
module ol_vamp_1_pplnjj_ew_nexeuuuxdx_3_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pplnjj_ew_nexeuuuxdx_3.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pplnjj_ew_nexeuuuxdx_3.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pplnjj_ew_nexeuuuxdx_3_/**/DREALKIND
  use ol_tensor_sum_storage_pplnjj_ew_nexeuuuxdx_3_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pplnjj_ew_nexeuuuxdx_3_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pplnjj_ew_nexeuuuxdx_3_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(4,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(74)*M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,8,2,1,4,16],[0,nMW,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,1),heltab2x64(:,:,1))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(1),n2h32(1))
  Gcoeff(:)%j = (c(79)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,8,2,1,4,16],[0,nMW,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZd,m3h2x32(:,2),heltab2x64(:,:,2))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(2),n2h32(2))
  Gcoeff(:)%j = (-(c(27)*M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,8,2,1,4,16],[0,0,0,nMW,0,nMW],6,0)
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,3),heltab2x64(:,:,3))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(3),n2h32(3))
  Gcoeff(:)%j = (c(28)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,8,2,1,4,16],[0,nMZ,0,nMW,0,nMW],6,0)
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,4),heltab2x64(:,:,4))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(4),n2h32(4))
  Gcoeff(:)%j = (c(94)*M(1,:)%j-c(93)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,8,2,1,4,16],[0,nMW,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,5),heltab2x64(:,:,5))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(5),n2h32(5))
  Gcoeff(:)%j = (-(c(72)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,4,1,2,8,16],[0,nMW,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,6),heltab2x64(:,:,6))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(6),n2h32(6))
  Gcoeff(:)%j = (c(78)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[32,4,1,2,8,16],[0,nMW,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZd,m3h2x32(:,7),heltab2x64(:,:,7))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(7),n2h32(7))
  Gcoeff(:)%j = (c(74)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[32,4,1,2,8,16],[0,nMW,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,8),heltab2x64(:,:,8))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(8),n2h32(8))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[32,4,1,2,8,16],[0,nMW,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZd,m3h2x32(:,9),heltab2x64(:,:,9))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(9),n2h32(9))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,4,1,2,8,16],[0,nMZ,0,nMW,0,nMW],6,0)
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,10),heltab2x64(:,:,10))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(10),n2h32(10))
  Gcoeff(:)%j = (-(c(90)*M(1,:)%j)+c(91)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[32,4,1,2,8,16],[0,nMW,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,11),heltab2x64(:,:,11))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(11),n2h32(11))
  Gcoeff(:)%j = (c(93)*M(1,:)%j-c(94)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[32,4,1,2,8,16],[0,nMW,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,12),heltab2x64(:,:,12))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(12),n2h32(12))
  Gcoeff(:)%j = (-(c(72)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[32,4,1,2,16,8],[0,nMW,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,13),heltab2x64(:,:,13))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(13),n2h32(13))
  Gcoeff(:)%j = (c(78)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[32,4,1,2,16,8],[0,nMW,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZd,m3h2x32(:,14),heltab2x64(:,:,14))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(14),n2h32(14))
  Gcoeff(:)%j = (c(74)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[32,4,1,2,16,8],[0,nMW,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,15),heltab2x64(:,:,15))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(15),n2h32(15))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[32,4,1,2,16,8],[0,nMW,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZd,m3h2x32(:,16),heltab2x64(:,:,16))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(16),n2h32(16))
  Gcoeff(:)%j = (-(c(90)*M(1,:)%j)+c(91)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[32,4,1,2,16,8],[0,nMW,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,17),heltab2x64(:,:,17))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(17),n2h32(17))
  Gcoeff(:)%j = (c(93)*M(1,:)%j-c(94)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[32,4,1,2,16,8],[0,nMW,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,18),heltab2x64(:,:,18))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(18),n2h32(18))
  Gcoeff(:)%j = (c(77)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[32,2,1,4,16,8],[nMW,0,nMZ,0,0,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,19),heltab2x64(:,:,19))
  Gcoeff(:)%j = (c(79)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[32,2,1,4,16,8],[nMW,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,20),heltab2x64(:,:,20))
  Gcoeff(:)%j = (c(24)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[32,2,1,4,16,8],[0,0,nMW,0,nMW,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,21),heltab2x64(:,:,21))
  Gcoeff(:)%j = (c(28)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[32,2,1,4,16,8],[nMZ,0,nMW,0,nMW,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(4),ngZd,m3h2x32(:,22),heltab2x64(:,:,22))
  Gcoeff(:)%j = (c(94)*M(1,:)%j-c(93)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[32,2,1,4,16,8],[nMW,0,nMZ,0,0,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,23),heltab2x64(:,:,23))
  Gcoeff(:)%j = (c(72)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[32,8,1,2,4,16],[0,nMW,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,24),heltab2x64(:,:,24))
  call Hloop_A_Q(ntryL,G0H32(6),32,0,G1H32(19),n2h32(19))
  Gcoeff(:)%j = (-(c(78)*M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[32,8,1,2,4,16],[0,nMW,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(6),ngZd,m3h2x32(:,25),heltab2x64(:,:,25))
  call Hloop_A_Q(ntryL,G0H32(6),32,0,G1H32(20),n2h32(20))
  Gcoeff(:)%j = (-(c(74)*M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[32,8,1,2,4,16],[0,nMW,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,26),heltab2x64(:,:,26))
  call Hloop_A_Q(ntryL,G0H32(6),32,0,G1H32(21),n2h32(21))
  Gcoeff(:)%j = (c(79)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[32,8,1,2,4,16],[0,nMW,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(6),ngZd,m3h2x32(:,27),heltab2x64(:,:,27))
  call Hloop_A_Q(ntryL,G0H32(6),32,0,G1H32(22),n2h32(22))
  Gcoeff(:)%j = (c(28)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[32,8,1,2,4,16],[0,nMZ,0,nMW,0,nMW],6,0)
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,28),heltab2x64(:,:,28))
  call Hloop_A_Q(ntryL,G0H32(6),32,0,G1H32(23),n2h32(23))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)+c(90)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[32,8,1,2,4,16],[0,nMW,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,29),heltab2x64(:,:,29))
  call Hloop_A_Q(ntryL,G0H32(6),32,0,G1H32(24),n2h32(24))
  Gcoeff(:)%j = (c(94)*M(1,:)%j-c(93)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[32,8,1,2,4,16],[0,nMW,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,30),heltab2x64(:,:,30))
  call Hloop_A_Q(ntryL,G0H32(6),32,0,G1H32(25),n2h32(25))
  Gcoeff(:)%j = (c(74)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[32,4,2,1,8,16],[0,nMW,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,31),heltab2x64(:,:,31))
  call Hloop_A_Q(ntryL,G0H32(6),32,0,G1H32(26),n2h32(26))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[32,4,2,1,8,16],[0,nMW,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(6),ngZd,m3h2x32(:,32),heltab2x64(:,:,32))
  call Hloop_A_Q(ntryL,G0H32(6),32,0,G1H32(27),n2h32(27))
  Gcoeff(:)%j = (c(27)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[32,4,2,1,8,16],[0,0,0,nMW,0,nMW],6,0)
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,33),heltab2x64(:,:,33))
  call Hloop_A_Q(ntryL,G0H32(6),32,0,G1H32(28),n2h32(28))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(34),h0tab(:,34),[32,4,2,1,8,16],[0,nMZ,0,nMW,0,nMW],6,0)
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,34),heltab2x64(:,:,34))
  call Hloop_A_Q(ntryL,G0H32(6),32,0,G1H32(29),n2h32(29))
  Gcoeff(:)%j = (c(93)*M(1,:)%j-c(94)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(35),h0tab(:,35),[32,4,2,1,8,16],[0,nMW,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,35),heltab2x64(:,:,35))
  call Hloop_A_Q(ntryL,G0H32(6),32,0,G1H32(30),n2h32(30))
  Gcoeff(:)%j = (c(72)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(36),h0tab(:,36),[32,4,16,2,1,8],[0,0,0,0,nMW,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,36),heltab2x64(:,:,36))
  Gcoeff(:)%j = (-(c(78)*M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(37),h0tab(:,37),[32,4,16,2,1,8],[nMZ,0,0,0,nMW,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(7),ngZd,m3h2x32(:,37),heltab2x64(:,:,37))
  Gcoeff(:)%j = (-(c(74)*M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(38),h0tab(:,38),[32,4,16,2,1,8],[0,0,nMZ,0,nMW,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,38),heltab2x64(:,:,38))
  Gcoeff(:)%j = (c(79)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(39),h0tab(:,39),[32,4,16,2,1,8],[nMZ,0,nMZ,0,nMW,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(9),ngZd,m3h2x32(:,39),heltab2x64(:,:,39))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)+c(90)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(40),h0tab(:,40),[32,4,16,2,1,8],[0,0,0,0,nMW,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,40),heltab2x64(:,:,40))
  Gcoeff(:)%j = (c(94)*M(1,:)%j-c(93)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(41),h0tab(:,41),[32,4,16,2,1,8],[0,0,nMZ,0,nMW,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(11),m3h2x32(:,41),heltab2x64(:,:,41))
  Gcoeff(:)%j = (-(c(77)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(42),h0tab(:,42),[32,2,1,8,16,4],[nMW,0,nMZ,0,0,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(12),m3h2x32(:,42),heltab2x64(:,:,42))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(43),h0tab(:,43),[32,2,1,8,16,4],[nMW,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(13),m3h2x32(:,43),heltab2x64(:,:,43))
  Gcoeff(:)%j = (-(c(24)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(44),h0tab(:,44),[32,2,1,8,16,4],[0,0,nMW,0,nMW,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(14),m3h2x32(:,44),heltab2x64(:,:,44))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(45),h0tab(:,45),[32,2,1,8,16,4],[nMZ,0,nMW,0,nMW,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(15),ngZd,m3h2x32(:,45),heltab2x64(:,:,45))
  Gcoeff(:)%j = (c(93)*M(1,:)%j-c(94)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(46),h0tab(:,46),[32,2,1,8,16,4],[nMW,0,nMZ,0,0,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(16),m3h2x32(:,46),heltab2x64(:,:,46))
  Gcoeff(:)%j = (c(74)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(47),h0tab(:,47),[32,4,2,1,16,8],[0,nMW,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,47),heltab2x64(:,:,47))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(31),n2h32(31))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(48),h0tab(:,48),[32,4,2,1,16,8],[0,nMW,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZd,m3h2x32(:,48),heltab2x64(:,:,48))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(32),n2h32(32))
  Gcoeff(:)%j = (c(93)*M(1,:)%j-c(94)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(49),h0tab(:,49),[32,4,2,1,16,8],[0,nMW,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,49),heltab2x64(:,:,49))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(33),n2h32(33))
  Gcoeff(:)%j = (-(c(74)*M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(50),h0tab(:,50),[32,4,16,1,2,8],[0,0,nMZ,0,nMW,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,50),heltab2x64(:,:,50))
  Gcoeff(:)%j = (c(79)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(51),h0tab(:,51),[32,4,16,1,2,8],[nMZ,0,nMZ,0,nMW,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(18),ngZd,m3h2x32(:,51),heltab2x64(:,:,51))
  Gcoeff(:)%j = (c(94)*M(1,:)%j-c(93)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(52),h0tab(:,52),[32,4,16,1,2,8],[0,0,nMZ,0,nMW,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(19),m3h2x32(:,52),heltab2x64(:,:,52))
  Gcoeff(:)%j = (c(77)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(53),h0tab(:,53),[32,2,1,16,4,8],[nMW,0,nMZ,0,0,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(20),m3h2x32(:,53),heltab2x64(:,:,53))
  Gcoeff(:)%j = (c(79)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(54),h0tab(:,54),[32,2,1,16,4,8],[nMW,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(21),m3h2x32(:,54),heltab2x64(:,:,54))
  Gcoeff(:)%j = (c(94)*M(1,:)%j-c(93)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(55),h0tab(:,55),[32,2,1,16,4,8],[nMW,0,nMZ,0,0,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(22),m3h2x32(:,55),heltab2x64(:,:,55))
  Gcoeff(:)%j = (-(c(77)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(56),h0tab(:,56),[32,2,1,16,8,4],[nMW,0,nMZ,0,0,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(23),m3h2x32(:,56),heltab2x64(:,:,56))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(57),h0tab(:,57),[32,2,1,16,8,4],[nMW,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(24),m3h2x32(:,57),heltab2x64(:,:,57))
  Gcoeff(:)%j = (c(93)*M(1,:)%j-c(94)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(58),h0tab(:,58),[32,2,1,16,8,4],[nMW,0,nMZ,0,0,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,58),heltab2x64(:,:,58))
  Gcoeff(:)%j = (-(c(75)*M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(59),h0tab(:,59),[32,1,2,4,16,8],[nMW,0,0,0,0,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(26),m3h2x32(:,59),heltab2x64(:,:,59))
  Gcoeff(:)%j = (-(c(78)*M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(60),h0tab(:,60),[32,1,2,4,16,8],[nMW,0,0,0,nMZ,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(27),m3h2x32(:,60),heltab2x64(:,:,60))
  Gcoeff(:)%j = (c(77)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(61),h0tab(:,61),[32,1,2,4,16,8],[nMW,0,nMZ,0,0,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(28),m3h2x32(:,61),heltab2x64(:,:,61))
  Gcoeff(:)%j = (c(79)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(62),h0tab(:,62),[32,1,2,4,16,8],[nMW,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(29),m3h2x32(:,62),heltab2x64(:,:,62))
  Gcoeff(:)%j = (c(28)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(63),h0tab(:,63),[32,1,2,4,16,8],[nMZ,0,nMW,0,nMW,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(30),ngZd,m3h2x32(:,63),heltab2x64(:,:,63))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)+c(90)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(64),h0tab(:,64),[32,1,2,4,16,8],[nMW,0,0,0,0,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(31),m3h2x32(:,64),heltab2x64(:,:,64))
  Gcoeff(:)%j = (c(94)*M(1,:)%j-c(93)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(65),h0tab(:,65),[32,1,2,4,16,8],[nMW,0,nMZ,0,0,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(32),m3h2x32(:,65),heltab2x64(:,:,65))
  Gcoeff(:)%j = (c(75)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(66),h0tab(:,66),[32,1,2,8,16,4],[nMW,0,0,0,0,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(33),m3h2x32(:,66),heltab2x64(:,:,66))
  Gcoeff(:)%j = (c(78)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(67),h0tab(:,67),[32,1,2,8,16,4],[nMW,0,0,0,nMZ,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(34),m3h2x32(:,67),heltab2x64(:,:,67))
  Gcoeff(:)%j = (-(c(77)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(68),h0tab(:,68),[32,1,2,8,16,4],[nMW,0,nMZ,0,0,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,68),heltab2x64(:,:,68))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(69),h0tab(:,69),[32,1,2,8,16,4],[nMW,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(36),m3h2x32(:,69),heltab2x64(:,:,69))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(70),h0tab(:,70),[32,1,2,8,16,4],[nMZ,0,nMW,0,nMW,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(37),ngZd,m3h2x32(:,70),heltab2x64(:,:,70))
  Gcoeff(:)%j = (-(c(90)*M(1,:)%j)+c(91)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(71),h0tab(:,71),[32,1,2,8,16,4],[nMW,0,0,0,0,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(38),m3h2x32(:,71),heltab2x64(:,:,71))
  Gcoeff(:)%j = (c(93)*M(1,:)%j-c(94)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(72),h0tab(:,72),[32,1,2,8,16,4],[nMW,0,nMZ,0,0,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(39),m3h2x32(:,72),heltab2x64(:,:,72))
  Gcoeff(:)%j = (-(c(75)*M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(73),h0tab(:,73),[32,1,2,16,4,8],[nMW,0,0,0,0,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(40),m3h2x32(:,73),heltab2x64(:,:,73))
  Gcoeff(:)%j = (-(c(78)*M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(74),h0tab(:,74),[32,1,2,16,4,8],[nMW,0,0,0,nMZ,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(41),m3h2x32(:,74),heltab2x64(:,:,74))
  Gcoeff(:)%j = (c(77)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(75),h0tab(:,75),[32,1,2,16,4,8],[nMW,0,nMZ,0,0,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(42),m3h2x32(:,75),heltab2x64(:,:,75))
  Gcoeff(:)%j = (c(79)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(76),h0tab(:,76),[32,1,2,16,4,8],[nMW,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(43),m3h2x32(:,76),heltab2x64(:,:,76))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)+c(90)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(77),h0tab(:,77),[32,1,2,16,4,8],[nMW,0,0,0,0,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(44),m3h2x32(:,77),heltab2x64(:,:,77))
  Gcoeff(:)%j = (c(94)*M(1,:)%j-c(93)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(78),h0tab(:,78),[32,1,2,16,4,8],[nMW,0,nMZ,0,0,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(45),m3h2x32(:,78),heltab2x64(:,:,78))
  Gcoeff(:)%j = (c(75)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(79),h0tab(:,79),[32,1,2,16,8,4],[nMW,0,0,0,0,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(46),m3h2x32(:,79),heltab2x64(:,:,79))
  Gcoeff(:)%j = (c(78)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(80),h0tab(:,80),[32,1,2,16,8,4],[nMW,0,0,0,nMZ,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(47),m3h2x32(:,80),heltab2x64(:,:,80))
  Gcoeff(:)%j = (-(c(77)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(81),h0tab(:,81),[32,1,2,16,8,4],[nMW,0,nMZ,0,0,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(48),m3h2x32(:,81),heltab2x64(:,:,81))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(82),h0tab(:,82),[32,1,2,16,8,4],[nMW,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(49),m3h2x32(:,82),heltab2x64(:,:,82))
  Gcoeff(:)%j = (-(c(90)*M(1,:)%j)+c(91)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(83),h0tab(:,83),[32,1,2,16,8,4],[nMW,0,0,0,0,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(50),m3h2x32(:,83),heltab2x64(:,:,83))
  Gcoeff(:)%j = (c(93)*M(1,:)%j-c(94)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(84),h0tab(:,84),[32,1,2,16,8,4],[nMW,0,nMZ,0,0,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(51),m3h2x32(:,84),heltab2x64(:,:,84))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(5),[G1H32(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(11),[G1H32(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(12),[G1H32(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(17),[G1H32(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(18),[G1H32(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(5),[G0H32(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(24),[G1H32(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(25),[G1H32(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(30),[G1H32(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(10),[G0H32(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(11),[G0H32(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(16),[G0H32(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(33),[G1H32(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(19),[G0H32(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(22),[G0H32(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(25),[G0H32(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(31),[G0H32(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(32),[G0H32(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(38),[G0H32(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(39),[G0H32(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(44),[G0H32(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(45),[G0H32(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(50),[G0H32(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(51),[G0H32(48)])
  call Hloop_AQ_W(ntryL,G1H32(5),ex4(:),G1H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_AQ_W(ntryL,G1H32(2),ex4(:),G1H16(2),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_AQ_V(ntryL,G1H32(3),ex4(:),G1H16(3),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_AQ_Z(ntryL,G1H32(4),ex4(:),G1H16(4),ngZu,m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_AQ_W(ntryL,G1H32(11),ex3(:),G1H16(5),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_AQ_W(ntryL,G1H32(7),ex3(:),G1H16(6),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_AQ_W(ntryL,G1H32(12),ex3(:),G1H16(7),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_AQ_W(ntryL,G1H32(9),ex3(:),G1H16(8),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_AQ_Z(ntryL,G1H32(10),ex3(:),G1H16(9),ngZu,m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_AQ_W(ntryL,G1H32(17),ex3(:),G1H16(10),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_AQ_W(ntryL,G1H32(14),ex3(:),G1H16(11),m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_AQ_W(ntryL,G1H32(18),ex3(:),G1H16(12),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_AQ_W(ntryL,G1H32(16),ex3(:),G1H16(13),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_WQ_A(ntryL,G0H32(5),ex2(:),G0H16(1),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(14),n2h16(1))
  call Hloop_WQ_A(ntryL,G0H32(2),ex2(:),G0H16(1),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(15),n2h16(2))
  call Hloop_VQ_A(ntryL,G0H32(3),ex2(:),G0H16(1),m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(16),n2h16(3))
  call Hloop_ZQ_A(ntryL,G0H32(4),ex2(:),G0H16(1),ngZl,m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(17),n2h16(4))
  call Hloop_AQ_W(ntryL,G1H32(24),ex4(:),G1H16(18),m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_AQ_W(ntryL,G1H32(20),ex4(:),G1H16(19),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_AQ_W(ntryL,G1H32(25),ex4(:),G1H16(20),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_AQ_W(ntryL,G1H32(22),ex4(:),G1H16(21),m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_AQ_Z(ntryL,G1H32(23),ex4(:),G1H16(22),ngZu,m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_AQ_W(ntryL,G1H32(30),ex3(:),G1H16(23),m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_AQ_W(ntryL,G1H32(27),ex3(:),G1H16(24),m3h2x16(:,24),heltab2x32(:,:,24))
  call Hloop_AQ_V(ntryL,G1H32(28),ex3(:),G1H16(25),m3h2x16(:,25),heltab2x32(:,:,25))
  call Hloop_AQ_Z(ntryL,G1H32(29),ex3(:),G1H16(26),ngZu,m3h2x16(:,26),heltab2x32(:,:,26))
  call Hloop_VQ_A(ntryL,G0H32(10),ex3(:),G0H16(1),m3h2x16(:,27),heltab2x32(:,:,27))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(27),n2h16(5))
  call Hloop_ZQ_A(ntryL,G0H32(7),ex3(:),G0H16(1),ngZu,m3h2x16(:,28),heltab2x32(:,:,28))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(28),n2h16(6))
  call Hloop_VQ_A(ntryL,G0H32(11),ex3(:),G0H16(1),m3h2x16(:,29),heltab2x32(:,:,29))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(29),n2h16(7))
  call Hloop_ZQ_A(ntryL,G0H32(9),ex3(:),G0H16(1),ngZu,m3h2x16(:,30),heltab2x32(:,:,30))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(30),n2h16(8))
  call Hloop_WQ_A(ntryL,G0H32(16),ex2(:),G0H16(1),m3h2x16(:,31),heltab2x32(:,:,31))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(31),n2h16(9))
  call Hloop_WQ_A(ntryL,G0H32(13),ex2(:),G0H16(1),m3h2x16(:,32),heltab2x32(:,:,32))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(32),n2h16(10))
  call Hloop_VQ_A(ntryL,G0H32(14),ex2(:),G0H16(1),m3h2x16(:,33),heltab2x32(:,:,33))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(33),n2h16(11))
  call Hloop_ZQ_A(ntryL,G0H32(15),ex2(:),G0H16(1),ngZl,m3h2x16(:,34),heltab2x32(:,:,34))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(34),n2h16(12))
  call Hloop_AQ_W(ntryL,G1H32(33),ex3(:),G1H16(35),m3h2x16(:,35),heltab2x32(:,:,35))
  call Hloop_AQ_W(ntryL,G1H32(32),ex3(:),G1H16(36),m3h2x16(:,36),heltab2x32(:,:,36))
  call Hloop_VQ_A(ntryL,G0H32(19),ex3(:),G0H16(1),m3h2x16(:,37),heltab2x32(:,:,37))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(37),n2h16(13))
  call Hloop_ZQ_A(ntryL,G0H32(18),ex3(:),G0H16(1),ngZu,m3h2x16(:,38),heltab2x32(:,:,38))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(38),n2h16(14))
  call Hloop_WQ_A(ntryL,G0H32(22),ex2(:),G0H16(1),m3h2x16(:,39),heltab2x32(:,:,39))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(39),n2h16(15))
  call Hloop_WQ_A(ntryL,G0H32(21),ex2(:),G0H16(1),m3h2x16(:,40),heltab2x32(:,:,40))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(40),n2h16(16))
  call Hloop_WQ_A(ntryL,G0H32(25),ex2(:),G0H16(1),m3h2x16(:,41),heltab2x32(:,:,41))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(41),n2h16(17))
  call Hloop_WQ_A(ntryL,G0H32(24),ex2(:),G0H16(1),m3h2x16(:,42),heltab2x32(:,:,42))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(42),n2h16(18))
  call Hloop_WA_Q(ntryL,G0H32(31),ex1(:),G0H16(1),m3h2x16(:,43),heltab2x32(:,:,43))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(43),n2h16(19))
  call Hloop_WA_Q(ntryL,G0H32(27),ex1(:),G0H16(1),m3h2x16(:,44),heltab2x32(:,:,44))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(44),n2h16(20))
  call Hloop_WA_Q(ntryL,G0H32(32),ex1(:),G0H16(1),m3h2x16(:,45),heltab2x32(:,:,45))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(45),n2h16(21))
  call Hloop_WA_Q(ntryL,G0H32(29),ex1(:),G0H16(1),m3h2x16(:,46),heltab2x32(:,:,46))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(46),n2h16(22))
  call Hloop_ZA_Q(ntryL,G0H32(30),ex1(:),G0H16(1),ngZn,m3h2x16(:,47),heltab2x32(:,:,47))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(47),n2h16(23))
  call Hloop_WA_Q(ntryL,G0H32(38),ex1(:),G0H16(1),m3h2x16(:,48),heltab2x32(:,:,48))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(48),n2h16(24))
  call Hloop_WA_Q(ntryL,G0H32(34),ex1(:),G0H16(1),m3h2x16(:,49),heltab2x32(:,:,49))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(49),n2h16(25))
  call Hloop_WA_Q(ntryL,G0H32(39),ex1(:),G0H16(1),m3h2x16(:,50),heltab2x32(:,:,50))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(50),n2h16(26))
  call Hloop_WA_Q(ntryL,G0H32(36),ex1(:),G0H16(1),m3h2x16(:,51),heltab2x32(:,:,51))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(51),n2h16(27))
  call Hloop_ZA_Q(ntryL,G0H32(37),ex1(:),G0H16(1),ngZn,m3h2x16(:,52),heltab2x32(:,:,52))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(52),n2h16(28))
  call Hloop_WA_Q(ntryL,G0H32(44),ex1(:),G0H16(1),m3h2x16(:,53),heltab2x32(:,:,53))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(53),n2h16(29))
  call Hloop_WA_Q(ntryL,G0H32(41),ex1(:),G0H16(1),m3h2x16(:,54),heltab2x32(:,:,54))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(54),n2h16(30))
  call Hloop_WA_Q(ntryL,G0H32(45),ex1(:),G0H16(1),m3h2x16(:,55),heltab2x32(:,:,55))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(55),n2h16(31))
  call Hloop_WA_Q(ntryL,G0H32(43),ex1(:),G0H16(1),m3h2x16(:,56),heltab2x32(:,:,56))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(56),n2h16(32))
  call Hloop_WA_Q(ntryL,G0H32(50),ex1(:),G0H16(1),m3h2x16(:,57),heltab2x32(:,:,57))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(57),n2h16(33))
  call Hloop_WA_Q(ntryL,G0H32(47),ex1(:),G0H16(1),m3h2x16(:,58),heltab2x32(:,:,58))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(58),n2h16(34))
  call Hloop_WA_Q(ntryL,G0H32(51),ex1(:),G0H16(1),m3h2x16(:,59),heltab2x32(:,:,59))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(59),n2h16(35))
  call Hloop_WA_Q(ntryL,G0H32(49),ex1(:),G0H16(1),m3h2x16(:,60),heltab2x32(:,:,60))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(60),n2h16(36))
  call Hloop_WQ_A(ntryL,G1H16(1),ex2(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_Q_A(ntryL,G1H8(1),42,0,G2H8(1),n2h8(1))
  call Hloop_WQ_A(ntryL,G1H16(2),ex2(:),G1H8(1),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_Q_A(ntryL,G1H8(1),42,0,G2H8(2),n2h8(2))
  call Hloop_VQ_A(ntryL,G1H16(3),ex2(:),G1H8(1),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_Q_A(ntryL,G1H8(1),42,0,G2H8(3),n2h8(3))
  call Hloop_ZQ_A(ntryL,G1H16(4),ex2(:),G1H8(1),ngZl,m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_Q_A(ntryL,G1H8(1),42,0,G2H8(4),n2h8(4))
  call Hloop_WA_Q(ntryL,G1H16(5),ex1(:),G1H8(1),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_A_Q(ntryL,G1H8(1),37,0,G2H8(5),n2h8(5))
  call Hloop_WA_Q(ntryL,G1H16(6),ex1(:),G1H8(1),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_A_Q(ntryL,G1H8(1),37,0,G2H8(6),n2h8(6))
  call Hloop_WA_Q(ntryL,G1H16(7),ex1(:),G1H8(1),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_A_Q(ntryL,G1H8(1),37,0,G2H8(7),n2h8(7))
  call Hloop_WA_Q(ntryL,G1H16(8),ex1(:),G1H8(1),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_A_Q(ntryL,G1H8(1),37,0,G2H8(8),n2h8(8))
  call Hloop_ZA_Q(ntryL,G1H16(9),ex1(:),G1H8(1),ngZn,m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_A_Q(ntryL,G1H8(1),37,0,G2H8(9),n2h8(9))
  call Hloop_WA_Q(ntryL,G1H16(10),ex1(:),G1H8(1),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_A_Q(ntryL,G1H8(1),37,0,G2H8(10),n2h8(10))
  call Hloop_WA_Q(ntryL,G1H16(11),ex1(:),G1H8(1),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_A_Q(ntryL,G1H8(1),37,0,G2H8(11),n2h8(11))
  call Hloop_WA_Q(ntryL,G1H16(12),ex1(:),G1H8(1),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_A_Q(ntryL,G1H8(1),37,0,G2H8(12),n2h8(12))
  call Hloop_WA_Q(ntryL,G1H16(13),ex1(:),G1H8(1),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_A_Q(ntryL,G1H8(1),37,0,G2H8(13),n2h8(13))
  call Hloop_QA_Z(ntryL,G1H16(14),ex1(:),G1H8(1),ngZn,m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_QA_Z(ntryL,G1H16(15),ex1(:),G1H8(2),ngZn,m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_QA_W(ntryL,G1H16(16),ex1(:),G1H8(3),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_QA_W(ntryL,G1H16(17),ex1(:),G1H8(4),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_WA_Q(ntryL,G1H16(18),ex1(:),G1H8(5),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_A_Q(ntryL,G1H8(5),41,0,G2H8(14),n2h8(14))
  call Hloop_WA_Q(ntryL,G1H16(19),ex1(:),G1H8(5),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_A_Q(ntryL,G1H8(5),41,0,G2H8(15),n2h8(15))
  call Hloop_WA_Q(ntryL,G1H16(20),ex1(:),G1H8(5),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_A_Q(ntryL,G1H8(5),41,0,G2H8(16),n2h8(16))
  call Hloop_WA_Q(ntryL,G1H16(21),ex1(:),G1H8(5),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_A_Q(ntryL,G1H8(5),41,0,G2H8(17),n2h8(17))
  call Hloop_ZA_Q(ntryL,G1H16(22),ex1(:),G1H8(5),ngZn,m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_A_Q(ntryL,G1H8(5),41,0,G2H8(18),n2h8(18))
  call Hloop_WQ_A(ntryL,G1H16(23),ex2(:),G1H8(5),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_Q_A(ntryL,G1H8(5),38,0,G2H8(19),n2h8(19))
  call Hloop_WQ_A(ntryL,G1H16(24),ex2(:),G1H8(5),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_Q_A(ntryL,G1H8(5),38,0,G2H8(20),n2h8(20))
  call Hloop_VQ_A(ntryL,G1H16(25),ex2(:),G1H8(5),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_Q_A(ntryL,G1H8(5),38,0,G2H8(21),n2h8(21))
  call Hloop_ZQ_A(ntryL,G1H16(26),ex2(:),G1H8(5),ngZl,m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_Q_A(ntryL,G1H8(5),38,0,G2H8(22),n2h8(22))
  call Hloop_QA_V(ntryL,G1H16(27),ex5(:),G1H8(5),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_QA_V(ntryL,G1H16(28),ex5(:),G1H8(6),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_QA_Z(ntryL,G1H16(29),ex5(:),G1H8(7),ngZu,m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_QA_Z(ntryL,G1H16(30),ex5(:),G1H8(8),ngZu,m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_QA_Z(ntryL,G1H16(31),ex1(:),G1H8(9),ngZn,m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_QA_Z(ntryL,G1H16(32),ex1(:),G1H8(10),ngZn,m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_QA_W(ntryL,G1H16(33),ex1(:),G1H8(11),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_QA_W(ntryL,G1H16(34),ex1(:),G1H8(12),m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_WQ_A(ntryL,G1H16(35),ex2(:),G1H8(13),m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_Q_A(ntryL,G1H8(13),38,0,G2H8(23),n2h8(23))
  call Hloop_WQ_A(ntryL,G1H16(36),ex2(:),G1H8(13),m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_Q_A(ntryL,G1H8(13),38,0,G2H8(24),n2h8(24))
  call Hloop_QA_Z(ntryL,G1H16(37),ex5(:),G1H8(13),ngZu,m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_QA_Z(ntryL,G1H16(38),ex5(:),G1H8(14),ngZu,m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_QA_Z(ntryL,G1H16(39),ex1(:),G1H8(15),ngZn,m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_QA_Z(ntryL,G1H16(40),ex1(:),G1H8(16),ngZn,m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_QA_Z(ntryL,G1H16(41),ex1(:),G1H8(17),ngZn,m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_QA_Z(ntryL,G1H16(42),ex1(:),G1H8(18),ngZn,m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_AQ_V(ntryL,G1H16(43),ex2(:),G1H8(19),m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_AQ_V(ntryL,G1H16(44),ex2(:),G1H8(20),m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_AQ_Z(ntryL,G1H16(45),ex2(:),G1H8(21),ngZl,m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_AQ_Z(ntryL,G1H16(46),ex2(:),G1H8(22),ngZl,m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_AQ_W(ntryL,G1H16(47),ex2(:),G1H8(23),m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_AQ_V(ntryL,G1H16(48),ex2(:),G1H8(24),m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_AQ_V(ntryL,G1H16(49),ex2(:),G1H8(25),m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_AQ_Z(ntryL,G1H16(50),ex2(:),G1H8(26),ngZl,m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_AQ_Z(ntryL,G1H16(51),ex2(:),G1H8(27),ngZl,m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_AQ_W(ntryL,G1H16(52),ex2(:),G1H8(28),m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_AQ_V(ntryL,G1H16(53),ex2(:),G1H8(29),m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_AQ_V(ntryL,G1H16(54),ex2(:),G1H8(30),m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_AQ_Z(ntryL,G1H16(55),ex2(:),G1H8(31),ngZl,m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_AQ_Z(ntryL,G1H16(56),ex2(:),G1H8(32),ngZl,m3h2x8(:,56),heltab2x16(:,:,56))
  call Hloop_AQ_V(ntryL,G1H16(57),ex2(:),G1H8(33),m3h2x8(:,57),heltab2x16(:,:,57))
  call Hloop_AQ_V(ntryL,G1H16(58),ex2(:),G1H8(34),m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_AQ_Z(ntryL,G1H16(59),ex2(:),G1H8(35),ngZl,m3h2x8(:,59),heltab2x16(:,:,59))
  call Hloop_AQ_Z(ntryL,G1H16(60),ex2(:),G1H8(36),ngZl,m3h2x8(:,60),heltab2x16(:,:,60))
  call Hloop_QA_Z(ntryL,G2H8(1),ex1(:),G2H4(1),ngZn,m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_QA_Z(ntryL,G2H8(2),ex1(:),G2H4(2),ngZn,m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_QA_W(ntryL,G2H8(3),ex1(:),G2H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_QA_W(ntryL,G2H8(4),ex1(:),G2H4(4),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_AQ_V(ntryL,G2H8(5),ex2(:),G2H4(5),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_AQ_V(ntryL,G2H8(6),ex2(:),G2H4(6),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_AQ_Z(ntryL,G2H8(7),ex2(:),G2H4(7),ngZl,m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_AQ_Z(ntryL,G2H8(8),ex2(:),G2H4(8),ngZl,m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_AQ_W(ntryL,G2H8(9),ex2(:),G2H4(9),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_AQ_V(ntryL,G2H8(10),ex2(:),G2H4(10),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_AQ_V(ntryL,G2H8(11),ex2(:),G2H4(11),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_AQ_Z(ntryL,G2H8(12),ex2(:),G2H4(12),ngZl,m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_AQ_Z(ntryL,G2H8(13),ex2(:),G2H4(13),ngZl,m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_ZQ_A(ntryL,G1H8(1),ex3(:),G1H4(1),ngZu,m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(14),n2h4(1))
  call Hloop_ZQ_A(ntryL,G1H8(2),ex3(:),G1H4(1),ngZu,m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(15),n2h4(2))
  call Hloop_WQ_A(ntryL,G1H8(3),ex3(:),G1H4(1),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(16),n2h4(3))
  call Hloop_WQ_A(ntryL,G1H8(4),ex3(:),G1H4(1),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(17),n2h4(4))
  call Hloop_AQ_V(ntryL,G2H8(14),ex2(:),G2H4(18),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_AQ_V(ntryL,G2H8(15),ex2(:),G2H4(19),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_AQ_Z(ntryL,G2H8(16),ex2(:),G2H4(20),ngZl,m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_AQ_Z(ntryL,G2H8(17),ex2(:),G2H4(21),ngZl,m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_AQ_W(ntryL,G2H8(18),ex2(:),G2H4(22),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_QA_Z(ntryL,G2H8(19),ex1(:),G2H4(23),ngZn,m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_QA_Z(ntryL,G2H8(20),ex1(:),G2H4(24),ngZn,m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_QA_W(ntryL,G2H8(21),ex1(:),G2H4(25),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_QA_W(ntryL,G2H8(22),ex1(:),G2H4(26),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_VQ_A(ntryL,G1H8(5),ex2(:),G1H4(1),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_Q_A(ntryL,G1H4(1),54,0,G2H4(27),n2h4(5))
  call Hloop_VQ_A(ntryL,G1H8(6),ex2(:),G1H4(1),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_Q_A(ntryL,G1H4(1),54,0,G2H4(28),n2h4(6))
  call Hloop_ZQ_A(ntryL,G1H8(7),ex2(:),G1H4(1),ngZl,m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_Q_A(ntryL,G1H4(1),54,0,G2H4(29),n2h4(7))
  call Hloop_ZQ_A(ntryL,G1H8(8),ex2(:),G1H4(1),ngZl,m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_Q_A(ntryL,G1H4(1),54,0,G2H4(30),n2h4(8))
  call Hloop_ZQ_A(ntryL,G1H8(9),ex4(:),G1H4(1),ngZu,m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(31),n2h4(9))
  call Hloop_ZQ_A(ntryL,G1H8(10),ex4(:),G1H4(1),ngZu,m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(32),n2h4(10))
  call Hloop_WQ_A(ntryL,G1H8(11),ex4(:),G1H4(1),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(33),n2h4(11))
  call Hloop_WQ_A(ntryL,G1H8(12),ex4(:),G1H4(1),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(34),n2h4(12))
  call Hloop_QA_Z(ntryL,G2H8(23),ex1(:),G2H4(35),ngZn,m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_QA_Z(ntryL,G2H8(24),ex1(:),G2H4(36),ngZn,m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_ZA_Q(ntryL,G1H8(13),ex1(:),G1H4(1),ngZn,m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_A_Q(ntryL,G1H4(1),53,0,G2H4(37),n2h4(13))
  call Hloop_ZA_Q(ntryL,G1H8(14),ex1(:),G1H4(1),ngZn,m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_A_Q(ntryL,G1H4(1),53,0,G2H4(38),n2h4(14))
  call Hloop_ZA_Q(ntryL,G1H8(15),ex5(:),G1H4(1),ngZu,m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(39),n2h4(15))
  call Hloop_ZA_Q(ntryL,G1H8(16),ex5(:),G1H4(1),ngZu,m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(40),n2h4(16))
  call Hloop_ZA_Q(ntryL,G1H8(17),ex5(:),G1H4(1),ngZu,m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(41),n2h4(17))
  call Hloop_ZA_Q(ntryL,G1H8(18),ex5(:),G1H4(1),ngZu,m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(42),n2h4(18))
  call Hloop_VQ_A(ntryL,G1H8(19),ex3(:),G1H4(1),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(43),n2h4(19))
  call Hloop_VQ_A(ntryL,G1H8(20),ex3(:),G1H4(1),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(44),n2h4(20))
  call Hloop_ZQ_A(ntryL,G1H8(21),ex3(:),G1H4(1),ngZu,m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(45),n2h4(21))
  call Hloop_ZQ_A(ntryL,G1H8(22),ex3(:),G1H4(1),ngZu,m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(46),n2h4(22))
  call Hloop_WQ_A(ntryL,G1H8(23),ex3(:),G1H4(1),m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(47),n2h4(23))
  call Hloop_VQ_A(ntryL,G1H8(24),ex4(:),G1H4(1),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(48),n2h4(24))
  call Hloop_VQ_A(ntryL,G1H8(25),ex4(:),G1H4(1),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(49),n2h4(25))
  call Hloop_ZQ_A(ntryL,G1H8(26),ex4(:),G1H4(1),ngZu,m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(50),n2h4(26))
  call Hloop_ZQ_A(ntryL,G1H8(27),ex4(:),G1H4(1),ngZu,m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(51),n2h4(27))
  call Hloop_WQ_A(ntryL,G1H8(28),ex4(:),G1H4(1),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(52),n2h4(28))
  call Hloop_VA_Q(ntryL,G1H8(29),ex5(:),G1H4(1),m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(53),n2h4(29))
  call Hloop_VA_Q(ntryL,G1H8(30),ex5(:),G1H4(1),m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(54),n2h4(30))
  call Hloop_ZA_Q(ntryL,G1H8(31),ex5(:),G1H4(1),ngZu,m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(55),n2h4(31))
  call Hloop_ZA_Q(ntryL,G1H8(32),ex5(:),G1H4(1),ngZu,m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(56),n2h4(32))
  call Hloop_VA_Q(ntryL,G1H8(33),ex5(:),G1H4(1),m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(57),n2h4(33))
  call Hloop_VA_Q(ntryL,G1H8(34),ex5(:),G1H4(1),m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(58),n2h4(34))
  call Hloop_ZA_Q(ntryL,G1H8(35),ex5(:),G1H4(1),ngZu,m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(59),n2h4(35))
  call Hloop_ZA_Q(ntryL,G1H8(36),ex5(:),G1H4(1),ngZu,m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(60),n2h4(36))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),16,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(1),mass5set(:,2),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(8),16,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(1),mass5set(:,3),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(14),16,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(1),mass5set(:,4),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
  call HG1shiftOLR(G1H4(20),16,4)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(2),mass5set(:,5),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
  call HG1shiftOLR(G1H4(26),16,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(2),mass5set(:,6),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
  call HG1shiftOLR(G1H4(32),16,4)
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(2),mass5set(:,1),  & 
G1H4(37),G1H4(38),G1H4(39),G1H4(40),G1H4(41),G1H4(42),4)
  call HG1shiftOLR(G1H4(38),16,4)
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(2),mass5set(:,2),  & 
G1H4(43),G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
  call HG1shiftOLR(G1H4(44),16,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(2),mass5set(:,4),  & 
G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),G1H4(54),4)
  call HG1shiftOLR(G1H4(50),16,4)
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(2),mass5set(:,5),  & 
G1H4(55),G1H4(56),G1H4(57),G1H4(58),G1H4(59),G1H4(60),4)
  call HG1shiftOLR(G1H4(56),8,4)
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(2),mass5set(:,6),  & 
G1H4(61),G1H4(62),G1H4(63),G1H4(64),G1H4(65),G1H4(66),4)
  call HG1shiftOLR(G1H4(62),8,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(2),mass5set(:,1),  & 
G1H4(67),G1H4(68),G1H4(69),G1H4(70),G1H4(71),G1H4(72),4)
  call HG1shiftOLR(G1H4(68),8,4)
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(2),mass5set(:,2),  & 
G1H4(73),G1H4(74),G1H4(75),G1H4(76),G1H4(77),G1H4(78),4)
  call HG1shiftOLR(G1H4(74),8,4)
  call Hloop_QA_V(ntryL,G2H4(14),ex5(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_Z(ntryL,G2H4(15),ex5(:),G2H2(2),ngZu,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_W(ntryL,G2H4(16),ex5(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_W(ntryL,G2H4(17),ex5(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hotf_5pt_reduction(G2H4(18),RedSet_5(3),mass5set(:,5),  & 
G1H4(79),G1H4(80),G1H4(81),G1H4(82),G1H4(83),G1H4(84),4)
  call HG1shiftOLR(G1H4(80),16,4)
  call Hotf_5pt_reduction(G2H4(19),RedSet_5(3),mass5set(:,6),  & 
G1H4(85),G1H4(86),G1H4(87),G1H4(88),G1H4(89),G1H4(90),4)
  call HG1shiftOLR(G1H4(86),16,4)
  call Hotf_5pt_reduction(G2H4(20),RedSet_5(3),mass5set(:,1),  & 
G1H4(91),G1H4(92),G1H4(93),G1H4(94),G1H4(95),G1H4(96),4)
  call HG1shiftOLR(G1H4(92),16,4)
  call Hotf_5pt_reduction(G2H4(21),RedSet_5(3),mass5set(:,2),  & 
G1H4(97),G1H4(98),G1H4(99),G1H4(100),G1H4(101),G1H4(102),4)
  call HG1shiftOLR(G1H4(98),16,4)
  call Hotf_5pt_reduction(G2H4(22),RedSet_5(3),mass5set(:,4),  & 
G1H4(103),G1H4(104),G1H4(105),G1H4(106),G1H4(107),G1H4(108),4)
  call HG1shiftOLR(G1H4(104),16,4)
  call Hotf_5pt_reduction(G2H4(23),RedSet_5(4),mass5set(:,1),  & 
G1H4(109),G1H4(110),G1H4(111),G1H4(112),G1H4(113),G1H4(114),4)
  call HG1shiftOLR(G1H4(110),16,4)
  call Hotf_5pt_reduction(G2H4(24),RedSet_5(4),mass5set(:,2),  & 
G1H4(115),G1H4(116),G1H4(117),G1H4(118),G1H4(119),G1H4(120),4)
  call HG1shiftOLR(G1H4(116),16,4)
  call Hotf_5pt_reduction(G2H4(25),RedSet_5(4),mass5set(:,3),  & 
G1H4(121),G1H4(122),G1H4(123),G1H4(124),G1H4(125),G1H4(126),4)
  call HG1shiftOLR(G1H4(122),16,4)
  call Hotf_5pt_reduction(G2H4(26),RedSet_5(4),mass5set(:,4),  & 
G1H4(127),G1H4(128),G1H4(129),G1H4(130),G1H4(131),G1H4(132),4)
  call HG1shiftOLR(G1H4(128),16,4)
  call Hloop_QA_W(ntryL,G2H4(27),ex1(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QA_W(ntryL,G2H4(28),ex1(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_QA_W(ntryL,G2H4(29),ex1(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_QA_W(ntryL,G2H4(30),ex1(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_QA_V(ntryL,G2H4(31),ex5(:),G2H2(9),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_QA_Z(ntryL,G2H4(32),ex5(:),G2H2(10),ngZu,m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_QA_W(ntryL,G2H4(33),ex5(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_QA_W(ntryL,G2H4(34),ex5(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hotf_5pt_reduction(G2H4(35),RedSet_5(4),mass5set(:,1),  & 
G1H4(133),G1H4(134),G1H4(135),G1H4(136),G1H4(137),G1H4(138),4)
  call HG1shiftOLR(G1H4(134),8,4)
  call Hotf_5pt_reduction(G2H4(36),RedSet_5(4),mass5set(:,2),  & 
G1H4(139),G1H4(140),G1H4(141),G1H4(142),G1H4(143),G1H4(144),4)
  call HG1shiftOLR(G1H4(140),8,4)
  call Hloop_AQ_W(ntryL,G2H4(37),ex2(:),G2H2(13),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_AQ_W(ntryL,G2H4(38),ex2(:),G2H2(14),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_AQ_V(ntryL,G2H4(39),ex3(:),G2H2(15),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_AQ_Z(ntryL,G2H4(40),ex3(:),G2H2(16),ngZu,m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_AQ_V(ntryL,G2H4(41),ex4(:),G2H2(17),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_AQ_Z(ntryL,G2H4(42),ex4(:),G2H2(18),ngZu,m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_QA_V(ntryL,G2H4(43),ex5(:),G2H2(19),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_QA_Z(ntryL,G2H4(44),ex5(:),G2H2(20),ngZu,m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_QA_V(ntryL,G2H4(45),ex5(:),G2H2(21),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_QA_Z(ntryL,G2H4(46),ex5(:),G2H2(22),ngZu,m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_QA_W(ntryL,G2H4(47),ex5(:),G2H2(23),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_QA_V(ntryL,G2H4(48),ex5(:),G2H2(24),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_QA_Z(ntryL,G2H4(49),ex5(:),G2H2(25),ngZu,m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_QA_V(ntryL,G2H4(50),ex5(:),G2H2(26),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_QA_Z(ntryL,G2H4(51),ex5(:),G2H2(27),ngZu,m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_QA_W(ntryL,G2H4(52),ex5(:),G2H2(28),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_AQ_V(ntryL,G2H4(53),ex3(:),G2H2(29),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_AQ_Z(ntryL,G2H4(54),ex3(:),G2H2(30),ngZu,m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_AQ_V(ntryL,G2H4(55),ex3(:),G2H2(31),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_AQ_Z(ntryL,G2H4(56),ex3(:),G2H2(32),ngZu,m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_AQ_V(ntryL,G2H4(57),ex4(:),G2H2(33),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_AQ_Z(ntryL,G2H4(58),ex4(:),G2H2(34),ngZu,m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_AQ_V(ntryL,G2H4(59),ex4(:),G2H2(35),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_AQ_Z(ntryL,G2H4(60),ex4(:),G2H2(36),ngZu,m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_ZQ_A(ntryL,G1H4(1),ex3(:),G1H2(1),ngZu,m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(37),n2h2(1))
call HGT_raise_alpha_OLR(G1H4(2),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(2),ex5(:),G1H2(1),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_ZQ_A(ntryL,G1H4(6),ex3(:),G1H2(2),ngZu,m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_Q_A(ntryL,G1H2(2),47,0,G2H2(38),n2h2(2))
  call Hloop_ZQ_A(ntryL,G1H4(7),ex3(:),G1H2(2),ngZu,m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_Q_A(ntryL,G1H2(2),47,0,G2H2(39),n2h2(3))
call HGT_raise_alpha_OLR(G1H4(8),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(8),ex5(:),G1H2(2),ngZu,m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_ZQ_A(ntryL,G1H4(12),ex3(:),G1H2(3),ngZu,m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_Q_A(ntryL,G1H2(3),47,0,G2H2(40),n2h2(4))
  call Hloop_WQ_A(ntryL,G1H4(13),ex3(:),G1H2(3),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(3),47,0,G2H2(41),n2h2(5))
call HGT_raise_alpha_OLR(G1H4(14),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(14),ex5(:),G1H2(3),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_WQ_A(ntryL,G1H4(18),ex3(:),G1H2(4),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(4),47,0,G2H2(42),n2h2(6))
  call Hloop_WQ_A(ntryL,G1H4(19),ex3(:),G1H2(4),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_Q_A(ntryL,G1H2(4),47,0,G2H2(43),n2h2(7))
call HGT_raise_alpha_OLR(G1H4(20),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(20),ex5(:),G1H2(4),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_WQ_A(ntryL,G1H4(24),ex3(:),G1H2(5),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(5),47,0,G2H2(44),n2h2(8))
  call Hloop_VQ_A(ntryL,G1H4(25),ex4(:),G1H2(5),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_Q_A(ntryL,G1H2(5),47,0,G2H2(45),n2h2(9))
call HGT_raise_alpha_OLR(G1H4(26),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(26),ex5(:),G1H2(5),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_VQ_A(ntryL,G1H4(30),ex4(:),G1H2(6),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(6),47,0,G2H2(46),n2h2(10))
  call Hloop_VQ_A(ntryL,G1H4(31),ex4(:),G1H2(6),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_Q_A(ntryL,G1H2(6),47,0,G2H2(47),n2h2(11))
call HGT_raise_alpha_OLR(G1H4(32),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(32),ex5(:),G1H2(6),ngZu,m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_VQ_A(ntryL,G1H4(36),ex4(:),G1H2(7),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_Q_A(ntryL,G1H2(7),47,0,G2H2(48),n2h2(12))
  call Hloop_ZQ_A(ntryL,G1H4(37),ex4(:),G1H2(7),ngZu,m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(7),47,0,G2H2(49),n2h2(13))
call HGT_raise_alpha_OLR(G1H4(38),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(38),ex5(:),G1H2(7),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_ZQ_A(ntryL,G1H4(42),ex4(:),G1H2(8),ngZu,m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(8),47,0,G2H2(50),n2h2(14))
  call Hloop_ZQ_A(ntryL,G1H4(43),ex4(:),G1H2(8),ngZu,m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_Q_A(ntryL,G1H2(8),47,0,G2H2(51),n2h2(15))
call HGT_raise_alpha_OLR(G1H4(44),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(44),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(44),ex5(:),G1H2(8),ngZu,m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_ZQ_A(ntryL,G1H4(48),ex4(:),G1H2(9),ngZu,m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_Q_A(ntryL,G1H2(9),47,0,G2H2(52),n2h2(16))
  call Hloop_WQ_A(ntryL,G1H4(49),ex4(:),G1H2(9),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_Q_A(ntryL,G1H2(9),47,0,G2H2(53),n2h2(17))
call HGT_raise_alpha_OLR(G1H4(50),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(50),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(50),ex5(:),G1H2(9),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_WQ_A(ntryL,G1H4(54),ex4(:),G1H2(10),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(10),47,0,G2H2(54),n2h2(18))
  call Hloop_VA_Q(ntryL,G1H4(55),ex5(:),G1H2(10),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_A_Q(ntryL,G1H2(10),55,0,G2H2(55),n2h2(19))
call HGT_raise_alpha_OLR(G1H4(56),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(56),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(56),ex4(:),G1H2(10),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_VA_Q(ntryL,G1H4(60),ex5(:),G1H2(11),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_A_Q(ntryL,G1H2(11),55,0,G2H2(56),n2h2(20))
  call Hloop_VA_Q(ntryL,G1H4(61),ex5(:),G1H2(11),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_A_Q(ntryL,G1H2(11),55,0,G2H2(57),n2h2(21))
call HGT_raise_alpha_OLR(G1H4(62),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(62),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(62),ex4(:),G1H2(11),ngZu,m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_VA_Q(ntryL,G1H4(66),ex5(:),G1H2(12),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_A_Q(ntryL,G1H2(12),55,0,G2H2(58),n2h2(22))
  call Hloop_ZA_Q(ntryL,G1H4(67),ex5(:),G1H2(12),ngZu,m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_A_Q(ntryL,G1H2(12),55,0,G2H2(59),n2h2(23))
call HGT_raise_alpha_OLR(G1H4(68),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(68),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(68),ex4(:),G1H2(12),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_ZA_Q(ntryL,G1H4(72),ex5(:),G1H2(13),ngZu,m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_A_Q(ntryL,G1H2(13),55,0,G2H2(60),n2h2(24))
  call Hloop_ZA_Q(ntryL,G1H4(73),ex5(:),G1H2(13),ngZu,m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_A_Q(ntryL,G1H2(13),55,0,G2H2(61),n2h2(25))
call HGT_raise_alpha_OLR(G1H4(74),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(74),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(74),ex4(:),G1H2(13),ngZu,m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_ZA_Q(ntryL,G1H4(78),ex5(:),G1H2(14),ngZu,m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_A_Q(ntryL,G1H2(14),55,0,G2H2(62),n2h2(26))
  call Hloop_VQ_A(ntryL,G1H4(79),ex3(:),G1H2(14),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_Q_A(ntryL,G1H2(14),47,0,G2H2(63),n2h2(27))
call HGT_raise_alpha_OLR(G1H4(80),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(80),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(80),ex5(:),G1H2(14),m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_VQ_A(ntryL,G1H4(84),ex3(:),G1H2(15),m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_Q_A(ntryL,G1H2(15),47,0,G2H2(64),n2h2(28))
  call Hloop_VQ_A(ntryL,G1H4(85),ex3(:),G1H2(15),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_Q_A(ntryL,G1H2(15),47,0,G2H2(65),n2h2(29))
call HGT_raise_alpha_OLR(G1H4(86),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(86),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(86),ex5(:),G1H2(15),ngZu,m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_VQ_A(ntryL,G1H4(90),ex3(:),G1H2(16),m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_Q_A(ntryL,G1H2(16),47,0,G2H2(66),n2h2(30))
  call Hloop_ZQ_A(ntryL,G1H4(91),ex3(:),G1H2(16),ngZu,m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_Q_A(ntryL,G1H2(16),47,0,G2H2(67),n2h2(31))
call HGT_raise_alpha_OLR(G1H4(92),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(92),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(92),ex5(:),G1H2(16),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_ZQ_A(ntryL,G1H4(96),ex3(:),G1H2(17),ngZu,m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_Q_A(ntryL,G1H2(17),47,0,G2H2(68),n2h2(32))
  call Hloop_ZQ_A(ntryL,G1H4(97),ex3(:),G1H2(17),ngZu,m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_Q_A(ntryL,G1H2(17),47,0,G2H2(69),n2h2(33))
call HGT_raise_alpha_OLR(G1H4(98),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(98),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(98),ex5(:),G1H2(17),ngZu,m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_ZQ_A(ntryL,G1H4(102),ex3(:),G1H2(18),ngZu,m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_Q_A(ntryL,G1H2(18),47,0,G2H2(70),n2h2(34))
  call Hloop_WQ_A(ntryL,G1H4(103),ex3(:),G1H2(18),m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_Q_A(ntryL,G1H2(18),47,0,G2H2(71),n2h2(35))
call HGT_raise_alpha_OLR(G1H4(104),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(104),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(104),ex5(:),G1H2(18),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_WQ_A(ntryL,G1H4(108),ex3(:),G1H2(19),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_Q_A(ntryL,G1H2(19),47,0,G2H2(72),n2h2(36))
  call Hloop_ZQ_A(ntryL,G1H4(109),ex4(:),G1H2(19),ngZu,m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_Q_A(ntryL,G1H2(19),47,0,G2H2(73),n2h2(37))
call HGT_raise_alpha_OLR(G1H4(110),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(110),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(110),ex5(:),G1H2(19),m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_ZQ_A(ntryL,G1H4(114),ex4(:),G1H2(20),ngZu,m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_Q_A(ntryL,G1H2(20),47,0,G2H2(74),n2h2(38))
  call Hloop_ZQ_A(ntryL,G1H4(115),ex4(:),G1H2(20),ngZu,m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_Q_A(ntryL,G1H2(20),47,0,G2H2(75),n2h2(39))
call HGT_raise_alpha_OLR(G1H4(116),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(116),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(116),ex5(:),G1H2(20),ngZu,m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_ZQ_A(ntryL,G1H4(120),ex4(:),G1H2(21),ngZu,m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_Q_A(ntryL,G1H2(21),47,0,G2H2(76),n2h2(40))
  call Hloop_WQ_A(ntryL,G1H4(121),ex4(:),G1H2(21),m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_Q_A(ntryL,G1H2(21),47,0,G2H2(77),n2h2(41))
call HGT_raise_alpha_OLR(G1H4(122),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(122),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(122),ex5(:),G1H2(21),m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_WQ_A(ntryL,G1H4(126),ex4(:),G1H2(22),m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_Q_A(ntryL,G1H2(22),47,0,G2H2(78),n2h2(42))
  call Hloop_WQ_A(ntryL,G1H4(127),ex4(:),G1H2(22),m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_Q_A(ntryL,G1H2(22),47,0,G2H2(79),n2h2(43))
call HGT_raise_alpha_OLR(G1H4(128),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(128),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(128),ex5(:),G1H2(22),m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_WQ_A(ntryL,G1H4(132),ex4(:),G1H2(23),m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_Q_A(ntryL,G1H2(23),47,0,G2H2(80),n2h2(44))
  call Hloop_ZA_Q(ntryL,G1H4(133),ex5(:),G1H2(23),ngZu,m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_A_Q(ntryL,G1H2(23),55,0,G2H2(81),n2h2(45))
call HGT_raise_alpha_OLR(G1H4(134),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(134),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(134),ex4(:),G1H2(23),m3h2x2(:,104),heltab2x4(:,:,104))
  call Hloop_ZA_Q(ntryL,G1H4(138),ex5(:),G1H2(24),ngZu,m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_A_Q(ntryL,G1H2(24),55,0,G2H2(82),n2h2(46))
  call Hloop_ZA_Q(ntryL,G1H4(139),ex5(:),G1H2(24),ngZu,m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_A_Q(ntryL,G1H2(24),55,0,G2H2(83),n2h2(47))
call HGT_raise_alpha_OLR(G1H4(140),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(140),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(140),ex4(:),G1H2(24),ngZu,m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_ZA_Q(ntryL,G1H4(144),ex5(:),G1H2(25),ngZu,m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_A_Q(ntryL,G1H2(25),55,0,G2H2(84),n2h2(48))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(5),mass5set(:,7),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(26),8,2)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(5),mass5set(:,7),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(32),8,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(5),mass5set(:,8),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
  call HG1shiftOLR(G1H2(38),8,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(5),mass5set(:,9),  & 
G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),G1H2(48),2)
  call HG1shiftOLR(G1H2(44),8,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(6),mass5set(:,10),  & 
G1H2(49),G1H2(50),G1H2(51),G1H2(52),G1H2(53),G1H2(54),2)
  call HG1shiftOLR(G1H2(50),8,2)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(6),mass5set(:,11),  & 
G1H2(55),G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),2)
  call HG1shiftOLR(G1H2(56),8,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(6),mass5set(:,12),  & 
G1H2(61),G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(62),8,2)
  call Hotf_5pt_reduction(G2H2(8),RedSet_5(6),mass5set(:,13),  & 
G1H2(67),G1H2(68),G1H2(69),G1H2(70),G1H2(71),G1H2(72),2)
  call HG1shiftOLR(G1H2(68),8,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(7),mass5set(:,7),  & 
G1H2(73),G1H2(74),G1H2(75),G1H2(76),G1H2(77),G1H2(78),2)
  call HG1shiftOLR(G1H2(74),4,2)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(7),mass5set(:,7),  & 
G1H2(79),G1H2(80),G1H2(81),G1H2(82),G1H2(83),G1H2(84),2)
  call HG1shiftOLR(G1H2(80),4,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(7),mass5set(:,8),  & 
G1H2(85),G1H2(86),G1H2(87),G1H2(88),G1H2(89),G1H2(90),2)
  call HG1shiftOLR(G1H2(86),4,2)
  call Hotf_5pt_reduction(G2H2(12),RedSet_5(7),mass5set(:,9),  & 
G1H2(91),G1H2(92),G1H2(93),G1H2(94),G1H2(95),G1H2(96),2)
  call HG1shiftOLR(G1H2(92),4,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(8),mass5set(:,12),  & 
G1H2(97),G1H2(98),G1H2(99),G1H2(100),G1H2(101),G1H2(102),2)
  call HG1shiftOLR(G1H2(98),8,2)
  call Hotf_5pt_reduction(G2H2(14),RedSet_5(8),mass5set(:,13),  & 
G1H2(103),G1H2(104),G1H2(105),G1H2(106),G1H2(107),G1H2(108),2)
  call HG1shiftOLR(G1H2(104),8,2)
  call Hotf_5pt_reduction(G2H2(15),RedSet_5(9),mass5set(:,7),  & 
G1H2(109),G1H2(110),G1H2(111),G1H2(112),G1H2(113),G1H2(114),2)
  call HG1shiftOLR(G1H2(110),8,2)
  call Hotf_5pt_reduction(G2H2(16),RedSet_5(9),mass5set(:,7),  & 
G1H2(115),G1H2(116),G1H2(117),G1H2(118),G1H2(119),G1H2(120),2)
  call HG1shiftOLR(G1H2(116),8,2)
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(9),mass5set(:,7),  & 
G1H2(121),G1H2(122),G1H2(123),G1H2(124),G1H2(125),G1H2(126),2)
  call HG1shiftOLR(G1H2(122),4,2)
  call Hotf_5pt_reduction(G2H2(18),RedSet_5(9),mass5set(:,7),  & 
G1H2(127),G1H2(128),G1H2(129),G1H2(130),G1H2(131),G1H2(132),2)
  call HG1shiftOLR(G1H2(128),4,2)
  call Hotf_5pt_reduction(G2H2(19),RedSet_5(10),mass5set(:,14),  & 
G1H2(133),G1H2(134),G1H2(135),G1H2(136),G1H2(137),G1H2(138),2)
  call HG1shiftOLR(G1H2(134),8,2)
  call Hotf_5pt_reduction(G2H2(20),RedSet_5(10),mass5set(:,14),  & 
G1H2(139),G1H2(140),G1H2(141),G1H2(142),G1H2(143),G1H2(144),2)
  call HG1shiftOLR(G1H2(140),8,2)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(10),mass5set(:,7),  & 
G1H2(145),G1H2(146),G1H2(147),G1H2(148),G1H2(149),G1H2(150),2)
  call HG1shiftOLR(G1H2(146),8,2)
  call Hotf_5pt_reduction(G2H2(22),RedSet_5(10),mass5set(:,7),  & 
G1H2(151),G1H2(152),G1H2(153),G1H2(154),G1H2(155),G1H2(156),2)
  call HG1shiftOLR(G1H2(152),8,2)
  call Hotf_5pt_reduction(G2H2(23),RedSet_5(10),mass5set(:,9),  & 
G1H2(157),G1H2(158),G1H2(159),G1H2(160),G1H2(161),G1H2(162),2)
  call HG1shiftOLR(G1H2(158),8,2)
  call Hotf_5pt_reduction(G2H2(24),RedSet_5(11),mass5set(:,14),  & 
G1H2(163),G1H2(164),G1H2(165),G1H2(166),G1H2(167),G1H2(168),2)
  call HG1shiftOLR(G1H2(164),4,2)
  call Hotf_5pt_reduction(G2H2(25),RedSet_5(11),mass5set(:,14),  & 
G1H2(169),G1H2(170),G1H2(171),G1H2(172),G1H2(173),G1H2(174),2)
  call HG1shiftOLR(G1H2(170),4,2)
  call Hotf_5pt_reduction(G2H2(26),RedSet_5(11),mass5set(:,7),  & 
G1H2(175),G1H2(176),G1H2(177),G1H2(178),G1H2(179),G1H2(180),2)
  call HG1shiftOLR(G1H2(176),4,2)
  call Hotf_5pt_reduction(G2H2(27),RedSet_5(11),mass5set(:,7),  & 
G1H2(181),G1H2(182),G1H2(183),G1H2(184),G1H2(185),G1H2(186),2)
  call HG1shiftOLR(G1H2(182),4,2)
  call Hotf_5pt_reduction(G2H2(28),RedSet_5(11),mass5set(:,9),  & 
G1H2(187),G1H2(188),G1H2(189),G1H2(190),G1H2(191),G1H2(192),2)
  call HG1shiftOLR(G1H2(188),4,2)
  call Hotf_5pt_reduction(G2H2(29),RedSet_5(12),mass5set(:,14),  & 
G1H2(193),G1H2(194),G1H2(195),G1H2(196),G1H2(197),G1H2(198),2)
  call HG1shiftOLR(G1H2(194),8,2)
  call Hotf_5pt_reduction(G2H2(30),RedSet_5(12),mass5set(:,14),  & 
G1H2(199),G1H2(200),G1H2(201),G1H2(202),G1H2(203),G1H2(204),2)
  call HG1shiftOLR(G1H2(200),8,2)
  call Hotf_5pt_reduction(G2H2(31),RedSet_5(12),mass5set(:,7),  & 
G1H2(205),G1H2(206),G1H2(207),G1H2(208),G1H2(209),G1H2(210),2)
  call HG1shiftOLR(G1H2(206),8,2)
  call Hotf_5pt_reduction(G2H2(32),RedSet_5(12),mass5set(:,7),  & 
G1H2(211),G1H2(212),G1H2(213),G1H2(214),G1H2(215),G1H2(216),2)
  call HG1shiftOLR(G1H2(212),8,2)
  call Hotf_5pt_reduction(G2H2(33),RedSet_5(12),mass5set(:,14),  & 
G1H2(217),G1H2(218),G1H2(219),G1H2(220),G1H2(221),G1H2(222),2)
  call HG1shiftOLR(G1H2(218),4,2)
  call Hotf_5pt_reduction(G2H2(34),RedSet_5(12),mass5set(:,14),  & 
G1H2(223),G1H2(224),G1H2(225),G1H2(226),G1H2(227),G1H2(228),2)
  call HG1shiftOLR(G1H2(224),4,2)
  call Hotf_5pt_reduction(G2H2(35),RedSet_5(12),mass5set(:,7),  & 
G1H2(229),G1H2(230),G1H2(231),G1H2(232),G1H2(233),G1H2(234),2)
  call HG1shiftOLR(G1H2(230),4,2)
  call Hotf_5pt_reduction(G2H2(36),RedSet_5(12),mass5set(:,7),  & 
G1H2(235),G1H2(236),G1H2(237),G1H2(238),G1H2(239),G1H2(240),2)
  call HG1shiftOLR(G1H2(236),4,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(37),ex5(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(39),ex5(:),G2tensor(2),ngZu,m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(41),ex5(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(43),ex5(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(45),ex5(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(47),ex5(:),G2tensor(6),ngZu,m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(49),ex5(:),G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(51),ex5(:),G2tensor(8),ngZu,m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(53),ex5(:),G2tensor(9),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(55),ex4(:),G2tensor(10),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(57),ex4(:),G2tensor(11),ngZu,m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(59),ex4(:),G2tensor(12),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(61),ex4(:),G2tensor(13),ngZu,m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(63),ex5(:),G2tensor(14),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(65),ex5(:),G2tensor(15),ngZu,m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(67),ex5(:),G2tensor(16),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(69),ex5(:),G2tensor(17),ngZu,m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(71),ex5(:),G2tensor(18),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(73),ex5(:),G2tensor(19),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(75),ex5(:),G2tensor(20),ngZu,m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(77),ex5(:),G2tensor(21),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(79),ex5(:),G2tensor(22),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(81),ex4(:),G2tensor(23),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(83),ex4(:),G2tensor(24),ngZu,m3h2x1(:,24),heltab2x2(:,:,24))
  call Hloop_VQ_A(ntryL,G1H2(25),ex4(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(25),n2h1(1))
  call Hloop_VQ_A(ntryL,G1H2(26),ex4(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(26),n2h1(2))
  call Hloop_ZQ_A(ntryL,G1H2(31),ex4(:),G1H1(1),ngZu,m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(27),n2h1(3))
  call Hloop_ZQ_A(ntryL,G1H2(32),ex4(:),G1H1(1),ngZu,m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(28),n2h1(4))
  call Hloop_WQ_A(ntryL,G1H2(37),ex4(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(29),n2h1(5))
  call Hloop_WQ_A(ntryL,G1H2(38),ex4(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(30),n2h1(6))
  call Hloop_WQ_A(ntryL,G1H2(43),ex4(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(31),n2h1(7))
  call Hloop_WQ_A(ntryL,G1H2(44),ex4(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(32),n2h1(8))
  call Hloop_WQ_A(ntryL,G1H2(49),ex4(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(33),n2h1(9))
  call Hloop_WQ_A(ntryL,G1H2(50),ex4(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(34),n2h1(10))
  call Hloop_WQ_A(ntryL,G1H2(55),ex4(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(35),n2h1(11))
  call Hloop_WQ_A(ntryL,G1H2(56),ex4(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(36),n2h1(12))
  call Hloop_WQ_A(ntryL,G1H2(61),ex4(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(37),n2h1(13))
  call Hloop_WQ_A(ntryL,G1H2(62),ex4(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(38),n2h1(14))
  call Hloop_WQ_A(ntryL,G1H2(67),ex4(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(39),n2h1(15))
  call Hloop_WQ_A(ntryL,G1H2(68),ex4(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(40),n2h1(16))
  call Hloop_VQ_A(ntryL,G1H2(73),ex3(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(41),n2h1(17))
  call Hloop_VQ_A(ntryL,G1H2(74),ex3(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(42),n2h1(18))
  call Hloop_ZQ_A(ntryL,G1H2(79),ex3(:),G1H1(1),ngZu,m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(43),n2h1(19))
  call Hloop_ZQ_A(ntryL,G1H2(80),ex3(:),G1H1(1),ngZu,m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(44),n2h1(20))
  call Hloop_WQ_A(ntryL,G1H2(85),ex3(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(45),n2h1(21))
  call Hloop_WQ_A(ntryL,G1H2(86),ex3(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(46),n2h1(22))
  call Hloop_WQ_A(ntryL,G1H2(91),ex3(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(47),n2h1(23))
  call Hloop_WQ_A(ntryL,G1H2(92),ex3(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(48),n2h1(24))
  call Hloop_WQ_A(ntryL,G1H2(97),ex4(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(49),n2h1(25))
  call Hloop_WQ_A(ntryL,G1H2(98),ex4(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(50),n2h1(26))
  call Hloop_WQ_A(ntryL,G1H2(103),ex4(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(51),n2h1(27))
  call Hloop_WQ_A(ntryL,G1H2(104),ex4(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(52),n2h1(28))
  call Hloop_VQ_A(ntryL,G1H2(109),ex4(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(53),n2h1(29))
  call Hloop_VQ_A(ntryL,G1H2(110),ex4(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(54),n2h1(30))
  call Hloop_ZQ_A(ntryL,G1H2(115),ex4(:),G1H1(1),ngZu,m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(55),n2h1(31))
  call Hloop_ZQ_A(ntryL,G1H2(116),ex4(:),G1H1(1),ngZu,m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(56),n2h1(32))
  call Hloop_VQ_A(ntryL,G1H2(121),ex3(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(57),n2h1(33))
  call Hloop_VQ_A(ntryL,G1H2(122),ex3(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(58),n2h1(34))
  call Hloop_ZQ_A(ntryL,G1H2(127),ex3(:),G1H1(1),ngZu,m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(59),n2h1(35))
  call Hloop_ZQ_A(ntryL,G1H2(128),ex3(:),G1H1(1),ngZu,m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(60),n2h1(36))
  call Hloop_VQ_A(ntryL,G1H2(133),ex4(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(61),n2h1(37))
  call Hloop_VQ_A(ntryL,G1H2(134),ex4(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(62),n2h1(38))
  call Hloop_ZQ_A(ntryL,G1H2(139),ex4(:),G1H1(1),ngZu,m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(63),n2h1(39))
  call Hloop_ZQ_A(ntryL,G1H2(140),ex4(:),G1H1(1),ngZu,m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(64),n2h1(40))
  call Hloop_VQ_A(ntryL,G1H2(145),ex4(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(65),n2h1(41))
  call Hloop_VQ_A(ntryL,G1H2(146),ex4(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(66),n2h1(42))
  call Hloop_ZQ_A(ntryL,G1H2(151),ex4(:),G1H1(1),ngZu,m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(67),n2h1(43))
  call Hloop_ZQ_A(ntryL,G1H2(152),ex4(:),G1H1(1),ngZu,m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(68),n2h1(44))
  call Hloop_WQ_A(ntryL,G1H2(157),ex4(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(69),n2h1(45))
  call Hloop_WQ_A(ntryL,G1H2(158),ex4(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(70),n2h1(46))
  call Hloop_VQ_A(ntryL,G1H2(163),ex3(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(71),n2h1(47))
  call Hloop_VQ_A(ntryL,G1H2(164),ex3(:),G1H1(1),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(72),n2h1(48))
  call Hloop_ZQ_A(ntryL,G1H2(169),ex3(:),G1H1(1),ngZu,m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(73),n2h1(49))
  call Hloop_ZQ_A(ntryL,G1H2(170),ex3(:),G1H1(1),ngZu,m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(74),n2h1(50))
  call Hloop_VQ_A(ntryL,G1H2(175),ex3(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(75),n2h1(51))
  call Hloop_VQ_A(ntryL,G1H2(176),ex3(:),G1H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(76),n2h1(52))
  call Hloop_ZQ_A(ntryL,G1H2(181),ex3(:),G1H1(1),ngZu,m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(77),n2h1(53))
  call Hloop_ZQ_A(ntryL,G1H2(182),ex3(:),G1H1(1),ngZu,m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(78),n2h1(54))
  call Hloop_WQ_A(ntryL,G1H2(187),ex3(:),G1H1(1),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(79),n2h1(55))
  call Hloop_WQ_A(ntryL,G1H2(188),ex3(:),G1H1(1),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(80),n2h1(56))
  call Hloop_VQ_A(ntryL,G1H2(193),ex4(:),G1H1(1),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(81),n2h1(57))
  call Hloop_VQ_A(ntryL,G1H2(194),ex4(:),G1H1(1),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(82),n2h1(58))
  call Hloop_ZQ_A(ntryL,G1H2(199),ex4(:),G1H1(1),ngZu,m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(83),n2h1(59))
  call Hloop_ZQ_A(ntryL,G1H2(200),ex4(:),G1H1(1),ngZu,m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(84),n2h1(60))
  call Hloop_VQ_A(ntryL,G1H2(205),ex4(:),G1H1(1),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(85),n2h1(61))
  call Hloop_VQ_A(ntryL,G1H2(206),ex4(:),G1H1(1),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(86),n2h1(62))
  call Hloop_ZQ_A(ntryL,G1H2(211),ex4(:),G1H1(1),ngZu,m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(87),n2h1(63))
  call Hloop_ZQ_A(ntryL,G1H2(212),ex4(:),G1H1(1),ngZu,m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(88),n2h1(64))
  call Hloop_VQ_A(ntryL,G1H2(217),ex3(:),G1H1(1),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(89),n2h1(65))
  call Hloop_VQ_A(ntryL,G1H2(218),ex3(:),G1H1(1),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(90),n2h1(66))
  call Hloop_ZQ_A(ntryL,G1H2(223),ex3(:),G1H1(1),ngZu,m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(91),n2h1(67))
  call Hloop_ZQ_A(ntryL,G1H2(224),ex3(:),G1H1(1),ngZu,m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(92),n2h1(68))
  call Hloop_VQ_A(ntryL,G1H2(229),ex3(:),G1H1(1),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(93),n2h1(69))
  call Hloop_VQ_A(ntryL,G1H2(230),ex3(:),G1H1(1),m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(94),n2h1(70))
  call Hloop_ZQ_A(ntryL,G1H2(235),ex3(:),G1H1(1),ngZu,m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(95),n2h1(71))
  call Hloop_ZQ_A(ntryL,G1H2(236),ex3(:),G1H1(1),ngZu,m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(96),n2h1(72))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),16)
  call Hotf_5pt_reduction_last(G2tensor(2),RedSet_5(1),mass5set(:,2),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),16)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(1),mass5set(:,3),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),16)
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(1),mass5set(:,4),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),16)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(2),mass5set(:,5),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),16)
  call Hotf_5pt_reduction_last(G2tensor(6),RedSet_5(2),mass5set(:,6),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),16)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(2),mass5set(:,1),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),16)
  call Hotf_5pt_reduction_last(G2tensor(8),RedSet_5(2),mass5set(:,2),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),16)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(2),mass5set(:,4),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),16)
  call Hotf_5pt_reduction_last(G2tensor(10),RedSet_5(2),mass5set(:,5),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),8)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(2),mass5set(:,6),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_5pt_reduction_last(G2tensor(12),RedSet_5(2),mass5set(:,1),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),8)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(2),mass5set(:,2),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),8)
  call Hotf_5pt_reduction_last(G2tensor(14),RedSet_5(3),mass5set(:,5),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),16)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(3),mass5set(:,6),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),16)
  call Hotf_5pt_reduction_last(G2tensor(16),RedSet_5(3),mass5set(:,1),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),16)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(3),mass5set(:,2),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),16)
  call Hotf_5pt_reduction_last(G2tensor(18),RedSet_5(3),mass5set(:,4),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),16)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(4),mass5set(:,1),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),16)
  call Hotf_5pt_reduction_last(G2tensor(20),RedSet_5(4),mass5set(:,2),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),16)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(4),mass5set(:,3),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),16)
  call Hotf_5pt_reduction_last(G2tensor(22),RedSet_5(4),mass5set(:,4),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),16)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(4),mass5set(:,1),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),8)
  call Hotf_5pt_reduction_last(G2tensor(24),RedSet_5(4),mass5set(:,2),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),8)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(5),mass5set(:,7),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),8)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(5),mass5set(:,7),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),8)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(5),mass5set(:,8),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),8)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(5),mass5set(:,9),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),8)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(6),mass5set(:,10),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),8)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(6),mass5set(:,11),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),8)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(6),mass5set(:,12),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
  call G_TensorShift(G1tensor(182),8)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(6),mass5set(:,13),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
  call G_TensorShift(G1tensor(188),8)
  call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(7),mass5set(:,7),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
  call G_TensorShift(G1tensor(194),4)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(7),mass5set(:,7),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
  call G_TensorShift(G1tensor(200),4)
  call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(7),mass5set(:,8),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(206),4)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(7),mass5set(:,9),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
  call G_TensorShift(G1tensor(212),4)
  call Hotf_5pt_reduction_last(G2tensor(49),RedSet_5(8),mass5set(:,12),  & 
G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
  call G_TensorShift(G1tensor(218),8)
  call Hotf_5pt_reduction_last(G2tensor(51),RedSet_5(8),mass5set(:,13),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227),G1tensor(228))
  call G_TensorShift(G1tensor(224),8)
  call Hotf_5pt_reduction_last(G2tensor(53),RedSet_5(9),mass5set(:,7),  & 
G1tensor(229),G1tensor(230),G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234))
  call G_TensorShift(G1tensor(230),8)
  call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(9),mass5set(:,7),  & 
G1tensor(235),G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(236),8)
  call Hotf_5pt_reduction_last(G2tensor(57),RedSet_5(9),mass5set(:,7),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245),G1tensor(246))
  call G_TensorShift(G1tensor(242),4)
  call Hotf_5pt_reduction_last(G2tensor(59),RedSet_5(9),mass5set(:,7),  & 
G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250),G1tensor(251),G1tensor(252))
  call G_TensorShift(G1tensor(248),4)
  call Hotf_5pt_reduction_last(G2tensor(61),RedSet_5(10),mass5set(:,14),  & 
G1tensor(253),G1tensor(254),G1tensor(255),G1tensor(256),G1tensor(257),G1tensor(258))
  call G_TensorShift(G1tensor(254),8)
  call Hotf_5pt_reduction_last(G2tensor(63),RedSet_5(10),mass5set(:,14),  & 
G1tensor(259),G1tensor(260),G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264))
  call G_TensorShift(G1tensor(260),8)
  call Hotf_5pt_reduction_last(G2tensor(65),RedSet_5(10),mass5set(:,7),  & 
G1tensor(265),G1tensor(266),G1tensor(267),G1tensor(268),G1tensor(269),G1tensor(270))
  call G_TensorShift(G1tensor(266),8)
  call Hotf_5pt_reduction_last(G2tensor(67),RedSet_5(10),mass5set(:,7),  & 
G1tensor(271),G1tensor(272),G1tensor(273),G1tensor(274),G1tensor(275),G1tensor(276))
  call G_TensorShift(G1tensor(272),8)
  call Hotf_5pt_reduction_last(G2tensor(69),RedSet_5(10),mass5set(:,9),  & 
G1tensor(277),G1tensor(278),G1tensor(279),G1tensor(280),G1tensor(281),G1tensor(282))
  call G_TensorShift(G1tensor(278),8)
  call Hotf_5pt_reduction_last(G2tensor(71),RedSet_5(11),mass5set(:,14),  & 
G1tensor(283),G1tensor(284),G1tensor(285),G1tensor(286),G1tensor(287),G1tensor(288))
  call G_TensorShift(G1tensor(284),4)
  call Hotf_5pt_reduction_last(G2tensor(73),RedSet_5(11),mass5set(:,14),  & 
G1tensor(289),G1tensor(290),G1tensor(291),G1tensor(292),G1tensor(293),G1tensor(294))
  call G_TensorShift(G1tensor(290),4)
  call Hotf_5pt_reduction_last(G2tensor(75),RedSet_5(11),mass5set(:,7),  & 
G1tensor(295),G1tensor(296),G1tensor(297),G1tensor(298),G1tensor(299),G1tensor(300))
  call G_TensorShift(G1tensor(296),4)
  call Hotf_5pt_reduction_last(G2tensor(77),RedSet_5(11),mass5set(:,7),  & 
G1tensor(301),G1tensor(302),G1tensor(303),G1tensor(304),G1tensor(305),G1tensor(306))
  call G_TensorShift(G1tensor(302),4)
  call Hotf_5pt_reduction_last(G2tensor(79),RedSet_5(11),mass5set(:,9),  & 
G1tensor(307),G1tensor(308),G1tensor(309),G1tensor(310),G1tensor(311),G1tensor(312))
  call G_TensorShift(G1tensor(308),4)
  call Hotf_5pt_reduction_last(G2tensor(81),RedSet_5(12),mass5set(:,14),  & 
G1tensor(313),G1tensor(314),G1tensor(315),G1tensor(316),G1tensor(317),G1tensor(318))
  call G_TensorShift(G1tensor(314),8)
  call Hotf_5pt_reduction_last(G2tensor(83),RedSet_5(12),mass5set(:,14),  & 
G1tensor(319),G1tensor(320),G1tensor(321),G1tensor(322),G1tensor(323),G1tensor(324))
  call G_TensorShift(G1tensor(320),8)
  call Hotf_5pt_reduction_last(G2tensor(85),RedSet_5(12),mass5set(:,7),  & 
G1tensor(325),G1tensor(326),G1tensor(327),G1tensor(328),G1tensor(329),G1tensor(330))
  call G_TensorShift(G1tensor(326),8)
  call Hotf_5pt_reduction_last(G2tensor(87),RedSet_5(12),mass5set(:,7),  & 
G1tensor(331),G1tensor(332),G1tensor(333),G1tensor(334),G1tensor(335),G1tensor(336))
  call G_TensorShift(G1tensor(332),8)
  call Hotf_5pt_reduction_last(G2tensor(89),RedSet_5(12),mass5set(:,14),  & 
G1tensor(337),G1tensor(338),G1tensor(339),G1tensor(340),G1tensor(341),G1tensor(342))
  call G_TensorShift(G1tensor(338),4)
  call Hotf_5pt_reduction_last(G2tensor(91),RedSet_5(12),mass5set(:,14),  & 
G1tensor(343),G1tensor(344),G1tensor(345),G1tensor(346),G1tensor(347),G1tensor(348))
  call G_TensorShift(G1tensor(344),4)
  call Hotf_5pt_reduction_last(G2tensor(93),RedSet_5(12),mass5set(:,7),  & 
G1tensor(349),G1tensor(350),G1tensor(351),G1tensor(352),G1tensor(353),G1tensor(354))
  call G_TensorShift(G1tensor(350),4)
  call Hotf_5pt_reduction_last(G2tensor(95),RedSet_5(12),mass5set(:,7),  & 
G1tensor(355),G1tensor(356),G1tensor(357),G1tensor(358),G1tensor(359),G1tensor(360))
  call G_TensorShift(G1tensor(356),4)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  call ol_merge_tensors(T1sum(21),[G1tensor(121)])
  call ol_merge_tensors(T1sum(22),[G1tensor(127)])
  call ol_merge_tensors(T1sum(23),[G1tensor(133)])
  call ol_merge_tensors(T1sum(24),[G1tensor(139)])
  call ol_merge_tensors(T1sum(25),[G1tensor(145)])
  call ol_merge_tensors(T1sum(26),[G1tensor(151)])
  call ol_merge_tensors(T1sum(27),[G1tensor(157)])
  call ol_merge_tensors(T1sum(28),[G1tensor(163)])
  call ol_merge_tensors(T1sum(29),[G1tensor(169)])
  call ol_merge_tensors(T1sum(30),[G1tensor(175)])
  call ol_merge_tensors(T1sum(31),[G1tensor(181)])
  call ol_merge_tensors(T1sum(32),[G1tensor(187)])
  call ol_merge_tensors(T1sum(33),[G1tensor(193)])
  call ol_merge_tensors(T1sum(34),[G1tensor(199)])
  call ol_merge_tensors(T1sum(35),[G1tensor(205)])
  call ol_merge_tensors(T1sum(36),[G1tensor(211)])
  call ol_merge_tensors(T1sum(37),[G1tensor(217)])
  call ol_merge_tensors(T1sum(38),[G1tensor(223)])
  call ol_merge_tensors(T1sum(39),[G1tensor(229)])
  call ol_merge_tensors(T1sum(40),[G1tensor(235)])
  call ol_merge_tensors(T1sum(41),[G1tensor(241)])
  call ol_merge_tensors(T1sum(42),[G1tensor(247)])
  call ol_merge_tensors(T1sum(43),[G1tensor(253)])
  call ol_merge_tensors(T1sum(44),[G1tensor(259)])
  call ol_merge_tensors(T1sum(45),[G1tensor(265)])
  call ol_merge_tensors(T1sum(46),[G1tensor(271)])
  call ol_merge_tensors(T1sum(47),[G1tensor(277)])
  call ol_merge_tensors(T1sum(48),[G1tensor(283)])
  call ol_merge_tensors(T1sum(49),[G1tensor(289)])
  call ol_merge_tensors(T1sum(50),[G1tensor(295)])
  call ol_merge_tensors(T1sum(51),[G1tensor(301)])
  call ol_merge_tensors(T1sum(52),[G1tensor(307)])
  call ol_merge_tensors(T1sum(53),[G1tensor(313)])
  call ol_merge_tensors(T1sum(54),[G1tensor(319)])
  call ol_merge_tensors(T1sum(55),[G1tensor(325)])
  call ol_merge_tensors(T1sum(56),[G1tensor(331)])
  call ol_merge_tensors(T1sum(57),[G1tensor(337)])
  call ol_merge_tensors(T1sum(58),[G1tensor(343)])
  call ol_merge_tensors(T1sum(59),[G1tensor(349)])
  call ol_merge_tensors(T1sum(60),[G1tensor(355)])
  Gcoeff(:)%j = (c(75)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(85),h0tab(:,85),[32,3,16,4,8],[nMW,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,85),heltab2x64(:,:,85))
  Gcoeff(:)%j = (c(57)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(86),h0tab(:,86),[32,3,16,4,8],[nMW,nMZ,0,0,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,86),heltab2x64(:,:,86))
  Gcoeff(:)%j = (c(78)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(87),h0tab(:,87),[32,3,16,4,8],[nMW,0,0,nMZ,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,87),heltab2x64(:,:,87))
  Gcoeff(:)%j = (c(59)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(88),h0tab(:,88),[32,3,16,4,8],[nMW,nMZ,0,nMZ,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(12),m3h2x32(:,88),heltab2x64(:,:,88))
  Gcoeff(:)%j = (c(91)*M(1,:)%j-c(90)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(89),h0tab(:,89),[32,3,16,4,8],[nMW,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,89),heltab2x64(:,:,89))
  Gcoeff(:)%j = (c(61)*M(1,:)%j-c(60)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(90),h0tab(:,90),[32,3,16,4,8],[nMW,nMZ,0,0,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(20),m3h2x32(:,90),heltab2x64(:,:,90))
  Gcoeff(:)%j = (-(c(70)*M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(91),h0tab(:,91),[32,3,8,4,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(23),m3h2x32(:,91),heltab2x64(:,:,91))
  call Hloop_A_Q(ntryL,G0H32(23),32,0,G1H32(1),n2h32(34))
  Gcoeff(:)%j = (c(77)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(92),h0tab(:,92),[32,3,8,4,16],[0,0,0,0,nMZ],5,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(26),ngZd,m3h2x32(:,92),heltab2x64(:,:,92))
  call Hloop_A_Q(ntryL,G0H32(26),32,0,G1H32(6),n2h32(35))
  Gcoeff(:)%j = (-(c(74)*M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(93),h0tab(:,93),[32,3,8,4,16],[0,0,nMZ,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(28),m3h2x32(:,93),heltab2x64(:,:,93))
  call Hloop_A_Q(ntryL,G0H32(28),32,0,G1H32(8),n2h32(36))
  Gcoeff(:)%j = (c(79)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(94),h0tab(:,94),[32,3,8,4,16],[0,0,nMZ,0,nMZ],5,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(33),ngZd,m3h2x32(:,94),heltab2x64(:,:,94))
  call Hloop_A_Q(ntryL,G0H32(33),32,0,G1H32(13),n2h32(37))
  Gcoeff(:)%j = (c(88)*M(1,:)%j-c(87)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(95),h0tab(:,95),[32,3,8,4,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,95),heltab2x64(:,:,95))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(15),n2h32(38))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)+c(82)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(96),h0tab(:,96),[32,3,8,4,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(40),m3h2x32(:,96),heltab2x64(:,:,96))
  call Hloop_A_Q(ntryL,G0H32(40),32,0,G1H32(19),n2h32(39))
  Gcoeff(:)%j = (c(94)*M(1,:)%j-c(93)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(97),h0tab(:,97),[32,3,8,4,16],[0,0,nMZ,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(42),m3h2x32(:,97),heltab2x64(:,:,97))
  call Hloop_A_Q(ntryL,G0H32(42),32,0,G1H32(21),n2h32(40))
  Gcoeff(:)%j = (c(94)*M(1,:)%j-c(93)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(98),h0tab(:,98),[32,3,8,4,16],[0,0,0,0,nMZ],5,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(46),ngZd,m3h2x32(:,98),heltab2x64(:,:,98))
  call Hloop_A_Q(ntryL,G0H32(46),32,0,G1H32(26),n2h32(41))
  Gcoeff(:)%j = (-(c(75)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(99),h0tab(:,99),[32,3,16,8,4],[nMW,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(48),m3h2x32(:,99),heltab2x64(:,:,99))
  Gcoeff(:)%j = (-(c(57)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(100),h0tab(:,100),[32,3,16,8,4],[nMW,nMZ,0,0,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,100),heltab2x64(:,:,100))
  Gcoeff(:)%j = (-(c(78)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(101),h0tab(:,101),[32,3,16,8,4],[nMW,0,0,nMZ,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,101),heltab2x64(:,:,101))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(102),h0tab(:,102),[32,3,16,8,4],[nMW,nMZ,0,nMZ,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,102),heltab2x64(:,:,102))
  Gcoeff(:)%j = (c(90)*M(1,:)%j-c(91)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(103),h0tab(:,103),[32,3,16,8,4],[nMW,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,103),heltab2x64(:,:,103))
  Gcoeff(:)%j = (c(60)*M(1,:)%j-c(61)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(104),h0tab(:,104),[32,3,16,8,4],[nMW,nMZ,0,0,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,104),heltab2x64(:,:,104))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(105),h0tab(:,105),[32,4,8,3,16],[0,0,0,0,nMW],5,1,wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,105),heltab2x64(:,:,105))
  call Hloop_A_Q(ntryL,G0H32(7),32,0,G1H32(31),n2h32(42))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(106),h0tab(:,106),[32,4,8,3,16],[0,nMZ,0,0,nMW],5,1,wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(11),m3h2x32(:,106),heltab2x64(:,:,106))
  call Hloop_A_Q(ntryL,G0H32(11),32,0,G1H32(5),n2h32(43))
  Gcoeff(:)%j = (c(37)*M(1,:)%j-c(38)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(107),h0tab(:,107),[32,4,8,3,16],[0,0,0,0,nMW],5,1,wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,107),heltab2x64(:,:,107))
  call Hloop_A_Q(ntryL,G0H32(9),32,0,G1H32(2),n2h32(44))
  Gcoeff(:)%j = (c(70)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(108),h0tab(:,108),[32,3,4,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(16),m3h2x32(:,108),heltab2x64(:,:,108))
  call Hloop_A_Q(ntryL,G0H32(16),32,0,G1H32(3),n2h32(45))
  Gcoeff(:)%j = (-(c(77)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(109),h0tab(:,109),[32,3,4,8,16],[0,0,0,0,nMZ],5,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(13),ngZd,m3h2x32(:,109),heltab2x64(:,:,109))
  call Hloop_A_Q(ntryL,G0H32(13),32,0,G1H32(4),n2h32(46))
  Gcoeff(:)%j = (c(74)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(110),h0tab(:,110),[32,3,4,8,16],[0,0,nMZ,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(14),m3h2x32(:,110),heltab2x64(:,:,110))
  call Hloop_A_Q(ntryL,G0H32(14),32,0,G1H32(11),n2h32(47))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(111),h0tab(:,111),[32,3,4,8,16],[0,0,nMZ,0,nMZ],5,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(15),ngZd,m3h2x32(:,111),heltab2x64(:,:,111))
  call Hloop_A_Q(ntryL,G0H32(15),32,0,G1H32(7),n2h32(48))
  Gcoeff(:)%j = (c(87)*M(1,:)%j-c(88)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(112),h0tab(:,112),[32,3,4,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(19),m3h2x32(:,112),heltab2x64(:,:,112))
  call Hloop_A_Q(ntryL,G0H32(19),32,0,G1H32(12),n2h32(49))
  Gcoeff(:)%j = (-(c(82)*M(1,:)%j)+c(83)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(113),h0tab(:,113),[32,3,4,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(18),m3h2x32(:,113),heltab2x64(:,:,113))
  call Hloop_A_Q(ntryL,G0H32(18),32,0,G1H32(9),n2h32(50))
  Gcoeff(:)%j = (c(93)*M(1,:)%j-c(94)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(114),h0tab(:,114),[32,3,4,8,16],[0,0,nMZ,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(22),m3h2x32(:,114),heltab2x64(:,:,114))
  call Hloop_A_Q(ntryL,G0H32(22),32,0,G1H32(10),n2h32(51))
  Gcoeff(:)%j = (c(93)*M(1,:)%j-c(94)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(115),h0tab(:,115),[32,3,4,8,16],[0,0,0,0,nMZ],5,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(21),ngZd,m3h2x32(:,115),heltab2x64(:,:,115))
  call Hloop_A_Q(ntryL,G0H32(21),32,0,G1H32(17),n2h32(52))
  Gcoeff(:)%j = (c(25)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(116),h0tab(:,116),[32,8,4,3,16],[0,0,0,0,nMW],5,1,wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,116),heltab2x64(:,:,116))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(14),n2h32(53))
  Gcoeff(:)%j = (c(28)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(117),h0tab(:,117),[32,8,4,3,16],[0,nMZ,0,0,nMW],5,1,wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(24),m3h2x32(:,117),heltab2x64(:,:,117))
  call Hloop_A_Q(ntryL,G0H32(24),32,0,G1H32(18),n2h32(54))
  Gcoeff(:)%j = (c(38)*M(1,:)%j-c(37)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(118),h0tab(:,118),[32,8,4,3,16],[0,0,0,0,nMW],5,1,wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(31),m3h2x32(:,118),heltab2x64(:,:,118))
  call Hloop_A_Q(ntryL,G0H32(31),32,0,G1H32(16),n2h32(55))
  Gcoeff(:)%j = (-(c(70)*M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(119),h0tab(:,119),[32,3,8,16,4],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(27),m3h2x32(:,119),heltab2x64(:,:,119))
  call Hloop_A_Q(ntryL,G0H32(27),32,0,G1H32(24),n2h32(56))
  Gcoeff(:)%j = (-(c(74)*M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(120),h0tab(:,120),[32,3,8,16,4],[0,0,nMZ,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(32),m3h2x32(:,120),heltab2x64(:,:,120))
  call Hloop_A_Q(ntryL,G0H32(32),32,0,G1H32(20),n2h32(57))
  Gcoeff(:)%j = (c(77)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(121),h0tab(:,121),[32,3,8,16,4],[0,0,0,0,nMZ],5,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(29),ngZd,m3h2x32(:,121),heltab2x64(:,:,121))
  call Hloop_A_Q(ntryL,G0H32(29),32,0,G1H32(25),n2h32(58))
  Gcoeff(:)%j = (c(79)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(122),h0tab(:,122),[32,3,8,16,4],[0,0,nMZ,0,nMZ],5,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(30),ngZd,m3h2x32(:,122),heltab2x64(:,:,122))
  call Hloop_A_Q(ntryL,G0H32(30),32,0,G1H32(22),n2h32(59))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)+c(82)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(123),h0tab(:,123),[32,3,8,16,4],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(38),m3h2x32(:,123),heltab2x64(:,:,123))
  call Hloop_A_Q(ntryL,G0H32(38),32,0,G1H32(23),n2h32(60))
  Gcoeff(:)%j = (c(88)*M(1,:)%j-c(87)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(124),h0tab(:,124),[32,3,8,16,4],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(34),m3h2x32(:,124),heltab2x64(:,:,124))
  call Hloop_A_Q(ntryL,G0H32(34),32,0,G1H32(30),n2h32(61))
  Gcoeff(:)%j = (c(94)*M(1,:)%j-c(93)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(125),h0tab(:,125),[32,3,8,16,4],[0,0,0,0,nMZ],5,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(39),ngZd,m3h2x32(:,125),heltab2x64(:,:,125))
  call Hloop_A_Q(ntryL,G0H32(39),32,0,G1H32(27),n2h32(62))
  Gcoeff(:)%j = (c(94)*M(1,:)%j-c(93)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(126),h0tab(:,126),[32,3,8,16,4],[0,0,nMZ,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(36),m3h2x32(:,126),heltab2x64(:,:,126))
  call Hloop_A_Q(ntryL,G0H32(36),32,0,G1H32(28),n2h32(63))
  Gcoeff(:)%j = (-(c(75)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(127),h0tab(:,127),[32,3,8,16,4],[nMW,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(37),m3h2x32(:,127),heltab2x64(:,:,127))
  Gcoeff(:)%j = (-(c(57)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(128),h0tab(:,128),[32,3,8,16,4],[nMW,nMZ,0,0,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(44),m3h2x32(:,128),heltab2x64(:,:,128))
  Gcoeff(:)%j = (-(c(78)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(129),h0tab(:,129),[32,3,8,16,4],[nMW,0,0,nMZ,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(41),m3h2x32(:,129),heltab2x64(:,:,129))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(130),h0tab(:,130),[32,3,8,16,4],[nMW,nMZ,0,nMZ,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(45),m3h2x32(:,130),heltab2x64(:,:,130))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(131),h0tab(:,131),[32,3,8,16,4],[0,nMW,0,nMW,0],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(43),m3h2x32(:,131),heltab2x64(:,:,131))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(132),h0tab(:,132),[32,3,8,16,4],[nMZ,nMW,0,nMW,0],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(50),ngZd,m3h2x32(:,132),heltab2x64(:,:,132))
  Gcoeff(:)%j = (c(90)*M(1,:)%j-c(91)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(133),h0tab(:,133),[32,3,8,16,4],[nMW,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(47),m3h2x32(:,133),heltab2x64(:,:,133))
  Gcoeff(:)%j = (c(60)*M(1,:)%j-c(61)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(134),h0tab(:,134),[32,3,8,16,4],[nMW,nMZ,0,0,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(51),m3h2x32(:,134),heltab2x64(:,:,134))
  Gcoeff(:)%j = (c(23)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(135),h0tab(:,135),[32,4,16,3,8],[0,nMW,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(49),m3h2x32(:,135),heltab2x64(:,:,135))
  call Hloop_A_Q(ntryL,G0H32(49),32,0,G1H32(29),n2h32(64))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(136),h0tab(:,136),[32,4,16,3,8],[0,nMW,0,0,nMZ],5,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(23),ngZd,m3h2x32(:,136),heltab2x64(:,:,136))
  call Hloop_A_Q(ntryL,G0H32(23),32,0,G1H32(33),n2h32(65))
  Gcoeff(:)%j = (c(37)*M(1,:)%j-c(38)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(137),h0tab(:,137),[32,4,16,3,8],[0,nMW,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(26),m3h2x32(:,137),heltab2x64(:,:,137))
  call Hloop_A_Q(ntryL,G0H32(26),32,0,G1H32(32),n2h32(66))
  Gcoeff(:)%j = (-(c(72)*M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(138),h0tab(:,138),[32,4,16,3,8],[0,0,0,nMW,0],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(28),m3h2x32(:,138),heltab2x64(:,:,138))
  Gcoeff(:)%j = (-(c(55)*M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(139),h0tab(:,139),[32,4,16,3,8],[0,0,nMZ,nMW,0],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(33),m3h2x32(:,139),heltab2x64(:,:,139))
  Gcoeff(:)%j = (c(78)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(140),h0tab(:,140),[32,4,16,3,8],[nMZ,0,0,nMW,0],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(35),ngZd,m3h2x32(:,140),heltab2x64(:,:,140))
  Gcoeff(:)%j = (c(59)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(141),h0tab(:,141),[32,4,16,3,8],[nMZ,0,nMZ,nMW,0],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(40),ngZd,m3h2x32(:,141),heltab2x64(:,:,141))
  Gcoeff(:)%j = (c(91)*M(1,:)%j-c(90)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(142),h0tab(:,142),[32,4,16,3,8],[0,0,0,nMW,0],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(42),m3h2x32(:,142),heltab2x64(:,:,142))
  Gcoeff(:)%j = (c(61)*M(1,:)%j-c(60)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(143),h0tab(:,143),[32,4,16,3,8],[0,0,nMZ,nMW,0],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(46),m3h2x32(:,143),heltab2x64(:,:,143))
  Gcoeff(:)%j = (c(70)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(144),h0tab(:,144),[32,3,4,16,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,144),heltab2x64(:,:,144))
  call Hloop_A_Q(ntryL,G0H32(7),32,0,G1H32(34),n2h32(67))
  Gcoeff(:)%j = (-(c(77)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(145),h0tab(:,145),[32,3,4,16,8],[0,0,0,0,nMZ],5,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(11),ngZd,m3h2x32(:,145),heltab2x64(:,:,145))
  call Hloop_A_Q(ntryL,G0H32(11),32,0,G1H32(35),n2h32(68))
  Gcoeff(:)%j = (c(74)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(146),h0tab(:,146),[32,3,4,16,8],[0,0,nMZ,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,146),heltab2x64(:,:,146))
  call Hloop_A_Q(ntryL,G0H32(9),32,0,G1H32(36),n2h32(69))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(147),h0tab(:,147),[32,3,4,16,8],[0,0,nMZ,0,nMZ],5,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(16),ngZd,m3h2x32(:,147),heltab2x64(:,:,147))
  call Hloop_A_Q(ntryL,G0H32(16),32,0,G1H32(37),n2h32(70))
  Gcoeff(:)%j = (c(87)*M(1,:)%j-c(88)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(148),h0tab(:,148),[32,3,4,16,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(13),m3h2x32(:,148),heltab2x64(:,:,148))
  call Hloop_A_Q(ntryL,G0H32(13),32,0,G1H32(38),n2h32(71))
  Gcoeff(:)%j = (-(c(82)*M(1,:)%j)+c(83)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(149),h0tab(:,149),[32,3,4,16,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(14),m3h2x32(:,149),heltab2x64(:,:,149))
  call Hloop_A_Q(ntryL,G0H32(14),32,0,G1H32(39),n2h32(72))
  Gcoeff(:)%j = (c(93)*M(1,:)%j-c(94)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(150),h0tab(:,150),[32,3,4,16,8],[0,0,nMZ,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(15),m3h2x32(:,150),heltab2x64(:,:,150))
  call Hloop_A_Q(ntryL,G0H32(15),32,0,G1H32(40),n2h32(73))
  Gcoeff(:)%j = (c(93)*M(1,:)%j-c(94)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(151),h0tab(:,151),[32,3,4,16,8],[0,0,0,0,nMZ],5,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(19),ngZd,m3h2x32(:,151),heltab2x64(:,:,151))
  call Hloop_A_Q(ntryL,G0H32(19),32,0,G1H32(41),n2h32(74))
  Gcoeff(:)%j = (c(75)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(152),h0tab(:,152),[32,3,4,16,8],[nMW,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(18),m3h2x32(:,152),heltab2x64(:,:,152))
  Gcoeff(:)%j = (c(78)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(153),h0tab(:,153),[32,3,4,16,8],[nMW,0,0,nMZ,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(22),m3h2x32(:,153),heltab2x64(:,:,153))
  Gcoeff(:)%j = (c(57)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(154),h0tab(:,154),[32,3,4,16,8],[nMW,nMZ,0,0,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(21),m3h2x32(:,154),heltab2x64(:,:,154))
  Gcoeff(:)%j = (c(59)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(155),h0tab(:,155),[32,3,4,16,8],[nMW,nMZ,0,nMZ,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,155),heltab2x64(:,:,155))
  Gcoeff(:)%j = (-(c(24)*M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(156),h0tab(:,156),[32,3,4,16,8],[0,nMW,0,nMW,0],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(24),m3h2x32(:,156),heltab2x64(:,:,156))
  Gcoeff(:)%j = (c(15)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(157),h0tab(:,157),[32,3,4,16,8],[nMZ,nMW,0,nMW,0],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(31),ngZd,m3h2x32(:,157),heltab2x64(:,:,157))
  Gcoeff(:)%j = (c(91)*M(1,:)%j-c(90)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(158),h0tab(:,158),[32,3,4,16,8],[nMW,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(27),m3h2x32(:,158),heltab2x64(:,:,158))
  Gcoeff(:)%j = (c(61)*M(1,:)%j-c(60)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(159),h0tab(:,159),[32,3,4,16,8],[nMW,nMZ,0,0,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(32),m3h2x32(:,159),heltab2x64(:,:,159))
  Gcoeff(:)%j = (-(c(72)*M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(160),h0tab(:,160),[32,8,3,4,16],[0,nMW,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(29),m3h2x32(:,160),heltab2x64(:,:,160))
  call Hloop_A_Q(ntryL,G0H32(29),32,0,G1H32(42),n2h32(75))
  Gcoeff(:)%j = (c(78)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(161),h0tab(:,161),[32,8,3,4,16],[0,nMW,0,0,nMZ],5,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(30),ngZd,m3h2x32(:,161),heltab2x64(:,:,161))
  call Hloop_A_Q(ntryL,G0H32(30),32,0,G1H32(43),n2h32(76))
  Gcoeff(:)%j = (-(c(55)*M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(162),h0tab(:,162),[32,8,3,4,16],[0,nMW,nMZ,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(38),m3h2x32(:,162),heltab2x64(:,:,162))
  call Hloop_A_Q(ntryL,G0H32(38),32,0,G1H32(44),n2h32(77))
  Gcoeff(:)%j = (c(59)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(163),h0tab(:,163),[32,8,3,4,16],[0,nMW,nMZ,0,nMZ],5,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(34),ngZd,m3h2x32(:,163),heltab2x64(:,:,163))
  call Hloop_A_Q(ntryL,G0H32(34),32,0,G1H32(45),n2h32(78))
  Gcoeff(:)%j = (c(27)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(164),h0tab(:,164),[32,8,3,4,16],[0,0,nMW,0,nMW],5,1,wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(39),m3h2x32(:,164),heltab2x64(:,:,164))
  call Hloop_A_Q(ntryL,G0H32(39),32,0,G1H32(46),n2h32(79))
  Gcoeff(:)%j = (c(15)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(165),h0tab(:,165),[32,8,3,4,16],[0,nMZ,nMW,0,nMW],5,1,wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(36),m3h2x32(:,165),heltab2x64(:,:,165))
  call Hloop_A_Q(ntryL,G0H32(36),32,0,G1H32(47),n2h32(80))
  Gcoeff(:)%j = (c(91)*M(1,:)%j-c(90)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(166),h0tab(:,166),[32,8,3,4,16],[0,nMW,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(49),m3h2x32(:,166),heltab2x64(:,:,166))
  call Hloop_A_Q(ntryL,G0H32(49),32,0,G1H32(48),n2h32(81))
  Gcoeff(:)%j = (c(61)*M(1,:)%j-c(60)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(167),h0tab(:,167),[32,8,3,4,16],[0,nMW,nMZ,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(23),m3h2x32(:,167),heltab2x64(:,:,167))
  call Hloop_A_Q(ntryL,G0H32(23),32,0,G1H32(49),n2h32(82))
  Gcoeff(:)%j = (-(c(23)*M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(168),h0tab(:,168),[32,4,3,16,8],[0,0,0,nMW,0],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(26),m3h2x32(:,168),heltab2x64(:,:,168))
  Gcoeff(:)%j = (c(28)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(169),h0tab(:,169),[32,4,3,16,8],[nMZ,0,0,nMW,0],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(7),ngZd,m3h2x32(:,169),heltab2x64(:,:,169))
  Gcoeff(:)%j = (c(38)*M(1,:)%j-c(37)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(170),h0tab(:,170),[32,4,3,16,8],[0,0,0,nMW,0],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(11),m3h2x32(:,170),heltab2x64(:,:,170))
  Gcoeff(:)%j = (c(72)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(171),h0tab(:,171),[32,4,3,16,8],[0,nMW,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,171),heltab2x64(:,:,171))
  call Hloop_A_Q(ntryL,G0H32(9),32,0,G1H32(50),n2h32(83))
  Gcoeff(:)%j = (c(55)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(172),h0tab(:,172),[32,4,3,16,8],[0,nMW,nMZ,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(16),m3h2x32(:,172),heltab2x64(:,:,172))
  call Hloop_A_Q(ntryL,G0H32(16),32,0,G1H32(51),n2h32(84))
  Gcoeff(:)%j = (-(c(78)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(173),h0tab(:,173),[32,4,3,16,8],[0,nMW,0,0,nMZ],5,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(13),ngZd,m3h2x32(:,173),heltab2x64(:,:,173))
  call Hloop_A_Q(ntryL,G0H32(13),32,0,G1H32(52),n2h32(85))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(174),h0tab(:,174),[32,4,3,16,8],[0,nMW,nMZ,0,nMZ],5,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(14),ngZd,m3h2x32(:,174),heltab2x64(:,:,174))
  call Hloop_A_Q(ntryL,G0H32(14),32,0,G1H32(53),n2h32(86))
  Gcoeff(:)%j = (c(90)*M(1,:)%j-c(91)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(175),h0tab(:,175),[32,4,3,16,8],[0,nMW,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(15),m3h2x32(:,175),heltab2x64(:,:,175))
  call Hloop_A_Q(ntryL,G0H32(15),32,0,G1H32(54),n2h32(87))
  Gcoeff(:)%j = (c(60)*M(1,:)%j-c(61)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(176),h0tab(:,176),[32,4,3,16,8],[0,nMW,nMZ,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(19),m3h2x32(:,176),heltab2x64(:,:,176))
  call Hloop_A_Q(ntryL,G0H32(19),32,0,G1H32(55),n2h32(88))
  Gcoeff(:)%j = (c(72)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(177),h0tab(:,177),[32,4,3,8,16],[0,nMW,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(29),m3h2x32(:,177),heltab2x64(:,:,177))
  call Hloop_A_Q(ntryL,G0H32(29),32,0,G1H32(56),n2h32(89))
  Gcoeff(:)%j = (-(c(78)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(178),h0tab(:,178),[32,4,3,8,16],[0,nMW,0,0,nMZ],5,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(30),ngZd,m3h2x32(:,178),heltab2x64(:,:,178))
  call Hloop_A_Q(ntryL,G0H32(30),32,0,G1H32(57),n2h32(90))
  Gcoeff(:)%j = (c(55)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(179),h0tab(:,179),[32,4,3,8,16],[0,nMW,nMZ,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(38),m3h2x32(:,179),heltab2x64(:,:,179))
  call Hloop_A_Q(ntryL,G0H32(38),32,0,G1H32(58),n2h32(91))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(180),h0tab(:,180),[32,4,3,8,16],[0,nMW,nMZ,0,nMZ],5,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(34),ngZd,m3h2x32(:,180),heltab2x64(:,:,180))
  call Hloop_A_Q(ntryL,G0H32(34),32,0,G1H32(59),n2h32(92))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(181),h0tab(:,181),[32,4,3,8,16],[0,0,nMW,0,nMW],5,1,wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(39),m3h2x32(:,181),heltab2x64(:,:,181))
  call Hloop_A_Q(ntryL,G0H32(39),32,0,G1H32(60),n2h32(93))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(182),h0tab(:,182),[32,4,3,8,16],[0,nMZ,nMW,0,nMW],5,1,wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(36),m3h2x32(:,182),heltab2x64(:,:,182))
  call Hloop_A_Q(ntryL,G0H32(36),32,0,G1H32(61),n2h32(94))
  Gcoeff(:)%j = (c(90)*M(1,:)%j-c(91)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(183),h0tab(:,183),[32,4,3,8,16],[0,nMW,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(49),m3h2x32(:,183),heltab2x64(:,:,183))
  call Hloop_A_Q(ntryL,G0H32(49),32,0,G1H32(62),n2h32(95))
  Gcoeff(:)%j = (c(60)*M(1,:)%j-c(61)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(184),h0tab(:,184),[32,4,3,8,16],[0,nMW,nMZ,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(23),m3h2x32(:,184),heltab2x64(:,:,184))
  call Hloop_A_Q(ntryL,G0H32(23),32,0,G1H32(63),n2h32(96))
  Gcoeff(:)%j = (-(c(69)*M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(185),h0tab(:,185),[32,2,1,8,20],[0,0,nMW,0,0],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,185),heltab2x64(:,:,185))
  Gcoeff(:)%j = (c(77)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(186),h0tab(:,186),[32,2,1,8,20],[nMW,0,nMZ,0,0],5,1,wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(16),m3h2x32(:,186),heltab2x64(:,:,186))
  Gcoeff(:)%j = (-(c(74)*M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(187),h0tab(:,187),[32,2,1,8,20],[nMZ,0,nMW,0,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(13),ngZd,m3h2x32(:,187),heltab2x64(:,:,187))
  Gcoeff(:)%j = (c(76)*M(4,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(188),h0tab(:,188),[32,2,1,8,20],[0,0,nMW,0,0],5,1,wf4(:,4))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(14),m3h2x32(:,188),heltab2x64(:,:,188))
  Gcoeff(:)%j = (c(79)*M(4,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(189),h0tab(:,189),[32,2,1,8,20],[nMW,0,nMZ,0,0],5,1,wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(15),m3h2x32(:,189),heltab2x64(:,:,189))
  Gcoeff(:)%j = (c(79)*M(4,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(190),h0tab(:,190),[32,2,1,8,20],[nMZ,0,nMW,0,0],5,1,wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(19),ngZd,m3h2x32(:,190),heltab2x64(:,:,190))
  Gcoeff(:)%j = (c(86)*M(1,:)%j-c(85)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(191),h0tab(:,191),[32,2,1,8,20],[0,0,nMW,0,0],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(29),m3h2x32(:,191),heltab2x64(:,:,191))
  Gcoeff(:)%j = (c(94)*M(1,:)%j-c(93)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(192),h0tab(:,192),[32,2,1,8,20],[nMW,0,nMZ,0,0],5,1,wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(30),m3h2x32(:,192),heltab2x64(:,:,192))
  Gcoeff(:)%j = (c(94)*M(1,:)%j-c(93)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(193),h0tab(:,193),[32,2,1,8,20],[nMZ,0,nMW,0,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(38),ngZd,m3h2x32(:,193),heltab2x64(:,:,193))
  Gcoeff(:)%j = (c(78)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(194),h0tab(:,194),[32,8,1,2,20],[0,nMZ,0,nMW,nMW],5,1,wf4(:,2))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(34),m3h2x32(:,194),heltab2x64(:,:,194))
  call Hloop_A_Q(ntryL,G0H32(34),32,0,G1H32(64),n2h32(97))
  Gcoeff(:)%j = (c(59)*M(4,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(195),h0tab(:,195),[32,8,1,2,20],[0,nMZ,0,nMW,nMW],5,1,wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(39),m3h2x32(:,195),heltab2x64(:,:,195))
  call Hloop_A_Q(ntryL,G0H32(39),32,0,G1H32(65),n2h32(98))
  Gcoeff(:)%j = (-(c(75)*M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(196),h0tab(:,196),[32,1,2,8,20],[nMW,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(36),m3h2x32(:,196),heltab2x64(:,:,196))
  Gcoeff(:)%j = (c(77)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(197),h0tab(:,197),[32,1,2,8,20],[nMW,0,nMZ,0,0],5,1,wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(49),m3h2x32(:,197),heltab2x64(:,:,197))
  Gcoeff(:)%j = (-(c(74)*M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(198),h0tab(:,198),[32,1,2,8,20],[nMZ,0,nMW,0,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(23),ngZd,m3h2x32(:,198),heltab2x64(:,:,198))
  Gcoeff(:)%j = (-(c(78)*M(4,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(199),h0tab(:,199),[32,1,2,8,20],[nMW,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(34),m3h2x32(:,199),heltab2x64(:,:,199))
  Gcoeff(:)%j = (c(79)*M(4,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(200),h0tab(:,200),[32,1,2,8,20],[nMW,0,nMZ,0,0],5,1,wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(39),m3h2x32(:,200),heltab2x64(:,:,200))
  Gcoeff(:)%j = (c(79)*M(4,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(201),h0tab(:,201),[32,1,2,8,20],[nMZ,0,nMW,0,0],5,1,wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(52),ngZd,m3h2x32(:,201),heltab2x64(:,:,201))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)+c(90)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(202),h0tab(:,202),[32,1,2,8,20],[nMW,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,202),heltab2x64(:,:,202))
  Gcoeff(:)%j = (c(94)*M(1,:)%j-c(93)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(203),h0tab(:,203),[32,1,2,8,20],[nMW,0,nMZ,0,0],5,1,wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(54),m3h2x32(:,203),heltab2x64(:,:,203))
  Gcoeff(:)%j = (c(94)*M(1,:)%j-c(93)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(204),h0tab(:,204),[32,1,2,8,20],[nMZ,0,nMW,0,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(55),ngZd,m3h2x32(:,204),heltab2x64(:,:,204))
  Gcoeff(:)%j = (c(78)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(205),h0tab(:,205),[32,1,2,20,8],[nMZ,0,nMW,nMW,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(56),ngZd,m3h2x32(:,205),heltab2x64(:,:,205))
  Gcoeff(:)%j = (c(59)*M(4,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(206),h0tab(:,206),[32,1,2,20,8],[nMZ,0,nMW,nMW,0],5,1,wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(57),ngZd,m3h2x32(:,206),heltab2x64(:,:,206))
  Gcoeff(:)%j = (-(c(77)*M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(207),h0tab(:,207),[32,8,2,1,20],[0,0,0,nMW,nMW],5,1,wf4(:,2))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(58),m3h2x32(:,207),heltab2x64(:,:,207))
  call Hloop_A_Q(ntryL,G0H32(58),32,0,G1H32(66),n2h32(99))
  Gcoeff(:)%j = (c(78)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(208),h0tab(:,208),[32,8,2,1,20],[0,nMZ,0,nMW,nMW],5,1,wf4(:,2))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(58),m3h2x32(:,208),heltab2x64(:,:,208))
  call Hloop_A_Q(ntryL,G0H32(58),32,0,G1H32(67),n2h32(100))
  Gcoeff(:)%j = (-(c(58)*M(4,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(209),h0tab(:,209),[32,8,2,1,20],[0,0,0,nMW,nMW],5,1,wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(58),m3h2x32(:,209),heltab2x64(:,:,209))
  call Hloop_A_Q(ntryL,G0H32(58),32,0,G1H32(68),n2h32(101))
  Gcoeff(:)%j = (c(59)*M(4,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(210),h0tab(:,210),[32,8,2,1,20],[0,nMZ,0,nMW,nMW],5,1,wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(58),m3h2x32(:,210),heltab2x64(:,:,210))
  call Hloop_A_Q(ntryL,G0H32(58),32,0,G1H32(69),n2h32(102))
  Gcoeff(:)%j = (c(74)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(211),h0tab(:,211),[32,2,1,20,8],[0,0,nMW,nMW,0],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(58),m3h2x32(:,211),heltab2x64(:,:,211))
  Gcoeff(:)%j = (c(78)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(212),h0tab(:,212),[32,2,1,20,8],[nMZ,0,nMW,nMW,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(59),ngZd,m3h2x32(:,212),heltab2x64(:,:,212))
  Gcoeff(:)%j = (c(56)*M(4,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(213),h0tab(:,213),[32,2,1,20,8],[0,0,nMW,nMW,0],5,1,wf4(:,4))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(60),m3h2x32(:,213),heltab2x64(:,:,213))
  Gcoeff(:)%j = (c(59)*M(4,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(214),h0tab(:,214),[32,2,1,20,8],[nMZ,0,nMW,nMW,0],5,1,wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(61),ngZd,m3h2x32(:,214),heltab2x64(:,:,214))
  Gcoeff(:)%j = (-(c(74)*M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(215),h0tab(:,215),[32,2,20,1,8],[0,0,0,nMW,0],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(62),m3h2x32(:,215),heltab2x64(:,:,215))
  Gcoeff(:)%j = (-(c(78)*M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(216),h0tab(:,216),[32,2,20,1,8],[nMZ,0,0,nMW,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(63),ngZd,m3h2x32(:,216),heltab2x64(:,:,216))
  Gcoeff(:)%j = (c(76)*M(4,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(217),h0tab(:,217),[32,2,20,1,8],[0,0,0,nMW,0],5,1,wf4(:,4))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(64),m3h2x32(:,217),heltab2x64(:,:,217))
  Gcoeff(:)%j = (c(79)*M(4,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(218),h0tab(:,218),[32,2,20,1,8],[nMW,0,0,nMZ,0],5,1,wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,218),heltab2x64(:,:,218))
  Gcoeff(:)%j = (c(79)*M(4,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(219),h0tab(:,219),[32,2,20,1,8],[nMZ,0,0,nMW,0],5,1,wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(66),ngZd,m3h2x32(:,219),heltab2x64(:,:,219))
  Gcoeff(:)%j = (c(77)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(220),h0tab(:,220),[32,1,20,2,8],[nMW,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(67),m3h2x32(:,220),heltab2x64(:,:,220))
  Gcoeff(:)%j = (-(c(78)*M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(221),h0tab(:,221),[32,1,20,2,8],[nMW,0,0,nMZ,0],5,1,wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(68),m3h2x32(:,221),heltab2x64(:,:,221))
  Gcoeff(:)%j = (-(c(78)*M(4,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(222),h0tab(:,222),[32,1,20,2,8],[nMW,0,0,0,0],5,1,wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(69),m3h2x32(:,222),heltab2x64(:,:,222))
  Gcoeff(:)%j = (c(79)*M(4,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(223),h0tab(:,223),[32,1,20,2,8],[nMW,0,0,nMZ,0],5,1,wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(70),m3h2x32(:,223),heltab2x64(:,:,223))
  Gcoeff(:)%j = (c(79)*M(4,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(224),h0tab(:,224),[32,1,20,2,8],[nMZ,0,0,nMW,0],5,1,wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(71),ngZd,m3h2x32(:,224),heltab2x64(:,:,224))
  Gcoeff(:)%j = (c(69)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(225),h0tab(:,225),[32,2,1,4,24],[0,0,nMW,0,0],5,1,wf4(:,6))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(72),m3h2x32(:,225),heltab2x64(:,:,225))
  Gcoeff(:)%j = (-(c(77)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(226),h0tab(:,226),[32,2,1,4,24],[nMW,0,nMZ,0,0],5,1,wf4(:,6))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(73),m3h2x32(:,226),heltab2x64(:,:,226))
  Gcoeff(:)%j = (c(74)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(227),h0tab(:,227),[32,2,1,4,24],[nMZ,0,nMW,0,0],5,1,wf4(:,6))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(74),ngZd,m3h2x32(:,227),heltab2x64(:,:,227))
  Gcoeff(:)%j = (-(c(76)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(228),h0tab(:,228),[32,2,1,4,24],[0,0,nMW,0,0],5,1,wf4(:,7))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(75),m3h2x32(:,228),heltab2x64(:,:,228))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(229),h0tab(:,229),[32,2,1,4,24],[nMW,0,nMZ,0,0],5,1,wf4(:,7))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(76),m3h2x32(:,229),heltab2x64(:,:,229))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(230),h0tab(:,230),[32,2,1,4,24],[nMZ,0,nMW,0,0],5,1,wf4(:,7))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(77),ngZd,m3h2x32(:,230),heltab2x64(:,:,230))
  Gcoeff(:)%j = (c(85)*M(1,:)%j-c(86)*M(3,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(231),h0tab(:,231),[32,2,1,4,24],[0,0,nMW,0,0],5,1,wf4(:,6))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(78),m3h2x32(:,231),heltab2x64(:,:,231))
  Gcoeff(:)%j = (c(93)*M(1,:)%j-c(94)*M(3,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(232),h0tab(:,232),[32,2,1,4,24],[nMW,0,nMZ,0,0],5,1,wf4(:,6))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(79),m3h2x32(:,232),heltab2x64(:,:,232))
  Gcoeff(:)%j = (c(93)*M(1,:)%j-c(94)*M(3,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(233),h0tab(:,233),[32,2,1,4,24],[nMZ,0,nMW,0,0],5,1,wf4(:,6))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(80),ngZd,m3h2x32(:,233),heltab2x64(:,:,233))
  Gcoeff(:)%j = (-(c(78)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(234),h0tab(:,234),[32,4,1,2,24],[0,nMZ,0,nMW,nMW],5,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(81),m3h2x32(:,234),heltab2x64(:,:,234))
  call Hloop_A_Q(ntryL,G0H32(81),32,0,G1H32(70),n2h32(103))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(235),h0tab(:,235),[32,4,1,2,24],[0,nMZ,0,nMW,nMW],5,1,wf4(:,7))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(81),m3h2x32(:,235),heltab2x64(:,:,235))
  call Hloop_A_Q(ntryL,G0H32(81),32,0,G1H32(71),n2h32(104))
  Gcoeff(:)%j = (c(75)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(236),h0tab(:,236),[32,1,2,4,24],[nMW,0,0,0,0],5,1,wf4(:,6))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(81),m3h2x32(:,236),heltab2x64(:,:,236))
  Gcoeff(:)%j = (-(c(77)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(237),h0tab(:,237),[32,1,2,4,24],[nMW,0,nMZ,0,0],5,1,wf4(:,6))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(82),m3h2x32(:,237),heltab2x64(:,:,237))
  Gcoeff(:)%j = (c(74)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(238),h0tab(:,238),[32,1,2,4,24],[nMZ,0,nMW,0,0],5,1,wf4(:,6))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(83),ngZd,m3h2x32(:,238),heltab2x64(:,:,238))
  Gcoeff(:)%j = (c(78)*M(2,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(239),h0tab(:,239),[32,1,2,4,24],[nMW,0,0,0,0],5,1,wf4(:,7))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(84),m3h2x32(:,239),heltab2x64(:,:,239))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(240),h0tab(:,240),[32,1,2,4,24],[nMW,0,nMZ,0,0],5,1,wf4(:,7))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(85),m3h2x32(:,240),heltab2x64(:,:,240))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(241),h0tab(:,241),[32,1,2,4,24],[nMZ,0,nMW,0,0],5,1,wf4(:,7))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(86),ngZd,m3h2x32(:,241),heltab2x64(:,:,241))
  Gcoeff(:)%j = (-(c(90)*M(1,:)%j)+c(91)*M(3,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(242),h0tab(:,242),[32,1,2,4,24],[nMW,0,0,0,0],5,1,wf4(:,6))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(87),m3h2x32(:,242),heltab2x64(:,:,242))
  Gcoeff(:)%j = (c(93)*M(1,:)%j-c(94)*M(3,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(243),h0tab(:,243),[32,1,2,4,24],[nMW,0,nMZ,0,0],5,1,wf4(:,6))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(88),m3h2x32(:,243),heltab2x64(:,:,243))
  Gcoeff(:)%j = (c(93)*M(1,:)%j-c(94)*M(3,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(244),h0tab(:,244),[32,1,2,4,24],[nMZ,0,nMW,0,0],5,1,wf4(:,6))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(89),ngZd,m3h2x32(:,244),heltab2x64(:,:,244))
  Gcoeff(:)%j = (-(c(78)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(245),h0tab(:,245),[32,1,2,24,4],[nMZ,0,nMW,nMW,0],5,1,wf4(:,6))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(90),ngZd,m3h2x32(:,245),heltab2x64(:,:,245))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(246),h0tab(:,246),[32,1,2,24,4],[nMZ,0,nMW,nMW,0],5,1,wf4(:,7))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(91),ngZd,m3h2x32(:,246),heltab2x64(:,:,246))
  Gcoeff(:)%j = (c(77)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(247),h0tab(:,247),[32,4,2,1,24],[0,0,0,nMW,nMW],5,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(92),m3h2x32(:,247),heltab2x64(:,:,247))
  call Hloop_A_Q(ntryL,G0H32(92),32,0,G1H32(72),n2h32(105))
  Gcoeff(:)%j = (-(c(78)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(248),h0tab(:,248),[32,4,2,1,24],[0,nMZ,0,nMW,nMW],5,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(92),m3h2x32(:,248),heltab2x64(:,:,248))
  call Hloop_A_Q(ntryL,G0H32(92),32,0,G1H32(73),n2h32(106))
  Gcoeff(:)%j = (c(58)*M(2,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(249),h0tab(:,249),[32,4,2,1,24],[0,0,0,nMW,nMW],5,1,wf4(:,7))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(92),m3h2x32(:,249),heltab2x64(:,:,249))
  call Hloop_A_Q(ntryL,G0H32(92),32,0,G1H32(74),n2h32(107))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(250),h0tab(:,250),[32,4,2,1,24],[0,nMZ,0,nMW,nMW],5,1,wf4(:,7))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(92),m3h2x32(:,250),heltab2x64(:,:,250))
  call Hloop_A_Q(ntryL,G0H32(92),32,0,G1H32(75),n2h32(108))
  Gcoeff(:)%j = (-(c(74)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(251),h0tab(:,251),[32,2,1,24,4],[0,0,nMW,nMW,0],5,1,wf4(:,6))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(92),m3h2x32(:,251),heltab2x64(:,:,251))
  Gcoeff(:)%j = (-(c(78)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(252),h0tab(:,252),[32,2,1,24,4],[nMZ,0,nMW,nMW,0],5,1,wf4(:,6))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(93),ngZd,m3h2x32(:,252),heltab2x64(:,:,252))
  Gcoeff(:)%j = (-(c(56)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(253),h0tab(:,253),[32,2,1,24,4],[0,0,nMW,nMW,0],5,1,wf4(:,7))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(94),m3h2x32(:,253),heltab2x64(:,:,253))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(254),h0tab(:,254),[32,2,1,24,4],[nMZ,0,nMW,nMW,0],5,1,wf4(:,7))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(95),ngZd,m3h2x32(:,254),heltab2x64(:,:,254))
  Gcoeff(:)%j = (c(74)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(255),h0tab(:,255),[32,2,24,1,4],[0,0,0,nMW,0],5,1,wf4(:,6))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(96),m3h2x32(:,255),heltab2x64(:,:,255))
  Gcoeff(:)%j = (c(78)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(256),h0tab(:,256),[32,2,24,1,4],[nMZ,0,0,nMW,0],5,1,wf4(:,6))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(97),ngZd,m3h2x32(:,256),heltab2x64(:,:,256))
  Gcoeff(:)%j = (-(c(76)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(257),h0tab(:,257),[32,2,24,1,4],[0,0,0,nMW,0],5,1,wf4(:,7))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(98),m3h2x32(:,257),heltab2x64(:,:,257))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(258),h0tab(:,258),[32,2,24,1,4],[nMW,0,0,nMZ,0],5,1,wf4(:,7))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(99),m3h2x32(:,258),heltab2x64(:,:,258))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(259),h0tab(:,259),[32,2,24,1,4],[nMZ,0,0,nMW,0],5,1,wf4(:,7))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(100),ngZd,m3h2x32(:,259),heltab2x64(:,:,259))
  Gcoeff(:)%j = (-(c(77)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(260),h0tab(:,260),[32,1,24,2,4],[nMW,0,0,0,0],5,1,wf4(:,6))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(101),m3h2x32(:,260),heltab2x64(:,:,260))
  Gcoeff(:)%j = (c(78)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(261),h0tab(:,261),[32,1,24,2,4],[nMW,0,0,nMZ,0],5,1,wf4(:,6))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(102),m3h2x32(:,261),heltab2x64(:,:,261))
  Gcoeff(:)%j = (c(78)*M(2,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(262),h0tab(:,262),[32,1,24,2,4],[nMW,0,0,0,0],5,1,wf4(:,7))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(103),m3h2x32(:,262),heltab2x64(:,:,262))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(263),h0tab(:,263),[32,1,24,2,4],[nMW,0,0,nMZ,0],5,1,wf4(:,7))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(104),m3h2x32(:,263),heltab2x64(:,:,263))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(264),h0tab(:,264),[32,1,24,2,4],[nMZ,0,0,nMW,0],5,1,wf4(:,7))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(105),ngZd,m3h2x32(:,264),heltab2x64(:,:,264))
  Gcoeff(:)%j = (c(27)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(265),h0tab(:,265),[36,8,1,2,16],[0,nMW,0,0,0],5,1,wf4(:,5))
  call Hloop_AW_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,1),heltab2x64(:,:,265))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(1),n2h16(37))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(266),h0tab(:,266),[36,8,1,2,16],[0,nMW,0,nMZ,0],5,1,wf4(:,5))
  call Hloop_AW_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,2),heltab2x64(:,:,266))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(2),n2h16(38))
  Gcoeff(:)%j = (-(c(78)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(267),h0tab(:,267),[36,2,1,8,16],[nMW,0,nMZ,0,0],5,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),36,G1H16(3),m3h4x16(:,3),heltab2x64(:,:,267))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(268),h0tab(:,268),[36,2,1,8,16],[nMW,0,nMZ,0,nMZ],5,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),36,G1H16(4),m3h4x16(:,4),heltab2x64(:,:,268))
  Gcoeff(:)%j = (c(28)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(269),h0tab(:,269),[36,2,1,8,16],[0,0,nMW,0,nMW],5,1,wf4(:,5))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,5),36,G1H16(5),m3h4x16(:,5),heltab2x64(:,:,269))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(270),h0tab(:,270),[36,2,1,8,16],[nMZ,0,nMW,0,nMW],5,1,wf4(:,5))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,5),36,G1H16(6),m3h4x16(:,6),heltab2x64(:,:,270))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(271),h0tab(:,271),[36,8,2,1,16],[0,nMW,0,nMZ,0],5,1,wf4(:,5))
  call Hloop_AW_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,7),heltab2x64(:,:,271))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(7),n2h16(39))
  Gcoeff(:)%j = (-(c(78)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(272),h0tab(:,272),[36,2,1,16,8],[nMW,0,nMZ,0,0],5,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),36,G1H16(8),m3h4x16(:,8),heltab2x64(:,:,272))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(273),h0tab(:,273),[36,2,1,16,8],[nMW,0,nMZ,0,nMZ],5,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),36,G1H16(9),m3h4x16(:,9),heltab2x64(:,:,273))
  Gcoeff(:)%j = (c(77)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(274),h0tab(:,274),[36,1,2,8,16],[nMW,0,0,0,0],5,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),36,G1H16(10),m3h4x16(:,10),heltab2x64(:,:,274))
  Gcoeff(:)%j = (c(58)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(275),h0tab(:,275),[36,1,2,8,16],[nMW,0,0,0,nMZ],5,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),36,G1H16(11),m3h4x16(:,11),heltab2x64(:,:,275))
  Gcoeff(:)%j = (-(c(78)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(276),h0tab(:,276),[36,1,2,8,16],[nMW,0,nMZ,0,0],5,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),36,G1H16(12),m3h4x16(:,12),heltab2x64(:,:,276))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(277),h0tab(:,277),[36,1,2,8,16],[nMW,0,nMZ,0,nMZ],5,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),36,G1H16(13),m3h4x16(:,13),heltab2x64(:,:,277))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(278),h0tab(:,278),[36,1,2,8,16],[nMZ,0,nMW,0,nMW],5,1,wf4(:,5))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,5),36,G1H16(14),m3h4x16(:,14),heltab2x64(:,:,278))
  Gcoeff(:)%j = (c(77)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(279),h0tab(:,279),[36,1,2,16,8],[nMW,0,0,0,0],5,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),36,G1H16(15),m3h4x16(:,15),heltab2x64(:,:,279))
  Gcoeff(:)%j = (c(58)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(280),h0tab(:,280),[36,1,2,16,8],[nMW,0,0,0,nMZ],5,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),36,G1H16(16),m3h4x16(:,16),heltab2x64(:,:,280))
  Gcoeff(:)%j = (-(c(78)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(281),h0tab(:,281),[36,1,2,16,8],[nMW,0,nMZ,0,0],5,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),36,G1H16(17),m3h4x16(:,17),heltab2x64(:,:,281))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(282),h0tab(:,282),[36,1,2,16,8],[nMW,0,nMZ,0,nMZ],5,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),36,G1H16(18),m3h4x16(:,18),heltab2x64(:,:,282))
  Gcoeff(:)%j = (c(78)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(283),h0tab(:,283),[36,1,8,16,2],[0,nMZ,0,0,0],5,1,wf4(:,5))
  call Hloop_QW_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,19),heltab2x64(:,:,283))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(19),n2h16(40))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(284),h0tab(:,284),[36,1,8,16,2],[0,nMZ,0,nMZ,0],5,1,wf4(:,5))
  call Hloop_QW_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,20),heltab2x64(:,:,284))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(20),n2h16(41))
  Gcoeff(:)%j = (c(78)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(285),h0tab(:,285),[36,1,16,8,2],[0,nMZ,0,0,0],5,1,wf4(:,5))
  call Hloop_QW_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,21),heltab2x64(:,:,285))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(21),n2h16(42))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(286),h0tab(:,286),[36,1,16,8,2],[0,nMZ,0,nMZ,0],5,1,wf4(:,5))
  call Hloop_QW_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,22),heltab2x64(:,:,286))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(22),n2h16(43))
  Gcoeff(:)%j = (-(c(27)*M(4,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(287),h0tab(:,287),[40,4,1,2,16],[0,nMW,0,0,0],5,1,wf4(:,3))
  call Hloop_AW_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,23),heltab2x64(:,:,287))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(23),n2h16(44))
  Gcoeff(:)%j = (c(28)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(288),h0tab(:,288),[40,4,1,2,16],[0,nMW,0,nMZ,0],5,1,wf4(:,3))
  call Hloop_AW_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,24),heltab2x64(:,:,288))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(24),n2h16(45))
  Gcoeff(:)%j = (c(78)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(289),h0tab(:,289),[40,2,1,4,16],[nMW,0,nMZ,0,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),40,G1H16(25),m3h4x16(:,25),heltab2x64(:,:,289))
  Gcoeff(:)%j = (c(59)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(290),h0tab(:,290),[40,2,1,4,16],[nMW,0,nMZ,0,nMZ],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),40,G1H16(26),m3h4x16(:,26),heltab2x64(:,:,290))
  Gcoeff(:)%j = (-(c(28)*M(4,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(291),h0tab(:,291),[40,2,1,4,16],[0,0,nMW,0,nMW],5,1,wf4(:,3))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,3),40,G1H16(27),m3h4x16(:,27),heltab2x64(:,:,291))
  Gcoeff(:)%j = (c(15)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(292),h0tab(:,292),[40,2,1,4,16],[nMZ,0,nMW,0,nMW],5,1,wf4(:,3))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,3),40,G1H16(28),m3h4x16(:,28),heltab2x64(:,:,292))
  Gcoeff(:)%j = (c(28)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(293),h0tab(:,293),[40,4,2,1,16],[0,nMW,0,nMZ,0],5,1,wf4(:,3))
  call Hloop_AW_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,29),heltab2x64(:,:,293))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(29),n2h16(46))
  Gcoeff(:)%j = (c(78)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(294),h0tab(:,294),[40,2,1,16,4],[nMW,0,nMZ,0,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),40,G1H16(30),m3h4x16(:,30),heltab2x64(:,:,294))
  Gcoeff(:)%j = (c(59)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(295),h0tab(:,295),[40,2,1,16,4],[nMW,0,nMZ,0,nMZ],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),40,G1H16(31),m3h4x16(:,31),heltab2x64(:,:,295))
  Gcoeff(:)%j = (-(c(77)*M(4,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(296),h0tab(:,296),[40,1,2,4,16],[nMW,0,0,0,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),40,G1H16(32),m3h4x16(:,32),heltab2x64(:,:,296))
  Gcoeff(:)%j = (-(c(58)*M(4,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(297),h0tab(:,297),[40,1,2,4,16],[nMW,0,0,0,nMZ],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),40,G1H16(33),m3h4x16(:,33),heltab2x64(:,:,297))
  Gcoeff(:)%j = (c(78)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(298),h0tab(:,298),[40,1,2,4,16],[nMW,0,nMZ,0,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),40,G1H16(34),m3h4x16(:,34),heltab2x64(:,:,298))
  Gcoeff(:)%j = (c(59)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(299),h0tab(:,299),[40,1,2,4,16],[nMW,0,nMZ,0,nMZ],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),40,G1H16(35),m3h4x16(:,35),heltab2x64(:,:,299))
  Gcoeff(:)%j = (c(15)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(300),h0tab(:,300),[40,1,2,4,16],[nMZ,0,nMW,0,nMW],5,1,wf4(:,3))
  call Hloop_UW_V(ntryL,G0H64(1),0,wf4(:,3),40,G1H16(36),m3h4x16(:,36),heltab2x64(:,:,300))
  Gcoeff(:)%j = (-(c(77)*M(4,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(301),h0tab(:,301),[40,1,2,16,4],[nMW,0,0,0,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),40,G1H16(37),m3h4x16(:,37),heltab2x64(:,:,301))
  Gcoeff(:)%j = (-(c(58)*M(4,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(302),h0tab(:,302),[40,1,2,16,4],[nMW,0,0,0,nMZ],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),40,G1H16(38),m3h4x16(:,38),heltab2x64(:,:,302))
  Gcoeff(:)%j = (c(78)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(303),h0tab(:,303),[40,1,2,16,4],[nMW,0,nMZ,0,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),40,G1H16(39),m3h4x16(:,39),heltab2x64(:,:,303))
  Gcoeff(:)%j = (c(59)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(304),h0tab(:,304),[40,1,2,16,4],[nMW,0,nMZ,0,nMZ],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),40,G1H16(40),m3h4x16(:,40),heltab2x64(:,:,304))
  Gcoeff(:)%j = (-(c(78)*M(4,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(305),h0tab(:,305),[40,1,4,16,2],[0,nMZ,0,0,0],5,1,wf4(:,3))
  call Hloop_QW_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,41),heltab2x64(:,:,305))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(41),n2h16(47))
  Gcoeff(:)%j = (c(79)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(306),h0tab(:,306),[40,1,4,16,2],[0,nMZ,0,nMZ,0],5,1,wf4(:,3))
  call Hloop_QW_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,42),heltab2x64(:,:,306))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(42),n2h16(48))
  Gcoeff(:)%j = (-(c(78)*M(4,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(307),h0tab(:,307),[40,1,16,4,2],[0,nMZ,0,0,0],5,1,wf4(:,3))
  call Hloop_QW_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,43),heltab2x64(:,:,307))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(43),n2h16(49))
  Gcoeff(:)%j = (c(79)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(308),h0tab(:,308),[40,1,16,4,2],[0,nMZ,0,nMZ,0],5,1,wf4(:,3))
  call Hloop_QW_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,44),heltab2x64(:,:,308))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(44),n2h16(50))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(17),[G0H32(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(20),[G0H32(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(19),[G1H32(15),G1H32(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(26),[G1H32(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(21),[G1H32(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(4),[G0H32(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(10),[G0H32(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(2),[G1H32(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(9),[G1H32(12),G1H32(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(17),[G1H32(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(10),[G1H32(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(16),[G1H32(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(30),[G1H32(23),G1H32(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(28),[G1H32(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(27),[G1H32(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(47),[G0H32(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(51),[G0H32(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(32),[G1H32(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(42),[G0H32(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(46),[G0H32(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(39),[G1H32(38),G1H32(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(41),[G1H32(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(40),[G1H32(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(27),[G0H32(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(32),[G0H32(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(48),[G1H32(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(49),[G1H32(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(11),[G0H32(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(54),[G1H32(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(55),[G1H32(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(62),[G1H32(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(63),[G1H32(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(29),[G0H32(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(30),[G0H32(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(38),[G0H32(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(53),[G0H32(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(54),[G0H32(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(55),[G0H32(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(78),[G0H32(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(79),[G0H32(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(80),[G0H32(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(87),[G0H32(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(88),[G0H32(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(89),[G0H32(83)])
  call Hloop_UV_W(ntryL,G0H32(17),32,wf4(:,1),3,G1H8(1),m3h4x8(:,1),heltab2x32(:,:,61))
  call Hloop_UV_W(ntryL,G0H32(20),32,wf4(:,1),3,G1H8(2),m3h4x8(:,2),heltab2x32(:,:,62))
  call Hloop_UV_W(ntryL,G0H32(8),32,wf4(:,1),3,G1H8(3),m3h4x8(:,3),heltab2x32(:,:,63))
  call Hloop_UV_W(ntryL,G0H32(12),32,wf4(:,1),3,G1H8(4),m3h4x8(:,4),heltab2x32(:,:,64))
  call Hloop_AW_Q(ntryL,G1H32(19),wf4(:,1),G1H8(5),m3h4x8(:,5),heltab2x32(:,:,65))
  call Hloop_A_Q(ntryL,G1H8(5),35,0,G2H8(1),n2h8(25))
  call Hloop_AW_Q(ntryL,G1H32(26),wf4(:,1),G1H8(6),m3h4x8(:,6),heltab2x32(:,:,66))
  call Hloop_A_Q(ntryL,G1H8(6),35,0,G2H8(2),n2h8(26))
  call Hloop_AW_Q(ntryL,G1H32(21),wf4(:,1),G1H8(7),m3h4x8(:,7),heltab2x32(:,:,67))
  call Hloop_A_Q(ntryL,G1H8(7),35,0,G2H8(3),n2h8(27))
  call Hloop_AW_Q(ntryL,G1H32(13),wf4(:,1),G1H8(8),m3h4x8(:,8),heltab2x32(:,:,68))
  call Hloop_A_Q(ntryL,G1H8(8),35,0,G2H8(4),n2h8(28))
  call Hloop_UV_W(ntryL,G0H32(4),32,wf4(:,1),3,G1H8(9),m3h4x8(:,9),heltab2x32(:,:,69))
  call Hloop_UV_W(ntryL,G0H32(10),32,wf4(:,1),3,G1H8(10),m3h4x8(:,10),heltab2x32(:,:,70))
  call Hloop_UV_W(ntryL,G0H32(2),32,wf4(:,1),3,G1H8(11),m3h4x8(:,11),heltab2x32(:,:,71))
  call Hloop_UV_W(ntryL,G0H32(3),32,wf4(:,1),3,G1H8(12),m3h4x8(:,12),heltab2x32(:,:,72))
  call Hloop_AQ_V(ntryL,G1H32(2),ex3(:),G1H16(45),m3h2x16(:,61),heltab2x32(:,:,73))
  call Hloop_AQ_Z(ntryL,G1H32(5),ex3(:),G1H16(46),ngZu,m3h2x16(:,62),heltab2x32(:,:,74))
  call Hloop_AW_Q(ntryL,G1H32(9),wf4(:,1),G1H8(13),m3h4x8(:,13),heltab2x32(:,:,75))
  call Hloop_A_Q(ntryL,G1H8(13),35,0,G2H8(5),n2h8(29))
  call Hloop_AW_Q(ntryL,G1H32(17),wf4(:,1),G1H8(14),m3h4x8(:,14),heltab2x32(:,:,76))
  call Hloop_A_Q(ntryL,G1H8(14),35,0,G2H8(6),n2h8(30))
  call Hloop_AW_Q(ntryL,G1H32(10),wf4(:,1),G1H8(15),m3h4x8(:,15),heltab2x32(:,:,77))
  call Hloop_A_Q(ntryL,G1H8(15),35,0,G2H8(7),n2h8(31))
  call Hloop_AW_Q(ntryL,G1H32(7),wf4(:,1),G1H8(16),m3h4x8(:,16),heltab2x32(:,:,78))
  call Hloop_A_Q(ntryL,G1H8(16),35,0,G2H8(8),n2h8(32))
  call Hloop_AQ_V(ntryL,G1H32(16),ex4(:),G1H16(47),m3h2x16(:,63),heltab2x32(:,:,79))
  call Hloop_AQ_Z(ntryL,G1H32(18),ex4(:),G1H16(48),ngZu,m3h2x16(:,64),heltab2x32(:,:,80))
  call Hloop_AW_Q(ntryL,G1H32(30),wf4(:,1),G1H8(17),m3h4x8(:,17),heltab2x32(:,:,81))
  call Hloop_A_Q(ntryL,G1H8(17),35,0,G2H8(9),n2h8(33))
  call Hloop_AW_Q(ntryL,G1H32(28),wf4(:,1),G1H8(18),m3h4x8(:,18),heltab2x32(:,:,82))
  call Hloop_A_Q(ntryL,G1H8(18),35,0,G2H8(10),n2h8(34))
  call Hloop_AW_Q(ntryL,G1H32(27),wf4(:,1),G1H8(19),m3h4x8(:,19),heltab2x32(:,:,83))
  call Hloop_A_Q(ntryL,G1H8(19),35,0,G2H8(11),n2h8(35))
  call Hloop_AW_Q(ntryL,G1H32(22),wf4(:,1),G1H8(20),m3h4x8(:,20),heltab2x32(:,:,84))
  call Hloop_A_Q(ntryL,G1H8(20),35,0,G2H8(12),n2h8(36))
  call Hloop_UV_W(ntryL,G0H32(47),32,wf4(:,1),3,G1H8(21),m3h4x8(:,21),heltab2x32(:,:,85))
  call Hloop_UV_W(ntryL,G0H32(51),32,wf4(:,1),3,G1H8(22),m3h4x8(:,22),heltab2x32(:,:,86))
  call Hloop_UV_W(ntryL,G0H32(41),32,wf4(:,1),3,G1H8(23),m3h4x8(:,23),heltab2x32(:,:,87))
  call Hloop_UV_W(ntryL,G0H32(45),32,wf4(:,1),3,G1H8(24),m3h4x8(:,24),heltab2x32(:,:,88))
  call Hloop_UW_V(ntryL,G0H32(43),32,wf4(:,1),3,G1H8(25),m3h4x8(:,25),heltab2x32(:,:,89))
  call Hloop_UW_V(ntryL,G0H32(50),32,wf4(:,1),3,G1H8(26),m3h4x8(:,26),heltab2x32(:,:,90))
  call Hloop_AQ_W(ntryL,G1H32(32),ex3(:),G1H16(49),m3h2x16(:,65),heltab2x32(:,:,91))
  call Hloop_AQ_W(ntryL,G1H32(33),ex3(:),G1H16(50),m3h2x16(:,66),heltab2x32(:,:,92))
  call Hloop_VQ_A(ntryL,G0H32(42),ex3(:),G0H16(1),m3h2x16(:,67),heltab2x32(:,:,93))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(51),n2h16(51))
  call Hloop_VQ_A(ntryL,G0H32(46),ex3(:),G0H16(1),m3h2x16(:,68),heltab2x32(:,:,94))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(52),n2h16(52))
  call Hloop_ZQ_A(ntryL,G0H32(35),ex3(:),G0H16(1),ngZu,m3h2x16(:,69),heltab2x32(:,:,95))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(53),n2h16(53))
  call Hloop_ZQ_A(ntryL,G0H32(40),ex3(:),G0H16(1),ngZu,m3h2x16(:,70),heltab2x32(:,:,96))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(54),n2h16(54))
  call Hloop_AW_Q(ntryL,G1H32(39),wf4(:,1),G1H8(27),m3h4x8(:,27),heltab2x32(:,:,97))
  call Hloop_A_Q(ntryL,G1H8(27),35,0,G2H8(13),n2h8(37))
  call Hloop_AW_Q(ntryL,G1H32(41),wf4(:,1),G1H8(28),m3h4x8(:,28),heltab2x32(:,:,98))
  call Hloop_A_Q(ntryL,G1H8(28),35,0,G2H8(14),n2h8(38))
  call Hloop_AW_Q(ntryL,G1H32(40),wf4(:,1),G1H8(29),m3h4x8(:,29),heltab2x32(:,:,99))
  call Hloop_A_Q(ntryL,G1H8(29),35,0,G2H8(15),n2h8(39))
  call Hloop_AW_Q(ntryL,G1H32(37),wf4(:,1),G1H8(30),m3h4x8(:,30),heltab2x32(:,:,100))
  call Hloop_A_Q(ntryL,G1H8(30),35,0,G2H8(16),n2h8(40))
  call Hloop_UV_W(ntryL,G0H32(27),32,wf4(:,1),3,G1H8(31),m3h4x8(:,31),heltab2x32(:,:,101))
  call Hloop_UV_W(ntryL,G0H32(22),32,wf4(:,1),3,G1H8(32),m3h4x8(:,32),heltab2x32(:,:,102))
  call Hloop_UV_W(ntryL,G0H32(32),32,wf4(:,1),3,G1H8(33),m3h4x8(:,33),heltab2x32(:,:,103))
  call Hloop_UV_W(ntryL,G0H32(25),32,wf4(:,1),3,G1H8(34),m3h4x8(:,34),heltab2x32(:,:,104))
  call Hloop_UW_V(ntryL,G0H32(24),32,wf4(:,1),3,G1H8(35),m3h4x8(:,35),heltab2x32(:,:,105))
  call Hloop_UW_V(ntryL,G0H32(31),32,wf4(:,1),3,G1H8(36),m3h4x8(:,36),heltab2x32(:,:,106))
  call Hloop_AQ_W(ntryL,G1H32(48),ex4(:),G1H16(55),m3h2x16(:,71),heltab2x32(:,:,107))
  call Hloop_AQ_W(ntryL,G1H32(43),ex4(:),G1H16(56),m3h2x16(:,72),heltab2x32(:,:,108))
  call Hloop_AQ_W(ntryL,G1H32(49),ex4(:),G1H16(57),m3h2x16(:,73),heltab2x32(:,:,109))
  call Hloop_AQ_W(ntryL,G1H32(45),ex4(:),G1H16(58),m3h2x16(:,74),heltab2x32(:,:,110))
  call Hloop_AQ_V(ntryL,G1H32(46),ex4(:),G1H16(59),m3h2x16(:,75),heltab2x32(:,:,111))
  call Hloop_AQ_Z(ntryL,G1H32(47),ex4(:),G1H16(60),ngZu,m3h2x16(:,76),heltab2x32(:,:,112))
  call Hloop_VQ_A(ntryL,G0H32(11),ex3(:),G0H16(1),m3h2x16(:,77),heltab2x32(:,:,113))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(61),n2h16(55))
  call Hloop_ZQ_A(ntryL,G0H32(7),ex3(:),G0H16(1),ngZu,m3h2x16(:,78),heltab2x32(:,:,114))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(62),n2h16(56))
  call Hloop_AQ_W(ntryL,G1H32(54),ex3(:),G1H16(63),m3h2x16(:,79),heltab2x32(:,:,115))
  call Hloop_AQ_W(ntryL,G1H32(55),ex3(:),G1H16(64),m3h2x16(:,80),heltab2x32(:,:,116))
  call Hloop_AQ_W(ntryL,G1H32(52),ex3(:),G1H16(65),m3h2x16(:,81),heltab2x32(:,:,117))
  call Hloop_AQ_W(ntryL,G1H32(53),ex3(:),G1H16(66),m3h2x16(:,82),heltab2x32(:,:,118))
  call Hloop_AQ_W(ntryL,G1H32(62),ex3(:),G1H16(67),m3h2x16(:,83),heltab2x32(:,:,119))
  call Hloop_AQ_W(ntryL,G1H32(57),ex3(:),G1H16(68),m3h2x16(:,84),heltab2x32(:,:,120))
  call Hloop_AQ_W(ntryL,G1H32(63),ex3(:),G1H16(69),m3h2x16(:,85),heltab2x32(:,:,121))
  call Hloop_AQ_W(ntryL,G1H32(59),ex3(:),G1H16(70),m3h2x16(:,86),heltab2x32(:,:,122))
  call Hloop_AQ_V(ntryL,G1H32(60),ex3(:),G1H16(71),m3h2x16(:,87),heltab2x32(:,:,123))
  call Hloop_AQ_Z(ntryL,G1H32(61),ex3(:),G1H16(72),ngZu,m3h2x16(:,88),heltab2x32(:,:,124))
  call Hloop_VQ_A(ntryL,G0H32(29),ex2(:),G0H16(1),m3h2x16(:,89),heltab2x32(:,:,125))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(73),n2h16(57))
  call Hloop_WQ_A(ntryL,G0H32(30),ex2(:),G0H16(1),m3h2x16(:,90),heltab2x32(:,:,126))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(74),n2h16(58))
  call Hloop_ZQ_A(ntryL,G0H32(38),ex2(:),G0H16(1),ngZl,m3h2x16(:,91),heltab2x32(:,:,127))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(75),n2h16(59))
  call Hloop_VQ_A(ntryL,G0H32(14),ex2(:),G0H16(1),m3h2x16(:,92),heltab2x32(:,:,128))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(76),n2h16(60))
  call Hloop_WQ_A(ntryL,G0H32(15),ex2(:),G0H16(1),m3h2x16(:,93),heltab2x32(:,:,129))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(77),n2h16(61))
  call Hloop_ZQ_A(ntryL,G0H32(19),ex2(:),G0H16(1),ngZl,m3h2x16(:,94),heltab2x32(:,:,130))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(78),n2h16(62))
  call Hloop_AQ_Z(ntryL,G1H32(64),ex4(:),G1H16(79),ngZu,m3h2x16(:,95),heltab2x32(:,:,131))
  call Hloop_AQ_Z(ntryL,G1H32(65),ex4(:),G1H16(80),ngZu,m3h2x16(:,96),heltab2x32(:,:,132))
  call Hloop_WA_Q(ntryL,G0H32(53),ex1(:),G0H16(1),m3h2x16(:,97),heltab2x32(:,:,133))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(81),n2h16(63))
  call Hloop_WA_Q(ntryL,G0H32(54),ex1(:),G0H16(1),m3h2x16(:,98),heltab2x32(:,:,134))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(82),n2h16(64))
  call Hloop_ZA_Q(ntryL,G0H32(55),ex1(:),G0H16(1),ngZn,m3h2x16(:,99),heltab2x32(:,:,135))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(83),n2h16(65))
  call Hloop_WA_Q(ntryL,G0H32(34),ex1(:),G0H16(1),m3h2x16(:,100),heltab2x32(:,:,136))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(84),n2h16(66))
  call Hloop_WA_Q(ntryL,G0H32(39),ex1(:),G0H16(1),m3h2x16(:,101),heltab2x32(:,:,137))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(85),n2h16(67))
  call Hloop_ZA_Q(ntryL,G0H32(52),ex1(:),G0H16(1),ngZn,m3h2x16(:,102),heltab2x32(:,:,138))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(86),n2h16(68))
  call Hloop_ZA_Q(ntryL,G0H32(56),ex1(:),G0H16(1),ngZn,m3h2x16(:,103),heltab2x32(:,:,139))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(87),n2h16(69))
  call Hloop_ZA_Q(ntryL,G0H32(57),ex1(:),G0H16(1),ngZn,m3h2x16(:,104),heltab2x32(:,:,140))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(88),n2h16(70))
  call Hloop_AQ_V(ntryL,G1H32(66),ex4(:),G1H16(89),m3h2x16(:,105),heltab2x32(:,:,141))
  call Hloop_AQ_Z(ntryL,G1H32(67),ex4(:),G1H16(90),ngZu,m3h2x16(:,106),heltab2x32(:,:,142))
  call Hloop_AQ_V(ntryL,G1H32(68),ex4(:),G1H16(91),m3h2x16(:,107),heltab2x32(:,:,143))
  call Hloop_AQ_Z(ntryL,G1H32(69),ex4(:),G1H16(92),ngZu,m3h2x16(:,108),heltab2x32(:,:,144))
  call Hloop_VQ_A(ntryL,G0H32(58),ex2(:),G0H16(1),m3h2x16(:,109),heltab2x32(:,:,145))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(93),n2h16(71))
  call Hloop_ZQ_A(ntryL,G0H32(59),ex2(:),G0H16(1),ngZl,m3h2x16(:,110),heltab2x32(:,:,146))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(94),n2h16(72))
  call Hloop_VQ_A(ntryL,G0H32(60),ex2(:),G0H16(1),m3h2x16(:,111),heltab2x32(:,:,147))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(95),n2h16(73))
  call Hloop_ZQ_A(ntryL,G0H32(61),ex2(:),G0H16(1),ngZl,m3h2x16(:,112),heltab2x32(:,:,148))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(96),n2h16(74))
  call Hloop_VQ_A(ntryL,G0H32(62),ex2(:),G0H16(1),m3h2x16(:,113),heltab2x32(:,:,149))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(97),n2h16(75))
  call Hloop_ZQ_A(ntryL,G0H32(63),ex2(:),G0H16(1),ngZl,m3h2x16(:,114),heltab2x32(:,:,150))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(98),n2h16(76))
  call Hloop_VQ_A(ntryL,G0H32(64),ex2(:),G0H16(1),m3h2x16(:,115),heltab2x32(:,:,151))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(99),n2h16(77))
  call Hloop_WQ_A(ntryL,G0H32(65),ex2(:),G0H16(1),m3h2x16(:,116),heltab2x32(:,:,152))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(100),n2h16(78))
  call Hloop_ZQ_A(ntryL,G0H32(66),ex2(:),G0H16(1),ngZl,m3h2x16(:,117),heltab2x32(:,:,153))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(101),n2h16(79))
  call Hloop_WA_Q(ntryL,G0H32(67),ex1(:),G0H16(1),m3h2x16(:,118),heltab2x32(:,:,154))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(102),n2h16(80))
  call Hloop_WA_Q(ntryL,G0H32(68),ex1(:),G0H16(1),m3h2x16(:,119),heltab2x32(:,:,155))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(103),n2h16(81))
  call Hloop_WA_Q(ntryL,G0H32(69),ex1(:),G0H16(1),m3h2x16(:,120),heltab2x32(:,:,156))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(104),n2h16(82))
  call Hloop_WA_Q(ntryL,G0H32(70),ex1(:),G0H16(1),m3h2x16(:,121),heltab2x32(:,:,157))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(105),n2h16(83))
  call Hloop_ZA_Q(ntryL,G0H32(71),ex1(:),G0H16(1),ngZn,m3h2x16(:,122),heltab2x32(:,:,158))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(106),n2h16(84))
  call Hloop_VQ_A(ntryL,G0H32(78),ex2(:),G0H16(1),m3h2x16(:,123),heltab2x32(:,:,159))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(107),n2h16(85))
  call Hloop_WQ_A(ntryL,G0H32(79),ex2(:),G0H16(1),m3h2x16(:,124),heltab2x32(:,:,160))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(108),n2h16(86))
  call Hloop_ZQ_A(ntryL,G0H32(80),ex2(:),G0H16(1),ngZl,m3h2x16(:,125),heltab2x32(:,:,161))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(109),n2h16(87))
  call Hloop_VQ_A(ntryL,G0H32(75),ex2(:),G0H16(1),m3h2x16(:,126),heltab2x32(:,:,162))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(110),n2h16(88))
  call Hloop_WQ_A(ntryL,G0H32(76),ex2(:),G0H16(1),m3h2x16(:,127),heltab2x32(:,:,163))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(111),n2h16(89))
  call Hloop_ZQ_A(ntryL,G0H32(77),ex2(:),G0H16(1),ngZl,m3h2x16(:,128),heltab2x32(:,:,164))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(112),n2h16(90))
  call Hloop_AQ_Z(ntryL,G1H32(70),ex3(:),G1H16(113),ngZu,m3h2x16(:,129),heltab2x32(:,:,165))
  call Hloop_AQ_Z(ntryL,G1H32(71),ex3(:),G1H16(114),ngZu,m3h2x16(:,130),heltab2x32(:,:,166))
  call Hloop_WA_Q(ntryL,G0H32(87),ex1(:),G0H16(1),m3h2x16(:,131),heltab2x32(:,:,167))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(115),n2h16(91))
  call Hloop_WA_Q(ntryL,G0H32(88),ex1(:),G0H16(1),m3h2x16(:,132),heltab2x32(:,:,168))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(116),n2h16(92))
  call Hloop_ZA_Q(ntryL,G0H32(89),ex1(:),G0H16(1),ngZn,m3h2x16(:,133),heltab2x32(:,:,169))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(117),n2h16(93))
  call Hloop_WA_Q(ntryL,G0H32(84),ex1(:),G0H16(1),m3h2x16(:,134),heltab2x32(:,:,170))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(118),n2h16(94))
  call Hloop_WA_Q(ntryL,G0H32(85),ex1(:),G0H16(1),m3h2x16(:,135),heltab2x32(:,:,171))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(119),n2h16(95))
  call Hloop_ZA_Q(ntryL,G0H32(86),ex1(:),G0H16(1),ngZn,m3h2x16(:,136),heltab2x32(:,:,172))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(120),n2h16(96))
  call Hloop_ZA_Q(ntryL,G0H32(90),ex1(:),G0H16(1),ngZn,m3h2x16(:,137),heltab2x32(:,:,173))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(121),n2h16(97))
  call Hloop_ZA_Q(ntryL,G0H32(91),ex1(:),G0H16(1),ngZn,m3h2x16(:,138),heltab2x32(:,:,174))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(122),n2h16(98))
  call Hloop_AQ_V(ntryL,G1H32(72),ex3(:),G1H16(123),m3h2x16(:,139),heltab2x32(:,:,175))
  call Hloop_AQ_Z(ntryL,G1H32(73),ex3(:),G1H16(124),ngZu,m3h2x16(:,140),heltab2x32(:,:,176))
  call Hloop_AQ_V(ntryL,G1H32(74),ex3(:),G1H16(125),m3h2x16(:,141),heltab2x32(:,:,177))
  call Hloop_AQ_Z(ntryL,G1H32(75),ex3(:),G1H16(126),ngZu,m3h2x16(:,142),heltab2x32(:,:,178))
  call Hloop_VQ_A(ntryL,G0H32(92),ex2(:),G0H16(1),m3h2x16(:,143),heltab2x32(:,:,179))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(127),n2h16(99))
  call Hloop_ZQ_A(ntryL,G0H32(93),ex2(:),G0H16(1),ngZl,m3h2x16(:,144),heltab2x32(:,:,180))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(128),n2h16(100))
  call Hloop_VQ_A(ntryL,G0H32(94),ex2(:),G0H16(1),m3h2x16(:,145),heltab2x32(:,:,181))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(129),n2h16(101))
  call Hloop_ZQ_A(ntryL,G0H32(95),ex2(:),G0H16(1),ngZl,m3h2x16(:,146),heltab2x32(:,:,182))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(130),n2h16(102))
  call Hloop_VQ_A(ntryL,G0H32(96),ex2(:),G0H16(1),m3h2x16(:,147),heltab2x32(:,:,183))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(131),n2h16(103))
  call Hloop_ZQ_A(ntryL,G0H32(97),ex2(:),G0H16(1),ngZl,m3h2x16(:,148),heltab2x32(:,:,184))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(132),n2h16(104))
  call Hloop_VQ_A(ntryL,G0H32(98),ex2(:),G0H16(1),m3h2x16(:,149),heltab2x32(:,:,185))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(133),n2h16(105))
  call Hloop_WQ_A(ntryL,G0H32(99),ex2(:),G0H16(1),m3h2x16(:,150),heltab2x32(:,:,186))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(134),n2h16(106))
  call Hloop_ZQ_A(ntryL,G0H32(100),ex2(:),G0H16(1),ngZl,m3h2x16(:,151),heltab2x32(:,:,187))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(135),n2h16(107))
  call Hloop_WA_Q(ntryL,G0H32(101),ex1(:),G0H16(1),m3h2x16(:,152),heltab2x32(:,:,188))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(136),n2h16(108))
  call Hloop_WA_Q(ntryL,G0H32(102),ex1(:),G0H16(1),m3h2x16(:,153),heltab2x32(:,:,189))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(137),n2h16(109))
  call Hloop_WA_Q(ntryL,G0H32(103),ex1(:),G0H16(1),m3h2x16(:,154),heltab2x32(:,:,190))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(138),n2h16(110))
  call Hloop_WA_Q(ntryL,G0H32(104),ex1(:),G0H16(1),m3h2x16(:,155),heltab2x32(:,:,191))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(139),n2h16(111))
  call Hloop_ZA_Q(ntryL,G0H32(105),ex1(:),G0H16(1),ngZn,m3h2x16(:,156),heltab2x32(:,:,192))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(140),n2h16(112))
  call Hloop_AQ_W(ntryL,G1H16(1),ex4(:),G1H8(5),m3h2x8(:,61),heltab2x16(:,:,61))
  call Hloop_AQ_W(ntryL,G1H16(2),ex4(:),G1H8(6),m3h2x8(:,62),heltab2x16(:,:,62))
  call Hloop_WQ_A(ntryL,G1H16(3),ex2(:),G1H8(7),m3h2x8(:,63),heltab2x16(:,:,63))
  call Hloop_Q_A(ntryL,G1H8(7),38,0,G2H8(17),n2h8(41))
  call Hloop_WQ_A(ntryL,G1H16(4),ex2(:),G1H8(8),m3h2x8(:,64),heltab2x16(:,:,64))
  call Hloop_Q_A(ntryL,G1H8(8),38,0,G2H8(18),n2h8(42))
  call Hloop_VQ_A(ntryL,G1H16(5),ex2(:),G1H8(13),m3h2x8(:,65),heltab2x16(:,:,65))
  call Hloop_Q_A(ntryL,G1H8(13),38,0,G2H8(19),n2h8(43))
  call Hloop_ZQ_A(ntryL,G1H16(6),ex2(:),G1H8(14),ngZl,m3h2x8(:,66),heltab2x16(:,:,66))
  call Hloop_Q_A(ntryL,G1H8(14),38,0,G2H8(20),n2h8(44))
  call Hloop_AQ_W(ntryL,G1H16(7),ex4(:),G1H8(15),m3h2x8(:,67),heltab2x16(:,:,67))
  call Hloop_WQ_A(ntryL,G1H16(8),ex2(:),G1H8(16),m3h2x8(:,68),heltab2x16(:,:,68))
  call Hloop_Q_A(ntryL,G1H8(16),38,0,G2H8(21),n2h8(45))
  call Hloop_WQ_A(ntryL,G1H16(9),ex2(:),G1H8(17),m3h2x8(:,69),heltab2x16(:,:,69))
  call Hloop_Q_A(ntryL,G1H8(17),38,0,G2H8(22),n2h8(46))
  call Hloop_WA_Q(ntryL,G1H16(10),ex1(:),G1H8(18),m3h2x8(:,70),heltab2x16(:,:,70))
  call Hloop_A_Q(ntryL,G1H8(18),37,0,G2H8(23),n2h8(47))
  call Hloop_WA_Q(ntryL,G1H16(11),ex1(:),G1H8(19),m3h2x8(:,71),heltab2x16(:,:,71))
  call Hloop_A_Q(ntryL,G1H8(19),37,0,G2H8(24),n2h8(48))
  call Hloop_WA_Q(ntryL,G1H16(12),ex1(:),G1H8(20),m3h2x8(:,72),heltab2x16(:,:,72))
  call Hloop_A_Q(ntryL,G1H8(20),37,0,G2H8(25),n2h8(49))
  call Hloop_WA_Q(ntryL,G1H16(13),ex1(:),G1H8(27),m3h2x8(:,73),heltab2x16(:,:,73))
  call Hloop_A_Q(ntryL,G1H8(27),37,0,G2H8(26),n2h8(50))
  call Hloop_ZA_Q(ntryL,G1H16(14),ex1(:),G1H8(28),ngZn,m3h2x8(:,74),heltab2x16(:,:,74))
  call Hloop_A_Q(ntryL,G1H8(28),37,0,G2H8(27),n2h8(51))
  call Hloop_WA_Q(ntryL,G1H16(15),ex1(:),G1H8(29),m3h2x8(:,75),heltab2x16(:,:,75))
  call Hloop_A_Q(ntryL,G1H8(29),37,0,G2H8(28),n2h8(52))
  call Hloop_WA_Q(ntryL,G1H16(16),ex1(:),G1H8(30),m3h2x8(:,76),heltab2x16(:,:,76))
  call Hloop_A_Q(ntryL,G1H8(30),37,0,G2H8(29),n2h8(53))
  call Hloop_WA_Q(ntryL,G1H16(17),ex1(:),G1H8(7),m3h2x8(:,77),heltab2x16(:,:,77))
  call Hloop_A_Q(ntryL,G1H8(7),37,0,G2H8(30),n2h8(54))
  call Hloop_WA_Q(ntryL,G1H16(18),ex1(:),G1H8(8),m3h2x8(:,78),heltab2x16(:,:,78))
  call Hloop_A_Q(ntryL,G1H8(8),37,0,G2H8(31),n2h8(55))
  call Hloop_QA_Z(ntryL,G1H16(19),ex1(:),G1H8(13),ngZn,m3h2x8(:,79),heltab2x16(:,:,79))
  call Hloop_QA_Z(ntryL,G1H16(20),ex1(:),G1H8(14),ngZn,m3h2x8(:,80),heltab2x16(:,:,80))
  call Hloop_QA_Z(ntryL,G1H16(21),ex1(:),G1H8(16),ngZn,m3h2x8(:,81),heltab2x16(:,:,81))



end subroutine vamp_1

end module ol_vamp_1_pplnjj_ew_nexeuuuxdx_3_/**/REALKIND
