
module ol_vamp_1_pplnjj_ew_nexeuccxdx_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pplnjj_ew_nexeuccxdx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pplnjj_ew_nexeuccxdx_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pplnjj_ew_nexeuccxdx_1_/**/DREALKIND
  use ol_tensor_sum_storage_pplnjj_ew_nexeuccxdx_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pplnjj_ew_nexeuccxdx_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pplnjj_ew_nexeuccxdx_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(4,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)+c(26)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,4,1,2,8,16],[0,nMW,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,1),heltab2x64(:,:,1))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(1),n2h32(1))
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(29)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,4,1,2,8,16],[0,nMW,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,2),heltab2x64(:,:,2))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(2),n2h32(2))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)+c(26)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,4,1,2,16,8],[0,nMW,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,3),heltab2x64(:,:,3))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(3),n2h32(3))
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(29)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,4,1,2,16,8],[0,nMW,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,4),heltab2x64(:,:,4))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(4),n2h32(4))
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(29)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,4,2,1,8,16],[0,nMW,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,5),heltab2x64(:,:,5))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(5),n2h32(5))
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(29)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,2,1,8,16,4],[nMW,0,nMZ,0,0,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,6),heltab2x64(:,:,6))
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(29)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[32,4,2,1,16,8],[0,nMW,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,7),heltab2x64(:,:,7))
  call Hloop_A_Q(ntryL,G0H32(2),32,0,G1H32(6),n2h32(6))
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(29)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[32,2,1,16,8,4],[nMW,0,nMZ,0,0,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,8),heltab2x64(:,:,8))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)+c(26)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[32,1,2,8,16,4],[nMW,0,0,0,0,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,9),heltab2x64(:,:,9))
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(29)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,1,2,8,16,4],[nMW,0,nMZ,0,0,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,10),heltab2x64(:,:,10))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)+c(26)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[32,1,2,16,8,4],[nMW,0,0,0,0,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,11),heltab2x64(:,:,11))
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(29)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[32,1,2,16,8,4],[nMW,0,nMZ,0,0,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,12),heltab2x64(:,:,12))
  call Hloop_AQ_W(ntryL,G1H32(1),ex3(:),G1H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_AQ_W(ntryL,G1H32(2),ex3(:),G1H16(2),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_AQ_W(ntryL,G1H32(3),ex3(:),G1H16(3),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_AQ_W(ntryL,G1H32(4),ex3(:),G1H16(4),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_AQ_W(ntryL,G1H32(5),ex3(:),G1H16(5),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_WQ_A(ntryL,G0H32(1),ex2(:),G0H16(1),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(6),n2h16(1))
  call Hloop_AQ_W(ntryL,G1H32(6),ex3(:),G1H16(7),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_WQ_A(ntryL,G0H32(2),ex2(:),G0H16(1),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(8),n2h16(2))
  call Hloop_WA_Q(ntryL,G0H32(3),ex1(:),G0H16(1),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(9),n2h16(3))
  call Hloop_WA_Q(ntryL,G0H32(4),ex1(:),G0H16(1),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(10),n2h16(4))
  call Hloop_WA_Q(ntryL,G0H32(5),ex1(:),G0H16(1),m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(11),n2h16(5))
  call Hloop_WA_Q(ntryL,G0H32(6),ex1(:),G0H16(1),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(12),n2h16(6))
  call Hloop_WA_Q(ntryL,G1H16(1),ex1(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(1),37,0,G2H8(1),n2h8(1))
  call Hloop_WA_Q(ntryL,G1H16(2),ex1(:),G1H8(1),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_A_Q(ntryL,G1H8(1),37,0,G2H8(2),n2h8(2))
  call Hloop_WA_Q(ntryL,G1H16(3),ex1(:),G1H8(1),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_A_Q(ntryL,G1H8(1),37,0,G2H8(3),n2h8(3))
  call Hloop_WA_Q(ntryL,G1H16(4),ex1(:),G1H8(1),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_A_Q(ntryL,G1H8(1),37,0,G2H8(4),n2h8(4))
  call Hloop_WQ_A(ntryL,G1H16(5),ex2(:),G1H8(1),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_Q_A(ntryL,G1H8(1),38,0,G2H8(5),n2h8(5))
  call Hloop_QA_Z(ntryL,G1H16(6),ex1(:),G1H8(1),ngZn,m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_WQ_A(ntryL,G1H16(7),ex2(:),G1H8(2),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_Q_A(ntryL,G1H8(2),38,0,G2H8(6),n2h8(6))
  call Hloop_QA_Z(ntryL,G1H16(8),ex1(:),G1H8(2),ngZn,m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_AQ_V(ntryL,G1H16(9),ex2(:),G1H8(3),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_AQ_Z(ntryL,G1H16(10),ex2(:),G1H8(4),ngZl,m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_AQ_V(ntryL,G1H16(11),ex2(:),G1H8(5),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_AQ_Z(ntryL,G1H16(12),ex2(:),G1H8(6),ngZl,m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_AQ_V(ntryL,G2H8(1),ex2(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_Z(ntryL,G2H8(2),ex2(:),G2H4(2),ngZl,m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_AQ_V(ntryL,G2H8(3),ex2(:),G2H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_AQ_Z(ntryL,G2H8(4),ex2(:),G2H4(4),ngZl,m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_QA_Z(ntryL,G2H8(5),ex1(:),G2H4(5),ngZn,m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_ZQ_A(ntryL,G1H8(1),ex4(:),G1H4(1),ngZu,m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(6),n2h4(1))
  call Hloop_QA_Z(ntryL,G2H8(6),ex1(:),G2H4(7),ngZn,m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_ZA_Q(ntryL,G1H8(2),ex5(:),G1H4(1),ngZu,m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(8),n2h4(2))
  call Hloop_VQ_A(ntryL,G1H8(3),ex4(:),G1H4(1),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(9),n2h4(3))
  call Hloop_ZQ_A(ntryL,G1H8(4),ex4(:),G1H4(1),ngZu,m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(10),n2h4(4))
  call Hloop_VA_Q(ntryL,G1H8(5),ex5(:),G1H4(1),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(11),n2h4(5))
  call Hloop_ZA_Q(ntryL,G1H8(6),ex5(:),G1H4(1),ngZu,m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(12),n2h4(6))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),16,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(1),mass5set(:,2),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(8),16,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(1),mass5set(:,1),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(14),8,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(1),mass5set(:,2),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
  call HG1shiftOLR(G1H4(20),8,4)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(2),mass5set(:,2),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
  call HG1shiftOLR(G1H4(26),16,4)
  call Hloop_QA_V(ntryL,G2H4(6),ex5(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(2),mass5set(:,2),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
  call HG1shiftOLR(G1H4(32),8,4)
  call Hloop_AQ_V(ntryL,G2H4(8),ex4(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_V(ntryL,G2H4(9),ex5(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_V(ntryL,G2H4(10),ex5(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_AQ_V(ntryL,G2H4(11),ex4(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_V(ntryL,G2H4(12),ex4(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_VQ_A(ntryL,G1H4(1),ex4(:),G1H2(1),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(7),n2h2(1))
call HGT_raise_alpha_OLR(G1H4(2),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(2),ex5(:),G1H2(1),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_VQ_A(ntryL,G1H4(6),ex4(:),G1H2(2),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_Q_A(ntryL,G1H2(2),47,0,G2H2(8),n2h2(2))
  call Hloop_ZQ_A(ntryL,G1H4(7),ex4(:),G1H2(2),ngZu,m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_Q_A(ntryL,G1H2(2),47,0,G2H2(9),n2h2(3))
call HGT_raise_alpha_OLR(G1H4(8),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(8),ex5(:),G1H2(2),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_ZQ_A(ntryL,G1H4(12),ex4(:),G1H2(3),ngZu,m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_Q_A(ntryL,G1H2(3),47,0,G2H2(10),n2h2(4))
  call Hloop_VA_Q(ntryL,G1H4(13),ex5(:),G1H2(3),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_A_Q(ntryL,G1H2(3),55,0,G2H2(11),n2h2(5))
call HGT_raise_alpha_OLR(G1H4(14),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(14),ex4(:),G1H2(3),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_VA_Q(ntryL,G1H4(18),ex5(:),G1H2(4),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_A_Q(ntryL,G1H2(4),55,0,G2H2(12),n2h2(6))
  call Hloop_ZA_Q(ntryL,G1H4(19),ex5(:),G1H2(4),ngZu,m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_A_Q(ntryL,G1H2(4),55,0,G2H2(13),n2h2(7))
call HGT_raise_alpha_OLR(G1H4(20),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(20),ex4(:),G1H2(4),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_ZA_Q(ntryL,G1H4(24),ex5(:),G1H2(5),ngZu,m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_A_Q(ntryL,G1H2(5),55,0,G2H2(14),n2h2(8))
  call Hloop_ZQ_A(ntryL,G1H4(25),ex4(:),G1H2(5),ngZu,m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_Q_A(ntryL,G1H2(5),47,0,G2H2(15),n2h2(9))
call HGT_raise_alpha_OLR(G1H4(26),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(26),ex5(:),G1H2(5),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_ZQ_A(ntryL,G1H4(30),ex4(:),G1H2(6),ngZu,m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_Q_A(ntryL,G1H2(6),47,0,G2H2(16),n2h2(10))
  call Hloop_ZA_Q(ntryL,G1H4(31),ex5(:),G1H2(6),ngZu,m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_A_Q(ntryL,G1H2(6),55,0,G2H2(17),n2h2(11))
call HGT_raise_alpha_OLR(G1H4(32),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(32),ex4(:),G1H2(6),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_ZA_Q(ntryL,G1H4(36),ex5(:),G1H2(7),ngZu,m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_A_Q(ntryL,G1H2(7),55,0,G2H2(18),n2h2(12))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(3),mass5set(:,3),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(8),4,2)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(4),mass5set(:,3),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),G1H2(18),2)
  call HG1shiftOLR(G1H2(14),4,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(5),mass5set(:,4),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),G1H2(24),2)
  call HG1shiftOLR(G1H2(20),4,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(5),mass5set(:,3),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(26),4,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(6),mass5set(:,4),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(32),4,2)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(6),mass5set(:,3),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
  call HG1shiftOLR(G1H2(38),4,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(7),ex5(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(9),ex5(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(11),ex4(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(13),ex4(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(15),ex5(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(17),ex4(:),G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hloop_VQ_A(ntryL,G1H2(7),ex3(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(7),n2h1(1))
  call Hloop_VQ_A(ntryL,G1H2(8),ex3(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(8),n2h1(2))
  call Hloop_VQ_A(ntryL,G1H2(13),ex3(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(9),n2h1(3))
  call Hloop_VQ_A(ntryL,G1H2(14),ex3(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(10),n2h1(4))
  call Hloop_VQ_A(ntryL,G1H2(19),ex3(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(5))
  call Hloop_VQ_A(ntryL,G1H2(20),ex3(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(12),n2h1(6))
  call Hloop_VQ_A(ntryL,G1H2(25),ex3(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(7))
  call Hloop_VQ_A(ntryL,G1H2(26),ex3(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(14),n2h1(8))
  call Hloop_VQ_A(ntryL,G1H2(31),ex3(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(9))
  call Hloop_VQ_A(ntryL,G1H2(32),ex3(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(16),n2h1(10))
  call Hloop_VQ_A(ntryL,G1H2(37),ex3(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(17),n2h1(11))
  call Hloop_VQ_A(ntryL,G1H2(38),ex3(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(18),n2h1(12))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),16)
  call Hotf_5pt_reduction_last(G2tensor(2),RedSet_5(1),mass5set(:,2),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),16)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(1),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(1),mass5set(:,2),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),8)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(2),mass5set(:,2),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),16)
  call Hotf_5pt_reduction_last(G2tensor(6),RedSet_5(2),mass5set(:,2),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),8)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(3),mass5set(:,3),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),4)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(4),mass5set(:,3),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),4)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(5),mass5set(:,4),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),4)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(5),mass5set(:,3),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),4)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(6),mass5set(:,4),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),4)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(6),mass5set(:,3),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),4)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  Gcoeff(:)%j = (c(25)*M(2,:)%j-c(26)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[32,3,16,8,4],[nMW,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,13),heltab2x64(:,:,13))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(13)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[32,3,16,8,4],[nMW,nMZ,0,0,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,14),heltab2x64(:,:,14))
  Gcoeff(:)%j = (c(5)*M(2,:)%j-c(6)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[32,4,8,3,16],[0,0,0,0,nMW],5,1,wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,15),heltab2x64(:,:,15))
  call Hloop_A_Q(ntryL,G0H32(3),32,0,G1H32(1),n2h32(7))
  Gcoeff(:)%j = (c(22)*M(2,:)%j-c(23)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[32,3,4,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,16),heltab2x64(:,:,16))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(2),n2h32(8))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)+c(18)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[32,3,4,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,17),heltab2x64(:,:,17))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(3),n2h32(9))
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(29)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[32,3,4,8,16],[0,0,nMZ,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,18),heltab2x64(:,:,18))
  call Hloop_A_Q(ntryL,G0H32(6),32,0,G1H32(4),n2h32(10))
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(29)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[32,3,4,8,16],[0,0,0,0,nMZ],5,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(3),ngZd,m3h2x32(:,19),heltab2x64(:,:,19))
  call Hloop_A_Q(ntryL,G0H32(3),32,0,G1H32(5),n2h32(11))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)+c(37)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[32,3,4,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,20),heltab2x64(:,:,20))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(6),n2h32(12))
  Gcoeff(:)%j = (c(25)*M(2,:)%j-c(26)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[32,3,8,16,4],[nMW,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,21),heltab2x64(:,:,21))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(13)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[32,3,8,16,4],[nMW,nMZ,0,0,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,22),heltab2x64(:,:,22))
  Gcoeff(:)%j = (c(5)*M(2,:)%j-c(6)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[32,4,16,3,8],[0,nMW,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,23),heltab2x64(:,:,23))
  call Hloop_A_Q(ntryL,G0H32(3),32,0,G1H32(7),n2h32(13))
  Gcoeff(:)%j = (c(22)*M(2,:)%j-c(23)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[32,3,4,16,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,24),heltab2x64(:,:,24))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(8),n2h32(14))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)+c(18)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[32,3,4,16,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,25),heltab2x64(:,:,25))
  call Hloop_A_Q(ntryL,G0H32(3),32,0,G1H32(9),n2h32(15))
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(29)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[32,3,4,16,8],[0,0,nMZ,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,26),heltab2x64(:,:,26))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(10),n2h32(16))
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(29)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[32,3,4,16,8],[0,0,0,0,nMZ],5,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(3),ngZd,m3h2x32(:,27),heltab2x64(:,:,27))
  call Hloop_A_Q(ntryL,G0H32(3),32,0,G1H32(11),n2h32(17))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)-c(41)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[32,3,4,16,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,28),heltab2x64(:,:,28))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(12),n2h32(18))
  Gcoeff(:)%j = (c(25)*M(2,:)%j-c(26)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[32,4,3,16,8],[0,nMW,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,29),heltab2x64(:,:,29))
  call Hloop_A_Q(ntryL,G0H32(3),32,0,G1H32(13),n2h32(19))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(13)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[32,4,3,16,8],[0,nMW,nMZ,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,30),heltab2x64(:,:,30))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(14),n2h32(20))
  Gcoeff(:)%j = (c(25)*M(2,:)%j-c(26)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[32,4,3,8,16],[0,nMW,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,31),heltab2x64(:,:,31))
  call Hloop_A_Q(ntryL,G0H32(3),32,0,G1H32(15),n2h32(21))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(13)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[32,4,3,8,16],[0,nMW,nMZ,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,32),heltab2x64(:,:,32))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(16),n2h32(22))
  Gcoeff(:)%j = (c(20)*M(2,:)%j-c(21)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[32,2,1,4,24],[0,0,nMW,0,0],5,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,33),heltab2x64(:,:,33))
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(29)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(34),h0tab(:,34),[32,2,1,4,24],[nMW,0,nMZ,0,0],5,1,wf4(:,3))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,34),heltab2x64(:,:,34))
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(29)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(35),h0tab(:,35),[32,2,1,4,24],[nMZ,0,nMW,0,0],5,1,wf4(:,3))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(7),ngZd,m3h2x32(:,35),heltab2x64(:,:,35))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)+c(26)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(36),h0tab(:,36),[32,1,2,4,24],[nMW,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,36),heltab2x64(:,:,36))
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(29)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(37),h0tab(:,37),[32,1,2,4,24],[nMW,0,nMZ,0,0],5,1,wf4(:,3))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,37),heltab2x64(:,:,37))
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(29)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(38),h0tab(:,38),[32,1,2,4,24],[nMZ,0,nMW,0,0],5,1,wf4(:,3))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(10),ngZd,m3h2x32(:,38),heltab2x64(:,:,38))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(6),[G1H32(3),G1H32(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(12),[G1H32(9),G1H32(8)])
  call Hloop_UV_W(ntryL,G0H32(1),32,wf4(:,1),3,G1H8(1),m3h4x8(:,1),heltab2x32(:,:,13))
  call Hloop_UV_W(ntryL,G0H32(2),32,wf4(:,1),3,G1H8(2),m3h4x8(:,2),heltab2x32(:,:,14))
  call Hloop_AQ_V(ntryL,G1H32(1),ex3(:),G1H16(1),m3h2x16(:,13),heltab2x32(:,:,15))
  call Hloop_AW_Q(ntryL,G1H32(6),wf4(:,1),G1H8(3),m3h4x8(:,3),heltab2x32(:,:,16))
  call Hloop_A_Q(ntryL,G1H8(3),35,0,G2H8(1),n2h8(7))
  call Hloop_AW_Q(ntryL,G1H32(4),wf4(:,1),G1H8(4),m3h4x8(:,4),heltab2x32(:,:,17))
  call Hloop_A_Q(ntryL,G1H8(4),35,0,G2H8(2),n2h8(8))
  call Hloop_AW_Q(ntryL,G1H32(5),wf4(:,1),G1H8(5),m3h4x8(:,5),heltab2x32(:,:,18))
  call Hloop_A_Q(ntryL,G1H8(5),35,0,G2H8(3),n2h8(9))
  call Hloop_UV_W(ntryL,G0H32(5),32,wf4(:,1),3,G1H8(6),m3h4x8(:,6),heltab2x32(:,:,19))
  call Hloop_UV_W(ntryL,G0H32(6),32,wf4(:,1),3,G1H8(3),m3h4x8(:,7),heltab2x32(:,:,20))
  call Hloop_AQ_W(ntryL,G1H32(7),ex3(:),G1H16(2),m3h2x16(:,14),heltab2x32(:,:,21))
  call Hloop_AW_Q(ntryL,G1H32(12),wf4(:,1),G1H8(4),m3h4x8(:,8),heltab2x32(:,:,22))
  call Hloop_A_Q(ntryL,G1H8(4),35,0,G2H8(4),n2h8(10))
  call Hloop_AW_Q(ntryL,G1H32(10),wf4(:,1),G1H8(5),m3h4x8(:,9),heltab2x32(:,:,23))
  call Hloop_A_Q(ntryL,G1H8(5),35,0,G2H8(5),n2h8(11))
  call Hloop_AW_Q(ntryL,G1H32(11),wf4(:,1),G1H8(4),m3h4x8(:,10),heltab2x32(:,:,24))
  call Hloop_A_Q(ntryL,G1H8(4),35,0,G2H8(6),n2h8(12))
  call Hloop_AQ_W(ntryL,G1H32(13),ex3(:),G1H16(3),m3h2x16(:,15),heltab2x32(:,:,25))
  call Hloop_AQ_W(ntryL,G1H32(14),ex3(:),G1H16(4),m3h2x16(:,16),heltab2x32(:,:,26))
  call Hloop_AQ_W(ntryL,G1H32(15),ex3(:),G1H16(5),m3h2x16(:,17),heltab2x32(:,:,27))
  call Hloop_AQ_W(ntryL,G1H32(16),ex3(:),G1H16(6),m3h2x16(:,18),heltab2x32(:,:,28))
  call Hloop_VQ_A(ntryL,G0H32(3),ex2(:),G0H16(1),m3h2x16(:,19),heltab2x32(:,:,29))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(7),n2h16(7))
  call Hloop_WQ_A(ntryL,G0H32(4),ex2(:),G0H16(1),m3h2x16(:,20),heltab2x32(:,:,30))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(8),n2h16(8))
  call Hloop_ZQ_A(ntryL,G0H32(7),ex2(:),G0H16(1),ngZl,m3h2x16(:,21),heltab2x32(:,:,31))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(9),n2h16(9))
  call Hloop_WA_Q(ntryL,G0H32(8),ex1(:),G0H16(1),m3h2x16(:,22),heltab2x32(:,:,32))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(10),n2h16(10))
  call Hloop_WA_Q(ntryL,G0H32(9),ex1(:),G0H16(1),m3h2x16(:,23),heltab2x32(:,:,33))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(11),n2h16(11))
  call Hloop_ZA_Q(ntryL,G0H32(10),ex1(:),G0H16(1),ngZn,m3h2x16(:,24),heltab2x32(:,:,34))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(12),n2h16(12))
  call Hloop_VA_Q(ntryL,G1H8(1),ex5(:),G1H4(1),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(1),n2h4(13))
  call Hloop_ZA_Q(ntryL,G1H8(2),ex5(:),G1H4(2),ngZu,m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_A_Q(ntryL,G1H4(2),51,0,G2H4(2),n2h4(14))
  call Hloop_VQ_A(ntryL,G1H16(1),ex4(:),G1H8(5),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_Q_A(ntryL,G1H8(5),44,0,G2H8(7),n2h8(13))
  call Hloop_AQ_V(ntryL,G2H8(1),ex3(:),G2H4(3),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_AQ_Z(ntryL,G2H8(2),ex3(:),G2H4(4),ngZu,m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_AQ_V(ntryL,G2H8(3),ex3(:),G2H4(5),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_VQ_A(ntryL,G1H8(6),ex4(:),G1H4(6),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_Q_A(ntryL,G1H4(6),43,0,G2H4(6),n2h4(15))
  call Hloop_ZQ_A(ntryL,G1H8(3),ex4(:),G1H4(7),ngZu,m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_Q_A(ntryL,G1H4(7),43,0,G2H4(7),n2h4(16))
  call Hloop_WA_Q(ntryL,G1H16(2),ex5(:),G1H8(4),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_A_Q(ntryL,G1H8(4),52,0,G2H8(1),n2h8(14))
  call Hloop_AQ_V(ntryL,G2H8(4),ex3(:),G2H4(8),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_AQ_Z(ntryL,G2H8(5),ex3(:),G2H4(9),ngZu,m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_AQ_V(ntryL,G2H8(6),ex3(:),G2H4(10),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_UV_W(ntryL,G1H16(3),36,wf4(:,1),3,G2H4(11),m3h4x4(:,1),heltab2x16(:,:,15))
  call Hloop_UV_W(ntryL,G1H16(4),36,wf4(:,1),3,G2H4(12),m3h4x4(:,2),heltab2x16(:,:,16))
  call Hloop_UV_W(ntryL,G1H16(5),36,wf4(:,1),3,G2H4(13),m3h4x4(:,3),heltab2x16(:,:,17))
  call Hloop_UV_W(ntryL,G1H16(6),36,wf4(:,1),3,G2H4(14),m3h4x4(:,4),heltab2x16(:,:,18))
  call Hloop_QA_W(ntryL,G1H16(7),ex1(:),G1H8(1),m3h2x8(:,15),heltab2x16(:,:,19))
  call Hloop_QA_Z(ntryL,G1H16(8),ex1(:),G1H8(2),ngZn,m3h2x8(:,16),heltab2x16(:,:,20))
  call Hloop_QA_W(ntryL,G1H16(9),ex1(:),G1H8(5),m3h2x8(:,17),heltab2x16(:,:,21))
  call Hloop_AQ_V(ntryL,G1H16(10),ex2(:),G1H8(6),m3h2x8(:,18),heltab2x16(:,:,22))
  call Hloop_AQ_Z(ntryL,G1H16(11),ex2(:),G1H8(3),ngZl,m3h2x8(:,19),heltab2x16(:,:,23))
  call Hloop_AQ_W(ntryL,G1H16(12),ex2(:),G1H8(4),m3h2x8(:,20),heltab2x16(:,:,24))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(14),[G1H4(29),G1H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G1H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G1H4(35),G1H4(23)])
  call Hloop_VQ_A(ntryL,G1H4(3),ex4(:),G1H2(7),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(7),47,0,G2H2(1),n2h2(13))
  call Hloop_VQ_A(ntryL,G1H4(4),ex4(:),G1H2(8),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_Q_A(ntryL,G1H2(8),47,0,G2H2(2),n2h2(14))
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(7),mass5set(:,1),  & 
G1H4(8),G1H4(12),G1H4(13),G1H4(14),G1H4(18),G1H4(19),4)
  call HG1shiftOLR(G1H4(12),16,4)
  call Hloop_ZQ_A(ntryL,G1H4(9),ex4(:),G1H2(13),ngZu,m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(13),47,0,G2H2(3),n2h2(15))
  call Hloop_ZQ_A(ntryL,G1H4(10),ex4(:),G1H2(14),ngZu,m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_Q_A(ntryL,G1H2(14),47,0,G2H2(4),n2h2(16))
  call Hotf_5pt_reduction(G2H4(14),RedSet_5(7),mass5set(:,5),  & 
G1H4(20),G1H4(24),G1H4(25),G1H4(26),G1H4(30),G1H4(31),4)
  call HG1shiftOLR(G1H4(24),16,4)
  call Hloop_VA_Q(ntryL,G1H4(15),ex5(:),G1H2(19),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_A_Q(ntryL,G1H2(19),55,0,G2H2(5),n2h2(17))
  call Hloop_VA_Q(ntryL,G1H4(16),ex5(:),G1H2(20),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_A_Q(ntryL,G1H2(20),55,0,G2H2(6),n2h2(18))
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(8),mass5set(:,1),  & 
G1H4(32),G1H4(36),G1H4(1),G1H4(2),G1H4(6),G1H4(7),4)
  call HG1shiftOLR(G1H4(36),8,4)
  call Hloop_ZA_Q(ntryL,G1H4(21),ex5(:),G1H2(25),ngZu,m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_A_Q(ntryL,G1H2(25),55,0,G2H2(7),n2h2(19))
  call Hloop_ZA_Q(ntryL,G1H4(22),ex5(:),G1H2(26),ngZu,m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_A_Q(ntryL,G1H2(26),55,0,G2H2(9),n2h2(20))
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(8),mass5set(:,5),  & 
G1H4(5),G1H4(29),G1H4(11),G1H4(17),G1H4(35),G1H4(23),4)
  call HG1shiftOLR(G1H4(29),8,4)
  call Hloop_ZQ_A(ntryL,G1H4(27),ex4(:),G1H2(31),ngZu,m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(31),47,0,G2H2(11),n2h2(21))
  call Hloop_ZQ_A(ntryL,G1H4(28),ex4(:),G1H2(32),ngZu,m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_Q_A(ntryL,G1H2(32),47,0,G2H2(13),n2h2(22))
  call Hloop_ZA_Q(ntryL,G1H4(33),ex5(:),G1H2(37),ngZu,m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(37),55,0,G2H2(15),n2h2(23))
  call Hloop_ZA_Q(ntryL,G1H4(34),ex5(:),G1H2(38),ngZu,m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_A_Q(ntryL,G1H2(38),55,0,G2H2(17),n2h2(24))
  call Hloop_AQ_V(ntryL,G2H4(1),ex4(:),G2H2(19),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_AQ_V(ntryL,G2H4(2),ex4(:),G2H2(20),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hotf_5pt_reduction(G2H8(7),RedSet_5(9),mass5set(:,6),  & 
G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),G1H8(12),8)
  call HG1shiftOLR(G1H8(8),16,8)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(10),mass5set(:,7),  & 
G1H4(3),G1H4(4),G1H4(9),G1H4(10),G1H4(15),G1H4(16),4)
  call HG1shiftOLR(G1H4(4),16,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(10),mass5set(:,8),  & 
G1H4(21),G1H4(22),G1H4(27),G1H4(28),G1H4(33),G1H4(34),4)
  call HG1shiftOLR(G1H4(22),16,4)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(10),mass5set(:,9),  & 
G1H4(37),G1H4(38),G1H4(39),G1H4(40),G1H4(41),G1H4(42),4)
  call HG1shiftOLR(G1H4(38),16,4)
  call Hloop_QA_V(ntryL,G2H4(6),ex5(:),G2H2(21),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_QA_V(ntryL,G2H4(7),ex5(:),G2H2(22),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(11),mass5set(:,1),  & 
G1H8(13),G1H8(14),G1H8(15),G1H8(16),G1H8(17),G1H8(18),8)
  call HG1shiftOLR(G1H8(14),8,8)
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(12),mass5set(:,7),  & 
G1H4(43),G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
  call HG1shiftOLR(G1H4(44),8,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(12),mass5set(:,8),  & 
G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),G1H4(54),4)
  call HG1shiftOLR(G1H4(50),8,4)
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(12),mass5set(:,9),  & 
G1H4(55),G1H4(56),G1H4(57),G1H4(58),G1H4(59),G1H4(60),4)
  call HG1shiftOLR(G1H4(56),8,4)
  call Hloop_WQ_A(ntryL,G1H8(1),ex3(:),G1H4(61),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_Q_A(ntryL,G1H4(61),39,0,G2H4(13),n2h4(17))
  call Hloop_ZQ_A(ntryL,G1H8(2),ex3(:),G1H4(61),ngZu,m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G1H4(61),39,0,G2H4(14),n2h4(18))
  call Hloop_WQ_A(ntryL,G1H8(5),ex3(:),G1H4(61),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_Q_A(ntryL,G1H4(61),39,0,G2H4(11),n2h4(19))
  call Hloop_VQ_A(ntryL,G1H8(6),ex3(:),G1H4(61),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_Q_A(ntryL,G1H4(61),39,0,G2H4(12),n2h4(20))
  call Hloop_ZQ_A(ntryL,G1H8(3),ex3(:),G1H4(61),ngZu,m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_Q_A(ntryL,G1H4(61),39,0,G2H4(1),n2h4(21))
  call Hloop_WQ_A(ntryL,G1H8(4),ex3(:),G1H4(61),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_Q_A(ntryL,G1H4(61),39,0,G2H4(2),n2h4(22))
  call Hloop_VQ_A(ntryL,G1H4(8),ex4(:),G1H2(7),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(7),47,0,G2H2(23),n2h2(25))
call HGT_raise_alpha_OLR(G1H4(12),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(12),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(12),ex5(:),G1H2(8),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_VQ_A(ntryL,G1H4(18),ex4(:),G1H2(13),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(13),47,0,G2H2(24),n2h2(26))
  call Hloop_VQ_A(ntryL,G1H4(19),ex4(:),G1H2(14),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_Q_A(ntryL,G1H2(14),47,0,G2H2(25),n2h2(27))
  call Hloop_ZQ_A(ntryL,G1H4(20),ex4(:),G1H2(19),ngZu,m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(19),47,0,G2H2(26),n2h2(28))
call HGT_raise_alpha_OLR(G1H4(24),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(24),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(24),ex5(:),G1H2(20),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_ZQ_A(ntryL,G1H4(30),ex4(:),G1H2(25),ngZu,m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_Q_A(ntryL,G1H2(25),47,0,G2H2(27),n2h2(29))
  call Hloop_ZQ_A(ntryL,G1H4(31),ex4(:),G1H2(26),ngZu,m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(26),47,0,G2H2(28),n2h2(30))
  call Hloop_VA_Q(ntryL,G1H4(32),ex5(:),G1H2(31),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_A_Q(ntryL,G1H2(31),55,0,G2H2(29),n2h2(31))
call HGT_raise_alpha_OLR(G1H4(36),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(36),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(36),ex4(:),G1H2(32),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_VA_Q(ntryL,G1H4(6),ex5(:),G1H2(37),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_A_Q(ntryL,G1H2(37),55,0,G2H2(30),n2h2(32))
  call Hloop_VA_Q(ntryL,G1H4(7),ex5(:),G1H2(38),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_A_Q(ntryL,G1H2(38),55,0,G2H2(31),n2h2(33))
  call Hloop_ZA_Q(ntryL,G1H4(5),ex5(:),G1H2(7),ngZu,m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_A_Q(ntryL,G1H2(7),55,0,G2H2(32),n2h2(34))
call HGT_raise_alpha_OLR(G1H4(29),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(29),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(29),ex4(:),G1H2(13),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_ZA_Q(ntryL,G1H4(35),ex5(:),G1H2(14),ngZu,m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_A_Q(ntryL,G1H2(14),55,0,G2H2(33),n2h2(35))
  call Hloop_ZA_Q(ntryL,G1H4(23),ex5(:),G1H2(19),ngZu,m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_A_Q(ntryL,G1H2(19),55,0,G2H2(34),n2h2(36))
  call Hloop_QW_A(ntryL,G1H8(7),wf4(:,1),G1H2(25),m3h4x2(:,1),heltab2x8(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(25),47,0,G2H2(35),n2h2(37))
call HGT_raise_alpha_OLR(G1H8(8),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(8),ex5(:),G1H4(61),m3h2x4(:,29),heltab2x8(:,:,30))
  call Hloop_QW_A(ntryL,G1H8(11),wf4(:,1),G1H2(26),m3h4x2(:,2),heltab2x8(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(26),47,0,G2H2(36),n2h2(38))
  call Hloop_QW_A(ntryL,G1H8(12),wf4(:,1),G1H2(31),m3h4x2(:,3),heltab2x8(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(31),47,0,G2H2(37),n2h2(39))
  call Hloop_VQ_A(ntryL,G1H4(3),ex4(:),G1H2(37),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(37),47,0,G2H2(38),n2h2(40))
call HGT_raise_alpha_OLR(G1H4(4),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(4),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(4),ex5(:),G1H2(38),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_VQ_A(ntryL,G1H4(15),ex4(:),G1H2(7),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(7),47,0,G2H2(39),n2h2(41))
  call Hloop_VQ_A(ntryL,G1H4(16),ex4(:),G1H2(14),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_Q_A(ntryL,G1H2(14),47,0,G2H2(40),n2h2(42))
  call Hloop_ZQ_A(ntryL,G1H4(21),ex4(:),G1H2(19),ngZu,m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_Q_A(ntryL,G1H2(19),47,0,G2H2(41),n2h2(43))
call HGT_raise_alpha_OLR(G1H4(22),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(22),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(22),ex5(:),G1H2(25),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_ZQ_A(ntryL,G1H4(33),ex4(:),G1H2(26),ngZu,m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(26),47,0,G2H2(42),n2h2(44))
  call Hloop_ZQ_A(ntryL,G1H4(34),ex4(:),G1H2(31),ngZu,m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_Q_A(ntryL,G1H2(31),47,0,G2H2(43),n2h2(45))
  call Hloop_VQ_A(ntryL,G1H4(37),ex4(:),G1H2(37),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_Q_A(ntryL,G1H2(37),47,0,G2H2(44),n2h2(46))
call HGT_raise_alpha_OLR(G1H4(38),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(38),ex5(:),G1H2(7),ngZu,m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_VQ_A(ntryL,G1H4(41),ex4(:),G1H2(14),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_Q_A(ntryL,G1H2(14),47,0,G2H2(45),n2h2(47))
  call Hloop_VQ_A(ntryL,G1H4(42),ex4(:),G1H2(19),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_Q_A(ntryL,G1H2(19),47,0,G2H2(46),n2h2(48))
  call Hloop_AW_Q(ntryL,G1H8(13),wf4(:,1),G1H2(26),m3h4x2(:,4),heltab2x8(:,:,33))
  call Hloop_A_Q(ntryL,G1H2(26),55,0,G2H2(47),n2h2(49))
call HGT_raise_alpha_OLR(G1H8(14),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(14),ex4(:),G1H4(8),m3h2x4(:,30),heltab2x8(:,:,34))
  call Hloop_AW_Q(ntryL,G1H8(17),wf4(:,1),G1H2(31),m3h4x2(:,5),heltab2x8(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(31),55,0,G2H2(48),n2h2(50))
  call Hloop_AW_Q(ntryL,G1H8(18),wf4(:,1),G1H2(37),m3h4x2(:,6),heltab2x8(:,:,36))
  call Hloop_A_Q(ntryL,G1H2(37),55,0,G2H2(49),n2h2(51))
  call Hloop_VA_Q(ntryL,G1H4(43),ex5(:),G1H2(14),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_A_Q(ntryL,G1H2(14),55,0,G2H2(50),n2h2(52))
call HGT_raise_alpha_OLR(G1H4(44),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(44),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(44),ex4(:),G1H2(19),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_VA_Q(ntryL,G1H4(47),ex5(:),G1H2(26),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_A_Q(ntryL,G1H2(26),55,0,G2H2(51),n2h2(53))
  call Hloop_VA_Q(ntryL,G1H4(48),ex5(:),G1H2(31),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_A_Q(ntryL,G1H2(31),55,0,G2H2(52),n2h2(54))
  call Hloop_ZA_Q(ntryL,G1H4(49),ex5(:),G1H2(37),ngZu,m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_A_Q(ntryL,G1H2(37),55,0,G2H2(53),n2h2(55))
call HGT_raise_alpha_OLR(G1H4(50),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(50),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(50),ex4(:),G1H2(14),m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_ZA_Q(ntryL,G1H4(53),ex5(:),G1H2(26),ngZu,m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_A_Q(ntryL,G1H2(26),55,0,G2H2(54),n2h2(56))
  call Hloop_ZA_Q(ntryL,G1H4(54),ex5(:),G1H2(31),ngZu,m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_A_Q(ntryL,G1H2(31),55,0,G2H2(55),n2h2(57))
  call Hloop_VA_Q(ntryL,G1H4(55),ex5(:),G1H2(37),m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_A_Q(ntryL,G1H2(37),55,0,G2H2(56),n2h2(58))
call HGT_raise_alpha_OLR(G1H4(56),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(56),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(56),ex4(:),G1H2(26),ngZu,m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_VA_Q(ntryL,G1H4(59),ex5(:),G1H2(31),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_A_Q(ntryL,G1H2(31),55,0,G2H2(57),n2h2(59))
  call Hloop_VA_Q(ntryL,G1H4(60),ex5(:),G1H2(37),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_A_Q(ntryL,G1H2(37),55,0,G2H2(58),n2h2(60))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(10),[G2H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G2H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(22),[G1H2(28),G1H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(18),[G1H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G1H2(40),G1H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(21),[G1H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(29),[G1H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(36),[G1H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(42),[G1H2(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(19),[G1H2(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(41),[G1H2(35)])
call HGT_w2_OLR(G1H2(1),1,1,2)
call HGT_w2_invQ_OLR(G1H2(1),2,5,2)
  call Hloop_VQ_A(ntryL,G1H2(1),ex4(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(1),n2h1(13))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(10),ex5(:),G2tensor(2),m3h2x1(:,20),heltab2x2(:,:,20))
call HGT_w2_OLR(G1H2(2),1,1,2)
call HGT_w2_invQ_OLR(G1H2(2),2,5,2)
  call Hloop_ZQ_A(ntryL,G1H2(2),ex4(:),G1H1(1),ngZu,m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(3),n2h1(14))
call HGT_w2_OLR(G1H2(3),1,1,2)
call HGT_w2_invQ_OLR(G1H2(3),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(3),ex5(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(4),n2h1(15))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(14),ex4(:),G2tensor(5),m3h2x1(:,23),heltab2x2(:,:,23))
call HGT_w2_OLR(G1H2(4),1,1,2)
call HGT_w2_invQ_OLR(G1H2(4),2,5,2)
  call Hloop_ZA_Q(ntryL,G1H2(4),ex5(:),G1H1(1),ngZu,m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(6),n2h1(16))
call HGT_w2_OLR(G1H2(5),1,1,2)
call HGT_w2_invQ_OLR(G1H2(5),2,5,2)
  call Hloop_ZQ_A(ntryL,G1H2(5),ex4(:),G1H1(1),ngZu,m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(7),n2h1(17))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(16),ex5(:),G2tensor(9),m3h2x1(:,26),heltab2x2(:,:,26))
call HGT_w2_OLR(G1H2(6),1,1,2)
call HGT_w2_invQ_OLR(G1H2(6),2,5,2)
  call Hloop_ZA_Q(ntryL,G1H2(6),ex5(:),G1H1(1),ngZu,m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(18))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(18),ex4(:),G2tensor(13),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hloop_VQ_A(ntryL,G1H2(9),ex3(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(19))
  call Hotf_5pt_reduction(G2H2(22),RedSet_5(13),mass5set(:,10),  & 
G1H2(31),G1H2(37),G1H2(28),G1H2(10),G1H2(12),G1H2(40),2)
  call HG1shiftOLR(G1H2(37),4,2)
  call Hloop_VQ_A(ntryL,G1H2(11),ex3(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(17),n2h1(20))
  call Hloop_VQ_A(ntryL,G1H2(18),ex3(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(19),n2h1(21))
  call Hloop_VQ_A(ntryL,G1H2(15),ex3(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(20),n2h1(22))
  call Hotf_5pt_reduction(G2H2(20),RedSet_5(14),mass5set(:,10),  & 
G1H2(16),G1H2(22),G1H2(23),G1H2(24),G1H2(30),G1H2(34),2)
  call HG1shiftOLR(G1H2(22),4,2)
  call Hloop_VQ_A(ntryL,G1H2(17),ex3(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(21),n2h1(23))
  call Hloop_VQ_A(ntryL,G1H2(21),ex3(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(22),n2h1(24))
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(13),mass5set(:,4),  & 
G1H2(35),G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),2)
  call HG1shiftOLR(G1H2(1),4,2)
  call Hloop_VQ_A(ntryL,G1H2(29),ex3(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(23),n2h1(25))
  call Hloop_VQ_A(ntryL,G1H2(36),ex3(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(24),n2h1(26))
  call Hloop_VQ_A(ntryL,G1H2(27),ex3(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(25),n2h1(27))
  call Hloop_VQ_A(ntryL,G1H2(42),ex3(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(26),n2h1(28))
  call Hloop_VQ_A(ntryL,G1H2(33),ex3(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(27),n2h1(29))
  call Hotf_5pt_reduction(G2H2(19),RedSet_5(14),mass5set(:,4),  & 
G1H2(6),G1H2(9),G1H2(11),G1H2(18),G1H2(15),G1H2(17),2)
  call HG1shiftOLR(G1H2(9),4,2)
  call Hloop_VQ_A(ntryL,G1H2(41),ex3(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(28),n2h1(30))
  call Hloop_VQ_A(ntryL,G1H2(39),ex3(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(29),n2h1(31))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(1),ex5(:),G2tensor(30),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(2),ex5(:),G2tensor(31),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(3),ex5(:),G2tensor(32),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(4),ex5(:),G2tensor(33),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(5),ex4(:),G2tensor(34),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(6),ex4(:),G2tensor(35),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(7),ex4(:),G2tensor(36),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(9),ex4(:),G2tensor(37),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(11),ex5(:),G2tensor(38),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(13),ex5(:),G2tensor(39),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(15),ex4(:),G2tensor(40),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(17),ex4(:),G2tensor(41),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(15),mass5set(:,11),  & 
G1H4(12),G1H4(18),G1H4(19),G1H4(20),G1H4(24),G1H4(30),4)
  call HG1shiftOLR(G1H4(18),24,4)
  call Hotf_5pt_reduction(G2H4(14),RedSet_5(15),mass5set(:,3),  & 
G1H4(31),G1H4(32),G1H4(36),G1H4(6),G1H4(7),G1H4(5),4)
  call HG1shiftOLR(G1H4(32),24,4)
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(15),mass5set(:,12),  & 
G1H4(29),G1H4(35),G1H4(23),G1H4(3),G1H4(4),G1H4(15),4)
  call HG1shiftOLR(G1H4(35),24,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(16),mass5set(:,4),  & 
G1H4(16),G1H4(21),G1H4(22),G1H4(33),G1H4(34),G1H4(37),4)
  call HG1shiftOLR(G1H4(21),24,4)
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(16),mass5set(:,3),  & 
G1H4(38),G1H4(41),G1H4(42),G1H4(43),G1H4(44),G1H4(47),4)
  call HG1shiftOLR(G1H4(41),24,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(16),mass5set(:,12),  & 
G1H4(48),G1H4(49),G1H4(50),G1H4(53),G1H4(54),G1H4(55),4)
  call HG1shiftOLR(G1H4(49),24,4)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(23),ex5(:),G2tensor(42),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(25),ex5(:),G2tensor(43),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(26),ex5(:),G2tensor(44),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(28),ex5(:),G2tensor(45),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(29),ex4(:),G2tensor(46),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(31),ex4(:),G2tensor(47),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(32),ex4(:),G2tensor(48),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(34),ex4(:),G2tensor(49),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(35),ex5(:),G2tensor(50),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(37),ex5(:),G2tensor(51),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(38),ex5(:),G2tensor(52),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(40),ex5(:),G2tensor(53),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(41),ex5(:),G2tensor(54),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(43),ex5(:),G2tensor(55),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(44),ex5(:),G2tensor(56),ngZu,m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(46),ex5(:),G2tensor(57),ngZu,m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(47),ex4(:),G2tensor(58),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(49),ex4(:),G2tensor(59),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(50),ex4(:),G2tensor(60),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(52),ex4(:),G2tensor(61),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(53),ex4(:),G2tensor(62),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(55),ex4(:),G2tensor(63),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(56),ex4(:),G2tensor(64),ngZu,m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(58),ex4(:),G2tensor(65),ngZu,m3h2x1(:,77),heltab2x2(:,:,77))
  call Hloop_VQ_A(ntryL,G1H2(31),ex3(:),G1H1(1),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(66),n2h1(32))
  call Hloop_VQ_A(ntryL,G1H2(37),ex3(:),G1H1(1),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(67),n2h1(33))
  call Hloop_VQ_A(ntryL,G1H2(40),ex3(:),G1H1(1),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(68),n2h1(34))
  call Hloop_VQ_A(ntryL,G1H2(16),ex3(:),G1H1(1),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(69),n2h1(35))
  call Hloop_VQ_A(ntryL,G1H2(22),ex3(:),G1H1(1),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(70),n2h1(36))
  call Hloop_VQ_A(ntryL,G1H2(34),ex3(:),G1H1(1),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(71),n2h1(37))
  call Hloop_VQ_A(ntryL,G1H2(35),ex3(:),G1H1(1),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(72),n2h1(38))
  call Hloop_VQ_A(ntryL,G1H2(1),ex3(:),G1H1(1),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(73),n2h1(39))
  call Hloop_VQ_A(ntryL,G1H2(5),ex3(:),G1H1(1),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(74),n2h1(40))
  call Hloop_VQ_A(ntryL,G1H2(6),ex3(:),G1H1(1),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(75),n2h1(41))
  call Hloop_VQ_A(ntryL,G1H2(9),ex3(:),G1H1(1),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(76),n2h1(42))
  call Hloop_VQ_A(ntryL,G1H2(17),ex3(:),G1H1(1),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(77),n2h1(43))
  call Hloop_QV_A(ntryL,G1H4(12),wf4(:,3),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(78),n2h1(44))
  call Hloop_QV_A(ntryL,G1H4(18),wf4(:,3),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,0,G2tensor(79),n2h1(45))
  call Hloop_QV_A(ntryL,G1H4(30),wf4(:,3),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(80),n2h1(46))
  call Hloop_QV_A(ntryL,G1H4(31),wf4(:,3),G1H1(1),m3h4x1(:,4),heltab2x4(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(81),n2h1(47))
  call Hloop_QV_A(ntryL,G1H4(32),wf4(:,3),G1H1(1),m3h4x1(:,5),heltab2x4(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,0,G2tensor(82),n2h1(48))
  call Hloop_QV_A(ntryL,G1H4(5),wf4(:,3),G1H1(1),m3h4x1(:,6),heltab2x4(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(83),n2h1(49))
  call Hloop_QV_A(ntryL,G1H4(29),wf4(:,3),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(84),n2h1(50))
  call Hloop_QV_A(ntryL,G1H4(35),wf4(:,3),G1H1(1),m3h4x1(:,8),heltab2x4(:,:,88))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,0,G2tensor(85),n2h1(51))
  call Hloop_QV_A(ntryL,G1H4(15),wf4(:,3),G1H1(1),m3h4x1(:,9),heltab2x4(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(86),n2h1(52))
  call Hloop_QV_A(ntryL,G1H4(16),wf4(:,3),G1H1(1),m3h4x1(:,10),heltab2x4(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(87),n2h1(53))
  call Hloop_QV_A(ntryL,G1H4(21),wf4(:,3),G1H1(1),m3h4x1(:,11),heltab2x4(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,0,G2tensor(88),n2h1(54))
  call Hloop_QV_A(ntryL,G1H4(37),wf4(:,3),G1H1(1),m3h4x1(:,12),heltab2x4(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(89),n2h1(55))
  call Hloop_QV_A(ntryL,G1H4(38),wf4(:,3),G1H1(1),m3h4x1(:,13),heltab2x4(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(90),n2h1(56))
  call Hloop_QV_A(ntryL,G1H4(41),wf4(:,3),G1H1(1),m3h4x1(:,14),heltab2x4(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,0,G2tensor(91),n2h1(57))
  call Hloop_QV_A(ntryL,G1H4(47),wf4(:,3),G1H1(1),m3h4x1(:,15),heltab2x4(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(92),n2h1(58))
  call Hloop_QV_A(ntryL,G1H4(48),wf4(:,3),G1H1(1),m3h4x1(:,16),heltab2x4(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(93),n2h1(59))
  call Hloop_QV_A(ntryL,G1H4(49),wf4(:,3),G1H1(1),m3h4x1(:,17),heltab2x4(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,0,G2tensor(94),n2h1(60))
  call Hloop_QV_A(ntryL,G1H4(55),wf4(:,3),G1H1(1),m3h4x1(:,18),heltab2x4(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(95),n2h1(61))
  call ol_merge_tensors(G2tensor(38),[G2tensor(8),G1tensor(38),G1tensor(27)])
  call ol_merge_tensors(G2tensor(40),[G2tensor(10),G1tensor(44),G1tensor(33)])
  call ol_merge_tensors(G2tensor(30),[G2tensor(12),G1tensor(50),G1tensor(3)])
  call ol_merge_tensors(G2tensor(32),[G2tensor(14),G1tensor(56),G1tensor(9)])
  call ol_merge_tensors(G2tensor(34),[G2tensor(16),G1tensor(62),G1tensor(15)])
  call ol_merge_tensors(G2tensor(36),[G2tensor(18),G1tensor(68),G1tensor(21)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(2)])
  call ol_merge_tensors(G2tensor(31),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(42),[G1tensor(5)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(12),G1tensor(6)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(8)])
  call ol_merge_tensors(G2tensor(33),[G1tensor(10)])
  call ol_merge_tensors(G2tensor(44),[G1tensor(29),G1tensor(11)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(14)])
  call ol_merge_tensors(G2tensor(35),[G1tensor(16)])
  call ol_merge_tensors(G2tensor(46),[G1tensor(17)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(24),G1tensor(18)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(20)])
  call ol_merge_tensors(G2tensor(37),[G1tensor(22)])
  call ol_merge_tensors(G2tensor(48),[G1tensor(35),G1tensor(23)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(26)])
  call ol_merge_tensors(G2tensor(39),[G1tensor(28)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(30)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(32)])
  call ol_merge_tensors(G2tensor(41),[G1tensor(34)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(36)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(39)])
  call ol_merge_tensors(G2tensor(66),[G1tensor(58),G1tensor(40)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(41)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(48),G1tensor(42)])
  call ol_merge_tensors(G2tensor(20),[G1tensor(45)])
  call ol_merge_tensors(G2tensor(69),[G1tensor(70),G1tensor(46)])
  call ol_merge_tensors(G2tensor(21),[G1tensor(47)])
  call ol_merge_tensors(G2tensor(22),[G1tensor(51)])
  call ol_merge_tensors(G2tensor(72),[G1tensor(52)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(59),G1tensor(53)])
  call ol_merge_tensors(G2tensor(24),[G1tensor(66),G1tensor(54)])
  call ol_merge_tensors(G2tensor(25),[G1tensor(57)])
  call ol_merge_tensors(G2tensor(26),[G1tensor(72),G1tensor(60)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(63)])
  call ol_merge_tensors(G2tensor(75),[G1tensor(64)])
  call ol_merge_tensors(G2tensor(28),[G1tensor(71),G1tensor(65)])
  call ol_merge_tensors(G2tensor(29),[G1tensor(69)])
  call Hotf_5pt_reduction_last(G2tensor(38),RedSet_5(17),mass5set(:,3),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25),G1tensor(31))
  call G_TensorShift(G1tensor(7),16)
  call Hotf_5pt_reduction_last(G2tensor(40),RedSet_5(18),mass5set(:,3),  & 
G1tensor(37),G1tensor(43),G1tensor(49),G1tensor(55),G1tensor(61),G1tensor(67))
  call G_TensorShift(G1tensor(43),8)
  call Hotf_5pt_reduction_last(G2tensor(30),RedSet_5(19),mass5set(:,4),  & 
G1tensor(38),G1tensor(27),G1tensor(44),G1tensor(33),G1tensor(50),G1tensor(3))
  call G_TensorShift(G1tensor(27),16)
  call Hotf_5pt_reduction_last(G2tensor(32),RedSet_5(19),mass5set(:,3),  & 
G1tensor(56),G1tensor(9),G1tensor(62),G1tensor(15),G1tensor(68),G1tensor(21))
  call G_TensorShift(G1tensor(9),16)
  call Hotf_5pt_reduction_last(G2tensor(34),RedSet_5(20),mass5set(:,4),  & 
G1tensor(2),G1tensor(4),G1tensor(5),G1tensor(12),G1tensor(6),G1tensor(8))
  call G_TensorShift(G1tensor(4),8)
  call Hotf_5pt_reduction_last(G2tensor(36),RedSet_5(20),mass5set(:,3),  & 
G1tensor(10),G1tensor(29),G1tensor(11),G1tensor(14),G1tensor(16),G1tensor(17))
  call G_TensorShift(G1tensor(29),8)
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(21),mass5set(:,1),  & 
G1tensor(24),G1tensor(18),G1tensor(20),G1tensor(22),G1tensor(35),G1tensor(23))
  call G_TensorShift(G1tensor(18),8)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(22),mass5set(:,7),  & 
G1tensor(26),G1tensor(28),G1tensor(30),G1tensor(32),G1tensor(34),G1tensor(36))
  call G_TensorShift(G1tensor(28),16)
  call Hotf_5pt_reduction_last(G2tensor(42),RedSet_5(7),mass5set(:,1),  & 
G1tensor(39),G1tensor(58),G1tensor(40),G1tensor(41),G1tensor(48),G1tensor(42))
  call G_TensorShift(G1tensor(58),16)
  call Hotf_5pt_reduction_last(G2tensor(2),RedSet_5(23),mass5set(:,1),  & 
G1tensor(45),G1tensor(70),G1tensor(46),G1tensor(47),G1tensor(51),G1tensor(52))
  call G_TensorShift(G1tensor(70),16)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(21),mass5set(:,2),  & 
G1tensor(59),G1tensor(53),G1tensor(66),G1tensor(54),G1tensor(57),G1tensor(72))
  call G_TensorShift(G1tensor(53),8)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(22),mass5set(:,8),  & 
G1tensor(60),G1tensor(63),G1tensor(64),G1tensor(71),G1tensor(65),G1tensor(69))
  call G_TensorShift(G1tensor(63),16)
  call Hotf_5pt_reduction_last(G2tensor(44),RedSet_5(7),mass5set(:,5),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),16)
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(24),mass5set(:,1),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),16)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(25),mass5set(:,7),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),8)
  call Hotf_5pt_reduction_last(G2tensor(46),RedSet_5(8),mass5set(:,1),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),8)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(26),mass5set(:,1),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),8)
  call Hotf_5pt_reduction_last(G2tensor(6),RedSet_5(24),mass5set(:,2),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),16)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(25),mass5set(:,8),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),8)
  call Hotf_5pt_reduction_last(G2tensor(48),RedSet_5(8),mass5set(:,5),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),8)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(27),mass5set(:,2),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),8)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(28),mass5set(:,8),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),16)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(29),mass5set(:,1),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),16)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(30),mass5set(:,2),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),16)
  call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(31),mass5set(:,8),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),8)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(32),mass5set(:,1),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),8)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(33),mass5set(:,13),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),4)
  call Hotf_5pt_reduction_last(G2tensor(66),RedSet_5(13),mass5set(:,10),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),4)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(34),mass5set(:,4),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),4)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(35),mass5set(:,3),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),4)
  call Hotf_5pt_reduction_last(G2tensor(20),RedSet_5(36),mass5set(:,13),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
  call G_TensorShift(G1tensor(182),4)
  call Hotf_5pt_reduction_last(G2tensor(69),RedSet_5(14),mass5set(:,10),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
  call G_TensorShift(G1tensor(188),4)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(37),mass5set(:,4),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
  call G_TensorShift(G1tensor(194),4)
  call Hotf_5pt_reduction_last(G2tensor(22),RedSet_5(38),mass5set(:,7),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
  call G_TensorShift(G1tensor(200),4)
  call Hotf_5pt_reduction_last(G2tensor(72),RedSet_5(13),mass5set(:,4),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(206),4)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(39),mass5set(:,4),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
  call G_TensorShift(G1tensor(212),4)
  call Hotf_5pt_reduction_last(G2tensor(24),RedSet_5(40),mass5set(:,4),  & 
G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
  call G_TensorShift(G1tensor(218),4)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(38),mass5set(:,13),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227),G1tensor(228))
  call G_TensorShift(G1tensor(224),4)
  call Hotf_5pt_reduction_last(G2tensor(26),RedSet_5(40),mass5set(:,3),  & 
G1tensor(229),G1tensor(230),G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234))
  call G_TensorShift(G1tensor(230),4)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(41),mass5set(:,7),  & 
G1tensor(235),G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(236),4)
  call Hotf_5pt_reduction_last(G2tensor(75),RedSet_5(14),mass5set(:,4),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245),G1tensor(246))
  call G_TensorShift(G1tensor(242),4)
  call Hotf_5pt_reduction_last(G2tensor(28),RedSet_5(42),mass5set(:,4),  & 
G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250),G1tensor(251),G1tensor(252))
  call G_TensorShift(G1tensor(248),4)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(41),mass5set(:,13),  & 
G1tensor(253),G1tensor(254),G1tensor(255),G1tensor(256),G1tensor(257),G1tensor(258))
  call G_TensorShift(G1tensor(254),4)
  call Hotf_5pt_reduction_last(G2tensor(50),RedSet_5(9),mass5set(:,6),  & 
G1tensor(259),G1tensor(260),G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264))
  call G_TensorShift(G1tensor(260),16)
  call Hotf_5pt_reduction_last(G2tensor(52),RedSet_5(10),mass5set(:,7),  & 
G1tensor(265),G1tensor(266),G1tensor(267),G1tensor(268),G1tensor(269),G1tensor(270))
  call G_TensorShift(G1tensor(266),16)
  call Hotf_5pt_reduction_last(G2tensor(54),RedSet_5(10),mass5set(:,8),  & 
G1tensor(271),G1tensor(272),G1tensor(273),G1tensor(274),G1tensor(275),G1tensor(276))
  call G_TensorShift(G1tensor(272),16)
  call Hotf_5pt_reduction_last(G2tensor(56),RedSet_5(10),mass5set(:,9),  & 
G1tensor(277),G1tensor(278),G1tensor(279),G1tensor(280),G1tensor(281),G1tensor(282))
  call G_TensorShift(G1tensor(278),16)
  call Hotf_5pt_reduction_last(G2tensor(58),RedSet_5(11),mass5set(:,1),  & 
G1tensor(283),G1tensor(284),G1tensor(285),G1tensor(286),G1tensor(287),G1tensor(288))
  call G_TensorShift(G1tensor(284),8)
  call Hotf_5pt_reduction_last(G2tensor(60),RedSet_5(12),mass5set(:,7),  & 
G1tensor(289),G1tensor(290),G1tensor(291),G1tensor(292),G1tensor(293),G1tensor(294))
  call G_TensorShift(G1tensor(290),8)
  call Hotf_5pt_reduction_last(G2tensor(62),RedSet_5(12),mass5set(:,8),  & 
G1tensor(295),G1tensor(296),G1tensor(297),G1tensor(298),G1tensor(299),G1tensor(300))
  call G_TensorShift(G1tensor(296),8)
  call Hotf_5pt_reduction_last(G2tensor(64),RedSet_5(12),mass5set(:,9),  & 
G1tensor(301),G1tensor(302),G1tensor(303),G1tensor(304),G1tensor(305),G1tensor(306))
  call G_TensorShift(G1tensor(302),8)
  call Hotf_5pt_reduction_last(G2tensor(78),RedSet_5(15),mass5set(:,11),  & 
G1tensor(307),G1tensor(308),G1tensor(309),G1tensor(310),G1tensor(311),G1tensor(312))
  call G_TensorShift(G1tensor(308),24)
  call Hotf_5pt_reduction_last(G2tensor(81),RedSet_5(15),mass5set(:,3),  & 
G1tensor(313),G1tensor(314),G1tensor(315),G1tensor(316),G1tensor(317),G1tensor(318))
  call G_TensorShift(G1tensor(314),24)
  call Hotf_5pt_reduction_last(G2tensor(84),RedSet_5(15),mass5set(:,12),  & 
G1tensor(319),G1tensor(320),G1tensor(321),G1tensor(322),G1tensor(323),G1tensor(324))
  call G_TensorShift(G1tensor(320),24)
  call Hotf_5pt_reduction_last(G2tensor(87),RedSet_5(16),mass5set(:,4),  & 
G1tensor(325),G1tensor(326),G1tensor(327),G1tensor(328),G1tensor(329),G1tensor(330))
  call G_TensorShift(G1tensor(326),24)
  call Hotf_5pt_reduction_last(G2tensor(90),RedSet_5(16),mass5set(:,3),  & 
G1tensor(331),G1tensor(332),G1tensor(333),G1tensor(334),G1tensor(335),G1tensor(336))
  call G_TensorShift(G1tensor(332),24)
  call Hotf_5pt_reduction_last(G2tensor(93),RedSet_5(16),mass5set(:,12),  & 
G1tensor(337),G1tensor(338),G1tensor(339),G1tensor(340),G1tensor(341),G1tensor(342))
  call G_TensorShift(G1tensor(338),24)
  call ol_merge_tensors(T1sum(13),[G1tensor(1)])
  call ol_merge_tensors(T1sum(14),[G1tensor(37)])
  call ol_merge_tensors(T1sum(15),[G1tensor(38)])
  call ol_merge_tensors(T1sum(16),[G1tensor(56)])
  call ol_merge_tensors(T1sum(17),[G1tensor(2)])
  call ol_merge_tensors(T1sum(18),[G1tensor(10)])
  call ol_merge_tensors(T1sum(19),[G1tensor(24)])
  call ol_merge_tensors(T1sum(20),[G1tensor(26)])
  call ol_merge_tensors(T1sum(21),[G1tensor(39)])
  call ol_merge_tensors(T1sum(22),[G1tensor(45)])
  call ol_merge_tensors(T1sum(23),[G1tensor(59)])
  call ol_merge_tensors(T1sum(24),[G1tensor(60)])
  call ol_merge_tensors(T1sum(25),[G1tensor(73)])
  call ol_merge_tensors(T1sum(26),[G1tensor(79)])
  call ol_merge_tensors(T1sum(27),[G1tensor(85)])
  call ol_merge_tensors(T1sum(28),[G1tensor(91)])
  call ol_merge_tensors(T1sum(29),[G1tensor(97)])
  call ol_merge_tensors(T1sum(30),[G1tensor(103)])
  call ol_merge_tensors(T1sum(31),[G1tensor(109)])
  call ol_merge_tensors(T1sum(32),[G1tensor(115)])
  call ol_merge_tensors(T1sum(33),[G1tensor(121)])
  call ol_merge_tensors(T1sum(34),[G1tensor(127)])
  call ol_merge_tensors(T1sum(35),[G1tensor(133)])
  call ol_merge_tensors(T1sum(36),[G1tensor(139)])
  call ol_merge_tensors(T1sum(37),[G1tensor(145)])
  call ol_merge_tensors(T1sum(38),[G1tensor(151)])
  call ol_merge_tensors(T1sum(39),[G1tensor(157)])
  call ol_merge_tensors(T1sum(40),[G1tensor(163)])
  call ol_merge_tensors(T1sum(41),[G1tensor(169)])
  call ol_merge_tensors(T1sum(42),[G1tensor(175)])
  call ol_merge_tensors(T1sum(43),[G1tensor(181)])
  call ol_merge_tensors(T1sum(44),[G1tensor(187)])
  call ol_merge_tensors(T1sum(45),[G1tensor(193)])
  call ol_merge_tensors(T1sum(46),[G1tensor(199)])
  call ol_merge_tensors(T1sum(47),[G1tensor(205)])
  call ol_merge_tensors(T1sum(48),[G1tensor(211)])
  call ol_merge_tensors(T1sum(49),[G1tensor(217)])
  call ol_merge_tensors(T1sum(50),[G1tensor(223)])
  call ol_merge_tensors(T1sum(51),[G1tensor(229)])
  call ol_merge_tensors(T1sum(52),[G1tensor(235)])
  call ol_merge_tensors(T1sum(53),[G1tensor(241)])
  call ol_merge_tensors(T1sum(54),[G1tensor(247)])
  call ol_merge_tensors(T1sum(55),[G1tensor(253)])
  call ol_merge_tensors(T1sum(56),[G1tensor(259)])
  call ol_merge_tensors(T1sum(57),[G1tensor(265)])
  call ol_merge_tensors(T1sum(58),[G1tensor(271)])
  call ol_merge_tensors(T1sum(59),[G1tensor(277)])
  call ol_merge_tensors(T1sum(60),[G1tensor(283)])
  call ol_merge_tensors(T1sum(61),[G1tensor(289)])
  call ol_merge_tensors(T1sum(62),[G1tensor(295)])
  call ol_merge_tensors(T1sum(63),[G1tensor(301)])
  call ol_merge_tensors(T1sum(64),[G1tensor(307)])
  call ol_merge_tensors(T1sum(65),[G1tensor(313)])
  call ol_merge_tensors(T1sum(66),[G1tensor(319)])
  call ol_merge_tensors(T1sum(67),[G1tensor(325)])
  call ol_merge_tensors(T1sum(68),[G1tensor(331)])
  call ol_merge_tensors(T1sum(69),[G1tensor(337)])
  Gcoeff(:)%j = (c(19)*M(2,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(39),h0tab(:,39),[32,4,3,24],[0,0,0,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,39),heltab2x64(:,:,39))
  Gcoeff(:)%j = (-(c(30)*M(2,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(40),h0tab(:,40),[32,4,3,24],[0,0,0,0],4,2,wf4(:,1),wf4(:,4))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,40),heltab2x64(:,:,40))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)+c(18)*M(4,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(41),h0tab(:,41),[32,4,3,24],[0,0,0,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,41),heltab2x64(:,:,41))
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(29)*M(4,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(42),h0tab(:,42),[32,4,3,24],[nMZ,0,0,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(6),ngZd,m3h2x32(:,42),heltab2x64(:,:,42))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)+c(36)*M(3,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(43),h0tab(:,43),[32,4,3,24],[0,0,0,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,43),heltab2x64(:,:,43))
  Gcoeff(:)%j = (-(c(24)*M(2,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(44),h0tab(:,44),[32,3,24,4],[0,0,0,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,44),heltab2x64(:,:,44))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(3),n2h32(23))
  Gcoeff(:)%j = (-(c(30)*M(2,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(45),h0tab(:,45),[32,3,24,4],[0,0,0,0],4,2,wf4(:,1),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,45),heltab2x64(:,:,45))
  call Hloop_A_Q(ntryL,G0H32(7),32,0,G1H32(2),n2h32(24))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)+c(18)*M(4,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(46),h0tab(:,46),[32,3,24,4],[0,0,0,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,46),heltab2x64(:,:,46))
  call Hloop_A_Q(ntryL,G0H32(8),32,0,G1H32(9),n2h32(25))
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(29)*M(4,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(47),h0tab(:,47),[32,3,24,4],[0,0,0,nMZ],4,2,wf4(:,1),wf4(:,3))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(9),ngZd,m3h2x32(:,47),heltab2x64(:,:,47))
  call Hloop_A_Q(ntryL,G0H32(9),32,0,G1H32(8),n2h32(26))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)+c(36)*M(3,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(48),h0tab(:,48),[32,3,24,4],[0,0,0,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,48),heltab2x64(:,:,48))
  call Hloop_A_Q(ntryL,G0H32(10),32,0,G1H32(1),n2h32(27))
  Gcoeff(:)%j = (c(31)*M(1,:)%j-c(32)*M(3,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(49),h0tab(:,49),[32,3,4,24],[0,0,0,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,49),heltab2x64(:,:,49))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(6),n2h32(28))
  Gcoeff(:)%j = (c(25)*M(2,:)%j-c(26)*M(4,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(50),h0tab(:,50),[32,3,4,24],[nMW,0,0,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,50),heltab2x64(:,:,50))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)+c(21)*M(4,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(51),h0tab(:,51),[32,3,4,24],[0,nMW,0,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,51),heltab2x64(:,:,51))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(13)*M(4,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(52),h0tab(:,52),[32,3,4,24],[nMW,nMZ,0,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,52),heltab2x64(:,:,52))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(13)*M(4,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(53),h0tab(:,53),[32,3,4,24],[nMZ,nMW,0,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(10),ngZd,m3h2x32(:,53),heltab2x64(:,:,53))
  Gcoeff(:)%j = (-(c(7)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(54),h0tab(:,54),[36,3,8,16],[0,0,0,0],4,2,wf4(:,2),wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,1),heltab2x64(:,:,54))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(1),n2h16(13))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)+c(18)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(55),h0tab(:,55),[32,7,16,8],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,54),heltab2x64(:,:,55))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(4),n2h32(29))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)+c(18)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(56),h0tab(:,56),[32,7,16,8],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,55),heltab2x64(:,:,56))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(5),n2h32(30))
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(29)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(57),h0tab(:,57),[32,7,16,8],[0,0,0,nMZ],4,1,wf8(:,3))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),ngZd,m3h2x32(:,56),heltab2x64(:,:,57))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(7),n2h32(31))
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(29)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(58),h0tab(:,58),[32,7,16,8],[0,nMZ,0,0],4,1,wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,57),heltab2x64(:,:,58))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(12),n2h32(32))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)-c(41)*M(3,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(59),h0tab(:,59),[32,7,16,8],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,58),heltab2x64(:,:,59))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(10),n2h32(33))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)+c(18)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(60),h0tab(:,60),[32,7,8,16],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,59),heltab2x64(:,:,60))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(11),n2h32(34))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)+c(18)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(61),h0tab(:,61),[32,7,8,16],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,60),heltab2x64(:,:,61))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(13),n2h32(35))
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(29)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(62),h0tab(:,62),[32,7,8,16],[0,nMZ,0,0],4,1,wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,61),heltab2x64(:,:,62))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(14),n2h32(36))
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(29)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(63),h0tab(:,63),[32,7,8,16],[0,0,0,nMZ],4,1,wf8(:,3))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),ngZd,m3h2x32(:,62),heltab2x64(:,:,63))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(15),n2h32(37))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)+c(37)*M(3,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(64),h0tab(:,64),[32,7,8,16],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,63),heltab2x64(:,:,64))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(16),n2h32(38))
  Gcoeff(:)%j = (c(5)*M(2,:)%j-c(6)*M(4,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(65),h0tab(:,65),[32,4,16,11],[0,0,0,nMW],4,1,wf8(:,12))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,64),heltab2x64(:,:,65))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(17),n2h32(39))
  Gcoeff(:)%j = (c(5)*M(2,:)%j-c(6)*M(4,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(66),h0tab(:,66),[32,4,16,11],[0,nMW,0,0],4,1,wf8(:,12))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,65),heltab2x64(:,:,66))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(18),n2h32(40))
  Gcoeff(:)%j = (c(5)*M(2,:)%j-c(6)*M(4,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(67),h0tab(:,67),[32,4,11,16],[0,0,0,nMW],4,1,wf8(:,12))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,66),heltab2x64(:,:,67))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(19),n2h32(41))
  Gcoeff(:)%j = (c(5)*M(2,:)%j-c(6)*M(4,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(68),h0tab(:,68),[32,4,11,16],[0,nMW,0,0],4,1,wf8(:,12))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,67),heltab2x64(:,:,68))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(20),n2h32(42))
  Gcoeff(:)%j = (c(22)*M(2,:)%j-c(23)*M(4,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(69),h0tab(:,69),[35,4,8,16],[0,0,0,0],4,1,wf8(:,37))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,37),G0H8(1),m3h8x8(:,1),heltab2x64(:,:,69))
  call Hloop_A_Q(ntryL,G0H8(1),35,0,G1H8(1),n2h8(17))
  Gcoeff(:)%j = (c(22)*M(2,:)%j-c(23)*M(4,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(70),h0tab(:,70),[35,4,8,16],[0,0,0,0],4,1,wf8(:,37))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,37),G0H8(1),m3h8x8(:,2),heltab2x64(:,:,70))
  call Hloop_A_Q(ntryL,G0H8(1),35,0,G1H8(2),n2h8(18))
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(29)*M(4,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(71),h0tab(:,71),[35,4,8,16],[0,nMZ,0,0],4,1,wf8(:,37))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,37),G0H8(1),m3h8x8(:,3),heltab2x64(:,:,71))
  call Hloop_A_Q(ntryL,G0H8(1),35,0,G1H8(5),n2h8(19))
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(29)*M(4,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(72),h0tab(:,72),[35,4,8,16],[0,0,0,nMZ],4,1,wf8(:,37))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,37),G0H8(1),ngZu,m3h8x8(:,4),heltab2x64(:,:,72))
  call Hloop_A_Q(ntryL,G0H8(1),35,0,G1H8(6),n2h8(20))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)+c(37)*M(3,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(73),h0tab(:,73),[35,4,8,16],[0,0,0,0],4,1,wf8(:,37))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,37),G0H8(1),m3h8x8(:,5),heltab2x64(:,:,73))
  call Hloop_A_Q(ntryL,G0H8(1),35,0,G1H8(3),n2h8(21))
  Gcoeff(:)%j = (c(22)*M(2,:)%j-c(23)*M(4,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(74),h0tab(:,74),[35,4,16,8],[0,0,0,0],4,1,wf8(:,37))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,37),G0H8(1),m3h8x8(:,6),heltab2x64(:,:,74))
  call Hloop_A_Q(ntryL,G0H8(1),35,0,G1H8(4),n2h8(22))
  Gcoeff(:)%j = (c(22)*M(2,:)%j-c(23)*M(4,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(75),h0tab(:,75),[35,4,16,8],[0,0,0,0],4,1,wf8(:,37))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,37),G0H8(1),m3h8x8(:,7),heltab2x64(:,:,75))
  call Hloop_A_Q(ntryL,G0H8(1),35,0,G1H8(7),n2h8(23))
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(29)*M(4,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(76),h0tab(:,76),[35,4,16,8],[0,nMZ,0,0],4,1,wf8(:,37))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,37),G0H8(1),m3h8x8(:,8),heltab2x64(:,:,76))
  call Hloop_A_Q(ntryL,G0H8(1),35,0,G1H8(8),n2h8(24))
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(29)*M(4,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(77),h0tab(:,77),[35,4,16,8],[0,0,0,nMZ],4,1,wf8(:,37))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,37),G0H8(1),ngZu,m3h8x8(:,9),heltab2x64(:,:,77))
  call Hloop_A_Q(ntryL,G0H8(1),35,0,G1H8(11),n2h8(25))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)-c(41)*M(3,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(78),h0tab(:,78),[35,4,16,8],[0,0,0,0],4,1,wf8(:,37))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,37),G0H8(1),m3h8x8(:,10),heltab2x64(:,:,78))
  call Hloop_A_Q(ntryL,G0H8(1),35,0,G1H8(12),n2h8(26))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)+c(26)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(79),h0tab(:,79),[32,1,2,28],[nMW,0,0,0],4,1,wf8(:,7))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,68),heltab2x64(:,:,79))
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(29)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(80),h0tab(:,80),[32,1,2,28],[nMW,0,nMZ,0],4,1,wf8(:,7))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(11),m3h2x32(:,69),heltab2x64(:,:,80))
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(29)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(81),h0tab(:,81),[32,1,2,28],[nMZ,0,nMW,0],4,1,wf8(:,7))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(12),ngZd,m3h2x32(:,70),heltab2x64(:,:,81))
  Gcoeff(:)%j = (c(20)*M(2,:)%j-c(21)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(82),h0tab(:,82),[32,2,1,28],[0,0,nMW,0],4,1,wf8(:,7))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(13),m3h2x32(:,71),heltab2x64(:,:,82))
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(29)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(83),h0tab(:,83),[32,2,1,28],[nMW,0,nMZ,0],4,1,wf8(:,7))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(14),m3h2x32(:,72),heltab2x64(:,:,83))
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(29)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(84),h0tab(:,84),[32,2,1,28],[nMZ,0,nMW,0],4,1,wf8(:,7))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(15),ngZd,m3h2x32(:,73),heltab2x64(:,:,84))
  Gcoeff(:)%j = (c(20)*M(2,:)%j-c(21)*M(4,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(85),h0tab(:,85),[56,2,1,4],[0,0,nMW,0],4,1,wf8(:,41))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,41),G0H8(1),m3h8x8(:,11),heltab2x64(:,:,85))
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(29)*M(4,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(86),h0tab(:,86),[56,2,1,4],[nMW,0,nMZ,0],4,1,wf8(:,41))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,41),G0H8(2),m3h8x8(:,12),heltab2x64(:,:,86))
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(29)*M(4,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(87),h0tab(:,87),[56,2,1,4],[nMZ,0,nMW,0],4,1,wf8(:,41))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,41),G0H8(3),ngZd,m3h8x8(:,13),heltab2x64(:,:,87))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)+c(26)*M(4,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(88),h0tab(:,88),[56,1,2,4],[nMW,0,0,0],4,1,wf8(:,41))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,41),G0H8(4),m3h8x8(:,14),heltab2x64(:,:,88))
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(29)*M(4,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(89),h0tab(:,89),[56,1,2,4],[nMW,0,nMZ,0],4,1,wf8(:,41))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,41),G0H8(5),m3h8x8(:,15),heltab2x64(:,:,89))
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(29)*M(4,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(90),h0tab(:,90),[56,1,2,4],[nMZ,0,nMW,0],4,1,wf8(:,41))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,41),G0H8(6),ngZd,m3h8x8(:,16),heltab2x64(:,:,90))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(3),[G0H32(5),G0H32(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(1),[G1H32(9),G1H32(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(10),[G1H32(5),G1H32(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(16),[G1H32(13),G1H32(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(3),[G1H8(2),G1H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(12),[G1H8(7),G1H8(4)])
  call Hloop_VQ_A(ntryL,G0H32(3),ex3(:),G0H16(1),m3h2x16(:,25),heltab2x32(:,:,35))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(2),n2h16(14))
  call Hloop_VQ_A(ntryL,G0H32(2),ex3(:),G0H16(1),m3h2x16(:,26),heltab2x32(:,:,36))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(3),n2h16(15))
  call Hloop_ZQ_A(ntryL,G0H32(6),ex3(:),G0H16(1),ngZu,m3h2x16(:,27),heltab2x32(:,:,37))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(4),n2h16(16))
  call Hloop_AW_Q(ntryL,G1H32(1),wf4(:,1),G1H8(13),m3h4x8(:,11),heltab2x32(:,:,38))
  call Hloop_A_Q(ntryL,G1H8(13),35,0,G2H8(2),n2h8(27))
  call Hloop_AW_Q(ntryL,G1H32(2),wf4(:,1),G1H8(14),m3h4x8(:,12),heltab2x32(:,:,39))
  call Hloop_A_Q(ntryL,G1H8(14),35,0,G2H8(3),n2h8(28))
  call Hloop_AW_Q(ntryL,G1H32(8),wf4(:,1),G1H8(17),m3h4x8(:,13),heltab2x32(:,:,40))
  call Hloop_A_Q(ntryL,G1H8(17),35,0,G2H8(4),n2h8(29))
  call Hloop_AW_Q(ntryL,G1H32(6),wf4(:,1),G1H8(18),m3h4x8(:,14),heltab2x32(:,:,41))
  call Hloop_A_Q(ntryL,G1H8(18),35,0,G2H8(5),n2h8(30))
  call Hloop_UV_W(ntryL,G0H32(7),32,wf4(:,1),3,G1H8(2),m3h4x8(:,15),heltab2x32(:,:,42))
  call Hloop_UW_V(ntryL,G0H32(8),32,wf4(:,1),3,G1H8(1),m3h4x8(:,16),heltab2x32(:,:,43))
  call Hloop_UV_W(ntryL,G0H32(9),32,wf4(:,1),3,G1H8(7),m3h4x8(:,17),heltab2x32(:,:,44))
  call Hloop_UW_V(ntryL,G0H32(10),32,wf4(:,1),3,G1H8(4),m3h4x8(:,18),heltab2x32(:,:,45))
  call Hloop_AW_Q(ntryL,G1H16(1),wf4(:,1),G1H4(56),m3h4x4(:,5),heltab2x16(:,:,25))
  call Hloop_A_Q(ntryL,G1H4(56),39,0,G2H4(3),n2h4(33))
  call Hloop_AQ_V(ntryL,G1H32(10),wf8(:,3),G1H4(59),m3h8x4(:,1),heltab2x32(:,:,46))
  call Hloop_AQ_V(ntryL,G1H32(7),wf8(:,3),G1H4(60),m3h8x4(:,2),heltab2x32(:,:,47))
  call Hloop_AQ_Z(ntryL,G1H32(12),wf8(:,3),G1H4(12),ngZd,m3h8x4(:,3),heltab2x32(:,:,48))
  call Hloop_AQ_V(ntryL,G1H32(16),wf8(:,3),G1H4(18),m3h8x4(:,4),heltab2x32(:,:,49))
  call Hloop_AQ_Z(ntryL,G1H32(14),wf8(:,3),G1H4(30),ngZd,m3h8x4(:,5),heltab2x32(:,:,50))
  call Hloop_AQ_V(ntryL,G1H32(15),wf8(:,3),G1H4(31),m3h8x4(:,6),heltab2x32(:,:,51))
  call Hloop_AQ_V(ntryL,G1H32(17),ex3(:),G1H16(5),m3h2x16(:,28),heltab2x32(:,:,52))
  call Hloop_AQ_W(ntryL,G1H32(18),ex3(:),G1H16(6),m3h2x16(:,29),heltab2x32(:,:,53))
  call Hloop_AQ_V(ntryL,G1H32(19),ex3(:),G1H16(7),m3h2x16(:,30),heltab2x32(:,:,54))
  call Hloop_AQ_W(ntryL,G1H32(20),ex3(:),G1H16(8),m3h2x16(:,31),heltab2x32(:,:,55))
  call Hloop_AQ_V(ntryL,G1H8(3),ex3(:),G1H4(32),m3h2x4(:,31),heltab2x8(:,:,37))
  call Hloop_AQ_Z(ntryL,G1H8(5),ex3(:),G1H4(5),ngZu,m3h2x4(:,32),heltab2x8(:,:,38))
  call Hloop_AQ_V(ntryL,G1H8(6),ex3(:),G1H4(29),m3h2x4(:,33),heltab2x8(:,:,39))
  call Hloop_AQ_V(ntryL,G1H8(12),ex3(:),G1H4(35),m3h2x4(:,34),heltab2x8(:,:,40))
  call Hloop_AQ_Z(ntryL,G1H8(8),ex3(:),G1H4(15),ngZu,m3h2x4(:,35),heltab2x8(:,:,41))
  call Hloop_AQ_V(ntryL,G1H8(11),ex3(:),G1H4(16),m3h2x4(:,36),heltab2x8(:,:,42))
  call Hloop_WA_Q(ntryL,G0H32(4),ex1(:),G0H16(1),m3h2x16(:,32),heltab2x32(:,:,56))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(9),n2h16(17))
  call Hloop_WA_Q(ntryL,G0H32(11),ex1(:),G0H16(1),m3h2x16(:,33),heltab2x32(:,:,57))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(10),n2h16(18))
  call Hloop_ZA_Q(ntryL,G0H32(12),ex1(:),G0H16(1),ngZn,m3h2x16(:,34),heltab2x32(:,:,58))
  call Hloop_A_Q(ntryL,G0H16(1),33,0,G1H16(11),n2h16(19))
  call Hloop_VQ_A(ntryL,G0H32(13),ex2(:),G0H16(1),m3h2x16(:,35),heltab2x32(:,:,59))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(12),n2h16(20))
  call Hloop_WQ_A(ntryL,G0H32(14),ex2(:),G0H16(1),m3h2x16(:,36),heltab2x32(:,:,60))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(1),n2h16(21))
  call Hloop_ZQ_A(ntryL,G0H32(15),ex2(:),G0H16(1),ngZl,m3h2x16(:,37),heltab2x32(:,:,61))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(13),n2h16(22))
  call Hloop_VQ_A(ntryL,G0H8(1),ex2(:),G0H4(1),m3h2x4(:,37),heltab2x8(:,:,43))
  call Hloop_Q_A(ntryL,G0H4(1),58,0,G1H4(21),n2h4(34))
  call Hloop_WQ_A(ntryL,G0H8(2),ex2(:),G0H4(1),m3h2x4(:,38),heltab2x8(:,:,44))
  call Hloop_Q_A(ntryL,G0H4(1),58,0,G1H4(37),n2h4(35))
  call Hloop_ZQ_A(ntryL,G0H8(3),ex2(:),G0H4(1),ngZl,m3h2x4(:,39),heltab2x8(:,:,45))
  call Hloop_Q_A(ntryL,G0H4(1),58,0,G1H4(38),n2h4(36))
  call Hloop_WA_Q(ntryL,G0H8(4),ex1(:),G0H4(1),m3h2x4(:,40),heltab2x8(:,:,46))
  call Hloop_A_Q(ntryL,G0H4(1),57,0,G1H4(41),n2h4(37))
  call Hloop_WA_Q(ntryL,G0H8(5),ex1(:),G0H4(1),m3h2x4(:,41),heltab2x8(:,:,47))
  call Hloop_A_Q(ntryL,G0H4(1),57,0,G1H4(47),n2h4(38))
  call Hloop_ZA_Q(ntryL,G0H8(6),ex1(:),G0H4(1),ngZn,m3h2x4(:,42),heltab2x8(:,:,48))
  call Hloop_A_Q(ntryL,G0H4(1),57,0,G1H4(48),n2h4(39))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(18),[G1H4(10),G1H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(30),[G1H4(28),G1H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(59),[G1H4(46),G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(12),[G1H4(52),G1H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(32),[G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(5),[G1H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(29),[G1H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(31),[G1H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(35),[G1H4(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(15),[G1H4(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(16),[G1H4(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(60),[G1H4(58)])
  call Hloop_VQ_A(ntryL,G1H4(13),ex4(:),G1H2(21),m3h2x2(:,81),heltab2x4(:,:,99))
  call Hloop_Q_A(ntryL,G1H2(21),47,0,G2H2(8),n2h2(61))
  call Hloop_VQ_A(ntryL,G1H4(18),ex4(:),G1H2(29),m3h2x2(:,82),heltab2x4(:,:,100))
  call Hloop_Q_A(ntryL,G1H2(29),47,0,G2H2(12),n2h2(62))
  call Hloop_ZQ_A(ntryL,G1H4(25),ex4(:),G1H2(36),ngZu,m3h2x2(:,83),heltab2x4(:,:,101))
  call Hloop_Q_A(ntryL,G1H2(36),47,0,G2H2(10),n2h2(63))
  call Hloop_ZQ_A(ntryL,G1H4(30),ex4(:),G1H2(27),ngZu,m3h2x2(:,84),heltab2x4(:,:,102))
  call Hloop_Q_A(ntryL,G1H2(27),47,0,G2H2(14),n2h2(64))
  call Hloop_VA_Q(ntryL,G1H4(1),ex5(:),G1H2(42),m3h2x2(:,85),heltab2x4(:,:,103))
  call Hloop_A_Q(ntryL,G1H2(42),55,0,G2H2(16),n2h2(65))
  call Hloop_VA_Q(ntryL,G1H4(59),ex5(:),G1H2(33),m3h2x2(:,86),heltab2x4(:,:,104))
  call Hloop_A_Q(ntryL,G1H2(33),55,0,G2H2(18),n2h2(66))
  call Hloop_ZA_Q(ntryL,G1H4(11),ex5(:),G1H2(41),ngZu,m3h2x2(:,87),heltab2x4(:,:,105))
  call Hloop_A_Q(ntryL,G1H2(41),55,0,G2H2(22),n2h2(67))
  call Hloop_ZA_Q(ntryL,G1H4(12),ex5(:),G1H2(39),ngZu,m3h2x2(:,88),heltab2x4(:,:,106))
  call Hloop_A_Q(ntryL,G1H2(39),55,0,G2H2(20),n2h2(68))
  call Hloop_QW_A(ntryL,G1H8(9),wf4(:,1),G1H2(31),m3h4x2(:,7),heltab2x8(:,:,49))
  call Hloop_Q_A(ntryL,G1H2(31),47,0,G2H2(21),n2h2(69))
  call Hloop_QW_A(ntryL,G1H8(10),wf4(:,1),G1H2(37),m3h4x2(:,8),heltab2x8(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(37),47,0,G2H2(19),n2h2(70))
  call Hloop_VQ_A(ntryL,G1H4(32),ex4(:),G1H2(40),m3h2x2(:,89),heltab2x4(:,:,107))
  call Hloop_Q_A(ntryL,G1H2(40),47,0,G2H2(1),n2h2(71))
  call Hloop_ZQ_A(ntryL,G1H4(5),ex4(:),G1H2(16),ngZu,m3h2x2(:,90),heltab2x4(:,:,108))
  call Hloop_Q_A(ntryL,G1H2(16),47,0,G2H2(2),n2h2(72))
  call Hloop_VQ_A(ntryL,G1H4(29),ex4(:),G1H2(22),m3h2x2(:,91),heltab2x4(:,:,109))
  call Hloop_Q_A(ntryL,G1H2(22),47,0,G2H2(3),n2h2(73))
  call Hloop_VQ_A(ntryL,G1H4(31),ex4(:),G1H2(34),m3h2x2(:,92),heltab2x4(:,:,110))
  call Hloop_Q_A(ntryL,G1H2(34),47,0,G2H2(4),n2h2(74))
  call Hloop_AW_Q(ntryL,G1H8(15),wf4(:,1),G1H2(35),m3h4x2(:,9),heltab2x8(:,:,51))
  call Hloop_A_Q(ntryL,G1H2(35),55,0,G2H2(5),n2h2(75))
  call Hloop_AW_Q(ntryL,G1H8(16),wf4(:,1),G1H2(1),m3h4x2(:,10),heltab2x8(:,:,52))
  call Hloop_A_Q(ntryL,G1H2(1),55,0,G2H2(6),n2h2(76))
  call Hloop_VA_Q(ntryL,G1H4(35),ex5(:),G1H2(5),m3h2x2(:,93),heltab2x4(:,:,111))
  call Hloop_A_Q(ntryL,G1H2(5),55,0,G2H2(7),n2h2(77))
  call Hloop_ZA_Q(ntryL,G1H4(15),ex5(:),G1H2(6),ngZu,m3h2x2(:,94),heltab2x4(:,:,112))
  call Hloop_A_Q(ntryL,G1H2(6),55,0,G2H2(9),n2h2(78))
  call Hloop_VA_Q(ntryL,G1H4(16),ex5(:),G1H2(9),m3h2x2(:,95),heltab2x4(:,:,113))
  call Hloop_A_Q(ntryL,G1H2(9),55,0,G2H2(11),n2h2(79))
  call Hloop_VA_Q(ntryL,G1H4(60),ex5(:),G1H2(17),m3h2x2(:,96),heltab2x4(:,:,114))
  call Hloop_A_Q(ntryL,G1H2(17),55,0,G2H2(13),n2h2(80))
  call Hloop_QW_A(ntryL,G1H16(2),wf4(:,1),G1H4(49),m3h4x4(:,6),heltab2x16(:,:,26))
  call Hloop_Q_A(ntryL,G1H4(49),39,0,G2H4(4),n2h4(40))
  call Hloop_QW_A(ntryL,G1H16(3),wf4(:,1),G1H4(55),m3h4x4(:,7),heltab2x16(:,:,27))
  call Hloop_Q_A(ntryL,G1H4(55),39,0,G2H4(5),n2h4(41))
  call Hloop_QW_A(ntryL,G1H16(4),wf4(:,1),G1H4(56),m3h4x4(:,8),heltab2x16(:,:,28))
  call Hloop_Q_A(ntryL,G1H4(56),39,0,G2H4(6),n2h4(42))
  call Hotf_4pt_reduction(G2H8(2),RedSet_4(48),mass4set(:,1),  & 
G1H8(13),G1H8(14),G1H8(17),G1H8(18),G1H8(3),8)
  call HG1shiftOLR(G1H8(14),4,8)
  call Hotf_4pt_reduction(G2H8(3),RedSet_4(48),mass4set(:,1),  & 
G1H8(5),G1H8(6),G1H8(12),G1H8(8),G1H8(11),8)
  call HG1shiftOLR(G1H8(6),4,8)
  call Hotf_4pt_reduction(G2H8(4),RedSet_4(48),mass4set(:,2),  & 
G1H8(9),G1H8(10),G1H8(15),G1H8(16),G1H8(19),8)
  call HG1shiftOLR(G1H8(10),4,8)
  call Hloop_AQ_V(ntryL,G2H8(5),ex3(:),G2H4(7),m3h2x4(:,43),heltab2x8(:,:,53))
  call Hloop_VQ_A(ntryL,G1H8(2),ex3(:),G1H4(10),m3h2x4(:,44),heltab2x8(:,:,54))
  call Hloop_Q_A(ntryL,G1H4(10),39,0,G2H4(8),n2h4(43))
  call Hloop_WQ_A(ntryL,G1H8(1),ex3(:),G1H4(14),m3h2x4(:,45),heltab2x8(:,:,55))
  call Hloop_Q_A(ntryL,G1H4(14),39,0,G2H4(9),n2h4(44))
  call Hloop_ZQ_A(ntryL,G1H8(7),ex3(:),G1H4(28),ngZu,m3h2x4(:,46),heltab2x8(:,:,56))
  call Hloop_Q_A(ntryL,G1H4(28),39,0,G2H4(10),n2h4(45))
  call Hloop_WQ_A(ntryL,G1H8(4),ex3(:),G1H4(26),m3h2x4(:,47),heltab2x8(:,:,57))
  call Hloop_Q_A(ntryL,G1H4(26),39,0,G2H4(13),n2h4(46))
  call Hloop_AQ_V(ntryL,G2H4(3),ex4(:),G2H2(15),m3h2x2(:,97),heltab2x4(:,:,115))
  call Hloop_VA_Q(ntryL,G1H16(5),ex5(:),G1H8(2),m3h2x8(:,21),heltab2x16(:,:,29))
  call Hloop_A_Q(ntryL,G1H8(2),52,0,G2H8(6),n2h8(31))
  call Hloop_WA_Q(ntryL,G1H16(6),ex5(:),G1H8(1),m3h2x8(:,22),heltab2x16(:,:,30))
  call Hloop_A_Q(ntryL,G1H8(1),52,0,G2H8(7),n2h8(32))
  call Hloop_VQ_A(ntryL,G1H16(7),wf8(:,12),G1H2(21),m3h8x2(:,1),heltab2x16(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(21),47,0,G2H2(17),n2h2(81))
  call Hloop_WQ_A(ntryL,G1H16(8),wf8(:,12),G1H2(29),m3h8x2(:,2),heltab2x16(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(29),47,0,G2H2(23),n2h2(82))
  call Hloop_AQ_V(ntryL,G1H16(9),ex2(:),G1H8(7),m3h2x8(:,23),heltab2x16(:,:,33))
  call Hloop_AQ_Z(ntryL,G1H16(10),ex2(:),G1H8(4),ngZl,m3h2x8(:,24),heltab2x16(:,:,34))
  call Hloop_AQ_W(ntryL,G1H16(11),ex2(:),G1H8(2),m3h2x8(:,25),heltab2x16(:,:,35))
  call Hloop_QA_W(ntryL,G1H16(12),ex1(:),G1H8(1),m3h2x8(:,26),heltab2x16(:,:,36))
  call Hloop_QA_Z(ntryL,G1H16(1),ex1(:),G1H8(20),ngZn,m3h2x8(:,27),heltab2x16(:,:,37))
  call Hloop_QA_W(ntryL,G1H16(13),ex1(:),G1H8(21),m3h2x8(:,28),heltab2x16(:,:,38))
  call Hloop_QA_W(ntryL,G1H4(21),ex1(:),G1H2(36),m3h2x2(:,98),heltab2x4(:,:,116))
  call Hloop_QA_Z(ntryL,G1H4(37),ex1(:),G1H2(27),ngZn,m3h2x2(:,99),heltab2x4(:,:,117))
  call Hloop_QA_W(ntryL,G1H4(38),ex1(:),G1H2(42),m3h2x2(:,100),heltab2x4(:,:,118))
  call Hloop_AQ_V(ntryL,G1H4(41),ex2(:),G1H2(33),m3h2x2(:,101),heltab2x4(:,:,119))
  call Hloop_AQ_Z(ntryL,G1H4(47),ex2(:),G1H2(41),ngZl,m3h2x2(:,102),heltab2x4(:,:,120))
  call Hloop_AQ_W(ntryL,G1H4(48),ex2(:),G1H2(39),m3h2x2(:,103),heltab2x4(:,:,121))
  call Hloop_AV_Q(ntryL,G1H8(13),wf4(:,3),G1H2(31),m3h4x2(:,11),heltab2x8(:,:,58))
  call Hloop_A_Q(ntryL,G1H2(31),59,0,G2H2(25),n2h2(83))
call HGT_raise_alpha_OLR(G1H8(14),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(14),ex3(:),G1H4(46),m3h2x4(:,48),heltab2x8(:,:,59))
  call Hloop_AV_Q(ntryL,G1H8(18),wf4(:,3),G1H2(37),m3h4x2(:,12),heltab2x8(:,:,60))
  call Hloop_A_Q(ntryL,G1H2(37),59,0,G2H2(26),n2h2(84))
  call Hloop_AV_Q(ntryL,G1H8(3),wf4(:,3),G1H2(40),m3h4x2(:,13),heltab2x8(:,:,61))
  call Hloop_A_Q(ntryL,G1H2(40),59,0,G2H2(28),n2h2(85))
  call Hloop_AZ_Q(ntryL,G1H8(5),wf4(:,4),G1H2(16),ngZu,m3h4x2(:,14),heltab2x8(:,:,62))
  call Hloop_A_Q(ntryL,G1H2(16),59,0,G2H2(29),n2h2(86))
call HGT_raise_alpha_OLR(G1H8(6),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(6),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(6),ex3(:),G1H4(2),m3h2x4(:,49),heltab2x8(:,:,63))
  call Hloop_AZ_Q(ntryL,G1H8(8),wf4(:,4),G1H2(22),ngZu,m3h4x2(:,15),heltab2x8(:,:,64))
  call Hloop_A_Q(ntryL,G1H2(22),59,0,G2H2(31),n2h2(87))
  call Hloop_AZ_Q(ntryL,G1H8(11),wf4(:,4),G1H2(34),ngZu,m3h4x2(:,16),heltab2x8(:,:,65))
  call Hloop_A_Q(ntryL,G1H2(34),59,0,G2H2(32),n2h2(88))
  call Hloop_AV_Q(ntryL,G1H8(9),wf4(:,3),G1H2(35),m3h4x2(:,17),heltab2x8(:,:,66))
  call Hloop_A_Q(ntryL,G1H2(35),59,0,G2H2(34),n2h2(89))
call HGT_raise_alpha_OLR(G1H8(10),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(10),2,5,8)
  call Hloop_ZQ_A(ntryL,G1H8(10),ex3(:),G1H4(52),ngZu,m3h2x4(:,50),heltab2x8(:,:,67))
  call Hloop_AV_Q(ntryL,G1H8(16),wf4(:,3),G1H2(1),m3h4x2(:,18),heltab2x8(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(1),59,0,G2H2(35),n2h2(90))
  call Hloop_AV_Q(ntryL,G1H8(19),wf4(:,3),G1H2(5),m3h4x2(:,19),heltab2x8(:,:,69))
  call Hloop_A_Q(ntryL,G1H2(5),59,0,G2H2(37),n2h2(91))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(23),[G2H2(27),G2H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(48),[G2H2(33),G2H2(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G2H2(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(7),[G1H2(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(42),[G2H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(26),[G1H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(54),[G2H2(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(3),[G1H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(30),[G1H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(18),[G1H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(15),[G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(23),[G1H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G1H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(10),[G1H4(43),G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G1H4(53),G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G1H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(44),[G1H4(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G2H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G2H2(28)])
call HGT_w2_OLR(G1H2(8),1,1,2)
call HGT_w2_invQ_OLR(G1H2(8),2,5,2)
  call Hloop_VQ_A(ntryL,G1H2(8),ex4(:),G1H1(1),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(8),n2h1(62))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(23),ex5(:),G2tensor(10),m3h2x1(:,91),heltab2x2(:,:,91))
call HGT_w2_OLR(G1H2(20),1,1,2)
call HGT_w2_invQ_OLR(G1H2(20),2,5,2)
  call Hloop_ZQ_A(ntryL,G1H2(20),ex4(:),G1H1(1),ngZu,m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(12),n2h1(63))
call HGT_w2_OLR(G1H2(32),1,1,2)
call HGT_w2_invQ_OLR(G1H2(32),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(32),ex5(:),G1H1(1),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(14),n2h1(64))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(48),ex4(:),G2tensor(16),m3h2x1(:,94),heltab2x2(:,:,94))
call HGT_w2_OLR(G1H2(13),1,1,2)
call HGT_w2_invQ_OLR(G1H2(13),2,5,2)
  call Hloop_ZA_Q(ntryL,G1H2(13),ex5(:),G1H1(1),ngZu,m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(18),n2h1(65))
call HGT_w2_OLR(G1H4(61),1,1,4)
call HGT_w2_invQ_OLR(G1H4(61),2,5,4)
  call Hloop_QW_A(ntryL,G1H4(61),wf4(:,1),G1H1(1),m3h4x1(:,19),heltab2x4(:,:,122))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(38),n2h1(66))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(17),ex5(:),G2tensor(40),m3h2x1(:,96),heltab2x2(:,:,96))
call HGT_w2_OLR(G1H2(7),1,1,2)
call HGT_w2_invQ_OLR(G1H2(7),2,5,2)
  call Hloop_VQ_A(ntryL,G1H2(7),ex4(:),G1H1(1),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(30),n2h1(67))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(42),ex5(:),G2tensor(32),m3h2x1(:,98),heltab2x2(:,:,98))
call HGT_w2_OLR(G1H2(25),1,1,2)
call HGT_w2_invQ_OLR(G1H2(25),2,5,2)
  call Hloop_ZQ_A(ntryL,G1H2(25),ex4(:),G1H1(1),ngZu,m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(34),n2h1(68))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(45),ex5(:),G2tensor(36),ngZu,m3h2x1(:,100),heltab2x2(:,:,100))
call HGT_w2_OLR(G1H4(8),1,1,4)
call HGT_w2_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_AW_Q(ntryL,G1H4(8),wf4(:,1),G1H1(1),m3h4x1(:,20),heltab2x4(:,:,123))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(1),n2h1(69))
call HGT_w2_OLR(G1H2(26),1,1,2)
call HGT_w2_invQ_OLR(G1H2(26),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(26),ex5(:),G1H1(1),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(31),n2h1(70))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(54),ex4(:),G2tensor(42),m3h2x1(:,102),heltab2x2(:,:,102))
call HGT_w2_OLR(G1H2(14),1,1,2)
call HGT_w2_invQ_OLR(G1H2(14),2,5,2)
  call Hloop_ZA_Q(ntryL,G1H2(14),ex5(:),G1H1(1),ngZu,m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(2),n2h1(71))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(57),ex4(:),G2tensor(3),ngZu,m3h2x1(:,104),heltab2x2(:,:,104))
  call Hloop_VQ_A(ntryL,G1H2(28),ex3(:),G1H1(1),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(33),n2h1(72))
  call Hloop_VQ_A(ntryL,G1H2(3),ex3(:),G1H1(1),m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(44),n2h1(73))
  call Hloop_VQ_A(ntryL,G1H2(30),ex3(:),G1H1(1),m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(4),n2h1(74))
  call Hloop_VQ_A(ntryL,G1H2(23),ex3(:),G1H1(1),m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(35),n2h1(75))
  call Hloop_VQ_A(ntryL,G1H2(18),ex3(:),G1H1(1),m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(46),n2h1(76))
  call Hloop_VQ_A(ntryL,G1H2(2),ex3(:),G1H1(1),m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(5),n2h1(77))
  call Hloop_VQ_A(ntryL,G1H2(15),ex3(:),G1H1(1),m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(6),n2h1(78))
  call Hloop_VQ_A(ntryL,G1H2(11),ex3(:),G1H1(1),m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(37),n2h1(79))
  call Hloop_QV_A(ntryL,G1H4(23),wf4(:,3),G1H1(1),m3h4x1(:,21),heltab2x4(:,:,124))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(48),n2h1(80))
  call Hotf_4pt_reduction(G2H4(9),RedSet_4(99),mass4set(:,3),  & 
G1H4(17),G1H4(9),G1H4(27),G1H4(39),G1H4(40),4)
  call HG1shiftOLR(G1H4(9),24,4)
  call Hloop_QV_A(ntryL,G1H4(24),wf4(:,3),G1H1(1),m3h4x1(:,22),heltab2x4(:,:,125))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(7),n2h1(81))
  call Hloop_QV_A(ntryL,G1H4(36),wf4(:,3),G1H1(1),m3h4x1(:,23),heltab2x4(:,:,126))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(39),n2h1(82))
  call Hotf_4pt_reduction(G2H4(10),RedSet_4(99),mass4set(:,4),  & 
G1H4(45),G1H4(51),G1H4(57),G1H4(58),G1H4(13),4)
  call HG1shiftOLR(G1H4(51),24,4)
  call Hloop_QV_A(ntryL,G1H4(7),wf4(:,3),G1H1(1),m3h4x1(:,24),heltab2x4(:,:,127))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(9),n2h1(83))
  call Hotf_4pt_reduction(G2H4(13),RedSet_4(99),mass4set(:,5),  & 
G1H4(18),G1H4(25),G1H4(30),G1H4(1),G1H4(59),4)
  call HG1shiftOLR(G1H4(25),24,4)
  call Hloop_QV_A(ntryL,G1H4(4),wf4(:,3),G1H1(1),m3h4x1(:,25),heltab2x4(:,:,128))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(84))
  call Hloop_QV_A(ntryL,G1H4(22),wf4(:,3),G1H1(1),m3h4x1(:,26),heltab2x4(:,:,129))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(41),n2h1(85))
  call Hotf_4pt_reduction(G2H4(8),RedSet_4(99),mass4set(:,6),  & 
G1H4(11),G1H4(12),G1H4(32),G1H4(5),G1H4(29),4)
  call HG1shiftOLR(G1H4(12),24,4)
  call Hloop_QV_A(ntryL,G1H4(44),wf4(:,3),G1H1(1),m3h4x1(:,27),heltab2x4(:,:,130))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(86))
  call Hloop_QV_A(ntryL,G1H4(42),wf4(:,3),G1H1(1),m3h4x1(:,28),heltab2x4(:,:,131))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(87))
  call Hloop_QV_A(ntryL,G1H4(50),wf4(:,3),G1H1(1),m3h4x1(:,29),heltab2x4(:,:,132))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(66),n2h1(88))
  call Hloop_QV_A(ntryL,G1H4(54),wf4(:,3),G1H1(1),m3h4x1(:,30),heltab2x4(:,:,133))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(17),n2h1(89))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(8),ex5(:),G2tensor(19),m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(12),ex5(:),G2tensor(20),m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(10),ex5(:),G2tensor(69),m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(14),ex5(:),G2tensor(21),m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(16),ex4(:),G2tensor(22),m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(18),ex4(:),G2tensor(72),m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(22),ex4(:),G2tensor(23),m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(20),ex4(:),G2tensor(24),m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(21),ex5(:),G2tensor(25),m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(19),ex5(:),G2tensor(26),m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(1),ex5(:),G2tensor(27),m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(2),ex5(:),G2tensor(75),m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(3),ex5(:),G2tensor(28),ngZu,m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(4),ex5(:),G2tensor(29),ngZu,m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(5),ex4(:),G2tensor(50),m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(6),ex4(:),G2tensor(52),m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(7),ex4(:),G2tensor(54),m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(9),ex4(:),G2tensor(56),m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(11),ex4(:),G2tensor(58),ngZu,m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(13),ex4(:),G2tensor(60),ngZu,m3h2x1(:,132),heltab2x2(:,:,132))
  call Hotf_4pt_reduction(G2H4(4),RedSet_4(11),mass4set(:,1),  & 
G1H4(31),G1H4(35),G1H4(15),G1H4(16),G1H4(60),4)
  call HG1shiftOLR(G1H4(35),24,4)
  call Hotf_4pt_reduction(G2H4(5),RedSet_4(11),mass4set(:,1),  & 
G1H4(49),G1H4(55),G1H4(56),G1H4(10),G1H4(14),4)
  call HG1shiftOLR(G1H4(55),24,4)
  call Hotf_4pt_reduction(G2H4(6),RedSet_4(11),mass4set(:,7),  & 
G1H4(28),G1H4(26),G1H4(21),G1H4(37),G1H4(38),4)
  call HG1shiftOLR(G1H4(26),24,4)
  call Hotf_4pt_reduction(G2H4(7),RedSet_4(99),mass4set(:,1),  & 
G1H4(41),G1H4(47),G1H4(48),G1H4(19),G1H4(20),4)
  call HG1shiftOLR(G1H4(47),24,4)
  call Hotf_4pt_reduction(G2H2(15),RedSet_4(2),mass4set(:,1),  & 
G1H2(6),G1H2(9),G1H2(17),G1H2(21),G1H2(29),2)
  call HG1shiftOLR(G1H2(9),16,2)
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H8(6),wf8(:,12),G2tensor(62),m3h8x1(:,1),heltab2x8(:,:,70))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(7),wf8(:,12),G2tensor(64),m3h8x1(:,2),heltab2x8(:,:,71))
  call Hloop_VQ_A(ntryL,G1H8(7),wf8(:,7),G1H1(1),m3h8x1(:,3),heltab2x8(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(78),n2h1(90))
  call Hloop_ZQ_A(ntryL,G1H8(4),wf8(:,7),G1H1(1),ngZu,m3h8x1(:,4),heltab2x8(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(81),n2h1(91))
  call Hloop_WQ_A(ntryL,G1H8(2),wf8(:,7),G1H1(1),m3h8x1(:,5),heltab2x8(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(84),n2h1(92))
  call Hloop_WQ_A(ntryL,G1H8(1),wf8(:,7),G1H1(1),m3h8x1(:,6),heltab2x8(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(87),n2h1(93))
  call Hloop_ZQ_A(ntryL,G1H8(20),wf8(:,7),G1H1(1),ngZu,m3h8x1(:,7),heltab2x8(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(90),n2h1(94))
  call Hloop_WQ_A(ntryL,G1H8(21),wf8(:,7),G1H1(1),m3h8x1(:,8),heltab2x8(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(93),n2h1(95))
  call Hloop_WQ_A(ntryL,G1H2(36),ex3(:),G1H1(1),m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(96),n2h1(96))
  call Hloop_ZQ_A(ntryL,G1H2(27),ex3(:),G1H1(1),ngZu,m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(97),n2h1(97))
  call Hloop_WQ_A(ntryL,G1H2(42),ex3(:),G1H1(1),m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(98),n2h1(98))
  call Hloop_VQ_A(ntryL,G1H2(33),ex3(:),G1H1(1),m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(99),n2h1(99))
  call Hloop_ZQ_A(ntryL,G1H2(41),ex3(:),G1H1(1),ngZu,m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(100),n2h1(100))
  call Hloop_WQ_A(ntryL,G1H2(39),ex3(:),G1H1(1),m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(101),n2h1(101))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(29),ex3(:),G2tensor(102),m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(32),ex3(:),G2tensor(103),m3h2x1(:,140),heltab2x2(:,:,140))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(34),ex3(:),G2tensor(104),ngZu,m3h2x1(:,141),heltab2x2(:,:,141))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(37),ex3(:),G2tensor(105),ngZu,m3h2x1(:,142),heltab2x2(:,:,142))
  call Hloop_QV_A(ntryL,G1H4(17),wf4(:,3),G1H1(1),m3h4x1(:,31),heltab2x4(:,:,134))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(106),n2h1(102))
  call Hloop_QV_A(ntryL,G1H4(9),wf4(:,3),G1H1(1),m3h4x1(:,32),heltab2x4(:,:,135))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,0,G2tensor(107),n2h1(103))
  call Hloop_QV_A(ntryL,G1H4(40),wf4(:,3),G1H1(1),m3h4x1(:,33),heltab2x4(:,:,136))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(108),n2h1(104))
  call Hloop_QV_A(ntryL,G1H4(45),wf4(:,3),G1H1(1),m3h4x1(:,34),heltab2x4(:,:,137))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(109),n2h1(105))
  call Hloop_QV_A(ntryL,G1H4(51),wf4(:,3),G1H1(1),m3h4x1(:,35),heltab2x4(:,:,138))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,0,G2tensor(110),n2h1(106))
  call Hloop_QV_A(ntryL,G1H4(13),wf4(:,3),G1H1(1),m3h4x1(:,36),heltab2x4(:,:,139))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(111),n2h1(107))
  call Hloop_QV_A(ntryL,G1H4(18),wf4(:,3),G1H1(1),m3h4x1(:,37),heltab2x4(:,:,140))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(112),n2h1(108))
  call Hloop_QV_A(ntryL,G1H4(25),wf4(:,3),G1H1(1),m3h4x1(:,38),heltab2x4(:,:,141))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,0,G2tensor(113),n2h1(109))
  call Hloop_QV_A(ntryL,G1H4(59),wf4(:,3),G1H1(1),m3h4x1(:,39),heltab2x4(:,:,142))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(114),n2h1(110))
  call Hloop_QV_A(ntryL,G1H4(11),wf4(:,3),G1H1(1),m3h4x1(:,40),heltab2x4(:,:,143))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(115),n2h1(111))
  call Hloop_QV_A(ntryL,G1H4(12),wf4(:,3),G1H1(1),m3h4x1(:,41),heltab2x4(:,:,144))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,0,G2tensor(116),n2h1(112))
  call Hloop_QV_A(ntryL,G1H4(29),wf4(:,3),G1H1(1),m3h4x1(:,42),heltab2x4(:,:,145))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(117),n2h1(113))
  call Hloop_QV_A(ntryL,G1H4(31),wf4(:,3),G1H1(1),m3h4x1(:,43),heltab2x4(:,:,146))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(118),n2h1(114))
  call Hloop_QV_A(ntryL,G1H4(35),wf4(:,3),G1H1(1),m3h4x1(:,44),heltab2x4(:,:,147))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,0,G2tensor(119),n2h1(115))
  call Hloop_QV_A(ntryL,G1H4(60),wf4(:,3),G1H1(1),m3h4x1(:,45),heltab2x4(:,:,148))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(120),n2h1(116))
  call Hloop_QZ_A(ntryL,G1H4(49),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,46),heltab2x4(:,:,149))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(121),n2h1(117))
  call Hloop_QZ_A(ntryL,G1H4(55),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,47),heltab2x4(:,:,150))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,0,G2tensor(122),n2h1(118))
  call Hloop_QZ_A(ntryL,G1H4(14),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,48),heltab2x4(:,:,151))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(123),n2h1(119))
  call Hloop_QV_A(ntryL,G1H4(28),wf4(:,3),G1H1(1),m3h4x1(:,49),heltab2x4(:,:,152))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(124),n2h1(120))
  call Hloop_QV_A(ntryL,G1H4(26),wf4(:,3),G1H1(1),m3h4x1(:,50),heltab2x4(:,:,153))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,0,G2tensor(125),n2h1(121))
  call Hloop_QV_A(ntryL,G1H4(38),wf4(:,3),G1H1(1),m3h4x1(:,51),heltab2x4(:,:,154))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(126),n2h1(122))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(41),39,wf4(:,3),24,G2tensor(127),m3h4x1(:,52),heltab2x4(:,:,155))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(47),0,wf4(:,3),24,G2tensor(128),m3h4x1(:,53),heltab2x4(:,:,156))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(20),39,wf4(:,3),24,G2tensor(129),m3h4x1(:,54),heltab2x4(:,:,157))
  call Hloop_VA_Q(ntryL,G1H2(6),ex5(:),G1H1(1),m3h2x1(:,143),heltab2x2(:,:,143))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(130),n2h1(124))
  call Hloop_VA_Q(ntryL,G1H2(9),ex5(:),G1H1(1),m3h2x1(:,144),heltab2x2(:,:,144))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(131),n2h1(125))
  call Hloop_VA_Q(ntryL,G1H2(29),ex5(:),G1H1(1),m3h2x1(:,145),heltab2x2(:,:,145))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(132),n2h1(126))
  call ol_merge_tensors(G2tensor(47),[G2tensor(43),G1tensor(96),G1tensor(42)])
  call ol_merge_tensors(G2tensor(49),[G2tensor(45),G1tensor(120),G1tensor(78)])
  call ol_merge_tensors(G2tensor(51),[G1tensor(264)])
  call ol_merge_tensors(G2tensor(127),[G2tensor(61),G2tensor(53),G1tensor(294),G1tensor(270)])
  call ol_merge_tensors(G2tensor(63),[G2tensor(55),G1tensor(300),G1tensor(276)])
  call ol_merge_tensors(G2tensor(65),[G2tensor(57),G1tensor(306),G1tensor(282)])
  call ol_merge_tensors(G2tensor(64),[G2tensor(59),G1tensor(288)])
  call ol_merge_tensors(G2tensor(69),[G2tensor(67),G1tensor(164),G1tensor(75),G1tensor(15),G1tensor(19)])
  call ol_merge_tensors(G2tensor(68),[G1tensor(168)])
  call ol_merge_tensors(G2tensor(23),[G2tensor(70),G1tensor(188),G1tensor(117),G1tensor(14),G1tensor(55)])
  call ol_merge_tensors(G2tensor(71),[G1tensor(192)])
  call ol_merge_tensors(G2tensor(19),[G2tensor(73),G1tensor(206),G1tensor(40),G1tensor(33)])
  call ol_merge_tensors(G2tensor(74),[G1tensor(210)])
  call ol_merge_tensors(G2tensor(22),[G2tensor(76),G1tensor(242),G1tensor(93),G1tensor(12)])
  call ol_merge_tensors(G2tensor(77),[G1tensor(246)])
  call ol_merge_tensors(G2tensor(96),[G2tensor(79),G1tensor(308)])
  call ol_merge_tensors(G2tensor(87),[G2tensor(80),G1tensor(312)])
  call ol_merge_tensors(G2tensor(97),[G2tensor(82),G1tensor(314)])
  call ol_merge_tensors(G2tensor(90),[G2tensor(83),G1tensor(318),G1tensor(180)])
  call ol_merge_tensors(G2tensor(98),[G2tensor(85),G1tensor(320)])
  call ol_merge_tensors(G2tensor(93),[G2tensor(86),G1tensor(324)])
  call ol_merge_tensors(G2tensor(99),[G2tensor(88),G1tensor(326)])
  call ol_merge_tensors(G2tensor(78),[G2tensor(89),G1tensor(330),G1tensor(222)])
  call ol_merge_tensors(G2tensor(100),[G2tensor(91),G1tensor(332)])
  call ol_merge_tensors(G2tensor(81),[G2tensor(92),G1tensor(336),G1tensor(234)])
  call ol_merge_tensors(G2tensor(101),[G2tensor(94),G1tensor(338)])
  call ol_merge_tensors(G2tensor(84),[G2tensor(95),G1tensor(342)])
  call ol_merge_tensors(G1tensor(123),[G1tensor(7)])
  call ol_merge_tensors(G1tensor(158),[G1tensor(129),G1tensor(13)])
  call ol_merge_tensors(G1tensor(170),[G1tensor(135),G1tensor(25)])
  call ol_merge_tensors(G1tensor(176),[G1tensor(67),G1tensor(31)])
  call ol_merge_tensors(G1tensor(141),[G1tensor(43)])
  call ol_merge_tensors(G1tensor(182),[G1tensor(147),G1tensor(49)])
  call ol_merge_tensors(G1tensor(194),[G1tensor(153),G1tensor(61)])
  call ol_merge_tensors(G1tensor(20),[G1tensor(27)])
  call ol_merge_tensors(G1tensor(200),[G1tensor(30),G1tensor(44)])
  call ol_merge_tensors(G1tensor(212),[G1tensor(46),G1tensor(68),G1tensor(50)])
  call ol_merge_tensors(G1tensor(218),[G1tensor(8),G1tensor(3)])
  call ol_merge_tensors(G1tensor(66),[G1tensor(9)])
  call ol_merge_tensors(G1tensor(224),[G1tensor(64),G1tensor(62)])
  call ol_merge_tensors(G1tensor(230),[G1tensor(17),G1tensor(21)])
  call ol_merge_tensors(G1tensor(81),[G1tensor(4)])
  call ol_merge_tensors(G1tensor(236),[G1tensor(87),G1tensor(5)])
  call ol_merge_tensors(G1tensor(248),[G1tensor(99),G1tensor(16),G1tensor(6)])
  call ol_merge_tensors(G1tensor(105),[G1tensor(29)])
  call ol_merge_tensors(G1tensor(254),[G1tensor(111),G1tensor(11)])
  call ol_merge_tensors(G1tensor(80),[G1tensor(18)])
  call ol_merge_tensors(G1tensor(28),[G1tensor(22)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(58),G1tensor(35)])
  call ol_merge_tensors(G1tensor(72),[G1tensor(70),G1tensor(23)])
  call ol_merge_tensors(G2tensor(20),[G1tensor(268),G1tensor(41),G1tensor(32)])
  call ol_merge_tensors(G1tensor(65),[G1tensor(47),G1tensor(34)])
  call ol_merge_tensors(G1tensor(90),[G1tensor(36)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(137),G1tensor(77),G1tensor(51),G1tensor(48)])
  call ol_merge_tensors(G1tensor(102),[G1tensor(52)])
  call ol_merge_tensors(G1tensor(104),[G1tensor(53)])
  call ol_merge_tensors(G1tensor(63),[G1tensor(54)])
  call ol_merge_tensors(G2tensor(12),[G1tensor(125),G1tensor(74),G1tensor(57)])
  call ol_merge_tensors(G2tensor(21),[G1tensor(274),G1tensor(130),G1tensor(76),G1tensor(71)])
  call ol_merge_tensors(G1tensor(114),[G1tensor(69)])
  call ol_merge_tensors(G1tensor(86),[G1tensor(82)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(92),G1tensor(83)])
  call ol_merge_tensors(G1tensor(108),[G1tensor(98),G1tensor(84)])
  call ol_merge_tensors(G2tensor(72),[G1tensor(292),G1tensor(94),G1tensor(88)])
  call ol_merge_tensors(G1tensor(113),[G1tensor(100),G1tensor(89)])
  call ol_merge_tensors(G2tensor(16),[G1tensor(287),G1tensor(155),G1tensor(119),G1tensor(101),G1tensor(95)])
  call ol_merge_tensors(G1tensor(110),[G1tensor(106)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(143),G1tensor(116),G1tensor(107)])
  call ol_merge_tensors(G2tensor(24),[G1tensor(298),G1tensor(148),G1tensor(118),G1tensor(112)])
  call ol_merge_tensors(G1tensor(140),[G1tensor(122)])
  call ol_merge_tensors(G1tensor(128),[G1tensor(124)])
  call ol_merge_tensors(G1tensor(134),[G1tensor(126)])
  call ol_merge_tensors(G1tensor(136),[G1tensor(131)])
  call ol_merge_tensors(G1tensor(150),[G1tensor(132)])
  call ol_merge_tensors(G1tensor(156),[G1tensor(138)])
  call ol_merge_tensors(G1tensor(146),[G1tensor(142)])
  call ol_merge_tensors(G1tensor(152),[G1tensor(144)])
  call ol_merge_tensors(G1tensor(154),[G1tensor(149)])
  call ol_merge_tensors(G2tensor(33),[G1tensor(225),G1tensor(165),G1tensor(159)])
  call ol_merge_tensors(G1tensor(171),[G1tensor(160)])
  call ol_merge_tensors(G1tensor(185),[G1tensor(177),G1tensor(161)])
  call ol_merge_tensors(G2tensor(44),[G1tensor(214),G1tensor(208),G1tensor(172),G1tensor(166)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(232),G1tensor(191),G1tensor(178),G1tensor(167)])
  call ol_merge_tensors(G1tensor(197),[G1tensor(179),G1tensor(173)])
  call ol_merge_tensors(G2tensor(35),[G1tensor(255),G1tensor(189),G1tensor(183)])
  call ol_merge_tensors(G1tensor(195),[G1tensor(184)])
  call ol_merge_tensors(G2tensor(46),[G1tensor(250),G1tensor(244),G1tensor(196),G1tensor(190)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(207),G1tensor(201)])
  call ol_merge_tensors(G1tensor(226),[G1tensor(213),G1tensor(202)])
  call ol_merge_tensors(G1tensor(239),[G1tensor(219),G1tensor(203)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(245),G1tensor(220),G1tensor(209)])
  call ol_merge_tensors(G1tensor(251),[G1tensor(233),G1tensor(221),G1tensor(215)])
  call ol_merge_tensors(G1tensor(257),[G1tensor(231),G1tensor(227)])
  call ol_merge_tensors(G2tensor(37),[G1tensor(243),G1tensor(237)])
  call ol_merge_tensors(G1tensor(256),[G1tensor(249),G1tensor(238)])
  call ol_merge_tensors(G2tensor(38),[G1tensor(260)])
  call ol_merge_tensors(G2tensor(25),[G1tensor(261)])
  call ol_merge_tensors(G2tensor(26),[G1tensor(262)])
  call ol_merge_tensors(G2tensor(40),[G1tensor(263)])
  call ol_merge_tensors(G2tensor(30),[G1tensor(278),G1tensor(266)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(267)])
  call ol_merge_tensors(G2tensor(32),[G1tensor(275),G1tensor(269)])
  call ol_merge_tensors(G2tensor(34),[G1tensor(272)])
  call ol_merge_tensors(G2tensor(75),[G1tensor(273)])
  call ol_merge_tensors(G2tensor(28),[G1tensor(279)])
  call ol_merge_tensors(G2tensor(29),[G1tensor(280)])
  call ol_merge_tensors(G2tensor(36),[G1tensor(281)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(284)])
  call ol_merge_tensors(G2tensor(50),[G1tensor(285)])
  call ol_merge_tensors(G2tensor(52),[G1tensor(286)])
  call ol_merge_tensors(G2tensor(31),[G1tensor(302),G1tensor(290)])
  call ol_merge_tensors(G2tensor(54),[G1tensor(291)])
  call ol_merge_tensors(G2tensor(42),[G1tensor(299),G1tensor(293)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(296)])
  call ol_merge_tensors(G2tensor(56),[G1tensor(297)])
  call ol_merge_tensors(G2tensor(58),[G1tensor(303)])
  call ol_merge_tensors(G2tensor(60),[G1tensor(304)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(305)])
  call ol_merge_tensors(G2tensor(48),[G1tensor(321),G1tensor(309)])
  call ol_merge_tensors(G2tensor(106),[G1tensor(310)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(311)])
  call ol_merge_tensors(G2tensor(39),[G1tensor(315)])
  call ol_merge_tensors(G2tensor(109),[G1tensor(334),G1tensor(316)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(317)])
  call ol_merge_tensors(G2tensor(112),[G1tensor(340),G1tensor(322)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(323)])
  call ol_merge_tensors(G2tensor(41),[G1tensor(327)])
  call ol_merge_tensors(G2tensor(115),[G1tensor(328)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(335),G1tensor(329)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(333)])
  call ol_merge_tensors(G2tensor(66),[G1tensor(339)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(341)])
  call ol_merge_tensors(G2tensor(121),[G2tensor(118)])
  call Hotf_4pt_reduction_last(G2tensor(47),RedSet_4(11),mass4set(:,3),  & 
G1tensor(1),G1tensor(37),G1tensor(38),G1tensor(56),G1tensor(2))
  call G_TensorShift(G1tensor(37),24)
  call Hotf_4pt_reduction_last(G2tensor(49),RedSet_4(11),mass4set(:,8),  & 
G1tensor(10),G1tensor(24),G1tensor(26),G1tensor(39),G1tensor(45))
  call G_TensorShift(G1tensor(24),24)
  call Hotf_4pt_reduction_last(G2tensor(51),RedSet_4(95),mass4set(:,9),  & 
G1tensor(59),G1tensor(60),G1tensor(73),G1tensor(79),G1tensor(85))
  call G_TensorShift(G1tensor(60),19)
  call Hotf_4pt_reduction_last(G2tensor(127),RedSet_4(99),mass4set(:,1),  & 
G1tensor(91),G1tensor(97),G1tensor(103),G1tensor(109),G1tensor(115))
  call G_TensorShift(G1tensor(97),24)
  call Hotf_4pt_reduction_last(G2tensor(63),RedSet_4(99),mass4set(:,10),  & 
G1tensor(121),G1tensor(127),G1tensor(133),G1tensor(139),G1tensor(145))
  call G_TensorShift(G1tensor(127),24)
  call Hotf_4pt_reduction_last(G2tensor(65),RedSet_4(99),mass4set(:,2),  & 
G1tensor(151),G1tensor(157),G1tensor(163),G1tensor(169),G1tensor(175))
  call G_TensorShift(G1tensor(157),24)
  call Hotf_4pt_reduction_last(G2tensor(64),RedSet_4(103),mass4set(:,3),  & 
G1tensor(181),G1tensor(187),G1tensor(193),G1tensor(199),G1tensor(205))
  call G_TensorShift(G1tensor(187),11)
  call Hotf_4pt_reduction_last(G2tensor(69),RedSet_4(2),mass4set(:,4),  & 
G1tensor(211),G1tensor(217),G1tensor(223),G1tensor(229),G1tensor(235))
  call G_TensorShift(G1tensor(217),16)
  call Hotf_4pt_reduction_last(G2tensor(68),RedSet_4(49),mass4set(:,4),  & 
G1tensor(241),G1tensor(247),G1tensor(253),G1tensor(259),G1tensor(265))
  call G_TensorShift(G1tensor(247),20)
  call Hotf_4pt_reduction_last(G2tensor(23),RedSet_4(17),mass4set(:,4),  & 
G1tensor(271),G1tensor(277),G1tensor(283),G1tensor(289),G1tensor(295))
  call G_TensorShift(G1tensor(277),8)
  call Hotf_4pt_reduction_last(G2tensor(71),RedSet_4(61),mass4set(:,4),  & 
G1tensor(301),G1tensor(307),G1tensor(313),G1tensor(319),G1tensor(325))
  call G_TensorShift(G1tensor(307),12)
  call Hotf_4pt_reduction_last(G2tensor(19),RedSet_4(2),mass4set(:,6),  & 
G1tensor(331),G1tensor(337),G1tensor(96),G1tensor(42),G1tensor(120))
  call G_TensorShift(G1tensor(337),16)
  call Hotf_4pt_reduction_last(G2tensor(74),RedSet_4(49),mass4set(:,6),  & 
G1tensor(78),G1tensor(264),G1tensor(294),G1tensor(270),G1tensor(300))
  call G_TensorShift(G1tensor(264),20)
  call Hotf_4pt_reduction_last(G2tensor(22),RedSet_4(17),mass4set(:,6),  & 
G1tensor(276),G1tensor(306),G1tensor(282),G1tensor(288),G1tensor(164))
  call G_TensorShift(G1tensor(306),8)
  call Hotf_4pt_reduction_last(G2tensor(77),RedSet_4(61),mass4set(:,6),  & 
G1tensor(75),G1tensor(15),G1tensor(19),G1tensor(168),G1tensor(188))
  call G_TensorShift(G1tensor(15),12)
  call Hotf_4pt_reduction_last(G2tensor(96),RedSet_4(114),mass4set(:,11),  & 
G1tensor(117),G1tensor(14),G1tensor(55),G1tensor(192),G1tensor(206))
  call G_TensorShift(G1tensor(14),4)
  call Hotf_4pt_reduction_last(G2tensor(87),RedSet_4(54),mass4set(:,11),  & 
G1tensor(40),G1tensor(33),G1tensor(210),G1tensor(242),G1tensor(93))
  call G_TensorShift(G1tensor(33),28)
  call Hotf_4pt_reduction_last(G2tensor(97),RedSet_4(114),mass4set(:,12),  & 
G1tensor(12),G1tensor(246),G1tensor(308),G1tensor(312),G1tensor(314))
  call G_TensorShift(G1tensor(246),4)
  call Hotf_4pt_reduction_last(G2tensor(90),RedSet_4(54),mass4set(:,12),  & 
G1tensor(318),G1tensor(180),G1tensor(320),G1tensor(324),G1tensor(326))
  call G_TensorShift(G1tensor(180),28)
  call Hotf_4pt_reduction_last(G2tensor(98),RedSet_4(114),mass4set(:,13),  & 
G1tensor(330),G1tensor(222),G1tensor(332),G1tensor(336),G1tensor(234))
  call G_TensorShift(G1tensor(222),4)
  call Hotf_4pt_reduction_last(G2tensor(93),RedSet_4(54),mass4set(:,13),  & 
G1tensor(338),G1tensor(342),G1tensor(7),G1tensor(129),G1tensor(13))
  call G_TensorShift(G1tensor(342),28)
  call Hotf_4pt_reduction_last(G2tensor(99),RedSet_4(115),mass4set(:,6),  & 
G1tensor(135),G1tensor(25),G1tensor(67),G1tensor(31),G1tensor(43))
  call G_TensorShift(G1tensor(25),4)
  call Hotf_4pt_reduction_last(G2tensor(78),RedSet_4(72),mass4set(:,6),  & 
G1tensor(147),G1tensor(49),G1tensor(153),G1tensor(61),G1tensor(27))
  call G_TensorShift(G1tensor(49),28)
  call Hotf_4pt_reduction_last(G2tensor(100),RedSet_4(115),mass4set(:,12),  & 
G1tensor(30),G1tensor(44),G1tensor(46),G1tensor(68),G1tensor(50))
  call G_TensorShift(G1tensor(44),4)
  call Hotf_4pt_reduction_last(G2tensor(81),RedSet_4(72),mass4set(:,12),  & 
G1tensor(8),G1tensor(3),G1tensor(9),G1tensor(64),G1tensor(62))
  call G_TensorShift(G1tensor(3),28)
  call Hotf_4pt_reduction_last(G2tensor(101),RedSet_4(115),mass4set(:,13),  & 
G1tensor(17),G1tensor(21),G1tensor(4),G1tensor(87),G1tensor(5))
  call G_TensorShift(G1tensor(21),4)
  call Hotf_4pt_reduction_last(G2tensor(84),RedSet_4(72),mass4set(:,13),  & 
G1tensor(99),G1tensor(16),G1tensor(6),G1tensor(29),G1tensor(111))
  call G_TensorShift(G1tensor(16),28)
  call Hotf_4pt_reduction_last(G2tensor(8),RedSet_4(81),mass4set(:,3),  & 
G1tensor(11),G1tensor(18),G1tensor(22),G1tensor(58),G1tensor(35))
  call G_TensorShift(G1tensor(18),8)
  call Hotf_4pt_reduction_last(G2tensor(20),RedSet_4(6),mass4set(:,1),  & 
G1tensor(70),G1tensor(23),G1tensor(268),G1tensor(41),G1tensor(32))
  call G_TensorShift(G1tensor(23),16)
  call Hotf_4pt_reduction_last(G2tensor(10),RedSet_4(10),mass4set(:,3),  & 
G1tensor(47),G1tensor(34),G1tensor(36),G1tensor(137),G1tensor(77))
  call G_TensorShift(G1tensor(34),16)
  call Hotf_4pt_reduction_last(G2tensor(12),RedSet_4(81),mass4set(:,8),  & 
G1tensor(51),G1tensor(48),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(48),8)
  call Hotf_4pt_reduction_last(G2tensor(21),RedSet_4(6),mass4set(:,14),  & 
G1tensor(125),G1tensor(74),G1tensor(57),G1tensor(274),G1tensor(130))
  call G_TensorShift(G1tensor(74),16)
  call Hotf_4pt_reduction_last(G2tensor(14),RedSet_4(85),mass4set(:,3),  & 
G1tensor(76),G1tensor(71),G1tensor(69),G1tensor(82),G1tensor(92))
  call G_TensorShift(G1tensor(71),16)
  call Hotf_4pt_reduction_last(G2tensor(72),RedSet_4(20),mass4set(:,1),  & 
G1tensor(83),G1tensor(98),G1tensor(84),G1tensor(292),G1tensor(94))
  call G_TensorShift(G1tensor(98),8)
  call Hotf_4pt_reduction_last(G2tensor(16),RedSet_4(23),mass4set(:,3),  & 
G1tensor(88),G1tensor(100),G1tensor(89),G1tensor(287),G1tensor(155))
  call G_TensorShift(G1tensor(100),8)
  call Hotf_4pt_reduction_last(G2tensor(18),RedSet_4(85),mass4set(:,8),  & 
G1tensor(119),G1tensor(101),G1tensor(95),G1tensor(106),G1tensor(143))
  call G_TensorShift(G1tensor(101),16)
  call Hotf_4pt_reduction_last(G2tensor(24),RedSet_4(20),mass4set(:,14),  & 
G1tensor(116),G1tensor(107),G1tensor(298),G1tensor(148),G1tensor(118))
  call G_TensorShift(G1tensor(107),8)
  call Hotf_4pt_reduction_last(G2tensor(33),RedSet_4(42),mass4set(:,7),  & 
G1tensor(112),G1tensor(122),G1tensor(124),G1tensor(126),G1tensor(131))
  call G_TensorShift(G1tensor(122),4)
  call Hotf_4pt_reduction_last(G2tensor(44),RedSet_4(47),mass4set(:,6),  & 
G1tensor(132),G1tensor(138),G1tensor(142),G1tensor(144),G1tensor(149))
  call G_TensorShift(G1tensor(138),4)
  call Hotf_4pt_reduction_last(G2tensor(4),RedSet_4(48),mass4set(:,4),  & 
G1tensor(225),G1tensor(165),G1tensor(159),G1tensor(160),G1tensor(177))
  call G_TensorShift(G1tensor(165),4)
  call Hotf_4pt_reduction_last(G2tensor(35),RedSet_4(56),mass4set(:,7),  & 
G1tensor(161),G1tensor(214),G1tensor(208),G1tensor(172),G1tensor(166))
  call G_TensorShift(G1tensor(214),4)
  call Hotf_4pt_reduction_last(G2tensor(46),RedSet_4(60),mass4set(:,6),  & 
G1tensor(232),G1tensor(191),G1tensor(178),G1tensor(167),G1tensor(179))
  call G_TensorShift(G1tensor(191),4)
  call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(42),mass4set(:,1),  & 
G1tensor(173),G1tensor(255),G1tensor(189),G1tensor(183),G1tensor(184))
  call G_TensorShift(G1tensor(255),4)
  call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(48),mass4set(:,6),  & 
G1tensor(250),G1tensor(244),G1tensor(196),G1tensor(190),G1tensor(207))
  call G_TensorShift(G1tensor(244),4)
  call Hotf_4pt_reduction_last(G2tensor(37),RedSet_4(56),mass4set(:,1),  & 
G1tensor(201),G1tensor(213),G1tensor(202),G1tensor(219),G1tensor(203))
  call G_TensorShift(G1tensor(213),4)
  call Hotf_4pt_reduction_last(G2tensor(38),RedSet_4(116),mass4set(:,1),  & 
G1tensor(245),G1tensor(220),G1tensor(209),G1tensor(233),G1tensor(221))
  call G_TensorShift(G1tensor(220),3)
  call Hotf_4pt_reduction_last(G2tensor(25),RedSet_4(93),mass4set(:,9),  & 
G1tensor(215),G1tensor(231),G1tensor(227),G1tensor(243),G1tensor(237))
  call G_TensorShift(G1tensor(231),16)
  call Hotf_4pt_reduction_last(G2tensor(26),RedSet_4(94),mass4set(:,9),  & 
G1tensor(249),G1tensor(238),G1tensor(260),G1tensor(261),G1tensor(262))
  call G_TensorShift(G1tensor(238),16)
  call Hotf_4pt_reduction_last(G2tensor(40),RedSet_4(10),mass4set(:,9),  & 
G1tensor(263),G1tensor(278),G1tensor(266),G1tensor(267),G1tensor(275))
  call G_TensorShift(G1tensor(278),16)
  call Hotf_4pt_reduction_last(G2tensor(30),RedSet_4(117),mass4set(:,1),  & 
G1tensor(269),G1tensor(272),G1tensor(273),G1tensor(279),G1tensor(280))
  call G_TensorShift(G1tensor(272),8)
  call Hotf_4pt_reduction_last(G2tensor(27),RedSet_4(97),mass4set(:,1),  & 
G1tensor(281),G1tensor(284),G1tensor(285),G1tensor(286),G1tensor(302))
  call G_TensorShift(G1tensor(284),16)
  call Hotf_4pt_reduction_last(G2tensor(32),RedSet_4(98),mass4set(:,1),  & 
G1tensor(290),G1tensor(291),G1tensor(299),G1tensor(293),G1tensor(296))
  call G_TensorShift(G1tensor(291),16)
  call Hotf_4pt_reduction_last(G2tensor(34),RedSet_4(117),mass4set(:,10),  & 
G1tensor(297),G1tensor(303),G1tensor(304),G1tensor(305),G1tensor(321))
  call G_TensorShift(G1tensor(303),8)
  call Hotf_4pt_reduction_last(G2tensor(75),RedSet_4(97),mass4set(:,14),  & 
G1tensor(309),G1tensor(310),G1tensor(311),G1tensor(315),G1tensor(334))
  call G_TensorShift(G1tensor(310),16)
  call Hotf_4pt_reduction_last(G2tensor(28),RedSet_4(97),mass4set(:,2),  & 
G1tensor(316),G1tensor(317),G1tensor(340),G1tensor(322),G1tensor(323))
  call G_TensorShift(G1tensor(317),16)
  call Hotf_4pt_reduction_last(G2tensor(29),RedSet_4(6),mass4set(:,2),  & 
G1tensor(327),G1tensor(328),G1tensor(335),G1tensor(329),G1tensor(333))
  call G_TensorShift(G1tensor(328),16)
  call Hotf_4pt_reduction_last(G2tensor(36),RedSet_4(98),mass4set(:,2),  & 
G1tensor(339),G1tensor(341),G1tensor(343),G1tensor(344),G1tensor(345))
  call G_TensorShift(G1tensor(341),16)
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(118),mass4set(:,3),  & 
G1tensor(346),G1tensor(347),G1tensor(348),G1tensor(349),G1tensor(350))
  call G_TensorShift(G1tensor(347),3)
  call Hotf_4pt_reduction_last(G2tensor(50),RedSet_4(101),mass4set(:,6),  & 
G1tensor(351),G1tensor(352),G1tensor(353),G1tensor(354),G1tensor(355))
  call G_TensorShift(G1tensor(352),8)
  call Hotf_4pt_reduction_last(G2tensor(52),RedSet_4(102),mass4set(:,1),  & 
G1tensor(356),G1tensor(357),G1tensor(358),G1tensor(359),G1tensor(360))
  call G_TensorShift(G1tensor(357),8)
  call Hotf_4pt_reduction_last(G2tensor(31),RedSet_4(119),mass4set(:,1),  & 
G1tensor(361),G1tensor(362),G1tensor(363),G1tensor(364),G1tensor(365))
  call G_TensorShift(G1tensor(362),16)
  call Hotf_4pt_reduction_last(G2tensor(54),RedSet_4(105),mass4set(:,1),  & 
G1tensor(366),G1tensor(367),G1tensor(368),G1tensor(369),G1tensor(370))
  call G_TensorShift(G1tensor(367),8)
  call Hotf_4pt_reduction_last(G2tensor(42),RedSet_4(106),mass4set(:,1),  & 
G1tensor(371),G1tensor(372),G1tensor(373),G1tensor(374),G1tensor(375))
  call G_TensorShift(G1tensor(372),8)
  call Hotf_4pt_reduction_last(G2tensor(2),RedSet_4(119),mass4set(:,10),  & 
G1tensor(376),G1tensor(377),G1tensor(378),G1tensor(379),G1tensor(380))
  call G_TensorShift(G1tensor(377),16)
  call Hotf_4pt_reduction_last(G2tensor(56),RedSet_4(105),mass4set(:,14),  & 
G1tensor(381),G1tensor(382),G1tensor(383),G1tensor(384),G1tensor(385))
  call G_TensorShift(G1tensor(382),8)
  call Hotf_4pt_reduction_last(G2tensor(58),RedSet_4(105),mass4set(:,2),  & 
G1tensor(386),G1tensor(387),G1tensor(388),G1tensor(389),G1tensor(390))
  call G_TensorShift(G1tensor(387),8)
  call Hotf_4pt_reduction_last(G2tensor(60),RedSet_4(20),mass4set(:,2),  & 
G1tensor(391),G1tensor(392),G1tensor(393),G1tensor(394),G1tensor(395))
  call G_TensorShift(G1tensor(392),8)
  call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(106),mass4set(:,2),  & 
G1tensor(396),G1tensor(397),G1tensor(398),G1tensor(399),G1tensor(400))
  call G_TensorShift(G1tensor(397),8)
  call Hotf_4pt_reduction_last(G2tensor(48),RedSet_4(108),mass4set(:,3),  & 
G1tensor(401),G1tensor(402),G1tensor(403),G1tensor(404),G1tensor(405))
  call G_TensorShift(G1tensor(402),24)
  call Hotf_4pt_reduction_last(G2tensor(106),RedSet_4(99),mass4set(:,3),  & 
G1tensor(406),G1tensor(407),G1tensor(408),G1tensor(409),G1tensor(410))
  call G_TensorShift(G1tensor(407),24)
  call Hotf_4pt_reduction_last(G2tensor(7),RedSet_4(109),mass4set(:,1),  & 
G1tensor(411),G1tensor(412),G1tensor(413),G1tensor(414),G1tensor(415))
  call G_TensorShift(G1tensor(412),24)
  call Hotf_4pt_reduction_last(G2tensor(39),RedSet_4(108),mass4set(:,14),  & 
G1tensor(416),G1tensor(417),G1tensor(418),G1tensor(419),G1tensor(420))
  call G_TensorShift(G1tensor(417),24)
  call Hotf_4pt_reduction_last(G2tensor(109),RedSet_4(99),mass4set(:,4),  & 
G1tensor(421),G1tensor(422),G1tensor(423),G1tensor(424),G1tensor(425))
  call G_TensorShift(G1tensor(422),24)
  call Hotf_4pt_reduction_last(G2tensor(9),RedSet_4(109),mass4set(:,6),  & 
G1tensor(426),G1tensor(427),G1tensor(428),G1tensor(429),G1tensor(430))
  call G_TensorShift(G1tensor(427),24)
  call Hotf_4pt_reduction_last(G2tensor(112),RedSet_4(99),mass4set(:,5),  & 
G1tensor(431),G1tensor(432),G1tensor(433),G1tensor(434),G1tensor(435))
  call G_TensorShift(G1tensor(432),24)
  call Hotf_4pt_reduction_last(G2tensor(11),RedSet_4(109),mass4set(:,7),  & 
G1tensor(436),G1tensor(437),G1tensor(438),G1tensor(439),G1tensor(440))
  call G_TensorShift(G1tensor(437),24)
  call Hotf_4pt_reduction_last(G2tensor(41),RedSet_4(111),mass4set(:,1),  & 
G1tensor(441),G1tensor(442),G1tensor(443),G1tensor(444),G1tensor(445))
  call G_TensorShift(G1tensor(442),24)
  call Hotf_4pt_reduction_last(G2tensor(115),RedSet_4(99),mass4set(:,6),  & 
G1tensor(446),G1tensor(447),G1tensor(448),G1tensor(449),G1tensor(450))
  call G_TensorShift(G1tensor(447),24)
  call Hotf_4pt_reduction_last(G2tensor(13),RedSet_4(112),mass4set(:,6),  & 
G1tensor(451),G1tensor(452),G1tensor(453),G1tensor(454),G1tensor(455))
  call G_TensorShift(G1tensor(452),24)
  call Hotf_4pt_reduction_last(G2tensor(15),RedSet_4(111),mass4set(:,14),  & 
G1tensor(456),G1tensor(457),G1tensor(458),G1tensor(459),G1tensor(460))
  call G_TensorShift(G1tensor(457),24)
  call Hotf_4pt_reduction_last(G2tensor(66),RedSet_4(111),mass4set(:,3),  & 
G1tensor(461),G1tensor(462),G1tensor(463),G1tensor(464),G1tensor(465))
  call G_TensorShift(G1tensor(462),24)
  call Hotf_4pt_reduction_last(G2tensor(17),RedSet_4(112),mass4set(:,7),  & 
G1tensor(466),G1tensor(467),G1tensor(468),G1tensor(469),G1tensor(470))
  call G_TensorShift(G1tensor(467),24)
  call Hotf_4pt_reduction_last(G2tensor(62),RedSet_4(103),mass4set(:,9),  & 
G1tensor(471),G1tensor(472),G1tensor(473),G1tensor(474),G1tensor(475))
  call G_TensorShift(G1tensor(472),11)
  call Hotf_4pt_reduction_last(G2tensor(102),RedSet_4(48),mass4set(:,1),  & 
G1tensor(476),G1tensor(477),G1tensor(478),G1tensor(479),G1tensor(480))
  call G_TensorShift(G1tensor(477),4)
  call Hotf_4pt_reduction_last(G2tensor(104),RedSet_4(48),mass4set(:,2),  & 
G1tensor(481),G1tensor(482),G1tensor(483),G1tensor(484),G1tensor(485))
  call G_TensorShift(G1tensor(482),4)
  call Hotf_4pt_reduction_last(G2tensor(121),RedSet_4(11),mass4set(:,1),  & 
G1tensor(486),G1tensor(487),G1tensor(488),G1tensor(489),G1tensor(490))
  call G_TensorShift(G1tensor(487),24)
  call Hotf_4pt_reduction_last(G2tensor(124),RedSet_4(11),mass4set(:,7),  & 
G1tensor(491),G1tensor(492),G1tensor(493),G1tensor(494),G1tensor(495))
  call G_TensorShift(G1tensor(492),24)
  call Hotf_4pt_reduction_last(G2tensor(130),RedSet_4(2),mass4set(:,1),  & 
G1tensor(496),G1tensor(497),G1tensor(498),G1tensor(499),G1tensor(500))
  call G_TensorShift(G1tensor(497),16)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(11),mass4set(:,3),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(10),RedSet_4(11),mass4set(:,8),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(59),RedSet_4(95),mass4set(:,9),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(99),mass4set(:,1),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(121),RedSet_4(99),mass4set(:,10),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(151),RedSet_4(99),mass4set(:,2),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(181),RedSet_4(103),mass4set(:,3),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(211),RedSet_4(2),mass4set(:,4),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(241),RedSet_4(49),mass4set(:,4),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(271),RedSet_4(17),mass4set(:,4),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(301),RedSet_4(61),mass4set(:,4),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(331),RedSet_4(2),mass4set(:,6),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(78),RedSet_4(49),mass4set(:,6),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(276),RedSet_4(17),mass4set(:,6),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call Hotf_4pt_reduction_last(G1tensor(75),RedSet_4(61),mass4set(:,6),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
  call Hotf_4pt_reduction_last(G1tensor(117),RedSet_4(114),mass4set(:,11),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
  call Hotf_4pt_reduction_last(G1tensor(40),RedSet_4(54),mass4set(:,11),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
  call Hotf_4pt_reduction_last(G1tensor(12),RedSet_4(114),mass4set(:,12),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
  call Hotf_4pt_reduction_last(G1tensor(318),RedSet_4(54),mass4set(:,12),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
  call Hotf_4pt_reduction_last(G1tensor(330),RedSet_4(114),mass4set(:,13),  & 
G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100))
  call Hotf_4pt_reduction_last(G1tensor(338),RedSet_4(54),mass4set(:,13),  & 
G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104),G0tensor(105))
  call Hotf_4pt_reduction_last(G1tensor(135),RedSet_4(115),mass4set(:,6),  & 
G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110))
  call Hotf_4pt_reduction_last(G1tensor(147),RedSet_4(72),mass4set(:,6),  & 
G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114),G0tensor(115))
  call Hotf_4pt_reduction_last(G1tensor(30),RedSet_4(115),mass4set(:,12),  & 
G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119),G0tensor(120))
  call Hotf_4pt_reduction_last(G1tensor(8),RedSet_4(72),mass4set(:,12),  & 
G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124),G0tensor(125))
  call Hotf_4pt_reduction_last(G1tensor(17),RedSet_4(115),mass4set(:,13),  & 
G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129),G0tensor(130))
  call Hotf_4pt_reduction_last(G1tensor(99),RedSet_4(72),mass4set(:,13),  & 
G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134),G0tensor(135))
  call Hotf_4pt_reduction_last(G1tensor(123),RedSet_4(87),mass4set(:,12),  & 
G0tensor(136),G0tensor(137),G0tensor(138),G0tensor(139),G0tensor(140))
  call Hotf_4pt_reduction_last(G1tensor(158),RedSet_4(26),mass4set(:,14),  & 
G0tensor(141),G0tensor(142),G0tensor(143),G0tensor(144),G0tensor(145))
  call Hotf_4pt_reduction_last(G1tensor(170),RedSet_4(27),mass4set(:,6),  & 
G0tensor(146),G0tensor(147),G0tensor(148),G0tensor(149),G0tensor(150))
  call Hotf_4pt_reduction_last(G1tensor(176),RedSet_4(28),mass4set(:,12),  & 
G0tensor(151),G0tensor(152),G0tensor(153),G0tensor(154),G0tensor(155))
  call Hotf_4pt_reduction_last(G1tensor(141),RedSet_4(90),mass4set(:,12),  & 
G0tensor(156),G0tensor(157),G0tensor(158),G0tensor(159),G0tensor(160))
  call Hotf_4pt_reduction_last(G1tensor(182),RedSet_4(36),mass4set(:,14),  & 
G0tensor(161),G0tensor(162),G0tensor(163),G0tensor(164),G0tensor(165))
  call Hotf_4pt_reduction_last(G1tensor(194),RedSet_4(37),mass4set(:,6),  & 
G0tensor(166),G0tensor(167),G0tensor(168),G0tensor(169),G0tensor(170))
  call Hotf_4pt_reduction_last(G1tensor(20),RedSet_4(79),mass4set(:,6),  & 
G0tensor(171),G0tensor(172),G0tensor(173),G0tensor(174),G0tensor(175))
  call Hotf_4pt_reduction_last(G1tensor(200),RedSet_4(1),mass4set(:,1),  & 
G0tensor(176),G0tensor(177),G0tensor(178),G0tensor(179),G0tensor(180))
  call Hotf_4pt_reduction_last(G1tensor(212),RedSet_4(3),mass4set(:,6),  & 
G0tensor(181),G0tensor(182),G0tensor(183),G0tensor(184),G0tensor(185))
  call Hotf_4pt_reduction_last(G1tensor(218),RedSet_4(4),mass4set(:,6),  & 
G0tensor(186),G0tensor(187),G0tensor(188),G0tensor(189),G0tensor(190))
  call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(79),mass4set(:,12),  & 
G0tensor(191),G0tensor(192),G0tensor(193),G0tensor(194),G0tensor(195))
  call Hotf_4pt_reduction_last(G1tensor(224),RedSet_4(1),mass4set(:,14),  & 
G0tensor(196),G0tensor(197),G0tensor(198),G0tensor(199),G0tensor(200))
  call Hotf_4pt_reduction_last(G1tensor(230),RedSet_4(4),mass4set(:,12),  & 
G0tensor(201),G0tensor(202),G0tensor(203),G0tensor(204),G0tensor(205))
  call Hotf_4pt_reduction_last(G1tensor(81),RedSet_4(83),mass4set(:,6),  & 
G0tensor(206),G0tensor(207),G0tensor(208),G0tensor(209),G0tensor(210))
  call Hotf_4pt_reduction_last(G1tensor(236),RedSet_4(16),mass4set(:,1),  & 
G0tensor(211),G0tensor(212),G0tensor(213),G0tensor(214),G0tensor(215))
  call Hotf_4pt_reduction_last(G1tensor(248),RedSet_4(18),mass4set(:,6),  & 
G0tensor(216),G0tensor(217),G0tensor(218),G0tensor(219),G0tensor(220))
  call Hotf_4pt_reduction_last(G1tensor(105),RedSet_4(83),mass4set(:,12),  & 
G0tensor(221),G0tensor(222),G0tensor(223),G0tensor(224),G0tensor(225))
  call Hotf_4pt_reduction_last(G1tensor(254),RedSet_4(16),mass4set(:,14),  & 
G0tensor(226),G0tensor(227),G0tensor(228),G0tensor(229),G0tensor(230))
  call Hotf_4pt_reduction_last(G1tensor(80),RedSet_4(120),mass4set(:,3),  & 
G0tensor(231),G0tensor(232),G0tensor(233),G0tensor(234),G0tensor(235))
  call Hotf_4pt_reduction_last(G1tensor(28),RedSet_4(80),mass4set(:,1),  & 
G0tensor(236),G0tensor(237),G0tensor(238),G0tensor(239),G0tensor(240))
  call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(81),mass4set(:,3),  & 
G0tensor(241),G0tensor(242),G0tensor(243),G0tensor(244),G0tensor(245))
  call Hotf_4pt_reduction_last(G1tensor(72),RedSet_4(82),mass4set(:,3),  & 
G0tensor(246),G0tensor(247),G0tensor(248),G0tensor(249),G0tensor(250))
  call Hotf_4pt_reduction_last(G1tensor(70),RedSet_4(6),mass4set(:,1),  & 
G0tensor(251),G0tensor(252),G0tensor(253),G0tensor(254),G0tensor(255))
  call Hotf_4pt_reduction_last(G1tensor(65),RedSet_4(7),mass4set(:,1),  & 
G0tensor(256),G0tensor(257),G0tensor(258),G0tensor(259),G0tensor(260))
  call Hotf_4pt_reduction_last(G1tensor(90),RedSet_4(8),mass4set(:,1),  & 
G0tensor(261),G0tensor(262),G0tensor(263),G0tensor(264),G0tensor(265))
  call Hotf_4pt_reduction_last(G1tensor(47),RedSet_4(10),mass4set(:,3),  & 
G0tensor(266),G0tensor(267),G0tensor(268),G0tensor(269),G0tensor(270))
  call Hotf_4pt_reduction_last(G1tensor(102),RedSet_4(13),mass4set(:,3),  & 
G0tensor(271),G0tensor(272),G0tensor(273),G0tensor(274),G0tensor(275))
  call Hotf_4pt_reduction_last(G1tensor(104),RedSet_4(120),mass4set(:,15),  & 
G0tensor(276),G0tensor(277),G0tensor(278),G0tensor(279),G0tensor(280))
  call Hotf_4pt_reduction_last(G1tensor(63),RedSet_4(80),mass4set(:,10),  & 
G0tensor(281),G0tensor(282),G0tensor(283),G0tensor(284),G0tensor(285))
  call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(81),mass4set(:,8),  & 
G0tensor(286),G0tensor(287),G0tensor(288),G0tensor(289),G0tensor(290))
  call Hotf_4pt_reduction_last(G1tensor(125),RedSet_4(6),mass4set(:,14),  & 
G0tensor(291),G0tensor(292),G0tensor(293),G0tensor(294),G0tensor(295))
  call Hotf_4pt_reduction_last(G1tensor(114),RedSet_4(8),mass4set(:,10),  & 
G0tensor(296),G0tensor(297),G0tensor(298),G0tensor(299),G0tensor(300))
  call Hotf_4pt_reduction_last(G1tensor(86),RedSet_4(84),mass4set(:,1),  & 
G0tensor(301),G0tensor(302),G0tensor(303),G0tensor(304),G0tensor(305))
  call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(85),mass4set(:,3),  & 
G0tensor(306),G0tensor(307),G0tensor(308),G0tensor(309),G0tensor(310))
  call Hotf_4pt_reduction_last(G1tensor(108),RedSet_4(86),mass4set(:,3),  & 
G0tensor(311),G0tensor(312),G0tensor(313),G0tensor(314),G0tensor(315))
  call Hotf_4pt_reduction_last(G1tensor(83),RedSet_4(20),mass4set(:,1),  & 
G0tensor(316),G0tensor(317),G0tensor(318),G0tensor(319),G0tensor(320))
  call Hotf_4pt_reduction_last(G1tensor(113),RedSet_4(21),mass4set(:,1),  & 
G0tensor(321),G0tensor(322),G0tensor(323),G0tensor(324),G0tensor(325))
  call Hotf_4pt_reduction_last(G1tensor(88),RedSet_4(23),mass4set(:,3),  & 
G0tensor(326),G0tensor(327),G0tensor(328),G0tensor(329),G0tensor(330))
  call Hotf_4pt_reduction_last(G1tensor(110),RedSet_4(84),mass4set(:,10),  & 
G0tensor(331),G0tensor(332),G0tensor(333),G0tensor(334),G0tensor(335))
  call Hotf_4pt_reduction_last(G1tensor(119),RedSet_4(85),mass4set(:,8),  & 
G0tensor(336),G0tensor(337),G0tensor(338),G0tensor(339),G0tensor(340))
  call Hotf_4pt_reduction_last(G1tensor(116),RedSet_4(20),mass4set(:,14),  & 
G0tensor(341),G0tensor(342),G0tensor(343),G0tensor(344),G0tensor(345))
  call Hotf_4pt_reduction_last(G1tensor(140),RedSet_4(121),mass4set(:,15),  & 
G0tensor(346),G0tensor(347),G0tensor(348),G0tensor(349),G0tensor(350))
  call Hotf_4pt_reduction_last(G1tensor(128),RedSet_4(88),mass4set(:,10),  & 
G0tensor(351),G0tensor(352),G0tensor(353),G0tensor(354),G0tensor(355))
  call Hotf_4pt_reduction_last(G1tensor(134),RedSet_4(89),mass4set(:,3),  & 
G0tensor(356),G0tensor(357),G0tensor(358),G0tensor(359),G0tensor(360))
  call Hotf_4pt_reduction_last(G1tensor(136),RedSet_4(30),mass4set(:,1),  & 
G0tensor(361),G0tensor(362),G0tensor(363),G0tensor(364),G0tensor(365))
  call Hotf_4pt_reduction_last(G1tensor(150),RedSet_4(31),mass4set(:,10),  & 
G0tensor(366),G0tensor(367),G0tensor(368),G0tensor(369),G0tensor(370))
  call Hotf_4pt_reduction_last(G1tensor(156),RedSet_4(33),mass4set(:,3),  & 
G0tensor(371),G0tensor(372),G0tensor(373),G0tensor(374),G0tensor(375))
  call Hotf_4pt_reduction_last(G1tensor(146),RedSet_4(91),mass4set(:,10),  & 
G0tensor(376),G0tensor(377),G0tensor(378),G0tensor(379),G0tensor(380))
  call Hotf_4pt_reduction_last(G1tensor(152),RedSet_4(92),mass4set(:,3),  & 
G0tensor(381),G0tensor(382),G0tensor(383),G0tensor(384),G0tensor(385))
  call Hotf_4pt_reduction_last(G1tensor(154),RedSet_4(39),mass4set(:,1),  & 
G0tensor(386),G0tensor(387),G0tensor(388),G0tensor(389),G0tensor(390))
  call Hotf_4pt_reduction_last(G1tensor(112),RedSet_4(42),mass4set(:,7),  & 
G0tensor(391),G0tensor(392),G0tensor(393),G0tensor(394),G0tensor(395))
  call Hotf_4pt_reduction_last(G1tensor(171),RedSet_4(43),mass4set(:,1),  & 
G0tensor(396),G0tensor(397),G0tensor(398),G0tensor(399),G0tensor(400))
  call Hotf_4pt_reduction_last(G1tensor(185),RedSet_4(44),mass4set(:,14),  & 
G0tensor(401),G0tensor(402),G0tensor(403),G0tensor(404),G0tensor(405))
  call Hotf_4pt_reduction_last(G1tensor(162),RedSet_4(45),mass4set(:,14),  & 
G0tensor(406),G0tensor(407),G0tensor(408),G0tensor(409),G0tensor(410))
  call Hotf_4pt_reduction_last(G1tensor(132),RedSet_4(47),mass4set(:,6),  & 
G0tensor(411),G0tensor(412),G0tensor(413),G0tensor(414),G0tensor(415))
  call Hotf_4pt_reduction_last(G1tensor(225),RedSet_4(48),mass4set(:,4),  & 
G0tensor(416),G0tensor(417),G0tensor(418),G0tensor(419),G0tensor(420))
  call Hotf_4pt_reduction_last(G1tensor(197),RedSet_4(51),mass4set(:,6),  & 
G0tensor(421),G0tensor(422),G0tensor(423),G0tensor(424),G0tensor(425))
  call Hotf_4pt_reduction_last(G1tensor(174),RedSet_4(52),mass4set(:,6),  & 
G0tensor(426),G0tensor(427),G0tensor(428),G0tensor(429),G0tensor(430))
  call Hotf_4pt_reduction_last(G1tensor(161),RedSet_4(56),mass4set(:,7),  & 
G0tensor(431),G0tensor(432),G0tensor(433),G0tensor(434),G0tensor(435))
  call Hotf_4pt_reduction_last(G1tensor(195),RedSet_4(57),mass4set(:,1),  & 
G0tensor(436),G0tensor(437),G0tensor(438),G0tensor(439),G0tensor(440))
  call Hotf_4pt_reduction_last(G1tensor(186),RedSet_4(58),mass4set(:,14),  & 
G0tensor(441),G0tensor(442),G0tensor(443),G0tensor(444),G0tensor(445))
  call Hotf_4pt_reduction_last(G1tensor(232),RedSet_4(60),mass4set(:,6),  & 
G0tensor(446),G0tensor(447),G0tensor(448),G0tensor(449),G0tensor(450))
  call Hotf_4pt_reduction_last(G1tensor(198),RedSet_4(63),mass4set(:,6),  & 
G0tensor(451),G0tensor(452),G0tensor(453),G0tensor(454),G0tensor(455))
  call Hotf_4pt_reduction_last(G1tensor(173),RedSet_4(42),mass4set(:,1),  & 
G0tensor(456),G0tensor(457),G0tensor(458),G0tensor(459),G0tensor(460))
  call Hotf_4pt_reduction_last(G1tensor(226),RedSet_4(65),mass4set(:,1),  & 
G0tensor(461),G0tensor(462),G0tensor(463),G0tensor(464),G0tensor(465))
  call Hotf_4pt_reduction_last(G1tensor(239),RedSet_4(66),mass4set(:,1),  & 
G0tensor(466),G0tensor(467),G0tensor(468),G0tensor(469),G0tensor(470))
  call Hotf_4pt_reduction_last(G1tensor(204),RedSet_4(67),mass4set(:,1),  & 
G0tensor(471),G0tensor(472),G0tensor(473),G0tensor(474),G0tensor(475))
  call Hotf_4pt_reduction_last(G1tensor(250),RedSet_4(48),mass4set(:,6),  & 
G0tensor(476),G0tensor(477),G0tensor(478),G0tensor(479),G0tensor(480))
  call Hotf_4pt_reduction_last(G1tensor(251),RedSet_4(69),mass4set(:,6),  & 
G0tensor(481),G0tensor(482),G0tensor(483),G0tensor(484),G0tensor(485))
  call Hotf_4pt_reduction_last(G1tensor(216),RedSet_4(70),mass4set(:,6),  & 
G0tensor(486),G0tensor(487),G0tensor(488),G0tensor(489),G0tensor(490))
  call Hotf_4pt_reduction_last(G1tensor(257),RedSet_4(66),mass4set(:,14),  & 
G0tensor(491),G0tensor(492),G0tensor(493),G0tensor(494),G0tensor(495))
  call Hotf_4pt_reduction_last(G1tensor(228),RedSet_4(67),mass4set(:,14),  & 
G0tensor(496),G0tensor(497),G0tensor(498),G0tensor(499),G0tensor(500))
  call Hotf_4pt_reduction_last(G1tensor(201),RedSet_4(56),mass4set(:,1),  & 
G0tensor(501),G0tensor(502),G0tensor(503),G0tensor(504),G0tensor(505))
  call Hotf_4pt_reduction_last(G1tensor(256),RedSet_4(74),mass4set(:,1),  & 
G0tensor(506),G0tensor(507),G0tensor(508),G0tensor(509),G0tensor(510))
  call Hotf_4pt_reduction_last(G1tensor(240),RedSet_4(75),mass4set(:,1),  & 
G0tensor(511),G0tensor(512),G0tensor(513),G0tensor(514),G0tensor(515))
  call Hotf_4pt_reduction_last(G1tensor(252),RedSet_4(77),mass4set(:,6),  & 
G0tensor(516),G0tensor(517),G0tensor(518),G0tensor(519),G0tensor(520))
  call Hotf_4pt_reduction_last(G1tensor(258),RedSet_4(75),mass4set(:,14),  & 
G0tensor(521),G0tensor(522),G0tensor(523),G0tensor(524),G0tensor(525))
  call Hotf_4pt_reduction_last(G1tensor(245),RedSet_4(116),mass4set(:,1),  & 
G0tensor(526),G0tensor(527),G0tensor(528),G0tensor(529),G0tensor(530))
  call Hotf_4pt_reduction_last(G1tensor(215),RedSet_4(93),mass4set(:,9),  & 
G0tensor(531),G0tensor(532),G0tensor(533),G0tensor(534),G0tensor(535))
  call Hotf_4pt_reduction_last(G1tensor(249),RedSet_4(94),mass4set(:,9),  & 
G0tensor(536),G0tensor(537),G0tensor(538),G0tensor(539),G0tensor(540))
  call Hotf_4pt_reduction_last(G1tensor(263),RedSet_4(10),mass4set(:,9),  & 
G0tensor(541),G0tensor(542),G0tensor(543),G0tensor(544),G0tensor(545))
  call Hotf_4pt_reduction_last(G1tensor(269),RedSet_4(117),mass4set(:,1),  & 
G0tensor(546),G0tensor(547),G0tensor(548),G0tensor(549),G0tensor(550))
  call Hotf_4pt_reduction_last(G1tensor(281),RedSet_4(97),mass4set(:,1),  & 
G0tensor(551),G0tensor(552),G0tensor(553),G0tensor(554),G0tensor(555))
  call Hotf_4pt_reduction_last(G1tensor(290),RedSet_4(98),mass4set(:,1),  & 
G0tensor(556),G0tensor(557),G0tensor(558),G0tensor(559),G0tensor(560))
  call Hotf_4pt_reduction_last(G1tensor(297),RedSet_4(117),mass4set(:,10),  & 
G0tensor(561),G0tensor(562),G0tensor(563),G0tensor(564),G0tensor(565))
  call Hotf_4pt_reduction_last(G1tensor(309),RedSet_4(97),mass4set(:,14),  & 
G0tensor(566),G0tensor(567),G0tensor(568),G0tensor(569),G0tensor(570))
  call Hotf_4pt_reduction_last(G1tensor(316),RedSet_4(97),mass4set(:,2),  & 
G0tensor(571),G0tensor(572),G0tensor(573),G0tensor(574),G0tensor(575))
  call Hotf_4pt_reduction_last(G1tensor(327),RedSet_4(6),mass4set(:,2),  & 
G0tensor(576),G0tensor(577),G0tensor(578),G0tensor(579),G0tensor(580))
  call Hotf_4pt_reduction_last(G1tensor(339),RedSet_4(98),mass4set(:,2),  & 
G0tensor(581),G0tensor(582),G0tensor(583),G0tensor(584),G0tensor(585))
  call Hotf_4pt_reduction_last(G1tensor(346),RedSet_4(118),mass4set(:,3),  & 
G0tensor(586),G0tensor(587),G0tensor(588),G0tensor(589),G0tensor(590))
  call Hotf_4pt_reduction_last(G1tensor(351),RedSet_4(101),mass4set(:,6),  & 
G0tensor(591),G0tensor(592),G0tensor(593),G0tensor(594),G0tensor(595))



end subroutine vamp_1

end module ol_vamp_1_pplnjj_ew_nexeuccxdx_1_/**/REALKIND
