
module ol_vamp_1_pplnjj_ew_neexuxdssx_4_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pplnjj_ew_neexuxdssx_4.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pplnjj_ew_neexuxdssx_4.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pplnjj_ew_neexuxdssx_4_/**/DREALKIND
  use ol_tensor_sum_storage_pplnjj_ew_neexuxdssx_4_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pplnjj_ew_neexuxdssx_4_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pplnjj_ew_neexuxdssx_4_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(56)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,8,4,1,2,16],[0,0,nMW,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,1),heltab2x64(:,:,1))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,8,4,1,2,16],[nMZ,0,nMW,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(2),ngZd,m3h2x32(:,2),heltab2x64(:,:,2))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,8,4,1,2,16],[0,0,nMW,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,3),heltab2x64(:,:,3))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,8,4,1,2,16],[nMZ,0,nMW,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(4),ngZd,m3h2x32(:,4),heltab2x64(:,:,4))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,8,4,1,2,16],[nMW,0,nMZ,0,nMW,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,5),heltab2x64(:,:,5))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,2,1,4,8,16],[0,0,nMW,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,6),heltab2x64(:,:,6))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[32,2,1,4,8,16],[0,0,nMW,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,7),heltab2x64(:,:,7))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[32,2,1,4,8,16],[nMZ,0,nMW,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(8),ngZd,m3h2x32(:,8),heltab2x64(:,:,8))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[32,2,1,4,8,16],[nMZ,0,nMW,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(9),ngZd,m3h2x32(:,9),heltab2x64(:,:,9))
  Gcoeff(:)%j = (c(58)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,4,8,1,2,16],[0,0,nMW,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,10),heltab2x64(:,:,10))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[32,4,8,1,2,16],[nMZ,0,nMW,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(11),ngZd,m3h2x32(:,11),heltab2x64(:,:,11))
  Gcoeff(:)%j = (c(62)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[32,4,8,1,2,16],[0,0,nMW,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(12),m3h2x32(:,12),heltab2x64(:,:,12))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[32,4,8,1,2,16],[nMZ,0,nMW,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(13),ngZd,m3h2x32(:,13),heltab2x64(:,:,13))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[32,4,8,1,2,16],[nMW,0,nMZ,0,nMW,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(14),m3h2x32(:,14),heltab2x64(:,:,14))
  Gcoeff(:)%j = (c(58)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[32,2,1,8,4,16],[0,0,nMW,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(15),m3h2x32(:,15),heltab2x64(:,:,15))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[32,2,1,8,4,16],[0,0,nMW,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(16),m3h2x32(:,16),heltab2x64(:,:,16))
  Gcoeff(:)%j = (c(62)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[32,2,1,8,4,16],[nMZ,0,nMW,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(17),ngZd,m3h2x32(:,17),heltab2x64(:,:,17))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[32,2,1,8,4,16],[nMZ,0,nMW,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(18),ngZd,m3h2x32(:,18),heltab2x64(:,:,18))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[32,8,4,2,1,16],[0,0,nMW,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(19),m3h2x32(:,19),heltab2x64(:,:,19))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[32,8,4,2,1,16],[nMZ,0,nMW,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(20),ngZd,m3h2x32(:,20),heltab2x64(:,:,20))
  Gcoeff(:)%j = (c(27)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[32,8,4,2,1,16],[nMW,0,0,0,nMW,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(21),m3h2x32(:,21),heltab2x64(:,:,21))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[32,8,4,2,1,16],[nMW,0,nMZ,0,nMW,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(22),m3h2x32(:,22),heltab2x64(:,:,22))
  Gcoeff(:)%j = (c(62)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[32,4,8,2,1,16],[0,0,nMW,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(23),m3h2x32(:,23),heltab2x64(:,:,23))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[32,4,8,2,1,16],[nMZ,0,nMW,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(24),ngZd,m3h2x32(:,24),heltab2x64(:,:,24))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[32,4,8,2,1,16],[nMW,0,0,0,nMW,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,25),heltab2x64(:,:,25))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[32,4,8,2,1,16],[nMW,0,nMZ,0,nMW,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(26),m3h2x32(:,26),heltab2x64(:,:,26))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[32,1,2,4,8,16],[nMZ,0,nMW,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(27),ngZd,m3h2x32(:,27),heltab2x64(:,:,27))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[32,1,2,4,8,16],[nMZ,0,nMW,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(28),ngZd,m3h2x32(:,28),heltab2x64(:,:,28))
  Gcoeff(:)%j = (c(62)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[32,1,2,8,4,16],[nMZ,0,nMW,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(29),ngZd,m3h2x32(:,29),heltab2x64(:,:,29))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[32,1,2,8,4,16],[nMZ,0,nMW,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(30),ngZd,m3h2x32(:,30),heltab2x64(:,:,30))
  call Hloop_VQ_A(ntryL,G0H32(1),ex4(:),G0H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(1),n2h16(1))
  call Hloop_ZQ_A(ntryL,G0H32(2),ex4(:),G0H16(1),ngZd,m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(2),n2h16(2))
  call Hloop_VQ_A(ntryL,G0H32(3),ex4(:),G0H16(1),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(3),n2h16(3))
  call Hloop_ZQ_A(ntryL,G0H32(4),ex4(:),G0H16(1),ngZd,m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(4),n2h16(4))
  call Hloop_WQ_A(ntryL,G0H32(5),ex4(:),G0H16(1),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(5),n2h16(5))
  call Hloop_VA_Q(ntryL,G0H32(6),ex2(:),G0H16(1),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(6),n2h16(6))
  call Hloop_VA_Q(ntryL,G0H32(7),ex2(:),G0H16(1),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(7),n2h16(7))
  call Hloop_ZA_Q(ntryL,G0H32(8),ex2(:),G0H16(1),ngZl,m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(8),n2h16(8))
  call Hloop_ZA_Q(ntryL,G0H32(9),ex2(:),G0H16(1),ngZl,m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(9),n2h16(9))
  call Hloop_VA_Q(ntryL,G0H32(10),ex3(:),G0H16(1),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(10),n2h16(10))
  call Hloop_ZA_Q(ntryL,G0H32(11),ex3(:),G0H16(1),ngZu,m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(11),n2h16(11))
  call Hloop_VA_Q(ntryL,G0H32(12),ex3(:),G0H16(1),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(12),n2h16(12))
  call Hloop_ZA_Q(ntryL,G0H32(13),ex3(:),G0H16(1),ngZu,m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(13),n2h16(13))
  call Hloop_WA_Q(ntryL,G0H32(14),ex3(:),G0H16(1),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(14),n2h16(14))
  call Hloop_VA_Q(ntryL,G0H32(15),ex2(:),G0H16(1),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(15),n2h16(15))
  call Hloop_VA_Q(ntryL,G0H32(16),ex2(:),G0H16(1),m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(16),n2h16(16))
  call Hloop_ZA_Q(ntryL,G0H32(17),ex2(:),G0H16(1),ngZl,m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(17),n2h16(17))
  call Hloop_ZA_Q(ntryL,G0H32(18),ex2(:),G0H16(1),ngZl,m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(18),n2h16(18))
  call Hloop_VQ_A(ntryL,G0H32(19),ex4(:),G0H16(1),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(19),n2h16(19))
  call Hloop_ZQ_A(ntryL,G0H32(20),ex4(:),G0H16(1),ngZd,m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(20),n2h16(20))
  call Hloop_WQ_A(ntryL,G0H32(21),ex4(:),G0H16(1),m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(21),n2h16(21))
  call Hloop_WQ_A(ntryL,G0H32(22),ex4(:),G0H16(1),m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(22),n2h16(22))
  call Hloop_VA_Q(ntryL,G0H32(23),ex3(:),G0H16(1),m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(23),n2h16(23))
  call Hloop_ZA_Q(ntryL,G0H32(24),ex3(:),G0H16(1),ngZu,m3h2x16(:,24),heltab2x32(:,:,24))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(24),n2h16(24))
  call Hloop_WA_Q(ntryL,G0H32(25),ex3(:),G0H16(1),m3h2x16(:,25),heltab2x32(:,:,25))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(25),n2h16(25))
  call Hloop_WA_Q(ntryL,G0H32(26),ex3(:),G0H16(1),m3h2x16(:,26),heltab2x32(:,:,26))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(26),n2h16(26))
  call Hloop_ZQ_A(ntryL,G0H32(27),ex1(:),G0H16(1),ngZn,m3h2x16(:,27),heltab2x32(:,:,27))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(27),n2h16(27))
  call Hloop_ZQ_A(ntryL,G0H32(28),ex1(:),G0H16(1),ngZn,m3h2x16(:,28),heltab2x32(:,:,28))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(28),n2h16(28))
  call Hloop_ZQ_A(ntryL,G0H32(29),ex1(:),G0H16(1),ngZn,m3h2x16(:,29),heltab2x32(:,:,29))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(29),n2h16(29))
  call Hloop_ZQ_A(ntryL,G0H32(30),ex1(:),G0H16(1),ngZn,m3h2x16(:,30),heltab2x32(:,:,30))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(30),n2h16(30))
  call Hloop_QA_W(ntryL,G1H16(1),ex3(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_QA_W(ntryL,G1H16(2),ex3(:),G1H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_QA_W(ntryL,G1H16(3),ex3(:),G1H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_QA_W(ntryL,G1H16(4),ex3(:),G1H8(4),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_QA_Z(ntryL,G1H16(5),ex3(:),G1H8(5),ngZu,m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_AQ_W(ntryL,G1H16(6),ex1(:),G1H8(6),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_AQ_W(ntryL,G1H16(7),ex1(:),G1H8(7),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_AQ_W(ntryL,G1H16(8),ex1(:),G1H8(8),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_AQ_W(ntryL,G1H16(9),ex1(:),G1H8(9),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_AQ_W(ntryL,G1H16(10),ex4(:),G1H8(10),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_AQ_W(ntryL,G1H16(11),ex4(:),G1H8(11),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_AQ_W(ntryL,G1H16(12),ex4(:),G1H8(12),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_AQ_W(ntryL,G1H16(13),ex4(:),G1H8(13),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_AQ_Z(ntryL,G1H16(14),ex4(:),G1H8(14),ngZd,m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_AQ_W(ntryL,G1H16(15),ex1(:),G1H8(15),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_AQ_W(ntryL,G1H16(16),ex1(:),G1H8(16),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_AQ_W(ntryL,G1H16(17),ex1(:),G1H8(17),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_AQ_W(ntryL,G1H16(18),ex1(:),G1H8(18),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_QA_W(ntryL,G1H16(19),ex3(:),G1H8(19),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_QA_W(ntryL,G1H16(20),ex3(:),G1H8(20),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_QA_V(ntryL,G1H16(21),ex3(:),G1H8(21),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_QA_Z(ntryL,G1H16(22),ex3(:),G1H8(22),ngZu,m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_AQ_W(ntryL,G1H16(23),ex4(:),G1H8(23),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_AQ_W(ntryL,G1H16(24),ex4(:),G1H8(24),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_AQ_V(ntryL,G1H16(25),ex4(:),G1H8(25),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_AQ_Z(ntryL,G1H16(26),ex4(:),G1H8(26),ngZd,m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_QA_W(ntryL,G1H16(27),ex2(:),G1H8(27),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_QA_W(ntryL,G1H16(28),ex2(:),G1H8(28),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_QA_W(ntryL,G1H16(29),ex2(:),G1H8(29),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_QA_W(ntryL,G1H16(30),ex2(:),G1H8(30),m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_WQ_A(ntryL,G1H8(1),ex1(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(1),n2h4(1))
  call Hloop_WQ_A(ntryL,G1H8(2),ex1(:),G1H4(1),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(2),n2h4(2))
  call Hloop_WQ_A(ntryL,G1H8(3),ex1(:),G1H4(1),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(3),n2h4(3))
  call Hloop_WQ_A(ntryL,G1H8(4),ex1(:),G1H4(1),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(4),n2h4(4))
  call Hloop_ZQ_A(ntryL,G1H8(5),ex1(:),G1H4(1),ngZn,m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(5),n2h4(5))
  call Hloop_WA_Q(ntryL,G1H8(6),ex3(:),G1H4(1),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_A_Q(ntryL,G1H4(1),39,0,G2H4(6),n2h4(6))
  call Hloop_WA_Q(ntryL,G1H8(7),ex3(:),G1H4(1),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_A_Q(ntryL,G1H4(1),39,0,G2H4(7),n2h4(7))
  call Hloop_WA_Q(ntryL,G1H8(8),ex3(:),G1H4(1),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_A_Q(ntryL,G1H4(1),39,0,G2H4(8),n2h4(8))
  call Hloop_WA_Q(ntryL,G1H8(9),ex3(:),G1H4(1),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_A_Q(ntryL,G1H4(1),39,0,G2H4(9),n2h4(9))
  call Hloop_WQ_A(ntryL,G1H8(10),ex1(:),G1H4(1),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(10),n2h4(10))
  call Hloop_WQ_A(ntryL,G1H8(11),ex1(:),G1H4(1),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(11),n2h4(11))
  call Hloop_WQ_A(ntryL,G1H8(12),ex1(:),G1H4(1),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(12),n2h4(12))
  call Hloop_WQ_A(ntryL,G1H8(13),ex1(:),G1H4(1),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(13),n2h4(13))
  call Hloop_ZQ_A(ntryL,G1H8(14),ex1(:),G1H4(1),ngZn,m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(14),n2h4(14))
  call Hloop_WQ_A(ntryL,G1H8(15),ex4(:),G1H4(1),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(15),n2h4(15))
  call Hloop_WQ_A(ntryL,G1H8(16),ex4(:),G1H4(1),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(16),n2h4(16))
  call Hloop_WQ_A(ntryL,G1H8(17),ex4(:),G1H4(1),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(17),n2h4(17))
  call Hloop_WQ_A(ntryL,G1H8(18),ex4(:),G1H4(1),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(18),n2h4(18))
  call Hloop_WA_Q(ntryL,G1H8(19),ex2(:),G1H4(1),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(19),n2h4(19))
  call Hloop_WA_Q(ntryL,G1H8(20),ex2(:),G1H4(1),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(20),n2h4(20))
  call Hloop_VA_Q(ntryL,G1H8(21),ex2(:),G1H4(1),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(21),n2h4(21))
  call Hloop_ZA_Q(ntryL,G1H8(22),ex2(:),G1H4(1),ngZl,m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(22),n2h4(22))
  call Hloop_WA_Q(ntryL,G1H8(23),ex2(:),G1H4(1),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(23),n2h4(23))
  call Hloop_WA_Q(ntryL,G1H8(24),ex2(:),G1H4(1),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(24),n2h4(24))
  call Hloop_VA_Q(ntryL,G1H8(25),ex2(:),G1H4(1),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(25),n2h4(25))
  call Hloop_ZA_Q(ntryL,G1H8(26),ex2(:),G1H4(1),ngZl,m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(26),n2h4(26))
  call Hloop_WA_Q(ntryL,G1H8(27),ex3(:),G1H4(1),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_A_Q(ntryL,G1H4(1),39,0,G2H4(27),n2h4(27))
  call Hloop_WA_Q(ntryL,G1H8(28),ex3(:),G1H4(1),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_A_Q(ntryL,G1H4(1),39,0,G2H4(28),n2h4(28))
  call Hloop_WQ_A(ntryL,G1H8(29),ex4(:),G1H4(1),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(29),n2h4(29))
  call Hloop_WQ_A(ntryL,G1H8(30),ex4(:),G1H4(1),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(30),n2h4(30))
  call Hloop_QA_V(ntryL,G2H4(1),ex2(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_V(ntryL,G2H4(2),ex2(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_Z(ntryL,G2H4(3),ex2(:),G2H2(3),ngZl,m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_Z(ntryL,G2H4(4),ex2(:),G2H2(4),ngZl,m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_QA_W(ntryL,G2H4(5),ex2(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_V(ntryL,G2H4(6),ex4(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_AQ_Z(ntryL,G2H4(7),ex4(:),G2H2(7),ngZd,m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_V(ntryL,G2H4(8),ex4(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_AQ_Z(ntryL,G2H4(9),ex4(:),G2H2(9),ngZd,m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_QA_V(ntryL,G2H4(10),ex2(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_QA_V(ntryL,G2H4(11),ex2(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_QA_Z(ntryL,G2H4(12),ex2(:),G2H2(12),ngZl,m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_QA_Z(ntryL,G2H4(13),ex2(:),G2H2(13),ngZl,m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_QA_W(ntryL,G2H4(14),ex2(:),G2H2(14),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_QA_V(ntryL,G2H4(15),ex3(:),G2H2(15),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_QA_Z(ntryL,G2H4(16),ex3(:),G2H2(16),ngZu,m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_QA_V(ntryL,G2H4(17),ex3(:),G2H2(17),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_QA_Z(ntryL,G2H4(18),ex3(:),G2H2(18),ngZu,m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_AQ_Z(ntryL,G2H4(19),ex1(:),G2H2(19),ngZn,m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_AQ_Z(ntryL,G2H4(20),ex1(:),G2H2(20),ngZn,m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_AQ_W(ntryL,G2H4(21),ex1(:),G2H2(21),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_AQ_W(ntryL,G2H4(22),ex1(:),G2H2(22),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_AQ_Z(ntryL,G2H4(23),ex1(:),G2H2(23),ngZn,m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_AQ_Z(ntryL,G2H4(24),ex1(:),G2H2(24),ngZn,m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_AQ_W(ntryL,G2H4(25),ex1(:),G2H2(25),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_AQ_W(ntryL,G2H4(26),ex1(:),G2H2(26),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_AQ_V(ntryL,G2H4(27),ex4(:),G2H2(27),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_AQ_Z(ntryL,G2H4(28),ex4(:),G2H2(28),ngZd,m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_QA_V(ntryL,G2H4(29),ex3(:),G2H2(29),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_QA_Z(ntryL,G2H4(30),ex3(:),G2H2(30),ngZu,m3h2x2(:,30),heltab2x4(:,:,30))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(2),16,2)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(1),mass5set(:,2),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(8),16,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(1),mass5set(:,1),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),G1H2(18),2)
  call HG1shiftOLR(G1H2(14),16,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(1),mass5set(:,2),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),G1H2(24),2)
  call HG1shiftOLR(G1H2(20),16,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(1),mass5set(:,3),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(26),16,2)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(2),mass5set(:,1),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(32),16,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(2),mass5set(:,1),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
  call HG1shiftOLR(G1H2(38),16,2)
  call Hotf_5pt_reduction(G2H2(8),RedSet_5(2),mass5set(:,2),  & 
G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),G1H2(48),2)
  call HG1shiftOLR(G1H2(44),16,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(2),mass5set(:,2),  & 
G1H2(49),G1H2(50),G1H2(51),G1H2(52),G1H2(53),G1H2(54),2)
  call HG1shiftOLR(G1H2(50),16,2)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(3),mass5set(:,1),  & 
G1H2(55),G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),2)
  call HG1shiftOLR(G1H2(56),16,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(3),mass5set(:,2),  & 
G1H2(61),G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(62),16,2)
  call Hotf_5pt_reduction(G2H2(12),RedSet_5(3),mass5set(:,1),  & 
G1H2(67),G1H2(68),G1H2(69),G1H2(70),G1H2(71),G1H2(72),2)
  call HG1shiftOLR(G1H2(68),16,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(3),mass5set(:,2),  & 
G1H2(73),G1H2(74),G1H2(75),G1H2(76),G1H2(77),G1H2(78),2)
  call HG1shiftOLR(G1H2(74),16,2)
  call Hotf_5pt_reduction(G2H2(14),RedSet_5(3),mass5set(:,3),  & 
G1H2(79),G1H2(80),G1H2(81),G1H2(82),G1H2(83),G1H2(84),2)
  call HG1shiftOLR(G1H2(80),16,2)
  call Hotf_5pt_reduction(G2H2(15),RedSet_5(4),mass5set(:,1),  & 
G1H2(85),G1H2(86),G1H2(87),G1H2(88),G1H2(89),G1H2(90),2)
  call HG1shiftOLR(G1H2(86),16,2)
  call Hotf_5pt_reduction(G2H2(16),RedSet_5(4),mass5set(:,1),  & 
G1H2(91),G1H2(92),G1H2(93),G1H2(94),G1H2(95),G1H2(96),2)
  call HG1shiftOLR(G1H2(92),16,2)
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(4),mass5set(:,2),  & 
G1H2(97),G1H2(98),G1H2(99),G1H2(100),G1H2(101),G1H2(102),2)
  call HG1shiftOLR(G1H2(98),16,2)
  call Hotf_5pt_reduction(G2H2(18),RedSet_5(4),mass5set(:,2),  & 
G1H2(103),G1H2(104),G1H2(105),G1H2(106),G1H2(107),G1H2(108),2)
  call HG1shiftOLR(G1H2(104),16,2)
  call Hotf_5pt_reduction(G2H2(19),RedSet_5(5),mass5set(:,1),  & 
G1H2(109),G1H2(110),G1H2(111),G1H2(112),G1H2(113),G1H2(114),2)
  call HG1shiftOLR(G1H2(110),16,2)
  call Hotf_5pt_reduction(G2H2(20),RedSet_5(5),mass5set(:,2),  & 
G1H2(115),G1H2(116),G1H2(117),G1H2(118),G1H2(119),G1H2(120),2)
  call HG1shiftOLR(G1H2(116),16,2)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(5),mass5set(:,4),  & 
G1H2(121),G1H2(122),G1H2(123),G1H2(124),G1H2(125),G1H2(126),2)
  call HG1shiftOLR(G1H2(122),16,2)
  call Hotf_5pt_reduction(G2H2(22),RedSet_5(5),mass5set(:,3),  & 
G1H2(127),G1H2(128),G1H2(129),G1H2(130),G1H2(131),G1H2(132),2)
  call HG1shiftOLR(G1H2(128),16,2)
  call Hotf_5pt_reduction(G2H2(23),RedSet_5(6),mass5set(:,1),  & 
G1H2(133),G1H2(134),G1H2(135),G1H2(136),G1H2(137),G1H2(138),2)
  call HG1shiftOLR(G1H2(134),16,2)
  call Hotf_5pt_reduction(G2H2(24),RedSet_5(6),mass5set(:,2),  & 
G1H2(139),G1H2(140),G1H2(141),G1H2(142),G1H2(143),G1H2(144),2)
  call HG1shiftOLR(G1H2(140),16,2)
  call Hotf_5pt_reduction(G2H2(25),RedSet_5(6),mass5set(:,4),  & 
G1H2(145),G1H2(146),G1H2(147),G1H2(148),G1H2(149),G1H2(150),2)
  call HG1shiftOLR(G1H2(146),16,2)
  call Hotf_5pt_reduction(G2H2(26),RedSet_5(6),mass5set(:,3),  & 
G1H2(151),G1H2(152),G1H2(153),G1H2(154),G1H2(155),G1H2(156),2)
  call HG1shiftOLR(G1H2(152),16,2)
  call Hotf_5pt_reduction(G2H2(27),RedSet_5(7),mass5set(:,2),  & 
G1H2(157),G1H2(158),G1H2(159),G1H2(160),G1H2(161),G1H2(162),2)
  call HG1shiftOLR(G1H2(158),16,2)
  call Hotf_5pt_reduction(G2H2(28),RedSet_5(7),mass5set(:,2),  & 
G1H2(163),G1H2(164),G1H2(165),G1H2(166),G1H2(167),G1H2(168),2)
  call HG1shiftOLR(G1H2(164),16,2)
  call Hotf_5pt_reduction(G2H2(29),RedSet_5(8),mass5set(:,2),  & 
G1H2(169),G1H2(170),G1H2(171),G1H2(172),G1H2(173),G1H2(174),2)
  call HG1shiftOLR(G1H2(170),16,2)
  call Hotf_5pt_reduction(G2H2(30),RedSet_5(8),mass5set(:,2),  & 
G1H2(175),G1H2(176),G1H2(177),G1H2(178),G1H2(179),G1H2(180),2)
  call HG1shiftOLR(G1H2(176),16,2)
  call Hloop_VQ_A(ntryL,G1H2(1),ex5(:),G1H1(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(1),n2h1(1))
  call Hloop_VQ_A(ntryL,G1H2(2),ex5(:),G1H1(1),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(2),n2h1(2))
  call Hloop_VQ_A(ntryL,G1H2(7),ex5(:),G1H1(1),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(3),n2h1(3))
  call Hloop_VQ_A(ntryL,G1H2(8),ex5(:),G1H1(1),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(4),n2h1(4))
  call Hloop_ZQ_A(ntryL,G1H2(13),ex5(:),G1H1(1),ngZd,m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(5),n2h1(5))
  call Hloop_ZQ_A(ntryL,G1H2(14),ex5(:),G1H1(1),ngZd,m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(6),n2h1(6))
  call Hloop_ZQ_A(ntryL,G1H2(19),ex5(:),G1H1(1),ngZd,m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(7),n2h1(7))
  call Hloop_ZQ_A(ntryL,G1H2(20),ex5(:),G1H1(1),ngZd,m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(8),n2h1(8))
  call Hloop_WQ_A(ntryL,G1H2(25),ex5(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(9),n2h1(9))
  call Hloop_WQ_A(ntryL,G1H2(26),ex5(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(10),n2h1(10))
  call Hloop_VQ_A(ntryL,G1H2(31),ex5(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(11))
  call Hloop_VQ_A(ntryL,G1H2(32),ex5(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(12),n2h1(12))
  call Hloop_ZQ_A(ntryL,G1H2(37),ex5(:),G1H1(1),ngZd,m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(13))
  call Hloop_ZQ_A(ntryL,G1H2(38),ex5(:),G1H1(1),ngZd,m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(14),n2h1(14))
  call Hloop_VQ_A(ntryL,G1H2(43),ex5(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(15))
  call Hloop_VQ_A(ntryL,G1H2(44),ex5(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(16),n2h1(16))
  call Hloop_ZQ_A(ntryL,G1H2(49),ex5(:),G1H1(1),ngZd,m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(17),n2h1(17))
  call Hloop_ZQ_A(ntryL,G1H2(50),ex5(:),G1H1(1),ngZd,m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(18),n2h1(18))
  call Hloop_VQ_A(ntryL,G1H2(55),ex5(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(19),n2h1(19))
  call Hloop_VQ_A(ntryL,G1H2(56),ex5(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(20),n2h1(20))
  call Hloop_VQ_A(ntryL,G1H2(61),ex5(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(21),n2h1(21))
  call Hloop_VQ_A(ntryL,G1H2(62),ex5(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(22),n2h1(22))
  call Hloop_ZQ_A(ntryL,G1H2(67),ex5(:),G1H1(1),ngZd,m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(23),n2h1(23))
  call Hloop_ZQ_A(ntryL,G1H2(68),ex5(:),G1H1(1),ngZd,m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(24),n2h1(24))
  call Hloop_ZQ_A(ntryL,G1H2(73),ex5(:),G1H1(1),ngZd,m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(25),n2h1(25))
  call Hloop_ZQ_A(ntryL,G1H2(74),ex5(:),G1H1(1),ngZd,m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(26),n2h1(26))
  call Hloop_WQ_A(ntryL,G1H2(79),ex5(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(27),n2h1(27))
  call Hloop_WQ_A(ntryL,G1H2(80),ex5(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(28),n2h1(28))
  call Hloop_VQ_A(ntryL,G1H2(85),ex5(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(29),n2h1(29))
  call Hloop_VQ_A(ntryL,G1H2(86),ex5(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(30),n2h1(30))
  call Hloop_ZQ_A(ntryL,G1H2(91),ex5(:),G1H1(1),ngZd,m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(31),n2h1(31))
  call Hloop_ZQ_A(ntryL,G1H2(92),ex5(:),G1H1(1),ngZd,m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(32),n2h1(32))
  call Hloop_VQ_A(ntryL,G1H2(97),ex5(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(33),n2h1(33))
  call Hloop_VQ_A(ntryL,G1H2(98),ex5(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(34),n2h1(34))
  call Hloop_ZQ_A(ntryL,G1H2(103),ex5(:),G1H1(1),ngZd,m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(35),n2h1(35))
  call Hloop_ZQ_A(ntryL,G1H2(104),ex5(:),G1H1(1),ngZd,m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(36),n2h1(36))
  call Hloop_ZQ_A(ntryL,G1H2(109),ex5(:),G1H1(1),ngZd,m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(37),n2h1(37))
  call Hloop_ZQ_A(ntryL,G1H2(110),ex5(:),G1H1(1),ngZd,m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(38),n2h1(38))
  call Hloop_ZQ_A(ntryL,G1H2(115),ex5(:),G1H1(1),ngZd,m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(39),n2h1(39))
  call Hloop_ZQ_A(ntryL,G1H2(116),ex5(:),G1H1(1),ngZd,m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(40),n2h1(40))
  call Hloop_WQ_A(ntryL,G1H2(121),ex5(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(41),n2h1(41))
  call Hloop_WQ_A(ntryL,G1H2(122),ex5(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(42),n2h1(42))
  call Hloop_WQ_A(ntryL,G1H2(127),ex5(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(43),n2h1(43))
  call Hloop_WQ_A(ntryL,G1H2(128),ex5(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(44),n2h1(44))
  call Hloop_ZQ_A(ntryL,G1H2(133),ex5(:),G1H1(1),ngZd,m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(45),n2h1(45))
  call Hloop_ZQ_A(ntryL,G1H2(134),ex5(:),G1H1(1),ngZd,m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(46),n2h1(46))
  call Hloop_ZQ_A(ntryL,G1H2(139),ex5(:),G1H1(1),ngZd,m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(47),n2h1(47))
  call Hloop_ZQ_A(ntryL,G1H2(140),ex5(:),G1H1(1),ngZd,m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(48),n2h1(48))
  call Hloop_WQ_A(ntryL,G1H2(145),ex5(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(49),n2h1(49))
  call Hloop_WQ_A(ntryL,G1H2(146),ex5(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(50),n2h1(50))
  call Hloop_WQ_A(ntryL,G1H2(151),ex5(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(51),n2h1(51))
  call Hloop_WQ_A(ntryL,G1H2(152),ex5(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(52),n2h1(52))
  call Hloop_VQ_A(ntryL,G1H2(157),ex5(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(53),n2h1(53))
  call Hloop_VQ_A(ntryL,G1H2(158),ex5(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(54),n2h1(54))
  call Hloop_ZQ_A(ntryL,G1H2(163),ex5(:),G1H1(1),ngZd,m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(55),n2h1(55))
  call Hloop_ZQ_A(ntryL,G1H2(164),ex5(:),G1H1(1),ngZd,m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(56),n2h1(56))
  call Hloop_VQ_A(ntryL,G1H2(169),ex5(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(57),n2h1(57))
  call Hloop_VQ_A(ntryL,G1H2(170),ex5(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(58),n2h1(58))
  call Hloop_ZQ_A(ntryL,G1H2(175),ex5(:),G1H1(1),ngZd,m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(59),n2h1(59))
  call Hloop_ZQ_A(ntryL,G1H2(176),ex5(:),G1H1(1),ngZd,m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(60),n2h1(60))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),16)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(1),mass5set(:,2),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),16)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(1),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),16)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(1),mass5set(:,2),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),16)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(1),mass5set(:,3),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),16)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(2),mass5set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),16)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(2),mass5set(:,1),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),16)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(2),mass5set(:,2),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),16)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(2),mass5set(:,2),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),16)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(3),mass5set(:,1),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),16)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(3),mass5set(:,2),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),16)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(3),mass5set(:,1),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),16)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(3),mass5set(:,2),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),16)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(3),mass5set(:,3),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),16)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(4),mass5set(:,1),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),16)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(4),mass5set(:,1),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),16)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(4),mass5set(:,2),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),16)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(4),mass5set(:,2),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),16)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(5),mass5set(:,1),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),16)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(5),mass5set(:,2),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),16)
  call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(5),mass5set(:,4),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),16)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(5),mass5set(:,3),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),16)
  call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(6),mass5set(:,1),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),16)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(6),mass5set(:,2),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),16)
  call Hotf_5pt_reduction_last(G2tensor(49),RedSet_5(6),mass5set(:,4),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),16)
  call Hotf_5pt_reduction_last(G2tensor(51),RedSet_5(6),mass5set(:,3),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),16)
  call Hotf_5pt_reduction_last(G2tensor(53),RedSet_5(7),mass5set(:,2),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),16)
  call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(7),mass5set(:,2),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),16)
  call Hotf_5pt_reduction_last(G2tensor(57),RedSet_5(8),mass5set(:,2),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),16)
  call Hotf_5pt_reduction_last(G2tensor(59),RedSet_5(8),mass5set(:,2),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),16)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  call ol_merge_tensors(T1sum(21),[G1tensor(121)])
  call ol_merge_tensors(T1sum(22),[G1tensor(127)])
  call ol_merge_tensors(T1sum(23),[G1tensor(133)])
  call ol_merge_tensors(T1sum(24),[G1tensor(139)])
  call ol_merge_tensors(T1sum(25),[G1tensor(145)])
  call ol_merge_tensors(T1sum(26),[G1tensor(151)])
  call ol_merge_tensors(T1sum(27),[G1tensor(157)])
  call ol_merge_tensors(T1sum(28),[G1tensor(163)])
  call ol_merge_tensors(T1sum(29),[G1tensor(169)])
  call ol_merge_tensors(T1sum(30),[G1tensor(175)])
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[32,3,16,4,8],[0,0,0,0,nMW],5,1,wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,31),heltab2x64(:,:,31))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(1),n2h32(1))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[32,3,16,4,8],[0,0,nMZ,0,nMW],5,1,wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,32),heltab2x64(:,:,32))
  call Hloop_A_Q(ntryL,G0H32(2),32,0,G1H32(2),n2h32(2))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[32,3,8,4,16],[0,nMW,0,0,0],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,33),heltab2x64(:,:,33))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(34),h0tab(:,34),[32,3,8,4,16],[nMZ,nMW,0,0,0],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(4),ngZd,m3h2x32(:,34),heltab2x64(:,:,34))
  Gcoeff(:)%j = (c(63)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(35),h0tab(:,35),[32,3,8,4,16],[0,nMW,0,nMZ,0],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,35),heltab2x64(:,:,35))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(36),h0tab(:,36),[32,3,8,4,16],[nMZ,nMW,0,nMZ,0],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(6),ngZd,m3h2x32(:,36),heltab2x64(:,:,36))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(37),h0tab(:,37),[32,3,16,8,4],[0,0,0,0,nMW],5,1,wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,37),heltab2x64(:,:,37))
  call Hloop_A_Q(ntryL,G0H32(7),32,0,G1H32(3),n2h32(3))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(38),h0tab(:,38),[32,3,16,8,4],[0,0,nMZ,0,nMW],5,1,wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,38),heltab2x64(:,:,38))
  call Hloop_A_Q(ntryL,G0H32(8),32,0,G1H32(4),n2h32(4))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(39),h0tab(:,39),[32,4,8,3,16],[0,0,nMW,0,0],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,39),heltab2x64(:,:,39))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(40),h0tab(:,40),[32,4,8,3,16],[0,0,nMW,nMZ,0],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,40),heltab2x64(:,:,40))
  Gcoeff(:)%j = (c(63)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(41),h0tab(:,41),[32,4,8,3,16],[nMZ,0,nMW,0,0],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(11),ngZd,m3h2x32(:,41),heltab2x64(:,:,41))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(42),h0tab(:,42),[32,4,8,3,16],[nMZ,0,nMW,nMZ,0],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(12),ngZd,m3h2x32(:,42),heltab2x64(:,:,42))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(43),h0tab(:,43),[32,4,8,3,16],[nMW,0,0,nMW,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(13),m3h2x32(:,43),heltab2x64(:,:,43))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(44),h0tab(:,44),[32,4,8,3,16],[nMW,0,nMZ,nMW,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(14),m3h2x32(:,44),heltab2x64(:,:,44))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(45),h0tab(:,45),[32,3,4,8,16],[0,nMW,0,0,0],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(15),m3h2x32(:,45),heltab2x64(:,:,45))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(46),h0tab(:,46),[32,3,4,8,16],[nMZ,nMW,0,0,0],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(16),ngZd,m3h2x32(:,46),heltab2x64(:,:,46))
  Gcoeff(:)%j = (c(63)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(47),h0tab(:,47),[32,3,4,8,16],[0,nMW,0,nMZ,0],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,47),heltab2x64(:,:,47))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(48),h0tab(:,48),[32,3,4,8,16],[nMZ,nMW,0,nMZ,0],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(18),ngZd,m3h2x32(:,48),heltab2x64(:,:,48))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(49),h0tab(:,49),[32,8,4,3,16],[0,0,nMW,0,0],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(19),m3h2x32(:,49),heltab2x64(:,:,49))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(50),h0tab(:,50),[32,8,4,3,16],[0,0,nMW,nMZ,0],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(20),m3h2x32(:,50),heltab2x64(:,:,50))
  Gcoeff(:)%j = (c(63)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(51),h0tab(:,51),[32,8,4,3,16],[nMZ,0,nMW,0,0],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(21),ngZd,m3h2x32(:,51),heltab2x64(:,:,51))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(52),h0tab(:,52),[32,8,4,3,16],[nMZ,0,nMW,nMZ,0],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(22),ngZd,m3h2x32(:,52),heltab2x64(:,:,52))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(53),h0tab(:,53),[32,8,4,3,16],[nMW,0,0,nMW,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(23),m3h2x32(:,53),heltab2x64(:,:,53))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(54),h0tab(:,54),[32,8,4,3,16],[nMW,0,nMZ,nMW,0],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(24),m3h2x32(:,54),heltab2x64(:,:,54))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(55),h0tab(:,55),[32,8,3,4,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,55),heltab2x64(:,:,55))
  Gcoeff(:)%j = (c(62)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(56),h0tab(:,56),[32,8,3,4,16],[nMZ,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(26),ngZd,m3h2x32(:,56),heltab2x64(:,:,56))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(57),h0tab(:,57),[32,8,3,4,16],[0,0,0,nMZ,0],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(27),m3h2x32(:,57),heltab2x64(:,:,57))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(58),h0tab(:,58),[32,8,3,4,16],[nMZ,0,0,nMZ,0],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(28),ngZd,m3h2x32(:,58),heltab2x64(:,:,58))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(59),h0tab(:,59),[32,4,3,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(29),m3h2x32(:,59),heltab2x64(:,:,59))
  Gcoeff(:)%j = (c(62)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(60),h0tab(:,60),[32,4,3,8,16],[0,0,0,nMZ,0],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(30),m3h2x32(:,60),heltab2x64(:,:,60))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(61),h0tab(:,61),[32,4,3,8,16],[nMZ,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(1),ngZd,m3h2x32(:,61),heltab2x64(:,:,61))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(62),h0tab(:,62),[32,4,3,8,16],[nMZ,0,0,nMZ,0],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(2),ngZd,m3h2x32(:,62),heltab2x64(:,:,62))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(63),h0tab(:,63),[32,2,1,16,12],[0,0,nMW,0,0],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,63),heltab2x64(:,:,63))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(64),h0tab(:,64),[32,2,1,16,12],[nMZ,0,nMW,0,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(8),ngZd,m3h2x32(:,64),heltab2x64(:,:,64))
  Gcoeff(:)%j = (c(63)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(65),h0tab(:,65),[32,12,2,1,16],[0,nMW,0,nMZ,0],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(31),m3h2x32(:,65),heltab2x64(:,:,65))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(66),h0tab(:,66),[32,12,2,1,16],[nMZ,nMW,0,nMZ,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(32),ngZd,m3h2x32(:,66),heltab2x64(:,:,66))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(67),h0tab(:,67),[32,12,2,1,16],[nMW,0,0,nMW,0],5,1,wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(33),m3h2x32(:,67),heltab2x64(:,:,67))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(68),h0tab(:,68),[32,12,2,1,16],[nMW,nMZ,0,nMW,0],5,1,wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(34),m3h2x32(:,68),heltab2x64(:,:,68))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(69),h0tab(:,69),[32,1,2,16,12],[nMZ,0,nMW,0,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(35),ngZd,m3h2x32(:,69),heltab2x64(:,:,69))
  Gcoeff(:)%j = (c(63)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(70),h0tab(:,70),[32,1,2,12,16],[nMZ,0,nMW,0,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(36),ngZd,m3h2x32(:,70),heltab2x64(:,:,70))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(71),h0tab(:,71),[32,1,2,12,16],[nMZ,0,nMW,nMZ,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(37),ngZd,m3h2x32(:,71),heltab2x64(:,:,71))
  Gcoeff(:)%j = (c(60)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(72),h0tab(:,72),[32,12,1,2,16],[0,nMW,0,0,0],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(38),m3h2x32(:,72),heltab2x64(:,:,72))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(73),h0tab(:,73),[32,12,1,2,16],[nMZ,nMW,0,0,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(39),ngZd,m3h2x32(:,73),heltab2x64(:,:,73))
  Gcoeff(:)%j = (c(63)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(74),h0tab(:,74),[32,12,1,2,16],[0,nMW,0,nMZ,0],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(40),m3h2x32(:,74),heltab2x64(:,:,74))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(75),h0tab(:,75),[32,12,1,2,16],[nMZ,nMW,0,nMZ,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(41),ngZd,m3h2x32(:,75),heltab2x64(:,:,75))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(76),h0tab(:,76),[32,12,1,2,16],[nMW,nMZ,0,nMW,0],5,1,wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(42),m3h2x32(:,76),heltab2x64(:,:,76))
  Gcoeff(:)%j = (c(60)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(77),h0tab(:,77),[32,2,1,12,16],[0,0,nMW,0,0],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(43),m3h2x32(:,77),heltab2x64(:,:,77))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(78),h0tab(:,78),[32,2,1,12,16],[0,0,nMW,nMZ,0],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(44),m3h2x32(:,78),heltab2x64(:,:,78))
  Gcoeff(:)%j = (c(63)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(79),h0tab(:,79),[32,2,1,12,16],[nMZ,0,nMW,0,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(45),ngZd,m3h2x32(:,79),heltab2x64(:,:,79))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(80),h0tab(:,80),[32,2,1,12,16],[nMZ,0,nMW,nMZ,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(46),ngZd,m3h2x32(:,80),heltab2x64(:,:,80))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(81),h0tab(:,81),[32,2,12,1,16],[0,0,0,nMZ,0],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(47),m3h2x32(:,81),heltab2x64(:,:,81))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(82),h0tab(:,82),[32,2,12,1,16],[nMZ,0,0,nMZ,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(48),ngZd,m3h2x32(:,82),heltab2x64(:,:,82))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(83),h0tab(:,83),[32,1,12,2,16],[nMZ,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(49),ngZd,m3h2x32(:,83),heltab2x64(:,:,83))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(84),h0tab(:,84),[32,1,12,2,16],[nMZ,0,0,nMZ,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(50),ngZd,m3h2x32(:,84),heltab2x64(:,:,84))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(85),h0tab(:,85),[48,4,1,2,8],[0,nMW,0,0,0],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,1),heltab2x64(:,:,85))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(1),n2h16(31))
  Gcoeff(:)%j = (c(62)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(86),h0tab(:,86),[48,4,1,2,8],[0,nMZ,0,nMW,0],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,2),heltab2x64(:,:,86))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(2),n2h16(32))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(87),h0tab(:,87),[48,4,1,2,8],[0,nMW,0,nMZ,0],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,3),heltab2x64(:,:,87))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(3),n2h16(33))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(88),h0tab(:,88),[48,4,1,2,8],[0,nMW,0,0,0],5,1,wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),ngZd,m3h4x16(:,4),heltab2x64(:,:,88))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(4),n2h16(34))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(89),h0tab(:,89),[48,4,1,2,8],[0,nMZ,0,nMW,0],5,1,wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),ngZu,m3h4x16(:,5),heltab2x64(:,:,89))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(5),n2h16(35))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(90),h0tab(:,90),[48,4,1,2,8],[0,nMW,0,nMZ,0],5,1,wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),ngZd,m3h4x16(:,6),heltab2x64(:,:,90))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(6),n2h16(36))
  Gcoeff(:)%j = (c(63)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(91),h0tab(:,91),[48,2,1,4,8],[nMW,0,nMZ,0,nMW],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(7),m3h4x16(:,7),heltab2x64(:,:,91))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(92),h0tab(:,92),[48,2,1,4,8],[nMW,0,nMZ,0,nMW],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),48,G1H16(8),m3h4x16(:,8),heltab2x64(:,:,92))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(93),h0tab(:,93),[48,4,2,1,8],[0,0,0,nMW,0],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,9),heltab2x64(:,:,93))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(9),n2h16(37))
  Gcoeff(:)%j = (c(62)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(94),h0tab(:,94),[48,4,2,1,8],[0,nMZ,0,nMW,0],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,10),heltab2x64(:,:,94))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(10),n2h16(38))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(95),h0tab(:,95),[48,4,2,1,8],[0,nMW,0,nMZ,0],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,11),heltab2x64(:,:,95))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(11),n2h16(39))
  Gcoeff(:)%j = (c(65)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(96),h0tab(:,96),[48,4,2,1,8],[0,0,0,nMW,0],5,1,wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),ngZu,m3h4x16(:,12),heltab2x64(:,:,96))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(12),n2h16(40))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(97),h0tab(:,97),[48,4,2,1,8],[0,nMZ,0,nMW,0],5,1,wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),ngZu,m3h4x16(:,13),heltab2x64(:,:,97))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(13),n2h16(41))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(98),h0tab(:,98),[48,4,2,1,8],[0,nMW,0,nMZ,0],5,1,wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),ngZd,m3h4x16(:,14),heltab2x64(:,:,98))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(14),n2h16(42))
  Gcoeff(:)%j = (c(63)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(99),h0tab(:,99),[48,2,1,8,4],[nMW,0,nMZ,0,nMW],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(15),m3h4x16(:,15),heltab2x64(:,:,99))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(100),h0tab(:,100),[48,2,1,8,4],[nMW,0,nMZ,0,nMW],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),48,G1H16(16),m3h4x16(:,16),heltab2x64(:,:,100))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(101),h0tab(:,101),[48,1,2,4,8],[nMW,0,0,0,nMW],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(17),m3h4x16(:,17),heltab2x64(:,:,101))
  Gcoeff(:)%j = (c(63)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(102),h0tab(:,102),[48,1,2,4,8],[nMW,0,nMZ,0,nMW],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(18),m3h4x16(:,18),heltab2x64(:,:,102))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(103),h0tab(:,103),[48,1,2,4,8],[nMW,0,0,0,nMW],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),48,G1H16(19),m3h4x16(:,19),heltab2x64(:,:,103))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(104),h0tab(:,104),[48,1,2,4,8],[nMW,0,nMZ,0,nMW],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),48,G1H16(20),m3h4x16(:,20),heltab2x64(:,:,104))
  Gcoeff(:)%j = (c(60)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(105),h0tab(:,105),[48,1,2,8,4],[nMW,0,0,0,nMW],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(21),m3h4x16(:,21),heltab2x64(:,:,105))
  Gcoeff(:)%j = (c(63)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(106),h0tab(:,106),[48,1,2,8,4],[nMW,0,nMZ,0,nMW],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(22),m3h4x16(:,22),heltab2x64(:,:,106))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(107),h0tab(:,107),[48,1,2,8,4],[nMW,0,0,0,nMW],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),48,G1H16(23),m3h4x16(:,23),heltab2x64(:,:,107))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(108),h0tab(:,108),[48,1,2,8,4],[nMW,0,nMZ,0,nMW],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),48,G1H16(24),m3h4x16(:,24),heltab2x64(:,:,108))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(109),h0tab(:,109),[48,1,4,8,2],[0,nMW,0,0,0],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,25),heltab2x64(:,:,109))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(25),n2h16(43))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(110),h0tab(:,110),[48,1,4,8,2],[0,nMW,0,nMZ,0],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,26),heltab2x64(:,:,110))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(26),n2h16(44))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(111),h0tab(:,111),[48,1,4,8,2],[0,nMW,0,0,0],5,1,wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),ngZl,m3h4x16(:,27),heltab2x64(:,:,111))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(27),n2h16(45))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(112),h0tab(:,112),[48,1,4,8,2],[0,nMZ,0,nMW,0],5,1,wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),ngZn,m3h4x16(:,28),heltab2x64(:,:,112))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(28),n2h16(46))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(113),h0tab(:,113),[48,1,4,8,2],[0,nMW,0,nMZ,0],5,1,wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),ngZl,m3h4x16(:,29),heltab2x64(:,:,113))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(29),n2h16(47))
  Gcoeff(:)%j = (c(62)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(114),h0tab(:,114),[48,1,8,4,2],[0,nMW,0,0,0],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,30),heltab2x64(:,:,114))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(30),n2h16(48))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(115),h0tab(:,115),[48,1,8,4,2],[0,nMW,0,nMZ,0],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,31),heltab2x64(:,:,115))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(31),n2h16(49))
  Gcoeff(:)%j = (c(65)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(116),h0tab(:,116),[48,1,8,4,2],[0,nMW,0,0,0],5,1,wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),ngZl,m3h4x16(:,32),heltab2x64(:,:,116))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(32),n2h16(50))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(117),h0tab(:,117),[48,1,8,4,2],[0,nMW,0,nMZ,0],5,1,wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),ngZl,m3h4x16(:,33),heltab2x64(:,:,117))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(33),n2h16(51))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(118),h0tab(:,118),[48,1,8,4,2],[0,nMZ,0,nMW,0],5,1,wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),ngZn,m3h4x16(:,34),heltab2x64(:,:,118))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(34),n2h16(52))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(4),[G1H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(5),[G1H16(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(6),[G1H16(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(8),[G1H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(12),[G1H16(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(13),[G1H16(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(14),[G1H16(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(16),[G1H16(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(19),[G1H16(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(20),[G1H16(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(23),[G1H16(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(24),[G1H16(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(27),[G1H16(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(29),[G1H16(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(32),[G1H16(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(33),[G1H16(31)])
  call Hloop_AW_Q(ntryL,G1H32(1),wf4(:,1),G1H8(1),m3h4x8(:,1),heltab2x32(:,:,31))
  call Hloop_A_Q(ntryL,G1H8(1),35,0,G2H8(1),n2h8(1))
  call Hloop_AW_Q(ntryL,G1H32(2),wf4(:,1),G1H8(2),m3h4x8(:,2),heltab2x32(:,:,32))
  call Hloop_A_Q(ntryL,G1H8(2),35,0,G2H8(2),n2h8(2))
  call Hloop_UV_W(ntryL,G0H32(3),32,wf4(:,1),3,G1H8(3),m3h4x8(:,3),heltab2x32(:,:,33))
  call Hloop_UV_W(ntryL,G0H32(4),32,wf4(:,1),3,G1H8(4),m3h4x8(:,4),heltab2x32(:,:,34))
  call Hloop_UV_W(ntryL,G0H32(5),32,wf4(:,1),3,G1H8(5),m3h4x8(:,5),heltab2x32(:,:,35))
  call Hloop_UV_W(ntryL,G0H32(6),32,wf4(:,1),3,G1H8(6),m3h4x8(:,6),heltab2x32(:,:,36))
  call Hloop_AW_Q(ntryL,G1H32(3),wf4(:,1),G1H8(7),m3h4x8(:,7),heltab2x32(:,:,37))
  call Hloop_A_Q(ntryL,G1H8(7),35,0,G2H8(3),n2h8(3))
  call Hloop_AW_Q(ntryL,G1H32(4),wf4(:,1),G1H8(8),m3h4x8(:,8),heltab2x32(:,:,38))
  call Hloop_A_Q(ntryL,G1H8(8),35,0,G2H8(4),n2h8(4))
  call Hloop_VA_Q(ntryL,G0H32(9),ex3(:),G0H16(1),m3h2x16(:,31),heltab2x32(:,:,39))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(1),n2h16(53))
  call Hloop_VA_Q(ntryL,G0H32(10),ex3(:),G0H16(1),m3h2x16(:,32),heltab2x32(:,:,40))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(2),n2h16(54))
  call Hloop_ZA_Q(ntryL,G0H32(11),ex3(:),G0H16(1),ngZu,m3h2x16(:,33),heltab2x32(:,:,41))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(3),n2h16(55))
  call Hloop_ZA_Q(ntryL,G0H32(12),ex3(:),G0H16(1),ngZu,m3h2x16(:,34),heltab2x32(:,:,42))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(7),n2h16(56))
  call Hloop_WA_Q(ntryL,G0H32(13),ex3(:),G0H16(1),m3h2x16(:,35),heltab2x32(:,:,43))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(9),n2h16(57))
  call Hloop_WA_Q(ntryL,G0H32(14),ex3(:),G0H16(1),m3h2x16(:,36),heltab2x32(:,:,44))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(10),n2h16(58))
  call Hloop_UV_W(ntryL,G0H32(15),32,wf4(:,1),3,G1H8(9),m3h4x8(:,9),heltab2x32(:,:,45))
  call Hloop_UV_W(ntryL,G0H32(16),32,wf4(:,1),3,G1H8(10),m3h4x8(:,10),heltab2x32(:,:,46))
  call Hloop_UV_W(ntryL,G0H32(17),32,wf4(:,1),3,G1H8(11),m3h4x8(:,11),heltab2x32(:,:,47))
  call Hloop_UV_W(ntryL,G0H32(18),32,wf4(:,1),3,G1H8(12),m3h4x8(:,12),heltab2x32(:,:,48))
  call Hloop_VQ_A(ntryL,G0H32(19),ex4(:),G0H16(1),m3h2x16(:,37),heltab2x32(:,:,49))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(11),n2h16(59))
  call Hloop_VQ_A(ntryL,G0H32(20),ex4(:),G0H16(1),m3h2x16(:,38),heltab2x32(:,:,50))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(15),n2h16(60))
  call Hloop_ZQ_A(ntryL,G0H32(21),ex4(:),G0H16(1),ngZd,m3h2x16(:,39),heltab2x32(:,:,51))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(17),n2h16(61))
  call Hloop_ZQ_A(ntryL,G0H32(22),ex4(:),G0H16(1),ngZd,m3h2x16(:,40),heltab2x32(:,:,52))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(18),n2h16(62))
  call Hloop_WQ_A(ntryL,G0H32(23),ex4(:),G0H16(1),m3h2x16(:,41),heltab2x32(:,:,53))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(21),n2h16(63))
  call Hloop_WQ_A(ntryL,G0H32(24),ex4(:),G0H16(1),m3h2x16(:,42),heltab2x32(:,:,54))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(22),n2h16(64))
  call Hloop_VQ_A(ntryL,G0H32(25),ex4(:),G0H16(1),m3h2x16(:,43),heltab2x32(:,:,55))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(25),n2h16(65))
  call Hloop_ZQ_A(ntryL,G0H32(26),ex4(:),G0H16(1),ngZd,m3h2x16(:,44),heltab2x32(:,:,56))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(26),n2h16(66))
  call Hloop_VQ_A(ntryL,G0H32(27),ex4(:),G0H16(1),m3h2x16(:,45),heltab2x32(:,:,57))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(30),n2h16(67))
  call Hloop_ZQ_A(ntryL,G0H32(28),ex4(:),G0H16(1),ngZd,m3h2x16(:,46),heltab2x32(:,:,58))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(31),n2h16(68))
  call Hloop_VA_Q(ntryL,G0H32(29),ex3(:),G0H16(1),m3h2x16(:,47),heltab2x32(:,:,59))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(35),n2h16(69))
  call Hloop_VA_Q(ntryL,G0H32(30),ex3(:),G0H16(1),m3h2x16(:,48),heltab2x32(:,:,60))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(36),n2h16(70))
  call Hloop_ZA_Q(ntryL,G0H32(1),ex3(:),G0H16(1),ngZu,m3h2x16(:,49),heltab2x32(:,:,61))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(37),n2h16(71))
  call Hloop_ZA_Q(ntryL,G0H32(2),ex3(:),G0H16(1),ngZu,m3h2x16(:,50),heltab2x32(:,:,62))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(38),n2h16(72))
  call Hloop_VA_Q(ntryL,G0H32(7),ex2(:),G0H16(1),m3h2x16(:,51),heltab2x32(:,:,63))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(39),n2h16(73))
  call Hloop_ZA_Q(ntryL,G0H32(8),ex2(:),G0H16(1),ngZl,m3h2x16(:,52),heltab2x32(:,:,64))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(40),n2h16(74))
  call Hloop_UW_V(ntryL,G0H32(31),32,wf4(:,2),12,G1H8(13),m3h4x8(:,13),heltab2x32(:,:,65))
  call Hloop_UW_V(ntryL,G0H32(32),32,wf4(:,2),12,G1H8(14),m3h4x8(:,14),heltab2x32(:,:,66))
  call Hloop_UV_W(ntryL,G0H32(33),32,wf4(:,2),12,G1H8(15),m3h4x8(:,15),heltab2x32(:,:,67))
  call Hloop_UV_W(ntryL,G0H32(34),32,wf4(:,2),12,G1H8(16),m3h4x8(:,16),heltab2x32(:,:,68))
  call Hloop_ZQ_A(ntryL,G0H32(35),ex1(:),G0H16(1),ngZn,m3h2x16(:,53),heltab2x32(:,:,69))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(41),n2h16(75))
  call Hloop_ZQ_A(ntryL,G0H32(36),ex1(:),G0H16(1),ngZn,m3h2x16(:,54),heltab2x32(:,:,70))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(42),n2h16(76))
  call Hloop_ZQ_A(ntryL,G0H32(37),ex1(:),G0H16(1),ngZn,m3h2x16(:,55),heltab2x32(:,:,71))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(43),n2h16(77))
  call Hloop_UW_V(ntryL,G0H32(38),32,wf4(:,2),12,G1H8(17),m3h4x8(:,17),heltab2x32(:,:,72))
  call Hloop_UW_V(ntryL,G0H32(39),32,wf4(:,2),12,G1H8(18),m3h4x8(:,18),heltab2x32(:,:,73))
  call Hloop_UW_V(ntryL,G0H32(40),32,wf4(:,2),12,G1H8(19),m3h4x8(:,19),heltab2x32(:,:,74))
  call Hloop_UW_V(ntryL,G0H32(41),32,wf4(:,2),12,G1H8(20),m3h4x8(:,20),heltab2x32(:,:,75))
  call Hloop_UV_W(ntryL,G0H32(42),32,wf4(:,2),12,G1H8(21),m3h4x8(:,21),heltab2x32(:,:,76))
  call Hloop_VA_Q(ntryL,G0H32(43),ex2(:),G0H16(1),m3h2x16(:,56),heltab2x32(:,:,77))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(44),n2h16(78))
  call Hloop_VA_Q(ntryL,G0H32(44),ex2(:),G0H16(1),m3h2x16(:,57),heltab2x32(:,:,78))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(45),n2h16(79))
  call Hloop_ZA_Q(ntryL,G0H32(45),ex2(:),G0H16(1),ngZl,m3h2x16(:,58),heltab2x32(:,:,79))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(46),n2h16(80))
  call Hloop_ZA_Q(ntryL,G0H32(46),ex2(:),G0H16(1),ngZl,m3h2x16(:,59),heltab2x32(:,:,80))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(47),n2h16(81))
  call Hloop_VA_Q(ntryL,G0H32(47),ex2(:),G0H16(1),m3h2x16(:,60),heltab2x32(:,:,81))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(48),n2h16(82))
  call Hloop_ZA_Q(ntryL,G0H32(48),ex2(:),G0H16(1),ngZl,m3h2x16(:,61),heltab2x32(:,:,82))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(49),n2h16(83))
  call Hloop_ZQ_A(ntryL,G0H32(49),ex1(:),G0H16(1),ngZn,m3h2x16(:,62),heltab2x32(:,:,83))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(50),n2h16(84))
  call Hloop_ZQ_A(ntryL,G0H32(50),ex1(:),G0H16(1),ngZn,m3h2x16(:,63),heltab2x32(:,:,84))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(51),n2h16(85))
  call Hloop_QA_W(ntryL,G1H16(4),ex3(:),G1H8(22),m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_QA_Z(ntryL,G1H16(5),ex3(:),G1H8(23),ngZu,m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_QA_W(ntryL,G1H16(6),ex3(:),G1H8(24),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_WA_Q(ntryL,G1H16(8),ex2(:),G1H8(25),m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_A_Q(ntryL,G1H8(25),50,0,G2H8(5),n2h8(5))
  call Hloop_QA_V(ntryL,G1H16(12),ex3(:),G1H8(26),m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_QA_Z(ntryL,G1H16(13),ex3(:),G1H8(27),ngZu,m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_QA_W(ntryL,G1H16(14),ex3(:),G1H8(28),m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_WA_Q(ntryL,G1H16(16),ex2(:),G1H8(29),m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_A_Q(ntryL,G1H8(29),50,0,G2H8(6),n2h8(6))
  call Hloop_WQ_A(ntryL,G1H16(19),ex1(:),G1H8(30),m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_Q_A(ntryL,G1H8(30),49,0,G2H8(7),n2h8(7))
  call Hloop_WQ_A(ntryL,G1H16(20),ex1(:),G1H8(1),m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_Q_A(ntryL,G1H8(1),49,0,G2H8(8),n2h8(8))
  call Hloop_WQ_A(ntryL,G1H16(23),ex1(:),G1H8(2),m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_Q_A(ntryL,G1H8(2),49,0,G2H8(9),n2h8(9))
  call Hloop_WQ_A(ntryL,G1H16(24),ex1(:),G1H8(7),m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_Q_A(ntryL,G1H8(7),49,0,G2H8(10),n2h8(10))
  call Hloop_AQ_W(ntryL,G1H16(27),ex1(:),G1H8(8),m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_AQ_W(ntryL,G1H16(29),ex1(:),G1H8(25),m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_AQ_Z(ntryL,G1H16(28),ex1(:),G1H8(29),ngZn,m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_AQ_W(ntryL,G1H16(32),ex1(:),G1H8(30),m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_AQ_W(ntryL,G1H16(33),ex1(:),G1H8(1),m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_AQ_Z(ntryL,G1H16(34),ex1(:),G1H8(2),ngZn,m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_AQ_V(ntryL,G2H8(1),ex5(:),G2H4(1),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_AQ_Z(ntryL,G2H8(2),ex5(:),G2H4(2),ngZd,m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_WQ_A(ntryL,G1H8(3),ex4(:),G1H4(1),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(3),n2h4(31))
  call Hloop_WQ_A(ntryL,G1H8(4),ex4(:),G1H4(1),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(4),n2h4(32))
  call Hloop_WQ_A(ntryL,G1H8(5),ex4(:),G1H4(1),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(5),n2h4(33))
  call Hloop_WQ_A(ntryL,G1H8(6),ex4(:),G1H4(1),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(6),n2h4(34))
  call Hloop_AQ_V(ntryL,G2H8(3),ex5(:),G2H4(7),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_AQ_Z(ntryL,G2H8(4),ex5(:),G2H4(8),ngZd,m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_AQ_W(ntryL,G1H16(1),ex4(:),G1H8(7),m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_AQ_W(ntryL,G1H16(2),ex4(:),G1H8(3),m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_AQ_W(ntryL,G1H16(3),ex4(:),G1H8(4),m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_AQ_W(ntryL,G1H16(7),ex4(:),G1H8(5),m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_AQ_V(ntryL,G1H16(9),ex4(:),G1H8(6),m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_AQ_Z(ntryL,G1H16(10),ex4(:),G1H8(31),ngZd,m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_WA_Q(ntryL,G1H8(9),ex3(:),G1H4(1),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_A_Q(ntryL,G1H4(1),39,0,G2H4(9),n2h4(35))
  call Hloop_WA_Q(ntryL,G1H8(10),ex3(:),G1H4(1),m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_A_Q(ntryL,G1H4(1),39,0,G2H4(10),n2h4(36))
  call Hloop_WA_Q(ntryL,G1H8(11),ex3(:),G1H4(1),m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_A_Q(ntryL,G1H4(1),39,0,G2H4(11),n2h4(37))
  call Hloop_WA_Q(ntryL,G1H8(12),ex3(:),G1H4(1),m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(1),39,0,G2H4(12),n2h4(38))
  call Hloop_QA_W(ntryL,G1H16(11),ex3(:),G1H8(9),m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_QA_W(ntryL,G1H16(15),ex3(:),G1H8(10),m3h2x8(:,56),heltab2x16(:,:,56))
  call Hloop_QA_W(ntryL,G1H16(17),ex3(:),G1H8(11),m3h2x8(:,57),heltab2x16(:,:,57))
  call Hloop_QA_W(ntryL,G1H16(18),ex3(:),G1H8(12),m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_QA_V(ntryL,G1H16(21),ex3(:),G1H8(32),m3h2x8(:,59),heltab2x16(:,:,59))
  call Hloop_QA_Z(ntryL,G1H16(22),ex3(:),G1H8(33),ngZu,m3h2x8(:,60),heltab2x16(:,:,60))
  call Hloop_QW_A(ntryL,G1H16(25),wf4(:,1),G1H4(1),m3h4x4(:,1),heltab2x16(:,:,61))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(13),n2h4(39))
  call Hloop_QW_A(ntryL,G1H16(26),wf4(:,1),G1H4(1),m3h4x4(:,2),heltab2x16(:,:,62))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(14),n2h4(40))
  call Hloop_QW_A(ntryL,G1H16(30),wf4(:,1),G1H4(1),m3h4x4(:,3),heltab2x16(:,:,63))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(15),n2h4(41))
  call Hloop_QW_A(ntryL,G1H16(31),wf4(:,1),G1H4(1),m3h4x4(:,4),heltab2x16(:,:,64))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(16),n2h4(42))
  call Hloop_AW_Q(ntryL,G1H16(35),wf4(:,1),G1H4(1),m3h4x4(:,5),heltab2x16(:,:,65))
  call Hloop_A_Q(ntryL,G1H4(1),39,0,G2H4(17),n2h4(43))
  call Hloop_AW_Q(ntryL,G1H16(36),wf4(:,1),G1H4(1),m3h4x4(:,6),heltab2x16(:,:,66))
  call Hloop_A_Q(ntryL,G1H4(1),39,0,G2H4(18),n2h4(44))
  call Hloop_AW_Q(ntryL,G1H16(37),wf4(:,1),G1H4(1),m3h4x4(:,7),heltab2x16(:,:,67))
  call Hloop_A_Q(ntryL,G1H4(1),39,0,G2H4(19),n2h4(45))
  call Hloop_AW_Q(ntryL,G1H16(38),wf4(:,1),G1H4(1),m3h4x4(:,8),heltab2x16(:,:,68))
  call Hloop_A_Q(ntryL,G1H4(1),39,0,G2H4(20),n2h4(46))
  call Hloop_AQ_W(ntryL,G1H16(39),ex1(:),G1H8(34),m3h2x8(:,61),heltab2x16(:,:,69))
  call Hloop_AQ_W(ntryL,G1H16(40),ex1(:),G1H8(35),m3h2x8(:,62),heltab2x16(:,:,70))
  call Hloop_WA_Q(ntryL,G1H8(13),ex2(:),G1H4(1),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(21),n2h4(47))
  call Hloop_WA_Q(ntryL,G1H8(14),ex2(:),G1H4(1),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(22),n2h4(48))
  call Hloop_VA_Q(ntryL,G1H8(15),ex2(:),G1H4(1),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(23),n2h4(49))
  call Hloop_ZA_Q(ntryL,G1H8(16),ex2(:),G1H4(1),ngZl,m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(24),n2h4(50))
  call Hloop_QA_W(ntryL,G1H16(41),ex2(:),G1H8(13),m3h2x8(:,63),heltab2x16(:,:,71))
  call Hloop_QA_W(ntryL,G1H16(42),ex2(:),G1H8(14),m3h2x8(:,64),heltab2x16(:,:,72))
  call Hloop_QA_W(ntryL,G1H16(43),ex2(:),G1H8(15),m3h2x8(:,65),heltab2x16(:,:,73))
  call Hloop_WQ_A(ntryL,G1H8(17),ex1(:),G1H4(1),m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(25),n2h4(51))
  call Hloop_WQ_A(ntryL,G1H8(18),ex1(:),G1H4(1),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(26),n2h4(52))
  call Hloop_WQ_A(ntryL,G1H8(19),ex1(:),G1H4(1),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(27),n2h4(53))
  call Hloop_WQ_A(ntryL,G1H8(20),ex1(:),G1H4(1),m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(28),n2h4(54))
  call Hloop_ZQ_A(ntryL,G1H8(21),ex1(:),G1H4(1),ngZn,m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(29),n2h4(55))
  call Hloop_AQ_W(ntryL,G1H16(44),ex1(:),G1H8(16),m3h2x8(:,66),heltab2x16(:,:,74))
  call Hloop_AQ_W(ntryL,G1H16(45),ex1(:),G1H8(17),m3h2x8(:,67),heltab2x16(:,:,75))
  call Hloop_AQ_W(ntryL,G1H16(46),ex1(:),G1H8(18),m3h2x8(:,68),heltab2x16(:,:,76))
  call Hloop_AQ_W(ntryL,G1H16(47),ex1(:),G1H8(19),m3h2x8(:,69),heltab2x16(:,:,77))
  call Hloop_AW_Q(ntryL,G1H16(48),wf4(:,2),G1H4(1),m3h4x4(:,9),heltab2x16(:,:,78))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(30),n2h4(56))
  call Hloop_AW_Q(ntryL,G1H16(49),wf4(:,2),G1H4(1),m3h4x4(:,10),heltab2x16(:,:,79))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(31),n2h4(57))
  call Hloop_QW_A(ntryL,G1H16(50),wf4(:,2),G1H4(1),m3h4x4(:,11),heltab2x16(:,:,80))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(32),n2h4(58))
  call Hloop_QW_A(ntryL,G1H16(51),wf4(:,2),G1H4(1),m3h4x4(:,12),heltab2x16(:,:,81))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(33),n2h4(59))
  call Hloop_WQ_A(ntryL,G1H8(22),ex1(:),G1H4(1),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(34),n2h4(60))
  call Hloop_ZQ_A(ntryL,G1H8(23),ex1(:),G1H4(1),ngZn,m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(35),n2h4(61))
  call Hloop_WQ_A(ntryL,G1H8(24),ex1(:),G1H4(1),m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(36),n2h4(62))
  call Hloop_AQ_Z(ntryL,G2H8(5),ex1(:),G2H4(37),ngZn,m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_VA_Q(ntryL,G1H8(26),ex2(:),G1H4(1),m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(38),n2h4(63))
  call Hloop_ZA_Q(ntryL,G1H8(27),ex2(:),G1H4(1),ngZl,m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(39),n2h4(64))
  call Hloop_WA_Q(ntryL,G1H8(28),ex2(:),G1H4(1),m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(40),n2h4(65))
  call Hloop_AQ_Z(ntryL,G2H8(6),ex1(:),G2H4(41),ngZn,m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_QA_V(ntryL,G2H8(7),ex2(:),G2H4(42),m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_QA_Z(ntryL,G2H8(8),ex2(:),G2H4(43),ngZl,m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_QA_V(ntryL,G2H8(9),ex2(:),G2H4(44),m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_QA_Z(ntryL,G2H8(10),ex2(:),G2H4(45),ngZl,m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_WA_Q(ntryL,G1H8(8),ex3(:),G1H4(1),m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_A_Q(ntryL,G1H4(1),53,0,G2H4(46),n2h4(66))
  call Hloop_WA_Q(ntryL,G1H8(25),ex3(:),G1H4(1),m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_A_Q(ntryL,G1H4(1),53,0,G2H4(47),n2h4(67))
  call Hloop_ZA_Q(ntryL,G1H8(29),ex3(:),G1H4(1),ngZu,m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_A_Q(ntryL,G1H4(1),53,0,G2H4(48),n2h4(68))
  call Hloop_WQ_A(ntryL,G1H8(30),ex4(:),G1H4(1),m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_Q_A(ntryL,G1H4(1),57,0,G2H4(49),n2h4(69))
  call Hloop_WQ_A(ntryL,G1H8(1),ex4(:),G1H4(1),m3h2x4(:,68),heltab2x8(:,:,68))
  call Hloop_Q_A(ntryL,G1H4(1),57,0,G2H4(50),n2h4(70))
  call Hloop_ZQ_A(ntryL,G1H8(2),ex4(:),G1H4(1),ngZd,m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_Q_A(ntryL,G1H4(1),57,0,G2H4(51),n2h4(71))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(9),mass5set(:,5),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),8,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(9),mass5set(:,6),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(8),8,4)
  call Hloop_QA_V(ntryL,G2H4(3),ex3(:),G2H2(1),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_QA_V(ntryL,G2H4(4),ex3(:),G2H2(2),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_QA_Z(ntryL,G2H4(5),ex3(:),G2H2(3),ngZu,m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_QA_Z(ntryL,G2H4(6),ex3(:),G2H2(4),ngZu,m3h2x2(:,34),heltab2x4(:,:,34))
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(10),mass5set(:,5),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(14),4,4)
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(10),mass5set(:,6),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
  call HG1shiftOLR(G1H4(20),4,4)
  call Hloop_UW_V(ntryL,G1H8(7),44,wf4(:,1),3,G2H2(5),m3h4x2(:,1),heltab2x8(:,:,70))
  call Hloop_UW_V(ntryL,G1H8(3),44,wf4(:,1),3,G2H2(6),m3h4x2(:,2),heltab2x8(:,:,71))
  call Hloop_UW_V(ntryL,G1H8(4),44,wf4(:,1),3,G2H2(7),m3h4x2(:,3),heltab2x8(:,:,72))
  call Hloop_UW_V(ntryL,G1H8(5),44,wf4(:,1),3,G2H2(8),m3h4x2(:,4),heltab2x8(:,:,73))
  call Hloop_UV_W(ntryL,G1H8(6),44,wf4(:,1),3,G2H2(9),m3h4x2(:,5),heltab2x8(:,:,74))
  call Hloop_UV_W(ntryL,G1H8(31),44,wf4(:,1),3,G2H2(10),m3h4x2(:,6),heltab2x8(:,:,75))
  call Hloop_AQ_V(ntryL,G2H4(9),ex4(:),G2H2(11),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_AQ_V(ntryL,G2H4(10),ex4(:),G2H2(12),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_AQ_Z(ntryL,G2H4(11),ex4(:),G2H2(13),ngZd,m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_AQ_Z(ntryL,G2H4(12),ex4(:),G2H2(14),ngZd,m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_UW_V(ntryL,G1H8(9),44,wf4(:,1),3,G2H2(15),m3h4x2(:,7),heltab2x8(:,:,76))
  call Hloop_UW_V(ntryL,G1H8(10),44,wf4(:,1),3,G2H2(16),m3h4x2(:,8),heltab2x8(:,:,77))
  call Hloop_UW_V(ntryL,G1H8(11),44,wf4(:,1),3,G2H2(17),m3h4x2(:,9),heltab2x8(:,:,78))
  call Hloop_UW_V(ntryL,G1H8(12),44,wf4(:,1),3,G2H2(18),m3h4x2(:,10),heltab2x8(:,:,79))
  call Hloop_UV_W(ntryL,G1H8(32),44,wf4(:,1),3,G2H2(19),m3h4x2(:,11),heltab2x8(:,:,80))
  call Hloop_UV_W(ntryL,G1H8(33),44,wf4(:,1),3,G2H2(20),m3h4x2(:,12),heltab2x8(:,:,81))
  call Hloop_QA_V(ntryL,G2H4(13),ex3(:),G2H2(21),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_QA_V(ntryL,G2H4(14),ex3(:),G2H2(22),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_QA_Z(ntryL,G2H4(15),ex3(:),G2H2(23),ngZu,m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_QA_Z(ntryL,G2H4(16),ex3(:),G2H2(24),ngZu,m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_AQ_V(ntryL,G2H4(17),ex4(:),G2H2(25),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_AQ_Z(ntryL,G2H4(18),ex4(:),G2H2(26),ngZd,m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_AQ_V(ntryL,G2H4(19),ex4(:),G2H2(27),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_AQ_Z(ntryL,G2H4(20),ex4(:),G2H2(28),ngZd,m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_WQ_A(ntryL,G1H8(34),ex5(:),G1H4(25),m3h2x4(:,70),heltab2x8(:,:,82))
  call Hloop_Q_A(ntryL,G1H4(25),51,0,G2H4(1),n2h4(72))
  call Hloop_WQ_A(ntryL,G1H8(35),ex5(:),G1H4(25),m3h2x4(:,71),heltab2x8(:,:,83))
  call Hloop_Q_A(ntryL,G1H4(25),51,0,G2H4(2),n2h4(73))
  call Hloop_AQ_Z(ntryL,G2H4(21),ex1(:),G2H2(29),ngZn,m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_AQ_Z(ntryL,G2H4(22),ex1(:),G2H2(30),ngZn,m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_AQ_W(ntryL,G2H4(23),ex1(:),G2H2(31),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_AQ_W(ntryL,G2H4(24),ex1(:),G2H2(32),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_WQ_A(ntryL,G1H8(13),ex5(:),G1H4(25),m3h2x4(:,72),heltab2x8(:,:,84))
  call Hloop_Q_A(ntryL,G1H4(25),51,0,G2H4(3),n2h4(74))
  call Hloop_UV_W(ntryL,G1H8(14),35,wf4(:,2),12,G2H2(33),m3h4x2(:,13),heltab2x8(:,:,85))
  call Hloop_UV_W(ntryL,G1H8(15),35,wf4(:,2),12,G2H2(34),m3h4x2(:,14),heltab2x8(:,:,86))
  call Hloop_QA_V(ntryL,G2H4(25),ex2(:),G2H2(35),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_QA_V(ntryL,G2H4(26),ex2(:),G2H2(36),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_QA_Z(ntryL,G2H4(27),ex2(:),G2H2(37),ngZl,m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_QA_Z(ntryL,G2H4(28),ex2(:),G2H2(38),ngZl,m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_QA_W(ntryL,G2H4(29),ex2(:),G2H2(39),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_UV_W(ntryL,G1H8(16),35,wf4(:,2),12,G2H2(40),m3h4x2(:,15),heltab2x8(:,:,87))
  call Hloop_UV_W(ntryL,G1H8(17),35,wf4(:,2),12,G2H2(41),m3h4x2(:,16),heltab2x8(:,:,88))
  call Hloop_UV_W(ntryL,G1H8(18),35,wf4(:,2),12,G2H2(42),m3h4x2(:,17),heltab2x8(:,:,89))
  call Hloop_UV_W(ntryL,G1H8(19),35,wf4(:,2),12,G2H2(43),m3h4x2(:,18),heltab2x8(:,:,90))
  call Hloop_AQ_Z(ntryL,G2H4(30),ex1(:),G2H2(44),ngZn,m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_AQ_Z(ntryL,G2H4(31),ex1(:),G2H2(45),ngZn,m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_QA_V(ntryL,G2H4(32),ex2(:),G2H2(46),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_QA_Z(ntryL,G2H4(33),ex2(:),G2H2(47),ngZl,m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_QA_V(ntryL,G2H4(34),ex2(:),G2H2(48),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_QA_W(ntryL,G2H4(35),ex2(:),G2H2(49),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_QA_Z(ntryL,G2H4(36),ex2(:),G2H2(50),ngZl,m3h2x2(:,62),heltab2x4(:,:,62))
  call Hotf_5pt_reduction(G2H4(37),RedSet_5(11),mass5set(:,7),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
  call HG1shiftOLR(G1H4(26),8,4)
  call Hloop_AQ_W(ntryL,G2H4(38),ex1(:),G2H2(51),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_AQ_W(ntryL,G2H4(39),ex1(:),G2H2(52),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_AQ_Z(ntryL,G2H4(40),ex1(:),G2H2(53),ngZn,m3h2x2(:,65),heltab2x4(:,:,65))
  call Hotf_5pt_reduction(G2H4(41),RedSet_5(12),mass5set(:,7),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
  call HG1shiftOLR(G1H4(32),4,4)
  call Hotf_5pt_reduction(G2H4(42),RedSet_5(13),mass5set(:,8),  & 
G1H4(37),G1H4(38),G1H4(39),G1H4(40),G1H4(41),G1H4(42),4)
  call HG1shiftOLR(G1H4(38),8,4)
  call Hotf_5pt_reduction(G2H4(43),RedSet_5(13),mass5set(:,7),  & 
G1H4(43),G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
  call HG1shiftOLR(G1H4(44),8,4)
  call Hotf_5pt_reduction(G2H4(44),RedSet_5(14),mass5set(:,8),  & 
G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),G1H4(54),4)
  call HG1shiftOLR(G1H4(50),4,4)
  call Hotf_5pt_reduction(G2H4(45),RedSet_5(14),mass5set(:,7),  & 
G1H4(55),G1H4(56),G1H4(57),G1H4(58),G1H4(59),G1H4(60),4)
  call HG1shiftOLR(G1H4(56),4,4)
  call Hloop_AQ_V(ntryL,G2H4(46),ex4(:),G2H2(54),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_AQ_Z(ntryL,G2H4(47),ex4(:),G2H2(55),ngZd,m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_AQ_W(ntryL,G2H4(48),ex4(:),G2H2(56),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_QA_V(ntryL,G2H4(49),ex3(:),G2H2(57),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_QA_Z(ntryL,G2H4(50),ex3(:),G2H2(58),ngZu,m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_QA_W(ntryL,G2H4(51),ex3(:),G2H2(59),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_VA_Q(ntryL,G1H4(1),ex3(:),G1H2(1),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_A_Q(ntryL,G1H2(1),55,0,G2H2(60),n2h2(1))
call HGT_raise_alpha_OLR(G1H4(2),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(2),ex4(:),G1H2(2),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_VA_Q(ntryL,G1H4(5),ex3(:),G1H2(7),m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_A_Q(ntryL,G1H2(7),55,0,G2H2(61),n2h2(2))
  call Hloop_VA_Q(ntryL,G1H4(6),ex3(:),G1H2(8),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_A_Q(ntryL,G1H2(8),55,0,G2H2(62),n2h2(3))
  call Hloop_ZA_Q(ntryL,G1H4(7),ex3(:),G1H2(13),ngZu,m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_A_Q(ntryL,G1H2(13),55,0,G2H2(63),n2h2(4))
call HGT_raise_alpha_OLR(G1H4(8),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(8),ex4(:),G1H2(14),m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_ZA_Q(ntryL,G1H4(11),ex3(:),G1H2(19),ngZu,m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_A_Q(ntryL,G1H2(19),55,0,G2H2(64),n2h2(5))
  call Hloop_ZA_Q(ntryL,G1H4(12),ex3(:),G1H2(20),ngZu,m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_A_Q(ntryL,G1H2(20),55,0,G2H2(65),n2h2(6))
  call Hloop_VQ_A(ntryL,G1H4(13),ex4(:),G1H2(25),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_Q_A(ntryL,G1H2(25),59,0,G2H2(66),n2h2(7))
call HGT_raise_alpha_OLR(G1H4(14),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(14),ex3(:),G1H2(26),m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_VQ_A(ntryL,G1H4(17),ex4(:),G1H2(31),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_Q_A(ntryL,G1H2(31),59,0,G2H2(67),n2h2(8))
  call Hloop_VQ_A(ntryL,G1H4(18),ex4(:),G1H2(32),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_Q_A(ntryL,G1H2(32),59,0,G2H2(68),n2h2(9))
  call Hloop_ZQ_A(ntryL,G1H4(19),ex4(:),G1H2(37),ngZd,m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_Q_A(ntryL,G1H2(37),59,0,G2H2(69),n2h2(10))
call HGT_raise_alpha_OLR(G1H4(20),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(20),ex3(:),G1H2(38),m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_ZQ_A(ntryL,G1H4(23),ex4(:),G1H2(43),ngZd,m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_Q_A(ntryL,G1H2(43),59,0,G2H2(70),n2h2(11))
  call Hloop_ZQ_A(ntryL,G1H4(24),ex4(:),G1H2(44),ngZd,m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_Q_A(ntryL,G1H2(44),59,0,G2H2(71),n2h2(12))
  call Hloop_ZA_Q(ntryL,G1H4(25),ex3(:),G1H2(49),ngZu,m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_A_Q(ntryL,G1H2(49),55,0,G2H2(72),n2h2(13))
call HGT_raise_alpha_OLR(G1H4(26),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(26),ex4(:),G1H2(50),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_ZA_Q(ntryL,G1H4(29),ex3(:),G1H2(55),ngZu,m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_A_Q(ntryL,G1H2(55),55,0,G2H2(73),n2h2(14))
  call Hloop_ZA_Q(ntryL,G1H4(30),ex3(:),G1H2(56),ngZu,m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_A_Q(ntryL,G1H2(56),55,0,G2H2(74),n2h2(15))
  call Hloop_ZQ_A(ntryL,G1H4(31),ex4(:),G1H2(61),ngZd,m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_Q_A(ntryL,G1H2(61),59,0,G2H2(75),n2h2(16))
call HGT_raise_alpha_OLR(G1H4(32),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(32),ex3(:),G1H2(62),m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_ZQ_A(ntryL,G1H4(35),ex4(:),G1H2(67),ngZd,m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_Q_A(ntryL,G1H2(67),59,0,G2H2(76),n2h2(17))
  call Hloop_ZQ_A(ntryL,G1H4(36),ex4(:),G1H2(68),ngZd,m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_Q_A(ntryL,G1H2(68),59,0,G2H2(77),n2h2(18))
  call Hloop_VA_Q(ntryL,G1H4(37),ex3(:),G1H2(73),m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_A_Q(ntryL,G1H2(73),55,0,G2H2(78),n2h2(19))
call HGT_raise_alpha_OLR(G1H4(38),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(38),ex4(:),G1H2(74),m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_VA_Q(ntryL,G1H4(41),ex3(:),G1H2(79),m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_A_Q(ntryL,G1H2(79),55,0,G2H2(79),n2h2(20))
  call Hloop_VA_Q(ntryL,G1H4(42),ex3(:),G1H2(80),m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_A_Q(ntryL,G1H2(80),55,0,G2H2(80),n2h2(21))
  call Hloop_ZA_Q(ntryL,G1H4(43),ex3(:),G1H2(85),ngZu,m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_A_Q(ntryL,G1H2(85),55,0,G2H2(81),n2h2(22))
call HGT_raise_alpha_OLR(G1H4(44),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(44),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(44),ex4(:),G1H2(86),m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_ZA_Q(ntryL,G1H4(47),ex3(:),G1H2(91),ngZu,m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_A_Q(ntryL,G1H2(91),55,0,G2H2(82),n2h2(23))
  call Hloop_ZA_Q(ntryL,G1H4(48),ex3(:),G1H2(92),ngZu,m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_A_Q(ntryL,G1H2(92),55,0,G2H2(83),n2h2(24))
  call Hloop_VQ_A(ntryL,G1H4(49),ex4(:),G1H2(97),m3h2x2(:,104),heltab2x4(:,:,104))
  call Hloop_Q_A(ntryL,G1H2(97),59,0,G2H2(84),n2h2(25))
call HGT_raise_alpha_OLR(G1H4(50),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(50),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(50),ex3(:),G1H2(98),m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_VQ_A(ntryL,G1H4(53),ex4(:),G1H2(103),m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_Q_A(ntryL,G1H2(103),59,0,G2H2(85),n2h2(26))
  call Hloop_VQ_A(ntryL,G1H4(54),ex4(:),G1H2(104),m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_Q_A(ntryL,G1H2(104),59,0,G2H2(86),n2h2(27))
  call Hloop_ZQ_A(ntryL,G1H4(55),ex4(:),G1H2(109),ngZd,m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_Q_A(ntryL,G1H2(109),59,0,G2H2(87),n2h2(28))
call HGT_raise_alpha_OLR(G1H4(56),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(56),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(56),ex3(:),G1H2(110),m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_ZQ_A(ntryL,G1H4(59),ex4(:),G1H2(115),ngZd,m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_Q_A(ntryL,G1H2(115),59,0,G2H2(88),n2h2(29))
  call Hloop_ZQ_A(ntryL,G1H4(60),ex4(:),G1H2(116),ngZd,m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_Q_A(ntryL,G1H2(116),59,0,G2H2(89),n2h2(30))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(9),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(35),[G1H2(58),G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(15),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(36),[G1H2(64),G1H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G1H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(21),[G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(37),[G1H2(70),G1H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(16),[G1H2(114),G1H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(38),[G1H2(76),G1H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(18),[G1H2(120),G1H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(39),[G1H2(82),G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G1H2(132),G1H2(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(45),[G1H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(11),[G1H2(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(40),[G1H2(90),G1H2(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(51),[G1H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G1H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(41),[G1H2(96),G1H2(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G1H2(160),G1H2(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(42),[G1H2(102),G1H2(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G1H2(166),G1H2(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(43),[G1H2(108),G1H2(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(63),[G1H2(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G1H2(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G1H2(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(75),[G1H2(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G1H2(138),G1H2(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G1H2(144),G1H2(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(10),[G1H2(156),G1H2(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(99),[G1H2(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G1H2(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(105),[G1H2(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G1H2(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G1H2(172),G1H2(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G1H2(178),G1H2(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(117),[G1H2(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G1H2(136),G1H2(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(30),[G1H2(142),G1H2(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(31),[G1H2(148),G1H2(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(131),[G1H2(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(19),[G1H2(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G1H2(154),G1H2(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(141),[G1H2(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(155),[G1H2(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G1H2(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(33),[G1H2(174),G1H2(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(34),[G1H2(180),G1H2(168)])
  call Hloop_VQ_A(ntryL,G1H2(9),ex5(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(1),n2h1(61))
  call Hotf_5pt_reduction(G2H2(35),RedSet_5(15),mass5set(:,9),  & 
G1H2(121),G1H2(122),G1H2(127),G1H2(128),G1H2(133),G1H2(134),2)
  call HG1shiftOLR(G1H2(122),16,2)
  call Hloop_VQ_A(ntryL,G1H2(5),ex5(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(3),n2h1(62))
  call Hotf_5pt_reduction(G2H2(15),RedSet_5(16),mass5set(:,1),  & 
G1H2(139),G1H2(140),G1H2(145),G1H2(146),G1H2(151),G1H2(152),2)
  call HG1shiftOLR(G1H2(140),16,2)
  call Hotf_5pt_reduction(G2H2(36),RedSet_5(15),mass5set(:,10),  & 
G1H2(157),G1H2(158),G1H2(163),G1H2(164),G1H2(169),G1H2(170),2)
  call HG1shiftOLR(G1H2(158),16,2)
  call Hloop_VQ_A(ntryL,G1H2(11),ex5(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(5),n2h1(63))
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(16),mass5set(:,2),  & 
G1H2(175),G1H2(176),G1H2(1),G1H2(7),G1H2(8),G1H2(13),2)
  call HG1shiftOLR(G1H2(176),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(21),ex5(:),G1H1(1),ngZd,m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(7),n2h1(64))
  call Hotf_5pt_reduction(G2H2(37),RedSet_5(15),mass5set(:,11),  & 
G1H2(19),G1H2(20),G1H2(25),G1H2(31),G1H2(32),G1H2(37),2)
  call HG1shiftOLR(G1H2(20),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(17),ex5(:),G1H1(1),ngZd,m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(9),n2h1(65))
  call Hotf_5pt_reduction(G2H2(16),RedSet_5(16),mass5set(:,12),  & 
G1H2(43),G1H2(44),G1H2(49),G1H2(55),G1H2(56),G1H2(61),2)
  call HG1shiftOLR(G1H2(44),16,2)
  call Hotf_5pt_reduction(G2H2(38),RedSet_5(15),mass5set(:,13),  & 
G1H2(67),G1H2(68),G1H2(73),G1H2(79),G1H2(80),G1H2(85),2)
  call HG1shiftOLR(G1H2(68),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(23),ex5(:),G1H1(1),ngZd,m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(66))
  call Hotf_5pt_reduction(G2H2(18),RedSet_5(16),mass5set(:,14),  & 
G1H2(91),G1H2(92),G1H2(97),G1H2(103),G1H2(104),G1H2(109),2)
  call HG1shiftOLR(G1H2(92),16,2)
  call Hloop_WQ_A(ntryL,G1H2(27),ex5(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(67))
  call Hotf_5pt_reduction(G2H2(39),RedSet_5(15),mass5set(:,15),  & 
G1H2(115),G1H2(116),G1H2(3),G1H2(58),G1H2(4),G1H2(6),2)
  call HG1shiftOLR(G1H2(116),16,2)
  call Hloop_WQ_A(ntryL,G1H2(29),ex5(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(68))
  call Hotf_5pt_reduction(G2H2(20),RedSet_5(16),mass5set(:,16),  & 
G1H2(64),G1H2(10),G1H2(12),G1H2(15),G1H2(70),G1H2(16),2)
  call HG1shiftOLR(G1H2(10),16,2)
  call Hloop_VQ_A(ntryL,G1H2(45),ex5(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(17),n2h1(69))
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(17),mass5set(:,9),  & 
G1H2(114),G1H2(18),G1H2(76),G1H2(22),G1H2(120),G1H2(24),2)
  call HG1shiftOLR(G1H2(18),16,2)
  call Hloop_VQ_A(ntryL,G1H2(35),ex5(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(19),n2h1(70))
  call Hotf_5pt_reduction(G2H2(40),RedSet_5(18),mass5set(:,1),  & 
G1H2(82),G1H2(28),G1H2(132),G1H2(30),G1H2(33),G1H2(34),2)
  call HG1shiftOLR(G1H2(28),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(51),ex5(:),G1H1(1),ngZd,m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(21),n2h1(71))
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(17),mass5set(:,11),  & 
G1H2(90),G1H2(36),G1H2(39),G1H2(40),G1H2(96),G1H2(42),2)
  call HG1shiftOLR(G1H2(36),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(41),ex5(:),G1H1(1),ngZd,m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(23),n2h1(72))
  call Hotf_5pt_reduction(G2H2(41),RedSet_5(18),mass5set(:,12),  & 
G1H2(160),G1H2(46),G1H2(102),G1H2(48),G1H2(166),G1H2(52),2)
  call HG1shiftOLR(G1H2(46),16,2)
  call Hotf_5pt_reduction(G2H2(12),RedSet_5(17),mass5set(:,10),  & 
G1H2(108),G1H2(54),G1H2(57),G1H2(60),G1H2(66),G1H2(69),2)
  call HG1shiftOLR(G1H2(54),16,2)
  call Hloop_VQ_A(ntryL,G1H2(47),ex5(:),G1H1(1),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(25),n2h1(73))
  call Hotf_5pt_reduction(G2H2(42),RedSet_5(18),mass5set(:,2),  & 
G1H2(138),G1H2(72),G1H2(144),G1H2(78),G1H2(156),G1H2(84),2)
  call HG1shiftOLR(G1H2(72),16,2)
  call Hotf_5pt_reduction(G2H2(14),RedSet_5(17),mass5set(:,13),  & 
G1H2(87),G1H2(88),G1H2(93),G1H2(94),G1H2(172),G1H2(100),2)
  call HG1shiftOLR(G1H2(88),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(53),ex5(:),G1H1(1),ngZd,m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(27),n2h1(74))
  call Hotf_5pt_reduction(G2H2(43),RedSet_5(18),mass5set(:,14),  & 
G1H2(178),G1H2(106),G1H2(111),G1H2(136),G1H2(112),G1H2(142),2)
  call HG1shiftOLR(G1H2(106),16,2)
  call Hloop_VQ_A(ntryL,G1H2(63),ex5(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(29),n2h1(75))
  call Hloop_VQ_A(ntryL,G1H2(59),ex5(:),G1H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(31),n2h1(76))
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(19),mass5set(:,1),  & 
G1H2(118),G1H2(148),G1H2(124),G1H2(125),G1H2(126),G1H2(154),2)
  call HG1shiftOLR(G1H2(148),16,2)
  call Hloop_VQ_A(ntryL,G1H2(65),ex5(:),G1H1(1),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(33),n2h1(77))
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(19),mass5set(:,2),  & 
G1H2(130),G1H2(135),G1H2(149),G1H2(150),G1H2(174),G1H2(162),2)
  call HG1shiftOLR(G1H2(135),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(75),ex5(:),G1H1(1),ngZd,m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(35),n2h1(78))
  call Hloop_ZQ_A(ntryL,G1H2(71),ex5(:),G1H1(1),ngZd,m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(37),n2h1(79))
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(19),mass5set(:,12),  & 
G1H2(180),G1H2(168),G1H2(9),G1H2(5),G1H2(11),G1H2(21),2)
  call HG1shiftOLR(G1H2(168),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(77),ex5(:),G1H1(1),ngZd,m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(39),n2h1(80))
  call Hotf_5pt_reduction(G2H2(8),RedSet_5(19),mass5set(:,14),  & 
G1H2(17),G1H2(23),G1H2(27),G1H2(29),G1H2(45),G1H2(35),2)
  call HG1shiftOLR(G1H2(23),16,2)
  call Hloop_WQ_A(ntryL,G1H2(81),ex5(:),G1H1(1),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(41),n2h1(81))
  call Hloop_WQ_A(ntryL,G1H2(83),ex5(:),G1H1(1),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(43),n2h1(82))
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(19),mass5set(:,16),  & 
G1H2(51),G1H2(41),G1H2(47),G1H2(53),G1H2(63),G1H2(59),2)
  call HG1shiftOLR(G1H2(41),16,2)
  call Hloop_VQ_A(ntryL,G1H2(99),ex5(:),G1H1(1),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(45),n2h1(83))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(20),mass5set(:,9),  & 
G1H2(65),G1H2(75),G1H2(71),G1H2(77),G1H2(81),G1H2(83),2)
  call HG1shiftOLR(G1H2(75),16,2)
  call Hloop_VQ_A(ntryL,G1H2(89),ex5(:),G1H1(1),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(47),n2h1(84))
  call Hloop_ZQ_A(ntryL,G1H2(105),ex5(:),G1H1(1),ngZd,m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(49),n2h1(85))
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(20),mass5set(:,11),  & 
G1H2(99),G1H2(89),G1H2(105),G1H2(181),G1H2(182),G1H2(183),2)
  call HG1shiftOLR(G1H2(89),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(95),ex5(:),G1H1(1),ngZd,m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(51),n2h1(86))
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(20),mass5set(:,10),  & 
G1H2(95),G1H2(184),G1H2(185),G1H2(186),G1H2(187),G1H2(188),2)
  call HG1shiftOLR(G1H2(184),16,2)
  call Hloop_VQ_A(ntryL,G1H2(101),ex5(:),G1H1(1),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(53),n2h1(87))
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(20),mass5set(:,13),  & 
G1H2(101),G1H2(189),G1H2(190),G1H2(191),G1H2(192),G1H2(193),2)
  call HG1shiftOLR(G1H2(189),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(107),ex5(:),G1H1(1),ngZd,m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(55),n2h1(88))
  call Hloop_ZQ_A(ntryL,G1H2(117),ex5(:),G1H1(1),ngZd,m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(57),n2h1(89))
  call Hotf_5pt_reduction(G2H2(29),RedSet_5(21),mass5set(:,11),  & 
G1H2(107),G1H2(117),G1H2(194),G1H2(195),G1H2(196),G1H2(197),2)
  call HG1shiftOLR(G1H2(117),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(113),ex5(:),G1H1(1),ngZd,m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(59),n2h1(90))
  call Hotf_5pt_reduction(G2H2(30),RedSet_5(21),mass5set(:,13),  & 
G1H2(113),G1H2(198),G1H2(199),G1H2(200),G1H2(201),G1H2(202),2)
  call HG1shiftOLR(G1H2(198),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(119),ex5(:),G1H1(1),ngZd,m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(61),n2h1(91))
  call Hloop_WQ_A(ntryL,G1H2(123),ex5(:),G1H1(1),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(62),n2h1(92))
  call Hotf_5pt_reduction(G2H2(31),RedSet_5(21),mass5set(:,17),  & 
G1H2(119),G1H2(123),G1H2(203),G1H2(204),G1H2(205),G1H2(206),2)
  call HG1shiftOLR(G1H2(123),16,2)
  call Hloop_WQ_A(ntryL,G1H2(131),ex5(:),G1H1(1),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(63),n2h1(93))
  call Hotf_5pt_reduction(G2H2(19),RedSet_5(16),mass5set(:,17),  & 
G1H2(131),G1H2(207),G1H2(208),G1H2(209),G1H2(210),G1H2(211),2)
  call HG1shiftOLR(G1H2(207),16,2)
  call Hloop_WQ_A(ntryL,G1H2(129),ex5(:),G1H1(1),m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(64),n2h1(94))
  call Hotf_5pt_reduction(G2H2(32),RedSet_5(21),mass5set(:,15),  & 
G1H2(129),G1H2(212),G1H2(213),G1H2(214),G1H2(215),G1H2(216),2)
  call HG1shiftOLR(G1H2(212),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(141),ex5(:),G1H1(1),ngZd,m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(65),n2h1(95))
  call Hloop_ZQ_A(ntryL,G1H2(137),ex5(:),G1H1(1),ngZd,m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(66),n2h1(96))
  call Hloop_ZQ_A(ntryL,G1H2(143),ex5(:),G1H1(1),ngZd,m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(67),n2h1(97))
  call Hloop_WQ_A(ntryL,G1H2(147),ex5(:),G1H1(1),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(68),n2h1(98))
  call Hloop_WQ_A(ntryL,G1H2(155),ex5(:),G1H1(1),m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(69),n2h1(99))
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(19),mass5set(:,17),  & 
G1H2(141),G1H2(137),G1H2(143),G1H2(147),G1H2(155),G1H2(217),2)
  call HG1shiftOLR(G1H2(137),16,2)
  call Hloop_WQ_A(ntryL,G1H2(153),ex5(:),G1H1(1),m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(70),n2h1(100))
  call Hloop_VQ_A(ntryL,G1H2(159),ex5(:),G1H1(1),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(71),n2h1(101))
  call Hloop_VQ_A(ntryL,G1H2(161),ex5(:),G1H1(1),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(72),n2h1(102))
  call Hotf_5pt_reduction(G2H2(33),RedSet_5(22),mass5set(:,2),  & 
G1H2(153),G1H2(159),G1H2(161),G1H2(218),G1H2(219),G1H2(220),2)
  call HG1shiftOLR(G1H2(159),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(165),ex5(:),G1H1(1),ngZd,m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(73),n2h1(103))
  call Hloop_ZQ_A(ntryL,G1H2(167),ex5(:),G1H1(1),ngZd,m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(74),n2h1(104))
  call Hotf_5pt_reduction(G2H2(34),RedSet_5(22),mass5set(:,14),  & 
G1H2(165),G1H2(167),G1H2(221),G1H2(222),G1H2(223),G1H2(224),2)
  call HG1shiftOLR(G1H2(167),16,2)
  call Hloop_VQ_A(ntryL,G1H2(171),ex5(:),G1H1(1),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(75),n2h1(105))
  call Hloop_VQ_A(ntryL,G1H2(173),ex5(:),G1H1(1),m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(76),n2h1(106))
  call Hloop_ZQ_A(ntryL,G1H2(177),ex5(:),G1H1(1),ngZd,m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(77),n2h1(107))
  call Hloop_ZQ_A(ntryL,G1H2(179),ex5(:),G1H1(1),ngZd,m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(78),n2h1(108))
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(23),mass5set(:,18),  & 
G1H2(171),G1H2(173),G1H2(177),G1H2(179),G1H2(225),G1H2(226),2)
  call HG1shiftOLR(G1H2(173),16,2)
  call Hotf_5pt_reduction(G2H2(22),RedSet_5(23),mass5set(:,19),  & 
G1H2(227),G1H2(228),G1H2(229),G1H2(230),G1H2(231),G1H2(232),2)
  call HG1shiftOLR(G1H2(228),16,2)
  call Hotf_5pt_reduction(G2H2(23),RedSet_5(23),mass5set(:,20),  & 
G1H2(233),G1H2(234),G1H2(235),G1H2(236),G1H2(237),G1H2(238),2)
  call HG1shiftOLR(G1H2(234),16,2)
  call Hotf_5pt_reduction(G2H2(24),RedSet_5(23),mass5set(:,21),  & 
G1H2(239),G1H2(240),G1H2(241),G1H2(242),G1H2(243),G1H2(244),2)
  call HG1shiftOLR(G1H2(240),16,2)
  call Hotf_5pt_reduction(G2H2(25),RedSet_5(24),mass5set(:,18),  & 
G1H2(245),G1H2(246),G1H2(247),G1H2(248),G1H2(249),G1H2(250),2)
  call HG1shiftOLR(G1H2(246),16,2)
  call Hotf_5pt_reduction(G2H2(26),RedSet_5(24),mass5set(:,20),  & 
G1H2(251),G1H2(252),G1H2(253),G1H2(254),G1H2(255),G1H2(256),2)
  call HG1shiftOLR(G1H2(252),16,2)
  call Hotf_5pt_reduction(G2H2(27),RedSet_5(24),mass5set(:,19),  & 
G1H2(257),G1H2(258),G1H2(259),G1H2(260),G1H2(261),G1H2(262),2)
  call HG1shiftOLR(G1H2(258),16,2)
  call Hotf_5pt_reduction(G2H2(28),RedSet_5(24),mass5set(:,21),  & 
G1H2(263),G1H2(264),G1H2(265),G1H2(266),G1H2(267),G1H2(268),2)
  call HG1shiftOLR(G1H2(264),16,2)
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(25),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(5),G1H4(6),G1H4(7),G1H4(8),4)
  call HG1shiftOLR(G1H4(2),12,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(25),mass5set(:,2),  & 
G1H4(11),G1H4(12),G1H4(13),G1H4(14),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(12),12,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(26),mass5set(:,2),  & 
G1H4(19),G1H4(20),G1H4(23),G1H4(24),G1H4(25),G1H4(26),4)
  call HG1shiftOLR(G1H4(20),12,4)
  call Hotf_5pt_reduction(G2H2(44),RedSet_5(27),mass5set(:,20),  & 
G1H2(269),G1H2(270),G1H2(271),G1H2(272),G1H2(273),G1H2(274),2)
  call HG1shiftOLR(G1H2(270),16,2)
  call Hotf_5pt_reduction(G2H2(45),RedSet_5(27),mass5set(:,21),  & 
G1H2(275),G1H2(276),G1H2(277),G1H2(278),G1H2(279),G1H2(280),2)
  call HG1shiftOLR(G1H2(276),16,2)
  call Hotf_5pt_reduction(G2H2(46),RedSet_5(28),mass5set(:,19),  & 
G1H2(281),G1H2(282),G1H2(283),G1H2(284),G1H2(285),G1H2(286),2)
  call HG1shiftOLR(G1H2(282),16,2)
  call Hotf_5pt_reduction(G2H2(47),RedSet_5(28),mass5set(:,21),  & 
G1H2(287),G1H2(288),G1H2(289),G1H2(290),G1H2(291),G1H2(292),2)
  call HG1shiftOLR(G1H2(288),16,2)
  call Hotf_5pt_reduction(G2H2(48),RedSet_5(29),mass5set(:,9),  & 
G1H2(293),G1H2(294),G1H2(295),G1H2(296),G1H2(297),G1H2(298),2)
  call HG1shiftOLR(G1H2(294),8,2)
  call Hotf_5pt_reduction(G2H2(49),RedSet_5(29),mass5set(:,22),  & 
G1H2(299),G1H2(300),G1H2(301),G1H2(302),G1H2(303),G1H2(304),2)
  call HG1shiftOLR(G1H2(300),8,2)
  call Hotf_5pt_reduction(G2H2(50),RedSet_5(29),mass5set(:,11),  & 
G1H2(305),G1H2(306),G1H2(307),G1H2(308),G1H2(309),G1H2(310),2)
  call HG1shiftOLR(G1H2(306),8,2)
  call Hotf_5pt_reduction(G2H2(51),RedSet_5(30),mass5set(:,23),  & 
G1H2(311),G1H2(312),G1H2(313),G1H2(314),G1H2(315),G1H2(316),2)
  call HG1shiftOLR(G1H2(312),8,2)
  call Hotf_5pt_reduction(G2H2(52),RedSet_5(30),mass5set(:,22),  & 
G1H2(317),G1H2(318),G1H2(319),G1H2(320),G1H2(321),G1H2(322),2)
  call HG1shiftOLR(G1H2(318),8,2)
  call Hotf_5pt_reduction(G2H2(53),RedSet_5(30),mass5set(:,11),  & 
G1H2(323),G1H2(324),G1H2(325),G1H2(326),G1H2(327),G1H2(328),2)
  call HG1shiftOLR(G1H2(324),8,2)
  call Hotf_5pt_reduction(G2H2(54),RedSet_5(31),mass5set(:,9),  & 
G1H2(329),G1H2(330),G1H2(331),G1H2(332),G1H2(333),G1H2(334),2)
  call HG1shiftOLR(G1H2(330),2,2)
  call Hotf_5pt_reduction(G2H2(55),RedSet_5(31),mass5set(:,11),  & 
G1H2(335),G1H2(336),G1H2(337),G1H2(338),G1H2(339),G1H2(340),2)
  call HG1shiftOLR(G1H2(336),2,2)
  call Hotf_5pt_reduction(G2H2(56),RedSet_5(31),mass5set(:,22),  & 
G1H2(341),G1H2(342),G1H2(343),G1H2(344),G1H2(345),G1H2(346),2)
  call HG1shiftOLR(G1H2(342),2,2)
  call Hotf_5pt_reduction(G2H2(57),RedSet_5(32),mass5set(:,9),  & 
G1H2(347),G1H2(348),G1H2(349),G1H2(350),G1H2(351),G1H2(352),2)
  call HG1shiftOLR(G1H2(348),2,2)
  call Hotf_5pt_reduction(G2H2(58),RedSet_5(32),mass5set(:,11),  & 
G1H2(353),G1H2(354),G1H2(355),G1H2(356),G1H2(357),G1H2(358),2)
  call HG1shiftOLR(G1H2(354),2,2)
  call Hotf_5pt_reduction(G2H2(59),RedSet_5(32),mass5set(:,22),  & 
G1H2(359),G1H2(360),G1H2(361),G1H2(362),G1H2(363),G1H2(364),2)
  call HG1shiftOLR(G1H2(360),2,2)
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(60),ex4(:),G2tensor(79),m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(62),ex4(:),G2tensor(80),m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(63),ex4(:),G2tensor(81),m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(65),ex4(:),G2tensor(82),m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(66),ex3(:),G2tensor(83),m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(68),ex3(:),G2tensor(84),m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(69),ex3(:),G2tensor(85),m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(71),ex3(:),G2tensor(86),m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(72),ex4(:),G2tensor(87),m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(74),ex4(:),G2tensor(88),m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(75),ex3(:),G2tensor(89),m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(77),ex3(:),G2tensor(90),m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(78),ex4(:),G2tensor(91),m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(80),ex4(:),G2tensor(92),m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(81),ex4(:),G2tensor(93),m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(83),ex4(:),G2tensor(94),m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(84),ex3(:),G2tensor(95),m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(86),ex3(:),G2tensor(96),m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(87),ex3(:),G2tensor(97),m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(89),ex3(:),G2tensor(98),m3h2x1(:,128),heltab2x2(:,:,128))
  call Hloop_VQ_A(ntryL,G1H2(121),ex5(:),G1H1(1),m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(99),n2h1(109))
  call Hloop_VQ_A(ntryL,G1H2(122),ex5(:),G1H1(1),m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(100),n2h1(110))
  call Hloop_VQ_A(ntryL,G1H2(134),ex5(:),G1H1(1),m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(101),n2h1(111))
  call Hloop_VQ_A(ntryL,G1H2(139),ex5(:),G1H1(1),m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(102),n2h1(112))
  call Hloop_VQ_A(ntryL,G1H2(140),ex5(:),G1H1(1),m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(103),n2h1(113))
  call Hloop_VQ_A(ntryL,G1H2(152),ex5(:),G1H1(1),m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(104),n2h1(114))
  call Hloop_VQ_A(ntryL,G1H2(157),ex5(:),G1H1(1),m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(105),n2h1(115))
  call Hloop_VQ_A(ntryL,G1H2(158),ex5(:),G1H1(1),m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(106),n2h1(116))
  call Hloop_VQ_A(ntryL,G1H2(170),ex5(:),G1H1(1),m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(107),n2h1(117))
  call Hloop_VQ_A(ntryL,G1H2(175),ex5(:),G1H1(1),m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(108),n2h1(118))
  call Hloop_VQ_A(ntryL,G1H2(176),ex5(:),G1H1(1),m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(109),n2h1(119))
  call Hloop_VQ_A(ntryL,G1H2(13),ex5(:),G1H1(1),m3h2x1(:,140),heltab2x2(:,:,140))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(110),n2h1(120))
  call Hloop_ZQ_A(ntryL,G1H2(19),ex5(:),G1H1(1),ngZd,m3h2x1(:,141),heltab2x2(:,:,141))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(111),n2h1(121))
  call Hloop_ZQ_A(ntryL,G1H2(20),ex5(:),G1H1(1),ngZd,m3h2x1(:,142),heltab2x2(:,:,142))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(112),n2h1(122))
  call Hloop_ZQ_A(ntryL,G1H2(37),ex5(:),G1H1(1),ngZd,m3h2x1(:,143),heltab2x2(:,:,143))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(113),n2h1(123))
  call Hloop_ZQ_A(ntryL,G1H2(43),ex5(:),G1H1(1),ngZd,m3h2x1(:,144),heltab2x2(:,:,144))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(114),n2h1(124))
  call Hloop_ZQ_A(ntryL,G1H2(44),ex5(:),G1H1(1),ngZd,m3h2x1(:,145),heltab2x2(:,:,145))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(115),n2h1(125))
  call Hloop_ZQ_A(ntryL,G1H2(61),ex5(:),G1H1(1),ngZd,m3h2x1(:,146),heltab2x2(:,:,146))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(116),n2h1(126))
  call Hloop_ZQ_A(ntryL,G1H2(67),ex5(:),G1H1(1),ngZd,m3h2x1(:,147),heltab2x2(:,:,147))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(117),n2h1(127))
  call Hloop_ZQ_A(ntryL,G1H2(68),ex5(:),G1H1(1),ngZd,m3h2x1(:,148),heltab2x2(:,:,148))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(118),n2h1(128))
  call Hloop_ZQ_A(ntryL,G1H2(85),ex5(:),G1H1(1),ngZd,m3h2x1(:,149),heltab2x2(:,:,149))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(119),n2h1(129))
  call Hloop_ZQ_A(ntryL,G1H2(91),ex5(:),G1H1(1),ngZd,m3h2x1(:,150),heltab2x2(:,:,150))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(120),n2h1(130))
  call Hloop_ZQ_A(ntryL,G1H2(92),ex5(:),G1H1(1),ngZd,m3h2x1(:,151),heltab2x2(:,:,151))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(121),n2h1(131))
  call Hloop_ZQ_A(ntryL,G1H2(109),ex5(:),G1H1(1),ngZd,m3h2x1(:,152),heltab2x2(:,:,152))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(122),n2h1(132))
  call Hloop_WQ_A(ntryL,G1H2(115),ex5(:),G1H1(1),m3h2x1(:,153),heltab2x2(:,:,153))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(123),n2h1(133))
  call Hloop_WQ_A(ntryL,G1H2(116),ex5(:),G1H1(1),m3h2x1(:,154),heltab2x2(:,:,154))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(124),n2h1(134))
  call Hloop_WQ_A(ntryL,G1H2(6),ex5(:),G1H1(1),m3h2x1(:,155),heltab2x2(:,:,155))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(125),n2h1(135))
  call Hloop_WQ_A(ntryL,G1H2(64),ex5(:),G1H1(1),m3h2x1(:,156),heltab2x2(:,:,156))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(126),n2h1(136))
  call Hloop_WQ_A(ntryL,G1H2(10),ex5(:),G1H1(1),m3h2x1(:,157),heltab2x2(:,:,157))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(127),n2h1(137))
  call Hloop_WQ_A(ntryL,G1H2(16),ex5(:),G1H1(1),m3h2x1(:,158),heltab2x2(:,:,158))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(128),n2h1(138))
  call Hloop_VQ_A(ntryL,G1H2(114),ex5(:),G1H1(1),m3h2x1(:,159),heltab2x2(:,:,159))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(129),n2h1(139))
  call Hloop_VQ_A(ntryL,G1H2(18),ex5(:),G1H1(1),m3h2x1(:,160),heltab2x2(:,:,160))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(130),n2h1(140))
  call Hloop_VQ_A(ntryL,G1H2(24),ex5(:),G1H1(1),m3h2x1(:,161),heltab2x2(:,:,161))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(131),n2h1(141))
  call Hloop_VQ_A(ntryL,G1H2(82),ex5(:),G1H1(1),m3h2x1(:,162),heltab2x2(:,:,162))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(132),n2h1(142))
  call Hloop_VQ_A(ntryL,G1H2(28),ex5(:),G1H1(1),m3h2x1(:,163),heltab2x2(:,:,163))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(133),n2h1(143))
  call Hloop_VQ_A(ntryL,G1H2(34),ex5(:),G1H1(1),m3h2x1(:,164),heltab2x2(:,:,164))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(134),n2h1(144))
  call Hloop_ZQ_A(ntryL,G1H2(90),ex5(:),G1H1(1),ngZd,m3h2x1(:,165),heltab2x2(:,:,165))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(135),n2h1(145))
  call Hloop_ZQ_A(ntryL,G1H2(36),ex5(:),G1H1(1),ngZd,m3h2x1(:,166),heltab2x2(:,:,166))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(136),n2h1(146))
  call Hloop_ZQ_A(ntryL,G1H2(42),ex5(:),G1H1(1),ngZd,m3h2x1(:,167),heltab2x2(:,:,167))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(137),n2h1(147))
  call Hloop_ZQ_A(ntryL,G1H2(160),ex5(:),G1H1(1),ngZd,m3h2x1(:,168),heltab2x2(:,:,168))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(138),n2h1(148))
  call Hloop_ZQ_A(ntryL,G1H2(46),ex5(:),G1H1(1),ngZd,m3h2x1(:,169),heltab2x2(:,:,169))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(139),n2h1(149))
  call Hloop_ZQ_A(ntryL,G1H2(52),ex5(:),G1H1(1),ngZd,m3h2x1(:,170),heltab2x2(:,:,170))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(140),n2h1(150))
  call Hloop_VQ_A(ntryL,G1H2(108),ex5(:),G1H1(1),m3h2x1(:,171),heltab2x2(:,:,171))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(141),n2h1(151))
  call Hloop_VQ_A(ntryL,G1H2(54),ex5(:),G1H1(1),m3h2x1(:,172),heltab2x2(:,:,172))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(142),n2h1(152))
  call Hloop_VQ_A(ntryL,G1H2(69),ex5(:),G1H1(1),m3h2x1(:,173),heltab2x2(:,:,173))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(143),n2h1(153))
  call Hloop_VQ_A(ntryL,G1H2(138),ex5(:),G1H1(1),m3h2x1(:,174),heltab2x2(:,:,174))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(144),n2h1(154))
  call Hloop_VQ_A(ntryL,G1H2(72),ex5(:),G1H1(1),m3h2x1(:,175),heltab2x2(:,:,175))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(145),n2h1(155))
  call Hloop_VQ_A(ntryL,G1H2(84),ex5(:),G1H1(1),m3h2x1(:,176),heltab2x2(:,:,176))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(146),n2h1(156))
  call Hloop_ZQ_A(ntryL,G1H2(87),ex5(:),G1H1(1),ngZd,m3h2x1(:,177),heltab2x2(:,:,177))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(147),n2h1(157))
  call Hloop_ZQ_A(ntryL,G1H2(88),ex5(:),G1H1(1),ngZd,m3h2x1(:,178),heltab2x2(:,:,178))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(148),n2h1(158))
  call Hloop_ZQ_A(ntryL,G1H2(100),ex5(:),G1H1(1),ngZd,m3h2x1(:,179),heltab2x2(:,:,179))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(149),n2h1(159))
  call Hloop_ZQ_A(ntryL,G1H2(178),ex5(:),G1H1(1),ngZd,m3h2x1(:,180),heltab2x2(:,:,180))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(150),n2h1(160))
  call Hloop_ZQ_A(ntryL,G1H2(106),ex5(:),G1H1(1),ngZd,m3h2x1(:,181),heltab2x2(:,:,181))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(151),n2h1(161))
  call Hloop_ZQ_A(ntryL,G1H2(142),ex5(:),G1H1(1),ngZd,m3h2x1(:,182),heltab2x2(:,:,182))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(152),n2h1(162))
  call Hloop_VQ_A(ntryL,G1H2(118),ex5(:),G1H1(1),m3h2x1(:,183),heltab2x2(:,:,183))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(153),n2h1(163))
  call Hloop_VQ_A(ntryL,G1H2(148),ex5(:),G1H1(1),m3h2x1(:,184),heltab2x2(:,:,184))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(154),n2h1(164))
  call Hloop_VQ_A(ntryL,G1H2(154),ex5(:),G1H1(1),m3h2x1(:,185),heltab2x2(:,:,185))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(155),n2h1(165))
  call Hloop_VQ_A(ntryL,G1H2(130),ex5(:),G1H1(1),m3h2x1(:,186),heltab2x2(:,:,186))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(156),n2h1(166))
  call Hloop_VQ_A(ntryL,G1H2(135),ex5(:),G1H1(1),m3h2x1(:,187),heltab2x2(:,:,187))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(157),n2h1(167))
  call Hloop_VQ_A(ntryL,G1H2(162),ex5(:),G1H1(1),m3h2x1(:,188),heltab2x2(:,:,188))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(158),n2h1(168))
  call Hloop_ZQ_A(ntryL,G1H2(180),ex5(:),G1H1(1),ngZd,m3h2x1(:,189),heltab2x2(:,:,189))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(159),n2h1(169))
  call Hloop_ZQ_A(ntryL,G1H2(168),ex5(:),G1H1(1),ngZd,m3h2x1(:,190),heltab2x2(:,:,190))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(160),n2h1(170))
  call Hloop_ZQ_A(ntryL,G1H2(21),ex5(:),G1H1(1),ngZd,m3h2x1(:,191),heltab2x2(:,:,191))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(161),n2h1(171))
  call Hloop_ZQ_A(ntryL,G1H2(17),ex5(:),G1H1(1),ngZd,m3h2x1(:,192),heltab2x2(:,:,192))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(162),n2h1(172))
  call Hloop_ZQ_A(ntryL,G1H2(23),ex5(:),G1H1(1),ngZd,m3h2x1(:,193),heltab2x2(:,:,193))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(163),n2h1(173))
  call Hloop_ZQ_A(ntryL,G1H2(35),ex5(:),G1H1(1),ngZd,m3h2x1(:,194),heltab2x2(:,:,194))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(164),n2h1(174))
  call Hloop_WQ_A(ntryL,G1H2(51),ex5(:),G1H1(1),m3h2x1(:,195),heltab2x2(:,:,195))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(165),n2h1(175))
  call Hloop_WQ_A(ntryL,G1H2(41),ex5(:),G1H1(1),m3h2x1(:,196),heltab2x2(:,:,196))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(166),n2h1(176))
  call Hloop_WQ_A(ntryL,G1H2(59),ex5(:),G1H1(1),m3h2x1(:,197),heltab2x2(:,:,197))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(167),n2h1(177))
  call Hloop_VQ_A(ntryL,G1H2(65),ex5(:),G1H1(1),m3h2x1(:,198),heltab2x2(:,:,198))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(168),n2h1(178))
  call Hloop_VQ_A(ntryL,G1H2(75),ex5(:),G1H1(1),m3h2x1(:,199),heltab2x2(:,:,199))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(169),n2h1(179))
  call Hloop_VQ_A(ntryL,G1H2(83),ex5(:),G1H1(1),m3h2x1(:,200),heltab2x2(:,:,200))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(170),n2h1(180))
  call Hloop_ZQ_A(ntryL,G1H2(99),ex5(:),G1H1(1),ngZd,m3h2x1(:,201),heltab2x2(:,:,201))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(171),n2h1(181))
  call Hloop_ZQ_A(ntryL,G1H2(89),ex5(:),G1H1(1),ngZd,m3h2x1(:,202),heltab2x2(:,:,202))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(172),n2h1(182))
  call Hloop_ZQ_A(ntryL,G1H2(183),ex5(:),G1H1(1),ngZd,m3h2x1(:,203),heltab2x2(:,:,203))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(173),n2h1(183))
  call Hloop_VQ_A(ntryL,G1H2(95),ex5(:),G1H1(1),m3h2x1(:,204),heltab2x2(:,:,204))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(174),n2h1(184))
  call Hloop_VQ_A(ntryL,G1H2(184),ex5(:),G1H1(1),m3h2x1(:,205),heltab2x2(:,:,205))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(175),n2h1(185))
  call Hloop_VQ_A(ntryL,G1H2(188),ex5(:),G1H1(1),m3h2x1(:,206),heltab2x2(:,:,206))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(176),n2h1(186))
  call Hloop_ZQ_A(ntryL,G1H2(101),ex5(:),G1H1(1),ngZd,m3h2x1(:,207),heltab2x2(:,:,207))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(177),n2h1(187))
  call Hloop_ZQ_A(ntryL,G1H2(189),ex5(:),G1H1(1),ngZd,m3h2x1(:,208),heltab2x2(:,:,208))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(178),n2h1(188))
  call Hloop_ZQ_A(ntryL,G1H2(193),ex5(:),G1H1(1),ngZd,m3h2x1(:,209),heltab2x2(:,:,209))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(179),n2h1(189))
  call Hloop_ZQ_A(ntryL,G1H2(107),ex5(:),G1H1(1),ngZd,m3h2x1(:,210),heltab2x2(:,:,210))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(180),n2h1(190))
  call Hloop_ZQ_A(ntryL,G1H2(117),ex5(:),G1H1(1),ngZd,m3h2x1(:,211),heltab2x2(:,:,211))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(181),n2h1(191))
  call Hloop_ZQ_A(ntryL,G1H2(197),ex5(:),G1H1(1),ngZd,m3h2x1(:,212),heltab2x2(:,:,212))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(182),n2h1(192))
  call Hloop_ZQ_A(ntryL,G1H2(113),ex5(:),G1H1(1),ngZd,m3h2x1(:,213),heltab2x2(:,:,213))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(183),n2h1(193))
  call Hloop_ZQ_A(ntryL,G1H2(198),ex5(:),G1H1(1),ngZd,m3h2x1(:,214),heltab2x2(:,:,214))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(184),n2h1(194))
  call Hloop_ZQ_A(ntryL,G1H2(202),ex5(:),G1H1(1),ngZd,m3h2x1(:,215),heltab2x2(:,:,215))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(185),n2h1(195))
  call Hloop_WQ_A(ntryL,G1H2(119),ex5(:),G1H1(1),m3h2x1(:,216),heltab2x2(:,:,216))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(186),n2h1(196))
  call Hloop_WQ_A(ntryL,G1H2(123),ex5(:),G1H1(1),m3h2x1(:,217),heltab2x2(:,:,217))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(187),n2h1(197))
  call Hloop_WQ_A(ntryL,G1H2(206),ex5(:),G1H1(1),m3h2x1(:,218),heltab2x2(:,:,218))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(188),n2h1(198))
  call Hloop_WQ_A(ntryL,G1H2(131),ex5(:),G1H1(1),m3h2x1(:,219),heltab2x2(:,:,219))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(189),n2h1(199))
  call Hloop_WQ_A(ntryL,G1H2(207),ex5(:),G1H1(1),m3h2x1(:,220),heltab2x2(:,:,220))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(190),n2h1(200))
  call Hloop_WQ_A(ntryL,G1H2(211),ex5(:),G1H1(1),m3h2x1(:,221),heltab2x2(:,:,221))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(191),n2h1(201))
  call Hloop_WQ_A(ntryL,G1H2(129),ex5(:),G1H1(1),m3h2x1(:,222),heltab2x2(:,:,222))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(192),n2h1(202))
  call Hloop_WQ_A(ntryL,G1H2(212),ex5(:),G1H1(1),m3h2x1(:,223),heltab2x2(:,:,223))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(193),n2h1(203))
  call Hloop_WQ_A(ntryL,G1H2(216),ex5(:),G1H1(1),m3h2x1(:,224),heltab2x2(:,:,224))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(194),n2h1(204))
  call Hloop_WQ_A(ntryL,G1H2(141),ex5(:),G1H1(1),m3h2x1(:,225),heltab2x2(:,:,225))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(195),n2h1(205))
  call Hloop_WQ_A(ntryL,G1H2(137),ex5(:),G1H1(1),m3h2x1(:,226),heltab2x2(:,:,226))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(196),n2h1(206))
  call Hloop_WQ_A(ntryL,G1H2(217),ex5(:),G1H1(1),m3h2x1(:,227),heltab2x2(:,:,227))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(197),n2h1(207))
  call Hloop_VQ_A(ntryL,G1H2(153),ex5(:),G1H1(1),m3h2x1(:,228),heltab2x2(:,:,228))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(198),n2h1(208))
  call Hloop_VQ_A(ntryL,G1H2(159),ex5(:),G1H1(1),m3h2x1(:,229),heltab2x2(:,:,229))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(199),n2h1(209))
  call Hloop_VQ_A(ntryL,G1H2(220),ex5(:),G1H1(1),m3h2x1(:,230),heltab2x2(:,:,230))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(200),n2h1(210))
  call Hloop_ZQ_A(ntryL,G1H2(165),ex5(:),G1H1(1),ngZd,m3h2x1(:,231),heltab2x2(:,:,231))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(201),n2h1(211))
  call Hloop_ZQ_A(ntryL,G1H2(167),ex5(:),G1H1(1),ngZd,m3h2x1(:,232),heltab2x2(:,:,232))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(202),n2h1(212))
  call Hloop_ZQ_A(ntryL,G1H2(224),ex5(:),G1H1(1),ngZd,m3h2x1(:,233),heltab2x2(:,:,233))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(203),n2h1(213))
  call Hloop_VQ_A(ntryL,G1H2(171),ex5(:),G1H1(1),m3h2x1(:,234),heltab2x2(:,:,234))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(204),n2h1(214))
  call Hloop_VQ_A(ntryL,G1H2(173),ex5(:),G1H1(1),m3h2x1(:,235),heltab2x2(:,:,235))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(205),n2h1(215))
  call Hloop_VQ_A(ntryL,G1H2(226),ex5(:),G1H1(1),m3h2x1(:,236),heltab2x2(:,:,236))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(206),n2h1(216))
  call Hloop_VQ_A(ntryL,G1H2(227),ex5(:),G1H1(1),m3h2x1(:,237),heltab2x2(:,:,237))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(207),n2h1(217))
  call Hloop_VQ_A(ntryL,G1H2(228),ex5(:),G1H1(1),m3h2x1(:,238),heltab2x2(:,:,238))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(208),n2h1(218))
  call Hloop_VQ_A(ntryL,G1H2(232),ex5(:),G1H1(1),m3h2x1(:,239),heltab2x2(:,:,239))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(209),n2h1(219))
  call Hloop_ZQ_A(ntryL,G1H2(233),ex5(:),G1H1(1),ngZd,m3h2x1(:,240),heltab2x2(:,:,240))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(210),n2h1(220))
  call Hloop_ZQ_A(ntryL,G1H2(234),ex5(:),G1H1(1),ngZd,m3h2x1(:,241),heltab2x2(:,:,241))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(211),n2h1(221))
  call Hloop_ZQ_A(ntryL,G1H2(238),ex5(:),G1H1(1),ngZd,m3h2x1(:,242),heltab2x2(:,:,242))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(212),n2h1(222))
  call Hloop_ZQ_A(ntryL,G1H2(239),ex5(:),G1H1(1),ngZd,m3h2x1(:,243),heltab2x2(:,:,243))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(213),n2h1(223))
  call Hloop_ZQ_A(ntryL,G1H2(240),ex5(:),G1H1(1),ngZd,m3h2x1(:,244),heltab2x2(:,:,244))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(214),n2h1(224))
  call Hloop_ZQ_A(ntryL,G1H2(244),ex5(:),G1H1(1),ngZd,m3h2x1(:,245),heltab2x2(:,:,245))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(215),n2h1(225))
  call Hloop_VQ_A(ntryL,G1H2(245),ex5(:),G1H1(1),m3h2x1(:,246),heltab2x2(:,:,246))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(216),n2h1(226))
  call Hloop_VQ_A(ntryL,G1H2(246),ex5(:),G1H1(1),m3h2x1(:,247),heltab2x2(:,:,247))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(217),n2h1(227))
  call Hloop_VQ_A(ntryL,G1H2(250),ex5(:),G1H1(1),m3h2x1(:,248),heltab2x2(:,:,248))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(218),n2h1(228))
  call Hloop_ZQ_A(ntryL,G1H2(251),ex5(:),G1H1(1),ngZd,m3h2x1(:,249),heltab2x2(:,:,249))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(219),n2h1(229))
  call Hloop_ZQ_A(ntryL,G1H2(252),ex5(:),G1H1(1),ngZd,m3h2x1(:,250),heltab2x2(:,:,250))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(220),n2h1(230))
  call Hloop_ZQ_A(ntryL,G1H2(256),ex5(:),G1H1(1),ngZd,m3h2x1(:,251),heltab2x2(:,:,251))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(221),n2h1(231))
  call Hloop_VQ_A(ntryL,G1H2(257),ex5(:),G1H1(1),m3h2x1(:,252),heltab2x2(:,:,252))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(222),n2h1(232))
  call Hloop_VQ_A(ntryL,G1H2(258),ex5(:),G1H1(1),m3h2x1(:,253),heltab2x2(:,:,253))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(223),n2h1(233))
  call Hloop_VQ_A(ntryL,G1H2(262),ex5(:),G1H1(1),m3h2x1(:,254),heltab2x2(:,:,254))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(224),n2h1(234))
  call Hloop_ZQ_A(ntryL,G1H2(263),ex5(:),G1H1(1),ngZd,m3h2x1(:,255),heltab2x2(:,:,255))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(225),n2h1(235))
  call Hloop_ZQ_A(ntryL,G1H2(264),ex5(:),G1H1(1),ngZd,m3h2x1(:,256),heltab2x2(:,:,256))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(226),n2h1(236))
  call Hloop_ZQ_A(ntryL,G1H2(268),ex5(:),G1H1(1),ngZd,m3h2x1(:,257),heltab2x2(:,:,257))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(227),n2h1(237))
  call Hloop_QW_A(ntryL,G1H4(1),wf4(:,2),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,112))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(228),n2h1(238))
  call Hloop_QW_A(ntryL,G1H4(2),wf4(:,2),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,113))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(229),n2h1(239))
  call Hloop_QW_A(ntryL,G1H4(8),wf4(:,2),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,114))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(230),n2h1(240))
  call Hloop_QW_A(ntryL,G1H4(11),wf4(:,2),G1H1(1),m3h4x1(:,4),heltab2x4(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(231),n2h1(241))
  call Hloop_QW_A(ntryL,G1H4(12),wf4(:,2),G1H1(1),m3h4x1(:,5),heltab2x4(:,:,116))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(232),n2h1(242))
  call Hloop_QW_A(ntryL,G1H4(18),wf4(:,2),G1H1(1),m3h4x1(:,6),heltab2x4(:,:,117))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(233),n2h1(243))
  call Hloop_QW_A(ntryL,G1H4(19),wf4(:,2),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,118))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(234),n2h1(244))
  call Hloop_QW_A(ntryL,G1H4(20),wf4(:,2),G1H1(1),m3h4x1(:,8),heltab2x4(:,:,119))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(235),n2h1(245))
  call Hloop_QW_A(ntryL,G1H4(26),wf4(:,2),G1H1(1),m3h4x1(:,9),heltab2x4(:,:,120))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(236),n2h1(246))
  call Hloop_ZQ_A(ntryL,G1H2(269),ex5(:),G1H1(1),ngZd,m3h2x1(:,258),heltab2x2(:,:,258))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(237),n2h1(247))
  call Hloop_ZQ_A(ntryL,G1H2(270),ex5(:),G1H1(1),ngZd,m3h2x1(:,259),heltab2x2(:,:,259))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(238),n2h1(248))
  call Hloop_ZQ_A(ntryL,G1H2(274),ex5(:),G1H1(1),ngZd,m3h2x1(:,260),heltab2x2(:,:,260))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(239),n2h1(249))
  call Hloop_ZQ_A(ntryL,G1H2(275),ex5(:),G1H1(1),ngZd,m3h2x1(:,261),heltab2x2(:,:,261))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(240),n2h1(250))
  call Hloop_ZQ_A(ntryL,G1H2(276),ex5(:),G1H1(1),ngZd,m3h2x1(:,262),heltab2x2(:,:,262))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(241),n2h1(251))
  call Hloop_ZQ_A(ntryL,G1H2(280),ex5(:),G1H1(1),ngZd,m3h2x1(:,263),heltab2x2(:,:,263))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(242),n2h1(252))
  call Hloop_VQ_A(ntryL,G1H2(281),ex5(:),G1H1(1),m3h2x1(:,264),heltab2x2(:,:,264))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(243),n2h1(253))
  call Hloop_VQ_A(ntryL,G1H2(282),ex5(:),G1H1(1),m3h2x1(:,265),heltab2x2(:,:,265))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(244),n2h1(254))
  call Hloop_VQ_A(ntryL,G1H2(286),ex5(:),G1H1(1),m3h2x1(:,266),heltab2x2(:,:,266))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(245),n2h1(255))
  call Hloop_ZQ_A(ntryL,G1H2(287),ex5(:),G1H1(1),ngZd,m3h2x1(:,267),heltab2x2(:,:,267))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(246),n2h1(256))
  call Hloop_ZQ_A(ntryL,G1H2(288),ex5(:),G1H1(1),ngZd,m3h2x1(:,268),heltab2x2(:,:,268))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(247),n2h1(257))
  call Hloop_ZQ_A(ntryL,G1H2(292),ex5(:),G1H1(1),ngZd,m3h2x1(:,269),heltab2x2(:,:,269))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(248),n2h1(258))
  call Hloop_VQ_A(ntryL,G1H2(293),ex4(:),G1H1(1),m3h2x1(:,270),heltab2x2(:,:,270))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(249),n2h1(259))
  call Hloop_VQ_A(ntryL,G1H2(294),ex4(:),G1H1(1),m3h2x1(:,271),heltab2x2(:,:,271))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(250),n2h1(260))
  call Hloop_VQ_A(ntryL,G1H2(298),ex4(:),G1H1(1),m3h2x1(:,272),heltab2x2(:,:,272))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(251),n2h1(261))
  call Hloop_WQ_A(ntryL,G1H2(299),ex4(:),G1H1(1),m3h2x1(:,273),heltab2x2(:,:,273))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(252),n2h1(262))
  call Hloop_WQ_A(ntryL,G1H2(300),ex4(:),G1H1(1),m3h2x1(:,274),heltab2x2(:,:,274))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(253),n2h1(263))
  call Hloop_WQ_A(ntryL,G1H2(304),ex4(:),G1H1(1),m3h2x1(:,275),heltab2x2(:,:,275))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(254),n2h1(264))
  call Hloop_ZQ_A(ntryL,G1H2(305),ex4(:),G1H1(1),ngZd,m3h2x1(:,276),heltab2x2(:,:,276))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(255),n2h1(265))
  call Hloop_ZQ_A(ntryL,G1H2(306),ex4(:),G1H1(1),ngZd,m3h2x1(:,277),heltab2x2(:,:,277))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(256),n2h1(266))
  call Hloop_ZQ_A(ntryL,G1H2(310),ex4(:),G1H1(1),ngZd,m3h2x1(:,278),heltab2x2(:,:,278))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(257),n2h1(267))
  call Hloop_WQ_A(ntryL,G1H2(311),ex4(:),G1H1(1),m3h2x1(:,279),heltab2x2(:,:,279))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(258),n2h1(268))
  call Hloop_WQ_A(ntryL,G1H2(312),ex4(:),G1H1(1),m3h2x1(:,280),heltab2x2(:,:,280))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(259),n2h1(269))
  call Hloop_WQ_A(ntryL,G1H2(316),ex4(:),G1H1(1),m3h2x1(:,281),heltab2x2(:,:,281))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(260),n2h1(270))
  call Hloop_WQ_A(ntryL,G1H2(317),ex4(:),G1H1(1),m3h2x1(:,282),heltab2x2(:,:,282))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(261),n2h1(271))
  call Hloop_WQ_A(ntryL,G1H2(318),ex4(:),G1H1(1),m3h2x1(:,283),heltab2x2(:,:,283))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(262),n2h1(272))
  call Hloop_WQ_A(ntryL,G1H2(322),ex4(:),G1H1(1),m3h2x1(:,284),heltab2x2(:,:,284))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(263),n2h1(273))
  call Hloop_ZQ_A(ntryL,G1H2(323),ex4(:),G1H1(1),ngZd,m3h2x1(:,285),heltab2x2(:,:,285))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(264),n2h1(274))
  call Hloop_ZQ_A(ntryL,G1H2(324),ex4(:),G1H1(1),ngZd,m3h2x1(:,286),heltab2x2(:,:,286))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(265),n2h1(275))
  call Hloop_ZQ_A(ntryL,G1H2(328),ex4(:),G1H1(1),ngZd,m3h2x1(:,287),heltab2x2(:,:,287))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(266),n2h1(276))
  call Hloop_VA_Q(ntryL,G1H2(329),ex2(:),G1H1(1),m3h2x1(:,288),heltab2x2(:,:,288))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(267),n2h1(277))
  call Hloop_VA_Q(ntryL,G1H2(330),ex2(:),G1H1(1),m3h2x1(:,289),heltab2x2(:,:,289))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(268),n2h1(278))
  call Hloop_VA_Q(ntryL,G1H2(334),ex2(:),G1H1(1),m3h2x1(:,290),heltab2x2(:,:,290))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(269),n2h1(279))
  call Hloop_ZA_Q(ntryL,G1H2(335),ex2(:),G1H1(1),ngZl,m3h2x1(:,291),heltab2x2(:,:,291))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(270),n2h1(280))
  call Hloop_ZA_Q(ntryL,G1H2(336),ex2(:),G1H1(1),ngZl,m3h2x1(:,292),heltab2x2(:,:,292))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(271),n2h1(281))
  call Hloop_ZA_Q(ntryL,G1H2(340),ex2(:),G1H1(1),ngZl,m3h2x1(:,293),heltab2x2(:,:,293))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(272),n2h1(282))
  call Hloop_WA_Q(ntryL,G1H2(341),ex2(:),G1H1(1),m3h2x1(:,294),heltab2x2(:,:,294))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(273),n2h1(283))
  call Hloop_WA_Q(ntryL,G1H2(342),ex2(:),G1H1(1),m3h2x1(:,295),heltab2x2(:,:,295))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(274),n2h1(284))
  call Hloop_WA_Q(ntryL,G1H2(346),ex2(:),G1H1(1),m3h2x1(:,296),heltab2x2(:,:,296))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(275),n2h1(285))
  call Hloop_VA_Q(ntryL,G1H2(347),ex2(:),G1H1(1),m3h2x1(:,297),heltab2x2(:,:,297))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(276),n2h1(286))
  call Hloop_VA_Q(ntryL,G1H2(348),ex2(:),G1H1(1),m3h2x1(:,298),heltab2x2(:,:,298))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(277),n2h1(287))
  call Hloop_VA_Q(ntryL,G1H2(352),ex2(:),G1H1(1),m3h2x1(:,299),heltab2x2(:,:,299))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(278),n2h1(288))
  call Hloop_ZA_Q(ntryL,G1H2(353),ex2(:),G1H1(1),ngZl,m3h2x1(:,300),heltab2x2(:,:,300))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(279),n2h1(289))
  call Hloop_ZA_Q(ntryL,G1H2(354),ex2(:),G1H1(1),ngZl,m3h2x1(:,301),heltab2x2(:,:,301))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(280),n2h1(290))
  call Hloop_ZA_Q(ntryL,G1H2(358),ex2(:),G1H1(1),ngZl,m3h2x1(:,302),heltab2x2(:,:,302))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(281),n2h1(291))
  call Hloop_WA_Q(ntryL,G1H2(359),ex2(:),G1H1(1),m3h2x1(:,303),heltab2x2(:,:,303))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(282),n2h1(292))
  call Hloop_WA_Q(ntryL,G1H2(360),ex2(:),G1H1(1),m3h2x1(:,304),heltab2x2(:,:,304))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(283),n2h1(293))
  call Hloop_WA_Q(ntryL,G1H2(364),ex2(:),G1H1(1),m3h2x1(:,305),heltab2x2(:,:,305))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(284),n2h1(294))
  call ol_merge_tensors(G2tensor(2),[G1tensor(2)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(8)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(14)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(20)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(26)])
  call ol_merge_tensors(G2tensor(12),[G1tensor(32)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(38)])
  call ol_merge_tensors(G2tensor(16),[G1tensor(44)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(50)])
  call ol_merge_tensors(G2tensor(20),[G1tensor(56)])
  call ol_merge_tensors(G2tensor(22),[G1tensor(62)])
  call ol_merge_tensors(G2tensor(24),[G1tensor(68)])
  call ol_merge_tensors(G2tensor(26),[G1tensor(74)])
  call ol_merge_tensors(G2tensor(28),[G1tensor(80)])
  call ol_merge_tensors(G2tensor(30),[G1tensor(86)])
  call ol_merge_tensors(G2tensor(32),[G1tensor(92)])
  call ol_merge_tensors(G2tensor(34),[G1tensor(98)])
  call ol_merge_tensors(G2tensor(36),[G1tensor(104)])
  call ol_merge_tensors(G2tensor(38),[G1tensor(110)])
  call ol_merge_tensors(G2tensor(40),[G1tensor(116)])
  call ol_merge_tensors(G2tensor(42),[G1tensor(122)])
  call ol_merge_tensors(G2tensor(44),[G1tensor(128)])
  call ol_merge_tensors(G2tensor(46),[G1tensor(134)])
  call ol_merge_tensors(G2tensor(48),[G1tensor(140)])
  call ol_merge_tensors(G2tensor(50),[G1tensor(146)])
  call ol_merge_tensors(G2tensor(52),[G1tensor(152)])
  call ol_merge_tensors(G2tensor(54),[G1tensor(158)])
  call ol_merge_tensors(G2tensor(56),[G1tensor(164)])
  call ol_merge_tensors(G2tensor(58),[G1tensor(170)])
  call ol_merge_tensors(G2tensor(60),[G1tensor(176)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(9),G1tensor(3)])
  call ol_merge_tensors(G2tensor(99),[G1tensor(58),G1tensor(4)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(5)])
  call ol_merge_tensors(G2tensor(102),[G1tensor(6)])
  call ol_merge_tensors(G2tensor(105),[G1tensor(64),G1tensor(10)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(11)])
  call ol_merge_tensors(G2tensor(108),[G1tensor(12)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(21),G1tensor(15)])
  call ol_merge_tensors(G2tensor(111),[G1tensor(70),G1tensor(16)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(17)])
  call ol_merge_tensors(G2tensor(114),[G1tensor(114),G1tensor(18)])
  call ol_merge_tensors(G2tensor(117),[G1tensor(76),G1tensor(22)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(23)])
  call ol_merge_tensors(G2tensor(120),[G1tensor(120),G1tensor(24)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(27)])
  call ol_merge_tensors(G2tensor(123),[G1tensor(82),G1tensor(28)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(29)])
  call ol_merge_tensors(G2tensor(126),[G1tensor(132),G1tensor(30)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(45),G1tensor(33)])
  call ol_merge_tensors(G2tensor(129),[G1tensor(34)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(35)])
  call ol_merge_tensors(G2tensor(132),[G1tensor(90),G1tensor(36)])
  call ol_merge_tensors(G2tensor(21),[G1tensor(51),G1tensor(39)])
  call ol_merge_tensors(G2tensor(135),[G1tensor(40)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(41)])
  call ol_merge_tensors(G2tensor(138),[G1tensor(96),G1tensor(42)])
  call ol_merge_tensors(G2tensor(141),[G1tensor(160),G1tensor(46)])
  call ol_merge_tensors(G2tensor(25),[G1tensor(47)])
  call ol_merge_tensors(G2tensor(144),[G1tensor(102),G1tensor(48)])
  call ol_merge_tensors(G2tensor(147),[G1tensor(166),G1tensor(52)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(53)])
  call ol_merge_tensors(G2tensor(150),[G1tensor(108),G1tensor(54)])
  call ol_merge_tensors(G2tensor(29),[G1tensor(63),G1tensor(57)])
  call ol_merge_tensors(G2tensor(31),[G1tensor(59)])
  call ol_merge_tensors(G2tensor(153),[G1tensor(60)])
  call ol_merge_tensors(G2tensor(33),[G1tensor(65)])
  call ol_merge_tensors(G2tensor(156),[G1tensor(66)])
  call ol_merge_tensors(G2tensor(35),[G1tensor(75),G1tensor(69)])
  call ol_merge_tensors(G2tensor(37),[G1tensor(71)])
  call ol_merge_tensors(G2tensor(159),[G1tensor(138),G1tensor(72)])
  call ol_merge_tensors(G2tensor(39),[G1tensor(77)])
  call ol_merge_tensors(G2tensor(162),[G1tensor(144),G1tensor(78)])
  call ol_merge_tensors(G2tensor(41),[G1tensor(81)])
  call ol_merge_tensors(G2tensor(43),[G1tensor(83)])
  call ol_merge_tensors(G2tensor(165),[G1tensor(156),G1tensor(84)])
  call ol_merge_tensors(G2tensor(45),[G1tensor(99),G1tensor(87)])
  call ol_merge_tensors(G2tensor(168),[G1tensor(88)])
  call ol_merge_tensors(G2tensor(47),[G1tensor(89)])
  call ol_merge_tensors(G2tensor(49),[G1tensor(105),G1tensor(93)])
  call ol_merge_tensors(G2tensor(171),[G1tensor(94)])
  call ol_merge_tensors(G2tensor(51),[G1tensor(95)])
  call ol_merge_tensors(G2tensor(174),[G1tensor(172),G1tensor(100)])
  call ol_merge_tensors(G2tensor(53),[G1tensor(101)])
  call ol_merge_tensors(G2tensor(177),[G1tensor(178),G1tensor(106)])
  call ol_merge_tensors(G2tensor(55),[G1tensor(107)])
  call ol_merge_tensors(G2tensor(57),[G1tensor(117),G1tensor(111)])
  call ol_merge_tensors(G2tensor(180),[G1tensor(136),G1tensor(112)])
  call ol_merge_tensors(G2tensor(59),[G1tensor(113)])
  call ol_merge_tensors(G2tensor(183),[G1tensor(142),G1tensor(118)])
  call ol_merge_tensors(G2tensor(61),[G1tensor(119)])
  call ol_merge_tensors(G2tensor(62),[G1tensor(123)])
  call ol_merge_tensors(G2tensor(186),[G1tensor(148),G1tensor(124)])
  call ol_merge_tensors(G2tensor(63),[G1tensor(131),G1tensor(125)])
  call ol_merge_tensors(G2tensor(189),[G1tensor(126)])
  call ol_merge_tensors(G2tensor(64),[G1tensor(129)])
  call ol_merge_tensors(G2tensor(192),[G1tensor(154),G1tensor(130)])
  call ol_merge_tensors(G2tensor(65),[G1tensor(141),G1tensor(135)])
  call ol_merge_tensors(G2tensor(66),[G1tensor(137)])
  call ol_merge_tensors(G2tensor(67),[G1tensor(143)])
  call ol_merge_tensors(G2tensor(68),[G1tensor(147)])
  call ol_merge_tensors(G2tensor(69),[G1tensor(155),G1tensor(149)])
  call ol_merge_tensors(G2tensor(195),[G1tensor(150)])
  call ol_merge_tensors(G2tensor(70),[G1tensor(153)])
  call ol_merge_tensors(G2tensor(71),[G1tensor(159)])
  call ol_merge_tensors(G2tensor(72),[G1tensor(161)])
  call ol_merge_tensors(G2tensor(198),[G1tensor(174),G1tensor(162)])
  call ol_merge_tensors(G2tensor(73),[G1tensor(165)])
  call ol_merge_tensors(G2tensor(74),[G1tensor(167)])
  call ol_merge_tensors(G2tensor(201),[G1tensor(180),G1tensor(168)])
  call ol_merge_tensors(G2tensor(75),[G1tensor(171)])
  call ol_merge_tensors(G2tensor(76),[G1tensor(173)])
  call ol_merge_tensors(G2tensor(77),[G1tensor(177)])
  call ol_merge_tensors(G2tensor(78),[G1tensor(179)])
  call Hotf_5pt_reduction_last(G2tensor(2),RedSet_5(33),mass5set(:,1),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25),G1tensor(31))
  call G_TensorShift(G1tensor(7),2)
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(33),mass5set(:,2),  & 
G1tensor(37),G1tensor(43),G1tensor(49),G1tensor(55),G1tensor(61),G1tensor(67))
  call G_TensorShift(G1tensor(43),2)
  call Hotf_5pt_reduction_last(G2tensor(6),RedSet_5(33),mass5set(:,24),  & 
G1tensor(73),G1tensor(79),G1tensor(85),G1tensor(91),G1tensor(97),G1tensor(103))
  call G_TensorShift(G1tensor(79),2)
  call Hotf_5pt_reduction_last(G2tensor(8),RedSet_5(33),mass5set(:,25),  & 
G1tensor(109),G1tensor(115),G1tensor(121),G1tensor(127),G1tensor(133),G1tensor(139))
  call G_TensorShift(G1tensor(115),2)
  call Hotf_5pt_reduction_last(G2tensor(10),RedSet_5(33),mass5set(:,7),  & 
G1tensor(145),G1tensor(151),G1tensor(157),G1tensor(163),G1tensor(169),G1tensor(175))
  call G_TensorShift(G1tensor(151),2)
  call Hotf_5pt_reduction_last(G2tensor(12),RedSet_5(11),mass5set(:,1),  & 
G1tensor(2),G1tensor(8),G1tensor(14),G1tensor(20),G1tensor(26),G1tensor(32))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_5pt_reduction_last(G2tensor(14),RedSet_5(11),mass5set(:,24),  & 
G1tensor(38),G1tensor(44),G1tensor(50),G1tensor(56),G1tensor(62),G1tensor(68))
  call G_TensorShift(G1tensor(44),8)
  call Hotf_5pt_reduction_last(G2tensor(16),RedSet_5(11),mass5set(:,2),  & 
G1tensor(74),G1tensor(80),G1tensor(86),G1tensor(92),G1tensor(98),G1tensor(104))
  call G_TensorShift(G1tensor(80),8)
  call Hotf_5pt_reduction_last(G2tensor(18),RedSet_5(11),mass5set(:,25),  & 
G1tensor(110),G1tensor(116),G1tensor(122),G1tensor(128),G1tensor(134),G1tensor(140))
  call G_TensorShift(G1tensor(116),8)
  call Hotf_5pt_reduction_last(G2tensor(20),RedSet_5(34),mass5set(:,1),  & 
G1tensor(146),G1tensor(152),G1tensor(158),G1tensor(164),G1tensor(170),G1tensor(176))
  call G_TensorShift(G1tensor(152),2)
  call Hotf_5pt_reduction_last(G2tensor(22),RedSet_5(34),mass5set(:,2),  & 
G1tensor(9),G1tensor(3),G1tensor(58),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(3),2)
  call Hotf_5pt_reduction_last(G2tensor(24),RedSet_5(34),mass5set(:,24),  & 
G1tensor(64),G1tensor(10),G1tensor(11),G1tensor(12),G1tensor(21),G1tensor(15))
  call G_TensorShift(G1tensor(10),2)
  call Hotf_5pt_reduction_last(G2tensor(26),RedSet_5(34),mass5set(:,25),  & 
G1tensor(70),G1tensor(16),G1tensor(17),G1tensor(114),G1tensor(18),G1tensor(76))
  call G_TensorShift(G1tensor(16),2)
  call Hotf_5pt_reduction_last(G2tensor(28),RedSet_5(34),mass5set(:,7),  & 
G1tensor(22),G1tensor(23),G1tensor(120),G1tensor(24),G1tensor(27),G1tensor(82))
  call G_TensorShift(G1tensor(23),2)
  call Hotf_5pt_reduction_last(G2tensor(30),RedSet_5(12),mass5set(:,1),  & 
G1tensor(28),G1tensor(29),G1tensor(132),G1tensor(30),G1tensor(45),G1tensor(33))
  call G_TensorShift(G1tensor(29),4)
  call Hotf_5pt_reduction_last(G2tensor(32),RedSet_5(12),mass5set(:,24),  & 
G1tensor(34),G1tensor(35),G1tensor(90),G1tensor(36),G1tensor(51),G1tensor(39))
  call G_TensorShift(G1tensor(35),4)
  call Hotf_5pt_reduction_last(G2tensor(34),RedSet_5(12),mass5set(:,2),  & 
G1tensor(40),G1tensor(41),G1tensor(96),G1tensor(42),G1tensor(160),G1tensor(46))
  call G_TensorShift(G1tensor(41),4)
  call Hotf_5pt_reduction_last(G2tensor(36),RedSet_5(12),mass5set(:,25),  & 
G1tensor(47),G1tensor(102),G1tensor(48),G1tensor(166),G1tensor(52),G1tensor(53))
  call G_TensorShift(G1tensor(102),4)
  call Hotf_5pt_reduction_last(G2tensor(38),RedSet_5(35),mass5set(:,24),  & 
G1tensor(108),G1tensor(54),G1tensor(63),G1tensor(57),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(54),1)
  call Hotf_5pt_reduction_last(G2tensor(40),RedSet_5(35),mass5set(:,25),  & 
G1tensor(65),G1tensor(66),G1tensor(75),G1tensor(69),G1tensor(71),G1tensor(138))
  call G_TensorShift(G1tensor(66),1)
  call Hotf_5pt_reduction_last(G2tensor(42),RedSet_5(35),mass5set(:,8),  & 
G1tensor(72),G1tensor(77),G1tensor(144),G1tensor(78),G1tensor(81),G1tensor(83))
  call G_TensorShift(G1tensor(77),1)
  call Hotf_5pt_reduction_last(G2tensor(44),RedSet_5(35),mass5set(:,7),  & 
G1tensor(156),G1tensor(84),G1tensor(99),G1tensor(87),G1tensor(88),G1tensor(89))
  call G_TensorShift(G1tensor(84),1)
  call Hotf_5pt_reduction_last(G2tensor(46),RedSet_5(36),mass5set(:,24),  & 
G1tensor(105),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(172),G1tensor(100))
  call G_TensorShift(G1tensor(93),1)
  call Hotf_5pt_reduction_last(G2tensor(48),RedSet_5(36),mass5set(:,25),  & 
G1tensor(101),G1tensor(178),G1tensor(106),G1tensor(107),G1tensor(117),G1tensor(111))
  call G_TensorShift(G1tensor(178),1)
  call Hotf_5pt_reduction_last(G2tensor(50),RedSet_5(36),mass5set(:,8),  & 
G1tensor(136),G1tensor(112),G1tensor(113),G1tensor(142),G1tensor(118),G1tensor(119))
  call G_TensorShift(G1tensor(112),1)
  call Hotf_5pt_reduction_last(G2tensor(52),RedSet_5(36),mass5set(:,7),  & 
G1tensor(123),G1tensor(148),G1tensor(124),G1tensor(131),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(148),1)
  call Hotf_5pt_reduction_last(G2tensor(54),RedSet_5(13),mass5set(:,2),  & 
G1tensor(129),G1tensor(154),G1tensor(130),G1tensor(141),G1tensor(135),G1tensor(137))
  call G_TensorShift(G1tensor(154),8)
  call Hotf_5pt_reduction_last(G2tensor(56),RedSet_5(13),mass5set(:,25),  & 
G1tensor(143),G1tensor(147),G1tensor(155),G1tensor(149),G1tensor(150),G1tensor(153))
  call G_TensorShift(G1tensor(147),8)
  call Hotf_5pt_reduction_last(G2tensor(58),RedSet_5(14),mass5set(:,2),  & 
G1tensor(159),G1tensor(161),G1tensor(174),G1tensor(162),G1tensor(165),G1tensor(167))
  call G_TensorShift(G1tensor(161),4)
  call Hotf_5pt_reduction_last(G2tensor(60),RedSet_5(14),mass5set(:,25),  & 
G1tensor(180),G1tensor(168),G1tensor(171),G1tensor(173),G1tensor(177),G1tensor(179))
  call G_TensorShift(G1tensor(168),4)
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(37),mass5set(:,9),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
  call G_TensorShift(G1tensor(182),16)
  call Hotf_5pt_reduction_last(G2tensor(99),RedSet_5(15),mass5set(:,9),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
  call G_TensorShift(G1tensor(188),16)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(38),mass5set(:,18),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
  call G_TensorShift(G1tensor(194),16)
  call Hotf_5pt_reduction_last(G2tensor(102),RedSet_5(16),mass5set(:,1),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
  call G_TensorShift(G1tensor(200),16)
  call Hotf_5pt_reduction_last(G2tensor(105),RedSet_5(15),mass5set(:,10),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(206),16)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(38),mass5set(:,19),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
  call G_TensorShift(G1tensor(212),16)
  call Hotf_5pt_reduction_last(G2tensor(108),RedSet_5(16),mass5set(:,2),  & 
G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
  call G_TensorShift(G1tensor(218),16)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(37),mass5set(:,11),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227),G1tensor(228))
  call G_TensorShift(G1tensor(224),16)
  call Hotf_5pt_reduction_last(G2tensor(111),RedSet_5(15),mass5set(:,11),  & 
G1tensor(229),G1tensor(230),G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234))
  call G_TensorShift(G1tensor(230),16)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(38),mass5set(:,20),  & 
G1tensor(235),G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(236),16)
  call Hotf_5pt_reduction_last(G2tensor(114),RedSet_5(16),mass5set(:,12),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245),G1tensor(246))
  call G_TensorShift(G1tensor(242),16)
  call Hotf_5pt_reduction_last(G2tensor(117),RedSet_5(15),mass5set(:,13),  & 
G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250),G1tensor(251),G1tensor(252))
  call G_TensorShift(G1tensor(248),16)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(38),mass5set(:,21),  & 
G1tensor(253),G1tensor(254),G1tensor(255),G1tensor(256),G1tensor(257),G1tensor(258))
  call G_TensorShift(G1tensor(254),16)
  call Hotf_5pt_reduction_last(G2tensor(120),RedSet_5(16),mass5set(:,14),  & 
G1tensor(259),G1tensor(260),G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264))
  call G_TensorShift(G1tensor(260),16)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(37),mass5set(:,22),  & 
G1tensor(265),G1tensor(266),G1tensor(267),G1tensor(268),G1tensor(269),G1tensor(270))
  call G_TensorShift(G1tensor(266),16)
  call Hotf_5pt_reduction_last(G2tensor(123),RedSet_5(15),mass5set(:,15),  & 
G1tensor(271),G1tensor(272),G1tensor(273),G1tensor(274),G1tensor(275),G1tensor(276))
  call G_TensorShift(G1tensor(272),16)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(38),mass5set(:,17),  & 
G1tensor(277),G1tensor(278),G1tensor(279),G1tensor(280),G1tensor(281),G1tensor(282))
  call G_TensorShift(G1tensor(278),16)
  call Hotf_5pt_reduction_last(G2tensor(126),RedSet_5(16),mass5set(:,16),  & 
G1tensor(283),G1tensor(284),G1tensor(285),G1tensor(286),G1tensor(287),G1tensor(288))
  call G_TensorShift(G1tensor(284),16)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(39),mass5set(:,9),  & 
G1tensor(289),G1tensor(290),G1tensor(291),G1tensor(292),G1tensor(293),G1tensor(294))



end subroutine vamp_1

end module ol_vamp_1_pplnjj_ew_neexuxdssx_4_/**/REALKIND
