
module ol_vamp_1_pplnjj_ew_neexuxdag_2_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pplnjj_ew_neexuxdag_2.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pplnjj_ew_neexuxdag_2.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pplnjj_ew_neexuxdag_2_/**/DREALKIND
  use ol_tensor_sum_storage_pplnjj_ew_neexuxdag_2_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pplnjj_ew_neexuxdag_2_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pplnjj_ew_neexuxdag_2_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(23)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,8,2,1,4,16],[0,0,0,nMW,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,1),heltab2x64(:,:,1))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(1),n2h32(1))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,8,2,1,4,16],[0,nMW,0,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,2),heltab2x64(:,:,2))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(2),n2h32(2))
  Gcoeff(:)%j = (c(27)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,8,2,1,4,16],[0,nMZ,0,nMW,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,3),heltab2x64(:,:,3))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(3),n2h32(3))
  Gcoeff(:)%j = (c(23)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,4,1,2,8,16],[0,nMW,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,4),heltab2x64(:,:,4))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(4),n2h32(4))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,4,1,2,8,16],[0,nMZ,0,nMW,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,5),heltab2x64(:,:,5))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(5),n2h32(5))
  Gcoeff(:)%j = (c(27)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,4,1,2,8,16],[0,nMW,0,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,6),heltab2x64(:,:,6))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(6),n2h32(6))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[32,4,1,2,16,8],[0,nMZ,0,nMW,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,7),heltab2x64(:,:,7))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(7),n2h32(7))
  Gcoeff(:)%j = (c(28)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[32,8,1,2,4,16],[0,nMW,0,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,8),heltab2x64(:,:,8))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(8),n2h32(8))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[32,8,1,2,4,16],[0,nMW,0,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,9),heltab2x64(:,:,9))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(9),n2h32(9))
  Gcoeff(:)%j = (c(27)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,8,1,2,4,16],[0,nMZ,0,nMW,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,10),heltab2x64(:,:,10))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(10),n2h32(10))
  Gcoeff(:)%j = (c(28)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[32,4,2,1,8,16],[0,0,0,nMW,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,11),heltab2x64(:,:,11))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(11),n2h32(11))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[32,4,2,1,8,16],[0,nMZ,0,nMW,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,12),heltab2x64(:,:,12))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(12),n2h32(12))
  Gcoeff(:)%j = (c(27)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[32,4,2,1,8,16],[0,nMW,0,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,13),heltab2x64(:,:,13))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(13),n2h32(13))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[32,4,16,2,1,8],[0,nMW,nMW,0,nMZ,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,14),heltab2x64(:,:,14))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(14),n2h32(14))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[32,4,2,1,16,8],[0,0,0,nMW,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,15),heltab2x64(:,:,15))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(15),n2h32(15))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[32,4,2,1,16,8],[0,nMZ,0,nMW,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,16),heltab2x64(:,:,16))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(16),n2h32(16))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[32,4,16,1,2,8],[0,nMW,nMW,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,17),heltab2x64(:,:,17))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(17),n2h32(17))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[32,4,16,1,2,8],[0,nMW,nMW,0,nMZ,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,18),heltab2x64(:,:,18))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(18),n2h32(18))
  Gcoeff(:)%j = (c(27)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[32,4,1,16,2,8],[0,nMW,0,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,19),heltab2x64(:,:,19))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(19),n2h32(19))
  Gcoeff(:)%j = (c(30)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[32,4,1,16,2,8],[0,nMW,0,0,nMZ,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,20),heltab2x64(:,:,20))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(20),n2h32(20))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[32,4,2,16,1,8],[0,0,0,0,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,21),heltab2x64(:,:,21))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(21),n2h32(21))
  Gcoeff(:)%j = (c(30)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[32,4,2,16,1,8],[0,nMZ,0,0,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,22),heltab2x64(:,:,22))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(22),n2h32(22))
  call Hloop_AQ_V(ntryL,G1H32(1),ex4(:),G1H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_AQ_W(ntryL,G1H32(2),ex4(:),G1H16(2),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_AQ_Z(ntryL,G1H32(3),ex4(:),G1H16(3),ngZd,m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_QA_W(ntryL,G1H32(4),ex3(:),G1H16(4),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_QA_Z(ntryL,G1H32(5),ex3(:),G1H16(5),ngZu,m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_QA_W(ntryL,G1H32(6),ex3(:),G1H16(6),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_QA_Z(ntryL,G1H32(7),ex3(:),G1H16(7),ngZu,m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_AQ_W(ntryL,G1H32(8),ex4(:),G1H16(8),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_AQ_W(ntryL,G1H32(9),ex4(:),G1H16(9),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_AQ_Z(ntryL,G1H32(10),ex4(:),G1H16(10),ngZd,m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_QA_V(ntryL,G1H32(11),ex3(:),G1H16(11),m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_QA_Z(ntryL,G1H32(12),ex3(:),G1H16(12),ngZu,m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_QA_W(ntryL,G1H32(13),ex3(:),G1H16(13),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_QA_W(ntryL,G1H32(14),ex3(:),G1H16(14),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_QA_V(ntryL,G1H32(15),ex3(:),G1H16(15),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_QA_Z(ntryL,G1H32(16),ex3(:),G1H16(16),ngZu,m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_QA_W(ntryL,G1H32(17),ex3(:),G1H16(17),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_QA_W(ntryL,G1H32(18),ex3(:),G1H16(18),m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_QA_W(ntryL,G1H32(19),ex3(:),G1H16(19),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_QA_W(ntryL,G1H32(20),ex3(:),G1H16(20),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_QA_V(ntryL,G1H32(21),ex3(:),G1H16(21),m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_QA_Z(ntryL,G1H32(22),ex3(:),G1H16(22),ngZu,m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_VA_Q(ntryL,G1H16(1),ex2(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(1),n2h8(1))
  call Hloop_WA_Q(ntryL,G1H16(2),ex2(:),G1H8(1),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(2),n2h8(2))
  call Hloop_ZA_Q(ntryL,G1H16(3),ex2(:),G1H8(1),ngZl,m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(3),n2h8(3))
  call Hloop_WQ_A(ntryL,G1H16(4),ex1(:),G1H8(1),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(4),n2h8(4))
  call Hloop_ZQ_A(ntryL,G1H16(5),ex1(:),G1H8(1),ngZn,m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(5),n2h8(5))
  call Hloop_WQ_A(ntryL,G1H16(6),ex1(:),G1H8(1),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(6),n2h8(6))
  call Hloop_ZQ_A(ntryL,G1H16(7),ex1(:),G1H8(1),ngZn,m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(7),n2h8(7))
  call Hloop_WQ_A(ntryL,G1H16(8),ex1(:),G1H8(1),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_Q_A(ntryL,G1H8(1),41,0,G2H8(8),n2h8(8))
  call Hloop_WQ_A(ntryL,G1H16(9),ex1(:),G1H8(1),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_Q_A(ntryL,G1H8(1),41,0,G2H8(9),n2h8(9))
  call Hloop_ZQ_A(ntryL,G1H16(10),ex1(:),G1H8(1),ngZn,m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_Q_A(ntryL,G1H8(1),41,0,G2H8(10),n2h8(10))
  call Hloop_VA_Q(ntryL,G1H16(11),ex2(:),G1H8(1),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_A_Q(ntryL,G1H8(1),38,0,G2H8(11),n2h8(11))
  call Hloop_ZA_Q(ntryL,G1H16(12),ex2(:),G1H8(1),ngZl,m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_A_Q(ntryL,G1H8(1),38,0,G2H8(12),n2h8(12))
  call Hloop_WA_Q(ntryL,G1H16(13),ex2(:),G1H8(1),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_A_Q(ntryL,G1H8(1),38,0,G2H8(13),n2h8(13))
  call Hloop_UV_W(ntryL,G1H16(14),36,ex5(:),16,G2H8(14),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_VA_Q(ntryL,G1H16(15),ex2(:),G1H8(1),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_A_Q(ntryL,G1H8(1),38,0,G2H8(15),n2h8(14))
  call Hloop_ZA_Q(ntryL,G1H16(16),ex2(:),G1H8(1),ngZl,m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_A_Q(ntryL,G1H8(1),38,0,G2H8(16),n2h8(15))
  call Hloop_UV_W(ntryL,G1H16(17),36,ex5(:),16,G2H8(17),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_UV_W(ntryL,G1H16(18),36,ex5(:),16,G2H8(18),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_WQ_A(ntryL,G1H16(19),ex1(:),G1H8(1),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(19),n2h8(16))
  call Hloop_WQ_A(ntryL,G1H16(20),ex1(:),G1H8(1),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(20),n2h8(17))
  call Hloop_VA_Q(ntryL,G1H16(21),ex2(:),G1H8(1),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_A_Q(ntryL,G1H8(1),38,0,G2H8(21),n2h8(18))
  call Hloop_ZA_Q(ntryL,G1H16(22),ex2(:),G1H8(1),ngZl,m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_A_Q(ntryL,G1H8(1),38,0,G2H8(22),n2h8(19))
  call Hloop_AQ_W(ntryL,G2H8(1),ex1(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_Z(ntryL,G2H8(2),ex1(:),G2H4(2),ngZn,m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_AQ_W(ntryL,G2H8(3),ex1(:),G2H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_QA_V(ntryL,G2H8(4),ex2(:),G2H4(4),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_QA_W(ntryL,G2H8(5),ex2(:),G2H4(5),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_QA_Z(ntryL,G2H8(6),ex2(:),G2H4(6),ngZl,m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_QA_W(ntryL,G2H8(7),ex2(:),G2H4(7),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_QA_V(ntryL,G2H8(8),ex2(:),G2H4(8),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_QA_Z(ntryL,G2H8(9),ex2(:),G2H4(9),ngZl,m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_QA_W(ntryL,G2H8(10),ex2(:),G2H4(10),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_AQ_W(ntryL,G2H8(11),ex1(:),G2H4(11),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_AQ_W(ntryL,G2H8(12),ex1(:),G2H4(12),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_AQ_Z(ntryL,G2H8(13),ex1(:),G2H4(13),ngZn,m3h2x4(:,13),heltab2x8(:,:,13))
  call Hotf_5pt_reduction(G2H8(14),RedSet_5(1),mass5set(:,1),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),G1H8(6),8)
  call HG1shiftOLR(G1H8(2),8,8)
  call Hloop_AQ_W(ntryL,G2H8(15),ex1(:),G2H4(14),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_AQ_W(ntryL,G2H8(16),ex1(:),G2H4(15),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hotf_5pt_reduction(G2H8(17),RedSet_5(2),mass5set(:,1),  & 
G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),G1H8(12),8)
  call HG1shiftOLR(G1H8(8),8,8)
  call Hotf_5pt_reduction(G2H8(18),RedSet_5(2),mass5set(:,1),  & 
G1H8(13),G1H8(14),G1H8(15),G1H8(16),G1H8(17),G1H8(18),8)
  call HG1shiftOLR(G1H8(14),8,8)
  call Hotf_5pt_reduction(G2H8(19),RedSet_5(3),mass5set(:,2),  & 
G1H8(19),G1H8(20),G1H8(21),G1H8(22),G1H8(23),G1H8(24),8)
  call HG1shiftOLR(G1H8(20),8,8)
  call Hotf_5pt_reduction(G2H8(20),RedSet_5(3),mass5set(:,2),  & 
G1H8(25),G1H8(26),G1H8(27),G1H8(28),G1H8(29),G1H8(30),8)
  call HG1shiftOLR(G1H8(26),8,8)
  call Hotf_5pt_reduction(G2H8(21),RedSet_5(4),mass5set(:,3),  & 
G1H8(31),G1H8(32),G1H8(33),G1H8(34),G1H8(35),G1H8(36),8)
  call HG1shiftOLR(G1H8(32),8,8)
  call Hotf_5pt_reduction(G2H8(22),RedSet_5(4),mass5set(:,4),  & 
G1H8(37),G1H8(38),G1H8(39),G1H8(40),G1H8(41),G1H8(42),8)
  call HG1shiftOLR(G1H8(38),8,8)
  call Hloop_WA_Q(ntryL,G1H8(1),ex2(:),G1H4(1),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(16),n2h4(1))
call HGT_OLR(G1H8(2),1,1,8)
call HGT_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(2),-8,0,G2H8(1),n2h8(20))
  call Hloop_AQ_Z(ntryL,G2H8(1),ex4(:),G2H4(17),ngZd,m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_WA_Q(ntryL,G1H8(5),ex2(:),G1H4(1),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(18),n2h4(2))
  call Hloop_WA_Q(ntryL,G1H8(6),ex2(:),G1H4(1),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(19),n2h4(3))
  call Hloop_WQ_A(ntryL,G1H8(7),ex1(:),G1H4(1),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(20),n2h4(4))
call HGT_OLR(G1H8(8),1,1,8)
call HGT_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(8),-8,0,G2H8(2),n2h8(21))
  call Hloop_AQ_V(ntryL,G2H8(2),ex4(:),G2H4(21),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_WQ_A(ntryL,G1H8(11),ex1(:),G1H4(1),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(22),n2h4(5))
  call Hloop_WQ_A(ntryL,G1H8(12),ex1(:),G1H4(1),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(23),n2h4(6))
  call Hloop_WQ_A(ntryL,G1H8(13),ex1(:),G1H4(1),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(24),n2h4(7))
call HGT_OLR(G1H8(14),1,1,8)
call HGT_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(14),-8,0,G2H8(3),n2h8(22))
  call Hloop_AQ_Z(ntryL,G2H8(3),ex4(:),G2H4(25),ngZd,m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_WQ_A(ntryL,G1H8(17),ex1(:),G1H4(1),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(26),n2h4(8))
  call Hloop_WQ_A(ntryL,G1H8(18),ex1(:),G1H4(1),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(27),n2h4(9))
  call Hloop_QV_A(ntryL,G1H8(19),ex5(:),G1H4(1),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(28),n2h4(10))
call HGT_OLR(G1H8(20),1,1,8)
call HGT_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(20),-8,0,G2H8(4),n2h8(23))
  call Hloop_AQ_V(ntryL,G2H8(4),ex4(:),G2H4(29),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_QV_A(ntryL,G1H8(23),ex5(:),G1H4(1),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(30),n2h4(11))
  call Hloop_QV_A(ntryL,G1H8(24),ex5(:),G1H4(1),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(31),n2h4(12))
  call Hloop_QV_A(ntryL,G1H8(25),ex5(:),G1H4(1),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(32),n2h4(13))
call HGT_OLR(G1H8(26),1,1,8)
call HGT_invQ_OLR(G1H8(26),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(26),-8,0,G2H8(5),n2h8(24))
  call Hloop_AQ_Z(ntryL,G2H8(5),ex4(:),G2H4(33),ngZd,m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_QV_A(ntryL,G1H8(29),ex5(:),G1H4(1),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(34),n2h4(14))
  call Hloop_QV_A(ntryL,G1H8(30),ex5(:),G1H4(1),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(35),n2h4(15))
  call Hloop_AV_Q(ntryL,G1H8(31),ex5(:),G1H4(1),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(36),n2h4(16))
call HGT_OLR(G1H8(32),1,1,8)
call HGT_invQ_OLR(G1H8(32),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(32),-8,0,G2H8(6),n2h8(25))
  call Hloop_AQ_W(ntryL,G2H8(6),ex4(:),G2H4(37),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_AV_Q(ntryL,G1H8(35),ex5(:),G1H4(1),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(38),n2h4(17))
  call Hloop_AV_Q(ntryL,G1H8(36),ex5(:),G1H4(1),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(39),n2h4(18))
  call Hloop_AV_Q(ntryL,G1H8(37),ex5(:),G1H4(1),m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(40),n2h4(19))
call HGT_OLR(G1H8(38),1,1,8)
call HGT_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(38),-8,0,G2H8(7),n2h8(26))
  call Hloop_AQ_W(ntryL,G2H8(7),ex4(:),G2H4(41),m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_AV_Q(ntryL,G1H8(41),ex5(:),G1H4(1),m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(42),n2h4(20))
  call Hloop_AV_Q(ntryL,G1H8(42),ex5(:),G1H4(1),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(43),n2h4(21))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(5),mass5set(:,5),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),16,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(5),mass5set(:,6),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(8),16,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(5),mass5set(:,7),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(14),16,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(6),mass5set(:,2),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
  call HG1shiftOLR(G1H4(20),16,4)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(6),mass5set(:,7),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
  call HG1shiftOLR(G1H4(26),16,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(6),mass5set(:,6),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
  call HG1shiftOLR(G1H4(32),16,4)
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(6),mass5set(:,7),  & 
G1H4(37),G1H4(38),G1H4(39),G1H4(40),G1H4(41),G1H4(42),4)
  call HG1shiftOLR(G1H4(38),8,4)
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(7),mass5set(:,2),  & 
G1H4(43),G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
  call HG1shiftOLR(G1H4(44),16,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(7),mass5set(:,6),  & 
G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),G1H4(54),4)
  call HG1shiftOLR(G1H4(50),16,4)
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(7),mass5set(:,7),  & 
G1H4(55),G1H4(56),G1H4(57),G1H4(58),G1H4(59),G1H4(60),4)
  call HG1shiftOLR(G1H4(56),16,4)
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(8),mass5set(:,5),  & 
G1H4(61),G1H4(62),G1H4(63),G1H4(64),G1H4(65),G1H4(66),4)
  call HG1shiftOLR(G1H4(62),16,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(8),mass5set(:,7),  & 
G1H4(67),G1H4(68),G1H4(69),G1H4(70),G1H4(71),G1H4(72),4)
  call HG1shiftOLR(G1H4(68),16,4)
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(8),mass5set(:,6),  & 
G1H4(73),G1H4(74),G1H4(75),G1H4(76),G1H4(77),G1H4(78),4)
  call HG1shiftOLR(G1H4(74),16,4)
  call Hotf_5pt_reduction(G2H4(14),RedSet_5(8),mass5set(:,5),  & 
G1H4(79),G1H4(80),G1H4(81),G1H4(82),G1H4(83),G1H4(84),4)
  call HG1shiftOLR(G1H4(80),8,4)
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(8),mass5set(:,7),  & 
G1H4(85),G1H4(86),G1H4(87),G1H4(88),G1H4(89),G1H4(90),4)
  call HG1shiftOLR(G1H4(86),8,4)
  call Hloop_AQ_Z(ntryL,G2H4(16),ex1(:),G2H2(1),ngZn,m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_AQ_Z(ntryL,G2H4(19),ex1(:),G2H2(2),ngZn,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_V(ntryL,G2H4(20),ex2(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_V(ntryL,G2H4(23),ex2(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_QA_Z(ntryL,G2H4(24),ex2(:),G2H2(5),ngZl,m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QA_Z(ntryL,G2H4(27),ex2(:),G2H2(6),ngZl,m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_QA_V(ntryL,G2H4(28),ex2(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_QA_V(ntryL,G2H4(31),ex2(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_QA_Z(ntryL,G2H4(32),ex2(:),G2H2(9),ngZl,m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_QA_Z(ntryL,G2H4(35),ex2(:),G2H2(10),ngZl,m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_AQ_W(ntryL,G2H4(36),ex1(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_AQ_W(ntryL,G2H4(39),ex1(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_AQ_W(ntryL,G2H4(40),ex1(:),G2H2(13),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_AQ_W(ntryL,G2H4(43),ex1(:),G2H2(14),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_WA_Q(ntryL,G1H4(1),ex3(:),G1H2(1),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(15),n2h2(1))
call HGT_OLR(G1H4(2),1,1,4)
call HGT_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(2),-16,0,G2H4(1),n2h4(22))
  call Hloop_QV_A(ntryL,G2H4(1),ex5(:),G2H2(16),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_WA_Q(ntryL,G1H4(6),ex3(:),G1H2(1),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(17),n2h2(2))
  call Hloop_ZA_Q(ntryL,G1H4(7),ex3(:),G1H2(1),ngZu,m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(18),n2h2(3))
call HGT_OLR(G1H4(8),1,1,4)
call HGT_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(8),-16,0,G2H4(2),n2h4(23))
  call Hloop_QV_A(ntryL,G2H4(2),ex5(:),G2H2(19),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_ZA_Q(ntryL,G1H4(12),ex3(:),G1H2(1),ngZu,m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(20),n2h2(4))
  call Hloop_WA_Q(ntryL,G1H4(13),ex3(:),G1H2(1),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(21),n2h2(5))
call HGT_OLR(G1H4(14),1,1,4)
call HGT_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(14),-16,0,G2H4(3),n2h4(24))
  call Hloop_QV_A(ntryL,G2H4(3),ex5(:),G2H2(22),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_WA_Q(ntryL,G1H4(18),ex3(:),G1H2(1),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(23),n2h2(6))
  call Hloop_VQ_A(ntryL,G1H4(19),ex4(:),G1H2(1),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(24),n2h2(7))
call HGT_OLR(G1H4(20),1,1,4)
call HGT_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(20),-16,0,G2H4(4),n2h4(25))
  call Hloop_AV_Q(ntryL,G2H4(4),ex5(:),G2H2(25),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_VQ_A(ntryL,G1H4(24),ex4(:),G1H2(1),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(26),n2h2(8))
  call Hloop_WQ_A(ntryL,G1H4(25),ex4(:),G1H2(1),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(27),n2h2(9))
call HGT_OLR(G1H4(26),1,1,4)
call HGT_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(26),-16,0,G2H4(5),n2h4(26))
  call Hloop_AV_Q(ntryL,G2H4(5),ex5(:),G2H2(28),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_WQ_A(ntryL,G1H4(30),ex4(:),G1H2(1),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(29),n2h2(10))
  call Hloop_ZQ_A(ntryL,G1H4(31),ex4(:),G1H2(1),ngZd,m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(30),n2h2(11))
call HGT_OLR(G1H4(32),1,1,4)
call HGT_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(32),-16,0,G2H4(6),n2h4(27))
  call Hloop_AV_Q(ntryL,G2H4(6),ex5(:),G2H2(31),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_ZQ_A(ntryL,G1H4(36),ex4(:),G1H2(1),ngZd,m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(32),n2h2(12))
  call Hloop_UW_V(ntryL,G1H4(37),39,ex5(:),16,G2H2(33),m3h2x2(:,33),heltab2x4(:,:,33))
call HGT_OLR(G1H4(38),1,1,4)
call HGT_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(38),-8,0,G2H4(7),n2h4(28))
  call Hloop_AQ_W(ntryL,G2H4(7),ex4(:),G2H2(34),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_UW_V(ntryL,G1H4(42),39,ex5(:),16,G2H2(35),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_VA_Q(ntryL,G1H4(43),ex3(:),G1H2(1),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(36),n2h2(13))
call HGT_OLR(G1H4(44),1,1,4)
call HGT_invQ_OLR(G1H4(44),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(44),-16,0,G2H4(8),n2h4(29))
  call Hloop_QV_A(ntryL,G2H4(8),ex5(:),G2H2(37),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_VA_Q(ntryL,G1H4(48),ex3(:),G1H2(1),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(38),n2h2(14))
  call Hloop_ZA_Q(ntryL,G1H4(49),ex3(:),G1H2(1),ngZu,m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(39),n2h2(15))
call HGT_OLR(G1H4(50),1,1,4)
call HGT_invQ_OLR(G1H4(50),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(50),-16,0,G2H4(9),n2h4(30))
  call Hloop_QV_A(ntryL,G2H4(9),ex5(:),G2H2(40),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_ZA_Q(ntryL,G1H4(54),ex3(:),G1H2(1),ngZu,m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(41),n2h2(16))
  call Hloop_WA_Q(ntryL,G1H4(55),ex3(:),G1H2(1),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(42),n2h2(17))
call HGT_OLR(G1H4(56),1,1,4)
call HGT_invQ_OLR(G1H4(56),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(56),-16,0,G2H4(10),n2h4(31))
  call Hloop_QV_A(ntryL,G2H4(10),ex5(:),G2H2(43),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_WA_Q(ntryL,G1H4(60),ex3(:),G1H2(1),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(44),n2h2(18))
  call Hloop_WQ_A(ntryL,G1H4(61),ex4(:),G1H2(1),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(45),n2h2(19))
call HGT_OLR(G1H4(62),1,1,4)
call HGT_invQ_OLR(G1H4(62),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(62),-16,0,G2H4(11),n2h4(32))
  call Hloop_AV_Q(ntryL,G2H4(11),ex5(:),G2H2(46),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_WQ_A(ntryL,G1H4(66),ex4(:),G1H2(1),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(47),n2h2(20))
  call Hloop_WQ_A(ntryL,G1H4(67),ex4(:),G1H2(1),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(48),n2h2(21))
call HGT_OLR(G1H4(68),1,1,4)
call HGT_invQ_OLR(G1H4(68),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(68),-16,0,G2H4(12),n2h4(33))
  call Hloop_AV_Q(ntryL,G2H4(12),ex5(:),G2H2(49),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_WQ_A(ntryL,G1H4(72),ex4(:),G1H2(1),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(50),n2h2(22))
  call Hloop_ZQ_A(ntryL,G1H4(73),ex4(:),G1H2(1),ngZd,m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(51),n2h2(23))
call HGT_OLR(G1H4(74),1,1,4)
call HGT_invQ_OLR(G1H4(74),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(74),-16,0,G2H4(13),n2h4(34))
  call Hloop_AV_Q(ntryL,G2H4(13),ex5(:),G2H2(52),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_ZQ_A(ntryL,G1H4(78),ex4(:),G1H2(1),ngZd,m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(53),n2h2(24))
  call Hloop_UW_V(ntryL,G1H4(79),39,ex5(:),16,G2H2(54),m3h2x2(:,54),heltab2x4(:,:,54))
call HGT_OLR(G1H4(80),1,1,4)
call HGT_invQ_OLR(G1H4(80),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(80),-8,0,G2H4(14),n2h4(35))
  call Hloop_AQ_W(ntryL,G2H4(14),ex4(:),G2H2(55),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_UW_V(ntryL,G1H4(84),39,ex5(:),16,G2H2(56),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_UW_V(ntryL,G1H4(85),39,ex5(:),16,G2H2(57),m3h2x2(:,57),heltab2x4(:,:,57))
call HGT_OLR(G1H4(86),1,1,4)
call HGT_invQ_OLR(G1H4(86),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(86),-8,0,G2H4(15),n2h4(36))
  call Hloop_AQ_W(ntryL,G2H4(15),ex4(:),G2H2(58),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_UW_V(ntryL,G1H4(90),39,ex5(:),16,G2H2(59),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(2),8,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(2),mass5set(:,1),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(8),8,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(2),mass5set(:,1),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),G1H2(18),2)
  call HG1shiftOLR(G1H2(14),8,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(3),mass5set(:,2),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),G1H2(24),2)
  call HG1shiftOLR(G1H2(20),8,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(3),mass5set(:,2),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(26),8,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(4),mass5set(:,3),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(32),8,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(4),mass5set(:,4),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
  call HG1shiftOLR(G1H2(38),8,2)
  call Hotf_5pt_reduction(G2H2(15),RedSet_5(5),mass5set(:,5),  & 
G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),G1H2(48),2)
  call HG1shiftOLR(G1H2(44),16,2)
  call Hotf_5pt_reduction(G2H2(18),RedSet_5(5),mass5set(:,6),  & 
G1H2(49),G1H2(50),G1H2(51),G1H2(52),G1H2(53),G1H2(54),2)
  call HG1shiftOLR(G1H2(50),16,2)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(5),mass5set(:,7),  & 
G1H2(55),G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),2)
  call HG1shiftOLR(G1H2(56),16,2)
  call Hotf_5pt_reduction(G2H2(24),RedSet_5(6),mass5set(:,2),  & 
G1H2(61),G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(62),16,2)
  call Hotf_5pt_reduction(G2H2(27),RedSet_5(6),mass5set(:,7),  & 
G1H2(67),G1H2(68),G1H2(69),G1H2(70),G1H2(71),G1H2(72),2)
  call HG1shiftOLR(G1H2(68),16,2)
  call Hotf_5pt_reduction(G2H2(30),RedSet_5(6),mass5set(:,6),  & 
G1H2(73),G1H2(74),G1H2(75),G1H2(76),G1H2(77),G1H2(78),2)
  call HG1shiftOLR(G1H2(74),16,2)
  call Hotf_5pt_reduction(G2H2(33),RedSet_5(6),mass5set(:,7),  & 
G1H2(79),G1H2(80),G1H2(81),G1H2(82),G1H2(83),G1H2(84),2)
  call HG1shiftOLR(G1H2(80),8,2)
  call Hotf_5pt_reduction(G2H2(36),RedSet_5(7),mass5set(:,2),  & 
G1H2(85),G1H2(86),G1H2(87),G1H2(88),G1H2(89),G1H2(90),2)
  call HG1shiftOLR(G1H2(86),16,2)
  call Hotf_5pt_reduction(G2H2(39),RedSet_5(7),mass5set(:,6),  & 
G1H2(91),G1H2(92),G1H2(93),G1H2(94),G1H2(95),G1H2(96),2)
  call HG1shiftOLR(G1H2(92),16,2)
  call Hotf_5pt_reduction(G2H2(42),RedSet_5(7),mass5set(:,7),  & 
G1H2(97),G1H2(98),G1H2(99),G1H2(100),G1H2(101),G1H2(102),2)
  call HG1shiftOLR(G1H2(98),16,2)
  call Hotf_5pt_reduction(G2H2(45),RedSet_5(8),mass5set(:,5),  & 
G1H2(103),G1H2(104),G1H2(105),G1H2(106),G1H2(107),G1H2(108),2)
  call HG1shiftOLR(G1H2(104),16,2)
  call Hotf_5pt_reduction(G2H2(48),RedSet_5(8),mass5set(:,7),  & 
G1H2(109),G1H2(110),G1H2(111),G1H2(112),G1H2(113),G1H2(114),2)
  call HG1shiftOLR(G1H2(110),16,2)
  call Hotf_5pt_reduction(G2H2(51),RedSet_5(8),mass5set(:,6),  & 
G1H2(115),G1H2(116),G1H2(117),G1H2(118),G1H2(119),G1H2(120),2)
  call HG1shiftOLR(G1H2(116),16,2)
  call Hotf_5pt_reduction(G2H2(54),RedSet_5(8),mass5set(:,5),  & 
G1H2(121),G1H2(122),G1H2(123),G1H2(124),G1H2(125),G1H2(126),2)
  call HG1shiftOLR(G1H2(122),8,2)
  call Hotf_5pt_reduction(G2H2(57),RedSet_5(8),mass5set(:,7),  & 
G1H2(127),G1H2(128),G1H2(129),G1H2(130),G1H2(131),G1H2(132),2)
  call HG1shiftOLR(G1H2(128),8,2)
  call Hloop_ZQ_A(ntryL,G1H2(1),ex4(:),G1H1(1),ngZd,m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(1),n2h1(1))
  call Hloop_ZQ_A(ntryL,G1H2(2),ex4(:),G1H1(1),ngZd,m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(2),n2h1(2))
  call Hloop_VQ_A(ntryL,G1H2(7),ex4(:),G1H1(1),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(3),n2h1(3))
  call Hloop_VQ_A(ntryL,G1H2(8),ex4(:),G1H1(1),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(4),n2h1(4))
  call Hloop_ZQ_A(ntryL,G1H2(13),ex4(:),G1H1(1),ngZd,m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(5),n2h1(5))
  call Hloop_ZQ_A(ntryL,G1H2(14),ex4(:),G1H1(1),ngZd,m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(6),n2h1(6))
  call Hloop_VQ_A(ntryL,G1H2(19),ex4(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(7),n2h1(7))
  call Hloop_VQ_A(ntryL,G1H2(20),ex4(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(8),n2h1(8))
  call Hloop_ZQ_A(ntryL,G1H2(25),ex4(:),G1H1(1),ngZd,m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(9),n2h1(9))
  call Hloop_ZQ_A(ntryL,G1H2(26),ex4(:),G1H1(1),ngZd,m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(10),n2h1(10))
  call Hloop_WQ_A(ntryL,G1H2(31),ex4(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(11))
  call Hloop_WQ_A(ntryL,G1H2(32),ex4(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(12),n2h1(12))
  call Hloop_WQ_A(ntryL,G1H2(37),ex4(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(13))
  call Hloop_WQ_A(ntryL,G1H2(38),ex4(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(14),n2h1(14))
  call Hloop_AV_Q(ntryL,G1H2(43),ex5(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(15))
  call Hloop_AV_Q(ntryL,G1H2(44),ex5(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(16),n2h1(16))
  call Hloop_AV_Q(ntryL,G1H2(49),ex5(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(17),n2h1(17))
  call Hloop_AV_Q(ntryL,G1H2(50),ex5(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(18),n2h1(18))
  call Hloop_AV_Q(ntryL,G1H2(55),ex5(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(19),n2h1(19))
  call Hloop_AV_Q(ntryL,G1H2(56),ex5(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(20),n2h1(20))
  call Hloop_QV_A(ntryL,G1H2(61),ex5(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(21),n2h1(21))
  call Hloop_QV_A(ntryL,G1H2(62),ex5(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(22),n2h1(22))
  call Hloop_QV_A(ntryL,G1H2(67),ex5(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(23),n2h1(23))
  call Hloop_QV_A(ntryL,G1H2(68),ex5(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(24),n2h1(24))
  call Hloop_QV_A(ntryL,G1H2(73),ex5(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(25),n2h1(25))
  call Hloop_QV_A(ntryL,G1H2(74),ex5(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(26),n2h1(26))
  call Hloop_WQ_A(ntryL,G1H2(79),ex4(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(27),n2h1(27))
  call Hloop_WQ_A(ntryL,G1H2(80),ex4(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(28),n2h1(28))
  call Hloop_AV_Q(ntryL,G1H2(85),ex5(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(29),n2h1(29))
  call Hloop_AV_Q(ntryL,G1H2(86),ex5(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(30),n2h1(30))
  call Hloop_AV_Q(ntryL,G1H2(91),ex5(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(31),n2h1(31))
  call Hloop_AV_Q(ntryL,G1H2(92),ex5(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(32),n2h1(32))
  call Hloop_AV_Q(ntryL,G1H2(97),ex5(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(33),n2h1(33))
  call Hloop_AV_Q(ntryL,G1H2(98),ex5(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(34),n2h1(34))
  call Hloop_QV_A(ntryL,G1H2(103),ex5(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(35),n2h1(35))
  call Hloop_QV_A(ntryL,G1H2(104),ex5(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(36),n2h1(36))
  call Hloop_QV_A(ntryL,G1H2(109),ex5(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(37),n2h1(37))
  call Hloop_QV_A(ntryL,G1H2(110),ex5(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(38),n2h1(38))
  call Hloop_QV_A(ntryL,G1H2(115),ex5(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(39),n2h1(39))
  call Hloop_QV_A(ntryL,G1H2(116),ex5(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(40),n2h1(40))
  call Hloop_WQ_A(ntryL,G1H2(121),ex4(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(41),n2h1(41))
  call Hloop_WQ_A(ntryL,G1H2(122),ex4(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(42),n2h1(42))
  call Hloop_WQ_A(ntryL,G1H2(127),ex4(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(43),n2h1(43))
  call Hloop_WQ_A(ntryL,G1H2(128),ex4(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(44),n2h1(44))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(2),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(2),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(3),mass5set(:,2),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),8)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(3),mass5set(:,2),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(4),mass5set(:,3),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),8)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(4),mass5set(:,4),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(5),mass5set(:,5),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),16)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(5),mass5set(:,6),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),16)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(5),mass5set(:,7),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),16)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(6),mass5set(:,2),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),16)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(6),mass5set(:,7),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),16)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(6),mass5set(:,6),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),16)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(6),mass5set(:,7),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),8)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(7),mass5set(:,2),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),16)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(7),mass5set(:,6),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),16)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(7),mass5set(:,7),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),16)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(8),mass5set(:,5),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),16)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(8),mass5set(:,7),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),16)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(8),mass5set(:,6),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),16)
  call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(8),mass5set(:,5),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),8)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(8),mass5set(:,7),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),8)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  call ol_merge_tensors(T1sum(21),[G1tensor(121)])
  call ol_merge_tensors(T1sum(22),[G1tensor(127)])
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[32,3,16,4,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,23),heltab2x64(:,:,23))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(1),n2h32(23))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[32,3,16,4,8],[0,0,0,nMZ,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,24),heltab2x64(:,:,24))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(2),n2h32(24))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[32,3,8,4,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,25),heltab2x64(:,:,25))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(3),n2h32(25))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[32,3,8,4,16],[0,0,nMZ,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,26),heltab2x64(:,:,26))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(4),n2h32(26))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[32,3,16,8,4],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,27),heltab2x64(:,:,27))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(5),n2h32(27))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[32,3,16,8,4],[0,0,0,nMZ,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,28),heltab2x64(:,:,28))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(6),n2h32(28))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[32,4,8,3,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,29),heltab2x64(:,:,29))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(7),n2h32(29))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[32,4,8,3,16],[0,nMZ,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,30),heltab2x64(:,:,30))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(8),n2h32(30))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[32,3,4,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,31),heltab2x64(:,:,31))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(9),n2h32(31))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[32,3,4,8,16],[0,0,nMZ,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,32),heltab2x64(:,:,32))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(10),n2h32(32))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[32,8,4,3,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,33),heltab2x64(:,:,33))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(11),n2h32(33))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(34),h0tab(:,34),[32,8,4,3,16],[0,nMZ,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,34),heltab2x64(:,:,34))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(12),n2h32(34))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(35),h0tab(:,35),[32,4,16,3,8],[0,nMW,nMW,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,35),heltab2x64(:,:,35))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(13),n2h32(35))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(36),h0tab(:,36),[32,4,16,3,8],[0,nMW,nMW,nMZ,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,36),heltab2x64(:,:,36))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(14),n2h32(36))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(37),h0tab(:,37),[32,4,16,3,8],[0,nMW,nMW,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,37),heltab2x64(:,:,37))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(15),n2h32(37))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(38),h0tab(:,38),[32,4,16,3,8],[0,nMW,nMW,nMZ,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,38),heltab2x64(:,:,38))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(16),n2h32(38))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(39),h0tab(:,39),[32,8,3,4,16],[0,nMW,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,39),heltab2x64(:,:,39))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(17),n2h32(39))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(40),h0tab(:,40),[32,8,3,4,16],[0,0,nMW,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,40),heltab2x64(:,:,40))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(18),n2h32(40))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(41),h0tab(:,41),[32,8,3,4,16],[0,nMW,nMZ,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,41),heltab2x64(:,:,41))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(19),n2h32(41))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(42),h0tab(:,42),[32,8,3,4,16],[0,nMZ,nMW,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,42),heltab2x64(:,:,42))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(20),n2h32(42))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(43),h0tab(:,43),[32,4,3,16,8],[0,0,nMW,nMW,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,43),heltab2x64(:,:,43))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(21),n2h32(43))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(44),h0tab(:,44),[32,4,3,16,8],[0,nMZ,nMW,nMW,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,44),heltab2x64(:,:,44))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(22),n2h32(44))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(45),h0tab(:,45),[32,4,3,16,8],[0,0,nMW,nMW,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,45),heltab2x64(:,:,45))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(23),n2h32(45))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(46),h0tab(:,46),[32,4,3,16,8],[0,nMZ,nMW,nMW,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,46),heltab2x64(:,:,46))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(24),n2h32(46))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(47),h0tab(:,47),[32,4,3,8,16],[0,0,nMW,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,47),heltab2x64(:,:,47))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(25),n2h32(47))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(48),h0tab(:,48),[32,4,3,8,16],[0,nMW,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,48),heltab2x64(:,:,48))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(26),n2h32(48))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(49),h0tab(:,49),[32,4,3,8,16],[0,nMZ,nMW,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,49),heltab2x64(:,:,49))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(27),n2h32(49))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(50),h0tab(:,50),[32,4,3,8,16],[0,nMW,nMZ,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,50),heltab2x64(:,:,50))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(28),n2h32(50))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(51),h0tab(:,51),[32,4,1,18,8],[0,nMW,0,0,0],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,51),heltab2x64(:,:,51))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(29),n2h32(51))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(52),h0tab(:,52),[32,4,1,18,8],[0,nMZ,0,nMW,0],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,52),heltab2x64(:,:,52))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(30),n2h32(52))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(53),h0tab(:,53),[32,4,1,18,8],[0,nMW,0,nMZ,0],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,53),heltab2x64(:,:,53))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(31),n2h32(53))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(54),h0tab(:,54),[32,4,18,1,8],[0,0,0,nMW,0],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,54),heltab2x64(:,:,54))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(32),n2h32(54))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(55),h0tab(:,55),[32,4,18,1,8],[0,nMZ,0,nMW,0],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,55),heltab2x64(:,:,55))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(33),n2h32(55))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(56),h0tab(:,56),[32,4,18,1,8],[0,nMW,0,nMZ,0],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,56),heltab2x64(:,:,56))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(34),n2h32(56))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(57),h0tab(:,57),[32,8,1,2,20],[0,nMW,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,57),heltab2x64(:,:,57))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(35),n2h32(57))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(58),h0tab(:,58),[32,8,1,2,20],[0,nMW,0,nMZ,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,58),heltab2x64(:,:,58))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(36),n2h32(58))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(59),h0tab(:,59),[32,8,1,2,20],[0,nMZ,0,nMW,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,59),heltab2x64(:,:,59))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(37),n2h32(59))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(60),h0tab(:,60),[32,8,2,1,20],[0,0,0,nMW,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,60),heltab2x64(:,:,60))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(38),n2h32(60))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(61),h0tab(:,61),[32,8,2,1,20],[0,nMW,0,nMZ,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,61),heltab2x64(:,:,61))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(39),n2h32(61))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(62),h0tab(:,62),[32,8,2,1,20],[0,nMZ,0,nMW,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,62),heltab2x64(:,:,62))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(40),n2h32(62))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(63),h0tab(:,63),[32,4,1,2,24],[0,nMW,0,0,0],5,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,63),heltab2x64(:,:,63))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(41),n2h32(63))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(64),h0tab(:,64),[32,4,1,2,24],[0,nMZ,0,nMW,0],5,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,64),heltab2x64(:,:,64))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(42),n2h32(64))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(65),h0tab(:,65),[32,4,1,2,24],[0,nMW,0,nMZ,0],5,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,65),heltab2x64(:,:,65))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(43),n2h32(65))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(66),h0tab(:,66),[32,4,2,1,24],[0,0,0,nMW,0],5,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,66),heltab2x64(:,:,66))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(44),n2h32(66))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(67),h0tab(:,67),[32,4,2,1,24],[0,nMZ,0,nMW,0],5,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,67),heltab2x64(:,:,67))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(45),n2h32(67))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(68),h0tab(:,68),[32,4,2,1,24],[0,nMW,0,nMZ,0],5,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,68),heltab2x64(:,:,68))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(46),n2h32(68))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(69),h0tab(:,69),[36,8,1,2,16],[0,nMZ,0,nMW,nMW],5,1,wf4(:,8))
  call Hloop_WA_Q(ntryL,G0H64(1),wf4(:,8),G0H16(1),m3h4x16(:,1),heltab2x64(:,:,69))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(70),h0tab(:,70),[36,2,1,8,16],[0,0,nMW,0,0],5,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,8),G0H16(1),m3h4x16(:,2),heltab2x64(:,:,70))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(71),h0tab(:,71),[36,2,1,8,16],[nMZ,0,nMW,0,0],5,1,wf4(:,8))
  call Hloop_QA_Z(ntryL,G0H64(1),wf4(:,8),G0H16(2),ngZu,m3h4x16(:,3),heltab2x64(:,:,71))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(72),h0tab(:,72),[36,2,1,8,16],[nMW,0,nMZ,0,0],5,1,wf4(:,8))
  call Hloop_QA_W(ntryL,G0H64(1),wf4(:,8),G0H16(3),m3h4x16(:,4),heltab2x64(:,:,72))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(73),h0tab(:,73),[36,8,2,1,16],[0,0,0,nMW,nMW],5,1,wf4(:,8))
  call Hloop_WA_Q(ntryL,G0H64(1),wf4(:,8),G0H16(4),m3h4x16(:,5),heltab2x64(:,:,73))
  call Hloop_A_Q(ntryL,G0H16(4),36,0,G1H16(2),n2h16(2))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(74),h0tab(:,74),[36,8,2,1,16],[0,nMZ,0,nMW,nMW],5,1,wf4(:,8))
  call Hloop_WA_Q(ntryL,G0H64(1),wf4(:,8),G0H16(4),m3h4x16(:,6),heltab2x64(:,:,74))
  call Hloop_A_Q(ntryL,G0H16(4),36,0,G1H16(3),n2h16(3))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(75),h0tab(:,75),[36,2,1,16,8],[0,0,nMW,nMW,0],5,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,8),G0H16(4),m3h4x16(:,7),heltab2x64(:,:,75))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(76),h0tab(:,76),[36,2,1,16,8],[nMZ,0,nMW,nMW,0],5,1,wf4(:,8))
  call Hloop_QA_Z(ntryL,G0H64(1),wf4(:,8),G0H16(5),ngZu,m3h4x16(:,8),heltab2x64(:,:,76))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(77),h0tab(:,77),[36,1,2,8,16],[nMW,0,0,0,0],5,1,wf4(:,8))
  call Hloop_QA_W(ntryL,G0H64(1),wf4(:,8),G0H16(6),m3h4x16(:,9),heltab2x64(:,:,77))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(78),h0tab(:,78),[36,1,2,8,16],[nMZ,0,nMW,0,0],5,1,wf4(:,8))
  call Hloop_QA_Z(ntryL,G0H64(1),wf4(:,8),G0H16(7),ngZu,m3h4x16(:,10),heltab2x64(:,:,78))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(79),h0tab(:,79),[36,1,2,8,16],[nMW,0,nMZ,0,0],5,1,wf4(:,8))
  call Hloop_QA_W(ntryL,G0H64(1),wf4(:,8),G0H16(8),m3h4x16(:,11),heltab2x64(:,:,79))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(80),h0tab(:,80),[36,1,2,16,8],[nMZ,0,nMW,nMW,0],5,1,wf4(:,8))
  call Hloop_QA_Z(ntryL,G0H64(1),wf4(:,8),G0H16(9),ngZu,m3h4x16(:,12),heltab2x64(:,:,80))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(81),h0tab(:,81),[36,2,16,1,8],[0,0,0,nMW,0],5,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,8),G0H16(10),m3h4x16(:,13),heltab2x64(:,:,81))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(82),h0tab(:,82),[36,2,16,1,8],[nMZ,0,0,nMW,0],5,1,wf4(:,8))
  call Hloop_QA_Z(ntryL,G0H64(1),wf4(:,8),G0H16(11),ngZu,m3h4x16(:,14),heltab2x64(:,:,82))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(83),h0tab(:,83),[36,1,16,2,8],[nMW,0,0,0,0],5,1,wf4(:,8))
  call Hloop_QA_W(ntryL,G0H64(1),wf4(:,8),G0H16(12),m3h4x16(:,15),heltab2x64(:,:,83))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(84),h0tab(:,84),[36,1,16,2,8],[nMW,0,0,nMZ,0],5,1,wf4(:,8))
  call Hloop_QA_W(ntryL,G0H64(1),wf4(:,8),G0H16(13),m3h4x16(:,16),heltab2x64(:,:,84))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(85),h0tab(:,85),[40,4,1,2,16],[0,nMZ,0,nMW,nMW],5,1,wf4(:,5))
  call Hloop_WQ_A(ntryL,G0H64(1),wf4(:,5),G0H16(14),m3h4x16(:,17),heltab2x64(:,:,85))
  call Hloop_Q_A(ntryL,G0H16(14),40,0,G1H16(4),n2h16(4))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(86),h0tab(:,86),[40,2,1,4,16],[0,0,nMW,0,0],5,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,5),G0H16(14),m3h4x16(:,18),heltab2x64(:,:,86))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(87),h0tab(:,87),[40,2,1,4,16],[nMW,0,nMZ,0,0],5,1,wf4(:,5))
  call Hloop_AQ_W(ntryL,G0H64(1),wf4(:,5),G0H16(15),m3h4x16(:,19),heltab2x64(:,:,87))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(88),h0tab(:,88),[40,2,1,4,16],[nMZ,0,nMW,0,0],5,1,wf4(:,5))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf4(:,5),G0H16(16),ngZd,m3h4x16(:,20),heltab2x64(:,:,88))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(89),h0tab(:,89),[40,4,2,1,16],[0,0,0,nMW,nMW],5,1,wf4(:,5))
  call Hloop_WQ_A(ntryL,G0H64(1),wf4(:,5),G0H16(17),m3h4x16(:,21),heltab2x64(:,:,89))
  call Hloop_Q_A(ntryL,G0H16(17),40,0,G1H16(5),n2h16(5))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(90),h0tab(:,90),[40,4,2,1,16],[0,nMZ,0,nMW,nMW],5,1,wf4(:,5))
  call Hloop_WQ_A(ntryL,G0H64(1),wf4(:,5),G0H16(17),m3h4x16(:,22),heltab2x64(:,:,90))
  call Hloop_Q_A(ntryL,G0H16(17),40,0,G1H16(6),n2h16(6))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(91),h0tab(:,91),[40,2,1,16,4],[0,0,nMW,nMW,0],5,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,5),G0H16(17),m3h4x16(:,23),heltab2x64(:,:,91))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(92),h0tab(:,92),[40,2,1,16,4],[nMZ,0,nMW,nMW,0],5,1,wf4(:,5))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf4(:,5),G0H16(18),ngZd,m3h4x16(:,24),heltab2x64(:,:,92))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(93),h0tab(:,93),[40,1,2,4,16],[nMW,0,0,0,0],5,1,wf4(:,5))
  call Hloop_AQ_W(ntryL,G0H64(1),wf4(:,5),G0H16(19),m3h4x16(:,25),heltab2x64(:,:,93))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(94),h0tab(:,94),[40,1,2,4,16],[nMW,0,nMZ,0,0],5,1,wf4(:,5))
  call Hloop_AQ_W(ntryL,G0H64(1),wf4(:,5),G0H16(20),m3h4x16(:,26),heltab2x64(:,:,94))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(95),h0tab(:,95),[40,1,2,4,16],[nMZ,0,nMW,0,0],5,1,wf4(:,5))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf4(:,5),G0H16(21),ngZd,m3h4x16(:,27),heltab2x64(:,:,95))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(96),h0tab(:,96),[40,1,2,16,4],[nMZ,0,nMW,nMW,0],5,1,wf4(:,5))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf4(:,5),G0H16(22),ngZd,m3h4x16(:,28),heltab2x64(:,:,96))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(97),h0tab(:,97),[40,2,16,1,4],[0,0,0,nMW,0],5,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,5),G0H16(23),m3h4x16(:,29),heltab2x64(:,:,97))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(98),h0tab(:,98),[40,2,16,1,4],[nMZ,0,0,nMW,0],5,1,wf4(:,5))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf4(:,5),G0H16(24),ngZd,m3h4x16(:,30),heltab2x64(:,:,98))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(99),h0tab(:,99),[40,1,16,2,4],[nMW,0,0,0,0],5,1,wf4(:,5))
  call Hloop_AQ_W(ntryL,G0H64(1),wf4(:,5),G0H16(25),m3h4x16(:,31),heltab2x64(:,:,99))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(100),h0tab(:,100),[40,1,16,2,4],[nMW,0,0,nMZ,0],5,1,wf4(:,5))
  call Hloop_AQ_W(ntryL,G0H64(1),wf4(:,5),G0H16(26),m3h4x16(:,32),heltab2x64(:,:,100))
  call Hloop_QW_A(ntryL,G1H32(1),wf4(:,1),G1H8(1),m3h4x8(:,1),heltab2x32(:,:,23))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(8),n2h8(27))
  call Hloop_QW_A(ntryL,G1H32(2),wf4(:,1),G1H8(2),m3h4x8(:,2),heltab2x32(:,:,24))
  call Hloop_Q_A(ntryL,G1H8(2),35,0,G2H8(9),n2h8(28))
  call Hloop_AW_Q(ntryL,G1H32(3),wf4(:,1),G1H8(5),m3h4x8(:,3),heltab2x32(:,:,25))
  call Hloop_A_Q(ntryL,G1H8(5),35,0,G2H8(10),n2h8(29))
  call Hloop_AW_Q(ntryL,G1H32(4),wf4(:,1),G1H8(6),m3h4x8(:,4),heltab2x32(:,:,26))
  call Hloop_A_Q(ntryL,G1H8(6),35,0,G2H8(11),n2h8(30))
  call Hloop_AW_Q(ntryL,G1H32(5),wf4(:,1),G1H8(7),m3h4x8(:,5),heltab2x32(:,:,27))
  call Hloop_A_Q(ntryL,G1H8(7),35,0,G2H8(12),n2h8(31))
  call Hloop_AW_Q(ntryL,G1H32(6),wf4(:,1),G1H8(8),m3h4x8(:,6),heltab2x32(:,:,28))
  call Hloop_A_Q(ntryL,G1H8(8),35,0,G2H8(13),n2h8(32))
  call Hloop_QA_V(ntryL,G1H32(7),ex3(:),G1H16(7),m3h2x16(:,23),heltab2x32(:,:,29))
  call Hloop_QA_Z(ntryL,G1H32(8),ex3(:),G1H16(8),ngZu,m3h2x16(:,24),heltab2x32(:,:,30))
  call Hloop_QW_A(ntryL,G1H32(9),wf4(:,1),G1H8(11),m3h4x8(:,7),heltab2x32(:,:,31))
  call Hloop_Q_A(ntryL,G1H8(11),35,0,G2H8(14),n2h8(33))
  call Hloop_QW_A(ntryL,G1H32(10),wf4(:,1),G1H8(12),m3h4x8(:,8),heltab2x32(:,:,32))
  call Hloop_Q_A(ntryL,G1H8(12),35,0,G2H8(15),n2h8(34))
  call Hloop_AQ_V(ntryL,G1H32(11),ex4(:),G1H16(9),m3h2x16(:,25),heltab2x32(:,:,33))
  call Hloop_AQ_Z(ntryL,G1H32(12),ex4(:),G1H16(10),ngZd,m3h2x16(:,26),heltab2x32(:,:,34))
  call Hloop_QA_W(ntryL,G1H32(13),ex3(:),G1H16(11),m3h2x16(:,27),heltab2x32(:,:,35))
  call Hloop_QA_W(ntryL,G1H32(14),ex3(:),G1H16(12),m3h2x16(:,28),heltab2x32(:,:,36))
  call Hloop_QA_W(ntryL,G1H32(15),ex3(:),G1H16(13),m3h2x16(:,29),heltab2x32(:,:,37))
  call Hloop_QA_W(ntryL,G1H32(16),ex3(:),G1H16(14),m3h2x16(:,30),heltab2x32(:,:,38))
  call Hloop_AQ_W(ntryL,G1H32(17),ex4(:),G1H16(15),m3h2x16(:,31),heltab2x32(:,:,39))
  call Hloop_AQ_V(ntryL,G1H32(18),ex4(:),G1H16(16),m3h2x16(:,32),heltab2x32(:,:,40))
  call Hloop_AQ_W(ntryL,G1H32(19),ex4(:),G1H16(17),m3h2x16(:,33),heltab2x32(:,:,41))
  call Hloop_AQ_Z(ntryL,G1H32(20),ex4(:),G1H16(18),ngZd,m3h2x16(:,34),heltab2x32(:,:,42))
  call Hloop_QA_V(ntryL,G1H32(21),ex3(:),G1H16(19),m3h2x16(:,35),heltab2x32(:,:,43))
  call Hloop_QA_Z(ntryL,G1H32(22),ex3(:),G1H16(20),ngZu,m3h2x16(:,36),heltab2x32(:,:,44))
  call Hloop_QA_V(ntryL,G1H32(23),ex3(:),G1H16(21),m3h2x16(:,37),heltab2x32(:,:,45))
  call Hloop_QA_Z(ntryL,G1H32(24),ex3(:),G1H16(22),ngZu,m3h2x16(:,38),heltab2x32(:,:,46))
  call Hloop_QA_V(ntryL,G1H32(25),ex3(:),G1H16(23),m3h2x16(:,39),heltab2x32(:,:,47))
  call Hloop_QA_W(ntryL,G1H32(26),ex3(:),G1H16(24),m3h2x16(:,40),heltab2x32(:,:,48))
  call Hloop_QA_Z(ntryL,G1H32(27),ex3(:),G1H16(25),ngZu,m3h2x16(:,41),heltab2x32(:,:,49))
  call Hloop_QA_W(ntryL,G1H32(28),ex3(:),G1H16(26),m3h2x16(:,42),heltab2x32(:,:,50))
  call Hloop_QA_W(ntryL,G1H32(29),ex3(:),G1H16(27),m3h2x16(:,43),heltab2x32(:,:,51))
  call Hloop_QA_Z(ntryL,G1H32(30),ex3(:),G1H16(28),ngZu,m3h2x16(:,44),heltab2x32(:,:,52))
  call Hloop_QA_W(ntryL,G1H32(31),ex3(:),G1H16(29),m3h2x16(:,45),heltab2x32(:,:,53))
  call Hloop_QA_V(ntryL,G1H32(32),ex3(:),G1H16(30),m3h2x16(:,46),heltab2x32(:,:,54))
  call Hloop_QA_Z(ntryL,G1H32(33),ex3(:),G1H16(31),ngZu,m3h2x16(:,47),heltab2x32(:,:,55))
  call Hloop_QA_W(ntryL,G1H32(34),ex3(:),G1H16(32),m3h2x16(:,48),heltab2x32(:,:,56))
  call Hloop_AQ_W(ntryL,G1H32(35),ex4(:),G1H16(33),m3h2x16(:,49),heltab2x32(:,:,57))
  call Hloop_AQ_W(ntryL,G1H32(36),ex4(:),G1H16(34),m3h2x16(:,50),heltab2x32(:,:,58))
  call Hloop_AQ_Z(ntryL,G1H32(37),ex4(:),G1H16(35),ngZd,m3h2x16(:,51),heltab2x32(:,:,59))
  call Hloop_AQ_V(ntryL,G1H32(38),ex4(:),G1H16(36),m3h2x16(:,52),heltab2x32(:,:,60))
  call Hloop_AQ_W(ntryL,G1H32(39),ex4(:),G1H16(37),m3h2x16(:,53),heltab2x32(:,:,61))
  call Hloop_AQ_Z(ntryL,G1H32(40),ex4(:),G1H16(38),ngZd,m3h2x16(:,54),heltab2x32(:,:,62))
  call Hloop_QA_W(ntryL,G1H32(41),ex3(:),G1H16(39),m3h2x16(:,55),heltab2x32(:,:,63))
  call Hloop_QA_Z(ntryL,G1H32(42),ex3(:),G1H16(40),ngZu,m3h2x16(:,56),heltab2x32(:,:,64))
  call Hloop_QA_W(ntryL,G1H32(43),ex3(:),G1H16(41),m3h2x16(:,57),heltab2x32(:,:,65))
  call Hloop_QA_V(ntryL,G1H32(44),ex3(:),G1H16(42),m3h2x16(:,58),heltab2x32(:,:,66))
  call Hloop_QA_Z(ntryL,G1H32(45),ex3(:),G1H16(43),ngZu,m3h2x16(:,59),heltab2x32(:,:,67))
  call Hloop_QA_W(ntryL,G1H32(46),ex3(:),G1H16(44),m3h2x16(:,60),heltab2x32(:,:,68))
  call Hloop_AQ_Z(ntryL,G1H16(1),ex4(:),G1H8(13),ngZd,m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_VA_Q(ntryL,G0H16(1),ex2(:),G0H8(1),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_A_Q(ntryL,G0H8(1),38,0,G1H8(14),n2h8(35))
  call Hloop_ZA_Q(ntryL,G0H16(2),ex2(:),G0H8(1),ngZl,m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_A_Q(ntryL,G0H8(1),38,0,G1H8(17),n2h8(36))
  call Hloop_WA_Q(ntryL,G0H16(3),ex2(:),G0H8(1),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_A_Q(ntryL,G0H8(1),38,0,G1H8(18),n2h8(37))
  call Hloop_AQ_V(ntryL,G1H16(2),ex4(:),G1H8(19),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_AQ_Z(ntryL,G1H16(3),ex4(:),G1H8(20),ngZd,m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_VA_Q(ntryL,G0H16(4),ex2(:),G0H8(1),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_A_Q(ntryL,G0H8(1),38,0,G1H8(23),n2h8(38))
  call Hloop_ZA_Q(ntryL,G0H16(5),ex2(:),G0H8(1),ngZl,m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_A_Q(ntryL,G0H8(1),38,0,G1H8(24),n2h8(39))
  call Hloop_WQ_A(ntryL,G0H16(6),ex1(:),G0H8(1),m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_Q_A(ntryL,G0H8(1),37,0,G1H8(25),n2h8(40))
  call Hloop_ZQ_A(ntryL,G0H16(7),ex1(:),G0H8(1),ngZn,m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_Q_A(ntryL,G0H8(1),37,0,G1H8(26),n2h8(41))
  call Hloop_WQ_A(ntryL,G0H16(8),ex1(:),G0H8(1),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_Q_A(ntryL,G0H8(1),37,0,G1H8(29),n2h8(42))
  call Hloop_ZQ_A(ntryL,G0H16(9),ex1(:),G0H8(1),ngZn,m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_Q_A(ntryL,G0H8(1),37,0,G1H8(30),n2h8(43))
  call Hloop_VA_Q(ntryL,G0H16(10),ex2(:),G0H8(1),m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_A_Q(ntryL,G0H8(1),38,0,G1H8(31),n2h8(44))
  call Hloop_ZA_Q(ntryL,G0H16(11),ex2(:),G0H8(1),ngZl,m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_A_Q(ntryL,G0H8(1),38,0,G1H8(32),n2h8(45))
  call Hloop_WQ_A(ntryL,G0H16(12),ex1(:),G0H8(1),m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_Q_A(ntryL,G0H8(1),37,0,G1H8(35),n2h8(46))
  call Hloop_WQ_A(ntryL,G0H16(13),ex1(:),G0H8(1),m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_Q_A(ntryL,G0H8(1),37,0,G1H8(36),n2h8(47))
  call Hloop_QA_Z(ntryL,G1H16(4),ex3(:),G1H8(37),ngZu,m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_VA_Q(ntryL,G0H16(14),ex2(:),G0H8(1),m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_A_Q(ntryL,G0H8(1),42,0,G1H8(38),n2h8(48))
  call Hloop_WA_Q(ntryL,G0H16(15),ex2(:),G0H8(1),m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_A_Q(ntryL,G0H8(1),42,0,G1H8(41),n2h8(49))
  call Hloop_ZA_Q(ntryL,G0H16(16),ex2(:),G0H8(1),ngZl,m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_A_Q(ntryL,G0H8(1),42,0,G1H8(42),n2h8(50))
  call Hloop_QA_V(ntryL,G1H16(5),ex3(:),G1H8(1),m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_QA_Z(ntryL,G1H16(6),ex3(:),G1H8(2),ngZu,m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_VA_Q(ntryL,G0H16(17),ex2(:),G0H8(1),m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_A_Q(ntryL,G0H8(1),42,0,G1H8(5),n2h8(51))
  call Hloop_ZA_Q(ntryL,G0H16(18),ex2(:),G0H8(1),ngZl,m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_A_Q(ntryL,G0H8(1),42,0,G1H8(6),n2h8(52))
  call Hloop_WQ_A(ntryL,G0H16(19),ex1(:),G0H8(1),m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_Q_A(ntryL,G0H8(1),41,0,G1H8(7),n2h8(53))
  call Hloop_WQ_A(ntryL,G0H16(20),ex1(:),G0H8(1),m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_Q_A(ntryL,G0H8(1),41,0,G1H8(8),n2h8(54))
  call Hloop_ZQ_A(ntryL,G0H16(21),ex1(:),G0H8(1),ngZn,m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_Q_A(ntryL,G0H8(1),41,0,G1H8(11),n2h8(55))
  call Hloop_ZQ_A(ntryL,G0H16(22),ex1(:),G0H8(1),ngZn,m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_Q_A(ntryL,G0H8(1),41,0,G1H8(12),n2h8(56))
  call Hloop_VA_Q(ntryL,G0H16(23),ex2(:),G0H8(1),m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_A_Q(ntryL,G0H8(1),42,0,G1H8(43),n2h8(57))
  call Hloop_ZA_Q(ntryL,G0H16(24),ex2(:),G0H8(1),ngZl,m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_A_Q(ntryL,G0H8(1),42,0,G1H8(44),n2h8(58))
  call Hloop_WQ_A(ntryL,G0H16(25),ex1(:),G0H8(1),m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_Q_A(ntryL,G0H8(1),41,0,G1H8(45),n2h8(59))
  call Hloop_WQ_A(ntryL,G0H16(26),ex1(:),G0H8(1),m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_Q_A(ntryL,G0H8(1),41,0,G1H8(46),n2h8(60))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(35),[G1H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(36),[G1H8(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(31),[G1H8(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(40),[G1H8(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(32),[G1H8(39)])
  call Hloop_WA_Q(ntryL,G1H8(3),ex2(:),G1H4(1),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(16),n2h4(37))
  call Hloop_WA_Q(ntryL,G1H8(4),ex2(:),G1H4(2),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_A_Q(ntryL,G1H4(2),54,0,G2H4(19),n2h4(38))
  call Hloop_WQ_A(ntryL,G1H8(9),ex1(:),G1H4(6),m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_Q_A(ntryL,G1H4(6),53,0,G2H4(20),n2h4(39))
  call Hloop_WQ_A(ntryL,G1H8(10),ex1(:),G1H4(7),m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_Q_A(ntryL,G1H4(7),53,0,G2H4(23),n2h4(40))
  call Hloop_WQ_A(ntryL,G1H8(15),ex1(:),G1H4(8),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_Q_A(ntryL,G1H4(8),53,0,G2H4(24),n2h4(41))
  call Hloop_WQ_A(ntryL,G1H8(16),ex1(:),G1H4(12),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_Q_A(ntryL,G1H4(12),53,0,G2H4(27),n2h4(42))
  call Hloop_QV_A(ntryL,G1H8(35),ex5(:),G1H4(13),m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_Q_A(ntryL,G1H4(13),53,0,G2H4(28),n2h4(43))
  call Hloop_QV_A(ntryL,G1H8(22),ex5(:),G1H4(14),m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_Q_A(ntryL,G1H4(14),53,0,G2H4(31),n2h4(44))
  call Hloop_QV_A(ntryL,G1H8(36),ex5(:),G1H4(18),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_Q_A(ntryL,G1H4(18),53,0,G2H4(32),n2h4(45))
  call Hloop_QV_A(ntryL,G1H8(28),ex5(:),G1H4(19),m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_Q_A(ntryL,G1H4(19),53,0,G2H4(35),n2h4(46))
  call Hloop_AV_Q(ntryL,G1H8(31),ex5(:),G1H4(20),m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_A_Q(ntryL,G1H4(20),54,0,G2H4(36),n2h4(47))
  call Hloop_AV_Q(ntryL,G1H8(40),ex5(:),G1H4(24),m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_A_Q(ntryL,G1H4(24),54,0,G2H4(39),n2h4(48))
  call Hloop_AV_Q(ntryL,G1H8(32),ex5(:),G1H4(25),m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_A_Q(ntryL,G1H4(25),54,0,G2H4(40),n2h4(49))
  call Hotf_5pt_reduction(G2H8(8),RedSet_5(9),mass5set(:,3),  & 
G1H8(21),G1H8(27),G1H8(33),G1H8(34),G1H8(39),G1H8(3),8)
  call HG1shiftOLR(G1H8(27),8,8)
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(9),mass5set(:,8),  & 
G1H8(4),G1H8(9),G1H8(10),G1H8(15),G1H8(16),G1H8(35),8)
  call HG1shiftOLR(G1H8(9),8,8)
  call Hloop_AQ_V(ntryL,G2H8(10),ex4(:),G2H4(43),m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_AQ_Z(ntryL,G2H8(11),ex4(:),G2H4(1),ngZd,m3h2x4(:,58),heltab2x8(:,:,58))
  call Hotf_5pt_reduction(G2H8(12),RedSet_5(10),mass5set(:,3),  & 
G1H8(22),G1H8(36),G1H8(28),G1H8(31),G1H8(40),G1H8(32),8)
  call HG1shiftOLR(G1H8(36),4,8)
  call Hotf_5pt_reduction(G2H8(13),RedSet_5(10),mass5set(:,8),  & 
G1H8(47),G1H8(48),G1H8(49),G1H8(50),G1H8(51),G1H8(52),8)
  call HG1shiftOLR(G1H8(48),4,8)
  call Hloop_VQ_A(ntryL,G1H16(7),ex4(:),G1H8(53),m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_Q_A(ntryL,G1H8(53),44,0,G2H8(16),n2h8(61))
  call Hloop_ZQ_A(ntryL,G1H16(8),ex4(:),G1H8(53),ngZd,m3h2x8(:,56),heltab2x16(:,:,56))
  call Hloop_Q_A(ntryL,G1H8(53),44,0,G2H8(17),n2h8(62))
  call Hloop_QA_V(ntryL,G2H8(14),ex3(:),G2H4(2),m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_QA_Z(ntryL,G2H8(15),ex3(:),G2H4(3),ngZu,m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_VA_Q(ntryL,G1H16(9),ex3(:),G1H8(53),m3h2x8(:,57),heltab2x16(:,:,57))
  call Hloop_A_Q(ntryL,G1H8(53),44,0,G2H8(18),n2h8(63))
  call Hloop_ZA_Q(ntryL,G1H16(10),ex3(:),G1H8(53),ngZu,m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_A_Q(ntryL,G1H8(53),44,0,G2H8(19),n2h8(64))
  call Hloop_VV_S(ntryL,G1H16(11),ex5(:),G1H8(53),m3h2x8(:,59),heltab2x16(:,:,59))
  call Hloop_VV_S(ntryL,G1H16(12),ex5(:),G1H8(54),m3h2x8(:,60),heltab2x16(:,:,60))
  call Hloop_UV_W(ntryL,G1H16(13),36,ex5(:),16,G2H8(20),m3h2x8(:,61),heltab2x16(:,:,61))
  call Hloop_UV_W(ntryL,G1H16(14),36,ex5(:),16,G2H8(21),m3h2x8(:,62),heltab2x16(:,:,62))
  call Hloop_UW_V(ntryL,G1H16(15),40,wf4(:,1),3,G2H4(4),m3h4x4(:,1),heltab2x16(:,:,63))
  call Hloop_UV_W(ntryL,G1H16(16),40,wf4(:,1),3,G2H4(5),m3h4x4(:,2),heltab2x16(:,:,64))
  call Hloop_UW_V(ntryL,G1H16(17),40,wf4(:,1),3,G2H4(6),m3h4x4(:,3),heltab2x16(:,:,65))
  call Hloop_UV_W(ntryL,G1H16(18),40,wf4(:,1),3,G2H4(7),m3h4x4(:,4),heltab2x16(:,:,66))
  call Hloop_VV_S(ntryL,G1H16(19),wf4(:,1),G1H4(26),m3h4x4(:,5),heltab2x16(:,:,67))
  call Hloop_VV_S(ntryL,G1H16(20),wf4(:,1),G1H4(30),m3h4x4(:,6),heltab2x16(:,:,68))
  call Hloop_UV_W(ntryL,G1H16(21),36,wf4(:,1),3,G2H4(8),m3h4x4(:,7),heltab2x16(:,:,69))
  call Hloop_UV_W(ntryL,G1H16(22),36,wf4(:,1),3,G2H4(9),m3h4x4(:,8),heltab2x16(:,:,70))
  call Hloop_UV_W(ntryL,G1H16(23),36,wf4(:,1),3,G2H4(10),m3h4x4(:,9),heltab2x16(:,:,71))
  call Hloop_UW_V(ntryL,G1H16(24),36,wf4(:,1),3,G2H4(11),m3h4x4(:,10),heltab2x16(:,:,72))
  call Hloop_UV_W(ntryL,G1H16(25),36,wf4(:,1),3,G2H4(12),m3h4x4(:,11),heltab2x16(:,:,73))
  call Hloop_UW_V(ntryL,G1H16(26),36,wf4(:,1),3,G2H4(13),m3h4x4(:,12),heltab2x16(:,:,74))
  call Hloop_WQ_A(ntryL,G1H16(27),ex1(:),G1H8(55),m3h2x8(:,63),heltab2x16(:,:,75))
  call Hloop_Q_A(ntryL,G1H8(55),37,0,G2H8(22),n2h8(65))
  call Hloop_ZQ_A(ntryL,G1H16(28),ex1(:),G1H8(55),ngZn,m3h2x8(:,64),heltab2x16(:,:,76))
  call Hloop_Q_A(ntryL,G1H8(55),37,0,G2H8(1),n2h8(66))
  call Hloop_WQ_A(ntryL,G1H16(29),ex1(:),G1H8(55),m3h2x8(:,65),heltab2x16(:,:,77))
  call Hloop_Q_A(ntryL,G1H8(55),37,0,G2H8(2),n2h8(67))
  call Hloop_VA_Q(ntryL,G1H16(30),wf4(:,11),G1H4(31),m3h4x4(:,13),heltab2x16(:,:,78))
  call Hloop_A_Q(ntryL,G1H4(31),54,0,G2H4(14),n2h4(50))
  call Hloop_ZA_Q(ntryL,G1H16(31),wf4(:,11),G1H4(32),ngZl,m3h4x4(:,14),heltab2x16(:,:,79))
  call Hloop_A_Q(ntryL,G1H4(32),54,0,G2H4(15),n2h4(51))
  call Hloop_WA_Q(ntryL,G1H16(32),wf4(:,11),G1H4(36),m3h4x4(:,15),heltab2x16(:,:,80))
  call Hloop_A_Q(ntryL,G1H4(36),54,0,G2H4(44),n2h4(52))
  call Hloop_WQ_A(ntryL,G1H16(33),ex1(:),G1H8(55),m3h2x8(:,66),heltab2x16(:,:,81))
  call Hloop_Q_A(ntryL,G1H8(55),41,0,G2H8(3),n2h8(68))
  call Hloop_WQ_A(ntryL,G1H16(34),ex1(:),G1H8(55),m3h2x8(:,67),heltab2x16(:,:,82))
  call Hloop_Q_A(ntryL,G1H8(55),41,0,G2H8(4),n2h8(69))
  call Hloop_ZQ_A(ntryL,G1H16(35),ex1(:),G1H8(55),ngZn,m3h2x8(:,68),heltab2x16(:,:,83))
  call Hloop_Q_A(ntryL,G1H8(55),41,0,G2H8(5),n2h8(70))
  call Hloop_VA_Q(ntryL,G1H16(36),ex2(:),G1H8(55),m3h2x8(:,69),heltab2x16(:,:,84))
  call Hloop_A_Q(ntryL,G1H8(55),42,0,G2H8(6),n2h8(71))
  call Hloop_WA_Q(ntryL,G1H16(37),ex2(:),G1H8(55),m3h2x8(:,70),heltab2x16(:,:,85))
  call Hloop_A_Q(ntryL,G1H8(55),42,0,G2H8(7),n2h8(72))
  call Hloop_ZA_Q(ntryL,G1H16(38),ex2(:),G1H8(55),ngZl,m3h2x8(:,71),heltab2x16(:,:,86))
  call Hloop_A_Q(ntryL,G1H8(55),42,0,G2H8(8),n2h8(73))
  call Hloop_WQ_A(ntryL,G1H16(39),ex1(:),G1H8(55),m3h2x8(:,72),heltab2x16(:,:,87))
  call Hloop_Q_A(ntryL,G1H8(55),37,0,G2H8(9),n2h8(74))
  call Hloop_ZQ_A(ntryL,G1H16(40),ex1(:),G1H8(55),ngZn,m3h2x8(:,73),heltab2x16(:,:,88))
  call Hloop_Q_A(ntryL,G1H8(55),37,0,G2H8(10),n2h8(75))
  call Hloop_WQ_A(ntryL,G1H16(41),ex1(:),G1H8(55),m3h2x8(:,74),heltab2x16(:,:,89))
  call Hloop_Q_A(ntryL,G1H8(55),37,0,G2H8(11),n2h8(76))
  call Hloop_VA_Q(ntryL,G1H16(42),ex2(:),G1H8(55),m3h2x8(:,75),heltab2x16(:,:,90))
  call Hloop_A_Q(ntryL,G1H8(55),38,0,G2H8(12),n2h8(77))
  call Hloop_ZA_Q(ntryL,G1H16(43),ex2(:),G1H8(55),ngZl,m3h2x8(:,76),heltab2x16(:,:,91))
  call Hloop_A_Q(ntryL,G1H8(55),38,0,G2H8(13),n2h8(78))
  call Hloop_WA_Q(ntryL,G1H16(44),ex2(:),G1H8(55),m3h2x8(:,77),heltab2x16(:,:,92))
  call Hloop_A_Q(ntryL,G1H8(55),38,0,G2H8(14),n2h8(79))
  call Hloop_ZQ_A(ntryL,G1H8(13),ex1(:),G1H4(37),ngZn,m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_Q_A(ntryL,G1H4(37),45,0,G2H4(45),n2h4(53))
  call Hloop_AQ_W(ntryL,G1H8(14),ex1(:),G1H4(38),m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_AQ_W(ntryL,G1H8(17),ex1(:),G1H4(42),m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_AQ_Z(ntryL,G1H8(18),ex1(:),G1H4(43),ngZn,m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_VA_Q(ntryL,G1H8(19),ex2(:),G1H4(44),m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_A_Q(ntryL,G1H4(44),46,0,G2H4(46),n2h4(54))
  call Hloop_ZA_Q(ntryL,G1H8(20),ex2(:),G1H4(48),ngZl,m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_A_Q(ntryL,G1H4(48),46,0,G2H4(47),n2h4(55))
  call Hloop_AQ_W(ntryL,G1H8(23),ex1(:),G1H4(49),m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_AQ_W(ntryL,G1H8(24),ex1(:),G1H4(50),m3h2x4(:,68),heltab2x8(:,:,68))
  call Hloop_QA_V(ntryL,G1H8(25),ex2(:),G1H4(54),m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_QA_W(ntryL,G1H8(26),ex2(:),G1H4(55),m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_QA_Z(ntryL,G1H8(29),ex2(:),G1H4(56),ngZl,m3h2x4(:,71),heltab2x8(:,:,71))
  call Hloop_QA_W(ntryL,G1H8(30),ex2(:),G1H4(60),m3h2x4(:,72),heltab2x8(:,:,72))
  call Hloop_ZQ_A(ntryL,G1H8(37),ex1(:),G1H4(61),ngZn,m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_Q_A(ntryL,G1H4(61),45,0,G2H4(48),n2h4(56))
  call Hloop_AQ_W(ntryL,G1H8(38),ex1(:),G1H4(62),m3h2x4(:,74),heltab2x8(:,:,74))
  call Hloop_AQ_Z(ntryL,G1H8(41),ex1(:),G1H4(66),ngZn,m3h2x4(:,75),heltab2x8(:,:,75))
  call Hloop_AQ_W(ntryL,G1H8(42),ex1(:),G1H4(67),m3h2x4(:,76),heltab2x8(:,:,76))
  call Hloop_VA_Q(ntryL,G1H8(1),ex2(:),G1H4(68),m3h2x4(:,77),heltab2x8(:,:,77))
  call Hloop_A_Q(ntryL,G1H4(68),46,0,G2H4(49),n2h4(57))
  call Hloop_ZA_Q(ntryL,G1H8(2),ex2(:),G1H4(72),ngZl,m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_A_Q(ntryL,G1H4(72),46,0,G2H4(50),n2h4(58))
  call Hloop_AQ_W(ntryL,G1H8(5),ex1(:),G1H4(73),m3h2x4(:,79),heltab2x8(:,:,79))
  call Hloop_AQ_W(ntryL,G1H8(6),ex1(:),G1H4(74),m3h2x4(:,80),heltab2x8(:,:,80))
  call Hloop_QA_V(ntryL,G1H8(7),ex2(:),G1H4(78),m3h2x4(:,81),heltab2x8(:,:,81))
  call Hloop_QA_Z(ntryL,G1H8(8),ex2(:),G1H4(79),ngZl,m3h2x4(:,82),heltab2x8(:,:,82))
  call Hloop_QA_W(ntryL,G1H8(11),ex2(:),G1H4(80),m3h2x4(:,83),heltab2x8(:,:,83))
  call Hloop_QA_W(ntryL,G1H8(12),ex2(:),G1H4(84),m3h2x4(:,84),heltab2x8(:,:,84))
  call Hloop_AV_Q(ntryL,G1H8(43),ex5(:),G1H4(85),m3h2x4(:,85),heltab2x8(:,:,85))
  call Hloop_A_Q(ntryL,G1H4(85),58,0,G2H4(51),n2h4(59))
  call Hloop_AV_Q(ntryL,G1H8(44),ex5(:),G1H4(86),m3h2x4(:,86),heltab2x8(:,:,86))
  call Hloop_A_Q(ntryL,G1H4(86),58,0,G2H4(52),n2h4(60))
  call Hloop_QV_A(ntryL,G1H8(45),ex5(:),G1H4(90),m3h2x4(:,87),heltab2x8(:,:,87))
  call Hloop_Q_A(ntryL,G1H4(90),57,0,G2H4(53),n2h4(61))
  call Hloop_QV_A(ntryL,G1H8(46),ex5(:),G1H4(1),m3h2x4(:,88),heltab2x8(:,:,88))
  call Hloop_Q_A(ntryL,G1H4(1),57,0,G2H4(54),n2h4(62))
  call Hloop_QV_A(ntryL,G1H8(21),ex5(:),G1H4(2),m3h2x4(:,89),heltab2x8(:,:,89))
  call Hloop_Q_A(ntryL,G1H4(2),51,0,G2H4(55),n2h4(63))
call HGT_OLR(G1H8(27),1,1,8)
call HGT_invQ_OLR(G1H8(27),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(27),-8,0,G2H8(15),n2h8(80))
  call Hloop_AQ_V(ntryL,G2H8(15),ex4(:),G2H4(56),m3h2x4(:,90),heltab2x8(:,:,90))
  call Hloop_QV_A(ntryL,G1H8(34),ex5(:),G1H4(6),m3h2x4(:,91),heltab2x8(:,:,91))
  call Hloop_Q_A(ntryL,G1H4(6),51,0,G2H4(57),n2h4(64))
  call Hloop_QV_A(ntryL,G1H8(39),ex5(:),G1H4(7),m3h2x4(:,92),heltab2x8(:,:,92))
  call Hloop_Q_A(ntryL,G1H4(7),51,0,G2H4(58),n2h4(65))
  call Hloop_QV_A(ntryL,G1H8(3),ex5(:),G1H4(8),m3h2x4(:,93),heltab2x8(:,:,93))
  call Hloop_Q_A(ntryL,G1H4(8),51,0,G2H4(59),n2h4(66))
  call Hloop_QV_A(ntryL,G1H8(4),ex5(:),G1H4(12),m3h2x4(:,94),heltab2x8(:,:,94))
  call Hloop_Q_A(ntryL,G1H4(12),51,0,G2H4(60),n2h4(67))
call HGT_OLR(G1H8(9),1,1,8)
call HGT_invQ_OLR(G1H8(9),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(9),-8,0,G2H8(15),n2h8(81))
  call Hloop_AQ_Z(ntryL,G2H8(15),ex4(:),G2H4(61),ngZd,m3h2x4(:,95),heltab2x8(:,:,95))
  call Hloop_QV_A(ntryL,G1H8(15),ex5(:),G1H4(13),m3h2x4(:,96),heltab2x8(:,:,96))
  call Hloop_Q_A(ntryL,G1H4(13),51,0,G2H4(62),n2h4(68))
  call Hloop_QV_A(ntryL,G1H8(16),ex5(:),G1H4(14),m3h2x4(:,97),heltab2x8(:,:,97))
  call Hloop_Q_A(ntryL,G1H4(14),51,0,G2H4(63),n2h4(69))
  call Hloop_QV_A(ntryL,G1H8(35),ex5(:),G1H4(18),m3h2x4(:,98),heltab2x8(:,:,98))
  call Hloop_Q_A(ntryL,G1H4(18),51,0,G2H4(64),n2h4(70))
  call Hloop_AV_Q(ntryL,G1H8(22),ex5(:),G1H4(19),m3h2x4(:,99),heltab2x8(:,:,99))
  call Hloop_A_Q(ntryL,G1H4(19),51,0,G2H4(65),n2h4(71))
call HGT_OLR(G1H8(36),1,1,8)
call HGT_invQ_OLR(G1H8(36),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(36),-4,0,G2H8(15),n2h8(82))
  call Hloop_QA_V(ntryL,G2H8(15),ex3(:),G2H4(66),m3h2x4(:,100),heltab2x8(:,:,100))
  call Hloop_AV_Q(ntryL,G1H8(31),ex5(:),G1H4(20),m3h2x4(:,101),heltab2x8(:,:,101))
  call Hloop_A_Q(ntryL,G1H4(20),51,0,G2H4(67),n2h4(72))
  call Hloop_AV_Q(ntryL,G1H8(40),ex5(:),G1H4(24),m3h2x4(:,102),heltab2x8(:,:,102))
  call Hloop_A_Q(ntryL,G1H4(24),51,0,G2H4(68),n2h4(73))
  call Hloop_AV_Q(ntryL,G1H8(32),ex5(:),G1H4(25),m3h2x4(:,103),heltab2x8(:,:,103))
  call Hloop_A_Q(ntryL,G1H4(25),51,0,G2H4(69),n2h4(74))
  call Hloop_AV_Q(ntryL,G1H8(47),ex5(:),G1H4(31),m3h2x4(:,104),heltab2x8(:,:,104))
  call Hloop_A_Q(ntryL,G1H4(31),51,0,G2H4(70),n2h4(75))
call HGT_OLR(G1H8(48),1,1,8)
call HGT_invQ_OLR(G1H8(48),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(48),-4,0,G2H8(15),n2h8(83))
  call Hloop_QA_Z(ntryL,G2H8(15),ex3(:),G2H4(71),ngZu,m3h2x4(:,105),heltab2x8(:,:,105))
  call Hloop_AV_Q(ntryL,G1H8(50),ex5(:),G1H4(32),m3h2x4(:,106),heltab2x8(:,:,106))
  call Hloop_A_Q(ntryL,G1H4(32),51,0,G2H4(72),n2h4(76))
  call Hloop_AV_Q(ntryL,G1H8(51),ex5(:),G1H4(36),m3h2x4(:,107),heltab2x8(:,:,107))
  call Hloop_A_Q(ntryL,G1H4(36),51,0,G2H4(73),n2h4(77))
  call Hloop_AV_Q(ntryL,G1H8(52),ex5(:),G1H4(37),m3h2x4(:,108),heltab2x8(:,:,108))
  call Hloop_A_Q(ntryL,G1H4(37),51,0,G2H4(74),n2h4(78))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(44),[G2H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(30),[G2H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(34),[G2H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(14),[G2H4(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(15),[G2H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(62),[G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(16),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(5),[G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(66),[G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G1H4(53),G1H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(67),[G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G1H4(59),G1H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(54),[G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(55),[G1H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G1H4(71),G1H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(56),[G1H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G1H4(77),G1H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(60),[G1H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G1H4(89),G1H4(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(78),[G1H4(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G1H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(79),[G1H4(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(80),[G1H4(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(38),[G1H4(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(70),[G1H4(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(10),[G1H4(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(42),[G1H4(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(43),[G1H4(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(49),[G1H4(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(88),[G1H4(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G1H4(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(50),[G1H4(87)])
call HGT_lower_alpha_w2_OLR(G2H4(17),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(17),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(17),6,15,4)
  call Hotf_5pt_reduction(G2H4(17),RedSet_5(11),mass5set(:,9),  & 
G1H4(44),G1H4(48),G1H4(61),G1H4(68),G1H4(72),G1H4(85),4)
  call HG1shiftOLR(G1H4(48),1,4)
  call Hloop_AQ_Z(ntryL,G2H4(44),ex1(:),G2H2(1),ngZn,m3h2x2(:,60),heltab2x4(:,:,60))
call HGT_lower_alpha_w2_OLR(G2H4(21),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(21),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(21),6,15,4)
  call Hotf_5pt_reduction(G2H4(21),RedSet_5(12),mass5set(:,1),  & 
G1H4(86),G1H4(90),G1H4(1),G1H4(2),G1H4(6),G1H4(7),4)
  call HG1shiftOLR(G1H4(90),2,4)
  call Hloop_QA_V(ntryL,G2H4(30),ex2(:),G2H2(3),m3h2x2(:,61),heltab2x4(:,:,61))
call HGT_lower_alpha_w2_OLR(G2H4(25),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(25),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(25),6,15,4)
  call Hotf_5pt_reduction(G2H4(25),RedSet_5(12),mass5set(:,9),  & 
G1H4(8),G1H4(12),G1H4(13),G1H4(14),G1H4(18),G1H4(19),4)
  call HG1shiftOLR(G1H4(12),2,4)
  call Hloop_QA_Z(ntryL,G2H4(34),ex2(:),G2H2(5),ngZl,m3h2x2(:,62),heltab2x4(:,:,62))
call HGT_lower_alpha_w2_OLR(G2H4(29),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(29),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(29),6,15,4)
  call Hotf_5pt_reduction(G2H4(29),RedSet_5(13),mass5set(:,2),  & 
G1H4(20),G1H4(24),G1H4(25),G1H4(31),G1H4(32),G1H4(36),4)
  call HG1shiftOLR(G1H4(24),2,4)
call HGT_lower_alpha_w2_OLR(G2H4(33),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(33),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(33),6,15,4)
  call Hotf_5pt_reduction(G2H4(33),RedSet_5(13),mass5set(:,10),  & 
G1H4(37),G1H4(3),G1H4(4),G1H4(5),G1H4(9),G1H4(53),4)
  call HG1shiftOLR(G1H4(3),2,4)
call HGT_lower_alpha_w2_OLR(G2H4(37),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(37),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(37),6,15,4)
  call Hotf_5pt_reduction(G2H4(37),RedSet_5(14),mass5set(:,11),  & 
G1H4(11),G1H4(15),G1H4(59),G1H4(17),G1H4(21),G1H4(23),4)
  call HG1shiftOLR(G1H4(15),1,4)
  call Hloop_AQ_W(ntryL,G2H4(14),ex1(:),G2H2(7),m3h2x2(:,63),heltab2x4(:,:,63))
call HGT_lower_alpha_w2_OLR(G2H4(41),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(41),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(41),6,15,4)
  call Hotf_5pt_reduction(G2H4(41),RedSet_5(14),mass5set(:,12),  & 
G1H4(27),G1H4(71),G1H4(29),G1H4(33),G1H4(77),G1H4(35),4)
  call HG1shiftOLR(G1H4(71),1,4)
  call Hloop_AQ_W(ntryL,G2H4(15),ex1(:),G2H2(9),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_WA_Q(ntryL,G1H4(62),ex3(:),G1H2(1),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(11),n2h2(25))
  call Hloop_WA_Q(ntryL,G1H4(16),ex3(:),G1H2(2),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_A_Q(ntryL,G1H2(2),47,0,G2H2(13),n2h2(26))
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(15),mass5set(:,13),  & 
G1H4(39),G1H4(89),G1H4(41),G1H4(45),G1H4(47),G1H4(51),4)
  call HG1shiftOLR(G1H4(89),16,4)
  call Hloop_ZA_Q(ntryL,G1H4(66),ex3(:),G1H2(7),ngZu,m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_A_Q(ntryL,G1H2(7),47,0,G2H2(15),n2h2(27))
  call Hloop_ZA_Q(ntryL,G1H4(10),ex3(:),G1H2(8),ngZu,m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(8),47,0,G2H2(18),n2h2(28))
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(15),mass5set(:,14),  & 
G1H4(57),G1H4(63),G1H4(64),G1H4(65),G1H4(69),G1H4(75),4)
  call HG1shiftOLR(G1H4(63),16,4)
  call Hloop_WA_Q(ntryL,G1H4(67),ex3(:),G1H2(13),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_A_Q(ntryL,G1H2(13),47,0,G2H2(21),n2h2(29))
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(15),mass5set(:,15),  & 
G1H4(81),G1H4(82),G1H4(83),G1H4(87),G1H4(62),G1H4(16),4)
  call HG1shiftOLR(G1H4(82),16,4)
  call Hloop_VQ_A(ntryL,G1H4(54),ex4(:),G1H2(14),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_Q_A(ntryL,G1H2(14),47,0,G2H2(24),n2h2(30))
  call Hloop_VQ_A(ntryL,G1H4(22),ex4(:),G1H2(19),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_Q_A(ntryL,G1H2(19),47,0,G2H2(27),n2h2(31))
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(16),mass5set(:,2),  & 
G1H4(66),G1H4(10),G1H4(67),G1H4(54),G1H4(22),G1H4(91),4)
  call HG1shiftOLR(G1H4(10),16,4)
  call Hloop_WQ_A(ntryL,G1H4(55),ex4(:),G1H2(20),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_Q_A(ntryL,G1H2(20),47,0,G2H2(30),n2h2(32))
  call Hloop_WQ_A(ntryL,G1H4(28),ex4(:),G1H2(25),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_Q_A(ntryL,G1H2(25),47,0,G2H2(33),n2h2(33))
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(16),mass5set(:,15),  & 
G1H4(55),G1H4(28),G1H4(92),G1H4(93),G1H4(94),G1H4(95),4)
  call HG1shiftOLR(G1H4(28),16,4)
  call Hloop_ZQ_A(ntryL,G1H4(56),ex4(:),G1H2(26),ngZd,m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_Q_A(ntryL,G1H2(26),47,0,G2H2(36),n2h2(34))
  call Hloop_ZQ_A(ntryL,G1H4(34),ex4(:),G1H2(31),ngZd,m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_Q_A(ntryL,G1H2(31),47,0,G2H2(39),n2h2(35))
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(16),mass5set(:,14),  & 
G1H4(56),G1H4(34),G1H4(96),G1H4(97),G1H4(98),G1H4(99),4)
  call HG1shiftOLR(G1H4(34),16,4)
  call Hloop_UW_V(ntryL,G1H4(60),39,ex5(:),16,G2H2(42),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_UW_V(ntryL,G1H4(40),39,ex5(:),16,G2H2(45),m3h2x2(:,77),heltab2x4(:,:,77))
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(17),mass5set(:,16),  & 
G1H4(60),G1H4(40),G1H4(100),G1H4(101),G1H4(102),G1H4(103),4)
  call HG1shiftOLR(G1H4(40),8,4)
  call Hloop_VA_Q(ntryL,G1H4(78),ex3(:),G1H2(32),m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_A_Q(ntryL,G1H2(32),47,0,G2H2(48),n2h2(36))
  call Hloop_VA_Q(ntryL,G1H4(46),ex3(:),G1H2(37),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_A_Q(ntryL,G1H2(37),47,0,G2H2(51),n2h2(37))
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(15),mass5set(:,2),  & 
G1H4(78),G1H4(46),G1H4(104),G1H4(105),G1H4(106),G1H4(107),4)
  call HG1shiftOLR(G1H4(46),16,4)
  call Hloop_ZA_Q(ntryL,G1H4(79),ex3(:),G1H2(38),ngZu,m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_A_Q(ntryL,G1H2(38),47,0,G2H2(54),n2h2(38))
  call Hloop_ZA_Q(ntryL,G1H4(52),ex3(:),G1H2(43),ngZu,m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_A_Q(ntryL,G1H2(43),47,0,G2H2(57),n2h2(39))
  call Hloop_WA_Q(ntryL,G1H4(80),ex3(:),G1H2(44),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_A_Q(ntryL,G1H2(44),47,0,G2H2(60),n2h2(40))
  call Hloop_WA_Q(ntryL,G1H4(58),ex3(:),G1H2(49),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_A_Q(ntryL,G1H2(49),47,0,G2H2(61),n2h2(41))
  call Hloop_WQ_A(ntryL,G1H4(38),ex4(:),G1H2(50),m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_Q_A(ntryL,G1H2(50),47,0,G2H2(62),n2h2(42))
  call Hloop_WQ_A(ntryL,G1H4(70),ex4(:),G1H2(55),m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_Q_A(ntryL,G1H2(55),47,0,G2H2(63),n2h2(43))
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(16),mass5set(:,13),  & 
G1H4(79),G1H4(52),G1H4(80),G1H4(58),G1H4(38),G1H4(70),4)
  call HG1shiftOLR(G1H4(52),16,4)
  call Hloop_WQ_A(ntryL,G1H4(42),ex4(:),G1H2(56),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_Q_A(ntryL,G1H2(56),47,0,G2H2(64),n2h2(44))
  call Hloop_ZQ_A(ntryL,G1H4(43),ex4(:),G1H2(61),ngZd,m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_Q_A(ntryL,G1H2(61),47,0,G2H2(65),n2h2(45))
  call Hloop_ZQ_A(ntryL,G1H4(76),ex4(:),G1H2(62),ngZd,m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_Q_A(ntryL,G1H2(62),47,0,G2H2(66),n2h2(46))
  call Hloop_UW_V(ntryL,G1H4(49),39,ex5(:),16,G2H2(67),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_UW_V(ntryL,G1H4(88),39,ex5(:),16,G2H2(68),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(17),mass5set(:,17),  & 
G1H4(42),G1H4(43),G1H4(76),G1H4(49),G1H4(88),G1H4(108),4)
  call HG1shiftOLR(G1H4(43),8,4)
  call Hloop_UW_V(ntryL,G1H4(50),39,ex5(:),16,G2H2(69),m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_AQ_Z(ntryL,G2H4(16),ex1(:),G2H2(70),ngZn,m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_AQ_Z(ntryL,G2H4(19),ex1(:),G2H2(71),ngZn,m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_QA_V(ntryL,G2H4(20),ex2(:),G2H2(72),m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_QA_V(ntryL,G2H4(23),ex2(:),G2H2(73),m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_QA_Z(ntryL,G2H4(24),ex2(:),G2H2(74),ngZl,m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_QA_Z(ntryL,G2H4(27),ex2(:),G2H2(75),ngZl,m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_QA_V(ntryL,G2H4(28),ex2(:),G2H2(76),m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_QA_V(ntryL,G2H4(31),ex2(:),G2H2(77),m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_QA_Z(ntryL,G2H4(32),ex2(:),G2H2(78),ngZl,m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_QA_Z(ntryL,G2H4(35),ex2(:),G2H2(79),ngZl,m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_AQ_W(ntryL,G2H4(36),ex1(:),G2H2(80),m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_AQ_W(ntryL,G2H4(39),ex1(:),G2H2(81),m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_AQ_W(ntryL,G2H4(40),ex1(:),G2H2(82),m3h2x2(:,104),heltab2x4(:,:,104))
  call Hotf_5pt_reduction(G2H4(43),RedSet_5(18),mass5set(:,3),  & 
G1H4(50),G1H4(109),G1H4(110),G1H4(111),G1H4(112),G1H4(113),4)
  call HG1shiftOLR(G1H4(109),16,4)
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(18),mass5set(:,18),  & 
G1H4(114),G1H4(115),G1H4(116),G1H4(117),G1H4(118),G1H4(119),4)
  call HG1shiftOLR(G1H4(115),16,4)
  call Hotf_5pt_reduction(G2H8(16),RedSet_5(19),mass5set(:,3),  & 
G1H8(55),G1H8(13),G1H8(14),G1H8(17),G1H8(18),G1H8(19),8)
  call HG1shiftOLR(G1H8(13),16,8)
  call Hotf_5pt_reduction(G2H8(17),RedSet_5(19),mass5set(:,4),  & 
G1H8(20),G1H8(23),G1H8(24),G1H8(25),G1H8(26),G1H8(29),8)
  call HG1shiftOLR(G1H8(23),16,8)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(20),mass5set(:,3),  & 
G1H4(120),G1H4(121),G1H4(122),G1H4(123),G1H4(124),G1H4(125),4)
  call HG1shiftOLR(G1H4(121),16,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(20),mass5set(:,18),  & 
G1H4(126),G1H4(127),G1H4(128),G1H4(129),G1H4(130),G1H4(131),4)
  call HG1shiftOLR(G1H4(127),16,4)
  call Hotf_5pt_reduction(G2H8(18),RedSet_5(21),mass5set(:,3),  & 
G1H8(30),G1H8(37),G1H8(38),G1H8(41),G1H8(42),G1H8(1),8)
  call HG1shiftOLR(G1H8(37),16,8)
  call Hotf_5pt_reduction(G2H8(19),RedSet_5(21),mass5set(:,4),  & 
G1H8(2),G1H8(5),G1H8(6),G1H8(7),G1H8(8),G1H8(11),8)
  call HG1shiftOLR(G1H8(5),16,8)
  call Hloop_SV_V(ntryL,G1H8(53),wf4(:,1),G1H2(67),m3h4x2(:,1),heltab2x8(:,:,109))
  call Hloop_SV_V(ntryL,G1H8(54),wf4(:,1),G1H2(68),m3h4x2(:,2),heltab2x8(:,:,110))
  call Hotf_5pt_reduction(G2H8(20),RedSet_5(22),mass5set(:,1),  & 
G1H8(12),G1H8(43),G1H8(44),G1H8(45),G1H8(46),G1H8(21),8)
  call HG1shiftOLR(G1H8(43),8,8)
  call Hotf_5pt_reduction(G2H8(21),RedSet_5(22),mass5set(:,19),  & 
G1H8(27),G1H8(34),G1H8(39),G1H8(3),G1H8(4),G1H8(9),8)
  call HG1shiftOLR(G1H8(34),8,8)
  call Hloop_SV_V(ntryL,G1H4(26),ex5(:),G1H2(73),m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_SV_V(ntryL,G1H4(30),ex5(:),G1H2(74),m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_QA_V(ntryL,G2H8(22),wf4(:,11),G2H2(83),m3h4x2(:,3),heltab2x8(:,:,111))
  call Hloop_QA_W(ntryL,G2H8(1),wf4(:,11),G2H2(84),m3h4x2(:,4),heltab2x8(:,:,112))
  call Hloop_QA_Z(ntryL,G2H8(2),wf4(:,11),G2H2(85),ngZl,m3h4x2(:,5),heltab2x8(:,:,113))
  call Hloop_QA_V(ntryL,G2H8(3),ex2(:),G2H4(18),m3h2x4(:,109),heltab2x8(:,:,114))
  call Hloop_QA_Z(ntryL,G2H8(4),ex2(:),G2H4(22),ngZl,m3h2x4(:,110),heltab2x8(:,:,115))
  call Hloop_QA_W(ntryL,G2H8(5),ex2(:),G2H4(26),m3h2x4(:,111),heltab2x8(:,:,116))
  call Hloop_AQ_W(ntryL,G2H8(6),ex1(:),G2H4(38),m3h2x4(:,112),heltab2x8(:,:,117))
  call Hloop_AQ_Z(ntryL,G2H8(7),ex1(:),G2H4(42),ngZn,m3h2x4(:,113),heltab2x8(:,:,118))
  call Hloop_AQ_W(ntryL,G2H8(8),ex1(:),G2H4(17),m3h2x4(:,114),heltab2x8(:,:,119))
  call Hloop_QA_V(ntryL,G2H8(9),ex2(:),G2H4(44),m3h2x4(:,115),heltab2x8(:,:,120))
  call Hloop_QA_W(ntryL,G2H8(10),ex2(:),G2H4(21),m3h2x4(:,116),heltab2x8(:,:,121))
  call Hloop_QA_Z(ntryL,G2H8(11),ex2(:),G2H4(30),ngZl,m3h2x4(:,117),heltab2x8(:,:,122))
  call Hloop_AQ_W(ntryL,G2H8(12),ex1(:),G2H4(25),m3h2x4(:,118),heltab2x8(:,:,123))
  call Hloop_AQ_W(ntryL,G2H8(13),ex1(:),G2H4(34),m3h2x4(:,119),heltab2x8(:,:,124))
  call Hloop_AQ_Z(ntryL,G2H8(14),ex1(:),G2H4(29),ngZn,m3h2x4(:,120),heltab2x8(:,:,125))
  call Hloop_QA_W(ntryL,G2H4(45),ex2(:),G2H2(86),m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_AQ_W(ntryL,G2H4(46),ex1(:),G2H2(87),m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_AQ_W(ntryL,G2H4(47),ex1(:),G2H2(88),m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_QA_W(ntryL,G2H4(48),ex2(:),G2H2(89),m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_AQ_W(ntryL,G2H4(49),ex1(:),G2H2(90),m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_AQ_W(ntryL,G2H4(50),ex1(:),G2H2(91),m3h2x2(:,112),heltab2x4(:,:,112))
  call Hloop_UW_V(ntryL,G1H4(73),43,ex5(:),16,G2H2(92),m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_UW_V(ntryL,G1H4(74),43,ex5(:),16,G2H2(93),m3h2x2(:,114),heltab2x4(:,:,114))
  call Hloop_UW_V(ntryL,G1H4(84),43,ex5(:),16,G2H2(94),m3h2x2(:,115),heltab2x4(:,:,115))
  call Hloop_AQ_W(ntryL,G2H4(51),ex1(:),G2H2(95),m3h2x2(:,116),heltab2x4(:,:,116))
  call Hloop_AQ_W(ntryL,G2H4(52),ex1(:),G2H2(96),m3h2x2(:,117),heltab2x4(:,:,117))
  call Hloop_QA_V(ntryL,G2H4(53),ex2(:),G2H2(97),m3h2x2(:,118),heltab2x4(:,:,118))
  call Hloop_QA_Z(ntryL,G2H4(54),ex2(:),G2H2(98),ngZl,m3h2x2(:,119),heltab2x4(:,:,119))
  call Hloop_QA_V(ntryL,G2H4(55),ex3(:),G2H2(99),m3h2x2(:,120),heltab2x4(:,:,120))
  call Hloop_QA_V(ntryL,G2H4(58),ex3(:),G2H2(100),m3h2x2(:,121),heltab2x4(:,:,121))
  call Hloop_QA_V(ntryL,G2H4(59),ex3(:),G2H2(101),m3h2x2(:,122),heltab2x4(:,:,122))
  call Hloop_QA_Z(ntryL,G2H4(60),ex3(:),G2H2(102),ngZu,m3h2x2(:,123),heltab2x4(:,:,123))
  call Hloop_QA_Z(ntryL,G2H4(63),ex3(:),G2H2(103),ngZu,m3h2x2(:,124),heltab2x4(:,:,124))
  call Hloop_QA_Z(ntryL,G2H4(64),ex3(:),G2H2(104),ngZu,m3h2x2(:,125),heltab2x4(:,:,125))
  call Hloop_AQ_V(ntryL,G2H4(65),ex4(:),G2H2(105),m3h2x2(:,126),heltab2x4(:,:,126))
  call Hloop_AQ_V(ntryL,G2H4(68),ex4(:),G2H2(106),m3h2x2(:,127),heltab2x4(:,:,127))
  call Hloop_AQ_V(ntryL,G2H4(69),ex4(:),G2H2(107),m3h2x2(:,128),heltab2x4(:,:,128))
  call Hloop_AQ_Z(ntryL,G2H4(70),ex4(:),G2H2(108),ngZd,m3h2x2(:,129),heltab2x4(:,:,129))
  call Hloop_AQ_Z(ntryL,G2H4(73),ex4(:),G2H2(109),ngZd,m3h2x2(:,130),heltab2x4(:,:,130))
  call Hloop_AQ_Z(ntryL,G2H4(74),ex4(:),G2H2(110),ngZd,m3h2x2(:,131),heltab2x4(:,:,131))
  call Hloop_WA_Q(ntryL,G1H4(44),ex2(:),G1H2(79),m3h2x2(:,132),heltab2x4(:,:,132))
  call Hloop_A_Q(ntryL,G1H2(79),62,0,G2H2(111),n2h2(47))
call HGT_raise_alpha_OLR(G1H4(48),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(48),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(48),ex1(:),G1H2(80),ngZn,m3h2x2(:,133),heltab2x4(:,:,133))
  call Hloop_WA_Q(ntryL,G1H4(72),ex2(:),G1H2(85),m3h2x2(:,134),heltab2x4(:,:,134))
  call Hloop_A_Q(ntryL,G1H2(85),62,0,G2H2(112),n2h2(48))
  call Hloop_WA_Q(ntryL,G1H4(85),ex2(:),G1H2(86),m3h2x2(:,135),heltab2x4(:,:,135))
  call Hloop_A_Q(ntryL,G1H2(86),62,0,G2H2(113),n2h2(49))
  call Hloop_WQ_A(ntryL,G1H4(86),ex1(:),G1H2(91),m3h2x2(:,136),heltab2x4(:,:,136))
  call Hloop_Q_A(ntryL,G1H2(91),61,0,G2H2(114),n2h2(50))
call HGT_raise_alpha_OLR(G1H4(90),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(90),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(90),ex2(:),G1H2(92),m3h2x2(:,137),heltab2x4(:,:,137))
  call Hloop_WQ_A(ntryL,G1H4(6),ex1(:),G1H2(97),m3h2x2(:,138),heltab2x4(:,:,138))
  call Hloop_Q_A(ntryL,G1H2(97),61,0,G2H2(115),n2h2(51))
  call Hloop_WQ_A(ntryL,G1H4(7),ex1(:),G1H2(98),m3h2x2(:,139),heltab2x4(:,:,139))
  call Hloop_Q_A(ntryL,G1H2(98),61,0,G2H2(116),n2h2(52))
  call Hloop_WQ_A(ntryL,G1H4(8),ex1(:),G1H2(103),m3h2x2(:,140),heltab2x4(:,:,140))
  call Hloop_Q_A(ntryL,G1H2(103),61,0,G2H2(117),n2h2(53))
call HGT_raise_alpha_OLR(G1H4(12),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(12),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(12),ex2(:),G1H2(104),ngZl,m3h2x2(:,141),heltab2x4(:,:,141))
  call Hloop_WQ_A(ntryL,G1H4(18),ex1(:),G1H2(109),m3h2x2(:,142),heltab2x4(:,:,142))
  call Hloop_Q_A(ntryL,G1H2(109),61,0,G2H2(118),n2h2(54))
  call Hloop_WQ_A(ntryL,G1H4(19),ex1(:),G1H2(110),m3h2x2(:,143),heltab2x4(:,:,143))
  call Hloop_Q_A(ntryL,G1H2(110),61,0,G2H2(119),n2h2(55))
  call Hloop_QV_A(ntryL,G1H4(20),ex5(:),G1H2(115),m3h2x2(:,144),heltab2x4(:,:,144))
  call Hloop_Q_A(ntryL,G1H2(115),61,0,G2H2(120),n2h2(56))
call HGT_raise_alpha_OLR(G1H4(24),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(24),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(24),ex2(:),G1H2(116),m3h2x2(:,145),heltab2x4(:,:,145))
  call Hloop_QV_A(ntryL,G1H4(32),ex5(:),G1H2(121),m3h2x2(:,146),heltab2x4(:,:,146))
  call Hloop_Q_A(ntryL,G1H2(121),61,0,G2H2(121),n2h2(57))
  call Hloop_QV_A(ntryL,G1H4(36),ex5(:),G1H2(122),m3h2x2(:,147),heltab2x4(:,:,147))
  call Hloop_Q_A(ntryL,G1H2(122),61,0,G2H2(122),n2h2(58))
  call Hloop_QV_A(ntryL,G1H4(37),ex5(:),G1H2(127),m3h2x2(:,148),heltab2x4(:,:,148))
  call Hloop_Q_A(ntryL,G1H2(127),61,0,G2H2(123),n2h2(59))
call HGT_raise_alpha_OLR(G1H4(3),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(3),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(3),ex2(:),G1H2(128),ngZl,m3h2x2(:,149),heltab2x4(:,:,149))
  call Hloop_QV_A(ntryL,G1H4(9),ex5(:),G1H2(1),m3h2x2(:,150),heltab2x4(:,:,150))
  call Hloop_Q_A(ntryL,G1H2(1),61,0,G2H2(124),n2h2(60))
  call Hloop_QV_A(ntryL,G1H4(53),ex5(:),G1H2(2),m3h2x2(:,151),heltab2x4(:,:,151))
  call Hloop_Q_A(ntryL,G1H2(2),61,0,G2H2(125),n2h2(61))
  call Hloop_AV_Q(ntryL,G1H4(11),ex5(:),G1H2(7),m3h2x2(:,152),heltab2x4(:,:,152))
  call Hloop_A_Q(ntryL,G1H2(7),62,0,G2H2(126),n2h2(62))
call HGT_raise_alpha_OLR(G1H4(15),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(15),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(15),ex1(:),G1H2(8),m3h2x2(:,153),heltab2x4(:,:,153))
  call Hloop_AV_Q(ntryL,G1H4(21),ex5(:),G1H2(13),m3h2x2(:,154),heltab2x4(:,:,154))
  call Hloop_A_Q(ntryL,G1H2(13),62,0,G2H2(127),n2h2(63))
  call Hloop_AV_Q(ntryL,G1H4(23),ex5(:),G1H2(14),m3h2x2(:,155),heltab2x4(:,:,155))
  call Hloop_A_Q(ntryL,G1H2(14),62,0,G2H2(128),n2h2(64))
  call Hloop_AV_Q(ntryL,G1H4(27),ex5(:),G1H2(19),m3h2x2(:,156),heltab2x4(:,:,156))
  call Hloop_A_Q(ntryL,G1H2(19),62,0,G2H2(129),n2h2(65))
call HGT_raise_alpha_OLR(G1H4(71),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(71),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(71),ex1(:),G1H2(20),m3h2x2(:,157),heltab2x4(:,:,157))
  call Hloop_AV_Q(ntryL,G1H4(77),ex5(:),G1H2(25),m3h2x2(:,158),heltab2x4(:,:,158))
  call Hloop_A_Q(ntryL,G1H2(25),62,0,G2H2(130),n2h2(66))
  call Hloop_AV_Q(ntryL,G1H4(35),ex5(:),G1H2(26),m3h2x2(:,159),heltab2x4(:,:,159))
  call Hloop_A_Q(ntryL,G1H2(26),62,0,G2H2(131),n2h2(67))
  call Hloop_WA_Q(ntryL,G1H4(39),ex3(:),G1H2(31),m3h2x2(:,160),heltab2x4(:,:,160))
  call Hloop_A_Q(ntryL,G1H2(31),47,0,G2H2(132),n2h2(68))
call HGT_OLR(G1H4(89),1,1,4)
call HGT_invQ_OLR(G1H4(89),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(89),-16,0,G2H4(33),n2h4(86))
  call Hloop_QV_A(ntryL,G2H4(33),ex5(:),G2H2(133),m3h2x2(:,161),heltab2x4(:,:,161))
  call Hloop_WA_Q(ntryL,G1H4(47),ex3(:),G1H2(32),m3h2x2(:,162),heltab2x4(:,:,162))
  call Hloop_A_Q(ntryL,G1H2(32),47,0,G2H2(134),n2h2(69))
  call Hloop_WA_Q(ntryL,G1H4(51),ex3(:),G1H2(37),m3h2x2(:,163),heltab2x4(:,:,163))
  call Hloop_A_Q(ntryL,G1H2(37),47,0,G2H2(135),n2h2(70))
  call Hloop_ZA_Q(ntryL,G1H4(57),ex3(:),G1H2(38),ngZu,m3h2x2(:,164),heltab2x4(:,:,164))
  call Hloop_A_Q(ntryL,G1H2(38),47,0,G2H2(136),n2h2(71))
call HGT_OLR(G1H4(63),1,1,4)
call HGT_invQ_OLR(G1H4(63),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(63),-16,0,G2H4(37),n2h4(87))
  call Hloop_QV_A(ntryL,G2H4(37),ex5(:),G2H2(137),m3h2x2(:,165),heltab2x4(:,:,165))
  call Hloop_ZA_Q(ntryL,G1H4(69),ex3(:),G1H2(43),ngZu,m3h2x2(:,166),heltab2x4(:,:,166))
  call Hloop_A_Q(ntryL,G1H2(43),47,0,G2H2(138),n2h2(72))
  call Hloop_ZA_Q(ntryL,G1H4(75),ex3(:),G1H2(44),ngZu,m3h2x2(:,167),heltab2x4(:,:,167))
  call Hloop_A_Q(ntryL,G1H2(44),47,0,G2H2(139),n2h2(73))
  call Hloop_WA_Q(ntryL,G1H4(81),ex3(:),G1H2(49),m3h2x2(:,168),heltab2x4(:,:,168))
  call Hloop_A_Q(ntryL,G1H2(49),47,0,G2H2(140),n2h2(74))
call HGT_OLR(G1H4(82),1,1,4)
call HGT_invQ_OLR(G1H4(82),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(82),-16,0,G2H4(14),n2h4(88))
  call Hloop_QV_A(ntryL,G2H4(14),ex5(:),G2H2(141),m3h2x2(:,169),heltab2x4(:,:,169))
  call Hloop_WA_Q(ntryL,G1H4(62),ex3(:),G1H2(50),m3h2x2(:,170),heltab2x4(:,:,170))
  call Hloop_A_Q(ntryL,G1H2(50),47,0,G2H2(142),n2h2(75))
  call Hloop_WA_Q(ntryL,G1H4(16),ex3(:),G1H2(55),m3h2x2(:,171),heltab2x4(:,:,171))
  call Hloop_A_Q(ntryL,G1H2(55),47,0,G2H2(143),n2h2(76))
  call Hloop_VQ_A(ntryL,G1H4(66),ex4(:),G1H2(56),m3h2x2(:,172),heltab2x4(:,:,172))
  call Hloop_Q_A(ntryL,G1H2(56),47,0,G2H2(144),n2h2(77))
call HGT_OLR(G1H4(10),1,1,4)
call HGT_invQ_OLR(G1H4(10),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(10),-16,0,G2H4(41),n2h4(89))
  call Hloop_AV_Q(ntryL,G2H4(41),ex5(:),G2H2(145),m3h2x2(:,173),heltab2x4(:,:,173))
  call Hloop_VQ_A(ntryL,G1H4(22),ex4(:),G1H2(61),m3h2x2(:,174),heltab2x4(:,:,174))
  call Hloop_Q_A(ntryL,G1H2(61),47,0,G2H2(146),n2h2(78))
  call Hloop_VQ_A(ntryL,G1H4(91),ex4(:),G1H2(62),m3h2x2(:,175),heltab2x4(:,:,175))
  call Hloop_Q_A(ntryL,G1H2(62),47,0,G2H2(147),n2h2(79))
  call Hloop_WQ_A(ntryL,G1H4(55),ex4(:),G1H2(79),m3h2x2(:,176),heltab2x4(:,:,176))
  call Hloop_Q_A(ntryL,G1H2(79),47,0,G2H2(148),n2h2(80))
call HGT_OLR(G1H4(28),1,1,4)
call HGT_invQ_OLR(G1H4(28),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(28),-16,0,G2H4(15),n2h4(90))
  call Hloop_AV_Q(ntryL,G2H4(15),ex5(:),G2H2(149),m3h2x2(:,177),heltab2x4(:,:,177))
  call Hloop_WQ_A(ntryL,G1H4(94),ex4(:),G1H2(85),m3h2x2(:,178),heltab2x4(:,:,178))
  call Hloop_Q_A(ntryL,G1H2(85),47,0,G2H2(150),n2h2(81))
  call Hloop_WQ_A(ntryL,G1H4(95),ex4(:),G1H2(86),m3h2x2(:,179),heltab2x4(:,:,179))
  call Hloop_Q_A(ntryL,G1H2(86),47,0,G2H2(151),n2h2(82))
  call Hloop_ZQ_A(ntryL,G1H4(56),ex4(:),G1H2(91),ngZd,m3h2x2(:,180),heltab2x4(:,:,180))
  call Hloop_Q_A(ntryL,G1H2(91),47,0,G2H2(152),n2h2(83))
call HGT_OLR(G1H4(34),1,1,4)
call HGT_invQ_OLR(G1H4(34),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(34),-16,0,G2H4(5),n2h4(91))
  call Hloop_AV_Q(ntryL,G2H4(5),ex5(:),G2H2(153),m3h2x2(:,181),heltab2x4(:,:,181))
  call Hloop_ZQ_A(ntryL,G1H4(98),ex4(:),G1H2(97),ngZd,m3h2x2(:,182),heltab2x4(:,:,182))
  call Hloop_Q_A(ntryL,G1H2(97),47,0,G2H2(154),n2h2(84))
  call Hloop_ZQ_A(ntryL,G1H4(99),ex4(:),G1H2(98),ngZd,m3h2x2(:,183),heltab2x4(:,:,183))
  call Hloop_Q_A(ntryL,G1H2(98),47,0,G2H2(155),n2h2(85))
  call Hloop_UW_V(ntryL,G1H4(60),39,ex5(:),16,G2H2(156),m3h2x2(:,184),heltab2x4(:,:,184))
call HGT_OLR(G1H4(40),1,1,4)
call HGT_invQ_OLR(G1H4(40),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(40),-8,0,G2H4(6),n2h4(92))
  call Hloop_AQ_W(ntryL,G2H4(6),ex4(:),G2H2(157),m3h2x2(:,185),heltab2x4(:,:,185))
  call Hloop_UW_V(ntryL,G1H4(102),39,ex5(:),16,G2H2(158),m3h2x2(:,186),heltab2x4(:,:,186))
  call Hloop_UW_V(ntryL,G1H4(103),39,ex5(:),16,G2H2(159),m3h2x2(:,187),heltab2x4(:,:,187))
  call Hloop_VA_Q(ntryL,G1H4(78),ex3(:),G1H2(103),m3h2x2(:,188),heltab2x4(:,:,188))
  call Hloop_A_Q(ntryL,G1H2(103),47,0,G2H2(160),n2h2(86))
call HGT_OLR(G1H4(46),1,1,4)
call HGT_invQ_OLR(G1H4(46),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(46),-16,0,G2H4(7),n2h4(93))
  call Hloop_QV_A(ntryL,G2H4(7),ex5(:),G2H2(161),m3h2x2(:,189),heltab2x4(:,:,189))
  call Hloop_VA_Q(ntryL,G1H4(106),ex3(:),G1H2(109),m3h2x2(:,190),heltab2x4(:,:,190))
  call Hloop_A_Q(ntryL,G1H2(109),47,0,G2H2(162),n2h2(87))
  call Hloop_VA_Q(ntryL,G1H4(107),ex3(:),G1H2(110),m3h2x2(:,191),heltab2x4(:,:,191))
  call Hloop_A_Q(ntryL,G1H2(110),47,0,G2H2(163),n2h2(88))
  call Hloop_WQ_A(ntryL,G1H4(79),ex4(:),G1H2(115),m3h2x2(:,192),heltab2x4(:,:,192))
  call Hloop_Q_A(ntryL,G1H2(115),47,0,G2H2(164),n2h2(89))
call HGT_OLR(G1H4(52),1,1,4)
call HGT_invQ_OLR(G1H4(52),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(52),-16,0,G2H4(11),n2h4(94))
  call Hloop_AV_Q(ntryL,G2H4(11),ex5(:),G2H2(165),m3h2x2(:,193),heltab2x4(:,:,193))
  call Hloop_WQ_A(ntryL,G1H4(38),ex4(:),G1H2(121),m3h2x2(:,194),heltab2x4(:,:,194))
  call Hloop_Q_A(ntryL,G1H2(121),47,0,G2H2(166),n2h2(90))
  call Hloop_WQ_A(ntryL,G1H4(70),ex4(:),G1H2(122),m3h2x2(:,195),heltab2x4(:,:,195))
  call Hloop_Q_A(ntryL,G1H2(122),47,0,G2H2(167),n2h2(91))
  call Hloop_UW_V(ntryL,G1H4(42),39,ex5(:),16,G2H2(168),m3h2x2(:,196),heltab2x4(:,:,196))
call HGT_OLR(G1H4(43),1,1,4)
call HGT_invQ_OLR(G1H4(43),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(43),-8,0,G2H4(12),n2h4(95))
  call Hloop_AQ_W(ntryL,G2H4(12),ex4(:),G2H2(169),m3h2x2(:,197),heltab2x4(:,:,197))
  call Hloop_UW_V(ntryL,G1H4(88),39,ex5(:),16,G2H2(170),m3h2x2(:,198),heltab2x4(:,:,198))
  call Hloop_UW_V(ntryL,G1H4(108),39,ex5(:),16,G2H2(171),m3h2x2(:,199),heltab2x4(:,:,199))
  call Hloop_VA_Q(ntryL,G1H4(50),ex3(:),G1H2(127),m3h2x2(:,200),heltab2x4(:,:,200))
  call Hloop_A_Q(ntryL,G1H2(127),47,0,G2H2(172),n2h2(92))
call HGT_OLR(G1H4(109),1,1,4)
call HGT_invQ_OLR(G1H4(109),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(109),-16,0,G2H4(13),n2h4(96))
  call Hloop_QV_A(ntryL,G2H4(13),ex5(:),G2H2(173),m3h2x2(:,201),heltab2x4(:,:,201))
  call Hloop_VA_Q(ntryL,G1H4(112),ex3(:),G1H2(1),m3h2x2(:,202),heltab2x4(:,:,202))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(174),n2h2(93))
  call Hloop_VA_Q(ntryL,G1H4(113),ex3(:),G1H2(2),m3h2x2(:,203),heltab2x4(:,:,203))
  call Hloop_A_Q(ntryL,G1H2(2),47,0,G2H2(175),n2h2(94))
  call Hloop_ZA_Q(ntryL,G1H4(114),ex3(:),G1H2(7),ngZu,m3h2x2(:,204),heltab2x4(:,:,204))
  call Hloop_A_Q(ntryL,G1H2(7),47,0,G2H2(176),n2h2(95))
call HGT_OLR(G1H4(115),1,1,4)
call HGT_invQ_OLR(G1H4(115),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(115),-16,0,G2H4(9),n2h4(97))
  call Hloop_QV_A(ntryL,G2H4(9),ex5(:),G2H2(177),m3h2x2(:,205),heltab2x4(:,:,205))
  call Hloop_ZA_Q(ntryL,G1H4(118),ex3(:),G1H2(13),ngZu,m3h2x2(:,206),heltab2x4(:,:,206))
  call Hloop_A_Q(ntryL,G1H2(13),47,0,G2H2(178),n2h2(96))
  call Hloop_ZA_Q(ntryL,G1H4(119),ex3(:),G1H2(14),ngZu,m3h2x2(:,207),heltab2x4(:,:,207))
  call Hloop_A_Q(ntryL,G1H2(14),47,0,G2H2(179),n2h2(97))
  call Hloop_QW_A(ntryL,G1H8(55),wf4(:,1),G1H2(19),m3h4x2(:,6),heltab2x8(:,:,126))
  call Hloop_Q_A(ntryL,G1H2(19),47,0,G2H2(180),n2h2(98))
call HGT_OLR(G1H8(13),1,1,8)
call HGT_invQ_OLR(G1H8(13),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(13),-16,0,G2H8(15),n2h8(84))
  call Hloop_AV_Q(ntryL,G2H8(15),ex5(:),G2H4(4),m3h2x4(:,121),heltab2x8(:,:,127))
  call Hloop_QW_A(ntryL,G1H8(18),wf4(:,1),G1H2(25),m3h4x2(:,7),heltab2x8(:,:,128))
  call Hloop_Q_A(ntryL,G1H2(25),47,0,G2H2(181),n2h2(99))
  call Hloop_QW_A(ntryL,G1H8(19),wf4(:,1),G1H2(26),m3h4x2(:,8),heltab2x8(:,:,129))
  call Hloop_Q_A(ntryL,G1H2(26),47,0,G2H2(182),n2h2(100))
  call Hloop_QW_A(ntryL,G1H8(20),wf4(:,1),G1H2(31),m3h4x2(:,9),heltab2x8(:,:,130))
  call Hloop_Q_A(ntryL,G1H2(31),47,0,G2H2(183),n2h2(101))
call HGT_OLR(G1H8(23),1,1,8)
call HGT_invQ_OLR(G1H8(23),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(23),-16,0,G2H8(16),n2h8(85))
  call Hloop_AV_Q(ntryL,G2H8(16),ex5(:),G2H4(10),m3h2x4(:,122),heltab2x8(:,:,131))
  call Hloop_QW_A(ntryL,G1H8(26),wf4(:,1),G1H2(32),m3h4x2(:,10),heltab2x8(:,:,132))
  call Hloop_Q_A(ntryL,G1H2(32),47,0,G2H2(184),n2h2(102))
  call Hloop_QW_A(ntryL,G1H8(29),wf4(:,1),G1H2(37),m3h4x2(:,11),heltab2x8(:,:,133))
  call Hloop_Q_A(ntryL,G1H2(37),47,0,G2H2(185),n2h2(103))
  call Hloop_VQ_A(ntryL,G1H4(120),ex4(:),G1H2(38),m3h2x2(:,208),heltab2x4(:,:,208))
  call Hloop_Q_A(ntryL,G1H2(38),47,0,G2H2(186),n2h2(104))
call HGT_OLR(G1H4(121),1,1,4)
call HGT_invQ_OLR(G1H4(121),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(121),-16,0,G2H4(8),n2h4(98))
  call Hloop_AV_Q(ntryL,G2H4(8),ex5(:),G2H2(187),m3h2x2(:,209),heltab2x4(:,:,209))
  call Hloop_VQ_A(ntryL,G1H4(124),ex4(:),G1H2(43),m3h2x2(:,210),heltab2x4(:,:,210))
  call Hloop_Q_A(ntryL,G1H2(43),47,0,G2H2(188),n2h2(105))
  call Hloop_VQ_A(ntryL,G1H4(125),ex4(:),G1H2(44),m3h2x2(:,211),heltab2x4(:,:,211))
  call Hloop_Q_A(ntryL,G1H2(44),47,0,G2H2(189),n2h2(106))
  call Hloop_ZQ_A(ntryL,G1H4(126),ex4(:),G1H2(49),ngZd,m3h2x2(:,212),heltab2x4(:,:,212))
  call Hloop_Q_A(ntryL,G1H2(49),47,0,G2H2(190),n2h2(107))
call HGT_OLR(G1H4(127),1,1,4)
call HGT_invQ_OLR(G1H4(127),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(127),-16,0,G2H4(16),n2h4(99))
  call Hloop_AV_Q(ntryL,G2H4(16),ex5(:),G2H2(191),m3h2x2(:,213),heltab2x4(:,:,213))
  call Hloop_ZQ_A(ntryL,G1H4(130),ex4(:),G1H2(50),ngZd,m3h2x2(:,214),heltab2x4(:,:,214))
  call Hloop_Q_A(ntryL,G1H2(50),47,0,G2H2(192),n2h2(108))
  call Hloop_ZQ_A(ntryL,G1H4(131),ex4(:),G1H2(55),ngZd,m3h2x2(:,215),heltab2x4(:,:,215))
  call Hloop_Q_A(ntryL,G1H2(55),47,0,G2H2(193),n2h2(109))
  call Hloop_AW_Q(ntryL,G1H8(30),wf4(:,1),G1H2(56),m3h4x2(:,12),heltab2x8(:,:,134))
  call Hloop_A_Q(ntryL,G1H2(56),47,0,G2H2(194),n2h2(110))
call HGT_OLR(G1H8(37),1,1,8)
call HGT_invQ_OLR(G1H8(37),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(37),-16,0,G2H8(17),n2h8(86))
  call Hloop_QV_A(ntryL,G2H8(17),ex5(:),G2H4(19),m3h2x4(:,123),heltab2x8(:,:,135))
  call Hloop_AW_Q(ntryL,G1H8(42),wf4(:,1),G1H2(61),m3h4x2(:,13),heltab2x8(:,:,136))
  call Hloop_A_Q(ntryL,G1H2(61),47,0,G2H2(195),n2h2(111))
  call Hloop_AW_Q(ntryL,G1H8(1),wf4(:,1),G1H2(62),m3h4x2(:,14),heltab2x8(:,:,137))
  call Hloop_A_Q(ntryL,G1H2(62),47,0,G2H2(196),n2h2(112))
  call Hloop_AW_Q(ntryL,G1H8(2),wf4(:,1),G1H2(79),m3h4x2(:,15),heltab2x8(:,:,138))
  call Hloop_A_Q(ntryL,G1H2(79),47,0,G2H2(197),n2h2(113))
call HGT_OLR(G1H8(5),1,1,8)
call HGT_invQ_OLR(G1H8(5),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(5),-16,0,G2H8(18),n2h8(87))
  call Hloop_QV_A(ntryL,G2H8(18),ex5(:),G2H4(20),m3h2x4(:,124),heltab2x8(:,:,139))
  call Hloop_AW_Q(ntryL,G1H8(8),wf4(:,1),G1H2(85),m3h4x2(:,16),heltab2x8(:,:,140))
  call Hloop_A_Q(ntryL,G1H2(85),47,0,G2H2(198),n2h2(114))
  call Hloop_AW_Q(ntryL,G1H8(11),wf4(:,1),G1H2(86),m3h4x2(:,17),heltab2x8(:,:,141))
  call Hloop_A_Q(ntryL,G1H2(86),47,0,G2H2(199),n2h2(115))
  call Hloop_UW_V(ntryL,G1H8(12),52,wf4(:,1),3,G2H2(200),m3h4x2(:,18),heltab2x8(:,:,142))
call HGT_OLR(G1H8(43),1,1,8)
call HGT_invQ_OLR(G1H8(43),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(43),-8,0,G2H8(19),n2h8(88))
  call Hloop_AQ_V(ntryL,G2H8(19),ex4(:),G2H4(23),m3h2x4(:,125),heltab2x8(:,:,143))
  call Hloop_UW_V(ntryL,G1H8(46),52,wf4(:,1),3,G2H2(201),m3h4x2(:,19),heltab2x8(:,:,144))
  call Hloop_UW_V(ntryL,G1H8(21),52,wf4(:,1),3,G2H2(202),m3h4x2(:,20),heltab2x8(:,:,145))
  call Hloop_UW_V(ntryL,G1H8(27),52,wf4(:,1),3,G2H2(203),m3h4x2(:,21),heltab2x8(:,:,146))
call HGT_OLR(G1H8(34),1,1,8)
call HGT_invQ_OLR(G1H8(34),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(34),-8,0,G2H8(20),n2h8(89))
  call Hloop_AQ_Z(ntryL,G2H8(20),ex4(:),G2H4(24),ngZd,m3h2x4(:,126),heltab2x8(:,:,147))
  call Hloop_UW_V(ntryL,G1H8(4),52,wf4(:,1),3,G2H2(204),m3h4x2(:,22),heltab2x8(:,:,148))
  call Hloop_UW_V(ntryL,G1H8(9),52,wf4(:,1),3,G2H2(205),m3h4x2(:,23),heltab2x8(:,:,149))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(203),[G2H2(6),G2H2(2),G1H2(68),G1H2(18),G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(200),[G2H2(4),G1H2(67),G1H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(83),[G2H2(8),G1H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(85),[G2H2(10),G1H2(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(56),[G2H2(12),G1H2(126),G1H2(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(59),[G2H2(14),G1H2(132),G1H2(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G1H2(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G1H2(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(23),[G1H2(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G2H2(26),G1H2(78),G1H2(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G1H2(72)])
call HGT_lower_alpha_w2_OLR(G2H2(34),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(34),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(34),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(34),[G2H2(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(84),[G2H2(35),G1H2(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(41),[G2H2(38),G1H2(96),G1H2(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(44),[G1H2(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(47),[G1H2(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(50),[G1H2(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(53),[G1H2(120)])
call HGT_lower_alpha_w2_OLR(G2H2(55),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(55),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(55),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(55),[G2H2(90)])
call HGT_lower_alpha_w2_OLR(G2H2(58),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(58),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(58),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(58),[G2H2(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(70),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(71),[G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(72),[G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(73),[G1H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G1H2(23),G1H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(74),[G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(75),[G1H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G1H2(29),G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(76),[G1H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(77),[G1H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(78),[G1H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(79),[G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(80),[G1H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(81),[G1H2(40),G1H2(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G1H2(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(82),[G1H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G1H2(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(11),[G1H2(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G1H2(58),G1H2(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(132),[G1H2(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(15),[G1H2(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(18),[G1H2(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(136),[G1H2(95),G1H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(21),[G1H2(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(140),[G1H2(101),G1H2(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(24),[G1H2(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(27),[G1H2(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(144),[G1H2(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(30),[G1H2(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(33),[G1H2(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(148),[G1H2(113),G1H2(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(36),[G1H2(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(39),[G1H2(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(152),[G1H2(119),G1H2(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(42),[G1H2(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(45),[G1H2(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(156),[G1H2(74),G1H2(131),G1H2(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(48),[G1H2(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(51),[G1H2(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(160),[G1H2(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(54),[G1H2(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(57),[G1H2(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(60),[G1H2(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(61),[G1H2(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(62),[G1H2(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(63),[G1H2(112),G1H2(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(164),[G1H2(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(64),[G1H2(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(65),[G1H2(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(66),[G1H2(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(67),[G1H2(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(68),[G1H2(130),G1H2(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(168),[G1H2(73),G1H2(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(69),[G1H2(129)])
  call Hotf_5pt_reduction(G2H2(203),RedSet_5(22),mass5set(:,19),  & 
G1H2(91),G1H2(97),G1H2(98),G1H2(103),G1H2(109),G1H2(110),2)
  call HG1shiftOLR(G1H2(97),8,2)
  call Hotf_5pt_reduction(G2H2(200),RedSet_5(22),mass5set(:,1),  & 
G1H2(115),G1H2(121),G1H2(122),G1H2(127),G1H2(1),G1H2(2),2)
  call HG1shiftOLR(G1H2(121),8,2)
  call Hotf_5pt_reduction(G2H2(83),RedSet_5(23),mass5set(:,2),  & 
G1H2(7),G1H2(13),G1H2(14),G1H2(19),G1H2(25),G1H2(26),2)
  call HG1shiftOLR(G1H2(13),8,2)
  call Hotf_5pt_reduction(G2H2(85),RedSet_5(23),mass5set(:,6),  & 
G1H2(31),G1H2(32),G1H2(37),G1H2(38),G1H2(43),G1H2(44),2)
  call HG1shiftOLR(G1H2(32),8,2)
  call Hotf_5pt_reduction(G2H2(56),RedSet_5(24),mass5set(:,5),  & 
G1H2(49),G1H2(50),G1H2(55),G1H2(56),G1H2(61),G1H2(62),2)
  call HG1shiftOLR(G1H2(50),8,2)
  call Hotf_5pt_reduction(G2H2(59),RedSet_5(24),mass5set(:,7),  & 
G1H2(79),G1H2(85),G1H2(86),G1H2(68),G1H2(18),G1H2(6),2)
  call HG1shiftOLR(G1H2(85),8,2)
call HGT_OLR(G2H2(16),1,1,2)
call HGT_invQ_OLR(G2H2(16),2,5,2)
call HGT_OLR(G2H2(16),6,15,2)
  call Hotf_5pt_reduction(G2H2(16),RedSet_5(25),mass5set(:,5),  & 
G1H2(67),G1H2(12),G1H2(24),G1H2(30),G1H2(126),G1H2(36),2)
  call HG1shiftOLR(G1H2(12),4,2)
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(26),mass5set(:,3),  & 
G1H2(132),G1H2(42),G1H2(48),G1H2(54),G1H2(60),G1H2(78),2)
  call HG1shiftOLR(G1H2(42),16,2)
call HGT_OLR(G2H2(19),1,1,2)
call HGT_invQ_OLR(G2H2(19),2,5,2)
call HGT_OLR(G2H2(19),6,15,2)
  call Hotf_5pt_reduction(G2H2(19),RedSet_5(25),mass5set(:,6),  & 
G1H2(66),G1H2(72),G1H2(84),G1H2(96),G1H2(90),G1H2(102),2)
  call HG1shiftOLR(G1H2(72),4,2)
  call Hotf_5pt_reduction(G2H2(20),RedSet_5(26),mass5set(:,2),  & 
G1H2(108),G1H2(114),G1H2(120),G1H2(3),G1H2(4),G1H2(5),2)
  call HG1shiftOLR(G1H2(114),16,2)
call HGT_OLR(G2H2(22),1,1,2)
call HGT_invQ_OLR(G2H2(22),2,5,2)
call HGT_OLR(G2H2(22),6,15,2)
  call Hotf_5pt_reduction(G2H2(22),RedSet_5(25),mass5set(:,7),  & 
G1H2(9),G1H2(10),G1H2(23),G1H2(11),G1H2(15),G1H2(16),2)
  call HG1shiftOLR(G1H2(10),4,2)
  call Hotf_5pt_reduction(G2H2(23),RedSet_5(26),mass5set(:,4),  & 
G1H2(29),G1H2(17),G1H2(21),G1H2(22),G1H2(27),G1H2(28),2)
  call HG1shiftOLR(G1H2(17),16,2)
call HGT_OLR(G2H2(25),1,1,2)
call HGT_invQ_OLR(G2H2(25),2,5,2)
call HGT_OLR(G2H2(25),6,15,2)
  call Hotf_5pt_reduction(G2H2(25),RedSet_5(27),mass5set(:,2),  & 
G1H2(33),G1H2(40),G1H2(34),G1H2(35),G1H2(39),G1H2(41),2)
  call HG1shiftOLR(G1H2(40),8,2)
  call Hotf_5pt_reduction(G2H2(32),RedSet_5(28),mass5set(:,2),  & 
G1H2(45),G1H2(58),G1H2(46),G1H2(47),G1H2(51),G1H2(52),2)
  call HG1shiftOLR(G1H2(58),16,2)
call HGT_OLR(G2H2(28),1,1,2)
call HGT_invQ_OLR(G2H2(28),2,5,2)
call HGT_OLR(G2H2(28),6,15,2)
  call Hotf_5pt_reduction(G2H2(28),RedSet_5(27),mass5set(:,7),  & 
G1H2(95),G1H2(53),G1H2(57),G1H2(101),G1H2(59),G1H2(63),2)
  call HG1shiftOLR(G1H2(53),8,2)
  call Hotf_5pt_reduction(G2H2(29),RedSet_5(28),mass5set(:,4),  & 
G1H2(64),G1H2(65),G1H2(69),G1H2(70),G1H2(113),G1H2(71),2)
  call HG1shiftOLR(G1H2(65),16,2)
call HGT_OLR(G2H2(31),1,1,2)
call HGT_invQ_OLR(G2H2(31),2,5,2)
call HGT_OLR(G2H2(31),6,15,2)
  call Hotf_5pt_reduction(G2H2(31),RedSet_5(27),mass5set(:,6),  & 
G1H2(75),G1H2(76),G1H2(119),G1H2(77),G1H2(81),G1H2(82),2)
  call HG1shiftOLR(G1H2(76),8,2)
  call Hotf_5pt_reduction(G2H2(34),RedSet_5(29),mass5set(:,20),  & 
G1H2(74),G1H2(131),G1H2(83),G1H2(87),G1H2(88),G1H2(89),2)
  call HG1shiftOLR(G1H2(131),16,2)
  call Hotf_5pt_reduction(G2H2(84),RedSet_5(23),mass5set(:,7),  & 
G1H2(93),G1H2(94),G1H2(99),G1H2(100),G1H2(105),G1H2(112),2)
  call HG1shiftOLR(G1H2(94),8,2)
call HGT_OLR(G2H2(37),1,1,2)
call HGT_invQ_OLR(G2H2(37),2,5,2)
call HGT_OLR(G2H2(37),6,15,2)
  call Hotf_5pt_reduction(G2H2(37),RedSet_5(30),mass5set(:,2),  & 
G1H2(106),G1H2(107),G1H2(111),G1H2(117),G1H2(118),G1H2(123),2)
  call HG1shiftOLR(G1H2(107),4,2)
  call Hotf_5pt_reduction(G2H2(41),RedSet_5(31),mass5set(:,2),  & 
G1H2(130),G1H2(124),G1H2(73),G1H2(125),G1H2(129),G1H2(133),2)
  call HG1shiftOLR(G1H2(124),16,2)
call HGT_OLR(G2H2(40),1,1,2)
call HGT_invQ_OLR(G2H2(40),2,5,2)
call HGT_OLR(G2H2(40),6,15,2)
  call Hotf_5pt_reduction(G2H2(40),RedSet_5(30),mass5set(:,6),  & 
G1H2(134),G1H2(135),G1H2(136),G1H2(137),G1H2(138),G1H2(139),2)
  call HG1shiftOLR(G1H2(135),4,2)
call HGT_OLR(G2H2(43),1,1,2)
call HGT_invQ_OLR(G2H2(43),2,5,2)
call HGT_OLR(G2H2(43),6,15,2)
  call Hotf_5pt_reduction(G2H2(43),RedSet_5(30),mass5set(:,7),  & 
G1H2(140),G1H2(141),G1H2(142),G1H2(143),G1H2(144),G1H2(145),2)
  call HG1shiftOLR(G1H2(141),4,2)
  call Hotf_5pt_reduction(G2H2(44),RedSet_5(31),mass5set(:,4),  & 
G1H2(146),G1H2(147),G1H2(148),G1H2(149),G1H2(150),G1H2(151),2)
  call HG1shiftOLR(G1H2(147),16,2)
call HGT_OLR(G2H2(46),1,1,2)
call HGT_invQ_OLR(G2H2(46),2,5,2)
call HGT_OLR(G2H2(46),6,15,2)
  call Hotf_5pt_reduction(G2H2(46),RedSet_5(32),mass5set(:,5),  & 
G1H2(152),G1H2(153),G1H2(154),G1H2(155),G1H2(156),G1H2(157),2)
  call HG1shiftOLR(G1H2(153),8,2)
  call Hotf_5pt_reduction(G2H2(47),RedSet_5(33),mass5set(:,3),  & 
G1H2(158),G1H2(159),G1H2(160),G1H2(161),G1H2(162),G1H2(163),2)
  call HG1shiftOLR(G1H2(159),16,2)
call HGT_OLR(G2H2(49),1,1,2)
call HGT_invQ_OLR(G2H2(49),2,5,2)
call HGT_OLR(G2H2(49),6,15,2)
  call Hotf_5pt_reduction(G2H2(49),RedSet_5(32),mass5set(:,7),  & 
G1H2(164),G1H2(165),G1H2(166),G1H2(167),G1H2(168),G1H2(169),2)
  call HG1shiftOLR(G1H2(165),8,2)
  call Hotf_5pt_reduction(G2H2(50),RedSet_5(33),mass5set(:,4),  & 
G1H2(170),G1H2(171),G1H2(172),G1H2(173),G1H2(174),G1H2(175),2)
  call HG1shiftOLR(G1H2(171),16,2)
call HGT_OLR(G2H2(52),1,1,2)
call HGT_invQ_OLR(G2H2(52),2,5,2)
call HGT_OLR(G2H2(52),6,15,2)
  call Hotf_5pt_reduction(G2H2(52),RedSet_5(32),mass5set(:,6),  & 
G1H2(176),G1H2(177),G1H2(178),G1H2(179),G1H2(180),G1H2(181),2)
  call HG1shiftOLR(G1H2(177),8,2)
  call Hotf_5pt_reduction(G2H2(53),RedSet_5(33),mass5set(:,2),  & 
G1H2(182),G1H2(183),G1H2(184),G1H2(185),G1H2(186),G1H2(187),2)
  call HG1shiftOLR(G1H2(183),16,2)
  call Hotf_5pt_reduction(G2H2(55),RedSet_5(34),mass5set(:,21),  & 
G1H2(188),G1H2(189),G1H2(190),G1H2(191),G1H2(192),G1H2(193),2)
  call HG1shiftOLR(G1H2(189),16,2)
  call Hotf_5pt_reduction(G2H2(58),RedSet_5(34),mass5set(:,20),  & 
G1H2(194),G1H2(195),G1H2(196),G1H2(197),G1H2(198),G1H2(199),2)
  call HG1shiftOLR(G1H2(195),16,2)
  call Hotf_5pt_reduction(G2H2(70),RedSet_5(35),mass5set(:,22),  & 
G1H2(200),G1H2(201),G1H2(202),G1H2(203),G1H2(204),G1H2(205),2)
  call HG1shiftOLR(G1H2(201),8,2)
  call Hotf_5pt_reduction(G2H2(71),RedSet_5(36),mass5set(:,6),  & 
G1H2(206),G1H2(207),G1H2(208),G1H2(209),G1H2(210),G1H2(211),2)
  call HG1shiftOLR(G1H2(207),8,2)
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(37),mass5set(:,6),  & 
G1H2(212),G1H2(213),G1H2(214),G1H2(215),G1H2(216),G1H2(217),2)
  call HG1shiftOLR(G1H2(213),8,2)
  call Hotf_5pt_reduction(G2H2(72),RedSet_5(38),mass5set(:,23),  & 
G1H2(218),G1H2(219),G1H2(220),G1H2(221),G1H2(222),G1H2(223),2)
  call HG1shiftOLR(G1H2(219),8,2)
  call Hotf_5pt_reduction(G2H2(73),RedSet_5(39),mass5set(:,2),  & 
G1H2(224),G1H2(225),G1H2(226),G1H2(227),G1H2(228),G1H2(229),2)
  call HG1shiftOLR(G1H2(225),8,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(40),mass5set(:,2),  & 
G1H2(230),G1H2(231),G1H2(232),G1H2(233),G1H2(234),G1H2(235),2)
  call HG1shiftOLR(G1H2(231),8,2)
  call Hotf_5pt_reduction(G2H2(74),RedSet_5(38),mass5set(:,22),  & 
G1H2(236),G1H2(237),G1H2(238),G1H2(239),G1H2(240),G1H2(241),2)
  call HG1shiftOLR(G1H2(237),8,2)
  call Hotf_5pt_reduction(G2H2(75),RedSet_5(39),mass5set(:,6),  & 
G1H2(242),G1H2(243),G1H2(244),G1H2(245),G1H2(246),G1H2(247),2)
  call HG1shiftOLR(G1H2(243),8,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(40),mass5set(:,6),  & 
G1H2(248),G1H2(249),G1H2(250),G1H2(251),G1H2(252),G1H2(253),2)
  call HG1shiftOLR(G1H2(249),8,2)
  call Hotf_5pt_reduction(G2H2(76),RedSet_5(41),mass5set(:,24),  & 
G1H2(254),G1H2(255),G1H2(256),G1H2(257),G1H2(258),G1H2(259),2)
  call HG1shiftOLR(G1H2(255),8,2)
  call Hotf_5pt_reduction(G2H2(77),RedSet_5(42),mass5set(:,3),  & 
G1H2(260),G1H2(261),G1H2(262),G1H2(263),G1H2(264),G1H2(265),2)
  call HG1shiftOLR(G1H2(261),8,2)
  call Hotf_5pt_reduction(G2H2(78),RedSet_5(41),mass5set(:,25),  & 
G1H2(266),G1H2(267),G1H2(268),G1H2(269),G1H2(270),G1H2(271),2)
  call HG1shiftOLR(G1H2(267),8,2)
  call Hotf_5pt_reduction(G2H2(79),RedSet_5(42),mass5set(:,8),  & 
G1H2(272),G1H2(273),G1H2(274),G1H2(275),G1H2(276),G1H2(277),2)
  call HG1shiftOLR(G1H2(273),8,2)
  call Hotf_5pt_reduction(G2H2(80),RedSet_5(43),mass5set(:,5),  & 
G1H2(278),G1H2(279),G1H2(280),G1H2(281),G1H2(282),G1H2(283),2)
  call HG1shiftOLR(G1H2(279),8,2)
  call Hotf_5pt_reduction(G2H2(81),RedSet_5(44),mass5set(:,5),  & 
G1H2(284),G1H2(285),G1H2(286),G1H2(287),G1H2(288),G1H2(289),2)
  call HG1shiftOLR(G1H2(285),8,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(37),mass5set(:,5),  & 
G1H2(290),G1H2(291),G1H2(292),G1H2(293),G1H2(294),G1H2(295),2)
  call HG1shiftOLR(G1H2(291),8,2)
  call Hotf_5pt_reduction(G2H2(82),RedSet_5(43),mass5set(:,26),  & 
G1H2(296),G1H2(297),G1H2(298),G1H2(299),G1H2(300),G1H2(301),2)
  call HG1shiftOLR(G1H2(297),8,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(37),mass5set(:,7),  & 
G1H2(302),G1H2(303),G1H2(304),G1H2(305),G1H2(306),G1H2(307),2)
  call HG1shiftOLR(G1H2(303),8,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(45),mass5set(:,13),  & 
G1H2(308),G1H2(309),G1H2(310),G1H2(311),G1H2(312),G1H2(313),2)
  call HG1shiftOLR(G1H2(309),16,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(46),mass5set(:,13),  & 
G1H2(314),G1H2(315),G1H2(316),G1H2(317),G1H2(318),G1H2(319),2)
  call HG1shiftOLR(G1H2(315),16,2)
  call Hotf_5pt_reduction(G2H2(132),RedSet_5(15),mass5set(:,13),  & 
G1H2(320),G1H2(321),G1H2(322),G1H2(323),G1H2(324),G1H2(325),2)
  call HG1shiftOLR(G1H2(321),16,2)
  call Hotf_5pt_reduction(G2H2(15),RedSet_5(45),mass5set(:,27),  & 
G1H2(326),G1H2(327),G1H2(328),G1H2(329),G1H2(330),G1H2(331),2)
  call HG1shiftOLR(G1H2(327),16,2)
  call Hotf_5pt_reduction(G2H2(18),RedSet_5(46),mass5set(:,18),  & 
G1H2(332),G1H2(333),G1H2(334),G1H2(335),G1H2(336),G1H2(337),2)
  call HG1shiftOLR(G1H2(333),16,2)
  call Hotf_5pt_reduction(G2H2(136),RedSet_5(15),mass5set(:,14),  & 
G1H2(338),G1H2(339),G1H2(340),G1H2(341),G1H2(342),G1H2(343),2)
  call HG1shiftOLR(G1H2(339),16,2)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(45),mass5set(:,28),  & 
G1H2(344),G1H2(345),G1H2(346),G1H2(347),G1H2(348),G1H2(349),2)
  call HG1shiftOLR(G1H2(345),16,2)
  call Hotf_5pt_reduction(G2H2(140),RedSet_5(15),mass5set(:,15),  & 
G1H2(350),G1H2(351),G1H2(352),G1H2(353),G1H2(354),G1H2(355),2)
  call HG1shiftOLR(G1H2(351),16,2)
  call Hotf_5pt_reduction(G2H2(24),RedSet_5(47),mass5set(:,24),  & 
G1H2(356),G1H2(357),G1H2(358),G1H2(359),G1H2(360),G1H2(361),2)
  call HG1shiftOLR(G1H2(357),16,2)
  call Hotf_5pt_reduction(G2H2(27),RedSet_5(48),mass5set(:,3),  & 
G1H2(362),G1H2(363),G1H2(364),G1H2(365),G1H2(366),G1H2(367),2)
  call HG1shiftOLR(G1H2(363),16,2)
  call Hotf_5pt_reduction(G2H2(144),RedSet_5(16),mass5set(:,2),  & 
G1H2(368),G1H2(369),G1H2(370),G1H2(371),G1H2(372),G1H2(373),2)
  call HG1shiftOLR(G1H2(369),16,2)
  call Hotf_5pt_reduction(G2H2(30),RedSet_5(47),mass5set(:,28),  & 
G1H2(374),G1H2(375),G1H2(376),G1H2(377),G1H2(378),G1H2(379),2)
  call HG1shiftOLR(G1H2(375),16,2)
  call Hotf_5pt_reduction(G2H2(33),RedSet_5(48),mass5set(:,13),  & 
G1H2(380),G1H2(381),G1H2(382),G1H2(383),G1H2(384),G1H2(385),2)
  call HG1shiftOLR(G1H2(381),16,2)
  call Hotf_5pt_reduction(G2H2(148),RedSet_5(16),mass5set(:,15),  & 
G1H2(386),G1H2(387),G1H2(388),G1H2(389),G1H2(390),G1H2(391),2)
  call HG1shiftOLR(G1H2(387),16,2)
  call Hotf_5pt_reduction(G2H2(36),RedSet_5(47),mass5set(:,27),  & 
G1H2(392),G1H2(393),G1H2(394),G1H2(395),G1H2(396),G1H2(397),2)
  call HG1shiftOLR(G1H2(393),16,2)
  call Hotf_5pt_reduction(G2H2(39),RedSet_5(48),mass5set(:,18),  & 
G1H2(398),G1H2(399),G1H2(400),G1H2(401),G1H2(402),G1H2(403),2)
  call HG1shiftOLR(G1H2(399),16,2)
  call Hotf_5pt_reduction(G2H2(152),RedSet_5(16),mass5set(:,14),  & 
G1H2(404),G1H2(405),G1H2(406),G1H2(407),G1H2(408),G1H2(409),2)
  call HG1shiftOLR(G1H2(405),16,2)
  call Hotf_5pt_reduction(G2H2(42),RedSet_5(49),mass5set(:,29),  & 
G1H2(410),G1H2(411),G1H2(412),G1H2(413),G1H2(414),G1H2(415),2)
  call HG1shiftOLR(G1H2(411),8,2)
  call Hotf_5pt_reduction(G2H2(45),RedSet_5(50),mass5set(:,17),  & 
G1H2(416),G1H2(417),G1H2(418),G1H2(419),G1H2(420),G1H2(421),2)
  call HG1shiftOLR(G1H2(417),8,2)
  call Hotf_5pt_reduction(G2H2(156),RedSet_5(17),mass5set(:,16),  & 
G1H2(422),G1H2(423),G1H2(424),G1H2(425),G1H2(426),G1H2(427),2)
  call HG1shiftOLR(G1H2(423),8,2)
  call Hotf_5pt_reduction(G2H2(48),RedSet_5(51),mass5set(:,24),  & 
G1H2(428),G1H2(429),G1H2(430),G1H2(431),G1H2(432),G1H2(433),2)
  call HG1shiftOLR(G1H2(429),16,2)
  call Hotf_5pt_reduction(G2H2(51),RedSet_5(52),mass5set(:,3),  & 
G1H2(434),G1H2(435),G1H2(436),G1H2(437),G1H2(438),G1H2(439),2)
  call HG1shiftOLR(G1H2(435),16,2)
  call Hotf_5pt_reduction(G2H2(160),RedSet_5(15),mass5set(:,2),  & 
G1H2(440),G1H2(441),G1H2(442),G1H2(443),G1H2(444),G1H2(445),2)
  call HG1shiftOLR(G1H2(441),16,2)
  call Hotf_5pt_reduction(G2H2(54),RedSet_5(51),mass5set(:,27),  & 
G1H2(446),G1H2(447),G1H2(448),G1H2(449),G1H2(450),G1H2(451),2)
  call HG1shiftOLR(G1H2(447),16,2)
  call Hotf_5pt_reduction(G2H2(57),RedSet_5(52),mass5set(:,18),  & 
G1H2(452),G1H2(453),G1H2(454),G1H2(455),G1H2(456),G1H2(457),2)
  call HG1shiftOLR(G1H2(453),16,2)
  call Hotf_5pt_reduction(G2H2(60),RedSet_5(51),mass5set(:,28),  & 
G1H2(458),G1H2(459),G1H2(460),G1H2(461),G1H2(462),G1H2(463),2)
  call HG1shiftOLR(G1H2(459),16,2)
  call Hotf_5pt_reduction(G2H2(61),RedSet_5(52),mass5set(:,13),  & 
G1H2(464),G1H2(465),G1H2(466),G1H2(467),G1H2(468),G1H2(469),2)
  call HG1shiftOLR(G1H2(465),16,2)
  call Hotf_5pt_reduction(G2H2(62),RedSet_5(53),mass5set(:,13),  & 
G1H2(470),G1H2(471),G1H2(472),G1H2(473),G1H2(474),G1H2(475),2)
  call HG1shiftOLR(G1H2(471),16,2)
  call Hotf_5pt_reduction(G2H2(63),RedSet_5(54),mass5set(:,13),  & 
G1H2(476),G1H2(477),G1H2(478),G1H2(479),G1H2(480),G1H2(481),2)
  call HG1shiftOLR(G1H2(477),16,2)
  call Hotf_5pt_reduction(G2H2(164),RedSet_5(16),mass5set(:,13),  & 
G1H2(482),G1H2(483),G1H2(484),G1H2(485),G1H2(486),G1H2(487),2)
  call HG1shiftOLR(G1H2(483),16,2)
  call Hotf_5pt_reduction(G2H2(64),RedSet_5(53),mass5set(:,28),  & 
G1H2(488),G1H2(489),G1H2(490),G1H2(491),G1H2(492),G1H2(493),2)
  call HG1shiftOLR(G1H2(489),16,2)
  call Hotf_5pt_reduction(G2H2(65),RedSet_5(53),mass5set(:,27),  & 
G1H2(494),G1H2(495),G1H2(496),G1H2(497),G1H2(498),G1H2(499),2)
  call HG1shiftOLR(G1H2(495),16,2)
  call Hotf_5pt_reduction(G2H2(66),RedSet_5(54),mass5set(:,18),  & 
G1H2(500),G1H2(501),G1H2(502),G1H2(503),G1H2(504),G1H2(505),2)
  call HG1shiftOLR(G1H2(501),16,2)
  call Hotf_5pt_reduction(G2H2(67),RedSet_5(55),mass5set(:,17),  & 
G1H2(506),G1H2(507),G1H2(508),G1H2(509),G1H2(510),G1H2(511),2)
  call HG1shiftOLR(G1H2(507),8,2)
  call Hotf_5pt_reduction(G2H2(68),RedSet_5(56),mass5set(:,17),  & 
G1H2(512),G1H2(513),G1H2(514),G1H2(515),G1H2(516),G1H2(517),2)
  call HG1shiftOLR(G1H2(513),8,2)
  call Hotf_5pt_reduction(G2H2(168),RedSet_5(17),mass5set(:,17),  & 
G1H2(518),G1H2(519),G1H2(520),G1H2(521),G1H2(522),G1H2(523),2)
  call HG1shiftOLR(G1H2(519),8,2)
  call Hotf_5pt_reduction(G2H2(69),RedSet_5(55),mass5set(:,29),  & 
G1H2(524),G1H2(525),G1H2(526),G1H2(527),G1H2(528),G1H2(529),2)
  call HG1shiftOLR(G1H2(525),8,2)
  call Hotf_5pt_reduction(G2H4(18),RedSet_5(7),mass5set(:,2),  & 
G1H4(26),G1H4(30),G1H4(73),G1H4(74),G1H4(84),G1H4(44),4)
  call HG1shiftOLR(G1H4(30),20,4)
  call Hotf_5pt_reduction(G2H4(22),RedSet_5(7),mass5set(:,6),  & 
G1H4(48),G1H4(72),G1H4(85),G1H4(86),G1H4(90),G1H4(6),4)
  call HG1shiftOLR(G1H4(72),20,4)
  call Hotf_5pt_reduction(G2H4(26),RedSet_5(7),mass5set(:,7),  & 
G1H4(7),G1H4(8),G1H4(12),G1H4(18),G1H4(19),G1H4(20),4)
  call HG1shiftOLR(G1H4(8),20,4)
  call Hotf_5pt_reduction(G2H4(38),RedSet_5(5),mass5set(:,5),  & 
G1H4(24),G1H4(32),G1H4(36),G1H4(37),G1H4(3),G1H4(9),4)
  call HG1shiftOLR(G1H4(32),20,4)
  call Hotf_5pt_reduction(G2H4(42),RedSet_5(5),mass5set(:,6),  & 
G1H4(53),G1H4(11),G1H4(15),G1H4(21),G1H4(23),G1H4(27),4)
  call HG1shiftOLR(G1H4(11),20,4)
  call Hotf_5pt_reduction(G2H4(17),RedSet_5(5),mass5set(:,7),  & 
G1H4(71),G1H4(77),G1H4(35),G1H4(39),G1H4(89),G1H4(47),4)
  call HG1shiftOLR(G1H4(77),20,4)
  call Hotf_5pt_reduction(G2H4(44),RedSet_5(6),mass5set(:,2),  & 
G1H4(51),G1H4(57),G1H4(63),G1H4(69),G1H4(75),G1H4(81),4)
  call HG1shiftOLR(G1H4(57),24,4)
  call Hotf_5pt_reduction(G2H4(21),RedSet_5(6),mass5set(:,7),  & 
G1H4(82),G1H4(62),G1H4(16),G1H4(66),G1H4(10),G1H4(22),4)
  call HG1shiftOLR(G1H4(62),24,4)
  call Hotf_5pt_reduction(G2H4(30),RedSet_5(6),mass5set(:,6),  & 
G1H4(91),G1H4(55),G1H4(28),G1H4(94),G1H4(95),G1H4(56),4)
  call HG1shiftOLR(G1H4(55),24,4)
  call Hotf_5pt_reduction(G2H4(25),RedSet_5(8),mass5set(:,5),  & 
G1H4(34),G1H4(98),G1H4(99),G1H4(60),G1H4(40),G1H4(102),4)
  call HG1shiftOLR(G1H4(98),24,4)
  call Hotf_5pt_reduction(G2H4(34),RedSet_5(8),mass5set(:,7),  & 
G1H4(103),G1H4(78),G1H4(46),G1H4(106),G1H4(107),G1H4(79),4)
  call HG1shiftOLR(G1H4(78),24,4)
  call Hotf_5pt_reduction(G2H4(29),RedSet_5(8),mass5set(:,6),  & 
G1H4(52),G1H4(38),G1H4(70),G1H4(42),G1H4(43),G1H4(88),4)
  call HG1shiftOLR(G1H4(38),24,4)
  call Hotf_5pt_reduction(G2H2(86),RedSet_5(57),mass5set(:,20),  & 
G1H2(530),G1H2(531),G1H2(532),G1H2(533),G1H2(534),G1H2(535),2)
  call HG1shiftOLR(G1H2(531),16,2)
  call Hotf_5pt_reduction(G2H2(87),RedSet_5(58),mass5set(:,21),  & 
G1H2(536),G1H2(537),G1H2(538),G1H2(539),G1H2(540),G1H2(541),2)
  call HG1shiftOLR(G1H2(537),16,2)
  call Hotf_5pt_reduction(G2H2(88),RedSet_5(58),mass5set(:,20),  & 
G1H2(542),G1H2(543),G1H2(544),G1H2(545),G1H2(546),G1H2(547),2)
  call HG1shiftOLR(G1H2(543),16,2)
  call Hotf_5pt_reduction(G2H2(92),RedSet_5(59),mass5set(:,17),  & 
G1H2(548),G1H2(549),G1H2(550),G1H2(551),G1H2(552),G1H2(553),2)
  call HG1shiftOLR(G1H2(549),4,2)
  call Hotf_5pt_reduction(G2H2(93),RedSet_5(59),mass5set(:,29),  & 
G1H2(554),G1H2(555),G1H2(556),G1H2(557),G1H2(558),G1H2(559),2)
  call HG1shiftOLR(G1H2(555),4,2)
  call Hotf_5pt_reduction(G2H2(94),RedSet_5(60),mass5set(:,29),  & 
G1H2(560),G1H2(561),G1H2(562),G1H2(563),G1H2(564),G1H2(565),2)
  call HG1shiftOLR(G1H2(561),4,2)
  call Hotf_5pt_reduction(G2H2(95),RedSet_5(61),mass5set(:,5),  & 
G1H2(566),G1H2(567),G1H2(568),G1H2(569),G1H2(570),G1H2(571),2)
  call HG1shiftOLR(G1H2(567),4,2)
  call Hotf_5pt_reduction(G2H2(96),RedSet_5(61),mass5set(:,26),  & 
G1H2(572),G1H2(573),G1H2(574),G1H2(575),G1H2(576),G1H2(577),2)
  call HG1shiftOLR(G1H2(573),4,2)
  call Hotf_5pt_reduction(G2H2(97),RedSet_5(62),mass5set(:,24),  & 
G1H2(578),G1H2(579),G1H2(580),G1H2(581),G1H2(582),G1H2(583),2)
  call HG1shiftOLR(G1H2(579),4,2)
  call Hotf_5pt_reduction(G2H2(98),RedSet_5(62),mass5set(:,25),  & 
G1H2(584),G1H2(585),G1H2(586),G1H2(587),G1H2(588),G1H2(589),2)
  call HG1shiftOLR(G1H2(585),4,2)
  call Hotf_5pt_reduction(G2H2(99),RedSet_5(9),mass5set(:,3),  & 
G1H2(590),G1H2(591),G1H2(592),G1H2(593),G1H2(594),G1H2(595),2)
  call HG1shiftOLR(G1H2(591),8,2)
  call Hotf_4pt_reduction(G2H2(101),RedSet_4(103),mass4set(:,1),  & 
G1H2(596),G1H2(597),G1H2(598),G1H2(599),G1H2(600),2)
  call HG1shiftOLR(G1H2(597),12,2)
  call Hotf_5pt_reduction(G2H2(102),RedSet_5(9),mass5set(:,8),  & 
G1H2(601),G1H2(602),G1H2(603),G1H2(604),G1H2(605),G1H2(606),2)
  call HG1shiftOLR(G1H2(602),8,2)
  call Hotf_4pt_reduction(G2H2(104),RedSet_4(103),mass4set(:,1),  & 
G1H2(607),G1H2(608),G1H2(609),G1H2(610),G1H2(611),2)
  call HG1shiftOLR(G1H2(608),12,2)
  call Hotf_5pt_reduction(G2H2(105),RedSet_5(10),mass5set(:,3),  & 
G1H2(612),G1H2(613),G1H2(614),G1H2(615),G1H2(616),G1H2(617),2)
  call HG1shiftOLR(G1H2(613),4,2)
  call Hotf_4pt_reduction(G2H2(107),RedSet_4(103),mass4set(:,1),  & 
G1H2(618),G1H2(619),G1H2(620),G1H2(621),G1H2(622),2)
  call HG1shiftOLR(G1H2(619),12,2)
  call Hotf_5pt_reduction(G2H2(108),RedSet_5(10),mass5set(:,8),  & 
G1H2(623),G1H2(624),G1H2(625),G1H2(626),G1H2(627),G1H2(628),2)
  call HG1shiftOLR(G1H2(624),4,2)
  call Hotf_4pt_reduction(G2H2(110),RedSet_4(103),mass4set(:,1),  & 
G1H2(629),G1H2(630),G1H2(631),G1H2(632),G1H2(633),2)
  call HG1shiftOLR(G1H2(630),12,2)
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(111),ex1(:),G2tensor(1),ngZn,m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(113),ex1(:),G2tensor(3),ngZn,m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(114),ex2(:),G2tensor(5),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(116),ex2(:),G2tensor(7),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(117),ex2(:),G2tensor(9),ngZl,m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(119),ex2(:),G2tensor(11),ngZl,m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(120),ex2(:),G2tensor(13),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(122),ex2(:),G2tensor(15),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(123),ex2(:),G2tensor(17),ngZl,m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(125),ex2(:),G2tensor(19),ngZl,m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(126),ex1(:),G2tensor(21),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(128),ex1(:),G2tensor(23),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(129),ex1(:),G2tensor(25),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(131),ex1(:),G2tensor(27),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hotf_4pt_reduction(G2H2(135),RedSet_4(56),mass4set(:,2),  & 
G1H2(634),G1H2(635),G1H2(636),G1H2(637),G1H2(638),2)
  call HG1shiftOLR(G1H2(635),20,2)
  call Hotf_4pt_reduction(G2H2(139),RedSet_4(56),mass4set(:,3),  & 
G1H2(639),G1H2(640),G1H2(641),G1H2(642),G1H2(643),2)
  call HG1shiftOLR(G1H2(640),20,2)
  call Hotf_4pt_reduction(G2H2(143),RedSet_4(56),mass4set(:,4),  & 
G1H2(644),G1H2(645),G1H2(646),G1H2(647),G1H2(648),2)
  call HG1shiftOLR(G1H2(645),20,2)
  call Hotf_4pt_reduction(G2H2(147),RedSet_4(71),mass4set(:,5),  & 
G1H2(649),G1H2(650),G1H2(651),G1H2(652),G1H2(653),2)
  call HG1shiftOLR(G1H2(650),24,2)
  call Hotf_4pt_reduction(G2H2(151),RedSet_4(71),mass4set(:,4),  & 
G1H2(654),G1H2(655),G1H2(656),G1H2(657),G1H2(658),2)
  call HG1shiftOLR(G1H2(655),24,2)
  call Hotf_4pt_reduction(G2H2(155),RedSet_4(71),mass4set(:,3),  & 
G1H2(659),G1H2(660),G1H2(661),G1H2(662),G1H2(663),2)
  call HG1shiftOLR(G1H2(660),24,2)
  call Hotf_4pt_reduction(G2H2(159),RedSet_4(71),mass4set(:,4),  & 
G1H2(664),G1H2(665),G1H2(666),G1H2(667),G1H2(668),2)
  call HG1shiftOLR(G1H2(665),24,2)
  call Hotf_4pt_reduction(G2H2(163),RedSet_4(56),mass4set(:,5),  & 
G1H2(669),G1H2(670),G1H2(671),G1H2(672),G1H2(673),2)
  call HG1shiftOLR(G1H2(670),20,2)
  call Hotf_4pt_reduction(G2H2(167),RedSet_4(71),mass4set(:,2),  & 
G1H2(674),G1H2(675),G1H2(676),G1H2(677),G1H2(678),2)
  call HG1shiftOLR(G1H2(675),24,2)
  call Hotf_4pt_reduction(G2H2(171),RedSet_4(71),mass4set(:,2),  & 
G1H2(679),G1H2(680),G1H2(681),G1H2(682),G1H2(683),2)
  call HG1shiftOLR(G1H2(680),24,2)
  call Hotf_5pt_reduction(G2H2(172),RedSet_5(18),mass5set(:,3),  & 
G1H2(684),G1H2(685),G1H2(686),G1H2(687),G1H2(688),G1H2(689),2)
  call HG1shiftOLR(G1H2(685),16,2)
  call Hotf_4pt_reduction(G2H2(175),RedSet_4(104),mass4set(:,1),  & 
G1H2(690),G1H2(691),G1H2(692),G1H2(693),G1H2(694),2)
  call HG1shiftOLR(G1H2(691),20,2)
  call Hotf_5pt_reduction(G2H2(176),RedSet_5(18),mass5set(:,18),  & 
G1H2(695),G1H2(696),G1H2(697),G1H2(698),G1H2(699),G1H2(700),2)
  call HG1shiftOLR(G1H2(696),16,2)
  call Hotf_4pt_reduction(G2H2(179),RedSet_4(104),mass4set(:,6),  & 
G1H2(701),G1H2(702),G1H2(703),G1H2(704),G1H2(705),2)
  call HG1shiftOLR(G1H2(702),20,2)
  call Hotf_5pt_reduction(G2H2(180),RedSet_5(19),mass5set(:,3),  & 
G1H2(706),G1H2(707),G1H2(708),G1H2(709),G1H2(710),G1H2(711),2)
  call HG1shiftOLR(G1H2(707),16,2)
  call Hotf_4pt_reduction(G2H2(182),RedSet_4(105),mass4set(:,1),  & 
G1H2(712),G1H2(713),G1H2(714),G1H2(715),G1H2(716),2)
  call HG1shiftOLR(G1H2(713),19,2)
  call Hotf_5pt_reduction(G2H2(183),RedSet_5(19),mass5set(:,4),  & 
G1H2(717),G1H2(718),G1H2(719),G1H2(720),G1H2(721),G1H2(722),2)
  call HG1shiftOLR(G1H2(718),16,2)
  call Hotf_4pt_reduction(G2H2(185),RedSet_4(105),mass4set(:,7),  & 
G1H2(723),G1H2(724),G1H2(725),G1H2(726),G1H2(727),2)
  call HG1shiftOLR(G1H2(724),19,2)
  call Hotf_5pt_reduction(G2H2(186),RedSet_5(20),mass5set(:,3),  & 
G1H2(728),G1H2(729),G1H2(730),G1H2(731),G1H2(732),G1H2(733),2)
  call HG1shiftOLR(G1H2(729),16,2)
  call Hotf_4pt_reduction(G2H2(189),RedSet_4(106),mass4set(:,1),  & 
G1H2(734),G1H2(735),G1H2(736),G1H2(737),G1H2(738),2)
  call HG1shiftOLR(G1H2(735),24,2)
  call Hotf_5pt_reduction(G2H2(190),RedSet_5(20),mass5set(:,18),  & 
G1H2(739),G1H2(740),G1H2(741),G1H2(742),G1H2(743),G1H2(744),2)
  call HG1shiftOLR(G1H2(740),16,2)
  call Hotf_4pt_reduction(G2H2(193),RedSet_4(106),mass4set(:,6),  & 
G1H2(745),G1H2(746),G1H2(747),G1H2(748),G1H2(749),2)
  call HG1shiftOLR(G1H2(746),24,2)
  call Hotf_5pt_reduction(G2H2(194),RedSet_5(21),mass5set(:,3),  & 
G1H2(750),G1H2(751),G1H2(752),G1H2(753),G1H2(754),G1H2(755),2)
  call HG1shiftOLR(G1H2(751),16,2)
  call Hotf_4pt_reduction(G2H2(196),RedSet_4(107),mass4set(:,1),  & 
G1H2(756),G1H2(757),G1H2(758),G1H2(759),G1H2(760),2)
  call HG1shiftOLR(G1H2(757),19,2)
  call Hotf_5pt_reduction(G2H2(197),RedSet_5(21),mass5set(:,4),  & 
G1H2(761),G1H2(762),G1H2(763),G1H2(764),G1H2(765),G1H2(766),2)
  call HG1shiftOLR(G1H2(762),16,2)
  call Hotf_4pt_reduction(G2H2(199),RedSet_4(107),mass4set(:,7),  & 
G1H2(767),G1H2(768),G1H2(769),G1H2(770),G1H2(771),2)
  call HG1shiftOLR(G1H2(768),19,2)
  call Hotf_4pt_reduction(G2H2(202),RedSet_4(13),mass4set(:,8),  & 
G1H2(772),G1H2(773),G1H2(774),G1H2(775),G1H2(776),2)
  call HG1shiftOLR(G1H2(773),11,2)
  call Hotf_4pt_reduction(G2H2(205),RedSet_4(13),mass4set(:,8),  & 
G1H2(777),G1H2(778),G1H2(779),G1H2(780),G1H2(781),2)
  call HG1shiftOLR(G1H2(778),11,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(777),[G1H2(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(772),[G1H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(634),[G1H2(325)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(639),[G1H2(343)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(644),[G1H2(355)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(649),[G1H2(373)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(654),[G1H2(391)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(659),[G1H2(409)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(664),[G1H2(427)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(669),[G1H2(445)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(674),[G1H2(487)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(679),[G1H2(523)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(596),[G1H2(595)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(607),[G1H2(606)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(618),[G1H2(617)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(629),[G1H2(628)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(690),[G1H2(689)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(701),[G1H2(700)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(712),[G1H2(711)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(723),[G1H2(722)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(734),[G1H2(733)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(745),[G1H2(744)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(756),[G1H2(755)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(767),[G1H2(766)])
  call Hloop_ZQ_A(ntryL,G1H2(91),ex4(:),G1H1(1),ngZd,m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(29),n2h1(45))
  call Hloop_ZQ_A(ntryL,G1H2(97),ex4(:),G1H1(1),ngZd,m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(31),n2h1(46))
  call Hloop_ZQ_A(ntryL,G1H2(777),ex4(:),G1H1(1),ngZd,m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(33),n2h1(47))
  call Hloop_VQ_A(ntryL,G1H2(115),ex4(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(35),n2h1(48))
  call Hloop_VQ_A(ntryL,G1H2(121),ex4(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(37),n2h1(49))
  call Hloop_VQ_A(ntryL,G1H2(772),ex4(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(39),n2h1(50))
  call Hloop_VQ_A(ntryL,G1H2(7),ex4(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(41),n2h1(51))
  call Hloop_VQ_A(ntryL,G1H2(13),ex4(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(43),n2h1(52))
  call Hloop_VQ_A(ntryL,G1H2(26),ex4(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(45),n2h1(53))
  call Hloop_ZQ_A(ntryL,G1H2(31),ex4(:),G1H1(1),ngZd,m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(46),n2h1(54))
  call Hloop_ZQ_A(ntryL,G1H2(32),ex4(:),G1H1(1),ngZd,m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(47),n2h1(55))
  call Hloop_ZQ_A(ntryL,G1H2(44),ex4(:),G1H1(1),ngZd,m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(48),n2h1(56))
  call Hloop_WQ_A(ntryL,G1H2(49),ex4(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(49),n2h1(57))
  call Hloop_WQ_A(ntryL,G1H2(50),ex4(:),G1H1(1),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(50),n2h1(58))
  call Hloop_WQ_A(ntryL,G1H2(62),ex4(:),G1H1(1),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(51),n2h1(59))
  call Hloop_WQ_A(ntryL,G1H2(79),ex4(:),G1H1(1),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(52),n2h1(60))
  call Hloop_WQ_A(ntryL,G1H2(85),ex4(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(53),n2h1(61))
  call Hloop_WQ_A(ntryL,G1H2(6),ex4(:),G1H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(54),n2h1(62))
  call Hloop_WA_Q(ntryL,G1H2(67),ex3(:),G1H1(1),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(55),n2h1(63))
  call Hloop_WA_Q(ntryL,G1H2(12),ex3(:),G1H1(1),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(56),n2h1(64))
  call Hloop_WA_Q(ntryL,G1H2(36),ex3(:),G1H1(1),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(57),n2h1(65))
  call Hloop_AV_Q(ntryL,G1H2(132),ex5(:),G1H1(1),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(58),n2h1(66))
  call Hloop_AV_Q(ntryL,G1H2(42),ex5(:),G1H1(1),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(59),n2h1(67))
  call Hloop_AV_Q(ntryL,G1H2(78),ex5(:),G1H1(1),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(60),n2h1(68))
  call Hloop_ZA_Q(ntryL,G1H2(66),ex3(:),G1H1(1),ngZu,m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(61),n2h1(69))
  call Hloop_ZA_Q(ntryL,G1H2(72),ex3(:),G1H1(1),ngZu,m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(62),n2h1(70))
  call Hloop_ZA_Q(ntryL,G1H2(102),ex3(:),G1H1(1),ngZu,m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(63),n2h1(71))
  call Hloop_AV_Q(ntryL,G1H2(108),ex5(:),G1H1(1),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(64),n2h1(72))
  call Hloop_AV_Q(ntryL,G1H2(114),ex5(:),G1H1(1),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(65),n2h1(73))
  call Hloop_AV_Q(ntryL,G1H2(5),ex5(:),G1H1(1),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(66),n2h1(74))
  call Hloop_WA_Q(ntryL,G1H2(9),ex3(:),G1H1(1),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(67),n2h1(75))
  call Hloop_WA_Q(ntryL,G1H2(10),ex3(:),G1H1(1),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(68),n2h1(76))
  call Hloop_WA_Q(ntryL,G1H2(16),ex3(:),G1H1(1),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(69),n2h1(77))
  call Hloop_AV_Q(ntryL,G1H2(29),ex5(:),G1H1(1),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(70),n2h1(78))
  call Hloop_AV_Q(ntryL,G1H2(17),ex5(:),G1H1(1),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(71),n2h1(79))
  call Hloop_AV_Q(ntryL,G1H2(28),ex5(:),G1H1(1),m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(72),n2h1(80))
  call Hloop_VQ_A(ntryL,G1H2(33),ex4(:),G1H1(1),m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(73),n2h1(81))
  call Hloop_VQ_A(ntryL,G1H2(40),ex4(:),G1H1(1),m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(74),n2h1(82))
  call Hloop_VQ_A(ntryL,G1H2(41),ex4(:),G1H1(1),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(75),n2h1(83))
  call Hloop_QV_A(ntryL,G1H2(45),ex5(:),G1H1(1),m3h2x1(:,98),heltab2x2(:,:,98))



end subroutine vamp_1

end module ol_vamp_1_pplnjj_ew_neexuxdag_2_/**/REALKIND
