
module ol_colourmatrix_pplnjj_ew_nexecddxsx_3_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(69,3), K2(3,3), KL(3,3), Cas(6) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [   0,   0,   0]
  K1( 2,:) = [   0,   9,   0]
  K1( 3,:) = [   0,   0,   0]
  K1( 4,:) = [   0,   0,   0]
  K1( 5,:) = [   0,   0,   0]
  K1( 6,:) = [   0,   0,   0]
  K1( 7,:) = [   0,   0,   0]
  K1( 8,:) = [   0,   0,   0]
  K1( 9,:) = [   0,   0,   0]
  K1(10,:) = [   0,   0,   0]
  K1(11,:) = [   0,   0,   0]
  K1(12,:) = [   0,   0,   0]
  K1(13,:) = [   0,   0,   0]
  K1(14,:) = [   0,   0,   0]
  K1(15,:) = [   0,   0,   0]
  K1(16,:) = [   0,   0,   0]
  K1(17,:) = [   0,   0,   0]
  K1(18,:) = [   0,   0,   0]
  K1(19,:) = [   0,   0,   0]
  K1(20,:) = [   0,  12,   0]
  K1(21,:) = [   0,   0,   0]
  K1(22,:) = [   0,   0,   0]
  K1(23,:) = [   0,   0,   0]
  K1(24,:) = [   0,   0,   0]
  K1(25,:) = [   0,   0,   0]
  K1(26,:) = [   0,   0,   0]
  K1(27,:) = [   0,   0,   0]
  K1(28,:) = [   0,   0,   0]
  K1(29,:) = [   0,   0,   0]
  K1(30,:) = [   0,   0,   0]
  K1(31,:) = [   0,   0,   0]
  K1(32,:) = [   0,  12,   0]
  K1(33,:) = [   0,   0,   0]
  K1(34,:) = [   0,   0,   0]
  K1(35,:) = [   0,   0,   0]
  K1(36,:) = [   0,   0,   0]
  K1(37,:) = [   0,   0,   0]
  K1(38,:) = [   0,   0,   0]
  K1(39,:) = [   0,   0,   0]
  K1(40,:) = [   0,   0,   0]
  K1(41,:) = [   0,   0,   0]
  K1(42,:) = [   0,   0,   0]
  K1(43,:) = [   0,   0,   0]
  K1(44,:) = [   0, -12,   0]
  K1(45,:) = [   0,   0,   0]
  K1(46,:) = [   0,   0,   0]
  K1(47,:) = [   0,  12,   0]
  K1(48,:) = [   0,   0,   0]
  K1(49,:) = [   0,   0,   0]
  K1(50,:) = [   0,   0,   0]
  K1(51,:) = [   0,   0,   0]
  K1(52,:) = [   0,   0,   0]
  K1(53,:) = [   0,   0,   0]
  K1(54,:) = [   0,   0,   0]
  K1(55,:) = [   0,   0,   0]
  K1(56,:) = [   0, -12,   0]
  K1(57,:) = [   0,   0,   0]
  K1(58,:) = [   0,   0,   0]
  K1(59,:) = [   0,   0,   0]
  K1(60,:) = [   0,   0,   0]
  K1(61,:) = [   0,   0,   0]
  K1(62,:) = [   0,   0,   0]
  K1(63,:) = [   0,   0,   0]
  K1(64,:) = [   0,   0,   0]
  K1(65,:) = [   0,  12,   0]
  K1(66,:) = [   0,   0,   0]
  K1(67,:) = [   0,   9,   0]
  K1(68,:) = [   9,   0,   3]
  K1(69,:) = [   0,   3,   0]

  K2(1,:) = [ 0, 9, 0]
  K2(2,:) = [ 9, 0, 3]
  K2(3,:) = [ 0, 3, 0]

  KL(1,:) = [ 0, 9, 0]
  KL(2,:) = [ 9, 0, 3]
  KL(3,:) = [ 0, 3, 0]

#if -1 > 0
    co = 0
    do k = 1, 6
      co = co + k
      Cas(k) = K1(1+3*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_pplnjj_ew_nexecddxsx_3_/**/REALKIND



module ol_forced_parameters_pplnjj_ew_nexecddxsx_3_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pplnjj_ew_nexecddxsx_3_/**/REALKIND


! **********************************************************************
module ol_loop_storage_pplnjj_ew_nexecddxsx_3_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 64 ! number of helicity configurations
  integer(intkind2), save :: nhel = 64 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: hel_states = 64 ! number of helicity configurations needed for mem-allocation
  integer(intkind2), save :: Hel(64) ! physical helicity states
#endif

  type(Hpolcont), save, allocatable :: A(:,:), M1helarray(:,:), M1helarray_ct(:,:)
  complex(REALKIND), save :: den(151)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,21), wf8(8,108), wf16(16,31), wf64(64,142)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(206), c(184)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save, allocatable :: M0_col1_helarray(:,:), M0M1_hel_cc(:,:,:)
  complex(REALKIND), save :: M2ctcc(22)

end module ol_loop_storage_pplnjj_ew_nexecddxsx_3_/**/REALKIND






! **********************************************************************
module ol_loop_pplnjj_ew_nexecddxsx_3_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_pplnjj_ew_nexecddxsx_3_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(  1) = (CI*countertermnorm*eQED**6)/(cw*sqrt2)
    f(  2) = (CI*eQED**4)/(4._/**/REALKIND*sw**4)
    f(  3) = (CI*countertermnorm*eQED**6)/(4._/**/REALKIND*sw**4)
    f(  4) = (CI*countertermnorm*eQED**6*EWctVdu)/(4._/**/REALKIND*sw**4)
    f(  5) = (CI*countertermnorm*eQED**6*EWctVen)/(4._/**/REALKIND*sw**4)
    f(  6) = (CI*countertermnorm*eQED**6*EWctVud)/(4._/**/REALKIND*sw**4)
    f(  7) = (CI*countertermnorm*eQED**4*gQCD**2)/(4._/**/REALKIND*sw**4)
    f(  8) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**2)/(4._/**/REALKIND*sw**4)
    f(  9) = (CI*countertermnorm*ctVsc*eQED**4*gQCD**2)/(4._/**/REALKIND*sw**4)
    f( 10) = (CI*cw*eQED**4)/(2._/**/REALKIND*sw**3)
    f( 11) = (CI*countertermnorm*cw*eQED**6)/(6._/**/REALKIND*sw**3)
    f( 12) = (CI*countertermnorm*cw*eQED**6)/(2._/**/REALKIND*sw**3)
    f( 13) = (CI*countertermnorm*cw*eQED**6*EWctVdu)/(2._/**/REALKIND*sw**3)
    f( 14) = (CI*countertermnorm*cw*eQED**6*EWctVen)/(2._/**/REALKIND*sw**3)
    f( 15) = (CI*countertermnorm*ctVqq*cw*eQED**4*gQCD**2)/(2._/**/REALKIND*sw**3)
    f( 16) = (CI*countertermnorm*ctVsc*cw*eQED**4*gQCD**2)/(2._/**/REALKIND*sw**3)
    f( 17) = (CI*eQED**4)/(18._/**/REALKIND*sw**2)
    f( 18) = (CI*eQED**4)/(9._/**/REALKIND*sw**2)
    f( 19) = (CI*eQED**4)/(6._/**/REALKIND*sw**2)
    f( 20) = (CI*eQED**4)/(2._/**/REALKIND*sw**2)
    f( 21) = (CI*countertermnorm*eQED**6)/(18._/**/REALKIND*sw**2)
    f( 22) = (CI*countertermnorm*eQED**6)/(9._/**/REALKIND*sw**2)
    f( 23) = (CI*countertermnorm*eQED**6)/(6._/**/REALKIND*sw**2)
    f( 24) = (CI*countertermnorm*eQED**6)/(3._/**/REALKIND*sw**2)
    f( 25) = (CI*countertermnorm*eQED**6)/(2._/**/REALKIND*sw**2)
    f( 26) = (CI*countertermnorm*eQED**6*EWctAWW)/(6._/**/REALKIND*sw**2)
    f( 27) = (CI*countertermnorm*eQED**6*EWctVdu)/(18._/**/REALKIND*sw**2)
    f( 28) = (CI*countertermnorm*eQED**6*EWctVdu)/(9._/**/REALKIND*sw**2)
    f( 29) = (CI*countertermnorm*eQED**6*EWctVdu)/(6._/**/REALKIND*sw**2)
    f( 30) = (CI*countertermnorm*eQED**6*EWctVdu)/(2._/**/REALKIND*sw**2)
    f( 31) = (CI*countertermnorm*eQED**6*EWctVen)/(18._/**/REALKIND*sw**2)
    f( 32) = (CI*countertermnorm*eQED**6*EWctVen)/(9._/**/REALKIND*sw**2)
    f( 33) = (CI*countertermnorm*eQED**6*EWctVen)/(6._/**/REALKIND*sw**2)
    f( 34) = (CI*countertermnorm*eQED**6*EWctVen)/(2._/**/REALKIND*sw**2)
    f( 35) = (CI*countertermnorm*eQED**6*EWctZWW)/(2._/**/REALKIND*sw**2)
    f( 36) = (CI*eQED**2*gQCD**2)/(2._/**/REALKIND*sw**2)
    f( 37) = (CI*countertermnorm*eQED**4*gQCD**2)/(18._/**/REALKIND*sw**2)
    f( 38) = (CI*countertermnorm*eQED**4*gQCD**2)/(9._/**/REALKIND*sw**2)
    f( 39) = (CI*countertermnorm*eQED**4*gQCD**2)/(6._/**/REALKIND*sw**2)
    f( 40) = (CI*countertermnorm*eQED**4*gQCD**2)/(2._/**/REALKIND*sw**2)
    f( 41) = (CI*countertermnorm*ctVcc*eQED**4*gQCD**2)/(9._/**/REALKIND*sw**2)
    f( 42) = (CI*countertermnorm*ctVcc*eQED**4*gQCD**2)/(2._/**/REALKIND*sw**2)
    f( 43) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**2)/(18._/**/REALKIND*sw**2)
    f( 44) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**2)/(9._/**/REALKIND*sw**2)
    f( 45) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**2)/(6._/**/REALKIND*sw**2)
    f( 46) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**2)/(2._/**/REALKIND*sw**2)
    f( 47) = (CI*countertermnorm*ctVsc*eQED**4*gQCD**2)/(18._/**/REALKIND*sw**2)
    f( 48) = (CI*countertermnorm*ctVsc*eQED**4*gQCD**2)/(9._/**/REALKIND*sw**2)
    f( 49) = (CI*countertermnorm*ctVsc*eQED**4*gQCD**2)/(6._/**/REALKIND*sw**2)
    f( 50) = (CI*countertermnorm*ctVsc*eQED**4*gQCD**2)/(2._/**/REALKIND*sw**2)
    f( 51) = (CI*countertermnorm*eQED**4*EWctVdu*gQCD**2)/(2._/**/REALKIND*sw**2)
    f( 52) = (CI*countertermnorm*eQED**4*EWctVen*gQCD**2)/(2._/**/REALKIND*sw**2)
    f( 53) = (CI*countertermnorm*eQED**6*MW)/(6._/**/REALKIND*sw**2)
    f( 54) = (CI*countertermnorm*eQED**4*gQCD**2)/(2._/**/REALKIND*cw*sw)
    f( 55) = (CI*countertermnorm*eQED**6*MW)/(2._/**/REALKIND*cw*sw)
    f( 56) = (CI*countertermnorm*eQED**6)/(3._/**/REALKIND*sqrt2*sw)
    f( 57) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*18._/**/REALKIND)
    f( 58) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*9._/**/REALKIND)
    f( 59) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*6._/**/REALKIND)
    f( 60) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*2._/**/REALKIND)
    f( 61) = (eQED**4*gQCD**2*integralnorm*MW**2*SwB)/(cw**2*2._/**/REALKIND)
    f( 62) = (eQED**6*integralnorm*SwB)/(sw**6*16._/**/REALKIND)
    f( 63) = (eQED**6*integralnorm*SwB)/(sw**6*8._/**/REALKIND)
    f( 64) = (eQED**6*integralnorm*SwB)/(sw**6*4._/**/REALKIND)
    f( 65) = (cw**2*eQED**6*integralnorm*SwB)/(sw**6*4._/**/REALKIND)
    f( 66) = (eQED**6*integralnorm*MW**2*SwB)/(sw**6*4._/**/REALKIND)
    f( 67) = (eQED**6*integralnorm*SwB)/(cw*sw**5*16._/**/REALKIND)
    f( 68) = (eQED**6*integralnorm*SwB)/(cw*sw**5*8._/**/REALKIND)
    f( 69) = (cw*eQED**6*integralnorm*SwB)/(sw**5*8._/**/REALKIND)
    f( 70) = (cw*eQED**6*integralnorm*SwB)/(sw**5*4._/**/REALKIND)
    f( 71) = (cw*eQED**6*integralnorm*SwB)/(sw**5*2._/**/REALKIND)
    f( 72) = (cw**3*eQED**6*integralnorm*SwB)/(sw**5*2._/**/REALKIND)
    f( 73) = (eQED**6*integralnorm*MW**2*SwB)/(cw**3*sw**5*2._/**/REALKIND)
    f( 74) = (eQED**6*integralnorm*MW**2*SwB)/(cw*sw**5*2._/**/REALKIND)
    f( 75) = (cw*eQED**6*integralnorm*MW**2*SwB)/(sw**5*4._/**/REALKIND)
    f( 76) = (cw*eQED**6*integralnorm*MW**2*SwB)/(sw**5*2._/**/REALKIND)
    f( 77) = (eQED**6*integralnorm*SwB)/(sw**4*72._/**/REALKIND)
    f( 78) = (eQED**6*integralnorm*SwB)/(sw**4*36._/**/REALKIND)
    f( 79) = (eQED**6*integralnorm*SwB)/(sw**4*24._/**/REALKIND)
    f( 80) = (eQED**6*integralnorm*SwB)/(sw**4*18._/**/REALKIND)
    f( 81) = (eQED**6*integralnorm*SwB)/(sw**4*12._/**/REALKIND)
    f( 82) = (eQED**6*integralnorm*SwB)/(sw**4*9._/**/REALKIND)
    f( 83) = (eQED**6*integralnorm*SwB)/(sw**4*8._/**/REALKIND)
    f( 84) = (eQED**6*integralnorm*SwB)/(sw**4*6._/**/REALKIND)
    f( 85) = (eQED**6*integralnorm*SwB)/(sw**4*4._/**/REALKIND)
    f( 86) = (eQED**6*integralnorm*SwB)/(cw**2*sw**4*8._/**/REALKIND)
    f( 87) = (cw**2*eQED**6*integralnorm*SwB)/(sw**4*18._/**/REALKIND)
    f( 88) = (cw**2*eQED**6*integralnorm*SwB)/(sw**4*9._/**/REALKIND)
    f( 89) = (cw**2*eQED**6*integralnorm*SwB)/(sw**4*6._/**/REALKIND)
    f( 90) = (cw**2*eQED**6*integralnorm*SwB)/(sw**4*2._/**/REALKIND)
    f( 91) = (eQED**4*gQCD**2*integralnorm*SwB)/(sw**4*8._/**/REALKIND)
    f( 92) = (eQED**4*gQCD**2*integralnorm*SwB)/(sw**4*4._/**/REALKIND)
    f( 93) = (cw**2*eQED**4*gQCD**2*integralnorm*SwB)/(sw**4*2._/**/REALKIND)
    f( 94) = (eQED**6*integralnorm*MH**2*SwB)/(sw**4*24._/**/REALKIND)
    f( 95) = (eQED**6*integralnorm*MH**2*SwB)/(sw**4*12._/**/REALKIND)
    f( 96) = (eQED**6*integralnorm*MW**2*SwB)/(sw**4*18._/**/REALKIND)
    f( 97) = (eQED**6*integralnorm*MW**2*SwB)/(sw**4*12._/**/REALKIND)
    f( 98) = (eQED**6*integralnorm*MW**2*SwB)/(sw**4*9._/**/REALKIND)
    f( 99) = (eQED**6*integralnorm*MW**2*SwB)/(sw**4*6._/**/REALKIND)
    f(100) = (eQED**6*integralnorm*MW**2*SwB)/(sw**4*4._/**/REALKIND)
    f(101) = (eQED**6*integralnorm*MW**2*SwB)/(sw**4*2._/**/REALKIND)
    f(102) = (eQED**6*integralnorm*MW**2*SwB)/(cw**4*sw**4*2._/**/REALKIND)
    f(103) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*sw**4*2._/**/REALKIND)
    f(104) = (eQED**4*gQCD**2*integralnorm*MW**2*SwB)/(sw**4*2._/**/REALKIND)
    f(105) = (eQED**6*integralnorm*SwB)/(cw*sw**3*8._/**/REALKIND)
    f(106) = (cw*eQED**6*integralnorm*SwB)/(sw**3*18._/**/REALKIND)
    f(107) = (cw*eQED**6*integralnorm*SwB)/(sw**3*9._/**/REALKIND)
    f(108) = (cw*eQED**6*integralnorm*SwB)/(sw**3*6._/**/REALKIND)
    f(109) = (cw*eQED**6*integralnorm*SwB)/(sw**3*3._/**/REALKIND)
    f(110) = (cw*eQED**6*integralnorm*SwB)/(sw**3*2._/**/REALKIND)
    f(111) = (cw*eQED**4*gQCD**2*integralnorm*SwB)/(sw**3*2._/**/REALKIND)
    f(112) = (eQED**6*integralnorm*MH**2*SwB)/(cw*sw**3*8._/**/REALKIND)
    f(113) = (eQED**6*integralnorm*MW**2*SwB)/(cw**3*sw**3*4._/**/REALKIND)
    f(114) = (eQED**6*integralnorm*MW**2*SwB)/(cw*sw**3*4._/**/REALKIND)
    f(115) = (cw*eQED**6*integralnorm*MW**2*SwB)/(sw**3*2._/**/REALKIND)
    f(116) = (eQED**6*integralnorm*SwB)/(sw**2*162._/**/REALKIND)
    f(117) = (eQED**6*integralnorm*SwB)/(sw**2*81._/**/REALKIND)
    f(118) = (eQED**6*integralnorm*SwB)/(sw**2*54._/**/REALKIND)
    f(119) = (2*eQED**6*integralnorm*SwB)/(sw**2*81._/**/REALKIND)
    f(120) = (eQED**6*integralnorm*SwB)/(sw**2*27._/**/REALKIND)
    f(121) = (4*eQED**6*integralnorm*SwB)/(sw**2*81._/**/REALKIND)
    f(122) = (eQED**6*integralnorm*SwB)/(sw**2*18._/**/REALKIND)
    f(123) = (2*eQED**6*integralnorm*SwB)/(sw**2*27._/**/REALKIND)
    f(124) = (eQED**6*integralnorm*SwB)/(sw**2*9._/**/REALKIND)
    f(125) = (eQED**6*integralnorm*SwB)/(sw**2*6._/**/REALKIND)
    f(126) = (2*eQED**6*integralnorm*SwB)/(sw**2*9._/**/REALKIND)
    f(127) = (eQED**6*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f(128) = (eQED**6*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(129) = (eQED**4*gQCD**2*integralnorm*SwB)/(sw**2*18._/**/REALKIND)
    f(130) = (eQED**4*gQCD**2*integralnorm*SwB)/(sw**2*9._/**/REALKIND)
    f(131) = (eQED**4*gQCD**2*integralnorm*SwB)/(sw**2*6._/**/REALKIND)
    f(132) = (2*eQED**4*gQCD**2*integralnorm*SwB)/(sw**2*9._/**/REALKIND)
    f(133) = (eQED**4*gQCD**2*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f(134) = (eQED**4*gQCD**2*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(135) = (eQED**6*integralnorm*MW**2*SwB)/(sw**2*18._/**/REALKIND)
    f(136) = (eQED**6*integralnorm*MW**2*SwB)/(sw**2*9._/**/REALKIND)
    f(137) = (eQED**6*integralnorm*MW**2*SwB)/(sw**2*6._/**/REALKIND)
    f(138) = (eQED**6*integralnorm*MW**2*SwB)/(sw**2*2._/**/REALKIND)
    f(139) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*sw**2*4._/**/REALKIND)
    f(140) = (eQED**4*gQCD**2*integralnorm*MW**2*SwB)/(sw**2*2._/**/REALKIND)
    f(141) = (eQED**6*integralnorm*MW**2*SwB)/(cw*sw*6._/**/REALKIND)
    f(142) = (eQED**6*integralnorm*MW**2*SwB)/(cw*sw*3._/**/REALKIND)
    f(143) = (eQED**6*integralnorm*MW**2*SwB)/(cw*sw*2._/**/REALKIND)
    f(144) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**5*16._/**/REALKIND))
    f(145) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**5*8._/**/REALKIND))
    f(146) = -((eQED**6*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw**5*8._/**/REALKIND))
    f(147) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(sw**4*12._/**/REALKIND))
    f(148) = -((eQED**6*integralnorm*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*sw**4*4._/**/REALKIND*8._/**/REALKIND))
    f(149) = (eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**2*sw**2*12._/**/REALKIND)
    f(150) = -((eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(sw**4*12._/**/REALKIND))
    f(151) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*12._/**/REALKIND))
    f(152) = (eQED**6*integralnorm*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw*sw**5*4._/**/REALKIND*8._/**/REALKIND)
    f(153) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*6._/**/REALKIND))
    f(154) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*4._/**/REALKIND))
    f(155) = -((eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*4._/**/REALKIND))
    f(156) = -((eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw*4._/**/REALKIND))
    f(157) = (eQED**6*integralnorm*SwF)/(sw**6*8._/**/REALKIND)
    f(158) = (eQED**6*integralnorm*SwF)/(sw**6*4._/**/REALKIND)
    f(159) = (cw*eQED**6*integralnorm*SwF)/(sw**5*4._/**/REALKIND)
    f(160) = (cw*eQED**6*integralnorm*SwF)/(sw**5*2._/**/REALKIND)
    f(161) = (eQED**6*integralnorm*SwF)/(sw**4*36._/**/REALKIND)
    f(162) = (eQED**6*integralnorm*SwF)/(sw**4*18._/**/REALKIND)
    f(163) = (eQED**6*integralnorm*SwF)/(sw**4*12._/**/REALKIND)
    f(164) = (eQED**6*integralnorm*SwF)/(sw**4*9._/**/REALKIND)
    f(165) = (eQED**6*integralnorm*SwF)/(sw**4*6._/**/REALKIND)
    f(166) = (eQED**6*integralnorm*SwF)/(sw**4*4._/**/REALKIND)
    f(167) = (eQED**6*integralnorm*SwF)/(sw**4*2._/**/REALKIND)
    f(168) = (eQED**4*gQCD**2*integralnorm*SwF)/(sw**4*4._/**/REALKIND)
    f(169) = (eQED**4*gQCD**2*integralnorm*SwF)/(sw**4*2._/**/REALKIND)
    f(170) = (eQED**6*integralnorm*MB*SwF)/(sw**4*36._/**/REALKIND)
    f(171) = (eQED**6*integralnorm*MB*SwF)/(sw**4*4._/**/REALKIND)
    f(172) = (eQED**6*integralnorm*ML*SwF)/(sw**4*12._/**/REALKIND)
    f(173) = (eQED**6*integralnorm*ML*SwF)/(sw**4*4._/**/REALKIND)
    f(174) = (eQED**6*integralnorm*MM*SwF)/(sw**4*12._/**/REALKIND)
    f(175) = (eQED**6*integralnorm*MM*SwF)/(sw**4*4._/**/REALKIND)
    f(176) = (eQED**6*integralnorm*MT*SwF)/(sw**4*18._/**/REALKIND)
    f(177) = (eQED**6*integralnorm*MT*SwF)/(sw**4*4._/**/REALKIND)
    f(178) = (eQED**6*integralnorm*SwF)/(cw*sw**3*4._/**/REALKIND)
    f(179) = (cw*eQED**6*integralnorm*SwF)/(sw**3*18._/**/REALKIND)
    f(180) = (cw*eQED**6*integralnorm*SwF)/(sw**3*9._/**/REALKIND)
    f(181) = (cw*eQED**6*integralnorm*SwF)/(sw**3*6._/**/REALKIND)
    f(182) = (2*cw*eQED**6*integralnorm*SwF)/(sw**3*9._/**/REALKIND)
    f(183) = (cw*eQED**6*integralnorm*SwF)/(sw**3*2._/**/REALKIND)
    f(184) = (cw*eQED**6*integralnorm*SwF)/sw**3
    f(185) = (3*cw*eQED**6*integralnorm*SwF)/(sw**3*2._/**/REALKIND)
    f(186) = (eQED**6*integralnorm*ML*SwF)/(cw*sw**3*4._/**/REALKIND)
    f(187) = (eQED**6*integralnorm*MM*SwF)/(cw*sw**3*4._/**/REALKIND)
    f(188) = (eQED**6*integralnorm*SwF)/(sw**2*162._/**/REALKIND)
    f(189) = (eQED**6*integralnorm*SwF)/(sw**2*81._/**/REALKIND)
    f(190) = (eQED**6*integralnorm*SwF)/(sw**2*54._/**/REALKIND)
    f(191) = (2*eQED**6*integralnorm*SwF)/(sw**2*81._/**/REALKIND)
    f(192) = (eQED**6*integralnorm*SwF)/(sw**2*27._/**/REALKIND)
    f(193) = (4*eQED**6*integralnorm*SwF)/(sw**2*81._/**/REALKIND)
    f(194) = (eQED**6*integralnorm*SwF)/(sw**2*18._/**/REALKIND)
    f(195) = (2*eQED**6*integralnorm*SwF)/(sw**2*27._/**/REALKIND)
    f(196) = (8*eQED**6*integralnorm*SwF)/(sw**2*81._/**/REALKIND)
    f(197) = (eQED**6*integralnorm*SwF)/(sw**2*9._/**/REALKIND)
    f(198) = (4*eQED**6*integralnorm*SwF)/(sw**2*27._/**/REALKIND)
    f(199) = (eQED**6*integralnorm*SwF)/(sw**2*6._/**/REALKIND)
    f(200) = (2*eQED**6*integralnorm*SwF)/(sw**2*9._/**/REALKIND)
    f(201) = (eQED**6*integralnorm*SwF)/(sw**2*3._/**/REALKIND)
    f(202) = (4*eQED**6*integralnorm*SwF)/(sw**2*9._/**/REALKIND)
    f(203) = (eQED**6*integralnorm*SwF)/(sw**2*2._/**/REALKIND)
    f(204) = (2*eQED**6*integralnorm*SwF)/(sw**2*3._/**/REALKIND)
    f(205) = (eQED**6*integralnorm*SwF)/sw**2
    f(206) = (3*eQED**6*integralnorm*SwF)/(sw**2*2._/**/REALKIND)

  c = [ 6*f(57), 6*f(58), 6*f(59), 6*f(60), f(61), 3*f(61), 6*f(62), 6*f(63), 6*f(64), 6*f(65), 6*f(66), 6*f(67), 6*f(68), 6*f(69) &
    , 6*f(70), 6*f(71), 6*f(72), 6*f(73), 6*f(74), 6*f(75), 6*f(76), 6*f(77), 6*f(78), 6*f(79), 6*f(80), 6*f(81), 6*f(82), 6*f(83) &
    , 6*f(84), 6*f(85), 6*f(86), 6*f(87), 6*f(88), 6*f(89), 6*f(90), f(91), 3*f(91), f(92), 3*f(92), 8*f(92), f(93), 3*f(93) &
    , 6*f(94), 6*f(95), 6*f(96), 6*f(97), 6*f(98), 6*f(99), 6*f(100), 6*f(101), 6*f(102), 6*f(103), f(104), 3*f(104), 6*f(105) &
    , 6*f(106), 6*f(107), 6*f(108), 6*f(109), 6*f(110), f(111), 3*f(111), 8*f(111), 6*f(112), 6*f(113), 6*f(114), 6*f(115) &
    , 6*f(116), 6*f(117), 6*f(118), 6*f(119), 6*f(120), 6*f(121), 6*f(122), 6*f(123), 6*f(124), 6*f(125), 6*f(126), 6*f(127) &
    , 6*f(128), f(129), 3*f(129), 8*f(129), f(130), 3*f(130), 8*f(130), f(131), 3*f(131), 8*f(131), f(132), 3*f(132), f(133) &
    , 3*f(133), f(134), 3*f(134), 8*f(134), 6*f(135), 6*f(136), 6*f(137), 6*f(138), 6*f(139), f(140), 3*f(140), 6*f(141), 6*f(142) &
    , 6*f(143), 6*f(144), 6*f(145), 6*f(146), 6*f(147), 6*f(148), 6*f(149), 6*f(150), 6*f(151), 6*f(152), 6*f(153), 6*f(154) &
    , 6*f(155), 6*f(156), 6*f(157), 18*f(157), 18*f(158), 6*f(159), 18*f(159), 18*f(160), 6*f(161), 18*f(161), 6*f(162), 18*f(162) &
    , 6*f(163), 18*f(163), 18*f(164), 18*f(165), 6*f(166), 18*f(166), 18*f(167), f(168), 3*f(168), 9*f(168), 3*f(169), 9*f(169) &
    , 18*f(170), 18*f(171), 6*f(172), 6*f(173), 6*f(174), 6*f(175), 18*f(176), 18*f(177), 18*f(178), 18*f(179), 18*f(180) &
    , 6*f(181), 18*f(182), 6*f(183), 18*f(183), 18*f(184), 6*f(185), 6*f(186), 6*f(187), 18*f(188), 18*f(189), 18*f(190) &
    , 18*f(191), 18*f(192), 18*f(193), 6*f(194), 18*f(194), 18*f(195), 18*f(196), 6*f(197), 18*f(197), 18*f(198), 6*f(199) &
    , 18*f(199), 18*f(200), 6*f(201), 18*f(201), 18*f(202), 6*f(203), 18*f(203), 18*f(204), 18*f(205), 6*f(206) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3) - MW2)+L(6,3))
  den(2) = 1 /((L(5,36) - MW2)+L(6,36))
  den(3) = 1 /((L(5,24))+L(6,24))
  den(6) = 1 /((L(5,24) - MZ2)+L(6,24))
  den(8) = 1 /((L(5,7))+L(6,7))
  den(12) = 1 /((L(5,28))+L(6,28))
  den(17) = 1 /((L(5,44))+L(6,44))
  den(20) = 1 /((L(5,37))+L(6,37))
  den(24) = 1 /((L(5,25))+L(6,25))
  den(27) = 1 /((L(5,19))+L(6,19))
  den(30) = 1 /((L(5,35))+L(6,35))
  den(34) = 1 /((L(5,56))+L(6,56))
  den(39) = 1 /((L(5,26))+L(6,26))
  den(44) = 1 /((L(5,38))+L(6,38))
  den(49) = 1 /((L(5,60) - MW2)+L(6,60))
  den(56) = 1 /((L(5,27) - MW2)+L(6,27))
  den(62) = 1 /((L(5,39))+L(6,39))
  den(65) = 1 /((L(5,39) - MZ2)+L(6,39))
  den(103) = 1 /((L(5,39) - MH2)+L(6,39))

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(7) = den(4)*den(6)
  den(9) = den(1)*den(8)
  den(10) = den(3)*den(9)
  den(11) = den(6)*den(9)
  den(13) = den(3)*den(12)
  den(14) = den(1)*den(13)
  den(15) = den(6)*den(12)
  den(16) = den(1)*den(15)
  den(18) = den(2)*den(17)
  den(19) = den(1)*den(18)
  den(21) = den(2)*den(20)
  den(22) = den(3)*den(21)
  den(23) = den(6)*den(21)
  den(25) = den(6)*den(24)
  den(26) = den(2)*den(25)
  den(28) = den(1)*den(27)
  den(29) = den(2)*den(28)
  den(31) = den(1)*den(30)
  den(32) = den(3)*den(31)
  den(33) = den(6)*den(31)
  den(35) = den(3)*den(34)
  den(36) = den(1)*den(35)
  den(37) = den(6)*den(34)
  den(38) = den(1)*den(37)
  den(40) = den(3)*den(39)
  den(41) = den(2)*den(40)
  den(42) = den(6)*den(39)
  den(43) = den(2)*den(42)
  den(45) = den(2)*den(44)
  den(46) = den(3)*den(45)
  den(47) = den(6)*den(45)
  den(48) = den(2)*den(3)
  den(50) = den(48)*den(49)
  den(51) = den(1)*den(50)
  den(52) = den(2)*den(6)
  den(53) = den(49)*den(52)
  den(54) = den(1)*den(53)
  den(55) = den(1)*den(3)
  den(57) = den(55)*den(56)
  den(58) = den(2)*den(57)
  den(59) = den(1)*den(6)
  den(60) = den(56)*den(59)
  den(61) = den(2)*den(60)
  den(63) = den(4)*den(62)
  den(64) = den(3)*den(63)
  den(66) = den(4)*den(65)
  den(67) = den(3)*den(66)
  den(68) = den(6)*den(63)
  den(69) = den(6)*den(66)
  den(70) = den(1)**2
  den(71) = den(35)*den(70)
  den(72) = den(37)*den(70)
  den(73) = den(13)*den(70)
  den(74) = den(15)*den(70)
  den(75) = den(3)**2
  den(76) = den(31)*den(75)
  den(77) = den(3)*den(6)
  den(78) = den(31)*den(77)
  den(79) = den(6)**2
  den(80) = den(31)*den(79)
  den(81) = den(9)*den(35)
  den(82) = den(9)*den(37)
  den(83) = den(13)*den(31)
  den(84) = den(15)*den(31)
  den(85) = den(9)*den(75)
  den(86) = den(9)*den(77)
  den(87) = den(9)*den(79)
  den(88) = den(18)*den(70)
  den(89) = den(2)**2
  den(90) = den(28)*den(89)
  den(91) = den(18)*den(28)
  den(92) = den(21)*den(40)
  den(93) = den(21)*den(42)
  den(94) = den(25)*den(45)
  den(95) = den(40)*den(89)
  den(96) = den(42)*den(89)
  den(97) = den(45)*den(77)
  den(98) = den(45)*den(79)
  den(99) = den(25)*den(89)
  den(100) = den(21)*den(75)
  den(101) = den(21)*den(77)
  den(102) = den(21)*den(79)
  den(104) = den(4)*den(103)
  den(105) = den(9)*den(62)
  den(106) = den(9)*den(65)
  den(107) = den(28)*den(56)
  den(108) = den(31)*den(62)
  den(109) = den(31)*den(65)
  den(110) = den(25)*den(56)
  den(111) = den(40)*den(56)
  den(112) = den(42)*den(56)
  den(113) = den(13)*den(49)
  den(114) = den(15)*den(49)
  den(115) = den(35)*den(49)
  den(116) = den(37)*den(49)
  den(117) = den(21)*den(62)
  den(118) = den(21)*den(65)
  den(119) = den(45)*den(65)
  den(120) = den(18)*den(49)
  den(121) = den(1)*den(2)*den(3)
  den(122) = den(1)*den(2)*den(6)
  den(123) = den(1)*den(48)
  den(124) = den(1)*den(52)
  den(125) = den(2)*den(55)
  den(126) = den(2)*den(59)
  den(127) = den(3)*den(104)
  den(128) = den(6)*den(104)
  den(129) = den(3)*den(105)
  den(130) = den(3)*den(106)
  den(131) = den(6)*den(105)
  den(132) = den(6)*den(106)
  den(133) = den(3)*den(108)
  den(134) = den(6)*den(108)
  den(135) = den(3)*den(109)
  den(136) = den(6)*den(109)
  den(137) = den(1)*den(113)
  den(138) = den(1)*den(114)
  den(139) = den(1)*den(115)
  den(140) = den(1)*den(116)
  den(141) = den(2)*den(107)
  den(142) = den(1)*den(120)
  den(143) = den(3)*den(117)
  den(144) = den(6)*den(117)
  den(145) = den(3)*den(118)
  den(146) = den(6)*den(118)
  den(147) = den(2)*den(110)
  den(148) = den(3)*den(119)
  den(149) = den(6)*den(119)
  den(150) = den(2)*den(111)
  den(151) = den(2)*den(112)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif

! **********************************************************************
subroutine allocate_diagrams()
!-----------------------------------------------------------------------
! After the first Born evaluation, colour-stripped amplitudes and
! colour vectors are initialiased with the minimum number of relevant
! helicity states.
! **********************************************************************
#ifndef PRECISION_dp
  use ol_loop_storage_pplnjj_ew_nexecddxsx_3_/**/DREALKIND, only: hel_states
#endif
  implicit none

  if (allocated(A)) deallocate(A)
  if (allocated(M1helarray)) deallocate(M1helarray)
  if (allocated(M1helarray_ct)) deallocate(M1helarray_ct)
  if (allocated(M0_col1_helarray)) deallocate(M0_col1_helarray)
  allocate(A(hel_states,142))
  allocate(M1helarray(3,hel_states))
  allocate(M1helarray_ct(3,hel_states))
  allocate(M0_col1_helarray(3,hel_states))
#if -1 > 0
  if (allocated(M0M1_hel_cc)) deallocate(M0M1_hel_cc)
  allocate(M0M1_hel_cc(3,hel_states,22))
#endif
end subroutine allocate_diagrams

!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_pplnjj_ew_nexecddxsx_3_/**/DREALKIND, only: &
  nhel, Hel, hel_states
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for anti-nu_e e- charm down anti-down anti-strange -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_settings_pplnjj_ew_nexecddxsx_3, only: hel_mem_opt
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_pplnjj_ew_nexecddxsx_3, only: &
    & external_perm_pplnjj_ew_nexecddxsx_3, &
    & external_perm_inv_pplnjj_ew_nexecddxsx_3, &
    & extcomb_perm_pplnjj_ew_nexecddxsx_3, &
    & average_factor_pplnjj_ew_nexecddxsx_3, &
    & photonid_pplnjj_ew_nexecddxsx_3
  use ol_ew_renormalisation_/**/REALKIND, only: photon_factors
  use ol_external_pplnjj_ew_nexecddxsx_3, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_pplnjj_ew_nexecddxsx_3_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_pplnjj_ew_nexecddxsx_3_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_pplnjj_ew_nexecddxsx_3
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(22)
  logical, intent(in) :: qp_kinematics
  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,6)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,6)
#endif
  integer           :: extmasses2(6)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(22)
  complex(REALKIND) :: M1(3), M2(3)
  real(REALKIND)    :: P_scatt_intern(0:3,6)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  real(REALKIND)       :: bornphotonfactor
  integer(intkind1) :: nsync
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(22), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak

#if 6 > 3
  integer :: ind_cc_comb(9)
#endif

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(142)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,142))
  end if

  call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, 0, 0, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_pplnjj_ew_nexecddxsx_3, 6, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_A(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_Q(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_Q(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_Q(P(:,4), rZERO, H4, ex4, POLSEL(4),4)
  call pol_wf_A(P(:,5), rZERO, H5, ex5, POLSEL(5),5)
  call pol_wf_A(P(:,6), rZERO, H6, ex6, POLSEL(6),6)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_W(ntry, ex2(:), ex1(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_QA_W(ntry, ex3(:), ex6(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_QA_V(ntry, ex4(:), ex5(:), wf4(:,3), n3(:,3), t3x4(:,:,3))
  call vert_UV_W(ntry, wf4(:,2), 36, wf4(:,1), 3, wf16(:,1), n3(:,4), t3x16(:,:,1))
  call vert_QA_Z(gZd,ntry, ex4(:), ex5(:), wf4(:,4), n3(:,5), t3x4(:,:,4))
  call vert_WQ_A(ntry, wf4(:,1), ex3(:), wf8(:,1), n3(:,6), t3x8(:,:,1))
  call vert_AV_Q(ntry, ex6(:), wf4(:,3), wf8(:,2), n3(:,7), t3x8(:,:,2))
  call prop_Q_A(ntry, wf8(:,1), 7, ZERO, 0_intkind1, wf8(:,3), n2(1))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,4), wf8(:,4), n3(:,8), t3x8(:,:,3))
  call vert_VQ_A(ntry, wf4(:,3), ex3(:), wf8(:,5), n3(:,9), t3x8(:,:,4))
  call vert_AW_Q(ntry, ex6(:), wf4(:,1), wf8(:,6), n3(:,10), t3x8(:,:,5))
  call prop_Q_A(ntry, wf8(:,5), 28, ZERO, 0_intkind1, wf8(:,7), n2(2))
  call vert_ZQ_A(gZu,ntry, wf4(:,4), ex3(:), wf8(:,8), n3(:,11), t3x8(:,:,6))
  call prop_Q_A(ntry, wf8(:,8), 28, ZERO, 0_intkind1, wf8(:,9), n2(3))
  call vert_WQ_A(ntry, wf4(:,2), ex4(:), wf8(:,10), n3(:,12), t3x8(:,:,7))
  call vert_AW_Q(ntry, ex5(:), wf4(:,1), wf8(:,11), n3(:,13), t3x8(:,:,8))
  call prop_Q_A(ntry, wf8(:,10), 44, ZERO, 0_intkind1, wf8(:,12), n2(4))
  call vert_AW_Q(ntry, ex1(:), wf4(:,2), wf8(:,13), n3(:,14), t3x8(:,:,9))
  call vert_VQ_A(ntry, wf4(:,3), ex2(:), wf8(:,14), n3(:,15), t3x8(:,:,10))
  call prop_A_Q(ntry, wf8(:,13), 37, ZERO, 0_intkind1, wf8(:,15), n2(5))
  call vert_ZQ_A(gZl,ntry, wf4(:,4), ex2(:), wf8(:,16), n3(:,16), t3x8(:,:,11))
  call vert_AZ_Q(gZn,ntry, ex1(:), wf4(:,4), wf8(:,17), n3(:,17), t3x8(:,:,12))
  call vert_WQ_A(ntry, wf4(:,2), ex2(:), wf8(:,18), n3(:,18), t3x8(:,:,13))
  call prop_A_Q(ntry, wf8(:,17), 25, ZERO, 0_intkind1, wf8(:,19), n2(6))
  call counter_UV_W(ntry, wf4(:,2), 36, wf4(:,1), 3, wf16(:,2), n3(:,19), t3x16(:,:,2))
  call counter_AV_Q(ntry, ex6(:), wf4(:,3), wf8(:,20), n3(:,20), t3x8(:,:,14))
  call counter_AV_Q_LR(EWctAdd,ntry, ex6(:), wf4(:,3), wf8(:,21), n3(:,21), t3x8(:,:,15))
  call counter_AZ_Q(gZd,ntry, ex6(:), wf4(:,4), wf8(:,22), n3(:,22), t3x8(:,:,16))
  call counter_AZ_Q(EWctVdd,ntry, ex6(:), wf4(:,4), wf8(:,23), n3(:,23), t3x8(:,:,17))
  call counter_AV_Q_LR(EWctGdd,ntry, ex6(:), wf4(:,3), wf8(:,24), n3(:,24), t3x8(:,:,18))
  call counter_AW_Q(ntry, ex6(:), wf4(:,1), wf8(:,25), n3(:,25), t3x8(:,:,19))
  call counter_AW_Q(ntry, ex5(:), wf4(:,1), wf8(:,26), n3(:,26), t3x8(:,:,20))
  call counter_WQ_A(ntry, wf4(:,2), ex4(:), wf8(:,27), n3(:,27), t3x8(:,:,21))
  call prop_A_Q(ntry, wf8(:,11), 19, ZERO, 0_intkind1, wf8(:,28), n2(7))
  call counter_QA_V(ntry, ex4(:), ex5(:), wf4(:,5), n3(:,28), t3x4(:,:,5))
  call counter_QA_V_LR(EWctAdd,ntry, ex4(:), ex5(:), wf4(:,6), n3(:,29), t3x4(:,:,6))
  call counter_QA_Z(gZd,ntry, ex4(:), ex5(:), wf4(:,7), n3(:,30), t3x4(:,:,7))
  call counter_QA_Z(EWctVdd,ntry, ex4(:), ex5(:), wf4(:,8), n3(:,31), t3x4(:,:,8))
  call vert_AV_Q(ntry, ex6(:), wf4(:,5), wf8(:,29), n3(:,32), t3x8(:,:,22))
  call vert_AV_Q(ntry, ex6(:), wf4(:,6), wf8(:,30), n3(:,33), t3x8(:,:,23))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,7), wf8(:,31), n3(:,34), t3x8(:,:,24))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,8), wf8(:,32), n3(:,35), t3x8(:,:,25))
  call counter_QA_V_LR(EWctGdd,ntry, ex4(:), ex5(:), wf4(:,9), n3(:,36), t3x4(:,:,9))
  call vert_AV_Q(ntry, ex6(:), wf4(:,9), wf8(:,33), n3(:,37), t3x8(:,:,26))
  call vert_VQ_A(ntry, wf4(:,5), ex3(:), wf8(:,34), n3(:,38), t3x8(:,:,27))
  call prop_Q_A(ntry, wf8(:,34), 28, ZERO, 0_intkind1, wf8(:,35), n2(8))
  call vert_VQ_A(ntry, wf4(:,6), ex3(:), wf8(:,36), n3(:,39), t3x8(:,:,28))
  call prop_Q_A(ntry, wf8(:,36), 28, ZERO, 0_intkind1, wf8(:,37), n2(9))
  call vert_ZQ_A(gZu,ntry, wf4(:,7), ex3(:), wf8(:,38), n3(:,40), t3x8(:,:,29))
  call prop_Q_A(ntry, wf8(:,38), 28, ZERO, 0_intkind1, wf8(:,39), n2(10))
  call vert_ZQ_A(gZu,ntry, wf4(:,8), ex3(:), wf8(:,40), n3(:,41), t3x8(:,:,30))
  call prop_Q_A(ntry, wf8(:,40), 28, ZERO, 0_intkind1, wf8(:,41), n2(11))
  call vert_VQ_A(ntry, wf4(:,9), ex3(:), wf8(:,42), n3(:,42), t3x8(:,:,31))
  call prop_Q_A(ntry, wf8(:,42), 28, ZERO, 0_intkind1, wf8(:,43), n2(12))
  call counter_VQ_A(ntry, wf4(:,3), ex3(:), wf8(:,44), n3(:,43), t3x8(:,:,32))
  call prop_A_Q(ntry, wf8(:,6), 35, ZERO, 0_intkind1, wf8(:,45), n2(13))
  call counter_VQ_A_LR(EWctAuu,ntry, wf4(:,3), ex3(:), wf8(:,46), n3(:,44), t3x8(:,:,33))
  call counter_ZQ_A(gZu,ntry, wf4(:,4), ex3(:), wf8(:,47), n3(:,45), t3x8(:,:,34))
  call counter_ZQ_A(EWctVuu,ntry, wf4(:,4), ex3(:), wf8(:,48), n3(:,46), t3x8(:,:,35))
  call counter_VQ_A_LR(EWctGuu,ntry, wf4(:,3), ex3(:), wf8(:,49), n3(:,47), t3x8(:,:,36))
  call counter_WQ_A(ntry, wf4(:,1), ex3(:), wf8(:,50), n3(:,48), t3x8(:,:,37))
  call prop_A_Q(ntry, wf8(:,2), 56, ZERO, 0_intkind1, wf8(:,51), n2(14))
  call prop_A_Q(ntry, wf8(:,4), 56, ZERO, 0_intkind1, wf8(:,52), n2(15))
  call counter_AQ_S(ctSsc,ntry, ex6(:), ex3(:), wf4(:,10), n3(:,49), t3x4(:,:,10))
  call vert_SV_V(ntry, wf4(:,10), wf4(:,1), wf16(:,3), n3(:,50), t3x16(:,:,3))
  call counter_AQ_S(EWctPdu,ntry, ex6(:), ex3(:), wf4(:,11), n3(:,51), t3x4(:,:,11))
  call vert_SV_V(ntry, wf4(:,11), wf4(:,1), wf16(:,4), n3(:,52), t3x16(:,:,4))
  call counter_QA_W(ntry, ex3(:), ex6(:), wf4(:,12), n3(:,53), t3x4(:,:,12))
  call vert_UV_W(ntry, wf4(:,12), 36, wf4(:,1), 3, wf16(:,5), n3(:,54), t3x16(:,:,5))
  call vert_WQ_A(ntry, wf4(:,12), ex4(:), wf8(:,53), n3(:,55), t3x8(:,:,38))
  call prop_Q_A(ntry, wf8(:,53), 44, ZERO, 0_intkind1, wf8(:,54), n2(16))
  call vert_VQ_A(ntry, wf4(:,5), ex2(:), wf8(:,55), n3(:,56), t3x8(:,:,39))
  call vert_VQ_A(ntry, wf4(:,6), ex2(:), wf8(:,56), n3(:,57), t3x8(:,:,40))
  call vert_ZQ_A(gZl,ntry, wf4(:,7), ex2(:), wf8(:,57), n3(:,58), t3x8(:,:,41))
  call vert_ZQ_A(gZl,ntry, wf4(:,8), ex2(:), wf8(:,58), n3(:,59), t3x8(:,:,42))
  call vert_AZ_Q(gZn,ntry, ex1(:), wf4(:,7), wf8(:,59), n3(:,60), t3x8(:,:,43))
  call prop_A_Q(ntry, wf8(:,59), 25, ZERO, 0_intkind1, wf8(:,60), n2(17))
  call vert_AZ_Q(gZn,ntry, ex1(:), wf4(:,8), wf8(:,61), n3(:,61), t3x8(:,:,44))
  call prop_A_Q(ntry, wf8(:,61), 25, ZERO, 0_intkind1, wf8(:,62), n2(18))
  call vert_WQ_A(ntry, wf4(:,12), ex2(:), wf8(:,63), n3(:,62), t3x8(:,:,45))
  call vert_AW_Q(ntry, ex1(:), wf4(:,12), wf8(:,64), n3(:,63), t3x8(:,:,46))
  call prop_A_Q(ntry, wf8(:,64), 37, ZERO, 0_intkind1, wf8(:,65), n2(19))
  call counter_ZQ_A(EWctAee,ntry, wf4(:,3), ex2(:), wf8(:,66), n3(:,64), t3x8(:,:,47))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,4), ex2(:), wf8(:,67), n3(:,65), t3x8(:,:,48))
  call counter_WQ_A(ntry, wf4(:,2), ex2(:), wf8(:,68), n3(:,66), t3x8(:,:,49))
  call counter_AW_Q(ntry, ex1(:), wf4(:,2), wf8(:,69), n3(:,67), t3x8(:,:,50))
  call prop_Q_A(ntry, wf8(:,14), 26, ZERO, 0_intkind1, wf8(:,70), n2(20))
  call prop_Q_A(ntry, wf8(:,16), 26, ZERO, 0_intkind1, wf8(:,71), n2(21))
  call counter_AZ_Q(EWctAnn,ntry, ex1(:), wf4(:,3), wf8(:,72), n3(:,68), t3x8(:,:,51))
  call prop_Q_A(ntry, wf8(:,18), 38, ZERO, 0_intkind1, wf8(:,73), n2(22))
  call counter_AZ_Q(EWctVnn,ntry, ex1(:), wf4(:,4), wf8(:,74), n3(:,69), t3x8(:,:,52))
  call counter_QA_W(ntry, ex2(:), ex1(:), wf4(:,13), n3(:,70), t3x4(:,:,13))
  call vert_UV_W(ntry, wf4(:,2), 36, wf4(:,13), 3, wf16(:,6), n3(:,71), t3x16(:,:,6))
  call vert_WQ_A(ntry, wf4(:,13), ex3(:), wf8(:,75), n3(:,72), t3x8(:,:,53))
  call prop_Q_A(ntry, wf8(:,75), 7, ZERO, 0_intkind1, wf8(:,76), n2(23))
  call vert_AW_Q(ntry, ex6(:), wf4(:,13), wf8(:,77), n3(:,73), t3x8(:,:,54))
  call vert_AW_Q(ntry, ex5(:), wf4(:,13), wf8(:,78), n3(:,74), t3x8(:,:,55))
  call vert_VV_S(ntry, wf4(:,3), wf4(:,2), wf16(:,7), n3(:,75), t3x16(:,:,7))
  call counter_V_S(EWctPW,ntry, wf4(:,1), 3, wf4(:,14), n2(24))
  call vert_VV_S(ntry, wf4(:,4), wf4(:,2), wf16(:,8), n3(:,76), t3x16(:,:,8))
  call vert_UV_W(ntry, wf4(:,3), 24, wf4(:,2), 36, wf16(:,9), n3(:,77), t3x16(:,:,9))
  call counter_V_V(EWctWW,ntry, wf4(:,1), 3, wf4(:,15), n2(25))
  call vert_UV_W(ntry, wf4(:,4), 24, wf4(:,2), 36, wf16(:,10), n3(:,78), t3x16(:,:,10))
  call vert_VV_S(ntry, wf4(:,1), wf4(:,3), wf16(:,11), n3(:,79), t3x16(:,:,11))
  call counter_V_S(EWctPW,ntry, wf4(:,2), 36, wf4(:,16), n2(26))
  call vert_VV_S(ntry, wf4(:,1), wf4(:,4), wf16(:,12), n3(:,80), t3x16(:,:,12))
  call vert_UV_W(ntry, wf4(:,1), 3, wf4(:,3), 24, wf16(:,13), n3(:,81), t3x16(:,:,13))
  call counter_V_V(EWctWW,ntry, wf4(:,2), 36, wf4(:,17), n2(27))
  call vert_UV_W(ntry, wf4(:,1), 3, wf4(:,4), 24, wf16(:,14), n3(:,82), t3x16(:,:,14))
  call counter_V_V(EWctAA,ntry, wf4(:,3), 24, wf4(:,18), n2(28))
  call counter_V_V(EWctAZ,ntry, wf4(:,3), 24, wf4(:,19), n2(29))
  call counter_V_V(EWctAZ,ntry, wf4(:,4), 24, wf4(:,20), n2(30))
  call counter_V_V(EWctZZ,ntry, wf4(:,4), 24, wf4(:,21), n2(31))
  call vert_WQ_A(ntry, wf4(:,15), ex3(:), wf8(:,79), n3(:,83), t3x8(:,:,56))
  call vert_AW_Q(ntry, ex6(:), wf4(:,15), wf8(:,80), n3(:,84), t3x8(:,:,57))
  call vert_VQ_A(ntry, wf4(:,18), ex3(:), wf8(:,81), n3(:,85), t3x8(:,:,58))
  call vert_VQ_A(ntry, wf4(:,20), ex3(:), wf8(:,82), n3(:,86), t3x8(:,:,59))
  call vert_ZQ_A(gZu,ntry, wf4(:,19), ex3(:), wf8(:,83), n3(:,87), t3x8(:,:,60))
  call vert_ZQ_A(gZu,ntry, wf4(:,21), ex3(:), wf8(:,84), n3(:,88), t3x8(:,:,61))
  call counter_Q_A(ctqq,3,ntry, wf8(:,3), 7, wf8(:,85), n2(32))
  call counter_Q_A_LR(EWctdd,ntry, wf8(:,3), 7, wf8(:,86), n2(33))
  call counter_Q_A(ctcc,4,ntry, wf8(:,7), 28, wf8(:,87), n2(34))
  call counter_Q_A_LR(EWctuu,ntry, wf8(:,7), 28, wf8(:,88), n2(35))
  call counter_Q_A(ctcc,4,ntry, wf8(:,9), 28, wf8(:,89), n2(36))
  call counter_Q_A_LR(EWctuu,ntry, wf8(:,9), 28, wf8(:,90), n2(37))
  call vert_AV_Q(ntry, ex6(:), wf4(:,18), wf8(:,91), n3(:,89), t3x8(:,:,62))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,19), wf8(:,92), n3(:,90), t3x8(:,:,63))
  call vert_AV_Q(ntry, ex6(:), wf4(:,20), wf8(:,93), n3(:,91), t3x8(:,:,64))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,21), wf8(:,94), n3(:,92), t3x8(:,:,65))
  call vert_AW_Q(ntry, ex5(:), wf4(:,15), wf8(:,95), n3(:,93), t3x8(:,:,66))
  call vert_WQ_A(ntry, wf4(:,17), ex4(:), wf8(:,96), n3(:,94), t3x8(:,:,67))
  call counter_Q_A(ctqq,2,ntry, wf8(:,12), 44, wf8(:,97), n2(38))
  call counter_Q_A_LR(EWctuu,ntry, wf8(:,12), 44, wf8(:,98), n2(39))
  call counter_A_Q_LR(EWctee,ntry, wf8(:,15), 37, wf8(:,99), n2(40))
  call counter_A_Q_LR(EWctnn,ntry, wf8(:,19), 25, wf8(:,100), n2(41))
  call vert_AW_Q(ntry, ex1(:), wf4(:,17), wf8(:,101), n3(:,95), t3x8(:,:,68))
  call vert_AZ_Q(gZn,ntry, ex1(:), wf4(:,19), wf8(:,102), n3(:,96), t3x8(:,:,69))
  call vert_AZ_Q(gZn,ntry, ex1(:), wf4(:,21), wf8(:,103), n3(:,97), t3x8(:,:,70))
  call vert_WQ_A(ntry, wf4(:,17), ex2(:), wf8(:,104), n3(:,98), t3x8(:,:,71))
  call vert_VQ_A(ntry, wf4(:,18), ex2(:), wf8(:,105), n3(:,99), t3x8(:,:,72))
  call vert_VQ_A(ntry, wf4(:,20), ex2(:), wf8(:,106), n3(:,100), t3x8(:,:,73))
  call vert_ZQ_A(gZl,ntry, wf4(:,19), ex2(:), wf8(:,107), n3(:,101), t3x8(:,:,74))
  call vert_ZQ_A(gZl,ntry, wf4(:,21), ex2(:), wf8(:,108), n3(:,102), t3x8(:,:,75))
  call vert_VV_S(ntry, wf4(:,1), wf4(:,2), wf16(:,15), n3(:,103), t3x16(:,:,15))
  call vert_QA_V(ntry, wf8(:,3), ex6(:), wf16(:,16), n3(:,104), t3x16(:,:,16))
  call vert_QA_Z(gZd,ntry, wf8(:,3), ex6(:), wf16(:,17), n3(:,105), t3x16(:,:,17))
  call vert_QA_W(ntry, ex4(:), wf8(:,28), wf16(:,18), n3(:,106), t3x16(:,:,18))
  call vert_QA_V(ntry, ex3(:), wf8(:,45), wf16(:,19), n3(:,107), t3x16(:,:,19))
  call vert_QA_Z(gZu,ntry, ex3(:), wf8(:,45), wf16(:,20), n3(:,108), t3x16(:,:,20))
  call vert_QA_W(ntry, ex2(:), wf8(:,19), wf16(:,21), n3(:,109), t3x16(:,:,21))
  call vert_QA_W(ntry, wf8(:,70), ex1(:), wf16(:,22), n3(:,110), t3x16(:,:,22))
  call vert_QA_W(ntry, wf8(:,71), ex1(:), wf16(:,23), n3(:,111), t3x16(:,:,23))
  call vert_QA_W(ntry, wf8(:,7), ex6(:), wf16(:,24), n3(:,112), t3x16(:,:,24))
  call vert_QA_W(ntry, wf8(:,9), ex6(:), wf16(:,25), n3(:,113), t3x16(:,:,25))
  call vert_QA_W(ntry, ex3(:), wf8(:,51), wf16(:,26), n3(:,114), t3x16(:,:,26))
  call vert_QA_W(ntry, ex3(:), wf8(:,52), wf16(:,27), n3(:,115), t3x16(:,:,27))
  call vert_QA_V(ntry, ex2(:), wf8(:,15), wf16(:,28), n3(:,116), t3x16(:,:,28))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,15), wf16(:,29), n3(:,117), t3x16(:,:,29))
  call vert_QA_Z(gZn,ntry, wf8(:,73), ex1(:), wf16(:,30), n3(:,118), t3x16(:,:,30))
  call vert_QA_W(ntry, wf8(:,12), ex5(:), wf16(:,31), n3(:,119), t3x16(:,:,31))


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  if (ntry < 2) then
    if(hel_mem_opt) hel_states = nhel
    call allocate_diagrams()
  end if

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do

  call photon_factors(photonid_pplnjj_ew_nexecddxsx_3, &
                    &  0, bornphotonfactor)
  M02 = bornphotonfactor * M02
  M2ct = bornphotonfactor * M2ct
  M2colint = bornphotonfactor * M2colint

#if -1 > 0 && 6 > 3
  !!Born-loop colour correlators interference
  
  M0M1_hel_cc(:,:,:)%j = 0
  M2ctcc = 0
  do n = 1, 9
    M2add_ct = 0
    m = ind_cc_comb(n)
      do k = 1, nhel
        call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
        call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
        M2ctcc(m) = M2ctcc(m) + M2add_ct
      end do
  end do
  M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
  M0M1_hel_cc(:,nhel+1:,:)%j = 0
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5,i6
integer :: n

n=0

do i6= 1, 2
do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf
 end if
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_VV(nsync, wf4(:,3), wf16(:,1), A(:,1), n3(:,120), t3x64(:,:,1), nhel, den(5))
    call Hcont_VV(nsync, wf16(:,1), wf4(:,4), A(:,2), n3(:,121), t3x64(:,:,2), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,3), A(:,3), n3(:,122), t3x64(:,:,3), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,4), A(:,4), n3(:,123), t3x64(:,:,4), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,3), A(:,5), n3(:,124), t3x64(:,:,5), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,7), A(:,6), n3(:,125), t3x64(:,:,6), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,9), A(:,7), n3(:,126), t3x64(:,:,7), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,7), A(:,8), n3(:,127), t3x64(:,:,8), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,12), A(:,9), n3(:,128), t3x64(:,:,9), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,15), A(:,10), n3(:,129), t3x64(:,:,10), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,16), A(:,11), n3(:,130), t3x64(:,:,11), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,19), A(:,12), n3(:,131), t3x64(:,:,12), nhel, den(26))

    call Hcont_VV(nsync, wf4(:,3), wf16(:,2), A(:,13), n3(:,132), t3x64(:,:,13), nhel, den(5))
    call Hcont_VV(nsync, wf4(:,4), wf16(:,2), A(:,14), n3(:,133), t3x64(:,:,14), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,20), A(:,15), n3(:,134), t3x64(:,:,15), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,21), A(:,16), n3(:,135), t3x64(:,:,16), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,22), A(:,17), n3(:,136), t3x64(:,:,17), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,23), A(:,18), n3(:,137), t3x64(:,:,18), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,24), A(:,19), n3(:,138), t3x64(:,:,19), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,25), A(:,20), n3(:,139), t3x64(:,:,20), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,25), A(:,21), n3(:,140), t3x64(:,:,21), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,25), A(:,22), n3(:,141), t3x64(:,:,22), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,25), A(:,23), n3(:,142), t3x64(:,:,23), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,25), A(:,24), n3(:,143), t3x64(:,:,24), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,26), A(:,25), n3(:,144), t3x64(:,:,25), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,26), A(:,26), n3(:,145), t3x64(:,:,26), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,28), A(:,27), n3(:,146), t3x64(:,:,27), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,28), A(:,28), n3(:,147), t3x64(:,:,28), nhel, den(29))
    call Hcont_VV(nsync, wf16(:,1), wf4(:,5), A(:,29), n3(:,148), t3x64(:,:,29), nhel, den(5))
    call Hcont_VV(nsync, wf16(:,1), wf4(:,6), A(:,30), n3(:,149), t3x64(:,:,30), nhel, den(5))
    call Hcont_VV(nsync, wf16(:,1), wf4(:,7), A(:,31), n3(:,150), t3x64(:,:,31), nhel, den(7))
    call Hcont_VV(nsync, wf16(:,1), wf4(:,8), A(:,32), n3(:,151), t3x64(:,:,32), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,29), A(:,33), n3(:,152), t3x64(:,:,33), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,30), A(:,34), n3(:,153), t3x64(:,:,34), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,31), A(:,35), n3(:,154), t3x64(:,:,35), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,32), A(:,36), n3(:,155), t3x64(:,:,36), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,33), A(:,37), n3(:,156), t3x64(:,:,37), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,35), A(:,38), n3(:,157), t3x64(:,:,38), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,37), A(:,39), n3(:,158), t3x64(:,:,39), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,39), A(:,40), n3(:,159), t3x64(:,:,40), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,41), A(:,41), n3(:,160), t3x64(:,:,41), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,43), A(:,42), n3(:,161), t3x64(:,:,42), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,44), wf8(:,45), A(:,43), n3(:,162), t3x64(:,:,43), nhel, den(32))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,46), A(:,44), n3(:,163), t3x64(:,:,44), nhel, den(32))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,47), A(:,45), n3(:,164), t3x64(:,:,45), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,48), A(:,46), n3(:,165), t3x64(:,:,46), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,49), A(:,47), n3(:,166), t3x64(:,:,47), nhel, den(32))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,51), A(:,48), n3(:,167), t3x64(:,:,48), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,51), A(:,49), n3(:,168), t3x64(:,:,49), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,52), A(:,50), n3(:,169), t3x64(:,:,50), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,52), A(:,51), n3(:,170), t3x64(:,:,51), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,51), A(:,52), n3(:,171), t3x64(:,:,52), nhel, den(36))
    call Hcont_VV(nsync, wf4(:,3), wf16(:,3), A(:,53), n3(:,172), t3x64(:,:,53), nhel, den(5))
    call Hcont_VV(nsync, wf4(:,3), wf16(:,4), A(:,54), n3(:,173), t3x64(:,:,54), nhel, den(5))
    call Hcont_VV(nsync, wf4(:,4), wf16(:,3), A(:,55), n3(:,174), t3x64(:,:,55), nhel, den(7))
    call Hcont_VV(nsync, wf4(:,4), wf16(:,4), A(:,56), n3(:,175), t3x64(:,:,56), nhel, den(7))
    call Hcont_VV(nsync, wf4(:,3), wf16(:,5), A(:,57), n3(:,176), t3x64(:,:,57), nhel, den(5))
    call Hcont_VV(nsync, wf4(:,3), wf16(:,5), A(:,58), n3(:,177), t3x64(:,:,58), nhel, den(5))
    call Hcont_VV(nsync, wf4(:,4), wf16(:,5), A(:,59), n3(:,178), t3x64(:,:,59), nhel, den(7))
    call Hcont_VV(nsync, wf4(:,4), wf16(:,5), A(:,60), n3(:,179), t3x64(:,:,60), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,54), A(:,61), n3(:,180), t3x64(:,:,61), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,54), A(:,62), n3(:,181), t3x64(:,:,62), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,55), A(:,63), n3(:,182), t3x64(:,:,63), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,56), A(:,64), n3(:,183), t3x64(:,:,64), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,57), A(:,65), n3(:,184), t3x64(:,:,65), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,58), A(:,66), n3(:,185), t3x64(:,:,66), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,60), A(:,67), n3(:,186), t3x64(:,:,67), nhel, den(26))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,62), A(:,68), n3(:,187), t3x64(:,:,68), nhel, den(26))
    call Hcont_QA(nsync, wf8(:,19), wf8(:,63), A(:,69), n3(:,188), t3x64(:,:,69), nhel, den(26))
    call Hcont_QA(nsync, wf8(:,19), wf8(:,63), A(:,70), n3(:,189), t3x64(:,:,70), nhel, den(26))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,65), A(:,71), n3(:,190), t3x64(:,:,71), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,65), A(:,72), n3(:,191), t3x64(:,:,72), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,65), A(:,73), n3(:,192), t3x64(:,:,73), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,65), A(:,74), n3(:,193), t3x64(:,:,74), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,66), A(:,75), n3(:,194), t3x64(:,:,75), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,67), A(:,76), n3(:,195), t3x64(:,:,76), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,19), wf8(:,68), A(:,77), n3(:,196), t3x64(:,:,77), nhel, den(26))
    call Hcont_QA(nsync, wf8(:,69), wf8(:,70), A(:,78), n3(:,197), t3x64(:,:,78), nhel, den(41))
    call Hcont_QA(nsync, wf8(:,69), wf8(:,71), A(:,79), n3(:,198), t3x64(:,:,79), nhel, den(43))
    call Hcont_QA(nsync, wf8(:,72), wf8(:,73), A(:,80), n3(:,199), t3x64(:,:,80), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,73), wf8(:,74), A(:,81), n3(:,200), t3x64(:,:,81), nhel, den(47))
    call Hcont_VV(nsync, wf4(:,3), wf16(:,6), A(:,82), n3(:,201), t3x64(:,:,82), nhel, den(5))
    call Hcont_VV(nsync, wf4(:,4), wf16(:,6), A(:,83), n3(:,202), t3x64(:,:,83), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,76), A(:,84), n3(:,203), t3x64(:,:,84), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,4), wf8(:,76), A(:,85), n3(:,204), t3x64(:,:,85), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,76), A(:,86), n3(:,205), t3x64(:,:,86), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,77), A(:,87), n3(:,206), t3x64(:,:,87), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,77), A(:,88), n3(:,207), t3x64(:,:,88), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,77), A(:,89), n3(:,208), t3x64(:,:,89), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,78), A(:,90), n3(:,209), t3x64(:,:,90), nhel, den(19))
    call Hcont_SS(nsync, wf16(:,7), wf4(:,14), A(:,91), n3(:,210), t3x64(:,:,91), nhel, den(51))
    call Hcont_SS(nsync, wf4(:,14), wf16(:,8), A(:,92), n3(:,211), t3x64(:,:,92), nhel, den(54))
    call Hcont_VV(nsync, wf16(:,9), wf4(:,15), A(:,93), n3(:,212), t3x64(:,:,93), nhel, den(51))
    call Hcont_VV(nsync, wf4(:,15), wf16(:,10), A(:,94), n3(:,213), t3x64(:,:,94), nhel, den(54))
    call Hcont_SS(nsync, wf16(:,11), wf4(:,16), A(:,95), n3(:,214), t3x64(:,:,95), nhel, den(58))
    call Hcont_SS(nsync, wf4(:,16), wf16(:,12), A(:,96), n3(:,215), t3x64(:,:,96), nhel, den(61))
    call Hcont_VV(nsync, wf16(:,13), wf4(:,17), A(:,97), n3(:,216), t3x64(:,:,97), nhel, den(58))
    call Hcont_VV(nsync, wf4(:,17), wf16(:,14), A(:,98), n3(:,217), t3x64(:,:,98), nhel, den(61))
    call Hcont_VV(nsync, wf16(:,1), wf4(:,18), A(:,99), n3(:,218), t3x64(:,:,99), nhel, den(64))
    call Hcont_VV(nsync, wf16(:,1), wf4(:,19), A(:,100), n3(:,219), t3x64(:,:,100), nhel, den(67))
    call Hcont_VV(nsync, wf16(:,1), wf4(:,20), A(:,101), n3(:,220), t3x64(:,:,101), nhel, den(68))
    call Hcont_VV(nsync, wf16(:,1), wf4(:,21), A(:,102), n3(:,221), t3x64(:,:,102), nhel, den(69))
    call Hcont_QA(nsync, wf8(:,51), wf8(:,79), A(:,103), n3(:,222), t3x64(:,:,103), nhel, den(71))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,79), A(:,104), n3(:,223), t3x64(:,:,104), nhel, den(72))
    call Hcont_QA(nsync, wf8(:,51), wf8(:,79), A(:,105), n3(:,224), t3x64(:,:,105), nhel, den(71))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,80), A(:,106), n3(:,225), t3x64(:,:,106), nhel, den(73))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,80), A(:,107), n3(:,226), t3x64(:,:,107), nhel, den(74))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,80), A(:,108), n3(:,227), t3x64(:,:,108), nhel, den(73))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,81), A(:,109), n3(:,228), t3x64(:,:,109), nhel, den(76))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,82), A(:,110), n3(:,229), t3x64(:,:,110), nhel, den(78))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,83), A(:,111), n3(:,230), t3x64(:,:,111), nhel, den(78))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,84), A(:,112), n3(:,231), t3x64(:,:,112), nhel, den(80))
    call Hcont_QA(nsync, wf8(:,51), wf8(:,85), A(:,113), n3(:,232), t3x64(:,:,113), nhel, den(81))
    call Hcont_QA(nsync, wf8(:,51), wf8(:,86), A(:,114), n3(:,233), t3x64(:,:,114), nhel, den(81))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,85), A(:,115), n3(:,234), t3x64(:,:,115), nhel, den(82))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,86), A(:,116), n3(:,235), t3x64(:,:,116), nhel, den(82))
    call Hcont_QA(nsync, wf8(:,51), wf8(:,86), A(:,117), n3(:,236), t3x64(:,:,117), nhel, den(81))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,87), A(:,118), n3(:,237), t3x64(:,:,118), nhel, den(83))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,88), A(:,119), n3(:,238), t3x64(:,:,119), nhel, den(83))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,89), A(:,120), n3(:,239), t3x64(:,:,120), nhel, den(84))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,90), A(:,121), n3(:,240), t3x64(:,:,121), nhel, den(84))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,88), A(:,122), n3(:,241), t3x64(:,:,122), nhel, den(83))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,91), A(:,123), n3(:,242), t3x64(:,:,123), nhel, den(85))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,92), A(:,124), n3(:,243), t3x64(:,:,124), nhel, den(86))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,93), A(:,125), n3(:,244), t3x64(:,:,125), nhel, den(86))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,94), A(:,126), n3(:,245), t3x64(:,:,126), nhel, den(87))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,95), A(:,127), n3(:,246), t3x64(:,:,127), nhel, den(88))
    call Hcont_QA(nsync, wf8(:,28), wf8(:,96), A(:,128), n3(:,247), t3x64(:,:,128), nhel, den(90))
    call Hcont_QA(nsync, wf8(:,28), wf8(:,97), A(:,129), n3(:,248), t3x64(:,:,129), nhel, den(91))
    call Hcont_QA(nsync, wf8(:,28), wf8(:,98), A(:,130), n3(:,249), t3x64(:,:,130), nhel, den(91))
    call Hcont_QA(nsync, wf8(:,70), wf8(:,99), A(:,131), n3(:,250), t3x64(:,:,131), nhel, den(92))
    call Hcont_QA(nsync, wf8(:,71), wf8(:,99), A(:,132), n3(:,251), t3x64(:,:,132), nhel, den(93))
    call Hcont_QA(nsync, wf8(:,73), wf8(:,100), A(:,133), n3(:,252), t3x64(:,:,133), nhel, den(94))
    call Hcont_QA(nsync, wf8(:,70), wf8(:,101), A(:,134), n3(:,253), t3x64(:,:,134), nhel, den(95))
    call Hcont_QA(nsync, wf8(:,71), wf8(:,101), A(:,135), n3(:,254), t3x64(:,:,135), nhel, den(96))
    call Hcont_QA(nsync, wf8(:,73), wf8(:,102), A(:,136), n3(:,255), t3x64(:,:,136), nhel, den(97))
    call Hcont_QA(nsync, wf8(:,73), wf8(:,103), A(:,137), n3(:,256), t3x64(:,:,137), nhel, den(98))
    call Hcont_QA(nsync, wf8(:,19), wf8(:,104), A(:,138), n3(:,257), t3x64(:,:,138), nhel, den(99))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,105), A(:,139), n3(:,258), t3x64(:,:,139), nhel, den(100))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,106), A(:,140), n3(:,259), t3x64(:,:,140), nhel, den(101))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,107), A(:,141), n3(:,260), t3x64(:,:,141), nhel, den(101))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,108), A(:,142), n3(:,261), t3x64(:,:,142), nhel, den(102))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(3), M2(3) ! M1helarray(3,nhel)
  integer :: empty(0), i

  M1(1)%j = ((A(j,5)%j+A(j,8)%j)*f(36))/6._/**/REALKIND
  M1(2)%j = -(A(j,9)%j*f(2))-A(j,2)%j*f(10)-A(j,3)%j*f(17)+A(j,6)%j*f(18)+(A(j,1)%j-A(j,10)%j)*f(19)+(-A(j,4)%j-A(j,7)%j-A(j,11)%j &
       -A(j,12)%j)*f(20)
  M1(3)%j = ((-A(j,5)%j-A(j,8)%j)*f(36))/2._/**/REALKIND

  M2(1)%j = A(j,129)%j*f(7)+(-A(j,25)%j-A(j,27)%j)*f(8)-A(j,61)%j*f(9)-A(j,31)%j*f(15)-A(j,59)%j*f(16)+A(j,113)%j*f(37) &
       -A(j,118)%j*f(38)-A(j,53)%j*f(39)+(A(j,115)%j+A(j,120)%j)*f(40)+((A(j,19)%j+A(j,37)%j+A(j,42)%j+A(j,47)%j-A(j,105)%j &
       -A(j,108)%j-A(j,117)%j-A(j,122)%j)*f(40))/6._/**/REALKIND+A(j,43)%j*f(41)-A(j,45)%j*f(42)+(-A(j,15)%j-A(j,33)%j)*f(43) &
       +A(j,38)%j*f(44)+(A(j,29)%j-A(j,63)%j)*f(45)+(-A(j,17)%j-A(j,35)%j-A(j,40)%j-A(j,65)%j-A(j,67)%j)*f(46)-A(j,48)%j*f(47) &
       +A(j,20)%j*f(48)+(A(j,57)%j-A(j,71)%j)*f(49)+(-A(j,22)%j-A(j,50)%j-A(j,69)%j-A(j,73)%j)*f(50)+((A(j,24)%j &
       +A(j,52)%j)*f(51))/6._/**/REALKIND+((A(j,86)%j+A(j,89)%j)*f(52))/6._/**/REALKIND-A(j,55)%j*f(54)
  M2(2)%j = A(j,56)%j*f(1)+(A(j,127)%j+A(j,128)%j+A(j,130)%j)*f(3)+(-A(j,26)%j-A(j,62)%j)*f(4)-A(j,90)%j*f(5)-A(j,28)%j*f(6) &
       +A(j,100)%j*f(11)+(-A(j,32)%j+A(j,94)%j+A(j,98)%j+A(j,102)%j)*f(12)-A(j,60)%j*f(13)-A(j,83)%j*f(14)+(A(j,103)%j+A(j,114)%j &
       +A(j,123)%j)*f(21)+(-A(j,106)%j-A(j,109)%j-A(j,119)%j)*f(22)+(-A(j,16)%j-A(j,34)%j-A(j,44)%j-A(j,75)%j-A(j,80)%j-A(j,93)%j &
       -A(j,97)%j-A(j,99)%j+A(j,111)%j+A(j,124)%j+A(j,125)%j+A(j,131)%j+A(j,134)%j+A(j,136)%j+A(j,139)%j+A(j,141)%j)*f(23) &
       +(A(j,39)%j-A(j,110)%j)*f(24)+(-A(j,18)%j+A(j,30)%j-A(j,36)%j-A(j,41)%j-A(j,46)%j-A(j,64)%j-A(j,66)%j-A(j,68)%j-A(j,76)%j &
       -A(j,81)%j-A(j,101)%j+A(j,104)%j+A(j,107)%j+A(j,112)%j+A(j,116)%j+A(j,121)%j+A(j,126)%j+A(j,132)%j+A(j,133)%j+A(j,135)%j &
       +A(j,137)%j+A(j,138)%j+A(j,140)%j+A(j,142)%j)*f(25)+A(j,13)%j*f(26)-A(j,49)%j*f(27)+A(j,21)%j*f(28)+(A(j,58)%j &
       -A(j,72)%j)*f(29)+(-A(j,23)%j-A(j,51)%j-A(j,70)%j-A(j,74)%j)*f(30)-A(j,84)%j*f(31)+A(j,87)%j*f(32)+(-A(j,78)%j &
       +A(j,82)%j)*f(33)+(-A(j,77)%j-A(j,79)%j-A(j,85)%j-A(j,88)%j)*f(34)+A(j,14)%j*f(35)+(A(j,91)%j+A(j,95)%j)*f(53)+(A(j,92)%j &
       +A(j,96)%j)*f(55)+A(j,54)%j*f(56)
  M2(3)%j = ((-A(j,19)%j-A(j,37)%j-A(j,42)%j-A(j,47)%j+A(j,105)%j+A(j,108)%j+A(j,117)%j+A(j,122)%j)*f(40))/2._/**/REALKIND+(( &
       -A(j,24)%j-A(j,52)%j)*f(51))/2._/**/REALKIND+((-A(j,86)%j-A(j,89)%j)*f(52))/2._/**/REALKIND


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pplnjj_ew_nexecddxsx_3_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(3)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 3
      do j = 1, 3
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pplnjj_ew_nexecddxsx_3_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(3), Mct(3)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 3
    do j = 1, 3
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+3*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_pplnjj_ew_nexecddxsx_3_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(3)
  real(REALKIND),    intent(out) :: M2IRadd(22)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 23-1
    colmatpos = 3*k
    do i = 1, 3
      do j = 1, 3
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pplnjj_ew_nexecddxsx_3_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(3)
  complex(REALKIND), intent(in)  :: M2(3)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 3
    do j = 1, 3
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_pplnjj_ew_nexecddxsx_3_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(3)
  type(Hpolcont), intent(out)  :: M0_col(3)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 3 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 3 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+3*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_pplnjj_ew_nexecddxsx_3_/**/REALKIND
