
module ol_vamp_2_pplnjj_ckm_neexuxdgg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_2(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pplnjj_ckm_neexuxdgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pplnjj_ckm_neexuxdgg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pplnjj_ckm_neexuxdgg_1_/**/DREALKIND
  use ol_tensor_sum_storage_pplnjj_ckm_neexuxdgg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pplnjj_ckm_neexuxdgg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pplnjj_ckm_neexuxdgg_1_/**/DREALKIND, only: ntryL, p_switch, Hel
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(64)
  type(Hpolcont), intent(in) :: M(3,64)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================
call TI_triangle_red(G2tensor(161),RedBasis(24),mass3set(:,1),G0tensor(75),G0tensor(30),G0tensor(167),G0tensor(55),M2L1R1)
call TI_triangle_red(G2tensor(76),RedBasis(19),mass3set(:,1),G0tensor(40),G0tensor(177),G0tensor(65),G0tensor(45),M2L1R1)
call TI_triangle_red(G2tensor(39),RedBasis(67),mass3set(:,1),G0tensor(203),G0tensor(198),G0tensor(122),G0tensor(13),M2L1R1)
call TI_triangle_red(G2tensor(7),RedBasis(66),mass3set(:,1),G0tensor(127),G0tensor(14),G0tensor(208),G0tensor(137),M2L1R1)
call TI_triangle_red(G2tensor(34),RedBasis(3),mass3set(:,1),G0tensor(118),G0tensor(23),G0tensor(142),G0tensor(108),M2L1R1)
call TI_triangle_red(G2tensor(31),RedBasis(5),mass3set(:,1),G0tensor(99),G0tensor(24),G0tensor(152),G0tensor(44),M2L1R1)
call TI_triangle_red(G2tensor(38),RedBasis(8),mass3set(:,1),G0tensor(29),G0tensor(162),G0tensor(64),G0tensor(39),M2L1R1)
call TI_triangle_red(G2tensor(42),RedBasis(7),mass3set(:,1),G0tensor(187),G0tensor(74),G0tensor(54),G0tensor(197),M2L1R1)
call TI_triangle_red(G3tensor(9),RedBasis(17),mass3set(:,1),G0tensor(193),G0tensor(163),G0tensor(83),G0tensor(202),M2L1R1)
call TI_triangle_red(G2tensor(70),RedBasis(27),mass3set(:,1),G0tensor(184),G0tensor(168),G0tensor(84),G0tensor(158),M2L1R1)
call TI_triangle_red(G3tensor(5),RedBasis(17),mass3set(:,2),G0tensor(117),G0tensor(114),G0tensor(89),G0tensor(97),M2L1R1,[nMT], &
    G0tensor(93))
call TI_triangle_red(G3tensor(7),RedBasis(17),mass3set(:,3),G0tensor(102),G0tensor(94),G0tensor(134),G0tensor(129),M2L1R1,[nMB], &
    G0tensor(119))
call ol_merge_tensors(T0sum(43),[G0tensor(1)])
call ol_merge_tensors(T0sum(44),[G0tensor(21)])
call ol_merge_tensors(T0sum(45),[G0tensor(41)])
call ol_merge_tensors(T0sum(46),[G0tensor(61)])
call ol_merge_tensors(T0sum(47),[G0tensor(81)])
call ol_merge_tensors(T0sum(48),[G0tensor(101)])
call ol_merge_tensors(T0sum(49),[G0tensor(121)])
call ol_merge_tensors(T0sum(50),[G0tensor(141)])
call ol_merge_tensors(T0sum(51),[G0tensor(161)])
call ol_merge_tensors(T0sum(52),[G0tensor(181)])
call ol_merge_tensors(T0sum(53),[G0tensor(201)])
call ol_merge_tensors(T0sum(54),[G0tensor(113)])
call ol_merge_tensors(T0sum(55),[G0tensor(182)])
call ol_merge_tensors(T0sum(56),[G0tensor(112)])
call ol_merge_tensors(T0sum(57),[G0tensor(103)])
call ol_merge_tensors(T0sum(58),[G0tensor(42)])
call ol_merge_tensors(T0sum(59),[G0tensor(123)])
call ol_merge_tensors(T0sum(60),[G0tensor(87)])
call ol_merge_tensors(T0sum(61),[G0tensor(172)])
call ol_merge_tensors(T0sum(62),[G0tensor(72)])
call ol_merge_tensors(T0sum(63),[G0tensor(95)])
call ol_merge_tensors(T0sum(64),[G0tensor(60)])
call ol_merge_tensors(T0sum(65),[G0tensor(173)])
call ol_merge_tensors(T0sum(66),[G0tensor(2)])
call ol_merge_tensors(T0sum(67),[G0tensor(145)])
call ol_merge_tensors(T0sum(68),[G0tensor(150)])
call ol_merge_tensors(T0sum(69),[G0tensor(20)])
call ol_merge_tensors(T0sum(70),[G0tensor(15)])
call ol_merge_tensors(T0sum(71),[G0tensor(34)])
call ol_merge_tensors(T0sum(72),[G0tensor(147)])
call ol_merge_tensors(T0sum(73),[G0tensor(165)])
call ol_merge_tensors(T0sum(74),[G0tensor(200)])
call ol_merge_tensors(T0sum(75),[G0tensor(58)])
call ol_merge_tensors(T0sum(76),[G0tensor(210)])
call ol_merge_tensors(T0sum(77),[G0tensor(3)])
call ol_merge_tensors(T0sum(78),[G0tensor(75)])
call ol_merge_tensors(T0sum(79),[G0tensor(40)])
call ol_merge_tensors(T0sum(80),[G0tensor(203)])
call ol_merge_tensors(T0sum(81),[G0tensor(127)])
call ol_merge_tensors(T0sum(82),[G0tensor(118)])
call ol_merge_tensors(T0sum(83),[G0tensor(99)])
call ol_merge_tensors(T0sum(84),[G0tensor(29)])
call ol_merge_tensors(T0sum(85),[G0tensor(187)])
call ol_merge_tensors(T0sum(86),[G0tensor(193)])
call ol_merge_tensors(T0sum(87),[G0tensor(184)])
call ol_merge_tensors(T0sum(88),[G0tensor(117)])
call ol_merge_tensors(T0sum(89),[G0tensor(102)])
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(67)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(107),h0tab(:,107),[47,16],[0,0],3,1,wf16(:,13))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),wf16(:,13),G0H2(1),m4h2x16x2(:,1),heltab3x64(:,:,10))
Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(2,:)%j)) * den(67)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(108),h0tab(:,108),[47,16],[0,0],3,1,wf16(:,13))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf16(:,13),ex6(:),G0H2(2),m4h16x2x2(:,1),heltab3x64(:,:,11))
Gcoeff(:)%j = (c(2)*(-M(1,:)%j+M(2,:)%j)) * den(67)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(109),h0tab(:,109),[47,16],[0,0],3,1,wf16(:,13))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),wf16(:,13),G0H2(3),m4h2x16x2(:,2),heltab3x64(:,:,12))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(70)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(110),h0tab(:,110),[47,16],[0,0],3,1,wf16(:,18))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),wf16(:,18),G0H2(4),m4h2x16x2(:,3),heltab3x64(:,:,13))
Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(2,:)%j)) * den(70)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(111),h0tab(:,111),[47,16],[0,0],3,1,wf16(:,18))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf16(:,18),ex6(:),G0H2(5),m4h16x2x2(:,2),heltab3x64(:,:,14))
Gcoeff(:)%j = (c(2)*(-M(1,:)%j+M(2,:)%j)) * den(70)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(112),h0tab(:,112),[47,16],[0,0],3,1,wf16(:,18))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),wf16(:,18),G0H2(6),m4h2x16x2(:,4),heltab3x64(:,:,15))
Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(2,:)%j)) * den(67)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(113),h0tab(:,113),[32,31],[0,0],3,1,wf16(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(9),m3h2x32(:,65),heltab2x64(:,:,98))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(67)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(114),h0tab(:,114),[32,31],[0,0],3,1,wf16(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(11),m3h2x32(:,66),heltab2x64(:,:,99))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(2,:)%j)) * den(67)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(115),h0tab(:,115),[32,31],[0,0],3,1,wf16(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(22),m3h2x32(:,67),heltab2x64(:,:,100))
Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(2,:)%j)) * den(70)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(116),h0tab(:,116),[32,31],[0,0],3,1,wf16(:,18))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(24),m3h2x32(:,68),heltab2x64(:,:,101))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(70)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(117),h0tab(:,117),[32,31],[0,0],3,1,wf16(:,18))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(1),m3h2x32(:,69),heltab2x64(:,:,102))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(2,:)%j)) * den(70)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(118),h0tab(:,118),[32,31],[0,0],3,1,wf16(:,18))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(2),m3h2x32(:,70),heltab2x64(:,:,103))
Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(2,:)%j)) * den(67)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(119),h0tab(:,119),[48,15],[0,0],3,1,wf16(:,13))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(9),m4h2x2x16(:,10),heltab3x64(:,:,16))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(67)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(120),h0tab(:,120),[48,15],[0,0],3,1,wf16(:,13))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex5(:),ex6(:),G0H16(2),m4h2x2x16(:,11),heltab3x64(:,:,17))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(2,:)%j)) * den(67)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(121),h0tab(:,121),[48,15],[0,0],3,1,wf16(:,13))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(3),m4h2x2x16(:,12),heltab3x64(:,:,18))
Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(2,:)%j)) * den(70)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(122),h0tab(:,122),[48,15],[0,0],3,1,wf16(:,18))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(6),m4h2x2x16(:,13),heltab3x64(:,:,19))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(70)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(123),h0tab(:,123),[48,15],[0,0],3,1,wf16(:,18))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex5(:),ex6(:),G0H16(5),m4h2x2x16(:,14),heltab3x64(:,:,20))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(2,:)%j)) * den(70)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(124),h0tab(:,124),[48,15],[0,0],3,1,wf16(:,18))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(4),m4h2x2x16(:,15),heltab3x64(:,:,21))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(41)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(125),h0tab(:,125),[40,23],[0,0],2,2,wf4(:,6),wf16(:,9))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,6),G0H16(1),m3h4x16(:,20),heltab2x64(:,:,104))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(38)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(126),h0tab(:,126),[43,20],[0,0],2,2,wf16(:,8),wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,8),G0H4(5),m3h16x4(:,9),heltab2x64(:,:,105))
  call Hloop_Q_A(ntryL,G0H4(5),43,0,G1H4(33),n2h4(57))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(44)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(127),h0tab(:,127),[52,11],[0,0],2,2,wf8(:,20),wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,20),G0H8(1),m3h8x8(:,7),heltab2x64(:,:,106))
  call Hloop_A_Q(ntryL,G0H8(1),52,0,G1H8(24),n2h8(43))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(76)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(128),h0tab(:,128),[43,20],[0,0],2,2,wf16(:,22),wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,22),G0H4(1),m3h16x4(:,10),heltab2x64(:,:,107))
  call Hloop_Q_A(ntryL,G0H4(1),43,0,G1H4(39),n2h4(58))
Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(51)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(129),h0tab(:,129),[39,24],[0,0],2,2,wf16(:,12),wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,12),G0H4(2),m3h16x4(:,11),heltab2x64(:,:,108))
  call Hloop_A_Q(ntryL,G0H4(2),39,0,G1H4(24),n2h4(59))
Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(48)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(130),h0tab(:,130),[36,27],[0,0],2,2,wf4(:,9),wf16(:,11))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,9),G0H16(7),m3h4x16(:,21),heltab2x64(:,:,109))
Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(77)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(131),h0tab(:,131),[39,24],[0,0],2,2,wf16(:,17),wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,17),G0H4(3),m3h16x4(:,12),heltab2x64(:,:,110))
  call Hloop_A_Q(ntryL,G0H4(3),39,0,G1H4(25),n2h4(60))
Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(52)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(132),h0tab(:,132),[56,7],[0,0],2,2,wf8(:,26),wf8(:,6))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,26),G0H8(1),m3h8x8(:,8),heltab2x64(:,:,111))
  call Hloop_Q_A(ntryL,G0H8(1),56,0,G1H8(29),n2h8(44))
Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(57)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(133),h0tab(:,133),[52,11],[0,0],2,2,wf8(:,21),wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,21),G0H8(1),m3h8x8(:,9),heltab2x64(:,:,112))
  call Hloop_A_Q(ntryL,G0H8(1),52,0,G1H8(32),n2h8(45))
Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(78)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(134),h0tab(:,134),[36,27],[0,0],2,2,wf4(:,9),wf16(:,20))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,9),G0H16(8),m3h4x16(:,22),heltab2x64(:,:,113))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(79)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(135),h0tab(:,135),[40,23],[0,0],2,2,wf4(:,6),wf16(:,15))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,6),G0H16(10),m3h4x16(:,23),heltab2x64(:,:,114))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(58)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(136),h0tab(:,136),[56,7],[0,0],2,2,wf8(:,27),wf8(:,6))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,27),G0H8(1),m3h8x8(:,10),heltab2x64(:,:,115))
  call Hloop_Q_A(ntryL,G0H8(1),56,0,G1H8(3),n2h8(46))
Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(80)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(137),h0tab(:,137),[48,15],[0,0],2,2,wf4(:,11),wf16(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,11),G0H16(11),m3h4x16(:,24),heltab2x64(:,:,116))
  call Hloop_Q_A(ntryL,G0H16(11),48,0,G1H16(4),n2h16(33))
Gcoeff(:)%j = (c(12)*(-M(1,:)%j+M(2,:)%j)) * den(80)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(138),h0tab(:,138),[48,15],[nMT,nMT],2,2,wf4(:,11),wf16(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,11),G0H16(11),m3h4x16(:,25),heltab2x64(:,:,117))
  call Hloop_Q_A(ntryL,G0H16(11),48,nMT,G1H16(1),n2h16(34))
Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(80)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(139),h0tab(:,139),[48,15],[0,0],2,2,wf4(:,11),wf16(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,11),G0H16(11),m3h4x16(:,26),heltab2x64(:,:,118))
  call Hloop_Q_A(ntryL,G0H16(11),48,0,G1H16(3),n2h16(35))
Gcoeff(:)%j = (c(12)*(-M(1,:)%j+M(2,:)%j)) * den(80)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(140),h0tab(:,140),[48,15],[nMB,nMB],2,2,wf4(:,11),wf16(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,11),G0H16(11),m3h4x16(:,27),heltab2x64(:,:,119))
  call Hloop_Q_A(ntryL,G0H16(11),48,nMB,G1H16(10),n2h16(36))
Gcoeff(:)%j = (c(7)*(-M(1,:)%j+M(2,:)%j)) * den(80)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(141),h0tab(:,141),[48,15],[0,0],2,2,wf4(:,11),wf16(:,13))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,11),48,G1H16(11),m3h4x16(:,28),heltab2x64(:,:,120))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(2,:)%j)) * den(80)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(142),h0tab(:,142),[48,15],[0,0],2,2,wf4(:,11),wf16(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,11),48,G1H16(22),m3h4x16(:,29),heltab2x64(:,:,121))
Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(2,:)%j)) * den(61)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(143),h0tab(:,143),[56,7],[0,0],2,2,wf8(:,29),wf8(:,6))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,29),G0H8(1),m3h8x8(:,11),heltab2x64(:,:,122))
  call Hloop_Q_A(ntryL,G0H8(1),56,0,G1H8(9),n2h8(47))
Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(81)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(144),h0tab(:,144),[48,15],[0,0],2,2,wf4(:,11),wf16(:,18))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,11),G0H16(11),m3h4x16(:,30),heltab2x64(:,:,123))
  call Hloop_Q_A(ntryL,G0H16(11),48,0,G1H16(21),n2h16(37))
Gcoeff(:)%j = (c(12)*(-M(1,:)%j+M(2,:)%j)) * den(81)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(145),h0tab(:,145),[48,15],[nMT,nMT],2,2,wf4(:,11),wf16(:,18))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,11),G0H16(11),m3h4x16(:,31),heltab2x64(:,:,124))
  call Hloop_Q_A(ntryL,G0H16(11),48,nMT,G1H16(5),n2h16(38))
Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(81)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(146),h0tab(:,146),[48,15],[0,0],2,2,wf4(:,11),wf16(:,18))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,11),G0H16(11),m3h4x16(:,32),heltab2x64(:,:,125))
  call Hloop_Q_A(ntryL,G0H16(11),48,0,G1H16(6),n2h16(39))
Gcoeff(:)%j = (c(12)*(-M(1,:)%j+M(2,:)%j)) * den(81)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(147),h0tab(:,147),[48,15],[nMB,nMB],2,2,wf4(:,11),wf16(:,18))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,11),G0H16(11),m3h4x16(:,33),heltab2x64(:,:,126))
  call Hloop_Q_A(ntryL,G0H16(11),48,nMB,G1H16(8),n2h16(40))
Gcoeff(:)%j = (c(7)*(-M(1,:)%j+M(2,:)%j)) * den(81)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(148),h0tab(:,148),[48,15],[0,0],2,2,wf4(:,11),wf16(:,18))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,11),48,G1H16(18),m3h4x16(:,34),heltab2x64(:,:,127))
Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(2,:)%j)) * den(81)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(149),h0tab(:,149),[48,15],[0,0],2,2,wf4(:,11),wf16(:,18))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,11),48,G1H16(16),m3h4x16(:,35),heltab2x64(:,:,128))
Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(2,:)%j)) * den(62)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(150),h0tab(:,150),[52,11],[0,0],2,2,wf8(:,11),wf8(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,11),G0H8(1),m3h8x8(:,12),heltab2x64(:,:,129))
  call ol_merge(ntryL,G0H2(6),[G0H2(5),G0H2(4),G0H2(3),G0H2(2),G0H2(1)])
  call ol_merge(ntryL,G1H16(22),[G0H16(3),G0H16(2),G0H16(9)])
  call ol_merge(ntryL,G1H16(16),[G0H16(4),G0H16(5),G0H16(6)])
  call ol_merge(ntryL,G1H4(39),[G1H4(33)])
  call ol_merge(ntryL,G1H8(32),[G1H8(24)])
  call ol_merge(ntryL,G1H4(25),[G1H4(24)])
  call ol_merge(ntryL,G1H8(9),[G1H8(3),G1H8(29)])
  call ol_merge(ntryL,G1H16(3),[G1H16(4)])
  call ol_merge(ntryL,G1H16(6),[G1H16(21)])
  call Hcheck_last_UV_W(ntryL,l_switch,G0H2(6),47,ex5(:),16,G1tensor(1),m3h2x1(:,220),heltab2x2(:,:,220))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H32(9),ex5(:),wf16(:,13),G1tensor(31),m4h2x16x1(:,1),heltab3x32(:,:,1))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H32(11),wf16(:,13),ex5(:),G1tensor(61),m4h16x2x1(:,1),heltab3x32(:,:,2))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G1H32(22),ex5(:),wf16(:,13),G1tensor(14),m4h2x16x1(:,2),heltab3x32(:,:,3))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H32(24),ex5(:),wf16(:,18),G1tensor(26),m4h2x16x1(:,3),heltab3x32(:,:,4))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H32(1),wf16(:,18),ex5(:),G1tensor(42),m4h16x2x1(:,2),heltab3x32(:,:,5))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G1H32(2),ex5(:),wf16(:,18),G1tensor(54),m4h2x16x1(:,4),heltab3x32(:,:,6))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H16(22),48,wf16(:,13),15,G2tensor(167),m3h16x1(:,9),heltab2x16(:,:,69))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H16(16),48,wf16(:,18),15,G2tensor(107),m3h16x1(:,10),heltab2x16(:,:,70))
  call Hloop_VA_Q(ntryL,G0H16(1),wf16(:,9),G0H1(1),m3h16x1(:,11),heltab2x16(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,0,G1tensor(68),n2h1(199))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H4(39),wf4(:,5),G1tensor(11),m3h4x1(:,36),heltab2x4(:,:,112))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(32),wf8(:,3),G1tensor(10),m3h8x1(:,12),heltab2x8(:,:,75))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H4(25),wf4(:,10),G1tensor(21),m3h4x1(:,37),heltab2x4(:,:,113))
  call Hloop_VQ_A(ntryL,G0H16(7),wf16(:,11),G0H1(1),m3h16x1(:,12),heltab2x16(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,0,G1tensor(28),n2h1(200))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H8(9),wf8(:,6),G1tensor(47),m3h8x1(:,13),heltab2x8(:,:,76))
  call Hloop_VQ_A(ntryL,G0H16(8),wf16(:,20),G0H1(1),m3h16x1(:,13),heltab2x16(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,0,G1tensor(45),n2h1(201))
  call Hloop_VA_Q(ntryL,G0H16(10),wf16(:,15),G0H1(1),m3h16x1(:,14),heltab2x16(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,0,G1tensor(64),n2h1(202))
  call Hloop_QV_A(ntryL,G1H16(3),wf16(:,13),G1H1(1),m3h16x1(:,15),heltab2x16(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(152),n2h1(203))
  call Hloop_QV_A(ntryL,G1H16(1),wf16(:,13),G1H1(1),m3h16x1(:,16),heltab2x16(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(113),n2h1(204))
  call Hloop_QV_A(ntryL,G1H16(10),wf16(:,13),G1H1(1),m3h16x1(:,17),heltab2x16(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(158),n2h1(205))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H16(11),48,wf16(:,13),15,G2tensor(170),m3h16x1(:,18),heltab2x16(:,:,78))
  call Hloop_QV_A(ntryL,G1H16(6),wf16(:,18),G1H1(1),m3h16x1(:,19),heltab2x16(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(164),n2h1(206))
  call Hloop_QV_A(ntryL,G1H16(5),wf16(:,18),G1H1(1),m3h16x1(:,20),heltab2x16(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(173),n2h1(207))
  call Hloop_QV_A(ntryL,G1H16(8),wf16(:,18),G1H1(1),m3h16x1(:,21),heltab2x16(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(176),n2h1(208))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H16(18),48,wf16(:,18),15,G2tensor(179),m3h16x1(:,22),heltab2x16(:,:,82))
  call Hloop_VQ_A(ntryL,G0H8(1),wf8(:,3),G0H1(1),m3h8x1(:,14),heltab2x8(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,0,G1tensor(76),n2h1(209))
  call ol_merge_tensors(G0tensor(208),[G0tensor(122),G0tensor(68),G0tensor(132),G0tensor(63),G0tensor(73),G0tensor(53) &
    ,G0tensor(106),G0tensor(66),G0tensor(51),G0tensor(31),G0tensor(6)])
  call ol_merge_tensors(G1tensor(1),[G0tensor(84),G0tensor(83),G0tensor(198),G0tensor(65),G0tensor(167),G0tensor(4),G0tensor(85) &
    ,G0tensor(205),G0tensor(153),G0tensor(206),G0tensor(191),G0tensor(11)])
  call ol_merge_tensors(G0tensor(13),[G0tensor(120),G0tensor(160),G0tensor(170),G0tensor(115),G0tensor(22),G0tensor(151) &
    ,G0tensor(16)])
  call ol_merge_tensors(G0tensor(152),[G0tensor(142),G0tensor(105),G0tensor(79),G0tensor(69),G0tensor(25),G0tensor(130) &
    ,G0tensor(43),G0tensor(143),G0tensor(38),G0tensor(126),G0tensor(91),G0tensor(71),G0tensor(26)])
  call ol_merge_tensors(G1tensor(76),[G1tensor(10),G0tensor(30),G0tensor(175),G0tensor(70),G0tensor(125),G0tensor(92),G0tensor(98) &
    ,G0tensor(76),G0tensor(36)])
  call ol_merge_tensors(G0tensor(54),[G0tensor(64),G0tensor(48),G0tensor(80),G0tensor(155),G0tensor(135),G0tensor(10) &
    ,G0tensor(186),G0tensor(166),G0tensor(146),G0tensor(131),G0tensor(111),G0tensor(86),G0tensor(46)])
  call ol_merge_tensors(G1tensor(47),[G0tensor(177),G0tensor(190),G0tensor(19),G0tensor(67),G0tensor(116),G0tensor(56)])
  call ol_merge_tensors(G0tensor(168),[G0tensor(195),G0tensor(90),G0tensor(78),G0tensor(17),G0tensor(188),G0tensor(136) &
    ,G0tensor(96)])
  call ol_merge_tensors(G1tensor(64),[G1tensor(68),G0tensor(23),G0tensor(137),G0tensor(45),G0tensor(35),G0tensor(192),G0tensor(7) &
    ,G0tensor(156)])
  call ol_merge_tensors(G1tensor(45),[G1tensor(28),G0tensor(74),G0tensor(55),G0tensor(9),G0tensor(88),G0tensor(107),G0tensor(52) &
    ,G0tensor(171)])
  call ol_merge_tensors(G1tensor(54),[G1tensor(42),G1tensor(26),G1tensor(14),G1tensor(61),G1tensor(31),G0tensor(202),G0tensor(197) &
    ,G0tensor(108),G0tensor(18),G0tensor(110),G0tensor(28),G0tensor(128),G0tensor(47),G0tensor(27),G0tensor(12),G0tensor(176)])
  call ol_merge_tensors(G1tensor(11),[G0tensor(24),G0tensor(14),G0tensor(49),G0tensor(140),G0tensor(138),G0tensor(82),G0tensor(37) &
    ,G0tensor(196)])
  call ol_merge_tensors(G0tensor(158),[G0tensor(39),G0tensor(44),G0tensor(207),G0tensor(77),G0tensor(32),G0tensor(183)])
  call ol_merge_tensors(G1tensor(21),[G0tensor(162),G0tensor(157),G0tensor(8),G0tensor(5),G0tensor(62),G0tensor(57)])
  call ol_merge_tensors(G2tensor(179),[G2tensor(164),G2tensor(170),G2tensor(152),G2tensor(107),G2tensor(167),G0tensor(163) &
    ,G0tensor(100),G0tensor(59),G0tensor(185),G0tensor(33),G0tensor(50),G0tensor(180)])
  call ol_merge_tensors(G2tensor(173),[G2tensor(113),G0tensor(114)])
  call ol_merge_tensors(G2tensor(176),[G2tensor(158),G0tensor(94)])
call TI_bubble_red(G2tensor(179),48,mass2set(:,1),G0tensor(109),M2L1R1)
call TI_bubble_red(G2tensor(173),48,mass2set(:,2),G0tensor(104),M2L1R1,G0tensor(209))
call TI_bubble_red(G2tensor(176),48,mass2set(:,3),G0tensor(133),M2L1R1,G0tensor(124))
  call ol_merge_tensors(G0tensor(93),[G0tensor(209)])
  call ol_merge_tensors(G0tensor(119),[G0tensor(124)])
call TI_bubble_red(G1tensor(1),47,mass2set(:,1),G0tensor(199),M2L1R1)
call TI_bubble_red(G1tensor(76),52,mass2set(:,1),G0tensor(148),M2L1R1)
call TI_bubble_red(G1tensor(47),56,mass2set(:,1),G0tensor(139),M2L1R1)
call TI_bubble_red(G1tensor(64),40,mass2set(:,1),G0tensor(204),M2L1R1)
call TI_bubble_red(G1tensor(45),36,mass2set(:,1),G0tensor(149),M2L1R1)
call TI_bubble_red(G1tensor(54),32,mass2set(:,1),G0tensor(144),M2L1R1)
call TI_bubble_red(G1tensor(11),43,mass2set(:,1),G0tensor(189),M2L1R1)
call TI_bubble_red(G1tensor(21),39,mass2set(:,1),G0tensor(179),M2L1R1)
call ol_merge_tensors(T0sum(90),[G0tensor(208)])
call ol_merge_tensors(T0sum(91),[G0tensor(199)])
call ol_merge_tensors(T0sum(92),[G0tensor(13)])
call ol_merge_tensors(T0sum(93),[G0tensor(152)])
call ol_merge_tensors(T0sum(94),[G0tensor(148)])
call ol_merge_tensors(T0sum(95),[G0tensor(54)])
call ol_merge_tensors(T0sum(96),[G0tensor(139)])
call ol_merge_tensors(T0sum(97),[G0tensor(168)])
call ol_merge_tensors(T0sum(98),[G0tensor(204)])
call ol_merge_tensors(T0sum(99),[G0tensor(149)])
call ol_merge_tensors(T0sum(100),[G0tensor(144)])
call ol_merge_tensors(T0sum(101),[G0tensor(189)])
call ol_merge_tensors(T0sum(102),[G0tensor(158)])
call ol_merge_tensors(T0sum(103),[G0tensor(179)])
call ol_merge_tensors(T0sum(104),[G0tensor(109)])
call ol_merge_tensors(T0sum(105),[G0tensor(104)])
call ol_merge_tensors(T0sum(106),[G0tensor(93)])
call ol_merge_tensors(T0sum(107),[G0tensor(89)])
call ol_merge_tensors(T0sum(108),[G0tensor(97)])
call ol_merge_tensors(T0sum(109),[G0tensor(133)])
call ol_merge_tensors(T0sum(110),[G0tensor(119)])
call ol_merge_tensors(T0sum(111),[G0tensor(134)])
call ol_merge_tensors(T0sum(112),[G0tensor(129)])


! Compute scalar Master integrals 

call compute_scalar_box([ 36, 52, 55 ],masses2_9,RedSet_4(10),ScalarBoxes(1))
call compute_scalar_box([ 32, 52, 55 ],masses2_9,RedSet_4(11),ScalarBoxes(2))
call compute_scalar_box([ 32, 36, 55 ],masses2_9,RedSet_4(1),ScalarBoxes(3))
call compute_scalar_box([ 32, 36, 52 ],masses2_9,RedSet_4(2),ScalarBoxes(4))
call compute_scalar_box([ 4, 20, 23 ],masses2_9,RedSet_4(12),ScalarBoxes(5))
call compute_scalar_box([ 36, 39, 55 ],masses2_9,RedSet_4(13),ScalarBoxes(6))
call compute_scalar_box([ 32, 39, 55 ],masses2_9,RedSet_4(14),ScalarBoxes(7))
call compute_scalar_box([ 32, 36, 39 ],masses2_9,RedSet_4(3),ScalarBoxes(8))
call compute_scalar_box([ 4, 7, 23 ],masses2_9,RedSet_4(15),ScalarBoxes(9))
call compute_scalar_box([ 35, 51, 55 ],masses2_9,RedSet_4(16),ScalarBoxes(10))
call compute_scalar_box([ 32, 51, 55 ],masses2_9,RedSet_4(17),ScalarBoxes(11))
call compute_scalar_box([ 32, 35, 55 ],masses2_9,RedSet_4(18),ScalarBoxes(12))
call compute_scalar_box([ 32, 35, 51 ],masses2_9,RedSet_4(4),ScalarBoxes(13))
call compute_scalar_box([ 3, 19, 23 ],masses2_9,RedSet_4(19),ScalarBoxes(14))
call compute_scalar_box([ 35, 51, 59 ],masses2_9,RedSet_4(20),ScalarBoxes(15))
call compute_scalar_box([ 32, 51, 59 ],masses2_9,RedSet_4(21),ScalarBoxes(16))
call compute_scalar_box([ 32, 35, 59 ],masses2_9,RedSet_4(22),ScalarBoxes(17))
call compute_scalar_box([ 3, 19, 27 ],masses2_9,RedSet_4(23),ScalarBoxes(18))
call compute_scalar_box([ 40, 43, 47 ],masses2_9,RedSet_4(24),ScalarBoxes(19))
call compute_scalar_box([ 32, 43, 47 ],masses2_9,RedSet_4(25),ScalarBoxes(20))
call compute_scalar_box([ 32, 40, 47 ],masses2_9,RedSet_4(26),ScalarBoxes(21))
call compute_scalar_box([ 32, 40, 43 ],masses2_9,RedSet_4(5),ScalarBoxes(22))
call compute_scalar_box([ 8, 11, 15 ],masses2_9,RedSet_4(27),ScalarBoxes(23))
call compute_scalar_box([ 36, 39, 47 ],masses2_9,RedSet_4(28),ScalarBoxes(24))
call compute_scalar_box([ 32, 39, 47 ],masses2_9,RedSet_4(29),ScalarBoxes(25))
call compute_scalar_box([ 32, 36, 47 ],masses2_9,RedSet_4(30),ScalarBoxes(26))
call compute_scalar_box([ 4, 7, 15 ],masses2_9,RedSet_4(31),ScalarBoxes(27))
call compute_scalar_box([ 35, 43, 47 ],masses2_9,RedSet_4(32),ScalarBoxes(28))
call compute_scalar_box([ 32, 35, 47 ],masses2_9,RedSet_4(33),ScalarBoxes(29))
call compute_scalar_box([ 32, 35, 43 ],masses2_9,RedSet_4(6),ScalarBoxes(30))
call compute_scalar_box([ 3, 11, 15 ],masses2_9,RedSet_4(34),ScalarBoxes(31))
call compute_scalar_box([ 36, 44, 47 ],masses2_9,RedSet_4(35),ScalarBoxes(32))
call compute_scalar_box([ 32, 44, 47 ],masses2_9,RedSet_4(36),ScalarBoxes(33))
call compute_scalar_box([ 32, 36, 44 ],masses2_9,RedSet_4(7),ScalarBoxes(34))
call compute_scalar_box([ 4, 12, 15 ],masses2_9,RedSet_4(37),ScalarBoxes(35))
call compute_scalar_box([ 35, 39, 47 ],masses2_9,RedSet_4(38),ScalarBoxes(36))
call compute_scalar_box([ 32, 35, 39 ],masses2_9,RedSet_4(8),ScalarBoxes(37))
call compute_scalar_box([ 3, 7, 15 ],masses2_9,RedSet_4(39),ScalarBoxes(38))
call compute_scalar_box([ 40, 44, 47 ],masses2_9,RedSet_4(40),ScalarBoxes(39))
call compute_scalar_box([ 32, 40, 44 ],masses2_9,RedSet_4(9),ScalarBoxes(40))
call compute_scalar_box([ 8, 12, 15 ],masses2_9,RedSet_4(41),ScalarBoxes(41))
call compute_scalar_box([ 35, 43, 59 ],masses2_9,RedSet_4(42),ScalarBoxes(42))
call compute_scalar_box([ 32, 43, 59 ],masses2_9,RedSet_4(43),ScalarBoxes(43))
call compute_scalar_box([ 3, 11, 27 ],masses2_9,RedSet_4(44),ScalarBoxes(44))
call compute_scalar_box([ 35, 39, 55 ],masses2_9,RedSet_4(45),ScalarBoxes(45))
call compute_scalar_box([ 3, 7, 23 ],masses2_9,RedSet_4(46),ScalarBoxes(46))
! end of process


end subroutine vamp_2

end module ol_vamp_2_pplnjj_ckm_neexuxdgg_1_/**/REALKIND
