
module ol_vamp_1_pplnjj_ckm_nexeuuxcbx_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pplnjj_ckm_nexeuuxcbx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pplnjj_ckm_nexeuuxcbx_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pplnjj_ckm_nexeuuxcbx_1_/**/DREALKIND
  use ol_tensor_sum_storage_pplnjj_ckm_nexeuuxcbx_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pplnjj_ckm_nexeuuxcbx_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pplnjj_ckm_nexeuuxcbx_1_/**/DREALKIND, only: ntryL, p_switch, Hel
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(64)
  type(Hpolcont), intent(in) :: M(2,64)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(2,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,3,16,4,8],[nMB,0,0,0,0],5,1,wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,1),heltab2x64(:,:,1))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(1),n2h32(1))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(5)*M(2,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,3,16,8,4],[nMB,0,0,0,0],5,1,wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,2),heltab2x64(:,:,2))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(2),n2h32(2))
  call Hloop_AW_Q(ntryL,G1H32(1),wf4(:,3),G1H8(1),m3h4x8(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(1),35,0,G2H8(1),n2h8(1))
  call Hloop_AW_Q(ntryL,G1H32(2),wf4(:,3),G1H8(1),m3h4x8(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G1H8(1),35,0,G2H8(2),n2h8(2))
  call Hloop_AQ_V(ntryL,G2H8(1),ex5(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_V(ntryL,G2H8(2),ex5(:),G2H4(2),m3h2x4(:,2),heltab2x8(:,:,2))
call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
call HG1shiftOLR(G1H4(2),8,4)
call Hotf_5pt_reduction(G2H4(2),RedSet_5(2),mass5set(:,1),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
call HG1shiftOLR(G1H4(8),4,4)
  call Hloop_VQ_A(ntryL,G1H4(1),ex3(:),G1H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(1),n2h2(1))
call HGT_raise_alpha_OLR(G1H4(2),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(2),ex4(:),G1H2(1),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_VQ_A(ntryL,G1H4(5),ex3(:),G1H2(2),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_Q_A(ntryL,G1H2(2),55,0,G2H2(2),n2h2(2))
  call Hloop_VQ_A(ntryL,G1H4(6),ex3(:),G1H2(2),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_Q_A(ntryL,G1H2(2),55,0,G2H2(3),n2h2(3))
  call Hloop_VA_Q(ntryL,G1H4(7),ex4(:),G1H2(2),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_A_Q(ntryL,G1H2(2),59,0,G2H2(4),n2h2(4))
call HGT_raise_alpha_OLR(G1H4(8),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(8),ex3(:),G1H2(2),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_VA_Q(ntryL,G1H4(11),ex4(:),G1H2(3),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_A_Q(ntryL,G1H2(3),59,0,G2H2(5),n2h2(5))
  call Hloop_VA_Q(ntryL,G1H4(12),ex4(:),G1H2(3),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_A_Q(ntryL,G1H2(3),59,0,G2H2(6),n2h2(6))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(1),ex4(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(3),ex4(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(4),ex3(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(6),ex3(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
call G_TensorShift(G1tensor(2),8)
call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(2),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
call G_TensorShift(G1tensor(8),4)
call ol_merge_tensors(T1sum(1),[G1tensor(1)])
call ol_merge_tensors(T1sum(2),[G1tensor(7)])
Gcoeff(:)%j = (c(6)*M(1,:)%j-c(5)*M(2,:)%j) * den(23)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,12,3,16],[nMB,nMB,0,0],4,2,wf4(:,2),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,3),heltab2x64(:,:,3))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(1),n2h32(3))
Gcoeff(:)%j = (c(6)*M(1,:)%j-c(5)*M(2,:)%j) * den(23)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,3,12,16],[nMB,0,0,0],4,2,wf4(:,3),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,4),heltab2x64(:,:,4))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(2),n2h32(4))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(2,:)%j) * den(23)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,3,16,12],[nMB,0,0,0],4,2,wf4(:,3),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,5),heltab2x64(:,:,5))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(3),n2h32(5))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(5)*M(2,:)%j) * den(4)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,4,8,19],[0,0,0,nMB],4,1,wf8(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,6),heltab2x64(:,:,6))
Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(2,:)%j) * den(4)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[32,8,4,19],[0,0,0,nMB],4,1,wf8(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,7),heltab2x64(:,:,7))
Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(2,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[35,8,4,16],[0,0,0,0],4,1,wf8(:,10))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,10),G0H8(1),m3h8x8(:,1),heltab2x64(:,:,8))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(5)*M(2,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[35,4,8,16],[0,0,0,0],4,1,wf8(:,10))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,10),G0H8(2),m3h8x8(:,2),heltab2x64(:,:,9))
  call Hloop_AV_Q(ntryL,G1H32(1),wf4(:,2),G1H8(1),m3h4x8(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMB,G2H8(1),n2h8(3))
  call Hloop_AW_Q(ntryL,G1H32(2),wf4(:,3),G1H8(1),m3h4x8(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G1H8(1),35,0,G2H8(2),n2h8(4))
  call Hloop_AW_Q(ntryL,G1H32(3),wf4(:,3),G1H8(1),m3h4x8(:,5),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G1H8(1),35,0,G2H8(3),n2h8(5))
  call Hloop_VQ_A(ntryL,G0H32(1),ex3(:),G0H16(1),m3h2x16(:,1),heltab2x32(:,:,6))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(1),n2h16(1))
  call Hloop_VA_Q(ntryL,G0H32(2),ex4(:),G0H16(1),m3h2x16(:,2),heltab2x32(:,:,7))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(2),n2h16(2))
  call Hloop_VA_Q(ntryL,G0H8(1),ex4(:),G0H4(1),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_A_Q(ntryL,G0H4(1),43,0,G1H4(1),n2h4(3))
  call Hloop_VQ_A(ntryL,G0H8(2),ex3(:),G0H4(1),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_Q_A(ntryL,G0H4(1),39,0,G1H4(2),n2h4(4))
  call Hloop_VQ_A(ntryL,G1H4(3),ex3(:),G1H2(3),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_Q_A(ntryL,G1H2(3),55,0,G2H2(1),n2h2(7))
  call Hloop_VQ_A(ntryL,G1H4(4),ex3(:),G1H2(3),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_Q_A(ntryL,G1H2(3),55,0,G2H2(3),n2h2(8))
  call Hloop_VA_Q(ntryL,G1H4(9),ex4(:),G1H2(3),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_A_Q(ntryL,G1H2(3),59,0,G2H2(4),n2h2(9))
  call Hloop_VA_Q(ntryL,G1H4(10),ex4(:),G1H2(3),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_A_Q(ntryL,G1H2(3),59,0,G2H2(6),n2h2(10))
call Hotf_4pt_reduction(G2H8(1),RedSet_4(10),mass4set(:,1),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),8)
call HG1shiftOLR(G1H8(2),16,8)
call Hotf_4pt_reduction(G2H8(2),RedSet_4(11),mass4set(:,2),  & 
G1H8(6),G1H8(7),G1H8(8),G1H8(9),G1H8(10),8)
call HG1shiftOLR(G1H8(7),16,8)
  call Hloop_AQ_V(ntryL,G2H8(3),ex5(:),G2H4(1),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_QA_V(ntryL,G1H16(1),ex4(:),G1H8(11),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_AQ_V(ntryL,G1H16(2),ex3(:),G1H8(12),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_AQ_V(ntryL,G1H4(1),ex3(:),G1H2(3),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_QA_V(ntryL,G1H4(2),ex4(:),G1H2(4),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_AW_Q(ntryL,G1H8(1),wf4(:,3),G1H2(5),m3h4x2(:,1),heltab2x8(:,:,6))
  call Hloop_A_Q(ntryL,G1H2(5),47,0,G2H2(7),n2h2(11))
call HGT_raise_alpha_OLR(G1H8(2),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(2),ex5(:),G1H4(5),m3h2x4(:,6),heltab2x8(:,:,7))
  call Hloop_AW_Q(ntryL,G1H8(4),wf4(:,3),G1H2(5),m3h4x2(:,2),heltab2x8(:,:,8))
  call Hloop_A_Q(ntryL,G1H2(5),47,0,G2H2(8),n2h2(12))
  call Hloop_AW_Q(ntryL,G1H8(5),wf4(:,3),G1H2(5),m3h4x2(:,3),heltab2x8(:,:,9))
  call Hloop_A_Q(ntryL,G1H2(5),47,0,G2H2(9),n2h2(13))
  call Hloop_AV_Q(ntryL,G1H8(6),wf4(:,2),G1H2(5),m3h4x2(:,4),heltab2x8(:,:,10))
  call Hloop_A_Q(ntryL,G1H2(5),47,0,G2H2(10),n2h2(14))
call HGT_raise_alpha_OLR(G1H8(7),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(7),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(7),ex5(:),G1H4(6),m3h2x4(:,7),heltab2x8(:,:,11))
  call Hloop_AV_Q(ntryL,G1H8(9),wf4(:,2),G1H2(5),m3h4x2(:,5),heltab2x8(:,:,12))
  call Hloop_A_Q(ntryL,G1H2(5),47,0,G2H2(11),n2h2(15))
  call Hloop_AV_Q(ntryL,G1H8(10),wf4(:,2),G1H2(5),m3h4x2(:,6),heltab2x8(:,:,13))
  call Hloop_A_Q(ntryL,G1H2(5),47,0,G2H2(12),n2h2(16))
call HGT_w2_OLR(G1H2(1),1,1,2)
call HGT_w2_invQ_OLR(G1H2(1),2,5,2)
  call Hloop_VQ_A(ntryL,G1H2(1),ex3(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(1),n2h1(1))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(2),ex4(:),G2tensor(3),m3h2x1(:,6),heltab2x2(:,:,6))
call HGT_w2_OLR(G1H2(2),1,1,2)
call HGT_w2_invQ_OLR(G1H2(2),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(2),ex4(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(5),n2h1(2))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(5),ex3(:),G2tensor(6),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(1),ex4(:),G2tensor(7),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(3),ex4(:),G2tensor(8),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(4),ex3(:),G2tensor(9),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(6),ex3(:),G2tensor(10),m3h2x1(:,12),heltab2x2(:,:,12))
call Hotf_4pt_reduction(G2H4(1),RedSet_4(4),mass4set(:,2),  & 
G1H4(7),G1H4(8),G1H4(11),G1H4(12),G1H4(3),4)
call HG1shiftOLR(G1H4(8),12,4)
  call Hloop_VQ_A(ntryL,G1H8(11),wf8(:,3),G1H1(1),m3h8x1(:,1),heltab2x8(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(11),n2h1(3))
  call Hloop_VQ_A(ntryL,G1H8(12),wf8(:,3),G1H1(1),m3h8x1(:,2),heltab2x8(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(12),n2h1(4))
  call Hloop_VQ_A(ntryL,G1H2(3),ex5(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(5))
  call Hloop_VQ_A(ntryL,G1H2(4),ex5(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(14),n2h1(6))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(7),ex5(:),G2tensor(15),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(9),ex5(:),G2tensor(16),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(10),ex5(:),G2tensor(17),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(12),ex5(:),G2tensor(18),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(7),51,wf4(:,2),12,G2tensor(19),m3h4x1(:,1),heltab2x4(:,:,15))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(8),0,wf4(:,2),12,G2tensor(20),m3h4x1(:,2),heltab2x4(:,:,16))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(3),51,wf4(:,2),12,G2tensor(21),m3h4x1(:,3),heltab2x4(:,:,17))
  call ol_merge_tensors(G2tensor(19),[G2tensor(4),G2tensor(2),G1tensor(12),G1tensor(6)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(2)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(3)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(5)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(8)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(9)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(10)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(11)])
call Hotf_4pt_reduction_last(G2tensor(19),RedSet_4(4),mass4set(:,2),  & 
G1tensor(1),G1tensor(7),G1tensor(12),G1tensor(6),G1tensor(2))
call G_TensorShift(G1tensor(7),12)
call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(12),mass4set(:,2),  & 
G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(8),G1tensor(9))
call G_TensorShift(G1tensor(4),4)
call Hotf_4pt_reduction_last(G2tensor(7),RedSet_4(1),mass4set(:,3),  & 
G1tensor(10),G1tensor(11),G1tensor(13),G1tensor(14),G1tensor(15))
call G_TensorShift(G1tensor(11),8)
call Hotf_4pt_reduction_last(G2tensor(8),RedSet_4(2),mass4set(:,2),  & 
G1tensor(16),G1tensor(17),G1tensor(18),G1tensor(19),G1tensor(20))
call G_TensorShift(G1tensor(17),8)
call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(3),mass4set(:,2),  & 
G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24),G1tensor(25))
call G_TensorShift(G1tensor(22),8)
call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(13),mass4set(:,2),  & 
G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
call G_TensorShift(G1tensor(27),8)
call Hotf_4pt_reduction_last(G2tensor(9),RedSet_4(6),mass4set(:,3),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35))
call G_TensorShift(G1tensor(32),4)
call Hotf_4pt_reduction_last(G2tensor(10),RedSet_4(7),mass4set(:,2),  & 
G1tensor(36),G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40))
call G_TensorShift(G1tensor(37),4)
call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(8),mass4set(:,2),  & 
G1tensor(41),G1tensor(42),G1tensor(43),G1tensor(44),G1tensor(45))
call G_TensorShift(G1tensor(42),4)
call Hotf_4pt_reduction_last(G2tensor(11),RedSet_4(14),mass4set(:,4),  & 
G1tensor(46),G1tensor(47),G1tensor(48),G1tensor(49),G1tensor(50))
call G_TensorShift(G1tensor(47),19)
call Hotf_4pt_reduction_last(G2tensor(12),RedSet_4(15),mass4set(:,4),  & 
G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54),G1tensor(55))
call G_TensorShift(G1tensor(52),19)
call Hotf_4pt_reduction_last(G2tensor(13),RedSet_4(16),mass4set(:,3),  & 
G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
call G_TensorShift(G1tensor(57),16)
call Hotf_4pt_reduction_last(G2tensor(14),RedSet_4(17),mass4set(:,3),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65))
call G_TensorShift(G1tensor(62),16)
call Hotf_4pt_reduction_last(G2tensor(15),RedSet_4(10),mass4set(:,1),  & 
G1tensor(66),G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70))
call G_TensorShift(G1tensor(67),16)
call Hotf_4pt_reduction_last(G2tensor(17),RedSet_4(11),mass4set(:,2),  & 
G1tensor(71),G1tensor(72),G1tensor(73),G1tensor(74),G1tensor(75))
call G_TensorShift(G1tensor(72),16)
call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(4),mass4set(:,2),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
call Hotf_4pt_reduction_last(G1tensor(3),RedSet_4(12),mass4set(:,2),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
call Hotf_4pt_reduction_last(G1tensor(10),RedSet_4(1),mass4set(:,3),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
call Hotf_4pt_reduction_last(G1tensor(16),RedSet_4(2),mass4set(:,2),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
call Hotf_4pt_reduction_last(G1tensor(21),RedSet_4(3),mass4set(:,2),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(13),mass4set(:,2),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(6),mass4set(:,3),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
call Hotf_4pt_reduction_last(G1tensor(36),RedSet_4(7),mass4set(:,2),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(8),mass4set(:,2),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
call Hotf_4pt_reduction_last(G1tensor(46),RedSet_4(14),mass4set(:,4),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(15),mass4set(:,4),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
call Hotf_4pt_reduction_last(G1tensor(56),RedSet_4(16),mass4set(:,3),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(17),mass4set(:,3),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(10),mass4set(:,1),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
call Hotf_4pt_reduction_last(G1tensor(71),RedSet_4(11),mass4set(:,2),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
call ol_merge_tensors(T0sum(1),[G0tensor(1)])
call ol_merge_tensors(T0sum(2),[G0tensor(6)])
call ol_merge_tensors(T0sum(3),[G0tensor(11)])
call ol_merge_tensors(T0sum(4),[G0tensor(16)])
call ol_merge_tensors(T0sum(5),[G0tensor(21)])
call ol_merge_tensors(T0sum(6),[G0tensor(26)])
call ol_merge_tensors(T0sum(7),[G0tensor(31)])
call ol_merge_tensors(T0sum(8),[G0tensor(36)])
call ol_merge_tensors(T0sum(9),[G0tensor(41)])
call ol_merge_tensors(T0sum(10),[G0tensor(46)])
call ol_merge_tensors(T0sum(11),[G0tensor(51)])
call ol_merge_tensors(T0sum(12),[G0tensor(56)])
call ol_merge_tensors(T0sum(13),[G0tensor(61)])
call ol_merge_tensors(T0sum(14),[G0tensor(66)])
call ol_merge_tensors(T0sum(15),[G0tensor(71)])
Gcoeff(:)%j = (c(6)*M(1,:)%j-c(5)*M(2,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,12,19],[nMB,nMB,0],3,2,wf4(:,2),wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,8),heltab2x64(:,:,10))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(1),n2h32(6))
Gcoeff(:)%j = (c(2)*M(1,:)%j-c(1)*M(2,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[32,12,19],[0,0,nMB],3,2,wf4(:,2),wf8(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,9),heltab2x64(:,:,11))
Gcoeff(:)%j = (c(6)*M(1,:)%j-c(5)*M(2,:)%j) * den(11)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[35,12,16],[0,0,0],3,2,wf8(:,10),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,10),G0H8(1),m3h8x8(:,3),heltab2x64(:,:,12))
  call Hloop_A_Q(ntryL,G0H8(1),35,0,G1H8(1),n2h8(8))
Gcoeff(:)%j = (c(2)*M(1,:)%j-c(1)*M(2,:)%j) * den(11)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[35,12,16],[0,0,0],3,2,wf8(:,10),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,10),G0H8(2),m3h8x8(:,4),heltab2x64(:,:,13))
Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(8)*M(2,:)%j) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[32,3,28],[nMB,0,0],3,2,wf4(:,3),wf8(:,6))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,10),heltab2x64(:,:,14))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(2),n2h32(7))
Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(8)*M(2,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[44,3,16],[nMB,0,0],3,2,wf8(:,12),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,12),G0H8(1),m3h8x8(:,5),heltab2x64(:,:,15))
  call Hloop_A_Q(ntryL,G0H8(1),44,nMB,G1H8(2),n2h8(9))
Gcoeff(:)%j = (c(6)*M(1,:)%j-c(5)*M(2,:)%j) * den(21)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[51,4,8],[0,0,0],3,1,wf16(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,1),G0H4(1),m3h16x4(:,1),heltab2x64(:,:,16))
  call Hloop_A_Q(ntryL,G0H4(1),51,0,G1H4(4),n2h4(5))
Gcoeff(:)%j = (c(2)*M(1,:)%j-c(1)*M(2,:)%j) * den(21)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[51,4,8],[0,0,0],3,1,wf16(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,1),51,G1H4(9),m3h16x4(:,2),heltab2x64(:,:,17))
Gcoeff(:)%j = (c(6)*M(1,:)%j-c(5)*M(2,:)%j) * den(22)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[51,4,8],[0,0,0],3,1,wf16(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,2),G0H4(1),m3h16x4(:,3),heltab2x64(:,:,18))
  call Hloop_A_Q(ntryL,G0H4(1),51,0,G1H4(10),n2h4(6))
Gcoeff(:)%j = (c(2)*M(1,:)%j-c(1)*M(2,:)%j) * den(22)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[51,4,8],[0,0,0],3,1,wf16(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,2),51,G1H4(1),m3h16x4(:,4),heltab2x64(:,:,19))
  call ol_merge(ntryL,G1H8(2),[G1H8(3)])
  call ol_merge(ntryL,G1H8(1),[G1H8(8)])
  call ol_merge(ntryL,G1H4(10),[G1H4(4)])
  call ol_merge(ntryL,G1H4(1),[G1H4(9)])
  call Hloop_AW_Q(ntryL,G1H8(2),wf4(:,3),G1H2(5),m3h4x2(:,7),heltab2x8(:,:,16))
  call Hloop_A_Q(ntryL,G1H2(5),47,0,G2H2(2),n2h2(17))
  call Hloop_AV_Q(ntryL,G1H8(1),wf4(:,2),G1H2(1),m3h4x2(:,8),heltab2x8(:,:,17))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(5),n2h2(18))
  call Hloop_AV_Q(ntryL,G1H32(1),wf4(:,2),G1H8(4),m3h4x8(:,6),heltab2x32(:,:,8))
  call Hloop_A_Q(ntryL,G1H8(4),44,nMB,G2H8(1),n2h8(10))
  call Hloop_UV_W(ntryL,G0H32(2),32,wf4(:,2),12,G1H8(5),m3h4x8(:,7),heltab2x32(:,:,9))
  call Hloop_UV_W(ntryL,G0H8(2),35,wf4(:,2),12,G1H2(2),m3h4x2(:,9),heltab2x8(:,:,18))
  call Hloop_AW_Q(ntryL,G1H32(2),wf4(:,3),G1H8(6),m3h4x8(:,8),heltab2x32(:,:,10))
  call Hloop_A_Q(ntryL,G1H8(6),35,0,G2H8(2),n2h8(11))
  call Hloop_AQ_V(ntryL,G1H4(10),ex3(:),G1H2(3),m3h2x2(:,15),heltab2x4(:,:,18))
  call Hloop_VQ_A(ntryL,G1H4(1),ex3(:),G1H2(4),m3h2x2(:,16),heltab2x4(:,:,19))
  call Hloop_Q_A(ntryL,G1H2(4),55,0,G2H2(1),n2h2(19))
  call ol_merge(ntryL,G2H2(11),[G2H2(8)])
call HGT_w2_OLR(G1H4(5),1,1,4)
call HGT_w2_invQ_OLR(G1H4(5),2,5,4)
  call Hloop_AW_Q(ntryL,G1H4(5),wf4(:,3),G1H1(1),m3h4x1(:,4),heltab2x4(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(4),n2h1(8))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(11),ex5(:),G2tensor(2),m3h2x1(:,19),heltab2x2(:,:,19))
call HGT_w2_OLR(G1H4(6),1,1,4)
call HGT_w2_invQ_OLR(G1H4(6),2,5,4)
  call Hloop_AV_Q(ntryL,G1H4(6),wf4(:,2),G1H1(1),m3h4x1(:,5),heltab2x4(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(19),n2h1(9))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(11),51,wf4(:,2),12,G2tensor(1),m3h4x1(:,6),heltab2x4(:,:,22))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(12),51,wf4(:,2),12,G2tensor(7),m3h4x1(:,7),heltab2x4(:,:,23))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(2),ex5(:),G2tensor(8),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(5),ex5(:),G2tensor(3),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(1),wf8(:,3),G2tensor(5),m3h8x1(:,3),heltab2x8(:,:,19))
  call Hloop_VQ_A(ntryL,G1H8(5),wf8(:,3),G1H1(1),m3h8x1(:,4),heltab2x8(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(9),n2h1(10))
  call Hloop_VQ_A(ntryL,G1H2(2),ex5(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(10),n2h1(11))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(2),wf8(:,6),G2tensor(6),m3h8x1(:,5),heltab2x8(:,:,21))
  call Hloop_VA_Q(ntryL,G1H2(3),ex4(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(12))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(1),ex4(:),G2tensor(12),m3h2x1(:,24),heltab2x2(:,:,24))
  call ol_merge_tensors(G2tensor(5),[G2tensor(16),G1tensor(70),G0tensor(70)])
  call ol_merge_tensors(G2tensor(6),[G2tensor(21),G2tensor(18),G1tensor(75),G1tensor(45),G1tensor(25),G1tensor(2),G0tensor(75) &
    ,G0tensor(45),G0tensor(25),G0tensor(5)])
  call ol_merge_tensors(G2tensor(8),[G2tensor(20),G1tensor(68),G1tensor(27),G1tensor(4),G1tensor(7),G0tensor(68),G0tensor(27) &
    ,G0tensor(7),G0tensor(2)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(35),G1tensor(15),G1tensor(12),G0tensor(35),G0tensor(15),G0tensor(3)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(40),G1tensor(20),G1tensor(6),G0tensor(40),G0tensor(20),G0tensor(4)])
  call ol_merge_tensors(G1tensor(11),[G1tensor(5),G0tensor(12),G0tensor(8)])
  call ol_merge_tensors(G1tensor(17),[G1tensor(8),G0tensor(17),G0tensor(9)])
  call ol_merge_tensors(G1tensor(22),[G1tensor(9),G0tensor(22),G0tensor(10)])
  call ol_merge_tensors(G2tensor(12),[G2tensor(11),G1tensor(62),G1tensor(47),G1tensor(18),G1tensor(13),G0tensor(62),G0tensor(47) &
    ,G0tensor(18),G0tensor(13)])
  call ol_merge_tensors(G1tensor(23),[G1tensor(14),G0tensor(23),G0tensor(14)])
  call ol_merge_tensors(G1tensor(24),[G1tensor(19),G0tensor(24),G0tensor(19)])
  call ol_merge_tensors(G1tensor(32),[G1tensor(28),G0tensor(32),G0tensor(28)])
  call ol_merge_tensors(G1tensor(37),[G1tensor(29),G0tensor(37),G0tensor(29)])
  call ol_merge_tensors(G1tensor(42),[G1tensor(30),G0tensor(42),G0tensor(30)])
  call ol_merge_tensors(G1tensor(57),[G1tensor(52),G1tensor(38),G1tensor(33),G0tensor(57),G0tensor(52),G0tensor(38) &
    ,G0tensor(33)])
  call ol_merge_tensors(G1tensor(43),[G1tensor(34),G0tensor(43),G0tensor(34)])
  call ol_merge_tensors(G1tensor(44),[G1tensor(39),G0tensor(44),G0tensor(39)])
  call ol_merge_tensors(G1tensor(48),[G0tensor(48)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(54),G1tensor(49),G0tensor(54),G0tensor(49)])
  call ol_merge_tensors(G1tensor(50),[G0tensor(50)])
  call ol_merge_tensors(G1tensor(53),[G0tensor(53)])
  call ol_merge_tensors(G1tensor(55),[G0tensor(55)])
  call ol_merge_tensors(G1tensor(58),[G0tensor(58)])
  call ol_merge_tensors(G2tensor(10),[G2tensor(3),G1tensor(73),G1tensor(64),G1tensor(59),G0tensor(73),G0tensor(64),G0tensor(59)])
  call ol_merge_tensors(G1tensor(60),[G0tensor(60)])
  call ol_merge_tensors(G1tensor(63),[G0tensor(63)])
  call ol_merge_tensors(G1tensor(65),[G0tensor(65)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(67),G0tensor(67)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(74),G1tensor(69),G0tensor(74),G0tensor(69)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(72),G0tensor(72)])
call TI_triangle_red(G2tensor(5),RedBasis(15),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1,[nMB], &
    G0tensor(21))
call TI_triangle_red(G2tensor(6),RedBasis(1),mass3set(:,2),G0tensor(26),G0tensor(31),G0tensor(36),G0tensor(41),M2L1R1,[nMB], &
    G0tensor(46))
call TI_triangle_red(G2tensor(8),RedBasis(17),mass3set(:,2),G0tensor(51),G0tensor(56),G0tensor(61),G0tensor(66),M2L1R1,[nMB], &
    G0tensor(71))
call TI_triangle_red(G2tensor(1),RedBasis(4),mass3set(:,3),G0tensor(70),G0tensor(75),G0tensor(45),G0tensor(25),M2L1R1)
call TI_triangle_red(G2tensor(7),RedBasis(2),mass3set(:,2),G0tensor(5),G0tensor(68),G0tensor(27),G0tensor(7),M2L1R1,[nMB], &
    G0tensor(2))
call TI_triangle_red(G2tensor(12),RedBasis(6),mass3set(:,3),G0tensor(35),G0tensor(15),G0tensor(3),G0tensor(40),M2L1R1)
call TI_triangle_red(G2tensor(9),RedBasis(15),mass3set(:,4),G0tensor(20),G0tensor(4),G0tensor(12),G0tensor(8),M2L1R1,[nMB], &
    G0tensor(17))
call TI_triangle_red(G2tensor(10),RedBasis(18),mass3set(:,3),G0tensor(9),G0tensor(22),G0tensor(10),G0tensor(62),M2L1R1)
call TI_triangle_red(G2tensor(4),RedBasis(33),mass3set(:,1),G0tensor(47),G0tensor(18),G0tensor(13),G0tensor(23),M2L1R1,[nMB], &
    G0tensor(14))
call TI_triangle_red(G2tensor(2),RedBasis(16),mass3set(:,2),G0tensor(24),G0tensor(19),G0tensor(32),G0tensor(28),M2L1R1,[nMB], &
    G0tensor(37))
call TI_triangle_red(G2tensor(19),RedBasis(34),mass3set(:,2),G0tensor(29),G0tensor(42),G0tensor(30),G0tensor(57),M2L1R1,[nMB], &
    G0tensor(52))
call TI_triangle_red(G1tensor(11),RedBasis(21),mass3set(:,3),G0tensor(38),G0tensor(33),G0tensor(43),G0tensor(34),M2L1R1)
call TI_triangle_red(G1tensor(17),RedBasis(20),mass3set(:,2),G0tensor(44),G0tensor(39),G0tensor(48),G0tensor(54),M2L1R1,[nMB], &
    G0tensor(49))
call TI_triangle_red(G1tensor(22),RedBasis(19),mass3set(:,2),G0tensor(50),G0tensor(53),G0tensor(55),G0tensor(58),M2L1R1,[nMB], &
    G0tensor(73))
call TI_triangle_red(G1tensor(23),RedBasis(5),mass3set(:,3),G0tensor(64),G0tensor(59),G0tensor(60),G0tensor(63),M2L1R1)
call TI_triangle_red(G1tensor(24),RedBasis(3),mass3set(:,2),G0tensor(65),G0tensor(67),G0tensor(74),G0tensor(69),M2L1R1,[nMB], &
    G0tensor(72))
call TI_triangle_red(G1tensor(32),RedBasis(24),mass3set(:,3),G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),M2L1R1)
call TI_triangle_red(G1tensor(37),RedBasis(23),mass3set(:,2),G0tensor(80),G0tensor(81),G0tensor(82),G0tensor(83),M2L1R1,[nMB], &
    G0tensor(84))
call TI_triangle_red(G1tensor(42),RedBasis(22),mass3set(:,2),G0tensor(85),G0tensor(86),G0tensor(87),G0tensor(88),M2L1R1,[nMB], &
    G0tensor(89))
call TI_triangle_red(G1tensor(57),RedBasis(9),mass3set(:,3),G0tensor(90),G0tensor(91),G0tensor(92),G0tensor(93),M2L1R1)
call TI_triangle_red(G1tensor(43),RedBasis(8),mass3set(:,3),G0tensor(94),G0tensor(95),G0tensor(96),G0tensor(97),M2L1R1)
call TI_triangle_red(G1tensor(44),RedBasis(7),mass3set(:,2),G0tensor(98),G0tensor(99),G0tensor(100),G0tensor(101),M2L1R1,[nMB], &
    G0tensor(102))
call TI_triangle_red(G1tensor(48),RedBasis(26),mass3set(:,4),G0tensor(103),G0tensor(104),G0tensor(105),G0tensor(106),M2L1R1,[nMB], &
    G0tensor(107))
call TI_triangle_red(G1tensor(50),RedBasis(25),mass3set(:,4),G0tensor(108),G0tensor(109),G0tensor(110),G0tensor(111),M2L1R1,[nMB], &
    G0tensor(112))
call TI_triangle_red(G1tensor(53),RedBasis(28),mass3set(:,4),G0tensor(113),G0tensor(114),G0tensor(115),G0tensor(116),M2L1R1,[nMB], &
    G0tensor(117))
call TI_triangle_red(G1tensor(55),RedBasis(27),mass3set(:,4),G0tensor(118),G0tensor(119),G0tensor(120),G0tensor(121),M2L1R1,[nMB], &
    G0tensor(122))
call TI_triangle_red(G1tensor(58),RedBasis(30),mass3set(:,3),G0tensor(123),G0tensor(124),G0tensor(125),G0tensor(126),M2L1R1)
call TI_triangle_red(G1tensor(60),RedBasis(29),mass3set(:,3),G0tensor(127),G0tensor(128),G0tensor(129),G0tensor(130),M2L1R1)
call TI_triangle_red(G1tensor(63),RedBasis(32),mass3set(:,3),G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134),M2L1R1)
call TI_triangle_red(G1tensor(65),RedBasis(31),mass3set(:,3),G0tensor(135),G0tensor(136),G0tensor(137),G0tensor(138),M2L1R1)
call ol_merge_tensors(T0sum(16),[G0tensor(1)])
call ol_merge_tensors(T0sum(17),[G0tensor(26)])
call ol_merge_tensors(T0sum(18),[G0tensor(51)])
call ol_merge_tensors(T0sum(19),[G0tensor(70)])
call ol_merge_tensors(T0sum(20),[G0tensor(5)])
call ol_merge_tensors(T0sum(21),[G0tensor(38)])
call ol_merge_tensors(T0sum(22),[G0tensor(44)])
call ol_merge_tensors(T0sum(23),[G0tensor(50)])
call ol_merge_tensors(T0sum(24),[G0tensor(35)])
call ol_merge_tensors(T0sum(25),[G0tensor(64)])
call ol_merge_tensors(T0sum(26),[G0tensor(65)])
call ol_merge_tensors(T0sum(27),[G0tensor(76)])
call ol_merge_tensors(T0sum(28),[G0tensor(80)])
call ol_merge_tensors(T0sum(29),[G0tensor(85)])
call ol_merge_tensors(T0sum(30),[G0tensor(90)])
call ol_merge_tensors(T0sum(31),[G0tensor(94)])
call ol_merge_tensors(T0sum(32),[G0tensor(98)])
call ol_merge_tensors(T0sum(33),[G0tensor(103)])
call ol_merge_tensors(T0sum(34),[G0tensor(20)])
call ol_merge_tensors(T0sum(35),[G0tensor(108)])
call ol_merge_tensors(T0sum(36),[G0tensor(113)])
call ol_merge_tensors(T0sum(37),[G0tensor(118)])
call ol_merge_tensors(T0sum(38),[G0tensor(123)])
call ol_merge_tensors(T0sum(39),[G0tensor(9)])
call ol_merge_tensors(T0sum(40),[G0tensor(127)])
call ol_merge_tensors(T0sum(41),[G0tensor(131)])
call ol_merge_tensors(T0sum(42),[G0tensor(135)])
call ol_merge_tensors(T0sum(43),[G0tensor(47)])
call ol_merge_tensors(T0sum(44),[G0tensor(24)])
call ol_merge_tensors(T0sum(45),[G0tensor(29)])
Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(8)*M(2,:)%j) * den(18)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[44,19],[nMB,0],2,2,wf8(:,12),wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,12),G0H8(1),m3h8x8(:,6),heltab2x64(:,:,20))
  call Hloop_A_Q(ntryL,G0H8(1),44,nMB,G1H8(7),n2h8(12))
Gcoeff(:)%j = (c(17)*M(1,:)%j-c(16)*M(2,:)%j) * den(24)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[51,12],[0,0],2,2,wf16(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,1),G0H4(1),m3h16x4(:,5),heltab2x64(:,:,21))
  call Hloop_Q_A(ntryL,G0H4(1),51,0,G1H4(2),n2h4(7))
Gcoeff(:)%j = (c(15)*M(1,:)%j-c(14)*M(2,:)%j) * den(24)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[51,12],[nMT,nMT],2,2,wf16(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,1),G0H4(1),m3h16x4(:,6),heltab2x64(:,:,22))
  call Hloop_Q_A(ntryL,G0H4(1),51,nMT,G1H4(7),n2h4(8))
Gcoeff(:)%j = (c(17)*M(1,:)%j-c(16)*M(2,:)%j) * den(24)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[51,12],[0,0],2,2,wf16(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,1),G0H4(1),m3h16x4(:,7),heltab2x64(:,:,23))
  call Hloop_Q_A(ntryL,G0H4(1),51,0,G1H4(8),n2h4(9))
Gcoeff(:)%j = (c(15)*M(1,:)%j-c(14)*M(2,:)%j) * den(24)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[51,12],[nMB,nMB],2,2,wf16(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,1),G0H4(1),m3h16x4(:,8),heltab2x64(:,:,24))
  call Hloop_Q_A(ntryL,G0H4(1),51,nMB,G1H4(3),n2h4(10))
Gcoeff(:)%j = (c(13)*M(1,:)%j-c(10)*M(2,:)%j) * den(24)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[51,12],[0,0],2,2,wf16(:,1),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,1),51,G1H4(4),m3h16x4(:,9),heltab2x64(:,:,25))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(3)*M(2,:)%j) * den(24)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[51,12],[0,0],2,2,wf16(:,1),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,1),51,G1H4(9),m3h16x4(:,10),heltab2x64(:,:,26))
Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(8)*M(2,:)%j) * den(19)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[35,28],[0,0],2,2,wf8(:,10),wf8(:,6))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,10),G0H8(2),m3h8x8(:,7),heltab2x64(:,:,27))
  call Hloop_A_Q(ntryL,G0H8(2),35,0,G1H8(9),n2h8(13))
Gcoeff(:)%j = (c(17)*M(1,:)%j-c(16)*M(2,:)%j) * den(25)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[51,12],[0,0],2,2,wf16(:,2),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,2),G0H4(1),m3h16x4(:,11),heltab2x64(:,:,28))
  call Hloop_Q_A(ntryL,G0H4(1),51,0,G1H4(10),n2h4(11))
Gcoeff(:)%j = (c(15)*M(1,:)%j-c(14)*M(2,:)%j) * den(25)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[51,12],[nMT,nMT],2,2,wf16(:,2),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,2),G0H4(1),m3h16x4(:,12),heltab2x64(:,:,29))
  call Hloop_Q_A(ntryL,G0H4(1),51,nMT,G1H4(1),n2h4(12))
Gcoeff(:)%j = (c(17)*M(1,:)%j-c(16)*M(2,:)%j) * den(25)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[51,12],[0,0],2,2,wf16(:,2),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,2),G0H4(1),m3h16x4(:,13),heltab2x64(:,:,30))
  call Hloop_Q_A(ntryL,G0H4(1),51,0,G1H4(5),n2h4(13))
Gcoeff(:)%j = (c(15)*M(1,:)%j-c(14)*M(2,:)%j) * den(25)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[51,12],[nMB,nMB],2,2,wf16(:,2),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,2),G0H4(1),m3h16x4(:,14),heltab2x64(:,:,31))
  call Hloop_Q_A(ntryL,G0H4(1),51,nMB,G1H4(6),n2h4(14))
Gcoeff(:)%j = (c(13)*M(1,:)%j-c(10)*M(2,:)%j) * den(25)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[51,12],[0,0],2,2,wf16(:,2),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,2),51,G1H4(11),m3h16x4(:,15),heltab2x64(:,:,32))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(3)*M(2,:)%j) * den(25)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[51,12],[0,0],2,2,wf16(:,2),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,2),51,G1H4(12),m3h16x4(:,16),heltab2x64(:,:,33))
  call ol_merge(ntryL,G1H4(5),[G1H4(10),G1H4(8),G1H4(2)])
  call ol_merge(ntryL,G1H4(1),[G1H4(7)])
  call ol_merge(ntryL,G1H4(6),[G1H4(3)])
  call ol_merge(ntryL,G1H4(11),[G1H4(4)])
  call ol_merge(ntryL,G1H4(12),[G1H4(9)])
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(7),wf8(:,3),G1tensor(1),m3h8x1(:,6),heltab2x8(:,:,22))
  call Hloop_QV_A(ntryL,G1H4(5),wf4(:,2),G1H1(1),m3h4x1(:,8),heltab2x4(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(13))
  call Hloop_QV_A(ntryL,G1H4(1),wf4(:,2),G1H1(1),m3h4x1(:,9),heltab2x4(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(14),n2h1(14))
  call Hloop_QV_A(ntryL,G1H4(6),wf4(:,2),G1H1(1),m3h4x1(:,10),heltab2x4(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(15),n2h1(15))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(11),51,wf4(:,2),12,G2tensor(17),m3h4x1(:,11),heltab2x4(:,:,27))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(12),51,wf4(:,2),12,G2tensor(16),m3h4x1(:,12),heltab2x4(:,:,28))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(9),wf8(:,6),G1tensor(3),m3h8x1(:,7),heltab2x8(:,:,23))
  call ol_merge_tensors(G2tensor(15),[G0tensor(18),G0tensor(6)])
  call ol_merge_tensors(G1tensor(1),[G0tensor(81),G0tensor(39),G0tensor(68),G0tensor(66),G0tensor(11)])
  call ol_merge_tensors(G0tensor(101),[G0tensor(69),G0tensor(28),G0tensor(7),G0tensor(41),G0tensor(16)])
  call ol_merge_tensors(G0tensor(122),[G0tensor(117),G0tensor(112),G0tensor(107),G0tensor(102),G0tensor(89),G0tensor(84) &
    ,G0tensor(72),G0tensor(73),G0tensor(49),G0tensor(52),G0tensor(37),G0tensor(14),G0tensor(17),G0tensor(2),G0tensor(71) &
    ,G0tensor(46),G0tensor(21)])
  call ol_merge_tensors(G0tensor(86),[G0tensor(53),G0tensor(42),G0tensor(13),G0tensor(56),G0tensor(31)])
  call ol_merge_tensors(G1tensor(3),[G0tensor(138),G0tensor(130),G0tensor(97),G0tensor(63),G0tensor(62),G0tensor(25) &
    ,G0tensor(36)])
  call ol_merge_tensors(G0tensor(133),[G0tensor(125),G0tensor(77),G0tensor(33),G0tensor(32),G0tensor(10),G0tensor(75) &
    ,G0tensor(61)])
  call ol_merge_tensors(G2tensor(16),[G2tensor(17),G2tensor(13),G0tensor(93),G0tensor(30),G0tensor(22),G0tensor(4),G0tensor(40) &
    ,G0tensor(27),G0tensor(45)])
  call ol_merge_tensors(G0tensor(136),[G0tensor(124),G0tensor(114),G0tensor(109),G0tensor(100),G0tensor(96),G0tensor(92) &
    ,G0tensor(48),G0tensor(43),G0tensor(15)])
  call ol_merge_tensors(G0tensor(132),[G0tensor(128),G0tensor(119),G0tensor(104),G0tensor(91),G0tensor(82),G0tensor(78) &
    ,G0tensor(74),G0tensor(60),G0tensor(3)])
  call ol_merge_tensors(G0tensor(115),[G0tensor(105),G0tensor(12)])
  call ol_merge_tensors(G0tensor(121),[G0tensor(111),G0tensor(8)])
  call ol_merge_tensors(G0tensor(57),[G0tensor(19),G0tensor(23)])
  call ol_merge_tensors(G0tensor(129),[G0tensor(126),G0tensor(59),G0tensor(55),G0tensor(34)])
  call ol_merge_tensors(G0tensor(67),[G0tensor(58),G0tensor(54)])
  call ol_merge_tensors(G0tensor(137),[G0tensor(134),G0tensor(95),G0tensor(87),G0tensor(79)])
  call ol_merge_tensors(G0tensor(99),[G0tensor(88),G0tensor(83)])
  call ol_merge_tensors(G0tensor(110),[G0tensor(106)])
  call ol_merge_tensors(G0tensor(120),[G0tensor(116)])
call TI_bubble_red(G2tensor(15),51,mass2set(:,1),G0tensor(1),M2L1R1,G0tensor(26))
call TI_bubble_red(G2tensor(16),51,mass2set(:,2),G0tensor(51),M2L1R1)
call TI_bubble_red(G2tensor(14),51,mass2set(:,3),G0tensor(70),M2L1R1,G0tensor(5))
  call ol_merge_tensors(G0tensor(122),[G0tensor(26)])
call TI_bubble_red(G1tensor(1),44,mass2set(:,4),G0tensor(38),M2L1R1,G0tensor(44))
call TI_bubble_red(G1tensor(3),35,mass2set(:,2),G0tensor(50),M2L1R1)
  call ol_merge_tensors(G0tensor(44),[G0tensor(122)])
call ol_merge_tensors(T0sum(46),[G0tensor(1)])
call ol_merge_tensors(T0sum(47),[G0tensor(44)])
call ol_merge_tensors(T0sum(48),[G0tensor(38)])
call ol_merge_tensors(T0sum(49),[G0tensor(101)])
call ol_merge_tensors(T0sum(50),[G0tensor(86)])
call ol_merge_tensors(T0sum(51),[G0tensor(50)])
call ol_merge_tensors(T0sum(52),[G0tensor(133)])
call ol_merge_tensors(T0sum(53),[G0tensor(51)])
call ol_merge_tensors(T0sum(54),[G0tensor(136)])
call ol_merge_tensors(T0sum(55),[G0tensor(132)])
call ol_merge_tensors(T0sum(56),[G0tensor(115)])
call ol_merge_tensors(T0sum(57),[G0tensor(121)])
call ol_merge_tensors(T0sum(58),[G0tensor(57)])
call ol_merge_tensors(T0sum(59),[G0tensor(129)])
call ol_merge_tensors(T0sum(60),[G0tensor(67)])
call ol_merge_tensors(T0sum(61),[G0tensor(137)])
call ol_merge_tensors(T0sum(62),[G0tensor(99)])
call ol_merge_tensors(T0sum(63),[G0tensor(110)])
call ol_merge_tensors(T0sum(64),[G0tensor(120)])
call ol_merge_tensors(T0sum(65),[G0tensor(70)])
call ol_merge_tensors(T0sum(66),[G0tensor(5)])


! Compute scalar Master integrals 

call compute_scalar_box([ 35, 51, 55 ],masses2_11,RedSet_4(1),ScalarBoxes(1))
call compute_scalar_box([ 32, 51, 55 ],masses2_13,RedSet_4(2),ScalarBoxes(2))
call compute_scalar_box([ 32, 35, 55 ],masses2_13,RedSet_4(3),ScalarBoxes(3))
call compute_scalar_box([ 32, 35, 51 ],masses2_13,RedSet_4(4),ScalarBoxes(4))
call compute_scalar_box([ 3, 19, 23 ],masses2_12,RedSet_4(5),ScalarBoxes(5))
call compute_scalar_box([ 35, 51, 59 ],masses2_11,RedSet_4(6),ScalarBoxes(6))
call compute_scalar_box([ 32, 51, 59 ],masses2_13,RedSet_4(7),ScalarBoxes(7))
call compute_scalar_box([ 32, 35, 59 ],masses2_13,RedSet_4(8),ScalarBoxes(8))
call compute_scalar_box([ 3, 19, 27 ],masses2_12,RedSet_4(9),ScalarBoxes(9))
! end of process


end subroutine vamp_1

end module ol_vamp_1_pplnjj_ckm_nexeuuxcbx_1_/**/REALKIND
