
module ol_vamp_1_pplnjj_ckm_nexeuddxsx_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pplnjj_ckm_nexeuddxsx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pplnjj_ckm_nexeuddxsx_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pplnjj_ckm_nexeuddxsx_1_/**/DREALKIND
  use ol_tensor_sum_storage_pplnjj_ckm_nexeuddxsx_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pplnjj_ckm_nexeuddxsx_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pplnjj_ckm_nexeuddxsx_1_/**/DREALKIND, only: ntryL, p_switch, Hel
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(64)
  type(Hpolcont), intent(in) :: M(2,64)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(7)*M(2,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,3,4,8,16],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,1),heltab2x64(:,:,1))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(1),n2h32(1))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)-c(11)*M(2,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,3,4,16,8],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,2),heltab2x64(:,:,2))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(2),n2h32(2))
  call Hloop_AW_Q(ntryL,G1H32(1),wf4(:,3),G1H8(1),m3h4x8(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(1),35,0,G2H8(1),n2h8(1))
  call Hloop_AW_Q(ntryL,G1H32(2),wf4(:,3),G1H8(1),m3h4x8(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G1H8(1),35,0,G2H8(2),n2h8(2))
  call Hloop_AQ_V(ntryL,G2H8(1),ex3(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_V(ntryL,G2H8(2),ex3(:),G2H4(2),m3h2x4(:,2),heltab2x8(:,:,2))
call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
call HG1shiftOLR(G1H4(2),16,4)
call Hotf_5pt_reduction(G2H4(2),RedSet_5(2),mass5set(:,1),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
call HG1shiftOLR(G1H4(8),8,4)
  call Hloop_VQ_A(ntryL,G1H4(1),ex4(:),G1H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(1),n2h2(1))
call HGT_raise_alpha_OLR(G1H4(2),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(2),ex5(:),G1H2(1),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_VQ_A(ntryL,G1H4(5),ex4(:),G1H2(2),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_Q_A(ntryL,G1H2(2),47,0,G2H2(2),n2h2(2))
  call Hloop_VQ_A(ntryL,G1H4(6),ex4(:),G1H2(2),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_Q_A(ntryL,G1H2(2),47,0,G2H2(3),n2h2(3))
  call Hloop_VA_Q(ntryL,G1H4(7),ex5(:),G1H2(2),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_A_Q(ntryL,G1H2(2),55,0,G2H2(4),n2h2(4))
call HGT_raise_alpha_OLR(G1H4(8),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(8),ex4(:),G1H2(2),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_VA_Q(ntryL,G1H4(11),ex5(:),G1H2(3),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_A_Q(ntryL,G1H2(3),55,0,G2H2(5),n2h2(5))
  call Hloop_VA_Q(ntryL,G1H4(12),ex5(:),G1H2(3),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_A_Q(ntryL,G1H2(3),55,0,G2H2(6),n2h2(6))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(1),ex5(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(3),ex5(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(4),ex4(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(6),ex4(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
call G_TensorShift(G1tensor(2),16)
call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(2),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
call G_TensorShift(G1tensor(8),8)
call ol_merge_tensors(T1sum(1),[G1tensor(1)])
call ol_merge_tensors(T1sum(2),[G1tensor(7)])
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(6)*M(2,:)%j) * den(23)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,4,3,24],[0,0,0,0],4,2,wf4(:,3),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,3),heltab2x64(:,:,3))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(6)*M(2,:)%j) * den(23)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,3,24,4],[0,0,0,0],4,2,wf4(:,3),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,4),heltab2x64(:,:,4))
  call Hloop_A_Q(ntryL,G0H32(2),32,0,G1H32(1),n2h32(3))
Gcoeff(:)%j = (c(1)*M(1,:)%j-c(2)*M(2,:)%j) * den(23)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,3,4,24],[0,0,0,0],4,2,wf4(:,3),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,5),heltab2x64(:,:,5))
  call Hloop_A_Q(ntryL,G0H32(2),32,0,G1H32(2),n2h32(4))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)-c(11)*M(2,:)%j) * den(4)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,7,16,8],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,6),heltab2x64(:,:,6))
  call Hloop_A_Q(ntryL,G0H32(2),32,0,G1H32(3),n2h32(5))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(7)*M(2,:)%j) * den(4)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[32,7,8,16],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,7),heltab2x64(:,:,7))
  call Hloop_A_Q(ntryL,G0H32(2),32,0,G1H32(4),n2h32(6))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(7)*M(2,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[35,4,8,16],[0,0,0,0],4,1,wf8(:,13))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,13),G0H8(1),m3h8x8(:,1),heltab2x64(:,:,8))
  call Hloop_A_Q(ntryL,G0H8(1),35,0,G1H8(1),n2h8(3))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)-c(11)*M(2,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[35,4,16,8],[0,0,0,0],4,1,wf8(:,13))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,13),G0H8(1),m3h8x8(:,2),heltab2x64(:,:,9))
  call Hloop_A_Q(ntryL,G0H8(1),35,0,G1H8(2),n2h8(4))
  call Hloop_VQ_A(ntryL,G0H32(1),ex3(:),G0H16(1),m3h2x16(:,1),heltab2x32(:,:,3))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(1),n2h16(1))
  call Hloop_AW_Q(ntryL,G1H32(1),wf4(:,3),G1H8(3),m3h4x8(:,3),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G1H8(3),35,0,G2H8(1),n2h8(5))
  call Hloop_AW_Q(ntryL,G1H32(2),wf4(:,3),G1H8(3),m3h4x8(:,4),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G1H8(3),35,0,G2H8(2),n2h8(6))
  call Hloop_AQ_V(ntryL,G1H32(3),wf8(:,3),G1H4(1),m3h8x4(:,1),heltab2x32(:,:,6))
  call Hloop_AQ_V(ntryL,G1H32(4),wf8(:,3),G1H4(2),m3h8x4(:,2),heltab2x32(:,:,7))
  call Hloop_AQ_V(ntryL,G1H8(1),ex3(:),G1H4(5),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_AQ_V(ntryL,G1H8(2),ex3(:),G1H4(6),m3h2x4(:,4),heltab2x8(:,:,4))
  call ol_merge(ntryL,G1H4(5),[G1H4(3)])
  call ol_merge(ntryL,G1H4(2),[G1H4(4)])
  call ol_merge(ntryL,G1H4(6),[G1H4(9)])
  call ol_merge(ntryL,G1H4(1),[G1H4(10)])
  call Hloop_VQ_A(ntryL,G1H4(5),ex4(:),G1H2(3),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_Q_A(ntryL,G1H2(3),47,0,G2H2(1),n2h2(7))
  call Hloop_VQ_A(ntryL,G1H4(2),ex4(:),G1H2(3),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_Q_A(ntryL,G1H2(3),47,0,G2H2(3),n2h2(8))
  call Hloop_VA_Q(ntryL,G1H4(6),ex5(:),G1H2(3),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_A_Q(ntryL,G1H2(3),55,0,G2H2(4),n2h2(9))
  call Hloop_VA_Q(ntryL,G1H4(1),ex5(:),G1H2(3),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_A_Q(ntryL,G1H2(3),55,0,G2H2(6),n2h2(10))
  call Hloop_QW_A(ntryL,G1H16(1),wf4(:,3),G1H4(7),m3h4x4(:,1),heltab2x16(:,:,1))
  call Hloop_Q_A(ntryL,G1H4(7),39,0,G2H4(1),n2h4(3))
call Hotf_4pt_reduction(G2H8(1),RedSet_4(10),mass4set(:,1),  & 
G1H8(3),G1H8(1),G1H8(2),G1H8(4),G1H8(5),8)
call HG1shiftOLR(G1H8(1),4,8)
  call Hloop_AQ_V(ntryL,G2H8(2),ex3(:),G2H4(2),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_AV_Q(ntryL,G1H8(3),wf4(:,2),G1H2(3),m3h4x2(:,1),heltab2x8(:,:,6))
  call Hloop_A_Q(ntryL,G1H2(3),59,0,G2H2(7),n2h2(11))
call HGT_raise_alpha_OLR(G1H8(1),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(1),ex3(:),G1H4(8),m3h2x4(:,6),heltab2x8(:,:,7))
  call Hloop_AV_Q(ntryL,G1H8(4),wf4(:,2),G1H2(3),m3h4x2(:,2),heltab2x8(:,:,8))
  call Hloop_A_Q(ntryL,G1H2(3),59,0,G2H2(8),n2h2(12))
  call Hloop_AV_Q(ntryL,G1H8(5),wf4(:,2),G1H2(3),m3h4x2(:,3),heltab2x8(:,:,9))
  call Hloop_A_Q(ntryL,G1H2(3),59,0,G2H2(9),n2h2(13))
call HGT_w2_OLR(G1H2(1),1,1,2)
call HGT_w2_invQ_OLR(G1H2(1),2,5,2)
  call Hloop_VQ_A(ntryL,G1H2(1),ex4(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(1),n2h1(1))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(2),ex5(:),G2tensor(3),m3h2x1(:,6),heltab2x2(:,:,6))
call HGT_w2_OLR(G1H2(2),1,1,2)
call HGT_w2_invQ_OLR(G1H2(2),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(2),ex5(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(5),n2h1(2))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(5),ex4(:),G2tensor(6),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(1),ex5(:),G2tensor(7),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(3),ex5(:),G2tensor(8),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(4),ex4(:),G2tensor(9),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(6),ex4(:),G2tensor(10),m3h2x1(:,12),heltab2x2(:,:,12))
call Hotf_4pt_reduction(G2H4(1),RedSet_4(11),mass4set(:,1),  & 
G1H4(11),G1H4(12),G1H4(3),G1H4(4),G1H4(9),4)
call HG1shiftOLR(G1H4(12),24,4)
call Hotf_4pt_reduction(G2H4(2),RedSet_4(4),mass4set(:,1),  & 
G1H4(10),G1H4(5),G1H4(2),G1H4(6),G1H4(1),4)
call HG1shiftOLR(G1H4(5),24,4)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(7),ex3(:),G2tensor(11),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(9),ex3(:),G2tensor(12),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hloop_QV_A(ntryL,G1H4(11),wf4(:,2),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(3))
  call Hloop_QV_A(ntryL,G1H4(12),wf4(:,2),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,0,G2tensor(14),n2h1(4))
  call Hloop_QV_A(ntryL,G1H4(9),wf4(:,2),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(5))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(10),39,wf4(:,2),24,G2tensor(16),m3h4x1(:,4),heltab2x4(:,:,16))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(5),0,wf4(:,2),24,G2tensor(17),m3h4x1(:,5),heltab2x4(:,:,17))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(1),39,wf4(:,2),24,G2tensor(18),m3h4x1(:,6),heltab2x4(:,:,18))
  call ol_merge_tensors(G2tensor(16),[G2tensor(4),G2tensor(2),G1tensor(12),G1tensor(6)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(2)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(3)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(5)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(8)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(9)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(10)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(11)])
call Hotf_4pt_reduction_last(G2tensor(16),RedSet_4(4),mass4set(:,1),  & 
G1tensor(1),G1tensor(7),G1tensor(12),G1tensor(6),G1tensor(2))
call G_TensorShift(G1tensor(7),24)
call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(12),mass4set(:,1),  & 
G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(8),G1tensor(9))
call G_TensorShift(G1tensor(4),8)
call Hotf_4pt_reduction_last(G2tensor(7),RedSet_4(1),mass4set(:,1),  & 
G1tensor(10),G1tensor(11),G1tensor(13),G1tensor(14),G1tensor(15))
call G_TensorShift(G1tensor(11),16)
call Hotf_4pt_reduction_last(G2tensor(8),RedSet_4(2),mass4set(:,1),  & 
G1tensor(16),G1tensor(17),G1tensor(18),G1tensor(19),G1tensor(20))
call G_TensorShift(G1tensor(17),16)
call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(3),mass4set(:,1),  & 
G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24),G1tensor(25))
call G_TensorShift(G1tensor(22),16)
call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(13),mass4set(:,1),  & 
G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
call G_TensorShift(G1tensor(27),16)
call Hotf_4pt_reduction_last(G2tensor(9),RedSet_4(6),mass4set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35))
call G_TensorShift(G1tensor(32),8)
call Hotf_4pt_reduction_last(G2tensor(10),RedSet_4(7),mass4set(:,1),  & 
G1tensor(36),G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40))
call G_TensorShift(G1tensor(37),8)
call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(8),mass4set(:,1),  & 
G1tensor(41),G1tensor(42),G1tensor(43),G1tensor(44),G1tensor(45))
call G_TensorShift(G1tensor(42),8)
call Hotf_4pt_reduction_last(G2tensor(11),RedSet_4(10),mass4set(:,1),  & 
G1tensor(46),G1tensor(47),G1tensor(48),G1tensor(49),G1tensor(50))
call G_TensorShift(G1tensor(47),4)
call Hotf_4pt_reduction_last(G2tensor(13),RedSet_4(11),mass4set(:,1),  & 
G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54),G1tensor(55))
call G_TensorShift(G1tensor(52),24)
call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(4),mass4set(:,1),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
call Hotf_4pt_reduction_last(G1tensor(3),RedSet_4(12),mass4set(:,1),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
call Hotf_4pt_reduction_last(G1tensor(10),RedSet_4(1),mass4set(:,1),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
call Hotf_4pt_reduction_last(G1tensor(16),RedSet_4(2),mass4set(:,1),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
call Hotf_4pt_reduction_last(G1tensor(21),RedSet_4(3),mass4set(:,1),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(13),mass4set(:,1),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(6),mass4set(:,1),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
call Hotf_4pt_reduction_last(G1tensor(36),RedSet_4(7),mass4set(:,1),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(8),mass4set(:,1),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
call Hotf_4pt_reduction_last(G1tensor(46),RedSet_4(10),mass4set(:,1),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(11),mass4set(:,1),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
call ol_merge_tensors(T0sum(1),[G0tensor(1)])
call ol_merge_tensors(T0sum(2),[G0tensor(6)])
call ol_merge_tensors(T0sum(3),[G0tensor(11)])
call ol_merge_tensors(T0sum(4),[G0tensor(16)])
call ol_merge_tensors(T0sum(5),[G0tensor(21)])
call ol_merge_tensors(T0sum(6),[G0tensor(26)])
call ol_merge_tensors(T0sum(7),[G0tensor(31)])
call ol_merge_tensors(T0sum(8),[G0tensor(36)])
call ol_merge_tensors(T0sum(9),[G0tensor(41)])
call ol_merge_tensors(T0sum(10),[G0tensor(46)])
call ol_merge_tensors(T0sum(11),[G0tensor(51)])
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(6)*M(2,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,7,24],[0,0,0],3,2,wf8(:,3),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,8),heltab2x64(:,:,10))
Gcoeff(:)%j = (c(1)*M(1,:)%j-c(2)*M(2,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[32,7,24],[0,0,0],3,2,wf8(:,3),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,9),heltab2x64(:,:,11))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(1),n2h32(7))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(6)*M(2,:)%j) * den(11)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[35,4,24],[0,0,0],3,2,wf8(:,13),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,13),G0H8(1),m3h8x8(:,3),heltab2x64(:,:,12))
Gcoeff(:)%j = (c(1)*M(1,:)%j-c(2)*M(2,:)%j) * den(11)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[35,4,24],[0,0,0],3,2,wf8(:,13),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,13),G0H8(2),m3h8x8(:,4),heltab2x64(:,:,13))
  call Hloop_A_Q(ntryL,G0H8(2),35,0,G1H8(3),n2h8(8))
Gcoeff(:)%j = (c(8)*M(1,:)%j-c(12)*M(2,:)%j) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[32,3,28],[0,0,0],3,2,wf4(:,3),wf8(:,6))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,10),heltab2x64(:,:,14))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(2),n2h32(8))
Gcoeff(:)%j = (c(8)*M(1,:)%j-c(12)*M(2,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[56,3,4],[0,0,0],3,2,wf8(:,15),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,15),G0H8(2),m3h8x8(:,5),heltab2x64(:,:,15))
  call Hloop_A_Q(ntryL,G0H8(2),56,0,G1H8(1),n2h8(9))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(6)*M(2,:)%j) * den(21)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[39,8,16],[0,0,0],3,1,wf16(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,1),G0H4(1),m3h16x4(:,1),heltab2x64(:,:,16))
  call Hloop_A_Q(ntryL,G0H4(1),39,0,G1H4(7),n2h4(4))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)+c(2)*M(2,:)%j) * den(21)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[39,8,16],[0,0,0],3,1,wf16(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,1),39,G1H4(11),m3h16x4(:,2),heltab2x64(:,:,17))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(6)*M(2,:)%j) * den(22)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[39,8,16],[0,0,0],3,1,wf16(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,2),G0H4(1),m3h16x4(:,3),heltab2x64(:,:,18))
  call Hloop_A_Q(ntryL,G0H4(1),39,0,G1H4(12),n2h4(5))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)+c(2)*M(2,:)%j) * den(22)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[39,8,16],[0,0,0],3,1,wf16(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,2),39,G1H4(9),m3h16x4(:,4),heltab2x64(:,:,19))
  call ol_merge(ntryL,G1H4(12),[G1H4(7)])
  call ol_merge(ntryL,G1H4(9),[G1H4(11)])
  call Hloop_AV_Q(ntryL,G1H8(2),wf4(:,2),G1H2(3),m3h4x2(:,4),heltab2x8(:,:,10))
  call Hloop_A_Q(ntryL,G1H2(3),59,0,G2H2(2),n2h2(14))
  call Hloop_VQ_A(ntryL,G0H32(2),wf8(:,3),G0H4(1),m3h8x4(:,3),heltab2x32(:,:,8))
  call Hloop_Q_A(ntryL,G0H4(1),39,0,G1H4(10),n2h4(6))
  call Hloop_AQ_V(ntryL,G1H32(1),wf8(:,3),G1H4(5),m3h8x4(:,4),heltab2x32(:,:,9))
  call Hloop_VQ_A(ntryL,G0H8(1),ex3(:),G0H4(1),m3h2x4(:,7),heltab2x8(:,:,11))
  call Hloop_Q_A(ntryL,G0H4(1),39,0,G1H4(1),n2h4(7))
  call Hloop_AQ_V(ntryL,G1H8(3),ex3(:),G1H4(7),m3h2x4(:,8),heltab2x8(:,:,12))
  call Hloop_AW_Q(ntryL,G1H32(2),wf4(:,3),G1H8(4),m3h4x8(:,5),heltab2x32(:,:,10))
  call Hloop_A_Q(ntryL,G1H8(4),35,0,G2H8(1),n2h8(10))
  call Hloop_AW_Q(ntryL,G1H8(1),wf4(:,3),G1H2(1),m3h4x2(:,5),heltab2x8(:,:,13))
  call Hloop_A_Q(ntryL,G1H2(1),59,0,G2H2(5),n2h2(15))
  call Hloop_AQ_V(ntryL,G1H4(12),ex4(:),G1H2(2),m3h2x2(:,13),heltab2x4(:,:,19))
  call Hloop_VQ_A(ntryL,G1H4(9),ex4(:),G1H2(3),m3h2x2(:,14),heltab2x4(:,:,20))
  call Hloop_Q_A(ntryL,G1H2(3),47,0,G2H2(1),n2h2(16))
  call ol_merge(ntryL,G1H4(10),[G1H4(4)])
  call ol_merge(ntryL,G1H4(7),[G1H4(2)])
  call ol_merge(ntryL,G1H4(5),[G1H4(6)])
call HGT_w2_OLR(G1H4(8),1,1,4)
call HGT_w2_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_AV_Q(ntryL,G1H4(8),wf4(:,2),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(4),n2h1(7))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(8),ex3(:),G2tensor(2),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hloop_QV_A(ntryL,G1H4(3),wf4(:,2),G1H1(1),m3h4x1(:,8),heltab2x4(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(16),n2h1(8))
  call Hloop_QV_A(ntryL,G1H4(10),wf4(:,2),G1H1(1),m3h4x1(:,9),heltab2x4(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(1),n2h1(9))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(7),39,wf4(:,2),24,G2tensor(7),m3h4x1(:,10),heltab2x4(:,:,24))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(5),39,wf4(:,2),24,G2tensor(8),m3h4x1(:,11),heltab2x4(:,:,25))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(2),ex3(:),G2tensor(3),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hloop_QV_A(ntryL,G1H4(1),wf4(:,2),G1H1(1),m3h4x1(:,12),heltab2x4(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(5),n2h1(10))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(1),wf8(:,6),G2tensor(9),m3h8x1(:,1),heltab2x8(:,:,14))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(5),ex3(:),G2tensor(10),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hloop_VA_Q(ntryL,G1H2(2),ex5(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(6),n2h1(11))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(1),ex5(:),G2tensor(11),m3h2x1(:,19),heltab2x2(:,:,19))
  call ol_merge_tensors(G2tensor(9),[G2tensor(18),G2tensor(12),G1tensor(50),G1tensor(45),G1tensor(25),G1tensor(2),G0tensor(50) &
    ,G0tensor(45),G0tensor(25),G0tensor(5)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(52),G0tensor(52)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(55),G0tensor(55)])
  call ol_merge_tensors(G2tensor(10),[G2tensor(17),G1tensor(27),G1tensor(4),G1tensor(7),G0tensor(27),G0tensor(7),G0tensor(2)])
  call ol_merge_tensors(G2tensor(5),[G2tensor(7),G1tensor(35),G1tensor(15),G1tensor(12),G0tensor(35),G0tensor(15),G0tensor(3)])
  call ol_merge_tensors(G2tensor(8),[G2tensor(1),G1tensor(54),G1tensor(40),G1tensor(20),G1tensor(6),G0tensor(54),G0tensor(40) &
    ,G0tensor(20),G0tensor(4)])
  call ol_merge_tensors(G1tensor(11),[G1tensor(5),G0tensor(12),G0tensor(8)])
  call ol_merge_tensors(G1tensor(17),[G1tensor(8),G0tensor(17),G0tensor(9)])
  call ol_merge_tensors(G1tensor(22),[G1tensor(9),G0tensor(22),G0tensor(10)])
  call ol_merge_tensors(G2tensor(11),[G2tensor(6),G1tensor(18),G1tensor(13),G0tensor(18),G0tensor(13)])
  call ol_merge_tensors(G1tensor(23),[G1tensor(14),G0tensor(23),G0tensor(14)])
  call ol_merge_tensors(G1tensor(24),[G1tensor(19),G0tensor(24),G0tensor(19)])
  call ol_merge_tensors(G1tensor(32),[G1tensor(28),G0tensor(32),G0tensor(28)])
  call ol_merge_tensors(G1tensor(37),[G1tensor(29),G0tensor(37),G0tensor(29)])
  call ol_merge_tensors(G1tensor(42),[G1tensor(30),G0tensor(42),G0tensor(30)])
  call ol_merge_tensors(G1tensor(38),[G1tensor(33),G0tensor(38),G0tensor(33)])
  call ol_merge_tensors(G1tensor(43),[G1tensor(34),G0tensor(43),G0tensor(34)])
  call ol_merge_tensors(G1tensor(44),[G1tensor(39),G0tensor(44),G0tensor(39)])
  call ol_merge_tensors(G2tensor(16),[G2tensor(4),G1tensor(53),G1tensor(47),G0tensor(53),G0tensor(47)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(48),G0tensor(48)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(49),G0tensor(49)])
call TI_triangle_red(G2tensor(9),RedBasis(1),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1)
call TI_triangle_red(G2tensor(14),RedBasis(25),mass3set(:,1),G0tensor(21),G0tensor(26),G0tensor(31),G0tensor(36),M2L1R1)
call TI_triangle_red(G2tensor(15),RedBasis(17),mass3set(:,1),G0tensor(41),G0tensor(46),G0tensor(51),G0tensor(50),M2L1R1)
call TI_triangle_red(G2tensor(10),RedBasis(26),mass3set(:,1),G0tensor(45),G0tensor(25),G0tensor(5),G0tensor(52),M2L1R1)
call TI_triangle_red(G2tensor(5),RedBasis(4),mass3set(:,1),G0tensor(55),G0tensor(27),G0tensor(7),G0tensor(2),M2L1R1)
call TI_triangle_red(G2tensor(8),RedBasis(2),mass3set(:,1),G0tensor(35),G0tensor(15),G0tensor(3),G0tensor(54),M2L1R1)
call TI_triangle_red(G2tensor(11),RedBasis(6),mass3set(:,1),G0tensor(40),G0tensor(20),G0tensor(4),G0tensor(12),M2L1R1)
call TI_triangle_red(G2tensor(16),RedBasis(18),mass3set(:,1),G0tensor(8),G0tensor(17),G0tensor(9),G0tensor(22),M2L1R1)
call TI_triangle_red(G2tensor(3),RedBasis(16),mass3set(:,1),G0tensor(10),G0tensor(18),G0tensor(13),G0tensor(23),M2L1R1)
call TI_triangle_red(G2tensor(2),RedBasis(15),mass3set(:,1),G0tensor(14),G0tensor(24),G0tensor(19),G0tensor(32),M2L1R1)
call TI_triangle_red(G1tensor(11),RedBasis(21),mass3set(:,1),G0tensor(28),G0tensor(37),G0tensor(29),G0tensor(42),M2L1R1)
call TI_triangle_red(G1tensor(17),RedBasis(20),mass3set(:,1),G0tensor(30),G0tensor(38),G0tensor(33),G0tensor(43),M2L1R1)
call TI_triangle_red(G1tensor(22),RedBasis(19),mass3set(:,1),G0tensor(34),G0tensor(44),G0tensor(39),G0tensor(53),M2L1R1)
call TI_triangle_red(G1tensor(23),RedBasis(5),mass3set(:,1),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(56),M2L1R1)
call TI_triangle_red(G1tensor(24),RedBasis(3),mass3set(:,1),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60),M2L1R1)
call TI_triangle_red(G1tensor(32),RedBasis(24),mass3set(:,1),G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),M2L1R1)
call TI_triangle_red(G1tensor(37),RedBasis(23),mass3set(:,1),G0tensor(65),G0tensor(66),G0tensor(67),G0tensor(68),M2L1R1)
call TI_triangle_red(G1tensor(42),RedBasis(22),mass3set(:,1),G0tensor(69),G0tensor(70),G0tensor(71),G0tensor(72),M2L1R1)
call TI_triangle_red(G1tensor(38),RedBasis(9),mass3set(:,1),G0tensor(73),G0tensor(74),G0tensor(75),G0tensor(76),M2L1R1)
call TI_triangle_red(G1tensor(43),RedBasis(8),mass3set(:,1),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80),M2L1R1)
call TI_triangle_red(G1tensor(44),RedBasis(7),mass3set(:,1),G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),M2L1R1)
call ol_merge_tensors(T0sum(12),[G0tensor(1)])
call ol_merge_tensors(T0sum(13),[G0tensor(21)])
call ol_merge_tensors(T0sum(14),[G0tensor(41)])
call ol_merge_tensors(T0sum(15),[G0tensor(45)])
call ol_merge_tensors(T0sum(16),[G0tensor(55)])
call ol_merge_tensors(T0sum(17),[G0tensor(35)])
call ol_merge_tensors(T0sum(18),[G0tensor(28)])
call ol_merge_tensors(T0sum(19),[G0tensor(30)])
call ol_merge_tensors(T0sum(20),[G0tensor(34)])
call ol_merge_tensors(T0sum(21),[G0tensor(40)])
call ol_merge_tensors(T0sum(22),[G0tensor(47)])
call ol_merge_tensors(T0sum(23),[G0tensor(57)])
call ol_merge_tensors(T0sum(24),[G0tensor(61)])
call ol_merge_tensors(T0sum(25),[G0tensor(65)])
call ol_merge_tensors(T0sum(26),[G0tensor(69)])
call ol_merge_tensors(T0sum(27),[G0tensor(73)])
call ol_merge_tensors(T0sum(28),[G0tensor(77)])
call ol_merge_tensors(T0sum(29),[G0tensor(81)])
call ol_merge_tensors(T0sum(30),[G0tensor(8)])
call ol_merge_tensors(T0sum(31),[G0tensor(10)])
call ol_merge_tensors(T0sum(32),[G0tensor(14)])
Gcoeff(:)%j = (-(c(16)*M(1,:)%j)+c(17)*M(2,:)%j) * den(24)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[39,24],[0,0],2,2,wf16(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,1),G0H4(1),m3h16x4(:,5),heltab2x64(:,:,20))
  call Hloop_Q_A(ntryL,G0H4(1),39,0,G1H4(11),n2h4(8))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(2,:)%j) * den(24)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[39,24],[nMT,nMT],2,2,wf16(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,1),G0H4(1),m3h16x4(:,6),heltab2x64(:,:,21))
  call Hloop_Q_A(ntryL,G0H4(1),39,nMT,G1H4(12),n2h4(9))
Gcoeff(:)%j = (-(c(16)*M(1,:)%j)+c(17)*M(2,:)%j) * den(24)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[39,24],[0,0],2,2,wf16(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,1),G0H4(1),m3h16x4(:,7),heltab2x64(:,:,22))
  call Hloop_Q_A(ntryL,G0H4(1),39,0,G1H4(9),n2h4(10))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(2,:)%j) * den(24)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[39,24],[nMB,nMB],2,2,wf16(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,1),G0H4(1),m3h16x4(:,8),heltab2x64(:,:,23))
  call Hloop_Q_A(ntryL,G0H4(1),39,nMB,G1H4(4),n2h4(11))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(13)*M(2,:)%j) * den(24)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[39,24],[0,0],2,2,wf16(:,1),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,1),39,G1H4(2),m3h16x4(:,9),heltab2x64(:,:,24))
Gcoeff(:)%j = (c(3)*M(1,:)%j-c(4)*M(2,:)%j) * den(24)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[39,24],[0,0],2,2,wf16(:,1),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,1),39,G1H4(6),m3h16x4(:,10),heltab2x64(:,:,25))
Gcoeff(:)%j = (c(8)*M(1,:)%j-c(12)*M(2,:)%j) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[56,7],[0,0],2,2,wf8(:,15),wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,15),G0H8(2),m3h8x8(:,6),heltab2x64(:,:,26))
  call Hloop_A_Q(ntryL,G0H8(2),56,0,G1H8(5),n2h8(11))
Gcoeff(:)%j = (c(8)*M(1,:)%j-c(12)*M(2,:)%j) * den(18)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[35,28],[0,0],2,2,wf8(:,13),wf8(:,6))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,13),G0H8(1),m3h8x8(:,7),heltab2x64(:,:,27))
  call Hloop_A_Q(ntryL,G0H8(1),35,0,G1H8(2),n2h8(12))
Gcoeff(:)%j = (-(c(16)*M(1,:)%j)+c(17)*M(2,:)%j) * den(25)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[39,24],[0,0],2,2,wf16(:,2),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,2),G0H4(1),m3h16x4(:,11),heltab2x64(:,:,28))
  call Hloop_Q_A(ntryL,G0H4(1),39,0,G1H4(8),n2h4(12))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(2,:)%j) * den(25)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[39,24],[nMT,nMT],2,2,wf16(:,2),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,2),G0H4(1),m3h16x4(:,12),heltab2x64(:,:,29))
  call Hloop_Q_A(ntryL,G0H4(1),39,nMT,G1H4(3),n2h4(13))
Gcoeff(:)%j = (-(c(16)*M(1,:)%j)+c(17)*M(2,:)%j) * den(25)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[39,24],[0,0],2,2,wf16(:,2),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,2),G0H4(1),m3h16x4(:,13),heltab2x64(:,:,30))
  call Hloop_Q_A(ntryL,G0H4(1),39,0,G1H4(10),n2h4(14))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(2,:)%j) * den(25)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[39,24],[nMB,nMB],2,2,wf16(:,2),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,2),G0H4(1),m3h16x4(:,14),heltab2x64(:,:,31))
  call Hloop_Q_A(ntryL,G0H4(1),39,nMB,G1H4(7),n2h4(15))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(13)*M(2,:)%j) * den(25)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[39,24],[0,0],2,2,wf16(:,2),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,2),39,G1H4(5),m3h16x4(:,15),heltab2x64(:,:,32))
Gcoeff(:)%j = (c(3)*M(1,:)%j-c(4)*M(2,:)%j) * den(25)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[39,24],[0,0],2,2,wf16(:,2),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,2),39,G1H4(1),m3h16x4(:,16),heltab2x64(:,:,33))
  call ol_merge(ntryL,G1H4(10),[G1H4(8),G1H4(9),G1H4(11)])
  call ol_merge(ntryL,G1H4(3),[G1H4(12)])
  call ol_merge(ntryL,G1H4(7),[G1H4(4)])
  call ol_merge(ntryL,G1H4(5),[G1H4(2)])
  call ol_merge(ntryL,G1H4(1),[G1H4(6)])
  call Hloop_QV_A(ntryL,G1H4(10),wf4(:,2),G1H1(1),m3h4x1(:,13),heltab2x4(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(12))
  call Hloop_QV_A(ntryL,G1H4(3),wf4(:,2),G1H1(1),m3h4x1(:,14),heltab2x4(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(18),n2h1(13))
  call Hloop_QV_A(ntryL,G1H4(7),wf4(:,2),G1H1(1),m3h4x1(:,15),heltab2x4(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(12),n2h1(14))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(5),39,wf4(:,2),24,G2tensor(17),m3h4x1(:,16),heltab2x4(:,:,30))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(1),39,wf4(:,2),24,G2tensor(7),m3h4x1(:,17),heltab2x4(:,:,31))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(5),wf8(:,3),G1tensor(1),m3h8x1(:,2),heltab2x8(:,:,15))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(2),wf8(:,6),G1tensor(3),m3h8x1(:,3),heltab2x8(:,:,16))
  call ol_merge_tensors(G0tensor(70),[G0tensor(44),G0tensor(17),G0tensor(25),G0tensor(31),G0tensor(6)])
  call ol_merge_tensors(G1tensor(3),[G0tensor(80),G0tensor(56),G0tensor(23),G0tensor(2),G0tensor(11)])
  call ol_merge_tensors(G0tensor(84),[G0tensor(60),G0tensor(32),G0tensor(54),G0tensor(50),G0tensor(16)])
  call ol_merge_tensors(G0tensor(62),[G0tensor(37),G0tensor(19),G0tensor(13),G0tensor(27),G0tensor(5),G0tensor(46),G0tensor(26)])
  call ol_merge_tensors(G1tensor(1),[G0tensor(66),G0tensor(38),G0tensor(15),G0tensor(52),G0tensor(36)])
  call ol_merge_tensors(G0tensor(24),[G0tensor(22),G0tensor(51)])
  call ol_merge_tensors(G2tensor(7),[G2tensor(17),G2tensor(13),G0tensor(76),G0tensor(18),G0tensor(9),G0tensor(12),G0tensor(3) &
    ,G0tensor(7)])
  call ol_merge_tensors(G0tensor(83),[G0tensor(79),G0tensor(75),G0tensor(33),G0tensor(29),G0tensor(20)])
  call ol_merge_tensors(G0tensor(74),[G0tensor(67),G0tensor(63),G0tensor(59),G0tensor(49),G0tensor(4)])
  call ol_merge_tensors(G0tensor(48),[G0tensor(39),G0tensor(42)])
  call ol_merge_tensors(G0tensor(58),[G0tensor(53),G0tensor(43)])
  call ol_merge_tensors(G0tensor(78),[G0tensor(71),G0tensor(64)])
  call ol_merge_tensors(G0tensor(82),[G0tensor(72),G0tensor(68)])
call TI_bubble_red(G2tensor(7),39,mass2set(:,1),G0tensor(1),M2L1R1)
call TI_bubble_red(G2tensor(18),39,mass2set(:,2),G0tensor(21),M2L1R1,G0tensor(41))
call TI_bubble_red(G2tensor(12),39,mass2set(:,3),G0tensor(45),M2L1R1,G0tensor(55))
call TI_bubble_red(G1tensor(3),35,mass2set(:,1),G0tensor(35),M2L1R1)
call TI_bubble_red(G1tensor(1),56,mass2set(:,1),G0tensor(28),M2L1R1)
call ol_merge_tensors(T0sum(33),[G0tensor(70)])
call ol_merge_tensors(T0sum(34),[G0tensor(35)])
call ol_merge_tensors(T0sum(35),[G0tensor(84)])
call ol_merge_tensors(T0sum(36),[G0tensor(62)])
call ol_merge_tensors(T0sum(37),[G0tensor(28)])
call ol_merge_tensors(T0sum(38),[G0tensor(24)])
call ol_merge_tensors(T0sum(39),[G0tensor(1)])
call ol_merge_tensors(T0sum(40),[G0tensor(83)])
call ol_merge_tensors(T0sum(41),[G0tensor(74)])
call ol_merge_tensors(T0sum(42),[G0tensor(48)])
call ol_merge_tensors(T0sum(43),[G0tensor(58)])
call ol_merge_tensors(T0sum(44),[G0tensor(78)])
call ol_merge_tensors(T0sum(45),[G0tensor(82)])
call ol_merge_tensors(T0sum(46),[G0tensor(21)])
call ol_merge_tensors(T0sum(47),[G0tensor(41)])
call ol_merge_tensors(T0sum(48),[G0tensor(45)])
call ol_merge_tensors(T0sum(49),[G0tensor(55)])


! Compute scalar Master integrals 

call compute_scalar_box([ 35, 39, 47 ],masses2_7,RedSet_4(1),ScalarBoxes(1))
call compute_scalar_box([ 32, 39, 47 ],masses2_7,RedSet_4(2),ScalarBoxes(2))
call compute_scalar_box([ 32, 35, 47 ],masses2_7,RedSet_4(3),ScalarBoxes(3))
call compute_scalar_box([ 32, 35, 39 ],masses2_7,RedSet_4(4),ScalarBoxes(4))
call compute_scalar_box([ 3, 7, 15 ],masses2_7,RedSet_4(5),ScalarBoxes(5))
call compute_scalar_box([ 35, 39, 55 ],masses2_7,RedSet_4(6),ScalarBoxes(6))
call compute_scalar_box([ 32, 39, 55 ],masses2_7,RedSet_4(7),ScalarBoxes(7))
call compute_scalar_box([ 32, 35, 55 ],masses2_7,RedSet_4(8),ScalarBoxes(8))
call compute_scalar_box([ 3, 7, 23 ],masses2_7,RedSet_4(9),ScalarBoxes(9))
! end of process


end subroutine vamp_1

end module ol_vamp_1_pplnjj_ckm_nexeuddxsx_1_/**/REALKIND
