
module ol_vamp_1_pplnjj_ckm_neexuxdddx_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pplnjj_ckm_neexuxdddx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pplnjj_ckm_neexuxdddx_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pplnjj_ckm_neexuxdddx_1_/**/DREALKIND
  use ol_tensor_sum_storage_pplnjj_ckm_neexuxdddx_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pplnjj_ckm_neexuxdddx_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pplnjj_ckm_neexuxdddx_1_/**/DREALKIND, only: ntryL, p_switch, Hel
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(64)
  type(Hpolcont), intent(in) :: M(2,64)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

Gcoeff(:)%j = (c(5)*M(1,:)%j+c(11)*M(2,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,8,4,3,16],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,1),heltab2x64(:,:,1))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(1),n2h32(1))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(5)*M(2,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,8,3,4,16],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,2),heltab2x64(:,:,2))
Gcoeff(:)%j = (c(9)*M(1,:)%j-c(7)*M(2,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,4,3,16,8],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,3),heltab2x64(:,:,3))
Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(2,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,4,3,8,16],[0,0,0,0,0],5,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,4),heltab2x64(:,:,4))
  call Hloop_AQ_V(ntryL,G1H32(1),ex4(:),G1H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_VQ_A(ntryL,G0H32(1),ex4(:),G0H16(1),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(2),n2h16(1))
  call Hloop_VA_Q(ntryL,G0H32(2),ex3(:),G0H16(1),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(3),n2h16(2))
  call Hloop_VA_Q(ntryL,G0H32(3),ex3(:),G0H16(1),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(4),n2h16(3))
  call Hloop_VA_Q(ntryL,G1H16(1),ex3(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(1),n2h8(1))
  call Hloop_QW_A(ntryL,G1H16(2),wf4(:,3),G1H4(1),m3h4x4(:,1),heltab2x16(:,:,2))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(1),n2h4(1))
  call Hloop_AW_Q(ntryL,G1H16(3),wf4(:,3),G1H4(1),m3h4x4(:,2),heltab2x16(:,:,3))
  call Hloop_A_Q(ntryL,G1H4(1),39,0,G2H4(2),n2h4(2))
  call Hloop_AW_Q(ntryL,G1H16(4),wf4(:,3),G1H4(1),m3h4x4(:,3),heltab2x16(:,:,4))
  call Hloop_A_Q(ntryL,G1H4(1),39,0,G2H4(3),n2h4(3))
call Hotf_5pt_reduction(G2H8(1),RedSet_5(1),mass5set(:,1),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),G1H8(6),8)
call HG1shiftOLR(G1H8(2),16,8)
  call Hloop_QA_V(ntryL,G2H4(1),ex3(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_AQ_V(ntryL,G2H4(2),ex5(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_AQ_V(ntryL,G2H4(3),ex4(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_AW_Q(ntryL,G1H8(1),wf4(:,3),G1H2(1),m3h4x2(:,1),heltab2x8(:,:,1))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(4),n2h2(1))
call HGT_raise_alpha_OLR(G1H8(2),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(2),ex5(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,2))
  call Hloop_AW_Q(ntryL,G1H8(5),wf4(:,3),G1H2(1),m3h4x2(:,2),heltab2x8(:,:,3))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(5),n2h2(2))
  call Hloop_AW_Q(ntryL,G1H8(6),wf4(:,3),G1H2(1),m3h4x2(:,3),heltab2x8(:,:,4))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(6),n2h2(3))
call Hotf_5pt_reduction(G2H2(1),RedSet_5(2),mass5set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
call HG1shiftOLR(G1H2(2),16,2)
call Hotf_5pt_reduction(G2H2(2),RedSet_5(3),mass5set(:,1),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
call HG1shiftOLR(G1H2(8),8,2)
call Hotf_5pt_reduction(G2H2(3),RedSet_5(4),mass5set(:,1),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),G1H2(18),2)
call HG1shiftOLR(G1H2(14),16,2)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(4),ex5(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(6),ex5(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hloop_VQ_A(ntryL,G1H2(1),ex5(:),G1H1(1),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(3),n2h1(1))
  call Hloop_VQ_A(ntryL,G1H2(2),ex5(:),G1H1(1),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(4),n2h1(2))
  call Hloop_VQ_A(ntryL,G1H2(6),ex5(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(5),n2h1(3))
  call Hloop_VQ_A(ntryL,G1H2(7),ex4(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(6),n2h1(4))
  call Hloop_VQ_A(ntryL,G1H2(8),ex4(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(7),n2h1(5))
  call Hloop_VQ_A(ntryL,G1H2(12),ex4(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(8),n2h1(6))
  call Hloop_VQ_A(ntryL,G1H2(13),ex5(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(9),n2h1(7))
  call Hloop_VQ_A(ntryL,G1H2(14),ex5(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(10),n2h1(8))
  call Hloop_VQ_A(ntryL,G1H2(18),ex5(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(9))
call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
call G_TensorShift(G1tensor(2),16)
call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(2),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
call G_TensorShift(G1tensor(8),16)
call Hotf_5pt_reduction_last(G2tensor(6),RedSet_5(3),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
call G_TensorShift(G1tensor(14),8)
call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(4),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
call G_TensorShift(G1tensor(20),16)
call ol_merge_tensors(T1sum(1),[G1tensor(1)])
call ol_merge_tensors(T1sum(2),[G1tensor(7)])
call ol_merge_tensors(T1sum(3),[G1tensor(13)])
call ol_merge_tensors(T1sum(4),[G1tensor(19)])
Gcoeff(:)%j = (c(5)*M(1,:)%j-c(6)*M(2,:)%j) * den(41)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[40,3,4,16],[0,0,0,0],4,2,wf4(:,2),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,1),heltab2x64(:,:,5))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(1),n2h16(4))
Gcoeff(:)%j = (c(5)*M(1,:)%j-c(6)*M(2,:)%j) * den(41)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[40,3,16,4],[0,0,0,0],4,2,wf4(:,2),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,2),heltab2x64(:,:,6))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(2),n2h16(5))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)+c(2)*M(2,:)%j) * den(41)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[40,4,3,16],[0,0,0,0],4,2,wf4(:,2),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,2),40,G1H16(3),m3h4x16(:,3),heltab2x64(:,:,7))
Gcoeff(:)%j = (c(6)*M(1,:)%j-c(5)*M(2,:)%j) * den(42)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[48,3,4,8],[0,0,0,0],4,2,wf4(:,4),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,4),heltab2x64(:,:,8))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(4),n2h16(6))
Gcoeff(:)%j = (c(6)*M(1,:)%j-c(5)*M(2,:)%j) * den(42)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[48,3,8,4],[0,0,0,0],4,2,wf4(:,4),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,5),heltab2x64(:,:,9))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(5),n2h16(7))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(2,:)%j) * den(42)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[48,4,3,8],[0,0,0,0],4,2,wf4(:,4),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),48,G1H16(6),m3h4x16(:,6),heltab2x64(:,:,10))
Gcoeff(:)%j = (c(9)*M(1,:)%j-c(7)*M(2,:)%j) * den(4)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[32,7,16,8],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,5),heltab2x64(:,:,11))
Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(2,:)%j) * den(4)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[32,7,8,16],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,6),heltab2x64(:,:,12))
Gcoeff(:)%j = (c(5)*M(1,:)%j+c(11)*M(2,:)%j) * den(4)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[32,8,7,16],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,7),heltab2x64(:,:,13))
  call Hloop_A_Q(ntryL,G0H32(3),32,0,G1H32(1),n2h32(2))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(5)*M(2,:)%j) * den(4)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[32,8,7,16],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,8),heltab2x64(:,:,14))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(5)*M(2,:)%j) * den(21)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[32,11,4,16],[0,0,0,0],4,1,wf8(:,26))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,9),heltab2x64(:,:,15))
Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(2,:)%j) * den(21)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[32,4,11,16],[0,0,0,0],4,1,wf8(:,26))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,10),heltab2x64(:,:,16))
Gcoeff(:)%j = (c(5)*M(1,:)%j+c(11)*M(2,:)%j) * den(15)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[32,8,4,19],[0,0,0,0],4,1,wf8(:,22))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,11),heltab2x64(:,:,17))
  call Hloop_A_Q(ntryL,G0H32(6),32,0,G1H32(2),n2h32(3))
Gcoeff(:)%j = (c(9)*M(1,:)%j-c(7)*M(2,:)%j) * den(15)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[32,4,19,8],[0,0,0,0],4,1,wf8(:,22))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,12),heltab2x64(:,:,18))
  call Hloop_QW_A(ntryL,G1H16(1),wf4(:,3),G1H4(2),m3h4x4(:,4),heltab2x16(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(2),43,0,G2H4(1),n2h4(4))
  call Hloop_AW_Q(ntryL,G1H16(2),wf4(:,3),G1H4(2),m3h4x4(:,5),heltab2x16(:,:,6))
  call Hloop_A_Q(ntryL,G1H4(2),43,0,G2H4(2),n2h4(5))
  call Hloop_VA_Q(ntryL,G1H16(3),ex3(:),G1H8(1),m3h2x8(:,2),heltab2x16(:,:,7))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(1),n2h8(3))
  call Hloop_QW_A(ntryL,G1H16(4),wf4(:,3),G1H4(2),m3h4x4(:,6),heltab2x16(:,:,8))
  call Hloop_Q_A(ntryL,G1H4(2),51,0,G2H4(3),n2h4(6))
  call Hloop_AW_Q(ntryL,G1H16(5),wf4(:,3),G1H4(2),m3h4x4(:,7),heltab2x16(:,:,9))
  call Hloop_A_Q(ntryL,G1H4(2),51,0,G2H4(4),n2h4(7))
  call Hloop_VA_Q(ntryL,G1H16(6),ex3(:),G1H8(2),m3h2x8(:,3),heltab2x16(:,:,10))
  call Hloop_A_Q(ntryL,G1H8(2),52,0,G2H8(2),n2h8(4))
  call Hloop_VA_Q(ntryL,G0H32(1),wf8(:,3),G0H4(1),m3h8x4(:,1),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G0H4(1),39,0,G1H4(2),n2h4(8))
  call Hloop_VA_Q(ntryL,G0H32(2),wf8(:,3),G0H4(1),m3h8x4(:,2),heltab2x32(:,:,6))
  call Hloop_A_Q(ntryL,G0H4(1),39,0,G1H4(3),n2h4(9))
  call Hloop_AQ_V(ntryL,G1H32(1),ex4(:),G1H16(1),m3h2x16(:,5),heltab2x32(:,:,7))
  call Hloop_VQ_A(ntryL,G0H32(3),ex4(:),G0H16(1),m3h2x16(:,6),heltab2x32(:,:,8))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(2),n2h16(8))
  call Hloop_VQ_A(ntryL,G0H32(4),wf8(:,26),G0H4(1),m3h8x4(:,3),heltab2x32(:,:,9))
  call Hloop_Q_A(ntryL,G0H4(1),43,0,G1H4(4),n2h4(10))
  call Hloop_VA_Q(ntryL,G0H32(5),ex3(:),G0H16(1),m3h2x16(:,7),heltab2x32(:,:,10))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(3),n2h16(9))
  call Hloop_AQ_V(ntryL,G1H32(2),ex4(:),G1H16(4),m3h2x16(:,8),heltab2x32(:,:,11))
  call Hloop_VA_Q(ntryL,G0H32(6),ex3(:),G0H16(1),m3h2x16(:,9),heltab2x32(:,:,12))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(5),n2h16(10))
  call ol_merge(ntryL,G2H8(1),[G1H8(3)])
call Hotf_4pt_reduction(G2H8(1),RedSet_4(1),mass4set(:,1),  & 
G1H8(5),G1H8(6),G1H8(1),G1H8(2),G1H8(3),8)
call HG1shiftOLR(G1H8(6),16,8)
  call Hloop_AW_Q(ntryL,G1H8(4),wf4(:,3),G1H2(1),m3h4x2(:,4),heltab2x8(:,:,5))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(1),n2h2(4))
  call Hloop_QA_V(ntryL,G2H4(1),ex3(:),G2H2(2),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_AQ_V(ntryL,G2H4(2),ex5(:),G2H2(3),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QA_V(ntryL,G2H4(3),ex3(:),G2H2(4),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_AQ_V(ntryL,G2H4(4),ex4(:),G2H2(6),m3h2x2(:,7),heltab2x4(:,:,7))
call Hotf_4pt_reduction(G2H8(2),RedSet_4(19),mass4set(:,1),  & 
G1H8(4),G1H8(7),G1H8(8),G1H8(9),G1H8(10),8)
call HG1shiftOLR(G1H8(7),8,8)
  call Hloop_AQ_V(ntryL,G1H4(2),ex5(:),G1H2(2),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_AQ_V(ntryL,G1H4(3),ex4(:),G1H2(6),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_VA_Q(ntryL,G1H16(1),wf8(:,3),G1H2(7),m3h8x2(:,1),heltab2x16(:,:,11))
  call Hloop_A_Q(ntryL,G1H2(7),47,0,G2H2(7),n2h2(5))
  call Hloop_QA_V(ntryL,G1H16(2),wf8(:,3),G1H2(8),m3h8x2(:,2),heltab2x16(:,:,12))
  call Hloop_QA_V(ntryL,G1H4(4),ex3(:),G1H2(12),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_AQ_V(ntryL,G1H16(3),wf8(:,26),G1H2(13),m3h8x2(:,3),heltab2x16(:,:,13))
  call Hloop_VA_Q(ntryL,G1H16(4),ex3(:),G1H8(11),m3h2x8(:,4),heltab2x16(:,:,14))
  call Hloop_A_Q(ntryL,G1H8(11),44,0,G2H8(1),n2h8(5))
  call Hloop_AQ_V(ntryL,G1H16(5),wf8(:,22),G1H2(14),m3h8x2(:,4),heltab2x16(:,:,15))
  call Hloop_AW_Q(ntryL,G1H8(5),wf4(:,3),G1H2(18),m3h4x2(:,5),heltab2x8(:,:,6))
  call Hloop_A_Q(ntryL,G1H2(18),47,0,G2H2(8),n2h2(6))
call HGT_raise_alpha_OLR(G1H8(6),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(6),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(6),ex5(:),G1H4(2),m3h2x4(:,2),heltab2x8(:,:,7))
  call Hloop_AW_Q(ntryL,G1H8(2),wf4(:,3),G1H2(1),m3h4x2(:,6),heltab2x8(:,:,8))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(9),n2h2(7))
  call Hloop_AW_Q(ntryL,G1H8(3),wf4(:,3),G1H2(7),m3h4x2(:,7),heltab2x8(:,:,9))
  call Hloop_A_Q(ntryL,G1H2(7),47,0,G2H2(10),n2h2(8))
  call Hloop_AW_Q(ntryL,G1H8(4),wf4(:,3),G1H2(18),m3h4x2(:,8),heltab2x8(:,:,10))
  call Hloop_A_Q(ntryL,G1H2(18),55,0,G2H2(11),n2h2(9))
call HGT_raise_alpha_OLR(G1H8(7),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(7),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(7),ex4(:),G1H4(3),m3h2x4(:,3),heltab2x8(:,:,11))
  call Hloop_AW_Q(ntryL,G1H8(9),wf4(:,3),G1H2(1),m3h4x2(:,9),heltab2x8(:,:,12))
  call Hloop_A_Q(ntryL,G1H2(1),55,0,G2H2(12),n2h2(10))
  call Hloop_AW_Q(ntryL,G1H8(10),wf4(:,3),G1H2(7),m3h4x2(:,10),heltab2x8(:,:,13))
  call Hloop_A_Q(ntryL,G1H2(7),55,0,G2H2(13),n2h2(11))
  call ol_merge(ntryL,G2H2(7),[G2H2(5)])
  call ol_merge(ntryL,G2H2(2),[G1H2(3)])
  call ol_merge(ntryL,G1H2(12),[G1H2(4)])
  call ol_merge(ntryL,G1H2(8),[G1H2(5)])
  call ol_merge(ntryL,G1H2(2),[G1H2(10)])
  call ol_merge(ntryL,G1H2(14),[G1H2(11)])
  call ol_merge(ntryL,G1H2(6),[G1H2(16)])
  call ol_merge(ntryL,G1H2(13),[G1H2(17)])
call HGT_w2_OLR(G1H4(1),1,1,4)
call HGT_w2_invQ_OLR(G1H4(1),2,5,4)
  call Hloop_AW_Q(ntryL,G1H4(1),wf4(:,3),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(1),n2h1(10))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(7),ex5(:),G2tensor(3),m3h2x1(:,12),heltab2x2(:,:,12))
call Hotf_4pt_reduction(G2H2(2),RedSet_4(6),mass4set(:,1),  & 
G1H2(18),G1H2(1),G1H2(7),G1H2(3),G1H2(4),2)
call HG1shiftOLR(G1H2(1),16,2)
  call Hloop_VQ_A(ntryL,G1H2(12),ex5(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(6),n2h1(11))
  call Hloop_VQ_A(ntryL,G1H2(8),ex5(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(9),n2h1(12))
  call Hloop_VQ_A(ntryL,G1H2(9),ex4(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(12),n2h1(13))
  call Hloop_VQ_A(ntryL,G1H2(2),ex4(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(14))
  call Hloop_VQ_A(ntryL,G1H2(14),ex4(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(14),n2h1(15))
  call Hloop_VQ_A(ntryL,G1H2(15),ex5(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(16))
  call Hloop_VQ_A(ntryL,G1H2(6),ex5(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(16),n2h1(17))
  call Hloop_VQ_A(ntryL,G1H2(13),ex5(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(17),n2h1(18))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(1),ex5(:),G2tensor(18),m3h2x1(:,21),heltab2x2(:,:,21))
call Hotf_4pt_reduction(G2H2(3),RedSet_4(20),mass4set(:,1),  & 
G1H2(5),G1H2(10),G1H2(11),G1H2(16),G1H2(17),2)
call HG1shiftOLR(G1H2(10),4,2)
call Hotf_4pt_reduction(G2H2(4),RedSet_4(21),mass4set(:,1),  & 
G1H2(12),G1H2(8),G1H2(9),G1H2(2),G1H2(14),2)
call HG1shiftOLR(G1H2(8),8,2)
call Hotf_4pt_reduction(G2H2(6),RedSet_4(22),mass4set(:,1),  & 
G1H2(15),G1H2(6),G1H2(13),G1H2(19),G1H2(20),2)
call HG1shiftOLR(G1H2(6),4,2)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(1),wf8(:,22),G2tensor(19),m3h8x1(:,1),heltab2x8(:,:,14))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(8),ex5(:),G2tensor(20),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(10),ex5(:),G2tensor(21),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(11),ex4(:),G2tensor(22),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(13),ex4(:),G2tensor(23),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hloop_VQ_A(ntryL,G1H2(18),ex5(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(24),n2h1(19))
  call Hloop_VQ_A(ntryL,G1H2(1),ex5(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(25),n2h1(20))
  call Hloop_VQ_A(ntryL,G1H2(4),ex5(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(26),n2h1(21))
  call Hloop_VA_Q(ntryL,G1H2(5),ex3(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(27),n2h1(22))
  call Hloop_VA_Q(ntryL,G1H2(10),ex3(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(28),n2h1(23))
  call Hloop_VA_Q(ntryL,G1H2(17),ex3(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(29),n2h1(24))
  call Hloop_VQ_A(ntryL,G1H2(12),ex4(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(30),n2h1(25))
  call Hloop_VQ_A(ntryL,G1H2(8),ex4(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(31),n2h1(26))
  call Hloop_VQ_A(ntryL,G1H2(14),ex4(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(32),n2h1(27))
  call Hloop_VA_Q(ntryL,G1H2(15),ex3(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(33),n2h1(28))
  call Hloop_VA_Q(ntryL,G1H2(6),ex3(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(34),n2h1(29))
  call Hloop_VA_Q(ntryL,G1H2(20),ex3(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(35),n2h1(30))
  call ol_merge_tensors(G2tensor(19),[G2tensor(2),G1tensor(6)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(8)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(12)])
  call ol_merge_tensors(G2tensor(20),[G2tensor(7),G1tensor(14),G1tensor(3)])
  call ol_merge_tensors(G2tensor(11),[G2tensor(8),G1tensor(24),G1tensor(18)])
  call ol_merge_tensors(G2tensor(22),[G2tensor(10),G1tensor(20)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(2)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(9),[G2tensor(3),G1tensor(11),G1tensor(5)])
  call ol_merge_tensors(G2tensor(24),[G1tensor(9)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(10)])
  call ol_merge_tensors(G2tensor(12),[G1tensor(15)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(16)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(17)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(21)])
  call ol_merge_tensors(G2tensor(16),[G1tensor(22)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(23)])
call Hotf_4pt_reduction_last(G2tensor(19),RedSet_4(4),mass4set(:,1),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(6))
call G_TensorShift(G1tensor(7),19)
call Hotf_4pt_reduction_last(G2tensor(4),RedSet_4(23),mass4set(:,1),  & 
G1tensor(8),G1tensor(12),G1tensor(14),G1tensor(3),G1tensor(24))
call G_TensorShift(G1tensor(12),4)
call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(8),mass4set(:,1),  & 
G1tensor(18),G1tensor(20),G1tensor(2),G1tensor(4),G1tensor(11))
call G_TensorShift(G1tensor(20),20)
call Hotf_4pt_reduction_last(G2tensor(20),RedSet_4(1),mass4set(:,1),  & 
G1tensor(5),G1tensor(9),G1tensor(10),G1tensor(15),G1tensor(16))
call G_TensorShift(G1tensor(9),16)
call Hotf_4pt_reduction_last(G2tensor(11),RedSet_4(13),mass4set(:,1),  & 
G1tensor(17),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(25))
call G_TensorShift(G1tensor(21),24)
call Hotf_4pt_reduction_last(G2tensor(22),RedSet_4(19),mass4set(:,1),  & 
G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
call G_TensorShift(G1tensor(27),8)
call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(24),mass4set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35))
call G_TensorShift(G1tensor(32),3)
call Hotf_4pt_reduction_last(G2tensor(18),RedSet_4(2),mass4set(:,1),  & 
G1tensor(36),G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40))
call G_TensorShift(G1tensor(37),16)
call Hotf_4pt_reduction_last(G2tensor(9),RedSet_4(3),mass4set(:,1),  & 
G1tensor(41),G1tensor(42),G1tensor(43),G1tensor(44),G1tensor(45))
call G_TensorShift(G1tensor(42),16)
call Hotf_4pt_reduction_last(G2tensor(24),RedSet_4(6),mass4set(:,1),  & 
G1tensor(46),G1tensor(47),G1tensor(48),G1tensor(49),G1tensor(50))
call G_TensorShift(G1tensor(47),16)
call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(7),mass4set(:,1),  & 
G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54),G1tensor(55))
call G_TensorShift(G1tensor(52),16)
call Hotf_4pt_reduction_last(G2tensor(12),RedSet_4(10),mass4set(:,1),  & 
G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
call G_TensorShift(G1tensor(57),8)
call Hotf_4pt_reduction_last(G2tensor(13),RedSet_4(11),mass4set(:,1),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65))
call G_TensorShift(G1tensor(62),8)
call Hotf_4pt_reduction_last(G2tensor(14),RedSet_4(12),mass4set(:,1),  & 
G1tensor(66),G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70))
call G_TensorShift(G1tensor(67),8)
call Hotf_4pt_reduction_last(G2tensor(15),RedSet_4(15),mass4set(:,1),  & 
G1tensor(71),G1tensor(72),G1tensor(73),G1tensor(74),G1tensor(75))
call G_TensorShift(G1tensor(72),16)
call Hotf_4pt_reduction_last(G2tensor(16),RedSet_4(16),mass4set(:,1),  & 
G1tensor(76),G1tensor(77),G1tensor(78),G1tensor(79),G1tensor(80))
call G_TensorShift(G1tensor(77),16)
call Hotf_4pt_reduction_last(G2tensor(17),RedSet_4(17),mass4set(:,1),  & 
G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84),G1tensor(85))
call G_TensorShift(G1tensor(82),16)
call Hotf_4pt_reduction_last(G2tensor(27),RedSet_4(20),mass4set(:,1),  & 
G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
call G_TensorShift(G1tensor(87),4)
call Hotf_4pt_reduction_last(G2tensor(30),RedSet_4(21),mass4set(:,1),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95))
call G_TensorShift(G1tensor(92),8)
call Hotf_4pt_reduction_last(G2tensor(33),RedSet_4(22),mass4set(:,1),  & 
G1tensor(96),G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100))
call G_TensorShift(G1tensor(97),4)
call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(4),mass4set(:,1),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
call Hotf_4pt_reduction_last(G1tensor(8),RedSet_4(23),mass4set(:,1),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
call Hotf_4pt_reduction_last(G1tensor(18),RedSet_4(8),mass4set(:,1),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
call Hotf_4pt_reduction_last(G1tensor(5),RedSet_4(1),mass4set(:,1),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
call Hotf_4pt_reduction_last(G1tensor(17),RedSet_4(13),mass4set(:,1),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(19),mass4set(:,1),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(24),mass4set(:,1),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
call Hotf_4pt_reduction_last(G1tensor(36),RedSet_4(2),mass4set(:,1),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(3),mass4set(:,1),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
call Hotf_4pt_reduction_last(G1tensor(46),RedSet_4(6),mass4set(:,1),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(7),mass4set(:,1),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
call Hotf_4pt_reduction_last(G1tensor(56),RedSet_4(10),mass4set(:,1),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(11),mass4set(:,1),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(12),mass4set(:,1),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
call Hotf_4pt_reduction_last(G1tensor(71),RedSet_4(15),mass4set(:,1),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(16),mass4set(:,1),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
call Hotf_4pt_reduction_last(G1tensor(81),RedSet_4(17),mass4set(:,1),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
call Hotf_4pt_reduction_last(G1tensor(86),RedSet_4(20),mass4set(:,1),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(21),mass4set(:,1),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
call Hotf_4pt_reduction_last(G1tensor(96),RedSet_4(22),mass4set(:,1),  & 
G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100))
call ol_merge_tensors(T0sum(1),[G0tensor(1)])
call ol_merge_tensors(T0sum(2),[G0tensor(6)])
call ol_merge_tensors(T0sum(3),[G0tensor(11)])
call ol_merge_tensors(T0sum(4),[G0tensor(16)])
call ol_merge_tensors(T0sum(5),[G0tensor(21)])
call ol_merge_tensors(T0sum(6),[G0tensor(26)])
call ol_merge_tensors(T0sum(7),[G0tensor(31)])
call ol_merge_tensors(T0sum(8),[G0tensor(36)])
call ol_merge_tensors(T0sum(9),[G0tensor(41)])
call ol_merge_tensors(T0sum(10),[G0tensor(46)])
call ol_merge_tensors(T0sum(11),[G0tensor(51)])
call ol_merge_tensors(T0sum(12),[G0tensor(56)])
call ol_merge_tensors(T0sum(13),[G0tensor(61)])
call ol_merge_tensors(T0sum(14),[G0tensor(66)])
call ol_merge_tensors(T0sum(15),[G0tensor(71)])
call ol_merge_tensors(T0sum(16),[G0tensor(76)])
call ol_merge_tensors(T0sum(17),[G0tensor(81)])
call ol_merge_tensors(T0sum(18),[G0tensor(86)])
call ol_merge_tensors(T0sum(19),[G0tensor(91)])
call ol_merge_tensors(T0sum(20),[G0tensor(96)])
Gcoeff(:)%j = (c(5)*M(1,:)%j-c(6)*M(2,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[40,7,16],[0,0,0],3,2,wf4(:,2),wf8(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,7),heltab2x64(:,:,19))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(6),n2h16(11))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)+c(2)*M(2,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[40,7,16],[0,0,0],3,2,wf4(:,2),wf8(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,2),40,G1H16(1),m3h4x16(:,8),heltab2x64(:,:,20))
Gcoeff(:)%j = (c(5)*M(1,:)%j-c(6)*M(2,:)%j) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[40,4,19],[0,0,0],3,2,wf4(:,2),wf8(:,22))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,9),heltab2x64(:,:,21))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(2),n2h16(12))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)+c(2)*M(2,:)%j) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[40,4,19],[0,0,0],3,2,wf4(:,2),wf8(:,22))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,2),40,G1H16(3),m3h4x16(:,10),heltab2x64(:,:,22))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)+c(12)*M(2,:)%j) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[44,3,16],[0,0,0],3,2,wf8(:,6),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,6),G0H8(1),m3h8x8(:,1),heltab2x64(:,:,23))
  call Hloop_A_Q(ntryL,G0H8(1),44,0,G1H8(11),n2h8(8))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)+c(12)*M(2,:)%j) * den(19)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[56,3,4],[0,0,0],3,2,wf8(:,24),wf4(:,3))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,24),G0H8(1),m3h8x8(:,2),heltab2x64(:,:,24))
  call Hloop_Q_A(ntryL,G0H8(1),56,0,G1H8(5),n2h8(9))
Gcoeff(:)%j = (c(6)*M(1,:)%j-c(5)*M(2,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[48,7,8],[0,0,0],3,2,wf4(:,4),wf8(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,11),heltab2x64(:,:,25))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(4),n2h16(13))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(2,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[48,7,8],[0,0,0],3,2,wf4(:,4),wf8(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),48,G1H16(5),m3h4x16(:,12),heltab2x64(:,:,26))
Gcoeff(:)%j = (c(6)*M(1,:)%j-c(5)*M(2,:)%j) * den(22)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[48,4,11],[0,0,0],3,2,wf4(:,4),wf8(:,26))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,13),heltab2x64(:,:,27))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(7),n2h16(14))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(2,:)%j) * den(22)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[48,4,11],[0,0,0],3,2,wf4(:,4),wf8(:,26))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),48,G1H16(8),m3h4x16(:,14),heltab2x64(:,:,28))
Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(8)*M(2,:)%j) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[52,3,8],[0,0,0],3,2,wf8(:,10),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,10),G0H8(1),m3h8x8(:,3),heltab2x64(:,:,29))
  call Hloop_A_Q(ntryL,G0H8(1),52,0,G1H8(6),n2h8(10))
Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(8)*M(2,:)%j) * den(24)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[56,3,4],[0,0,0],3,2,wf8(:,27),wf4(:,3))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,27),G0H8(1),m3h8x8(:,4),heltab2x64(:,:,30))
  call Hloop_Q_A(ntryL,G0H8(1),56,0,G1H8(2),n2h8(11))
Gcoeff(:)%j = (c(6)*M(1,:)%j-c(5)*M(2,:)%j) * den(36)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[32,15,16],[0,0,0],3,1,wf16(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,13),heltab2x64(:,:,31))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(1),n2h32(4))
Gcoeff(:)%j = (c(2)*M(1,:)%j-c(1)*M(2,:)%j) * den(36)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[32,15,16],[0,0,0],3,1,wf16(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,14),heltab2x64(:,:,32))
Gcoeff(:)%j = (c(5)*M(1,:)%j-c(6)*M(2,:)%j) * den(38)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[32,8,23],[0,0,0],3,1,wf16(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,15),heltab2x64(:,:,33))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)+c(2)*M(2,:)%j) * den(38)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(34),h0tab(:,34),[32,8,23],[0,0,0],3,1,wf16(:,2))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,16),heltab2x64(:,:,34))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(2),n2h32(5))
Gcoeff(:)%j = (c(6)*M(1,:)%j-c(5)*M(2,:)%j) * den(39)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(35),h0tab(:,35),[32,15,16],[0,0,0],3,1,wf16(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,17),heltab2x64(:,:,35))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(3),n2h32(6))
Gcoeff(:)%j = (c(2)*M(1,:)%j-c(1)*M(2,:)%j) * den(39)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(36),h0tab(:,36),[32,15,16],[0,0,0],3,1,wf16(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,18),heltab2x64(:,:,36))
Gcoeff(:)%j = (c(5)*M(1,:)%j-c(6)*M(2,:)%j) * den(40)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(37),h0tab(:,37),[32,8,23],[0,0,0],3,1,wf16(:,4))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,19),heltab2x64(:,:,37))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)+c(2)*M(2,:)%j) * den(40)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(38),h0tab(:,38),[32,8,23],[0,0,0],3,1,wf16(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,20),heltab2x64(:,:,38))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(4),n2h32(7))
  call ol_merge(ntryL,G1H8(11),[G1H8(1)])
  call ol_merge(ntryL,G1H8(6),[G1H8(8)])
  call ol_merge(ntryL,G1H8(2),[G1H8(5)])
  call Hloop_AW_Q(ntryL,G1H8(11),wf4(:,3),G1H2(18),m3h4x2(:,11),heltab2x8(:,:,15))
  call Hloop_A_Q(ntryL,G1H2(18),47,0,G2H2(5),n2h2(12))
  call Hloop_AW_Q(ntryL,G1H8(6),wf4(:,3),G1H2(1),m3h4x2(:,12),heltab2x8(:,:,16))
  call Hloop_A_Q(ntryL,G1H2(1),55,0,G2H2(7),n2h2(13))
  call Hloop_QA_V(ntryL,G1H16(6),wf8(:,3),G1H2(4),m3h8x2(:,5),heltab2x16(:,:,16))
  call Hloop_VA_Q(ntryL,G1H16(1),wf8(:,3),G1H2(5),m3h8x2(:,6),heltab2x16(:,:,17))
  call Hloop_A_Q(ntryL,G1H2(5),47,0,G2H2(2),n2h2(14))
  call Hloop_QA_V(ntryL,G1H16(2),ex3(:),G1H8(3),m3h2x8(:,5),heltab2x16(:,:,18))
  call Hloop_VA_Q(ntryL,G1H16(3),ex3(:),G1H8(4),m3h2x8(:,6),heltab2x16(:,:,19))
  call Hloop_A_Q(ntryL,G1H8(4),44,0,G2H8(2),n2h8(12))
  call Hloop_QW_A(ntryL,G1H8(2),wf4(:,3),G1H2(10),m3h4x2(:,13),heltab2x8(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(10),59,0,G2H2(1),n2h2(15))
  call Hloop_QA_V(ntryL,G1H16(4),wf8(:,3),G1H2(17),m3h8x2(:,7),heltab2x16(:,:,20))
  call Hloop_VA_Q(ntryL,G1H16(5),wf8(:,3),G1H2(12),m3h8x2(:,8),heltab2x16(:,:,21))
  call Hloop_A_Q(ntryL,G1H2(12),55,0,G2H2(3),n2h2(16))
  call Hloop_QA_V(ntryL,G1H16(7),ex3(:),G1H8(7),m3h2x8(:,7),heltab2x16(:,:,22))
  call Hloop_VA_Q(ntryL,G1H16(8),ex3(:),G1H8(9),m3h2x8(:,8),heltab2x16(:,:,23))
  call Hloop_A_Q(ntryL,G1H8(9),52,0,G2H8(1),n2h8(13))
  call Hloop_AV_Q(ntryL,G1H32(1),wf16(:,1),G1H2(8),m3h16x2(:,1),heltab2x32(:,:,13))
  call Hloop_A_Q(ntryL,G1H2(8),47,0,G2H2(4),n2h2(17))
  call Hloop_UV_W(ntryL,G0H32(2),32,wf16(:,1),15,G1H2(14),m3h16x2(:,2),heltab2x32(:,:,14))
  call Hloop_VQ_A(ntryL,G0H32(3),ex4(:),G0H16(1),m3h2x16(:,10),heltab2x32(:,:,15))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(6),n2h16(15))
  call Hloop_AQ_V(ntryL,G1H32(2),ex4(:),G1H16(1),m3h2x16(:,11),heltab2x32(:,:,16))
  call Hloop_AV_Q(ntryL,G1H32(3),wf16(:,3),G1H2(15),m3h16x2(:,3),heltab2x32(:,:,17))
  call Hloop_A_Q(ntryL,G1H2(15),47,0,G2H2(6),n2h2(18))
  call Hloop_UV_W(ntryL,G0H32(6),32,wf16(:,3),15,G1H2(6),m3h16x2(:,4),heltab2x32(:,:,18))
  call Hloop_VQ_A(ntryL,G0H32(1),ex4(:),G0H16(1),m3h2x16(:,12),heltab2x32(:,:,19))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(2),n2h16(16))
  call Hloop_AQ_V(ntryL,G1H32(4),ex4(:),G1H16(3),m3h2x16(:,13),heltab2x32(:,:,20))
  call ol_merge(ntryL,G1H4(3),[G1H4(2)])
  call ol_merge(ntryL,G2H2(2),[G2H2(9)])
  call ol_merge(ntryL,G2H2(3),[G2H2(12)])
  call ol_merge(ntryL,G1H2(4),[G1H2(3)])
  call ol_merge(ntryL,G1H2(17),[G1H2(2)])
  call ol_merge(ntryL,G2H2(6),[G2H2(4)])
  call ol_merge(ntryL,G1H2(6),[G1H2(14)])
call HGT_w2_OLR(G1H4(3),1,1,4)
call HGT_w2_invQ_OLR(G1H4(3),2,5,4)
  call Hloop_AW_Q(ntryL,G1H4(3),wf4(:,3),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(2),n2h1(31))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(2),ex5(:),G2tensor(7),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(3),ex4(:),G2tensor(8),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hloop_VQ_A(ntryL,G1H2(7),ex5(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(10),n2h1(32))
  call Hloop_VQ_A(ntryL,G1H2(4),ex5(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(3),n2h1(33))
  call Hloop_VA_Q(ntryL,G1H2(11),ex3(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(19),n2h1(34))
  call Hloop_VA_Q(ntryL,G1H2(16),ex3(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(4),n2h1(35))
  call Hloop_VQ_A(ntryL,G1H2(9),ex4(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(5),n2h1(36))
  call Hloop_VQ_A(ntryL,G1H2(17),ex4(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(20),n2h1(37))
  call Hloop_VA_Q(ntryL,G1H2(13),ex3(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(38))
  call Hloop_VA_Q(ntryL,G1H2(19),ex3(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(22),n2h1(39))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(5),ex5(:),G2tensor(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(7),ex4(:),G2tensor(18),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hloop_VQ_A(ntryL,G1H8(3),wf8(:,22),G1H1(1),m3h8x1(:,2),heltab2x8(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(9),n2h1(40))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(2),wf8(:,22),G2tensor(24),m3h8x1(:,3),heltab2x8(:,:,19))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(1),ex3(:),G2tensor(6),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hloop_VQ_A(ntryL,G1H8(7),wf8(:,26),G1H1(1),m3h8x1(:,4),heltab2x8(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(12),n2h1(41))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(1),wf8(:,26),G2tensor(13),m3h8x1(:,5),heltab2x8(:,:,21))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(6),ex5(:),G2tensor(14),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hloop_VQ_A(ntryL,G1H2(6),ex5(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(42))
  call Hloop_QV_A(ntryL,G1H16(6),wf16(:,2),G1H1(1),m3h16x1(:,1),heltab2x16(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(16),n2h1(43))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H16(1),40,wf16(:,2),23,G2tensor(17),m3h16x1(:,2),heltab2x16(:,:,25))
  call Hloop_QV_A(ntryL,G1H16(2),wf16(:,4),G1H1(1),m3h16x1(:,3),heltab2x16(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(27),n2h1(44))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H16(3),40,wf16(:,4),23,G2tensor(30),m3h16x1(:,4),heltab2x16(:,:,27))
  call ol_merge_tensors(G2tensor(24),[G2tensor(9),G2tensor(21),G1tensor(67),G1tensor(16),G1tensor(13),G0tensor(67),G0tensor(20) &
    ,G0tensor(3)])
  call ol_merge_tensors(G2tensor(13),[G2tensor(12),G2tensor(23),G1tensor(82),G1tensor(30),G0tensor(82),G0tensor(30)])
  call ol_merge_tensors(G2tensor(6),[G2tensor(31),G2tensor(25),G1tensor(92),G1tensor(47),G1tensor(14),G0tensor(92),G0tensor(47) &
    ,G0tensor(8)])
  call ol_merge_tensors(G2tensor(29),[G2tensor(26),G1tensor(90),G1tensor(50),G1tensor(2),G0tensor(90),G0tensor(50),G0tensor(13)])
  call ol_merge_tensors(G2tensor(1),[G2tensor(28),G1tensor(87),G1tensor(57),G1tensor(38),G1tensor(10),G0tensor(87),G0tensor(57) &
    ,G0tensor(38),G0tensor(18)])
  call ol_merge_tensors(G2tensor(35),[G2tensor(32),G1tensor(100),G1tensor(95),G0tensor(100),G0tensor(95)])
  call ol_merge_tensors(G2tensor(18),[G2tensor(34),G1tensor(97),G1tensor(72),G1tensor(28),G0tensor(97),G0tensor(72) &
    ,G0tensor(28)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(98),G1tensor(32),G1tensor(7),G0tensor(98),G0tensor(32),G0tensor(2)])
  call ol_merge_tensors(G1tensor(40),[G1tensor(19),G0tensor(40),G0tensor(4)])
  call ol_merge_tensors(G2tensor(30),[G2tensor(27),G2tensor(17),G2tensor(16),G1tensor(45),G1tensor(11),G1tensor(6),G0tensor(45) &
    ,G0tensor(15),G0tensor(5)])
  call ol_merge_tensors(G1tensor(20),[G1tensor(12),G0tensor(12),G0tensor(7)])
  call ol_merge_tensors(G2tensor(22),[G1tensor(99),G1tensor(52),G1tensor(3),G0tensor(99),G0tensor(52),G0tensor(9)])
  call ol_merge_tensors(G1tensor(42),[G1tensor(35),G1tensor(24),G0tensor(42),G0tensor(35),G0tensor(10)])
  call ol_merge_tensors(G1tensor(55),[G1tensor(4),G0tensor(55),G0tensor(14)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(33),G1tensor(27),G1tensor(21),G1tensor(9),G0tensor(33),G0tensor(27),G0tensor(22) &
    ,G0tensor(17)])
  call ol_merge_tensors(G2tensor(3),[G2tensor(7),G1tensor(62),G1tensor(49),G1tensor(43),G1tensor(15),G0tensor(62),G0tensor(49) &
    ,G0tensor(43),G0tensor(19)])
  call ol_merge_tensors(G1tensor(75),[G1tensor(60),G1tensor(22),G0tensor(75),G0tensor(60),G0tensor(23)])
  call ol_merge_tensors(G1tensor(80),[G1tensor(65),G1tensor(23),G0tensor(80),G0tensor(65),G0tensor(24)])
  call ol_merge_tensors(G1tensor(85),[G1tensor(70),G1tensor(25),G0tensor(85),G0tensor(70),G0tensor(25)])
  call ol_merge_tensors(G2tensor(20),[G2tensor(8),G1tensor(94),G1tensor(77),G1tensor(29),G0tensor(94),G0tensor(77),G0tensor(29)])
  call ol_merge_tensors(G1tensor(37),[G1tensor(34),G0tensor(37),G0tensor(34)])
  call ol_merge_tensors(G2tensor(15),[G2tensor(14),G1tensor(84),G1tensor(79),G1tensor(54),G1tensor(44),G1tensor(39),G0tensor(84) &
    ,G0tensor(79),G0tensor(54),G0tensor(44),G0tensor(39)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(53),G1tensor(48),G0tensor(53),G0tensor(48)])
  call ol_merge_tensors(G1tensor(63),[G1tensor(58),G0tensor(63),G0tensor(58)])
  call ol_merge_tensors(G1tensor(68),[G1tensor(59),G0tensor(68),G0tensor(59)])
  call ol_merge_tensors(G1tensor(69),[G1tensor(64),G0tensor(69),G0tensor(64)])
  call ol_merge_tensors(G1tensor(78),[G1tensor(73),G0tensor(78),G0tensor(73)])
  call ol_merge_tensors(G1tensor(83),[G1tensor(74),G0tensor(83),G0tensor(74)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(88),G0tensor(88)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(89),G0tensor(89)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(93),G0tensor(93)])
call TI_triangle_red(G2tensor(24),RedBasis(4),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1)
call TI_triangle_red(G2tensor(13),RedBasis(28),mass3set(:,1),G0tensor(21),G0tensor(26),G0tensor(31),G0tensor(36),M2L1R1)
call TI_triangle_red(G2tensor(6),RedBasis(38),mass3set(:,1),G0tensor(41),G0tensor(46),G0tensor(51),G0tensor(56),M2L1R1)
call TI_triangle_red(G2tensor(29),RedBasis(8),mass3set(:,1),G0tensor(61),G0tensor(66),G0tensor(71),G0tensor(76),M2L1R1)
call TI_triangle_red(G2tensor(1),RedBasis(6),mass3set(:,1),G0tensor(81),G0tensor(86),G0tensor(91),G0tensor(96),M2L1R1)
call TI_triangle_red(G2tensor(35),RedBasis(33),mass3set(:,1),G0tensor(67),G0tensor(20),G0tensor(3),G0tensor(82),M2L1R1)
call TI_triangle_red(G2tensor(18),RedBasis(30),mass3set(:,1),G0tensor(30),G0tensor(92),G0tensor(47),G0tensor(8),M2L1R1)
call TI_triangle_red(G2tensor(11),RedBasis(36),mass3set(:,1),G0tensor(90),G0tensor(50),G0tensor(13),G0tensor(87),M2L1R1)
call TI_triangle_red(G2tensor(30),RedBasis(1),mass3set(:,1),G0tensor(57),G0tensor(38),G0tensor(18),G0tensor(100),M2L1R1)
call TI_triangle_red(G2tensor(22),RedBasis(35),mass3set(:,1),G0tensor(95),G0tensor(97),G0tensor(72),G0tensor(28),M2L1R1)
call TI_triangle_red(G2tensor(2),RedBasis(40),mass3set(:,1),G0tensor(98),G0tensor(32),G0tensor(2),G0tensor(40),M2L1R1)
call TI_triangle_red(G2tensor(3),RedBasis(5),mass3set(:,1),G0tensor(4),G0tensor(45),G0tensor(15),G0tensor(5),M2L1R1)
call TI_triangle_red(G2tensor(20),RedBasis(29),mass3set(:,1),G0tensor(12),G0tensor(7),G0tensor(99),G0tensor(52),M2L1R1)
call TI_triangle_red(G2tensor(15),RedBasis(3),mass3set(:,1),G0tensor(9),G0tensor(42),G0tensor(35),G0tensor(10),M2L1R1)
call TI_triangle_red(G2tensor(10),RedBasis(9),mass3set(:,1),G0tensor(55),G0tensor(14),G0tensor(33),G0tensor(27),M2L1R1)
call TI_triangle_red(G2tensor(19),RedBasis(32),mass3set(:,1),G0tensor(22),G0tensor(17),G0tensor(62),G0tensor(49),M2L1R1)
call TI_triangle_red(G2tensor(4),RedBasis(31),mass3set(:,1),G0tensor(43),G0tensor(19),G0tensor(75),G0tensor(60),M2L1R1)
call TI_triangle_red(G2tensor(5),RedBasis(34),mass3set(:,1),G0tensor(23),G0tensor(80),G0tensor(65),G0tensor(24),M2L1R1)
call TI_triangle_red(G1tensor(40),RedBasis(2),mass3set(:,1),G0tensor(85),G0tensor(70),G0tensor(25),G0tensor(94),M2L1R1)
call TI_triangle_red(G1tensor(20),RedBasis(41),mass3set(:,1),G0tensor(77),G0tensor(29),G0tensor(37),G0tensor(34),M2L1R1)
call TI_triangle_red(G1tensor(42),RedBasis(37),mass3set(:,1),G0tensor(84),G0tensor(79),G0tensor(54),G0tensor(44),M2L1R1)
call TI_triangle_red(G1tensor(55),RedBasis(7),mass3set(:,1),G0tensor(39),G0tensor(53),G0tensor(48),G0tensor(63),M2L1R1)
call TI_triangle_red(G1tensor(75),RedBasis(13),mass3set(:,1),G0tensor(58),G0tensor(68),G0tensor(59),G0tensor(69),M2L1R1)
call TI_triangle_red(G1tensor(80),RedBasis(11),mass3set(:,1),G0tensor(64),G0tensor(78),G0tensor(73),G0tensor(83),M2L1R1)
call TI_triangle_red(G1tensor(85),RedBasis(10),mass3set(:,1),G0tensor(74),G0tensor(88),G0tensor(89),G0tensor(93),M2L1R1)
call TI_triangle_red(G1tensor(37),RedBasis(39),mass3set(:,1),G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104),M2L1R1)
call TI_triangle_red(G1tensor(63),RedBasis(15),mass3set(:,1),G0tensor(105),G0tensor(106),G0tensor(107),G0tensor(108),M2L1R1)
call TI_triangle_red(G1tensor(68),RedBasis(14),mass3set(:,1),G0tensor(109),G0tensor(110),G0tensor(111),G0tensor(112),M2L1R1)
call TI_triangle_red(G1tensor(69),RedBasis(12),mass3set(:,1),G0tensor(113),G0tensor(114),G0tensor(115),G0tensor(116),M2L1R1)
call TI_triangle_red(G1tensor(78),RedBasis(17),mass3set(:,1),G0tensor(117),G0tensor(118),G0tensor(119),G0tensor(120),M2L1R1)
call TI_triangle_red(G1tensor(83),RedBasis(16),mass3set(:,1),G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124),M2L1R1)
call ol_merge_tensors(T0sum(21),[G0tensor(1)])
call ol_merge_tensors(T0sum(22),[G0tensor(21)])
call ol_merge_tensors(T0sum(23),[G0tensor(41)])
call ol_merge_tensors(T0sum(24),[G0tensor(61)])
call ol_merge_tensors(T0sum(25),[G0tensor(81)])
call ol_merge_tensors(T0sum(26),[G0tensor(67)])
call ol_merge_tensors(T0sum(27),[G0tensor(30)])
call ol_merge_tensors(T0sum(28),[G0tensor(90)])
call ol_merge_tensors(T0sum(29),[G0tensor(85)])
call ol_merge_tensors(T0sum(30),[G0tensor(57)])
call ol_merge_tensors(T0sum(31),[G0tensor(77)])
call ol_merge_tensors(T0sum(32),[G0tensor(95)])
call ol_merge_tensors(T0sum(33),[G0tensor(84)])
call ol_merge_tensors(T0sum(34),[G0tensor(39)])
call ol_merge_tensors(T0sum(35),[G0tensor(98)])
call ol_merge_tensors(T0sum(36),[G0tensor(4)])
call ol_merge_tensors(T0sum(37),[G0tensor(58)])
call ol_merge_tensors(T0sum(38),[G0tensor(64)])
call ol_merge_tensors(T0sum(39),[G0tensor(74)])
call ol_merge_tensors(T0sum(40),[G0tensor(12)])
call ol_merge_tensors(T0sum(41),[G0tensor(101)])
call ol_merge_tensors(T0sum(42),[G0tensor(9)])
call ol_merge_tensors(T0sum(43),[G0tensor(55)])
call ol_merge_tensors(T0sum(44),[G0tensor(105)])
call ol_merge_tensors(T0sum(45),[G0tensor(109)])
call ol_merge_tensors(T0sum(46),[G0tensor(113)])
call ol_merge_tensors(T0sum(47),[G0tensor(117)])
call ol_merge_tensors(T0sum(48),[G0tensor(121)])
call ol_merge_tensors(T0sum(49),[G0tensor(22)])
call ol_merge_tensors(T0sum(50),[G0tensor(43)])
call ol_merge_tensors(T0sum(51),[G0tensor(23)])
Gcoeff(:)%j = (c(16)*M(1,:)%j-c(17)*M(2,:)%j) * den(43)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(39),h0tab(:,39),[40,23],[0,0],2,2,wf4(:,2),wf16(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,15),heltab2x64(:,:,39))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(4),n2h16(17))
Gcoeff(:)%j = (c(14)*M(1,:)%j-c(15)*M(2,:)%j) * den(43)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(40),h0tab(:,40),[40,23],[nMT,nMT],2,2,wf4(:,2),wf16(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,16),heltab2x64(:,:,40))
  call Hloop_Q_A(ntryL,G0H16(1),40,nMT,G1H16(5),n2h16(18))
Gcoeff(:)%j = (c(16)*M(1,:)%j-c(17)*M(2,:)%j) * den(43)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(41),h0tab(:,41),[40,23],[0,0],2,2,wf4(:,2),wf16(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,17),heltab2x64(:,:,41))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(7),n2h16(19))
Gcoeff(:)%j = (c(14)*M(1,:)%j-c(15)*M(2,:)%j) * den(43)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(42),h0tab(:,42),[40,23],[nMB,nMB],2,2,wf4(:,2),wf16(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,18),heltab2x64(:,:,42))
  call Hloop_Q_A(ntryL,G0H16(1),40,nMB,G1H16(8),n2h16(20))
Gcoeff(:)%j = (c(10)*M(1,:)%j-c(13)*M(2,:)%j) * den(43)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(43),h0tab(:,43),[40,23],[0,0],2,2,wf4(:,2),wf16(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,2),40,G1H16(6),m3h4x16(:,19),heltab2x64(:,:,43))
Gcoeff(:)%j = (-(c(3)*M(1,:)%j)+c(4)*M(2,:)%j) * den(43)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(44),h0tab(:,44),[40,23],[0,0],2,2,wf4(:,2),wf16(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,2),40,G1H16(1),m3h4x16(:,20),heltab2x64(:,:,44))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)+c(12)*M(2,:)%j) * den(27)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(45),h0tab(:,45),[56,7],[0,0],2,2,wf8(:,24),wf8(:,3))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,24),G0H8(1),m3h8x8(:,5),heltab2x64(:,:,45))
  call Hloop_Q_A(ntryL,G0H8(1),56,0,G1H8(10),n2h8(14))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)+c(12)*M(2,:)%j) * den(28)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(46),h0tab(:,46),[44,19],[0,0],2,2,wf8(:,6),wf8(:,22))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,6),G0H8(1),m3h8x8(:,6),heltab2x64(:,:,46))
Gcoeff(:)%j = (c(16)*M(1,:)%j-c(17)*M(2,:)%j) * den(44)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(47),h0tab(:,47),[40,23],[0,0],2,2,wf4(:,2),wf16(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,21),heltab2x64(:,:,47))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(2),n2h16(21))
Gcoeff(:)%j = (c(14)*M(1,:)%j-c(15)*M(2,:)%j) * den(44)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(48),h0tab(:,48),[40,23],[nMT,nMT],2,2,wf4(:,2),wf16(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,22),heltab2x64(:,:,48))
  call Hloop_Q_A(ntryL,G0H16(1),40,nMT,G1H16(3),n2h16(22))
Gcoeff(:)%j = (c(16)*M(1,:)%j-c(17)*M(2,:)%j) * den(44)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(49),h0tab(:,49),[40,23],[0,0],2,2,wf4(:,2),wf16(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,23),heltab2x64(:,:,49))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(9),n2h16(23))
Gcoeff(:)%j = (c(14)*M(1,:)%j-c(15)*M(2,:)%j) * den(44)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(50),h0tab(:,50),[40,23],[nMB,nMB],2,2,wf4(:,2),wf16(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,2),G0H16(1),m3h4x16(:,24),heltab2x64(:,:,50))
  call Hloop_Q_A(ntryL,G0H16(1),40,nMB,G1H16(10),n2h16(24))
Gcoeff(:)%j = (c(10)*M(1,:)%j-c(13)*M(2,:)%j) * den(44)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(51),h0tab(:,51),[40,23],[0,0],2,2,wf4(:,2),wf16(:,4))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,2),40,G1H16(11),m3h4x16(:,25),heltab2x64(:,:,51))
Gcoeff(:)%j = (-(c(3)*M(1,:)%j)+c(4)*M(2,:)%j) * den(44)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(52),h0tab(:,52),[40,23],[0,0],2,2,wf4(:,2),wf16(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,2),40,G1H16(12),m3h4x16(:,26),heltab2x64(:,:,52))
Gcoeff(:)%j = (c(17)*M(1,:)%j-c(16)*M(2,:)%j) * den(45)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(53),h0tab(:,53),[48,15],[0,0],2,2,wf4(:,4),wf16(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,27),heltab2x64(:,:,53))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(13),n2h16(25))
Gcoeff(:)%j = (c(15)*M(1,:)%j-c(14)*M(2,:)%j) * den(45)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(54),h0tab(:,54),[48,15],[nMT,nMT],2,2,wf4(:,4),wf16(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,28),heltab2x64(:,:,54))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMT,G1H16(14),n2h16(26))
Gcoeff(:)%j = (c(17)*M(1,:)%j-c(16)*M(2,:)%j) * den(45)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(55),h0tab(:,55),[48,15],[0,0],2,2,wf4(:,4),wf16(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,29),heltab2x64(:,:,55))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(15),n2h16(27))
Gcoeff(:)%j = (c(15)*M(1,:)%j-c(14)*M(2,:)%j) * den(45)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(56),h0tab(:,56),[48,15],[nMB,nMB],2,2,wf4(:,4),wf16(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,30),heltab2x64(:,:,56))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMB,G1H16(16),n2h16(28))
Gcoeff(:)%j = (c(13)*M(1,:)%j-c(10)*M(2,:)%j) * den(45)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(57),h0tab(:,57),[48,15],[0,0],2,2,wf4(:,4),wf16(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,4),48,G1H16(17),m3h4x16(:,31),heltab2x64(:,:,57))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(3)*M(2,:)%j) * den(45)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(58),h0tab(:,58),[48,15],[0,0],2,2,wf4(:,4),wf16(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),48,G1H16(18),m3h4x16(:,32),heltab2x64(:,:,58))
Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(8)*M(2,:)%j) * den(30)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(59),h0tab(:,59),[56,7],[0,0],2,2,wf8(:,27),wf8(:,3))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,27),G0H8(2),m3h8x8(:,7),heltab2x64(:,:,59))
  call Hloop_Q_A(ntryL,G0H8(2),56,0,G1H8(1),n2h8(15))
Gcoeff(:)%j = (c(17)*M(1,:)%j-c(16)*M(2,:)%j) * den(46)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(60),h0tab(:,60),[48,15],[0,0],2,2,wf4(:,4),wf16(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,33),heltab2x64(:,:,60))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(19),n2h16(29))
Gcoeff(:)%j = (c(15)*M(1,:)%j-c(14)*M(2,:)%j) * den(46)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(61),h0tab(:,61),[48,15],[nMT,nMT],2,2,wf4(:,4),wf16(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,34),heltab2x64(:,:,61))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMT,G1H16(20),n2h16(30))
Gcoeff(:)%j = (c(17)*M(1,:)%j-c(16)*M(2,:)%j) * den(46)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(62),h0tab(:,62),[48,15],[0,0],2,2,wf4(:,4),wf16(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,35),heltab2x64(:,:,62))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(21),n2h16(31))
Gcoeff(:)%j = (c(15)*M(1,:)%j-c(14)*M(2,:)%j) * den(46)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(63),h0tab(:,63),[48,15],[nMB,nMB],2,2,wf4(:,4),wf16(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,36),heltab2x64(:,:,63))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMB,G1H16(22),n2h16(32))
Gcoeff(:)%j = (c(13)*M(1,:)%j-c(10)*M(2,:)%j) * den(46)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(64),h0tab(:,64),[48,15],[0,0],2,2,wf4(:,4),wf16(:,3))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,4),48,G1H16(23),m3h4x16(:,37),heltab2x64(:,:,64))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(3)*M(2,:)%j) * den(46)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(65),h0tab(:,65),[48,15],[0,0],2,2,wf4(:,4),wf16(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),48,G1H16(24),m3h4x16(:,38),heltab2x64(:,:,65))
Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(8)*M(2,:)%j) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(66),h0tab(:,66),[52,11],[0,0],2,2,wf8(:,10),wf8(:,26))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,10),G0H8(2),m3h8x8(:,8),heltab2x64(:,:,66))
  call ol_merge(ntryL,G1H16(7),[G1H16(4)])
  call ol_merge(ntryL,G1H8(1),[G1H8(10)])
  call ol_merge(ntryL,G1H16(9),[G1H16(2)])
  call ol_merge(ntryL,G1H16(15),[G1H16(13)])
  call ol_merge(ntryL,G1H16(21),[G1H16(19)])
  call Hloop_QV_A(ntryL,G1H16(7),wf16(:,2),G1H1(1),m3h16x1(:,5),heltab2x16(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(33),n2h1(45))
  call Hloop_QV_A(ntryL,G1H16(5),wf16(:,2),G1H1(1),m3h16x1(:,6),heltab2x16(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(9),n2h1(46))
  call Hloop_QV_A(ntryL,G1H16(8),wf16(:,2),G1H1(1),m3h16x1(:,7),heltab2x16(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(21),n2h1(47))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H16(6),40,wf16(:,2),23,G2tensor(12),m3h16x1(:,8),heltab2x16(:,:,31))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H16(1),40,wf16(:,2),23,G2tensor(23),m3h16x1(:,9),heltab2x16(:,:,32))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H8(1),wf8(:,3),G1tensor(1),m3h8x1(:,6),heltab2x8(:,:,22))
  call Hloop_VQ_A(ntryL,G0H8(1),wf8(:,22),G0H1(1),m3h8x1(:,7),heltab2x8(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,0,G1tensor(8),n2h1(48))
  call Hloop_QV_A(ntryL,G1H16(9),wf16(:,4),G1H1(1),m3h16x1(:,10),heltab2x16(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(31),n2h1(49))
  call Hloop_QV_A(ntryL,G1H16(3),wf16(:,4),G1H1(1),m3h16x1(:,11),heltab2x16(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(25),n2h1(50))
  call Hloop_QV_A(ntryL,G1H16(10),wf16(:,4),G1H1(1),m3h16x1(:,12),heltab2x16(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(26),n2h1(51))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H16(11),40,wf16(:,4),23,G2tensor(28),m3h16x1(:,13),heltab2x16(:,:,36))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H16(12),40,wf16(:,4),23,G2tensor(32),m3h16x1(:,14),heltab2x16(:,:,37))
  call Hloop_QV_A(ntryL,G1H16(15),wf16(:,1),G1H1(1),m3h16x1(:,15),heltab2x16(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(34),n2h1(52))
  call Hloop_QV_A(ntryL,G1H16(14),wf16(:,1),G1H1(1),m3h16x1(:,16),heltab2x16(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(27),n2h1(53))
  call Hloop_QV_A(ntryL,G1H16(16),wf16(:,1),G1H1(1),m3h16x1(:,17),heltab2x16(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(17),n2h1(54))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H16(17),48,wf16(:,1),15,G2tensor(16),m3h16x1(:,18),heltab2x16(:,:,41))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H16(18),48,wf16(:,1),15,G2tensor(7),m3h16x1(:,19),heltab2x16(:,:,42))
  call Hloop_QV_A(ntryL,G1H16(21),wf16(:,3),G1H1(1),m3h16x1(:,20),heltab2x16(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(8),n2h1(55))
  call Hloop_QV_A(ntryL,G1H16(20),wf16(:,3),G1H1(1),m3h16x1(:,21),heltab2x16(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(14),n2h1(56))
  call Hloop_QV_A(ntryL,G1H16(22),wf16(:,3),G1H1(1),m3h16x1(:,22),heltab2x16(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(24),n2h1(57))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H16(23),48,wf16(:,3),15,G2tensor(13),m3h16x1(:,23),heltab2x16(:,:,46))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H16(24),48,wf16(:,3),15,G2tensor(6),m3h16x1(:,24),heltab2x16(:,:,47))
  call Hloop_VQ_A(ntryL,G0H8(2),wf8(:,26),G0H1(1),m3h8x1(:,8),heltab2x8(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,0,G1tensor(18),n2h1(58))
  call ol_merge_tensors(G0tensor(88),[G0tensor(80),G0tensor(75),G0tensor(62),G0tensor(14),G0tensor(32),G0tensor(72),G0tensor(13) &
    ,G0tensor(51),G0tensor(26),G0tensor(6)])
  call ol_merge_tensors(G1tensor(8),[G0tensor(110),G0tensor(25),G0tensor(19),G0tensor(96),G0tensor(11)])
  call ol_merge_tensors(G2tensor(32),[G2tensor(28),G2tensor(31),G2tensor(23),G2tensor(12),G2tensor(33),G0tensor(114),G0tensor(60) &
    ,G0tensor(5),G0tensor(18),G0tensor(76),G0tensor(16)])
  call ol_merge_tensors(G1tensor(18),[G0tensor(122),G0tensor(53),G0tensor(34),G0tensor(97),G0tensor(8),G0tensor(31)])
  call ol_merge_tensors(G2tensor(6),[G2tensor(13),G2tensor(8),G2tensor(7),G2tensor(16),G2tensor(34),G0tensor(104),G0tensor(44) &
    ,G0tensor(42),G0tensor(52),G0tensor(28),G0tensor(82),G0tensor(36)])
  call ol_merge_tensors(G0tensor(103),[G0tensor(68),G0tensor(37),G0tensor(2),G0tensor(92),G0tensor(20),G0tensor(86),G0tensor(66) &
    ,G0tensor(46)])
  call ol_merge_tensors(G1tensor(1),[G0tensor(78),G0tensor(54),G0tensor(7),G0tensor(45),G0tensor(40),G0tensor(56)])
  call ol_merge_tensors(G0tensor(48),[G0tensor(49),G0tensor(27),G0tensor(71)])
  call ol_merge_tensors(G0tensor(123),[G0tensor(119),G0tensor(106),G0tensor(17),G0tensor(33),G0tensor(35),G0tensor(15) &
    ,G0tensor(91)])
  call ol_merge_tensors(G0tensor(102),[G0tensor(70),G0tensor(24),G0tensor(87),G0tensor(3)])
  call ol_merge_tensors(G0tensor(118),[G0tensor(115),G0tensor(111),G0tensor(107),G0tensor(79),G0tensor(29),G0tensor(65) &
    ,G0tensor(99),G0tensor(38),G0tensor(50),G0tensor(47)])
  call ol_merge_tensors(G0tensor(116),[G0tensor(93),G0tensor(83),G0tensor(63),G0tensor(94),G0tensor(10),G0tensor(100)])
  call ol_merge_tensors(G0tensor(120),[G0tensor(108),G0tensor(73),G0tensor(59)])
  call ol_merge_tensors(G0tensor(124),[G0tensor(112),G0tensor(89),G0tensor(69)])
  call ol_merge_tensors(G2tensor(25),[G2tensor(9)])
  call ol_merge_tensors(G2tensor(26),[G2tensor(21)])
  call ol_merge_tensors(G2tensor(14),[G2tensor(27)])
  call ol_merge_tensors(G2tensor(24),[G2tensor(17)])
call TI_bubble_red(G2tensor(32),40,mass2set(:,1),G0tensor(1),M2L1R1)
call TI_bubble_red(G2tensor(6),48,mass2set(:,1),G0tensor(21),M2L1R1)
call TI_bubble_red(G2tensor(25),40,mass2set(:,2),G0tensor(41),M2L1R1,G0tensor(61))
call TI_bubble_red(G2tensor(26),40,mass2set(:,3),G0tensor(81),M2L1R1,G0tensor(67))
call TI_bubble_red(G2tensor(14),48,mass2set(:,2),G0tensor(30),M2L1R1,G0tensor(90))
call TI_bubble_red(G2tensor(24),48,mass2set(:,3),G0tensor(85),M2L1R1,G0tensor(57))
  call ol_merge_tensors(G0tensor(90),[G0tensor(61)])
  call ol_merge_tensors(G0tensor(57),[G0tensor(67)])
call TI_bubble_red(G1tensor(8),44,mass2set(:,1),G0tensor(77),M2L1R1)
call TI_bubble_red(G1tensor(18),52,mass2set(:,1),G0tensor(95),M2L1R1)
call TI_bubble_red(G1tensor(1),56,mass2set(:,1),G0tensor(84),M2L1R1)
call ol_merge_tensors(T0sum(52),[G0tensor(88)])
call ol_merge_tensors(T0sum(53),[G0tensor(77)])
call ol_merge_tensors(T0sum(54),[G0tensor(1)])
call ol_merge_tensors(T0sum(55),[G0tensor(95)])
call ol_merge_tensors(T0sum(56),[G0tensor(21)])
call ol_merge_tensors(T0sum(57),[G0tensor(103)])
call ol_merge_tensors(T0sum(58),[G0tensor(84)])
call ol_merge_tensors(T0sum(59),[G0tensor(48)])
call ol_merge_tensors(T0sum(60),[G0tensor(123)])
call ol_merge_tensors(T0sum(61),[G0tensor(102)])
call ol_merge_tensors(T0sum(62),[G0tensor(118)])
call ol_merge_tensors(T0sum(63),[G0tensor(116)])
call ol_merge_tensors(T0sum(64),[G0tensor(120)])
call ol_merge_tensors(T0sum(65),[G0tensor(124)])
call ol_merge_tensors(T0sum(66),[G0tensor(41)])
call ol_merge_tensors(T0sum(67),[G0tensor(90)])
call ol_merge_tensors(T0sum(68),[G0tensor(81)])
call ol_merge_tensors(T0sum(69),[G0tensor(57)])
call ol_merge_tensors(T0sum(70),[G0tensor(30)])
call ol_merge_tensors(T0sum(71),[G0tensor(85)])


! Compute scalar Master integrals 

call compute_scalar_box([ 40, 44, 47 ],masses2_7,RedSet_4(1),ScalarBoxes(1))
call compute_scalar_box([ 32, 44, 47 ],masses2_7,RedSet_4(2),ScalarBoxes(2))
call compute_scalar_box([ 32, 40, 47 ],masses2_7,RedSet_4(3),ScalarBoxes(3))
call compute_scalar_box([ 32, 40, 44 ],masses2_7,RedSet_4(4),ScalarBoxes(4))
call compute_scalar_box([ 8, 12, 15 ],masses2_7,RedSet_4(5),ScalarBoxes(5))
call compute_scalar_box([ 40, 43, 47 ],masses2_7,RedSet_4(6),ScalarBoxes(6))
call compute_scalar_box([ 32, 43, 47 ],masses2_7,RedSet_4(7),ScalarBoxes(7))
call compute_scalar_box([ 32, 40, 43 ],masses2_7,RedSet_4(8),ScalarBoxes(8))
call compute_scalar_box([ 8, 11, 15 ],masses2_7,RedSet_4(9),ScalarBoxes(9))
call compute_scalar_box([ 36, 39, 55 ],masses2_7,RedSet_4(10),ScalarBoxes(10))
call compute_scalar_box([ 32, 39, 55 ],masses2_7,RedSet_4(11),ScalarBoxes(11))
call compute_scalar_box([ 32, 36, 55 ],masses2_7,RedSet_4(12),ScalarBoxes(12))
call compute_scalar_box([ 32, 36, 39 ],masses2_7,RedSet_4(13),ScalarBoxes(13))
call compute_scalar_box([ 4, 7, 23 ],masses2_7,RedSet_4(14),ScalarBoxes(14))
call compute_scalar_box([ 36, 39, 47 ],masses2_7,RedSet_4(15),ScalarBoxes(15))
call compute_scalar_box([ 32, 39, 47 ],masses2_7,RedSet_4(16),ScalarBoxes(16))
call compute_scalar_box([ 32, 36, 47 ],masses2_7,RedSet_4(17),ScalarBoxes(17))
call compute_scalar_box([ 4, 7, 15 ],masses2_7,RedSet_4(18),ScalarBoxes(18))
! end of process


end subroutine vamp_1

end module ol_vamp_1_pplnjj_ckm_neexuxdddx_1_/**/REALKIND
