
module ol_vamp_1_pplnjj_ckm_neexcxbgg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pplnjj_ckm_neexcxbgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pplnjj_ckm_neexcxbgg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pplnjj_ckm_neexcxbgg_1_/**/DREALKIND
  use ol_tensor_sum_storage_pplnjj_ckm_neexcxbgg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pplnjj_ckm_neexcxbgg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pplnjj_ckm_neexcxbgg_1_/**/DREALKIND, only: ntryL, p_switch, Hel
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(64)
  type(Hpolcont), intent(in) :: M(3,64)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

Gcoeff(:)%j = (c(8)*M(1,:)%j-c(9)*M(3,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,3,16,4,8],[nMB,0,0,0,nMB],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,1),heltab2x64(:,:,1))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(1),n2h32(1))
Gcoeff(:)%j = (c(8)*M(1,:)%j-c(9)*M(3,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,3,8,4,16],[0,nMB,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,2),heltab2x64(:,:,2))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(2),n2h32(2))
Gcoeff(:)%j = (c(8)*M(2,:)%j-c(9)*M(3,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,3,16,8,4],[0,nMB,nMB,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,3),heltab2x64(:,:,3))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(3),n2h32(3))
Gcoeff(:)%j = (c(8)*M(2,:)%j-c(9)*M(3,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,4,8,3,16],[0,0,nMB,0,0],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,4),heltab2x64(:,:,4))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(4),n2h32(4))
Gcoeff(:)%j = (c(8)*M(2,:)%j-c(9)*M(3,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,3,4,8,16],[nMB,0,0,nMB,nMB],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,5),heltab2x64(:,:,5))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(5),n2h32(5))
Gcoeff(:)%j = (c(8)*M(1,:)%j-c(9)*M(3,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,8,4,3,16],[nMB,0,0,nMB,nMB],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,6),heltab2x64(:,:,6))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(6),n2h32(6))
Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[32,3,8,16,4],[0,nMB,0,0,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,7),heltab2x64(:,:,7))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(7),n2h32(7))
Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[32,4,16,3,8],[0,0,0,nMB,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(8),m3h2x32(:,8),heltab2x64(:,:,8))
Gcoeff(:)%j = (-(c(4)*M(3,:)%j)) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[32,3,4,16,8],[nMB,0,0,0,nMB],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,9),heltab2x64(:,:,9))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(9),n2h32(8))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(9)*M(3,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,8,3,4,16],[0,nMB,0,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(10),m3h2x32(:,10),heltab2x64(:,:,10))
Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[32,4,3,16,8],[0,0,nMB,nMB,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(11),m3h2x32(:,11),heltab2x64(:,:,11))
Gcoeff(:)%j = (-(c(11)*M(2,:)%j)-c(9)*M(3,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[32,4,3,8,16],[0,0,nMB,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(12),m3h2x32(:,12),heltab2x64(:,:,12))
  call Hloop_QW_A(ntryL,G1H32(1),wf4(:,4),G1H8(1),m3h4x8(:,1),heltab2x32(:,:,1))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(1),n2h8(1))
  call Hloop_AW_Q(ntryL,G1H32(2),wf4(:,4),G1H8(1),m3h4x8(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G1H8(1),35,nMB,G2H8(2),n2h8(2))
  call Hloop_AW_Q(ntryL,G1H32(3),wf4(:,4),G1H8(1),m3h4x8(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G1H8(1),35,nMB,G2H8(3),n2h8(3))
  call Hloop_QA_V(ntryL,G1H32(4),ex3(:),G1H16(1),m3h2x16(:,1),heltab2x32(:,:,4))
  call Hloop_QW_A(ntryL,G1H32(5),wf4(:,4),G1H8(1),m3h4x8(:,4),heltab2x32(:,:,5))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(4),n2h8(4))
  call Hloop_AQ_V(ntryL,G1H32(6),ex4(:),G1H16(2),m3h2x16(:,2),heltab2x32(:,:,6))
  call Hloop_AW_Q(ntryL,G1H32(7),wf4(:,4),G1H8(1),m3h4x8(:,5),heltab2x32(:,:,7))
  call Hloop_A_Q(ntryL,G1H8(1),35,nMB,G2H8(5),n2h8(5))
  call Hloop_VA_Q(ntryL,G1H32(8),ex3(:),G1H16(3),m3h2x16(:,3),heltab2x32(:,:,8))
  call Hloop_A_Q(ntryL,G1H16(3),36,0,G2H16(1),n2h16(1))
  call Hloop_QW_A(ntryL,G1H32(9),wf4(:,4),G1H8(1),m3h4x8(:,6),heltab2x32(:,:,9))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(6),n2h8(6))
  call Hloop_VQ_A(ntryL,G1H32(10),ex4(:),G1H16(3),m3h2x16(:,4),heltab2x32(:,:,10))
  call Hloop_Q_A(ntryL,G1H16(3),40,nMB,G2H16(2),n2h16(2))
  call Hloop_VA_Q(ntryL,G1H32(11),ex3(:),G1H16(3),m3h2x16(:,5),heltab2x32(:,:,11))
  call Hloop_A_Q(ntryL,G1H16(3),36,0,G2H16(3),n2h16(3))
  call Hloop_VA_Q(ntryL,G1H32(12),ex3(:),G1H16(3),m3h2x16(:,6),heltab2x32(:,:,12))
  call Hloop_A_Q(ntryL,G1H16(3),36,0,G2H16(4),n2h16(4))
call Hotf_5pt_reduction(G2H8(1),RedSet_5(1),mass5set(:,1),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),G1H8(6),8)
call HG1shiftOLR(G1H8(2),8,8)
  call Hloop_AQ_V(ntryL,G2H8(2),ex4(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
call Hotf_5pt_reduction(G2H8(3),RedSet_5(2),mass5set(:,2),  & 
G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),G1H8(12),8)
call HG1shiftOLR(G1H8(8),4,8)
  call Hloop_VQ_A(ntryL,G1H16(1),ex4(:),G1H8(13),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_Q_A(ntryL,G1H8(13),44,nMB,G2H8(1),n2h8(7))
  call Hloop_QA_V(ntryL,G2H8(4),ex3(:),G2H4(2),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_VA_Q(ntryL,G1H16(2),ex3(:),G1H8(13),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_A_Q(ntryL,G1H8(13),44,0,G2H8(2),n2h8(8))
  call Hloop_AQ_V(ntryL,G2H8(5),ex4(:),G2H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
call Hotf_5pt_reduction(G2H16(1),RedSet_5(3),mass5set(:,3),  & 
G1H16(3),G1H16(1),G1H16(2),G1H16(4),G1H16(5),G1H16(6),16)
call HG1shiftOLR(G1H16(1),8,16)
  call Hloop_QA_V(ntryL,G2H8(6),ex3(:),G2H4(4),m3h2x4(:,4),heltab2x8(:,:,4))
call Hotf_5pt_reduction(G2H16(2),RedSet_5(4),mass5set(:,4),  & 
G1H16(7),G1H16(8),G1H16(9),G1H16(10),G1H16(11),G1H16(12),16)
call HG1shiftOLR(G1H16(8),16,16)
call Hotf_5pt_reduction(G2H16(3),RedSet_5(5),mass5set(:,5),  & 
G1H16(13),G1H16(14),G1H16(15),G1H16(16),G1H16(17),G1H16(18),16)
call HG1shiftOLR(G1H16(14),8,16)
call Hotf_5pt_reduction(G2H16(4),RedSet_5(6),mass5set(:,6),  & 
G1H16(19),G1H16(20),G1H16(21),G1H16(22),G1H16(23),G1H16(24),16)
call HG1shiftOLR(G1H16(20),16,16)
  call Hloop_QV_A(ntryL,G1H8(1),ex5(:),G1H4(1),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(5),n2h4(1))
call HGT_OLR(G1H8(2),1,1,8)
call HGT_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(2),-8,nMB,G2H8(3),n2h8(9))
  call Hloop_AQ_V(ntryL,G2H8(3),ex4(:),G2H4(6),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_QV_A(ntryL,G1H8(4),ex5(:),G1H4(1),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(7),n2h4(2))
  call Hloop_QV_A(ntryL,G1H8(5),ex5(:),G1H4(1),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(8),n2h4(3))
  call Hloop_QV_A(ntryL,G1H8(6),ex5(:),G1H4(1),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(9),n2h4(4))
  call Hloop_AV_Q(ntryL,G1H8(7),ex5(:),G1H4(1),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMB,G2H4(10),n2h4(5))
call HGT_OLR(G1H8(8),1,1,8)
call HGT_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(8),-4,0,G2H8(4),n2h8(10))
  call Hloop_QA_V(ntryL,G2H8(4),ex3(:),G2H4(11),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_AV_Q(ntryL,G1H8(10),ex5(:),G1H4(1),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMB,G2H4(12),n2h4(6))
  call Hloop_AV_Q(ntryL,G1H8(11),ex5(:),G1H4(1),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMB,G2H4(13),n2h4(7))
  call Hloop_AV_Q(ntryL,G1H8(12),ex5(:),G1H4(1),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMB,G2H4(14),n2h4(8))
  call Hloop_AV_Q(ntryL,G1H16(3),ex5(:),G1H8(13),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_A_Q(ntryL,G1H8(13),52,0,G2H8(5),n2h8(11))
call HGT_raise_alpha_OLR(G1H16(1),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(1),2,5,16)
  call Hloop_VQ_A(ntryL,G1H16(1),ex4(:),G1H8(1),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_AV_Q(ntryL,G1H16(4),ex5(:),G1H8(2),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_A_Q(ntryL,G1H8(2),52,0,G2H8(6),n2h8(12))
  call Hloop_AV_Q(ntryL,G1H16(5),ex5(:),G1H8(4),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_A_Q(ntryL,G1H8(4),52,0,G2H8(3),n2h8(13))
  call Hloop_AV_Q(ntryL,G1H16(6),ex5(:),G1H8(5),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_A_Q(ntryL,G1H8(5),52,0,G2H8(4),n2h8(14))
  call Hloop_QW_A(ntryL,G1H16(7),wf4(:,4),G1H4(1),m3h4x4(:,1),heltab2x16(:,:,8))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(15),n2h4(9))
call HGT_raise_alpha_OLR(G1H16(8),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(8),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(8),-16,ex5(:),16,G2H8(7),m3h2x8(:,8),heltab2x16(:,:,9))
call signflip_OLR(G2H8(7))
  call Hloop_QW_A(ntryL,G1H16(10),wf4(:,4),G1H4(1),m3h4x4(:,2),heltab2x16(:,:,10))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(16),n2h4(10))
  call Hloop_QW_A(ntryL,G1H16(11),wf4(:,4),G1H4(1),m3h4x4(:,3),heltab2x16(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(17),n2h4(11))
  call Hloop_QW_A(ntryL,G1H16(12),wf4(:,4),G1H4(1),m3h4x4(:,4),heltab2x16(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(18),n2h4(12))
  call Hloop_AW_Q(ntryL,G1H16(13),wf4(:,4),G1H4(1),m3h4x4(:,5),heltab2x16(:,:,13))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMB,G2H4(19),n2h4(13))
call HGT_raise_alpha_OLR(G1H16(14),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(14),2,5,16)
  call Hloop_VQ_A(ntryL,G1H16(14),ex4(:),G1H8(6),m3h2x8(:,9),heltab2x16(:,:,14))
  call Hloop_AW_Q(ntryL,G1H16(16),wf4(:,4),G1H4(1),m3h4x4(:,6),heltab2x16(:,:,15))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMB,G2H4(20),n2h4(14))
  call Hloop_AW_Q(ntryL,G1H16(17),wf4(:,4),G1H4(1),m3h4x4(:,7),heltab2x16(:,:,16))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMB,G2H4(21),n2h4(15))
  call Hloop_AW_Q(ntryL,G1H16(18),wf4(:,4),G1H4(1),m3h4x4(:,8),heltab2x16(:,:,17))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMB,G2H4(22),n2h4(16))
  call Hloop_AW_Q(ntryL,G1H16(19),wf4(:,4),G1H4(1),m3h4x4(:,9),heltab2x16(:,:,18))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMB,G2H4(23),n2h4(17))
call HGT_raise_alpha_OLR(G1H16(20),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(20),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(20),-16,ex5(:),16,G2H8(8),m3h2x8(:,10),heltab2x16(:,:,19))
call signflip_OLR(G2H8(8))
  call Hloop_AW_Q(ntryL,G1H16(22),wf4(:,4),G1H4(1),m3h4x4(:,10),heltab2x16(:,:,20))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMB,G2H4(24),n2h4(18))
  call Hloop_AW_Q(ntryL,G1H16(23),wf4(:,4),G1H4(1),m3h4x4(:,11),heltab2x16(:,:,21))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMB,G2H4(25),n2h4(19))
  call Hloop_AW_Q(ntryL,G1H16(24),wf4(:,4),G1H4(1),m3h4x4(:,12),heltab2x16(:,:,22))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMB,G2H4(26),n2h4(20))
call Hotf_5pt_reduction(G2H4(1),RedSet_5(7),mass5set(:,4),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
call HG1shiftOLR(G1H4(2),16,4)
call Hotf_5pt_reduction(G2H8(1),RedSet_5(8),mass5set(:,6),  & 
G1H8(7),G1H8(8),G1H8(10),G1H8(11),G1H8(12),G1H8(13),8)
call HG1shiftOLR(G1H8(8),16,8)
call Hotf_5pt_reduction(G2H4(2),RedSet_5(9),mass5set(:,7),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
call HG1shiftOLR(G1H4(8),16,4)
call Hotf_5pt_reduction(G2H8(2),RedSet_5(10),mass5set(:,7),  & 
G1H8(2),G1H8(4),G1H8(5),G1H8(14),G1H8(15),G1H8(16),8)
call HG1shiftOLR(G1H8(4),16,8)
call Hotf_5pt_reduction(G2H4(3),RedSet_5(11),mass5set(:,4),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
call HG1shiftOLR(G1H4(14),4,4)
call Hotf_5pt_reduction(G2H4(4),RedSet_5(12),mass5set(:,1),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
call HG1shiftOLR(G1H4(20),8,4)
  call Hloop_QA_V(ntryL,G2H4(5),ex3(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_V(ntryL,G2H4(8),ex3(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_V(ntryL,G2H4(9),ex3(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_AQ_V(ntryL,G2H4(10),ex4(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_AQ_V(ntryL,G2H4(13),ex4(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_V(ntryL,G2H4(14),ex4(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
call Hotf_5pt_reduction(G2H8(5),RedSet_5(3),mass5set(:,3),  & 
G1H8(17),G1H8(18),G1H8(19),G1H8(20),G1H8(21),G1H8(22),8)
call HG1shiftOLR(G1H8(18),8,8)
call Hotf_4pt_reduction(G2H8(3),RedSet_4(1),mass4set(:,1),  & 
G1H8(23),G1H8(24),G1H8(25),G1H8(26),G1H8(27),8)
call HG1shiftOLR(G1H8(24),8,8)
call Hotf_4pt_reduction(G2H8(4),RedSet_4(2),mass4set(:,2),  & 
G1H8(28),G1H8(29),G1H8(30),G1H8(31),G1H8(32),8)
call HG1shiftOLR(G1H8(29),11,8)
  call Hloop_QA_V(ntryL,G2H4(15),ex3(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_QA_V(ntryL,G2H4(17),ex3(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_QA_V(ntryL,G2H4(18),ex3(:),G2H2(9),m3h2x2(:,9),heltab2x4(:,:,9))
call Hotf_5pt_reduction(G2H4(19),RedSet_5(5),mass5set(:,5),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
call HG1shiftOLR(G1H4(26),8,4)
call Hotf_4pt_reduction(G2H4(21),RedSet_4(1),mass4set(:,1),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),4)
call HG1shiftOLR(G1H4(32),8,4)
call Hotf_4pt_reduction(G2H4(22),RedSet_4(3),mass4set(:,1),  & 
G1H4(36),G1H4(37),G1H4(38),G1H4(39),G1H4(40),4)
call HG1shiftOLR(G1H4(37),24,4)
  call Hloop_AQ_V(ntryL,G2H4(23),ex4(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_AQ_V(ntryL,G2H4(25),ex4(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_AQ_V(ntryL,G2H4(26),ex4(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call ol_merge(ntryL,G1H8(23),[G1H8(21)])
  call ol_merge(ntryL,G1H8(28),[G1H8(22)])
  call ol_merge(ntryL,G1H4(31),[G1H4(29)])
  call ol_merge(ntryL,G1H4(36),[G1H4(30)])
  call Hloop_VA_Q(ntryL,G1H4(1),ex3(:),G1H2(1),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(13),n2h2(1))
call HGT_OLR(G1H4(2),1,1,4)
call HGT_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(2),-16,0,G2H4(1),n2h4(21))
  call Hloop_QV_A(ntryL,G2H4(1),ex5(:),G2H2(14),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_VA_Q(ntryL,G1H4(5),ex3(:),G1H2(1),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(15),n2h2(2))
  call Hloop_VA_Q(ntryL,G1H4(6),ex3(:),G1H2(1),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(16),n2h2(3))
  call Hloop_QW_A(ntryL,G1H8(7),wf4(:,4),G1H2(1),m3h4x2(:,1),heltab2x8(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(17),n2h2(4))
call HGT_OLR(G1H8(8),1,1,8)
call HGT_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(8),-16,0,G2H8(1),n2h8(15))
  call Hloop_AV_Q(ntryL,G2H8(1),ex5(:),G2H4(2),m3h2x4(:,15),heltab2x8(:,:,16))
  call Hloop_QW_A(ntryL,G1H8(12),wf4(:,4),G1H2(1),m3h4x2(:,2),heltab2x8(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(18),n2h2(5))
  call Hloop_QW_A(ntryL,G1H8(13),wf4(:,4),G1H2(1),m3h4x2(:,3),heltab2x8(:,:,18))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(19),n2h2(6))
  call Hloop_VQ_A(ntryL,G1H4(7),ex4(:),G1H2(1),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMB,G2H2(20),n2h2(7))
call HGT_OLR(G1H4(8),1,1,4)
call HGT_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(8),-16,nMB,G2H4(3),n2h4(22))
  call Hloop_AV_Q(ntryL,G2H4(3),ex5(:),G2H2(21),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_VQ_A(ntryL,G1H4(11),ex4(:),G1H2(1),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMB,G2H2(22),n2h2(8))
  call Hloop_VQ_A(ntryL,G1H4(12),ex4(:),G1H2(1),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMB,G2H2(23),n2h2(9))
  call Hloop_AW_Q(ntryL,G1H8(2),wf4(:,4),G1H2(1),m3h4x2(:,4),heltab2x8(:,:,19))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMB,G2H2(24),n2h2(10))
call HGT_OLR(G1H8(4),1,1,8)
call HGT_invQ_OLR(G1H8(4),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(4),-16,nMB,G2H8(2),n2h8(16))
  call Hloop_QV_A(ntryL,G2H8(2),ex5(:),G2H4(4),m3h2x4(:,16),heltab2x8(:,:,20))
  call Hloop_AW_Q(ntryL,G1H8(15),wf4(:,4),G1H2(1),m3h4x2(:,5),heltab2x8(:,:,21))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMB,G2H2(25),n2h2(11))
  call Hloop_AW_Q(ntryL,G1H8(16),wf4(:,4),G1H2(1),m3h4x2(:,6),heltab2x8(:,:,22))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMB,G2H2(26),n2h2(12))
  call Hloop_UV_W(ntryL,G1H4(13),43,ex5(:),16,G2H2(27),m3h2x2(:,21),heltab2x4(:,:,21))
call HGT_OLR(G1H4(14),1,1,4)
call HGT_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(14),-4,0,G2H4(5),n2h4(23))
  call Hloop_QA_V(ntryL,G2H4(5),ex3(:),G2H2(28),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_UV_W(ntryL,G1H4(17),43,ex5(:),16,G2H2(29),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_UV_W(ntryL,G1H4(18),43,ex5(:),16,G2H2(30),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_UV_W(ntryL,G1H4(19),39,ex5(:),16,G2H2(31),m3h2x2(:,25),heltab2x4(:,:,25))
call HGT_OLR(G1H4(20),1,1,4)
call HGT_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(20),-8,nMB,G2H4(8),n2h4(24))
  call Hloop_AQ_V(ntryL,G2H4(8),ex4(:),G2H2(32),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_UV_W(ntryL,G1H4(23),39,ex5(:),16,G2H2(33),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_UV_W(ntryL,G1H4(24),39,ex5(:),16,G2H2(34),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_AW_Q(ntryL,G1H8(17),wf4(:,4),G1H2(1),m3h4x2(:,7),heltab2x8(:,:,23))
  call Hloop_A_Q(ntryL,G1H2(1),55,nMB,G2H2(35),n2h2(13))
call HGT_raise_alpha_OLR(G1H8(18),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(18),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(18),ex4(:),G1H4(29),m3h2x4(:,17),heltab2x8(:,:,24))
  call Hloop_AW_Q(ntryL,G1H8(23),wf4(:,4),G1H2(1),m3h4x2(:,8),heltab2x8(:,:,25))
  call Hloop_A_Q(ntryL,G1H2(1),55,nMB,G2H2(36),n2h2(14))
  call Hloop_AW_Q(ntryL,G1H8(28),wf4(:,4),G1H2(1),m3h4x2(:,9),heltab2x8(:,:,26))
  call Hloop_A_Q(ntryL,G1H2(1),55,nMB,G2H2(37),n2h2(15))
call HGT_raise_alpha_OLR(G1H8(24),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(24),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(24),ex4(:),G1H4(30),m3h2x4(:,18),heltab2x8(:,:,27))
  call Hloop_AW_Q(ntryL,G1H8(27),wf4(:,4),G1H2(1),m3h4x2(:,10),heltab2x8(:,:,28))
  call Hloop_A_Q(ntryL,G1H2(1),55,nMB,G2H2(38),n2h2(16))
call HGT_raise_alpha_OLR(G1H8(29),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(29),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(29),ex4(:),G1H4(1),m3h2x4(:,19),heltab2x8(:,:,29))
  call Hloop_AW_Q(ntryL,G1H8(32),wf4(:,4),G1H2(1),m3h4x2(:,11),heltab2x8(:,:,30))
  call Hloop_A_Q(ntryL,G1H2(1),55,nMB,G2H2(39),n2h2(17))
  call Hloop_AV_Q(ntryL,G1H4(25),ex5(:),G1H2(1),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_A_Q(ntryL,G1H2(1),55,nMB,G2H2(40),n2h2(18))
call HGT_raise_alpha_OLR(G1H4(26),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(26),ex4(:),G1H2(1),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_AV_Q(ntryL,G1H4(31),ex5(:),G1H2(2),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_A_Q(ntryL,G1H2(2),55,nMB,G2H2(41),n2h2(19))
  call Hloop_AV_Q(ntryL,G1H4(36),ex5(:),G1H2(2),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_A_Q(ntryL,G1H2(2),55,nMB,G2H2(42),n2h2(20))
call HGT_raise_alpha_OLR(G1H4(32),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(32),ex4(:),G1H2(2),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_AV_Q(ntryL,G1H4(35),ex5(:),G1H2(3),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_A_Q(ntryL,G1H2(3),55,nMB,G2H2(43),n2h2(21))
call HGT_raise_alpha_OLR(G1H4(37),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(37),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(37),ex4(:),G1H2(3),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_AV_Q(ntryL,G1H4(40),ex5(:),G1H2(4),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_A_Q(ntryL,G1H2(4),55,nMB,G2H2(44),n2h2(22))
call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(4),G1H2(5),G1H2(6),G1H2(7),G1H2(8),G1H2(9),2)
call HG1shiftOLR(G1H2(5),8,2)
call Hotf_4pt_reduction(G2H2(3),RedSet_4(4),mass4set(:,3),  & 
G1H2(10),G1H2(11),G1H2(12),G1H2(13),G1H2(14),2)
call HG1shiftOLR(G1H2(11),12,2)
call Hotf_5pt_reduction(G2H2(4),RedSet_5(2),mass5set(:,2),  & 
G1H2(15),G1H2(16),G1H2(17),G1H2(18),G1H2(19),G1H2(20),2)
call HG1shiftOLR(G1H2(16),4,2)
call Hotf_4pt_reduction(G2H2(6),RedSet_4(4),mass4set(:,4),  & 
G1H2(21),G1H2(22),G1H2(23),G1H2(24),G1H2(25),2)
call HG1shiftOLR(G1H2(22),12,2)
call Hotf_5pt_reduction(G2H2(7),RedSet_5(4),mass5set(:,4),  & 
G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),G1H2(31),2)
call HG1shiftOLR(G1H2(27),16,2)
call Hotf_4pt_reduction(G2H2(9),RedSet_4(5),mass4set(:,5),  & 
G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
call HG1shiftOLR(G1H2(33),20,2)
call Hotf_5pt_reduction(G2H2(10),RedSet_5(6),mass5set(:,6),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
call HG1shiftOLR(G1H2(38),16,2)
call Hotf_4pt_reduction(G2H2(12),RedSet_4(3),mass4set(:,1),  & 
G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),2)
call HG1shiftOLR(G1H2(44),24,2)
call Hotf_5pt_reduction(G2H2(13),RedSet_5(7),mass5set(:,4),  & 
G1H2(48),G1H2(49),G1H2(50),G1H2(51),G1H2(52),G1H2(53),2)
call HG1shiftOLR(G1H2(49),16,2)
call Hotf_4pt_reduction(G2H2(16),RedSet_4(6),mass4set(:,5),  & 
G1H2(54),G1H2(55),G1H2(56),G1H2(57),G1H2(58),2)
call HG1shiftOLR(G1H2(55),20,2)
call Hotf_5pt_reduction(G2H2(17),RedSet_5(8),mass5set(:,6),  & 
G1H2(59),G1H2(60),G1H2(61),G1H2(62),G1H2(63),G1H2(64),2)
call HG1shiftOLR(G1H2(60),16,2)
call Hotf_4pt_reduction(G2H2(19),RedSet_4(7),mass4set(:,1),  & 
G1H2(65),G1H2(66),G1H2(67),G1H2(68),G1H2(69),2)
call HG1shiftOLR(G1H2(66),19,2)
call Hotf_5pt_reduction(G2H2(20),RedSet_5(9),mass5set(:,7),  & 
G1H2(70),G1H2(71),G1H2(72),G1H2(73),G1H2(74),G1H2(75),2)
call HG1shiftOLR(G1H2(71),16,2)
call Hotf_4pt_reduction(G2H2(23),RedSet_4(8),mass4set(:,3),  & 
G1H2(76),G1H2(77),G1H2(78),G1H2(79),G1H2(80),2)
call HG1shiftOLR(G1H2(77),24,2)
call Hotf_5pt_reduction(G2H2(24),RedSet_5(10),mass5set(:,7),  & 
G1H2(81),G1H2(82),G1H2(83),G1H2(84),G1H2(85),G1H2(86),2)
call HG1shiftOLR(G1H2(82),16,2)
call Hotf_4pt_reduction(G2H2(26),RedSet_4(9),mass4set(:,3),  & 
G1H2(87),G1H2(88),G1H2(89),G1H2(90),G1H2(91),2)
call HG1shiftOLR(G1H2(88),19,2)
call Hotf_5pt_reduction(G2H2(27),RedSet_5(11),mass5set(:,4),  & 
G1H2(92),G1H2(93),G1H2(94),G1H2(95),G1H2(96),G1H2(97),2)
call HG1shiftOLR(G1H2(93),4,2)
call Hotf_4pt_reduction(G2H2(30),RedSet_4(6),mass4set(:,5),  & 
G1H2(98),G1H2(99),G1H2(100),G1H2(101),G1H2(102),2)
call HG1shiftOLR(G1H2(99),20,2)
call Hotf_5pt_reduction(G2H2(31),RedSet_5(12),mass5set(:,1),  & 
G1H2(103),G1H2(104),G1H2(105),G1H2(106),G1H2(107),G1H2(108),2)
call HG1shiftOLR(G1H2(104),8,2)
call Hotf_4pt_reduction(G2H2(34),RedSet_4(8),mass4set(:,3),  & 
G1H2(109),G1H2(110),G1H2(111),G1H2(112),G1H2(113),2)
call HG1shiftOLR(G1H2(110),24,2)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(35),ex4(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(37),ex4(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(40),ex4(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(42),ex4(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call ol_merge(ntryL,G1H2(10),[G1H2(9)])
  call ol_merge(ntryL,G1H2(21),[G1H2(20)])
  call ol_merge(ntryL,G1H2(32),[G1H2(31)])
  call ol_merge(ntryL,G1H2(43),[G1H2(42)])
  call ol_merge(ntryL,G1H2(54),[G1H2(53)])
  call ol_merge(ntryL,G1H2(65),[G1H2(64)])
  call ol_merge(ntryL,G1H2(76),[G1H2(75)])
  call ol_merge(ntryL,G1H2(87),[G1H2(86)])
  call ol_merge(ntryL,G1H2(98),[G1H2(97)])
  call ol_merge(ntryL,G1H2(109),[G1H2(108)])
  call Hloop_VQ_A(ntryL,G1H2(4),ex4(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(5),n2h1(1))
  call Hloop_VQ_A(ntryL,G1H2(5),ex4(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(6),n2h1(2))
  call Hloop_VQ_A(ntryL,G1H2(10),ex4(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(7),n2h1(3))
  call Hloop_VQ_A(ntryL,G1H2(11),ex4(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(8),n2h1(4))
  call Hloop_VA_Q(ntryL,G1H2(15),ex3(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(9),n2h1(5))
  call Hloop_VA_Q(ntryL,G1H2(16),ex3(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(10),n2h1(6))
  call Hloop_VA_Q(ntryL,G1H2(21),ex3(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(7))
  call Hloop_VA_Q(ntryL,G1H2(22),ex3(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(12),n2h1(8))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(26),47,ex5(:),16,G2tensor(13),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(27),0,ex5(:),16,G2tensor(14),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(32),47,ex5(:),16,G2tensor(15),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(33),4,ex5(:),16,G2tensor(16),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(37),47,ex5(:),16,G2tensor(17),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(38),0,ex5(:),16,G2tensor(18),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(43),47,ex5(:),16,G2tensor(19),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(44),8,ex5(:),16,G2tensor(20),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hloop_AV_Q(ntryL,G1H2(48),ex5(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(21),n2h1(13))
  call Hloop_AV_Q(ntryL,G1H2(49),ex5(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(22),n2h1(14))
  call Hloop_AV_Q(ntryL,G1H2(54),ex5(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(23),n2h1(15))
  call Hloop_AV_Q(ntryL,G1H2(55),ex5(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,0,G2tensor(24),n2h1(16))
  call Hloop_QV_A(ntryL,G1H2(59),ex5(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(25),n2h1(17))
  call Hloop_QV_A(ntryL,G1H2(60),ex5(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(26),n2h1(18))
  call Hloop_QV_A(ntryL,G1H2(65),ex5(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(27),n2h1(19))
  call Hloop_QV_A(ntryL,G1H2(66),ex5(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),19,0,G2tensor(28),n2h1(20))
  call Hloop_QV_A(ntryL,G1H2(70),ex5(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(29),n2h1(21))
  call Hloop_QV_A(ntryL,G1H2(71),ex5(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(30),n2h1(22))
  call Hloop_QV_A(ntryL,G1H2(76),ex5(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(31),n2h1(23))
  call Hloop_QV_A(ntryL,G1H2(77),ex5(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,nMB,G2tensor(32),n2h1(24))
  call Hloop_AV_Q(ntryL,G1H2(81),ex5(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(33),n2h1(25))
  call Hloop_AV_Q(ntryL,G1H2(82),ex5(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(34),n2h1(26))
  call Hloop_AV_Q(ntryL,G1H2(87),ex5(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(35),n2h1(27))
  call Hloop_AV_Q(ntryL,G1H2(88),ex5(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),19,nMB,G2tensor(36),n2h1(28))
  call Hloop_VA_Q(ntryL,G1H2(92),ex3(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(37),n2h1(29))
  call Hloop_VA_Q(ntryL,G1H2(93),ex3(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(38),n2h1(30))
  call Hloop_VA_Q(ntryL,G1H2(98),ex3(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(39),n2h1(31))
  call Hloop_VA_Q(ntryL,G1H2(99),ex3(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,0,G2tensor(40),n2h1(32))
  call Hloop_VQ_A(ntryL,G1H2(103),ex4(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(41),n2h1(33))
  call Hloop_VQ_A(ntryL,G1H2(104),ex4(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(42),n2h1(34))
  call Hloop_VQ_A(ntryL,G1H2(109),ex4(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(43),n2h1(35))
  call Hloop_VQ_A(ntryL,G1H2(110),ex4(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,nMB,G2tensor(44),n2h1(36))
call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(3),mass5set(:,3),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
call G_TensorShift(G1tensor(2),8)
call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(5),mass5set(:,5),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
call G_TensorShift(G1tensor(8),8)
call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(1),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
call G_TensorShift(G1tensor(14),8)
call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(2),mass5set(:,2),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
call G_TensorShift(G1tensor(20),4)
call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(4),mass5set(:,4),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
call G_TensorShift(G1tensor(26),16)
call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(6),mass5set(:,6),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
call G_TensorShift(G1tensor(32),16)
call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(7),mass5set(:,4),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
call G_TensorShift(G1tensor(38),16)
call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(8),mass5set(:,6),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
call G_TensorShift(G1tensor(44),16)
call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(9),mass5set(:,7),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
call G_TensorShift(G1tensor(50),16)
call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(10),mass5set(:,7),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
call G_TensorShift(G1tensor(56),16)
call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(11),mass5set(:,4),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
call G_TensorShift(G1tensor(62),4)
call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(12),mass5set(:,1),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
call G_TensorShift(G1tensor(68),8)
call ol_merge_tensors(T1sum(1),[G1tensor(1)])
call ol_merge_tensors(T1sum(2),[G1tensor(7)])
call ol_merge_tensors(T1sum(3),[G1tensor(13)])
call ol_merge_tensors(T1sum(4),[G1tensor(19)])
call ol_merge_tensors(T1sum(5),[G1tensor(25)])
call ol_merge_tensors(T1sum(6),[G1tensor(31)])
call ol_merge_tensors(T1sum(7),[G1tensor(37)])
call ol_merge_tensors(T1sum(8),[G1tensor(43)])
call ol_merge_tensors(T1sum(9),[G1tensor(49)])
call ol_merge_tensors(T1sum(10),[G1tensor(55)])
call ol_merge_tensors(T1sum(11),[G1tensor(61)])
call ol_merge_tensors(T1sum(12),[G1tensor(67)])
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(9)*M(3,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[48,4,3,8],[0,0,nMB,0],5,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(1),m4h2x2x16(:,1),heltab3x64(:,:,1))
Gcoeff(:)%j = (-(c(11)*M(2,:)%j)-c(9)*M(3,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[48,4,3,8],[0,0,nMB,0],5,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex5(:),ex6(:),G0H16(2),m4h2x2x16(:,2),heltab3x64(:,:,2))
Gcoeff(:)%j = (c(11)*(M(1,:)%j-M(2,:)%j)) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[48,4,3,8],[0,0,nMB,0],5,1,wf4(:,4))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(3),m4h2x2x16(:,3),heltab3x64(:,:,3))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(4)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[32,8,3,20],[0,nMB,0,0],4,2,wf4(:,4),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(1),m3h2x32(:,13),heltab2x64(:,:,13))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(4)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[32,3,20,8],[nMB,0,0,nMB],4,2,wf4(:,4),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,14),heltab2x64(:,:,14))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(2),n2h32(9))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(4)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[32,3,8,20],[0,nMB,0,0],4,2,wf4(:,4),wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,15),heltab2x64(:,:,15))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(3),n2h32(10))
Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(45)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[32,4,3,24],[0,0,nMB,0],4,2,wf4(:,4),wf4(:,10))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(4),m3h2x32(:,16),heltab2x64(:,:,16))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(45)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[32,3,24,4],[0,nMB,0,0],4,2,wf4(:,4),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,17),heltab2x64(:,:,17))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(5),n2h32(11))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(45)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[32,3,4,24],[nMB,0,0,nMB],4,2,wf4(:,4),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,18),heltab2x64(:,:,18))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(6),n2h32(12))
Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(11)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[36,3,8,16],[0,nMB,0,0],4,2,wf4(:,9),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,9),G0H16(4),m3h4x16(:,1),heltab2x64(:,:,19))
  call Hloop_A_Q(ntryL,G0H16(4),36,0,G1H16(3),n2h16(9))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(11)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[36,3,16,8],[0,nMB,nMB,0],4,2,wf4(:,9),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,9),G0H16(4),m3h4x16(:,2),heltab2x64(:,:,20))
  call Hloop_A_Q(ntryL,G0H16(4),36,0,G1H16(1),n2h16(10))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(11)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[36,8,3,16],[0,nMB,0,0],4,2,wf4(:,9),wf4(:,4))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,9),G0H16(4),m3h4x16(:,3),heltab2x64(:,:,21))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(35)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[40,3,4,16],[nMB,0,0,0],4,2,wf4(:,6),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,6),G0H16(5),m3h4x16(:,4),heltab2x64(:,:,22))
  call Hloop_Q_A(ntryL,G0H16(5),40,nMB,G1H16(4),n2h16(11))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(35)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[40,3,16,4],[nMB,0,0,0],4,2,wf4(:,6),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,6),G0H16(5),m3h4x16(:,5),heltab2x64(:,:,23))
  call Hloop_Q_A(ntryL,G0H16(5),40,nMB,G1H16(5),n2h16(12))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(35)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[40,4,3,16],[0,0,nMB,nMB],4,2,wf4(:,6),wf4(:,4))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,6),G0H16(5),m3h4x16(:,6),heltab2x64(:,:,24))
Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(2,:)%j)) * den(75)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[48,3,4,8],[nMB,0,0,nMB],4,2,wf4(:,11),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,11),G0H16(6),m3h4x16(:,7),heltab2x64(:,:,25))
  call Hloop_Q_A(ntryL,G0H16(6),48,nMB,G1H16(6),n2h16(13))
Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(2,:)%j)) * den(75)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[48,3,8,4],[0,nMB,0,0],4,2,wf4(:,11),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,11),G0H16(6),m3h4x16(:,8),heltab2x64(:,:,26))
  call Hloop_A_Q(ntryL,G0H16(6),48,0,G1H16(7),n2h16(14))
Gcoeff(:)%j = (c(11)*(M(1,:)%j-M(2,:)%j)) * den(75)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[48,4,3,8],[0,0,nMB,0],4,2,wf4(:,11),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,11),48,G1H16(8),m3h4x16(:,9),heltab2x64(:,:,27))
Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[32,7,16,8],[0,nMB,nMB,0],4,1,wf8(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(7),m3h2x32(:,19),heltab2x64(:,:,28))
Gcoeff(:)%j = (-(c(4)*M(3,:)%j)) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[32,7,16,8],[nMB,0,0,nMB],4,1,wf8(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,20),heltab2x64(:,:,29))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(8),n2h32(13))
Gcoeff(:)%j = (c(8)*M(2,:)%j-c(9)*M(3,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[32,7,8,16],[nMB,0,nMB,nMB],4,1,wf8(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,21),heltab2x64(:,:,30))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(9),n2h32(14))
Gcoeff(:)%j = (-(c(11)*M(2,:)%j)-c(9)*M(3,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(34),h0tab(:,34),[32,7,8,16],[0,nMB,0,0],4,1,wf8(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(10),m3h2x32(:,22),heltab2x64(:,:,31))
Gcoeff(:)%j = (c(8)*M(1,:)%j-c(9)*M(3,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(35),h0tab(:,35),[32,8,7,16],[nMB,0,nMB,nMB],4,1,wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,23),heltab2x64(:,:,32))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(11),n2h32(15))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(9)*M(3,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(36),h0tab(:,36),[32,8,7,16],[0,nMB,0,0],4,1,wf8(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(12),m3h2x32(:,24),heltab2x64(:,:,33))
Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(37),h0tab(:,37),[32,4,16,11],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(13),m3h2x32(:,25),heltab2x64(:,:,34))
Gcoeff(:)%j = (-(c(4)*M(3,:)%j)) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(38),h0tab(:,38),[32,4,16,11],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,26),heltab2x64(:,:,35))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(14),n2h32(16))
Gcoeff(:)%j = (c(8)*M(1,:)%j-c(9)*M(3,:)%j) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(39),h0tab(:,39),[32,11,4,16],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,27),heltab2x64(:,:,36))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(15),n2h32(17))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(9)*M(3,:)%j) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(40),h0tab(:,40),[32,11,4,16],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(16),m3h2x32(:,28),heltab2x64(:,:,37))
Gcoeff(:)%j = (c(8)*M(2,:)%j-c(9)*M(3,:)%j) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(41),h0tab(:,41),[32,4,11,16],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,29),heltab2x64(:,:,38))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(17),n2h32(18))
Gcoeff(:)%j = (-(c(11)*M(2,:)%j)-c(9)*M(3,:)%j) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(42),h0tab(:,42),[32,4,11,16],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(18),m3h2x32(:,30),heltab2x64(:,:,39))
  call ol_merge(ntryL,G1H16(4),[G1H16(9)])
  call ol_merge(ntryL,G1H16(1),[G1H16(15)])
  call ol_merge(ntryL,G1H16(3),[G1H16(21)])
  call ol_merge(ntryL,G1H16(8),[G0H16(3),G0H16(2),G0H16(1)])
  call Hloop_QV_A(ntryL,G1H8(3),ex5(:),G1H4(2),m3h2x4(:,20),heltab2x8(:,:,31))
  call Hloop_Q_A(ntryL,G1H4(2),51,0,G2H4(9),n2h4(28))
  call Hloop_AV_Q(ntryL,G1H8(9),ex5(:),G1H4(5),m3h2x4(:,21),heltab2x8(:,:,32))
  call Hloop_A_Q(ntryL,G1H4(5),51,nMB,G2H4(10),n2h4(29))
  call Hloop_AV_Q(ntryL,G1H16(2),ex5(:),G1H8(21),m3h2x8(:,11),heltab2x16(:,:,23))
  call Hloop_A_Q(ntryL,G1H8(21),52,0,G2H8(5),n2h8(20))
  call Hloop_QW_A(ntryL,G1H16(4),wf4(:,4),G1H4(6),m3h4x4(:,13),heltab2x16(:,:,24))
  call Hloop_Q_A(ntryL,G1H4(6),43,0,G2H4(13),n2h4(30))
  call Hloop_AW_Q(ntryL,G1H16(1),wf4(:,4),G1H4(7),m3h4x4(:,14),heltab2x16(:,:,25))
  call Hloop_A_Q(ntryL,G1H4(7),39,nMB,G2H4(14),n2h4(31))
  call Hloop_AW_Q(ntryL,G1H16(3),wf4(:,4),G1H4(8),m3h4x4(:,15),heltab2x16(:,:,26))
  call Hloop_A_Q(ntryL,G1H4(8),39,nMB,G2H4(15),n2h4(32))
  call Hloop_VA_Q(ntryL,G1H16(8),ex3(:),G1H8(22),m3h2x8(:,12),heltab2x16(:,:,27))
  call Hloop_A_Q(ntryL,G1H8(22),52,0,G2H8(3),n2h8(21))
  call Hloop_VQ_A(ntryL,G1H32(1),ex4(:),G1H16(10),m3h2x16(:,7),heltab2x32(:,:,13))
  call Hloop_Q_A(ntryL,G1H16(10),40,nMB,G2H16(1),n2h16(15))
  call Hloop_QW_A(ntryL,G1H32(2),wf4(:,4),G1H8(7),m3h4x8(:,7),heltab2x32(:,:,14))
  call Hloop_Q_A(ntryL,G1H8(7),35,0,G2H8(4),n2h8(22))
  call Hloop_AW_Q(ntryL,G1H32(3),wf4(:,4),G1H8(8),m3h4x8(:,8),heltab2x32(:,:,15))
  call Hloop_A_Q(ntryL,G1H8(8),35,nMB,G2H8(1),n2h8(23))
  call Hloop_VA_Q(ntryL,G1H32(4),ex3(:),G1H16(11),m3h2x16(:,8),heltab2x32(:,:,16))
  call Hloop_A_Q(ntryL,G1H16(11),36,0,G2H16(2),n2h16(16))
  call Hloop_AW_Q(ntryL,G1H32(5),wf4(:,4),G1H8(12),m3h4x8(:,9),heltab2x32(:,:,17))
  call Hloop_A_Q(ntryL,G1H8(12),35,nMB,G2H8(2),n2h8(24))
  call Hloop_QW_A(ntryL,G1H32(6),wf4(:,4),G1H8(13),m3h4x8(:,10),heltab2x32(:,:,18))
  call Hloop_Q_A(ntryL,G1H8(13),35,0,G2H8(9),n2h8(25))
  call Hloop_VQ_A(ntryL,G0H16(4),ex4(:),G0H8(1),m3h2x8(:,13),heltab2x16(:,:,28))
  call Hloop_Q_A(ntryL,G0H8(1),44,nMB,G1H8(2),n2h8(26))
  call Hloop_QW_A(ntryL,G1H16(5),wf4(:,4),G1H4(11),m3h4x4(:,16),heltab2x16(:,:,29))
  call Hloop_Q_A(ntryL,G1H4(11),43,0,G2H4(17),n2h4(33))
  call Hloop_VA_Q(ntryL,G0H16(5),ex3(:),G0H8(1),m3h2x8(:,14),heltab2x16(:,:,30))
  call Hloop_A_Q(ntryL,G0H8(1),44,0,G1H8(4),n2h8(27))
  call Hloop_QW_A(ntryL,G1H16(6),wf4(:,4),G1H4(12),m3h4x4(:,17),heltab2x16(:,:,31))
  call Hloop_Q_A(ntryL,G1H4(12),51,0,G2H4(18),n2h4(34))
  call Hloop_AW_Q(ntryL,G1H16(7),wf4(:,4),G1H4(13),m3h4x4(:,18),heltab2x16(:,:,32))
  call Hloop_A_Q(ntryL,G1H4(13),51,nMB,G2H4(19),n2h4(35))
  call Hloop_VA_Q(ntryL,G1H32(7),wf8(:,6),G1H4(14),m3h8x4(:,1),heltab2x32(:,:,19))
  call Hloop_A_Q(ntryL,G1H4(14),39,nMB,G2H4(21),n2h4(36))
  call Hloop_QA_V(ntryL,G1H32(8),wf8(:,6),G1H4(17),m3h8x4(:,2),heltab2x32(:,:,20))
  call Hloop_QA_V(ntryL,G1H32(9),wf8(:,6),G1H4(18),m3h8x4(:,3),heltab2x32(:,:,21))
  call Hloop_VA_Q(ntryL,G1H32(10),wf8(:,6),G1H4(19),m3h8x4(:,4),heltab2x32(:,:,22))
  call Hloop_A_Q(ntryL,G1H4(19),39,nMB,G2H4(22),n2h4(37))
  call Hloop_AQ_V(ntryL,G1H32(11),ex4(:),G1H16(12),m3h2x16(:,9),heltab2x32(:,:,23))
  call Hloop_VQ_A(ntryL,G1H32(12),ex4(:),G1H16(13),m3h2x16(:,10),heltab2x32(:,:,24))
  call Hloop_Q_A(ntryL,G1H16(13),40,nMB,G2H16(3),n2h16(17))
  call Hloop_VA_Q(ntryL,G1H32(13),ex3(:),G1H16(14),m3h2x16(:,11),heltab2x32(:,:,25))
  call Hloop_A_Q(ntryL,G1H16(14),36,0,G2H16(4),n2h16(18))
  call Hloop_QA_V(ntryL,G1H32(14),ex3(:),G1H16(16),m3h2x16(:,12),heltab2x32(:,:,26))
  call Hloop_AQ_V(ntryL,G1H32(15),wf8(:,3),G1H4(20),m3h8x4(:,5),heltab2x32(:,:,27))
  call Hloop_VQ_A(ntryL,G1H32(16),wf8(:,3),G1H4(23),m3h8x4(:,6),heltab2x32(:,:,28))
  call Hloop_Q_A(ntryL,G1H4(23),43,0,G2H4(23),n2h4(38))
  call Hloop_QA_V(ntryL,G1H32(17),ex3(:),G1H16(17),m3h2x16(:,13),heltab2x32(:,:,29))
  call Hloop_VA_Q(ntryL,G1H32(18),ex3(:),G1H16(18),m3h2x16(:,14),heltab2x32(:,:,30))
  call Hloop_A_Q(ntryL,G1H16(18),36,0,G2H16(5),n2h16(19))
call HGT_lower_alpha_w2_OLR(G2H4(6),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(6),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(6),6,15,4)
  call ol_merge(ntryL,G2H4(6),[G2H4(17)])
  call ol_merge(ntryL,G2H4(14),[G1H4(27)])
call HGT_lower_alpha_w2_OLR(G2H4(11),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(11),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(11),6,15,4)
  call ol_merge(ntryL,G2H4(11),[G2H4(14)])
  call ol_merge(ntryL,G2H8(6),[G1H8(20)])
  call ol_merge(ntryL,G2H4(23),[G2H4(16)])
  call ol_merge(ntryL,G1H8(4),[G1H8(5)])
call HGT_w2_OLR(G1H8(6),1,1,8)
call HGT_w2_invQ_OLR(G1H8(6),2,5,8)
  call ol_merge(ntryL,G1H8(6),[G1H8(4)])
  call ol_merge(ntryL,G2H4(21),[G2H4(20),G1H4(28)])
call HGT_lower_alpha_OLR(G2H8(8),1,1,8)
call HGT_lower_alpha_invQ_OLR(G2H8(8),2,5,8)
call HGT_lower_alpha_OLR(G2H8(8),6,15,8)
  call ol_merge(ntryL,G2H8(8),[G2H8(3)])
  call ol_merge(ntryL,G2H4(22),[G2H4(24)])
  call ol_merge(ntryL,G1H4(20),[G1H4(4)])
  call ol_merge(ntryL,G1H8(2),[G1H8(10)])
  call ol_merge(ntryL,G1H4(18),[G1H4(10)])
  call ol_merge(ntryL,G1H4(17),[G1H4(22)])
  call ol_merge(ntryL,G2H8(5),[G1H8(19)])
call Hotf_4pt_reduction(G2H4(6),RedSet_4(47),mass4set(:,6),  & 
G1H4(24),G1H4(25),G1H4(26),G1H4(31),G1H4(36),4)
call HG1shiftOLR(G1H4(25),4,4)
  call Hloop_QA_V(ntryL,G2H4(7),ex3(:),G2H2(1),m3h2x2(:,37),heltab2x4(:,:,37))
call Hotf_4pt_reduction(G2H4(11),RedSet_4(13),mass4set(:,4),  & 
G1H4(32),G1H4(35),G1H4(37),G1H4(40),G1H4(2),4)
call HG1shiftOLR(G1H4(35),8,4)
  call Hloop_AQ_V(ntryL,G2H4(12),ex4(:),G2H2(3),m3h2x2(:,38),heltab2x4(:,:,38))
call HGT_w2_OLR(G1H8(1),1,1,8)
call HGT_w2_invQ_OLR(G1H8(1),2,5,8)
  call Hloop_AV_Q(ntryL,G1H8(1),ex5(:),G1H4(5),m3h2x4(:,22),heltab2x8(:,:,33))
  call Hloop_A_Q(ntryL,G1H4(5),60,0,G2H4(25),n2h4(39))
call Hotf_4pt_reduction(G2H8(6),RedSet_4(11),mass4set(:,1),  & 
G1H8(15),G1H8(16),G1H8(17),G1H8(18),G1H8(23),8)
call HG1shiftOLR(G1H8(16),8,8)
call HGT_lower_alpha_OLR(G2H8(7),1,1,8)
call HGT_lower_alpha_invQ_OLR(G2H8(7),2,5,8)
call HGT_lower_alpha_OLR(G2H8(7),6,15,8)
call Hotf_4pt_reduction(G2H8(7),RedSet_4(48),mass4set(:,5),  & 
G1H8(28),G1H8(24),G1H8(27),G1H8(29),G1H8(32),8)
call HG1shiftOLR(G1H8(24),4,8)
  call Hloop_QA_V(ntryL,G2H4(23),ex3(:),G2H2(4),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_AW_Q(ntryL,G1H8(6),wf4(:,4),G1H2(9),m3h4x2(:,12),heltab2x8(:,:,34))
  call Hloop_A_Q(ntryL,G1H2(9),47,nMB,G2H2(6),n2h2(23))
call Hotf_4pt_reduction(G2H4(21),RedSet_4(14),mass4set(:,4),  & 
G1H4(6),G1H4(7),G1H4(8),G1H4(11),G1H4(12),4)
call HG1shiftOLR(G1H4(7),8,4)
call Hotf_4pt_reduction(G2H8(8),RedSet_4(49),mass4set(:,1),  & 
G1H8(3),G1H8(9),G1H8(21),G1H8(22),G1H8(7),8)
call HG1shiftOLR(G1H8(9),8,8)
  call Hloop_AQ_V(ntryL,G2H4(22),ex4(:),G2H2(7),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_VA_Q(ntryL,G1H4(3),ex3(:),G1H2(20),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_A_Q(ntryL,G1H2(20),47,0,G2H2(9),n2h2(24))
  call Hloop_VA_Q(ntryL,G1H4(20),ex3(:),G1H2(31),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_A_Q(ntryL,G1H2(31),47,0,G2H2(10),n2h2(25))
  call Hloop_QW_A(ntryL,G1H8(2),wf4(:,4),G1H2(42),m3h4x2(:,13),heltab2x8(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(42),47,0,G2H2(12),n2h2(26))
  call Hloop_QW_A(ntryL,G1H8(11),wf4(:,4),G1H2(53),m3h4x2(:,14),heltab2x8(:,:,36))
  call Hloop_Q_A(ntryL,G1H2(53),47,0,G2H2(13),n2h2(27))
  call Hloop_VQ_A(ntryL,G1H4(9),ex4(:),G1H2(64),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(64),47,nMB,G2H2(16),n2h2(28))
  call Hloop_VQ_A(ntryL,G1H4(18),ex4(:),G1H2(75),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_Q_A(ntryL,G1H2(75),47,nMB,G2H2(17),n2h2(29))
  call Hloop_AW_Q(ntryL,G1H8(14),wf4(:,4),G1H2(86),m3h4x2(:,15),heltab2x8(:,:,37))
  call Hloop_A_Q(ntryL,G1H2(86),47,nMB,G2H2(19),n2h2(30))
  call Hloop_UV_W(ntryL,G1H4(15),43,ex5(:),16,G2H2(20),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_UV_W(ntryL,G1H4(16),43,ex5(:),16,G2H2(23),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_UV_W(ntryL,G1H4(21),39,ex5(:),16,G2H2(24),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_UV_W(ntryL,G1H4(17),39,ex5(:),16,G2H2(26),m3h2x2(:,48),heltab2x4(:,:,48))
call Hotf_4pt_reduction(G2H8(5),RedSet_4(10),mass4set(:,1),  & 
G1H8(8),G1H8(12),G1H8(13),G1H8(20),G1H8(5),8)
call HG1shiftOLR(G1H8(12),8,8)
  call Hloop_AW_Q(ntryL,G1H8(25),wf4(:,4),G1H2(97),m3h4x2(:,16),heltab2x8(:,:,38))
  call Hloop_A_Q(ntryL,G1H2(97),55,nMB,G2H2(27),n2h2(31))
  call Hloop_AW_Q(ntryL,G1H8(26),wf4(:,4),G1H2(108),m3h4x2(:,17),heltab2x8(:,:,39))
  call Hloop_A_Q(ntryL,G1H2(108),55,nMB,G2H2(30),n2h2(32))
  call Hloop_AW_Q(ntryL,G1H8(30),wf4(:,4),G1H2(4),m3h4x2(:,18),heltab2x8(:,:,40))
  call Hloop_A_Q(ntryL,G1H2(4),55,nMB,G2H2(31),n2h2(33))
  call Hloop_AW_Q(ntryL,G1H8(31),wf4(:,4),G1H2(5),m3h4x2(:,19),heltab2x8(:,:,41))
  call Hloop_A_Q(ntryL,G1H2(5),55,nMB,G2H2(34),n2h2(34))
  call Hloop_AV_Q(ntryL,G1H4(33),ex5(:),G1H2(10),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_A_Q(ntryL,G1H2(10),55,nMB,G2H2(35),n2h2(35))
  call Hloop_AV_Q(ntryL,G1H4(34),ex5(:),G1H2(11),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_A_Q(ntryL,G1H2(11),55,nMB,G2H2(37),n2h2(36))
  call Hloop_AV_Q(ntryL,G1H4(38),ex5(:),G1H2(15),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_A_Q(ntryL,G1H2(15),55,nMB,G2H2(40),n2h2(37))
  call Hloop_AV_Q(ntryL,G1H4(39),ex5(:),G1H2(16),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_A_Q(ntryL,G1H2(16),55,nMB,G2H2(42),n2h2(38))
  call Hloop_QA_V(ntryL,G2H4(9),ex3(:),G2H2(45),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_AQ_V(ntryL,G2H4(10),ex4(:),G2H2(46),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_QA_V(ntryL,G2H4(13),ex3(:),G2H2(47),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_AQ_V(ntryL,G2H4(15),ex4(:),G2H2(48),m3h2x2(:,56),heltab2x4(:,:,56))
call Hotf_4pt_reduction(G2H16(1),RedSet_4(5),mass4set(:,5),  & 
G1H16(19),G1H16(20),G1H16(22),G1H16(23),G1H16(24),16)
call HG1shiftOLR(G1H16(20),20,16)
  call Hloop_QA_V(ntryL,G2H8(4),wf4(:,5),G2H2(49),m3h4x2(:,20),heltab2x8(:,:,42))
  call Hloop_AQ_V(ntryL,G2H8(1),ex4(:),G2H4(26),m3h2x4(:,23),heltab2x8(:,:,43))
call Hotf_4pt_reduction(G2H16(2),RedSet_4(3),mass4set(:,1),  & 
G1H16(9),G1H16(15),G1H16(21),G1H16(2),G1H16(4),16)
call HG1shiftOLR(G1H16(15),24,16)
  call Hloop_AQ_V(ntryL,G2H8(2),wf4(:,10),G2H2(50),m3h4x2(:,21),heltab2x8(:,:,44))
  call Hloop_QA_V(ntryL,G2H8(9),ex3(:),G2H4(1),m3h2x4(:,24),heltab2x8(:,:,45))
  call Hloop_QA_V(ntryL,G2H4(18),ex3(:),G2H2(51),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_AQ_V(ntryL,G2H4(19),ex4(:),G2H2(52),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_VA_Q(ntryL,G1H16(12),wf8(:,6),G1H2(21),m3h8x2(:,1),heltab2x16(:,:,33))
  call Hloop_A_Q(ntryL,G1H2(21),47,nMB,G2H2(53),n2h2(39))
  call Hloop_QA_V(ntryL,G2H16(3),wf8(:,6),G2H2(54),m3h8x2(:,2),heltab2x16(:,:,34))
call Hotf_4pt_reduction(G2H16(4),RedSet_4(2),mass4set(:,2),  & 
G1H16(1),G1H16(3),G1H16(8),G1H16(10),G1H16(11),16)
call HG1shiftOLR(G1H16(3),11,16)
  call Hloop_UV_W(ntryL,G1H16(16),36,ex5(:),16,G2H8(3),m3h2x8(:,15),heltab2x16(:,:,35))
  call Hloop_VQ_A(ntryL,G1H16(17),wf8(:,3),G1H2(22),m3h8x2(:,3),heltab2x16(:,:,36))
  call Hloop_Q_A(ntryL,G1H2(22),47,0,G2H2(55),n2h2(40))
  call Hloop_AQ_V(ntryL,G2H16(5),wf8(:,3),G2H2(56),m3h8x2(:,4),heltab2x16(:,:,37))
  call Hloop_QV_A(ntryL,G1H4(24),ex5(:),G1H2(26),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(26),59,0,G2H2(57),n2h2(41))
call HGT_raise_alpha_OLR(G1H4(25),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(25),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(25),ex3(:),G1H2(27),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_QV_A(ntryL,G1H4(31),ex5(:),G1H2(32),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_Q_A(ntryL,G1H2(32),59,0,G2H2(58),n2h2(42))
  call Hloop_QV_A(ntryL,G1H4(36),ex5(:),G1H2(33),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_Q_A(ntryL,G1H2(33),59,0,G2H2(59),n2h2(43))
  call Hloop_AV_Q(ntryL,G1H4(32),ex5(:),G1H2(37),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_A_Q(ntryL,G1H2(37),55,nMB,G2H2(60),n2h2(44))
call HGT_raise_alpha_OLR(G1H4(35),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(35),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(35),ex4(:),G1H2(38),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_AV_Q(ntryL,G1H4(40),ex5(:),G1H2(43),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_A_Q(ntryL,G1H2(43),55,nMB,G2H2(61),n2h2(45))
  call Hloop_AV_Q(ntryL,G1H4(2),ex5(:),G1H2(44),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_A_Q(ntryL,G1H2(44),55,nMB,G2H2(62),n2h2(46))
  call Hloop_AW_Q(ntryL,G1H8(15),wf4(:,4),G1H2(48),m3h4x2(:,22),heltab2x8(:,:,46))
  call Hloop_A_Q(ntryL,G1H2(48),55,nMB,G2H2(63),n2h2(47))
call HGT_raise_alpha_OLR(G1H8(16),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(16),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(16),ex4(:),G1H4(13),m3h2x4(:,25),heltab2x8(:,:,47))
  call Hloop_AW_Q(ntryL,G1H8(18),wf4(:,4),G1H2(49),m3h4x2(:,23),heltab2x8(:,:,48))
  call Hloop_A_Q(ntryL,G1H2(49),55,nMB,G2H2(64),n2h2(48))
  call Hloop_AW_Q(ntryL,G1H8(23),wf4(:,4),G1H2(54),m3h4x2(:,24),heltab2x8(:,:,49))
  call Hloop_A_Q(ntryL,G1H2(54),55,nMB,G2H2(65),n2h2(49))
  call Hloop_QW_A(ntryL,G1H8(28),wf4(:,4),G1H2(55),m3h4x2(:,25),heltab2x8(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(55),59,0,G2H2(66),n2h2(50))
call HGT_raise_alpha_OLR(G1H8(24),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(24),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(24),ex3(:),G1H4(14),m3h2x4(:,26),heltab2x8(:,:,51))
  call Hloop_QW_A(ntryL,G1H8(29),wf4(:,4),G1H2(59),m3h4x2(:,26),heltab2x8(:,:,52))
  call Hloop_Q_A(ntryL,G1H2(59),59,0,G2H2(67),n2h2(51))
  call Hloop_QW_A(ntryL,G1H8(32),wf4(:,4),G1H2(60),m3h4x2(:,27),heltab2x8(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(60),59,0,G2H2(68),n2h2(52))
  call Hloop_AV_Q(ntryL,G1H4(6),ex5(:),G1H2(65),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_A_Q(ntryL,G1H2(65),55,nMB,G2H2(69),n2h2(53))
call HGT_raise_alpha_OLR(G1H4(7),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(7),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(7),ex4(:),G1H2(66),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_AV_Q(ntryL,G1H4(11),ex5(:),G1H2(70),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_A_Q(ntryL,G1H2(70),55,nMB,G2H2(70),n2h2(54))
  call Hloop_AV_Q(ntryL,G1H4(12),ex5(:),G1H2(71),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_A_Q(ntryL,G1H2(71),55,nMB,G2H2(71),n2h2(55))
  call Hloop_AW_Q(ntryL,G1H8(3),wf4(:,4),G1H2(76),m3h4x2(:,28),heltab2x8(:,:,54))
  call Hloop_A_Q(ntryL,G1H2(76),55,nMB,G2H2(72),n2h2(56))
call HGT_raise_alpha_OLR(G1H8(9),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(9),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(9),ex4(:),G1H4(19),m3h2x4(:,27),heltab2x8(:,:,55))
  call Hloop_AW_Q(ntryL,G1H8(22),wf4(:,4),G1H2(77),m3h4x2(:,29),heltab2x8(:,:,56))
  call Hloop_A_Q(ntryL,G1H2(77),55,nMB,G2H2(73),n2h2(57))
  call Hloop_AW_Q(ntryL,G1H8(7),wf4(:,4),G1H2(81),m3h4x2(:,30),heltab2x8(:,:,57))
  call Hloop_A_Q(ntryL,G1H2(81),55,nMB,G2H2(74),n2h2(58))
  call Hloop_AW_Q(ntryL,G1H8(8),wf4(:,4),G1H2(82),m3h4x2(:,31),heltab2x8(:,:,58))
  call Hloop_A_Q(ntryL,G1H2(82),55,nMB,G2H2(75),n2h2(59))
call HGT_raise_alpha_OLR(G1H8(12),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(12),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(12),ex4(:),G1H4(23),m3h2x4(:,28),heltab2x8(:,:,59))
  call Hloop_AW_Q(ntryL,G1H8(20),wf4(:,4),G1H2(87),m3h4x2(:,32),heltab2x8(:,:,60))
  call Hloop_A_Q(ntryL,G1H2(87),55,nMB,G2H2(76),n2h2(60))
  call Hloop_AW_Q(ntryL,G1H8(5),wf4(:,4),G1H2(88),m3h4x2(:,33),heltab2x8(:,:,61))
  call Hloop_A_Q(ntryL,G1H2(88),55,nMB,G2H2(77),n2h2(61))
  call Hloop_QW_A(ntryL,G1H16(19),wf4(:,4),G1H4(27),m3h4x4(:,19),heltab2x16(:,:,38))
  call Hloop_Q_A(ntryL,G1H4(27),43,0,G2H4(3),n2h4(43))
call HGT_raise_alpha_OLR(G1H16(20),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(20),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(20),wf4(:,5),G1H4(28),m3h4x4(:,20),heltab2x16(:,:,39))
  call Hloop_QW_A(ntryL,G1H16(23),wf4(:,4),G1H4(4),m3h4x4(:,21),heltab2x16(:,:,40))
  call Hloop_Q_A(ntryL,G1H4(4),43,0,G2H4(5),n2h4(44))
  call Hloop_QW_A(ntryL,G1H16(24),wf4(:,4),G1H4(10),m3h4x4(:,22),heltab2x16(:,:,41))
  call Hloop_Q_A(ntryL,G1H4(10),43,0,G2H4(8),n2h4(45))
  call Hloop_AW_Q(ntryL,G1H16(9),wf4(:,4),G1H4(22),m3h4x4(:,23),heltab2x16(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(22),39,nMB,G2H4(17),n2h4(46))
call HGT_raise_alpha_OLR(G1H16(15),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(15),2,5,16)
  call Hloop_VQ_A(ntryL,G1H16(15),wf4(:,10),G1H4(5),m3h4x4(:,24),heltab2x16(:,:,43))
  call Hloop_AW_Q(ntryL,G1H16(2),wf4(:,4),G1H4(3),m3h4x4(:,25),heltab2x16(:,:,44))
  call Hloop_A_Q(ntryL,G1H4(3),39,nMB,G2H4(14),n2h4(47))
  call Hloop_AW_Q(ntryL,G1H16(4),wf4(:,4),G1H4(20),m3h4x4(:,26),heltab2x16(:,:,45))
  call Hloop_A_Q(ntryL,G1H4(20),39,nMB,G2H4(16),n2h4(48))
  call Hloop_AV_Q(ntryL,G1H16(1),ex5(:),G1H8(4),m3h2x8(:,16),heltab2x16(:,:,46))
  call Hloop_A_Q(ntryL,G1H8(4),52,0,G2H8(6),n2h8(32))
call HGT_raise_alpha_OLR(G1H16(3),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(3),2,5,16)
  call Hloop_VQ_A(ntryL,G1H16(3),wf8(:,3),G1H2(92),m3h8x2(:,5),heltab2x16(:,:,47))
  call Hloop_AV_Q(ntryL,G1H16(10),ex5(:),G1H8(10),m3h2x8(:,17),heltab2x16(:,:,48))
  call Hloop_A_Q(ntryL,G1H8(10),52,0,G2H8(7),n2h8(33))
  call Hloop_AV_Q(ntryL,G1H16(11),ex5(:),G1H8(19),m3h2x8(:,18),heltab2x16(:,:,49))
  call Hloop_A_Q(ntryL,G1H8(19),52,0,G2H8(8),n2h8(34))
  call ol_merge(ntryL,G2H2(49),[G2H2(33),G2H2(2),G1H2(107),G1H2(8)])
  call ol_merge(ntryL,G2H2(50),[G2H2(29),G2H2(5),G1H2(96),G1H2(19)])
  call ol_merge(ntryL,G2H2(54),[G2H2(8),G1H2(30)])
  call ol_merge(ntryL,G2H2(56),[G2H2(11),G1H2(41)])
call HGT_OLR(G2H2(14),1,1,2)
call HGT_invQ_OLR(G2H2(14),2,5,2)
call HGT_OLR(G2H2(14),6,15,2)
  call ol_merge(ntryL,G2H2(14),[G2H2(52)])
  call ol_merge(ntryL,G2H2(15),[G1H2(52)])
  call ol_merge(ntryL,G2H2(55),[G2H2(18),G1H2(63)])
call HGT_OLR(G2H2(21),1,1,2)
call HGT_invQ_OLR(G2H2(21),2,5,2)
call HGT_OLR(G2H2(21),6,15,2)
  call ol_merge(ntryL,G2H2(21),[G2H2(51)])
  call ol_merge(ntryL,G2H2(22),[G1H2(74)])
  call ol_merge(ntryL,G2H2(53),[G2H2(25),G1H2(85)])
  call ol_merge(ntryL,G2H2(48),[G1H2(39)])
call HGT_lower_alpha_w2_OLR(G2H2(28),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(28),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(28),6,15,2)
  call ol_merge(ntryL,G2H2(28),[G2H2(48)])
  call ol_merge(ntryL,G2H2(47),[G1H2(28)])
call HGT_lower_alpha_w2_OLR(G2H2(32),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(32),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(32),6,15,2)
  call ol_merge(ntryL,G2H2(32),[G2H2(47)])
call HGT_w2_OLR(G1H4(29),1,1,4)
call HGT_w2_invQ_OLR(G1H4(29),2,5,4)
  call ol_merge(ntryL,G2H4(25),[G1H4(29)])
  call ol_merge(ntryL,G2H2(41),[G2H2(36)])
  call ol_merge(ntryL,G2H2(44),[G2H2(43),G2H2(39),G2H2(38)])
  call ol_merge(ntryL,G2H2(6),[G1H2(83)])
call HGT_w2_OLR(G1H2(1),1,1,2)
call HGT_w2_invQ_OLR(G1H2(1),2,5,2)
  call ol_merge(ntryL,G2H2(6),[G1H2(1)])
call HGT_w2_OLR(G1H2(2),1,1,2)
call HGT_w2_invQ_OLR(G1H2(2),2,5,2)
  call ol_merge(ntryL,G1H2(2),[G1H2(89)])
  call ol_merge(ntryL,G2H2(45),[G1H2(6)])
  call ol_merge(ntryL,G2H2(1),[G1H2(7)])
  call ol_merge(ntryL,G1H2(113),[G1H2(14)])
  call ol_merge(ntryL,G2H2(46),[G1H2(17)])
  call ol_merge(ntryL,G2H2(3),[G1H2(18)])
  call ol_merge(ntryL,G1H2(102),[G1H2(25)])
  call ol_merge(ntryL,G2H2(4),[G1H2(29)])
  call ol_merge(ntryL,G2H2(7),[G1H2(40)])
  call ol_merge(ntryL,G2H2(9),[G1H2(50)])
  call ol_merge(ntryL,G2H2(10),[G1H2(51)])
  call ol_merge(ntryL,G2H2(12),[G1H2(61)])
  call ol_merge(ntryL,G2H2(13),[G1H2(62)])
  call ol_merge(ntryL,G2H2(16),[G1H2(72)])
  call ol_merge(ntryL,G2H2(17),[G1H2(73)])
  call ol_merge(ntryL,G2H2(19),[G1H2(84)])
  call ol_merge(ntryL,G2H2(20),[G1H2(94)])
  call ol_merge(ntryL,G2H2(23),[G1H2(95)])
  call ol_merge(ntryL,G2H2(24),[G1H2(105)])
  call ol_merge(ntryL,G2H2(26),[G1H2(106)])
  call ol_merge(ntryL,G2H2(77),[G2H2(31)])
  call ol_merge(ntryL,G2H2(65),[G2H2(34)])
  call ol_merge(ntryL,G2H2(62),[G2H2(40)])
  call ol_merge(ntryL,G2H2(71),[G2H2(42)])
call Hotf_4pt_reduction(G2H2(49),RedSet_4(18),mass4set(:,3),  & 
G1H2(93),G1H2(98),G1H2(99),G1H2(103),G1H2(104),2)
call HG1shiftOLR(G1H2(98),8,2)
call Hotf_4pt_reduction(G2H2(50),RedSet_4(22),mass4set(:,5),  & 
G1H2(109),G1H2(110),G1H2(9),G1H2(20),G1H2(31),2)
call HG1shiftOLR(G1H2(110),4,2)
call Hotf_4pt_reduction(G2H2(54),RedSet_4(26),mass4set(:,5),  & 
G1H2(42),G1H2(53),G1H2(64),G1H2(75),G1H2(86),2)
call HG1shiftOLR(G1H2(53),16,2)
call Hotf_4pt_reduction(G2H2(56),RedSet_4(30),mass4set(:,2),  & 
G1H2(97),G1H2(108),G1H2(4),G1H2(5),G1H2(10),2)
call HG1shiftOLR(G1H2(108),16,2)
call Hotf_4pt_reduction(G2H2(14),RedSet_4(50),mass4set(:,5),  & 
G1H2(11),G1H2(15),G1H2(16),G1H2(21),G1H2(22),2)
call HG1shiftOLR(G1H2(15),4,2)
call Hotf_4pt_reduction(G2H2(15),RedSet_4(33),mass4set(:,5),  & 
G1H2(26),G1H2(32),G1H2(33),G1H2(37),G1H2(43),2)
call HG1shiftOLR(G1H2(32),16,2)
call HGT_OLR(G2H4(2),1,1,4)
call HGT_invQ_OLR(G2H4(2),2,5,4)
call HGT_OLR(G2H4(2),6,15,4)
call Hotf_4pt_reduction(G2H4(2),RedSet_4(51),mass4set(:,1),  & 
G1H4(9),G1H4(18),G1H4(15),G1H4(16),G1H4(21),4)
call HG1shiftOLR(G1H4(18),3,4)
call Hotf_4pt_reduction(G2H2(55),RedSet_4(30),mass4set(:,2),  & 
G1H2(44),G1H2(48),G1H2(49),G1H2(54),G1H2(55),2)
call HG1shiftOLR(G1H2(48),16,2)
call Hotf_4pt_reduction(G2H2(21),RedSet_4(52),mass4set(:,3),  & 
G1H2(59),G1H2(60),G1H2(65),G1H2(70),G1H2(71),2)
call HG1shiftOLR(G1H2(60),8,2)
call Hotf_4pt_reduction(G2H2(22),RedSet_4(33),mass4set(:,7),  & 
G1H2(76),G1H2(77),G1H2(81),G1H2(82),G1H2(87),2)
call HG1shiftOLR(G1H2(77),16,2)
call HGT_OLR(G2H4(4),1,1,4)
call HGT_invQ_OLR(G2H4(4),2,5,4)
call HGT_OLR(G2H4(4),6,15,4)
call Hotf_4pt_reduction(G2H4(4),RedSet_4(53),mass4set(:,3),  & 
G1H4(17),G1H4(33),G1H4(34),G1H4(38),G1H4(39),4)
call HG1shiftOLR(G1H4(33),3,4)
call Hotf_4pt_reduction(G2H2(53),RedSet_4(26),mass4set(:,7),  & 
G1H2(88),G1H2(107),G1H2(8),G1H2(96),G1H2(19),2)
call HG1shiftOLR(G1H2(107),16,2)
call Hotf_4pt_reduction(G2H2(28),RedSet_4(28),mass4set(:,5),  & 
G1H2(30),G1H2(41),G1H2(52),G1H2(63),G1H2(74),2)
call HG1shiftOLR(G1H2(41),16,2)
call Hotf_4pt_reduction(G2H2(32),RedSet_4(24),mass4set(:,6),  & 
G1H2(85),G1H2(39),G1H2(28),G1H2(83),G1H2(1),2)
call HG1shiftOLR(G1H2(39),16,2)
call Hotf_4pt_reduction(G2H4(25),RedSet_4(54),mass4set(:,8),  & 
G1H4(24),G1H4(25),G1H4(31),G1H4(36),G1H4(32),4)
call HG1shiftOLR(G1H4(25),3,4)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(41),ex4(:),G2tensor(1),m3h2x1(:,45),heltab2x2(:,:,45))
call HGT_w2_OLR(G1H4(30),1,1,4)
call HGT_w2_invQ_OLR(G1H4(30),2,5,4)
  call Hloop_AW_Q(ntryL,G1H4(30),wf4(:,4),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(3),n2h1(37))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(44),ex4(:),G2tensor(5),m3h2x1(:,46),heltab2x2(:,:,46))
call HGT_w2_OLR(G1H4(1),1,1,4)
call HGT_w2_invQ_OLR(G1H4(1),2,5,4)
  call Hloop_AW_Q(ntryL,G1H4(1),wf4(:,4),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),3,nMB,G2tensor(9),n2h1(38))
call Hotf_4pt_reduction(G2H2(6),RedSet_4(40),mass4set(:,9),  & 
G1H2(89),G1H2(6),G1H2(7),G1H2(14),G1H2(17),2)
call HG1shiftOLR(G1H2(6),16,2)
  call Hloop_AV_Q(ntryL,G1H2(2),ex5(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(13),n2h1(39))
call HGT_w2_OLR(G1H2(3),1,1,2)
call HGT_w2_invQ_OLR(G1H2(3),2,5,2)
  call Hloop_AV_Q(ntryL,G1H2(3),ex5(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(17),n2h1(40))
call Hotf_4pt_reduction(G2H2(45),RedSet_4(16),mass4set(:,8),  & 
G1H2(18),G1H2(25),G1H2(29),G1H2(40),G1H2(50),2)
call HG1shiftOLR(G1H2(25),8,2)
call Hotf_4pt_reduction(G2H2(1),RedSet_4(17),mass4set(:,3),  & 
G1H2(51),G1H2(61),G1H2(62),G1H2(72),G1H2(73),2)
call HG1shiftOLR(G1H2(61),8,2)
  call Hloop_VQ_A(ntryL,G1H2(12),ex4(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(21),n2h1(41))
  call Hloop_VQ_A(ntryL,G1H2(13),ex4(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(25),n2h1(42))
  call Hloop_VQ_A(ntryL,G1H2(113),ex4(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(29),n2h1(43))
call Hotf_4pt_reduction(G2H2(46),RedSet_4(20),mass4set(:,10),  & 
G1H2(84),G1H2(94),G1H2(95),G1H2(105),G1H2(106),2)
call HG1shiftOLR(G1H2(94),4,2)
call Hotf_4pt_reduction(G2H2(3),RedSet_4(21),mass4set(:,5),  & 
G1H2(2),G1H2(3),G1H2(12),G1H2(13),G1H2(113),2)
call HG1shiftOLR(G1H2(3),4,2)
  call Hloop_VA_Q(ntryL,G1H2(23),ex3(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(33),n2h1(44))
  call Hloop_VA_Q(ntryL,G1H2(24),ex3(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(37),n2h1(45))
  call Hloop_VA_Q(ntryL,G1H2(102),ex3(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(41),n2h1(46))
call Hotf_4pt_reduction(G2H2(4),RedSet_4(25),mass4set(:,2),  & 
G1H2(23),G1H2(24),G1H2(102),G1H2(114),G1H2(115),2)
call HG1shiftOLR(G1H2(24),16,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(34),47,ex5(:),16,G2tensor(45),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(35),47,ex5(:),16,G2tensor(46),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(36),47,ex5(:),16,G2tensor(47),m3h2x1(:,57),heltab2x2(:,:,57))
call Hotf_4pt_reduction(G2H2(7),RedSet_4(29),mass4set(:,5),  & 
G1H2(34),G1H2(35),G1H2(36),G1H2(116),G1H2(117),2)
call HG1shiftOLR(G1H2(35),16,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(45),47,ex5(:),16,G2tensor(48),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(46),47,ex5(:),16,G2tensor(49),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(47),47,ex5(:),16,G2tensor(50),m3h2x1(:,60),heltab2x2(:,:,60))
call Hotf_4pt_reduction(G2H2(9),RedSet_4(32),mass4set(:,6),  & 
G1H2(45),G1H2(46),G1H2(47),G1H2(118),G1H2(119),2)
call HG1shiftOLR(G1H2(46),16,2)
call Hotf_4pt_reduction(G2H2(10),RedSet_4(25),mass4set(:,2),  & 
G1H2(120),G1H2(121),G1H2(122),G1H2(123),G1H2(124),2)
call HG1shiftOLR(G1H2(121),16,2)
  call Hloop_AV_Q(ntryL,G1H2(56),ex5(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(51),n2h1(47))
  call Hloop_AV_Q(ntryL,G1H2(57),ex5(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(52),n2h1(48))
  call Hloop_AV_Q(ntryL,G1H2(58),ex5(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(53),n2h1(49))
call Hotf_4pt_reduction(G2H2(12),RedSet_4(35),mass4set(:,5),  & 
G1H2(56),G1H2(57),G1H2(58),G1H2(125),G1H2(126),2)
call HG1shiftOLR(G1H2(57),16,2)
call Hotf_4pt_reduction(G2H2(13),RedSet_4(36),mass4set(:,5),  & 
G1H2(127),G1H2(128),G1H2(129),G1H2(130),G1H2(131),2)
call HG1shiftOLR(G1H2(128),16,2)
  call Hloop_QV_A(ntryL,G1H2(67),ex5(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(54),n2h1(50))
  call Hloop_QV_A(ntryL,G1H2(68),ex5(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(55),n2h1(51))
  call Hloop_QV_A(ntryL,G1H2(69),ex5(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(56),n2h1(52))
call Hotf_4pt_reduction(G2H2(16),RedSet_4(38),mass4set(:,9),  & 
G1H2(67),G1H2(68),G1H2(69),G1H2(132),G1H2(133),2)
call HG1shiftOLR(G1H2(68),16,2)
call Hotf_4pt_reduction(G2H2(17),RedSet_4(29),mass4set(:,7),  & 
G1H2(134),G1H2(135),G1H2(136),G1H2(137),G1H2(138),2)
call HG1shiftOLR(G1H2(135),16,2)
  call Hloop_QV_A(ntryL,G1H2(78),ex5(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(57),n2h1(53))
  call Hloop_QV_A(ntryL,G1H2(79),ex5(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(58),n2h1(54))
  call Hloop_QV_A(ntryL,G1H2(80),ex5(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(59),n2h1(55))
call Hotf_4pt_reduction(G2H2(19),RedSet_4(36),mass4set(:,7),  & 
G1H2(78),G1H2(79),G1H2(80),G1H2(139),G1H2(140),2)
call HG1shiftOLR(G1H2(79),16,2)
  call Hloop_AV_Q(ntryL,G1H2(90),ex5(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(60),n2h1(56))
  call Hloop_AV_Q(ntryL,G1H2(91),ex5(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(61),n2h1(57))
call Hotf_4pt_reduction(G2H2(20),RedSet_4(42),mass4set(:,6),  & 
G1H2(90),G1H2(91),G1H2(141),G1H2(142),G1H2(143),2)
call HG1shiftOLR(G1H2(91),4,2)
call Hotf_4pt_reduction(G2H2(23),RedSet_4(43),mass4set(:,2),  & 
G1H2(144),G1H2(145),G1H2(146),G1H2(147),G1H2(148),2)
call HG1shiftOLR(G1H2(145),4,2)
  call Hloop_VA_Q(ntryL,G1H2(100),ex3(:),G1H1(1),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(62),n2h1(58))
  call Hloop_VA_Q(ntryL,G1H2(101),ex3(:),G1H1(1),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(63),n2h1(59))
call Hotf_4pt_reduction(G2H2(24),RedSet_4(45),mass4set(:,8),  & 
G1H2(100),G1H2(101),G1H2(149),G1H2(150),G1H2(151),2)
call HG1shiftOLR(G1H2(101),8,2)
call Hotf_4pt_reduction(G2H2(26),RedSet_4(14),mass4set(:,3),  & 
G1H2(152),G1H2(153),G1H2(154),G1H2(155),G1H2(156),2)
call HG1shiftOLR(G1H2(153),8,2)
  call Hloop_VQ_A(ntryL,G1H2(111),ex4(:),G1H1(1),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(64),n2h1(60))
  call Hloop_VQ_A(ntryL,G1H2(112),ex4(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(65),n2h1(61))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(77),ex4(:),G2tensor(66),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(65),ex4(:),G2tensor(67),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(62),ex4(:),G2tensor(68),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(71),ex4(:),G2tensor(69),m3h2x1(:,79),heltab2x2(:,:,79))
call Hotf_4pt_reduction(G2H4(26),RedSet_4(6),mass4set(:,5),  & 
G1H4(35),G1H4(40),G1H4(2),G1H4(6),G1H4(7),4)
call HG1shiftOLR(G1H4(40),20,4)
call Hotf_4pt_reduction(G2H4(1),RedSet_4(8),mass4set(:,3),  & 
G1H4(11),G1H4(12),G1H4(27),G1H4(4),G1H4(10),4)
call HG1shiftOLR(G1H4(12),24,4)
call Hotf_4pt_reduction(G2H8(3),RedSet_4(2),mass4set(:,2),  & 
G1H8(1),G1H8(6),G1H8(2),G1H8(11),G1H8(14),8)
call HG1shiftOLR(G1H8(6),11,8)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(57),ex3(:),G2tensor(70),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(59),ex3(:),G2tensor(71),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(60),ex4(:),G2tensor(72),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(63),ex4(:),G2tensor(73),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(66),ex3(:),G2tensor(74),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(68),ex3(:),G2tensor(75),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(69),ex4(:),G2tensor(76),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(72),ex4(:),G2tensor(77),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(74),ex4(:),G2tensor(78),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(75),ex4(:),G2tensor(79),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(3),wf4(:,5),G2tensor(80),m3h4x1(:,3),heltab2x4(:,:,73))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(8),wf4(:,5),G2tensor(81),m3h4x1(:,4),heltab2x4(:,:,74))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(17),wf4(:,10),G2tensor(82),m3h4x1(:,5),heltab2x4(:,:,75))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(16),wf4(:,10),G2tensor(83),m3h4x1(:,6),heltab2x4(:,:,76))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(6),wf8(:,3),G2tensor(84),m3h8x1(:,1),heltab2x8(:,:,62))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(8),wf8(:,3),G2tensor(85),m3h8x1(:,2),heltab2x8(:,:,63))
  call Hloop_VQ_A(ntryL,G1H2(93),ex4(:),G1H1(1),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(86),n2h1(62))
  call Hloop_VQ_A(ntryL,G1H2(98),ex4(:),G1H1(1),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(87),n2h1(63))
  call Hloop_VQ_A(ntryL,G1H2(104),ex4(:),G1H1(1),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(88),n2h1(64))
  call Hloop_VA_Q(ntryL,G1H2(109),ex3(:),G1H1(1),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(89),n2h1(65))
  call Hloop_VA_Q(ntryL,G1H2(110),ex3(:),G1H1(1),m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(90),n2h1(66))
  call Hloop_VA_Q(ntryL,G1H2(31),ex3(:),G1H1(1),m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(91),n2h1(67))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(42),47,ex5(:),16,G2tensor(92),m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(53),0,ex5(:),16,G2tensor(93),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(86),47,ex5(:),16,G2tensor(94),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(97),47,ex5(:),16,G2tensor(95),m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(108),0,ex5(:),16,G2tensor(96),m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(10),47,ex5(:),16,G2tensor(97),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hloop_VA_Q(ntryL,G1H2(11),ex3(:),G1H1(1),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(98),n2h1(70))
  call Hloop_VA_Q(ntryL,G1H2(15),ex3(:),G1H1(1),m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(99),n2h1(71))
  call Hloop_VA_Q(ntryL,G1H2(22),ex3(:),G1H1(1),m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(100),n2h1(72))
  call Hloop_AV_Q(ntryL,G1H2(26),ex5(:),G1H1(1),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(101),n2h1(73))
  call Hloop_AV_Q(ntryL,G1H2(32),ex5(:),G1H1(1),m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(102),n2h1(74))
  call Hloop_AV_Q(ntryL,G1H2(43),ex5(:),G1H1(1),m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(103),n2h1(75))
  call Hloop_QW_A(ntryL,G1H4(9),wf4(:,4),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(104),n2h1(76))
  call Hloop_QW_A(ntryL,G1H4(18),wf4(:,4),G1H1(1),m3h4x1(:,8),heltab2x4(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),3,0,G2tensor(105),n2h1(77))
  call Hloop_QW_A(ntryL,G1H4(21),wf4(:,4),G1H1(1),m3h4x1(:,9),heltab2x4(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(106),n2h1(78))
  call Hloop_QV_A(ntryL,G1H2(44),ex5(:),G1H1(1),m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(107),n2h1(79))
  call Hloop_QV_A(ntryL,G1H2(48),ex5(:),G1H1(1),m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(108),n2h1(80))
  call Hloop_QV_A(ntryL,G1H2(55),ex5(:),G1H1(1),m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(109),n2h1(81))
  call Hloop_VQ_A(ntryL,G1H2(59),ex4(:),G1H1(1),m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(110),n2h1(82))
  call Hloop_VQ_A(ntryL,G1H2(60),ex4(:),G1H1(1),m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(111),n2h1(83))
  call Hloop_VQ_A(ntryL,G1H2(71),ex4(:),G1H1(1),m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(112),n2h1(84))
  call Hloop_QV_A(ntryL,G1H2(76),ex5(:),G1H1(1),m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(113),n2h1(85))
  call Hloop_QV_A(ntryL,G1H2(77),ex5(:),G1H1(1),m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(114),n2h1(86))
  call Hloop_QV_A(ntryL,G1H2(87),ex5(:),G1H1(1),m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(115),n2h1(87))
  call Hloop_AW_Q(ntryL,G1H4(17),wf4(:,4),G1H1(1),m3h4x1(:,10),heltab2x4(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(116),n2h1(88))
  call Hloop_AW_Q(ntryL,G1H4(33),wf4(:,4),G1H1(1),m3h4x1(:,11),heltab2x4(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),3,nMB,G2tensor(117),n2h1(89))
  call Hloop_AW_Q(ntryL,G1H4(39),wf4(:,4),G1H1(1),m3h4x1(:,12),heltab2x4(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(118),n2h1(90))
  call Hloop_AV_Q(ntryL,G1H2(88),ex5(:),G1H1(1),m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(119),n2h1(91))
  call Hloop_AV_Q(ntryL,G1H2(107),ex5(:),G1H1(1),m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(120),n2h1(92))
  call Hloop_AV_Q(ntryL,G1H2(19),ex5(:),G1H1(1),m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(121),n2h1(93))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(30),47,ex5(:),16,G2tensor(122),m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(41),0,ex5(:),16,G2tensor(123),m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(74),47,ex5(:),16,G2tensor(124),m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(85),47,ex5(:),16,G2tensor(125),m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(39),0,ex5(:),16,G2tensor(126),m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(1),47,ex5(:),16,G2tensor(127),m3h2x1(:,125),heltab2x2(:,:,125))
  call Hloop_AW_Q(ntryL,G1H4(24),wf4(:,4),G1H1(1),m3h4x1(:,13),heltab2x4(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(128),n2h1(96))
  call Hloop_AW_Q(ntryL,G1H4(25),wf4(:,4),G1H1(1),m3h4x1(:,14),heltab2x4(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),3,nMB,G2tensor(129),n2h1(97))
  call Hloop_AW_Q(ntryL,G1H4(32),wf4(:,4),G1H1(1),m3h4x1(:,15),heltab2x4(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(130),n2h1(98))
  call Hloop_AV_Q(ntryL,G1H2(89),ex5(:),G1H1(1),m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(131),n2h1(99))
  call Hloop_AV_Q(ntryL,G1H2(6),ex5(:),G1H1(1),m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(132),n2h1(100))
  call Hloop_AV_Q(ntryL,G1H2(17),ex5(:),G1H1(1),m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(133),n2h1(101))
  call Hloop_VQ_A(ntryL,G1H2(18),ex4(:),G1H1(1),m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(134),n2h1(102))
  call Hloop_VQ_A(ntryL,G1H2(25),ex4(:),G1H1(1),m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(135),n2h1(103))
  call Hloop_VQ_A(ntryL,G1H2(50),ex4(:),G1H1(1),m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(136),n2h1(104))
  call Hloop_VQ_A(ntryL,G1H2(51),ex4(:),G1H1(1),m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(137),n2h1(105))
  call Hloop_VQ_A(ntryL,G1H2(61),ex4(:),G1H1(1),m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(138),n2h1(106))
  call Hloop_VQ_A(ntryL,G1H2(73),ex4(:),G1H1(1),m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(139),n2h1(107))
  call Hloop_VA_Q(ntryL,G1H2(84),ex3(:),G1H1(1),m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(140),n2h1(108))
  call Hloop_VA_Q(ntryL,G1H2(94),ex3(:),G1H1(1),m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(141),n2h1(109))
  call Hloop_VA_Q(ntryL,G1H2(106),ex3(:),G1H1(1),m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(142),n2h1(110))
  call Hloop_VA_Q(ntryL,G1H2(2),ex3(:),G1H1(1),m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(143),n2h1(111))
  call Hloop_VA_Q(ntryL,G1H2(3),ex3(:),G1H1(1),m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(144),n2h1(112))
  call Hloop_VA_Q(ntryL,G1H2(113),ex3(:),G1H1(1),m3h2x1(:,140),heltab2x2(:,:,140))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(145),n2h1(113))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(23),47,ex5(:),16,G2tensor(146),m3h2x1(:,141),heltab2x2(:,:,141))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(24),0,ex5(:),16,G2tensor(147),m3h2x1(:,142),heltab2x2(:,:,142))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(115),47,ex5(:),16,G2tensor(148),m3h2x1(:,143),heltab2x2(:,:,143))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(34),47,ex5(:),16,G2tensor(149),m3h2x1(:,144),heltab2x2(:,:,144))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(35),0,ex5(:),16,G2tensor(150),m3h2x1(:,145),heltab2x2(:,:,145))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(117),47,ex5(:),16,G2tensor(151),m3h2x1(:,146),heltab2x2(:,:,146))
  call Hloop_AV_Q(ntryL,G1H2(45),ex5(:),G1H1(1),m3h2x1(:,147),heltab2x2(:,:,147))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(152),n2h1(116))
  call Hloop_AV_Q(ntryL,G1H2(46),ex5(:),G1H1(1),m3h2x1(:,148),heltab2x2(:,:,148))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(153),n2h1(117))
  call Hloop_AV_Q(ntryL,G1H2(119),ex5(:),G1H1(1),m3h2x1(:,149),heltab2x2(:,:,149))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(154),n2h1(118))
  call Hloop_AV_Q(ntryL,G1H2(120),ex5(:),G1H1(1),m3h2x1(:,150),heltab2x2(:,:,150))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(155),n2h1(119))
  call Hloop_AV_Q(ntryL,G1H2(121),ex5(:),G1H1(1),m3h2x1(:,151),heltab2x2(:,:,151))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(156),n2h1(120))
  call Hloop_AV_Q(ntryL,G1H2(124),ex5(:),G1H1(1),m3h2x1(:,152),heltab2x2(:,:,152))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(157),n2h1(121))
  call Hloop_QV_A(ntryL,G1H2(56),ex5(:),G1H1(1),m3h2x1(:,153),heltab2x2(:,:,153))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(158),n2h1(122))
  call Hloop_QV_A(ntryL,G1H2(57),ex5(:),G1H1(1),m3h2x1(:,154),heltab2x2(:,:,154))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(159),n2h1(123))
  call Hloop_QV_A(ntryL,G1H2(126),ex5(:),G1H1(1),m3h2x1(:,155),heltab2x2(:,:,155))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(160),n2h1(124))
  call Hloop_QV_A(ntryL,G1H2(127),ex5(:),G1H1(1),m3h2x1(:,156),heltab2x2(:,:,156))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(161),n2h1(125))
  call Hloop_QV_A(ntryL,G1H2(128),ex5(:),G1H1(1),m3h2x1(:,157),heltab2x2(:,:,157))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(162),n2h1(126))
  call Hloop_QV_A(ntryL,G1H2(131),ex5(:),G1H1(1),m3h2x1(:,158),heltab2x2(:,:,158))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(163),n2h1(127))
  call Hloop_QV_A(ntryL,G1H2(67),ex5(:),G1H1(1),m3h2x1(:,159),heltab2x2(:,:,159))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(164),n2h1(128))
  call Hloop_QV_A(ntryL,G1H2(68),ex5(:),G1H1(1),m3h2x1(:,160),heltab2x2(:,:,160))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(165),n2h1(129))
  call Hloop_QV_A(ntryL,G1H2(133),ex5(:),G1H1(1),m3h2x1(:,161),heltab2x2(:,:,161))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(166),n2h1(130))
  call Hloop_QV_A(ntryL,G1H2(134),ex5(:),G1H1(1),m3h2x1(:,162),heltab2x2(:,:,162))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(167),n2h1(131))
  call Hloop_QV_A(ntryL,G1H2(135),ex5(:),G1H1(1),m3h2x1(:,163),heltab2x2(:,:,163))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(168),n2h1(132))
  call Hloop_QV_A(ntryL,G1H2(138),ex5(:),G1H1(1),m3h2x1(:,164),heltab2x2(:,:,164))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(169),n2h1(133))
  call Hloop_AV_Q(ntryL,G1H2(78),ex5(:),G1H1(1),m3h2x1(:,165),heltab2x2(:,:,165))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(170),n2h1(134))
  call Hloop_AV_Q(ntryL,G1H2(79),ex5(:),G1H1(1),m3h2x1(:,166),heltab2x2(:,:,166))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(171),n2h1(135))
  call Hloop_AV_Q(ntryL,G1H2(140),ex5(:),G1H1(1),m3h2x1(:,167),heltab2x2(:,:,167))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(172),n2h1(136))
  call Hloop_VA_Q(ntryL,G1H2(90),ex3(:),G1H1(1),m3h2x1(:,168),heltab2x2(:,:,168))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(173),n2h1(137))
  call Hloop_VA_Q(ntryL,G1H2(91),ex3(:),G1H1(1),m3h2x1(:,169),heltab2x2(:,:,169))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(174),n2h1(138))
  call Hloop_VA_Q(ntryL,G1H2(143),ex3(:),G1H1(1),m3h2x1(:,170),heltab2x2(:,:,170))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(175),n2h1(139))
  call Hloop_VA_Q(ntryL,G1H2(144),ex3(:),G1H1(1),m3h2x1(:,171),heltab2x2(:,:,171))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(176),n2h1(140))
  call Hloop_VA_Q(ntryL,G1H2(145),ex3(:),G1H1(1),m3h2x1(:,172),heltab2x2(:,:,172))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(177),n2h1(141))
  call Hloop_VA_Q(ntryL,G1H2(148),ex3(:),G1H1(1),m3h2x1(:,173),heltab2x2(:,:,173))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(178),n2h1(142))
  call Hloop_VQ_A(ntryL,G1H2(100),ex4(:),G1H1(1),m3h2x1(:,174),heltab2x2(:,:,174))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(179),n2h1(143))
  call Hloop_VQ_A(ntryL,G1H2(101),ex4(:),G1H1(1),m3h2x1(:,175),heltab2x2(:,:,175))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(180),n2h1(144))
  call Hloop_VQ_A(ntryL,G1H2(151),ex4(:),G1H1(1),m3h2x1(:,176),heltab2x2(:,:,176))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(181),n2h1(145))
  call Hloop_VQ_A(ntryL,G1H2(152),ex4(:),G1H1(1),m3h2x1(:,177),heltab2x2(:,:,177))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(182),n2h1(146))
  call Hloop_VQ_A(ntryL,G1H2(153),ex4(:),G1H1(1),m3h2x1(:,178),heltab2x2(:,:,178))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(183),n2h1(147))
  call Hloop_VQ_A(ntryL,G1H2(156),ex4(:),G1H1(1),m3h2x1(:,179),heltab2x2(:,:,179))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(184),n2h1(148))
  call Hloop_VA_Q(ntryL,G1H4(35),wf4(:,5),G1H1(1),m3h4x1(:,16),heltab2x4(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(185),n2h1(149))
  call Hloop_VA_Q(ntryL,G1H4(40),wf4(:,5),G1H1(1),m3h4x1(:,17),heltab2x4(:,:,87))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,0,G2tensor(186),n2h1(150))
  call Hloop_VA_Q(ntryL,G1H4(7),wf4(:,5),G1H1(1),m3h4x1(:,18),heltab2x4(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(187),n2h1(151))
  call Hloop_VQ_A(ntryL,G1H4(11),wf4(:,10),G1H1(1),m3h4x1(:,19),heltab2x4(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(188),n2h1(152))
  call Hloop_VQ_A(ntryL,G1H4(12),wf4(:,10),G1H1(1),m3h4x1(:,20),heltab2x4(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,nMB,G2tensor(189),n2h1(153))
  call Hloop_VQ_A(ntryL,G1H4(10),wf4(:,10),G1H1(1),m3h4x1(:,21),heltab2x4(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(190),n2h1(154))
  call Hloop_VQ_A(ntryL,G1H8(1),wf8(:,3),G1H1(1),m3h8x1(:,3),heltab2x8(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(191),n2h1(155))
  call Hloop_VQ_A(ntryL,G1H8(6),wf8(:,3),G1H1(1),m3h8x1(:,4),heltab2x8(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),11,0,G2tensor(192),n2h1(156))
  call Hloop_VQ_A(ntryL,G1H8(14),wf8(:,3),G1H1(1),m3h8x1(:,5),heltab2x8(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(193),n2h1(157))
  call ol_merge_tensors(G2tensor(191),[G2tensor(84),G2tensor(2),G1tensor(6)])
  call ol_merge_tensors(G2tensor(82),[G2tensor(19),G2tensor(4),G1tensor(36),G1tensor(12)])
  call ol_merge_tensors(G2tensor(70),[G2tensor(6),G1tensor(14)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(18)])
  call ol_merge_tensors(G2tensor(72),[G2tensor(10),G1tensor(20),G1tensor(9)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(24)])
  call ol_merge_tensors(G2tensor(74),[G2tensor(14),G1tensor(26)])
  call ol_merge_tensors(G2tensor(80),[G2tensor(15),G1tensor(30)])
  call ol_merge_tensors(G2tensor(77),[G2tensor(18),G1tensor(32)])
  call ol_merge_tensors(G2tensor(98),[G2tensor(22),G1tensor(38)])
  call ol_merge_tensors(G2tensor(185),[G2tensor(39),G2tensor(23),G1tensor(66),G1tensor(42)])
  call ol_merge_tensors(G2tensor(104),[G2tensor(26),G1tensor(44)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(48)])
  call ol_merge_tensors(G2tensor(110),[G2tensor(30),G1tensor(50)])
  call ol_merge_tensors(G2tensor(188),[G2tensor(43),G2tensor(31),G1tensor(72),G1tensor(54)])
  call ol_merge_tensors(G2tensor(116),[G2tensor(34),G1tensor(56)])
  call ol_merge_tensors(G2tensor(35),[G1tensor(60)])
  call ol_merge_tensors(G2tensor(122),[G2tensor(38),G1tensor(62),G1tensor(33)])
  call ol_merge_tensors(G2tensor(125),[G2tensor(42),G1tensor(68),G1tensor(27)])
  call ol_merge_tensors(G2tensor(128),[G1tensor(2)])
  call ol_merge_tensors(G2tensor(79),[G1tensor(3)])
  call ol_merge_tensors(G2tensor(73),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(11),G1tensor(5)])
  call ol_merge_tensors(G2tensor(131),[G1tensor(57),G1tensor(8)])
  call ol_merge_tensors(G2tensor(76),[G1tensor(10)])
  call ol_merge_tensors(G2tensor(134),[G1tensor(15)])
  call ol_merge_tensors(G2tensor(137),[G1tensor(16)])
  call ol_merge_tensors(G2tensor(86),[G1tensor(71),G1tensor(17)])
  call ol_merge_tensors(G2tensor(140),[G1tensor(21)])
  call ol_merge_tensors(G2tensor(143),[G1tensor(22)])
  call ol_merge_tensors(G2tensor(89),[G1tensor(65),G1tensor(23)])
  call ol_merge_tensors(G2tensor(155),[G2tensor(146),G1tensor(40),G1tensor(28)])
  call ol_merge_tensors(G2tensor(92),[G1tensor(29)])
  call ol_merge_tensors(G2tensor(149),[G1tensor(34)])
  call ol_merge_tensors(G2tensor(107),[G2tensor(95),G1tensor(47),G1tensor(35)])
  call ol_merge_tensors(G2tensor(152),[G1tensor(39)])
  call ol_merge_tensors(G2tensor(101),[G1tensor(41)])
  call ol_merge_tensors(G2tensor(158),[G1tensor(45)])
  call ol_merge_tensors(G2tensor(161),[G1tensor(46)])
  call ol_merge_tensors(G2tensor(164),[G1tensor(51)])
  call ol_merge_tensors(G2tensor(167),[G1tensor(52)])
  call ol_merge_tensors(G2tensor(113),[G1tensor(53)])
  call ol_merge_tensors(G2tensor(170),[G1tensor(58)])
  call ol_merge_tensors(G2tensor(119),[G1tensor(59)])
  call ol_merge_tensors(G2tensor(173),[G1tensor(63)])
  call ol_merge_tensors(G2tensor(176),[G1tensor(64)])
  call ol_merge_tensors(G2tensor(179),[G1tensor(69)])
  call ol_merge_tensors(G2tensor(182),[G1tensor(70)])
call Hotf_4pt_reduction_last(G2tensor(191),RedSet_4(2),mass4set(:,2),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25))
call G_TensorShift(G1tensor(7),11)
call Hotf_4pt_reduction_last(G2tensor(82),RedSet_4(3),mass4set(:,1),  & 
G1tensor(31),G1tensor(37),G1tensor(43),G1tensor(49),G1tensor(55))
call G_TensorShift(G1tensor(37),24)
call Hotf_4pt_reduction_last(G2tensor(70),RedSet_4(47),mass4set(:,6),  & 
G1tensor(61),G1tensor(67),G1tensor(6),G1tensor(36),G1tensor(12))
call G_TensorShift(G1tensor(67),4)
call Hotf_4pt_reduction_last(G2tensor(7),RedSet_4(4),mass4set(:,3),  & 
G1tensor(14),G1tensor(18),G1tensor(20),G1tensor(9),G1tensor(24))
call G_TensorShift(G1tensor(18),12)
call Hotf_4pt_reduction_last(G2tensor(72),RedSet_4(13),mass4set(:,4),  & 
G1tensor(26),G1tensor(30),G1tensor(32),G1tensor(38),G1tensor(66))
call G_TensorShift(G1tensor(30),8)
call Hotf_4pt_reduction_last(G2tensor(11),RedSet_4(4),mass4set(:,4),  & 
G1tensor(42),G1tensor(44),G1tensor(48),G1tensor(50),G1tensor(72))
call G_TensorShift(G1tensor(44),12)
call Hotf_4pt_reduction_last(G2tensor(74),RedSet_4(48),mass4set(:,5),  & 
G1tensor(54),G1tensor(56),G1tensor(60),G1tensor(62),G1tensor(33))
call G_TensorShift(G1tensor(56),4)
call Hotf_4pt_reduction_last(G2tensor(80),RedSet_4(5),mass4set(:,5),  & 
G1tensor(68),G1tensor(27),G1tensor(2),G1tensor(3),G1tensor(4))
call G_TensorShift(G1tensor(27),20)
call Hotf_4pt_reduction_last(G2tensor(77),RedSet_4(49),mass4set(:,1),  & 
G1tensor(11),G1tensor(5),G1tensor(57),G1tensor(8),G1tensor(10))
call G_TensorShift(G1tensor(5),8)
call Hotf_4pt_reduction_last(G2tensor(98),RedSet_4(50),mass4set(:,5),  & 
G1tensor(15),G1tensor(16),G1tensor(71),G1tensor(17),G1tensor(21))
call G_TensorShift(G1tensor(16),4)
call Hotf_4pt_reduction_last(G2tensor(185),RedSet_4(6),mass4set(:,5),  & 
G1tensor(22),G1tensor(65),G1tensor(23),G1tensor(40),G1tensor(28))
call G_TensorShift(G1tensor(65),20)
call Hotf_4pt_reduction_last(G2tensor(104),RedSet_4(51),mass4set(:,1),  & 
G1tensor(29),G1tensor(34),G1tensor(47),G1tensor(35),G1tensor(39))
call G_TensorShift(G1tensor(34),3)
call Hotf_4pt_reduction_last(G2tensor(27),RedSet_4(7),mass4set(:,1),  & 
G1tensor(41),G1tensor(45),G1tensor(46),G1tensor(51),G1tensor(52))
call G_TensorShift(G1tensor(45),19)
call Hotf_4pt_reduction_last(G2tensor(110),RedSet_4(52),mass4set(:,3),  & 
G1tensor(53),G1tensor(58),G1tensor(59),G1tensor(63),G1tensor(64))
call G_TensorShift(G1tensor(58),8)
call Hotf_4pt_reduction_last(G2tensor(188),RedSet_4(8),mass4set(:,3),  & 
G1tensor(69),G1tensor(70),G1tensor(73),G1tensor(74),G1tensor(75))
call G_TensorShift(G1tensor(70),24)
call Hotf_4pt_reduction_last(G2tensor(116),RedSet_4(53),mass4set(:,3),  & 
G1tensor(76),G1tensor(77),G1tensor(78),G1tensor(79),G1tensor(80))
call G_TensorShift(G1tensor(77),3)
call Hotf_4pt_reduction_last(G2tensor(35),RedSet_4(9),mass4set(:,3),  & 
G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84),G1tensor(85))
call G_TensorShift(G1tensor(82),19)
call Hotf_4pt_reduction_last(G2tensor(122),RedSet_4(28),mass4set(:,5),  & 
G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
call G_TensorShift(G1tensor(87),16)
call Hotf_4pt_reduction_last(G2tensor(125),RedSet_4(24),mass4set(:,6),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95))
call G_TensorShift(G1tensor(92),16)
call Hotf_4pt_reduction_last(G2tensor(128),RedSet_4(54),mass4set(:,8),  & 
G1tensor(96),G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100))
call G_TensorShift(G1tensor(97),3)
call Hotf_4pt_reduction_last(G2tensor(79),RedSet_4(10),mass4set(:,1),  & 
G1tensor(101),G1tensor(102),G1tensor(103),G1tensor(104),G1tensor(105))
call G_TensorShift(G1tensor(102),8)
call Hotf_4pt_reduction_last(G2tensor(73),RedSet_4(11),mass4set(:,1),  & 
G1tensor(106),G1tensor(107),G1tensor(108),G1tensor(109),G1tensor(110))
call G_TensorShift(G1tensor(107),8)
call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,1),  & 
G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114),G1tensor(115))
call G_TensorShift(G1tensor(112),8)
call Hotf_4pt_reduction_last(G2tensor(131),RedSet_4(40),mass4set(:,9),  & 
G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
call G_TensorShift(G1tensor(117),16)
call Hotf_4pt_reduction_last(G2tensor(76),RedSet_4(14),mass4set(:,4),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125))
call G_TensorShift(G1tensor(122),8)
call Hotf_4pt_reduction_last(G2tensor(134),RedSet_4(16),mass4set(:,8),  & 
G1tensor(126),G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130))
call G_TensorShift(G1tensor(127),8)
call Hotf_4pt_reduction_last(G2tensor(137),RedSet_4(17),mass4set(:,3),  & 
G1tensor(131),G1tensor(132),G1tensor(133),G1tensor(134),G1tensor(135))
call G_TensorShift(G1tensor(132),8)
call Hotf_4pt_reduction_last(G2tensor(86),RedSet_4(18),mass4set(:,3),  & 
G1tensor(136),G1tensor(137),G1tensor(138),G1tensor(139),G1tensor(140))
call G_TensorShift(G1tensor(137),8)
call Hotf_4pt_reduction_last(G2tensor(140),RedSet_4(20),mass4set(:,10),  & 
G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144),G1tensor(145))
call G_TensorShift(G1tensor(142),4)
call Hotf_4pt_reduction_last(G2tensor(143),RedSet_4(21),mass4set(:,5),  & 
G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
call G_TensorShift(G1tensor(147),4)
call Hotf_4pt_reduction_last(G2tensor(89),RedSet_4(22),mass4set(:,5),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155))
call G_TensorShift(G1tensor(152),4)
call Hotf_4pt_reduction_last(G2tensor(155),RedSet_4(25),mass4set(:,2),  & 
G1tensor(156),G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160))
call G_TensorShift(G1tensor(157),16)
call Hotf_4pt_reduction_last(G2tensor(92),RedSet_4(26),mass4set(:,5),  & 
G1tensor(161),G1tensor(162),G1tensor(163),G1tensor(164),G1tensor(165))
call G_TensorShift(G1tensor(162),16)
call Hotf_4pt_reduction_last(G2tensor(149),RedSet_4(29),mass4set(:,5),  & 
G1tensor(166),G1tensor(167),G1tensor(168),G1tensor(169),G1tensor(170))
call G_TensorShift(G1tensor(167),16)
call Hotf_4pt_reduction_last(G2tensor(107),RedSet_4(30),mass4set(:,2),  & 
G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174),G1tensor(175))
call G_TensorShift(G1tensor(172),16)
call Hotf_4pt_reduction_last(G2tensor(152),RedSet_4(32),mass4set(:,6),  & 
G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
call G_TensorShift(G1tensor(177),16)
call Hotf_4pt_reduction_last(G2tensor(101),RedSet_4(33),mass4set(:,5),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185))
call G_TensorShift(G1tensor(182),16)
call Hotf_4pt_reduction_last(G2tensor(158),RedSet_4(35),mass4set(:,5),  & 
G1tensor(186),G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190))
call G_TensorShift(G1tensor(187),16)
call Hotf_4pt_reduction_last(G2tensor(161),RedSet_4(36),mass4set(:,5),  & 
G1tensor(191),G1tensor(192),G1tensor(193),G1tensor(194),G1tensor(195))
call G_TensorShift(G1tensor(192),16)
call Hotf_4pt_reduction_last(G2tensor(164),RedSet_4(38),mass4set(:,9),  & 
G1tensor(196),G1tensor(197),G1tensor(198),G1tensor(199),G1tensor(200))
call G_TensorShift(G1tensor(197),16)
call Hotf_4pt_reduction_last(G2tensor(167),RedSet_4(29),mass4set(:,7),  & 
G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204),G1tensor(205))
call G_TensorShift(G1tensor(202),16)
call Hotf_4pt_reduction_last(G2tensor(113),RedSet_4(33),mass4set(:,7),  & 
G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
call G_TensorShift(G1tensor(207),16)
call Hotf_4pt_reduction_last(G2tensor(170),RedSet_4(36),mass4set(:,7),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215))
call G_TensorShift(G1tensor(212),16)
call Hotf_4pt_reduction_last(G2tensor(119),RedSet_4(26),mass4set(:,7),  & 
G1tensor(216),G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220))
call G_TensorShift(G1tensor(217),16)
call Hotf_4pt_reduction_last(G2tensor(173),RedSet_4(42),mass4set(:,6),  & 
G1tensor(221),G1tensor(222),G1tensor(223),G1tensor(224),G1tensor(225))
call G_TensorShift(G1tensor(222),4)
call Hotf_4pt_reduction_last(G2tensor(176),RedSet_4(43),mass4set(:,2),  & 
G1tensor(226),G1tensor(227),G1tensor(228),G1tensor(229),G1tensor(230))
call G_TensorShift(G1tensor(227),4)
call Hotf_4pt_reduction_last(G2tensor(179),RedSet_4(45),mass4set(:,8),  & 
G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234),G1tensor(235))
call G_TensorShift(G1tensor(232),8)
call Hotf_4pt_reduction_last(G2tensor(182),RedSet_4(14),mass4set(:,3),  & 
G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
call G_TensorShift(G1tensor(237),8)
call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(2),mass4set(:,2),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(3),mass4set(:,1),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(47),mass4set(:,6),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
call Hotf_4pt_reduction_last(G1tensor(14),RedSet_4(4),mass4set(:,3),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(13),mass4set(:,4),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
call Hotf_4pt_reduction_last(G1tensor(42),RedSet_4(4),mass4set(:,4),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
call Hotf_4pt_reduction_last(G1tensor(54),RedSet_4(48),mass4set(:,5),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
call Hotf_4pt_reduction_last(G1tensor(68),RedSet_4(5),mass4set(:,5),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(49),mass4set(:,1),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
call Hotf_4pt_reduction_last(G1tensor(15),RedSet_4(50),mass4set(:,5),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
call Hotf_4pt_reduction_last(G1tensor(22),RedSet_4(6),mass4set(:,5),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
call Hotf_4pt_reduction_last(G1tensor(29),RedSet_4(51),mass4set(:,1),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(7),mass4set(:,1),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
call Hotf_4pt_reduction_last(G1tensor(53),RedSet_4(52),mass4set(:,3),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
call Hotf_4pt_reduction_last(G1tensor(69),RedSet_4(8),mass4set(:,3),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(53),mass4set(:,3),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
call Hotf_4pt_reduction_last(G1tensor(81),RedSet_4(9),mass4set(:,3),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
call Hotf_4pt_reduction_last(G1tensor(86),RedSet_4(28),mass4set(:,5),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(24),mass4set(:,6),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
call Hotf_4pt_reduction_last(G1tensor(96),RedSet_4(54),mass4set(:,8),  & 
G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100))
call Hotf_4pt_reduction_last(G1tensor(101),RedSet_4(10),mass4set(:,1),  & 
G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104),G0tensor(105))
call Hotf_4pt_reduction_last(G1tensor(106),RedSet_4(11),mass4set(:,1),  & 
G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110))
call Hotf_4pt_reduction_last(G1tensor(111),RedSet_4(1),mass4set(:,1),  & 
G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114),G0tensor(115))
call Hotf_4pt_reduction_last(G1tensor(116),RedSet_4(40),mass4set(:,9),  & 
G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119),G0tensor(120))
call Hotf_4pt_reduction_last(G1tensor(121),RedSet_4(14),mass4set(:,4),  & 
G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124),G0tensor(125))
call Hotf_4pt_reduction_last(G1tensor(126),RedSet_4(16),mass4set(:,8),  & 
G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129),G0tensor(130))
call Hotf_4pt_reduction_last(G1tensor(131),RedSet_4(17),mass4set(:,3),  & 
G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134),G0tensor(135))
call Hotf_4pt_reduction_last(G1tensor(136),RedSet_4(18),mass4set(:,3),  & 
G0tensor(136),G0tensor(137),G0tensor(138),G0tensor(139),G0tensor(140))
call Hotf_4pt_reduction_last(G1tensor(141),RedSet_4(20),mass4set(:,10),  & 
G0tensor(141),G0tensor(142),G0tensor(143),G0tensor(144),G0tensor(145))
call Hotf_4pt_reduction_last(G1tensor(146),RedSet_4(21),mass4set(:,5),  & 
G0tensor(146),G0tensor(147),G0tensor(148),G0tensor(149),G0tensor(150))
call Hotf_4pt_reduction_last(G1tensor(151),RedSet_4(22),mass4set(:,5),  & 
G0tensor(151),G0tensor(152),G0tensor(153),G0tensor(154),G0tensor(155))
call Hotf_4pt_reduction_last(G1tensor(156),RedSet_4(25),mass4set(:,2),  & 
G0tensor(156),G0tensor(157),G0tensor(158),G0tensor(159),G0tensor(160))
call Hotf_4pt_reduction_last(G1tensor(161),RedSet_4(26),mass4set(:,5),  & 
G0tensor(161),G0tensor(162),G0tensor(163),G0tensor(164),G0tensor(165))
call Hotf_4pt_reduction_last(G1tensor(166),RedSet_4(29),mass4set(:,5),  & 
G0tensor(166),G0tensor(167),G0tensor(168),G0tensor(169),G0tensor(170))
call Hotf_4pt_reduction_last(G1tensor(171),RedSet_4(30),mass4set(:,2),  & 
G0tensor(171),G0tensor(172),G0tensor(173),G0tensor(174),G0tensor(175))
call Hotf_4pt_reduction_last(G1tensor(176),RedSet_4(32),mass4set(:,6),  & 
G0tensor(176),G0tensor(177),G0tensor(178),G0tensor(179),G0tensor(180))
call Hotf_4pt_reduction_last(G1tensor(181),RedSet_4(33),mass4set(:,5),  & 
G0tensor(181),G0tensor(182),G0tensor(183),G0tensor(184),G0tensor(185))
call Hotf_4pt_reduction_last(G1tensor(186),RedSet_4(35),mass4set(:,5),  & 
G0tensor(186),G0tensor(187),G0tensor(188),G0tensor(189),G0tensor(190))
call Hotf_4pt_reduction_last(G1tensor(191),RedSet_4(36),mass4set(:,5),  & 
G0tensor(191),G0tensor(192),G0tensor(193),G0tensor(194),G0tensor(195))
call Hotf_4pt_reduction_last(G1tensor(196),RedSet_4(38),mass4set(:,9),  & 
G0tensor(196),G0tensor(197),G0tensor(198),G0tensor(199),G0tensor(200))
call Hotf_4pt_reduction_last(G1tensor(201),RedSet_4(29),mass4set(:,7),  & 
G0tensor(201),G0tensor(202),G0tensor(203),G0tensor(204),G0tensor(205))
call Hotf_4pt_reduction_last(G1tensor(206),RedSet_4(33),mass4set(:,7),  & 
G0tensor(206),G0tensor(207),G0tensor(208),G0tensor(209),G0tensor(210))
call Hotf_4pt_reduction_last(G1tensor(211),RedSet_4(36),mass4set(:,7),  & 
G0tensor(211),G0tensor(212),G0tensor(213),G0tensor(214),G0tensor(215))
call Hotf_4pt_reduction_last(G1tensor(216),RedSet_4(26),mass4set(:,7),  & 
G0tensor(216),G0tensor(217),G0tensor(218),G0tensor(219),G0tensor(220))
call Hotf_4pt_reduction_last(G1tensor(221),RedSet_4(42),mass4set(:,6),  & 
G0tensor(221),G0tensor(222),G0tensor(223),G0tensor(224),G0tensor(225))
call Hotf_4pt_reduction_last(G1tensor(226),RedSet_4(43),mass4set(:,2),  & 
G0tensor(226),G0tensor(227),G0tensor(228),G0tensor(229),G0tensor(230))
call Hotf_4pt_reduction_last(G1tensor(231),RedSet_4(45),mass4set(:,8),  & 
G0tensor(231),G0tensor(232),G0tensor(233),G0tensor(234),G0tensor(235))
call Hotf_4pt_reduction_last(G1tensor(236),RedSet_4(14),mass4set(:,3),  & 
G0tensor(236),G0tensor(237),G0tensor(238),G0tensor(239),G0tensor(240))
call ol_merge_tensors(T0sum(1),[G0tensor(1)])
call ol_merge_tensors(T0sum(2),[G0tensor(6)])
call ol_merge_tensors(T0sum(3),[G0tensor(11)])
call ol_merge_tensors(T0sum(4),[G0tensor(16)])
call ol_merge_tensors(T0sum(5),[G0tensor(21)])
call ol_merge_tensors(T0sum(6),[G0tensor(26)])
call ol_merge_tensors(T0sum(7),[G0tensor(31)])
call ol_merge_tensors(T0sum(8),[G0tensor(36)])
call ol_merge_tensors(T0sum(9),[G0tensor(41)])
call ol_merge_tensors(T0sum(10),[G0tensor(46)])
call ol_merge_tensors(T0sum(11),[G0tensor(51)])
call ol_merge_tensors(T0sum(12),[G0tensor(56)])
call ol_merge_tensors(T0sum(13),[G0tensor(61)])
call ol_merge_tensors(T0sum(14),[G0tensor(66)])
call ol_merge_tensors(T0sum(15),[G0tensor(71)])
call ol_merge_tensors(T0sum(16),[G0tensor(76)])
call ol_merge_tensors(T0sum(17),[G0tensor(81)])
call ol_merge_tensors(T0sum(18),[G0tensor(86)])
call ol_merge_tensors(T0sum(19),[G0tensor(91)])
call ol_merge_tensors(T0sum(20),[G0tensor(96)])
call ol_merge_tensors(T0sum(21),[G0tensor(101)])
call ol_merge_tensors(T0sum(22),[G0tensor(106)])
call ol_merge_tensors(T0sum(23),[G0tensor(111)])
call ol_merge_tensors(T0sum(24),[G0tensor(116)])
call ol_merge_tensors(T0sum(25),[G0tensor(121)])
call ol_merge_tensors(T0sum(26),[G0tensor(126)])
call ol_merge_tensors(T0sum(27),[G0tensor(131)])
call ol_merge_tensors(T0sum(28),[G0tensor(136)])
call ol_merge_tensors(T0sum(29),[G0tensor(141)])
call ol_merge_tensors(T0sum(30),[G0tensor(146)])
call ol_merge_tensors(T0sum(31),[G0tensor(151)])
call ol_merge_tensors(T0sum(32),[G0tensor(156)])
call ol_merge_tensors(T0sum(33),[G0tensor(161)])
call ol_merge_tensors(T0sum(34),[G0tensor(166)])
call ol_merge_tensors(T0sum(35),[G0tensor(171)])
call ol_merge_tensors(T0sum(36),[G0tensor(176)])
call ol_merge_tensors(T0sum(37),[G0tensor(181)])
call ol_merge_tensors(T0sum(38),[G0tensor(186)])
call ol_merge_tensors(T0sum(39),[G0tensor(191)])
call ol_merge_tensors(T0sum(40),[G0tensor(196)])
call ol_merge_tensors(T0sum(41),[G0tensor(201)])
call ol_merge_tensors(T0sum(42),[G0tensor(206)])
call ol_merge_tensors(T0sum(43),[G0tensor(211)])
call ol_merge_tensors(T0sum(44),[G0tensor(216)])
call ol_merge_tensors(T0sum(45),[G0tensor(221)])
call ol_merge_tensors(T0sum(46),[G0tensor(226)])
call ol_merge_tensors(T0sum(47),[G0tensor(231)])
call ol_merge_tensors(T0sum(48),[G0tensor(236)])
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(9)*M(3,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(43),h0tab(:,43),[48,7,8],[0,nMB,0],4,1,wf8(:,6))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(6),m4h2x2x16(:,4),heltab3x64(:,:,4))
Gcoeff(:)%j = (-(c(11)*M(2,:)%j)-c(9)*M(3,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(44),h0tab(:,44),[48,7,8],[0,nMB,0],4,1,wf8(:,6))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex5(:),ex6(:),G0H16(3),m4h2x2x16(:,5),heltab3x64(:,:,5))
Gcoeff(:)%j = (c(11)*(M(1,:)%j-M(2,:)%j)) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(45),h0tab(:,45),[48,7,8],[0,nMB,0],4,1,wf8(:,6))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(2),m4h2x2x16(:,6),heltab3x64(:,:,6))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(9)*M(3,:)%j) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(46),h0tab(:,46),[48,4,11],[0,0,0],4,1,wf8(:,3))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(1),m4h2x2x16(:,7),heltab3x64(:,:,7))
Gcoeff(:)%j = (-(c(11)*M(2,:)%j)-c(9)*M(3,:)%j) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(47),h0tab(:,47),[48,4,11],[0,0,0],4,1,wf8(:,3))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex5(:),ex6(:),G0H16(4),m4h2x2x16(:,8),heltab3x64(:,:,8))
Gcoeff(:)%j = (c(11)*(M(1,:)%j-M(2,:)%j)) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(48),h0tab(:,48),[48,4,11],[0,0,0],4,1,wf8(:,3))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(5),m4h2x2x16(:,9),heltab3x64(:,:,9))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(73)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(49),h0tab(:,49),[40,3,20],[nMB,0,0],3,3,wf4(:,6),wf4(:,4),wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,6),G0H16(7),m3h4x16(:,10),heltab2x64(:,:,40))
  call Hloop_Q_A(ntryL,G0H16(7),40,nMB,G1H16(5),n2h16(23))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(50),h0tab(:,50),[32,11,20],[0,0,0],3,2,wf8(:,3),wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,31),heltab2x64(:,:,41))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(1),n2h32(19))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(51),h0tab(:,51),[32,11,20],[0,0,0],3,2,wf8(:,3),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(2),m3h2x32(:,32),heltab2x64(:,:,42))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(24)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(52),h0tab(:,52),[52,3,8],[0,nMB,0],3,2,wf8(:,20),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,20),G0H8(1),m3h8x8(:,1),heltab2x64(:,:,43))
  call Hloop_A_Q(ntryL,G0H8(1),52,0,G1H8(25),n2h8(35))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(40)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(53),h0tab(:,53),[32,8,23],[nMB,0,nMB],3,1,wf16(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,33),heltab2x64(:,:,44))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(3),n2h32(20))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(40)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(54),h0tab(:,54),[32,8,23],[0,nMB,0],3,1,wf16(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(4),m3h2x32(:,34),heltab2x64(:,:,45))
Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(74)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(55),h0tab(:,55),[36,3,24],[0,nMB,0],3,3,wf4(:,9),wf4(:,4),wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,9),G0H16(7),m3h4x16(:,11),heltab2x64(:,:,46))
  call Hloop_A_Q(ntryL,G0H16(7),36,0,G1H16(6),n2h16(24))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(15)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(56),h0tab(:,56),[32,7,24],[nMB,0,nMB],3,2,wf8(:,6),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,35),heltab2x64(:,:,47))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(5),n2h32(21))
Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(15)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(57),h0tab(:,57),[32,7,24],[0,nMB,0],3,2,wf8(:,6),wf4(:,10))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(6),m3h2x32(:,36),heltab2x64(:,:,48))
Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(29)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(58),h0tab(:,58),[56,3,4],[nMB,0,0],3,2,wf8(:,26),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,26),G0H8(1),m3h8x8(:,2),heltab2x64(:,:,49))
  call Hloop_Q_A(ntryL,G0H8(1),56,nMB,G1H8(26),n2h8(36))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(47)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(59),h0tab(:,59),[32,4,27],[0,0,0],3,1,wf16(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,37),heltab2x64(:,:,50))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(7),n2h32(22))
Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(47)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(60),h0tab(:,60),[32,4,27],[0,0,0],3,1,wf16(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(8),m3h2x32(:,38),heltab2x64(:,:,51))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(61),h0tab(:,61),[36,11,16],[0,0,0],3,2,wf4(:,9),wf8(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,9),G0H16(7),m3h4x16(:,12),heltab2x64(:,:,52))
Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(62),h0tab(:,62),[36,11,16],[0,0,0],3,2,wf4(:,9),wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,9),G0H16(8),m3h4x16(:,13),heltab2x64(:,:,53))
  call Hloop_A_Q(ntryL,G0H16(8),36,0,G1H16(7),n2h16(25))
Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(26)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(63),h0tab(:,63),[52,3,8],[0,nMB,0],3,2,wf8(:,21),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,21),G0H8(1),m3h8x8(:,3),heltab2x64(:,:,54))
  call Hloop_A_Q(ntryL,G0H8(1),52,0,G1H8(30),n2h8(37))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(50)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(64),h0tab(:,64),[39,8,16],[0,nMB,nMB],3,1,wf16(:,12))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,12),G0H4(1),m3h16x4(:,1),heltab2x64(:,:,55))
Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(50)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(65),h0tab(:,65),[39,8,16],[nMB,0,0],3,1,wf16(:,12))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,12),G0H4(2),m3h16x4(:,2),heltab2x64(:,:,56))
  call Hloop_A_Q(ntryL,G0H4(2),39,nMB,G1H4(22),n2h4(49))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(66),h0tab(:,66),[40,7,16],[0,nMB,nMB],3,2,wf4(:,6),wf8(:,6))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,6),G0H16(8),m3h4x16(:,14),heltab2x64(:,:,57))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(67),h0tab(:,67),[40,7,16],[nMB,0,0],3,2,wf4(:,6),wf8(:,6))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,6),G0H16(9),m3h4x16(:,15),heltab2x64(:,:,58))
  call Hloop_Q_A(ntryL,G0H16(9),40,nMB,G1H16(13),n2h16(26))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(68),h0tab(:,68),[56,3,4],[nMB,0,0],3,2,wf8(:,27),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,27),G0H8(1),m3h8x8(:,4),heltab2x64(:,:,59))
  call Hloop_Q_A(ntryL,G0H8(1),56,nMB,G1H8(31),n2h8(38))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(37)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(69),h0tab(:,69),[43,4,16],[0,0,0],3,1,wf16(:,8))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,8),G0H4(2),m3h16x4(:,3),heltab2x64(:,:,60))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(37)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(70),h0tab(:,70),[43,4,16],[0,0,0],3,1,wf16(:,8))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,8),G0H4(3),m3h16x4(:,4),heltab2x64(:,:,61))
  call Hloop_Q_A(ntryL,G0H4(3),43,0,G1H4(3),n2h4(50))
Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(2,:)%j)) * den(19)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(71),h0tab(:,71),[48,7,8],[nMB,0,nMB],3,2,wf4(:,11),wf8(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,11),G0H16(9),m3h4x16(:,16),heltab2x64(:,:,62))
  call Hloop_Q_A(ntryL,G0H16(9),48,nMB,G1H16(14),n2h16(27))
Gcoeff(:)%j = (c(11)*(M(1,:)%j-M(2,:)%j)) * den(19)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(72),h0tab(:,72),[48,7,8],[0,nMB,0],3,2,wf4(:,11),wf8(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,11),48,G1H16(18),m3h4x16(:,17),heltab2x64(:,:,63))
Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(2,:)%j)) * den(32)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(73),h0tab(:,73),[48,4,11],[0,0,0],3,2,wf4(:,11),wf8(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,11),G0H16(9),m3h4x16(:,18),heltab2x64(:,:,64))
  call Hloop_Q_A(ntryL,G0H16(9),48,0,G1H16(12),n2h16(28))
Gcoeff(:)%j = (c(11)*(M(1,:)%j-M(2,:)%j)) * den(32)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(74),h0tab(:,74),[48,4,11],[0,0,0],3,2,wf4(:,11),wf8(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,11),48,G1H16(16),m3h4x16(:,19),heltab2x64(:,:,65))
Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(2,:)%j)) * den(22)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(75),h0tab(:,75),[52,3,8],[0,nMB,0],3,2,wf8(:,11),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,11),G0H8(1),m3h8x8(:,5),heltab2x64(:,:,66))
  call Hloop_A_Q(ntryL,G0H8(1),52,0,G1H8(15),n2h8(39))
Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(2,:)%j)) * den(34)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(76),h0tab(:,76),[56,3,4],[nMB,0,0],3,2,wf8(:,29),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,29),G0H8(1),m3h8x8(:,6),heltab2x64(:,:,67))
  call Hloop_Q_A(ntryL,G0H8(1),56,nMB,G1H8(16),n2h8(40))
Gcoeff(:)%j = (c(17)*M(1,:)%j-c(16)*M(3,:)%j) * den(67)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(77),h0tab(:,77),[32,15,16],[0,0,0],3,1,wf16(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,39),heltab2x64(:,:,68))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(9),n2h32(23))
Gcoeff(:)%j = (c(15)*M(1,:)%j-c(14)*M(3,:)%j) * den(67)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(78),h0tab(:,78),[32,15,16],[nMT,nMT,nMT],3,1,wf16(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,40),heltab2x64(:,:,69))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(10),n2h32(24))
Gcoeff(:)%j = (c(17)*M(2,:)%j-c(16)*M(3,:)%j) * den(67)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(79),h0tab(:,79),[32,15,16],[0,0,0],3,1,wf16(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,41),heltab2x64(:,:,70))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(11),n2h32(25))
Gcoeff(:)%j = (c(15)*M(2,:)%j-c(14)*M(3,:)%j) * den(67)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(80),h0tab(:,80),[32,15,16],[nMT,nMT,nMT],3,1,wf16(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,42),heltab2x64(:,:,71))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(12),n2h32(26))
Gcoeff(:)%j = (c(17)*M(1,:)%j-c(16)*M(3,:)%j) * den(67)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(81),h0tab(:,81),[32,15,16],[0,0,0],3,1,wf16(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,43),heltab2x64(:,:,72))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(13),n2h32(27))
Gcoeff(:)%j = (c(15)*M(1,:)%j-c(14)*M(3,:)%j) * den(67)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(82),h0tab(:,82),[32,15,16],[nMB,nMB,nMB],3,1,wf16(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,44),heltab2x64(:,:,73))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(14),n2h32(28))
Gcoeff(:)%j = (c(17)*M(2,:)%j-c(16)*M(3,:)%j) * den(67)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(83),h0tab(:,83),[32,15,16],[0,0,0],3,1,wf16(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,45),heltab2x64(:,:,74))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(15),n2h32(29))
Gcoeff(:)%j = (c(15)*M(2,:)%j-c(14)*M(3,:)%j) * den(67)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(84),h0tab(:,84),[32,15,16],[nMB,nMB,nMB],3,1,wf16(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,46),heltab2x64(:,:,75))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(16),n2h32(30))
Gcoeff(:)%j = (c(6)*(-M(1,:)%j+M(2,:)%j)) * den(67)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(85),h0tab(:,85),[32,15,16],[0,0,0],3,1,wf16(:,13))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(17),m3h2x32(:,47),heltab2x64(:,:,76))
Gcoeff(:)%j = (c(6)*(M(1,:)%j-M(2,:)%j)) * den(67)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(86),h0tab(:,86),[32,15,16],[0,0,0],3,1,wf16(:,13))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(18),m3h2x32(:,48),heltab2x64(:,:,77))
Gcoeff(:)%j = (c(6)*(M(1,:)%j-M(2,:)%j)) * den(67)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(87),h0tab(:,87),[32,15,16],[0,0,0],3,1,wf16(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(19),m3h2x32(:,49),heltab2x64(:,:,78))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(68)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(88),h0tab(:,88),[32,8,23],[nMB,0,nMB],3,1,wf16(:,15))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,50),heltab2x64(:,:,79))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(20),n2h32(31))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(68)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(89),h0tab(:,89),[32,8,23],[0,nMB,0],3,1,wf16(:,15))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(21),m3h2x32(:,51),heltab2x64(:,:,80))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(69)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(90),h0tab(:,90),[39,8,16],[0,nMB,nMB],3,1,wf16(:,17))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,17),G0H4(3),m3h16x4(:,5),heltab2x64(:,:,81))
Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(69)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(91),h0tab(:,91),[39,8,16],[nMB,0,0],3,1,wf16(:,17))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,17),G0H4(4),m3h16x4(:,6),heltab2x64(:,:,82))
  call Hloop_A_Q(ntryL,G0H4(4),39,nMB,G1H4(20),n2h4(51))
Gcoeff(:)%j = (c(17)*M(1,:)%j-c(16)*M(3,:)%j) * den(70)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(92),h0tab(:,92),[32,15,16],[0,0,0],3,1,wf16(:,18))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,52),heltab2x64(:,:,83))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(22),n2h32(32))
Gcoeff(:)%j = (c(15)*M(1,:)%j-c(14)*M(3,:)%j) * den(70)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(93),h0tab(:,93),[32,15,16],[nMT,nMT,nMT],3,1,wf16(:,18))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,53),heltab2x64(:,:,84))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(23),n2h32(33))
Gcoeff(:)%j = (c(17)*M(2,:)%j-c(16)*M(3,:)%j) * den(70)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(94),h0tab(:,94),[32,15,16],[0,0,0],3,1,wf16(:,18))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,54),heltab2x64(:,:,85))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(24),n2h32(34))
Gcoeff(:)%j = (c(15)*M(2,:)%j-c(14)*M(3,:)%j) * den(70)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(95),h0tab(:,95),[32,15,16],[nMT,nMT,nMT],3,1,wf16(:,18))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,55),heltab2x64(:,:,86))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(25),n2h32(35))
Gcoeff(:)%j = (c(17)*M(1,:)%j-c(16)*M(3,:)%j) * den(70)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(96),h0tab(:,96),[32,15,16],[0,0,0],3,1,wf16(:,18))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,56),heltab2x64(:,:,87))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(26),n2h32(36))
Gcoeff(:)%j = (c(15)*M(1,:)%j-c(14)*M(3,:)%j) * den(70)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(97),h0tab(:,97),[32,15,16],[nMB,nMB,nMB],3,1,wf16(:,18))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,57),heltab2x64(:,:,88))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(27),n2h32(37))
Gcoeff(:)%j = (c(17)*M(2,:)%j-c(16)*M(3,:)%j) * den(70)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(98),h0tab(:,98),[32,15,16],[0,0,0],3,1,wf16(:,18))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,58),heltab2x64(:,:,89))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(28),n2h32(38))
Gcoeff(:)%j = (c(15)*M(2,:)%j-c(14)*M(3,:)%j) * den(70)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(99),h0tab(:,99),[32,15,16],[nMB,nMB,nMB],3,1,wf16(:,18))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,59),heltab2x64(:,:,90))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(29),n2h32(39))
Gcoeff(:)%j = (c(6)*(-M(1,:)%j+M(2,:)%j)) * den(70)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(100),h0tab(:,100),[32,15,16],[0,0,0],3,1,wf16(:,18))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(30),m3h2x32(:,60),heltab2x64(:,:,91))
Gcoeff(:)%j = (c(6)*(M(1,:)%j-M(2,:)%j)) * den(70)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(101),h0tab(:,101),[32,15,16],[0,0,0],3,1,wf16(:,18))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(31),m3h2x32(:,61),heltab2x64(:,:,92))
Gcoeff(:)%j = (c(6)*(M(1,:)%j-M(2,:)%j)) * den(70)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(102),h0tab(:,102),[32,15,16],[0,0,0],3,1,wf16(:,18))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(32),m3h2x32(:,62),heltab2x64(:,:,93))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(71)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(103),h0tab(:,103),[32,4,27],[0,0,0],3,1,wf16(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,63),heltab2x64(:,:,94))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(33),n2h32(40))
Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(71)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(104),h0tab(:,104),[32,4,27],[0,0,0],3,1,wf16(:,20))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(34),m3h2x32(:,64),heltab2x64(:,:,95))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(72)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(105),h0tab(:,105),[43,4,16],[0,0,0],3,1,wf16(:,22))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,22),G0H4(4),m3h16x4(:,7),heltab2x64(:,:,96))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(72)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(106),h0tab(:,106),[43,4,16],[0,0,0],3,1,wf16(:,22))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,22),G0H4(5),m3h16x4(:,8),heltab2x64(:,:,97))
  call Hloop_Q_A(ntryL,G0H4(5),43,0,G1H4(29),n2h4(52))
  call ol_merge(ntryL,G1H4(8),[G1H4(37)])
  call ol_merge(ntryL,G1H8(15),[G1H8(30),G1H8(25),G1H8(13),G1H8(21),G1H8(17)])
  call ol_merge(ntryL,G1H8(16),[G1H8(31),G1H8(26),G1H8(27)])
  call ol_merge(ntryL,G1H16(5),[G1H16(22)])
  call ol_merge(ntryL,G1H16(6),[G1H16(21)])
  call ol_merge(ntryL,G1H16(18),[G0H16(2),G0H16(3),G0H16(6)])
  call ol_merge(ntryL,G1H16(16),[G0H16(5),G0H16(4),G0H16(1)])
  call ol_merge(ntryL,G0H4(3),[G0H4(1)])
  call ol_merge(ntryL,G1H4(20),[G1H4(22)])
  call ol_merge(ntryL,G0H4(4),[G0H4(2)])
  call ol_merge(ntryL,G1H4(29),[G1H4(3)])
  call ol_merge(ntryL,G1H32(13),[G1H32(9)])
  call ol_merge(ntryL,G1H32(15),[G1H32(11)])
  call ol_merge(ntryL,G1H32(26),[G1H32(22)])
  call ol_merge(ntryL,G1H32(28),[G1H32(24)])
  call Hloop_QV_A(ntryL,G1H4(26),ex5(:),G1H2(111),m3h2x2(:,71),heltab2x4(:,:,92))
  call Hloop_Q_A(ntryL,G1H2(111),59,0,G2H2(33),n2h2(62))
  call Hloop_AV_Q(ntryL,G1H4(8),ex5(:),G1H2(112),m3h2x2(:,72),heltab2x4(:,:,93))
  call Hloop_A_Q(ntryL,G1H2(112),55,nMB,G2H2(2),n2h2(63))
  call Hloop_AW_Q(ntryL,G1H8(15),wf4(:,4),G1H2(93),m3h4x2(:,34),heltab2x8(:,:,67))
  call Hloop_A_Q(ntryL,G1H2(93),55,nMB,G2H2(29),n2h2(64))
  call Hloop_QW_A(ntryL,G1H8(16),wf4(:,4),G1H2(98),m3h4x2(:,35),heltab2x8(:,:,68))
  call Hloop_Q_A(ntryL,G1H2(98),59,0,G2H2(5),n2h2(65))
  call Hloop_QW_A(ntryL,G1H16(5),wf4(:,4),G1H4(30),m3h4x4(:,27),heltab2x16(:,:,50))
  call Hloop_Q_A(ntryL,G1H4(30),43,0,G2H4(20),n2h4(53))
  call Hloop_AW_Q(ntryL,G1H16(6),wf4(:,4),G1H4(1),m3h4x4(:,28),heltab2x16(:,:,51))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMB,G2H4(24),n2h4(54))
  call Hloop_AV_Q(ntryL,G1H16(8),ex5(:),G1H8(18),m3h2x8(:,19),heltab2x16(:,:,52))
  call Hloop_A_Q(ntryL,G1H8(18),52,0,G2H8(5),n2h8(41))
  call Hloop_VA_Q(ntryL,G1H16(18),wf8(:,6),G1H2(104),m3h8x2(:,6),heltab2x16(:,:,53))
  call Hloop_A_Q(ntryL,G1H2(104),55,nMB,G2H2(8),n2h2(66))
  call Hloop_VA_Q(ntryL,G1H16(16),ex3(:),G1H8(23),m3h2x8(:,20),heltab2x16(:,:,54))
  call Hloop_A_Q(ntryL,G1H8(23),52,0,G2H8(4),n2h8(42))
  call Hloop_AQ_V(ntryL,G1H32(1),wf8(:,3),G1H4(9),m3h8x4(:,7),heltab2x32(:,:,31))
  call Hloop_VQ_A(ntryL,G1H32(2),wf8(:,3),G1H4(18),m3h8x4(:,8),heltab2x32(:,:,32))
  call Hloop_Q_A(ntryL,G1H4(18),43,0,G2H4(6),n2h4(55))
  call Hloop_AQ_V(ntryL,G1H32(3),ex4(:),G1H16(17),m3h2x16(:,15),heltab2x32(:,:,33))
  call Hloop_VQ_A(ntryL,G1H32(4),ex4(:),G1H16(19),m3h2x16(:,16),heltab2x32(:,:,34))
  call Hloop_Q_A(ntryL,G1H16(19),40,nMB,G2H16(1),n2h16(29))
  call Hloop_QA_V(ntryL,G1H32(5),wf8(:,6),G1H4(21),m3h8x4(:,9),heltab2x32(:,:,35))
  call Hloop_VA_Q(ntryL,G1H32(6),wf8(:,6),G1H4(17),m3h8x4(:,10),heltab2x32(:,:,36))
  call Hloop_A_Q(ntryL,G1H4(17),39,nMB,G2H4(7),n2h4(56))
  call Hloop_QA_V(ntryL,G1H32(7),ex3(:),G1H16(20),m3h2x16(:,17),heltab2x32(:,:,37))
  call Hloop_VA_Q(ntryL,G1H32(8),ex3(:),G1H16(23),m3h2x16(:,18),heltab2x32(:,:,38))
  call Hloop_A_Q(ntryL,G1H16(23),36,0,G2H16(2),n2h16(30))
  call Hloop_VQ_A(ntryL,G0H16(7),wf8(:,3),G0H2(1),m3h8x2(:,7),heltab2x16(:,:,55))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(109),n2h2(67))
  call Hloop_AQ_V(ntryL,G1H16(7),wf8(:,3),G1H2(110),m3h8x2(:,8),heltab2x16(:,:,56))
  call Hloop_VQ_A(ntryL,G0H4(3),ex4(:),G0H2(1),m3h2x2(:,73),heltab2x4(:,:,94))
  call Hloop_Q_A(ntryL,G0H2(1),47,nMB,G1H2(31),n2h2(68))
  call Hloop_AQ_V(ntryL,G1H4(20),ex4(:),G1H2(42),m3h2x2(:,74),heltab2x4(:,:,95))
  call Hloop_VA_Q(ntryL,G0H16(8),wf8(:,6),G0H2(1),m3h8x2(:,9),heltab2x16(:,:,57))
  call Hloop_A_Q(ntryL,G0H2(1),47,nMB,G1H2(53),n2h2(69))
  call Hloop_QA_V(ntryL,G1H16(13),wf8(:,6),G1H2(86),m3h8x2(:,10),heltab2x16(:,:,58))
  call Hloop_VA_Q(ntryL,G0H4(4),ex3(:),G0H2(1),m3h2x2(:,75),heltab2x4(:,:,96))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(97),n2h2(70))
  call Hloop_QA_V(ntryL,G1H4(29),ex3(:),G1H2(108),m3h2x2(:,76),heltab2x4(:,:,97))
  call Hloop_QA_V(ntryL,G1H16(14),wf8(:,6),G1H2(10),m3h8x2(:,11),heltab2x16(:,:,59))
  call Hloop_QA_V(ntryL,G1H16(12),ex3(:),G1H8(28),m3h2x8(:,21),heltab2x16(:,:,60))
  call Hloop_AV_Q(ntryL,G1H32(13),wf16(:,13),G1H2(11),m3h16x2(:,1),heltab2x32(:,:,39))
  call Hloop_A_Q(ntryL,G1H2(11),47,0,G2H2(11),n2h2(71))
  call Hloop_AV_Q(ntryL,G1H32(10),wf16(:,13),G1H2(15),m3h16x2(:,2),heltab2x32(:,:,40))
  call Hloop_A_Q(ntryL,G1H2(15),47,nMT,G2H2(52),n2h2(72))
  call Hloop_QV_A(ntryL,G1H32(15),wf16(:,13),G1H2(22),m3h16x2(:,3),heltab2x32(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(22),47,0,G2H2(18),n2h2(73))
  call Hloop_QV_A(ntryL,G1H32(12),wf16(:,13),G1H2(26),m3h16x2(:,4),heltab2x32(:,:,42))
  call Hloop_Q_A(ntryL,G1H2(26),47,nMT,G2H2(51),n2h2(74))
  call Hloop_AV_Q(ntryL,G1H32(14),wf16(:,13),G1H2(32),m3h16x2(:,5),heltab2x32(:,:,43))
  call Hloop_A_Q(ntryL,G1H2(32),47,nMB,G2H2(25),n2h2(75))
  call Hloop_QV_A(ntryL,G1H32(16),wf16(:,13),G1H2(43),m3h16x2(:,6),heltab2x32(:,:,44))
  call Hloop_Q_A(ntryL,G1H2(43),47,nMB,G2H2(48),n2h2(76))
  call Hloop_DV_C(ntryL,G1H32(17),32,wf16(:,13),G2H2(47),m3h16x2(:,7),heltab2x32(:,:,45))
  call Hloop_CV_D(ntryL,G1H32(18),32,wf16(:,13),15,G2H2(36),m3h16x2(:,8),heltab2x32(:,:,46))
  call Hloop_UV_W(ntryL,G1H32(19),32,wf16(:,13),15,G2H2(43),m3h16x2(:,9),heltab2x32(:,:,47))
  call Hloop_AQ_V(ntryL,G1H32(20),ex4(:),G1H16(24),m3h2x16(:,19),heltab2x32(:,:,48))
  call Hloop_VQ_A(ntryL,G1H32(21),ex4(:),G1H16(9),m3h2x16(:,20),heltab2x32(:,:,49))
  call Hloop_Q_A(ntryL,G1H16(9),40,nMB,G2H16(3),n2h16(31))
  call Hloop_AV_Q(ntryL,G1H32(26),wf16(:,18),G1H2(44),m3h16x2(:,10),heltab2x32(:,:,50))
  call Hloop_A_Q(ntryL,G1H2(44),47,0,G2H2(39),n2h2(77))
  call Hloop_AV_Q(ntryL,G1H32(23),wf16(:,18),G1H2(48),m3h16x2(:,11),heltab2x32(:,:,51))
  call Hloop_A_Q(ntryL,G1H2(48),47,nMT,G2H2(38),n2h2(78))
  call Hloop_QV_A(ntryL,G1H32(28),wf16(:,18),G1H2(55),m3h16x2(:,12),heltab2x32(:,:,52))
  call Hloop_Q_A(ntryL,G1H2(55),47,0,G2H2(31),n2h2(79))
  call Hloop_QV_A(ntryL,G1H32(25),wf16(:,18),G1H2(59),m3h16x2(:,13),heltab2x32(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(59),47,nMT,G2H2(34),n2h2(80))
  call Hloop_AV_Q(ntryL,G1H32(27),wf16(:,18),G1H2(60),m3h16x2(:,14),heltab2x32(:,:,54))
  call Hloop_A_Q(ntryL,G1H2(60),47,nMB,G2H2(40),n2h2(81))
  call Hloop_QV_A(ntryL,G1H32(29),wf16(:,18),G1H2(71),m3h16x2(:,15),heltab2x32(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(71),47,nMB,G2H2(42),n2h2(82))
  call Hloop_DV_C(ntryL,G1H32(30),32,wf16(:,18),G2H2(49),m3h16x2(:,16),heltab2x32(:,:,56))
  call Hloop_CV_D(ntryL,G1H32(31),32,wf16(:,18),15,G2H2(50),m3h16x2(:,17),heltab2x32(:,:,57))
  call Hloop_UV_W(ntryL,G1H32(32),32,wf16(:,18),15,G2H2(54),m3h16x2(:,18),heltab2x32(:,:,58))
  call Hloop_QA_V(ntryL,G1H32(33),ex3(:),G1H16(15),m3h2x16(:,21),heltab2x32(:,:,59))
  call Hloop_VA_Q(ntryL,G1H32(34),ex3(:),G1H16(2),m3h2x16(:,22),heltab2x32(:,:,60))
  call Hloop_A_Q(ntryL,G1H16(2),36,0,G2H16(4),n2h16(32))
  call ol_merge(ntryL,G2H2(76),[G2H2(61),G2H2(35),G2H2(27)])
  call ol_merge(ntryL,G2H2(70),[G2H2(64),G2H2(37),G2H2(30)])
  call ol_merge(ntryL,G1H2(129),[G1H2(58)])
call HGT_w2_OLR(G1H2(27),1,1,2)
call HGT_w2_invQ_OLR(G1H2(27),2,5,2)
  call ol_merge(ntryL,G1H2(27),[G1H2(129)])
  call ol_merge(ntryL,G1H2(80),[G1H2(7)])
call HGT_w2_OLR(G1H2(38),1,1,2)
call HGT_w2_invQ_OLR(G1H2(38),2,5,2)
  call ol_merge(ntryL,G1H2(38),[G1H2(80)])
call HGT_w2_OLR(G1H4(13),1,1,4)
call HGT_w2_invQ_OLR(G1H4(13),2,5,4)
  call ol_merge(ntryL,G1H4(13),[G1H4(36)])
  call ol_merge(ntryL,G1H4(28),[G1H4(14)])
call HGT_w2_OLR(G1H4(28),1,1,4)
call HGT_w2_invQ_OLR(G1H4(28),2,5,4)
  call ol_merge(ntryL,G1H4(28),[G1H4(15)])
  call ol_merge(ntryL,G1H2(53),[G1H2(14),G1H2(8)])
call HGT_w2_OLR(G1H2(66),1,1,2)
call HGT_w2_invQ_OLR(G1H2(66),2,5,2)
  call ol_merge(ntryL,G1H2(66),[G1H2(53)])
  call ol_merge(ntryL,G1H4(5),[G1H4(19)])
call HGT_w2_OLR(G1H4(5),1,1,4)
call HGT_w2_invQ_OLR(G1H4(5),2,5,4)
  call ol_merge(ntryL,G1H4(5),[G1H4(34)])
  call ol_merge(ntryL,G2H2(8),[G2H2(73)])
call HGT_w2_OLR(G1H4(23),1,1,4)
call HGT_w2_invQ_OLR(G1H4(23),2,5,4)
  call ol_merge(ntryL,G1H4(23),[G1H4(31)])
  call ol_merge(ntryL,G2H4(6),[G2H4(5)])
  call ol_merge(ntryL,G2H4(7),[G2H4(14)])
  call ol_merge(ntryL,G1H2(97),[G1H2(122),G1H2(47)])
call HGT_w2_OLR(G1H2(92),1,1,2)
call HGT_w2_invQ_OLR(G1H2(92),2,5,2)
  call ol_merge(ntryL,G1H2(92),[G1H2(97)])
  call ol_merge(ntryL,G1H2(150),[G1H2(40),G1H2(99)])
  call ol_merge(ntryL,G1H2(155),[G1H2(72),G1H2(103)])
  call ol_merge(ntryL,G1H2(142),[G1H2(105),G1H2(9)])
  call ol_merge(ntryL,G1H2(147),[G1H2(13),G1H2(20)])
  call ol_merge(ntryL,G1H2(86),[G1H2(83),G1H2(64)])
  call ol_merge(ntryL,G2H2(54),[G2H2(43),G1H2(116),G1H2(114),G1H2(5),G1H2(75)])
  call ol_merge(ntryL,G1H2(110),[G1H2(63),G1H2(4)])
  call ol_merge(ntryL,G1H2(12),[G1H2(95),G1H2(16)])
  call ol_merge(ntryL,G1H2(118),[G1H2(33)])
  call ol_merge(ntryL,G2H2(39),[G2H2(11),G1H2(123),G1H2(37)])
  call ol_merge(ntryL,G1H2(109),[G1H2(125),G1H2(49)])
  call ol_merge(ntryL,G2H2(31),[G2H2(18),G1H2(130),G1H2(54)])
  call ol_merge(ntryL,G1H2(62),[G1H2(29),G1H2(65)])
  call ol_merge(ntryL,G1H2(10),[G1H2(70)])
  call ol_merge(ntryL,G1H2(132),[G1H2(81)])
  call ol_merge(ntryL,G2H2(42),[G2H2(48),G1H2(137),G1H2(82)])
  call ol_merge(ntryL,G2H2(40),[G2H2(25),G1H2(139),G1H2(96)])
  call ol_merge(ntryL,G1H2(42),[G1H2(36),G1H2(52)])
  call ol_merge(ntryL,G1H2(108),[G1H2(102),G1H2(28)])
  call ol_merge(ntryL,G1H2(31),[G1H2(136),G1H2(69)])
  call ol_merge(ntryL,G1H2(146),[G1H2(141)])
  call ol_merge(ntryL,G1H2(154),[G1H2(149)])
  call ol_merge(ntryL,G1H4(9),[G1H4(6)])
  call ol_merge(ntryL,G1H4(21),[G1H4(4)])
  call ol_merge(ntryL,G2H2(38),[G2H2(52)])
  call ol_merge(ntryL,G2H2(34),[G2H2(51)])
  call ol_merge(ntryL,G2H2(49),[G2H2(47)])
  call ol_merge(ntryL,G2H2(50),[G2H2(36)])
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(76),ex4(:),G2tensor(84),m3h2x1(:,180),heltab2x2(:,:,180))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(70),ex4(:),G2tensor(2),m3h2x1(:,181),heltab2x2(:,:,181))
  call Hloop_QV_A(ntryL,G1H2(27),ex5(:),G1H1(1),m3h2x1(:,182),heltab2x2(:,:,182))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(19),n2h1(158))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(58),ex3(:),G2tensor(4),m3h2x1(:,183),heltab2x2(:,:,183))
  call Hloop_AV_Q(ntryL,G1H2(38),ex5(:),G1H1(1),m3h2x1(:,184),heltab2x2(:,:,184))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(6),n2h1(159))
  call Hloop_AW_Q(ntryL,G1H4(13),wf4(:,4),G1H1(1),m3h4x1(:,22),heltab2x4(:,:,98))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(10),n2h1(160))
  call Hloop_QW_A(ntryL,G1H4(28),wf4(:,4),G1H1(1),m3h4x1(:,23),heltab2x4(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(14),n2h1(161))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(67),ex3(:),G2tensor(15),m3h2x1(:,185),heltab2x2(:,:,185))
  call Hloop_AV_Q(ntryL,G1H2(66),ex5(:),G1H1(1),m3h2x1(:,186),heltab2x2(:,:,186))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(18),n2h1(162))
  call Hloop_AW_Q(ntryL,G1H4(5),wf4(:,4),G1H1(1),m3h4x1(:,24),heltab2x4(:,:,100))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(22),n2h1(163))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(8),ex4(:),G2tensor(39),m3h2x1(:,187),heltab2x2(:,:,187))
  call Hloop_AW_Q(ntryL,G1H4(23),wf4(:,4),G1H1(1),m3h4x1(:,25),heltab2x4(:,:,101))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(23),n2h1(164))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(6),wf4(:,5),G2tensor(26),m3h4x1(:,26),heltab2x4(:,:,102))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(7),wf4(:,10),G2tensor(30),m3h4x1(:,27),heltab2x4(:,:,103))
  call Hloop_AV_Q(ntryL,G1H2(92),ex5(:),G1H1(1),m3h2x1(:,188),heltab2x2(:,:,188))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(43),n2h1(165))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(7),wf8(:,3),G2tensor(31),m3h8x1(:,6),heltab2x8(:,:,69))
  call Hloop_VQ_A(ntryL,G1H2(150),ex4(:),G1H1(1),m3h2x1(:,189),heltab2x2(:,:,189))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(34),n2h1(166))
  call Hloop_VQ_A(ntryL,G1H2(155),ex4(:),G1H1(1),m3h2x1(:,190),heltab2x2(:,:,190))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(38),n2h1(167))
  call Hloop_VA_Q(ntryL,G1H2(142),ex3(:),G1H1(1),m3h2x1(:,191),heltab2x2(:,:,191))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(42),n2h1(168))
  call Hloop_VA_Q(ntryL,G1H2(147),ex3(:),G1H1(1),m3h2x1(:,192),heltab2x2(:,:,192))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(146),n2h1(169))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(86),47,ex5(:),16,G2tensor(95),m3h2x1(:,193),heltab2x2(:,:,193))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(54),47,ex5(:),16,G3tensor(1),m3h2x1(:,194),heltab2x2(:,:,194))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(110),47,ex5(:),16,G2tensor(191),m3h2x1(:,195),heltab2x2(:,:,195))
  call Hloop_VA_Q(ntryL,G1H2(12),ex3(:),G1H1(1),m3h2x1(:,196),heltab2x2(:,:,196))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(82),n2h1(170))
  call Hloop_VA_Q(ntryL,G1H2(21),ex3(:),G1H1(1),m3h2x1(:,197),heltab2x2(:,:,197))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(70),n2h1(171))
  call Hloop_AV_Q(ntryL,G1H2(118),ex5(:),G1H1(1),m3h2x1(:,198),heltab2x2(:,:,198))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(7),n2h1(172))
  call Hloop_AV_Q(ntryL,G2H2(39),ex5(:),G2H1(1),m3h2x1(:,199),heltab2x2(:,:,199))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(2),n2h1(173))
  call Hloop_QW_A(ntryL,G1H4(16),wf4(:,4),G1H1(1),m3h4x1(:,28),heltab2x4(:,:,104))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(72),n2h1(174))
  call Hloop_QV_A(ntryL,G1H2(109),ex5(:),G1H1(1),m3h2x1(:,200),heltab2x2(:,:,200))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(175))
  call Hloop_QV_A(ntryL,G2H2(31),ex5(:),G2H1(1),m3h2x1(:,201),heltab2x2(:,:,201))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(3),n2h1(176))
  call Hloop_VQ_A(ntryL,G1H2(62),ex4(:),G1H1(1),m3h2x1(:,202),heltab2x2(:,:,202))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(74),n2h1(177))
  call Hloop_VQ_A(ntryL,G1H2(10),ex4(:),G1H1(1),m3h2x1(:,203),heltab2x2(:,:,203))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(80),n2h1(178))
  call Hloop_QV_A(ntryL,G1H2(132),ex5(:),G1H1(1),m3h2x1(:,204),heltab2x2(:,:,204))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(77),n2h1(179))
  call Hloop_QV_A(ntryL,G2H2(42),ex5(:),G2H1(1),m3h2x1(:,205),heltab2x2(:,:,205))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(4),n2h1(180))
  call Hloop_AW_Q(ntryL,G1H4(38),wf4(:,4),G1H1(1),m3h4x1(:,29),heltab2x4(:,:,105))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(98),n2h1(181))
  call Hloop_AV_Q(ntryL,G2H2(40),ex5(:),G2H1(1),m3h2x1(:,206),heltab2x2(:,:,206))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(5),n2h1(182))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(42),47,ex5(:),16,G2tensor(185),m3h2x1(:,207),heltab2x2(:,:,207))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(108),47,ex5(:),16,G2tensor(104),m3h2x1(:,208),heltab2x2(:,:,208))
  call Hloop_QV_A(ntryL,G1H2(31),ex5(:),G1H1(1),m3h2x1(:,209),heltab2x2(:,:,209))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(27),n2h1(183))
  call Hloop_VA_Q(ntryL,G1H2(146),ex3(:),G1H1(1),m3h2x1(:,210),heltab2x2(:,:,210))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(110),n2h1(184))
  call Hloop_VQ_A(ntryL,G1H2(154),ex4(:),G1H1(1),m3h2x1(:,211),heltab2x2(:,:,211))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(188),n2h1(185))
  call Hloop_VA_Q(ntryL,G1H4(2),wf4(:,5),G1H1(1),m3h4x1(:,30),heltab2x4(:,:,106))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(116),n2h1(186))
  call Hloop_VA_Q(ntryL,G1H4(9),wf4(:,5),G1H1(1),m3h4x1(:,31),heltab2x4(:,:,107))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(35),n2h1(187))
  call Hloop_VQ_A(ntryL,G1H4(27),wf4(:,10),G1H1(1),m3h4x1(:,32),heltab2x4(:,:,108))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(122),n2h1(188))
  call Hloop_VQ_A(ntryL,G1H4(21),wf4(:,10),G1H1(1),m3h4x1(:,33),heltab2x4(:,:,109))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(125),n2h1(189))
  call Hloop_VQ_A(ntryL,G1H8(2),wf8(:,3),G1H1(1),m3h8x1(:,7),heltab2x8(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(128),n2h1(190))
  call Hloop_VQ_A(ntryL,G1H8(11),wf8(:,3),G1H1(1),m3h8x1(:,8),heltab2x8(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(79),n2h1(191))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(33),ex3(:),G2tensor(73),m3h2x1(:,212),heltab2x2(:,:,212))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(2),ex4(:),G2tensor(1),m3h2x1(:,213),heltab2x2(:,:,213))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(29),ex4(:),G2tensor(131),m3h2x1(:,214),heltab2x2(:,:,214))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(5),ex3(:),G2tensor(76),m3h2x1(:,215),heltab2x2(:,:,215))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(20),wf4(:,5),G2tensor(134),m3h4x1(:,34),heltab2x4(:,:,110))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(24),wf4(:,10),G2tensor(137),m3h4x1(:,35),heltab2x4(:,:,111))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(5),wf8(:,3),G2tensor(86),m3h8x1(:,9),heltab2x8(:,:,72))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(4),wf8(:,3),G2tensor(140),m3h8x1(:,10),heltab2x8(:,:,73))
  call Hloop_VA_Q(ntryL,G1H16(17),wf16(:,9),G1H1(1),m3h16x1(:,1),heltab2x16(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(143),n2h1(192))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H16(1),wf16(:,9),G2tensor(89),m3h16x1(:,2),heltab2x16(:,:,62))
  call Hloop_VQ_A(ntryL,G1H16(20),wf16(:,11),G1H1(1),m3h16x1(:,3),heltab2x16(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(155),n2h1(193))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H16(2),wf16(:,11),G2tensor(92),m3h16x1(:,4),heltab2x16(:,:,64))
  call Hloop_VQ_A(ntryL,G1H8(28),wf8(:,3),G1H1(1),m3h8x1(:,11),heltab2x8(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(149),n2h1(194))
  call Hloop_AV_Q(ntryL,G2H2(38),ex5(:),G2H1(1),m3h2x1(:,216),heltab2x2(:,:,216))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(6),n2h1(195))
  call Hloop_QV_A(ntryL,G2H2(34),ex5(:),G2H1(1),m3h2x1(:,217),heltab2x2(:,:,217))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(7),n2h1(196))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(49),47,ex5(:),G3tensor(8),m3h2x1(:,218),heltab2x2(:,:,218))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(50),47,ex5(:),16,G3tensor(9),m3h2x1(:,219),heltab2x2(:,:,219))
  call Hloop_VA_Q(ntryL,G1H16(24),wf16(:,15),G1H1(1),m3h16x1(:,5),heltab2x16(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(107),n2h1(197))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H16(3),wf16(:,15),G2tensor(152),m3h16x1(:,6),heltab2x16(:,:,66))
  call Hloop_VQ_A(ntryL,G1H16(15),wf16(:,20),G1H1(1),m3h16x1(:,7),heltab2x16(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(101),n2h1(198))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H16(4),wf16(:,20),G2tensor(158),m3h16x1(:,8),heltab2x16(:,:,68))
  call ol_merge_tensors(G2tensor(19),[G2tensor(8),G1tensor(193),G1tensor(188),G1tensor(18),G1tensor(67),G0tensor(193) &
    ,G0tensor(188),G0tensor(17),G0tensor(12)])
  call ol_merge_tensors(G2tensor(6),[G2tensor(12),G1tensor(213),G1tensor(118),G1tensor(44),G1tensor(30),G0tensor(213) &
    ,G0tensor(118),G0tensor(27),G0tensor(22)])
  call ol_merge_tensors(G2tensor(14),[G2tensor(159),G2tensor(16),G1tensor(187),G1tensor(47),G1tensor(27),G1tensor(56) &
    ,G0tensor(187),G0tensor(58),G0tensor(37),G0tensor(32)])
  call ol_merge_tensors(G2tensor(22),[G2tensor(132),G2tensor(17),G2tensor(20),G1tensor(117),G1tensor(78),G1tensor(5),G1tensor(37) &
    ,G0tensor(117),G0tensor(78),G0tensor(42),G0tensor(7)])
  call ol_merge_tensors(G2tensor(131),[G2tensor(186),G2tensor(123),G2tensor(99),G2tensor(40),G2tensor(24),G1tensor(108) &
    ,G1tensor(103),G1tensor(87),G1tensor(65),G1tensor(16),G1tensor(57),G0tensor(108),G0tensor(103),G0tensor(87),G0tensor(52) &
    ,G0tensor(47),G0tensor(43)])
  call ol_merge_tensors(G2tensor(74),[G2tensor(165),G2tensor(105),G2tensor(28),G1tensor(197),G1tensor(133),G1tensor(128) &
    ,G1tensor(59),G1tensor(45),G1tensor(34),G0tensor(197),G0tensor(133),G0tensor(128),G0tensor(68),G0tensor(62),G0tensor(57)])
  call ol_merge_tensors(G2tensor(76),[G2tensor(189),G2tensor(126),G2tensor(111),G2tensor(44),G2tensor(32),G1tensor(92) &
    ,G1tensor(70),G1tensor(58),G1tensor(60),G0tensor(92),G0tensor(72),G0tensor(67),G0tensor(33)])
  call ol_merge_tensors(G2tensor(82),[G2tensor(153),G2tensor(117),G2tensor(36),G1tensor(177),G1tensor(148),G1tensor(143) &
    ,G1tensor(82),G1tensor(77),G1tensor(71),G0tensor(177),G0tensor(148),G0tensor(143),G0tensor(82),G0tensor(77),G0tensor(48)])
  call ol_merge_tensors(G2tensor(133),[G2tensor(130),G2tensor(13),G2tensor(3),G1tensor(120),G1tensor(112),G1tensor(100) &
    ,G1tensor(83),G0tensor(120),G0tensor(112),G0tensor(100),G0tensor(83)])
  call ol_merge_tensors(G2tensor(158),[G2tensor(101),G2tensor(92),G2tensor(155),G2tensor(193),G2tensor(109),G2tensor(97) &
    ,G2tensor(85),G2tensor(83),G2tensor(56),G2tensor(50),G2tensor(5),G1tensor(175),G1tensor(115),G1tensor(52),G1tensor(55) &
    ,G1tensor(25),G0tensor(175),G0tensor(115),G0tensor(65),G0tensor(10),G0tensor(5)])
  call ol_merge_tensors(G2tensor(104),[G2tensor(43),G2tensor(192),G2tensor(180),G2tensor(129),G2tensor(9),G1tensor(232) &
    ,G1tensor(178),G1tensor(158),G1tensor(97),G1tensor(93),G1tensor(7),G0tensor(232),G0tensor(178),G0tensor(158),G0tensor(97) &
    ,G0tensor(93),G0tensor(2)])
  call ol_merge_tensors(G2tensor(136),[G2tensor(21),G1tensor(130),G1tensor(20),G0tensor(130),G0tensor(18)])
  call ol_merge_tensors(G2tensor(139),[G2tensor(25),G1tensor(135),G1tensor(9),G0tensor(135),G0tensor(19)])
  call ol_merge_tensors(G2tensor(190),[G2tensor(115),G2tensor(88),G2tensor(59),G2tensor(29),G1tensor(210),G1tensor(140) &
    ,G1tensor(75),G1tensor(24),G0tensor(210),G0tensor(140),G0tensor(75),G0tensor(20)])
  call ol_merge_tensors(G2tensor(142),[G2tensor(33),G1tensor(145),G1tensor(48),G0tensor(145),G0tensor(28)])
  call ol_merge_tensors(G2tensor(145),[G2tensor(37),G1tensor(150),G1tensor(50),G0tensor(150),G0tensor(29)])
  call ol_merge_tensors(G2tensor(187),[G2tensor(103),G2tensor(91),G2tensor(53),G2tensor(41),G1tensor(185),G1tensor(155) &
    ,G1tensor(28),G1tensor(72),G0tensor(185),G0tensor(155),G0tensor(55),G0tensor(30)])
  call ol_merge_tensors(G2tensor(134),[G2tensor(127),G2tensor(87),G2tensor(71),G2tensor(45),G1tensor(137),G1tensor(95),G1tensor(2) &
    ,G1tensor(12),G0tensor(137),G0tensor(95),G0tensor(38),G0tensor(15)])
  call ol_merge_tensors(G2tensor(35),[G2tensor(26),G2tensor(178),G2tensor(157),G2tensor(148),G2tensor(63),G2tensor(52) &
    ,G2tensor(46),G1tensor(230),G1tensor(160),G1tensor(40),G1tensor(3),G0tensor(230),G0tensor(160),G0tensor(54),G0tensor(39)])
  call ol_merge_tensors(G2tensor(152),[G2tensor(89),G2tensor(94),G2tensor(81),G2tensor(47),G1tensor(165),G1tensor(4),G0tensor(165) &
    ,G0tensor(40)])
  call ol_merge_tensors(G2tensor(137),[G2tensor(124),G2tensor(90),G2tensor(68),G2tensor(48),G1tensor(152),G1tensor(90) &
    ,G1tensor(66),G1tensor(43),G0tensor(152),G0tensor(90),G0tensor(25),G0tensor(8)])
  call ol_merge_tensors(G2tensor(30),[G2tensor(151),G2tensor(69),G2tensor(49),G1tensor(170),G1tensor(125),G1tensor(49) &
    ,G0tensor(170),G0tensor(125),G0tensor(9)])
  call ol_merge_tensors(G2tensor(116),[G2tensor(175),G2tensor(154),G2tensor(62),G2tensor(51),G1tensor(225),G1tensor(180) &
    ,G1tensor(23),G0tensor(225),G0tensor(180),G0tensor(53)])
  call ol_merge_tensors(G2tensor(160),[G2tensor(54),G1tensor(190),G1tensor(46),G0tensor(190),G0tensor(63)])
  call ol_merge_tensors(G2tensor(163),[G2tensor(55),G1tensor(195),G1tensor(51),G0tensor(195),G0tensor(64)])
  call ol_merge_tensors(G2tensor(122),[G2tensor(181),G2tensor(166),G2tensor(64),G2tensor(57),G1tensor(235),G1tensor(200) &
    ,G1tensor(73),G0tensor(235),G0tensor(200),G0tensor(73)])
  call ol_merge_tensors(G2tensor(125),[G2tensor(184),G2tensor(169),G2tensor(65),G2tensor(58),G1tensor(240),G1tensor(205) &
    ,G1tensor(74),G0tensor(240),G0tensor(205),G0tensor(74)])
  call ol_merge_tensors(G2tensor(172),[G2tensor(60),G1tensor(215),G1tensor(84),G0tensor(215),G0tensor(84)])
  call ol_merge_tensors(G2tensor(107),[G2tensor(143),G2tensor(121),G2tensor(61),G1tensor(220),G1tensor(85),G0tensor(220) &
    ,G0tensor(85)])
  call ol_merge_tensors(G2tensor(86),[G2tensor(128),G2tensor(66),G1tensor(105),G1tensor(13),G0tensor(105),G0tensor(3)])
  call ol_merge_tensors(G2tensor(79),[G2tensor(31),G2tensor(67),G1tensor(110),G1tensor(19),G0tensor(110),G0tensor(4)])
  call ol_merge_tensors(G2tensor(93),[G2tensor(75),G1tensor(162),G1tensor(33),G0tensor(162),G0tensor(35)])
  call ol_merge_tensors(G2tensor(149),[G2tensor(140),G2tensor(108),G2tensor(106),G2tensor(96),G2tensor(78),G1tensor(172) &
    ,G1tensor(39),G1tensor(10),G0tensor(172),G0tensor(60),G0tensor(45)])
  call ol_merge_tensors(G2tensor(102),[G2tensor(100),G1tensor(182),G1tensor(21),G0tensor(182),G0tensor(50)])
  call ol_merge_tensors(G2tensor(114),[G2tensor(112),G1tensor(207),G1tensor(64),G0tensor(207),G0tensor(70)])
  call ol_merge_tensors(G2tensor(120),[G2tensor(118),G1tensor(217),G1tensor(80),G0tensor(217),G0tensor(80)])
  call ol_merge_tensors(G2tensor(73),[G2tensor(110),G2tensor(135),G1tensor(228),G1tensor(223),G1tensor(127),G1tensor(6) &
    ,G0tensor(228),G0tensor(223),G0tensor(127),G0tensor(13)])
  call ol_merge_tensors(G2tensor(4),[G2tensor(138),G1tensor(132),G1tensor(36),G0tensor(132),G0tensor(14)])
  call ol_merge_tensors(G2tensor(1),[G2tensor(141),G1tensor(142),G1tensor(123),G1tensor(32),G0tensor(142),G0tensor(123) &
    ,G0tensor(23)])
  call ol_merge_tensors(G2tensor(84),[G2tensor(144),G1tensor(147),G1tensor(113),G1tensor(104),G1tensor(38),G0tensor(147) &
    ,G0tensor(113),G0tensor(104),G0tensor(24)])
  call ol_merge_tensors(G2tensor(70),[G2tensor(15),G2tensor(156),G2tensor(147),G1tensor(157),G1tensor(17),G1tensor(62) &
    ,G0tensor(157),G0tensor(49),G0tensor(34)])
  call ol_merge_tensors(G2tensor(39),[G2tensor(150),G1tensor(167),G1tensor(8),G0tensor(167),G0tensor(44)])
  call ol_merge_tensors(G2tensor(72),[G2tensor(162),G1tensor(192),G1tensor(35),G0tensor(192),G0tensor(59)])
  call ol_merge_tensors(G2tensor(80),[G2tensor(168),G1tensor(202),G1tensor(63),G0tensor(202),G0tensor(69)])
  call ol_merge_tensors(G2tensor(98),[G2tensor(171),G1tensor(212),G1tensor(79),G0tensor(212),G0tensor(79)])
  call ol_merge_tensors(G2tensor(185),[G2tensor(174),G1tensor(222),G1tensor(168),G1tensor(88),G0tensor(222),G0tensor(168) &
    ,G0tensor(88)])
  call ol_merge_tensors(G2tensor(11),[G2tensor(191),G2tensor(177),G1tensor(227),G1tensor(189),G1tensor(173),G1tensor(89) &
    ,G0tensor(227),G0tensor(189),G0tensor(173),G0tensor(89)])
  call ol_merge_tensors(G2tensor(95),[G2tensor(183),G1tensor(237),G1tensor(163),G1tensor(94),G0tensor(237),G0tensor(163) &
    ,G0tensor(94)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(102),G1tensor(98),G0tensor(102),G0tensor(98)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(107),G1tensor(99),G0tensor(107),G0tensor(99)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(124),G1tensor(114),G1tensor(109),G0tensor(124),G0tensor(114),G0tensor(109)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(218),G1tensor(122),G1tensor(119),G0tensor(218),G0tensor(122),G0tensor(119)])
  call ol_merge_tensors(G2tensor(34),[G1tensor(234),G1tensor(138),G1tensor(129),G0tensor(234),G0tensor(138),G0tensor(129)])
  call ol_merge_tensors(G2tensor(38),[G1tensor(239),G1tensor(139),G1tensor(134),G0tensor(239),G0tensor(139),G0tensor(134)])
  call ol_merge_tensors(G2tensor(42),[G1tensor(224),G1tensor(153),G1tensor(144),G0tensor(224),G0tensor(153),G0tensor(144)])
  call ol_merge_tensors(G2tensor(146),[G1tensor(229),G1tensor(154),G1tensor(149),G0tensor(229),G0tensor(154),G0tensor(149)])
  call ol_merge_tensors(G3tensor(9),[G3tensor(8),G3tensor(3),G3tensor(2),G3tensor(1),G1tensor(194),G1tensor(184),G1tensor(174) &
    ,G1tensor(169),G1tensor(164),G1tensor(159),G0tensor(194),G0tensor(184),G0tensor(174),G0tensor(169),G0tensor(164) &
    ,G0tensor(159)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(183),G1tensor(179),G0tensor(183),G0tensor(179)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(203),G1tensor(198),G0tensor(203),G0tensor(198)])
  call ol_merge_tensors(G2tensor(77),[G1tensor(208),G1tensor(199),G0tensor(208),G0tensor(199)])
  call ol_merge_tensors(G3tensor(5),[G3tensor(4),G1tensor(219),G1tensor(214),G1tensor(209),G1tensor(204),G0tensor(219) &
    ,G0tensor(214),G0tensor(209),G0tensor(204)])
  call ol_merge_tensors(G2tensor(188),[G1tensor(238),G1tensor(233),G0tensor(238),G0tensor(233)])
  call ol_merge_tensors(G3tensor(7),[G3tensor(6)])
call TI_triangle_red(G2tensor(19),RedBasis(30),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1,[nMB], &
    G0tensor(21))
call TI_triangle_red(G2tensor(6),RedBasis(30),mass3set(:,2),G0tensor(26),G0tensor(31),G0tensor(36),G0tensor(41),M2L1R1,[nMB], &
    G0tensor(46))
call TI_triangle_red(G2tensor(14),RedBasis(64),mass3set(:,3),G0tensor(51),G0tensor(56),G0tensor(61),G0tensor(66),M2L1R1,[nMB], &
    G0tensor(71))
call TI_triangle_red(G2tensor(22),RedBasis(65),mass3set(:,4),G0tensor(76),G0tensor(81),G0tensor(86),G0tensor(91),M2L1R1,[nMB], &
    G0tensor(96))
call TI_triangle_red(G2tensor(131),RedBasis(14),mass3set(:,3),G0tensor(101),G0tensor(106),G0tensor(111), &
    G0tensor(116),M2L1R1,[nMB],G0tensor(121))
call TI_triangle_red(G2tensor(74),RedBasis(6),mass3set(:,4),G0tensor(126),G0tensor(131),G0tensor(136),G0tensor(141),M2L1R1,[nMB], &
    G0tensor(146))
call TI_triangle_red(G2tensor(76),RedBasis(59),mass3set(:,1),G0tensor(151),G0tensor(156),G0tensor(161),G0tensor(166),M2L1R1,[nMB], &
    G0tensor(171))
call TI_triangle_red(G2tensor(82),RedBasis(9),mass3set(:,1),G0tensor(176),G0tensor(181),G0tensor(186),G0tensor(191),M2L1R1,[nMB], &
    G0tensor(196))



end subroutine vamp_1

end module ol_vamp_1_pplnjj_ckm_neexcxbgg_1_/**/REALKIND
