
! **********************************************************************
module ol_tables_storage_pplnjj_ckm_neexuxccxb_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  ! helicity tables for the 1-loop recursion
integer(intkind2), save :: h0tab(64,33)
integer(intkind2), save :: heltab2x2(2,2,19)
integer(intkind2), save :: heltab2x4(2,4,31)
integer(intkind2), save :: heltab2x8(2,8,16)
integer(intkind2), save :: heltab2x16(2,16,1)
integer(intkind2), save :: heltab2x32(2,32,10)
integer(intkind2), save :: heltab2x64(2,64,33)


  ! number of helicity states for openloops recursion steps
integer(intkind2), save :: m0h(33)
integer(intkind2), save :: m3h2x1(3,19)
integer(intkind2), save :: m3h4x1(3,17)
integer(intkind2), save :: m3h8x1(3,3)
integer(intkind2), save :: m3h2x2(3,14)
integer(intkind2), save :: m3h4x2(3,5)
integer(intkind2), save :: m3h2x4(3,8)
integer(intkind2), save :: m3h4x4(3,1)
integer(intkind2), save :: m3h8x4(3,4)
integer(intkind2), save :: m3h16x4(3,16)
integer(intkind2), save :: m3h4x8(3,5)
integer(intkind2), save :: m3h8x8(3,7)
integer(intkind2), save :: m3h2x16(3,1)
integer(intkind2), save :: m3h2x32(3,10)

integer(intkind2), save :: n2h1(14)
integer(intkind2), save :: n2h2(16)
integer(intkind2), save :: n2h4(15)
integer(intkind2), save :: n2h8(12)
integer(intkind2), save :: n2h16(1)
integer(intkind2), save :: n2h32(8)


contains

!**********************************************************************
subroutine HOL_m3_init()
!**********************************************************************
! initialize m3 arrays for helicity summation
!**********************************************************************
  use KIND_TYPES, only: REALKIND, intkind2

m3h2x1(1,:)=2
m3h2x1(2,:)=1
m3h2x1(3,:)=2
m3h4x1(1,:)=4
m3h4x1(2,:)=1
m3h4x1(3,:)=4
m3h8x1(1,:)=8
m3h8x1(2,:)=1
m3h8x1(3,:)=8
m3h2x2(1,:)=2
m3h2x2(2,:)=2
m3h2x2(3,:)=4
m3h4x2(1,:)=4
m3h4x2(2,:)=2
m3h4x2(3,:)=8
m3h2x4(1,:)=2
m3h2x4(2,:)=4
m3h2x4(3,:)=8
m3h4x4(1,:)=4
m3h4x4(2,:)=4
m3h4x4(3,:)=16
m3h8x4(1,:)=8
m3h8x4(2,:)=4
m3h8x4(3,:)=32
m3h16x4(1,:)=16
m3h16x4(2,:)=4
m3h16x4(3,:)=64
m3h4x8(1,:)=4
m3h4x8(2,:)=8
m3h4x8(3,:)=32
m3h8x8(1,:)=8
m3h8x8(2,:)=8
m3h8x8(3,:)=64
m3h2x16(1,:)=2
m3h2x16(2,:)=16
m3h2x16(3,:)=32
m3h2x32(1,:)=2
m3h2x32(2,:)=32
m3h2x32(3,:)=64

n2h1(:)=1
n2h2(:)=2
n2h4(:)=4
n2h8(:)=8
n2h16(:)=16
n2h32(:)=32


end subroutine HOL_m3_init

!**********************************************************************

end module ol_tables_storage_pplnjj_ckm_neexuxccxb_1_/**/REALKIND

! **********************************************************************
module ol_tensor_sum_storage_pplnjj_ckm_neexuxccxb_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol, hcl, met
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  type(met), save :: M2L1R1

  ! Declarations of loop wave function tensors

  type(hol), save :: G1H1(1)
  type(hol), save :: G1H2(3)
  type(hol), save :: G2H2(9)
  type(hol), save :: G0H4(1)
  type(hol), save :: G1H4(12)
  type(hol), save :: G2H4(2)
  type(hol), save :: G0H8(2)
  type(hol), save :: G1H8(5)
  type(hol), save :: G2H8(2)
  type(hol), save :: G0H16(1)
  type(hol), save :: G1H16(1)
  type(hol), save :: G0H32(2)
  type(hol), save :: G1H32(4)
  type(hol), save :: G0H64(1)
  type(hcl), save, dimension(107) :: G0tensor
  type(hcl), save, dimension(55) :: G1tensor
  type(hcl), save, dimension(18) :: G2tensor



  ! Declarations for on-the-fly tensor reduction 
type (basis),      save :: RedBasis(26)
type (redset4),    save :: RedSet_4(13)
type (redset5),    save :: RedSet_5(2)
integer, save :: mass2set(0:1,4)
integer, save :: mass3set(0:2,4)
integer, save :: mass4set(0:3,3)
integer, save :: mass5set(0:4,1)



  ! Declarations for TI calls

  integer, save :: momenta_1(2)
  integer, save :: momenta_2(2)
  integer, save :: momenta_3(2)
  integer, save :: momenta_4(2)
  integer, save :: momenta_5(2)
  integer, save :: momenta_6(2)
  integer, save :: momenta_7(2)
  integer, save :: momenta_8(2)
  integer, save :: momenta_9(2)
  integer, save :: momenta_10(2)
  integer, save :: momenta_11(2)
  integer, save :: momenta_12(2)
  integer, save :: momenta_13(2)
  integer, save :: momenta_14(2)
  integer, save :: momenta_15(3)
  integer, save :: momenta_16(3)
  integer, save :: momenta_17(3)
  integer, save :: momenta_18(3)
  integer, save :: momenta_19(3)
  integer, save :: momenta_20(3)
  integer, save :: momenta_21(3)
  integer, save :: momenta_22(3)
  integer, save :: momenta_23(3)
  integer, save :: momenta_24(3)
  integer, save :: momenta_25(3)
  integer, save :: momenta_26(3)
  integer, save :: momenta_27(3)
  integer, save :: momenta_28(3)
  integer, save :: momenta_29(3)
  integer, save :: momenta_30(3)
  integer, save :: momenta_31(3)
  integer, save :: momenta_32(3)
  integer, save :: momenta_33(3)
  integer, save :: momenta_34(3)
  integer, save :: momenta_35(3)
  integer, save :: momenta_36(4)
  integer, save :: momenta_37(4)
  integer, save :: momenta_38(4)
  integer, save :: momenta_39(4)
  integer, save :: momenta_40(4)
  integer, save :: momenta_41(4)
  integer, save :: momenta_42(4)
  integer, save :: momenta_43(4)
  integer, save :: momenta_44(4)
  integer, save :: momenta_45(4)
  integer, save :: momenta_46(4)
  integer, save :: momenta_47(5)
  integer, save :: momenta_48(5)

  integer, save :: masses2_1(2)
  integer, save :: masses2_2(2)
  integer, save :: masses2_3(2)
  integer, save :: masses2_4(2)
  integer, save :: masses2_5(2)
  integer, save :: masses2_6(2)
  integer, save :: masses2_7(3)
  integer, save :: masses2_8(3)
  integer, save :: masses2_9(3)
  integer, save :: masses2_10(3)
  integer, save :: masses2_11(4)
  integer, save :: masses2_12(4)
  integer, save :: masses2_13(4)
  integer, save :: masses2_14(4)
  integer, save :: masses2_15(5)

type(scalarbox), save :: ScalarBoxes(9)

integer, save :: sbarray_1(5)
integer, save :: sbarray_2(5)

  type(hcl), save, dimension(55) :: T0sum
  type(hcl), save, dimension(2) :: T1sum


  contains

!**********************************************************************
subroutine HOL_memory_allocation()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none

    call hol_allocation(4,5,4,1,G1H1,1)
  call hol_allocation(4,5,4,2,G1H2,3)
  call hol_allocation(4,15,4,2,G2H2,9)
  call hol_allocation(4,1,4,4,G0H4,1)
  call hol_allocation(4,5,4,4,G1H4,12)
  call hol_allocation(4,15,4,4,G2H4,2)
  call hol_allocation(4,1,4,8,G0H8,2)
  call hol_allocation(4,5,4,8,G1H8,5)
  call hol_allocation(4,15,4,8,G2H8,2)
  call hol_allocation(4,1,4,16,G0H16,1)
  call hol_allocation(4,5,4,16,G1H16,1)
  call hol_allocation(4,1,4,32,G0H32,2)
  call hol_allocation(4,5,4,32,G1H32,4)
  call hol_allocation(4,1,4,64,G0H64,1)


end subroutine HOL_memory_allocation


!**********************************************************************
subroutine HOL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_deallocation
  implicit none
  integer,   intent(in)    :: dmode

    call hol_deallocation(G1H1,1,dmode)
  call hol_deallocation(G1H2,3,dmode)
  call hol_deallocation(G2H2,9,dmode)
  call hol_deallocation(G0H4,1,dmode)
  call hol_deallocation(G1H4,12,dmode)
  call hol_deallocation(G2H4,2,dmode)
  call hol_deallocation(G0H8,2,dmode)
  call hol_deallocation(G1H8,5,dmode)
  call hol_deallocation(G2H8,2,dmode)
  call hol_deallocation(G0H16,1,dmode)
  call hol_deallocation(G1H16,1,dmode)
  call hol_deallocation(G0H32,2,dmode)
  call hol_deallocation(G1H32,4,dmode)
  call hol_deallocation(G0H64,1,dmode)


end subroutine HOL_memory_deallocation_/**/REALKIND

!**********************************************************************
subroutine HCL_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

  call hcl_allocation(1,G0tensor, 107)
call hcl_allocation(5,G1tensor, 55)
call hcl_allocation(15,G2tensor, 18)


end subroutine HCL_memory_allocation


!**********************************************************************
subroutine HCL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! deallocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_deallocation
  implicit none
  integer,   intent(in)    :: dmode

  call hcl_deallocation(G0tensor, 107,dmode)
call hcl_deallocation(G1tensor, 55,dmode)
call hcl_deallocation(G2tensor, 18,dmode)

  call hcl_deallocation(T0sum,55,dmode)
call hcl_deallocation(T1sum,2,dmode)


end subroutine HCL_memory_deallocation_/**/REALKIND


!**********************************************************************
subroutine Tsum_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

  call hcl_allocation(1,T0sum,55)
call hcl_allocation(5,T1sum,2)


end subroutine Tsum_memory_allocation


#ifdef PRECISION_dp
subroutine max_point(r) &
    & bind(c,name="ol_f_max_point_pplnjj_ckm_neexuxccxb_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 5
end subroutine max_point

subroutine tensor_rank(r) &
    & bind(c,name="ol_f_tensor_rank_pplnjj_ckm_neexuxccxb_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 1
end subroutine tensor_rank
#endif

subroutine reset_tensor_sum()
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  use ol_parameters_init_/**/REALKIND, only: init_hcl
  implicit none
  integer :: i

  do i = 1,55
    call init_hcl(T0sum(i))
  end do
  do i = 1,2
    call init_hcl(T1sum(i))
  end do

end subroutine reset_tensor_sum


subroutine scale_one_tsum(tsum, spow)
  use ol_parameters_decl_/**/REALKIND, only: scalefactor
  implicit none
  complex(REALKIND), intent(inout) :: tsum(:)
  integer, intent(in) :: spow ! rank 0 scale power
  real(REALKIND) :: sfinv, sfac
  integer :: sz
  sfinv = 1/scalefactor
  sfac = scalefactor**spow
  sz = size(tsum)
  tsum(1) = sfac*tsum(1)
  if (sz > 1) then ! rank 1
    sfac = sfac*sfinv
    tsum(2:5) = sfac*tsum(2:5)
  end if
  if (sz > 5) then ! rank 2
    sfac = sfac*sfinv
    tsum(6:15) = sfac*tsum(6:15)
  end if
  if (sz > 15) then ! rank 3
    sfac = sfac*sfinv
    tsum(16:35) = sfac*tsum(16:35)
  end if
  if (sz > 35) then ! rank 4
    sfac = sfac*sfinv
    tsum(36:70) = sfac*tsum(36:70)
  end if
  if (sz > 70) then ! rank 5
    sfac = sfac*sfinv
    tsum(71:126) = sfac*tsum(71:126)
  end if
  if (sz > 126) then ! rank 6
    sfac = sfac*sfinv
    tsum(127:210) = sfac*tsum(127:210)
  end if
  if (sz > 210) then ! rank 7
    sfac = sfac*sfinv
    tsum(211:330) = sfac*tsum(211:330)
  end if
end subroutine scale_one_tsum


subroutine scale_tensor_sum()
  implicit none
  call scale_one_tsum(T1sum(1)%cmp, 2)
  call scale_one_tsum(T1sum(2)%cmp, 2)
  call scale_one_tsum(T0sum(1)%cmp, 0)
  call scale_one_tsum(T0sum(2)%cmp, 0)
  call scale_one_tsum(T0sum(3)%cmp, 0)
  call scale_one_tsum(T0sum(4)%cmp, 0)
  call scale_one_tsum(T0sum(5)%cmp, 0)
  call scale_one_tsum(T0sum(6)%cmp, 0)
  call scale_one_tsum(T0sum(7)%cmp, 0)
  call scale_one_tsum(T0sum(8)%cmp, 0)
  call scale_one_tsum(T0sum(9)%cmp, 0)
  call scale_one_tsum(T0sum(10)%cmp, 0)
  call scale_one_tsum(T0sum(11)%cmp, 0)
  call scale_one_tsum(T0sum(12)%cmp, -2)
  call scale_one_tsum(T0sum(13)%cmp, -2)
  call scale_one_tsum(T0sum(14)%cmp, -2)
  call scale_one_tsum(T0sum(15)%cmp, -2)
  call scale_one_tsum(T0sum(16)%cmp, -2)
  call scale_one_tsum(T0sum(17)%cmp, -2)
  call scale_one_tsum(T0sum(18)%cmp, -2)
  call scale_one_tsum(T0sum(19)%cmp, -2)
  call scale_one_tsum(T0sum(20)%cmp, -2)
  call scale_one_tsum(T0sum(21)%cmp, -2)
  call scale_one_tsum(T0sum(22)%cmp, -2)
  call scale_one_tsum(T0sum(23)%cmp, -2)
  call scale_one_tsum(T0sum(24)%cmp, -2)
  call scale_one_tsum(T0sum(25)%cmp, -2)
  call scale_one_tsum(T0sum(26)%cmp, -2)
  call scale_one_tsum(T0sum(27)%cmp, -2)
  call scale_one_tsum(T0sum(28)%cmp, -2)
  call scale_one_tsum(T0sum(29)%cmp, -2)
  call scale_one_tsum(T0sum(30)%cmp, -2)
  call scale_one_tsum(T0sum(31)%cmp, -2)
  call scale_one_tsum(T0sum(32)%cmp, -2)
  call scale_one_tsum(T0sum(33)%cmp, -2)
  call scale_one_tsum(T0sum(34)%cmp, -2)
  call scale_one_tsum(T0sum(35)%cmp, -4)
  call scale_one_tsum(T0sum(36)%cmp, -4)
  call scale_one_tsum(T0sum(37)%cmp, -4)
  call scale_one_tsum(T0sum(38)%cmp, -4)
  call scale_one_tsum(T0sum(39)%cmp, -4)
  call scale_one_tsum(T0sum(40)%cmp, -4)
  call scale_one_tsum(T0sum(41)%cmp, -4)
  call scale_one_tsum(T0sum(42)%cmp, -4)
  call scale_one_tsum(T0sum(43)%cmp, -4)
  call scale_one_tsum(T0sum(44)%cmp, -4)
  call scale_one_tsum(T0sum(45)%cmp, -4)
  call scale_one_tsum(T0sum(46)%cmp, -4)
  call scale_one_tsum(T0sum(47)%cmp, -4)
  call scale_one_tsum(T0sum(48)%cmp, -4)
  call scale_one_tsum(T0sum(49)%cmp, -4)
  call scale_one_tsum(T0sum(50)%cmp, -4)
  call scale_one_tsum(T0sum(51)%cmp, -4)
  call scale_one_tsum(T0sum(52)%cmp, -4)
  call scale_one_tsum(T0sum(53)%cmp, -4)
  call scale_one_tsum(T0sum(54)%cmp, -4)
  call scale_one_tsum(T0sum(55)%cmp, -4)

end subroutine scale_tensor_sum

! **********************************************************************
subroutine set_integral_masses_and_momenta()
! **********************************************************************

  use ol_parameters_decl_/**/REALKIND
  momenta_1 = [ 0, 0 ]
  momenta_2 = [ 32, 31 ]
  momenta_3 = [ 35, 28 ]
  momenta_4 = [ 36, 27 ]
  momenta_5 = [ 39, 24 ]
  momenta_6 = [ 40, 23 ]
  momenta_7 = [ 43, 20 ]
  momenta_8 = [ 47, 16 ]
  momenta_9 = [ 48, 15 ]
  momenta_10 = [ 51, 12 ]
  momenta_11 = [ 55, 8 ]
  momenta_12 = [ 56, 7 ]
  momenta_13 = [ 59, 4 ]
  momenta_14 = [ 60, 3 ]
  momenta_15 = [ 32, 3, 28 ]
  momenta_16 = [ 32, 4, 27 ]
  momenta_17 = [ 32, 7, 24 ]
  momenta_18 = [ 32, 15, 16 ]
  momenta_19 = [ 32, 23, 8 ]
  momenta_20 = [ 32, 27, 4 ]
  momenta_21 = [ 35, 4, 24 ]
  momenta_22 = [ 35, 12, 16 ]
  momenta_23 = [ 35, 20, 8 ]
  momenta_24 = [ 35, 24, 4 ]
  momenta_25 = [ 36, 3, 24 ]
  momenta_26 = [ 39, 8, 16 ]
  momenta_27 = [ 39, 16, 8 ]
  momenta_28 = [ 40, 3, 20 ]
  momenta_29 = [ 40, 7, 16 ]
  momenta_30 = [ 43, 4, 16 ]
  momenta_31 = [ 48, 3, 12 ]
  momenta_32 = [ 48, 7, 8 ]
  momenta_33 = [ 51, 4, 8 ]
  momenta_34 = [ 56, 3, 4 ]
  momenta_35 = [ 56, 4, 3 ]
  momenta_36 = [ 32, 3, 4, 24 ]
  momenta_37 = [ 32, 3, 12, 16 ]
  momenta_38 = [ 32, 3, 20, 8 ]
  momenta_39 = [ 32, 3, 24, 4 ]
  momenta_40 = [ 32, 4, 3, 24 ]
  momenta_41 = [ 32, 7, 8, 16 ]
  momenta_42 = [ 32, 7, 16, 8 ]
  momenta_43 = [ 35, 4, 8, 16 ]
  momenta_44 = [ 35, 4, 16, 8 ]
  momenta_45 = [ 40, 3, 4, 16 ]
  momenta_46 = [ 48, 3, 4, 8 ]
  momenta_47 = [ 32, 3, 4, 8, 16 ]
  momenta_48 = [ 32, 3, 4, 16, 8 ]

  masses2_1 = [ 0, 0 ]
  masses2_2 = [ nMB, 0 ]
  masses2_3 = [ nMT, 0 ]
  masses2_4 = [ 0, nMB ]
  masses2_5 = [ nMB, nMB ]
  masses2_6 = [ nMT, nMT ]
  masses2_7 = [ 0, 0, 0 ]
  masses2_8 = [ nMB, 0, 0 ]
  masses2_9 = [ nMB, 0, nMB ]
  masses2_10 = [ 0, nMB, 0 ]
  masses2_11 = [ 0, 0, 0, 0 ]
  masses2_12 = [ nMB, 0, 0, 0 ]
  masses2_13 = [ nMB, 0, 0, nMB ]
  masses2_14 = [ 0, nMB, 0, 0 ]
  masses2_15 = [ 0, nMB, 0, 0, 0 ]


end subroutine  set_integral_masses_and_momenta

! **********************************************************************
subroutine integrate_tensor_sum(M2out)
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! only: ZERO, masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: a_switch
#endif
  use ol_parameters_init_/**/REALKIND, only: init_met, add_met, met_to_real
  use ol_loop_routines_/**/REALKIND, only: TI_call_OL
  implicit none
  real(REALKIND), intent(out) :: M2out
  type(met) :: M2
  call init_met(M2)

sbarray_1 = [1, 2, 3, 4, 5]
sbarray_2 = [6, 7, 8, 4, 9]


#ifdef LOOPSQUARED
  if (a_switch == 1 .or. a_switch == 7) then
#endif
  call TI_call_OL(0,0, momenta_36, masses2_14, T0sum(1), M2,[4], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_46, masses2_14, T0sum(2), M2,[5], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_43, masses2_11, T0sum(3), M2,[1], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_41, masses2_14, T0sum(4), M2,[2], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_37, masses2_14, T0sum(5), M2,[3], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_45, masses2_14, T0sum(6), M2,[9], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_44, masses2_11, T0sum(7), M2,[6], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_42, masses2_14, T0sum(8), M2,[7], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_38, masses2_14, T0sum(9), M2,[8], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_39, masses2_14, T0sum(10), M2)
  call TI_call_OL(0,0, momenta_40, masses2_13, T0sum(11), M2)
  call TI_call_OL(0,0, momenta_15, masses2_10, T0sum(12), M2)
  call TI_call_OL(0,0, momenta_35, masses2_8, T0sum(13), M2)
  call TI_call_OL(0,0, momenta_16, masses2_8, T0sum(14), M2)
  call TI_call_OL(0,0, momenta_34, masses2_10, T0sum(15), M2)
  call TI_call_OL(0,0, momenta_21, masses2_7, T0sum(16), M2)
  call TI_call_OL(0,0, momenta_17, masses2_10, T0sum(17), M2)
  call TI_call_OL(0,0, momenta_33, masses2_7, T0sum(18), M2)
  call TI_call_OL(0,0, momenta_32, masses2_10, T0sum(19), M2)
  call TI_call_OL(0,0, momenta_31, masses2_10, T0sum(20), M2)
  call TI_call_OL(0,0, momenta_26, masses2_7, T0sum(21), M2)
  call TI_call_OL(0,0, momenta_22, masses2_7, T0sum(22), M2)
  call TI_call_OL(0,0, momenta_18, masses2_10, T0sum(23), M2)
  call TI_call_OL(0,0, momenta_30, masses2_7, T0sum(24), M2)
  call TI_call_OL(0,0, momenta_29, masses2_10, T0sum(25), M2)
  call TI_call_OL(0,0, momenta_28, masses2_10, T0sum(26), M2)
  call TI_call_OL(0,0, momenta_27, masses2_7, T0sum(27), M2)
  call TI_call_OL(0,0, momenta_23, masses2_7, T0sum(28), M2)
  call TI_call_OL(0,0, momenta_19, masses2_10, T0sum(29), M2)
  call TI_call_OL(0,0, momenta_25, masses2_10, T0sum(30), M2)
  call TI_call_OL(0,0, momenta_24, masses2_7, T0sum(31), M2)
  call TI_call_OL(0,0, momenta_20, masses2_10, T0sum(32), M2)
  call TI_call_OL(0,0, momenta_25, masses2_9, T0sum(33), M2)
  call TI_call_OL(0,0, momenta_17, masses2_9, T0sum(34), M2)
  call TI_call_OL(0,0, momenta_14, masses2_4, T0sum(35), M2)
  call TI_call_OL(0,0, momenta_3, masses2_1, T0sum(36), M2)
  call TI_call_OL(0,0, momenta_2, masses2_4, T0sum(37), M2)
  call TI_call_OL(0,0, momenta_1, masses2_2, T0sum(38), M2)
  call TI_call_OL(0,0, momenta_13, masses2_1, T0sum(39), M2)
  call TI_call_OL(0,0, momenta_14, masses2_2, T0sum(40), M2)
  call TI_call_OL(0,0, momenta_12, masses2_2, T0sum(41), M2)
  call TI_call_OL(0,0, momenta_4, masses2_2, T0sum(42), M2)
  call TI_call_OL(0,0, momenta_2, masses2_2, T0sum(43), M2)
  call TI_call_OL(0,0, momenta_12, masses2_4, T0sum(44), M2)
  call TI_call_OL(0,0, momenta_5, masses2_1, T0sum(45), M2)
  call TI_call_OL(0,0, momenta_11, masses2_1, T0sum(46), M2)
  call TI_call_OL(0,0, momenta_8, masses2_1, T0sum(47), M2)
  call TI_call_OL(0,0, momenta_4, masses2_4, T0sum(48), M2)
  call TI_call_OL(0,0, momenta_5, masses2_5, T0sum(49), M2)
  call TI_call_OL(0,0, momenta_10, masses2_1, T0sum(50), M2)
  call TI_call_OL(0,0, momenta_9, masses2_4, T0sum(51), M2)
  call TI_call_OL(0,0, momenta_7, masses2_1, T0sum(52), M2)
  call TI_call_OL(0,0, momenta_6, masses2_4, T0sum(53), M2)
  call TI_call_OL(0,0, momenta_5, masses2_6, T0sum(54), M2)
  call TI_call_OL(0,0, momenta_1, masses2_3, T0sum(55), M2)

  call TI_call_OL(0,1, momenta_47, masses2_15, T1sum(1), M2,sbarray_1, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_48, masses2_15, T1sum(2), M2,sbarray_2, ScalarBoxes(:))

  call add_met(M2,M2L1R1)

#ifdef LOOPSQUARED
  end if
#endif

  call met_to_real(M2out,M2)

#ifdef PRECISION_dp
  call HOL_memory_deallocation_/**/REALKIND(1)
  call HCL_memory_deallocation_/**/REALKIND(1)
#endif

end subroutine integrate_tensor_sum

end module ol_tensor_sum_storage_pplnjj_ckm_neexuxccxb_1_/**/REALKIND
