
module ol_colourmatrix_pplnaj_nexeudxag_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(23,1), K2(1,1), KL(1,1)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [  12]
  K1( 2,:) = [   0]
  K1( 3,:) = [   0]
  K1( 4,:) = [   0]
  K1( 5,:) = [   0]
  K1( 6,:) = [   0]
  K1( 7,:) = [  16]
  K1( 8,:) = [   0]
  K1( 9,:) = [   0]
  K1(10,:) = [   2]
  K1(11,:) = [  16]
  K1(12,:) = [   0]
  K1(13,:) = [   0]
  K1(14,:) = [   0]
  K1(15,:) = [   0]
  K1(16,:) = [   0]
  K1(17,:) = [   0]
  K1(18,:) = [   0]
  K1(19,:) = [ -18]
  K1(20,:) = [ -18]
  K1(21,:) = [   0]
  K1(22,:) = [  36]
  K1(23,:) = [   0]
  K1 = (1._/**/REALKIND / 3) * K1

  K2(1,:) = [ 4]

  KL(1,:) = [ 4]

  end subroutine colourmatrix_init
end module ol_colourmatrix_pplnaj_nexeudxag_1_/**/REALKIND



module ol_forced_parameters_pplnaj_nexeudxag_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pplnaj_nexeudxag_1_/**/REALKIND
! **********************************************************************
module ol_loop_storage_pplnaj_nexeudxag_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2  
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  
#ifdef PRECISION_dp
  integer(intkind1), save :: ntry = 1, ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types 
  ! the following are flags for memory allocation of the hol coefficients in dp or qp 
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer(intkind2), parameter :: nheltot = 64 ! number of helicity configurations
  integer(intkind2), save :: nhel = 64 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(64) ! physical helicity states
#endif

  complex(REALKIND), save :: den(91)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,28), wf8(8,44), wf16(16,30), wf64(64,52)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(21), c(12)

  !below the colour vector for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(1,64)

end module ol_loop_storage_pplnaj_nexeudxag_1_/**/REALKIND






! **********************************************************************
module ol_loop_pplnaj_nexeudxag_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2  
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_pplnaj_nexeudxag_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (CI*eQED**3*gQCD)/(6._/**/REALKIND*sw**2)
    f( 2) = (CI*eQED**3*gQCD)/(3._/**/REALKIND*sw**2)
    f( 3) = (CI*eQED**3*gQCD)/(2._/**/REALKIND*sw**2)
    f( 4) = (CI*countertermnorm*eQED**3*gQCD**3)/(6._/**/REALKIND*sw**2)
    f( 5) = (CI*countertermnorm*eQED**3*gQCD**3)/(3._/**/REALKIND*sw**2)
    f( 6) = (CI*countertermnorm*eQED**3*gQCD**3)/(2._/**/REALKIND*sw**2)
    f( 7) = (CI*countertermnorm*ctGqq*eQED**3*gQCD**3)/(6._/**/REALKIND*sw**2)
    f( 8) = (CI*countertermnorm*ctGqq*eQED**3*gQCD**3)/(3._/**/REALKIND*sw**2)
    f( 9) = (CI*countertermnorm*ctGqq*eQED**3*gQCD**3)/(2._/**/REALKIND*sw**2)
    f(10) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**3)/(6._/**/REALKIND*sw**2)
    f(11) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**3)/(3._/**/REALKIND*sw**2)
    f(12) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**3)/(2._/**/REALKIND*sw**2)
    f(13) = (CI*eQED**3*gQCD**3*integralnorm*SwB)/(6._/**/REALKIND*sw**2)
    f(14) = (CI*eQED**3*gQCD**3*integralnorm*SwB)/(3._/**/REALKIND*sw**2)
    f(15) = (CI*eQED**3*gQCD**3*integralnorm*SwB)/(2._/**/REALKIND*sw**2)
    f(16) = (eQED**3*gQCD**3*integralnorm*SwB)/(sw**2*6._/**/REALKIND)
    f(17) = (eQED**3*gQCD**3*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f(18) = (eQED**3*gQCD**3*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(19) = (eQED**3*gQCD**3*integralnorm*SwF)/(sw**2*6._/**/REALKIND)
    f(20) = (eQED**3*gQCD**3*integralnorm*SwF)/(sw**2*3._/**/REALKIND)
    f(21) = (2*eQED**3*gQCD**3*integralnorm*SwF)/(sw**2*3._/**/REALKIND)

  c = [ 9*CI*f(13), 9*CI*f(14), 9*CI*f(15), f(16), 8*f(16), f(17), 8*f(17), f(18), 8*f(18), 3*f(19), 3*f(20), 3*f(21) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3) - MW2)+L(6,3))
  den(2) = 1 /((L(5,20))+L(6,20))
  den(3) = 1 /((L(5,40))+L(6,40))
  den(6) = 1 /((L(5,11))+L(6,11))
  den(9) = 1 /((L(5,36))+L(6,36))
  den(10) = 1 /((L(5,24))+L(6,24))
  den(13) = 1 /((L(5,7))+L(6,7))
  den(17) = 1 /((L(5,44) - MW2)+L(6,44))
  den(23) = 1 /((L(5,18))+L(6,18))
  den(24) = 1 /((L(5,19) - MW2)+L(6,19))
  den(28) = 1 /((L(5,52))+L(6,52))
  den(35) = 1 /((L(5,56))+L(6,56))
  den(42) = 1 /((L(5,43))+L(6,43))
  den(45) = 1 /((L(5,23))+L(6,23))
  den(52) = 1 /((L(5,27))+L(6,27))
  den(55) = 1 /((L(5,39))+L(6,39))
  den(71) = 1 /((L(5,15))+L(6,15))

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(7) = den(1)*den(6)
  den(8) = den(2)*den(7)
  den(11) = den(1)*den(9)
  den(12) = den(10)*den(11)
  den(14) = den(1)*den(13)
  den(15) = den(10)*den(14)
  den(16) = den(7)*den(9)
  den(18) = den(9)*den(17)
  den(19) = den(1)*den(18)
  den(20) = den(3)*den(14)
  den(21) = den(3)*den(17)
  den(22) = den(1)*den(21)
  den(25) = den(23)*den(24)
  den(26) = den(9)*den(25)
  den(27) = den(3)*den(25)
  den(29) = den(2)*den(28)
  den(30) = den(1)*den(29)
  den(31) = den(1)*den(24)
  den(32) = den(9)*den(31)
  den(33) = den(9)*den(28)
  den(34) = den(1)*den(33)
  den(36) = den(10)*den(35)
  den(37) = den(1)*den(36)
  den(38) = den(3)*den(31)
  den(39) = den(3)*den(35)
  den(40) = den(1)*den(39)
  den(41) = den(1)*den(3)
  den(43) = den(41)*den(42)
  den(44) = den(2)*den(43)
  den(46) = den(4)*den(45)
  den(47) = den(3)*den(46)
  den(48) = den(2)**2
  den(49) = den(7)*den(48)
  den(50) = den(7)*den(29)
  den(51) = den(1)*den(10)
  den(53) = den(51)*den(52)
  den(54) = den(9)*den(53)
  den(56) = den(11)*den(55)
  den(57) = den(10)*den(56)
  den(58) = den(14)*den(36)
  den(59) = den(10)**2
  den(60) = den(14)*den(59)
  den(61) = den(9)**2
  den(62) = den(31)*den(61)
  den(63) = den(7)*den(61)
  den(64) = den(7)*den(33)
  den(65) = den(3)**2
  den(66) = den(31)*den(65)
  den(67) = den(14)*den(39)
  den(68) = den(14)*den(65)
  den(69) = den(25)*den(61)
  den(70) = den(25)*den(65)
  den(72) = den(14)*den(71)
  den(73) = den(14)*den(45)
  den(74) = den(14)*den(55)
  den(75) = den(7)*den(71)
  den(76) = den(7)*den(52)
  den(77) = den(7)*den(42)
  den(78) = den(31)*den(45)
  den(79) = den(31)*den(52)
  den(80) = den(25)*den(45)
  den(81) = den(25)*den(52)
  den(82) = den(1)*den(2)*den(3)
  den(83) = den(1)*den(9)*den(10)
  den(84) = den(2)*den(77)
  den(85) = den(10)*den(74)
  den(86) = den(9)*den(76)
  den(87) = den(9)*den(79)
  den(88) = den(3)*den(73)
  den(89) = den(3)*den(78)
  den(90) = den(9)*den(81)
  den(91) = den(3)*den(80)

end subroutine denominators

!
!
!
!
!
! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_pplnaj_nexeudxag_1_/**/DREALKIND, only: ntry, nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for anti-nu_e e- up anti-down gamma glue -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_pplnaj_nexeudxag_1, only: external_perm_pplnaj_nexeudxag_1, &
    & external_perm_inv_pplnaj_nexeudxag_1, extcomb_perm_pplnaj_nexeudxag_1, &
    & average_factor_pplnaj_nexeudxag_1
  use ol_external_pplnaj_nexeudxag_1, only: H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_pplnaj_nexeudxag_1_/**/REALKIND, only: colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_pplnaj_nexeudxag_1_/**/REALKIND, only: check_forced_parameters
  use ol_heltables_OLR_pplnaj_nexeudxag_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: IR_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(22)
  logical, intent(in) :: qp_kinematics

  integer           :: shift, k, r, m, n
  real(REALKIND)    :: P(0:3,6)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,6)
#endif
  integer           :: extmasses2(6)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(22)
  complex(REALKIND) :: M1(1), M2(1) 
  real(REALKIND)    :: P_scatt_intern(0:3,6)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(1,64)
  type(Hpolcont) :: M1helarray_ct(1,64)

  type(Hpolcont) :: A(64,52)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(52)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call set_parameter("ew_renorm", 0)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, 0, 0, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, external_perm_inv_pplnaj_nexeudxag_1, 6, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_A(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_Q(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_Q(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rZERO, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rZERO, H5, ex5, POLSEL(5),5)
  call pol_wf_V(P(:,6), rZERO, H6, ex6, POLSEL(6),6)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_W(ntry, ex2(:), ex1(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_VQ_A(ntry, ex5(:), ex3(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_AV_Q(ntry, ex4(:), ex6(:), wf4(:,3), n3(:,3), t3x4(:,:,3))
  call prop_W_W(ntry, wf4(:,1), 3, MW, 1_intkind1, wf4(:,4), n2(1))
  call prop_Q_A(ntry, wf4(:,2), 20, ZERO, 0_intkind1, wf4(:,5), n2(2))
  call prop_A_Q(ntry, wf4(:,3), 40, ZERO, 0_intkind1, wf4(:,6), n2(3))
  call vert_WQ_A(ntry, wf4(:,4), wf4(:,5), wf16(:,1), n3(:,4), t3x16(:,:,1))
  call vert_AW_Q(ntry, ex4(:), wf4(:,4), wf8(:,1), n3(:,5), t3x8(:,:,1))
  call vert_VQ_A(ntry, ex6(:), wf4(:,5), wf8(:,2), n3(:,6), t3x8(:,:,2))
  call prop_A_Q(ntry, wf8(:,1), 11, ZERO, 0_intkind1, wf8(:,3), n2(4))
  call vert_VQ_A(ntry, ex6(:), ex3(:), wf4(:,7), n3(:,7), t3x4(:,:,4))
  call vert_AV_Q(ntry, ex4(:), ex5(:), wf4(:,8), n3(:,8), t3x4(:,:,5))
  call prop_Q_A(ntry, wf4(:,7), 36, ZERO, 0_intkind1, wf4(:,9), n2(5))
  call prop_A_Q(ntry, wf4(:,8), 24, ZERO, 0_intkind1, wf4(:,10), n2(6))
  call vert_WQ_A(ntry, wf4(:,4), wf4(:,9), wf16(:,2), n3(:,9), t3x16(:,:,2))
  call vert_WQ_A(ntry, wf4(:,4), ex3(:), wf8(:,4), n3(:,10), t3x8(:,:,3))
  call vert_AV_Q(ntry, wf4(:,10), ex6(:), wf8(:,5), n3(:,11), t3x8(:,:,4))
  call prop_Q_A(ntry, wf8(:,4), 7, ZERO, 0_intkind1, wf8(:,6), n2(7))
  call vert_VQ_A(ntry, ex5(:), wf4(:,9), wf8(:,7), n3(:,12), t3x8(:,:,5))
  call vert_QA_W(ntry, wf4(:,9), ex4(:), wf8(:,8), n3(:,13), t3x8(:,:,6))
  call vert_UV_W(ntry, wf4(:,4), 3, ex5(:), 16, wf8(:,9), n3(:,14), t3x8(:,:,7))
  call prop_W_W(ntry, wf8(:,8), 44, MW, 1_intkind1, wf8(:,10), n2(8))
  call vert_AV_Q(ntry, wf4(:,6), ex5(:), wf8(:,11), n3(:,15), t3x8(:,:,8))
  call vert_QA_W(ntry, ex3(:), wf4(:,6), wf8(:,12), n3(:,16), t3x8(:,:,9))
  call prop_W_W(ntry, wf8(:,12), 44, MW, 1_intkind1, wf8(:,13), n2(9))
  call vert_VQ_A(ntry, ex5(:), ex2(:), wf4(:,11), n3(:,17), t3x4(:,:,6))
  call prop_Q_A(ntry, wf4(:,11), 18, ZERO, 0_intkind1, wf4(:,12), n2(10))
  call vert_QA_W(ntry, wf4(:,12), ex1(:), wf8(:,14), n3(:,18), t3x8(:,:,10))
  call prop_W_W(ntry, wf8(:,14), 19, MW, 1_intkind1, wf8(:,15), n2(11))
  call counter_WQ_A(ntry, wf4(:,4), wf4(:,5), wf16(:,3), n3(:,19), t3x16(:,:,3))
  call counter_VQ_A(ntry, ex6(:), wf4(:,5), wf8(:,16), n3(:,20), t3x8(:,:,11))
  call counter_WQ_A(ntry, wf4(:,4), wf4(:,9), wf16(:,4), n3(:,21), t3x16(:,:,4))
  call counter_AV_Q(ntry, wf4(:,10), ex6(:), wf8(:,17), n3(:,22), t3x8(:,:,12))
  call counter_VQ_A(ntry, ex5(:), wf4(:,9), wf8(:,18), n3(:,23), t3x8(:,:,13))
  call counter_AV_Q(ntry, wf4(:,6), ex5(:), wf8(:,19), n3(:,24), t3x8(:,:,14))
  call counter_AW_Q(ntry, ex4(:), wf4(:,4), wf8(:,20), n3(:,25), t3x8(:,:,15))
  call prop_Q_A(ntry, wf8(:,2), 52, ZERO, 0_intkind1, wf8(:,21), n2(12))
  call counter_AV_Q(ntry, ex4(:), ex6(:), wf4(:,13), n3(:,26), t3x4(:,:,7))
  call prop_A_Q(ntry, wf4(:,13), 40, ZERO, 0_intkind1, wf4(:,14), n2(13))
  call counter_QA_W(ntry, wf4(:,9), ex4(:), wf8(:,22), n3(:,27), t3x8(:,:,16))
  call prop_W_W(ntry, wf8(:,9), 19, MW, 1_intkind1, wf8(:,23), n2(14))
  call prop_Q_A(ntry, wf8(:,7), 52, ZERO, 0_intkind1, wf8(:,24), n2(15))
  call vert_AV_Q(ntry, wf4(:,14), ex5(:), wf8(:,25), n3(:,28), t3x8(:,:,17))
  call vert_QA_W(ntry, ex3(:), wf4(:,14), wf8(:,26), n3(:,29), t3x8(:,:,18))
  call prop_W_W(ntry, wf8(:,26), 44, MW, 1_intkind1, wf8(:,27), n2(16))
  call counter_AV_Q(ntry, ex4(:), ex5(:), wf4(:,15), n3(:,30), t3x4(:,:,8))
  call prop_A_Q(ntry, wf4(:,15), 24, ZERO, 0_intkind1, wf4(:,16), n2(17))
  call vert_AV_Q(ntry, wf4(:,16), ex6(:), wf8(:,28), n3(:,31), t3x8(:,:,19))
  call counter_WQ_A(ntry, wf4(:,4), ex3(:), wf8(:,29), n3(:,32), t3x8(:,:,20))
  call prop_A_Q(ntry, wf8(:,5), 56, ZERO, 0_intkind1, wf8(:,30), n2(18))
  call counter_VQ_A(ntry, ex6(:), ex3(:), wf4(:,17), n3(:,33), t3x4(:,:,9))
  call prop_Q_A(ntry, wf4(:,17), 36, ZERO, 0_intkind1, wf4(:,18), n2(19))
  call vert_WQ_A(ntry, wf4(:,4), wf4(:,18), wf16(:,5), n3(:,34), t3x16(:,:,5))
  call counter_QA_W(ntry, ex3(:), wf4(:,6), wf8(:,31), n3(:,35), t3x8(:,:,21))
  call prop_A_Q(ntry, wf8(:,11), 56, ZERO, 0_intkind1, wf8(:,32), n2(20))
  call vert_VQ_A(ntry, ex5(:), wf4(:,18), wf8(:,33), n3(:,36), t3x8(:,:,22))
  call vert_QA_W(ntry, wf4(:,18), ex4(:), wf8(:,34), n3(:,37), t3x8(:,:,23))
  call prop_W_W(ntry, wf8(:,34), 44, MW, 1_intkind1, wf8(:,35), n2(21))
  call counter_VQ_A(ntry, ex5(:), ex3(:), wf4(:,19), n3(:,38), t3x4(:,:,10))
  call prop_Q_A(ntry, wf4(:,19), 20, ZERO, 0_intkind1, wf4(:,20), n2(22))
  call vert_WQ_A(ntry, wf4(:,4), wf4(:,20), wf16(:,6), n3(:,39), t3x16(:,:,6))
  call vert_VQ_A(ntry, ex6(:), wf4(:,20), wf8(:,36), n3(:,40), t3x8(:,:,24))
  call vert_AW_Q(ntry, wf4(:,6), wf4(:,4), wf16(:,7), n3(:,41), t3x16(:,:,7))
  call counter_Q_A(ctqq,2,ntry, wf4(:,5), 20, wf4(:,21), n2(23))
  call prop_A_Q(ntry, wf16(:,7), 43, ZERO, 0_intkind1, wf16(:,8), n2(24))
  call counter_A_Q(ctqq,1,ntry, wf4(:,6), 40, wf4(:,22), n2(25))
  call prop_Q_A(ntry, wf16(:,1), 23, ZERO, 0_intkind1, wf16(:,9), n2(26))
  call prop_Q_A(ntry, wf4(:,21), 20, ZERO, 0_intkind1, wf4(:,23), n2(27))
  call vert_VQ_A(ntry, ex6(:), wf4(:,23), wf8(:,37), n3(:,42), t3x8(:,:,25))
  call counter_A_Q(ctqq,2,ntry, wf8(:,3), 11, wf8(:,38), n2(28))
  call vert_AW_Q(ntry, wf4(:,10), wf4(:,4), wf16(:,10), n3(:,43), t3x16(:,:,8))
  call counter_Q_A(ctqq,2,ntry, wf4(:,9), 36, wf4(:,24), n2(29))
  call prop_A_Q(ntry, wf16(:,10), 27, ZERO, 0_intkind1, wf16(:,11), n2(30))
  call counter_A_Q(ctqq,1,ntry, wf4(:,10), 24, wf4(:,25), n2(31))
  call prop_Q_A(ntry, wf16(:,2), 39, ZERO, 0_intkind1, wf16(:,12), n2(32))
  call counter_Q_A(ctqq,1,ntry, wf8(:,6), 7, wf8(:,39), n2(33))
  call prop_A_Q(ntry, wf4(:,25), 24, ZERO, 0_intkind1, wf4(:,26), n2(34))
  call vert_AV_Q(ntry, wf4(:,26), ex6(:), wf8(:,40), n3(:,44), t3x8(:,:,26))
  call prop_Q_A(ntry, wf4(:,24), 36, ZERO, 0_intkind1, wf4(:,27), n2(35))
  call vert_QA_W(ntry, wf4(:,27), ex4(:), wf8(:,41), n3(:,45), t3x8(:,:,27))
  call vert_VQ_A(ntry, ex5(:), wf4(:,27), wf8(:,42), n3(:,46), t3x8(:,:,28))
  call prop_A_Q(ntry, wf4(:,22), 40, ZERO, 0_intkind1, wf4(:,28), n2(36))
  call vert_QA_W(ntry, ex3(:), wf4(:,28), wf8(:,43), n3(:,47), t3x8(:,:,29))
  call vert_AV_Q(ntry, wf4(:,28), ex5(:), wf8(:,44), n3(:,48), t3x8(:,:,30))
  call vert_QA_V(ntry, wf8(:,6), ex4(:), wf16(:,13), n3(:,49), t3x16(:,:,9))
  call vert_VQ_A(ntry, ex5(:), wf8(:,6), wf16(:,14), n3(:,50), t3x16(:,:,10))
  call prop_Q_A(ntry, wf16(:,14), 23, ZERO, 0_intkind1, wf16(:,15), n2(37))
  call vert_VQ_A(ntry, ex6(:), wf8(:,6), wf16(:,16), n3(:,51), t3x16(:,:,11))
  call prop_Q_A(ntry, wf16(:,16), 39, ZERO, 0_intkind1, wf16(:,17), n2(38))
  call vert_QA_V(ntry, ex3(:), wf8(:,3), wf16(:,18), n3(:,52), t3x16(:,:,12))
  call vert_AV_Q(ntry, wf8(:,3), ex5(:), wf16(:,19), n3(:,53), t3x16(:,:,13))
  call prop_A_Q(ntry, wf16(:,19), 27, ZERO, 0_intkind1, wf16(:,20), n2(39))
  call vert_AV_Q(ntry, wf8(:,3), ex6(:), wf16(:,21), n3(:,54), t3x16(:,:,14))
  call prop_A_Q(ntry, wf16(:,21), 43, ZERO, 0_intkind1, wf16(:,22), n2(40))
  call vert_WQ_A(ntry, wf8(:,23), ex3(:), wf16(:,23), n3(:,55), t3x16(:,:,15))
  call prop_Q_A(ntry, wf16(:,23), 23, ZERO, 0_intkind1, wf16(:,24), n2(41))
  call vert_AW_Q(ntry, ex4(:), wf8(:,23), wf16(:,25), n3(:,56), t3x16(:,:,16))
  call prop_A_Q(ntry, wf16(:,25), 27, ZERO, 0_intkind1, wf16(:,26), n2(42))
  call vert_WQ_A(ntry, wf8(:,15), ex3(:), wf16(:,27), n3(:,57), t3x16(:,:,17))
  call prop_Q_A(ntry, wf16(:,27), 23, ZERO, 0_intkind1, wf16(:,28), n2(43))
  call vert_AW_Q(ntry, ex4(:), wf8(:,15), wf16(:,29), n3(:,58), t3x16(:,:,18))
  call prop_A_Q(ntry, wf16(:,29), 27, ZERO, 0_intkind1, wf16(:,30), n2(44))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_exwf(ex5)
  call init_hybrid_exwf(ex6)
  call init_hybrid_wf(wf4)
  call init_hybrid_wf(wf8)
  call init_hybrid_wf(wf16)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k))
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0
  
    do k = 1, nhel
      call colint(M1helarray(:,k)%j, M2add)
      call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct)
      if (IR_is_on > 0) then
	call colint_IR(M1helarray(:,k)%j, M2add_colint)
      end if
      !summation over helicity configurations
      M02 = M02 + M2add
      M2ct = M2ct + M2add_ct
      M2colint = M2colint + M2add_colint
    end do



  contains

subroutine physical_helicities()
  implicit none 

integer :: i1,i2,i3,i4,i5,i6
integer :: n

n=0

do i6= 1, 2
do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf
 end if
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_QA(nsync, wf4(:,6), wf16(:,1), A(:,1), n3(:,59), t3x64(:,:,1), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,3), A(:,2), n3(:,60), t3x64(:,:,2), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,10), wf16(:,2), A(:,3), n3(:,61), t3x64(:,:,3), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,5), wf8(:,6), A(:,4), n3(:,62), t3x64(:,:,4), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,7), A(:,5), n3(:,63), t3x64(:,:,5), nhel, den(16))
    call Hcont_VV(nsync, wf8(:,9), wf8(:,10), A(:,6), n3(:,64), t3x64(:,:,6), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,11), A(:,7), n3(:,65), t3x64(:,:,7), nhel, den(20))
    call Hcont_VV(nsync, wf8(:,9), wf8(:,13), A(:,8), n3(:,66), t3x64(:,:,8), nhel, den(22))
    call Hcont_VV(nsync, wf8(:,8), wf8(:,15), A(:,9), n3(:,67), t3x64(:,:,9), nhel, den(26))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,15), A(:,10), n3(:,68), t3x64(:,:,10), nhel, den(27))

    call Hcont_QA(nsync, wf4(:,6), wf16(:,3), A(:,11), n3(:,69), t3x64(:,:,11), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,16), A(:,12), n3(:,70), t3x64(:,:,12), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,10), wf16(:,4), A(:,13), n3(:,71), t3x64(:,:,13), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,17), A(:,14), n3(:,72), t3x64(:,:,14), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,18), A(:,15), n3(:,73), t3x64(:,:,15), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,19), A(:,16), n3(:,74), t3x64(:,:,16), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,21), A(:,17), n3(:,75), t3x64(:,:,17), nhel, den(30))
    call Hcont_QA(nsync, wf16(:,1), wf4(:,14), A(:,18), n3(:,76), t3x64(:,:,18), nhel, den(5))
    call Hcont_VV(nsync, wf8(:,22), wf8(:,23), A(:,19), n3(:,77), t3x64(:,:,19), nhel, den(32))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,24), A(:,20), n3(:,78), t3x64(:,:,20), nhel, den(34))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,25), A(:,21), n3(:,79), t3x64(:,:,21), nhel, den(20))
    call Hcont_VV(nsync, wf8(:,9), wf8(:,27), A(:,22), n3(:,80), t3x64(:,:,22), nhel, den(22))
    call Hcont_QA(nsync, wf16(:,2), wf4(:,16), A(:,23), n3(:,81), t3x64(:,:,23), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,28), A(:,24), n3(:,82), t3x64(:,:,24), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,30), A(:,25), n3(:,83), t3x64(:,:,25), nhel, den(37))
    call Hcont_QA(nsync, wf4(:,10), wf16(:,5), A(:,26), n3(:,84), t3x64(:,:,26), nhel, den(12))
    call Hcont_VV(nsync, wf8(:,23), wf8(:,31), A(:,27), n3(:,85), t3x64(:,:,27), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,32), A(:,28), n3(:,86), t3x64(:,:,28), nhel, den(40))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,33), A(:,29), n3(:,87), t3x64(:,:,29), nhel, den(16))
    call Hcont_VV(nsync, wf8(:,9), wf8(:,35), A(:,30), n3(:,88), t3x64(:,:,30), nhel, den(19))
    call Hcont_QA(nsync, wf4(:,6), wf16(:,6), A(:,31), n3(:,89), t3x64(:,:,31), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,36), A(:,32), n3(:,90), t3x64(:,:,32), nhel, den(8))
    call Hcont_VV(nsync, wf8(:,15), wf8(:,22), A(:,33), n3(:,91), t3x64(:,:,33), nhel, den(26))
    call Hcont_VV(nsync, wf8(:,15), wf8(:,26), A(:,34), n3(:,92), t3x64(:,:,34), nhel, den(27))
    call Hcont_VV(nsync, wf8(:,15), wf8(:,31), A(:,35), n3(:,93), t3x64(:,:,35), nhel, den(27))
    call Hcont_VV(nsync, wf8(:,15), wf8(:,34), A(:,36), n3(:,94), t3x64(:,:,36), nhel, den(26))
    call Hcont_QA(nsync, wf4(:,21), wf16(:,8), A(:,37), n3(:,95), t3x64(:,:,37), nhel, den(44))
    call Hcont_QA(nsync, wf4(:,22), wf16(:,9), A(:,38), n3(:,96), t3x64(:,:,38), nhel, den(47))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,37), A(:,39), n3(:,97), t3x64(:,:,39), nhel, den(49))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,38), A(:,40), n3(:,98), t3x64(:,:,40), nhel, den(50))
    call Hcont_QA(nsync, wf4(:,24), wf16(:,11), A(:,41), n3(:,99), t3x64(:,:,41), nhel, den(54))
    call Hcont_QA(nsync, wf4(:,25), wf16(:,12), A(:,42), n3(:,100), t3x64(:,:,42), nhel, den(57))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,39), A(:,43), n3(:,101), t3x64(:,:,43), nhel, den(58))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,40), A(:,44), n3(:,102), t3x64(:,:,44), nhel, den(60))
    call Hcont_VV(nsync, wf8(:,23), wf8(:,41), A(:,45), n3(:,103), t3x64(:,:,45), nhel, den(62))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,42), A(:,46), n3(:,104), t3x64(:,:,46), nhel, den(63))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,38), A(:,47), n3(:,105), t3x64(:,:,47), nhel, den(64))
    call Hcont_VV(nsync, wf8(:,23), wf8(:,43), A(:,48), n3(:,106), t3x64(:,:,48), nhel, den(66))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,39), A(:,49), n3(:,107), t3x64(:,:,49), nhel, den(67))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,44), A(:,50), n3(:,108), t3x64(:,:,50), nhel, den(68))
    call Hcont_VV(nsync, wf8(:,15), wf8(:,41), A(:,51), n3(:,109), t3x64(:,:,51), nhel, den(69))
    call Hcont_VV(nsync, wf8(:,15), wf8(:,43), A(:,52), n3(:,110), t3x64(:,:,52), nhel, den(70))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(1), M2(1) ! M1helarray(1,64)
  integer :: empty(0), i

  M1(1)%j = (A(j,3)%j+A(j,4)%j+A(j,7)%j)*f(1)+(-A(j,1)%j-A(j,2)%j-A(j,5)%j)*f(2)+(-A(j,6)%j-A(j,8)%j+A(j,9)%j+A(j,10)%j)*f(3)

  M2(1)%j = (-A(j,41)%j-A(j,42)%j-A(j,43)%j-A(j,44)%j-A(j,49)%j-A(j,50)%j)*f(4)+(A(j,37)%j+A(j,38)%j+A(j,39)%j+A(j,40)%j+A(j,46)%j &
       +A(j,47)%j)*f(5)+(A(j,45)%j+A(j,48)%j-A(j,51)%j-A(j,52)%j)*f(6)+(A(j,14)%j+A(j,21)%j+A(j,26)%j)*f(7)+(-A(j,12)%j-A(j,18)%j &
       -A(j,29)%j)*f(8)+(-A(j,22)%j-A(j,30)%j+A(j,34)%j+A(j,36)%j)*f(9)+(A(j,13)%j+A(j,16)%j+A(j,23)%j+A(j,24)%j+A(j,25)%j &
       +A(j,28)%j)*f(10)+(-A(j,11)%j-A(j,15)%j-A(j,17)%j-A(j,20)%j-A(j,31)%j-A(j,32)%j)*f(11)+(-A(j,19)%j-A(j,27)%j+A(j,33)%j &
       +A(j,35)%j)*f(12)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)  

  !M(i) corresponds to \Gamma_{i} in Fabio's thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pplnaj_nexeudxag_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 1
      do j = 1, 1
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pplnaj_nexeudxag_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M(1), Mct(1)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer ::  i, j

  M2colint_ct = 0

    do i = 1, 1
      do j = 1, 1
        M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i,j)*Mct(j))
      end do
    end do


end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_pplnaj_nexeudxag_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2IRadd(22)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 23-1
    colmatpos = 1*k
    do i = 1, 1
      do j = 1, 1
	M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do
  
end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pplnaj_nexeudxag_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabio's thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_pplnaj_nexeudxag_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(1)
  type(Hpolcont), intent(out)  :: M0_col(1)
  integer :: i, j


  do j = 1, 1 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 1 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i,j)
    end do    
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_pplnaj_nexeudxag_1_/**/REALKIND
