
module ol_vamp_1_ppllttj_nenexttxggg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllttj_nenexttxggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllttj_nenexttxggg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppllttj_nenexttxggg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppllttj_nenexttxggg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppllttj_nenexttxggg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppllttj_nenexttxggg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(128)
  type(Hpolcont), intent(in) :: M(11,128)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(12)*M(4,:)%j)+c(13)*M(10,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1),h0tab(:,1),[64,3,32,8,4,16],[nMT,nMT,nMT,0,nMT,nMT],6,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1),heltab2x128(:,:,1))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(1),n2h64(1))
  Gcoeff(:)%j = (-(c(12)*M(4,:)%j)+c(13)*M(10,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(2),h0tab(:,2),[64,3,16,4,8,32],[nMT,nMT,nMT,0,nMT,nMT],6,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,2),heltab2x128(:,:,2))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(2),n2h64(2))
  Gcoeff(:)%j = (-(c(12)*M(6,:)%j)+c(13)*M(11,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(3),h0tab(:,3),[64,3,32,16,4,8],[nMT,nMT,nMT,nMT,0,nMT],6,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,3),heltab2x128(:,:,3))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(3),n2h64(3))
  Gcoeff(:)%j = (-(c(12)*M(6,:)%j)+c(13)*M(11,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(4),h0tab(:,4),[64,8,4,16,3,32],[nMT,0,nMT,nMT,nMT,nMT],6,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,4),heltab2x128(:,:,4))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(4),n2h64(4))
  Gcoeff(:)%j = (-(c(12)*M(6,:)%j)+c(13)*M(11,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(5),h0tab(:,5),[64,3,8,4,16,32],[nMT,nMT,0,nMT,nMT,nMT],6,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,5),heltab2x128(:,:,5))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(5),n2h64(5))
  Gcoeff(:)%j = (-(c(12)*M(4,:)%j)+c(13)*M(10,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(6),h0tab(:,6),[64,16,4,8,3,32],[nMT,nMT,0,nMT,nMT,nMT],6,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,6),heltab2x128(:,:,6))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(6),n2h64(6))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)+c(13)*M(11,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(7),h0tab(:,7),[64,3,32,4,8,16],[nMT,nMT,nMT,0,nMT,nMT],6,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,7),heltab2x128(:,:,7))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(7),n2h64(7))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)+c(13)*M(11,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(8),h0tab(:,8),[64,3,16,8,4,32],[nMT,nMT,nMT,0,nMT,nMT],6,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,8),heltab2x128(:,:,8))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(8),n2h64(8))
  Gcoeff(:)%j = (-(c(12)*M(5,:)%j)+c(13)*M(10,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(9),h0tab(:,9),[64,3,16,32,4,8],[nMT,nMT,nMT,nMT,0,nMT],6,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,9),heltab2x128(:,:,9))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(9),n2h64(9))
  Gcoeff(:)%j = (-(c(12)*M(5,:)%j)+c(13)*M(10,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(10),h0tab(:,10),[64,8,4,32,3,16],[nMT,0,nMT,nMT,nMT,nMT],6,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,10),heltab2x128(:,:,10))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(10),n2h64(10))
  Gcoeff(:)%j = (-(c(12)*M(5,:)%j)+c(13)*M(10,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(11),h0tab(:,11),[64,3,8,4,32,16],[nMT,nMT,0,nMT,nMT,nMT],6,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,11),heltab2x128(:,:,11))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(11),n2h64(11))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)+c(13)*M(11,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(12),h0tab(:,12),[64,16,3,8,4,32],[nMT,nMT,nMT,0,nMT,nMT],6,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,12),heltab2x128(:,:,12))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(12),n2h64(12))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(13)*M(10,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(13),h0tab(:,13),[64,3,32,16,8,4],[nMT,nMT,nMT,nMT,0,nMT],6,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,13),heltab2x128(:,:,13))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(13),n2h64(13))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(13)*M(10,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(14),h0tab(:,14),[64,4,8,16,3,32],[nMT,0,nMT,nMT,nMT,nMT],6,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,14),heltab2x128(:,:,14))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(14),n2h64(14))
  Gcoeff(:)%j = (-(c(12)*M(3,:)%j)+c(13)*M(11,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(15),h0tab(:,15),[64,3,16,32,8,4],[nMT,nMT,nMT,nMT,0,nMT],6,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,15),heltab2x128(:,:,15))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(15),n2h64(15))
  Gcoeff(:)%j = (-(c(12)*M(3,:)%j)+c(13)*M(11,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(16),h0tab(:,16),[64,4,8,32,3,16],[nMT,0,nMT,nMT,nMT,nMT],6,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,16),heltab2x128(:,:,16))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(16),n2h64(16))
  Gcoeff(:)%j = (-(c(12)*M(3,:)%j)+c(13)*M(11,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(17),h0tab(:,17),[64,4,8,3,32,16],[nMT,0,nMT,nMT,nMT,nMT],6,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,17),heltab2x128(:,:,17))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(17),n2h64(17))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(13)*M(10,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(18),h0tab(:,18),[64,4,8,3,16,32],[nMT,0,nMT,nMT,nMT,nMT],6,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,18),heltab2x128(:,:,18))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(18),n2h64(18))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(13)*M(10,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(19),h0tab(:,19),[64,3,4,8,16,32],[nMT,nMT,0,nMT,nMT,nMT],6,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,19),heltab2x128(:,:,19))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(19),n2h64(19))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)+c(13)*M(11,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(20),h0tab(:,20),[64,16,8,4,3,32],[nMT,nMT,0,nMT,nMT,nMT],6,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,20),heltab2x128(:,:,20))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(20),n2h64(20))
  Gcoeff(:)%j = (-(c(12)*M(3,:)%j)+c(13)*M(11,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(21),h0tab(:,21),[64,3,4,8,32,16],[nMT,nMT,0,nMT,nMT,nMT],6,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,21),heltab2x128(:,:,21))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(21),n2h64(21))
  Gcoeff(:)%j = (-(c(12)*M(4,:)%j)+c(13)*M(10,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(22),h0tab(:,22),[64,16,3,4,8,32],[nMT,nMT,nMT,0,nMT,nMT],6,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,22),heltab2x128(:,:,22))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(22),n2h64(22))
  Gcoeff(:)%j = (-(c(12)*M(5,:)%j)+c(13)*M(10,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(23),h0tab(:,23),[64,8,4,3,32,16],[nMT,0,nMT,nMT,nMT,nMT],6,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,23),heltab2x128(:,:,23))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(23),n2h64(23))
  Gcoeff(:)%j = (-(c(12)*M(6,:)%j)+c(13)*M(11,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(24),h0tab(:,24),[64,8,4,3,16,32],[nMT,0,nMT,nMT,nMT,nMT],6,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,24),heltab2x128(:,:,24))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(24),n2h64(24))
  Gcoeff(:)%j = (c(4)*(M(9,:)%j-M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(25),h0tab(:,25),[64,3,32,4,16,8],[nMT,nMT,nMT,0,0,nMT],6,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,25),heltab2x128(:,:,25))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(25),n2h64(25))
  Gcoeff(:)%j = (c(4)*(-M(9,:)%j+M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(26),h0tab(:,26),[64,3,8,16,4,32],[nMT,nMT,0,0,nMT,nMT],6,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,26),heltab2x128(:,:,26))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(26),n2h64(26))
  Gcoeff(:)%j = (c(4)*(M(8,:)%j-M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(27),h0tab(:,27),[64,3,16,4,32,8],[nMT,nMT,nMT,0,0,nMT],6,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,27),heltab2x128(:,:,27))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(27),n2h64(27))
  Gcoeff(:)%j = (c(4)*(-M(8,:)%j+M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(28),h0tab(:,28),[64,3,8,32,4,16],[nMT,nMT,0,0,nMT,nMT],6,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,28),heltab2x128(:,:,28))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(28),n2h64(28))
  Gcoeff(:)%j = (c(13)*(-M(7,:)%j-M(9,:)%j+M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(29),h0tab(:,29),[64,8,3,32,4,16],[0,nMT,nMT,nMT,0,0],6,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(29),m3h2x64(:,29),heltab2x128(:,:,29))
  Gcoeff(:)%j = (c(13)*(-M(7,:)%j-M(8,:)%j+M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(30),h0tab(:,30),[64,8,3,16,4,32],[0,nMT,nMT,nMT,0,0],6,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(30),m3h2x64(:,30),heltab2x128(:,:,30))
  Gcoeff(:)%j = (c(4)*(-M(9,:)%j+M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(31),h0tab(:,31),[64,3,32,8,16,4],[nMT,nMT,nMT,0,0,nMT],6,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,31),heltab2x128(:,:,31))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(31),n2h64(29))
  Gcoeff(:)%j = (c(4)*(M(9,:)%j-M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(32),h0tab(:,32),[64,4,16,8,3,32],[nMT,0,0,nMT,nMT,nMT],6,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,32),heltab2x128(:,:,32))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(32),n2h64(30))
  Gcoeff(:)%j = (c(4)*(-M(7,:)%j+M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(33),h0tab(:,33),[64,4,16,3,32,8],[0,nMT,nMT,nMT,nMT,0],6,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(33),m3h2x64(:,33),heltab2x128(:,:,33))
  Gcoeff(:)%j = (c(13)*(-M(8,:)%j-M(9,:)%j+M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(34),h0tab(:,34),[64,3,8,32,16,4],[nMT,nMT,0,0,0,nMT],6,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,34),heltab2x128(:,:,34))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(34),n2h64(31))
  Gcoeff(:)%j = (c(13)*(-M(7,:)%j-M(8,:)%j+M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(35),h0tab(:,35),[64,4,16,3,8,32],[0,nMT,nMT,nMT,0,0],6,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(35),m3h2x64(:,35),heltab2x128(:,:,35))
  Gcoeff(:)%j = (c(4)*(-M(7,:)%j+M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(36),h0tab(:,36),[64,4,16,32,3,8],[0,nMT,nMT,nMT,nMT,0],6,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(36),m3h2x64(:,36),heltab2x128(:,:,36))
  Gcoeff(:)%j = (c(4)*(M(9,:)%j-M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(37),h0tab(:,37),[64,3,4,16,8,32],[nMT,nMT,0,0,nMT,nMT],6,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,37),heltab2x128(:,:,37))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(37),n2h64(32))
  Gcoeff(:)%j = (c(4)*(-M(9,:)%j+M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(38),h0tab(:,38),[64,8,16,4,3,32],[nMT,0,0,nMT,nMT,nMT],6,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,38),heltab2x128(:,:,38))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(38),n2h64(33))
  Gcoeff(:)%j = (c(13)*(-M(8,:)%j-M(9,:)%j+M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(39),h0tab(:,39),[64,3,4,16,32,8],[nMT,nMT,0,0,0,nMT],6,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,39),heltab2x128(:,:,39))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(39),n2h64(34))
  Gcoeff(:)%j = (c(13)*(-M(7,:)%j-M(9,:)%j+M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(40),h0tab(:,40),[64,8,32,3,4,16],[0,nMT,nMT,nMT,0,0],6,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(40),m3h2x64(:,40),heltab2x128(:,:,40))
  Gcoeff(:)%j = (-(c(6)*M(4,:)%j)+c(4)*(-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(41),h0tab(:,41),[64,16,4,3,8,32],[0,0,nMT,nMT,0,0],6,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(41),m3h2x64(:,41),heltab2x128(:,:,41))
  Gcoeff(:)%j = (c(6)*M(6,:)%j+c(4)*(M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(42),h0tab(:,42),[64,8,3,4,16,32],[0,nMT,nMT,0,0,0],6,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(42),m3h2x64(:,42),heltab2x128(:,:,42))
  Gcoeff(:)%j = (c(4)*(-M(8,:)%j+M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(43),h0tab(:,43),[64,3,16,8,32,4],[nMT,nMT,nMT,0,0,nMT],6,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,43),heltab2x128(:,:,43))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(43),n2h64(35))
  Gcoeff(:)%j = (c(4)*(-M(7,:)%j+M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(44),h0tab(:,44),[64,4,32,3,16,8],[0,nMT,nMT,nMT,nMT,0],6,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(44),m3h2x64(:,44),heltab2x128(:,:,44))
  Gcoeff(:)%j = (c(13)*(-M(8,:)%j-M(9,:)%j+M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(45),h0tab(:,45),[64,3,8,16,32,4],[nMT,nMT,0,0,0,nMT],6,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,45),heltab2x128(:,:,45))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(45),n2h64(36))
  Gcoeff(:)%j = (c(13)*(-M(7,:)%j-M(9,:)%j+M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(46),h0tab(:,46),[64,4,32,3,8,16],[0,nMT,nMT,nMT,0,0],6,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(46),m3h2x64(:,46),heltab2x128(:,:,46))
  Gcoeff(:)%j = (c(4)*(M(8,:)%j-M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(47),h0tab(:,47),[64,4,32,8,3,16],[nMT,0,0,nMT,nMT,nMT],6,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,47),heltab2x128(:,:,47))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(47),n2h64(37))
  Gcoeff(:)%j = (c(4)*(-M(7,:)%j+M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(48),h0tab(:,48),[64,4,32,16,3,8],[0,nMT,nMT,nMT,nMT,0],6,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(48),m3h2x64(:,48),heltab2x128(:,:,48))
  Gcoeff(:)%j = (c(4)*(M(8,:)%j-M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(49),h0tab(:,49),[64,3,4,32,8,16],[nMT,nMT,0,0,nMT,nMT],6,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,49),heltab2x128(:,:,49))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(49),n2h64(38))
  Gcoeff(:)%j = (c(13)*(-M(8,:)%j-M(9,:)%j+M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(50),h0tab(:,50),[64,3,4,32,16,8],[nMT,nMT,0,0,0,nMT],6,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,50),heltab2x128(:,:,50))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(50),n2h64(39))
  Gcoeff(:)%j = (c(13)*(-M(7,:)%j-M(8,:)%j+M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(51),h0tab(:,51),[64,8,16,3,4,32],[0,nMT,nMT,nMT,0,0],6,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(51),m3h2x64(:,51),heltab2x128(:,:,51))
  Gcoeff(:)%j = (c(6)*M(2,:)%j+c(4)*(M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(52),h0tab(:,52),[64,16,8,3,4,32],[0,0,nMT,nMT,0,0],6,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(52),m3h2x64(:,52),heltab2x128(:,:,52))
  Gcoeff(:)%j = (c(4)*(-M(8,:)%j+M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(53),h0tab(:,53),[64,8,32,4,3,16],[nMT,0,0,nMT,nMT,nMT],6,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,53),heltab2x128(:,:,53))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(53),n2h64(40))
  Gcoeff(:)%j = (c(6)*M(5,:)%j+c(4)*(M(7,:)%j+M(8,:)%j+M(9,:)%j-M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(54),h0tab(:,54),[64,8,3,4,32,16],[0,nMT,nMT,0,0,0],6,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(54),m3h2x64(:,54),heltab2x128(:,:,54))
  Gcoeff(:)%j = (c(13)*(-M(7,:)%j-M(9,:)%j+M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(55),h0tab(:,55),[64,4,3,32,8,16],[0,nMT,nMT,nMT,0,0],6,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(55),m3h2x64(:,55),heltab2x128(:,:,55))
  Gcoeff(:)%j = (c(13)*(-M(7,:)%j-M(8,:)%j+M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(56),h0tab(:,56),[64,4,3,16,8,32],[0,nMT,nMT,nMT,0,0],6,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(56),m3h2x64(:,56),heltab2x128(:,:,56))
  Gcoeff(:)%j = (c(4)*(-M(7,:)%j+M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(57),h0tab(:,57),[64,4,3,32,16,8],[0,nMT,nMT,nMT,nMT,0],6,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(57),m3h2x64(:,57),heltab2x128(:,:,57))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(4)*(-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(58),h0tab(:,58),[64,4,3,8,16,32],[0,nMT,nMT,0,0,0],6,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(58),m3h2x64(:,58),heltab2x128(:,:,58))
  Gcoeff(:)%j = (c(4)*(-M(7,:)%j+M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(59),h0tab(:,59),[64,4,3,16,32,8],[0,nMT,nMT,nMT,nMT,0],6,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(59),m3h2x64(:,59),heltab2x128(:,:,59))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)+c(4)*(-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(60),h0tab(:,60),[64,4,3,8,32,16],[0,nMT,nMT,0,0,0],6,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(60),m3h2x64(:,60),heltab2x128(:,:,60))
  call Hloop_QZ_A(ntryL,G1H64(1),wf4(:,2),G1H16(1),ngZu,m3h4x16(:,1),heltab2x64(:,:,1))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMT,G2H16(1),n2h16(1))
  call Hloop_AZ_Q(ntryL,G1H64(2),wf4(:,2),G1H16(1),ngZu,m3h4x16(:,2),heltab2x64(:,:,2))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMT,G2H16(2),n2h16(2))
  call Hloop_AZ_Q(ntryL,G1H64(3),wf4(:,2),G1H16(1),ngZu,m3h4x16(:,3),heltab2x64(:,:,3))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMT,G2H16(3),n2h16(3))
  call Hloop_QA_V(ntryL,G1H64(4),ex4(:),G1H32(1),m3h2x32(:,1),heltab2x64(:,:,4))
  call Hloop_QZ_A(ntryL,G1H64(5),wf4(:,2),G1H16(1),ngZu,m3h4x16(:,4),heltab2x64(:,:,5))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMT,G2H16(4),n2h16(4))
  call Hloop_AV_Q(ntryL,G1H64(6),ex5(:),G1H32(2),m3h2x32(:,2),heltab2x64(:,:,6))
  call Hloop_A_Q(ntryL,G1H32(2),80,nMT,G2H32(1),n2h32(1))
  call Hloop_AZ_Q(ntryL,G1H64(7),wf4(:,2),G1H16(1),ngZu,m3h4x16(:,5),heltab2x64(:,:,7))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMT,G2H16(5),n2h16(5))
  call Hloop_QZ_A(ntryL,G1H64(8),wf4(:,2),G1H16(1),ngZu,m3h4x16(:,6),heltab2x64(:,:,8))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMT,G2H16(6),n2h16(6))
  call Hloop_AZ_Q(ntryL,G1H64(9),wf4(:,2),G1H16(1),ngZu,m3h4x16(:,7),heltab2x64(:,:,9))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMT,G2H16(7),n2h16(7))
  call Hloop_QA_V(ntryL,G1H64(10),ex4(:),G1H32(2),m3h2x32(:,3),heltab2x64(:,:,10))
  call Hloop_QZ_A(ntryL,G1H64(11),wf4(:,2),G1H16(1),ngZu,m3h4x16(:,8),heltab2x64(:,:,11))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMT,G2H16(8),n2h16(8))
  call Hloop_QV_A(ntryL,G1H64(12),ex5(:),G1H32(3),m3h2x32(:,4),heltab2x64(:,:,12))
  call Hloop_Q_A(ntryL,G1H32(3),80,nMT,G2H32(2),n2h32(2))
  call Hloop_QZ_A(ntryL,G1H64(13),wf4(:,2),G1H16(1),ngZu,m3h4x16(:,9),heltab2x64(:,:,13))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMT,G2H16(9),n2h16(9))
  call Hloop_AQ_V(ntryL,G1H64(14),ex3(:),G1H32(3),m3h2x32(:,5),heltab2x64(:,:,14))
  call Hloop_QZ_A(ntryL,G1H64(15),wf4(:,2),G1H16(1),ngZu,m3h4x16(:,10),heltab2x64(:,:,15))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMT,G2H16(10),n2h16(10))
  call Hloop_AQ_V(ntryL,G1H64(16),ex3(:),G1H32(4),m3h2x32(:,6),heltab2x64(:,:,16))
  call Hloop_AQ_V(ntryL,G1H64(17),ex3(:),G1H32(5),m3h2x32(:,7),heltab2x64(:,:,17))
  call Hloop_AQ_V(ntryL,G1H64(18),ex3(:),G1H32(6),m3h2x32(:,8),heltab2x64(:,:,18))
  call Hloop_AZ_Q(ntryL,G1H64(19),wf4(:,2),G1H16(1),ngZu,m3h4x16(:,11),heltab2x64(:,:,19))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMT,G2H16(11),n2h16(11))
  call Hloop_QV_A(ntryL,G1H64(20),ex5(:),G1H32(7),m3h2x32(:,9),heltab2x64(:,:,20))
  call Hloop_Q_A(ntryL,G1H32(7),80,nMT,G2H32(3),n2h32(3))
  call Hloop_AZ_Q(ntryL,G1H64(21),wf4(:,2),G1H16(1),ngZu,m3h4x16(:,12),heltab2x64(:,:,21))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMT,G2H16(12),n2h16(12))
  call Hloop_AV_Q(ntryL,G1H64(22),ex5(:),G1H32(7),m3h2x32(:,10),heltab2x64(:,:,22))
  call Hloop_A_Q(ntryL,G1H32(7),80,nMT,G2H32(4),n2h32(4))
  call Hloop_QA_V(ntryL,G1H64(23),ex4(:),G1H32(7),m3h2x32(:,11),heltab2x64(:,:,23))
  call Hloop_QA_V(ntryL,G1H64(24),ex4(:),G1H32(8),m3h2x32(:,12),heltab2x64(:,:,24))
  call Hloop_AZ_Q(ntryL,G1H64(25),wf4(:,2),G1H16(1),ngZu,m3h4x16(:,13),heltab2x64(:,:,25))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMT,G2H16(13),n2h16(13))
  call Hloop_QZ_A(ntryL,G1H64(26),wf4(:,2),G1H16(1),ngZu,m3h4x16(:,14),heltab2x64(:,:,26))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMT,G2H16(14),n2h16(14))
  call Hloop_AZ_Q(ntryL,G1H64(27),wf4(:,2),G1H16(1),ngZu,m3h4x16(:,15),heltab2x64(:,:,27))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMT,G2H16(15),n2h16(15))
  call Hloop_QZ_A(ntryL,G1H64(28),wf4(:,2),G1H16(1),ngZu,m3h4x16(:,16),heltab2x64(:,:,28))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMT,G2H16(16),n2h16(16))
  call Hloop_VA_Q(ntryL,G1H64(29),ex4(:),G1H32(9),m3h2x32(:,13),heltab2x64(:,:,29))
  call Hloop_A_Q(ntryL,G1H32(9),72,nMT,G2H32(5),n2h32(5))
  call Hloop_VA_Q(ntryL,G1H64(30),ex4(:),G1H32(9),m3h2x32(:,14),heltab2x64(:,:,30))
  call Hloop_A_Q(ntryL,G1H32(9),72,nMT,G2H32(6),n2h32(6))
  call Hloop_QZ_A(ntryL,G1H64(31),wf4(:,2),G1H16(1),ngZu,m3h4x16(:,17),heltab2x64(:,:,31))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMT,G2H16(17),n2h16(17))
  call Hloop_AQ_V(ntryL,G1H64(32),ex3(:),G1H32(9),m3h2x32(:,15),heltab2x64(:,:,32))
  call Hloop_VQ_A(ntryL,G1H64(33),ex3(:),G1H32(10),m3h2x32(:,16),heltab2x64(:,:,33))
  call Hloop_Q_A(ntryL,G1H32(10),68,nMT,G2H32(7),n2h32(7))
  call Hloop_QZ_A(ntryL,G1H64(34),wf4(:,2),G1H16(1),ngZu,m3h4x16(:,18),heltab2x64(:,:,34))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMT,G2H16(18),n2h16(18))
  call Hloop_VQ_A(ntryL,G1H64(35),ex3(:),G1H32(10),m3h2x32(:,17),heltab2x64(:,:,35))
  call Hloop_Q_A(ntryL,G1H32(10),68,nMT,G2H32(8),n2h32(8))
  call Hloop_VQ_A(ntryL,G1H64(36),ex3(:),G1H32(10),m3h2x32(:,18),heltab2x64(:,:,36))
  call Hloop_Q_A(ntryL,G1H32(10),68,nMT,G2H32(9),n2h32(9))
  call Hloop_AZ_Q(ntryL,G1H64(37),wf4(:,2),G1H16(1),ngZu,m3h4x16(:,19),heltab2x64(:,:,37))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMT,G2H16(19),n2h16(19))
  call Hloop_QA_V(ntryL,G1H64(38),ex4(:),G1H32(10),m3h2x32(:,19),heltab2x64(:,:,38))
  call Hloop_AZ_Q(ntryL,G1H64(39),wf4(:,2),G1H16(1),ngZu,m3h4x16(:,20),heltab2x64(:,:,39))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMT,G2H16(20),n2h16(20))
  call Hloop_VA_Q(ntryL,G1H64(40),ex4(:),G1H32(11),m3h2x32(:,20),heltab2x64(:,:,40))
  call Hloop_A_Q(ntryL,G1H32(11),72,nMT,G2H32(10),n2h32(10))
  call Hloop_UV_W(ntryL,G1H64(41),64,ex5(:),16,G2H32(11),m3h2x32(:,21),heltab2x64(:,:,41))
  call Hloop_VA_Q(ntryL,G1H64(42),ex4(:),G1H32(11),m3h2x32(:,22),heltab2x64(:,:,42))
  call Hloop_A_Q(ntryL,G1H32(11),72,nMT,G2H32(12),n2h32(11))
  call Hloop_QZ_A(ntryL,G1H64(43),wf4(:,2),G1H16(1),ngZu,m3h4x16(:,21),heltab2x64(:,:,43))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMT,G2H16(21),n2h16(21))
  call Hloop_VQ_A(ntryL,G1H64(44),ex3(:),G1H32(11),m3h2x32(:,23),heltab2x64(:,:,44))
  call Hloop_Q_A(ntryL,G1H32(11),68,nMT,G2H32(13),n2h32(12))
  call Hloop_QZ_A(ntryL,G1H64(45),wf4(:,2),G1H16(1),ngZu,m3h4x16(:,22),heltab2x64(:,:,45))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMT,G2H16(22),n2h16(22))
  call Hloop_VQ_A(ntryL,G1H64(46),ex3(:),G1H32(11),m3h2x32(:,24),heltab2x64(:,:,46))
  call Hloop_Q_A(ntryL,G1H32(11),68,nMT,G2H32(14),n2h32(13))
  call Hloop_AQ_V(ntryL,G1H64(47),ex3(:),G1H32(11),m3h2x32(:,25),heltab2x64(:,:,47))
  call Hloop_VQ_A(ntryL,G1H64(48),ex3(:),G1H32(12),m3h2x32(:,26),heltab2x64(:,:,48))
  call Hloop_Q_A(ntryL,G1H32(12),68,nMT,G2H32(15),n2h32(14))
  call Hloop_AZ_Q(ntryL,G1H64(49),wf4(:,2),G1H16(1),ngZu,m3h4x16(:,23),heltab2x64(:,:,49))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMT,G2H16(23),n2h16(23))
  call Hloop_AZ_Q(ntryL,G1H64(50),wf4(:,2),G1H16(1),ngZu,m3h4x16(:,24),heltab2x64(:,:,50))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMT,G2H16(24),n2h16(24))
  call Hloop_VA_Q(ntryL,G1H64(51),ex4(:),G1H32(12),m3h2x32(:,27),heltab2x64(:,:,51))
  call Hloop_A_Q(ntryL,G1H32(12),72,nMT,G2H32(16),n2h32(15))
  call Hloop_UV_W(ntryL,G1H64(52),64,ex5(:),16,G2H32(17),m3h2x32(:,28),heltab2x64(:,:,52))
  call Hloop_QA_V(ntryL,G1H64(53),ex4(:),G1H32(12),m3h2x32(:,29),heltab2x64(:,:,53))
  call Hloop_VA_Q(ntryL,G1H64(54),ex4(:),G1H32(13),m3h2x32(:,30),heltab2x64(:,:,54))
  call Hloop_A_Q(ntryL,G1H32(13),72,nMT,G2H32(18),n2h32(16))
  call Hloop_VQ_A(ntryL,G1H64(55),ex3(:),G1H32(13),m3h2x32(:,31),heltab2x64(:,:,55))
  call Hloop_Q_A(ntryL,G1H32(13),68,nMT,G2H32(19),n2h32(17))
  call Hloop_VQ_A(ntryL,G1H64(56),ex3(:),G1H32(13),m3h2x32(:,32),heltab2x64(:,:,56))
  call Hloop_Q_A(ntryL,G1H32(13),68,nMT,G2H32(20),n2h32(18))
  call Hloop_VQ_A(ntryL,G1H64(57),ex3(:),G1H32(13),m3h2x32(:,33),heltab2x64(:,:,57))
  call Hloop_Q_A(ntryL,G1H32(13),68,nMT,G2H32(21),n2h32(19))
  call Hloop_VQ_A(ntryL,G1H64(58),ex3(:),G1H32(13),m3h2x32(:,34),heltab2x64(:,:,58))
  call Hloop_Q_A(ntryL,G1H32(13),68,nMT,G2H32(22),n2h32(20))
  call Hloop_VQ_A(ntryL,G1H64(59),ex3(:),G1H32(13),m3h2x32(:,35),heltab2x64(:,:,59))
  call Hloop_Q_A(ntryL,G1H32(13),68,nMT,G2H32(23),n2h32(21))
  call Hloop_VQ_A(ntryL,G1H64(60),ex3(:),G1H32(13),m3h2x32(:,36),heltab2x64(:,:,60))
  call Hloop_Q_A(ntryL,G1H32(13),68,nMT,G2H32(24),n2h32(22))
  call Hotf_5pt_reduction(G2H16(1),RedSet_5(1),mass5set(:,1),  & 
G1H16(1),G1H16(2),G1H16(3),G1H16(4),G1H16(5),G1H16(6),16)
  call HG1shiftOLR(G1H16(2),16,16)
  call Hotf_5pt_reduction(G2H16(2),RedSet_5(2),mass5set(:,1),  & 
G1H16(7),G1H16(8),G1H16(9),G1H16(10),G1H16(11),G1H16(12),16)
  call HG1shiftOLR(G1H16(8),32,16)
  call Hotf_5pt_reduction(G2H16(3),RedSet_5(3),mass5set(:,2),  & 
G1H16(13),G1H16(14),G1H16(15),G1H16(16),G1H16(17),G1H16(18),16)
  call HG1shiftOLR(G1H16(14),8,16)
  call Hloop_VQ_A(ntryL,G1H32(1),ex3(:),G1H16(19),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_Q_A(ntryL,G1H16(19),76,nMT,G2H16(1),n2h16(25))
  call Hloop_QA_V(ntryL,G2H16(4),ex4(:),G2H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_AQ_V(ntryL,G2H32(1),ex3(:),G2H16(2),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hotf_5pt_reduction(G2H16(5),RedSet_5(4),mass5set(:,1),  & 
G1H16(19),G1H16(20),G1H16(21),G1H16(22),G1H16(23),G1H16(24),16)
  call HG1shiftOLR(G1H16(20),16,16)
  call Hotf_5pt_reduction(G2H16(6),RedSet_5(5),mass5set(:,1),  & 
G1H16(25),G1H16(26),G1H16(27),G1H16(28),G1H16(29),G1H16(30),16)
  call HG1shiftOLR(G1H16(26),32,16)
  call Hotf_5pt_reduction(G2H16(7),RedSet_5(6),mass5set(:,2),  & 
G1H16(31),G1H16(32),G1H16(33),G1H16(34),G1H16(35),G1H16(36),16)
  call HG1shiftOLR(G1H16(32),8,16)
  call Hloop_VQ_A(ntryL,G1H32(2),ex3(:),G1H16(37),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_Q_A(ntryL,G1H16(37),76,nMT,G2H16(3),n2h16(26))
  call Hloop_QA_V(ntryL,G2H16(8),ex4(:),G2H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hotf_5pt_reduction(G2H32(2),RedSet_5(7),mass5set(:,1),  & 
G1H32(13),G1H32(1),G1H32(2),G1H32(14),G1H32(15),G1H32(16),32)
  call HG1shiftOLR(G1H32(1),32,32)
  call Hotf_5pt_reduction(G2H16(9),RedSet_5(3),mass5set(:,2),  & 
G1H16(37),G1H16(38),G1H16(39),G1H16(40),G1H16(41),G1H16(42),16)
  call HG1shiftOLR(G1H16(38),4,16)
  call Hloop_VA_Q(ntryL,G1H32(3),ex4(:),G1H16(43),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G1H16(43),76,nMT,G2H16(4),n2h16(27))
  call Hotf_5pt_reduction(G2H16(10),RedSet_5(6),mass5set(:,2),  & 
G1H16(43),G1H16(44),G1H16(45),G1H16(46),G1H16(47),G1H16(48),16)
  call HG1shiftOLR(G1H16(44),4,16)
  call Hloop_VA_Q(ntryL,G1H32(4),ex4(:),G1H16(49),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G1H16(49),76,nMT,G2H16(5),n2h16(28))
  call Hloop_VA_Q(ntryL,G1H32(5),ex4(:),G1H16(49),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_A_Q(ntryL,G1H16(49),76,nMT,G2H16(6),n2h16(29))
  call Hloop_VA_Q(ntryL,G1H32(6),ex4(:),G1H16(49),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_A_Q(ntryL,G1H16(49),76,nMT,G2H16(7),n2h16(30))
  call Hloop_AQ_V(ntryL,G2H16(11),ex3(:),G2H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_QA_V(ntryL,G2H32(3),ex4(:),G2H16(8),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_AQ_V(ntryL,G2H16(12),ex3(:),G2H8(4),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hotf_5pt_reduction(G2H32(4),RedSet_5(8),mass5set(:,1),  & 
G1H32(3),G1H32(4),G1H32(5),G1H32(6),G1H32(17),G1H32(18),32)
  call HG1shiftOLR(G1H32(4),32,32)
  call Hloop_VQ_A(ntryL,G1H32(7),ex3(:),G1H16(49),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_Q_A(ntryL,G1H16(49),76,nMT,G2H16(9),n2h16(31))
  call Hloop_VQ_A(ntryL,G1H32(8),ex3(:),G1H16(49),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_Q_A(ntryL,G1H16(49),76,nMT,G2H16(10),n2h16(32))
  call Hotf_5pt_reduction(G2H16(13),RedSet_5(4),mass5set(:,1),  & 
G1H16(49),G1H16(50),G1H16(51),G1H16(52),G1H16(53),G1H16(54),16)
  call HG1shiftOLR(G1H16(50),8,16)
  call Hloop_QA_V(ntryL,G2H16(14),ex4(:),G2H8(5),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hotf_5pt_reduction(G2H16(15),RedSet_5(2),mass5set(:,1),  & 
G1H16(55),G1H16(56),G1H16(57),G1H16(58),G1H16(59),G1H16(60),16)
  call HG1shiftOLR(G1H16(56),8,16)
  call Hloop_QA_V(ntryL,G2H16(16),ex4(:),G2H8(6),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hotf_5pt_reduction(G2H32(5),RedSet_5(9),mass5set(:,3),  & 
G1H32(7),G1H32(8),G1H32(19),G1H32(20),G1H32(21),G1H32(22),32)
  call HG1shiftOLR(G1H32(8),16,32)
  call Hotf_5pt_reduction(G2H32(6),RedSet_5(10),mass5set(:,3),  & 
G1H32(23),G1H32(24),G1H32(25),G1H32(26),G1H32(27),G1H32(28),32)
  call HG1shiftOLR(G1H32(24),32,32)
  call Hotf_5pt_reduction(G2H16(17),RedSet_5(1),mass5set(:,1),  & 
G1H16(61),G1H16(62),G1H16(63),G1H16(64),G1H16(65),G1H16(66),16)
  call HG1shiftOLR(G1H16(62),4,16)
  call Hloop_UV_W(ntryL,G1H32(9),68,ex5(:),16,G2H16(11),m3h2x16(:,11),heltab2x32(:,:,11))
  call Hotf_5pt_reduction(G2H32(7),RedSet_5(11),mass5set(:,3),  & 
G1H32(9),G1H32(29),G1H32(30),G1H32(31),G1H32(32),G1H32(33),32)
  call HG1shiftOLR(G1H32(29),8,32)
  call Hloop_QA_V(ntryL,G2H16(18),ex4(:),G2H8(7),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hotf_5pt_reduction(G2H32(8),RedSet_5(11),mass5set(:,3),  & 
G1H32(34),G1H32(35),G1H32(36),G1H32(37),G1H32(38),G1H32(39),32)
  call HG1shiftOLR(G1H32(35),32,32)
  call Hotf_5pt_reduction(G2H32(9),RedSet_5(12),mass5set(:,3),  & 
G1H32(40),G1H32(41),G1H32(42),G1H32(43),G1H32(44),G1H32(45),32)
  call HG1shiftOLR(G1H32(41),8,32)
  call Hloop_AQ_V(ntryL,G2H16(19),ex3(:),G2H8(8),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_UV_W(ntryL,G1H32(10),72,ex5(:),16,G2H16(12),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_AQ_V(ntryL,G2H16(20),ex3(:),G2H8(9),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hotf_5pt_reduction(G2H32(10),RedSet_5(13),mass5set(:,3),  & 
G1H32(10),G1H32(46),G1H32(47),G1H32(48),G1H32(49),G1H32(50),32)
  call HG1shiftOLR(G1H32(46),16,32)
  call Hotf_5pt_reduction(G2H32(11),RedSet_5(14),mass5set(:,4),  & 
G1H32(51),G1H32(52),G1H32(53),G1H32(54),G1H32(55),G1H32(56),32)
  call HG1shiftOLR(G1H32(52),32,32)
  call Hotf_5pt_reduction(G2H32(12),RedSet_5(15),mass5set(:,5),  & 
G1H32(57),G1H32(58),G1H32(59),G1H32(60),G1H32(61),G1H32(62),32)
  call HG1shiftOLR(G1H32(58),32,32)
  call Hotf_5pt_reduction(G2H16(21),RedSet_5(5),mass5set(:,1),  & 
G1H16(67),G1H16(68),G1H16(69),G1H16(70),G1H16(71),G1H16(72),16)
  call HG1shiftOLR(G1H16(68),4,16)
  call Hotf_5pt_reduction(G2H32(13),RedSet_5(16),mass5set(:,3),  & 
G1H32(63),G1H32(64),G1H32(65),G1H32(66),G1H32(67),G1H32(68),32)
  call HG1shiftOLR(G1H32(64),8,32)
  call Hloop_QA_V(ntryL,G2H16(22),ex4(:),G2H8(10),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hotf_5pt_reduction(G2H32(14),RedSet_5(16),mass5set(:,3),  & 
G1H32(69),G1H32(70),G1H32(71),G1H32(72),G1H32(73),G1H32(74),32)
  call HG1shiftOLR(G1H32(70),16,32)
  call Hloop_UV_W(ntryL,G1H32(11),68,ex6(:),32,G2H16(13),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hotf_5pt_reduction(G2H32(15),RedSet_5(17),mass5set(:,3),  & 
G1H32(11),G1H32(75),G1H32(76),G1H32(77),G1H32(78),G1H32(79),32)
  call HG1shiftOLR(G1H32(75),8,32)
  call Hloop_AQ_V(ntryL,G2H16(23),ex3(:),G2H8(11),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_AQ_V(ntryL,G2H16(24),ex3(:),G2H8(12),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hotf_5pt_reduction(G2H32(16),RedSet_5(18),mass5set(:,3),  & 
G1H32(80),G1H32(81),G1H32(82),G1H32(83),G1H32(84),G1H32(85),32)
  call HG1shiftOLR(G1H32(81),32,32)
  call Hotf_5pt_reduction(G2H32(17),RedSet_5(19),mass5set(:,4),  & 
G1H32(86),G1H32(87),G1H32(88),G1H32(89),G1H32(90),G1H32(91),32)
  call HG1shiftOLR(G1H32(87),32,32)
  call Hloop_UV_W(ntryL,G1H32(12),72,ex6(:),32,G2H16(14),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hotf_5pt_reduction(G2H32(18),RedSet_5(15),mass5set(:,5),  & 
G1H32(12),G1H32(92),G1H32(93),G1H32(94),G1H32(95),G1H32(96),32)
  call HG1shiftOLR(G1H32(92),16,32)
  call Hotf_5pt_reduction(G2H32(19),RedSet_5(20),mass5set(:,3),  & 
G1H32(97),G1H32(98),G1H32(99),G1H32(100),G1H32(101),G1H32(102),32)
  call HG1shiftOLR(G1H32(98),16,32)
  call Hotf_5pt_reduction(G2H32(20),RedSet_5(21),mass5set(:,3),  & 
G1H32(103),G1H32(104),G1H32(105),G1H32(106),G1H32(107),G1H32(108),32)
  call HG1shiftOLR(G1H32(104),32,32)
  call Hotf_5pt_reduction(G2H32(21),RedSet_5(20),mass5set(:,3),  & 
G1H32(109),G1H32(110),G1H32(111),G1H32(112),G1H32(113),G1H32(114),32)
  call HG1shiftOLR(G1H32(110),8,32)
  call Hotf_5pt_reduction(G2H32(22),RedSet_5(22),mass5set(:,5),  & 
G1H32(115),G1H32(116),G1H32(117),G1H32(118),G1H32(119),G1H32(120),32)
  call HG1shiftOLR(G1H32(116),32,32)
  call Hotf_5pt_reduction(G2H32(23),RedSet_5(21),mass5set(:,3),  & 
G1H32(121),G1H32(122),G1H32(123),G1H32(124),G1H32(125),G1H32(126),32)
  call HG1shiftOLR(G1H32(122),8,32)
  call Hotf_5pt_reduction(G2H32(24),RedSet_5(22),mass5set(:,5),  & 
G1H32(127),G1H32(128),G1H32(129),G1H32(130),G1H32(131),G1H32(132),32)
  call HG1shiftOLR(G1H32(128),16,32)
  call Hloop_QV_A(ntryL,G1H16(1),ex6(:),G1H8(1),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_Q_A(ntryL,G1H8(1),99,nMT,G2H8(13),n2h8(1))
call HGT_OLR(G1H16(2),1,1,16)
call HGT_invQ_OLR(G1H16(2),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(2),-16,nMT,G2H16(15),n2h16(33))
  call Hloop_AV_Q(ntryL,G2H16(15),ex5(:),G2H8(14),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_QV_A(ntryL,G1H16(4),ex6(:),G1H8(1),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_Q_A(ntryL,G1H8(1),99,nMT,G2H8(15),n2h8(2))
  call Hloop_QV_A(ntryL,G1H16(5),ex6(:),G1H8(1),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_Q_A(ntryL,G1H8(1),99,nMT,G2H8(16),n2h8(3))
  call Hloop_QV_A(ntryL,G1H16(6),ex6(:),G1H8(1),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_Q_A(ntryL,G1H8(1),99,nMT,G2H8(17),n2h8(4))
  call Hloop_AV_Q(ntryL,G1H16(7),ex5(:),G1H8(1),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_A_Q(ntryL,G1H8(1),83,nMT,G2H8(18),n2h8(5))
call HGT_OLR(G1H16(8),1,1,16)
call HGT_invQ_OLR(G1H16(8),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(8),-32,nMT,G2H16(16),n2h16(34))
  call Hloop_QV_A(ntryL,G2H16(16),ex6(:),G2H8(19),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_AV_Q(ntryL,G1H16(10),ex5(:),G1H8(1),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_A_Q(ntryL,G1H8(1),83,nMT,G2H8(20),n2h8(6))
  call Hloop_AV_Q(ntryL,G1H16(11),ex5(:),G1H8(1),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_A_Q(ntryL,G1H8(1),83,nMT,G2H8(21),n2h8(7))
  call Hloop_AV_Q(ntryL,G1H16(12),ex5(:),G1H8(1),m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_A_Q(ntryL,G1H8(1),83,nMT,G2H8(22),n2h8(8))
  call Hloop_AV_Q(ntryL,G1H16(13),ex6(:),G1H8(1),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_A_Q(ntryL,G1H8(1),99,nMT,G2H8(23),n2h8(9))
call HGT_OLR(G1H16(14),1,1,16)
call HGT_invQ_OLR(G1H16(14),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(14),-8,nMT,G2H16(17),n2h16(35))
  call Hloop_QA_V(ntryL,G2H16(17),ex4(:),G2H8(24),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_AV_Q(ntryL,G1H16(16),ex6(:),G1H8(1),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_A_Q(ntryL,G1H8(1),99,nMT,G2H8(25),n2h8(10))
  call Hloop_AV_Q(ntryL,G1H16(17),ex6(:),G1H8(1),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_A_Q(ntryL,G1H8(1),99,nMT,G2H8(26),n2h8(11))
  call Hloop_AV_Q(ntryL,G1H16(18),ex6(:),G1H8(1),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_A_Q(ntryL,G1H8(1),99,nMT,G2H8(27),n2h8(12))
  call Hloop_AV_Q(ntryL,G1H16(19),ex6(:),G1H8(1),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_A_Q(ntryL,G1H8(1),99,nMT,G2H8(28),n2h8(13))
call HGT_OLR(G1H16(20),1,1,16)
call HGT_invQ_OLR(G1H16(20),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(20),-16,nMT,G2H16(18),n2h16(36))
  call Hloop_QV_A(ntryL,G2H16(18),ex5(:),G2H8(29),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_AV_Q(ntryL,G1H16(22),ex6(:),G1H8(1),m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_A_Q(ntryL,G1H8(1),99,nMT,G2H8(30),n2h8(14))
  call Hloop_AV_Q(ntryL,G1H16(23),ex6(:),G1H8(1),m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_A_Q(ntryL,G1H8(1),99,nMT,G2H8(31),n2h8(15))
  call Hloop_AV_Q(ntryL,G1H16(24),ex6(:),G1H8(1),m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_A_Q(ntryL,G1H8(1),99,nMT,G2H8(32),n2h8(16))
  call Hloop_QV_A(ntryL,G1H16(25),ex5(:),G1H8(1),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMT,G2H8(33),n2h8(17))
call HGT_OLR(G1H16(26),1,1,16)
call HGT_invQ_OLR(G1H16(26),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(26),-32,nMT,G2H16(19),n2h16(37))
  call Hloop_AV_Q(ntryL,G2H16(19),ex6(:),G2H8(34),m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_QV_A(ntryL,G1H16(28),ex5(:),G1H8(1),m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMT,G2H8(35),n2h8(18))
  call Hloop_QV_A(ntryL,G1H16(29),ex5(:),G1H8(1),m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMT,G2H8(36),n2h8(19))
  call Hloop_QV_A(ntryL,G1H16(30),ex5(:),G1H8(1),m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMT,G2H8(37),n2h8(20))
  call Hloop_AV_Q(ntryL,G1H16(31),ex5(:),G1H8(1),m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_A_Q(ntryL,G1H8(1),83,nMT,G2H8(38),n2h8(21))
call HGT_OLR(G1H16(32),1,1,16)
call HGT_invQ_OLR(G1H16(32),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(32),-8,nMT,G2H16(20),n2h16(38))
  call Hloop_QA_V(ntryL,G2H16(20),ex4(:),G2H8(39),m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_AV_Q(ntryL,G1H16(34),ex5(:),G1H8(1),m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_A_Q(ntryL,G1H8(1),83,nMT,G2H8(40),n2h8(22))
  call Hloop_AV_Q(ntryL,G1H16(35),ex5(:),G1H8(1),m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_A_Q(ntryL,G1H8(1),83,nMT,G2H8(41),n2h8(23))
  call Hloop_AV_Q(ntryL,G1H16(36),ex5(:),G1H8(1),m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_A_Q(ntryL,G1H8(1),83,nMT,G2H8(42),n2h8(24))
  call Hloop_QZ_A(ntryL,G1H32(13),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,1),heltab2x32(:,:,15))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMT,G2H8(43),n2h8(25))
call HGT_OLR(G1H32(1),1,1,32)
call HGT_invQ_OLR(G1H32(1),2,5,32)
  call Hloop_A_Q(ntryL,G1H32(1),-32,nMT,G2H32(1),n2h32(23))
  call Hloop_AV_Q(ntryL,G2H32(1),ex6(:),G2H16(21),m3h2x16(:,15),heltab2x32(:,:,16))
  call Hloop_QZ_A(ntryL,G1H32(14),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,2),heltab2x32(:,:,17))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMT,G2H8(44),n2h8(26))
  call Hloop_QZ_A(ntryL,G1H32(15),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,3),heltab2x32(:,:,18))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMT,G2H8(45),n2h8(27))
  call Hloop_QZ_A(ntryL,G1H32(16),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,4),heltab2x32(:,:,19))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMT,G2H8(46),n2h8(28))
  call Hloop_QV_A(ntryL,G1H16(37),ex6(:),G1H8(1),m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_Q_A(ntryL,G1H8(1),99,nMT,G2H8(47),n2h8(29))
call HGT_OLR(G1H16(38),1,1,16)
call HGT_invQ_OLR(G1H16(38),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(38),-4,nMT,G2H16(22),n2h16(39))
  call Hloop_AQ_V(ntryL,G2H16(22),ex3(:),G2H8(48),m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_QV_A(ntryL,G1H16(40),ex6(:),G1H8(1),m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_Q_A(ntryL,G1H8(1),99,nMT,G2H8(49),n2h8(30))
  call Hloop_QV_A(ntryL,G1H16(41),ex6(:),G1H8(1),m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_Q_A(ntryL,G1H8(1),99,nMT,G2H8(50),n2h8(31))
  call Hloop_QV_A(ntryL,G1H16(42),ex6(:),G1H8(1),m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_Q_A(ntryL,G1H8(1),99,nMT,G2H8(51),n2h8(32))
  call Hloop_QV_A(ntryL,G1H16(43),ex5(:),G1H8(1),m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMT,G2H8(52),n2h8(33))
call HGT_OLR(G1H16(44),1,1,16)
call HGT_invQ_OLR(G1H16(44),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(44),-4,nMT,G2H16(23),n2h16(40))
  call Hloop_AQ_V(ntryL,G2H16(23),ex3(:),G2H8(53),m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_QV_A(ntryL,G1H16(46),ex5(:),G1H8(1),m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMT,G2H8(54),n2h8(34))
  call Hloop_QV_A(ntryL,G1H16(47),ex5(:),G1H8(1),m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMT,G2H8(55),n2h8(35))
  call Hloop_QV_A(ntryL,G1H16(48),ex5(:),G1H8(1),m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMT,G2H8(56),n2h8(36))
  call Hloop_AZ_Q(ntryL,G1H32(3),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,5),heltab2x32(:,:,20))
  call Hloop_A_Q(ntryL,G1H8(1),83,nMT,G2H8(57),n2h8(37))
call HGT_OLR(G1H32(4),1,1,32)
call HGT_invQ_OLR(G1H32(4),2,5,32)
  call Hloop_Q_A(ntryL,G1H32(4),-32,nMT,G2H32(2),n2h32(24))
  call Hloop_QV_A(ntryL,G2H32(2),ex6(:),G2H16(24),m3h2x16(:,16),heltab2x32(:,:,21))
  call Hloop_AZ_Q(ntryL,G1H32(6),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,6),heltab2x32(:,:,22))
  call Hloop_A_Q(ntryL,G1H8(1),83,nMT,G2H8(58),n2h8(38))
  call Hloop_AZ_Q(ntryL,G1H32(17),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,7),heltab2x32(:,:,23))
  call Hloop_A_Q(ntryL,G1H8(1),83,nMT,G2H8(59),n2h8(39))
  call Hloop_AZ_Q(ntryL,G1H32(18),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,8),heltab2x32(:,:,24))
  call Hloop_A_Q(ntryL,G1H8(1),83,nMT,G2H8(60),n2h8(40))
  call Hloop_AV_Q(ntryL,G1H16(49),ex6(:),G1H8(1),m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_A_Q(ntryL,G1H8(1),99,nMT,G2H8(61),n2h8(41))
call HGT_OLR(G1H16(50),1,1,16)
call HGT_invQ_OLR(G1H16(50),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(50),-8,nMT,G2H16(15),n2h16(41))
  call Hloop_QA_V(ntryL,G2H16(15),ex4(:),G2H8(62),m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_AV_Q(ntryL,G1H16(52),ex6(:),G1H8(1),m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_A_Q(ntryL,G1H8(1),99,nMT,G2H8(63),n2h8(42))
  call Hloop_AV_Q(ntryL,G1H16(53),ex6(:),G1H8(1),m3h2x8(:,56),heltab2x16(:,:,56))
  call Hloop_A_Q(ntryL,G1H8(1),99,nMT,G2H8(64),n2h8(43))
  call Hloop_AV_Q(ntryL,G1H16(54),ex6(:),G1H8(1),m3h2x8(:,57),heltab2x16(:,:,57))
  call Hloop_A_Q(ntryL,G1H8(1),99,nMT,G2H8(65),n2h8(44))
  call Hloop_AV_Q(ntryL,G1H16(55),ex5(:),G1H8(1),m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_A_Q(ntryL,G1H8(1),83,nMT,G2H8(66),n2h8(45))
call HGT_OLR(G1H16(56),1,1,16)
call HGT_invQ_OLR(G1H16(56),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(56),-8,nMT,G2H16(16),n2h16(42))
  call Hloop_QA_V(ntryL,G2H16(16),ex4(:),G2H8(67),m3h2x8(:,59),heltab2x16(:,:,59))
  call Hloop_AV_Q(ntryL,G1H16(58),ex5(:),G1H8(1),m3h2x8(:,60),heltab2x16(:,:,60))
  call Hloop_A_Q(ntryL,G1H8(1),83,nMT,G2H8(68),n2h8(46))
  call Hloop_AV_Q(ntryL,G1H16(59),ex5(:),G1H8(1),m3h2x8(:,61),heltab2x16(:,:,61))
  call Hloop_A_Q(ntryL,G1H8(1),83,nMT,G2H8(69),n2h8(47))
  call Hloop_AV_Q(ntryL,G1H16(60),ex5(:),G1H8(1),m3h2x8(:,62),heltab2x16(:,:,62))
  call Hloop_A_Q(ntryL,G1H8(1),83,nMT,G2H8(70),n2h8(48))
  call Hloop_AZ_Q(ntryL,G1H32(7),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,9),heltab2x32(:,:,25))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(71),n2h8(49))
call HGT_raise_alpha_OLR(G1H32(8),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(8),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(8),-16,ex5(:),16,G2H16(17),m3h2x16(:,17),heltab2x32(:,:,26))
call signflip_OLR(G2H16(17))
  call Hloop_AZ_Q(ntryL,G1H32(20),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,10),heltab2x32(:,:,27))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(72),n2h8(50))
  call Hloop_AZ_Q(ntryL,G1H32(21),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,11),heltab2x32(:,:,28))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(73),n2h8(51))
  call Hloop_AZ_Q(ntryL,G1H32(22),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,12),heltab2x32(:,:,29))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(74),n2h8(52))
  call Hloop_AZ_Q(ntryL,G1H32(23),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,13),heltab2x32(:,:,30))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(75),n2h8(53))
call HGT_raise_alpha_OLR(G1H32(24),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(24),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(24),-32,ex6(:),32,G2H16(18),m3h2x16(:,18),heltab2x32(:,:,31))
call signflip_OLR(G2H16(18))
  call Hloop_AZ_Q(ntryL,G1H32(26),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,14),heltab2x32(:,:,32))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(76),n2h8(54))
  call Hloop_AZ_Q(ntryL,G1H32(27),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,15),heltab2x32(:,:,33))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(77),n2h8(55))
  call Hloop_AZ_Q(ntryL,G1H32(28),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,16),heltab2x32(:,:,34))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(78),n2h8(56))
  call Hloop_QV_A(ntryL,G1H16(61),ex6(:),G1H8(1),m3h2x8(:,63),heltab2x16(:,:,63))
  call Hloop_Q_A(ntryL,G1H8(1),99,nMT,G2H8(79),n2h8(57))
call HGT_OLR(G1H16(62),1,1,16)
call HGT_invQ_OLR(G1H16(62),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(62),-4,nMT,G2H16(19),n2h16(43))
  call Hloop_AQ_V(ntryL,G2H16(19),ex3(:),G2H8(80),m3h2x8(:,64),heltab2x16(:,:,64))
  call Hloop_QV_A(ntryL,G1H16(64),ex6(:),G1H8(1),m3h2x8(:,65),heltab2x16(:,:,65))
  call Hloop_Q_A(ntryL,G1H8(1),99,nMT,G2H8(81),n2h8(58))
  call Hloop_QV_A(ntryL,G1H16(65),ex6(:),G1H8(1),m3h2x8(:,66),heltab2x16(:,:,66))
  call Hloop_Q_A(ntryL,G1H8(1),99,nMT,G2H8(82),n2h8(59))
  call Hloop_QV_A(ntryL,G1H16(66),ex6(:),G1H8(1),m3h2x8(:,67),heltab2x16(:,:,67))
  call Hloop_Q_A(ntryL,G1H8(1),99,nMT,G2H8(83),n2h8(60))
  call Hloop_QV_A(ntryL,G1H32(9),ex5(:),G1H16(1),m3h2x16(:,19),heltab2x32(:,:,35))
  call Hloop_Q_A(ntryL,G1H16(1),84,nMT,G2H16(20),n2h16(44))
call HGT_raise_alpha_OLR(G1H32(29),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(29),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(29),ex4(:),G1H16(2),m3h2x16(:,20),heltab2x32(:,:,36))
  call Hloop_QV_A(ntryL,G1H32(31),ex5(:),G1H16(4),m3h2x16(:,21),heltab2x32(:,:,37))
  call Hloop_Q_A(ntryL,G1H16(4),84,nMT,G2H16(22),n2h16(45))
  call Hloop_QV_A(ntryL,G1H32(32),ex5(:),G1H16(5),m3h2x16(:,22),heltab2x32(:,:,38))
  call Hloop_Q_A(ntryL,G1H16(5),84,nMT,G2H16(23),n2h16(46))
  call Hloop_QV_A(ntryL,G1H32(33),ex5(:),G1H16(6),m3h2x16(:,23),heltab2x32(:,:,39))
  call Hloop_Q_A(ntryL,G1H16(6),84,nMT,G2H16(15),n2h16(47))
  call Hloop_QV_A(ntryL,G1H32(34),ex5(:),G1H16(7),m3h2x16(:,24),heltab2x32(:,:,40))
  call Hloop_Q_A(ntryL,G1H16(7),84,nMT,G2H16(16),n2h16(48))
call HGT_raise_alpha_OLR(G1H32(35),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(35),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(35),-32,ex6(:),32,G2H16(19),m3h2x16(:,25),heltab2x32(:,:,41))
call signflip_OLR(G2H16(19))
  call Hloop_QV_A(ntryL,G1H32(37),ex5(:),G1H16(8),m3h2x16(:,26),heltab2x32(:,:,42))
  call Hloop_Q_A(ntryL,G1H16(8),84,nMT,G2H16(25),n2h16(49))
  call Hloop_QV_A(ntryL,G1H32(38),ex5(:),G1H16(10),m3h2x16(:,27),heltab2x32(:,:,43))
  call Hloop_Q_A(ntryL,G1H16(10),84,nMT,G2H16(26),n2h16(50))
  call Hloop_QV_A(ntryL,G1H32(39),ex5(:),G1H16(11),m3h2x16(:,28),heltab2x32(:,:,44))
  call Hloop_Q_A(ntryL,G1H16(11),84,nMT,G2H16(27),n2h16(51))
  call Hloop_QV_A(ntryL,G1H32(40),ex5(:),G1H16(12),m3h2x16(:,29),heltab2x32(:,:,45))
  call Hloop_Q_A(ntryL,G1H16(12),84,nMT,G2H16(28),n2h16(52))
call HGT_raise_alpha_OLR(G1H32(41),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(41),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(41),ex4(:),G1H16(13),m3h2x16(:,30),heltab2x32(:,:,46))
  call Hloop_QV_A(ntryL,G1H32(43),ex5(:),G1H16(14),m3h2x16(:,31),heltab2x32(:,:,47))
  call Hloop_Q_A(ntryL,G1H16(14),84,nMT,G2H16(29),n2h16(53))
  call Hloop_QV_A(ntryL,G1H32(44),ex5(:),G1H16(16),m3h2x16(:,32),heltab2x32(:,:,48))
  call Hloop_Q_A(ntryL,G1H16(16),84,nMT,G2H16(30),n2h16(54))
  call Hloop_QV_A(ntryL,G1H32(45),ex5(:),G1H16(17),m3h2x16(:,33),heltab2x32(:,:,49))
  call Hloop_Q_A(ntryL,G1H16(17),84,nMT,G2H16(31),n2h16(55))
  call Hloop_AV_Q(ntryL,G1H32(10),ex6(:),G1H16(18),m3h2x16(:,34),heltab2x32(:,:,50))
  call Hloop_A_Q(ntryL,G1H16(18),104,nMT,G2H16(32),n2h16(56))
call HGT_raise_alpha_OLR(G1H32(46),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(46),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(46),-16,ex5(:),16,G2H16(33),m3h2x16(:,35),heltab2x32(:,:,51))
call signflip_OLR(G2H16(33))
  call Hloop_AV_Q(ntryL,G1H32(48),ex6(:),G1H16(19),m3h2x16(:,36),heltab2x32(:,:,52))
  call Hloop_A_Q(ntryL,G1H16(19),104,nMT,G2H16(34),n2h16(57))
  call Hloop_AV_Q(ntryL,G1H32(49),ex6(:),G1H16(20),m3h2x16(:,37),heltab2x32(:,:,53))
  call Hloop_A_Q(ntryL,G1H16(20),104,nMT,G2H16(35),n2h16(58))
  call Hloop_AV_Q(ntryL,G1H32(50),ex6(:),G1H16(22),m3h2x16(:,38),heltab2x32(:,:,54))
  call Hloop_A_Q(ntryL,G1H16(22),104,nMT,G2H16(36),n2h16(59))
  call Hloop_VQ_A(ntryL,G1H32(51),ex3(:),G1H16(23),m3h2x16(:,39),heltab2x32(:,:,55))
  call Hloop_Q_A(ntryL,G1H16(23),84,nMT,G2H16(37),n2h16(60))
call HGT_raise_alpha_OLR(G1H32(52),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(52),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(52),-32,ex6(:),32,G2H16(38),m3h2x16(:,40),heltab2x32(:,:,56))
call signflip_OLR(G2H16(38))
  call Hloop_VQ_A(ntryL,G1H32(54),ex3(:),G1H16(24),m3h2x16(:,41),heltab2x32(:,:,57))
  call Hloop_Q_A(ntryL,G1H16(24),84,nMT,G2H16(39),n2h16(61))
  call Hloop_VQ_A(ntryL,G1H32(55),ex3(:),G1H16(25),m3h2x16(:,42),heltab2x32(:,:,58))
  call Hloop_Q_A(ntryL,G1H16(25),84,nMT,G2H16(40),n2h16(62))
  call Hloop_VQ_A(ntryL,G1H32(56),ex3(:),G1H16(26),m3h2x16(:,43),heltab2x32(:,:,59))
  call Hloop_Q_A(ntryL,G1H16(26),84,nMT,G2H16(41),n2h16(63))
  call Hloop_AZ_Q(ntryL,G1H32(57),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,17),heltab2x32(:,:,60))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(84),n2h8(61))
call HGT_raise_alpha_OLR(G1H32(58),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(58),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(58),-32,ex6(:),32,G2H16(42),m3h2x16(:,44),heltab2x32(:,:,61))
call signflip_OLR(G2H16(42))
  call Hloop_AZ_Q(ntryL,G1H32(60),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,18),heltab2x32(:,:,62))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(85),n2h8(62))
  call Hloop_AZ_Q(ntryL,G1H32(61),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,19),heltab2x32(:,:,63))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(86),n2h8(63))
  call Hloop_AZ_Q(ntryL,G1H32(62),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,20),heltab2x32(:,:,64))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(87),n2h8(64))
  call Hloop_QV_A(ntryL,G1H16(67),ex5(:),G1H8(1),m3h2x8(:,68),heltab2x16(:,:,68))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMT,G2H8(88),n2h8(65))
call HGT_OLR(G1H16(68),1,1,16)
call HGT_invQ_OLR(G1H16(68),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(68),-4,nMT,G2H16(43),n2h16(64))
  call Hloop_AQ_V(ntryL,G2H16(43),ex3(:),G2H8(89),m3h2x8(:,69),heltab2x16(:,:,69))
  call Hloop_QV_A(ntryL,G1H16(70),ex5(:),G1H8(1),m3h2x8(:,70),heltab2x16(:,:,70))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMT,G2H8(90),n2h8(66))
  call Hloop_QV_A(ntryL,G1H16(71),ex5(:),G1H8(1),m3h2x8(:,71),heltab2x16(:,:,71))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMT,G2H8(91),n2h8(67))
  call Hloop_QV_A(ntryL,G1H16(72),ex5(:),G1H8(1),m3h2x8(:,72),heltab2x16(:,:,72))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMT,G2H8(92),n2h8(68))
  call Hloop_QV_A(ntryL,G1H32(63),ex6(:),G1H16(28),m3h2x16(:,45),heltab2x32(:,:,65))
  call Hloop_Q_A(ntryL,G1H16(28),100,nMT,G2H16(43),n2h16(65))
call HGT_raise_alpha_OLR(G1H32(64),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(64),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(64),ex4(:),G1H16(29),m3h2x16(:,46),heltab2x32(:,:,66))
  call Hloop_QV_A(ntryL,G1H32(66),ex6(:),G1H16(30),m3h2x16(:,47),heltab2x32(:,:,67))
  call Hloop_Q_A(ntryL,G1H16(30),100,nMT,G2H16(44),n2h16(66))
  call Hloop_QV_A(ntryL,G1H32(67),ex6(:),G1H16(31),m3h2x16(:,48),heltab2x32(:,:,68))
  call Hloop_Q_A(ntryL,G1H16(31),100,nMT,G2H16(45),n2h16(67))
  call Hloop_QV_A(ntryL,G1H32(68),ex6(:),G1H16(32),m3h2x16(:,49),heltab2x32(:,:,69))
  call Hloop_Q_A(ntryL,G1H16(32),100,nMT,G2H16(46),n2h16(68))
  call Hloop_QV_A(ntryL,G1H32(69),ex6(:),G1H16(34),m3h2x16(:,50),heltab2x32(:,:,70))
  call Hloop_Q_A(ntryL,G1H16(34),100,nMT,G2H16(47),n2h16(69))
call HGT_raise_alpha_OLR(G1H32(70),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(70),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(70),-16,ex5(:),16,G2H16(48),m3h2x16(:,51),heltab2x32(:,:,71))
call signflip_OLR(G2H16(48))
  call Hloop_QV_A(ntryL,G1H32(72),ex6(:),G1H16(35),m3h2x16(:,52),heltab2x32(:,:,72))
  call Hloop_Q_A(ntryL,G1H16(35),100,nMT,G2H16(49),n2h16(70))
  call Hloop_QV_A(ntryL,G1H32(73),ex6(:),G1H16(36),m3h2x16(:,53),heltab2x32(:,:,73))
  call Hloop_Q_A(ntryL,G1H16(36),100,nMT,G2H16(50),n2h16(71))
  call Hloop_QV_A(ntryL,G1H32(74),ex6(:),G1H16(37),m3h2x16(:,54),heltab2x32(:,:,74))
  call Hloop_Q_A(ntryL,G1H16(37),100,nMT,G2H16(51),n2h16(72))
  call Hloop_QV_A(ntryL,G1H32(11),ex6(:),G1H16(38),m3h2x16(:,55),heltab2x32(:,:,75))
  call Hloop_Q_A(ntryL,G1H16(38),100,nMT,G2H16(52),n2h16(73))
call HGT_raise_alpha_OLR(G1H32(75),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(75),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(75),ex4(:),G1H16(40),m3h2x16(:,56),heltab2x32(:,:,76))
  call Hloop_QV_A(ntryL,G1H32(77),ex6(:),G1H16(41),m3h2x16(:,57),heltab2x32(:,:,77))
  call Hloop_Q_A(ntryL,G1H16(41),100,nMT,G2H16(53),n2h16(74))
  call Hloop_QV_A(ntryL,G1H32(78),ex6(:),G1H16(42),m3h2x16(:,58),heltab2x32(:,:,78))
  call Hloop_Q_A(ntryL,G1H16(42),100,nMT,G2H16(54),n2h16(75))
  call Hloop_QV_A(ntryL,G1H32(79),ex6(:),G1H16(43),m3h2x16(:,59),heltab2x32(:,:,79))
  call Hloop_Q_A(ntryL,G1H16(43),100,nMT,G2H16(55),n2h16(76))
  call Hloop_AV_Q(ntryL,G1H32(80),ex5(:),G1H16(44),m3h2x16(:,60),heltab2x32(:,:,80))
  call Hloop_A_Q(ntryL,G1H16(44),88,nMT,G2H16(56),n2h16(77))
call HGT_raise_alpha_OLR(G1H32(81),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(81),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(81),-32,ex6(:),32,G2H16(57),m3h2x16(:,61),heltab2x32(:,:,81))
call signflip_OLR(G2H16(57))
  call Hloop_AV_Q(ntryL,G1H32(83),ex5(:),G1H16(46),m3h2x16(:,62),heltab2x32(:,:,82))
  call Hloop_A_Q(ntryL,G1H16(46),88,nMT,G2H16(58),n2h16(78))
  call Hloop_AV_Q(ntryL,G1H32(84),ex5(:),G1H16(47),m3h2x16(:,63),heltab2x32(:,:,83))
  call Hloop_A_Q(ntryL,G1H16(47),88,nMT,G2H16(59),n2h16(79))
  call Hloop_AV_Q(ntryL,G1H32(85),ex5(:),G1H16(48),m3h2x16(:,64),heltab2x32(:,:,84))
  call Hloop_A_Q(ntryL,G1H16(48),88,nMT,G2H16(60),n2h16(80))
  call Hloop_VA_Q(ntryL,G1H32(86),ex4(:),G1H16(49),m3h2x16(:,65),heltab2x32(:,:,85))
  call Hloop_A_Q(ntryL,G1H16(49),88,nMT,G2H16(61),n2h16(81))
call HGT_raise_alpha_OLR(G1H32(87),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(87),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(87),-32,ex6(:),32,G2H16(62),m3h2x16(:,66),heltab2x32(:,:,86))
call signflip_OLR(G2H16(62))
  call Hloop_VA_Q(ntryL,G1H32(89),ex4(:),G1H16(50),m3h2x16(:,67),heltab2x32(:,:,87))
  call Hloop_A_Q(ntryL,G1H16(50),88,nMT,G2H16(63),n2h16(82))
  call Hloop_VA_Q(ntryL,G1H32(90),ex4(:),G1H16(52),m3h2x16(:,68),heltab2x32(:,:,88))
  call Hloop_A_Q(ntryL,G1H16(52),88,nMT,G2H16(64),n2h16(83))
  call Hloop_VA_Q(ntryL,G1H32(91),ex4(:),G1H16(53),m3h2x16(:,69),heltab2x32(:,:,89))
  call Hloop_A_Q(ntryL,G1H16(53),88,nMT,G2H16(65),n2h16(84))
  call Hloop_AZ_Q(ntryL,G1H32(12),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,21),heltab2x32(:,:,90))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(93),n2h8(69))
call HGT_raise_alpha_OLR(G1H32(92),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(92),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(92),-16,ex5(:),16,G2H16(66),m3h2x16(:,70),heltab2x32(:,:,91))
call signflip_OLR(G2H16(66))
  call Hloop_AZ_Q(ntryL,G1H32(94),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,22),heltab2x32(:,:,92))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(94),n2h8(70))
  call Hloop_AZ_Q(ntryL,G1H32(95),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,23),heltab2x32(:,:,93))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(95),n2h8(71))
  call Hloop_AZ_Q(ntryL,G1H32(96),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,24),heltab2x32(:,:,94))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(96),n2h8(72))
  call Hloop_QZ_A(ntryL,G1H32(97),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,25),heltab2x32(:,:,95))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(97),n2h8(73))
call HGT_raise_alpha_OLR(G1H32(98),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(98),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(98),-16,ex5(:),16,G2H16(67),m3h2x16(:,71),heltab2x32(:,:,96))
call signflip_OLR(G2H16(67))
  call Hloop_QZ_A(ntryL,G1H32(100),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,26),heltab2x32(:,:,97))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(98),n2h8(74))
  call Hloop_QZ_A(ntryL,G1H32(101),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,27),heltab2x32(:,:,98))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(99),n2h8(75))
  call Hloop_QZ_A(ntryL,G1H32(102),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,28),heltab2x32(:,:,99))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(100),n2h8(76))
  call Hloop_QZ_A(ntryL,G1H32(103),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,29),heltab2x32(:,:,100))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(101),n2h8(77))
call HGT_raise_alpha_OLR(G1H32(104),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(104),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(104),-32,ex6(:),32,G2H16(68),m3h2x16(:,72),heltab2x32(:,:,101))
call signflip_OLR(G2H16(68))
  call Hloop_QZ_A(ntryL,G1H32(106),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,30),heltab2x32(:,:,102))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(102),n2h8(78))
  call Hloop_QZ_A(ntryL,G1H32(107),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,31),heltab2x32(:,:,103))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(103),n2h8(79))
  call Hloop_QZ_A(ntryL,G1H32(108),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,32),heltab2x32(:,:,104))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(104),n2h8(80))
  call Hloop_QZ_A(ntryL,G1H32(109),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,33),heltab2x32(:,:,105))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(105),n2h8(81))
call HGT_raise_alpha_OLR(G1H32(110),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(110),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(110),ex4(:),G1H16(54),m3h2x16(:,73),heltab2x32(:,:,106))
  call Hloop_QZ_A(ntryL,G1H32(112),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,34),heltab2x32(:,:,107))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(106),n2h8(82))
  call Hloop_QZ_A(ntryL,G1H32(113),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,35),heltab2x32(:,:,108))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(107),n2h8(83))
  call Hloop_QZ_A(ntryL,G1H32(114),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,36),heltab2x32(:,:,109))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(108),n2h8(84))
  call Hloop_QZ_A(ntryL,G1H32(115),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,37),heltab2x32(:,:,110))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(109),n2h8(85))
call HGT_raise_alpha_OLR(G1H32(116),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(116),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(116),-32,ex6(:),32,G2H16(69),m3h2x16(:,74),heltab2x32(:,:,111))
call signflip_OLR(G2H16(69))
  call Hloop_QZ_A(ntryL,G1H32(118),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,38),heltab2x32(:,:,112))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(110),n2h8(86))
  call Hloop_QZ_A(ntryL,G1H32(119),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,39),heltab2x32(:,:,113))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(111),n2h8(87))
  call Hloop_QZ_A(ntryL,G1H32(120),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,40),heltab2x32(:,:,114))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(112),n2h8(88))
  call Hloop_QZ_A(ntryL,G1H32(121),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,41),heltab2x32(:,:,115))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(113),n2h8(89))
call HGT_raise_alpha_OLR(G1H32(122),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(122),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(122),ex4(:),G1H16(55),m3h2x16(:,75),heltab2x32(:,:,116))
  call Hloop_QZ_A(ntryL,G1H32(124),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,42),heltab2x32(:,:,117))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(114),n2h8(90))
  call Hloop_QZ_A(ntryL,G1H32(125),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,43),heltab2x32(:,:,118))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(115),n2h8(91))
  call Hloop_QZ_A(ntryL,G1H32(126),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,44),heltab2x32(:,:,119))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(116),n2h8(92))
  call Hloop_QZ_A(ntryL,G1H32(127),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,45),heltab2x32(:,:,120))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(117),n2h8(93))
call HGT_raise_alpha_OLR(G1H32(128),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(128),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(128),-16,ex5(:),16,G2H16(70),m3h2x16(:,76),heltab2x32(:,:,121))
call signflip_OLR(G2H16(70))
  call Hloop_QZ_A(ntryL,G1H32(130),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,46),heltab2x32(:,:,122))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(118),n2h8(94))
  call Hloop_QZ_A(ntryL,G1H32(131),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,47),heltab2x32(:,:,123))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(119),n2h8(95))
  call Hloop_QZ_A(ntryL,G1H32(132),wf4(:,2),G1H8(1),ngZu,m3h4x8(:,48),heltab2x32(:,:,124))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(120),n2h8(96))
  call Hotf_5pt_reduction(G2H16(1),RedSet_5(23),mass5set(:,6),  & 
G1H16(56),G1H16(58),G1H16(59),G1H16(60),G1H16(61),G1H16(62),16)
  call HG1shiftOLR(G1H16(58),32,16)
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(24),mass5set(:,7),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),G1H8(6),8)
  call HG1shiftOLR(G1H8(2),32,8)
  call Hotf_5pt_reduction(G2H16(2),RedSet_5(25),mass5set(:,7),  & 
G1H16(64),G1H16(65),G1H16(66),G1H16(1),G1H16(4),G1H16(5),16)
  call HG1shiftOLR(G1H16(65),32,16)
  call Hotf_5pt_reduction(G2H16(3),RedSet_5(26),mass5set(:,6),  & 
G1H16(6),G1H16(7),G1H16(8),G1H16(10),G1H16(11),G1H16(12),16)
  call HG1shiftOLR(G1H16(7),16,16)
  call Hotf_5pt_reduction(G2H8(2),RedSet_5(24),mass5set(:,7),  & 
G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),G1H8(12),8)
  call HG1shiftOLR(G1H8(8),16,8)
  call Hotf_5pt_reduction(G2H16(4),RedSet_5(27),mass5set(:,6),  & 
G1H16(14),G1H16(16),G1H16(17),G1H16(18),G1H16(19),G1H16(20),16)
  call HG1shiftOLR(G1H16(16),32,16)
  call Hotf_5pt_reduction(G2H16(5),RedSet_5(28),mass5set(:,6),  & 
G1H16(22),G1H16(23),G1H16(24),G1H16(25),G1H16(26),G1H16(67),16)
  call HG1shiftOLR(G1H16(23),16,16)
  call Hotf_5pt_reduction(G2H16(6),RedSet_5(29),mass5set(:,6),  & 
G1H16(68),G1H16(70),G1H16(71),G1H16(72),G1H16(28),G1H16(30),16)
  call HG1shiftOLR(G1H16(70),16,16)
  call Hotf_5pt_reduction(G2H16(7),RedSet_5(29),mass5set(:,6),  & 
G1H16(31),G1H16(32),G1H16(34),G1H16(35),G1H16(36),G1H16(37),16)
  call HG1shiftOLR(G1H16(32),32,16)
  call Hotf_5pt_reduction(G2H8(3),RedSet_5(30),mass5set(:,7),  & 
G1H8(13),G1H8(14),G1H8(15),G1H8(16),G1H8(17),G1H8(18),8)
  call HG1shiftOLR(G1H8(14),32,8)
  call Hotf_5pt_reduction(G2H16(8),RedSet_5(31),mass5set(:,7),  & 
G1H16(38),G1H16(41),G1H16(42),G1H16(43),G1H16(44),G1H16(46),16)
  call HG1shiftOLR(G1H16(41),32,16)
  call Hotf_5pt_reduction(G2H8(4),RedSet_5(30),mass5set(:,7),  & 
G1H8(19),G1H8(20),G1H8(21),G1H8(22),G1H8(23),G1H8(24),8)
  call HG1shiftOLR(G1H8(20),16,8)
  call Hotf_5pt_reduction(G2H16(9),RedSet_5(32),mass5set(:,6),  & 
G1H16(47),G1H16(48),G1H16(49),G1H16(50),G1H16(52),G1H16(53),16)
  call HG1shiftOLR(G1H16(48),16,16)
  call Hotf_5pt_reduction(G2H16(10),RedSet_5(32),mass5set(:,6),  & 
G1H16(73),G1H16(74),G1H16(75),G1H16(76),G1H16(77),G1H16(78),16)
  call HG1shiftOLR(G1H16(74),32,16)
  call Hotf_5pt_reduction(G2H8(5),RedSet_5(33),mass5set(:,8),  & 
G1H8(25),G1H8(26),G1H8(27),G1H8(28),G1H8(29),G1H8(30),8)
  call HG1shiftOLR(G1H8(26),32,8)
  call Hotf_5pt_reduction(G2H8(6),RedSet_5(34),mass5set(:,8),  & 
G1H8(31),G1H8(32),G1H8(33),G1H8(34),G1H8(35),G1H8(36),8)
  call HG1shiftOLR(G1H8(32),16,8)
  call Hotf_5pt_reduction(G2H16(11),RedSet_5(35),mass5set(:,9),  & 
G1H16(79),G1H16(80),G1H16(81),G1H16(82),G1H16(83),G1H16(84),16)
  call HG1shiftOLR(G1H16(80),32,16)
  call Hotf_5pt_reduction(G2H8(7),RedSet_5(34),mass5set(:,8),  & 
G1H8(37),G1H8(38),G1H8(39),G1H8(40),G1H8(41),G1H8(42),8)
  call HG1shiftOLR(G1H8(38),4,8)
  call Hotf_5pt_reduction(G2H8(8),RedSet_5(36),mass5set(:,8),  & 
G1H8(43),G1H8(44),G1H8(45),G1H8(46),G1H8(47),G1H8(48),8)
  call HG1shiftOLR(G1H8(44),32,8)
  call Hotf_5pt_reduction(G2H16(12),RedSet_5(37),mass5set(:,9),  & 
G1H16(85),G1H16(86),G1H16(87),G1H16(88),G1H16(89),G1H16(90),16)
  call HG1shiftOLR(G1H16(86),32,16)
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(36),mass5set(:,8),  & 
G1H8(49),G1H8(50),G1H8(51),G1H8(52),G1H8(53),G1H8(54),8)
  call HG1shiftOLR(G1H8(50),8,8)
  call Hotf_5pt_reduction(G2H8(10),RedSet_5(33),mass5set(:,8),  & 
G1H8(55),G1H8(56),G1H8(57),G1H8(58),G1H8(59),G1H8(60),8)
  call HG1shiftOLR(G1H8(56),4,8)
  call Hotf_5pt_reduction(G2H16(13),RedSet_5(38),mass5set(:,9),  & 
G1H16(91),G1H16(92),G1H16(93),G1H16(94),G1H16(95),G1H16(96),16)
  call HG1shiftOLR(G1H16(92),16,16)
  call Hotf_5pt_reduction(G2H8(11),RedSet_5(39),mass5set(:,8),  & 
G1H8(61),G1H8(62),G1H8(63),G1H8(64),G1H8(65),G1H8(66),8)
  call HG1shiftOLR(G1H8(62),16,8)
  call Hotf_5pt_reduction(G2H8(12),RedSet_5(39),mass5set(:,8),  & 
G1H8(67),G1H8(68),G1H8(69),G1H8(70),G1H8(71),G1H8(72),8)
  call HG1shiftOLR(G1H8(68),8,8)
  call Hotf_5pt_reduction(G2H16(14),RedSet_5(40),mass5set(:,9),  & 
G1H16(97),G1H16(98),G1H16(99),G1H16(100),G1H16(101),G1H16(102),16)
  call HG1shiftOLR(G1H16(98),16,16)
  call Hloop_QA_V(ntryL,G2H8(13),ex4(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_QA_V(ntryL,G2H8(16),ex4(:),G2H4(2),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_QA_V(ntryL,G2H8(17),ex4(:),G2H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_AQ_V(ntryL,G2H8(18),ex3(:),G2H4(4),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_AQ_V(ntryL,G2H8(21),ex3(:),G2H4(5),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_AQ_V(ntryL,G2H8(22),ex3(:),G2H4(6),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hotf_5pt_reduction(G2H8(23),RedSet_5(3),mass5set(:,2),  & 
G1H8(73),G1H8(74),G1H8(75),G1H8(76),G1H8(77),G1H8(78),8)
  call HG1shiftOLR(G1H8(74),8,8)
  call Hotf_5pt_reduction(G2H8(26),RedSet_5(41),mass5set(:,1),  & 
G1H8(79),G1H8(80),G1H8(81),G1H8(82),G1H8(83),G1H8(84),8)
  call HG1shiftOLR(G1H8(80),8,8)
  call Hotf_5pt_reduction(G2H8(27),RedSet_5(42),mass5set(:,1),  & 
G1H8(85),G1H8(86),G1H8(87),G1H8(88),G1H8(89),G1H8(90),8)
  call HG1shiftOLR(G1H8(86),8,8)
  call Hloop_AQ_V(ntryL,G2H8(28),ex3(:),G2H4(7),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_AQ_V(ntryL,G2H8(31),ex3(:),G2H4(8),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_AQ_V(ntryL,G2H8(32),ex3(:),G2H4(9),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_QA_V(ntryL,G2H8(33),ex4(:),G2H4(10),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_QA_V(ntryL,G2H8(36),ex4(:),G2H4(11),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_QA_V(ntryL,G2H8(37),ex4(:),G2H4(12),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hotf_5pt_reduction(G2H8(38),RedSet_5(6),mass5set(:,2),  & 
G1H8(91),G1H8(92),G1H8(93),G1H8(94),G1H8(95),G1H8(96),8)
  call HG1shiftOLR(G1H8(92),8,8)
  call Hotf_5pt_reduction(G2H8(41),RedSet_5(41),mass5set(:,1),  & 
G1H8(97),G1H8(98),G1H8(99),G1H8(100),G1H8(101),G1H8(102),8)
  call HG1shiftOLR(G1H8(98),8,8)
  call Hotf_5pt_reduction(G2H8(42),RedSet_5(43),mass5set(:,1),  & 
G1H8(103),G1H8(104),G1H8(105),G1H8(106),G1H8(107),G1H8(108),8)
  call HG1shiftOLR(G1H8(104),8,8)
  call Hloop_QA_V(ntryL,G2H8(43),ex4(:),G2H4(13),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_QA_V(ntryL,G2H8(45),ex4(:),G2H4(14),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_QA_V(ntryL,G2H8(46),ex4(:),G2H4(15),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hotf_5pt_reduction(G2H8(47),RedSet_5(3),mass5set(:,2),  & 
G1H8(109),G1H8(110),G1H8(111),G1H8(112),G1H8(113),G1H8(114),8)
  call HG1shiftOLR(G1H8(110),4,8)
  call Hotf_5pt_reduction(G2H8(50),RedSet_5(44),mass5set(:,1),  & 
G1H8(115),G1H8(116),G1H8(117),G1H8(118),G1H8(119),G1H8(120),8)
  call HG1shiftOLR(G1H8(116),4,8)
  call Hotf_5pt_reduction(G2H8(51),RedSet_5(45),mass5set(:,1),  & 
G1H8(121),G1H8(122),G1H8(123),G1H8(124),G1H8(125),G1H8(126),8)
  call HG1shiftOLR(G1H8(122),4,8)
  call Hotf_5pt_reduction(G2H8(52),RedSet_5(6),mass5set(:,2),  & 
G1H8(127),G1H8(128),G1H8(129),G1H8(130),G1H8(131),G1H8(132),8)
  call HG1shiftOLR(G1H8(128),4,8)
  call Hotf_5pt_reduction(G2H8(55),RedSet_5(44),mass5set(:,1),  & 
G1H8(133),G1H8(134),G1H8(135),G1H8(136),G1H8(137),G1H8(138),8)
  call HG1shiftOLR(G1H8(134),4,8)
  call Hotf_5pt_reduction(G2H8(56),RedSet_5(46),mass5set(:,1),  & 
G1H8(139),G1H8(140),G1H8(141),G1H8(142),G1H8(143),G1H8(144),8)
  call HG1shiftOLR(G1H8(140),4,8)
  call Hloop_AQ_V(ntryL,G2H8(57),ex3(:),G2H4(16),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_AQ_V(ntryL,G2H8(59),ex3(:),G2H4(17),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_AQ_V(ntryL,G2H8(60),ex3(:),G2H4(18),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_AQ_V(ntryL,G2H8(61),ex3(:),G2H4(19),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_AQ_V(ntryL,G2H8(64),ex3(:),G2H4(20),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_AQ_V(ntryL,G2H8(65),ex3(:),G2H4(21),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_AQ_V(ntryL,G2H8(66),ex3(:),G2H4(22),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_AQ_V(ntryL,G2H8(69),ex3(:),G2H4(23),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_AQ_V(ntryL,G2H8(70),ex3(:),G2H4(24),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hotf_5pt_reduction(G2H8(71),RedSet_5(9),mass5set(:,3),  & 
G1H8(145),G1H8(146),G1H8(147),G1H8(148),G1H8(149),G1H8(150),8)
  call HG1shiftOLR(G1H8(146),16,8)
  call Hotf_5pt_reduction(G2H8(73),RedSet_5(47),mass5set(:,5),  & 
G1H8(151),G1H8(152),G1H8(153),G1H8(154),G1H8(155),G1H8(156),8)
  call HG1shiftOLR(G1H8(152),16,8)
  call Hotf_5pt_reduction(G2H8(74),RedSet_5(48),mass5set(:,5),  & 
G1H8(157),G1H8(158),G1H8(159),G1H8(160),G1H8(161),G1H8(162),8)
  call HG1shiftOLR(G1H8(158),16,8)
  call Hotf_5pt_reduction(G2H8(75),RedSet_5(10),mass5set(:,3),  & 
G1H8(163),G1H8(164),G1H8(165),G1H8(166),G1H8(167),G1H8(168),8)
  call HG1shiftOLR(G1H8(164),32,8)
  call Hotf_5pt_reduction(G2H8(77),RedSet_5(49),mass5set(:,5),  & 
G1H8(169),G1H8(170),G1H8(171),G1H8(172),G1H8(173),G1H8(174),8)
  call HG1shiftOLR(G1H8(170),32,8)
  call Hotf_5pt_reduction(G2H8(78),RedSet_5(50),mass5set(:,5),  & 
G1H8(175),G1H8(176),G1H8(177),G1H8(178),G1H8(179),G1H8(180),8)
  call HG1shiftOLR(G1H8(176),32,8)
  call Hloop_QA_V(ntryL,G2H8(79),ex4(:),G2H4(25),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_QA_V(ntryL,G2H8(82),ex4(:),G2H4(26),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_QA_V(ntryL,G2H8(83),ex4(:),G2H4(27),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hotf_5pt_reduction(G2H16(20),RedSet_5(11),mass5set(:,3),  & 
G1H16(103),G1H16(104),G1H16(105),G1H16(106),G1H16(107),G1H16(108),16)
  call HG1shiftOLR(G1H16(104),8,16)
  call Hotf_5pt_reduction(G2H16(23),RedSet_5(51),mass5set(:,3),  & 
G1H16(109),G1H16(110),G1H16(111),G1H16(112),G1H16(113),G1H16(114),16)
  call HG1shiftOLR(G1H16(110),8,16)
  call Hotf_5pt_reduction(G2H16(15),RedSet_5(52),mass5set(:,3),  & 
G1H16(115),G1H16(116),G1H16(117),G1H16(118),G1H16(119),G1H16(120),16)
  call HG1shiftOLR(G1H16(116),8,16)
  call Hotf_5pt_reduction(G2H16(16),RedSet_5(11),mass5set(:,3),  & 
G1H16(121),G1H16(122),G1H16(123),G1H16(124),G1H16(125),G1H16(126),16)
  call HG1shiftOLR(G1H16(122),32,16)
  call Hotf_5pt_reduction(G2H16(26),RedSet_5(53),mass5set(:,5),  & 
G1H16(127),G1H16(128),G1H16(129),G1H16(130),G1H16(131),G1H16(132),16)
  call HG1shiftOLR(G1H16(128),32,16)
  call Hotf_5pt_reduction(G2H16(27),RedSet_5(54),mass5set(:,5),  & 
G1H16(133),G1H16(134),G1H16(135),G1H16(136),G1H16(137),G1H16(138),16)
  call HG1shiftOLR(G1H16(134),32,16)
  call Hotf_5pt_reduction(G2H16(28),RedSet_5(12),mass5set(:,3),  & 
G1H16(139),G1H16(140),G1H16(141),G1H16(142),G1H16(143),G1H16(144),16)
  call HG1shiftOLR(G1H16(140),8,16)
  call Hotf_5pt_reduction(G2H16(30),RedSet_5(55),mass5set(:,3),  & 
G1H16(145),G1H16(146),G1H16(147),G1H16(148),G1H16(149),G1H16(150),16)
  call HG1shiftOLR(G1H16(146),8,16)
  call Hotf_5pt_reduction(G2H16(31),RedSet_5(52),mass5set(:,3),  & 
G1H16(151),G1H16(152),G1H16(153),G1H16(154),G1H16(155),G1H16(156),16)
  call HG1shiftOLR(G1H16(152),8,16)
  call Hotf_5pt_reduction(G2H16(32),RedSet_5(13),mass5set(:,3),  & 
G1H16(157),G1H16(158),G1H16(159),G1H16(160),G1H16(161),G1H16(162),16)
  call HG1shiftOLR(G1H16(158),16,16)
  call Hotf_5pt_reduction(G2H16(35),RedSet_5(47),mass5set(:,5),  & 
G1H16(163),G1H16(164),G1H16(165),G1H16(166),G1H16(167),G1H16(168),16)
  call HG1shiftOLR(G1H16(164),16,16)
  call Hotf_5pt_reduction(G2H16(36),RedSet_5(56),mass5set(:,5),  & 
G1H16(169),G1H16(170),G1H16(171),G1H16(172),G1H16(173),G1H16(174),16)
  call HG1shiftOLR(G1H16(170),16,16)
  call Hotf_5pt_reduction(G2H16(37),RedSet_5(14),mass5set(:,4),  & 
G1H16(175),G1H16(176),G1H16(177),G1H16(178),G1H16(179),G1H16(180),16)
  call HG1shiftOLR(G1H16(176),32,16)
  call Hotf_5pt_reduction(G2H16(40),RedSet_5(57),mass5set(:,10),  & 
G1H16(181),G1H16(182),G1H16(183),G1H16(184),G1H16(185),G1H16(186),16)
  call HG1shiftOLR(G1H16(182),32,16)
  call Hotf_5pt_reduction(G2H16(41),RedSet_5(58),mass5set(:,10),  & 
G1H16(187),G1H16(188),G1H16(189),G1H16(190),G1H16(191),G1H16(192),16)
  call HG1shiftOLR(G1H16(188),32,16)
  call Hloop_AQ_V(ntryL,G2H8(84),ex3(:),G2H4(28),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_AQ_V(ntryL,G2H8(86),ex3(:),G2H4(29),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_AQ_V(ntryL,G2H8(87),ex3(:),G2H4(30),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_QA_V(ntryL,G2H8(88),ex4(:),G2H4(31),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_QA_V(ntryL,G2H8(91),ex4(:),G2H4(32),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_QA_V(ntryL,G2H8(92),ex4(:),G2H4(33),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hotf_5pt_reduction(G2H16(43),RedSet_5(16),mass5set(:,3),  & 
G1H16(193),G1H16(194),G1H16(195),G1H16(196),G1H16(197),G1H16(198),16)
  call HG1shiftOLR(G1H16(194),8,16)
  call Hotf_5pt_reduction(G2H16(45),RedSet_5(59),mass5set(:,3),  & 
G1H16(199),G1H16(200),G1H16(201),G1H16(202),G1H16(203),G1H16(204),16)
  call HG1shiftOLR(G1H16(200),8,16)
  call Hotf_5pt_reduction(G2H16(46),RedSet_5(60),mass5set(:,3),  & 
G1H16(205),G1H16(206),G1H16(207),G1H16(208),G1H16(209),G1H16(210),16)
  call HG1shiftOLR(G1H16(206),8,16)
  call Hotf_5pt_reduction(G2H16(47),RedSet_5(16),mass5set(:,3),  & 
G1H16(211),G1H16(212),G1H16(213),G1H16(214),G1H16(215),G1H16(216),16)
  call HG1shiftOLR(G1H16(212),16,16)
  call Hotf_5pt_reduction(G2H16(50),RedSet_5(61),mass5set(:,5),  & 
G1H16(217),G1H16(218),G1H16(219),G1H16(220),G1H16(221),G1H16(222),16)
  call HG1shiftOLR(G1H16(218),16,16)
  call Hotf_5pt_reduction(G2H16(51),RedSet_5(62),mass5set(:,5),  & 
G1H16(223),G1H16(224),G1H16(225),G1H16(226),G1H16(227),G1H16(228),16)
  call HG1shiftOLR(G1H16(224),16,16)
  call Hotf_5pt_reduction(G2H16(52),RedSet_5(17),mass5set(:,3),  & 
G1H16(229),G1H16(230),G1H16(231),G1H16(232),G1H16(233),G1H16(234),16)
  call HG1shiftOLR(G1H16(230),8,16)
  call Hotf_5pt_reduction(G2H16(54),RedSet_5(55),mass5set(:,3),  & 
G1H16(235),G1H16(236),G1H16(237),G1H16(238),G1H16(239),G1H16(240),16)
  call HG1shiftOLR(G1H16(236),8,16)
  call Hotf_5pt_reduction(G2H16(55),RedSet_5(60),mass5set(:,3),  & 
G1H16(241),G1H16(242),G1H16(243),G1H16(244),G1H16(245),G1H16(246),16)
  call HG1shiftOLR(G1H16(242),8,16)
  call Hotf_5pt_reduction(G2H16(56),RedSet_5(18),mass5set(:,3),  & 
G1H16(247),G1H16(248),G1H16(249),G1H16(250),G1H16(251),G1H16(252),16)
  call HG1shiftOLR(G1H16(248),32,16)
  call Hotf_5pt_reduction(G2H16(59),RedSet_5(49),mass5set(:,5),  & 
G1H16(253),G1H16(254),G1H16(255),G1H16(256),G1H16(257),G1H16(258),16)
  call HG1shiftOLR(G1H16(254),32,16)
  call Hotf_5pt_reduction(G2H16(60),RedSet_5(63),mass5set(:,5),  & 
G1H16(259),G1H16(260),G1H16(261),G1H16(262),G1H16(263),G1H16(264),16)
  call HG1shiftOLR(G1H16(260),32,16)
  call Hotf_5pt_reduction(G2H16(61),RedSet_5(19),mass5set(:,4),  & 
G1H16(265),G1H16(266),G1H16(267),G1H16(268),G1H16(269),G1H16(270),16)
  call HG1shiftOLR(G1H16(266),32,16)
  call Hotf_5pt_reduction(G2H16(64),RedSet_5(64),mass5set(:,10),  & 
G1H16(271),G1H16(272),G1H16(273),G1H16(274),G1H16(275),G1H16(276),16)
  call HG1shiftOLR(G1H16(272),32,16)
  call Hotf_5pt_reduction(G2H16(65),RedSet_5(65),mass5set(:,10),  & 
G1H16(277),G1H16(278),G1H16(279),G1H16(280),G1H16(281),G1H16(282),16)
  call HG1shiftOLR(G1H16(278),32,16)
  call Hloop_AQ_V(ntryL,G2H8(93),ex3(:),G2H4(34),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_AQ_V(ntryL,G2H8(95),ex3(:),G2H4(35),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_AQ_V(ntryL,G2H8(96),ex3(:),G2H4(36),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hotf_5pt_reduction(G2H8(97),RedSet_5(20),mass5set(:,3),  & 
G1H8(181),G1H8(182),G1H8(183),G1H8(184),G1H8(185),G1H8(186),8)
  call HG1shiftOLR(G1H8(182),16,8)
  call Hotf_5pt_reduction(G2H8(99),RedSet_5(61),mass5set(:,5),  & 
G1H8(187),G1H8(188),G1H8(189),G1H8(190),G1H8(191),G1H8(192),8)
  call HG1shiftOLR(G1H8(188),16,8)
  call Hotf_5pt_reduction(G2H8(100),RedSet_5(66),mass5set(:,5),  & 
G1H8(193),G1H8(194),G1H8(195),G1H8(196),G1H8(197),G1H8(198),8)
  call HG1shiftOLR(G1H8(194),16,8)
  call Hotf_5pt_reduction(G2H8(101),RedSet_5(21),mass5set(:,3),  & 
G1H8(199),G1H8(200),G1H8(201),G1H8(202),G1H8(203),G1H8(204),8)
  call HG1shiftOLR(G1H8(200),32,8)
  call Hotf_5pt_reduction(G2H8(103),RedSet_5(53),mass5set(:,5),  & 
G1H8(205),G1H8(206),G1H8(207),G1H8(208),G1H8(209),G1H8(210),8)
  call HG1shiftOLR(G1H8(206),32,8)
  call Hotf_5pt_reduction(G2H8(104),RedSet_5(67),mass5set(:,5),  & 
G1H8(211),G1H8(212),G1H8(213),G1H8(214),G1H8(215),G1H8(216),8)
  call HG1shiftOLR(G1H8(212),32,8)
  call Hotf_5pt_reduction(G2H8(105),RedSet_5(20),mass5set(:,3),  & 
G1H8(217),G1H8(218),G1H8(219),G1H8(220),G1H8(221),G1H8(222),8)
  call HG1shiftOLR(G1H8(218),8,8)
  call Hotf_5pt_reduction(G2H8(107),RedSet_5(59),mass5set(:,3),  & 
G1H8(223),G1H8(224),G1H8(225),G1H8(226),G1H8(227),G1H8(228),8)
  call HG1shiftOLR(G1H8(224),8,8)
  call Hotf_5pt_reduction(G2H8(108),RedSet_5(68),mass5set(:,3),  & 
G1H8(229),G1H8(230),G1H8(231),G1H8(232),G1H8(233),G1H8(234),8)
  call HG1shiftOLR(G1H8(230),8,8)
  call Hloop_QA_V(ntryL,G2H8(109),ex4(:),G2H4(37),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_QA_V(ntryL,G2H8(111),ex4(:),G2H4(38),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_QA_V(ntryL,G2H8(112),ex4(:),G2H4(39),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hotf_5pt_reduction(G2H8(113),RedSet_5(21),mass5set(:,3),  & 
G1H8(235),G1H8(236),G1H8(237),G1H8(238),G1H8(239),G1H8(240),8)
  call HG1shiftOLR(G1H8(236),8,8)
  call Hotf_5pt_reduction(G2H8(115),RedSet_5(51),mass5set(:,3),  & 
G1H8(241),G1H8(242),G1H8(243),G1H8(244),G1H8(245),G1H8(246),8)
  call HG1shiftOLR(G1H8(242),8,8)
  call Hotf_5pt_reduction(G2H8(116),RedSet_5(68),mass5set(:,3),  & 
G1H8(247),G1H8(248),G1H8(249),G1H8(250),G1H8(251),G1H8(252),8)
  call HG1shiftOLR(G1H8(248),8,8)
  call Hloop_QA_V(ntryL,G2H8(117),ex4(:),G2H4(40),m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_QA_V(ntryL,G2H8(119),ex4(:),G2H4(41),m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_QA_V(ntryL,G2H8(120),ex4(:),G2H4(42),m3h2x4(:,42),heltab2x8(:,:,42))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(79),[G1H8(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(85),[G1H8(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(97),[G1H8(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(103),[G1H8(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(115),[G1H8(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(121),[G1H8(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(133),[G1H8(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(139),[G1H8(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(151),[G1H8(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(157),[G1H8(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(169),[G1H8(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(175),[G1H8(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(109),[G1H16(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(115),[G1H16(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(127),[G1H16(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(133),[G1H16(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(145),[G1H16(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(151),[G1H16(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(163),[G1H16(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(169),[G1H16(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(181),[G1H16(179)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(187),[G1H16(180)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(199),[G1H16(197)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(205),[G1H16(198)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(217),[G1H16(215)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(223),[G1H16(216)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(235),[G1H16(233)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(241),[G1H16(234)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(253),[G1H16(251)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(259),[G1H16(252)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(271),[G1H16(269)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(277),[G1H16(270)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(187),[G1H8(185)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(193),[G1H8(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(205),[G1H8(203)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(211),[G1H8(204)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(223),[G1H8(221)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(229),[G1H8(222)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(241),[G1H8(239)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(247),[G1H8(240)])
  call Hloop_QV_A(ntryL,G1H16(56),ex5(:),G1H8(77),m3h2x8(:,73),heltab2x16(:,:,73))
  call Hloop_Q_A(ntryL,G1H8(77),92,nMT,G2H8(1),n2h8(97))
call HGT_OLR(G1H16(58),1,1,16)
call HGT_invQ_OLR(G1H16(58),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(58),-32,nMT,G2H16(1),n2h16(85))
  call Hloop_AV_Q(ntryL,G2H16(1),ex6(:),G2H8(2),m3h2x8(:,74),heltab2x16(:,:,74))
  call Hloop_QV_A(ntryL,G1H16(61),ex5(:),G1H8(78),m3h2x8(:,75),heltab2x16(:,:,75))
  call Hloop_Q_A(ntryL,G1H8(78),92,nMT,G2H8(3),n2h8(98))
  call Hloop_QV_A(ntryL,G1H16(62),ex5(:),G1H8(95),m3h2x8(:,76),heltab2x16(:,:,76))
  call Hloop_Q_A(ntryL,G1H8(95),92,nMT,G2H8(4),n2h8(99))
  call Hloop_VQ_A(ntryL,G1H8(1),ex3(:),G1H4(1),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMT,G2H4(43),n2h4(1))
call HGT_OLR(G1H8(2),1,1,8)
call HGT_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(2),-32,nMT,G2H8(5),n2h8(100))
  call Hloop_AV_Q(ntryL,G2H8(5),ex6(:),G2H4(44),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_VQ_A(ntryL,G1H8(5),ex3(:),G1H4(1),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMT,G2H4(45),n2h4(2))
  call Hloop_VQ_A(ntryL,G1H8(6),ex3(:),G1H4(1),m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMT,G2H4(46),n2h4(3))
  call Hloop_VA_Q(ntryL,G1H16(64),ex4(:),G1H8(96),m3h2x8(:,77),heltab2x16(:,:,77))
  call Hloop_A_Q(ntryL,G1H8(96),92,nMT,G2H8(6),n2h8(101))
call HGT_OLR(G1H16(65),1,1,16)
call HGT_invQ_OLR(G1H16(65),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(65),-32,nMT,G2H16(2),n2h16(86))
  call Hloop_QV_A(ntryL,G2H16(2),ex6(:),G2H8(7),m3h2x8(:,78),heltab2x16(:,:,78))
  call Hloop_VA_Q(ntryL,G1H16(4),ex4(:),G1H8(113),m3h2x8(:,79),heltab2x16(:,:,79))
  call Hloop_A_Q(ntryL,G1H8(113),92,nMT,G2H8(8),n2h8(102))
  call Hloop_VA_Q(ntryL,G1H16(5),ex4(:),G1H8(114),m3h2x8(:,80),heltab2x16(:,:,80))
  call Hloop_A_Q(ntryL,G1H8(114),92,nMT,G2H8(9),n2h8(103))
  call Hloop_QV_A(ntryL,G1H16(6),ex6(:),G1H8(131),m3h2x8(:,81),heltab2x16(:,:,81))
  call Hloop_Q_A(ntryL,G1H8(131),108,nMT,G2H8(10),n2h8(104))
call HGT_OLR(G1H16(7),1,1,16)
call HGT_invQ_OLR(G1H16(7),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(7),-16,nMT,G2H16(3),n2h16(87))
  call Hloop_AV_Q(ntryL,G2H16(3),ex5(:),G2H8(11),m3h2x8(:,82),heltab2x16(:,:,82))
  call Hloop_QV_A(ntryL,G1H16(11),ex6(:),G1H8(132),m3h2x8(:,83),heltab2x16(:,:,83))
  call Hloop_Q_A(ntryL,G1H8(132),108,nMT,G2H8(12),n2h8(105))
  call Hloop_QV_A(ntryL,G1H16(12),ex6(:),G1H8(149),m3h2x8(:,84),heltab2x16(:,:,84))
  call Hloop_Q_A(ntryL,G1H8(149),108,nMT,G2H8(13),n2h8(106))
  call Hloop_VQ_A(ntryL,G1H8(7),ex3(:),G1H4(1),m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMT,G2H4(47),n2h4(4))
call HGT_OLR(G1H8(8),1,1,8)
call HGT_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(8),-16,nMT,G2H8(16),n2h8(107))
  call Hloop_AV_Q(ntryL,G2H8(16),ex5(:),G2H4(48),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_VQ_A(ntryL,G1H8(11),ex3(:),G1H4(1),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMT,G2H4(49),n2h4(5))
  call Hloop_VQ_A(ntryL,G1H8(12),ex3(:),G1H4(1),m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMT,G2H4(50),n2h4(6))
  call Hloop_AV_Q(ntryL,G1H16(14),ex5(:),G1H8(150),m3h2x8(:,85),heltab2x16(:,:,85))
  call Hloop_A_Q(ntryL,G1H8(150),92,nMT,G2H8(17),n2h8(108))
call HGT_OLR(G1H16(16),1,1,16)
call HGT_invQ_OLR(G1H16(16),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(16),-32,nMT,G2H16(4),n2h16(88))
  call Hloop_QV_A(ntryL,G2H16(4),ex6(:),G2H8(18),m3h2x8(:,86),heltab2x16(:,:,86))
  call Hloop_AV_Q(ntryL,G1H16(19),ex5(:),G1H8(167),m3h2x8(:,87),heltab2x16(:,:,87))
  call Hloop_A_Q(ntryL,G1H8(167),92,nMT,G2H8(21),n2h8(109))
  call Hloop_AV_Q(ntryL,G1H16(20),ex5(:),G1H8(168),m3h2x8(:,88),heltab2x16(:,:,88))
  call Hloop_A_Q(ntryL,G1H8(168),92,nMT,G2H8(22),n2h8(110))
  call Hloop_AV_Q(ntryL,G1H16(22),ex6(:),G1H8(185),m3h2x8(:,89),heltab2x16(:,:,89))
  call Hloop_A_Q(ntryL,G1H8(185),108,nMT,G2H8(23),n2h8(111))
call HGT_OLR(G1H16(23),1,1,16)
call HGT_invQ_OLR(G1H16(23),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(23),-16,nMT,G2H16(5),n2h16(89))
  call Hloop_QV_A(ntryL,G2H16(5),ex5(:),G2H8(26),m3h2x8(:,90),heltab2x16(:,:,90))
  call Hloop_AV_Q(ntryL,G1H16(26),ex6(:),G1H8(186),m3h2x8(:,91),heltab2x16(:,:,91))
  call Hloop_A_Q(ntryL,G1H8(186),108,nMT,G2H8(27),n2h8(112))
  call Hloop_AV_Q(ntryL,G1H16(67),ex6(:),G1H8(203),m3h2x8(:,92),heltab2x16(:,:,92))
  call Hloop_A_Q(ntryL,G1H8(203),108,nMT,G2H8(28),n2h8(113))
  call Hloop_AZ_Q(ntryL,G1H16(68),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,1),heltab2x16(:,:,93))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMT,G2H4(51),n2h4(7))
call HGT_OLR(G1H16(70),1,1,16)
call HGT_invQ_OLR(G1H16(70),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(70),-16,nMT,G2H16(6),n2h16(90))
  call Hloop_QV_A(ntryL,G2H16(6),ex5(:),G2H8(31),m3h2x8(:,93),heltab2x16(:,:,94))
  call Hloop_AZ_Q(ntryL,G1H16(28),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,2),heltab2x16(:,:,95))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMT,G2H4(52),n2h4(8))
  call Hloop_AZ_Q(ntryL,G1H16(30),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,3),heltab2x16(:,:,96))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMT,G2H4(53),n2h4(9))
  call Hloop_AZ_Q(ntryL,G1H16(31),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,4),heltab2x16(:,:,97))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMT,G2H4(54),n2h4(10))
call HGT_OLR(G1H16(32),1,1,16)
call HGT_invQ_OLR(G1H16(32),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(32),-32,nMT,G2H16(7),n2h16(91))
  call Hloop_QV_A(ntryL,G2H16(7),ex6(:),G2H8(32),m3h2x8(:,94),heltab2x16(:,:,98))
  call Hloop_AZ_Q(ntryL,G1H16(36),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,5),heltab2x16(:,:,99))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMT,G2H4(55),n2h4(11))
  call Hloop_AZ_Q(ntryL,G1H16(37),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,6),heltab2x16(:,:,100))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMT,G2H4(56),n2h4(12))
  call Hloop_VA_Q(ntryL,G1H8(13),ex4(:),G1H4(1),m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMT,G2H4(57),n2h4(13))
call HGT_OLR(G1H8(14),1,1,8)
call HGT_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(14),-32,nMT,G2H8(33),n2h8(114))
  call Hloop_QV_A(ntryL,G2H8(33),ex6(:),G2H4(58),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_VA_Q(ntryL,G1H8(17),ex4(:),G1H4(1),m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMT,G2H4(59),n2h4(14))
  call Hloop_VA_Q(ntryL,G1H8(18),ex4(:),G1H4(1),m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMT,G2H4(60),n2h4(15))
  call Hloop_VQ_A(ntryL,G1H16(38),ex3(:),G1H8(204),m3h2x8(:,95),heltab2x16(:,:,101))
  call Hloop_Q_A(ntryL,G1H8(204),92,nMT,G2H8(36),n2h8(115))
call HGT_OLR(G1H16(41),1,1,16)
call HGT_invQ_OLR(G1H16(41),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(41),-32,nMT,G2H16(8),n2h16(92))
  call Hloop_AV_Q(ntryL,G2H16(8),ex6(:),G2H8(37),m3h2x8(:,96),heltab2x16(:,:,102))
  call Hloop_VQ_A(ntryL,G1H16(44),ex3(:),G1H8(221),m3h2x8(:,97),heltab2x16(:,:,103))
  call Hloop_Q_A(ntryL,G1H8(221),92,nMT,G2H8(38),n2h8(116))
  call Hloop_VQ_A(ntryL,G1H16(46),ex3(:),G1H8(222),m3h2x8(:,98),heltab2x16(:,:,104))
  call Hloop_Q_A(ntryL,G1H8(222),92,nMT,G2H8(41),n2h8(117))
  call Hloop_VA_Q(ntryL,G1H8(19),ex4(:),G1H4(1),m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMT,G2H4(61),n2h4(16))
call HGT_OLR(G1H8(20),1,1,8)
call HGT_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(20),-16,nMT,G2H8(42),n2h8(118))
  call Hloop_QV_A(ntryL,G2H8(42),ex5(:),G2H4(62),m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_VA_Q(ntryL,G1H8(23),ex4(:),G1H4(1),m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMT,G2H4(63),n2h4(17))
  call Hloop_VA_Q(ntryL,G1H8(24),ex4(:),G1H4(1),m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMT,G2H4(64),n2h4(18))
  call Hloop_QZ_A(ntryL,G1H16(47),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,7),heltab2x16(:,:,105))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMT,G2H4(65),n2h4(19))
call HGT_OLR(G1H16(48),1,1,16)
call HGT_invQ_OLR(G1H16(48),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(48),-16,nMT,G2H16(9),n2h16(93))
  call Hloop_AV_Q(ntryL,G2H16(9),ex5(:),G2H8(43),m3h2x8(:,99),heltab2x16(:,:,106))
  call Hloop_QZ_A(ntryL,G1H16(52),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,8),heltab2x16(:,:,107))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMT,G2H4(66),n2h4(20))
  call Hloop_QZ_A(ntryL,G1H16(53),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,9),heltab2x16(:,:,108))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMT,G2H4(67),n2h4(21))
  call Hloop_QZ_A(ntryL,G1H16(73),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,10),heltab2x16(:,:,109))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMT,G2H4(68),n2h4(22))
call HGT_OLR(G1H16(74),1,1,16)
call HGT_invQ_OLR(G1H16(74),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(74),-32,nMT,G2H16(10),n2h16(94))
  call Hloop_AV_Q(ntryL,G2H16(10),ex6(:),G2H8(45),m3h2x8(:,100),heltab2x16(:,:,110))
  call Hloop_QZ_A(ntryL,G1H16(77),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,11),heltab2x16(:,:,111))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMT,G2H4(69),n2h4(23))
  call Hloop_QZ_A(ntryL,G1H16(78),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,12),heltab2x16(:,:,112))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMT,G2H4(70),n2h4(24))
  call Hloop_UV_W(ntryL,G1H8(25),75,ex5(:),16,G2H4(71),m3h2x4(:,59),heltab2x8(:,:,59))
call HGT_OLR(G1H8(26),1,1,8)
call HGT_invQ_OLR(G1H8(26),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(26),-32,nMT,G2H8(46),n2h8(119))
  call Hloop_AV_Q(ntryL,G2H8(46),ex6(:),G2H4(72),m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_UV_W(ntryL,G1H8(29),75,ex5(:),16,G2H4(73),m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_UV_W(ntryL,G1H8(30),75,ex5(:),16,G2H4(74),m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_UV_W(ntryL,G1H8(31),75,ex6(:),32,G2H4(75),m3h2x4(:,63),heltab2x8(:,:,63))
call HGT_OLR(G1H8(32),1,1,8)
call HGT_invQ_OLR(G1H8(32),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(32),-16,nMT,G2H8(47),n2h8(120))
  call Hloop_AV_Q(ntryL,G2H8(47),ex5(:),G2H4(76),m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_UV_W(ntryL,G1H8(35),75,ex6(:),32,G2H4(77),m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_UV_W(ntryL,G1H8(36),75,ex6(:),32,G2H4(78),m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_VA_Q(ntryL,G1H16(79),ex4(:),G1H8(239),m3h2x8(:,101),heltab2x16(:,:,113))
  call Hloop_A_Q(ntryL,G1H8(239),92,nMT,G2H8(50),n2h8(121))
call HGT_OLR(G1H16(80),1,1,16)
call HGT_invQ_OLR(G1H16(80),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(80),-32,nMT,G2H16(11),n2h16(95))
  call Hloop_QV_A(ntryL,G2H16(11),ex6(:),G2H8(51),m3h2x8(:,102),heltab2x16(:,:,114))
  call Hloop_VA_Q(ntryL,G1H16(83),ex4(:),G1H8(240),m3h2x8(:,103),heltab2x16(:,:,115))
  call Hloop_A_Q(ntryL,G1H8(240),92,nMT,G2H8(52),n2h8(122))
  call Hloop_VA_Q(ntryL,G1H16(84),ex4(:),G1H8(77),m3h2x8(:,104),heltab2x16(:,:,116))
  call Hloop_A_Q(ntryL,G1H8(77),92,nMT,G2H8(55),n2h8(123))
  call Hloop_UV_W(ntryL,G1H8(37),75,ex6(:),32,G2H4(79),m3h2x4(:,67),heltab2x8(:,:,67))
call HGT_OLR(G1H8(38),1,1,8)
call HGT_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(38),-4,nMT,G2H8(56),n2h8(124))
  call Hloop_AQ_V(ntryL,G2H8(56),ex3(:),G2H4(80),m3h2x4(:,68),heltab2x8(:,:,68))
  call Hloop_UV_W(ntryL,G1H8(41),75,ex6(:),32,G2H4(81),m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_UV_W(ntryL,G1H8(42),75,ex6(:),32,G2H4(82),m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_UV_W(ntryL,G1H8(43),71,ex5(:),16,G2H4(83),m3h2x4(:,71),heltab2x8(:,:,71))
call HGT_OLR(G1H8(44),1,1,8)
call HGT_invQ_OLR(G1H8(44),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(44),-32,nMT,G2H8(57),n2h8(125))
  call Hloop_QV_A(ntryL,G2H8(57),ex6(:),G2H4(84),m3h2x4(:,72),heltab2x8(:,:,72))
  call Hloop_UV_W(ntryL,G1H8(47),71,ex5(:),16,G2H4(85),m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_UV_W(ntryL,G1H8(48),71,ex5(:),16,G2H4(86),m3h2x4(:,74),heltab2x8(:,:,74))
  call Hloop_VQ_A(ntryL,G1H16(85),ex3(:),G1H8(78),m3h2x8(:,105),heltab2x16(:,:,117))
  call Hloop_Q_A(ntryL,G1H8(78),92,nMT,G2H8(59),n2h8(126))
call HGT_OLR(G1H16(86),1,1,16)
call HGT_invQ_OLR(G1H16(86),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(86),-32,nMT,G2H16(12),n2h16(96))
  call Hloop_AV_Q(ntryL,G2H16(12),ex6(:),G2H8(60),m3h2x8(:,106),heltab2x16(:,:,118))
  call Hloop_VQ_A(ntryL,G1H16(89),ex3(:),G1H8(95),m3h2x8(:,107),heltab2x16(:,:,119))
  call Hloop_Q_A(ntryL,G1H8(95),92,nMT,G2H8(61),n2h8(127))
  call Hloop_VQ_A(ntryL,G1H16(90),ex3(:),G1H8(1),m3h2x8(:,108),heltab2x16(:,:,120))
  call Hloop_Q_A(ntryL,G1H8(1),92,nMT,G2H8(64),n2h8(128))
  call Hloop_UV_W(ntryL,G1H8(49),71,ex5(:),16,G2H4(87),m3h2x4(:,75),heltab2x8(:,:,75))
call HGT_OLR(G1H8(50),1,1,8)
call HGT_invQ_OLR(G1H8(50),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(50),-8,nMT,G2H8(65),n2h8(129))
  call Hloop_QA_V(ntryL,G2H8(65),ex4(:),G2H4(88),m3h2x4(:,76),heltab2x8(:,:,76))
  call Hloop_UV_W(ntryL,G1H8(53),71,ex5(:),16,G2H4(89),m3h2x4(:,77),heltab2x8(:,:,77))
  call Hloop_UV_W(ntryL,G1H8(54),71,ex5(:),16,G2H4(90),m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_UV_W(ntryL,G1H8(55),75,ex5(:),16,G2H4(91),m3h2x4(:,79),heltab2x8(:,:,79))
call HGT_OLR(G1H8(56),1,1,8)
call HGT_invQ_OLR(G1H8(56),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(56),-4,nMT,G2H8(66),n2h8(130))
  call Hloop_AQ_V(ntryL,G2H8(66),ex3(:),G2H4(92),m3h2x4(:,80),heltab2x8(:,:,80))
  call Hloop_UV_W(ntryL,G1H8(59),75,ex5(:),16,G2H4(93),m3h2x4(:,81),heltab2x8(:,:,81))
  call Hloop_UV_W(ntryL,G1H8(60),75,ex5(:),16,G2H4(94),m3h2x4(:,82),heltab2x8(:,:,82))
  call Hloop_VA_Q(ntryL,G1H16(91),ex4(:),G1H8(2),m3h2x8(:,109),heltab2x16(:,:,121))
  call Hloop_A_Q(ntryL,G1H8(2),108,nMT,G2H8(69),n2h8(131))
call HGT_OLR(G1H16(92),1,1,16)
call HGT_invQ_OLR(G1H16(92),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(92),-16,nMT,G2H16(13),n2h16(97))
  call Hloop_QV_A(ntryL,G2H16(13),ex5(:),G2H8(70),m3h2x8(:,110),heltab2x16(:,:,122))
  call Hloop_VA_Q(ntryL,G1H16(95),ex4(:),G1H8(5),m3h2x8(:,111),heltab2x16(:,:,123))
  call Hloop_A_Q(ntryL,G1H8(5),108,nMT,G2H8(71),n2h8(132))
  call Hloop_VA_Q(ntryL,G1H16(96),ex4(:),G1H8(6),m3h2x8(:,112),heltab2x16(:,:,124))
  call Hloop_A_Q(ntryL,G1H8(6),108,nMT,G2H8(73),n2h8(133))
  call Hloop_UV_W(ntryL,G1H8(61),71,ex6(:),32,G2H4(95),m3h2x4(:,83),heltab2x8(:,:,83))
call HGT_OLR(G1H8(62),1,1,8)
call HGT_invQ_OLR(G1H8(62),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(62),-16,nMT,G2H8(74),n2h8(134))
  call Hloop_QV_A(ntryL,G2H8(74),ex5(:),G2H4(96),m3h2x4(:,84),heltab2x8(:,:,84))
  call Hloop_UV_W(ntryL,G1H8(65),71,ex6(:),32,G2H4(97),m3h2x4(:,85),heltab2x8(:,:,85))
  call Hloop_UV_W(ntryL,G1H8(66),71,ex6(:),32,G2H4(98),m3h2x4(:,86),heltab2x8(:,:,86))
  call Hloop_UV_W(ntryL,G1H8(67),71,ex6(:),32,G2H4(99),m3h2x4(:,87),heltab2x8(:,:,87))
call HGT_OLR(G1H8(68),1,1,8)
call HGT_invQ_OLR(G1H8(68),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(68),-8,nMT,G2H8(75),n2h8(135))
  call Hloop_QA_V(ntryL,G2H8(75),ex4(:),G2H4(100),m3h2x4(:,88),heltab2x8(:,:,88))
  call Hloop_UV_W(ntryL,G1H8(71),71,ex6(:),32,G2H4(101),m3h2x4(:,89),heltab2x8(:,:,89))
  call Hloop_UV_W(ntryL,G1H8(72),71,ex6(:),32,G2H4(102),m3h2x4(:,90),heltab2x8(:,:,90))
  call Hloop_VQ_A(ntryL,G1H16(97),ex3(:),G1H8(96),m3h2x8(:,113),heltab2x16(:,:,125))
  call Hloop_Q_A(ntryL,G1H8(96),108,nMT,G2H8(77),n2h8(136))
call HGT_OLR(G1H16(98),1,1,16)
call HGT_invQ_OLR(G1H16(98),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(98),-16,nMT,G2H16(14),n2h16(98))
  call Hloop_AV_Q(ntryL,G2H16(14),ex5(:),G2H8(78),m3h2x8(:,114),heltab2x16(:,:,126))
  call Hloop_VQ_A(ntryL,G1H16(101),ex3(:),G1H8(113),m3h2x8(:,115),heltab2x16(:,:,127))
  call Hloop_Q_A(ntryL,G1H8(113),108,nMT,G2H8(79),n2h8(137))
  call Hloop_VQ_A(ntryL,G1H16(102),ex3(:),G1H8(114),m3h2x8(:,116),heltab2x16(:,:,128))
  call Hloop_Q_A(ntryL,G1H8(114),108,nMT,G2H8(82),n2h8(138))
  call Hloop_AV_Q(ntryL,G1H8(73),ex5(:),G1H4(1),m3h2x4(:,91),heltab2x8(:,:,91))
  call Hloop_A_Q(ntryL,G1H4(1),115,nMT,G2H4(103),n2h4(25))
call HGT_OLR(G1H8(74),1,1,8)
call HGT_invQ_OLR(G1H8(74),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(74),-8,nMT,G2H8(83),n2h8(139))
  call Hloop_QA_V(ntryL,G2H8(83),ex4(:),G2H4(104),m3h2x4(:,92),heltab2x8(:,:,92))
  call Hloop_AV_Q(ntryL,G1H8(79),ex5(:),G1H4(1),m3h2x4(:,93),heltab2x8(:,:,93))
  call Hloop_A_Q(ntryL,G1H4(1),115,nMT,G2H4(105),n2h4(26))
  call Hloop_AV_Q(ntryL,G1H8(85),ex5(:),G1H4(1),m3h2x4(:,94),heltab2x8(:,:,94))
  call Hloop_A_Q(ntryL,G1H4(1),115,nMT,G2H4(106),n2h4(27))
call HGT_OLR(G1H8(80),1,1,8)
call HGT_invQ_OLR(G1H8(80),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(80),-8,nMT,G2H8(84),n2h8(140))
  call Hloop_QA_V(ntryL,G2H8(84),ex4(:),G2H4(107),m3h2x4(:,95),heltab2x8(:,:,95))
  call Hloop_AV_Q(ntryL,G1H8(83),ex5(:),G1H4(1),m3h2x4(:,96),heltab2x8(:,:,96))
  call Hloop_A_Q(ntryL,G1H4(1),115,nMT,G2H4(108),n2h4(28))
  call Hloop_AV_Q(ntryL,G1H8(84),ex5(:),G1H4(1),m3h2x4(:,97),heltab2x8(:,:,97))
  call Hloop_A_Q(ntryL,G1H4(1),115,nMT,G2H4(109),n2h4(29))
call HGT_OLR(G1H8(86),1,1,8)
call HGT_invQ_OLR(G1H8(86),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(86),-8,nMT,G2H8(86),n2h8(141))
  call Hloop_QA_V(ntryL,G2H8(86),ex4(:),G2H4(110),m3h2x4(:,98),heltab2x8(:,:,98))
  call Hloop_AV_Q(ntryL,G1H8(89),ex5(:),G1H4(1),m3h2x4(:,99),heltab2x8(:,:,99))
  call Hloop_A_Q(ntryL,G1H4(1),115,nMT,G2H4(111),n2h4(30))
  call Hloop_AV_Q(ntryL,G1H8(90),ex5(:),G1H4(1),m3h2x4(:,100),heltab2x8(:,:,100))
  call Hloop_A_Q(ntryL,G1H4(1),115,nMT,G2H4(112),n2h4(31))
  call Hloop_AV_Q(ntryL,G1H8(91),ex6(:),G1H4(1),m3h2x4(:,101),heltab2x8(:,:,101))
  call Hloop_A_Q(ntryL,G1H4(1),115,nMT,G2H4(113),n2h4(32))
call HGT_OLR(G1H8(92),1,1,8)
call HGT_invQ_OLR(G1H8(92),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(92),-8,nMT,G2H8(87),n2h8(142))
  call Hloop_QA_V(ntryL,G2H8(87),ex4(:),G2H4(114),m3h2x4(:,102),heltab2x8(:,:,102))
  call Hloop_AV_Q(ntryL,G1H8(97),ex6(:),G1H4(1),m3h2x4(:,103),heltab2x8(:,:,103))
  call Hloop_A_Q(ntryL,G1H4(1),115,nMT,G2H4(115),n2h4(33))
  call Hloop_AV_Q(ntryL,G1H8(103),ex6(:),G1H4(1),m3h2x4(:,104),heltab2x8(:,:,104))
  call Hloop_A_Q(ntryL,G1H4(1),115,nMT,G2H4(116),n2h4(34))
call HGT_OLR(G1H8(98),1,1,8)
call HGT_invQ_OLR(G1H8(98),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(98),-8,nMT,G2H8(88),n2h8(143))
  call Hloop_QA_V(ntryL,G2H8(88),ex4(:),G2H4(117),m3h2x4(:,105),heltab2x8(:,:,105))
  call Hloop_AV_Q(ntryL,G1H8(101),ex6(:),G1H4(1),m3h2x4(:,106),heltab2x8(:,:,106))
  call Hloop_A_Q(ntryL,G1H4(1),115,nMT,G2H4(118),n2h4(35))
  call Hloop_AV_Q(ntryL,G1H8(102),ex6(:),G1H4(1),m3h2x4(:,107),heltab2x8(:,:,107))
  call Hloop_A_Q(ntryL,G1H4(1),115,nMT,G2H4(119),n2h4(36))
call HGT_OLR(G1H8(104),1,1,8)
call HGT_invQ_OLR(G1H8(104),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(104),-8,nMT,G2H8(91),n2h8(144))
  call Hloop_QA_V(ntryL,G2H8(91),ex4(:),G2H4(120),m3h2x4(:,108),heltab2x8(:,:,108))
  call Hloop_AV_Q(ntryL,G1H8(107),ex6(:),G1H4(1),m3h2x4(:,109),heltab2x8(:,:,109))
  call Hloop_A_Q(ntryL,G1H4(1),115,nMT,G2H4(121),n2h4(37))
  call Hloop_AV_Q(ntryL,G1H8(108),ex6(:),G1H4(1),m3h2x4(:,110),heltab2x8(:,:,110))
  call Hloop_A_Q(ntryL,G1H4(1),115,nMT,G2H4(122),n2h4(38))
  call Hloop_QV_A(ntryL,G1H8(109),ex5(:),G1H4(1),m3h2x4(:,111),heltab2x8(:,:,111))
  call Hloop_Q_A(ntryL,G1H4(1),115,nMT,G2H4(123),n2h4(39))
call HGT_OLR(G1H8(110),1,1,8)
call HGT_invQ_OLR(G1H8(110),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(110),-4,nMT,G2H8(92),n2h8(145))
  call Hloop_AQ_V(ntryL,G2H8(92),ex3(:),G2H4(124),m3h2x4(:,112),heltab2x8(:,:,112))
  call Hloop_QV_A(ntryL,G1H8(115),ex5(:),G1H4(1),m3h2x4(:,113),heltab2x8(:,:,113))
  call Hloop_Q_A(ntryL,G1H4(1),115,nMT,G2H4(125),n2h4(40))
  call Hloop_QV_A(ntryL,G1H8(121),ex5(:),G1H4(1),m3h2x4(:,114),heltab2x8(:,:,114))
  call Hloop_Q_A(ntryL,G1H4(1),115,nMT,G2H4(126),n2h4(41))
call HGT_OLR(G1H8(116),1,1,8)
call HGT_invQ_OLR(G1H8(116),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(116),-4,nMT,G2H8(93),n2h8(146))
  call Hloop_AQ_V(ntryL,G2H8(93),ex3(:),G2H4(127),m3h2x4(:,115),heltab2x8(:,:,115))
  call Hloop_QV_A(ntryL,G1H8(119),ex5(:),G1H4(1),m3h2x4(:,116),heltab2x8(:,:,116))
  call Hloop_Q_A(ntryL,G1H4(1),115,nMT,G2H4(128),n2h4(42))
  call Hloop_QV_A(ntryL,G1H8(120),ex5(:),G1H4(1),m3h2x4(:,117),heltab2x8(:,:,117))
  call Hloop_Q_A(ntryL,G1H4(1),115,nMT,G2H4(129),n2h4(43))
call HGT_OLR(G1H8(122),1,1,8)
call HGT_invQ_OLR(G1H8(122),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(122),-4,nMT,G2H8(95),n2h8(147))
  call Hloop_AQ_V(ntryL,G2H8(95),ex3(:),G2H4(130),m3h2x4(:,118),heltab2x8(:,:,118))
  call Hloop_QV_A(ntryL,G1H8(125),ex5(:),G1H4(1),m3h2x4(:,119),heltab2x8(:,:,119))
  call Hloop_Q_A(ntryL,G1H4(1),115,nMT,G2H4(131),n2h4(44))
  call Hloop_QV_A(ntryL,G1H8(126),ex5(:),G1H4(1),m3h2x4(:,120),heltab2x8(:,:,120))
  call Hloop_Q_A(ntryL,G1H4(1),115,nMT,G2H4(132),n2h4(45))
  call Hloop_QV_A(ntryL,G1H8(127),ex6(:),G1H4(1),m3h2x4(:,121),heltab2x8(:,:,121))
  call Hloop_Q_A(ntryL,G1H4(1),115,nMT,G2H4(133),n2h4(46))
call HGT_OLR(G1H8(128),1,1,8)
call HGT_invQ_OLR(G1H8(128),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(128),-4,nMT,G2H8(96),n2h8(148))
  call Hloop_AQ_V(ntryL,G2H8(96),ex3(:),G2H4(134),m3h2x4(:,122),heltab2x8(:,:,122))
  call Hloop_QV_A(ntryL,G1H8(133),ex6(:),G1H4(1),m3h2x4(:,123),heltab2x8(:,:,123))
  call Hloop_Q_A(ntryL,G1H4(1),115,nMT,G2H4(135),n2h4(47))
  call Hloop_QV_A(ntryL,G1H8(139),ex6(:),G1H4(1),m3h2x4(:,124),heltab2x8(:,:,124))
  call Hloop_Q_A(ntryL,G1H4(1),115,nMT,G2H4(136),n2h4(48))
call HGT_OLR(G1H8(134),1,1,8)
call HGT_invQ_OLR(G1H8(134),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(134),-4,nMT,G2H8(97),n2h8(149))
  call Hloop_AQ_V(ntryL,G2H8(97),ex3(:),G2H4(137),m3h2x4(:,125),heltab2x8(:,:,125))
  call Hloop_QV_A(ntryL,G1H8(137),ex6(:),G1H4(1),m3h2x4(:,126),heltab2x8(:,:,126))
  call Hloop_Q_A(ntryL,G1H4(1),115,nMT,G2H4(138),n2h4(49))
  call Hloop_QV_A(ntryL,G1H8(138),ex6(:),G1H4(1),m3h2x4(:,127),heltab2x8(:,:,127))
  call Hloop_Q_A(ntryL,G1H4(1),115,nMT,G2H4(139),n2h4(50))
call HGT_OLR(G1H8(140),1,1,8)
call HGT_invQ_OLR(G1H8(140),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(140),-4,nMT,G2H8(99),n2h8(150))
  call Hloop_AQ_V(ntryL,G2H8(99),ex3(:),G2H4(140),m3h2x4(:,128),heltab2x8(:,:,128))
  call Hloop_QV_A(ntryL,G1H8(143),ex6(:),G1H4(1),m3h2x4(:,129),heltab2x8(:,:,129))
  call Hloop_Q_A(ntryL,G1H4(1),115,nMT,G2H4(141),n2h4(51))
  call Hloop_QV_A(ntryL,G1H8(144),ex6(:),G1H4(1),m3h2x4(:,130),heltab2x8(:,:,130))
  call Hloop_Q_A(ntryL,G1H4(1),115,nMT,G2H4(142),n2h4(52))
  call Hloop_AV_Q(ntryL,G1H8(145),ex6(:),G1H4(1),m3h2x4(:,131),heltab2x8(:,:,131))
  call Hloop_A_Q(ntryL,G1H4(1),107,nMT,G2H4(143),n2h4(53))
call HGT_raise_alpha_OLR(G1H8(146),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(146),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(146),-16,ex5(:),16,G2H4(144),m3h2x4(:,132),heltab2x8(:,:,132))
call signflip_OLR(G2H4(144))
  call Hloop_AV_Q(ntryL,G1H8(151),ex6(:),G1H4(1),m3h2x4(:,133),heltab2x8(:,:,133))
  call Hloop_A_Q(ntryL,G1H4(1),107,nMT,G2H4(145),n2h4(54))
  call Hloop_AV_Q(ntryL,G1H8(157),ex6(:),G1H4(1),m3h2x4(:,134),heltab2x8(:,:,134))
  call Hloop_A_Q(ntryL,G1H4(1),107,nMT,G2H4(146),n2h4(55))
call HGT_raise_alpha_OLR(G1H8(152),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(152),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(152),-16,ex5(:),16,G2H4(147),m3h2x4(:,135),heltab2x8(:,:,135))
call signflip_OLR(G2H4(147))
  call Hloop_AV_Q(ntryL,G1H8(155),ex6(:),G1H4(1),m3h2x4(:,136),heltab2x8(:,:,136))
  call Hloop_A_Q(ntryL,G1H4(1),107,nMT,G2H4(148),n2h4(56))
  call Hloop_AV_Q(ntryL,G1H8(156),ex6(:),G1H4(1),m3h2x4(:,137),heltab2x8(:,:,137))
  call Hloop_A_Q(ntryL,G1H4(1),107,nMT,G2H4(149),n2h4(57))
call HGT_raise_alpha_OLR(G1H8(158),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(158),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(158),-16,ex5(:),16,G2H4(150),m3h2x4(:,138),heltab2x8(:,:,138))
call signflip_OLR(G2H4(150))
  call Hloop_AV_Q(ntryL,G1H8(161),ex6(:),G1H4(1),m3h2x4(:,139),heltab2x8(:,:,139))
  call Hloop_A_Q(ntryL,G1H4(1),107,nMT,G2H4(151),n2h4(58))
  call Hloop_AV_Q(ntryL,G1H8(162),ex6(:),G1H4(1),m3h2x4(:,140),heltab2x8(:,:,140))
  call Hloop_A_Q(ntryL,G1H4(1),107,nMT,G2H4(152),n2h4(59))
  call Hloop_AV_Q(ntryL,G1H8(163),ex5(:),G1H4(1),m3h2x4(:,141),heltab2x8(:,:,141))
  call Hloop_A_Q(ntryL,G1H4(1),91,nMT,G2H4(153),n2h4(60))
call HGT_raise_alpha_OLR(G1H8(164),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(164),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(164),-32,ex6(:),32,G2H4(154),m3h2x4(:,142),heltab2x8(:,:,142))
call signflip_OLR(G2H4(154))
  call Hloop_AV_Q(ntryL,G1H8(169),ex5(:),G1H4(1),m3h2x4(:,143),heltab2x8(:,:,143))
  call Hloop_A_Q(ntryL,G1H4(1),91,nMT,G2H4(155),n2h4(61))
  call Hloop_AV_Q(ntryL,G1H8(175),ex5(:),G1H4(1),m3h2x4(:,144),heltab2x8(:,:,144))
  call Hloop_A_Q(ntryL,G1H4(1),91,nMT,G2H4(156),n2h4(62))
call HGT_raise_alpha_OLR(G1H8(170),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(170),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(170),-32,ex6(:),32,G2H4(157),m3h2x4(:,145),heltab2x8(:,:,145))
call signflip_OLR(G2H4(157))
  call Hloop_AV_Q(ntryL,G1H8(173),ex5(:),G1H4(1),m3h2x4(:,146),heltab2x8(:,:,146))
  call Hloop_A_Q(ntryL,G1H4(1),91,nMT,G2H4(158),n2h4(63))
  call Hloop_AV_Q(ntryL,G1H8(174),ex5(:),G1H4(1),m3h2x4(:,147),heltab2x8(:,:,147))
  call Hloop_A_Q(ntryL,G1H4(1),91,nMT,G2H4(159),n2h4(64))
call HGT_raise_alpha_OLR(G1H8(176),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(176),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(176),-32,ex6(:),32,G2H4(160),m3h2x4(:,148),heltab2x8(:,:,148))
call signflip_OLR(G2H4(160))
  call Hloop_AV_Q(ntryL,G1H8(179),ex5(:),G1H4(1),m3h2x4(:,149),heltab2x8(:,:,149))
  call Hloop_A_Q(ntryL,G1H4(1),91,nMT,G2H4(161),n2h4(65))
  call Hloop_AV_Q(ntryL,G1H8(180),ex5(:),G1H4(1),m3h2x4(:,150),heltab2x8(:,:,150))
  call Hloop_A_Q(ntryL,G1H4(1),91,nMT,G2H4(162),n2h4(66))
  call Hloop_QZ_A(ntryL,G1H16(103),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,13),heltab2x16(:,:,129))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMT,G2H4(163),n2h4(67))
call HGT_raise_alpha_OLR(G1H16(104),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(104),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(104),ex4(:),G1H8(131),m3h2x8(:,117),heltab2x16(:,:,130))
  call Hloop_QZ_A(ntryL,G1H16(109),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,14),heltab2x16(:,:,131))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMT,G2H4(164),n2h4(68))
  call Hloop_QZ_A(ntryL,G1H16(115),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,15),heltab2x16(:,:,132))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMT,G2H4(165),n2h4(69))
call HGT_raise_alpha_OLR(G1H16(110),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(110),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(110),ex4(:),G1H8(132),m3h2x8(:,118),heltab2x16(:,:,133))
  call Hloop_QZ_A(ntryL,G1H16(113),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,16),heltab2x16(:,:,134))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMT,G2H4(166),n2h4(70))
  call Hloop_QZ_A(ntryL,G1H16(114),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,17),heltab2x16(:,:,135))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMT,G2H4(167),n2h4(71))
call HGT_raise_alpha_OLR(G1H16(116),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(116),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(116),ex4(:),G1H8(149),m3h2x8(:,119),heltab2x16(:,:,136))
  call Hloop_QZ_A(ntryL,G1H16(119),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,18),heltab2x16(:,:,137))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMT,G2H4(168),n2h4(72))
  call Hloop_QZ_A(ntryL,G1H16(120),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,19),heltab2x16(:,:,138))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMT,G2H4(169),n2h4(73))
  call Hloop_QZ_A(ntryL,G1H16(121),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,20),heltab2x16(:,:,139))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMT,G2H4(170),n2h4(74))
call HGT_raise_alpha_OLR(G1H16(122),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(122),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(122),-32,ex6(:),32,G2H8(100),m3h2x8(:,120),heltab2x16(:,:,140))
call signflip_OLR(G2H8(100))
  call Hloop_QZ_A(ntryL,G1H16(127),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,21),heltab2x16(:,:,141))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMT,G2H4(171),n2h4(75))
  call Hloop_QZ_A(ntryL,G1H16(133),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,22),heltab2x16(:,:,142))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMT,G2H4(172),n2h4(76))
call HGT_raise_alpha_OLR(G1H16(128),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(128),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(128),-32,ex6(:),32,G2H8(101),m3h2x8(:,121),heltab2x16(:,:,143))
call signflip_OLR(G2H8(101))
  call Hloop_QZ_A(ntryL,G1H16(131),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,23),heltab2x16(:,:,144))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMT,G2H4(173),n2h4(77))
  call Hloop_QZ_A(ntryL,G1H16(132),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,24),heltab2x16(:,:,145))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMT,G2H4(174),n2h4(78))
call HGT_raise_alpha_OLR(G1H16(134),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(134),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(134),-32,ex6(:),32,G2H8(103),m3h2x8(:,122),heltab2x16(:,:,146))
call signflip_OLR(G2H8(103))
  call Hloop_QZ_A(ntryL,G1H16(137),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,25),heltab2x16(:,:,147))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMT,G2H4(175),n2h4(79))
  call Hloop_QZ_A(ntryL,G1H16(138),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,26),heltab2x16(:,:,148))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMT,G2H4(176),n2h4(80))
  call Hloop_QV_A(ntryL,G1H16(139),ex6(:),G1H8(7),m3h2x8(:,123),heltab2x16(:,:,149))
  call Hloop_Q_A(ntryL,G1H8(7),116,nMT,G2H8(104),n2h8(157))
call HGT_raise_alpha_OLR(G1H16(140),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(140),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(140),ex4(:),G1H8(8),m3h2x8(:,124),heltab2x16(:,:,150))
  call Hloop_QV_A(ntryL,G1H16(145),ex6(:),G1H8(11),m3h2x8(:,125),heltab2x16(:,:,151))
  call Hloop_Q_A(ntryL,G1H8(11),116,nMT,G2H8(105),n2h8(158))
  call Hloop_QV_A(ntryL,G1H16(151),ex6(:),G1H8(12),m3h2x8(:,126),heltab2x16(:,:,152))
  call Hloop_Q_A(ntryL,G1H8(12),116,nMT,G2H8(107),n2h8(159))
call HGT_raise_alpha_OLR(G1H16(146),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(146),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(146),ex4(:),G1H8(150),m3h2x8(:,127),heltab2x16(:,:,153))
  call Hloop_QV_A(ntryL,G1H16(149),ex6(:),G1H8(167),m3h2x8(:,128),heltab2x16(:,:,154))
  call Hloop_Q_A(ntryL,G1H8(167),116,nMT,G2H8(108),n2h8(160))
  call Hloop_QV_A(ntryL,G1H16(150),ex6(:),G1H8(168),m3h2x8(:,129),heltab2x16(:,:,155))
  call Hloop_Q_A(ntryL,G1H8(168),116,nMT,G2H8(109),n2h8(161))
call HGT_raise_alpha_OLR(G1H16(152),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(152),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(152),ex4(:),G1H8(185),m3h2x8(:,130),heltab2x16(:,:,156))
  call Hloop_QV_A(ntryL,G1H16(155),ex6(:),G1H8(186),m3h2x8(:,131),heltab2x16(:,:,157))
  call Hloop_Q_A(ntryL,G1H8(186),116,nMT,G2H8(111),n2h8(162))
  call Hloop_QV_A(ntryL,G1H16(156),ex6(:),G1H8(203),m3h2x8(:,132),heltab2x16(:,:,158))
  call Hloop_Q_A(ntryL,G1H8(203),116,nMT,G2H8(112),n2h8(163))
  call Hloop_AZ_Q(ntryL,G1H16(157),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,27),heltab2x16(:,:,159))
  call Hloop_A_Q(ntryL,G1H4(1),107,nMT,G2H4(177),n2h4(81))
call HGT_raise_alpha_OLR(G1H16(158),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(158),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(158),-16,ex5(:),16,G2H8(113),m3h2x8(:,133),heltab2x16(:,:,160))
call signflip_OLR(G2H8(113))
  call Hloop_AZ_Q(ntryL,G1H16(163),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,28),heltab2x16(:,:,161))
  call Hloop_A_Q(ntryL,G1H4(1),107,nMT,G2H4(178),n2h4(82))
  call Hloop_AZ_Q(ntryL,G1H16(169),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,29),heltab2x16(:,:,162))
  call Hloop_A_Q(ntryL,G1H4(1),107,nMT,G2H4(179),n2h4(83))
call HGT_raise_alpha_OLR(G1H16(164),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(164),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(164),-16,ex5(:),16,G2H8(115),m3h2x8(:,134),heltab2x16(:,:,163))
call signflip_OLR(G2H8(115))
  call Hloop_AZ_Q(ntryL,G1H16(167),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,30),heltab2x16(:,:,164))
  call Hloop_A_Q(ntryL,G1H4(1),107,nMT,G2H4(180),n2h4(84))
  call Hloop_AZ_Q(ntryL,G1H16(168),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,31),heltab2x16(:,:,165))
  call Hloop_A_Q(ntryL,G1H4(1),107,nMT,G2H4(181),n2h4(85))
call HGT_raise_alpha_OLR(G1H16(170),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(170),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(170),-16,ex5(:),16,G2H8(116),m3h2x8(:,135),heltab2x16(:,:,166))
call signflip_OLR(G2H8(116))
  call Hloop_AZ_Q(ntryL,G1H16(173),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,32),heltab2x16(:,:,167))
  call Hloop_A_Q(ntryL,G1H4(1),107,nMT,G2H4(182),n2h4(86))
  call Hloop_AZ_Q(ntryL,G1H16(174),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,33),heltab2x16(:,:,168))
  call Hloop_A_Q(ntryL,G1H4(1),107,nMT,G2H4(183),n2h4(87))
  call Hloop_QZ_A(ntryL,G1H16(175),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,34),heltab2x16(:,:,169))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMT,G2H4(184),n2h4(88))
call HGT_raise_alpha_OLR(G1H16(176),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(176),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(176),-32,ex6(:),32,G2H8(117),m3h2x8(:,136),heltab2x16(:,:,170))
call signflip_OLR(G2H8(117))
  call Hloop_QZ_A(ntryL,G1H16(181),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,35),heltab2x16(:,:,171))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMT,G2H4(185),n2h4(89))
  call Hloop_QZ_A(ntryL,G1H16(187),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,36),heltab2x16(:,:,172))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMT,G2H4(186),n2h4(90))
call HGT_raise_alpha_OLR(G1H16(182),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(182),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(182),-32,ex6(:),32,G2H8(119),m3h2x8(:,137),heltab2x16(:,:,173))
call signflip_OLR(G2H8(119))
  call Hloop_QZ_A(ntryL,G1H16(185),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,37),heltab2x16(:,:,174))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMT,G2H4(187),n2h4(91))
  call Hloop_QZ_A(ntryL,G1H16(186),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,38),heltab2x16(:,:,175))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMT,G2H4(188),n2h4(92))
call HGT_raise_alpha_OLR(G1H16(188),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(188),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(188),-32,ex6(:),32,G2H8(120),m3h2x8(:,138),heltab2x16(:,:,176))
call signflip_OLR(G2H8(120))
  call Hloop_QZ_A(ntryL,G1H16(191),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,39),heltab2x16(:,:,177))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMT,G2H4(189),n2h4(93))
  call Hloop_QZ_A(ntryL,G1H16(192),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,40),heltab2x16(:,:,178))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMT,G2H4(190),n2h4(94))
  call Hloop_QZ_A(ntryL,G1H16(193),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,41),heltab2x16(:,:,179))
  call Hloop_Q_A(ntryL,G1H4(1),103,nMT,G2H4(191),n2h4(95))
call HGT_raise_alpha_OLR(G1H16(194),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(194),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(194),ex4(:),G1H8(13),m3h2x8(:,139),heltab2x16(:,:,180))
  call Hloop_QZ_A(ntryL,G1H16(199),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,42),heltab2x16(:,:,181))
  call Hloop_Q_A(ntryL,G1H4(1),103,nMT,G2H4(192),n2h4(96))
  call Hloop_QZ_A(ntryL,G1H16(205),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,43),heltab2x16(:,:,182))
  call Hloop_Q_A(ntryL,G1H4(1),103,nMT,G2H4(193),n2h4(97))
call HGT_raise_alpha_OLR(G1H16(200),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(200),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(200),ex4(:),G1H8(14),m3h2x8(:,140),heltab2x16(:,:,183))
  call Hloop_QZ_A(ntryL,G1H16(203),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,44),heltab2x16(:,:,184))
  call Hloop_Q_A(ntryL,G1H4(1),103,nMT,G2H4(194),n2h4(98))
  call Hloop_QZ_A(ntryL,G1H16(204),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,45),heltab2x16(:,:,185))
  call Hloop_Q_A(ntryL,G1H4(1),103,nMT,G2H4(195),n2h4(99))
call HGT_raise_alpha_OLR(G1H16(206),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(206),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(206),ex4(:),G1H8(17),m3h2x8(:,141),heltab2x16(:,:,186))
  call Hloop_QZ_A(ntryL,G1H16(209),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,46),heltab2x16(:,:,187))
  call Hloop_Q_A(ntryL,G1H4(1),103,nMT,G2H4(196),n2h4(100))
  call Hloop_QZ_A(ntryL,G1H16(210),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,47),heltab2x16(:,:,188))
  call Hloop_Q_A(ntryL,G1H4(1),103,nMT,G2H4(197),n2h4(101))
  call Hloop_QZ_A(ntryL,G1H16(211),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,48),heltab2x16(:,:,189))
  call Hloop_Q_A(ntryL,G1H4(1),103,nMT,G2H4(198),n2h4(102))
call HGT_raise_alpha_OLR(G1H16(212),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(212),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(212),-16,ex5(:),16,G2H8(5),m3h2x8(:,142),heltab2x16(:,:,190))
call signflip_OLR(G2H8(5))
  call Hloop_QZ_A(ntryL,G1H16(217),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,49),heltab2x16(:,:,191))
  call Hloop_Q_A(ntryL,G1H4(1),103,nMT,G2H4(199),n2h4(103))
  call Hloop_QZ_A(ntryL,G1H16(223),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,50),heltab2x16(:,:,192))
  call Hloop_Q_A(ntryL,G1H4(1),103,nMT,G2H4(200),n2h4(104))
call HGT_raise_alpha_OLR(G1H16(218),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(218),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(218),-16,ex5(:),16,G2H8(16),m3h2x8(:,143),heltab2x16(:,:,193))
call signflip_OLR(G2H8(16))
  call Hloop_QZ_A(ntryL,G1H16(221),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,51),heltab2x16(:,:,194))
  call Hloop_Q_A(ntryL,G1H4(1),103,nMT,G2H4(201),n2h4(105))
  call Hloop_QZ_A(ntryL,G1H16(222),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,52),heltab2x16(:,:,195))
  call Hloop_Q_A(ntryL,G1H4(1),103,nMT,G2H4(202),n2h4(106))
call HGT_raise_alpha_OLR(G1H16(224),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(224),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(224),-16,ex5(:),16,G2H8(33),m3h2x8(:,144),heltab2x16(:,:,196))
call signflip_OLR(G2H8(33))
  call Hloop_QZ_A(ntryL,G1H16(227),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,53),heltab2x16(:,:,197))
  call Hloop_Q_A(ntryL,G1H4(1),103,nMT,G2H4(203),n2h4(107))
  call Hloop_QZ_A(ntryL,G1H16(228),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,54),heltab2x16(:,:,198))
  call Hloop_Q_A(ntryL,G1H4(1),103,nMT,G2H4(204),n2h4(108))
  call Hloop_QV_A(ntryL,G1H16(229),ex5(:),G1H8(18),m3h2x8(:,145),heltab2x16(:,:,199))
  call Hloop_Q_A(ntryL,G1H8(18),116,nMT,G2H8(42),n2h8(164))
call HGT_raise_alpha_OLR(G1H16(230),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(230),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(230),ex4(:),G1H8(204),m3h2x8(:,146),heltab2x16(:,:,200))
  call Hloop_QV_A(ntryL,G1H16(235),ex5(:),G1H8(221),m3h2x8(:,147),heltab2x16(:,:,201))
  call Hloop_Q_A(ntryL,G1H8(221),116,nMT,G2H8(46),n2h8(165))
  call Hloop_QV_A(ntryL,G1H16(241),ex5(:),G1H8(222),m3h2x8(:,148),heltab2x16(:,:,202))
  call Hloop_Q_A(ntryL,G1H8(222),116,nMT,G2H8(47),n2h8(166))
call HGT_raise_alpha_OLR(G1H16(236),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(236),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(236),ex4(:),G1H8(19),m3h2x8(:,149),heltab2x16(:,:,203))
  call Hloop_QV_A(ntryL,G1H16(239),ex5(:),G1H8(20),m3h2x8(:,150),heltab2x16(:,:,204))
  call Hloop_Q_A(ntryL,G1H8(20),116,nMT,G2H8(56),n2h8(167))
  call Hloop_QV_A(ntryL,G1H16(240),ex5(:),G1H8(23),m3h2x8(:,151),heltab2x16(:,:,205))
  call Hloop_Q_A(ntryL,G1H8(23),116,nMT,G2H8(57),n2h8(168))
call HGT_raise_alpha_OLR(G1H16(242),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(242),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(242),ex4(:),G1H8(24),m3h2x8(:,152),heltab2x16(:,:,206))
  call Hloop_QV_A(ntryL,G1H16(245),ex5(:),G1H8(25),m3h2x8(:,153),heltab2x16(:,:,207))
  call Hloop_Q_A(ntryL,G1H8(25),116,nMT,G2H8(65),n2h8(169))
  call Hloop_QV_A(ntryL,G1H16(246),ex5(:),G1H8(26),m3h2x8(:,154),heltab2x16(:,:,208))
  call Hloop_Q_A(ntryL,G1H8(26),116,nMT,G2H8(66),n2h8(170))
  call Hloop_AZ_Q(ntryL,G1H16(247),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,55),heltab2x16(:,:,209))
  call Hloop_A_Q(ntryL,G1H4(1),91,nMT,G2H4(205),n2h4(109))
call HGT_raise_alpha_OLR(G1H16(248),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(248),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(248),-32,ex6(:),32,G2H8(74),m3h2x8(:,155),heltab2x16(:,:,210))
call signflip_OLR(G2H8(74))
  call Hloop_AZ_Q(ntryL,G1H16(253),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,56),heltab2x16(:,:,211))
  call Hloop_A_Q(ntryL,G1H4(1),91,nMT,G2H4(206),n2h4(110))
  call Hloop_AZ_Q(ntryL,G1H16(259),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,57),heltab2x16(:,:,212))
  call Hloop_A_Q(ntryL,G1H4(1),91,nMT,G2H4(207),n2h4(111))
call HGT_raise_alpha_OLR(G1H16(254),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(254),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(254),-32,ex6(:),32,G2H8(75),m3h2x8(:,156),heltab2x16(:,:,213))
call signflip_OLR(G2H8(75))
  call Hloop_AZ_Q(ntryL,G1H16(257),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,58),heltab2x16(:,:,214))
  call Hloop_A_Q(ntryL,G1H4(1),91,nMT,G2H4(208),n2h4(112))
  call Hloop_AZ_Q(ntryL,G1H16(258),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,59),heltab2x16(:,:,215))
  call Hloop_A_Q(ntryL,G1H4(1),91,nMT,G2H4(209),n2h4(113))
call HGT_raise_alpha_OLR(G1H16(260),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(260),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(260),-32,ex6(:),32,G2H8(83),m3h2x8(:,157),heltab2x16(:,:,216))
call signflip_OLR(G2H8(83))
  call Hloop_AZ_Q(ntryL,G1H16(263),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,60),heltab2x16(:,:,217))
  call Hloop_A_Q(ntryL,G1H4(1),91,nMT,G2H4(210),n2h4(114))
  call Hloop_AZ_Q(ntryL,G1H16(264),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,61),heltab2x16(:,:,218))
  call Hloop_A_Q(ntryL,G1H4(1),91,nMT,G2H4(211),n2h4(115))
  call Hloop_AZ_Q(ntryL,G1H16(265),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,62),heltab2x16(:,:,219))
  call Hloop_A_Q(ntryL,G1H4(1),91,nMT,G2H4(212),n2h4(116))
call HGT_raise_alpha_OLR(G1H16(266),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(266),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(266),-32,ex6(:),32,G2H8(84),m3h2x8(:,158),heltab2x16(:,:,220))
call signflip_OLR(G2H8(84))
  call Hloop_AZ_Q(ntryL,G1H16(271),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,63),heltab2x16(:,:,221))
  call Hloop_A_Q(ntryL,G1H4(1),91,nMT,G2H4(213),n2h4(117))
  call Hloop_AZ_Q(ntryL,G1H16(277),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,64),heltab2x16(:,:,222))
  call Hloop_A_Q(ntryL,G1H4(1),91,nMT,G2H4(214),n2h4(118))
call HGT_raise_alpha_OLR(G1H16(272),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(272),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(272),-32,ex6(:),32,G2H8(86),m3h2x8(:,159),heltab2x16(:,:,223))
call signflip_OLR(G2H8(86))
  call Hloop_AZ_Q(ntryL,G1H16(275),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,65),heltab2x16(:,:,224))
  call Hloop_A_Q(ntryL,G1H4(1),91,nMT,G2H4(215),n2h4(119))
  call Hloop_AZ_Q(ntryL,G1H16(276),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,66),heltab2x16(:,:,225))
  call Hloop_A_Q(ntryL,G1H4(1),91,nMT,G2H4(216),n2h4(120))
call HGT_raise_alpha_OLR(G1H16(278),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(278),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(278),-32,ex6(:),32,G2H8(87),m3h2x8(:,160),heltab2x16(:,:,226))
call signflip_OLR(G2H8(87))
  call Hloop_AZ_Q(ntryL,G1H16(281),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,67),heltab2x16(:,:,227))
  call Hloop_A_Q(ntryL,G1H4(1),91,nMT,G2H4(217),n2h4(121))
  call Hloop_AZ_Q(ntryL,G1H16(282),wf4(:,2),G1H4(1),ngZu,m3h4x4(:,68),heltab2x16(:,:,228))
  call Hloop_A_Q(ntryL,G1H4(1),91,nMT,G2H4(218),n2h4(122))
  call Hloop_QV_A(ntryL,G1H8(181),ex6(:),G1H4(1),m3h2x4(:,151),heltab2x8(:,:,151))
  call Hloop_Q_A(ntryL,G1H4(1),103,nMT,G2H4(219),n2h4(123))
call HGT_raise_alpha_OLR(G1H8(182),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(182),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(182),-16,ex5(:),16,G2H4(220),m3h2x4(:,152),heltab2x8(:,:,152))
call signflip_OLR(G2H4(220))
  call Hloop_QV_A(ntryL,G1H8(187),ex6(:),G1H4(1),m3h2x4(:,153),heltab2x8(:,:,153))
  call Hloop_Q_A(ntryL,G1H4(1),103,nMT,G2H4(221),n2h4(124))
  call Hloop_QV_A(ntryL,G1H8(193),ex6(:),G1H4(1),m3h2x4(:,154),heltab2x8(:,:,154))
  call Hloop_Q_A(ntryL,G1H4(1),103,nMT,G2H4(222),n2h4(125))
call HGT_raise_alpha_OLR(G1H8(188),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(188),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(188),-16,ex5(:),16,G2H4(223),m3h2x4(:,155),heltab2x8(:,:,155))
call signflip_OLR(G2H4(223))
  call Hloop_QV_A(ntryL,G1H8(191),ex6(:),G1H4(1),m3h2x4(:,156),heltab2x8(:,:,156))
  call Hloop_Q_A(ntryL,G1H4(1),103,nMT,G2H4(224),n2h4(126))
  call Hloop_QV_A(ntryL,G1H8(192),ex6(:),G1H4(1),m3h2x4(:,157),heltab2x8(:,:,157))
  call Hloop_Q_A(ntryL,G1H4(1),103,nMT,G2H4(225),n2h4(127))
call HGT_raise_alpha_OLR(G1H8(194),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(194),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(194),-16,ex5(:),16,G2H4(226),m3h2x4(:,158),heltab2x8(:,:,158))
call signflip_OLR(G2H4(226))
  call Hloop_QV_A(ntryL,G1H8(197),ex6(:),G1H4(1),m3h2x4(:,159),heltab2x8(:,:,159))
  call Hloop_Q_A(ntryL,G1H4(1),103,nMT,G2H4(227),n2h4(128))
  call Hloop_QV_A(ntryL,G1H8(198),ex6(:),G1H4(1),m3h2x4(:,160),heltab2x8(:,:,160))
  call Hloop_Q_A(ntryL,G1H4(1),103,nMT,G2H4(228),n2h4(129))
  call Hloop_QV_A(ntryL,G1H8(199),ex5(:),G1H4(1),m3h2x4(:,161),heltab2x8(:,:,161))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMT,G2H4(229),n2h4(130))
call HGT_raise_alpha_OLR(G1H8(200),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(200),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(200),-32,ex6(:),32,G2H4(230),m3h2x4(:,162),heltab2x8(:,:,162))
call signflip_OLR(G2H4(230))
  call Hloop_QV_A(ntryL,G1H8(205),ex5(:),G1H4(1),m3h2x4(:,163),heltab2x8(:,:,163))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMT,G2H4(231),n2h4(131))
  call Hloop_QV_A(ntryL,G1H8(211),ex5(:),G1H4(1),m3h2x4(:,164),heltab2x8(:,:,164))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMT,G2H4(232),n2h4(132))
call HGT_raise_alpha_OLR(G1H8(206),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(206),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(206),-32,ex6(:),32,G2H4(233),m3h2x4(:,165),heltab2x8(:,:,165))
call signflip_OLR(G2H4(233))
  call Hloop_QV_A(ntryL,G1H8(209),ex5(:),G1H4(1),m3h2x4(:,166),heltab2x8(:,:,166))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMT,G2H4(234),n2h4(133))
  call Hloop_QV_A(ntryL,G1H8(210),ex5(:),G1H4(1),m3h2x4(:,167),heltab2x8(:,:,167))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMT,G2H4(235),n2h4(134))
call HGT_raise_alpha_OLR(G1H8(212),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(212),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(212),-32,ex6(:),32,G2H4(236),m3h2x4(:,168),heltab2x8(:,:,168))
call signflip_OLR(G2H4(236))
  call Hloop_QV_A(ntryL,G1H8(215),ex5(:),G1H4(1),m3h2x4(:,169),heltab2x8(:,:,169))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMT,G2H4(237),n2h4(135))
  call Hloop_QV_A(ntryL,G1H8(216),ex5(:),G1H4(1),m3h2x4(:,170),heltab2x8(:,:,170))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMT,G2H4(238),n2h4(136))
  call Hloop_QV_A(ntryL,G1H8(217),ex6(:),G1H4(1),m3h2x4(:,171),heltab2x8(:,:,171))
  call Hloop_Q_A(ntryL,G1H4(1),103,nMT,G2H4(239),n2h4(137))
call HGT_raise_alpha_OLR(G1H8(218),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(218),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(218),ex4(:),G1H4(1),m3h2x4(:,172),heltab2x8(:,:,172))
  call Hloop_QV_A(ntryL,G1H8(223),ex6(:),G1H4(2),m3h2x4(:,173),heltab2x8(:,:,173))
  call Hloop_Q_A(ntryL,G1H4(2),103,nMT,G2H4(240),n2h4(138))
  call Hloop_QV_A(ntryL,G1H8(229),ex6(:),G1H4(2),m3h2x4(:,174),heltab2x8(:,:,174))
  call Hloop_Q_A(ntryL,G1H4(2),103,nMT,G2H4(241),n2h4(139))
call HGT_raise_alpha_OLR(G1H8(224),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(224),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(224),ex4(:),G1H4(2),m3h2x4(:,175),heltab2x8(:,:,175))
  call Hloop_QV_A(ntryL,G1H8(227),ex6(:),G1H4(3),m3h2x4(:,176),heltab2x8(:,:,176))
  call Hloop_Q_A(ntryL,G1H4(3),103,nMT,G2H4(242),n2h4(140))
  call Hloop_QV_A(ntryL,G1H8(228),ex6(:),G1H4(3),m3h2x4(:,177),heltab2x8(:,:,177))
  call Hloop_Q_A(ntryL,G1H4(3),103,nMT,G2H4(243),n2h4(141))
call HGT_raise_alpha_OLR(G1H8(230),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(230),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(230),ex4(:),G1H4(3),m3h2x4(:,178),heltab2x8(:,:,178))
  call Hloop_QV_A(ntryL,G1H8(233),ex6(:),G1H4(4),m3h2x4(:,179),heltab2x8(:,:,179))
  call Hloop_Q_A(ntryL,G1H4(4),103,nMT,G2H4(244),n2h4(142))
  call Hloop_QV_A(ntryL,G1H8(234),ex6(:),G1H4(4),m3h2x4(:,180),heltab2x8(:,:,180))
  call Hloop_Q_A(ntryL,G1H4(4),103,nMT,G2H4(245),n2h4(143))
  call Hloop_QV_A(ntryL,G1H8(235),ex5(:),G1H4(4),m3h2x4(:,181),heltab2x8(:,:,181))
  call Hloop_Q_A(ntryL,G1H4(4),87,nMT,G2H4(246),n2h4(144))
call HGT_raise_alpha_OLR(G1H8(236),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(236),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(236),ex4(:),G1H4(4),m3h2x4(:,182),heltab2x8(:,:,182))
  call Hloop_QV_A(ntryL,G1H8(241),ex5(:),G1H4(5),m3h2x4(:,183),heltab2x8(:,:,183))
  call Hloop_Q_A(ntryL,G1H4(5),87,nMT,G2H4(247),n2h4(145))
  call Hloop_QV_A(ntryL,G1H8(247),ex5(:),G1H4(5),m3h2x4(:,184),heltab2x8(:,:,184))
  call Hloop_Q_A(ntryL,G1H4(5),87,nMT,G2H4(248),n2h4(146))
call HGT_raise_alpha_OLR(G1H8(242),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(242),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(242),ex4(:),G1H4(5),m3h2x4(:,185),heltab2x8(:,:,185))
  call Hloop_QV_A(ntryL,G1H8(245),ex5(:),G1H4(6),m3h2x4(:,186),heltab2x8(:,:,186))
  call Hloop_Q_A(ntryL,G1H4(6),87,nMT,G2H4(249),n2h4(147))
  call Hloop_QV_A(ntryL,G1H8(246),ex5(:),G1H4(6),m3h2x4(:,187),heltab2x8(:,:,187))
  call Hloop_Q_A(ntryL,G1H4(6),87,nMT,G2H4(250),n2h4(148))
call HGT_raise_alpha_OLR(G1H8(248),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(248),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(248),ex4(:),G1H4(6),m3h2x4(:,188),heltab2x8(:,:,188))
  call Hloop_QV_A(ntryL,G1H8(251),ex5(:),G1H4(7),m3h2x4(:,189),heltab2x8(:,:,189))
  call Hloop_Q_A(ntryL,G1H4(7),87,nMT,G2H4(251),n2h4(149))
  call Hloop_QV_A(ntryL,G1H8(252),ex5(:),G1H4(7),m3h2x4(:,190),heltab2x8(:,:,190))
  call Hloop_Q_A(ntryL,G1H4(7),87,nMT,G2H4(252),n2h4(150))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,1),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(8),16,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(69),mass5set(:,2),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(14),16,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(2),mass5set(:,1),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
  call HG1shiftOLR(G1H4(20),32,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(70),mass5set(:,2),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
  call HG1shiftOLR(G1H4(26),32,4)
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(4),mass5set(:,1),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
  call HG1shiftOLR(G1H4(32),16,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(69),mass5set(:,2),  & 
G1H4(37),G1H4(38),G1H4(39),G1H4(40),G1H4(41),G1H4(42),4)
  call HG1shiftOLR(G1H4(38),16,4)
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(5),mass5set(:,1),  & 
G1H4(43),G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
  call HG1shiftOLR(G1H4(44),32,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(70),mass5set(:,2),  & 
G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),G1H4(54),4)
  call HG1shiftOLR(G1H4(50),32,4)
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(7),mass5set(:,1),  & 
G1H4(55),G1H4(56),G1H4(57),G1H4(58),G1H4(59),G1H4(60),4)
  call HG1shiftOLR(G1H4(56),32,4)
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(71),mass5set(:,2),  & 
G1H4(61),G1H4(62),G1H4(63),G1H4(64),G1H4(65),G1H4(66),4)
  call HG1shiftOLR(G1H4(62),32,4)
  call Hotf_5pt_reduction(G2H4(16),RedSet_5(8),mass5set(:,1),  & 
G1H4(67),G1H4(68),G1H4(69),G1H4(70),G1H4(71),G1H4(72),4)
  call HG1shiftOLR(G1H4(68),32,4)
  call Hotf_5pt_reduction(G2H4(18),RedSet_5(71),mass5set(:,2),  & 
G1H4(73),G1H4(74),G1H4(75),G1H4(76),G1H4(77),G1H4(78),4)
  call HG1shiftOLR(G1H4(74),32,4)
  call Hotf_5pt_reduction(G2H4(19),RedSet_5(4),mass5set(:,1),  & 
G1H4(79),G1H4(80),G1H4(81),G1H4(82),G1H4(83),G1H4(84),4)
  call HG1shiftOLR(G1H4(80),8,4)
  call Hotf_5pt_reduction(G2H4(21),RedSet_5(42),mass5set(:,1),  & 
G1H4(85),G1H4(86),G1H4(87),G1H4(88),G1H4(89),G1H4(90),4)
  call HG1shiftOLR(G1H4(86),8,4)
  call Hotf_5pt_reduction(G2H4(22),RedSet_5(2),mass5set(:,1),  & 
G1H4(91),G1H4(92),G1H4(93),G1H4(94),G1H4(95),G1H4(96),4)
  call HG1shiftOLR(G1H4(92),8,4)
  call Hotf_5pt_reduction(G2H4(24),RedSet_5(43),mass5set(:,1),  & 
G1H4(97),G1H4(98),G1H4(99),G1H4(100),G1H4(101),G1H4(102),4)
  call HG1shiftOLR(G1H4(98),8,4)
  call Hotf_5pt_reduction(G2H4(25),RedSet_5(1),mass5set(:,1),  & 
G1H4(103),G1H4(104),G1H4(105),G1H4(106),G1H4(107),G1H4(108),4)
  call HG1shiftOLR(G1H4(104),4,4)
  call Hotf_5pt_reduction(G2H4(27),RedSet_5(45),mass5set(:,1),  & 
G1H4(109),G1H4(110),G1H4(111),G1H4(112),G1H4(113),G1H4(114),4)
  call HG1shiftOLR(G1H4(110),4,4)
  call Hotf_5pt_reduction(G2H4(28),RedSet_5(15),mass5set(:,5),  & 
G1H4(115),G1H4(116),G1H4(117),G1H4(118),G1H4(119),G1H4(120),4)
  call HG1shiftOLR(G1H4(116),32,4)
  call Hotf_5pt_reduction(G2H4(30),RedSet_5(50),mass5set(:,5),  & 
G1H4(121),G1H4(122),G1H4(123),G1H4(124),G1H4(125),G1H4(126),4)
  call HG1shiftOLR(G1H4(122),32,4)
  call Hotf_5pt_reduction(G2H4(31),RedSet_5(5),mass5set(:,1),  & 
G1H4(127),G1H4(128),G1H4(129),G1H4(130),G1H4(131),G1H4(132),4)
  call HG1shiftOLR(G1H4(128),4,4)
  call Hotf_5pt_reduction(G2H4(33),RedSet_5(46),mass5set(:,1),  & 
G1H4(133),G1H4(134),G1H4(135),G1H4(136),G1H4(137),G1H4(138),4)
  call HG1shiftOLR(G1H4(134),4,4)
  call Hotf_5pt_reduction(G2H4(34),RedSet_5(15),mass5set(:,5),  & 
G1H4(139),G1H4(140),G1H4(141),G1H4(142),G1H4(143),G1H4(144),4)
  call HG1shiftOLR(G1H4(140),16,4)
  call Hotf_5pt_reduction(G2H4(36),RedSet_5(48),mass5set(:,5),  & 
G1H4(145),G1H4(146),G1H4(147),G1H4(148),G1H4(149),G1H4(150),4)
  call HG1shiftOLR(G1H4(146),16,4)
  call Hotf_5pt_reduction(G2H4(37),RedSet_5(22),mass5set(:,5),  & 
G1H4(151),G1H4(152),G1H4(153),G1H4(154),G1H4(155),G1H4(156),4)
  call HG1shiftOLR(G1H4(152),32,4)
  call Hotf_5pt_reduction(G2H4(39),RedSet_5(67),mass5set(:,5),  & 
G1H4(157),G1H4(158),G1H4(159),G1H4(160),G1H4(161),G1H4(162),4)
  call HG1shiftOLR(G1H4(158),32,4)
  call Hotf_5pt_reduction(G2H4(40),RedSet_5(22),mass5set(:,5),  & 
G1H4(163),G1H4(164),G1H4(165),G1H4(166),G1H4(167),G1H4(168),4)
  call HG1shiftOLR(G1H4(164),16,4)
  call Hotf_5pt_reduction(G2H4(42),RedSet_5(66),mass5set(:,5),  & 
G1H4(169),G1H4(170),G1H4(171),G1H4(172),G1H4(173),G1H4(174),4)
  call HG1shiftOLR(G1H4(170),16,4)
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(23),mass5set(:,6),  & 
G1H8(29),G1H8(30),G1H8(31),G1H8(32),G1H8(35),G1H8(36),8)
  call HG1shiftOLR(G1H8(30),32,8)
  call Hotf_5pt_reduction(G2H8(4),RedSet_5(72),mass5set(:,6),  & 
G1H8(239),G1H8(240),G1H8(77),G1H8(37),G1H8(38),G1H8(41),8)
  call HG1shiftOLR(G1H8(240),32,8)
  call Hotf_5pt_reduction(G2H4(43),RedSet_5(24),mass5set(:,7),  & 
G1H4(175),G1H4(176),G1H4(177),G1H4(178),G1H4(179),G1H4(180),4)
  call HG1shiftOLR(G1H4(176),32,4)
  call Hotf_5pt_reduction(G2H4(46),RedSet_5(73),mass5set(:,7),  & 
G1H4(181),G1H4(182),G1H4(183),G1H4(184),G1H4(185),G1H4(186),4)
  call HG1shiftOLR(G1H4(182),32,4)
  call Hotf_5pt_reduction(G2H8(6),RedSet_5(25),mass5set(:,7),  & 
G1H8(42),G1H8(43),G1H8(44),G1H8(47),G1H8(48),G1H8(78),8)
  call HG1shiftOLR(G1H8(43),32,8)
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(58),mass5set(:,7),  & 
G1H8(95),G1H8(1),G1H8(49),G1H8(50),G1H8(53),G1H8(54),8)
  call HG1shiftOLR(G1H8(1),32,8)
  call Hotf_5pt_reduction(G2H8(10),RedSet_5(26),mass5set(:,6),  & 
G1H8(55),G1H8(56),G1H8(59),G1H8(60),G1H8(2),G1H8(5),8)
  call HG1shiftOLR(G1H8(56),16,8)
  call Hotf_5pt_reduction(G2H8(13),RedSet_5(74),mass5set(:,6),  & 
G1H8(6),G1H8(61),G1H8(62),G1H8(65),G1H8(66),G1H8(67),8)
  call HG1shiftOLR(G1H8(61),16,8)
  call Hotf_5pt_reduction(G2H4(47),RedSet_5(24),mass5set(:,7),  & 
G1H4(187),G1H4(188),G1H4(189),G1H4(190),G1H4(191),G1H4(192),4)
  call HG1shiftOLR(G1H4(188),16,4)
  call Hotf_5pt_reduction(G2H4(50),RedSet_5(75),mass5set(:,7),  & 
G1H4(193),G1H4(194),G1H4(195),G1H4(196),G1H4(197),G1H4(198),4)
  call HG1shiftOLR(G1H4(194),16,4)
  call Hotf_5pt_reduction(G2H8(17),RedSet_5(27),mass5set(:,6),  & 
G1H8(68),G1H8(71),G1H8(72),G1H8(96),G1H8(113),G1H8(114),8)
  call HG1shiftOLR(G1H8(71),32,8)
  call Hotf_5pt_reduction(G2H8(22),RedSet_5(76),mass5set(:,6),  & 
G1H8(73),G1H8(74),G1H8(79),G1H8(85),G1H8(80),G1H8(83),8)
  call HG1shiftOLR(G1H8(74),32,8)
  call Hotf_5pt_reduction(G2H8(23),RedSet_5(28),mass5set(:,6),  & 
G1H8(84),G1H8(86),G1H8(89),G1H8(90),G1H8(91),G1H8(92),8)
  call HG1shiftOLR(G1H8(86),16,8)
  call Hotf_5pt_reduction(G2H8(28),RedSet_5(77),mass5set(:,6),  & 
G1H8(97),G1H8(103),G1H8(98),G1H8(101),G1H8(102),G1H8(104),8)
  call HG1shiftOLR(G1H8(103),16,8)
  call Hotf_5pt_reduction(G2H4(51),RedSet_5(29),mass5set(:,6),  & 
G1H4(199),G1H4(200),G1H4(201),G1H4(202),G1H4(203),G1H4(204),4)
  call HG1shiftOLR(G1H4(200),16,4)
  call Hotf_5pt_reduction(G2H4(53),RedSet_5(77),mass5set(:,6),  & 
G1H4(205),G1H4(206),G1H4(207),G1H4(208),G1H4(209),G1H4(210),4)
  call HG1shiftOLR(G1H4(206),16,4)
  call Hotf_5pt_reduction(G2H4(54),RedSet_5(29),mass5set(:,6),  & 
G1H4(211),G1H4(212),G1H4(213),G1H4(214),G1H4(215),G1H4(216),4)
  call HG1shiftOLR(G1H4(212),32,4)
  call Hotf_5pt_reduction(G2H4(56),RedSet_5(76),mass5set(:,6),  & 
G1H4(217),G1H4(218),G1H4(219),G1H4(220),G1H4(221),G1H4(222),4)
  call HG1shiftOLR(G1H4(218),32,4)
  call Hotf_5pt_reduction(G2H4(57),RedSet_5(30),mass5set(:,7),  & 
G1H4(223),G1H4(224),G1H4(225),G1H4(226),G1H4(227),G1H4(228),4)
  call HG1shiftOLR(G1H4(224),32,4)
  call Hotf_5pt_reduction(G2H4(60),RedSet_5(78),mass5set(:,7),  & 
G1H4(229),G1H4(230),G1H4(231),G1H4(232),G1H4(233),G1H4(234),4)
  call HG1shiftOLR(G1H4(230),32,4)
  call Hotf_5pt_reduction(G2H8(36),RedSet_5(31),mass5set(:,7),  & 
G1H8(107),G1H8(108),G1H8(109),G1H8(110),G1H8(115),G1H8(121),8)
  call HG1shiftOLR(G1H8(108),32,8)
  call Hotf_5pt_reduction(G2H8(41),RedSet_5(65),mass5set(:,7),  & 
G1H8(116),G1H8(119),G1H8(120),G1H8(122),G1H8(125),G1H8(126),8)
  call HG1shiftOLR(G1H8(119),32,8)
  call Hotf_5pt_reduction(G2H4(61),RedSet_5(30),mass5set(:,7),  & 
G1H4(235),G1H4(236),G1H4(237),G1H4(238),G1H4(239),G1H4(240),4)
  call HG1shiftOLR(G1H4(236),16,4)
  call Hotf_5pt_reduction(G2H4(64),RedSet_5(79),mass5set(:,7),  & 
G1H4(241),G1H4(242),G1H4(243),G1H4(244),G1H4(245),G1H4(246),4)
  call HG1shiftOLR(G1H4(242),16,4)
  call Hotf_5pt_reduction(G2H4(65),RedSet_5(32),mass5set(:,6),  & 
G1H4(247),G1H4(248),G1H4(249),G1H4(250),G1H4(251),G1H4(252),4)
  call HG1shiftOLR(G1H4(248),16,4)
  call Hotf_5pt_reduction(G2H4(67),RedSet_5(74),mass5set(:,6),  & 
G1H4(253),G1H4(254),G1H4(255),G1H4(256),G1H4(257),G1H4(258),4)
  call HG1shiftOLR(G1H4(254),16,4)
  call Hotf_5pt_reduction(G2H4(68),RedSet_5(32),mass5set(:,6),  & 
G1H4(259),G1H4(260),G1H4(261),G1H4(262),G1H4(263),G1H4(264),4)
  call HG1shiftOLR(G1H4(260),32,4)
  call Hotf_5pt_reduction(G2H4(70),RedSet_5(72),mass5set(:,6),  & 
G1H4(265),G1H4(266),G1H4(267),G1H4(268),G1H4(269),G1H4(270),4)
  call HG1shiftOLR(G1H4(266),32,4)
  call Hotf_5pt_reduction(G2H4(71),RedSet_5(33),mass5set(:,8),  & 
G1H4(271),G1H4(272),G1H4(273),G1H4(274),G1H4(275),G1H4(276),4)
  call HG1shiftOLR(G1H4(272),32,4)
  call Hotf_5pt_reduction(G2H4(74),RedSet_5(73),mass5set(:,7),  & 
G1H4(277),G1H4(278),G1H4(279),G1H4(280),G1H4(281),G1H4(282),4)
  call HG1shiftOLR(G1H4(278),32,4)
  call Hotf_5pt_reduction(G2H4(75),RedSet_5(34),mass5set(:,8),  & 
G1H4(283),G1H4(284),G1H4(285),G1H4(286),G1H4(287),G1H4(288),4)
  call HG1shiftOLR(G1H4(284),16,4)
  call Hotf_5pt_reduction(G2H4(78),RedSet_5(75),mass5set(:,7),  & 
G1H4(289),G1H4(290),G1H4(291),G1H4(292),G1H4(293),G1H4(294),4)
  call HG1shiftOLR(G1H4(290),16,4)
  call Hotf_5pt_reduction(G2H8(50),RedSet_5(35),mass5set(:,9),  & 
G1H8(127),G1H8(128),G1H8(133),G1H8(139),G1H8(134),G1H8(137),8)
  call HG1shiftOLR(G1H8(128),32,8)
  call Hotf_5pt_reduction(G2H8(55),RedSet_5(54),mass5set(:,9),  & 
G1H8(138),G1H8(140),G1H8(143),G1H8(144),G1H8(145),G1H8(146),8)
  call HG1shiftOLR(G1H8(140),32,8)
  call Hotf_5pt_reduction(G2H4(79),RedSet_5(34),mass5set(:,8),  & 
G1H4(295),G1H4(296),G1H4(297),G1H4(298),G1H4(299),G1H4(300),4)
  call HG1shiftOLR(G1H4(296),4,4)
  call Hotf_5pt_reduction(G2H4(82),RedSet_5(80),mass5set(:,8),  & 
G1H4(301),G1H4(302),G1H4(303),G1H4(304),G1H4(305),G1H4(306),4)
  call HG1shiftOLR(G1H4(302),4,4)
  call Hotf_5pt_reduction(G2H4(83),RedSet_5(36),mass5set(:,8),  & 
G1H4(307),G1H4(308),G1H4(309),G1H4(310),G1H4(311),G1H4(312),4)
  call HG1shiftOLR(G1H4(308),32,4)
  call Hotf_5pt_reduction(G2H4(86),RedSet_5(78),mass5set(:,7),  & 
G1H4(313),G1H4(314),G1H4(315),G1H4(316),G1H4(317),G1H4(318),4)
  call HG1shiftOLR(G1H4(314),32,4)
  call Hotf_5pt_reduction(G2H8(59),RedSet_5(37),mass5set(:,9),  & 
G1H8(151),G1H8(157),G1H8(152),G1H8(155),G1H8(156),G1H8(158),8)
  call HG1shiftOLR(G1H8(157),32,8)
  call Hotf_5pt_reduction(G2H8(64),RedSet_5(63),mass5set(:,9),  & 
G1H8(161),G1H8(162),G1H8(163),G1H8(164),G1H8(169),G1H8(175),8)
  call HG1shiftOLR(G1H8(162),32,8)
  call Hotf_5pt_reduction(G2H4(87),RedSet_5(36),mass5set(:,8),  & 
G1H4(319),G1H4(320),G1H4(321),G1H4(322),G1H4(323),G1H4(324),4)
  call HG1shiftOLR(G1H4(320),8,4)
  call Hotf_5pt_reduction(G2H4(90),RedSet_5(81),mass5set(:,8),  & 
G1H4(325),G1H4(326),G1H4(327),G1H4(328),G1H4(329),G1H4(330),4)
  call HG1shiftOLR(G1H4(326),8,4)
  call Hotf_5pt_reduction(G2H4(91),RedSet_5(33),mass5set(:,8),  & 
G1H4(331),G1H4(332),G1H4(333),G1H4(334),G1H4(335),G1H4(336),4)
  call HG1shiftOLR(G1H4(332),4,4)
  call Hotf_5pt_reduction(G2H4(94),RedSet_5(80),mass5set(:,8),  & 
G1H4(337),G1H4(338),G1H4(339),G1H4(340),G1H4(341),G1H4(342),4)
  call HG1shiftOLR(G1H4(338),4,4)
  call Hotf_5pt_reduction(G2H8(69),RedSet_5(38),mass5set(:,9),  & 
G1H8(170),G1H8(173),G1H8(174),G1H8(176),G1H8(179),G1H8(180),8)
  call HG1shiftOLR(G1H8(173),16,8)
  call Hotf_5pt_reduction(G2H8(73),RedSet_5(62),mass5set(:,9),  & 
G1H8(7),G1H8(11),G1H8(12),G1H8(167),G1H8(168),G1H8(186),8)
  call HG1shiftOLR(G1H8(11),16,8)
  call Hotf_5pt_reduction(G2H4(95),RedSet_5(39),mass5set(:,8),  & 
G1H4(343),G1H4(344),G1H4(345),G1H4(346),G1H4(347),G1H4(348),4)
  call HG1shiftOLR(G1H4(344),16,4)
  call Hotf_5pt_reduction(G2H4(98),RedSet_5(79),mass5set(:,7),  & 
G1H4(349),G1H4(350),G1H4(351),G1H4(352),G1H4(353),G1H4(354),4)
  call HG1shiftOLR(G1H4(350),16,4)
  call Hotf_5pt_reduction(G2H4(99),RedSet_5(39),mass5set(:,8),  & 
G1H4(355),G1H4(356),G1H4(357),G1H4(358),G1H4(359),G1H4(360),4)
  call HG1shiftOLR(G1H4(356),8,4)
  call Hotf_5pt_reduction(G2H4(102),RedSet_5(81),mass5set(:,8),  & 
G1H4(361),G1H4(362),G1H4(363),G1H4(364),G1H4(365),G1H4(366),4)
  call HG1shiftOLR(G1H4(362),8,4)
  call Hotf_5pt_reduction(G2H8(77),RedSet_5(40),mass5set(:,9),  & 
G1H8(203),G1H8(18),G1H8(221),G1H8(222),G1H8(20),G1H8(23),8)
  call HG1shiftOLR(G1H8(18),16,8)
  call Hotf_5pt_reduction(G2H8(82),RedSet_5(56),mass5set(:,9),  & 
G1H8(25),G1H8(26),G1H8(181),G1H8(182),G1H8(187),G1H8(193),8)
  call HG1shiftOLR(G1H8(26),16,8)
  call Hloop_AQ_V(ntryL,G2H4(103),ex3(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_AQ_V(ntryL,G2H4(106),ex3(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_AQ_V(ntryL,G2H4(112),ex3(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_AQ_V(ntryL,G2H4(113),ex3(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_AQ_V(ntryL,G2H4(116),ex3(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_V(ntryL,G2H4(122),ex3(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_QA_V(ntryL,G2H4(123),ex4(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_QA_V(ntryL,G2H4(126),ex4(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_QA_V(ntryL,G2H4(132),ex4(:),G2H2(9),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_QA_V(ntryL,G2H4(133),ex4(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_QA_V(ntryL,G2H4(136),ex4(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_QA_V(ntryL,G2H4(142),ex4(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_AQ_V(ntryL,G2H4(143),ex3(:),G2H2(13),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_AQ_V(ntryL,G2H4(146),ex3(:),G2H2(14),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_AQ_V(ntryL,G2H4(152),ex3(:),G2H2(15),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_AQ_V(ntryL,G2H4(153),ex3(:),G2H2(16),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_AQ_V(ntryL,G2H4(156),ex3(:),G2H2(17),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_AQ_V(ntryL,G2H4(162),ex3(:),G2H2(18),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hotf_5pt_reduction(G2H4(163),RedSet_5(11),mass5set(:,3),  & 
G1H4(367),G1H4(368),G1H4(369),G1H4(370),G1H4(371),G1H4(372),4)
  call HG1shiftOLR(G1H4(368),8,4)
  call Hotf_5pt_reduction(G2H4(165),RedSet_5(52),mass5set(:,3),  & 
G1H4(373),G1H4(374),G1H4(375),G1H4(376),G1H4(377),G1H4(378),4)
  call HG1shiftOLR(G1H4(374),8,4)
  call Hotf_4pt_reduction(G2H4(169),RedSet_4(1),mass4set(:,1),  & 
G1H4(379),G1H4(380),G1H4(381),G1H4(382),G1H4(383),4)
  call HG1shiftOLR(G1H4(380),43,4)
  call Hloop_QA_V(ntryL,G2H4(170),ex4(:),G2H2(19),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_QA_V(ntryL,G2H4(172),ex4(:),G2H2(20),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_QA_V(ntryL,G2H4(176),ex4(:),G2H2(21),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hotf_5pt_reduction(G2H8(104),RedSet_5(12),mass5set(:,3),  & 
G1H8(188),G1H8(191),G1H8(192),G1H8(194),G1H8(197),G1H8(198),8)
  call HG1shiftOLR(G1H8(191),8,8)
  call Hotf_5pt_reduction(G2H8(107),RedSet_5(52),mass5set(:,3),  & 
G1H8(199),G1H8(200),G1H8(205),G1H8(211),G1H8(206),G1H8(209),8)
  call HG1shiftOLR(G1H8(200),8,8)
  call Hotf_4pt_reduction(G2H8(112),RedSet_4(1),mass4set(:,1),  & 
G1H8(210),G1H8(212),G1H8(215),G1H8(216),G1H8(217),8)
  call HG1shiftOLR(G1H8(212),43,8)
  call Hloop_AQ_V(ntryL,G2H4(177),ex3(:),G2H2(22),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_AQ_V(ntryL,G2H4(179),ex3(:),G2H2(23),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_AQ_V(ntryL,G2H4(183),ex3(:),G2H2(24),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_QA_V(ntryL,G2H4(184),ex4(:),G2H2(25),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_QA_V(ntryL,G2H4(186),ex4(:),G2H2(26),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_QA_V(ntryL,G2H4(190),ex4(:),G2H2(27),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hotf_5pt_reduction(G2H4(191),RedSet_5(16),mass5set(:,3),  & 
G1H4(384),G1H4(385),G1H4(386),G1H4(387),G1H4(388),G1H4(389),4)
  call HG1shiftOLR(G1H4(385),8,4)
  call Hotf_5pt_reduction(G2H4(193),RedSet_5(60),mass5set(:,3),  & 
G1H4(390),G1H4(391),G1H4(392),G1H4(393),G1H4(394),G1H4(395),4)
  call HG1shiftOLR(G1H4(391),8,4)
  call Hotf_4pt_reduction(G2H4(197),RedSet_4(2),mass4set(:,1),  & 
G1H4(396),G1H4(397),G1H4(398),G1H4(399),G1H4(400),4)
  call HG1shiftOLR(G1H4(397),27,4)
  call Hloop_QA_V(ntryL,G2H4(198),ex4(:),G2H2(28),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_QA_V(ntryL,G2H4(200),ex4(:),G2H2(29),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_QA_V(ntryL,G2H4(204),ex4(:),G2H2(30),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hotf_5pt_reduction(G2H8(42),RedSet_5(17),mass5set(:,3),  & 
G1H8(218),G1H8(223),G1H8(229),G1H8(224),G1H8(227),G1H8(228),8)
  call HG1shiftOLR(G1H8(223),8,8)
  call Hotf_5pt_reduction(G2H8(47),RedSet_5(60),mass5set(:,3),  & 
G1H8(230),G1H8(233),G1H8(234),G1H8(235),G1H8(236),G1H8(241),8)
  call HG1shiftOLR(G1H8(233),8,8)
  call Hotf_4pt_reduction(G2H8(66),RedSet_4(2),mass4set(:,1),  & 
G1H8(247),G1H8(242),G1H8(245),G1H8(246),G1H8(248),8)
  call HG1shiftOLR(G1H8(242),27,8)
  call Hloop_AQ_V(ntryL,G2H4(205),ex3(:),G2H2(31),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_AQ_V(ntryL,G2H4(207),ex3(:),G2H2(32),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_AQ_V(ntryL,G2H4(211),ex3(:),G2H2(33),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_AQ_V(ntryL,G2H4(212),ex3(:),G2H2(34),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_AQ_V(ntryL,G2H4(214),ex3(:),G2H2(35),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_AQ_V(ntryL,G2H4(218),ex3(:),G2H2(36),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_QA_V(ntryL,G2H4(219),ex4(:),G2H2(37),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_QA_V(ntryL,G2H4(222),ex4(:),G2H2(38),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_QA_V(ntryL,G2H4(228),ex4(:),G2H2(39),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_QA_V(ntryL,G2H4(229),ex4(:),G2H2(40),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_QA_V(ntryL,G2H4(232),ex4(:),G2H2(41),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_QA_V(ntryL,G2H4(238),ex4(:),G2H2(42),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hotf_5pt_reduction(G2H4(239),RedSet_5(20),mass5set(:,3),  & 
G1H4(401),G1H4(402),G1H4(403),G1H4(404),G1H4(405),G1H4(406),4)
  call HG1shiftOLR(G1H4(402),8,4)
  call Hotf_5pt_reduction(G2H4(241),RedSet_5(68),mass5set(:,3),  & 
G1H4(407),G1H4(408),G1H4(409),G1H4(410),G1H4(411),G1H4(412),4)
  call HG1shiftOLR(G1H4(408),8,4)
  call Hotf_4pt_reduction(G2H4(245),RedSet_4(3),mass4set(:,1),  & 
G1H4(413),G1H4(414),G1H4(415),G1H4(416),G1H4(417),4)
  call HG1shiftOLR(G1H4(414),56,4)
  call Hotf_5pt_reduction(G2H4(246),RedSet_5(21),mass5set(:,3),  & 
G1H4(418),G1H4(419),G1H4(420),G1H4(421),G1H4(422),G1H4(423),4)
  call HG1shiftOLR(G1H4(419),8,4)
  call Hotf_5pt_reduction(G2H4(248),RedSet_5(68),mass5set(:,3),  & 
G1H4(424),G1H4(425),G1H4(426),G1H4(427),G1H4(428),G1H4(429),4)
  call HG1shiftOLR(G1H4(425),8,4)
  call Hotf_4pt_reduction(G2H4(252),RedSet_4(3),mass4set(:,1),  & 
G1H4(430),G1H4(431),G1H4(432),G1H4(433),G1H4(434),4)
  call HG1shiftOLR(G1H4(431),56,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(13),[G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(25),[G1H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(37),[G1H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(49),[G1H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(61),[G1H4(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(73),[G1H4(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(85),[G1H4(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(97),[G1H4(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(109),[G1H4(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(121),[G1H4(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(133),[G1H4(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(145),[G1H4(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(157),[G1H4(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(169),[G1H4(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(239),[G1H8(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(181),[G1H4(180)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(95),[G1H8(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(6),[G1H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(193),[G1H4(192)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(73),[G1H8(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(97),[G1H8(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(205),[G1H4(204)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(217),[G1H4(216)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(229),[G1H4(228)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(116),[G1H8(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(241),[G1H4(240)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(253),[G1H4(252)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(265),[G1H4(264)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(277),[G1H4(276)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(289),[G1H4(288)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(138),[G1H8(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(301),[G1H4(300)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(313),[G1H4(312)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(161),[G1H8(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(325),[G1H4(324)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(337),[G1H4(336)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(7),[G1H8(180)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(349),[G1H4(348)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(361),[G1H4(360)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(25),[G1H8(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(373),[G1H4(372)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(379),[G1H4(378)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(199),[G1H8(198)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(210),[G1H8(209)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(390),[G1H4(389)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(396),[G1H4(395)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(230),[G1H8(228)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(247),[G1H8(241)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(407),[G1H4(406)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(413),[G1H4(412)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(424),[G1H4(423)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(430),[G1H4(429)])
  call Hloop_VQ_A(ntryL,G1H4(7),ex3(:),G1H2(1),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(1),111,nMT,G2H2(43),n2h2(1))
call HGT_OLR(G1H4(8),1,1,4)
call HGT_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(8),-16,nMT,G2H4(1),n2h4(151))
  call Hloop_AV_Q(ntryL,G2H4(1),ex5(:),G2H2(44),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_VQ_A(ntryL,G1H4(13),ex3(:),G1H2(1),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(1),111,nMT,G2H2(45),n2h2(2))
call HGT_OLR(G1H4(14),1,1,4)
call HGT_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(14),-16,nMT,G2H4(3),n2h4(152))
  call Hloop_AV_Q(ntryL,G2H4(3),ex5(:),G2H2(46),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_VQ_A(ntryL,G1H4(18),ex3(:),G1H2(1),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_Q_A(ntryL,G1H2(1),111,nMT,G2H2(47),n2h2(3))
  call Hloop_VA_Q(ntryL,G1H4(19),ex4(:),G1H2(1),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_A_Q(ntryL,G1H2(1),95,nMT,G2H2(48),n2h2(4))
call HGT_OLR(G1H4(20),1,1,4)
call HGT_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(20),-32,nMT,G2H4(4),n2h4(153))
  call Hloop_QV_A(ntryL,G2H4(4),ex6(:),G2H2(49),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_VA_Q(ntryL,G1H4(25),ex4(:),G1H2(1),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_A_Q(ntryL,G1H2(1),95,nMT,G2H2(50),n2h2(5))
call HGT_OLR(G1H4(26),1,1,4)
call HGT_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(26),-32,nMT,G2H4(6),n2h4(154))
  call Hloop_QV_A(ntryL,G2H4(6),ex6(:),G2H2(51),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_VA_Q(ntryL,G1H4(30),ex4(:),G1H2(1),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_A_Q(ntryL,G1H2(1),95,nMT,G2H2(52),n2h2(6))
  call Hloop_VA_Q(ntryL,G1H4(31),ex4(:),G1H2(1),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_A_Q(ntryL,G1H2(1),111,nMT,G2H2(53),n2h2(7))
call HGT_OLR(G1H4(32),1,1,4)
call HGT_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(32),-16,nMT,G2H4(7),n2h4(155))
  call Hloop_QV_A(ntryL,G2H4(7),ex5(:),G2H2(54),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_VA_Q(ntryL,G1H4(37),ex4(:),G1H2(1),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_A_Q(ntryL,G1H2(1),111,nMT,G2H2(55),n2h2(8))
call HGT_OLR(G1H4(38),1,1,4)
call HGT_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(38),-16,nMT,G2H4(9),n2h4(156))
  call Hloop_QV_A(ntryL,G2H4(9),ex5(:),G2H2(56),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_VA_Q(ntryL,G1H4(42),ex4(:),G1H2(1),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_A_Q(ntryL,G1H2(1),111,nMT,G2H2(57),n2h2(9))
  call Hloop_VQ_A(ntryL,G1H4(43),ex3(:),G1H2(1),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMT,G2H2(58),n2h2(10))
call HGT_OLR(G1H4(44),1,1,4)
call HGT_invQ_OLR(G1H4(44),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(44),-32,nMT,G2H4(10),n2h4(157))
  call Hloop_AV_Q(ntryL,G2H4(10),ex6(:),G2H2(59),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_VQ_A(ntryL,G1H4(49),ex3(:),G1H2(1),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMT,G2H2(60),n2h2(11))
call HGT_OLR(G1H4(50),1,1,4)
call HGT_invQ_OLR(G1H4(50),2,5,4)



end subroutine vamp_1

end module ol_vamp_1_ppllttj_nenexttxggg_1_/**/REALKIND
