
module ol_vamp_1_ppllttj_eexttxggg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllttj_eexttxggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllttj_eexttxggg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppllttj_eexttxggg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppllttj_eexttxggg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppllttj_eexttxggg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppllttj_eexttxggg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(128)
  type(Hpolcont), intent(in) :: M(11,128)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(23)*M(4,:)%j-c(24)*M(10,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1),h0tab(:,1),[64,3,32,8,4,16],[nMT,nMT,nMT,0,nMT,nMT],6,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1),heltab2x128(:,:,1))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(1),n2h64(1))
  Gcoeff(:)%j = (-(c(29)*M(4,:)%j)+c(30)*M(10,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(2),h0tab(:,2),[64,3,32,8,4,16],[nMT,nMT,nMT,0,nMT,nMT],6,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,2),heltab2x128(:,:,2))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(2),n2h64(2))
  Gcoeff(:)%j = (c(23)*M(4,:)%j-c(24)*M(10,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(3),h0tab(:,3),[64,3,16,4,8,32],[nMT,nMT,nMT,0,nMT,nMT],6,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,3),heltab2x128(:,:,3))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(3),n2h64(3))
  Gcoeff(:)%j = (-(c(29)*M(4,:)%j)+c(30)*M(10,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(4),h0tab(:,4),[64,3,16,4,8,32],[nMT,nMT,nMT,0,nMT,nMT],6,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,4),heltab2x128(:,:,4))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(4),n2h64(4))
  Gcoeff(:)%j = (c(23)*M(6,:)%j-c(24)*M(11,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(5),h0tab(:,5),[64,3,32,16,4,8],[nMT,nMT,nMT,nMT,0,nMT],6,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,5),heltab2x128(:,:,5))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(5),n2h64(5))
  Gcoeff(:)%j = (-(c(29)*M(6,:)%j)+c(30)*M(11,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(6),h0tab(:,6),[64,3,32,16,4,8],[nMT,nMT,nMT,nMT,0,nMT],6,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,6),heltab2x128(:,:,6))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(6),n2h64(6))
  Gcoeff(:)%j = (c(23)*M(6,:)%j-c(24)*M(11,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(7),h0tab(:,7),[64,8,4,16,3,32],[nMT,0,nMT,nMT,nMT,nMT],6,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,7),heltab2x128(:,:,7))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(7),n2h64(7))
  Gcoeff(:)%j = (-(c(29)*M(6,:)%j)+c(30)*M(11,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(8),h0tab(:,8),[64,8,4,16,3,32],[nMT,0,nMT,nMT,nMT,nMT],6,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,8),heltab2x128(:,:,8))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(8),n2h64(8))
  Gcoeff(:)%j = (c(23)*M(6,:)%j-c(24)*M(11,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(9),h0tab(:,9),[64,3,8,4,16,32],[nMT,nMT,0,nMT,nMT,nMT],6,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,9),heltab2x128(:,:,9))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(9),n2h64(9))
  Gcoeff(:)%j = (-(c(29)*M(6,:)%j)+c(30)*M(11,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(10),h0tab(:,10),[64,3,8,4,16,32],[nMT,nMT,0,nMT,nMT,nMT],6,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,10),heltab2x128(:,:,10))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(10),n2h64(10))
  Gcoeff(:)%j = (c(23)*M(4,:)%j-c(24)*M(10,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(11),h0tab(:,11),[64,16,4,8,3,32],[nMT,nMT,0,nMT,nMT,nMT],6,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,11),heltab2x128(:,:,11))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(11),n2h64(11))
  Gcoeff(:)%j = (-(c(29)*M(4,:)%j)+c(30)*M(10,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(12),h0tab(:,12),[64,16,4,8,3,32],[nMT,nMT,0,nMT,nMT,nMT],6,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,12),heltab2x128(:,:,12))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(12),n2h64(12))
  Gcoeff(:)%j = (c(23)*M(2,:)%j-c(24)*M(11,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(13),h0tab(:,13),[64,3,32,4,8,16],[nMT,nMT,nMT,0,nMT,nMT],6,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,13),heltab2x128(:,:,13))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(13),n2h64(13))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)+c(30)*M(11,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(14),h0tab(:,14),[64,3,32,4,8,16],[nMT,nMT,nMT,0,nMT,nMT],6,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,14),heltab2x128(:,:,14))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(14),n2h64(14))
  Gcoeff(:)%j = (c(23)*M(2,:)%j-c(24)*M(11,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(15),h0tab(:,15),[64,3,16,8,4,32],[nMT,nMT,nMT,0,nMT,nMT],6,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,15),heltab2x128(:,:,15))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(15),n2h64(15))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)+c(30)*M(11,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(16),h0tab(:,16),[64,3,16,8,4,32],[nMT,nMT,nMT,0,nMT,nMT],6,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,16),heltab2x128(:,:,16))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(16),n2h64(16))
  Gcoeff(:)%j = (c(23)*M(5,:)%j-c(24)*M(10,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(17),h0tab(:,17),[64,3,16,32,4,8],[nMT,nMT,nMT,nMT,0,nMT],6,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,17),heltab2x128(:,:,17))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(17),n2h64(17))
  Gcoeff(:)%j = (-(c(29)*M(5,:)%j)+c(30)*M(10,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(18),h0tab(:,18),[64,3,16,32,4,8],[nMT,nMT,nMT,nMT,0,nMT],6,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,18),heltab2x128(:,:,18))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(18),n2h64(18))
  Gcoeff(:)%j = (c(23)*M(5,:)%j-c(24)*M(10,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(19),h0tab(:,19),[64,8,4,32,3,16],[nMT,0,nMT,nMT,nMT,nMT],6,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,19),heltab2x128(:,:,19))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(19),n2h64(19))
  Gcoeff(:)%j = (-(c(29)*M(5,:)%j)+c(30)*M(10,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(20),h0tab(:,20),[64,8,4,32,3,16],[nMT,0,nMT,nMT,nMT,nMT],6,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,20),heltab2x128(:,:,20))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(20),n2h64(20))
  Gcoeff(:)%j = (c(23)*M(5,:)%j-c(24)*M(10,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(21),h0tab(:,21),[64,3,8,4,32,16],[nMT,nMT,0,nMT,nMT,nMT],6,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,21),heltab2x128(:,:,21))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(21),n2h64(21))
  Gcoeff(:)%j = (-(c(29)*M(5,:)%j)+c(30)*M(10,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(22),h0tab(:,22),[64,3,8,4,32,16],[nMT,nMT,0,nMT,nMT,nMT],6,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,22),heltab2x128(:,:,22))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(22),n2h64(22))
  Gcoeff(:)%j = (c(23)*M(2,:)%j-c(24)*M(11,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(23),h0tab(:,23),[64,16,3,8,4,32],[nMT,nMT,nMT,0,nMT,nMT],6,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,23),heltab2x128(:,:,23))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(23),n2h64(23))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)+c(30)*M(11,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(24),h0tab(:,24),[64,16,3,8,4,32],[nMT,nMT,nMT,0,nMT,nMT],6,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,24),heltab2x128(:,:,24))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(24),n2h64(24))
  Gcoeff(:)%j = (c(23)*M(1,:)%j-c(24)*M(10,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(25),h0tab(:,25),[64,3,32,16,8,4],[nMT,nMT,nMT,nMT,0,nMT],6,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,25),heltab2x128(:,:,25))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(25),n2h64(25))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)+c(30)*M(10,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(26),h0tab(:,26),[64,3,32,16,8,4],[nMT,nMT,nMT,nMT,0,nMT],6,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,26),heltab2x128(:,:,26))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(26),n2h64(26))
  Gcoeff(:)%j = (c(23)*M(1,:)%j-c(24)*M(10,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(27),h0tab(:,27),[64,4,8,16,3,32],[nMT,0,nMT,nMT,nMT,nMT],6,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,27),heltab2x128(:,:,27))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(27),n2h64(27))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)+c(30)*M(10,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(28),h0tab(:,28),[64,4,8,16,3,32],[nMT,0,nMT,nMT,nMT,nMT],6,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,28),heltab2x128(:,:,28))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(28),n2h64(28))
  Gcoeff(:)%j = (c(23)*M(3,:)%j-c(24)*M(11,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(29),h0tab(:,29),[64,3,16,32,8,4],[nMT,nMT,nMT,nMT,0,nMT],6,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,29),heltab2x128(:,:,29))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(29),n2h64(29))
  Gcoeff(:)%j = (-(c(29)*M(3,:)%j)+c(30)*M(11,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(30),h0tab(:,30),[64,3,16,32,8,4],[nMT,nMT,nMT,nMT,0,nMT],6,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,30),heltab2x128(:,:,30))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(30),n2h64(30))
  Gcoeff(:)%j = (c(23)*M(3,:)%j-c(24)*M(11,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(31),h0tab(:,31),[64,4,8,32,3,16],[nMT,0,nMT,nMT,nMT,nMT],6,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,31),heltab2x128(:,:,31))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(31),n2h64(31))
  Gcoeff(:)%j = (-(c(29)*M(3,:)%j)+c(30)*M(11,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(32),h0tab(:,32),[64,4,8,32,3,16],[nMT,0,nMT,nMT,nMT,nMT],6,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,32),heltab2x128(:,:,32))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(32),n2h64(32))
  Gcoeff(:)%j = (c(23)*M(3,:)%j-c(24)*M(11,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(33),h0tab(:,33),[64,4,8,3,32,16],[nMT,0,nMT,nMT,nMT,nMT],6,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,33),heltab2x128(:,:,33))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(33),n2h64(33))
  Gcoeff(:)%j = (-(c(29)*M(3,:)%j)+c(30)*M(11,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(34),h0tab(:,34),[64,4,8,3,32,16],[nMT,0,nMT,nMT,nMT,nMT],6,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,34),heltab2x128(:,:,34))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(34),n2h64(34))
  Gcoeff(:)%j = (c(23)*M(1,:)%j-c(24)*M(10,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(35),h0tab(:,35),[64,4,8,3,16,32],[nMT,0,nMT,nMT,nMT,nMT],6,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,35),heltab2x128(:,:,35))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(35),n2h64(35))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)+c(30)*M(10,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(36),h0tab(:,36),[64,4,8,3,16,32],[nMT,0,nMT,nMT,nMT,nMT],6,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,36),heltab2x128(:,:,36))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(36),n2h64(36))
  Gcoeff(:)%j = (c(23)*M(1,:)%j-c(24)*M(10,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(37),h0tab(:,37),[64,3,4,8,16,32],[nMT,nMT,0,nMT,nMT,nMT],6,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,37),heltab2x128(:,:,37))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(37),n2h64(37))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)+c(30)*M(10,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(38),h0tab(:,38),[64,3,4,8,16,32],[nMT,nMT,0,nMT,nMT,nMT],6,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,38),heltab2x128(:,:,38))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(38),n2h64(38))
  Gcoeff(:)%j = (c(23)*M(2,:)%j-c(24)*M(11,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(39),h0tab(:,39),[64,16,8,4,3,32],[nMT,nMT,0,nMT,nMT,nMT],6,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,39),heltab2x128(:,:,39))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(39),n2h64(39))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)+c(30)*M(11,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(40),h0tab(:,40),[64,16,8,4,3,32],[nMT,nMT,0,nMT,nMT,nMT],6,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,40),heltab2x128(:,:,40))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(40),n2h64(40))
  Gcoeff(:)%j = (c(23)*M(3,:)%j-c(24)*M(11,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(41),h0tab(:,41),[64,3,4,8,32,16],[nMT,nMT,0,nMT,nMT,nMT],6,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,41),heltab2x128(:,:,41))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(41),n2h64(41))
  Gcoeff(:)%j = (-(c(29)*M(3,:)%j)+c(30)*M(11,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(42),h0tab(:,42),[64,3,4,8,32,16],[nMT,nMT,0,nMT,nMT,nMT],6,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,42),heltab2x128(:,:,42))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(42),n2h64(42))
  Gcoeff(:)%j = (c(23)*M(4,:)%j-c(24)*M(10,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(43),h0tab(:,43),[64,16,3,4,8,32],[nMT,nMT,nMT,0,nMT,nMT],6,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,43),heltab2x128(:,:,43))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(43),n2h64(43))
  Gcoeff(:)%j = (-(c(29)*M(4,:)%j)+c(30)*M(10,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(44),h0tab(:,44),[64,16,3,4,8,32],[nMT,nMT,nMT,0,nMT,nMT],6,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,44),heltab2x128(:,:,44))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(44),n2h64(44))
  Gcoeff(:)%j = (c(23)*M(5,:)%j-c(24)*M(10,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(45),h0tab(:,45),[64,8,4,3,32,16],[nMT,0,nMT,nMT,nMT,nMT],6,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,45),heltab2x128(:,:,45))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(45),n2h64(45))
  Gcoeff(:)%j = (-(c(29)*M(5,:)%j)+c(30)*M(10,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(46),h0tab(:,46),[64,8,4,3,32,16],[nMT,0,nMT,nMT,nMT,nMT],6,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,46),heltab2x128(:,:,46))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(46),n2h64(46))
  Gcoeff(:)%j = (c(23)*M(6,:)%j-c(24)*M(11,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(47),h0tab(:,47),[64,8,4,3,16,32],[nMT,0,nMT,nMT,nMT,nMT],6,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,47),heltab2x128(:,:,47))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(47),n2h64(47))
  Gcoeff(:)%j = (-(c(29)*M(6,:)%j)+c(30)*M(11,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(48),h0tab(:,48),[64,8,4,3,16,32],[nMT,0,nMT,nMT,nMT,nMT],6,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,48),heltab2x128(:,:,48))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(48),n2h64(48))
  Gcoeff(:)%j = (c(6)*(-M(9,:)%j+M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(49),h0tab(:,49),[64,3,32,4,16,8],[nMT,nMT,nMT,0,0,nMT],6,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,49),heltab2x128(:,:,49))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(49),n2h64(49))
  Gcoeff(:)%j = (c(11)*(M(9,:)%j-M(11,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(50),h0tab(:,50),[64,3,32,4,16,8],[nMT,nMT,nMT,0,0,nMT],6,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,50),heltab2x128(:,:,50))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(50),n2h64(50))
  Gcoeff(:)%j = (c(6)*(M(9,:)%j-M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(51),h0tab(:,51),[64,3,8,16,4,32],[nMT,nMT,0,0,nMT,nMT],6,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,51),heltab2x128(:,:,51))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(51),n2h64(51))
  Gcoeff(:)%j = (c(11)*(-M(9,:)%j+M(11,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(52),h0tab(:,52),[64,3,8,16,4,32],[nMT,nMT,0,0,nMT,nMT],6,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,52),heltab2x128(:,:,52))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(52),n2h64(52))
  Gcoeff(:)%j = (c(6)*(-M(8,:)%j+M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(53),h0tab(:,53),[64,3,16,4,32,8],[nMT,nMT,nMT,0,0,nMT],6,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,53),heltab2x128(:,:,53))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(53),n2h64(53))
  Gcoeff(:)%j = (c(11)*(M(8,:)%j-M(10,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(54),h0tab(:,54),[64,3,16,4,32,8],[nMT,nMT,nMT,0,0,nMT],6,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,54),heltab2x128(:,:,54))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(54),n2h64(54))
  Gcoeff(:)%j = (c(6)*(M(8,:)%j-M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(55),h0tab(:,55),[64,3,8,32,4,16],[nMT,nMT,0,0,nMT,nMT],6,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,55),heltab2x128(:,:,55))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(55),n2h64(55))
  Gcoeff(:)%j = (c(11)*(-M(8,:)%j+M(10,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(56),h0tab(:,56),[64,3,8,32,4,16],[nMT,nMT,0,0,nMT,nMT],6,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,56),heltab2x128(:,:,56))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(56),n2h64(56))
  Gcoeff(:)%j = (c(24)*(M(7,:)%j+M(9,:)%j-M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(57),h0tab(:,57),[64,8,3,32,4,16],[0,nMT,nMT,nMT,0,0],6,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(57),m3h2x64(:,57),heltab2x128(:,:,57))
  Gcoeff(:)%j = (c(30)*(-M(7,:)%j-M(9,:)%j+M(11,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(58),h0tab(:,58),[64,8,3,32,4,16],[0,nMT,nMT,nMT,0,0],6,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(58),m3h2x64(:,58),heltab2x128(:,:,58))
  Gcoeff(:)%j = (c(24)*(M(7,:)%j+M(8,:)%j-M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(59),h0tab(:,59),[64,8,3,16,4,32],[0,nMT,nMT,nMT,0,0],6,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(59),m3h2x64(:,59),heltab2x128(:,:,59))
  Gcoeff(:)%j = (c(30)*(-M(7,:)%j-M(8,:)%j+M(10,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(60),h0tab(:,60),[64,8,3,16,4,32],[0,nMT,nMT,nMT,0,0],6,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(60),m3h2x64(:,60),heltab2x128(:,:,60))
  Gcoeff(:)%j = (c(6)*(M(9,:)%j-M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(61),h0tab(:,61),[64,3,32,8,16,4],[nMT,nMT,nMT,0,0,nMT],6,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,61),heltab2x128(:,:,61))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(61),n2h64(57))
  Gcoeff(:)%j = (c(11)*(-M(9,:)%j+M(10,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(62),h0tab(:,62),[64,3,32,8,16,4],[nMT,nMT,nMT,0,0,nMT],6,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,62),heltab2x128(:,:,62))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(62),n2h64(58))
  Gcoeff(:)%j = (c(6)*(-M(9,:)%j+M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(63),h0tab(:,63),[64,4,16,8,3,32],[nMT,0,0,nMT,nMT,nMT],6,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,63),heltab2x128(:,:,63))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(63),n2h64(59))
  Gcoeff(:)%j = (c(11)*(M(9,:)%j-M(10,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(64),h0tab(:,64),[64,4,16,8,3,32],[nMT,0,0,nMT,nMT,nMT],6,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,64),heltab2x128(:,:,64))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(64),n2h64(60))
  Gcoeff(:)%j = (c(6)*(M(7,:)%j-M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(65),h0tab(:,65),[64,4,16,3,32,8],[0,nMT,nMT,nMT,nMT,0],6,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(65),m3h2x64(:,65),heltab2x128(:,:,65))
  Gcoeff(:)%j = (c(11)*(-M(7,:)%j+M(11,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(66),h0tab(:,66),[64,4,16,3,32,8],[0,nMT,nMT,nMT,nMT,0],6,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(66),m3h2x64(:,66),heltab2x128(:,:,66))
  Gcoeff(:)%j = (c(24)*(M(8,:)%j+M(9,:)%j-M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(67),h0tab(:,67),[64,3,8,32,16,4],[nMT,nMT,0,0,0,nMT],6,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,67),heltab2x128(:,:,67))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(67),n2h64(61))
  Gcoeff(:)%j = (c(30)*(-M(8,:)%j-M(9,:)%j+M(10,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(68),h0tab(:,68),[64,3,8,32,16,4],[nMT,nMT,0,0,0,nMT],6,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,68),heltab2x128(:,:,68))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(68),n2h64(62))
  Gcoeff(:)%j = (c(24)*(M(7,:)%j+M(8,:)%j-M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(69),h0tab(:,69),[64,4,16,3,8,32],[0,nMT,nMT,nMT,0,0],6,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(69),m3h2x64(:,69),heltab2x128(:,:,69))
  Gcoeff(:)%j = (c(30)*(-M(7,:)%j-M(8,:)%j+M(11,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(70),h0tab(:,70),[64,4,16,3,8,32],[0,nMT,nMT,nMT,0,0],6,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(70),m3h2x64(:,70),heltab2x128(:,:,70))
  Gcoeff(:)%j = (c(6)*(M(7,:)%j-M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(71),h0tab(:,71),[64,4,16,32,3,8],[0,nMT,nMT,nMT,nMT,0],6,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(71),m3h2x64(:,71),heltab2x128(:,:,71))
  Gcoeff(:)%j = (c(11)*(-M(7,:)%j+M(11,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(72),h0tab(:,72),[64,4,16,32,3,8],[0,nMT,nMT,nMT,nMT,0],6,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(72),m3h2x64(:,72),heltab2x128(:,:,72))
  Gcoeff(:)%j = (c(6)*(-M(9,:)%j+M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(73),h0tab(:,73),[64,3,4,16,8,32],[nMT,nMT,0,0,nMT,nMT],6,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,73),heltab2x128(:,:,73))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(73),n2h64(63))
  Gcoeff(:)%j = (c(11)*(M(9,:)%j-M(10,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(74),h0tab(:,74),[64,3,4,16,8,32],[nMT,nMT,0,0,nMT,nMT],6,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,74),heltab2x128(:,:,74))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(74),n2h64(64))
  Gcoeff(:)%j = (c(6)*(M(9,:)%j-M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(75),h0tab(:,75),[64,8,16,4,3,32],[nMT,0,0,nMT,nMT,nMT],6,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,75),heltab2x128(:,:,75))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(75),n2h64(65))
  Gcoeff(:)%j = (c(11)*(-M(9,:)%j+M(11,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(76),h0tab(:,76),[64,8,16,4,3,32],[nMT,0,0,nMT,nMT,nMT],6,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,76),heltab2x128(:,:,76))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(76),n2h64(66))
  Gcoeff(:)%j = (c(24)*(M(8,:)%j+M(9,:)%j-M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(77),h0tab(:,77),[64,3,4,16,32,8],[nMT,nMT,0,0,0,nMT],6,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,77),heltab2x128(:,:,77))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(77),n2h64(67))
  Gcoeff(:)%j = (c(30)*(-M(8,:)%j-M(9,:)%j+M(10,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(78),h0tab(:,78),[64,3,4,16,32,8],[nMT,nMT,0,0,0,nMT],6,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,78),heltab2x128(:,:,78))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(78),n2h64(68))
  Gcoeff(:)%j = (c(24)*(M(7,:)%j+M(9,:)%j-M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(79),h0tab(:,79),[64,8,32,3,4,16],[0,nMT,nMT,nMT,0,0],6,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(79),m3h2x64(:,79),heltab2x128(:,:,79))
  Gcoeff(:)%j = (c(30)*(-M(7,:)%j-M(9,:)%j+M(11,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(80),h0tab(:,80),[64,8,32,3,4,16],[0,nMT,nMT,nMT,0,0],6,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(80),m3h2x64(:,80),heltab2x128(:,:,80))
  Gcoeff(:)%j = (c(8)*M(4,:)%j+c(6)*(M(7,:)%j+M(8,:)%j+M(9,:)%j-M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(81),h0tab(:,81),[64,16,4,3,8,32],[0,0,nMT,nMT,0,0],6,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(81),m3h2x64(:,81),heltab2x128(:,:,81))
  Gcoeff(:)%j = (-(c(13)*M(4,:)%j)+c(11)*(-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(11,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(82),h0tab(:,82),[64,16,4,3,8,32],[0,0,nMT,nMT,0,0],6,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(82),m3h2x64(:,82),heltab2x128(:,:,82))
  Gcoeff(:)%j = (-(c(8)*M(6,:)%j)+c(6)*(-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(83),h0tab(:,83),[64,8,3,4,16,32],[0,nMT,nMT,0,0,0],6,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(83),m3h2x64(:,83),heltab2x128(:,:,83))
  Gcoeff(:)%j = (c(13)*M(6,:)%j+c(11)*(M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(84),h0tab(:,84),[64,8,3,4,16,32],[0,nMT,nMT,0,0,0],6,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(84),m3h2x64(:,84),heltab2x128(:,:,84))
  Gcoeff(:)%j = (c(6)*(M(8,:)%j-M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(85),h0tab(:,85),[64,3,16,8,32,4],[nMT,nMT,nMT,0,0,nMT],6,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,85),heltab2x128(:,:,85))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(85),n2h64(69))
  Gcoeff(:)%j = (c(11)*(-M(8,:)%j+M(11,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(86),h0tab(:,86),[64,3,16,8,32,4],[nMT,nMT,nMT,0,0,nMT],6,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,86),heltab2x128(:,:,86))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(86),n2h64(70))
  Gcoeff(:)%j = (c(6)*(M(7,:)%j-M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(87),h0tab(:,87),[64,4,32,3,16,8],[0,nMT,nMT,nMT,nMT,0],6,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(87),m3h2x64(:,87),heltab2x128(:,:,87))
  Gcoeff(:)%j = (c(11)*(-M(7,:)%j+M(10,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(88),h0tab(:,88),[64,4,32,3,16,8],[0,nMT,nMT,nMT,nMT,0],6,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(88),m3h2x64(:,88),heltab2x128(:,:,88))
  Gcoeff(:)%j = (c(24)*(M(8,:)%j+M(9,:)%j-M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(89),h0tab(:,89),[64,3,8,16,32,4],[nMT,nMT,0,0,0,nMT],6,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,89),heltab2x128(:,:,89))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(89),n2h64(71))
  Gcoeff(:)%j = (c(30)*(-M(8,:)%j-M(9,:)%j+M(11,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(90),h0tab(:,90),[64,3,8,16,32,4],[nMT,nMT,0,0,0,nMT],6,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,90),heltab2x128(:,:,90))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(90),n2h64(72))
  Gcoeff(:)%j = (c(24)*(M(7,:)%j+M(9,:)%j-M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(91),h0tab(:,91),[64,4,32,3,8,16],[0,nMT,nMT,nMT,0,0],6,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(91),m3h2x64(:,91),heltab2x128(:,:,91))
  Gcoeff(:)%j = (c(30)*(-M(7,:)%j-M(9,:)%j+M(10,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(92),h0tab(:,92),[64,4,32,3,8,16],[0,nMT,nMT,nMT,0,0],6,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(92),m3h2x64(:,92),heltab2x128(:,:,92))
  Gcoeff(:)%j = (c(6)*(-M(8,:)%j+M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(93),h0tab(:,93),[64,4,32,8,3,16],[nMT,0,0,nMT,nMT,nMT],6,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,93),heltab2x128(:,:,93))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(93),n2h64(73))
  Gcoeff(:)%j = (c(11)*(M(8,:)%j-M(11,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(94),h0tab(:,94),[64,4,32,8,3,16],[nMT,0,0,nMT,nMT,nMT],6,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,94),heltab2x128(:,:,94))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(94),n2h64(74))
  Gcoeff(:)%j = (c(6)*(M(7,:)%j-M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(95),h0tab(:,95),[64,4,32,16,3,8],[0,nMT,nMT,nMT,nMT,0],6,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(95),m3h2x64(:,95),heltab2x128(:,:,95))
  Gcoeff(:)%j = (c(11)*(-M(7,:)%j+M(10,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(96),h0tab(:,96),[64,4,32,16,3,8],[0,nMT,nMT,nMT,nMT,0],6,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(96),m3h2x64(:,96),heltab2x128(:,:,96))
  Gcoeff(:)%j = (c(6)*(-M(8,:)%j+M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(97),h0tab(:,97),[64,3,4,32,8,16],[nMT,nMT,0,0,nMT,nMT],6,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,97),heltab2x128(:,:,97))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(97),n2h64(75))
  Gcoeff(:)%j = (c(11)*(M(8,:)%j-M(11,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(98),h0tab(:,98),[64,3,4,32,8,16],[nMT,nMT,0,0,nMT,nMT],6,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,98),heltab2x128(:,:,98))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(98),n2h64(76))
  Gcoeff(:)%j = (c(24)*(M(8,:)%j+M(9,:)%j-M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(99),h0tab(:,99),[64,3,4,32,16,8],[nMT,nMT,0,0,0,nMT],6,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,99),heltab2x128(:,:,99))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(99),n2h64(77))
  Gcoeff(:)%j = (c(30)*(-M(8,:)%j-M(9,:)%j+M(11,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(100),h0tab(:,100),[64,3,4,32,16,8],[nMT,nMT,0,0,0,nMT],6,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,100),heltab2x128(:,:,100))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(100),n2h64(78))
  Gcoeff(:)%j = (c(24)*(M(7,:)%j+M(8,:)%j-M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(101),h0tab(:,101),[64,8,16,3,4,32],[0,nMT,nMT,nMT,0,0],6,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(101),m3h2x64(:,101),heltab2x128(:,:,101))
  Gcoeff(:)%j = (c(30)*(-M(7,:)%j-M(8,:)%j+M(10,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(102),h0tab(:,102),[64,8,16,3,4,32],[0,nMT,nMT,nMT,0,0],6,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(102),m3h2x64(:,102),heltab2x128(:,:,102))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)+c(6)*(-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(103),h0tab(:,103),[64,16,8,3,4,32],[0,0,nMT,nMT,0,0],6,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(103),m3h2x64(:,103),heltab2x128(:,:,103))
  Gcoeff(:)%j = (c(13)*M(2,:)%j+c(11)*(M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(104),h0tab(:,104),[64,16,8,3,4,32],[0,0,nMT,nMT,0,0],6,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(104),m3h2x64(:,104),heltab2x128(:,:,104))
  Gcoeff(:)%j = (c(6)*(M(8,:)%j-M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(105),h0tab(:,105),[64,8,32,4,3,16],[nMT,0,0,nMT,nMT,nMT],6,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,105),heltab2x128(:,:,105))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(105),n2h64(79))
  Gcoeff(:)%j = (c(11)*(-M(8,:)%j+M(10,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(106),h0tab(:,106),[64,8,32,4,3,16],[nMT,0,0,nMT,nMT,nMT],6,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,106),heltab2x128(:,:,106))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(106),n2h64(80))
  Gcoeff(:)%j = (-(c(8)*M(5,:)%j)+c(6)*(-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(107),h0tab(:,107),[64,8,3,4,32,16],[0,nMT,nMT,0,0,0],6,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(107),m3h2x64(:,107),heltab2x128(:,:,107))
  Gcoeff(:)%j = (c(13)*M(5,:)%j+c(11)*(M(7,:)%j+M(8,:)%j+M(9,:)%j-M(11,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(108),h0tab(:,108),[64,8,3,4,32,16],[0,nMT,nMT,0,0,0],6,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(108),m3h2x64(:,108),heltab2x128(:,:,108))
  Gcoeff(:)%j = (c(24)*(M(7,:)%j+M(9,:)%j-M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(109),h0tab(:,109),[64,4,3,32,8,16],[0,nMT,nMT,nMT,0,0],6,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(109),m3h2x64(:,109),heltab2x128(:,:,109))
  Gcoeff(:)%j = (c(30)*(-M(7,:)%j-M(9,:)%j+M(10,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(110),h0tab(:,110),[64,4,3,32,8,16],[0,nMT,nMT,nMT,0,0],6,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(110),m3h2x64(:,110),heltab2x128(:,:,110))
  Gcoeff(:)%j = (c(24)*(M(7,:)%j+M(8,:)%j-M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(111),h0tab(:,111),[64,4,3,16,8,32],[0,nMT,nMT,nMT,0,0],6,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(111),m3h2x64(:,111),heltab2x128(:,:,111))
  Gcoeff(:)%j = (c(30)*(-M(7,:)%j-M(8,:)%j+M(11,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(112),h0tab(:,112),[64,4,3,16,8,32],[0,nMT,nMT,nMT,0,0],6,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(112),m3h2x64(:,112),heltab2x128(:,:,112))
  Gcoeff(:)%j = (c(6)*(M(7,:)%j-M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(113),h0tab(:,113),[64,4,3,32,16,8],[0,nMT,nMT,nMT,nMT,0],6,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(113),m3h2x64(:,113),heltab2x128(:,:,113))
  Gcoeff(:)%j = (c(11)*(-M(7,:)%j+M(10,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(114),h0tab(:,114),[64,4,3,32,16,8],[0,nMT,nMT,nMT,nMT,0],6,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(114),m3h2x64(:,114),heltab2x128(:,:,114))
  Gcoeff(:)%j = (c(8)*M(1,:)%j+c(6)*(M(7,:)%j+M(8,:)%j+M(9,:)%j-M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(115),h0tab(:,115),[64,4,3,8,16,32],[0,nMT,nMT,0,0,0],6,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(115),m3h2x64(:,115),heltab2x128(:,:,115))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)+c(11)*(-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(11,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(116),h0tab(:,116),[64,4,3,8,16,32],[0,nMT,nMT,0,0,0],6,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(116),m3h2x64(:,116),heltab2x128(:,:,116))
  Gcoeff(:)%j = (c(6)*(M(7,:)%j-M(11,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(117),h0tab(:,117),[64,4,3,16,32,8],[0,nMT,nMT,nMT,nMT,0],6,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(117),m3h2x64(:,117),heltab2x128(:,:,117))
  Gcoeff(:)%j = (c(11)*(-M(7,:)%j+M(11,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(118),h0tab(:,118),[64,4,3,16,32,8],[0,nMT,nMT,nMT,nMT,0],6,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(118),m3h2x64(:,118),heltab2x128(:,:,118))
  Gcoeff(:)%j = (c(8)*M(3,:)%j+c(6)*(M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(119),h0tab(:,119),[64,4,3,8,32,16],[0,nMT,nMT,0,0,0],6,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(119),m3h2x64(:,119),heltab2x128(:,:,119))
  Gcoeff(:)%j = (-(c(13)*M(3,:)%j)+c(11)*(-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(120),h0tab(:,120),[64,4,3,8,32,16],[0,nMT,nMT,0,0,0],6,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(120),m3h2x64(:,120),heltab2x128(:,:,120))
  call Hloop_QV_A(ntryL,G1H64(1),wf4(:,1),G1H16(1),m3h4x16(:,1),heltab2x64(:,:,1))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMT,G2H16(1),n2h16(1))
  call Hloop_QZ_A(ntryL,G1H64(2),wf4(:,3),G1H16(1),ngZu,m3h4x16(:,2),heltab2x64(:,:,2))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMT,G2H16(2),n2h16(2))
  call Hloop_AV_Q(ntryL,G1H64(3),wf4(:,1),G1H16(1),m3h4x16(:,3),heltab2x64(:,:,3))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMT,G2H16(3),n2h16(3))
  call Hloop_AZ_Q(ntryL,G1H64(4),wf4(:,3),G1H16(1),ngZu,m3h4x16(:,4),heltab2x64(:,:,4))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMT,G2H16(4),n2h16(4))
  call Hloop_AV_Q(ntryL,G1H64(5),wf4(:,1),G1H16(1),m3h4x16(:,5),heltab2x64(:,:,5))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMT,G2H16(5),n2h16(5))
  call Hloop_AZ_Q(ntryL,G1H64(6),wf4(:,3),G1H16(1),ngZu,m3h4x16(:,6),heltab2x64(:,:,6))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMT,G2H16(6),n2h16(6))
  call Hloop_QA_V(ntryL,G1H64(7),ex4(:),G1H32(1),m3h2x32(:,1),heltab2x64(:,:,7))
  call Hloop_QA_V(ntryL,G1H64(8),ex4(:),G1H32(2),m3h2x32(:,2),heltab2x64(:,:,8))
  call Hloop_QV_A(ntryL,G1H64(9),wf4(:,1),G1H16(1),m3h4x16(:,7),heltab2x64(:,:,9))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMT,G2H16(7),n2h16(7))
  call Hloop_QZ_A(ntryL,G1H64(10),wf4(:,3),G1H16(1),ngZu,m3h4x16(:,8),heltab2x64(:,:,10))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMT,G2H16(8),n2h16(8))
  call Hloop_AV_Q(ntryL,G1H64(11),ex5(:),G1H32(3),m3h2x32(:,3),heltab2x64(:,:,11))
  call Hloop_A_Q(ntryL,G1H32(3),80,nMT,G2H32(1),n2h32(1))
  call Hloop_AV_Q(ntryL,G1H64(12),ex5(:),G1H32(3),m3h2x32(:,4),heltab2x64(:,:,12))
  call Hloop_A_Q(ntryL,G1H32(3),80,nMT,G2H32(2),n2h32(2))
  call Hloop_AV_Q(ntryL,G1H64(13),wf4(:,1),G1H16(1),m3h4x16(:,9),heltab2x64(:,:,13))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMT,G2H16(9),n2h16(9))
  call Hloop_AZ_Q(ntryL,G1H64(14),wf4(:,3),G1H16(1),ngZu,m3h4x16(:,10),heltab2x64(:,:,14))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMT,G2H16(10),n2h16(10))
  call Hloop_QV_A(ntryL,G1H64(15),wf4(:,1),G1H16(1),m3h4x16(:,11),heltab2x64(:,:,15))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMT,G2H16(11),n2h16(11))
  call Hloop_QZ_A(ntryL,G1H64(16),wf4(:,3),G1H16(1),ngZu,m3h4x16(:,12),heltab2x64(:,:,16))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMT,G2H16(12),n2h16(12))
  call Hloop_AV_Q(ntryL,G1H64(17),wf4(:,1),G1H16(1),m3h4x16(:,13),heltab2x64(:,:,17))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMT,G2H16(13),n2h16(13))
  call Hloop_AZ_Q(ntryL,G1H64(18),wf4(:,3),G1H16(1),ngZu,m3h4x16(:,14),heltab2x64(:,:,18))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMT,G2H16(14),n2h16(14))
  call Hloop_QA_V(ntryL,G1H64(19),ex4(:),G1H32(3),m3h2x32(:,5),heltab2x64(:,:,19))
  call Hloop_QA_V(ntryL,G1H64(20),ex4(:),G1H32(4),m3h2x32(:,6),heltab2x64(:,:,20))
  call Hloop_QV_A(ntryL,G1H64(21),wf4(:,1),G1H16(1),m3h4x16(:,15),heltab2x64(:,:,21))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMT,G2H16(15),n2h16(15))
  call Hloop_QZ_A(ntryL,G1H64(22),wf4(:,3),G1H16(1),ngZu,m3h4x16(:,16),heltab2x64(:,:,22))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMT,G2H16(16),n2h16(16))
  call Hloop_QV_A(ntryL,G1H64(23),ex5(:),G1H32(5),m3h2x32(:,7),heltab2x64(:,:,23))
  call Hloop_Q_A(ntryL,G1H32(5),80,nMT,G2H32(3),n2h32(3))
  call Hloop_QV_A(ntryL,G1H64(24),ex5(:),G1H32(5),m3h2x32(:,8),heltab2x64(:,:,24))
  call Hloop_Q_A(ntryL,G1H32(5),80,nMT,G2H32(4),n2h32(4))
  call Hloop_QV_A(ntryL,G1H64(25),wf4(:,1),G1H16(1),m3h4x16(:,17),heltab2x64(:,:,25))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMT,G2H16(17),n2h16(17))
  call Hloop_QZ_A(ntryL,G1H64(26),wf4(:,3),G1H16(1),ngZu,m3h4x16(:,18),heltab2x64(:,:,26))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMT,G2H16(18),n2h16(18))
  call Hloop_AQ_V(ntryL,G1H64(27),ex3(:),G1H32(5),m3h2x32(:,9),heltab2x64(:,:,27))
  call Hloop_AQ_V(ntryL,G1H64(28),ex3(:),G1H32(6),m3h2x32(:,10),heltab2x64(:,:,28))
  call Hloop_QV_A(ntryL,G1H64(29),wf4(:,1),G1H16(1),m3h4x16(:,19),heltab2x64(:,:,29))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMT,G2H16(19),n2h16(19))
  call Hloop_QZ_A(ntryL,G1H64(30),wf4(:,3),G1H16(1),ngZu,m3h4x16(:,20),heltab2x64(:,:,30))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMT,G2H16(20),n2h16(20))
  call Hloop_AQ_V(ntryL,G1H64(31),ex3(:),G1H32(7),m3h2x32(:,11),heltab2x64(:,:,31))
  call Hloop_AQ_V(ntryL,G1H64(32),ex3(:),G1H32(8),m3h2x32(:,12),heltab2x64(:,:,32))
  call Hloop_AQ_V(ntryL,G1H64(33),ex3(:),G1H32(9),m3h2x32(:,13),heltab2x64(:,:,33))
  call Hloop_AQ_V(ntryL,G1H64(34),ex3(:),G1H32(10),m3h2x32(:,14),heltab2x64(:,:,34))
  call Hloop_AQ_V(ntryL,G1H64(35),ex3(:),G1H32(11),m3h2x32(:,15),heltab2x64(:,:,35))
  call Hloop_AQ_V(ntryL,G1H64(36),ex3(:),G1H32(12),m3h2x32(:,16),heltab2x64(:,:,36))
  call Hloop_AV_Q(ntryL,G1H64(37),wf4(:,1),G1H16(1),m3h4x16(:,21),heltab2x64(:,:,37))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMT,G2H16(21),n2h16(21))
  call Hloop_AZ_Q(ntryL,G1H64(38),wf4(:,3),G1H16(1),ngZu,m3h4x16(:,22),heltab2x64(:,:,38))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMT,G2H16(22),n2h16(22))
  call Hloop_QV_A(ntryL,G1H64(39),ex5(:),G1H32(13),m3h2x32(:,17),heltab2x64(:,:,39))
  call Hloop_Q_A(ntryL,G1H32(13),80,nMT,G2H32(5),n2h32(5))
  call Hloop_QV_A(ntryL,G1H64(40),ex5(:),G1H32(13),m3h2x32(:,18),heltab2x64(:,:,40))
  call Hloop_Q_A(ntryL,G1H32(13),80,nMT,G2H32(6),n2h32(6))
  call Hloop_AV_Q(ntryL,G1H64(41),wf4(:,1),G1H16(1),m3h4x16(:,23),heltab2x64(:,:,41))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMT,G2H16(23),n2h16(23))
  call Hloop_AZ_Q(ntryL,G1H64(42),wf4(:,3),G1H16(1),ngZu,m3h4x16(:,24),heltab2x64(:,:,42))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMT,G2H16(24),n2h16(24))
  call Hloop_AV_Q(ntryL,G1H64(43),ex5(:),G1H32(13),m3h2x32(:,19),heltab2x64(:,:,43))
  call Hloop_A_Q(ntryL,G1H32(13),80,nMT,G2H32(7),n2h32(7))
  call Hloop_AV_Q(ntryL,G1H64(44),ex5(:),G1H32(13),m3h2x32(:,20),heltab2x64(:,:,44))
  call Hloop_A_Q(ntryL,G1H32(13),80,nMT,G2H32(8),n2h32(8))
  call Hloop_QA_V(ntryL,G1H64(45),ex4(:),G1H32(13),m3h2x32(:,21),heltab2x64(:,:,45))
  call Hloop_QA_V(ntryL,G1H64(46),ex4(:),G1H32(14),m3h2x32(:,22),heltab2x64(:,:,46))
  call Hloop_QA_V(ntryL,G1H64(47),ex4(:),G1H32(15),m3h2x32(:,23),heltab2x64(:,:,47))
  call Hloop_QA_V(ntryL,G1H64(48),ex4(:),G1H32(16),m3h2x32(:,24),heltab2x64(:,:,48))
  call Hloop_AV_Q(ntryL,G1H64(49),wf4(:,1),G1H16(1),m3h4x16(:,25),heltab2x64(:,:,49))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMT,G2H16(25),n2h16(25))
  call Hloop_AZ_Q(ntryL,G1H64(50),wf4(:,3),G1H16(1),ngZu,m3h4x16(:,26),heltab2x64(:,:,50))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMT,G2H16(26),n2h16(26))
  call Hloop_QV_A(ntryL,G1H64(51),wf4(:,1),G1H16(1),m3h4x16(:,27),heltab2x64(:,:,51))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMT,G2H16(27),n2h16(27))
  call Hloop_QZ_A(ntryL,G1H64(52),wf4(:,3),G1H16(1),ngZu,m3h4x16(:,28),heltab2x64(:,:,52))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMT,G2H16(28),n2h16(28))
  call Hloop_AV_Q(ntryL,G1H64(53),wf4(:,1),G1H16(1),m3h4x16(:,29),heltab2x64(:,:,53))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMT,G2H16(29),n2h16(29))
  call Hloop_AZ_Q(ntryL,G1H64(54),wf4(:,3),G1H16(1),ngZu,m3h4x16(:,30),heltab2x64(:,:,54))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMT,G2H16(30),n2h16(30))
  call Hloop_QV_A(ntryL,G1H64(55),wf4(:,1),G1H16(1),m3h4x16(:,31),heltab2x64(:,:,55))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMT,G2H16(31),n2h16(31))
  call Hloop_QZ_A(ntryL,G1H64(56),wf4(:,3),G1H16(1),ngZu,m3h4x16(:,32),heltab2x64(:,:,56))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMT,G2H16(32),n2h16(32))
  call Hloop_VA_Q(ntryL,G1H64(57),ex4(:),G1H32(17),m3h2x32(:,25),heltab2x64(:,:,57))
  call Hloop_A_Q(ntryL,G1H32(17),72,nMT,G2H32(9),n2h32(9))
  call Hloop_VA_Q(ntryL,G1H64(58),ex4(:),G1H32(17),m3h2x32(:,26),heltab2x64(:,:,58))
  call Hloop_A_Q(ntryL,G1H32(17),72,nMT,G2H32(10),n2h32(10))
  call Hloop_VA_Q(ntryL,G1H64(59),ex4(:),G1H32(17),m3h2x32(:,27),heltab2x64(:,:,59))
  call Hloop_A_Q(ntryL,G1H32(17),72,nMT,G2H32(11),n2h32(11))
  call Hloop_VA_Q(ntryL,G1H64(60),ex4(:),G1H32(17),m3h2x32(:,28),heltab2x64(:,:,60))
  call Hloop_A_Q(ntryL,G1H32(17),72,nMT,G2H32(12),n2h32(12))
  call Hloop_QV_A(ntryL,G1H64(61),wf4(:,1),G1H16(1),m3h4x16(:,33),heltab2x64(:,:,61))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMT,G2H16(33),n2h16(33))
  call Hloop_QZ_A(ntryL,G1H64(62),wf4(:,3),G1H16(1),ngZu,m3h4x16(:,34),heltab2x64(:,:,62))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMT,G2H16(34),n2h16(34))
  call Hloop_AQ_V(ntryL,G1H64(63),ex3(:),G1H32(17),m3h2x32(:,29),heltab2x64(:,:,63))
  call Hloop_AQ_V(ntryL,G1H64(64),ex3(:),G1H32(18),m3h2x32(:,30),heltab2x64(:,:,64))
  call Hloop_VQ_A(ntryL,G1H64(65),ex3(:),G1H32(19),m3h2x32(:,31),heltab2x64(:,:,65))
  call Hloop_Q_A(ntryL,G1H32(19),68,nMT,G2H32(13),n2h32(13))
  call Hloop_VQ_A(ntryL,G1H64(66),ex3(:),G1H32(19),m3h2x32(:,32),heltab2x64(:,:,66))
  call Hloop_Q_A(ntryL,G1H32(19),68,nMT,G2H32(14),n2h32(14))
  call Hloop_QV_A(ntryL,G1H64(67),wf4(:,1),G1H16(1),m3h4x16(:,35),heltab2x64(:,:,67))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMT,G2H16(35),n2h16(35))
  call Hloop_QZ_A(ntryL,G1H64(68),wf4(:,3),G1H16(1),ngZu,m3h4x16(:,36),heltab2x64(:,:,68))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMT,G2H16(36),n2h16(36))
  call Hloop_VQ_A(ntryL,G1H64(69),ex3(:),G1H32(19),m3h2x32(:,33),heltab2x64(:,:,69))
  call Hloop_Q_A(ntryL,G1H32(19),68,nMT,G2H32(15),n2h32(15))
  call Hloop_VQ_A(ntryL,G1H64(70),ex3(:),G1H32(19),m3h2x32(:,34),heltab2x64(:,:,70))
  call Hloop_Q_A(ntryL,G1H32(19),68,nMT,G2H32(16),n2h32(16))
  call Hloop_VQ_A(ntryL,G1H64(71),ex3(:),G1H32(19),m3h2x32(:,35),heltab2x64(:,:,71))
  call Hloop_Q_A(ntryL,G1H32(19),68,nMT,G2H32(17),n2h32(17))
  call Hloop_VQ_A(ntryL,G1H64(72),ex3(:),G1H32(19),m3h2x32(:,36),heltab2x64(:,:,72))
  call Hloop_Q_A(ntryL,G1H32(19),68,nMT,G2H32(18),n2h32(18))
  call Hloop_AV_Q(ntryL,G1H64(73),wf4(:,1),G1H16(1),m3h4x16(:,37),heltab2x64(:,:,73))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMT,G2H16(37),n2h16(37))
  call Hloop_AZ_Q(ntryL,G1H64(74),wf4(:,3),G1H16(1),ngZu,m3h4x16(:,38),heltab2x64(:,:,74))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMT,G2H16(38),n2h16(38))
  call Hloop_QA_V(ntryL,G1H64(75),ex4(:),G1H32(19),m3h2x32(:,37),heltab2x64(:,:,75))
  call Hloop_QA_V(ntryL,G1H64(76),ex4(:),G1H32(20),m3h2x32(:,38),heltab2x64(:,:,76))
  call Hloop_AV_Q(ntryL,G1H64(77),wf4(:,1),G1H16(1),m3h4x16(:,39),heltab2x64(:,:,77))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMT,G2H16(39),n2h16(39))
  call Hloop_AZ_Q(ntryL,G1H64(78),wf4(:,3),G1H16(1),ngZu,m3h4x16(:,40),heltab2x64(:,:,78))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMT,G2H16(40),n2h16(40))
  call Hloop_VA_Q(ntryL,G1H64(79),ex4(:),G1H32(21),m3h2x32(:,39),heltab2x64(:,:,79))
  call Hloop_A_Q(ntryL,G1H32(21),72,nMT,G2H32(19),n2h32(19))
  call Hloop_VA_Q(ntryL,G1H64(80),ex4(:),G1H32(21),m3h2x32(:,40),heltab2x64(:,:,80))
  call Hloop_A_Q(ntryL,G1H32(21),72,nMT,G2H32(20),n2h32(20))
  call Hloop_UV_W(ntryL,G1H64(81),64,ex5(:),16,G2H32(21),m3h2x32(:,41),heltab2x64(:,:,81))
  call Hloop_UV_W(ntryL,G1H64(82),64,ex5(:),16,G2H32(22),m3h2x32(:,42),heltab2x64(:,:,82))
  call Hloop_VA_Q(ntryL,G1H64(83),ex4(:),G1H32(21),m3h2x32(:,43),heltab2x64(:,:,83))
  call Hloop_A_Q(ntryL,G1H32(21),72,nMT,G2H32(23),n2h32(21))
  call Hloop_VA_Q(ntryL,G1H64(84),ex4(:),G1H32(21),m3h2x32(:,44),heltab2x64(:,:,84))
  call Hloop_A_Q(ntryL,G1H32(21),72,nMT,G2H32(24),n2h32(22))
  call Hloop_QV_A(ntryL,G1H64(85),wf4(:,1),G1H16(1),m3h4x16(:,41),heltab2x64(:,:,85))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMT,G2H16(41),n2h16(41))
  call Hloop_QZ_A(ntryL,G1H64(86),wf4(:,3),G1H16(1),ngZu,m3h4x16(:,42),heltab2x64(:,:,86))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMT,G2H16(42),n2h16(42))
  call Hloop_VQ_A(ntryL,G1H64(87),ex3(:),G1H32(21),m3h2x32(:,45),heltab2x64(:,:,87))
  call Hloop_Q_A(ntryL,G1H32(21),68,nMT,G2H32(25),n2h32(23))
  call Hloop_VQ_A(ntryL,G1H64(88),ex3(:),G1H32(21),m3h2x32(:,46),heltab2x64(:,:,88))
  call Hloop_Q_A(ntryL,G1H32(21),68,nMT,G2H32(26),n2h32(24))
  call Hloop_QV_A(ntryL,G1H64(89),wf4(:,1),G1H16(1),m3h4x16(:,43),heltab2x64(:,:,89))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMT,G2H16(43),n2h16(43))
  call Hloop_QZ_A(ntryL,G1H64(90),wf4(:,3),G1H16(1),ngZu,m3h4x16(:,44),heltab2x64(:,:,90))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMT,G2H16(44),n2h16(44))
  call Hloop_VQ_A(ntryL,G1H64(91),ex3(:),G1H32(21),m3h2x32(:,47),heltab2x64(:,:,91))
  call Hloop_Q_A(ntryL,G1H32(21),68,nMT,G2H32(27),n2h32(25))
  call Hloop_VQ_A(ntryL,G1H64(92),ex3(:),G1H32(21),m3h2x32(:,48),heltab2x64(:,:,92))
  call Hloop_Q_A(ntryL,G1H32(21),68,nMT,G2H32(28),n2h32(26))
  call Hloop_AQ_V(ntryL,G1H64(93),ex3(:),G1H32(21),m3h2x32(:,49),heltab2x64(:,:,93))
  call Hloop_AQ_V(ntryL,G1H64(94),ex3(:),G1H32(22),m3h2x32(:,50),heltab2x64(:,:,94))
  call Hloop_VQ_A(ntryL,G1H64(95),ex3(:),G1H32(23),m3h2x32(:,51),heltab2x64(:,:,95))
  call Hloop_Q_A(ntryL,G1H32(23),68,nMT,G2H32(29),n2h32(27))
  call Hloop_VQ_A(ntryL,G1H64(96),ex3(:),G1H32(23),m3h2x32(:,52),heltab2x64(:,:,96))
  call Hloop_Q_A(ntryL,G1H32(23),68,nMT,G2H32(30),n2h32(28))
  call Hloop_AV_Q(ntryL,G1H64(97),wf4(:,1),G1H16(1),m3h4x16(:,45),heltab2x64(:,:,97))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMT,G2H16(45),n2h16(45))
  call Hloop_AZ_Q(ntryL,G1H64(98),wf4(:,3),G1H16(1),ngZu,m3h4x16(:,46),heltab2x64(:,:,98))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMT,G2H16(46),n2h16(46))
  call Hloop_AV_Q(ntryL,G1H64(99),wf4(:,1),G1H16(1),m3h4x16(:,47),heltab2x64(:,:,99))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMT,G2H16(47),n2h16(47))
  call Hloop_AZ_Q(ntryL,G1H64(100),wf4(:,3),G1H16(1),ngZu,m3h4x16(:,48),heltab2x64(:,:,100))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMT,G2H16(48),n2h16(48))
  call Hloop_VA_Q(ntryL,G1H64(101),ex4(:),G1H32(23),m3h2x32(:,53),heltab2x64(:,:,101))
  call Hloop_A_Q(ntryL,G1H32(23),72,nMT,G2H32(31),n2h32(29))
  call Hloop_VA_Q(ntryL,G1H64(102),ex4(:),G1H32(23),m3h2x32(:,54),heltab2x64(:,:,102))
  call Hloop_A_Q(ntryL,G1H32(23),72,nMT,G2H32(32),n2h32(30))
  call Hloop_UV_W(ntryL,G1H64(103),64,ex5(:),16,G2H32(33),m3h2x32(:,55),heltab2x64(:,:,103))
  call Hloop_UV_W(ntryL,G1H64(104),64,ex5(:),16,G2H32(34),m3h2x32(:,56),heltab2x64(:,:,104))
  call Hloop_QA_V(ntryL,G1H64(105),ex4(:),G1H32(23),m3h2x32(:,57),heltab2x64(:,:,105))
  call Hloop_QA_V(ntryL,G1H64(106),ex4(:),G1H32(24),m3h2x32(:,58),heltab2x64(:,:,106))
  call Hloop_VA_Q(ntryL,G1H64(107),ex4(:),G1H32(25),m3h2x32(:,59),heltab2x64(:,:,107))
  call Hloop_A_Q(ntryL,G1H32(25),72,nMT,G2H32(35),n2h32(31))
  call Hloop_VA_Q(ntryL,G1H64(108),ex4(:),G1H32(25),m3h2x32(:,60),heltab2x64(:,:,108))
  call Hloop_A_Q(ntryL,G1H32(25),72,nMT,G2H32(36),n2h32(32))
  call Hloop_VQ_A(ntryL,G1H64(109),ex3(:),G1H32(25),m3h2x32(:,61),heltab2x64(:,:,109))
  call Hloop_Q_A(ntryL,G1H32(25),68,nMT,G2H32(37),n2h32(33))
  call Hloop_VQ_A(ntryL,G1H64(110),ex3(:),G1H32(25),m3h2x32(:,62),heltab2x64(:,:,110))
  call Hloop_Q_A(ntryL,G1H32(25),68,nMT,G2H32(38),n2h32(34))
  call Hloop_VQ_A(ntryL,G1H64(111),ex3(:),G1H32(25),m3h2x32(:,63),heltab2x64(:,:,111))
  call Hloop_Q_A(ntryL,G1H32(25),68,nMT,G2H32(39),n2h32(35))
  call Hloop_VQ_A(ntryL,G1H64(112),ex3(:),G1H32(25),m3h2x32(:,64),heltab2x64(:,:,112))
  call Hloop_Q_A(ntryL,G1H32(25),68,nMT,G2H32(40),n2h32(36))
  call Hloop_VQ_A(ntryL,G1H64(113),ex3(:),G1H32(25),m3h2x32(:,65),heltab2x64(:,:,113))
  call Hloop_Q_A(ntryL,G1H32(25),68,nMT,G2H32(41),n2h32(37))
  call Hloop_VQ_A(ntryL,G1H64(114),ex3(:),G1H32(25),m3h2x32(:,66),heltab2x64(:,:,114))
  call Hloop_Q_A(ntryL,G1H32(25),68,nMT,G2H32(42),n2h32(38))
  call Hloop_VQ_A(ntryL,G1H64(115),ex3(:),G1H32(25),m3h2x32(:,67),heltab2x64(:,:,115))
  call Hloop_Q_A(ntryL,G1H32(25),68,nMT,G2H32(43),n2h32(39))
  call Hloop_VQ_A(ntryL,G1H64(116),ex3(:),G1H32(25),m3h2x32(:,68),heltab2x64(:,:,116))
  call Hloop_Q_A(ntryL,G1H32(25),68,nMT,G2H32(44),n2h32(40))
  call Hloop_VQ_A(ntryL,G1H64(117),ex3(:),G1H32(25),m3h2x32(:,69),heltab2x64(:,:,117))
  call Hloop_Q_A(ntryL,G1H32(25),68,nMT,G2H32(45),n2h32(41))
  call Hloop_VQ_A(ntryL,G1H64(118),ex3(:),G1H32(25),m3h2x32(:,70),heltab2x64(:,:,118))
  call Hloop_Q_A(ntryL,G1H32(25),68,nMT,G2H32(46),n2h32(42))
  call Hloop_VQ_A(ntryL,G1H64(119),ex3(:),G1H32(25),m3h2x32(:,71),heltab2x64(:,:,119))
  call Hloop_Q_A(ntryL,G1H32(25),68,nMT,G2H32(47),n2h32(43))
  call Hloop_VQ_A(ntryL,G1H64(120),ex3(:),G1H32(25),m3h2x32(:,72),heltab2x64(:,:,120))
  call Hloop_Q_A(ntryL,G1H32(25),68,nMT,G2H32(48),n2h32(44))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(2),[G2H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(4),[G2H16(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(6),[G2H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(8),[G2H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(10),[G2H16(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(12),[G2H16(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(14),[G2H16(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(16),[G2H16(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(18),[G2H16(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(20),[G2H16(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(22),[G2H16(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(24),[G2H16(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(26),[G2H16(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(28),[G2H16(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(30),[G2H16(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(32),[G2H16(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(34),[G2H16(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(36),[G2H16(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(38),[G2H16(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(40),[G2H16(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(42),[G2H16(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(44),[G2H16(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(46),[G2H16(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(48),[G2H16(47)])
  call Hotf_5pt_reduction(G2H16(2),RedSet_5(1),mass5set(:,1),  & 
G1H16(1),G1H16(2),G1H16(3),G1H16(4),G1H16(5),G1H16(6),16)
  call HG1shiftOLR(G1H16(2),16,16)
  call Hotf_5pt_reduction(G2H16(4),RedSet_5(2),mass5set(:,1),  & 
G1H16(7),G1H16(8),G1H16(9),G1H16(10),G1H16(11),G1H16(12),16)
  call HG1shiftOLR(G1H16(8),32,16)
  call Hotf_5pt_reduction(G2H16(6),RedSet_5(3),mass5set(:,2),  & 
G1H16(13),G1H16(14),G1H16(15),G1H16(16),G1H16(17),G1H16(18),16)
  call HG1shiftOLR(G1H16(14),8,16)
  call Hloop_VQ_A(ntryL,G1H32(1),ex3(:),G1H16(19),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_Q_A(ntryL,G1H16(19),76,nMT,G2H16(1),n2h16(49))
  call Hloop_VQ_A(ntryL,G1H32(2),ex3(:),G1H16(19),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_Q_A(ntryL,G1H16(19),76,nMT,G2H16(3),n2h16(50))
  call Hloop_QA_V(ntryL,G2H16(8),ex4(:),G2H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_AQ_V(ntryL,G2H32(1),ex3(:),G2H16(5),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_AQ_V(ntryL,G2H32(2),ex3(:),G2H16(7),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hotf_5pt_reduction(G2H16(10),RedSet_5(4),mass5set(:,1),  & 
G1H16(19),G1H16(20),G1H16(21),G1H16(22),G1H16(23),G1H16(24),16)
  call HG1shiftOLR(G1H16(20),16,16)
  call Hotf_5pt_reduction(G2H16(12),RedSet_5(5),mass5set(:,1),  & 
G1H16(25),G1H16(26),G1H16(27),G1H16(28),G1H16(29),G1H16(30),16)
  call HG1shiftOLR(G1H16(26),32,16)
  call Hotf_5pt_reduction(G2H16(14),RedSet_5(6),mass5set(:,2),  & 
G1H16(31),G1H16(32),G1H16(33),G1H16(34),G1H16(35),G1H16(36),16)
  call HG1shiftOLR(G1H16(32),8,16)
  call Hloop_VQ_A(ntryL,G1H32(3),ex3(:),G1H16(37),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_Q_A(ntryL,G1H16(37),76,nMT,G2H16(9),n2h16(51))
  call Hloop_VQ_A(ntryL,G1H32(4),ex3(:),G1H16(37),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_Q_A(ntryL,G1H16(37),76,nMT,G2H16(11),n2h16(52))
  call Hloop_QA_V(ntryL,G2H16(16),ex4(:),G2H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hotf_5pt_reduction(G2H32(3),RedSet_5(7),mass5set(:,1),  & 
G1H32(25),G1H32(1),G1H32(2),G1H32(3),G1H32(4),G1H32(26),32)
  call HG1shiftOLR(G1H32(1),32,32)
  call Hotf_5pt_reduction(G2H32(4),RedSet_5(7),mass5set(:,1),  & 
G1H32(27),G1H32(28),G1H32(29),G1H32(30),G1H32(31),G1H32(32),32)
  call HG1shiftOLR(G1H32(28),32,32)
  call Hotf_5pt_reduction(G2H16(18),RedSet_5(3),mass5set(:,2),  & 
G1H16(37),G1H16(38),G1H16(39),G1H16(40),G1H16(41),G1H16(42),16)
  call HG1shiftOLR(G1H16(38),4,16)
  call Hloop_VA_Q(ntryL,G1H32(5),ex4(:),G1H16(43),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_A_Q(ntryL,G1H16(43),76,nMT,G2H16(13),n2h16(53))
  call Hloop_VA_Q(ntryL,G1H32(6),ex4(:),G1H16(43),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_A_Q(ntryL,G1H16(43),76,nMT,G2H16(15),n2h16(54))
  call Hotf_5pt_reduction(G2H16(20),RedSet_5(6),mass5set(:,2),  & 
G1H16(43),G1H16(44),G1H16(45),G1H16(46),G1H16(47),G1H16(48),16)
  call HG1shiftOLR(G1H16(44),4,16)
  call Hloop_VA_Q(ntryL,G1H32(7),ex4(:),G1H16(49),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_A_Q(ntryL,G1H16(49),76,nMT,G2H16(17),n2h16(55))
  call Hloop_VA_Q(ntryL,G1H32(8),ex4(:),G1H16(49),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_A_Q(ntryL,G1H16(49),76,nMT,G2H16(19),n2h16(56))
  call Hloop_VA_Q(ntryL,G1H32(9),ex4(:),G1H16(49),m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_A_Q(ntryL,G1H16(49),76,nMT,G2H16(21),n2h16(57))
  call Hloop_VA_Q(ntryL,G1H32(10),ex4(:),G1H16(49),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_A_Q(ntryL,G1H16(49),76,nMT,G2H16(23),n2h16(58))
  call Hloop_VA_Q(ntryL,G1H32(11),ex4(:),G1H16(49),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_A_Q(ntryL,G1H16(49),76,nMT,G2H16(25),n2h16(59))
  call Hloop_VA_Q(ntryL,G1H32(12),ex4(:),G1H16(49),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_A_Q(ntryL,G1H16(49),76,nMT,G2H16(27),n2h16(60))
  call Hloop_AQ_V(ntryL,G2H16(22),ex3(:),G2H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_QA_V(ntryL,G2H32(5),ex4(:),G2H16(29),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_QA_V(ntryL,G2H32(6),ex4(:),G2H16(31),m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_AQ_V(ntryL,G2H16(24),ex3(:),G2H8(4),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hotf_5pt_reduction(G2H32(7),RedSet_5(8),mass5set(:,1),  & 
G1H32(5),G1H32(6),G1H32(7),G1H32(8),G1H32(9),G1H32(10),32)
  call HG1shiftOLR(G1H32(6),32,32)
  call Hotf_5pt_reduction(G2H32(8),RedSet_5(8),mass5set(:,1),  & 
G1H32(11),G1H32(12),G1H32(33),G1H32(34),G1H32(35),G1H32(36),32)
  call HG1shiftOLR(G1H32(12),32,32)
  call Hloop_VQ_A(ntryL,G1H32(13),ex3(:),G1H16(49),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_Q_A(ntryL,G1H16(49),76,nMT,G2H16(33),n2h16(61))
  call Hloop_VQ_A(ntryL,G1H32(14),ex3(:),G1H16(49),m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_Q_A(ntryL,G1H16(49),76,nMT,G2H16(35),n2h16(62))
  call Hloop_VQ_A(ntryL,G1H32(15),ex3(:),G1H16(49),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_Q_A(ntryL,G1H16(49),76,nMT,G2H16(37),n2h16(63))
  call Hloop_VQ_A(ntryL,G1H32(16),ex3(:),G1H16(49),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_Q_A(ntryL,G1H16(49),76,nMT,G2H16(39),n2h16(64))
  call Hotf_5pt_reduction(G2H16(26),RedSet_5(4),mass5set(:,1),  & 
G1H16(49),G1H16(50),G1H16(51),G1H16(52),G1H16(53),G1H16(54),16)
  call HG1shiftOLR(G1H16(50),8,16)
  call Hloop_QA_V(ntryL,G2H16(28),ex4(:),G2H8(5),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hotf_5pt_reduction(G2H16(30),RedSet_5(2),mass5set(:,1),  & 
G1H16(55),G1H16(56),G1H16(57),G1H16(58),G1H16(59),G1H16(60),16)
  call HG1shiftOLR(G1H16(56),8,16)
  call Hloop_QA_V(ntryL,G2H16(32),ex4(:),G2H8(6),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hotf_5pt_reduction(G2H32(9),RedSet_5(9),mass5set(:,3),  & 
G1H32(13),G1H32(14),G1H32(15),G1H32(16),G1H32(37),G1H32(38),32)
  call HG1shiftOLR(G1H32(14),16,32)
  call Hotf_5pt_reduction(G2H32(10),RedSet_5(9),mass5set(:,3),  & 
G1H32(39),G1H32(40),G1H32(41),G1H32(42),G1H32(43),G1H32(44),32)
  call HG1shiftOLR(G1H32(40),16,32)
  call Hotf_5pt_reduction(G2H32(11),RedSet_5(10),mass5set(:,3),  & 
G1H32(45),G1H32(46),G1H32(47),G1H32(48),G1H32(49),G1H32(50),32)
  call HG1shiftOLR(G1H32(46),32,32)
  call Hotf_5pt_reduction(G2H32(12),RedSet_5(10),mass5set(:,3),  & 
G1H32(51),G1H32(52),G1H32(53),G1H32(54),G1H32(55),G1H32(56),32)
  call HG1shiftOLR(G1H32(52),32,32)
  call Hotf_5pt_reduction(G2H16(34),RedSet_5(1),mass5set(:,1),  & 
G1H16(61),G1H16(62),G1H16(63),G1H16(64),G1H16(65),G1H16(66),16)
  call HG1shiftOLR(G1H16(62),4,16)
  call Hloop_UV_W(ntryL,G1H32(17),68,ex5(:),16,G2H16(41),m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_UV_W(ntryL,G1H32(18),68,ex5(:),16,G2H16(43),m3h2x16(:,22),heltab2x32(:,:,22))
  call Hotf_5pt_reduction(G2H32(13),RedSet_5(11),mass5set(:,3),  & 
G1H32(17),G1H32(18),G1H32(57),G1H32(58),G1H32(59),G1H32(60),32)
  call HG1shiftOLR(G1H32(18),8,32)
  call Hotf_5pt_reduction(G2H32(14),RedSet_5(11),mass5set(:,3),  & 
G1H32(61),G1H32(62),G1H32(63),G1H32(64),G1H32(65),G1H32(66),32)
  call HG1shiftOLR(G1H32(62),8,32)
  call Hloop_QA_V(ntryL,G2H16(36),ex4(:),G2H8(7),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hotf_5pt_reduction(G2H32(15),RedSet_5(11),mass5set(:,3),  & 
G1H32(67),G1H32(68),G1H32(69),G1H32(70),G1H32(71),G1H32(72),32)
  call HG1shiftOLR(G1H32(68),32,32)
  call Hotf_5pt_reduction(G2H32(16),RedSet_5(11),mass5set(:,3),  & 
G1H32(73),G1H32(74),G1H32(75),G1H32(76),G1H32(77),G1H32(78),32)
  call HG1shiftOLR(G1H32(74),32,32)
  call Hotf_5pt_reduction(G2H32(17),RedSet_5(12),mass5set(:,3),  & 
G1H32(79),G1H32(80),G1H32(81),G1H32(82),G1H32(83),G1H32(84),32)
  call HG1shiftOLR(G1H32(80),8,32)
  call Hotf_5pt_reduction(G2H32(18),RedSet_5(12),mass5set(:,3),  & 
G1H32(85),G1H32(86),G1H32(87),G1H32(88),G1H32(89),G1H32(90),32)
  call HG1shiftOLR(G1H32(86),8,32)
  call Hloop_AQ_V(ntryL,G2H16(38),ex3(:),G2H8(8),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_UV_W(ntryL,G1H32(19),72,ex5(:),16,G2H16(45),m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_UV_W(ntryL,G1H32(20),72,ex5(:),16,G2H16(47),m3h2x16(:,24),heltab2x32(:,:,24))
  call Hloop_AQ_V(ntryL,G2H16(40),ex3(:),G2H8(9),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hotf_5pt_reduction(G2H32(19),RedSet_5(13),mass5set(:,3),  & 
G1H32(19),G1H32(20),G1H32(91),G1H32(92),G1H32(93),G1H32(94),32)
  call HG1shiftOLR(G1H32(20),16,32)
  call Hotf_5pt_reduction(G2H32(20),RedSet_5(13),mass5set(:,3),  & 
G1H32(95),G1H32(96),G1H32(97),G1H32(98),G1H32(99),G1H32(100),32)
  call HG1shiftOLR(G1H32(96),16,32)
  call Hotf_5pt_reduction(G2H32(21),RedSet_5(14),mass5set(:,4),  & 
G1H32(101),G1H32(102),G1H32(103),G1H32(104),G1H32(105),G1H32(106),32)
  call HG1shiftOLR(G1H32(102),32,32)
  call Hotf_5pt_reduction(G2H32(22),RedSet_5(14),mass5set(:,4),  & 
G1H32(107),G1H32(108),G1H32(109),G1H32(110),G1H32(111),G1H32(112),32)
  call HG1shiftOLR(G1H32(108),32,32)
  call Hotf_5pt_reduction(G2H32(23),RedSet_5(15),mass5set(:,5),  & 
G1H32(113),G1H32(114),G1H32(115),G1H32(116),G1H32(117),G1H32(118),32)
  call HG1shiftOLR(G1H32(114),32,32)
  call Hotf_5pt_reduction(G2H32(24),RedSet_5(15),mass5set(:,5),  & 
G1H32(119),G1H32(120),G1H32(121),G1H32(122),G1H32(123),G1H32(124),32)
  call HG1shiftOLR(G1H32(120),32,32)
  call Hotf_5pt_reduction(G2H16(42),RedSet_5(5),mass5set(:,1),  & 
G1H16(67),G1H16(68),G1H16(69),G1H16(70),G1H16(71),G1H16(72),16)
  call HG1shiftOLR(G1H16(68),4,16)
  call Hotf_5pt_reduction(G2H32(25),RedSet_5(16),mass5set(:,3),  & 
G1H32(125),G1H32(126),G1H32(127),G1H32(128),G1H32(129),G1H32(130),32)
  call HG1shiftOLR(G1H32(126),8,32)
  call Hotf_5pt_reduction(G2H32(26),RedSet_5(16),mass5set(:,3),  & 
G1H32(131),G1H32(132),G1H32(133),G1H32(134),G1H32(135),G1H32(136),32)
  call HG1shiftOLR(G1H32(132),8,32)
  call Hloop_QA_V(ntryL,G2H16(44),ex4(:),G2H8(10),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hotf_5pt_reduction(G2H32(27),RedSet_5(16),mass5set(:,3),  & 
G1H32(137),G1H32(138),G1H32(139),G1H32(140),G1H32(141),G1H32(142),32)
  call HG1shiftOLR(G1H32(138),16,32)
  call Hotf_5pt_reduction(G2H32(28),RedSet_5(16),mass5set(:,3),  & 
G1H32(143),G1H32(144),G1H32(145),G1H32(146),G1H32(147),G1H32(148),32)
  call HG1shiftOLR(G1H32(144),16,32)
  call Hloop_UV_W(ntryL,G1H32(21),68,ex6(:),32,G2H16(2),m3h2x16(:,25),heltab2x32(:,:,25))
  call Hloop_UV_W(ntryL,G1H32(22),68,ex6(:),32,G2H16(4),m3h2x16(:,26),heltab2x32(:,:,26))
  call Hotf_5pt_reduction(G2H32(29),RedSet_5(17),mass5set(:,3),  & 
G1H32(21),G1H32(22),G1H32(149),G1H32(150),G1H32(151),G1H32(152),32)
  call HG1shiftOLR(G1H32(22),8,32)
  call Hotf_5pt_reduction(G2H32(30),RedSet_5(17),mass5set(:,3),  & 
G1H32(153),G1H32(154),G1H32(155),G1H32(156),G1H32(157),G1H32(158),32)
  call HG1shiftOLR(G1H32(154),8,32)
  call Hloop_AQ_V(ntryL,G2H16(46),ex3(:),G2H8(11),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_AQ_V(ntryL,G2H16(48),ex3(:),G2H8(12),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hotf_5pt_reduction(G2H32(31),RedSet_5(18),mass5set(:,3),  & 
G1H32(159),G1H32(160),G1H32(161),G1H32(162),G1H32(163),G1H32(164),32)
  call HG1shiftOLR(G1H32(160),32,32)
  call Hotf_5pt_reduction(G2H32(32),RedSet_5(18),mass5set(:,3),  & 
G1H32(165),G1H32(166),G1H32(167),G1H32(168),G1H32(169),G1H32(170),32)
  call HG1shiftOLR(G1H32(166),32,32)
  call Hotf_5pt_reduction(G2H32(33),RedSet_5(19),mass5set(:,4),  & 
G1H32(171),G1H32(172),G1H32(173),G1H32(174),G1H32(175),G1H32(176),32)
  call HG1shiftOLR(G1H32(172),32,32)
  call Hotf_5pt_reduction(G2H32(34),RedSet_5(19),mass5set(:,4),  & 
G1H32(177),G1H32(178),G1H32(179),G1H32(180),G1H32(181),G1H32(182),32)
  call HG1shiftOLR(G1H32(178),32,32)
  call Hloop_UV_W(ntryL,G1H32(23),72,ex6(:),32,G2H16(6),m3h2x16(:,27),heltab2x32(:,:,27))
  call Hloop_UV_W(ntryL,G1H32(24),72,ex6(:),32,G2H16(8),m3h2x16(:,28),heltab2x32(:,:,28))
  call Hotf_5pt_reduction(G2H32(35),RedSet_5(15),mass5set(:,5),  & 
G1H32(23),G1H32(24),G1H32(183),G1H32(184),G1H32(185),G1H32(186),32)
  call HG1shiftOLR(G1H32(24),16,32)
  call Hotf_5pt_reduction(G2H32(36),RedSet_5(15),mass5set(:,5),  & 
G1H32(187),G1H32(188),G1H32(189),G1H32(190),G1H32(191),G1H32(192),32)
  call HG1shiftOLR(G1H32(188),16,32)
  call Hotf_5pt_reduction(G2H32(37),RedSet_5(20),mass5set(:,3),  & 
G1H32(193),G1H32(194),G1H32(195),G1H32(196),G1H32(197),G1H32(198),32)
  call HG1shiftOLR(G1H32(194),16,32)
  call Hotf_5pt_reduction(G2H32(38),RedSet_5(20),mass5set(:,3),  & 
G1H32(199),G1H32(200),G1H32(201),G1H32(202),G1H32(203),G1H32(204),32)
  call HG1shiftOLR(G1H32(200),16,32)
  call Hotf_5pt_reduction(G2H32(39),RedSet_5(21),mass5set(:,3),  & 
G1H32(205),G1H32(206),G1H32(207),G1H32(208),G1H32(209),G1H32(210),32)
  call HG1shiftOLR(G1H32(206),32,32)
  call Hotf_5pt_reduction(G2H32(40),RedSet_5(21),mass5set(:,3),  & 
G1H32(211),G1H32(212),G1H32(213),G1H32(214),G1H32(215),G1H32(216),32)
  call HG1shiftOLR(G1H32(212),32,32)
  call Hotf_5pt_reduction(G2H32(41),RedSet_5(20),mass5set(:,3),  & 
G1H32(217),G1H32(218),G1H32(219),G1H32(220),G1H32(221),G1H32(222),32)
  call HG1shiftOLR(G1H32(218),8,32)
  call Hotf_5pt_reduction(G2H32(42),RedSet_5(20),mass5set(:,3),  & 
G1H32(223),G1H32(224),G1H32(225),G1H32(226),G1H32(227),G1H32(228),32)
  call HG1shiftOLR(G1H32(224),8,32)
  call Hotf_5pt_reduction(G2H32(43),RedSet_5(22),mass5set(:,5),  & 
G1H32(229),G1H32(230),G1H32(231),G1H32(232),G1H32(233),G1H32(234),32)
  call HG1shiftOLR(G1H32(230),32,32)
  call Hotf_5pt_reduction(G2H32(44),RedSet_5(22),mass5set(:,5),  & 
G1H32(235),G1H32(236),G1H32(237),G1H32(238),G1H32(239),G1H32(240),32)
  call HG1shiftOLR(G1H32(236),32,32)
  call Hotf_5pt_reduction(G2H32(45),RedSet_5(21),mass5set(:,3),  & 
G1H32(241),G1H32(242),G1H32(243),G1H32(244),G1H32(245),G1H32(246),32)
  call HG1shiftOLR(G1H32(242),8,32)
  call Hotf_5pt_reduction(G2H32(46),RedSet_5(21),mass5set(:,3),  & 
G1H32(247),G1H32(248),G1H32(249),G1H32(250),G1H32(251),G1H32(252),32)
  call HG1shiftOLR(G1H32(248),8,32)
  call Hotf_5pt_reduction(G2H32(47),RedSet_5(22),mass5set(:,5),  & 
G1H32(253),G1H32(254),G1H32(255),G1H32(256),G1H32(257),G1H32(258),32)
  call HG1shiftOLR(G1H32(254),16,32)
  call Hotf_5pt_reduction(G2H32(48),RedSet_5(22),mass5set(:,5),  & 
G1H32(259),G1H32(260),G1H32(261),G1H32(262),G1H32(263),G1H32(264),32)
  call HG1shiftOLR(G1H32(260),16,32)
  call Hloop_QV_A(ntryL,G1H16(1),ex6(:),G1H8(1),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_Q_A(ntryL,G1H8(1),99,nMT,G2H8(13),n2h8(1))
call HGT_OLR(G1H16(2),1,1,16)
call HGT_invQ_OLR(G1H16(2),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(2),-16,nMT,G2H16(10),n2h16(65))
  call Hloop_AV_Q(ntryL,G2H16(10),ex5(:),G2H8(14),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_QV_A(ntryL,G1H16(4),ex6(:),G1H8(1),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_Q_A(ntryL,G1H8(1),99,nMT,G2H8(15),n2h8(2))
  call Hloop_QV_A(ntryL,G1H16(5),ex6(:),G1H8(1),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_Q_A(ntryL,G1H8(1),99,nMT,G2H8(16),n2h8(3))
  call Hloop_QV_A(ntryL,G1H16(6),ex6(:),G1H8(1),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_Q_A(ntryL,G1H8(1),99,nMT,G2H8(17),n2h8(4))
  call Hloop_AV_Q(ntryL,G1H16(7),ex5(:),G1H8(1),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_A_Q(ntryL,G1H8(1),83,nMT,G2H8(18),n2h8(5))
call HGT_OLR(G1H16(8),1,1,16)
call HGT_invQ_OLR(G1H16(8),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(8),-32,nMT,G2H16(12),n2h16(66))
  call Hloop_QV_A(ntryL,G2H16(12),ex6(:),G2H8(19),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_AV_Q(ntryL,G1H16(10),ex5(:),G1H8(1),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_A_Q(ntryL,G1H8(1),83,nMT,G2H8(20),n2h8(6))
  call Hloop_AV_Q(ntryL,G1H16(11),ex5(:),G1H8(1),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_A_Q(ntryL,G1H8(1),83,nMT,G2H8(21),n2h8(7))
  call Hloop_AV_Q(ntryL,G1H16(12),ex5(:),G1H8(1),m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_A_Q(ntryL,G1H8(1),83,nMT,G2H8(22),n2h8(8))
  call Hloop_AV_Q(ntryL,G1H16(13),ex6(:),G1H8(1),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_A_Q(ntryL,G1H8(1),99,nMT,G2H8(23),n2h8(9))
call HGT_OLR(G1H16(14),1,1,16)
call HGT_invQ_OLR(G1H16(14),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(14),-8,nMT,G2H16(14),n2h16(67))
  call Hloop_QA_V(ntryL,G2H16(14),ex4(:),G2H8(24),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_AV_Q(ntryL,G1H16(16),ex6(:),G1H8(1),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_A_Q(ntryL,G1H8(1),99,nMT,G2H8(25),n2h8(10))
  call Hloop_AV_Q(ntryL,G1H16(17),ex6(:),G1H8(1),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_A_Q(ntryL,G1H8(1),99,nMT,G2H8(26),n2h8(11))
  call Hloop_AV_Q(ntryL,G1H16(18),ex6(:),G1H8(1),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_A_Q(ntryL,G1H8(1),99,nMT,G2H8(27),n2h8(12))
  call Hloop_AV_Q(ntryL,G1H16(19),ex6(:),G1H8(1),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_A_Q(ntryL,G1H8(1),99,nMT,G2H8(28),n2h8(13))
call HGT_OLR(G1H16(20),1,1,16)
call HGT_invQ_OLR(G1H16(20),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(20),-16,nMT,G2H16(16),n2h16(68))
  call Hloop_QV_A(ntryL,G2H16(16),ex5(:),G2H8(29),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_AV_Q(ntryL,G1H16(22),ex6(:),G1H8(1),m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_A_Q(ntryL,G1H8(1),99,nMT,G2H8(30),n2h8(14))
  call Hloop_AV_Q(ntryL,G1H16(23),ex6(:),G1H8(1),m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_A_Q(ntryL,G1H8(1),99,nMT,G2H8(31),n2h8(15))
  call Hloop_AV_Q(ntryL,G1H16(24),ex6(:),G1H8(1),m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_A_Q(ntryL,G1H8(1),99,nMT,G2H8(32),n2h8(16))
  call Hloop_QV_A(ntryL,G1H16(25),ex5(:),G1H8(1),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMT,G2H8(33),n2h8(17))
call HGT_OLR(G1H16(26),1,1,16)
call HGT_invQ_OLR(G1H16(26),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(26),-32,nMT,G2H16(18),n2h16(69))
  call Hloop_AV_Q(ntryL,G2H16(18),ex6(:),G2H8(34),m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_QV_A(ntryL,G1H16(28),ex5(:),G1H8(1),m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMT,G2H8(35),n2h8(18))
  call Hloop_QV_A(ntryL,G1H16(29),ex5(:),G1H8(1),m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMT,G2H8(36),n2h8(19))
  call Hloop_QV_A(ntryL,G1H16(30),ex5(:),G1H8(1),m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMT,G2H8(37),n2h8(20))
  call Hloop_AV_Q(ntryL,G1H16(31),ex5(:),G1H8(1),m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_A_Q(ntryL,G1H8(1),83,nMT,G2H8(38),n2h8(21))
call HGT_OLR(G1H16(32),1,1,16)
call HGT_invQ_OLR(G1H16(32),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(32),-8,nMT,G2H16(20),n2h16(70))
  call Hloop_QA_V(ntryL,G2H16(20),ex4(:),G2H8(39),m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_AV_Q(ntryL,G1H16(34),ex5(:),G1H8(1),m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_A_Q(ntryL,G1H8(1),83,nMT,G2H8(40),n2h8(22))
  call Hloop_AV_Q(ntryL,G1H16(35),ex5(:),G1H8(1),m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_A_Q(ntryL,G1H8(1),83,nMT,G2H8(41),n2h8(23))
  call Hloop_AV_Q(ntryL,G1H16(36),ex5(:),G1H8(1),m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_A_Q(ntryL,G1H8(1),83,nMT,G2H8(42),n2h8(24))
  call Hloop_QV_A(ntryL,G1H32(25),wf4(:,1),G1H8(1),m3h4x8(:,1),heltab2x32(:,:,29))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMT,G2H8(43),n2h8(25))
call HGT_OLR(G1H32(1),1,1,32)
call HGT_invQ_OLR(G1H32(1),2,5,32)
  call Hloop_A_Q(ntryL,G1H32(1),-32,nMT,G2H32(1),n2h32(45))
  call Hloop_AV_Q(ntryL,G2H32(1),ex6(:),G2H16(22),m3h2x16(:,29),heltab2x32(:,:,30))
  call Hloop_QV_A(ntryL,G1H32(3),wf4(:,1),G1H8(1),m3h4x8(:,2),heltab2x32(:,:,31))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMT,G2H8(44),n2h8(26))
  call Hloop_QV_A(ntryL,G1H32(4),wf4(:,1),G1H8(1),m3h4x8(:,3),heltab2x32(:,:,32))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMT,G2H8(45),n2h8(27))
  call Hloop_QV_A(ntryL,G1H32(26),wf4(:,1),G1H8(1),m3h4x8(:,4),heltab2x32(:,:,33))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMT,G2H8(46),n2h8(28))
  call Hloop_QZ_A(ntryL,G1H32(27),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,5),heltab2x32(:,:,34))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMT,G2H8(47),n2h8(29))
call HGT_OLR(G1H32(28),1,1,32)
call HGT_invQ_OLR(G1H32(28),2,5,32)
  call Hloop_A_Q(ntryL,G1H32(28),-32,nMT,G2H32(2),n2h32(46))
  call Hloop_AV_Q(ntryL,G2H32(2),ex6(:),G2H16(24),m3h2x16(:,30),heltab2x32(:,:,35))
  call Hloop_QZ_A(ntryL,G1H32(30),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,6),heltab2x32(:,:,36))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMT,G2H8(48),n2h8(30))
  call Hloop_QZ_A(ntryL,G1H32(31),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,7),heltab2x32(:,:,37))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMT,G2H8(49),n2h8(31))
  call Hloop_QZ_A(ntryL,G1H32(32),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,8),heltab2x32(:,:,38))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMT,G2H8(50),n2h8(32))
  call Hloop_QV_A(ntryL,G1H16(37),ex6(:),G1H8(1),m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_Q_A(ntryL,G1H8(1),99,nMT,G2H8(51),n2h8(33))
call HGT_OLR(G1H16(38),1,1,16)
call HGT_invQ_OLR(G1H16(38),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(38),-4,nMT,G2H16(26),n2h16(71))
  call Hloop_AQ_V(ntryL,G2H16(26),ex3(:),G2H8(52),m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_QV_A(ntryL,G1H16(40),ex6(:),G1H8(1),m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_Q_A(ntryL,G1H8(1),99,nMT,G2H8(53),n2h8(34))
  call Hloop_QV_A(ntryL,G1H16(41),ex6(:),G1H8(1),m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_Q_A(ntryL,G1H8(1),99,nMT,G2H8(54),n2h8(35))
  call Hloop_QV_A(ntryL,G1H16(42),ex6(:),G1H8(1),m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_Q_A(ntryL,G1H8(1),99,nMT,G2H8(55),n2h8(36))
  call Hloop_QV_A(ntryL,G1H16(43),ex5(:),G1H8(1),m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMT,G2H8(56),n2h8(37))
call HGT_OLR(G1H16(44),1,1,16)
call HGT_invQ_OLR(G1H16(44),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(44),-4,nMT,G2H16(28),n2h16(72))
  call Hloop_AQ_V(ntryL,G2H16(28),ex3(:),G2H8(57),m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_QV_A(ntryL,G1H16(46),ex5(:),G1H8(1),m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMT,G2H8(58),n2h8(38))
  call Hloop_QV_A(ntryL,G1H16(47),ex5(:),G1H8(1),m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMT,G2H8(59),n2h8(39))
  call Hloop_QV_A(ntryL,G1H16(48),ex5(:),G1H8(1),m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMT,G2H8(60),n2h8(40))
  call Hloop_AV_Q(ntryL,G1H32(5),wf4(:,1),G1H8(1),m3h4x8(:,9),heltab2x32(:,:,39))
  call Hloop_A_Q(ntryL,G1H8(1),83,nMT,G2H8(61),n2h8(41))
call HGT_OLR(G1H32(6),1,1,32)
call HGT_invQ_OLR(G1H32(6),2,5,32)
  call Hloop_Q_A(ntryL,G1H32(6),-32,nMT,G2H32(3),n2h32(47))
  call Hloop_QV_A(ntryL,G2H32(3),ex6(:),G2H16(30),m3h2x16(:,31),heltab2x32(:,:,40))
  call Hloop_AV_Q(ntryL,G1H32(8),wf4(:,1),G1H8(1),m3h4x8(:,10),heltab2x32(:,:,41))
  call Hloop_A_Q(ntryL,G1H8(1),83,nMT,G2H8(62),n2h8(42))
  call Hloop_AV_Q(ntryL,G1H32(9),wf4(:,1),G1H8(1),m3h4x8(:,11),heltab2x32(:,:,42))
  call Hloop_A_Q(ntryL,G1H8(1),83,nMT,G2H8(63),n2h8(43))
  call Hloop_AV_Q(ntryL,G1H32(10),wf4(:,1),G1H8(1),m3h4x8(:,12),heltab2x32(:,:,43))
  call Hloop_A_Q(ntryL,G1H8(1),83,nMT,G2H8(64),n2h8(44))
  call Hloop_AZ_Q(ntryL,G1H32(11),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,13),heltab2x32(:,:,44))
  call Hloop_A_Q(ntryL,G1H8(1),83,nMT,G2H8(65),n2h8(45))
call HGT_OLR(G1H32(12),1,1,32)
call HGT_invQ_OLR(G1H32(12),2,5,32)
  call Hloop_Q_A(ntryL,G1H32(12),-32,nMT,G2H32(4),n2h32(48))
  call Hloop_QV_A(ntryL,G2H32(4),ex6(:),G2H16(32),m3h2x16(:,32),heltab2x32(:,:,45))
  call Hloop_AZ_Q(ntryL,G1H32(34),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,14),heltab2x32(:,:,46))
  call Hloop_A_Q(ntryL,G1H8(1),83,nMT,G2H8(66),n2h8(46))
  call Hloop_AZ_Q(ntryL,G1H32(35),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,15),heltab2x32(:,:,47))
  call Hloop_A_Q(ntryL,G1H8(1),83,nMT,G2H8(67),n2h8(47))
  call Hloop_AZ_Q(ntryL,G1H32(36),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,16),heltab2x32(:,:,48))
  call Hloop_A_Q(ntryL,G1H8(1),83,nMT,G2H8(68),n2h8(48))
  call Hloop_AV_Q(ntryL,G1H16(49),ex6(:),G1H8(1),m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_A_Q(ntryL,G1H8(1),99,nMT,G2H8(69),n2h8(49))
call HGT_OLR(G1H16(50),1,1,16)
call HGT_invQ_OLR(G1H16(50),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(50),-8,nMT,G2H16(34),n2h16(73))
  call Hloop_QA_V(ntryL,G2H16(34),ex4(:),G2H8(70),m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_AV_Q(ntryL,G1H16(52),ex6(:),G1H8(1),m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_A_Q(ntryL,G1H8(1),99,nMT,G2H8(71),n2h8(50))
  call Hloop_AV_Q(ntryL,G1H16(53),ex6(:),G1H8(1),m3h2x8(:,56),heltab2x16(:,:,56))
  call Hloop_A_Q(ntryL,G1H8(1),99,nMT,G2H8(72),n2h8(51))
  call Hloop_AV_Q(ntryL,G1H16(54),ex6(:),G1H8(1),m3h2x8(:,57),heltab2x16(:,:,57))
  call Hloop_A_Q(ntryL,G1H8(1),99,nMT,G2H8(73),n2h8(52))
  call Hloop_AV_Q(ntryL,G1H16(55),ex5(:),G1H8(1),m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_A_Q(ntryL,G1H8(1),83,nMT,G2H8(74),n2h8(53))
call HGT_OLR(G1H16(56),1,1,16)
call HGT_invQ_OLR(G1H16(56),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(56),-8,nMT,G2H16(36),n2h16(74))
  call Hloop_QA_V(ntryL,G2H16(36),ex4(:),G2H8(75),m3h2x8(:,59),heltab2x16(:,:,59))
  call Hloop_AV_Q(ntryL,G1H16(58),ex5(:),G1H8(1),m3h2x8(:,60),heltab2x16(:,:,60))
  call Hloop_A_Q(ntryL,G1H8(1),83,nMT,G2H8(76),n2h8(54))
  call Hloop_AV_Q(ntryL,G1H16(59),ex5(:),G1H8(1),m3h2x8(:,61),heltab2x16(:,:,61))
  call Hloop_A_Q(ntryL,G1H8(1),83,nMT,G2H8(77),n2h8(55))
  call Hloop_AV_Q(ntryL,G1H16(60),ex5(:),G1H8(1),m3h2x8(:,62),heltab2x16(:,:,62))
  call Hloop_A_Q(ntryL,G1H8(1),83,nMT,G2H8(78),n2h8(56))
  call Hloop_AV_Q(ntryL,G1H32(13),wf4(:,1),G1H8(1),m3h4x8(:,17),heltab2x32(:,:,49))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(79),n2h8(57))
call HGT_raise_alpha_OLR(G1H32(14),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(14),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(14),-16,ex5(:),16,G2H16(38),m3h2x16(:,33),heltab2x32(:,:,50))
call signflip_OLR(G2H16(38))
  call Hloop_AV_Q(ntryL,G1H32(16),wf4(:,1),G1H8(1),m3h4x8(:,18),heltab2x32(:,:,51))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(80),n2h8(58))
  call Hloop_AV_Q(ntryL,G1H32(37),wf4(:,1),G1H8(1),m3h4x8(:,19),heltab2x32(:,:,52))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(81),n2h8(59))
  call Hloop_AV_Q(ntryL,G1H32(38),wf4(:,1),G1H8(1),m3h4x8(:,20),heltab2x32(:,:,53))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(82),n2h8(60))
  call Hloop_AZ_Q(ntryL,G1H32(39),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,21),heltab2x32(:,:,54))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(83),n2h8(61))
call HGT_raise_alpha_OLR(G1H32(40),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(40),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(40),-16,ex5(:),16,G2H16(40),m3h2x16(:,34),heltab2x32(:,:,55))
call signflip_OLR(G2H16(40))
  call Hloop_AZ_Q(ntryL,G1H32(42),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,22),heltab2x32(:,:,56))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(84),n2h8(62))
  call Hloop_AZ_Q(ntryL,G1H32(43),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,23),heltab2x32(:,:,57))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(85),n2h8(63))
  call Hloop_AZ_Q(ntryL,G1H32(44),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,24),heltab2x32(:,:,58))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(86),n2h8(64))
  call Hloop_AV_Q(ntryL,G1H32(45),wf4(:,1),G1H8(1),m3h4x8(:,25),heltab2x32(:,:,59))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(87),n2h8(65))
call HGT_raise_alpha_OLR(G1H32(46),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(46),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(46),-32,ex6(:),32,G2H16(42),m3h2x16(:,35),heltab2x32(:,:,60))
call signflip_OLR(G2H16(42))
  call Hloop_AV_Q(ntryL,G1H32(48),wf4(:,1),G1H8(1),m3h4x8(:,26),heltab2x32(:,:,61))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(88),n2h8(66))
  call Hloop_AV_Q(ntryL,G1H32(49),wf4(:,1),G1H8(1),m3h4x8(:,27),heltab2x32(:,:,62))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(89),n2h8(67))
  call Hloop_AV_Q(ntryL,G1H32(50),wf4(:,1),G1H8(1),m3h4x8(:,28),heltab2x32(:,:,63))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(90),n2h8(68))
  call Hloop_AZ_Q(ntryL,G1H32(51),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,29),heltab2x32(:,:,64))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(91),n2h8(69))
call HGT_raise_alpha_OLR(G1H32(52),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(52),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(52),-32,ex6(:),32,G2H16(44),m3h2x16(:,36),heltab2x32(:,:,65))
call signflip_OLR(G2H16(44))
  call Hloop_AZ_Q(ntryL,G1H32(54),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,30),heltab2x32(:,:,66))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(92),n2h8(70))
  call Hloop_AZ_Q(ntryL,G1H32(55),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,31),heltab2x32(:,:,67))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(93),n2h8(71))
  call Hloop_AZ_Q(ntryL,G1H32(56),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,32),heltab2x32(:,:,68))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(94),n2h8(72))
  call Hloop_QV_A(ntryL,G1H16(61),ex6(:),G1H8(1),m3h2x8(:,63),heltab2x16(:,:,63))
  call Hloop_Q_A(ntryL,G1H8(1),99,nMT,G2H8(95),n2h8(73))
call HGT_OLR(G1H16(62),1,1,16)
call HGT_invQ_OLR(G1H16(62),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(62),-4,nMT,G2H16(46),n2h16(75))
  call Hloop_AQ_V(ntryL,G2H16(46),ex3(:),G2H8(96),m3h2x8(:,64),heltab2x16(:,:,64))
  call Hloop_QV_A(ntryL,G1H16(64),ex6(:),G1H8(1),m3h2x8(:,65),heltab2x16(:,:,65))
  call Hloop_Q_A(ntryL,G1H8(1),99,nMT,G2H8(97),n2h8(74))
  call Hloop_QV_A(ntryL,G1H16(65),ex6(:),G1H8(1),m3h2x8(:,66),heltab2x16(:,:,66))
  call Hloop_Q_A(ntryL,G1H8(1),99,nMT,G2H8(98),n2h8(75))
  call Hloop_QV_A(ntryL,G1H16(66),ex6(:),G1H8(1),m3h2x8(:,67),heltab2x16(:,:,67))
  call Hloop_Q_A(ntryL,G1H8(1),99,nMT,G2H8(99),n2h8(76))
  call Hloop_QV_A(ntryL,G1H32(17),ex5(:),G1H16(1),m3h2x16(:,37),heltab2x32(:,:,69))
  call Hloop_Q_A(ntryL,G1H16(1),84,nMT,G2H16(48),n2h16(76))
call HGT_raise_alpha_OLR(G1H32(18),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(18),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(18),ex4(:),G1H16(2),m3h2x16(:,38),heltab2x32(:,:,70))
  call Hloop_QV_A(ntryL,G1H32(58),ex5(:),G1H16(4),m3h2x16(:,39),heltab2x32(:,:,71))
  call Hloop_Q_A(ntryL,G1H16(4),84,nMT,G2H16(10),n2h16(77))
  call Hloop_QV_A(ntryL,G1H32(59),ex5(:),G1H16(5),m3h2x16(:,40),heltab2x32(:,:,72))
  call Hloop_Q_A(ntryL,G1H16(5),84,nMT,G2H16(12),n2h16(78))
  call Hloop_QV_A(ntryL,G1H32(60),ex5(:),G1H16(6),m3h2x16(:,41),heltab2x32(:,:,73))
  call Hloop_Q_A(ntryL,G1H16(6),84,nMT,G2H16(14),n2h16(79))
  call Hloop_QV_A(ntryL,G1H32(61),ex5(:),G1H16(7),m3h2x16(:,42),heltab2x32(:,:,74))
  call Hloop_Q_A(ntryL,G1H16(7),84,nMT,G2H16(16),n2h16(80))
call HGT_raise_alpha_OLR(G1H32(62),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(62),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(62),ex4(:),G1H16(8),m3h2x16(:,43),heltab2x32(:,:,75))
  call Hloop_QV_A(ntryL,G1H32(64),ex5(:),G1H16(10),m3h2x16(:,44),heltab2x32(:,:,76))
  call Hloop_Q_A(ntryL,G1H16(10),84,nMT,G2H16(18),n2h16(81))
  call Hloop_QV_A(ntryL,G1H32(65),ex5(:),G1H16(11),m3h2x16(:,45),heltab2x32(:,:,77))
  call Hloop_Q_A(ntryL,G1H16(11),84,nMT,G2H16(20),n2h16(82))
  call Hloop_QV_A(ntryL,G1H32(66),ex5(:),G1H16(12),m3h2x16(:,46),heltab2x32(:,:,78))
  call Hloop_Q_A(ntryL,G1H16(12),84,nMT,G2H16(26),n2h16(83))
  call Hloop_QV_A(ntryL,G1H32(67),ex5(:),G1H16(13),m3h2x16(:,47),heltab2x32(:,:,79))
  call Hloop_Q_A(ntryL,G1H16(13),84,nMT,G2H16(28),n2h16(84))
call HGT_raise_alpha_OLR(G1H32(68),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(68),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(68),-32,ex6(:),32,G2H16(34),m3h2x16(:,48),heltab2x32(:,:,80))
call signflip_OLR(G2H16(34))
  call Hloop_QV_A(ntryL,G1H32(70),ex5(:),G1H16(14),m3h2x16(:,49),heltab2x32(:,:,81))
  call Hloop_Q_A(ntryL,G1H16(14),84,nMT,G2H16(36),n2h16(85))
  call Hloop_QV_A(ntryL,G1H32(71),ex5(:),G1H16(16),m3h2x16(:,50),heltab2x32(:,:,82))
  call Hloop_Q_A(ntryL,G1H16(16),84,nMT,G2H16(46),n2h16(86))
  call Hloop_QV_A(ntryL,G1H32(72),ex5(:),G1H16(17),m3h2x16(:,51),heltab2x32(:,:,83))
  call Hloop_Q_A(ntryL,G1H16(17),84,nMT,G2H16(49),n2h16(87))
  call Hloop_QV_A(ntryL,G1H32(73),ex5(:),G1H16(18),m3h2x16(:,52),heltab2x32(:,:,84))
  call Hloop_Q_A(ntryL,G1H16(18),84,nMT,G2H16(50),n2h16(88))
call HGT_raise_alpha_OLR(G1H32(74),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(74),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(74),-32,ex6(:),32,G2H16(51),m3h2x16(:,53),heltab2x32(:,:,85))
call signflip_OLR(G2H16(51))
  call Hloop_QV_A(ntryL,G1H32(76),ex5(:),G1H16(19),m3h2x16(:,54),heltab2x32(:,:,86))
  call Hloop_Q_A(ntryL,G1H16(19),84,nMT,G2H16(52),n2h16(89))
  call Hloop_QV_A(ntryL,G1H32(77),ex5(:),G1H16(20),m3h2x16(:,55),heltab2x32(:,:,87))
  call Hloop_Q_A(ntryL,G1H16(20),84,nMT,G2H16(53),n2h16(90))
  call Hloop_QV_A(ntryL,G1H32(78),ex5(:),G1H16(22),m3h2x16(:,56),heltab2x32(:,:,88))
  call Hloop_Q_A(ntryL,G1H16(22),84,nMT,G2H16(54),n2h16(91))
  call Hloop_QV_A(ntryL,G1H32(79),ex5(:),G1H16(23),m3h2x16(:,57),heltab2x32(:,:,89))
  call Hloop_Q_A(ntryL,G1H16(23),84,nMT,G2H16(55),n2h16(92))
call HGT_raise_alpha_OLR(G1H32(80),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(80),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(80),ex4(:),G1H16(24),m3h2x16(:,58),heltab2x32(:,:,90))
  call Hloop_QV_A(ntryL,G1H32(82),ex5(:),G1H16(25),m3h2x16(:,59),heltab2x32(:,:,91))
  call Hloop_Q_A(ntryL,G1H16(25),84,nMT,G2H16(56),n2h16(93))
  call Hloop_QV_A(ntryL,G1H32(83),ex5(:),G1H16(26),m3h2x16(:,60),heltab2x32(:,:,92))
  call Hloop_Q_A(ntryL,G1H16(26),84,nMT,G2H16(57),n2h16(94))
  call Hloop_QV_A(ntryL,G1H32(84),ex5(:),G1H16(28),m3h2x16(:,61),heltab2x32(:,:,93))
  call Hloop_Q_A(ntryL,G1H16(28),84,nMT,G2H16(58),n2h16(95))
  call Hloop_QV_A(ntryL,G1H32(85),ex5(:),G1H16(29),m3h2x16(:,62),heltab2x32(:,:,94))
  call Hloop_Q_A(ntryL,G1H16(29),84,nMT,G2H16(59),n2h16(96))
call HGT_raise_alpha_OLR(G1H32(86),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(86),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(86),ex4(:),G1H16(30),m3h2x16(:,63),heltab2x32(:,:,95))
  call Hloop_QV_A(ntryL,G1H32(88),ex5(:),G1H16(31),m3h2x16(:,64),heltab2x32(:,:,96))
  call Hloop_Q_A(ntryL,G1H16(31),84,nMT,G2H16(60),n2h16(97))
  call Hloop_QV_A(ntryL,G1H32(89),ex5(:),G1H16(32),m3h2x16(:,65),heltab2x32(:,:,97))
  call Hloop_Q_A(ntryL,G1H16(32),84,nMT,G2H16(61),n2h16(98))
  call Hloop_QV_A(ntryL,G1H32(90),ex5(:),G1H16(34),m3h2x16(:,66),heltab2x32(:,:,98))
  call Hloop_Q_A(ntryL,G1H16(34),84,nMT,G2H16(62),n2h16(99))
  call Hloop_AV_Q(ntryL,G1H32(19),ex6(:),G1H16(35),m3h2x16(:,67),heltab2x32(:,:,99))
  call Hloop_A_Q(ntryL,G1H16(35),104,nMT,G2H16(63),n2h16(100))
call HGT_raise_alpha_OLR(G1H32(20),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(20),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(20),-16,ex5(:),16,G2H16(64),m3h2x16(:,68),heltab2x32(:,:,100))
call signflip_OLR(G2H16(64))
  call Hloop_AV_Q(ntryL,G1H32(92),ex6(:),G1H16(36),m3h2x16(:,69),heltab2x32(:,:,101))
  call Hloop_A_Q(ntryL,G1H16(36),104,nMT,G2H16(65),n2h16(101))
  call Hloop_AV_Q(ntryL,G1H32(93),ex6(:),G1H16(37),m3h2x16(:,70),heltab2x32(:,:,102))
  call Hloop_A_Q(ntryL,G1H16(37),104,nMT,G2H16(66),n2h16(102))
  call Hloop_AV_Q(ntryL,G1H32(94),ex6(:),G1H16(38),m3h2x16(:,71),heltab2x32(:,:,103))
  call Hloop_A_Q(ntryL,G1H16(38),104,nMT,G2H16(67),n2h16(103))
  call Hloop_AV_Q(ntryL,G1H32(95),ex6(:),G1H16(40),m3h2x16(:,72),heltab2x32(:,:,104))
  call Hloop_A_Q(ntryL,G1H16(40),104,nMT,G2H16(68),n2h16(104))
call HGT_raise_alpha_OLR(G1H32(96),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(96),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(96),-16,ex5(:),16,G2H16(69),m3h2x16(:,73),heltab2x32(:,:,105))
call signflip_OLR(G2H16(69))
  call Hloop_AV_Q(ntryL,G1H32(98),ex6(:),G1H16(41),m3h2x16(:,74),heltab2x32(:,:,106))
  call Hloop_A_Q(ntryL,G1H16(41),104,nMT,G2H16(70),n2h16(105))
  call Hloop_AV_Q(ntryL,G1H32(99),ex6(:),G1H16(42),m3h2x16(:,75),heltab2x32(:,:,107))
  call Hloop_A_Q(ntryL,G1H16(42),104,nMT,G2H16(71),n2h16(106))
  call Hloop_AV_Q(ntryL,G1H32(100),ex6(:),G1H16(43),m3h2x16(:,76),heltab2x32(:,:,108))
  call Hloop_A_Q(ntryL,G1H16(43),104,nMT,G2H16(72),n2h16(107))
  call Hloop_VQ_A(ntryL,G1H32(101),ex3(:),G1H16(44),m3h2x16(:,77),heltab2x32(:,:,109))
  call Hloop_Q_A(ntryL,G1H16(44),84,nMT,G2H16(73),n2h16(108))
call HGT_raise_alpha_OLR(G1H32(102),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(102),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(102),-32,ex6(:),32,G2H16(74),m3h2x16(:,78),heltab2x32(:,:,110))
call signflip_OLR(G2H16(74))
  call Hloop_VQ_A(ntryL,G1H32(104),ex3(:),G1H16(46),m3h2x16(:,79),heltab2x32(:,:,111))
  call Hloop_Q_A(ntryL,G1H16(46),84,nMT,G2H16(75),n2h16(109))
  call Hloop_VQ_A(ntryL,G1H32(105),ex3(:),G1H16(47),m3h2x16(:,80),heltab2x32(:,:,112))
  call Hloop_Q_A(ntryL,G1H16(47),84,nMT,G2H16(76),n2h16(110))
  call Hloop_VQ_A(ntryL,G1H32(106),ex3(:),G1H16(48),m3h2x16(:,81),heltab2x32(:,:,113))
  call Hloop_Q_A(ntryL,G1H16(48),84,nMT,G2H16(77),n2h16(111))
  call Hloop_VQ_A(ntryL,G1H32(107),ex3(:),G1H16(49),m3h2x16(:,82),heltab2x32(:,:,114))
  call Hloop_Q_A(ntryL,G1H16(49),84,nMT,G2H16(78),n2h16(112))
call HGT_raise_alpha_OLR(G1H32(108),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(108),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(108),-32,ex6(:),32,G2H16(79),m3h2x16(:,83),heltab2x32(:,:,115))
call signflip_OLR(G2H16(79))
  call Hloop_VQ_A(ntryL,G1H32(110),ex3(:),G1H16(50),m3h2x16(:,84),heltab2x32(:,:,116))
  call Hloop_Q_A(ntryL,G1H16(50),84,nMT,G2H16(80),n2h16(113))
  call Hloop_VQ_A(ntryL,G1H32(111),ex3(:),G1H16(52),m3h2x16(:,85),heltab2x32(:,:,117))
  call Hloop_Q_A(ntryL,G1H16(52),84,nMT,G2H16(81),n2h16(114))
  call Hloop_VQ_A(ntryL,G1H32(112),ex3(:),G1H16(53),m3h2x16(:,86),heltab2x32(:,:,118))
  call Hloop_Q_A(ntryL,G1H16(53),84,nMT,G2H16(82),n2h16(115))
  call Hloop_AV_Q(ntryL,G1H32(113),wf4(:,1),G1H8(1),m3h4x8(:,33),heltab2x32(:,:,119))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(100),n2h8(77))
call HGT_raise_alpha_OLR(G1H32(114),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(114),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(114),-32,ex6(:),32,G2H16(83),m3h2x16(:,87),heltab2x32(:,:,120))
call signflip_OLR(G2H16(83))
  call Hloop_AV_Q(ntryL,G1H32(116),wf4(:,1),G1H8(1),m3h4x8(:,34),heltab2x32(:,:,121))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(101),n2h8(78))
  call Hloop_AV_Q(ntryL,G1H32(117),wf4(:,1),G1H8(1),m3h4x8(:,35),heltab2x32(:,:,122))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(102),n2h8(79))
  call Hloop_AV_Q(ntryL,G1H32(118),wf4(:,1),G1H8(1),m3h4x8(:,36),heltab2x32(:,:,123))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(103),n2h8(80))
  call Hloop_AZ_Q(ntryL,G1H32(119),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,37),heltab2x32(:,:,124))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(104),n2h8(81))
call HGT_raise_alpha_OLR(G1H32(120),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(120),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(120),-32,ex6(:),32,G2H16(84),m3h2x16(:,88),heltab2x32(:,:,125))
call signflip_OLR(G2H16(84))
  call Hloop_AZ_Q(ntryL,G1H32(122),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,38),heltab2x32(:,:,126))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(105),n2h8(82))
  call Hloop_AZ_Q(ntryL,G1H32(123),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,39),heltab2x32(:,:,127))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(106),n2h8(83))
  call Hloop_AZ_Q(ntryL,G1H32(124),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,40),heltab2x32(:,:,128))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(107),n2h8(84))
  call Hloop_QV_A(ntryL,G1H16(67),ex5(:),G1H8(1),m3h2x8(:,68),heltab2x16(:,:,68))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMT,G2H8(108),n2h8(85))
call HGT_OLR(G1H16(68),1,1,16)
call HGT_invQ_OLR(G1H16(68),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(68),-4,nMT,G2H16(85),n2h16(116))
  call Hloop_AQ_V(ntryL,G2H16(85),ex3(:),G2H8(109),m3h2x8(:,69),heltab2x16(:,:,69))
  call Hloop_QV_A(ntryL,G1H16(70),ex5(:),G1H8(1),m3h2x8(:,70),heltab2x16(:,:,70))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMT,G2H8(110),n2h8(86))
  call Hloop_QV_A(ntryL,G1H16(71),ex5(:),G1H8(1),m3h2x8(:,71),heltab2x16(:,:,71))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMT,G2H8(111),n2h8(87))
  call Hloop_QV_A(ntryL,G1H16(72),ex5(:),G1H8(1),m3h2x8(:,72),heltab2x16(:,:,72))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMT,G2H8(112),n2h8(88))
  call Hloop_QV_A(ntryL,G1H32(125),ex6(:),G1H16(54),m3h2x16(:,89),heltab2x32(:,:,129))
  call Hloop_Q_A(ntryL,G1H16(54),100,nMT,G2H16(85),n2h16(117))
call HGT_raise_alpha_OLR(G1H32(126),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(126),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(126),ex4(:),G1H16(55),m3h2x16(:,90),heltab2x32(:,:,130))
  call Hloop_QV_A(ntryL,G1H32(128),ex6(:),G1H16(56),m3h2x16(:,91),heltab2x32(:,:,131))
  call Hloop_Q_A(ntryL,G1H16(56),100,nMT,G2H16(86),n2h16(118))
  call Hloop_QV_A(ntryL,G1H32(129),ex6(:),G1H16(58),m3h2x16(:,92),heltab2x32(:,:,132))
  call Hloop_Q_A(ntryL,G1H16(58),100,nMT,G2H16(87),n2h16(119))
  call Hloop_QV_A(ntryL,G1H32(130),ex6(:),G1H16(59),m3h2x16(:,93),heltab2x32(:,:,133))
  call Hloop_Q_A(ntryL,G1H16(59),100,nMT,G2H16(88),n2h16(120))
  call Hloop_QV_A(ntryL,G1H32(131),ex6(:),G1H16(60),m3h2x16(:,94),heltab2x32(:,:,134))
  call Hloop_Q_A(ntryL,G1H16(60),100,nMT,G2H16(89),n2h16(121))
call HGT_raise_alpha_OLR(G1H32(132),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(132),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(132),ex4(:),G1H16(61),m3h2x16(:,95),heltab2x32(:,:,135))
  call Hloop_QV_A(ntryL,G1H32(134),ex6(:),G1H16(62),m3h2x16(:,96),heltab2x32(:,:,136))
  call Hloop_Q_A(ntryL,G1H16(62),100,nMT,G2H16(90),n2h16(122))
  call Hloop_QV_A(ntryL,G1H32(135),ex6(:),G1H16(64),m3h2x16(:,97),heltab2x32(:,:,137))
  call Hloop_Q_A(ntryL,G1H16(64),100,nMT,G2H16(91),n2h16(123))
  call Hloop_QV_A(ntryL,G1H32(136),ex6(:),G1H16(65),m3h2x16(:,98),heltab2x32(:,:,138))
  call Hloop_Q_A(ntryL,G1H16(65),100,nMT,G2H16(92),n2h16(124))
  call Hloop_QV_A(ntryL,G1H32(137),ex6(:),G1H16(66),m3h2x16(:,99),heltab2x32(:,:,139))
  call Hloop_Q_A(ntryL,G1H16(66),100,nMT,G2H16(93),n2h16(125))
call HGT_raise_alpha_OLR(G1H32(138),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(138),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(138),-16,ex5(:),16,G2H16(94),m3h2x16(:,100),heltab2x32(:,:,140))
call signflip_OLR(G2H16(94))
  call Hloop_QV_A(ntryL,G1H32(140),ex6(:),G1H16(1),m3h2x16(:,101),heltab2x32(:,:,141))
  call Hloop_Q_A(ntryL,G1H16(1),100,nMT,G2H16(95),n2h16(126))
  call Hloop_QV_A(ntryL,G1H32(141),ex6(:),G1H16(4),m3h2x16(:,102),heltab2x32(:,:,142))
  call Hloop_Q_A(ntryL,G1H16(4),100,nMT,G2H16(96),n2h16(127))
  call Hloop_QV_A(ntryL,G1H32(142),ex6(:),G1H16(5),m3h2x16(:,103),heltab2x32(:,:,143))
  call Hloop_Q_A(ntryL,G1H16(5),100,nMT,G2H16(97),n2h16(128))
  call Hloop_QV_A(ntryL,G1H32(143),ex6(:),G1H16(6),m3h2x16(:,104),heltab2x32(:,:,144))
  call Hloop_Q_A(ntryL,G1H16(6),100,nMT,G2H16(98),n2h16(129))
call HGT_raise_alpha_OLR(G1H32(144),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(144),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(144),-16,ex5(:),16,G2H16(99),m3h2x16(:,105),heltab2x32(:,:,145))
call signflip_OLR(G2H16(99))
  call Hloop_QV_A(ntryL,G1H32(146),ex6(:),G1H16(7),m3h2x16(:,106),heltab2x32(:,:,146))
  call Hloop_Q_A(ntryL,G1H16(7),100,nMT,G2H16(100),n2h16(130))
  call Hloop_QV_A(ntryL,G1H32(147),ex6(:),G1H16(10),m3h2x16(:,107),heltab2x32(:,:,147))
  call Hloop_Q_A(ntryL,G1H16(10),100,nMT,G2H16(101),n2h16(131))
  call Hloop_QV_A(ntryL,G1H32(148),ex6(:),G1H16(11),m3h2x16(:,108),heltab2x32(:,:,148))
  call Hloop_Q_A(ntryL,G1H16(11),100,nMT,G2H16(102),n2h16(132))
  call Hloop_QV_A(ntryL,G1H32(21),ex6(:),G1H16(12),m3h2x16(:,109),heltab2x32(:,:,149))
  call Hloop_Q_A(ntryL,G1H16(12),100,nMT,G2H16(103),n2h16(133))
call HGT_raise_alpha_OLR(G1H32(22),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(22),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(22),ex4(:),G1H16(13),m3h2x16(:,110),heltab2x32(:,:,150))
  call Hloop_QV_A(ntryL,G1H32(150),ex6(:),G1H16(14),m3h2x16(:,111),heltab2x32(:,:,151))
  call Hloop_Q_A(ntryL,G1H16(14),100,nMT,G2H16(104),n2h16(134))
  call Hloop_QV_A(ntryL,G1H32(151),ex6(:),G1H16(16),m3h2x16(:,112),heltab2x32(:,:,152))
  call Hloop_Q_A(ntryL,G1H16(16),100,nMT,G2H16(105),n2h16(135))
  call Hloop_QV_A(ntryL,G1H32(152),ex6(:),G1H16(17),m3h2x16(:,113),heltab2x32(:,:,153))
  call Hloop_Q_A(ntryL,G1H16(17),100,nMT,G2H16(106),n2h16(136))
  call Hloop_QV_A(ntryL,G1H32(153),ex6(:),G1H16(18),m3h2x16(:,114),heltab2x32(:,:,154))
  call Hloop_Q_A(ntryL,G1H16(18),100,nMT,G2H16(107),n2h16(137))
call HGT_raise_alpha_OLR(G1H32(154),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(154),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(154),ex4(:),G1H16(19),m3h2x16(:,115),heltab2x32(:,:,155))
  call Hloop_QV_A(ntryL,G1H32(156),ex6(:),G1H16(20),m3h2x16(:,116),heltab2x32(:,:,156))
  call Hloop_Q_A(ntryL,G1H16(20),100,nMT,G2H16(108),n2h16(138))
  call Hloop_QV_A(ntryL,G1H32(157),ex6(:),G1H16(22),m3h2x16(:,117),heltab2x32(:,:,157))
  call Hloop_Q_A(ntryL,G1H16(22),100,nMT,G2H16(109),n2h16(139))
  call Hloop_QV_A(ntryL,G1H32(158),ex6(:),G1H16(23),m3h2x16(:,118),heltab2x32(:,:,158))
  call Hloop_Q_A(ntryL,G1H16(23),100,nMT,G2H16(110),n2h16(140))
  call Hloop_AV_Q(ntryL,G1H32(159),ex5(:),G1H16(25),m3h2x16(:,119),heltab2x32(:,:,159))
  call Hloop_A_Q(ntryL,G1H16(25),88,nMT,G2H16(111),n2h16(141))
call HGT_raise_alpha_OLR(G1H32(160),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(160),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(160),-32,ex6(:),32,G2H16(112),m3h2x16(:,120),heltab2x32(:,:,160))
call signflip_OLR(G2H16(112))
  call Hloop_AV_Q(ntryL,G1H32(162),ex5(:),G1H16(26),m3h2x16(:,121),heltab2x32(:,:,161))
  call Hloop_A_Q(ntryL,G1H16(26),88,nMT,G2H16(113),n2h16(142))
  call Hloop_AV_Q(ntryL,G1H32(163),ex5(:),G1H16(28),m3h2x16(:,122),heltab2x32(:,:,162))
  call Hloop_A_Q(ntryL,G1H16(28),88,nMT,G2H16(114),n2h16(143))
  call Hloop_AV_Q(ntryL,G1H32(164),ex5(:),G1H16(29),m3h2x16(:,123),heltab2x32(:,:,163))
  call Hloop_A_Q(ntryL,G1H16(29),88,nMT,G2H16(115),n2h16(144))
  call Hloop_AV_Q(ntryL,G1H32(165),ex5(:),G1H16(31),m3h2x16(:,124),heltab2x32(:,:,164))
  call Hloop_A_Q(ntryL,G1H16(31),88,nMT,G2H16(116),n2h16(145))
call HGT_raise_alpha_OLR(G1H32(166),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(166),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(166),-32,ex6(:),32,G2H16(117),m3h2x16(:,125),heltab2x32(:,:,165))
call signflip_OLR(G2H16(117))
  call Hloop_AV_Q(ntryL,G1H32(168),ex5(:),G1H16(32),m3h2x16(:,126),heltab2x32(:,:,166))
  call Hloop_A_Q(ntryL,G1H16(32),88,nMT,G2H16(118),n2h16(146))
  call Hloop_AV_Q(ntryL,G1H32(169),ex5(:),G1H16(34),m3h2x16(:,127),heltab2x32(:,:,167))
  call Hloop_A_Q(ntryL,G1H16(34),88,nMT,G2H16(119),n2h16(147))
  call Hloop_AV_Q(ntryL,G1H32(170),ex5(:),G1H16(35),m3h2x16(:,128),heltab2x32(:,:,168))
  call Hloop_A_Q(ntryL,G1H16(35),88,nMT,G2H16(120),n2h16(148))
  call Hloop_VA_Q(ntryL,G1H32(171),ex4(:),G1H16(36),m3h2x16(:,129),heltab2x32(:,:,169))
  call Hloop_A_Q(ntryL,G1H16(36),88,nMT,G2H16(121),n2h16(149))
call HGT_raise_alpha_OLR(G1H32(172),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(172),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(172),-32,ex6(:),32,G2H16(122),m3h2x16(:,130),heltab2x32(:,:,170))
call signflip_OLR(G2H16(122))
  call Hloop_VA_Q(ntryL,G1H32(174),ex4(:),G1H16(37),m3h2x16(:,131),heltab2x32(:,:,171))
  call Hloop_A_Q(ntryL,G1H16(37),88,nMT,G2H16(123),n2h16(150))
  call Hloop_VA_Q(ntryL,G1H32(175),ex4(:),G1H16(38),m3h2x16(:,132),heltab2x32(:,:,172))
  call Hloop_A_Q(ntryL,G1H16(38),88,nMT,G2H16(124),n2h16(151))
  call Hloop_VA_Q(ntryL,G1H32(176),ex4(:),G1H16(40),m3h2x16(:,133),heltab2x32(:,:,173))
  call Hloop_A_Q(ntryL,G1H16(40),88,nMT,G2H16(125),n2h16(152))
  call Hloop_VA_Q(ntryL,G1H32(177),ex4(:),G1H16(41),m3h2x16(:,134),heltab2x32(:,:,174))
  call Hloop_A_Q(ntryL,G1H16(41),88,nMT,G2H16(126),n2h16(153))
call HGT_raise_alpha_OLR(G1H32(178),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(178),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(178),-32,ex6(:),32,G2H16(127),m3h2x16(:,135),heltab2x32(:,:,175))
call signflip_OLR(G2H16(127))
  call Hloop_VA_Q(ntryL,G1H32(180),ex4(:),G1H16(42),m3h2x16(:,136),heltab2x32(:,:,176))
  call Hloop_A_Q(ntryL,G1H16(42),88,nMT,G2H16(128),n2h16(154))
  call Hloop_VA_Q(ntryL,G1H32(181),ex4(:),G1H16(43),m3h2x16(:,137),heltab2x32(:,:,177))
  call Hloop_A_Q(ntryL,G1H16(43),88,nMT,G2H16(129),n2h16(155))
  call Hloop_VA_Q(ntryL,G1H32(182),ex4(:),G1H16(44),m3h2x16(:,138),heltab2x32(:,:,178))
  call Hloop_A_Q(ntryL,G1H16(44),88,nMT,G2H16(130),n2h16(156))
  call Hloop_AV_Q(ntryL,G1H32(23),wf4(:,1),G1H8(1),m3h4x8(:,41),heltab2x32(:,:,179))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(113),n2h8(89))
call HGT_raise_alpha_OLR(G1H32(24),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(24),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(24),-16,ex5(:),16,G2H16(131),m3h2x16(:,139),heltab2x32(:,:,180))
call signflip_OLR(G2H16(131))
  call Hloop_AV_Q(ntryL,G1H32(184),wf4(:,1),G1H8(1),m3h4x8(:,42),heltab2x32(:,:,181))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(114),n2h8(90))
  call Hloop_AV_Q(ntryL,G1H32(185),wf4(:,1),G1H8(1),m3h4x8(:,43),heltab2x32(:,:,182))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(115),n2h8(91))
  call Hloop_AV_Q(ntryL,G1H32(186),wf4(:,1),G1H8(1),m3h4x8(:,44),heltab2x32(:,:,183))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(116),n2h8(92))
  call Hloop_AZ_Q(ntryL,G1H32(187),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,45),heltab2x32(:,:,184))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(117),n2h8(93))
call HGT_raise_alpha_OLR(G1H32(188),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(188),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(188),-16,ex5(:),16,G2H16(132),m3h2x16(:,140),heltab2x32(:,:,185))
call signflip_OLR(G2H16(132))
  call Hloop_AZ_Q(ntryL,G1H32(190),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,46),heltab2x32(:,:,186))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(118),n2h8(94))
  call Hloop_AZ_Q(ntryL,G1H32(191),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,47),heltab2x32(:,:,187))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(119),n2h8(95))
  call Hloop_AZ_Q(ntryL,G1H32(192),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,48),heltab2x32(:,:,188))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(120),n2h8(96))
  call Hloop_QV_A(ntryL,G1H32(193),wf4(:,1),G1H8(1),m3h4x8(:,49),heltab2x32(:,:,189))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(121),n2h8(97))
call HGT_raise_alpha_OLR(G1H32(194),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(194),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(194),-16,ex5(:),16,G2H16(133),m3h2x16(:,141),heltab2x32(:,:,190))
call signflip_OLR(G2H16(133))
  call Hloop_QV_A(ntryL,G1H32(196),wf4(:,1),G1H8(1),m3h4x8(:,50),heltab2x32(:,:,191))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(122),n2h8(98))
  call Hloop_QV_A(ntryL,G1H32(197),wf4(:,1),G1H8(1),m3h4x8(:,51),heltab2x32(:,:,192))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(123),n2h8(99))
  call Hloop_QV_A(ntryL,G1H32(198),wf4(:,1),G1H8(1),m3h4x8(:,52),heltab2x32(:,:,193))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(124),n2h8(100))
  call Hloop_QZ_A(ntryL,G1H32(199),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,53),heltab2x32(:,:,194))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(125),n2h8(101))
call HGT_raise_alpha_OLR(G1H32(200),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(200),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(200),-16,ex5(:),16,G2H16(134),m3h2x16(:,142),heltab2x32(:,:,195))
call signflip_OLR(G2H16(134))
  call Hloop_QZ_A(ntryL,G1H32(202),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,54),heltab2x32(:,:,196))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(126),n2h8(102))
  call Hloop_QZ_A(ntryL,G1H32(203),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,55),heltab2x32(:,:,197))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(127),n2h8(103))
  call Hloop_QZ_A(ntryL,G1H32(204),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,56),heltab2x32(:,:,198))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(128),n2h8(104))
  call Hloop_QV_A(ntryL,G1H32(205),wf4(:,1),G1H8(1),m3h4x8(:,57),heltab2x32(:,:,199))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(129),n2h8(105))
call HGT_raise_alpha_OLR(G1H32(206),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(206),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(206),-32,ex6(:),32,G2H16(135),m3h2x16(:,143),heltab2x32(:,:,200))
call signflip_OLR(G2H16(135))
  call Hloop_QV_A(ntryL,G1H32(208),wf4(:,1),G1H8(1),m3h4x8(:,58),heltab2x32(:,:,201))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(130),n2h8(106))
  call Hloop_QV_A(ntryL,G1H32(209),wf4(:,1),G1H8(1),m3h4x8(:,59),heltab2x32(:,:,202))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(131),n2h8(107))
  call Hloop_QV_A(ntryL,G1H32(210),wf4(:,1),G1H8(1),m3h4x8(:,60),heltab2x32(:,:,203))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(132),n2h8(108))
  call Hloop_QZ_A(ntryL,G1H32(211),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,61),heltab2x32(:,:,204))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(133),n2h8(109))
call HGT_raise_alpha_OLR(G1H32(212),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(212),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(212),-32,ex6(:),32,G2H16(136),m3h2x16(:,144),heltab2x32(:,:,205))
call signflip_OLR(G2H16(136))
  call Hloop_QZ_A(ntryL,G1H32(214),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,62),heltab2x32(:,:,206))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(134),n2h8(110))
  call Hloop_QZ_A(ntryL,G1H32(215),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,63),heltab2x32(:,:,207))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(135),n2h8(111))
  call Hloop_QZ_A(ntryL,G1H32(216),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,64),heltab2x32(:,:,208))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(136),n2h8(112))
  call Hloop_QV_A(ntryL,G1H32(217),wf4(:,1),G1H8(1),m3h4x8(:,65),heltab2x32(:,:,209))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(137),n2h8(113))
call HGT_raise_alpha_OLR(G1H32(218),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(218),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(218),ex4(:),G1H16(46),m3h2x16(:,145),heltab2x32(:,:,210))
  call Hloop_QV_A(ntryL,G1H32(220),wf4(:,1),G1H8(1),m3h4x8(:,66),heltab2x32(:,:,211))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(138),n2h8(114))
  call Hloop_QV_A(ntryL,G1H32(221),wf4(:,1),G1H8(1),m3h4x8(:,67),heltab2x32(:,:,212))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(139),n2h8(115))
  call Hloop_QV_A(ntryL,G1H32(222),wf4(:,1),G1H8(1),m3h4x8(:,68),heltab2x32(:,:,213))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(140),n2h8(116))
  call Hloop_QZ_A(ntryL,G1H32(223),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,69),heltab2x32(:,:,214))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(141),n2h8(117))
call HGT_raise_alpha_OLR(G1H32(224),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(224),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(224),ex4(:),G1H16(47),m3h2x16(:,146),heltab2x32(:,:,215))
  call Hloop_QZ_A(ntryL,G1H32(226),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,70),heltab2x32(:,:,216))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(142),n2h8(118))
  call Hloop_QZ_A(ntryL,G1H32(227),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,71),heltab2x32(:,:,217))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(143),n2h8(119))
  call Hloop_QZ_A(ntryL,G1H32(228),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,72),heltab2x32(:,:,218))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(144),n2h8(120))
  call Hloop_QV_A(ntryL,G1H32(229),wf4(:,1),G1H8(1),m3h4x8(:,73),heltab2x32(:,:,219))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(145),n2h8(121))
call HGT_raise_alpha_OLR(G1H32(230),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(230),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(230),-32,ex6(:),32,G2H16(137),m3h2x16(:,147),heltab2x32(:,:,220))
call signflip_OLR(G2H16(137))
  call Hloop_QV_A(ntryL,G1H32(232),wf4(:,1),G1H8(1),m3h4x8(:,74),heltab2x32(:,:,221))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(146),n2h8(122))
  call Hloop_QV_A(ntryL,G1H32(233),wf4(:,1),G1H8(1),m3h4x8(:,75),heltab2x32(:,:,222))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(147),n2h8(123))
  call Hloop_QV_A(ntryL,G1H32(234),wf4(:,1),G1H8(1),m3h4x8(:,76),heltab2x32(:,:,223))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(148),n2h8(124))
  call Hloop_QZ_A(ntryL,G1H32(235),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,77),heltab2x32(:,:,224))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(149),n2h8(125))
call HGT_raise_alpha_OLR(G1H32(236),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(236),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(236),-32,ex6(:),32,G2H16(138),m3h2x16(:,148),heltab2x32(:,:,225))
call signflip_OLR(G2H16(138))
  call Hloop_QZ_A(ntryL,G1H32(238),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,78),heltab2x32(:,:,226))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(150),n2h8(126))
  call Hloop_QZ_A(ntryL,G1H32(239),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,79),heltab2x32(:,:,227))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(151),n2h8(127))
  call Hloop_QZ_A(ntryL,G1H32(240),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,80),heltab2x32(:,:,228))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(152),n2h8(128))
  call Hloop_QV_A(ntryL,G1H32(241),wf4(:,1),G1H8(1),m3h4x8(:,81),heltab2x32(:,:,229))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(153),n2h8(129))
call HGT_raise_alpha_OLR(G1H32(242),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(242),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(242),ex4(:),G1H16(48),m3h2x16(:,149),heltab2x32(:,:,230))
  call Hloop_QV_A(ntryL,G1H32(244),wf4(:,1),G1H8(1),m3h4x8(:,82),heltab2x32(:,:,231))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(154),n2h8(130))
  call Hloop_QV_A(ntryL,G1H32(245),wf4(:,1),G1H8(1),m3h4x8(:,83),heltab2x32(:,:,232))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(155),n2h8(131))
  call Hloop_QV_A(ntryL,G1H32(246),wf4(:,1),G1H8(1),m3h4x8(:,84),heltab2x32(:,:,233))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(156),n2h8(132))
  call Hloop_QZ_A(ntryL,G1H32(247),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,85),heltab2x32(:,:,234))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(157),n2h8(133))
call HGT_raise_alpha_OLR(G1H32(248),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(248),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(248),ex4(:),G1H16(49),m3h2x16(:,150),heltab2x32(:,:,235))
  call Hloop_QZ_A(ntryL,G1H32(250),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,86),heltab2x32(:,:,236))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(158),n2h8(134))
  call Hloop_QZ_A(ntryL,G1H32(251),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,87),heltab2x32(:,:,237))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(159),n2h8(135))
  call Hloop_QZ_A(ntryL,G1H32(252),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,88),heltab2x32(:,:,238))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(160),n2h8(136))
  call Hloop_QV_A(ntryL,G1H32(253),wf4(:,1),G1H8(1),m3h4x8(:,89),heltab2x32(:,:,239))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(161),n2h8(137))
call HGT_raise_alpha_OLR(G1H32(254),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(254),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(254),-16,ex5(:),16,G2H16(139),m3h2x16(:,151),heltab2x32(:,:,240))
call signflip_OLR(G2H16(139))
  call Hloop_QV_A(ntryL,G1H32(256),wf4(:,1),G1H8(1),m3h4x8(:,90),heltab2x32(:,:,241))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(162),n2h8(138))
  call Hloop_QV_A(ntryL,G1H32(257),wf4(:,1),G1H8(1),m3h4x8(:,91),heltab2x32(:,:,242))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(163),n2h8(139))
  call Hloop_QV_A(ntryL,G1H32(258),wf4(:,1),G1H8(1),m3h4x8(:,92),heltab2x32(:,:,243))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(164),n2h8(140))
  call Hloop_QZ_A(ntryL,G1H32(259),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,93),heltab2x32(:,:,244))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(165),n2h8(141))
call HGT_raise_alpha_OLR(G1H32(260),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(260),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(260),-16,ex5(:),16,G2H16(140),m3h2x16(:,152),heltab2x32(:,:,245))
call signflip_OLR(G2H16(140))
  call Hloop_QZ_A(ntryL,G1H32(262),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,94),heltab2x32(:,:,246))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(166),n2h8(142))
  call Hloop_QZ_A(ntryL,G1H32(263),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,95),heltab2x32(:,:,247))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(167),n2h8(143))
  call Hloop_QZ_A(ntryL,G1H32(264),wf4(:,3),G1H8(1),ngZu,m3h4x8(:,96),heltab2x32(:,:,248))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(168),n2h8(144))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(47),[G2H8(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(49),[G2H8(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(50),[G2H8(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(65),[G2H8(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(67),[G2H8(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(68),[G2H8(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(83),[G2H8(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(85),[G2H8(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(86),[G2H8(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(91),[G2H8(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(93),[G2H8(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(94),[G2H8(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(104),[G2H8(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(106),[G2H8(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(107),[G2H8(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(117),[G2H8(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(119),[G2H8(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(120),[G2H8(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(125),[G2H8(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(127),[G2H8(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(128),[G2H8(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(133),[G2H8(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(135),[G2H8(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(136),[G2H8(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(141),[G2H8(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(143),[G2H8(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(144),[G2H8(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(149),[G2H8(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(151),[G2H8(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(152),[G2H8(148)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(157),[G2H8(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(159),[G2H8(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(160),[G2H8(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(165),[G2H8(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(167),[G2H8(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(168),[G2H8(164)])
  call Hotf_5pt_reduction(G2H16(1),RedSet_5(23),mass5set(:,6),  & 
G1H16(50),G1H16(52),G1H16(53),G1H16(67),G1H16(68),G1H16(70),16)
  call HG1shiftOLR(G1H16(52),32,16)
  call Hotf_5pt_reduction(G2H16(3),RedSet_5(23),mass5set(:,6),  & 
G1H16(71),G1H16(72),G1H16(54),G1H16(56),G1H16(58),G1H16(59),16)
  call HG1shiftOLR(G1H16(72),32,16)
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(24),mass5set(:,7),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),G1H8(6),8)
  call HG1shiftOLR(G1H8(2),32,8)
  call Hotf_5pt_reduction(G2H16(5),RedSet_5(25),mass5set(:,7),  & 
G1H16(60),G1H16(62),G1H16(64),G1H16(65),G1H16(66),G1H16(1),16)
  call HG1shiftOLR(G1H16(62),32,16)
  call Hotf_5pt_reduction(G2H16(7),RedSet_5(25),mass5set(:,7),  & 
G1H16(4),G1H16(5),G1H16(6),G1H16(7),G1H16(10),G1H16(11),16)
  call HG1shiftOLR(G1H16(5),32,16)
  call Hotf_5pt_reduction(G2H16(9),RedSet_5(26),mass5set(:,6),  & 
G1H16(12),G1H16(14),G1H16(16),G1H16(17),G1H16(18),G1H16(20),16)
  call HG1shiftOLR(G1H16(14),16,16)
  call Hotf_5pt_reduction(G2H16(11),RedSet_5(26),mass5set(:,6),  & 
G1H16(22),G1H16(23),G1H16(25),G1H16(26),G1H16(28),G1H16(29),16)
  call HG1shiftOLR(G1H16(23),16,16)
  call Hotf_5pt_reduction(G2H8(2),RedSet_5(24),mass5set(:,7),  & 
G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),G1H8(12),8)
  call HG1shiftOLR(G1H8(8),16,8)
  call Hotf_5pt_reduction(G2H16(13),RedSet_5(27),mass5set(:,6),  & 
G1H16(31),G1H16(32),G1H16(34),G1H16(35),G1H16(36),G1H16(37),16)
  call HG1shiftOLR(G1H16(32),32,16)
  call Hotf_5pt_reduction(G2H16(15),RedSet_5(27),mass5set(:,6),  & 
G1H16(38),G1H16(40),G1H16(41),G1H16(42),G1H16(43),G1H16(44),16)
  call HG1shiftOLR(G1H16(40),32,16)
  call Hotf_5pt_reduction(G2H16(17),RedSet_5(28),mass5set(:,6),  & 
G1H16(73),G1H16(74),G1H16(75),G1H16(76),G1H16(77),G1H16(78),16)
  call HG1shiftOLR(G1H16(74),16,16)
  call Hotf_5pt_reduction(G2H16(19),RedSet_5(28),mass5set(:,6),  & 
G1H16(79),G1H16(80),G1H16(81),G1H16(82),G1H16(83),G1H16(84),16)
  call HG1shiftOLR(G1H16(80),16,16)
  call Hotf_5pt_reduction(G2H16(21),RedSet_5(29),mass5set(:,6),  & 
G1H16(85),G1H16(86),G1H16(87),G1H16(88),G1H16(89),G1H16(90),16)
  call HG1shiftOLR(G1H16(86),16,16)
  call Hotf_5pt_reduction(G2H16(23),RedSet_5(29),mass5set(:,6),  & 
G1H16(91),G1H16(92),G1H16(93),G1H16(94),G1H16(95),G1H16(96),16)
  call HG1shiftOLR(G1H16(92),16,16)
  call Hotf_5pt_reduction(G2H16(25),RedSet_5(29),mass5set(:,6),  & 
G1H16(97),G1H16(98),G1H16(99),G1H16(100),G1H16(101),G1H16(102),16)
  call HG1shiftOLR(G1H16(98),32,16)
  call Hotf_5pt_reduction(G2H16(27),RedSet_5(29),mass5set(:,6),  & 
G1H16(103),G1H16(104),G1H16(105),G1H16(106),G1H16(107),G1H16(108),16)
  call HG1shiftOLR(G1H16(104),32,16)
  call Hotf_5pt_reduction(G2H8(3),RedSet_5(30),mass5set(:,7),  & 
G1H8(13),G1H8(14),G1H8(15),G1H8(16),G1H8(17),G1H8(18),8)
  call HG1shiftOLR(G1H8(14),32,8)
  call Hotf_5pt_reduction(G2H16(29),RedSet_5(31),mass5set(:,7),  & 
G1H16(109),G1H16(110),G1H16(111),G1H16(112),G1H16(113),G1H16(114),16)
  call HG1shiftOLR(G1H16(110),32,16)
  call Hotf_5pt_reduction(G2H16(31),RedSet_5(31),mass5set(:,7),  & 
G1H16(115),G1H16(116),G1H16(117),G1H16(118),G1H16(119),G1H16(120),16)
  call HG1shiftOLR(G1H16(116),32,16)
  call Hotf_5pt_reduction(G2H8(4),RedSet_5(30),mass5set(:,7),  & 
G1H8(19),G1H8(20),G1H8(21),G1H8(22),G1H8(23),G1H8(24),8)
  call HG1shiftOLR(G1H8(20),16,8)
  call Hotf_5pt_reduction(G2H16(33),RedSet_5(32),mass5set(:,6),  & 
G1H16(121),G1H16(122),G1H16(123),G1H16(124),G1H16(125),G1H16(126),16)
  call HG1shiftOLR(G1H16(122),16,16)
  call Hotf_5pt_reduction(G2H16(35),RedSet_5(32),mass5set(:,6),  & 
G1H16(127),G1H16(128),G1H16(129),G1H16(130),G1H16(131),G1H16(132),16)
  call HG1shiftOLR(G1H16(128),16,16)
  call Hotf_5pt_reduction(G2H16(37),RedSet_5(32),mass5set(:,6),  & 
G1H16(133),G1H16(134),G1H16(135),G1H16(136),G1H16(137),G1H16(138),16)
  call HG1shiftOLR(G1H16(134),32,16)
  call Hotf_5pt_reduction(G2H16(39),RedSet_5(32),mass5set(:,6),  & 
G1H16(139),G1H16(140),G1H16(141),G1H16(142),G1H16(143),G1H16(144),16)
  call HG1shiftOLR(G1H16(140),32,16)
  call Hotf_5pt_reduction(G2H8(5),RedSet_5(33),mass5set(:,8),  & 
G1H8(25),G1H8(26),G1H8(27),G1H8(28),G1H8(29),G1H8(30),8)
  call HG1shiftOLR(G1H8(26),32,8)
  call Hotf_5pt_reduction(G2H8(6),RedSet_5(34),mass5set(:,8),  & 
G1H8(31),G1H8(32),G1H8(33),G1H8(34),G1H8(35),G1H8(36),8)
  call HG1shiftOLR(G1H8(32),16,8)
  call Hotf_5pt_reduction(G2H16(41),RedSet_5(35),mass5set(:,9),  & 
G1H16(145),G1H16(146),G1H16(147),G1H16(148),G1H16(149),G1H16(150),16)
  call HG1shiftOLR(G1H16(146),32,16)
  call Hotf_5pt_reduction(G2H16(43),RedSet_5(35),mass5set(:,9),  & 
G1H16(151),G1H16(152),G1H16(153),G1H16(154),G1H16(155),G1H16(156),16)
  call HG1shiftOLR(G1H16(152),32,16)
  call Hotf_5pt_reduction(G2H8(7),RedSet_5(34),mass5set(:,8),  & 
G1H8(37),G1H8(38),G1H8(39),G1H8(40),G1H8(41),G1H8(42),8)
  call HG1shiftOLR(G1H8(38),4,8)
  call Hotf_5pt_reduction(G2H8(8),RedSet_5(36),mass5set(:,8),  & 
G1H8(43),G1H8(44),G1H8(45),G1H8(46),G1H8(47),G1H8(48),8)
  call HG1shiftOLR(G1H8(44),32,8)
  call Hotf_5pt_reduction(G2H16(45),RedSet_5(37),mass5set(:,9),  & 
G1H16(157),G1H16(158),G1H16(159),G1H16(160),G1H16(161),G1H16(162),16)
  call HG1shiftOLR(G1H16(158),32,16)
  call Hotf_5pt_reduction(G2H16(47),RedSet_5(37),mass5set(:,9),  & 
G1H16(163),G1H16(164),G1H16(165),G1H16(166),G1H16(167),G1H16(168),16)
  call HG1shiftOLR(G1H16(164),32,16)
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(36),mass5set(:,8),  & 
G1H8(49),G1H8(50),G1H8(51),G1H8(52),G1H8(53),G1H8(54),8)
  call HG1shiftOLR(G1H8(50),8,8)
  call Hotf_5pt_reduction(G2H8(10),RedSet_5(33),mass5set(:,8),  & 
G1H8(55),G1H8(56),G1H8(57),G1H8(58),G1H8(59),G1H8(60),8)
  call HG1shiftOLR(G1H8(56),4,8)
  call Hotf_5pt_reduction(G2H16(2),RedSet_5(38),mass5set(:,9),  & 
G1H16(169),G1H16(170),G1H16(171),G1H16(172),G1H16(173),G1H16(174),16)
  call HG1shiftOLR(G1H16(170),16,16)
  call Hotf_5pt_reduction(G2H16(4),RedSet_5(38),mass5set(:,9),  & 
G1H16(175),G1H16(176),G1H16(177),G1H16(178),G1H16(179),G1H16(180),16)
  call HG1shiftOLR(G1H16(176),16,16)
  call Hotf_5pt_reduction(G2H8(11),RedSet_5(39),mass5set(:,8),  & 
G1H8(61),G1H8(62),G1H8(63),G1H8(64),G1H8(65),G1H8(66),8)
  call HG1shiftOLR(G1H8(62),16,8)
  call Hotf_5pt_reduction(G2H8(12),RedSet_5(39),mass5set(:,8),  & 
G1H8(67),G1H8(68),G1H8(69),G1H8(70),G1H8(71),G1H8(72),8)
  call HG1shiftOLR(G1H8(68),8,8)
  call Hotf_5pt_reduction(G2H16(6),RedSet_5(40),mass5set(:,9),  & 
G1H16(181),G1H16(182),G1H16(183),G1H16(184),G1H16(185),G1H16(186),16)
  call HG1shiftOLR(G1H16(182),16,16)
  call Hotf_5pt_reduction(G2H16(8),RedSet_5(40),mass5set(:,9),  & 
G1H16(187),G1H16(188),G1H16(189),G1H16(190),G1H16(191),G1H16(192),16)
  call HG1shiftOLR(G1H16(188),16,16)
  call Hloop_QA_V(ntryL,G2H8(13),ex4(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_QA_V(ntryL,G2H8(16),ex4(:),G2H4(2),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_QA_V(ntryL,G2H8(17),ex4(:),G2H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_AQ_V(ntryL,G2H8(18),ex3(:),G2H4(4),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_AQ_V(ntryL,G2H8(21),ex3(:),G2H4(5),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_AQ_V(ntryL,G2H8(22),ex3(:),G2H4(6),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hotf_5pt_reduction(G2H8(23),RedSet_5(3),mass5set(:,2),  & 
G1H8(73),G1H8(74),G1H8(75),G1H8(76),G1H8(77),G1H8(78),8)
  call HG1shiftOLR(G1H8(74),8,8)
  call Hotf_5pt_reduction(G2H8(26),RedSet_5(41),mass5set(:,1),  & 
G1H8(79),G1H8(80),G1H8(81),G1H8(82),G1H8(83),G1H8(84),8)
  call HG1shiftOLR(G1H8(80),8,8)
  call Hotf_5pt_reduction(G2H8(27),RedSet_5(42),mass5set(:,1),  & 
G1H8(85),G1H8(86),G1H8(87),G1H8(88),G1H8(89),G1H8(90),8)
  call HG1shiftOLR(G1H8(86),8,8)
  call Hloop_AQ_V(ntryL,G2H8(28),ex3(:),G2H4(7),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_AQ_V(ntryL,G2H8(31),ex3(:),G2H4(8),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_AQ_V(ntryL,G2H8(32),ex3(:),G2H4(9),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_QA_V(ntryL,G2H8(33),ex4(:),G2H4(10),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_QA_V(ntryL,G2H8(36),ex4(:),G2H4(11),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_QA_V(ntryL,G2H8(37),ex4(:),G2H4(12),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hotf_5pt_reduction(G2H8(38),RedSet_5(6),mass5set(:,2),  & 
G1H8(91),G1H8(92),G1H8(93),G1H8(94),G1H8(95),G1H8(96),8)
  call HG1shiftOLR(G1H8(92),8,8)
  call Hotf_5pt_reduction(G2H8(41),RedSet_5(41),mass5set(:,1),  & 
G1H8(97),G1H8(98),G1H8(99),G1H8(100),G1H8(101),G1H8(102),8)
  call HG1shiftOLR(G1H8(98),8,8)
  call Hotf_5pt_reduction(G2H8(42),RedSet_5(43),mass5set(:,1),  & 
G1H8(103),G1H8(104),G1H8(105),G1H8(106),G1H8(107),G1H8(108),8)
  call HG1shiftOLR(G1H8(104),8,8)
  call Hloop_QA_V(ntryL,G2H8(47),ex4(:),G2H4(13),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_QA_V(ntryL,G2H8(49),ex4(:),G2H4(14),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_QA_V(ntryL,G2H8(50),ex4(:),G2H4(15),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hotf_5pt_reduction(G2H8(51),RedSet_5(3),mass5set(:,2),  & 
G1H8(109),G1H8(110),G1H8(111),G1H8(112),G1H8(113),G1H8(114),8)
  call HG1shiftOLR(G1H8(110),4,8)
  call Hotf_5pt_reduction(G2H8(54),RedSet_5(44),mass5set(:,1),  & 
G1H8(115),G1H8(116),G1H8(117),G1H8(118),G1H8(119),G1H8(120),8)
  call HG1shiftOLR(G1H8(116),4,8)
  call Hotf_5pt_reduction(G2H8(55),RedSet_5(45),mass5set(:,1),  & 
G1H8(121),G1H8(122),G1H8(123),G1H8(124),G1H8(125),G1H8(126),8)
  call HG1shiftOLR(G1H8(122),4,8)
  call Hotf_5pt_reduction(G2H8(56),RedSet_5(6),mass5set(:,2),  & 
G1H8(127),G1H8(128),G1H8(129),G1H8(130),G1H8(131),G1H8(132),8)
  call HG1shiftOLR(G1H8(128),4,8)
  call Hotf_5pt_reduction(G2H8(59),RedSet_5(44),mass5set(:,1),  & 
G1H8(133),G1H8(134),G1H8(135),G1H8(136),G1H8(137),G1H8(138),8)
  call HG1shiftOLR(G1H8(134),4,8)
  call Hotf_5pt_reduction(G2H8(60),RedSet_5(46),mass5set(:,1),  & 
G1H8(139),G1H8(140),G1H8(141),G1H8(142),G1H8(143),G1H8(144),8)
  call HG1shiftOLR(G1H8(140),4,8)
  call Hloop_AQ_V(ntryL,G2H8(65),ex3(:),G2H4(16),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_AQ_V(ntryL,G2H8(67),ex3(:),G2H4(17),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_AQ_V(ntryL,G2H8(68),ex3(:),G2H4(18),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_AQ_V(ntryL,G2H8(69),ex3(:),G2H4(19),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_AQ_V(ntryL,G2H8(72),ex3(:),G2H4(20),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_AQ_V(ntryL,G2H8(73),ex3(:),G2H4(21),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_AQ_V(ntryL,G2H8(74),ex3(:),G2H4(22),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_AQ_V(ntryL,G2H8(77),ex3(:),G2H4(23),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_AQ_V(ntryL,G2H8(78),ex3(:),G2H4(24),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hotf_5pt_reduction(G2H8(83),RedSet_5(9),mass5set(:,3),  & 
G1H8(145),G1H8(146),G1H8(147),G1H8(148),G1H8(149),G1H8(150),8)
  call HG1shiftOLR(G1H8(146),16,8)
  call Hotf_5pt_reduction(G2H8(85),RedSet_5(47),mass5set(:,5),  & 
G1H8(151),G1H8(152),G1H8(153),G1H8(154),G1H8(155),G1H8(156),8)
  call HG1shiftOLR(G1H8(152),16,8)
  call Hotf_5pt_reduction(G2H8(86),RedSet_5(48),mass5set(:,5),  & 
G1H8(157),G1H8(158),G1H8(159),G1H8(160),G1H8(161),G1H8(162),8)
  call HG1shiftOLR(G1H8(158),16,8)
  call Hotf_5pt_reduction(G2H8(91),RedSet_5(10),mass5set(:,3),  & 
G1H8(163),G1H8(164),G1H8(165),G1H8(166),G1H8(167),G1H8(168),8)
  call HG1shiftOLR(G1H8(164),32,8)
  call Hotf_5pt_reduction(G2H8(93),RedSet_5(49),mass5set(:,5),  & 
G1H8(169),G1H8(170),G1H8(171),G1H8(172),G1H8(173),G1H8(174),8)
  call HG1shiftOLR(G1H8(170),32,8)
  call Hotf_5pt_reduction(G2H8(94),RedSet_5(50),mass5set(:,5),  & 
G1H8(175),G1H8(176),G1H8(177),G1H8(178),G1H8(179),G1H8(180),8)
  call HG1shiftOLR(G1H8(176),32,8)
  call Hloop_QA_V(ntryL,G2H8(95),ex4(:),G2H4(25),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_QA_V(ntryL,G2H8(98),ex4(:),G2H4(26),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_QA_V(ntryL,G2H8(99),ex4(:),G2H4(27),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hotf_5pt_reduction(G2H16(48),RedSet_5(11),mass5set(:,3),  & 
G1H16(193),G1H16(194),G1H16(195),G1H16(196),G1H16(197),G1H16(198),16)
  call HG1shiftOLR(G1H16(194),8,16)
  call Hotf_5pt_reduction(G2H16(12),RedSet_5(51),mass5set(:,3),  & 
G1H16(199),G1H16(200),G1H16(201),G1H16(202),G1H16(203),G1H16(204),16)
  call HG1shiftOLR(G1H16(200),8,16)
  call Hotf_5pt_reduction(G2H16(14),RedSet_5(52),mass5set(:,3),  & 
G1H16(205),G1H16(206),G1H16(207),G1H16(208),G1H16(209),G1H16(210),16)
  call HG1shiftOLR(G1H16(206),8,16)
  call Hotf_5pt_reduction(G2H16(16),RedSet_5(11),mass5set(:,3),  & 
G1H16(211),G1H16(212),G1H16(213),G1H16(214),G1H16(215),G1H16(216),16)
  call HG1shiftOLR(G1H16(212),8,16)
  call Hotf_5pt_reduction(G2H16(20),RedSet_5(51),mass5set(:,3),  & 
G1H16(217),G1H16(218),G1H16(219),G1H16(220),G1H16(221),G1H16(222),16)
  call HG1shiftOLR(G1H16(218),8,16)
  call Hotf_5pt_reduction(G2H16(26),RedSet_5(52),mass5set(:,3),  & 
G1H16(223),G1H16(224),G1H16(225),G1H16(226),G1H16(227),G1H16(228),16)
  call HG1shiftOLR(G1H16(224),8,16)
  call Hotf_5pt_reduction(G2H16(28),RedSet_5(11),mass5set(:,3),  & 
G1H16(229),G1H16(230),G1H16(231),G1H16(232),G1H16(233),G1H16(234),16)
  call HG1shiftOLR(G1H16(230),32,16)
  call Hotf_5pt_reduction(G2H16(46),RedSet_5(53),mass5set(:,5),  & 
G1H16(235),G1H16(236),G1H16(237),G1H16(238),G1H16(239),G1H16(240),16)
  call HG1shiftOLR(G1H16(236),32,16)
  call Hotf_5pt_reduction(G2H16(49),RedSet_5(54),mass5set(:,5),  & 
G1H16(241),G1H16(242),G1H16(243),G1H16(244),G1H16(245),G1H16(246),16)
  call HG1shiftOLR(G1H16(242),32,16)
  call Hotf_5pt_reduction(G2H16(50),RedSet_5(11),mass5set(:,3),  & 
G1H16(247),G1H16(248),G1H16(249),G1H16(250),G1H16(251),G1H16(252),16)
  call HG1shiftOLR(G1H16(248),32,16)
  call Hotf_5pt_reduction(G2H16(53),RedSet_5(53),mass5set(:,5),  & 
G1H16(253),G1H16(254),G1H16(255),G1H16(256),G1H16(257),G1H16(258),16)
  call HG1shiftOLR(G1H16(254),32,16)
  call Hotf_5pt_reduction(G2H16(54),RedSet_5(54),mass5set(:,5),  & 
G1H16(259),G1H16(260),G1H16(261),G1H16(262),G1H16(263),G1H16(264),16)
  call HG1shiftOLR(G1H16(260),32,16)
  call Hotf_5pt_reduction(G2H16(55),RedSet_5(12),mass5set(:,3),  & 
G1H16(265),G1H16(266),G1H16(267),G1H16(268),G1H16(269),G1H16(270),16)
  call HG1shiftOLR(G1H16(266),8,16)
  call Hotf_5pt_reduction(G2H16(57),RedSet_5(55),mass5set(:,3),  & 
G1H16(271),G1H16(272),G1H16(273),G1H16(274),G1H16(275),G1H16(276),16)
  call HG1shiftOLR(G1H16(272),8,16)
  call Hotf_5pt_reduction(G2H16(58),RedSet_5(52),mass5set(:,3),  & 
G1H16(277),G1H16(278),G1H16(279),G1H16(280),G1H16(281),G1H16(282),16)
  call HG1shiftOLR(G1H16(278),8,16)
  call Hotf_5pt_reduction(G2H16(59),RedSet_5(12),mass5set(:,3),  & 
G1H16(283),G1H16(284),G1H16(285),G1H16(286),G1H16(287),G1H16(288),16)
  call HG1shiftOLR(G1H16(284),8,16)
  call Hotf_5pt_reduction(G2H16(61),RedSet_5(55),mass5set(:,3),  & 
G1H16(289),G1H16(290),G1H16(291),G1H16(292),G1H16(293),G1H16(294),16)
  call HG1shiftOLR(G1H16(290),8,16)
  call Hotf_5pt_reduction(G2H16(62),RedSet_5(52),mass5set(:,3),  & 
G1H16(295),G1H16(296),G1H16(297),G1H16(298),G1H16(299),G1H16(300),16)
  call HG1shiftOLR(G1H16(296),8,16)
  call Hotf_5pt_reduction(G2H16(63),RedSet_5(13),mass5set(:,3),  & 
G1H16(301),G1H16(302),G1H16(303),G1H16(304),G1H16(305),G1H16(306),16)
  call HG1shiftOLR(G1H16(302),16,16)
  call Hotf_5pt_reduction(G2H16(66),RedSet_5(47),mass5set(:,5),  & 
G1H16(307),G1H16(308),G1H16(309),G1H16(310),G1H16(311),G1H16(312),16)
  call HG1shiftOLR(G1H16(308),16,16)
  call Hotf_5pt_reduction(G2H16(67),RedSet_5(56),mass5set(:,5),  & 
G1H16(313),G1H16(314),G1H16(315),G1H16(316),G1H16(317),G1H16(318),16)
  call HG1shiftOLR(G1H16(314),16,16)
  call Hotf_5pt_reduction(G2H16(68),RedSet_5(13),mass5set(:,3),  & 
G1H16(319),G1H16(320),G1H16(321),G1H16(322),G1H16(323),G1H16(324),16)
  call HG1shiftOLR(G1H16(320),16,16)
  call Hotf_5pt_reduction(G2H16(71),RedSet_5(47),mass5set(:,5),  & 
G1H16(325),G1H16(326),G1H16(327),G1H16(328),G1H16(329),G1H16(330),16)
  call HG1shiftOLR(G1H16(326),16,16)
  call Hotf_5pt_reduction(G2H16(72),RedSet_5(56),mass5set(:,5),  & 
G1H16(331),G1H16(332),G1H16(333),G1H16(334),G1H16(335),G1H16(336),16)
  call HG1shiftOLR(G1H16(332),16,16)
  call Hotf_5pt_reduction(G2H16(73),RedSet_5(14),mass5set(:,4),  & 
G1H16(337),G1H16(338),G1H16(339),G1H16(340),G1H16(341),G1H16(342),16)
  call HG1shiftOLR(G1H16(338),32,16)
  call Hotf_5pt_reduction(G2H16(76),RedSet_5(57),mass5set(:,10),  & 
G1H16(343),G1H16(344),G1H16(345),G1H16(346),G1H16(347),G1H16(348),16)
  call HG1shiftOLR(G1H16(344),32,16)
  call Hotf_5pt_reduction(G2H16(77),RedSet_5(58),mass5set(:,10),  & 
G1H16(349),G1H16(350),G1H16(351),G1H16(352),G1H16(353),G1H16(354),16)
  call HG1shiftOLR(G1H16(350),32,16)
  call Hotf_5pt_reduction(G2H16(78),RedSet_5(14),mass5set(:,4),  & 
G1H16(355),G1H16(356),G1H16(357),G1H16(358),G1H16(359),G1H16(360),16)
  call HG1shiftOLR(G1H16(356),32,16)
  call Hotf_5pt_reduction(G2H16(81),RedSet_5(57),mass5set(:,10),  & 
G1H16(361),G1H16(362),G1H16(363),G1H16(364),G1H16(365),G1H16(366),16)
  call HG1shiftOLR(G1H16(362),32,16)
  call Hotf_5pt_reduction(G2H16(82),RedSet_5(58),mass5set(:,10),  & 
G1H16(367),G1H16(368),G1H16(369),G1H16(370),G1H16(371),G1H16(372),16)
  call HG1shiftOLR(G1H16(368),32,16)
  call Hloop_AQ_V(ntryL,G2H8(104),ex3(:),G2H4(28),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_AQ_V(ntryL,G2H8(106),ex3(:),G2H4(29),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_AQ_V(ntryL,G2H8(107),ex3(:),G2H4(30),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_QA_V(ntryL,G2H8(108),ex4(:),G2H4(31),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_QA_V(ntryL,G2H8(111),ex4(:),G2H4(32),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_QA_V(ntryL,G2H8(112),ex4(:),G2H4(33),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hotf_5pt_reduction(G2H16(85),RedSet_5(16),mass5set(:,3),  & 
G1H16(373),G1H16(374),G1H16(375),G1H16(376),G1H16(377),G1H16(378),16)
  call HG1shiftOLR(G1H16(374),8,16)
  call Hotf_5pt_reduction(G2H16(87),RedSet_5(59),mass5set(:,3),  & 
G1H16(379),G1H16(380),G1H16(381),G1H16(382),G1H16(383),G1H16(384),16)
  call HG1shiftOLR(G1H16(380),8,16)
  call Hotf_5pt_reduction(G2H16(88),RedSet_5(60),mass5set(:,3),  & 
G1H16(385),G1H16(386),G1H16(387),G1H16(388),G1H16(389),G1H16(390),16)
  call HG1shiftOLR(G1H16(386),8,16)
  call Hotf_5pt_reduction(G2H16(89),RedSet_5(16),mass5set(:,3),  & 
G1H16(391),G1H16(392),G1H16(393),G1H16(394),G1H16(395),G1H16(396),16)
  call HG1shiftOLR(G1H16(392),8,16)
  call Hotf_5pt_reduction(G2H16(91),RedSet_5(59),mass5set(:,3),  & 
G1H16(397),G1H16(398),G1H16(399),G1H16(400),G1H16(401),G1H16(402),16)
  call HG1shiftOLR(G1H16(398),8,16)
  call Hotf_5pt_reduction(G2H16(92),RedSet_5(60),mass5set(:,3),  & 
G1H16(403),G1H16(404),G1H16(405),G1H16(406),G1H16(407),G1H16(408),16)
  call HG1shiftOLR(G1H16(404),8,16)
  call Hotf_5pt_reduction(G2H16(93),RedSet_5(16),mass5set(:,3),  & 
G1H16(409),G1H16(410),G1H16(411),G1H16(412),G1H16(413),G1H16(414),16)
  call HG1shiftOLR(G1H16(410),16,16)
  call Hotf_5pt_reduction(G2H16(96),RedSet_5(61),mass5set(:,5),  & 
G1H16(415),G1H16(416),G1H16(417),G1H16(418),G1H16(419),G1H16(420),16)
  call HG1shiftOLR(G1H16(416),16,16)
  call Hotf_5pt_reduction(G2H16(97),RedSet_5(62),mass5set(:,5),  & 
G1H16(421),G1H16(422),G1H16(423),G1H16(424),G1H16(425),G1H16(426),16)
  call HG1shiftOLR(G1H16(422),16,16)
  call Hotf_5pt_reduction(G2H16(98),RedSet_5(16),mass5set(:,3),  & 
G1H16(427),G1H16(428),G1H16(429),G1H16(430),G1H16(431),G1H16(432),16)
  call HG1shiftOLR(G1H16(428),16,16)
  call Hotf_5pt_reduction(G2H16(101),RedSet_5(61),mass5set(:,5),  & 
G1H16(433),G1H16(434),G1H16(435),G1H16(436),G1H16(437),G1H16(438),16)
  call HG1shiftOLR(G1H16(434),16,16)
  call Hotf_5pt_reduction(G2H16(102),RedSet_5(62),mass5set(:,5),  & 
G1H16(439),G1H16(440),G1H16(441),G1H16(442),G1H16(443),G1H16(444),16)
  call HG1shiftOLR(G1H16(440),16,16)
  call Hotf_5pt_reduction(G2H16(103),RedSet_5(17),mass5set(:,3),  & 
G1H16(445),G1H16(446),G1H16(447),G1H16(448),G1H16(449),G1H16(450),16)
  call HG1shiftOLR(G1H16(446),8,16)
  call Hotf_5pt_reduction(G2H16(105),RedSet_5(55),mass5set(:,3),  & 
G1H16(451),G1H16(452),G1H16(453),G1H16(454),G1H16(455),G1H16(456),16)
  call HG1shiftOLR(G1H16(452),8,16)
  call Hotf_5pt_reduction(G2H16(106),RedSet_5(60),mass5set(:,3),  & 
G1H16(457),G1H16(458),G1H16(459),G1H16(460),G1H16(461),G1H16(462),16)
  call HG1shiftOLR(G1H16(458),8,16)
  call Hotf_5pt_reduction(G2H16(107),RedSet_5(17),mass5set(:,3),  & 
G1H16(463),G1H16(464),G1H16(465),G1H16(466),G1H16(467),G1H16(468),16)
  call HG1shiftOLR(G1H16(464),8,16)
  call Hotf_5pt_reduction(G2H16(109),RedSet_5(55),mass5set(:,3),  & 
G1H16(469),G1H16(470),G1H16(471),G1H16(472),G1H16(473),G1H16(474),16)
  call HG1shiftOLR(G1H16(470),8,16)
  call Hotf_5pt_reduction(G2H16(110),RedSet_5(60),mass5set(:,3),  & 
G1H16(475),G1H16(476),G1H16(477),G1H16(478),G1H16(479),G1H16(480),16)
  call HG1shiftOLR(G1H16(476),8,16)
  call Hotf_5pt_reduction(G2H16(111),RedSet_5(18),mass5set(:,3),  & 
G1H16(481),G1H16(482),G1H16(483),G1H16(484),G1H16(485),G1H16(486),16)
  call HG1shiftOLR(G1H16(482),32,16)
  call Hotf_5pt_reduction(G2H16(114),RedSet_5(49),mass5set(:,5),  & 
G1H16(487),G1H16(488),G1H16(489),G1H16(490),G1H16(491),G1H16(492),16)
  call HG1shiftOLR(G1H16(488),32,16)
  call Hotf_5pt_reduction(G2H16(115),RedSet_5(63),mass5set(:,5),  & 
G1H16(493),G1H16(494),G1H16(495),G1H16(496),G1H16(497),G1H16(498),16)
  call HG1shiftOLR(G1H16(494),32,16)
  call Hotf_5pt_reduction(G2H16(116),RedSet_5(18),mass5set(:,3),  & 
G1H16(499),G1H16(500),G1H16(501),G1H16(502),G1H16(503),G1H16(504),16)
  call HG1shiftOLR(G1H16(500),32,16)
  call Hotf_5pt_reduction(G2H16(119),RedSet_5(49),mass5set(:,5),  & 
G1H16(505),G1H16(506),G1H16(507),G1H16(508),G1H16(509),G1H16(510),16)
  call HG1shiftOLR(G1H16(506),32,16)
  call Hotf_5pt_reduction(G2H16(120),RedSet_5(63),mass5set(:,5),  & 
G1H16(511),G1H16(512),G1H16(513),G1H16(514),G1H16(515),G1H16(516),16)
  call HG1shiftOLR(G1H16(512),32,16)
  call Hotf_5pt_reduction(G2H16(121),RedSet_5(19),mass5set(:,4),  & 
G1H16(517),G1H16(518),G1H16(519),G1H16(520),G1H16(521),G1H16(522),16)
  call HG1shiftOLR(G1H16(518),32,16)
  call Hotf_5pt_reduction(G2H16(124),RedSet_5(64),mass5set(:,10),  & 
G1H16(523),G1H16(524),G1H16(525),G1H16(526),G1H16(527),G1H16(528),16)
  call HG1shiftOLR(G1H16(524),32,16)
  call Hotf_5pt_reduction(G2H16(125),RedSet_5(65),mass5set(:,10),  & 
G1H16(529),G1H16(530),G1H16(531),G1H16(532),G1H16(533),G1H16(534),16)
  call HG1shiftOLR(G1H16(530),32,16)
  call Hotf_5pt_reduction(G2H16(126),RedSet_5(19),mass5set(:,4),  & 
G1H16(535),G1H16(536),G1H16(537),G1H16(538),G1H16(539),G1H16(540),16)
  call HG1shiftOLR(G1H16(536),32,16)
  call Hotf_5pt_reduction(G2H16(129),RedSet_5(64),mass5set(:,10),  & 
G1H16(541),G1H16(542),G1H16(543),G1H16(544),G1H16(545),G1H16(546),16)
  call HG1shiftOLR(G1H16(542),32,16)
  call Hotf_5pt_reduction(G2H16(130),RedSet_5(65),mass5set(:,10),  & 
G1H16(547),G1H16(548),G1H16(549),G1H16(550),G1H16(551),G1H16(552),16)
  call HG1shiftOLR(G1H16(548),32,16)
  call Hloop_AQ_V(ntryL,G2H8(117),ex3(:),G2H4(34),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_AQ_V(ntryL,G2H8(119),ex3(:),G2H4(35),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_AQ_V(ntryL,G2H8(120),ex3(:),G2H4(36),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hotf_5pt_reduction(G2H8(125),RedSet_5(20),mass5set(:,3),  & 
G1H8(181),G1H8(182),G1H8(183),G1H8(184),G1H8(185),G1H8(186),8)
  call HG1shiftOLR(G1H8(182),16,8)
  call Hotf_5pt_reduction(G2H8(127),RedSet_5(61),mass5set(:,5),  & 
G1H8(187),G1H8(188),G1H8(189),G1H8(190),G1H8(191),G1H8(192),8)
  call HG1shiftOLR(G1H8(188),16,8)
  call Hotf_5pt_reduction(G2H8(128),RedSet_5(66),mass5set(:,5),  & 
G1H8(193),G1H8(194),G1H8(195),G1H8(196),G1H8(197),G1H8(198),8)
  call HG1shiftOLR(G1H8(194),16,8)
  call Hotf_5pt_reduction(G2H8(133),RedSet_5(21),mass5set(:,3),  & 
G1H8(199),G1H8(200),G1H8(201),G1H8(202),G1H8(203),G1H8(204),8)
  call HG1shiftOLR(G1H8(200),32,8)
  call Hotf_5pt_reduction(G2H8(135),RedSet_5(53),mass5set(:,5),  & 
G1H8(205),G1H8(206),G1H8(207),G1H8(208),G1H8(209),G1H8(210),8)
  call HG1shiftOLR(G1H8(206),32,8)
  call Hotf_5pt_reduction(G2H8(136),RedSet_5(67),mass5set(:,5),  & 
G1H8(211),G1H8(212),G1H8(213),G1H8(214),G1H8(215),G1H8(216),8)
  call HG1shiftOLR(G1H8(212),32,8)
  call Hotf_5pt_reduction(G2H8(141),RedSet_5(20),mass5set(:,3),  & 
G1H8(217),G1H8(218),G1H8(219),G1H8(220),G1H8(221),G1H8(222),8)
  call HG1shiftOLR(G1H8(218),8,8)
  call Hotf_5pt_reduction(G2H8(143),RedSet_5(59),mass5set(:,3),  & 
G1H8(223),G1H8(224),G1H8(225),G1H8(226),G1H8(227),G1H8(228),8)
  call HG1shiftOLR(G1H8(224),8,8)
  call Hotf_5pt_reduction(G2H8(144),RedSet_5(68),mass5set(:,3),  & 
G1H8(229),G1H8(230),G1H8(231),G1H8(232),G1H8(233),G1H8(234),8)
  call HG1shiftOLR(G1H8(230),8,8)
  call Hloop_QA_V(ntryL,G2H8(149),ex4(:),G2H4(37),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_QA_V(ntryL,G2H8(151),ex4(:),G2H4(38),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_QA_V(ntryL,G2H8(152),ex4(:),G2H4(39),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hotf_5pt_reduction(G2H8(157),RedSet_5(21),mass5set(:,3),  & 
G1H8(235),G1H8(236),G1H8(237),G1H8(238),G1H8(239),G1H8(240),8)
  call HG1shiftOLR(G1H8(236),8,8)
  call Hotf_5pt_reduction(G2H8(159),RedSet_5(51),mass5set(:,3),  & 
G1H8(241),G1H8(242),G1H8(243),G1H8(244),G1H8(245),G1H8(246),8)
  call HG1shiftOLR(G1H8(242),8,8)
  call Hotf_5pt_reduction(G2H8(160),RedSet_5(68),mass5set(:,3),  & 
G1H8(247),G1H8(248),G1H8(249),G1H8(250),G1H8(251),G1H8(252),8)
  call HG1shiftOLR(G1H8(248),8,8)
  call Hloop_QA_V(ntryL,G2H8(165),ex4(:),G2H4(40),m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_QA_V(ntryL,G2H8(167),ex4(:),G2H4(41),m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_QA_V(ntryL,G2H8(168),ex4(:),G2H4(42),m3h2x4(:,42),heltab2x8(:,:,42))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(79),[G1H8(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(85),[G1H8(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(97),[G1H8(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(103),[G1H8(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(115),[G1H8(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(121),[G1H8(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(133),[G1H8(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(139),[G1H8(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(151),[G1H8(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(157),[G1H8(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(169),[G1H8(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(175),[G1H8(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(199),[G1H16(197)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(205),[G1H16(198)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(217),[G1H16(215)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(223),[G1H16(216)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(235),[G1H16(233)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(241),[G1H16(234)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(253),[G1H16(251)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(259),[G1H16(252)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(271),[G1H16(269)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(277),[G1H16(270)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(289),[G1H16(287)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(295),[G1H16(288)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(307),[G1H16(305)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(313),[G1H16(306)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(325),[G1H16(323)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(331),[G1H16(324)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(343),[G1H16(341)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(349),[G1H16(342)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(361),[G1H16(359)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(367),[G1H16(360)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(379),[G1H16(377)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(385),[G1H16(378)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(397),[G1H16(395)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(403),[G1H16(396)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(415),[G1H16(413)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(421),[G1H16(414)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(433),[G1H16(431)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(439),[G1H16(432)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(451),[G1H16(449)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(457),[G1H16(450)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(469),[G1H16(467)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(475),[G1H16(468)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(487),[G1H16(485)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(493),[G1H16(486)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(505),[G1H16(503)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(511),[G1H16(504)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(523),[G1H16(521)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(529),[G1H16(522)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(541),[G1H16(539)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(547),[G1H16(540)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(187),[G1H8(185)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(193),[G1H8(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(205),[G1H8(203)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(211),[G1H8(204)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(223),[G1H8(221)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(229),[G1H8(222)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(241),[G1H8(239)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(247),[G1H8(240)])
  call Hloop_QV_A(ntryL,G1H16(50),ex5(:),G1H8(77),m3h2x8(:,73),heltab2x16(:,:,73))
  call Hloop_Q_A(ntryL,G1H8(77),92,nMT,G2H8(43),n2h8(145))
call HGT_OLR(G1H16(52),1,1,16)
call HGT_invQ_OLR(G1H16(52),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(52),-32,nMT,G2H16(1),n2h16(157))
  call Hloop_AV_Q(ntryL,G2H16(1),ex6(:),G2H8(45),m3h2x8(:,74),heltab2x16(:,:,74))
  call Hloop_QV_A(ntryL,G1H16(68),ex5(:),G1H8(78),m3h2x8(:,75),heltab2x16(:,:,75))
  call Hloop_Q_A(ntryL,G1H8(78),92,nMT,G2H8(46),n2h8(146))
  call Hloop_QV_A(ntryL,G1H16(70),ex5(:),G1H8(95),m3h2x8(:,76),heltab2x16(:,:,76))
  call Hloop_Q_A(ntryL,G1H8(95),92,nMT,G2H8(61),n2h8(147))
  call Hloop_QV_A(ntryL,G1H16(71),ex5(:),G1H8(96),m3h2x8(:,77),heltab2x16(:,:,77))
  call Hloop_Q_A(ntryL,G1H8(96),92,nMT,G2H8(63),n2h8(148))
call HGT_OLR(G1H16(72),1,1,16)
call HGT_invQ_OLR(G1H16(72),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(72),-32,nMT,G2H16(3),n2h16(158))
  call Hloop_AV_Q(ntryL,G2H16(3),ex6(:),G2H8(64),m3h2x8(:,78),heltab2x16(:,:,78))
  call Hloop_QV_A(ntryL,G1H16(58),ex5(:),G1H8(113),m3h2x8(:,79),heltab2x16(:,:,79))
  call Hloop_Q_A(ntryL,G1H8(113),92,nMT,G2H8(79),n2h8(149))
  call Hloop_QV_A(ntryL,G1H16(59),ex5(:),G1H8(114),m3h2x8(:,80),heltab2x16(:,:,80))
  call Hloop_Q_A(ntryL,G1H8(114),92,nMT,G2H8(81),n2h8(150))
  call Hloop_VQ_A(ntryL,G1H8(1),ex3(:),G1H4(1),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMT,G2H4(43),n2h4(1))
call HGT_OLR(G1H8(2),1,1,8)
call HGT_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(2),-32,nMT,G2H8(82),n2h8(151))
  call Hloop_AV_Q(ntryL,G2H8(82),ex6(:),G2H4(44),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_VQ_A(ntryL,G1H8(5),ex3(:),G1H4(1),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMT,G2H4(45),n2h4(2))
  call Hloop_VQ_A(ntryL,G1H8(6),ex3(:),G1H4(1),m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMT,G2H4(46),n2h4(3))
  call Hloop_VA_Q(ntryL,G1H16(60),ex4(:),G1H8(131),m3h2x8(:,81),heltab2x16(:,:,81))
  call Hloop_A_Q(ntryL,G1H8(131),92,nMT,G2H8(87),n2h8(152))
call HGT_OLR(G1H16(62),1,1,16)
call HGT_invQ_OLR(G1H16(62),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(62),-32,nMT,G2H16(5),n2h16(159))
  call Hloop_QV_A(ntryL,G2H16(5),ex6(:),G2H8(89),m3h2x8(:,82),heltab2x16(:,:,82))
  call Hloop_VA_Q(ntryL,G1H16(66),ex4(:),G1H8(132),m3h2x8(:,83),heltab2x16(:,:,83))
  call Hloop_A_Q(ntryL,G1H8(132),92,nMT,G2H8(90),n2h8(153))
  call Hloop_VA_Q(ntryL,G1H16(1),ex4(:),G1H8(149),m3h2x8(:,84),heltab2x16(:,:,84))
  call Hloop_A_Q(ntryL,G1H8(149),92,nMT,G2H8(100),n2h8(154))
  call Hloop_VA_Q(ntryL,G1H16(4),ex4(:),G1H8(150),m3h2x8(:,85),heltab2x16(:,:,85))
  call Hloop_A_Q(ntryL,G1H8(150),92,nMT,G2H8(102),n2h8(155))
call HGT_OLR(G1H16(5),1,1,16)
call HGT_invQ_OLR(G1H16(5),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(5),-32,nMT,G2H16(7),n2h16(160))
  call Hloop_QV_A(ntryL,G2H16(7),ex6(:),G2H8(103),m3h2x8(:,86),heltab2x16(:,:,86))
  call Hloop_VA_Q(ntryL,G1H16(10),ex4(:),G1H8(167),m3h2x8(:,87),heltab2x16(:,:,87))
  call Hloop_A_Q(ntryL,G1H8(167),92,nMT,G2H8(113),n2h8(156))
  call Hloop_VA_Q(ntryL,G1H16(11),ex4(:),G1H8(168),m3h2x8(:,88),heltab2x16(:,:,88))
  call Hloop_A_Q(ntryL,G1H8(168),92,nMT,G2H8(115),n2h8(157))
  call Hloop_QV_A(ntryL,G1H16(12),ex6(:),G1H8(185),m3h2x8(:,89),heltab2x16(:,:,89))
  call Hloop_Q_A(ntryL,G1H8(185),108,nMT,G2H8(116),n2h8(158))
call HGT_OLR(G1H16(14),1,1,16)
call HGT_invQ_OLR(G1H16(14),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(14),-16,nMT,G2H16(9),n2h16(161))
  call Hloop_AV_Q(ntryL,G2H16(9),ex5(:),G2H8(121),m3h2x8(:,90),heltab2x16(:,:,90))
  call Hloop_QV_A(ntryL,G1H16(18),ex6(:),G1H8(186),m3h2x8(:,91),heltab2x16(:,:,91))
  call Hloop_Q_A(ntryL,G1H8(186),108,nMT,G2H8(123),n2h8(159))
  call Hloop_QV_A(ntryL,G1H16(20),ex6(:),G1H8(203),m3h2x8(:,92),heltab2x16(:,:,92))
  call Hloop_Q_A(ntryL,G1H8(203),108,nMT,G2H8(124),n2h8(160))
  call Hloop_QV_A(ntryL,G1H16(22),ex6(:),G1H8(204),m3h2x8(:,93),heltab2x16(:,:,93))
  call Hloop_Q_A(ntryL,G1H8(204),108,nMT,G2H8(129),n2h8(161))
call HGT_OLR(G1H16(23),1,1,16)
call HGT_invQ_OLR(G1H16(23),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(23),-16,nMT,G2H16(11),n2h16(162))
  call Hloop_AV_Q(ntryL,G2H16(11),ex5(:),G2H8(131),m3h2x8(:,94),heltab2x16(:,:,94))
  call Hloop_QV_A(ntryL,G1H16(28),ex6(:),G1H8(221),m3h2x8(:,95),heltab2x16(:,:,95))
  call Hloop_Q_A(ntryL,G1H8(221),108,nMT,G2H8(132),n2h8(162))
  call Hloop_QV_A(ntryL,G1H16(29),ex6(:),G1H8(222),m3h2x8(:,96),heltab2x16(:,:,96))
  call Hloop_Q_A(ntryL,G1H8(222),108,nMT,G2H8(137),n2h8(163))
  call Hloop_VQ_A(ntryL,G1H8(7),ex3(:),G1H4(1),m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMT,G2H4(47),n2h4(4))
call HGT_OLR(G1H8(8),1,1,8)
call HGT_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(8),-16,nMT,G2H8(139),n2h8(164))
  call Hloop_AV_Q(ntryL,G2H8(139),ex5(:),G2H4(48),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_VQ_A(ntryL,G1H8(11),ex3(:),G1H4(1),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMT,G2H4(49),n2h4(5))
  call Hloop_VQ_A(ntryL,G1H8(12),ex3(:),G1H4(1),m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMT,G2H4(50),n2h4(6))
  call Hloop_AV_Q(ntryL,G1H16(31),ex5(:),G1H8(239),m3h2x8(:,97),heltab2x16(:,:,97))
  call Hloop_A_Q(ntryL,G1H8(239),92,nMT,G2H8(140),n2h8(165))
call HGT_OLR(G1H16(32),1,1,16)
call HGT_invQ_OLR(G1H16(32),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(32),-32,nMT,G2H16(13),n2h16(163))
  call Hloop_QV_A(ntryL,G2H16(13),ex6(:),G2H8(145),m3h2x8(:,98),heltab2x16(:,:,98))
  call Hloop_AV_Q(ntryL,G1H16(36),ex5(:),G1H8(240),m3h2x8(:,99),heltab2x16(:,:,99))
  call Hloop_A_Q(ntryL,G1H8(240),92,nMT,G2H8(147),n2h8(166))
  call Hloop_AV_Q(ntryL,G1H16(37),ex5(:),G1H8(77),m3h2x8(:,100),heltab2x16(:,:,100))
  call Hloop_A_Q(ntryL,G1H8(77),92,nMT,G2H8(148),n2h8(167))
  call Hloop_AV_Q(ntryL,G1H16(38),ex5(:),G1H8(78),m3h2x8(:,101),heltab2x16(:,:,101))
  call Hloop_A_Q(ntryL,G1H8(78),92,nMT,G2H8(153),n2h8(168))
call HGT_OLR(G1H16(40),1,1,16)
call HGT_invQ_OLR(G1H16(40),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(40),-32,nMT,G2H16(15),n2h16(164))
  call Hloop_QV_A(ntryL,G2H16(15),ex6(:),G2H8(155),m3h2x8(:,102),heltab2x16(:,:,102))
  call Hloop_AV_Q(ntryL,G1H16(43),ex5(:),G1H8(95),m3h2x8(:,103),heltab2x16(:,:,103))
  call Hloop_A_Q(ntryL,G1H8(95),92,nMT,G2H8(156),n2h8(169))
  call Hloop_AV_Q(ntryL,G1H16(44),ex5(:),G1H8(96),m3h2x8(:,104),heltab2x16(:,:,104))
  call Hloop_A_Q(ntryL,G1H8(96),92,nMT,G2H8(161),n2h8(170))
  call Hloop_AV_Q(ntryL,G1H16(73),ex6(:),G1H8(113),m3h2x8(:,105),heltab2x16(:,:,105))
  call Hloop_A_Q(ntryL,G1H8(113),108,nMT,G2H8(163),n2h8(171))
call HGT_OLR(G1H16(74),1,1,16)
call HGT_invQ_OLR(G1H16(74),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(74),-16,nMT,G2H16(17),n2h16(165))
  call Hloop_QV_A(ntryL,G2H16(17),ex5(:),G2H8(164),m3h2x8(:,106),heltab2x16(:,:,106))
  call Hloop_AV_Q(ntryL,G1H16(77),ex6(:),G1H8(114),m3h2x8(:,107),heltab2x16(:,:,107))
  call Hloop_A_Q(ntryL,G1H8(114),108,nMT,G2H8(1),n2h8(172))
  call Hloop_AV_Q(ntryL,G1H16(78),ex6(:),G1H8(1),m3h2x8(:,108),heltab2x16(:,:,108))
  call Hloop_A_Q(ntryL,G1H8(1),108,nMT,G2H8(2),n2h8(173))
  call Hloop_AV_Q(ntryL,G1H16(79),ex6(:),G1H8(2),m3h2x8(:,109),heltab2x16(:,:,109))
  call Hloop_A_Q(ntryL,G1H8(2),108,nMT,G2H8(3),n2h8(174))
call HGT_OLR(G1H16(80),1,1,16)
call HGT_invQ_OLR(G1H16(80),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(80),-16,nMT,G2H16(19),n2h16(166))
  call Hloop_QV_A(ntryL,G2H16(19),ex5(:),G2H8(4),m3h2x8(:,110),heltab2x16(:,:,110))
  call Hloop_AV_Q(ntryL,G1H16(83),ex6(:),G1H8(5),m3h2x8(:,111),heltab2x16(:,:,111))
  call Hloop_A_Q(ntryL,G1H8(5),108,nMT,G2H8(5),n2h8(175))
  call Hloop_AV_Q(ntryL,G1H16(84),ex6(:),G1H8(6),m3h2x8(:,112),heltab2x16(:,:,112))
  call Hloop_A_Q(ntryL,G1H8(6),108,nMT,G2H8(6),n2h8(176))
  call Hloop_AV_Q(ntryL,G1H16(85),wf4(:,1),G1H4(1),m3h4x4(:,1),heltab2x16(:,:,113))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMT,G2H4(51),n2h4(7))
call HGT_OLR(G1H16(86),1,1,16)
call HGT_invQ_OLR(G1H16(86),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(86),-16,nMT,G2H16(21),n2h16(167))
  call Hloop_QV_A(ntryL,G2H16(21),ex5(:),G2H8(7),m3h2x8(:,113),heltab2x16(:,:,114))
  call Hloop_AV_Q(ntryL,G1H16(89),wf4(:,1),G1H4(1),m3h4x4(:,2),heltab2x16(:,:,115))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMT,G2H4(52),n2h4(8))
  call Hloop_AV_Q(ntryL,G1H16(90),wf4(:,1),G1H4(1),m3h4x4(:,3),heltab2x16(:,:,116))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMT,G2H4(53),n2h4(9))
  call Hloop_AZ_Q(ntryL,G1H16(91),wf4(:,3),G1H4(1),ngZu,m3h4x4(:,4),heltab2x16(:,:,117))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMT,G2H4(54),n2h4(10))
call HGT_OLR(G1H16(92),1,1,16)
call HGT_invQ_OLR(G1H16(92),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(92),-16,nMT,G2H16(23),n2h16(168))
  call Hloop_QV_A(ntryL,G2H16(23),ex5(:),G2H8(8),m3h2x8(:,114),heltab2x16(:,:,118))
  call Hloop_AZ_Q(ntryL,G1H16(95),wf4(:,3),G1H4(1),ngZu,m3h4x4(:,5),heltab2x16(:,:,119))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMT,G2H4(55),n2h4(11))
  call Hloop_AZ_Q(ntryL,G1H16(96),wf4(:,3),G1H4(1),ngZu,m3h4x4(:,6),heltab2x16(:,:,120))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMT,G2H4(56),n2h4(12))
  call Hloop_AV_Q(ntryL,G1H16(97),wf4(:,1),G1H4(1),m3h4x4(:,7),heltab2x16(:,:,121))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMT,G2H4(57),n2h4(13))
call HGT_OLR(G1H16(98),1,1,16)
call HGT_invQ_OLR(G1H16(98),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(98),-32,nMT,G2H16(25),n2h16(169))
  call Hloop_QV_A(ntryL,G2H16(25),ex6(:),G2H8(9),m3h2x8(:,115),heltab2x16(:,:,122))
  call Hloop_AV_Q(ntryL,G1H16(101),wf4(:,1),G1H4(1),m3h4x4(:,8),heltab2x16(:,:,123))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMT,G2H4(58),n2h4(14))
  call Hloop_AV_Q(ntryL,G1H16(102),wf4(:,1),G1H4(1),m3h4x4(:,9),heltab2x16(:,:,124))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMT,G2H4(59),n2h4(15))
  call Hloop_AZ_Q(ntryL,G1H16(103),wf4(:,3),G1H4(1),ngZu,m3h4x4(:,10),heltab2x16(:,:,125))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMT,G2H4(60),n2h4(16))
call HGT_OLR(G1H16(104),1,1,16)
call HGT_invQ_OLR(G1H16(104),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(104),-32,nMT,G2H16(27),n2h16(170))
  call Hloop_QV_A(ntryL,G2H16(27),ex6(:),G2H8(10),m3h2x8(:,116),heltab2x16(:,:,126))
  call Hloop_AZ_Q(ntryL,G1H16(107),wf4(:,3),G1H4(1),ngZu,m3h4x4(:,11),heltab2x16(:,:,127))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMT,G2H4(61),n2h4(17))
  call Hloop_AZ_Q(ntryL,G1H16(108),wf4(:,3),G1H4(1),ngZu,m3h4x4(:,12),heltab2x16(:,:,128))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMT,G2H4(62),n2h4(18))
  call Hloop_VA_Q(ntryL,G1H8(13),ex4(:),G1H4(1),m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMT,G2H4(63),n2h4(19))
call HGT_OLR(G1H8(14),1,1,8)
call HGT_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(14),-32,nMT,G2H8(11),n2h8(177))
  call Hloop_QV_A(ntryL,G2H8(11),ex6(:),G2H4(64),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_VA_Q(ntryL,G1H8(17),ex4(:),G1H4(1),m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMT,G2H4(65),n2h4(20))
  call Hloop_VA_Q(ntryL,G1H8(18),ex4(:),G1H4(1),m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMT,G2H4(66),n2h4(21))
  call Hloop_VQ_A(ntryL,G1H16(109),ex3(:),G1H8(131),m3h2x8(:,117),heltab2x16(:,:,129))
  call Hloop_Q_A(ntryL,G1H8(131),92,nMT,G2H8(12),n2h8(178))
call HGT_OLR(G1H16(110),1,1,16)
call HGT_invQ_OLR(G1H16(110),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(110),-32,nMT,G2H16(29),n2h16(171))
  call Hloop_AV_Q(ntryL,G2H16(29),ex6(:),G2H8(13),m3h2x8(:,118),heltab2x16(:,:,130))
  call Hloop_VQ_A(ntryL,G1H16(113),ex3(:),G1H8(132),m3h2x8(:,119),heltab2x16(:,:,131))
  call Hloop_Q_A(ntryL,G1H8(132),92,nMT,G2H8(16),n2h8(179))
  call Hloop_VQ_A(ntryL,G1H16(114),ex3(:),G1H8(149),m3h2x8(:,120),heltab2x16(:,:,132))
  call Hloop_Q_A(ntryL,G1H8(149),92,nMT,G2H8(17),n2h8(180))
  call Hloop_VQ_A(ntryL,G1H16(115),ex3(:),G1H8(150),m3h2x8(:,121),heltab2x16(:,:,133))
  call Hloop_Q_A(ntryL,G1H8(150),92,nMT,G2H8(18),n2h8(181))
call HGT_OLR(G1H16(116),1,1,16)
call HGT_invQ_OLR(G1H16(116),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(116),-32,nMT,G2H16(31),n2h16(172))
  call Hloop_AV_Q(ntryL,G2H16(31),ex6(:),G2H8(21),m3h2x8(:,122),heltab2x16(:,:,134))
  call Hloop_VQ_A(ntryL,G1H16(119),ex3(:),G1H8(167),m3h2x8(:,123),heltab2x16(:,:,135))
  call Hloop_Q_A(ntryL,G1H8(167),92,nMT,G2H8(22),n2h8(182))
  call Hloop_VQ_A(ntryL,G1H16(120),ex3(:),G1H8(168),m3h2x8(:,124),heltab2x16(:,:,136))
  call Hloop_Q_A(ntryL,G1H8(168),92,nMT,G2H8(23),n2h8(183))
  call Hloop_VA_Q(ntryL,G1H8(19),ex4(:),G1H4(1),m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMT,G2H4(67),n2h4(22))
call HGT_OLR(G1H8(20),1,1,8)
call HGT_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(20),-16,nMT,G2H8(26),n2h8(184))
  call Hloop_QV_A(ntryL,G2H8(26),ex5(:),G2H4(68),m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_VA_Q(ntryL,G1H8(23),ex4(:),G1H4(1),m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMT,G2H4(69),n2h4(23))
  call Hloop_VA_Q(ntryL,G1H8(24),ex4(:),G1H4(1),m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMT,G2H4(70),n2h4(24))
  call Hloop_QV_A(ntryL,G1H16(121),wf4(:,1),G1H4(1),m3h4x4(:,13),heltab2x16(:,:,137))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMT,G2H4(71),n2h4(25))
call HGT_OLR(G1H16(122),1,1,16)
call HGT_invQ_OLR(G1H16(122),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(122),-16,nMT,G2H16(33),n2h16(173))
  call Hloop_AV_Q(ntryL,G2H16(33),ex5(:),G2H8(27),m3h2x8(:,125),heltab2x16(:,:,138))
  call Hloop_QV_A(ntryL,G1H16(125),wf4(:,1),G1H4(1),m3h4x4(:,14),heltab2x16(:,:,139))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMT,G2H4(72),n2h4(26))
  call Hloop_QV_A(ntryL,G1H16(126),wf4(:,1),G1H4(1),m3h4x4(:,15),heltab2x16(:,:,140))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMT,G2H4(73),n2h4(27))
  call Hloop_QZ_A(ntryL,G1H16(127),wf4(:,3),G1H4(1),ngZu,m3h4x4(:,16),heltab2x16(:,:,141))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMT,G2H4(74),n2h4(28))
call HGT_OLR(G1H16(128),1,1,16)
call HGT_invQ_OLR(G1H16(128),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(128),-16,nMT,G2H16(35),n2h16(174))
  call Hloop_AV_Q(ntryL,G2H16(35),ex5(:),G2H8(28),m3h2x8(:,126),heltab2x16(:,:,142))
  call Hloop_QZ_A(ntryL,G1H16(131),wf4(:,3),G1H4(1),ngZu,m3h4x4(:,17),heltab2x16(:,:,143))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMT,G2H4(75),n2h4(29))
  call Hloop_QZ_A(ntryL,G1H16(132),wf4(:,3),G1H4(1),ngZu,m3h4x4(:,18),heltab2x16(:,:,144))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMT,G2H4(76),n2h4(30))
  call Hloop_QV_A(ntryL,G1H16(133),wf4(:,1),G1H4(1),m3h4x4(:,19),heltab2x16(:,:,145))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMT,G2H4(77),n2h4(31))
call HGT_OLR(G1H16(134),1,1,16)
call HGT_invQ_OLR(G1H16(134),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(134),-32,nMT,G2H16(37),n2h16(175))
  call Hloop_AV_Q(ntryL,G2H16(37),ex6(:),G2H8(31),m3h2x8(:,127),heltab2x16(:,:,146))
  call Hloop_QV_A(ntryL,G1H16(137),wf4(:,1),G1H4(1),m3h4x4(:,20),heltab2x16(:,:,147))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMT,G2H4(78),n2h4(32))
  call Hloop_QV_A(ntryL,G1H16(138),wf4(:,1),G1H4(1),m3h4x4(:,21),heltab2x16(:,:,148))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMT,G2H4(79),n2h4(33))
  call Hloop_QZ_A(ntryL,G1H16(139),wf4(:,3),G1H4(1),ngZu,m3h4x4(:,22),heltab2x16(:,:,149))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMT,G2H4(80),n2h4(34))
call HGT_OLR(G1H16(140),1,1,16)
call HGT_invQ_OLR(G1H16(140),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(140),-32,nMT,G2H16(39),n2h16(176))
  call Hloop_AV_Q(ntryL,G2H16(39),ex6(:),G2H8(32),m3h2x8(:,128),heltab2x16(:,:,150))
  call Hloop_QZ_A(ntryL,G1H16(143),wf4(:,3),G1H4(1),ngZu,m3h4x4(:,23),heltab2x16(:,:,151))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMT,G2H4(81),n2h4(35))
  call Hloop_QZ_A(ntryL,G1H16(144),wf4(:,3),G1H4(1),ngZu,m3h4x4(:,24),heltab2x16(:,:,152))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMT,G2H4(82),n2h4(36))
  call Hloop_UV_W(ntryL,G1H8(25),75,ex5(:),16,G2H4(83),m3h2x4(:,59),heltab2x8(:,:,59))
call HGT_OLR(G1H8(26),1,1,8)
call HGT_invQ_OLR(G1H8(26),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(26),-32,nMT,G2H8(33),n2h8(185))
  call Hloop_AV_Q(ntryL,G2H8(33),ex6(:),G2H4(84),m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_UV_W(ntryL,G1H8(29),75,ex5(:),16,G2H4(85),m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_UV_W(ntryL,G1H8(30),75,ex5(:),16,G2H4(86),m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_UV_W(ntryL,G1H8(31),75,ex6(:),32,G2H4(87),m3h2x4(:,63),heltab2x8(:,:,63))
call HGT_OLR(G1H8(32),1,1,8)
call HGT_invQ_OLR(G1H8(32),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(32),-16,nMT,G2H8(36),n2h8(186))
  call Hloop_AV_Q(ntryL,G2H8(36),ex5(:),G2H4(88),m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_UV_W(ntryL,G1H8(35),75,ex6(:),32,G2H4(89),m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_UV_W(ntryL,G1H8(36),75,ex6(:),32,G2H4(90),m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_VA_Q(ntryL,G1H16(145),ex4(:),G1H8(185),m3h2x8(:,129),heltab2x16(:,:,153))
  call Hloop_A_Q(ntryL,G1H8(185),92,nMT,G2H8(37),n2h8(187))
call HGT_OLR(G1H16(146),1,1,16)
call HGT_invQ_OLR(G1H16(146),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(146),-32,nMT,G2H16(41),n2h16(177))
  call Hloop_QV_A(ntryL,G2H16(41),ex6(:),G2H8(38),m3h2x8(:,130),heltab2x16(:,:,154))
  call Hloop_VA_Q(ntryL,G1H16(149),ex4(:),G1H8(186),m3h2x8(:,131),heltab2x16(:,:,155))
  call Hloop_A_Q(ntryL,G1H8(186),92,nMT,G2H8(41),n2h8(188))
  call Hloop_VA_Q(ntryL,G1H16(150),ex4(:),G1H8(203),m3h2x8(:,132),heltab2x16(:,:,156))
  call Hloop_A_Q(ntryL,G1H8(203),92,nMT,G2H8(42),n2h8(189))
  call Hloop_VA_Q(ntryL,G1H16(151),ex4(:),G1H8(204),m3h2x8(:,133),heltab2x16(:,:,157))
  call Hloop_A_Q(ntryL,G1H8(204),92,nMT,G2H8(47),n2h8(190))
call HGT_OLR(G1H16(152),1,1,16)
call HGT_invQ_OLR(G1H16(152),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(152),-32,nMT,G2H16(43),n2h16(178))
  call Hloop_QV_A(ntryL,G2H16(43),ex6(:),G2H8(49),m3h2x8(:,134),heltab2x16(:,:,158))
  call Hloop_VA_Q(ntryL,G1H16(155),ex4(:),G1H8(221),m3h2x8(:,135),heltab2x16(:,:,159))
  call Hloop_A_Q(ntryL,G1H8(221),92,nMT,G2H8(50),n2h8(191))
  call Hloop_VA_Q(ntryL,G1H16(156),ex4(:),G1H8(222),m3h2x8(:,136),heltab2x16(:,:,160))
  call Hloop_A_Q(ntryL,G1H8(222),92,nMT,G2H8(51),n2h8(192))
  call Hloop_UV_W(ntryL,G1H8(37),75,ex6(:),32,G2H4(91),m3h2x4(:,67),heltab2x8(:,:,67))
call HGT_OLR(G1H8(38),1,1,8)
call HGT_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(38),-4,nMT,G2H8(54),n2h8(193))
  call Hloop_AQ_V(ntryL,G2H8(54),ex3(:),G2H4(92),m3h2x4(:,68),heltab2x8(:,:,68))
  call Hloop_UV_W(ntryL,G1H8(41),75,ex6(:),32,G2H4(93),m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_UV_W(ntryL,G1H8(42),75,ex6(:),32,G2H4(94),m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_UV_W(ntryL,G1H8(43),71,ex5(:),16,G2H4(95),m3h2x4(:,71),heltab2x8(:,:,71))
call HGT_OLR(G1H8(44),1,1,8)
call HGT_invQ_OLR(G1H8(44),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(44),-32,nMT,G2H8(55),n2h8(194))
  call Hloop_QV_A(ntryL,G2H8(55),ex6(:),G2H4(96),m3h2x4(:,72),heltab2x8(:,:,72))
  call Hloop_UV_W(ntryL,G1H8(47),71,ex5(:),16,G2H4(97),m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_UV_W(ntryL,G1H8(48),71,ex5(:),16,G2H4(98),m3h2x4(:,74),heltab2x8(:,:,74))
  call Hloop_VQ_A(ntryL,G1H16(157),ex3(:),G1H8(7),m3h2x8(:,137),heltab2x16(:,:,161))
  call Hloop_Q_A(ntryL,G1H8(7),92,nMT,G2H8(56),n2h8(195))
call HGT_OLR(G1H16(158),1,1,16)
call HGT_invQ_OLR(G1H16(158),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(158),-32,nMT,G2H16(45),n2h16(179))



end subroutine vamp_1

end module ol_vamp_1_ppllttj_eexttxggg_1_/**/REALKIND
