
module ol_vamp_1_ppllttj_nenexttxbbxg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllttj_nenexttxbbxg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllttj_nenexttxbbxg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppllttj_nenexttxbbxg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppllttj_nenexttxbbxg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppllttj_nenexttxbbxg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppllttj_nenexttxbbxg_1_/**/DREALKIND, only: ntryL, p_switch, Hel
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(128)
  type(Hpolcont), intent(in) :: M(4,128)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

Gcoeff(:)%j = (c(14)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)+c(10)*M(4,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1),h0tab(:,1),[64,3,32,8,4,16],[nMB,nMB,0,nMT,0,nMB],6,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1),heltab2x128(:,:,1))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(1),n2h64(1))
Gcoeff(:)%j = (c(14)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)+c(10)*M(4,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(2),h0tab(:,2),[64,3,16,4,8,32],[nMB,nMB,0,nMT,0,nMB],6,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,2),heltab2x128(:,:,2))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(2),n2h64(2))
Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)+c(4)*(M(1,:)%j-M(4,:)%j)) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(3),h0tab(:,3),[64,8,4,16,3,32],[0,nMT,0,nMB,nMB,0],6,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(3),m3h2x64(:,3),heltab2x128(:,:,3))
Gcoeff(:)%j = (c(11)*(-M(2,:)%j-M(3,:)%j)+c(10)*M(4,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(4),h0tab(:,4),[64,3,32,4,8,16],[nMB,nMB,0,nMT,0,nMB],6,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,4),heltab2x128(:,:,4))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(4),n2h64(3))
Gcoeff(:)%j = (c(11)*(-M(2,:)%j-M(3,:)%j)+c(10)*M(4,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(5),h0tab(:,5),[64,3,16,8,4,32],[nMB,nMB,0,nMT,0,nMB],6,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,5),heltab2x128(:,:,5))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(5),n2h64(4))
Gcoeff(:)%j = (c(5)*M(2,:)%j+c(3)*M(3,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(6),h0tab(:,6),[64,8,4,32,3,16],[0,nMT,0,nMB,nMB,0],6,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(6),m3h2x64(:,6),heltab2x128(:,:,6))
Gcoeff(:)%j = (-(c(3)*M(2,:)%j)-c(5)*M(3,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(7),h0tab(:,7),[64,4,8,16,3,32],[0,nMT,0,nMB,nMB,0],6,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(7),m3h2x64(:,7),heltab2x128(:,:,7))
Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)+c(4)*(-M(1,:)%j+M(4,:)%j)) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(8),h0tab(:,8),[64,4,8,32,3,16],[0,nMT,0,nMB,nMB,0],6,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(8),m3h2x64(:,8),heltab2x128(:,:,8))
Gcoeff(:)%j = (c(10)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)+c(14)*M(4,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(9),h0tab(:,9),[64,4,16,3,32,8],[nMT,0,nMB,nMB,0,nMT],6,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,9),heltab2x128(:,:,9))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(9),n2h64(5))
Gcoeff(:)%j = (c(10)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)+c(14)*M(4,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(10),h0tab(:,10),[64,3,8,32,16,4],[nMT,nMT,0,nMB,0,nMT],6,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,10),heltab2x128(:,:,10))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(10),n2h64(6))
Gcoeff(:)%j = (c(10)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)+c(14)*M(4,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(11),h0tab(:,11),[64,3,4,16,32,8],[nMT,nMT,0,nMB,0,nMT],6,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,11),heltab2x128(:,:,11))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(11),n2h64(7))
Gcoeff(:)%j = (c(14)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)+c(10)*M(4,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(12),h0tab(:,12),[64,16,4,3,8,32],[nMB,0,nMT,nMT,0,nMB],6,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,12),heltab2x128(:,:,12))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(12),n2h64(8))
Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)+c(4)*(M(1,:)%j-M(4,:)%j)) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(13),h0tab(:,13),[64,8,3,4,16,32],[0,nMT,nMT,0,nMB,0],6,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(13),m3h2x64(:,13),heltab2x128(:,:,13))
Gcoeff(:)%j = (c(10)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(14),h0tab(:,14),[64,4,32,3,16,8],[nMT,0,nMB,nMB,0,nMT],6,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,14),heltab2x128(:,:,14))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(14),n2h64(9))
Gcoeff(:)%j = (c(10)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(15),h0tab(:,15),[64,3,8,16,32,4],[nMT,nMT,0,nMB,0,nMT],6,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,15),heltab2x128(:,:,15))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(15),n2h64(10))
Gcoeff(:)%j = (c(10)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(16),h0tab(:,16),[64,3,4,32,16,8],[nMT,nMT,0,nMB,0,nMT],6,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,16),heltab2x128(:,:,16))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(16),n2h64(11))
Gcoeff(:)%j = (c(11)*(-M(2,:)%j-M(3,:)%j)+c(10)*M(4,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(17),h0tab(:,17),[64,16,8,3,4,32],[nMB,0,nMT,nMT,0,nMB],6,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,17),heltab2x128(:,:,17))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(17),n2h64(12))
Gcoeff(:)%j = (c(5)*M(2,:)%j+c(3)*M(3,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(18),h0tab(:,18),[64,8,3,4,32,16],[0,nMT,nMT,0,nMB,0],6,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(18),m3h2x64(:,18),heltab2x128(:,:,18))
Gcoeff(:)%j = (-(c(3)*M(2,:)%j)-c(5)*M(3,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(19),h0tab(:,19),[64,4,3,8,16,32],[0,nMT,nMT,0,nMB,0],6,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(19),m3h2x64(:,19),heltab2x128(:,:,19))
Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)+c(4)*(-M(1,:)%j+M(4,:)%j)) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(20),h0tab(:,20),[64,4,3,8,32,16],[0,nMT,nMT,0,nMB,0],6,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(20),m3h2x64(:,20),heltab2x128(:,:,20))
  call Hloop_QZ_A(ntryL,G1H64(1),wf4(:,4),G1H16(1),ngZd,m3h4x16(:,1),heltab2x64(:,:,1))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMB,G2H16(1),n2h16(1))
  call Hloop_AZ_Q(ntryL,G1H64(2),wf4(:,4),G1H16(1),ngZd,m3h4x16(:,2),heltab2x64(:,:,2))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMB,G2H16(2),n2h16(2))
  call Hloop_VA_Q(ntryL,G1H64(3),ex4(:),G1H32(1),m3h2x32(:,1),heltab2x64(:,:,3))
  call Hloop_A_Q(ntryL,G1H32(1),72,nMT,G2H32(1),n2h32(1))
  call Hloop_QZ_A(ntryL,G1H64(4),wf4(:,4),G1H16(1),ngZd,m3h4x16(:,3),heltab2x64(:,:,4))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMB,G2H16(3),n2h16(3))
  call Hloop_AZ_Q(ntryL,G1H64(5),wf4(:,4),G1H16(1),ngZd,m3h4x16(:,4),heltab2x64(:,:,5))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMB,G2H16(4),n2h16(4))
  call Hloop_VA_Q(ntryL,G1H64(6),ex4(:),G1H32(1),m3h2x32(:,2),heltab2x64(:,:,6))
  call Hloop_A_Q(ntryL,G1H32(1),72,nMT,G2H32(2),n2h32(2))
  call Hloop_VQ_A(ntryL,G1H64(7),ex3(:),G1H32(1),m3h2x32(:,3),heltab2x64(:,:,7))
  call Hloop_Q_A(ntryL,G1H32(1),68,nMT,G2H32(3),n2h32(3))
  call Hloop_VQ_A(ntryL,G1H64(8),ex3(:),G1H32(1),m3h2x32(:,4),heltab2x64(:,:,8))
  call Hloop_Q_A(ntryL,G1H32(1),68,nMT,G2H32(4),n2h32(4))
  call Hloop_AQ_V(ntryL,G1H64(9),ex3(:),G1H32(1),m3h2x32(:,5),heltab2x64(:,:,9))
  call Hloop_QZ_A(ntryL,G1H64(10),wf4(:,4),G1H16(1),ngZu,m3h4x16(:,5),heltab2x64(:,:,10))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMT,G2H16(5),n2h16(5))
  call Hloop_AZ_Q(ntryL,G1H64(11),wf4(:,4),G1H16(1),ngZu,m3h4x16(:,6),heltab2x64(:,:,11))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMT,G2H16(6),n2h16(6))
  call Hloop_AQ_V(ntryL,G1H64(12),ex5(:),G1H32(2),m3h2x32(:,6),heltab2x64(:,:,12))
  call Hloop_VA_Q(ntryL,G1H64(13),ex4(:),G1H32(3),m3h2x32(:,7),heltab2x64(:,:,13))
  call Hloop_A_Q(ntryL,G1H32(3),72,nMT,G2H32(5),n2h32(5))
  call Hloop_AQ_V(ntryL,G1H64(14),ex3(:),G1H32(3),m3h2x32(:,8),heltab2x64(:,:,14))
  call Hloop_QZ_A(ntryL,G1H64(15),wf4(:,4),G1H16(1),ngZu,m3h4x16(:,7),heltab2x64(:,:,15))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMT,G2H16(7),n2h16(7))
  call Hloop_AZ_Q(ntryL,G1H64(16),wf4(:,4),G1H16(1),ngZu,m3h4x16(:,8),heltab2x64(:,:,16))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMT,G2H16(8),n2h16(8))
  call Hloop_AQ_V(ntryL,G1H64(17),ex5(:),G1H32(4),m3h2x32(:,9),heltab2x64(:,:,17))
  call Hloop_VA_Q(ntryL,G1H64(18),ex4(:),G1H32(5),m3h2x32(:,10),heltab2x64(:,:,18))
  call Hloop_A_Q(ntryL,G1H32(5),72,nMT,G2H32(6),n2h32(6))
  call Hloop_VQ_A(ntryL,G1H64(19),ex3(:),G1H32(5),m3h2x32(:,11),heltab2x64(:,:,19))
  call Hloop_Q_A(ntryL,G1H32(5),68,nMT,G2H32(7),n2h32(7))
  call Hloop_VQ_A(ntryL,G1H64(20),ex3(:),G1H32(5),m3h2x32(:,12),heltab2x64(:,:,20))
  call Hloop_Q_A(ntryL,G1H32(5),68,nMT,G2H32(8),n2h32(8))
  call Hloop_QA_V(ntryL,G2H16(1),ex6(:),G2H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_AQ_V(ntryL,G2H16(2),ex5(:),G2H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_AQ_V(ntryL,G2H32(1),ex3(:),G2H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_QA_V(ntryL,G2H16(3),ex6(:),G2H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_AQ_V(ntryL,G2H16(4),ex5(:),G2H8(4),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_AQ_V(ntryL,G2H32(2),ex3(:),G2H16(2),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_QA_V(ntryL,G2H32(3),ex4(:),G2H16(3),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_QA_V(ntryL,G2H32(4),ex4(:),G2H16(4),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_VQ_A(ntryL,G1H32(1),ex5(:),G1H16(1),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_Q_A(ntryL,G1H16(1),84,nMB,G2H16(9),n2h16(9))
  call Hloop_QA_V(ntryL,G2H16(5),ex4(:),G2H8(5),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_AQ_V(ntryL,G2H16(6),ex3(:),G2H8(6),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_VQ_A(ntryL,G1H32(2),ex3(:),G1H16(1),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_Q_A(ntryL,G1H16(1),84,nMT,G2H16(5),n2h16(10))
call Hotf_5pt_reduction(G2H32(5),RedSet_5(1),mass5set(:,1),  & 
G1H32(5),G1H32(1),G1H32(2),G1H32(6),G1H32(7),G1H32(8),32)
call HG1shiftOLR(G1H32(1),32,32)
  call Hloop_VA_Q(ntryL,G1H32(3),ex6(:),G1H16(1),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_A_Q(ntryL,G1H16(1),100,nMB,G2H16(6),n2h16(11))
  call Hloop_QA_V(ntryL,G2H16(7),ex4(:),G2H8(7),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_AQ_V(ntryL,G2H16(8),ex3(:),G2H8(8),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_VA_Q(ntryL,G1H32(4),ex4(:),G1H16(1),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_A_Q(ntryL,G1H16(1),88,nMT,G2H16(7),n2h16(12))
call Hotf_5pt_reduction(G2H32(6),RedSet_5(1),mass5set(:,1),  & 
G1H32(3),G1H32(4),G1H32(9),G1H32(10),G1H32(11),G1H32(12),32)
call HG1shiftOLR(G1H32(4),16,32)
call Hotf_5pt_reduction(G2H32(7),RedSet_5(2),mass5set(:,1),  & 
G1H32(13),G1H32(14),G1H32(15),G1H32(16),G1H32(17),G1H32(18),32)
call HG1shiftOLR(G1H32(14),32,32)
call Hotf_5pt_reduction(G2H32(8),RedSet_5(2),mass5set(:,1),  & 
G1H32(19),G1H32(20),G1H32(21),G1H32(22),G1H32(23),G1H32(24),32)
call HG1shiftOLR(G1H32(20),16,32)
  call Hloop_AZ_Q(ntryL,G1H32(5),wf4(:,4),G1H8(1),ngZu,m3h4x8(:,1),heltab2x32(:,:,9))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(9),n2h8(1))
call HGT_raise_alpha_OLR(G1H32(1),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(1),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(1),ex6(:),G1H16(1),m3h2x16(:,9),heltab2x32(:,:,10))
  call Hloop_AZ_Q(ntryL,G1H32(6),wf4(:,4),G1H8(1),ngZu,m3h4x8(:,2),heltab2x32(:,:,11))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(10),n2h8(2))
  call Hloop_AZ_Q(ntryL,G1H32(7),wf4(:,4),G1H8(1),ngZu,m3h4x8(:,3),heltab2x32(:,:,12))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(11),n2h8(3))
  call Hloop_AZ_Q(ntryL,G1H32(8),wf4(:,4),G1H8(1),ngZu,m3h4x8(:,4),heltab2x32(:,:,13))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(12),n2h8(4))
  call Hloop_AZ_Q(ntryL,G1H32(3),wf4(:,4),G1H8(1),ngZu,m3h4x8(:,5),heltab2x32(:,:,14))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(13),n2h8(5))
call HGT_raise_alpha_OLR(G1H32(4),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(4),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(4),ex5(:),G1H16(2),m3h2x16(:,10),heltab2x32(:,:,15))
  call Hloop_AZ_Q(ntryL,G1H32(10),wf4(:,4),G1H8(1),ngZu,m3h4x8(:,6),heltab2x32(:,:,16))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(14),n2h8(6))
  call Hloop_AZ_Q(ntryL,G1H32(11),wf4(:,4),G1H8(1),ngZu,m3h4x8(:,7),heltab2x32(:,:,17))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(15),n2h8(7))
  call Hloop_AZ_Q(ntryL,G1H32(12),wf4(:,4),G1H8(1),ngZu,m3h4x8(:,8),heltab2x32(:,:,18))
  call Hloop_A_Q(ntryL,G1H8(1),75,nMT,G2H8(16),n2h8(8))
  call Hloop_QZ_A(ntryL,G1H32(13),wf4(:,4),G1H8(1),ngZu,m3h4x8(:,9),heltab2x32(:,:,19))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(17),n2h8(9))
call HGT_raise_alpha_OLR(G1H32(14),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(14),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(14),ex6(:),G1H16(3),m3h2x16(:,11),heltab2x32(:,:,20))
  call Hloop_QZ_A(ntryL,G1H32(16),wf4(:,4),G1H8(1),ngZu,m3h4x8(:,10),heltab2x32(:,:,21))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(18),n2h8(10))
  call Hloop_QZ_A(ntryL,G1H32(17),wf4(:,4),G1H8(1),ngZu,m3h4x8(:,11),heltab2x32(:,:,22))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(19),n2h8(11))
  call Hloop_QZ_A(ntryL,G1H32(18),wf4(:,4),G1H8(1),ngZu,m3h4x8(:,12),heltab2x32(:,:,23))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(20),n2h8(12))
  call Hloop_QZ_A(ntryL,G1H32(19),wf4(:,4),G1H8(1),ngZu,m3h4x8(:,13),heltab2x32(:,:,24))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(21),n2h8(13))
call HGT_raise_alpha_OLR(G1H32(20),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(20),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(20),ex5(:),G1H16(4),m3h2x16(:,12),heltab2x32(:,:,25))
  call Hloop_QZ_A(ntryL,G1H32(22),wf4(:,4),G1H8(1),ngZu,m3h4x8(:,14),heltab2x32(:,:,26))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(22),n2h8(14))
  call Hloop_QZ_A(ntryL,G1H32(23),wf4(:,4),G1H8(1),ngZu,m3h4x8(:,15),heltab2x32(:,:,27))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(23),n2h8(15))
  call Hloop_QZ_A(ntryL,G1H32(24),wf4(:,4),G1H8(1),ngZu,m3h4x8(:,16),heltab2x32(:,:,28))
  call Hloop_Q_A(ntryL,G1H8(1),71,nMT,G2H8(24),n2h8(16))
call Hotf_5pt_reduction(G2H8(1),RedSet_5(3),mass5set(:,2),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),G1H8(6),8)
call HG1shiftOLR(G1H8(2),16,8)
call Hotf_5pt_reduction(G2H8(2),RedSet_5(4),mass5set(:,2),  & 
G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),G1H8(12),8)
call HG1shiftOLR(G1H8(8),32,8)
call Hotf_5pt_reduction(G2H16(1),RedSet_5(5),mass5set(:,3),  & 
G1H16(5),G1H16(6),G1H16(7),G1H16(8),G1H16(9),G1H16(10),16)
call HG1shiftOLR(G1H16(6),32,16)
call Hotf_5pt_reduction(G2H8(3),RedSet_5(6),mass5set(:,2),  & 
G1H8(13),G1H8(14),G1H8(15),G1H8(16),G1H8(17),G1H8(18),8)
call HG1shiftOLR(G1H8(14),16,8)
call Hotf_5pt_reduction(G2H8(4),RedSet_5(7),mass5set(:,2),  & 
G1H8(19),G1H8(20),G1H8(21),G1H8(22),G1H8(23),G1H8(24),8)
call HG1shiftOLR(G1H8(20),32,8)
call Hotf_5pt_reduction(G2H16(2),RedSet_5(8),mass5set(:,3),  & 
G1H16(11),G1H16(12),G1H16(13),G1H16(14),G1H16(15),G1H16(16),16)
call HG1shiftOLR(G1H16(12),16,16)
call Hotf_5pt_reduction(G2H16(3),RedSet_5(9),mass5set(:,3),  & 
G1H16(17),G1H16(18),G1H16(19),G1H16(20),G1H16(21),G1H16(22),16)
call HG1shiftOLR(G1H16(18),32,16)
call Hotf_5pt_reduction(G2H16(4),RedSet_5(10),mass5set(:,3),  & 
G1H16(23),G1H16(24),G1H16(25),G1H16(26),G1H16(27),G1H16(28),16)
call HG1shiftOLR(G1H16(24),16,16)
call Hotf_5pt_reduction(G2H16(9),RedSet_5(11),mass5set(:,4),  & 
G1H16(29),G1H16(30),G1H16(31),G1H16(32),G1H16(33),G1H16(34),16)
call HG1shiftOLR(G1H16(30),8,16)
call Hotf_5pt_reduction(G2H8(5),RedSet_5(12),mass5set(:,5),  & 
G1H8(25),G1H8(26),G1H8(27),G1H8(28),G1H8(29),G1H8(30),8)
call HG1shiftOLR(G1H8(26),4,8)
call Hotf_5pt_reduction(G2H8(6),RedSet_5(13),mass5set(:,5),  & 
G1H8(31),G1H8(32),G1H8(33),G1H8(34),G1H8(35),G1H8(36),8)
call HG1shiftOLR(G1H8(32),8,8)
call Hotf_5pt_reduction(G2H16(5),RedSet_5(14),mass5set(:,6),  & 
G1H16(35),G1H16(36),G1H16(37),G1H16(38),G1H16(39),G1H16(40),16)
call HG1shiftOLR(G1H16(36),32,16)
call Hotf_5pt_reduction(G2H16(6),RedSet_5(15),mass5set(:,4),  & 
G1H16(41),G1H16(42),G1H16(43),G1H16(44),G1H16(45),G1H16(46),16)
call HG1shiftOLR(G1H16(42),8,16)
call Hotf_5pt_reduction(G2H8(7),RedSet_5(16),mass5set(:,5),  & 
G1H8(37),G1H8(38),G1H8(39),G1H8(40),G1H8(41),G1H8(42),8)
call HG1shiftOLR(G1H8(38),4,8)
call Hotf_5pt_reduction(G2H8(8),RedSet_5(17),mass5set(:,5),  & 
G1H8(43),G1H8(44),G1H8(45),G1H8(46),G1H8(47),G1H8(48),8)
call HG1shiftOLR(G1H8(44),8,8)
call Hotf_5pt_reduction(G2H16(7),RedSet_5(18),mass5set(:,6),  & 
G1H16(47),G1H16(48),G1H16(49),G1H16(50),G1H16(51),G1H16(52),16)
call HG1shiftOLR(G1H16(48),32,16)
  call Hloop_AQ_V(ntryL,G2H8(9),ex3(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_V(ntryL,G2H8(11),ex3(:),G2H4(2),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_AQ_V(ntryL,G2H8(12),ex3(:),G2H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_AQ_V(ntryL,G2H8(13),ex3(:),G2H4(4),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_AQ_V(ntryL,G2H8(15),ex3(:),G2H4(5),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_AQ_V(ntryL,G2H8(16),ex3(:),G2H4(6),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_QA_V(ntryL,G2H8(17),ex4(:),G2H4(7),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_QA_V(ntryL,G2H8(19),ex4(:),G2H4(8),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_QA_V(ntryL,G2H8(20),ex4(:),G2H4(9),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_QA_V(ntryL,G2H8(21),ex4(:),G2H4(10),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_QA_V(ntryL,G2H8(23),ex4(:),G2H4(11),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_QA_V(ntryL,G2H8(24),ex4(:),G2H4(12),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_VA_Q(ntryL,G1H8(1),ex4(:),G1H4(1),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_A_Q(ntryL,G1H4(1),107,nMT,G2H4(13),n2h4(1))
call HGT_OLR(G1H8(2),1,1,8)
call HGT_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(2),-16,nMB,G2H8(1),n2h8(17))
  call Hloop_AQ_V(ntryL,G2H8(1),ex5(:),G2H4(14),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_VA_Q(ntryL,G1H8(5),ex4(:),G1H4(1),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_A_Q(ntryL,G1H4(1),107,nMT,G2H4(15),n2h4(2))
  call Hloop_VA_Q(ntryL,G1H8(6),ex4(:),G1H4(1),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_A_Q(ntryL,G1H4(1),107,nMT,G2H4(16),n2h4(3))
  call Hloop_VQ_A(ntryL,G1H8(7),ex3(:),G1H4(1),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMT,G2H4(17),n2h4(4))
call HGT_OLR(G1H8(8),1,1,8)
call HGT_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(8),-32,nMB,G2H8(2),n2h8(18))
  call Hloop_QA_V(ntryL,G2H8(2),ex6(:),G2H4(18),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_VQ_A(ntryL,G1H8(11),ex3(:),G1H4(1),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMT,G2H4(19),n2h4(5))
  call Hloop_VQ_A(ntryL,G1H8(12),ex3(:),G1H4(1),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMT,G2H4(20),n2h4(6))
  call Hloop_VQ_A(ntryL,G1H16(5),ex5(:),G1H8(1),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_Q_A(ntryL,G1H8(1),92,nMB,G2H8(3),n2h8(19))
call HGT_raise_alpha_OLR(G1H16(6),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(6),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(6),ex6(:),G1H8(2),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_VQ_A(ntryL,G1H16(9),ex5(:),G1H8(5),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_Q_A(ntryL,G1H8(5),92,nMB,G2H8(4),n2h8(20))
  call Hloop_VQ_A(ntryL,G1H16(10),ex5(:),G1H8(6),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_Q_A(ntryL,G1H8(6),92,nMB,G2H8(5),n2h8(21))
  call Hloop_VQ_A(ntryL,G1H8(13),ex3(:),G1H4(1),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G1H4(1),103,nMT,G2H4(21),n2h4(7))
call HGT_OLR(G1H8(14),1,1,8)
call HGT_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(14),-16,nMB,G2H8(6),n2h8(22))
  call Hloop_AQ_V(ntryL,G2H8(6),ex5(:),G2H4(22),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_VQ_A(ntryL,G1H8(17),ex3(:),G1H4(1),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_Q_A(ntryL,G1H4(1),103,nMT,G2H4(23),n2h4(8))
  call Hloop_VQ_A(ntryL,G1H8(18),ex3(:),G1H4(1),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G1H4(1),103,nMT,G2H4(24),n2h4(9))
  call Hloop_VA_Q(ntryL,G1H8(19),ex4(:),G1H4(1),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_A_Q(ntryL,G1H4(1),91,nMT,G2H4(25),n2h4(10))
call HGT_OLR(G1H8(20),1,1,8)
call HGT_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(20),-32,nMB,G2H8(7),n2h8(23))
  call Hloop_QA_V(ntryL,G2H8(7),ex6(:),G2H4(26),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_VA_Q(ntryL,G1H8(23),ex4(:),G1H4(1),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_A_Q(ntryL,G1H4(1),91,nMT,G2H4(27),n2h4(11))
  call Hloop_VA_Q(ntryL,G1H8(24),ex4(:),G1H4(1),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_A_Q(ntryL,G1H4(1),91,nMT,G2H4(28),n2h4(12))
  call Hloop_VA_Q(ntryL,G1H16(11),ex6(:),G1H8(7),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_A_Q(ntryL,G1H8(7),108,nMB,G2H8(8),n2h8(24))
call HGT_raise_alpha_OLR(G1H16(12),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(12),2,5,16)
  call Hloop_VQ_A(ntryL,G1H16(12),ex5(:),G1H8(8),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_VA_Q(ntryL,G1H16(15),ex6(:),G1H8(11),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_A_Q(ntryL,G1H8(11),108,nMB,G2H8(9),n2h8(25))
  call Hloop_VA_Q(ntryL,G1H16(16),ex6(:),G1H8(12),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_A_Q(ntryL,G1H8(12),108,nMB,G2H8(11),n2h8(26))
  call Hloop_VQ_A(ntryL,G1H16(17),ex5(:),G1H8(1),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_Q_A(ntryL,G1H8(1),92,nMB,G2H8(12),n2h8(27))
call HGT_raise_alpha_OLR(G1H16(18),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(18),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(18),ex6(:),G1H8(5),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_VQ_A(ntryL,G1H16(21),ex5(:),G1H8(6),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_Q_A(ntryL,G1H8(6),92,nMB,G2H8(13),n2h8(28))
  call Hloop_VQ_A(ntryL,G1H16(22),ex5(:),G1H8(13),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_Q_A(ntryL,G1H8(13),92,nMB,G2H8(15),n2h8(29))
  call Hloop_VA_Q(ntryL,G1H16(23),ex6(:),G1H8(14),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_A_Q(ntryL,G1H8(14),108,nMB,G2H8(16),n2h8(30))
call HGT_raise_alpha_OLR(G1H16(24),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(24),2,5,16)
  call Hloop_VQ_A(ntryL,G1H16(24),ex5(:),G1H8(17),m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_VA_Q(ntryL,G1H16(27),ex6(:),G1H8(18),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_A_Q(ntryL,G1H8(18),108,nMB,G2H8(17),n2h8(31))
  call Hloop_VA_Q(ntryL,G1H16(28),ex6(:),G1H8(19),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_A_Q(ntryL,G1H8(19),108,nMB,G2H8(19),n2h8(32))
  call Hloop_QZ_A(ntryL,G1H16(29),wf4(:,4),G1H4(1),ngZd,m3h4x4(:,1),heltab2x16(:,:,25))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMB,G2H4(29),n2h4(13))
call HGT_OLR(G1H16(30),1,1,16)
call HGT_invQ_OLR(G1H16(30),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(30),-8,nMT,G2H16(8),n2h16(17))
  call Hloop_QA_V(ntryL,G2H16(8),ex4(:),G2H8(20),m3h2x8(:,25),heltab2x16(:,:,26))
  call Hloop_QZ_A(ntryL,G1H16(33),wf4(:,4),G1H4(1),ngZd,m3h4x4(:,2),heltab2x16(:,:,27))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMB,G2H4(30),n2h4(14))
  call Hloop_QZ_A(ntryL,G1H16(34),wf4(:,4),G1H4(1),ngZd,m3h4x4(:,3),heltab2x16(:,:,28))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMB,G2H4(31),n2h4(15))
  call Hloop_VA_Q(ntryL,G1H8(25),ex6(:),G1H4(1),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_A_Q(ntryL,G1H4(1),107,nMB,G2H4(32),n2h4(16))
call HGT_OLR(G1H8(26),1,1,8)
call HGT_invQ_OLR(G1H8(26),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(26),-4,nMT,G2H8(21),n2h8(33))
  call Hloop_AQ_V(ntryL,G2H8(21),ex3(:),G2H4(33),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_VA_Q(ntryL,G1H8(29),ex6(:),G1H4(1),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_A_Q(ntryL,G1H4(1),107,nMB,G2H4(34),n2h4(17))
  call Hloop_VA_Q(ntryL,G1H8(30),ex6(:),G1H4(1),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_A_Q(ntryL,G1H4(1),107,nMB,G2H4(35),n2h4(18))
  call Hloop_VQ_A(ntryL,G1H8(31),ex5(:),G1H4(1),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMB,G2H4(36),n2h4(19))
call HGT_OLR(G1H8(32),1,1,8)
call HGT_invQ_OLR(G1H8(32),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(32),-8,nMT,G2H8(23),n2h8(34))
  call Hloop_QA_V(ntryL,G2H8(23),ex4(:),G2H4(37),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_VQ_A(ntryL,G1H8(35),ex5(:),G1H4(1),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMB,G2H4(38),n2h4(20))
  call Hloop_VQ_A(ntryL,G1H8(36),ex5(:),G1H4(1),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMB,G2H4(39),n2h4(21))
  call Hloop_QZ_A(ntryL,G1H16(35),wf4(:,4),G1H4(1),ngZu,m3h4x4(:,4),heltab2x16(:,:,29))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMT,G2H4(40),n2h4(22))
call HGT_OLR(G1H16(36),1,1,16)
call HGT_invQ_OLR(G1H16(36),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(36),-32,nMB,G2H16(1),n2h16(18))
  call Hloop_QA_V(ntryL,G2H16(1),ex6(:),G2H8(24),m3h2x8(:,26),heltab2x16(:,:,30))
  call Hloop_QZ_A(ntryL,G1H16(39),wf4(:,4),G1H4(1),ngZu,m3h4x4(:,5),heltab2x16(:,:,31))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMT,G2H4(41),n2h4(23))
  call Hloop_QZ_A(ntryL,G1H16(40),wf4(:,4),G1H4(1),ngZu,m3h4x4(:,6),heltab2x16(:,:,32))
  call Hloop_Q_A(ntryL,G1H4(1),87,nMT,G2H4(42),n2h4(24))
  call Hloop_AZ_Q(ntryL,G1H16(41),wf4(:,4),G1H4(1),ngZd,m3h4x4(:,7),heltab2x16(:,:,33))
  call Hloop_A_Q(ntryL,G1H4(1),103,nMB,G2H4(43),n2h4(25))
call HGT_OLR(G1H16(42),1,1,16)
call HGT_invQ_OLR(G1H16(42),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(42),-8,nMT,G2H16(2),n2h16(19))
  call Hloop_QA_V(ntryL,G2H16(2),ex4(:),G2H8(1),m3h2x8(:,27),heltab2x16(:,:,34))
  call Hloop_AZ_Q(ntryL,G1H16(45),wf4(:,4),G1H4(1),ngZd,m3h4x4(:,8),heltab2x16(:,:,35))
  call Hloop_A_Q(ntryL,G1H4(1),103,nMB,G2H4(44),n2h4(26))
  call Hloop_AZ_Q(ntryL,G1H16(46),wf4(:,4),G1H4(1),ngZd,m3h4x4(:,9),heltab2x16(:,:,36))
  call Hloop_A_Q(ntryL,G1H4(1),103,nMB,G2H4(45),n2h4(27))
  call Hloop_VQ_A(ntryL,G1H8(37),ex5(:),G1H4(1),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_Q_A(ntryL,G1H4(1),91,nMB,G2H4(46),n2h4(28))
call HGT_OLR(G1H8(38),1,1,8)
call HGT_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(38),-4,nMT,G2H8(2),n2h8(35))
  call Hloop_AQ_V(ntryL,G2H8(2),ex3(:),G2H4(47),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_VQ_A(ntryL,G1H8(41),ex5(:),G1H4(1),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_Q_A(ntryL,G1H4(1),91,nMB,G2H4(48),n2h4(29))
  call Hloop_VQ_A(ntryL,G1H8(42),ex5(:),G1H4(1),m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_Q_A(ntryL,G1H4(1),91,nMB,G2H4(49),n2h4(30))
  call Hloop_VA_Q(ntryL,G1H8(43),ex6(:),G1H4(1),m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_A_Q(ntryL,G1H4(1),103,nMB,G2H4(50),n2h4(31))
call HGT_OLR(G1H8(44),1,1,8)
call HGT_invQ_OLR(G1H8(44),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(44),-8,nMT,G2H8(6),n2h8(36))
  call Hloop_QA_V(ntryL,G2H8(6),ex4(:),G2H4(51),m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_VA_Q(ntryL,G1H8(47),ex6(:),G1H4(1),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_A_Q(ntryL,G1H4(1),103,nMB,G2H4(52),n2h4(32))
  call Hloop_VA_Q(ntryL,G1H8(48),ex6(:),G1H4(1),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_A_Q(ntryL,G1H4(1),103,nMB,G2H4(53),n2h4(33))
  call Hloop_AZ_Q(ntryL,G1H16(47),wf4(:,4),G1H4(1),ngZu,m3h4x4(:,10),heltab2x16(:,:,37))
  call Hloop_A_Q(ntryL,G1H4(1),91,nMT,G2H4(54),n2h4(34))
call HGT_OLR(G1H16(48),1,1,16)
call HGT_invQ_OLR(G1H16(48),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(48),-32,nMB,G2H16(3),n2h16(20))
  call Hloop_QA_V(ntryL,G2H16(3),ex6(:),G2H8(7),m3h2x8(:,28),heltab2x16(:,:,38))
  call Hloop_AZ_Q(ntryL,G1H16(51),wf4(:,4),G1H4(1),ngZu,m3h4x4(:,11),heltab2x16(:,:,39))
  call Hloop_A_Q(ntryL,G1H4(1),91,nMT,G2H4(55),n2h4(35))
  call Hloop_AZ_Q(ntryL,G1H16(52),wf4(:,4),G1H4(1),ngZu,m3h4x4(:,12),heltab2x16(:,:,40))
  call Hloop_A_Q(ntryL,G1H4(1),91,nMT,G2H4(56),n2h4(36))
call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
call HG1shiftOLR(G1H4(2),32,4)
call Hotf_5pt_reduction(G2H4(3),RedSet_5(19),mass5set(:,7),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
call HG1shiftOLR(G1H4(8),32,4)
call Hotf_5pt_reduction(G2H4(4),RedSet_5(1),mass5set(:,1),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
call HG1shiftOLR(G1H4(14),16,4)
call Hotf_5pt_reduction(G2H4(6),RedSet_5(20),mass5set(:,7),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
call HG1shiftOLR(G1H4(20),16,4)
call Hotf_5pt_reduction(G2H4(7),RedSet_5(2),mass5set(:,1),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
call HG1shiftOLR(G1H4(26),32,4)
call Hotf_5pt_reduction(G2H4(9),RedSet_5(21),mass5set(:,7),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
call HG1shiftOLR(G1H4(32),32,4)
call Hotf_5pt_reduction(G2H4(10),RedSet_5(2),mass5set(:,1),  & 
G1H4(37),G1H4(38),G1H4(39),G1H4(40),G1H4(41),G1H4(42),4)
call HG1shiftOLR(G1H4(38),16,4)
call Hotf_5pt_reduction(G2H4(12),RedSet_5(22),mass5set(:,7),  & 
G1H4(43),G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
call HG1shiftOLR(G1H4(44),16,4)
  call Hloop_AQ_V(ntryL,G2H4(13),ex3(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_AQ_V(ntryL,G2H4(16),ex3(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_V(ntryL,G2H4(17),ex4(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_V(ntryL,G2H4(20),ex4(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
call Hotf_5pt_reduction(G2H8(3),RedSet_5(5),mass5set(:,3),  & 
G1H8(20),G1H8(23),G1H8(24),G1H8(7),G1H8(11),G1H8(12),8)
call HG1shiftOLR(G1H8(23),32,8)
call Hotf_5pt_reduction(G2H8(5),RedSet_5(23),mass5set(:,3),  & 
G1H8(1),G1H8(6),G1H8(13),G1H8(14),G1H8(18),G1H8(19),8)
call HG1shiftOLR(G1H8(6),32,8)
  call Hloop_QA_V(ntryL,G2H4(21),ex4(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QA_V(ntryL,G2H4(24),ex4(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_AQ_V(ntryL,G2H4(25),ex3(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_V(ntryL,G2H4(28),ex3(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
call Hotf_5pt_reduction(G2H8(8),RedSet_5(8),mass5set(:,3),  & 
G1H8(25),G1H8(26),G1H8(29),G1H8(30),G1H8(31),G1H8(32),8)
call HG1shiftOLR(G1H8(26),16,8)
call Hotf_5pt_reduction(G2H8(11),RedSet_5(24),mass5set(:,3),  & 
G1H8(35),G1H8(36),G1H8(37),G1H8(38),G1H8(41),G1H8(42),8)
call HG1shiftOLR(G1H8(36),16,8)
call Hotf_5pt_reduction(G2H8(12),RedSet_5(9),mass5set(:,3),  & 
G1H8(43),G1H8(44),G1H8(47),G1H8(48),G1H8(49),G1H8(50),8)
call HG1shiftOLR(G1H8(44),32,8)
call Hotf_5pt_reduction(G2H8(15),RedSet_5(25),mass5set(:,3),  & 
G1H8(51),G1H8(52),G1H8(53),G1H8(54),G1H8(55),G1H8(56),8)
call HG1shiftOLR(G1H8(52),32,8)
call Hotf_5pt_reduction(G2H8(16),RedSet_5(10),mass5set(:,3),  & 
G1H8(57),G1H8(58),G1H8(59),G1H8(60),G1H8(61),G1H8(62),8)
call HG1shiftOLR(G1H8(58),16,8)
call Hotf_5pt_reduction(G2H8(19),RedSet_5(26),mass5set(:,3),  & 
G1H8(63),G1H8(64),G1H8(65),G1H8(66),G1H8(67),G1H8(68),8)
call HG1shiftOLR(G1H8(64),16,8)
  call Hloop_QA_V(ntryL,G2H4(29),ex6(:),G2H2(9),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_QA_V(ntryL,G2H4(31),ex6(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_AQ_V(ntryL,G2H4(32),ex5(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_AQ_V(ntryL,G2H4(35),ex5(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_QA_V(ntryL,G2H4(36),ex6(:),G2H2(13),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_QA_V(ntryL,G2H4(39),ex6(:),G2H2(14),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_QA_V(ntryL,G2H4(40),ex4(:),G2H2(15),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_QA_V(ntryL,G2H4(42),ex4(:),G2H2(16),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_AQ_V(ntryL,G2H4(43),ex5(:),G2H2(17),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_AQ_V(ntryL,G2H4(45),ex5(:),G2H2(18),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_QA_V(ntryL,G2H4(46),ex6(:),G2H2(19),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_QA_V(ntryL,G2H4(49),ex6(:),G2H2(20),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_AQ_V(ntryL,G2H4(50),ex5(:),G2H2(21),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_AQ_V(ntryL,G2H4(53),ex5(:),G2H2(22),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_AQ_V(ntryL,G2H4(54),ex3(:),G2H2(23),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_AQ_V(ntryL,G2H4(56),ex3(:),G2H2(24),m3h2x2(:,24),heltab2x4(:,:,24))
  call ol_merge(ntryL,G1H4(7),[G1H4(6)])
  call ol_merge(ntryL,G1H4(19),[G1H4(18)])
  call ol_merge(ntryL,G1H4(31),[G1H4(30)])
  call ol_merge(ntryL,G1H4(43),[G1H4(42)])
  call ol_merge(ntryL,G1H8(1),[G1H8(12)])
  call ol_merge(ntryL,G1H8(35),[G1H8(32)])
  call ol_merge(ntryL,G1H8(51),[G1H8(50)])
  call ol_merge(ntryL,G1H8(63),[G1H8(62)])
  call Hloop_VQ_A(ntryL,G1H4(1),ex5(:),G1H2(1),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(25),n2h2(1))
call HGT_raise_alpha_OLR(G1H4(2),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(2),ex6(:),G1H2(1),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_VQ_A(ntryL,G1H4(7),ex5(:),G1H2(2),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(2),95,nMB,G2H2(26),n2h2(2))
call HGT_raise_alpha_OLR(G1H4(8),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(8),ex6(:),G1H2(2),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_VQ_A(ntryL,G1H4(12),ex5(:),G1H2(3),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(3),95,nMB,G2H2(27),n2h2(3))
  call Hloop_VA_Q(ntryL,G1H4(13),ex6(:),G1H2(3),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_A_Q(ntryL,G1H2(3),111,nMB,G2H2(28),n2h2(4))
call HGT_raise_alpha_OLR(G1H4(14),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(14),ex5(:),G1H2(3),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_VA_Q(ntryL,G1H4(19),ex6(:),G1H2(4),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_A_Q(ntryL,G1H2(4),111,nMB,G2H2(29),n2h2(5))
call HGT_raise_alpha_OLR(G1H4(20),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(20),ex5(:),G1H2(4),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_VA_Q(ntryL,G1H4(24),ex6(:),G1H2(5),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_A_Q(ntryL,G1H2(5),111,nMB,G2H2(30),n2h2(6))
  call Hloop_VQ_A(ntryL,G1H4(25),ex5(:),G1H2(5),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(5),95,nMB,G2H2(31),n2h2(7))
call HGT_raise_alpha_OLR(G1H4(26),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(26),ex6(:),G1H2(5),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_VQ_A(ntryL,G1H4(31),ex5(:),G1H2(6),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_Q_A(ntryL,G1H2(6),95,nMB,G2H2(32),n2h2(8))
call HGT_raise_alpha_OLR(G1H4(32),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(32),ex6(:),G1H2(6),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_VQ_A(ntryL,G1H4(36),ex5(:),G1H2(7),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_Q_A(ntryL,G1H2(7),95,nMB,G2H2(33),n2h2(9))
  call Hloop_VA_Q(ntryL,G1H4(37),ex6(:),G1H2(7),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_A_Q(ntryL,G1H2(7),111,nMB,G2H2(34),n2h2(10))
call HGT_raise_alpha_OLR(G1H4(38),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(38),ex5(:),G1H2(7),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_VA_Q(ntryL,G1H4(43),ex6(:),G1H2(8),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_A_Q(ntryL,G1H2(8),111,nMB,G2H2(35),n2h2(11))
call HGT_raise_alpha_OLR(G1H4(44),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(44),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(44),ex5(:),G1H2(8),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_VA_Q(ntryL,G1H4(48),ex6(:),G1H2(9),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_A_Q(ntryL,G1H2(9),111,nMB,G2H2(36),n2h2(12))
  call Hloop_QZ_A(ntryL,G1H8(20),wf4(:,4),G1H2(9),ngZd,m3h4x2(:,1),heltab2x8(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(9),95,nMB,G2H2(37),n2h2(13))
call HGT_raise_alpha_OLR(G1H8(23),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(23),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(23),ex6(:),G1H4(6),m3h2x4(:,45),heltab2x8(:,:,46))
  call Hloop_QZ_A(ntryL,G1H8(1),wf4(:,4),G1H2(9),ngZd,m3h4x2(:,2),heltab2x8(:,:,47))
  call Hloop_Q_A(ntryL,G1H2(9),95,nMB,G2H2(38),n2h2(14))
call HGT_raise_alpha_OLR(G1H8(6),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(6),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(6),ex6(:),G1H4(18),m3h2x4(:,46),heltab2x8(:,:,48))
  call Hloop_QZ_A(ntryL,G1H8(19),wf4(:,4),G1H2(9),ngZd,m3h4x2(:,3),heltab2x8(:,:,49))
  call Hloop_Q_A(ntryL,G1H2(9),95,nMB,G2H2(39),n2h2(15))
  call Hloop_AZ_Q(ntryL,G1H8(25),wf4(:,4),G1H2(9),ngZd,m3h4x2(:,4),heltab2x8(:,:,50))
  call Hloop_A_Q(ntryL,G1H2(9),111,nMB,G2H2(40),n2h2(16))
call HGT_raise_alpha_OLR(G1H8(26),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(26),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(26),ex5(:),G1H4(30),m3h2x4(:,47),heltab2x8(:,:,51))
  call Hloop_AZ_Q(ntryL,G1H8(35),wf4(:,4),G1H2(9),ngZd,m3h4x2(:,5),heltab2x8(:,:,52))
  call Hloop_A_Q(ntryL,G1H2(9),111,nMB,G2H2(41),n2h2(17))
call HGT_raise_alpha_OLR(G1H8(36),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(36),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(36),ex5(:),G1H4(42),m3h2x4(:,48),heltab2x8(:,:,53))
  call Hloop_AZ_Q(ntryL,G1H8(42),wf4(:,4),G1H2(9),ngZd,m3h4x2(:,6),heltab2x8(:,:,54))
  call Hloop_A_Q(ntryL,G1H2(9),111,nMB,G2H2(42),n2h2(18))
  call Hloop_QZ_A(ntryL,G1H8(43),wf4(:,4),G1H2(9),ngZd,m3h4x2(:,7),heltab2x8(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(9),95,nMB,G2H2(43),n2h2(19))
call HGT_raise_alpha_OLR(G1H8(44),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(44),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(44),ex6(:),G1H4(1),m3h2x4(:,49),heltab2x8(:,:,56))
  call Hloop_QZ_A(ntryL,G1H8(51),wf4(:,4),G1H2(9),ngZd,m3h4x2(:,8),heltab2x8(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(9),95,nMB,G2H2(44),n2h2(20))
call HGT_raise_alpha_OLR(G1H8(52),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(52),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(52),ex6(:),G1H4(2),m3h2x4(:,50),heltab2x8(:,:,58))
  call Hloop_QZ_A(ntryL,G1H8(56),wf4(:,4),G1H2(9),ngZd,m3h4x2(:,9),heltab2x8(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(9),95,nMB,G2H2(45),n2h2(21))
  call Hloop_AZ_Q(ntryL,G1H8(57),wf4(:,4),G1H2(9),ngZd,m3h4x2(:,10),heltab2x8(:,:,60))
  call Hloop_A_Q(ntryL,G1H2(9),111,nMB,G2H2(46),n2h2(22))
call HGT_raise_alpha_OLR(G1H8(58),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(58),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(58),ex5(:),G1H4(7),m3h2x4(:,51),heltab2x8(:,:,61))
  call Hloop_AZ_Q(ntryL,G1H8(63),wf4(:,4),G1H2(9),ngZd,m3h4x2(:,11),heltab2x8(:,:,62))
  call Hloop_A_Q(ntryL,G1H2(9),111,nMB,G2H2(47),n2h2(23))
call HGT_raise_alpha_OLR(G1H8(64),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(64),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(64),ex5(:),G1H4(8),m3h2x4(:,52),heltab2x8(:,:,63))
  call Hloop_AZ_Q(ntryL,G1H8(68),wf4(:,4),G1H2(9),ngZd,m3h4x2(:,12),heltab2x8(:,:,64))
  call Hloop_A_Q(ntryL,G1H2(9),111,nMB,G2H2(48),n2h2(24))
call Hotf_5pt_reduction(G2H2(1),RedSet_5(3),mass5set(:,2),  & 
G1H2(9),G1H2(10),G1H2(11),G1H2(12),G1H2(13),G1H2(14),2)
call HG1shiftOLR(G1H2(10),16,2)
call Hotf_5pt_reduction(G2H2(3),RedSet_5(4),mass5set(:,2),  & 
G1H2(15),G1H2(16),G1H2(17),G1H2(18),G1H2(19),G1H2(20),2)
call HG1shiftOLR(G1H2(16),32,2)
call Hotf_5pt_reduction(G2H2(5),RedSet_5(6),mass5set(:,2),  & 
G1H2(21),G1H2(22),G1H2(23),G1H2(24),G1H2(25),G1H2(26),2)
call HG1shiftOLR(G1H2(22),16,2)
call Hotf_5pt_reduction(G2H2(7),RedSet_5(7),mass5set(:,2),  & 
G1H2(27),G1H2(28),G1H2(29),G1H2(30),G1H2(31),G1H2(32),2)
call HG1shiftOLR(G1H2(28),32,2)
call Hotf_5pt_reduction(G2H2(9),RedSet_5(11),mass5set(:,4),  & 
G1H2(33),G1H2(34),G1H2(35),G1H2(36),G1H2(37),G1H2(38),2)
call HG1shiftOLR(G1H2(34),8,2)
call Hotf_5pt_reduction(G2H2(11),RedSet_5(12),mass5set(:,5),  & 
G1H2(39),G1H2(40),G1H2(41),G1H2(42),G1H2(43),G1H2(44),2)
call HG1shiftOLR(G1H2(40),4,2)
call Hotf_5pt_reduction(G2H2(13),RedSet_5(13),mass5set(:,5),  & 
G1H2(45),G1H2(46),G1H2(47),G1H2(48),G1H2(49),G1H2(50),2)
call HG1shiftOLR(G1H2(46),8,2)
call Hotf_5pt_reduction(G2H2(15),RedSet_5(14),mass5set(:,6),  & 
G1H2(51),G1H2(52),G1H2(53),G1H2(54),G1H2(55),G1H2(56),2)
call HG1shiftOLR(G1H2(52),32,2)
call Hotf_5pt_reduction(G2H2(17),RedSet_5(15),mass5set(:,4),  & 
G1H2(57),G1H2(58),G1H2(59),G1H2(60),G1H2(61),G1H2(62),2)
call HG1shiftOLR(G1H2(58),8,2)
call Hotf_5pt_reduction(G2H2(19),RedSet_5(16),mass5set(:,5),  & 
G1H2(63),G1H2(64),G1H2(65),G1H2(66),G1H2(67),G1H2(68),2)
call HG1shiftOLR(G1H2(64),4,2)
call Hotf_5pt_reduction(G2H2(21),RedSet_5(17),mass5set(:,5),  & 
G1H2(69),G1H2(70),G1H2(71),G1H2(72),G1H2(73),G1H2(74),2)
call HG1shiftOLR(G1H2(70),8,2)
call Hotf_5pt_reduction(G2H2(23),RedSet_5(18),mass5set(:,6),  & 
G1H2(75),G1H2(76),G1H2(77),G1H2(78),G1H2(79),G1H2(80),2)
call HG1shiftOLR(G1H2(76),32,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(25),ex6(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(28),ex5(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(31),ex6(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(34),ex5(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(37),ex6(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(40),ex5(:),G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(43),ex6(:),G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(46),ex5(:),G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hloop_VQ_A(ntryL,G1H2(9),ex5(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(9),n2h1(1))
  call Hloop_VQ_A(ntryL,G1H2(10),ex5(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(10),n2h1(2))
  call Hloop_VA_Q(ntryL,G1H2(15),ex6(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(11),n2h1(3))
  call Hloop_VA_Q(ntryL,G1H2(16),ex6(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,nMB,G2tensor(12),n2h1(4))
  call Hloop_VQ_A(ntryL,G1H2(21),ex5(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(13),n2h1(5))
  call Hloop_VQ_A(ntryL,G1H2(22),ex5(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(14),n2h1(6))
  call Hloop_VA_Q(ntryL,G1H2(27),ex6(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(15),n2h1(7))
  call Hloop_VA_Q(ntryL,G1H2(28),ex6(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,nMB,G2tensor(16),n2h1(8))
  call Hloop_VA_Q(ntryL,G1H2(33),ex4(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(17),n2h1(9))
  call Hloop_VA_Q(ntryL,G1H2(34),ex4(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(18),n2h1(10))
  call Hloop_VQ_A(ntryL,G1H2(39),ex3(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(19),n2h1(11))
  call Hloop_VQ_A(ntryL,G1H2(40),ex3(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(20),n2h1(12))
  call Hloop_VA_Q(ntryL,G1H2(45),ex4(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(21),n2h1(13))
  call Hloop_VA_Q(ntryL,G1H2(46),ex4(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(22),n2h1(14))
  call Hloop_VA_Q(ntryL,G1H2(51),ex6(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(23),n2h1(15))
  call Hloop_VA_Q(ntryL,G1H2(52),ex6(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,nMB,G2tensor(24),n2h1(16))
  call Hloop_VA_Q(ntryL,G1H2(57),ex4(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(25),n2h1(17))
  call Hloop_VA_Q(ntryL,G1H2(58),ex4(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(26),n2h1(18))
  call Hloop_VQ_A(ntryL,G1H2(63),ex3(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(27),n2h1(19))
  call Hloop_VQ_A(ntryL,G1H2(64),ex3(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(28),n2h1(20))
  call Hloop_VA_Q(ntryL,G1H2(69),ex4(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(29),n2h1(21))
  call Hloop_VA_Q(ntryL,G1H2(70),ex4(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(30),n2h1(22))
  call Hloop_VA_Q(ntryL,G1H2(75),ex6(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(31),n2h1(23))
  call Hloop_VA_Q(ntryL,G1H2(76),ex6(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,nMB,G2tensor(32),n2h1(24))
call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
call G_TensorShift(G1tensor(2),32)
call Hotf_5pt_reduction_last(G2tensor(2),RedSet_5(1),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
call G_TensorShift(G1tensor(8),16)
call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(2),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
call G_TensorShift(G1tensor(14),32)
call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(2),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
call G_TensorShift(G1tensor(20),16)
call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(5),mass5set(:,3),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
call G_TensorShift(G1tensor(26),32)
call Hotf_5pt_reduction_last(G2tensor(6),RedSet_5(8),mass5set(:,3),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
call G_TensorShift(G1tensor(32),16)
call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(9),mass5set(:,3),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
call G_TensorShift(G1tensor(38),32)
call Hotf_5pt_reduction_last(G2tensor(8),RedSet_5(10),mass5set(:,3),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
call G_TensorShift(G1tensor(44),16)
call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(3),mass5set(:,2),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
call G_TensorShift(G1tensor(50),16)
call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(4),mass5set(:,2),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
call G_TensorShift(G1tensor(56),32)
call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(6),mass5set(:,2),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
call G_TensorShift(G1tensor(62),16)
call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(7),mass5set(:,2),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
call G_TensorShift(G1tensor(68),32)
call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(11),mass5set(:,4),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
call G_TensorShift(G1tensor(74),8)
call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(12),mass5set(:,5),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
call G_TensorShift(G1tensor(80),4)
call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(13),mass5set(:,5),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
call G_TensorShift(G1tensor(86),8)
call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(14),mass5set(:,6),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
call G_TensorShift(G1tensor(92),32)
call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(15),mass5set(:,4),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
call G_TensorShift(G1tensor(98),8)
call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(16),mass5set(:,5),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
call G_TensorShift(G1tensor(104),4)
call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(17),mass5set(:,5),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
call G_TensorShift(G1tensor(110),8)
call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(18),mass5set(:,6),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
call G_TensorShift(G1tensor(116),32)
call ol_merge_tensors(T1sum(1),[G1tensor(1)])
call ol_merge_tensors(T1sum(2),[G1tensor(7)])
call ol_merge_tensors(T1sum(3),[G1tensor(13)])
call ol_merge_tensors(T1sum(4),[G1tensor(19)])
call ol_merge_tensors(T1sum(5),[G1tensor(25)])
call ol_merge_tensors(T1sum(6),[G1tensor(31)])
call ol_merge_tensors(T1sum(7),[G1tensor(37)])
call ol_merge_tensors(T1sum(8),[G1tensor(43)])
call ol_merge_tensors(T1sum(9),[G1tensor(49)])
call ol_merge_tensors(T1sum(10),[G1tensor(55)])
call ol_merge_tensors(T1sum(11),[G1tensor(61)])
call ol_merge_tensors(T1sum(12),[G1tensor(67)])
call ol_merge_tensors(T1sum(13),[G1tensor(73)])
call ol_merge_tensors(T1sum(14),[G1tensor(79)])
call ol_merge_tensors(T1sum(15),[G1tensor(85)])
call ol_merge_tensors(T1sum(16),[G1tensor(91)])
call ol_merge_tensors(T1sum(17),[G1tensor(97)])
call ol_merge_tensors(T1sum(18),[G1tensor(103)])
call ol_merge_tensors(T1sum(19),[G1tensor(109)])
call ol_merge_tensors(T1sum(20),[G1tensor(115)])
Gcoeff(:)%j = (c(14)*M(1,:)%j-c(11)*M(2,:)%j+c(10)*M(4,:)%j) * den(64)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(21),h0tab(:,21),[64,12,3,32,16],[nMB,nMB,nMB,0,nMB],5,2,wf4(:,2),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,21),heltab2x128(:,:,21))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(1),n2h64(13))
Gcoeff(:)%j = (c(14)*M(1,:)%j-c(11)*M(2,:)%j+c(10)*M(4,:)%j) * den(64)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(22),h0tab(:,22),[64,3,12,32,16],[nMB,nMB,nMB,0,nMB],5,2,wf4(:,4),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,22),heltab2x128(:,:,22))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(2),n2h64(14))
Gcoeff(:)%j = (c(14)*M(1,:)%j-c(11)*M(3,:)%j+c(10)*M(4,:)%j) * den(64)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(23),h0tab(:,23),[64,12,3,16,32],[nMB,nMB,nMB,0,nMB],5,2,wf4(:,2),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,23),heltab2x128(:,:,23))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(3),n2h64(15))
Gcoeff(:)%j = (c(14)*M(1,:)%j-c(11)*M(2,:)%j+c(10)*M(4,:)%j) * den(64)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(24),h0tab(:,24),[64,3,16,32,12],[nMB,nMB,0,nMB,nMB],5,2,wf4(:,4),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,24),heltab2x128(:,:,24))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(4),n2h64(16))
Gcoeff(:)%j = (c(14)*M(1,:)%j-c(11)*M(3,:)%j+c(10)*M(4,:)%j) * den(64)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(25),h0tab(:,25),[64,3,12,16,32],[nMB,nMB,nMB,0,nMB],5,2,wf4(:,4),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,25),heltab2x128(:,:,25))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(5),n2h64(17))
Gcoeff(:)%j = (c(14)*M(1,:)%j-c(11)*M(3,:)%j+c(10)*M(4,:)%j) * den(64)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(26),h0tab(:,26),[64,3,32,16,12],[nMB,nMB,0,nMB,nMB],5,2,wf4(:,4),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,26),heltab2x128(:,:,26))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(6),n2h64(18))
Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(64)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(27),h0tab(:,27),[64,16,3,12,32],[0,nMB,nMB,nMB,0],5,2,wf4(:,4),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(7),m3h2x64(:,27),heltab2x128(:,:,27))
Gcoeff(:)%j = (c(19)*M(2,:)%j+c(14)*(M(1,:)%j-M(4,:)%j)) * den(64)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(28),h0tab(:,28),[64,12,32,3,16],[0,0,nMB,nMB,0],5,2,wf4(:,2),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(8),m3h2x64(:,28),heltab2x128(:,:,28))
Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(64)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(29),h0tab(:,29),[64,16,12,3,32],[0,nMB,nMB,nMB,0],5,2,wf4(:,2),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(9),m3h2x64(:,29),heltab2x128(:,:,29))
Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(64)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(30),h0tab(:,30),[64,3,32,12,16],[nMB,nMB,0,0,nMB],5,2,wf4(:,4),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,30),heltab2x128(:,:,30))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(10),n2h64(19))
Gcoeff(:)%j = (c(19)*M(3,:)%j+c(14)*(M(1,:)%j-M(4,:)%j)) * den(64)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(31),h0tab(:,31),[64,12,16,3,32],[0,0,nMB,nMB,0],5,2,wf4(:,2),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(11),m3h2x64(:,31),heltab2x128(:,:,31))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(64)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(32),h0tab(:,32),[64,3,16,12,32],[nMB,nMB,0,0,nMB],5,2,wf4(:,4),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,32),heltab2x128(:,:,32))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(12),n2h64(20))
Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(3,:)%j+c(14)*M(4,:)%j) * den(66)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(33),h0tab(:,33),[64,4,8,3,48],[nMT,0,nMT,nMT,nMT],5,2,wf4(:,4),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,33),heltab2x128(:,:,33))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(13),n2h64(21))
Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(3,:)%j+c(14)*M(4,:)%j) * den(66)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(34),h0tab(:,34),[64,3,48,8,4],[nMT,nMT,nMT,0,nMT],5,2,wf4(:,4),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,34),heltab2x128(:,:,34))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(14),n2h64(22))
Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(2,:)%j+c(14)*M(4,:)%j) * den(66)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(35),h0tab(:,35),[64,8,4,3,48],[nMT,0,nMT,nMT,nMT],5,2,wf4(:,4),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,35),heltab2x128(:,:,35))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(15),n2h64(23))
Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(3,:)%j+c(14)*M(4,:)%j) * den(66)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(36),h0tab(:,36),[64,3,4,8,48],[nMT,nMT,0,nMT,nMT],5,2,wf4(:,4),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,36),heltab2x128(:,:,36))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(16),n2h64(24))
Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(2,:)%j+c(14)*M(4,:)%j) * den(66)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(37),h0tab(:,37),[64,3,48,4,8],[nMT,nMT,nMT,0,nMT],5,2,wf4(:,4),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,37),heltab2x128(:,:,37))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(17),n2h64(25))
Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(2,:)%j+c(14)*M(4,:)%j) * den(66)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(38),h0tab(:,38),[64,3,8,4,48],[nMT,nMT,0,nMT,nMT],5,2,wf4(:,4),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,38),heltab2x128(:,:,38))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(18),n2h64(26))
Gcoeff(:)%j = (c(4)*M(4,:)%j) * den(66)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(39),h0tab(:,39),[64,4,3,48,8],[0,nMT,nMT,nMT,0],5,2,wf4(:,4),wf4(:,9))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(19),m3h2x64(:,39),heltab2x128(:,:,39))
Gcoeff(:)%j = (c(19)*M(3,:)%j+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(66)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(40),h0tab(:,40),[64,4,3,8,48],[0,nMT,nMT,0,0],5,2,wf4(:,4),wf4(:,9))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(20),m3h2x64(:,40),heltab2x128(:,:,40))
Gcoeff(:)%j = (c(4)*M(4,:)%j) * den(66)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(41),h0tab(:,41),[64,4,48,3,8],[0,nMT,nMT,nMT,0],5,2,wf4(:,9),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(21),m3h2x64(:,41),heltab2x128(:,:,41))
Gcoeff(:)%j = (c(4)*M(4,:)%j) * den(66)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(42),h0tab(:,42),[64,3,8,48,4],[nMT,nMT,0,0,nMT],5,2,wf4(:,4),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,42),heltab2x128(:,:,42))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(22),n2h64(27))
Gcoeff(:)%j = (c(19)*M(2,:)%j+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(66)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(43),h0tab(:,43),[64,8,3,4,48],[0,nMT,nMT,0,0],5,2,wf4(:,4),wf4(:,9))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(23),m3h2x64(:,43),heltab2x128(:,:,43))
Gcoeff(:)%j = (-(c(4)*M(4,:)%j)) * den(66)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(44),h0tab(:,44),[64,3,4,48,8],[nMT,nMT,0,0,nMT],5,2,wf4(:,4),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,44),heltab2x128(:,:,44))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(24),n2h64(28))
Gcoeff(:)%j = (c(10)*M(1,:)%j+c(17)*M(3,:)%j) * den(33)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(45),h0tab(:,45),[68,3,8,16,32],[nMT,nMT,0,nMB,0],5,2,wf4(:,10),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,1),heltab2x128(:,:,45))
  call Hloop_Q_A(ntryL,G0H32(1),68,nMT,G1H32(5),n2h32(13))
Gcoeff(:)%j = (c(10)*M(1,:)%j+c(17)*M(3,:)%j) * den(33)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(46),h0tab(:,46),[68,8,16,3,32],[nMT,0,nMB,nMB,0],5,2,wf4(:,10),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,2),heltab2x128(:,:,46))
  call Hloop_Q_A(ntryL,G0H32(1),68,nMT,G1H32(1),n2h32(14))
Gcoeff(:)%j = (c(15)*M(1,:)%j-c(12)*M(3,:)%j) * den(33)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(47),h0tab(:,47),[68,3,8,32,16],[nMT,nMT,0,nMB,0],5,2,wf4(:,10),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,3),heltab2x128(:,:,47))
  call Hloop_Q_A(ntryL,G0H32(1),68,nMT,G1H32(6),n2h32(15))
Gcoeff(:)%j = (c(15)*M(1,:)%j-c(12)*M(3,:)%j) * den(33)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(48),h0tab(:,48),[68,8,32,3,16],[nMT,0,nMB,nMB,0],5,2,wf4(:,10),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,4),heltab2x128(:,:,48))
  call Hloop_Q_A(ntryL,G0H32(1),68,nMT,G1H32(7),n2h32(16))
Gcoeff(:)%j = (c(15)*M(1,:)%j-c(12)*M(2,:)%j) * den(42)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(49),h0tab(:,49),[72,3,4,16,32],[nMT,nMT,0,nMB,0],5,2,wf4(:,12),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,12),G0H32(1),m3h4x32(:,5),heltab2x128(:,:,49))
  call Hloop_A_Q(ntryL,G0H32(1),72,nMT,G1H32(8),n2h32(17))
Gcoeff(:)%j = (c(15)*M(1,:)%j-c(12)*M(2,:)%j) * den(42)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(50),h0tab(:,50),[72,4,16,3,32],[nMT,0,nMB,nMB,0],5,2,wf4(:,12),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,12),G0H32(1),m3h4x32(:,6),heltab2x128(:,:,50))
  call Hloop_A_Q(ntryL,G0H32(1),72,nMT,G1H32(3),n2h32(18))
Gcoeff(:)%j = (c(10)*M(1,:)%j+c(17)*M(2,:)%j) * den(42)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(51),h0tab(:,51),[72,3,4,32,16],[nMT,nMT,0,nMB,0],5,2,wf4(:,12),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,12),G0H32(1),m3h4x32(:,7),heltab2x128(:,:,51))
  call Hloop_A_Q(ntryL,G0H32(1),72,nMT,G1H32(4),n2h32(19))
Gcoeff(:)%j = (c(10)*M(1,:)%j+c(17)*M(2,:)%j) * den(42)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(52),h0tab(:,52),[72,4,32,3,16],[nMT,0,nMB,nMB,0],5,2,wf4(:,12),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,12),G0H32(1),m3h4x32(:,8),heltab2x128(:,:,52))
  call Hloop_A_Q(ntryL,G0H32(1),72,nMT,G1H32(10),n2h32(20))
Gcoeff(:)%j = (c(17)*M(2,:)%j+c(10)*M(4,:)%j) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(53),h0tab(:,53),[80,3,32,4,8],[nMB,nMB,0,nMT,0],5,2,wf4(:,5),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,5),G0H32(1),m3h4x32(:,9),heltab2x128(:,:,53))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(11),n2h32(21))
Gcoeff(:)%j = (-(c(12)*M(2,:)%j)+c(15)*M(4,:)%j) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(54),h0tab(:,54),[80,3,32,8,4],[nMB,nMB,0,nMT,0],5,2,wf4(:,5),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,5),G0H32(1),m3h4x32(:,10),heltab2x128(:,:,54))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(12),n2h32(22))
Gcoeff(:)%j = (c(17)*M(2,:)%j+c(10)*M(4,:)%j) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(55),h0tab(:,55),[80,8,3,4,32],[0,nMT,nMT,0,nMB],5,2,wf4(:,5),wf4(:,4))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,5),G0H32(1),m3h4x32(:,11),heltab2x128(:,:,55))
Gcoeff(:)%j = (-(c(12)*M(2,:)%j)+c(15)*M(4,:)%j) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(56),h0tab(:,56),[80,4,3,8,32],[0,nMT,nMT,0,nMB],5,2,wf4(:,5),wf4(:,4))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,5),G0H32(2),m3h4x32(:,12),heltab2x128(:,:,56))
Gcoeff(:)%j = (-(c(12)*M(3,:)%j)+c(15)*M(4,:)%j) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(57),h0tab(:,57),[96,3,16,4,8],[nMB,nMB,0,nMT,0],5,2,wf4(:,7),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,7),G0H32(3),m3h4x32(:,13),heltab2x128(:,:,57))
  call Hloop_A_Q(ntryL,G0H32(3),96,nMB,G1H32(13),n2h32(23))
Gcoeff(:)%j = (c(17)*M(3,:)%j+c(10)*M(4,:)%j) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(58),h0tab(:,58),[96,3,16,8,4],[nMB,nMB,0,nMT,0],5,2,wf4(:,7),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,7),G0H32(3),m3h4x32(:,14),heltab2x128(:,:,58))
  call Hloop_A_Q(ntryL,G0H32(3),96,nMB,G1H32(14),n2h32(24))
Gcoeff(:)%j = (-(c(12)*M(3,:)%j)+c(15)*M(4,:)%j) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(59),h0tab(:,59),[96,8,3,4,16],[0,nMT,nMT,0,nMB],5,2,wf4(:,7),wf4(:,4))
  call Hloop_QA_V(ntryL,G0H128(1),wf4(:,7),G0H32(3),m3h4x32(:,15),heltab2x128(:,:,59))
Gcoeff(:)%j = (c(17)*M(3,:)%j+c(10)*M(4,:)%j) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(60),h0tab(:,60),[96,4,3,8,16],[0,nMT,nMT,0,nMB],5,2,wf4(:,7),wf4(:,4))
  call Hloop_QA_V(ntryL,G0H128(1),wf4(:,7),G0H32(4),m3h4x32(:,16),heltab2x128(:,:,60))
Gcoeff(:)%j = (c(10)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)) * den(40)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(61),h0tab(:,61),[64,7,32,16,8],[nMT,0,nMB,0,nMT],5,1,wf8(:,15))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,45),heltab2x128(:,:,61))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(25),n2h64(29))
Gcoeff(:)%j = (-(c(3)*M(2,:)%j)-c(5)*M(3,:)%j) * den(40)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(62),h0tab(:,62),[64,7,8,16,32],[0,nMT,0,nMB,0],5,1,wf8(:,15))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(26),m3h2x64(:,46),heltab2x128(:,:,62))
Gcoeff(:)%j = (c(11)*(-M(2,:)%j-M(3,:)%j)+c(10)*M(4,:)%j) * den(40)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(63),h0tab(:,63),[64,16,8,7,32],[nMB,0,nMT,0,nMB],5,1,wf8(:,15))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,47),heltab2x128(:,:,63))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(27),n2h64(30))
Gcoeff(:)%j = (c(10)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)+c(14)*M(4,:)%j) * den(40)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(64),h0tab(:,64),[64,7,16,32,8],[nMT,0,nMB,0,nMT],5,1,wf8(:,15))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,48),heltab2x128(:,:,64))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(28),n2h64(31))
Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)+c(4)*(-M(1,:)%j+M(4,:)%j)) * den(40)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(65),h0tab(:,65),[64,7,8,32,16],[0,nMT,0,nMB,0],5,1,wf8(:,15))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(29),m3h2x64(:,49),heltab2x128(:,:,65))
Gcoeff(:)%j = (c(14)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)+c(10)*M(4,:)%j) * den(40)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(66),h0tab(:,66),[64,16,7,8,32],[nMB,0,nMT,0,nMB],5,1,wf8(:,15))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,50),heltab2x128(:,:,66))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(30),n2h64(32))
Gcoeff(:)%j = (c(5)*M(2,:)%j+c(3)*M(3,:)%j) * den(40)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(67),h0tab(:,67),[64,8,7,32,16],[0,nMT,0,nMB,0],5,1,wf8(:,15))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(31),m3h2x64(:,51),heltab2x128(:,:,67))
Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)+c(4)*(M(1,:)%j-M(4,:)%j)) * den(40)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(68),h0tab(:,68),[64,8,7,16,32],[0,nMT,0,nMB,0],5,1,wf8(:,15))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(32),m3h2x64(:,52),heltab2x128(:,:,68))
Gcoeff(:)%j = (c(10)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)+c(14)*M(4,:)%j) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(69),h0tab(:,69),[64,4,16,32,11],[nMT,0,nMB,0,nMT],5,1,wf8(:,11))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,53),heltab2x128(:,:,69))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(33),n2h64(33))
Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)+c(4)*(M(1,:)%j-M(4,:)%j)) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(70),h0tab(:,70),[64,11,4,16,32],[0,nMT,0,nMB,0],5,1,wf8(:,11))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(34),m3h2x64(:,54),heltab2x128(:,:,70))
Gcoeff(:)%j = (c(14)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)+c(10)*M(4,:)%j) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(71),h0tab(:,71),[64,16,4,11,32],[nMB,0,nMT,0,nMB],5,1,wf8(:,11))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,55),heltab2x128(:,:,71))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(35),n2h64(34))
Gcoeff(:)%j = (c(10)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(72),h0tab(:,72),[64,4,32,16,11],[nMT,0,nMB,0,nMT],5,1,wf8(:,11))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,56),heltab2x128(:,:,72))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(36),n2h64(35))
Gcoeff(:)%j = (c(5)*M(2,:)%j+c(3)*M(3,:)%j) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(73),h0tab(:,73),[64,11,4,32,16],[0,nMT,0,nMB,0],5,1,wf8(:,11))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(37),m3h2x64(:,57),heltab2x128(:,:,73))
Gcoeff(:)%j = (c(11)*(-M(2,:)%j-M(3,:)%j)+c(10)*M(4,:)%j) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(74),h0tab(:,74),[64,16,11,4,32],[nMB,0,nMT,0,nMB],5,1,wf8(:,11))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,58),heltab2x128(:,:,74))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(38),n2h64(36))
Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)+c(4)*(-M(1,:)%j+M(4,:)%j)) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(75),h0tab(:,75),[64,4,11,32,16],[0,nMT,0,nMB,0],5,1,wf8(:,11))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(39),m3h2x64(:,59),heltab2x128(:,:,75))
Gcoeff(:)%j = (-(c(3)*M(2,:)%j)-c(5)*M(3,:)%j) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(76),h0tab(:,76),[64,4,11,16,32],[0,nMT,0,nMB,0],5,1,wf8(:,11))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(40),m3h2x64(:,60),heltab2x128(:,:,76))
Gcoeff(:)%j = (c(5)*M(2,:)%j+c(3)*M(3,:)%j) * den(15)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(77),h0tab(:,77),[64,8,4,32,19],[0,nMT,0,nMB,0],5,1,wf8(:,6))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(41),m3h2x64(:,61),heltab2x128(:,:,77))
Gcoeff(:)%j = (c(11)*(-M(2,:)%j-M(3,:)%j)+c(10)*M(4,:)%j) * den(15)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(78),h0tab(:,78),[64,19,8,4,32],[nMB,0,nMT,0,nMB],5,1,wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,62),heltab2x128(:,:,78))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(42),n2h64(37))
Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)+c(4)*(-M(1,:)%j+M(4,:)%j)) * den(15)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(79),h0tab(:,79),[64,4,8,32,19],[0,nMT,0,nMB,0],5,1,wf8(:,6))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(43),m3h2x64(:,63),heltab2x128(:,:,79))
Gcoeff(:)%j = (-(c(3)*M(2,:)%j)-c(5)*M(3,:)%j) * den(15)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(80),h0tab(:,80),[64,4,8,19,32],[0,nMT,0,nMB,0],5,1,wf8(:,6))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(44),m3h2x64(:,64),heltab2x128(:,:,80))
Gcoeff(:)%j = (c(14)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)+c(10)*M(4,:)%j) * den(15)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(81),h0tab(:,81),[64,19,4,8,32],[nMB,0,nMT,0,nMB],5,1,wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,65),heltab2x128(:,:,81))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(45),n2h64(38))
Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)+c(4)*(M(1,:)%j-M(4,:)%j)) * den(15)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(82),h0tab(:,82),[64,8,4,19,32],[0,nMT,0,nMB,0],5,1,wf8(:,6))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(46),m3h2x64(:,66),heltab2x128(:,:,82))
Gcoeff(:)%j = (c(10)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)) * den(15)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(83),h0tab(:,83),[64,4,32,19,8],[nMT,0,nMB,0,nMT],5,1,wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,67),heltab2x128(:,:,83))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(47),n2h64(39))
Gcoeff(:)%j = (c(10)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)+c(14)*M(4,:)%j) * den(15)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(84),h0tab(:,84),[64,4,19,32,8],[nMT,0,nMB,0,nMT],5,1,wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,68),heltab2x128(:,:,84))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(48),n2h64(40))
Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)+c(4)*(M(1,:)%j-M(4,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(85),h0tab(:,85),[64,8,4,16,35],[0,nMT,0,nMB,0],5,1,wf8(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(49),m3h2x64(:,69),heltab2x128(:,:,85))
Gcoeff(:)%j = (c(14)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)+c(10)*M(4,:)%j) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(86),h0tab(:,86),[64,16,4,8,35],[nMB,0,nMT,0,nMB],5,1,wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,70),heltab2x128(:,:,86))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(50),n2h64(41))
Gcoeff(:)%j = (-(c(3)*M(2,:)%j)-c(5)*M(3,:)%j) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(87),h0tab(:,87),[64,4,8,16,35],[0,nMT,0,nMB,0],5,1,wf8(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(51),m3h2x64(:,71),heltab2x128(:,:,87))
Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)+c(4)*(-M(1,:)%j+M(4,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(88),h0tab(:,88),[64,4,8,35,16],[0,nMT,0,nMB,0],5,1,wf8(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(52),m3h2x64(:,72),heltab2x128(:,:,88))
Gcoeff(:)%j = (c(11)*(-M(2,:)%j-M(3,:)%j)+c(10)*M(4,:)%j) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(89),h0tab(:,89),[64,16,8,4,35],[nMB,0,nMT,0,nMB],5,1,wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,73),heltab2x128(:,:,89))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(53),n2h64(42))
Gcoeff(:)%j = (c(5)*M(2,:)%j+c(3)*M(3,:)%j) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(90),h0tab(:,90),[64,8,4,35,16],[0,nMT,0,nMB,0],5,1,wf8(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(54),m3h2x64(:,74),heltab2x128(:,:,90))
Gcoeff(:)%j = (c(10)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)+c(14)*M(4,:)%j) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(91),h0tab(:,91),[64,4,16,35,8],[nMT,0,nMB,0,nMT],5,1,wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,75),heltab2x128(:,:,91))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(55),n2h64(43))
Gcoeff(:)%j = (c(10)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(92),h0tab(:,92),[64,4,35,16,8],[nMT,0,nMB,0,nMT],5,1,wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,76),heltab2x128(:,:,92))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(56),n2h64(44))
  call ol_merge(ntryL,G1H32(8),[G1H32(2)])
  call ol_merge(ntryL,G1H32(4),[G1H32(9)])
  call ol_merge(ntryL,G1H32(5),[G1H32(15)])
  call ol_merge(ntryL,G1H32(6),[G1H32(21)])
  call Hloop_AZ_Q(ntryL,G1H32(8),wf4(:,4),G1H8(12),ngZu,m3h4x8(:,17),heltab2x32(:,:,29))
  call Hloop_A_Q(ntryL,G1H8(12),75,nMT,G2H8(21),n2h8(45))
  call Hloop_AZ_Q(ntryL,G1H32(4),wf4(:,4),G1H8(32),ngZu,m3h4x8(:,18),heltab2x32(:,:,30))
  call Hloop_A_Q(ntryL,G1H8(32),75,nMT,G2H8(23),n2h8(46))
  call Hloop_QZ_A(ntryL,G1H32(5),wf4(:,4),G1H8(50),ngZu,m3h4x8(:,19),heltab2x32(:,:,31))
  call Hloop_Q_A(ntryL,G1H8(50),71,nMT,G2H8(2),n2h8(47))
  call Hloop_QZ_A(ntryL,G1H32(6),wf4(:,4),G1H8(62),ngZu,m3h4x8(:,20),heltab2x32(:,:,32))
  call Hloop_Q_A(ntryL,G1H8(62),71,nMT,G2H8(6),n2h8(48))
  call Hloop_QV_A(ntryL,G1H64(1),wf4(:,2),G1H16(5),m3h4x16(:,9),heltab2x64(:,:,21))
  call Hloop_Q_A(ntryL,G1H16(5),76,nMB,G2H16(4),n2h16(21))
  call Hloop_QZ_A(ntryL,G1H64(2),wf4(:,4),G1H16(6),ngZd,m3h4x16(:,10),heltab2x64(:,:,22))
  call Hloop_Q_A(ntryL,G1H16(6),67,nMB,G2H16(9),n2h16(22))
  call Hloop_AV_Q(ntryL,G1H64(3),wf4(:,2),G1H16(9),m3h4x16(:,11),heltab2x64(:,:,23))
  call Hloop_A_Q(ntryL,G1H16(9),76,nMB,G2H16(5),n2h16(23))
  call Hloop_AZ_Q(ntryL,G1H64(4),wf4(:,4),G1H16(10),ngZd,m3h4x16(:,12),heltab2x64(:,:,24))
  call Hloop_A_Q(ntryL,G1H16(10),67,nMB,G2H16(6),n2h16(24))
  call Hloop_AZ_Q(ntryL,G1H64(5),wf4(:,4),G1H16(11),ngZd,m3h4x16(:,13),heltab2x64(:,:,25))
  call Hloop_A_Q(ntryL,G1H16(11),67,nMB,G2H16(7),n2h16(25))
  call Hloop_QZ_A(ntryL,G1H64(6),wf4(:,4),G1H16(12),ngZd,m3h4x16(:,14),heltab2x64(:,:,26))
  call Hloop_Q_A(ntryL,G1H16(12),67,nMB,G2H16(8),n2h16(26))
  call Hloop_VQ_A(ntryL,G1H64(7),ex5(:),G1H32(16),m3h2x32(:,13),heltab2x64(:,:,27))
  call Hloop_Q_A(ntryL,G1H32(16),80,nMB,G2H32(1),n2h32(25))
  call Hloop_UV_W(ntryL,G1H64(8),64,wf4(:,2),12,G2H16(1),m3h4x16(:,15),heltab2x64(:,:,28))
  call Hloop_VQ_A(ntryL,G1H64(9),ex5(:),G1H32(17),m3h2x32(:,14),heltab2x64(:,:,29))
  call Hloop_Q_A(ntryL,G1H32(17),80,nMB,G2H32(2),n2h32(26))
  call Hloop_QZ_A(ntryL,G1H64(10),wf4(:,4),G1H16(15),ngZd,m3h4x16(:,16),heltab2x64(:,:,30))
  call Hloop_Q_A(ntryL,G1H16(15),67,nMB,G2H16(2),n2h16(27))
  call Hloop_UV_W(ntryL,G1H64(11),64,wf4(:,2),12,G2H16(3),m3h4x16(:,17),heltab2x64(:,:,31))
  call Hloop_AZ_Q(ntryL,G1H64(12),wf4(:,4),G1H16(16),ngZd,m3h4x16(:,18),heltab2x64(:,:,32))
  call Hloop_A_Q(ntryL,G1H16(16),67,nMB,G2H16(10),n2h16(28))
  call Hloop_AQ_V(ntryL,G1H64(13),ex3(:),G1H32(18),m3h2x32(:,15),heltab2x64(:,:,33))
  call Hloop_QZ_A(ntryL,G1H64(14),wf4(:,4),G1H16(17),ngZu,m3h4x16(:,19),heltab2x64(:,:,34))
  call Hloop_Q_A(ntryL,G1H16(17),67,nMT,G2H16(11),n2h16(29))
  call Hloop_QA_V(ntryL,G1H64(15),ex4(:),G1H32(19),m3h2x32(:,16),heltab2x64(:,:,35))
  call Hloop_AZ_Q(ntryL,G1H64(16),wf4(:,4),G1H16(18),ngZu,m3h4x16(:,20),heltab2x64(:,:,36))
  call Hloop_A_Q(ntryL,G1H16(18),67,nMT,G2H16(12),n2h16(30))
  call Hloop_AZ_Q(ntryL,G1H64(17),wf4(:,4),G1H16(21),ngZu,m3h4x16(:,21),heltab2x64(:,:,37))
  call Hloop_A_Q(ntryL,G1H16(21),67,nMT,G2H16(13),n2h16(31))
  call Hloop_QZ_A(ntryL,G1H64(18),wf4(:,4),G1H16(22),ngZu,m3h4x16(:,22),heltab2x64(:,:,38))
  call Hloop_Q_A(ntryL,G1H16(22),67,nMT,G2H16(14),n2h16(32))
  call Hloop_VQ_A(ntryL,G1H64(19),ex3(:),G1H32(20),m3h2x32(:,17),heltab2x64(:,:,39))
  call Hloop_Q_A(ntryL,G1H32(20),68,nMT,G2H32(3),n2h32(27))
  call Hloop_VQ_A(ntryL,G1H64(20),ex3(:),G1H32(22),m3h2x32(:,18),heltab2x64(:,:,40))
  call Hloop_Q_A(ntryL,G1H32(22),68,nMT,G2H32(4),n2h32(28))
  call Hloop_VQ_A(ntryL,G1H64(21),ex3(:),G1H32(23),m3h2x32(:,19),heltab2x64(:,:,41))
  call Hloop_Q_A(ntryL,G1H32(23),68,nMT,G2H32(5),n2h32(29))
  call Hloop_QZ_A(ntryL,G1H64(22),wf4(:,4),G1H16(23),ngZu,m3h4x16(:,23),heltab2x64(:,:,42))
  call Hloop_Q_A(ntryL,G1H16(23),67,nMT,G2H16(15),n2h16(33))
  call Hloop_VA_Q(ntryL,G1H64(23),ex4(:),G1H32(24),m3h2x32(:,20),heltab2x64(:,:,43))
  call Hloop_A_Q(ntryL,G1H32(24),72,nMT,G2H32(6),n2h32(30))
  call Hloop_AZ_Q(ntryL,G1H64(24),wf4(:,4),G1H16(24),ngZu,m3h4x16(:,24),heltab2x64(:,:,44))
  call Hloop_A_Q(ntryL,G1H16(24),67,nMT,G2H16(16),n2h16(34))
  call Hloop_QA_V(ntryL,G1H32(1),ex4(:),G1H16(27),m3h2x16(:,13),heltab2x32(:,:,33))
  call Hloop_QA_V(ntryL,G1H32(7),ex4(:),G1H16(28),m3h2x16(:,14),heltab2x32(:,:,34))
  call Hloop_AQ_V(ntryL,G1H32(3),ex3(:),G1H16(29),m3h2x16(:,15),heltab2x32(:,:,35))
  call Hloop_AQ_V(ntryL,G1H32(10),ex3(:),G1H16(30),m3h2x16(:,16),heltab2x32(:,:,36))
  call Hloop_QZ_A(ntryL,G1H32(11),wf4(:,4),G1H8(20),ngZd,m3h4x8(:,21),heltab2x32(:,:,37))
  call Hloop_Q_A(ntryL,G1H8(20),83,nMB,G2H8(3),n2h8(49))
  call Hloop_QZ_A(ntryL,G1H32(12),wf4(:,4),G1H8(23),ngZd,m3h4x8(:,22),heltab2x32(:,:,38))
  call Hloop_Q_A(ntryL,G1H8(23),83,nMB,G2H8(5),n2h8(50))
  call Hloop_VA_Q(ntryL,G0H32(1),ex4(:),G0H16(1),m3h2x16(:,17),heltab2x32(:,:,39))
  call Hloop_A_Q(ntryL,G0H16(1),88,nMT,G1H16(33),n2h16(35))
  call Hloop_VQ_A(ntryL,G0H32(2),ex3(:),G0H16(1),m3h2x16(:,18),heltab2x32(:,:,40))
  call Hloop_Q_A(ntryL,G0H16(1),84,nMT,G1H16(34),n2h16(36))
  call Hloop_AZ_Q(ntryL,G1H32(13),wf4(:,4),G1H8(1),ngZd,m3h4x8(:,23),heltab2x32(:,:,41))
  call Hloop_A_Q(ntryL,G1H8(1),99,nMB,G2H8(8),n2h8(51))
  call Hloop_AZ_Q(ntryL,G1H32(14),wf4(:,4),G1H8(6),ngZd,m3h4x8(:,24),heltab2x32(:,:,42))
  call Hloop_A_Q(ntryL,G1H8(6),99,nMB,G2H8(11),n2h8(52))
  call Hloop_VA_Q(ntryL,G0H32(3),ex4(:),G0H16(1),m3h2x16(:,19),heltab2x32(:,:,43))
  call Hloop_A_Q(ntryL,G0H16(1),104,nMT,G1H16(35),n2h16(37))
  call Hloop_VQ_A(ntryL,G0H32(4),ex3(:),G0H16(1),m3h2x16(:,20),heltab2x32(:,:,44))
  call Hloop_Q_A(ntryL,G0H16(1),100,nMT,G1H16(36),n2h16(38))
  call Hloop_AQ_V(ntryL,G1H64(25),wf8(:,15),G1H8(19),m3h8x8(:,1),heltab2x64(:,:,45))
  call Hloop_VQ_A(ntryL,G1H64(26),wf8(:,15),G1H8(25),m3h8x8(:,2),heltab2x64(:,:,46))
  call Hloop_Q_A(ntryL,G1H8(25),71,nMT,G2H8(12),n2h8(53))
  call Hloop_AQ_V(ntryL,G1H64(27),ex5(:),G1H32(2),m3h2x32(:,21),heltab2x64(:,:,47))
  call Hloop_AQ_V(ntryL,G1H64(28),wf8(:,15),G1H8(26),m3h8x8(:,3),heltab2x64(:,:,48))
  call Hloop_VQ_A(ntryL,G1H64(29),wf8(:,15),G1H8(35),m3h8x8(:,4),heltab2x64(:,:,49))
  call Hloop_Q_A(ntryL,G1H8(35),71,nMT,G2H8(15),n2h8(54))
  call Hloop_AQ_V(ntryL,G1H64(30),ex5(:),G1H32(9),m3h2x32(:,22),heltab2x64(:,:,50))
  call Hloop_VA_Q(ntryL,G1H64(31),ex4(:),G1H32(15),m3h2x32(:,23),heltab2x64(:,:,51))
  call Hloop_A_Q(ntryL,G1H32(15),72,nMT,G2H32(7),n2h32(31))
  call Hloop_VA_Q(ntryL,G1H64(32),ex4(:),G1H32(21),m3h2x32(:,24),heltab2x64(:,:,52))
  call Hloop_A_Q(ntryL,G1H32(21),72,nMT,G2H32(8),n2h32(32))
  call Hloop_AQ_V(ntryL,G1H64(33),ex3(:),G1H32(8),m3h2x32(:,25),heltab2x64(:,:,53))
  call Hloop_VA_Q(ntryL,G1H64(34),wf8(:,11),G1H8(36),m3h8x8(:,5),heltab2x64(:,:,54))
  call Hloop_A_Q(ntryL,G1H8(36),75,nMT,G2H8(16),n2h8(55))
  call Hloop_AQ_V(ntryL,G1H64(35),ex5(:),G1H32(4),m3h2x32(:,26),heltab2x64(:,:,55))
  call Hloop_AQ_V(ntryL,G1H64(36),ex3(:),G1H32(5),m3h2x32(:,27),heltab2x64(:,:,56))
  call Hloop_VA_Q(ntryL,G1H64(37),wf8(:,11),G1H8(42),m3h8x8(:,6),heltab2x64(:,:,57))
  call Hloop_A_Q(ntryL,G1H8(42),75,nMT,G2H8(19),n2h8(56))
  call Hloop_AQ_V(ntryL,G1H64(38),ex5(:),G1H32(6),m3h2x32(:,28),heltab2x64(:,:,58))
  call Hloop_VQ_A(ntryL,G1H64(39),ex3(:),G1H32(16),m3h2x32(:,29),heltab2x64(:,:,59))
  call Hloop_Q_A(ntryL,G1H32(16),68,nMT,G2H32(9),n2h32(33))
  call Hloop_VQ_A(ntryL,G1H64(40),ex3(:),G1H32(17),m3h2x32(:,30),heltab2x64(:,:,60))
  call Hloop_Q_A(ntryL,G1H32(17),68,nMT,G2H32(10),n2h32(34))
  call Hloop_VA_Q(ntryL,G1H64(41),ex4(:),G1H32(20),m3h2x32(:,31),heltab2x64(:,:,61))
  call Hloop_A_Q(ntryL,G1H32(20),72,nMT,G2H32(11),n2h32(35))
  call Hloop_AQ_V(ntryL,G1H64(42),wf8(:,6),G1H8(43),m3h8x8(:,7),heltab2x64(:,:,62))
  call Hloop_VQ_A(ntryL,G1H64(43),ex3(:),G1H32(22),m3h2x32(:,32),heltab2x64(:,:,63))
  call Hloop_Q_A(ntryL,G1H32(22),68,nMT,G2H32(12),n2h32(36))
  call Hloop_VQ_A(ntryL,G1H64(44),ex3(:),G1H32(23),m3h2x32(:,33),heltab2x64(:,:,64))
  call Hloop_Q_A(ntryL,G1H32(23),68,nMT,G2H32(13),n2h32(37))
  call Hloop_AQ_V(ntryL,G1H64(45),wf8(:,6),G1H8(44),m3h8x8(:,8),heltab2x64(:,:,65))
  call Hloop_VA_Q(ntryL,G1H64(46),ex4(:),G1H32(24),m3h2x32(:,34),heltab2x64(:,:,66))
  call Hloop_A_Q(ntryL,G1H32(24),72,nMT,G2H32(14),n2h32(38))
  call Hloop_AQ_V(ntryL,G1H64(47),ex3(:),G1H32(1),m3h2x32(:,35),heltab2x64(:,:,67))
  call Hloop_AQ_V(ntryL,G1H64(48),ex3(:),G1H32(7),m3h2x32(:,36),heltab2x64(:,:,68))
  call Hloop_VA_Q(ntryL,G1H64(49),ex4(:),G1H32(3),m3h2x32(:,37),heltab2x64(:,:,69))
  call Hloop_A_Q(ntryL,G1H32(3),72,nMT,G2H32(15),n2h32(39))
  call Hloop_AQ_V(ntryL,G1H64(50),ex5(:),G1H32(10),m3h2x32(:,38),heltab2x64(:,:,70))
  call Hloop_VQ_A(ntryL,G1H64(51),ex3(:),G1H32(11),m3h2x32(:,39),heltab2x64(:,:,71))
  call Hloop_Q_A(ntryL,G1H32(11),68,nMT,G2H32(16),n2h32(40))
  call Hloop_VQ_A(ntryL,G1H64(52),ex3(:),G1H32(12),m3h2x32(:,40),heltab2x64(:,:,72))
  call Hloop_Q_A(ntryL,G1H32(12),68,nMT,G2H32(17),n2h32(41))
  call Hloop_AQ_V(ntryL,G1H64(53),ex5(:),G1H32(13),m3h2x32(:,41),heltab2x64(:,:,73))
  call Hloop_VA_Q(ntryL,G1H64(54),ex4(:),G1H32(14),m3h2x32(:,42),heltab2x64(:,:,74))
  call Hloop_A_Q(ntryL,G1H32(14),72,nMT,G2H32(18),n2h32(42))
  call Hloop_AQ_V(ntryL,G1H64(55),ex3(:),G1H32(15),m3h2x32(:,43),heltab2x64(:,:,75))
  call Hloop_AQ_V(ntryL,G1H64(56),ex3(:),G1H32(21),m3h2x32(:,44),heltab2x64(:,:,76))
call HGT_w2_OLR(G1H16(1),1,1,16)
call HGT_w2_invQ_OLR(G1H16(1),2,5,16)
  call ol_merge(ntryL,G1H16(1),[G1H16(35)])
  call ol_merge(ntryL,G2H8(16),[G2H8(10)])
  call ol_merge(ntryL,G1H16(33),[G1H16(49)])
call HGT_w2_OLR(G1H16(2),1,1,16)
call HGT_w2_invQ_OLR(G1H16(2),2,5,16)
  call ol_merge(ntryL,G1H16(2),[G1H16(33)])
  call ol_merge(ntryL,G2H8(19),[G2H8(14)])
call HGT_w2_OLR(G1H16(3),1,1,16)
call HGT_w2_invQ_OLR(G1H16(3),2,5,16)
  call ol_merge(ntryL,G1H16(3),[G1H16(36)])
  call ol_merge(ntryL,G2H8(12),[G2H8(18)])
  call ol_merge(ntryL,G1H16(34),[G1H16(37)])
call HGT_w2_OLR(G1H16(4),1,1,16)
call HGT_w2_invQ_OLR(G1H16(4),2,5,16)
  call ol_merge(ntryL,G1H16(4),[G1H16(34)])
  call ol_merge(ntryL,G2H8(15),[G2H8(22)])
  call ol_merge(ntryL,G1H8(44),[G1H8(10)])
  call ol_merge(ntryL,G1H16(29),[G1H16(7)])
  call ol_merge(ntryL,G2H16(3),[G1H16(20),G1H16(8)])
  call ol_merge(ntryL,G1H8(43),[G1H8(22)])
  call ol_merge(ntryL,G1H16(30),[G1H16(13)])
  call ol_merge(ntryL,G2H16(1),[G1H16(26),G1H16(14)])
  call ol_merge(ntryL,G1H16(27),[G1H16(19)])
  call ol_merge(ntryL,G1H16(28),[G1H16(25)])
  call ol_merge(ntryL,G1H8(26),[G1H8(34)])
  call ol_merge(ntryL,G1H8(19),[G1H8(46)])
  call Hloop_AZ_Q(ntryL,G1H16(1),wf4(:,4),G1H4(12),ngZu,m3h4x4(:,13),heltab2x16(:,:,41))
  call Hloop_A_Q(ntryL,G1H4(12),107,nMT,G2H4(1),n2h4(45))
  call Hloop_AQ_V(ntryL,G2H8(16),ex3(:),G2H4(3),m3h2x4(:,53),heltab2x8(:,:,65))
  call Hloop_AZ_Q(ntryL,G1H16(2),wf4(:,4),G1H4(13),ngZu,m3h4x4(:,14),heltab2x16(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(13),91,nMT,G2H4(4),n2h4(46))
  call Hloop_AQ_V(ntryL,G2H8(19),ex3(:),G2H4(6),m3h2x4(:,54),heltab2x8(:,:,66))
  call Hloop_QZ_A(ntryL,G1H16(3),wf4(:,4),G1H4(14),ngZu,m3h4x4(:,15),heltab2x16(:,:,43))
  call Hloop_Q_A(ntryL,G1H4(14),103,nMT,G2H4(7),n2h4(47))
  call Hloop_QA_V(ntryL,G2H8(12),ex4(:),G2H4(9),m3h2x4(:,55),heltab2x8(:,:,67))
  call Hloop_QZ_A(ntryL,G1H16(4),wf4(:,4),G1H4(19),ngZu,m3h4x4(:,16),heltab2x16(:,:,44))
  call Hloop_Q_A(ntryL,G1H4(19),87,nMT,G2H4(10),n2h4(48))
  call Hloop_QA_V(ntryL,G2H8(15),ex4(:),G2H4(12),m3h2x4(:,56),heltab2x8(:,:,68))
  call Hloop_VA_Q(ntryL,G1H8(3),ex4(:),G1H4(20),m3h2x4(:,57),heltab2x8(:,:,69))
  call Hloop_A_Q(ntryL,G1H4(20),107,nMT,G2H4(13),n2h4(49))
  call Hloop_VA_Q(ntryL,G1H8(4),ex4(:),G1H4(24),m3h2x4(:,58),heltab2x8(:,:,70))
  call Hloop_A_Q(ntryL,G1H4(24),107,nMT,G2H4(16),n2h4(50))
  call Hloop_VQ_A(ntryL,G1H8(9),ex3(:),G1H4(25),m3h2x4(:,59),heltab2x8(:,:,71))
  call Hloop_Q_A(ntryL,G1H4(25),87,nMT,G2H4(17),n2h4(51))
  call Hloop_VQ_A(ntryL,G1H8(44),ex3(:),G1H4(26),m3h2x4(:,60),heltab2x8(:,:,72))
  call Hloop_Q_A(ntryL,G1H4(26),87,nMT,G2H4(20),n2h4(52))
  call Hloop_VQ_A(ntryL,G1H16(29),ex5(:),G1H8(51),m3h2x8(:,29),heltab2x16(:,:,45))
  call Hloop_Q_A(ntryL,G1H8(51),92,nMB,G2H8(10),n2h8(57))
call Hotf_5pt_reduction(G2H16(3),RedSet_5(27),mass5set(:,8),  & 
G1H16(39),G1H16(40),G1H16(41),G1H16(42),G1H16(45),G1H16(46),16)
call HG1shiftOLR(G1H16(40),32,16)
  call Hloop_VQ_A(ntryL,G1H8(15),ex3(:),G1H4(31),m3h2x4(:,61),heltab2x8(:,:,73))
  call Hloop_Q_A(ntryL,G1H4(31),103,nMT,G2H4(21),n2h4(53))
  call Hloop_VQ_A(ntryL,G1H8(16),ex3(:),G1H4(32),m3h2x4(:,62),heltab2x8(:,:,74))
  call Hloop_Q_A(ntryL,G1H4(32),103,nMT,G2H4(24),n2h4(54))
  call Hloop_VA_Q(ntryL,G1H8(21),ex4(:),G1H4(36),m3h2x4(:,63),heltab2x8(:,:,75))
  call Hloop_A_Q(ntryL,G1H4(36),91,nMT,G2H4(25),n2h4(55))
  call Hloop_VA_Q(ntryL,G1H8(43),ex4(:),G1H4(37),m3h2x4(:,64),heltab2x8(:,:,76))
  call Hloop_A_Q(ntryL,G1H4(37),91,nMT,G2H4(28),n2h4(56))
  call Hloop_VA_Q(ntryL,G1H16(30),ex6(:),G1H8(52),m3h2x8(:,30),heltab2x16(:,:,46))
  call Hloop_A_Q(ntryL,G1H8(52),108,nMB,G2H8(14),n2h8(58))
call Hotf_5pt_reduction(G2H16(1),RedSet_5(28),mass5set(:,8),  & 
G1H16(47),G1H16(48),G1H16(51),G1H16(52),G1H16(5),G1H16(6),16)
call HG1shiftOLR(G1H16(48),16,16)
  call Hloop_VQ_A(ntryL,G1H16(27),ex5(:),G1H8(56),m3h2x8(:,31),heltab2x16(:,:,47))
  call Hloop_Q_A(ntryL,G1H8(56),92,nMB,G2H8(18),n2h8(59))
  call Hloop_VA_Q(ntryL,G1H16(28),ex6(:),G1H8(57),m3h2x8(:,32),heltab2x16(:,:,48))
  call Hloop_A_Q(ntryL,G1H8(57),108,nMB,G2H8(22),n2h8(60))
  call Hloop_QZ_A(ntryL,G1H16(31),wf4(:,4),G1H4(38),ngZd,m3h4x4(:,17),heltab2x16(:,:,49))
  call Hloop_Q_A(ntryL,G1H4(38),87,nMB,G2H4(29),n2h4(57))
  call Hloop_QZ_A(ntryL,G1H16(32),wf4(:,4),G1H4(43),ngZd,m3h4x4(:,18),heltab2x16(:,:,50))
  call Hloop_Q_A(ntryL,G1H4(43),87,nMB,G2H4(31),n2h4(58))
  call Hloop_VA_Q(ntryL,G1H8(27),ex6(:),G1H4(44),m3h2x4(:,65),heltab2x8(:,:,77))
  call Hloop_A_Q(ntryL,G1H4(44),107,nMB,G2H4(32),n2h4(59))
  call Hloop_VA_Q(ntryL,G1H8(28),ex6(:),G1H4(48),m3h2x4(:,66),heltab2x8(:,:,78))
  call Hloop_A_Q(ntryL,G1H4(48),107,nMB,G2H4(35),n2h4(60))
  call Hloop_VQ_A(ntryL,G1H8(33),ex5(:),G1H4(12),m3h2x4(:,67),heltab2x8(:,:,79))
  call Hloop_Q_A(ntryL,G1H4(12),87,nMB,G2H4(36),n2h4(61))
  call Hloop_VQ_A(ntryL,G1H8(26),ex5(:),G1H4(13),m3h2x4(:,68),heltab2x8(:,:,80))
  call Hloop_Q_A(ntryL,G1H4(13),87,nMB,G2H4(39),n2h4(62))
  call Hloop_QZ_A(ntryL,G1H16(38),wf4(:,4),G1H4(14),ngZu,m3h4x4(:,19),heltab2x16(:,:,51))
  call Hloop_Q_A(ntryL,G1H4(14),87,nMT,G2H4(40),n2h4(63))
  call Hloop_AZ_Q(ntryL,G1H16(43),wf4(:,4),G1H4(19),ngZd,m3h4x4(:,20),heltab2x16(:,:,52))
  call Hloop_A_Q(ntryL,G1H4(19),103,nMB,G2H4(42),n2h4(64))
  call Hloop_AZ_Q(ntryL,G1H16(44),wf4(:,4),G1H4(20),ngZd,m3h4x4(:,21),heltab2x16(:,:,53))
  call Hloop_A_Q(ntryL,G1H4(20),103,nMB,G2H4(43),n2h4(65))
  call Hloop_VQ_A(ntryL,G1H8(39),ex5(:),G1H4(24),m3h2x4(:,69),heltab2x8(:,:,81))
  call Hloop_Q_A(ntryL,G1H4(24),91,nMB,G2H4(45),n2h4(66))
  call Hloop_VQ_A(ntryL,G1H8(40),ex5(:),G1H4(25),m3h2x4(:,70),heltab2x8(:,:,82))
  call Hloop_Q_A(ntryL,G1H4(25),91,nMB,G2H4(46),n2h4(67))
  call Hloop_VA_Q(ntryL,G1H8(45),ex6(:),G1H4(26),m3h2x4(:,71),heltab2x8(:,:,83))
  call Hloop_A_Q(ntryL,G1H4(26),103,nMB,G2H4(49),n2h4(68))
  call Hloop_VA_Q(ntryL,G1H8(19),ex6(:),G1H4(31),m3h2x4(:,72),heltab2x8(:,:,84))
  call Hloop_A_Q(ntryL,G1H4(31),103,nMB,G2H4(50),n2h4(69))
  call Hloop_AZ_Q(ntryL,G1H16(50),wf4(:,4),G1H4(32),ngZu,m3h4x4(:,22),heltab2x16(:,:,54))
  call Hloop_A_Q(ntryL,G1H4(32),91,nMT,G2H4(53),n2h4(70))
  call Hloop_AQ_V(ntryL,G2H8(21),ex3(:),G2H4(54),m3h2x4(:,73),heltab2x8(:,:,85))
  call Hloop_AQ_V(ntryL,G2H8(23),ex3(:),G2H4(56),m3h2x4(:,74),heltab2x8(:,:,86))
  call Hloop_QA_V(ntryL,G2H8(2),ex4(:),G2H4(57),m3h2x4(:,75),heltab2x8(:,:,87))
  call Hloop_QA_V(ntryL,G2H8(6),ex4(:),G2H4(58),m3h2x4(:,76),heltab2x8(:,:,88))
call Hotf_5pt_reduction(G2H16(4),RedSet_5(29),mass5set(:,9),  & 
G1H16(9),G1H16(10),G1H16(11),G1H16(12),G1H16(15),G1H16(16),16)
call HG1shiftOLR(G1H16(10),16,16)
call Hotf_5pt_reduction(G2H16(9),RedSet_5(30),mass5set(:,9),  & 
G1H16(17),G1H16(18),G1H16(21),G1H16(22),G1H16(23),G1H16(24),16)
call HG1shiftOLR(G1H16(18),16,16)
call Hotf_5pt_reduction(G2H16(5),RedSet_5(31),mass5set(:,9),  & 
G1H16(35),G1H16(49),G1H16(33),G1H16(36),G1H16(37),G1H16(34),16)
call HG1shiftOLR(G1H16(49),32,16)
  call Hloop_AQ_V(ntryL,G2H16(6),ex5(:),G2H8(16),m3h2x8(:,33),heltab2x16(:,:,55))
call Hotf_5pt_reduction(G2H16(7),RedSet_5(32),mass5set(:,9),  & 
G1H16(7),G1H16(20),G1H16(8),G1H16(13),G1H16(26),G1H16(14),16)
call HG1shiftOLR(G1H16(20),32,16)
  call Hloop_QA_V(ntryL,G2H16(8),ex6(:),G2H8(19),m3h2x8(:,34),heltab2x16(:,:,56))
call Hotf_5pt_reduction(G2H32(1),RedSet_5(33),mass5set(:,10),  & 
G1H32(16),G1H32(17),G1H32(20),G1H32(22),G1H32(23),G1H32(24),32)
call HG1shiftOLR(G1H32(17),32,32)
call Hotf_5pt_reduction(G2H32(2),RedSet_5(34),mass5set(:,10),  & 
G1H32(3),G1H32(11),G1H32(12),G1H32(14),G1H32(25),G1H32(26),32)
call HG1shiftOLR(G1H32(11),32,32)
  call Hloop_QA_V(ntryL,G2H16(2),ex6(:),G2H8(12),m3h2x8(:,35),heltab2x16(:,:,57))
  call Hloop_AQ_V(ntryL,G2H16(10),ex5(:),G2H8(15),m3h2x8(:,36),heltab2x16(:,:,58))
  call Hloop_VA_Q(ntryL,G1H32(18),ex4(:),G1H16(19),m3h2x16(:,21),heltab2x32(:,:,45))
  call Hloop_A_Q(ntryL,G1H16(19),76,nMT,G2H16(3),n2h16(39))
call Hotf_5pt_reduction(G2H16(11),RedSet_5(35),mass5set(:,11),  & 
G1H16(25),G1H16(1),G1H16(2),G1H16(3),G1H16(4),G1H16(29),16)
call HG1shiftOLR(G1H16(1),4,16)
  call Hloop_VQ_A(ntryL,G1H32(19),ex3(:),G1H16(30),m3h2x16(:,22),heltab2x32(:,:,46))
  call Hloop_Q_A(ntryL,G1H16(30),76,nMT,G2H16(1),n2h16(40))
  call Hloop_AQ_V(ntryL,G2H16(12),ex3(:),G2H8(21),m3h2x8(:,37),heltab2x16(:,:,59))
call Hotf_5pt_reduction(G2H16(13),RedSet_5(36),mass5set(:,11),  & 
G1H16(27),G1H16(28),G1H16(31),G1H16(32),G1H16(38),G1H16(43),16)
call HG1shiftOLR(G1H16(28),8,16)
  call Hloop_QA_V(ntryL,G2H16(14),ex4(:),G2H8(23),m3h2x8(:,38),heltab2x16(:,:,60))
call Hotf_5pt_reduction(G2H32(3),RedSet_5(37),mass5set(:,12),  & 
G1H32(18),G1H32(19),G1H32(27),G1H32(28),G1H32(29),G1H32(30),32)
call HG1shiftOLR(G1H32(19),8,32)
call Hotf_5pt_reduction(G2H32(4),RedSet_5(2),mass5set(:,1),  & 
G1H32(31),G1H32(32),G1H32(33),G1H32(34),G1H32(35),G1H32(36),32)
call HG1shiftOLR(G1H32(32),48,32)
call Hotf_5pt_reduction(G2H32(5),RedSet_5(38),mass5set(:,12),  & 
G1H32(37),G1H32(38),G1H32(39),G1H32(40),G1H32(41),G1H32(42),32)
call HG1shiftOLR(G1H32(38),8,32)
  call Hloop_QA_V(ntryL,G2H16(15),ex4(:),G2H8(2),m3h2x8(:,39),heltab2x16(:,:,61))
call Hotf_5pt_reduction(G2H32(6),RedSet_5(1),mass5set(:,1),  & 
G1H32(43),G1H32(44),G1H32(45),G1H32(46),G1H32(47),G1H32(48),32)
call HG1shiftOLR(G1H32(44),48,32)
  call Hloop_AQ_V(ntryL,G2H16(16),ex3(:),G2H8(6),m3h2x8(:,40),heltab2x16(:,:,62))
  call Hloop_QA_V(ntryL,G2H8(3),ex6(:),G2H4(59),m3h2x4(:,77),heltab2x8(:,:,89))
  call Hloop_QA_V(ntryL,G2H8(5),ex6(:),G2H4(60),m3h2x4(:,78),heltab2x8(:,:,90))
  call Hloop_AQ_V(ntryL,G2H8(8),ex5(:),G2H4(61),m3h2x4(:,79),heltab2x8(:,:,91))
  call Hloop_AQ_V(ntryL,G2H8(11),ex5(:),G2H4(62),m3h2x4(:,80),heltab2x8(:,:,92))
  call Hloop_VA_Q(ntryL,G1H32(2),ex4(:),G1H16(44),m3h2x16(:,23),heltab2x32(:,:,47))
  call Hloop_A_Q(ntryL,G1H16(44),88,nMT,G2H16(4),n2h16(41))
  call Hloop_VQ_A(ntryL,G1H32(9),wf8(:,15),G1H4(36),m3h8x4(:,1),heltab2x32(:,:,48))
  call Hloop_Q_A(ntryL,G1H4(36),87,nMT,G2H4(63),n2h4(71))
  call Hloop_AQ_V(ntryL,G2H32(7),wf8(:,15),G2H4(64),m3h8x4(:,2),heltab2x32(:,:,49))
  call Hloop_AQ_V(ntryL,G2H32(8),wf8(:,15),G2H4(65),m3h8x4(:,3),heltab2x32(:,:,50))
  call Hloop_VQ_A(ntryL,G1H32(8),ex5(:),G1H16(50),m3h2x16(:,24),heltab2x32(:,:,51))
  call Hloop_Q_A(ntryL,G1H16(50),84,nMB,G2H16(9),n2h16(42))
  call Hloop_VQ_A(ntryL,G1H32(4),ex3(:),G1H16(19),m3h2x16(:,25),heltab2x32(:,:,52))
  call Hloop_Q_A(ntryL,G1H16(19),84,nMT,G2H16(5),n2h16(43))
  call Hloop_VA_Q(ntryL,G1H32(5),ex6(:),G1H16(30),m3h2x16(:,26),heltab2x32(:,:,53))
  call Hloop_A_Q(ntryL,G1H16(30),100,nMB,G2H16(6),n2h16(44))
  call Hloop_VA_Q(ntryL,G1H32(6),wf8(:,11),G1H4(37),m3h8x4(:,4),heltab2x32(:,:,54))
  call Hloop_A_Q(ntryL,G1H4(37),91,nMT,G2H4(66),n2h4(72))
  call Hloop_QA_V(ntryL,G2H32(9),wf8(:,11),G2H4(67),m3h8x4(:,5),heltab2x32(:,:,55))
  call Hloop_QA_V(ntryL,G2H32(10),wf8(:,11),G2H4(68),m3h8x4(:,6),heltab2x32(:,:,56))
  call Hloop_AQ_V(ntryL,G2H32(11),ex3(:),G2H16(7),m3h2x16(:,27),heltab2x32(:,:,57))
  call Hloop_QA_V(ntryL,G2H32(12),ex4(:),G2H16(8),m3h2x16(:,28),heltab2x32(:,:,58))
  call Hloop_QA_V(ntryL,G2H32(13),ex4(:),G2H16(2),m3h2x16(:,29),heltab2x32(:,:,59))
  call Hloop_AQ_V(ntryL,G2H32(14),ex3(:),G2H16(10),m3h2x16(:,30),heltab2x32(:,:,60))
  call Hloop_VA_Q(ntryL,G1H32(1),ex6(:),G1H16(44),m3h2x16(:,31),heltab2x32(:,:,61))
  call Hloop_A_Q(ntryL,G1H16(44),100,nMB,G2H16(11),n2h16(45))
  call Hloop_VQ_A(ntryL,G1H32(7),wf8(:,6),G1H4(38),m3h8x4(:,7),heltab2x32(:,:,62))
  call Hloop_Q_A(ntryL,G1H4(38),87,nMB,G2H4(69),n2h4(73))
  call Hloop_AQ_V(ntryL,G2H32(15),ex3(:),G2H16(12),m3h2x16(:,32),heltab2x32(:,:,63))
  call Hloop_VQ_A(ntryL,G1H32(10),ex3(:),G1H16(50),m3h2x16(:,33),heltab2x32(:,:,64))
  call Hloop_Q_A(ntryL,G1H16(50),84,nMT,G2H16(13),n2h16(46))
  call Hloop_QA_V(ntryL,G2H32(16),ex4(:),G2H16(14),m3h2x16(:,34),heltab2x32(:,:,65))
  call Hloop_QA_V(ntryL,G2H32(17),ex4(:),G2H16(15),m3h2x16(:,35),heltab2x32(:,:,66))
  call Hloop_VA_Q(ntryL,G1H32(13),ex4(:),G1H16(19),m3h2x16(:,36),heltab2x32(:,:,67))
  call Hloop_A_Q(ntryL,G1H16(19),88,nMT,G2H16(16),n2h16(47))
  call Hloop_AQ_V(ntryL,G2H32(18),ex3(:),G2H16(17),m3h2x16(:,37),heltab2x32(:,:,68))
  call Hloop_VQ_A(ntryL,G1H32(15),ex5(:),G1H16(30),m3h2x16(:,38),heltab2x32(:,:,69))
  call Hloop_Q_A(ntryL,G1H16(30),84,nMB,G2H16(18),n2h16(48))
  call Hloop_VA_Q(ntryL,G1H32(21),wf8(:,2),G1H4(43),m3h8x4(:,8),heltab2x32(:,:,70))
  call Hloop_A_Q(ntryL,G1H4(43),103,nMB,G2H4(70),n2h4(74))
  call Hloop_VQ_A(ntryL,G1H16(39),ex5(:),G1H8(58),m3h2x8(:,41),heltab2x16(:,:,63))
  call Hloop_Q_A(ntryL,G1H8(58),92,nMB,G2H8(3),n2h8(61))
call HGT_raise_alpha_OLR(G1H16(40),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(40),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(40),ex6(:),G1H8(63),m3h2x8(:,42),heltab2x16(:,:,64))
  call Hloop_VQ_A(ntryL,G1H16(42),ex5(:),G1H8(64),m3h2x8(:,43),heltab2x16(:,:,65))
  call Hloop_Q_A(ntryL,G1H8(64),92,nMB,G2H8(5),n2h8(62))
  call Hloop_VQ_A(ntryL,G1H16(45),ex5(:),G1H8(68),m3h2x8(:,44),heltab2x16(:,:,66))
  call Hloop_Q_A(ntryL,G1H8(68),92,nMB,G2H8(8),n2h8(63))
  call Hloop_VQ_A(ntryL,G1H16(46),ex5(:),G1H8(12),m3h2x8(:,45),heltab2x16(:,:,67))
  call Hloop_Q_A(ntryL,G1H8(12),92,nMB,G2H8(11),n2h8(64))
  call Hloop_VA_Q(ntryL,G1H16(47),ex6(:),G1H8(32),m3h2x8(:,46),heltab2x16(:,:,68))
  call Hloop_A_Q(ntryL,G1H8(32),108,nMB,G2H8(25),n2h8(65))
call HGT_raise_alpha_OLR(G1H16(48),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(48),2,5,16)
  call Hloop_VQ_A(ntryL,G1H16(48),ex5(:),G1H8(50),m3h2x8(:,47),heltab2x16(:,:,69))
  call Hloop_VA_Q(ntryL,G1H16(52),ex6(:),G1H8(62),m3h2x8(:,48),heltab2x16(:,:,70))
  call Hloop_A_Q(ntryL,G1H8(62),108,nMB,G2H8(26),n2h8(66))
  call Hloop_VA_Q(ntryL,G1H16(5),ex6(:),G1H8(20),m3h2x8(:,49),heltab2x16(:,:,71))
  call Hloop_A_Q(ntryL,G1H8(20),108,nMB,G2H8(27),n2h8(67))
  call Hloop_VA_Q(ntryL,G1H16(6),ex6(:),G1H8(23),m3h2x8(:,50),heltab2x16(:,:,72))
  call Hloop_A_Q(ntryL,G1H8(23),108,nMB,G2H8(28),n2h8(68))
  call Hloop_QZ_A(ntryL,G1H16(9),wf4(:,4),G1H4(44),ngZd,m3h4x4(:,23),heltab2x16(:,:,73))
  call Hloop_Q_A(ntryL,G1H4(44),79,nMB,G2H4(71),n2h4(75))
call HGT_OLR(G1H16(10),1,1,16)
call HGT_invQ_OLR(G1H16(10),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(10),-16,nMB,G2H16(19),n2h16(51))
  call Hloop_AQ_V(ntryL,G2H16(19),ex5(:),G2H8(29),m3h2x8(:,51),heltab2x16(:,:,74))
  call Hloop_QZ_A(ntryL,G1H16(12),wf4(:,4),G1H4(48),ngZd,m3h4x4(:,24),heltab2x16(:,:,75))
  call Hloop_Q_A(ntryL,G1H4(48),79,nMB,G2H4(72),n2h4(76))
  call Hloop_QZ_A(ntryL,G1H16(15),wf4(:,4),G1H4(12),ngZd,m3h4x4(:,25),heltab2x16(:,:,76))
  call Hloop_Q_A(ntryL,G1H4(12),79,nMB,G2H4(73),n2h4(77))
  call Hloop_QZ_A(ntryL,G1H16(16),wf4(:,4),G1H4(13),ngZd,m3h4x4(:,26),heltab2x16(:,:,77))
  call Hloop_Q_A(ntryL,G1H4(13),79,nMB,G2H4(74),n2h4(78))
  call Hloop_QV_A(ntryL,G1H16(17),wf4(:,2),G1H4(14),m3h4x4(:,27),heltab2x16(:,:,78))
  call Hloop_Q_A(ntryL,G1H4(14),79,nMB,G2H4(75),n2h4(79))
call HGT_OLR(G1H16(18),1,1,16)
call HGT_invQ_OLR(G1H16(18),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(18),-16,nMB,G2H16(19),n2h16(52))
  call Hloop_AQ_V(ntryL,G2H16(19),ex5(:),G2H8(30),m3h2x8(:,52),heltab2x16(:,:,79))
  call Hloop_QV_A(ntryL,G1H16(22),wf4(:,2),G1H4(19),m3h4x4(:,28),heltab2x16(:,:,80))
  call Hloop_Q_A(ntryL,G1H4(19),79,nMB,G2H4(76),n2h4(80))
  call Hloop_QV_A(ntryL,G1H16(23),wf4(:,2),G1H4(20),m3h4x4(:,29),heltab2x16(:,:,81))
  call Hloop_Q_A(ntryL,G1H4(20),79,nMB,G2H4(77),n2h4(81))
  call Hloop_QV_A(ntryL,G1H16(24),wf4(:,2),G1H4(24),m3h4x4(:,30),heltab2x16(:,:,82))
  call Hloop_Q_A(ntryL,G1H4(24),79,nMB,G2H4(78),n2h4(82))
  call Hloop_AZ_Q(ntryL,G1H16(35),wf4(:,4),G1H4(25),ngZd,m3h4x4(:,31),heltab2x16(:,:,83))
  call Hloop_A_Q(ntryL,G1H4(25),79,nMB,G2H4(79),n2h4(83))
call HGT_OLR(G1H16(49),1,1,16)
call HGT_invQ_OLR(G1H16(49),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(49),-32,nMB,G2H16(19),n2h16(53))
  call Hloop_QA_V(ntryL,G2H16(19),ex6(:),G2H8(31),m3h2x8(:,53),heltab2x16(:,:,84))
  call Hloop_AZ_Q(ntryL,G1H16(36),wf4(:,4),G1H4(26),ngZd,m3h4x4(:,32),heltab2x16(:,:,85))
  call Hloop_A_Q(ntryL,G1H4(26),79,nMB,G2H4(80),n2h4(84))
  call Hloop_AZ_Q(ntryL,G1H16(37),wf4(:,4),G1H4(31),ngZd,m3h4x4(:,33),heltab2x16(:,:,86))
  call Hloop_A_Q(ntryL,G1H4(31),79,nMB,G2H4(81),n2h4(85))
  call Hloop_AZ_Q(ntryL,G1H16(34),wf4(:,4),G1H4(32),ngZd,m3h4x4(:,34),heltab2x16(:,:,87))
  call Hloop_A_Q(ntryL,G1H4(32),79,nMB,G2H4(82),n2h4(86))
  call Hloop_AV_Q(ntryL,G1H16(7),wf4(:,2),G1H4(36),m3h4x4(:,35),heltab2x16(:,:,88))
  call Hloop_A_Q(ntryL,G1H4(36),79,nMB,G2H4(83),n2h4(87))
call HGT_OLR(G1H16(20),1,1,16)
call HGT_invQ_OLR(G1H16(20),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(20),-32,nMB,G2H16(19),n2h16(54))
  call Hloop_QA_V(ntryL,G2H16(19),ex6(:),G2H8(32),m3h2x8(:,54),heltab2x16(:,:,89))
  call Hloop_AV_Q(ntryL,G1H16(13),wf4(:,2),G1H4(37),m3h4x4(:,36),heltab2x16(:,:,90))
  call Hloop_A_Q(ntryL,G1H4(37),79,nMB,G2H4(84),n2h4(88))
  call Hloop_AV_Q(ntryL,G1H16(26),wf4(:,2),G1H4(38),m3h4x4(:,37),heltab2x16(:,:,91))
  call Hloop_A_Q(ntryL,G1H4(38),79,nMB,G2H4(85),n2h4(89))
  call Hloop_AV_Q(ntryL,G1H16(14),wf4(:,2),G1H4(43),m3h4x4(:,38),heltab2x16(:,:,92))
  call Hloop_A_Q(ntryL,G1H4(43),79,nMB,G2H4(86),n2h4(90))
  call Hloop_QZ_A(ntryL,G1H32(16),wf4(:,4),G1H8(1),ngZd,m3h4x8(:,25),heltab2x32(:,:,71))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMB,G2H8(33),n2h8(69))
call HGT_raise_alpha_OLR(G1H32(17),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(17),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(17),ex6(:),G1H16(44),m3h2x16(:,39),heltab2x32(:,:,72))
  call Hloop_QZ_A(ntryL,G1H32(22),wf4(:,4),G1H8(6),ngZd,m3h4x8(:,26),heltab2x32(:,:,73))
  call Hloop_Q_A(ntryL,G1H8(6),83,nMB,G2H8(34),n2h8(70))
  call Hloop_QZ_A(ntryL,G1H32(23),wf4(:,4),G1H8(25),ngZd,m3h4x8(:,27),heltab2x32(:,:,74))
  call Hloop_Q_A(ntryL,G1H8(25),83,nMB,G2H8(35),n2h8(71))
  call Hloop_QZ_A(ntryL,G1H32(24),wf4(:,4),G1H8(35),ngZd,m3h4x8(:,28),heltab2x32(:,:,75))
  call Hloop_Q_A(ntryL,G1H8(35),83,nMB,G2H8(36),n2h8(72))
  call Hloop_QV_A(ntryL,G1H32(3),wf4(:,2),G1H8(36),m3h4x8(:,29),heltab2x32(:,:,76))
  call Hloop_Q_A(ntryL,G1H8(36),92,nMB,G2H8(37),n2h8(73))
call HGT_raise_alpha_OLR(G1H32(11),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(11),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(11),ex6(:),G1H16(50),m3h2x16(:,40),heltab2x32(:,:,77))
  call Hloop_QV_A(ntryL,G1H32(14),wf4(:,2),G1H8(42),m3h4x8(:,30),heltab2x32(:,:,78))
  call Hloop_Q_A(ntryL,G1H8(42),92,nMB,G2H8(38),n2h8(74))
  call Hloop_QV_A(ntryL,G1H32(25),wf4(:,2),G1H8(10),m3h4x8(:,31),heltab2x32(:,:,79))
  call Hloop_Q_A(ntryL,G1H8(10),92,nMB,G2H8(39),n2h8(75))
  call Hloop_QV_A(ntryL,G1H32(26),wf4(:,2),G1H8(22),m3h4x8(:,32),heltab2x32(:,:,80))
  call Hloop_Q_A(ntryL,G1H8(22),92,nMB,G2H8(40),n2h8(76))
  call Hloop_QV_A(ntryL,G1H16(25),wf4(:,9),G1H4(44),m3h4x4(:,39),heltab2x16(:,:,93))
  call Hloop_Q_A(ntryL,G1H4(44),115,nMT,G2H4(87),n2h4(91))
call HGT_OLR(G1H16(1),1,1,16)
call HGT_invQ_OLR(G1H16(1),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(1),-4,nMT,G2H16(19),n2h16(55))
  call Hloop_AQ_V(ntryL,G2H16(19),ex3(:),G2H8(41),m3h2x8(:,55),heltab2x16(:,:,94))
  call Hloop_QV_A(ntryL,G1H16(3),wf4(:,9),G1H4(48),m3h4x4(:,40),heltab2x16(:,:,95))
  call Hloop_Q_A(ntryL,G1H4(48),115,nMT,G2H4(88),n2h4(92))
  call Hloop_QV_A(ntryL,G1H16(4),wf4(:,9),G1H4(12),m3h4x4(:,41),heltab2x16(:,:,96))
  call Hloop_Q_A(ntryL,G1H4(12),115,nMT,G2H4(89),n2h4(93))
  call Hloop_QV_A(ntryL,G1H16(29),wf4(:,9),G1H4(13),m3h4x4(:,42),heltab2x16(:,:,97))
  call Hloop_Q_A(ntryL,G1H4(13),115,nMT,G2H4(90),n2h4(94))
  call Hloop_AV_Q(ntryL,G1H16(27),wf4(:,9),G1H4(14),m3h4x4(:,43),heltab2x16(:,:,98))
  call Hloop_A_Q(ntryL,G1H4(14),115,nMT,G2H4(91),n2h4(95))
call HGT_OLR(G1H16(28),1,1,16)
call HGT_invQ_OLR(G1H16(28),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(28),-8,nMT,G2H16(19),n2h16(56))
  call Hloop_QA_V(ntryL,G2H16(19),ex4(:),G2H8(42),m3h2x8(:,56),heltab2x16(:,:,99))
  call Hloop_AV_Q(ntryL,G1H16(32),wf4(:,9),G1H4(19),m3h4x4(:,44),heltab2x16(:,:,100))
  call Hloop_A_Q(ntryL,G1H4(19),115,nMT,G2H4(92),n2h4(96))
  call Hloop_AV_Q(ntryL,G1H16(38),wf4(:,9),G1H4(20),m3h4x4(:,45),heltab2x16(:,:,101))
  call Hloop_A_Q(ntryL,G1H4(20),115,nMT,G2H4(93),n2h4(97))
  call Hloop_AV_Q(ntryL,G1H16(43),wf4(:,9),G1H4(24),m3h4x4(:,46),heltab2x16(:,:,102))
  call Hloop_A_Q(ntryL,G1H4(24),115,nMT,G2H4(94),n2h4(98))
  call Hloop_QZ_A(ntryL,G1H32(18),wf4(:,4),G1H8(34),ngZu,m3h4x8(:,33),heltab2x32(:,:,81))
  call Hloop_Q_A(ntryL,G1H8(34),71,nMT,G2H8(43),n2h8(77))
call HGT_raise_alpha_OLR(G1H32(19),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(19),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(19),ex4(:),G1H16(19),m3h2x16(:,41),heltab2x32(:,:,82))
  call Hloop_QZ_A(ntryL,G1H32(28),wf4(:,4),G1H8(46),ngZu,m3h4x8(:,34),heltab2x32(:,:,83))
  call Hloop_Q_A(ntryL,G1H8(46),71,nMT,G2H8(44),n2h8(78))
  call Hloop_QZ_A(ntryL,G1H32(29),wf4(:,4),G1H8(3),ngZu,m3h4x8(:,35),heltab2x32(:,:,84))
  call Hloop_Q_A(ntryL,G1H8(3),71,nMT,G2H8(45),n2h8(79))
  call Hloop_QZ_A(ntryL,G1H32(30),wf4(:,4),G1H8(4),ngZu,m3h4x8(:,36),heltab2x32(:,:,85))
  call Hloop_Q_A(ntryL,G1H8(4),71,nMT,G2H8(46),n2h8(80))
  call Hloop_QZ_A(ntryL,G1H32(31),wf4(:,4),G1H8(9),ngZu,m3h4x8(:,37),heltab2x32(:,:,86))
  call Hloop_Q_A(ntryL,G1H8(9),71,nMT,G2H8(47),n2h8(81))
call HGT_raise_alpha_OLR(G1H32(32),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(32),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(32),-48,wf4(:,9),48,G2H8(48),m3h4x8(:,38),heltab2x32(:,:,87))
call signflip_OLR(G2H8(48))
  call Hloop_QZ_A(ntryL,G1H32(34),wf4(:,4),G1H8(44),ngZu,m3h4x8(:,39),heltab2x32(:,:,88))
  call Hloop_Q_A(ntryL,G1H8(44),71,nMT,G2H8(49),n2h8(82))
  call Hloop_QZ_A(ntryL,G1H32(35),wf4(:,4),G1H8(51),ngZu,m3h4x8(:,40),heltab2x32(:,:,89))
  call Hloop_Q_A(ntryL,G1H8(51),71,nMT,G2H8(50),n2h8(83))
  call Hloop_QZ_A(ntryL,G1H32(36),wf4(:,4),G1H8(15),ngZu,m3h4x8(:,41),heltab2x32(:,:,90))
  call Hloop_Q_A(ntryL,G1H8(15),71,nMT,G2H8(51),n2h8(84))
  call Hloop_QV_A(ntryL,G1H32(37),wf4(:,9),G1H8(16),m3h4x8(:,42),heltab2x32(:,:,91))
  call Hloop_Q_A(ntryL,G1H8(16),116,nMT,G2H8(52),n2h8(85))
call HGT_raise_alpha_OLR(G1H32(38),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(38),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(38),ex4(:),G1H16(30),m3h2x16(:,42),heltab2x32(:,:,92))
  call Hloop_QV_A(ntryL,G1H32(40),wf4(:,9),G1H8(21),m3h4x8(:,43),heltab2x32(:,:,93))
  call Hloop_Q_A(ntryL,G1H8(21),116,nMT,G2H8(53),n2h8(86))
  call Hloop_QV_A(ntryL,G1H32(41),wf4(:,9),G1H8(43),m3h4x8(:,44),heltab2x32(:,:,94))
  call Hloop_Q_A(ntryL,G1H8(43),116,nMT,G2H8(54),n2h8(87))
  call Hloop_QV_A(ntryL,G1H32(42),wf4(:,9),G1H8(52),m3h4x8(:,45),heltab2x32(:,:,95))
  call Hloop_Q_A(ntryL,G1H8(52),116,nMT,G2H8(55),n2h8(88))
  call Hloop_AZ_Q(ntryL,G1H32(43),wf4(:,4),G1H8(56),ngZu,m3h4x8(:,46),heltab2x32(:,:,96))
  call Hloop_A_Q(ntryL,G1H8(56),75,nMT,G2H8(56),n2h8(89))
call HGT_raise_alpha_OLR(G1H32(44),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(44),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(44),-48,wf4(:,9),48,G2H8(57),m3h4x8(:,47),heltab2x32(:,:,97))
call signflip_OLR(G2H8(57))
  call Hloop_AZ_Q(ntryL,G1H32(46),wf4(:,4),G1H8(57),ngZu,m3h4x8(:,48),heltab2x32(:,:,98))
  call Hloop_A_Q(ntryL,G1H8(57),75,nMT,G2H8(58),n2h8(90))
  call Hloop_AZ_Q(ntryL,G1H32(47),wf4(:,4),G1H8(27),ngZu,m3h4x8(:,49),heltab2x32(:,:,99))
  call Hloop_A_Q(ntryL,G1H8(27),75,nMT,G2H8(59),n2h8(91))
  call Hloop_AZ_Q(ntryL,G1H32(48),wf4(:,4),G1H8(28),ngZu,m3h4x8(:,50),heltab2x32(:,:,100))
  call Hloop_A_Q(ntryL,G1H8(28),75,nMT,G2H8(60),n2h8(92))
  call ol_merge(ntryL,G2H4(65),[G2H4(2),G1H4(5)])
  call ol_merge(ntryL,G2H4(64),[G2H4(5),G1H4(17)])
  call ol_merge(ntryL,G2H4(68),[G2H4(8),G1H4(29)])
  call ol_merge(ntryL,G2H4(67),[G2H4(11),G1H4(41)])
call HGT_lower_alpha_w2_OLR(G2H4(14),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(14),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(14),6,15,4)
  call ol_merge(ntryL,G2H4(14),[G2H4(60)])
call HGT_lower_alpha_w2_OLR(G2H4(18),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(18),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(18),6,15,4)
  call ol_merge(ntryL,G2H4(18),[G2H4(61)])
  call ol_merge(ntryL,G2H8(4),[G1H8(11)])
call HGT_lower_alpha_w2_OLR(G2H4(22),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(22),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(22),6,15,4)
  call ol_merge(ntryL,G2H4(22),[G2H4(59)])
call HGT_lower_alpha_w2_OLR(G2H4(26),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(26),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(26),6,15,4)
  call ol_merge(ntryL,G2H4(26),[G2H4(62)])
  call ol_merge(ntryL,G2H8(9),[G1H8(31)])
  call ol_merge(ntryL,G2H8(13),[G1H8(49)])
  call ol_merge(ntryL,G2H8(17),[G1H8(61)])
  call ol_merge(ntryL,G2H8(10),[G1H8(24)])
call HGT_lower_alpha_w2_OLR(G2H8(20),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(20),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(20),6,15,8)
  call ol_merge(ntryL,G2H8(20),[G2H8(10)])
  call ol_merge(ntryL,G2H4(69),[G2H4(30)])
  call ol_merge(ntryL,G2H4(58),[G1H4(39)])
call HGT_lower_alpha_w2_OLR(G2H4(33),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(33),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(33),6,15,4)
  call ol_merge(ntryL,G2H4(33),[G2H4(58)])
  call ol_merge(ntryL,G2H4(54),[G1H4(3)])
call HGT_lower_alpha_w2_OLR(G2H4(37),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(37),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(37),6,15,4)
  call ol_merge(ntryL,G2H4(37),[G2H4(54)])
  call ol_merge(ntryL,G2H4(63),[G2H4(41)])
  call ol_merge(ntryL,G2H8(14),[G1H8(29)])
call HGT_lower_alpha_w2_OLR(G2H8(1),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(1),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(1),6,15,8)
  call ol_merge(ntryL,G2H8(1),[G2H8(14)])
  call ol_merge(ntryL,G2H4(70),[G2H4(44)])
  call ol_merge(ntryL,G2H4(57),[G1H4(27)])
call HGT_lower_alpha_w2_OLR(G2H4(47),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(47),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(47),6,15,4)
  call ol_merge(ntryL,G2H4(47),[G2H4(57)])
  call ol_merge(ntryL,G2H4(56),[G1H4(15)])
call HGT_lower_alpha_w2_OLR(G2H4(51),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(51),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(51),6,15,4)
  call ol_merge(ntryL,G2H4(51),[G2H4(56)])
  call ol_merge(ntryL,G2H4(66),[G2H4(55)])
  call ol_merge(ntryL,G2H4(3),[G1H4(4)])
  call ol_merge(ntryL,G2H4(6),[G1H4(16)])
  call ol_merge(ntryL,G2H4(9),[G1H4(28)])
  call ol_merge(ntryL,G2H4(12),[G1H4(40)])
  call ol_merge(ntryL,G2H8(3),[G1H8(48),G1H8(7)])
  call ol_merge(ntryL,G2H8(8),[G1H8(54),G1H8(14)])
  call ol_merge(ntryL,G2H8(25),[G1H8(60),G1H8(30)])
  call ol_merge(ntryL,G2H8(27),[G1H8(66),G1H8(38)])
  call ol_merge(ntryL,G2H8(18),[G1H8(47)])
  call ol_merge(ntryL,G2H8(22),[G1H8(59)])
call Hotf_5pt_reduction(G2H4(65),RedSet_5(39),mass5set(:,3),  & 
G1H4(25),G1H4(26),G1H4(31),G1H4(32),G1H4(36),G1H4(37),4)
call HG1shiftOLR(G1H4(26),32,4)
call Hotf_5pt_reduction(G2H4(64),RedSet_5(40),mass5set(:,3),  & 
G1H4(38),G1H4(43),G1H4(44),G1H4(48),G1H4(12),G1H4(13),4)
call HG1shiftOLR(G1H4(43),16,4)
call Hotf_5pt_reduction(G2H4(68),RedSet_5(41),mass5set(:,3),  & 
G1H4(14),G1H4(19),G1H4(20),G1H4(24),G1H4(5),G1H4(17),4)
call HG1shiftOLR(G1H4(19),32,4)
call Hotf_5pt_reduction(G2H4(67),RedSet_5(42),mass5set(:,3),  & 
G1H4(29),G1H4(41),G1H4(39),G1H4(3),G1H4(27),G1H4(15),4)
call HG1shiftOLR(G1H4(41),16,4)
call Hotf_5pt_reduction(G2H4(14),RedSet_5(43),mass5set(:,13),  & 
G1H4(4),G1H4(16),G1H4(28),G1H4(40),G1H4(49),G1H4(50),4)
call HG1shiftOLR(G1H4(16),4,4)
  call Hloop_AQ_V(ntryL,G2H4(15),ex3(:),G2H2(1),m3h2x2(:,45),heltab2x4(:,:,45))
call Hotf_5pt_reduction(G2H4(18),RedSet_5(44),mass5set(:,13),  & 
G1H4(51),G1H4(52),G1H4(53),G1H4(54),G1H4(55),G1H4(56),4)
call HG1shiftOLR(G1H4(52),8,4)
  call Hloop_QA_V(ntryL,G2H4(19),ex4(:),G2H2(3),m3h2x2(:,46),heltab2x4(:,:,46))
call HGT_w2_OLR(G1H8(2),1,1,8)
call HGT_w2_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(2),ex5(:),G1H4(57),m3h2x4(:,81),heltab2x8(:,:,93))
  call Hloop_Q_A(ntryL,G1H4(57),124,nMB,G2H4(2),n2h4(99))
call Hotf_5pt_reduction(G2H8(4),RedSet_5(45),mass5set(:,14),  & 
G1H8(33),G1H8(26),G1H8(39),G1H8(40),G1H8(45),G1H8(19),8)
call HG1shiftOLR(G1H8(26),32,8)
call Hotf_5pt_reduction(G2H4(22),RedSet_5(46),mass5set(:,13),  & 
G1H4(57),G1H4(58),G1H4(59),G1H4(60),G1H4(61),G1H4(62),4)
call HG1shiftOLR(G1H4(58),8,4)
  call Hloop_QA_V(ntryL,G2H4(23),ex4(:),G2H2(5),m3h2x2(:,47),heltab2x4(:,:,47))
call Hotf_5pt_reduction(G2H4(26),RedSet_5(47),mass5set(:,13),  & 
G1H4(63),G1H4(64),G1H4(65),G1H4(66),G1H4(67),G1H4(68),4)
call HG1shiftOLR(G1H4(64),4,4)
  call Hloop_AQ_V(ntryL,G2H4(27),ex3(:),G2H2(7),m3h2x2(:,48),heltab2x4(:,:,48))
call HGT_w2_OLR(G1H8(8),1,1,8)
call HGT_w2_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(8),ex6(:),G1H4(69),m3h2x4(:,82),heltab2x8(:,:,94))
  call Hloop_A_Q(ntryL,G1H4(69),124,nMB,G2H4(5),n2h4(100))
call Hotf_5pt_reduction(G2H8(9),RedSet_5(48),mass5set(:,14),  & 
G1H8(58),G1H8(64),G1H8(68),G1H8(12),G1H8(32),G1H8(62),8)
call HG1shiftOLR(G1H8(64),16,8)
call HGT_w2_OLR(G1H8(5),1,1,8)
call HGT_w2_invQ_OLR(G1H8(5),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(5),ex5(:),G1H4(69),m3h2x4(:,83),heltab2x8(:,:,95))
  call Hloop_Q_A(ntryL,G1H4(69),124,nMB,G2H4(8),n2h4(101))
call Hotf_5pt_reduction(G2H8(13),RedSet_5(49),mass5set(:,14),  & 
G1H8(20),G1H8(23),G1H8(1),G1H8(6),G1H8(25),G1H8(35),8)
call HG1shiftOLR(G1H8(23),32,8)
call HGT_w2_OLR(G1H8(17),1,1,8)
call HGT_w2_invQ_OLR(G1H8(17),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(17),ex6(:),G1H4(69),m3h2x4(:,84),heltab2x8(:,:,96))
  call Hloop_A_Q(ntryL,G1H4(69),124,nMB,G2H4(11),n2h4(102))
call Hotf_5pt_reduction(G2H8(17),RedSet_5(50),mass5set(:,14),  & 
G1H8(36),G1H8(42),G1H8(10),G1H8(22),G1H8(34),G1H8(46),8)
call HG1shiftOLR(G1H8(42),16,8)
call Hotf_5pt_reduction(G2H8(20),RedSet_5(51),mass5set(:,15),  & 
G1H8(3),G1H8(4),G1H8(9),G1H8(44),G1H8(51),G1H8(15),8)
call HG1shiftOLR(G1H8(4),32,8)
  call Hloop_QA_V(ntryL,G2H4(69),ex6(:),G2H2(9),m3h2x2(:,49),heltab2x4(:,:,49))
call Hotf_5pt_reduction(G2H4(33),RedSet_5(52),mass5set(:,16),  & 
G1H4(69),G1H4(70),G1H4(71),G1H4(72),G1H4(73),G1H4(74),4)
call HG1shiftOLR(G1H4(70),16,4)
  call Hloop_AQ_V(ntryL,G2H4(34),ex5(:),G2H2(11),m3h2x2(:,50),heltab2x4(:,:,50))
call Hotf_5pt_reduction(G2H4(37),RedSet_5(53),mass5set(:,16),  & 
G1H4(75),G1H4(76),G1H4(77),G1H4(78),G1H4(79),G1H4(80),4)
call HG1shiftOLR(G1H4(76),32,4)
  call Hloop_QA_V(ntryL,G2H4(38),ex6(:),G2H2(13),m3h2x2(:,51),heltab2x4(:,:,51))
call HGT_lower_alpha_w2_OLR(G2H8(24),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(24),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(24),6,15,8)
call Hotf_5pt_reduction(G2H8(24),RedSet_5(54),mass5set(:,17),  & 
G1H8(16),G1H8(21),G1H8(43),G1H8(52),G1H8(56),G1H8(57),8)
call HG1shiftOLR(G1H8(21),8,8)
  call Hloop_QA_V(ntryL,G2H4(63),ex4(:),G2H2(15),m3h2x2(:,52),heltab2x4(:,:,52))
call Hotf_5pt_reduction(G2H8(1),RedSet_5(55),mass5set(:,15),  & 
G1H8(27),G1H8(28),G1H8(11),G1H8(31),G1H8(49),G1H8(61),8)
call HG1shiftOLR(G1H8(28),16,8)
  call Hloop_AQ_V(ntryL,G2H4(70),ex5(:),G2H2(17),m3h2x2(:,53),heltab2x4(:,:,53))
call Hotf_5pt_reduction(G2H4(47),RedSet_5(56),mass5set(:,16),  & 
G1H4(81),G1H4(82),G1H4(83),G1H4(84),G1H4(85),G1H4(86),4)
call HG1shiftOLR(G1H4(82),32,4)
  call Hloop_QA_V(ntryL,G2H4(48),ex6(:),G2H2(19),m3h2x2(:,54),heltab2x4(:,:,54))
call Hotf_5pt_reduction(G2H4(51),RedSet_5(57),mass5set(:,16),  & 
G1H4(87),G1H4(88),G1H4(89),G1H4(90),G1H4(91),G1H4(92),4)
call HG1shiftOLR(G1H4(88),16,4)
  call Hloop_AQ_V(ntryL,G2H4(52),ex5(:),G2H2(21),m3h2x2(:,55),heltab2x4(:,:,55))
call HGT_lower_alpha_w2_OLR(G2H8(7),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(7),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(7),6,15,8)
call Hotf_5pt_reduction(G2H8(7),RedSet_5(58),mass5set(:,17),  & 
G1H8(24),G1H8(29),G1H8(48),G1H8(7),G1H8(54),G1H8(14),8)
call HG1shiftOLR(G1H8(29),4,8)
  call Hloop_AQ_V(ntryL,G2H4(66),ex3(:),G2H2(23),m3h2x2(:,56),heltab2x4(:,:,56))
call Hotf_5pt_reduction(G2H4(3),RedSet_5(59),mass5set(:,3),  & 
G1H4(93),G1H4(94),G1H4(95),G1H4(96),G1H4(97),G1H4(98),4)
call HG1shiftOLR(G1H4(94),32,4)
  call Hloop_VQ_A(ntryL,G1H4(9),ex5(:),G1H2(9),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(9),95,nMB,G2H2(25),n2h2(25))
  call Hloop_VQ_A(ntryL,G1H4(10),ex5(:),G1H2(10),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_Q_A(ntryL,G1H2(10),95,nMB,G2H2(28),n2h2(26))
  call Hloop_VQ_A(ntryL,G1H4(11),ex5(:),G1H2(15),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(15),95,nMB,G2H2(31),n2h2(27))
call Hotf_5pt_reduction(G2H4(6),RedSet_5(60),mass5set(:,3),  & 
G1H4(9),G1H4(10),G1H4(11),G1H4(99),G1H4(100),G1H4(101),4)
call HG1shiftOLR(G1H4(10),16,4)
  call Hloop_VA_Q(ntryL,G1H4(21),ex6(:),G1H2(16),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_A_Q(ntryL,G1H2(16),111,nMB,G2H2(34),n2h2(28))
  call Hloop_VA_Q(ntryL,G1H4(22),ex6(:),G1H2(21),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_A_Q(ntryL,G1H2(21),111,nMB,G2H2(37),n2h2(29))
  call Hloop_VA_Q(ntryL,G1H4(23),ex6(:),G1H2(22),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_A_Q(ntryL,G1H2(22),111,nMB,G2H2(40),n2h2(30))
call Hotf_5pt_reduction(G2H4(9),RedSet_5(61),mass5set(:,3),  & 
G1H4(21),G1H4(22),G1H4(23),G1H4(102),G1H4(103),G1H4(104),4)
call HG1shiftOLR(G1H4(22),32,4)
  call Hloop_VQ_A(ntryL,G1H4(33),ex5(:),G1H2(27),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(27),95,nMB,G2H2(43),n2h2(31))
  call Hloop_VQ_A(ntryL,G1H4(34),ex5(:),G1H2(28),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_Q_A(ntryL,G1H2(28),95,nMB,G2H2(46),n2h2(32))
  call Hloop_VQ_A(ntryL,G1H4(35),ex5(:),G1H2(33),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_Q_A(ntryL,G1H2(33),95,nMB,G2H2(49),n2h2(33))
call Hotf_5pt_reduction(G2H4(12),RedSet_5(62),mass5set(:,3),  & 
G1H4(33),G1H4(34),G1H4(35),G1H4(105),G1H4(106),G1H4(107),4)
call HG1shiftOLR(G1H4(34),16,4)
  call Hloop_VA_Q(ntryL,G1H4(45),ex6(:),G1H2(34),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_A_Q(ntryL,G1H2(34),111,nMB,G2H2(50),n2h2(34))
  call Hloop_VA_Q(ntryL,G1H4(46),ex6(:),G1H2(39),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_A_Q(ntryL,G1H2(39),111,nMB,G2H2(51),n2h2(35))
  call Hloop_VA_Q(ntryL,G1H4(47),ex6(:),G1H2(40),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(40),111,nMB,G2H2(52),n2h2(36))
call Hotf_5pt_reduction(G2H8(3),RedSet_5(27),mass5set(:,8),  & 
G1H8(60),G1H8(30),G1H8(66),G1H8(38),G1H8(47),G1H8(59),8)
call HG1shiftOLR(G1H8(30),32,8)
  call Hloop_QZ_A(ntryL,G1H8(13),wf4(:,4),G1H2(45),ngZd,m3h4x2(:,13),heltab2x8(:,:,97))
  call Hloop_Q_A(ntryL,G1H2(45),95,nMB,G2H2(53),n2h2(37))
call Hotf_4pt_reduction(G2H8(8),RedSet_4(55),mass4set(:,1),  & 
G1H8(2),G1H8(8),G1H8(5),G1H8(17),G1H8(13),8)
call HG1shiftOLR(G1H8(8),32,8)
  call Hloop_QZ_A(ntryL,G1H8(18),wf4(:,4),G1H2(46),ngZd,m3h4x2(:,14),heltab2x8(:,:,98))
  call Hloop_Q_A(ntryL,G1H2(46),95,nMB,G2H2(54),n2h2(38))
call Hotf_5pt_reduction(G2H8(25),RedSet_5(28),mass5set(:,8),  & 
G1H8(18),G1H8(69),G1H8(70),G1H8(71),G1H8(72),G1H8(73),8)
call HG1shiftOLR(G1H8(69),16,8)
  call Hloop_AZ_Q(ntryL,G1H8(37),wf4(:,4),G1H2(51),ngZd,m3h4x2(:,15),heltab2x8(:,:,99))
  call Hloop_A_Q(ntryL,G1H2(51),111,nMB,G2H2(55),n2h2(39))
call Hotf_4pt_reduction(G2H8(27),RedSet_4(69),mass4set(:,1),  & 
G1H8(37),G1H8(74),G1H8(75),G1H8(76),G1H8(77),8)
call HG1shiftOLR(G1H8(74),16,8)
  call Hloop_AZ_Q(ntryL,G1H8(41),wf4(:,4),G1H2(52),ngZd,m3h4x2(:,16),heltab2x8(:,:,100))
  call Hloop_A_Q(ntryL,G1H2(52),111,nMB,G2H2(56),n2h2(40))
call Hotf_5pt_reduction(G2H8(18),RedSet_5(63),mass5set(:,15),  & 
G1H8(41),G1H8(78),G1H8(79),G1H8(80),G1H8(81),G1H8(82),8)
call HG1shiftOLR(G1H8(78),32,8)
  call Hloop_QZ_A(ntryL,G1H8(53),wf4(:,4),G1H2(57),ngZd,m3h4x2(:,17),heltab2x8(:,:,101))
  call Hloop_Q_A(ntryL,G1H2(57),95,nMB,G2H2(57),n2h2(41))
  call Hloop_QZ_A(ntryL,G1H8(55),wf4(:,4),G1H2(58),ngZd,m3h4x2(:,18),heltab2x8(:,:,102))
  call Hloop_Q_A(ntryL,G1H2(58),95,nMB,G2H2(58),n2h2(42))
call Hotf_5pt_reduction(G2H8(22),RedSet_5(64),mass5set(:,15),  & 
G1H8(53),G1H8(55),G1H8(83),G1H8(84),G1H8(85),G1H8(86),8)
call HG1shiftOLR(G1H8(55),16,8)
  call Hloop_AZ_Q(ntryL,G1H8(65),wf4(:,4),G1H2(63),ngZd,m3h4x2(:,19),heltab2x8(:,:,103))
  call Hloop_A_Q(ntryL,G1H2(63),111,nMB,G2H2(59),n2h2(43))
  call Hloop_AZ_Q(ntryL,G1H8(67),wf4(:,4),G1H2(64),ngZd,m3h4x2(:,20),heltab2x8(:,:,104))
  call Hloop_A_Q(ntryL,G1H2(64),111,nMB,G2H2(60),n2h2(44))
  call Hloop_AQ_V(ntryL,G2H4(1),ex3(:),G2H2(61),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_AQ_V(ntryL,G2H4(4),ex3(:),G2H2(62),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_QA_V(ntryL,G2H4(7),ex4(:),G2H2(63),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_QA_V(ntryL,G2H4(10),ex4(:),G2H2(64),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_AQ_V(ntryL,G2H4(13),ex3(:),G2H2(65),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_AQ_V(ntryL,G2H4(16),ex3(:),G2H2(66),m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_QA_V(ntryL,G2H4(17),ex4(:),G2H2(67),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_QA_V(ntryL,G2H4(20),ex4(:),G2H2(68),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_QA_V(ntryL,G2H4(21),ex4(:),G2H2(69),m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_QA_V(ntryL,G2H4(24),ex4(:),G2H2(70),m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_AQ_V(ntryL,G2H4(25),ex3(:),G2H2(71),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_AQ_V(ntryL,G2H4(28),ex3(:),G2H2(72),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_QA_V(ntryL,G2H4(29),ex6(:),G2H2(73),m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_QA_V(ntryL,G2H4(31),ex6(:),G2H2(74),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_AQ_V(ntryL,G2H4(32),ex5(:),G2H2(75),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_AQ_V(ntryL,G2H4(35),ex5(:),G2H2(76),m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_QA_V(ntryL,G2H4(36),ex6(:),G2H2(77),m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_QA_V(ntryL,G2H4(39),ex6(:),G2H2(78),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_QA_V(ntryL,G2H4(40),ex4(:),G2H2(79),m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_AQ_V(ntryL,G2H4(42),ex5(:),G2H2(80),m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_AQ_V(ntryL,G2H4(43),ex5(:),G2H2(81),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_QA_V(ntryL,G2H4(45),ex6(:),G2H2(82),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_QA_V(ntryL,G2H4(46),ex6(:),G2H2(83),m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_AQ_V(ntryL,G2H4(49),ex5(:),G2H2(84),m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_AQ_V(ntryL,G2H4(50),ex5(:),G2H2(85),m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_AQ_V(ntryL,G2H4(53),ex3(:),G2H2(86),m3h2x2(:,94),heltab2x4(:,:,94))
call Hotf_5pt_reduction(G2H8(16),RedSet_5(65),mass5set(:,18),  & 
G1H8(65),G1H8(67),G1H8(87),G1H8(88),G1H8(89),G1H8(90),8)
call HG1shiftOLR(G1H8(67),12,8)
call Hotf_5pt_reduction(G2H8(19),RedSet_5(66),mass5set(:,18),  & 
G1H8(91),G1H8(92),G1H8(93),G1H8(94),G1H8(95),G1H8(96),8)
call HG1shiftOLR(G1H8(92),12,8)
call Hotf_5pt_reduction(G2H8(12),RedSet_5(67),mass5set(:,19),  & 
G1H8(97),G1H8(98),G1H8(99),G1H8(100),G1H8(101),G1H8(102),8)
call HG1shiftOLR(G1H8(98),16,8)
call Hotf_5pt_reduction(G2H8(15),RedSet_5(68),mass5set(:,19),  & 
G1H8(103),G1H8(104),G1H8(105),G1H8(106),G1H8(107),G1H8(108),8)
call HG1shiftOLR(G1H8(104),32,8)
call Hotf_5pt_reduction(G2H16(3),RedSet_5(69),mass5set(:,20),  & 
G1H16(39),G1H16(40),G1H16(42),G1H16(45),G1H16(46),G1H16(47),16)
call HG1shiftOLR(G1H16(40),48,16)
call Hotf_5pt_reduction(G2H16(1),RedSet_5(70),mass5set(:,20),  & 
G1H16(48),G1H16(52),G1H16(5),G1H16(6),G1H16(9),G1H16(10),16)
call HG1shiftOLR(G1H16(52),48,16)
call Hotf_5pt_reduction(G2H8(21),RedSet_5(71),mass5set(:,21),  & 
G1H8(109),G1H8(110),G1H8(111),G1H8(112),G1H8(113),G1H8(114),8)
call HG1shiftOLR(G1H8(110),48,8)
call Hotf_5pt_reduction(G2H8(23),RedSet_5(72),mass5set(:,21),  & 
G1H8(115),G1H8(116),G1H8(117),G1H8(118),G1H8(119),G1H8(120),8)
call HG1shiftOLR(G1H8(116),48,8)
call Hotf_5pt_reduction(G2H8(2),RedSet_5(73),mass5set(:,22),  & 
G1H8(121),G1H8(122),G1H8(123),G1H8(124),G1H8(125),G1H8(126),8)
call HG1shiftOLR(G1H8(122),4,8)
call Hotf_5pt_reduction(G2H8(6),RedSet_5(74),mass5set(:,22),  & 
G1H8(127),G1H8(128),G1H8(129),G1H8(130),G1H8(131),G1H8(132),8)
call HG1shiftOLR(G1H8(128),8,8)
  call Hloop_AQ_V(ntryL,G2H16(4),wf8(:,15),G2H2(87),m3h8x2(:,1),heltab2x16(:,:,103))
  call Hloop_QA_V(ntryL,G2H16(9),ex6(:),G2H8(10),m3h2x8(:,57),heltab2x16(:,:,104))
  call Hloop_QA_V(ntryL,G2H16(5),wf8(:,11),G2H2(88),m3h8x2(:,2),heltab2x16(:,:,105))
  call Hloop_AQ_V(ntryL,G2H16(6),ex5(:),G2H8(14),m3h2x8(:,58),heltab2x16(:,:,106))
call Hotf_5pt_reduction(G2H16(7),RedSet_5(8),mass5set(:,3),  & 
G1H16(12),G1H16(15),G1H16(16),G1H16(17),G1H16(18),G1H16(22),16)
call HG1shiftOLR(G1H16(15),19,16)
call Hotf_5pt_reduction(G2H16(8),RedSet_5(10),mass5set(:,3),  & 
G1H16(23),G1H16(24),G1H16(35),G1H16(49),G1H16(36),G1H16(37),16)
call HG1shiftOLR(G1H16(24),19,16)
call Hotf_5pt_reduction(G2H16(2),RedSet_5(25),mass5set(:,3),  & 
G1H16(34),G1H16(7),G1H16(20),G1H16(13),G1H16(26),G1H16(14),16)
call HG1shiftOLR(G1H16(7),32,16)
call Hotf_5pt_reduction(G2H16(10),RedSet_5(23),mass5set(:,3),  & 
G1H16(25),G1H16(1),G1H16(3),G1H16(4),G1H16(29),G1H16(27),16)
call HG1shiftOLR(G1H16(1),32,16)
  call Hloop_AQ_V(ntryL,G2H16(11),wf8(:,6),G2H2(89),m3h8x2(:,3),heltab2x16(:,:,107))
call Hotf_5pt_reduction(G2H16(12),RedSet_5(5),mass5set(:,3),  & 
G1H16(28),G1H16(32),G1H16(38),G1H16(43),G1H16(53),G1H16(54),16)
call HG1shiftOLR(G1H16(32),35,16)
  call Hloop_QA_V(ntryL,G2H16(13),ex4(:),G2H8(4),m3h2x8(:,59),heltab2x16(:,:,108))
call Hotf_5pt_reduction(G2H16(14),RedSet_5(9),mass5set(:,3),  & 
G1H16(55),G1H16(56),G1H16(57),G1H16(58),G1H16(59),G1H16(60),16)
call HG1shiftOLR(G1H16(56),35,16)
call Hotf_5pt_reduction(G2H16(15),RedSet_5(26),mass5set(:,3),  & 
G1H16(61),G1H16(62),G1H16(63),G1H16(64),G1H16(65),G1H16(66),16)
call HG1shiftOLR(G1H16(62),16,16)
  call Hloop_AQ_V(ntryL,G2H16(16),ex3(:),G2H8(9),m3h2x8(:,60),heltab2x16(:,:,109))
call Hotf_5pt_reduction(G2H16(17),RedSet_5(24),mass5set(:,3),  & 
G1H16(67),G1H16(68),G1H16(69),G1H16(70),G1H16(71),G1H16(72),16)
call HG1shiftOLR(G1H16(68),16,16)
  call Hloop_QA_V(ntryL,G2H16(18),wf8(:,2),G2H2(90),m3h8x2(:,4),heltab2x16(:,:,110))
call Hotf_4pt_reduction(G2H8(11),RedSet_4(56),mass4set(:,1),  & 
G1H8(133),G1H8(134),G1H8(135),G1H8(136),G1H8(137),8)
call HG1shiftOLR(G1H8(134),35,8)
call Hotf_4pt_reduction(G2H8(28),RedSet_4(70),mass4set(:,1),  & 
G1H8(138),G1H8(139),G1H8(140),G1H8(141),G1H8(142),8)
call HG1shiftOLR(G1H8(139),19,8)
  call Hloop_QA_V(ntryL,G2H4(71),ex6(:),G2H2(91),m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_QA_V(ntryL,G2H4(73),ex6(:),G2H2(92),m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_QA_V(ntryL,G2H4(74),ex6(:),G2H2(93),m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_QA_V(ntryL,G2H4(75),ex6(:),G2H2(94),m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_QA_V(ntryL,G2H4(77),ex6(:),G2H2(95),m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_QA_V(ntryL,G2H4(78),ex6(:),G2H2(96),m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_AQ_V(ntryL,G2H4(79),ex5(:),G2H2(97),m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_AQ_V(ntryL,G2H4(81),ex5(:),G2H2(98),m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_AQ_V(ntryL,G2H4(82),ex5(:),G2H2(99),m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_AQ_V(ntryL,G2H4(83),ex5(:),G2H2(100),m3h2x2(:,104),heltab2x4(:,:,104))
  call Hloop_AQ_V(ntryL,G2H4(85),ex5(:),G2H2(101),m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_AQ_V(ntryL,G2H4(86),ex5(:),G2H2(102),m3h2x2(:,106),heltab2x4(:,:,106))
call Hotf_5pt_reduction(G2H8(33),RedSet_5(33),mass5set(:,10),  & 
G1H8(143),G1H8(144),G1H8(145),G1H8(146),G1H8(147),G1H8(148),8)
call HG1shiftOLR(G1H8(144),32,8)
call Hotf_4pt_reduction(G2H8(35),RedSet_4(188),mass4set(:,2),  & 
G1H8(149),G1H8(150),G1H8(151),G1H8(152),G1H8(153),8)
call HG1shiftOLR(G1H8(150),32,8)
call Hotf_4pt_reduction(G2H8(36),RedSet_4(234),mass4set(:,2),  & 
G1H8(154),G1H8(155),G1H8(156),G1H8(157),G1H8(158),8)
call HG1shiftOLR(G1H8(155),44,8)
call Hotf_5pt_reduction(G2H8(37),RedSet_5(34),mass5set(:,10),  & 
G1H8(159),G1H8(160),G1H8(161),G1H8(162),G1H8(163),G1H8(164),8)
call HG1shiftOLR(G1H8(160),32,8)
call Hotf_4pt_reduction(G2H8(39),RedSet_4(188),mass4set(:,2),  & 
G1H8(165),G1H8(166),G1H8(167),G1H8(168),G1H8(169),8)
call HG1shiftOLR(G1H8(166),32,8)
call Hotf_4pt_reduction(G2H8(40),RedSet_4(235),mass4set(:,2),  & 
G1H8(170),G1H8(171),G1H8(172),G1H8(173),G1H8(174),8)
call HG1shiftOLR(G1H8(171),35,8)
  call Hloop_QA_V(ntryL,G2H4(87),ex4(:),G2H2(103),m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_QA_V(ntryL,G2H4(89),ex4(:),G2H2(104),m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_QA_V(ntryL,G2H4(90),ex4(:),G2H2(105),m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_AQ_V(ntryL,G2H4(91),ex3(:),G2H2(106),m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_AQ_V(ntryL,G2H4(93),ex3(:),G2H2(107),m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_AQ_V(ntryL,G2H4(94),ex3(:),G2H2(108),m3h2x2(:,112),heltab2x4(:,:,112))
call Hotf_5pt_reduction(G2H8(43),RedSet_5(37),mass5set(:,12),  & 
G1H8(175),G1H8(176),G1H8(177),G1H8(178),G1H8(179),G1H8(180),8)
call HG1shiftOLR(G1H8(176),8,8)
call Hotf_4pt_reduction(G2H8(45),RedSet_4(152),mass4set(:,3),  & 
G1H8(181),G1H8(182),G1H8(183),G1H8(184),G1H8(185),8)
call HG1shiftOLR(G1H8(182),8,8)
call Hotf_4pt_reduction(G2H8(46),RedSet_4(37),mass4set(:,3),  & 
G1H8(186),G1H8(187),G1H8(188),G1H8(189),G1H8(190),8)
call HG1shiftOLR(G1H8(187),56,8)
  call Hloop_QA_V(ntryL,G2H8(47),ex4(:),G2H4(60),m3h2x4(:,85),heltab2x8(:,:,105))
  call Hloop_QA_V(ntryL,G2H8(50),ex4(:),G2H4(61),m3h2x4(:,86),heltab2x8(:,:,106))
  call Hloop_QA_V(ntryL,G2H8(51),ex4(:),G2H4(59),m3h2x4(:,87),heltab2x8(:,:,107))
call Hotf_5pt_reduction(G2H8(52),RedSet_5(38),mass5set(:,12),  & 
G1H8(191),G1H8(192),G1H8(193),G1H8(194),G1H8(195),G1H8(196),8)
call HG1shiftOLR(G1H8(192),8,8)
call Hotf_4pt_reduction(G2H8(54),RedSet_4(152),mass4set(:,3),  & 
G1H8(197),G1H8(198),G1H8(199),G1H8(200),G1H8(201),8)
call HG1shiftOLR(G1H8(198),8,8)
call Hotf_4pt_reduction(G2H8(55),RedSet_4(236),mass4set(:,3),  & 
G1H8(202),G1H8(203),G1H8(204),G1H8(205),G1H8(206),8)
call HG1shiftOLR(G1H8(203),11,8)
  call Hloop_AQ_V(ntryL,G2H8(56),ex3(:),G2H4(62),m3h2x4(:,88),heltab2x8(:,:,108))
  call Hloop_AQ_V(ntryL,G2H8(59),ex3(:),G2H4(30),m3h2x4(:,89),heltab2x8(:,:,109))
  call Hloop_AQ_V(ntryL,G2H8(60),ex3(:),G2H4(58),m3h2x4(:,90),heltab2x8(:,:,110))
  call ol_merge(ntryL,G1H8(2),[G1H8(47)])
  call ol_merge(ntryL,G1H8(133),[G1H8(59)])
  call ol_merge(ntryL,G1H8(37),[G1H8(72)])
  call ol_merge(ntryL,G1H8(138),[G1H8(73)])
  call ol_merge(ntryL,G1H8(149),[G1H8(147)])
  call ol_merge(ntryL,G1H8(154),[G1H8(148)])
  call ol_merge(ntryL,G1H8(165),[G1H8(163)])
  call ol_merge(ntryL,G1H8(170),[G1H8(164)])
  call ol_merge(ntryL,G1H8(181),[G1H8(179)])
  call ol_merge(ntryL,G1H8(186),[G1H8(180)])
  call ol_merge(ntryL,G1H8(197),[G1H8(195)])
  call ol_merge(ntryL,G1H8(202),[G1H8(196)])
  call Hloop_VQ_A(ntryL,G1H4(25),ex5(:),G1H2(69),m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_Q_A(ntryL,G1H2(69),95,nMB,G2H2(109),n2h2(45))
call HGT_raise_alpha_OLR(G1H4(26),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(26),ex6(:),G1H2(70),m3h2x2(:,114),heltab2x4(:,:,114))
  call Hloop_VQ_A(ntryL,G1H4(36),ex5(:),G1H2(75),m3h2x2(:,115),heltab2x4(:,:,115))
  call Hloop_Q_A(ntryL,G1H2(75),95,nMB,G2H2(110),n2h2(46))
  call Hloop_VQ_A(ntryL,G1H4(37),ex5(:),G1H2(76),m3h2x2(:,116),heltab2x4(:,:,116))
  call Hloop_Q_A(ntryL,G1H2(76),95,nMB,G2H2(111),n2h2(47))
  call Hloop_VA_Q(ntryL,G1H4(38),ex6(:),G1H2(9),m3h2x2(:,117),heltab2x4(:,:,117))
  call Hloop_A_Q(ntryL,G1H2(9),111,nMB,G2H2(112),n2h2(48))
call HGT_raise_alpha_OLR(G1H4(43),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(43),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(43),ex5(:),G1H2(10),m3h2x2(:,118),heltab2x4(:,:,118))
  call Hloop_VA_Q(ntryL,G1H4(12),ex6(:),G1H2(15),m3h2x2(:,119),heltab2x4(:,:,119))
  call Hloop_A_Q(ntryL,G1H2(15),111,nMB,G2H2(113),n2h2(49))
  call Hloop_VA_Q(ntryL,G1H4(13),ex6(:),G1H2(16),m3h2x2(:,120),heltab2x4(:,:,120))
  call Hloop_A_Q(ntryL,G1H2(16),111,nMB,G2H2(114),n2h2(50))
  call Hloop_VQ_A(ntryL,G1H4(14),ex5(:),G1H2(21),m3h2x2(:,121),heltab2x4(:,:,121))
  call Hloop_Q_A(ntryL,G1H2(21),95,nMB,G2H2(115),n2h2(51))
call HGT_raise_alpha_OLR(G1H4(19),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(19),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(19),ex6(:),G1H2(22),m3h2x2(:,122),heltab2x4(:,:,122))
  call Hloop_VQ_A(ntryL,G1H4(5),ex5(:),G1H2(27),m3h2x2(:,123),heltab2x4(:,:,123))
  call Hloop_Q_A(ntryL,G1H2(27),95,nMB,G2H2(116),n2h2(52))
  call Hloop_VQ_A(ntryL,G1H4(17),ex5(:),G1H2(28),m3h2x2(:,124),heltab2x4(:,:,124))
  call Hloop_Q_A(ntryL,G1H2(28),95,nMB,G2H2(117),n2h2(53))
  call Hloop_VA_Q(ntryL,G1H4(29),ex6(:),G1H2(33),m3h2x2(:,125),heltab2x4(:,:,125))
  call Hloop_A_Q(ntryL,G1H2(33),111,nMB,G2H2(118),n2h2(54))
call HGT_raise_alpha_OLR(G1H4(41),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(41),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(41),ex5(:),G1H2(34),m3h2x2(:,126),heltab2x4(:,:,126))
  call Hloop_VA_Q(ntryL,G1H4(27),ex6(:),G1H2(39),m3h2x2(:,127),heltab2x4(:,:,127))
  call Hloop_A_Q(ntryL,G1H2(39),111,nMB,G2H2(119),n2h2(55))
  call Hloop_VA_Q(ntryL,G1H4(15),ex6(:),G1H2(40),m3h2x2(:,128),heltab2x4(:,:,128))
  call Hloop_A_Q(ntryL,G1H2(40),111,nMB,G2H2(120),n2h2(56))
  call Hloop_VA_Q(ntryL,G1H4(4),ex4(:),G1H2(45),m3h2x2(:,129),heltab2x4(:,:,129))
  call Hloop_A_Q(ntryL,G1H2(45),123,nMT,G2H2(121),n2h2(57))
call HGT_raise_alpha_OLR(G1H4(16),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(16),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(16),ex3(:),G1H2(46),m3h2x2(:,130),heltab2x4(:,:,130))
  call Hloop_VA_Q(ntryL,G1H4(49),ex4(:),G1H2(51),m3h2x2(:,131),heltab2x4(:,:,131))
  call Hloop_A_Q(ntryL,G1H2(51),123,nMT,G2H2(122),n2h2(58))
  call Hloop_VA_Q(ntryL,G1H4(50),ex4(:),G1H2(52),m3h2x2(:,132),heltab2x4(:,:,132))
  call Hloop_A_Q(ntryL,G1H2(52),123,nMT,G2H2(123),n2h2(59))
  call Hloop_VQ_A(ntryL,G1H4(51),ex3(:),G1H2(57),m3h2x2(:,133),heltab2x4(:,:,133))
  call Hloop_Q_A(ntryL,G1H2(57),119,nMT,G2H2(124),n2h2(60))
call HGT_raise_alpha_OLR(G1H4(52),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(52),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(52),ex4(:),G1H2(58),m3h2x2(:,134),heltab2x4(:,:,134))
  call Hloop_VQ_A(ntryL,G1H4(55),ex3(:),G1H2(63),m3h2x2(:,135),heltab2x4(:,:,135))
  call Hloop_Q_A(ntryL,G1H2(63),119,nMT,G2H2(125),n2h2(61))
  call Hloop_VQ_A(ntryL,G1H4(56),ex3(:),G1H2(64),m3h2x2(:,136),heltab2x4(:,:,136))
  call Hloop_Q_A(ntryL,G1H2(64),119,nMT,G2H2(126),n2h2(62))
  call Hloop_QZ_A(ntryL,G1H8(33),wf4(:,4),G1H2(69),ngZd,m3h4x2(:,21),heltab2x8(:,:,111))
  call Hloop_Q_A(ntryL,G1H2(69),95,nMB,G2H2(127),n2h2(63))
call HGT_raise_alpha_OLR(G1H8(26),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(26),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(26),ex6(:),G1H4(45),m3h2x4(:,91),heltab2x8(:,:,112))
  call Hloop_QZ_A(ntryL,G1H8(45),wf4(:,4),G1H2(75),ngZd,m3h4x2(:,22),heltab2x8(:,:,113))
  call Hloop_Q_A(ntryL,G1H2(75),95,nMB,G2H2(128),n2h2(64))
  call Hloop_QZ_A(ntryL,G1H8(19),wf4(:,4),G1H2(76),ngZd,m3h4x2(:,23),heltab2x8(:,:,114))
  call Hloop_Q_A(ntryL,G1H2(76),95,nMB,G2H2(129),n2h2(65))
  call Hloop_VQ_A(ntryL,G1H4(57),ex3(:),G1H2(9),m3h2x2(:,137),heltab2x4(:,:,137))
  call Hloop_Q_A(ntryL,G1H2(9),119,nMT,G2H2(130),n2h2(66))
call HGT_raise_alpha_OLR(G1H4(58),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(58),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(58),ex4(:),G1H2(15),m3h2x2(:,138),heltab2x4(:,:,138))
  call Hloop_VQ_A(ntryL,G1H4(61),ex3(:),G1H2(16),m3h2x2(:,139),heltab2x4(:,:,139))
  call Hloop_Q_A(ntryL,G1H2(16),119,nMT,G2H2(131),n2h2(67))
  call Hloop_VQ_A(ntryL,G1H4(62),ex3(:),G1H2(21),m3h2x2(:,140),heltab2x4(:,:,140))
  call Hloop_Q_A(ntryL,G1H2(21),119,nMT,G2H2(132),n2h2(68))
  call Hloop_VA_Q(ntryL,G1H4(63),ex4(:),G1H2(27),m3h2x2(:,141),heltab2x4(:,:,141))
  call Hloop_A_Q(ntryL,G1H2(27),123,nMT,G2H2(133),n2h2(69))
call HGT_raise_alpha_OLR(G1H4(64),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(64),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(64),ex3(:),G1H2(28),m3h2x2(:,142),heltab2x4(:,:,142))
  call Hloop_VA_Q(ntryL,G1H4(67),ex4(:),G1H2(33),m3h2x2(:,143),heltab2x4(:,:,143))
  call Hloop_A_Q(ntryL,G1H2(33),123,nMT,G2H2(134),n2h2(70))
  call Hloop_VA_Q(ntryL,G1H4(68),ex4(:),G1H2(39),m3h2x2(:,144),heltab2x4(:,:,144))
  call Hloop_A_Q(ntryL,G1H2(39),123,nMT,G2H2(135),n2h2(71))
  call Hloop_AZ_Q(ntryL,G1H8(58),wf4(:,4),G1H2(40),ngZd,m3h4x2(:,24),heltab2x8(:,:,115))
  call Hloop_A_Q(ntryL,G1H2(40),111,nMB,G2H2(136),n2h2(72))
call HGT_raise_alpha_OLR(G1H8(64),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(64),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(64),ex5(:),G1H4(46),m3h2x4(:,92),heltab2x8(:,:,116))
  call Hloop_AZ_Q(ntryL,G1H8(32),wf4(:,4),G1H2(45),ngZd,m3h4x2(:,25),heltab2x8(:,:,117))
  call Hloop_A_Q(ntryL,G1H2(45),111,nMB,G2H2(137),n2h2(73))
  call Hloop_AZ_Q(ntryL,G1H8(62),wf4(:,4),G1H2(51),ngZd,m3h4x2(:,26),heltab2x8(:,:,118))
  call Hloop_A_Q(ntryL,G1H2(51),111,nMB,G2H2(138),n2h2(74))
  call Hloop_QZ_A(ntryL,G1H8(20),wf4(:,4),G1H2(52),ngZd,m3h4x2(:,27),heltab2x8(:,:,119))
  call Hloop_Q_A(ntryL,G1H2(52),95,nMB,G2H2(139),n2h2(75))
call HGT_raise_alpha_OLR(G1H8(23),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(23),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(23),ex6(:),G1H4(47),m3h2x4(:,93),heltab2x8(:,:,120))
  call Hloop_QZ_A(ntryL,G1H8(25),wf4(:,4),G1H2(57),ngZd,m3h4x2(:,28),heltab2x8(:,:,121))
  call Hloop_Q_A(ntryL,G1H2(57),95,nMB,G2H2(140),n2h2(76))
  call Hloop_QZ_A(ntryL,G1H8(35),wf4(:,4),G1H2(63),ngZd,m3h4x2(:,29),heltab2x8(:,:,122))
  call Hloop_Q_A(ntryL,G1H2(63),95,nMB,G2H2(141),n2h2(77))
  call Hloop_AZ_Q(ntryL,G1H8(36),wf4(:,4),G1H2(64),ngZd,m3h4x2(:,30),heltab2x8(:,:,123))
  call Hloop_A_Q(ntryL,G1H2(64),111,nMB,G2H2(142),n2h2(78))
call HGT_raise_alpha_OLR(G1H8(42),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(42),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(42),ex5(:),G1H4(25),m3h2x4(:,94),heltab2x8(:,:,124))
  call Hloop_AZ_Q(ntryL,G1H8(34),wf4(:,4),G1H2(69),ngZd,m3h4x2(:,31),heltab2x8(:,:,125))
  call Hloop_A_Q(ntryL,G1H2(69),111,nMB,G2H2(143),n2h2(79))
  call Hloop_AZ_Q(ntryL,G1H8(46),wf4(:,4),G1H2(75),ngZd,m3h4x2(:,32),heltab2x8(:,:,126))
  call Hloop_A_Q(ntryL,G1H2(75),111,nMB,G2H2(144),n2h2(80))
  call Hloop_QZ_A(ntryL,G1H8(3),wf4(:,4),G1H2(76),ngZd,m3h4x2(:,33),heltab2x8(:,:,127))
  call Hloop_Q_A(ntryL,G1H2(76),95,nMB,G2H2(145),n2h2(81))
call HGT_raise_alpha_OLR(G1H8(4),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(4),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(4),ex6(:),G1H4(26),m3h2x4(:,95),heltab2x8(:,:,128))
  call Hloop_QZ_A(ntryL,G1H8(51),wf4(:,4),G1H2(9),ngZd,m3h4x2(:,34),heltab2x8(:,:,129))
  call Hloop_Q_A(ntryL,G1H2(9),95,nMB,G2H2(146),n2h2(82))
  call Hloop_QZ_A(ntryL,G1H8(15),wf4(:,4),G1H2(16),ngZd,m3h4x2(:,35),heltab2x8(:,:,130))
  call Hloop_Q_A(ntryL,G1H2(16),95,nMB,G2H2(147),n2h2(83))
  call Hloop_VA_Q(ntryL,G1H4(69),ex6(:),G1H2(21),m3h2x2(:,145),heltab2x4(:,:,145))
  call Hloop_A_Q(ntryL,G1H2(21),111,nMB,G2H2(148),n2h2(84))
call HGT_raise_alpha_OLR(G1H4(70),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(70),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(70),ex5(:),G1H2(27),m3h2x2(:,146),heltab2x4(:,:,146))
  call Hloop_VA_Q(ntryL,G1H4(73),ex6(:),G1H2(33),m3h2x2(:,147),heltab2x4(:,:,147))
  call Hloop_A_Q(ntryL,G1H2(33),111,nMB,G2H2(149),n2h2(85))
  call Hloop_VA_Q(ntryL,G1H4(74),ex6(:),G1H2(39),m3h2x2(:,148),heltab2x4(:,:,148))
  call Hloop_A_Q(ntryL,G1H2(39),111,nMB,G2H2(150),n2h2(86))
  call Hloop_VQ_A(ntryL,G1H4(75),ex5(:),G1H2(40),m3h2x2(:,149),heltab2x4(:,:,149))
  call Hloop_Q_A(ntryL,G1H2(40),95,nMB,G2H2(151),n2h2(87))
call HGT_raise_alpha_OLR(G1H4(76),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(76),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(76),ex6(:),G1H2(45),m3h2x2(:,150),heltab2x4(:,:,150))
  call Hloop_VQ_A(ntryL,G1H4(79),ex5(:),G1H2(51),m3h2x2(:,151),heltab2x4(:,:,151))
  call Hloop_Q_A(ntryL,G1H2(51),95,nMB,G2H2(152),n2h2(88))
  call Hloop_VQ_A(ntryL,G1H4(80),ex5(:),G1H2(52),m3h2x2(:,152),heltab2x4(:,:,152))
  call Hloop_Q_A(ntryL,G1H2(52),95,nMB,G2H2(153),n2h2(89))
  call Hloop_QZ_A(ntryL,G1H8(16),wf4(:,4),G1H2(57),ngZu,m3h4x2(:,36),heltab2x8(:,:,131))
  call Hloop_Q_A(ntryL,G1H2(57),119,nMT,G2H2(154),n2h2(90))
call HGT_raise_alpha_OLR(G1H8(21),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(21),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(21),ex4(:),G1H4(36),m3h2x4(:,96),heltab2x8(:,:,132))
  call Hloop_QZ_A(ntryL,G1H8(56),wf4(:,4),G1H2(63),ngZu,m3h4x2(:,37),heltab2x8(:,:,133))
  call Hloop_Q_A(ntryL,G1H2(63),119,nMT,G2H2(155),n2h2(91))
  call Hloop_QZ_A(ntryL,G1H8(57),wf4(:,4),G1H2(64),ngZu,m3h4x2(:,38),heltab2x8(:,:,134))
  call Hloop_Q_A(ntryL,G1H2(64),119,nMT,G2H2(156),n2h2(92))
  call Hloop_AZ_Q(ntryL,G1H8(27),wf4(:,4),G1H2(69),ngZd,m3h4x2(:,39),heltab2x8(:,:,135))
  call Hloop_A_Q(ntryL,G1H2(69),111,nMB,G2H2(157),n2h2(93))
call HGT_raise_alpha_OLR(G1H8(28),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(28),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(28),ex5(:),G1H4(37),m3h2x4(:,97),heltab2x8(:,:,136))
  call Hloop_AZ_Q(ntryL,G1H8(49),wf4(:,4),G1H2(75),ngZd,m3h4x2(:,40),heltab2x8(:,:,137))
  call Hloop_A_Q(ntryL,G1H2(75),111,nMB,G2H2(158),n2h2(94))
  call Hloop_AZ_Q(ntryL,G1H8(61),wf4(:,4),G1H2(76),ngZd,m3h4x2(:,41),heltab2x8(:,:,138))
  call Hloop_A_Q(ntryL,G1H2(76),111,nMB,G2H2(159),n2h2(95))
  call Hloop_VQ_A(ntryL,G1H4(81),ex5(:),G1H2(9),m3h2x2(:,153),heltab2x4(:,:,153))
  call Hloop_Q_A(ntryL,G1H2(9),95,nMB,G2H2(160),n2h2(96))
call HGT_raise_alpha_OLR(G1H4(82),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(82),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(82),ex6(:),G1H2(16),m3h2x2(:,154),heltab2x4(:,:,154))
  call Hloop_VQ_A(ntryL,G1H4(85),ex5(:),G1H2(21),m3h2x2(:,155),heltab2x4(:,:,155))
  call Hloop_Q_A(ntryL,G1H2(21),95,nMB,G2H2(161),n2h2(97))
  call Hloop_VQ_A(ntryL,G1H4(86),ex5(:),G1H2(33),m3h2x2(:,156),heltab2x4(:,:,156))
  call Hloop_Q_A(ntryL,G1H2(33),95,nMB,G2H2(162),n2h2(98))
  call Hloop_VA_Q(ntryL,G1H4(87),ex6(:),G1H2(39),m3h2x2(:,157),heltab2x4(:,:,157))
  call Hloop_A_Q(ntryL,G1H2(39),111,nMB,G2H2(163),n2h2(99))
call HGT_raise_alpha_OLR(G1H4(88),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(88),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(88),ex5(:),G1H2(40),m3h2x2(:,158),heltab2x4(:,:,158))
  call Hloop_VA_Q(ntryL,G1H4(91),ex6(:),G1H2(51),m3h2x2(:,159),heltab2x4(:,:,159))
  call Hloop_A_Q(ntryL,G1H2(51),111,nMB,G2H2(164),n2h2(100))
  call Hloop_VA_Q(ntryL,G1H4(92),ex6(:),G1H2(52),m3h2x2(:,160),heltab2x4(:,:,160))
  call Hloop_A_Q(ntryL,G1H2(52),111,nMB,G2H2(165),n2h2(101))
  call Hloop_AZ_Q(ntryL,G1H8(24),wf4(:,4),G1H2(57),ngZu,m3h4x2(:,42),heltab2x8(:,:,139))
  call Hloop_A_Q(ntryL,G1H2(57),123,nMT,G2H2(166),n2h2(102))
call HGT_raise_alpha_OLR(G1H8(29),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(29),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(29),ex3(:),G1H4(38),m3h2x4(:,98),heltab2x8(:,:,140))
  call Hloop_AZ_Q(ntryL,G1H8(54),wf4(:,4),G1H2(63),ngZu,m3h4x2(:,43),heltab2x8(:,:,141))
  call Hloop_A_Q(ntryL,G1H2(63),123,nMT,G2H2(167),n2h2(103))
  call Hloop_AZ_Q(ntryL,G1H8(14),wf4(:,4),G1H2(64),ngZu,m3h4x2(:,44),heltab2x8(:,:,142))
  call Hloop_A_Q(ntryL,G1H2(64),123,nMT,G2H2(168),n2h2(104))
  call Hloop_VQ_A(ntryL,G1H4(93),ex5(:),G1H2(69),m3h2x2(:,161),heltab2x4(:,:,161))
  call Hloop_Q_A(ntryL,G1H2(69),95,nMB,G2H2(169),n2h2(105))
call HGT_raise_alpha_OLR(G1H4(94),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(94),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(94),ex6(:),G1H2(75),m3h2x2(:,162),heltab2x4(:,:,162))
  call Hloop_VQ_A(ntryL,G1H4(97),ex5(:),G1H2(76),m3h2x2(:,163),heltab2x4(:,:,163))
  call Hloop_Q_A(ntryL,G1H2(76),95,nMB,G2H2(170),n2h2(106))
  call Hloop_VQ_A(ntryL,G1H4(98),ex5(:),G1H2(9),m3h2x2(:,164),heltab2x4(:,:,164))
  call Hloop_Q_A(ntryL,G1H2(9),95,nMB,G2H2(171),n2h2(107))
  call Hloop_VA_Q(ntryL,G1H4(9),ex6(:),G1H2(21),m3h2x2(:,165),heltab2x4(:,:,165))
  call Hloop_A_Q(ntryL,G1H2(21),111,nMB,G2H2(172),n2h2(108))
call HGT_raise_alpha_OLR(G1H4(10),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(10),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(10),ex5(:),G1H2(33),m3h2x2(:,166),heltab2x4(:,:,166))
  call Hloop_VA_Q(ntryL,G1H4(100),ex6(:),G1H2(39),m3h2x2(:,167),heltab2x4(:,:,167))
  call Hloop_A_Q(ntryL,G1H2(39),111,nMB,G2H2(173),n2h2(109))
  call Hloop_VA_Q(ntryL,G1H4(101),ex6(:),G1H2(51),m3h2x2(:,168),heltab2x4(:,:,168))
  call Hloop_A_Q(ntryL,G1H2(51),111,nMB,G2H2(174),n2h2(110))
  call Hloop_VQ_A(ntryL,G1H4(21),ex5(:),G1H2(52),m3h2x2(:,169),heltab2x4(:,:,169))
  call Hloop_Q_A(ntryL,G1H2(52),95,nMB,G2H2(175),n2h2(111))
call HGT_raise_alpha_OLR(G1H4(22),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(22),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(22),ex6(:),G1H2(57),m3h2x2(:,170),heltab2x4(:,:,170))
  call Hloop_VQ_A(ntryL,G1H4(103),ex5(:),G1H2(63),m3h2x2(:,171),heltab2x4(:,:,171))
  call Hloop_Q_A(ntryL,G1H2(63),95,nMB,G2H2(176),n2h2(112))
  call Hloop_VQ_A(ntryL,G1H4(104),ex5(:),G1H2(64),m3h2x2(:,172),heltab2x4(:,:,172))
  call Hloop_Q_A(ntryL,G1H2(64),95,nMB,G2H2(177),n2h2(113))
  call Hloop_VA_Q(ntryL,G1H4(33),ex6(:),G1H2(69),m3h2x2(:,173),heltab2x4(:,:,173))
  call Hloop_A_Q(ntryL,G1H2(69),111,nMB,G2H2(178),n2h2(114))
call HGT_raise_alpha_OLR(G1H4(34),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(34),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(34),ex5(:),G1H2(76),m3h2x2(:,174),heltab2x4(:,:,174))
  call Hloop_VA_Q(ntryL,G1H4(106),ex6(:),G1H2(9),m3h2x2(:,175),heltab2x4(:,:,175))
  call Hloop_A_Q(ntryL,G1H2(9),111,nMB,G2H2(179),n2h2(115))
  call Hloop_VA_Q(ntryL,G1H4(107),ex6(:),G1H2(21),m3h2x2(:,176),heltab2x4(:,:,176))
  call Hloop_A_Q(ntryL,G1H2(21),111,nMB,G2H2(180),n2h2(116))
  call Hloop_QZ_A(ntryL,G1H8(60),wf4(:,4),G1H2(39),ngZd,m3h4x2(:,45),heltab2x8(:,:,143))
  call Hloop_Q_A(ntryL,G1H2(39),95,nMB,G2H2(181),n2h2(117))
call HGT_raise_alpha_OLR(G1H8(30),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(30),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(30),ex6(:),G1H4(43),m3h2x4(:,99),heltab2x8(:,:,144))
  call Hloop_QZ_A(ntryL,G1H8(2),wf4(:,4),G1H2(51),ngZd,m3h4x2(:,46),heltab2x8(:,:,145))
  call Hloop_Q_A(ntryL,G1H2(51),95,nMB,G2H2(182),n2h2(118))
  call Hloop_QZ_A(ntryL,G1H8(133),wf4(:,4),G1H2(52),ngZd,m3h4x2(:,47),heltab2x8(:,:,146))
  call Hloop_Q_A(ntryL,G1H2(52),95,nMB,G2H2(183),n2h2(119))
call HGT_raise_alpha_OLR(G1H8(8),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(8),ex6(:),G1H4(12),m3h2x4(:,100),heltab2x8(:,:,147))
  call Hloop_QZ_A(ntryL,G1H8(13),wf4(:,4),G1H2(63),ngZd,m3h4x2(:,48),heltab2x8(:,:,148))
  call Hloop_Q_A(ntryL,G1H2(63),95,nMB,G2H2(184),n2h2(120))
  call Hloop_AZ_Q(ntryL,G1H8(18),wf4(:,4),G1H2(64),ngZd,m3h4x2(:,49),heltab2x8(:,:,149))
  call Hloop_A_Q(ntryL,G1H2(64),111,nMB,G2H2(185),n2h2(121))
call HGT_raise_alpha_OLR(G1H8(69),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(69),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(69),ex5(:),G1H4(13),m3h2x4(:,101),heltab2x8(:,:,150))
  call Hloop_AZ_Q(ntryL,G1H8(37),wf4(:,4),G1H2(69),ngZd,m3h4x2(:,50),heltab2x8(:,:,151))
  call Hloop_A_Q(ntryL,G1H2(69),111,nMB,G2H2(186),n2h2(122))
  call Hloop_AZ_Q(ntryL,G1H8(138),wf4(:,4),G1H2(9),ngZd,m3h4x2(:,51),heltab2x8(:,:,152))
  call Hloop_A_Q(ntryL,G1H2(9),111,nMB,G2H2(187),n2h2(123))
call HGT_raise_alpha_OLR(G1H8(74),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(74),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(74),ex5(:),G1H4(14),m3h2x4(:,102),heltab2x8(:,:,153))
  call Hloop_AZ_Q(ntryL,G1H8(77),wf4(:,4),G1H2(21),ngZd,m3h4x2(:,52),heltab2x8(:,:,154))
  call Hloop_A_Q(ntryL,G1H2(21),111,nMB,G2H2(188),n2h2(124))
  call Hloop_QZ_A(ntryL,G1H8(41),wf4(:,4),G1H2(39),ngZd,m3h4x2(:,53),heltab2x8(:,:,155))
  call Hloop_Q_A(ntryL,G1H2(39),95,nMB,G2H2(189),n2h2(125))
call HGT_raise_alpha_OLR(G1H8(78),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(78),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(78),ex6(:),G1H4(19),m3h2x4(:,103),heltab2x8(:,:,156))
  call Hloop_QZ_A(ntryL,G1H8(81),wf4(:,4),G1H2(51),ngZd,m3h4x2(:,54),heltab2x8(:,:,157))
  call Hloop_Q_A(ntryL,G1H2(51),95,nMB,G2H2(190),n2h2(126))
  call Hloop_QZ_A(ntryL,G1H8(82),wf4(:,4),G1H2(52),ngZd,m3h4x2(:,55),heltab2x8(:,:,158))
  call Hloop_Q_A(ntryL,G1H2(52),95,nMB,G2H2(191),n2h2(127))
  call Hloop_AZ_Q(ntryL,G1H8(53),wf4(:,4),G1H2(63),ngZd,m3h4x2(:,56),heltab2x8(:,:,159))
  call Hloop_A_Q(ntryL,G1H2(63),111,nMB,G2H2(192),n2h2(128))
call HGT_raise_alpha_OLR(G1H8(55),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(55),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(55),ex5(:),G1H4(5),m3h2x4(:,104),heltab2x8(:,:,160))
  call Hloop_AZ_Q(ntryL,G1H8(85),wf4(:,4),G1H2(64),ngZd,m3h4x2(:,57),heltab2x8(:,:,161))
  call Hloop_A_Q(ntryL,G1H2(64),111,nMB,G2H2(193),n2h2(129))
  call Hloop_AZ_Q(ntryL,G1H8(86),wf4(:,4),G1H2(69),ngZd,m3h4x2(:,58),heltab2x8(:,:,162))
  call Hloop_A_Q(ntryL,G1H2(69),111,nMB,G2H2(194),n2h2(130))
  call Hloop_VA_Q(ntryL,G1H8(65),ex6(:),G1H4(17),m3h2x4(:,105),heltab2x8(:,:,163))
  call Hloop_A_Q(ntryL,G1H4(17),115,nMB,G2H4(54),n2h4(119))
call HGT_OLR(G1H8(67),1,1,8)
call HGT_invQ_OLR(G1H8(67),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(67),-12,nMB,G2H8(13),n2h8(107))
  call Hloop_QV_A(ntryL,G2H8(13),wf4(:,2),G2H2(195),m3h4x2(:,59),heltab2x8(:,:,164))
  call Hloop_VA_Q(ntryL,G1H8(89),ex6(:),G1H4(29),m3h2x4(:,106),heltab2x8(:,:,165))
  call Hloop_A_Q(ntryL,G1H4(29),115,nMB,G2H4(41),n2h4(120))
  call Hloop_VA_Q(ntryL,G1H8(90),ex6(:),G1H4(41),m3h2x4(:,107),heltab2x8(:,:,166))
  call Hloop_A_Q(ntryL,G1H4(41),115,nMB,G2H4(44),n2h4(121))
  call Hloop_VQ_A(ntryL,G1H8(91),ex5(:),G1H4(27),m3h2x4(:,108),heltab2x8(:,:,167))
  call Hloop_Q_A(ntryL,G1H4(27),115,nMB,G2H4(57),n2h4(122))
call HGT_OLR(G1H8(92),1,1,8)
call HGT_invQ_OLR(G1H8(92),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(92),-12,nMB,G2H8(17),n2h8(108))
  call Hloop_AV_Q(ntryL,G2H8(17),wf4(:,2),G2H2(196),m3h4x2(:,60),heltab2x8(:,:,168))
  call Hloop_VQ_A(ntryL,G1H8(95),ex5(:),G1H4(15),m3h2x4(:,109),heltab2x8(:,:,169))
  call Hloop_Q_A(ntryL,G1H4(15),115,nMB,G2H4(56),n2h4(123))
  call Hloop_VQ_A(ntryL,G1H8(96),ex5(:),G1H4(4),m3h2x4(:,110),heltab2x8(:,:,170))
  call Hloop_Q_A(ntryL,G1H4(4),115,nMB,G2H4(55),n2h4(124))
  call Hloop_UV_W(ntryL,G1H8(97),99,wf4(:,2),12,G2H2(197),m3h4x2(:,61),heltab2x8(:,:,171))
call HGT_OLR(G1H8(98),1,1,8)
call HGT_invQ_OLR(G1H8(98),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(98),-16,nMB,G2H8(20),n2h8(109))
  call Hloop_AQ_V(ntryL,G2H8(20),ex5(:),G2H4(65),m3h2x4(:,111),heltab2x8(:,:,172))
  call Hloop_UV_W(ntryL,G1H8(101),99,wf4(:,2),12,G2H2(198),m3h4x2(:,62),heltab2x8(:,:,173))
  call Hloop_UV_W(ntryL,G1H8(102),99,wf4(:,2),12,G2H2(199),m3h4x2(:,63),heltab2x8(:,:,174))
  call Hloop_UV_W(ntryL,G1H8(103),83,wf4(:,2),12,G2H2(200),m3h4x2(:,64),heltab2x8(:,:,175))
call HGT_OLR(G1H8(104),1,1,8)
call HGT_invQ_OLR(G1H8(104),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(104),-32,nMB,G2H8(24),n2h8(110))
  call Hloop_QA_V(ntryL,G2H8(24),ex6(:),G2H4(64),m3h2x4(:,112),heltab2x8(:,:,176))
  call Hloop_UV_W(ntryL,G1H8(107),83,wf4(:,2),12,G2H2(201),m3h4x2(:,65),heltab2x8(:,:,177))
  call Hloop_UV_W(ntryL,G1H8(108),83,wf4(:,2),12,G2H2(202),m3h4x2(:,66),heltab2x8(:,:,178))
  call Hloop_AZ_Q(ntryL,G1H16(39),wf4(:,4),G1H4(16),ngZu,m3h4x4(:,47),heltab2x16(:,:,111))
  call Hloop_A_Q(ntryL,G1H4(16),79,nMT,G2H4(68),n2h4(125))
call HGT_OLR(G1H16(40),1,1,16)
call HGT_invQ_OLR(G1H16(40),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(40),-48,nMT,G2H16(19),n2h16(57))
  call Hloop_QV_A(ntryL,G2H16(19),wf4(:,9),G2H4(67),m3h4x4(:,48),heltab2x16(:,:,112))
  call Hloop_AZ_Q(ntryL,G1H16(46),wf4(:,4),G1H4(49),ngZu,m3h4x4(:,49),heltab2x16(:,:,113))
  call Hloop_A_Q(ntryL,G1H4(49),79,nMT,G2H4(14),n2h4(126))
  call Hloop_AZ_Q(ntryL,G1H16(47),wf4(:,4),G1H4(50),ngZu,m3h4x4(:,50),heltab2x16(:,:,114))
  call Hloop_A_Q(ntryL,G1H4(50),79,nMT,G2H4(15),n2h4(127))
  call Hloop_QZ_A(ntryL,G1H16(48),wf4(:,4),G1H4(51),ngZu,m3h4x4(:,51),heltab2x16(:,:,115))
  call Hloop_Q_A(ntryL,G1H4(51),79,nMT,G2H4(18),n2h4(128))
call HGT_OLR(G1H16(52),1,1,16)
call HGT_invQ_OLR(G1H16(52),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(52),-48,nMT,G2H16(3),n2h16(58))
  call Hloop_AV_Q(ntryL,G2H16(3),wf4(:,9),G2H4(19),m3h4x4(:,52),heltab2x16(:,:,116))
  call Hloop_QZ_A(ntryL,G1H16(9),wf4(:,4),G1H4(52),ngZu,m3h4x4(:,53),heltab2x16(:,:,117))
  call Hloop_Q_A(ntryL,G1H4(52),79,nMT,G2H4(22),n2h4(129))
  call Hloop_QZ_A(ntryL,G1H16(10),wf4(:,4),G1H4(55),ngZu,m3h4x4(:,54),heltab2x16(:,:,118))
  call Hloop_Q_A(ntryL,G1H4(55),79,nMT,G2H4(23),n2h4(130))
  call Hloop_VA_Q(ntryL,G1H8(109),ex4(:),G1H4(56),m3h2x4(:,113),heltab2x8(:,:,179))
  call Hloop_A_Q(ntryL,G1H4(56),79,nMT,G2H4(26),n2h4(131))
call HGT_OLR(G1H8(110),1,1,8)
call HGT_invQ_OLR(G1H8(110),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(110),-48,nMT,G2H8(1),n2h8(111))
  call Hloop_QV_A(ntryL,G2H8(1),wf4(:,9),G2H2(203),m3h4x2(:,67),heltab2x8(:,:,180))
  call Hloop_VA_Q(ntryL,G1H8(113),ex4(:),G1H4(57),m3h2x4(:,114),heltab2x8(:,:,181))
  call Hloop_A_Q(ntryL,G1H4(57),79,nMT,G2H4(27),n2h4(132))
  call Hloop_VA_Q(ntryL,G1H8(114),ex4(:),G1H4(58),m3h2x4(:,115),heltab2x8(:,:,182))
  call Hloop_A_Q(ntryL,G1H4(58),79,nMT,G2H4(69),n2h4(133))
  call Hloop_VQ_A(ntryL,G1H8(115),ex3(:),G1H4(61),m3h2x4(:,116),heltab2x8(:,:,183))
  call Hloop_Q_A(ntryL,G1H4(61),79,nMT,G2H4(33),n2h4(134))
call HGT_OLR(G1H8(116),1,1,8)
call HGT_invQ_OLR(G1H8(116),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(116),-48,nMT,G2H8(7),n2h8(112))
  call Hloop_AV_Q(ntryL,G2H8(7),wf4(:,9),G2H2(204),m3h4x2(:,68),heltab2x8(:,:,184))
  call Hloop_VQ_A(ntryL,G1H8(119),ex3(:),G1H4(62),m3h2x4(:,117),heltab2x8(:,:,185))
  call Hloop_Q_A(ntryL,G1H4(62),79,nMT,G2H4(34),n2h4(135))
  call Hloop_VQ_A(ntryL,G1H8(120),ex3(:),G1H4(63),m3h2x4(:,118),heltab2x8(:,:,186))
  call Hloop_Q_A(ntryL,G1H4(63),79,nMT,G2H4(37),n2h4(136))
  call Hloop_UV_W(ntryL,G1H8(121),75,wf4(:,9),48,G2H2(205),m3h4x2(:,69),heltab2x8(:,:,187))
call HGT_OLR(G1H8(122),1,1,8)
call HGT_invQ_OLR(G1H8(122),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(122),-4,nMT,G2H8(3),n2h8(113))
  call Hloop_AQ_V(ntryL,G2H8(3),ex3(:),G2H4(38),m3h2x4(:,119),heltab2x8(:,:,188))
  call Hloop_UV_W(ntryL,G1H8(125),75,wf4(:,9),48,G2H2(206),m3h4x2(:,70),heltab2x8(:,:,189))
  call Hloop_UV_W(ntryL,G1H8(126),75,wf4(:,9),48,G2H2(207),m3h4x2(:,71),heltab2x8(:,:,190))
  call Hloop_UV_W(ntryL,G1H8(127),71,wf4(:,9),48,G2H2(208),m3h4x2(:,72),heltab2x8(:,:,191))
call HGT_OLR(G1H8(128),1,1,8)
call HGT_invQ_OLR(G1H8(128),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(128),-8,nMT,G2H8(8),n2h8(114))
  call Hloop_QA_V(ntryL,G2H8(8),ex4(:),G2H4(63),m3h2x4(:,120),heltab2x8(:,:,192))
  call Hloop_UV_W(ntryL,G1H8(131),71,wf4(:,9),48,G2H2(209),m3h4x2(:,73),heltab2x8(:,:,193))
  call Hloop_UV_W(ntryL,G1H8(132),71,wf4(:,9),48,G2H2(210),m3h4x2(:,74),heltab2x8(:,:,194))
  call Hloop_VA_Q(ntryL,G1H16(12),ex6(:),G1H8(47),m3h2x8(:,61),heltab2x16(:,:,119))
  call Hloop_A_Q(ntryL,G1H8(47),108,nMB,G2H8(25),n2h8(115))
call HGT_raise_alpha_OLR(G1H16(15),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(15),2,5,16)
  call Hloop_VQ_A(ntryL,G1H16(15),wf8(:,6),G1H2(9),m3h8x2(:,5),heltab2x16(:,:,120))
  call Hloop_VA_Q(ntryL,G1H16(18),ex6(:),G1H8(59),m3h2x8(:,62),heltab2x16(:,:,121))
  call Hloop_A_Q(ntryL,G1H8(59),108,nMB,G2H8(27),n2h8(116))
  call Hloop_VA_Q(ntryL,G1H16(22),ex6(:),G1H8(72),m3h2x8(:,63),heltab2x16(:,:,122))
  call Hloop_A_Q(ntryL,G1H8(72),108,nMB,G2H8(18),n2h8(117))
  call Hloop_VA_Q(ntryL,G1H16(23),ex6(:),G1H8(73),m3h2x8(:,64),heltab2x16(:,:,123))
  call Hloop_A_Q(ntryL,G1H8(73),108,nMB,G2H8(22),n2h8(118))
call HGT_raise_alpha_OLR(G1H16(24),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(24),2,5,16)
  call Hloop_VQ_A(ntryL,G1H16(24),wf8(:,6),G1H2(21),m3h8x2(:,6),heltab2x16(:,:,124))
  call Hloop_VA_Q(ntryL,G1H16(36),ex6(:),G1H8(147),m3h2x8(:,65),heltab2x16(:,:,125))
  call Hloop_A_Q(ntryL,G1H8(147),108,nMB,G2H8(16),n2h8(119))
  call Hloop_VA_Q(ntryL,G1H16(37),ex6(:),G1H8(148),m3h2x8(:,66),heltab2x16(:,:,126))
  call Hloop_A_Q(ntryL,G1H8(148),108,nMB,G2H8(19),n2h8(120))
  call Hloop_VQ_A(ntryL,G1H16(34),wf8(:,6),G1H2(39),m3h8x2(:,7),heltab2x16(:,:,127))
  call Hloop_Q_A(ntryL,G1H2(39),95,nMB,G2H2(211),n2h2(131))
call HGT_raise_alpha_OLR(G1H16(7),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(7),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(7),ex6(:),G1H8(163),m3h2x8(:,67),heltab2x16(:,:,128))
  call Hloop_VQ_A(ntryL,G1H16(26),wf8(:,6),G1H2(51),m3h8x2(:,8),heltab2x16(:,:,129))
  call Hloop_Q_A(ntryL,G1H2(51),95,nMB,G2H2(212),n2h2(132))
  call Hloop_VQ_A(ntryL,G1H16(14),wf8(:,6),G1H2(52),m3h8x2(:,9),heltab2x16(:,:,130))
  call Hloop_Q_A(ntryL,G1H2(52),95,nMB,G2H2(213),n2h2(133))
  call Hloop_VQ_A(ntryL,G1H16(25),wf8(:,6),G1H2(63),m3h8x2(:,10),heltab2x16(:,:,131))
  call Hloop_Q_A(ntryL,G1H2(63),95,nMB,G2H2(214),n2h2(134))
call HGT_raise_alpha_OLR(G1H16(1),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(1),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(1),ex6(:),G1H8(164),m3h2x8(:,68),heltab2x16(:,:,132))
  call Hloop_VQ_A(ntryL,G1H16(29),wf8(:,6),G1H2(64),m3h8x2(:,11),heltab2x16(:,:,133))
  call Hloop_Q_A(ntryL,G1H2(64),95,nMB,G2H2(215),n2h2(135))
  call Hloop_VQ_A(ntryL,G1H16(27),wf8(:,6),G1H2(69),m3h8x2(:,12),heltab2x16(:,:,134))
  call Hloop_Q_A(ntryL,G1H2(69),95,nMB,G2H2(216),n2h2(136))
  call Hloop_VQ_A(ntryL,G1H16(28),ex5(:),G1H8(179),m3h2x8(:,69),heltab2x16(:,:,135))
  call Hloop_Q_A(ntryL,G1H8(179),92,nMB,G2H8(12),n2h8(121))
call HGT_raise_alpha_OLR(G1H16(32),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(32),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(32),wf8(:,2),G1H2(39),m3h8x2(:,13),heltab2x16(:,:,136))
  call Hloop_VQ_A(ntryL,G1H16(53),ex5(:),G1H8(180),m3h2x8(:,70),heltab2x16(:,:,137))
  call Hloop_Q_A(ntryL,G1H8(180),92,nMB,G2H8(15),n2h8(122))
  call Hloop_VQ_A(ntryL,G1H16(54),ex5(:),G1H8(195),m3h2x8(:,71),heltab2x16(:,:,138))
  call Hloop_Q_A(ntryL,G1H8(195),92,nMB,G2H8(21),n2h8(123))
  call Hloop_VQ_A(ntryL,G1H16(55),ex5(:),G1H8(196),m3h2x8(:,72),heltab2x16(:,:,139))
  call Hloop_Q_A(ntryL,G1H8(196),92,nMB,G2H8(23),n2h8(124))
call HGT_raise_alpha_OLR(G1H16(56),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(56),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(56),wf8(:,2),G1H2(51),m3h8x2(:,14),heltab2x16(:,:,140))
  call Hloop_VQ_A(ntryL,G1H16(59),ex5(:),G1H8(33),m3h2x8(:,73),heltab2x16(:,:,141))
  call Hloop_Q_A(ntryL,G1H8(33),92,nMB,G2H8(2),n2h8(125))
  call Hloop_VQ_A(ntryL,G1H16(60),ex5(:),G1H8(26),m3h2x8(:,74),heltab2x16(:,:,142))
  call Hloop_Q_A(ntryL,G1H8(26),92,nMB,G2H8(6),n2h8(126))
  call Hloop_VA_Q(ntryL,G1H16(61),wf8(:,2),G1H2(52),m3h8x2(:,15),heltab2x16(:,:,143))
  call Hloop_A_Q(ntryL,G1H2(52),111,nMB,G2H2(217),n2h2(137))
call HGT_raise_alpha_OLR(G1H16(62),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(62),2,5,16)
  call Hloop_VQ_A(ntryL,G1H16(62),ex5(:),G1H8(45),m3h2x8(:,75),heltab2x16(:,:,144))
  call Hloop_VA_Q(ntryL,G1H16(65),wf8(:,2),G1H2(63),m3h8x2(:,16),heltab2x16(:,:,145))
  call Hloop_A_Q(ntryL,G1H2(63),111,nMB,G2H2(218),n2h2(138))
  call Hloop_VA_Q(ntryL,G1H16(66),wf8(:,2),G1H2(64),m3h8x2(:,17),heltab2x16(:,:,146))
  call Hloop_A_Q(ntryL,G1H2(64),111,nMB,G2H2(219),n2h2(139))
  call Hloop_VA_Q(ntryL,G1H16(67),wf8(:,2),G1H2(69),m3h8x2(:,18),heltab2x16(:,:,147))
  call Hloop_A_Q(ntryL,G1H2(69),111,nMB,G2H2(220),n2h2(140))
call HGT_raise_alpha_OLR(G1H16(68),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(68),2,5,16)



end subroutine vamp_1

end module ol_vamp_1_ppllttj_nenexttxbbxg_1_/**/REALKIND
