
module ol_colourmatrix_ppllttj_eexttxggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(6,6), K2(6,11), KL(6,11), Cas(7)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1(1,:) = [ 64, -8, -8,  1,  1, 10]
  K1(2,:) = [ -8, 64,  1, 10, -8,  1]
  K1(3,:) = [ -8,  1, 64, -8, 10,  1]
  K1(4,:) = [  1, 10, -8, 64,  1, -8]
  K1(5,:) = [  1, -8, 10,  1, 64, -8]
  K1(6,:) = [ 10,  1,  1, -8, -8, 64]
  K1 = (1._/**/REALKIND / 9) * K1

  K2(1,:) = [ 64, -8, -8,  1,  1, 10, 24, -3, 24, 21, -6]
  K2(2,:) = [ -8, 64,  1, 10, -8,  1, -3, 24, 24, -6, 21]
  K2(3,:) = [ -8,  1, 64, -8, 10,  1, 24, 24, -3, -6, 21]
  K2(4,:) = [  1, 10, -8, 64,  1, -8, -3, 24, 24, 21, -6]
  K2(5,:) = [  1, -8, 10,  1, 64, -8, 24, 24, -3, 21, -6]
  K2(6,:) = [ 10,  1,  1, -8, -8, 64, 24, -3, 24, -6, 21]
  K2 = (1._/**/REALKIND / 9) * K2

  KL(1,:) = [ 64, -8, -8,  1,  1, 10, 24, -3, 24, 21, -6]
  KL(2,:) = [ -8, 64,  1, 10, -8,  1, -3, 24, 24, -6, 21]
  KL(3,:) = [ -8,  1, 64, -8, 10,  1, 24, 24, -3, -6, 21]
  KL(4,:) = [  1, 10, -8, 64,  1, -8, -3, 24, 24, 21, -6]
  KL(5,:) = [  1, -8, 10,  1, 64, -8, 24, 24, -3, 21, -6]
  KL(6,:) = [ 10,  1,  1, -8, -8, 64, 24, -3, 24, -6, 21]
  KL = (1._/**/REALKIND / 9) * KL
  Cas = 0
  end subroutine colourmatrix_init
end module ol_colourmatrix_ppllttj_eexttxggg_1_/**/REALKIND



module ol_forced_parameters_ppllttj_eexttxggg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppllttj_eexttxggg_1_/**/REALKIND
! **********************************************************************
module ol_loop_storage_ppllttj_eexttxggg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntry = 1, ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer(intkind2), parameter :: nheltot = 128 ! number of helicity configurations
  integer(intkind2), save :: nhel = 128 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(128) ! physical helicity states
#endif

  complex(REALKIND), save :: den(1460)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2), ex7(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,49), wf8(8,212), wf16(16,323), wf32(32,270), wf128(128,969)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(44), c(54)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(11,128), M0M1_hel_cc(11,128,29)
  complex(REALKIND), save :: M2ctcc(29)

end module ol_loop_storage_ppllttj_eexttxggg_1_/**/REALKIND






! **********************************************************************
module ol_loop_ppllttj_eexttxggg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppllttj_eexttxggg_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (2*CI*eQED**2*gQCD**3)/3._/**/REALKIND
    f( 2) = CI*eQED**2*gQCD**3
    f( 3) = (2*eQED**2*gQCD**3)/3._/**/REALKIND
    f( 4) = eQED**2*gQCD**3
    f( 5) = (2*CI*countertermnorm*eQED**2*gQCD**5)/3._/**/REALKIND
    f( 6) = CI*countertermnorm*eQED**2*gQCD**5
    f( 7) = (2*countertermnorm*eQED**2*gQCD**5)/3._/**/REALKIND
    f( 8) = countertermnorm*eQED**2*gQCD**5
    f( 9) = (2*CI*countertermnorm*ctGtt*eQED**2*gQCD**5)/3._/**/REALKIND
    f(10) = CI*countertermnorm*ctGtt*eQED**2*gQCD**5
    f(11) = (2*countertermnorm*ctGtt*eQED**2*gQCD**5)/3._/**/REALKIND
    f(12) = countertermnorm*ctGtt*eQED**2*gQCD**5
    f(13) = (2*CI*countertermnorm*ctVtt*eQED**2*gQCD**5)/3._/**/REALKIND
    f(14) = CI*countertermnorm*ctVtt*eQED**2*gQCD**5
    f(15) = (2*countertermnorm*ctVtt*eQED**2*gQCD**5)/3._/**/REALKIND
    f(16) = countertermnorm*ctVtt*eQED**2*gQCD**5
    f(17) = (2*CI*countertermnorm*ctVVV*eQED**2*gQCD**5)/3._/**/REALKIND
    f(18) = CI*countertermnorm*ctVVV*eQED**2*gQCD**5
    f(19) = (2*countertermnorm*ctVVV*eQED**2*gQCD**5)/3._/**/REALKIND
    f(20) = countertermnorm*ctVVV*eQED**2*gQCD**5
    f(21) = (2*CI*countertermnorm*ctVVVV*eQED**2*gQCD**5)/3._/**/REALKIND
    f(22) = CI*countertermnorm*ctVVVV*eQED**2*gQCD**5
    f(23) = CI*countertermnorm*ctZGG*eQED**2*gQCD**5
    f(24) = countertermnorm*ctZGG*eQED**2*gQCD**5
    f(25) = (2*CI*countertermnorm*eQED**2*gQCD**5*R2GGGG)/3._/**/REALKIND
    f(26) = CI*countertermnorm*eQED**2*gQCD**5*R2GGGG
    f(27) = (CI*eQED**2*gQCD**5*integralnorm*SwB)/3._/**/REALKIND
    f(28) = (CI*eQED**2*gQCD**5*integralnorm*SwB)/2._/**/REALKIND
    f(29) = (2*CI*eQED**2*gQCD**5*integralnorm*SwB)/3._/**/REALKIND
    f(30) = CI*eQED**2*gQCD**5*integralnorm*SwB
    f(31) = (eQED**2*gQCD**5*integralnorm*SwB)/3._/**/REALKIND
    f(32) = (eQED**2*gQCD**5*integralnorm*SwB)/2._/**/REALKIND
    f(33) = (2*eQED**2*gQCD**5*integralnorm*SwB)/3._/**/REALKIND
    f(34) = eQED**2*gQCD**5*integralnorm*SwB
    f(35) = (CI*eQED**2*gQCD**5*integralnorm*SwF)/3._/**/REALKIND
    f(36) = (2*CI*eQED**2*gQCD**5*integralnorm*SwF)/3._/**/REALKIND
    f(37) = CI*eQED**2*gQCD**5*integralnorm*SwF
    f(38) = (4*CI*eQED**2*gQCD**5*integralnorm*SwF)/3._/**/REALKIND
    f(39) = 2*CI*eQED**2*gQCD**5*integralnorm*SwF
    f(40) = (eQED**2*gQCD**5*integralnorm*SwF)/3._/**/REALKIND
    f(41) = (2*eQED**2*gQCD**5*integralnorm*SwF)/3._/**/REALKIND
    f(42) = eQED**2*gQCD**5*integralnorm*SwF
    f(43) = (4*eQED**2*gQCD**5*integralnorm*SwF)/3._/**/REALKIND
    f(44) = 2*eQED**2*gQCD**5*integralnorm*SwF

  c = [ 9*CI*f(27), 18*CI*f(27), 9*CI*f(28), 18*CI*f(28), CI*f(29), 3*CI*f(29), 8*CI*f(29), 9*CI*f(29), 18*CI*f(29), CI*f(30) &
    , 3*CI*f(30), 8*CI*f(30), 9*CI*f(30), 18*CI*f(30), 3*f(31), 6*f(31), 9*f(31), 18*f(31), 3*f(32), 6*f(32), 9*f(32), 18*f(32) &
    , f(33), 3*f(33), 6*f(33), 8*f(33), 9*f(33), 18*f(33), f(34), 3*f(34), 6*f(34), 8*f(34), 9*f(34), 18*f(34), CI*f(35) &
    , 3*CI*f(35), CI*f(36), 3*CI*f(36), CI*f(37), 3*CI*f(37), CI*f(38), 3*CI*f(38), CI*f(39), 3*CI*f(39), f(40), 3*f(40), f(41) &
    , 3*f(41), f(42), 3*f(42), f(43), 3*f(43), f(44), 3*f(44) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3))+L(6,3))
  den(2) = 1 /((L(5,112))+L(6,112))
  den(3) = 1 /((L(5,7) - MT2)+L(6,7))
  den(6) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(9) = 1 /((L(5,116) - MT2)+L(6,116))
  den(13) = 1 /((L(5,20) - MT2)+L(6,20))
  den(14) = 1 /((L(5,40) - MT2)+L(6,40))
  den(16) = 1 /((L(5,84) - MT2)+L(6,84))
  den(22) = 1 /((L(5,104) - MT2)+L(6,104))
  den(27) = 1 /((L(5,72) - MT2)+L(6,72))
  den(29) = 1 /((L(5,52) - MT2)+L(6,52))
  den(37) = 1 /((L(5,96))+L(6,96))
  den(39) = 1 /((L(5,11) - MT2)+L(6,11))
  den(51) = 1 /((L(5,36) - MT2)+L(6,36))
  den(52) = 1 /((L(5,24) - MT2)+L(6,24))
  den(54) = 1 /((L(5,100) - MT2)+L(6,100))
  den(60) = 1 /((L(5,88) - MT2)+L(6,88))
  den(65) = 1 /((L(5,68) - MT2)+L(6,68))
  den(70) = 1 /((L(5,56) - MT2)+L(6,56))
  den(91) = 1 /((L(5,80))+L(6,80))
  den(118) = 1 /((L(5,48))+L(6,48))
  den(166) = 1 /((L(5,12))+L(6,12))
  den(173) = 1 /((L(5,28))+L(6,28))
  den(178) = 1 /((L(5,60))+L(6,60))
  den(181) = 1 /((L(5,92))+L(6,92))
  den(184) = 1 /((L(5,108))+L(6,108))
  den(189) = 1 /((L(5,44))+L(6,44))
  den(193) = 1 /((L(5,76))+L(6,76))
  den(217) = 1 /((L(5,120) - MT2)+L(6,120))
  den(233) = 1 /((L(5,67))+L(6,67))
  den(240) = 1 /((L(5,35))+L(6,35))
  den(247) = 1 /((L(5,19))+L(6,19))
  den(251) = 1 /((L(5,23) - MT2)+L(6,23))
  den(256) = 1 /((L(5,43) - MT2)+L(6,43))
  den(269) = 1 /((L(5,75) - MT2)+L(6,75))
  den(279) = 1 /((L(5,39) - MT2)+L(6,39))
  den(284) = 1 /((L(5,27) - MT2)+L(6,27))
  den(295) = 1 /((L(5,71) - MT2)+L(6,71))
  den(656) = 1 /((L(5,15))+L(6,15))
  den(776) = 1 /((L(5,31))+L(6,31))
  den(784) = 1 /((L(5,55) - MT2)+L(6,55))
  den(790) = 1 /((L(5,87) - MT2)+L(6,87))
  den(811) = 1 /((L(5,59) - MT2)+L(6,59))
  den(816) = 1 /((L(5,91) - MT2)+L(6,91))
  den(825) = 1 /((L(5,47))+L(6,47))
  den(838) = 1 /((L(5,103) - MT2)+L(6,103))
  den(863) = 1 /((L(5,107) - MT2)+L(6,107))
  den(890) = 1 /((L(5,79))+L(6,79))

  ! denominators
  den(4) = den(1)*den(3)
  den(5) = den(2)*den(4)
  den(7) = den(3)*den(6)
  den(8) = den(2)*den(7)
  den(10) = den(2)*den(9)
  den(11) = den(1)*den(10)
  den(12) = den(6)*den(10)
  den(15) = den(1)*den(14)
  den(17) = den(13)*den(16)
  den(18) = den(15)*den(17)
  den(19) = den(6)*den(14)
  den(20) = den(17)*den(19)
  den(21) = den(1)*den(13)
  den(23) = den(14)*den(22)
  den(24) = den(21)*den(23)
  den(25) = den(6)*den(13)
  den(26) = den(23)*den(25)
  den(28) = den(1)*den(27)
  den(30) = den(13)*den(29)
  den(31) = den(28)*den(30)
  den(32) = den(6)*den(27)
  den(33) = den(30)*den(32)
  den(34) = den(22)*den(27)
  den(35) = den(21)*den(34)
  den(36) = den(25)*den(34)
  den(38) = den(13)*den(37)
  den(40) = den(1)*den(39)
  den(41) = den(38)*den(40)
  den(42) = den(6)*den(39)
  den(43) = den(38)*den(42)
  den(44) = den(22)*den(37)
  den(45) = den(21)*den(44)
  den(46) = den(25)*den(44)
  den(47) = den(30)*den(40)
  den(48) = den(30)*den(42)
  den(49) = den(17)*den(40)
  den(50) = den(17)*den(42)
  den(53) = den(1)*den(52)
  den(55) = den(51)*den(54)
  den(56) = den(53)*den(55)
  den(57) = den(6)*den(52)
  den(58) = den(55)*den(57)
  den(59) = den(1)*den(51)
  den(61) = den(52)*den(60)
  den(62) = den(59)*den(61)
  den(63) = den(6)*den(51)
  den(64) = den(61)*den(63)
  den(66) = den(54)*den(65)
  den(67) = den(53)*den(66)
  den(68) = den(57)*den(66)
  den(69) = den(1)*den(65)
  den(71) = den(52)*den(70)
  den(72) = den(69)*den(71)
  den(73) = den(6)*den(65)
  den(74) = den(71)*den(73)
  den(75) = den(37)*den(52)
  den(76) = den(4)*den(75)
  den(77) = den(7)*den(75)
  den(78) = den(37)*den(54)
  den(79) = den(53)*den(78)
  den(80) = den(57)*den(78)
  den(81) = den(4)*den(61)
  den(82) = den(7)*den(61)
  den(83) = den(4)*den(71)
  den(84) = den(7)*den(71)
  den(85) = den(29)*den(51)
  den(86) = den(28)*den(85)
  den(87) = den(32)*den(85)
  den(88) = den(27)*den(60)
  den(89) = den(59)*den(88)
  den(90) = den(63)*den(88)
  den(92) = den(51)*den(91)
  den(93) = den(40)*den(92)
  den(94) = den(42)*den(92)
  den(95) = den(60)*den(91)
  den(96) = den(59)*den(95)
  den(97) = den(63)*den(95)
  den(98) = den(40)*den(85)
  den(99) = den(42)*den(85)
  den(100) = den(40)*den(55)
  den(101) = den(42)*den(55)
  den(102) = den(16)*den(65)
  den(103) = den(15)*den(102)
  den(104) = den(19)*den(102)
  den(105) = den(14)*den(70)
  den(106) = den(69)*den(105)
  den(107) = den(73)*den(105)
  den(108) = den(14)*den(91)
  den(109) = den(4)*den(108)
  den(110) = den(7)*den(108)
  den(111) = den(16)*den(91)
  den(112) = den(15)*den(111)
  den(113) = den(19)*den(111)
  den(114) = den(4)*den(23)
  den(115) = den(7)*den(23)
  den(116) = den(4)*den(105)
  den(117) = den(7)*den(105)
  den(119) = den(65)*den(118)
  den(120) = den(40)*den(119)
  den(121) = den(42)*den(119)
  den(122) = den(70)*den(118)
  den(123) = den(69)*den(122)
  den(124) = den(73)*den(122)
  den(125) = den(27)*den(118)
  den(126) = den(4)*den(125)
  den(127) = den(7)*den(125)
  den(128) = den(29)*den(118)
  den(129) = den(28)*den(128)
  den(130) = den(32)*den(128)
  den(131) = den(2)*den(118)
  den(132) = den(4)*den(131)
  den(133) = den(7)*den(131)
  den(134) = den(4)*den(122)
  den(135) = den(7)*den(122)
  den(136) = den(40)*den(131)
  den(137) = den(42)*den(131)
  den(138) = den(40)*den(128)
  den(139) = den(42)*den(128)
  den(140) = den(40)*den(102)
  den(141) = den(42)*den(102)
  den(142) = den(40)*den(66)
  den(143) = den(42)*den(66)
  den(144) = den(4)*den(34)
  den(145) = den(7)*den(34)
  den(146) = den(4)*den(88)
  den(147) = den(7)*den(88)
  den(148) = den(2)*den(91)
  den(149) = den(4)*den(148)
  den(150) = den(7)*den(148)
  den(151) = den(4)*den(95)
  den(152) = den(7)*den(95)
  den(153) = den(40)*den(148)
  den(154) = den(42)*den(148)
  den(155) = den(40)*den(111)
  den(156) = den(42)*den(111)
  den(157) = den(2)*den(37)
  den(158) = den(4)*den(157)
  den(159) = den(7)*den(157)
  den(160) = den(4)*den(44)
  den(161) = den(7)*den(44)
  den(162) = den(40)*den(157)
  den(163) = den(42)*den(157)
  den(164) = den(40)*den(78)
  den(165) = den(42)*den(78)
  den(167) = den(1)*den(166)
  den(168) = den(118)*den(167)
  den(169) = den(6)*den(166)
  den(170) = den(118)*den(169)
  den(171) = den(91)*den(167)
  den(172) = den(91)*den(169)
  den(174) = den(166)*den(173)
  den(175) = den(1)*den(174)
  den(176) = den(6)*den(174)
  den(177) = den(2)*den(169)
  den(179) = den(166)*den(178)
  den(180) = den(6)*den(179)
  den(182) = den(166)*den(181)
  den(183) = den(6)*den(182)
  den(185) = den(166)*den(184)
  den(186) = den(6)*den(185)
  den(187) = den(37)*den(167)
  den(188) = den(37)*den(169)
  den(190) = den(166)*den(189)
  den(191) = den(1)*den(190)
  den(192) = den(6)*den(190)
  den(194) = den(166)*den(193)
  den(195) = den(1)*den(194)
  den(196) = den(6)*den(194)
  den(197) = den(13)*den(173)
  den(198) = den(1)*den(197)
  den(199) = den(6)*den(197)
  den(200) = den(52)*den(173)
  den(201) = den(1)*den(200)
  den(202) = den(6)*den(200)
  den(203) = den(51)*den(189)
  den(204) = den(1)*den(203)
  den(205) = den(6)*den(203)
  den(206) = den(14)*den(189)
  den(207) = den(1)*den(206)
  den(208) = den(6)*den(206)
  den(209) = den(65)*den(193)
  den(210) = den(1)*den(209)
  den(211) = den(6)*den(209)
  den(212) = den(27)*den(193)
  den(213) = den(1)*den(212)
  den(214) = den(6)*den(212)
  den(215) = den(2)*den(40)
  den(216) = den(2)*den(42)
  den(218) = den(2)*den(217)
  den(219) = den(1)*den(218)
  den(220) = den(6)*den(218)
  den(221) = den(6)*den(118)
  den(222) = den(194)*den(221)
  den(223) = den(131)*den(169)
  den(224) = den(118)*den(166)
  den(225) = den(178)*den(224)
  den(226) = den(6)*den(225)
  den(227) = den(6)*den(91)
  den(228) = den(190)*den(227)
  den(229) = den(148)*den(169)
  den(230) = den(6)*den(37)
  den(231) = den(174)*den(230)
  den(232) = den(157)*den(169)
  den(234) = den(6)*den(233)
  den(235) = den(174)*den(234)
  den(236) = den(190)*den(234)
  den(237) = den(91)*den(166)
  den(238) = den(181)*den(237)
  den(239) = den(6)*den(238)
  den(241) = den(6)*den(240)
  den(242) = den(174)*den(241)
  den(243) = den(194)*den(241)
  den(244) = den(37)*den(166)
  den(245) = den(184)*den(244)
  den(246) = den(6)*den(245)
  den(248) = den(6)*den(247)
  den(249) = den(190)*den(248)
  den(250) = den(194)*den(248)
  den(252) = den(21)*den(251)
  den(253) = den(14)*den(252)
  den(254) = den(25)*den(251)
  den(255) = den(14)*den(254)
  den(257) = den(15)*den(256)
  den(258) = den(13)*den(257)
  den(259) = den(19)*den(256)
  den(260) = den(13)*den(259)
  den(261) = den(13)*den(14)
  den(262) = den(178)*den(261)
  den(263) = den(6)*den(262)
  den(264) = den(197)*den(230)
  den(265) = den(197)*den(234)
  den(266) = den(30)*den(234)
  den(267) = den(27)*den(252)
  den(268) = den(27)*den(254)
  den(270) = den(28)*den(269)
  den(271) = den(13)*den(270)
  den(272) = den(32)*den(269)
  den(273) = den(13)*den(272)
  den(274) = den(13)*den(27)
  den(275) = den(181)*den(274)
  den(276) = den(6)*den(275)
  den(277) = den(197)*den(241)
  den(278) = den(17)*den(241)
  den(280) = den(59)*den(279)
  den(281) = den(52)*den(280)
  den(282) = den(63)*den(279)
  den(283) = den(52)*den(282)
  den(285) = den(53)*den(284)
  den(286) = den(51)*den(285)
  den(287) = den(57)*den(284)
  den(288) = den(51)*den(287)
  den(289) = den(51)*den(52)
  den(290) = den(178)*den(289)
  den(291) = den(6)*den(290)
  den(292) = den(200)*den(230)
  den(293) = den(200)*den(234)
  den(294) = den(71)*den(234)
  den(296) = den(69)*den(295)
  den(297) = den(52)*den(296)
  den(298) = den(73)*den(295)
  den(299) = den(52)*den(298)
  den(300) = den(65)*den(285)
  den(301) = den(65)*den(287)
  den(302) = den(52)*den(65)
  den(303) = den(181)*den(302)
  den(304) = den(6)*den(303)
  den(305) = den(200)*den(241)
  den(306) = den(61)*den(241)
  den(307) = den(203)*den(227)
  den(308) = den(203)*den(234)
  den(309) = den(85)*den(234)
  den(310) = den(206)*den(227)
  den(311) = den(206)*den(234)
  den(312) = den(105)*den(234)
  den(313) = den(209)*den(221)
  den(314) = den(212)*den(221)
  den(315) = den(128)*den(234)
  den(316) = den(122)*den(234)
  den(317) = den(209)*den(241)
  den(318) = den(102)*den(241)
  den(319) = den(212)*den(241)
  den(320) = den(88)*den(241)
  den(321) = den(111)*den(241)
  den(322) = den(95)*den(241)
  den(323) = den(4)*den(218)
  den(324) = den(7)*den(218)
  den(325) = den(10)*den(40)
  den(326) = den(10)*den(42)
  den(327) = den(2)**2
  den(328) = den(40)*den(327)
  den(329) = den(42)*den(327)
  den(330) = den(4)*den(327)
  den(331) = den(7)*den(327)
  den(332) = den(27)*den(280)
  den(333) = den(27)*den(282)
  den(334) = den(51)*den(270)
  den(335) = den(51)*den(272)
  den(336) = den(27)*den(51)
  den(337) = den(184)*den(336)
  den(338) = den(6)*den(337)
  den(339) = den(203)*den(248)
  den(340) = den(55)*den(248)
  den(341) = den(14)*den(296)
  den(342) = den(14)*den(298)
  den(343) = den(65)*den(257)
  den(344) = den(65)*den(259)
  den(345) = den(14)*den(65)
  den(346) = den(184)*den(345)
  den(347) = den(6)*den(346)
  den(348) = den(206)*den(248)
  den(349) = den(23)*den(248)
  den(350) = den(209)*den(248)
  den(351) = den(66)*den(248)
  den(352) = den(212)*den(248)
  den(353) = den(34)*den(248)
  den(354) = den(78)*den(248)
  den(355) = den(44)*den(248)
  den(356) = den(37)*den(252)
  den(357) = den(37)*den(254)
  den(358) = den(9)*den(38)
  den(359) = den(1)*den(358)
  den(360) = den(6)*den(358)
  den(361) = den(91)*den(280)
  den(362) = den(91)*den(282)
  den(363) = den(9)*den(92)
  den(364) = den(1)*den(363)
  den(365) = den(6)*den(363)
  den(366) = den(118)*den(296)
  den(367) = den(118)*den(298)
  den(368) = den(9)*den(119)
  den(369) = den(1)*den(368)
  den(370) = den(6)*den(368)
  den(371) = den(37)*den(285)
  den(372) = den(37)*den(287)
  den(373) = den(75)*den(217)
  den(374) = den(1)*den(373)
  den(375) = den(6)*den(373)
  den(376) = den(91)*den(257)
  den(377) = den(91)*den(259)
  den(378) = den(108)*den(217)
  den(379) = den(1)*den(378)
  den(380) = den(6)*den(378)
  den(381) = den(118)*den(270)
  den(382) = den(118)*den(272)
  den(383) = den(125)*den(217)
  den(384) = den(1)*den(383)
  den(385) = den(6)*den(383)
  den(386) = den(13)**2
  den(387) = den(257)*den(386)
  den(388) = den(259)*den(386)
  den(389) = den(1)*den(386)
  den(390) = den(23)*den(389)
  den(391) = den(6)*den(386)
  den(392) = den(23)*den(391)
  den(393) = den(14)**2
  den(394) = den(252)*den(393)
  den(395) = den(254)*den(393)
  den(396) = den(1)*den(393)
  den(397) = den(17)*den(396)
  den(398) = den(6)*den(393)
  den(399) = den(17)*den(398)
  den(400) = den(17)*den(257)
  den(401) = den(17)*den(259)
  den(402) = den(23)*den(252)
  den(403) = den(23)*den(254)
  den(404) = den(270)*den(386)
  den(405) = den(272)*den(386)
  den(406) = den(34)*den(389)
  den(407) = den(34)*den(391)
  den(408) = den(27)**2
  den(409) = den(252)*den(408)
  den(410) = den(254)*den(408)
  den(411) = den(1)*den(408)
  den(412) = den(30)*den(411)
  den(413) = den(6)*den(408)
  den(414) = den(30)*den(413)
  den(415) = den(30)*den(270)
  den(416) = den(30)*den(272)
  den(417) = den(34)*den(252)
  den(418) = den(34)*den(254)
  den(419) = den(40)*den(386)
  den(420) = den(37)*den(419)
  den(421) = den(42)*den(386)
  den(422) = den(37)*den(421)
  den(423) = den(44)*den(389)
  den(424) = den(44)*den(391)
  den(425) = den(37)**2
  den(426) = den(252)*den(425)
  den(427) = den(254)*den(425)
  den(428) = den(40)*den(358)
  den(429) = den(42)*den(358)
  den(430) = den(44)*den(252)
  den(431) = den(44)*den(254)
  den(432) = den(13)*den(425)
  den(433) = den(40)*den(432)
  den(434) = den(42)*den(432)
  den(435) = den(29)*den(386)
  den(436) = den(40)*den(435)
  den(437) = den(42)*den(435)
  den(438) = den(40)*den(256)
  den(439) = den(386)*den(438)
  den(440) = den(42)*den(256)
  den(441) = den(386)*den(440)
  den(442) = den(9)*den(17)
  den(443) = den(40)*den(442)
  den(444) = den(42)*den(442)
  den(445) = den(9)*den(30)
  den(446) = den(40)*den(445)
  den(447) = den(42)*den(445)
  den(448) = den(40)*den(269)
  den(449) = den(30)*den(448)
  den(450) = den(42)*den(269)
  den(451) = den(30)*den(450)
  den(452) = den(17)*den(438)
  den(453) = den(17)*den(440)
  den(454) = den(51)**2
  den(455) = den(285)*den(454)
  den(456) = den(287)*den(454)
  den(457) = den(1)*den(454)
  den(458) = den(61)*den(457)
  den(459) = den(6)*den(454)
  den(460) = den(61)*den(459)
  den(461) = den(52)**2
  den(462) = den(280)*den(461)
  den(463) = den(282)*den(461)
  den(464) = den(1)*den(461)
  den(465) = den(55)*den(464)
  den(466) = den(6)*den(461)
  den(467) = den(55)*den(466)
  den(468) = den(55)*den(285)
  den(469) = den(55)*den(287)
  den(470) = den(61)*den(280)
  den(471) = den(61)*den(282)
  den(472) = den(65)**2
  den(473) = den(285)*den(472)
  den(474) = den(287)*den(472)
  den(475) = den(1)*den(472)
  den(476) = den(71)*den(475)
  den(477) = den(6)*den(472)
  den(478) = den(71)*den(477)
  den(479) = den(296)*den(461)
  den(480) = den(298)*den(461)
  den(481) = den(66)*den(464)
  den(482) = den(66)*den(466)
  den(483) = den(66)*den(285)
  den(484) = den(66)*den(287)
  den(485) = den(71)*den(296)
  den(486) = den(71)*den(298)
  den(487) = den(285)*den(425)
  den(488) = den(287)*den(425)
  den(489) = den(4)*den(373)
  den(490) = den(7)*den(373)
  den(491) = den(78)*den(285)
  den(492) = den(78)*den(287)
  den(493) = den(4)*den(461)
  den(494) = den(37)*den(493)
  den(495) = den(7)*den(461)
  den(496) = den(37)*den(495)
  den(497) = den(78)*den(464)
  den(498) = den(78)*den(466)
  den(499) = den(4)*den(425)
  den(500) = den(52)*den(499)
  den(501) = den(7)*den(425)
  den(502) = den(52)*den(501)
  den(503) = den(61)*den(217)
  den(504) = den(4)*den(503)
  den(505) = den(7)*den(503)
  den(506) = den(71)*den(217)
  den(507) = den(4)*den(506)
  den(508) = den(7)*den(506)
  den(509) = den(70)*den(461)
  den(510) = den(4)*den(509)
  den(511) = den(7)*den(509)
  den(512) = den(4)*den(279)
  den(513) = den(461)*den(512)
  den(514) = den(7)*den(279)
  den(515) = den(461)*den(514)
  den(516) = den(61)*den(512)
  den(517) = den(61)*den(514)
  den(518) = den(4)*den(295)
  den(519) = den(71)*den(518)
  den(520) = den(7)*den(295)
  den(521) = den(71)*den(520)
  den(522) = den(270)*den(454)
  den(523) = den(272)*den(454)
  den(524) = den(88)*den(457)
  den(525) = den(88)*den(459)
  den(526) = den(280)*den(408)
  den(527) = den(282)*den(408)
  den(528) = den(85)*den(411)
  den(529) = den(85)*den(413)
  den(530) = den(85)*den(270)
  den(531) = den(85)*den(272)
  den(532) = den(88)*den(280)
  den(533) = den(88)*den(282)
  den(534) = den(40)*den(454)
  den(535) = den(91)*den(534)
  den(536) = den(42)*den(454)
  den(537) = den(91)*den(536)
  den(538) = den(95)*den(457)
  den(539) = den(95)*den(459)
  den(540) = den(91)**2
  den(541) = den(280)*den(540)
  den(542) = den(282)*den(540)
  den(543) = den(40)*den(363)
  den(544) = den(42)*den(363)
  den(545) = den(95)*den(280)
  den(546) = den(95)*den(282)
  den(547) = den(51)*den(540)
  den(548) = den(40)*den(547)
  den(549) = den(42)*den(547)
  den(550) = den(29)*den(454)
  den(551) = den(40)*den(550)
  den(552) = den(42)*den(550)
  den(553) = den(40)*den(284)
  den(554) = den(454)*den(553)
  den(555) = den(42)*den(284)
  den(556) = den(454)*den(555)
  den(557) = den(9)*den(55)
  den(558) = den(40)*den(557)
  den(559) = den(42)*den(557)
  den(560) = den(9)*den(85)
  den(561) = den(40)*den(560)
  den(562) = den(42)*den(560)
  den(563) = den(85)*den(448)
  den(564) = den(85)*den(450)
  den(565) = den(55)*den(553)
  den(566) = den(55)*den(555)
  den(567) = den(257)*den(472)
  den(568) = den(259)*den(472)
  den(569) = den(105)*den(475)
  den(570) = den(105)*den(477)
  den(571) = den(296)*den(393)
  den(572) = den(298)*den(393)
  den(573) = den(102)*den(396)
  den(574) = den(102)*den(398)
  den(575) = den(102)*den(257)
  den(576) = den(102)*den(259)
  den(577) = den(105)*den(296)
  den(578) = den(105)*den(298)
  den(579) = den(257)*den(540)
  den(580) = den(259)*den(540)
  den(581) = den(4)*den(378)
  den(582) = den(7)*den(378)
  den(583) = den(111)*den(257)
  den(584) = den(111)*den(259)
  den(585) = den(4)*den(393)
  den(586) = den(91)*den(585)
  den(587) = den(7)*den(393)
  den(588) = den(91)*den(587)
  den(589) = den(111)*den(396)
  den(590) = den(111)*den(398)
  den(591) = den(4)*den(540)
  den(592) = den(14)*den(591)
  den(593) = den(7)*den(540)
  den(594) = den(14)*den(593)
  den(595) = den(23)*den(217)
  den(596) = den(4)*den(595)
  den(597) = den(7)*den(595)
  den(598) = den(105)*den(217)
  den(599) = den(4)*den(598)
  den(600) = den(7)*den(598)
  den(601) = den(70)*den(393)
  den(602) = den(4)*den(601)
  den(603) = den(7)*den(601)
  den(604) = den(4)*den(251)
  den(605) = den(393)*den(604)
  den(606) = den(7)*den(251)
  den(607) = den(393)*den(606)
  den(608) = den(23)*den(604)
  den(609) = den(23)*den(606)
  den(610) = den(105)*den(518)
  den(611) = den(105)*den(520)
  den(612) = den(40)*den(472)
  den(613) = den(118)*den(612)
  den(614) = den(42)*den(472)
  den(615) = den(118)*den(614)
  den(616) = den(122)*den(475)
  den(617) = den(122)*den(477)
  den(618) = den(118)**2
  den(619) = den(296)*den(618)
  den(620) = den(298)*den(618)
  den(621) = den(40)*den(368)
  den(622) = den(42)*den(368)
  den(623) = den(122)*den(296)
  den(624) = den(122)*den(298)
  den(625) = den(65)*den(618)
  den(626) = den(40)*den(625)
  den(627) = den(42)*den(625)
  den(628) = den(270)*den(618)
  den(629) = den(272)*den(618)
  den(630) = den(4)*den(383)
  den(631) = den(7)*den(383)
  den(632) = den(128)*den(270)
  den(633) = den(128)*den(272)
  den(634) = den(4)*den(408)
  den(635) = den(118)*den(634)
  den(636) = den(7)*den(408)
  den(637) = den(118)*den(636)
  den(638) = den(128)*den(411)
  den(639) = den(128)*den(413)
  den(640) = den(4)*den(618)
  den(641) = den(27)*den(640)
  den(642) = den(7)*den(618)
  den(643) = den(27)*den(642)
  den(644) = den(131)*den(217)
  den(645) = den(4)*den(644)
  den(646) = den(7)*den(644)
  den(647) = den(9)*den(131)
  den(648) = den(40)*den(647)
  den(649) = den(42)*den(647)
  den(650) = den(29)*den(618)
  den(651) = den(40)*den(650)
  den(652) = den(42)*den(650)
  den(653) = den(122)*den(217)
  den(654) = den(4)*den(653)
  den(655) = den(7)*den(653)
  den(657) = den(40)*den(656)
  den(658) = den(131)*den(657)
  den(659) = den(42)*den(656)
  den(660) = den(131)*den(659)
  den(661) = den(128)*den(448)
  den(662) = den(128)*den(450)
  den(663) = den(70)*den(618)
  den(664) = den(4)*den(663)
  den(665) = den(7)*den(663)
  den(666) = den(4)*den(656)
  den(667) = den(131)*den(666)
  den(668) = den(7)*den(656)
  den(669) = den(131)*den(668)
  den(670) = den(122)*den(518)
  den(671) = den(122)*den(520)
  den(672) = den(9)*den(128)
  den(673) = den(40)*den(672)
  den(674) = den(42)*den(672)
  den(675) = den(618)*den(666)
  den(676) = den(618)*den(668)
  den(677) = den(618)*den(657)
  den(678) = den(618)*den(659)
  den(679) = den(16)*den(472)
  den(680) = den(40)*den(679)
  den(681) = den(42)*den(679)
  den(682) = den(472)*den(553)
  den(683) = den(472)*den(555)
  den(684) = den(9)*den(66)
  den(685) = den(40)*den(684)
  den(686) = den(42)*den(684)
  den(687) = den(9)*den(102)
  den(688) = den(40)*den(687)
  den(689) = den(42)*den(687)
  den(690) = den(102)*den(438)
  den(691) = den(102)*den(440)
  den(692) = den(66)*den(553)
  den(693) = den(66)*den(555)
  den(694) = den(34)*den(217)
  den(695) = den(4)*den(694)
  den(696) = den(7)*den(694)
  den(697) = den(88)*den(217)
  den(698) = den(4)*den(697)
  den(699) = den(7)*den(697)
  den(700) = den(60)*den(408)
  den(701) = den(4)*den(700)
  den(702) = den(7)*den(700)
  den(703) = den(408)*den(604)
  den(704) = den(408)*den(606)
  den(705) = den(34)*den(604)
  den(706) = den(34)*den(606)
  den(707) = den(88)*den(512)
  den(708) = den(88)*den(514)
  den(709) = den(148)*den(217)
  den(710) = den(4)*den(709)
  den(711) = den(7)*den(709)
  den(712) = den(9)*den(148)
  den(713) = den(40)*den(712)
  den(714) = den(42)*den(712)
  den(715) = den(16)*den(540)
  den(716) = den(40)*den(715)
  den(717) = den(42)*den(715)
  den(718) = den(95)*den(217)
  den(719) = den(4)*den(718)
  den(720) = den(7)*den(718)
  den(721) = den(148)*den(657)
  den(722) = den(148)*den(659)
  den(723) = den(111)*den(438)
  den(724) = den(111)*den(440)
  den(725) = den(60)*den(540)
  den(726) = den(4)*den(725)
  den(727) = den(7)*den(725)
  den(728) = den(148)*den(666)
  den(729) = den(148)*den(668)
  den(730) = den(95)*den(512)
  den(731) = den(95)*den(514)
  den(732) = den(9)*den(111)
  den(733) = den(40)*den(732)
  den(734) = den(42)*den(732)
  den(735) = den(540)*den(666)
  den(736) = den(540)*den(668)
  den(737) = den(540)*den(657)
  den(738) = den(540)*den(659)
  den(739) = den(157)*den(217)
  den(740) = den(4)*den(739)
  den(741) = den(7)*den(739)
  den(742) = den(9)*den(157)
  den(743) = den(40)*den(742)
  den(744) = den(42)*den(742)
  den(745) = den(44)*den(217)
  den(746) = den(4)*den(745)
  den(747) = den(7)*den(745)
  den(748) = den(157)*den(657)
  den(749) = den(157)*den(659)
  den(750) = den(78)*den(553)
  den(751) = den(78)*den(555)
  den(752) = den(54)*den(425)
  den(753) = den(40)*den(752)
  den(754) = den(42)*den(752)
  den(755) = den(157)*den(666)
  den(756) = den(157)*den(668)
  den(757) = den(44)*den(604)
  den(758) = den(44)*den(606)
  den(759) = den(9)*den(78)
  den(760) = den(40)*den(759)
  den(761) = den(42)*den(759)
  den(762) = den(22)*den(425)
  den(763) = den(4)*den(762)
  den(764) = den(7)*den(762)
  den(765) = den(425)*den(666)
  den(766) = den(425)*den(668)
  den(767) = den(425)*den(657)
  den(768) = den(425)*den(659)
  den(769) = den(174)*den(178)
  den(770) = den(174)*den(181)
  den(771) = den(178)*den(190)
  den(772) = den(184)*den(190)
  den(773) = den(181)*den(194)
  den(774) = den(184)*den(194)
  den(775) = den(13)*den(40)
  den(777) = den(775)*den(776)
  den(778) = den(13)*den(42)
  den(779) = den(776)*den(778)
  den(780) = den(178)*den(197)
  den(781) = den(181)*den(197)
  den(782) = den(30)*den(178)
  den(783) = den(1)*den(30)
  den(785) = den(783)*den(784)
  den(786) = den(6)*den(30)
  den(787) = den(784)*den(786)
  den(788) = den(17)*den(181)
  den(789) = den(1)*den(17)
  den(791) = den(789)*den(790)
  den(792) = den(6)*den(17)
  den(793) = den(790)*den(792)
  den(794) = den(252)*den(776)
  den(795) = den(254)*den(776)
  den(796) = den(252)*den(784)
  den(797) = den(254)*den(784)
  den(798) = den(252)*den(790)
  den(799) = den(254)*den(790)
  den(800) = den(4)*den(52)
  den(801) = den(776)*den(800)
  den(802) = den(7)*den(52)
  den(803) = den(776)*den(802)
  den(804) = den(178)*den(200)
  den(805) = den(181)*den(200)
  den(806) = den(71)*den(178)
  den(807) = den(61)*den(181)
  den(808) = den(285)*den(776)
  den(809) = den(287)*den(776)
  den(810) = den(1)*den(71)
  den(812) = den(810)*den(811)
  den(813) = den(6)*den(71)
  den(814) = den(811)*den(813)
  den(815) = den(1)*den(61)
  den(817) = den(815)*den(816)
  den(818) = den(6)*den(61)
  den(819) = den(816)*den(818)
  den(820) = den(285)*den(811)
  den(821) = den(287)*den(811)
  den(822) = den(285)*den(816)
  den(823) = den(287)*den(816)
  den(824) = den(40)*den(51)
  den(826) = den(824)*den(825)
  den(827) = den(42)*den(51)
  den(828) = den(825)*den(827)
  den(829) = den(178)*den(203)
  den(830) = den(184)*den(203)
  den(831) = den(85)*den(178)
  den(832) = den(1)*den(85)
  den(833) = den(784)*den(832)
  den(834) = den(6)*den(85)
  den(835) = den(784)*den(834)
  den(836) = den(55)*den(184)
  den(837) = den(1)*den(55)
  den(839) = den(837)*den(838)
  den(840) = den(6)*den(55)
  den(841) = den(838)*den(840)
  den(842) = den(280)*den(825)
  den(843) = den(282)*den(825)
  den(844) = den(280)*den(784)
  den(845) = den(282)*den(784)
  den(846) = den(280)*den(838)
  den(847) = den(282)*den(838)
  den(848) = den(4)*den(14)
  den(849) = den(825)*den(848)
  den(850) = den(7)*den(14)
  den(851) = den(825)*den(850)
  den(852) = den(178)*den(206)
  den(853) = den(184)*den(206)
  den(854) = den(105)*den(178)
  den(855) = den(23)*den(184)
  den(856) = den(257)*den(825)
  den(857) = den(259)*den(825)
  den(858) = den(1)*den(105)
  den(859) = den(811)*den(858)
  den(860) = den(6)*den(105)
  den(861) = den(811)*den(860)
  den(862) = den(1)*den(23)
  den(864) = den(862)*den(863)
  den(865) = den(6)*den(23)
  den(866) = den(863)*den(865)
  den(867) = den(257)*den(811)
  den(868) = den(259)*den(811)
  den(869) = den(257)*den(863)
  den(870) = den(259)*den(863)
  den(871) = den(4)*den(118)
  den(872) = den(784)*den(871)
  den(873) = den(7)*den(118)
  den(874) = den(784)*den(873)
  den(875) = den(40)*den(118)
  den(876) = den(811)*den(875)
  den(877) = den(42)*den(118)
  den(878) = den(811)*den(877)
  den(879) = den(128)*den(178)
  den(880) = den(122)*den(178)
  den(881) = den(1)*den(128)
  den(882) = den(784)*den(881)
  den(883) = den(6)*den(128)
  den(884) = den(784)*den(883)
  den(885) = den(1)*den(122)
  den(886) = den(811)*den(885)
  den(887) = den(6)*den(122)
  den(888) = den(811)*den(887)
  den(889) = den(40)*den(65)
  den(891) = den(889)*den(890)
  den(892) = den(42)*den(65)
  den(893) = den(890)*den(892)
  den(894) = den(181)*den(209)
  den(895) = den(184)*den(209)
  den(896) = den(102)*den(181)
  den(897) = den(1)*den(102)
  den(898) = den(790)*den(897)
  den(899) = den(6)*den(102)
  den(900) = den(790)*den(899)
  den(901) = den(66)*den(184)
  den(902) = den(1)*den(66)
  den(903) = den(838)*den(902)
  den(904) = den(6)*den(66)
  den(905) = den(838)*den(904)
  den(906) = den(296)*den(890)
  den(907) = den(298)*den(890)
  den(908) = den(296)*den(790)
  den(909) = den(298)*den(790)
  den(910) = den(296)*den(838)
  den(911) = den(298)*den(838)
  den(912) = den(4)*den(27)
  den(913) = den(890)*den(912)
  den(914) = den(7)*den(27)
  den(915) = den(890)*den(914)
  den(916) = den(181)*den(212)
  den(917) = den(184)*den(212)
  den(918) = den(88)*den(181)
  den(919) = den(34)*den(184)
  den(920) = den(270)*den(890)
  den(921) = den(272)*den(890)
  den(922) = den(1)*den(88)
  den(923) = den(816)*den(922)
  den(924) = den(6)*den(88)
  den(925) = den(816)*den(924)
  den(926) = den(1)*den(34)
  den(927) = den(863)*den(926)
  den(928) = den(6)*den(34)
  den(929) = den(863)*den(928)
  den(930) = den(270)*den(816)
  den(931) = den(272)*den(816)
  den(932) = den(270)*den(863)
  den(933) = den(272)*den(863)
  den(934) = den(4)*den(91)
  den(935) = den(790)*den(934)
  den(936) = den(7)*den(91)
  den(937) = den(790)*den(936)
  den(938) = den(40)*den(91)
  den(939) = den(816)*den(938)
  den(940) = den(42)*den(91)
  den(941) = den(816)*den(940)
  den(942) = den(111)*den(181)
  den(943) = den(95)*den(181)
  den(944) = den(1)*den(111)
  den(945) = den(790)*den(944)
  den(946) = den(6)*den(111)
  den(947) = den(790)*den(946)
  den(948) = den(1)*den(95)
  den(949) = den(816)*den(948)
  den(950) = den(6)*den(95)
  den(951) = den(816)*den(950)
  den(952) = den(4)*den(37)
  den(953) = den(838)*den(952)
  den(954) = den(7)*den(37)
  den(955) = den(838)*den(954)
  den(956) = den(37)*den(40)
  den(957) = den(863)*den(956)
  den(958) = den(37)*den(42)
  den(959) = den(863)*den(958)
  den(960) = den(78)*den(184)
  den(961) = den(44)*den(184)
  den(962) = den(1)*den(78)
  den(963) = den(838)*den(962)
  den(964) = den(6)*den(78)
  den(965) = den(838)*den(964)
  den(966) = den(1)*den(44)
  den(967) = den(863)*den(966)
  den(968) = den(6)*den(44)
  den(969) = den(863)*den(968)
  den(970) = den(666)*den(776)
  den(971) = den(668)*den(776)
  den(972) = den(666)*den(825)
  den(973) = den(668)*den(825)
  den(974) = den(666)*den(890)
  den(975) = den(668)*den(890)
  den(976) = den(604)*den(776)
  den(977) = den(606)*den(776)
  den(978) = den(604)*den(784)
  den(979) = den(606)*den(784)
  den(980) = den(604)*den(790)
  den(981) = den(606)*den(790)
  den(982) = den(512)*den(825)
  den(983) = den(514)*den(825)
  den(984) = den(512)*den(784)
  den(985) = den(514)*den(784)
  den(986) = den(512)*den(838)
  den(987) = den(514)*den(838)
  den(988) = den(518)*den(890)
  den(989) = den(520)*den(890)
  den(990) = den(518)*den(790)
  den(991) = den(520)*den(790)
  den(992) = den(518)*den(838)
  den(993) = den(520)*den(838)
  den(994) = den(657)*den(776)
  den(995) = den(659)*den(776)
  den(996) = den(657)*den(825)
  den(997) = den(659)*den(825)
  den(998) = den(657)*den(890)
  den(999) = den(659)*den(890)
  den(1000) = den(553)*den(776)
  den(1001) = den(555)*den(776)
  den(1002) = den(438)*den(825)
  den(1003) = den(440)*den(825)
  den(1004) = den(448)*den(890)
  den(1005) = den(450)*den(890)
  den(1006) = den(553)*den(811)
  den(1007) = den(555)*den(811)
  den(1008) = den(553)*den(816)
  den(1009) = den(555)*den(816)
  den(1010) = den(438)*den(811)
  den(1011) = den(440)*den(811)
  den(1012) = den(438)*den(863)
  den(1013) = den(440)*den(863)
  den(1014) = den(448)*den(816)
  den(1015) = den(450)*den(816)
  den(1016) = den(448)*den(863)
  den(1017) = den(450)*den(863)
  den(1018) = den(1)*den(185)
  den(1019) = den(1)*den(182)
  den(1020) = den(1)*den(179)
  den(1021) = den(1)*den(2)*den(166)
  den(1022) = den(2)*den(6)*den(166)
  den(1023) = den(1)*den(118)
  den(1024) = den(1)*den(91)
  den(1025) = den(1)*den(37)
  den(1026) = den(1)*den(2)
  den(1027) = den(2)*den(6)
  den(1028) = den(1)*den(118)*den(194)
  den(1029) = den(6)*den(118)*den(194)
  den(1030) = den(1)*den(131)*den(166)
  den(1031) = den(6)*den(131)*den(166)
  den(1032) = den(1)*den(225)
  den(1033) = den(1)*den(118)*den(166)
  den(1034) = den(6)*den(118)*den(166)
  den(1035) = den(1)*den(91)*den(190)
  den(1036) = den(6)*den(91)*den(190)
  den(1037) = den(1)*den(148)*den(166)
  den(1038) = den(6)*den(148)*den(166)
  den(1039) = den(1)*den(238)
  den(1040) = den(1)*den(91)*den(166)
  den(1041) = den(6)*den(91)*den(166)
  den(1042) = den(1)*den(37)*den(174)
  den(1043) = den(6)*den(37)*den(174)
  den(1044) = den(1)*den(157)*den(166)
  den(1045) = den(6)*den(157)*den(166)
  den(1046) = den(1)*den(245)
  den(1047) = den(1)*den(37)*den(166)
  den(1048) = den(6)*den(37)*den(166)
  den(1049) = den(1)*den(769)
  den(1050) = den(6)*den(769)
  den(1051) = den(1)*den(770)
  den(1052) = den(6)*den(770)
  den(1053) = den(1)*den(771)
  den(1054) = den(6)*den(771)
  den(1055) = den(1)*den(772)
  den(1056) = den(6)*den(772)
  den(1057) = den(1)*den(773)
  den(1058) = den(6)*den(773)
  den(1059) = den(1)*den(774)
  den(1060) = den(6)*den(774)
  den(1061) = den(1)*den(14)*den(17)
  den(1062) = den(6)*den(14)*den(17)
  den(1063) = den(1)*den(13)*den(23)
  den(1064) = den(6)*den(13)*den(23)
  den(1065) = den(1)*den(262)
  den(1066) = den(1)*den(13)*den(14)
  den(1067) = den(6)*den(13)*den(14)
  den(1068) = den(1)*den(27)*den(30)
  den(1069) = den(6)*den(27)*den(30)
  den(1070) = den(1)*den(13)*den(34)
  den(1071) = den(6)*den(13)*den(34)
  den(1072) = den(1)*den(275)
  den(1073) = den(1)*den(13)*den(27)
  den(1074) = den(6)*den(13)*den(27)
  den(1075) = den(13)*den(37)*den(40)
  den(1076) = den(13)*den(37)*den(42)
  den(1077) = den(1)*den(37)*den(197)
  den(1078) = den(6)*den(37)*den(197)
  den(1079) = den(1)*den(13)*den(44)
  den(1080) = den(6)*den(13)*den(44)
  den(1081) = den(1)*den(13)*den(37)
  den(1082) = den(6)*den(13)*den(37)
  den(1083) = den(13)*den(438)
  den(1084) = den(13)*den(440)
  den(1085) = den(13)*den(448)
  den(1086) = den(13)*den(450)
  den(1087) = den(1)*den(780)
  den(1088) = den(6)*den(780)
  den(1089) = den(1)*den(781)
  den(1090) = den(6)*den(781)
  den(1091) = den(1)*den(782)
  den(1092) = den(6)*den(782)
  den(1093) = den(1)*den(445)
  den(1094) = den(6)*den(445)
  den(1095) = den(1)*den(788)
  den(1096) = den(6)*den(788)
  den(1097) = den(1)*den(442)
  den(1098) = den(6)*den(442)
  den(1099) = den(1)*den(52)*den(55)
  den(1100) = den(6)*den(52)*den(55)
  den(1101) = den(1)*den(51)*den(61)
  den(1102) = den(6)*den(51)*den(61)
  den(1103) = den(1)*den(290)
  den(1104) = den(1)*den(51)*den(52)
  den(1105) = den(6)*den(51)*den(52)
  den(1106) = den(1)*den(52)*den(66)
  den(1107) = den(6)*den(52)*den(66)
  den(1108) = den(1)*den(65)*den(71)
  den(1109) = den(6)*den(65)*den(71)
  den(1110) = den(1)*den(303)
  den(1111) = den(1)*den(52)*den(65)
  den(1112) = den(6)*den(52)*den(65)
  den(1113) = den(4)*den(37)*den(52)
  den(1114) = den(7)*den(37)*den(52)
  den(1115) = den(1)*den(37)*den(200)
  den(1116) = den(6)*den(37)*den(200)
  den(1117) = den(1)*den(52)*den(78)
  den(1118) = den(6)*den(52)*den(78)
  den(1119) = den(1)*den(37)*den(52)
  den(1120) = den(6)*den(37)*den(52)
  den(1121) = den(52)*den(512)
  den(1122) = den(52)*den(514)
  den(1123) = den(52)*den(518)
  den(1124) = den(52)*den(520)
  den(1125) = den(1)*den(804)
  den(1126) = den(6)*den(804)
  den(1127) = den(1)*den(805)
  den(1128) = den(6)*den(805)
  den(1129) = den(1)*den(806)
  den(1130) = den(6)*den(806)
  den(1131) = den(1)*den(807)
  den(1132) = den(6)*den(807)
  den(1133) = den(1)*den(506)
  den(1134) = den(6)*den(506)
  den(1135) = den(1)*den(503)
  den(1136) = den(6)*den(503)
  den(1137) = den(1)*den(27)*den(85)
  den(1138) = den(6)*den(27)*den(85)
  den(1139) = den(1)*den(51)*den(88)
  den(1140) = den(6)*den(51)*den(88)
  den(1141) = den(1)*den(337)
  den(1142) = den(1)*den(27)*den(51)
  den(1143) = den(6)*den(27)*den(51)
  den(1144) = den(40)*den(51)*den(91)
  den(1145) = den(42)*den(51)*den(91)
  den(1146) = den(1)*den(91)*den(203)
  den(1147) = den(6)*den(91)*den(203)
  den(1148) = den(1)*den(51)*den(95)
  den(1149) = den(6)*den(51)*den(95)
  den(1150) = den(1)*den(51)*den(91)
  den(1151) = den(6)*den(51)*den(91)
  den(1152) = den(51)*den(553)
  den(1153) = den(51)*den(555)
  den(1154) = den(51)*den(448)
  den(1155) = den(51)*den(450)
  den(1156) = den(1)*den(829)
  den(1157) = den(6)*den(829)
  den(1158) = den(1)*den(830)
  den(1159) = den(6)*den(830)
  den(1160) = den(1)*den(831)
  den(1161) = den(6)*den(831)
  den(1162) = den(1)*den(560)
  den(1163) = den(6)*den(560)
  den(1164) = den(1)*den(836)
  den(1165) = den(6)*den(836)
  den(1166) = den(1)*den(557)
  den(1167) = den(6)*den(557)
  den(1168) = den(1)*den(14)*den(102)
  den(1169) = den(6)*den(14)*den(102)
  den(1170) = den(1)*den(65)*den(105)
  den(1171) = den(6)*den(65)*den(105)
  den(1172) = den(1)*den(346)
  den(1173) = den(1)*den(14)*den(65)
  den(1174) = den(6)*den(14)*den(65)
  den(1175) = den(4)*den(14)*den(91)
  den(1176) = den(7)*den(14)*den(91)
  den(1177) = den(1)*den(91)*den(206)
  den(1178) = den(6)*den(91)*den(206)
  den(1179) = den(1)*den(14)*den(111)
  den(1180) = den(6)*den(14)*den(111)
  den(1181) = den(1)*den(14)*den(91)
  den(1182) = den(6)*den(14)*den(91)
  den(1183) = den(14)*den(604)
  den(1184) = den(14)*den(606)
  den(1185) = den(14)*den(518)
  den(1186) = den(14)*den(520)
  den(1187) = den(1)*den(852)
  den(1188) = den(6)*den(852)
  den(1189) = den(1)*den(853)
  den(1190) = den(6)*den(853)
  den(1191) = den(1)*den(854)
  den(1192) = den(6)*den(854)
  den(1193) = den(1)*den(855)
  den(1194) = den(6)*den(855)
  den(1195) = den(1)*den(598)
  den(1196) = den(6)*den(598)
  den(1197) = den(1)*den(595)
  den(1198) = den(6)*den(595)
  den(1199) = den(40)*den(65)*den(118)
  den(1200) = den(42)*den(65)*den(118)
  den(1201) = den(1)*den(118)*den(209)
  den(1202) = den(6)*den(118)*den(209)
  den(1203) = den(1)*den(65)*den(122)
  den(1204) = den(6)*den(65)*den(122)
  den(1205) = den(1)*den(65)*den(118)
  den(1206) = den(6)*den(65)*den(118)
  den(1207) = den(4)*den(27)*den(118)
  den(1208) = den(7)*den(27)*den(118)
  den(1209) = den(1)*den(118)*den(212)
  den(1210) = den(6)*den(118)*den(212)
  den(1211) = den(1)*den(27)*den(128)
  den(1212) = den(6)*den(27)*den(128)
  den(1213) = den(1)*den(27)*den(118)
  den(1214) = den(6)*den(27)*den(118)
  den(1215) = den(118)*den(666)
  den(1216) = den(118)*den(668)
  den(1217) = den(118)*den(518)
  den(1218) = den(118)*den(520)
  den(1219) = den(118)*den(657)
  den(1220) = den(118)*den(659)
  den(1221) = den(118)*den(448)
  den(1222) = den(118)*den(450)
  den(1223) = den(1)*den(879)
  den(1224) = den(6)*den(879)
  den(1225) = den(1)*den(880)
  den(1226) = den(6)*den(880)
  den(1227) = den(1)*den(672)
  den(1228) = den(6)*den(672)
  den(1229) = den(1)*den(647)
  den(1230) = den(6)*den(647)
  den(1231) = den(1)*den(653)
  den(1232) = den(6)*den(653)
  den(1233) = den(1)*den(644)
  den(1234) = den(6)*den(644)
  den(1235) = den(1)*den(131)
  den(1236) = den(6)*den(131)
  den(1237) = den(65)*den(553)
  den(1238) = den(65)*den(555)
  den(1239) = den(65)*den(438)
  den(1240) = den(65)*den(440)
  den(1241) = den(1)*den(894)
  den(1242) = den(6)*den(894)
  den(1243) = den(1)*den(895)
  den(1244) = den(6)*den(895)
  den(1245) = den(1)*den(896)
  den(1246) = den(6)*den(896)
  den(1247) = den(1)*den(687)
  den(1248) = den(6)*den(687)
  den(1249) = den(1)*den(901)
  den(1250) = den(6)*den(901)
  den(1251) = den(1)*den(684)
  den(1252) = den(6)*den(684)
  den(1253) = den(27)*den(604)
  den(1254) = den(27)*den(606)
  den(1255) = den(27)*den(512)
  den(1256) = den(27)*den(514)
  den(1257) = den(1)*den(916)
  den(1258) = den(6)*den(916)
  den(1259) = den(1)*den(917)
  den(1260) = den(6)*den(917)
  den(1261) = den(1)*den(918)
  den(1262) = den(6)*den(918)
  den(1263) = den(1)*den(919)
  den(1264) = den(6)*den(919)
  den(1265) = den(1)*den(697)
  den(1266) = den(6)*den(697)
  den(1267) = den(1)*den(694)
  den(1268) = den(6)*den(694)
  den(1269) = den(91)*den(666)
  den(1270) = den(91)*den(668)
  den(1271) = den(91)*den(512)
  den(1272) = den(91)*den(514)
  den(1273) = den(91)*den(657)
  den(1274) = den(91)*den(659)
  den(1275) = den(91)*den(438)
  den(1276) = den(91)*den(440)
  den(1277) = den(1)*den(942)
  den(1278) = den(6)*den(942)
  den(1279) = den(1)*den(943)
  den(1280) = den(6)*den(943)
  den(1281) = den(1)*den(732)
  den(1282) = den(6)*den(732)
  den(1283) = den(1)*den(712)
  den(1284) = den(6)*den(712)
  den(1285) = den(1)*den(718)
  den(1286) = den(6)*den(718)
  den(1287) = den(1)*den(709)
  den(1288) = den(6)*den(709)
  den(1289) = den(1)*den(148)
  den(1290) = den(6)*den(148)
  den(1291) = den(37)*den(666)
  den(1292) = den(37)*den(668)
  den(1293) = den(37)*den(604)
  den(1294) = den(37)*den(606)
  den(1295) = den(37)*den(657)
  den(1296) = den(37)*den(659)
  den(1297) = den(37)*den(553)
  den(1298) = den(37)*den(555)
  den(1299) = den(1)*den(960)
  den(1300) = den(6)*den(960)
  den(1301) = den(1)*den(961)
  den(1302) = den(6)*den(961)
  den(1303) = den(1)*den(759)
  den(1304) = den(6)*den(759)
  den(1305) = den(1)*den(742)
  den(1306) = den(6)*den(742)
  den(1307) = den(1)*den(745)
  den(1308) = den(6)*den(745)
  den(1309) = den(1)*den(739)
  den(1310) = den(6)*den(739)
  den(1311) = den(1)*den(157)
  den(1312) = den(6)*den(157)
  den(1313) = den(2)*den(666)
  den(1314) = den(2)*den(668)
  den(1315) = den(2)*den(657)
  den(1316) = den(2)*den(659)
  den(1317) = den(14)*den(791)
  den(1318) = den(14)*den(793)
  den(1319) = den(14)*den(798)
  den(1320) = den(14)*den(799)
  den(1321) = den(13)*den(864)
  den(1322) = den(13)*den(866)
  den(1323) = den(13)*den(869)
  den(1324) = den(13)*den(870)
  den(1325) = den(27)*den(785)
  den(1326) = den(27)*den(787)
  den(1327) = den(27)*den(796)
  den(1328) = den(27)*den(797)
  den(1329) = den(13)*den(927)
  den(1330) = den(13)*den(929)
  den(1331) = den(13)*den(932)
  den(1332) = den(13)*den(933)
  den(1333) = den(37)*den(777)
  den(1334) = den(37)*den(779)
  den(1335) = den(13)*den(957)
  den(1336) = den(13)*den(959)
  den(1337) = den(37)*den(794)
  den(1338) = den(37)*den(795)
  den(1339) = den(13)*den(967)
  den(1340) = den(13)*den(969)
  den(1341) = den(13)*den(1012)
  den(1342) = den(13)*den(1013)
  den(1343) = den(13)*den(1016)
  den(1344) = den(13)*den(1017)
  den(1345) = den(52)*den(839)
  den(1346) = den(52)*den(841)
  den(1347) = den(52)*den(846)
  den(1348) = den(52)*den(847)
  den(1349) = den(51)*den(817)
  den(1350) = den(51)*den(819)
  den(1351) = den(51)*den(822)
  den(1352) = den(51)*den(823)
  den(1353) = den(52)*den(903)
  den(1354) = den(52)*den(905)
  den(1355) = den(52)*den(910)
  den(1356) = den(52)*den(911)
  den(1357) = den(65)*den(812)
  den(1358) = den(65)*den(814)
  den(1359) = den(65)*den(820)
  den(1360) = den(65)*den(821)
  den(1361) = den(37)*den(801)
  den(1362) = den(37)*den(803)
  den(1363) = den(52)*den(953)
  den(1364) = den(52)*den(955)
  den(1365) = den(52)*den(963)
  den(1366) = den(52)*den(965)
  den(1367) = den(37)*den(808)
  den(1368) = den(37)*den(809)
  den(1369) = den(52)*den(986)
  den(1370) = den(52)*den(987)
  den(1371) = den(52)*den(992)
  den(1372) = den(52)*den(993)
  den(1373) = den(27)*den(833)
  den(1374) = den(27)*den(835)
  den(1375) = den(27)*den(844)
  den(1376) = den(27)*den(845)
  den(1377) = den(51)*den(923)
  den(1378) = den(51)*den(925)
  den(1379) = den(51)*den(930)
  den(1380) = den(51)*den(931)
  den(1381) = den(91)*den(826)
  den(1382) = den(91)*den(828)
  den(1383) = den(51)*den(939)
  den(1384) = den(51)*den(941)
  den(1385) = den(91)*den(842)
  den(1386) = den(91)*den(843)
  den(1387) = den(51)*den(949)
  den(1388) = den(51)*den(951)
  den(1389) = den(51)*den(1008)
  den(1390) = den(51)*den(1009)
  den(1391) = den(51)*den(1014)
  den(1392) = den(51)*den(1015)
  den(1393) = den(14)*den(898)
  den(1394) = den(14)*den(900)
  den(1395) = den(14)*den(908)
  den(1396) = den(14)*den(909)
  den(1397) = den(65)*den(859)
  den(1398) = den(65)*den(861)
  den(1399) = den(65)*den(867)
  den(1400) = den(65)*den(868)
  den(1401) = den(91)*den(849)
  den(1402) = den(91)*den(851)
  den(1403) = den(14)*den(935)
  den(1404) = den(14)*den(937)
  den(1405) = den(14)*den(945)
  den(1406) = den(14)*den(947)
  den(1407) = den(91)*den(856)
  den(1408) = den(91)*den(857)
  den(1409) = den(14)*den(980)
  den(1410) = den(14)*den(981)
  den(1411) = den(14)*den(990)
  den(1412) = den(14)*den(991)
  den(1413) = den(118)*den(891)
  den(1414) = den(118)*den(893)
  den(1415) = den(65)*den(876)
  den(1416) = den(65)*den(878)
  den(1417) = den(118)*den(906)
  den(1418) = den(118)*den(907)
  den(1419) = den(65)*den(886)
  den(1420) = den(65)*den(888)
  den(1421) = den(118)*den(913)
  den(1422) = den(118)*den(915)
  den(1423) = den(27)*den(872)
  den(1424) = den(27)*den(874)
  den(1425) = den(27)*den(882)
  den(1426) = den(27)*den(884)
  den(1427) = den(118)*den(920)
  den(1428) = den(118)*den(921)
  den(1429) = den(118)*den(974)
  den(1430) = den(118)*den(975)
  den(1431) = den(118)*den(988)
  den(1432) = den(118)*den(989)
  den(1433) = den(118)*den(998)
  den(1434) = den(118)*den(999)
  den(1435) = den(118)*den(1004)
  den(1436) = den(118)*den(1005)
  den(1437) = den(65)*den(1006)
  den(1438) = den(65)*den(1007)
  den(1439) = den(65)*den(1010)
  den(1440) = den(65)*den(1011)
  den(1441) = den(27)*den(978)
  den(1442) = den(27)*den(979)
  den(1443) = den(27)*den(984)
  den(1444) = den(27)*den(985)
  den(1445) = den(91)*den(972)
  den(1446) = den(91)*den(973)
  den(1447) = den(91)*den(982)
  den(1448) = den(91)*den(983)
  den(1449) = den(91)*den(996)
  den(1450) = den(91)*den(997)
  den(1451) = den(91)*den(1002)
  den(1452) = den(91)*den(1003)
  den(1453) = den(37)*den(970)
  den(1454) = den(37)*den(971)
  den(1455) = den(37)*den(976)
  den(1456) = den(37)*den(977)
  den(1457) = den(37)*den(994)
  den(1458) = den(37)*den(995)
  den(1459) = den(37)*den(1000)
  den(1460) = den(37)*den(1001)

end subroutine denominators

!
!
!
!
!
! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_ppllttj_eexttxggg_1_/**/DREALKIND, only: ntry, nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for e- e+ top anti-top glue glue glue -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppllttj_eexttxggg_1, only: external_perm_ppllttj_eexttxggg_1, &
    & external_perm_inv_ppllttj_eexttxggg_1, extcomb_perm_ppllttj_eexttxggg_1, &
    & average_factor_ppllttj_eexttxggg_1
  use ol_external_ppllttj_eexttxggg_1, only: H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppllttj_eexttxggg_1_/**/REALKIND, only: colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppllttj_eexttxggg_1_/**/REALKIND, only: check_forced_parameters
  use ol_heltables_OLR_ppllttj_eexttxggg_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: IR_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,7)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(29)
  logical, intent(in) :: qp_kinematics

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,7)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,7)
#endif
  integer           :: extmasses2(7)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(29)
  complex(REALKIND) :: M1(6), M2(11)
  real(REALKIND)    :: P_scatt_intern(0:3,7)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(6,128)
  type(Hpolcont) :: M1helarray_ct(11,128)
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(29), nextcombs, ind_cc_comb(14)

  type(Hpolcont) :: A(128,969)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(969)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call set_parameter("ew_renorm", 0)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, nMT, nMT, 0, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, external_perm_inv_ppllttj_eexttxggg_1, 7, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_Q(P(:,3), rMT, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rMT, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rZERO, H5, ex5, POLSEL(5),5)
  call pol_wf_V(P(:,6), rZERO, H6, ex6, POLSEL(6),6)
  call pol_wf_V(P(:,7), rZERO, H7, ex7, POLSEL(7),7)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_GGG_G(ntry, ex5(:), ex6(:), ex7(:), wf8(:,1), n4(:,1), t4x8(:,:,1))
  call vert_VQ_A(ntry, wf4(:,1), ex3(:), wf8(:,2), n3(:,2), t3x8(:,:,1))
  call vert_AV_Q(ntry, ex4(:), wf8(:,1), wf16(:,1), n3(:,3), t3x16(:,:,1))
  call prop_Q_A(ntry, wf8(:,2), 7, MT, 1_intkind1, wf8(:,3), n2(1))
  call vert_GGG_G(ntry, ex6(:), ex7(:), ex5(:), wf8(:,4), n4(:,2), t4x8(:,:,2))
  call vert_AV_Q(ntry, ex4(:), wf8(:,4), wf16(:,2), n3(:,4), t3x16(:,:,2))
  call vert_GGG_G(ntry, ex7(:), ex5(:), ex6(:), wf8(:,5), n4(:,3), t4x8(:,:,3))
  call vert_AV_Q(ntry, ex4(:), wf8(:,5), wf16(:,3), n3(:,5), t3x16(:,:,3))
  call vert_QA_Z(gZl,ntry, ex1(:), ex2(:), wf4(:,2), n3(:,6), t3x4(:,:,2))
  call prop_W_W(ntry, wf4(:,2), 3, MZ, 1_intkind1, wf4(:,3), n2(2))
  call vert_ZQ_A(gZu,ntry, wf4(:,3), ex3(:), wf8(:,6), n3(:,7), t3x8(:,:,2))
  call prop_Q_A(ntry, wf8(:,6), 7, MT, 1_intkind1, wf8(:,7), n2(3))
  call vert_VQ_A(ntry, wf8(:,1), ex3(:), wf16(:,4), n3(:,8), t3x16(:,:,4))
  call vert_AV_Q(ntry, ex4(:), wf4(:,1), wf8(:,8), n3(:,9), t3x8(:,:,3))
  call prop_Q_A(ntry, wf16(:,4), 116, MT, 1_intkind1, wf16(:,5), n2(4))
  call vert_VQ_A(ntry, wf8(:,4), ex3(:), wf16(:,6), n3(:,10), t3x16(:,:,5))
  call prop_Q_A(ntry, wf16(:,6), 116, MT, 1_intkind1, wf16(:,7), n2(5))
  call vert_VQ_A(ntry, wf8(:,5), ex3(:), wf16(:,8), n3(:,11), t3x16(:,:,6))
  call prop_Q_A(ntry, wf16(:,8), 116, MT, 1_intkind1, wf16(:,9), n2(6))
  call vert_AZ_Q(gZu,ntry, ex4(:), wf4(:,3), wf8(:,9), n3(:,12), t3x8(:,:,4))
  call vert_VQ_A(ntry, ex5(:), ex3(:), wf4(:,4), n3(:,13), t3x4(:,:,3))
  call vert_AV_Q(ntry, ex4(:), ex6(:), wf4(:,5), n3(:,14), t3x4(:,:,4))
  call prop_Q_A(ntry, wf4(:,4), 20, MT, 1_intkind1, wf4(:,6), n2(7))
  call prop_A_Q(ntry, wf4(:,5), 40, MT, 1_intkind1, wf4(:,7), n2(8))
  call vert_VQ_A(ntry, ex7(:), wf4(:,6), wf8(:,10), n3(:,15), t3x8(:,:,5))
  call vert_AV_Q(ntry, wf4(:,7), wf4(:,1), wf16(:,10), n3(:,16), t3x16(:,:,7))
  call prop_Q_A(ntry, wf8(:,10), 84, MT, 1_intkind1, wf8(:,11), n2(9))
  call vert_AZ_Q(gZu,ntry, wf4(:,7), wf4(:,3), wf16(:,11), n3(:,17), t3x16(:,:,8))
  call vert_AV_Q(ntry, wf4(:,7), ex7(:), wf8(:,12), n3(:,18), t3x8(:,:,6))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,6), wf16(:,12), n3(:,19), t3x16(:,:,9))
  call prop_A_Q(ntry, wf8(:,12), 104, MT, 1_intkind1, wf8(:,13), n2(10))
  call vert_ZQ_A(gZu,ntry, wf4(:,3), wf4(:,6), wf16(:,13), n3(:,20), t3x16(:,:,10))
  call vert_AV_Q(ntry, ex4(:), ex7(:), wf4(:,8), n3(:,21), t3x4(:,:,5))
  call prop_A_Q(ntry, wf4(:,8), 72, MT, 1_intkind1, wf4(:,9), n2(11))
  call vert_VQ_A(ntry, ex6(:), wf4(:,6), wf8(:,14), n3(:,22), t3x8(:,:,7))
  call vert_AV_Q(ntry, wf4(:,9), wf4(:,1), wf16(:,14), n3(:,23), t3x16(:,:,11))
  call prop_Q_A(ntry, wf8(:,14), 52, MT, 1_intkind1, wf8(:,15), n2(12))
  call vert_AZ_Q(gZu,ntry, wf4(:,9), wf4(:,3), wf16(:,15), n3(:,24), t3x16(:,:,12))
  call vert_AV_Q(ntry, wf4(:,9), ex6(:), wf8(:,16), n3(:,25), t3x8(:,:,8))
  call prop_A_Q(ntry, wf8(:,16), 104, MT, 1_intkind1, wf8(:,17), n2(13))
  call vert_UV_W(ntry, ex6(:), 32, ex7(:), 64, wf4(:,10), n3(:,26), t3x4(:,:,6))
  call vert_VQ_A(ntry, wf4(:,10), wf4(:,6), wf16(:,16), n3(:,27), t3x16(:,:,13))
  call prop_A_Q(ntry, wf8(:,8), 11, MT, 1_intkind1, wf8(:,18), n2(14))
  call prop_A_Q(ntry, wf8(:,9), 11, MT, 1_intkind1, wf8(:,19), n2(15))
  call vert_AV_Q(ntry, ex4(:), wf4(:,10), wf8(:,20), n3(:,28), t3x8(:,:,9))
  call prop_A_Q(ntry, wf8(:,20), 104, MT, 1_intkind1, wf8(:,21), n2(16))
  call vert_AV_Q(ntry, wf8(:,18), ex7(:), wf16(:,17), n3(:,29), t3x16(:,:,14))
  call vert_AV_Q(ntry, wf8(:,19), ex7(:), wf16(:,18), n3(:,30), t3x16(:,:,15))
  call vert_AV_Q(ntry, wf8(:,18), ex6(:), wf16(:,19), n3(:,31), t3x16(:,:,16))
  call vert_AV_Q(ntry, wf8(:,19), ex6(:), wf16(:,20), n3(:,32), t3x16(:,:,17))
  call vert_VQ_A(ntry, ex6(:), ex3(:), wf4(:,11), n3(:,33), t3x4(:,:,7))
  call vert_AV_Q(ntry, ex4(:), ex5(:), wf4(:,12), n3(:,34), t3x4(:,:,8))
  call prop_Q_A(ntry, wf4(:,11), 36, MT, 1_intkind1, wf4(:,13), n2(17))
  call prop_A_Q(ntry, wf4(:,12), 24, MT, 1_intkind1, wf4(:,14), n2(18))
  call vert_VQ_A(ntry, ex7(:), wf4(:,13), wf8(:,22), n3(:,35), t3x8(:,:,10))
  call vert_AV_Q(ntry, wf4(:,14), wf4(:,1), wf16(:,21), n3(:,36), t3x16(:,:,18))
  call prop_Q_A(ntry, wf8(:,22), 100, MT, 1_intkind1, wf8(:,23), n2(19))
  call vert_AZ_Q(gZu,ntry, wf4(:,14), wf4(:,3), wf16(:,22), n3(:,37), t3x16(:,:,19))
  call vert_AV_Q(ntry, wf4(:,14), ex7(:), wf8(:,24), n3(:,38), t3x8(:,:,11))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,13), wf16(:,23), n3(:,39), t3x16(:,:,20))
  call prop_A_Q(ntry, wf8(:,24), 88, MT, 1_intkind1, wf8(:,25), n2(20))
  call vert_ZQ_A(gZu,ntry, wf4(:,3), wf4(:,13), wf16(:,24), n3(:,40), t3x16(:,:,21))
  call vert_VQ_A(ntry, ex7(:), ex3(:), wf4(:,15), n3(:,41), t3x4(:,:,9))
  call prop_Q_A(ntry, wf4(:,15), 68, MT, 1_intkind1, wf4(:,16), n2(21))
  call vert_VQ_A(ntry, ex6(:), wf4(:,16), wf8(:,26), n3(:,42), t3x8(:,:,12))
  call prop_Q_A(ntry, wf8(:,26), 100, MT, 1_intkind1, wf8(:,27), n2(22))
  call vert_AV_Q(ntry, wf4(:,14), ex6(:), wf8(:,28), n3(:,43), t3x8(:,:,13))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,16), wf16(:,25), n3(:,44), t3x16(:,:,22))
  call prop_A_Q(ntry, wf8(:,28), 56, MT, 1_intkind1, wf8(:,29), n2(23))
  call vert_ZQ_A(gZu,ntry, wf4(:,3), wf4(:,16), wf16(:,26), n3(:,45), t3x16(:,:,23))
  call vert_AV_Q(ntry, wf4(:,14), wf4(:,10), wf16(:,27), n3(:,46), t3x16(:,:,24))
  call vert_VQ_A(ntry, wf4(:,10), ex3(:), wf8(:,30), n3(:,47), t3x8(:,:,14))
  call prop_Q_A(ntry, wf8(:,30), 100, MT, 1_intkind1, wf8(:,31), n2(24))
  call vert_VQ_A(ntry, ex6(:), wf8(:,3), wf16(:,28), n3(:,48), t3x16(:,:,25))
  call vert_VQ_A(ntry, ex6(:), wf8(:,7), wf16(:,29), n3(:,49), t3x16(:,:,26))
  call vert_VQ_A(ntry, ex7(:), wf8(:,3), wf16(:,30), n3(:,50), t3x16(:,:,27))
  call vert_VQ_A(ntry, ex7(:), wf8(:,7), wf16(:,31), n3(:,51), t3x16(:,:,28))
  call vert_VQ_A(ntry, ex5(:), wf4(:,13), wf8(:,32), n3(:,52), t3x8(:,:,15))
  call prop_Q_A(ntry, wf8(:,32), 52, MT, 1_intkind1, wf8(:,33), n2(25))
  call vert_AV_Q(ntry, wf4(:,9), ex5(:), wf8(:,34), n3(:,53), t3x8(:,:,16))
  call prop_A_Q(ntry, wf8(:,34), 88, MT, 1_intkind1, wf8(:,35), n2(26))
  call vert_UV_W(ntry, ex5(:), 16, ex7(:), 64, wf4(:,17), n3(:,54), t3x4(:,:,10))
  call vert_VQ_A(ntry, wf4(:,17), wf4(:,13), wf16(:,32), n3(:,55), t3x16(:,:,29))
  call vert_AV_Q(ntry, ex4(:), wf4(:,17), wf8(:,36), n3(:,56), t3x8(:,:,17))
  call prop_A_Q(ntry, wf8(:,36), 88, MT, 1_intkind1, wf8(:,37), n2(27))
  call vert_AV_Q(ntry, wf8(:,18), ex5(:), wf16(:,33), n3(:,57), t3x16(:,:,30))
  call vert_AV_Q(ntry, wf8(:,19), ex5(:), wf16(:,34), n3(:,58), t3x16(:,:,31))
  call vert_VQ_A(ntry, ex5(:), wf4(:,16), wf8(:,38), n3(:,59), t3x8(:,:,18))
  call prop_Q_A(ntry, wf8(:,38), 84, MT, 1_intkind1, wf8(:,39), n2(28))
  call vert_AV_Q(ntry, wf4(:,7), ex5(:), wf8(:,40), n3(:,60), t3x8(:,:,19))
  call prop_A_Q(ntry, wf8(:,40), 56, MT, 1_intkind1, wf8(:,41), n2(29))
  call vert_AV_Q(ntry, wf4(:,7), wf4(:,17), wf16(:,35), n3(:,61), t3x16(:,:,32))
  call vert_VQ_A(ntry, wf4(:,17), ex3(:), wf8(:,42), n3(:,62), t3x8(:,:,20))
  call prop_Q_A(ntry, wf8(:,42), 84, MT, 1_intkind1, wf8(:,43), n2(30))
  call vert_VQ_A(ntry, ex5(:), wf8(:,3), wf16(:,36), n3(:,63), t3x16(:,:,33))
  call vert_VQ_A(ntry, ex5(:), wf8(:,7), wf16(:,37), n3(:,64), t3x16(:,:,34))
  call vert_UV_W(ntry, ex5(:), 16, ex6(:), 32, wf4(:,18), n3(:,65), t3x4(:,:,11))
  call vert_VQ_A(ntry, wf4(:,18), wf4(:,16), wf16(:,38), n3(:,66), t3x16(:,:,35))
  call vert_AV_Q(ntry, ex4(:), wf4(:,18), wf8(:,44), n3(:,67), t3x8(:,:,21))
  call prop_A_Q(ntry, wf8(:,44), 56, MT, 1_intkind1, wf8(:,45), n2(31))
  call vert_AV_Q(ntry, wf4(:,9), wf4(:,18), wf16(:,39), n3(:,68), t3x16(:,:,36))
  call vert_VQ_A(ntry, wf4(:,18), ex3(:), wf8(:,46), n3(:,69), t3x8(:,:,22))
  call prop_Q_A(ntry, wf8(:,46), 52, MT, 1_intkind1, wf8(:,47), n2(32))
  call vert_UV_W(ntry, wf4(:,18), 48, ex7(:), 64, wf8(:,48), n3(:,70), t3x8(:,:,23))
  call vert_QA_V(ntry, wf8(:,3), ex4(:), wf16(:,40), n3(:,71), t3x16(:,:,37))
  call vert_QA_V(ntry, wf8(:,7), ex4(:), wf16(:,41), n3(:,72), t3x16(:,:,38))
  call vert_QA_V(ntry, ex3(:), wf8(:,18), wf16(:,42), n3(:,73), t3x16(:,:,39))
  call vert_QA_V(ntry, ex3(:), wf8(:,19), wf16(:,43), n3(:,74), t3x16(:,:,40))
  call vert_VQ_A(ntry, ex7(:), wf8(:,47), wf16(:,44), n3(:,75), t3x16(:,:,41))
  call vert_UV_W(ntry, ex6(:), 32, wf4(:,17), 80, wf8(:,49), n3(:,76), t3x8(:,:,24))
  call vert_VQ_A(ntry, ex6(:), wf8(:,43), wf16(:,45), n3(:,77), t3x16(:,:,42))
  call vert_UV_W(ntry, ex5(:), 16, wf4(:,10), 96, wf8(:,50), n3(:,78), t3x8(:,:,25))
  call vert_VQ_A(ntry, ex5(:), wf8(:,31), wf16(:,46), n3(:,79), t3x16(:,:,43))
  call vert_QA_V(ntry, ex3(:), ex4(:), wf4(:,19), n3(:,80), t3x4(:,:,12))
  call counter_VGG_G(ctAGGG,ntry, wf4(:,1), wf4(:,19), ex7(:), wf32(:,1), n4(:,4), t4x32(:,:,1))
  call counter_VGG_G(ctAGGG,ntry, wf4(:,1), ex7(:), wf4(:,19), wf32(:,2), n4(:,5), t4x32(:,:,2))
  call counter_VGG_G(ctZGGG,ntry, wf4(:,3), wf4(:,19), ex7(:), wf32(:,3), n4(:,6), t4x32(:,:,3))
  call counter_VGG_G(ctZGGG,ntry, wf4(:,3), ex7(:), wf4(:,19), wf32(:,4), n4(:,7), t4x32(:,:,4))
  call counter_VGG_G(ctAGGG,ntry, wf4(:,1), wf4(:,19), ex6(:), wf32(:,5), n4(:,8), t4x32(:,:,5))
  call counter_VGG_G(ctAGGG,ntry, wf4(:,1), ex6(:), wf4(:,19), wf32(:,6), n4(:,9), t4x32(:,:,6))
  call counter_VGG_G(ctZGGG,ntry, wf4(:,3), wf4(:,19), ex6(:), wf32(:,7), n4(:,10), t4x32(:,:,7))
  call counter_VGG_G(ctZGGG,ntry, wf4(:,3), ex6(:), wf4(:,19), wf32(:,8), n4(:,11), t4x32(:,:,8))
  call vert_UV_W(ntry, wf4(:,19), 12, ex5(:), 16, wf8(:,51), n3(:,81), t3x8(:,:,26))
  call counter_VGG_G(ctAGGG,ntry, wf4(:,1), ex6(:), ex7(:), wf16(:,47), n4(:,12), t4x16(:,:,1))
  call counter_VGG_G(ctAGGG,ntry, wf4(:,1), ex7(:), ex6(:), wf16(:,48), n4(:,13), t4x16(:,:,2))
  call counter_VGG_G(ctZGGG,ntry, wf4(:,3), ex6(:), ex7(:), wf16(:,49), n4(:,14), t4x16(:,:,3))
  call counter_VGG_G(ctZGGG,ntry, wf4(:,3), ex7(:), ex6(:), wf16(:,50), n4(:,15), t4x16(:,:,4))
  call counter_VG_G(ntry, wf4(:,3), wf4(:,19), 12, wf16(:,51), 15, n3(:,82), t3x16(:,:,44))
  call vert_GGG_G(ntry, wf4(:,19), ex5(:), ex6(:), wf16(:,52), n4(:,16), t4x16(:,:,5))
  call counter_VG_G(ntry, wf4(:,3), ex7(:), 64, wf8(:,52), 67, n3(:,83), t3x8(:,:,27))
  call vert_GGG_G(ntry, ex5(:), ex6(:), wf4(:,19), wf16(:,53), n4(:,17), t4x16(:,:,6))
  call vert_GGG_G(ntry, ex6(:), wf4(:,19), ex5(:), wf16(:,54), n4(:,18), t4x16(:,:,7))
  call vert_GGG_G(ntry, wf4(:,19), ex5(:), ex7(:), wf16(:,55), n4(:,19), t4x16(:,:,8))
  call counter_VG_G(ntry, wf4(:,3), ex6(:), 32, wf8(:,53), 35, n3(:,84), t3x8(:,:,28))
  call vert_GGG_G(ntry, ex5(:), ex7(:), wf4(:,19), wf16(:,56), n4(:,20), t4x16(:,:,9))
  call vert_GGG_G(ntry, ex7(:), wf4(:,19), ex5(:), wf16(:,57), n4(:,21), t4x16(:,:,10))
  call vert_GGG_G(ntry, wf4(:,19), ex6(:), ex7(:), wf16(:,58), n4(:,22), t4x16(:,:,11))
  call counter_VG_G(ntry, wf4(:,3), ex5(:), 16, wf8(:,54), 19, n3(:,85), t3x8(:,:,29))
  call vert_GGG_G(ntry, ex6(:), ex7(:), wf4(:,19), wf16(:,59), n4(:,23), t4x16(:,:,12))
  call vert_GGG_G(ntry, ex7(:), wf4(:,19), ex6(:), wf16(:,60), n4(:,24), t4x16(:,:,13))
  call counter_VGG_G(ctAGGG,ntry, wf4(:,1), wf4(:,19), ex5(:), wf32(:,9), n4(:,25), t4x32(:,:,9))
  call counter_VGG_G(ctAGGG,ntry, wf4(:,1), ex5(:), wf4(:,19), wf32(:,10), n4(:,26), t4x32(:,:,10))
  call counter_VGG_G(ctZGGG,ntry, wf4(:,3), wf4(:,19), ex5(:), wf32(:,11), n4(:,27), t4x32(:,:,11))
  call counter_VGG_G(ctZGGG,ntry, wf4(:,3), ex5(:), wf4(:,19), wf32(:,12), n4(:,28), t4x32(:,:,12))
  call vert_UV_W(ntry, wf4(:,19), 12, ex6(:), 32, wf8(:,55), n3(:,86), t3x8(:,:,30))
  call counter_VGG_G(ctAGGG,ntry, wf4(:,1), ex5(:), ex7(:), wf16(:,61), n4(:,29), t4x16(:,:,14))
  call counter_VGG_G(ctAGGG,ntry, wf4(:,1), ex7(:), ex5(:), wf16(:,62), n4(:,30), t4x16(:,:,15))
  call counter_VGG_G(ctZGGG,ntry, wf4(:,3), ex5(:), ex7(:), wf16(:,63), n4(:,31), t4x16(:,:,16))
  call counter_VGG_G(ctZGGG,ntry, wf4(:,3), ex7(:), ex5(:), wf16(:,64), n4(:,32), t4x16(:,:,17))
  call vert_UV_W(ntry, wf4(:,19), 12, ex7(:), 64, wf8(:,56), n3(:,87), t3x8(:,:,31))
  call counter_VGG_G(ctAGGG,ntry, wf4(:,1), ex5(:), ex6(:), wf16(:,65), n4(:,33), t4x16(:,:,18))
  call counter_VGG_G(ctAGGG,ntry, wf4(:,1), ex6(:), ex5(:), wf16(:,66), n4(:,34), t4x16(:,:,19))
  call counter_VGG_G(ctZGGG,ntry, wf4(:,3), ex5(:), ex6(:), wf16(:,67), n4(:,35), t4x16(:,:,20))
  call counter_VGG_G(ctZGGG,ntry, wf4(:,3), ex6(:), ex5(:), wf16(:,68), n4(:,36), t4x16(:,:,21))
  call vert_QA_V(ntry, wf4(:,6), ex4(:), wf8(:,57), n3(:,88), t3x8(:,:,32))
  call vert_QA_V(ntry, ex3(:), wf4(:,14), wf8(:,58), n3(:,89), t3x8(:,:,33))
  call vert_QA_V(ntry, wf4(:,13), ex4(:), wf8(:,59), n3(:,90), t3x8(:,:,34))
  call vert_QA_V(ntry, ex3(:), wf4(:,7), wf8(:,60), n3(:,91), t3x8(:,:,35))
  call vert_QA_V(ntry, wf4(:,16), ex4(:), wf8(:,61), n3(:,92), t3x8(:,:,36))
  call vert_QA_V(ntry, ex3(:), wf4(:,9), wf8(:,62), n3(:,93), t3x8(:,:,37))
  call counter_GGG_G(ntry, ex5(:), ex6(:), ex7(:), wf8(:,63), n4(:,37), t4x8(:,:,4))
  call vert_AV_Q(ntry, ex4(:), wf8(:,63), wf16(:,69), n3(:,94), t3x16(:,:,45))
  call counter_GGG_G(ntry, ex6(:), ex7(:), ex5(:), wf8(:,64), n4(:,38), t4x8(:,:,5))
  call vert_AV_Q(ntry, ex4(:), wf8(:,64), wf16(:,70), n3(:,95), t3x16(:,:,46))
  call counter_GGG_G(ntry, ex7(:), ex5(:), ex6(:), wf8(:,65), n4(:,39), t4x8(:,:,6))
  call vert_AV_Q(ntry, ex4(:), wf8(:,65), wf16(:,71), n3(:,96), t3x16(:,:,47))
  call vert_VQ_A(ntry, wf8(:,63), ex3(:), wf16(:,72), n3(:,97), t3x16(:,:,48))
  call prop_Q_A(ntry, wf16(:,72), 116, MT, 1_intkind1, wf16(:,73), n2(33))
  call vert_VQ_A(ntry, wf8(:,64), ex3(:), wf16(:,74), n3(:,98), t3x16(:,:,49))
  call prop_Q_A(ntry, wf16(:,74), 116, MT, 1_intkind1, wf16(:,75), n2(34))
  call vert_VQ_A(ntry, wf8(:,65), ex3(:), wf16(:,76), n3(:,99), t3x16(:,:,50))
  call prop_Q_A(ntry, wf16(:,76), 116, MT, 1_intkind1, wf16(:,77), n2(35))
  call counter_AV_Q(ntry, ex4(:), wf8(:,1), wf16(:,78), n3(:,100), t3x16(:,:,51))
  call counter_AV_Q(ntry, ex4(:), wf8(:,4), wf16(:,79), n3(:,101), t3x16(:,:,52))
  call counter_AV_Q(ntry, ex4(:), wf8(:,5), wf16(:,80), n3(:,102), t3x16(:,:,53))
  call counter_AV_Q(ntry, ex4(:), wf4(:,1), wf8(:,66), n3(:,103), t3x8(:,:,38))
  call counter_AZ_Q(gZu,ntry, ex4(:), wf4(:,3), wf8(:,67), n3(:,104), t3x8(:,:,39))
  call counter_VQ_A(ntry, wf8(:,1), ex3(:), wf16(:,81), n3(:,105), t3x16(:,:,54))
  call counter_VQ_A(ntry, wf8(:,4), ex3(:), wf16(:,82), n3(:,106), t3x16(:,:,55))
  call counter_VQ_A(ntry, wf8(:,5), ex3(:), wf16(:,83), n3(:,107), t3x16(:,:,56))
  call counter_VQ_A(ntry, wf4(:,1), ex3(:), wf8(:,68), n3(:,108), t3x8(:,:,40))
  call prop_A_Q(ntry, wf16(:,1), 120, MT, 1_intkind1, wf16(:,84), n2(36))
  call prop_A_Q(ntry, wf16(:,2), 120, MT, 1_intkind1, wf16(:,85), n2(37))
  call prop_A_Q(ntry, wf16(:,3), 120, MT, 1_intkind1, wf16(:,86), n2(38))
  call counter_ZQ_A(gZu,ntry, wf4(:,3), ex3(:), wf8(:,69), n3(:,109), t3x8(:,:,41))
  call counter_VG_G(ntry, wf4(:,3), wf4(:,18), 48, wf16(:,87), 51, n3(:,110), t3x16(:,:,57))
  call vert_UV_W(ntry, wf4(:,19), 12, wf4(:,18), 48, wf16(:,88), n3(:,111), t3x16(:,:,58))
  call counter_VG_G(ntry, wf4(:,3), wf4(:,17), 80, wf16(:,89), 83, n3(:,112), t3x16(:,:,59))
  call counter_VG_G(ntry, wf4(:,3), wf4(:,10), 96, wf16(:,90), 99, n3(:,113), t3x16(:,:,60))
  call vert_UV_W(ntry, wf8(:,51), 28, ex6(:), 32, wf16(:,91), n3(:,114), t3x16(:,:,61))
  call vert_UV_W(ntry, ex5(:), 16, wf8(:,55), 44, wf16(:,92), n3(:,115), t3x16(:,:,62))
  call vert_UV_W(ntry, wf4(:,19), 12, wf4(:,17), 80, wf16(:,93), n3(:,116), t3x16(:,:,63))
  call vert_UV_W(ntry, wf8(:,51), 28, ex7(:), 64, wf16(:,94), n3(:,117), t3x16(:,:,64))
  call vert_UV_W(ntry, ex5(:), 16, wf8(:,53), 35, wf16(:,95), n3(:,118), t3x16(:,:,65))
  call vert_UV_W(ntry, wf4(:,19), 12, wf4(:,10), 96, wf16(:,96), n3(:,119), t3x16(:,:,66))
  call vert_UV_W(ntry, wf8(:,54), 19, ex7(:), 64, wf16(:,97), n3(:,120), t3x16(:,:,67))
  call vert_UV_W(ntry, wf8(:,54), 19, ex6(:), 32, wf16(:,98), n3(:,121), t3x16(:,:,68))
  call counter_AV_Q(ntry, wf4(:,7), wf4(:,1), wf16(:,99), n3(:,122), t3x16(:,:,69))
  call counter_AZ_Q(gZu,ntry, wf4(:,7), wf4(:,3), wf16(:,100), n3(:,123), t3x16(:,:,70))
  call counter_VQ_A(ntry, wf4(:,1), wf4(:,6), wf16(:,101), n3(:,124), t3x16(:,:,71))
  call counter_ZQ_A(gZu,ntry, wf4(:,3), wf4(:,6), wf16(:,102), n3(:,125), t3x16(:,:,72))
  call counter_AV_Q(ntry, wf4(:,7), ex7(:), wf8(:,70), n3(:,126), t3x8(:,:,42))
  call prop_Q_A(ntry, wf16(:,12), 23, MT, 1_intkind1, wf16(:,103), n2(39))
  call prop_Q_A(ntry, wf16(:,13), 23, MT, 1_intkind1, wf16(:,104), n2(40))
  call counter_VQ_A(ntry, ex7(:), wf4(:,6), wf8(:,71), n3(:,127), t3x8(:,:,43))
  call prop_A_Q(ntry, wf16(:,10), 43, MT, 1_intkind1, wf16(:,105), n2(41))
  call prop_A_Q(ntry, wf16(:,11), 43, MT, 1_intkind1, wf16(:,106), n2(42))
  call vert_QA_V(ntry, wf4(:,6), wf4(:,7), wf16(:,107), n3(:,128), t3x16(:,:,73))
  call counter_AV_Q(ntry, wf4(:,9), wf4(:,1), wf16(:,108), n3(:,129), t3x16(:,:,74))
  call counter_AZ_Q(gZu,ntry, wf4(:,9), wf4(:,3), wf16(:,109), n3(:,130), t3x16(:,:,75))
  call counter_VQ_A(ntry, wf4(:,10), wf4(:,6), wf16(:,110), n3(:,131), t3x16(:,:,76))
  call counter_AV_Q(ntry, wf8(:,18), ex7(:), wf16(:,111), n3(:,132), t3x16(:,:,77))
  call counter_AV_Q(ntry, wf8(:,19), ex7(:), wf16(:,112), n3(:,133), t3x16(:,:,78))
  call prop_Q_A(ntry, wf8(:,71), 84, MT, 1_intkind1, wf8(:,72), n2(43))
  call vert_UV_W(ntry, wf8(:,57), 28, ex6(:), 32, wf16(:,113), n3(:,134), t3x16(:,:,79))
  call vert_QA_V(ntry, wf8(:,15), ex4(:), wf16(:,114), n3(:,135), t3x16(:,:,80))
  call counter_AV_Q(ntry, wf4(:,9), ex6(:), wf8(:,73), n3(:,136), t3x8(:,:,44))
  call counter_VQ_A(ntry, ex6(:), wf4(:,6), wf8(:,74), n3(:,137), t3x8(:,:,45))
  call prop_A_Q(ntry, wf16(:,14), 75, MT, 1_intkind1, wf16(:,115), n2(44))
  call prop_A_Q(ntry, wf16(:,15), 75, MT, 1_intkind1, wf16(:,116), n2(45))
  call vert_QA_V(ntry, wf4(:,6), wf4(:,9), wf16(:,117), n3(:,138), t3x16(:,:,81))
  call counter_AV_Q(ntry, wf8(:,18), ex6(:), wf16(:,118), n3(:,139), t3x16(:,:,82))
  call counter_AV_Q(ntry, wf8(:,19), ex6(:), wf16(:,119), n3(:,140), t3x16(:,:,83))
  call prop_Q_A(ntry, wf8(:,74), 52, MT, 1_intkind1, wf8(:,75), n2(46))
  call vert_UV_W(ntry, wf8(:,57), 28, ex7(:), 64, wf16(:,120), n3(:,141), t3x16(:,:,84))
  call vert_AV_Q(ntry, ex4(:), wf8(:,53), wf16(:,121), n3(:,142), t3x16(:,:,85))
  call counter_UV_W(ntry, ex6(:), 32, ex7(:), 64, wf4(:,20), n3(:,143), t3x4(:,:,13))
  call vert_VQ_A(ntry, wf4(:,20), wf4(:,6), wf16(:,122), n3(:,144), t3x16(:,:,86))
  call vert_AV_Q(ntry, ex4(:), wf4(:,20), wf8(:,76), n3(:,145), t3x8(:,:,46))
  call prop_A_Q(ntry, wf8(:,76), 104, MT, 1_intkind1, wf8(:,77), n2(47))
  call counter_AV_Q(ntry, wf4(:,14), wf4(:,1), wf16(:,123), n3(:,146), t3x16(:,:,87))
  call counter_AZ_Q(gZu,ntry, wf4(:,14), wf4(:,3), wf16(:,124), n3(:,147), t3x16(:,:,88))
  call counter_VQ_A(ntry, wf4(:,1), wf4(:,13), wf16(:,125), n3(:,148), t3x16(:,:,89))
  call counter_ZQ_A(gZu,ntry, wf4(:,3), wf4(:,13), wf16(:,126), n3(:,149), t3x16(:,:,90))
  call counter_AV_Q(ntry, wf4(:,14), ex7(:), wf8(:,78), n3(:,150), t3x8(:,:,47))
  call prop_Q_A(ntry, wf16(:,23), 39, MT, 1_intkind1, wf16(:,127), n2(48))
  call prop_Q_A(ntry, wf16(:,24), 39, MT, 1_intkind1, wf16(:,128), n2(49))
  call counter_VQ_A(ntry, ex7(:), wf4(:,13), wf8(:,79), n3(:,151), t3x8(:,:,48))
  call prop_A_Q(ntry, wf16(:,21), 27, MT, 1_intkind1, wf16(:,129), n2(50))
  call prop_A_Q(ntry, wf16(:,22), 27, MT, 1_intkind1, wf16(:,130), n2(51))
  call vert_QA_V(ntry, wf4(:,13), wf4(:,14), wf16(:,131), n3(:,152), t3x16(:,:,91))
  call counter_VQ_A(ntry, wf4(:,1), wf4(:,16), wf16(:,132), n3(:,153), t3x16(:,:,92))
  call counter_ZQ_A(gZu,ntry, wf4(:,3), wf4(:,16), wf16(:,133), n3(:,154), t3x16(:,:,93))
  call counter_AV_Q(ntry, wf4(:,14), wf4(:,10), wf16(:,134), n3(:,155), t3x16(:,:,94))
  call prop_A_Q(ntry, wf8(:,78), 88, MT, 1_intkind1, wf8(:,80), n2(52))
  call counter_VQ_A(ntry, ex7(:), wf8(:,3), wf16(:,135), n3(:,156), t3x16(:,:,95))
  call counter_VQ_A(ntry, ex7(:), wf8(:,7), wf16(:,136), n3(:,157), t3x16(:,:,96))
  call vert_UV_W(ntry, wf8(:,58), 28, ex6(:), 32, wf16(:,137), n3(:,158), t3x16(:,:,97))
  call vert_QA_V(ntry, ex3(:), wf8(:,29), wf16(:,138), n3(:,159), t3x16(:,:,98))
  call counter_AV_Q(ntry, wf4(:,14), ex6(:), wf8(:,81), n3(:,160), t3x8(:,:,49))
  call prop_Q_A(ntry, wf16(:,25), 71, MT, 1_intkind1, wf16(:,139), n2(53))
  call prop_Q_A(ntry, wf16(:,26), 71, MT, 1_intkind1, wf16(:,140), n2(54))
  call counter_VQ_A(ntry, ex6(:), wf4(:,16), wf8(:,82), n3(:,161), t3x8(:,:,50))
  call vert_QA_V(ntry, wf4(:,16), wf4(:,14), wf16(:,141), n3(:,162), t3x16(:,:,99))
  call prop_A_Q(ntry, wf8(:,81), 56, MT, 1_intkind1, wf8(:,83), n2(55))
  call counter_VQ_A(ntry, ex6(:), wf8(:,3), wf16(:,142), n3(:,163), t3x16(:,:,100))
  call counter_VQ_A(ntry, ex6(:), wf8(:,7), wf16(:,143), n3(:,164), t3x16(:,:,101))
  call vert_UV_W(ntry, wf8(:,58), 28, ex7(:), 64, wf16(:,144), n3(:,165), t3x16(:,:,102))
  call vert_VQ_A(ntry, wf8(:,53), ex3(:), wf16(:,145), n3(:,166), t3x16(:,:,103))
  call vert_AV_Q(ntry, wf4(:,14), wf4(:,20), wf16(:,146), n3(:,167), t3x16(:,:,104))
  call vert_VQ_A(ntry, wf4(:,20), ex3(:), wf8(:,84), n3(:,168), t3x8(:,:,51))
  call prop_Q_A(ntry, wf8(:,84), 100, MT, 1_intkind1, wf8(:,85), n2(56))
  call counter_VQ_A(ntry, wf4(:,17), wf4(:,13), wf16(:,147), n3(:,169), t3x16(:,:,105))
  call prop_Q_A(ntry, wf8(:,79), 100, MT, 1_intkind1, wf8(:,86), n2(57))
  call vert_UV_W(ntry, ex5(:), 16, wf8(:,59), 44, wf16(:,148), n3(:,170), t3x16(:,:,106))
  call vert_QA_V(ntry, wf8(:,33), ex4(:), wf16(:,149), n3(:,171), t3x16(:,:,107))
  call counter_AV_Q(ntry, wf4(:,7), wf4(:,17), wf16(:,150), n3(:,172), t3x16(:,:,108))
  call prop_A_Q(ntry, wf8(:,70), 104, MT, 1_intkind1, wf8(:,87), n2(58))
  call vert_UV_W(ntry, ex5(:), 16, wf8(:,60), 44, wf16(:,151), n3(:,173), t3x16(:,:,109))
  call vert_QA_V(ntry, ex3(:), wf8(:,41), wf16(:,152), n3(:,174), t3x16(:,:,110))
  call counter_VQ_A(ntry, wf4(:,18), wf4(:,16), wf16(:,153), n3(:,175), t3x16(:,:,111))
  call counter_AV_Q(ntry, wf4(:,9), wf4(:,18), wf16(:,154), n3(:,176), t3x16(:,:,112))
  call counter_UV_W(ntry, wf4(:,18), 48, ex7(:), 64, wf8(:,88), n3(:,177), t3x8(:,:,52))
  call counter_VQ_A(ntry, ex7(:), wf8(:,47), wf16(:,155), n3(:,178), t3x16(:,:,113))
  call vert_QA_V(ntry, wf8(:,47), ex4(:), wf16(:,156), n3(:,179), t3x16(:,:,114))
  call vert_QA_V(ntry, ex3(:), wf8(:,45), wf16(:,157), n3(:,180), t3x16(:,:,115))
  call prop_Q_A(ntry, wf8(:,82), 100, MT, 1_intkind1, wf8(:,89), n2(59))
  call vert_UV_W(ntry, ex5(:), 16, wf8(:,61), 76, wf16(:,158), n3(:,181), t3x16(:,:,116))
  call vert_QA_V(ntry, wf8(:,39), ex4(:), wf16(:,159), n3(:,182), t3x16(:,:,117))
  call prop_A_Q(ntry, wf8(:,73), 104, MT, 1_intkind1, wf8(:,90), n2(60))
  call vert_UV_W(ntry, ex5(:), 16, wf8(:,62), 76, wf16(:,160), n3(:,183), t3x16(:,:,118))
  call vert_QA_V(ntry, ex3(:), wf8(:,35), wf16(:,161), n3(:,184), t3x16(:,:,119))
  call counter_UV_W(ntry, ex6(:), 32, wf4(:,17), 80, wf8(:,91), n3(:,185), t3x8(:,:,53))
  call counter_VQ_A(ntry, ex6(:), wf8(:,43), wf16(:,162), n3(:,186), t3x16(:,:,120))
  call vert_QA_V(ntry, wf8(:,43), ex4(:), wf16(:,163), n3(:,187), t3x16(:,:,121))
  call vert_QA_V(ntry, ex3(:), wf8(:,37), wf16(:,164), n3(:,188), t3x16(:,:,122))
  call vert_UV_W(ntry, ex5(:), 16, wf4(:,20), 96, wf8(:,92), n3(:,189), t3x8(:,:,54))
  call vert_VQ_A(ntry, ex5(:), wf8(:,85), wf16(:,165), n3(:,190), t3x16(:,:,123))
  call counter_Q_A(cttt,6,ntry, wf8(:,3), 7, wf8(:,93), n2(61))
  call counter_Q_A(cttt,6,ntry, wf8(:,7), 7, wf8(:,94), n2(62))
  call counter_Q_A(cttt,6,ntry, wf16(:,5), 116, wf16(:,166), n2(63))
  call counter_Q_A(cttt,6,ntry, wf16(:,7), 116, wf16(:,167), n2(64))
  call counter_Q_A(cttt,6,ntry, wf16(:,9), 116, wf16(:,168), n2(65))
  call counter_V_V(ctGG,21,ntry, wf8(:,1), 112, wf8(:,95), n2(66))
  call vert_VQ_A(ntry, wf8(:,95), ex3(:), wf16(:,169), n3(:,191), t3x16(:,:,124))
  call counter_V_V(ctGG,21,ntry, wf8(:,4), 112, wf8(:,96), n2(67))
  call vert_VQ_A(ntry, wf8(:,96), ex3(:), wf16(:,170), n3(:,192), t3x16(:,:,125))
  call counter_V_V(ctGG,21,ntry, wf8(:,5), 112, wf8(:,97), n2(68))
  call vert_VQ_A(ntry, wf8(:,97), ex3(:), wf16(:,171), n3(:,193), t3x16(:,:,126))
  call vert_AV_Q(ntry, ex4(:), wf8(:,95), wf16(:,172), n3(:,194), t3x16(:,:,127))
  call vert_AV_Q(ntry, ex4(:), wf8(:,96), wf16(:,173), n3(:,195), t3x16(:,:,128))
  call vert_AV_Q(ntry, ex4(:), wf8(:,97), wf16(:,174), n3(:,196), t3x16(:,:,129))
  call counter_AV_Q(ntry, wf4(:,9), ex5(:), wf8(:,98), n3(:,197), t3x8(:,:,55))
  call counter_VQ_A(ntry, ex5(:), wf4(:,13), wf8(:,99), n3(:,198), t3x8(:,:,56))
  call vert_QA_V(ntry, wf4(:,13), wf4(:,9), wf16(:,175), n3(:,199), t3x16(:,:,130))
  call counter_AV_Q(ntry, wf8(:,18), ex5(:), wf16(:,176), n3(:,200), t3x16(:,:,131))
  call counter_AV_Q(ntry, wf8(:,19), ex5(:), wf16(:,177), n3(:,201), t3x16(:,:,132))
  call prop_Q_A(ntry, wf8(:,99), 52, MT, 1_intkind1, wf8(:,100), n2(69))
  call vert_UV_W(ntry, wf8(:,59), 44, ex7(:), 64, wf16(:,178), n3(:,202), t3x16(:,:,133))
  call vert_AV_Q(ntry, ex4(:), wf8(:,54), wf16(:,179), n3(:,203), t3x16(:,:,134))
  call counter_UV_W(ntry, ex5(:), 16, ex7(:), 64, wf4(:,21), n3(:,204), t3x4(:,:,14))
  call vert_VQ_A(ntry, wf4(:,21), wf4(:,13), wf16(:,180), n3(:,205), t3x16(:,:,135))
  call vert_AV_Q(ntry, ex4(:), wf4(:,21), wf8(:,101), n3(:,206), t3x8(:,:,57))
  call prop_A_Q(ntry, wf8(:,101), 88, MT, 1_intkind1, wf8(:,102), n2(70))
  call counter_AV_Q(ntry, wf4(:,7), ex5(:), wf8(:,103), n3(:,207), t3x8(:,:,58))
  call counter_VQ_A(ntry, ex5(:), wf4(:,16), wf8(:,104), n3(:,208), t3x8(:,:,59))
  call vert_QA_V(ntry, wf4(:,16), wf4(:,7), wf16(:,181), n3(:,209), t3x16(:,:,136))
  call prop_A_Q(ntry, wf8(:,103), 56, MT, 1_intkind1, wf8(:,105), n2(71))
  call counter_VQ_A(ntry, ex5(:), wf8(:,3), wf16(:,182), n3(:,210), t3x16(:,:,137))
  call counter_VQ_A(ntry, ex5(:), wf8(:,7), wf16(:,183), n3(:,211), t3x16(:,:,138))
  call vert_UV_W(ntry, wf8(:,60), 44, ex7(:), 64, wf16(:,184), n3(:,212), t3x16(:,:,139))
  call vert_VQ_A(ntry, wf8(:,54), ex3(:), wf16(:,185), n3(:,213), t3x16(:,:,140))
  call vert_AV_Q(ntry, wf4(:,7), wf4(:,21), wf16(:,186), n3(:,214), t3x16(:,:,141))
  call vert_VQ_A(ntry, wf4(:,21), ex3(:), wf8(:,106), n3(:,215), t3x8(:,:,60))
  call prop_Q_A(ntry, wf8(:,106), 84, MT, 1_intkind1, wf8(:,107), n2(72))
  call prop_Q_A(ntry, wf8(:,104), 84, MT, 1_intkind1, wf8(:,108), n2(73))
  call vert_UV_W(ntry, ex6(:), 32, wf8(:,61), 76, wf16(:,187), n3(:,216), t3x16(:,:,142))
  call prop_A_Q(ntry, wf8(:,98), 88, MT, 1_intkind1, wf8(:,109), n2(74))
  call vert_UV_W(ntry, ex6(:), 32, wf8(:,62), 76, wf16(:,188), n3(:,217), t3x16(:,:,143))
  call counter_UV_W(ntry, ex5(:), 16, wf4(:,10), 96, wf8(:,110), n3(:,218), t3x8(:,:,61))
  call counter_VQ_A(ntry, ex5(:), wf8(:,31), wf16(:,189), n3(:,219), t3x16(:,:,144))
  call vert_QA_V(ntry, wf8(:,31), ex4(:), wf16(:,190), n3(:,220), t3x16(:,:,145))
  call vert_QA_V(ntry, ex3(:), wf8(:,21), wf16(:,191), n3(:,221), t3x16(:,:,146))
  call vert_UV_W(ntry, ex6(:), 32, wf4(:,21), 80, wf8(:,111), n3(:,222), t3x8(:,:,62))
  call vert_VQ_A(ntry, ex6(:), wf8(:,107), wf16(:,192), n3(:,223), t3x16(:,:,147))
  call counter_UV_W(ntry, ex5(:), 16, ex6(:), 32, wf4(:,22), n3(:,224), t3x4(:,:,15))
  call vert_VQ_A(ntry, wf4(:,22), wf4(:,16), wf16(:,193), n3(:,225), t3x16(:,:,148))
  call vert_AV_Q(ntry, ex4(:), wf4(:,22), wf8(:,112), n3(:,226), t3x8(:,:,63))
  call prop_A_Q(ntry, wf8(:,112), 56, MT, 1_intkind1, wf8(:,113), n2(75))
  call vert_AV_Q(ntry, wf4(:,9), wf4(:,22), wf16(:,194), n3(:,227), t3x16(:,:,149))
  call vert_VQ_A(ntry, wf4(:,22), ex3(:), wf8(:,114), n3(:,228), t3x8(:,:,64))
  call prop_Q_A(ntry, wf8(:,114), 52, MT, 1_intkind1, wf8(:,115), n2(76))
  call vert_UV_W(ntry, wf4(:,22), 48, ex7(:), 64, wf8(:,116), n3(:,229), t3x8(:,:,65))
  call vert_VQ_A(ntry, ex7(:), wf8(:,115), wf16(:,195), n3(:,230), t3x16(:,:,150))
  call counter_AV_Q(ntry, ex4(:), wf4(:,10), wf8(:,117), n3(:,231), t3x8(:,:,66))
  call prop_Q_A(ntry, wf16(:,16), 116, MT, 1_intkind1, wf16(:,196), n2(77))
  call prop_A_Q(ntry, wf8(:,66), 11, MT, 1_intkind1, wf8(:,118), n2(78))
  call vert_AV_Q(ntry, wf8(:,118), ex7(:), wf16(:,197), n3(:,232), t3x16(:,:,151))
  call prop_A_Q(ntry, wf8(:,67), 11, MT, 1_intkind1, wf8(:,119), n2(79))
  call vert_AV_Q(ntry, wf8(:,119), ex7(:), wf16(:,198), n3(:,233), t3x16(:,:,152))
  call vert_AV_Q(ntry, wf8(:,118), ex6(:), wf16(:,199), n3(:,234), t3x16(:,:,153))
  call vert_AV_Q(ntry, wf8(:,119), ex6(:), wf16(:,200), n3(:,235), t3x16(:,:,154))
  call counter_AV_Q(ntry, ex4(:), ex7(:), wf4(:,23), n3(:,236), t3x4(:,:,16))
  call prop_A_Q(ntry, wf4(:,23), 72, MT, 1_intkind1, wf4(:,24), n2(80))
  call vert_AV_Q(ntry, wf4(:,24), wf4(:,1), wf16(:,201), n3(:,237), t3x16(:,:,155))
  call vert_AZ_Q(gZu,ntry, wf4(:,24), wf4(:,3), wf16(:,202), n3(:,238), t3x16(:,:,156))
  call vert_AV_Q(ntry, wf4(:,24), ex6(:), wf8(:,120), n3(:,239), t3x8(:,:,67))
  call prop_A_Q(ntry, wf8(:,120), 104, MT, 1_intkind1, wf8(:,121), n2(81))
  call counter_AV_Q(ntry, ex4(:), ex6(:), wf4(:,25), n3(:,240), t3x4(:,:,17))
  call prop_A_Q(ntry, wf4(:,25), 40, MT, 1_intkind1, wf4(:,26), n2(82))
  call vert_AV_Q(ntry, wf4(:,26), wf4(:,1), wf16(:,203), n3(:,241), t3x16(:,:,157))
  call vert_AZ_Q(gZu,ntry, wf4(:,26), wf4(:,3), wf16(:,204), n3(:,242), t3x16(:,:,158))
  call vert_AV_Q(ntry, wf4(:,26), ex7(:), wf8(:,122), n3(:,243), t3x8(:,:,68))
  call prop_A_Q(ntry, wf8(:,122), 104, MT, 1_intkind1, wf8(:,123), n2(83))
  call counter_AV_Q(ntry, ex4(:), wf4(:,17), wf8(:,124), n3(:,244), t3x8(:,:,69))
  call prop_Q_A(ntry, wf16(:,32), 116, MT, 1_intkind1, wf16(:,205), n2(84))
  call vert_AV_Q(ntry, wf8(:,118), ex5(:), wf16(:,206), n3(:,245), t3x16(:,:,159))
  call vert_AV_Q(ntry, wf8(:,119), ex5(:), wf16(:,207), n3(:,246), t3x16(:,:,160))
  call vert_AV_Q(ntry, wf4(:,24), ex5(:), wf8(:,125), n3(:,247), t3x8(:,:,70))
  call prop_A_Q(ntry, wf8(:,125), 88, MT, 1_intkind1, wf8(:,126), n2(85))
  call counter_AV_Q(ntry, ex4(:), wf4(:,18), wf8(:,127), n3(:,248), t3x8(:,:,71))
  call prop_Q_A(ntry, wf16(:,38), 116, MT, 1_intkind1, wf16(:,208), n2(86))
  call prop_A_Q(ntry, wf8(:,127), 56, MT, 1_intkind1, wf8(:,128), n2(87))
  call counter_QA_V(ntry, wf8(:,3), ex4(:), wf16(:,209), n3(:,249), t3x16(:,:,161))
  call counter_QA_V(ntry, wf8(:,7), ex4(:), wf16(:,210), n3(:,250), t3x16(:,:,162))
  call vert_QA_V(ntry, ex3(:), wf8(:,118), wf16(:,211), n3(:,251), t3x16(:,:,163))
  call vert_QA_V(ntry, ex3(:), wf8(:,119), wf16(:,212), n3(:,252), t3x16(:,:,164))
  call vert_AV_Q(ntry, wf4(:,24), wf4(:,18), wf16(:,213), n3(:,253), t3x16(:,:,165))
  call prop_A_Q(ntry, wf8(:,124), 88, MT, 1_intkind1, wf8(:,129), n2(88))
  call prop_A_Q(ntry, wf8(:,117), 104, MT, 1_intkind1, wf8(:,130), n2(89))
  call vert_AV_Q(ntry, wf4(:,26), ex5(:), wf8(:,131), n3(:,254), t3x8(:,:,72))
  call prop_A_Q(ntry, wf8(:,131), 56, MT, 1_intkind1, wf8(:,132), n2(90))
  call vert_AV_Q(ntry, wf4(:,26), wf4(:,17), wf16(:,214), n3(:,255), t3x16(:,:,166))
  call counter_AV_Q(ntry, ex4(:), ex5(:), wf4(:,27), n3(:,256), t3x4(:,:,18))
  call prop_A_Q(ntry, wf4(:,27), 24, MT, 1_intkind1, wf4(:,28), n2(91))
  call vert_AV_Q(ntry, wf4(:,28), wf4(:,1), wf16(:,215), n3(:,257), t3x16(:,:,167))
  call vert_AZ_Q(gZu,ntry, wf4(:,28), wf4(:,3), wf16(:,216), n3(:,258), t3x16(:,:,168))
  call vert_AV_Q(ntry, wf4(:,28), ex7(:), wf8(:,133), n3(:,259), t3x8(:,:,73))
  call prop_A_Q(ntry, wf8(:,133), 88, MT, 1_intkind1, wf8(:,134), n2(92))
  call vert_AV_Q(ntry, wf4(:,28), ex6(:), wf8(:,135), n3(:,260), t3x8(:,:,74))
  call prop_A_Q(ntry, wf8(:,135), 56, MT, 1_intkind1, wf8(:,136), n2(93))
  call vert_AV_Q(ntry, wf4(:,28), wf4(:,10), wf16(:,217), n3(:,261), t3x16(:,:,169))
  call counter_VQ_A(ntry, wf4(:,10), ex3(:), wf8(:,137), n3(:,262), t3x8(:,:,75))
  call prop_A_Q(ntry, wf16(:,27), 120, MT, 1_intkind1, wf16(:,218), n2(94))
  call prop_Q_A(ntry, wf8(:,68), 7, MT, 1_intkind1, wf8(:,138), n2(95))
  call vert_VQ_A(ntry, ex6(:), wf8(:,138), wf16(:,219), n3(:,263), t3x16(:,:,170))
  call prop_Q_A(ntry, wf8(:,69), 7, MT, 1_intkind1, wf8(:,139), n2(96))
  call vert_VQ_A(ntry, ex6(:), wf8(:,139), wf16(:,220), n3(:,264), t3x16(:,:,171))
  call vert_VQ_A(ntry, ex7(:), wf8(:,138), wf16(:,221), n3(:,265), t3x16(:,:,172))
  call vert_VQ_A(ntry, ex7(:), wf8(:,139), wf16(:,222), n3(:,266), t3x16(:,:,173))
  call counter_VQ_A(ntry, ex7(:), ex3(:), wf4(:,29), n3(:,267), t3x4(:,:,19))
  call prop_Q_A(ntry, wf4(:,29), 68, MT, 1_intkind1, wf4(:,30), n2(97))
  call vert_VQ_A(ntry, ex6(:), wf4(:,30), wf8(:,140), n3(:,268), t3x8(:,:,76))
  call prop_Q_A(ntry, wf8(:,140), 100, MT, 1_intkind1, wf8(:,141), n2(98))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,30), wf16(:,223), n3(:,269), t3x16(:,:,174))
  call vert_ZQ_A(gZu,ntry, wf4(:,3), wf4(:,30), wf16(:,224), n3(:,270), t3x16(:,:,175))
  call counter_VQ_A(ntry, ex6(:), ex3(:), wf4(:,31), n3(:,271), t3x4(:,:,20))
  call prop_Q_A(ntry, wf4(:,31), 36, MT, 1_intkind1, wf4(:,32), n2(99))
  call vert_VQ_A(ntry, ex7(:), wf4(:,32), wf8(:,142), n3(:,272), t3x8(:,:,77))
  call prop_Q_A(ntry, wf8(:,142), 100, MT, 1_intkind1, wf8(:,143), n2(100))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,32), wf16(:,225), n3(:,273), t3x16(:,:,176))
  call vert_ZQ_A(gZu,ntry, wf4(:,3), wf4(:,32), wf16(:,226), n3(:,274), t3x16(:,:,177))
  call counter_VQ_A(ntry, wf4(:,17), ex3(:), wf8(:,144), n3(:,275), t3x8(:,:,78))
  call prop_A_Q(ntry, wf16(:,35), 120, MT, 1_intkind1, wf16(:,227), n2(101))
  call vert_VQ_A(ntry, ex5(:), wf8(:,138), wf16(:,228), n3(:,276), t3x16(:,:,178))
  call vert_VQ_A(ntry, ex5(:), wf8(:,139), wf16(:,229), n3(:,277), t3x16(:,:,179))
  call vert_VQ_A(ntry, ex5(:), wf4(:,30), wf8(:,145), n3(:,278), t3x8(:,:,79))
  call prop_Q_A(ntry, wf8(:,145), 84, MT, 1_intkind1, wf8(:,146), n2(102))
  call counter_VQ_A(ntry, wf4(:,18), ex3(:), wf8(:,147), n3(:,279), t3x8(:,:,80))
  call prop_A_Q(ntry, wf16(:,39), 120, MT, 1_intkind1, wf16(:,230), n2(103))
  call counter_QA_V(ntry, ex3(:), wf8(:,18), wf16(:,231), n3(:,280), t3x16(:,:,180))
  call counter_QA_V(ntry, ex3(:), wf8(:,19), wf16(:,232), n3(:,281), t3x16(:,:,181))
  call prop_Q_A(ntry, wf8(:,147), 52, MT, 1_intkind1, wf8(:,148), n2(104))
  call vert_VQ_A(ntry, ex7(:), wf8(:,148), wf16(:,233), n3(:,282), t3x16(:,:,182))
  call vert_QA_V(ntry, wf8(:,138), ex4(:), wf16(:,234), n3(:,283), t3x16(:,:,183))
  call vert_QA_V(ntry, wf8(:,139), ex4(:), wf16(:,235), n3(:,284), t3x16(:,:,184))
  call vert_VQ_A(ntry, wf4(:,18), wf4(:,30), wf16(:,236), n3(:,285), t3x16(:,:,185))
  call prop_Q_A(ntry, wf8(:,144), 84, MT, 1_intkind1, wf8(:,149), n2(105))
  call vert_VQ_A(ntry, ex6(:), wf8(:,149), wf16(:,237), n3(:,286), t3x16(:,:,186))
  call prop_Q_A(ntry, wf8(:,137), 100, MT, 1_intkind1, wf8(:,150), n2(106))
  call vert_VQ_A(ntry, ex5(:), wf8(:,150), wf16(:,238), n3(:,287), t3x16(:,:,187))
  call vert_VQ_A(ntry, ex5(:), wf4(:,32), wf8(:,151), n3(:,288), t3x8(:,:,81))
  call prop_Q_A(ntry, wf8(:,151), 52, MT, 1_intkind1, wf8(:,152), n2(107))
  call vert_VQ_A(ntry, wf4(:,17), wf4(:,32), wf16(:,239), n3(:,289), t3x16(:,:,188))
  call counter_VQ_A(ntry, ex5(:), ex3(:), wf4(:,33), n3(:,290), t3x4(:,:,21))
  call prop_Q_A(ntry, wf4(:,33), 20, MT, 1_intkind1, wf4(:,34), n2(108))
  call vert_VQ_A(ntry, ex7(:), wf4(:,34), wf8(:,153), n3(:,291), t3x8(:,:,82))
  call prop_Q_A(ntry, wf8(:,153), 84, MT, 1_intkind1, wf8(:,154), n2(109))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,34), wf16(:,240), n3(:,292), t3x16(:,:,189))
  call vert_ZQ_A(gZu,ntry, wf4(:,3), wf4(:,34), wf16(:,241), n3(:,293), t3x16(:,:,190))
  call vert_VQ_A(ntry, ex6(:), wf4(:,34), wf8(:,155), n3(:,294), t3x8(:,:,83))
  call prop_Q_A(ntry, wf8(:,155), 52, MT, 1_intkind1, wf8(:,156), n2(110))
  call vert_VQ_A(ntry, wf4(:,10), wf4(:,34), wf16(:,242), n3(:,295), t3x16(:,:,191))
  call counter_Q_A(cttt,6,ntry, wf4(:,6), 20, wf4(:,35), n2(111))
  call prop_Q_A(ntry, wf4(:,35), 20, MT, 1_intkind1, wf4(:,36), n2(112))
  call vert_VQ_A(ntry, ex7(:), wf4(:,36), wf8(:,157), n3(:,296), t3x8(:,:,84))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,36), wf16(:,243), n3(:,297), t3x16(:,:,192))
  call vert_ZQ_A(gZu,ntry, wf4(:,3), wf4(:,36), wf16(:,244), n3(:,298), t3x16(:,:,193))
  call counter_A_Q(cttt,6,ntry, wf4(:,7), 40, wf4(:,37), n2(113))
  call prop_A_Q(ntry, wf4(:,37), 40, MT, 1_intkind1, wf4(:,38), n2(114))
  call vert_AV_Q(ntry, wf4(:,38), ex7(:), wf8(:,158), n3(:,299), t3x8(:,:,85))
  call vert_AV_Q(ntry, wf4(:,38), wf4(:,1), wf16(:,245), n3(:,300), t3x16(:,:,194))
  call vert_AZ_Q(gZu,ntry, wf4(:,38), wf4(:,3), wf16(:,246), n3(:,301), t3x16(:,:,195))
  call counter_Q_A(cttt,6,ntry, wf8(:,11), 84, wf8(:,159), n2(115))
  call counter_A_Q(cttt,6,ntry, wf8(:,13), 104, wf8(:,160), n2(116))
  call vert_VQ_A(ntry, ex6(:), wf4(:,36), wf8(:,161), n3(:,302), t3x8(:,:,86))
  call counter_A_Q(cttt,6,ntry, wf4(:,9), 72, wf4(:,39), n2(117))
  call prop_A_Q(ntry, wf4(:,39), 72, MT, 1_intkind1, wf4(:,40), n2(118))
  call vert_AV_Q(ntry, wf4(:,40), ex6(:), wf8(:,162), n3(:,303), t3x8(:,:,87))
  call vert_AV_Q(ntry, wf4(:,40), wf4(:,1), wf16(:,247), n3(:,304), t3x16(:,:,196))
  call vert_AZ_Q(gZu,ntry, wf4(:,40), wf4(:,3), wf16(:,248), n3(:,305), t3x16(:,:,197))
  call counter_Q_A(cttt,6,ntry, wf8(:,15), 52, wf8(:,163), n2(119))
  call counter_A_Q(cttt,6,ntry, wf8(:,17), 104, wf8(:,164), n2(120))
  call vert_QA_V(ntry, wf4(:,36), wf8(:,18), wf32(:,13), n3(:,306), t3x32(:,:,1))
  call vert_QA_V(ntry, wf4(:,36), wf8(:,19), wf32(:,14), n3(:,307), t3x32(:,:,2))
  call counter_V_V(ctGG,21,ntry, wf4(:,10), 96, wf4(:,41), n2(121))
  call vert_AV_Q(ntry, ex4(:), wf4(:,41), wf8(:,165), n3(:,308), t3x8(:,:,88))
  call counter_A_Q(cttt,6,ntry, wf8(:,18), 11, wf8(:,166), n2(122))
  call counter_A_Q(cttt,6,ntry, wf8(:,19), 11, wf8(:,167), n2(123))
  call counter_A_Q(cttt,6,ntry, wf8(:,21), 104, wf8(:,168), n2(124))
  call vert_VQ_A(ntry, wf4(:,41), wf4(:,6), wf16(:,249), n3(:,309), t3x16(:,:,198))
  call prop_Q_A(ntry, wf8(:,161), 52, MT, 1_intkind1, wf8(:,169), n2(125))
  call prop_A_Q(ntry, wf16(:,19), 43, MT, 1_intkind1, wf16(:,250), n2(126))
  call prop_A_Q(ntry, wf16(:,20), 43, MT, 1_intkind1, wf16(:,251), n2(127))
  call vert_VQ_A(ntry, ex6(:), wf8(:,11), wf16(:,252), n3(:,310), t3x16(:,:,199))
  call prop_Q_A(ntry, wf16(:,252), 116, MT, 1_intkind1, wf16(:,253), n2(128))
  call vert_VQ_A(ntry, ex7(:), wf8(:,15), wf16(:,254), n3(:,311), t3x16(:,:,200))
  call prop_Q_A(ntry, wf16(:,254), 116, MT, 1_intkind1, wf16(:,255), n2(129))
  call prop_A_Q(ntry, wf16(:,17), 75, MT, 1_intkind1, wf16(:,256), n2(130))
  call prop_A_Q(ntry, wf16(:,18), 75, MT, 1_intkind1, wf16(:,257), n2(131))
  call counter_Q_A(cttt,6,ntry, wf4(:,13), 36, wf4(:,42), n2(132))
  call prop_Q_A(ntry, wf4(:,42), 36, MT, 1_intkind1, wf4(:,43), n2(133))
  call vert_VQ_A(ntry, ex7(:), wf4(:,43), wf8(:,170), n3(:,312), t3x8(:,:,89))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,43), wf16(:,258), n3(:,313), t3x16(:,:,201))
  call vert_ZQ_A(gZu,ntry, wf4(:,3), wf4(:,43), wf16(:,259), n3(:,314), t3x16(:,:,202))
  call counter_A_Q(cttt,6,ntry, wf4(:,14), 24, wf4(:,44), n2(134))
  call prop_A_Q(ntry, wf4(:,44), 24, MT, 1_intkind1, wf4(:,45), n2(135))
  call vert_AV_Q(ntry, wf4(:,45), ex7(:), wf8(:,171), n3(:,315), t3x8(:,:,90))
  call vert_AV_Q(ntry, wf4(:,45), wf4(:,1), wf16(:,260), n3(:,316), t3x16(:,:,203))
  call vert_AZ_Q(gZu,ntry, wf4(:,45), wf4(:,3), wf16(:,261), n3(:,317), t3x16(:,:,204))
  call counter_Q_A(cttt,6,ntry, wf8(:,23), 100, wf8(:,172), n2(136))
  call counter_A_Q(cttt,6,ntry, wf8(:,25), 88, wf8(:,173), n2(137))
  call counter_Q_A(cttt,6,ntry, wf4(:,16), 68, wf4(:,46), n2(138))
  call prop_Q_A(ntry, wf4(:,46), 68, MT, 1_intkind1, wf4(:,47), n2(139))
  call vert_VQ_A(ntry, ex6(:), wf4(:,47), wf8(:,174), n3(:,318), t3x8(:,:,91))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,47), wf16(:,262), n3(:,319), t3x16(:,:,205))
  call vert_ZQ_A(gZu,ntry, wf4(:,3), wf4(:,47), wf16(:,263), n3(:,320), t3x16(:,:,206))
  call vert_AV_Q(ntry, wf4(:,45), ex6(:), wf8(:,175), n3(:,321), t3x8(:,:,92))
  call counter_Q_A(cttt,6,ntry, wf8(:,27), 100, wf8(:,176), n2(140))
  call counter_A_Q(cttt,6,ntry, wf8(:,29), 56, wf8(:,177), n2(141))
  call vert_VQ_A(ntry, wf4(:,41), ex3(:), wf8(:,178), n3(:,322), t3x8(:,:,93))
  call counter_Q_A(cttt,6,ntry, wf8(:,31), 100, wf8(:,179), n2(142))
  call vert_QA_V(ntry, wf8(:,3), wf4(:,45), wf32(:,15), n3(:,323), t3x32(:,:,3))
  call vert_QA_V(ntry, wf8(:,7), wf4(:,45), wf32(:,16), n3(:,324), t3x32(:,:,4))
  call vert_VQ_A(ntry, wf4(:,41), wf8(:,3), wf32(:,17), n3(:,325), t3x32(:,:,5))
  call vert_VQ_A(ntry, wf4(:,41), wf8(:,7), wf32(:,18), n3(:,326), t3x32(:,:,6))
  call vert_AV_Q(ntry, wf8(:,25), ex6(:), wf16(:,264), n3(:,327), t3x16(:,:,207))
  call prop_A_Q(ntry, wf16(:,264), 120, MT, 1_intkind1, wf16(:,265), n2(143))
  call vert_AV_Q(ntry, wf8(:,29), ex7(:), wf16(:,266), n3(:,328), t3x16(:,:,208))
  call prop_A_Q(ntry, wf16(:,266), 120, MT, 1_intkind1, wf16(:,267), n2(144))
  call prop_A_Q(ntry, wf8(:,175), 56, MT, 1_intkind1, wf8(:,180), n2(145))
  call prop_Q_A(ntry, wf16(:,28), 39, MT, 1_intkind1, wf16(:,268), n2(146))
  call prop_Q_A(ntry, wf16(:,29), 39, MT, 1_intkind1, wf16(:,269), n2(147))
  call prop_Q_A(ntry, wf16(:,30), 71, MT, 1_intkind1, wf16(:,270), n2(148))
  call prop_Q_A(ntry, wf16(:,31), 71, MT, 1_intkind1, wf16(:,271), n2(149))
  call vert_VQ_A(ntry, ex5(:), wf4(:,43), wf8(:,181), n3(:,329), t3x8(:,:,94))
  call vert_AV_Q(ntry, wf4(:,40), ex5(:), wf8(:,182), n3(:,330), t3x8(:,:,95))
  call counter_Q_A(cttt,6,ntry, wf8(:,33), 52, wf8(:,183), n2(150))
  call counter_A_Q(cttt,6,ntry, wf8(:,35), 88, wf8(:,184), n2(151))
  call vert_QA_V(ntry, wf4(:,43), wf8(:,18), wf32(:,19), n3(:,331), t3x32(:,:,7))
  call vert_QA_V(ntry, wf4(:,43), wf8(:,19), wf32(:,20), n3(:,332), t3x32(:,:,8))
  call counter_V_V(ctGG,21,ntry, wf4(:,17), 80, wf4(:,48), n2(152))
  call vert_AV_Q(ntry, ex4(:), wf4(:,48), wf8(:,185), n3(:,333), t3x8(:,:,96))
  call counter_A_Q(cttt,6,ntry, wf8(:,37), 88, wf8(:,186), n2(153))
  call vert_VQ_A(ntry, wf4(:,48), wf4(:,13), wf16(:,272), n3(:,334), t3x16(:,:,209))
  call prop_Q_A(ntry, wf8(:,181), 52, MT, 1_intkind1, wf8(:,187), n2(154))
  call prop_A_Q(ntry, wf16(:,33), 27, MT, 1_intkind1, wf16(:,273), n2(155))
  call prop_A_Q(ntry, wf16(:,34), 27, MT, 1_intkind1, wf16(:,274), n2(156))
  call vert_VQ_A(ntry, ex5(:), wf8(:,23), wf16(:,275), n3(:,335), t3x16(:,:,210))
  call prop_Q_A(ntry, wf16(:,275), 116, MT, 1_intkind1, wf16(:,276), n2(157))
  call vert_VQ_A(ntry, ex7(:), wf8(:,33), wf16(:,277), n3(:,336), t3x16(:,:,211))
  call prop_Q_A(ntry, wf16(:,277), 116, MT, 1_intkind1, wf16(:,278), n2(158))
  call vert_VQ_A(ntry, ex5(:), wf4(:,47), wf8(:,188), n3(:,337), t3x8(:,:,97))
  call vert_AV_Q(ntry, wf4(:,38), ex5(:), wf8(:,189), n3(:,338), t3x8(:,:,98))
  call counter_Q_A(cttt,6,ntry, wf8(:,39), 84, wf8(:,190), n2(159))
  call counter_A_Q(cttt,6,ntry, wf8(:,41), 56, wf8(:,191), n2(160))
  call vert_VQ_A(ntry, wf4(:,48), ex3(:), wf8(:,192), n3(:,339), t3x8(:,:,99))
  call counter_Q_A(cttt,6,ntry, wf8(:,43), 84, wf8(:,193), n2(161))
  call vert_QA_V(ntry, wf8(:,3), wf4(:,38), wf32(:,21), n3(:,340), t3x32(:,:,9))
  call vert_QA_V(ntry, wf8(:,7), wf4(:,38), wf32(:,22), n3(:,341), t3x32(:,:,10))
  call vert_VQ_A(ntry, wf4(:,48), wf8(:,3), wf32(:,23), n3(:,342), t3x32(:,:,11))
  call vert_VQ_A(ntry, wf4(:,48), wf8(:,7), wf32(:,24), n3(:,343), t3x32(:,:,12))
  call vert_AV_Q(ntry, wf8(:,13), ex5(:), wf16(:,279), n3(:,344), t3x16(:,:,212))
  call prop_A_Q(ntry, wf16(:,279), 120, MT, 1_intkind1, wf16(:,280), n2(162))
  call vert_AV_Q(ntry, wf8(:,41), ex7(:), wf16(:,281), n3(:,345), t3x16(:,:,213))
  call prop_A_Q(ntry, wf16(:,281), 120, MT, 1_intkind1, wf16(:,282), n2(163))
  call prop_A_Q(ntry, wf8(:,189), 56, MT, 1_intkind1, wf8(:,194), n2(164))
  call prop_Q_A(ntry, wf16(:,36), 23, MT, 1_intkind1, wf16(:,283), n2(165))
  call prop_Q_A(ntry, wf16(:,37), 23, MT, 1_intkind1, wf16(:,284), n2(166))
  call vert_QA_V(ntry, wf4(:,47), wf8(:,18), wf32(:,25), n3(:,346), t3x32(:,:,13))
  call vert_QA_V(ntry, wf4(:,47), wf8(:,19), wf32(:,26), n3(:,347), t3x32(:,:,14))
  call counter_V_V(ctGG,21,ntry, wf4(:,18), 48, wf4(:,49), n2(167))
  call vert_AV_Q(ntry, ex4(:), wf4(:,49), wf8(:,195), n3(:,348), t3x8(:,:,100))
  call counter_A_Q(cttt,6,ntry, wf8(:,45), 56, wf8(:,196), n2(168))
  call vert_VQ_A(ntry, wf4(:,49), wf4(:,16), wf16(:,285), n3(:,349), t3x16(:,:,214))
  call vert_VQ_A(ntry, wf4(:,49), ex3(:), wf8(:,197), n3(:,350), t3x8(:,:,101))
  call counter_Q_A(cttt,6,ntry, wf8(:,47), 52, wf8(:,198), n2(169))
  call vert_QA_V(ntry, wf8(:,3), wf4(:,40), wf32(:,27), n3(:,351), t3x32(:,:,15))
  call vert_QA_V(ntry, wf8(:,7), wf4(:,40), wf32(:,28), n3(:,352), t3x32(:,:,16))
  call vert_VQ_A(ntry, wf4(:,49), wf8(:,3), wf32(:,29), n3(:,353), t3x32(:,:,17))
  call vert_VQ_A(ntry, wf4(:,49), wf8(:,7), wf32(:,30), n3(:,354), t3x32(:,:,18))
  call vert_AV_Q(ntry, ex4(:), wf8(:,48), wf16(:,286), n3(:,355), t3x16(:,:,215))
  call prop_A_Q(ntry, wf16(:,286), 120, MT, 1_intkind1, wf16(:,287), n2(170))
  call vert_VQ_A(ntry, wf8(:,48), ex3(:), wf16(:,288), n3(:,356), t3x16(:,:,216))
  call prop_Q_A(ntry, wf16(:,288), 116, MT, 1_intkind1, wf16(:,289), n2(171))
  call prop_Q_A(ntry, wf8(:,197), 52, MT, 1_intkind1, wf8(:,199), n2(172))
  call vert_AV_Q(ntry, wf8(:,45), ex7(:), wf16(:,290), n3(:,357), t3x16(:,:,217))
  call prop_A_Q(ntry, wf16(:,290), 120, MT, 1_intkind1, wf16(:,291), n2(173))
  call counter_V_V(ctGG,21,ntry, wf8(:,48), 112, wf8(:,200), n2(174))
  call prop_A_Q(ntry, wf8(:,195), 56, MT, 1_intkind1, wf8(:,201), n2(175))
  call prop_Q_A(ntry, wf16(:,44), 116, MT, 1_intkind1, wf16(:,292), n2(176))
  call vert_UV_W(ntry, wf4(:,49), 48, ex7(:), 64, wf8(:,202), n3(:,358), t3x8(:,:,102))
  call prop_Q_A(ntry, wf8(:,188), 84, MT, 1_intkind1, wf8(:,203), n2(177))
  call vert_VQ_A(ntry, ex5(:), wf8(:,27), wf16(:,293), n3(:,359), t3x16(:,:,218))
  call prop_Q_A(ntry, wf16(:,293), 116, MT, 1_intkind1, wf16(:,294), n2(178))
  call vert_VQ_A(ntry, ex6(:), wf8(:,39), wf16(:,295), n3(:,360), t3x16(:,:,219))
  call prop_Q_A(ntry, wf16(:,295), 116, MT, 1_intkind1, wf16(:,296), n2(179))
  call vert_AV_Q(ntry, wf8(:,17), ex5(:), wf16(:,297), n3(:,361), t3x16(:,:,220))
  call prop_A_Q(ntry, wf16(:,297), 120, MT, 1_intkind1, wf16(:,298), n2(180))
  call vert_AV_Q(ntry, wf8(:,35), ex6(:), wf16(:,299), n3(:,362), t3x16(:,:,221))
  call prop_A_Q(ntry, wf16(:,299), 120, MT, 1_intkind1, wf16(:,300), n2(181))
  call prop_A_Q(ntry, wf8(:,182), 88, MT, 1_intkind1, wf8(:,204), n2(182))
  call vert_AV_Q(ntry, ex4(:), wf8(:,49), wf16(:,301), n3(:,363), t3x16(:,:,222))
  call prop_A_Q(ntry, wf16(:,301), 120, MT, 1_intkind1, wf16(:,302), n2(183))
  call vert_VQ_A(ntry, wf8(:,49), ex3(:), wf16(:,303), n3(:,364), t3x16(:,:,223))
  call prop_Q_A(ntry, wf16(:,303), 116, MT, 1_intkind1, wf16(:,304), n2(184))
  call prop_Q_A(ntry, wf8(:,192), 84, MT, 1_intkind1, wf8(:,205), n2(185))
  call vert_AV_Q(ntry, wf8(:,37), ex6(:), wf16(:,305), n3(:,365), t3x16(:,:,224))
  call prop_A_Q(ntry, wf16(:,305), 120, MT, 1_intkind1, wf16(:,306), n2(186))
  call counter_V_V(ctGG,21,ntry, wf8(:,49), 112, wf8(:,206), n2(187))
  call prop_A_Q(ntry, wf8(:,185), 88, MT, 1_intkind1, wf8(:,207), n2(188))
  call prop_Q_A(ntry, wf16(:,45), 116, MT, 1_intkind1, wf16(:,307), n2(189))
  call vert_UV_W(ntry, ex6(:), 32, wf4(:,48), 80, wf8(:,208), n3(:,366), t3x8(:,:,103))
  call vert_AV_Q(ntry, ex4(:), wf8(:,50), wf16(:,308), n3(:,367), t3x16(:,:,225))
  call prop_A_Q(ntry, wf16(:,308), 120, MT, 1_intkind1, wf16(:,309), n2(190))
  call vert_VQ_A(ntry, wf8(:,50), ex3(:), wf16(:,310), n3(:,368), t3x16(:,:,226))
  call prop_Q_A(ntry, wf16(:,310), 116, MT, 1_intkind1, wf16(:,311), n2(191))
  call vert_AV_Q(ntry, wf8(:,21), ex5(:), wf16(:,312), n3(:,369), t3x16(:,:,227))
  call prop_A_Q(ntry, wf16(:,312), 120, MT, 1_intkind1, wf16(:,313), n2(192))
  call counter_V_V(ctGG,21,ntry, wf8(:,50), 112, wf8(:,209), n2(193))
  call prop_Q_A(ntry, wf8(:,178), 100, MT, 1_intkind1, wf8(:,210), n2(194))
  call prop_Q_A(ntry, wf16(:,46), 116, MT, 1_intkind1, wf16(:,314), n2(195))
  call prop_A_Q(ntry, wf8(:,165), 104, MT, 1_intkind1, wf8(:,211), n2(196))
  call vert_UV_W(ntry, ex5(:), 16, wf4(:,41), 96, wf8(:,212), n3(:,370), t3x8(:,:,104))
  call vert_UV_W(ntry, wf8(:,55), 44, ex7(:), 64, wf16(:,315), n3(:,371), t3x16(:,:,228))
  call vert_UV_W(ntry, ex5(:), 16, wf8(:,56), 76, wf16(:,316), n3(:,372), t3x16(:,:,229))
  call vert_UV_W(ntry, ex6(:), 32, wf8(:,56), 76, wf16(:,317), n3(:,373), t3x16(:,:,230))
  call vert_QA_V(ntry, wf4(:,6), wf8(:,18), wf32(:,31), n3(:,374), t3x32(:,:,19))
  call vert_QA_V(ntry, wf4(:,6), wf8(:,19), wf32(:,32), n3(:,375), t3x32(:,:,20))
  call vert_VQ_A(ntry, wf4(:,1), wf8(:,15), wf32(:,33), n3(:,376), t3x32(:,:,21))
  call prop_Q_A(ntry, wf32(:,33), 55, MT, 1_intkind1, wf32(:,34), n2(197))
  call vert_ZQ_A(gZu,ntry, wf4(:,3), wf8(:,15), wf32(:,35), n3(:,377), t3x32(:,:,22))
  call prop_Q_A(ntry, wf32(:,35), 55, MT, 1_intkind1, wf32(:,36), n2(198))
  call vert_QA_V(ntry, wf8(:,11), ex4(:), wf16(:,318), n3(:,378), t3x16(:,:,231))
  call vert_VQ_A(ntry, wf4(:,1), wf8(:,11), wf32(:,37), n3(:,379), t3x32(:,:,23))
  call prop_Q_A(ntry, wf32(:,37), 87, MT, 1_intkind1, wf32(:,38), n2(199))
  call vert_ZQ_A(gZu,ntry, wf4(:,3), wf8(:,11), wf32(:,39), n3(:,380), t3x32(:,:,24))
  call prop_Q_A(ntry, wf32(:,39), 87, MT, 1_intkind1, wf32(:,40), n2(200))
  call vert_QA_V(ntry, wf16(:,103), ex4(:), wf32(:,41), n3(:,381), t3x32(:,:,25))
  call vert_QA_V(ntry, wf16(:,104), ex4(:), wf32(:,42), n3(:,382), t3x32(:,:,26))
  call vert_VQ_A(ntry, ex6(:), wf16(:,103), wf32(:,43), n3(:,383), t3x32(:,:,27))
  call prop_Q_A(ntry, wf32(:,43), 55, MT, 1_intkind1, wf32(:,44), n2(201))
  call vert_VQ_A(ntry, ex6(:), wf16(:,104), wf32(:,45), n3(:,384), t3x32(:,:,28))
  call prop_Q_A(ntry, wf32(:,45), 55, MT, 1_intkind1, wf32(:,46), n2(202))
  call vert_VQ_A(ntry, ex7(:), wf16(:,103), wf32(:,47), n3(:,385), t3x32(:,:,29))
  call prop_Q_A(ntry, wf32(:,47), 87, MT, 1_intkind1, wf32(:,48), n2(203))
  call vert_VQ_A(ntry, ex7(:), wf16(:,104), wf32(:,49), n3(:,386), t3x32(:,:,30))
  call prop_Q_A(ntry, wf32(:,49), 87, MT, 1_intkind1, wf32(:,50), n2(204))
  call vert_QA_V(ntry, wf8(:,3), wf4(:,14), wf32(:,51), n3(:,387), t3x32(:,:,31))
  call vert_QA_V(ntry, wf8(:,7), wf4(:,14), wf32(:,52), n3(:,388), t3x32(:,:,32))
  call vert_QA_V(ntry, ex3(:), wf8(:,25), wf16(:,319), n3(:,389), t3x16(:,:,232))
  call vert_QA_V(ntry, ex3(:), wf16(:,129), wf32(:,53), n3(:,390), t3x32(:,:,33))
  call vert_QA_V(ntry, ex3(:), wf16(:,130), wf32(:,54), n3(:,391), t3x32(:,:,34))
  call vert_AV_Q(ntry, wf8(:,29), wf4(:,1), wf32(:,55), n3(:,392), t3x32(:,:,35))
  call prop_A_Q(ntry, wf32(:,55), 59, MT, 1_intkind1, wf32(:,56), n2(205))
  call vert_AZ_Q(gZu,ntry, wf8(:,29), wf4(:,3), wf32(:,57), n3(:,393), t3x32(:,:,36))
  call prop_A_Q(ntry, wf32(:,57), 59, MT, 1_intkind1, wf32(:,58), n2(206))
  call vert_AV_Q(ntry, wf8(:,25), wf4(:,1), wf32(:,59), n3(:,394), t3x32(:,:,37))
  call prop_A_Q(ntry, wf32(:,59), 91, MT, 1_intkind1, wf32(:,60), n2(207))
  call vert_AZ_Q(gZu,ntry, wf8(:,25), wf4(:,3), wf32(:,61), n3(:,395), t3x32(:,:,38))
  call prop_A_Q(ntry, wf32(:,61), 91, MT, 1_intkind1, wf32(:,62), n2(208))
  call vert_AV_Q(ntry, wf16(:,129), ex6(:), wf32(:,63), n3(:,396), t3x32(:,:,39))
  call prop_A_Q(ntry, wf32(:,63), 59, MT, 1_intkind1, wf32(:,64), n2(209))
  call vert_AV_Q(ntry, wf16(:,130), ex6(:), wf32(:,65), n3(:,397), t3x32(:,:,40))
  call prop_A_Q(ntry, wf32(:,65), 59, MT, 1_intkind1, wf32(:,66), n2(210))
  call vert_AV_Q(ntry, wf16(:,129), ex7(:), wf32(:,67), n3(:,398), t3x32(:,:,41))
  call prop_A_Q(ntry, wf32(:,67), 91, MT, 1_intkind1, wf32(:,68), n2(211))
  call vert_AV_Q(ntry, wf16(:,130), ex7(:), wf32(:,69), n3(:,399), t3x32(:,:,42))
  call prop_A_Q(ntry, wf32(:,69), 91, MT, 1_intkind1, wf32(:,70), n2(212))
  call vert_QA_V(ntry, wf4(:,13), wf8(:,18), wf32(:,71), n3(:,400), t3x32(:,:,43))
  call vert_QA_V(ntry, wf4(:,13), wf8(:,19), wf32(:,72), n3(:,401), t3x32(:,:,44))
  call vert_VQ_A(ntry, wf4(:,1), wf8(:,33), wf32(:,73), n3(:,402), t3x32(:,:,45))
  call prop_Q_A(ntry, wf32(:,73), 55, MT, 1_intkind1, wf32(:,74), n2(213))
  call vert_ZQ_A(gZu,ntry, wf4(:,3), wf8(:,33), wf32(:,75), n3(:,403), t3x32(:,:,46))
  call prop_Q_A(ntry, wf32(:,75), 55, MT, 1_intkind1, wf32(:,76), n2(214))
  call vert_QA_V(ntry, wf8(:,23), ex4(:), wf16(:,320), n3(:,404), t3x16(:,:,233))
  call vert_VQ_A(ntry, wf4(:,1), wf8(:,23), wf32(:,77), n3(:,405), t3x32(:,:,47))
  call prop_Q_A(ntry, wf32(:,77), 103, MT, 1_intkind1, wf32(:,78), n2(215))
  call vert_ZQ_A(gZu,ntry, wf4(:,3), wf8(:,23), wf32(:,79), n3(:,406), t3x32(:,:,48))
  call prop_Q_A(ntry, wf32(:,79), 103, MT, 1_intkind1, wf32(:,80), n2(216))
  call vert_QA_V(ntry, wf16(:,127), ex4(:), wf32(:,81), n3(:,407), t3x32(:,:,49))
  call vert_QA_V(ntry, wf16(:,128), ex4(:), wf32(:,82), n3(:,408), t3x32(:,:,50))
  call vert_VQ_A(ntry, ex5(:), wf16(:,127), wf32(:,83), n3(:,409), t3x32(:,:,51))
  call prop_Q_A(ntry, wf32(:,83), 55, MT, 1_intkind1, wf32(:,84), n2(217))
  call vert_VQ_A(ntry, ex5(:), wf16(:,128), wf32(:,85), n3(:,410), t3x32(:,:,52))
  call prop_Q_A(ntry, wf32(:,85), 55, MT, 1_intkind1, wf32(:,86), n2(218))
  call vert_VQ_A(ntry, ex7(:), wf16(:,127), wf32(:,87), n3(:,411), t3x32(:,:,53))
  call prop_Q_A(ntry, wf32(:,87), 103, MT, 1_intkind1, wf32(:,88), n2(219))
  call vert_VQ_A(ntry, ex7(:), wf16(:,128), wf32(:,89), n3(:,412), t3x32(:,:,54))
  call prop_Q_A(ntry, wf32(:,89), 103, MT, 1_intkind1, wf32(:,90), n2(220))
  call vert_QA_V(ntry, wf8(:,3), wf4(:,7), wf32(:,91), n3(:,413), t3x32(:,:,55))
  call vert_QA_V(ntry, wf8(:,7), wf4(:,7), wf32(:,92), n3(:,414), t3x32(:,:,56))
  call vert_QA_V(ntry, ex3(:), wf8(:,13), wf16(:,321), n3(:,415), t3x16(:,:,234))
  call vert_QA_V(ntry, ex3(:), wf16(:,105), wf32(:,93), n3(:,416), t3x32(:,:,57))
  call vert_QA_V(ntry, ex3(:), wf16(:,106), wf32(:,94), n3(:,417), t3x32(:,:,58))
  call vert_AV_Q(ntry, wf8(:,41), wf4(:,1), wf32(:,95), n3(:,418), t3x32(:,:,59))
  call prop_A_Q(ntry, wf32(:,95), 59, MT, 1_intkind1, wf32(:,96), n2(221))
  call vert_AZ_Q(gZu,ntry, wf8(:,41), wf4(:,3), wf32(:,97), n3(:,419), t3x32(:,:,60))
  call prop_A_Q(ntry, wf32(:,97), 59, MT, 1_intkind1, wf32(:,98), n2(222))
  call vert_AV_Q(ntry, wf8(:,13), wf4(:,1), wf32(:,99), n3(:,420), t3x32(:,:,61))
  call prop_A_Q(ntry, wf32(:,99), 107, MT, 1_intkind1, wf32(:,100), n2(223))
  call vert_AZ_Q(gZu,ntry, wf8(:,13), wf4(:,3), wf32(:,101), n3(:,421), t3x32(:,:,62))
  call prop_A_Q(ntry, wf32(:,101), 107, MT, 1_intkind1, wf32(:,102), n2(224))
  call vert_AV_Q(ntry, wf16(:,105), ex5(:), wf32(:,103), n3(:,422), t3x32(:,:,63))
  call prop_A_Q(ntry, wf32(:,103), 59, MT, 1_intkind1, wf32(:,104), n2(225))
  call vert_AV_Q(ntry, wf16(:,106), ex5(:), wf32(:,105), n3(:,423), t3x32(:,:,64))
  call prop_A_Q(ntry, wf32(:,105), 59, MT, 1_intkind1, wf32(:,106), n2(226))
  call vert_AV_Q(ntry, wf16(:,105), ex7(:), wf32(:,107), n3(:,424), t3x32(:,:,65))
  call prop_A_Q(ntry, wf32(:,107), 107, MT, 1_intkind1, wf32(:,108), n2(227))
  call vert_AV_Q(ntry, wf16(:,106), ex7(:), wf32(:,109), n3(:,425), t3x32(:,:,66))
  call prop_A_Q(ntry, wf32(:,109), 107, MT, 1_intkind1, wf32(:,110), n2(228))
  call vert_VQ_A(ntry, wf4(:,18), wf8(:,3), wf32(:,111), n3(:,426), t3x32(:,:,67))
  call prop_Q_A(ntry, wf32(:,111), 55, MT, 1_intkind1, wf32(:,112), n2(229))
  call vert_VQ_A(ntry, wf4(:,18), wf8(:,7), wf32(:,113), n3(:,427), t3x32(:,:,68))
  call prop_Q_A(ntry, wf32(:,113), 55, MT, 1_intkind1, wf32(:,114), n2(230))
  call vert_AV_Q(ntry, wf8(:,18), wf4(:,18), wf32(:,115), n3(:,428), t3x32(:,:,69))
  call prop_A_Q(ntry, wf32(:,115), 59, MT, 1_intkind1, wf32(:,116), n2(231))
  call vert_AV_Q(ntry, wf8(:,19), wf4(:,18), wf32(:,117), n3(:,429), t3x32(:,:,70))
  call prop_A_Q(ntry, wf32(:,117), 59, MT, 1_intkind1, wf32(:,118), n2(232))
  call vert_VQ_A(ntry, wf4(:,1), wf8(:,47), wf32(:,119), n3(:,430), t3x32(:,:,71))
  call prop_Q_A(ntry, wf32(:,119), 55, MT, 1_intkind1, wf32(:,120), n2(233))
  call vert_ZQ_A(gZu,ntry, wf4(:,3), wf8(:,47), wf32(:,121), n3(:,431), t3x32(:,:,72))
  call prop_Q_A(ntry, wf32(:,121), 55, MT, 1_intkind1, wf32(:,122), n2(234))
  call vert_AV_Q(ntry, wf8(:,45), wf4(:,1), wf32(:,123), n3(:,432), t3x32(:,:,73))
  call prop_A_Q(ntry, wf32(:,123), 59, MT, 1_intkind1, wf32(:,124), n2(235))
  call vert_AZ_Q(gZu,ntry, wf8(:,45), wf4(:,3), wf32(:,125), n3(:,433), t3x32(:,:,74))
  call prop_A_Q(ntry, wf32(:,125), 59, MT, 1_intkind1, wf32(:,126), n2(236))
  call vert_QA_V(ntry, wf4(:,16), wf8(:,18), wf32(:,127), n3(:,434), t3x32(:,:,75))
  call vert_QA_V(ntry, wf4(:,16), wf8(:,19), wf32(:,128), n3(:,435), t3x32(:,:,76))
  call vert_VQ_A(ntry, wf4(:,1), wf8(:,39), wf32(:,129), n3(:,436), t3x32(:,:,77))
  call prop_Q_A(ntry, wf32(:,129), 87, MT, 1_intkind1, wf32(:,130), n2(237))
  call vert_ZQ_A(gZu,ntry, wf4(:,3), wf8(:,39), wf32(:,131), n3(:,437), t3x32(:,:,78))
  call prop_Q_A(ntry, wf32(:,131), 87, MT, 1_intkind1, wf32(:,132), n2(238))
  call vert_QA_V(ntry, wf8(:,27), ex4(:), wf16(:,322), n3(:,438), t3x16(:,:,235))
  call vert_VQ_A(ntry, wf4(:,1), wf8(:,27), wf32(:,133), n3(:,439), t3x32(:,:,79))
  call prop_Q_A(ntry, wf32(:,133), 103, MT, 1_intkind1, wf32(:,134), n2(239))
  call vert_ZQ_A(gZu,ntry, wf4(:,3), wf8(:,27), wf32(:,135), n3(:,440), t3x32(:,:,80))
  call prop_Q_A(ntry, wf32(:,135), 103, MT, 1_intkind1, wf32(:,136), n2(240))
  call vert_QA_V(ntry, wf16(:,139), ex4(:), wf32(:,137), n3(:,441), t3x32(:,:,81))
  call vert_QA_V(ntry, wf16(:,140), ex4(:), wf32(:,138), n3(:,442), t3x32(:,:,82))
  call vert_VQ_A(ntry, ex5(:), wf16(:,139), wf32(:,139), n3(:,443), t3x32(:,:,83))
  call prop_Q_A(ntry, wf32(:,139), 87, MT, 1_intkind1, wf32(:,140), n2(241))
  call vert_VQ_A(ntry, ex5(:), wf16(:,140), wf32(:,141), n3(:,444), t3x32(:,:,84))
  call prop_Q_A(ntry, wf32(:,141), 87, MT, 1_intkind1, wf32(:,142), n2(242))
  call vert_VQ_A(ntry, ex6(:), wf16(:,139), wf32(:,143), n3(:,445), t3x32(:,:,85))
  call prop_Q_A(ntry, wf32(:,143), 103, MT, 1_intkind1, wf32(:,144), n2(243))
  call vert_VQ_A(ntry, ex6(:), wf16(:,140), wf32(:,145), n3(:,446), t3x32(:,:,86))
  call prop_Q_A(ntry, wf32(:,145), 103, MT, 1_intkind1, wf32(:,146), n2(244))
  call vert_QA_V(ntry, wf8(:,3), wf4(:,9), wf32(:,147), n3(:,447), t3x32(:,:,87))
  call vert_QA_V(ntry, wf8(:,7), wf4(:,9), wf32(:,148), n3(:,448), t3x32(:,:,88))
  call vert_QA_V(ntry, ex3(:), wf8(:,17), wf16(:,323), n3(:,449), t3x16(:,:,236))
  call vert_QA_V(ntry, ex3(:), wf16(:,115), wf32(:,149), n3(:,450), t3x32(:,:,89))
  call vert_QA_V(ntry, ex3(:), wf16(:,116), wf32(:,150), n3(:,451), t3x32(:,:,90))
  call vert_AV_Q(ntry, wf8(:,35), wf4(:,1), wf32(:,151), n3(:,452), t3x32(:,:,91))
  call prop_A_Q(ntry, wf32(:,151), 91, MT, 1_intkind1, wf32(:,152), n2(245))
  call vert_AZ_Q(gZu,ntry, wf8(:,35), wf4(:,3), wf32(:,153), n3(:,453), t3x32(:,:,92))
  call prop_A_Q(ntry, wf32(:,153), 91, MT, 1_intkind1, wf32(:,154), n2(246))
  call vert_AV_Q(ntry, wf8(:,17), wf4(:,1), wf32(:,155), n3(:,454), t3x32(:,:,93))
  call prop_A_Q(ntry, wf32(:,155), 107, MT, 1_intkind1, wf32(:,156), n2(247))
  call vert_AZ_Q(gZu,ntry, wf8(:,17), wf4(:,3), wf32(:,157), n3(:,455), t3x32(:,:,94))
  call prop_A_Q(ntry, wf32(:,157), 107, MT, 1_intkind1, wf32(:,158), n2(248))
  call vert_AV_Q(ntry, wf16(:,115), ex5(:), wf32(:,159), n3(:,456), t3x32(:,:,95))
  call prop_A_Q(ntry, wf32(:,159), 91, MT, 1_intkind1, wf32(:,160), n2(249))
  call vert_AV_Q(ntry, wf16(:,116), ex5(:), wf32(:,161), n3(:,457), t3x32(:,:,96))
  call prop_A_Q(ntry, wf32(:,161), 91, MT, 1_intkind1, wf32(:,162), n2(250))
  call vert_AV_Q(ntry, wf16(:,115), ex6(:), wf32(:,163), n3(:,458), t3x32(:,:,97))
  call prop_A_Q(ntry, wf32(:,163), 107, MT, 1_intkind1, wf32(:,164), n2(251))
  call vert_AV_Q(ntry, wf16(:,116), ex6(:), wf32(:,165), n3(:,459), t3x32(:,:,98))
  call prop_A_Q(ntry, wf32(:,165), 107, MT, 1_intkind1, wf32(:,166), n2(252))
  call vert_VQ_A(ntry, wf4(:,17), wf8(:,3), wf32(:,167), n3(:,460), t3x32(:,:,99))
  call prop_Q_A(ntry, wf32(:,167), 87, MT, 1_intkind1, wf32(:,168), n2(253))
  call vert_VQ_A(ntry, wf4(:,17), wf8(:,7), wf32(:,169), n3(:,461), t3x32(:,:,100))
  call prop_Q_A(ntry, wf32(:,169), 87, MT, 1_intkind1, wf32(:,170), n2(254))
  call vert_AV_Q(ntry, wf8(:,18), wf4(:,17), wf32(:,171), n3(:,462), t3x32(:,:,101))
  call prop_A_Q(ntry, wf32(:,171), 91, MT, 1_intkind1, wf32(:,172), n2(255))
  call vert_AV_Q(ntry, wf8(:,19), wf4(:,17), wf32(:,173), n3(:,463), t3x32(:,:,102))
  call prop_A_Q(ntry, wf32(:,173), 91, MT, 1_intkind1, wf32(:,174), n2(256))
  call vert_VQ_A(ntry, wf4(:,1), wf8(:,43), wf32(:,175), n3(:,464), t3x32(:,:,103))
  call prop_Q_A(ntry, wf32(:,175), 87, MT, 1_intkind1, wf32(:,176), n2(257))
  call vert_ZQ_A(gZu,ntry, wf4(:,3), wf8(:,43), wf32(:,177), n3(:,465), t3x32(:,:,104))
  call prop_Q_A(ntry, wf32(:,177), 87, MT, 1_intkind1, wf32(:,178), n2(258))
  call vert_AV_Q(ntry, wf8(:,37), wf4(:,1), wf32(:,179), n3(:,466), t3x32(:,:,105))
  call prop_A_Q(ntry, wf32(:,179), 91, MT, 1_intkind1, wf32(:,180), n2(259))
  call vert_AZ_Q(gZu,ntry, wf8(:,37), wf4(:,3), wf32(:,181), n3(:,467), t3x32(:,:,106))
  call prop_A_Q(ntry, wf32(:,181), 91, MT, 1_intkind1, wf32(:,182), n2(260))
  call vert_VQ_A(ntry, wf4(:,10), wf8(:,3), wf32(:,183), n3(:,468), t3x32(:,:,107))
  call prop_Q_A(ntry, wf32(:,183), 103, MT, 1_intkind1, wf32(:,184), n2(261))
  call vert_VQ_A(ntry, wf4(:,10), wf8(:,7), wf32(:,185), n3(:,469), t3x32(:,:,108))
  call prop_Q_A(ntry, wf32(:,185), 103, MT, 1_intkind1, wf32(:,186), n2(262))
  call vert_AV_Q(ntry, wf8(:,18), wf4(:,10), wf32(:,187), n3(:,470), t3x32(:,:,109))
  call prop_A_Q(ntry, wf32(:,187), 107, MT, 1_intkind1, wf32(:,188), n2(263))
  call vert_AV_Q(ntry, wf8(:,19), wf4(:,10), wf32(:,189), n3(:,471), t3x32(:,:,110))
  call prop_A_Q(ntry, wf32(:,189), 107, MT, 1_intkind1, wf32(:,190), n2(264))
  call vert_VQ_A(ntry, wf4(:,1), wf8(:,31), wf32(:,191), n3(:,472), t3x32(:,:,111))
  call prop_Q_A(ntry, wf32(:,191), 103, MT, 1_intkind1, wf32(:,192), n2(265))
  call vert_ZQ_A(gZu,ntry, wf4(:,3), wf8(:,31), wf32(:,193), n3(:,473), t3x32(:,:,112))
  call prop_Q_A(ntry, wf32(:,193), 103, MT, 1_intkind1, wf32(:,194), n2(266))
  call vert_AV_Q(ntry, wf8(:,21), wf4(:,1), wf32(:,195), n3(:,474), t3x32(:,:,113))
  call prop_A_Q(ntry, wf32(:,195), 107, MT, 1_intkind1, wf32(:,196), n2(267))
  call vert_AZ_Q(gZu,ntry, wf8(:,21), wf4(:,3), wf32(:,197), n3(:,475), t3x32(:,:,114))
  call prop_A_Q(ntry, wf32(:,197), 107, MT, 1_intkind1, wf32(:,198), n2(268))
  call vert_UV_W(ntry, wf16(:,40), 15, ex5(:), 16, wf32(:,199), n3(:,476), t3x32(:,:,115))
  call vert_UV_W(ntry, wf16(:,41), 15, ex5(:), 16, wf32(:,200), n3(:,477), t3x32(:,:,116))
  call vert_UV_W(ntry, wf16(:,40), 15, ex6(:), 32, wf32(:,201), n3(:,478), t3x32(:,:,117))
  call vert_UV_W(ntry, wf16(:,41), 15, ex6(:), 32, wf32(:,202), n3(:,479), t3x32(:,:,118))
  call vert_UV_W(ntry, wf16(:,40), 15, ex7(:), 64, wf32(:,203), n3(:,480), t3x32(:,:,119))
  call vert_UV_W(ntry, wf16(:,41), 15, ex7(:), 64, wf32(:,204), n3(:,481), t3x32(:,:,120))
  call vert_QA_V(ntry, wf16(:,283), ex4(:), wf32(:,205), n3(:,482), t3x32(:,:,121))
  call vert_QA_V(ntry, wf16(:,284), ex4(:), wf32(:,206), n3(:,483), t3x32(:,:,122))
  call vert_VQ_A(ntry, ex6(:), wf16(:,283), wf32(:,207), n3(:,484), t3x32(:,:,123))
  call prop_Q_A(ntry, wf32(:,207), 55, MT, 1_intkind1, wf32(:,208), n2(269))
  call vert_VQ_A(ntry, ex6(:), wf16(:,284), wf32(:,209), n3(:,485), t3x32(:,:,124))
  call prop_Q_A(ntry, wf32(:,209), 55, MT, 1_intkind1, wf32(:,210), n2(270))
  call vert_VQ_A(ntry, ex7(:), wf16(:,283), wf32(:,211), n3(:,486), t3x32(:,:,125))
  call prop_Q_A(ntry, wf32(:,211), 87, MT, 1_intkind1, wf32(:,212), n2(271))
  call vert_VQ_A(ntry, ex7(:), wf16(:,284), wf32(:,213), n3(:,487), t3x32(:,:,126))
  call prop_Q_A(ntry, wf32(:,213), 87, MT, 1_intkind1, wf32(:,214), n2(272))
  call vert_QA_V(ntry, wf16(:,268), ex4(:), wf32(:,215), n3(:,488), t3x32(:,:,127))
  call vert_QA_V(ntry, wf16(:,269), ex4(:), wf32(:,216), n3(:,489), t3x32(:,:,128))
  call vert_VQ_A(ntry, ex5(:), wf16(:,268), wf32(:,217), n3(:,490), t3x32(:,:,129))
  call prop_Q_A(ntry, wf32(:,217), 55, MT, 1_intkind1, wf32(:,218), n2(273))
  call vert_VQ_A(ntry, ex5(:), wf16(:,269), wf32(:,219), n3(:,491), t3x32(:,:,130))
  call prop_Q_A(ntry, wf32(:,219), 55, MT, 1_intkind1, wf32(:,220), n2(274))
  call vert_VQ_A(ntry, ex7(:), wf16(:,268), wf32(:,221), n3(:,492), t3x32(:,:,131))
  call prop_Q_A(ntry, wf32(:,221), 103, MT, 1_intkind1, wf32(:,222), n2(275))
  call vert_VQ_A(ntry, ex7(:), wf16(:,269), wf32(:,223), n3(:,493), t3x32(:,:,132))
  call prop_Q_A(ntry, wf32(:,223), 103, MT, 1_intkind1, wf32(:,224), n2(276))
  call vert_QA_V(ntry, wf16(:,270), ex4(:), wf32(:,225), n3(:,494), t3x32(:,:,133))
  call vert_QA_V(ntry, wf16(:,271), ex4(:), wf32(:,226), n3(:,495), t3x32(:,:,134))
  call vert_VQ_A(ntry, ex5(:), wf16(:,270), wf32(:,227), n3(:,496), t3x32(:,:,135))
  call prop_Q_A(ntry, wf32(:,227), 87, MT, 1_intkind1, wf32(:,228), n2(277))
  call vert_VQ_A(ntry, ex5(:), wf16(:,271), wf32(:,229), n3(:,497), t3x32(:,:,136))
  call prop_Q_A(ntry, wf32(:,229), 87, MT, 1_intkind1, wf32(:,230), n2(278))
  call vert_VQ_A(ntry, ex6(:), wf16(:,270), wf32(:,231), n3(:,498), t3x32(:,:,137))
  call prop_Q_A(ntry, wf32(:,231), 103, MT, 1_intkind1, wf32(:,232), n2(279))
  call vert_VQ_A(ntry, ex6(:), wf16(:,271), wf32(:,233), n3(:,499), t3x32(:,:,138))
  call prop_Q_A(ntry, wf32(:,233), 103, MT, 1_intkind1, wf32(:,234), n2(280))
  call vert_UV_W(ntry, wf16(:,42), 15, ex5(:), 16, wf32(:,235), n3(:,500), t3x32(:,:,139))
  call vert_UV_W(ntry, wf16(:,43), 15, ex5(:), 16, wf32(:,236), n3(:,501), t3x32(:,:,140))
  call vert_UV_W(ntry, wf16(:,42), 15, ex6(:), 32, wf32(:,237), n3(:,502), t3x32(:,:,141))
  call vert_UV_W(ntry, wf16(:,43), 15, ex6(:), 32, wf32(:,238), n3(:,503), t3x32(:,:,142))
  call vert_UV_W(ntry, wf16(:,42), 15, ex7(:), 64, wf32(:,239), n3(:,504), t3x32(:,:,143))
  call vert_UV_W(ntry, wf16(:,43), 15, ex7(:), 64, wf32(:,240), n3(:,505), t3x32(:,:,144))
  call vert_QA_V(ntry, ex3(:), wf16(:,273), wf32(:,241), n3(:,506), t3x32(:,:,145))
  call vert_QA_V(ntry, ex3(:), wf16(:,274), wf32(:,242), n3(:,507), t3x32(:,:,146))
  call vert_QA_V(ntry, ex3(:), wf16(:,250), wf32(:,243), n3(:,508), t3x32(:,:,147))
  call vert_QA_V(ntry, ex3(:), wf16(:,251), wf32(:,244), n3(:,509), t3x32(:,:,148))
  call vert_QA_V(ntry, ex3(:), wf16(:,256), wf32(:,245), n3(:,510), t3x32(:,:,149))
  call vert_QA_V(ntry, ex3(:), wf16(:,257), wf32(:,246), n3(:,511), t3x32(:,:,150))
  call vert_AV_Q(ntry, wf16(:,273), ex6(:), wf32(:,247), n3(:,512), t3x32(:,:,151))
  call prop_A_Q(ntry, wf32(:,247), 59, MT, 1_intkind1, wf32(:,248), n2(281))
  call vert_AV_Q(ntry, wf16(:,274), ex6(:), wf32(:,249), n3(:,513), t3x32(:,:,152))
  call prop_A_Q(ntry, wf32(:,249), 59, MT, 1_intkind1, wf32(:,250), n2(282))
  call vert_AV_Q(ntry, wf16(:,273), ex7(:), wf32(:,251), n3(:,514), t3x32(:,:,153))
  call prop_A_Q(ntry, wf32(:,251), 91, MT, 1_intkind1, wf32(:,252), n2(283))
  call vert_AV_Q(ntry, wf16(:,274), ex7(:), wf32(:,253), n3(:,515), t3x32(:,:,154))
  call prop_A_Q(ntry, wf32(:,253), 91, MT, 1_intkind1, wf32(:,254), n2(284))
  call vert_AV_Q(ntry, wf16(:,250), ex5(:), wf32(:,255), n3(:,516), t3x32(:,:,155))
  call prop_A_Q(ntry, wf32(:,255), 59, MT, 1_intkind1, wf32(:,256), n2(285))
  call vert_AV_Q(ntry, wf16(:,251), ex5(:), wf32(:,257), n3(:,517), t3x32(:,:,156))
  call prop_A_Q(ntry, wf32(:,257), 59, MT, 1_intkind1, wf32(:,258), n2(286))
  call vert_AV_Q(ntry, wf16(:,250), ex7(:), wf32(:,259), n3(:,518), t3x32(:,:,157))
  call prop_A_Q(ntry, wf32(:,259), 107, MT, 1_intkind1, wf32(:,260), n2(287))
  call vert_AV_Q(ntry, wf16(:,251), ex7(:), wf32(:,261), n3(:,519), t3x32(:,:,158))
  call prop_A_Q(ntry, wf32(:,261), 107, MT, 1_intkind1, wf32(:,262), n2(288))
  call vert_AV_Q(ntry, wf16(:,256), ex5(:), wf32(:,263), n3(:,520), t3x32(:,:,159))
  call prop_A_Q(ntry, wf32(:,263), 91, MT, 1_intkind1, wf32(:,264), n2(289))
  call vert_AV_Q(ntry, wf16(:,257), ex5(:), wf32(:,265), n3(:,521), t3x32(:,:,160))
  call prop_A_Q(ntry, wf32(:,265), 91, MT, 1_intkind1, wf32(:,266), n2(290))
  call vert_AV_Q(ntry, wf16(:,256), ex6(:), wf32(:,267), n3(:,522), t3x32(:,:,161))
  call prop_A_Q(ntry, wf32(:,267), 107, MT, 1_intkind1, wf32(:,268), n2(291))
  call vert_AV_Q(ntry, wf16(:,257), ex6(:), wf32(:,269), n3(:,523), t3x32(:,:,162))
  call prop_A_Q(ntry, wf32(:,269), 107, MT, 1_intkind1, wf32(:,270), n2(292))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_exwf(ex5)
  call init_hybrid_exwf(ex6)
  call init_hybrid_exwf(ex7)
  call init_hybrid_wf(wf4)
  call init_hybrid_wf(wf8)
  call init_hybrid_wf(wf16)
  call init_hybrid_wf(wf32)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do

  !! used for born-loop colour-correlators
  extcombs = [(i, i = 0, 29-1)]
  nextcombs = 7*(7+1)/2 + 1
  if(nextcombs>0) then
    allocate(extcombs_permuted(nextcombs))
  end if
  do k = 1, nextcombs
    extcombs_permuted(k) = extcomb_perm_ppllttj_eexttxggg_1(extcombs(k))
  end do




  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5,i6,i7
integer :: n

n=0

do i7= 1, 2
do i6= 1, 2
do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2) .OR. (ex7(i7)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf + ex7(i7)%hf
 end if
end do
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_QA(nsync, wf16(:,1), wf8(:,3), A(:,1), n3(:,524), t3x128(:,:,1), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,3), wf16(:,2), A(:,2), n3(:,525), t3x128(:,:,2), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,3), wf16(:,3), A(:,3), n3(:,526), t3x128(:,:,3), nhel, den(5))
    call Hcont_QA(nsync, wf16(:,1), wf8(:,7), A(:,4), n3(:,527), t3x128(:,:,4), nhel, den(8))
    call Hcont_QA(nsync, wf16(:,2), wf8(:,7), A(:,5), n3(:,528), t3x128(:,:,5), nhel, den(8))
    call Hcont_QA(nsync, wf16(:,3), wf8(:,7), A(:,6), n3(:,529), t3x128(:,:,6), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,5), A(:,7), n3(:,530), t3x128(:,:,7), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,7), A(:,8), n3(:,531), t3x128(:,:,8), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,9), A(:,9), n3(:,532), t3x128(:,:,9), nhel, den(11))
    call Hcont_QA(nsync, wf16(:,5), wf8(:,9), A(:,10), n3(:,533), t3x128(:,:,10), nhel, den(12))
    call Hcont_QA(nsync, wf16(:,7), wf8(:,9), A(:,11), n3(:,534), t3x128(:,:,11), nhel, den(12))
    call Hcont_QA(nsync, wf16(:,9), wf8(:,9), A(:,12), n3(:,535), t3x128(:,:,12), nhel, den(12))
    call Hcont_QA(nsync, wf16(:,10), wf8(:,11), A(:,13), n3(:,536), t3x128(:,:,13), nhel, den(18))
    call Hcont_QA(nsync, wf8(:,11), wf16(:,11), A(:,14), n3(:,537), t3x128(:,:,14), nhel, den(20))
    call Hcont_QA(nsync, wf16(:,12), wf8(:,13), A(:,15), n3(:,538), t3x128(:,:,15), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,13), wf16(:,13), A(:,16), n3(:,539), t3x128(:,:,16), nhel, den(26))
    call Hcont_QA(nsync, wf16(:,14), wf8(:,15), A(:,17), n3(:,540), t3x128(:,:,17), nhel, den(31))
    call Hcont_QA(nsync, wf8(:,15), wf16(:,15), A(:,18), n3(:,541), t3x128(:,:,18), nhel, den(33))
    call Hcont_QA(nsync, wf16(:,12), wf8(:,17), A(:,19), n3(:,542), t3x128(:,:,19), nhel, den(35))
    call Hcont_QA(nsync, wf16(:,13), wf8(:,17), A(:,20), n3(:,543), t3x128(:,:,20), nhel, den(36))
    call Hcont_QA(nsync, wf16(:,16), wf8(:,18), A(:,21), n3(:,544), t3x128(:,:,21), nhel, den(41))
    call Hcont_QA(nsync, wf16(:,16), wf8(:,19), A(:,22), n3(:,545), t3x128(:,:,22), nhel, den(43))
    call Hcont_QA(nsync, wf16(:,12), wf8(:,21), A(:,23), n3(:,546), t3x128(:,:,23), nhel, den(45))
    call Hcont_QA(nsync, wf16(:,13), wf8(:,21), A(:,24), n3(:,547), t3x128(:,:,24), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,15), wf16(:,17), A(:,25), n3(:,548), t3x128(:,:,25), nhel, den(47))
    call Hcont_QA(nsync, wf8(:,15), wf16(:,18), A(:,26), n3(:,549), t3x128(:,:,26), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,11), wf16(:,19), A(:,27), n3(:,550), t3x128(:,:,27), nhel, den(49))
    call Hcont_QA(nsync, wf8(:,11), wf16(:,20), A(:,28), n3(:,551), t3x128(:,:,28), nhel, den(50))
    call Hcont_QA(nsync, wf16(:,21), wf8(:,23), A(:,29), n3(:,552), t3x128(:,:,29), nhel, den(56))
    call Hcont_QA(nsync, wf8(:,23), wf16(:,22), A(:,30), n3(:,553), t3x128(:,:,30), nhel, den(58))
    call Hcont_QA(nsync, wf16(:,23), wf8(:,25), A(:,31), n3(:,554), t3x128(:,:,31), nhel, den(62))
    call Hcont_QA(nsync, wf8(:,25), wf16(:,24), A(:,32), n3(:,555), t3x128(:,:,32), nhel, den(64))
    call Hcont_QA(nsync, wf16(:,21), wf8(:,27), A(:,33), n3(:,556), t3x128(:,:,33), nhel, den(67))
    call Hcont_QA(nsync, wf16(:,22), wf8(:,27), A(:,34), n3(:,557), t3x128(:,:,34), nhel, den(68))
    call Hcont_QA(nsync, wf16(:,25), wf8(:,29), A(:,35), n3(:,558), t3x128(:,:,35), nhel, den(72))
    call Hcont_QA(nsync, wf8(:,29), wf16(:,26), A(:,36), n3(:,559), t3x128(:,:,36), nhel, den(74))
    call Hcont_QA(nsync, wf8(:,3), wf16(:,27), A(:,37), n3(:,560), t3x128(:,:,37), nhel, den(76))
    call Hcont_QA(nsync, wf8(:,7), wf16(:,27), A(:,38), n3(:,561), t3x128(:,:,38), nhel, den(77))
    call Hcont_QA(nsync, wf16(:,21), wf8(:,31), A(:,39), n3(:,562), t3x128(:,:,39), nhel, den(79))
    call Hcont_QA(nsync, wf16(:,22), wf8(:,31), A(:,40), n3(:,563), t3x128(:,:,40), nhel, den(80))
    call Hcont_QA(nsync, wf8(:,25), wf16(:,28), A(:,41), n3(:,564), t3x128(:,:,41), nhel, den(81))
    call Hcont_QA(nsync, wf8(:,25), wf16(:,29), A(:,42), n3(:,565), t3x128(:,:,42), nhel, den(82))
    call Hcont_QA(nsync, wf8(:,29), wf16(:,30), A(:,43), n3(:,566), t3x128(:,:,43), nhel, den(83))
    call Hcont_QA(nsync, wf8(:,29), wf16(:,31), A(:,44), n3(:,567), t3x128(:,:,44), nhel, den(84))
    call Hcont_QA(nsync, wf16(:,14), wf8(:,33), A(:,45), n3(:,568), t3x128(:,:,45), nhel, den(86))
    call Hcont_QA(nsync, wf16(:,15), wf8(:,33), A(:,46), n3(:,569), t3x128(:,:,46), nhel, den(87))
    call Hcont_QA(nsync, wf16(:,23), wf8(:,35), A(:,47), n3(:,570), t3x128(:,:,47), nhel, den(89))
    call Hcont_QA(nsync, wf16(:,24), wf8(:,35), A(:,48), n3(:,571), t3x128(:,:,48), nhel, den(90))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,32), A(:,49), n3(:,572), t3x128(:,:,49), nhel, den(93))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,32), A(:,50), n3(:,573), t3x128(:,:,50), nhel, den(94))
    call Hcont_QA(nsync, wf16(:,23), wf8(:,37), A(:,51), n3(:,574), t3x128(:,:,51), nhel, den(96))
    call Hcont_QA(nsync, wf16(:,24), wf8(:,37), A(:,52), n3(:,575), t3x128(:,:,52), nhel, den(97))
    call Hcont_QA(nsync, wf16(:,17), wf8(:,33), A(:,53), n3(:,576), t3x128(:,:,53), nhel, den(98))
    call Hcont_QA(nsync, wf16(:,18), wf8(:,33), A(:,54), n3(:,577), t3x128(:,:,54), nhel, den(99))
    call Hcont_QA(nsync, wf8(:,23), wf16(:,33), A(:,55), n3(:,578), t3x128(:,:,55), nhel, den(100))
    call Hcont_QA(nsync, wf8(:,23), wf16(:,34), A(:,56), n3(:,579), t3x128(:,:,56), nhel, den(101))
    call Hcont_QA(nsync, wf16(:,10), wf8(:,39), A(:,57), n3(:,580), t3x128(:,:,57), nhel, den(103))
    call Hcont_QA(nsync, wf16(:,11), wf8(:,39), A(:,58), n3(:,581), t3x128(:,:,58), nhel, den(104))
    call Hcont_QA(nsync, wf16(:,25), wf8(:,41), A(:,59), n3(:,582), t3x128(:,:,59), nhel, den(106))
    call Hcont_QA(nsync, wf16(:,26), wf8(:,41), A(:,60), n3(:,583), t3x128(:,:,60), nhel, den(107))
    call Hcont_QA(nsync, wf8(:,3), wf16(:,35), A(:,61), n3(:,584), t3x128(:,:,61), nhel, den(109))
    call Hcont_QA(nsync, wf8(:,7), wf16(:,35), A(:,62), n3(:,585), t3x128(:,:,62), nhel, den(110))
    call Hcont_QA(nsync, wf16(:,10), wf8(:,43), A(:,63), n3(:,586), t3x128(:,:,63), nhel, den(112))
    call Hcont_QA(nsync, wf16(:,11), wf8(:,43), A(:,64), n3(:,587), t3x128(:,:,64), nhel, den(113))
    call Hcont_QA(nsync, wf8(:,13), wf16(:,36), A(:,65), n3(:,588), t3x128(:,:,65), nhel, den(114))
    call Hcont_QA(nsync, wf8(:,13), wf16(:,37), A(:,66), n3(:,589), t3x128(:,:,66), nhel, den(115))
    call Hcont_QA(nsync, wf16(:,30), wf8(:,41), A(:,67), n3(:,590), t3x128(:,:,67), nhel, den(116))
    call Hcont_QA(nsync, wf16(:,31), wf8(:,41), A(:,68), n3(:,591), t3x128(:,:,68), nhel, den(117))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,38), A(:,69), n3(:,592), t3x128(:,:,69), nhel, den(120))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,38), A(:,70), n3(:,593), t3x128(:,:,70), nhel, den(121))
    call Hcont_QA(nsync, wf16(:,25), wf8(:,45), A(:,71), n3(:,594), t3x128(:,:,71), nhel, den(123))
    call Hcont_QA(nsync, wf16(:,26), wf8(:,45), A(:,72), n3(:,595), t3x128(:,:,72), nhel, den(124))
    call Hcont_QA(nsync, wf8(:,3), wf16(:,39), A(:,73), n3(:,596), t3x128(:,:,73), nhel, den(126))
    call Hcont_QA(nsync, wf8(:,7), wf16(:,39), A(:,74), n3(:,597), t3x128(:,:,74), nhel, den(127))
    call Hcont_QA(nsync, wf16(:,14), wf8(:,47), A(:,75), n3(:,598), t3x128(:,:,75), nhel, den(129))
    call Hcont_QA(nsync, wf16(:,15), wf8(:,47), A(:,76), n3(:,599), t3x128(:,:,76), nhel, den(130))
    call Hcont_VV(nsync, wf8(:,48), wf16(:,40), A(:,77), n3(:,600), t3x128(:,:,77), nhel, den(132))
    call Hcont_VV(nsync, wf8(:,48), wf16(:,41), A(:,78), n3(:,601), t3x128(:,:,78), nhel, den(133))
    call Hcont_QA(nsync, wf16(:,30), wf8(:,45), A(:,79), n3(:,602), t3x128(:,:,79), nhel, den(134))
    call Hcont_QA(nsync, wf16(:,31), wf8(:,45), A(:,80), n3(:,603), t3x128(:,:,80), nhel, den(135))
    call Hcont_VV(nsync, wf8(:,48), wf16(:,42), A(:,81), n3(:,604), t3x128(:,:,81), nhel, den(136))
    call Hcont_VV(nsync, wf8(:,48), wf16(:,43), A(:,82), n3(:,605), t3x128(:,:,82), nhel, den(137))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,44), A(:,83), n3(:,606), t3x128(:,:,83), nhel, den(138))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,44), A(:,84), n3(:,607), t3x128(:,:,84), nhel, den(139))
    call Hcont_QA(nsync, wf16(:,19), wf8(:,39), A(:,85), n3(:,608), t3x128(:,:,85), nhel, den(140))
    call Hcont_QA(nsync, wf16(:,20), wf8(:,39), A(:,86), n3(:,609), t3x128(:,:,86), nhel, den(141))
    call Hcont_QA(nsync, wf8(:,27), wf16(:,33), A(:,87), n3(:,610), t3x128(:,:,87), nhel, den(142))
    call Hcont_QA(nsync, wf8(:,27), wf16(:,34), A(:,88), n3(:,611), t3x128(:,:,88), nhel, den(143))
    call Hcont_QA(nsync, wf8(:,17), wf16(:,36), A(:,89), n3(:,612), t3x128(:,:,89), nhel, den(144))
    call Hcont_QA(nsync, wf8(:,17), wf16(:,37), A(:,90), n3(:,613), t3x128(:,:,90), nhel, den(145))
    call Hcont_QA(nsync, wf16(:,28), wf8(:,35), A(:,91), n3(:,614), t3x128(:,:,91), nhel, den(146))
    call Hcont_QA(nsync, wf16(:,29), wf8(:,35), A(:,92), n3(:,615), t3x128(:,:,92), nhel, den(147))
    call Hcont_VV(nsync, wf16(:,40), wf8(:,49), A(:,93), n3(:,616), t3x128(:,:,93), nhel, den(149))
    call Hcont_VV(nsync, wf16(:,41), wf8(:,49), A(:,94), n3(:,617), t3x128(:,:,94), nhel, den(150))
    call Hcont_QA(nsync, wf16(:,28), wf8(:,37), A(:,95), n3(:,618), t3x128(:,:,95), nhel, den(151))
    call Hcont_QA(nsync, wf16(:,29), wf8(:,37), A(:,96), n3(:,619), t3x128(:,:,96), nhel, den(152))
    call Hcont_VV(nsync, wf16(:,42), wf8(:,49), A(:,97), n3(:,620), t3x128(:,:,97), nhel, den(153))
    call Hcont_VV(nsync, wf16(:,43), wf8(:,49), A(:,98), n3(:,621), t3x128(:,:,98), nhel, den(154))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,45), A(:,99), n3(:,622), t3x128(:,:,99), nhel, den(155))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,45), A(:,100), n3(:,623), t3x128(:,:,100), nhel, den(156))
    call Hcont_VV(nsync, wf16(:,40), wf8(:,50), A(:,101), n3(:,624), t3x128(:,:,101), nhel, den(158))
    call Hcont_VV(nsync, wf16(:,41), wf8(:,50), A(:,102), n3(:,625), t3x128(:,:,102), nhel, den(159))
    call Hcont_QA(nsync, wf8(:,21), wf16(:,36), A(:,103), n3(:,626), t3x128(:,:,103), nhel, den(160))
    call Hcont_QA(nsync, wf8(:,21), wf16(:,37), A(:,104), n3(:,627), t3x128(:,:,104), nhel, den(161))
    call Hcont_VV(nsync, wf16(:,42), wf8(:,50), A(:,105), n3(:,628), t3x128(:,:,105), nhel, den(162))
    call Hcont_VV(nsync, wf16(:,43), wf8(:,50), A(:,106), n3(:,629), t3x128(:,:,106), nhel, den(163))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,46), A(:,107), n3(:,630), t3x128(:,:,107), nhel, den(164))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,46), A(:,108), n3(:,631), t3x128(:,:,108), nhel, den(165))

    call Hcont_VV(nsync, wf4(:,18), wf32(:,1), A(:,109), n3(:,632), t3x128(:,:,109), nhel, den(168))
    call Hcont_VV(nsync, wf4(:,18), wf32(:,2), A(:,110), n3(:,633), t3x128(:,:,110), nhel, den(168))
    call Hcont_VV(nsync, wf4(:,18), wf32(:,3), A(:,111), n3(:,634), t3x128(:,:,111), nhel, den(170))
    call Hcont_VV(nsync, wf4(:,18), wf32(:,4), A(:,112), n3(:,635), t3x128(:,:,112), nhel, den(170))
    call Hcont_VV(nsync, wf4(:,17), wf32(:,5), A(:,113), n3(:,636), t3x128(:,:,113), nhel, den(171))
    call Hcont_VV(nsync, wf4(:,17), wf32(:,6), A(:,114), n3(:,637), t3x128(:,:,114), nhel, den(171))
    call Hcont_VV(nsync, wf4(:,17), wf32(:,7), A(:,115), n3(:,638), t3x128(:,:,115), nhel, den(172))
    call Hcont_VV(nsync, wf4(:,17), wf32(:,8), A(:,116), n3(:,639), t3x128(:,:,116), nhel, den(172))
    call Hcont_VV(nsync, wf8(:,51), wf16(:,47), A(:,117), n3(:,640), t3x128(:,:,117), nhel, den(175))
    call Hcont_VV(nsync, wf8(:,51), wf16(:,48), A(:,118), n3(:,641), t3x128(:,:,118), nhel, den(175))
    call Hcont_VV(nsync, wf8(:,51), wf16(:,49), A(:,119), n3(:,642), t3x128(:,:,119), nhel, den(176))
    call Hcont_VV(nsync, wf8(:,51), wf16(:,50), A(:,120), n3(:,643), t3x128(:,:,120), nhel, den(176))
    call Hcont_VV(nsync, wf8(:,1), wf16(:,51), A(:,121), n3(:,644), t3x128(:,:,121), nhel, den(177))
    call Hcont_VV(nsync, wf8(:,4), wf16(:,51), A(:,122), n3(:,645), t3x128(:,:,122), nhel, den(177))
    call Hcont_VV(nsync, wf8(:,5), wf16(:,51), A(:,123), n3(:,646), t3x128(:,:,123), nhel, den(177))
    call Hcont_VV(nsync, wf16(:,52), wf8(:,52), A(:,124), n3(:,647), t3x128(:,:,124), nhel, den(180))
    call Hcont_VV(nsync, wf8(:,52), wf16(:,53), A(:,125), n3(:,648), t3x128(:,:,125), nhel, den(180))
    call Hcont_VV(nsync, wf8(:,52), wf16(:,54), A(:,126), n3(:,649), t3x128(:,:,126), nhel, den(180))
    call Hcont_VV(nsync, wf16(:,55), wf8(:,53), A(:,127), n3(:,650), t3x128(:,:,127), nhel, den(183))
    call Hcont_VV(nsync, wf8(:,53), wf16(:,56), A(:,128), n3(:,651), t3x128(:,:,128), nhel, den(183))
    call Hcont_VV(nsync, wf8(:,53), wf16(:,57), A(:,129), n3(:,652), t3x128(:,:,129), nhel, den(183))
    call Hcont_VV(nsync, wf16(:,58), wf8(:,54), A(:,130), n3(:,653), t3x128(:,:,130), nhel, den(186))
    call Hcont_VV(nsync, wf8(:,54), wf16(:,59), A(:,131), n3(:,654), t3x128(:,:,131), nhel, den(186))
    call Hcont_VV(nsync, wf8(:,54), wf16(:,60), A(:,132), n3(:,655), t3x128(:,:,132), nhel, den(186))
    call Hcont_VV(nsync, wf4(:,10), wf32(:,9), A(:,133), n3(:,656), t3x128(:,:,133), nhel, den(187))
    call Hcont_VV(nsync, wf4(:,10), wf32(:,10), A(:,134), n3(:,657), t3x128(:,:,134), nhel, den(187))
    call Hcont_VV(nsync, wf4(:,10), wf32(:,11), A(:,135), n3(:,658), t3x128(:,:,135), nhel, den(188))
    call Hcont_VV(nsync, wf4(:,10), wf32(:,12), A(:,136), n3(:,659), t3x128(:,:,136), nhel, den(188))
    call Hcont_VV(nsync, wf8(:,55), wf16(:,61), A(:,137), n3(:,660), t3x128(:,:,137), nhel, den(191))
    call Hcont_VV(nsync, wf8(:,55), wf16(:,62), A(:,138), n3(:,661), t3x128(:,:,138), nhel, den(191))
    call Hcont_VV(nsync, wf8(:,55), wf16(:,63), A(:,139), n3(:,662), t3x128(:,:,139), nhel, den(192))
    call Hcont_VV(nsync, wf8(:,55), wf16(:,64), A(:,140), n3(:,663), t3x128(:,:,140), nhel, den(192))
    call Hcont_VV(nsync, wf8(:,56), wf16(:,65), A(:,141), n3(:,664), t3x128(:,:,141), nhel, den(195))
    call Hcont_VV(nsync, wf8(:,56), wf16(:,66), A(:,142), n3(:,665), t3x128(:,:,142), nhel, den(195))
    call Hcont_VV(nsync, wf8(:,56), wf16(:,67), A(:,143), n3(:,666), t3x128(:,:,143), nhel, den(196))
    call Hcont_VV(nsync, wf8(:,56), wf16(:,68), A(:,144), n3(:,667), t3x128(:,:,144), nhel, den(196))
    call Hcont_VV(nsync, wf16(:,47), wf8(:,57), A(:,145), n3(:,668), t3x128(:,:,145), nhel, den(198))
    call Hcont_VV(nsync, wf16(:,48), wf8(:,57), A(:,146), n3(:,669), t3x128(:,:,146), nhel, den(198))
    call Hcont_VV(nsync, wf16(:,49), wf8(:,57), A(:,147), n3(:,670), t3x128(:,:,147), nhel, den(199))
    call Hcont_VV(nsync, wf16(:,50), wf8(:,57), A(:,148), n3(:,671), t3x128(:,:,148), nhel, den(199))
    call Hcont_VV(nsync, wf16(:,47), wf8(:,58), A(:,149), n3(:,672), t3x128(:,:,149), nhel, den(201))
    call Hcont_VV(nsync, wf16(:,48), wf8(:,58), A(:,150), n3(:,673), t3x128(:,:,150), nhel, den(201))
    call Hcont_VV(nsync, wf16(:,49), wf8(:,58), A(:,151), n3(:,674), t3x128(:,:,151), nhel, den(202))
    call Hcont_VV(nsync, wf16(:,50), wf8(:,58), A(:,152), n3(:,675), t3x128(:,:,152), nhel, den(202))
    call Hcont_VV(nsync, wf16(:,61), wf8(:,59), A(:,153), n3(:,676), t3x128(:,:,153), nhel, den(204))
    call Hcont_VV(nsync, wf16(:,62), wf8(:,59), A(:,154), n3(:,677), t3x128(:,:,154), nhel, den(204))
    call Hcont_VV(nsync, wf16(:,63), wf8(:,59), A(:,155), n3(:,678), t3x128(:,:,155), nhel, den(205))
    call Hcont_VV(nsync, wf16(:,64), wf8(:,59), A(:,156), n3(:,679), t3x128(:,:,156), nhel, den(205))
    call Hcont_VV(nsync, wf16(:,61), wf8(:,60), A(:,157), n3(:,680), t3x128(:,:,157), nhel, den(207))
    call Hcont_VV(nsync, wf16(:,62), wf8(:,60), A(:,158), n3(:,681), t3x128(:,:,158), nhel, den(207))
    call Hcont_VV(nsync, wf16(:,63), wf8(:,60), A(:,159), n3(:,682), t3x128(:,:,159), nhel, den(208))
    call Hcont_VV(nsync, wf16(:,64), wf8(:,60), A(:,160), n3(:,683), t3x128(:,:,160), nhel, den(208))
    call Hcont_VV(nsync, wf16(:,65), wf8(:,61), A(:,161), n3(:,684), t3x128(:,:,161), nhel, den(210))
    call Hcont_VV(nsync, wf16(:,66), wf8(:,61), A(:,162), n3(:,685), t3x128(:,:,162), nhel, den(210))
    call Hcont_VV(nsync, wf16(:,67), wf8(:,61), A(:,163), n3(:,686), t3x128(:,:,163), nhel, den(211))
    call Hcont_VV(nsync, wf16(:,68), wf8(:,61), A(:,164), n3(:,687), t3x128(:,:,164), nhel, den(211))
    call Hcont_VV(nsync, wf16(:,65), wf8(:,62), A(:,165), n3(:,688), t3x128(:,:,165), nhel, den(213))
    call Hcont_VV(nsync, wf16(:,66), wf8(:,62), A(:,166), n3(:,689), t3x128(:,:,166), nhel, den(213))
    call Hcont_VV(nsync, wf16(:,67), wf8(:,62), A(:,167), n3(:,690), t3x128(:,:,167), nhel, den(214))
    call Hcont_VV(nsync, wf16(:,68), wf8(:,62), A(:,168), n3(:,691), t3x128(:,:,168), nhel, den(214))
    call Hcont_QA(nsync, wf8(:,3), wf16(:,69), A(:,169), n3(:,692), t3x128(:,:,169), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,3), wf16(:,70), A(:,170), n3(:,693), t3x128(:,:,170), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,3), wf16(:,71), A(:,171), n3(:,694), t3x128(:,:,171), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,3), wf16(:,69), A(:,172), n3(:,695), t3x128(:,:,172), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,3), wf16(:,70), A(:,173), n3(:,696), t3x128(:,:,173), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,3), wf16(:,71), A(:,174), n3(:,697), t3x128(:,:,174), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,7), wf16(:,69), A(:,175), n3(:,698), t3x128(:,:,175), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,7), wf16(:,70), A(:,176), n3(:,699), t3x128(:,:,176), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,7), wf16(:,71), A(:,177), n3(:,700), t3x128(:,:,177), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,7), wf16(:,69), A(:,178), n3(:,701), t3x128(:,:,178), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,7), wf16(:,70), A(:,179), n3(:,702), t3x128(:,:,179), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,7), wf16(:,71), A(:,180), n3(:,703), t3x128(:,:,180), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,73), A(:,181), n3(:,704), t3x128(:,:,181), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,75), A(:,182), n3(:,705), t3x128(:,:,182), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,77), A(:,183), n3(:,706), t3x128(:,:,183), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,73), A(:,184), n3(:,707), t3x128(:,:,184), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,75), A(:,185), n3(:,708), t3x128(:,:,185), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,77), A(:,186), n3(:,709), t3x128(:,:,186), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,9), wf16(:,73), A(:,187), n3(:,710), t3x128(:,:,187), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,9), wf16(:,75), A(:,188), n3(:,711), t3x128(:,:,188), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,9), wf16(:,77), A(:,189), n3(:,712), t3x128(:,:,189), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,9), wf16(:,73), A(:,190), n3(:,713), t3x128(:,:,190), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,9), wf16(:,75), A(:,191), n3(:,714), t3x128(:,:,191), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,9), wf16(:,77), A(:,192), n3(:,715), t3x128(:,:,192), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,3), wf16(:,78), A(:,193), n3(:,716), t3x128(:,:,193), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,3), wf16(:,79), A(:,194), n3(:,717), t3x128(:,:,194), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,3), wf16(:,80), A(:,195), n3(:,718), t3x128(:,:,195), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,7), wf16(:,78), A(:,196), n3(:,719), t3x128(:,:,196), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,7), wf16(:,79), A(:,197), n3(:,720), t3x128(:,:,197), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,7), wf16(:,80), A(:,198), n3(:,721), t3x128(:,:,198), nhel, den(8))
    call Hcont_QA(nsync, wf16(:,5), wf8(:,66), A(:,199), n3(:,722), t3x128(:,:,199), nhel, den(11))
    call Hcont_QA(nsync, wf16(:,7), wf8(:,66), A(:,200), n3(:,723), t3x128(:,:,200), nhel, den(11))
    call Hcont_QA(nsync, wf16(:,9), wf8(:,66), A(:,201), n3(:,724), t3x128(:,:,201), nhel, den(11))
    call Hcont_QA(nsync, wf16(:,5), wf8(:,67), A(:,202), n3(:,725), t3x128(:,:,202), nhel, den(12))
    call Hcont_QA(nsync, wf16(:,7), wf8(:,67), A(:,203), n3(:,726), t3x128(:,:,203), nhel, den(12))
    call Hcont_QA(nsync, wf16(:,9), wf8(:,67), A(:,204), n3(:,727), t3x128(:,:,204), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,81), A(:,205), n3(:,728), t3x128(:,:,205), nhel, den(215))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,82), A(:,206), n3(:,729), t3x128(:,:,206), nhel, den(215))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,83), A(:,207), n3(:,730), t3x128(:,:,207), nhel, den(215))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,81), A(:,208), n3(:,731), t3x128(:,:,208), nhel, den(216))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,82), A(:,209), n3(:,732), t3x128(:,:,209), nhel, den(216))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,83), A(:,210), n3(:,733), t3x128(:,:,210), nhel, den(216))
    call Hcont_QA(nsync, wf8(:,68), wf16(:,84), A(:,211), n3(:,734), t3x128(:,:,211), nhel, den(219))
    call Hcont_QA(nsync, wf8(:,68), wf16(:,85), A(:,212), n3(:,735), t3x128(:,:,212), nhel, den(219))
    call Hcont_QA(nsync, wf8(:,68), wf16(:,86), A(:,213), n3(:,736), t3x128(:,:,213), nhel, den(219))
    call Hcont_QA(nsync, wf16(:,84), wf8(:,69), A(:,214), n3(:,737), t3x128(:,:,214), nhel, den(220))
    call Hcont_QA(nsync, wf16(:,85), wf8(:,69), A(:,215), n3(:,738), t3x128(:,:,215), nhel, den(220))
    call Hcont_QA(nsync, wf16(:,86), wf8(:,69), A(:,216), n3(:,739), t3x128(:,:,216), nhel, den(220))
    call Hcont_VV(nsync, wf8(:,56), wf16(:,87), A(:,217), n3(:,740), t3x128(:,:,217), nhel, den(222))
    call Hcont_VV(nsync, wf8(:,48), wf16(:,51), A(:,218), n3(:,741), t3x128(:,:,218), nhel, den(223))
    call Hcont_VV(nsync, wf8(:,52), wf16(:,88), A(:,219), n3(:,742), t3x128(:,:,219), nhel, den(226))
    call Hcont_VV(nsync, wf8(:,55), wf16(:,89), A(:,220), n3(:,743), t3x128(:,:,220), nhel, den(228))
    call Hcont_VV(nsync, wf8(:,49), wf16(:,51), A(:,221), n3(:,744), t3x128(:,:,221), nhel, den(229))
    call Hcont_VV(nsync, wf8(:,51), wf16(:,90), A(:,222), n3(:,745), t3x128(:,:,222), nhel, den(231))
    call Hcont_VV(nsync, wf8(:,50), wf16(:,51), A(:,223), n3(:,746), t3x128(:,:,223), nhel, den(232))
    call Hcont_VV(nsync, wf8(:,52), wf16(:,91), A(:,224), n3(:,747), t3x128(:,:,224), nhel, den(235))
    call Hcont_VV(nsync, wf8(:,52), wf16(:,92), A(:,225), n3(:,748), t3x128(:,:,225), nhel, den(236))
    call Hcont_VV(nsync, wf8(:,53), wf16(:,93), A(:,226), n3(:,749), t3x128(:,:,226), nhel, den(239))
    call Hcont_VV(nsync, wf8(:,53), wf16(:,94), A(:,227), n3(:,750), t3x128(:,:,227), nhel, den(242))
    call Hcont_VV(nsync, wf8(:,56), wf16(:,95), A(:,228), n3(:,751), t3x128(:,:,228), nhel, den(243))
    call Hcont_VV(nsync, wf8(:,54), wf16(:,96), A(:,229), n3(:,752), t3x128(:,:,229), nhel, den(246))
    call Hcont_VV(nsync, wf8(:,55), wf16(:,97), A(:,230), n3(:,753), t3x128(:,:,230), nhel, den(249))
    call Hcont_VV(nsync, wf8(:,56), wf16(:,98), A(:,231), n3(:,754), t3x128(:,:,231), nhel, den(250))
    call Hcont_QA(nsync, wf8(:,11), wf16(:,99), A(:,232), n3(:,755), t3x128(:,:,232), nhel, den(18))
    call Hcont_QA(nsync, wf8(:,11), wf16(:,100), A(:,233), n3(:,756), t3x128(:,:,233), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,13), wf16(:,101), A(:,234), n3(:,757), t3x128(:,:,234), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,13), wf16(:,102), A(:,235), n3(:,758), t3x128(:,:,235), nhel, den(26))
    call Hcont_QA(nsync, wf8(:,70), wf16(:,103), A(:,236), n3(:,759), t3x128(:,:,236), nhel, den(253))
    call Hcont_QA(nsync, wf8(:,70), wf16(:,104), A(:,237), n3(:,760), t3x128(:,:,237), nhel, den(255))
    call Hcont_QA(nsync, wf8(:,71), wf16(:,105), A(:,238), n3(:,761), t3x128(:,:,238), nhel, den(258))
    call Hcont_QA(nsync, wf8(:,71), wf16(:,106), A(:,239), n3(:,762), t3x128(:,:,239), nhel, den(260))
    call Hcont_VV(nsync, wf8(:,52), wf16(:,107), A(:,240), n3(:,763), t3x128(:,:,240), nhel, den(263))
    call Hcont_QA(nsync, wf8(:,15), wf16(:,108), A(:,241), n3(:,764), t3x128(:,:,241), nhel, den(31))
    call Hcont_QA(nsync, wf8(:,15), wf16(:,109), A(:,242), n3(:,765), t3x128(:,:,242), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,17), wf16(:,101), A(:,243), n3(:,766), t3x128(:,:,243), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,17), wf16(:,102), A(:,244), n3(:,767), t3x128(:,:,244), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,110), A(:,245), n3(:,768), t3x128(:,:,245), nhel, den(41))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,110), A(:,246), n3(:,769), t3x128(:,:,246), nhel, den(43))
    call Hcont_VV(nsync, wf8(:,57), wf16(:,90), A(:,247), n3(:,770), t3x128(:,:,247), nhel, den(264))
    call Hcont_QA(nsync, wf8(:,21), wf16(:,101), A(:,248), n3(:,771), t3x128(:,:,248), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,21), wf16(:,102), A(:,249), n3(:,772), t3x128(:,:,249), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,15), wf16(:,111), A(:,250), n3(:,773), t3x128(:,:,250), nhel, den(47))
    call Hcont_QA(nsync, wf8(:,15), wf16(:,112), A(:,251), n3(:,774), t3x128(:,:,251), nhel, den(48))
    call Hcont_QA(nsync, wf16(:,19), wf8(:,72), A(:,252), n3(:,775), t3x128(:,:,252), nhel, den(49))
    call Hcont_QA(nsync, wf16(:,20), wf8(:,72), A(:,253), n3(:,776), t3x128(:,:,253), nhel, den(50))
    call Hcont_VV(nsync, wf8(:,52), wf16(:,113), A(:,254), n3(:,777), t3x128(:,:,254), nhel, den(265))
    call Hcont_VV(nsync, wf8(:,52), wf16(:,114), A(:,255), n3(:,778), t3x128(:,:,255), nhel, den(266))
    call Hcont_QA(nsync, wf16(:,103), wf8(:,73), A(:,256), n3(:,779), t3x128(:,:,256), nhel, den(267))
    call Hcont_QA(nsync, wf16(:,104), wf8(:,73), A(:,257), n3(:,780), t3x128(:,:,257), nhel, den(268))
    call Hcont_QA(nsync, wf8(:,74), wf16(:,115), A(:,258), n3(:,781), t3x128(:,:,258), nhel, den(271))
    call Hcont_QA(nsync, wf8(:,74), wf16(:,116), A(:,259), n3(:,782), t3x128(:,:,259), nhel, den(273))
    call Hcont_VV(nsync, wf8(:,53), wf16(:,117), A(:,260), n3(:,783), t3x128(:,:,260), nhel, den(276))
    call Hcont_QA(nsync, wf8(:,11), wf16(:,118), A(:,261), n3(:,784), t3x128(:,:,261), nhel, den(49))
    call Hcont_QA(nsync, wf8(:,11), wf16(:,119), A(:,262), n3(:,785), t3x128(:,:,262), nhel, den(50))
    call Hcont_QA(nsync, wf16(:,17), wf8(:,75), A(:,263), n3(:,786), t3x128(:,:,263), nhel, den(47))
    call Hcont_QA(nsync, wf16(:,18), wf8(:,75), A(:,264), n3(:,787), t3x128(:,:,264), nhel, den(48))
    call Hcont_VV(nsync, wf8(:,53), wf16(:,120), A(:,265), n3(:,788), t3x128(:,:,265), nhel, den(277))
    call Hcont_QA(nsync, wf8(:,11), wf16(:,121), A(:,266), n3(:,789), t3x128(:,:,266), nhel, den(278))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,122), A(:,267), n3(:,790), t3x128(:,:,267), nhel, den(41))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,122), A(:,268), n3(:,791), t3x128(:,:,268), nhel, den(43))
    call Hcont_QA(nsync, wf16(:,12), wf8(:,77), A(:,269), n3(:,792), t3x128(:,:,269), nhel, den(45))
    call Hcont_QA(nsync, wf16(:,13), wf8(:,77), A(:,270), n3(:,793), t3x128(:,:,270), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,23), wf16(:,123), A(:,271), n3(:,794), t3x128(:,:,271), nhel, den(56))
    call Hcont_QA(nsync, wf8(:,23), wf16(:,124), A(:,272), n3(:,795), t3x128(:,:,272), nhel, den(58))
    call Hcont_QA(nsync, wf8(:,25), wf16(:,125), A(:,273), n3(:,796), t3x128(:,:,273), nhel, den(62))
    call Hcont_QA(nsync, wf8(:,25), wf16(:,126), A(:,274), n3(:,797), t3x128(:,:,274), nhel, den(64))
    call Hcont_QA(nsync, wf8(:,78), wf16(:,127), A(:,275), n3(:,798), t3x128(:,:,275), nhel, den(281))
    call Hcont_QA(nsync, wf8(:,78), wf16(:,128), A(:,276), n3(:,799), t3x128(:,:,276), nhel, den(283))
    call Hcont_QA(nsync, wf8(:,79), wf16(:,129), A(:,277), n3(:,800), t3x128(:,:,277), nhel, den(286))
    call Hcont_QA(nsync, wf8(:,79), wf16(:,130), A(:,278), n3(:,801), t3x128(:,:,278), nhel, den(288))
    call Hcont_VV(nsync, wf8(:,52), wf16(:,131), A(:,279), n3(:,802), t3x128(:,:,279), nhel, den(291))
    call Hcont_QA(nsync, wf8(:,27), wf16(:,123), A(:,280), n3(:,803), t3x128(:,:,280), nhel, den(67))
    call Hcont_QA(nsync, wf8(:,27), wf16(:,124), A(:,281), n3(:,804), t3x128(:,:,281), nhel, den(68))
    call Hcont_QA(nsync, wf8(:,29), wf16(:,132), A(:,282), n3(:,805), t3x128(:,:,282), nhel, den(72))
    call Hcont_QA(nsync, wf8(:,29), wf16(:,133), A(:,283), n3(:,806), t3x128(:,:,283), nhel, den(74))
    call Hcont_QA(nsync, wf8(:,3), wf16(:,134), A(:,284), n3(:,807), t3x128(:,:,284), nhel, den(76))
    call Hcont_QA(nsync, wf8(:,7), wf16(:,134), A(:,285), n3(:,808), t3x128(:,:,285), nhel, den(77))
    call Hcont_VV(nsync, wf8(:,58), wf16(:,90), A(:,286), n3(:,809), t3x128(:,:,286), nhel, den(292))
    call Hcont_QA(nsync, wf8(:,31), wf16(:,123), A(:,287), n3(:,810), t3x128(:,:,287), nhel, den(79))
    call Hcont_QA(nsync, wf8(:,31), wf16(:,124), A(:,288), n3(:,811), t3x128(:,:,288), nhel, den(80))
    call Hcont_QA(nsync, wf16(:,28), wf8(:,80), A(:,289), n3(:,812), t3x128(:,:,289), nhel, den(81))
    call Hcont_QA(nsync, wf16(:,29), wf8(:,80), A(:,290), n3(:,813), t3x128(:,:,290), nhel, den(82))
    call Hcont_QA(nsync, wf8(:,29), wf16(:,135), A(:,291), n3(:,814), t3x128(:,:,291), nhel, den(83))
    call Hcont_QA(nsync, wf8(:,29), wf16(:,136), A(:,292), n3(:,815), t3x128(:,:,292), nhel, den(84))
    call Hcont_VV(nsync, wf8(:,52), wf16(:,137), A(:,293), n3(:,816), t3x128(:,:,293), nhel, den(293))
    call Hcont_VV(nsync, wf8(:,52), wf16(:,138), A(:,294), n3(:,817), t3x128(:,:,294), nhel, den(294))
    call Hcont_QA(nsync, wf8(:,81), wf16(:,139), A(:,295), n3(:,818), t3x128(:,:,295), nhel, den(297))
    call Hcont_QA(nsync, wf8(:,81), wf16(:,140), A(:,296), n3(:,819), t3x128(:,:,296), nhel, den(299))
    call Hcont_QA(nsync, wf16(:,129), wf8(:,82), A(:,297), n3(:,820), t3x128(:,:,297), nhel, den(300))
    call Hcont_QA(nsync, wf16(:,130), wf8(:,82), A(:,298), n3(:,821), t3x128(:,:,298), nhel, den(301))
    call Hcont_VV(nsync, wf8(:,53), wf16(:,141), A(:,299), n3(:,822), t3x128(:,:,299), nhel, den(304))
    call Hcont_QA(nsync, wf16(:,30), wf8(:,83), A(:,300), n3(:,823), t3x128(:,:,300), nhel, den(83))
    call Hcont_QA(nsync, wf16(:,31), wf8(:,83), A(:,301), n3(:,824), t3x128(:,:,301), nhel, den(84))
    call Hcont_QA(nsync, wf8(:,25), wf16(:,142), A(:,302), n3(:,825), t3x128(:,:,302), nhel, den(81))
    call Hcont_QA(nsync, wf8(:,25), wf16(:,143), A(:,303), n3(:,826), t3x128(:,:,303), nhel, den(82))
    call Hcont_VV(nsync, wf8(:,53), wf16(:,144), A(:,304), n3(:,827), t3x128(:,:,304), nhel, den(305))
    call Hcont_QA(nsync, wf8(:,25), wf16(:,145), A(:,305), n3(:,828), t3x128(:,:,305), nhel, den(306))
    call Hcont_QA(nsync, wf8(:,3), wf16(:,146), A(:,306), n3(:,829), t3x128(:,:,306), nhel, den(76))
    call Hcont_QA(nsync, wf8(:,7), wf16(:,146), A(:,307), n3(:,830), t3x128(:,:,307), nhel, den(77))
    call Hcont_QA(nsync, wf16(:,21), wf8(:,85), A(:,308), n3(:,831), t3x128(:,:,308), nhel, den(79))
    call Hcont_QA(nsync, wf16(:,22), wf8(:,85), A(:,309), n3(:,832), t3x128(:,:,309), nhel, den(80))
    call Hcont_QA(nsync, wf8(:,33), wf16(:,108), A(:,310), n3(:,833), t3x128(:,:,310), nhel, den(86))
    call Hcont_QA(nsync, wf8(:,33), wf16(:,109), A(:,311), n3(:,834), t3x128(:,:,311), nhel, den(87))
    call Hcont_QA(nsync, wf8(:,35), wf16(:,125), A(:,312), n3(:,835), t3x128(:,:,312), nhel, den(89))
    call Hcont_QA(nsync, wf8(:,35), wf16(:,126), A(:,313), n3(:,836), t3x128(:,:,313), nhel, den(90))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,147), A(:,314), n3(:,837), t3x128(:,:,314), nhel, den(93))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,147), A(:,315), n3(:,838), t3x128(:,:,315), nhel, den(94))
    call Hcont_VV(nsync, wf8(:,59), wf16(:,89), A(:,316), n3(:,839), t3x128(:,:,316), nhel, den(307))
    call Hcont_QA(nsync, wf8(:,37), wf16(:,125), A(:,317), n3(:,840), t3x128(:,:,317), nhel, den(96))
    call Hcont_QA(nsync, wf8(:,37), wf16(:,126), A(:,318), n3(:,841), t3x128(:,:,318), nhel, den(97))
    call Hcont_QA(nsync, wf8(:,33), wf16(:,111), A(:,319), n3(:,842), t3x128(:,:,319), nhel, den(98))
    call Hcont_QA(nsync, wf8(:,33), wf16(:,112), A(:,320), n3(:,843), t3x128(:,:,320), nhel, den(99))
    call Hcont_QA(nsync, wf16(:,33), wf8(:,86), A(:,321), n3(:,844), t3x128(:,:,321), nhel, den(100))
    call Hcont_QA(nsync, wf16(:,34), wf8(:,86), A(:,322), n3(:,845), t3x128(:,:,322), nhel, den(101))
    call Hcont_VV(nsync, wf8(:,52), wf16(:,148), A(:,323), n3(:,846), t3x128(:,:,323), nhel, den(308))
    call Hcont_VV(nsync, wf8(:,52), wf16(:,149), A(:,324), n3(:,847), t3x128(:,:,324), nhel, den(309))
    call Hcont_QA(nsync, wf8(:,39), wf16(:,99), A(:,325), n3(:,848), t3x128(:,:,325), nhel, den(103))
    call Hcont_QA(nsync, wf8(:,39), wf16(:,100), A(:,326), n3(:,849), t3x128(:,:,326), nhel, den(104))
    call Hcont_QA(nsync, wf8(:,41), wf16(:,132), A(:,327), n3(:,850), t3x128(:,:,327), nhel, den(106))
    call Hcont_QA(nsync, wf8(:,41), wf16(:,133), A(:,328), n3(:,851), t3x128(:,:,328), nhel, den(107))
    call Hcont_QA(nsync, wf8(:,3), wf16(:,150), A(:,329), n3(:,852), t3x128(:,:,329), nhel, den(109))
    call Hcont_QA(nsync, wf8(:,7), wf16(:,150), A(:,330), n3(:,853), t3x128(:,:,330), nhel, den(110))
    call Hcont_VV(nsync, wf8(:,60), wf16(:,89), A(:,331), n3(:,854), t3x128(:,:,331), nhel, den(310))
    call Hcont_QA(nsync, wf8(:,43), wf16(:,99), A(:,332), n3(:,855), t3x128(:,:,332), nhel, den(112))
    call Hcont_QA(nsync, wf8(:,43), wf16(:,100), A(:,333), n3(:,856), t3x128(:,:,333), nhel, den(113))
    call Hcont_QA(nsync, wf16(:,36), wf8(:,87), A(:,334), n3(:,857), t3x128(:,:,334), nhel, den(114))
    call Hcont_QA(nsync, wf16(:,37), wf8(:,87), A(:,335), n3(:,858), t3x128(:,:,335), nhel, den(115))
    call Hcont_QA(nsync, wf8(:,41), wf16(:,135), A(:,336), n3(:,859), t3x128(:,:,336), nhel, den(116))
    call Hcont_QA(nsync, wf8(:,41), wf16(:,136), A(:,337), n3(:,860), t3x128(:,:,337), nhel, den(117))
    call Hcont_VV(nsync, wf8(:,52), wf16(:,151), A(:,338), n3(:,861), t3x128(:,:,338), nhel, den(311))
    call Hcont_VV(nsync, wf8(:,52), wf16(:,152), A(:,339), n3(:,862), t3x128(:,:,339), nhel, den(312))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,153), A(:,340), n3(:,863), t3x128(:,:,340), nhel, den(120))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,153), A(:,341), n3(:,864), t3x128(:,:,341), nhel, den(121))
    call Hcont_VV(nsync, wf8(:,61), wf16(:,87), A(:,342), n3(:,865), t3x128(:,:,342), nhel, den(313))
    call Hcont_QA(nsync, wf8(:,45), wf16(:,132), A(:,343), n3(:,866), t3x128(:,:,343), nhel, den(123))
    call Hcont_QA(nsync, wf8(:,45), wf16(:,133), A(:,344), n3(:,867), t3x128(:,:,344), nhel, den(124))
    call Hcont_QA(nsync, wf8(:,3), wf16(:,154), A(:,345), n3(:,868), t3x128(:,:,345), nhel, den(126))
    call Hcont_QA(nsync, wf8(:,7), wf16(:,154), A(:,346), n3(:,869), t3x128(:,:,346), nhel, den(127))
    call Hcont_VV(nsync, wf8(:,62), wf16(:,87), A(:,347), n3(:,870), t3x128(:,:,347), nhel, den(314))
    call Hcont_QA(nsync, wf8(:,47), wf16(:,108), A(:,348), n3(:,871), t3x128(:,:,348), nhel, den(129))
    call Hcont_QA(nsync, wf8(:,47), wf16(:,109), A(:,349), n3(:,872), t3x128(:,:,349), nhel, den(130))
    call Hcont_VV(nsync, wf16(:,40), wf8(:,88), A(:,350), n3(:,873), t3x128(:,:,350), nhel, den(132))
    call Hcont_VV(nsync, wf16(:,41), wf8(:,88), A(:,351), n3(:,874), t3x128(:,:,351), nhel, den(133))
    call Hcont_QA(nsync, wf8(:,45), wf16(:,135), A(:,352), n3(:,875), t3x128(:,:,352), nhel, den(134))
    call Hcont_QA(nsync, wf8(:,45), wf16(:,136), A(:,353), n3(:,876), t3x128(:,:,353), nhel, den(135))
    call Hcont_VV(nsync, wf16(:,42), wf8(:,88), A(:,354), n3(:,877), t3x128(:,:,354), nhel, den(136))
    call Hcont_VV(nsync, wf16(:,43), wf8(:,88), A(:,355), n3(:,878), t3x128(:,:,355), nhel, den(137))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,155), A(:,356), n3(:,879), t3x128(:,:,356), nhel, den(138))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,155), A(:,357), n3(:,880), t3x128(:,:,357), nhel, den(139))
    call Hcont_VV(nsync, wf8(:,52), wf16(:,156), A(:,358), n3(:,881), t3x128(:,:,358), nhel, den(315))
    call Hcont_VV(nsync, wf8(:,52), wf16(:,157), A(:,359), n3(:,882), t3x128(:,:,359), nhel, den(316))
    call Hcont_QA(nsync, wf8(:,39), wf16(:,118), A(:,360), n3(:,883), t3x128(:,:,360), nhel, den(140))
    call Hcont_QA(nsync, wf8(:,39), wf16(:,119), A(:,361), n3(:,884), t3x128(:,:,361), nhel, den(141))
    call Hcont_QA(nsync, wf16(:,33), wf8(:,89), A(:,362), n3(:,885), t3x128(:,:,362), nhel, den(142))
    call Hcont_QA(nsync, wf16(:,34), wf8(:,89), A(:,363), n3(:,886), t3x128(:,:,363), nhel, den(143))
    call Hcont_VV(nsync, wf8(:,53), wf16(:,158), A(:,364), n3(:,887), t3x128(:,:,364), nhel, den(317))
    call Hcont_VV(nsync, wf8(:,53), wf16(:,159), A(:,365), n3(:,888), t3x128(:,:,365), nhel, den(318))
    call Hcont_QA(nsync, wf16(:,36), wf8(:,90), A(:,366), n3(:,889), t3x128(:,:,366), nhel, den(144))
    call Hcont_QA(nsync, wf16(:,37), wf8(:,90), A(:,367), n3(:,890), t3x128(:,:,367), nhel, den(145))
    call Hcont_QA(nsync, wf8(:,35), wf16(:,142), A(:,368), n3(:,891), t3x128(:,:,368), nhel, den(146))
    call Hcont_QA(nsync, wf8(:,35), wf16(:,143), A(:,369), n3(:,892), t3x128(:,:,369), nhel, den(147))
    call Hcont_VV(nsync, wf8(:,53), wf16(:,160), A(:,370), n3(:,893), t3x128(:,:,370), nhel, den(319))
    call Hcont_VV(nsync, wf8(:,53), wf16(:,161), A(:,371), n3(:,894), t3x128(:,:,371), nhel, den(320))
    call Hcont_VV(nsync, wf16(:,40), wf8(:,91), A(:,372), n3(:,895), t3x128(:,:,372), nhel, den(149))
    call Hcont_VV(nsync, wf16(:,41), wf8(:,91), A(:,373), n3(:,896), t3x128(:,:,373), nhel, den(150))
    call Hcont_QA(nsync, wf8(:,37), wf16(:,142), A(:,374), n3(:,897), t3x128(:,:,374), nhel, den(151))
    call Hcont_QA(nsync, wf8(:,37), wf16(:,143), A(:,375), n3(:,898), t3x128(:,:,375), nhel, den(152))
    call Hcont_VV(nsync, wf16(:,42), wf8(:,91), A(:,376), n3(:,899), t3x128(:,:,376), nhel, den(153))
    call Hcont_VV(nsync, wf16(:,43), wf8(:,91), A(:,377), n3(:,900), t3x128(:,:,377), nhel, den(154))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,162), A(:,378), n3(:,901), t3x128(:,:,378), nhel, den(155))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,162), A(:,379), n3(:,902), t3x128(:,:,379), nhel, den(156))
    call Hcont_VV(nsync, wf8(:,53), wf16(:,163), A(:,380), n3(:,903), t3x128(:,:,380), nhel, den(321))
    call Hcont_VV(nsync, wf8(:,53), wf16(:,164), A(:,381), n3(:,904), t3x128(:,:,381), nhel, den(322))
    call Hcont_VV(nsync, wf16(:,40), wf8(:,92), A(:,382), n3(:,905), t3x128(:,:,382), nhel, den(158))
    call Hcont_VV(nsync, wf16(:,41), wf8(:,92), A(:,383), n3(:,906), t3x128(:,:,383), nhel, den(159))
    call Hcont_QA(nsync, wf16(:,36), wf8(:,77), A(:,384), n3(:,907), t3x128(:,:,384), nhel, den(160))
    call Hcont_QA(nsync, wf16(:,37), wf8(:,77), A(:,385), n3(:,908), t3x128(:,:,385), nhel, den(161))
    call Hcont_VV(nsync, wf16(:,42), wf8(:,92), A(:,386), n3(:,909), t3x128(:,:,386), nhel, den(162))
    call Hcont_VV(nsync, wf16(:,43), wf8(:,92), A(:,387), n3(:,910), t3x128(:,:,387), nhel, den(163))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,165), A(:,388), n3(:,911), t3x128(:,:,388), nhel, den(164))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,165), A(:,389), n3(:,912), t3x128(:,:,389), nhel, den(165))
    call Hcont_QA(nsync, wf16(:,84), wf8(:,93), A(:,390), n3(:,913), t3x128(:,:,390), nhel, den(323))
    call Hcont_QA(nsync, wf16(:,85), wf8(:,93), A(:,391), n3(:,914), t3x128(:,:,391), nhel, den(323))
    call Hcont_QA(nsync, wf16(:,86), wf8(:,93), A(:,392), n3(:,915), t3x128(:,:,392), nhel, den(323))
    call Hcont_QA(nsync, wf16(:,84), wf8(:,94), A(:,393), n3(:,916), t3x128(:,:,393), nhel, den(324))
    call Hcont_QA(nsync, wf16(:,85), wf8(:,94), A(:,394), n3(:,917), t3x128(:,:,394), nhel, den(324))
    call Hcont_QA(nsync, wf16(:,86), wf8(:,94), A(:,395), n3(:,918), t3x128(:,:,395), nhel, den(324))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,166), A(:,396), n3(:,919), t3x128(:,:,396), nhel, den(325))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,167), A(:,397), n3(:,920), t3x128(:,:,397), nhel, den(325))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,168), A(:,398), n3(:,921), t3x128(:,:,398), nhel, den(325))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,166), A(:,399), n3(:,922), t3x128(:,:,399), nhel, den(326))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,167), A(:,400), n3(:,923), t3x128(:,:,400), nhel, den(326))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,168), A(:,401), n3(:,924), t3x128(:,:,401), nhel, den(326))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,169), A(:,402), n3(:,925), t3x128(:,:,402), nhel, den(328))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,170), A(:,403), n3(:,926), t3x128(:,:,403), nhel, den(328))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,171), A(:,404), n3(:,927), t3x128(:,:,404), nhel, den(328))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,169), A(:,405), n3(:,928), t3x128(:,:,405), nhel, den(329))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,170), A(:,406), n3(:,929), t3x128(:,:,406), nhel, den(329))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,171), A(:,407), n3(:,930), t3x128(:,:,407), nhel, den(329))
    call Hcont_QA(nsync, wf8(:,3), wf16(:,172), A(:,408), n3(:,931), t3x128(:,:,408), nhel, den(330))
    call Hcont_QA(nsync, wf8(:,3), wf16(:,173), A(:,409), n3(:,932), t3x128(:,:,409), nhel, den(330))
    call Hcont_QA(nsync, wf8(:,3), wf16(:,174), A(:,410), n3(:,933), t3x128(:,:,410), nhel, den(330))
    call Hcont_QA(nsync, wf8(:,7), wf16(:,172), A(:,411), n3(:,934), t3x128(:,:,411), nhel, den(331))
    call Hcont_QA(nsync, wf8(:,7), wf16(:,173), A(:,412), n3(:,935), t3x128(:,:,412), nhel, den(331))
    call Hcont_QA(nsync, wf8(:,7), wf16(:,174), A(:,413), n3(:,936), t3x128(:,:,413), nhel, den(331))
    call Hcont_QA(nsync, wf16(:,127), wf8(:,98), A(:,414), n3(:,937), t3x128(:,:,414), nhel, den(332))
    call Hcont_QA(nsync, wf16(:,128), wf8(:,98), A(:,415), n3(:,938), t3x128(:,:,415), nhel, den(333))
    call Hcont_QA(nsync, wf16(:,115), wf8(:,99), A(:,416), n3(:,939), t3x128(:,:,416), nhel, den(334))
    call Hcont_QA(nsync, wf16(:,116), wf8(:,99), A(:,417), n3(:,940), t3x128(:,:,417), nhel, den(335))
    call Hcont_VV(nsync, wf8(:,54), wf16(:,175), A(:,418), n3(:,941), t3x128(:,:,418), nhel, den(338))
    call Hcont_QA(nsync, wf8(:,23), wf16(:,176), A(:,419), n3(:,942), t3x128(:,:,419), nhel, den(100))
    call Hcont_QA(nsync, wf8(:,23), wf16(:,177), A(:,420), n3(:,943), t3x128(:,:,420), nhel, den(101))
    call Hcont_QA(nsync, wf16(:,17), wf8(:,100), A(:,421), n3(:,944), t3x128(:,:,421), nhel, den(98))
    call Hcont_QA(nsync, wf16(:,18), wf8(:,100), A(:,422), n3(:,945), t3x128(:,:,422), nhel, den(99))
    call Hcont_VV(nsync, wf8(:,54), wf16(:,178), A(:,423), n3(:,946), t3x128(:,:,423), nhel, den(339))
    call Hcont_QA(nsync, wf8(:,23), wf16(:,179), A(:,424), n3(:,947), t3x128(:,:,424), nhel, den(340))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,180), A(:,425), n3(:,948), t3x128(:,:,425), nhel, den(93))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,180), A(:,426), n3(:,949), t3x128(:,:,426), nhel, den(94))
    call Hcont_QA(nsync, wf16(:,23), wf8(:,102), A(:,427), n3(:,950), t3x128(:,:,427), nhel, den(96))
    call Hcont_QA(nsync, wf16(:,24), wf8(:,102), A(:,428), n3(:,951), t3x128(:,:,428), nhel, den(97))
    call Hcont_QA(nsync, wf16(:,139), wf8(:,103), A(:,429), n3(:,952), t3x128(:,:,429), nhel, den(341))
    call Hcont_QA(nsync, wf16(:,140), wf8(:,103), A(:,430), n3(:,953), t3x128(:,:,430), nhel, den(342))
    call Hcont_QA(nsync, wf16(:,105), wf8(:,104), A(:,431), n3(:,954), t3x128(:,:,431), nhel, den(343))
    call Hcont_QA(nsync, wf16(:,106), wf8(:,104), A(:,432), n3(:,955), t3x128(:,:,432), nhel, den(344))
    call Hcont_VV(nsync, wf8(:,54), wf16(:,181), A(:,433), n3(:,956), t3x128(:,:,433), nhel, den(347))
    call Hcont_QA(nsync, wf16(:,30), wf8(:,105), A(:,434), n3(:,957), t3x128(:,:,434), nhel, den(116))
    call Hcont_QA(nsync, wf16(:,31), wf8(:,105), A(:,435), n3(:,958), t3x128(:,:,435), nhel, den(117))
    call Hcont_QA(nsync, wf8(:,13), wf16(:,182), A(:,436), n3(:,959), t3x128(:,:,436), nhel, den(114))
    call Hcont_QA(nsync, wf8(:,13), wf16(:,183), A(:,437), n3(:,960), t3x128(:,:,437), nhel, den(115))
    call Hcont_VV(nsync, wf8(:,54), wf16(:,184), A(:,438), n3(:,961), t3x128(:,:,438), nhel, den(348))
    call Hcont_QA(nsync, wf8(:,13), wf16(:,185), A(:,439), n3(:,962), t3x128(:,:,439), nhel, den(349))
    call Hcont_QA(nsync, wf8(:,3), wf16(:,186), A(:,440), n3(:,963), t3x128(:,:,440), nhel, den(109))
    call Hcont_QA(nsync, wf8(:,7), wf16(:,186), A(:,441), n3(:,964), t3x128(:,:,441), nhel, den(110))
    call Hcont_QA(nsync, wf16(:,10), wf8(:,107), A(:,442), n3(:,965), t3x128(:,:,442), nhel, den(112))
    call Hcont_QA(nsync, wf16(:,11), wf8(:,107), A(:,443), n3(:,966), t3x128(:,:,443), nhel, den(113))
    call Hcont_QA(nsync, wf8(:,27), wf16(:,176), A(:,444), n3(:,967), t3x128(:,:,444), nhel, den(142))
    call Hcont_QA(nsync, wf8(:,27), wf16(:,177), A(:,445), n3(:,968), t3x128(:,:,445), nhel, den(143))
    call Hcont_QA(nsync, wf16(:,19), wf8(:,108), A(:,446), n3(:,969), t3x128(:,:,446), nhel, den(140))
    call Hcont_QA(nsync, wf16(:,20), wf8(:,108), A(:,447), n3(:,970), t3x128(:,:,447), nhel, den(141))
    call Hcont_VV(nsync, wf8(:,54), wf16(:,187), A(:,448), n3(:,971), t3x128(:,:,448), nhel, den(350))
    call Hcont_QA(nsync, wf8(:,27), wf16(:,179), A(:,449), n3(:,972), t3x128(:,:,449), nhel, den(351))
    call Hcont_QA(nsync, wf16(:,28), wf8(:,109), A(:,450), n3(:,973), t3x128(:,:,450), nhel, den(146))
    call Hcont_QA(nsync, wf16(:,29), wf8(:,109), A(:,451), n3(:,974), t3x128(:,:,451), nhel, den(147))
    call Hcont_QA(nsync, wf8(:,17), wf16(:,182), A(:,452), n3(:,975), t3x128(:,:,452), nhel, den(144))
    call Hcont_QA(nsync, wf8(:,17), wf16(:,183), A(:,453), n3(:,976), t3x128(:,:,453), nhel, den(145))
    call Hcont_VV(nsync, wf8(:,54), wf16(:,188), A(:,454), n3(:,977), t3x128(:,:,454), nhel, den(352))
    call Hcont_QA(nsync, wf8(:,17), wf16(:,185), A(:,455), n3(:,978), t3x128(:,:,455), nhel, den(353))
    call Hcont_VV(nsync, wf16(:,40), wf8(:,110), A(:,456), n3(:,979), t3x128(:,:,456), nhel, den(158))
    call Hcont_VV(nsync, wf16(:,41), wf8(:,110), A(:,457), n3(:,980), t3x128(:,:,457), nhel, den(159))
    call Hcont_QA(nsync, wf8(:,21), wf16(:,182), A(:,458), n3(:,981), t3x128(:,:,458), nhel, den(160))
    call Hcont_QA(nsync, wf8(:,21), wf16(:,183), A(:,459), n3(:,982), t3x128(:,:,459), nhel, den(161))
    call Hcont_VV(nsync, wf16(:,42), wf8(:,110), A(:,460), n3(:,983), t3x128(:,:,460), nhel, den(162))
    call Hcont_VV(nsync, wf16(:,43), wf8(:,110), A(:,461), n3(:,984), t3x128(:,:,461), nhel, den(163))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,189), A(:,462), n3(:,985), t3x128(:,:,462), nhel, den(164))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,189), A(:,463), n3(:,986), t3x128(:,:,463), nhel, den(165))
    call Hcont_VV(nsync, wf8(:,54), wf16(:,190), A(:,464), n3(:,987), t3x128(:,:,464), nhel, den(354))
    call Hcont_VV(nsync, wf8(:,54), wf16(:,191), A(:,465), n3(:,988), t3x128(:,:,465), nhel, den(355))
    call Hcont_VV(nsync, wf16(:,40), wf8(:,111), A(:,466), n3(:,989), t3x128(:,:,466), nhel, den(149))
    call Hcont_VV(nsync, wf16(:,41), wf8(:,111), A(:,467), n3(:,990), t3x128(:,:,467), nhel, den(150))
    call Hcont_QA(nsync, wf16(:,28), wf8(:,102), A(:,468), n3(:,991), t3x128(:,:,468), nhel, den(151))
    call Hcont_QA(nsync, wf16(:,29), wf8(:,102), A(:,469), n3(:,992), t3x128(:,:,469), nhel, den(152))
    call Hcont_VV(nsync, wf16(:,42), wf8(:,111), A(:,470), n3(:,993), t3x128(:,:,470), nhel, den(153))
    call Hcont_VV(nsync, wf16(:,43), wf8(:,111), A(:,471), n3(:,994), t3x128(:,:,471), nhel, den(154))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,192), A(:,472), n3(:,995), t3x128(:,:,472), nhel, den(155))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,192), A(:,473), n3(:,996), t3x128(:,:,473), nhel, den(156))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,193), A(:,474), n3(:,997), t3x128(:,:,474), nhel, den(120))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,193), A(:,475), n3(:,998), t3x128(:,:,475), nhel, den(121))
    call Hcont_QA(nsync, wf16(:,25), wf8(:,113), A(:,476), n3(:,999), t3x128(:,:,476), nhel, den(123))
    call Hcont_QA(nsync, wf16(:,26), wf8(:,113), A(:,477), n3(:,1000), t3x128(:,:,477), nhel, den(124))
    call Hcont_QA(nsync, wf8(:,3), wf16(:,194), A(:,478), n3(:,1001), t3x128(:,:,478), nhel, den(126))
    call Hcont_QA(nsync, wf8(:,7), wf16(:,194), A(:,479), n3(:,1002), t3x128(:,:,479), nhel, den(127))
    call Hcont_QA(nsync, wf16(:,14), wf8(:,115), A(:,480), n3(:,1003), t3x128(:,:,480), nhel, den(129))
    call Hcont_QA(nsync, wf16(:,15), wf8(:,115), A(:,481), n3(:,1004), t3x128(:,:,481), nhel, den(130))
    call Hcont_VV(nsync, wf16(:,40), wf8(:,116), A(:,482), n3(:,1005), t3x128(:,:,482), nhel, den(132))
    call Hcont_VV(nsync, wf16(:,41), wf8(:,116), A(:,483), n3(:,1006), t3x128(:,:,483), nhel, den(133))
    call Hcont_QA(nsync, wf16(:,30), wf8(:,113), A(:,484), n3(:,1007), t3x128(:,:,484), nhel, den(134))
    call Hcont_QA(nsync, wf16(:,31), wf8(:,113), A(:,485), n3(:,1008), t3x128(:,:,485), nhel, den(135))
    call Hcont_VV(nsync, wf16(:,42), wf8(:,116), A(:,486), n3(:,1009), t3x128(:,:,486), nhel, den(136))
    call Hcont_VV(nsync, wf16(:,43), wf8(:,116), A(:,487), n3(:,1010), t3x128(:,:,487), nhel, den(137))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,195), A(:,488), n3(:,1011), t3x128(:,:,488), nhel, den(138))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,195), A(:,489), n3(:,1012), t3x128(:,:,489), nhel, den(139))
    call Hcont_QA(nsync, wf16(:,103), wf8(:,117), A(:,490), n3(:,1013), t3x128(:,:,490), nhel, den(356))
    call Hcont_QA(nsync, wf16(:,104), wf8(:,117), A(:,491), n3(:,1014), t3x128(:,:,491), nhel, den(357))
    call Hcont_QA(nsync, wf8(:,66), wf16(:,196), A(:,492), n3(:,1015), t3x128(:,:,492), nhel, den(359))
    call Hcont_QA(nsync, wf8(:,67), wf16(:,196), A(:,493), n3(:,1016), t3x128(:,:,493), nhel, den(360))
    call Hcont_QA(nsync, wf8(:,15), wf16(:,197), A(:,494), n3(:,1017), t3x128(:,:,494), nhel, den(47))
    call Hcont_QA(nsync, wf8(:,15), wf16(:,198), A(:,495), n3(:,1018), t3x128(:,:,495), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,11), wf16(:,199), A(:,496), n3(:,1019), t3x128(:,:,496), nhel, den(49))
    call Hcont_QA(nsync, wf8(:,11), wf16(:,200), A(:,497), n3(:,1020), t3x128(:,:,497), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,15), wf16(:,201), A(:,498), n3(:,1021), t3x128(:,:,498), nhel, den(31))
    call Hcont_QA(nsync, wf8(:,15), wf16(:,202), A(:,499), n3(:,1022), t3x128(:,:,499), nhel, den(33))
    call Hcont_QA(nsync, wf16(:,12), wf8(:,121), A(:,500), n3(:,1023), t3x128(:,:,500), nhel, den(35))
    call Hcont_QA(nsync, wf16(:,13), wf8(:,121), A(:,501), n3(:,1024), t3x128(:,:,501), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,11), wf16(:,203), A(:,502), n3(:,1025), t3x128(:,:,502), nhel, den(18))
    call Hcont_QA(nsync, wf8(:,11), wf16(:,204), A(:,503), n3(:,1026), t3x128(:,:,503), nhel, den(20))
    call Hcont_QA(nsync, wf16(:,12), wf8(:,123), A(:,504), n3(:,1027), t3x128(:,:,504), nhel, den(24))
    call Hcont_QA(nsync, wf16(:,13), wf8(:,123), A(:,505), n3(:,1028), t3x128(:,:,505), nhel, den(26))
    call Hcont_QA(nsync, wf16(:,127), wf8(:,124), A(:,506), n3(:,1029), t3x128(:,:,506), nhel, den(361))
    call Hcont_QA(nsync, wf16(:,128), wf8(:,124), A(:,507), n3(:,1030), t3x128(:,:,507), nhel, den(362))
    call Hcont_QA(nsync, wf8(:,66), wf16(:,205), A(:,508), n3(:,1031), t3x128(:,:,508), nhel, den(364))
    call Hcont_QA(nsync, wf8(:,67), wf16(:,205), A(:,509), n3(:,1032), t3x128(:,:,509), nhel, den(365))
    call Hcont_QA(nsync, wf8(:,33), wf16(:,197), A(:,510), n3(:,1033), t3x128(:,:,510), nhel, den(98))
    call Hcont_QA(nsync, wf8(:,33), wf16(:,198), A(:,511), n3(:,1034), t3x128(:,:,511), nhel, den(99))
    call Hcont_QA(nsync, wf8(:,23), wf16(:,206), A(:,512), n3(:,1035), t3x128(:,:,512), nhel, den(100))
    call Hcont_QA(nsync, wf8(:,23), wf16(:,207), A(:,513), n3(:,1036), t3x128(:,:,513), nhel, den(101))
    call Hcont_QA(nsync, wf8(:,33), wf16(:,201), A(:,514), n3(:,1037), t3x128(:,:,514), nhel, den(86))
    call Hcont_QA(nsync, wf8(:,33), wf16(:,202), A(:,515), n3(:,1038), t3x128(:,:,515), nhel, den(87))
    call Hcont_QA(nsync, wf16(:,23), wf8(:,126), A(:,516), n3(:,1039), t3x128(:,:,516), nhel, den(89))
    call Hcont_QA(nsync, wf16(:,24), wf8(:,126), A(:,517), n3(:,1040), t3x128(:,:,517), nhel, den(90))
    call Hcont_QA(nsync, wf16(:,139), wf8(:,127), A(:,518), n3(:,1041), t3x128(:,:,518), nhel, den(366))
    call Hcont_QA(nsync, wf16(:,140), wf8(:,127), A(:,519), n3(:,1042), t3x128(:,:,519), nhel, den(367))
    call Hcont_QA(nsync, wf8(:,66), wf16(:,208), A(:,520), n3(:,1043), t3x128(:,:,520), nhel, den(369))
    call Hcont_QA(nsync, wf8(:,67), wf16(:,208), A(:,521), n3(:,1044), t3x128(:,:,521), nhel, den(370))
    call Hcont_QA(nsync, wf16(:,30), wf8(:,128), A(:,522), n3(:,1045), t3x128(:,:,522), nhel, den(134))
    call Hcont_QA(nsync, wf16(:,31), wf8(:,128), A(:,523), n3(:,1046), t3x128(:,:,523), nhel, den(135))
    call Hcont_VV(nsync, wf8(:,48), wf16(:,209), A(:,524), n3(:,1047), t3x128(:,:,524), nhel, den(132))
    call Hcont_VV(nsync, wf8(:,48), wf16(:,210), A(:,525), n3(:,1048), t3x128(:,:,525), nhel, den(133))
    call Hcont_QA(nsync, wf16(:,44), wf8(:,118), A(:,526), n3(:,1049), t3x128(:,:,526), nhel, den(138))
    call Hcont_QA(nsync, wf16(:,44), wf8(:,119), A(:,527), n3(:,1050), t3x128(:,:,527), nhel, den(139))
    call Hcont_VV(nsync, wf8(:,48), wf16(:,211), A(:,528), n3(:,1051), t3x128(:,:,528), nhel, den(136))
    call Hcont_VV(nsync, wf8(:,48), wf16(:,212), A(:,529), n3(:,1052), t3x128(:,:,529), nhel, den(137))
    call Hcont_QA(nsync, wf8(:,3), wf16(:,213), A(:,530), n3(:,1053), t3x128(:,:,530), nhel, den(126))
    call Hcont_QA(nsync, wf8(:,7), wf16(:,213), A(:,531), n3(:,1054), t3x128(:,:,531), nhel, den(127))
    call Hcont_QA(nsync, wf8(:,47), wf16(:,201), A(:,532), n3(:,1055), t3x128(:,:,532), nhel, den(129))
    call Hcont_QA(nsync, wf8(:,47), wf16(:,202), A(:,533), n3(:,1056), t3x128(:,:,533), nhel, den(130))
    call Hcont_QA(nsync, wf8(:,39), wf16(:,199), A(:,534), n3(:,1057), t3x128(:,:,534), nhel, den(140))
    call Hcont_QA(nsync, wf8(:,39), wf16(:,200), A(:,535), n3(:,1058), t3x128(:,:,535), nhel, den(141))
    call Hcont_QA(nsync, wf8(:,27), wf16(:,206), A(:,536), n3(:,1059), t3x128(:,:,536), nhel, den(142))
    call Hcont_QA(nsync, wf8(:,27), wf16(:,207), A(:,537), n3(:,1060), t3x128(:,:,537), nhel, den(143))
    call Hcont_QA(nsync, wf16(:,28), wf8(:,129), A(:,538), n3(:,1061), t3x128(:,:,538), nhel, den(151))
    call Hcont_QA(nsync, wf16(:,29), wf8(:,129), A(:,539), n3(:,1062), t3x128(:,:,539), nhel, den(152))
    call Hcont_VV(nsync, wf8(:,49), wf16(:,209), A(:,540), n3(:,1063), t3x128(:,:,540), nhel, den(149))
    call Hcont_VV(nsync, wf8(:,49), wf16(:,210), A(:,541), n3(:,1064), t3x128(:,:,541), nhel, den(150))
    call Hcont_QA(nsync, wf16(:,45), wf8(:,118), A(:,542), n3(:,1065), t3x128(:,:,542), nhel, den(155))
    call Hcont_QA(nsync, wf16(:,45), wf8(:,119), A(:,543), n3(:,1066), t3x128(:,:,543), nhel, den(156))
    call Hcont_VV(nsync, wf8(:,49), wf16(:,211), A(:,544), n3(:,1067), t3x128(:,:,544), nhel, den(153))
    call Hcont_VV(nsync, wf8(:,49), wf16(:,212), A(:,545), n3(:,1068), t3x128(:,:,545), nhel, den(154))
    call Hcont_QA(nsync, wf16(:,36), wf8(:,130), A(:,546), n3(:,1069), t3x128(:,:,546), nhel, den(160))
    call Hcont_QA(nsync, wf16(:,37), wf8(:,130), A(:,547), n3(:,1070), t3x128(:,:,547), nhel, den(161))
    call Hcont_VV(nsync, wf8(:,50), wf16(:,209), A(:,548), n3(:,1071), t3x128(:,:,548), nhel, den(158))
    call Hcont_VV(nsync, wf8(:,50), wf16(:,210), A(:,549), n3(:,1072), t3x128(:,:,549), nhel, den(159))
    call Hcont_QA(nsync, wf16(:,46), wf8(:,118), A(:,550), n3(:,1073), t3x128(:,:,550), nhel, den(164))
    call Hcont_QA(nsync, wf16(:,46), wf8(:,119), A(:,551), n3(:,1074), t3x128(:,:,551), nhel, den(165))
    call Hcont_VV(nsync, wf8(:,50), wf16(:,211), A(:,552), n3(:,1075), t3x128(:,:,552), nhel, den(162))
    call Hcont_VV(nsync, wf8(:,50), wf16(:,212), A(:,553), n3(:,1076), t3x128(:,:,553), nhel, den(163))
    call Hcont_QA(nsync, wf16(:,36), wf8(:,121), A(:,554), n3(:,1077), t3x128(:,:,554), nhel, den(144))
    call Hcont_QA(nsync, wf16(:,37), wf8(:,121), A(:,555), n3(:,1078), t3x128(:,:,555), nhel, den(145))
    call Hcont_QA(nsync, wf16(:,28), wf8(:,126), A(:,556), n3(:,1079), t3x128(:,:,556), nhel, den(146))
    call Hcont_QA(nsync, wf16(:,29), wf8(:,126), A(:,557), n3(:,1080), t3x128(:,:,557), nhel, den(147))
    call Hcont_QA(nsync, wf8(:,39), wf16(:,203), A(:,558), n3(:,1081), t3x128(:,:,558), nhel, den(103))
    call Hcont_QA(nsync, wf8(:,39), wf16(:,204), A(:,559), n3(:,1082), t3x128(:,:,559), nhel, den(104))
    call Hcont_QA(nsync, wf16(:,25), wf8(:,132), A(:,560), n3(:,1083), t3x128(:,:,560), nhel, den(106))
    call Hcont_QA(nsync, wf16(:,26), wf8(:,132), A(:,561), n3(:,1084), t3x128(:,:,561), nhel, den(107))
    call Hcont_QA(nsync, wf8(:,3), wf16(:,214), A(:,562), n3(:,1085), t3x128(:,:,562), nhel, den(109))
    call Hcont_QA(nsync, wf8(:,7), wf16(:,214), A(:,563), n3(:,1086), t3x128(:,:,563), nhel, den(110))
    call Hcont_QA(nsync, wf8(:,43), wf16(:,203), A(:,564), n3(:,1087), t3x128(:,:,564), nhel, den(112))
    call Hcont_QA(nsync, wf8(:,43), wf16(:,204), A(:,565), n3(:,1088), t3x128(:,:,565), nhel, den(113))
    call Hcont_QA(nsync, wf16(:,36), wf8(:,123), A(:,566), n3(:,1089), t3x128(:,:,566), nhel, den(114))
    call Hcont_QA(nsync, wf16(:,37), wf8(:,123), A(:,567), n3(:,1090), t3x128(:,:,567), nhel, den(115))
    call Hcont_QA(nsync, wf16(:,30), wf8(:,132), A(:,568), n3(:,1091), t3x128(:,:,568), nhel, den(116))
    call Hcont_QA(nsync, wf16(:,31), wf8(:,132), A(:,569), n3(:,1092), t3x128(:,:,569), nhel, den(117))
    call Hcont_QA(nsync, wf8(:,23), wf16(:,215), A(:,570), n3(:,1093), t3x128(:,:,570), nhel, den(56))
    call Hcont_QA(nsync, wf8(:,23), wf16(:,216), A(:,571), n3(:,1094), t3x128(:,:,571), nhel, den(58))
    call Hcont_QA(nsync, wf16(:,23), wf8(:,134), A(:,572), n3(:,1095), t3x128(:,:,572), nhel, den(62))
    call Hcont_QA(nsync, wf16(:,24), wf8(:,134), A(:,573), n3(:,1096), t3x128(:,:,573), nhel, den(64))
    call Hcont_QA(nsync, wf8(:,27), wf16(:,215), A(:,574), n3(:,1097), t3x128(:,:,574), nhel, den(67))
    call Hcont_QA(nsync, wf8(:,27), wf16(:,216), A(:,575), n3(:,1098), t3x128(:,:,575), nhel, den(68))
    call Hcont_QA(nsync, wf16(:,25), wf8(:,136), A(:,576), n3(:,1099), t3x128(:,:,576), nhel, den(72))
    call Hcont_QA(nsync, wf16(:,26), wf8(:,136), A(:,577), n3(:,1100), t3x128(:,:,577), nhel, den(74))
    call Hcont_QA(nsync, wf8(:,3), wf16(:,217), A(:,578), n3(:,1101), t3x128(:,:,578), nhel, den(76))
    call Hcont_QA(nsync, wf8(:,7), wf16(:,217), A(:,579), n3(:,1102), t3x128(:,:,579), nhel, den(77))
    call Hcont_QA(nsync, wf8(:,31), wf16(:,215), A(:,580), n3(:,1103), t3x128(:,:,580), nhel, den(79))
    call Hcont_QA(nsync, wf8(:,31), wf16(:,216), A(:,581), n3(:,1104), t3x128(:,:,581), nhel, den(80))
    call Hcont_QA(nsync, wf16(:,28), wf8(:,134), A(:,582), n3(:,1105), t3x128(:,:,582), nhel, den(81))
    call Hcont_QA(nsync, wf16(:,29), wf8(:,134), A(:,583), n3(:,1106), t3x128(:,:,583), nhel, den(82))
    call Hcont_QA(nsync, wf16(:,30), wf8(:,136), A(:,584), n3(:,1107), t3x128(:,:,584), nhel, den(83))
    call Hcont_QA(nsync, wf16(:,31), wf8(:,136), A(:,585), n3(:,1108), t3x128(:,:,585), nhel, den(84))
    call Hcont_QA(nsync, wf16(:,129), wf8(:,137), A(:,586), n3(:,1109), t3x128(:,:,586), nhel, den(371))
    call Hcont_QA(nsync, wf16(:,130), wf8(:,137), A(:,587), n3(:,1110), t3x128(:,:,587), nhel, den(372))
    call Hcont_QA(nsync, wf8(:,68), wf16(:,218), A(:,588), n3(:,1111), t3x128(:,:,588), nhel, den(374))
    call Hcont_QA(nsync, wf8(:,69), wf16(:,218), A(:,589), n3(:,1112), t3x128(:,:,589), nhel, den(375))
    call Hcont_QA(nsync, wf8(:,25), wf16(:,219), A(:,590), n3(:,1113), t3x128(:,:,590), nhel, den(81))
    call Hcont_QA(nsync, wf8(:,25), wf16(:,220), A(:,591), n3(:,1114), t3x128(:,:,591), nhel, den(82))
    call Hcont_QA(nsync, wf8(:,29), wf16(:,221), A(:,592), n3(:,1115), t3x128(:,:,592), nhel, den(83))
    call Hcont_QA(nsync, wf8(:,29), wf16(:,222), A(:,593), n3(:,1116), t3x128(:,:,593), nhel, den(84))
    call Hcont_QA(nsync, wf16(:,21), wf8(:,141), A(:,594), n3(:,1117), t3x128(:,:,594), nhel, den(67))
    call Hcont_QA(nsync, wf16(:,22), wf8(:,141), A(:,595), n3(:,1118), t3x128(:,:,595), nhel, den(68))
    call Hcont_QA(nsync, wf8(:,29), wf16(:,223), A(:,596), n3(:,1119), t3x128(:,:,596), nhel, den(72))
    call Hcont_QA(nsync, wf8(:,29), wf16(:,224), A(:,597), n3(:,1120), t3x128(:,:,597), nhel, den(74))
    call Hcont_QA(nsync, wf16(:,21), wf8(:,143), A(:,598), n3(:,1121), t3x128(:,:,598), nhel, den(56))
    call Hcont_QA(nsync, wf16(:,22), wf8(:,143), A(:,599), n3(:,1122), t3x128(:,:,599), nhel, den(58))
    call Hcont_QA(nsync, wf8(:,25), wf16(:,225), A(:,600), n3(:,1123), t3x128(:,:,600), nhel, den(62))
    call Hcont_QA(nsync, wf8(:,25), wf16(:,226), A(:,601), n3(:,1124), t3x128(:,:,601), nhel, den(64))
    call Hcont_QA(nsync, wf16(:,105), wf8(:,144), A(:,602), n3(:,1125), t3x128(:,:,602), nhel, den(376))
    call Hcont_QA(nsync, wf16(:,106), wf8(:,144), A(:,603), n3(:,1126), t3x128(:,:,603), nhel, den(377))
    call Hcont_QA(nsync, wf8(:,68), wf16(:,227), A(:,604), n3(:,1127), t3x128(:,:,604), nhel, den(379))
    call Hcont_QA(nsync, wf8(:,69), wf16(:,227), A(:,605), n3(:,1128), t3x128(:,:,605), nhel, den(380))
    call Hcont_QA(nsync, wf8(:,13), wf16(:,228), A(:,606), n3(:,1129), t3x128(:,:,606), nhel, den(114))
    call Hcont_QA(nsync, wf8(:,13), wf16(:,229), A(:,607), n3(:,1130), t3x128(:,:,607), nhel, den(115))
    call Hcont_QA(nsync, wf8(:,41), wf16(:,221), A(:,608), n3(:,1131), t3x128(:,:,608), nhel, den(116))
    call Hcont_QA(nsync, wf8(:,41), wf16(:,222), A(:,609), n3(:,1132), t3x128(:,:,609), nhel, den(117))
    call Hcont_QA(nsync, wf16(:,10), wf8(:,146), A(:,610), n3(:,1133), t3x128(:,:,610), nhel, den(103))
    call Hcont_QA(nsync, wf16(:,11), wf8(:,146), A(:,611), n3(:,1134), t3x128(:,:,611), nhel, den(104))
    call Hcont_QA(nsync, wf8(:,41), wf16(:,223), A(:,612), n3(:,1135), t3x128(:,:,612), nhel, den(106))
    call Hcont_QA(nsync, wf8(:,41), wf16(:,224), A(:,613), n3(:,1136), t3x128(:,:,613), nhel, den(107))
    call Hcont_QA(nsync, wf16(:,115), wf8(:,147), A(:,614), n3(:,1137), t3x128(:,:,614), nhel, den(381))
    call Hcont_QA(nsync, wf16(:,116), wf8(:,147), A(:,615), n3(:,1138), t3x128(:,:,615), nhel, den(382))
    call Hcont_QA(nsync, wf8(:,68), wf16(:,230), A(:,616), n3(:,1139), t3x128(:,:,616), nhel, den(384))
    call Hcont_QA(nsync, wf8(:,69), wf16(:,230), A(:,617), n3(:,1140), t3x128(:,:,617), nhel, den(385))
    call Hcont_VV(nsync, wf8(:,48), wf16(:,231), A(:,618), n3(:,1141), t3x128(:,:,618), nhel, den(136))
    call Hcont_VV(nsync, wf8(:,48), wf16(:,232), A(:,619), n3(:,1142), t3x128(:,:,619), nhel, den(137))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,233), A(:,620), n3(:,1143), t3x128(:,:,620), nhel, den(138))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,233), A(:,621), n3(:,1144), t3x128(:,:,621), nhel, den(139))
    call Hcont_VV(nsync, wf8(:,48), wf16(:,234), A(:,622), n3(:,1145), t3x128(:,:,622), nhel, den(132))
    call Hcont_VV(nsync, wf8(:,48), wf16(:,235), A(:,623), n3(:,1146), t3x128(:,:,623), nhel, den(133))
    call Hcont_QA(nsync, wf8(:,45), wf16(:,221), A(:,624), n3(:,1147), t3x128(:,:,624), nhel, den(134))
    call Hcont_QA(nsync, wf8(:,45), wf16(:,222), A(:,625), n3(:,1148), t3x128(:,:,625), nhel, den(135))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,236), A(:,626), n3(:,1149), t3x128(:,:,626), nhel, den(120))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,236), A(:,627), n3(:,1150), t3x128(:,:,627), nhel, den(121))
    call Hcont_QA(nsync, wf8(:,45), wf16(:,223), A(:,628), n3(:,1151), t3x128(:,:,628), nhel, den(123))
    call Hcont_QA(nsync, wf8(:,45), wf16(:,224), A(:,629), n3(:,1152), t3x128(:,:,629), nhel, den(124))
    call Hcont_QA(nsync, wf8(:,17), wf16(:,228), A(:,630), n3(:,1153), t3x128(:,:,630), nhel, den(144))
    call Hcont_QA(nsync, wf8(:,17), wf16(:,229), A(:,631), n3(:,1154), t3x128(:,:,631), nhel, den(145))
    call Hcont_QA(nsync, wf8(:,35), wf16(:,219), A(:,632), n3(:,1155), t3x128(:,:,632), nhel, den(146))
    call Hcont_QA(nsync, wf8(:,35), wf16(:,220), A(:,633), n3(:,1156), t3x128(:,:,633), nhel, den(147))
    call Hcont_VV(nsync, wf8(:,49), wf16(:,231), A(:,634), n3(:,1157), t3x128(:,:,634), nhel, den(153))
    call Hcont_VV(nsync, wf8(:,49), wf16(:,232), A(:,635), n3(:,1158), t3x128(:,:,635), nhel, den(154))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,237), A(:,636), n3(:,1159), t3x128(:,:,636), nhel, den(155))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,237), A(:,637), n3(:,1160), t3x128(:,:,637), nhel, den(156))
    call Hcont_VV(nsync, wf8(:,49), wf16(:,234), A(:,638), n3(:,1161), t3x128(:,:,638), nhel, den(149))
    call Hcont_VV(nsync, wf8(:,49), wf16(:,235), A(:,639), n3(:,1162), t3x128(:,:,639), nhel, den(150))
    call Hcont_QA(nsync, wf8(:,37), wf16(:,219), A(:,640), n3(:,1163), t3x128(:,:,640), nhel, den(151))
    call Hcont_QA(nsync, wf8(:,37), wf16(:,220), A(:,641), n3(:,1164), t3x128(:,:,641), nhel, den(152))
    call Hcont_VV(nsync, wf8(:,50), wf16(:,231), A(:,642), n3(:,1165), t3x128(:,:,642), nhel, den(162))
    call Hcont_VV(nsync, wf8(:,50), wf16(:,232), A(:,643), n3(:,1166), t3x128(:,:,643), nhel, den(163))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,238), A(:,644), n3(:,1167), t3x128(:,:,644), nhel, den(164))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,238), A(:,645), n3(:,1168), t3x128(:,:,645), nhel, den(165))
    call Hcont_VV(nsync, wf8(:,50), wf16(:,234), A(:,646), n3(:,1169), t3x128(:,:,646), nhel, den(158))
    call Hcont_VV(nsync, wf8(:,50), wf16(:,235), A(:,647), n3(:,1170), t3x128(:,:,647), nhel, den(159))
    call Hcont_QA(nsync, wf8(:,21), wf16(:,228), A(:,648), n3(:,1171), t3x128(:,:,648), nhel, den(160))
    call Hcont_QA(nsync, wf8(:,21), wf16(:,229), A(:,649), n3(:,1172), t3x128(:,:,649), nhel, den(161))
    call Hcont_QA(nsync, wf16(:,19), wf8(:,146), A(:,650), n3(:,1173), t3x128(:,:,650), nhel, den(140))
    call Hcont_QA(nsync, wf16(:,20), wf8(:,146), A(:,651), n3(:,1174), t3x128(:,:,651), nhel, den(141))
    call Hcont_QA(nsync, wf16(:,33), wf8(:,141), A(:,652), n3(:,1175), t3x128(:,:,652), nhel, den(142))
    call Hcont_QA(nsync, wf16(:,34), wf8(:,141), A(:,653), n3(:,1176), t3x128(:,:,653), nhel, den(143))
    call Hcont_QA(nsync, wf16(:,14), wf8(:,152), A(:,654), n3(:,1177), t3x128(:,:,654), nhel, den(86))
    call Hcont_QA(nsync, wf16(:,15), wf8(:,152), A(:,655), n3(:,1178), t3x128(:,:,655), nhel, den(87))
    call Hcont_QA(nsync, wf8(:,35), wf16(:,225), A(:,656), n3(:,1179), t3x128(:,:,656), nhel, den(89))
    call Hcont_QA(nsync, wf8(:,35), wf16(:,226), A(:,657), n3(:,1180), t3x128(:,:,657), nhel, den(90))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,239), A(:,658), n3(:,1181), t3x128(:,:,658), nhel, den(93))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,239), A(:,659), n3(:,1182), t3x128(:,:,659), nhel, den(94))
    call Hcont_QA(nsync, wf8(:,37), wf16(:,225), A(:,660), n3(:,1183), t3x128(:,:,660), nhel, den(96))
    call Hcont_QA(nsync, wf8(:,37), wf16(:,226), A(:,661), n3(:,1184), t3x128(:,:,661), nhel, den(97))
    call Hcont_QA(nsync, wf16(:,17), wf8(:,152), A(:,662), n3(:,1185), t3x128(:,:,662), nhel, den(98))
    call Hcont_QA(nsync, wf16(:,18), wf8(:,152), A(:,663), n3(:,1186), t3x128(:,:,663), nhel, den(99))
    call Hcont_QA(nsync, wf16(:,33), wf8(:,143), A(:,664), n3(:,1187), t3x128(:,:,664), nhel, den(100))
    call Hcont_QA(nsync, wf16(:,34), wf8(:,143), A(:,665), n3(:,1188), t3x128(:,:,665), nhel, den(101))
    call Hcont_QA(nsync, wf16(:,10), wf8(:,154), A(:,666), n3(:,1189), t3x128(:,:,666), nhel, den(18))
    call Hcont_QA(nsync, wf16(:,11), wf8(:,154), A(:,667), n3(:,1190), t3x128(:,:,667), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,13), wf16(:,240), A(:,668), n3(:,1191), t3x128(:,:,668), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,13), wf16(:,241), A(:,669), n3(:,1192), t3x128(:,:,669), nhel, den(26))
    call Hcont_QA(nsync, wf16(:,14), wf8(:,156), A(:,670), n3(:,1193), t3x128(:,:,670), nhel, den(31))
    call Hcont_QA(nsync, wf16(:,15), wf8(:,156), A(:,671), n3(:,1194), t3x128(:,:,671), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,17), wf16(:,240), A(:,672), n3(:,1195), t3x128(:,:,672), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,17), wf16(:,241), A(:,673), n3(:,1196), t3x128(:,:,673), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,242), A(:,674), n3(:,1197), t3x128(:,:,674), nhel, den(41))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,242), A(:,675), n3(:,1198), t3x128(:,:,675), nhel, den(43))
    call Hcont_QA(nsync, wf8(:,21), wf16(:,240), A(:,676), n3(:,1199), t3x128(:,:,676), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,21), wf16(:,241), A(:,677), n3(:,1200), t3x128(:,:,677), nhel, den(46))
    call Hcont_QA(nsync, wf16(:,17), wf8(:,156), A(:,678), n3(:,1201), t3x128(:,:,678), nhel, den(47))
    call Hcont_QA(nsync, wf16(:,18), wf8(:,156), A(:,679), n3(:,1202), t3x128(:,:,679), nhel, den(48))
    call Hcont_QA(nsync, wf16(:,19), wf8(:,154), A(:,680), n3(:,1203), t3x128(:,:,680), nhel, den(49))
    call Hcont_QA(nsync, wf16(:,20), wf8(:,154), A(:,681), n3(:,1204), t3x128(:,:,681), nhel, den(50))
    call Hcont_QA(nsync, wf16(:,105), wf8(:,157), A(:,682), n3(:,1205), t3x128(:,:,682), nhel, den(387))
    call Hcont_QA(nsync, wf16(:,106), wf8(:,157), A(:,683), n3(:,1206), t3x128(:,:,683), nhel, den(388))
    call Hcont_QA(nsync, wf8(:,13), wf16(:,243), A(:,684), n3(:,1207), t3x128(:,:,684), nhel, den(390))
    call Hcont_QA(nsync, wf8(:,13), wf16(:,244), A(:,685), n3(:,1208), t3x128(:,:,685), nhel, den(392))
    call Hcont_QA(nsync, wf16(:,103), wf8(:,158), A(:,686), n3(:,1209), t3x128(:,:,686), nhel, den(394))
    call Hcont_QA(nsync, wf16(:,104), wf8(:,158), A(:,687), n3(:,1210), t3x128(:,:,687), nhel, den(395))
    call Hcont_QA(nsync, wf8(:,11), wf16(:,245), A(:,688), n3(:,1211), t3x128(:,:,688), nhel, den(397))
    call Hcont_QA(nsync, wf8(:,11), wf16(:,246), A(:,689), n3(:,1212), t3x128(:,:,689), nhel, den(399))
    call Hcont_QA(nsync, wf16(:,105), wf8(:,159), A(:,690), n3(:,1213), t3x128(:,:,690), nhel, den(400))
    call Hcont_QA(nsync, wf16(:,106), wf8(:,159), A(:,691), n3(:,1214), t3x128(:,:,691), nhel, den(401))
    call Hcont_QA(nsync, wf16(:,103), wf8(:,160), A(:,692), n3(:,1215), t3x128(:,:,692), nhel, den(402))
    call Hcont_QA(nsync, wf16(:,104), wf8(:,160), A(:,693), n3(:,1216), t3x128(:,:,693), nhel, den(403))
    call Hcont_QA(nsync, wf16(:,115), wf8(:,161), A(:,694), n3(:,1217), t3x128(:,:,694), nhel, den(404))
    call Hcont_QA(nsync, wf16(:,116), wf8(:,161), A(:,695), n3(:,1218), t3x128(:,:,695), nhel, den(405))
    call Hcont_QA(nsync, wf8(:,17), wf16(:,243), A(:,696), n3(:,1219), t3x128(:,:,696), nhel, den(406))
    call Hcont_QA(nsync, wf8(:,17), wf16(:,244), A(:,697), n3(:,1220), t3x128(:,:,697), nhel, den(407))
    call Hcont_QA(nsync, wf16(:,103), wf8(:,162), A(:,698), n3(:,1221), t3x128(:,:,698), nhel, den(409))
    call Hcont_QA(nsync, wf16(:,104), wf8(:,162), A(:,699), n3(:,1222), t3x128(:,:,699), nhel, den(410))
    call Hcont_QA(nsync, wf8(:,15), wf16(:,247), A(:,700), n3(:,1223), t3x128(:,:,700), nhel, den(412))
    call Hcont_QA(nsync, wf8(:,15), wf16(:,248), A(:,701), n3(:,1224), t3x128(:,:,701), nhel, den(414))
    call Hcont_QA(nsync, wf16(:,115), wf8(:,163), A(:,702), n3(:,1225), t3x128(:,:,702), nhel, den(415))
    call Hcont_QA(nsync, wf16(:,116), wf8(:,163), A(:,703), n3(:,1226), t3x128(:,:,703), nhel, den(416))
    call Hcont_QA(nsync, wf16(:,103), wf8(:,164), A(:,704), n3(:,1227), t3x128(:,:,704), nhel, den(417))
    call Hcont_QA(nsync, wf16(:,104), wf8(:,164), A(:,705), n3(:,1228), t3x128(:,:,705), nhel, den(418))
    call Hcont_VV(nsync, wf4(:,10), wf32(:,13), A(:,706), n3(:,1229), t3x128(:,:,706), nhel, den(420))
    call Hcont_VV(nsync, wf4(:,10), wf32(:,14), A(:,707), n3(:,1230), t3x128(:,:,707), nhel, den(422))
    call Hcont_QA(nsync, wf8(:,21), wf16(:,243), A(:,708), n3(:,1231), t3x128(:,:,708), nhel, den(423))
    call Hcont_QA(nsync, wf8(:,21), wf16(:,244), A(:,709), n3(:,1232), t3x128(:,:,709), nhel, den(424))
    call Hcont_QA(nsync, wf16(:,103), wf8(:,165), A(:,710), n3(:,1233), t3x128(:,:,710), nhel, den(426))
    call Hcont_QA(nsync, wf16(:,104), wf8(:,165), A(:,711), n3(:,1234), t3x128(:,:,711), nhel, den(427))
    call Hcont_QA(nsync, wf16(:,196), wf8(:,166), A(:,712), n3(:,1235), t3x128(:,:,712), nhel, den(428))
    call Hcont_QA(nsync, wf16(:,196), wf8(:,167), A(:,713), n3(:,1236), t3x128(:,:,713), nhel, den(429))
    call Hcont_QA(nsync, wf16(:,103), wf8(:,168), A(:,714), n3(:,1237), t3x128(:,:,714), nhel, den(430))
    call Hcont_QA(nsync, wf16(:,104), wf8(:,168), A(:,715), n3(:,1238), t3x128(:,:,715), nhel, den(431))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,249), A(:,716), n3(:,1239), t3x128(:,:,716), nhel, den(433))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,249), A(:,717), n3(:,1240), t3x128(:,:,717), nhel, den(434))
    call Hcont_QA(nsync, wf16(:,17), wf8(:,169), A(:,718), n3(:,1241), t3x128(:,:,718), nhel, den(436))
    call Hcont_QA(nsync, wf16(:,18), wf8(:,169), A(:,719), n3(:,1242), t3x128(:,:,719), nhel, den(437))
    call Hcont_QA(nsync, wf8(:,157), wf16(:,250), A(:,720), n3(:,1243), t3x128(:,:,720), nhel, den(439))
    call Hcont_QA(nsync, wf8(:,157), wf16(:,251), A(:,721), n3(:,1244), t3x128(:,:,721), nhel, den(441))
    call Hcont_QA(nsync, wf8(:,166), wf16(:,253), A(:,722), n3(:,1245), t3x128(:,:,722), nhel, den(443))
    call Hcont_QA(nsync, wf8(:,167), wf16(:,253), A(:,723), n3(:,1246), t3x128(:,:,723), nhel, den(444))
    call Hcont_QA(nsync, wf8(:,166), wf16(:,255), A(:,724), n3(:,1247), t3x128(:,:,724), nhel, den(446))
    call Hcont_QA(nsync, wf8(:,167), wf16(:,255), A(:,725), n3(:,1248), t3x128(:,:,725), nhel, den(447))
    call Hcont_QA(nsync, wf8(:,163), wf16(:,256), A(:,726), n3(:,1249), t3x128(:,:,726), nhel, den(449))
    call Hcont_QA(nsync, wf8(:,163), wf16(:,257), A(:,727), n3(:,1250), t3x128(:,:,727), nhel, den(451))
    call Hcont_QA(nsync, wf8(:,159), wf16(:,250), A(:,728), n3(:,1251), t3x128(:,:,728), nhel, den(452))
    call Hcont_QA(nsync, wf8(:,159), wf16(:,251), A(:,729), n3(:,1252), t3x128(:,:,729), nhel, den(453))
    call Hcont_QA(nsync, wf16(:,129), wf8(:,170), A(:,730), n3(:,1253), t3x128(:,:,730), nhel, den(455))
    call Hcont_QA(nsync, wf16(:,130), wf8(:,170), A(:,731), n3(:,1254), t3x128(:,:,731), nhel, den(456))
    call Hcont_QA(nsync, wf8(:,25), wf16(:,258), A(:,732), n3(:,1255), t3x128(:,:,732), nhel, den(458))
    call Hcont_QA(nsync, wf8(:,25), wf16(:,259), A(:,733), n3(:,1256), t3x128(:,:,733), nhel, den(460))
    call Hcont_QA(nsync, wf16(:,127), wf8(:,171), A(:,734), n3(:,1257), t3x128(:,:,734), nhel, den(462))
    call Hcont_QA(nsync, wf16(:,128), wf8(:,171), A(:,735), n3(:,1258), t3x128(:,:,735), nhel, den(463))
    call Hcont_QA(nsync, wf8(:,23), wf16(:,260), A(:,736), n3(:,1259), t3x128(:,:,736), nhel, den(465))
    call Hcont_QA(nsync, wf8(:,23), wf16(:,261), A(:,737), n3(:,1260), t3x128(:,:,737), nhel, den(467))
    call Hcont_QA(nsync, wf16(:,129), wf8(:,172), A(:,738), n3(:,1261), t3x128(:,:,738), nhel, den(468))
    call Hcont_QA(nsync, wf16(:,130), wf8(:,172), A(:,739), n3(:,1262), t3x128(:,:,739), nhel, den(469))
    call Hcont_QA(nsync, wf16(:,127), wf8(:,173), A(:,740), n3(:,1263), t3x128(:,:,740), nhel, den(470))
    call Hcont_QA(nsync, wf16(:,128), wf8(:,173), A(:,741), n3(:,1264), t3x128(:,:,741), nhel, den(471))
    call Hcont_QA(nsync, wf16(:,129), wf8(:,174), A(:,742), n3(:,1265), t3x128(:,:,742), nhel, den(473))
    call Hcont_QA(nsync, wf16(:,130), wf8(:,174), A(:,743), n3(:,1266), t3x128(:,:,743), nhel, den(474))
    call Hcont_QA(nsync, wf8(:,29), wf16(:,262), A(:,744), n3(:,1267), t3x128(:,:,744), nhel, den(476))
    call Hcont_QA(nsync, wf8(:,29), wf16(:,263), A(:,745), n3(:,1268), t3x128(:,:,745), nhel, den(478))
    call Hcont_QA(nsync, wf16(:,139), wf8(:,175), A(:,746), n3(:,1269), t3x128(:,:,746), nhel, den(479))
    call Hcont_QA(nsync, wf16(:,140), wf8(:,175), A(:,747), n3(:,1270), t3x128(:,:,747), nhel, den(480))
    call Hcont_QA(nsync, wf8(:,27), wf16(:,260), A(:,748), n3(:,1271), t3x128(:,:,748), nhel, den(481))
    call Hcont_QA(nsync, wf8(:,27), wf16(:,261), A(:,749), n3(:,1272), t3x128(:,:,749), nhel, den(482))
    call Hcont_QA(nsync, wf16(:,129), wf8(:,176), A(:,750), n3(:,1273), t3x128(:,:,750), nhel, den(483))
    call Hcont_QA(nsync, wf16(:,130), wf8(:,176), A(:,751), n3(:,1274), t3x128(:,:,751), nhel, den(484))
    call Hcont_QA(nsync, wf16(:,139), wf8(:,177), A(:,752), n3(:,1275), t3x128(:,:,752), nhel, den(485))
    call Hcont_QA(nsync, wf16(:,140), wf8(:,177), A(:,753), n3(:,1276), t3x128(:,:,753), nhel, den(486))
    call Hcont_QA(nsync, wf16(:,129), wf8(:,178), A(:,754), n3(:,1277), t3x128(:,:,754), nhel, den(487))
    call Hcont_QA(nsync, wf16(:,130), wf8(:,178), A(:,755), n3(:,1278), t3x128(:,:,755), nhel, den(488))
    call Hcont_QA(nsync, wf8(:,93), wf16(:,218), A(:,756), n3(:,1279), t3x128(:,:,756), nhel, den(489))
    call Hcont_QA(nsync, wf8(:,94), wf16(:,218), A(:,757), n3(:,1280), t3x128(:,:,757), nhel, den(490))
    call Hcont_QA(nsync, wf16(:,129), wf8(:,179), A(:,758), n3(:,1281), t3x128(:,:,758), nhel, den(491))
    call Hcont_QA(nsync, wf16(:,130), wf8(:,179), A(:,759), n3(:,1282), t3x128(:,:,759), nhel, den(492))
    call Hcont_VV(nsync, wf4(:,10), wf32(:,15), A(:,760), n3(:,1283), t3x128(:,:,760), nhel, den(494))
    call Hcont_VV(nsync, wf4(:,10), wf32(:,16), A(:,761), n3(:,1284), t3x128(:,:,761), nhel, den(496))
    call Hcont_QA(nsync, wf8(:,31), wf16(:,260), A(:,762), n3(:,1285), t3x128(:,:,762), nhel, den(497))
    call Hcont_QA(nsync, wf8(:,31), wf16(:,261), A(:,763), n3(:,1286), t3x128(:,:,763), nhel, den(498))
    call Hcont_QA(nsync, wf4(:,14), wf32(:,17), A(:,764), n3(:,1287), t3x128(:,:,764), nhel, den(500))
    call Hcont_QA(nsync, wf4(:,14), wf32(:,18), A(:,765), n3(:,1288), t3x128(:,:,765), nhel, den(502))
    call Hcont_QA(nsync, wf8(:,93), wf16(:,265), A(:,766), n3(:,1289), t3x128(:,:,766), nhel, den(504))
    call Hcont_QA(nsync, wf8(:,94), wf16(:,265), A(:,767), n3(:,1290), t3x128(:,:,767), nhel, den(505))
    call Hcont_QA(nsync, wf8(:,93), wf16(:,267), A(:,768), n3(:,1291), t3x128(:,:,768), nhel, den(507))
    call Hcont_QA(nsync, wf8(:,94), wf16(:,267), A(:,769), n3(:,1292), t3x128(:,:,769), nhel, den(508))
    call Hcont_QA(nsync, wf16(:,30), wf8(:,180), A(:,770), n3(:,1293), t3x128(:,:,770), nhel, den(510))
    call Hcont_QA(nsync, wf16(:,31), wf8(:,180), A(:,771), n3(:,1294), t3x128(:,:,771), nhel, den(511))
    call Hcont_QA(nsync, wf8(:,171), wf16(:,268), A(:,772), n3(:,1295), t3x128(:,:,772), nhel, den(513))
    call Hcont_QA(nsync, wf8(:,171), wf16(:,269), A(:,773), n3(:,1296), t3x128(:,:,773), nhel, den(515))
    call Hcont_QA(nsync, wf8(:,173), wf16(:,268), A(:,774), n3(:,1297), t3x128(:,:,774), nhel, den(516))
    call Hcont_QA(nsync, wf8(:,173), wf16(:,269), A(:,775), n3(:,1298), t3x128(:,:,775), nhel, den(517))
    call Hcont_QA(nsync, wf8(:,177), wf16(:,270), A(:,776), n3(:,1299), t3x128(:,:,776), nhel, den(519))
    call Hcont_QA(nsync, wf8(:,177), wf16(:,271), A(:,777), n3(:,1300), t3x128(:,:,777), nhel, den(521))
    call Hcont_QA(nsync, wf16(:,115), wf8(:,181), A(:,778), n3(:,1301), t3x128(:,:,778), nhel, den(522))
    call Hcont_QA(nsync, wf16(:,116), wf8(:,181), A(:,779), n3(:,1302), t3x128(:,:,779), nhel, den(523))
    call Hcont_QA(nsync, wf8(:,35), wf16(:,258), A(:,780), n3(:,1303), t3x128(:,:,780), nhel, den(524))
    call Hcont_QA(nsync, wf8(:,35), wf16(:,259), A(:,781), n3(:,1304), t3x128(:,:,781), nhel, den(525))
    call Hcont_QA(nsync, wf16(:,127), wf8(:,182), A(:,782), n3(:,1305), t3x128(:,:,782), nhel, den(526))
    call Hcont_QA(nsync, wf16(:,128), wf8(:,182), A(:,783), n3(:,1306), t3x128(:,:,783), nhel, den(527))
    call Hcont_QA(nsync, wf8(:,33), wf16(:,247), A(:,784), n3(:,1307), t3x128(:,:,784), nhel, den(528))
    call Hcont_QA(nsync, wf8(:,33), wf16(:,248), A(:,785), n3(:,1308), t3x128(:,:,785), nhel, den(529))
    call Hcont_QA(nsync, wf16(:,115), wf8(:,183), A(:,786), n3(:,1309), t3x128(:,:,786), nhel, den(530))
    call Hcont_QA(nsync, wf16(:,116), wf8(:,183), A(:,787), n3(:,1310), t3x128(:,:,787), nhel, den(531))
    call Hcont_QA(nsync, wf16(:,127), wf8(:,184), A(:,788), n3(:,1311), t3x128(:,:,788), nhel, den(532))
    call Hcont_QA(nsync, wf16(:,128), wf8(:,184), A(:,789), n3(:,1312), t3x128(:,:,789), nhel, den(533))
    call Hcont_VV(nsync, wf4(:,17), wf32(:,19), A(:,790), n3(:,1313), t3x128(:,:,790), nhel, den(535))
    call Hcont_VV(nsync, wf4(:,17), wf32(:,20), A(:,791), n3(:,1314), t3x128(:,:,791), nhel, den(537))
    call Hcont_QA(nsync, wf8(:,37), wf16(:,258), A(:,792), n3(:,1315), t3x128(:,:,792), nhel, den(538))
    call Hcont_QA(nsync, wf8(:,37), wf16(:,259), A(:,793), n3(:,1316), t3x128(:,:,793), nhel, den(539))
    call Hcont_QA(nsync, wf16(:,127), wf8(:,185), A(:,794), n3(:,1317), t3x128(:,:,794), nhel, den(541))
    call Hcont_QA(nsync, wf16(:,128), wf8(:,185), A(:,795), n3(:,1318), t3x128(:,:,795), nhel, den(542))
    call Hcont_QA(nsync, wf16(:,205), wf8(:,166), A(:,796), n3(:,1319), t3x128(:,:,796), nhel, den(543))
    call Hcont_QA(nsync, wf16(:,205), wf8(:,167), A(:,797), n3(:,1320), t3x128(:,:,797), nhel, den(544))
    call Hcont_QA(nsync, wf16(:,127), wf8(:,186), A(:,798), n3(:,1321), t3x128(:,:,798), nhel, den(545))
    call Hcont_QA(nsync, wf16(:,128), wf8(:,186), A(:,799), n3(:,1322), t3x128(:,:,799), nhel, den(546))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,272), A(:,800), n3(:,1323), t3x128(:,:,800), nhel, den(548))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,272), A(:,801), n3(:,1324), t3x128(:,:,801), nhel, den(549))
    call Hcont_QA(nsync, wf16(:,17), wf8(:,187), A(:,802), n3(:,1325), t3x128(:,:,802), nhel, den(551))
    call Hcont_QA(nsync, wf16(:,18), wf8(:,187), A(:,803), n3(:,1326), t3x128(:,:,803), nhel, den(552))
    call Hcont_QA(nsync, wf8(:,170), wf16(:,273), A(:,804), n3(:,1327), t3x128(:,:,804), nhel, den(554))
    call Hcont_QA(nsync, wf8(:,170), wf16(:,274), A(:,805), n3(:,1328), t3x128(:,:,805), nhel, den(556))
    call Hcont_QA(nsync, wf8(:,166), wf16(:,276), A(:,806), n3(:,1329), t3x128(:,:,806), nhel, den(558))
    call Hcont_QA(nsync, wf8(:,167), wf16(:,276), A(:,807), n3(:,1330), t3x128(:,:,807), nhel, den(559))
    call Hcont_QA(nsync, wf8(:,166), wf16(:,278), A(:,808), n3(:,1331), t3x128(:,:,808), nhel, den(561))
    call Hcont_QA(nsync, wf8(:,167), wf16(:,278), A(:,809), n3(:,1332), t3x128(:,:,809), nhel, den(562))
    call Hcont_QA(nsync, wf16(:,256), wf8(:,183), A(:,810), n3(:,1333), t3x128(:,:,810), nhel, den(563))
    call Hcont_QA(nsync, wf16(:,257), wf8(:,183), A(:,811), n3(:,1334), t3x128(:,:,811), nhel, den(564))
    call Hcont_QA(nsync, wf8(:,172), wf16(:,273), A(:,812), n3(:,1335), t3x128(:,:,812), nhel, den(565))
    call Hcont_QA(nsync, wf8(:,172), wf16(:,274), A(:,813), n3(:,1336), t3x128(:,:,813), nhel, den(566))
    call Hcont_QA(nsync, wf16(:,105), wf8(:,188), A(:,814), n3(:,1337), t3x128(:,:,814), nhel, den(567))
    call Hcont_QA(nsync, wf16(:,106), wf8(:,188), A(:,815), n3(:,1338), t3x128(:,:,815), nhel, den(568))
    call Hcont_QA(nsync, wf8(:,41), wf16(:,262), A(:,816), n3(:,1339), t3x128(:,:,816), nhel, den(569))
    call Hcont_QA(nsync, wf8(:,41), wf16(:,263), A(:,817), n3(:,1340), t3x128(:,:,817), nhel, den(570))
    call Hcont_QA(nsync, wf16(:,139), wf8(:,189), A(:,818), n3(:,1341), t3x128(:,:,818), nhel, den(571))
    call Hcont_QA(nsync, wf16(:,140), wf8(:,189), A(:,819), n3(:,1342), t3x128(:,:,819), nhel, den(572))
    call Hcont_QA(nsync, wf8(:,39), wf16(:,245), A(:,820), n3(:,1343), t3x128(:,:,820), nhel, den(573))
    call Hcont_QA(nsync, wf8(:,39), wf16(:,246), A(:,821), n3(:,1344), t3x128(:,:,821), nhel, den(574))
    call Hcont_QA(nsync, wf16(:,105), wf8(:,190), A(:,822), n3(:,1345), t3x128(:,:,822), nhel, den(575))
    call Hcont_QA(nsync, wf16(:,106), wf8(:,190), A(:,823), n3(:,1346), t3x128(:,:,823), nhel, den(576))
    call Hcont_QA(nsync, wf16(:,139), wf8(:,191), A(:,824), n3(:,1347), t3x128(:,:,824), nhel, den(577))
    call Hcont_QA(nsync, wf16(:,140), wf8(:,191), A(:,825), n3(:,1348), t3x128(:,:,825), nhel, den(578))
    call Hcont_QA(nsync, wf16(:,105), wf8(:,192), A(:,826), n3(:,1349), t3x128(:,:,826), nhel, den(579))
    call Hcont_QA(nsync, wf16(:,106), wf8(:,192), A(:,827), n3(:,1350), t3x128(:,:,827), nhel, den(580))
    call Hcont_QA(nsync, wf8(:,93), wf16(:,227), A(:,828), n3(:,1351), t3x128(:,:,828), nhel, den(581))
    call Hcont_QA(nsync, wf8(:,94), wf16(:,227), A(:,829), n3(:,1352), t3x128(:,:,829), nhel, den(582))
    call Hcont_QA(nsync, wf16(:,105), wf8(:,193), A(:,830), n3(:,1353), t3x128(:,:,830), nhel, den(583))
    call Hcont_QA(nsync, wf16(:,106), wf8(:,193), A(:,831), n3(:,1354), t3x128(:,:,831), nhel, den(584))
    call Hcont_VV(nsync, wf4(:,17), wf32(:,21), A(:,832), n3(:,1355), t3x128(:,:,832), nhel, den(586))
    call Hcont_VV(nsync, wf4(:,17), wf32(:,22), A(:,833), n3(:,1356), t3x128(:,:,833), nhel, den(588))
    call Hcont_QA(nsync, wf8(:,43), wf16(:,245), A(:,834), n3(:,1357), t3x128(:,:,834), nhel, den(589))
    call Hcont_QA(nsync, wf8(:,43), wf16(:,246), A(:,835), n3(:,1358), t3x128(:,:,835), nhel, den(590))
    call Hcont_QA(nsync, wf4(:,7), wf32(:,23), A(:,836), n3(:,1359), t3x128(:,:,836), nhel, den(592))
    call Hcont_QA(nsync, wf4(:,7), wf32(:,24), A(:,837), n3(:,1360), t3x128(:,:,837), nhel, den(594))
    call Hcont_QA(nsync, wf8(:,93), wf16(:,280), A(:,838), n3(:,1361), t3x128(:,:,838), nhel, den(596))
    call Hcont_QA(nsync, wf8(:,94), wf16(:,280), A(:,839), n3(:,1362), t3x128(:,:,839), nhel, den(597))
    call Hcont_QA(nsync, wf8(:,93), wf16(:,282), A(:,840), n3(:,1363), t3x128(:,:,840), nhel, den(599))
    call Hcont_QA(nsync, wf8(:,94), wf16(:,282), A(:,841), n3(:,1364), t3x128(:,:,841), nhel, den(600))
    call Hcont_QA(nsync, wf16(:,30), wf8(:,194), A(:,842), n3(:,1365), t3x128(:,:,842), nhel, den(602))
    call Hcont_QA(nsync, wf16(:,31), wf8(:,194), A(:,843), n3(:,1366), t3x128(:,:,843), nhel, den(603))
    call Hcont_QA(nsync, wf8(:,158), wf16(:,283), A(:,844), n3(:,1367), t3x128(:,:,844), nhel, den(605))
    call Hcont_QA(nsync, wf8(:,158), wf16(:,284), A(:,845), n3(:,1368), t3x128(:,:,845), nhel, den(607))
    call Hcont_QA(nsync, wf8(:,160), wf16(:,283), A(:,846), n3(:,1369), t3x128(:,:,846), nhel, den(608))
    call Hcont_QA(nsync, wf8(:,160), wf16(:,284), A(:,847), n3(:,1370), t3x128(:,:,847), nhel, den(609))
    call Hcont_QA(nsync, wf16(:,270), wf8(:,191), A(:,848), n3(:,1371), t3x128(:,:,848), nhel, den(610))
    call Hcont_QA(nsync, wf16(:,271), wf8(:,191), A(:,849), n3(:,1372), t3x128(:,:,849), nhel, den(611))
    call Hcont_VV(nsync, wf4(:,18), wf32(:,25), A(:,850), n3(:,1373), t3x128(:,:,850), nhel, den(613))
    call Hcont_VV(nsync, wf4(:,18), wf32(:,26), A(:,851), n3(:,1374), t3x128(:,:,851), nhel, den(615))
    call Hcont_QA(nsync, wf8(:,45), wf16(:,262), A(:,852), n3(:,1375), t3x128(:,:,852), nhel, den(616))
    call Hcont_QA(nsync, wf8(:,45), wf16(:,263), A(:,853), n3(:,1376), t3x128(:,:,853), nhel, den(617))
    call Hcont_QA(nsync, wf16(:,139), wf8(:,195), A(:,854), n3(:,1377), t3x128(:,:,854), nhel, den(619))
    call Hcont_QA(nsync, wf16(:,140), wf8(:,195), A(:,855), n3(:,1378), t3x128(:,:,855), nhel, den(620))
    call Hcont_QA(nsync, wf16(:,208), wf8(:,166), A(:,856), n3(:,1379), t3x128(:,:,856), nhel, den(621))
    call Hcont_QA(nsync, wf16(:,208), wf8(:,167), A(:,857), n3(:,1380), t3x128(:,:,857), nhel, den(622))
    call Hcont_QA(nsync, wf16(:,139), wf8(:,196), A(:,858), n3(:,1381), t3x128(:,:,858), nhel, den(623))
    call Hcont_QA(nsync, wf16(:,140), wf8(:,196), A(:,859), n3(:,1382), t3x128(:,:,859), nhel, den(624))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,285), A(:,860), n3(:,1383), t3x128(:,:,860), nhel, den(626))
    call Hcont_QA(nsync, wf8(:,19), wf16(:,285), A(:,861), n3(:,1384), t3x128(:,:,861), nhel, den(627))
    call Hcont_QA(nsync, wf16(:,115), wf8(:,197), A(:,862), n3(:,1385), t3x128(:,:,862), nhel, den(628))
    call Hcont_QA(nsync, wf16(:,116), wf8(:,197), A(:,863), n3(:,1386), t3x128(:,:,863), nhel, den(629))
    call Hcont_QA(nsync, wf8(:,93), wf16(:,230), A(:,864), n3(:,1387), t3x128(:,:,864), nhel, den(630))
    call Hcont_QA(nsync, wf8(:,94), wf16(:,230), A(:,865), n3(:,1388), t3x128(:,:,865), nhel, den(631))
    call Hcont_QA(nsync, wf16(:,115), wf8(:,198), A(:,866), n3(:,1389), t3x128(:,:,866), nhel, den(632))
    call Hcont_QA(nsync, wf16(:,116), wf8(:,198), A(:,867), n3(:,1390), t3x128(:,:,867), nhel, den(633))
    call Hcont_VV(nsync, wf4(:,18), wf32(:,27), A(:,868), n3(:,1391), t3x128(:,:,868), nhel, den(635))
    call Hcont_VV(nsync, wf4(:,18), wf32(:,28), A(:,869), n3(:,1392), t3x128(:,:,869), nhel, den(637))
    call Hcont_QA(nsync, wf8(:,47), wf16(:,247), A(:,870), n3(:,1393), t3x128(:,:,870), nhel, den(638))
    call Hcont_QA(nsync, wf8(:,47), wf16(:,248), A(:,871), n3(:,1394), t3x128(:,:,871), nhel, den(639))
    call Hcont_QA(nsync, wf4(:,9), wf32(:,29), A(:,872), n3(:,1395), t3x128(:,:,872), nhel, den(641))
    call Hcont_QA(nsync, wf4(:,9), wf32(:,30), A(:,873), n3(:,1396), t3x128(:,:,873), nhel, den(643))
    call Hcont_QA(nsync, wf8(:,93), wf16(:,287), A(:,874), n3(:,1397), t3x128(:,:,874), nhel, den(645))
    call Hcont_QA(nsync, wf8(:,94), wf16(:,287), A(:,875), n3(:,1398), t3x128(:,:,875), nhel, den(646))
    call Hcont_QA(nsync, wf8(:,166), wf16(:,289), A(:,876), n3(:,1399), t3x128(:,:,876), nhel, den(648))
    call Hcont_QA(nsync, wf8(:,167), wf16(:,289), A(:,877), n3(:,1400), t3x128(:,:,877), nhel, den(649))
    call Hcont_QA(nsync, wf16(:,17), wf8(:,199), A(:,878), n3(:,1401), t3x128(:,:,878), nhel, den(651))
    call Hcont_QA(nsync, wf16(:,18), wf8(:,199), A(:,879), n3(:,1402), t3x128(:,:,879), nhel, den(652))
    call Hcont_QA(nsync, wf8(:,93), wf16(:,291), A(:,880), n3(:,1403), t3x128(:,:,880), nhel, den(654))
    call Hcont_QA(nsync, wf8(:,94), wf16(:,291), A(:,881), n3(:,1404), t3x128(:,:,881), nhel, den(655))
    call Hcont_VV(nsync, wf16(:,42), wf8(:,200), A(:,882), n3(:,1405), t3x128(:,:,882), nhel, den(658))
    call Hcont_VV(nsync, wf16(:,43), wf8(:,200), A(:,883), n3(:,1406), t3x128(:,:,883), nhel, den(660))
    call Hcont_QA(nsync, wf16(:,256), wf8(:,198), A(:,884), n3(:,1407), t3x128(:,:,884), nhel, den(661))
    call Hcont_QA(nsync, wf16(:,257), wf8(:,198), A(:,885), n3(:,1408), t3x128(:,:,885), nhel, den(662))
    call Hcont_QA(nsync, wf16(:,30), wf8(:,201), A(:,886), n3(:,1409), t3x128(:,:,886), nhel, den(664))
    call Hcont_QA(nsync, wf16(:,31), wf8(:,201), A(:,887), n3(:,1410), t3x128(:,:,887), nhel, den(665))
    call Hcont_VV(nsync, wf16(:,40), wf8(:,200), A(:,888), n3(:,1411), t3x128(:,:,888), nhel, den(667))
    call Hcont_VV(nsync, wf16(:,41), wf8(:,200), A(:,889), n3(:,1412), t3x128(:,:,889), nhel, den(669))
    call Hcont_QA(nsync, wf16(:,270), wf8(:,196), A(:,890), n3(:,1413), t3x128(:,:,890), nhel, den(670))
    call Hcont_QA(nsync, wf16(:,271), wf8(:,196), A(:,891), n3(:,1414), t3x128(:,:,891), nhel, den(671))
    call Hcont_QA(nsync, wf8(:,166), wf16(:,292), A(:,892), n3(:,1415), t3x128(:,:,892), nhel, den(673))
    call Hcont_QA(nsync, wf8(:,167), wf16(:,292), A(:,893), n3(:,1416), t3x128(:,:,893), nhel, den(674))
    call Hcont_VV(nsync, wf16(:,40), wf8(:,202), A(:,894), n3(:,1417), t3x128(:,:,894), nhel, den(675))
    call Hcont_VV(nsync, wf16(:,41), wf8(:,202), A(:,895), n3(:,1418), t3x128(:,:,895), nhel, den(676))
    call Hcont_VV(nsync, wf16(:,42), wf8(:,202), A(:,896), n3(:,1419), t3x128(:,:,896), nhel, den(677))
    call Hcont_VV(nsync, wf16(:,43), wf8(:,202), A(:,897), n3(:,1420), t3x128(:,:,897), nhel, den(678))
    call Hcont_QA(nsync, wf16(:,19), wf8(:,203), A(:,898), n3(:,1421), t3x128(:,:,898), nhel, den(680))
    call Hcont_QA(nsync, wf16(:,20), wf8(:,203), A(:,899), n3(:,1422), t3x128(:,:,899), nhel, den(681))
    call Hcont_QA(nsync, wf8(:,174), wf16(:,273), A(:,900), n3(:,1423), t3x128(:,:,900), nhel, den(682))
    call Hcont_QA(nsync, wf8(:,174), wf16(:,274), A(:,901), n3(:,1424), t3x128(:,:,901), nhel, den(683))
    call Hcont_QA(nsync, wf8(:,166), wf16(:,294), A(:,902), n3(:,1425), t3x128(:,:,902), nhel, den(685))
    call Hcont_QA(nsync, wf8(:,167), wf16(:,294), A(:,903), n3(:,1426), t3x128(:,:,903), nhel, den(686))
    call Hcont_QA(nsync, wf8(:,166), wf16(:,296), A(:,904), n3(:,1427), t3x128(:,:,904), nhel, den(688))
    call Hcont_QA(nsync, wf8(:,167), wf16(:,296), A(:,905), n3(:,1428), t3x128(:,:,905), nhel, den(689))
    call Hcont_QA(nsync, wf16(:,250), wf8(:,190), A(:,906), n3(:,1429), t3x128(:,:,906), nhel, den(690))
    call Hcont_QA(nsync, wf16(:,251), wf8(:,190), A(:,907), n3(:,1430), t3x128(:,:,907), nhel, den(691))
    call Hcont_QA(nsync, wf8(:,176), wf16(:,273), A(:,908), n3(:,1431), t3x128(:,:,908), nhel, den(692))
    call Hcont_QA(nsync, wf8(:,176), wf16(:,274), A(:,909), n3(:,1432), t3x128(:,:,909), nhel, den(693))
    call Hcont_QA(nsync, wf8(:,93), wf16(:,298), A(:,910), n3(:,1433), t3x128(:,:,910), nhel, den(695))
    call Hcont_QA(nsync, wf8(:,94), wf16(:,298), A(:,911), n3(:,1434), t3x128(:,:,911), nhel, den(696))
    call Hcont_QA(nsync, wf8(:,93), wf16(:,300), A(:,912), n3(:,1435), t3x128(:,:,912), nhel, den(698))
    call Hcont_QA(nsync, wf8(:,94), wf16(:,300), A(:,913), n3(:,1436), t3x128(:,:,913), nhel, den(699))
    call Hcont_QA(nsync, wf16(:,28), wf8(:,204), A(:,914), n3(:,1437), t3x128(:,:,914), nhel, den(701))
    call Hcont_QA(nsync, wf16(:,29), wf8(:,204), A(:,915), n3(:,1438), t3x128(:,:,915), nhel, den(702))
    call Hcont_QA(nsync, wf8(:,162), wf16(:,283), A(:,916), n3(:,1439), t3x128(:,:,916), nhel, den(703))
    call Hcont_QA(nsync, wf8(:,162), wf16(:,284), A(:,917), n3(:,1440), t3x128(:,:,917), nhel, den(704))
    call Hcont_QA(nsync, wf8(:,164), wf16(:,283), A(:,918), n3(:,1441), t3x128(:,:,918), nhel, den(705))
    call Hcont_QA(nsync, wf8(:,164), wf16(:,284), A(:,919), n3(:,1442), t3x128(:,:,919), nhel, den(706))
    call Hcont_QA(nsync, wf16(:,268), wf8(:,184), A(:,920), n3(:,1443), t3x128(:,:,920), nhel, den(707))
    call Hcont_QA(nsync, wf16(:,269), wf8(:,184), A(:,921), n3(:,1444), t3x128(:,:,921), nhel, den(708))
    call Hcont_QA(nsync, wf8(:,93), wf16(:,302), A(:,922), n3(:,1445), t3x128(:,:,922), nhel, den(710))
    call Hcont_QA(nsync, wf8(:,94), wf16(:,302), A(:,923), n3(:,1446), t3x128(:,:,923), nhel, den(711))
    call Hcont_QA(nsync, wf8(:,166), wf16(:,304), A(:,924), n3(:,1447), t3x128(:,:,924), nhel, den(713))
    call Hcont_QA(nsync, wf8(:,167), wf16(:,304), A(:,925), n3(:,1448), t3x128(:,:,925), nhel, den(714))
    call Hcont_QA(nsync, wf16(:,19), wf8(:,205), A(:,926), n3(:,1449), t3x128(:,:,926), nhel, den(716))
    call Hcont_QA(nsync, wf16(:,20), wf8(:,205), A(:,927), n3(:,1450), t3x128(:,:,927), nhel, den(717))
    call Hcont_QA(nsync, wf8(:,93), wf16(:,306), A(:,928), n3(:,1451), t3x128(:,:,928), nhel, den(719))
    call Hcont_QA(nsync, wf8(:,94), wf16(:,306), A(:,929), n3(:,1452), t3x128(:,:,929), nhel, den(720))
    call Hcont_VV(nsync, wf16(:,42), wf8(:,206), A(:,930), n3(:,1453), t3x128(:,:,930), nhel, den(721))
    call Hcont_VV(nsync, wf16(:,43), wf8(:,206), A(:,931), n3(:,1454), t3x128(:,:,931), nhel, den(722))
    call Hcont_QA(nsync, wf16(:,250), wf8(:,193), A(:,932), n3(:,1455), t3x128(:,:,932), nhel, den(723))
    call Hcont_QA(nsync, wf16(:,251), wf8(:,193), A(:,933), n3(:,1456), t3x128(:,:,933), nhel, den(724))
    call Hcont_QA(nsync, wf16(:,28), wf8(:,207), A(:,934), n3(:,1457), t3x128(:,:,934), nhel, den(726))
    call Hcont_QA(nsync, wf16(:,29), wf8(:,207), A(:,935), n3(:,1458), t3x128(:,:,935), nhel, den(727))
    call Hcont_VV(nsync, wf16(:,40), wf8(:,206), A(:,936), n3(:,1459), t3x128(:,:,936), nhel, den(728))
    call Hcont_VV(nsync, wf16(:,41), wf8(:,206), A(:,937), n3(:,1460), t3x128(:,:,937), nhel, den(729))
    call Hcont_QA(nsync, wf16(:,268), wf8(:,186), A(:,938), n3(:,1461), t3x128(:,:,938), nhel, den(730))
    call Hcont_QA(nsync, wf16(:,269), wf8(:,186), A(:,939), n3(:,1462), t3x128(:,:,939), nhel, den(731))
    call Hcont_QA(nsync, wf8(:,166), wf16(:,307), A(:,940), n3(:,1463), t3x128(:,:,940), nhel, den(733))
    call Hcont_QA(nsync, wf8(:,167), wf16(:,307), A(:,941), n3(:,1464), t3x128(:,:,941), nhel, den(734))
    call Hcont_VV(nsync, wf16(:,40), wf8(:,208), A(:,942), n3(:,1465), t3x128(:,:,942), nhel, den(735))
    call Hcont_VV(nsync, wf16(:,41), wf8(:,208), A(:,943), n3(:,1466), t3x128(:,:,943), nhel, den(736))
    call Hcont_VV(nsync, wf16(:,42), wf8(:,208), A(:,944), n3(:,1467), t3x128(:,:,944), nhel, den(737))
    call Hcont_VV(nsync, wf16(:,43), wf8(:,208), A(:,945), n3(:,1468), t3x128(:,:,945), nhel, den(738))
    call Hcont_QA(nsync, wf8(:,93), wf16(:,309), A(:,946), n3(:,1469), t3x128(:,:,946), nhel, den(740))
    call Hcont_QA(nsync, wf8(:,94), wf16(:,309), A(:,947), n3(:,1470), t3x128(:,:,947), nhel, den(741))
    call Hcont_QA(nsync, wf8(:,166), wf16(:,311), A(:,948), n3(:,1471), t3x128(:,:,948), nhel, den(743))
    call Hcont_QA(nsync, wf8(:,167), wf16(:,311), A(:,949), n3(:,1472), t3x128(:,:,949), nhel, den(744))
    call Hcont_QA(nsync, wf8(:,93), wf16(:,313), A(:,950), n3(:,1473), t3x128(:,:,950), nhel, den(746))
    call Hcont_QA(nsync, wf8(:,94), wf16(:,313), A(:,951), n3(:,1474), t3x128(:,:,951), nhel, den(747))
    call Hcont_VV(nsync, wf16(:,42), wf8(:,209), A(:,952), n3(:,1475), t3x128(:,:,952), nhel, den(748))
    call Hcont_VV(nsync, wf16(:,43), wf8(:,209), A(:,953), n3(:,1476), t3x128(:,:,953), nhel, den(749))
    call Hcont_QA(nsync, wf8(:,179), wf16(:,273), A(:,954), n3(:,1477), t3x128(:,:,954), nhel, den(750))
    call Hcont_QA(nsync, wf8(:,179), wf16(:,274), A(:,955), n3(:,1478), t3x128(:,:,955), nhel, den(751))
    call Hcont_QA(nsync, wf16(:,33), wf8(:,210), A(:,956), n3(:,1479), t3x128(:,:,956), nhel, den(753))
    call Hcont_QA(nsync, wf16(:,34), wf8(:,210), A(:,957), n3(:,1480), t3x128(:,:,957), nhel, den(754))
    call Hcont_VV(nsync, wf16(:,40), wf8(:,209), A(:,958), n3(:,1481), t3x128(:,:,958), nhel, den(755))
    call Hcont_VV(nsync, wf16(:,41), wf8(:,209), A(:,959), n3(:,1482), t3x128(:,:,959), nhel, den(756))
    call Hcont_QA(nsync, wf8(:,168), wf16(:,283), A(:,960), n3(:,1483), t3x128(:,:,960), nhel, den(757))
    call Hcont_QA(nsync, wf8(:,168), wf16(:,284), A(:,961), n3(:,1484), t3x128(:,:,961), nhel, den(758))
    call Hcont_QA(nsync, wf8(:,166), wf16(:,314), A(:,962), n3(:,1485), t3x128(:,:,962), nhel, den(760))
    call Hcont_QA(nsync, wf8(:,167), wf16(:,314), A(:,963), n3(:,1486), t3x128(:,:,963), nhel, den(761))
    call Hcont_QA(nsync, wf16(:,36), wf8(:,211), A(:,964), n3(:,1487), t3x128(:,:,964), nhel, den(763))
    call Hcont_QA(nsync, wf16(:,37), wf8(:,211), A(:,965), n3(:,1488), t3x128(:,:,965), nhel, den(764))
    call Hcont_VV(nsync, wf16(:,40), wf8(:,212), A(:,966), n3(:,1489), t3x128(:,:,966), nhel, den(765))
    call Hcont_VV(nsync, wf16(:,41), wf8(:,212), A(:,967), n3(:,1490), t3x128(:,:,967), nhel, den(766))
    call Hcont_VV(nsync, wf16(:,42), wf8(:,212), A(:,968), n3(:,1491), t3x128(:,:,968), nhel, den(767))
    call Hcont_VV(nsync, wf16(:,43), wf8(:,212), A(:,969), n3(:,1492), t3x128(:,:,969), nhel, den(768))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(6), M2(11) ! M1helarray(11,128)
  integer :: empty(0), i

  M1(1)%j = (-A(j,1)%j+A(j,2)%j-A(j,7)%j+A(j,8)%j-A(j,33)%j-A(j,35)%j-A(j,43)%j-A(j,77)%j-A(j,81)%j-A(j,87)%j-A(j,101)%j &
       -A(j,105)%j)*f(1)+(A(j,4)%j-A(j,5)%j+A(j,10)%j-A(j,11)%j+A(j,34)%j+A(j,36)%j+A(j,44)%j+A(j,78)%j+A(j,82)%j+A(j,88)%j &
       +A(j,102)%j+A(j,106)%j)*f(2)+CI*(-A(j,37)%j-A(j,39)%j-A(j,69)%j-A(j,71)%j-A(j,79)%j-A(j,107)%j)*f(3)+CI*(A(j,38)%j &
       +A(j,40)%j+A(j,70)%j+A(j,72)%j+A(j,80)%j+A(j,108)%j)*f(4)
  M1(2)%j = (-A(j,2)%j+A(j,3)%j-A(j,8)%j+A(j,9)%j-A(j,29)%j-A(j,31)%j-A(j,41)%j-A(j,55)%j+A(j,93)%j+A(j,97)%j+A(j,101)%j &
       +A(j,105)%j)*f(1)+(A(j,5)%j-A(j,6)%j+A(j,11)%j-A(j,12)%j+A(j,30)%j+A(j,32)%j+A(j,42)%j+A(j,56)%j-A(j,94)%j-A(j,98)%j &
       -A(j,102)%j-A(j,106)%j)*f(2)+CI*(A(j,37)%j+A(j,39)%j-A(j,49)%j-A(j,51)%j-A(j,95)%j+A(j,107)%j)*f(3)+CI*(-A(j,38)%j &
       -A(j,40)%j+A(j,50)%j+A(j,52)%j+A(j,96)%j-A(j,108)%j)*f(4)
  M1(3)%j = (A(j,1)%j-A(j,3)%j+A(j,7)%j-A(j,9)%j-A(j,57)%j-A(j,59)%j-A(j,67)%j+A(j,77)%j+A(j,81)%j-A(j,85)%j-A(j,93)%j &
       -A(j,97)%j)*f(1)+(-A(j,4)%j+A(j,6)%j-A(j,10)%j+A(j,12)%j+A(j,58)%j+A(j,60)%j+A(j,68)%j-A(j,78)%j-A(j,82)%j+A(j,86)%j &
       +A(j,94)%j+A(j,98)%j)*f(2)+CI*(-A(j,61)%j-A(j,63)%j+A(j,69)%j+A(j,71)%j+A(j,79)%j-A(j,99)%j)*f(3)+CI*(A(j,62)%j+A(j,64)%j &
       -A(j,70)%j-A(j,72)%j-A(j,80)%j+A(j,100)%j)*f(4)
  M1(4)%j = (-A(j,2)%j+A(j,3)%j-A(j,8)%j+A(j,9)%j-A(j,13)%j-A(j,15)%j-A(j,27)%j-A(j,65)%j+A(j,93)%j+A(j,97)%j+A(j,101)%j &
       +A(j,105)%j)*f(1)+(A(j,5)%j-A(j,6)%j+A(j,11)%j-A(j,12)%j+A(j,14)%j+A(j,16)%j+A(j,28)%j+A(j,66)%j-A(j,94)%j-A(j,98)%j &
       -A(j,102)%j-A(j,106)%j)*f(2)+CI*(-A(j,21)%j-A(j,23)%j+A(j,61)%j+A(j,63)%j+A(j,99)%j-A(j,103)%j)*f(3)+CI*(A(j,22)%j &
       +A(j,24)%j-A(j,62)%j-A(j,64)%j-A(j,100)%j+A(j,104)%j)*f(4)
  M1(5)%j = (A(j,1)%j-A(j,3)%j+A(j,7)%j-A(j,9)%j-A(j,45)%j-A(j,47)%j-A(j,53)%j+A(j,77)%j+A(j,81)%j-A(j,91)%j-A(j,93)%j &
       -A(j,97)%j)*f(1)+(-A(j,4)%j+A(j,6)%j-A(j,10)%j+A(j,12)%j+A(j,46)%j+A(j,48)%j+A(j,54)%j-A(j,78)%j-A(j,82)%j+A(j,92)%j &
       +A(j,94)%j+A(j,98)%j)*f(2)+CI*(A(j,49)%j+A(j,51)%j-A(j,73)%j-A(j,75)%j-A(j,83)%j+A(j,95)%j)*f(3)+CI*(-A(j,50)%j-A(j,52)%j &
       +A(j,74)%j+A(j,76)%j+A(j,84)%j-A(j,96)%j)*f(4)
  M1(6)%j = (-A(j,1)%j+A(j,2)%j-A(j,7)%j+A(j,8)%j-A(j,17)%j-A(j,19)%j-A(j,25)%j-A(j,77)%j-A(j,81)%j-A(j,89)%j-A(j,101)%j &
       -A(j,105)%j)*f(1)+(A(j,4)%j-A(j,5)%j+A(j,10)%j-A(j,11)%j+A(j,18)%j+A(j,20)%j+A(j,26)%j+A(j,78)%j+A(j,82)%j+A(j,90)%j &
       +A(j,102)%j+A(j,106)%j)*f(2)+CI*(A(j,21)%j+A(j,23)%j+A(j,73)%j+A(j,75)%j+A(j,83)%j+A(j,103)%j)*f(3)+CI*(-A(j,22)%j &
       -A(j,24)%j-A(j,74)%j-A(j,76)%j-A(j,84)%j-A(j,104)%j)*f(4)

  M2( 1)%j = (A(j,390)%j-A(j,391)%j+A(j,396)%j-A(j,397)%j+A(j,402)%j-A(j,403)%j+A(j,408)%j-A(j,409)%j+A(j,742)%j+A(j,744)%j &
        +A(j,746)%j+A(j,748)%j+A(j,750)%j+A(j,752)%j+A(j,768)%j+A(j,770)%j+A(j,776)%j+A(j,874)%j+A(j,876)%j+A(j,882)%j+A(j,888)%j &
        +A(j,894)%j+A(j,896)%j+A(j,900)%j+A(j,902)%j+A(j,908)%j+A(j,946)%j+A(j,948)%j+A(j,952)%j+A(j,958)%j+A(j,966)%j &
        +A(j,968)%j)*f(5)+((A(j,149)%j+A(j,151)%j+A(j,161)%j+A(j,163)%j)*f(6))/2._/**/REALKIND+(-A(j,393)%j+A(j,394)%j-A(j,399)%j &
        +A(j,400)%j-A(j,405)%j+A(j,406)%j-A(j,411)%j+A(j,412)%j-A(j,743)%j-A(j,745)%j-A(j,747)%j-A(j,749)%j-A(j,751)%j-A(j,753)%j &
        -A(j,769)%j-A(j,771)%j-A(j,777)%j-A(j,875)%j-A(j,877)%j-A(j,883)%j-A(j,889)%j-A(j,895)%j-A(j,897)%j-A(j,901)%j-A(j,903)%j &
        -A(j,909)%j-A(j,947)%j-A(j,949)%j-A(j,953)%j-A(j,959)%j-A(j,967)%j-A(j,969)%j)*f(6)+CI*(A(j,754)%j+A(j,756)%j+A(j,758)%j &
        +A(j,760)%j+A(j,762)%j+A(j,764)%j+A(j,850)%j+A(j,852)%j+A(j,854)%j+A(j,856)%j+A(j,858)%j+A(j,860)%j+A(j,880)%j+A(j,886)%j &
        +A(j,890)%j+A(j,954)%j+A(j,956)%j+A(j,962)%j)*f(7)+(CI*(A(j,110)%j+A(j,112)%j+A(j,117)%j+A(j,119)%j+A(j,133)%j+A(j,135)%j &
        -A(j,141)%j-A(j,143)%j)*f(8))/2._/**/REALKIND+CI*(-A(j,755)%j-A(j,757)%j-A(j,759)%j-A(j,761)%j-A(j,763)%j-A(j,765)%j &
        -A(j,851)%j-A(j,853)%j-A(j,855)%j-A(j,857)%j-A(j,859)%j-A(j,861)%j-A(j,881)%j-A(j,887)%j-A(j,891)%j-A(j,955)%j-A(j,957)%j &
        -A(j,963)%j)*f(8)+(-A(j,193)%j+A(j,194)%j-A(j,205)%j+A(j,206)%j-A(j,291)%j-A(j,295)%j-A(j,297)%j-A(j,300)%j-A(j,362)%j &
        -A(j,444)%j-A(j,524)%j-A(j,548)%j-A(j,574)%j-A(j,576)%j-A(j,584)%j-A(j,594)%j-A(j,596)%j-A(j,618)%j-A(j,642)%j &
        -A(j,652)%j)*f(9)+(A(j,196)%j-A(j,197)%j+A(j,208)%j-A(j,209)%j+A(j,292)%j+A(j,296)%j+A(j,298)%j+A(j,301)%j+A(j,363)%j &
        +A(j,445)%j+A(j,525)%j+A(j,549)%j+A(j,575)%j+A(j,577)%j+A(j,585)%j+A(j,595)%j+A(j,597)%j+A(j,619)%j+A(j,643)%j &
        +A(j,653)%j)*f(10)+CI*(-A(j,284)%j-A(j,340)%j-A(j,352)%j-A(j,462)%j-A(j,518)%j-A(j,522)%j-A(j,578)%j-A(j,580)%j-A(j,586)%j &
        -A(j,626)%j-A(j,628)%j-A(j,644)%j)*f(11)+CI*(A(j,285)%j+A(j,341)%j+A(j,353)%j+A(j,463)%j+A(j,519)%j+A(j,523)%j+A(j,579)%j &
        +A(j,581)%j+A(j,587)%j+A(j,627)%j+A(j,629)%j+A(j,645)%j)*f(12)+(-A(j,199)%j+A(j,200)%j-A(j,211)%j+A(j,212)%j-A(j,280)%j &
        -A(j,282)%j-A(j,528)%j-A(j,536)%j-A(j,552)%j-A(j,592)%j-A(j,622)%j-A(j,646)%j)*f(13)+(A(j,202)%j-A(j,203)%j+A(j,214)%j &
        -A(j,215)%j+A(j,281)%j+A(j,283)%j+A(j,529)%j+A(j,537)%j+A(j,553)%j+A(j,593)%j+A(j,623)%j+A(j,647)%j)*f(14)+CI*(-A(j,287)%j &
        -A(j,343)%j-A(j,520)%j-A(j,550)%j-A(j,588)%j-A(j,624)%j)*f(15)+CI*(A(j,288)%j+A(j,344)%j+A(j,521)%j+A(j,551)%j+A(j,589)%j &
        +A(j,625)%j)*f(16)+(-A(j,350)%j-A(j,354)%j-A(j,382)%j-A(j,386)%j-A(j,456)%j-A(j,460)%j-A(j,482)%j-A(j,486)%j)*f(17) &
        +(A(j,351)%j+A(j,355)%j+A(j,383)%j+A(j,387)%j+A(j,457)%j+A(j,461)%j+A(j,483)%j+A(j,487)%j)*f(18)+CI*(-A(j,306)%j &
        -A(j,308)%j-A(j,388)%j-A(j,474)%j-A(j,476)%j-A(j,484)%j)*f(19)+CI*(A(j,307)%j+A(j,309)%j+A(j,389)%j+A(j,475)%j+A(j,477)%j &
        +A(j,485)%j)*f(20)+(A(j,169)%j+A(j,170)%j+A(j,181)%j+A(j,182)%j)*f(21)+2*(-A(j,171)%j-A(j,183)%j)*f(21)+(-A(j,175)%j &
        -A(j,176)%j-A(j,187)%j-A(j,188)%j)*f(22)+2*(A(j,177)%j+A(j,189)%j)*f(22)+CI*(A(j,286)%j+A(j,293)%j-A(j,304)%j+A(j,342)%j &
        +A(j,359)%j-A(j,364)%j+A(j,448)%j+A(j,464)%j)*f(23)+(-A(j,121)%j+A(j,122)%j-A(j,124)%j+A(j,125)%j+A(j,127)%j-A(j,129)%j &
        -A(j,131)%j+A(j,132)%j+A(j,217)%j-A(j,218)%j-A(j,219)%j-A(j,222)%j-A(j,223)%j-A(j,224)%j+A(j,227)%j+A(j,228)%j+A(j,229)%j &
        +A(j,231)%j-A(j,294)%j-A(j,299)%j-A(j,449)%j)*f(24)+(19*(-A(j,172)%j-A(j,173)%j-A(j,184)%j &
        -A(j,185)%j)*f(25))/2._/**/REALKIND+18*(A(j,174)%j+A(j,186)%j)*f(25)+(19*(A(j,178)%j+A(j,179)%j+A(j,190)%j &
        +A(j,191)%j)*f(26))/2._/**/REALKIND+18*(-A(j,180)%j-A(j,192)%j)*f(26)
  M2( 2)%j = (A(j,391)%j-A(j,392)%j+A(j,397)%j-A(j,398)%j+A(j,403)%j-A(j,404)%j+A(j,409)%j-A(j,410)%j+A(j,730)%j+A(j,732)%j &
        +A(j,734)%j+A(j,736)%j+A(j,738)%j+A(j,740)%j+A(j,766)%j+A(j,772)%j+A(j,774)%j+A(j,804)%j+A(j,806)%j+A(j,812)%j-A(j,922)%j &
        -A(j,924)%j-A(j,930)%j-A(j,936)%j-A(j,942)%j-A(j,944)%j-A(j,946)%j-A(j,948)%j-A(j,952)%j-A(j,958)%j-A(j,966)%j &
        -A(j,968)%j)*f(5)+((A(j,150)%j+A(j,152)%j+A(j,153)%j+A(j,155)%j)*f(6))/2._/**/REALKIND+(-A(j,394)%j+A(j,395)%j-A(j,400)%j &
        +A(j,401)%j-A(j,406)%j+A(j,407)%j-A(j,412)%j+A(j,413)%j-A(j,731)%j-A(j,733)%j-A(j,735)%j-A(j,737)%j-A(j,739)%j-A(j,741)%j &
        -A(j,767)%j-A(j,773)%j-A(j,775)%j-A(j,805)%j-A(j,807)%j-A(j,813)%j+A(j,923)%j+A(j,925)%j+A(j,931)%j+A(j,937)%j+A(j,943)%j &
        +A(j,945)%j+A(j,947)%j+A(j,949)%j+A(j,953)%j+A(j,959)%j+A(j,967)%j+A(j,969)%j)*f(6)+CI*(-A(j,754)%j-A(j,756)%j-A(j,758)%j &
        -A(j,760)%j-A(j,762)%j-A(j,764)%j+A(j,790)%j+A(j,792)%j+A(j,794)%j+A(j,796)%j+A(j,798)%j+A(j,800)%j+A(j,928)%j+A(j,934)%j &
        +A(j,938)%j-A(j,954)%j-A(j,956)%j-A(j,962)%j)*f(7)+(CI*(A(j,114)%j+A(j,116)%j+A(j,118)%j+A(j,120)%j-A(j,133)%j-A(j,135)%j &
        -A(j,137)%j-A(j,139)%j)*f(8))/2._/**/REALKIND+CI*(A(j,755)%j+A(j,757)%j+A(j,759)%j+A(j,761)%j+A(j,763)%j+A(j,765)%j &
        -A(j,791)%j-A(j,793)%j-A(j,795)%j-A(j,797)%j-A(j,799)%j-A(j,801)%j-A(j,929)%j-A(j,935)%j-A(j,939)%j+A(j,955)%j+A(j,957)%j &
        +A(j,963)%j)*f(8)+(-A(j,194)%j+A(j,195)%j-A(j,206)%j+A(j,207)%j-A(j,275)%j-A(j,277)%j-A(j,289)%j-A(j,302)%j-A(j,321)%j &
        -A(j,419)%j+A(j,540)%j+A(j,548)%j-A(j,570)%j-A(j,572)%j-A(j,582)%j-A(j,598)%j-A(j,600)%j+A(j,634)%j+A(j,642)%j &
        -A(j,664)%j)*f(9)+(A(j,197)%j-A(j,198)%j+A(j,209)%j-A(j,210)%j+A(j,276)%j+A(j,278)%j+A(j,290)%j+A(j,303)%j+A(j,322)%j &
        +A(j,420)%j-A(j,541)%j-A(j,549)%j+A(j,571)%j+A(j,573)%j+A(j,583)%j+A(j,599)%j+A(j,601)%j-A(j,635)%j-A(j,643)%j &
        +A(j,665)%j)*f(10)+CI*(A(j,284)%j-A(j,314)%j-A(j,374)%j+A(j,462)%j-A(j,506)%j-A(j,538)%j+A(j,578)%j+A(j,580)%j+A(j,586)%j &
        +A(j,644)%j-A(j,658)%j-A(j,660)%j)*f(11)+CI*(-A(j,285)%j+A(j,315)%j+A(j,375)%j-A(j,463)%j+A(j,507)%j+A(j,539)%j-A(j,579)%j &
        -A(j,581)%j-A(j,587)%j-A(j,645)%j+A(j,659)%j+A(j,661)%j)*f(12)+(-A(j,200)%j+A(j,201)%j-A(j,212)%j+A(j,213)%j-A(j,271)%j &
        -A(j,273)%j-A(j,512)%j+A(j,544)%j+A(j,552)%j-A(j,590)%j+A(j,638)%j+A(j,646)%j)*f(13)+(A(j,203)%j-A(j,204)%j+A(j,215)%j &
        -A(j,216)%j+A(j,272)%j+A(j,274)%j+A(j,513)%j-A(j,545)%j-A(j,553)%j+A(j,591)%j-A(j,639)%j-A(j,647)%j)*f(14)+CI*(A(j,287)%j &
        -A(j,317)%j-A(j,508)%j+A(j,550)%j+A(j,588)%j-A(j,640)%j)*f(15)+CI*(-A(j,288)%j+A(j,318)%j+A(j,509)%j-A(j,551)%j-A(j,589)%j &
        +A(j,641)%j)*f(16)+(A(j,372)%j+A(j,376)%j+A(j,382)%j+A(j,386)%j+A(j,456)%j+A(j,460)%j+A(j,466)%j+A(j,470)%j)*f(17)+( &
        -A(j,373)%j-A(j,377)%j-A(j,383)%j-A(j,387)%j-A(j,457)%j-A(j,461)%j-A(j,467)%j-A(j,471)%j)*f(18)+CI*(A(j,306)%j+A(j,308)%j &
        +A(j,388)%j-A(j,425)%j-A(j,427)%j-A(j,468)%j)*f(19)+CI*(-A(j,307)%j-A(j,309)%j-A(j,389)%j+A(j,426)%j+A(j,428)%j &
        +A(j,469)%j)*f(20)+2*(-A(j,169)%j-A(j,181)%j)*f(21)+(A(j,170)%j+A(j,171)%j+A(j,182)%j+A(j,183)%j)*f(21)+2*(A(j,175)%j &
        +A(j,187)%j)*f(22)+(-A(j,176)%j-A(j,177)%j-A(j,188)%j-A(j,189)%j)*f(22)+CI*(-A(j,286)%j-A(j,293)%j+A(j,304)%j+A(j,316)%j &
        -A(j,323)%j+A(j,381)%j-A(j,423)%j-A(j,464)%j)*f(23)+(-A(j,122)%j+A(j,123)%j+A(j,124)%j-A(j,126)%j-A(j,127)%j+A(j,128)%j &
        -A(j,130)%j+A(j,131)%j+A(j,220)%j+A(j,221)%j+A(j,222)%j+A(j,223)%j+A(j,224)%j-A(j,225)%j-A(j,226)%j-A(j,227)%j-A(j,229)%j &
        +A(j,230)%j-A(j,279)%j-A(j,305)%j-A(j,424)%j)*f(24)+18*(A(j,172)%j+A(j,184)%j)*f(25)+(19*(-A(j,173)%j-A(j,174)%j &
        -A(j,185)%j-A(j,186)%j)*f(25))/2._/**/REALKIND+18*(-A(j,178)%j-A(j,190)%j)*f(26)+(19*(A(j,179)%j+A(j,180)%j+A(j,191)%j &
        +A(j,192)%j)*f(26))/2._/**/REALKIND
  M2( 3)%j = (-A(j,390)%j+A(j,392)%j-A(j,396)%j+A(j,398)%j-A(j,402)%j+A(j,404)%j-A(j,408)%j+A(j,410)%j+A(j,814)%j+A(j,816)%j &
        +A(j,818)%j+A(j,820)%j+A(j,822)%j+A(j,824)%j+A(j,840)%j+A(j,842)%j+A(j,848)%j-A(j,874)%j-A(j,876)%j-A(j,882)%j-A(j,888)%j &
        -A(j,894)%j-A(j,896)%j+A(j,898)%j+A(j,904)%j+A(j,906)%j+A(j,922)%j+A(j,924)%j+A(j,930)%j+A(j,936)%j+A(j,942)%j &
        +A(j,944)%j)*f(5)+((A(j,157)%j+A(j,159)%j+A(j,162)%j+A(j,164)%j)*f(6))/2._/**/REALKIND+(A(j,393)%j-A(j,395)%j+A(j,399)%j &
        -A(j,401)%j+A(j,405)%j-A(j,407)%j+A(j,411)%j-A(j,413)%j-A(j,815)%j-A(j,817)%j-A(j,819)%j-A(j,821)%j-A(j,823)%j-A(j,825)%j &
        -A(j,841)%j-A(j,843)%j-A(j,849)%j+A(j,875)%j+A(j,877)%j+A(j,883)%j+A(j,889)%j+A(j,895)%j+A(j,897)%j-A(j,899)%j-A(j,905)%j &
        -A(j,907)%j-A(j,923)%j-A(j,925)%j-A(j,931)%j-A(j,937)%j-A(j,943)%j-A(j,945)%j)*f(6)+CI*(A(j,826)%j+A(j,828)%j+A(j,830)%j &
        +A(j,832)%j+A(j,834)%j+A(j,836)%j-A(j,850)%j-A(j,852)%j-A(j,854)%j-A(j,856)%j-A(j,858)%j-A(j,860)%j-A(j,880)%j-A(j,886)%j &
        -A(j,890)%j+A(j,926)%j+A(j,932)%j+A(j,940)%j)*f(7)+(CI*(-A(j,110)%j-A(j,112)%j+A(j,113)%j+A(j,115)%j+A(j,137)%j+A(j,139)%j &
        -A(j,142)%j-A(j,144)%j)*f(8))/2._/**/REALKIND+CI*(-A(j,827)%j-A(j,829)%j-A(j,831)%j-A(j,833)%j-A(j,835)%j-A(j,837)%j &
        +A(j,851)%j+A(j,853)%j+A(j,855)%j+A(j,857)%j+A(j,859)%j+A(j,861)%j+A(j,881)%j+A(j,887)%j+A(j,891)%j-A(j,927)%j-A(j,933)%j &
        -A(j,941)%j)*f(8)+(A(j,193)%j-A(j,195)%j+A(j,205)%j-A(j,207)%j-A(j,336)%j-A(j,360)%j-A(j,429)%j-A(j,431)%j-A(j,434)%j &
        -A(j,446)%j+A(j,524)%j-A(j,540)%j-A(j,558)%j-A(j,560)%j-A(j,568)%j-A(j,610)%j-A(j,612)%j+A(j,618)%j-A(j,634)%j &
        -A(j,650)%j)*f(9)+(-A(j,196)%j+A(j,198)%j-A(j,208)%j+A(j,210)%j+A(j,337)%j+A(j,361)%j+A(j,430)%j+A(j,432)%j+A(j,435)%j &
        +A(j,447)%j-A(j,525)%j+A(j,541)%j+A(j,559)%j+A(j,561)%j+A(j,569)%j+A(j,611)%j+A(j,613)%j-A(j,619)%j+A(j,635)%j &
        +A(j,651)%j)*f(10)+CI*(-A(j,329)%j+A(j,340)%j+A(j,352)%j-A(j,378)%j+A(j,518)%j+A(j,522)%j-A(j,562)%j-A(j,564)%j-A(j,602)%j &
        +A(j,626)%j+A(j,628)%j-A(j,636)%j)*f(11)+CI*(A(j,330)%j-A(j,341)%j-A(j,353)%j+A(j,379)%j-A(j,519)%j-A(j,523)%j+A(j,563)%j &
        +A(j,565)%j+A(j,603)%j-A(j,627)%j-A(j,629)%j+A(j,637)%j)*f(12)+(A(j,199)%j-A(j,201)%j+A(j,211)%j-A(j,213)%j-A(j,325)%j &
        -A(j,327)%j+A(j,528)%j-A(j,534)%j-A(j,544)%j-A(j,608)%j+A(j,622)%j-A(j,638)%j)*f(13)+(-A(j,202)%j+A(j,204)%j-A(j,214)%j &
        +A(j,216)%j+A(j,326)%j+A(j,328)%j-A(j,529)%j+A(j,535)%j+A(j,545)%j+A(j,609)%j-A(j,623)%j+A(j,639)%j)*f(14)+CI*(-A(j,332)%j &
        +A(j,343)%j+A(j,520)%j-A(j,542)%j-A(j,604)%j+A(j,624)%j)*f(15)+CI*(A(j,333)%j-A(j,344)%j-A(j,521)%j+A(j,543)%j+A(j,605)%j &
        -A(j,625)%j)*f(16)+(A(j,350)%j+A(j,354)%j-A(j,372)%j-A(j,376)%j-A(j,466)%j-A(j,470)%j+A(j,482)%j+A(j,486)%j)*f(17)+( &
        -A(j,351)%j-A(j,355)%j+A(j,373)%j+A(j,377)%j+A(j,467)%j+A(j,471)%j-A(j,483)%j-A(j,487)%j)*f(18)+CI*(-A(j,440)%j-A(j,442)%j &
        -A(j,472)%j+A(j,474)%j+A(j,476)%j+A(j,484)%j)*f(19)+CI*(A(j,441)%j+A(j,443)%j+A(j,473)%j-A(j,475)%j-A(j,477)%j &
        -A(j,485)%j)*f(20)+2*(-A(j,170)%j-A(j,182)%j)*f(21)+(A(j,169)%j+A(j,171)%j+A(j,181)%j+A(j,183)%j)*f(21)+2*(A(j,176)%j &
        +A(j,188)%j)*f(22)+(-A(j,175)%j-A(j,177)%j-A(j,187)%j-A(j,189)%j)*f(22)+CI*(A(j,331)%j-A(j,338)%j-A(j,342)%j-A(j,359)%j &
        +A(j,364)%j+A(j,380)%j-A(j,438)%j-A(j,448)%j)*f(23)+(A(j,121)%j-A(j,123)%j-A(j,125)%j+A(j,126)%j-A(j,128)%j+A(j,129)%j &
        +A(j,130)%j-A(j,132)%j-A(j,217)%j+A(j,218)%j+A(j,219)%j-A(j,220)%j-A(j,221)%j+A(j,225)%j+A(j,226)%j-A(j,228)%j-A(j,230)%j &
        -A(j,231)%j-A(j,339)%j-A(j,365)%j-A(j,433)%j)*f(24)+18*(A(j,173)%j+A(j,185)%j)*f(25)+(19*(-A(j,172)%j-A(j,174)%j &
        -A(j,184)%j-A(j,186)%j)*f(25))/2._/**/REALKIND+18*(-A(j,179)%j-A(j,191)%j)*f(26)+(19*(A(j,178)%j+A(j,180)%j+A(j,190)%j &
        +A(j,192)%j)*f(26))/2._/**/REALKIND
  M2( 4)%j = (A(j,391)%j-A(j,392)%j+A(j,397)%j-A(j,398)%j+A(j,403)%j-A(j,404)%j+A(j,409)%j-A(j,410)%j+A(j,682)%j+A(j,684)%j &
        +A(j,686)%j+A(j,688)%j+A(j,690)%j+A(j,692)%j+A(j,720)%j+A(j,722)%j+A(j,728)%j+A(j,838)%j+A(j,844)%j+A(j,846)%j-A(j,922)%j &
        -A(j,924)%j-A(j,930)%j-A(j,936)%j-A(j,942)%j-A(j,944)%j-A(j,946)%j-A(j,948)%j-A(j,952)%j-A(j,958)%j-A(j,966)%j &
        -A(j,968)%j)*f(5)+((A(j,145)%j+A(j,147)%j+A(j,158)%j+A(j,160)%j)*f(6))/2._/**/REALKIND+(-A(j,394)%j+A(j,395)%j-A(j,400)%j &
        +A(j,401)%j-A(j,406)%j+A(j,407)%j-A(j,412)%j+A(j,413)%j-A(j,683)%j-A(j,685)%j-A(j,687)%j-A(j,689)%j-A(j,691)%j-A(j,693)%j &
        -A(j,721)%j-A(j,723)%j-A(j,729)%j-A(j,839)%j-A(j,845)%j-A(j,847)%j+A(j,923)%j+A(j,925)%j+A(j,931)%j+A(j,937)%j+A(j,943)%j &
        +A(j,945)%j+A(j,947)%j+A(j,949)%j+A(j,953)%j+A(j,959)%j+A(j,967)%j+A(j,969)%j)*f(6)+CI*(A(j,706)%j+A(j,708)%j+A(j,710)%j &
        +A(j,712)%j+A(j,714)%j+A(j,716)%j-A(j,826)%j-A(j,828)%j-A(j,830)%j-A(j,832)%j-A(j,834)%j-A(j,836)%j-A(j,926)%j-A(j,932)%j &
        -A(j,940)%j+A(j,950)%j+A(j,960)%j+A(j,964)%j)*f(7)+(CI*(-A(j,113)%j-A(j,115)%j-A(j,117)%j-A(j,119)%j+A(j,134)%j+A(j,136)%j &
        +A(j,138)%j+A(j,140)%j)*f(8))/2._/**/REALKIND+CI*(-A(j,707)%j-A(j,709)%j-A(j,711)%j-A(j,713)%j-A(j,715)%j-A(j,717)%j &
        +A(j,827)%j+A(j,829)%j+A(j,831)%j+A(j,833)%j+A(j,835)%j+A(j,837)%j+A(j,927)%j+A(j,933)%j+A(j,941)%j-A(j,951)%j-A(j,961)%j &
        -A(j,965)%j)*f(8)+(-A(j,194)%j+A(j,195)%j-A(j,206)%j+A(j,207)%j-A(j,236)%j-A(j,238)%j-A(j,252)%j-A(j,261)%j-A(j,334)%j &
        -A(j,436)%j-A(j,502)%j-A(j,504)%j+A(j,540)%j+A(j,548)%j-A(j,566)%j+A(j,634)%j+A(j,642)%j-A(j,666)%j-A(j,668)%j &
        -A(j,680)%j)*f(9)+(A(j,197)%j-A(j,198)%j+A(j,209)%j-A(j,210)%j+A(j,237)%j+A(j,239)%j+A(j,253)%j+A(j,262)%j+A(j,335)%j &
        +A(j,437)%j+A(j,503)%j+A(j,505)%j-A(j,541)%j-A(j,549)%j+A(j,567)%j-A(j,635)%j-A(j,643)%j+A(j,667)%j+A(j,669)%j &
        +A(j,681)%j)*f(10)+CI*(-A(j,245)%j+A(j,329)%j+A(j,378)%j-A(j,458)%j-A(j,490)%j-A(j,546)%j+A(j,562)%j+A(j,564)%j+A(j,602)%j &
        +A(j,636)%j-A(j,674)%j-A(j,676)%j)*f(11)+CI*(A(j,246)%j-A(j,330)%j-A(j,379)%j+A(j,459)%j+A(j,491)%j+A(j,547)%j-A(j,563)%j &
        -A(j,565)%j-A(j,603)%j-A(j,637)%j+A(j,675)%j+A(j,677)%j)*f(12)+(-A(j,200)%j+A(j,201)%j-A(j,212)%j+A(j,213)%j-A(j,232)%j &
        -A(j,234)%j-A(j,496)%j+A(j,544)%j+A(j,552)%j-A(j,606)%j+A(j,638)%j+A(j,646)%j)*f(13)+(A(j,203)%j-A(j,204)%j+A(j,215)%j &
        -A(j,216)%j+A(j,233)%j+A(j,235)%j+A(j,497)%j-A(j,545)%j-A(j,553)%j+A(j,607)%j-A(j,639)%j-A(j,647)%j)*f(14)+CI*(-A(j,248)%j &
        +A(j,332)%j-A(j,492)%j+A(j,542)%j+A(j,604)%j-A(j,648)%j)*f(15)+CI*(A(j,249)%j-A(j,333)%j+A(j,493)%j-A(j,543)%j-A(j,605)%j &
        +A(j,649)%j)*f(16)+(A(j,372)%j+A(j,376)%j+A(j,382)%j+A(j,386)%j+A(j,456)%j+A(j,460)%j+A(j,466)%j+A(j,470)%j)*f(17)+( &
        -A(j,373)%j-A(j,377)%j-A(j,383)%j-A(j,387)%j-A(j,457)%j-A(j,461)%j-A(j,467)%j-A(j,471)%j)*f(18)+CI*(-A(j,267)%j-A(j,269)%j &
        -A(j,384)%j+A(j,440)%j+A(j,442)%j+A(j,472)%j)*f(19)+CI*(A(j,268)%j+A(j,270)%j+A(j,385)%j-A(j,441)%j-A(j,443)%j &
        -A(j,473)%j)*f(20)+2*(-A(j,169)%j-A(j,181)%j)*f(21)+(A(j,170)%j+A(j,171)%j+A(j,182)%j+A(j,183)%j)*f(21)+2*(A(j,175)%j &
        +A(j,187)%j)*f(22)+(-A(j,176)%j-A(j,177)%j-A(j,188)%j-A(j,189)%j)*f(22)+CI*(A(j,247)%j+A(j,254)%j-A(j,265)%j-A(j,331)%j &
        +A(j,338)%j-A(j,380)%j+A(j,438)%j+A(j,465)%j)*f(23)+(-A(j,122)%j+A(j,123)%j+A(j,124)%j-A(j,126)%j-A(j,127)%j+A(j,128)%j &
        -A(j,130)%j+A(j,131)%j+A(j,220)%j+A(j,221)%j+A(j,222)%j+A(j,223)%j+A(j,224)%j-A(j,225)%j-A(j,226)%j-A(j,227)%j-A(j,229)%j &
        +A(j,230)%j-A(j,240)%j-A(j,266)%j-A(j,439)%j)*f(24)+18*(A(j,172)%j+A(j,184)%j)*f(25)+(19*(-A(j,173)%j-A(j,174)%j &
        -A(j,185)%j-A(j,186)%j)*f(25))/2._/**/REALKIND+18*(-A(j,178)%j-A(j,190)%j)*f(26)+(19*(A(j,179)%j+A(j,180)%j+A(j,191)%j &
        +A(j,192)%j)*f(26))/2._/**/REALKIND
  M2( 5)%j = (-A(j,390)%j+A(j,392)%j-A(j,396)%j+A(j,398)%j-A(j,402)%j+A(j,404)%j-A(j,408)%j+A(j,410)%j+A(j,778)%j+A(j,780)%j &
        +A(j,782)%j+A(j,784)%j+A(j,786)%j+A(j,788)%j+A(j,802)%j+A(j,808)%j+A(j,810)%j-A(j,874)%j-A(j,876)%j-A(j,882)%j-A(j,888)%j &
        -A(j,894)%j-A(j,896)%j+A(j,912)%j+A(j,914)%j+A(j,920)%j+A(j,922)%j+A(j,924)%j+A(j,930)%j+A(j,936)%j+A(j,942)%j &
        +A(j,944)%j)*f(5)+((A(j,154)%j+A(j,156)%j+A(j,165)%j+A(j,167)%j)*f(6))/2._/**/REALKIND+(A(j,393)%j-A(j,395)%j+A(j,399)%j &
        -A(j,401)%j+A(j,405)%j-A(j,407)%j+A(j,411)%j-A(j,413)%j-A(j,779)%j-A(j,781)%j-A(j,783)%j-A(j,785)%j-A(j,787)%j-A(j,789)%j &
        -A(j,803)%j-A(j,809)%j-A(j,811)%j+A(j,875)%j+A(j,877)%j+A(j,883)%j+A(j,889)%j+A(j,895)%j+A(j,897)%j-A(j,913)%j-A(j,915)%j &
        -A(j,921)%j-A(j,923)%j-A(j,925)%j-A(j,931)%j-A(j,937)%j-A(j,943)%j-A(j,945)%j)*f(6)+CI*(-A(j,790)%j-A(j,792)%j-A(j,794)%j &
        -A(j,796)%j-A(j,798)%j-A(j,800)%j+A(j,862)%j+A(j,864)%j+A(j,866)%j+A(j,868)%j+A(j,870)%j+A(j,872)%j+A(j,878)%j+A(j,884)%j &
        +A(j,892)%j-A(j,928)%j-A(j,934)%j-A(j,938)%j)*f(7)+(CI*(A(j,109)%j+A(j,111)%j-A(j,114)%j-A(j,116)%j-A(j,138)%j-A(j,140)%j &
        +A(j,141)%j+A(j,143)%j)*f(8))/2._/**/REALKIND+CI*(A(j,791)%j+A(j,793)%j+A(j,795)%j+A(j,797)%j+A(j,799)%j+A(j,801)%j &
        -A(j,863)%j-A(j,865)%j-A(j,867)%j-A(j,869)%j-A(j,871)%j-A(j,873)%j-A(j,879)%j-A(j,885)%j-A(j,893)%j+A(j,929)%j+A(j,935)%j &
        +A(j,939)%j)*f(8)+(A(j,193)%j-A(j,195)%j+A(j,205)%j-A(j,207)%j-A(j,319)%j-A(j,368)%j-A(j,414)%j-A(j,416)%j-A(j,421)%j &
        -A(j,450)%j-A(j,514)%j-A(j,516)%j+A(j,524)%j-A(j,540)%j-A(j,556)%j+A(j,618)%j-A(j,634)%j-A(j,654)%j-A(j,656)%j &
        -A(j,662)%j)*f(9)+(-A(j,196)%j+A(j,198)%j-A(j,208)%j+A(j,210)%j+A(j,320)%j+A(j,369)%j+A(j,415)%j+A(j,417)%j+A(j,422)%j &
        +A(j,451)%j+A(j,515)%j+A(j,517)%j-A(j,525)%j+A(j,541)%j+A(j,557)%j-A(j,619)%j+A(j,635)%j+A(j,655)%j+A(j,657)%j &
        +A(j,663)%j)*f(10)+CI*(A(j,314)%j-A(j,345)%j-A(j,356)%j+A(j,374)%j+A(j,506)%j-A(j,530)%j-A(j,532)%j+A(j,538)%j-A(j,614)%j &
        -A(j,620)%j+A(j,658)%j+A(j,660)%j)*f(11)+CI*(-A(j,315)%j+A(j,346)%j+A(j,357)%j-A(j,375)%j-A(j,507)%j+A(j,531)%j+A(j,533)%j &
        -A(j,539)%j+A(j,615)%j+A(j,621)%j-A(j,659)%j-A(j,661)%j)*f(12)+(A(j,199)%j-A(j,201)%j+A(j,211)%j-A(j,213)%j-A(j,310)%j &
        -A(j,312)%j-A(j,510)%j+A(j,528)%j-A(j,544)%j+A(j,622)%j-A(j,632)%j-A(j,638)%j)*f(13)+(-A(j,202)%j+A(j,204)%j-A(j,214)%j &
        +A(j,216)%j+A(j,311)%j+A(j,313)%j+A(j,511)%j-A(j,529)%j+A(j,545)%j-A(j,623)%j+A(j,633)%j+A(j,639)%j)*f(14)+CI*(A(j,317)%j &
        -A(j,348)%j+A(j,508)%j-A(j,526)%j-A(j,616)%j+A(j,640)%j)*f(15)+CI*(-A(j,318)%j+A(j,349)%j-A(j,509)%j+A(j,527)%j+A(j,617)%j &
        -A(j,641)%j)*f(16)+(A(j,350)%j+A(j,354)%j-A(j,372)%j-A(j,376)%j-A(j,466)%j-A(j,470)%j+A(j,482)%j+A(j,486)%j)*f(17)+( &
        -A(j,351)%j-A(j,355)%j+A(j,373)%j+A(j,377)%j+A(j,467)%j+A(j,471)%j-A(j,483)%j-A(j,487)%j)*f(18)+CI*(A(j,425)%j+A(j,427)%j &
        +A(j,468)%j-A(j,478)%j-A(j,480)%j-A(j,488)%j)*f(19)+CI*(-A(j,426)%j-A(j,428)%j-A(j,469)%j+A(j,479)%j+A(j,481)%j &
        +A(j,489)%j)*f(20)+2*(-A(j,170)%j-A(j,182)%j)*f(21)+(A(j,169)%j+A(j,171)%j+A(j,181)%j+A(j,183)%j)*f(21)+2*(A(j,176)%j &
        +A(j,188)%j)*f(22)+(-A(j,175)%j-A(j,177)%j-A(j,187)%j-A(j,189)%j)*f(22)+CI*(-A(j,316)%j+A(j,323)%j+A(j,347)%j+A(j,358)%j &
        -A(j,370)%j-A(j,381)%j+A(j,423)%j+A(j,454)%j)*f(23)+(A(j,121)%j-A(j,123)%j-A(j,125)%j+A(j,126)%j-A(j,128)%j+A(j,129)%j &
        +A(j,130)%j-A(j,132)%j-A(j,217)%j+A(j,218)%j+A(j,219)%j-A(j,220)%j-A(j,221)%j+A(j,225)%j+A(j,226)%j-A(j,228)%j-A(j,230)%j &
        -A(j,231)%j-A(j,324)%j-A(j,371)%j-A(j,418)%j)*f(24)+18*(A(j,173)%j+A(j,185)%j)*f(25)+(19*(-A(j,172)%j-A(j,174)%j &
        -A(j,184)%j-A(j,186)%j)*f(25))/2._/**/REALKIND+18*(-A(j,179)%j-A(j,191)%j)*f(26)+(19*(A(j,178)%j+A(j,180)%j+A(j,190)%j &
        +A(j,192)%j)*f(26))/2._/**/REALKIND
  M2( 6)%j = (A(j,390)%j-A(j,391)%j+A(j,396)%j-A(j,397)%j+A(j,402)%j-A(j,403)%j+A(j,408)%j-A(j,409)%j+A(j,694)%j+A(j,696)%j &
        +A(j,698)%j+A(j,700)%j+A(j,702)%j+A(j,704)%j+A(j,718)%j+A(j,724)%j+A(j,726)%j+A(j,874)%j+A(j,876)%j+A(j,882)%j+A(j,888)%j &
        +A(j,894)%j+A(j,896)%j+A(j,910)%j+A(j,916)%j+A(j,918)%j+A(j,946)%j+A(j,948)%j+A(j,952)%j+A(j,958)%j+A(j,966)%j &
        +A(j,968)%j)*f(5)+((A(j,146)%j+A(j,148)%j+A(j,166)%j+A(j,168)%j)*f(6))/2._/**/REALKIND+(-A(j,393)%j+A(j,394)%j-A(j,399)%j &
        +A(j,400)%j-A(j,405)%j+A(j,406)%j-A(j,411)%j+A(j,412)%j-A(j,695)%j-A(j,697)%j-A(j,699)%j-A(j,701)%j-A(j,703)%j-A(j,705)%j &
        -A(j,719)%j-A(j,725)%j-A(j,727)%j-A(j,875)%j-A(j,877)%j-A(j,883)%j-A(j,889)%j-A(j,895)%j-A(j,897)%j-A(j,911)%j-A(j,917)%j &
        -A(j,919)%j-A(j,947)%j-A(j,949)%j-A(j,953)%j-A(j,959)%j-A(j,967)%j-A(j,969)%j)*f(6)+CI*(-A(j,706)%j-A(j,708)%j-A(j,710)%j &
        -A(j,712)%j-A(j,714)%j-A(j,716)%j-A(j,862)%j-A(j,864)%j-A(j,866)%j-A(j,868)%j-A(j,870)%j-A(j,872)%j-A(j,878)%j-A(j,884)%j &
        -A(j,892)%j-A(j,950)%j-A(j,960)%j-A(j,964)%j)*f(7)+(CI*(-A(j,109)%j-A(j,111)%j-A(j,118)%j-A(j,120)%j-A(j,134)%j-A(j,136)%j &
        +A(j,142)%j+A(j,144)%j)*f(8))/2._/**/REALKIND+CI*(A(j,707)%j+A(j,709)%j+A(j,711)%j+A(j,713)%j+A(j,715)%j+A(j,717)%j &
        +A(j,863)%j+A(j,865)%j+A(j,867)%j+A(j,869)%j+A(j,871)%j+A(j,873)%j+A(j,879)%j+A(j,885)%j+A(j,893)%j+A(j,951)%j+A(j,961)%j &
        +A(j,965)%j)*f(8)+(-A(j,193)%j+A(j,194)%j-A(j,205)%j+A(j,206)%j-A(j,250)%j-A(j,256)%j-A(j,258)%j-A(j,263)%j-A(j,366)%j &
        -A(j,452)%j-A(j,498)%j-A(j,500)%j-A(j,524)%j-A(j,548)%j-A(j,554)%j-A(j,618)%j-A(j,642)%j-A(j,670)%j-A(j,672)%j &
        -A(j,678)%j)*f(9)+(A(j,196)%j-A(j,197)%j+A(j,208)%j-A(j,209)%j+A(j,251)%j+A(j,257)%j+A(j,259)%j+A(j,264)%j+A(j,367)%j &
        +A(j,453)%j+A(j,499)%j+A(j,501)%j+A(j,525)%j+A(j,549)%j+A(j,555)%j+A(j,619)%j+A(j,643)%j+A(j,671)%j+A(j,673)%j &
        +A(j,679)%j)*f(10)+CI*(A(j,245)%j+A(j,345)%j+A(j,356)%j+A(j,458)%j+A(j,490)%j+A(j,530)%j+A(j,532)%j+A(j,546)%j+A(j,614)%j &
        +A(j,620)%j+A(j,674)%j+A(j,676)%j)*f(11)+CI*(-A(j,246)%j-A(j,346)%j-A(j,357)%j-A(j,459)%j-A(j,491)%j-A(j,531)%j-A(j,533)%j &
        -A(j,547)%j-A(j,615)%j-A(j,621)%j-A(j,675)%j-A(j,677)%j)*f(12)+(-A(j,199)%j+A(j,200)%j-A(j,211)%j+A(j,212)%j-A(j,241)%j &
        -A(j,243)%j-A(j,494)%j-A(j,528)%j-A(j,552)%j-A(j,622)%j-A(j,630)%j-A(j,646)%j)*f(13)+(A(j,202)%j-A(j,203)%j+A(j,214)%j &
        -A(j,215)%j+A(j,242)%j+A(j,244)%j+A(j,495)%j+A(j,529)%j+A(j,553)%j+A(j,623)%j+A(j,631)%j+A(j,647)%j)*f(14)+CI*(A(j,248)%j &
        +A(j,348)%j+A(j,492)%j+A(j,526)%j+A(j,616)%j+A(j,648)%j)*f(15)+CI*(-A(j,249)%j-A(j,349)%j-A(j,493)%j-A(j,527)%j-A(j,617)%j &
        -A(j,649)%j)*f(16)+(-A(j,350)%j-A(j,354)%j-A(j,382)%j-A(j,386)%j-A(j,456)%j-A(j,460)%j-A(j,482)%j-A(j,486)%j)*f(17) &
        +(A(j,351)%j+A(j,355)%j+A(j,383)%j+A(j,387)%j+A(j,457)%j+A(j,461)%j+A(j,483)%j+A(j,487)%j)*f(18)+CI*(A(j,267)%j+A(j,269)%j &
        +A(j,384)%j+A(j,478)%j+A(j,480)%j+A(j,488)%j)*f(19)+CI*(-A(j,268)%j-A(j,270)%j-A(j,385)%j-A(j,479)%j-A(j,481)%j &
        -A(j,489)%j)*f(20)+(A(j,169)%j+A(j,170)%j+A(j,181)%j+A(j,182)%j)*f(21)+2*(-A(j,171)%j-A(j,183)%j)*f(21)+(-A(j,175)%j &
        -A(j,176)%j-A(j,187)%j-A(j,188)%j)*f(22)+2*(A(j,177)%j+A(j,189)%j)*f(22)+CI*(-A(j,247)%j-A(j,254)%j+A(j,265)%j-A(j,347)%j &
        -A(j,358)%j+A(j,370)%j-A(j,454)%j-A(j,465)%j)*f(23)+(-A(j,121)%j+A(j,122)%j-A(j,124)%j+A(j,125)%j+A(j,127)%j-A(j,129)%j &
        -A(j,131)%j+A(j,132)%j+A(j,217)%j-A(j,218)%j-A(j,219)%j-A(j,222)%j-A(j,223)%j-A(j,224)%j+A(j,227)%j+A(j,228)%j+A(j,229)%j &
        +A(j,231)%j-A(j,255)%j-A(j,260)%j-A(j,455)%j)*f(24)+(19*(-A(j,172)%j-A(j,173)%j-A(j,184)%j &
        -A(j,185)%j)*f(25))/2._/**/REALKIND+18*(A(j,174)%j+A(j,186)%j)*f(25)+(19*(A(j,178)%j+A(j,179)%j+A(j,190)%j &
        +A(j,191)%j)*f(26))/2._/**/REALKIND+18*(-A(j,180)%j-A(j,192)%j)*f(26)
  M2( 7)%j = ((-A(j,161)%j-A(j,162)%j-A(j,163)%j-A(j,164)%j-A(j,165)%j-A(j,166)%j-A(j,167)%j-A(j,168)%j)*f(6))/6._/**/REALKIND &
        +(2*(A(j,172)%j+A(j,173)%j+A(j,174)%j+A(j,184)%j+A(j,185)%j+A(j,186)%j)*f(25))/3._/**/REALKIND+(2*(-A(j,178)%j-A(j,179)%j &
        -A(j,180)%j-A(j,190)%j-A(j,191)%j-A(j,192)%j)*f(26))/3._/**/REALKIND
  M2( 8)%j = ((-A(j,153)%j-A(j,154)%j-A(j,155)%j-A(j,156)%j-A(j,157)%j-A(j,158)%j-A(j,159)%j-A(j,160)%j)*f(6))/6._/**/REALKIND &
        +(2*(A(j,172)%j+A(j,173)%j+A(j,174)%j+A(j,184)%j+A(j,185)%j+A(j,186)%j)*f(25))/3._/**/REALKIND+(2*(-A(j,178)%j-A(j,179)%j &
        -A(j,180)%j-A(j,190)%j-A(j,191)%j-A(j,192)%j)*f(26))/3._/**/REALKIND
  M2( 9)%j = ((-A(j,145)%j-A(j,146)%j-A(j,147)%j-A(j,148)%j-A(j,149)%j-A(j,150)%j-A(j,151)%j-A(j,152)%j)*f(6))/6._/**/REALKIND &
        +(2*(A(j,172)%j+A(j,173)%j+A(j,174)%j+A(j,184)%j+A(j,185)%j+A(j,186)%j)*f(25))/3._/**/REALKIND+(2*(-A(j,178)%j-A(j,179)%j &
        -A(j,180)%j-A(j,190)%j-A(j,191)%j-A(j,192)%j)*f(26))/3._/**/REALKIND
  M2(10)%j = (CI*(-A(j,109)%j-A(j,110)%j-A(j,111)%j-A(j,112)%j+A(j,113)%j+A(j,114)%j+A(j,115)%j+A(j,116)%j-A(j,133)%j-A(j,134)%j &
        -A(j,135)%j-A(j,136)%j)*f(8))/6._/**/REALKIND+((A(j,172)%j+A(j,173)%j+A(j,174)%j+A(j,184)%j+A(j,185)%j &
        +A(j,186)%j)*f(25))/3._/**/REALKIND+((-A(j,178)%j-A(j,179)%j-A(j,180)%j-A(j,190)%j-A(j,191)%j &
        -A(j,192)%j)*f(26))/3._/**/REALKIND
  M2(11)%j = (CI*(A(j,109)%j+A(j,110)%j+A(j,111)%j+A(j,112)%j-A(j,113)%j-A(j,114)%j-A(j,115)%j-A(j,116)%j+A(j,133)%j+A(j,134)%j &
        +A(j,135)%j+A(j,136)%j)*f(8))/6._/**/REALKIND+((A(j,172)%j+A(j,173)%j+A(j,174)%j+A(j,184)%j+A(j,185)%j &
        +A(j,186)%j)*f(25))/3._/**/REALKIND+((-A(j,178)%j-A(j,179)%j-A(j,180)%j-A(j,190)%j-A(j,191)%j &
        -A(j,192)%j)*f(26))/3._/**/REALKIND


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppllttj_eexttxggg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(6)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 6
      do j = 1, 6
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppllttj_eexttxggg_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(6), Mct(11)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 6
    do j = 1, 11
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+6*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppllttj_eexttxggg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(6)
  real(REALKIND),    intent(out) :: M2IRadd(29)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 1-1
    colmatpos = 6*k
    do i = 1, 6
      do j = 1, 6
	      M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppllttj_eexttxggg_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(6)
  complex(REALKIND), intent(in)  :: M2(6)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 6
    do j = 1, 6
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppllttj_eexttxggg_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(6)
  type(Hpolcont), intent(out)  :: M0_col(11)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 11 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 6 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+6*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppllttj_eexttxggg_1_/**/REALKIND
