
module ol_vamp_1_pplltt_eexttxddx_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pplltt_eexttxddx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pplltt_eexttxddx_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pplltt_eexttxddx_1_/**/DREALKIND
  use ol_tensor_sum_storage_pplltt_eexttxddx_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pplltt_eexttxddx_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pplltt_eexttxddx_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(64)
  type(Hpolcont), intent(in) :: M(2,64)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)+c(13)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,3,16,4,8],[0,0,0,nMT,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,1),heltab2x64(:,:,1))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(1),n2h32(1))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(33)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,3,16,4,8],[0,0,0,nMT,0],5,1,wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,2),heltab2x64(:,:,2))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(2),n2h32(2))
  Gcoeff(:)%j = (c(15)*M(1,:)%j+c(9)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,3,16,8,4],[0,0,0,nMT,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,3),heltab2x64(:,:,3))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(3),n2h32(3))
  Gcoeff(:)%j = (c(35)*M(1,:)%j+c(29)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,3,16,8,4],[0,0,0,nMT,0],5,1,wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,4),heltab2x64(:,:,4))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(4),n2h32(4))
  Gcoeff(:)%j = (c(22)*M(1,:)%j-c(24)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,8,3,4,16],[0,nMT,nMT,0,0],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,5),heltab2x64(:,:,5))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(33)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,8,3,4,16],[0,nMT,nMT,0,0],5,1,wf4(:,4))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,6),heltab2x64(:,:,6))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)-c(20)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[32,4,3,8,16],[0,nMT,nMT,0,0],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,7),heltab2x64(:,:,7))
  Gcoeff(:)%j = (c(35)*M(1,:)%j+c(29)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[32,4,3,8,16],[0,nMT,nMT,0,0],5,1,wf4(:,4))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,8),heltab2x64(:,:,8))
  call Hloop_AV_Q(ntryL,G1H32(1),wf4(:,1),G1H8(1),m3h4x8(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(1),35,0,G2H8(1),n2h8(1))
  call Hloop_AZ_Q(ntryL,G1H32(2),wf4(:,4),G1H8(1),ngZd,m3h4x8(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G1H8(1),35,0,G2H8(2),n2h8(2))
  call Hloop_AV_Q(ntryL,G1H32(3),wf4(:,1),G1H8(1),m3h4x8(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G1H8(1),35,0,G2H8(3),n2h8(3))
  call Hloop_AZ_Q(ntryL,G1H32(4),wf4(:,4),G1H8(1),ngZd,m3h4x8(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G1H8(1),35,0,G2H8(4),n2h8(4))
  call Hloop_VA_Q(ntryL,G0H32(1),ex4(:),G0H16(1),m3h2x16(:,1),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G0H16(1),40,nMT,G1H16(1),n2h16(1))
  call Hloop_VA_Q(ntryL,G0H32(2),ex4(:),G0H16(1),m3h2x16(:,2),heltab2x32(:,:,6))
  call Hloop_A_Q(ntryL,G0H16(1),40,nMT,G1H16(2),n2h16(2))
  call Hloop_VQ_A(ntryL,G0H32(3),ex3(:),G0H16(1),m3h2x16(:,3),heltab2x32(:,:,7))
  call Hloop_Q_A(ntryL,G0H16(1),36,nMT,G1H16(3),n2h16(3))
  call Hloop_VQ_A(ntryL,G0H32(4),ex3(:),G0H16(1),m3h2x16(:,4),heltab2x32(:,:,8))
  call Hloop_Q_A(ntryL,G0H16(1),36,nMT,G1H16(4),n2h16(4))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(2),[G2H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(4),[G2H8(3)])
  call Hloop_AQ_V(ntryL,G2H8(2),ex5(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_V(ntryL,G2H8(4),ex5(:),G2H4(2),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_AV_Q(ntryL,G1H16(1),wf4(:,1),G1H4(1),m3h4x4(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(3),n2h4(1))
  call Hloop_AZ_Q(ntryL,G1H16(2),wf4(:,4),G1H4(1),ngZu,m3h4x4(:,2),heltab2x16(:,:,2))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(4),n2h4(2))
  call Hloop_QV_A(ntryL,G1H16(3),wf4(:,1),G1H4(1),m3h4x4(:,3),heltab2x16(:,:,3))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(5),n2h4(3))
  call Hloop_QZ_A(ntryL,G1H16(4),wf4(:,4),G1H4(1),ngZu,m3h4x4(:,4),heltab2x16(:,:,4))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(6),n2h4(4))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G2H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G2H4(5)])
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),8,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(2),mass5set(:,1),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(8),4,4)
  call Hloop_AQ_V(ntryL,G2H4(4),ex3(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_V(ntryL,G2H4(6),ex4(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_VQ_A(ntryL,G1H4(1),ex3(:),G1H2(1),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(3),n2h2(1))
call HGT_raise_alpha_OLR(G1H4(2),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(2),ex4(:),G1H2(1),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_VQ_A(ntryL,G1H4(5),ex3(:),G1H2(2),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_Q_A(ntryL,G1H2(2),55,nMT,G2H2(4),n2h2(2))
  call Hloop_VQ_A(ntryL,G1H4(6),ex3(:),G1H2(2),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_Q_A(ntryL,G1H2(2),55,nMT,G2H2(5),n2h2(3))
  call Hloop_VA_Q(ntryL,G1H4(7),ex4(:),G1H2(2),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_A_Q(ntryL,G1H2(2),59,nMT,G2H2(6),n2h2(4))
call HGT_raise_alpha_OLR(G1H4(8),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(8),ex3(:),G1H2(2),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_VA_Q(ntryL,G1H4(11),ex4(:),G1H2(3),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_A_Q(ntryL,G1H2(3),59,nMT,G2H2(7),n2h2(5))
  call Hloop_VA_Q(ntryL,G1H4(12),ex4(:),G1H2(3),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_A_Q(ntryL,G1H2(3),59,nMT,G2H2(8),n2h2(6))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(3),mass5set(:,2),  & 
G1H2(3),G1H2(4),G1H2(5),G1H2(6),G1H2(7),G1H2(8),2)
  call HG1shiftOLR(G1H2(4),16,2)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(4),mass5set(:,2),  & 
G1H2(9),G1H2(10),G1H2(11),G1H2(12),G1H2(13),G1H2(14),2)
  call HG1shiftOLR(G1H2(10),16,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(3),ex4(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(5),ex4(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(6),ex3(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(8),ex3(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hloop_VQ_A(ntryL,G1H2(3),ex5(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(5),n2h1(1))
  call Hloop_VQ_A(ntryL,G1H2(4),ex5(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(6),n2h1(2))
  call Hloop_VQ_A(ntryL,G1H2(8),ex5(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(7),n2h1(3))
  call Hloop_VQ_A(ntryL,G1H2(9),ex5(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(8),n2h1(4))
  call Hloop_VQ_A(ntryL,G1H2(10),ex5(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(9),n2h1(5))
  call Hloop_VQ_A(ntryL,G1H2(14),ex5(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(10),n2h1(6))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(2),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),4)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(3),mass5set(:,2),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),16)
  call Hotf_5pt_reduction_last(G2tensor(8),RedSet_5(4),mass5set(:,2),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),16)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(9)*M(2,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[32,12,3,16],[0,0,0,0],4,2,wf4(:,2),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,9),heltab2x64(:,:,9))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(1),n2h32(5))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,12,3,16],[0,0,0,0],4,2,wf4(:,2),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,10),heltab2x64(:,:,10))
  call Hloop_A_Q(ntryL,G0H32(2),32,0,G1H32(2),n2h32(6))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(9)*M(2,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,11),heltab2x64(:,:,11))
  call Hloop_A_Q(ntryL,G0H32(3),32,0,G1H32(3),n2h32(7))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[32,3,12,16],[0,0,0,0],4,2,wf4(:,4),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,12),heltab2x64(:,:,12))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(4),n2h32(8))
  Gcoeff(:)%j = (c(2)*M(1,:)%j-c(1)*M(2,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[32,3,16,12],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,13),heltab2x64(:,:,13))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(5),n2h32(9))
  Gcoeff(:)%j = (c(6)*M(1,:)%j-c(5)*M(2,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[32,3,16,12],[0,0,0,0],4,2,wf4(:,4),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,14),heltab2x64(:,:,14))
  call Hloop_A_Q(ntryL,G0H32(2),32,0,G1H32(6),n2h32(10))
  Gcoeff(:)%j = (c(21)*M(1,:)%j-c(20)*M(2,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[48,3,4,8],[nMT,nMT,0,nMT],4,2,wf4(:,5),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,1),heltab2x64(:,:,15))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(1),n2h16(5))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[48,3,4,8],[nMT,nMT,0,nMT],4,2,wf4(:,5),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,2),heltab2x64(:,:,16))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(2),n2h16(6))
  Gcoeff(:)%j = (c(21)*M(1,:)%j-c(20)*M(2,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[48,3,8,4],[nMT,nMT,0,nMT],4,2,wf4(:,5),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,3),heltab2x64(:,:,17))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMT,G1H16(3),n2h16(7))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[48,3,8,4],[nMT,nMT,0,nMT],4,2,wf4(:,5),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,4),heltab2x64(:,:,18))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMT,G1H16(4),n2h16(8))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(3)*M(2,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[48,4,3,8],[0,nMT,nMT,0],4,2,wf4(:,5),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(5),m3h4x16(:,5),heltab2x64(:,:,19))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(5)*M(2,:)%j) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[48,4,3,8],[0,nMT,nMT,0],4,2,wf4(:,5),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(6),m3h4x16(:,6),heltab2x64(:,:,20))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)-c(20)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[32,7,8,16],[0,nMT,0,0],4,1,wf8(:,12))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,15),heltab2x64(:,:,21))
  Gcoeff(:)%j = (c(35)*M(1,:)%j+c(29)*M(2,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[32,7,8,16],[0,nMT,0,0],4,1,wf8(:,14))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,16),heltab2x64(:,:,22))
  Gcoeff(:)%j = (c(22)*M(1,:)%j-c(24)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[32,8,7,16],[0,nMT,0,0],4,1,wf8(:,12))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,17),heltab2x64(:,:,23))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(33)*M(2,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[32,8,7,16],[0,nMT,0,0],4,1,wf8(:,14))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,18),heltab2x64(:,:,24))
  Gcoeff(:)%j = (c(22)*M(1,:)%j-c(24)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[32,11,4,16],[0,nMT,0,0],4,1,wf8(:,35))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,19),heltab2x64(:,:,25))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(33)*M(2,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[32,11,4,16],[0,nMT,0,0],4,1,wf8(:,36))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,20),heltab2x64(:,:,26))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)-c(20)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[32,4,11,16],[0,nMT,0,0],4,1,wf8(:,35))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,21),heltab2x64(:,:,27))
  Gcoeff(:)%j = (c(35)*M(1,:)%j+c(29)*M(2,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[32,4,11,16],[0,nMT,0,0],4,1,wf8(:,36))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,22),heltab2x64(:,:,28))
  Gcoeff(:)%j = (c(15)*M(1,:)%j+c(9)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[32,4,8,19],[0,nMT,0,0],4,1,wf8(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,23),heltab2x64(:,:,29))
  Gcoeff(:)%j = (c(35)*M(1,:)%j+c(29)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[32,4,8,19],[0,nMT,0,0],4,1,wf8(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,24),heltab2x64(:,:,30))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)+c(13)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[32,8,4,19],[0,nMT,0,0],4,1,wf8(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(11),m3h2x32(:,25),heltab2x64(:,:,31))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(33)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[32,8,4,19],[0,nMT,0,0],4,1,wf8(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(12),m3h2x32(:,26),heltab2x64(:,:,32))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)+c(13)*M(2,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[35,8,4,16],[0,nMT,0,0],4,1,wf8(:,23))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,23),G0H8(1),m3h8x8(:,1),heltab2x64(:,:,33))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(33)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(34),h0tab(:,34),[35,8,4,16],[0,nMT,0,0],4,1,wf8(:,24))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,24),G0H8(2),m3h8x8(:,2),heltab2x64(:,:,34))
  Gcoeff(:)%j = (c(15)*M(1,:)%j+c(9)*M(2,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(35),h0tab(:,35),[35,4,8,16],[0,nMT,0,0],4,1,wf8(:,23))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,23),G0H8(3),m3h8x8(:,3),heltab2x64(:,:,35))
  Gcoeff(:)%j = (c(35)*M(1,:)%j+c(29)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(36),h0tab(:,36),[35,4,8,16],[0,nMT,0,0],4,1,wf8(:,24))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,24),G0H8(4),m3h8x8(:,4),heltab2x64(:,:,36))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(2),[G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(4),[G0H8(3)])
  call Hloop_AV_Q(ntryL,G1H32(1),wf4(:,2),G1H8(1),m3h4x8(:,5),heltab2x32(:,:,9))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(1),n2h8(5))
  call Hloop_AV_Q(ntryL,G1H32(2),wf4(:,2),G1H8(1),m3h4x8(:,6),heltab2x32(:,:,10))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(3),n2h8(6))
  call Hloop_AV_Q(ntryL,G1H32(3),wf4(:,1),G1H8(1),m3h4x8(:,7),heltab2x32(:,:,11))
  call Hloop_A_Q(ntryL,G1H8(1),35,0,G2H8(2),n2h8(7))
  call Hloop_AZ_Q(ntryL,G1H32(4),wf4(:,4),G1H8(1),ngZd,m3h4x8(:,8),heltab2x32(:,:,12))
  call Hloop_A_Q(ntryL,G1H8(1),35,0,G2H8(4),n2h8(8))
  call Hloop_AV_Q(ntryL,G1H32(5),wf4(:,1),G1H8(1),m3h4x8(:,9),heltab2x32(:,:,13))
  call Hloop_A_Q(ntryL,G1H8(1),35,0,G2H8(5),n2h8(9))
  call Hloop_AZ_Q(ntryL,G1H32(6),wf4(:,4),G1H8(1),ngZd,m3h4x8(:,10),heltab2x32(:,:,14))
  call Hloop_A_Q(ntryL,G1H8(1),35,0,G2H8(6),n2h8(10))
  call Hloop_AV_Q(ntryL,G1H16(1),wf4(:,1),G1H4(1),m3h4x4(:,5),heltab2x16(:,:,5))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMT,G2H4(3),n2h4(7))
  call Hloop_AZ_Q(ntryL,G1H16(2),wf4(:,4),G1H4(2),ngZu,m3h4x4(:,6),heltab2x16(:,:,6))
  call Hloop_A_Q(ntryL,G1H4(2),51,nMT,G2H4(5),n2h4(8))
  call Hloop_QV_A(ntryL,G1H16(3),wf4(:,1),G1H4(5),m3h4x4(:,7),heltab2x16(:,:,7))
  call Hloop_Q_A(ntryL,G1H4(5),51,nMT,G2H4(1),n2h4(9))
  call Hloop_QZ_A(ntryL,G1H16(4),wf4(:,4),G1H4(6),ngZu,m3h4x4(:,8),heltab2x16(:,:,8))
  call Hloop_Q_A(ntryL,G1H4(6),51,nMT,G2H4(2),n2h4(10))
  call Hloop_VQ_A(ntryL,G1H16(5),ex3(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,9))
  call Hloop_Q_A(ntryL,G1H8(1),52,nMT,G2H8(7),n2h8(11))
  call Hloop_VQ_A(ntryL,G1H16(6),ex3(:),G1H8(1),m3h2x8(:,2),heltab2x16(:,:,10))
  call Hloop_Q_A(ntryL,G1H8(1),52,nMT,G2H8(8),n2h8(12))
  call Hloop_VQ_A(ntryL,G0H32(3),wf8(:,12),G0H4(1),m3h8x4(:,1),heltab2x32(:,:,15))
  call Hloop_Q_A(ntryL,G0H4(1),39,nMT,G1H4(7),n2h4(11))
  call Hloop_VQ_A(ntryL,G0H32(4),wf8(:,14),G0H4(1),m3h8x4(:,2),heltab2x32(:,:,16))
  call Hloop_Q_A(ntryL,G0H4(1),39,nMT,G1H4(8),n2h4(12))
  call Hloop_VA_Q(ntryL,G0H32(1),ex4(:),G0H16(1),m3h2x16(:,5),heltab2x32(:,:,17))
  call Hloop_A_Q(ntryL,G0H16(1),40,nMT,G1H16(1),n2h16(9))
  call Hloop_VA_Q(ntryL,G0H32(2),ex4(:),G0H16(1),m3h2x16(:,6),heltab2x32(:,:,18))
  call Hloop_A_Q(ntryL,G0H16(1),40,nMT,G1H16(2),n2h16(10))
  call Hloop_VA_Q(ntryL,G0H32(5),wf8(:,35),G0H4(1),m3h8x4(:,3),heltab2x32(:,:,19))
  call Hloop_A_Q(ntryL,G0H4(1),43,nMT,G1H4(11),n2h4(13))
  call Hloop_VA_Q(ntryL,G0H32(6),wf8(:,36),G0H4(1),m3h8x4(:,4),heltab2x32(:,:,20))
  call Hloop_A_Q(ntryL,G0H4(1),43,nMT,G1H4(12),n2h4(14))
  call Hloop_VQ_A(ntryL,G0H32(7),ex3(:),G0H16(1),m3h2x16(:,7),heltab2x32(:,:,21))
  call Hloop_Q_A(ntryL,G0H16(1),36,nMT,G1H16(3),n2h16(11))
  call Hloop_VQ_A(ntryL,G0H32(8),ex3(:),G0H16(1),m3h2x16(:,8),heltab2x32(:,:,22))
  call Hloop_Q_A(ntryL,G0H16(1),36,nMT,G1H16(4),n2h16(12))
  call Hloop_VQ_A(ntryL,G0H32(9),ex3(:),G0H16(1),m3h2x16(:,9),heltab2x32(:,:,23))
  call Hloop_Q_A(ntryL,G0H16(1),36,nMT,G1H16(5),n2h16(13))
  call Hloop_VQ_A(ntryL,G0H32(10),ex3(:),G0H16(1),m3h2x16(:,10),heltab2x32(:,:,24))
  call Hloop_Q_A(ntryL,G0H16(1),36,nMT,G1H16(6),n2h16(14))
  call Hloop_VA_Q(ntryL,G0H32(11),ex4(:),G0H16(1),m3h2x16(:,11),heltab2x32(:,:,25))
  call Hloop_A_Q(ntryL,G0H16(1),40,nMT,G1H16(7),n2h16(15))
  call Hloop_VA_Q(ntryL,G0H32(12),ex4(:),G0H16(1),m3h2x16(:,12),heltab2x32(:,:,26))
  call Hloop_A_Q(ntryL,G0H16(1),40,nMT,G1H16(8),n2h16(16))
  call Hloop_VA_Q(ntryL,G0H8(2),ex4(:),G0H4(1),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_A_Q(ntryL,G0H4(1),43,nMT,G1H4(1),n2h4(15))
  call Hloop_VQ_A(ntryL,G0H8(4),ex3(:),G0H4(1),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_Q_A(ntryL,G0H4(1),39,nMT,G1H4(2),n2h4(16))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(4),[G2H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(6),[G2H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(5),[G2H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(2),[G2H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(8),[G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(12),[G1H4(11)])
  call Hloop_VQ_A(ntryL,G1H4(3),ex3(:),G1H2(3),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_Q_A(ntryL,G1H2(3),55,nMT,G2H2(1),n2h2(7))
  call Hloop_VQ_A(ntryL,G1H4(4),ex3(:),G1H2(4),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_Q_A(ntryL,G1H2(4),55,nMT,G2H2(2),n2h2(8))
  call Hloop_VA_Q(ntryL,G1H4(9),ex4(:),G1H2(8),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_A_Q(ntryL,G1H2(8),59,nMT,G2H2(3),n2h2(9))
  call Hloop_VA_Q(ntryL,G1H4(10),ex4(:),G1H2(9),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_A_Q(ntryL,G1H2(9),59,nMT,G2H2(5),n2h2(10))
  call Hotf_4pt_reduction(G2H8(1),RedSet_4(20),mass4set(:,1),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),8)
  call HG1shiftOLR(G1H8(2),16,8)
  call Hotf_4pt_reduction(G2H8(3),RedSet_4(20),mass4set(:,1),  & 
G1H8(6),G1H8(7),G1H8(8),G1H8(9),G1H8(10),8)
  call HG1shiftOLR(G1H8(7),16,8)
  call Hotf_4pt_reduction(G2H8(4),RedSet_4(21),mass4set(:,1),  & 
G1H8(11),G1H8(12),G1H8(13),G1H8(14),G1H8(15),8)
  call HG1shiftOLR(G1H8(12),16,8)
  call Hloop_AQ_V(ntryL,G2H8(6),ex5(:),G2H4(4),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_AQ_V(ntryL,G2H4(5),ex3(:),G2H2(6),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_QA_V(ntryL,G2H4(2),ex4(:),G2H2(8),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hotf_4pt_reduction(G2H8(7),RedSet_4(22),mass4set(:,2),  & 
G1H8(16),G1H8(17),G1H8(18),G1H8(19),G1H8(20),8)
  call HG1shiftOLR(G1H8(17),8,8)
  call Hotf_4pt_reduction(G2H8(8),RedSet_4(22),mass4set(:,2),  & 
G1H8(21),G1H8(22),G1H8(23),G1H8(24),G1H8(25),8)
  call HG1shiftOLR(G1H8(22),8,8)
  call Hloop_QA_V(ntryL,G1H4(8),ex4(:),G1H2(10),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_AQ_V(ntryL,G1H16(1),wf8(:,12),G1H2(14),m3h8x2(:,1),heltab2x16(:,:,11))
  call Hloop_AQ_V(ntryL,G1H16(2),wf8(:,14),G1H2(3),m3h8x2(:,2),heltab2x16(:,:,12))
  call Hloop_AQ_V(ntryL,G1H4(12),ex3(:),G1H2(4),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_QA_V(ntryL,G1H16(3),wf8(:,35),G1H2(8),m3h8x2(:,3),heltab2x16(:,:,13))
  call Hloop_QA_V(ntryL,G1H16(4),wf8(:,36),G1H2(9),m3h8x2(:,4),heltab2x16(:,:,14))
  call Hloop_QA_V(ntryL,G1H16(5),ex4(:),G1H8(26),m3h2x8(:,3),heltab2x16(:,:,15))
  call Hloop_QA_V(ntryL,G1H16(6),ex4(:),G1H8(27),m3h2x8(:,4),heltab2x16(:,:,16))
  call Hloop_AQ_V(ntryL,G1H16(7),ex3(:),G1H8(28),m3h2x8(:,5),heltab2x16(:,:,17))
  call Hloop_AQ_V(ntryL,G1H16(8),ex3(:),G1H8(29),m3h2x8(:,6),heltab2x16(:,:,18))
  call Hloop_AQ_V(ntryL,G1H4(1),ex3(:),G1H2(15),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_QA_V(ntryL,G1H4(2),ex4(:),G1H2(16),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_AV_Q(ntryL,G1H8(1),wf4(:,1),G1H2(17),m3h4x2(:,1),heltab2x8(:,:,6))
  call Hloop_A_Q(ntryL,G1H2(17),47,0,G2H2(9),n2h2(11))
call HGT_raise_alpha_OLR(G1H8(2),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(2),ex5(:),G1H4(5),m3h2x4(:,6),heltab2x8(:,:,7))
  call Hloop_AV_Q(ntryL,G1H8(4),wf4(:,1),G1H2(17),m3h4x2(:,2),heltab2x8(:,:,8))
  call Hloop_A_Q(ntryL,G1H2(17),47,0,G2H2(10),n2h2(12))
  call Hloop_AV_Q(ntryL,G1H8(5),wf4(:,1),G1H2(17),m3h4x2(:,3),heltab2x8(:,:,9))
  call Hloop_A_Q(ntryL,G1H2(17),47,0,G2H2(11),n2h2(13))
  call Hloop_AZ_Q(ntryL,G1H8(6),wf4(:,4),G1H2(17),ngZd,m3h4x2(:,4),heltab2x8(:,:,10))
  call Hloop_A_Q(ntryL,G1H2(17),47,0,G2H2(12),n2h2(14))
call HGT_raise_alpha_OLR(G1H8(7),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(7),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(7),ex5(:),G1H4(6),m3h2x4(:,7),heltab2x8(:,:,11))
  call Hloop_AZ_Q(ntryL,G1H8(9),wf4(:,4),G1H2(17),ngZd,m3h4x2(:,5),heltab2x8(:,:,12))
  call Hloop_A_Q(ntryL,G1H2(17),47,0,G2H2(13),n2h2(15))
  call Hloop_AZ_Q(ntryL,G1H8(10),wf4(:,4),G1H2(17),ngZd,m3h4x2(:,6),heltab2x8(:,:,13))
  call Hloop_A_Q(ntryL,G1H2(17),47,0,G2H2(14),n2h2(16))
  call Hloop_AV_Q(ntryL,G1H8(11),wf4(:,2),G1H2(17),m3h4x2(:,7),heltab2x8(:,:,14))
  call Hloop_A_Q(ntryL,G1H2(17),47,0,G2H2(15),n2h2(17))
call HGT_raise_alpha_OLR(G1H8(12),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(12),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(12),ex5(:),G1H4(7),m3h2x4(:,8),heltab2x8(:,:,15))
  call Hloop_AV_Q(ntryL,G1H8(14),wf4(:,2),G1H2(17),m3h4x2(:,8),heltab2x8(:,:,16))
  call Hloop_A_Q(ntryL,G1H2(17),47,0,G2H2(16),n2h2(18))
  call Hloop_AV_Q(ntryL,G1H8(15),wf4(:,2),G1H2(17),m3h4x2(:,9),heltab2x8(:,:,17))
  call Hloop_A_Q(ntryL,G1H2(17),47,0,G2H2(17),n2h2(19))
  call Hloop_QV_A(ntryL,G1H8(16),wf4(:,1),G1H2(17),m3h4x2(:,10),heltab2x8(:,:,18))
  call Hloop_Q_A(ntryL,G1H2(17),55,nMT,G2H2(18),n2h2(20))
call HGT_raise_alpha_OLR(G1H8(17),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(17),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(17),ex4(:),G1H4(11),m3h2x4(:,9),heltab2x8(:,:,19))
  call Hloop_QV_A(ntryL,G1H8(19),wf4(:,1),G1H2(17),m3h4x2(:,11),heltab2x8(:,:,20))
  call Hloop_Q_A(ntryL,G1H2(17),55,nMT,G2H2(19),n2h2(21))
  call Hloop_QV_A(ntryL,G1H8(20),wf4(:,1),G1H2(17),m3h4x2(:,12),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G1H2(17),55,nMT,G2H2(20),n2h2(22))
  call Hloop_QZ_A(ntryL,G1H8(21),wf4(:,4),G1H2(17),ngZu,m3h4x2(:,13),heltab2x8(:,:,22))
  call Hloop_Q_A(ntryL,G1H2(17),55,nMT,G2H2(21),n2h2(23))
call HGT_raise_alpha_OLR(G1H8(22),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(22),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(22),ex4(:),G1H4(3),m3h2x4(:,10),heltab2x8(:,:,23))
  call Hloop_QZ_A(ntryL,G1H8(24),wf4(:,4),G1H2(17),ngZu,m3h4x2(:,14),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G1H2(17),55,nMT,G2H2(22),n2h2(24))
  call Hloop_QZ_A(ntryL,G1H8(25),wf4(:,4),G1H2(17),ngZu,m3h4x2(:,15),heltab2x8(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(17),55,nMT,G2H2(23),n2h2(25))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(4),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(3),[G1H2(14),G1H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(10),[G1H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(9),[G1H2(8),G1H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G2H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G2H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(21),[G2H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(23),[G2H2(20)])
call HGT_w2_OLR(G1H2(1),1,1,2)
call HGT_w2_invQ_OLR(G1H2(1),2,5,2)
  call Hloop_VQ_A(ntryL,G1H2(1),ex3(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(1),n2h1(7))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(4),ex4(:),G2tensor(3),m3h2x1(:,12),heltab2x2(:,:,12))
call HGT_w2_OLR(G1H2(2),1,1,2)
call HGT_w2_invQ_OLR(G1H2(2),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(2),ex4(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(5),n2h1(8))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(7),ex3(:),G2tensor(8),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hloop_VQ_A(ntryL,G1H2(5),ex5(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(9))
  call Hloop_VQ_A(ntryL,G1H2(4),ex5(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(12),n2h1(10))
  call Hloop_VQ_A(ntryL,G1H2(3),ex5(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(11))
  call Hloop_VQ_A(ntryL,G1H2(11),ex5(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(14),n2h1(12))
  call Hloop_VQ_A(ntryL,G1H2(10),ex5(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(13))
  call Hloop_VQ_A(ntryL,G1H2(9),ex5(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(16),n2h1(14))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(1),ex4(:),G2tensor(17),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(2),ex4(:),G2tensor(18),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(3),ex3(:),G2tensor(19),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(5),ex3(:),G2tensor(20),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hotf_4pt_reduction(G2H4(4),RedSet_4(4),mass4set(:,1),  & 
G1H4(4),G1H4(9),G1H4(10),G1H4(8),G1H4(12),4)
  call HG1shiftOLR(G1H4(9),12,4)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(23),mass4set(:,3),  & 
G1H2(17),G1H2(6),G1H2(14),G1H2(7),G1H2(12),2)
  call HG1shiftOLR(G1H2(6),8,2)
  call Hotf_4pt_reduction(G2H2(8),RedSet_4(24),mass4set(:,3),  & 
G1H2(8),G1H2(13),G1H2(1),G1H2(2),G1H2(5),2)
  call HG1shiftOLR(G1H2(13),4,2)
  call Hloop_VQ_A(ntryL,G1H8(26),wf8(:,3),G1H1(1),m3h8x1(:,1),heltab2x8(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(21),n2h1(15))
  call Hloop_VQ_A(ntryL,G1H8(27),wf8(:,5),G1H1(1),m3h8x1(:,2),heltab2x8(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(22),n2h1(16))
  call Hloop_VQ_A(ntryL,G1H8(28),wf8(:,3),G1H1(1),m3h8x1(:,3),heltab2x8(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(23),n2h1(17))
  call Hloop_VQ_A(ntryL,G1H8(29),wf8(:,5),G1H1(1),m3h8x1(:,4),heltab2x8(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(24),n2h1(18))
  call Hloop_VQ_A(ntryL,G1H2(15),ex5(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(25),n2h1(19))
  call Hloop_VQ_A(ntryL,G1H2(16),ex5(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(26),n2h1(20))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(12),ex5(:),G2tensor(27),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(14),ex5(:),G2tensor(28),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(15),ex5(:),G2tensor(29),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(17),ex5(:),G2tensor(30),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(21),ex4(:),G2tensor(31),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(23),ex4(:),G2tensor(32),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(4),51,wf4(:,2),12,G2tensor(33),m3h4x1(:,1),heltab2x4(:,:,21))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(9),0,wf4(:,2),12,G2tensor(34),m3h4x1(:,2),heltab2x4(:,:,22))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(12),51,wf4(:,2),12,G2tensor(35),m3h4x1(:,3),heltab2x4(:,:,23))
  call Hloop_VA_Q(ntryL,G1H2(17),ex4(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(36),n2h1(22))
  call Hloop_VA_Q(ntryL,G1H2(6),ex4(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(37),n2h1(23))
  call Hloop_VA_Q(ntryL,G1H2(12),ex4(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(38),n2h1(24))
  call Hloop_VQ_A(ntryL,G1H2(8),ex3(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(39),n2h1(25))
  call Hloop_VQ_A(ntryL,G1H2(13),ex3(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(40),n2h1(26))
  call Hloop_VQ_A(ntryL,G1H2(5),ex3(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(41),n2h1(27))
  call ol_merge_tensors(G2tensor(33),[G2tensor(4),G2tensor(2),G1tensor(12),G1tensor(6)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(14)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(18)])
  call ol_merge_tensors(G2tensor(31),[G2tensor(9),G1tensor(20)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(24)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(2)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(3)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(5)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(8)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(9)])
  call ol_merge_tensors(G2tensor(20),[G1tensor(10)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(11)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(15)])
  call ol_merge_tensors(G2tensor(12),[G1tensor(16)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(17)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(21)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(22)])
  call ol_merge_tensors(G2tensor(16),[G1tensor(23)])
  call ol_merge_tensors(G2tensor(22),[G2tensor(21)])
  call ol_merge_tensors(G2tensor(24),[G2tensor(23)])
  call Hotf_4pt_reduction_last(G2tensor(33),RedSet_4(4),mass4set(:,1),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(12))
  call G_TensorShift(G1tensor(7),12)
  call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(25),mass4set(:,2),  & 
G1tensor(6),G1tensor(14),G1tensor(18),G1tensor(20),G1tensor(24))
  call G_TensorShift(G1tensor(14),4)
  call Hotf_4pt_reduction_last(G2tensor(7),RedSet_4(13),mass4set(:,2),  & 
G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(8))
  call G_TensorShift(G1tensor(3),20)
  call Hotf_4pt_reduction_last(G2tensor(31),RedSet_4(22),mass4set(:,2),  & 
G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(15),G1tensor(16))
  call G_TensorShift(G1tensor(10),8)
  call Hotf_4pt_reduction_last(G2tensor(10),RedSet_4(18),mass4set(:,2),  & 
G1tensor(17),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(25))
  call G_TensorShift(G1tensor(21),24)
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(26),mass4set(:,4),  & 
G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(27),4)
  call Hotf_4pt_reduction_last(G2tensor(17),RedSet_4(1),mass4set(:,5),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35))
  call G_TensorShift(G1tensor(32),8)
  call Hotf_4pt_reduction_last(G2tensor(18),RedSet_4(2),mass4set(:,5),  & 
G1tensor(36),G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40))
  call G_TensorShift(G1tensor(37),8)
  call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(3),mass4set(:,5),  & 
G1tensor(41),G1tensor(42),G1tensor(43),G1tensor(44),G1tensor(45))
  call G_TensorShift(G1tensor(42),8)
  call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(27),mass4set(:,4),  & 
G1tensor(46),G1tensor(47),G1tensor(48),G1tensor(49),G1tensor(50))
  call G_TensorShift(G1tensor(47),8)
  call Hotf_4pt_reduction_last(G2tensor(19),RedSet_4(6),mass4set(:,5),  & 
G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54),G1tensor(55))
  call G_TensorShift(G1tensor(52),4)
  call Hotf_4pt_reduction_last(G2tensor(20),RedSet_4(7),mass4set(:,5),  & 
G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(57),4)
  call Hotf_4pt_reduction_last(G2tensor(8),RedSet_4(8),mass4set(:,5),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65))
  call G_TensorShift(G1tensor(62),4)
  call Hotf_4pt_reduction_last(G2tensor(11),RedSet_4(10),mass4set(:,6),  & 
G1tensor(66),G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70))
  call G_TensorShift(G1tensor(67),16)
  call Hotf_4pt_reduction_last(G2tensor(12),RedSet_4(11),mass4set(:,7),  & 
G1tensor(71),G1tensor(72),G1tensor(73),G1tensor(74),G1tensor(75))
  call G_TensorShift(G1tensor(72),16)
  call Hotf_4pt_reduction_last(G2tensor(13),RedSet_4(12),mass4set(:,7),  & 
G1tensor(76),G1tensor(77),G1tensor(78),G1tensor(79),G1tensor(80))
  call G_TensorShift(G1tensor(77),16)
  call Hotf_4pt_reduction_last(G2tensor(14),RedSet_4(15),mass4set(:,6),  & 
G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84),G1tensor(85))
  call G_TensorShift(G1tensor(82),16)
  call Hotf_4pt_reduction_last(G2tensor(15),RedSet_4(16),mass4set(:,7),  & 
G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(87),16)
  call Hotf_4pt_reduction_last(G2tensor(16),RedSet_4(17),mass4set(:,7),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95))
  call G_TensorShift(G1tensor(92),16)
  call Hotf_4pt_reduction_last(G2tensor(22),RedSet_4(28),mass4set(:,7),  & 
G1tensor(96),G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100))
  call G_TensorShift(G1tensor(97),19)
  call Hotf_4pt_reduction_last(G2tensor(24),RedSet_4(29),mass4set(:,7),  & 
G1tensor(101),G1tensor(102),G1tensor(103),G1tensor(104),G1tensor(105))
  call G_TensorShift(G1tensor(102),19)
  call Hotf_4pt_reduction_last(G2tensor(25),RedSet_4(30),mass4set(:,7),  & 
G1tensor(106),G1tensor(107),G1tensor(108),G1tensor(109),G1tensor(110))
  call G_TensorShift(G1tensor(107),16)
  call Hotf_4pt_reduction_last(G2tensor(26),RedSet_4(31),mass4set(:,7),  & 
G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114),G1tensor(115))
  call G_TensorShift(G1tensor(112),16)
  call Hotf_4pt_reduction_last(G2tensor(27),RedSet_4(20),mass4set(:,1),  & 
G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(117),16)
  call Hotf_4pt_reduction_last(G2tensor(29),RedSet_4(21),mass4set(:,1),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125))
  call G_TensorShift(G1tensor(122),16)
  call Hotf_4pt_reduction_last(G2tensor(36),RedSet_4(23),mass4set(:,3),  & 
G1tensor(126),G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130))
  call G_TensorShift(G1tensor(127),8)
  call Hotf_4pt_reduction_last(G2tensor(39),RedSet_4(24),mass4set(:,3),  & 
G1tensor(131),G1tensor(132),G1tensor(133),G1tensor(134),G1tensor(135))
  call G_TensorShift(G1tensor(132),4)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(4),mass4set(:,1),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(6),RedSet_4(25),mass4set(:,2),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(2),RedSet_4(13),mass4set(:,2),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(9),RedSet_4(22),mass4set(:,2),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(17),RedSet_4(18),mass4set(:,2),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(26),mass4set(:,4),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(1),mass4set(:,5),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(36),RedSet_4(2),mass4set(:,5),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(3),mass4set(:,5),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(46),RedSet_4(27),mass4set(:,4),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(6),mass4set(:,5),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(56),RedSet_4(7),mass4set(:,5),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(8),mass4set(:,5),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(10),mass4set(:,6),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call Hotf_4pt_reduction_last(G1tensor(71),RedSet_4(11),mass4set(:,7),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
  call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(12),mass4set(:,7),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
  call Hotf_4pt_reduction_last(G1tensor(81),RedSet_4(15),mass4set(:,6),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
  call Hotf_4pt_reduction_last(G1tensor(86),RedSet_4(16),mass4set(:,7),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
  call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(17),mass4set(:,7),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
  call Hotf_4pt_reduction_last(G1tensor(96),RedSet_4(28),mass4set(:,7),  & 
G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100))
  call Hotf_4pt_reduction_last(G1tensor(101),RedSet_4(29),mass4set(:,7),  & 
G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104),G0tensor(105))
  call Hotf_4pt_reduction_last(G1tensor(106),RedSet_4(30),mass4set(:,7),  & 
G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110))
  call Hotf_4pt_reduction_last(G1tensor(111),RedSet_4(31),mass4set(:,7),  & 
G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114),G0tensor(115))
  call Hotf_4pt_reduction_last(G1tensor(116),RedSet_4(20),mass4set(:,1),  & 
G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119),G0tensor(120))
  call Hotf_4pt_reduction_last(G1tensor(121),RedSet_4(21),mass4set(:,1),  & 
G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124),G0tensor(125))
  call Hotf_4pt_reduction_last(G1tensor(126),RedSet_4(23),mass4set(:,3),  & 
G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129),G0tensor(130))
  call Hotf_4pt_reduction_last(G1tensor(131),RedSet_4(24),mass4set(:,3),  & 
G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134),G0tensor(135))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  call ol_merge_tensors(T0sum(12),[G0tensor(56)])
  call ol_merge_tensors(T0sum(13),[G0tensor(61)])
  call ol_merge_tensors(T0sum(14),[G0tensor(66)])
  call ol_merge_tensors(T0sum(15),[G0tensor(71)])
  call ol_merge_tensors(T0sum(16),[G0tensor(76)])
  call ol_merge_tensors(T0sum(17),[G0tensor(81)])
  call ol_merge_tensors(T0sum(18),[G0tensor(86)])
  call ol_merge_tensors(T0sum(19),[G0tensor(91)])
  call ol_merge_tensors(T0sum(20),[G0tensor(96)])
  call ol_merge_tensors(T0sum(21),[G0tensor(101)])
  call ol_merge_tensors(T0sum(22),[G0tensor(106)])
  call ol_merge_tensors(T0sum(23),[G0tensor(111)])
  call ol_merge_tensors(T0sum(24),[G0tensor(116)])
  call ol_merge_tensors(T0sum(25),[G0tensor(121)])
  call ol_merge_tensors(T0sum(26),[G0tensor(126)])
  call ol_merge_tensors(T0sum(27),[G0tensor(131)])
  Gcoeff(:)%j = (c(45)*M(1,:)%j-c(44)*M(2,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(37),h0tab(:,37),[48,3,12],[0,0,0],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,7),heltab2x64(:,:,37))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(1),n2h16(17))
  Gcoeff(:)%j = (c(41)*M(1,:)%j-c(40)*M(2,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(38),h0tab(:,38),[48,3,12],[nMT,nMT,nMT],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,8),heltab2x64(:,:,38))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(2),n2h16(18))
  Gcoeff(:)%j = (c(45)*M(1,:)%j-c(44)*M(2,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(39),h0tab(:,39),[48,3,12],[0,0,0],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,9),heltab2x64(:,:,39))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(3),n2h16(19))
  Gcoeff(:)%j = (c(41)*M(1,:)%j-c(40)*M(2,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(40),h0tab(:,40),[48,3,12],[nMT,nMT,nMT],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,10),heltab2x64(:,:,40))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMT,G1H16(4),n2h16(20))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)+c(40)*M(2,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(41),h0tab(:,41),[48,3,12],[0,0,0],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,11),heltab2x64(:,:,41))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(5),n2h16(21))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)+c(38)*M(2,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(42),h0tab(:,42),[48,3,12],[nMB,nMB,nMB],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,12),heltab2x64(:,:,42))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMB,G1H16(6),n2h16(22))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)+c(40)*M(2,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(43),h0tab(:,43),[48,3,12],[0,0,0],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,13),heltab2x64(:,:,43))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(7),n2h16(23))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)+c(38)*M(2,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(44),h0tab(:,44),[48,3,12],[nMB,nMB,nMB],3,3,wf4(:,5),wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,14),heltab2x64(:,:,44))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMB,G1H16(8),n2h16(24))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)+c(46)*M(2,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(45),h0tab(:,45),[48,3,12],[0,0,0],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,15),heltab2x64(:,:,45))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(9),n2h16(25))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)+c(42)*M(2,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(46),h0tab(:,46),[48,3,12],[nMT,nMT,nMT],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,16),heltab2x64(:,:,46))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(10),n2h16(26))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)+c(46)*M(2,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(47),h0tab(:,47),[48,3,12],[0,0,0],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,17),heltab2x64(:,:,47))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(11),n2h16(27))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)+c(42)*M(2,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(48),h0tab(:,48),[48,3,12],[nMT,nMT,nMT],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,18),heltab2x64(:,:,48))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMT,G1H16(12),n2h16(28))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)+c(46)*M(2,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(49),h0tab(:,49),[48,3,12],[0,0,0],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,19),heltab2x64(:,:,49))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(13),n2h16(29))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)+c(42)*M(2,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(50),h0tab(:,50),[48,3,12],[nMB,nMB,nMB],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,20),heltab2x64(:,:,50))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMB,G1H16(14),n2h16(30))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)+c(46)*M(2,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(51),h0tab(:,51),[48,3,12],[0,0,0],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,21),heltab2x64(:,:,51))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(15),n2h16(31))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)+c(42)*M(2,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(52),h0tab(:,52),[48,3,12],[nMB,nMB,nMB],3,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,22),heltab2x64(:,:,52))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMB,G1H16(16),n2h16(32))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(9)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(53),h0tab(:,53),[32,12,19],[0,0,0],3,2,wf4(:,2),wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,27),heltab2x64(:,:,53))
  call Hloop_A_Q(ntryL,G0H32(3),32,0,G1H32(1),n2h32(11))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(54),h0tab(:,54),[32,12,19],[0,0,0],3,2,wf4(:,2),wf8(:,5))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,28),heltab2x64(:,:,54))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(2),n2h32(12))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(55),h0tab(:,55),[32,12,19],[0,0,0],3,2,wf4(:,2),wf8(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,29),heltab2x64(:,:,55))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(5)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(56),h0tab(:,56),[32,12,19],[0,0,0],3,2,wf4(:,2),wf8(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,30),heltab2x64(:,:,56))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(9)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(57),h0tab(:,57),[35,12,16],[0,0,0],3,2,wf8(:,23),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,23),G0H8(1),m3h8x8(:,5),heltab2x64(:,:,57))
  call Hloop_A_Q(ntryL,G0H8(1),35,0,G1H8(1),n2h8(18))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(58),h0tab(:,58),[35,12,16],[0,0,0],3,2,wf8(:,24),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,24),G0H8(3),m3h8x8(:,6),heltab2x64(:,:,58))
  call Hloop_A_Q(ntryL,G0H8(3),35,0,G1H8(2),n2h8(19))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(59),h0tab(:,59),[35,12,16],[0,0,0],3,2,wf8(:,23),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,23),G0H8(2),m3h8x8(:,7),heltab2x64(:,:,59))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(5)*M(2,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(60),h0tab(:,60),[35,12,16],[0,0,0],3,2,wf8(:,24),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,24),G0H8(4),m3h8x8(:,8),heltab2x64(:,:,60))
  Gcoeff(:)%j = (c(16)*M(1,:)%j-c(12)*M(2,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(61),h0tab(:,61),[32,3,28],[0,0,0],3,2,wf4(:,1),wf8(:,8))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,31),heltab2x64(:,:,61))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(3),n2h32(13))
  Gcoeff(:)%j = (c(36)*M(1,:)%j-c(32)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(62),h0tab(:,62),[32,3,28],[0,0,0],3,2,wf4(:,4),wf8(:,8))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,32),heltab2x64(:,:,62))
  call Hloop_A_Q(ntryL,G0H32(6),32,0,G1H32(4),n2h32(14))
  Gcoeff(:)%j = (c(16)*M(1,:)%j-c(12)*M(2,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(63),h0tab(:,63),[44,3,16],[0,0,0],3,2,wf8(:,26),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,26),G0H8(1),m3h8x8(:,9),heltab2x64(:,:,63))
  call Hloop_A_Q(ntryL,G0H8(1),44,0,G1H8(4),n2h8(20))
  Gcoeff(:)%j = (c(36)*M(1,:)%j-c(32)*M(2,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(64),h0tab(:,64),[44,3,16],[0,0,0],3,2,wf8(:,26),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,26),G0H8(3),m3h8x8(:,10),heltab2x64(:,:,64))
  call Hloop_A_Q(ntryL,G0H8(3),44,0,G1H8(5),n2h8(21))
  Gcoeff(:)%j = (c(21)*M(1,:)%j-c(20)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(65),h0tab(:,65),[48,7,8],[nMT,0,nMT],3,2,wf4(:,5),wf8(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,23),heltab2x64(:,:,65))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(17),n2h16(33))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(66),h0tab(:,66),[48,7,8],[nMT,0,nMT],3,2,wf4(:,5),wf8(:,14))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,24),heltab2x64(:,:,66))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(18),n2h16(34))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(3)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(67),h0tab(:,67),[48,7,8],[0,nMT,0],3,2,wf4(:,5),wf8(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(19),m3h4x16(:,25),heltab2x64(:,:,67))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(5)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(68),h0tab(:,68),[48,7,8],[0,nMT,0],3,2,wf4(:,5),wf8(:,14))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(20),m3h4x16(:,26),heltab2x64(:,:,68))
  Gcoeff(:)%j = (c(21)*M(1,:)%j-c(20)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(69),h0tab(:,69),[48,4,11],[nMT,0,nMT],3,2,wf4(:,5),wf8(:,35))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,27),heltab2x64(:,:,69))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(21),n2h16(35))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(70),h0tab(:,70),[48,4,11],[nMT,0,nMT],3,2,wf4(:,5),wf8(:,36))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,28),heltab2x64(:,:,70))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(22),n2h16(36))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(3)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(71),h0tab(:,71),[48,4,11],[0,nMT,0],3,2,wf4(:,5),wf8(:,35))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(23),m3h4x16(:,29),heltab2x64(:,:,71))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(5)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(72),h0tab(:,72),[48,4,11],[0,nMT,0],3,2,wf4(:,5),wf8(:,36))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(24),m3h4x16(:,30),heltab2x64(:,:,72))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)+c(23)*M(2,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(73),h0tab(:,73),[52,3,8],[nMT,nMT,0],3,2,wf8(:,17),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,17),G0H8(1),m3h8x8(:,11),heltab2x64(:,:,73))
  call Hloop_Q_A(ntryL,G0H8(1),52,nMT,G1H8(6),n2h8(22))
  Gcoeff(:)%j = (c(36)*M(1,:)%j-c(32)*M(2,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(74),h0tab(:,74),[52,3,8],[nMT,nMT,0],3,2,wf8(:,17),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,17),G0H8(3),m3h8x8(:,12),heltab2x64(:,:,74))
  call Hloop_Q_A(ntryL,G0H8(3),52,nMT,G1H8(7),n2h8(23))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)+c(23)*M(2,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(75),h0tab(:,75),[56,3,4],[nMT,nMT,0],3,2,wf8(:,38),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,38),G0H8(1),m3h8x8(:,13),heltab2x64(:,:,75))
  call Hloop_A_Q(ntryL,G0H8(1),56,nMT,G1H8(9),n2h8(24))
  Gcoeff(:)%j = (c(36)*M(1,:)%j-c(32)*M(2,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(76),h0tab(:,76),[56,3,4],[nMT,nMT,0],3,2,wf8(:,38),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,38),G0H8(3),m3h8x8(:,14),heltab2x64(:,:,76))
  call Hloop_A_Q(ntryL,G0H8(3),56,nMT,G1H8(10),n2h8(25))
  Gcoeff(:)%j = (c(21)*M(1,:)%j-c(20)*M(2,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(77),h0tab(:,77),[32,15,16],[0,0,0],3,1,wf16(:,2))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,33),heltab2x64(:,:,77))
  call Hloop_A_Q(ntryL,G0H32(7),32,0,G1H32(5),n2h32(15))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(78),h0tab(:,78),[32,15,16],[0,0,0],3,1,wf16(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,34),heltab2x64(:,:,78))
  call Hloop_A_Q(ntryL,G0H32(8),32,0,G1H32(6),n2h32(16))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(3)*M(2,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(79),h0tab(:,79),[32,15,16],[0,0,0],3,1,wf16(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,35),heltab2x64(:,:,79))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(5)*M(2,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(80),h0tab(:,80),[32,15,16],[0,0,0],3,1,wf16(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,36),heltab2x64(:,:,80))
  Gcoeff(:)%j = (c(21)*M(1,:)%j-c(20)*M(2,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(81),h0tab(:,81),[32,15,16],[0,0,0],3,1,wf16(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(11),m3h2x32(:,37),heltab2x64(:,:,81))
  call Hloop_A_Q(ntryL,G0H32(11),32,0,G1H32(7),n2h32(17))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(82),h0tab(:,82),[32,15,16],[0,0,0],3,1,wf16(:,5))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(12),m3h2x32(:,38),heltab2x64(:,:,82))
  call Hloop_A_Q(ntryL,G0H32(12),32,0,G1H32(8),n2h32(18))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(3)*M(2,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(83),h0tab(:,83),[32,15,16],[0,0,0],3,1,wf16(:,4))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,39),heltab2x64(:,:,83))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(5)*M(2,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(84),h0tab(:,84),[32,15,16],[0,0,0],3,1,wf16(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,40),heltab2x64(:,:,84))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(9)*M(2,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(85),h0tab(:,85),[51,4,8],[nMT,0,nMT],3,1,wf16(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,6),G0H4(1),m3h16x4(:,1),heltab2x64(:,:,85))
  call Hloop_A_Q(ntryL,G0H4(1),51,nMT,G1H4(1),n2h4(17))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(86),h0tab(:,86),[51,4,8],[nMT,0,nMT],3,1,wf16(:,7))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,7),G0H4(1),m3h16x4(:,2),heltab2x64(:,:,86))
  call Hloop_A_Q(ntryL,G0H4(1),51,nMT,G1H4(2),n2h4(18))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(2,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(87),h0tab(:,87),[51,4,8],[0,nMT,0],3,1,wf16(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,6),51,G1H4(4),m3h16x4(:,3),heltab2x64(:,:,87))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(5)*M(2,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(88),h0tab(:,88),[51,4,8],[0,nMT,0],3,1,wf16(:,7))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,7),51,G1H4(9),m3h16x4(:,4),heltab2x64(:,:,88))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(9)*M(2,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(89),h0tab(:,89),[51,4,8],[nMT,0,nMT],3,1,wf16(:,8))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,8),G0H4(1),m3h16x4(:,5),heltab2x64(:,:,89))
  call Hloop_A_Q(ntryL,G0H4(1),51,nMT,G1H4(12),n2h4(19))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(90),h0tab(:,90),[51,4,8],[nMT,0,nMT],3,1,wf16(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,9),G0H4(1),m3h16x4(:,6),heltab2x64(:,:,90))
  call Hloop_A_Q(ntryL,G0H4(1),51,nMT,G1H4(13),n2h4(20))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(2,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(91),h0tab(:,91),[51,4,8],[0,nMT,0],3,1,wf16(:,8))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,8),51,G1H4(14),m3h16x4(:,7),heltab2x64(:,:,91))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(5)*M(2,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(92),h0tab(:,92),[51,4,8],[0,nMT,0],3,1,wf16(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,9),51,G1H4(15),m3h16x4(:,8),heltab2x64(:,:,92))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(4),[G1H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(5),[G1H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(2),[G1H8(1),G1H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(6),[G1H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(7),[G1H8(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(5),[G1H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(7),[G1H16(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(4),[G0H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(13),[G1H4(12),G1H4(2),G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(15),[G1H4(14),G1H4(9),G1H4(4)])
  call Hloop_AV_Q(ntryL,G1H8(4),wf4(:,1),G1H2(4),m3h4x2(:,16),heltab2x8(:,:,30))
  call Hloop_A_Q(ntryL,G1H2(4),47,0,G2H2(9),n2h2(26))
  call Hloop_AZ_Q(ntryL,G1H8(5),wf4(:,4),G1H2(3),ngZd,m3h4x2(:,17),heltab2x8(:,:,31))
  call Hloop_A_Q(ntryL,G1H2(3),47,0,G2H2(11),n2h2(27))
  call Hloop_AV_Q(ntryL,G1H8(2),wf4(:,2),G1H2(11),m3h4x2(:,18),heltab2x8(:,:,32))
  call Hloop_A_Q(ntryL,G1H2(11),47,0,G2H2(18),n2h2(28))
  call Hloop_QV_A(ntryL,G1H8(6),wf4(:,1),G1H2(10),m3h4x2(:,19),heltab2x8(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(10),55,nMT,G2H2(20),n2h2(29))
  call Hloop_QZ_A(ntryL,G1H8(7),wf4(:,4),G1H2(9),ngZu,m3h4x2(:,20),heltab2x8(:,:,34))
  call Hloop_Q_A(ntryL,G1H2(9),55,nMT,G2H2(4),n2h2(30))
  call Hloop_AV_Q(ntryL,G1H16(5),wf4(:,1),G1H4(12),m3h4x4(:,9),heltab2x16(:,:,19))
  call Hloop_A_Q(ntryL,G1H4(12),51,0,G2H4(6),n2h4(21))
  call Hloop_AV_Q(ntryL,G1H16(2),wf4(:,1),G1H4(2),m3h4x4(:,10),heltab2x16(:,:,20))
  call Hloop_A_Q(ntryL,G1H4(2),51,nMT,G2H4(3),n2h4(22))
  call Hloop_QV_A(ntryL,G1H16(7),wf4(:,1),G1H4(1),m3h4x4(:,11),heltab2x16(:,:,21))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(1),n2h4(23))
  call Hloop_QV_A(ntryL,G1H16(4),wf4(:,1),G1H4(14),m3h4x4(:,12),heltab2x16(:,:,22))
  call Hloop_Q_A(ntryL,G1H4(14),51,nMT,G2H4(5),n2h4(24))
  call Hloop_AV_Q(ntryL,G1H16(6),wf4(:,1),G1H4(9),m3h4x4(:,13),heltab2x16(:,:,23))
  call Hloop_A_Q(ntryL,G1H4(9),51,nMB,G2H4(2),n2h4(25))
  call Hloop_QV_A(ntryL,G1H16(8),wf4(:,1),G1H4(4),m3h4x4(:,14),heltab2x16(:,:,24))
  call Hloop_Q_A(ntryL,G1H4(4),51,nMB,G2H4(4),n2h4(26))
  call Hloop_AZ_Q(ntryL,G1H16(9),wf4(:,4),G1H4(12),ngZu,m3h4x4(:,15),heltab2x16(:,:,25))
  call Hloop_A_Q(ntryL,G1H4(12),51,0,G2H4(7),n2h4(27))
  call Hloop_AZ_Q(ntryL,G1H16(10),wf4(:,4),G1H4(2),ngZu,m3h4x4(:,16),heltab2x16(:,:,26))
  call Hloop_A_Q(ntryL,G1H4(2),51,nMT,G2H4(8),n2h4(28))
  call Hloop_QZ_A(ntryL,G1H16(11),wf4(:,4),G1H4(1),ngZu,m3h4x4(:,17),heltab2x16(:,:,27))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(9),n2h4(29))
  call Hloop_QZ_A(ntryL,G1H16(12),wf4(:,4),G1H4(14),ngZu,m3h4x4(:,18),heltab2x16(:,:,28))
  call Hloop_Q_A(ntryL,G1H4(14),51,nMT,G2H4(10),n2h4(30))
  call Hloop_AZ_Q(ntryL,G1H16(13),wf4(:,4),G1H4(9),ngZd,m3h4x4(:,19),heltab2x16(:,:,29))
  call Hloop_A_Q(ntryL,G1H4(9),51,0,G2H4(11),n2h4(31))
  call Hloop_AZ_Q(ntryL,G1H16(14),wf4(:,4),G1H4(4),ngZd,m3h4x4(:,20),heltab2x16(:,:,30))
  call Hloop_A_Q(ntryL,G1H4(4),51,nMB,G2H4(12),n2h4(32))
  call Hloop_QZ_A(ntryL,G1H16(15),wf4(:,4),G1H4(12),ngZd,m3h4x4(:,21),heltab2x16(:,:,31))
  call Hloop_Q_A(ntryL,G1H4(12),51,0,G2H4(13),n2h4(33))
  call Hloop_QZ_A(ntryL,G1H16(16),wf4(:,4),G1H4(2),ngZd,m3h4x4(:,22),heltab2x16(:,:,32))
  call Hloop_Q_A(ntryL,G1H4(2),51,nMB,G2H4(14),n2h4(34))
  call Hloop_AV_Q(ntryL,G1H32(1),wf4(:,2),G1H8(11),m3h4x8(:,11),heltab2x32(:,:,27))
  call Hloop_A_Q(ntryL,G1H8(11),44,0,G2H8(2),n2h8(26))
  call Hloop_AV_Q(ntryL,G1H32(2),wf4(:,2),G1H8(12),m3h4x8(:,12),heltab2x32(:,:,28))
  call Hloop_A_Q(ntryL,G1H8(12),44,0,G2H8(5),n2h8(27))
  call Hloop_UV_W(ntryL,G0H32(1),32,wf4(:,2),12,G1H8(14),m3h4x8(:,13),heltab2x32(:,:,29))
  call Hloop_UV_W(ntryL,G0H32(2),32,wf4(:,2),12,G1H8(15),m3h4x8(:,14),heltab2x32(:,:,30))
  call Hloop_UV_W(ntryL,G0H8(4),35,wf4(:,2),12,G1H2(15),m3h4x2(:,21),heltab2x8(:,:,35))
  call Hloop_AV_Q(ntryL,G1H32(3),wf4(:,1),G1H8(16),m3h4x8(:,15),heltab2x32(:,:,31))
  call Hloop_A_Q(ntryL,G1H8(16),35,0,G2H8(1),n2h8(28))
  call Hloop_AZ_Q(ntryL,G1H32(4),wf4(:,4),G1H8(17),ngZd,m3h4x8(:,16),heltab2x32(:,:,32))
  call Hloop_A_Q(ntryL,G1H8(17),35,0,G2H8(3),n2h8(29))
  call Hloop_AQ_V(ntryL,G1H16(17),wf8(:,12),G1H2(16),m3h8x2(:,5),heltab2x16(:,:,33))
  call Hloop_AQ_V(ntryL,G1H16(18),wf8(:,14),G1H2(17),m3h8x2(:,6),heltab2x16(:,:,34))
  call Hloop_VQ_A(ntryL,G1H16(19),wf8(:,12),G1H2(6),m3h8x2(:,7),heltab2x16(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(6),55,nMT,G2H2(7),n2h2(31))
  call Hloop_VQ_A(ntryL,G1H16(20),wf8(:,14),G1H2(12),m3h8x2(:,8),heltab2x16(:,:,36))
  call Hloop_Q_A(ntryL,G1H2(12),55,nMT,G2H2(1),n2h2(32))
  call Hloop_AQ_V(ntryL,G1H16(21),ex3(:),G1H8(19),m3h2x8(:,7),heltab2x16(:,:,37))
  call Hloop_AQ_V(ntryL,G1H16(22),ex3(:),G1H8(20),m3h2x8(:,8),heltab2x16(:,:,38))
  call Hloop_VQ_A(ntryL,G1H16(23),ex3(:),G1H8(21),m3h2x8(:,9),heltab2x16(:,:,39))
  call Hloop_Q_A(ntryL,G1H8(21),52,nMT,G2H8(4),n2h8(30))
  call Hloop_VQ_A(ntryL,G1H16(24),ex3(:),G1H8(22),m3h2x8(:,10),heltab2x16(:,:,40))
  call Hloop_Q_A(ntryL,G1H8(22),52,nMT,G2H8(6),n2h8(31))
  call Hloop_AV_Q(ntryL,G1H8(9),wf4(:,1),G1H2(8),m3h4x2(:,22),heltab2x8(:,:,36))
  call Hloop_A_Q(ntryL,G1H2(8),59,nMT,G2H2(2),n2h2(33))
  call Hloop_AZ_Q(ntryL,G1H8(10),wf4(:,4),G1H2(13),ngZu,m3h4x2(:,23),heltab2x8(:,:,37))
  call Hloop_A_Q(ntryL,G1H2(13),59,nMT,G2H2(3),n2h2(34))
  call Hloop_AV_Q(ntryL,G1H32(5),wf16(:,2),G1H2(5),m3h16x2(:,1),heltab2x32(:,:,33))
  call Hloop_A_Q(ntryL,G1H2(5),47,0,G2H2(5),n2h2(35))
  call Hloop_AV_Q(ntryL,G1H32(6),wf16(:,3),G1H2(4),m3h16x2(:,2),heltab2x32(:,:,34))
  call Hloop_A_Q(ntryL,G1H2(4),47,0,G2H2(6),n2h2(36))
  call Hloop_UV_W(ntryL,G0H32(9),32,wf16(:,2),15,G1H2(3),m3h16x2(:,3),heltab2x32(:,:,35))
  call Hloop_UV_W(ntryL,G0H32(10),32,wf16(:,3),15,G1H2(11),m3h16x2(:,4),heltab2x32(:,:,36))
  call Hloop_AV_Q(ntryL,G1H32(7),wf16(:,4),G1H2(10),m3h16x2(:,5),heltab2x32(:,:,37))
  call Hloop_A_Q(ntryL,G1H2(10),47,0,G2H2(8),n2h2(37))
  call Hloop_AV_Q(ntryL,G1H32(8),wf16(:,5),G1H2(9),m3h16x2(:,6),heltab2x32(:,:,38))
  call Hloop_A_Q(ntryL,G1H2(9),47,0,G2H2(12),n2h2(38))
  call Hloop_UV_W(ntryL,G0H32(3),32,wf16(:,4),15,G1H2(6),m3h16x2(:,7),heltab2x32(:,:,39))
  call Hloop_UV_W(ntryL,G0H32(4),32,wf16(:,5),15,G1H2(12),m3h16x2(:,8),heltab2x32(:,:,40))
  call Hloop_AQ_V(ntryL,G1H4(13),ex3(:),G1H2(8),m3h2x2(:,21),heltab2x4(:,:,24))
  call Hloop_VQ_A(ntryL,G1H4(15),ex3(:),G1H2(13),m3h2x2(:,22),heltab2x4(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(13),55,nMT,G2H2(14),n2h2(39))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G2H2(8),G2H2(6),G2H2(5),G2H2(16),G2H2(13) &
    ,G2H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G2H4(7),G2H4(6)])
call HGT_w2_OLR(G1H4(7),1,1,4)
call HGT_w2_invQ_OLR(G1H4(7),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G2H2(7),G2H2(22),G2H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(8),[G1H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(17),[G1H2(16),G1H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(11),[G2H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G2H2(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G2H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G2H4(9),G2H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(10),[G2H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G2H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(14),[G2H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(3),[G2H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G2H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(12),[G1H2(6),G1H2(11),G1H2(3)])
call HGT_w2_OLR(G1H4(5),1,1,4)
call HGT_w2_invQ_OLR(G1H4(5),2,5,4)
  call Hloop_AV_Q(ntryL,G1H4(5),wf4(:,1),G1H1(1),m3h4x1(:,4),heltab2x4(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(4),n2h1(28))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(12),ex5(:),G2tensor(2),m3h2x1(:,39),heltab2x2(:,:,39))
call HGT_w2_OLR(G1H4(6),1,1,4)
call HGT_w2_invQ_OLR(G1H4(6),2,5,4)
  call Hloop_AZ_Q(ntryL,G1H4(6),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,5),heltab2x4(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(9),n2h1(29))
  call Hloop_AV_Q(ntryL,G2H4(11),wf4(:,2),G2H1(1),m3h4x1(:,6),heltab2x4(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(1),n2h1(30))
call HGT_w2_OLR(G1H4(11),1,1,4)
call HGT_w2_invQ_OLR(G1H4(11),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(11),wf4(:,1),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(21),n2h1(31))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(1),ex4(:),G2tensor(23),m3h2x1(:,40),heltab2x2(:,:,40))
call HGT_w2_OLR(G1H4(3),1,1,4)
call HGT_w2_invQ_OLR(G1H4(3),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(3),wf4(:,4),G1H1(1),ngZu,m3h4x1(:,8),heltab2x4(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(33),n2h1(32))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(10),51,wf4(:,2),12,G2tensor(6),m3h4x1(:,9),heltab2x4(:,:,31))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(8),51,wf4(:,2),12,G2tensor(7),m3h4x1(:,10),heltab2x4(:,:,32))
  call Hloop_VA_Q(ntryL,G1H2(8),ex4(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(31),n2h1(33))
  call Hloop_VA_Q(ntryL,G1H2(17),ex4(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(10),n2h1(34))
  call Hloop_VQ_A(ntryL,G1H2(1),ex3(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(1),n2h1(35))
  call Hloop_VQ_A(ntryL,G1H2(2),ex3(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(17),n2h1(36))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(11),ex5(:),G2tensor(18),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(18),ex5(:),G2tensor(3),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(4),ex4(:),G2tensor(5),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hloop_AV_Q(ntryL,G2H4(8),wf4(:,2),G2H1(1),m3h4x1(:,11),heltab2x4(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(2),n2h1(37))
  call Hloop_QV_A(ntryL,G2H4(13),wf4(:,2),G2H1(1),m3h4x1(:,12),heltab2x4(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(3),n2h1(38))
  call Hloop_QV_A(ntryL,G2H4(10),wf4(:,2),G2H1(1),m3h4x1(:,13),heltab2x4(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(4),n2h1(39))
  call Hloop_AV_Q(ntryL,G2H4(12),wf4(:,2),G2H1(1),m3h4x1(:,14),heltab2x4(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(5),n2h1(40))
  call Hloop_QV_A(ntryL,G2H4(14),wf4(:,2),G2H1(1),m3h4x1(:,15),heltab2x4(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(6),n2h1(41))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(2),wf8(:,3),G2tensor(19),m3h8x1(:,5),heltab2x8(:,:,38))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(5),wf8(:,5),G2tensor(20),m3h8x1(:,6),heltab2x8(:,:,39))
  call Hloop_VQ_A(ntryL,G1H8(14),wf8(:,3),G1H1(1),m3h8x1(:,7),heltab2x8(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(8),n2h1(42))
  call Hloop_VQ_A(ntryL,G1H8(15),wf8(:,5),G1H1(1),m3h8x1(:,8),heltab2x8(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(43))
  call Hloop_VQ_A(ntryL,G1H2(15),ex5(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(12),n2h1(44))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(3),wf8(:,8),G2tensor(13),m3h8x1(:,9),heltab2x8(:,:,42))
  call Hloop_VA_Q(ntryL,G1H8(19),wf8(:,35),G1H1(1),m3h8x1(:,10),heltab2x8(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(14),n2h1(45))
  call Hloop_VA_Q(ntryL,G1H8(20),wf8(:,36),G1H1(1),m3h8x1(:,11),heltab2x8(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(15),n2h1(46))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(4),wf8(:,35),G2tensor(16),m3h8x1(:,12),heltab2x8(:,:,45))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(6),wf8(:,36),G2tensor(22),m3h8x1(:,13),heltab2x8(:,:,46))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(3),ex3(:),G2tensor(24),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hloop_VQ_A(ntryL,G1H2(12),ex5(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(25),n2h1(47))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(14),ex4(:),G2tensor(26),m3h2x1(:,51),heltab2x2(:,:,51))
  call ol_merge_tensors(G2tensor(11),[G2tensor(8),G2tensor(20),G2tensor(19),G2tensor(28),G1tensor(120),G1tensor(104),G1tensor(99) &
    ,G0tensor(120),G0tensor(104),G0tensor(99)])
  call ol_merge_tensors(G2tensor(13),[G2tensor(35),G2tensor(30),G1tensor(125),G1tensor(65),G1tensor(45),G1tensor(12),G0tensor(125) &
    ,G0tensor(65),G0tensor(45),G0tensor(5)])
  call ol_merge_tensors(G2tensor(22),[G2tensor(16),G2tensor(32),G1tensor(92),G1tensor(16),G0tensor(92),G0tensor(20)])
  call ol_merge_tensors(G2tensor(18),[G2tensor(34),G1tensor(118),G1tensor(47),G1tensor(27),G1tensor(7),G0tensor(118),G0tensor(47) &
    ,G0tensor(27),G0tensor(2)])
  call ol_merge_tensors(G2tensor(24),[G2tensor(37),G1tensor(127),G1tensor(67),G1tensor(18),G0tensor(127),G0tensor(67) &
    ,G0tensor(8)])
  call ol_merge_tensors(G3tensor(4),[G3tensor(2),G2tensor(41),G2tensor(38),G1tensor(135),G1tensor(130),G0tensor(135) &
    ,G0tensor(130)])
  call ol_merge_tensors(G2tensor(5),[G2tensor(40),G1tensor(132),G1tensor(82),G1tensor(11),G0tensor(132),G0tensor(82) &
    ,G0tensor(18)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(55),G1tensor(35),G1tensor(13),G0tensor(55),G0tensor(35),G0tensor(3)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(60),G1tensor(40),G1tensor(19),G0tensor(60),G0tensor(40),G0tensor(4)])
  call ol_merge_tensors(G1tensor(3),[G1tensor(14),G0tensor(12),G0tensor(7)])
  call ol_merge_tensors(G1tensor(72),[G1tensor(20),G0tensor(72),G0tensor(9)])
  call ol_merge_tensors(G1tensor(77),[G1tensor(24),G0tensor(77),G0tensor(10)])
  call ol_merge_tensors(G1tensor(70),[G1tensor(4),G0tensor(70),G0tensor(13)])
  call ol_merge_tensors(G1tensor(75),[G1tensor(5),G0tensor(75),G0tensor(14)])
  call ol_merge_tensors(G1tensor(105),[G1tensor(80),G1tensor(8),G0tensor(105),G0tensor(80),G0tensor(15)])
  call ol_merge_tensors(G2tensor(33),[G2tensor(21),G1tensor(21),G1tensor(10),G0tensor(22),G0tensor(17)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(87),G1tensor(15),G0tensor(87),G0tensor(19)])
  call ol_merge_tensors(G1tensor(85),[G1tensor(22),G0tensor(85),G0tensor(23)])
  call ol_merge_tensors(G1tensor(90),[G1tensor(23),G0tensor(90),G0tensor(24)])
  call ol_merge_tensors(G1tensor(100),[G1tensor(95),G1tensor(25),G0tensor(100),G0tensor(95),G0tensor(25)])
  call ol_merge_tensors(G1tensor(32),[G1tensor(28),G0tensor(32),G0tensor(28)])
  call ol_merge_tensors(G1tensor(37),[G1tensor(29),G0tensor(37),G0tensor(29)])
  call ol_merge_tensors(G1tensor(42),[G1tensor(30),G0tensor(42),G0tensor(30)])
  call ol_merge_tensors(G2tensor(26),[G1tensor(112),G1tensor(97),G1tensor(38),G1tensor(33),G0tensor(112),G0tensor(97),G0tensor(38) &
    ,G0tensor(33)])
  call ol_merge_tensors(G1tensor(43),[G1tensor(34),G0tensor(43),G0tensor(34)])
  call ol_merge_tensors(G1tensor(44),[G1tensor(39),G0tensor(44),G0tensor(39)])
  call ol_merge_tensors(G1tensor(52),[G1tensor(48),G0tensor(52),G0tensor(48)])
  call ol_merge_tensors(G1tensor(57),[G1tensor(49),G0tensor(57),G0tensor(49)])
  call ol_merge_tensors(G1tensor(62),[G1tensor(50),G0tensor(62),G0tensor(50)])
  call ol_merge_tensors(G1tensor(107),[G1tensor(102),G1tensor(58),G1tensor(53),G0tensor(107),G0tensor(102),G0tensor(58) &
    ,G0tensor(53)])
  call ol_merge_tensors(G1tensor(63),[G1tensor(54),G0tensor(63),G0tensor(54)])
  call ol_merge_tensors(G1tensor(64),[G1tensor(59),G0tensor(64),G0tensor(59)])
  call ol_merge_tensors(G1tensor(108),[G1tensor(73),G1tensor(68),G0tensor(108),G0tensor(73),G0tensor(68)])
  call ol_merge_tensors(G1tensor(78),[G1tensor(69),G0tensor(78),G0tensor(69)])
  call ol_merge_tensors(G2tensor(25),[G2tensor(2),G1tensor(124),G1tensor(119),G1tensor(94),G1tensor(89),G1tensor(79),G1tensor(74) &
    ,G0tensor(124),G0tensor(119),G0tensor(94),G0tensor(89),G0tensor(79),G0tensor(74)])
  call ol_merge_tensors(G1tensor(113),[G1tensor(88),G1tensor(83),G0tensor(113),G0tensor(88),G0tensor(83)])
  call ol_merge_tensors(G1tensor(93),[G1tensor(84),G0tensor(93),G0tensor(84)])
  call ol_merge_tensors(G1tensor(98),[G0tensor(98)])
  call ol_merge_tensors(G1tensor(103),[G0tensor(103)])
  call ol_merge_tensors(G2tensor(12),[G2tensor(3),G1tensor(123),G1tensor(114),G1tensor(109),G0tensor(123),G0tensor(114) &
    ,G0tensor(109)])
  call ol_merge_tensors(G1tensor(110),[G0tensor(110)])
  call ol_merge_tensors(G1tensor(115),[G0tensor(115)])
  call ol_merge_tensors(G2tensor(9),[G2tensor(4),G1tensor(117),G0tensor(117)])
  call ol_merge_tensors(G3tensor(3),[G3tensor(1),G1tensor(122),G0tensor(122)])
  call ol_merge_tensors(G2tensor(31),[G1tensor(128),G0tensor(128)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(129),G0tensor(129)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(133),G0tensor(133)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(134),G0tensor(134)])
  call ol_merge_tensors(G3tensor(6),[G3tensor(5)])
  call ol_merge_tensors(G2tensor(15),[G2tensor(14)])
  call TI_triangle_red(G2tensor(11),RedBasis(32),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1)
  call TI_triangle_red(G2tensor(13),RedBasis(1),mass3set(:,1),G0tensor(21),G0tensor(26),G0tensor(31),G0tensor(36),M2L1R1)
  call TI_triangle_red(G2tensor(22),RedBasis(35),mass3set(:,2),G0tensor(41),G0tensor(46),G0tensor(51),G0tensor(56),M2L1R1,[nMT], &
    G0tensor(61))
  call TI_triangle_red(G2tensor(18),RedBasis(33),mass3set(:,1),G0tensor(66),G0tensor(71),G0tensor(76),G0tensor(81),M2L1R1)
  call TI_triangle_red(G2tensor(24),RedBasis(41),mass3set(:,3),G0tensor(86),G0tensor(91),G0tensor(96),G0tensor(101),M2L1R1,[nMT], &
    G0tensor(106))
  call TI_triangle_red(G3tensor(4),RedBasis(38),mass3set(:,4),G0tensor(111),G0tensor(116),G0tensor(121), &
    G0tensor(126),M2L1R1,[nMT],G0tensor(131))
  call TI_triangle_red(G2tensor(5),RedBasis(37),mass3set(:,3),G0tensor(120),G0tensor(104),G0tensor(99),G0tensor(125),M2L1R1,[nMT], &
    G0tensor(65))
  call TI_triangle_red(G2tensor(6),RedBasis(4),mass3set(:,1),G0tensor(45),G0tensor(5),G0tensor(92),G0tensor(20),M2L1R1)
  call TI_triangle_red(G2tensor(7),RedBasis(2),mass3set(:,1),G0tensor(118),G0tensor(47),G0tensor(27),G0tensor(2),M2L1R1)
  call TI_triangle_red(G2tensor(33),RedBasis(50),mass3set(:,5),G0tensor(127),G0tensor(67),G0tensor(8),G0tensor(135),M2L1R1,[nMT], &
    G0tensor(130))
  call TI_triangle_red(G2tensor(23),RedBasis(36),mass3set(:,2),G0tensor(132),G0tensor(82),G0tensor(18),G0tensor(55),M2L1R1,[nMT], &
    G0tensor(35))
  call TI_triangle_red(G2tensor(26),RedBasis(6),mass3set(:,2),G0tensor(3),G0tensor(60),G0tensor(40),G0tensor(4),M2L1R1,[nMT], &
    G0tensor(12))
  call TI_triangle_red(G2tensor(25),RedBasis(12),mass3set(:,1),G0tensor(7),G0tensor(72),G0tensor(9),G0tensor(77),M2L1R1)
  call TI_triangle_red(G2tensor(12),RedBasis(34),mass3set(:,1),G0tensor(10),G0tensor(70),G0tensor(13),G0tensor(75),M2L1R1)
  call TI_triangle_red(G2tensor(9),RedBasis(51),mass3set(:,1),G0tensor(14),G0tensor(105),G0tensor(80),G0tensor(15),M2L1R1)
  call TI_triangle_red(G3tensor(3),RedBasis(38),mass3set(:,1),G0tensor(22),G0tensor(17),G0tensor(87),G0tensor(19),M2L1R1)
  call TI_triangle_red(G2tensor(31),RedBasis(6),mass3set(:,6),G0tensor(85),G0tensor(23),G0tensor(90),G0tensor(24),M2L1R1,[nMT], &
    G0tensor(100))
  call TI_triangle_red(G2tensor(10),RedBasis(36),mass3set(:,6),G0tensor(95),G0tensor(25),G0tensor(32),G0tensor(28),M2L1R1,[nMT], &
    G0tensor(37))
  call TI_triangle_red(G2tensor(1),RedBasis(9),mass3set(:,6),G0tensor(29),G0tensor(42),G0tensor(30),G0tensor(112),M2L1R1,[nMT], &
    G0tensor(97))
  call TI_triangle_red(G2tensor(17),RedBasis(39),mass3set(:,6),G0tensor(38),G0tensor(33),G0tensor(43),G0tensor(34),M2L1R1,[nMT], &
    G0tensor(44))
  call TI_triangle_red(G3tensor(6),RedBasis(38),mass3set(:,7),G0tensor(39),G0tensor(52),G0tensor(48),G0tensor(57),M2L1R1,[nMB], &
    G0tensor(49))
  call TI_triangle_red(G2tensor(15),RedBasis(35),mass3set(:,6),G0tensor(62),G0tensor(50),G0tensor(107),G0tensor(102),M2L1R1,[nMT], &
    G0tensor(58))
  call TI_triangle_red(G1tensor(3),RedBasis(52),mass3set(:,5),G0tensor(53),G0tensor(63),G0tensor(54),G0tensor(64),M2L1R1,[nMT], &
    G0tensor(59))
  call TI_triangle_red(G1tensor(72),RedBasis(39),mass3set(:,2),G0tensor(108),G0tensor(73),G0tensor(68),G0tensor(78),M2L1R1,[nMT], &
    G0tensor(69))
  call TI_triangle_red(G1tensor(77),RedBasis(40),mass3set(:,2),G0tensor(124),G0tensor(119),G0tensor(94),G0tensor(89),M2L1R1,[nMT], &
    G0tensor(79))
  call TI_triangle_red(G1tensor(70),RedBasis(13),mass3set(:,3),G0tensor(74),G0tensor(113),G0tensor(88),G0tensor(83),M2L1R1,[nMT], &
    G0tensor(93))
  call TI_triangle_red(G1tensor(75),RedBasis(11),mass3set(:,2),G0tensor(84),G0tensor(98),G0tensor(103),G0tensor(123),M2L1R1,[nMT], &
    G0tensor(114))
  call TI_triangle_red(G1tensor(105),RedBasis(10),mass3set(:,2),G0tensor(109),G0tensor(110),G0tensor(115), &
    G0tensor(117),M2L1R1,[nMT],G0tensor(122))
  call TI_triangle_red(G1tensor(85),RedBasis(18),mass3set(:,3),G0tensor(128),G0tensor(129),G0tensor(133), &
    G0tensor(134),M2L1R1,[nMT],G0tensor(136))
  call TI_triangle_red(G1tensor(90),RedBasis(17),mass3set(:,2),G0tensor(137),G0tensor(138),G0tensor(139), &
    G0tensor(140),M2L1R1,[nMT],G0tensor(141))
  call TI_triangle_red(G1tensor(100),RedBasis(16),mass3set(:,2),G0tensor(142),G0tensor(143),G0tensor(144), &
    G0tensor(145),M2L1R1,[nMT],G0tensor(146))
  call TI_triangle_red(G1tensor(32),RedBasis(43),mass3set(:,8),G0tensor(147),G0tensor(148),G0tensor(149), &
    G0tensor(150),M2L1R1,[nMT],G0tensor(151))
  call TI_triangle_red(G1tensor(37),RedBasis(42),mass3set(:,8),G0tensor(152),G0tensor(153),G0tensor(154), &
    G0tensor(155),M2L1R1,[nMT],G0tensor(156))
  call TI_triangle_red(G1tensor(42),RedBasis(13),mass3set(:,8),G0tensor(157),G0tensor(158),G0tensor(159), &
    G0tensor(160),M2L1R1,[nMT],G0tensor(161))
  call TI_triangle_red(G1tensor(43),RedBasis(5),mass3set(:,2),G0tensor(162),G0tensor(163),G0tensor(164), &
    G0tensor(165),M2L1R1,[nMT],G0tensor(166))
  call TI_triangle_red(G1tensor(44),RedBasis(3),mass3set(:,2),G0tensor(167),G0tensor(168),G0tensor(169), &
    G0tensor(170),M2L1R1,[nMT],G0tensor(171))
  call TI_triangle_red(G1tensor(52),RedBasis(45),mass3set(:,8),G0tensor(172),G0tensor(173),G0tensor(174), &
    G0tensor(175),M2L1R1,[nMT],G0tensor(176))
  call TI_triangle_red(G1tensor(57),RedBasis(44),mass3set(:,8),G0tensor(177),G0tensor(178),G0tensor(179), &
    G0tensor(180),M2L1R1,[nMT],G0tensor(181))
  call TI_triangle_red(G1tensor(62),RedBasis(18),mass3set(:,8),G0tensor(182),G0tensor(183),G0tensor(184), &
    G0tensor(185),M2L1R1,[nMT],G0tensor(186))
  call TI_triangle_red(G1tensor(107),RedBasis(9),mass3set(:,2),G0tensor(187),G0tensor(188),G0tensor(189), &
    G0tensor(190),M2L1R1,[nMT],G0tensor(191))
  call TI_triangle_red(G1tensor(63),RedBasis(8),mass3set(:,2),G0tensor(192),G0tensor(193),G0tensor(194), &
    G0tensor(195),M2L1R1,[nMT],G0tensor(196))
  call TI_triangle_red(G1tensor(64),RedBasis(7),mass3set(:,2),G0tensor(197),G0tensor(198),G0tensor(199), &
    G0tensor(200),M2L1R1,[nMT],G0tensor(201))
  call TI_triangle_red(G1tensor(108),RedBasis(15),mass3set(:,9),G0tensor(202),G0tensor(203),G0tensor(204), &
    G0tensor(205),M2L1R1,[nMT],G0tensor(206))
  call TI_triangle_red(G1tensor(78),RedBasis(14),mass3set(:,9),G0tensor(207),G0tensor(208),G0tensor(209), &
    G0tensor(210),M2L1R1,[nMT],G0tensor(211))
  call TI_triangle_red(G1tensor(113),RedBasis(20),mass3set(:,9),G0tensor(212),G0tensor(213),G0tensor(214), &
    G0tensor(215),M2L1R1,[nMT],G0tensor(216))
  call TI_triangle_red(G1tensor(93),RedBasis(19),mass3set(:,9),G0tensor(217),G0tensor(218),G0tensor(219), &
    G0tensor(220),M2L1R1,[nMT],G0tensor(221))
  call TI_triangle_red(G1tensor(98),RedBasis(46),mass3set(:,9),G0tensor(222),G0tensor(223),G0tensor(224), &
    G0tensor(225),M2L1R1,[nMT],G0tensor(226))
  call TI_triangle_red(G1tensor(103),RedBasis(47),mass3set(:,9),G0tensor(227),G0tensor(228),G0tensor(229), &
    G0tensor(230),M2L1R1,[nMT],G0tensor(231))
  call TI_triangle_red(G1tensor(110),RedBasis(48),mass3set(:,2),G0tensor(232),G0tensor(233),G0tensor(234), &
    G0tensor(235),M2L1R1,[nMT],G0tensor(236))
  call TI_triangle_red(G1tensor(115),RedBasis(49),mass3set(:,2),G0tensor(237),G0tensor(238),G0tensor(239), &
    G0tensor(240),M2L1R1,[nMT],G0tensor(241))
  call ol_merge_tensors(T0sum(28),[G0tensor(1)])
  call ol_merge_tensors(T0sum(29),[G0tensor(21)])
  call ol_merge_tensors(T0sum(30),[G0tensor(41)])
  call ol_merge_tensors(T0sum(31),[G0tensor(66)])
  call ol_merge_tensors(T0sum(32),[G0tensor(86)])
  call ol_merge_tensors(T0sum(33),[G0tensor(111)])
  call ol_merge_tensors(T0sum(34),[G0tensor(120)])
  call ol_merge_tensors(T0sum(35),[G0tensor(45)])
  call ol_merge_tensors(T0sum(36),[G0tensor(118)])
  call ol_merge_tensors(T0sum(37),[G0tensor(53)])
  call ol_merge_tensors(T0sum(38),[G0tensor(108)])
  call ol_merge_tensors(T0sum(39),[G0tensor(124)])
  call ol_merge_tensors(T0sum(40),[G0tensor(74)])
  call ol_merge_tensors(T0sum(41),[G0tensor(84)])
  call ol_merge_tensors(T0sum(42),[G0tensor(109)])
  call ol_merge_tensors(T0sum(43),[G0tensor(127)])
  call ol_merge_tensors(T0sum(44),[G0tensor(132)])
  call ol_merge_tensors(T0sum(45),[G0tensor(128)])
  call ol_merge_tensors(T0sum(46),[G0tensor(137)])
  call ol_merge_tensors(T0sum(47),[G0tensor(142)])
  call ol_merge_tensors(T0sum(48),[G0tensor(147)])
  call ol_merge_tensors(T0sum(49),[G0tensor(152)])
  call ol_merge_tensors(T0sum(50),[G0tensor(157)])
  call ol_merge_tensors(T0sum(51),[G0tensor(3)])
  call ol_merge_tensors(T0sum(52),[G0tensor(162)])
  call ol_merge_tensors(T0sum(53),[G0tensor(167)])
  call ol_merge_tensors(T0sum(54),[G0tensor(172)])
  call ol_merge_tensors(T0sum(55),[G0tensor(177)])
  call ol_merge_tensors(T0sum(56),[G0tensor(182)])
  call ol_merge_tensors(T0sum(57),[G0tensor(187)])
  call ol_merge_tensors(T0sum(58),[G0tensor(192)])
  call ol_merge_tensors(T0sum(59),[G0tensor(197)])
  call ol_merge_tensors(T0sum(60),[G0tensor(202)])
  call ol_merge_tensors(T0sum(61),[G0tensor(207)])
  call ol_merge_tensors(T0sum(62),[G0tensor(7)])
  call ol_merge_tensors(T0sum(63),[G0tensor(212)])
  call ol_merge_tensors(T0sum(64),[G0tensor(217)])
  call ol_merge_tensors(T0sum(65),[G0tensor(222)])
  call ol_merge_tensors(T0sum(66),[G0tensor(227)])
  call ol_merge_tensors(T0sum(67),[G0tensor(10)])
  call ol_merge_tensors(T0sum(68),[G0tensor(232)])
  call ol_merge_tensors(T0sum(69),[G0tensor(237)])
  call ol_merge_tensors(T0sum(70),[G0tensor(14)])
  call ol_merge_tensors(T0sum(71),[G0tensor(22)])
  call ol_merge_tensors(T0sum(72),[G0tensor(85)])
  call ol_merge_tensors(T0sum(73),[G0tensor(95)])
  call ol_merge_tensors(T0sum(74),[G0tensor(29)])
  call ol_merge_tensors(T0sum(75),[G0tensor(38)])
  call ol_merge_tensors(T0sum(76),[G0tensor(39)])
  call ol_merge_tensors(T0sum(77),[G0tensor(62)])
  Gcoeff(:)%j = (c(16)*M(1,:)%j-c(12)*M(2,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(93),h0tab(:,93),[44,19],[0,0],2,2,wf8(:,26),wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,26),G0H8(1),m3h8x8(:,15),heltab2x64(:,:,93))
  call Hloop_A_Q(ntryL,G0H8(1),44,0,G1H8(24),n2h8(32))
  Gcoeff(:)%j = (c(36)*M(1,:)%j-c(32)*M(2,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(94),h0tab(:,94),[44,19],[0,0],2,2,wf8(:,26),wf8(:,5))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,26),G0H8(3),m3h8x8(:,16),heltab2x64(:,:,94))
  call Hloop_A_Q(ntryL,G0H8(3),44,0,G1H8(25),n2h8(33))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)+c(40)*M(2,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(95),h0tab(:,95),[51,12],[0,0],2,2,wf16(:,6),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,6),G0H4(1),m3h16x4(:,9),heltab2x64(:,:,95))
  call Hloop_Q_A(ntryL,G0H4(1),51,0,G1H4(1),n2h4(35))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)+c(38)*M(2,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(96),h0tab(:,96),[51,12],[nMT,nMT],2,2,wf16(:,6),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,6),G0H4(1),m3h16x4(:,10),heltab2x64(:,:,96))
  call Hloop_Q_A(ntryL,G0H4(1),51,nMT,G1H4(14),n2h4(36))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)+c(40)*M(2,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(97),h0tab(:,97),[51,12],[0,0],2,2,wf16(:,6),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,6),G0H4(1),m3h16x4(:,11),heltab2x64(:,:,97))
  call Hloop_Q_A(ntryL,G0H4(1),51,0,G1H4(9),n2h4(37))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)+c(38)*M(2,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(98),h0tab(:,98),[51,12],[nMB,nMB],2,2,wf16(:,6),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,6),G0H4(1),m3h16x4(:,12),heltab2x64(:,:,98))
  call Hloop_Q_A(ntryL,G0H4(1),51,nMB,G1H4(4),n2h4(38))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)+c(46)*M(2,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(99),h0tab(:,99),[51,12],[0,0],2,2,wf16(:,7),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,7),G0H4(1),m3h16x4(:,13),heltab2x64(:,:,99))
  call Hloop_Q_A(ntryL,G0H4(1),51,0,G1H4(12),n2h4(39))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)+c(42)*M(2,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(100),h0tab(:,100),[51,12],[nMT,nMT],2,2,wf16(:,7),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,7),G0H4(1),m3h16x4(:,14),heltab2x64(:,:,100))
  call Hloop_Q_A(ntryL,G0H4(1),51,nMT,G1H4(2),n2h4(40))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)+c(46)*M(2,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(101),h0tab(:,101),[51,12],[0,0],2,2,wf16(:,7),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,7),G0H4(1),m3h16x4(:,15),heltab2x64(:,:,101))
  call Hloop_Q_A(ntryL,G0H4(1),51,0,G1H4(13),n2h4(41))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)+c(42)*M(2,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(102),h0tab(:,102),[51,12],[nMB,nMB],2,2,wf16(:,7),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,7),G0H4(1),m3h16x4(:,16),heltab2x64(:,:,102))
  call Hloop_Q_A(ntryL,G0H4(1),51,nMB,G1H4(15),n2h4(42))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)+c(14)*M(2,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(103),h0tab(:,103),[51,12],[0,0],2,2,wf16(:,6),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,6),51,G1H4(7),m3h16x4(:,17),heltab2x64(:,:,103))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)+c(34)*M(2,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(104),h0tab(:,104),[51,12],[0,0],2,2,wf16(:,7),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,7),51,G1H4(5),m3h16x4(:,18),heltab2x64(:,:,104))
  Gcoeff(:)%j = (c(8)*M(1,:)%j-c(7)*M(2,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(105),h0tab(:,105),[51,12],[0,0],2,2,wf16(:,6),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,6),51,G1H4(6),m3h16x4(:,19),heltab2x64(:,:,105))
  Gcoeff(:)%j = (c(19)*M(1,:)%j-c(18)*M(2,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(106),h0tab(:,106),[51,12],[0,0],2,2,wf16(:,7),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,7),51,G1H4(11),m3h16x4(:,20),heltab2x64(:,:,106))
  Gcoeff(:)%j = (c(16)*M(1,:)%j-c(12)*M(2,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(107),h0tab(:,107),[35,28],[0,0],2,2,wf8(:,23),wf8(:,8))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,23),G0H8(2),m3h8x8(:,17),heltab2x64(:,:,107))
  call Hloop_A_Q(ntryL,G0H8(2),35,0,G1H8(26),n2h8(34))
  Gcoeff(:)%j = (c(36)*M(1,:)%j-c(32)*M(2,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(108),h0tab(:,108),[35,28],[0,0],2,2,wf8(:,24),wf8(:,8))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,24),G0H8(4),m3h8x8(:,18),heltab2x64(:,:,108))
  call Hloop_A_Q(ntryL,G0H8(4),35,0,G1H8(27),n2h8(35))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)+c(40)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(109),h0tab(:,109),[51,12],[0,0],2,2,wf16(:,8),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,8),G0H4(1),m3h16x4(:,21),heltab2x64(:,:,109))
  call Hloop_Q_A(ntryL,G0H4(1),51,0,G1H4(3),n2h4(43))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)+c(38)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(110),h0tab(:,110),[51,12],[nMT,nMT],2,2,wf16(:,8),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,8),G0H4(1),m3h16x4(:,22),heltab2x64(:,:,110))
  call Hloop_Q_A(ntryL,G0H4(1),51,nMT,G1H4(10),n2h4(44))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)+c(40)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(111),h0tab(:,111),[51,12],[0,0],2,2,wf16(:,8),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,8),G0H4(1),m3h16x4(:,23),heltab2x64(:,:,111))
  call Hloop_Q_A(ntryL,G0H4(1),51,0,G1H4(8),n2h4(45))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)+c(38)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(112),h0tab(:,112),[51,12],[nMB,nMB],2,2,wf16(:,8),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,8),G0H4(1),m3h16x4(:,24),heltab2x64(:,:,112))
  call Hloop_Q_A(ntryL,G0H4(1),51,nMB,G1H4(16),n2h4(46))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)+c(46)*M(2,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(113),h0tab(:,113),[51,12],[0,0],2,2,wf16(:,9),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,9),G0H4(1),m3h16x4(:,25),heltab2x64(:,:,113))
  call Hloop_Q_A(ntryL,G0H4(1),51,0,G1H4(17),n2h4(47))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)+c(42)*M(2,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(114),h0tab(:,114),[51,12],[nMT,nMT],2,2,wf16(:,9),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,9),G0H4(1),m3h16x4(:,26),heltab2x64(:,:,114))
  call Hloop_Q_A(ntryL,G0H4(1),51,nMT,G1H4(18),n2h4(48))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)+c(46)*M(2,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(115),h0tab(:,115),[51,12],[0,0],2,2,wf16(:,9),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,9),G0H4(1),m3h16x4(:,27),heltab2x64(:,:,115))
  call Hloop_Q_A(ntryL,G0H4(1),51,0,G1H4(19),n2h4(49))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)+c(42)*M(2,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(116),h0tab(:,116),[51,12],[nMB,nMB],2,2,wf16(:,9),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,9),G0H4(1),m3h16x4(:,28),heltab2x64(:,:,116))
  call Hloop_Q_A(ntryL,G0H4(1),51,nMB,G1H4(20),n2h4(50))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)+c(14)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(117),h0tab(:,117),[51,12],[0,0],2,2,wf16(:,8),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,8),51,G1H4(21),m3h16x4(:,29),heltab2x64(:,:,117))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)+c(34)*M(2,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(118),h0tab(:,118),[51,12],[0,0],2,2,wf16(:,9),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,9),51,G1H4(22),m3h16x4(:,30),heltab2x64(:,:,118))
  Gcoeff(:)%j = (c(8)*M(1,:)%j-c(7)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(119),h0tab(:,119),[51,12],[0,0],2,2,wf16(:,8),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,8),51,G1H4(23),m3h16x4(:,31),heltab2x64(:,:,119))
  Gcoeff(:)%j = (c(19)*M(1,:)%j-c(18)*M(2,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(120),h0tab(:,120),[51,12],[0,0],2,2,wf16(:,9),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,9),51,G1H4(24),m3h16x4(:,32),heltab2x64(:,:,120))
  Gcoeff(:)%j = (c(45)*M(1,:)%j-c(44)*M(2,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(121),h0tab(:,121),[48,15],[0,0],2,2,wf4(:,5),wf16(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,31),heltab2x64(:,:,121))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(1),n2h16(37))
  Gcoeff(:)%j = (c(41)*M(1,:)%j-c(40)*M(2,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(122),h0tab(:,122),[48,15],[nMT,nMT],2,2,wf4(:,5),wf16(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,32),heltab2x64(:,:,122))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMT,G1H16(3),n2h16(38))
  Gcoeff(:)%j = (c(45)*M(1,:)%j-c(44)*M(2,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(123),h0tab(:,123),[48,15],[0,0],2,2,wf4(:,5),wf16(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,33),heltab2x64(:,:,123))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(5),n2h16(39))
  Gcoeff(:)%j = (c(41)*M(1,:)%j-c(40)*M(2,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(124),h0tab(:,124),[48,15],[nMB,nMB],2,2,wf4(:,5),wf16(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,34),heltab2x64(:,:,124))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMB,G1H16(2),n2h16(40))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)+c(46)*M(2,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(125),h0tab(:,125),[48,15],[0,0],2,2,wf4(:,5),wf16(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,35),heltab2x64(:,:,125))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(7),n2h16(41))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)+c(42)*M(2,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(126),h0tab(:,126),[48,15],[nMT,nMT],2,2,wf4(:,5),wf16(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,36),heltab2x64(:,:,126))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMT,G1H16(4),n2h16(42))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)+c(46)*M(2,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(127),h0tab(:,127),[48,15],[0,0],2,2,wf4(:,5),wf16(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,37),heltab2x64(:,:,127))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(6),n2h16(43))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)+c(42)*M(2,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(128),h0tab(:,128),[48,15],[nMB,nMB],2,2,wf4(:,5),wf16(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,38),heltab2x64(:,:,128))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMB,G1H16(8),n2h16(44))
  Gcoeff(:)%j = (c(28)*M(1,:)%j-c(25)*M(2,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(129),h0tab(:,129),[48,15],[0,0],2,2,wf4(:,5),wf16(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(9),m3h4x16(:,39),heltab2x64(:,:,129))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)+c(34)*M(2,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(130),h0tab(:,130),[48,15],[0,0],2,2,wf4(:,5),wf16(:,3))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(10),m3h4x16(:,40),heltab2x64(:,:,130))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)+c(14)*M(2,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(131),h0tab(:,131),[48,15],[0,0],2,2,wf4(:,5),wf16(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(11),m3h4x16(:,41),heltab2x64(:,:,131))
  Gcoeff(:)%j = (c(19)*M(1,:)%j-c(18)*M(2,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(132),h0tab(:,132),[48,15],[0,0],2,2,wf4(:,5),wf16(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(12),m3h4x16(:,42),heltab2x64(:,:,132))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)+c(23)*M(2,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(133),h0tab(:,133),[56,7],[nMT,0],2,2,wf8(:,38),wf8(:,12))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,38),G0H8(1),m3h8x8(:,19),heltab2x64(:,:,133))
  call Hloop_A_Q(ntryL,G0H8(1),56,nMT,G1H8(28),n2h8(36))
  Gcoeff(:)%j = (c(36)*M(1,:)%j-c(32)*M(2,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(134),h0tab(:,134),[56,7],[nMT,0],2,2,wf8(:,38),wf8(:,14))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,38),G0H8(3),m3h8x8(:,20),heltab2x64(:,:,134))
  call Hloop_A_Q(ntryL,G0H8(3),56,nMT,G1H8(29),n2h8(37))
  Gcoeff(:)%j = (c(45)*M(1,:)%j-c(44)*M(2,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(135),h0tab(:,135),[48,15],[0,0],2,2,wf4(:,5),wf16(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,43),heltab2x64(:,:,135))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(13),n2h16(45))
  Gcoeff(:)%j = (c(41)*M(1,:)%j-c(40)*M(2,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(136),h0tab(:,136),[48,15],[nMT,nMT],2,2,wf4(:,5),wf16(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,44),heltab2x64(:,:,136))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMT,G1H16(14),n2h16(46))
  Gcoeff(:)%j = (c(45)*M(1,:)%j-c(44)*M(2,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(137),h0tab(:,137),[48,15],[0,0],2,2,wf4(:,5),wf16(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,45),heltab2x64(:,:,137))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(15),n2h16(47))
  Gcoeff(:)%j = (c(41)*M(1,:)%j-c(40)*M(2,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(138),h0tab(:,138),[48,15],[nMB,nMB],2,2,wf4(:,5),wf16(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,46),heltab2x64(:,:,138))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMB,G1H16(16),n2h16(48))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)+c(46)*M(2,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(139),h0tab(:,139),[48,15],[0,0],2,2,wf4(:,5),wf16(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,47),heltab2x64(:,:,139))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(17),n2h16(49))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)+c(42)*M(2,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(140),h0tab(:,140),[48,15],[nMT,nMT],2,2,wf4(:,5),wf16(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,48),heltab2x64(:,:,140))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMT,G1H16(18),n2h16(50))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)+c(46)*M(2,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(141),h0tab(:,141),[48,15],[0,0],2,2,wf4(:,5),wf16(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,49),heltab2x64(:,:,141))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(19),n2h16(51))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)+c(42)*M(2,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(142),h0tab(:,142),[48,15],[nMB,nMB],2,2,wf4(:,5),wf16(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,50),heltab2x64(:,:,142))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMB,G1H16(20),n2h16(52))
  Gcoeff(:)%j = (c(28)*M(1,:)%j-c(25)*M(2,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(143),h0tab(:,143),[48,15],[0,0],2,2,wf4(:,5),wf16(:,4))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(21),m3h4x16(:,51),heltab2x64(:,:,143))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)+c(34)*M(2,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(144),h0tab(:,144),[48,15],[0,0],2,2,wf4(:,5),wf16(:,5))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(22),m3h4x16(:,52),heltab2x64(:,:,144))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)+c(14)*M(2,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(145),h0tab(:,145),[48,15],[0,0],2,2,wf4(:,5),wf16(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(23),m3h4x16(:,53),heltab2x64(:,:,145))
  Gcoeff(:)%j = (c(19)*M(1,:)%j-c(18)*M(2,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(146),h0tab(:,146),[48,15],[0,0],2,2,wf4(:,5),wf16(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,5),48,G1H16(24),m3h4x16(:,54),heltab2x64(:,:,146))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)+c(23)*M(2,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(147),h0tab(:,147),[52,11],[0,nMT],2,2,wf8(:,17),wf8(:,35))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,17),G0H8(2),m3h8x8(:,21),heltab2x64(:,:,147))
  Gcoeff(:)%j = (c(36)*M(1,:)%j-c(32)*M(2,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(148),h0tab(:,148),[52,11],[0,nMT],2,2,wf8(:,17),wf8(:,36))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,17),G0H8(4),m3h8x8(:,22),heltab2x64(:,:,148))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(19),[G1H4(17),G1H4(8),G1H4(3),G1H4(13),G1H4(12),G1H4(9) &
    ,G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(18),[G1H4(10),G1H4(2),G1H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(20),[G1H4(16),G1H4(15),G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(22),[G1H4(21),G1H4(5),G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(24),[G1H4(23),G1H4(11),G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(27),[G1H8(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(5),[G1H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(6),[G1H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(15),[G1H16(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(19),[G1H16(17)])
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(24),wf8(:,3),G1tensor(1),m3h8x1(:,14),heltab2x8(:,:,47))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(25),wf8(:,5),G1tensor(6),m3h8x1(:,15),heltab2x8(:,:,48))
  call Hloop_QV_A(ntryL,G1H4(19),wf4(:,2),G1H1(1),m3h4x1(:,16),heltab2x4(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(27),n2h1(48))
  call Hloop_QV_A(ntryL,G1H4(18),wf4(:,2),G1H1(1),m3h4x1(:,17),heltab2x4(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(29),n2h1(49))
  call Hloop_QV_A(ntryL,G1H4(20),wf4(:,2),G1H1(1),m3h4x1(:,18),heltab2x4(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(36),n2h1(50))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(22),51,wf4(:,2),12,G2tensor(39),m3h4x1(:,19),heltab2x4(:,:,41))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(24),51,wf4(:,2),12,G2tensor(8),m3h4x1(:,20),heltab2x4(:,:,42))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(27),wf8(:,8),G1tensor(2),m3h8x1(:,16),heltab2x8(:,:,49))
  call Hloop_QV_A(ntryL,G1H16(5),wf16(:,2),G1H1(1),m3h16x1(:,1),heltab2x16(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(20),n2h1(51))
  call Hloop_QV_A(ntryL,G1H16(3),wf16(:,2),G1H1(1),m3h16x1(:,2),heltab2x16(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(19),n2h1(52))
  call Hloop_QV_A(ntryL,G1H16(2),wf16(:,2),G1H1(1),m3h16x1(:,3),heltab2x16(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(28),n2h1(53))
  call Hloop_QV_A(ntryL,G1H16(6),wf16(:,3),G1H1(1),m3h16x1(:,4),heltab2x16(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(35),n2h1(54))
  call Hloop_QV_A(ntryL,G1H16(4),wf16(:,3),G1H1(1),m3h16x1(:,5),heltab2x16(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(30),n2h1(55))
  call Hloop_QV_A(ntryL,G1H16(8),wf16(:,3),G1H1(1),m3h16x1(:,6),heltab2x16(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(16),n2h1(56))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H16(9),48,wf16(:,2),15,G2tensor(32),m3h16x1(:,7),heltab2x16(:,:,47))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H16(10),48,wf16(:,3),15,G2tensor(34),m3h16x1(:,8),heltab2x16(:,:,48))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H16(11),48,wf16(:,2),15,G2tensor(37),m3h16x1(:,9),heltab2x16(:,:,49))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H16(12),48,wf16(:,3),15,G2tensor(41),m3h16x1(:,10),heltab2x16(:,:,50))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(28),wf8(:,12),G1tensor(9),m3h8x1(:,17),heltab2x8(:,:,50))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(29),wf8(:,14),G1tensor(17),m3h8x1(:,18),heltab2x8(:,:,51))
  call Hloop_QV_A(ntryL,G1H16(15),wf16(:,4),G1H1(1),m3h16x1(:,11),heltab2x16(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(38),n2h1(57))
  call Hloop_QV_A(ntryL,G1H16(14),wf16(:,4),G1H1(1),m3h16x1(:,12),heltab2x16(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(40),n2h1(58))
  call Hloop_QV_A(ntryL,G1H16(16),wf16(:,4),G1H1(1),m3h16x1(:,13),heltab2x16(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(21),n2h1(59))
  call Hloop_QV_A(ntryL,G1H16(19),wf16(:,5),G1H1(1),m3h16x1(:,14),heltab2x16(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(2),n2h1(60))
  call Hloop_QV_A(ntryL,G1H16(18),wf16(:,5),G1H1(1),m3h16x1(:,15),heltab2x16(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(3),n2h1(61))
  call Hloop_QV_A(ntryL,G1H16(20),wf16(:,5),G1H1(1),m3h16x1(:,16),heltab2x16(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(4),n2h1(62))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H16(21),48,wf16(:,4),15,G2tensor(14),m3h16x1(:,17),heltab2x16(:,:,57))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H16(22),48,wf16(:,5),15,G2tensor(11),m3h16x1(:,18),heltab2x16(:,:,58))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H16(23),48,wf16(:,4),15,G2tensor(13),m3h16x1(:,19),heltab2x16(:,:,59))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H16(24),48,wf16(:,5),15,G2tensor(22),m3h16x1(:,20),heltab2x16(:,:,60))
  call Hloop_VA_Q(ntryL,G0H8(2),wf8(:,35),G0H1(1),m3h8x1(:,19),heltab2x8(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(26),n2h1(63))
  call Hloop_VA_Q(ntryL,G0H8(4),wf8(:,36),G0H1(1),m3h8x1(:,20),heltab2x8(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(31),n2h1(64))
  call ol_merge_tensors(G2tensor(8),[G2tensor(39),G2tensor(27),G0tensor(190),G0tensor(87),G0tensor(105),G0tensor(70),G0tensor(4) &
    ,G0tensor(27),G0tensor(92),G0tensor(6)])
  call ol_merge_tensors(G1tensor(6),[G1tensor(1),G0tensor(229),G0tensor(224),G0tensor(178),G0tensor(153),G0tensor(47),G0tensor(81) &
    ,G0tensor(11)])
  call ol_merge_tensors(G0tensor(200),[G0tensor(170),G0tensor(145),G0tensor(140),G0tensor(117),G0tensor(123),G0tensor(77) &
    ,G0tensor(2),G0tensor(36),G0tensor(16)])
  call ol_merge_tensors(G0tensor(183),[G0tensor(158),G0tensor(17),G0tensor(80),G0tensor(71),G0tensor(26)])
  call ol_merge_tensors(G1tensor(2),[G0tensor(240),G0tensor(235),G0tensor(195),G0tensor(165),G0tensor(75),G0tensor(20) &
    ,G0tensor(31)])
  call ol_merge_tensors(G0tensor(238),[G0tensor(154),G0tensor(149),G0tensor(143),G0tensor(43),G0tensor(30),G0tensor(60) &
    ,G0tensor(67),G0tensor(46)])
  call ol_merge_tensors(G0tensor(218),[G0tensor(33),G0tensor(125),G0tensor(51)])
  call ol_merge_tensors(G2tensor(22),[G2tensor(13),G2tensor(11),G2tensor(14),G2tensor(2),G2tensor(38),G2tensor(41),G2tensor(37) &
    ,G2tensor(34),G2tensor(32),G2tensor(35),G2tensor(20),G0tensor(89),G0tensor(78),G0tensor(19),G0tensor(15),G0tensor(72) &
    ,G0tensor(55),G0tensor(56)])
  call ol_merge_tensors(G0tensor(241),[G0tensor(236),G0tensor(231),G0tensor(226),G0tensor(221),G0tensor(216),G0tensor(211) &
    ,G0tensor(206),G0tensor(201),G0tensor(196),G0tensor(191),G0tensor(186),G0tensor(181),G0tensor(176),G0tensor(171),G0tensor(166) &
    ,G0tensor(161),G0tensor(156),G0tensor(151),G0tensor(146),G0tensor(141),G0tensor(136),G0tensor(122),G0tensor(114),G0tensor(93) &
    ,G0tensor(79),G0tensor(69),G0tensor(59),G0tensor(58),G0tensor(44),G0tensor(97),G0tensor(37),G0tensor(100),G0tensor(12) &
    ,G0tensor(35),G0tensor(130),G0tensor(65),G0tensor(131),G0tensor(106),G0tensor(61)])
  call ol_merge_tensors(G0tensor(219),[G0tensor(214),G0tensor(209),G0tensor(204),G0tensor(173),G0tensor(148),G0tensor(13) &
    ,G0tensor(9),G0tensor(5),G0tensor(76)])
  call ol_merge_tensors(G0tensor(129),[G0tensor(113),G0tensor(54),G0tensor(8),G0tensor(104),G0tensor(116),G0tensor(91)])
  call ol_merge_tensors(G0tensor(228),[G0tensor(203),G0tensor(199),G0tensor(194),G0tensor(189),G0tensor(68),G0tensor(50) &
    ,G0tensor(23),G0tensor(96)])
  call ol_merge_tensors(G1tensor(17),[G1tensor(9),G0tensor(208),G0tensor(94),G0tensor(25),G0tensor(101)])
  call ol_merge_tensors(G2tensor(29),[G0tensor(112),G0tensor(24),G0tensor(121)])
  call ol_merge_tensors(G2tensor(3),[G2tensor(40),G2tensor(30),G2tensor(19),G0tensor(102),G0tensor(34),G0tensor(28) &
    ,G0tensor(126)])
  call ol_merge_tensors(G0tensor(223),[G0tensor(213),G0tensor(169),G0tensor(164),G0tensor(42),G0tensor(40),G0tensor(18) &
    ,G0tensor(99)])
  call ol_merge_tensors(G0tensor(138),[G0tensor(82),G0tensor(135)])
  call ol_merge_tensors(G0tensor(233),[G0tensor(188),G0tensor(179),G0tensor(174),G0tensor(110),G0tensor(119),G0tensor(63) &
    ,G0tensor(32),G0tensor(90)])
  call ol_merge_tensors(G2tensor(36),[G0tensor(48)])
  call ol_merge_tensors(G2tensor(4),[G2tensor(21),G2tensor(16),G2tensor(28),G0tensor(57)])
  call ol_merge_tensors(G1tensor(31),[G1tensor(26),G0tensor(98),G0tensor(73),G0tensor(64),G0tensor(107)])
  call ol_merge_tensors(G0tensor(234),[G0tensor(205),G0tensor(103),G0tensor(88)])
  call ol_merge_tensors(G0tensor(230),[G0tensor(210),G0tensor(115),G0tensor(83)])
  call ol_merge_tensors(G0tensor(239),[G0tensor(215),G0tensor(139),G0tensor(133)])
  call ol_merge_tensors(G0tensor(225),[G0tensor(220),G0tensor(144),G0tensor(134)])
  call ol_merge_tensors(G0tensor(163),[G0tensor(159),G0tensor(150)])
  call ol_merge_tensors(G0tensor(168),[G0tensor(160),G0tensor(155)])
  call ol_merge_tensors(G0tensor(193),[G0tensor(184),G0tensor(175)])
  call ol_merge_tensors(G0tensor(198),[G0tensor(185),G0tensor(180)])
call TI_bubble_red(G2tensor(8),51,mass2set(:,1),G0tensor(1),M2L1R1)
call TI_bubble_red(G2tensor(22),48,mass2set(:,1),G0tensor(21),M2L1R1)
call TI_bubble_red(G2tensor(29),51,mass2set(:,2),G0tensor(41),M2L1R1,G0tensor(66))
call TI_bubble_red(G2tensor(3),48,mass2set(:,2),G0tensor(86),M2L1R1,G0tensor(111))
call TI_bubble_red(G2tensor(36),51,mass2set(:,3),G0tensor(120),M2L1R1,G0tensor(45))
call TI_bubble_red(G2tensor(4),48,mass2set(:,3),G0tensor(118),M2L1R1,G0tensor(53))
  call ol_merge_tensors(G0tensor(111),[G0tensor(66),G0tensor(241)])
  call ol_merge_tensors(G0tensor(49),[G0tensor(53),G0tensor(45)])
call TI_bubble_red(G1tensor(6),44,mass2set(:,1),G0tensor(108),M2L1R1)
call TI_bubble_red(G1tensor(2),35,mass2set(:,1),G0tensor(124),M2L1R1)
call TI_bubble_red(G1tensor(17),56,mass2set(:,4),G0tensor(74),M2L1R1,G0tensor(84))
call TI_bubble_red(G1tensor(31),52,mass2set(:,5),G0tensor(109),M2L1R1,G0tensor(127))
  call ol_merge_tensors(G0tensor(127),[G0tensor(84),G0tensor(111)])
  call ol_merge_tensors(T0sum(78),[G0tensor(1)])
  call ol_merge_tensors(T0sum(79),[G0tensor(108)])
  call ol_merge_tensors(T0sum(80),[G0tensor(200)])
  call ol_merge_tensors(T0sum(81),[G0tensor(183)])
  call ol_merge_tensors(T0sum(82),[G0tensor(124)])
  call ol_merge_tensors(T0sum(83),[G0tensor(238)])
  call ol_merge_tensors(T0sum(84),[G0tensor(218)])
  call ol_merge_tensors(T0sum(85),[G0tensor(21)])
  call ol_merge_tensors(T0sum(86),[G0tensor(127)])
  call ol_merge_tensors(T0sum(87),[G0tensor(219)])
  call ol_merge_tensors(T0sum(88),[G0tensor(129)])
  call ol_merge_tensors(T0sum(89),[G0tensor(228)])
  call ol_merge_tensors(T0sum(90),[G0tensor(74)])
  call ol_merge_tensors(T0sum(91),[G0tensor(41)])
  call ol_merge_tensors(T0sum(92),[G0tensor(86)])
  call ol_merge_tensors(T0sum(93),[G0tensor(223)])
  call ol_merge_tensors(T0sum(94),[G0tensor(138)])
  call ol_merge_tensors(T0sum(95),[G0tensor(233)])
  call ol_merge_tensors(T0sum(96),[G0tensor(52)])
  call ol_merge_tensors(T0sum(97),[G0tensor(120)])
  call ol_merge_tensors(T0sum(98),[G0tensor(49)])
  call ol_merge_tensors(T0sum(99),[G0tensor(118)])
  call ol_merge_tensors(T0sum(100),[G0tensor(109)])
  call ol_merge_tensors(T0sum(101),[G0tensor(234)])
  call ol_merge_tensors(T0sum(102),[G0tensor(230)])
  call ol_merge_tensors(T0sum(103),[G0tensor(239)])
  call ol_merge_tensors(T0sum(104),[G0tensor(225)])
  call ol_merge_tensors(T0sum(105),[G0tensor(163)])
  call ol_merge_tensors(T0sum(106),[G0tensor(168)])
  call ol_merge_tensors(T0sum(107),[G0tensor(193)])
  call ol_merge_tensors(T0sum(108),[G0tensor(198)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 35, 51, 55 ],masses2_18,RedSet_4(1),ScalarBoxes(1))
  call compute_scalar_box([ 32, 51, 55 ],masses2_18,RedSet_4(2),ScalarBoxes(2))
  call compute_scalar_box([ 32, 35, 55 ],masses2_18,RedSet_4(3),ScalarBoxes(3))
  call compute_scalar_box([ 32, 35, 51 ],masses2_16,RedSet_4(4),ScalarBoxes(4))
  call compute_scalar_box([ 3, 19, 23 ],masses2_18,RedSet_4(5),ScalarBoxes(5))
  call compute_scalar_box([ 35, 51, 59 ],masses2_18,RedSet_4(6),ScalarBoxes(6))
  call compute_scalar_box([ 32, 51, 59 ],masses2_18,RedSet_4(7),ScalarBoxes(7))
  call compute_scalar_box([ 32, 35, 59 ],masses2_18,RedSet_4(8),ScalarBoxes(8))
  call compute_scalar_box([ 3, 19, 27 ],masses2_18,RedSet_4(9),ScalarBoxes(9))
  call compute_scalar_box([ 40, 43, 47 ],masses2_21,RedSet_4(10),ScalarBoxes(10))
  call compute_scalar_box([ 32, 43, 47 ],masses2_19,RedSet_4(11),ScalarBoxes(11))
  call compute_scalar_box([ 32, 40, 47 ],masses2_19,RedSet_4(12),ScalarBoxes(12))
  call compute_scalar_box([ 32, 40, 43 ],masses2_20,RedSet_4(13),ScalarBoxes(13))
  call compute_scalar_box([ 8, 11, 15 ],masses2_21,RedSet_4(14),ScalarBoxes(14))
  call compute_scalar_box([ 36, 39, 47 ],masses2_21,RedSet_4(15),ScalarBoxes(15))
  call compute_scalar_box([ 32, 39, 47 ],masses2_19,RedSet_4(16),ScalarBoxes(16))
  call compute_scalar_box([ 32, 36, 47 ],masses2_19,RedSet_4(17),ScalarBoxes(17))
  call compute_scalar_box([ 32, 36, 39 ],masses2_20,RedSet_4(18),ScalarBoxes(18))
  call compute_scalar_box([ 4, 7, 15 ],masses2_21,RedSet_4(19),ScalarBoxes(19))
! end of process


end subroutine vamp_1

end module ol_vamp_1_pplltt_eexttxddx_1_/**/REALKIND
