
module ol_colourmatrix_pplltt_eexttxddx_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(46,2), K2(46,2), KL(46,2), Cas(6) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [   9,   3]
  K1( 2,:) = [   3,   9]
  K1( 3,:) = [   0,   0]
  K1( 4,:) = [   0,   0]
  K1( 5,:) = [   0,   0]
  K1( 6,:) = [   0,   0]
  K1( 7,:) = [   0,   0]
  K1( 8,:) = [   0,   0]
  K1( 9,:) = [   0,   0]
  K1(10,:) = [   0,   0]
  K1(11,:) = [   0,   0]
  K1(12,:) = [   0,   0]
  K1(13,:) = [  12,   4]
  K1(14,:) = [   4,  12]
  K1(15,:) = [   0,   0]
  K1(16,:) = [   0,   0]
  K1(17,:) = [   0,   0]
  K1(18,:) = [   0,   0]
  K1(19,:) = [   0,  -4]
  K1(20,:) = [  -4, -12]
  K1(21,:) = [  12,   4]
  K1(22,:) = [   4,  12]
  K1(23,:) = [   0,   0]
  K1(24,:) = [   0,   0]
  K1(25,:) = [   0,   0]
  K1(26,:) = [   0,   0]
  K1(27,:) = [   0,   4]
  K1(28,:) = [   4,   0]
  K1(29,:) = [ -12,  -4]
  K1(30,:) = [  -4,   0]
  K1(31,:) = [  12,   4]
  K1(32,:) = [   4,  12]
  K1(33,:) = [   0,   0]
  K1(34,:) = [   0,   0]
  K1(35,:) = [   0,   0]
  K1(36,:) = [   0,   0]
  K1(37,:) = [ -12,  -4]
  K1(38,:) = [  -4,   0]
  K1(39,:) = [   0,   4]
  K1(40,:) = [   4,   0]
  K1(41,:) = [   0,  -4]
  K1(42,:) = [  -4, -12]
  K1(43,:) = [  12,   4]
  K1(44,:) = [   4,  12]
  K1(45,:) = [   0,   0]
  K1(46,:) = [   0,   0]

  K2( 1,:) = [   9,   3]
  K2( 2,:) = [   3,   9]
  K2( 3,:) = [   0,   0]
  K2( 4,:) = [   0,   0]
  K2( 5,:) = [   0,   0]
  K2( 6,:) = [   0,   0]
  K2( 7,:) = [   0,   0]
  K2( 8,:) = [   0,   0]
  K2( 9,:) = [   0,   0]
  K2(10,:) = [   0,   0]
  K2(11,:) = [   0,   0]
  K2(12,:) = [   0,   0]
  K2(13,:) = [  12,   4]
  K2(14,:) = [   4,  12]
  K2(15,:) = [   0,   0]
  K2(16,:) = [   0,   0]
  K2(17,:) = [   0,   0]
  K2(18,:) = [   0,   0]
  K2(19,:) = [   0,  -4]
  K2(20,:) = [  -4, -12]
  K2(21,:) = [  12,   4]
  K2(22,:) = [   4,  12]
  K2(23,:) = [   0,   0]
  K2(24,:) = [   0,   0]
  K2(25,:) = [   0,   0]
  K2(26,:) = [   0,   0]
  K2(27,:) = [   0,   4]
  K2(28,:) = [   4,   0]
  K2(29,:) = [ -12,  -4]
  K2(30,:) = [  -4,   0]
  K2(31,:) = [  12,   4]
  K2(32,:) = [   4,  12]
  K2(33,:) = [   0,   0]
  K2(34,:) = [   0,   0]
  K2(35,:) = [   0,   0]
  K2(36,:) = [   0,   0]
  K2(37,:) = [ -12,  -4]
  K2(38,:) = [  -4,   0]
  K2(39,:) = [   0,   4]
  K2(40,:) = [   4,   0]
  K2(41,:) = [   0,  -4]
  K2(42,:) = [  -4, -12]
  K2(43,:) = [  12,   4]
  K2(44,:) = [   4,  12]
  K2(45,:) = [   0,   0]
  K2(46,:) = [   0,   0]

  KL( 1,:) = [   9,   3]
  KL( 2,:) = [   3,   9]
  KL( 3,:) = [   0,   0]
  KL( 4,:) = [   0,   0]
  KL( 5,:) = [   0,   0]
  KL( 6,:) = [   0,   0]
  KL( 7,:) = [   0,   0]
  KL( 8,:) = [   0,   0]
  KL( 9,:) = [   0,   0]
  KL(10,:) = [   0,   0]
  KL(11,:) = [   0,   0]
  KL(12,:) = [   0,   0]
  KL(13,:) = [  12,   4]
  KL(14,:) = [   4,  12]
  KL(15,:) = [   0,   0]
  KL(16,:) = [   0,   0]
  KL(17,:) = [   0,   0]
  KL(18,:) = [   0,   0]
  KL(19,:) = [   0,  -4]
  KL(20,:) = [  -4, -12]
  KL(21,:) = [  12,   4]
  KL(22,:) = [   4,  12]
  KL(23,:) = [   0,   0]
  KL(24,:) = [   0,   0]
  KL(25,:) = [   0,   0]
  KL(26,:) = [   0,   0]
  KL(27,:) = [   0,   4]
  KL(28,:) = [   4,   0]
  KL(29,:) = [ -12,  -4]
  KL(30,:) = [  -4,   0]
  KL(31,:) = [  12,   4]
  KL(32,:) = [   4,  12]
  KL(33,:) = [   0,   0]
  KL(34,:) = [   0,   0]
  KL(35,:) = [   0,   0]
  KL(36,:) = [   0,   0]
  KL(37,:) = [ -12,  -4]
  KL(38,:) = [  -4,   0]
  KL(39,:) = [   0,   4]
  KL(40,:) = [   4,   0]
  KL(41,:) = [   0,  -4]
  KL(42,:) = [  -4, -12]
  KL(43,:) = [  12,   4]
  KL(44,:) = [   4,  12]
  KL(45,:) = [   0,   0]
  KL(46,:) = [   0,   0]

#if -1 > 0
    co = 0
    do k = 1, 6
      co = co + k
      Cas(k) = K1(1+2*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_pplltt_eexttxddx_1_/**/REALKIND



module ol_forced_parameters_pplltt_eexttxddx_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pplltt_eexttxddx_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_pplltt_eexttxddx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 64 ! number of helicity configurations
  integer(intkind2), save :: nhel = 64 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(64) ! physical helicity states
#endif

  complex(REALKIND), save :: den(83)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,9), wf8(8,52), wf16(16,9), wf64(64,49)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(30), c(47)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(2,64), M0M1_hel_cc(2,64,22)
  complex(REALKIND), save :: M2ctcc(22)

end module ol_loop_storage_pplltt_eexttxddx_1_/**/REALKIND






! **********************************************************************
module ol_loop_pplltt_eexttxddx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_pplltt_eexttxddx_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (CI*eQED**2*gQCD**2)/3._/**/REALKIND
    f( 2) = (2*CI*eQED**2*gQCD**2)/3._/**/REALKIND
    f( 3) = CI*eQED**2*gQCD**2
    f( 4) = (CI*countertermnorm*eQED**2*gQCD**4)/3._/**/REALKIND
    f( 5) = (2*CI*countertermnorm*eQED**2*gQCD**4)/3._/**/REALKIND
    f( 6) = CI*countertermnorm*eQED**2*gQCD**4
    f( 7) = (CI*countertermnorm*ctGqq*eQED**2*gQCD**4)/3._/**/REALKIND
    f( 8) = (2*CI*countertermnorm*ctGqq*eQED**2*gQCD**4)/3._/**/REALKIND
    f( 9) = CI*countertermnorm*ctGqq*eQED**2*gQCD**4
    f(10) = (CI*countertermnorm*ctGtt*eQED**2*gQCD**4)/3._/**/REALKIND
    f(11) = (2*CI*countertermnorm*ctGtt*eQED**2*gQCD**4)/3._/**/REALKIND
    f(12) = CI*countertermnorm*ctGtt*eQED**2*gQCD**4
    f(13) = (CI*countertermnorm*ctVqq*eQED**2*gQCD**4)/3._/**/REALKIND
    f(14) = CI*countertermnorm*ctVqq*eQED**2*gQCD**4
    f(15) = (2*CI*countertermnorm*ctVtt*eQED**2*gQCD**4)/3._/**/REALKIND
    f(16) = CI*countertermnorm*ctVtt*eQED**2*gQCD**4
    f(17) = countertermnorm*ctZGG*eQED**2*gQCD**4
    f(18) = (CI*eQED**2*gQCD**4*integralnorm*SwB)/3._/**/REALKIND
    f(19) = (2*CI*eQED**2*gQCD**4*integralnorm*SwB)/3._/**/REALKIND
    f(20) = CI*eQED**2*gQCD**4*integralnorm*SwB
    f(21) = (eQED**2*gQCD**4*integralnorm*SwB)/6._/**/REALKIND
    f(22) = (eQED**2*gQCD**4*integralnorm*SwB)/3._/**/REALKIND
    f(23) = (eQED**2*gQCD**4*integralnorm*SwB)/2._/**/REALKIND
    f(24) = (2*eQED**2*gQCD**4*integralnorm*SwB)/3._/**/REALKIND
    f(25) = eQED**2*gQCD**4*integralnorm*SwB
    f(26) = (eQED**2*gQCD**4*integralnorm*SwF)/3._/**/REALKIND
    f(27) = (2*eQED**2*gQCD**4*integralnorm*SwF)/3._/**/REALKIND
    f(28) = eQED**2*gQCD**4*integralnorm*SwF
    f(29) = (4*eQED**2*gQCD**4*integralnorm*SwF)/3._/**/REALKIND
    f(30) = 2*eQED**2*gQCD**4*integralnorm*SwF

  c = [ 9*CI*f(18), 27*CI*f(18), 9*CI*f(19), 27*CI*f(19), 9*CI*f(20), 27*CI*f(20), 18*f(21), 54*f(21), f(22), 3*f(22), 6*f(22) &
    , 8*f(22), 10*f(22), 18*f(22), 21*f(22), 24*f(22), 54*f(22), 18*f(23), 54*f(23), f(24), 3*f(24), 6*f(24), 8*f(24), 10*f(24) &
    , 18*f(24), 21*f(24), 24*f(24), 54*f(24), f(25), 3*f(25), 6*f(25), 8*f(25), 10*f(25), 18*f(25), 21*f(25), 24*f(25), 54*f(25) &
    , 3*f(26), 9*f(26), 3*f(27), 9*f(27), 3*f(28), 9*f(28), 3*f(29), 9*f(29), 3*f(30), 9*f(30) ]
  c = (1._/**/REALKIND / 36) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3))+L(6,3))
  den(2) = 1 /((L(5,12))+L(6,12))
  den(3) = 1 /((L(5,19))+L(6,19))
  den(6) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(9) = 1 /((L(5,28))+L(6,28))
  den(13) = 1 /((L(5,48))+L(6,48))
  den(14) = 1 /((L(5,7) - MT2)+L(6,7))
  den(19) = 1 /((L(5,52) - MT2)+L(6,52))
  den(25) = 1 /((L(5,35))+L(6,35))
  den(30) = 1 /((L(5,44))+L(6,44))
  den(34) = 1 /((L(5,11) - MT2)+L(6,11))
  den(39) = 1 /((L(5,56) - MT2)+L(6,56))
  den(61) = 1 /((L(5,15))+L(6,15))
  den(66) = 1 /((L(5,51))+L(6,51))

  ! denominators
  den(4) = den(1)*den(3)
  den(5) = den(2)*den(4)
  den(7) = den(3)*den(6)
  den(8) = den(2)*den(7)
  den(10) = den(2)*den(9)
  den(11) = den(1)*den(10)
  den(12) = den(6)*den(10)
  den(15) = den(1)*den(14)
  den(16) = den(13)*den(15)
  den(17) = den(6)*den(14)
  den(18) = den(13)*den(17)
  den(20) = den(13)*den(19)
  den(21) = den(1)*den(20)
  den(22) = den(6)*den(20)
  den(23) = den(2)*den(6)
  den(24) = den(13)*den(23)
  den(26) = den(1)*den(25)
  den(27) = den(2)*den(26)
  den(28) = den(6)*den(25)
  den(29) = den(2)*den(28)
  den(31) = den(2)*den(30)
  den(32) = den(1)*den(31)
  den(33) = den(6)*den(31)
  den(35) = den(1)*den(34)
  den(36) = den(13)*den(35)
  den(37) = den(6)*den(34)
  den(38) = den(13)*den(37)
  den(40) = den(13)*den(39)
  den(41) = den(1)*den(40)
  den(42) = den(6)*den(40)
  den(43) = den(2)**2
  den(44) = den(26)*den(43)
  den(45) = den(28)*den(43)
  den(46) = den(4)*den(43)
  den(47) = den(7)*den(43)
  den(48) = den(4)*den(31)
  den(49) = den(7)*den(31)
  den(50) = den(10)*den(26)
  den(51) = den(10)*den(28)
  den(52) = den(15)*den(40)
  den(53) = den(17)*den(40)
  den(54) = den(20)*den(35)
  den(55) = den(20)*den(37)
  den(56) = den(13)**2
  den(57) = den(35)*den(56)
  den(58) = den(37)*den(56)
  den(59) = den(15)*den(56)
  den(60) = den(17)*den(56)
  den(62) = den(15)*den(61)
  den(63) = den(17)*den(61)
  den(64) = den(35)*den(61)
  den(65) = den(37)*den(61)
  den(67) = den(4)*den(66)
  den(68) = den(7)*den(66)
  den(69) = den(26)*den(66)
  den(70) = den(28)*den(66)
  den(71) = den(1)*den(2)*den(13)
  den(72) = den(2)*den(6)*den(13)
  den(73) = den(1)*den(2)
  den(74) = den(1)*den(13)
  den(75) = den(6)*den(13)
  den(76) = den(2)*den(67)
  den(77) = den(2)*den(68)
  den(78) = den(2)*den(69)
  den(79) = den(2)*den(70)
  den(80) = den(13)*den(62)
  den(81) = den(13)*den(63)
  den(82) = den(13)*den(64)
  den(83) = den(13)*den(65)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif


!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_pplltt_eexttxddx_1_/**/DREALKIND, only: nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for e- e+ top anti-top down anti-down -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_pplltt_eexttxddx_1, only: &
    & external_perm_pplltt_eexttxddx_1, &
    & external_perm_inv_pplltt_eexttxddx_1, &
    & extcomb_perm_pplltt_eexttxddx_1, &
    & average_factor_pplltt_eexttxddx_1, &
    & photonid_pplltt_eexttxddx_1
  use ol_ew_renormalisation_/**/REALKIND, only: photon_factors
  use ol_external_pplltt_eexttxddx_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_pplltt_eexttxddx_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_pplltt_eexttxddx_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_pplltt_eexttxddx_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: IR_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(22)
  logical, intent(in) :: qp_kinematics
  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,6)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,6)
#endif
  integer           :: extmasses2(6)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(22)
  complex(REALKIND) :: M1(2), M2(2)
  real(REALKIND)    :: P_scatt_intern(0:3,6)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  real(REALKIND)       :: bornphotonfactor
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(2,64)
  type(Hpolcont) :: M1helarray_ct(2,64)
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(22), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak

#if 6 > 3
  integer :: ind_cc_comb(9)
#endif
  type(Hpolcont) :: A(64,49)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(49)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    call amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
  end if


  call set_parameter("ew_renorm", 0)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, nMT, nMT, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_pplltt_eexttxddx_1, 6, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_Q(P(:,3), rMT, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rMT, H4, ex4, POLSEL(4),4)
  call pol_wf_Q(P(:,5), rZERO, H5, ex5, POLSEL(5),5)
  call pol_wf_A(P(:,6), rZERO, H6, ex6, POLSEL(6),6)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_QA_V(ntry, ex3(:), ex4(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_VQ_A(ntry, wf4(:,1), ex5(:), wf8(:,1), n3(:,3), t3x8(:,:,1))
  call vert_AV_Q(ntry, ex6(:), wf4(:,2), wf8(:,2), n3(:,4), t3x8(:,:,2))
  call prop_Q_A(ntry, wf8(:,1), 19, ZERO, 0_intkind1, wf8(:,3), n2(1))
  call vert_QA_Z(gZl,ntry, ex1(:), ex2(:), wf4(:,3), n3(:,5), t3x4(:,:,3))
  call prop_W_W(ntry, wf4(:,3), 3, MZ, 1_intkind1, wf4(:,4), n2(2))
  call vert_ZQ_A(gZd,ntry, wf4(:,4), ex5(:), wf8(:,4), n3(:,6), t3x8(:,:,3))
  call prop_Q_A(ntry, wf8(:,4), 19, ZERO, 0_intkind1, wf8(:,5), n2(3))
  call vert_VQ_A(ntry, wf4(:,2), ex5(:), wf8(:,6), n3(:,7), t3x8(:,:,4))
  call vert_AV_Q(ntry, ex6(:), wf4(:,1), wf8(:,7), n3(:,8), t3x8(:,:,5))
  call prop_Q_A(ntry, wf8(:,6), 28, ZERO, 0_intkind1, wf8(:,8), n2(4))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,4), wf8(:,9), n3(:,9), t3x8(:,:,6))
  call vert_QA_V(ntry, ex5(:), ex6(:), wf4(:,5), n3(:,10), t3x4(:,:,4))
  call vert_VQ_A(ntry, wf4(:,1), ex3(:), wf8(:,10), n3(:,11), t3x8(:,:,7))
  call vert_AV_Q(ntry, ex4(:), wf4(:,5), wf8(:,11), n3(:,12), t3x8(:,:,8))
  call prop_Q_A(ntry, wf8(:,10), 7, MT, 1_intkind1, wf8(:,12), n2(5))
  call vert_ZQ_A(gZu,ntry, wf4(:,4), ex3(:), wf8(:,13), n3(:,13), t3x8(:,:,9))
  call prop_Q_A(ntry, wf8(:,13), 7, MT, 1_intkind1, wf8(:,14), n2(6))
  call vert_VQ_A(ntry, wf4(:,5), ex3(:), wf8(:,15), n3(:,14), t3x8(:,:,10))
  call vert_AV_Q(ntry, ex4(:), wf4(:,1), wf8(:,16), n3(:,15), t3x8(:,:,11))
  call prop_Q_A(ntry, wf8(:,15), 52, MT, 1_intkind1, wf8(:,17), n2(7))
  call vert_AZ_Q(gZu,ntry, ex4(:), wf4(:,4), wf8(:,18), n3(:,16), t3x8(:,:,12))
  call counter_VG_G(ntry, wf4(:,4), wf4(:,2), 12, wf16(:,1), 15, n3(:,17), t3x16(:,:,1))
  call counter_AV_Q(ntry, ex6(:), wf4(:,2), wf8(:,19), n3(:,18), t3x8(:,:,13))
  call counter_AV_Q(ntry, ex6(:), wf4(:,1), wf8(:,20), n3(:,19), t3x8(:,:,14))
  call counter_AZ_Q(gZd,ntry, ex6(:), wf4(:,4), wf8(:,21), n3(:,20), t3x8(:,:,15))
  call counter_VQ_A(ntry, wf4(:,2), ex5(:), wf8(:,22), n3(:,21), t3x8(:,:,16))
  call prop_A_Q(ntry, wf8(:,7), 35, ZERO, 0_intkind1, wf8(:,23), n2(8))
  call prop_A_Q(ntry, wf8(:,9), 35, ZERO, 0_intkind1, wf8(:,24), n2(9))
  call counter_VQ_A(ntry, wf4(:,1), ex5(:), wf8(:,25), n3(:,22), t3x8(:,:,17))
  call prop_A_Q(ntry, wf8(:,2), 44, ZERO, 0_intkind1, wf8(:,26), n2(10))
  call counter_ZQ_A(gZd,ntry, wf4(:,4), ex5(:), wf8(:,27), n3(:,23), t3x8(:,:,18))
  call counter_QA_V(ntry, ex5(:), ex6(:), wf4(:,6), n3(:,24), t3x4(:,:,5))
  call vert_AV_Q(ntry, ex4(:), wf4(:,6), wf8(:,28), n3(:,25), t3x8(:,:,19))
  call vert_VQ_A(ntry, wf4(:,6), ex3(:), wf8(:,29), n3(:,26), t3x8(:,:,20))
  call prop_Q_A(ntry, wf8(:,29), 52, MT, 1_intkind1, wf8(:,30), n2(11))
  call counter_AV_Q(ntry, ex4(:), wf4(:,5), wf8(:,31), n3(:,27), t3x8(:,:,21))
  call counter_AV_Q(ntry, ex4(:), wf4(:,1), wf8(:,32), n3(:,28), t3x8(:,:,22))
  call counter_AZ_Q(gZu,ntry, ex4(:), wf4(:,4), wf8(:,33), n3(:,29), t3x8(:,:,23))
  call counter_VQ_A(ntry, wf4(:,5), ex3(:), wf8(:,34), n3(:,30), t3x8(:,:,24))
  call prop_A_Q(ntry, wf8(:,16), 11, MT, 1_intkind1, wf8(:,35), n2(12))
  call prop_A_Q(ntry, wf8(:,18), 11, MT, 1_intkind1, wf8(:,36), n2(13))
  call counter_VQ_A(ntry, wf4(:,1), ex3(:), wf8(:,37), n3(:,31), t3x8(:,:,25))
  call prop_A_Q(ntry, wf8(:,11), 56, MT, 1_intkind1, wf8(:,38), n2(14))
  call counter_ZQ_A(gZu,ntry, wf4(:,4), ex3(:), wf8(:,39), n3(:,32), t3x8(:,:,26))
  call counter_QA_V(ntry, ex3(:), ex4(:), wf4(:,7), n3(:,33), t3x4(:,:,6))
  call vert_AV_Q(ntry, ex6(:), wf4(:,7), wf8(:,40), n3(:,34), t3x8(:,:,27))
  call vert_VQ_A(ntry, wf4(:,7), ex5(:), wf8(:,41), n3(:,35), t3x8(:,:,28))
  call prop_Q_A(ntry, wf8(:,41), 28, ZERO, 0_intkind1, wf8(:,42), n2(15))
  call counter_V_V(ctGG,21,ntry, wf4(:,2), 12, wf4(:,8), n2(16))
  call vert_VQ_A(ntry, wf4(:,8), ex5(:), wf8(:,43), n3(:,36), t3x8(:,:,29))
  call vert_AV_Q(ntry, ex6(:), wf4(:,8), wf8(:,44), n3(:,37), t3x8(:,:,30))
  call counter_Q_A(ctqq,1,ntry, wf8(:,3), 19, wf8(:,45), n2(17))
  call counter_Q_A(ctqq,1,ntry, wf8(:,5), 19, wf8(:,46), n2(18))
  call counter_Q_A(ctqq,1,ntry, wf8(:,8), 28, wf8(:,47), n2(19))
  call counter_Q_A(cttt,6,ntry, wf8(:,12), 7, wf8(:,48), n2(20))
  call counter_Q_A(cttt,6,ntry, wf8(:,14), 7, wf8(:,49), n2(21))
  call counter_Q_A(cttt,6,ntry, wf8(:,17), 52, wf8(:,50), n2(22))
  call counter_V_V(ctGG,21,ntry, wf4(:,5), 48, wf4(:,9), n2(23))
  call vert_VQ_A(ntry, wf4(:,9), ex3(:), wf8(:,51), n3(:,38), t3x8(:,:,31))
  call vert_AV_Q(ntry, ex4(:), wf4(:,9), wf8(:,52), n3(:,39), t3x8(:,:,32))
  call vert_QA_V(ntry, wf8(:,12), ex4(:), wf16(:,2), n3(:,40), t3x16(:,:,2))
  call vert_QA_V(ntry, wf8(:,14), ex4(:), wf16(:,3), n3(:,41), t3x16(:,:,3))
  call vert_QA_V(ntry, ex3(:), wf8(:,35), wf16(:,4), n3(:,42), t3x16(:,:,4))
  call vert_QA_V(ntry, ex3(:), wf8(:,36), wf16(:,5), n3(:,43), t3x16(:,:,5))
  call vert_QA_V(ntry, wf8(:,3), ex6(:), wf16(:,6), n3(:,44), t3x16(:,:,6))
  call vert_QA_V(ntry, wf8(:,5), ex6(:), wf16(:,7), n3(:,45), t3x16(:,:,7))
  call vert_QA_V(ntry, ex5(:), wf8(:,23), wf16(:,8), n3(:,46), t3x16(:,:,8))
  call vert_QA_V(ntry, ex5(:), wf8(:,24), wf16(:,9), n3(:,47), t3x16(:,:,9))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_exwf(ex5)
  call init_hybrid_exwf(ex6)
  call init_hybrid_wf(wf4)
  call init_hybrid_wf(wf8)
  call init_hybrid_wf(wf16)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do

  call photon_factors(photonid_pplltt_eexttxddx_1, &
                    &  0, bornphotonfactor)
  M02 = bornphotonfactor * M02
  M2ct = bornphotonfactor * M2ct
  M2colint = bornphotonfactor * M2colint

  !! used for born-loop colour-correlators
  extcombs = [(i, i = 0, 22-1)]
  nextcombs = 6*(6+1)/2 + 1
  if(nextcombs>0) then
    allocate(extcombs_permuted(nextcombs))
  end if
  do k = 1, nextcombs
    extcombs_permuted(k) = extcomb_perm_pplltt_eexttxddx_1(extcombs(k))
  end do

#if -1 > 0 && 6 > 3
  !!Born-loop colour correlators interference

  M0M1_hel_cc(:,:,:)%j = 0
  do n = 1, 9
    M2add_ct = 0
    m = ind_cc_comb(n)
      do k = 1, nhel
        call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
        call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
        M2ctcc(m) = M2ctcc(m) + M2add_ct
      end do
  end do
  M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
  M0M1_hel_cc(:,nhel+1:,:)%j = 0
#endif

  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5,i6
integer :: n

n=0

do i6= 1, 2
do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf
 end if
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_QA(nsync, wf8(:,2), wf8(:,3), A(:,1), n3(:,48), t3x64(:,:,1), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,5), A(:,2), n3(:,49), t3x64(:,:,2), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,8), A(:,3), n3(:,50), t3x64(:,:,3), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,9), A(:,4), n3(:,51), t3x64(:,:,4), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,12), A(:,5), n3(:,52), t3x64(:,:,5), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,14), A(:,6), n3(:,53), t3x64(:,:,6), nhel, den(18))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,17), A(:,7), n3(:,54), t3x64(:,:,7), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,17), wf8(:,18), A(:,8), n3(:,55), t3x64(:,:,8), nhel, den(22))

    call Hcont_VV(nsync, wf4(:,5), wf16(:,1), A(:,9), n3(:,56), t3x64(:,:,9), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,19), A(:,10), n3(:,57), t3x64(:,:,10), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,5), wf8(:,19), A(:,11), n3(:,58), t3x64(:,:,11), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,20), A(:,12), n3(:,59), t3x64(:,:,12), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,21), A(:,13), n3(:,60), t3x64(:,:,13), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,23), A(:,14), n3(:,61), t3x64(:,:,14), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,24), A(:,15), n3(:,62), t3x64(:,:,15), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,25), wf8(:,26), A(:,16), n3(:,63), t3x64(:,:,16), nhel, den(32))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,27), A(:,17), n3(:,64), t3x64(:,:,17), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,28), A(:,18), n3(:,65), t3x64(:,:,18), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,28), A(:,19), n3(:,66), t3x64(:,:,19), nhel, den(18))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,30), A(:,20), n3(:,67), t3x64(:,:,20), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,30), A(:,21), n3(:,68), t3x64(:,:,21), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,31), A(:,22), n3(:,69), t3x64(:,:,22), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,31), A(:,23), n3(:,70), t3x64(:,:,23), nhel, den(18))
    call Hcont_QA(nsync, wf8(:,17), wf8(:,32), A(:,24), n3(:,71), t3x64(:,:,24), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,17), wf8(:,33), A(:,25), n3(:,72), t3x64(:,:,25), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,35), A(:,26), n3(:,73), t3x64(:,:,26), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,36), A(:,27), n3(:,74), t3x64(:,:,27), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,37), wf8(:,38), A(:,28), n3(:,75), t3x64(:,:,28), nhel, den(41))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,39), A(:,29), n3(:,76), t3x64(:,:,29), nhel, den(42))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,40), A(:,30), n3(:,77), t3x64(:,:,30), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,5), wf8(:,40), A(:,31), n3(:,78), t3x64(:,:,31), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,42), A(:,32), n3(:,79), t3x64(:,:,32), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,42), A(:,33), n3(:,80), t3x64(:,:,33), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,43), A(:,34), n3(:,81), t3x64(:,:,34), nhel, den(44))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,43), A(:,35), n3(:,82), t3x64(:,:,35), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,44), A(:,36), n3(:,83), t3x64(:,:,36), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,5), wf8(:,44), A(:,37), n3(:,84), t3x64(:,:,37), nhel, den(47))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,45), A(:,38), n3(:,85), t3x64(:,:,38), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,46), A(:,39), n3(:,86), t3x64(:,:,39), nhel, den(49))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,47), A(:,40), n3(:,87), t3x64(:,:,40), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,47), A(:,41), n3(:,88), t3x64(:,:,41), nhel, den(51))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,48), A(:,42), n3(:,89), t3x64(:,:,42), nhel, den(52))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,49), A(:,43), n3(:,90), t3x64(:,:,43), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,35), wf8(:,50), A(:,44), n3(:,91), t3x64(:,:,44), nhel, den(54))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,50), A(:,45), n3(:,92), t3x64(:,:,45), nhel, den(55))
    call Hcont_QA(nsync, wf8(:,35), wf8(:,51), A(:,46), n3(:,93), t3x64(:,:,46), nhel, den(57))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,51), A(:,47), n3(:,94), t3x64(:,:,47), nhel, den(58))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,52), A(:,48), n3(:,95), t3x64(:,:,48), nhel, den(59))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,52), A(:,49), n3(:,96), t3x64(:,:,49), nhel, den(60))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(2), M2(2) ! M1helarray(2,64)
  integer :: empty(0), i

  M1(1)%j = ((A(j,1)%j+A(j,3)%j)*f(1))/2._/**/REALKIND+((-A(j,5)%j-A(j,7)%j)*f(2))/2._/**/REALKIND+((A(j,2)%j+A(j,4)%j+A(j,6)%j &
       +A(j,8)%j)*f(3))/2._/**/REALKIND
  M1(2)%j = ((-A(j,1)%j-A(j,3)%j)*f(1))/6._/**/REALKIND+((A(j,5)%j+A(j,7)%j)*f(2))/6._/**/REALKIND+((-A(j,2)%j-A(j,4)%j-A(j,6)%j &
       -A(j,8)%j)*f(3))/6._/**/REALKIND

  M2(1)%j = ((-A(j,34)%j-A(j,36)%j-A(j,38)%j-A(j,40)%j)*f(4))/2._/**/REALKIND+((A(j,42)%j+A(j,44)%j+A(j,46)%j &
       +A(j,48)%j)*f(5))/2._/**/REALKIND+((-A(j,35)%j-A(j,37)%j-A(j,39)%j-A(j,41)%j-A(j,43)%j-A(j,45)%j-A(j,47)%j &
       -A(j,49)%j)*f(6))/2._/**/REALKIND+((A(j,10)%j+A(j,14)%j)*f(7))/2._/**/REALKIND+((-A(j,18)%j &
       -A(j,20)%j)*f(8))/2._/**/REALKIND+((A(j,11)%j+A(j,15)%j+A(j,19)%j+A(j,21)%j)*f(9))/2._/**/REALKIND+((A(j,30)%j &
       +A(j,32)%j)*f(10))/2._/**/REALKIND+((-A(j,22)%j-A(j,26)%j)*f(11))/2._/**/REALKIND+((A(j,23)%j+A(j,27)%j+A(j,31)%j &
       +A(j,33)%j)*f(12))/2._/**/REALKIND+((A(j,12)%j+A(j,16)%j)*f(13))/2._/**/REALKIND+((A(j,13)%j &
       +A(j,17)%j)*f(14))/2._/**/REALKIND+((-A(j,24)%j-A(j,28)%j)*f(15))/2._/**/REALKIND+((A(j,25)%j &
       +A(j,29)%j)*f(16))/2._/**/REALKIND-(A(j,9)%j*f(17))/2._/**/REALKIND
  M2(2)%j = ((A(j,34)%j+A(j,36)%j+A(j,38)%j+A(j,40)%j)*f(4))/6._/**/REALKIND+((-A(j,42)%j-A(j,44)%j-A(j,46)%j &
       -A(j,48)%j)*f(5))/6._/**/REALKIND+((A(j,35)%j+A(j,37)%j+A(j,39)%j+A(j,41)%j+A(j,43)%j+A(j,45)%j+A(j,47)%j &
       +A(j,49)%j)*f(6))/6._/**/REALKIND+((-A(j,10)%j-A(j,14)%j)*f(7))/6._/**/REALKIND+((A(j,18)%j &
       +A(j,20)%j)*f(8))/6._/**/REALKIND+((-A(j,11)%j-A(j,15)%j-A(j,19)%j-A(j,21)%j)*f(9))/6._/**/REALKIND+((-A(j,30)%j &
       -A(j,32)%j)*f(10))/6._/**/REALKIND+((A(j,22)%j+A(j,26)%j)*f(11))/6._/**/REALKIND+((-A(j,23)%j-A(j,27)%j-A(j,31)%j &
       -A(j,33)%j)*f(12))/6._/**/REALKIND+((-A(j,12)%j-A(j,16)%j)*f(13))/6._/**/REALKIND+((-A(j,13)%j &
       -A(j,17)%j)*f(14))/6._/**/REALKIND+((A(j,24)%j+A(j,28)%j)*f(15))/6._/**/REALKIND+((-A(j,25)%j &
       -A(j,29)%j)*f(16))/6._/**/REALKIND+(A(j,9)%j*f(17))/6._/**/REALKIND


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pplltt_eexttxddx_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(2)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 2
      do j = 1, 2
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pplltt_eexttxddx_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(2), Mct(2)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 2
    do j = 1, 2
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+2*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_pplltt_eexttxddx_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(2)
  real(REALKIND),    intent(out) :: M2IRadd(22)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 23-1
    colmatpos = 2*k
    do i = 1, 2
      do j = 1, 2
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pplltt_eexttxddx_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(2)
  complex(REALKIND), intent(in)  :: M2(2)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 2
    do j = 1, 2
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_pplltt_eexttxddx_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(2)
  type(Hpolcont), intent(out)  :: M0_col(2)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 2 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 2 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+2*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_pplltt_eexttxddx_1_/**/REALKIND
