
module ol_vamp_1_ppllnnjj_vbs_nexnmxemucdxsx_2_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllnnjj_vbs_nexnmxemucdxsx_2.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllnnjj_vbs_nexnmxemucdxsx_2.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppllnnjj_vbs_nexnmxemucdxsx_2_/**/DREALKIND
  use ol_tensor_sum_storage_ppllnnjj_vbs_nexnmxemucdxsx_2_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppllnnjj_vbs_nexnmxemucdxsx_2_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppllnnjj_vbs_nexnmxemucdxsx_2_/**/DREALKIND, only: ntryL, p_switch, Hel
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(256)
  type(Hpolcont), intent(in) :: M(1,256)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(1),h0tab(:,1),[128,10,80,5,32],[0,0,0,0,0],5,3,wf4(:,6),wf4(:,7),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,1),heltab2x256(:,:,1))
  call Hloop_A_Q(ntryL,G0H128(1),128,0,G1H128(1),n2h128(1))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(2),h0tab(:,2),[128,5,80,10,32],[0,0,0,0,0],5,3,wf4(:,5),wf4(:,7),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,2),heltab2x256(:,:,2))
  call Hloop_A_Q(ntryL,G0H128(1),128,0,G1H128(2),n2h128(2))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(333)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(3),h0tab(:,3),[160,5,16,64,10],[0,0,0,0,0],5,3,wf4(:,8),wf4(:,5),wf4(:,6))
  call Hloop_AW_Q(ntryL,G0H256(1),wf4(:,8),G0H64(1),m3h4x64(:,1),heltab2x256(:,:,3))
  call Hloop_A_Q(ntryL,G0H64(1),160,0,G1H64(1),n2h64(1))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(333)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(4),h0tab(:,4),[160,5,64,16,10],[0,0,0,0,0],5,3,wf4(:,8),wf4(:,5),wf4(:,6))
  call Hloop_QW_A(ntryL,G0H256(1),wf4(:,8),G0H64(1),m3h4x64(:,2),heltab2x256(:,:,4))
  call Hloop_Q_A(ntryL,G0H64(1),160,0,G1H64(2),n2h64(2))
  call Hloop_AW_Q(ntryL,G1H128(1),wf4(:,6),G1H32(1),m3h4x32(:,1),heltab2x128(:,:,1))
  call Hloop_A_Q(ntryL,G1H32(1),138,0,G2H32(1),n2h32(1))
  call Hloop_AW_Q(ntryL,G1H128(2),wf4(:,5),G1H32(1),m3h4x32(:,2),heltab2x128(:,:,2))
  call Hloop_A_Q(ntryL,G1H32(1),133,0,G2H32(2),n2h32(2))
  call Hloop_AW_Q(ntryL,G1H64(1),wf4(:,5),G1H16(1),m3h4x16(:,1),heltab2x64(:,:,1))
  call Hloop_A_Q(ntryL,G1H16(1),165,0,G2H16(1),n2h16(1))
  call Hloop_QW_A(ntryL,G1H64(2),wf4(:,5),G1H16(1),m3h4x16(:,2),heltab2x64(:,:,2))
  call Hloop_Q_A(ntryL,G1H16(1),165,0,G2H16(2),n2h16(2))
call Hotf_5pt_reduction(G2H32(1),RedSet_5(1),mass5set(:,1),  & 
G1H32(1),G1H32(2),G1H32(3),G1H32(4),G1H32(5),G1H32(6),32)
call HG1shiftOLR(G1H32(2),32,32)
call Hotf_5pt_reduction(G2H32(2),RedSet_5(2),mass5set(:,1),  & 
G1H32(7),G1H32(8),G1H32(9),G1H32(10),G1H32(11),G1H32(12),32)
call HG1shiftOLR(G1H32(8),32,32)
  call Hloop_AQ_V(ntryL,G2H16(1),ex5(:),G2H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_QA_V(ntryL,G2H16(2),ex7(:),G2H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_AW_Q(ntryL,G1H32(1),wf4(:,7),G1H8(1),m3h4x8(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(1),218,0,G2H8(3),n2h8(1))
call HGT_raise_alpha_OLR(G1H32(2),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(2),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(2),ex6(:),G1H16(1),m3h2x16(:,1),heltab2x32(:,:,2))
  call Hloop_AW_Q(ntryL,G1H32(4),wf4(:,7),G1H8(1),m3h4x8(:,2),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G1H8(1),218,0,G2H8(4),n2h8(2))
  call Hloop_AW_Q(ntryL,G1H32(5),wf4(:,7),G1H8(1),m3h4x8(:,3),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G1H8(1),218,0,G2H8(5),n2h8(3))
  call Hloop_AW_Q(ntryL,G1H32(6),wf4(:,7),G1H8(1),m3h4x8(:,4),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G1H8(1),218,0,G2H8(6),n2h8(4))
  call Hloop_AW_Q(ntryL,G1H32(7),wf4(:,7),G1H8(1),m3h4x8(:,5),heltab2x32(:,:,6))
  call Hloop_A_Q(ntryL,G1H8(1),213,0,G2H8(7),n2h8(5))
call HGT_raise_alpha_OLR(G1H32(8),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(8),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(8),ex6(:),G1H16(2),m3h2x16(:,2),heltab2x32(:,:,7))
  call Hloop_AW_Q(ntryL,G1H32(10),wf4(:,7),G1H8(1),m3h4x8(:,6),heltab2x32(:,:,8))
  call Hloop_A_Q(ntryL,G1H8(1),213,0,G2H8(8),n2h8(6))
  call Hloop_AW_Q(ntryL,G1H32(11),wf4(:,7),G1H8(1),m3h4x8(:,7),heltab2x32(:,:,9))
  call Hloop_A_Q(ntryL,G1H8(1),213,0,G2H8(9),n2h8(7))
  call Hloop_AW_Q(ntryL,G1H32(12),wf4(:,7),G1H8(1),m3h4x8(:,8),heltab2x32(:,:,10))
  call Hloop_A_Q(ntryL,G1H8(1),213,0,G2H8(10),n2h8(8))
call Hotf_5pt_reduction(G2H8(1),RedSet_5(3),mass5set(:,1),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),G1H8(6),8)
call HG1shiftOLR(G1H8(2),10,8)
call Hotf_5pt_reduction(G2H8(2),RedSet_5(4),mass5set(:,1),  & 
G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),G1H8(12),8)
call HG1shiftOLR(G1H8(8),10,8)
call Hotf_5pt_reduction(G2H8(3),RedSet_5(1),mass5set(:,1),  & 
G1H8(13),G1H8(14),G1H8(15),G1H8(16),G1H8(17),G1H8(18),8)
call HG1shiftOLR(G1H8(14),32,8)
call Hotf_4pt_reduction(G2H8(5),RedSet_4(1),mass4set(:,1),  & 
G1H8(19),G1H8(20),G1H8(21),G1H8(22),G1H8(23),8)
call HG1shiftOLR(G1H8(20),32,8)
call Hotf_4pt_reduction(G2H8(6),RedSet_4(2),mass4set(:,1),  & 
G1H8(24),G1H8(25),G1H8(26),G1H8(27),G1H8(28),8)
call HG1shiftOLR(G1H8(25),37,8)
call Hotf_5pt_reduction(G2H8(7),RedSet_5(2),mass5set(:,1),  & 
G1H8(29),G1H8(30),G1H8(31),G1H8(32),G1H8(33),G1H8(34),8)
call HG1shiftOLR(G1H8(30),32,8)
call Hotf_4pt_reduction(G2H8(9),RedSet_4(3),mass4set(:,1),  & 
G1H8(35),G1H8(36),G1H8(37),G1H8(38),G1H8(39),8)
call HG1shiftOLR(G1H8(36),32,8)
call Hotf_4pt_reduction(G2H8(10),RedSet_4(4),mass4set(:,1),  & 
G1H8(40),G1H8(41),G1H8(42),G1H8(43),G1H8(44),8)
call HG1shiftOLR(G1H8(41),42,8)
  call ol_merge(ntryL,G1H8(19),[G1H8(17)])
  call ol_merge(ntryL,G1H8(24),[G1H8(18)])
  call ol_merge(ntryL,G1H8(35),[G1H8(33)])
  call ol_merge(ntryL,G1H8(40),[G1H8(34)])
  call Hloop_VA_Q(ntryL,G1H8(1),ex7(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_A_Q(ntryL,G1H4(1),245,0,G2H4(1),n2h4(1))
call HGT_OLR(G1H8(2),1,1,8)
call HGT_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(2),-10,0,G2H8(1),n2h8(9))
  call Hloop_QW_A(ntryL,G2H8(1),wf4(:,6),G2H2(1),m3h4x2(:,1),heltab2x8(:,:,2))
  call Hloop_VA_Q(ntryL,G1H8(5),ex7(:),G1H4(1),m3h2x4(:,2),heltab2x8(:,:,3))
  call Hloop_A_Q(ntryL,G1H4(1),245,0,G2H4(2),n2h4(2))
  call Hloop_VA_Q(ntryL,G1H8(6),ex7(:),G1H4(1),m3h2x4(:,3),heltab2x8(:,:,4))
  call Hloop_A_Q(ntryL,G1H4(1),245,0,G2H4(3),n2h4(3))
  call Hloop_VQ_A(ntryL,G1H8(7),ex5(:),G1H4(1),m3h2x4(:,4),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(1),245,0,G2H4(4),n2h4(4))
call HGT_OLR(G1H8(8),1,1,8)
call HGT_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(8),-10,0,G2H8(2),n2h8(10))
  call Hloop_AW_Q(ntryL,G2H8(2),wf4(:,6),G2H2(2),m3h4x2(:,2),heltab2x8(:,:,6))
  call Hloop_VQ_A(ntryL,G1H8(11),ex5(:),G1H4(1),m3h2x4(:,5),heltab2x8(:,:,7))
  call Hloop_Q_A(ntryL,G1H4(1),245,0,G2H4(5),n2h4(5))
  call Hloop_VQ_A(ntryL,G1H8(12),ex5(:),G1H4(1),m3h2x4(:,6),heltab2x8(:,:,8))
  call Hloop_Q_A(ntryL,G1H4(1),245,0,G2H4(6),n2h4(6))
  call Hloop_AW_Q(ntryL,G1H8(13),wf4(:,5),G1H2(1),m3h4x2(:,3),heltab2x8(:,:,9))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(3),n2h2(1))
call HGT_raise_alpha_OLR(G1H8(14),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(14),ex6(:),G1H4(1),m3h2x4(:,7),heltab2x8(:,:,10))
  call Hloop_AW_Q(ntryL,G1H8(19),wf4(:,5),G1H2(1),m3h4x2(:,4),heltab2x8(:,:,11))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(4),n2h2(2))
  call Hloop_AW_Q(ntryL,G1H8(24),wf4(:,5),G1H2(1),m3h4x2(:,5),heltab2x8(:,:,12))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(5),n2h2(3))
call HGT_raise_alpha_OLR(G1H8(20),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(20),ex6(:),G1H4(2),m3h2x4(:,8),heltab2x8(:,:,13))
  call Hloop_AW_Q(ntryL,G1H8(23),wf4(:,5),G1H2(1),m3h4x2(:,6),heltab2x8(:,:,14))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(6),n2h2(4))
call HGT_raise_alpha_OLR(G1H8(25),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(25),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(25),ex6(:),G1H4(3),m3h2x4(:,9),heltab2x8(:,:,15))
  call Hloop_AW_Q(ntryL,G1H8(28),wf4(:,5),G1H2(1),m3h4x2(:,7),heltab2x8(:,:,16))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(7),n2h2(5))
  call Hloop_AW_Q(ntryL,G1H8(29),wf4(:,6),G1H2(1),m3h4x2(:,8),heltab2x8(:,:,17))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(8),n2h2(6))
call HGT_raise_alpha_OLR(G1H8(30),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(30),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(30),ex6(:),G1H4(4),m3h2x4(:,10),heltab2x8(:,:,18))
  call Hloop_AW_Q(ntryL,G1H8(35),wf4(:,6),G1H2(1),m3h4x2(:,9),heltab2x8(:,:,19))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(9),n2h2(7))
  call Hloop_AW_Q(ntryL,G1H8(40),wf4(:,6),G1H2(1),m3h4x2(:,10),heltab2x8(:,:,20))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(10),n2h2(8))
call HGT_raise_alpha_OLR(G1H8(36),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(36),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(36),ex6(:),G1H4(5),m3h2x4(:,11),heltab2x8(:,:,21))
  call Hloop_AW_Q(ntryL,G1H8(39),wf4(:,6),G1H2(1),m3h4x2(:,11),heltab2x8(:,:,22))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(11),n2h2(9))
call HGT_raise_alpha_OLR(G1H8(41),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(41),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(41),ex6(:),G1H4(6),m3h2x4(:,12),heltab2x8(:,:,23))
  call Hloop_AW_Q(ntryL,G1H8(44),wf4(:,6),G1H2(1),m3h4x2(:,12),heltab2x8(:,:,24))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(12),n2h2(10))
call Hotf_5pt_reduction(G2H4(1),RedSet_5(3),mass5set(:,1),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
call HG1shiftOLR(G1H4(8),10,4)
call Hotf_4pt_reduction(G2H4(3),RedSet_4(5),mass4set(:,1),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),4)
call HG1shiftOLR(G1H4(14),74,4)
call Hotf_5pt_reduction(G2H4(4),RedSet_5(4),mass5set(:,1),  & 
G1H4(18),G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),4)
call HG1shiftOLR(G1H4(19),10,4)
call Hotf_4pt_reduction(G2H4(6),RedSet_4(6),mass4set(:,1),  & 
G1H4(24),G1H4(25),G1H4(26),G1H4(27),G1H4(28),4)
call HG1shiftOLR(G1H4(25),26,4)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(3),ex6(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(5),ex6(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(8),ex6(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(10),ex6(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call ol_merge(ntryL,G1H4(13),[G1H4(12)])
  call ol_merge(ntryL,G1H4(24),[G1H4(23)])
  call Hloop_AW_Q(ntryL,G1H4(7),wf4(:,6),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,1))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),255,0,G2tensor(5),n2h1(1))
  call Hloop_AW_Q(ntryL,G1H4(8),wf4(:,6),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,2))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(6),n2h1(2))
  call Hloop_AW_Q(ntryL,G1H4(13),wf4(:,6),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,3))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),255,0,G2tensor(7),n2h1(3))
  call Hloop_AW_Q(ntryL,G1H4(14),wf4(:,6),G1H1(1),m3h4x1(:,4),heltab2x4(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),74,0,G2tensor(8),n2h1(4))
  call Hloop_QW_A(ntryL,G1H4(18),wf4(:,6),G1H1(1),m3h4x1(:,5),heltab2x4(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(9),n2h1(5))
  call Hloop_QW_A(ntryL,G1H4(19),wf4(:,6),G1H1(1),m3h4x1(:,6),heltab2x4(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(10),n2h1(6))
  call Hloop_QW_A(ntryL,G1H4(24),wf4(:,6),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(11),n2h1(7))
  call Hloop_QW_A(ntryL,G1H4(25),wf4(:,6),G1H1(1),m3h4x1(:,8),heltab2x4(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),26,0,G2tensor(12),n2h1(8))
call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
call G_TensorShift(G1tensor(2),32)
call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(2),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
call G_TensorShift(G1tensor(8),32)
call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(3),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
call G_TensorShift(G1tensor(14),10)
call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(4),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
call G_TensorShift(G1tensor(20),10)
call ol_merge_tensors(T1sum(1),[G1tensor(1)])
call ol_merge_tensors(T1sum(2),[G1tensor(7)])
call ol_merge_tensors(T1sum(3),[G1tensor(13)])
call ol_merge_tensors(T1sum(4),[G1tensor(19)])
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(626)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(5),h0tab(:,5),[128,10,80,37],[0,0,0,0],4,3,wf4(:,6),wf4(:,7),wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,3),heltab2x256(:,:,5))
  call Hloop_A_Q(ntryL,G0H128(1),128,0,G1H128(1),n2h128(3))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(629)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(6),h0tab(:,6),[133,32,10,80],[0,0,0,0],4,3,wf8(:,8),wf4(:,6),wf4(:,7))
  call Hloop_QA_V(ntryL,G0H256(1),wf8(:,8),G0H32(1),m3h8x32(:,1),heltab2x256(:,:,6))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(631)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(7),h0tab(:,7),[128,5,80,42],[0,0,0,0],4,3,wf4(:,5),wf4(:,7),wf8(:,7))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,4),heltab2x256(:,:,7))
  call Hloop_A_Q(ntryL,G0H128(1),128,0,G1H128(2),n2h128(4))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(633)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(8),h0tab(:,8),[138,32,5,80],[0,0,0,0],4,3,wf8(:,4),wf4(:,5),wf4(:,7))
  call Hloop_QA_V(ntryL,G0H256(1),wf8(:,4),G0H32(2),m3h8x32(:,2),heltab2x256(:,:,8))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(338)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(9),h0tab(:,9),[128,32,10,85],[0,0,0,0],4,2,wf4(:,6),wf16(:,3))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,5),heltab2x256(:,:,9))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(340)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(10),h0tab(:,10),[128,32,10,85],[0,0,0,0],4,2,wf4(:,6),wf16(:,5))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(2),m3h2x128(:,6),heltab2x256(:,:,10))
Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(338)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(11),h0tab(:,11),[128,10,85,32],[0,0,0,0],4,2,wf4(:,6),wf16(:,3))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(3),m3h2x128(:,7),heltab2x256(:,:,11))
  call Hloop_A_Q(ntryL,G0H128(3),128,0,G1H128(3),n2h128(5))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(340)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(12),h0tab(:,12),[128,10,85,32],[0,0,0,0],4,2,wf4(:,6),wf16(:,5))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(3),m3h2x128(:,8),heltab2x256(:,:,12))
  call Hloop_A_Q(ntryL,G0H128(3),128,0,G1H128(4),n2h128(6))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(346)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(13),h0tab(:,13),[128,32,5,90],[0,0,0,0],4,2,wf4(:,5),wf16(:,9))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(3),m3h2x128(:,9),heltab2x256(:,:,13))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(348)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(14),h0tab(:,14),[128,32,5,90],[0,0,0,0],4,2,wf4(:,5),wf16(:,12))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(4),m3h2x128(:,10),heltab2x256(:,:,14))
Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(346)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(15),h0tab(:,15),[128,5,90,32],[0,0,0,0],4,2,wf4(:,5),wf16(:,9))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(5),m3h2x128(:,11),heltab2x256(:,:,15))
  call Hloop_A_Q(ntryL,G0H128(5),128,0,G1H128(5),n2h128(7))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(348)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(16),h0tab(:,16),[128,5,90,32],[0,0,0,0],4,2,wf4(:,5),wf16(:,12))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(5),m3h2x128(:,12),heltab2x256(:,:,16))
  call Hloop_A_Q(ntryL,G0H128(5),128,0,G1H128(6),n2h128(8))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(644)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(17),h0tab(:,17),[160,10,64,21],[0,0,0,0],4,3,wf4(:,8),wf4(:,6),wf8(:,11))
  call Hloop_QW_A(ntryL,G0H256(1),wf4(:,8),G0H64(1),m3h4x64(:,3),heltab2x256(:,:,17))
  call Hloop_Q_A(ntryL,G0H64(1),160,0,G1H64(1),n2h64(3))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(647)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(18),h0tab(:,18),[160,10,16,69],[0,0,0,0],4,3,wf4(:,8),wf4(:,6),wf8(:,16))
  call Hloop_AW_Q(ntryL,G0H256(1),wf4(:,8),G0H64(1),m3h4x64(:,4),heltab2x256(:,:,18))
  call Hloop_A_Q(ntryL,G0H64(1),160,0,G1H64(2),n2h64(4))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(649)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(19),h0tab(:,19),[160,5,64,26],[0,0,0,0],4,3,wf4(:,8),wf4(:,5),wf8(:,15))
  call Hloop_QW_A(ntryL,G0H256(1),wf4(:,8),G0H64(1),m3h4x64(:,5),heltab2x256(:,:,19))
  call Hloop_Q_A(ntryL,G0H64(1),160,0,G1H64(3),n2h64(5))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(651)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(20),h0tab(:,20),[160,5,16,74],[0,0,0,0],4,3,wf4(:,8),wf4(:,5),wf8(:,12))
  call Hloop_AW_Q(ntryL,G0H256(1),wf4(:,8),G0H64(1),m3h4x64(:,6),heltab2x256(:,:,20))
  call Hloop_A_Q(ntryL,G0H64(1),160,0,G1H64(4),n2h64(6))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(352)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(21),h0tab(:,21),[165,10,16,64],[0,0,0,0],4,2,wf16(:,8),wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H256(1),wf16(:,8),G0H16(1),m3h16x16(:,1),heltab2x256(:,:,21))
  call Hloop_A_Q(ntryL,G0H16(1),165,0,G1H16(3),n2h16(3))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(354)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(22),h0tab(:,22),[165,10,16,64],[0,0,0,0],4,2,wf16(:,10),wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H256(1),wf16(:,10),G0H16(1),ngZd,m3h16x16(:,2),heltab2x256(:,:,22))
  call Hloop_A_Q(ntryL,G0H16(1),165,0,G1H16(4),n2h16(4))
Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(352)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(23),h0tab(:,23),[165,10,64,16],[0,0,0,0],4,2,wf16(:,8),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H256(1),wf16(:,8),G0H16(1),m3h16x16(:,3),heltab2x256(:,:,23))
  call Hloop_Q_A(ntryL,G0H16(1),165,0,G1H16(5),n2h16(5))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(354)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(24),h0tab(:,24),[165,10,64,16],[0,0,0,0],4,2,wf16(:,10),wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H256(1),wf16(:,10),G0H16(1),ngZu,m3h16x16(:,4),heltab2x256(:,:,24))
  call Hloop_Q_A(ntryL,G0H16(1),165,0,G1H16(6),n2h16(6))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(360)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(25),h0tab(:,25),[170,5,16,64],[0,0,0,0],4,2,wf16(:,4),wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H256(1),wf16(:,4),G0H16(1),m3h16x16(:,5),heltab2x256(:,:,25))
  call Hloop_A_Q(ntryL,G0H16(1),170,0,G1H16(7),n2h16(7))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(362)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(26),h0tab(:,26),[170,5,16,64],[0,0,0,0],4,2,wf16(:,21),wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H256(1),wf16(:,21),G0H16(1),ngZd,m3h16x16(:,6),heltab2x256(:,:,26))
  call Hloop_A_Q(ntryL,G0H16(1),170,0,G1H16(8),n2h16(8))
Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(360)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(27),h0tab(:,27),[170,5,64,16],[0,0,0,0],4,2,wf16(:,4),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H256(1),wf16(:,4),G0H16(1),m3h16x16(:,7),heltab2x256(:,:,27))
  call Hloop_Q_A(ntryL,G0H16(1),170,0,G1H16(9),n2h16(9))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(362)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(28),h0tab(:,28),[170,5,64,16],[0,0,0,0],4,2,wf16(:,21),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H256(1),wf16(:,21),G0H16(1),ngZu,m3h16x16(:,8),heltab2x256(:,:,28))
  call Hloop_Q_A(ntryL,G0H16(1),170,0,G1H16(10),n2h16(10))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(370)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(29),h0tab(:,29),[128,32,10,85],[0,0,0,0],4,2,wf4(:,6),wf16(:,20))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(5),m3h2x128(:,13),heltab2x256(:,:,29))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(372)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(30),h0tab(:,30),[128,32,10,85],[0,0,0,0],4,2,wf4(:,6),wf16(:,29))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(6),m3h2x128(:,14),heltab2x256(:,:,30))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(370)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(31),h0tab(:,31),[128,10,85,32],[0,0,0,0],4,2,wf4(:,6),wf16(:,20))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(7),m3h2x128(:,15),heltab2x256(:,:,31))
  call Hloop_A_Q(ntryL,G0H128(7),128,0,G1H128(7),n2h128(9))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(372)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(32),h0tab(:,32),[128,10,85,32],[0,0,0,0],4,2,wf4(:,6),wf16(:,29))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(7),m3h2x128(:,16),heltab2x256(:,:,32))
  call Hloop_A_Q(ntryL,G0H128(7),128,0,G1H128(8),n2h128(10))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(380)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(33),h0tab(:,33),[165,10,16,64],[0,0,0,0],4,2,wf16(:,11),wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H256(1),wf16(:,11),G0H16(1),m3h16x16(:,9),heltab2x256(:,:,33))
  call Hloop_A_Q(ntryL,G0H16(1),165,0,G1H16(11),n2h16(11))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(382)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(34),h0tab(:,34),[165,10,16,64],[0,0,0,0],4,2,wf16(:,74),wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H256(1),wf16(:,74),G0H16(1),ngZd,m3h16x16(:,10),heltab2x256(:,:,34))
  call Hloop_A_Q(ntryL,G0H16(1),165,0,G1H16(12),n2h16(12))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(380)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(35),h0tab(:,35),[165,10,64,16],[0,0,0,0],4,2,wf16(:,11),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H256(1),wf16(:,11),G0H16(1),m3h16x16(:,11),heltab2x256(:,:,35))
  call Hloop_Q_A(ntryL,G0H16(1),165,0,G1H16(13),n2h16(13))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(382)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(36),h0tab(:,36),[165,10,64,16],[0,0,0,0],4,2,wf16(:,74),wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H256(1),wf16(:,74),G0H16(1),ngZu,m3h16x16(:,12),heltab2x256(:,:,36))
  call Hloop_Q_A(ntryL,G0H16(1),165,0,G1H16(14),n2h16(14))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(390)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(37),h0tab(:,37),[128,32,10,85],[0,0,0,0],4,2,wf4(:,6),wf16(:,23))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(7),m3h2x128(:,17),heltab2x256(:,:,37))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(392)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(38),h0tab(:,38),[128,32,10,85],[0,0,0,0],4,2,wf4(:,6),wf16(:,33))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(8),m3h2x128(:,18),heltab2x256(:,:,38))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(390)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(39),h0tab(:,39),[128,10,85,32],[0,0,0,0],4,2,wf4(:,6),wf16(:,23))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(9),m3h2x128(:,19),heltab2x256(:,:,39))
  call Hloop_A_Q(ntryL,G0H128(9),128,0,G1H128(9),n2h128(11))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(392)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(40),h0tab(:,40),[128,10,85,32],[0,0,0,0],4,2,wf4(:,6),wf16(:,33))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(9),m3h2x128(:,20),heltab2x256(:,:,40))
  call Hloop_A_Q(ntryL,G0H128(9),128,0,G1H128(10),n2h128(12))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(400)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(41),h0tab(:,41),[165,10,16,64],[0,0,0,0],4,2,wf16(:,14),wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H256(1),wf16(:,14),G0H16(1),m3h16x16(:,13),heltab2x256(:,:,41))
  call Hloop_A_Q(ntryL,G0H16(1),165,0,G1H16(15),n2h16(15))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(402)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(42),h0tab(:,42),[165,10,16,64],[0,0,0,0],4,2,wf16(:,34),wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H256(1),wf16(:,34),G0H16(1),ngZd,m3h16x16(:,14),heltab2x256(:,:,42))
  call Hloop_A_Q(ntryL,G0H16(1),165,0,G1H16(16),n2h16(16))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(400)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(43),h0tab(:,43),[165,10,64,16],[0,0,0,0],4,2,wf16(:,14),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H256(1),wf16(:,14),G0H16(1),m3h16x16(:,15),heltab2x256(:,:,43))
  call Hloop_Q_A(ntryL,G0H16(1),165,0,G1H16(17),n2h16(17))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(402)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(44),h0tab(:,44),[165,10,64,16],[0,0,0,0],4,2,wf16(:,34),wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H256(1),wf16(:,34),G0H16(1),ngZu,m3h16x16(:,16),heltab2x256(:,:,44))
  call Hloop_Q_A(ntryL,G0H16(1),165,0,G1H16(18),n2h16(18))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(408)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(45),h0tab(:,45),[128,32,5,90],[0,0,0,0],4,2,wf4(:,5),wf16(:,25))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(9),m3h2x128(:,21),heltab2x256(:,:,45))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(410)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(46),h0tab(:,46),[128,32,5,90],[0,0,0,0],4,2,wf4(:,5),wf16(:,31))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(10),m3h2x128(:,22),heltab2x256(:,:,46))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(408)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(47),h0tab(:,47),[128,5,90,32],[0,0,0,0],4,2,wf4(:,5),wf16(:,25))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(11),m3h2x128(:,23),heltab2x256(:,:,47))
  call Hloop_A_Q(ntryL,G0H128(11),128,0,G1H128(11),n2h128(13))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(410)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(48),h0tab(:,48),[128,5,90,32],[0,0,0,0],4,2,wf4(:,5),wf16(:,31))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(11),m3h2x128(:,24),heltab2x256(:,:,48))
  call Hloop_A_Q(ntryL,G0H128(11),128,0,G1H128(12),n2h128(14))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(416)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(49),h0tab(:,49),[170,5,16,64],[0,0,0,0],4,2,wf16(:,16),wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H256(1),wf16(:,16),G0H16(1),m3h16x16(:,17),heltab2x256(:,:,49))
  call Hloop_A_Q(ntryL,G0H16(1),170,0,G1H16(19),n2h16(19))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(418)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(50),h0tab(:,50),[170,5,16,64],[0,0,0,0],4,2,wf16(:,73),wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H256(1),wf16(:,73),G0H16(1),ngZd,m3h16x16(:,18),heltab2x256(:,:,50))
  call Hloop_A_Q(ntryL,G0H16(1),170,0,G1H16(20),n2h16(20))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(416)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(51),h0tab(:,51),[170,5,64,16],[0,0,0,0],4,2,wf16(:,16),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H256(1),wf16(:,16),G0H16(1),m3h16x16(:,19),heltab2x256(:,:,51))
  call Hloop_Q_A(ntryL,G0H16(1),170,0,G1H16(21),n2h16(21))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(418)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(52),h0tab(:,52),[170,5,64,16],[0,0,0,0],4,2,wf16(:,73),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H256(1),wf16(:,73),G0H16(1),ngZu,m3h16x16(:,20),heltab2x256(:,:,52))
  call Hloop_Q_A(ntryL,G0H16(1),170,0,G1H16(22),n2h16(22))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(424)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(53),h0tab(:,53),[128,32,5,90],[0,0,0,0],4,2,wf4(:,5),wf16(:,27))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(11),m3h2x128(:,25),heltab2x256(:,:,53))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(426)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(54),h0tab(:,54),[128,32,5,90],[0,0,0,0],4,2,wf4(:,5),wf16(:,32))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(12),m3h2x128(:,26),heltab2x256(:,:,54))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(424)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(55),h0tab(:,55),[128,5,90,32],[0,0,0,0],4,2,wf4(:,5),wf16(:,27))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(13),m3h2x128(:,27),heltab2x256(:,:,55))
  call Hloop_A_Q(ntryL,G0H128(13),128,0,G1H128(13),n2h128(15))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(426)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(56),h0tab(:,56),[128,5,90,32],[0,0,0,0],4,2,wf4(:,5),wf16(:,32))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(13),m3h2x128(:,28),heltab2x256(:,:,56))
  call Hloop_A_Q(ntryL,G0H128(13),128,0,G1H128(14),n2h128(16))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(432)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(57),h0tab(:,57),[170,5,16,64],[0,0,0,0],4,2,wf16(:,18),wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H256(1),wf16(:,18),G0H16(1),m3h16x16(:,21),heltab2x256(:,:,57))
  call Hloop_A_Q(ntryL,G0H16(1),170,0,G1H16(23),n2h16(23))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(434)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(58),h0tab(:,58),[170,5,16,64],[0,0,0,0],4,2,wf16(:,30),wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H256(1),wf16(:,30),G0H16(1),ngZd,m3h16x16(:,22),heltab2x256(:,:,58))
  call Hloop_A_Q(ntryL,G0H16(1),170,0,G1H16(24),n2h16(24))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(432)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(59),h0tab(:,59),[170,5,64,16],[0,0,0,0],4,2,wf16(:,18),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H256(1),wf16(:,18),G0H16(1),m3h16x16(:,23),heltab2x256(:,:,59))
  call Hloop_Q_A(ntryL,G0H16(1),170,0,G1H16(25),n2h16(25))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(434)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(60),h0tab(:,60),[170,5,64,16],[0,0,0,0],4,2,wf16(:,30),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H256(1),wf16(:,30),G0H16(1),ngZu,m3h16x16(:,24),heltab2x256(:,:,60))
  call Hloop_Q_A(ntryL,G0H16(1),170,0,G1H16(26),n2h16(26))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(440)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(61),h0tab(:,61),[128,32,5,90],[0,0,0,0],4,2,wf4(:,5),wf16(:,35))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(13),m3h2x128(:,29),heltab2x256(:,:,61))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(442)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(62),h0tab(:,62),[128,32,5,90],[0,0,0,0],4,2,wf4(:,5),wf16(:,41))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(14),m3h2x128(:,30),heltab2x256(:,:,62))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(440)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(63),h0tab(:,63),[128,5,90,32],[0,0,0,0],4,2,wf4(:,5),wf16(:,35))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(15),m3h2x128(:,31),heltab2x256(:,:,63))
  call Hloop_A_Q(ntryL,G0H128(15),128,0,G1H128(15),n2h128(17))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(442)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(64),h0tab(:,64),[128,5,90,32],[0,0,0,0],4,2,wf4(:,5),wf16(:,41))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(15),m3h2x128(:,32),heltab2x256(:,:,64))
  call Hloop_A_Q(ntryL,G0H128(15),128,0,G1H128(16),n2h128(18))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(446)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(65),h0tab(:,65),[128,32,5,90],[0,0,0,0],4,2,wf4(:,5),wf16(:,42))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(15),m3h2x128(:,33),heltab2x256(:,:,65))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(446)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(66),h0tab(:,66),[128,5,90,32],[0,0,0,0],4,2,wf4(:,5),wf16(:,42))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(16),m3h2x128(:,34),heltab2x256(:,:,66))
  call Hloop_A_Q(ntryL,G0H128(16),128,0,G1H128(17),n2h128(19))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(466)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(67),h0tab(:,67),[170,5,16,64],[0,0,0,0],4,2,wf16(:,37),wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H256(1),wf16(:,37),G0H16(1),m3h16x16(:,25),heltab2x256(:,:,67))
  call Hloop_A_Q(ntryL,G0H16(1),170,0,G1H16(27),n2h16(27))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(468)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(68),h0tab(:,68),[170,5,16,64],[0,0,0,0],4,2,wf16(:,43),wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H256(1),wf16(:,43),G0H16(1),ngZd,m3h16x16(:,26),heltab2x256(:,:,68))
  call Hloop_A_Q(ntryL,G0H16(1),170,0,G1H16(28),n2h16(28))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(466)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(69),h0tab(:,69),[170,5,64,16],[0,0,0,0],4,2,wf16(:,37),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H256(1),wf16(:,37),G0H16(1),m3h16x16(:,27),heltab2x256(:,:,69))
  call Hloop_Q_A(ntryL,G0H16(1),170,0,G1H16(29),n2h16(29))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(468)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(70),h0tab(:,70),[170,5,64,16],[0,0,0,0],4,2,wf16(:,43),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H256(1),wf16(:,43),G0H16(1),ngZu,m3h16x16(:,28),heltab2x256(:,:,70))
  call Hloop_Q_A(ntryL,G0H16(1),170,0,G1H16(30),n2h16(30))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(471)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(71),h0tab(:,71),[170,5,16,64],[0,0,0,0],4,2,wf16(:,44),wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H256(1),wf16(:,44),G0H16(1),ngZd,m3h16x16(:,29),heltab2x256(:,:,71))
  call Hloop_A_Q(ntryL,G0H16(1),170,0,G1H16(31),n2h16(31))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(471)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(72),h0tab(:,72),[170,5,64,16],[0,0,0,0],4,2,wf16(:,44),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H256(1),wf16(:,44),G0H16(1),ngZu,m3h16x16(:,30),heltab2x256(:,:,72))
  call Hloop_Q_A(ntryL,G0H16(1),170,0,G1H16(32),n2h16(32))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(514)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(73),h0tab(:,73),[128,32,10,85],[0,0,0,0],4,2,wf4(:,6),wf16(:,45))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(16),m3h2x128(:,35),heltab2x256(:,:,73))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(516)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(74),h0tab(:,74),[128,32,10,85],[0,0,0,0],4,2,wf4(:,6),wf16(:,51))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(17),m3h2x128(:,36),heltab2x256(:,:,74))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(514)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(75),h0tab(:,75),[128,10,85,32],[0,0,0,0],4,2,wf4(:,6),wf16(:,45))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(18),m3h2x128(:,37),heltab2x256(:,:,75))
  call Hloop_A_Q(ntryL,G0H128(18),128,0,G1H128(18),n2h128(20))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(516)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(76),h0tab(:,76),[128,10,85,32],[0,0,0,0],4,2,wf4(:,6),wf16(:,51))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(18),m3h2x128(:,38),heltab2x256(:,:,76))
  call Hloop_A_Q(ntryL,G0H128(18),128,0,G1H128(19),n2h128(21))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(520)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(77),h0tab(:,77),[128,10,85,32],[0,0,0,0],4,2,wf4(:,6),wf16(:,52))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(18),m3h2x128(:,39),heltab2x256(:,:,77))
  call Hloop_A_Q(ntryL,G0H128(18),128,0,G1H128(20),n2h128(22))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(520)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(78),h0tab(:,78),[128,32,10,85],[0,0,0,0],4,2,wf4(:,6),wf16(:,52))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(18),m3h2x128(:,40),heltab2x256(:,:,78))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(540)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(79),h0tab(:,79),[165,10,16,64],[0,0,0,0],4,2,wf16(:,47),wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H256(1),wf16(:,47),G0H16(1),m3h16x16(:,31),heltab2x256(:,:,79))
  call Hloop_A_Q(ntryL,G0H16(1),165,0,G1H16(33),n2h16(33))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(542)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(80),h0tab(:,80),[165,10,16,64],[0,0,0,0],4,2,wf16(:,54),wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H256(1),wf16(:,54),G0H16(1),ngZd,m3h16x16(:,32),heltab2x256(:,:,80))
  call Hloop_A_Q(ntryL,G0H16(1),165,0,G1H16(34),n2h16(34))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(540)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(81),h0tab(:,81),[165,10,64,16],[0,0,0,0],4,2,wf16(:,47),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H256(1),wf16(:,47),G0H16(1),m3h16x16(:,33),heltab2x256(:,:,81))
  call Hloop_Q_A(ntryL,G0H16(1),165,0,G1H16(35),n2h16(35))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(542)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(82),h0tab(:,82),[165,10,64,16],[0,0,0,0],4,2,wf16(:,54),wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H256(1),wf16(:,54),G0H16(1),ngZu,m3h16x16(:,34),heltab2x256(:,:,82))
  call Hloop_Q_A(ntryL,G0H16(1),165,0,G1H16(36),n2h16(36))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(545)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(83),h0tab(:,83),[165,10,64,16],[0,0,0,0],4,2,wf16(:,53),wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H256(1),wf16(:,53),G0H16(1),ngZu,m3h16x16(:,35),heltab2x256(:,:,83))
  call Hloop_Q_A(ntryL,G0H16(1),165,0,G1H16(37),n2h16(37))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(545)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(84),h0tab(:,84),[165,10,16,64],[0,0,0,0],4,2,wf16(:,53),wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H256(1),wf16(:,53),G0H16(1),ngZd,m3h16x16(:,36),heltab2x256(:,:,84))
  call Hloop_A_Q(ntryL,G0H16(1),165,0,G1H16(38),n2h16(38))
  call ol_merge(ntryL,G1H16(38),[G1H16(34),G1H16(33),G1H16(16),G1H16(15),G1H16(12),G1H16(11),G1H16(4),G1H16(3)])
  call ol_merge(ntryL,G1H16(37),[G1H16(36),G1H16(35),G1H16(18),G1H16(17),G1H16(14),G1H16(13),G1H16(6),G1H16(5)])
  call ol_merge(ntryL,G1H16(31),[G1H16(28),G1H16(27),G1H16(24),G1H16(23),G1H16(20),G1H16(19),G1H16(8),G1H16(7)])
  call ol_merge(ntryL,G1H16(32),[G1H16(30),G1H16(29),G1H16(26),G1H16(25),G1H16(22),G1H16(21),G1H16(10),G1H16(9)])
  call Hloop_AW_Q(ntryL,G1H32(3),wf4(:,7),G1H8(17),m3h4x8(:,9),heltab2x32(:,:,11))
  call Hloop_A_Q(ntryL,G1H8(17),218,0,G2H8(3),n2h8(17))
  call Hloop_AW_Q(ntryL,G1H32(9),wf4(:,7),G1H8(18),m3h4x8(:,10),heltab2x32(:,:,12))
  call Hloop_A_Q(ntryL,G1H8(18),213,0,G2H8(5),n2h8(18))
  call Hloop_AW_Q(ntryL,G1H128(1),wf4(:,6),G1H32(1),m3h4x32(:,3),heltab2x128(:,:,3))
  call Hloop_A_Q(ntryL,G1H32(1),138,0,G2H32(1),n2h32(5))
  call Hloop_VQ_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,3),heltab2x32(:,:,13))
  call Hloop_Q_A(ntryL,G0H16(1),165,0,G1H16(34),n2h16(39))
  call Hloop_AW_Q(ntryL,G1H128(2),wf4(:,5),G1H32(2),m3h4x32(:,4),heltab2x128(:,:,4))
  call Hloop_A_Q(ntryL,G1H32(2),133,0,G2H32(2),n2h32(6))
  call Hloop_VQ_A(ntryL,G0H32(2),ex6(:),G0H16(1),m3h2x16(:,4),heltab2x32(:,:,14))
  call Hloop_Q_A(ntryL,G0H16(1),170,0,G1H16(33),n2h16(40))
  call Hloop_VQ_A(ntryL,G0H128(1),ex6(:),G0H64(1),m3h2x64(:,1),heltab2x128(:,:,5))
  call Hloop_Q_A(ntryL,G0H64(1),160,0,G1H64(5),n2h64(7))
  call Hloop_VQ_A(ntryL,G0H128(2),ex6(:),G0H64(1),m3h2x64(:,2),heltab2x128(:,:,6))
  call Hloop_Q_A(ntryL,G0H64(1),160,0,G1H64(6),n2h64(8))
  call Hloop_AW_Q(ntryL,G1H128(3),wf4(:,6),G1H32(4),m3h4x32(:,5),heltab2x128(:,:,7))
  call Hloop_A_Q(ntryL,G1H32(4),138,0,G2H32(3),n2h32(7))
  call Hloop_AW_Q(ntryL,G1H128(4),wf4(:,6),G1H32(5),m3h4x32(:,6),heltab2x128(:,:,8))
  call Hloop_A_Q(ntryL,G1H32(5),138,0,G2H32(4),n2h32(8))
  call Hloop_VQ_A(ntryL,G0H128(3),ex6(:),G0H64(1),m3h2x64(:,3),heltab2x128(:,:,9))
  call Hloop_Q_A(ntryL,G0H64(1),160,0,G1H64(7),n2h64(9))
  call Hloop_VQ_A(ntryL,G0H128(4),ex6(:),G0H64(1),m3h2x64(:,4),heltab2x128(:,:,10))
  call Hloop_Q_A(ntryL,G0H64(1),160,0,G1H64(8),n2h64(10))
  call Hloop_AW_Q(ntryL,G1H128(5),wf4(:,5),G1H32(6),m3h4x32(:,7),heltab2x128(:,:,11))
  call Hloop_A_Q(ntryL,G1H32(6),133,0,G2H32(5),n2h32(9))
  call Hloop_AW_Q(ntryL,G1H128(6),wf4(:,5),G1H32(7),m3h4x32(:,8),heltab2x128(:,:,12))
  call Hloop_A_Q(ntryL,G1H32(7),133,0,G2H32(6),n2h32(10))
  call Hloop_QW_A(ntryL,G1H64(1),wf4(:,6),G1H16(16),m3h4x16(:,3),heltab2x64(:,:,3))
  call Hloop_Q_A(ntryL,G1H16(16),170,0,G2H16(1),n2h16(41))
  call Hloop_AW_Q(ntryL,G1H64(2),wf4(:,6),G1H16(15),m3h4x16(:,4),heltab2x64(:,:,4))
  call Hloop_A_Q(ntryL,G1H16(15),170,0,G2H16(2),n2h16(42))
  call Hloop_QW_A(ntryL,G1H64(3),wf4(:,5),G1H16(12),m3h4x16(:,5),heltab2x64(:,:,5))
  call Hloop_Q_A(ntryL,G1H16(12),165,0,G2H16(3),n2h16(43))
  call Hloop_AW_Q(ntryL,G1H64(4),wf4(:,5),G1H16(11),m3h4x16(:,6),heltab2x64(:,:,6))
  call Hloop_A_Q(ntryL,G1H16(11),165,0,G2H16(4),n2h16(44))
  call Hloop_AW_Q(ntryL,G1H16(38),wf4(:,6),G1H4(12),m3h4x4(:,1),heltab2x16(:,:,3))
  call Hloop_A_Q(ntryL,G1H4(12),175,0,G2H4(1),n2h4(7))
  call Hloop_QW_A(ntryL,G1H16(37),wf4(:,6),G1H4(23),m3h4x4(:,2),heltab2x16(:,:,4))
  call Hloop_Q_A(ntryL,G1H4(23),175,0,G2H4(3),n2h4(8))
  call Hloop_AW_Q(ntryL,G1H16(31),wf4(:,5),G1H4(7),m3h4x4(:,3),heltab2x16(:,:,5))
  call Hloop_A_Q(ntryL,G1H4(7),175,0,G2H4(4),n2h4(9))
  call Hloop_QW_A(ntryL,G1H16(32),wf4(:,5),G1H4(8),m3h4x4(:,4),heltab2x16(:,:,6))
  call Hloop_Q_A(ntryL,G1H4(8),175,0,G2H4(6),n2h4(10))
  call Hloop_VQ_A(ntryL,G0H128(5),ex6(:),G0H64(1),m3h2x64(:,5),heltab2x128(:,:,13))
  call Hloop_Q_A(ntryL,G0H64(1),160,0,G1H64(1),n2h64(11))
  call Hloop_VQ_A(ntryL,G0H128(6),ex6(:),G0H64(1),m3h2x64(:,6),heltab2x128(:,:,14))
  call Hloop_Q_A(ntryL,G0H64(1),160,0,G1H64(2),n2h64(12))
  call Hloop_AW_Q(ntryL,G1H128(7),wf4(:,6),G1H32(8),m3h4x32(:,9),heltab2x128(:,:,15))
  call Hloop_A_Q(ntryL,G1H32(8),138,0,G2H32(7),n2h32(11))
  call Hloop_AW_Q(ntryL,G1H128(8),wf4(:,6),G1H32(10),m3h4x32(:,10),heltab2x128(:,:,16))
  call Hloop_A_Q(ntryL,G1H32(10),138,0,G2H32(8),n2h32(12))
  call Hloop_VQ_A(ntryL,G0H128(7),ex6(:),G0H64(1),m3h2x64(:,7),heltab2x128(:,:,17))
  call Hloop_Q_A(ntryL,G0H64(1),160,0,G1H64(3),n2h64(13))
  call Hloop_VQ_A(ntryL,G0H128(8),ex6(:),G0H64(1),m3h2x64(:,8),heltab2x128(:,:,18))
  call Hloop_Q_A(ntryL,G0H64(1),160,0,G1H64(4),n2h64(14))
  call Hloop_AW_Q(ntryL,G1H128(9),wf4(:,6),G1H32(11),m3h4x32(:,11),heltab2x128(:,:,19))
  call Hloop_A_Q(ntryL,G1H32(11),138,0,G2H32(9),n2h32(13))
  call Hloop_AW_Q(ntryL,G1H128(10),wf4(:,6),G1H32(12),m3h4x32(:,12),heltab2x128(:,:,20))
  call Hloop_A_Q(ntryL,G1H32(12),138,0,G2H32(10),n2h32(14))
  call Hloop_VQ_A(ntryL,G0H128(9),ex6(:),G0H64(1),m3h2x64(:,9),heltab2x128(:,:,21))
  call Hloop_Q_A(ntryL,G0H64(1),160,0,G1H64(9),n2h64(15))
  call Hloop_VQ_A(ntryL,G0H128(10),ex6(:),G0H64(1),m3h2x64(:,10),heltab2x128(:,:,22))
  call Hloop_Q_A(ntryL,G0H64(1),160,0,G1H64(10),n2h64(16))
  call Hloop_AW_Q(ntryL,G1H128(11),wf4(:,5),G1H32(3),m3h4x32(:,13),heltab2x128(:,:,23))
  call Hloop_A_Q(ntryL,G1H32(3),133,0,G2H32(11),n2h32(15))
  call Hloop_AW_Q(ntryL,G1H128(12),wf4(:,5),G1H32(9),m3h4x32(:,14),heltab2x128(:,:,24))
  call Hloop_A_Q(ntryL,G1H32(9),133,0,G2H32(12),n2h32(16))
  call Hloop_VQ_A(ntryL,G0H128(11),ex6(:),G0H64(1),m3h2x64(:,11),heltab2x128(:,:,25))
  call Hloop_Q_A(ntryL,G0H64(1),160,0,G1H64(11),n2h64(17))
  call Hloop_VQ_A(ntryL,G0H128(12),ex6(:),G0H64(1),m3h2x64(:,12),heltab2x128(:,:,26))
  call Hloop_Q_A(ntryL,G0H64(1),160,0,G1H64(12),n2h64(18))
  call Hloop_AW_Q(ntryL,G1H128(13),wf4(:,5),G1H32(1),m3h4x32(:,15),heltab2x128(:,:,27))
  call Hloop_A_Q(ntryL,G1H32(1),133,0,G2H32(13),n2h32(17))
  call Hloop_AW_Q(ntryL,G1H128(14),wf4(:,5),G1H32(2),m3h4x32(:,16),heltab2x128(:,:,28))
  call Hloop_A_Q(ntryL,G1H32(2),133,0,G2H32(14),n2h32(18))
  call Hloop_VQ_A(ntryL,G0H128(13),ex6(:),G0H64(1),m3h2x64(:,13),heltab2x128(:,:,29))
  call Hloop_Q_A(ntryL,G0H64(1),160,0,G1H64(13),n2h64(19))
  call Hloop_VQ_A(ntryL,G0H128(14),ex6(:),G0H64(1),m3h2x64(:,14),heltab2x128(:,:,30))
  call Hloop_Q_A(ntryL,G0H64(1),160,0,G1H64(14),n2h64(20))
  call Hloop_AW_Q(ntryL,G1H128(15),wf4(:,5),G1H32(4),m3h4x32(:,17),heltab2x128(:,:,31))
  call Hloop_A_Q(ntryL,G1H32(4),133,0,G2H32(15),n2h32(19))
  call Hloop_AW_Q(ntryL,G1H128(16),wf4(:,5),G1H32(5),m3h4x32(:,18),heltab2x128(:,:,32))
  call Hloop_A_Q(ntryL,G1H32(5),133,0,G2H32(16),n2h32(20))
  call Hloop_VQ_A(ntryL,G0H128(15),ex6(:),G0H64(1),m3h2x64(:,15),heltab2x128(:,:,33))
  call Hloop_Q_A(ntryL,G0H64(1),160,0,G1H64(15),n2h64(21))
  call Hloop_AW_Q(ntryL,G1H128(17),wf4(:,5),G1H32(6),m3h4x32(:,19),heltab2x128(:,:,34))
  call Hloop_A_Q(ntryL,G1H32(6),133,0,G2H32(17),n2h32(21))
  call Hloop_VQ_A(ntryL,G0H128(16),ex6(:),G0H64(1),m3h2x64(:,16),heltab2x128(:,:,35))
  call Hloop_Q_A(ntryL,G0H64(1),160,0,G1H64(16),n2h64(22))
  call Hloop_VQ_A(ntryL,G0H128(17),ex6(:),G0H64(1),m3h2x64(:,17),heltab2x128(:,:,36))
  call Hloop_Q_A(ntryL,G0H64(1),160,0,G1H64(17),n2h64(23))
  call Hloop_AW_Q(ntryL,G1H128(18),wf4(:,6),G1H32(7),m3h4x32(:,20),heltab2x128(:,:,37))
  call Hloop_A_Q(ntryL,G1H32(7),138,0,G2H32(18),n2h32(22))
  call Hloop_AW_Q(ntryL,G1H128(19),wf4(:,6),G1H32(8),m3h4x32(:,21),heltab2x128(:,:,38))
  call Hloop_A_Q(ntryL,G1H32(8),138,0,G2H32(19),n2h32(23))
  call Hloop_AW_Q(ntryL,G1H128(20),wf4(:,6),G1H32(10),m3h4x32(:,22),heltab2x128(:,:,39))
  call Hloop_A_Q(ntryL,G1H32(10),138,0,G2H32(20),n2h32(24))
  call Hloop_VQ_A(ntryL,G0H128(18),ex6(:),G0H64(1),m3h2x64(:,18),heltab2x128(:,:,40))
  call Hloop_Q_A(ntryL,G0H64(1),160,0,G1H64(18),n2h64(24))
  call ol_merge(ntryL,G2H8(4),[G1H8(16)])
  call ol_merge(ntryL,G2H8(8),[G1H8(32)])
  call ol_merge(ntryL,G2H8(3),[G1H8(15)])
  call ol_merge(ntryL,G2H8(5),[G1H8(31)])
call HGT_w2_OLR(G1H16(1),1,1,16)
call HGT_w2_invQ_OLR(G1H16(1),2,5,16)
  call Hloop_AW_Q(ntryL,G1H16(1),wf4(:,7),G1H4(13),m3h4x4(:,5),heltab2x16(:,:,7))
  call Hloop_A_Q(ntryL,G1H4(13),250,0,G2H4(7),n2h4(11))
call Hotf_4pt_reduction(G2H8(4),RedSet_4(8),mass4set(:,1),  & 
G1H8(33),G1H8(34),G1H8(1),G1H8(2),G1H8(5),8)
call HG1shiftOLR(G1H8(34),32,8)
call HGT_w2_OLR(G1H16(2),1,1,16)
call HGT_w2_invQ_OLR(G1H16(2),2,5,16)
  call Hloop_AW_Q(ntryL,G1H16(2),wf4(:,7),G1H4(14),m3h4x4(:,6),heltab2x16(:,:,8))
  call Hloop_A_Q(ntryL,G1H4(14),245,0,G2H4(8),n2h4(12))
call Hotf_4pt_reduction(G2H8(8),RedSet_4(11),mass4set(:,1),  & 
G1H8(6),G1H8(7),G1H8(8),G1H8(11),G1H8(12),8)
call HG1shiftOLR(G1H8(7),32,8)
  call Hloop_VA_Q(ntryL,G1H8(3),ex7(:),G1H4(18),m3h2x4(:,13),heltab2x8(:,:,25))
  call Hloop_A_Q(ntryL,G1H4(18),245,0,G2H4(9),n2h4(13))
  call Hloop_VA_Q(ntryL,G1H8(4),ex7(:),G1H4(19),m3h2x4(:,14),heltab2x8(:,:,26))
  call Hloop_A_Q(ntryL,G1H4(19),245,0,G2H4(10),n2h4(14))
  call Hloop_VQ_A(ntryL,G1H8(9),ex5(:),G1H4(24),m3h2x4(:,15),heltab2x8(:,:,27))
  call Hloop_Q_A(ntryL,G1H4(24),245,0,G2H4(11),n2h4(15))
  call Hloop_VQ_A(ntryL,G1H8(10),ex5(:),G1H4(25),m3h2x4(:,16),heltab2x8(:,:,28))
  call Hloop_Q_A(ntryL,G1H4(25),245,0,G2H4(12),n2h4(16))
call Hotf_4pt_reduction(G2H8(3),RedSet_4(7),mass4set(:,1),  & 
G1H8(13),G1H8(14),G1H8(19),G1H8(24),G1H8(20),8)
call HG1shiftOLR(G1H8(14),32,8)
  call Hloop_AW_Q(ntryL,G1H8(21),wf4(:,5),G1H2(1),m3h4x2(:,13),heltab2x8(:,:,29))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(3),n2h2(11))
  call Hloop_AW_Q(ntryL,G1H8(22),wf4(:,5),G1H2(1),m3h4x2(:,14),heltab2x8(:,:,30))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(5),n2h2(12))
  call Hloop_AW_Q(ntryL,G1H8(26),wf4(:,5),G1H2(1),m3h4x2(:,15),heltab2x8(:,:,31))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(8),n2h2(13))
  call Hloop_AW_Q(ntryL,G1H8(27),wf4(:,5),G1H2(1),m3h4x2(:,16),heltab2x8(:,:,32))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(10),n2h2(14))
call Hotf_4pt_reduction(G2H8(5),RedSet_4(10),mass4set(:,1),  & 
G1H8(23),G1H8(25),G1H8(28),G1H8(29),G1H8(30),8)
call HG1shiftOLR(G1H8(25),32,8)
  call Hloop_AW_Q(ntryL,G1H8(37),wf4(:,6),G1H2(1),m3h4x2(:,17),heltab2x8(:,:,33))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(13),n2h2(15))
  call Hloop_AW_Q(ntryL,G1H8(38),wf4(:,6),G1H2(1),m3h4x2(:,18),heltab2x8(:,:,34))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(14),n2h2(16))
  call Hloop_AW_Q(ntryL,G1H8(42),wf4(:,6),G1H2(1),m3h4x2(:,19),heltab2x8(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(15),n2h2(17))
  call Hloop_AW_Q(ntryL,G1H8(43),wf4(:,6),G1H2(1),m3h4x2(:,20),heltab2x8(:,:,36))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(16),n2h2(18))
call Hotf_4pt_reduction(G2H32(1),RedSet_4(2),mass4set(:,1),  & 
G1H32(11),G1H32(12),G1H32(3),G1H32(9),G1H32(1),32)
call HG1shiftOLR(G1H32(12),37,32)
  call Hloop_QW_A(ntryL,G1H16(34),wf4(:,6),G1H4(12),m3h4x4(:,7),heltab2x16(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(12),175,0,G2H4(13),n2h4(17))
call Hotf_4pt_reduction(G2H32(2),RedSet_4(4),mass4set(:,1),  & 
G1H32(2),G1H32(4),G1H32(5),G1H32(6),G1H32(7),32)
call HG1shiftOLR(G1H32(4),42,32)
  call Hloop_QW_A(ntryL,G1H16(33),wf4(:,5),G1H4(23),m3h4x4(:,8),heltab2x16(:,:,10))
  call Hloop_Q_A(ntryL,G1H4(23),175,0,G2H4(14),n2h4(18))
  call Hloop_QW_A(ntryL,G1H64(5),wf4(:,6),G1H16(4),m3h4x16(:,7),heltab2x64(:,:,7))
  call Hloop_Q_A(ntryL,G1H16(4),170,0,G2H16(5),n2h16(45))
  call Hloop_QW_A(ntryL,G1H64(6),wf4(:,6),G1H16(3),m3h4x16(:,8),heltab2x64(:,:,8))
  call Hloop_Q_A(ntryL,G1H16(3),170,0,G2H16(6),n2h16(46))
call Hotf_4pt_reduction(G2H32(3),RedSet_4(1),mass4set(:,1),  & 
G1H32(8),G1H32(10),G1H32(13),G1H32(14),G1H32(15),32)
call HG1shiftOLR(G1H32(10),32,32)
call Hotf_4pt_reduction(G2H32(4),RedSet_4(1),mass4set(:,1),  & 
G1H32(16),G1H32(17),G1H32(18),G1H32(19),G1H32(20),32)
call HG1shiftOLR(G1H32(17),32,32)
  call Hloop_QW_A(ntryL,G1H64(7),wf4(:,5),G1H16(36),m3h4x16(:,9),heltab2x64(:,:,9))
  call Hloop_Q_A(ntryL,G1H16(36),165,0,G2H16(7),n2h16(47))
  call Hloop_QW_A(ntryL,G1H64(8),wf4(:,5),G1H16(35),m3h4x16(:,10),heltab2x64(:,:,10))
  call Hloop_Q_A(ntryL,G1H16(35),165,0,G2H16(8),n2h16(48))
call Hotf_4pt_reduction(G2H32(5),RedSet_4(3),mass4set(:,1),  & 
G1H32(21),G1H32(22),G1H32(23),G1H32(24),G1H32(25),32)
call HG1shiftOLR(G1H32(22),32,32)
call Hotf_4pt_reduction(G2H32(6),RedSet_4(3),mass4set(:,1),  & 
G1H32(26),G1H32(27),G1H32(28),G1H32(29),G1H32(30),32)
call HG1shiftOLR(G1H32(27),32,32)
  call Hloop_QA_V(ntryL,G2H16(1),ex7(:),G2H8(6),m3h2x8(:,3),heltab2x16(:,:,11))
  call Hloop_AQ_V(ntryL,G2H16(2),ex5(:),G2H8(7),m3h2x8(:,4),heltab2x16(:,:,12))
  call Hloop_QA_V(ntryL,G2H16(3),ex7(:),G2H8(9),m3h2x8(:,5),heltab2x16(:,:,13))
  call Hloop_AQ_V(ntryL,G2H16(4),ex5(:),G2H8(10),m3h2x8(:,6),heltab2x16(:,:,14))
  call Hloop_AQ_V(ntryL,G2H4(1),ex5(:),G2H2(17),m3h2x2(:,1),heltab2x4(:,:,9))
  call Hloop_QA_V(ntryL,G2H4(3),ex7(:),G2H2(18),m3h2x2(:,2),heltab2x4(:,:,10))
  call Hloop_AQ_V(ntryL,G2H4(4),ex5(:),G2H2(19),m3h2x2(:,3),heltab2x4(:,:,11))
  call Hloop_QA_V(ntryL,G2H4(6),ex7(:),G2H2(20),m3h2x2(:,4),heltab2x4(:,:,12))
  call Hloop_QW_A(ntryL,G1H64(1),wf4(:,6),G1H16(18),m3h4x16(:,11),heltab2x64(:,:,11))
  call Hloop_Q_A(ntryL,G1H16(18),170,0,G2H16(1),n2h16(49))
  call Hloop_QW_A(ntryL,G1H64(2),wf4(:,6),G1H16(17),m3h4x16(:,12),heltab2x64(:,:,12))
  call Hloop_Q_A(ntryL,G1H16(17),170,0,G2H16(2),n2h16(50))
call Hotf_4pt_reduction(G2H32(7),RedSet_4(1),mass4set(:,1),  & 
G1H32(31),G1H32(32),G1H32(33),G1H32(34),G1H32(35),32)
call HG1shiftOLR(G1H32(32),32,32)
call Hotf_4pt_reduction(G2H32(8),RedSet_4(1),mass4set(:,1),  & 
G1H32(36),G1H32(37),G1H32(38),G1H32(39),G1H32(40),32)
call HG1shiftOLR(G1H32(37),32,32)
  call Hloop_QW_A(ntryL,G1H64(3),wf4(:,6),G1H16(14),m3h4x16(:,13),heltab2x64(:,:,13))
  call Hloop_Q_A(ntryL,G1H16(14),170,0,G2H16(3),n2h16(51))
  call Hloop_QW_A(ntryL,G1H64(4),wf4(:,6),G1H16(13),m3h4x16(:,14),heltab2x64(:,:,14))
  call Hloop_Q_A(ntryL,G1H16(13),170,0,G2H16(4),n2h16(52))
call Hotf_4pt_reduction(G2H32(9),RedSet_4(1),mass4set(:,1),  & 
G1H32(41),G1H32(42),G1H32(43),G1H32(44),G1H32(45),32)
call HG1shiftOLR(G1H32(42),32,32)
call Hotf_4pt_reduction(G2H32(10),RedSet_4(1),mass4set(:,1),  & 
G1H32(46),G1H32(47),G1H32(48),G1H32(49),G1H32(50),32)
call HG1shiftOLR(G1H32(47),32,32)
  call Hloop_QW_A(ntryL,G1H64(9),wf4(:,5),G1H16(6),m3h4x16(:,15),heltab2x64(:,:,15))
  call Hloop_Q_A(ntryL,G1H16(6),165,0,G2H16(9),n2h16(53))
  call Hloop_QW_A(ntryL,G1H64(10),wf4(:,5),G1H16(5),m3h4x16(:,16),heltab2x64(:,:,16))
  call Hloop_Q_A(ntryL,G1H16(5),165,0,G2H16(10),n2h16(54))
call Hotf_4pt_reduction(G2H32(11),RedSet_4(3),mass4set(:,1),  & 
G1H32(51),G1H32(52),G1H32(53),G1H32(54),G1H32(55),32)
call HG1shiftOLR(G1H32(52),32,32)
call Hotf_4pt_reduction(G2H32(12),RedSet_4(3),mass4set(:,1),  & 
G1H32(56),G1H32(57),G1H32(58),G1H32(59),G1H32(60),32)
call HG1shiftOLR(G1H32(57),32,32)
  call Hloop_QW_A(ntryL,G1H64(11),wf4(:,5),G1H16(28),m3h4x16(:,17),heltab2x64(:,:,17))
  call Hloop_Q_A(ntryL,G1H16(28),165,0,G2H16(11),n2h16(55))
  call Hloop_QW_A(ntryL,G1H64(12),wf4(:,5),G1H16(27),m3h4x16(:,18),heltab2x64(:,:,18))
  call Hloop_Q_A(ntryL,G1H16(27),165,0,G2H16(12),n2h16(56))
call Hotf_4pt_reduction(G2H32(13),RedSet_4(3),mass4set(:,1),  & 
G1H32(61),G1H32(62),G1H32(63),G1H32(64),G1H32(65),32)
call HG1shiftOLR(G1H32(62),32,32)
call Hotf_4pt_reduction(G2H32(14),RedSet_4(3),mass4set(:,1),  & 
G1H32(66),G1H32(67),G1H32(68),G1H32(69),G1H32(70),32)
call HG1shiftOLR(G1H32(67),32,32)
  call Hloop_QW_A(ntryL,G1H64(13),wf4(:,5),G1H16(24),m3h4x16(:,19),heltab2x64(:,:,19))
  call Hloop_Q_A(ntryL,G1H16(24),165,0,G2H16(13),n2h16(57))
  call Hloop_QW_A(ntryL,G1H64(14),wf4(:,5),G1H16(23),m3h4x16(:,20),heltab2x64(:,:,20))
  call Hloop_Q_A(ntryL,G1H16(23),165,0,G2H16(14),n2h16(58))
call Hotf_4pt_reduction(G2H32(15),RedSet_4(3),mass4set(:,1),  & 
G1H32(71),G1H32(72),G1H32(73),G1H32(74),G1H32(75),32)
call HG1shiftOLR(G1H32(72),32,32)
call Hotf_4pt_reduction(G2H32(16),RedSet_4(3),mass4set(:,1),  & 
G1H32(76),G1H32(77),G1H32(78),G1H32(79),G1H32(80),32)
call HG1shiftOLR(G1H32(77),32,32)
  call Hloop_QW_A(ntryL,G1H64(15),wf4(:,5),G1H16(20),m3h4x16(:,21),heltab2x64(:,:,21))
  call Hloop_Q_A(ntryL,G1H16(20),165,0,G2H16(15),n2h16(59))
call Hotf_4pt_reduction(G2H32(17),RedSet_4(3),mass4set(:,1),  & 
G1H32(81),G1H32(82),G1H32(83),G1H32(84),G1H32(85),32)
call HG1shiftOLR(G1H32(82),32,32)
  call Hloop_QW_A(ntryL,G1H64(16),wf4(:,6),G1H16(19),m3h4x16(:,22),heltab2x64(:,:,22))
  call Hloop_Q_A(ntryL,G1H16(19),170,0,G2H16(16),n2h16(60))
  call Hloop_QW_A(ntryL,G1H64(17),wf4(:,6),G1H16(8),m3h4x16(:,23),heltab2x64(:,:,23))
  call Hloop_Q_A(ntryL,G1H16(8),170,0,G2H16(17),n2h16(61))
call Hotf_4pt_reduction(G2H32(18),RedSet_4(1),mass4set(:,1),  & 
G1H32(86),G1H32(87),G1H32(88),G1H32(89),G1H32(90),32)
call HG1shiftOLR(G1H32(87),32,32)
call Hotf_4pt_reduction(G2H32(19),RedSet_4(1),mass4set(:,1),  & 
G1H32(91),G1H32(92),G1H32(93),G1H32(94),G1H32(95),32)
call HG1shiftOLR(G1H32(92),32,32)
call Hotf_4pt_reduction(G2H32(20),RedSet_4(1),mass4set(:,1),  & 
G1H32(96),G1H32(97),G1H32(98),G1H32(99),G1H32(100),32)
call HG1shiftOLR(G1H32(97),32,32)
  call Hloop_QW_A(ntryL,G1H64(18),wf4(:,6),G1H16(7),m3h4x16(:,24),heltab2x64(:,:,24))
  call Hloop_Q_A(ntryL,G1H16(7),170,0,G2H16(18),n2h16(62))
  call Hloop_AW_Q(ntryL,G1H8(33),wf4(:,5),G1H2(1),m3h4x2(:,21),heltab2x8(:,:,37))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(21),n2h2(19))
call HGT_raise_alpha_OLR(G1H8(34),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(34),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(34),ex6(:),G1H4(7),m3h2x4(:,17),heltab2x8(:,:,38))
  call Hloop_AW_Q(ntryL,G1H8(2),wf4(:,5),G1H2(1),m3h4x2(:,22),heltab2x8(:,:,39))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(22),n2h2(20))
  call Hloop_AW_Q(ntryL,G1H8(5),wf4(:,5),G1H2(1),m3h4x2(:,23),heltab2x8(:,:,40))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(23),n2h2(21))
  call Hloop_AW_Q(ntryL,G1H8(6),wf4(:,6),G1H2(1),m3h4x2(:,24),heltab2x8(:,:,41))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(24),n2h2(22))
call HGT_raise_alpha_OLR(G1H8(7),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(7),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(7),ex6(:),G1H4(8),m3h2x4(:,18),heltab2x8(:,:,42))
  call Hloop_AW_Q(ntryL,G1H8(11),wf4(:,6),G1H2(1),m3h4x2(:,25),heltab2x8(:,:,43))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(25),n2h2(23))
  call Hloop_AW_Q(ntryL,G1H8(12),wf4(:,6),G1H2(1),m3h4x2(:,26),heltab2x8(:,:,44))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(26),n2h2(24))
  call Hloop_AW_Q(ntryL,G1H8(13),wf4(:,5),G1H2(1),m3h4x2(:,27),heltab2x8(:,:,45))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(27),n2h2(25))
call HGT_raise_alpha_OLR(G1H8(14),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(14),ex6(:),G1H4(13),m3h2x4(:,19),heltab2x8(:,:,46))
  call Hloop_AW_Q(ntryL,G1H8(24),wf4(:,5),G1H2(1),m3h4x2(:,28),heltab2x8(:,:,47))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(28),n2h2(26))
  call Hloop_AW_Q(ntryL,G1H8(20),wf4(:,5),G1H2(1),m3h4x2(:,29),heltab2x8(:,:,48))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(29),n2h2(27))
  call Hloop_AW_Q(ntryL,G1H8(23),wf4(:,6),G1H2(1),m3h4x2(:,30),heltab2x8(:,:,49))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(30),n2h2(28))
call HGT_raise_alpha_OLR(G1H8(25),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(25),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(25),ex6(:),G1H4(14),m3h2x4(:,20),heltab2x8(:,:,50))
  call Hloop_AW_Q(ntryL,G1H8(29),wf4(:,6),G1H2(1),m3h4x2(:,31),heltab2x8(:,:,51))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(31),n2h2(29))
  call Hloop_AW_Q(ntryL,G1H8(30),wf4(:,6),G1H2(1),m3h4x2(:,32),heltab2x8(:,:,52))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(32),n2h2(30))
  call Hloop_AW_Q(ntryL,G1H32(11),wf4(:,7),G1H8(35),m3h4x8(:,11),heltab2x32(:,:,15))
  call Hloop_A_Q(ntryL,G1H8(35),218,0,G2H8(1),n2h8(23))
call HGT_raise_alpha_OLR(G1H32(12),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(12),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(12),wf8(:,3),G1H4(18),m3h8x4(:,1),heltab2x32(:,:,16))
  call Hloop_AW_Q(ntryL,G1H32(9),wf4(:,7),G1H8(40),m3h4x8(:,12),heltab2x32(:,:,17))
  call Hloop_A_Q(ntryL,G1H8(40),218,0,G2H8(2),n2h8(24))
  call Hloop_AW_Q(ntryL,G1H32(1),wf4(:,7),G1H8(36),m3h4x8(:,13),heltab2x32(:,:,18))
  call Hloop_A_Q(ntryL,G1H8(36),218,0,G2H8(4),n2h8(25))
  call Hloop_AW_Q(ntryL,G1H32(2),wf4(:,7),G1H8(39),m3h4x8(:,14),heltab2x32(:,:,19))
  call Hloop_A_Q(ntryL,G1H8(39),213,0,G2H8(8),n2h8(26))
call HGT_raise_alpha_OLR(G1H32(4),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(4),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(4),wf8(:,7),G1H4(19),m3h8x4(:,2),heltab2x32(:,:,20))
  call Hloop_AW_Q(ntryL,G1H32(6),wf4(:,7),G1H8(41),m3h4x8(:,15),heltab2x32(:,:,21))
  call Hloop_A_Q(ntryL,G1H8(41),213,0,G2H8(3),n2h8(27))
  call Hloop_AW_Q(ntryL,G1H32(7),wf4(:,7),G1H8(44),m3h4x8(:,16),heltab2x32(:,:,22))
  call Hloop_A_Q(ntryL,G1H8(44),213,0,G2H8(5),n2h8(28))
  call Hloop_AV_Q(ntryL,G1H32(8),wf16(:,3),G1H2(1),m3h16x2(:,1),heltab2x32(:,:,23))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(33),n2h2(31))
call HGT_raise_alpha_OLR(G1H32(10),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(10),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(10),ex6(:),G1H16(30),m3h2x16(:,5),heltab2x32(:,:,24))
  call Hloop_AV_Q(ntryL,G1H32(14),wf16(:,3),G1H2(1),m3h16x2(:,2),heltab2x32(:,:,25))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(34),n2h2(32))
  call Hloop_AV_Q(ntryL,G1H32(15),wf16(:,3),G1H2(1),m3h16x2(:,3),heltab2x32(:,:,26))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(35),n2h2(33))
  call Hloop_AZ_Q(ntryL,G1H32(16),wf16(:,5),G1H2(1),ngZu,m3h16x2(:,4),heltab2x32(:,:,27))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(36),n2h2(34))
call HGT_raise_alpha_OLR(G1H32(17),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(17),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(17),ex6(:),G1H16(29),m3h2x16(:,6),heltab2x32(:,:,28))
  call Hloop_AZ_Q(ntryL,G1H32(19),wf16(:,5),G1H2(1),ngZu,m3h16x2(:,5),heltab2x32(:,:,29))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(37),n2h2(35))
  call Hloop_AZ_Q(ntryL,G1H32(20),wf16(:,5),G1H2(1),ngZu,m3h16x2(:,6),heltab2x32(:,:,30))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(38),n2h2(36))
  call Hloop_AV_Q(ntryL,G1H32(21),wf16(:,9),G1H2(1),m3h16x2(:,7),heltab2x32(:,:,31))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(39),n2h2(37))
call HGT_raise_alpha_OLR(G1H32(22),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(22),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(22),ex6(:),G1H16(26),m3h2x16(:,7),heltab2x32(:,:,32))
  call Hloop_AV_Q(ntryL,G1H32(24),wf16(:,9),G1H2(1),m3h16x2(:,8),heltab2x32(:,:,33))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(40),n2h2(38))
  call Hloop_AV_Q(ntryL,G1H32(25),wf16(:,9),G1H2(1),m3h16x2(:,9),heltab2x32(:,:,34))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(41),n2h2(39))
  call Hloop_AZ_Q(ntryL,G1H32(26),wf16(:,12),G1H2(1),ngZu,m3h16x2(:,10),heltab2x32(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(42),n2h2(40))
call HGT_raise_alpha_OLR(G1H32(27),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(27),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(27),ex6(:),G1H16(25),m3h2x16(:,8),heltab2x32(:,:,36))
  call Hloop_AZ_Q(ntryL,G1H32(29),wf16(:,12),G1H2(1),ngZu,m3h16x2(:,11),heltab2x32(:,:,37))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(43),n2h2(41))
  call Hloop_AZ_Q(ntryL,G1H32(30),wf16(:,12),G1H2(1),ngZu,m3h16x2(:,12),heltab2x32(:,:,38))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(44),n2h2(42))
  call Hloop_AV_Q(ntryL,G1H32(31),wf16(:,20),G1H2(1),m3h16x2(:,13),heltab2x32(:,:,39))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(45),n2h2(43))
call HGT_raise_alpha_OLR(G1H32(32),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(32),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(32),ex6(:),G1H16(22),m3h2x16(:,9),heltab2x32(:,:,40))
  call Hloop_AV_Q(ntryL,G1H32(34),wf16(:,20),G1H2(1),m3h16x2(:,14),heltab2x32(:,:,41))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(46),n2h2(44))
  call Hloop_AV_Q(ntryL,G1H32(35),wf16(:,20),G1H2(1),m3h16x2(:,15),heltab2x32(:,:,42))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(47),n2h2(45))
  call Hloop_AZ_Q(ntryL,G1H32(36),wf16(:,29),G1H2(1),ngZu,m3h16x2(:,16),heltab2x32(:,:,43))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(48),n2h2(46))
call HGT_raise_alpha_OLR(G1H32(37),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(37),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(37),ex6(:),G1H16(21),m3h2x16(:,10),heltab2x32(:,:,44))
  call Hloop_AZ_Q(ntryL,G1H32(39),wf16(:,29),G1H2(1),ngZu,m3h16x2(:,17),heltab2x32(:,:,45))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(49),n2h2(47))
  call Hloop_AZ_Q(ntryL,G1H32(40),wf16(:,29),G1H2(1),ngZu,m3h16x2(:,18),heltab2x32(:,:,46))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(50),n2h2(48))
  call Hloop_AV_Q(ntryL,G1H32(41),wf16(:,23),G1H2(1),m3h16x2(:,19),heltab2x32(:,:,47))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(51),n2h2(49))
call HGT_raise_alpha_OLR(G1H32(42),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(42),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(42),ex6(:),G1H16(10),m3h2x16(:,11),heltab2x32(:,:,48))
  call Hloop_AV_Q(ntryL,G1H32(44),wf16(:,23),G1H2(1),m3h16x2(:,20),heltab2x32(:,:,49))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(52),n2h2(50))
  call Hloop_AV_Q(ntryL,G1H32(45),wf16(:,23),G1H2(1),m3h16x2(:,21),heltab2x32(:,:,50))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(53),n2h2(51))
  call Hloop_AZ_Q(ntryL,G1H32(46),wf16(:,33),G1H2(1),ngZu,m3h16x2(:,22),heltab2x32(:,:,51))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(54),n2h2(52))
call HGT_raise_alpha_OLR(G1H32(47),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(47),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(47),ex6(:),G1H16(9),m3h2x16(:,12),heltab2x32(:,:,52))
  call Hloop_AZ_Q(ntryL,G1H32(49),wf16(:,33),G1H2(1),ngZu,m3h16x2(:,23),heltab2x32(:,:,53))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(55),n2h2(53))
  call Hloop_AZ_Q(ntryL,G1H32(50),wf16(:,33),G1H2(1),ngZu,m3h16x2(:,24),heltab2x32(:,:,54))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(56),n2h2(54))
  call Hloop_AV_Q(ntryL,G1H32(51),wf16(:,25),G1H2(1),m3h16x2(:,25),heltab2x32(:,:,55))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(57),n2h2(55))
call HGT_raise_alpha_OLR(G1H32(52),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(52),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(52),ex6(:),G1H16(16),m3h2x16(:,13),heltab2x32(:,:,56))
  call Hloop_AV_Q(ntryL,G1H32(54),wf16(:,25),G1H2(1),m3h16x2(:,26),heltab2x32(:,:,57))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(58),n2h2(56))
  call Hloop_AV_Q(ntryL,G1H32(55),wf16(:,25),G1H2(1),m3h16x2(:,27),heltab2x32(:,:,58))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(59),n2h2(57))
  call Hloop_AZ_Q(ntryL,G1H32(56),wf16(:,31),G1H2(1),ngZu,m3h16x2(:,28),heltab2x32(:,:,59))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(60),n2h2(58))
call HGT_raise_alpha_OLR(G1H32(57),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(57),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(57),ex6(:),G1H16(15),m3h2x16(:,14),heltab2x32(:,:,60))
  call Hloop_AZ_Q(ntryL,G1H32(59),wf16(:,31),G1H2(1),ngZu,m3h16x2(:,29),heltab2x32(:,:,61))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(61),n2h2(59))
  call Hloop_AZ_Q(ntryL,G1H32(60),wf16(:,31),G1H2(1),ngZu,m3h16x2(:,30),heltab2x32(:,:,62))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(62),n2h2(60))
  call Hloop_AV_Q(ntryL,G1H32(61),wf16(:,27),G1H2(1),m3h16x2(:,31),heltab2x32(:,:,63))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(63),n2h2(61))
call HGT_raise_alpha_OLR(G1H32(62),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(62),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(62),ex6(:),G1H16(12),m3h2x16(:,15),heltab2x32(:,:,64))
  call Hloop_AV_Q(ntryL,G1H32(64),wf16(:,27),G1H2(1),m3h16x2(:,32),heltab2x32(:,:,65))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(64),n2h2(62))
  call Hloop_AV_Q(ntryL,G1H32(65),wf16(:,27),G1H2(1),m3h16x2(:,33),heltab2x32(:,:,66))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(65),n2h2(63))
  call Hloop_AZ_Q(ntryL,G1H32(66),wf16(:,32),G1H2(1),ngZu,m3h16x2(:,34),heltab2x32(:,:,67))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(66),n2h2(64))
call HGT_raise_alpha_OLR(G1H32(67),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(67),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(67),ex6(:),G1H16(11),m3h2x16(:,16),heltab2x32(:,:,68))
  call Hloop_AZ_Q(ntryL,G1H32(69),wf16(:,32),G1H2(1),ngZu,m3h16x2(:,35),heltab2x32(:,:,69))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(67),n2h2(65))
  call Hloop_AZ_Q(ntryL,G1H32(70),wf16(:,32),G1H2(1),ngZu,m3h16x2(:,36),heltab2x32(:,:,70))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(68),n2h2(66))
  call Hloop_AV_Q(ntryL,G1H32(71),wf16(:,35),G1H2(1),m3h16x2(:,37),heltab2x32(:,:,71))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(69),n2h2(67))
call HGT_raise_alpha_OLR(G1H32(72),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(72),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(72),ex6(:),G1H16(38),m3h2x16(:,17),heltab2x32(:,:,72))
  call Hloop_AV_Q(ntryL,G1H32(74),wf16(:,35),G1H2(1),m3h16x2(:,38),heltab2x32(:,:,73))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(70),n2h2(68))
  call Hloop_AV_Q(ntryL,G1H32(75),wf16(:,35),G1H2(1),m3h16x2(:,39),heltab2x32(:,:,74))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(71),n2h2(69))
  call Hloop_AZ_Q(ntryL,G1H32(76),wf16(:,41),G1H2(1),ngZu,m3h16x2(:,40),heltab2x32(:,:,75))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(72),n2h2(70))
call HGT_raise_alpha_OLR(G1H32(77),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(77),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(77),ex6(:),G1H16(37),m3h2x16(:,18),heltab2x32(:,:,76))
  call Hloop_AZ_Q(ntryL,G1H32(79),wf16(:,41),G1H2(1),ngZu,m3h16x2(:,41),heltab2x32(:,:,77))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(73),n2h2(71))
  call Hloop_AZ_Q(ntryL,G1H32(80),wf16(:,41),G1H2(1),ngZu,m3h16x2(:,42),heltab2x32(:,:,78))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(74),n2h2(72))
  call Hloop_AZ_Q(ntryL,G1H32(81),wf16(:,42),G1H2(1),ngZu,m3h16x2(:,43),heltab2x32(:,:,79))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(75),n2h2(73))
call HGT_raise_alpha_OLR(G1H32(82),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(82),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(82),ex6(:),G1H16(31),m3h2x16(:,19),heltab2x32(:,:,80))
  call Hloop_AZ_Q(ntryL,G1H32(84),wf16(:,42),G1H2(1),ngZu,m3h16x2(:,44),heltab2x32(:,:,81))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(76),n2h2(74))
  call Hloop_AZ_Q(ntryL,G1H32(85),wf16(:,42),G1H2(1),ngZu,m3h16x2(:,45),heltab2x32(:,:,82))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(77),n2h2(75))
  call Hloop_AV_Q(ntryL,G1H32(86),wf16(:,45),G1H2(1),m3h16x2(:,46),heltab2x32(:,:,83))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(78),n2h2(76))
call HGT_raise_alpha_OLR(G1H32(87),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(87),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(87),ex6(:),G1H16(32),m3h2x16(:,20),heltab2x32(:,:,84))
  call Hloop_AV_Q(ntryL,G1H32(89),wf16(:,45),G1H2(1),m3h16x2(:,47),heltab2x32(:,:,85))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(79),n2h2(77))
  call Hloop_AV_Q(ntryL,G1H32(90),wf16(:,45),G1H2(1),m3h16x2(:,48),heltab2x32(:,:,86))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(80),n2h2(78))
  call Hloop_AZ_Q(ntryL,G1H32(91),wf16(:,51),G1H2(1),ngZu,m3h16x2(:,49),heltab2x32(:,:,87))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(81),n2h2(79))
call HGT_raise_alpha_OLR(G1H32(92),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(92),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(92),ex6(:),G1H16(1),m3h2x16(:,21),heltab2x32(:,:,88))
  call Hloop_AZ_Q(ntryL,G1H32(94),wf16(:,51),G1H2(1),ngZu,m3h16x2(:,50),heltab2x32(:,:,89))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(82),n2h2(80))
  call Hloop_AZ_Q(ntryL,G1H32(95),wf16(:,51),G1H2(1),ngZu,m3h16x2(:,51),heltab2x32(:,:,90))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(83),n2h2(81))
  call Hloop_AZ_Q(ntryL,G1H32(96),wf16(:,52),G1H2(1),ngZu,m3h16x2(:,52),heltab2x32(:,:,91))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(84),n2h2(82))
call HGT_raise_alpha_OLR(G1H32(97),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(97),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(97),ex6(:),G1H16(2),m3h2x16(:,22),heltab2x32(:,:,92))
  call Hloop_AZ_Q(ntryL,G1H32(99),wf16(:,52),G1H2(1),ngZu,m3h16x2(:,53),heltab2x32(:,:,93))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(85),n2h2(83))
  call Hloop_AZ_Q(ntryL,G1H32(100),wf16(:,52),G1H2(1),ngZu,m3h16x2(:,54),heltab2x32(:,:,94))
  call Hloop_A_Q(ntryL,G1H2(1),223,0,G2H2(86),n2h2(84))
call HGT_OLR(G2H2(1),1,1,2)
call HGT_invQ_OLR(G2H2(1),2,5,2)
call HGT_OLR(G2H2(1),6,15,2)
  call ol_merge(ntryL,G2H2(1),[G2H2(19)])
  call ol_merge(ntryL,G2H4(8),[G2H4(2),G1H4(11)])
call HGT_w2_OLR(G1H4(4),1,1,4)
call HGT_w2_invQ_OLR(G1H4(4),2,5,4)
  call ol_merge(ntryL,G2H4(8),[G1H4(4)])
call HGT_OLR(G2H2(2),1,1,2)
call HGT_invQ_OLR(G2H2(2),2,5,2)
call HGT_OLR(G2H2(2),6,15,2)
  call ol_merge(ntryL,G2H2(2),[G2H2(20)])
  call ol_merge(ntryL,G2H4(5),[G1H4(22)])
call HGT_w2_OLR(G1H4(1),1,1,4)
call HGT_w2_invQ_OLR(G1H4(1),2,5,4)
  call ol_merge(ntryL,G2H4(7),[G1H4(1)])
  call ol_merge(ntryL,G2H2(84),[G2H2(81),G2H2(78),G2H2(54),G2H2(51),G2H2(48),G2H2(45),G2H2(36),G2H2(33),G2H2(4)])
  call ol_merge(ntryL,G2H2(86),[G2H2(83),G2H2(80),G2H2(56),G2H2(53),G2H2(50),G2H2(47),G2H2(38),G2H2(35),G2H2(7),G2H2(6)])
  call ol_merge(ntryL,G2H2(75),[G2H2(72),G2H2(69),G2H2(66),G2H2(63),G2H2(60),G2H2(57),G2H2(42),G2H2(39),G2H2(9)])
call HGT_w2_OLR(G1H4(5),1,1,4)
call HGT_w2_invQ_OLR(G1H4(5),2,5,4)
  call ol_merge(ntryL,G1H4(5),[G1H4(17)])
  call ol_merge(ntryL,G2H2(77),[G2H2(74),G2H2(71),G2H2(68),G2H2(65),G2H2(62),G2H2(59),G2H2(44),G2H2(41),G2H2(12),G2H2(11)])
  call ol_merge(ntryL,G2H4(9),[G1H4(9)])
  call ol_merge(ntryL,G2H4(10),[G1H4(10)])
  call ol_merge(ntryL,G2H4(11),[G1H4(20)])
  call ol_merge(ntryL,G2H4(12),[G1H4(21)])
  call ol_merge(ntryL,G2H2(29),[G2H2(8)])
  call ol_merge(ntryL,G2H2(23),[G2H2(10)])
  call ol_merge(ntryL,G2H2(32),[G2H2(15)])
  call ol_merge(ntryL,G2H2(26),[G2H2(16)])
call Hotf_4pt_reduction(G2H2(1),RedSet_4(20),mass4set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),2)
call HG1shiftOLR(G1H2(2),64,2)
call Hotf_4pt_reduction(G2H4(8),RedSet_4(15),mass4set(:,1),  & 
G1H4(24),G1H4(25),G1H4(12),G1H4(23),G1H4(11),4)
call HG1shiftOLR(G1H4(25),10,4)
call Hotf_4pt_reduction(G2H2(2),RedSet_4(21),mass4set(:,1),  & 
G1H2(6),G1H2(7),G1H2(8),G1H2(9),G1H2(10),2)
call HG1shiftOLR(G1H2(7),16,2)
call Hotf_4pt_reduction(G2H4(5),RedSet_4(15),mass4set(:,1),  & 
G1H4(4),G1H4(22),G1H4(1),G1H4(17),G1H4(9),4)
call HG1shiftOLR(G1H4(22),10,4)
call Hotf_4pt_reduction(G2H4(7),RedSet_4(22),mass4set(:,1),  & 
G1H4(10),G1H4(20),G1H4(21),G1H4(29),G1H4(30),4)
call HG1shiftOLR(G1H4(20),5,4)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(84),ex6(:),G2tensor(1),m3h2x1(:,5),heltab2x2(:,:,5))
call HGT_w2_OLR(G1H4(2),1,1,4)
call HGT_w2_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_AW_Q(ntryL,G1H4(2),wf4(:,5),G1H1(1),m3h4x1(:,9),heltab2x4(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),255,0,G2tensor(3),n2h1(9))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(86),ex6(:),G2tensor(5),m3h2x1(:,6),heltab2x2(:,:,6))
call HGT_w2_OLR(G1H4(3),1,1,4)
call HGT_w2_invQ_OLR(G1H4(3),2,5,4)
  call Hloop_AW_Q(ntryL,G1H4(3),wf4(:,5),G1H1(1),m3h4x1(:,10),heltab2x4(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),5,0,G2tensor(9),n2h1(10))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(75),ex6(:),G2tensor(13),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hloop_AW_Q(ntryL,G1H4(5),wf4(:,6),G1H1(1),m3h4x1(:,11),heltab2x4(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),255,0,G2tensor(14),n2h1(11))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(77),ex6(:),G2tensor(15),m3h2x1(:,8),heltab2x2(:,:,8))
call HGT_w2_OLR(G1H4(6),1,1,4)
call HGT_w2_invQ_OLR(G1H4(6),2,5,4)
  call Hloop_AW_Q(ntryL,G1H4(6),wf4(:,6),G1H1(1),m3h4x1(:,12),heltab2x4(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(16),n2h1(12))
call Hotf_4pt_reduction(G2H4(9),RedSet_4(13),mass4set(:,1),  & 
G1H4(2),G1H4(3),G1H4(5),G1H4(6),G1H4(31),4)
call HG1shiftOLR(G1H4(3),10,4)
call Hotf_4pt_reduction(G2H4(10),RedSet_4(14),mass4set(:,1),  & 
G1H4(32),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
call HG1shiftOLR(G1H4(33),10,4)
  call Hloop_AW_Q(ntryL,G1H4(15),wf4(:,6),G1H1(1),m3h4x1(:,13),heltab2x4(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),255,0,G2tensor(17),n2h1(13))
  call Hloop_AW_Q(ntryL,G1H4(16),wf4(:,6),G1H1(1),m3h4x1(:,14),heltab2x4(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),255,0,G2tensor(18),n2h1(14))
call Hotf_4pt_reduction(G2H4(11),RedSet_4(17),mass4set(:,1),  & 
G1H4(15),G1H4(16),G1H4(37),G1H4(38),G1H4(39),4)
call HG1shiftOLR(G1H4(16),10,4)
call Hotf_4pt_reduction(G2H4(12),RedSet_4(18),mass4set(:,1),  & 
G1H4(40),G1H4(41),G1H4(42),G1H4(43),G1H4(44),4)
call HG1shiftOLR(G1H4(41),10,4)
  call Hloop_QW_A(ntryL,G1H4(26),wf4(:,6),G1H1(1),m3h4x1(:,15),heltab2x4(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(19),n2h1(15))
  call Hloop_QW_A(ntryL,G1H4(27),wf4(:,6),G1H1(1),m3h4x1(:,16),heltab2x4(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(20),n2h1(16))
  call Hloop_QW_A(ntryL,G1H4(28),wf4(:,6),G1H1(1),m3h4x1(:,17),heltab2x4(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(21),n2h1(17))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(29),ex6(:),G2tensor(22),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(23),ex6(:),G2tensor(23),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(32),ex6(:),G2tensor(24),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(26),ex6(:),G2tensor(25),m3h2x1(:,12),heltab2x2(:,:,12))
call Hotf_4pt_reduction(G2H4(13),RedSet_4(23),mass4set(:,1),  & 
G1H4(26),G1H4(27),G1H4(28),G1H4(45),G1H4(46),4)
call HG1shiftOLR(G1H4(27),80,4)
call Hotf_4pt_reduction(G2H4(14),RedSet_4(24),mass4set(:,1),  & 
G1H4(47),G1H4(48),G1H4(49),G1H4(50),G1H4(51),4)
call HG1shiftOLR(G1H4(48),80,4)
call Hotf_4pt_reduction(G2H16(5),RedSet_4(25),mass4set(:,1),  & 
G1H16(34),G1H16(33),G1H16(4),G1H16(3),G1H16(36),16)
call HG1shiftOLR(G1H16(33),85,16)
call Hotf_4pt_reduction(G2H16(6),RedSet_4(25),mass4set(:,1),  & 
G1H16(35),G1H16(18),G1H16(17),G1H16(14),G1H16(13),16)
call HG1shiftOLR(G1H16(18),85,16)
call Hotf_4pt_reduction(G2H16(7),RedSet_4(26),mass4set(:,1),  & 
G1H16(6),G1H16(5),G1H16(28),G1H16(27),G1H16(24),16)
call HG1shiftOLR(G1H16(5),90,16)
call Hotf_4pt_reduction(G2H16(8),RedSet_4(26),mass4set(:,1),  & 
G1H16(23),G1H16(20),G1H16(19),G1H16(8),G1H16(7),16)
call HG1shiftOLR(G1H16(20),90,16)
call Hotf_4pt_reduction(G2H8(6),RedSet_4(27),mass4set(:,1),  & 
G1H8(17),G1H8(18),G1H8(16),G1H8(32),G1H8(15),8)
call HG1shiftOLR(G1H8(18),21,8)
call Hotf_4pt_reduction(G2H8(7),RedSet_4(28),mass4set(:,1),  & 
G1H8(31),G1H8(3),G1H8(4),G1H8(9),G1H8(10),8)
call HG1shiftOLR(G1H8(3),69,8)
call Hotf_4pt_reduction(G2H8(9),RedSet_4(6),mass4set(:,1),  & 
G1H8(21),G1H8(22),G1H8(26),G1H8(27),G1H8(37),8)
call HG1shiftOLR(G1H8(22),26,8)
call Hotf_4pt_reduction(G2H8(10),RedSet_4(5),mass4set(:,1),  & 
G1H8(38),G1H8(42),G1H8(43),G1H8(33),G1H8(34),8)
call HG1shiftOLR(G1H8(42),74,8)
call Hotf_4pt_reduction(G2H2(17),RedSet_4(29),mass4set(:,1),  & 
G1H2(11),G1H2(12),G1H2(13),G1H2(14),G1H2(15),2)
call HG1shiftOLR(G1H2(12),64,2)
call Hotf_4pt_reduction(G2H2(18),RedSet_4(30),mass4set(:,1),  & 
G1H2(16),G1H2(17),G1H2(18),G1H2(19),G1H2(20),2)
call HG1shiftOLR(G1H2(17),16,2)
call Hotf_4pt_reduction(G2H16(1),RedSet_4(25),mass4set(:,1),  & 
G1H16(39),G1H16(40),G1H16(41),G1H16(42),G1H16(43),16)
call HG1shiftOLR(G1H16(40),85,16)
call Hotf_4pt_reduction(G2H16(2),RedSet_4(25),mass4set(:,1),  & 
G1H16(44),G1H16(45),G1H16(46),G1H16(47),G1H16(48),16)
call HG1shiftOLR(G1H16(45),85,16)
call Hotf_4pt_reduction(G2H16(3),RedSet_4(25),mass4set(:,1),  & 
G1H16(49),G1H16(50),G1H16(51),G1H16(52),G1H16(53),16)
call HG1shiftOLR(G1H16(50),85,16)
call Hotf_4pt_reduction(G2H16(4),RedSet_4(25),mass4set(:,1),  & 
G1H16(54),G1H16(55),G1H16(56),G1H16(57),G1H16(58),16)
call HG1shiftOLR(G1H16(55),85,16)
call Hotf_4pt_reduction(G2H16(9),RedSet_4(26),mass4set(:,1),  & 
G1H16(59),G1H16(60),G1H16(61),G1H16(62),G1H16(63),16)
call HG1shiftOLR(G1H16(60),90,16)
call Hotf_4pt_reduction(G2H16(10),RedSet_4(26),mass4set(:,1),  & 
G1H16(64),G1H16(65),G1H16(66),G1H16(67),G1H16(68),16)
call HG1shiftOLR(G1H16(65),90,16)
call Hotf_4pt_reduction(G2H16(11),RedSet_4(26),mass4set(:,1),  & 
G1H16(69),G1H16(70),G1H16(71),G1H16(72),G1H16(73),16)
call HG1shiftOLR(G1H16(70),90,16)
call Hotf_4pt_reduction(G2H16(12),RedSet_4(26),mass4set(:,1),  & 
G1H16(74),G1H16(75),G1H16(76),G1H16(77),G1H16(78),16)
call HG1shiftOLR(G1H16(75),90,16)
call Hotf_4pt_reduction(G2H16(13),RedSet_4(26),mass4set(:,1),  & 
G1H16(79),G1H16(80),G1H16(81),G1H16(82),G1H16(83),16)
call HG1shiftOLR(G1H16(80),90,16)
call Hotf_4pt_reduction(G2H16(14),RedSet_4(26),mass4set(:,1),  & 
G1H16(84),G1H16(85),G1H16(86),G1H16(87),G1H16(88),16)
call HG1shiftOLR(G1H16(85),90,16)
call Hotf_4pt_reduction(G2H16(15),RedSet_4(26),mass4set(:,1),  & 
G1H16(89),G1H16(90),G1H16(91),G1H16(92),G1H16(93),16)
call HG1shiftOLR(G1H16(90),90,16)
call Hotf_4pt_reduction(G2H16(16),RedSet_4(25),mass4set(:,1),  & 
G1H16(94),G1H16(95),G1H16(96),G1H16(97),G1H16(98),16)
call HG1shiftOLR(G1H16(95),85,16)
call Hotf_4pt_reduction(G2H16(17),RedSet_4(25),mass4set(:,1),  & 
G1H16(99),G1H16(100),G1H16(101),G1H16(102),G1H16(103),16)
call HG1shiftOLR(G1H16(100),85,16)
call Hotf_4pt_reduction(G2H16(18),RedSet_4(25),mass4set(:,1),  & 
G1H16(104),G1H16(105),G1H16(106),G1H16(107),G1H16(108),16)
call HG1shiftOLR(G1H16(105),85,16)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(21),ex6(:),G2tensor(26),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(24),ex6(:),G2tensor(27),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(27),ex6(:),G2tensor(28),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(30),ex6(:),G2tensor(29),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(1),wf8(:,3),G2tensor(30),m3h8x1(:,1),heltab2x8(:,:,53))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(4),wf8(:,3),G2tensor(31),m3h8x1(:,2),heltab2x8(:,:,54))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(8),wf8(:,7),G2tensor(32),m3h8x1(:,3),heltab2x8(:,:,55))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(5),wf8(:,7),G2tensor(33),m3h8x1(:,4),heltab2x8(:,:,56))
  call Hloop_VA_Q(ntryL,G1H2(1),ex7(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),255,0,G2tensor(34),n2h1(18))
  call Hloop_VA_Q(ntryL,G1H2(2),ex7(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),64,0,G2tensor(35),n2h1(19))
  call Hloop_VA_Q(ntryL,G1H2(5),ex7(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),255,0,G2tensor(36),n2h1(20))
  call Hloop_AW_Q(ntryL,G1H4(24),wf4(:,6),G1H1(1),m3h4x1(:,18),heltab2x4(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),255,0,G2tensor(37),n2h1(21))
  call Hloop_AW_Q(ntryL,G1H4(25),wf4(:,6),G1H1(1),m3h4x1(:,19),heltab2x4(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(38),n2h1(22))
  call Hloop_AW_Q(ntryL,G1H4(11),wf4(:,6),G1H1(1),m3h4x1(:,20),heltab2x4(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),255,0,G2tensor(39),n2h1(23))
  call Hloop_VQ_A(ntryL,G1H2(6),ex5(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(40),n2h1(24))
  call Hloop_VQ_A(ntryL,G1H2(7),ex5(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(41),n2h1(25))
  call Hloop_VQ_A(ntryL,G1H2(10),ex5(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(42),n2h1(26))
  call Hloop_QW_A(ntryL,G1H4(4),wf4(:,6),G1H1(1),m3h4x1(:,21),heltab2x4(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(43),n2h1(27))
  call Hloop_QW_A(ntryL,G1H4(22),wf4(:,6),G1H1(1),m3h4x1(:,22),heltab2x4(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(44),n2h1(28))
  call Hloop_QW_A(ntryL,G1H4(9),wf4(:,6),G1H1(1),m3h4x1(:,23),heltab2x4(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(45),n2h1(29))
  call Hloop_AW_Q(ntryL,G1H4(10),wf4(:,5),G1H1(1),m3h4x1(:,24),heltab2x4(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),255,0,G2tensor(46),n2h1(30))
  call Hloop_AW_Q(ntryL,G1H4(20),wf4(:,5),G1H1(1),m3h4x1(:,25),heltab2x4(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),5,0,G2tensor(47),n2h1(31))
  call Hloop_AW_Q(ntryL,G1H4(30),wf4(:,5),G1H1(1),m3h4x1(:,26),heltab2x4(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),255,0,G2tensor(48),n2h1(32))
  call Hloop_AW_Q(ntryL,G1H4(2),wf4(:,6),G1H1(1),m3h4x1(:,27),heltab2x4(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),255,0,G2tensor(49),n2h1(33))
  call Hloop_AW_Q(ntryL,G1H4(3),wf4(:,6),G1H1(1),m3h4x1(:,28),heltab2x4(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(50),n2h1(34))
  call Hloop_AW_Q(ntryL,G1H4(31),wf4(:,6),G1H1(1),m3h4x1(:,29),heltab2x4(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),255,0,G2tensor(51),n2h1(35))
  call Hloop_AW_Q(ntryL,G1H4(32),wf4(:,6),G1H1(1),m3h4x1(:,30),heltab2x4(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),255,0,G2tensor(52),n2h1(36))
  call Hloop_AW_Q(ntryL,G1H4(33),wf4(:,6),G1H1(1),m3h4x1(:,31),heltab2x4(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(53),n2h1(37))
  call Hloop_AW_Q(ntryL,G1H4(36),wf4(:,6),G1H1(1),m3h4x1(:,32),heltab2x4(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),255,0,G2tensor(54),n2h1(38))
  call Hloop_QW_A(ntryL,G1H4(15),wf4(:,6),G1H1(1),m3h4x1(:,33),heltab2x4(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(55),n2h1(39))
  call Hloop_QW_A(ntryL,G1H4(16),wf4(:,6),G1H1(1),m3h4x1(:,34),heltab2x4(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(56),n2h1(40))
  call Hloop_QW_A(ntryL,G1H4(39),wf4(:,6),G1H1(1),m3h4x1(:,35),heltab2x4(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(57),n2h1(41))
  call Hloop_QW_A(ntryL,G1H4(40),wf4(:,6),G1H1(1),m3h4x1(:,36),heltab2x4(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(58),n2h1(42))
  call Hloop_QW_A(ntryL,G1H4(41),wf4(:,6),G1H1(1),m3h4x1(:,37),heltab2x4(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(59),n2h1(43))
  call Hloop_QW_A(ntryL,G1H4(44),wf4(:,6),G1H1(1),m3h4x1(:,38),heltab2x4(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(60),n2h1(44))
  call Hloop_QW_A(ntryL,G1H4(26),wf4(:,7),G1H1(1),m3h4x1(:,39),heltab2x4(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(61),n2h1(45))
  call Hloop_QW_A(ntryL,G1H4(27),wf4(:,7),G1H1(1),m3h4x1(:,40),heltab2x4(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),80,0,G2tensor(62),n2h1(46))
  call Hloop_QW_A(ntryL,G1H4(46),wf4(:,7),G1H1(1),m3h4x1(:,41),heltab2x4(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(63),n2h1(47))
  call Hloop_QW_A(ntryL,G1H4(47),wf4(:,7),G1H1(1),m3h4x1(:,42),heltab2x4(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(64),n2h1(48))
  call Hloop_QW_A(ntryL,G1H4(48),wf4(:,7),G1H1(1),m3h4x1(:,43),heltab2x4(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),80,0,G2tensor(65),n2h1(49))
  call Hloop_QW_A(ntryL,G1H4(51),wf4(:,7),G1H1(1),m3h4x1(:,44),heltab2x4(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(66),n2h1(50))
  call Hloop_QV_A(ntryL,G1H16(34),wf16(:,3),G1H1(1),m3h16x1(:,1),heltab2x16(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(67),n2h1(51))
  call Hloop_QV_A(ntryL,G1H16(33),wf16(:,3),G1H1(1),m3h16x1(:,2),heltab2x16(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),85,0,G2tensor(68),n2h1(52))
  call Hloop_QV_A(ntryL,G1H16(36),wf16(:,3),G1H1(1),m3h16x1(:,3),heltab2x16(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(69),n2h1(53))
  call Hloop_QZ_A(ntryL,G1H16(35),wf16(:,5),G1H1(1),ngZd,m3h16x1(:,4),heltab2x16(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(70),n2h1(54))
  call Hloop_QZ_A(ntryL,G1H16(18),wf16(:,5),G1H1(1),ngZd,m3h16x1(:,5),heltab2x16(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),85,0,G2tensor(71),n2h1(55))
  call Hloop_QZ_A(ntryL,G1H16(13),wf16(:,5),G1H1(1),ngZd,m3h16x1(:,6),heltab2x16(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(72),n2h1(56))
  call Hloop_QV_A(ntryL,G1H16(6),wf16(:,9),G1H1(1),m3h16x1(:,7),heltab2x16(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(73),n2h1(57))
  call Hloop_QV_A(ntryL,G1H16(5),wf16(:,9),G1H1(1),m3h16x1(:,8),heltab2x16(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),90,0,G2tensor(74),n2h1(58))
  call Hloop_QV_A(ntryL,G1H16(24),wf16(:,9),G1H1(1),m3h16x1(:,9),heltab2x16(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(75),n2h1(59))
  call Hloop_QZ_A(ntryL,G1H16(23),wf16(:,12),G1H1(1),ngZd,m3h16x1(:,10),heltab2x16(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(76),n2h1(60))
  call Hloop_QZ_A(ntryL,G1H16(20),wf16(:,12),G1H1(1),ngZd,m3h16x1(:,11),heltab2x16(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),90,0,G2tensor(77),n2h1(61))
  call Hloop_QZ_A(ntryL,G1H16(7),wf16(:,12),G1H1(1),ngZd,m3h16x1(:,12),heltab2x16(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(78),n2h1(62))
  call Hloop_VQ_A(ntryL,G1H8(17),wf8(:,11),G1H1(1),m3h8x1(:,5),heltab2x8(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(79),n2h1(63))
  call Hloop_VQ_A(ntryL,G1H8(18),wf8(:,11),G1H1(1),m3h8x1(:,6),heltab2x8(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),21,0,G2tensor(80),n2h1(64))
  call Hloop_VQ_A(ntryL,G1H8(15),wf8(:,11),G1H1(1),m3h8x1(:,7),heltab2x8(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(81),n2h1(65))
  call Hloop_VA_Q(ntryL,G1H8(31),wf8(:,16),G1H1(1),m3h8x1(:,8),heltab2x8(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),255,0,G2tensor(82),n2h1(66))
  call Hloop_VA_Q(ntryL,G1H8(3),wf8(:,16),G1H1(1),m3h8x1(:,9),heltab2x8(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),69,0,G2tensor(83),n2h1(67))
  call Hloop_VA_Q(ntryL,G1H8(10),wf8(:,16),G1H1(1),m3h8x1(:,10),heltab2x8(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),255,0,G2tensor(84),n2h1(68))
  call Hloop_VQ_A(ntryL,G1H8(21),wf8(:,15),G1H1(1),m3h8x1(:,11),heltab2x8(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(85),n2h1(69))
  call Hloop_VQ_A(ntryL,G1H8(22),wf8(:,15),G1H1(1),m3h8x1(:,12),heltab2x8(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),26,0,G2tensor(86),n2h1(70))
  call Hloop_VQ_A(ntryL,G1H8(37),wf8(:,15),G1H1(1),m3h8x1(:,13),heltab2x8(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(87),n2h1(71))
  call Hloop_VA_Q(ntryL,G1H8(38),wf8(:,12),G1H1(1),m3h8x1(:,14),heltab2x8(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),255,0,G2tensor(88),n2h1(72))
  call Hloop_VA_Q(ntryL,G1H8(42),wf8(:,12),G1H1(1),m3h8x1(:,15),heltab2x8(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),74,0,G2tensor(89),n2h1(73))
  call Hloop_VA_Q(ntryL,G1H8(34),wf8(:,12),G1H1(1),m3h8x1(:,16),heltab2x8(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),255,0,G2tensor(90),n2h1(74))
  call Hloop_VA_Q(ntryL,G1H2(11),ex7(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),255,0,G2tensor(91),n2h1(75))
  call Hloop_VA_Q(ntryL,G1H2(12),ex7(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),64,0,G2tensor(92),n2h1(76))
  call Hloop_VA_Q(ntryL,G1H2(15),ex7(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),255,0,G2tensor(93),n2h1(77))
  call Hloop_VQ_A(ntryL,G1H2(16),ex5(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(94),n2h1(78))
  call Hloop_VQ_A(ntryL,G1H2(17),ex5(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(95),n2h1(79))
  call Hloop_VQ_A(ntryL,G1H2(20),ex5(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(96),n2h1(80))
  call Hloop_QV_A(ntryL,G1H16(39),wf16(:,20),G1H1(1),m3h16x1(:,13),heltab2x16(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(97),n2h1(81))
  call Hloop_QV_A(ntryL,G1H16(40),wf16(:,20),G1H1(1),m3h16x1(:,14),heltab2x16(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),85,0,G2tensor(98),n2h1(82))
  call Hloop_QV_A(ntryL,G1H16(43),wf16(:,20),G1H1(1),m3h16x1(:,15),heltab2x16(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(99),n2h1(83))
  call Hloop_QZ_A(ntryL,G1H16(44),wf16(:,29),G1H1(1),ngZd,m3h16x1(:,16),heltab2x16(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(100),n2h1(84))
  call Hloop_QZ_A(ntryL,G1H16(45),wf16(:,29),G1H1(1),ngZd,m3h16x1(:,17),heltab2x16(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),85,0,G2tensor(101),n2h1(85))
  call Hloop_QZ_A(ntryL,G1H16(48),wf16(:,29),G1H1(1),ngZd,m3h16x1(:,18),heltab2x16(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(102),n2h1(86))
  call Hloop_QV_A(ntryL,G1H16(49),wf16(:,23),G1H1(1),m3h16x1(:,19),heltab2x16(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(103),n2h1(87))
  call Hloop_QV_A(ntryL,G1H16(50),wf16(:,23),G1H1(1),m3h16x1(:,20),heltab2x16(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),85,0,G2tensor(104),n2h1(88))
  call Hloop_QV_A(ntryL,G1H16(53),wf16(:,23),G1H1(1),m3h16x1(:,21),heltab2x16(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(105),n2h1(89))
  call Hloop_QZ_A(ntryL,G1H16(54),wf16(:,33),G1H1(1),ngZd,m3h16x1(:,22),heltab2x16(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(106),n2h1(90))
  call Hloop_QZ_A(ntryL,G1H16(55),wf16(:,33),G1H1(1),ngZd,m3h16x1(:,23),heltab2x16(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),85,0,G2tensor(107),n2h1(91))
  call Hloop_QZ_A(ntryL,G1H16(58),wf16(:,33),G1H1(1),ngZd,m3h16x1(:,24),heltab2x16(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(108),n2h1(92))
  call Hloop_QV_A(ntryL,G1H16(59),wf16(:,25),G1H1(1),m3h16x1(:,25),heltab2x16(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(109),n2h1(93))
  call Hloop_QV_A(ntryL,G1H16(60),wf16(:,25),G1H1(1),m3h16x1(:,26),heltab2x16(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),90,0,G2tensor(110),n2h1(94))
  call Hloop_QV_A(ntryL,G1H16(63),wf16(:,25),G1H1(1),m3h16x1(:,27),heltab2x16(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(111),n2h1(95))
  call Hloop_QZ_A(ntryL,G1H16(64),wf16(:,31),G1H1(1),ngZd,m3h16x1(:,28),heltab2x16(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(112),n2h1(96))
  call Hloop_QZ_A(ntryL,G1H16(65),wf16(:,31),G1H1(1),ngZd,m3h16x1(:,29),heltab2x16(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),90,0,G2tensor(113),n2h1(97))
  call Hloop_QZ_A(ntryL,G1H16(68),wf16(:,31),G1H1(1),ngZd,m3h16x1(:,30),heltab2x16(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(114),n2h1(98))
  call Hloop_QV_A(ntryL,G1H16(69),wf16(:,27),G1H1(1),m3h16x1(:,31),heltab2x16(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(115),n2h1(99))
  call Hloop_QV_A(ntryL,G1H16(70),wf16(:,27),G1H1(1),m3h16x1(:,32),heltab2x16(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),90,0,G2tensor(116),n2h1(100))
  call Hloop_QV_A(ntryL,G1H16(73),wf16(:,27),G1H1(1),m3h16x1(:,33),heltab2x16(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(117),n2h1(101))
  call Hloop_QZ_A(ntryL,G1H16(74),wf16(:,32),G1H1(1),ngZd,m3h16x1(:,34),heltab2x16(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(118),n2h1(102))
  call Hloop_QZ_A(ntryL,G1H16(75),wf16(:,32),G1H1(1),ngZd,m3h16x1(:,35),heltab2x16(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),90,0,G2tensor(119),n2h1(103))
  call Hloop_QZ_A(ntryL,G1H16(78),wf16(:,32),G1H1(1),ngZd,m3h16x1(:,36),heltab2x16(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(120),n2h1(104))
  call Hloop_QV_A(ntryL,G1H16(79),wf16(:,35),G1H1(1),m3h16x1(:,37),heltab2x16(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(121),n2h1(105))
  call Hloop_QV_A(ntryL,G1H16(80),wf16(:,35),G1H1(1),m3h16x1(:,38),heltab2x16(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),90,0,G2tensor(122),n2h1(106))
  call Hloop_QV_A(ntryL,G1H16(83),wf16(:,35),G1H1(1),m3h16x1(:,39),heltab2x16(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(123),n2h1(107))
  call Hloop_QZ_A(ntryL,G1H16(84),wf16(:,41),G1H1(1),ngZd,m3h16x1(:,40),heltab2x16(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(124),n2h1(108))
  call Hloop_QZ_A(ntryL,G1H16(85),wf16(:,41),G1H1(1),ngZd,m3h16x1(:,41),heltab2x16(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),90,0,G2tensor(125),n2h1(109))
  call Hloop_QZ_A(ntryL,G1H16(88),wf16(:,41),G1H1(1),ngZd,m3h16x1(:,42),heltab2x16(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(126),n2h1(110))
  call Hloop_QZ_A(ntryL,G1H16(89),wf16(:,42),G1H1(1),ngZd,m3h16x1(:,43),heltab2x16(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(127),n2h1(111))
  call Hloop_QZ_A(ntryL,G1H16(90),wf16(:,42),G1H1(1),ngZd,m3h16x1(:,44),heltab2x16(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),90,0,G2tensor(128),n2h1(112))
  call Hloop_QZ_A(ntryL,G1H16(93),wf16(:,42),G1H1(1),ngZd,m3h16x1(:,45),heltab2x16(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(129),n2h1(113))
  call Hloop_QV_A(ntryL,G1H16(94),wf16(:,45),G1H1(1),m3h16x1(:,46),heltab2x16(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(130),n2h1(114))
  call Hloop_QV_A(ntryL,G1H16(95),wf16(:,45),G1H1(1),m3h16x1(:,47),heltab2x16(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),85,0,G2tensor(131),n2h1(115))
  call Hloop_QV_A(ntryL,G1H16(98),wf16(:,45),G1H1(1),m3h16x1(:,48),heltab2x16(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(132),n2h1(116))
  call Hloop_QZ_A(ntryL,G1H16(99),wf16(:,51),G1H1(1),ngZd,m3h16x1(:,49),heltab2x16(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(133),n2h1(117))
  call Hloop_QZ_A(ntryL,G1H16(100),wf16(:,51),G1H1(1),ngZd,m3h16x1(:,50),heltab2x16(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),85,0,G2tensor(134),n2h1(118))
  call Hloop_QZ_A(ntryL,G1H16(103),wf16(:,51),G1H1(1),ngZd,m3h16x1(:,51),heltab2x16(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(135),n2h1(119))
  call Hloop_QZ_A(ntryL,G1H16(104),wf16(:,52),G1H1(1),ngZd,m3h16x1(:,52),heltab2x16(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(136),n2h1(120))
  call Hloop_QZ_A(ntryL,G1H16(105),wf16(:,52),G1H1(1),ngZd,m3h16x1(:,53),heltab2x16(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),85,0,G2tensor(137),n2h1(121))
  call Hloop_QZ_A(ntryL,G1H16(108),wf16(:,52),G1H1(1),ngZd,m3h16x1(:,54),heltab2x16(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),255,0,G2tensor(138),n2h1(122))
  call ol_merge_tensors(G2tensor(30),[G2tensor(2),G1tensor(6)])
  call ol_merge_tensors(G2tensor(32),[G2tensor(4),G1tensor(12)])
  call ol_merge_tensors(G2tensor(34),[G2tensor(6),G1tensor(14)])
  call ol_merge_tensors(G2tensor(88),[G2tensor(7),G1tensor(18)])
  call ol_merge_tensors(G2tensor(40),[G2tensor(10),G1tensor(20)])
  call ol_merge_tensors(G2tensor(85),[G2tensor(11),G1tensor(24)])
  call ol_merge_tensors(G2tensor(46),[G1tensor(2)])
  call ol_merge_tensors(G2tensor(28),[G1tensor(3)])
  call ol_merge_tensors(G2tensor(26),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(5)])
  call ol_merge_tensors(G2tensor(43),[G2tensor(37),G1tensor(23),G1tensor(17),G1tensor(8)])
  call ol_merge_tensors(G2tensor(29),[G1tensor(9)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(10)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(11)])
  call ol_merge_tensors(G2tensor(49),[G1tensor(15)])
  call ol_merge_tensors(G2tensor(52),[G1tensor(16)])
  call ol_merge_tensors(G2tensor(55),[G1tensor(21)])
  call ol_merge_tensors(G2tensor(58),[G1tensor(22)])
  call ol_merge_tensors(G2tensor(136),[G2tensor(133),G2tensor(130),G2tensor(106),G2tensor(103),G2tensor(100),G2tensor(97) &
    ,G2tensor(70),G2tensor(67)])
  call ol_merge_tensors(G2tensor(127),[G2tensor(124),G2tensor(121),G2tensor(118),G2tensor(115),G2tensor(112),G2tensor(109) &
    ,G2tensor(76),G2tensor(73)])
call Hotf_4pt_reduction_last(G2tensor(30),RedSet_4(2),mass4set(:,1),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(6))
call G_TensorShift(G1tensor(7),37)
call Hotf_4pt_reduction_last(G2tensor(32),RedSet_4(4),mass4set(:,1),  & 
G1tensor(12),G1tensor(14),G1tensor(18),G1tensor(20),G1tensor(24))
call G_TensorShift(G1tensor(14),42)
call Hotf_4pt_reduction_last(G2tensor(34),RedSet_4(20),mass4set(:,1),  & 
G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(23))
call G_TensorShift(G1tensor(3),64)
call Hotf_4pt_reduction_last(G2tensor(88),RedSet_4(5),mass4set(:,1),  & 
G1tensor(17),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11))
call G_TensorShift(G1tensor(8),74)
call Hotf_4pt_reduction_last(G2tensor(40),RedSet_4(21),mass4set(:,1),  & 
G1tensor(15),G1tensor(16),G1tensor(21),G1tensor(22),G1tensor(25))
call G_TensorShift(G1tensor(16),16)
call Hotf_4pt_reduction_last(G2tensor(85),RedSet_4(6),mass4set(:,1),  & 
G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
call G_TensorShift(G1tensor(27),26)
call Hotf_4pt_reduction_last(G2tensor(46),RedSet_4(22),mass4set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35))
call G_TensorShift(G1tensor(32),5)
call Hotf_4pt_reduction_last(G2tensor(28),RedSet_4(7),mass4set(:,1),  & 
G1tensor(36),G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40))
call G_TensorShift(G1tensor(37),32)
call Hotf_4pt_reduction_last(G2tensor(26),RedSet_4(8),mass4set(:,1),  & 
G1tensor(41),G1tensor(42),G1tensor(43),G1tensor(44),G1tensor(45))
call G_TensorShift(G1tensor(42),32)
call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,1),  & 
G1tensor(46),G1tensor(47),G1tensor(48),G1tensor(49),G1tensor(50))
call G_TensorShift(G1tensor(47),32)
call Hotf_4pt_reduction_last(G2tensor(43),RedSet_4(15),mass4set(:,1),  & 
G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54),G1tensor(55))
call G_TensorShift(G1tensor(52),10)
call Hotf_4pt_reduction_last(G2tensor(29),RedSet_4(10),mass4set(:,1),  & 
G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
call G_TensorShift(G1tensor(57),32)
call Hotf_4pt_reduction_last(G2tensor(27),RedSet_4(11),mass4set(:,1),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65))
call G_TensorShift(G1tensor(62),32)
call Hotf_4pt_reduction_last(G2tensor(13),RedSet_4(3),mass4set(:,1),  & 
G1tensor(66),G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70))
call G_TensorShift(G1tensor(67),32)
call Hotf_4pt_reduction_last(G2tensor(49),RedSet_4(13),mass4set(:,1),  & 
G1tensor(71),G1tensor(72),G1tensor(73),G1tensor(74),G1tensor(75))
call G_TensorShift(G1tensor(72),10)
call Hotf_4pt_reduction_last(G2tensor(52),RedSet_4(14),mass4set(:,1),  & 
G1tensor(76),G1tensor(77),G1tensor(78),G1tensor(79),G1tensor(80))
call G_TensorShift(G1tensor(77),10)
call Hotf_4pt_reduction_last(G2tensor(55),RedSet_4(17),mass4set(:,1),  & 
G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84),G1tensor(85))
call G_TensorShift(G1tensor(82),10)
call Hotf_4pt_reduction_last(G2tensor(58),RedSet_4(18),mass4set(:,1),  & 
G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
call G_TensorShift(G1tensor(87),10)
call Hotf_4pt_reduction_last(G2tensor(61),RedSet_4(23),mass4set(:,1),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95))
call G_TensorShift(G1tensor(92),80)
call Hotf_4pt_reduction_last(G2tensor(64),RedSet_4(24),mass4set(:,1),  & 
G1tensor(96),G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100))
call G_TensorShift(G1tensor(97),80)
call Hotf_4pt_reduction_last(G2tensor(136),RedSet_4(25),mass4set(:,1),  & 
G1tensor(101),G1tensor(102),G1tensor(103),G1tensor(104),G1tensor(105))
call G_TensorShift(G1tensor(102),85)
call Hotf_4pt_reduction_last(G2tensor(127),RedSet_4(26),mass4set(:,1),  & 
G1tensor(106),G1tensor(107),G1tensor(108),G1tensor(109),G1tensor(110))
call G_TensorShift(G1tensor(107),90)
call Hotf_4pt_reduction_last(G2tensor(79),RedSet_4(27),mass4set(:,1),  & 
G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114),G1tensor(115))
call G_TensorShift(G1tensor(112),21)
call Hotf_4pt_reduction_last(G2tensor(82),RedSet_4(28),mass4set(:,1),  & 
G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
call G_TensorShift(G1tensor(117),69)
call Hotf_4pt_reduction_last(G2tensor(91),RedSet_4(29),mass4set(:,1),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125))
call G_TensorShift(G1tensor(122),64)
call Hotf_4pt_reduction_last(G2tensor(94),RedSet_4(30),mass4set(:,1),  & 
G1tensor(126),G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130))
call G_TensorShift(G1tensor(127),16)
call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(2),mass4set(:,1),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
call Hotf_4pt_reduction_last(G1tensor(12),RedSet_4(4),mass4set(:,1),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
call Hotf_4pt_reduction_last(G1tensor(2),RedSet_4(20),mass4set(:,1),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
call Hotf_4pt_reduction_last(G1tensor(17),RedSet_4(5),mass4set(:,1),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
call Hotf_4pt_reduction_last(G1tensor(15),RedSet_4(21),mass4set(:,1),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(6),mass4set(:,1),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(22),mass4set(:,1),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
call Hotf_4pt_reduction_last(G1tensor(36),RedSet_4(7),mass4set(:,1),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(8),mass4set(:,1),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
call Hotf_4pt_reduction_last(G1tensor(46),RedSet_4(1),mass4set(:,1),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(15),mass4set(:,1),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
call Hotf_4pt_reduction_last(G1tensor(56),RedSet_4(10),mass4set(:,1),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(11),mass4set(:,1),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(3),mass4set(:,1),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
call Hotf_4pt_reduction_last(G1tensor(71),RedSet_4(13),mass4set(:,1),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(14),mass4set(:,1),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
call Hotf_4pt_reduction_last(G1tensor(81),RedSet_4(17),mass4set(:,1),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
call Hotf_4pt_reduction_last(G1tensor(86),RedSet_4(18),mass4set(:,1),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(23),mass4set(:,1),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
call Hotf_4pt_reduction_last(G1tensor(96),RedSet_4(24),mass4set(:,1),  & 
G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100))
call Hotf_4pt_reduction_last(G1tensor(101),RedSet_4(25),mass4set(:,1),  & 
G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104),G0tensor(105))
call Hotf_4pt_reduction_last(G1tensor(106),RedSet_4(26),mass4set(:,1),  & 
G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110))
call Hotf_4pt_reduction_last(G1tensor(111),RedSet_4(27),mass4set(:,1),  & 
G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114),G0tensor(115))
call Hotf_4pt_reduction_last(G1tensor(116),RedSet_4(28),mass4set(:,1),  & 
G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119),G0tensor(120))
call Hotf_4pt_reduction_last(G1tensor(121),RedSet_4(29),mass4set(:,1),  & 
G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124),G0tensor(125))
call Hotf_4pt_reduction_last(G1tensor(126),RedSet_4(30),mass4set(:,1),  & 
G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129),G0tensor(130))
call ol_merge_tensors(T0sum(1),[G0tensor(1)])
call ol_merge_tensors(T0sum(2),[G0tensor(6)])
call ol_merge_tensors(T0sum(3),[G0tensor(11)])
call ol_merge_tensors(T0sum(4),[G0tensor(16)])
call ol_merge_tensors(T0sum(5),[G0tensor(21)])
call ol_merge_tensors(T0sum(6),[G0tensor(26)])
call ol_merge_tensors(T0sum(7),[G0tensor(31)])
call ol_merge_tensors(T0sum(8),[G0tensor(36)])
call ol_merge_tensors(T0sum(9),[G0tensor(41)])
call ol_merge_tensors(T0sum(10),[G0tensor(46)])
call ol_merge_tensors(T0sum(11),[G0tensor(51)])
call ol_merge_tensors(T0sum(12),[G0tensor(56)])
call ol_merge_tensors(T0sum(13),[G0tensor(61)])
call ol_merge_tensors(T0sum(14),[G0tensor(66)])
call ol_merge_tensors(T0sum(15),[G0tensor(71)])
call ol_merge_tensors(T0sum(16),[G0tensor(76)])
call ol_merge_tensors(T0sum(17),[G0tensor(81)])
call ol_merge_tensors(T0sum(18),[G0tensor(86)])
call ol_merge_tensors(T0sum(19),[G0tensor(91)])
call ol_merge_tensors(T0sum(20),[G0tensor(96)])
call ol_merge_tensors(T0sum(21),[G0tensor(101)])
call ol_merge_tensors(T0sum(22),[G0tensor(106)])
call ol_merge_tensors(T0sum(23),[G0tensor(111)])
call ol_merge_tensors(T0sum(24),[G0tensor(116)])
call ol_merge_tensors(T0sum(25),[G0tensor(121)])
call ol_merge_tensors(T0sum(26),[G0tensor(126)])
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(332)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(85),h0tab(:,85),[128,32,95],[0,0,0],3,1,wf64(:,3))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,41),heltab2x256(:,:,85))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(335)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(86),h0tab(:,86),[175,16,64],[0,0,0],3,1,wf64(:,5))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,5),G0H4(1),m3h64x4(:,1),heltab2x256(:,:,86))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(24),n2h4(19))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(624)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(87),h0tab(:,87),[138,37,80],[0,0,0],3,3,wf8(:,4),wf8(:,3),wf4(:,7))
  call Hloop_QA_V(ntryL,G0H256(1),wf8(:,4),G0H32(1),m3h8x32(:,3),heltab2x256(:,:,87))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(37)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(88),h0tab(:,88),[128,37,90],[0,0,0],3,2,wf8(:,3),wf16(:,9))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(2),m3h2x128(:,42),heltab2x256(:,:,88))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(40)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(89),h0tab(:,89),[128,37,90],[0,0,0],3,2,wf8(:,3),wf16(:,12))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(3),m3h2x128(:,43),heltab2x256(:,:,89))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(625)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(90),h0tab(:,90),[128,10,117],[0,0,0],3,2,wf4(:,6),wf32(:,45))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(4),m3h2x128(:,44),heltab2x256(:,:,90))
  call Hloop_A_Q(ntryL,G0H128(4),128,0,G1H128(1),n2h128(23))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(627)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(91),h0tab(:,91),[133,42,80],[0,0,0],3,3,wf8(:,8),wf8(:,7),wf4(:,7))
  call Hloop_QA_V(ntryL,G0H256(1),wf8(:,8),G0H32(2),m3h8x32(:,4),heltab2x256(:,:,91))
Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(47)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(92),h0tab(:,92),[133,32,90],[0,0,0],3,2,wf8(:,8),wf16(:,9))
  call Hloop_QA_V(ntryL,G0H256(1),wf8(:,8),G0H32(3),m3h8x32(:,5),heltab2x256(:,:,92))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(48)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(93),h0tab(:,93),[133,32,90],[0,0,0],3,2,wf8(:,8),wf16(:,12))
  call Hloop_QA_V(ntryL,G0H256(1),wf8(:,8),G0H32(4),m3h8x32(:,6),heltab2x256(:,:,93))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(628)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(94),h0tab(:,94),[213,10,32],[0,0,0],3,2,wf32(:,44),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,44),G0H8(1),m3h32x8(:,1),heltab2x256(:,:,94))
  call Hloop_A_Q(ntryL,G0H8(1),213,0,G1H8(2),n2h8(29))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(49)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(95),h0tab(:,95),[128,42,85],[0,0,0],3,2,wf8(:,7),wf16(:,3))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(5),m3h2x128(:,45),heltab2x256(:,:,95))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(50)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(96),h0tab(:,96),[128,42,85],[0,0,0],3,2,wf8(:,7),wf16(:,5))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(6),m3h2x128(:,46),heltab2x256(:,:,96))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(630)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(97),h0tab(:,97),[128,5,122],[0,0,0],3,2,wf4(:,5),wf32(:,46))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(7),m3h2x128(:,47),heltab2x256(:,:,97))
  call Hloop_A_Q(ntryL,G0H128(7),128,0,G1H128(2),n2h128(24))
Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(51)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(98),h0tab(:,98),[138,32,85],[0,0,0],3,2,wf8(:,4),wf16(:,3))
  call Hloop_QA_V(ntryL,G0H256(1),wf8(:,4),G0H32(5),m3h8x32(:,7),heltab2x256(:,:,98))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(52)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(99),h0tab(:,99),[138,32,85],[0,0,0],3,2,wf8(:,4),wf16(:,5))
  call Hloop_QA_V(ntryL,G0H256(1),wf8(:,4),G0H32(6),m3h8x32(:,8),heltab2x256(:,:,99))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(632)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(100),h0tab(:,100),[218,5,32],[0,0,0],3,2,wf32(:,42),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,42),G0H8(1),m3h32x8(:,2),heltab2x256(:,:,100))
  call Hloop_A_Q(ntryL,G0H8(1),218,0,G1H8(5),n2h8(30))
Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(634)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(101),h0tab(:,101),[128,10,117],[0,0,0],3,2,wf4(:,6),wf32(:,38))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(8),m3h2x128(:,48),heltab2x256(:,:,101))
  call Hloop_A_Q(ntryL,G0H128(8),128,0,G1H128(3),n2h128(25))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(635)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(102),h0tab(:,102),[128,10,117],[0,0,0],3,2,wf4(:,6),wf32(:,40))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(9),m3h2x128(:,49),heltab2x256(:,:,102))
  call Hloop_A_Q(ntryL,G0H128(9),128,0,G1H128(4),n2h128(26))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(636)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(103),h0tab(:,103),[213,10,32],[0,0,0],3,2,wf32(:,34),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,34),G0H8(1),m3h32x8(:,3),heltab2x256(:,:,103))
  call Hloop_A_Q(ntryL,G0H8(1),213,0,G1H8(6),n2h8(31))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(637)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(104),h0tab(:,104),[213,10,32],[0,0,0],3,2,wf32(:,36),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,36),G0H8(1),m3h32x8(:,4),heltab2x256(:,:,104))
  call Hloop_A_Q(ntryL,G0H8(1),213,0,G1H8(7),n2h8(32))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(337)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(105),h0tab(:,105),[128,32,95],[0,0,0],3,1,wf64(:,7))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(10),m3h2x128(:,50),heltab2x256(:,:,105))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(339)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(106),h0tab(:,106),[128,32,95],[0,0,0],3,1,wf64(:,9))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(11),m3h2x128(:,51),heltab2x256(:,:,106))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(341)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(107),h0tab(:,107),[128,32,95],[0,0,0],3,1,wf64(:,11))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(12),m3h2x128(:,52),heltab2x256(:,:,107))
Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(638)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(108),h0tab(:,108),[128,5,122],[0,0,0],3,2,wf4(:,5),wf32(:,30))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(13),m3h2x128(:,53),heltab2x256(:,:,108))
  call Hloop_A_Q(ntryL,G0H128(13),128,0,G1H128(5),n2h128(27))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(639)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(109),h0tab(:,109),[128,5,122],[0,0,0],3,2,wf4(:,5),wf32(:,32))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(14),m3h2x128(:,54),heltab2x256(:,:,109))
  call Hloop_A_Q(ntryL,G0H128(14),128,0,G1H128(6),n2h128(28))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(640)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(110),h0tab(:,110),[218,5,32],[0,0,0],3,2,wf32(:,26),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,26),G0H8(1),m3h32x8(:,5),heltab2x256(:,:,110))
  call Hloop_A_Q(ntryL,G0H8(1),218,0,G1H8(11),n2h8(33))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(641)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(111),h0tab(:,111),[218,5,32],[0,0,0],3,2,wf32(:,28),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,28),G0H8(1),m3h32x8(:,6),heltab2x256(:,:,111))
  call Hloop_A_Q(ntryL,G0H8(1),218,0,G1H8(12),n2h8(34))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(345)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(112),h0tab(:,112),[128,32,95],[0,0,0],3,1,wf64(:,13))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(15),m3h2x128(:,55),heltab2x256(:,:,112))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(347)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(113),h0tab(:,113),[128,32,95],[0,0,0],3,1,wf64(:,15))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(16),m3h2x128(:,56),heltab2x256(:,:,113))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(349)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(114),h0tab(:,114),[128,32,95],[0,0,0],3,1,wf64(:,17))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(17),m3h2x128(:,57),heltab2x256(:,:,114))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(642)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(115),h0tab(:,115),[160,21,74],[0,0,0],3,3,wf4(:,8),wf8(:,11),wf8(:,12))
  call Hloop_AW_Q(ntryL,G0H256(1),wf4(:,8),G0H64(1),m3h4x64(:,7),heltab2x256(:,:,115))
  call Hloop_A_Q(ntryL,G0H64(1),160,0,G1H64(5),n2h64(25))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(61)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(116),h0tab(:,116),[170,21,64],[0,0,0],3,2,wf16(:,4),wf8(:,11))
  call Hloop_AV_Q(ntryL,G0H256(1),wf16(:,4),G0H16(1),m3h16x16(:,37),heltab2x256(:,:,116))
  call Hloop_A_Q(ntryL,G0H16(1),170,0,G1H16(34),n2h16(63))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(64)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(117),h0tab(:,117),[170,21,64],[0,0,0],3,2,wf16(:,21),wf8(:,11))
  call Hloop_AZ_Q(ntryL,G0H256(1),wf16(:,21),G0H16(1),ngZd,m3h16x16(:,38),heltab2x256(:,:,117))
  call Hloop_A_Q(ntryL,G0H16(1),170,0,G1H16(33),n2h16(64))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(643)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(118),h0tab(:,118),[181,10,64],[0,0,0],3,2,wf32(:,67),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H256(1),wf32(:,67),G0H8(1),m3h32x8(:,7),heltab2x256(:,:,118))
  call Hloop_Q_A(ntryL,G0H8(1),181,0,G1H8(13),n2h8(35))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(645)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(119),h0tab(:,119),[160,26,69],[0,0,0],3,3,wf4(:,8),wf8(:,15),wf8(:,16))
  call Hloop_AW_Q(ntryL,G0H256(1),wf4(:,8),G0H64(1),m3h4x64(:,8),heltab2x256(:,:,119))
  call Hloop_A_Q(ntryL,G0H64(1),160,0,G1H64(6),n2h64(26))
Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(71)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(120),h0tab(:,120),[170,16,69],[0,0,0],3,2,wf16(:,4),wf8(:,16))
  call Hloop_AV_Q(ntryL,G0H256(1),wf16(:,4),G0H16(1),m3h16x16(:,39),heltab2x256(:,:,120))
  call Hloop_A_Q(ntryL,G0H16(1),170,0,G1H16(36),n2h16(65))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(72)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(121),h0tab(:,121),[170,16,69],[0,0,0],3,2,wf16(:,21),wf8(:,16))
  call Hloop_AZ_Q(ntryL,G0H256(1),wf16(:,21),G0H16(1),ngZu,m3h16x16(:,40),heltab2x256(:,:,121))
  call Hloop_A_Q(ntryL,G0H16(1),170,0,G1H16(35),n2h16(66))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(646)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(122),h0tab(:,122),[229,10,16],[0,0,0],3,2,wf32(:,66),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,66),G0H8(1),m3h32x8(:,8),heltab2x256(:,:,122))
  call Hloop_A_Q(ntryL,G0H8(1),229,0,G1H8(14),n2h8(36))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(73)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(123),h0tab(:,123),[165,26,64],[0,0,0],3,2,wf16(:,8),wf8(:,15))
  call Hloop_AV_Q(ntryL,G0H256(1),wf16(:,8),G0H16(1),m3h16x16(:,41),heltab2x256(:,:,123))
  call Hloop_A_Q(ntryL,G0H16(1),165,0,G1H16(18),n2h16(67))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(74)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(124),h0tab(:,124),[165,26,64],[0,0,0],3,2,wf16(:,10),wf8(:,15))
  call Hloop_AZ_Q(ntryL,G0H256(1),wf16(:,10),G0H16(1),ngZd,m3h16x16(:,42),heltab2x256(:,:,124))
  call Hloop_A_Q(ntryL,G0H16(1),165,0,G1H16(13),n2h16(68))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(648)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(125),h0tab(:,125),[186,5,64],[0,0,0],3,2,wf32(:,68),wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H256(1),wf32(:,68),G0H8(1),m3h32x8(:,9),heltab2x256(:,:,125))
  call Hloop_Q_A(ntryL,G0H8(1),186,0,G1H8(24),n2h8(37))
Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(75)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(126),h0tab(:,126),[165,16,74],[0,0,0],3,2,wf16(:,8),wf8(:,12))
  call Hloop_AV_Q(ntryL,G0H256(1),wf16(:,8),G0H16(1),m3h16x16(:,43),heltab2x256(:,:,126))
  call Hloop_A_Q(ntryL,G0H16(1),165,0,G1H16(6),n2h16(69))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(76)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(127),h0tab(:,127),[165,16,74],[0,0,0],3,2,wf16(:,10),wf8(:,12))
  call Hloop_AZ_Q(ntryL,G0H256(1),wf16(:,10),G0H16(1),ngZu,m3h16x16(:,44),heltab2x256(:,:,127))
  call Hloop_A_Q(ntryL,G0H16(1),165,0,G1H16(5),n2h16(70))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(650)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(128),h0tab(:,128),[234,5,16],[0,0,0],3,2,wf32(:,64),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,64),G0H8(1),m3h32x8(:,10),heltab2x256(:,:,128))
  call Hloop_A_Q(ntryL,G0H8(1),234,0,G1H8(20),n2h8(38))
Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(652)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(129),h0tab(:,129),[181,10,64],[0,0,0],3,2,wf32(:,60),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H256(1),wf32(:,60),G0H8(1),m3h32x8(:,11),heltab2x256(:,:,129))
  call Hloop_Q_A(ntryL,G0H8(1),181,0,G1H8(23),n2h8(39))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(653)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(130),h0tab(:,130),[181,10,64],[0,0,0],3,2,wf32(:,62),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H256(1),wf32(:,62),G0H8(1),m3h32x8(:,12),heltab2x256(:,:,130))
  call Hloop_Q_A(ntryL,G0H8(1),181,0,G1H8(25),n2h8(40))
Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(654)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(131),h0tab(:,131),[186,5,64],[0,0,0],3,2,wf32(:,52),wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H256(1),wf32(:,52),G0H8(1),m3h32x8(:,13),heltab2x256(:,:,131))
  call Hloop_Q_A(ntryL,G0H8(1),186,0,G1H8(29),n2h8(41))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(655)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(132),h0tab(:,132),[186,5,64],[0,0,0],3,2,wf32(:,54),wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H256(1),wf32(:,54),G0H8(1),m3h32x8(:,14),heltab2x256(:,:,132))
  call Hloop_Q_A(ntryL,G0H8(1),186,0,G1H8(30),n2h8(42))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(656)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(133),h0tab(:,133),[229,10,16],[0,0,0],3,2,wf32(:,56),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,56),G0H8(1),m3h32x8(:,15),heltab2x256(:,:,133))
  call Hloop_A_Q(ntryL,G0H8(1),229,0,G1H8(35),n2h8(43))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(657)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(134),h0tab(:,134),[229,10,16],[0,0,0],3,2,wf32(:,58),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,58),G0H8(1),m3h32x8(:,16),heltab2x256(:,:,134))
  call Hloop_A_Q(ntryL,G0H8(1),229,0,G1H8(40),n2h8(44))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(351)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(135),h0tab(:,135),[175,16,64],[0,0,0],3,1,wf64(:,19))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,19),G0H4(1),m3h64x4(:,2),heltab2x256(:,:,135))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(25),n2h4(20))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(353)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(136),h0tab(:,136),[175,16,64],[0,0,0],3,1,wf64(:,21))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,21),G0H4(1),m3h64x4(:,3),heltab2x256(:,:,136))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(11),n2h4(21))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(355)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(137),h0tab(:,137),[175,16,64],[0,0,0],3,1,wf64(:,23))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,23),G0H4(1),m3h64x4(:,4),heltab2x256(:,:,137))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(4),n2h4(22))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(658)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(138),h0tab(:,138),[234,5,16],[0,0,0],3,2,wf32(:,48),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,48),G0H8(1),m3h32x8(:,17),heltab2x256(:,:,138))
  call Hloop_A_Q(ntryL,G0H8(1),234,0,G1H8(36),n2h8(45))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(659)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(139),h0tab(:,139),[234,5,16],[0,0,0],3,2,wf32(:,50),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,50),G0H8(1),m3h32x8(:,18),heltab2x256(:,:,139))
  call Hloop_A_Q(ntryL,G0H8(1),234,0,G1H8(39),n2h8(46))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(359)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(140),h0tab(:,140),[175,16,64],[0,0,0],3,1,wf64(:,25))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,25),G0H4(1),m3h64x4(:,5),heltab2x256(:,:,140))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(22),n2h4(23))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(361)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(141),h0tab(:,141),[175,16,64],[0,0,0],3,1,wf64(:,27))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,27),G0H4(1),m3h64x4(:,6),heltab2x256(:,:,141))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(9),n2h4(24))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(363)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(142),h0tab(:,142),[175,16,64],[0,0,0],3,1,wf64(:,29))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,29),G0H4(1),m3h64x4(:,7),heltab2x256(:,:,142))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(10),n2h4(25))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(78)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(143),h0tab(:,143),[128,42,85],[0,0,0],3,2,wf8(:,7),wf16(:,20))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(18),m3h2x128(:,58),heltab2x256(:,:,143))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(80)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(144),h0tab(:,144),[128,42,85],[0,0,0],3,2,wf8(:,7),wf16(:,29))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(4),m3h2x128(:,59),heltab2x256(:,:,144))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(188)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(145),h0tab(:,145),[170,21,64],[0,0,0],3,2,wf16(:,16),wf8(:,11))
  call Hloop_AV_Q(ntryL,G0H256(1),wf16(:,16),G0H16(1),m3h16x16(:,45),heltab2x256(:,:,145))
  call Hloop_A_Q(ntryL,G0H16(1),170,0,G1H16(24),n2h16(71))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(190)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(146),h0tab(:,146),[170,21,64],[0,0,0],3,2,wf16(:,73),wf8(:,11))
  call Hloop_AZ_Q(ntryL,G0H256(1),wf16(:,73),G0H16(1),ngZd,m3h16x16(:,46),heltab2x256(:,:,146))
  call Hloop_A_Q(ntryL,G0H16(1),170,0,G1H16(23),n2h16(72))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(365)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(147),h0tab(:,147),[128,32,95],[0,0,0],3,1,wf64(:,31))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(7),m3h2x128(:,60),heltab2x256(:,:,147))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(195)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(148),h0tab(:,148),[138,32,85],[0,0,0],3,2,wf8(:,4),wf16(:,20))
  call Hloop_QA_V(ntryL,G0H256(1),wf8(:,4),G0H32(7),m3h8x32(:,9),heltab2x256(:,:,148))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(196)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(149),h0tab(:,149),[138,32,85],[0,0,0],3,2,wf8(:,4),wf16(:,29))
  call Hloop_QA_V(ntryL,G0H256(1),wf8(:,4),G0H32(8),m3h8x32(:,10),heltab2x256(:,:,149))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(82)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(150),h0tab(:,150),[170,21,64],[0,0,0],3,2,wf16(:,18),wf8(:,11))
  call Hloop_AV_Q(ntryL,G0H256(1),wf16(:,18),G0H16(1),m3h16x16(:,47),heltab2x256(:,:,150))
  call Hloop_A_Q(ntryL,G0H16(1),170,0,G1H16(20),n2h16(73))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(84)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(151),h0tab(:,151),[170,21,64],[0,0,0],3,2,wf16(:,30),wf8(:,11))
  call Hloop_AZ_Q(ntryL,G0H256(1),wf16(:,30),G0H16(1),ngZd,m3h16x16(:,48),heltab2x256(:,:,151))
  call Hloop_A_Q(ntryL,G0H16(1),170,0,G1H16(7),n2h16(74))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(660)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(152),h0tab(:,152),[128,10,117],[0,0,0],3,2,wf4(:,6),wf32(:,70))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(8),m3h2x128(:,61),heltab2x256(:,:,152))
  call Hloop_A_Q(ntryL,G0H128(8),128,0,G1H128(7),n2h128(29))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(661)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(153),h0tab(:,153),[128,10,117],[0,0,0],3,2,wf4(:,6),wf32(:,72))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(9),m3h2x128(:,62),heltab2x256(:,:,153))
  call Hloop_A_Q(ntryL,G0H128(9),128,0,G1H128(8),n2h128(30))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(662)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(154),h0tab(:,154),[213,10,32],[0,0,0],3,2,wf32(:,74),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,74),G0H8(1),m3h32x8(:,19),heltab2x256(:,:,154))
  call Hloop_A_Q(ntryL,G0H8(1),213,0,G1H8(41),n2h8(47))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(663)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(155),h0tab(:,155),[213,10,32],[0,0,0],3,2,wf32(:,76),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,76),G0H8(1),m3h32x8(:,20),heltab2x256(:,:,155))
  call Hloop_A_Q(ntryL,G0H8(1),213,0,G1H8(44),n2h8(48))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(371)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(156),h0tab(:,156),[128,32,95],[0,0,0],3,1,wf64(:,33))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(13),m3h2x128(:,63),heltab2x256(:,:,156))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(373)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(157),h0tab(:,157),[128,32,95],[0,0,0],3,1,wf64(:,35))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(14),m3h2x128(:,64),heltab2x256(:,:,157))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(86)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(158),h0tab(:,158),[128,37,90],[0,0,0],3,2,wf8(:,3),wf16(:,25))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(8),m3h2x128(:,65),heltab2x256(:,:,158))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(88)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(159),h0tab(:,159),[128,37,90],[0,0,0],3,2,wf8(:,3),wf16(:,31))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(9),m3h2x128(:,66),heltab2x256(:,:,159))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(192)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(160),h0tab(:,160),[165,26,64],[0,0,0],3,2,wf16(:,11),wf8(:,15))
  call Hloop_AV_Q(ntryL,G0H256(1),wf16(:,11),G0H16(1),m3h16x16(:,49),heltab2x256(:,:,160))
  call Hloop_A_Q(ntryL,G0H16(1),165,0,G1H16(39),n2h16(75))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(194)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(161),h0tab(:,161),[165,26,64],[0,0,0],3,2,wf16(:,74),wf8(:,15))
  call Hloop_AZ_Q(ntryL,G0H256(1),wf16(:,74),G0H16(1),ngZd,m3h16x16(:,50),heltab2x256(:,:,161))
  call Hloop_A_Q(ntryL,G0H16(1),165,0,G1H16(40),n2h16(76))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(90)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(162),h0tab(:,162),[128,37,90],[0,0,0],3,2,wf8(:,3),wf16(:,27))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(19),m3h2x128(:,67),heltab2x256(:,:,162))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(92)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(163),h0tab(:,163),[128,37,90],[0,0,0],3,2,wf8(:,3),wf16(:,32))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(20),m3h2x128(:,68),heltab2x256(:,:,163))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(199)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(164),h0tab(:,164),[165,16,74],[0,0,0],3,2,wf16(:,11),wf8(:,12))
  call Hloop_AV_Q(ntryL,G0H256(1),wf16(:,11),G0H16(1),m3h16x16(:,51),heltab2x256(:,:,164))
  call Hloop_A_Q(ntryL,G0H16(1),165,0,G1H16(43),n2h16(77))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(200)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(165),h0tab(:,165),[165,16,74],[0,0,0],3,2,wf16(:,74),wf8(:,12))
  call Hloop_AZ_Q(ntryL,G0H256(1),wf16(:,74),G0H16(1),ngZu,m3h16x16(:,52),heltab2x256(:,:,165))
  call Hloop_A_Q(ntryL,G0H16(1),165,0,G1H16(44),n2h16(78))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(375)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(166),h0tab(:,166),[175,16,64],[0,0,0],3,1,wf64(:,37))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,37),G0H4(1),m3h64x4(:,8),heltab2x256(:,:,166))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(20),n2h4(26))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(664)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(167),h0tab(:,167),[181,10,64],[0,0,0],3,2,wf32(:,78),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H256(1),wf32(:,78),G0H8(1),m3h32x8(:,21),heltab2x256(:,:,167))
  call Hloop_Q_A(ntryL,G0H8(1),181,0,G1H8(17),n2h8(49))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(665)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(168),h0tab(:,168),[181,10,64],[0,0,0],3,2,wf32(:,80),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H256(1),wf32(:,80),G0H8(1),m3h32x8(:,22),heltab2x256(:,:,168))
  call Hloop_Q_A(ntryL,G0H8(1),181,0,G1H8(18),n2h8(50))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(666)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(169),h0tab(:,169),[229,10,16],[0,0,0],3,2,wf32(:,82),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,82),G0H8(1),m3h32x8(:,23),heltab2x256(:,:,169))
  call Hloop_A_Q(ntryL,G0H8(1),229,0,G1H8(15),n2h8(51))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(667)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(170),h0tab(:,170),[229,10,16],[0,0,0],3,2,wf32(:,84),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,84),G0H8(1),m3h32x8(:,24),heltab2x256(:,:,170))
  call Hloop_A_Q(ntryL,G0H8(1),229,0,G1H8(31),n2h8(52))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(381)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(171),h0tab(:,171),[175,16,64],[0,0,0],3,1,wf64(:,39))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,39),G0H4(1),m3h64x4(:,9),heltab2x256(:,:,171))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(30),n2h4(27))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(383)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(172),h0tab(:,172),[175,16,64],[0,0,0],3,1,wf64(:,41))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,41),G0H4(1),m3h64x4(:,10),heltab2x256(:,:,172))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(2),n2h4(28))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(385)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(173),h0tab(:,173),[128,32,95],[0,0,0],3,1,wf64(:,43))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(21),m3h2x128(:,69),heltab2x256(:,:,173))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(94)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(174),h0tab(:,174),[128,42,85],[0,0,0],3,2,wf8(:,7),wf16(:,23))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(22),m3h2x128(:,70),heltab2x256(:,:,174))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(96)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(175),h0tab(:,175),[128,42,85],[0,0,0],3,2,wf8(:,7),wf16(:,33))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(23),m3h2x128(:,71),heltab2x256(:,:,175))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(201)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(176),h0tab(:,176),[170,16,69],[0,0,0],3,2,wf16(:,16),wf8(:,16))
  call Hloop_AV_Q(ntryL,G0H256(1),wf16(:,16),G0H16(1),m3h16x16(:,53),heltab2x256(:,:,176))
  call Hloop_A_Q(ntryL,G0H16(1),170,0,G1H16(45),n2h16(79))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(202)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(177),h0tab(:,177),[170,16,69],[0,0,0],3,2,wf16(:,73),wf8(:,16))
  call Hloop_AZ_Q(ntryL,G0H256(1),wf16(:,73),G0H16(1),ngZu,m3h16x16(:,54),heltab2x256(:,:,177))
  call Hloop_A_Q(ntryL,G0H16(1),170,0,G1H16(48),n2h16(80))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(97)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(178),h0tab(:,178),[138,32,85],[0,0,0],3,2,wf8(:,4),wf16(:,23))
  call Hloop_QA_V(ntryL,G0H256(1),wf8(:,4),G0H32(9),m3h8x32(:,11),heltab2x256(:,:,178))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(98)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(179),h0tab(:,179),[138,32,85],[0,0,0],3,2,wf8(:,4),wf16(:,33))
  call Hloop_QA_V(ntryL,G0H256(1),wf8(:,4),G0H32(10),m3h8x32(:,12),heltab2x256(:,:,179))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(203)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(180),h0tab(:,180),[170,16,69],[0,0,0],3,2,wf16(:,18),wf8(:,16))
  call Hloop_AV_Q(ntryL,G0H256(1),wf16(:,18),G0H16(1),m3h16x16(:,55),heltab2x256(:,:,180))
  call Hloop_A_Q(ntryL,G0H16(1),170,0,G1H16(49),n2h16(81))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(204)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(181),h0tab(:,181),[170,16,69],[0,0,0],3,2,wf16(:,30),wf8(:,16))
  call Hloop_AZ_Q(ntryL,G0H256(1),wf16(:,30),G0H16(1),ngZu,m3h16x16(:,56),heltab2x256(:,:,181))
  call Hloop_A_Q(ntryL,G0H16(1),170,0,G1H16(50),n2h16(82))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(668)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(182),h0tab(:,182),[128,10,117],[0,0,0],3,2,wf4(:,6),wf32(:,86))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(24),m3h2x128(:,72),heltab2x256(:,:,182))
  call Hloop_A_Q(ntryL,G0H128(24),128,0,G1H128(9),n2h128(31))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(669)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(183),h0tab(:,183),[128,10,117],[0,0,0],3,2,wf4(:,6),wf32(:,88))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(24),m3h2x128(:,73),heltab2x256(:,:,183))
  call Hloop_A_Q(ntryL,G0H128(24),128,0,G1H128(10),n2h128(32))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(670)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(184),h0tab(:,184),[213,10,32],[0,0,0],3,2,wf32(:,90),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,90),G0H8(1),m3h32x8(:,25),heltab2x256(:,:,184))
  call Hloop_A_Q(ntryL,G0H8(1),213,0,G1H8(3),n2h8(53))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(671)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(185),h0tab(:,185),[213,10,32],[0,0,0],3,2,wf32(:,92),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,92),G0H8(1),m3h32x8(:,26),heltab2x256(:,:,185))
  call Hloop_A_Q(ntryL,G0H8(1),213,0,G1H8(10),n2h8(54))
Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(391)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(186),h0tab(:,186),[128,32,95],[0,0,0],3,1,wf64(:,45))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(24),m3h2x128(:,74),heltab2x256(:,:,186))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(393)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(187),h0tab(:,187),[128,32,95],[0,0,0],3,1,wf64(:,47))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(25),m3h2x128(:,75),heltab2x256(:,:,187))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(197)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(188),h0tab(:,188),[133,32,90],[0,0,0],3,2,wf8(:,8),wf16(:,25))
  call Hloop_QA_V(ntryL,G0H256(1),wf8(:,8),G0H32(11),m3h8x32(:,13),heltab2x256(:,:,188))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(198)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(189),h0tab(:,189),[133,32,90],[0,0,0],3,2,wf8(:,8),wf16(:,31))
  call Hloop_QA_V(ntryL,G0H256(1),wf8(:,8),G0H32(12),m3h8x32(:,14),heltab2x256(:,:,189))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(100)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(190),h0tab(:,190),[165,26,64],[0,0,0],3,2,wf16(:,14),wf8(:,15))
  call Hloop_AV_Q(ntryL,G0H256(1),wf16(:,14),G0H16(1),m3h16x16(:,57),heltab2x256(:,:,190))
  call Hloop_A_Q(ntryL,G0H16(1),165,0,G1H16(53),n2h16(83))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(102)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(191),h0tab(:,191),[165,26,64],[0,0,0],3,2,wf16(:,34),wf8(:,15))
  call Hloop_AZ_Q(ntryL,G0H256(1),wf16(:,34),G0H16(1),ngZd,m3h16x16(:,58),heltab2x256(:,:,191))
  call Hloop_A_Q(ntryL,G0H16(1),165,0,G1H16(54),n2h16(84))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(395)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(192),h0tab(:,192),[175,16,64],[0,0,0],3,1,wf64(:,49))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,49),G0H4(1),m3h64x4(:,11),heltab2x256(:,:,192))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(3),n2h4(29))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(103)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(193),h0tab(:,193),[133,32,90],[0,0,0],3,2,wf8(:,8),wf16(:,27))
  call Hloop_QA_V(ntryL,G0H256(1),wf8(:,8),G0H32(13),m3h8x32(:,15),heltab2x256(:,:,193))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(104)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(194),h0tab(:,194),[133,32,90],[0,0,0],3,2,wf8(:,8),wf16(:,32))
  call Hloop_QA_V(ntryL,G0H256(1),wf8(:,8),G0H32(14),m3h8x32(:,16),heltab2x256(:,:,194))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(205)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(195),h0tab(:,195),[165,16,74],[0,0,0],3,2,wf16(:,14),wf8(:,12))
  call Hloop_AV_Q(ntryL,G0H256(1),wf16(:,14),G0H16(1),m3h16x16(:,59),heltab2x256(:,:,195))
  call Hloop_A_Q(ntryL,G0H16(1),165,0,G1H16(55),n2h16(85))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(206)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(196),h0tab(:,196),[165,16,74],[0,0,0],3,2,wf16(:,34),wf8(:,12))
  call Hloop_AZ_Q(ntryL,G0H256(1),wf16(:,34),G0H16(1),ngZu,m3h16x16(:,60),heltab2x256(:,:,196))
  call Hloop_A_Q(ntryL,G0H16(1),165,0,G1H16(58),n2h16(86))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(672)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(197),h0tab(:,197),[181,10,64],[0,0,0],3,2,wf32(:,94),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H256(1),wf32(:,94),G0H8(1),m3h32x8(:,27),heltab2x256(:,:,197))
  call Hloop_Q_A(ntryL,G0H8(1),181,0,G1H8(21),n2h8(55))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(673)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(198),h0tab(:,198),[181,10,64],[0,0,0],3,2,wf32(:,96),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H256(1),wf32(:,96),G0H8(1),m3h32x8(:,28),heltab2x256(:,:,198))
  call Hloop_Q_A(ntryL,G0H8(1),181,0,G1H8(22),n2h8(56))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(674)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(199),h0tab(:,199),[229,10,16],[0,0,0],3,2,wf32(:,98),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,98),G0H8(1),m3h32x8(:,29),heltab2x256(:,:,199))
  call Hloop_A_Q(ntryL,G0H8(1),229,0,G1H8(37),n2h8(57))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(675)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(200),h0tab(:,200),[229,10,16],[0,0,0],3,2,wf32(:,100),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,100),G0H8(1),m3h32x8(:,30),heltab2x256(:,:,200))
  call Hloop_A_Q(ntryL,G0H8(1),229,0,G1H8(38),n2h8(58))
Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(401)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(201),h0tab(:,201),[175,16,64],[0,0,0],3,1,wf64(:,51))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,51),G0H4(1),m3h64x4(:,12),heltab2x256(:,:,201))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(31),n2h4(30))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(403)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(202),h0tab(:,202),[175,16,64],[0,0,0],3,1,wf64(:,53))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,53),G0H4(1),m3h64x4(:,13),heltab2x256(:,:,202))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(32),n2h4(31))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(676)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(203),h0tab(:,203),[128,5,122],[0,0,0],3,2,wf4(:,5),wf32(:,102))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(26),m3h2x128(:,76),heltab2x256(:,:,203))
  call Hloop_A_Q(ntryL,G0H128(26),128,0,G1H128(11),n2h128(33))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(677)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(204),h0tab(:,204),[128,5,122],[0,0,0],3,2,wf4(:,5),wf32(:,104))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(26),m3h2x128(:,77),heltab2x256(:,:,204))
  call Hloop_A_Q(ntryL,G0H128(26),128,0,G1H128(12),n2h128(34))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(678)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(205),h0tab(:,205),[218,5,32],[0,0,0],3,2,wf32(:,106),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,106),G0H8(1),m3h32x8(:,31),heltab2x256(:,:,205))
  call Hloop_A_Q(ntryL,G0H8(1),218,0,G1H8(42),n2h8(59))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(679)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(206),h0tab(:,206),[218,5,32],[0,0,0],3,2,wf32(:,108),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,108),G0H8(1),m3h32x8(:,32),heltab2x256(:,:,206))
  call Hloop_A_Q(ntryL,G0H8(1),218,0,G1H8(34),n2h8(60))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(409)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(207),h0tab(:,207),[128,32,95],[0,0,0],3,1,wf64(:,55))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(26),m3h2x128(:,78),heltab2x256(:,:,207))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(411)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(208),h0tab(:,208),[128,32,95],[0,0,0],3,1,wf64(:,57))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(27),m3h2x128(:,79),heltab2x256(:,:,208))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(680)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(209),h0tab(:,209),[186,5,64],[0,0,0],3,2,wf32(:,110),wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H256(1),wf32(:,110),G0H8(1),m3h32x8(:,33),heltab2x256(:,:,209))
  call Hloop_Q_A(ntryL,G0H8(1),186,0,G1H8(45),n2h8(61))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(681)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(210),h0tab(:,210),[186,5,64],[0,0,0],3,2,wf32(:,112),wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H256(1),wf32(:,112),G0H8(1),m3h32x8(:,34),heltab2x256(:,:,210))
  call Hloop_Q_A(ntryL,G0H8(1),186,0,G1H8(46),n2h8(62))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(682)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(211),h0tab(:,211),[234,5,16],[0,0,0],3,2,wf32(:,114),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,114),G0H8(1),m3h32x8(:,35),heltab2x256(:,:,211))
  call Hloop_A_Q(ntryL,G0H8(1),234,0,G1H8(47),n2h8(63))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(683)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(212),h0tab(:,212),[234,5,16],[0,0,0],3,2,wf32(:,116),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,116),G0H8(1),m3h32x8(:,36),heltab2x256(:,:,212))
  call Hloop_A_Q(ntryL,G0H8(1),234,0,G1H8(48),n2h8(64))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(417)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(213),h0tab(:,213),[175,16,64],[0,0,0],3,1,wf64(:,59))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,59),G0H4(1),m3h64x4(:,14),heltab2x256(:,:,213))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(33),n2h4(32))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(419)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(214),h0tab(:,214),[175,16,64],[0,0,0],3,1,wf64(:,61))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,61),G0H4(1),m3h64x4(:,15),heltab2x256(:,:,214))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(36),n2h4(33))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(684)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(215),h0tab(:,215),[128,5,122],[0,0,0],3,2,wf4(:,5),wf32(:,118))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(28),m3h2x128(:,80),heltab2x256(:,:,215))
  call Hloop_A_Q(ntryL,G0H128(28),128,0,G1H128(13),n2h128(35))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(685)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(216),h0tab(:,216),[128,5,122],[0,0,0],3,2,wf4(:,5),wf32(:,120))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(28),m3h2x128(:,81),heltab2x256(:,:,216))
  call Hloop_A_Q(ntryL,G0H128(28),128,0,G1H128(14),n2h128(36))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(686)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(217),h0tab(:,217),[218,5,32],[0,0,0],3,2,wf32(:,122),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,122),G0H8(1),m3h32x8(:,37),heltab2x256(:,:,217))
  call Hloop_A_Q(ntryL,G0H8(1),218,0,G1H8(49),n2h8(65))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(687)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(218),h0tab(:,218),[218,5,32],[0,0,0],3,2,wf32(:,124),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,124),G0H8(1),m3h32x8(:,38),heltab2x256(:,:,218))
  call Hloop_A_Q(ntryL,G0H8(1),218,0,G1H8(50),n2h8(66))
Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(425)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(219),h0tab(:,219),[128,32,95],[0,0,0],3,1,wf64(:,63))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(28),m3h2x128(:,82),heltab2x256(:,:,219))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(427)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(220),h0tab(:,220),[128,32,95],[0,0,0],3,1,wf64(:,65))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(29),m3h2x128(:,83),heltab2x256(:,:,220))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(688)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(221),h0tab(:,221),[186,5,64],[0,0,0],3,2,wf32(:,126),wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H256(1),wf32(:,126),G0H8(1),m3h32x8(:,39),heltab2x256(:,:,221))
  call Hloop_Q_A(ntryL,G0H8(1),186,0,G1H8(51),n2h8(67))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(689)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(222),h0tab(:,222),[186,5,64],[0,0,0],3,2,wf32(:,128),wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H256(1),wf32(:,128),G0H8(1),m3h32x8(:,40),heltab2x256(:,:,222))
  call Hloop_Q_A(ntryL,G0H8(1),186,0,G1H8(52),n2h8(68))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(690)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(223),h0tab(:,223),[234,5,16],[0,0,0],3,2,wf32(:,130),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,130),G0H8(1),m3h32x8(:,41),heltab2x256(:,:,223))
  call Hloop_A_Q(ntryL,G0H8(1),234,0,G1H8(53),n2h8(69))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(691)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(224),h0tab(:,224),[234,5,16],[0,0,0],3,2,wf32(:,132),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,132),G0H8(1),m3h32x8(:,42),heltab2x256(:,:,224))
  call Hloop_A_Q(ntryL,G0H8(1),234,0,G1H8(54),n2h8(70))
Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(433)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(225),h0tab(:,225),[175,16,64],[0,0,0],3,1,wf64(:,67))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,67),G0H4(1),m3h64x4(:,16),heltab2x256(:,:,225))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(15),n2h4(34))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(435)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(226),h0tab(:,226),[175,16,64],[0,0,0],3,1,wf64(:,69))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,69),G0H4(1),m3h64x4(:,17),heltab2x256(:,:,226))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(16),n2h4(35))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(124)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(227),h0tab(:,227),[128,37,90],[0,0,0],3,2,wf8(:,3),wf16(:,35))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(30),m3h2x128(:,84),heltab2x256(:,:,227))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(126)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(228),h0tab(:,228),[128,37,90],[0,0,0],3,2,wf8(:,3),wf16(:,41))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(31),m3h2x128(:,85),heltab2x256(:,:,228))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(128)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(229),h0tab(:,229),[128,37,90],[0,0,0],3,2,wf8(:,3),wf16(:,42))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(32),m3h2x128(:,86),heltab2x256(:,:,229))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(129)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(230),h0tab(:,230),[133,32,90],[0,0,0],3,2,wf8(:,8),wf16(:,35))
  call Hloop_QA_V(ntryL,G0H256(1),wf8(:,8),G0H32(15),m3h8x32(:,17),heltab2x256(:,:,230))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(130)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(231),h0tab(:,231),[133,32,90],[0,0,0],3,2,wf8(:,8),wf16(:,41))
  call Hloop_QA_V(ntryL,G0H256(1),wf8(:,8),G0H32(16),m3h8x32(:,18),heltab2x256(:,:,231))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(131)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(232),h0tab(:,232),[133,32,90],[0,0,0],3,2,wf8(:,8),wf16(:,42))
  call Hloop_QA_V(ntryL,G0H256(1),wf8(:,8),G0H32(17),m3h8x32(:,19),heltab2x256(:,:,232))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(692)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(233),h0tab(:,233),[128,5,122],[0,0,0],3,2,wf4(:,5),wf32(:,134))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(33),m3h2x128(:,87),heltab2x256(:,:,233))
  call Hloop_A_Q(ntryL,G0H128(33),128,0,G1H128(15),n2h128(37))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(693)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(234),h0tab(:,234),[128,5,122],[0,0,0],3,2,wf4(:,5),wf32(:,136))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(33),m3h2x128(:,88),heltab2x256(:,:,234))
  call Hloop_A_Q(ntryL,G0H128(33),128,0,G1H128(16),n2h128(38))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(694)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(235),h0tab(:,235),[218,5,32],[0,0,0],3,2,wf32(:,138),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,138),G0H8(1),m3h32x8(:,43),heltab2x256(:,:,235))
  call Hloop_A_Q(ntryL,G0H8(1),218,0,G1H8(55),n2h8(71))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(695)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(236),h0tab(:,236),[218,5,32],[0,0,0],3,2,wf32(:,140),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,140),G0H8(1),m3h32x8(:,44),heltab2x256(:,:,236))
  call Hloop_A_Q(ntryL,G0H8(1),218,0,G1H8(56),n2h8(72))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(441)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(237),h0tab(:,237),[128,32,95],[0,0,0],3,1,wf64(:,71))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(33),m3h2x128(:,89),heltab2x256(:,:,237))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(443)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(238),h0tab(:,238),[128,32,95],[0,0,0],3,1,wf64(:,73))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(34),m3h2x128(:,90),heltab2x256(:,:,238))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(696)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(239),h0tab(:,239),[128,5,122],[0,0,0],3,2,wf4(:,5),wf32(:,142))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(35),m3h2x128(:,91),heltab2x256(:,:,239))
  call Hloop_A_Q(ntryL,G0H128(35),128,0,G1H128(17),n2h128(39))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(697)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(240),h0tab(:,240),[218,5,32],[0,0,0],3,2,wf32(:,144),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,144),G0H8(1),m3h32x8(:,45),heltab2x256(:,:,240))
  call Hloop_A_Q(ntryL,G0H8(1),218,0,G1H8(57),n2h8(73))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(447)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(241),h0tab(:,241),[128,32,95],[0,0,0],3,1,wf64(:,75))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(35),m3h2x128(:,92),heltab2x256(:,:,241))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(450)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(242),h0tab(:,242),[128,32,95],[0,0,0],3,1,wf64(:,77))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(36),m3h2x128(:,93),heltab2x256(:,:,242))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(453)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(243),h0tab(:,243),[128,32,95],[0,0,0],3,1,wf64(:,79))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(37),m3h2x128(:,94),heltab2x256(:,:,243))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(455)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(244),h0tab(:,244),[128,32,95],[0,0,0],3,1,wf64(:,81))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(38),m3h2x128(:,95),heltab2x256(:,:,244))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(457)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(245),h0tab(:,245),[128,32,95],[0,0,0],3,1,wf64(:,83))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(39),m3h2x128(:,96),heltab2x256(:,:,245))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(460)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(246),h0tab(:,246),[128,32,95],[0,0,0],3,1,wf64(:,85))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(40),m3h2x128(:,97),heltab2x256(:,:,246))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(133)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(247),h0tab(:,247),[170,21,64],[0,0,0],3,2,wf16(:,37),wf8(:,11))
  call Hloop_AV_Q(ntryL,G0H256(1),wf16(:,37),G0H16(1),m3h16x16(:,61),heltab2x256(:,:,247))
  call Hloop_A_Q(ntryL,G0H16(1),170,0,G1H16(59),n2h16(87))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(135)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(248),h0tab(:,248),[170,21,64],[0,0,0],3,2,wf16(:,43),wf8(:,11))
  call Hloop_AZ_Q(ntryL,G0H256(1),wf16(:,43),G0H16(1),ngZd,m3h16x16(:,62),heltab2x256(:,:,248))
  call Hloop_A_Q(ntryL,G0H16(1),170,0,G1H16(60),n2h16(88))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(137)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(249),h0tab(:,249),[170,21,64],[0,0,0],3,2,wf16(:,44),wf8(:,11))
  call Hloop_AZ_Q(ntryL,G0H256(1),wf16(:,44),G0H16(1),ngZd,m3h16x16(:,63),heltab2x256(:,:,249))
  call Hloop_A_Q(ntryL,G0H16(1),170,0,G1H16(63),n2h16(89))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(139)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(250),h0tab(:,250),[170,16,69],[0,0,0],3,2,wf16(:,37),wf8(:,16))
  call Hloop_AV_Q(ntryL,G0H256(1),wf16(:,37),G0H16(1),m3h16x16(:,64),heltab2x256(:,:,250))
  call Hloop_A_Q(ntryL,G0H16(1),170,0,G1H16(64),n2h16(90))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(140)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(251),h0tab(:,251),[170,16,69],[0,0,0],3,2,wf16(:,43),wf8(:,16))
  call Hloop_AZ_Q(ntryL,G0H256(1),wf16(:,43),G0H16(1),ngZu,m3h16x16(:,65),heltab2x256(:,:,251))
  call Hloop_A_Q(ntryL,G0H16(1),170,0,G1H16(65),n2h16(91))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(138)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(252),h0tab(:,252),[170,16,69],[0,0,0],3,2,wf16(:,44),wf8(:,16))
  call Hloop_AZ_Q(ntryL,G0H256(1),wf16(:,44),G0H16(1),ngZu,m3h16x16(:,66),heltab2x256(:,:,252))
  call Hloop_A_Q(ntryL,G0H16(1),170,0,G1H16(68),n2h16(92))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(698)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(253),h0tab(:,253),[186,5,64],[0,0,0],3,2,wf32(:,155),wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H256(1),wf32(:,155),G0H8(1),m3h32x8(:,46),heltab2x256(:,:,253))
  call Hloop_Q_A(ntryL,G0H8(1),186,0,G1H8(58),n2h8(74))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(699)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(254),h0tab(:,254),[186,5,64],[0,0,0],3,2,wf32(:,157),wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H256(1),wf32(:,157),G0H8(1),m3h32x8(:,47),heltab2x256(:,:,254))
  call Hloop_Q_A(ntryL,G0H8(1),186,0,G1H8(59),n2h8(75))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(700)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(255),h0tab(:,255),[186,5,64],[0,0,0],3,2,wf32(:,159),wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H256(1),wf32(:,159),G0H8(1),m3h32x8(:,48),heltab2x256(:,:,255))
  call Hloop_Q_A(ntryL,G0H8(1),186,0,G1H8(60),n2h8(76))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(701)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(256),h0tab(:,256),[234,5,16],[0,0,0],3,2,wf32(:,161),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,161),G0H8(1),m3h32x8(:,49),heltab2x256(:,:,256))
  call Hloop_A_Q(ntryL,G0H8(1),234,0,G1H8(61),n2h8(77))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(702)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(257),h0tab(:,257),[234,5,16],[0,0,0],3,2,wf32(:,163),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,163),G0H8(1),m3h32x8(:,50),heltab2x256(:,:,257))
  call Hloop_A_Q(ntryL,G0H8(1),234,0,G1H8(62),n2h8(78))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(467)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(258),h0tab(:,258),[175,16,64],[0,0,0],3,1,wf64(:,87))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,87),G0H4(1),m3h64x4(:,18),heltab2x256(:,:,258))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(39),n2h4(36))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(469)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(259),h0tab(:,259),[175,16,64],[0,0,0],3,1,wf64(:,89))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,89),G0H4(1),m3h64x4(:,19),heltab2x256(:,:,259))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(40),n2h4(37))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(703)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(260),h0tab(:,260),[234,5,16],[0,0,0],3,2,wf32(:,165),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,165),G0H8(1),m3h32x8(:,51),heltab2x256(:,:,260))
  call Hloop_A_Q(ntryL,G0H8(1),234,0,G1H8(63),n2h8(79))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(472)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(261),h0tab(:,261),[175,16,64],[0,0,0],3,1,wf64(:,91))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,91),G0H4(1),m3h64x4(:,20),heltab2x256(:,:,261))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(41),n2h4(38))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(475)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(262),h0tab(:,262),[175,16,64],[0,0,0],3,1,wf64(:,93))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,93),G0H4(1),m3h64x4(:,21),heltab2x256(:,:,262))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(44),n2h4(39))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(478)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(263),h0tab(:,263),[175,16,64],[0,0,0],3,1,wf64(:,95))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,95),G0H4(1),m3h64x4(:,22),heltab2x256(:,:,263))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(26),n2h4(40))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(480)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(264),h0tab(:,264),[175,16,64],[0,0,0],3,1,wf64(:,97))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,97),G0H4(1),m3h64x4(:,23),heltab2x256(:,:,264))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(27),n2h4(41))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(482)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(265),h0tab(:,265),[175,16,64],[0,0,0],3,1,wf64(:,99))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,99),G0H4(1),m3h64x4(:,24),heltab2x256(:,:,265))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(46),n2h4(42))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(485)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(266),h0tab(:,266),[175,16,64],[0,0,0],3,1,wf64(:,101))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,101),G0H4(1),m3h64x4(:,25),heltab2x256(:,:,266))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(47),n2h4(43))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(487)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(267),h0tab(:,267),[128,32,95],[0,0,0],3,1,wf64(:,103))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(41),m3h2x128(:,98),heltab2x256(:,:,267))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(489)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(268),h0tab(:,268),[128,32,95],[0,0,0],3,1,wf64(:,105))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(42),m3h2x128(:,99),heltab2x256(:,:,268))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(491)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(269),h0tab(:,269),[128,32,95],[0,0,0],3,1,wf64(:,107))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(43),m3h2x128(:,100),heltab2x256(:,:,269))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(493)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(270),h0tab(:,270),[175,16,64],[0,0,0],3,1,wf64(:,109))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,109),G0H4(1),m3h64x4(:,26),heltab2x256(:,:,270))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(48),n2h4(44))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(495)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(271),h0tab(:,271),[175,16,64],[0,0,0],3,1,wf64(:,111))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,111),G0H4(1),m3h64x4(:,27),heltab2x256(:,:,271))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(51),n2h4(45))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(497)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(272),h0tab(:,272),[175,16,64],[0,0,0],3,1,wf64(:,113))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,113),G0H4(1),m3h64x4(:,28),heltab2x256(:,:,272))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(52),n2h4(46))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(499)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(273),h0tab(:,273),[128,32,95],[0,0,0],3,1,wf64(:,115))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(44),m3h2x128(:,101),heltab2x256(:,:,273))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(501)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(274),h0tab(:,274),[128,32,95],[0,0,0],3,1,wf64(:,117))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(45),m3h2x128(:,102),heltab2x256(:,:,274))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(503)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(275),h0tab(:,275),[128,32,95],[0,0,0],3,1,wf64(:,119))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(46),m3h2x128(:,103),heltab2x256(:,:,275))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(505)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(276),h0tab(:,276),[175,16,64],[0,0,0],3,1,wf64(:,121))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,121),G0H4(1),m3h64x4(:,29),heltab2x256(:,:,276))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(53),n2h4(47))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(507)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(277),h0tab(:,277),[175,16,64],[0,0,0],3,1,wf64(:,123))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,123),G0H4(1),m3h64x4(:,30),heltab2x256(:,:,277))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(54),n2h4(48))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(509)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(278),h0tab(:,278),[175,16,64],[0,0,0],3,1,wf64(:,125))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,125),G0H4(1),m3h64x4(:,31),heltab2x256(:,:,278))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(55),n2h4(49))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(160)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(279),h0tab(:,279),[128,42,85],[0,0,0],3,2,wf8(:,7),wf16(:,45))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(47),m3h2x128(:,104),heltab2x256(:,:,279))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(162)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(280),h0tab(:,280),[128,42,85],[0,0,0],3,2,wf8(:,7),wf16(:,51))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(48),m3h2x128(:,105),heltab2x256(:,:,280))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(163)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(281),h0tab(:,281),[138,32,85],[0,0,0],3,2,wf8(:,4),wf16(:,45))
  call Hloop_QA_V(ntryL,G0H256(1),wf8(:,4),G0H32(18),m3h8x32(:,20),heltab2x256(:,:,281))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(164)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(282),h0tab(:,282),[138,32,85],[0,0,0],3,2,wf8(:,4),wf16(:,51))
  call Hloop_QA_V(ntryL,G0H256(1),wf8(:,4),G0H32(19),m3h8x32(:,21),heltab2x256(:,:,282))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(704)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(283),h0tab(:,283),[128,10,117],[0,0,0],3,2,wf4(:,6),wf32(:,200))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(49),m3h2x128(:,106),heltab2x256(:,:,283))
  call Hloop_A_Q(ntryL,G0H128(49),128,0,G1H128(18),n2h128(40))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(705)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(284),h0tab(:,284),[128,10,117],[0,0,0],3,2,wf4(:,6),wf32(:,202))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(49),m3h2x128(:,107),heltab2x256(:,:,284))
  call Hloop_A_Q(ntryL,G0H128(49),128,0,G1H128(19),n2h128(41))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(706)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(285),h0tab(:,285),[213,10,32],[0,0,0],3,2,wf32(:,204),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,204),G0H8(1),m3h32x8(:,52),heltab2x256(:,:,285))
  call Hloop_A_Q(ntryL,G0H8(1),213,0,G1H8(64),n2h8(80))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(707)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(286),h0tab(:,286),[213,10,32],[0,0,0],3,2,wf32(:,206),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,206),G0H8(1),m3h32x8(:,53),heltab2x256(:,:,286))
  call Hloop_A_Q(ntryL,G0H8(1),213,0,G1H8(65),n2h8(81))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(515)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(287),h0tab(:,287),[128,32,95],[0,0,0],3,1,wf64(:,127))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(49),m3h2x128(:,108),heltab2x256(:,:,287))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(517)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(288),h0tab(:,288),[128,32,95],[0,0,0],3,1,wf64(:,129))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(50),m3h2x128(:,109),heltab2x256(:,:,288))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(708)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(289),h0tab(:,289),[128,10,117],[0,0,0],3,2,wf4(:,6),wf32(:,208))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(51),m3h2x128(:,110),heltab2x256(:,:,289))
  call Hloop_A_Q(ntryL,G0H128(51),128,0,G1H128(20),n2h128(42))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(709)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(290),h0tab(:,290),[213,10,32],[0,0,0],3,2,wf32(:,210),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,210),G0H8(1),m3h32x8(:,54),heltab2x256(:,:,290))
  call Hloop_A_Q(ntryL,G0H8(1),213,0,G1H8(66),n2h8(82))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(167)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(291),h0tab(:,291),[128,42,85],[0,0,0],3,2,wf8(:,7),wf16(:,52))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(51),m3h2x128(:,111),heltab2x256(:,:,291))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(166)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(292),h0tab(:,292),[138,32,85],[0,0,0],3,2,wf8(:,4),wf16(:,52))
  call Hloop_QA_V(ntryL,G0H256(1),wf8(:,4),G0H32(20),m3h8x32(:,22),heltab2x256(:,:,292))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(521)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(293),h0tab(:,293),[128,32,95],[0,0,0],3,1,wf64(:,131))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(52),m3h2x128(:,112),heltab2x256(:,:,293))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(524)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(294),h0tab(:,294),[128,32,95],[0,0,0],3,1,wf64(:,133))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(53),m3h2x128(:,113),heltab2x256(:,:,294))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(527)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(295),h0tab(:,295),[128,32,95],[0,0,0],3,1,wf64(:,135))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(54),m3h2x128(:,114),heltab2x256(:,:,295))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(529)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(296),h0tab(:,296),[128,32,95],[0,0,0],3,1,wf64(:,137))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(55),m3h2x128(:,115),heltab2x256(:,:,296))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(531)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(297),h0tab(:,297),[128,32,95],[0,0,0],3,1,wf64(:,139))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(56),m3h2x128(:,116),heltab2x256(:,:,297))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(534)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(298),h0tab(:,298),[128,32,95],[0,0,0],3,1,wf64(:,141))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(57),m3h2x128(:,117),heltab2x256(:,:,298))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(710)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(299),h0tab(:,299),[181,10,64],[0,0,0],3,2,wf32(:,221),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H256(1),wf32(:,221),G0H8(1),m3h32x8(:,55),heltab2x256(:,:,299))
  call Hloop_Q_A(ntryL,G0H8(1),181,0,G1H8(67),n2h8(83))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(171)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(300),h0tab(:,300),[165,26,64],[0,0,0],3,2,wf16(:,47),wf8(:,15))
  call Hloop_AV_Q(ntryL,G0H256(1),wf16(:,47),G0H16(1),m3h16x16(:,67),heltab2x256(:,:,300))
  call Hloop_A_Q(ntryL,G0H16(1),165,0,G1H16(69),n2h16(93))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(173)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(301),h0tab(:,301),[165,26,64],[0,0,0],3,2,wf16(:,54),wf8(:,15))
  call Hloop_AZ_Q(ntryL,G0H256(1),wf16(:,54),G0H16(1),ngZd,m3h16x16(:,68),heltab2x256(:,:,301))
  call Hloop_A_Q(ntryL,G0H16(1),165,0,G1H16(70),n2h16(94))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(174)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(302),h0tab(:,302),[165,16,74],[0,0,0],3,2,wf16(:,47),wf8(:,12))
  call Hloop_AV_Q(ntryL,G0H256(1),wf16(:,47),G0H16(1),m3h16x16(:,69),heltab2x256(:,:,302))
  call Hloop_A_Q(ntryL,G0H16(1),165,0,G1H16(73),n2h16(95))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(175)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(303),h0tab(:,303),[165,16,74],[0,0,0],3,2,wf16(:,54),wf8(:,12))
  call Hloop_AZ_Q(ntryL,G0H256(1),wf16(:,54),G0H16(1),ngZu,m3h16x16(:,70),heltab2x256(:,:,303))
  call Hloop_A_Q(ntryL,G0H16(1),165,0,G1H16(74),n2h16(96))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(711)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(304),h0tab(:,304),[181,10,64],[0,0,0],3,2,wf32(:,223),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H256(1),wf32(:,223),G0H8(1),m3h32x8(:,56),heltab2x256(:,:,304))
  call Hloop_Q_A(ntryL,G0H8(1),181,0,G1H8(68),n2h8(84))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(712)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(305),h0tab(:,305),[181,10,64],[0,0,0],3,2,wf32(:,225),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H256(1),wf32(:,225),G0H8(1),m3h32x8(:,57),heltab2x256(:,:,305))
  call Hloop_Q_A(ntryL,G0H8(1),181,0,G1H8(69),n2h8(85))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(713)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(306),h0tab(:,306),[229,10,16],[0,0,0],3,2,wf32(:,227),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,227),G0H8(1),m3h32x8(:,58),heltab2x256(:,:,306))
  call Hloop_A_Q(ntryL,G0H8(1),229,0,G1H8(70),n2h8(86))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(714)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(307),h0tab(:,307),[229,10,16],[0,0,0],3,2,wf32(:,229),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,229),G0H8(1),m3h32x8(:,59),heltab2x256(:,:,307))
  call Hloop_A_Q(ntryL,G0H8(1),229,0,G1H8(71),n2h8(87))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(541)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(308),h0tab(:,308),[175,16,64],[0,0,0],3,1,wf64(:,143))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,143),G0H4(1),m3h64x4(:,32),heltab2x256(:,:,308))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(56),n2h4(50))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(543)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(309),h0tab(:,309),[175,16,64],[0,0,0],3,1,wf64(:,145))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,145),G0H4(1),m3h64x4(:,33),heltab2x256(:,:,309))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(57),n2h4(51))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(715)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(310),h0tab(:,310),[229,10,16],[0,0,0],3,2,wf32(:,231),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),wf32(:,231),G0H8(1),m3h32x8(:,60),heltab2x256(:,:,310))
  call Hloop_A_Q(ntryL,G0H8(1),229,0,G1H8(72),n2h8(88))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(176)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(311),h0tab(:,311),[165,26,64],[0,0,0],3,2,wf16(:,53),wf8(:,15))
  call Hloop_AZ_Q(ntryL,G0H256(1),wf16(:,53),G0H16(1),ngZd,m3h16x16(:,71),heltab2x256(:,:,311))
  call Hloop_A_Q(ntryL,G0H16(1),165,0,G1H16(75),n2h16(97))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(169)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(312),h0tab(:,312),[165,16,74],[0,0,0],3,2,wf16(:,53),wf8(:,12))
  call Hloop_AZ_Q(ntryL,G0H256(1),wf16(:,53),G0H16(1),ngZu,m3h16x16(:,72),heltab2x256(:,:,312))
  call Hloop_A_Q(ntryL,G0H16(1),165,0,G1H16(78),n2h16(98))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(546)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(313),h0tab(:,313),[175,16,64],[0,0,0],3,1,wf64(:,147))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,147),G0H4(1),m3h64x4(:,34),heltab2x256(:,:,313))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(58),n2h4(52))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(549)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(314),h0tab(:,314),[175,16,64],[0,0,0],3,1,wf64(:,149))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,149),G0H4(1),m3h64x4(:,35),heltab2x256(:,:,314))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(59),n2h4(53))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(552)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(315),h0tab(:,315),[175,16,64],[0,0,0],3,1,wf64(:,151))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,151),G0H4(1),m3h64x4(:,36),heltab2x256(:,:,315))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(60),n2h4(54))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(554)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(316),h0tab(:,316),[175,16,64],[0,0,0],3,1,wf64(:,153))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,153),G0H4(1),m3h64x4(:,37),heltab2x256(:,:,316))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(61),n2h4(55))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(556)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(317),h0tab(:,317),[175,16,64],[0,0,0],3,1,wf64(:,155))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,155),G0H4(1),m3h64x4(:,38),heltab2x256(:,:,317))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(62),n2h4(56))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(559)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(318),h0tab(:,318),[175,16,64],[0,0,0],3,1,wf64(:,157))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,157),G0H4(1),m3h64x4(:,39),heltab2x256(:,:,318))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(63),n2h4(57))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(561)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(319),h0tab(:,319),[128,32,95],[0,0,0],3,1,wf64(:,159))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(58),m3h2x128(:,118),heltab2x256(:,:,319))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(563)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(320),h0tab(:,320),[175,16,64],[0,0,0],3,1,wf64(:,161))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,161),G0H4(1),m3h64x4(:,40),heltab2x256(:,:,320))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(64),n2h4(58))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(565)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(321),h0tab(:,321),[128,32,95],[0,0,0],3,1,wf64(:,163))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(59),m3h2x128(:,119),heltab2x256(:,:,321))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(567)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(322),h0tab(:,322),[175,16,64],[0,0,0],3,1,wf64(:,165))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,165),G0H4(1),m3h64x4(:,41),heltab2x256(:,:,322))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(65),n2h4(59))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(569)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(323),h0tab(:,323),[128,32,95],[0,0,0],3,1,wf64(:,167))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(60),m3h2x128(:,120),heltab2x256(:,:,323))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(571)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(324),h0tab(:,324),[128,32,95],[0,0,0],3,1,wf64(:,169))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(61),m3h2x128(:,121),heltab2x256(:,:,324))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(573)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(325),h0tab(:,325),[175,16,64],[0,0,0],3,1,wf64(:,171))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,171),G0H4(1),m3h64x4(:,42),heltab2x256(:,:,325))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(66),n2h4(60))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(575)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(326),h0tab(:,326),[175,16,64],[0,0,0],3,1,wf64(:,173))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,173),G0H4(1),m3h64x4(:,43),heltab2x256(:,:,326))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(67),n2h4(61))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(577)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(327),h0tab(:,327),[128,32,95],[0,0,0],3,1,wf64(:,175))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(62),m3h2x128(:,122),heltab2x256(:,:,327))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(579)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(328),h0tab(:,328),[128,32,95],[0,0,0],3,1,wf64(:,177))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(63),m3h2x128(:,123),heltab2x256(:,:,328))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(581)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(329),h0tab(:,329),[175,16,64],[0,0,0],3,1,wf64(:,179))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,179),G0H4(1),m3h64x4(:,44),heltab2x256(:,:,329))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(68),n2h4(62))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(583)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(330),h0tab(:,330),[175,16,64],[0,0,0],3,1,wf64(:,181))
  call Hloop_AW_Q(ntryL,G0H256(1),wf64(:,181),G0H4(1),m3h64x4(:,45),heltab2x256(:,:,330))
  call Hloop_A_Q(ntryL,G0H4(1),175,0,G1H4(69),n2h4(63))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(585)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(331),h0tab(:,331),[128,32,95],[0,0,0],3,1,wf64(:,183))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(64),m3h2x128(:,124),heltab2x256(:,:,331))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(587)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(332),h0tab(:,332),[128,32,95],[0,0,0],3,1,wf64(:,185))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(65),m3h2x128(:,125),heltab2x256(:,:,332))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(589)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(333),h0tab(:,333),[128,32,95],[0,0,0],3,1,wf64(:,187))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(66),m3h2x128(:,126),heltab2x256(:,:,333))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(591)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(334),h0tab(:,334),[128,32,95],[0,0,0],3,1,wf64(:,189))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(67),m3h2x128(:,127),heltab2x256(:,:,334))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(593)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(335),h0tab(:,335),[128,32,95],[0,0,0],3,1,wf64(:,191))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(68),m3h2x128(:,128),heltab2x256(:,:,335))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(595)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(336),h0tab(:,336),[128,32,95],[0,0,0],3,1,wf64(:,193))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(69),m3h2x128(:,129),heltab2x256(:,:,336))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(597)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(337),h0tab(:,337),[128,32,95],[0,0,0],3,1,wf64(:,195))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(70),m3h2x128(:,130),heltab2x256(:,:,337))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(599)
call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(338),h0tab(:,338),[128,32,95],[0,0,0],3,1,wf64(:,197))
  call Hloop_QA_V(ntryL,G0H256(1),ex8(:),G0H128(71),m3h2x128(:,131),heltab2x256(:,:,338))



end subroutine vamp_1

end module ol_vamp_1_ppllnnjj_vbs_nexnmxemucdxsx_2_/**/REALKIND
