
! **********************************************************************
module ol_tables_storage_ppllnnjj_vbs_nenmexmxuxcxds_2_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  ! helicity tables for the 1-loop recursion
integer(intkind2), save :: h0tab(256,430)
integer(intkind2), save :: heltab2x2(2,2,43)
integer(intkind2), save :: heltab2x4(2,4,63)
integer(intkind2), save :: heltab2x8(2,8,94)
integer(intkind2), save :: heltab2x16(2,16,144)
integer(intkind2), save :: heltab2x32(2,32,174)
integer(intkind2), save :: heltab2x64(2,64,81)
integer(intkind2), save :: heltab2x128(2,128,133)
integer(intkind2), save :: heltab2x256(2,256,430)


  ! number of helicity states for openloops recursion steps  
integer(intkind2), save :: m0h(430)
integer(intkind2), save :: m3h2x1(3,43)
integer(intkind2), save :: m3h4x1(3,58)
integer(intkind2), save :: m3h8x1(3,36)
integer(intkind2), save :: m3h16x1(3,126)
integer(intkind2), save :: m3h32x1(3,40)
integer(intkind2), save :: m3h64x1(3,55)
integer(intkind2), save :: m3h2x2(3,5)
integer(intkind2), save :: m3h4x2(3,38)
integer(intkind2), save :: m3h8x2(3,2)
integer(intkind2), save :: m3h16x2(3,72)
integer(intkind2), save :: m3h2x4(3,20)
integer(intkind2), save :: m3h4x4(3,8)
integer(intkind2), save :: m3h8x4(3,4)
integer(intkind2), save :: m3h64x4(3,55)
integer(intkind2), save :: m3h2x8(3,8)
integer(intkind2), save :: m3h4x8(3,18)
integer(intkind2), save :: m3h8x8(3,2)
integer(intkind2), save :: m3h32x8(3,120)
integer(intkind2), save :: m3h2x16(3,40)
integer(intkind2), save :: m3h4x16(3,24)
integer(intkind2), save :: m3h8x16(3,18)
integer(intkind2), save :: m3h16x16(3,72)
integer(intkind2), save :: m3h4x32(3,42)
integer(intkind2), save :: m3h8x32(3,42)
integer(intkind2), save :: m3h2x64(3,73)
integer(intkind2), save :: m3h4x64(3,8)
integer(intkind2), save :: m3h2x128(3,133)

integer(intkind2), save :: n2h1(281)
integer(intkind2), save :: n2h2(108)
integer(intkind2), save :: n2h4(75)
integer(intkind2), save :: n2h8(132)
integer(intkind2), save :: n2h16(134)
integer(intkind2), save :: n2h32(82)
integer(intkind2), save :: n2h64(81)
integer(intkind2), save :: n2h128(42)


contains

!**********************************************************************
subroutine HOL_m3_init()
!**********************************************************************
! initialize m3 arrays for helicity summation
!**********************************************************************
  use KIND_TYPES, only: REALKIND, intkind2
  
m3h2x1(1,:)=2
m3h2x1(2,:)=1
m3h2x1(3,:)=2
m3h4x1(1,:)=4
m3h4x1(2,:)=1
m3h4x1(3,:)=4
m3h8x1(1,:)=8
m3h8x1(2,:)=1
m3h8x1(3,:)=8
m3h16x1(1,:)=16
m3h16x1(2,:)=1
m3h16x1(3,:)=16
m3h32x1(1,:)=32
m3h32x1(2,:)=1
m3h32x1(3,:)=32
m3h64x1(1,:)=64
m3h64x1(2,:)=1
m3h64x1(3,:)=64
m3h2x2(1,:)=2
m3h2x2(2,:)=2
m3h2x2(3,:)=4
m3h4x2(1,:)=4
m3h4x2(2,:)=2
m3h4x2(3,:)=8
m3h8x2(1,:)=8
m3h8x2(2,:)=2
m3h8x2(3,:)=16
m3h16x2(1,:)=16
m3h16x2(2,:)=2
m3h16x2(3,:)=32
m3h2x4(1,:)=2
m3h2x4(2,:)=4
m3h2x4(3,:)=8
m3h4x4(1,:)=4
m3h4x4(2,:)=4
m3h4x4(3,:)=16
m3h8x4(1,:)=8
m3h8x4(2,:)=4
m3h8x4(3,:)=32
m3h64x4(1,:)=64
m3h64x4(2,:)=4
m3h64x4(3,:)=256
m3h2x8(1,:)=2
m3h2x8(2,:)=8
m3h2x8(3,:)=16
m3h4x8(1,:)=4
m3h4x8(2,:)=8
m3h4x8(3,:)=32
m3h8x8(1,:)=8
m3h8x8(2,:)=8
m3h8x8(3,:)=64
m3h32x8(1,:)=32
m3h32x8(2,:)=8
m3h32x8(3,:)=256
m3h2x16(1,:)=2
m3h2x16(2,:)=16
m3h2x16(3,:)=32
m3h4x16(1,:)=4
m3h4x16(2,:)=16
m3h4x16(3,:)=64
m3h8x16(1,:)=8
m3h8x16(2,:)=16
m3h8x16(3,:)=128
m3h16x16(1,:)=16
m3h16x16(2,:)=16
m3h16x16(3,:)=256
m3h4x32(1,:)=4
m3h4x32(2,:)=32
m3h4x32(3,:)=128
m3h8x32(1,:)=8
m3h8x32(2,:)=32
m3h8x32(3,:)=256
m3h2x64(1,:)=2
m3h2x64(2,:)=64
m3h2x64(3,:)=128
m3h4x64(1,:)=4
m3h4x64(2,:)=64
m3h4x64(3,:)=256
m3h2x128(1,:)=2
m3h2x128(2,:)=128
m3h2x128(3,:)=256

n2h1(:)=1
n2h2(:)=2
n2h4(:)=4
n2h8(:)=8
n2h16(:)=16
n2h32(:)=32
n2h64(:)=64
n2h128(:)=128


end subroutine HOL_m3_init

!**********************************************************************

end module ol_tables_storage_ppllnnjj_vbs_nenmexmxuxcxds_2_/**/REALKIND 

! **********************************************************************
module ol_tensor_sum_storage_ppllnnjj_vbs_nenmexmxuxcxds_2_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol, hcl, met
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  type(met), save :: M2L1R1

  ! Declarations of loop wave function tensors

  type(hol), save :: G0H1(1)
  type(hol), save :: G1H1(1)
  type(hol), save :: G1H2(20)
  type(hol), save :: G2H2(86)
  type(hol), save :: G0H4(1)
  type(hol), save :: G1H4(79)
  type(hol), save :: G2H4(14)
  type(hol), save :: G0H8(19)
  type(hol), save :: G1H8(72)
  type(hol), save :: G2H8(10)
  type(hol), save :: G0H16(1)
  type(hol), save :: G1H16(108)
  type(hol), save :: G2H16(18)
  type(hol), save :: G0H32(20)
  type(hol), save :: G1H32(100)
  type(hol), save :: G2H32(20)
  type(hol), save :: G0H64(1)
  type(hol), save :: G1H64(55)
  type(hol), save :: G0H128(73)
  type(hol), save :: G1H128(20)
  type(hol), save :: G0H256(1)
  type(hcl), save, dimension(192) :: G0tensor
  type(hcl), save, dimension(130) :: G1tensor
  type(hcl), save, dimension(277) :: G2tensor



  ! Declarations for on-the-fly tensor reduction 
type (basis),      save :: RedBasis(58)
type (redset4),    save :: RedSet_4(30)
type (redset5),    save :: RedSet_5(4)
integer, save :: mass2set(0:1,1)
integer, save :: mass3set(0:2,1)
integer, save :: mass4set(0:3,1)
integer, save :: mass5set(0:4,1)



  ! Declarations for TI calls

  integer, save :: momenta_1(2)
  integer, save :: momenta_2(2)
  integer, save :: momenta_3(2)
  integer, save :: momenta_4(2)
  integer, save :: momenta_5(2)
  integer, save :: momenta_6(2)
  integer, save :: momenta_7(2)
  integer, save :: momenta_8(2)
  integer, save :: momenta_9(2)
  integer, save :: momenta_10(2)
  integer, save :: momenta_11(2)
  integer, save :: momenta_12(2)
  integer, save :: momenta_13(2)
  integer, save :: momenta_14(2)
  integer, save :: momenta_15(2)
  integer, save :: momenta_16(2)
  integer, save :: momenta_17(2)
  integer, save :: momenta_18(2)
  integer, save :: momenta_19(3)
  integer, save :: momenta_20(3)
  integer, save :: momenta_21(3)
  integer, save :: momenta_22(3)
  integer, save :: momenta_23(3)
  integer, save :: momenta_24(3)
  integer, save :: momenta_25(3)
  integer, save :: momenta_26(3)
  integer, save :: momenta_27(3)
  integer, save :: momenta_28(3)
  integer, save :: momenta_29(3)
  integer, save :: momenta_30(3)
  integer, save :: momenta_31(3)
  integer, save :: momenta_32(3)
  integer, save :: momenta_33(3)
  integer, save :: momenta_34(3)
  integer, save :: momenta_35(3)
  integer, save :: momenta_36(3)
  integer, save :: momenta_37(3)
  integer, save :: momenta_38(3)
  integer, save :: momenta_39(3)
  integer, save :: momenta_40(3)
  integer, save :: momenta_41(3)
  integer, save :: momenta_42(3)
  integer, save :: momenta_43(3)
  integer, save :: momenta_44(3)
  integer, save :: momenta_45(3)
  integer, save :: momenta_46(3)
  integer, save :: momenta_47(3)
  integer, save :: momenta_48(3)
  integer, save :: momenta_49(3)
  integer, save :: momenta_50(3)
  integer, save :: momenta_51(3)
  integer, save :: momenta_52(3)
  integer, save :: momenta_53(3)
  integer, save :: momenta_54(3)
  integer, save :: momenta_55(3)
  integer, save :: momenta_56(3)
  integer, save :: momenta_57(3)
  integer, save :: momenta_58(3)
  integer, save :: momenta_59(3)
  integer, save :: momenta_60(3)
  integer, save :: momenta_61(3)
  integer, save :: momenta_62(3)
  integer, save :: momenta_63(3)
  integer, save :: momenta_64(3)
  integer, save :: momenta_65(3)
  integer, save :: momenta_66(3)
  integer, save :: momenta_67(4)
  integer, save :: momenta_68(4)
  integer, save :: momenta_69(4)
  integer, save :: momenta_70(4)
  integer, save :: momenta_71(4)
  integer, save :: momenta_72(4)
  integer, save :: momenta_73(4)
  integer, save :: momenta_74(4)
  integer, save :: momenta_75(4)
  integer, save :: momenta_76(4)
  integer, save :: momenta_77(4)
  integer, save :: momenta_78(4)
  integer, save :: momenta_79(4)
  integer, save :: momenta_80(4)
  integer, save :: momenta_81(4)
  integer, save :: momenta_82(4)
  integer, save :: momenta_83(4)
  integer, save :: momenta_84(4)
  integer, save :: momenta_85(4)
  integer, save :: momenta_86(4)
  integer, save :: momenta_87(4)
  integer, save :: momenta_88(4)
  integer, save :: momenta_89(4)
  integer, save :: momenta_90(4)
  integer, save :: momenta_91(4)
  integer, save :: momenta_92(4)
  integer, save :: momenta_93(5)
  integer, save :: momenta_94(5)
  integer, save :: momenta_95(5)
  integer, save :: momenta_96(5)

  integer, save :: masses2_1(2)
  integer, save :: masses2_2(3)
  integer, save :: masses2_3(4)
  integer, save :: masses2_4(5)

type(scalarbox), save :: ScalarBoxes(19)

integer, save :: sbarray_1(5)
integer, save :: sbarray_2(5)
integer, save :: sbarray_3(5)
integer, save :: sbarray_4(5)

  type(hcl), save, dimension(92) :: T0sum
  type(hcl), save, dimension(4) :: T1sum


  contains
  
!**********************************************************************
subroutine HOL_memory_allocation()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none
  
    call hol_allocation(4,1,4,1,G0H1,1)
  call hol_allocation(4,5,4,1,G1H1,1)
  call hol_allocation(4,5,4,2,G1H2,20)
  call hol_allocation(4,15,4,2,G2H2,86)
  call hol_allocation(4,1,4,4,G0H4,1)
  call hol_allocation(4,5,4,4,G1H4,79)
  call hol_allocation(4,15,4,4,G2H4,14)
  call hol_allocation(4,1,4,8,G0H8,19)
  call hol_allocation(4,5,4,8,G1H8,72)
  call hol_allocation(4,15,4,8,G2H8,10)
  call hol_allocation(4,1,4,16,G0H16,1)
  call hol_allocation(4,5,4,16,G1H16,108)
  call hol_allocation(4,15,4,16,G2H16,18)
  call hol_allocation(4,1,4,32,G0H32,20)
  call hol_allocation(4,5,4,32,G1H32,100)
  call hol_allocation(4,15,4,32,G2H32,20)
  call hol_allocation(4,1,4,64,G0H64,1)
  call hol_allocation(4,5,4,64,G1H64,55)
  call hol_allocation(4,1,4,128,G0H128,73)
  call hol_allocation(4,5,4,128,G1H128,20)
  call hol_allocation(4,1,4,256,G0H256,1)


end subroutine HOL_memory_allocation


!**********************************************************************
subroutine HOL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_deallocation
  implicit none
  integer,   intent(in)    :: dmode
  
    call hol_deallocation(G0H1,1,dmode)
  call hol_deallocation(G1H1,1,dmode)
  call hol_deallocation(G1H2,20,dmode)
  call hol_deallocation(G2H2,86,dmode)
  call hol_deallocation(G0H4,1,dmode)
  call hol_deallocation(G1H4,79,dmode)
  call hol_deallocation(G2H4,14,dmode)
  call hol_deallocation(G0H8,19,dmode)
  call hol_deallocation(G1H8,72,dmode)
  call hol_deallocation(G2H8,10,dmode)
  call hol_deallocation(G0H16,1,dmode)
  call hol_deallocation(G1H16,108,dmode)
  call hol_deallocation(G2H16,18,dmode)
  call hol_deallocation(G0H32,20,dmode)
  call hol_deallocation(G1H32,100,dmode)
  call hol_deallocation(G2H32,20,dmode)
  call hol_deallocation(G0H64,1,dmode)
  call hol_deallocation(G1H64,55,dmode)
  call hol_deallocation(G0H128,73,dmode)
  call hol_deallocation(G1H128,20,dmode)
  call hol_deallocation(G0H256,1,dmode)


end subroutine HOL_memory_deallocation_/**/REALKIND

!**********************************************************************
subroutine HCL_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none
  
  call hcl_allocation(1,G0tensor, 192)
call hcl_allocation(5,G1tensor, 130)
call hcl_allocation(15,G2tensor, 277)


end subroutine HCL_memory_allocation


!**********************************************************************
subroutine HCL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! deallocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_deallocation
  implicit none
  integer,   intent(in)    :: dmode
  
  call hcl_deallocation(G0tensor, 192,dmode)
call hcl_deallocation(G1tensor, 130,dmode)
call hcl_deallocation(G2tensor, 277,dmode)

  call hcl_deallocation(T0sum,92,dmode)
call hcl_deallocation(T1sum,4,dmode)


end subroutine HCL_memory_deallocation_/**/REALKIND


!**********************************************************************
subroutine Tsum_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none
  
  call hcl_allocation(1,T0sum,92)
call hcl_allocation(5,T1sum,4)


end subroutine Tsum_memory_allocation


#ifdef PRECISION_dp
subroutine max_point(r) &
    & bind(c,name="ol_f_max_point_ppllnnjj_vbs_nenmexmxuxcxds_2")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 5
end subroutine max_point

subroutine tensor_rank(r) &
    & bind(c,name="ol_f_tensor_rank_ppllnnjj_vbs_nenmexmxuxcxds_2")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 1
end subroutine tensor_rank
#endif

subroutine reset_tensor_sum()
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  use ol_parameters_init_/**/REALKIND, only: init_hcl
  implicit none
  integer :: i

  do i = 1,92
    call init_hcl(T0sum(i))
  end do
  do i = 1,4
    call init_hcl(T1sum(i))
  end do

end subroutine reset_tensor_sum


subroutine scale_one_tsum(tsum, spow)
  use ol_parameters_decl_/**/REALKIND, only: scalefactor
  implicit none
  complex(REALKIND), intent(inout) :: tsum(:)
  integer, intent(in) :: spow ! rank 0 scale power
  real(REALKIND) :: sfinv, sfac
  integer :: sz
  sfinv = 1/scalefactor
  sfac = scalefactor**spow
  sz = size(tsum)
  tsum(1) = sfac*tsum(1)
  if (sz > 1) then ! rank 1
    sfac = sfac*sfinv
    tsum(2:5) = sfac*tsum(2:5)
  end if
  if (sz > 5) then ! rank 2
    sfac = sfac*sfinv
    tsum(6:15) = sfac*tsum(6:15)
  end if
  if (sz > 15) then ! rank 3
    sfac = sfac*sfinv
    tsum(16:35) = sfac*tsum(16:35)
  end if
  if (sz > 35) then ! rank 4
    sfac = sfac*sfinv
    tsum(36:70) = sfac*tsum(36:70)
  end if
  if (sz > 70) then ! rank 5
    sfac = sfac*sfinv
    tsum(71:126) = sfac*tsum(71:126)
  end if
  if (sz > 126) then ! rank 6
    sfac = sfac*sfinv
    tsum(127:210) = sfac*tsum(127:210)
  end if
  if (sz > 210) then ! rank 7
    sfac = sfac*sfinv
    tsum(211:330) = sfac*tsum(211:330)
  end if
end subroutine scale_one_tsum


subroutine scale_tensor_sum()
  implicit none
  call scale_one_tsum(T1sum(1)%cmp, -2)
  call scale_one_tsum(T1sum(2)%cmp, -2)
  call scale_one_tsum(T1sum(3)%cmp, -2)
  call scale_one_tsum(T1sum(4)%cmp, -2)
  call scale_one_tsum(T0sum(1)%cmp, -4)
  call scale_one_tsum(T0sum(2)%cmp, -4)
  call scale_one_tsum(T0sum(3)%cmp, -4)
  call scale_one_tsum(T0sum(4)%cmp, -4)
  call scale_one_tsum(T0sum(5)%cmp, -4)
  call scale_one_tsum(T0sum(6)%cmp, -4)
  call scale_one_tsum(T0sum(7)%cmp, -4)
  call scale_one_tsum(T0sum(8)%cmp, -4)
  call scale_one_tsum(T0sum(9)%cmp, -4)
  call scale_one_tsum(T0sum(10)%cmp, -4)
  call scale_one_tsum(T0sum(11)%cmp, -4)
  call scale_one_tsum(T0sum(12)%cmp, -4)
  call scale_one_tsum(T0sum(13)%cmp, -4)
  call scale_one_tsum(T0sum(14)%cmp, -4)
  call scale_one_tsum(T0sum(15)%cmp, -4)
  call scale_one_tsum(T0sum(16)%cmp, -4)
  call scale_one_tsum(T0sum(17)%cmp, -4)
  call scale_one_tsum(T0sum(18)%cmp, -4)
  call scale_one_tsum(T0sum(19)%cmp, -4)
  call scale_one_tsum(T0sum(20)%cmp, -4)
  call scale_one_tsum(T0sum(21)%cmp, -4)
  call scale_one_tsum(T0sum(22)%cmp, -4)
  call scale_one_tsum(T0sum(23)%cmp, -4)
  call scale_one_tsum(T0sum(24)%cmp, -4)
  call scale_one_tsum(T0sum(25)%cmp, -4)
  call scale_one_tsum(T0sum(26)%cmp, -4)
  call scale_one_tsum(T0sum(27)%cmp, -6)
  call scale_one_tsum(T0sum(28)%cmp, -6)
  call scale_one_tsum(T0sum(29)%cmp, -6)
  call scale_one_tsum(T0sum(30)%cmp, -6)
  call scale_one_tsum(T0sum(31)%cmp, -6)
  call scale_one_tsum(T0sum(32)%cmp, -6)
  call scale_one_tsum(T0sum(33)%cmp, -6)
  call scale_one_tsum(T0sum(34)%cmp, -6)
  call scale_one_tsum(T0sum(35)%cmp, -6)
  call scale_one_tsum(T0sum(36)%cmp, -6)
  call scale_one_tsum(T0sum(37)%cmp, -6)
  call scale_one_tsum(T0sum(38)%cmp, -6)
  call scale_one_tsum(T0sum(39)%cmp, -6)
  call scale_one_tsum(T0sum(40)%cmp, -6)
  call scale_one_tsum(T0sum(41)%cmp, -6)
  call scale_one_tsum(T0sum(42)%cmp, -6)
  call scale_one_tsum(T0sum(43)%cmp, -6)
  call scale_one_tsum(T0sum(44)%cmp, -6)
  call scale_one_tsum(T0sum(45)%cmp, -6)
  call scale_one_tsum(T0sum(46)%cmp, -6)
  call scale_one_tsum(T0sum(47)%cmp, -6)
  call scale_one_tsum(T0sum(48)%cmp, -6)
  call scale_one_tsum(T0sum(49)%cmp, -6)
  call scale_one_tsum(T0sum(50)%cmp, -6)
  call scale_one_tsum(T0sum(51)%cmp, -6)
  call scale_one_tsum(T0sum(52)%cmp, -6)
  call scale_one_tsum(T0sum(53)%cmp, -6)
  call scale_one_tsum(T0sum(54)%cmp, -6)
  call scale_one_tsum(T0sum(55)%cmp, -6)
  call scale_one_tsum(T0sum(56)%cmp, -6)
  call scale_one_tsum(T0sum(57)%cmp, -6)
  call scale_one_tsum(T0sum(58)%cmp, -6)
  call scale_one_tsum(T0sum(59)%cmp, -6)
  call scale_one_tsum(T0sum(60)%cmp, -6)
  call scale_one_tsum(T0sum(61)%cmp, -6)
  call scale_one_tsum(T0sum(62)%cmp, -6)
  call scale_one_tsum(T0sum(63)%cmp, -6)
  call scale_one_tsum(T0sum(64)%cmp, -6)
  call scale_one_tsum(T0sum(65)%cmp, -6)
  call scale_one_tsum(T0sum(66)%cmp, -6)
  call scale_one_tsum(T0sum(67)%cmp, -6)
  call scale_one_tsum(T0sum(68)%cmp, -6)
  call scale_one_tsum(T0sum(69)%cmp, -6)
  call scale_one_tsum(T0sum(70)%cmp, -6)
  call scale_one_tsum(T0sum(71)%cmp, -6)
  call scale_one_tsum(T0sum(72)%cmp, -6)
  call scale_one_tsum(T0sum(73)%cmp, -6)
  call scale_one_tsum(T0sum(74)%cmp, -6)
  call scale_one_tsum(T0sum(75)%cmp, -8)
  call scale_one_tsum(T0sum(76)%cmp, -8)
  call scale_one_tsum(T0sum(77)%cmp, -8)
  call scale_one_tsum(T0sum(78)%cmp, -8)
  call scale_one_tsum(T0sum(79)%cmp, -8)
  call scale_one_tsum(T0sum(80)%cmp, -8)
  call scale_one_tsum(T0sum(81)%cmp, -8)
  call scale_one_tsum(T0sum(82)%cmp, -8)
  call scale_one_tsum(T0sum(83)%cmp, -8)
  call scale_one_tsum(T0sum(84)%cmp, -8)
  call scale_one_tsum(T0sum(85)%cmp, -8)
  call scale_one_tsum(T0sum(86)%cmp, -8)
  call scale_one_tsum(T0sum(87)%cmp, -8)
  call scale_one_tsum(T0sum(88)%cmp, -8)
  call scale_one_tsum(T0sum(89)%cmp, -8)
  call scale_one_tsum(T0sum(90)%cmp, -8)
  call scale_one_tsum(T0sum(91)%cmp, -8)
  call scale_one_tsum(T0sum(92)%cmp, -8)

end subroutine scale_tensor_sum

! **********************************************************************
subroutine set_integral_masses_and_momenta()
! **********************************************************************

  use ol_parameters_decl_/**/REALKIND
  momenta_1 = [ 128, 127 ]
  momenta_2 = [ 133, 122 ]
  momenta_3 = [ 138, 117 ]
  momenta_4 = [ 160, 95 ]
  momenta_5 = [ 165, 90 ]
  momenta_6 = [ 170, 85 ]
  momenta_7 = [ 175, 80 ]
  momenta_8 = [ 181, 74 ]
  momenta_9 = [ 186, 69 ]
  momenta_10 = [ 191, 64 ]
  momenta_11 = [ 213, 42 ]
  momenta_12 = [ 218, 37 ]
  momenta_13 = [ 223, 32 ]
  momenta_14 = [ 229, 26 ]
  momenta_15 = [ 234, 21 ]
  momenta_16 = [ 239, 16 ]
  momenta_17 = [ 245, 10 ]
  momenta_18 = [ 250, 5 ]
  momenta_19 = [ 128, 5, 122 ]
  momenta_20 = [ 128, 10, 117 ]
  momenta_21 = [ 128, 32, 95 ]
  momenta_22 = [ 128, 37, 90 ]
  momenta_23 = [ 128, 42, 85 ]
  momenta_24 = [ 128, 85, 42 ]
  momenta_25 = [ 128, 90, 37 ]
  momenta_26 = [ 128, 95, 32 ]
  momenta_27 = [ 133, 32, 90 ]
  momenta_28 = [ 133, 42, 80 ]
  momenta_29 = [ 133, 80, 42 ]
  momenta_30 = [ 133, 90, 32 ]
  momenta_31 = [ 138, 32, 85 ]
  momenta_32 = [ 138, 37, 80 ]
  momenta_33 = [ 138, 80, 37 ]
  momenta_34 = [ 138, 85, 32 ]
  momenta_35 = [ 160, 5, 90 ]
  momenta_36 = [ 160, 10, 85 ]
  momenta_37 = [ 160, 21, 74 ]
  momenta_38 = [ 160, 26, 69 ]
  momenta_39 = [ 160, 69, 26 ]
  momenta_40 = [ 160, 74, 21 ]
  momenta_41 = [ 160, 85, 10 ]
  momenta_42 = [ 160, 90, 5 ]
  momenta_43 = [ 165, 10, 80 ]
  momenta_44 = [ 165, 16, 74 ]
  momenta_45 = [ 165, 26, 64 ]
  momenta_46 = [ 165, 64, 26 ]
  momenta_47 = [ 165, 74, 16 ]
  momenta_48 = [ 165, 80, 10 ]
  momenta_49 = [ 170, 5, 80 ]
  momenta_50 = [ 170, 16, 69 ]
  momenta_51 = [ 170, 21, 64 ]
  momenta_52 = [ 170, 64, 21 ]
  momenta_53 = [ 170, 69, 16 ]
  momenta_54 = [ 170, 80, 5 ]
  momenta_55 = [ 175, 16, 64 ]
  momenta_56 = [ 175, 64, 16 ]
  momenta_57 = [ 181, 10, 64 ]
  momenta_58 = [ 181, 64, 10 ]
  momenta_59 = [ 186, 5, 64 ]
  momenta_60 = [ 213, 10, 32 ]
  momenta_61 = [ 213, 32, 10 ]
  momenta_62 = [ 218, 5, 32 ]
  momenta_63 = [ 218, 32, 5 ]
  momenta_64 = [ 229, 10, 16 ]
  momenta_65 = [ 229, 16, 10 ]
  momenta_66 = [ 234, 5, 16 ]
  momenta_67 = [ 128, 5, 80, 42 ]
  momenta_68 = [ 128, 5, 90, 32 ]
  momenta_69 = [ 128, 10, 80, 37 ]
  momenta_70 = [ 128, 10, 85, 32 ]
  momenta_71 = [ 128, 32, 5, 90 ]
  momenta_72 = [ 128, 32, 10, 85 ]
  momenta_73 = [ 128, 85, 10, 32 ]
  momenta_74 = [ 128, 90, 5, 32 ]
  momenta_75 = [ 133, 32, 10, 80 ]
  momenta_76 = [ 133, 80, 10, 32 ]
  momenta_77 = [ 138, 32, 5, 80 ]
  momenta_78 = [ 138, 80, 5, 32 ]
  momenta_79 = [ 160, 5, 16, 74 ]
  momenta_80 = [ 160, 5, 64, 26 ]
  momenta_81 = [ 160, 5, 80, 10 ]
  momenta_82 = [ 160, 10, 16, 69 ]
  momenta_83 = [ 160, 10, 64, 21 ]
  momenta_84 = [ 160, 10, 80, 5 ]
  momenta_85 = [ 160, 21, 64, 10 ]
  momenta_86 = [ 160, 69, 16, 10 ]
  momenta_87 = [ 165, 10, 16, 64 ]
  momenta_88 = [ 165, 10, 64, 16 ]
  momenta_89 = [ 165, 16, 64, 10 ]
  momenta_90 = [ 165, 64, 16, 10 ]
  momenta_91 = [ 170, 5, 16, 64 ]
  momenta_92 = [ 170, 5, 64, 16 ]
  momenta_93 = [ 128, 5, 80, 10, 32 ]
  momenta_94 = [ 128, 10, 80, 5, 32 ]
  momenta_95 = [ 160, 5, 16, 64, 10 ]
  momenta_96 = [ 160, 5, 64, 16, 10 ]

  masses2_1 = [ 0, 0 ]
  masses2_2 = [ 0, 0, 0 ]
  masses2_3 = [ 0, 0, 0, 0 ]
  masses2_4 = [ 0, 0, 0, 0, 0 ]


end subroutine  set_integral_masses_and_momenta

! **********************************************************************
subroutine integrate_tensor_sum(M2out)
! **********************************************************************
  use ol_external_ppllnnjj_vbs_nenmexmxuxcxds_2, only: channel_number_ppllnnjj_vbs_nenmexmxuxcxds_2
  use ol_parameters_decl_/**/REALKIND ! only: ZERO, masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: a_switch
#endif
  use ol_parameters_init_/**/DREALKIND, only: channel_on
  use ol_parameters_init_/**/REALKIND, only: init_met, add_met, met_to_real
  use ol_loop_routines_/**/REALKIND, only: TI_call_OL
  implicit none
  real(REALKIND), intent(out) :: M2out
  type(met) :: M2
  call channel_on(channel_number_ppllnnjj_vbs_nenmexmxuxcxds_2)
  call init_met(M2)

sbarray_1 = [1, 2, 3, 4, 5]
sbarray_2 = [6, 7, 8, 9, 10]
sbarray_3 = [11, 12, 13, 14, 15]
sbarray_4 = [16, 17, 13, 18, 19]


#ifdef LOOPSQUARED
  if (a_switch == 1 .or. a_switch == 7) then
#endif
  call TI_call_OL(0,0, momenta_69, masses2_3, T0sum(1), M2,[4], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_67, masses2_3, T0sum(2), M2,[9], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_91, masses2_3, T0sum(3), M2,[15], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_79, masses2_3, T0sum(4), M2,[14], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_92, masses2_3, T0sum(5), M2,[19], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_80, masses2_3, T0sum(6), M2,[18], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_84, masses2_3, T0sum(7), M2,[5], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_78, masses2_3, T0sum(8), M2,[1], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_74, masses2_3, T0sum(9), M2,[2], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_70, masses2_3, T0sum(10), M2,[3], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_81, masses2_3, T0sum(11), M2,[13], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_76, masses2_3, T0sum(12), M2,[6], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_73, masses2_3, T0sum(13), M2,[7], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_68, masses2_3, T0sum(14), M2,[8], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_89, masses2_3, T0sum(15), M2,[11], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_85, masses2_3, T0sum(16), M2,[12], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_90, masses2_3, T0sum(17), M2,[16], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_86, masses2_3, T0sum(18), M2,[17], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_75, masses2_3, T0sum(19), M2,[6], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_77, masses2_3, T0sum(20), M2,[1], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_72, masses2_3, T0sum(21), M2,[7], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_71, masses2_3, T0sum(22), M2,[2], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_83, masses2_3, T0sum(23), M2,[12], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_82, masses2_3, T0sum(24), M2,[17], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_87, masses2_3, T0sum(25), M2,[16], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_88, masses2_3, T0sum(26), M2,[11], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_66, masses2_2, T0sum(27), M2)
  call TI_call_OL(0,0, momenta_59, masses2_2, T0sum(28), M2)
  call TI_call_OL(0,0, momenta_36, masses2_2, T0sum(29), M2)
  call TI_call_OL(0,0, momenta_20, masses2_2, T0sum(30), M2)
  call TI_call_OL(0,0, momenta_43, masses2_2, T0sum(31), M2)
  call TI_call_OL(0,0, momenta_35, masses2_2, T0sum(32), M2)
  call TI_call_OL(0,0, momenta_19, masses2_2, T0sum(33), M2)
  call TI_call_OL(0,0, momenta_49, masses2_2, T0sum(34), M2)
  call TI_call_OL(0,0, momenta_44, masses2_2, T0sum(35), M2)
  call TI_call_OL(0,0, momenta_37, masses2_2, T0sum(36), M2)
  call TI_call_OL(0,0, momenta_46, masses2_2, T0sum(37), M2)
  call TI_call_OL(0,0, momenta_39, masses2_2, T0sum(38), M2)
  call TI_call_OL(0,0, momenta_33, masses2_2, T0sum(39), M2)
  call TI_call_OL(0,0, momenta_25, masses2_2, T0sum(40), M2)
  call TI_call_OL(0,0, momenta_29, masses2_2, T0sum(41), M2)
  call TI_call_OL(0,0, momenta_24, masses2_2, T0sum(42), M2)
  call TI_call_OL(0,0, momenta_55, masses2_2, T0sum(43), M2)
  call TI_call_OL(0,0, momenta_51, masses2_2, T0sum(44), M2)
  call TI_call_OL(0,0, momenta_56, masses2_2, T0sum(45), M2)
  call TI_call_OL(0,0, momenta_53, masses2_2, T0sum(46), M2)
  call TI_call_OL(0,0, momenta_61, masses2_2, T0sum(47), M2)
  call TI_call_OL(0,0, momenta_27, masses2_2, T0sum(48), M2)
  call TI_call_OL(0,0, momenta_63, masses2_2, T0sum(49), M2)
  call TI_call_OL(0,0, momenta_31, masses2_2, T0sum(50), M2)
  call TI_call_OL(0,0, momenta_21, masses2_2, T0sum(51), M2)
  call TI_call_OL(0,0, momenta_57, masses2_2, T0sum(52), M2)
  call TI_call_OL(0,0, momenta_64, masses2_2, T0sum(53), M2)
  call TI_call_OL(0,0, momenta_54, masses2_2, T0sum(54), M2)
  call TI_call_OL(0,0, momenta_42, masses2_2, T0sum(55), M2)
  call TI_call_OL(0,0, momenta_62, masses2_2, T0sum(56), M2)
  call TI_call_OL(0,0, momenta_34, masses2_2, T0sum(57), M2)
  call TI_call_OL(0,0, momenta_26, masses2_2, T0sum(58), M2)
  call TI_call_OL(0,0, momenta_48, masses2_2, T0sum(59), M2)
  call TI_call_OL(0,0, momenta_41, masses2_2, T0sum(60), M2)
  call TI_call_OL(0,0, momenta_60, masses2_2, T0sum(61), M2)
  call TI_call_OL(0,0, momenta_30, masses2_2, T0sum(62), M2)
  call TI_call_OL(0,0, momenta_58, masses2_2, T0sum(63), M2)
  call TI_call_OL(0,0, momenta_65, masses2_2, T0sum(64), M2)
  call TI_call_OL(0,0, momenta_28, masses2_2, T0sum(65), M2)
  call TI_call_OL(0,0, momenta_32, masses2_2, T0sum(66), M2)
  call TI_call_OL(0,0, momenta_23, masses2_2, T0sum(67), M2)
  call TI_call_OL(0,0, momenta_22, masses2_2, T0sum(68), M2)
  call TI_call_OL(0,0, momenta_52, masses2_2, T0sum(69), M2)
  call TI_call_OL(0,0, momenta_40, masses2_2, T0sum(70), M2)
  call TI_call_OL(0,0, momenta_50, masses2_2, T0sum(71), M2)
  call TI_call_OL(0,0, momenta_38, masses2_2, T0sum(72), M2)
  call TI_call_OL(0,0, momenta_45, masses2_2, T0sum(73), M2)
  call TI_call_OL(0,0, momenta_47, masses2_2, T0sum(74), M2)
  call TI_call_OL(0,0, momenta_18, masses2_1, T0sum(75), M2)
  call TI_call_OL(0,0, momenta_16, masses2_1, T0sum(76), M2)
  call TI_call_OL(0,0, momenta_15, masses2_1, T0sum(77), M2)
  call TI_call_OL(0,0, momenta_10, masses2_1, T0sum(78), M2)
  call TI_call_OL(0,0, momenta_9, masses2_1, T0sum(79), M2)
  call TI_call_OL(0,0, momenta_17, masses2_1, T0sum(80), M2)
  call TI_call_OL(0,0, momenta_6, masses2_1, T0sum(81), M2)
  call TI_call_OL(0,0, momenta_4, masses2_1, T0sum(82), M2)
  call TI_call_OL(0,0, momenta_3, masses2_1, T0sum(83), M2)
  call TI_call_OL(0,0, momenta_1, masses2_1, T0sum(84), M2)
  call TI_call_OL(0,0, momenta_7, masses2_1, T0sum(85), M2)
  call TI_call_OL(0,0, momenta_5, masses2_1, T0sum(86), M2)
  call TI_call_OL(0,0, momenta_2, masses2_1, T0sum(87), M2)
  call TI_call_OL(0,0, momenta_8, masses2_1, T0sum(88), M2)
  call TI_call_OL(0,0, momenta_14, masses2_1, T0sum(89), M2)
  call TI_call_OL(0,0, momenta_12, masses2_1, T0sum(90), M2)
  call TI_call_OL(0,0, momenta_11, masses2_1, T0sum(91), M2)
  call TI_call_OL(0,0, momenta_13, masses2_1, T0sum(92), M2)

  call TI_call_OL(0,1, momenta_94, masses2_4, T1sum(1), M2,sbarray_1, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_93, masses2_4, T1sum(2), M2,sbarray_2, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_95, masses2_4, T1sum(3), M2,sbarray_3, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_96, masses2_4, T1sum(4), M2,sbarray_4, ScalarBoxes(:))

  call add_met(M2,M2L1R1)

#ifdef LOOPSQUARED
  end if
#endif

  call met_to_real(M2out,M2)
  
#ifdef PRECISION_dp
  call HOL_memory_deallocation_/**/REALKIND(1)
  call HCL_memory_deallocation_/**/REALKIND(1)
#endif

end subroutine integrate_tensor_sum

end module ol_tensor_sum_storage_ppllnnjj_vbs_nenmexmxuxcxds_2_/**/REALKIND
