
module ol_colourmatrix_ppllnnjj_vbs_nexnmxemucdxsx_2_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(38,1), K2(1,1), KL(1,1)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [   9]
  K1( 2,:) = [   0]
  K1( 3,:) = [   0]
  K1( 4,:) = [   0]
  K1( 5,:) = [   0]
  K1( 6,:) = [   0]
  K1( 7,:) = [   0]
  K1( 8,:) = [   0]
  K1( 9,:) = [   0]
  K1(10,:) = [   0]
  K1(11,:) = [   0]
  K1(12,:) = [   0]
  K1(13,:) = [   0]
  K1(14,:) = [   0]
  K1(15,:) = [   0]
  K1(16,:) = [  12]
  K1(17,:) = [   0]
  K1(18,:) = [   0]
  K1(19,:) = [   0]
  K1(20,:) = [   0]
  K1(21,:) = [   0]
  K1(22,:) = [  12]
  K1(23,:) = [   0]
  K1(24,:) = [   0]
  K1(25,:) = [   0]
  K1(26,:) = [   0]
  K1(27,:) = [ -12]
  K1(28,:) = [   0]
  K1(29,:) = [  12]
  K1(30,:) = [   0]
  K1(31,:) = [   0]
  K1(32,:) = [   0]
  K1(33,:) = [   0]
  K1(34,:) = [   0]
  K1(35,:) = [ -12]
  K1(36,:) = [   0]
  K1(37,:) = [  12]
  K1(38,:) = [   0]

  K2(1,:) = [ 9]

  KL(1,:) = [ 9]

  end subroutine colourmatrix_init
end module ol_colourmatrix_ppllnnjj_vbs_nexnmxemucdxsx_2_/**/REALKIND



module ol_forced_parameters_ppllnnjj_vbs_nexnmxemucdxsx_2_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (MM /= 0) write(*,101) 'MM = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppllnnjj_vbs_nexnmxemucdxsx_2_/**/REALKIND
! **********************************************************************
module ol_loop_storage_ppllnnjj_vbs_nexnmxemucdxsx_2_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2  
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  
#ifdef PRECISION_dp
  integer(intkind1), save :: ntry = 1, ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types 
  ! the following are flags for memory allocation of the hol coefficients in dp or qp 
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer(intkind2), parameter :: nheltot = 256 ! number of helicity configurations
  integer(intkind2), save :: nhel = 256 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(256) ! physical helicity states
#endif

  complex(REALKIND), save :: den(771)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2), ex7(2), ex8(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,12), wf8(8,80), wf16(16,142), wf32(32,304), wf64(64,221), wf256(256,439)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(57), c(11)

  !below the colour vector for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(1,256)

end module ol_loop_storage_ppllnnjj_vbs_nexnmxemucdxsx_2_/**/REALKIND






! **********************************************************************
module ol_loop_ppllnnjj_vbs_nexnmxemucdxsx_2_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2  
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppllnnjj_vbs_nexnmxemucdxsx_2_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (CI*eQED**6)/(8._/**/REALKIND*sw**6)
    f( 2) = (CI*eQED**6)/(4._/**/REALKIND*sw**6)
    f( 3) = (CI*cw**2*eQED**6)/(4._/**/REALKIND*sw**6)
    f( 4) = (CI*countertermnorm*eQED**6*gQCD**2)/(8._/**/REALKIND*sw**6)
    f( 5) = (CI*countertermnorm*ctVqq*eQED**6*gQCD**2)/(8._/**/REALKIND*sw**6)
    f( 6) = (CI*countertermnorm*ctVqq*eQED**6*gQCD**2)/(4._/**/REALKIND*sw**6)
    f( 7) = (CI*countertermnorm*ctVsc*eQED**6*gQCD**2)/(8._/**/REALKIND*sw**6)
    f( 8) = (CI*countertermnorm*ctVsc*eQED**6*gQCD**2)/(4._/**/REALKIND*sw**6)
    f( 9) = (CI*countertermnorm*ctVqq*cw**2*eQED**6*gQCD**2)/(4._/**/REALKIND*sw**6)
    f(10) = (CI*countertermnorm*ctVsc*cw**2*eQED**6*gQCD**2)/(4._/**/REALKIND*sw**6)
    f(11) = (CI*eQED**6*MW**2)/(4._/**/REALKIND*sw**6)
    f(12) = (CI*countertermnorm*ctVqq*eQED**6*gQCD**2*MW**2)/(4._/**/REALKIND*sw**6)
    f(13) = (CI*countertermnorm*ctVsc*eQED**6*gQCD**2*MW**2)/(4._/**/REALKIND*sw**6)
    f(14) = (CI*cw*eQED**6)/(4._/**/REALKIND*sw**5)
    f(15) = (CI*countertermnorm*cw*eQED**6*gQCD**2)/(4._/**/REALKIND*sw**5)
    f(16) = (CI*countertermnorm*ctVcc*cw*eQED**6*gQCD**2)/(4._/**/REALKIND*sw**5)
    f(17) = (CI*countertermnorm*ctVqq*cw*eQED**6*gQCD**2)/(4._/**/REALKIND*sw**5)
    f(18) = (CI*countertermnorm*ctVsc*cw*eQED**6*gQCD**2)/(4._/**/REALKIND*sw**5)
    f(19) = (CI*eQED**6)/(36._/**/REALKIND*sw**4)
    f(20) = (CI*eQED**6)/(18._/**/REALKIND*sw**4)
    f(21) = (CI*eQED**6)/(12._/**/REALKIND*sw**4)
    f(22) = (CI*eQED**6)/(9._/**/REALKIND*sw**4)
    f(23) = (CI*eQED**6)/(6._/**/REALKIND*sw**4)
    f(24) = (CI*eQED**6)/(4._/**/REALKIND*sw**4)
    f(25) = (CI*countertermnorm*eQED**6*gQCD**2)/(36._/**/REALKIND*sw**4)
    f(26) = (CI*countertermnorm*eQED**6*gQCD**2)/(18._/**/REALKIND*sw**4)
    f(27) = (CI*countertermnorm*eQED**6*gQCD**2)/(12._/**/REALKIND*sw**4)
    f(28) = (CI*countertermnorm*eQED**6*gQCD**2)/(9._/**/REALKIND*sw**4)
    f(29) = (CI*countertermnorm*eQED**6*gQCD**2)/(6._/**/REALKIND*sw**4)
    f(30) = (CI*countertermnorm*eQED**6*gQCD**2)/(4._/**/REALKIND*sw**4)
    f(31) = (CI*countertermnorm*ctVcc*eQED**6*gQCD**2)/(18._/**/REALKIND*sw**4)
    f(32) = (CI*countertermnorm*ctVcc*eQED**6*gQCD**2)/(9._/**/REALKIND*sw**4)
    f(33) = (CI*countertermnorm*ctVcc*eQED**6*gQCD**2)/(6._/**/REALKIND*sw**4)
    f(34) = (CI*countertermnorm*ctVcc*eQED**6*gQCD**2)/(4._/**/REALKIND*sw**4)
    f(35) = (CI*countertermnorm*ctVqq*eQED**6*gQCD**2)/(36._/**/REALKIND*sw**4)
    f(36) = (CI*countertermnorm*ctVqq*eQED**6*gQCD**2)/(18._/**/REALKIND*sw**4)
    f(37) = (CI*countertermnorm*ctVqq*eQED**6*gQCD**2)/(12._/**/REALKIND*sw**4)
    f(38) = (CI*countertermnorm*ctVqq*eQED**6*gQCD**2)/(9._/**/REALKIND*sw**4)
    f(39) = (CI*countertermnorm*ctVqq*eQED**6*gQCD**2)/(6._/**/REALKIND*sw**4)
    f(40) = (CI*countertermnorm*ctVqq*eQED**6*gQCD**2)/(4._/**/REALKIND*sw**4)
    f(41) = (CI*countertermnorm*ctVsc*eQED**6*gQCD**2)/(36._/**/REALKIND*sw**4)
    f(42) = (CI*countertermnorm*ctVsc*eQED**6*gQCD**2)/(18._/**/REALKIND*sw**4)
    f(43) = (CI*countertermnorm*ctVsc*eQED**6*gQCD**2)/(12._/**/REALKIND*sw**4)
    f(44) = (CI*countertermnorm*ctVsc*eQED**6*gQCD**2)/(9._/**/REALKIND*sw**4)
    f(45) = (CI*countertermnorm*ctVsc*eQED**6*gQCD**2)/(6._/**/REALKIND*sw**4)
    f(46) = (CI*countertermnorm*ctVsc*eQED**6*gQCD**2)/(4._/**/REALKIND*sw**4)
    f(47) = (eQED**6*gQCD**2*integralnorm*SwB)/(sw**6*8._/**/REALKIND)
    f(48) = (eQED**6*gQCD**2*integralnorm*SwB)/(sw**6*4._/**/REALKIND)
    f(49) = (cw**2*eQED**6*gQCD**2*integralnorm*SwB)/(sw**6*4._/**/REALKIND)
    f(50) = (eQED**6*gQCD**2*integralnorm*MW**2*SwB)/(sw**6*4._/**/REALKIND)
    f(51) = (cw*eQED**6*gQCD**2*integralnorm*SwB)/(sw**5*4._/**/REALKIND)
    f(52) = (eQED**6*gQCD**2*integralnorm*SwB)/(sw**4*36._/**/REALKIND)
    f(53) = (eQED**6*gQCD**2*integralnorm*SwB)/(sw**4*18._/**/REALKIND)
    f(54) = (eQED**6*gQCD**2*integralnorm*SwB)/(sw**4*12._/**/REALKIND)
    f(55) = (eQED**6*gQCD**2*integralnorm*SwB)/(sw**4*9._/**/REALKIND)
    f(56) = (eQED**6*gQCD**2*integralnorm*SwB)/(sw**4*6._/**/REALKIND)
    f(57) = (eQED**6*gQCD**2*integralnorm*SwB)/(sw**4*4._/**/REALKIND)

  c = [ 4*f(47), 4*f(48), 4*f(49), 4*f(50), 4*f(51), 4*f(52), 4*f(53), 4*f(54), 4*f(55), 4*f(56), 4*f(57) ]
  c = (1._/**/REALKIND / 3) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,5) - MW2)+L(6,5))
  den(2) = 1 /((L(5,10) - MW2)+L(6,10))
  den(3) = 1 /((L(5,80) - MW2)+L(6,80))
  den(4) = 1 /((L(5,160) - MW2)+L(6,160))
  den(9) = 1 /((L(5,85) - MH2)+L(6,85))
  den(12) = 1 /((L(5,85))+L(6,85))
  den(15) = 1 /((L(5,85) - MZ2)+L(6,85))
  den(20) = 1 /((L(5,165) - MH2)+L(6,165))
  den(23) = 1 /((L(5,165))+L(6,165))
  den(26) = 1 /((L(5,165) - MZ2)+L(6,165))
  den(29) = 1 /((L(5,37))+L(6,37))
  den(31) = 1 /((L(5,138))+L(6,138))
  den(35) = 1 /((L(5,90))+L(6,90))
  den(38) = 1 /((L(5,90) - MZ2)+L(6,90))
  den(41) = 1 /((L(5,42))+L(6,42))
  den(43) = 1 /((L(5,133))+L(6,133))
  den(53) = 1 /((L(5,21))+L(6,21))
  den(55) = 1 /((L(5,74))+L(6,74))
  den(59) = 1 /((L(5,170))+L(6,170))
  den(62) = 1 /((L(5,170) - MZ2)+L(6,170))
  den(65) = 1 /((L(5,26))+L(6,26))
  den(67) = 1 /((L(5,69))+L(6,69))
  den(105) = 1 /((L(5,82))+L(6,82))
  den(109) = 1 /((L(5,162))+L(6,162))
  den(113) = 1 /((L(5,88))+L(6,88))
  den(116) = 1 /((L(5,168))+L(6,168))
  den(141) = 1 /((L(5,81))+L(6,81))
  den(145) = 1 /((L(5,161))+L(6,161))
  den(149) = 1 /((L(5,84))+L(6,84))
  den(152) = 1 /((L(5,164))+L(6,164))
  den(207) = 1 /((L(5,218))+L(6,218))
  den(212) = 1 /((L(5,122))+L(6,122))
  den(217) = 1 /((L(5,213))+L(6,213))
  den(222) = 1 /((L(5,117))+L(6,117))
  den(237) = 1 /((L(5,234))+L(6,234))
  den(242) = 1 /((L(5,186))+L(6,186))
  den(247) = 1 /((L(5,229))+L(6,229))
  den(252) = 1 /((L(5,181))+L(6,181))
  den(331) = 1 /((L(5,95) - MW2)+L(6,95))
  den(334) = 1 /((L(5,175) - MW2)+L(6,175))
  den(342) = 1 /((L(5,90) - MH2)+L(6,90))
  den(356) = 1 /((L(5,170) - MH2)+L(6,170))
  den(448) = 1 /((L(5,87))+L(6,87))
  den(451) = 1 /((L(5,93))+L(6,93))
  den(473) = 1 /((L(5,167))+L(6,167))
  den(476) = 1 /((L(5,173))+L(6,173))
  den(522) = 1 /((L(5,91))+L(6,91))
  den(525) = 1 /((L(5,94))+L(6,94))
  den(547) = 1 /((L(5,171))+L(6,171))
  den(550) = 1 /((L(5,174))+L(6,174))

  ! denominators
  den(5) = den(1)*den(2)*den(3)
  den(6) = den(4)*den(5)
  den(7) = den(1)*den(3)
  den(8) = den(2)*den(4)
  den(10) = den(7)*den(9)
  den(11) = den(8)*den(10)
  den(13) = den(7)*den(12)
  den(14) = den(8)*den(13)
  den(16) = den(7)*den(15)
  den(17) = den(8)*den(16)
  den(18) = den(1)*den(4)
  den(19) = den(2)*den(3)
  den(21) = den(18)*den(20)
  den(22) = den(19)*den(21)
  den(24) = den(18)*den(23)
  den(25) = den(19)*den(24)
  den(27) = den(18)*den(26)
  den(28) = den(19)*den(27)
  den(30) = den(1)*den(29)
  den(32) = den(2)*den(31)
  den(33) = den(3)*den(30)
  den(34) = den(32)*den(33)
  den(36) = den(19)*den(35)
  den(37) = den(30)*den(36)
  den(39) = den(19)*den(38)
  den(40) = den(30)*den(39)
  den(42) = den(2)*den(41)
  den(44) = den(1)*den(43)
  den(45) = den(3)*den(42)
  den(46) = den(44)*den(45)
  den(47) = den(36)*den(44)
  den(48) = den(39)*den(44)
  den(49) = den(13)*den(42)
  den(50) = den(16)*den(42)
  den(51) = den(13)*den(32)
  den(52) = den(16)*den(32)
  den(54) = den(1)*den(53)
  den(56) = den(2)*den(55)
  den(57) = den(4)*den(54)
  den(58) = den(56)*den(57)
  den(60) = den(8)*den(59)
  den(61) = den(54)*den(60)
  den(63) = den(8)*den(62)
  den(64) = den(54)*den(63)
  den(66) = den(2)*den(65)
  den(68) = den(1)*den(67)
  den(69) = den(4)*den(66)
  den(70) = den(68)*den(69)
  den(71) = den(60)*den(68)
  den(72) = den(63)*den(68)
  den(73) = den(24)*den(66)
  den(74) = den(27)*den(66)
  den(75) = den(24)*den(56)
  den(76) = den(27)*den(56)
  den(77) = den(12)*den(54)
  den(78) = den(42)*den(77)
  den(79) = den(15)*den(54)
  den(80) = den(42)*den(79)
  den(81) = den(32)*den(59)
  den(82) = den(54)*den(81)
  den(83) = den(32)*den(62)
  den(84) = den(54)*den(83)
  den(85) = den(35)*den(66)
  den(86) = den(30)*den(85)
  den(87) = den(38)*den(66)
  den(88) = den(30)*den(87)
  den(89) = den(35)*den(56)
  den(90) = den(30)*den(89)
  den(91) = den(38)*den(56)
  den(92) = den(30)*den(91)
  den(93) = den(12)*den(68)
  den(94) = den(42)*den(93)
  den(95) = den(15)*den(68)
  den(96) = den(42)*den(95)
  den(97) = den(32)*den(93)
  den(98) = den(32)*den(95)
  den(99) = den(23)*den(44)
  den(100) = den(66)*den(99)
  den(101) = den(26)*den(44)
  den(102) = den(66)*den(101)
  den(103) = den(44)*den(89)
  den(104) = den(44)*den(91)
  den(106) = den(3)*den(105)
  den(107) = den(24)*den(106)
  den(108) = den(27)*den(106)
  den(110) = den(4)*den(109)
  den(111) = den(13)*den(110)
  den(112) = den(16)*den(110)
  den(114) = den(3)*den(113)
  den(115) = den(27)*den(114)
  den(117) = den(4)*den(116)
  den(118) = den(16)*den(117)
  den(119) = den(1)*den(106)
  den(120) = den(117)*den(119)
  den(121) = den(1)*den(110)
  den(122) = den(114)*den(121)
  den(123) = den(35)*den(106)
  den(124) = den(30)*den(123)
  den(125) = den(38)*den(106)
  den(126) = den(30)*den(125)
  den(127) = den(38)*den(114)
  den(128) = den(30)*den(127)
  den(129) = den(44)*den(123)
  den(130) = den(44)*den(125)
  den(131) = den(44)*den(127)
  den(132) = den(59)*den(110)
  den(133) = den(54)*den(132)
  den(134) = den(62)*den(110)
  den(135) = den(54)*den(134)
  den(136) = den(62)*den(117)
  den(137) = den(54)*den(136)
  den(138) = den(68)*den(136)
  den(139) = den(68)*den(132)
  den(140) = den(68)*den(134)
  den(142) = den(3)*den(141)
  den(143) = den(60)*den(142)
  den(144) = den(63)*den(142)
  den(146) = den(4)*den(145)
  den(147) = den(36)*den(146)
  den(148) = den(39)*den(146)
  den(150) = den(3)*den(149)
  den(151) = den(63)*den(150)
  den(153) = den(4)*den(152)
  den(154) = den(39)*den(153)
  den(155) = den(2)*den(142)
  den(156) = den(153)*den(155)
  den(157) = den(2)*den(146)
  den(158) = den(150)*den(157)
  den(159) = den(12)*den(142)
  den(160) = den(42)*den(159)
  den(161) = den(15)*den(142)
  den(162) = den(42)*den(161)
  den(163) = den(32)*den(159)
  den(164) = den(32)*den(161)
  den(165) = den(15)*den(150)
  den(166) = den(32)*den(165)
  den(167) = den(42)*den(165)
  den(168) = den(26)*den(153)
  den(169) = den(56)*den(168)
  den(170) = den(23)*den(146)
  den(171) = den(66)*den(170)
  den(172) = den(26)*den(146)
  den(173) = den(66)*den(172)
  den(174) = den(56)*den(170)
  den(175) = den(56)*den(172)
  den(176) = den(66)*den(168)
  den(177) = den(117)*den(165)
  den(178) = den(114)*den(168)
  den(179) = den(106)*den(168)
  den(180) = den(110)*den(165)
  den(181) = den(136)*den(142)
  den(182) = den(110)*den(159)
  den(183) = den(110)*den(161)
  den(184) = den(127)*den(146)
  den(185) = den(106)*den(170)
  den(186) = den(106)*den(172)
  den(187) = den(42)*den(59)
  den(188) = den(54)*den(187)
  den(189) = den(42)*den(62)
  den(190) = den(54)*den(189)
  den(191) = den(23)*den(30)
  den(192) = den(66)*den(191)
  den(193) = den(26)*den(30)
  den(194) = den(66)*den(193)
  den(195) = den(32)*den(77)
  den(196) = den(32)*den(79)
  den(197) = den(44)*den(85)
  den(198) = den(44)*den(87)
  den(199) = den(56)*den(191)
  den(200) = den(56)*den(193)
  den(201) = den(68)*den(187)
  den(202) = den(68)*den(189)
  den(203) = den(68)*den(81)
  den(204) = den(68)*den(83)
  den(205) = den(56)*den(99)
  den(206) = den(56)*den(101)
  den(208) = den(36)*den(207)
  den(209) = den(30)*den(208)
  den(210) = den(39)*den(207)
  den(211) = den(30)*den(210)
  den(213) = den(36)*den(212)
  den(214) = den(44)*den(213)
  den(215) = den(39)*den(212)
  den(216) = den(44)*den(215)
  den(218) = den(13)*den(217)
  den(219) = den(42)*den(218)
  den(220) = den(16)*den(217)
  den(221) = den(42)*den(220)
  den(223) = den(13)*den(222)
  den(224) = den(32)*den(223)
  den(225) = den(16)*den(222)
  den(226) = den(32)*den(225)
  den(227) = den(3)*den(32)
  den(228) = den(207)*den(227)
  den(229) = den(30)*den(228)
  den(230) = den(3)*den(44)
  den(231) = den(217)*den(230)
  den(232) = den(42)*den(231)
  den(233) = den(33)*den(222)
  den(234) = den(32)*den(233)
  den(235) = den(45)*den(212)
  den(236) = den(44)*den(235)
  den(238) = den(60)*den(237)
  den(239) = den(54)*den(238)
  den(240) = den(63)*den(237)
  den(241) = den(54)*den(240)
  den(243) = den(60)*den(242)
  den(244) = den(68)*den(243)
  den(245) = den(63)*den(242)
  den(246) = den(68)*den(245)
  den(248) = den(24)*den(247)
  den(249) = den(66)*den(248)
  den(250) = den(27)*den(247)
  den(251) = den(66)*den(250)
  den(253) = den(24)*den(252)
  den(254) = den(56)*den(253)
  den(255) = den(27)*den(252)
  den(256) = den(56)*den(255)
  den(257) = den(4)*den(56)
  den(258) = den(237)*den(257)
  den(259) = den(54)*den(258)
  den(260) = den(4)*den(68)
  den(261) = den(247)*den(260)
  den(262) = den(66)*den(261)
  den(263) = den(57)*den(252)
  den(264) = den(56)*den(263)
  den(265) = den(69)*den(242)
  den(266) = den(68)*den(265)
  den(267) = den(53)*den(54)
  den(268) = den(187)*den(267)
  den(269) = den(189)*den(267)
  den(270) = den(81)*den(267)
  den(271) = den(83)*den(267)
  den(272) = den(65)*den(66)
  den(273) = den(191)*den(272)
  den(274) = den(193)*den(272)
  den(275) = den(55)*den(56)
  den(276) = den(191)*den(275)
  den(277) = den(193)*den(275)
  den(278) = den(67)*den(68)
  den(279) = den(187)*den(278)
  den(280) = den(189)*den(278)
  den(281) = den(81)*den(278)
  den(282) = den(83)*den(278)
  den(283) = den(99)*den(272)
  den(284) = den(101)*den(272)
  den(285) = den(99)*den(275)
  den(286) = den(101)*den(275)
  den(287) = den(41)*den(42)
  den(288) = den(77)*den(287)
  den(289) = den(79)*den(287)
  den(290) = den(31)*den(32)
  den(291) = den(77)*den(290)
  den(292) = den(79)*den(290)
  den(293) = den(29)*den(30)
  den(294) = den(85)*den(293)
  den(295) = den(87)*den(293)
  den(296) = den(89)*den(293)
  den(297) = den(91)*den(293)
  den(298) = den(93)*den(287)
  den(299) = den(95)*den(287)
  den(300) = den(93)*den(290)
  den(301) = den(95)*den(290)
  den(302) = den(43)*den(44)
  den(303) = den(85)*den(302)
  den(304) = den(87)*den(302)
  den(305) = den(89)*den(302)
  den(306) = den(91)*den(302)
  den(307) = den(123)*den(293)
  den(308) = den(125)*den(293)
  den(309) = den(127)*den(293)
  den(310) = den(123)*den(302)
  den(311) = den(125)*den(302)
  den(312) = den(127)*den(302)
  den(313) = den(132)*den(267)
  den(314) = den(134)*den(267)
  den(315) = den(136)*den(267)
  den(316) = den(136)*den(278)
  den(317) = den(132)*den(278)
  den(318) = den(134)*den(278)
  den(319) = den(159)*den(287)
  den(320) = den(161)*den(287)
  den(321) = den(159)*den(290)
  den(322) = den(161)*den(290)
  den(323) = den(165)*den(290)
  den(324) = den(165)*den(287)
  den(325) = den(168)*den(275)
  den(326) = den(170)*den(272)
  den(327) = den(172)*den(272)
  den(328) = den(170)*den(275)
  den(329) = den(172)*den(275)
  den(330) = den(168)*den(272)
  den(332) = den(5)*den(331)
  den(333) = den(1)*den(2)*den(4)
  den(335) = den(333)*den(334)
  den(336) = den(2)*den(10)
  den(337) = den(331)*den(336)
  den(338) = den(2)*den(13)
  den(339) = den(331)*den(338)
  den(340) = den(2)*den(16)
  den(341) = den(331)*den(340)
  den(343) = den(19)*den(342)
  den(344) = den(1)*den(343)
  den(345) = den(331)*den(344)
  den(346) = den(1)*den(36)
  den(347) = den(331)*den(346)
  den(348) = den(1)*den(39)
  den(349) = den(331)*den(348)
  den(350) = den(2)*den(21)
  den(351) = den(334)*den(350)
  den(352) = den(2)*den(24)
  den(353) = den(334)*den(352)
  den(354) = den(2)*den(27)
  den(355) = den(334)*den(354)
  den(357) = den(8)*den(356)
  den(358) = den(1)*den(357)
  den(359) = den(334)*den(358)
  den(360) = den(1)*den(60)
  den(361) = den(334)*den(360)
  den(362) = den(1)*den(63)
  den(363) = den(334)*den(362)
  den(364) = den(54)*den(56)
  den(365) = den(331)*den(364)
  den(366) = den(77)*den(222)
  den(367) = den(79)*den(222)
  den(368) = den(77)*den(217)
  den(369) = den(79)*den(217)
  den(370) = den(2)*den(77)
  den(371) = den(331)*den(370)
  den(372) = den(2)*den(79)
  den(373) = den(331)*den(372)
  den(374) = den(30)*den(32)
  den(375) = den(334)*den(374)
  den(376) = den(191)*den(252)
  den(377) = den(193)*den(252)
  den(378) = den(191)*den(247)
  den(379) = den(193)*den(247)
  den(380) = den(2)*den(191)
  den(381) = den(334)*den(380)
  den(382) = den(2)*den(193)
  den(383) = den(334)*den(382)
  den(384) = den(66)*den(68)
  den(385) = den(331)*den(384)
  den(386) = den(93)*den(222)
  den(387) = den(95)*den(222)
  den(388) = den(93)*den(217)
  den(389) = den(95)*den(217)
  den(390) = den(2)*den(93)
  den(391) = den(331)*den(390)
  den(392) = den(2)*den(95)
  den(393) = den(331)*den(392)
  den(394) = den(42)*den(44)
  den(395) = den(334)*den(394)
  den(396) = den(99)*den(252)
  den(397) = den(101)*den(252)
  den(398) = den(99)*den(247)
  den(399) = den(101)*den(247)
  den(400) = den(2)*den(99)
  den(401) = den(334)*den(400)
  den(402) = den(2)*den(101)
  den(403) = den(334)*den(402)
  den(404) = den(85)*den(212)
  den(405) = den(87)*den(212)
  den(406) = den(85)*den(207)
  den(407) = den(87)*den(207)
  den(408) = den(1)*den(85)
  den(409) = den(331)*den(408)
  den(410) = den(1)*den(87)
  den(411) = den(331)*den(410)
  den(412) = den(187)*den(242)
  den(413) = den(189)*den(242)
  den(414) = den(187)*den(237)
  den(415) = den(189)*den(237)
  den(416) = den(1)*den(187)
  den(417) = den(334)*den(416)
  den(418) = den(1)*den(189)
  den(419) = den(334)*den(418)
  den(420) = den(89)*den(212)
  den(421) = den(91)*den(212)
  den(422) = den(89)*den(207)
  den(423) = den(91)*den(207)
  den(424) = den(1)*den(89)
  den(425) = den(331)*den(424)
  den(426) = den(1)*den(91)
  den(427) = den(331)*den(426)
  den(428) = den(81)*den(242)
  den(429) = den(83)*den(242)
  den(430) = den(81)*den(237)
  den(431) = den(83)*den(237)
  den(432) = den(1)*den(81)
  den(433) = den(334)*den(432)
  den(434) = den(1)*den(83)
  den(435) = den(334)*den(434)
  den(436) = den(123)*den(212)
  den(437) = den(125)*den(212)
  den(438) = den(123)*den(207)
  den(439) = den(125)*den(207)
  den(440) = den(1)*den(123)
  den(441) = den(331)*den(440)
  den(442) = den(1)*den(125)
  den(443) = den(331)*den(442)
  den(444) = den(127)*den(212)
  den(445) = den(127)*den(207)
  den(446) = den(1)*den(127)
  den(447) = den(331)*den(446)
  den(449) = den(16)*den(448)
  den(450) = den(331)*den(449)
  den(452) = den(13)*den(451)
  den(453) = den(331)*den(452)
  den(454) = den(16)*den(451)
  den(455) = den(331)*den(454)
  den(456) = den(119)*den(448)
  den(457) = den(331)*den(456)
  den(458) = den(1)*den(114)
  den(459) = den(451)*den(458)
  den(460) = den(331)*den(459)
  den(461) = den(136)*den(242)
  den(462) = den(132)*den(242)
  den(463) = den(134)*den(242)
  den(464) = den(132)*den(237)
  den(465) = den(134)*den(237)
  den(466) = den(1)*den(132)
  den(467) = den(334)*den(466)
  den(468) = den(1)*den(134)
  den(469) = den(334)*den(468)
  den(470) = den(136)*den(237)
  den(471) = den(1)*den(136)
  den(472) = den(334)*den(471)
  den(474) = den(27)*den(473)
  den(475) = den(334)*den(474)
  den(477) = den(24)*den(476)
  den(478) = den(334)*den(477)
  den(479) = den(27)*den(476)
  den(480) = den(334)*den(479)
  den(481) = den(121)*den(473)
  den(482) = den(334)*den(481)
  den(483) = den(1)*den(117)
  den(484) = den(476)*den(483)
  den(485) = den(334)*den(484)
  den(486) = den(79)*den(448)
  den(487) = den(331)*den(486)
  den(488) = den(77)*den(451)
  den(489) = den(331)*den(488)
  den(490) = den(79)*den(451)
  den(491) = den(331)*den(490)
  den(492) = den(193)*den(473)
  den(493) = den(334)*den(492)
  den(494) = den(191)*den(476)
  den(495) = den(334)*den(494)
  den(496) = den(193)*den(476)
  den(497) = den(334)*den(496)
  den(498) = den(95)*den(448)
  den(499) = den(331)*den(498)
  den(500) = den(93)*den(451)
  den(501) = den(331)*den(500)
  den(502) = den(95)*den(451)
  den(503) = den(331)*den(502)
  den(504) = den(101)*den(473)
  den(505) = den(334)*den(504)
  den(506) = den(99)*den(476)
  den(507) = den(334)*den(506)
  den(508) = den(101)*den(476)
  den(509) = den(334)*den(508)
  den(510) = den(159)*den(222)
  den(511) = den(161)*den(222)
  den(512) = den(159)*den(217)
  den(513) = den(161)*den(217)
  den(514) = den(2)*den(159)
  den(515) = den(331)*den(514)
  den(516) = den(2)*den(161)
  den(517) = den(331)*den(516)
  den(518) = den(165)*den(222)
  den(519) = den(165)*den(217)
  den(520) = den(2)*den(165)
  den(521) = den(331)*den(520)
  den(523) = den(39)*den(522)
  den(524) = den(331)*den(523)
  den(526) = den(36)*den(525)
  den(527) = den(331)*den(526)
  den(528) = den(39)*den(525)
  den(529) = den(331)*den(528)
  den(530) = den(155)*den(522)
  den(531) = den(331)*den(530)
  den(532) = den(2)*den(150)
  den(533) = den(525)*den(532)
  den(534) = den(331)*den(533)
  den(535) = den(168)*den(252)
  den(536) = den(170)*den(252)
  den(537) = den(172)*den(252)
  den(538) = den(170)*den(247)
  den(539) = den(172)*den(247)
  den(540) = den(2)*den(170)
  den(541) = den(334)*den(540)
  den(542) = den(2)*den(172)
  den(543) = den(334)*den(542)
  den(544) = den(168)*den(247)
  den(545) = den(2)*den(168)
  den(546) = den(334)*den(545)
  den(548) = den(63)*den(547)
  den(549) = den(334)*den(548)
  den(551) = den(60)*den(550)
  den(552) = den(334)*den(551)
  den(553) = den(63)*den(550)
  den(554) = den(334)*den(553)
  den(555) = den(157)*den(547)
  den(556) = den(334)*den(555)
  den(557) = den(2)*den(153)
  den(558) = den(550)*den(557)
  den(559) = den(334)*den(558)
  den(560) = den(91)*den(522)
  den(561) = den(331)*den(560)
  den(562) = den(83)*den(547)
  den(563) = den(334)*den(562)
  den(564) = den(87)*den(522)
  den(565) = den(331)*den(564)
  den(566) = den(189)*den(547)
  den(567) = den(334)*den(566)
  den(568) = den(85)*den(525)
  den(569) = den(331)*den(568)
  den(570) = den(87)*den(525)
  den(571) = den(331)*den(570)
  den(572) = den(187)*den(550)
  den(573) = den(334)*den(572)
  den(574) = den(189)*den(550)
  den(575) = den(334)*den(574)
  den(576) = den(89)*den(525)
  den(577) = den(331)*den(576)
  den(578) = den(91)*den(525)
  den(579) = den(331)*den(578)
  den(580) = den(81)*den(550)
  den(581) = den(334)*den(580)
  den(582) = den(83)*den(550)
  den(583) = den(334)*den(582)
  den(584) = den(165)*den(448)
  den(585) = den(331)*den(584)
  den(586) = den(127)*den(522)
  den(587) = den(331)*den(586)
  den(588) = den(125)*den(522)
  den(589) = den(331)*den(588)
  den(590) = den(165)*den(451)
  den(591) = den(331)*den(590)
  den(592) = den(161)*den(448)
  den(593) = den(331)*den(592)
  den(594) = den(159)*den(451)
  den(595) = den(331)*den(594)
  den(596) = den(161)*den(451)
  den(597) = den(331)*den(596)
  den(598) = den(127)*den(525)
  den(599) = den(331)*den(598)
  den(600) = den(123)*den(525)
  den(601) = den(331)*den(600)
  den(602) = den(125)*den(525)
  den(603) = den(331)*den(602)
  den(604) = den(168)*den(473)
  den(605) = den(334)*den(604)
  den(606) = den(136)*den(547)
  den(607) = den(334)*den(606)
  den(608) = den(134)*den(547)
  den(609) = den(334)*den(608)
  den(610) = den(168)*den(476)
  den(611) = den(334)*den(610)
  den(612) = den(172)*den(473)
  den(613) = den(334)*den(612)
  den(614) = den(170)*den(476)
  den(615) = den(334)*den(614)
  den(616) = den(172)*den(476)
  den(617) = den(334)*den(616)
  den(618) = den(136)*den(550)
  den(619) = den(334)*den(618)
  den(620) = den(132)*den(550)
  den(621) = den(334)*den(620)
  den(622) = den(134)*den(550)
  den(623) = den(334)*den(622)
  den(624) = den(3)*den(30)*den(32)
  den(625) = den(2)*den(233)
  den(626) = den(2)*den(3)*den(30)
  den(627) = den(3)*den(42)*den(44)
  den(628) = den(2)*den(231)
  den(629) = den(2)*den(3)*den(44)
  den(630) = den(1)*den(235)
  den(631) = den(1)*den(3)*den(42)
  den(632) = den(1)*den(228)
  den(633) = den(1)*den(3)*den(32)
  den(634) = den(2)*den(223)
  den(635) = den(2)*den(225)
  den(636) = den(2)*den(218)
  den(637) = den(2)*den(220)
  den(638) = den(1)*den(213)
  den(639) = den(1)*den(215)
  den(640) = den(1)*den(208)
  den(641) = den(1)*den(210)
  den(642) = den(4)*den(54)*den(56)
  den(643) = den(2)*den(263)
  den(644) = den(2)*den(4)*den(54)
  den(645) = den(4)*den(66)*den(68)
  den(646) = den(2)*den(261)
  den(647) = den(2)*den(4)*den(68)
  den(648) = den(1)*den(265)
  den(649) = den(1)*den(4)*den(66)
  den(650) = den(1)*den(258)
  den(651) = den(1)*den(4)*den(56)
  den(652) = den(2)*den(253)
  den(653) = den(2)*den(255)
  den(654) = den(1)*den(243)
  den(655) = den(1)*den(245)
  den(656) = den(2)*den(248)
  den(657) = den(2)*den(250)
  den(658) = den(1)*den(238)
  den(659) = den(1)*den(240)
  den(660) = den(2)*den(366)
  den(661) = den(2)*den(367)
  den(662) = den(2)*den(368)
  den(663) = den(2)*den(369)
  den(664) = den(2)*den(376)
  den(665) = den(2)*den(377)
  den(666) = den(2)*den(378)
  den(667) = den(2)*den(379)
  den(668) = den(2)*den(386)
  den(669) = den(2)*den(387)
  den(670) = den(2)*den(388)
  den(671) = den(2)*den(389)
  den(672) = den(2)*den(396)
  den(673) = den(2)*den(397)
  den(674) = den(2)*den(398)
  den(675) = den(2)*den(399)
  den(676) = den(1)*den(404)
  den(677) = den(1)*den(405)
  den(678) = den(1)*den(406)
  den(679) = den(1)*den(407)
  den(680) = den(1)*den(412)
  den(681) = den(1)*den(413)
  den(682) = den(1)*den(414)
  den(683) = den(1)*den(415)
  den(684) = den(1)*den(420)
  den(685) = den(1)*den(421)
  den(686) = den(1)*den(422)
  den(687) = den(1)*den(423)
  den(688) = den(1)*den(428)
  den(689) = den(1)*den(429)
  den(690) = den(1)*den(430)
  den(691) = den(1)*den(431)
  den(692) = den(1)*den(436)
  den(693) = den(1)*den(437)
  den(694) = den(1)*den(438)
  den(695) = den(1)*den(439)
  den(696) = den(1)*den(444)
  den(697) = den(1)*den(445)
  den(698) = den(1)*den(461)
  den(699) = den(1)*den(462)
  den(700) = den(1)*den(463)
  den(701) = den(1)*den(464)
  den(702) = den(1)*den(465)
  den(703) = den(1)*den(470)
  den(704) = den(2)*den(510)
  den(705) = den(2)*den(511)
  den(706) = den(2)*den(512)
  den(707) = den(2)*den(513)
  den(708) = den(2)*den(518)
  den(709) = den(2)*den(519)
  den(710) = den(2)*den(535)
  den(711) = den(2)*den(536)
  den(712) = den(2)*den(537)
  den(713) = den(2)*den(538)
  den(714) = den(2)*den(539)
  den(715) = den(2)*den(544)
  den(716) = den(42)*den(368)
  den(717) = den(42)*den(369)
  den(718) = den(54)*den(414)
  den(719) = den(54)*den(415)
  den(720) = den(32)*den(366)
  den(721) = den(32)*den(367)
  den(722) = den(54)*den(430)
  den(723) = den(54)*den(431)
  den(724) = den(30)*den(406)
  den(725) = den(30)*den(407)
  den(726) = den(66)*den(378)
  den(727) = den(66)*den(379)
  den(728) = den(30)*den(422)
  den(729) = den(30)*den(423)
  den(730) = den(56)*den(376)
  den(731) = den(56)*den(377)
  den(732) = den(42)*den(388)
  den(733) = den(42)*den(389)
  den(734) = den(68)*den(412)
  den(735) = den(68)*den(413)
  den(736) = den(32)*den(386)
  den(737) = den(32)*den(387)
  den(738) = den(68)*den(428)
  den(739) = den(68)*den(429)
  den(740) = den(44)*den(404)
  den(741) = den(44)*den(405)
  den(742) = den(66)*den(398)
  den(743) = den(66)*den(399)
  den(744) = den(44)*den(420)
  den(745) = den(44)*den(421)
  den(746) = den(56)*den(396)
  den(747) = den(56)*den(397)
  den(748) = den(30)*den(438)
  den(749) = den(30)*den(439)
  den(750) = den(30)*den(445)
  den(751) = den(44)*den(436)
  den(752) = den(44)*den(437)
  den(753) = den(44)*den(444)
  den(754) = den(54)*den(464)
  den(755) = den(54)*den(465)
  den(756) = den(54)*den(470)
  den(757) = den(68)*den(461)
  den(758) = den(68)*den(462)
  den(759) = den(68)*den(463)
  den(760) = den(42)*den(512)
  den(761) = den(42)*den(513)
  den(762) = den(32)*den(510)
  den(763) = den(32)*den(511)
  den(764) = den(32)*den(518)
  den(765) = den(42)*den(519)
  den(766) = den(56)*den(535)
  den(767) = den(66)*den(538)
  den(768) = den(66)*den(539)
  den(769) = den(56)*den(536)
  den(770) = den(56)*den(537)
  den(771) = den(66)*den(544)

end subroutine denominators

!
!
!
!
!
! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_ppllnnjj_vbs_nexnmxemucdxsx_2_/**/DREALKIND, only: ntry, nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for anti-nu_e anti-nu_mu e- mu- up charm anti-down anti-strange -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppllnnjj_vbs_nexnmxemucdxsx_2, only: external_perm_ppllnnjj_vbs_nexnmxemucdxsx_2, &
    & external_perm_inv_ppllnnjj_vbs_nexnmxemucdxsx_2, extcomb_perm_ppllnnjj_vbs_nexnmxemucdxsx_2, &
    & average_factor_ppllnnjj_vbs_nexnmxemucdxsx_2
  use ol_external_ppllnnjj_vbs_nexnmxemucdxsx_2, only: H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppllnnjj_vbs_nexnmxemucdxsx_2_/**/REALKIND, only: colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppllnnjj_vbs_nexnmxemucdxsx_2_/**/REALKIND, only: check_forced_parameters
  use ol_heltables_OLR_ppllnnjj_vbs_nexnmxemucdxsx_2
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: IR_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,8)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(37)
  logical, intent(in) :: qp_kinematics

  integer           :: shift, k, r, m, n
  real(REALKIND)    :: P(0:3,8)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,8)
#endif
  integer           :: extmasses2(8)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(37)
  complex(REALKIND) :: M1(1), M2(1) 
  real(REALKIND)    :: P_scatt_intern(0:3,8)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(1,256)
  type(Hpolcont) :: M1helarray_ct(1,256)

  type(Hpolcont) :: A(256,439)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(439)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call set_parameter("ew_renorm", 0)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, 0, 0, 0, 0, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, external_perm_inv_ppllnnjj_vbs_nexnmxemucdxsx_2, 8, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_A(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_Q(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_Q(P(:,4), rZERO, H4, ex4, POLSEL(4),4)
  call pol_wf_Q(P(:,5), rZERO, H5, ex5, POLSEL(5),5)
  call pol_wf_Q(P(:,6), rZERO, H6, ex6, POLSEL(6),6)
  call pol_wf_A(P(:,7), rZERO, H7, ex7, POLSEL(7),7)
  call pol_wf_A(P(:,8), rZERO, H8, ex8, POLSEL(8),8)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_W(ntry, ex3(:), ex1(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_QA_W(ntry, ex4(:), ex2(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_QA_W(ntry, ex5(:), ex7(:), wf4(:,3), n3(:,3), t3x4(:,:,3))
  call vert_QA_W(ntry, ex6(:), ex8(:), wf4(:,4), n3(:,4), t3x4(:,:,4))
  call prop_W_W(ntry, wf4(:,1), 5, MW, 1_intkind1, wf4(:,5), n2(1))
  call prop_W_W(ntry, wf4(:,2), 10, MW, 1_intkind1, wf4(:,6), n2(2))
  call prop_W_W(ntry, wf4(:,3), 80, MW, 1_intkind1, wf4(:,7), n2(3))
  call prop_W_W(ntry, wf4(:,4), 160, MW, 1_intkind1, wf4(:,8), n2(4))
  call vert_WWV_V(ntry, wf4(:,5), wf4(:,6), wf4(:,7), wf64(:,1), n4(:,1), t4x64(:,:,1))
  call vert_VV_S(ntry, wf4(:,5), wf4(:,7), wf16(:,1), n3(:,5), t3x16(:,:,1))
  call vert_VV_S(ntry, wf4(:,6), wf4(:,8), wf16(:,2), n3(:,6), t3x16(:,:,2))
  call vert_UV_W(ntry, wf4(:,7), 80, wf4(:,5), 5, wf16(:,3), n3(:,7), t3x16(:,:,3))
  call vert_UV_W(ntry, wf4(:,8), 160, wf4(:,6), 10, wf16(:,4), n3(:,8), t3x16(:,:,4))
  call prop_W_W(ntry, wf16(:,3), 85, MZ, 1_intkind1, wf16(:,5), n2(5))
  call vert_VV_S(ntry, wf4(:,5), wf4(:,8), wf16(:,6), n3(:,9), t3x16(:,:,5))
  call vert_VV_S(ntry, wf4(:,6), wf4(:,7), wf16(:,7), n3(:,10), t3x16(:,:,6))
  call vert_UV_W(ntry, wf4(:,8), 160, wf4(:,5), 5, wf16(:,8), n3(:,11), t3x16(:,:,7))
  call vert_UV_W(ntry, wf4(:,7), 80, wf4(:,6), 10, wf16(:,9), n3(:,12), t3x16(:,:,8))
  call prop_W_W(ntry, wf16(:,8), 165, MZ, 1_intkind1, wf16(:,10), n2(6))
  call vert_WQ_A(ntry, wf4(:,5), ex6(:), wf8(:,1), n3(:,13), t3x8(:,:,1))
  call vert_AW_Q(ntry, ex8(:), wf4(:,6), wf8(:,2), n3(:,14), t3x8(:,:,2))
  call prop_Q_A(ntry, wf8(:,1), 37, ZERO, 0_intkind1, wf8(:,3), n2(7))
  call prop_A_Q(ntry, wf8(:,2), 138, ZERO, 0_intkind1, wf8(:,4), n2(8))
  call vert_WQ_A(ntry, wf4(:,7), wf8(:,3), wf32(:,1), n3(:,15), t3x32(:,:,1))
  call vert_QA_V(ntry, wf8(:,3), ex8(:), wf16(:,11), n3(:,16), t3x16(:,:,9))
  call prop_W_W(ntry, wf16(:,9), 90, MZ, 1_intkind1, wf16(:,12), n2(9))
  call vert_QA_Z(gZd,ntry, wf8(:,3), ex8(:), wf16(:,13), n3(:,17), t3x16(:,:,10))
  call vert_WQ_A(ntry, wf4(:,6), ex6(:), wf8(:,5), n3(:,18), t3x8(:,:,3))
  call vert_AW_Q(ntry, ex8(:), wf4(:,5), wf8(:,6), n3(:,19), t3x8(:,:,4))
  call prop_Q_A(ntry, wf8(:,5), 42, ZERO, 0_intkind1, wf8(:,7), n2(10))
  call prop_A_Q(ntry, wf8(:,6), 133, ZERO, 0_intkind1, wf8(:,8), n2(11))
  call vert_WQ_A(ntry, wf4(:,7), wf8(:,7), wf32(:,2), n3(:,20), t3x32(:,:,2))
  call vert_QA_V(ntry, ex6(:), wf8(:,8), wf16(:,14), n3(:,21), t3x16(:,:,11))
  call vert_QA_Z(gZu,ntry, ex6(:), wf8(:,8), wf16(:,15), n3(:,22), t3x16(:,:,12))
  call vert_QA_V(ntry, wf8(:,7), ex8(:), wf16(:,16), n3(:,23), t3x16(:,:,13))
  call vert_QA_Z(gZd,ntry, wf8(:,7), ex8(:), wf16(:,17), n3(:,24), t3x16(:,:,14))
  call vert_QA_V(ntry, ex6(:), wf8(:,4), wf16(:,18), n3(:,25), t3x16(:,:,15))
  call vert_QA_Z(gZu,ntry, ex6(:), wf8(:,4), wf16(:,19), n3(:,26), t3x16(:,:,16))
  call vert_WQ_A(ntry, wf4(:,5), ex5(:), wf8(:,9), n3(:,27), t3x8(:,:,5))
  call vert_AW_Q(ntry, ex7(:), wf4(:,6), wf8(:,10), n3(:,28), t3x8(:,:,6))
  call prop_Q_A(ntry, wf8(:,9), 21, ZERO, 0_intkind1, wf8(:,11), n2(12))
  call prop_A_Q(ntry, wf8(:,10), 74, ZERO, 0_intkind1, wf8(:,12), n2(13))
  call vert_WQ_A(ntry, wf4(:,8), wf8(:,11), wf32(:,3), n3(:,29), t3x32(:,:,3))
  call vert_QA_V(ntry, wf8(:,11), ex7(:), wf16(:,20), n3(:,30), t3x16(:,:,17))
  call prop_W_W(ntry, wf16(:,4), 170, MZ, 1_intkind1, wf16(:,21), n2(14))
  call vert_QA_Z(gZd,ntry, wf8(:,11), ex7(:), wf16(:,22), n3(:,31), t3x16(:,:,18))
  call vert_WQ_A(ntry, wf4(:,6), ex5(:), wf8(:,13), n3(:,32), t3x8(:,:,7))
  call vert_AW_Q(ntry, ex7(:), wf4(:,5), wf8(:,14), n3(:,33), t3x8(:,:,8))
  call prop_Q_A(ntry, wf8(:,13), 26, ZERO, 0_intkind1, wf8(:,15), n2(15))
  call prop_A_Q(ntry, wf8(:,14), 69, ZERO, 0_intkind1, wf8(:,16), n2(16))
  call vert_WQ_A(ntry, wf4(:,8), wf8(:,15), wf32(:,4), n3(:,34), t3x32(:,:,4))
  call vert_QA_V(ntry, ex5(:), wf8(:,16), wf16(:,23), n3(:,35), t3x16(:,:,19))
  call vert_QA_Z(gZu,ntry, ex5(:), wf8(:,16), wf16(:,24), n3(:,36), t3x16(:,:,20))
  call vert_QA_V(ntry, wf8(:,15), ex7(:), wf16(:,25), n3(:,37), t3x16(:,:,21))
  call vert_QA_Z(gZd,ntry, wf8(:,15), ex7(:), wf16(:,26), n3(:,38), t3x16(:,:,22))
  call vert_QA_V(ntry, ex5(:), wf8(:,12), wf16(:,27), n3(:,39), t3x16(:,:,23))
  call vert_QA_Z(gZu,ntry, ex5(:), wf8(:,12), wf16(:,28), n3(:,40), t3x16(:,:,24))
  call prop_W_W(ntry, wf16(:,22), 85, MZ, 1_intkind1, wf16(:,29), n2(17))
  call prop_W_W(ntry, wf16(:,19), 170, MZ, 1_intkind1, wf16(:,30), n2(18))
  call prop_W_W(ntry, wf16(:,26), 90, MZ, 1_intkind1, wf16(:,31), n2(19))
  call prop_W_W(ntry, wf16(:,28), 90, MZ, 1_intkind1, wf16(:,32), n2(20))
  call prop_W_W(ntry, wf16(:,24), 85, MZ, 1_intkind1, wf16(:,33), n2(21))
  call prop_W_W(ntry, wf16(:,15), 165, MZ, 1_intkind1, wf16(:,34), n2(22))
  call vert_AW_Q(ntry, ex2(:), wf4(:,7), wf8(:,17), n3(:,41), t3x8(:,:,9))
  call prop_A_Q(ntry, wf8(:,17), 82, ZERO, 0_intkind1, wf8(:,18), n2(23))
  call vert_QA_V(ntry, ex4(:), wf8(:,18), wf16(:,35), n3(:,42), t3x16(:,:,25))
  call vert_QA_Z(gZl,ntry, ex4(:), wf8(:,18), wf16(:,36), n3(:,43), t3x16(:,:,26))
  call vert_AW_Q(ntry, ex2(:), wf4(:,8), wf8(:,19), n3(:,44), t3x8(:,:,10))
  call prop_A_Q(ntry, wf8(:,19), 162, ZERO, 0_intkind1, wf8(:,20), n2(24))
  call vert_QA_V(ntry, ex4(:), wf8(:,20), wf16(:,37), n3(:,45), t3x16(:,:,27))
  call vert_QA_Z(gZl,ntry, ex4(:), wf8(:,20), wf16(:,38), n3(:,46), t3x16(:,:,28))
  call vert_WQ_A(ntry, wf4(:,7), ex4(:), wf8(:,21), n3(:,47), t3x8(:,:,11))
  call prop_Q_A(ntry, wf8(:,21), 88, ZERO, 0_intkind1, wf8(:,22), n2(25))
  call vert_QA_Z(gZn,ntry, wf8(:,22), ex2(:), wf16(:,39), n3(:,48), t3x16(:,:,29))
  call vert_WQ_A(ntry, wf4(:,8), ex4(:), wf8(:,23), n3(:,49), t3x8(:,:,12))
  call prop_Q_A(ntry, wf8(:,23), 168, ZERO, 0_intkind1, wf8(:,24), n2(26))
  call vert_QA_Z(gZn,ntry, wf8(:,24), ex2(:), wf16(:,40), n3(:,50), t3x16(:,:,30))
  call vert_AW_Q(ntry, wf8(:,18), wf4(:,5), wf32(:,5), n3(:,51), t3x32(:,:,5))
  call vert_AW_Q(ntry, wf8(:,20), wf4(:,5), wf32(:,6), n3(:,52), t3x32(:,:,6))
  call prop_W_W(ntry, wf16(:,36), 90, MZ, 1_intkind1, wf16(:,41), n2(27))
  call prop_W_W(ntry, wf16(:,39), 90, MZ, 1_intkind1, wf16(:,42), n2(28))
  call prop_W_W(ntry, wf16(:,38), 170, MZ, 1_intkind1, wf16(:,43), n2(29))
  call prop_W_W(ntry, wf16(:,40), 170, MZ, 1_intkind1, wf16(:,44), n2(30))
  call vert_AW_Q(ntry, ex1(:), wf4(:,7), wf8(:,25), n3(:,53), t3x8(:,:,13))
  call prop_A_Q(ntry, wf8(:,25), 81, ZERO, 0_intkind1, wf8(:,26), n2(31))
  call vert_QA_V(ntry, ex3(:), wf8(:,26), wf16(:,45), n3(:,54), t3x16(:,:,31))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,26), wf16(:,46), n3(:,55), t3x16(:,:,32))
  call vert_AW_Q(ntry, ex1(:), wf4(:,8), wf8(:,27), n3(:,56), t3x8(:,:,14))
  call prop_A_Q(ntry, wf8(:,27), 161, ZERO, 0_intkind1, wf8(:,28), n2(32))
  call vert_QA_V(ntry, ex3(:), wf8(:,28), wf16(:,47), n3(:,57), t3x16(:,:,33))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,28), wf16(:,48), n3(:,58), t3x16(:,:,34))
  call vert_WQ_A(ntry, wf4(:,7), ex3(:), wf8(:,29), n3(:,59), t3x8(:,:,15))
  call prop_Q_A(ntry, wf8(:,29), 84, ZERO, 0_intkind1, wf8(:,30), n2(33))
  call vert_QA_Z(gZn,ntry, wf8(:,30), ex1(:), wf16(:,49), n3(:,60), t3x16(:,:,35))
  call vert_WQ_A(ntry, wf4(:,8), ex3(:), wf8(:,31), n3(:,61), t3x8(:,:,16))
  call prop_Q_A(ntry, wf8(:,31), 164, ZERO, 0_intkind1, wf8(:,32), n2(34))
  call vert_QA_Z(gZn,ntry, wf8(:,32), ex1(:), wf16(:,50), n3(:,62), t3x16(:,:,36))
  call vert_AW_Q(ntry, wf8(:,26), wf4(:,6), wf32(:,7), n3(:,63), t3x32(:,:,7))
  call vert_AW_Q(ntry, wf8(:,28), wf4(:,6), wf32(:,8), n3(:,64), t3x32(:,:,8))
  call prop_W_W(ntry, wf16(:,46), 85, MZ, 1_intkind1, wf16(:,51), n2(35))
  call prop_W_W(ntry, wf16(:,49), 85, MZ, 1_intkind1, wf16(:,52), n2(36))
  call prop_W_W(ntry, wf16(:,50), 165, MZ, 1_intkind1, wf16(:,53), n2(37))
  call prop_W_W(ntry, wf16(:,48), 165, MZ, 1_intkind1, wf16(:,54), n2(38))
  call counter_QA_W(ntry, ex6(:), ex8(:), wf4(:,9), n3(:,65), t3x4(:,:,5))
  call prop_W_W(ntry, wf4(:,9), 160, MW, 1_intkind1, wf4(:,10), n2(39))
  call counter_QA_W(ntry, ex5(:), ex7(:), wf4(:,11), n3(:,66), t3x4(:,:,6))
  call prop_W_W(ntry, wf4(:,11), 80, MW, 1_intkind1, wf4(:,12), n2(40))
  call vert_WWV_V(ntry, wf4(:,5), wf4(:,6), wf4(:,12), wf64(:,2), n4(:,2), t4x64(:,:,2))
  call counter_WQ_A(ntry, wf4(:,7), wf8(:,3), wf32(:,9), n3(:,67), t3x32(:,:,9))
  call counter_WQ_A(ntry, wf4(:,7), wf8(:,7), wf32(:,10), n3(:,68), t3x32(:,:,10))
  call counter_QA_V(ntry, wf8(:,3), ex8(:), wf16(:,55), n3(:,69), t3x16(:,:,37))
  call counter_QA_Z(gZd,ntry, wf8(:,3), ex8(:), wf16(:,56), n3(:,70), t3x16(:,:,38))
  call counter_AW_Q(ntry, ex8(:), wf4(:,6), wf8(:,33), n3(:,71), t3x8(:,:,17))
  call prop_A_Q(ntry, wf8(:,33), 138, ZERO, 0_intkind1, wf8(:,34), n2(41))
  call counter_QA_V(ntry, wf8(:,7), ex8(:), wf16(:,57), n3(:,72), t3x16(:,:,39))
  call counter_QA_Z(gZd,ntry, wf8(:,7), ex8(:), wf16(:,58), n3(:,73), t3x16(:,:,40))
  call vert_QA_V(ntry, ex6(:), wf8(:,34), wf16(:,59), n3(:,74), t3x16(:,:,41))
  call vert_QA_Z(gZu,ntry, ex6(:), wf8(:,34), wf16(:,60), n3(:,75), t3x16(:,:,42))
  call counter_AW_Q(ntry, ex8(:), wf4(:,5), wf8(:,35), n3(:,76), t3x8(:,:,18))
  call prop_A_Q(ntry, wf8(:,35), 133, ZERO, 0_intkind1, wf8(:,36), n2(42))
  call vert_QA_V(ntry, ex6(:), wf8(:,36), wf16(:,61), n3(:,77), t3x16(:,:,43))
  call vert_QA_Z(gZu,ntry, ex6(:), wf8(:,36), wf16(:,62), n3(:,78), t3x16(:,:,44))
  call counter_WQ_A(ntry, wf4(:,8), wf8(:,11), wf32(:,11), n3(:,79), t3x32(:,:,11))
  call counter_WQ_A(ntry, wf4(:,8), wf8(:,15), wf32(:,12), n3(:,80), t3x32(:,:,12))
  call prop_W_W(ntry, wf16(:,60), 170, MZ, 1_intkind1, wf16(:,63), n2(43))
  call prop_W_W(ntry, wf16(:,62), 165, MZ, 1_intkind1, wf16(:,64), n2(44))
  call counter_QA_V(ntry, wf8(:,11), ex7(:), wf16(:,65), n3(:,81), t3x16(:,:,45))
  call counter_QA_Z(gZd,ntry, wf8(:,11), ex7(:), wf16(:,66), n3(:,82), t3x16(:,:,46))
  call counter_AW_Q(ntry, ex7(:), wf4(:,6), wf8(:,37), n3(:,83), t3x8(:,:,19))
  call prop_A_Q(ntry, wf8(:,37), 74, ZERO, 0_intkind1, wf8(:,38), n2(45))
  call counter_QA_V(ntry, wf8(:,15), ex7(:), wf16(:,67), n3(:,84), t3x16(:,:,47))
  call counter_QA_Z(gZd,ntry, wf8(:,15), ex7(:), wf16(:,68), n3(:,85), t3x16(:,:,48))
  call vert_QA_V(ntry, ex5(:), wf8(:,38), wf16(:,69), n3(:,86), t3x16(:,:,49))
  call vert_QA_Z(gZu,ntry, ex5(:), wf8(:,38), wf16(:,70), n3(:,87), t3x16(:,:,50))
  call counter_AW_Q(ntry, ex7(:), wf4(:,5), wf8(:,39), n3(:,88), t3x8(:,:,20))
  call prop_A_Q(ntry, wf8(:,39), 69, ZERO, 0_intkind1, wf8(:,40), n2(46))
  call vert_QA_V(ntry, ex5(:), wf8(:,40), wf16(:,71), n3(:,89), t3x16(:,:,51))
  call vert_QA_Z(gZu,ntry, ex5(:), wf8(:,40), wf16(:,72), n3(:,90), t3x16(:,:,52))
  call prop_W_W(ntry, wf16(:,17), 170, MZ, 1_intkind1, wf16(:,73), n2(47))
  call prop_W_W(ntry, wf16(:,13), 165, MZ, 1_intkind1, wf16(:,74), n2(48))
  call prop_W_W(ntry, wf16(:,70), 90, MZ, 1_intkind1, wf16(:,75), n2(49))
  call prop_W_W(ntry, wf16(:,72), 85, MZ, 1_intkind1, wf16(:,76), n2(50))
  call counter_QA_V(ntry, ex6(:), wf8(:,8), wf16(:,77), n3(:,91), t3x16(:,:,53))
  call counter_QA_Z(gZu,ntry, ex6(:), wf8(:,8), wf16(:,78), n3(:,92), t3x16(:,:,54))
  call counter_WQ_A(ntry, wf4(:,6), ex6(:), wf8(:,41), n3(:,93), t3x8(:,:,21))
  call prop_Q_A(ntry, wf8(:,41), 42, ZERO, 0_intkind1, wf8(:,42), n2(51))
  call vert_WQ_A(ntry, wf4(:,7), wf8(:,42), wf32(:,13), n3(:,94), t3x32(:,:,13))
  call counter_QA_V(ntry, ex6(:), wf8(:,4), wf16(:,79), n3(:,95), t3x16(:,:,55))
  call counter_QA_Z(gZu,ntry, ex6(:), wf8(:,4), wf16(:,80), n3(:,96), t3x16(:,:,56))
  call vert_QA_V(ntry, wf8(:,42), ex8(:), wf16(:,81), n3(:,97), t3x16(:,:,57))
  call vert_QA_Z(gZd,ntry, wf8(:,42), ex8(:), wf16(:,82), n3(:,98), t3x16(:,:,58))
  call counter_WQ_A(ntry, wf4(:,5), ex6(:), wf8(:,43), n3(:,99), t3x8(:,:,22))
  call prop_Q_A(ntry, wf8(:,43), 37, ZERO, 0_intkind1, wf8(:,44), n2(52))
  call vert_WQ_A(ntry, wf4(:,7), wf8(:,44), wf32(:,14), n3(:,100), t3x32(:,:,14))
  call vert_QA_V(ntry, wf8(:,44), ex8(:), wf16(:,83), n3(:,101), t3x16(:,:,59))
  call vert_QA_Z(gZd,ntry, wf8(:,44), ex8(:), wf16(:,84), n3(:,102), t3x16(:,:,60))
  call vert_VV_S(ntry, wf4(:,6), wf4(:,10), wf16(:,85), n3(:,103), t3x16(:,:,61))
  call vert_UV_W(ntry, wf4(:,10), 160, wf4(:,6), 10, wf16(:,86), n3(:,104), t3x16(:,:,62))
  call vert_VV_S(ntry, wf4(:,5), wf4(:,10), wf16(:,87), n3(:,105), t3x16(:,:,63))
  call vert_UV_W(ntry, wf4(:,10), 160, wf4(:,5), 5, wf16(:,88), n3(:,106), t3x16(:,:,64))
  call prop_W_W(ntry, wf16(:,88), 165, MZ, 1_intkind1, wf16(:,89), n2(53))
  call vert_WQ_A(ntry, wf4(:,10), wf8(:,11), wf32(:,15), n3(:,107), t3x32(:,:,15))
  call prop_W_W(ntry, wf16(:,86), 170, MZ, 1_intkind1, wf16(:,90), n2(54))
  call vert_WQ_A(ntry, wf4(:,10), wf8(:,15), wf32(:,16), n3(:,108), t3x32(:,:,16))
  call counter_QA_V(ntry, ex5(:), wf8(:,16), wf16(:,91), n3(:,109), t3x16(:,:,65))
  call counter_QA_Z(gZu,ntry, ex5(:), wf8(:,16), wf16(:,92), n3(:,110), t3x16(:,:,66))
  call counter_WQ_A(ntry, wf4(:,6), ex5(:), wf8(:,45), n3(:,111), t3x8(:,:,23))
  call prop_Q_A(ntry, wf8(:,45), 26, ZERO, 0_intkind1, wf8(:,46), n2(55))
  call vert_WQ_A(ntry, wf4(:,8), wf8(:,46), wf32(:,17), n3(:,112), t3x32(:,:,17))
  call counter_QA_V(ntry, ex5(:), wf8(:,12), wf16(:,93), n3(:,113), t3x16(:,:,67))
  call counter_QA_Z(gZu,ntry, ex5(:), wf8(:,12), wf16(:,94), n3(:,114), t3x16(:,:,68))
  call vert_QA_V(ntry, wf8(:,46), ex7(:), wf16(:,95), n3(:,115), t3x16(:,:,69))
  call vert_QA_Z(gZd,ntry, wf8(:,46), ex7(:), wf16(:,96), n3(:,116), t3x16(:,:,70))
  call counter_WQ_A(ntry, wf4(:,5), ex5(:), wf8(:,47), n3(:,117), t3x8(:,:,24))
  call prop_Q_A(ntry, wf8(:,47), 21, ZERO, 0_intkind1, wf8(:,48), n2(56))
  call vert_WQ_A(ntry, wf4(:,8), wf8(:,48), wf32(:,18), n3(:,118), t3x32(:,:,18))
  call vert_QA_V(ntry, wf8(:,48), ex7(:), wf16(:,97), n3(:,119), t3x16(:,:,71))
  call vert_QA_Z(gZd,ntry, wf8(:,48), ex7(:), wf16(:,98), n3(:,120), t3x16(:,:,72))
  call prop_W_W(ntry, wf16(:,96), 90, MZ, 1_intkind1, wf16(:,99), n2(57))
  call prop_W_W(ntry, wf16(:,98), 85, MZ, 1_intkind1, wf16(:,100), n2(58))
  call vert_VV_S(ntry, wf4(:,5), wf4(:,12), wf16(:,101), n3(:,121), t3x16(:,:,73))
  call vert_UV_W(ntry, wf4(:,12), 80, wf4(:,5), 5, wf16(:,102), n3(:,122), t3x16(:,:,74))
  call prop_W_W(ntry, wf16(:,102), 85, MZ, 1_intkind1, wf16(:,103), n2(59))
  call vert_VV_S(ntry, wf4(:,6), wf4(:,12), wf16(:,104), n3(:,123), t3x16(:,:,75))
  call vert_UV_W(ntry, wf4(:,12), 80, wf4(:,6), 10, wf16(:,105), n3(:,124), t3x16(:,:,76))
  call vert_WQ_A(ntry, wf4(:,12), wf8(:,3), wf32(:,19), n3(:,125), t3x32(:,:,19))
  call prop_W_W(ntry, wf16(:,105), 90, MZ, 1_intkind1, wf16(:,106), n2(60))
  call vert_WQ_A(ntry, wf4(:,12), wf8(:,7), wf32(:,20), n3(:,126), t3x32(:,:,20))
  call vert_WQ_A(ntry, wf4(:,10), ex4(:), wf8(:,49), n3(:,127), t3x8(:,:,25))
  call prop_Q_A(ntry, wf8(:,49), 168, ZERO, 0_intkind1, wf8(:,50), n2(61))
  call vert_QA_Z(gZn,ntry, wf8(:,50), ex2(:), wf16(:,107), n3(:,128), t3x16(:,:,77))
  call vert_AW_Q(ntry, ex2(:), wf4(:,10), wf8(:,51), n3(:,129), t3x8(:,:,26))
  call prop_A_Q(ntry, wf8(:,51), 162, ZERO, 0_intkind1, wf8(:,52), n2(62))
  call vert_QA_V(ntry, ex4(:), wf8(:,52), wf16(:,108), n3(:,130), t3x16(:,:,78))
  call vert_QA_Z(gZl,ntry, ex4(:), wf8(:,52), wf16(:,109), n3(:,131), t3x16(:,:,79))
  call vert_AW_Q(ntry, wf8(:,52), wf4(:,5), wf32(:,21), n3(:,132), t3x32(:,:,21))
  call prop_W_W(ntry, wf16(:,107), 170, MZ, 1_intkind1, wf16(:,110), n2(63))
  call prop_W_W(ntry, wf16(:,109), 170, MZ, 1_intkind1, wf16(:,111), n2(64))
  call vert_WQ_A(ntry, wf4(:,12), ex4(:), wf8(:,53), n3(:,133), t3x8(:,:,27))
  call prop_Q_A(ntry, wf8(:,53), 88, ZERO, 0_intkind1, wf8(:,54), n2(65))
  call vert_QA_Z(gZn,ntry, wf8(:,54), ex2(:), wf16(:,112), n3(:,134), t3x16(:,:,80))
  call vert_AW_Q(ntry, ex2(:), wf4(:,12), wf8(:,55), n3(:,135), t3x8(:,:,28))
  call prop_A_Q(ntry, wf8(:,55), 82, ZERO, 0_intkind1, wf8(:,56), n2(66))
  call vert_QA_V(ntry, ex4(:), wf8(:,56), wf16(:,113), n3(:,136), t3x16(:,:,81))
  call vert_QA_Z(gZl,ntry, ex4(:), wf8(:,56), wf16(:,114), n3(:,137), t3x16(:,:,82))
  call vert_AW_Q(ntry, wf8(:,56), wf4(:,5), wf32(:,22), n3(:,138), t3x32(:,:,22))
  call prop_W_W(ntry, wf16(:,112), 90, MZ, 1_intkind1, wf16(:,115), n2(67))
  call prop_W_W(ntry, wf16(:,114), 90, MZ, 1_intkind1, wf16(:,116), n2(68))
  call vert_WQ_A(ntry, wf4(:,10), ex3(:), wf8(:,57), n3(:,139), t3x8(:,:,29))
  call prop_Q_A(ntry, wf8(:,57), 164, ZERO, 0_intkind1, wf8(:,58), n2(69))
  call vert_QA_Z(gZn,ntry, wf8(:,58), ex1(:), wf16(:,117), n3(:,140), t3x16(:,:,83))
  call vert_AW_Q(ntry, ex1(:), wf4(:,10), wf8(:,59), n3(:,141), t3x8(:,:,30))
  call prop_A_Q(ntry, wf8(:,59), 161, ZERO, 0_intkind1, wf8(:,60), n2(70))
  call vert_QA_V(ntry, ex3(:), wf8(:,60), wf16(:,118), n3(:,142), t3x16(:,:,84))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,60), wf16(:,119), n3(:,143), t3x16(:,:,85))
  call vert_AW_Q(ntry, wf8(:,60), wf4(:,6), wf32(:,23), n3(:,144), t3x32(:,:,23))
  call prop_W_W(ntry, wf16(:,117), 165, MZ, 1_intkind1, wf16(:,120), n2(71))
  call prop_W_W(ntry, wf16(:,119), 165, MZ, 1_intkind1, wf16(:,121), n2(72))
  call vert_WQ_A(ntry, wf4(:,12), ex3(:), wf8(:,61), n3(:,145), t3x8(:,:,31))
  call prop_Q_A(ntry, wf8(:,61), 84, ZERO, 0_intkind1, wf8(:,62), n2(73))
  call vert_QA_Z(gZn,ntry, wf8(:,62), ex1(:), wf16(:,122), n3(:,146), t3x16(:,:,86))
  call vert_AW_Q(ntry, ex1(:), wf4(:,12), wf8(:,63), n3(:,147), t3x8(:,:,32))
  call prop_A_Q(ntry, wf8(:,63), 81, ZERO, 0_intkind1, wf8(:,64), n2(74))
  call vert_QA_V(ntry, ex3(:), wf8(:,64), wf16(:,123), n3(:,148), t3x16(:,:,87))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,64), wf16(:,124), n3(:,149), t3x16(:,:,88))
  call vert_AW_Q(ntry, wf8(:,64), wf4(:,6), wf32(:,24), n3(:,150), t3x32(:,:,24))
  call prop_W_W(ntry, wf16(:,122), 85, MZ, 1_intkind1, wf16(:,125), n2(75))
  call prop_W_W(ntry, wf16(:,124), 85, MZ, 1_intkind1, wf16(:,126), n2(76))
  call vert_AV_Q(ntry, ex8(:), wf16(:,9), wf32(:,25), n3(:,151), t3x32(:,:,25))
  call counter_Q_A(ctqq,3,ntry, wf8(:,3), 37, wf8(:,65), n2(77))
  call prop_A_Q(ntry, wf32(:,25), 218, ZERO, 0_intkind1, wf32(:,26), n2(78))
  call vert_AZ_Q(gZd,ntry, ex8(:), wf16(:,12), wf32(:,27), n3(:,152), t3x32(:,:,26))
  call prop_A_Q(ntry, wf32(:,27), 218, ZERO, 0_intkind1, wf32(:,28), n2(79))
  call vert_VQ_A(ntry, wf16(:,9), ex6(:), wf32(:,29), n3(:,153), t3x32(:,:,27))
  call counter_A_Q(ctcc,4,ntry, wf8(:,8), 133, wf8(:,66), n2(80))
  call prop_Q_A(ntry, wf32(:,29), 122, ZERO, 0_intkind1, wf32(:,30), n2(81))
  call vert_ZQ_A(gZu,ntry, wf16(:,12), ex6(:), wf32(:,31), n3(:,154), t3x32(:,:,28))
  call prop_Q_A(ntry, wf32(:,31), 122, ZERO, 0_intkind1, wf32(:,32), n2(82))
  call vert_AV_Q(ntry, ex8(:), wf16(:,3), wf32(:,33), n3(:,155), t3x32(:,:,29))
  call counter_Q_A(ctqq,3,ntry, wf8(:,7), 42, wf8(:,67), n2(83))
  call prop_A_Q(ntry, wf32(:,33), 213, ZERO, 0_intkind1, wf32(:,34), n2(84))
  call vert_AZ_Q(gZd,ntry, ex8(:), wf16(:,5), wf32(:,35), n3(:,156), t3x32(:,:,30))
  call prop_A_Q(ntry, wf32(:,35), 213, ZERO, 0_intkind1, wf32(:,36), n2(85))
  call vert_VQ_A(ntry, wf16(:,3), ex6(:), wf32(:,37), n3(:,157), t3x32(:,:,31))
  call counter_A_Q(ctcc,4,ntry, wf8(:,4), 138, wf8(:,68), n2(86))
  call prop_Q_A(ntry, wf32(:,37), 117, ZERO, 0_intkind1, wf32(:,38), n2(87))
  call vert_ZQ_A(gZu,ntry, wf16(:,5), ex6(:), wf32(:,39), n3(:,158), t3x32(:,:,32))
  call prop_Q_A(ntry, wf32(:,39), 117, ZERO, 0_intkind1, wf32(:,40), n2(88))
  call vert_AW_Q(ntry, wf8(:,4), wf4(:,7), wf32(:,41), n3(:,159), t3x32(:,:,33))
  call prop_A_Q(ntry, wf32(:,41), 218, ZERO, 0_intkind1, wf32(:,42), n2(89))
  call vert_AW_Q(ntry, wf8(:,8), wf4(:,7), wf32(:,43), n3(:,160), t3x32(:,:,34))
  call prop_A_Q(ntry, wf32(:,43), 213, ZERO, 0_intkind1, wf32(:,44), n2(90))
  call prop_Q_A(ntry, wf32(:,1), 117, ZERO, 0_intkind1, wf32(:,45), n2(91))
  call prop_Q_A(ntry, wf32(:,2), 122, ZERO, 0_intkind1, wf32(:,46), n2(92))
  call vert_AV_Q(ntry, ex7(:), wf16(:,4), wf32(:,47), n3(:,161), t3x32(:,:,35))
  call counter_Q_A(ctqq,1,ntry, wf8(:,11), 21, wf8(:,69), n2(93))
  call prop_A_Q(ntry, wf32(:,47), 234, ZERO, 0_intkind1, wf32(:,48), n2(94))
  call vert_AZ_Q(gZd,ntry, ex7(:), wf16(:,21), wf32(:,49), n3(:,162), t3x32(:,:,36))
  call prop_A_Q(ntry, wf32(:,49), 234, ZERO, 0_intkind1, wf32(:,50), n2(95))
  call vert_VQ_A(ntry, wf16(:,4), ex5(:), wf32(:,51), n3(:,163), t3x32(:,:,37))
  call counter_A_Q(ctqq,2,ntry, wf8(:,16), 69, wf8(:,70), n2(96))
  call prop_Q_A(ntry, wf32(:,51), 186, ZERO, 0_intkind1, wf32(:,52), n2(97))
  call vert_ZQ_A(gZu,ntry, wf16(:,21), ex5(:), wf32(:,53), n3(:,164), t3x32(:,:,38))
  call prop_Q_A(ntry, wf32(:,53), 186, ZERO, 0_intkind1, wf32(:,54), n2(98))
  call vert_AV_Q(ntry, ex7(:), wf16(:,8), wf32(:,55), n3(:,165), t3x32(:,:,39))
  call counter_Q_A(ctqq,1,ntry, wf8(:,15), 26, wf8(:,71), n2(99))
  call prop_A_Q(ntry, wf32(:,55), 229, ZERO, 0_intkind1, wf32(:,56), n2(100))
  call vert_AZ_Q(gZd,ntry, ex7(:), wf16(:,10), wf32(:,57), n3(:,166), t3x32(:,:,40))
  call prop_A_Q(ntry, wf32(:,57), 229, ZERO, 0_intkind1, wf32(:,58), n2(101))
  call vert_VQ_A(ntry, wf16(:,8), ex5(:), wf32(:,59), n3(:,167), t3x32(:,:,41))
  call counter_A_Q(ctqq,2,ntry, wf8(:,12), 74, wf8(:,72), n2(102))
  call prop_Q_A(ntry, wf32(:,59), 181, ZERO, 0_intkind1, wf32(:,60), n2(103))
  call vert_ZQ_A(gZu,ntry, wf16(:,10), ex5(:), wf32(:,61), n3(:,168), t3x32(:,:,42))
  call prop_Q_A(ntry, wf32(:,61), 181, ZERO, 0_intkind1, wf32(:,62), n2(104))
  call vert_AW_Q(ntry, wf8(:,12), wf4(:,8), wf32(:,63), n3(:,169), t3x32(:,:,43))
  call prop_A_Q(ntry, wf32(:,63), 234, ZERO, 0_intkind1, wf32(:,64), n2(105))
  call vert_AW_Q(ntry, wf8(:,16), wf4(:,8), wf32(:,65), n3(:,170), t3x32(:,:,44))
  call prop_A_Q(ntry, wf32(:,65), 229, ZERO, 0_intkind1, wf32(:,66), n2(106))
  call prop_Q_A(ntry, wf32(:,3), 181, ZERO, 0_intkind1, wf32(:,67), n2(107))
  call prop_Q_A(ntry, wf32(:,4), 186, ZERO, 0_intkind1, wf32(:,68), n2(108))
  call prop_Q_A(ntry, wf8(:,69), 21, ZERO, 0_intkind1, wf8(:,73), n2(109))
  call vert_QA_V(ntry, wf8(:,73), ex7(:), wf16(:,127), n3(:,171), t3x16(:,:,89))
  call vert_QA_Z(gZd,ntry, wf8(:,73), ex7(:), wf16(:,128), n3(:,172), t3x16(:,:,90))
  call prop_Q_A(ntry, wf8(:,71), 26, ZERO, 0_intkind1, wf8(:,74), n2(110))
  call vert_QA_V(ntry, wf8(:,74), ex7(:), wf16(:,129), n3(:,173), t3x16(:,:,91))
  call vert_QA_Z(gZd,ntry, wf8(:,74), ex7(:), wf16(:,130), n3(:,174), t3x16(:,:,92))
  call prop_A_Q(ntry, wf8(:,72), 74, ZERO, 0_intkind1, wf8(:,75), n2(111))
  call vert_QA_V(ntry, ex5(:), wf8(:,75), wf16(:,131), n3(:,175), t3x16(:,:,93))
  call vert_QA_Z(gZu,ntry, ex5(:), wf8(:,75), wf16(:,132), n3(:,176), t3x16(:,:,94))
  call prop_A_Q(ntry, wf8(:,70), 69, ZERO, 0_intkind1, wf8(:,76), n2(112))
  call vert_QA_V(ntry, ex5(:), wf8(:,76), wf16(:,133), n3(:,177), t3x16(:,:,95))
  call vert_QA_Z(gZu,ntry, ex5(:), wf8(:,76), wf16(:,134), n3(:,178), t3x16(:,:,96))
  call prop_Q_A(ntry, wf8(:,67), 42, ZERO, 0_intkind1, wf8(:,77), n2(113))
  call vert_QA_V(ntry, wf8(:,77), ex8(:), wf16(:,135), n3(:,179), t3x16(:,:,97))
  call vert_QA_Z(gZd,ntry, wf8(:,77), ex8(:), wf16(:,136), n3(:,180), t3x16(:,:,98))
  call prop_A_Q(ntry, wf8(:,68), 138, ZERO, 0_intkind1, wf8(:,78), n2(114))
  call vert_QA_V(ntry, ex6(:), wf8(:,78), wf16(:,137), n3(:,181), t3x16(:,:,99))
  call vert_QA_Z(gZu,ntry, ex6(:), wf8(:,78), wf16(:,138), n3(:,182), t3x16(:,:,100))
  call prop_Q_A(ntry, wf8(:,65), 37, ZERO, 0_intkind1, wf8(:,79), n2(115))
  call vert_QA_V(ntry, wf8(:,79), ex8(:), wf16(:,139), n3(:,183), t3x16(:,:,101))
  call vert_QA_Z(gZd,ntry, wf8(:,79), ex8(:), wf16(:,140), n3(:,184), t3x16(:,:,102))
  call prop_A_Q(ntry, wf8(:,66), 133, ZERO, 0_intkind1, wf8(:,80), n2(116))
  call vert_QA_V(ntry, ex6(:), wf8(:,80), wf16(:,141), n3(:,185), t3x16(:,:,103))
  call vert_QA_Z(gZu,ntry, ex6(:), wf8(:,80), wf16(:,142), n3(:,186), t3x16(:,:,104))
  call prop_W_W(ntry, wf64(:,1), 95, MW, 1_intkind1, wf64(:,3), n2(117))
  call vert_WWV_V(ntry, wf4(:,5), wf4(:,6), wf4(:,8), wf64(:,4), n4(:,3), t4x64(:,:,3))
  call prop_W_W(ntry, wf64(:,4), 175, MW, 1_intkind1, wf64(:,5), n2(118))
  call vert_SV_V(ntry, wf16(:,1), wf4(:,6), wf64(:,6), n3(:,187), t3x64(:,:,1))
  call prop_W_W(ntry, wf64(:,6), 95, MW, 1_intkind1, wf64(:,7), n2(119))
  call vert_UV_W(ntry, wf4(:,6), 10, wf16(:,3), 85, wf64(:,8), n3(:,188), t3x64(:,:,2))
  call prop_W_W(ntry, wf64(:,8), 95, MW, 1_intkind1, wf64(:,9), n2(120))
  call vert_UV_W(ntry, wf4(:,6), 10, wf16(:,5), 85, wf64(:,10), n3(:,189), t3x64(:,:,3))
  call prop_W_W(ntry, wf64(:,10), 95, MW, 1_intkind1, wf64(:,11), n2(121))
  call vert_SV_V(ntry, wf16(:,7), wf4(:,5), wf64(:,12), n3(:,190), t3x64(:,:,4))
  call prop_W_W(ntry, wf64(:,12), 95, MW, 1_intkind1, wf64(:,13), n2(122))
  call vert_UV_W(ntry, wf4(:,5), 5, wf16(:,9), 90, wf64(:,14), n3(:,191), t3x64(:,:,5))
  call prop_W_W(ntry, wf64(:,14), 95, MW, 1_intkind1, wf64(:,15), n2(123))
  call vert_UV_W(ntry, wf4(:,5), 5, wf16(:,12), 90, wf64(:,16), n3(:,192), t3x64(:,:,6))
  call prop_W_W(ntry, wf64(:,16), 95, MW, 1_intkind1, wf64(:,17), n2(124))
  call vert_SV_V(ntry, wf16(:,6), wf4(:,6), wf64(:,18), n3(:,193), t3x64(:,:,7))
  call prop_W_W(ntry, wf64(:,18), 175, MW, 1_intkind1, wf64(:,19), n2(125))
  call vert_UV_W(ntry, wf4(:,6), 10, wf16(:,8), 165, wf64(:,20), n3(:,194), t3x64(:,:,8))
  call prop_W_W(ntry, wf64(:,20), 175, MW, 1_intkind1, wf64(:,21), n2(126))
  call vert_UV_W(ntry, wf4(:,6), 10, wf16(:,10), 165, wf64(:,22), n3(:,195), t3x64(:,:,9))
  call prop_W_W(ntry, wf64(:,22), 175, MW, 1_intkind1, wf64(:,23), n2(127))
  call vert_SV_V(ntry, wf16(:,2), wf4(:,5), wf64(:,24), n3(:,196), t3x64(:,:,10))
  call prop_W_W(ntry, wf64(:,24), 175, MW, 1_intkind1, wf64(:,25), n2(128))
  call vert_UV_W(ntry, wf4(:,5), 5, wf16(:,4), 170, wf64(:,26), n3(:,197), t3x64(:,:,11))
  call prop_W_W(ntry, wf64(:,26), 175, MW, 1_intkind1, wf64(:,27), n2(129))
  call vert_UV_W(ntry, wf4(:,5), 5, wf16(:,21), 170, wf64(:,28), n3(:,198), t3x64(:,:,12))
  call prop_W_W(ntry, wf64(:,28), 175, MW, 1_intkind1, wf64(:,29), n2(130))
  call vert_QA_W(ntry, wf8(:,11), wf8(:,12), wf64(:,30), n3(:,199), t3x64(:,:,13))
  call prop_W_W(ntry, wf64(:,30), 95, MW, 1_intkind1, wf64(:,31), n2(131))
  call vert_VQ_A(ntry, wf16(:,20), ex6(:), wf32(:,69), n3(:,200), t3x32(:,:,45))
  call prop_Q_A(ntry, wf32(:,69), 117, ZERO, 0_intkind1, wf32(:,70), n2(132))
  call vert_ZQ_A(gZu,ntry, wf16(:,29), ex6(:), wf32(:,71), n3(:,201), t3x32(:,:,46))
  call prop_Q_A(ntry, wf32(:,71), 117, ZERO, 0_intkind1, wf32(:,72), n2(133))
  call vert_AV_Q(ntry, ex8(:), wf16(:,20), wf32(:,73), n3(:,202), t3x32(:,:,47))
  call prop_A_Q(ntry, wf32(:,73), 213, ZERO, 0_intkind1, wf32(:,74), n2(134))
  call vert_AZ_Q(gZd,ntry, ex8(:), wf16(:,29), wf32(:,75), n3(:,203), t3x32(:,:,48))
  call prop_A_Q(ntry, wf32(:,75), 213, ZERO, 0_intkind1, wf32(:,76), n2(135))
  call vert_UV_W(ntry, wf4(:,6), 10, wf16(:,20), 85, wf64(:,32), n3(:,204), t3x64(:,:,14))
  call prop_W_W(ntry, wf64(:,32), 95, MW, 1_intkind1, wf64(:,33), n2(136))
  call vert_UV_W(ntry, wf4(:,6), 10, wf16(:,29), 85, wf64(:,34), n3(:,205), t3x64(:,:,15))
  call prop_W_W(ntry, wf64(:,34), 95, MW, 1_intkind1, wf64(:,35), n2(137))
  call vert_QA_W(ntry, wf8(:,3), wf8(:,4), wf64(:,36), n3(:,206), t3x64(:,:,16))
  call prop_W_W(ntry, wf64(:,36), 175, MW, 1_intkind1, wf64(:,37), n2(138))
  call vert_VQ_A(ntry, wf16(:,11), ex5(:), wf32(:,77), n3(:,207), t3x32(:,:,49))
  call prop_Q_A(ntry, wf32(:,77), 181, ZERO, 0_intkind1, wf32(:,78), n2(139))
  call vert_ZQ_A(gZu,ntry, wf16(:,74), ex5(:), wf32(:,79), n3(:,208), t3x32(:,:,50))
  call prop_Q_A(ntry, wf32(:,79), 181, ZERO, 0_intkind1, wf32(:,80), n2(140))
  call vert_AV_Q(ntry, ex7(:), wf16(:,11), wf32(:,81), n3(:,209), t3x32(:,:,51))
  call prop_A_Q(ntry, wf32(:,81), 229, ZERO, 0_intkind1, wf32(:,82), n2(141))
  call vert_AZ_Q(gZd,ntry, ex7(:), wf16(:,74), wf32(:,83), n3(:,210), t3x32(:,:,52))
  call prop_A_Q(ntry, wf32(:,83), 229, ZERO, 0_intkind1, wf32(:,84), n2(142))
  call vert_UV_W(ntry, wf4(:,6), 10, wf16(:,11), 165, wf64(:,38), n3(:,211), t3x64(:,:,17))
  call prop_W_W(ntry, wf64(:,38), 175, MW, 1_intkind1, wf64(:,39), n2(143))
  call vert_UV_W(ntry, wf4(:,6), 10, wf16(:,74), 165, wf64(:,40), n3(:,212), t3x64(:,:,18))
  call prop_W_W(ntry, wf64(:,40), 175, MW, 1_intkind1, wf64(:,41), n2(144))
  call vert_QA_W(ntry, wf8(:,15), wf8(:,16), wf64(:,42), n3(:,213), t3x64(:,:,19))
  call prop_W_W(ntry, wf64(:,42), 95, MW, 1_intkind1, wf64(:,43), n2(145))
  call vert_VQ_A(ntry, wf16(:,23), ex6(:), wf32(:,85), n3(:,214), t3x32(:,:,53))
  call prop_Q_A(ntry, wf32(:,85), 117, ZERO, 0_intkind1, wf32(:,86), n2(146))
  call vert_ZQ_A(gZu,ntry, wf16(:,33), ex6(:), wf32(:,87), n3(:,215), t3x32(:,:,54))
  call prop_Q_A(ntry, wf32(:,87), 117, ZERO, 0_intkind1, wf32(:,88), n2(147))
  call vert_AV_Q(ntry, ex8(:), wf16(:,23), wf32(:,89), n3(:,216), t3x32(:,:,55))
  call prop_A_Q(ntry, wf32(:,89), 213, ZERO, 0_intkind1, wf32(:,90), n2(148))
  call vert_AZ_Q(gZd,ntry, ex8(:), wf16(:,33), wf32(:,91), n3(:,217), t3x32(:,:,56))
  call prop_A_Q(ntry, wf32(:,91), 213, ZERO, 0_intkind1, wf32(:,92), n2(149))
  call vert_UV_W(ntry, wf4(:,6), 10, wf16(:,23), 85, wf64(:,44), n3(:,218), t3x64(:,:,20))
  call prop_W_W(ntry, wf64(:,44), 95, MW, 1_intkind1, wf64(:,45), n2(150))
  call vert_UV_W(ntry, wf4(:,6), 10, wf16(:,33), 85, wf64(:,46), n3(:,219), t3x64(:,:,21))
  call prop_W_W(ntry, wf64(:,46), 95, MW, 1_intkind1, wf64(:,47), n2(151))
  call vert_QA_W(ntry, wf8(:,7), wf8(:,8), wf64(:,48), n3(:,220), t3x64(:,:,22))
  call prop_W_W(ntry, wf64(:,48), 175, MW, 1_intkind1, wf64(:,49), n2(152))
  call vert_VQ_A(ntry, wf16(:,14), ex5(:), wf32(:,93), n3(:,221), t3x32(:,:,57))
  call prop_Q_A(ntry, wf32(:,93), 181, ZERO, 0_intkind1, wf32(:,94), n2(153))
  call vert_ZQ_A(gZu,ntry, wf16(:,34), ex5(:), wf32(:,95), n3(:,222), t3x32(:,:,58))
  call prop_Q_A(ntry, wf32(:,95), 181, ZERO, 0_intkind1, wf32(:,96), n2(154))
  call vert_AV_Q(ntry, ex7(:), wf16(:,14), wf32(:,97), n3(:,223), t3x32(:,:,59))
  call prop_A_Q(ntry, wf32(:,97), 229, ZERO, 0_intkind1, wf32(:,98), n2(155))
  call vert_AZ_Q(gZd,ntry, ex7(:), wf16(:,34), wf32(:,99), n3(:,224), t3x32(:,:,60))
  call prop_A_Q(ntry, wf32(:,99), 229, ZERO, 0_intkind1, wf32(:,100), n2(156))
  call vert_UV_W(ntry, wf4(:,6), 10, wf16(:,14), 165, wf64(:,50), n3(:,225), t3x64(:,:,23))
  call prop_W_W(ntry, wf64(:,50), 175, MW, 1_intkind1, wf64(:,51), n2(157))
  call vert_UV_W(ntry, wf4(:,6), 10, wf16(:,34), 165, wf64(:,52), n3(:,226), t3x64(:,:,24))
  call prop_W_W(ntry, wf64(:,52), 175, MW, 1_intkind1, wf64(:,53), n2(158))
  call vert_VQ_A(ntry, wf16(:,25), ex6(:), wf32(:,101), n3(:,227), t3x32(:,:,61))
  call prop_Q_A(ntry, wf32(:,101), 122, ZERO, 0_intkind1, wf32(:,102), n2(159))
  call vert_ZQ_A(gZu,ntry, wf16(:,31), ex6(:), wf32(:,103), n3(:,228), t3x32(:,:,62))
  call prop_Q_A(ntry, wf32(:,103), 122, ZERO, 0_intkind1, wf32(:,104), n2(160))
  call vert_AV_Q(ntry, ex8(:), wf16(:,25), wf32(:,105), n3(:,229), t3x32(:,:,63))
  call prop_A_Q(ntry, wf32(:,105), 218, ZERO, 0_intkind1, wf32(:,106), n2(161))
  call vert_AZ_Q(gZd,ntry, ex8(:), wf16(:,31), wf32(:,107), n3(:,230), t3x32(:,:,64))
  call prop_A_Q(ntry, wf32(:,107), 218, ZERO, 0_intkind1, wf32(:,108), n2(162))
  call vert_UV_W(ntry, wf4(:,5), 5, wf16(:,25), 90, wf64(:,54), n3(:,231), t3x64(:,:,25))
  call prop_W_W(ntry, wf64(:,54), 95, MW, 1_intkind1, wf64(:,55), n2(163))
  call vert_UV_W(ntry, wf4(:,5), 5, wf16(:,31), 90, wf64(:,56), n3(:,232), t3x64(:,:,26))
  call prop_W_W(ntry, wf64(:,56), 95, MW, 1_intkind1, wf64(:,57), n2(164))
  call vert_VQ_A(ntry, wf16(:,16), ex5(:), wf32(:,109), n3(:,233), t3x32(:,:,65))
  call prop_Q_A(ntry, wf32(:,109), 186, ZERO, 0_intkind1, wf32(:,110), n2(165))
  call vert_ZQ_A(gZu,ntry, wf16(:,73), ex5(:), wf32(:,111), n3(:,234), t3x32(:,:,66))
  call prop_Q_A(ntry, wf32(:,111), 186, ZERO, 0_intkind1, wf32(:,112), n2(166))
  call vert_AV_Q(ntry, ex7(:), wf16(:,16), wf32(:,113), n3(:,235), t3x32(:,:,67))
  call prop_A_Q(ntry, wf32(:,113), 234, ZERO, 0_intkind1, wf32(:,114), n2(167))
  call vert_AZ_Q(gZd,ntry, ex7(:), wf16(:,73), wf32(:,115), n3(:,236), t3x32(:,:,68))
  call prop_A_Q(ntry, wf32(:,115), 234, ZERO, 0_intkind1, wf32(:,116), n2(168))
  call vert_UV_W(ntry, wf4(:,5), 5, wf16(:,16), 170, wf64(:,58), n3(:,237), t3x64(:,:,27))
  call prop_W_W(ntry, wf64(:,58), 175, MW, 1_intkind1, wf64(:,59), n2(169))
  call vert_UV_W(ntry, wf4(:,5), 5, wf16(:,73), 170, wf64(:,60), n3(:,238), t3x64(:,:,28))
  call prop_W_W(ntry, wf64(:,60), 175, MW, 1_intkind1, wf64(:,61), n2(170))
  call vert_VQ_A(ntry, wf16(:,27), ex6(:), wf32(:,117), n3(:,239), t3x32(:,:,69))
  call prop_Q_A(ntry, wf32(:,117), 122, ZERO, 0_intkind1, wf32(:,118), n2(171))
  call vert_ZQ_A(gZu,ntry, wf16(:,32), ex6(:), wf32(:,119), n3(:,240), t3x32(:,:,70))
  call prop_Q_A(ntry, wf32(:,119), 122, ZERO, 0_intkind1, wf32(:,120), n2(172))
  call vert_AV_Q(ntry, ex8(:), wf16(:,27), wf32(:,121), n3(:,241), t3x32(:,:,71))
  call prop_A_Q(ntry, wf32(:,121), 218, ZERO, 0_intkind1, wf32(:,122), n2(173))
  call vert_AZ_Q(gZd,ntry, ex8(:), wf16(:,32), wf32(:,123), n3(:,242), t3x32(:,:,72))
  call prop_A_Q(ntry, wf32(:,123), 218, ZERO, 0_intkind1, wf32(:,124), n2(174))
  call vert_UV_W(ntry, wf4(:,5), 5, wf16(:,27), 90, wf64(:,62), n3(:,243), t3x64(:,:,29))
  call prop_W_W(ntry, wf64(:,62), 95, MW, 1_intkind1, wf64(:,63), n2(175))
  call vert_UV_W(ntry, wf4(:,5), 5, wf16(:,32), 90, wf64(:,64), n3(:,244), t3x64(:,:,30))
  call prop_W_W(ntry, wf64(:,64), 95, MW, 1_intkind1, wf64(:,65), n2(176))
  call vert_VQ_A(ntry, wf16(:,18), ex5(:), wf32(:,125), n3(:,245), t3x32(:,:,73))
  call prop_Q_A(ntry, wf32(:,125), 186, ZERO, 0_intkind1, wf32(:,126), n2(177))
  call vert_ZQ_A(gZu,ntry, wf16(:,30), ex5(:), wf32(:,127), n3(:,246), t3x32(:,:,74))
  call prop_Q_A(ntry, wf32(:,127), 186, ZERO, 0_intkind1, wf32(:,128), n2(178))
  call vert_AV_Q(ntry, ex7(:), wf16(:,18), wf32(:,129), n3(:,247), t3x32(:,:,75))
  call prop_A_Q(ntry, wf32(:,129), 234, ZERO, 0_intkind1, wf32(:,130), n2(179))
  call vert_AZ_Q(gZd,ntry, ex7(:), wf16(:,30), wf32(:,131), n3(:,248), t3x32(:,:,76))
  call prop_A_Q(ntry, wf32(:,131), 234, ZERO, 0_intkind1, wf32(:,132), n2(180))
  call vert_UV_W(ntry, wf4(:,5), 5, wf16(:,18), 170, wf64(:,66), n3(:,249), t3x64(:,:,31))
  call prop_W_W(ntry, wf64(:,66), 175, MW, 1_intkind1, wf64(:,67), n2(181))
  call vert_UV_W(ntry, wf4(:,5), 5, wf16(:,30), 170, wf64(:,68), n3(:,250), t3x64(:,:,32))
  call prop_W_W(ntry, wf64(:,68), 175, MW, 1_intkind1, wf64(:,69), n2(182))
  call vert_VQ_A(ntry, wf16(:,35), ex6(:), wf32(:,133), n3(:,251), t3x32(:,:,77))
  call prop_Q_A(ntry, wf32(:,133), 122, ZERO, 0_intkind1, wf32(:,134), n2(183))
  call vert_ZQ_A(gZu,ntry, wf16(:,41), ex6(:), wf32(:,135), n3(:,252), t3x32(:,:,78))
  call prop_Q_A(ntry, wf32(:,135), 122, ZERO, 0_intkind1, wf32(:,136), n2(184))
  call vert_AV_Q(ntry, ex8(:), wf16(:,35), wf32(:,137), n3(:,253), t3x32(:,:,79))
  call prop_A_Q(ntry, wf32(:,137), 218, ZERO, 0_intkind1, wf32(:,138), n2(185))
  call vert_AZ_Q(gZd,ntry, ex8(:), wf16(:,41), wf32(:,139), n3(:,254), t3x32(:,:,80))
  call prop_A_Q(ntry, wf32(:,139), 218, ZERO, 0_intkind1, wf32(:,140), n2(186))
  call vert_UV_W(ntry, wf4(:,5), 5, wf16(:,35), 90, wf64(:,70), n3(:,255), t3x64(:,:,33))
  call prop_W_W(ntry, wf64(:,70), 95, MW, 1_intkind1, wf64(:,71), n2(187))
  call vert_UV_W(ntry, wf4(:,5), 5, wf16(:,41), 90, wf64(:,72), n3(:,256), t3x64(:,:,34))
  call prop_W_W(ntry, wf64(:,72), 95, MW, 1_intkind1, wf64(:,73), n2(188))
  call vert_ZQ_A(gZu,ntry, wf16(:,42), ex6(:), wf32(:,141), n3(:,257), t3x32(:,:,81))
  call prop_Q_A(ntry, wf32(:,141), 122, ZERO, 0_intkind1, wf32(:,142), n2(189))
  call vert_AZ_Q(gZd,ntry, ex8(:), wf16(:,42), wf32(:,143), n3(:,258), t3x32(:,:,82))
  call prop_A_Q(ntry, wf32(:,143), 218, ZERO, 0_intkind1, wf32(:,144), n2(190))
  call vert_UV_W(ntry, wf4(:,5), 5, wf16(:,42), 90, wf64(:,74), n3(:,259), t3x64(:,:,35))
  call prop_W_W(ntry, wf64(:,74), 95, MW, 1_intkind1, wf64(:,75), n2(191))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf16(:,5), wf32(:,145), n3(:,260), t3x32(:,:,83))
  call prop_A_Q(ntry, wf32(:,145), 87, ZERO, 0_intkind1, wf32(:,146), n2(192))
  call vert_QA_W(ntry, ex4(:), wf32(:,146), wf64(:,76), n3(:,261), t3x64(:,:,36))
  call prop_W_W(ntry, wf64(:,76), 95, MW, 1_intkind1, wf64(:,77), n2(193))
  call vert_VQ_A(ntry, wf16(:,3), ex4(:), wf32(:,147), n3(:,262), t3x32(:,:,84))
  call prop_Q_A(ntry, wf32(:,147), 93, ZERO, 0_intkind1, wf32(:,148), n2(194))
  call vert_QA_W(ntry, wf32(:,148), ex2(:), wf64(:,78), n3(:,263), t3x64(:,:,37))
  call prop_W_W(ntry, wf64(:,78), 95, MW, 1_intkind1, wf64(:,79), n2(195))
  call vert_ZQ_A(gZl,ntry, wf16(:,5), ex4(:), wf32(:,149), n3(:,264), t3x32(:,:,85))
  call prop_Q_A(ntry, wf32(:,149), 93, ZERO, 0_intkind1, wf32(:,150), n2(196))
  call vert_QA_W(ntry, wf32(:,150), ex2(:), wf64(:,80), n3(:,265), t3x64(:,:,38))
  call prop_W_W(ntry, wf64(:,80), 95, MW, 1_intkind1, wf64(:,81), n2(197))
  call prop_A_Q(ntry, wf32(:,5), 87, ZERO, 0_intkind1, wf32(:,151), n2(198))
  call vert_QA_W(ntry, ex4(:), wf32(:,151), wf64(:,82), n3(:,266), t3x64(:,:,39))
  call prop_W_W(ntry, wf64(:,82), 95, MW, 1_intkind1, wf64(:,83), n2(199))
  call vert_WQ_A(ntry, wf4(:,5), wf8(:,22), wf32(:,152), n3(:,267), t3x32(:,:,86))
  call prop_Q_A(ntry, wf32(:,152), 93, ZERO, 0_intkind1, wf32(:,153), n2(200))
  call vert_QA_W(ntry, wf32(:,153), ex2(:), wf64(:,84), n3(:,268), t3x64(:,:,40))
  call prop_W_W(ntry, wf64(:,84), 95, MW, 1_intkind1, wf64(:,85), n2(201))
  call vert_ZQ_A(gZu,ntry, wf16(:,44), ex5(:), wf32(:,154), n3(:,269), t3x32(:,:,87))
  call prop_Q_A(ntry, wf32(:,154), 186, ZERO, 0_intkind1, wf32(:,155), n2(202))
  call vert_VQ_A(ntry, wf16(:,37), ex5(:), wf32(:,156), n3(:,270), t3x32(:,:,88))
  call prop_Q_A(ntry, wf32(:,156), 186, ZERO, 0_intkind1, wf32(:,157), n2(203))
  call vert_ZQ_A(gZu,ntry, wf16(:,43), ex5(:), wf32(:,158), n3(:,271), t3x32(:,:,89))
  call prop_Q_A(ntry, wf32(:,158), 186, ZERO, 0_intkind1, wf32(:,159), n2(204))
  call vert_AV_Q(ntry, ex7(:), wf16(:,37), wf32(:,160), n3(:,272), t3x32(:,:,90))
  call prop_A_Q(ntry, wf32(:,160), 234, ZERO, 0_intkind1, wf32(:,161), n2(205))
  call vert_AZ_Q(gZd,ntry, ex7(:), wf16(:,43), wf32(:,162), n3(:,273), t3x32(:,:,91))
  call prop_A_Q(ntry, wf32(:,162), 234, ZERO, 0_intkind1, wf32(:,163), n2(206))
  call vert_UV_W(ntry, wf4(:,5), 5, wf16(:,37), 170, wf64(:,86), n3(:,274), t3x64(:,:,41))
  call prop_W_W(ntry, wf64(:,86), 175, MW, 1_intkind1, wf64(:,87), n2(207))
  call vert_UV_W(ntry, wf4(:,5), 5, wf16(:,43), 170, wf64(:,88), n3(:,275), t3x64(:,:,42))
  call prop_W_W(ntry, wf64(:,88), 175, MW, 1_intkind1, wf64(:,89), n2(208))
  call vert_AZ_Q(gZd,ntry, ex7(:), wf16(:,44), wf32(:,164), n3(:,276), t3x32(:,:,92))
  call prop_A_Q(ntry, wf32(:,164), 234, ZERO, 0_intkind1, wf32(:,165), n2(209))
  call vert_UV_W(ntry, wf4(:,5), 5, wf16(:,44), 170, wf64(:,90), n3(:,277), t3x64(:,:,43))
  call prop_W_W(ntry, wf64(:,90), 175, MW, 1_intkind1, wf64(:,91), n2(210))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf16(:,10), wf32(:,166), n3(:,278), t3x32(:,:,93))
  call prop_A_Q(ntry, wf32(:,166), 167, ZERO, 0_intkind1, wf32(:,167), n2(211))
  call vert_QA_W(ntry, ex4(:), wf32(:,167), wf64(:,92), n3(:,279), t3x64(:,:,44))
  call prop_W_W(ntry, wf64(:,92), 175, MW, 1_intkind1, wf64(:,93), n2(212))
  call vert_VQ_A(ntry, wf16(:,8), ex4(:), wf32(:,168), n3(:,280), t3x32(:,:,94))
  call prop_Q_A(ntry, wf32(:,168), 173, ZERO, 0_intkind1, wf32(:,169), n2(213))
  call vert_QA_W(ntry, wf32(:,169), ex2(:), wf64(:,94), n3(:,281), t3x64(:,:,45))
  call prop_W_W(ntry, wf64(:,94), 175, MW, 1_intkind1, wf64(:,95), n2(214))
  call vert_ZQ_A(gZl,ntry, wf16(:,10), ex4(:), wf32(:,170), n3(:,282), t3x32(:,:,95))
  call prop_Q_A(ntry, wf32(:,170), 173, ZERO, 0_intkind1, wf32(:,171), n2(215))
  call vert_QA_W(ntry, wf32(:,171), ex2(:), wf64(:,96), n3(:,283), t3x64(:,:,46))
  call prop_W_W(ntry, wf64(:,96), 175, MW, 1_intkind1, wf64(:,97), n2(216))
  call prop_A_Q(ntry, wf32(:,6), 167, ZERO, 0_intkind1, wf32(:,172), n2(217))
  call vert_QA_W(ntry, ex4(:), wf32(:,172), wf64(:,98), n3(:,284), t3x64(:,:,47))
  call prop_W_W(ntry, wf64(:,98), 175, MW, 1_intkind1, wf64(:,99), n2(218))
  call vert_WQ_A(ntry, wf4(:,5), wf8(:,24), wf32(:,173), n3(:,285), t3x32(:,:,96))
  call prop_Q_A(ntry, wf32(:,173), 173, ZERO, 0_intkind1, wf32(:,174), n2(219))
  call vert_QA_W(ntry, wf32(:,174), ex2(:), wf64(:,100), n3(:,286), t3x64(:,:,48))
  call prop_W_W(ntry, wf64(:,100), 175, MW, 1_intkind1, wf64(:,101), n2(220))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf16(:,29), wf32(:,175), n3(:,287), t3x32(:,:,97))
  call prop_A_Q(ntry, wf32(:,175), 87, ZERO, 0_intkind1, wf32(:,176), n2(221))
  call vert_QA_W(ntry, ex4(:), wf32(:,176), wf64(:,102), n3(:,288), t3x64(:,:,49))
  call prop_W_W(ntry, wf64(:,102), 95, MW, 1_intkind1, wf64(:,103), n2(222))
  call vert_VQ_A(ntry, wf16(:,20), ex4(:), wf32(:,177), n3(:,289), t3x32(:,:,98))
  call prop_Q_A(ntry, wf32(:,177), 93, ZERO, 0_intkind1, wf32(:,178), n2(223))
  call vert_QA_W(ntry, wf32(:,178), ex2(:), wf64(:,104), n3(:,290), t3x64(:,:,50))
  call prop_W_W(ntry, wf64(:,104), 95, MW, 1_intkind1, wf64(:,105), n2(224))
  call vert_ZQ_A(gZl,ntry, wf16(:,29), ex4(:), wf32(:,179), n3(:,291), t3x32(:,:,99))
  call prop_Q_A(ntry, wf32(:,179), 93, ZERO, 0_intkind1, wf32(:,180), n2(225))
  call vert_QA_W(ntry, wf32(:,180), ex2(:), wf64(:,106), n3(:,292), t3x64(:,:,51))
  call prop_W_W(ntry, wf64(:,106), 95, MW, 1_intkind1, wf64(:,107), n2(226))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf16(:,74), wf32(:,181), n3(:,293), t3x32(:,:,100))
  call prop_A_Q(ntry, wf32(:,181), 167, ZERO, 0_intkind1, wf32(:,182), n2(227))
  call vert_QA_W(ntry, ex4(:), wf32(:,182), wf64(:,108), n3(:,294), t3x64(:,:,52))
  call prop_W_W(ntry, wf64(:,108), 175, MW, 1_intkind1, wf64(:,109), n2(228))
  call vert_VQ_A(ntry, wf16(:,11), ex4(:), wf32(:,183), n3(:,295), t3x32(:,:,101))
  call prop_Q_A(ntry, wf32(:,183), 173, ZERO, 0_intkind1, wf32(:,184), n2(229))
  call vert_QA_W(ntry, wf32(:,184), ex2(:), wf64(:,110), n3(:,296), t3x64(:,:,53))
  call prop_W_W(ntry, wf64(:,110), 175, MW, 1_intkind1, wf64(:,111), n2(230))
  call vert_ZQ_A(gZl,ntry, wf16(:,74), ex4(:), wf32(:,185), n3(:,297), t3x32(:,:,102))
  call prop_Q_A(ntry, wf32(:,185), 173, ZERO, 0_intkind1, wf32(:,186), n2(231))
  call vert_QA_W(ntry, wf32(:,186), ex2(:), wf64(:,112), n3(:,298), t3x64(:,:,54))
  call prop_W_W(ntry, wf64(:,112), 175, MW, 1_intkind1, wf64(:,113), n2(232))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf16(:,33), wf32(:,187), n3(:,299), t3x32(:,:,103))
  call prop_A_Q(ntry, wf32(:,187), 87, ZERO, 0_intkind1, wf32(:,188), n2(233))
  call vert_QA_W(ntry, ex4(:), wf32(:,188), wf64(:,114), n3(:,300), t3x64(:,:,55))
  call prop_W_W(ntry, wf64(:,114), 95, MW, 1_intkind1, wf64(:,115), n2(234))
  call vert_VQ_A(ntry, wf16(:,23), ex4(:), wf32(:,189), n3(:,301), t3x32(:,:,104))
  call prop_Q_A(ntry, wf32(:,189), 93, ZERO, 0_intkind1, wf32(:,190), n2(235))
  call vert_QA_W(ntry, wf32(:,190), ex2(:), wf64(:,116), n3(:,302), t3x64(:,:,56))
  call prop_W_W(ntry, wf64(:,116), 95, MW, 1_intkind1, wf64(:,117), n2(236))
  call vert_ZQ_A(gZl,ntry, wf16(:,33), ex4(:), wf32(:,191), n3(:,303), t3x32(:,:,105))
  call prop_Q_A(ntry, wf32(:,191), 93, ZERO, 0_intkind1, wf32(:,192), n2(237))
  call vert_QA_W(ntry, wf32(:,192), ex2(:), wf64(:,118), n3(:,304), t3x64(:,:,57))
  call prop_W_W(ntry, wf64(:,118), 95, MW, 1_intkind1, wf64(:,119), n2(238))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf16(:,34), wf32(:,193), n3(:,305), t3x32(:,:,106))
  call prop_A_Q(ntry, wf32(:,193), 167, ZERO, 0_intkind1, wf32(:,194), n2(239))
  call vert_QA_W(ntry, ex4(:), wf32(:,194), wf64(:,120), n3(:,306), t3x64(:,:,58))
  call prop_W_W(ntry, wf64(:,120), 175, MW, 1_intkind1, wf64(:,121), n2(240))
  call vert_VQ_A(ntry, wf16(:,14), ex4(:), wf32(:,195), n3(:,307), t3x32(:,:,107))
  call prop_Q_A(ntry, wf32(:,195), 173, ZERO, 0_intkind1, wf32(:,196), n2(241))
  call vert_QA_W(ntry, wf32(:,196), ex2(:), wf64(:,122), n3(:,308), t3x64(:,:,59))
  call prop_W_W(ntry, wf64(:,122), 175, MW, 1_intkind1, wf64(:,123), n2(242))
  call vert_ZQ_A(gZl,ntry, wf16(:,34), ex4(:), wf32(:,197), n3(:,309), t3x32(:,:,108))
  call prop_Q_A(ntry, wf32(:,197), 173, ZERO, 0_intkind1, wf32(:,198), n2(243))
  call vert_QA_W(ntry, wf32(:,198), ex2(:), wf64(:,124), n3(:,310), t3x64(:,:,60))
  call prop_W_W(ntry, wf64(:,124), 175, MW, 1_intkind1, wf64(:,125), n2(244))
  call vert_VQ_A(ntry, wf16(:,45), ex6(:), wf32(:,199), n3(:,311), t3x32(:,:,109))
  call prop_Q_A(ntry, wf32(:,199), 117, ZERO, 0_intkind1, wf32(:,200), n2(245))
  call vert_ZQ_A(gZu,ntry, wf16(:,51), ex6(:), wf32(:,201), n3(:,312), t3x32(:,:,110))
  call prop_Q_A(ntry, wf32(:,201), 117, ZERO, 0_intkind1, wf32(:,202), n2(246))
  call vert_AV_Q(ntry, ex8(:), wf16(:,45), wf32(:,203), n3(:,313), t3x32(:,:,111))
  call prop_A_Q(ntry, wf32(:,203), 213, ZERO, 0_intkind1, wf32(:,204), n2(247))
  call vert_AZ_Q(gZd,ntry, ex8(:), wf16(:,51), wf32(:,205), n3(:,314), t3x32(:,:,112))
  call prop_A_Q(ntry, wf32(:,205), 213, ZERO, 0_intkind1, wf32(:,206), n2(248))
  call vert_UV_W(ntry, wf4(:,6), 10, wf16(:,45), 85, wf64(:,126), n3(:,315), t3x64(:,:,61))
  call prop_W_W(ntry, wf64(:,126), 95, MW, 1_intkind1, wf64(:,127), n2(249))
  call vert_UV_W(ntry, wf4(:,6), 10, wf16(:,51), 85, wf64(:,128), n3(:,316), t3x64(:,:,62))
  call prop_W_W(ntry, wf64(:,128), 95, MW, 1_intkind1, wf64(:,129), n2(250))
  call vert_ZQ_A(gZu,ntry, wf16(:,52), ex6(:), wf32(:,207), n3(:,317), t3x32(:,:,113))
  call prop_Q_A(ntry, wf32(:,207), 117, ZERO, 0_intkind1, wf32(:,208), n2(251))
  call vert_AZ_Q(gZd,ntry, ex8(:), wf16(:,52), wf32(:,209), n3(:,318), t3x32(:,:,114))
  call prop_A_Q(ntry, wf32(:,209), 213, ZERO, 0_intkind1, wf32(:,210), n2(252))
  call vert_UV_W(ntry, wf4(:,6), 10, wf16(:,52), 85, wf64(:,130), n3(:,319), t3x64(:,:,63))
  call prop_W_W(ntry, wf64(:,130), 95, MW, 1_intkind1, wf64(:,131), n2(253))
  call vert_AZ_Q(gZn,ntry, ex1(:), wf16(:,12), wf32(:,211), n3(:,320), t3x32(:,:,115))
  call prop_A_Q(ntry, wf32(:,211), 91, ZERO, 0_intkind1, wf32(:,212), n2(254))
  call vert_QA_W(ntry, ex3(:), wf32(:,212), wf64(:,132), n3(:,321), t3x64(:,:,64))
  call prop_W_W(ntry, wf64(:,132), 95, MW, 1_intkind1, wf64(:,133), n2(255))
  call vert_VQ_A(ntry, wf16(:,9), ex3(:), wf32(:,213), n3(:,322), t3x32(:,:,116))
  call prop_Q_A(ntry, wf32(:,213), 94, ZERO, 0_intkind1, wf32(:,214), n2(256))
  call vert_QA_W(ntry, wf32(:,214), ex1(:), wf64(:,134), n3(:,323), t3x64(:,:,65))
  call prop_W_W(ntry, wf64(:,134), 95, MW, 1_intkind1, wf64(:,135), n2(257))
  call vert_ZQ_A(gZl,ntry, wf16(:,12), ex3(:), wf32(:,215), n3(:,324), t3x32(:,:,117))
  call prop_Q_A(ntry, wf32(:,215), 94, ZERO, 0_intkind1, wf32(:,216), n2(258))
  call vert_QA_W(ntry, wf32(:,216), ex1(:), wf64(:,136), n3(:,325), t3x64(:,:,66))
  call prop_W_W(ntry, wf64(:,136), 95, MW, 1_intkind1, wf64(:,137), n2(259))
  call prop_A_Q(ntry, wf32(:,7), 91, ZERO, 0_intkind1, wf32(:,217), n2(260))
  call vert_QA_W(ntry, ex3(:), wf32(:,217), wf64(:,138), n3(:,326), t3x64(:,:,67))
  call prop_W_W(ntry, wf64(:,138), 95, MW, 1_intkind1, wf64(:,139), n2(261))
  call vert_WQ_A(ntry, wf4(:,6), wf8(:,30), wf32(:,218), n3(:,327), t3x32(:,:,118))
  call prop_Q_A(ntry, wf32(:,218), 94, ZERO, 0_intkind1, wf32(:,219), n2(262))
  call vert_QA_W(ntry, wf32(:,219), ex1(:), wf64(:,140), n3(:,328), t3x64(:,:,68))
  call prop_W_W(ntry, wf64(:,140), 95, MW, 1_intkind1, wf64(:,141), n2(263))
  call vert_ZQ_A(gZu,ntry, wf16(:,53), ex5(:), wf32(:,220), n3(:,329), t3x32(:,:,119))
  call prop_Q_A(ntry, wf32(:,220), 181, ZERO, 0_intkind1, wf32(:,221), n2(264))
  call vert_VQ_A(ntry, wf16(:,47), ex5(:), wf32(:,222), n3(:,330), t3x32(:,:,120))
  call prop_Q_A(ntry, wf32(:,222), 181, ZERO, 0_intkind1, wf32(:,223), n2(265))
  call vert_ZQ_A(gZu,ntry, wf16(:,54), ex5(:), wf32(:,224), n3(:,331), t3x32(:,:,121))
  call prop_Q_A(ntry, wf32(:,224), 181, ZERO, 0_intkind1, wf32(:,225), n2(266))
  call vert_AV_Q(ntry, ex7(:), wf16(:,47), wf32(:,226), n3(:,332), t3x32(:,:,122))
  call prop_A_Q(ntry, wf32(:,226), 229, ZERO, 0_intkind1, wf32(:,227), n2(267))
  call vert_AZ_Q(gZd,ntry, ex7(:), wf16(:,54), wf32(:,228), n3(:,333), t3x32(:,:,123))
  call prop_A_Q(ntry, wf32(:,228), 229, ZERO, 0_intkind1, wf32(:,229), n2(268))
  call vert_UV_W(ntry, wf4(:,6), 10, wf16(:,47), 165, wf64(:,142), n3(:,334), t3x64(:,:,69))
  call prop_W_W(ntry, wf64(:,142), 175, MW, 1_intkind1, wf64(:,143), n2(269))
  call vert_UV_W(ntry, wf4(:,6), 10, wf16(:,54), 165, wf64(:,144), n3(:,335), t3x64(:,:,70))
  call prop_W_W(ntry, wf64(:,144), 175, MW, 1_intkind1, wf64(:,145), n2(270))
  call vert_AZ_Q(gZd,ntry, ex7(:), wf16(:,53), wf32(:,230), n3(:,336), t3x32(:,:,124))
  call prop_A_Q(ntry, wf32(:,230), 229, ZERO, 0_intkind1, wf32(:,231), n2(271))
  call vert_UV_W(ntry, wf4(:,6), 10, wf16(:,53), 165, wf64(:,146), n3(:,337), t3x64(:,:,71))
  call prop_W_W(ntry, wf64(:,146), 175, MW, 1_intkind1, wf64(:,147), n2(272))
  call vert_AZ_Q(gZn,ntry, ex1(:), wf16(:,21), wf32(:,232), n3(:,338), t3x32(:,:,125))
  call prop_A_Q(ntry, wf32(:,232), 171, ZERO, 0_intkind1, wf32(:,233), n2(273))
  call vert_QA_W(ntry, ex3(:), wf32(:,233), wf64(:,148), n3(:,339), t3x64(:,:,72))
  call prop_W_W(ntry, wf64(:,148), 175, MW, 1_intkind1, wf64(:,149), n2(274))
  call vert_VQ_A(ntry, wf16(:,4), ex3(:), wf32(:,234), n3(:,340), t3x32(:,:,126))
  call prop_Q_A(ntry, wf32(:,234), 174, ZERO, 0_intkind1, wf32(:,235), n2(275))
  call vert_QA_W(ntry, wf32(:,235), ex1(:), wf64(:,150), n3(:,341), t3x64(:,:,73))
  call prop_W_W(ntry, wf64(:,150), 175, MW, 1_intkind1, wf64(:,151), n2(276))
  call vert_ZQ_A(gZl,ntry, wf16(:,21), ex3(:), wf32(:,236), n3(:,342), t3x32(:,:,127))
  call prop_Q_A(ntry, wf32(:,236), 174, ZERO, 0_intkind1, wf32(:,237), n2(277))
  call vert_QA_W(ntry, wf32(:,237), ex1(:), wf64(:,152), n3(:,343), t3x64(:,:,74))
  call prop_W_W(ntry, wf64(:,152), 175, MW, 1_intkind1, wf64(:,153), n2(278))
  call prop_A_Q(ntry, wf32(:,8), 171, ZERO, 0_intkind1, wf32(:,238), n2(279))
  call vert_QA_W(ntry, ex3(:), wf32(:,238), wf64(:,154), n3(:,344), t3x64(:,:,75))
  call prop_W_W(ntry, wf64(:,154), 175, MW, 1_intkind1, wf64(:,155), n2(280))
  call vert_WQ_A(ntry, wf4(:,6), wf8(:,32), wf32(:,239), n3(:,345), t3x32(:,:,128))
  call prop_Q_A(ntry, wf32(:,239), 174, ZERO, 0_intkind1, wf32(:,240), n2(281))
  call vert_QA_W(ntry, wf32(:,240), ex1(:), wf64(:,156), n3(:,346), t3x64(:,:,76))
  call prop_W_W(ntry, wf64(:,156), 175, MW, 1_intkind1, wf64(:,157), n2(282))
  call vert_AZ_Q(gZn,ntry, ex1(:), wf16(:,32), wf32(:,241), n3(:,347), t3x32(:,:,129))
  call prop_A_Q(ntry, wf32(:,241), 91, ZERO, 0_intkind1, wf32(:,242), n2(283))
  call vert_QA_W(ntry, ex3(:), wf32(:,242), wf64(:,158), n3(:,348), t3x64(:,:,77))
  call prop_W_W(ntry, wf64(:,158), 95, MW, 1_intkind1, wf64(:,159), n2(284))
  call vert_AZ_Q(gZn,ntry, ex1(:), wf16(:,30), wf32(:,243), n3(:,349), t3x32(:,:,130))
  call prop_A_Q(ntry, wf32(:,243), 171, ZERO, 0_intkind1, wf32(:,244), n2(285))
  call vert_QA_W(ntry, ex3(:), wf32(:,244), wf64(:,160), n3(:,350), t3x64(:,:,78))
  call prop_W_W(ntry, wf64(:,160), 175, MW, 1_intkind1, wf64(:,161), n2(286))
  call vert_AZ_Q(gZn,ntry, ex1(:), wf16(:,31), wf32(:,245), n3(:,351), t3x32(:,:,131))
  call prop_A_Q(ntry, wf32(:,245), 91, ZERO, 0_intkind1, wf32(:,246), n2(287))
  call vert_QA_W(ntry, ex3(:), wf32(:,246), wf64(:,162), n3(:,352), t3x64(:,:,79))
  call prop_W_W(ntry, wf64(:,162), 95, MW, 1_intkind1, wf64(:,163), n2(288))
  call vert_AZ_Q(gZn,ntry, ex1(:), wf16(:,73), wf32(:,247), n3(:,353), t3x32(:,:,132))
  call prop_A_Q(ntry, wf32(:,247), 171, ZERO, 0_intkind1, wf32(:,248), n2(289))
  call vert_QA_W(ntry, ex3(:), wf32(:,248), wf64(:,164), n3(:,354), t3x64(:,:,80))
  call prop_W_W(ntry, wf64(:,164), 175, MW, 1_intkind1, wf64(:,165), n2(290))
  call vert_VQ_A(ntry, wf16(:,25), ex3(:), wf32(:,249), n3(:,355), t3x32(:,:,133))
  call prop_Q_A(ntry, wf32(:,249), 94, ZERO, 0_intkind1, wf32(:,250), n2(291))
  call vert_QA_W(ntry, wf32(:,250), ex1(:), wf64(:,166), n3(:,356), t3x64(:,:,81))
  call prop_W_W(ntry, wf64(:,166), 95, MW, 1_intkind1, wf64(:,167), n2(292))
  call vert_ZQ_A(gZl,ntry, wf16(:,31), ex3(:), wf32(:,251), n3(:,357), t3x32(:,:,134))
  call prop_Q_A(ntry, wf32(:,251), 94, ZERO, 0_intkind1, wf32(:,252), n2(293))
  call vert_QA_W(ntry, wf32(:,252), ex1(:), wf64(:,168), n3(:,358), t3x64(:,:,82))
  call prop_W_W(ntry, wf64(:,168), 95, MW, 1_intkind1, wf64(:,169), n2(294))
  call vert_VQ_A(ntry, wf16(:,16), ex3(:), wf32(:,253), n3(:,359), t3x32(:,:,135))
  call prop_Q_A(ntry, wf32(:,253), 174, ZERO, 0_intkind1, wf32(:,254), n2(295))
  call vert_QA_W(ntry, wf32(:,254), ex1(:), wf64(:,170), n3(:,360), t3x64(:,:,83))
  call prop_W_W(ntry, wf64(:,170), 175, MW, 1_intkind1, wf64(:,171), n2(296))
  call vert_ZQ_A(gZl,ntry, wf16(:,73), ex3(:), wf32(:,255), n3(:,361), t3x32(:,:,136))
  call prop_Q_A(ntry, wf32(:,255), 174, ZERO, 0_intkind1, wf32(:,256), n2(297))
  call vert_QA_W(ntry, wf32(:,256), ex1(:), wf64(:,172), n3(:,362), t3x64(:,:,84))
  call prop_W_W(ntry, wf64(:,172), 175, MW, 1_intkind1, wf64(:,173), n2(298))
  call vert_VQ_A(ntry, wf16(:,27), ex3(:), wf32(:,257), n3(:,363), t3x32(:,:,137))
  call prop_Q_A(ntry, wf32(:,257), 94, ZERO, 0_intkind1, wf32(:,258), n2(299))
  call vert_QA_W(ntry, wf32(:,258), ex1(:), wf64(:,174), n3(:,364), t3x64(:,:,85))
  call prop_W_W(ntry, wf64(:,174), 95, MW, 1_intkind1, wf64(:,175), n2(300))
  call vert_ZQ_A(gZl,ntry, wf16(:,32), ex3(:), wf32(:,259), n3(:,365), t3x32(:,:,138))
  call prop_Q_A(ntry, wf32(:,259), 94, ZERO, 0_intkind1, wf32(:,260), n2(301))
  call vert_QA_W(ntry, wf32(:,260), ex1(:), wf64(:,176), n3(:,366), t3x64(:,:,86))
  call prop_W_W(ntry, wf64(:,176), 95, MW, 1_intkind1, wf64(:,177), n2(302))
  call vert_VQ_A(ntry, wf16(:,18), ex3(:), wf32(:,261), n3(:,367), t3x32(:,:,139))
  call prop_Q_A(ntry, wf32(:,261), 174, ZERO, 0_intkind1, wf32(:,262), n2(303))
  call vert_QA_W(ntry, wf32(:,262), ex1(:), wf64(:,178), n3(:,368), t3x64(:,:,87))
  call prop_W_W(ntry, wf64(:,178), 175, MW, 1_intkind1, wf64(:,179), n2(304))
  call vert_ZQ_A(gZl,ntry, wf16(:,30), ex3(:), wf32(:,263), n3(:,369), t3x32(:,:,140))
  call prop_Q_A(ntry, wf32(:,263), 174, ZERO, 0_intkind1, wf32(:,264), n2(305))
  call vert_QA_W(ntry, wf32(:,264), ex1(:), wf64(:,180), n3(:,370), t3x64(:,:,88))
  call prop_W_W(ntry, wf64(:,180), 175, MW, 1_intkind1, wf64(:,181), n2(306))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf16(:,52), wf32(:,265), n3(:,371), t3x32(:,:,141))
  call prop_A_Q(ntry, wf32(:,265), 87, ZERO, 0_intkind1, wf32(:,266), n2(307))
  call vert_QA_W(ntry, ex4(:), wf32(:,266), wf64(:,182), n3(:,372), t3x64(:,:,89))
  call prop_W_W(ntry, wf64(:,182), 95, MW, 1_intkind1, wf64(:,183), n2(308))
  call vert_AZ_Q(gZn,ntry, ex1(:), wf16(:,42), wf32(:,267), n3(:,373), t3x32(:,:,142))
  call prop_A_Q(ntry, wf32(:,267), 91, ZERO, 0_intkind1, wf32(:,268), n2(309))
  call vert_QA_W(ntry, ex3(:), wf32(:,268), wf64(:,184), n3(:,374), t3x64(:,:,90))
  call prop_W_W(ntry, wf64(:,184), 95, MW, 1_intkind1, wf64(:,185), n2(310))
  call vert_AZ_Q(gZn,ntry, ex1(:), wf16(:,41), wf32(:,269), n3(:,375), t3x32(:,:,143))
  call prop_A_Q(ntry, wf32(:,269), 91, ZERO, 0_intkind1, wf32(:,270), n2(311))
  call vert_QA_W(ntry, ex3(:), wf32(:,270), wf64(:,186), n3(:,376), t3x64(:,:,91))
  call prop_W_W(ntry, wf64(:,186), 95, MW, 1_intkind1, wf64(:,187), n2(312))
  call vert_ZQ_A(gZl,ntry, wf16(:,52), ex4(:), wf32(:,271), n3(:,377), t3x32(:,:,144))
  call prop_Q_A(ntry, wf32(:,271), 93, ZERO, 0_intkind1, wf32(:,272), n2(313))
  call vert_QA_W(ntry, wf32(:,272), ex2(:), wf64(:,188), n3(:,378), t3x64(:,:,92))
  call prop_W_W(ntry, wf64(:,188), 95, MW, 1_intkind1, wf64(:,189), n2(314))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf16(:,51), wf32(:,273), n3(:,379), t3x32(:,:,145))
  call prop_A_Q(ntry, wf32(:,273), 87, ZERO, 0_intkind1, wf32(:,274), n2(315))
  call vert_QA_W(ntry, ex4(:), wf32(:,274), wf64(:,190), n3(:,380), t3x64(:,:,93))
  call prop_W_W(ntry, wf64(:,190), 95, MW, 1_intkind1, wf64(:,191), n2(316))
  call vert_VQ_A(ntry, wf16(:,45), ex4(:), wf32(:,275), n3(:,381), t3x32(:,:,146))
  call prop_Q_A(ntry, wf32(:,275), 93, ZERO, 0_intkind1, wf32(:,276), n2(317))
  call vert_QA_W(ntry, wf32(:,276), ex2(:), wf64(:,192), n3(:,382), t3x64(:,:,94))
  call prop_W_W(ntry, wf64(:,192), 95, MW, 1_intkind1, wf64(:,193), n2(318))
  call vert_ZQ_A(gZl,ntry, wf16(:,51), ex4(:), wf32(:,277), n3(:,383), t3x32(:,:,147))
  call prop_Q_A(ntry, wf32(:,277), 93, ZERO, 0_intkind1, wf32(:,278), n2(319))
  call vert_QA_W(ntry, wf32(:,278), ex2(:), wf64(:,194), n3(:,384), t3x64(:,:,95))
  call prop_W_W(ntry, wf64(:,194), 95, MW, 1_intkind1, wf64(:,195), n2(320))
  call vert_ZQ_A(gZl,ntry, wf16(:,42), ex3(:), wf32(:,279), n3(:,385), t3x32(:,:,148))
  call prop_Q_A(ntry, wf32(:,279), 94, ZERO, 0_intkind1, wf32(:,280), n2(321))
  call vert_QA_W(ntry, wf32(:,280), ex1(:), wf64(:,196), n3(:,386), t3x64(:,:,96))
  call prop_W_W(ntry, wf64(:,196), 95, MW, 1_intkind1, wf64(:,197), n2(322))
  call vert_VQ_A(ntry, wf16(:,35), ex3(:), wf32(:,281), n3(:,387), t3x32(:,:,149))
  call prop_Q_A(ntry, wf32(:,281), 94, ZERO, 0_intkind1, wf32(:,282), n2(323))
  call vert_QA_W(ntry, wf32(:,282), ex1(:), wf64(:,198), n3(:,388), t3x64(:,:,97))
  call prop_W_W(ntry, wf64(:,198), 95, MW, 1_intkind1, wf64(:,199), n2(324))
  call vert_ZQ_A(gZl,ntry, wf16(:,41), ex3(:), wf32(:,283), n3(:,389), t3x32(:,:,150))
  call prop_Q_A(ntry, wf32(:,283), 94, ZERO, 0_intkind1, wf32(:,284), n2(325))
  call vert_QA_W(ntry, wf32(:,284), ex1(:), wf64(:,200), n3(:,390), t3x64(:,:,98))
  call prop_W_W(ntry, wf64(:,200), 95, MW, 1_intkind1, wf64(:,201), n2(326))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf16(:,53), wf32(:,285), n3(:,391), t3x32(:,:,151))
  call prop_A_Q(ntry, wf32(:,285), 167, ZERO, 0_intkind1, wf32(:,286), n2(327))
  call vert_QA_W(ntry, ex4(:), wf32(:,286), wf64(:,202), n3(:,392), t3x64(:,:,99))
  call prop_W_W(ntry, wf64(:,202), 175, MW, 1_intkind1, wf64(:,203), n2(328))
  call vert_AZ_Q(gZn,ntry, ex1(:), wf16(:,44), wf32(:,287), n3(:,393), t3x32(:,:,152))
  call prop_A_Q(ntry, wf32(:,287), 171, ZERO, 0_intkind1, wf32(:,288), n2(329))
  call vert_QA_W(ntry, ex3(:), wf32(:,288), wf64(:,204), n3(:,394), t3x64(:,:,100))
  call prop_W_W(ntry, wf64(:,204), 175, MW, 1_intkind1, wf64(:,205), n2(330))
  call vert_AZ_Q(gZn,ntry, ex1(:), wf16(:,43), wf32(:,289), n3(:,395), t3x32(:,:,153))
  call prop_A_Q(ntry, wf32(:,289), 171, ZERO, 0_intkind1, wf32(:,290), n2(331))
  call vert_QA_W(ntry, ex3(:), wf32(:,290), wf64(:,206), n3(:,396), t3x64(:,:,101))
  call prop_W_W(ntry, wf64(:,206), 175, MW, 1_intkind1, wf64(:,207), n2(332))
  call vert_ZQ_A(gZl,ntry, wf16(:,53), ex4(:), wf32(:,291), n3(:,397), t3x32(:,:,154))
  call prop_Q_A(ntry, wf32(:,291), 173, ZERO, 0_intkind1, wf32(:,292), n2(333))
  call vert_QA_W(ntry, wf32(:,292), ex2(:), wf64(:,208), n3(:,398), t3x64(:,:,102))
  call prop_W_W(ntry, wf64(:,208), 175, MW, 1_intkind1, wf64(:,209), n2(334))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf16(:,54), wf32(:,293), n3(:,399), t3x32(:,:,155))
  call prop_A_Q(ntry, wf32(:,293), 167, ZERO, 0_intkind1, wf32(:,294), n2(335))
  call vert_QA_W(ntry, ex4(:), wf32(:,294), wf64(:,210), n3(:,400), t3x64(:,:,103))
  call prop_W_W(ntry, wf64(:,210), 175, MW, 1_intkind1, wf64(:,211), n2(336))
  call vert_VQ_A(ntry, wf16(:,47), ex4(:), wf32(:,295), n3(:,401), t3x32(:,:,156))
  call prop_Q_A(ntry, wf32(:,295), 173, ZERO, 0_intkind1, wf32(:,296), n2(337))
  call vert_QA_W(ntry, wf32(:,296), ex2(:), wf64(:,212), n3(:,402), t3x64(:,:,104))
  call prop_W_W(ntry, wf64(:,212), 175, MW, 1_intkind1, wf64(:,213), n2(338))
  call vert_ZQ_A(gZl,ntry, wf16(:,54), ex4(:), wf32(:,297), n3(:,403), t3x32(:,:,157))
  call prop_Q_A(ntry, wf32(:,297), 173, ZERO, 0_intkind1, wf32(:,298), n2(339))
  call vert_QA_W(ntry, wf32(:,298), ex2(:), wf64(:,214), n3(:,404), t3x64(:,:,105))
  call prop_W_W(ntry, wf64(:,214), 175, MW, 1_intkind1, wf64(:,215), n2(340))
  call vert_ZQ_A(gZl,ntry, wf16(:,44), ex3(:), wf32(:,299), n3(:,405), t3x32(:,:,158))
  call prop_Q_A(ntry, wf32(:,299), 174, ZERO, 0_intkind1, wf32(:,300), n2(341))
  call vert_QA_W(ntry, wf32(:,300), ex1(:), wf64(:,216), n3(:,406), t3x64(:,:,106))
  call prop_W_W(ntry, wf64(:,216), 175, MW, 1_intkind1, wf64(:,217), n2(342))
  call vert_VQ_A(ntry, wf16(:,37), ex3(:), wf32(:,301), n3(:,407), t3x32(:,:,159))
  call prop_Q_A(ntry, wf32(:,301), 174, ZERO, 0_intkind1, wf32(:,302), n2(343))
  call vert_QA_W(ntry, wf32(:,302), ex1(:), wf64(:,218), n3(:,408), t3x64(:,:,107))
  call prop_W_W(ntry, wf64(:,218), 175, MW, 1_intkind1, wf64(:,219), n2(344))
  call vert_ZQ_A(gZl,ntry, wf16(:,43), ex3(:), wf32(:,303), n3(:,409), t3x32(:,:,160))
  call prop_Q_A(ntry, wf32(:,303), 174, ZERO, 0_intkind1, wf32(:,304), n2(345))
  call vert_QA_W(ntry, wf32(:,304), ex1(:), wf64(:,220), n3(:,410), t3x64(:,:,108))
  call prop_W_W(ntry, wf64(:,220), 175, MW, 1_intkind1, wf64(:,221), n2(346))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_exwf(ex5)
  call init_hybrid_exwf(ex6)
  call init_hybrid_exwf(ex7)
  call init_hybrid_exwf(ex8)
  call init_hybrid_wf(wf4)
  call init_hybrid_wf(wf8)
  call init_hybrid_wf(wf16)
  call init_hybrid_wf(wf32)
  call init_hybrid_wf(wf64)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k))
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0
  
    do k = 1, nhel
      call colint(M1helarray(:,k)%j, M2add)
      call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct)
      if (IR_is_on > 0) then
	call colint_IR(M1helarray(:,k)%j, M2add_colint)
      end if
      !summation over helicity configurations
      M02 = M02 + M2add
      M2ct = M2ct + M2add_ct
      M2colint = M2colint + M2add_colint
    end do



  contains

subroutine physical_helicities()
  implicit none 

integer :: i1,i2,i3,i4,i5,i6,i7,i8
integer :: n

n=0

do i8= 1, 2
do i7= 1, 2
do i6= 1, 2
do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2) .OR. (ex7(i7)%hf==-1_intkind2)  &
    .OR. (ex8(i8)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf + ex7(i7)%hf + ex8(i8)%hf
 end if
end do
end do
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_VV(nsync, wf4(:,8), wf64(:,1), A(:,1), n3(:,411), t3x256(:,:,1), nhel, den(6))
    call Hcont_SS(nsync, wf16(:,1), wf16(:,2), A(:,2), n3(:,412), t3x256(:,:,2), nhel, den(11))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,4), A(:,3), n3(:,413), t3x256(:,:,3), nhel, den(14))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,5), A(:,4), n3(:,414), t3x256(:,:,4), nhel, den(17))
    call Hcont_SS(nsync, wf16(:,6), wf16(:,7), A(:,5), n3(:,415), t3x256(:,:,5), nhel, den(22))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,9), A(:,6), n3(:,416), t3x256(:,:,6), nhel, den(25))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,10), A(:,7), n3(:,417), t3x256(:,:,7), nhel, den(28))
    call Hcont_QA(nsync, wf8(:,4), wf32(:,1), A(:,8), n3(:,418), t3x256(:,:,8), nhel, den(34))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,11), A(:,9), n3(:,419), t3x256(:,:,9), nhel, den(37))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,13), A(:,10), n3(:,420), t3x256(:,:,10), nhel, den(40))
    call Hcont_QA(nsync, wf8(:,8), wf32(:,2), A(:,11), n3(:,421), t3x256(:,:,11), nhel, den(46))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,14), A(:,12), n3(:,422), t3x256(:,:,12), nhel, den(47))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,15), A(:,13), n3(:,423), t3x256(:,:,13), nhel, den(48))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,16), A(:,14), n3(:,424), t3x256(:,:,14), nhel, den(49))
    call Hcont_VV(nsync, wf16(:,5), wf16(:,17), A(:,15), n3(:,425), t3x256(:,:,15), nhel, den(50))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,18), A(:,16), n3(:,426), t3x256(:,:,16), nhel, den(51))
    call Hcont_VV(nsync, wf16(:,5), wf16(:,19), A(:,17), n3(:,427), t3x256(:,:,17), nhel, den(52))
    call Hcont_QA(nsync, wf8(:,12), wf32(:,3), A(:,18), n3(:,428), t3x256(:,:,18), nhel, den(58))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,20), A(:,19), n3(:,429), t3x256(:,:,19), nhel, den(61))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,22), A(:,20), n3(:,430), t3x256(:,:,20), nhel, den(64))
    call Hcont_QA(nsync, wf8(:,16), wf32(:,4), A(:,21), n3(:,431), t3x256(:,:,21), nhel, den(70))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,23), A(:,22), n3(:,432), t3x256(:,:,22), nhel, den(71))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,24), A(:,23), n3(:,433), t3x256(:,:,23), nhel, den(72))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,25), A(:,24), n3(:,434), t3x256(:,:,24), nhel, den(73))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,26), A(:,25), n3(:,435), t3x256(:,:,25), nhel, den(74))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,27), A(:,26), n3(:,436), t3x256(:,:,26), nhel, den(75))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,28), A(:,27), n3(:,437), t3x256(:,:,27), nhel, den(76))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,20), A(:,28), n3(:,438), t3x256(:,:,28), nhel, den(78))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,29), A(:,29), n3(:,439), t3x256(:,:,29), nhel, den(80))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,20), A(:,30), n3(:,440), t3x256(:,:,30), nhel, den(82))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,30), A(:,31), n3(:,441), t3x256(:,:,31), nhel, den(84))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,25), A(:,32), n3(:,442), t3x256(:,:,32), nhel, den(86))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,31), A(:,33), n3(:,443), t3x256(:,:,33), nhel, den(88))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,27), A(:,34), n3(:,444), t3x256(:,:,34), nhel, den(90))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,32), A(:,35), n3(:,445), t3x256(:,:,35), nhel, den(92))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,23), A(:,36), n3(:,446), t3x256(:,:,36), nhel, den(94))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,33), A(:,37), n3(:,447), t3x256(:,:,37), nhel, den(96))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,23), A(:,38), n3(:,448), t3x256(:,:,38), nhel, den(97))
    call Hcont_VV(nsync, wf16(:,19), wf16(:,33), A(:,39), n3(:,449), t3x256(:,:,39), nhel, den(98))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,25), A(:,40), n3(:,450), t3x256(:,:,40), nhel, den(100))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,34), A(:,41), n3(:,451), t3x256(:,:,41), nhel, den(102))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,27), A(:,42), n3(:,452), t3x256(:,:,42), nhel, den(103))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,32), A(:,43), n3(:,453), t3x256(:,:,43), nhel, den(104))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,35), A(:,44), n3(:,454), t3x256(:,:,44), nhel, den(107))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,36), A(:,45), n3(:,455), t3x256(:,:,45), nhel, den(108))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,37), A(:,46), n3(:,456), t3x256(:,:,46), nhel, den(111))
    call Hcont_VV(nsync, wf16(:,5), wf16(:,38), A(:,47), n3(:,457), t3x256(:,:,47), nhel, den(112))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,39), A(:,48), n3(:,458), t3x256(:,:,48), nhel, den(115))
    call Hcont_VV(nsync, wf16(:,5), wf16(:,40), A(:,49), n3(:,459), t3x256(:,:,49), nhel, den(118))
    call Hcont_QA(nsync, wf8(:,24), wf32(:,5), A(:,50), n3(:,460), t3x256(:,:,50), nhel, den(120))
    call Hcont_QA(nsync, wf8(:,22), wf32(:,6), A(:,51), n3(:,461), t3x256(:,:,51), nhel, den(122))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,35), A(:,52), n3(:,462), t3x256(:,:,52), nhel, den(124))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,41), A(:,53), n3(:,463), t3x256(:,:,53), nhel, den(126))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,42), A(:,54), n3(:,464), t3x256(:,:,54), nhel, den(128))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,35), A(:,55), n3(:,465), t3x256(:,:,55), nhel, den(129))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,41), A(:,56), n3(:,466), t3x256(:,:,56), nhel, den(130))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,42), A(:,57), n3(:,467), t3x256(:,:,57), nhel, den(131))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,37), A(:,58), n3(:,468), t3x256(:,:,58), nhel, den(133))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,43), A(:,59), n3(:,469), t3x256(:,:,59), nhel, den(135))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,44), A(:,60), n3(:,470), t3x256(:,:,60), nhel, den(137))
    call Hcont_VV(nsync, wf16(:,24), wf16(:,44), A(:,61), n3(:,471), t3x256(:,:,61), nhel, den(138))
    call Hcont_VV(nsync, wf16(:,23), wf16(:,37), A(:,62), n3(:,472), t3x256(:,:,62), nhel, den(139))
    call Hcont_VV(nsync, wf16(:,24), wf16(:,43), A(:,63), n3(:,473), t3x256(:,:,63), nhel, den(140))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,45), A(:,64), n3(:,474), t3x256(:,:,64), nhel, den(143))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,46), A(:,65), n3(:,475), t3x256(:,:,65), nhel, den(144))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,47), A(:,66), n3(:,476), t3x256(:,:,66), nhel, den(147))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,48), A(:,67), n3(:,477), t3x256(:,:,67), nhel, den(148))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,49), A(:,68), n3(:,478), t3x256(:,:,68), nhel, den(151))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,50), A(:,69), n3(:,479), t3x256(:,:,69), nhel, den(154))
    call Hcont_QA(nsync, wf8(:,32), wf32(:,7), A(:,70), n3(:,480), t3x256(:,:,70), nhel, den(156))
    call Hcont_QA(nsync, wf8(:,30), wf32(:,8), A(:,71), n3(:,481), t3x256(:,:,71), nhel, den(158))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,45), A(:,72), n3(:,482), t3x256(:,:,72), nhel, den(160))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,51), A(:,73), n3(:,483), t3x256(:,:,73), nhel, den(162))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,45), A(:,74), n3(:,484), t3x256(:,:,74), nhel, den(163))
    call Hcont_VV(nsync, wf16(:,19), wf16(:,51), A(:,75), n3(:,485), t3x256(:,:,75), nhel, den(164))
    call Hcont_VV(nsync, wf16(:,19), wf16(:,52), A(:,76), n3(:,486), t3x256(:,:,76), nhel, den(166))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,52), A(:,77), n3(:,487), t3x256(:,:,77), nhel, den(167))
    call Hcont_VV(nsync, wf16(:,28), wf16(:,53), A(:,78), n3(:,488), t3x256(:,:,78), nhel, den(169))
    call Hcont_VV(nsync, wf16(:,25), wf16(:,47), A(:,79), n3(:,489), t3x256(:,:,79), nhel, den(171))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,54), A(:,80), n3(:,490), t3x256(:,:,80), nhel, den(173))
    call Hcont_VV(nsync, wf16(:,27), wf16(:,47), A(:,81), n3(:,491), t3x256(:,:,81), nhel, den(174))
    call Hcont_VV(nsync, wf16(:,28), wf16(:,54), A(:,82), n3(:,492), t3x256(:,:,82), nhel, den(175))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,53), A(:,83), n3(:,493), t3x256(:,:,83), nhel, den(176))
    call Hcont_VV(nsync, wf16(:,40), wf16(:,52), A(:,84), n3(:,494), t3x256(:,:,84), nhel, den(177))
    call Hcont_VV(nsync, wf16(:,39), wf16(:,53), A(:,85), n3(:,495), t3x256(:,:,85), nhel, den(178))
    call Hcont_VV(nsync, wf16(:,36), wf16(:,53), A(:,86), n3(:,496), t3x256(:,:,86), nhel, den(179))
    call Hcont_VV(nsync, wf16(:,38), wf16(:,52), A(:,87), n3(:,497), t3x256(:,:,87), nhel, den(180))
    call Hcont_VV(nsync, wf16(:,44), wf16(:,46), A(:,88), n3(:,498), t3x256(:,:,88), nhel, den(181))
    call Hcont_VV(nsync, wf16(:,37), wf16(:,45), A(:,89), n3(:,499), t3x256(:,:,89), nhel, den(182))
    call Hcont_VV(nsync, wf16(:,38), wf16(:,51), A(:,90), n3(:,500), t3x256(:,:,90), nhel, den(183))
    call Hcont_VV(nsync, wf16(:,42), wf16(:,48), A(:,91), n3(:,501), t3x256(:,:,91), nhel, den(184))
    call Hcont_VV(nsync, wf16(:,35), wf16(:,47), A(:,92), n3(:,502), t3x256(:,:,92), nhel, den(185))
    call Hcont_VV(nsync, wf16(:,36), wf16(:,54), A(:,93), n3(:,503), t3x256(:,:,93), nhel, den(186))

    call Hcont_VV(nsync, wf64(:,1), wf4(:,10), A(:,94), n3(:,504), t3x256(:,:,94), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,8), wf64(:,2), A(:,95), n3(:,505), t3x256(:,:,95), nhel, den(6))
    call Hcont_QA(nsync, wf8(:,4), wf32(:,9), A(:,96), n3(:,506), t3x256(:,:,96), nhel, den(34))
    call Hcont_QA(nsync, wf8(:,8), wf32(:,10), A(:,97), n3(:,507), t3x256(:,:,97), nhel, den(46))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,55), A(:,98), n3(:,508), t3x256(:,:,98), nhel, den(37))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,56), A(:,99), n3(:,509), t3x256(:,:,99), nhel, den(40))
    call Hcont_QA(nsync, wf32(:,1), wf8(:,34), A(:,100), n3(:,510), t3x256(:,:,100), nhel, den(34))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,57), A(:,101), n3(:,511), t3x256(:,:,101), nhel, den(49))
    call Hcont_VV(nsync, wf16(:,5), wf16(:,58), A(:,102), n3(:,512), t3x256(:,:,102), nhel, den(50))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,59), A(:,103), n3(:,513), t3x256(:,:,103), nhel, den(51))
    call Hcont_VV(nsync, wf16(:,5), wf16(:,60), A(:,104), n3(:,514), t3x256(:,:,104), nhel, den(52))
    call Hcont_QA(nsync, wf32(:,2), wf8(:,36), A(:,105), n3(:,515), t3x256(:,:,105), nhel, den(46))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,61), A(:,106), n3(:,516), t3x256(:,:,106), nhel, den(47))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,62), A(:,107), n3(:,517), t3x256(:,:,107), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,12), wf32(:,11), A(:,108), n3(:,518), t3x256(:,:,108), nhel, den(58))
    call Hcont_QA(nsync, wf8(:,16), wf32(:,12), A(:,109), n3(:,519), t3x256(:,:,109), nhel, den(70))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,57), A(:,110), n3(:,520), t3x256(:,:,110), nhel, den(78))
    call Hcont_VV(nsync, wf16(:,29), wf16(:,58), A(:,111), n3(:,521), t3x256(:,:,111), nhel, den(80))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,59), A(:,112), n3(:,522), t3x256(:,:,112), nhel, den(82))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,63), A(:,113), n3(:,523), t3x256(:,:,113), nhel, den(84))
    call Hcont_VV(nsync, wf16(:,25), wf16(:,55), A(:,114), n3(:,524), t3x256(:,:,114), nhel, den(86))
    call Hcont_VV(nsync, wf16(:,31), wf16(:,56), A(:,115), n3(:,525), t3x256(:,:,115), nhel, den(88))
    call Hcont_VV(nsync, wf16(:,27), wf16(:,55), A(:,116), n3(:,526), t3x256(:,:,116), nhel, den(90))
    call Hcont_VV(nsync, wf16(:,32), wf16(:,56), A(:,117), n3(:,527), t3x256(:,:,117), nhel, den(92))
    call Hcont_VV(nsync, wf16(:,23), wf16(:,57), A(:,118), n3(:,528), t3x256(:,:,118), nhel, den(94))
    call Hcont_VV(nsync, wf16(:,33), wf16(:,58), A(:,119), n3(:,529), t3x256(:,:,119), nhel, den(96))
    call Hcont_VV(nsync, wf16(:,23), wf16(:,59), A(:,120), n3(:,530), t3x256(:,:,120), nhel, den(97))
    call Hcont_VV(nsync, wf16(:,33), wf16(:,60), A(:,121), n3(:,531), t3x256(:,:,121), nhel, den(98))
    call Hcont_VV(nsync, wf16(:,25), wf16(:,61), A(:,122), n3(:,532), t3x256(:,:,122), nhel, den(100))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,64), A(:,123), n3(:,533), t3x256(:,:,123), nhel, den(102))
    call Hcont_VV(nsync, wf16(:,27), wf16(:,61), A(:,124), n3(:,534), t3x256(:,:,124), nhel, den(103))
    call Hcont_VV(nsync, wf16(:,32), wf16(:,62), A(:,125), n3(:,535), t3x256(:,:,125), nhel, den(104))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,65), A(:,126), n3(:,536), t3x256(:,:,126), nhel, den(61))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,66), A(:,127), n3(:,537), t3x256(:,:,127), nhel, den(64))
    call Hcont_QA(nsync, wf32(:,3), wf8(:,38), A(:,128), n3(:,538), t3x256(:,:,128), nhel, den(58))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,67), A(:,129), n3(:,539), t3x256(:,:,129), nhel, den(73))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,68), A(:,130), n3(:,540), t3x256(:,:,130), nhel, den(74))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,69), A(:,131), n3(:,541), t3x256(:,:,131), nhel, den(75))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,70), A(:,132), n3(:,542), t3x256(:,:,132), nhel, den(76))
    call Hcont_QA(nsync, wf32(:,4), wf8(:,40), A(:,133), n3(:,543), t3x256(:,:,133), nhel, den(70))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,71), A(:,134), n3(:,544), t3x256(:,:,134), nhel, den(71))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,72), A(:,135), n3(:,545), t3x256(:,:,135), nhel, den(72))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,65), A(:,136), n3(:,546), t3x256(:,:,136), nhel, den(188))
    call Hcont_VV(nsync, wf16(:,66), wf16(:,73), A(:,137), n3(:,547), t3x256(:,:,137), nhel, den(190))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,65), A(:,138), n3(:,548), t3x256(:,:,138), nhel, den(82))
    call Hcont_VV(nsync, wf16(:,30), wf16(:,66), A(:,139), n3(:,549), t3x256(:,:,139), nhel, den(84))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,67), A(:,140), n3(:,550), t3x256(:,:,140), nhel, den(192))
    call Hcont_VV(nsync, wf16(:,68), wf16(:,74), A(:,141), n3(:,551), t3x256(:,:,141), nhel, den(194))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,69), A(:,142), n3(:,552), t3x256(:,:,142), nhel, den(90))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,75), A(:,143), n3(:,553), t3x256(:,:,143), nhel, den(92))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,67), A(:,144), n3(:,554), t3x256(:,:,144), nhel, den(100))
    call Hcont_VV(nsync, wf16(:,34), wf16(:,68), A(:,145), n3(:,555), t3x256(:,:,145), nhel, den(102))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,69), A(:,146), n3(:,556), t3x256(:,:,146), nhel, den(103))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,75), A(:,147), n3(:,557), t3x256(:,:,147), nhel, den(104))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,71), A(:,148), n3(:,558), t3x256(:,:,148), nhel, den(94))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,76), A(:,149), n3(:,559), t3x256(:,:,149), nhel, den(96))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,71), A(:,150), n3(:,560), t3x256(:,:,150), nhel, den(97))
    call Hcont_VV(nsync, wf16(:,19), wf16(:,76), A(:,151), n3(:,561), t3x256(:,:,151), nhel, den(98))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,77), A(:,152), n3(:,562), t3x256(:,:,152), nhel, den(47))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,78), A(:,153), n3(:,563), t3x256(:,:,153), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,8), wf32(:,13), A(:,154), n3(:,564), t3x256(:,:,154), nhel, den(46))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,79), A(:,155), n3(:,565), t3x256(:,:,155), nhel, den(51))
    call Hcont_VV(nsync, wf16(:,5), wf16(:,80), A(:,156), n3(:,566), t3x256(:,:,156), nhel, den(52))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,81), A(:,157), n3(:,567), t3x256(:,:,157), nhel, den(49))
    call Hcont_VV(nsync, wf16(:,5), wf16(:,82), A(:,158), n3(:,568), t3x256(:,:,158), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,4), wf32(:,14), A(:,159), n3(:,569), t3x256(:,:,159), nhel, den(34))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,83), A(:,160), n3(:,570), t3x256(:,:,160), nhel, den(37))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,84), A(:,161), n3(:,571), t3x256(:,:,161), nhel, den(40))
    call Hcont_SS(nsync, wf16(:,1), wf16(:,85), A(:,162), n3(:,572), t3x256(:,:,162), nhel, den(11))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,86), A(:,163), n3(:,573), t3x256(:,:,163), nhel, den(14))
    call Hcont_VV(nsync, wf16(:,5), wf16(:,86), A(:,164), n3(:,574), t3x256(:,:,164), nhel, den(17))
    call Hcont_SS(nsync, wf16(:,7), wf16(:,87), A(:,165), n3(:,575), t3x256(:,:,165), nhel, den(22))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,88), A(:,166), n3(:,576), t3x256(:,:,166), nhel, den(25))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,89), A(:,167), n3(:,577), t3x256(:,:,167), nhel, den(28))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,79), A(:,168), n3(:,578), t3x256(:,:,168), nhel, den(195))
    call Hcont_VV(nsync, wf16(:,29), wf16(:,80), A(:,169), n3(:,579), t3x256(:,:,169), nhel, den(196))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,81), A(:,170), n3(:,580), t3x256(:,:,170), nhel, den(78))
    call Hcont_VV(nsync, wf16(:,29), wf16(:,82), A(:,171), n3(:,581), t3x256(:,:,171), nhel, den(80))
    call Hcont_VV(nsync, wf16(:,23), wf16(:,79), A(:,172), n3(:,582), t3x256(:,:,172), nhel, den(97))
    call Hcont_VV(nsync, wf16(:,33), wf16(:,80), A(:,173), n3(:,583), t3x256(:,:,173), nhel, den(98))
    call Hcont_VV(nsync, wf16(:,23), wf16(:,81), A(:,174), n3(:,584), t3x256(:,:,174), nhel, den(94))
    call Hcont_VV(nsync, wf16(:,33), wf16(:,82), A(:,175), n3(:,585), t3x256(:,:,175), nhel, den(96))
    call Hcont_VV(nsync, wf16(:,25), wf16(:,77), A(:,176), n3(:,586), t3x256(:,:,176), nhel, den(197))
    call Hcont_VV(nsync, wf16(:,31), wf16(:,78), A(:,177), n3(:,587), t3x256(:,:,177), nhel, den(198))
    call Hcont_VV(nsync, wf16(:,27), wf16(:,77), A(:,178), n3(:,588), t3x256(:,:,178), nhel, den(103))
    call Hcont_VV(nsync, wf16(:,32), wf16(:,78), A(:,179), n3(:,589), t3x256(:,:,179), nhel, den(104))
    call Hcont_VV(nsync, wf16(:,25), wf16(:,83), A(:,180), n3(:,590), t3x256(:,:,180), nhel, den(86))
    call Hcont_VV(nsync, wf16(:,31), wf16(:,84), A(:,181), n3(:,591), t3x256(:,:,181), nhel, den(88))
    call Hcont_VV(nsync, wf16(:,27), wf16(:,83), A(:,182), n3(:,592), t3x256(:,:,182), nhel, den(90))
    call Hcont_VV(nsync, wf16(:,32), wf16(:,84), A(:,183), n3(:,593), t3x256(:,:,183), nhel, den(92))
    call Hcont_QA(nsync, wf8(:,12), wf32(:,15), A(:,184), n3(:,594), t3x256(:,:,184), nhel, den(58))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,86), A(:,185), n3(:,595), t3x256(:,:,185), nhel, den(61))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,90), A(:,186), n3(:,596), t3x256(:,:,186), nhel, den(64))
    call Hcont_QA(nsync, wf8(:,16), wf32(:,16), A(:,187), n3(:,597), t3x256(:,:,187), nhel, den(70))
    call Hcont_VV(nsync, wf16(:,23), wf16(:,86), A(:,188), n3(:,598), t3x256(:,:,188), nhel, den(71))
    call Hcont_VV(nsync, wf16(:,24), wf16(:,90), A(:,189), n3(:,599), t3x256(:,:,189), nhel, den(72))
    call Hcont_VV(nsync, wf16(:,25), wf16(:,88), A(:,190), n3(:,600), t3x256(:,:,190), nhel, den(73))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,89), A(:,191), n3(:,601), t3x256(:,:,191), nhel, den(74))
    call Hcont_VV(nsync, wf16(:,27), wf16(:,88), A(:,192), n3(:,602), t3x256(:,:,192), nhel, den(75))
    call Hcont_VV(nsync, wf16(:,28), wf16(:,89), A(:,193), n3(:,603), t3x256(:,:,193), nhel, den(76))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,91), A(:,194), n3(:,604), t3x256(:,:,194), nhel, den(71))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,92), A(:,195), n3(:,605), t3x256(:,:,195), nhel, den(72))
    call Hcont_QA(nsync, wf8(:,16), wf32(:,17), A(:,196), n3(:,606), t3x256(:,:,196), nhel, den(70))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,93), A(:,197), n3(:,607), t3x256(:,:,197), nhel, den(75))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,94), A(:,198), n3(:,608), t3x256(:,:,198), nhel, den(76))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,95), A(:,199), n3(:,609), t3x256(:,:,199), nhel, den(73))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,96), A(:,200), n3(:,610), t3x256(:,:,200), nhel, den(74))
    call Hcont_QA(nsync, wf8(:,12), wf32(:,18), A(:,201), n3(:,611), t3x256(:,:,201), nhel, den(58))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,97), A(:,202), n3(:,612), t3x256(:,:,202), nhel, den(61))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,98), A(:,203), n3(:,613), t3x256(:,:,203), nhel, den(64))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,93), A(:,204), n3(:,614), t3x256(:,:,204), nhel, den(199))
    call Hcont_VV(nsync, wf16(:,74), wf16(:,94), A(:,205), n3(:,615), t3x256(:,:,205), nhel, den(200))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,95), A(:,206), n3(:,616), t3x256(:,:,206), nhel, den(86))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,99), A(:,207), n3(:,617), t3x256(:,:,207), nhel, den(88))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,91), A(:,208), n3(:,618), t3x256(:,:,208), nhel, den(201))
    call Hcont_VV(nsync, wf16(:,73), wf16(:,92), A(:,209), n3(:,619), t3x256(:,:,209), nhel, den(202))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,91), A(:,210), n3(:,620), t3x256(:,:,210), nhel, den(203))
    call Hcont_VV(nsync, wf16(:,30), wf16(:,92), A(:,211), n3(:,621), t3x256(:,:,211), nhel, den(204))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,93), A(:,212), n3(:,622), t3x256(:,:,212), nhel, den(205))
    call Hcont_VV(nsync, wf16(:,34), wf16(:,94), A(:,213), n3(:,623), t3x256(:,:,213), nhel, den(206))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,95), A(:,214), n3(:,624), t3x256(:,:,214), nhel, den(100))
    call Hcont_VV(nsync, wf16(:,34), wf16(:,96), A(:,215), n3(:,625), t3x256(:,:,215), nhel, den(102))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,97), A(:,216), n3(:,626), t3x256(:,:,216), nhel, den(78))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,100), A(:,217), n3(:,627), t3x256(:,:,217), nhel, den(80))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,97), A(:,218), n3(:,628), t3x256(:,:,218), nhel, den(82))
    call Hcont_VV(nsync, wf16(:,30), wf16(:,98), A(:,219), n3(:,629), t3x256(:,:,219), nhel, den(84))
    call Hcont_SS(nsync, wf16(:,2), wf16(:,101), A(:,220), n3(:,630), t3x256(:,:,220), nhel, den(11))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,102), A(:,221), n3(:,631), t3x256(:,:,221), nhel, den(14))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,103), A(:,222), n3(:,632), t3x256(:,:,222), nhel, den(17))
    call Hcont_SS(nsync, wf16(:,6), wf16(:,104), A(:,223), n3(:,633), t3x256(:,:,223), nhel, den(22))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,105), A(:,224), n3(:,634), t3x256(:,:,224), nhel, den(25))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,105), A(:,225), n3(:,635), t3x256(:,:,225), nhel, den(28))
    call Hcont_QA(nsync, wf8(:,4), wf32(:,19), A(:,226), n3(:,636), t3x256(:,:,226), nhel, den(34))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,105), A(:,227), n3(:,637), t3x256(:,:,227), nhel, den(37))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,106), A(:,228), n3(:,638), t3x256(:,:,228), nhel, den(40))
    call Hcont_QA(nsync, wf8(:,8), wf32(:,20), A(:,229), n3(:,639), t3x256(:,:,229), nhel, den(46))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,105), A(:,230), n3(:,640), t3x256(:,:,230), nhel, den(47))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,106), A(:,231), n3(:,641), t3x256(:,:,231), nhel, den(48))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,102), A(:,232), n3(:,642), t3x256(:,:,232), nhel, den(49))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,103), A(:,233), n3(:,643), t3x256(:,:,233), nhel, den(50))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,102), A(:,234), n3(:,644), t3x256(:,:,234), nhel, den(51))
    call Hcont_VV(nsync, wf16(:,19), wf16(:,103), A(:,235), n3(:,645), t3x256(:,:,235), nhel, den(52))
    call Hcont_VV(nsync, wf16(:,35), wf16(:,55), A(:,236), n3(:,646), t3x256(:,:,236), nhel, den(124))
    call Hcont_VV(nsync, wf16(:,41), wf16(:,56), A(:,237), n3(:,647), t3x256(:,:,237), nhel, den(126))
    call Hcont_VV(nsync, wf16(:,42), wf16(:,56), A(:,238), n3(:,648), t3x256(:,:,238), nhel, den(128))
    call Hcont_VV(nsync, wf16(:,35), wf16(:,61), A(:,239), n3(:,649), t3x256(:,:,239), nhel, den(129))
    call Hcont_VV(nsync, wf16(:,41), wf16(:,62), A(:,240), n3(:,650), t3x256(:,:,240), nhel, den(130))
    call Hcont_VV(nsync, wf16(:,42), wf16(:,62), A(:,241), n3(:,651), t3x256(:,:,241), nhel, den(131))
    call Hcont_VV(nsync, wf16(:,37), wf16(:,65), A(:,242), n3(:,652), t3x256(:,:,242), nhel, den(133))
    call Hcont_VV(nsync, wf16(:,43), wf16(:,66), A(:,243), n3(:,653), t3x256(:,:,243), nhel, den(135))
    call Hcont_VV(nsync, wf16(:,44), wf16(:,66), A(:,244), n3(:,654), t3x256(:,:,244), nhel, den(137))
    call Hcont_VV(nsync, wf16(:,44), wf16(:,72), A(:,245), n3(:,655), t3x256(:,:,245), nhel, den(138))
    call Hcont_VV(nsync, wf16(:,37), wf16(:,71), A(:,246), n3(:,656), t3x256(:,:,246), nhel, den(139))
    call Hcont_VV(nsync, wf16(:,43), wf16(:,72), A(:,247), n3(:,657), t3x256(:,:,247), nhel, den(140))
    call Hcont_VV(nsync, wf16(:,35), wf16(:,77), A(:,248), n3(:,658), t3x256(:,:,248), nhel, den(129))
    call Hcont_VV(nsync, wf16(:,41), wf16(:,78), A(:,249), n3(:,659), t3x256(:,:,249), nhel, den(130))
    call Hcont_VV(nsync, wf16(:,42), wf16(:,78), A(:,250), n3(:,660), t3x256(:,:,250), nhel, den(131))
    call Hcont_VV(nsync, wf16(:,35), wf16(:,83), A(:,251), n3(:,661), t3x256(:,:,251), nhel, den(124))
    call Hcont_VV(nsync, wf16(:,41), wf16(:,84), A(:,252), n3(:,662), t3x256(:,:,252), nhel, den(126))
    call Hcont_VV(nsync, wf16(:,42), wf16(:,84), A(:,253), n3(:,663), t3x256(:,:,253), nhel, den(128))
    call Hcont_VV(nsync, wf16(:,35), wf16(:,88), A(:,254), n3(:,664), t3x256(:,:,254), nhel, den(107))
    call Hcont_VV(nsync, wf16(:,36), wf16(:,89), A(:,255), n3(:,665), t3x256(:,:,255), nhel, den(108))
    call Hcont_VV(nsync, wf16(:,39), wf16(:,89), A(:,256), n3(:,666), t3x256(:,:,256), nhel, den(115))
    call Hcont_VV(nsync, wf16(:,5), wf16(:,107), A(:,257), n3(:,667), t3x256(:,:,257), nhel, den(118))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,108), A(:,258), n3(:,668), t3x256(:,:,258), nhel, den(111))
    call Hcont_VV(nsync, wf16(:,5), wf16(:,109), A(:,259), n3(:,669), t3x256(:,:,259), nhel, den(112))
    call Hcont_QA(nsync, wf32(:,5), wf8(:,50), A(:,260), n3(:,670), t3x256(:,:,260), nhel, den(120))
    call Hcont_QA(nsync, wf8(:,22), wf32(:,21), A(:,261), n3(:,671), t3x256(:,:,261), nhel, den(122))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,110), A(:,262), n3(:,672), t3x256(:,:,262), nhel, den(137))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,108), A(:,263), n3(:,673), t3x256(:,:,263), nhel, den(133))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,111), A(:,264), n3(:,674), t3x256(:,:,264), nhel, den(135))
    call Hcont_VV(nsync, wf16(:,24), wf16(:,110), A(:,265), n3(:,675), t3x256(:,:,265), nhel, den(138))
    call Hcont_VV(nsync, wf16(:,23), wf16(:,108), A(:,266), n3(:,676), t3x256(:,:,266), nhel, den(139))
    call Hcont_VV(nsync, wf16(:,24), wf16(:,111), A(:,267), n3(:,677), t3x256(:,:,267), nhel, den(140))
    call Hcont_VV(nsync, wf16(:,37), wf16(:,91), A(:,268), n3(:,678), t3x256(:,:,268), nhel, den(139))
    call Hcont_VV(nsync, wf16(:,43), wf16(:,92), A(:,269), n3(:,679), t3x256(:,:,269), nhel, den(140))
    call Hcont_VV(nsync, wf16(:,44), wf16(:,92), A(:,270), n3(:,680), t3x256(:,:,270), nhel, den(138))
    call Hcont_VV(nsync, wf16(:,37), wf16(:,97), A(:,271), n3(:,681), t3x256(:,:,271), nhel, den(133))
    call Hcont_VV(nsync, wf16(:,43), wf16(:,98), A(:,272), n3(:,682), t3x256(:,:,272), nhel, den(135))
    call Hcont_VV(nsync, wf16(:,44), wf16(:,98), A(:,273), n3(:,683), t3x256(:,:,273), nhel, den(137))
    call Hcont_VV(nsync, wf16(:,37), wf16(:,102), A(:,274), n3(:,684), t3x256(:,:,274), nhel, den(111))
    call Hcont_VV(nsync, wf16(:,38), wf16(:,103), A(:,275), n3(:,685), t3x256(:,:,275), nhel, den(112))
    call Hcont_VV(nsync, wf16(:,40), wf16(:,103), A(:,276), n3(:,686), t3x256(:,:,276), nhel, den(118))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,112), A(:,277), n3(:,687), t3x256(:,:,277), nhel, den(115))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,113), A(:,278), n3(:,688), t3x256(:,:,278), nhel, den(107))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,114), A(:,279), n3(:,689), t3x256(:,:,279), nhel, den(108))
    call Hcont_QA(nsync, wf32(:,6), wf8(:,54), A(:,280), n3(:,690), t3x256(:,:,280), nhel, den(122))
    call Hcont_QA(nsync, wf8(:,24), wf32(:,22), A(:,281), n3(:,691), t3x256(:,:,281), nhel, den(120))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,115), A(:,282), n3(:,692), t3x256(:,:,282), nhel, den(128))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,113), A(:,283), n3(:,693), t3x256(:,:,283), nhel, den(124))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,116), A(:,284), n3(:,694), t3x256(:,:,284), nhel, den(126))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,115), A(:,285), n3(:,695), t3x256(:,:,285), nhel, den(131))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,113), A(:,286), n3(:,696), t3x256(:,:,286), nhel, den(129))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,116), A(:,287), n3(:,697), t3x256(:,:,287), nhel, den(130))
    call Hcont_VV(nsync, wf16(:,45), wf16(:,57), A(:,288), n3(:,698), t3x256(:,:,288), nhel, den(160))
    call Hcont_VV(nsync, wf16(:,51), wf16(:,58), A(:,289), n3(:,699), t3x256(:,:,289), nhel, den(162))
    call Hcont_VV(nsync, wf16(:,45), wf16(:,59), A(:,290), n3(:,700), t3x256(:,:,290), nhel, den(163))
    call Hcont_VV(nsync, wf16(:,51), wf16(:,60), A(:,291), n3(:,701), t3x256(:,:,291), nhel, den(164))
    call Hcont_VV(nsync, wf16(:,52), wf16(:,60), A(:,292), n3(:,702), t3x256(:,:,292), nhel, den(166))
    call Hcont_VV(nsync, wf16(:,52), wf16(:,58), A(:,293), n3(:,703), t3x256(:,:,293), nhel, den(167))
    call Hcont_VV(nsync, wf16(:,53), wf16(:,70), A(:,294), n3(:,704), t3x256(:,:,294), nhel, den(169))
    call Hcont_VV(nsync, wf16(:,47), wf16(:,67), A(:,295), n3(:,705), t3x256(:,:,295), nhel, den(171))
    call Hcont_VV(nsync, wf16(:,54), wf16(:,68), A(:,296), n3(:,706), t3x256(:,:,296), nhel, den(173))
    call Hcont_VV(nsync, wf16(:,47), wf16(:,69), A(:,297), n3(:,707), t3x256(:,:,297), nhel, den(174))
    call Hcont_VV(nsync, wf16(:,54), wf16(:,70), A(:,298), n3(:,708), t3x256(:,:,298), nhel, den(175))
    call Hcont_VV(nsync, wf16(:,53), wf16(:,68), A(:,299), n3(:,709), t3x256(:,:,299), nhel, den(176))
    call Hcont_VV(nsync, wf16(:,45), wf16(:,79), A(:,300), n3(:,710), t3x256(:,:,300), nhel, den(163))
    call Hcont_VV(nsync, wf16(:,51), wf16(:,80), A(:,301), n3(:,711), t3x256(:,:,301), nhel, den(164))
    call Hcont_VV(nsync, wf16(:,45), wf16(:,81), A(:,302), n3(:,712), t3x256(:,:,302), nhel, den(160))
    call Hcont_VV(nsync, wf16(:,51), wf16(:,82), A(:,303), n3(:,713), t3x256(:,:,303), nhel, den(162))
    call Hcont_VV(nsync, wf16(:,52), wf16(:,82), A(:,304), n3(:,714), t3x256(:,:,304), nhel, den(167))
    call Hcont_VV(nsync, wf16(:,52), wf16(:,80), A(:,305), n3(:,715), t3x256(:,:,305), nhel, den(166))
    call Hcont_VV(nsync, wf16(:,45), wf16(:,86), A(:,306), n3(:,716), t3x256(:,:,306), nhel, den(143))
    call Hcont_VV(nsync, wf16(:,46), wf16(:,90), A(:,307), n3(:,717), t3x256(:,:,307), nhel, den(144))
    call Hcont_VV(nsync, wf16(:,49), wf16(:,90), A(:,308), n3(:,718), t3x256(:,:,308), nhel, den(151))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,117), A(:,309), n3(:,719), t3x256(:,:,309), nhel, den(154))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,118), A(:,310), n3(:,720), t3x256(:,:,310), nhel, den(147))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,119), A(:,311), n3(:,721), t3x256(:,:,311), nhel, den(148))
    call Hcont_QA(nsync, wf32(:,7), wf8(:,58), A(:,312), n3(:,722), t3x256(:,:,312), nhel, den(156))
    call Hcont_QA(nsync, wf8(:,30), wf32(:,23), A(:,313), n3(:,723), t3x256(:,:,313), nhel, den(158))
    call Hcont_VV(nsync, wf16(:,28), wf16(:,120), A(:,314), n3(:,724), t3x256(:,:,314), nhel, den(169))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,120), A(:,315), n3(:,725), t3x256(:,:,315), nhel, den(176))
    call Hcont_VV(nsync, wf16(:,25), wf16(:,118), A(:,316), n3(:,726), t3x256(:,:,316), nhel, den(171))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,121), A(:,317), n3(:,727), t3x256(:,:,317), nhel, den(173))
    call Hcont_VV(nsync, wf16(:,27), wf16(:,118), A(:,318), n3(:,728), t3x256(:,:,318), nhel, den(174))
    call Hcont_VV(nsync, wf16(:,28), wf16(:,121), A(:,319), n3(:,729), t3x256(:,:,319), nhel, den(175))
    call Hcont_VV(nsync, wf16(:,47), wf16(:,93), A(:,320), n3(:,730), t3x256(:,:,320), nhel, den(174))
    call Hcont_VV(nsync, wf16(:,54), wf16(:,94), A(:,321), n3(:,731), t3x256(:,:,321), nhel, den(175))
    call Hcont_VV(nsync, wf16(:,47), wf16(:,95), A(:,322), n3(:,732), t3x256(:,:,322), nhel, den(171))
    call Hcont_VV(nsync, wf16(:,54), wf16(:,96), A(:,323), n3(:,733), t3x256(:,:,323), nhel, den(173))
    call Hcont_VV(nsync, wf16(:,53), wf16(:,96), A(:,324), n3(:,734), t3x256(:,:,324), nhel, den(176))
    call Hcont_VV(nsync, wf16(:,53), wf16(:,94), A(:,325), n3(:,735), t3x256(:,:,325), nhel, den(169))
    call Hcont_VV(nsync, wf16(:,47), wf16(:,105), A(:,326), n3(:,736), t3x256(:,:,326), nhel, den(147))
    call Hcont_VV(nsync, wf16(:,48), wf16(:,106), A(:,327), n3(:,737), t3x256(:,:,327), nhel, den(148))
    call Hcont_VV(nsync, wf16(:,50), wf16(:,106), A(:,328), n3(:,738), t3x256(:,:,328), nhel, den(154))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,122), A(:,329), n3(:,739), t3x256(:,:,329), nhel, den(151))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,123), A(:,330), n3(:,740), t3x256(:,:,330), nhel, den(143))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,124), A(:,331), n3(:,741), t3x256(:,:,331), nhel, den(144))
    call Hcont_QA(nsync, wf32(:,8), wf8(:,62), A(:,332), n3(:,742), t3x256(:,:,332), nhel, den(158))
    call Hcont_QA(nsync, wf8(:,32), wf32(:,24), A(:,333), n3(:,743), t3x256(:,:,333), nhel, den(156))
    call Hcont_VV(nsync, wf16(:,19), wf16(:,125), A(:,334), n3(:,744), t3x256(:,:,334), nhel, den(166))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,125), A(:,335), n3(:,745), t3x256(:,:,335), nhel, den(167))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,123), A(:,336), n3(:,746), t3x256(:,:,336), nhel, den(160))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,126), A(:,337), n3(:,747), t3x256(:,:,337), nhel, den(162))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,123), A(:,338), n3(:,748), t3x256(:,:,338), nhel, den(163))
    call Hcont_VV(nsync, wf16(:,19), wf16(:,126), A(:,339), n3(:,749), t3x256(:,:,339), nhel, den(164))
    call Hcont_VV(nsync, wf16(:,52), wf16(:,107), A(:,340), n3(:,750), t3x256(:,:,340), nhel, den(177))
    call Hcont_VV(nsync, wf16(:,39), wf16(:,120), A(:,341), n3(:,751), t3x256(:,:,341), nhel, den(178))
    call Hcont_VV(nsync, wf16(:,36), wf16(:,120), A(:,342), n3(:,752), t3x256(:,:,342), nhel, den(179))
    call Hcont_VV(nsync, wf16(:,52), wf16(:,109), A(:,343), n3(:,753), t3x256(:,:,343), nhel, den(180))
    call Hcont_VV(nsync, wf16(:,46), wf16(:,110), A(:,344), n3(:,754), t3x256(:,:,344), nhel, den(181))
    call Hcont_VV(nsync, wf16(:,45), wf16(:,108), A(:,345), n3(:,755), t3x256(:,:,345), nhel, den(182))
    call Hcont_VV(nsync, wf16(:,51), wf16(:,109), A(:,346), n3(:,756), t3x256(:,:,346), nhel, den(183))
    call Hcont_VV(nsync, wf16(:,42), wf16(:,119), A(:,347), n3(:,757), t3x256(:,:,347), nhel, den(184))
    call Hcont_VV(nsync, wf16(:,35), wf16(:,118), A(:,348), n3(:,758), t3x256(:,:,348), nhel, den(185))
    call Hcont_VV(nsync, wf16(:,36), wf16(:,121), A(:,349), n3(:,759), t3x256(:,:,349), nhel, den(186))
    call Hcont_VV(nsync, wf16(:,53), wf16(:,112), A(:,350), n3(:,760), t3x256(:,:,350), nhel, den(178))
    call Hcont_VV(nsync, wf16(:,40), wf16(:,125), A(:,351), n3(:,761), t3x256(:,:,351), nhel, den(177))
    call Hcont_VV(nsync, wf16(:,38), wf16(:,125), A(:,352), n3(:,762), t3x256(:,:,352), nhel, den(180))
    call Hcont_VV(nsync, wf16(:,53), wf16(:,114), A(:,353), n3(:,763), t3x256(:,:,353), nhel, den(179))
    call Hcont_VV(nsync, wf16(:,48), wf16(:,115), A(:,354), n3(:,764), t3x256(:,:,354), nhel, den(184))
    call Hcont_VV(nsync, wf16(:,47), wf16(:,113), A(:,355), n3(:,765), t3x256(:,:,355), nhel, den(185))
    call Hcont_VV(nsync, wf16(:,54), wf16(:,114), A(:,356), n3(:,766), t3x256(:,:,356), nhel, den(186))
    call Hcont_VV(nsync, wf16(:,44), wf16(:,124), A(:,357), n3(:,767), t3x256(:,:,357), nhel, den(181))
    call Hcont_VV(nsync, wf16(:,37), wf16(:,123), A(:,358), n3(:,768), t3x256(:,:,358), nhel, den(182))
    call Hcont_VV(nsync, wf16(:,38), wf16(:,126), A(:,359), n3(:,769), t3x256(:,:,359), nhel, den(183))
    call Hcont_QA(nsync, wf8(:,65), wf32(:,26), A(:,360), n3(:,770), t3x256(:,:,360), nhel, den(209))
    call Hcont_QA(nsync, wf8(:,65), wf32(:,28), A(:,361), n3(:,771), t3x256(:,:,361), nhel, den(211))
    call Hcont_QA(nsync, wf8(:,66), wf32(:,30), A(:,362), n3(:,772), t3x256(:,:,362), nhel, den(214))
    call Hcont_QA(nsync, wf8(:,66), wf32(:,32), A(:,363), n3(:,773), t3x256(:,:,363), nhel, den(216))
    call Hcont_QA(nsync, wf8(:,67), wf32(:,34), A(:,364), n3(:,774), t3x256(:,:,364), nhel, den(219))
    call Hcont_QA(nsync, wf8(:,67), wf32(:,36), A(:,365), n3(:,775), t3x256(:,:,365), nhel, den(221))
    call Hcont_QA(nsync, wf8(:,68), wf32(:,38), A(:,366), n3(:,776), t3x256(:,:,366), nhel, den(224))
    call Hcont_QA(nsync, wf8(:,68), wf32(:,40), A(:,367), n3(:,777), t3x256(:,:,367), nhel, den(226))
    call Hcont_QA(nsync, wf8(:,65), wf32(:,42), A(:,368), n3(:,778), t3x256(:,:,368), nhel, den(229))
    call Hcont_QA(nsync, wf8(:,67), wf32(:,44), A(:,369), n3(:,779), t3x256(:,:,369), nhel, den(232))
    call Hcont_QA(nsync, wf8(:,68), wf32(:,45), A(:,370), n3(:,780), t3x256(:,:,370), nhel, den(234))
    call Hcont_QA(nsync, wf8(:,66), wf32(:,46), A(:,371), n3(:,781), t3x256(:,:,371), nhel, den(236))
    call Hcont_QA(nsync, wf8(:,69), wf32(:,48), A(:,372), n3(:,782), t3x256(:,:,372), nhel, den(239))
    call Hcont_QA(nsync, wf8(:,69), wf32(:,50), A(:,373), n3(:,783), t3x256(:,:,373), nhel, den(241))
    call Hcont_QA(nsync, wf8(:,70), wf32(:,52), A(:,374), n3(:,784), t3x256(:,:,374), nhel, den(244))
    call Hcont_QA(nsync, wf8(:,70), wf32(:,54), A(:,375), n3(:,785), t3x256(:,:,375), nhel, den(246))
    call Hcont_QA(nsync, wf8(:,71), wf32(:,56), A(:,376), n3(:,786), t3x256(:,:,376), nhel, den(249))
    call Hcont_QA(nsync, wf8(:,71), wf32(:,58), A(:,377), n3(:,787), t3x256(:,:,377), nhel, den(251))
    call Hcont_QA(nsync, wf8(:,72), wf32(:,60), A(:,378), n3(:,788), t3x256(:,:,378), nhel, den(254))
    call Hcont_QA(nsync, wf8(:,72), wf32(:,62), A(:,379), n3(:,789), t3x256(:,:,379), nhel, den(256))
    call Hcont_QA(nsync, wf8(:,69), wf32(:,64), A(:,380), n3(:,790), t3x256(:,:,380), nhel, den(259))
    call Hcont_QA(nsync, wf8(:,71), wf32(:,66), A(:,381), n3(:,791), t3x256(:,:,381), nhel, den(262))
    call Hcont_QA(nsync, wf8(:,72), wf32(:,67), A(:,382), n3(:,792), t3x256(:,:,382), nhel, den(264))
    call Hcont_QA(nsync, wf8(:,70), wf32(:,68), A(:,383), n3(:,793), t3x256(:,:,383), nhel, den(266))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,127), A(:,384), n3(:,794), t3x256(:,:,384), nhel, den(268))
    call Hcont_VV(nsync, wf16(:,73), wf16(:,128), A(:,385), n3(:,795), t3x256(:,:,385), nhel, den(269))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,127), A(:,386), n3(:,796), t3x256(:,:,386), nhel, den(270))
    call Hcont_VV(nsync, wf16(:,30), wf16(:,128), A(:,387), n3(:,797), t3x256(:,:,387), nhel, den(271))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,129), A(:,388), n3(:,798), t3x256(:,:,388), nhel, den(273))
    call Hcont_VV(nsync, wf16(:,74), wf16(:,130), A(:,389), n3(:,799), t3x256(:,:,389), nhel, den(274))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,131), A(:,390), n3(:,800), t3x256(:,:,390), nhel, den(276))
    call Hcont_VV(nsync, wf16(:,74), wf16(:,132), A(:,391), n3(:,801), t3x256(:,:,391), nhel, den(277))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,133), A(:,392), n3(:,802), t3x256(:,:,392), nhel, den(279))
    call Hcont_VV(nsync, wf16(:,73), wf16(:,134), A(:,393), n3(:,803), t3x256(:,:,393), nhel, den(280))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,133), A(:,394), n3(:,804), t3x256(:,:,394), nhel, den(281))
    call Hcont_VV(nsync, wf16(:,30), wf16(:,134), A(:,395), n3(:,805), t3x256(:,:,395), nhel, den(282))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,129), A(:,396), n3(:,806), t3x256(:,:,396), nhel, den(283))
    call Hcont_VV(nsync, wf16(:,34), wf16(:,130), A(:,397), n3(:,807), t3x256(:,:,397), nhel, den(284))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,131), A(:,398), n3(:,808), t3x256(:,:,398), nhel, den(285))
    call Hcont_VV(nsync, wf16(:,34), wf16(:,132), A(:,399), n3(:,809), t3x256(:,:,399), nhel, den(286))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,135), A(:,400), n3(:,810), t3x256(:,:,400), nhel, den(288))
    call Hcont_VV(nsync, wf16(:,29), wf16(:,136), A(:,401), n3(:,811), t3x256(:,:,401), nhel, den(289))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,137), A(:,402), n3(:,812), t3x256(:,:,402), nhel, den(291))
    call Hcont_VV(nsync, wf16(:,29), wf16(:,138), A(:,403), n3(:,813), t3x256(:,:,403), nhel, den(292))
    call Hcont_VV(nsync, wf16(:,25), wf16(:,139), A(:,404), n3(:,814), t3x256(:,:,404), nhel, den(294))
    call Hcont_VV(nsync, wf16(:,31), wf16(:,140), A(:,405), n3(:,815), t3x256(:,:,405), nhel, den(295))
    call Hcont_VV(nsync, wf16(:,27), wf16(:,139), A(:,406), n3(:,816), t3x256(:,:,406), nhel, den(296))
    call Hcont_VV(nsync, wf16(:,32), wf16(:,140), A(:,407), n3(:,817), t3x256(:,:,407), nhel, den(297))
    call Hcont_VV(nsync, wf16(:,23), wf16(:,135), A(:,408), n3(:,818), t3x256(:,:,408), nhel, den(298))
    call Hcont_VV(nsync, wf16(:,33), wf16(:,136), A(:,409), n3(:,819), t3x256(:,:,409), nhel, den(299))
    call Hcont_VV(nsync, wf16(:,23), wf16(:,137), A(:,410), n3(:,820), t3x256(:,:,410), nhel, den(300))
    call Hcont_VV(nsync, wf16(:,33), wf16(:,138), A(:,411), n3(:,821), t3x256(:,:,411), nhel, den(301))
    call Hcont_VV(nsync, wf16(:,25), wf16(:,141), A(:,412), n3(:,822), t3x256(:,:,412), nhel, den(303))
    call Hcont_VV(nsync, wf16(:,31), wf16(:,142), A(:,413), n3(:,823), t3x256(:,:,413), nhel, den(304))
    call Hcont_VV(nsync, wf16(:,27), wf16(:,141), A(:,414), n3(:,824), t3x256(:,:,414), nhel, den(305))
    call Hcont_VV(nsync, wf16(:,32), wf16(:,142), A(:,415), n3(:,825), t3x256(:,:,415), nhel, den(306))
    call Hcont_VV(nsync, wf16(:,35), wf16(:,139), A(:,416), n3(:,826), t3x256(:,:,416), nhel, den(307))
    call Hcont_VV(nsync, wf16(:,41), wf16(:,140), A(:,417), n3(:,827), t3x256(:,:,417), nhel, den(308))
    call Hcont_VV(nsync, wf16(:,42), wf16(:,140), A(:,418), n3(:,828), t3x256(:,:,418), nhel, den(309))
    call Hcont_VV(nsync, wf16(:,35), wf16(:,141), A(:,419), n3(:,829), t3x256(:,:,419), nhel, den(310))
    call Hcont_VV(nsync, wf16(:,41), wf16(:,142), A(:,420), n3(:,830), t3x256(:,:,420), nhel, den(311))
    call Hcont_VV(nsync, wf16(:,42), wf16(:,142), A(:,421), n3(:,831), t3x256(:,:,421), nhel, den(312))
    call Hcont_VV(nsync, wf16(:,37), wf16(:,127), A(:,422), n3(:,832), t3x256(:,:,422), nhel, den(313))
    call Hcont_VV(nsync, wf16(:,43), wf16(:,128), A(:,423), n3(:,833), t3x256(:,:,423), nhel, den(314))
    call Hcont_VV(nsync, wf16(:,44), wf16(:,128), A(:,424), n3(:,834), t3x256(:,:,424), nhel, den(315))
    call Hcont_VV(nsync, wf16(:,44), wf16(:,134), A(:,425), n3(:,835), t3x256(:,:,425), nhel, den(316))
    call Hcont_VV(nsync, wf16(:,37), wf16(:,133), A(:,426), n3(:,836), t3x256(:,:,426), nhel, den(317))
    call Hcont_VV(nsync, wf16(:,43), wf16(:,134), A(:,427), n3(:,837), t3x256(:,:,427), nhel, den(318))
    call Hcont_VV(nsync, wf16(:,45), wf16(:,135), A(:,428), n3(:,838), t3x256(:,:,428), nhel, den(319))
    call Hcont_VV(nsync, wf16(:,51), wf16(:,136), A(:,429), n3(:,839), t3x256(:,:,429), nhel, den(320))
    call Hcont_VV(nsync, wf16(:,45), wf16(:,137), A(:,430), n3(:,840), t3x256(:,:,430), nhel, den(321))
    call Hcont_VV(nsync, wf16(:,51), wf16(:,138), A(:,431), n3(:,841), t3x256(:,:,431), nhel, den(322))
    call Hcont_VV(nsync, wf16(:,52), wf16(:,138), A(:,432), n3(:,842), t3x256(:,:,432), nhel, den(323))
    call Hcont_VV(nsync, wf16(:,52), wf16(:,136), A(:,433), n3(:,843), t3x256(:,:,433), nhel, den(324))
    call Hcont_VV(nsync, wf16(:,53), wf16(:,132), A(:,434), n3(:,844), t3x256(:,:,434), nhel, den(325))
    call Hcont_VV(nsync, wf16(:,47), wf16(:,129), A(:,435), n3(:,845), t3x256(:,:,435), nhel, den(326))
    call Hcont_VV(nsync, wf16(:,54), wf16(:,130), A(:,436), n3(:,846), t3x256(:,:,436), nhel, den(327))
    call Hcont_VV(nsync, wf16(:,47), wf16(:,131), A(:,437), n3(:,847), t3x256(:,:,437), nhel, den(328))
    call Hcont_VV(nsync, wf16(:,54), wf16(:,132), A(:,438), n3(:,848), t3x256(:,:,438), nhel, den(329))
    call Hcont_VV(nsync, wf16(:,53), wf16(:,130), A(:,439), n3(:,849), t3x256(:,:,439), nhel, den(330))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(1), M2(1) ! M1helarray(1,256)
  integer :: empty(0), i

  M1(1)%j = (A(j,8)%j+A(j,11)%j+A(j,18)%j+A(j,21)%j+A(j,50)%j+A(j,51)%j+A(j,70)%j+A(j,71)%j)*f(1)+A(j,1)%j*f(2)+(A(j,4)%j &
       +A(j,7)%j)*f(3)+(-A(j,2)%j-A(j,5)%j)*f(11)+(A(j,10)%j+A(j,13)%j+A(j,15)%j+A(j,17)%j+A(j,20)%j+A(j,23)%j+A(j,25)%j+A(j,27)%j &
       +A(j,45)%j+A(j,47)%j+A(j,48)%j+A(j,49)%j+A(j,65)%j+A(j,67)%j+A(j,68)%j+A(j,69)%j)*f(14)+(A(j,28)%j+A(j,32)%j)*f(19)+( &
       -A(j,30)%j-A(j,34)%j-A(j,36)%j-A(j,40)%j)*f(20)+(-A(j,9)%j-A(j,14)%j-A(j,19)%j-A(j,24)%j+A(j,52)%j+A(j,58)%j+A(j,72)%j &
       +A(j,79)%j)*f(21)+(A(j,38)%j+A(j,42)%j)*f(22)+(A(j,12)%j+A(j,16)%j+A(j,22)%j+A(j,26)%j-A(j,55)%j-A(j,62)%j-A(j,74)%j &
       -A(j,81)%j)*f(23)+(A(j,3)%j+A(j,6)%j+A(j,29)%j+A(j,31)%j+A(j,33)%j+A(j,35)%j+A(j,37)%j+A(j,39)%j+A(j,41)%j+A(j,43)%j &
       -A(j,44)%j-A(j,46)%j+A(j,53)%j+A(j,54)%j+A(j,56)%j+A(j,57)%j+A(j,59)%j+A(j,60)%j+A(j,61)%j+A(j,63)%j-A(j,64)%j-A(j,66)%j &
       +A(j,73)%j+A(j,75)%j+A(j,76)%j+A(j,77)%j+A(j,78)%j+A(j,80)%j+A(j,82)%j+A(j,83)%j+A(j,84)%j+A(j,85)%j+A(j,86)%j+A(j,87)%j &
       +A(j,88)%j+A(j,89)%j+A(j,90)%j+A(j,91)%j+A(j,92)%j+A(j,93)%j)*f(24)

  M2(1)%j = (-A(j,368)%j-A(j,369)%j-A(j,370)%j-A(j,371)%j-A(j,380)%j-A(j,381)%j-A(j,382)%j-A(j,383)%j)*f(4)+(A(j,108)%j+A(j,109)%j &
       +A(j,128)%j+A(j,133)%j+A(j,196)%j+A(j,201)%j+A(j,226)%j+A(j,229)%j+A(j,280)%j+A(j,281)%j+A(j,332)%j+A(j,333)%j)*f(5) &
       +A(j,95)%j*f(6)+(A(j,96)%j+A(j,97)%j+A(j,100)%j+A(j,105)%j+A(j,154)%j+A(j,159)%j+A(j,184)%j+A(j,187)%j+A(j,260)%j &
       +A(j,261)%j+A(j,312)%j+A(j,313)%j)*f(7)+A(j,94)%j*f(8)+(A(j,222)%j+A(j,225)%j)*f(9)+(A(j,164)%j+A(j,167)%j)*f(10)+( &
       -A(j,220)%j-A(j,223)%j)*f(12)+(-A(j,162)%j-A(j,165)%j)*f(13)+(-A(j,361)%j-A(j,363)%j-A(j,365)%j-A(j,367)%j-A(j,373)%j &
       -A(j,375)%j-A(j,377)%j-A(j,379)%j)*f(15)+(A(j,153)%j+A(j,156)%j)*f(16)+(A(j,99)%j+A(j,102)%j+A(j,127)%j+A(j,130)%j &
       +A(j,132)%j+A(j,135)%j+A(j,195)%j+A(j,198)%j+A(j,200)%j+A(j,203)%j+A(j,228)%j+A(j,231)%j+A(j,233)%j+A(j,235)%j+A(j,275)%j &
       +A(j,276)%j+A(j,277)%j+A(j,279)%j+A(j,327)%j+A(j,328)%j+A(j,329)%j+A(j,331)%j)*f(17)+(A(j,104)%j+A(j,107)%j+A(j,158)%j &
       +A(j,161)%j+A(j,186)%j+A(j,189)%j+A(j,191)%j+A(j,193)%j+A(j,255)%j+A(j,256)%j+A(j,257)%j+A(j,259)%j+A(j,307)%j+A(j,308)%j &
       +A(j,309)%j+A(j,311)%j)*f(18)+(-A(j,384)%j-A(j,388)%j-A(j,400)%j-A(j,404)%j)*f(25)+(A(j,386)%j+A(j,390)%j+A(j,392)%j &
       +A(j,396)%j+A(j,402)%j+A(j,406)%j+A(j,408)%j+A(j,412)%j)*f(26)+(A(j,360)%j+A(j,364)%j+A(j,372)%j+A(j,376)%j-A(j,416)%j &
       -A(j,422)%j-A(j,428)%j-A(j,435)%j)*f(27)+(-A(j,394)%j-A(j,398)%j-A(j,410)%j-A(j,414)%j)*f(28)+(-A(j,362)%j-A(j,366)%j &
       -A(j,374)%j-A(j,378)%j+A(j,419)%j+A(j,426)%j+A(j,430)%j+A(j,437)%j)*f(29)+(-A(j,385)%j-A(j,387)%j-A(j,389)%j-A(j,391)%j &
       -A(j,393)%j-A(j,395)%j-A(j,397)%j-A(j,399)%j-A(j,401)%j-A(j,403)%j-A(j,405)%j-A(j,407)%j-A(j,409)%j-A(j,411)%j-A(j,413)%j &
       -A(j,415)%j-A(j,417)%j-A(j,418)%j-A(j,420)%j-A(j,421)%j-A(j,423)%j-A(j,424)%j-A(j,425)%j-A(j,427)%j-A(j,429)%j-A(j,431)%j &
       -A(j,432)%j-A(j,433)%j-A(j,434)%j-A(j,436)%j-A(j,438)%j-A(j,439)%j)*f(30)+(-A(j,168)%j-A(j,176)%j)*f(31)+(A(j,172)%j &
       +A(j,178)%j)*f(32)+(A(j,152)%j+A(j,155)%j-A(j,248)%j-A(j,300)%j)*f(33)+(A(j,169)%j+A(j,173)%j+A(j,177)%j+A(j,179)%j &
       +A(j,249)%j+A(j,250)%j+A(j,301)%j+A(j,305)%j)*f(34)+(A(j,110)%j+A(j,114)%j+A(j,136)%j+A(j,140)%j+A(j,206)%j &
       +A(j,216)%j)*f(35)+(-A(j,116)%j-A(j,118)%j-A(j,138)%j-A(j,142)%j-A(j,144)%j-A(j,148)%j-A(j,204)%j-A(j,208)%j-A(j,214)%j &
       -A(j,218)%j)*f(36)+(-A(j,98)%j-A(j,101)%j-A(j,126)%j-A(j,129)%j-A(j,199)%j-A(j,202)%j-A(j,227)%j-A(j,232)%j+A(j,236)%j &
       +A(j,242)%j+A(j,271)%j+A(j,283)%j+A(j,288)%j+A(j,295)%j+A(j,322)%j+A(j,336)%j)*f(37)+(A(j,146)%j+A(j,150)%j+A(j,210)%j &
       +A(j,212)%j)*f(38)+(A(j,131)%j+A(j,134)%j+A(j,194)%j+A(j,197)%j+A(j,230)%j+A(j,234)%j-A(j,246)%j-A(j,268)%j-A(j,286)%j &
       -A(j,297)%j-A(j,320)%j-A(j,338)%j)*f(39)+(A(j,111)%j+A(j,115)%j+A(j,117)%j+A(j,119)%j+A(j,137)%j+A(j,139)%j+A(j,141)%j &
       +A(j,143)%j+A(j,145)%j+A(j,147)%j+A(j,149)%j+A(j,151)%j+A(j,205)%j+A(j,207)%j+A(j,209)%j+A(j,211)%j+A(j,213)%j+A(j,215)%j &
       +A(j,217)%j+A(j,219)%j+A(j,221)%j+A(j,224)%j+A(j,237)%j+A(j,238)%j+A(j,243)%j+A(j,244)%j+A(j,245)%j+A(j,247)%j+A(j,269)%j &
       +A(j,270)%j+A(j,272)%j+A(j,273)%j-A(j,274)%j-A(j,278)%j+A(j,282)%j+A(j,284)%j+A(j,285)%j+A(j,287)%j+A(j,289)%j+A(j,293)%j &
       +A(j,294)%j+A(j,296)%j+A(j,298)%j+A(j,299)%j+A(j,321)%j+A(j,323)%j+A(j,324)%j+A(j,325)%j-A(j,326)%j-A(j,330)%j+A(j,334)%j &
       +A(j,335)%j+A(j,337)%j+A(j,339)%j+A(j,350)%j+A(j,351)%j+A(j,352)%j+A(j,353)%j+A(j,354)%j+A(j,355)%j+A(j,356)%j+A(j,357)%j &
       +A(j,358)%j+A(j,359)%j)*f(40)+(A(j,170)%j+A(j,180)%j)*f(41)+(-A(j,112)%j-A(j,122)%j-A(j,174)%j-A(j,182)%j)*f(42)+( &
       -A(j,157)%j-A(j,160)%j-A(j,185)%j-A(j,190)%j+A(j,251)%j+A(j,263)%j+A(j,302)%j+A(j,316)%j)*f(43)+(A(j,120)%j &
       +A(j,124)%j)*f(44)+(A(j,103)%j+A(j,106)%j+A(j,188)%j+A(j,192)%j-A(j,239)%j-A(j,266)%j-A(j,290)%j-A(j,318)%j)*f(45) &
       +(A(j,113)%j+A(j,121)%j+A(j,123)%j+A(j,125)%j+A(j,163)%j+A(j,166)%j+A(j,171)%j+A(j,175)%j+A(j,181)%j+A(j,183)%j+A(j,240)%j &
       +A(j,241)%j+A(j,252)%j+A(j,253)%j-A(j,254)%j-A(j,258)%j+A(j,262)%j+A(j,264)%j+A(j,265)%j+A(j,267)%j+A(j,291)%j+A(j,292)%j &
       +A(j,303)%j+A(j,304)%j-A(j,306)%j-A(j,310)%j+A(j,314)%j+A(j,315)%j+A(j,317)%j+A(j,319)%j+A(j,340)%j+A(j,341)%j+A(j,342)%j &
       +A(j,343)%j+A(j,344)%j+A(j,345)%j+A(j,346)%j+A(j,347)%j+A(j,348)%j+A(j,349)%j)*f(46)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)  

  !M(i) corresponds to \Gamma_{i} in Fabio's thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppllnnjj_vbs_nexnmxemucdxsx_2_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 1
      do j = 1, 1
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppllnnjj_vbs_nexnmxemucdxsx_2_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M(1), Mct(1)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer ::  i, j

  M2colint_ct = 0

    do i = 1, 1
      do j = 1, 1
        M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i,j)*Mct(j))
      end do
    end do


end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppllnnjj_vbs_nexnmxemucdxsx_2_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2IRadd(37)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 38-1
    colmatpos = 1*k
    do i = 1, 1
      do j = 1, 1
	M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do
  
end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppllnnjj_vbs_nexnmxemucdxsx_2_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabio's thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppllnnjj_vbs_nexnmxemucdxsx_2_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(1)
  type(Hpolcont), intent(out)  :: M0_col(1)
  integer :: i, j


  do j = 1, 1 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 1 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i,j)
    end do    
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppllnnjj_vbs_nexnmxemucdxsx_2_/**/REALKIND
