
module ol_colourmatrix_ppllnnjj_vbs_nenmexmxuxuxdd_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(76,2), K2(2,2), KL(2,2)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [   9,   3]
  K1( 2,:) = [   3,   9]
  K1( 3,:) = [   0,   0]
  K1( 4,:) = [   0,   0]
  K1( 5,:) = [   0,   0]
  K1( 6,:) = [   0,   0]
  K1( 7,:) = [   0,   0]
  K1( 8,:) = [   0,   0]
  K1( 9,:) = [   0,   0]
  K1(10,:) = [   0,   0]
  K1(11,:) = [   0,   0]
  K1(12,:) = [   0,   0]
  K1(13,:) = [   0,   0]
  K1(14,:) = [   0,   0]
  K1(15,:) = [   0,   0]
  K1(16,:) = [   0,   0]
  K1(17,:) = [   0,   0]
  K1(18,:) = [   0,   0]
  K1(19,:) = [   0,   0]
  K1(20,:) = [   0,   0]
  K1(21,:) = [   0,   0]
  K1(22,:) = [   0,   0]
  K1(23,:) = [   0,   0]
  K1(24,:) = [   0,   0]
  K1(25,:) = [   0,   0]
  K1(26,:) = [   0,   0]
  K1(27,:) = [   0,   0]
  K1(28,:) = [   0,   0]
  K1(29,:) = [   0,   0]
  K1(30,:) = [   0,   0]
  K1(31,:) = [  12,   4]
  K1(32,:) = [   4,  12]
  K1(33,:) = [   0,   0]
  K1(34,:) = [   0,   0]
  K1(35,:) = [   0,   0]
  K1(36,:) = [   0,   0]
  K1(37,:) = [   0,   0]
  K1(38,:) = [   0,   0]
  K1(39,:) = [   0,   0]
  K1(40,:) = [   0,   0]
  K1(41,:) = [   0,   4]
  K1(42,:) = [   4,   0]
  K1(43,:) = [  12,   4]
  K1(44,:) = [   4,  12]
  K1(45,:) = [   0,   0]
  K1(46,:) = [   0,   0]
  K1(47,:) = [   0,   0]
  K1(48,:) = [   0,   0]
  K1(49,:) = [   0,   0]
  K1(50,:) = [   0,   0]
  K1(51,:) = [   0,   0]
  K1(52,:) = [   0,   0]
  K1(53,:) = [   0,  -4]
  K1(54,:) = [  -4, -12]
  K1(55,:) = [ -12,  -4]
  K1(56,:) = [  -4,   0]
  K1(57,:) = [  12,   4]
  K1(58,:) = [   4,  12]
  K1(59,:) = [   0,   0]
  K1(60,:) = [   0,   0]
  K1(61,:) = [   0,   0]
  K1(62,:) = [   0,   0]
  K1(63,:) = [   0,   0]
  K1(64,:) = [   0,   0]
  K1(65,:) = [   0,   0]
  K1(66,:) = [   0,   0]
  K1(67,:) = [ -12,  -4]
  K1(68,:) = [  -4,   0]
  K1(69,:) = [   0,  -4]
  K1(70,:) = [  -4, -12]
  K1(71,:) = [   0,   4]
  K1(72,:) = [   4,   0]
  K1(73,:) = [  12,   4]
  K1(74,:) = [   4,  12]
  K1(75,:) = [   0,   0]
  K1(76,:) = [   0,   0]

  K2(1,:) = [ 9, 3]
  K2(2,:) = [ 3, 9]

  KL(1,:) = [ 9, 3]
  KL(2,:) = [ 3, 9]

  end subroutine colourmatrix_init
end module ol_colourmatrix_ppllnnjj_vbs_nenmexmxuxuxdd_1_/**/REALKIND



module ol_forced_parameters_ppllnnjj_vbs_nenmexmxuxuxdd_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (MM /= 0) write(*,101) 'MM = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppllnnjj_vbs_nenmexmxuxuxdd_1_/**/REALKIND
! **********************************************************************
module ol_loop_storage_ppllnnjj_vbs_nenmexmxuxuxdd_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2  
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  
#ifdef PRECISION_dp
  integer(intkind1), save :: ntry = 1, ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types 
  ! the following are flags for memory allocation of the hol coefficients in dp or qp 
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer(intkind2), parameter :: nheltot = 256 ! number of helicity configurations
  integer(intkind2), save :: nhel = 256 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(256) ! physical helicity states
#endif

  complex(REALKIND), save :: den(271)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2), ex7(2), ex8(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,4), wf8(8,48), wf16(16,76), wf32(32,64), wf256(256,128)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(9), c(17)

  !below the colour vector for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(2,256)

end module ol_loop_storage_ppllnnjj_vbs_nenmexmxuxuxdd_1_/**/REALKIND






! **********************************************************************
module ol_loop_ppllnnjj_vbs_nenmexmxuxuxdd_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2  
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppllnnjj_vbs_nenmexmxuxuxdd_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(1) = (CI*eQED**4*gQCD**2)/(4._/**/REALKIND*sw**4)
    f(2) = (CI*countertermnorm*eQED**4*gQCD**4)/(4._/**/REALKIND*sw**4)
    f(3) = (CI*countertermnorm*ctGqq*eQED**4*gQCD**4)/(4._/**/REALKIND*sw**4)
    f(4) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**4)/(4._/**/REALKIND*sw**4)
    f(5) = (CI*eQED**4*gQCD**4*integralnorm*SwB)/(4._/**/REALKIND*sw**4)
    f(6) = (eQED**4*gQCD**4*integralnorm*SwB)/(sw**4*8._/**/REALKIND)
    f(7) = (eQED**4*gQCD**4*integralnorm*SwB)/(sw**4*4._/**/REALKIND)
    f(8) = (eQED**4*gQCD**4*integralnorm*SwF)/(sw**4*4._/**/REALKIND)
    f(9) = (eQED**4*gQCD**4*integralnorm*SwF)/(sw**4*2._/**/REALKIND)

  c = [ 9*CI*f(5), 27*CI*f(5), 18*f(6), 54*f(6), f(7), 3*f(7), 6*f(7), 8*f(7), 10*f(7), 18*f(7), 21*f(7), 24*f(7), 54*f(7), 3*f(8) &
    , 9*f(8), 3*f(9), 9*f(9) ]
  c = (1._/**/REALKIND / 36) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,5) - MW2)+L(6,5))
  den(2) = 1 /((L(5,10) - MW2)+L(6,10))
  den(3) = 1 /((L(5,21))+L(6,21))
  den(5) = 1 /((L(5,42))+L(6,42))
  den(7) = 1 /((L(5,85))+L(6,85))
  den(10) = 1 /((L(5,106))+L(6,106))
  den(13) = 1 /((L(5,74))+L(6,74))
  den(17) = 1 /((L(5,138))+L(6,138))
  den(19) = 1 /((L(5,170))+L(6,170))
  den(22) = 1 /((L(5,26))+L(6,26))
  den(24) = 1 /((L(5,37))+L(6,37))
  den(26) = 1 /((L(5,90))+L(6,90))
  den(29) = 1 /((L(5,101))+L(6,101))
  den(34) = 1 /((L(5,154))+L(6,154))
  den(37) = 1 /((L(5,69))+L(6,69))
  den(45) = 1 /((L(5,133))+L(6,133))
  den(47) = 1 /((L(5,165))+L(6,165))
  den(50) = 1 /((L(5,149))+L(6,149))
  den(131) = 1 /((L(5,117))+L(6,117))
  den(133) = 1 /((L(5,213))+L(6,213))
  den(135) = 1 /((L(5,181))+L(6,181))
  den(140) = 1 /((L(5,229))+L(6,229))
  den(151) = 1 /((L(5,122))+L(6,122))
  den(153) = 1 /((L(5,218))+L(6,218))
  den(155) = 1 /((L(5,186))+L(6,186))
  den(160) = 1 /((L(5,234))+L(6,234))

  ! denominators
  den(4) = den(1)*den(3)
  den(6) = den(2)*den(5)
  den(8) = den(4)*den(7)
  den(9) = den(6)*den(8)
  den(11) = den(6)*den(10)
  den(12) = den(4)*den(11)
  den(14) = den(2)*den(13)
  den(15) = den(10)*den(14)
  den(16) = den(4)*den(15)
  den(18) = den(2)*den(17)
  den(20) = den(18)*den(19)
  den(21) = den(4)*den(20)
  den(23) = den(2)*den(22)
  den(25) = den(1)*den(24)
  den(27) = den(23)*den(26)
  den(28) = den(25)*den(27)
  den(30) = den(25)*den(29)
  den(31) = den(23)*den(30)
  den(32) = den(14)*den(26)
  den(33) = den(25)*den(32)
  den(35) = den(18)*den(34)
  den(36) = den(25)*den(35)
  den(38) = den(1)*den(37)
  den(39) = den(29)*den(38)
  den(40) = den(23)*den(39)
  den(41) = den(7)*den(38)
  den(42) = den(6)*den(41)
  den(43) = den(18)*den(41)
  den(44) = den(35)*den(38)
  den(46) = den(1)*den(45)
  den(48) = den(46)*den(47)
  den(49) = den(23)*den(48)
  den(51) = den(46)*den(50)
  den(52) = den(6)*den(51)
  den(53) = den(32)*den(46)
  den(54) = den(14)*den(51)
  den(55) = den(4)*den(50)
  den(56) = den(6)*den(55)
  den(57) = den(6)*den(19)
  den(58) = den(4)*den(57)
  den(59) = den(23)*den(34)
  den(60) = den(25)*den(59)
  den(61) = den(25)*den(47)
  den(62) = den(23)*den(61)
  den(63) = den(14)*den(55)
  den(64) = den(8)*den(18)
  den(65) = den(38)*den(59)
  den(66) = den(27)*den(46)
  den(67) = den(14)*den(61)
  den(68) = den(18)*den(30)
  den(69) = den(38)*den(57)
  den(70) = den(20)*den(38)
  den(71) = den(18)*den(39)
  den(72) = den(11)*den(46)
  den(73) = den(14)*den(48)
  den(74) = den(15)*den(46)
  den(75) = den(20)*den(41)
  den(76) = den(35)*den(39)
  den(77) = den(32)*den(48)
  den(78) = den(15)*den(51)
  den(79) = den(3)*den(4)
  den(80) = den(57)*den(79)
  den(81) = den(20)*den(79)
  den(82) = den(22)*den(23)
  den(83) = den(61)*den(82)
  den(84) = den(13)*den(14)
  den(85) = den(61)*den(84)
  den(86) = den(30)*den(35)
  den(87) = den(37)*den(38)
  den(88) = den(57)*den(87)
  den(89) = den(20)*den(87)
  den(90) = den(48)*den(82)
  den(91) = den(11)*den(51)
  den(92) = den(48)*den(84)
  den(93) = den(11)*den(79)
  den(94) = den(15)*den(79)
  den(95) = den(30)*den(82)
  den(96) = den(32)*den(61)
  den(97) = den(17)*den(18)
  den(98) = den(30)*den(97)
  den(99) = den(39)*den(82)
  den(100) = den(41)*den(57)
  den(101) = den(39)*den(97)
  den(102) = den(45)*den(46)
  den(103) = den(11)*den(102)
  den(104) = den(15)*den(102)
  den(105) = den(5)*den(6)
  den(106) = den(55)*den(105)
  den(107) = den(55)*den(84)
  den(108) = den(8)*den(20)
  den(109) = den(24)*den(25)
  den(110) = den(59)*den(109)
  den(111) = den(35)*den(109)
  den(112) = den(59)*den(87)
  den(113) = den(35)*den(87)
  den(114) = den(27)*den(48)
  den(115) = den(51)*den(105)
  den(116) = den(51)*den(84)
  den(117) = den(8)*den(105)
  den(118) = den(15)*den(55)
  den(119) = den(8)*den(97)
  den(120) = den(27)*den(109)
  den(121) = den(32)*den(109)
  den(122) = den(39)*den(59)
  den(123) = den(41)*den(105)
  den(124) = den(41)*den(97)
  den(125) = den(27)*den(102)
  den(126) = den(32)*den(102)
  den(127) = den(8)*den(57)
  den(128) = den(11)*den(55)
  den(129) = den(27)*den(61)
  den(130) = den(30)*den(59)
  den(132) = den(8)*den(131)
  den(134) = den(8)*den(133)
  den(136) = den(55)*den(135)
  den(137) = den(55)*den(133)
  den(138) = den(30)*den(131)
  den(139) = den(61)*den(135)
  den(141) = den(30)*den(140)
  den(142) = den(61)*den(140)
  den(143) = den(41)*den(131)
  den(144) = den(39)*den(131)
  den(145) = den(41)*den(133)
  den(146) = den(39)*den(140)
  den(147) = den(51)*den(135)
  den(148) = den(48)*den(135)
  den(149) = den(51)*den(133)
  den(150) = den(48)*den(140)
  den(152) = den(27)*den(151)
  den(154) = den(27)*den(153)
  den(156) = den(59)*den(155)
  den(157) = den(59)*den(153)
  den(158) = den(11)*den(151)
  den(159) = den(57)*den(155)
  den(161) = den(11)*den(160)
  den(162) = den(57)*den(160)
  den(163) = den(32)*den(151)
  den(164) = den(15)*den(151)
  den(165) = den(32)*den(153)
  den(166) = den(15)*den(160)
  den(167) = den(35)*den(155)
  den(168) = den(20)*den(155)
  den(169) = den(35)*den(153)
  den(170) = den(20)*den(160)
  den(171) = den(4)*den(6)
  den(172) = den(4)*den(14)
  den(173) = den(4)*den(18)
  den(174) = den(2)*den(132)
  den(175) = den(2)*den(134)
  den(176) = den(2)*den(8)
  den(177) = den(2)*den(136)
  den(178) = den(2)*den(137)
  den(179) = den(2)*den(55)
  den(180) = den(2)*den(4)
  den(181) = den(23)*den(25)
  den(182) = den(14)*den(25)
  den(183) = den(18)*den(25)
  den(184) = den(2)*den(138)
  den(185) = den(2)*den(139)
  den(186) = den(2)*den(141)
  den(187) = den(2)*den(30)
  den(188) = den(2)*den(142)
  den(189) = den(2)*den(61)
  den(190) = den(2)*den(25)
  den(191) = den(23)*den(38)
  den(192) = den(6)*den(38)
  den(193) = den(18)*den(38)
  den(194) = den(2)*den(143)
  den(195) = den(2)*den(144)
  den(196) = den(2)*den(145)
  den(197) = den(2)*den(41)
  den(198) = den(2)*den(146)
  den(199) = den(2)*den(39)
  den(200) = den(2)*den(38)
  den(201) = den(23)*den(46)
  den(202) = den(6)*den(46)
  den(203) = den(14)*den(46)
  den(204) = den(2)*den(147)
  den(205) = den(2)*den(148)
  den(206) = den(2)*den(149)
  den(207) = den(2)*den(51)
  den(208) = den(2)*den(150)
  den(209) = den(2)*den(48)
  den(210) = den(2)*den(46)
  den(211) = den(1)*den(152)
  den(212) = den(1)*den(154)
  den(213) = den(1)*den(27)
  den(214) = den(1)*den(156)
  den(215) = den(1)*den(157)
  den(216) = den(1)*den(59)
  den(217) = den(1)*den(23)
  den(218) = den(1)*den(158)
  den(219) = den(1)*den(159)
  den(220) = den(1)*den(161)
  den(221) = den(1)*den(11)
  den(222) = den(1)*den(162)
  den(223) = den(1)*den(57)
  den(224) = den(1)*den(6)
  den(225) = den(1)*den(163)
  den(226) = den(1)*den(164)
  den(227) = den(1)*den(165)
  den(228) = den(1)*den(32)
  den(229) = den(1)*den(166)
  den(230) = den(1)*den(15)
  den(231) = den(1)*den(14)
  den(232) = den(1)*den(167)
  den(233) = den(1)*den(168)
  den(234) = den(1)*den(169)
  den(235) = den(1)*den(35)
  den(236) = den(1)*den(170)
  den(237) = den(1)*den(20)
  den(238) = den(1)*den(18)
  den(239) = den(1)*den(2)
  den(240) = den(6)*den(134)
  den(241) = den(6)*den(137)
  den(242) = den(4)*den(161)
  den(243) = den(4)*den(162)
  den(244) = den(14)*den(136)
  den(245) = den(4)*den(166)
  den(246) = den(18)*den(132)
  den(247) = den(4)*den(170)
  den(248) = den(25)*den(154)
  den(249) = den(25)*den(157)
  den(250) = den(23)*den(141)
  den(251) = den(23)*den(142)
  den(252) = den(25)*den(165)
  den(253) = den(14)*den(139)
  den(254) = den(25)*den(169)
  den(255) = den(18)*den(138)
  den(256) = den(38)*den(156)
  den(257) = den(23)*den(146)
  den(258) = den(6)*den(145)
  den(259) = den(38)*den(159)
  den(260) = den(18)*den(143)
  den(261) = den(38)*den(167)
  den(262) = den(18)*den(144)
  den(263) = den(38)*den(168)
  den(264) = den(46)*den(152)
  den(265) = den(23)*den(150)
  den(266) = den(6)*den(149)
  den(267) = den(46)*den(158)
  den(268) = den(46)*den(163)
  den(269) = den(14)*den(147)
  den(270) = den(46)*den(164)
  den(271) = den(14)*den(148)

end subroutine denominators

!
!
!
!
!
! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_ppllnnjj_vbs_nenmexmxuxuxdd_1_/**/DREALKIND, only: ntry, nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for nu_e nu_mu e+ mu+ anti-up anti-up down down -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppllnnjj_vbs_nenmexmxuxuxdd_1, only: external_perm_ppllnnjj_vbs_nenmexmxuxuxdd_1, &
    & external_perm_inv_ppllnnjj_vbs_nenmexmxuxuxdd_1, extcomb_perm_ppllnnjj_vbs_nenmexmxuxuxdd_1, &
    & average_factor_ppllnnjj_vbs_nenmexmxuxuxdd_1
  use ol_external_ppllnnjj_vbs_nenmexmxuxuxdd_1, only: H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppllnnjj_vbs_nenmexmxuxuxdd_1_/**/REALKIND, only: colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppllnnjj_vbs_nenmexmxuxuxdd_1_/**/REALKIND, only: check_forced_parameters
  use ol_heltables_OLR_ppllnnjj_vbs_nenmexmxuxuxdd_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: IR_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,8)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(37)
  logical, intent(in) :: qp_kinematics

  integer           :: shift, k, r, m, n
  real(REALKIND)    :: P(0:3,8)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,8)
#endif
  integer           :: extmasses2(8)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(37)
  complex(REALKIND) :: M1(2), M2(2) 
  real(REALKIND)    :: P_scatt_intern(0:3,8)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(2,256)
  type(Hpolcont) :: M1helarray_ct(2,256)

  type(Hpolcont) :: A(256,128)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(128)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call set_parameter("ew_renorm", 0)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, 0, 0, 0, 0, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, external_perm_inv_ppllnnjj_vbs_nenmexmxuxuxdd_1, 8, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_Q(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_A(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rZERO, H4, ex4, POLSEL(4),4)
  call pol_wf_A(P(:,5), rZERO, H5, ex5, POLSEL(5),5)
  call pol_wf_A(P(:,6), rZERO, H6, ex6, POLSEL(6),6)
  call pol_wf_Q(P(:,7), rZERO, H7, ex7, POLSEL(7),7)
  call pol_wf_Q(P(:,8), rZERO, H8, ex8, POLSEL(8),8)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_W(ntry, ex1(:), ex3(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_QA_W(ntry, ex2(:), ex4(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call prop_W_W(ntry, wf4(:,1), 5, MW, 1_intkind1, wf4(:,3), n2(1))
  call prop_W_W(ntry, wf4(:,2), 10, MW, 1_intkind1, wf4(:,4), n2(2))
  call vert_AW_Q(ntry, ex5(:), wf4(:,3), wf8(:,1), n3(:,3), t3x8(:,:,1))
  call vert_AW_Q(ntry, ex6(:), wf4(:,4), wf8(:,2), n3(:,4), t3x8(:,:,2))
  call prop_A_Q(ntry, wf8(:,1), 21, ZERO, 0_intkind1, wf8(:,3), n2(3))
  call prop_A_Q(ntry, wf8(:,2), 42, ZERO, 0_intkind1, wf8(:,4), n2(4))
  call vert_QA_V(ntry, ex7(:), wf8(:,3), wf16(:,1), n3(:,5), t3x16(:,:,1))
  call vert_QA_V(ntry, ex8(:), wf8(:,4), wf16(:,2), n3(:,6), t3x16(:,:,2))
  call vert_QA_V(ntry, ex7(:), wf8(:,4), wf16(:,3), n3(:,7), t3x16(:,:,3))
  call vert_QA_V(ntry, ex8(:), wf8(:,3), wf16(:,4), n3(:,8), t3x16(:,:,4))
  call vert_WQ_A(ntry, wf4(:,4), ex7(:), wf8(:,5), n3(:,9), t3x8(:,:,3))
  call prop_Q_A(ntry, wf8(:,5), 74, ZERO, 0_intkind1, wf8(:,6), n2(5))
  call vert_QA_V(ntry, wf8(:,6), ex6(:), wf16(:,5), n3(:,10), t3x16(:,:,5))
  call vert_WQ_A(ntry, wf4(:,4), ex8(:), wf8(:,7), n3(:,11), t3x8(:,:,4))
  call prop_Q_A(ntry, wf8(:,7), 138, ZERO, 0_intkind1, wf8(:,8), n2(6))
  call vert_QA_V(ntry, wf8(:,8), ex6(:), wf16(:,6), n3(:,12), t3x16(:,:,6))
  call vert_AW_Q(ntry, ex5(:), wf4(:,4), wf8(:,9), n3(:,13), t3x8(:,:,5))
  call vert_AW_Q(ntry, ex6(:), wf4(:,3), wf8(:,10), n3(:,14), t3x8(:,:,6))
  call prop_A_Q(ntry, wf8(:,9), 26, ZERO, 0_intkind1, wf8(:,11), n2(7))
  call prop_A_Q(ntry, wf8(:,10), 37, ZERO, 0_intkind1, wf8(:,12), n2(8))
  call vert_QA_V(ntry, ex7(:), wf8(:,11), wf16(:,7), n3(:,15), t3x16(:,:,7))
  call vert_QA_V(ntry, ex8(:), wf8(:,12), wf16(:,8), n3(:,16), t3x16(:,:,8))
  call vert_QA_V(ntry, ex7(:), wf8(:,12), wf16(:,9), n3(:,17), t3x16(:,:,9))
  call vert_QA_V(ntry, ex8(:), wf8(:,11), wf16(:,10), n3(:,18), t3x16(:,:,10))
  call vert_QA_V(ntry, wf8(:,6), ex5(:), wf16(:,11), n3(:,19), t3x16(:,:,11))
  call vert_QA_V(ntry, wf8(:,8), ex5(:), wf16(:,12), n3(:,20), t3x16(:,:,12))
  call vert_WQ_A(ntry, wf4(:,3), ex7(:), wf8(:,13), n3(:,21), t3x8(:,:,7))
  call prop_Q_A(ntry, wf8(:,13), 69, ZERO, 0_intkind1, wf8(:,14), n2(9))
  call vert_QA_V(ntry, wf8(:,14), ex6(:), wf16(:,13), n3(:,22), t3x16(:,:,13))
  call vert_QA_V(ntry, wf8(:,14), ex5(:), wf16(:,14), n3(:,23), t3x16(:,:,14))
  call vert_WQ_A(ntry, wf4(:,3), ex8(:), wf8(:,15), n3(:,24), t3x8(:,:,8))
  call prop_Q_A(ntry, wf8(:,15), 133, ZERO, 0_intkind1, wf8(:,16), n2(10))
  call vert_QA_V(ntry, wf8(:,16), ex6(:), wf16(:,15), n3(:,25), t3x16(:,:,15))
  call vert_QA_V(ntry, wf8(:,16), ex5(:), wf16(:,16), n3(:,26), t3x16(:,:,16))
  call counter_QA_V(ntry, ex8(:), wf8(:,4), wf16(:,17), n3(:,27), t3x16(:,:,17))
  call counter_QA_V(ntry, ex8(:), wf8(:,3), wf16(:,18), n3(:,28), t3x16(:,:,18))
  call counter_WQ_A(ntry, wf4(:,4), ex8(:), wf8(:,17), n3(:,29), t3x8(:,:,9))
  call prop_Q_A(ntry, wf8(:,17), 138, ZERO, 0_intkind1, wf8(:,18), n2(11))
  call vert_QA_V(ntry, wf8(:,18), ex6(:), wf16(:,19), n3(:,30), t3x16(:,:,19))
  call counter_QA_V(ntry, ex8(:), wf8(:,12), wf16(:,20), n3(:,31), t3x16(:,:,20))
  call counter_QA_V(ntry, ex8(:), wf8(:,11), wf16(:,21), n3(:,32), t3x16(:,:,21))
  call vert_QA_V(ntry, wf8(:,18), ex5(:), wf16(:,22), n3(:,33), t3x16(:,:,22))
  call counter_WQ_A(ntry, wf4(:,3), ex8(:), wf8(:,19), n3(:,34), t3x8(:,:,10))
  call prop_Q_A(ntry, wf8(:,19), 133, ZERO, 0_intkind1, wf8(:,20), n2(12))
  call vert_QA_V(ntry, wf8(:,20), ex6(:), wf16(:,23), n3(:,35), t3x16(:,:,23))
  call vert_QA_V(ntry, wf8(:,20), ex5(:), wf16(:,24), n3(:,36), t3x16(:,:,24))
  call counter_QA_V(ntry, ex7(:), wf8(:,4), wf16(:,25), n3(:,37), t3x16(:,:,25))
  call counter_QA_V(ntry, ex7(:), wf8(:,3), wf16(:,26), n3(:,38), t3x16(:,:,26))
  call counter_WQ_A(ntry, wf4(:,4), ex7(:), wf8(:,21), n3(:,39), t3x8(:,:,11))
  call prop_Q_A(ntry, wf8(:,21), 74, ZERO, 0_intkind1, wf8(:,22), n2(13))
  call vert_QA_V(ntry, wf8(:,22), ex6(:), wf16(:,27), n3(:,40), t3x16(:,:,27))
  call counter_QA_V(ntry, ex7(:), wf8(:,12), wf16(:,28), n3(:,41), t3x16(:,:,28))
  call counter_QA_V(ntry, ex7(:), wf8(:,11), wf16(:,29), n3(:,42), t3x16(:,:,29))
  call vert_QA_V(ntry, wf8(:,22), ex5(:), wf16(:,30), n3(:,43), t3x16(:,:,30))
  call counter_WQ_A(ntry, wf4(:,3), ex7(:), wf8(:,23), n3(:,44), t3x8(:,:,12))
  call prop_Q_A(ntry, wf8(:,23), 69, ZERO, 0_intkind1, wf8(:,24), n2(14))
  call vert_QA_V(ntry, wf8(:,24), ex6(:), wf16(:,31), n3(:,45), t3x16(:,:,31))
  call vert_QA_V(ntry, wf8(:,24), ex5(:), wf16(:,32), n3(:,46), t3x16(:,:,32))
  call counter_QA_V(ntry, wf8(:,6), ex6(:), wf16(:,33), n3(:,47), t3x16(:,:,33))
  call counter_QA_V(ntry, wf8(:,8), ex6(:), wf16(:,34), n3(:,48), t3x16(:,:,34))
  call counter_AW_Q(ntry, ex6(:), wf4(:,4), wf8(:,25), n3(:,49), t3x8(:,:,13))
  call prop_A_Q(ntry, wf8(:,25), 42, ZERO, 0_intkind1, wf8(:,26), n2(15))
  call vert_QA_V(ntry, ex8(:), wf8(:,26), wf16(:,35), n3(:,50), t3x16(:,:,35))
  call vert_QA_V(ntry, ex7(:), wf8(:,26), wf16(:,36), n3(:,51), t3x16(:,:,36))
  call counter_QA_V(ntry, wf8(:,14), ex6(:), wf16(:,37), n3(:,52), t3x16(:,:,37))
  call counter_QA_V(ntry, wf8(:,16), ex6(:), wf16(:,38), n3(:,53), t3x16(:,:,38))
  call counter_AW_Q(ntry, ex6(:), wf4(:,3), wf8(:,27), n3(:,54), t3x8(:,:,14))
  call prop_A_Q(ntry, wf8(:,27), 37, ZERO, 0_intkind1, wf8(:,28), n2(16))
  call vert_QA_V(ntry, ex8(:), wf8(:,28), wf16(:,39), n3(:,55), t3x16(:,:,39))
  call vert_QA_V(ntry, ex7(:), wf8(:,28), wf16(:,40), n3(:,56), t3x16(:,:,40))
  call counter_QA_V(ntry, wf8(:,6), ex5(:), wf16(:,41), n3(:,57), t3x16(:,:,41))
  call counter_QA_V(ntry, wf8(:,8), ex5(:), wf16(:,42), n3(:,58), t3x16(:,:,42))
  call counter_AW_Q(ntry, ex5(:), wf4(:,4), wf8(:,29), n3(:,59), t3x8(:,:,15))
  call prop_A_Q(ntry, wf8(:,29), 26, ZERO, 0_intkind1, wf8(:,30), n2(17))
  call vert_QA_V(ntry, ex7(:), wf8(:,30), wf16(:,43), n3(:,60), t3x16(:,:,43))
  call vert_QA_V(ntry, ex8(:), wf8(:,30), wf16(:,44), n3(:,61), t3x16(:,:,44))
  call counter_QA_V(ntry, wf8(:,14), ex5(:), wf16(:,45), n3(:,62), t3x16(:,:,45))
  call counter_QA_V(ntry, wf8(:,16), ex5(:), wf16(:,46), n3(:,63), t3x16(:,:,46))
  call counter_AW_Q(ntry, ex5(:), wf4(:,3), wf8(:,31), n3(:,64), t3x8(:,:,16))
  call prop_A_Q(ntry, wf8(:,31), 21, ZERO, 0_intkind1, wf8(:,32), n2(18))
  call vert_QA_V(ntry, ex7(:), wf8(:,32), wf16(:,47), n3(:,65), t3x16(:,:,47))
  call vert_QA_V(ntry, ex8(:), wf8(:,32), wf16(:,48), n3(:,66), t3x16(:,:,48))
  call counter_V_V(ctGG,21,ntry, wf16(:,14), 85, wf16(:,49), n2(19))
  call counter_V_V(ctGG,21,ntry, wf16(:,12), 154, wf16(:,50), n2(20))
  call counter_V_V(ctGG,21,ntry, wf16(:,11), 90, wf16(:,51), n2(21))
  call counter_V_V(ctGG,21,ntry, wf16(:,16), 149, wf16(:,52), n2(22))
  call counter_A_Q(ctqq,1,ntry, wf8(:,3), 21, wf8(:,33), n2(23))
  call prop_A_Q(ntry, wf8(:,33), 21, ZERO, 0_intkind1, wf8(:,34), n2(24))
  call vert_QA_V(ntry, ex7(:), wf8(:,34), wf16(:,53), n3(:,67), t3x16(:,:,49))
  call counter_A_Q(ctqq,1,ntry, wf8(:,11), 26, wf8(:,35), n2(25))
  call prop_A_Q(ntry, wf8(:,35), 26, ZERO, 0_intkind1, wf8(:,36), n2(26))
  call vert_QA_V(ntry, ex7(:), wf8(:,36), wf16(:,54), n3(:,68), t3x16(:,:,50))
  call counter_Q_A(ctqq,2,ntry, wf8(:,6), 74, wf8(:,37), n2(27))
  call prop_Q_A(ntry, wf8(:,37), 74, ZERO, 0_intkind1, wf8(:,38), n2(28))
  call vert_QA_V(ntry, wf8(:,38), ex5(:), wf16(:,55), n3(:,69), t3x16(:,:,51))
  call counter_Q_A(ctqq,2,ntry, wf8(:,14), 69, wf8(:,39), n2(29))
  call prop_Q_A(ntry, wf8(:,39), 69, ZERO, 0_intkind1, wf8(:,40), n2(30))
  call vert_QA_V(ntry, wf8(:,40), ex5(:), wf16(:,56), n3(:,70), t3x16(:,:,52))
  call vert_QA_V(ntry, ex8(:), wf8(:,34), wf16(:,57), n3(:,71), t3x16(:,:,53))
  call vert_QA_V(ntry, ex8(:), wf8(:,36), wf16(:,58), n3(:,72), t3x16(:,:,54))
  call counter_Q_A(ctqq,2,ntry, wf8(:,8), 138, wf8(:,41), n2(31))
  call prop_Q_A(ntry, wf8(:,41), 138, ZERO, 0_intkind1, wf8(:,42), n2(32))
  call vert_QA_V(ntry, wf8(:,42), ex5(:), wf16(:,59), n3(:,73), t3x16(:,:,55))
  call counter_Q_A(ctqq,2,ntry, wf8(:,16), 133, wf8(:,43), n2(33))
  call prop_Q_A(ntry, wf8(:,43), 133, ZERO, 0_intkind1, wf8(:,44), n2(34))
  call vert_QA_V(ntry, wf8(:,44), ex5(:), wf16(:,60), n3(:,74), t3x16(:,:,56))
  call counter_A_Q(ctqq,1,ntry, wf8(:,4), 42, wf8(:,45), n2(35))
  call prop_A_Q(ntry, wf8(:,45), 42, ZERO, 0_intkind1, wf8(:,46), n2(36))
  call vert_QA_V(ntry, ex7(:), wf8(:,46), wf16(:,61), n3(:,75), t3x16(:,:,57))
  call vert_QA_V(ntry, wf8(:,38), ex6(:), wf16(:,62), n3(:,76), t3x16(:,:,58))
  call counter_V_V(ctGG,21,ntry, wf16(:,6), 170, wf16(:,63), n2(37))
  call counter_A_Q(ctqq,1,ntry, wf8(:,12), 37, wf8(:,47), n2(38))
  call prop_A_Q(ntry, wf8(:,47), 37, ZERO, 0_intkind1, wf8(:,48), n2(39))
  call vert_QA_V(ntry, ex7(:), wf8(:,48), wf16(:,64), n3(:,77), t3x16(:,:,59))
  call vert_QA_V(ntry, wf8(:,40), ex6(:), wf16(:,65), n3(:,78), t3x16(:,:,60))
  call counter_V_V(ctGG,21,ntry, wf16(:,15), 165, wf16(:,66), n2(40))
  call vert_QA_V(ntry, ex8(:), wf8(:,46), wf16(:,67), n3(:,79), t3x16(:,:,61))
  call counter_V_V(ctGG,21,ntry, wf16(:,5), 106, wf16(:,68), n2(41))
  call vert_QA_V(ntry, wf8(:,42), ex6(:), wf16(:,69), n3(:,80), t3x16(:,:,62))
  call vert_QA_V(ntry, ex8(:), wf8(:,48), wf16(:,70), n3(:,81), t3x16(:,:,63))
  call counter_V_V(ctGG,21,ntry, wf16(:,13), 101, wf16(:,71), n2(42))
  call vert_QA_V(ntry, wf8(:,44), ex6(:), wf16(:,72), n3(:,82), t3x16(:,:,64))
  call counter_V_V(ctGG,21,ntry, wf16(:,1), 85, wf16(:,73), n2(43))
  call counter_V_V(ctGG,21,ntry, wf16(:,3), 106, wf16(:,74), n2(44))
  call counter_V_V(ctGG,21,ntry, wf16(:,7), 90, wf16(:,75), n2(45))
  call counter_V_V(ctGG,21,ntry, wf16(:,9), 101, wf16(:,76), n2(46))
  call vert_AV_Q(ntry, ex6(:), wf16(:,1), wf32(:,1), n3(:,83), t3x32(:,:,1))
  call prop_A_Q(ntry, wf32(:,1), 117, ZERO, 0_intkind1, wf32(:,2), n2(47))
  call vert_VQ_A(ntry, wf16(:,1), ex8(:), wf32(:,3), n3(:,84), t3x32(:,:,2))
  call prop_Q_A(ntry, wf32(:,3), 213, ZERO, 0_intkind1, wf32(:,4), n2(48))
  call vert_AV_Q(ntry, ex6(:), wf16(:,4), wf32(:,5), n3(:,85), t3x32(:,:,3))
  call prop_A_Q(ntry, wf32(:,5), 181, ZERO, 0_intkind1, wf32(:,6), n2(49))
  call vert_VQ_A(ntry, wf16(:,4), ex7(:), wf32(:,7), n3(:,86), t3x32(:,:,4))
  call prop_Q_A(ntry, wf32(:,7), 213, ZERO, 0_intkind1, wf32(:,8), n2(50))
  call vert_AV_Q(ntry, ex5(:), wf16(:,9), wf32(:,9), n3(:,87), t3x32(:,:,5))
  call prop_A_Q(ntry, wf32(:,9), 117, ZERO, 0_intkind1, wf32(:,10), n2(51))
  call vert_AV_Q(ntry, ex5(:), wf16(:,8), wf32(:,11), n3(:,88), t3x32(:,:,6))
  call prop_A_Q(ntry, wf32(:,11), 181, ZERO, 0_intkind1, wf32(:,12), n2(52))
  call vert_VQ_A(ntry, wf16(:,9), ex8(:), wf32(:,13), n3(:,89), t3x32(:,:,7))
  call prop_Q_A(ntry, wf32(:,13), 229, ZERO, 0_intkind1, wf32(:,14), n2(53))
  call vert_VQ_A(ntry, wf16(:,8), ex7(:), wf32(:,15), n3(:,90), t3x32(:,:,8))
  call prop_Q_A(ntry, wf32(:,15), 229, ZERO, 0_intkind1, wf32(:,16), n2(54))
  call vert_AV_Q(ntry, ex6(:), wf16(:,14), wf32(:,17), n3(:,91), t3x32(:,:,9))
  call prop_A_Q(ntry, wf32(:,17), 117, ZERO, 0_intkind1, wf32(:,18), n2(55))
  call vert_AV_Q(ntry, ex5(:), wf16(:,13), wf32(:,19), n3(:,92), t3x32(:,:,10))
  call prop_A_Q(ntry, wf32(:,19), 117, ZERO, 0_intkind1, wf32(:,20), n2(56))
  call vert_VQ_A(ntry, wf16(:,14), ex8(:), wf32(:,21), n3(:,93), t3x32(:,:,11))
  call prop_Q_A(ntry, wf32(:,21), 213, ZERO, 0_intkind1, wf32(:,22), n2(57))
  call vert_VQ_A(ntry, wf16(:,13), ex8(:), wf32(:,23), n3(:,94), t3x32(:,:,12))
  call prop_Q_A(ntry, wf32(:,23), 229, ZERO, 0_intkind1, wf32(:,24), n2(58))
  call vert_AV_Q(ntry, ex6(:), wf16(:,16), wf32(:,25), n3(:,95), t3x32(:,:,13))
  call prop_A_Q(ntry, wf32(:,25), 181, ZERO, 0_intkind1, wf32(:,26), n2(59))
  call vert_AV_Q(ntry, ex5(:), wf16(:,15), wf32(:,27), n3(:,96), t3x32(:,:,14))
  call prop_A_Q(ntry, wf32(:,27), 181, ZERO, 0_intkind1, wf32(:,28), n2(60))
  call vert_VQ_A(ntry, wf16(:,16), ex7(:), wf32(:,29), n3(:,97), t3x32(:,:,15))
  call prop_Q_A(ntry, wf32(:,29), 213, ZERO, 0_intkind1, wf32(:,30), n2(61))
  call vert_VQ_A(ntry, wf16(:,15), ex7(:), wf32(:,31), n3(:,98), t3x32(:,:,16))
  call prop_Q_A(ntry, wf32(:,31), 229, ZERO, 0_intkind1, wf32(:,32), n2(62))
  call vert_AV_Q(ntry, ex6(:), wf16(:,7), wf32(:,33), n3(:,99), t3x32(:,:,17))
  call prop_A_Q(ntry, wf32(:,33), 122, ZERO, 0_intkind1, wf32(:,34), n2(63))
  call vert_VQ_A(ntry, wf16(:,7), ex8(:), wf32(:,35), n3(:,100), t3x32(:,:,18))
  call prop_Q_A(ntry, wf32(:,35), 218, ZERO, 0_intkind1, wf32(:,36), n2(64))
  call vert_AV_Q(ntry, ex6(:), wf16(:,10), wf32(:,37), n3(:,101), t3x32(:,:,19))
  call prop_A_Q(ntry, wf32(:,37), 186, ZERO, 0_intkind1, wf32(:,38), n2(65))
  call vert_VQ_A(ntry, wf16(:,10), ex7(:), wf32(:,39), n3(:,102), t3x32(:,:,20))
  call prop_Q_A(ntry, wf32(:,39), 218, ZERO, 0_intkind1, wf32(:,40), n2(66))
  call vert_AV_Q(ntry, ex5(:), wf16(:,3), wf32(:,41), n3(:,103), t3x32(:,:,21))
  call prop_A_Q(ntry, wf32(:,41), 122, ZERO, 0_intkind1, wf32(:,42), n2(67))
  call vert_AV_Q(ntry, ex5(:), wf16(:,2), wf32(:,43), n3(:,104), t3x32(:,:,22))
  call prop_A_Q(ntry, wf32(:,43), 186, ZERO, 0_intkind1, wf32(:,44), n2(68))
  call vert_VQ_A(ntry, wf16(:,3), ex8(:), wf32(:,45), n3(:,105), t3x32(:,:,23))
  call prop_Q_A(ntry, wf32(:,45), 234, ZERO, 0_intkind1, wf32(:,46), n2(69))
  call vert_VQ_A(ntry, wf16(:,2), ex7(:), wf32(:,47), n3(:,106), t3x32(:,:,24))
  call prop_Q_A(ntry, wf32(:,47), 234, ZERO, 0_intkind1, wf32(:,48), n2(70))
  call vert_AV_Q(ntry, ex6(:), wf16(:,11), wf32(:,49), n3(:,107), t3x32(:,:,25))
  call prop_A_Q(ntry, wf32(:,49), 122, ZERO, 0_intkind1, wf32(:,50), n2(71))
  call vert_AV_Q(ntry, ex5(:), wf16(:,5), wf32(:,51), n3(:,108), t3x32(:,:,26))
  call prop_A_Q(ntry, wf32(:,51), 122, ZERO, 0_intkind1, wf32(:,52), n2(72))
  call vert_VQ_A(ntry, wf16(:,11), ex8(:), wf32(:,53), n3(:,109), t3x32(:,:,27))
  call prop_Q_A(ntry, wf32(:,53), 218, ZERO, 0_intkind1, wf32(:,54), n2(73))
  call vert_VQ_A(ntry, wf16(:,5), ex8(:), wf32(:,55), n3(:,110), t3x32(:,:,28))
  call prop_Q_A(ntry, wf32(:,55), 234, ZERO, 0_intkind1, wf32(:,56), n2(74))
  call vert_AV_Q(ntry, ex6(:), wf16(:,12), wf32(:,57), n3(:,111), t3x32(:,:,29))
  call prop_A_Q(ntry, wf32(:,57), 186, ZERO, 0_intkind1, wf32(:,58), n2(75))
  call vert_AV_Q(ntry, ex5(:), wf16(:,6), wf32(:,59), n3(:,112), t3x32(:,:,30))
  call prop_A_Q(ntry, wf32(:,59), 186, ZERO, 0_intkind1, wf32(:,60), n2(76))
  call vert_VQ_A(ntry, wf16(:,12), ex7(:), wf32(:,61), n3(:,113), t3x32(:,:,31))
  call prop_Q_A(ntry, wf32(:,61), 218, ZERO, 0_intkind1, wf32(:,62), n2(77))
  call vert_VQ_A(ntry, wf16(:,6), ex7(:), wf32(:,63), n3(:,114), t3x32(:,:,32))
  call prop_Q_A(ntry, wf32(:,63), 234, ZERO, 0_intkind1, wf32(:,64), n2(78))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_exwf(ex5)
  call init_hybrid_exwf(ex6)
  call init_hybrid_exwf(ex7)
  call init_hybrid_exwf(ex8)
  call init_hybrid_wf(wf4)
  call init_hybrid_wf(wf8)
  call init_hybrid_wf(wf16)
  call init_hybrid_wf(wf32)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k))
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0
  
    do k = 1, nhel
      call colint(M1helarray(:,k)%j, M2add)
      call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct)
      if (IR_is_on > 0) then
	call colint_IR(M1helarray(:,k)%j, M2add_colint)
      end if
      !summation over helicity configurations
      M02 = M02 + M2add
      M2ct = M2ct + M2add_ct
      M2colint = M2colint + M2add_colint
    end do



  contains

subroutine physical_helicities()
  implicit none 

integer :: i1,i2,i3,i4,i5,i6,i7,i8
integer :: n

n=0

do i8= 1, 2
do i7= 1, 2
do i6= 1, 2
do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2) .OR. (ex7(i7)%hf==-1_intkind2)  &
    .OR. (ex8(i8)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf + ex7(i7)%hf + ex8(i8)%hf
 end if
end do
end do
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_VV(nsync, wf16(:,1), wf16(:,2), A(:,1), n3(:,115), t3x256(:,:,1), nhel, den(9))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,4), A(:,2), n3(:,116), t3x256(:,:,2), nhel, den(12))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,5), A(:,3), n3(:,117), t3x256(:,:,3), nhel, den(16))
    call Hcont_VV(nsync, wf16(:,1), wf16(:,6), A(:,4), n3(:,118), t3x256(:,:,4), nhel, den(21))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,8), A(:,5), n3(:,119), t3x256(:,:,5), nhel, den(28))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,10), A(:,6), n3(:,120), t3x256(:,:,6), nhel, den(31))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,11), A(:,7), n3(:,121), t3x256(:,:,7), nhel, den(33))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,12), A(:,8), n3(:,122), t3x256(:,:,8), nhel, den(36))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,13), A(:,9), n3(:,123), t3x256(:,:,9), nhel, den(40))
    call Hcont_VV(nsync, wf16(:,2), wf16(:,14), A(:,10), n3(:,124), t3x256(:,:,10), nhel, den(42))
    call Hcont_VV(nsync, wf16(:,6), wf16(:,14), A(:,11), n3(:,125), t3x256(:,:,11), nhel, den(43))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,13), A(:,12), n3(:,126), t3x256(:,:,12), nhel, den(44))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,15), A(:,13), n3(:,127), t3x256(:,:,13), nhel, den(49))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,16), A(:,14), n3(:,128), t3x256(:,:,14), nhel, den(52))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,15), A(:,15), n3(:,129), t3x256(:,:,15), nhel, den(53))
    call Hcont_VV(nsync, wf16(:,5), wf16(:,16), A(:,16), n3(:,130), t3x256(:,:,16), nhel, den(54))

    call Hcont_VV(nsync, wf16(:,1), wf16(:,17), A(:,17), n3(:,131), t3x256(:,:,17), nhel, den(9))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,18), A(:,18), n3(:,132), t3x256(:,:,18), nhel, den(12))
    call Hcont_VV(nsync, wf16(:,5), wf16(:,18), A(:,19), n3(:,133), t3x256(:,:,19), nhel, den(16))
    call Hcont_VV(nsync, wf16(:,1), wf16(:,19), A(:,20), n3(:,134), t3x256(:,:,20), nhel, den(21))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,20), A(:,21), n3(:,135), t3x256(:,:,21), nhel, den(28))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,21), A(:,22), n3(:,136), t3x256(:,:,22), nhel, den(31))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,20), A(:,23), n3(:,137), t3x256(:,:,23), nhel, den(33))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,22), A(:,24), n3(:,138), t3x256(:,:,24), nhel, den(36))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,21), A(:,25), n3(:,139), t3x256(:,:,25), nhel, den(40))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,17), A(:,26), n3(:,140), t3x256(:,:,26), nhel, den(42))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,19), A(:,27), n3(:,141), t3x256(:,:,27), nhel, den(43))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,22), A(:,28), n3(:,142), t3x256(:,:,28), nhel, den(44))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,23), A(:,29), n3(:,143), t3x256(:,:,29), nhel, den(49))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,24), A(:,30), n3(:,144), t3x256(:,:,30), nhel, den(52))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,23), A(:,31), n3(:,145), t3x256(:,:,31), nhel, den(53))
    call Hcont_VV(nsync, wf16(:,5), wf16(:,24), A(:,32), n3(:,146), t3x256(:,:,32), nhel, den(54))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,25), A(:,33), n3(:,147), t3x256(:,:,33), nhel, den(56))
    call Hcont_VV(nsync, wf16(:,2), wf16(:,26), A(:,34), n3(:,148), t3x256(:,:,34), nhel, den(58))
    call Hcont_VV(nsync, wf16(:,6), wf16(:,26), A(:,35), n3(:,149), t3x256(:,:,35), nhel, den(21))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,27), A(:,36), n3(:,150), t3x256(:,:,36), nhel, den(16))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,28), A(:,37), n3(:,151), t3x256(:,:,37), nhel, den(60))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,29), A(:,38), n3(:,152), t3x256(:,:,38), nhel, den(62))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,28), A(:,39), n3(:,153), t3x256(:,:,39), nhel, den(36))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,30), A(:,40), n3(:,154), t3x256(:,:,40), nhel, den(33))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,29), A(:,41), n3(:,155), t3x256(:,:,41), nhel, den(49))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,25), A(:,42), n3(:,156), t3x256(:,:,42), nhel, den(52))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,27), A(:,43), n3(:,157), t3x256(:,:,43), nhel, den(54))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,30), A(:,44), n3(:,158), t3x256(:,:,44), nhel, den(53))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,31), A(:,45), n3(:,159), t3x256(:,:,45), nhel, den(40))
    call Hcont_VV(nsync, wf16(:,2), wf16(:,32), A(:,46), n3(:,160), t3x256(:,:,46), nhel, den(42))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,31), A(:,47), n3(:,161), t3x256(:,:,47), nhel, den(44))
    call Hcont_VV(nsync, wf16(:,6), wf16(:,32), A(:,48), n3(:,162), t3x256(:,:,48), nhel, den(43))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,33), A(:,49), n3(:,163), t3x256(:,:,49), nhel, den(63))
    call Hcont_VV(nsync, wf16(:,1), wf16(:,34), A(:,50), n3(:,164), t3x256(:,:,50), nhel, den(64))
    call Hcont_VV(nsync, wf16(:,1), wf16(:,35), A(:,51), n3(:,165), t3x256(:,:,51), nhel, den(9))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,36), A(:,52), n3(:,166), t3x256(:,:,52), nhel, den(12))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,37), A(:,53), n3(:,167), t3x256(:,:,53), nhel, den(65))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,34), A(:,54), n3(:,168), t3x256(:,:,54), nhel, den(43))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,37), A(:,55), n3(:,169), t3x256(:,:,55), nhel, den(44))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,35), A(:,56), n3(:,170), t3x256(:,:,56), nhel, den(42))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,38), A(:,57), n3(:,171), t3x256(:,:,57), nhel, den(66))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,38), A(:,58), n3(:,172), t3x256(:,:,58), nhel, den(53))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,33), A(:,59), n3(:,173), t3x256(:,:,59), nhel, den(54))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,36), A(:,60), n3(:,174), t3x256(:,:,60), nhel, den(52))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,39), A(:,61), n3(:,175), t3x256(:,:,61), nhel, den(28))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,40), A(:,62), n3(:,176), t3x256(:,:,62), nhel, den(31))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,39), A(:,63), n3(:,177), t3x256(:,:,63), nhel, den(33))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,40), A(:,64), n3(:,178), t3x256(:,:,64), nhel, den(36))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,41), A(:,65), n3(:,179), t3x256(:,:,65), nhel, den(67))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,42), A(:,66), n3(:,180), t3x256(:,:,66), nhel, den(68))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,43), A(:,67), n3(:,181), t3x256(:,:,67), nhel, den(28))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,44), A(:,68), n3(:,182), t3x256(:,:,68), nhel, den(31))
    call Hcont_VV(nsync, wf16(:,2), wf16(:,45), A(:,69), n3(:,183), t3x256(:,:,69), nhel, den(69))
    call Hcont_VV(nsync, wf16(:,6), wf16(:,45), A(:,70), n3(:,184), t3x256(:,:,70), nhel, den(70))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,42), A(:,71), n3(:,185), t3x256(:,:,71), nhel, den(71))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,44), A(:,72), n3(:,186), t3x256(:,:,72), nhel, den(40))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,46), A(:,73), n3(:,187), t3x256(:,:,73), nhel, den(72))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,41), A(:,74), n3(:,188), t3x256(:,:,74), nhel, den(73))
    call Hcont_VV(nsync, wf16(:,5), wf16(:,46), A(:,75), n3(:,189), t3x256(:,:,75), nhel, den(74))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,43), A(:,76), n3(:,190), t3x256(:,:,76), nhel, den(49))
    call Hcont_VV(nsync, wf16(:,2), wf16(:,47), A(:,77), n3(:,191), t3x256(:,:,77), nhel, den(9))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,48), A(:,78), n3(:,192), t3x256(:,:,78), nhel, den(12))
    call Hcont_VV(nsync, wf16(:,5), wf16(:,48), A(:,79), n3(:,193), t3x256(:,:,79), nhel, den(16))
    call Hcont_VV(nsync, wf16(:,6), wf16(:,47), A(:,80), n3(:,194), t3x256(:,:,80), nhel, den(21))
    call Hcont_VV(nsync, wf16(:,6), wf16(:,49), A(:,81), n3(:,195), t3x256(:,:,81), nhel, den(75))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,50), A(:,82), n3(:,196), t3x256(:,:,82), nhel, den(76))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,51), A(:,83), n3(:,197), t3x256(:,:,83), nhel, den(77))
    call Hcont_VV(nsync, wf16(:,5), wf16(:,52), A(:,84), n3(:,198), t3x256(:,:,84), nhel, den(78))
    call Hcont_VV(nsync, wf16(:,2), wf16(:,53), A(:,85), n3(:,199), t3x256(:,:,85), nhel, den(80))
    call Hcont_VV(nsync, wf16(:,6), wf16(:,53), A(:,86), n3(:,200), t3x256(:,:,86), nhel, den(81))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,54), A(:,87), n3(:,201), t3x256(:,:,87), nhel, den(83))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,55), A(:,88), n3(:,202), t3x256(:,:,88), nhel, den(85))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,50), A(:,89), n3(:,203), t3x256(:,:,89), nhel, den(86))
    call Hcont_VV(nsync, wf16(:,2), wf16(:,56), A(:,90), n3(:,204), t3x256(:,:,90), nhel, den(88))
    call Hcont_VV(nsync, wf16(:,6), wf16(:,56), A(:,91), n3(:,205), t3x256(:,:,91), nhel, den(89))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,54), A(:,92), n3(:,206), t3x256(:,:,92), nhel, den(90))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,52), A(:,93), n3(:,207), t3x256(:,:,93), nhel, den(91))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,55), A(:,94), n3(:,208), t3x256(:,:,94), nhel, den(92))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,57), A(:,95), n3(:,209), t3x256(:,:,95), nhel, den(93))
    call Hcont_VV(nsync, wf16(:,5), wf16(:,57), A(:,96), n3(:,210), t3x256(:,:,96), nhel, den(94))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,58), A(:,97), n3(:,211), t3x256(:,:,97), nhel, den(95))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,51), A(:,98), n3(:,212), t3x256(:,:,98), nhel, den(96))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,59), A(:,99), n3(:,213), t3x256(:,:,99), nhel, den(98))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,58), A(:,100), n3(:,214), t3x256(:,:,100), nhel, den(99))
    call Hcont_VV(nsync, wf16(:,2), wf16(:,49), A(:,101), n3(:,215), t3x256(:,:,101), nhel, den(100))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,59), A(:,102), n3(:,216), t3x256(:,:,102), nhel, den(101))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,60), A(:,103), n3(:,217), t3x256(:,:,103), nhel, den(103))
    call Hcont_VV(nsync, wf16(:,5), wf16(:,60), A(:,104), n3(:,218), t3x256(:,:,104), nhel, den(104))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,61), A(:,105), n3(:,219), t3x256(:,:,105), nhel, den(106))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,62), A(:,106), n3(:,220), t3x256(:,:,106), nhel, den(107))
    call Hcont_VV(nsync, wf16(:,1), wf16(:,63), A(:,107), n3(:,221), t3x256(:,:,107), nhel, den(108))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,64), A(:,108), n3(:,222), t3x256(:,:,108), nhel, den(110))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,64), A(:,109), n3(:,223), t3x256(:,:,109), nhel, den(111))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,65), A(:,110), n3(:,224), t3x256(:,:,110), nhel, den(112))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,65), A(:,111), n3(:,225), t3x256(:,:,111), nhel, den(113))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,66), A(:,112), n3(:,226), t3x256(:,:,112), nhel, den(114))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,61), A(:,113), n3(:,227), t3x256(:,:,113), nhel, den(115))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,62), A(:,114), n3(:,228), t3x256(:,:,114), nhel, den(116))
    call Hcont_VV(nsync, wf16(:,1), wf16(:,67), A(:,115), n3(:,229), t3x256(:,:,115), nhel, den(117))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,68), A(:,116), n3(:,230), t3x256(:,:,116), nhel, den(118))
    call Hcont_VV(nsync, wf16(:,1), wf16(:,69), A(:,117), n3(:,231), t3x256(:,:,117), nhel, den(119))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,70), A(:,118), n3(:,232), t3x256(:,:,118), nhel, den(120))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,70), A(:,119), n3(:,233), t3x256(:,:,119), nhel, den(121))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,71), A(:,120), n3(:,234), t3x256(:,:,120), nhel, den(122))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,67), A(:,121), n3(:,235), t3x256(:,:,121), nhel, den(123))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,69), A(:,122), n3(:,236), t3x256(:,:,122), nhel, den(124))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,72), A(:,123), n3(:,237), t3x256(:,:,123), nhel, den(125))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,72), A(:,124), n3(:,238), t3x256(:,:,124), nhel, den(126))
    call Hcont_VV(nsync, wf16(:,2), wf16(:,73), A(:,125), n3(:,239), t3x256(:,:,125), nhel, den(127))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,74), A(:,126), n3(:,240), t3x256(:,:,126), nhel, den(128))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,75), A(:,127), n3(:,241), t3x256(:,:,127), nhel, den(129))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,76), A(:,128), n3(:,242), t3x256(:,:,128), nhel, den(130))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(2), M2(2) ! M1helarray(2,256)
  integer :: empty(0), i

  M1(1)%j = ((A(j,1)%j+A(j,4)%j+A(j,5)%j+A(j,7)%j+A(j,10)%j+A(j,11)%j+A(j,13)%j+A(j,15)%j)*f(1))/2._/**/REALKIND+((A(j,2)%j &
       +A(j,3)%j+A(j,6)%j+A(j,8)%j+A(j,9)%j+A(j,12)%j+A(j,14)%j+A(j,16)%j)*f(1))/6._/**/REALKIND
  M1(2)%j = ((-A(j,1)%j-A(j,4)%j-A(j,5)%j-A(j,7)%j-A(j,10)%j-A(j,11)%j-A(j,13)%j-A(j,15)%j)*f(1))/6._/**/REALKIND+((-A(j,2)%j &
       -A(j,3)%j-A(j,6)%j-A(j,8)%j-A(j,9)%j-A(j,12)%j-A(j,14)%j-A(j,16)%j)*f(1))/2._/**/REALKIND

  M2(1)%j = ((-A(j,81)%j-A(j,83)%j-A(j,85)%j-A(j,86)%j-A(j,87)%j-A(j,88)%j-A(j,90)%j-A(j,91)%j-A(j,92)%j-A(j,94)%j-A(j,98)%j &
       -A(j,101)%j-A(j,107)%j-A(j,112)%j-A(j,115)%j-A(j,117)%j-A(j,118)%j-A(j,119)%j-A(j,121)%j-A(j,122)%j-A(j,123)%j-A(j,124)%j &
       -A(j,125)%j-A(j,127)%j)*f(2))/2._/**/REALKIND+((-A(j,82)%j-A(j,84)%j-A(j,89)%j-A(j,93)%j-A(j,95)%j-A(j,96)%j-A(j,97)%j &
       -A(j,99)%j-A(j,100)%j-A(j,102)%j-A(j,103)%j-A(j,104)%j-A(j,105)%j-A(j,106)%j-A(j,108)%j-A(j,109)%j-A(j,110)%j-A(j,111)%j &
       -A(j,113)%j-A(j,114)%j-A(j,116)%j-A(j,120)%j-A(j,126)%j-A(j,128)%j)*f(2))/6._/**/REALKIND+((A(j,17)%j+A(j,21)%j+A(j,23)%j &
       +A(j,26)%j+A(j,34)%j+A(j,35)%j+A(j,38)%j+A(j,41)%j+A(j,50)%j+A(j,54)%j+A(j,57)%j+A(j,58)%j+A(j,65)%j+A(j,69)%j+A(j,70)%j &
       +A(j,74)%j)*f(3))/2._/**/REALKIND+((A(j,18)%j+A(j,19)%j+A(j,22)%j+A(j,25)%j+A(j,33)%j+A(j,37)%j+A(j,39)%j+A(j,42)%j &
       +A(j,49)%j+A(j,53)%j+A(j,55)%j+A(j,59)%j+A(j,66)%j+A(j,71)%j+A(j,73)%j+A(j,75)%j)*f(3))/6._/**/REALKIND+((A(j,24)%j &
       +A(j,28)%j+A(j,30)%j+A(j,32)%j+A(j,36)%j+A(j,43)%j+A(j,45)%j+A(j,47)%j+A(j,52)%j+A(j,60)%j+A(j,62)%j+A(j,64)%j+A(j,68)%j &
       +A(j,72)%j+A(j,78)%j+A(j,79)%j)*f(4))/6._/**/REALKIND+((A(j,20)%j+A(j,27)%j+A(j,29)%j+A(j,31)%j+A(j,40)%j+A(j,44)%j &
       +A(j,46)%j+A(j,48)%j+A(j,51)%j+A(j,56)%j+A(j,61)%j+A(j,63)%j+A(j,67)%j+A(j,76)%j+A(j,77)%j &
       +A(j,80)%j)*f(4))/2._/**/REALKIND
  M2(2)%j = ((A(j,81)%j+A(j,83)%j+A(j,85)%j+A(j,86)%j+A(j,87)%j+A(j,88)%j+A(j,90)%j+A(j,91)%j+A(j,92)%j+A(j,94)%j+A(j,98)%j &
       +A(j,101)%j+A(j,107)%j+A(j,112)%j+A(j,115)%j+A(j,117)%j+A(j,118)%j+A(j,119)%j+A(j,121)%j+A(j,122)%j+A(j,123)%j+A(j,124)%j &
       +A(j,125)%j+A(j,127)%j)*f(2))/6._/**/REALKIND+((A(j,82)%j+A(j,84)%j+A(j,89)%j+A(j,93)%j+A(j,95)%j+A(j,96)%j+A(j,97)%j &
       +A(j,99)%j+A(j,100)%j+A(j,102)%j+A(j,103)%j+A(j,104)%j+A(j,105)%j+A(j,106)%j+A(j,108)%j+A(j,109)%j+A(j,110)%j+A(j,111)%j &
       +A(j,113)%j+A(j,114)%j+A(j,116)%j+A(j,120)%j+A(j,126)%j+A(j,128)%j)*f(2))/2._/**/REALKIND+((-A(j,17)%j-A(j,21)%j-A(j,23)%j &
       -A(j,26)%j-A(j,34)%j-A(j,35)%j-A(j,38)%j-A(j,41)%j-A(j,50)%j-A(j,54)%j-A(j,57)%j-A(j,58)%j-A(j,65)%j-A(j,69)%j-A(j,70)%j &
       -A(j,74)%j)*f(3))/6._/**/REALKIND+((-A(j,18)%j-A(j,19)%j-A(j,22)%j-A(j,25)%j-A(j,33)%j-A(j,37)%j-A(j,39)%j-A(j,42)%j &
       -A(j,49)%j-A(j,53)%j-A(j,55)%j-A(j,59)%j-A(j,66)%j-A(j,71)%j-A(j,73)%j-A(j,75)%j)*f(3))/2._/**/REALKIND+((-A(j,24)%j &
       -A(j,28)%j-A(j,30)%j-A(j,32)%j-A(j,36)%j-A(j,43)%j-A(j,45)%j-A(j,47)%j-A(j,52)%j-A(j,60)%j-A(j,62)%j-A(j,64)%j-A(j,68)%j &
       -A(j,72)%j-A(j,78)%j-A(j,79)%j)*f(4))/2._/**/REALKIND+((-A(j,20)%j-A(j,27)%j-A(j,29)%j-A(j,31)%j-A(j,40)%j-A(j,44)%j &
       -A(j,46)%j-A(j,48)%j-A(j,51)%j-A(j,56)%j-A(j,61)%j-A(j,63)%j-A(j,67)%j-A(j,76)%j-A(j,77)%j &
       -A(j,80)%j)*f(4))/6._/**/REALKIND


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)  

  !M(i) corresponds to \Gamma_{i} in Fabio's thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppllnnjj_vbs_nenmexmxuxuxdd_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(2)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 2
      do j = 1, 2
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppllnnjj_vbs_nenmexmxuxuxdd_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M(2), Mct(2)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer ::  i, j

  M2colint_ct = 0

    do i = 1, 2
      do j = 1, 2
        M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i,j)*Mct(j))
      end do
    end do


end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppllnnjj_vbs_nenmexmxuxuxdd_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(2)
  real(REALKIND),    intent(out) :: M2IRadd(37)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 38-1
    colmatpos = 2*k
    do i = 1, 2
      do j = 1, 2
	M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do
  
end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppllnnjj_vbs_nenmexmxuxuxdd_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(2)
  complex(REALKIND), intent(in)  :: M2(2)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 2
    do j = 1, 2
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabio's thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppllnnjj_vbs_nenmexmxuxuxdd_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(2)
  type(Hpolcont), intent(out)  :: M0_col(2)
  integer :: i, j


  do j = 1, 2 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 2 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i,j)
    end do    
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppllnnjj_vbs_nenmexmxuxuxdd_1_/**/REALKIND
