
module ol_external_ppllnnjj_vbs_nexnmxemucdxsxg_1
  implicit none
  integer :: dummy_counter
  ! Permutation and inverse permutation of external particles
  integer, save :: external_perm_ppllnnjj_vbs_nexnmxemucdxsxg_1(9) = &
                     [ (dummy_counter, dummy_counter = 1, 9) ]
  integer, save :: external_perm_inv_ppllnnjj_vbs_nexnmxemucdxsxg_1(9) = &
                     [ (dummy_counter, dummy_counter = 1, 9) ]
  integer, save :: extcomb_perm_ppllnnjj_vbs_nexnmxemucdxsxg_1(0:46) = &
                     [ (dummy_counter, dummy_counter = 0, 46) ]
  ! Particle types (mapping of fields to integers is not fixed!)
  integer, save :: particle_types_ppllnnjj_vbs_nexnmxemucdxsxg_1(9) = &
                     [ 1, 2, 3, 4, 5, 6, 7, 8, 9 ]
  ! Colour and helicity average factors per particle
  integer, save :: average_factors_ppllnnjj_vbs_nexnmxemucdxsxg_1(9) = &
                     [ 2, 2, 2, 2, 6, 6, 6, 6, 16 ]
  ! Average factor; initialised to the identity permutation
  integer, save :: average_factor_ppllnnjj_vbs_nexnmxemucdxsxg_1 = &
                     4
  integer, save :: channel_number_ppllnnjj_vbs_nexnmxemucdxsxg_1 = -1
  ! external particle helicities
  logical, save :: hel_not_initialised = .true.
  integer, save :: H(9,512) ! H(i,la) = helicity of particle i in configuration la
  integer, save :: H_HC(512,9)
  integer, save :: POLSEL(9) = 0

  contains

  subroutine n_external(n) &
      & bind(c,name="ol_f_n_external_ppllnnjj_vbs_nexnmxemucdxsxg_1")
    ! Return the number of external particles
    implicit none
    integer, intent(out) :: n
    n = 9
  end subroutine n_external


  subroutine n_external_c(n) &
      & bind(c,name="ol_n_external_ppllnnjj_vbs_nexnmxemucdxsxg_1")
    use, intrinsic :: iso_c_binding, only: c_int
    implicit none
    integer(c_int) :: n
    n = 9
  end subroutine n_external_c


  subroutine set_permutation(perm) &
      & bind(c,name="ol_f_set_permutation_ppllnnjj_vbs_nexnmxemucdxsxg_1")
    use ol_parameters_decl_/**/DREALKIND, only: out_symmetry_on
    use ol_external_decl_/**/DREALKIND, only: n_scatt
    use ol_generic, only: factorial
    implicit none
    integer, intent(in) :: perm(9)
    integer :: i, j, ii, jj
    integer :: particle_types_perm_ppllnnjj_vbs_nexnmxemucdxsxg_1(9)
    external_perm_ppllnnjj_vbs_nexnmxemucdxsxg_1 = perm
    do i = 1, 9
      external_perm_inv_ppllnnjj_vbs_nexnmxemucdxsxg_1( &
        external_perm_ppllnnjj_vbs_nexnmxemucdxsxg_1(i)) = i
      particle_types_perm_ppllnnjj_vbs_nexnmxemucdxsxg_1(i) = &
        particle_types_ppllnnjj_vbs_nexnmxemucdxsxg_1( &
        external_perm_ppllnnjj_vbs_nexnmxemucdxsxg_1(i))
    end do
    do i = 1, 9
      do j = 1, i
        if (external_perm_ppllnnjj_vbs_nexnmxemucdxsxg_1(i) >= &
          external_perm_ppllnnjj_vbs_nexnmxemucdxsxg_1(j)) then
          ii = external_perm_ppllnnjj_vbs_nexnmxemucdxsxg_1(i)
          jj = external_perm_ppllnnjj_vbs_nexnmxemucdxsxg_1(j)
        else
          ii = external_perm_ppllnnjj_vbs_nexnmxemucdxsxg_1(j)
          jj = external_perm_ppllnnjj_vbs_nexnmxemucdxsxg_1(i)
        end if
        extcomb_perm_ppllnnjj_vbs_nexnmxemucdxsxg_1((i*(i-1))/2 + j) = (ii*(ii-1))/2 + jj
      end do
    end do
    ! Colour and helicity average factor
    average_factor_ppllnnjj_vbs_nexnmxemucdxsxg_1 = 1
    do i = 1, n_scatt
      average_factor_ppllnnjj_vbs_nexnmxemucdxsxg_1 = &
        average_factor_ppllnnjj_vbs_nexnmxemucdxsxg_1 &
        * average_factors_ppllnnjj_vbs_nexnmxemucdxsxg_1( &
        external_perm_ppllnnjj_vbs_nexnmxemucdxsxg_1(i))
    end do
    ! Symmetry factor for outgoing particles
    if (out_symmetry_on /= 0) then
      do i = 1, 9
        average_factor_ppllnnjj_vbs_nexnmxemucdxsxg_1 = &
          average_factor_ppllnnjj_vbs_nexnmxemucdxsxg_1 &
          * factorial(count(particle_types_perm_ppllnnjj_vbs_nexnmxemucdxsxg_1(n_scatt+1:9) == i))
      end do
    end if
  end subroutine set_permutation


  subroutine set_permutation_c(perm) &
      & bind(c,name="ol_set_permutation_ppllnnjj_vbs_nexnmxemucdxsxg_1")
    use, intrinsic :: iso_c_binding, only: c_int
    implicit none
    integer(c_int), intent(in) :: perm(9)
    integer :: f_perm(9)
    f_perm = perm
    call set_permutation(f_perm)
  end subroutine set_permutation_c


  subroutine get_masses(m_ex) &
      & bind(c,name="ol_f_get_masses_ppllnnjj_vbs_nexnmxemucdxsxg_1")
    ! Return the masses of the external particles in the current permutation.
    use KIND_TYPES, only: DREALKIND
    use ol_parameters_decl_/**/DREALKIND
    implicit none
    real(DREALKIND), intent(out) :: m_ex(9)
    integer        :: i
    real(DREALKIND) :: m_ex_orig(9)
    ! External particle masses for in the identity permutation
    m_ex_orig = [ rZERO, rZERO, rZERO, rZERO, rZERO, rZERO, rZERO, rZERO, rZERO ]
    do i = 1, 9
      m_ex(i) = m_ex_orig(external_perm_ppllnnjj_vbs_nexnmxemucdxsxg_1(i))
    end do
  end subroutine get_masses


  subroutine get_masses_c(m_ex) &
      & bind(c,name="ol_get_masses_ppllnnjj_vbs_nexnmxemucdxsxg_1")
    use KIND_TYPES, only: DREALKIND
    use, intrinsic :: iso_c_binding, only: c_double
    implicit none
    real(c_double), intent(out) :: m_ex(9)
    real(DREALKIND) :: f_m_ex(9)
    call get_masses(f_m_ex)
    m_ex = f_m_ex
  end subroutine get_masses_c


  subroutine rambo(sqrt_s, p_rambo) &
      & bind(c,name="ol_f_rambo_ppllnnjj_vbs_nexnmxemucdxsxg_1")
    use KIND_TYPES, only: DREALKIND
    use ol_kinematics_/**/DREALKIND, only: rambo_generic => rambo
    implicit none
    real(DREALKIND), intent(in) :: sqrt_s
    real(DREALKIND), intent(out) :: p_rambo(0:3,9)
    real(DREALKIND) :: m_ex(9)
    call get_masses(m_ex)
    call rambo_generic(sqrt_s, m_ex, p_rambo)
  end subroutine rambo


  subroutine rambo_c(sqrt_s, p_rambo) &
      & bind(c,name="ol_rambo_ppllnnjj_vbs_nexnmxemucdxsxg_1")
    use KIND_TYPES, only: DREALKIND
    use, intrinsic :: iso_c_binding, only: c_double
    implicit none
    real(c_double), intent(in) :: sqrt_s
    real(c_double), intent(out) :: p_rambo(0:3,9)
    real(DREALKIND) :: f_sqrt_s
    real(DREALKIND) :: f_p_rambo(0:3,9)
    f_sqrt_s = sqrt_s
    call rambo(f_sqrt_s, f_p_rambo)
    p_rambo = f_p_rambo
  end subroutine rambo_c


  subroutine hel_init
    implicit none
    integer :: binpos, flip, binco
    hel_not_initialised = .false.
    ! helicity configurations for this process
  H(:,  1) = [ -1, -1, -1, -1, -1, -1, -1, -1, -1 ]
  H(:,  2) = [ -1, -1, -1, -1, -1, -1, -1, -1,  1 ]
  H(:,  3) = [ -1, -1, -1, -1, -1, -1, -1,  1, -1 ]
  H(:,  4) = [ -1, -1, -1, -1, -1, -1, -1,  1,  1 ]
  H(:,  5) = [ -1, -1, -1, -1, -1, -1,  1, -1, -1 ]
  H(:,  6) = [ -1, -1, -1, -1, -1, -1,  1, -1,  1 ]
  H(:,  7) = [ -1, -1, -1, -1, -1, -1,  1,  1, -1 ]
  H(:,  8) = [ -1, -1, -1, -1, -1, -1,  1,  1,  1 ]
  H(:,  9) = [ -1, -1, -1, -1, -1,  1, -1, -1, -1 ]
  H(:, 10) = [ -1, -1, -1, -1, -1,  1, -1, -1,  1 ]
  H(:, 11) = [ -1, -1, -1, -1, -1,  1, -1,  1, -1 ]
  H(:, 12) = [ -1, -1, -1, -1, -1,  1, -1,  1,  1 ]
  H(:, 13) = [ -1, -1, -1, -1, -1,  1,  1, -1, -1 ]
  H(:, 14) = [ -1, -1, -1, -1, -1,  1,  1, -1,  1 ]
  H(:, 15) = [ -1, -1, -1, -1, -1,  1,  1,  1, -1 ]
  H(:, 16) = [ -1, -1, -1, -1, -1,  1,  1,  1,  1 ]
  H(:, 17) = [ -1, -1, -1, -1,  1, -1, -1, -1, -1 ]
  H(:, 18) = [ -1, -1, -1, -1,  1, -1, -1, -1,  1 ]
  H(:, 19) = [ -1, -1, -1, -1,  1, -1, -1,  1, -1 ]
  H(:, 20) = [ -1, -1, -1, -1,  1, -1, -1,  1,  1 ]
  H(:, 21) = [ -1, -1, -1, -1,  1, -1,  1, -1, -1 ]
  H(:, 22) = [ -1, -1, -1, -1,  1, -1,  1, -1,  1 ]
  H(:, 23) = [ -1, -1, -1, -1,  1, -1,  1,  1, -1 ]
  H(:, 24) = [ -1, -1, -1, -1,  1, -1,  1,  1,  1 ]
  H(:, 25) = [ -1, -1, -1, -1,  1,  1, -1, -1, -1 ]
  H(:, 26) = [ -1, -1, -1, -1,  1,  1, -1, -1,  1 ]
  H(:, 27) = [ -1, -1, -1, -1,  1,  1, -1,  1, -1 ]
  H(:, 28) = [ -1, -1, -1, -1,  1,  1, -1,  1,  1 ]
  H(:, 29) = [ -1, -1, -1, -1,  1,  1,  1, -1, -1 ]
  H(:, 30) = [ -1, -1, -1, -1,  1,  1,  1, -1,  1 ]
  H(:, 31) = [ -1, -1, -1, -1,  1,  1,  1,  1, -1 ]
  H(:, 32) = [ -1, -1, -1, -1,  1,  1,  1,  1,  1 ]
  H(:, 33) = [ -1, -1, -1,  1, -1, -1, -1, -1, -1 ]
  H(:, 34) = [ -1, -1, -1,  1, -1, -1, -1, -1,  1 ]
  H(:, 35) = [ -1, -1, -1,  1, -1, -1, -1,  1, -1 ]
  H(:, 36) = [ -1, -1, -1,  1, -1, -1, -1,  1,  1 ]
  H(:, 37) = [ -1, -1, -1,  1, -1, -1,  1, -1, -1 ]
  H(:, 38) = [ -1, -1, -1,  1, -1, -1,  1, -1,  1 ]
  H(:, 39) = [ -1, -1, -1,  1, -1, -1,  1,  1, -1 ]
  H(:, 40) = [ -1, -1, -1,  1, -1, -1,  1,  1,  1 ]
  H(:, 41) = [ -1, -1, -1,  1, -1,  1, -1, -1, -1 ]
  H(:, 42) = [ -1, -1, -1,  1, -1,  1, -1, -1,  1 ]
  H(:, 43) = [ -1, -1, -1,  1, -1,  1, -1,  1, -1 ]
  H(:, 44) = [ -1, -1, -1,  1, -1,  1, -1,  1,  1 ]
  H(:, 45) = [ -1, -1, -1,  1, -1,  1,  1, -1, -1 ]
  H(:, 46) = [ -1, -1, -1,  1, -1,  1,  1, -1,  1 ]
  H(:, 47) = [ -1, -1, -1,  1, -1,  1,  1,  1, -1 ]
  H(:, 48) = [ -1, -1, -1,  1, -1,  1,  1,  1,  1 ]
  H(:, 49) = [ -1, -1, -1,  1,  1, -1, -1, -1, -1 ]
  H(:, 50) = [ -1, -1, -1,  1,  1, -1, -1, -1,  1 ]
  H(:, 51) = [ -1, -1, -1,  1,  1, -1, -1,  1, -1 ]
  H(:, 52) = [ -1, -1, -1,  1,  1, -1, -1,  1,  1 ]
  H(:, 53) = [ -1, -1, -1,  1,  1, -1,  1, -1, -1 ]
  H(:, 54) = [ -1, -1, -1,  1,  1, -1,  1, -1,  1 ]
  H(:, 55) = [ -1, -1, -1,  1,  1, -1,  1,  1, -1 ]
  H(:, 56) = [ -1, -1, -1,  1,  1, -1,  1,  1,  1 ]
  H(:, 57) = [ -1, -1, -1,  1,  1,  1, -1, -1, -1 ]
  H(:, 58) = [ -1, -1, -1,  1,  1,  1, -1, -1,  1 ]
  H(:, 59) = [ -1, -1, -1,  1,  1,  1, -1,  1, -1 ]
  H(:, 60) = [ -1, -1, -1,  1,  1,  1, -1,  1,  1 ]
  H(:, 61) = [ -1, -1, -1,  1,  1,  1,  1, -1, -1 ]
  H(:, 62) = [ -1, -1, -1,  1,  1,  1,  1, -1,  1 ]
  H(:, 63) = [ -1, -1, -1,  1,  1,  1,  1,  1, -1 ]
  H(:, 64) = [ -1, -1, -1,  1,  1,  1,  1,  1,  1 ]
  H(:, 65) = [ -1, -1,  1, -1, -1, -1, -1, -1, -1 ]
  H(:, 66) = [ -1, -1,  1, -1, -1, -1, -1, -1,  1 ]
  H(:, 67) = [ -1, -1,  1, -1, -1, -1, -1,  1, -1 ]
  H(:, 68) = [ -1, -1,  1, -1, -1, -1, -1,  1,  1 ]
  H(:, 69) = [ -1, -1,  1, -1, -1, -1,  1, -1, -1 ]
  H(:, 70) = [ -1, -1,  1, -1, -1, -1,  1, -1,  1 ]
  H(:, 71) = [ -1, -1,  1, -1, -1, -1,  1,  1, -1 ]
  H(:, 72) = [ -1, -1,  1, -1, -1, -1,  1,  1,  1 ]
  H(:, 73) = [ -1, -1,  1, -1, -1,  1, -1, -1, -1 ]
  H(:, 74) = [ -1, -1,  1, -1, -1,  1, -1, -1,  1 ]
  H(:, 75) = [ -1, -1,  1, -1, -1,  1, -1,  1, -1 ]
  H(:, 76) = [ -1, -1,  1, -1, -1,  1, -1,  1,  1 ]
  H(:, 77) = [ -1, -1,  1, -1, -1,  1,  1, -1, -1 ]
  H(:, 78) = [ -1, -1,  1, -1, -1,  1,  1, -1,  1 ]
  H(:, 79) = [ -1, -1,  1, -1, -1,  1,  1,  1, -1 ]
  H(:, 80) = [ -1, -1,  1, -1, -1,  1,  1,  1,  1 ]
  H(:, 81) = [ -1, -1,  1, -1,  1, -1, -1, -1, -1 ]
  H(:, 82) = [ -1, -1,  1, -1,  1, -1, -1, -1,  1 ]
  H(:, 83) = [ -1, -1,  1, -1,  1, -1, -1,  1, -1 ]
  H(:, 84) = [ -1, -1,  1, -1,  1, -1, -1,  1,  1 ]
  H(:, 85) = [ -1, -1,  1, -1,  1, -1,  1, -1, -1 ]
  H(:, 86) = [ -1, -1,  1, -1,  1, -1,  1, -1,  1 ]
  H(:, 87) = [ -1, -1,  1, -1,  1, -1,  1,  1, -1 ]
  H(:, 88) = [ -1, -1,  1, -1,  1, -1,  1,  1,  1 ]
  H(:, 89) = [ -1, -1,  1, -1,  1,  1, -1, -1, -1 ]
  H(:, 90) = [ -1, -1,  1, -1,  1,  1, -1, -1,  1 ]
  H(:, 91) = [ -1, -1,  1, -1,  1,  1, -1,  1, -1 ]
  H(:, 92) = [ -1, -1,  1, -1,  1,  1, -1,  1,  1 ]
  H(:, 93) = [ -1, -1,  1, -1,  1,  1,  1, -1, -1 ]
  H(:, 94) = [ -1, -1,  1, -1,  1,  1,  1, -1,  1 ]
  H(:, 95) = [ -1, -1,  1, -1,  1,  1,  1,  1, -1 ]
  H(:, 96) = [ -1, -1,  1, -1,  1,  1,  1,  1,  1 ]
  H(:, 97) = [ -1, -1,  1,  1, -1, -1, -1, -1, -1 ]
  H(:, 98) = [ -1, -1,  1,  1, -1, -1, -1, -1,  1 ]
  H(:, 99) = [ -1, -1,  1,  1, -1, -1, -1,  1, -1 ]
  H(:,100) = [ -1, -1,  1,  1, -1, -1, -1,  1,  1 ]
  H(:,101) = [ -1, -1,  1,  1, -1, -1,  1, -1, -1 ]
  H(:,102) = [ -1, -1,  1,  1, -1, -1,  1, -1,  1 ]
  H(:,103) = [ -1, -1,  1,  1, -1, -1,  1,  1, -1 ]
  H(:,104) = [ -1, -1,  1,  1, -1, -1,  1,  1,  1 ]
  H(:,105) = [ -1, -1,  1,  1, -1,  1, -1, -1, -1 ]
  H(:,106) = [ -1, -1,  1,  1, -1,  1, -1, -1,  1 ]
  H(:,107) = [ -1, -1,  1,  1, -1,  1, -1,  1, -1 ]
  H(:,108) = [ -1, -1,  1,  1, -1,  1, -1,  1,  1 ]
  H(:,109) = [ -1, -1,  1,  1, -1,  1,  1, -1, -1 ]
  H(:,110) = [ -1, -1,  1,  1, -1,  1,  1, -1,  1 ]
  H(:,111) = [ -1, -1,  1,  1, -1,  1,  1,  1, -1 ]
  H(:,112) = [ -1, -1,  1,  1, -1,  1,  1,  1,  1 ]
  H(:,113) = [ -1, -1,  1,  1,  1, -1, -1, -1, -1 ]
  H(:,114) = [ -1, -1,  1,  1,  1, -1, -1, -1,  1 ]
  H(:,115) = [ -1, -1,  1,  1,  1, -1, -1,  1, -1 ]
  H(:,116) = [ -1, -1,  1,  1,  1, -1, -1,  1,  1 ]
  H(:,117) = [ -1, -1,  1,  1,  1, -1,  1, -1, -1 ]
  H(:,118) = [ -1, -1,  1,  1,  1, -1,  1, -1,  1 ]
  H(:,119) = [ -1, -1,  1,  1,  1, -1,  1,  1, -1 ]
  H(:,120) = [ -1, -1,  1,  1,  1, -1,  1,  1,  1 ]
  H(:,121) = [ -1, -1,  1,  1,  1,  1, -1, -1, -1 ]
  H(:,122) = [ -1, -1,  1,  1,  1,  1, -1, -1,  1 ]
  H(:,123) = [ -1, -1,  1,  1,  1,  1, -1,  1, -1 ]
  H(:,124) = [ -1, -1,  1,  1,  1,  1, -1,  1,  1 ]
  H(:,125) = [ -1, -1,  1,  1,  1,  1,  1, -1, -1 ]
  H(:,126) = [ -1, -1,  1,  1,  1,  1,  1, -1,  1 ]
  H(:,127) = [ -1, -1,  1,  1,  1,  1,  1,  1, -1 ]
  H(:,128) = [ -1, -1,  1,  1,  1,  1,  1,  1,  1 ]
  H(:,129) = [ -1,  1, -1, -1, -1, -1, -1, -1, -1 ]
  H(:,130) = [ -1,  1, -1, -1, -1, -1, -1, -1,  1 ]
  H(:,131) = [ -1,  1, -1, -1, -1, -1, -1,  1, -1 ]
  H(:,132) = [ -1,  1, -1, -1, -1, -1, -1,  1,  1 ]
  H(:,133) = [ -1,  1, -1, -1, -1, -1,  1, -1, -1 ]
  H(:,134) = [ -1,  1, -1, -1, -1, -1,  1, -1,  1 ]
  H(:,135) = [ -1,  1, -1, -1, -1, -1,  1,  1, -1 ]
  H(:,136) = [ -1,  1, -1, -1, -1, -1,  1,  1,  1 ]
  H(:,137) = [ -1,  1, -1, -1, -1,  1, -1, -1, -1 ]
  H(:,138) = [ -1,  1, -1, -1, -1,  1, -1, -1,  1 ]
  H(:,139) = [ -1,  1, -1, -1, -1,  1, -1,  1, -1 ]
  H(:,140) = [ -1,  1, -1, -1, -1,  1, -1,  1,  1 ]
  H(:,141) = [ -1,  1, -1, -1, -1,  1,  1, -1, -1 ]
  H(:,142) = [ -1,  1, -1, -1, -1,  1,  1, -1,  1 ]
  H(:,143) = [ -1,  1, -1, -1, -1,  1,  1,  1, -1 ]
  H(:,144) = [ -1,  1, -1, -1, -1,  1,  1,  1,  1 ]
  H(:,145) = [ -1,  1, -1, -1,  1, -1, -1, -1, -1 ]
  H(:,146) = [ -1,  1, -1, -1,  1, -1, -1, -1,  1 ]
  H(:,147) = [ -1,  1, -1, -1,  1, -1, -1,  1, -1 ]
  H(:,148) = [ -1,  1, -1, -1,  1, -1, -1,  1,  1 ]
  H(:,149) = [ -1,  1, -1, -1,  1, -1,  1, -1, -1 ]
  H(:,150) = [ -1,  1, -1, -1,  1, -1,  1, -1,  1 ]
  H(:,151) = [ -1,  1, -1, -1,  1, -1,  1,  1, -1 ]
  H(:,152) = [ -1,  1, -1, -1,  1, -1,  1,  1,  1 ]
  H(:,153) = [ -1,  1, -1, -1,  1,  1, -1, -1, -1 ]
  H(:,154) = [ -1,  1, -1, -1,  1,  1, -1, -1,  1 ]
  H(:,155) = [ -1,  1, -1, -1,  1,  1, -1,  1, -1 ]
  H(:,156) = [ -1,  1, -1, -1,  1,  1, -1,  1,  1 ]
  H(:,157) = [ -1,  1, -1, -1,  1,  1,  1, -1, -1 ]
  H(:,158) = [ -1,  1, -1, -1,  1,  1,  1, -1,  1 ]
  H(:,159) = [ -1,  1, -1, -1,  1,  1,  1,  1, -1 ]
  H(:,160) = [ -1,  1, -1, -1,  1,  1,  1,  1,  1 ]
  H(:,161) = [ -1,  1, -1,  1, -1, -1, -1, -1, -1 ]
  H(:,162) = [ -1,  1, -1,  1, -1, -1, -1, -1,  1 ]
  H(:,163) = [ -1,  1, -1,  1, -1, -1, -1,  1, -1 ]
  H(:,164) = [ -1,  1, -1,  1, -1, -1, -1,  1,  1 ]
  H(:,165) = [ -1,  1, -1,  1, -1, -1,  1, -1, -1 ]
  H(:,166) = [ -1,  1, -1,  1, -1, -1,  1, -1,  1 ]
  H(:,167) = [ -1,  1, -1,  1, -1, -1,  1,  1, -1 ]
  H(:,168) = [ -1,  1, -1,  1, -1, -1,  1,  1,  1 ]
  H(:,169) = [ -1,  1, -1,  1, -1,  1, -1, -1, -1 ]
  H(:,170) = [ -1,  1, -1,  1, -1,  1, -1, -1,  1 ]
  H(:,171) = [ -1,  1, -1,  1, -1,  1, -1,  1, -1 ]
  H(:,172) = [ -1,  1, -1,  1, -1,  1, -1,  1,  1 ]
  H(:,173) = [ -1,  1, -1,  1, -1,  1,  1, -1, -1 ]
  H(:,174) = [ -1,  1, -1,  1, -1,  1,  1, -1,  1 ]
  H(:,175) = [ -1,  1, -1,  1, -1,  1,  1,  1, -1 ]
  H(:,176) = [ -1,  1, -1,  1, -1,  1,  1,  1,  1 ]
  H(:,177) = [ -1,  1, -1,  1,  1, -1, -1, -1, -1 ]
  H(:,178) = [ -1,  1, -1,  1,  1, -1, -1, -1,  1 ]
  H(:,179) = [ -1,  1, -1,  1,  1, -1, -1,  1, -1 ]
  H(:,180) = [ -1,  1, -1,  1,  1, -1, -1,  1,  1 ]
  H(:,181) = [ -1,  1, -1,  1,  1, -1,  1, -1, -1 ]
  H(:,182) = [ -1,  1, -1,  1,  1, -1,  1, -1,  1 ]
  H(:,183) = [ -1,  1, -1,  1,  1, -1,  1,  1, -1 ]
  H(:,184) = [ -1,  1, -1,  1,  1, -1,  1,  1,  1 ]
  H(:,185) = [ -1,  1, -1,  1,  1,  1, -1, -1, -1 ]
  H(:,186) = [ -1,  1, -1,  1,  1,  1, -1, -1,  1 ]
  H(:,187) = [ -1,  1, -1,  1,  1,  1, -1,  1, -1 ]
  H(:,188) = [ -1,  1, -1,  1,  1,  1, -1,  1,  1 ]
  H(:,189) = [ -1,  1, -1,  1,  1,  1,  1, -1, -1 ]
  H(:,190) = [ -1,  1, -1,  1,  1,  1,  1, -1,  1 ]
  H(:,191) = [ -1,  1, -1,  1,  1,  1,  1,  1, -1 ]
  H(:,192) = [ -1,  1, -1,  1,  1,  1,  1,  1,  1 ]
  H(:,193) = [ -1,  1,  1, -1, -1, -1, -1, -1, -1 ]
  H(:,194) = [ -1,  1,  1, -1, -1, -1, -1, -1,  1 ]
  H(:,195) = [ -1,  1,  1, -1, -1, -1, -1,  1, -1 ]
  H(:,196) = [ -1,  1,  1, -1, -1, -1, -1,  1,  1 ]
  H(:,197) = [ -1,  1,  1, -1, -1, -1,  1, -1, -1 ]
  H(:,198) = [ -1,  1,  1, -1, -1, -1,  1, -1,  1 ]
  H(:,199) = [ -1,  1,  1, -1, -1, -1,  1,  1, -1 ]
  H(:,200) = [ -1,  1,  1, -1, -1, -1,  1,  1,  1 ]
  H(:,201) = [ -1,  1,  1, -1, -1,  1, -1, -1, -1 ]
  H(:,202) = [ -1,  1,  1, -1, -1,  1, -1, -1,  1 ]
  H(:,203) = [ -1,  1,  1, -1, -1,  1, -1,  1, -1 ]
  H(:,204) = [ -1,  1,  1, -1, -1,  1, -1,  1,  1 ]
  H(:,205) = [ -1,  1,  1, -1, -1,  1,  1, -1, -1 ]
  H(:,206) = [ -1,  1,  1, -1, -1,  1,  1, -1,  1 ]
  H(:,207) = [ -1,  1,  1, -1, -1,  1,  1,  1, -1 ]
  H(:,208) = [ -1,  1,  1, -1, -1,  1,  1,  1,  1 ]
  H(:,209) = [ -1,  1,  1, -1,  1, -1, -1, -1, -1 ]
  H(:,210) = [ -1,  1,  1, -1,  1, -1, -1, -1,  1 ]
  H(:,211) = [ -1,  1,  1, -1,  1, -1, -1,  1, -1 ]
  H(:,212) = [ -1,  1,  1, -1,  1, -1, -1,  1,  1 ]
  H(:,213) = [ -1,  1,  1, -1,  1, -1,  1, -1, -1 ]
  H(:,214) = [ -1,  1,  1, -1,  1, -1,  1, -1,  1 ]
  H(:,215) = [ -1,  1,  1, -1,  1, -1,  1,  1, -1 ]
  H(:,216) = [ -1,  1,  1, -1,  1, -1,  1,  1,  1 ]
  H(:,217) = [ -1,  1,  1, -1,  1,  1, -1, -1, -1 ]
  H(:,218) = [ -1,  1,  1, -1,  1,  1, -1, -1,  1 ]
  H(:,219) = [ -1,  1,  1, -1,  1,  1, -1,  1, -1 ]
  H(:,220) = [ -1,  1,  1, -1,  1,  1, -1,  1,  1 ]
  H(:,221) = [ -1,  1,  1, -1,  1,  1,  1, -1, -1 ]
  H(:,222) = [ -1,  1,  1, -1,  1,  1,  1, -1,  1 ]
  H(:,223) = [ -1,  1,  1, -1,  1,  1,  1,  1, -1 ]
  H(:,224) = [ -1,  1,  1, -1,  1,  1,  1,  1,  1 ]
  H(:,225) = [ -1,  1,  1,  1, -1, -1, -1, -1, -1 ]
  H(:,226) = [ -1,  1,  1,  1, -1, -1, -1, -1,  1 ]
  H(:,227) = [ -1,  1,  1,  1, -1, -1, -1,  1, -1 ]
  H(:,228) = [ -1,  1,  1,  1, -1, -1, -1,  1,  1 ]
  H(:,229) = [ -1,  1,  1,  1, -1, -1,  1, -1, -1 ]
  H(:,230) = [ -1,  1,  1,  1, -1, -1,  1, -1,  1 ]
  H(:,231) = [ -1,  1,  1,  1, -1, -1,  1,  1, -1 ]
  H(:,232) = [ -1,  1,  1,  1, -1, -1,  1,  1,  1 ]
  H(:,233) = [ -1,  1,  1,  1, -1,  1, -1, -1, -1 ]
  H(:,234) = [ -1,  1,  1,  1, -1,  1, -1, -1,  1 ]
  H(:,235) = [ -1,  1,  1,  1, -1,  1, -1,  1, -1 ]
  H(:,236) = [ -1,  1,  1,  1, -1,  1, -1,  1,  1 ]
  H(:,237) = [ -1,  1,  1,  1, -1,  1,  1, -1, -1 ]
  H(:,238) = [ -1,  1,  1,  1, -1,  1,  1, -1,  1 ]
  H(:,239) = [ -1,  1,  1,  1, -1,  1,  1,  1, -1 ]
  H(:,240) = [ -1,  1,  1,  1, -1,  1,  1,  1,  1 ]
  H(:,241) = [ -1,  1,  1,  1,  1, -1, -1, -1, -1 ]
  H(:,242) = [ -1,  1,  1,  1,  1, -1, -1, -1,  1 ]
  H(:,243) = [ -1,  1,  1,  1,  1, -1, -1,  1, -1 ]
  H(:,244) = [ -1,  1,  1,  1,  1, -1, -1,  1,  1 ]
  H(:,245) = [ -1,  1,  1,  1,  1, -1,  1, -1, -1 ]
  H(:,246) = [ -1,  1,  1,  1,  1, -1,  1, -1,  1 ]
  H(:,247) = [ -1,  1,  1,  1,  1, -1,  1,  1, -1 ]
  H(:,248) = [ -1,  1,  1,  1,  1, -1,  1,  1,  1 ]
  H(:,249) = [ -1,  1,  1,  1,  1,  1, -1, -1, -1 ]
  H(:,250) = [ -1,  1,  1,  1,  1,  1, -1, -1,  1 ]
  H(:,251) = [ -1,  1,  1,  1,  1,  1, -1,  1, -1 ]
  H(:,252) = [ -1,  1,  1,  1,  1,  1, -1,  1,  1 ]
  H(:,253) = [ -1,  1,  1,  1,  1,  1,  1, -1, -1 ]
  H(:,254) = [ -1,  1,  1,  1,  1,  1,  1, -1,  1 ]
  H(:,255) = [ -1,  1,  1,  1,  1,  1,  1,  1, -1 ]
  H(:,256) = [ -1,  1,  1,  1,  1,  1,  1,  1,  1 ]
  H(:,257) = [  1, -1, -1, -1, -1, -1, -1, -1, -1 ]
  H(:,258) = [  1, -1, -1, -1, -1, -1, -1, -1,  1 ]
  H(:,259) = [  1, -1, -1, -1, -1, -1, -1,  1, -1 ]
  H(:,260) = [  1, -1, -1, -1, -1, -1, -1,  1,  1 ]
  H(:,261) = [  1, -1, -1, -1, -1, -1,  1, -1, -1 ]
  H(:,262) = [  1, -1, -1, -1, -1, -1,  1, -1,  1 ]
  H(:,263) = [  1, -1, -1, -1, -1, -1,  1,  1, -1 ]
  H(:,264) = [  1, -1, -1, -1, -1, -1,  1,  1,  1 ]
  H(:,265) = [  1, -1, -1, -1, -1,  1, -1, -1, -1 ]
  H(:,266) = [  1, -1, -1, -1, -1,  1, -1, -1,  1 ]
  H(:,267) = [  1, -1, -1, -1, -1,  1, -1,  1, -1 ]
  H(:,268) = [  1, -1, -1, -1, -1,  1, -1,  1,  1 ]
  H(:,269) = [  1, -1, -1, -1, -1,  1,  1, -1, -1 ]
  H(:,270) = [  1, -1, -1, -1, -1,  1,  1, -1,  1 ]
  H(:,271) = [  1, -1, -1, -1, -1,  1,  1,  1, -1 ]
  H(:,272) = [  1, -1, -1, -1, -1,  1,  1,  1,  1 ]
  H(:,273) = [  1, -1, -1, -1,  1, -1, -1, -1, -1 ]
  H(:,274) = [  1, -1, -1, -1,  1, -1, -1, -1,  1 ]
  H(:,275) = [  1, -1, -1, -1,  1, -1, -1,  1, -1 ]
  H(:,276) = [  1, -1, -1, -1,  1, -1, -1,  1,  1 ]
  H(:,277) = [  1, -1, -1, -1,  1, -1,  1, -1, -1 ]
  H(:,278) = [  1, -1, -1, -1,  1, -1,  1, -1,  1 ]
  H(:,279) = [  1, -1, -1, -1,  1, -1,  1,  1, -1 ]
  H(:,280) = [  1, -1, -1, -1,  1, -1,  1,  1,  1 ]
  H(:,281) = [  1, -1, -1, -1,  1,  1, -1, -1, -1 ]
  H(:,282) = [  1, -1, -1, -1,  1,  1, -1, -1,  1 ]
  H(:,283) = [  1, -1, -1, -1,  1,  1, -1,  1, -1 ]
  H(:,284) = [  1, -1, -1, -1,  1,  1, -1,  1,  1 ]
  H(:,285) = [  1, -1, -1, -1,  1,  1,  1, -1, -1 ]
  H(:,286) = [  1, -1, -1, -1,  1,  1,  1, -1,  1 ]
  H(:,287) = [  1, -1, -1, -1,  1,  1,  1,  1, -1 ]
  H(:,288) = [  1, -1, -1, -1,  1,  1,  1,  1,  1 ]
  H(:,289) = [  1, -1, -1,  1, -1, -1, -1, -1, -1 ]
  H(:,290) = [  1, -1, -1,  1, -1, -1, -1, -1,  1 ]
  H(:,291) = [  1, -1, -1,  1, -1, -1, -1,  1, -1 ]
  H(:,292) = [  1, -1, -1,  1, -1, -1, -1,  1,  1 ]
  H(:,293) = [  1, -1, -1,  1, -1, -1,  1, -1, -1 ]
  H(:,294) = [  1, -1, -1,  1, -1, -1,  1, -1,  1 ]
  H(:,295) = [  1, -1, -1,  1, -1, -1,  1,  1, -1 ]
  H(:,296) = [  1, -1, -1,  1, -1, -1,  1,  1,  1 ]
  H(:,297) = [  1, -1, -1,  1, -1,  1, -1, -1, -1 ]
  H(:,298) = [  1, -1, -1,  1, -1,  1, -1, -1,  1 ]
  H(:,299) = [  1, -1, -1,  1, -1,  1, -1,  1, -1 ]
  H(:,300) = [  1, -1, -1,  1, -1,  1, -1,  1,  1 ]
  H(:,301) = [  1, -1, -1,  1, -1,  1,  1, -1, -1 ]
  H(:,302) = [  1, -1, -1,  1, -1,  1,  1, -1,  1 ]
  H(:,303) = [  1, -1, -1,  1, -1,  1,  1,  1, -1 ]
  H(:,304) = [  1, -1, -1,  1, -1,  1,  1,  1,  1 ]
  H(:,305) = [  1, -1, -1,  1,  1, -1, -1, -1, -1 ]
  H(:,306) = [  1, -1, -1,  1,  1, -1, -1, -1,  1 ]
  H(:,307) = [  1, -1, -1,  1,  1, -1, -1,  1, -1 ]
  H(:,308) = [  1, -1, -1,  1,  1, -1, -1,  1,  1 ]
  H(:,309) = [  1, -1, -1,  1,  1, -1,  1, -1, -1 ]
  H(:,310) = [  1, -1, -1,  1,  1, -1,  1, -1,  1 ]
  H(:,311) = [  1, -1, -1,  1,  1, -1,  1,  1, -1 ]
  H(:,312) = [  1, -1, -1,  1,  1, -1,  1,  1,  1 ]
  H(:,313) = [  1, -1, -1,  1,  1,  1, -1, -1, -1 ]
  H(:,314) = [  1, -1, -1,  1,  1,  1, -1, -1,  1 ]
  H(:,315) = [  1, -1, -1,  1,  1,  1, -1,  1, -1 ]
  H(:,316) = [  1, -1, -1,  1,  1,  1, -1,  1,  1 ]
  H(:,317) = [  1, -1, -1,  1,  1,  1,  1, -1, -1 ]
  H(:,318) = [  1, -1, -1,  1,  1,  1,  1, -1,  1 ]
  H(:,319) = [  1, -1, -1,  1,  1,  1,  1,  1, -1 ]
  H(:,320) = [  1, -1, -1,  1,  1,  1,  1,  1,  1 ]
  H(:,321) = [  1, -1,  1, -1, -1, -1, -1, -1, -1 ]
  H(:,322) = [  1, -1,  1, -1, -1, -1, -1, -1,  1 ]
  H(:,323) = [  1, -1,  1, -1, -1, -1, -1,  1, -1 ]
  H(:,324) = [  1, -1,  1, -1, -1, -1, -1,  1,  1 ]
  H(:,325) = [  1, -1,  1, -1, -1, -1,  1, -1, -1 ]
  H(:,326) = [  1, -1,  1, -1, -1, -1,  1, -1,  1 ]
  H(:,327) = [  1, -1,  1, -1, -1, -1,  1,  1, -1 ]
  H(:,328) = [  1, -1,  1, -1, -1, -1,  1,  1,  1 ]
  H(:,329) = [  1, -1,  1, -1, -1,  1, -1, -1, -1 ]
  H(:,330) = [  1, -1,  1, -1, -1,  1, -1, -1,  1 ]
  H(:,331) = [  1, -1,  1, -1, -1,  1, -1,  1, -1 ]
  H(:,332) = [  1, -1,  1, -1, -1,  1, -1,  1,  1 ]
  H(:,333) = [  1, -1,  1, -1, -1,  1,  1, -1, -1 ]
  H(:,334) = [  1, -1,  1, -1, -1,  1,  1, -1,  1 ]
  H(:,335) = [  1, -1,  1, -1, -1,  1,  1,  1, -1 ]
  H(:,336) = [  1, -1,  1, -1, -1,  1,  1,  1,  1 ]
  H(:,337) = [  1, -1,  1, -1,  1, -1, -1, -1, -1 ]
  H(:,338) = [  1, -1,  1, -1,  1, -1, -1, -1,  1 ]
  H(:,339) = [  1, -1,  1, -1,  1, -1, -1,  1, -1 ]
  H(:,340) = [  1, -1,  1, -1,  1, -1, -1,  1,  1 ]
  H(:,341) = [  1, -1,  1, -1,  1, -1,  1, -1, -1 ]
  H(:,342) = [  1, -1,  1, -1,  1, -1,  1, -1,  1 ]
  H(:,343) = [  1, -1,  1, -1,  1, -1,  1,  1, -1 ]
  H(:,344) = [  1, -1,  1, -1,  1, -1,  1,  1,  1 ]
  H(:,345) = [  1, -1,  1, -1,  1,  1, -1, -1, -1 ]
  H(:,346) = [  1, -1,  1, -1,  1,  1, -1, -1,  1 ]
  H(:,347) = [  1, -1,  1, -1,  1,  1, -1,  1, -1 ]
  H(:,348) = [  1, -1,  1, -1,  1,  1, -1,  1,  1 ]
  H(:,349) = [  1, -1,  1, -1,  1,  1,  1, -1, -1 ]
  H(:,350) = [  1, -1,  1, -1,  1,  1,  1, -1,  1 ]
  H(:,351) = [  1, -1,  1, -1,  1,  1,  1,  1, -1 ]
  H(:,352) = [  1, -1,  1, -1,  1,  1,  1,  1,  1 ]
  H(:,353) = [  1, -1,  1,  1, -1, -1, -1, -1, -1 ]
  H(:,354) = [  1, -1,  1,  1, -1, -1, -1, -1,  1 ]
  H(:,355) = [  1, -1,  1,  1, -1, -1, -1,  1, -1 ]
  H(:,356) = [  1, -1,  1,  1, -1, -1, -1,  1,  1 ]
  H(:,357) = [  1, -1,  1,  1, -1, -1,  1, -1, -1 ]
  H(:,358) = [  1, -1,  1,  1, -1, -1,  1, -1,  1 ]
  H(:,359) = [  1, -1,  1,  1, -1, -1,  1,  1, -1 ]
  H(:,360) = [  1, -1,  1,  1, -1, -1,  1,  1,  1 ]
  H(:,361) = [  1, -1,  1,  1, -1,  1, -1, -1, -1 ]
  H(:,362) = [  1, -1,  1,  1, -1,  1, -1, -1,  1 ]
  H(:,363) = [  1, -1,  1,  1, -1,  1, -1,  1, -1 ]
  H(:,364) = [  1, -1,  1,  1, -1,  1, -1,  1,  1 ]
  H(:,365) = [  1, -1,  1,  1, -1,  1,  1, -1, -1 ]
  H(:,366) = [  1, -1,  1,  1, -1,  1,  1, -1,  1 ]
  H(:,367) = [  1, -1,  1,  1, -1,  1,  1,  1, -1 ]
  H(:,368) = [  1, -1,  1,  1, -1,  1,  1,  1,  1 ]
  H(:,369) = [  1, -1,  1,  1,  1, -1, -1, -1, -1 ]
  H(:,370) = [  1, -1,  1,  1,  1, -1, -1, -1,  1 ]
  H(:,371) = [  1, -1,  1,  1,  1, -1, -1,  1, -1 ]
  H(:,372) = [  1, -1,  1,  1,  1, -1, -1,  1,  1 ]
  H(:,373) = [  1, -1,  1,  1,  1, -1,  1, -1, -1 ]
  H(:,374) = [  1, -1,  1,  1,  1, -1,  1, -1,  1 ]
  H(:,375) = [  1, -1,  1,  1,  1, -1,  1,  1, -1 ]
  H(:,376) = [  1, -1,  1,  1,  1, -1,  1,  1,  1 ]
  H(:,377) = [  1, -1,  1,  1,  1,  1, -1, -1, -1 ]
  H(:,378) = [  1, -1,  1,  1,  1,  1, -1, -1,  1 ]
  H(:,379) = [  1, -1,  1,  1,  1,  1, -1,  1, -1 ]
  H(:,380) = [  1, -1,  1,  1,  1,  1, -1,  1,  1 ]
  H(:,381) = [  1, -1,  1,  1,  1,  1,  1, -1, -1 ]
  H(:,382) = [  1, -1,  1,  1,  1,  1,  1, -1,  1 ]
  H(:,383) = [  1, -1,  1,  1,  1,  1,  1,  1, -1 ]
  H(:,384) = [  1, -1,  1,  1,  1,  1,  1,  1,  1 ]
  H(:,385) = [  1,  1, -1, -1, -1, -1, -1, -1, -1 ]
  H(:,386) = [  1,  1, -1, -1, -1, -1, -1, -1,  1 ]
  H(:,387) = [  1,  1, -1, -1, -1, -1, -1,  1, -1 ]
  H(:,388) = [  1,  1, -1, -1, -1, -1, -1,  1,  1 ]
  H(:,389) = [  1,  1, -1, -1, -1, -1,  1, -1, -1 ]
  H(:,390) = [  1,  1, -1, -1, -1, -1,  1, -1,  1 ]
  H(:,391) = [  1,  1, -1, -1, -1, -1,  1,  1, -1 ]
  H(:,392) = [  1,  1, -1, -1, -1, -1,  1,  1,  1 ]
  H(:,393) = [  1,  1, -1, -1, -1,  1, -1, -1, -1 ]
  H(:,394) = [  1,  1, -1, -1, -1,  1, -1, -1,  1 ]
  H(:,395) = [  1,  1, -1, -1, -1,  1, -1,  1, -1 ]
  H(:,396) = [  1,  1, -1, -1, -1,  1, -1,  1,  1 ]
  H(:,397) = [  1,  1, -1, -1, -1,  1,  1, -1, -1 ]
  H(:,398) = [  1,  1, -1, -1, -1,  1,  1, -1,  1 ]
  H(:,399) = [  1,  1, -1, -1, -1,  1,  1,  1, -1 ]
  H(:,400) = [  1,  1, -1, -1, -1,  1,  1,  1,  1 ]
  H(:,401) = [  1,  1, -1, -1,  1, -1, -1, -1, -1 ]
  H(:,402) = [  1,  1, -1, -1,  1, -1, -1, -1,  1 ]
  H(:,403) = [  1,  1, -1, -1,  1, -1, -1,  1, -1 ]
  H(:,404) = [  1,  1, -1, -1,  1, -1, -1,  1,  1 ]
  H(:,405) = [  1,  1, -1, -1,  1, -1,  1, -1, -1 ]
  H(:,406) = [  1,  1, -1, -1,  1, -1,  1, -1,  1 ]
  H(:,407) = [  1,  1, -1, -1,  1, -1,  1,  1, -1 ]
  H(:,408) = [  1,  1, -1, -1,  1, -1,  1,  1,  1 ]
  H(:,409) = [  1,  1, -1, -1,  1,  1, -1, -1, -1 ]
  H(:,410) = [  1,  1, -1, -1,  1,  1, -1, -1,  1 ]
  H(:,411) = [  1,  1, -1, -1,  1,  1, -1,  1, -1 ]
  H(:,412) = [  1,  1, -1, -1,  1,  1, -1,  1,  1 ]
  H(:,413) = [  1,  1, -1, -1,  1,  1,  1, -1, -1 ]
  H(:,414) = [  1,  1, -1, -1,  1,  1,  1, -1,  1 ]
  H(:,415) = [  1,  1, -1, -1,  1,  1,  1,  1, -1 ]
  H(:,416) = [  1,  1, -1, -1,  1,  1,  1,  1,  1 ]
  H(:,417) = [  1,  1, -1,  1, -1, -1, -1, -1, -1 ]
  H(:,418) = [  1,  1, -1,  1, -1, -1, -1, -1,  1 ]
  H(:,419) = [  1,  1, -1,  1, -1, -1, -1,  1, -1 ]
  H(:,420) = [  1,  1, -1,  1, -1, -1, -1,  1,  1 ]
  H(:,421) = [  1,  1, -1,  1, -1, -1,  1, -1, -1 ]
  H(:,422) = [  1,  1, -1,  1, -1, -1,  1, -1,  1 ]
  H(:,423) = [  1,  1, -1,  1, -1, -1,  1,  1, -1 ]
  H(:,424) = [  1,  1, -1,  1, -1, -1,  1,  1,  1 ]
  H(:,425) = [  1,  1, -1,  1, -1,  1, -1, -1, -1 ]
  H(:,426) = [  1,  1, -1,  1, -1,  1, -1, -1,  1 ]
  H(:,427) = [  1,  1, -1,  1, -1,  1, -1,  1, -1 ]
  H(:,428) = [  1,  1, -1,  1, -1,  1, -1,  1,  1 ]
  H(:,429) = [  1,  1, -1,  1, -1,  1,  1, -1, -1 ]
  H(:,430) = [  1,  1, -1,  1, -1,  1,  1, -1,  1 ]
  H(:,431) = [  1,  1, -1,  1, -1,  1,  1,  1, -1 ]
  H(:,432) = [  1,  1, -1,  1, -1,  1,  1,  1,  1 ]
  H(:,433) = [  1,  1, -1,  1,  1, -1, -1, -1, -1 ]
  H(:,434) = [  1,  1, -1,  1,  1, -1, -1, -1,  1 ]
  H(:,435) = [  1,  1, -1,  1,  1, -1, -1,  1, -1 ]
  H(:,436) = [  1,  1, -1,  1,  1, -1, -1,  1,  1 ]
  H(:,437) = [  1,  1, -1,  1,  1, -1,  1, -1, -1 ]
  H(:,438) = [  1,  1, -1,  1,  1, -1,  1, -1,  1 ]
  H(:,439) = [  1,  1, -1,  1,  1, -1,  1,  1, -1 ]
  H(:,440) = [  1,  1, -1,  1,  1, -1,  1,  1,  1 ]
  H(:,441) = [  1,  1, -1,  1,  1,  1, -1, -1, -1 ]
  H(:,442) = [  1,  1, -1,  1,  1,  1, -1, -1,  1 ]
  H(:,443) = [  1,  1, -1,  1,  1,  1, -1,  1, -1 ]
  H(:,444) = [  1,  1, -1,  1,  1,  1, -1,  1,  1 ]
  H(:,445) = [  1,  1, -1,  1,  1,  1,  1, -1, -1 ]
  H(:,446) = [  1,  1, -1,  1,  1,  1,  1, -1,  1 ]
  H(:,447) = [  1,  1, -1,  1,  1,  1,  1,  1, -1 ]
  H(:,448) = [  1,  1, -1,  1,  1,  1,  1,  1,  1 ]
  H(:,449) = [  1,  1,  1, -1, -1, -1, -1, -1, -1 ]
  H(:,450) = [  1,  1,  1, -1, -1, -1, -1, -1,  1 ]
  H(:,451) = [  1,  1,  1, -1, -1, -1, -1,  1, -1 ]
  H(:,452) = [  1,  1,  1, -1, -1, -1, -1,  1,  1 ]
  H(:,453) = [  1,  1,  1, -1, -1, -1,  1, -1, -1 ]
  H(:,454) = [  1,  1,  1, -1, -1, -1,  1, -1,  1 ]
  H(:,455) = [  1,  1,  1, -1, -1, -1,  1,  1, -1 ]
  H(:,456) = [  1,  1,  1, -1, -1, -1,  1,  1,  1 ]
  H(:,457) = [  1,  1,  1, -1, -1,  1, -1, -1, -1 ]
  H(:,458) = [  1,  1,  1, -1, -1,  1, -1, -1,  1 ]
  H(:,459) = [  1,  1,  1, -1, -1,  1, -1,  1, -1 ]
  H(:,460) = [  1,  1,  1, -1, -1,  1, -1,  1,  1 ]
  H(:,461) = [  1,  1,  1, -1, -1,  1,  1, -1, -1 ]
  H(:,462) = [  1,  1,  1, -1, -1,  1,  1, -1,  1 ]
  H(:,463) = [  1,  1,  1, -1, -1,  1,  1,  1, -1 ]
  H(:,464) = [  1,  1,  1, -1, -1,  1,  1,  1,  1 ]
  H(:,465) = [  1,  1,  1, -1,  1, -1, -1, -1, -1 ]
  H(:,466) = [  1,  1,  1, -1,  1, -1, -1, -1,  1 ]
  H(:,467) = [  1,  1,  1, -1,  1, -1, -1,  1, -1 ]
  H(:,468) = [  1,  1,  1, -1,  1, -1, -1,  1,  1 ]
  H(:,469) = [  1,  1,  1, -1,  1, -1,  1, -1, -1 ]
  H(:,470) = [  1,  1,  1, -1,  1, -1,  1, -1,  1 ]
  H(:,471) = [  1,  1,  1, -1,  1, -1,  1,  1, -1 ]
  H(:,472) = [  1,  1,  1, -1,  1, -1,  1,  1,  1 ]
  H(:,473) = [  1,  1,  1, -1,  1,  1, -1, -1, -1 ]
  H(:,474) = [  1,  1,  1, -1,  1,  1, -1, -1,  1 ]
  H(:,475) = [  1,  1,  1, -1,  1,  1, -1,  1, -1 ]
  H(:,476) = [  1,  1,  1, -1,  1,  1, -1,  1,  1 ]
  H(:,477) = [  1,  1,  1, -1,  1,  1,  1, -1, -1 ]
  H(:,478) = [  1,  1,  1, -1,  1,  1,  1, -1,  1 ]
  H(:,479) = [  1,  1,  1, -1,  1,  1,  1,  1, -1 ]
  H(:,480) = [  1,  1,  1, -1,  1,  1,  1,  1,  1 ]
  H(:,481) = [  1,  1,  1,  1, -1, -1, -1, -1, -1 ]
  H(:,482) = [  1,  1,  1,  1, -1, -1, -1, -1,  1 ]
  H(:,483) = [  1,  1,  1,  1, -1, -1, -1,  1, -1 ]
  H(:,484) = [  1,  1,  1,  1, -1, -1, -1,  1,  1 ]
  H(:,485) = [  1,  1,  1,  1, -1, -1,  1, -1, -1 ]
  H(:,486) = [  1,  1,  1,  1, -1, -1,  1, -1,  1 ]
  H(:,487) = [  1,  1,  1,  1, -1, -1,  1,  1, -1 ]
  H(:,488) = [  1,  1,  1,  1, -1, -1,  1,  1,  1 ]
  H(:,489) = [  1,  1,  1,  1, -1,  1, -1, -1, -1 ]
  H(:,490) = [  1,  1,  1,  1, -1,  1, -1, -1,  1 ]
  H(:,491) = [  1,  1,  1,  1, -1,  1, -1,  1, -1 ]
  H(:,492) = [  1,  1,  1,  1, -1,  1, -1,  1,  1 ]
  H(:,493) = [  1,  1,  1,  1, -1,  1,  1, -1, -1 ]
  H(:,494) = [  1,  1,  1,  1, -1,  1,  1, -1,  1 ]
  H(:,495) = [  1,  1,  1,  1, -1,  1,  1,  1, -1 ]
  H(:,496) = [  1,  1,  1,  1, -1,  1,  1,  1,  1 ]
  H(:,497) = [  1,  1,  1,  1,  1, -1, -1, -1, -1 ]
  H(:,498) = [  1,  1,  1,  1,  1, -1, -1, -1,  1 ]
  H(:,499) = [  1,  1,  1,  1,  1, -1, -1,  1, -1 ]
  H(:,500) = [  1,  1,  1,  1,  1, -1, -1,  1,  1 ]
  H(:,501) = [  1,  1,  1,  1,  1, -1,  1, -1, -1 ]
  H(:,502) = [  1,  1,  1,  1,  1, -1,  1, -1,  1 ]
  H(:,503) = [  1,  1,  1,  1,  1, -1,  1,  1, -1 ]
  H(:,504) = [  1,  1,  1,  1,  1, -1,  1,  1,  1 ]
  H(:,505) = [  1,  1,  1,  1,  1,  1, -1, -1, -1 ]
  H(:,506) = [  1,  1,  1,  1,  1,  1, -1, -1,  1 ]
  H(:,507) = [  1,  1,  1,  1,  1,  1, -1,  1, -1 ]
  H(:,508) = [  1,  1,  1,  1,  1,  1, -1,  1,  1 ]
  H(:,509) = [  1,  1,  1,  1,  1,  1,  1, -1, -1 ]
  H(:,510) = [  1,  1,  1,  1,  1,  1,  1, -1,  1 ]
  H(:,511) = [  1,  1,  1,  1,  1,  1,  1,  1, -1 ]
  H(:,512) = [  1,  1,  1,  1,  1,  1,  1,  1,  1 ]

  H_HC(:,9) = [ ((((2*(binco-1)+flip)*1+binpos, flip = 0, 1), binpos = 1, 1), binco = 1, 512/1/2) ]
  end subroutine hel_init


  subroutine pol_init(pol) &
      & bind(c,name="ol_f_pol_init_ppllnnjj_vbs_nexnmxemucdxsxg_1")
    implicit none
    integer, intent(in) :: pol(9)
    POLSEL = pol
  end subroutine pol_init

end module ol_external_ppllnnjj_vbs_nexnmxemucdxsxg_1


module colour_basis_ppllnnjj_vbs_nexnmxemucdxsxg_1
  implicit none
  ! tree colour basis
  integer, save :: extcolours(9) = [0,0,0,0,1,1,1,1,2]
  contains

  pure subroutine tree_colbasis_dim(extcols, ncolb, ncoupl, maxpows, nhel) &
    & bind(c, name="ol_tree_colbasis_dim_ppllnnjj_vbs_nexnmxemucdxsxg_1")
    implicit none
    ! colour representation of external particles: 0=neutral, 1=fundamental, 2=adjoint
    integer, intent(out) :: extcols(9)
    ! number of tree colour basis elements; number of selected couplings, number of selected powers per coupling
    integer, intent(out) :: ncolb, ncoupl, maxpows
    ! number of helicity configurations (all, not just non-vanishing)
    integer, intent(out) :: nhel
    extcols = extcolours
    ncolb = 4
    ncoupl = 1
    maxpows = 1
    nhel = 512
  end subroutine tree_colbasis_dim

  subroutine tree_colbasis(basis, powers) &
    & bind(c, name="ol_tree_colbasis_ppllnnjj_vbs_nexnmxemucdxsxg_1")
    implicit none
    integer, intent(out) :: powers(1,1)
    integer, intent(out) :: basis(3,4)
#if 1 > 0
    ! selected powers for each selected coupling
    powers = reshape([8], [1,1])
#endif
#if 4 > 0
    ! tree colour basis: [[composition_number, permutation_number, *coupling_powers], ...]
    basis = reshape( &
      [1,110,4,1,112,4,1,116,4,1,118,4], &
      [3,4])
#endif
  end subroutine tree_colbasis

end module colour_basis_ppllnnjj_vbs_nexnmxemucdxsxg_1

! **********************************************************************
module ol_heltables_ppllnnjj_vbs_nexnmxemucdxsxg_1
! **********************************************************************
  use KIND_TYPES, only: intkind2
  implicit none

  logical :: heltables_not_init = .true.

  ! helicity states of external particles
  ! integer, save :: &
  !   H1(2) = [-1,1], &
  !   H2(3) = [-1,0,1]
  !   ...
  integer, save :: &
    H1(2) = [-1,1], &
    H2(2) = [-1,1], &
    H3(2) = [-1,1], &
    H4(2) = [-1,1], &
    H5(2) = [-1,1], &
    H6(2) = [-1,1], &
    H7(2) = [-1,1], &
    H8(2) = [-1,1], &
    H9(2) = [-1,1]

  ! number of helicity states for wave functions returned by a propagator call: n2(sz)
  ! number of helicity states for wave functions in a v-point vertex call (v >= 3)
  ! or a contraction (v = 3): n<v>(v,sz)
  integer(intkind2), save :: n2(30), n3(3,132)

  ! helicity tables used in the construction of the h helicity states of a wave function (amplitude)
  ! from an v-point vertex (contraction): t<v>x<h>(v-1,h,sz)
  integer(intkind2), save :: t3x4(2,4,6), t3x8(2,8,8), t3x16(2,16,24), t3x32(2,32,38), t3x512(2,512,56)

  ! change of global-helicity state resulting from flip of individual-particle helicity
  integer(intkind2), save :: eflip(512,9)
  integer,           save :: exthel(512,9)
  integer,           save :: firstpol(9)

  contains

! **********************************************************************
subroutine init_heltables
! **********************************************************************
  use ol_helicity_init, only: heltable
  implicit none

  ! I/O helicity tables for vertices, propagators and contractions;
  ! helicity table for a vertex call: n_in/n_out are the number helicity states of the incoming/outgoing wave functions
  ! call heltable([<n_in1>, <n_in2>, ..., <n_out>], n, t)
  ! propagators only need the number of helicity configurations which is equal for the incoming and outgoing wave function
  ! n = <n>
  call heltable([2,2,4], n3(:,1), t3x4(:,:,1))
  call heltable([2,2,4], n3(:,2), t3x4(:,:,2))
  call heltable([2,2,4], n3(:,3), t3x4(:,:,3))
  n2(1) = 4
  n2(2) = 4
  call heltable([4,2,8], n3(:,4), t3x8(:,:,1))
  call heltable([2,4,8], n3(:,5), t3x8(:,:,2))
  n2(3) = 8
  n2(4) = 4
  n2(5) = 8
  call heltable([8,2,16], n3(:,6), t3x16(:,:,1))
  call heltable([4,8,32], n3(:,7), t3x32(:,:,1))
  call heltable([4,4,16], n3(:,8), t3x16(:,:,2))
  n2(6) = 16
  call heltable([16,2,32], n3(:,9), t3x32(:,:,2))
  call heltable([4,2,8], n3(:,10), t3x8(:,:,3))
  call heltable([2,4,8], n3(:,11), t3x8(:,:,4))
  n2(7) = 8
  n2(8) = 8
  call heltable([8,2,16], n3(:,12), t3x16(:,:,3))
  call heltable([4,8,32], n3(:,13), t3x32(:,:,3))
  call heltable([2,4,8], n3(:,14), t3x8(:,:,5))
  n2(9) = 8
  call heltable([2,8,16], n3(:,15), t3x16(:,:,4))
  call heltable([2,4,8], n3(:,16), t3x8(:,:,6))
  n2(10) = 8
  call heltable([2,8,16], n3(:,17), t3x16(:,:,5))
  call heltable([4,4,16], n3(:,18), t3x16(:,:,6))
  n2(11) = 16
  call heltable([16,2,32], n3(:,19), t3x32(:,:,4))
  call heltable([2,2,4], n3(:,20), t3x4(:,:,4))
  call heltable([4,2,8], n3(:,21), t3x8(:,:,7))
  n2(12) = 8
  n2(13) = 4
  call heltable([8,2,16], n3(:,22), t3x16(:,:,7))
  call heltable([4,8,32], n3(:,23), t3x32(:,:,5))
  call heltable([4,4,16], n3(:,24), t3x16(:,:,8))
  n2(14) = 16
  call heltable([16,2,32], n3(:,25), t3x32(:,:,6))
  call heltable([2,8,16], n3(:,26), t3x16(:,:,9))
  call heltable([4,2,8], n3(:,27), t3x8(:,:,8))
  n2(15) = 8
  call heltable([8,2,16], n3(:,28), t3x16(:,:,10))
  call heltable([4,8,32], n3(:,29), t3x32(:,:,7))
  call heltable([2,8,16], n3(:,30), t3x16(:,:,11))
  call heltable([4,4,16], n3(:,31), t3x16(:,:,12))
  n2(16) = 16
  call heltable([16,2,32], n3(:,32), t3x32(:,:,8))
  call heltable([2,2,4], n3(:,33), t3x4(:,:,5))
  n2(17) = 4
  call heltable([8,4,32], n3(:,34), t3x32(:,:,9))
  call heltable([8,4,32], n3(:,35), t3x32(:,:,10))
  call heltable([4,4,16], n3(:,36), t3x16(:,:,13))
  n2(18) = 16
  call heltable([2,16,32], n3(:,37), t3x32(:,:,11))
  call heltable([4,4,16], n3(:,38), t3x16(:,:,14))
  n2(19) = 16
  call heltable([2,16,32], n3(:,39), t3x32(:,:,12))
  call heltable([2,2,4], n3(:,40), t3x4(:,:,6))
  n2(20) = 4
  call heltable([8,4,32], n3(:,41), t3x32(:,:,13))
  call heltable([4,4,16], n3(:,42), t3x16(:,:,15))
  n2(21) = 16
  call heltable([2,16,32], n3(:,43), t3x32(:,:,14))
  call heltable([8,4,32], n3(:,44), t3x32(:,:,15))
  call heltable([4,4,16], n3(:,45), t3x16(:,:,16))
  n2(22) = 16
  call heltable([2,16,32], n3(:,46), t3x32(:,:,16))
  call heltable([16,2,32], n3(:,47), t3x32(:,:,17))
  call heltable([2,8,16], n3(:,48), t3x16(:,:,17))
  n2(23) = 16
  call heltable([2,16,32], n3(:,49), t3x32(:,:,18))
  call heltable([2,8,16], n3(:,50), t3x16(:,:,18))
  n2(24) = 16
  call heltable([2,16,32], n3(:,51), t3x32(:,:,19))
  call heltable([8,2,16], n3(:,52), t3x16(:,:,19))
  n2(25) = 16
  call heltable([16,2,32], n3(:,53), t3x32(:,:,20))
  call heltable([16,2,32], n3(:,54), t3x32(:,:,21))
  call heltable([2,16,32], n3(:,55), t3x32(:,:,22))
  call heltable([16,2,32], n3(:,56), t3x32(:,:,23))
  call heltable([2,8,16], n3(:,57), t3x16(:,:,20))
  n2(26) = 16
  call heltable([2,16,32], n3(:,58), t3x32(:,:,24))
  call heltable([2,8,16], n3(:,59), t3x16(:,:,21))
  n2(27) = 16
  call heltable([2,16,32], n3(:,60), t3x32(:,:,25))
  call heltable([2,16,32], n3(:,61), t3x32(:,:,26))
  call heltable([16,2,32], n3(:,62), t3x32(:,:,27))
  call heltable([8,2,16], n3(:,63), t3x16(:,:,22))
  n2(28) = 16
  call heltable([16,2,32], n3(:,64), t3x32(:,:,28))
  call heltable([2,16,32], n3(:,65), t3x32(:,:,29))
  call heltable([16,2,32], n3(:,66), t3x32(:,:,30))
  call heltable([8,2,16], n3(:,67), t3x16(:,:,23))
  n2(29) = 16
  call heltable([16,2,32], n3(:,68), t3x32(:,:,31))
  call heltable([16,2,32], n3(:,69), t3x32(:,:,32))
  call heltable([16,2,32], n3(:,70), t3x32(:,:,33))
  call heltable([8,2,16], n3(:,71), t3x16(:,:,24))
  n2(30) = 16
  call heltable([16,2,32], n3(:,72), t3x32(:,:,34))
  call heltable([16,2,32], n3(:,73), t3x32(:,:,35))
  call heltable([2,16,32], n3(:,74), t3x32(:,:,36))
  call heltable([16,2,32], n3(:,75), t3x32(:,:,37))
  call heltable([16,2,32], n3(:,76), t3x32(:,:,38))
  call heltable([16,32,512], n3(:,77), t3x512(:,:,1))
  call heltable([16,32,512], n3(:,78), t3x512(:,:,2))
  call heltable([16,32,512], n3(:,79), t3x512(:,:,3))
  call heltable([32,16,512], n3(:,80), t3x512(:,:,4))
  call heltable([32,16,512], n3(:,81), t3x512(:,:,5))
  call heltable([32,16,512], n3(:,82), t3x512(:,:,6))
  call heltable([16,32,512], n3(:,83), t3x512(:,:,7))
  call heltable([16,32,512], n3(:,84), t3x512(:,:,8))
  call heltable([16,32,512], n3(:,85), t3x512(:,:,9))
  call heltable([16,32,512], n3(:,86), t3x512(:,:,10))
  call heltable([32,16,512], n3(:,87), t3x512(:,:,11))
  call heltable([32,16,512], n3(:,88), t3x512(:,:,12))
  call heltable([16,32,512], n3(:,89), t3x512(:,:,13))
  call heltable([32,16,512], n3(:,90), t3x512(:,:,14))
  call heltable([16,32,512], n3(:,91), t3x512(:,:,15))
  call heltable([16,32,512], n3(:,92), t3x512(:,:,16))
  call heltable([16,32,512], n3(:,93), t3x512(:,:,17))
  call heltable([16,32,512], n3(:,94), t3x512(:,:,18))
  call heltable([16,32,512], n3(:,95), t3x512(:,:,19))
  call heltable([16,32,512], n3(:,96), t3x512(:,:,20))
  call heltable([16,32,512], n3(:,97), t3x512(:,:,21))
  call heltable([16,32,512], n3(:,98), t3x512(:,:,22))
  call heltable([16,32,512], n3(:,99), t3x512(:,:,23))
  call heltable([16,32,512], n3(:,100), t3x512(:,:,24))
  call heltable([16,32,512], n3(:,101), t3x512(:,:,25))
  call heltable([16,32,512], n3(:,102), t3x512(:,:,26))
  call heltable([16,32,512], n3(:,103), t3x512(:,:,27))
  call heltable([16,32,512], n3(:,104), t3x512(:,:,28))
  call heltable([16,32,512], n3(:,105), t3x512(:,:,29))
  call heltable([16,32,512], n3(:,106), t3x512(:,:,30))
  call heltable([16,32,512], n3(:,107), t3x512(:,:,31))
  call heltable([16,32,512], n3(:,108), t3x512(:,:,32))
  call heltable([16,32,512], n3(:,109), t3x512(:,:,33))
  call heltable([16,32,512], n3(:,110), t3x512(:,:,34))
  call heltable([16,32,512], n3(:,111), t3x512(:,:,35))
  call heltable([16,32,512], n3(:,112), t3x512(:,:,36))
  call heltable([16,32,512], n3(:,113), t3x512(:,:,37))
  call heltable([16,32,512], n3(:,114), t3x512(:,:,38))
  call heltable([16,32,512], n3(:,115), t3x512(:,:,39))
  call heltable([16,32,512], n3(:,116), t3x512(:,:,40))
  call heltable([16,32,512], n3(:,117), t3x512(:,:,41))
  call heltable([16,32,512], n3(:,118), t3x512(:,:,42))
  call heltable([16,32,512], n3(:,119), t3x512(:,:,43))
  call heltable([16,32,512], n3(:,120), t3x512(:,:,44))
  call heltable([16,32,512], n3(:,121), t3x512(:,:,45))
  call heltable([16,32,512], n3(:,122), t3x512(:,:,46))
  call heltable([16,32,512], n3(:,123), t3x512(:,:,47))
  call heltable([16,32,512], n3(:,124), t3x512(:,:,48))
  call heltable([16,32,512], n3(:,125), t3x512(:,:,49))
  call heltable([16,32,512], n3(:,126), t3x512(:,:,50))
  call heltable([16,32,512], n3(:,127), t3x512(:,:,51))
  call heltable([16,32,512], n3(:,128), t3x512(:,:,52))
  call heltable([16,32,512], n3(:,129), t3x512(:,:,53))
  call heltable([16,32,512], n3(:,130), t3x512(:,:,54))
  call heltable([16,32,512], n3(:,131), t3x512(:,:,55))
  call heltable([16,32,512], n3(:,132), t3x512(:,:,56))

  heltables_not_init = .false.

end subroutine init_heltables

end module ol_heltables_ppllnnjj_vbs_nexnmxemucdxsxg_1
