
! **********************************************************************
module ol_tables_storage_ppllnnjj_ew_nexnmxemuudxdx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  ! helicity tables for the 1-loop recursion
integer(intkind2), save :: h0tab(256,344)
integer(intkind2), save :: heltab2x2(2,2,184)
integer(intkind2), save :: heltab2x4(2,4,70)
integer(intkind2), save :: heltab2x8(2,8,268)
integer(intkind2), save :: heltab2x16(2,16,316)
integer(intkind2), save :: heltab2x32(2,32,128)
integer(intkind2), save :: heltab2x64(2,64,12)
integer(intkind2), save :: heltab2x128(2,128,96)
integer(intkind2), save :: heltab2x256(2,256,344)


  ! number of helicity states for openloops recursion steps
integer(intkind2), save :: m0h(344)
integer(intkind2), save :: m3h2x1(3,184)
integer(intkind2), save :: m3h4x1(3,58)
integer(intkind2), save :: m3h8x1(3,72)
integer(intkind2), save :: m3h16x1(3,136)
integer(intkind2), save :: m3h32x1(3,16)
integer(intkind2), save :: m3h2x2(3,12)
integer(intkind2), save :: m3h4x2(3,146)
integer(intkind2), save :: m3h8x2(3,58)
integer(intkind2), save :: m3h16x2(3,32)
integer(intkind2), save :: m3h2x4(3,50)
integer(intkind2), save :: m3h4x4(3,10)
integer(intkind2), save :: m3h8x4(3,2)
integer(intkind2), save :: m3h2x8(3,112)
integer(intkind2), save :: m3h8x8(3,2)
integer(intkind2), save :: m3h32x8(3,48)
integer(intkind2), save :: m3h2x16(3,78)
integer(intkind2), save :: m3h4x16(3,10)
integer(intkind2), save :: m3h8x16(3,36)
integer(intkind2), save :: m3h16x16(3,152)
integer(intkind2), save :: m3h4x32(3,48)
integer(intkind2), save :: m3h8x32(3,48)
integer(intkind2), save :: m3h2x64(3,12)
integer(intkind2), save :: m3h2x128(3,96)

integer(intkind2), save :: n2h1(222)
integer(intkind2), save :: n2h2(222)
integer(intkind2), save :: n2h4(20)
integer(intkind2), save :: n2h8(170)
integer(intkind2), save :: n2h16(152)
integer(intkind2), save :: n2h32(90)
integer(intkind2), save :: n2h64(12)
integer(intkind2), save :: n2h128(74)


contains

!**********************************************************************
subroutine HOL_m3_init()
!**********************************************************************
! initialize m3 arrays for helicity summation
!**********************************************************************
  use KIND_TYPES, only: REALKIND, intkind2

m3h2x1(1,:)=2
m3h2x1(2,:)=1
m3h2x1(3,:)=2
m3h4x1(1,:)=4
m3h4x1(2,:)=1
m3h4x1(3,:)=4
m3h8x1(1,:)=8
m3h8x1(2,:)=1
m3h8x1(3,:)=8
m3h16x1(1,:)=16
m3h16x1(2,:)=1
m3h16x1(3,:)=16
m3h32x1(1,:)=32
m3h32x1(2,:)=1
m3h32x1(3,:)=32
m3h2x2(1,:)=2
m3h2x2(2,:)=2
m3h2x2(3,:)=4
m3h4x2(1,:)=4
m3h4x2(2,:)=2
m3h4x2(3,:)=8
m3h8x2(1,:)=8
m3h8x2(2,:)=2
m3h8x2(3,:)=16
m3h16x2(1,:)=16
m3h16x2(2,:)=2
m3h16x2(3,:)=32
m3h2x4(1,:)=2
m3h2x4(2,:)=4
m3h2x4(3,:)=8
m3h4x4(1,:)=4
m3h4x4(2,:)=4
m3h4x4(3,:)=16
m3h8x4(1,:)=8
m3h8x4(2,:)=4
m3h8x4(3,:)=32
m3h2x8(1,:)=2
m3h2x8(2,:)=8
m3h2x8(3,:)=16
m3h8x8(1,:)=8
m3h8x8(2,:)=8
m3h8x8(3,:)=64
m3h32x8(1,:)=32
m3h32x8(2,:)=8
m3h32x8(3,:)=256
m3h2x16(1,:)=2
m3h2x16(2,:)=16
m3h2x16(3,:)=32
m3h4x16(1,:)=4
m3h4x16(2,:)=16
m3h4x16(3,:)=64
m3h8x16(1,:)=8
m3h8x16(2,:)=16
m3h8x16(3,:)=128
m3h16x16(1,:)=16
m3h16x16(2,:)=16
m3h16x16(3,:)=256
m3h4x32(1,:)=4
m3h4x32(2,:)=32
m3h4x32(3,:)=128
m3h8x32(1,:)=8
m3h8x32(2,:)=32
m3h8x32(3,:)=256
m3h2x64(1,:)=2
m3h2x64(2,:)=64
m3h2x64(3,:)=128
m3h2x128(1,:)=2
m3h2x128(2,:)=128
m3h2x128(3,:)=256

n2h1(:)=1
n2h2(:)=2
n2h4(:)=4
n2h8(:)=8
n2h16(:)=16
n2h32(:)=32
n2h64(:)=64
n2h128(:)=128


end subroutine HOL_m3_init

!**********************************************************************

end module ol_tables_storage_ppllnnjj_ew_nexnmxemuudxdx_1_/**/REALKIND

! **********************************************************************
module ol_tensor_sum_storage_ppllnnjj_ew_nexnmxemuudxdx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol, hcl, met
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  type(met), save :: M2L1R1

  ! Declarations of loop wave function tensors

  type(hol), save :: G0H1(1)
  type(hol), save :: G1H1(1)
  type(hol), save :: G1H2(40)
  type(hol), save :: G2H2(130)
  type(hol), save :: G0H4(1)
  type(hol), save :: G1H4(71)
  type(hol), save :: G2H4(10)
  type(hol), save :: G0H8(8)
  type(hol), save :: G1H8(135)
  type(hol), save :: G2H8(26)
  type(hol), save :: G0H16(1)
  type(hol), save :: G1H16(96)
  type(hol), save :: G2H16(18)
  type(hol), save :: G0H32(9)
  type(hol), save :: G1H32(40)
  type(hol), save :: G2H32(16)
  type(hol), save :: G0H64(1)
  type(hol), save :: G1H64(10)
  type(hol), save :: G0H128(13)
  type(hol), save :: G1H128(28)
  type(hol), save :: G0H256(1)
  type(hcl), save, dimension(610) :: G0tensor
  type(hcl), save, dimension(610) :: G1tensor
  type(hcl), save, dimension(258) :: G2tensor



  ! Declarations for on-the-fly tensor reduction
type (basis),      save :: RedBasis(169)
type (redset4),    save :: RedSet_4(162)
type (redset5),    save :: RedSet_5(50)
integer, save :: mass2set(0:1,3)
integer, save :: mass3set(0:2,1)
integer, save :: mass4set(0:3,1)
integer, save :: mass5set(0:4,1)



  ! Declarations for TI calls

  integer, save :: momenta_1(2)
  integer, save :: momenta_2(2)
  integer, save :: momenta_3(2)
  integer, save :: momenta_4(2)
  integer, save :: momenta_5(2)
  integer, save :: momenta_6(2)
  integer, save :: momenta_7(2)
  integer, save :: momenta_8(2)
  integer, save :: momenta_9(2)
  integer, save :: momenta_10(2)
  integer, save :: momenta_11(2)
  integer, save :: momenta_12(2)
  integer, save :: momenta_13(2)
  integer, save :: momenta_14(2)
  integer, save :: momenta_15(2)
  integer, save :: momenta_16(2)
  integer, save :: momenta_17(2)
  integer, save :: momenta_18(2)
  integer, save :: momenta_19(2)
  integer, save :: momenta_20(2)
  integer, save :: momenta_21(2)
  integer, save :: momenta_22(2)
  integer, save :: momenta_23(2)
  integer, save :: momenta_24(2)
  integer, save :: momenta_25(2)
  integer, save :: momenta_26(2)
  integer, save :: momenta_27(2)
  integer, save :: momenta_28(3)
  integer, save :: momenta_29(3)
  integer, save :: momenta_30(3)
  integer, save :: momenta_31(3)
  integer, save :: momenta_32(3)
  integer, save :: momenta_33(3)
  integer, save :: momenta_34(3)
  integer, save :: momenta_35(3)
  integer, save :: momenta_36(3)
  integer, save :: momenta_37(3)
  integer, save :: momenta_38(3)
  integer, save :: momenta_39(3)
  integer, save :: momenta_40(3)
  integer, save :: momenta_41(3)
  integer, save :: momenta_42(3)
  integer, save :: momenta_43(3)
  integer, save :: momenta_44(3)
  integer, save :: momenta_45(3)
  integer, save :: momenta_46(3)
  integer, save :: momenta_47(3)
  integer, save :: momenta_48(3)
  integer, save :: momenta_49(3)
  integer, save :: momenta_50(3)
  integer, save :: momenta_51(3)
  integer, save :: momenta_52(3)
  integer, save :: momenta_53(3)
  integer, save :: momenta_54(3)
  integer, save :: momenta_55(3)
  integer, save :: momenta_56(3)
  integer, save :: momenta_57(3)
  integer, save :: momenta_58(3)
  integer, save :: momenta_59(3)
  integer, save :: momenta_60(3)
  integer, save :: momenta_61(3)
  integer, save :: momenta_62(3)
  integer, save :: momenta_63(3)
  integer, save :: momenta_64(3)
  integer, save :: momenta_65(3)
  integer, save :: momenta_66(3)
  integer, save :: momenta_67(3)
  integer, save :: momenta_68(3)
  integer, save :: momenta_69(3)
  integer, save :: momenta_70(3)
  integer, save :: momenta_71(3)
  integer, save :: momenta_72(3)
  integer, save :: momenta_73(3)
  integer, save :: momenta_74(3)
  integer, save :: momenta_75(3)
  integer, save :: momenta_76(3)
  integer, save :: momenta_77(3)
  integer, save :: momenta_78(3)
  integer, save :: momenta_79(3)
  integer, save :: momenta_80(3)
  integer, save :: momenta_81(3)
  integer, save :: momenta_82(3)
  integer, save :: momenta_83(3)
  integer, save :: momenta_84(3)
  integer, save :: momenta_85(3)
  integer, save :: momenta_86(3)
  integer, save :: momenta_87(3)
  integer, save :: momenta_88(3)
  integer, save :: momenta_89(3)
  integer, save :: momenta_90(3)
  integer, save :: momenta_91(3)
  integer, save :: momenta_92(3)
  integer, save :: momenta_93(3)
  integer, save :: momenta_94(3)
  integer, save :: momenta_95(3)
  integer, save :: momenta_96(3)
  integer, save :: momenta_97(3)
  integer, save :: momenta_98(3)
  integer, save :: momenta_99(3)
  integer, save :: momenta_100(3)
  integer, save :: momenta_101(3)
  integer, save :: momenta_102(3)
  integer, save :: momenta_103(3)
  integer, save :: momenta_104(3)
  integer, save :: momenta_105(3)
  integer, save :: momenta_106(3)
  integer, save :: momenta_107(3)
  integer, save :: momenta_108(3)
  integer, save :: momenta_109(3)
  integer, save :: momenta_110(3)
  integer, save :: momenta_111(3)
  integer, save :: momenta_112(3)
  integer, save :: momenta_113(3)
  integer, save :: momenta_114(3)
  integer, save :: momenta_115(3)
  integer, save :: momenta_116(3)
  integer, save :: momenta_117(3)
  integer, save :: momenta_118(3)
  integer, save :: momenta_119(3)
  integer, save :: momenta_120(3)
  integer, save :: momenta_121(3)
  integer, save :: momenta_122(3)
  integer, save :: momenta_123(3)
  integer, save :: momenta_124(3)
  integer, save :: momenta_125(3)
  integer, save :: momenta_126(3)
  integer, save :: momenta_127(3)
  integer, save :: momenta_128(3)
  integer, save :: momenta_129(3)
  integer, save :: momenta_130(3)
  integer, save :: momenta_131(3)
  integer, save :: momenta_132(3)
  integer, save :: momenta_133(3)
  integer, save :: momenta_134(3)
  integer, save :: momenta_135(3)
  integer, save :: momenta_136(3)
  integer, save :: momenta_137(3)
  integer, save :: momenta_138(3)
  integer, save :: momenta_139(4)
  integer, save :: momenta_140(4)
  integer, save :: momenta_141(4)
  integer, save :: momenta_142(4)
  integer, save :: momenta_143(4)
  integer, save :: momenta_144(4)
  integer, save :: momenta_145(4)
  integer, save :: momenta_146(4)
  integer, save :: momenta_147(4)
  integer, save :: momenta_148(4)
  integer, save :: momenta_149(4)
  integer, save :: momenta_150(4)
  integer, save :: momenta_151(4)
  integer, save :: momenta_152(4)
  integer, save :: momenta_153(4)
  integer, save :: momenta_154(4)
  integer, save :: momenta_155(4)
  integer, save :: momenta_156(4)
  integer, save :: momenta_157(4)
  integer, save :: momenta_158(4)
  integer, save :: momenta_159(4)
  integer, save :: momenta_160(4)
  integer, save :: momenta_161(4)
  integer, save :: momenta_162(4)
  integer, save :: momenta_163(4)
  integer, save :: momenta_164(4)
  integer, save :: momenta_165(4)
  integer, save :: momenta_166(4)
  integer, save :: momenta_167(4)
  integer, save :: momenta_168(4)
  integer, save :: momenta_169(4)
  integer, save :: momenta_170(4)
  integer, save :: momenta_171(4)
  integer, save :: momenta_172(4)
  integer, save :: momenta_173(4)
  integer, save :: momenta_174(4)
  integer, save :: momenta_175(4)
  integer, save :: momenta_176(4)
  integer, save :: momenta_177(4)
  integer, save :: momenta_178(4)
  integer, save :: momenta_179(4)
  integer, save :: momenta_180(4)
  integer, save :: momenta_181(4)
  integer, save :: momenta_182(4)
  integer, save :: momenta_183(4)
  integer, save :: momenta_184(4)
  integer, save :: momenta_185(4)
  integer, save :: momenta_186(4)
  integer, save :: momenta_187(4)
  integer, save :: momenta_188(4)
  integer, save :: momenta_189(4)
  integer, save :: momenta_190(4)
  integer, save :: momenta_191(4)
  integer, save :: momenta_192(4)
  integer, save :: momenta_193(4)
  integer, save :: momenta_194(4)
  integer, save :: momenta_195(4)
  integer, save :: momenta_196(4)
  integer, save :: momenta_197(4)
  integer, save :: momenta_198(4)
  integer, save :: momenta_199(4)
  integer, save :: momenta_200(4)
  integer, save :: momenta_201(4)
  integer, save :: momenta_202(4)
  integer, save :: momenta_203(4)
  integer, save :: momenta_204(4)
  integer, save :: momenta_205(4)
  integer, save :: momenta_206(4)
  integer, save :: momenta_207(4)
  integer, save :: momenta_208(4)
  integer, save :: momenta_209(4)
  integer, save :: momenta_210(4)
  integer, save :: momenta_211(4)
  integer, save :: momenta_212(4)
  integer, save :: momenta_213(4)
  integer, save :: momenta_214(4)
  integer, save :: momenta_215(4)
  integer, save :: momenta_216(4)
  integer, save :: momenta_217(4)
  integer, save :: momenta_218(4)
  integer, save :: momenta_219(4)
  integer, save :: momenta_220(4)
  integer, save :: momenta_221(4)
  integer, save :: momenta_222(4)
  integer, save :: momenta_223(4)
  integer, save :: momenta_224(4)
  integer, save :: momenta_225(4)
  integer, save :: momenta_226(4)
  integer, save :: momenta_227(4)
  integer, save :: momenta_228(4)
  integer, save :: momenta_229(4)
  integer, save :: momenta_230(4)
  integer, save :: momenta_231(4)
  integer, save :: momenta_232(4)
  integer, save :: momenta_233(4)
  integer, save :: momenta_234(4)
  integer, save :: momenta_235(4)
  integer, save :: momenta_236(4)
  integer, save :: momenta_237(4)
  integer, save :: momenta_238(4)
  integer, save :: momenta_239(4)
  integer, save :: momenta_240(4)
  integer, save :: momenta_241(4)
  integer, save :: momenta_242(4)
  integer, save :: momenta_243(4)
  integer, save :: momenta_244(4)
  integer, save :: momenta_245(4)
  integer, save :: momenta_246(4)
  integer, save :: momenta_247(4)
  integer, save :: momenta_248(4)
  integer, save :: momenta_249(4)
  integer, save :: momenta_250(4)
  integer, save :: momenta_251(4)
  integer, save :: momenta_252(4)
  integer, save :: momenta_253(4)
  integer, save :: momenta_254(4)
  integer, save :: momenta_255(4)
  integer, save :: momenta_256(4)
  integer, save :: momenta_257(4)
  integer, save :: momenta_258(4)
  integer, save :: momenta_259(4)
  integer, save :: momenta_260(4)
  integer, save :: momenta_261(5)
  integer, save :: momenta_262(5)
  integer, save :: momenta_263(5)
  integer, save :: momenta_264(5)
  integer, save :: momenta_265(5)
  integer, save :: momenta_266(5)
  integer, save :: momenta_267(5)
  integer, save :: momenta_268(5)
  integer, save :: momenta_269(5)
  integer, save :: momenta_270(5)
  integer, save :: momenta_271(5)
  integer, save :: momenta_272(5)
  integer, save :: momenta_273(5)
  integer, save :: momenta_274(5)
  integer, save :: momenta_275(5)
  integer, save :: momenta_276(5)
  integer, save :: momenta_277(5)
  integer, save :: momenta_278(5)
  integer, save :: momenta_279(5)
  integer, save :: momenta_280(5)
  integer, save :: momenta_281(5)
  integer, save :: momenta_282(5)
  integer, save :: momenta_283(5)
  integer, save :: momenta_284(5)
  integer, save :: momenta_285(5)
  integer, save :: momenta_286(5)
  integer, save :: momenta_287(5)
  integer, save :: momenta_288(5)
  integer, save :: momenta_289(5)
  integer, save :: momenta_290(5)
  integer, save :: momenta_291(5)
  integer, save :: momenta_292(5)
  integer, save :: momenta_293(5)
  integer, save :: momenta_294(5)
  integer, save :: momenta_295(5)
  integer, save :: momenta_296(5)
  integer, save :: momenta_297(5)
  integer, save :: momenta_298(5)
  integer, save :: momenta_299(5)
  integer, save :: momenta_300(5)
  integer, save :: momenta_301(5)
  integer, save :: momenta_302(5)
  integer, save :: momenta_303(5)
  integer, save :: momenta_304(5)
  integer, save :: momenta_305(5)
  integer, save :: momenta_306(5)
  integer, save :: momenta_307(5)
  integer, save :: momenta_308(5)
  integer, save :: momenta_309(5)
  integer, save :: momenta_310(5)
  integer, save :: momenta_311(6)
  integer, save :: momenta_312(6)
  integer, save :: momenta_313(6)
  integer, save :: momenta_314(6)
  integer, save :: momenta_315(6)
  integer, save :: momenta_316(6)
  integer, save :: momenta_317(6)
  integer, save :: momenta_318(6)

  integer, save :: masses2_1(2)
  integer, save :: masses2_2(2)
  integer, save :: masses2_3(2)
  integer, save :: masses2_4(2)
  integer, save :: masses2_5(2)
  integer, save :: masses2_6(3)
  integer, save :: masses2_7(4)
  integer, save :: masses2_8(5)
  integer, save :: masses2_9(6)

type(scalarbox), save :: ScalarBoxes(150)

integer, save :: sbarray_1(15)
integer, save :: sbarray_2(15)
integer, save :: sbarray_3(15)
integer, save :: sbarray_4(15)
integer, save :: sbarray_5(15)
integer, save :: sbarray_6(15)
integer, save :: sbarray_7(15)
integer, save :: sbarray_8(15)
integer, save :: sbarray_9(5)
integer, save :: sbarray_10(5)
integer, save :: sbarray_11(5)
integer, save :: sbarray_12(5)
integer, save :: sbarray_13(5)
integer, save :: sbarray_14(5)
integer, save :: sbarray_15(5)
integer, save :: sbarray_16(5)
integer, save :: sbarray_17(5)
integer, save :: sbarray_18(5)
integer, save :: sbarray_19(5)
integer, save :: sbarray_20(5)
integer, save :: sbarray_21(5)
integer, save :: sbarray_22(5)
integer, save :: sbarray_23(5)
integer, save :: sbarray_24(5)
integer, save :: sbarray_25(5)
integer, save :: sbarray_26(5)
integer, save :: sbarray_27(5)
integer, save :: sbarray_28(5)
integer, save :: sbarray_29(5)
integer, save :: sbarray_30(5)
integer, save :: sbarray_31(5)
integer, save :: sbarray_32(5)
integer, save :: sbarray_33(5)
integer, save :: sbarray_34(5)
integer, save :: sbarray_35(5)
integer, save :: sbarray_36(5)
integer, save :: sbarray_37(5)
integer, save :: sbarray_38(5)
integer, save :: sbarray_39(5)
integer, save :: sbarray_40(5)
integer, save :: sbarray_41(5)
integer, save :: sbarray_42(5)
integer, save :: sbarray_43(5)
integer, save :: sbarray_44(5)
integer, save :: sbarray_45(5)
integer, save :: sbarray_46(5)
integer, save :: sbarray_47(5)
integer, save :: sbarray_48(5)
integer, save :: sbarray_49(5)
integer, save :: sbarray_50(5)
integer, save :: sbarray_51(5)
integer, save :: sbarray_52(5)
integer, save :: sbarray_53(5)
integer, save :: sbarray_54(5)
integer, save :: sbarray_55(5)
integer, save :: sbarray_56(5)
integer, save :: sbarray_57(5)
integer, save :: sbarray_58(5)

  type(hcl), save, dimension(269) :: T0sum
  type(hcl), save, dimension(58) :: T1sum


  contains

!**********************************************************************
subroutine HOL_memory_allocation_full()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_loop_storage_ppllnnjj_ew_nexnmxemuudxdx_1_/**/DREALKIND, only: nhel
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none

    call hol_allocation(4,1,4,1,G0H1,1)
  call hol_allocation(4,5,4,1,G1H1,1)
  call hol_allocation(4,5,4,2,G1H2,40)
  call hol_allocation(4,15,4,2,G2H2,130)
  call hol_allocation(4,1,4,4,G0H4,1)
  call hol_allocation(4,5,4,4,G1H4,71)
  call hol_allocation(4,15,4,4,G2H4,10)
  call hol_allocation(4,1,4,8,G0H8,8)
  call hol_allocation(4,5,4,8,G1H8,135)
  call hol_allocation(4,15,4,8,G2H8,26)
  call hol_allocation(4,1,4,16,G0H16,1)
  call hol_allocation(4,5,4,16,G1H16,96)
  call hol_allocation(4,15,4,16,G2H16,18)
  call hol_allocation(4,1,4,32,G0H32,9)
  call hol_allocation(4,5,4,32,G1H32,40)
  call hol_allocation(4,15,4,32,G2H32,16)
  call hol_allocation(4,1,4,64,G0H64,1)
  call hol_allocation(4,5,4,64,G1H64,10)
  call hol_allocation(4,1,4,128,G0H128,13)
  call hol_allocation(4,5,4,128,G1H128,28)
  call hol_allocation(4,1,4,256,G0H256,1)


end subroutine HOL_memory_allocation_full

!**********************************************************************
subroutine HOL_memory_allocation_optimized()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_loop_storage_ppllnnjj_ew_nexnmxemuudxdx_1_/**/DREALKIND, only: nhel
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none

    call hol_allocation(4,1,4,min(nhel,1),G0H1,1)
  call hol_allocation(4,5,4,min(nhel,1),G1H1,1)
  call hol_allocation(4,5,4,min(nhel,2),G1H2,40)
  call hol_allocation(4,15,4,min(nhel,2),G2H2,130)
  call hol_allocation(4,1,4,min(nhel,4),G0H4,1)
  call hol_allocation(4,5,4,min(nhel,4),G1H4,71)
  call hol_allocation(4,15,4,min(nhel,4),G2H4,10)
  call hol_allocation(4,1,4,min(nhel,8),G0H8,8)
  call hol_allocation(4,5,4,min(nhel,8),G1H8,135)
  call hol_allocation(4,15,4,min(nhel,8),G2H8,26)
  call hol_allocation(4,1,4,min(nhel,16),G0H16,1)
  call hol_allocation(4,5,4,min(nhel,16),G1H16,96)
  call hol_allocation(4,15,4,min(nhel,16),G2H16,18)
  call hol_allocation(4,1,4,min(nhel,32),G0H32,9)
  call hol_allocation(4,5,4,min(nhel,32),G1H32,40)
  call hol_allocation(4,15,4,min(nhel,32),G2H32,16)
  call hol_allocation(4,1,4,min(nhel,64),G0H64,1)
  call hol_allocation(4,5,4,min(nhel,64),G1H64,10)
  call hol_allocation(4,1,4,min(nhel,128),G0H128,13)
  call hol_allocation(4,5,4,min(nhel,128),G1H128,28)
  call hol_allocation(4,1,4,min(nhel,256),G0H256,1)


end subroutine HOL_memory_allocation_optimized

!**********************************************************************
subroutine HOL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_deallocation
  implicit none
  integer,   intent(in)    :: dmode

    call hol_deallocation(G0H1,1,dmode)
  call hol_deallocation(G1H1,1,dmode)
  call hol_deallocation(G1H2,40,dmode)
  call hol_deallocation(G2H2,130,dmode)
  call hol_deallocation(G0H4,1,dmode)
  call hol_deallocation(G1H4,71,dmode)
  call hol_deallocation(G2H4,10,dmode)
  call hol_deallocation(G0H8,8,dmode)
  call hol_deallocation(G1H8,135,dmode)
  call hol_deallocation(G2H8,26,dmode)
  call hol_deallocation(G0H16,1,dmode)
  call hol_deallocation(G1H16,96,dmode)
  call hol_deallocation(G2H16,18,dmode)
  call hol_deallocation(G0H32,9,dmode)
  call hol_deallocation(G1H32,40,dmode)
  call hol_deallocation(G2H32,16,dmode)
  call hol_deallocation(G0H64,1,dmode)
  call hol_deallocation(G1H64,10,dmode)
  call hol_deallocation(G0H128,13,dmode)
  call hol_deallocation(G1H128,28,dmode)
  call hol_deallocation(G0H256,1,dmode)


end subroutine HOL_memory_deallocation_/**/REALKIND

!**********************************************************************
subroutine HCL_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

  call hcl_allocation(1,G0tensor, 610)
call hcl_allocation(5,G1tensor, 610)
call hcl_allocation(15,G2tensor, 258)


end subroutine HCL_memory_allocation


!**********************************************************************
subroutine HCL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! deallocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_deallocation
  implicit none
  integer,   intent(in)    :: dmode

  call hcl_deallocation(G0tensor, 610,dmode)
call hcl_deallocation(G1tensor, 610,dmode)
call hcl_deallocation(G2tensor, 258,dmode)

    call hcl_deallocation(T0sum,269,dmode)
  call hcl_deallocation(T1sum,58,dmode)


end subroutine HCL_memory_deallocation_/**/REALKIND


!**********************************************************************
subroutine Tsum_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

    call hcl_allocation(1,T0sum,269)
  call hcl_allocation(5,T1sum,58)


end subroutine Tsum_memory_allocation


#ifdef PRECISION_dp
subroutine max_point(r) &
    & bind(c,name="ol_f_max_point_ppllnnjj_ew_nexnmxemuudxdx_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 6
end subroutine max_point

subroutine tensor_rank(r) &
    & bind(c,name="ol_f_tensor_rank_ppllnnjj_ew_nexnmxemuudxdx_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 1
end subroutine tensor_rank
#endif

subroutine reset_tensor_sum()
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  use ol_parameters_init_/**/REALKIND, only: init_hcl
  implicit none
  integer :: i

  do i = 1,269
    call init_hcl(T0sum(i))
  end do
  do i = 1,58
    call init_hcl(T1sum(i))
  end do

end subroutine reset_tensor_sum


subroutine scale_one_tsum(tsum, spow)
  use ol_parameters_decl_/**/REALKIND, only: scalefactor
  implicit none
  complex(REALKIND), intent(inout) :: tsum(:)
  integer, intent(in) :: spow ! rank 0 scale power
  real(REALKIND) :: sfinv, sfac
  integer :: sz
  sfinv = 1/scalefactor
  sfac = scalefactor**spow
  sz = size(tsum)
  tsum(1) = sfac*tsum(1)
  if (sz > 1) then ! rank 1
    sfac = sfac*sfinv
    tsum(2:5) = sfac*tsum(2:5)
  end if
  if (sz > 5) then ! rank 2
    sfac = sfac*sfinv
    tsum(6:15) = sfac*tsum(6:15)
  end if
  if (sz > 15) then ! rank 3
    sfac = sfac*sfinv
    tsum(16:35) = sfac*tsum(16:35)
  end if
  if (sz > 35) then ! rank 4
    sfac = sfac*sfinv
    tsum(36:70) = sfac*tsum(36:70)
  end if
  if (sz > 70) then ! rank 5
    sfac = sfac*sfinv
    tsum(71:126) = sfac*tsum(71:126)
  end if
  if (sz > 126) then ! rank 6
    sfac = sfac*sfinv
    tsum(127:210) = sfac*tsum(127:210)
  end if
  if (sz > 210) then ! rank 7
    sfac = sfac*sfinv
    tsum(211:330) = sfac*tsum(211:330)
  end if
end subroutine scale_one_tsum


subroutine scale_tensor_sum()
  implicit none
  call scale_one_tsum(T1sum(1)%cmp, 0)
  call scale_one_tsum(T1sum(2)%cmp, 0)
  call scale_one_tsum(T1sum(3)%cmp, 0)
  call scale_one_tsum(T1sum(4)%cmp, 0)
  call scale_one_tsum(T1sum(5)%cmp, 0)
  call scale_one_tsum(T1sum(6)%cmp, 0)
  call scale_one_tsum(T1sum(7)%cmp, 0)
  call scale_one_tsum(T1sum(8)%cmp, 0)
  call scale_one_tsum(T1sum(9)%cmp, -2)
  call scale_one_tsum(T1sum(10)%cmp, -2)
  call scale_one_tsum(T1sum(11)%cmp, -2)
  call scale_one_tsum(T1sum(12)%cmp, -2)
  call scale_one_tsum(T1sum(13)%cmp, -2)
  call scale_one_tsum(T1sum(14)%cmp, -2)
  call scale_one_tsum(T1sum(15)%cmp, -2)
  call scale_one_tsum(T1sum(16)%cmp, -2)
  call scale_one_tsum(T1sum(17)%cmp, -2)
  call scale_one_tsum(T1sum(18)%cmp, -2)
  call scale_one_tsum(T1sum(19)%cmp, -2)
  call scale_one_tsum(T1sum(20)%cmp, -2)
  call scale_one_tsum(T1sum(21)%cmp, -2)
  call scale_one_tsum(T1sum(22)%cmp, -2)
  call scale_one_tsum(T1sum(23)%cmp, -2)
  call scale_one_tsum(T1sum(24)%cmp, -2)
  call scale_one_tsum(T1sum(25)%cmp, -2)
  call scale_one_tsum(T1sum(26)%cmp, -2)
  call scale_one_tsum(T1sum(27)%cmp, -2)
  call scale_one_tsum(T1sum(28)%cmp, -2)
  call scale_one_tsum(T1sum(29)%cmp, -2)
  call scale_one_tsum(T1sum(30)%cmp, -2)
  call scale_one_tsum(T1sum(31)%cmp, -2)
  call scale_one_tsum(T1sum(32)%cmp, -2)
  call scale_one_tsum(T1sum(33)%cmp, -2)
  call scale_one_tsum(T1sum(34)%cmp, -2)
  call scale_one_tsum(T1sum(35)%cmp, -2)
  call scale_one_tsum(T1sum(36)%cmp, -2)
  call scale_one_tsum(T1sum(37)%cmp, -2)
  call scale_one_tsum(T1sum(38)%cmp, -2)
  call scale_one_tsum(T1sum(39)%cmp, -2)
  call scale_one_tsum(T1sum(40)%cmp, -2)
  call scale_one_tsum(T1sum(41)%cmp, -2)
  call scale_one_tsum(T1sum(42)%cmp, -2)
  call scale_one_tsum(T1sum(43)%cmp, -2)
  call scale_one_tsum(T1sum(44)%cmp, -2)
  call scale_one_tsum(T1sum(45)%cmp, -2)
  call scale_one_tsum(T1sum(46)%cmp, -2)
  call scale_one_tsum(T1sum(47)%cmp, -2)
  call scale_one_tsum(T1sum(48)%cmp, -2)
  call scale_one_tsum(T1sum(49)%cmp, -2)
  call scale_one_tsum(T1sum(50)%cmp, -2)
  call scale_one_tsum(T1sum(51)%cmp, -2)
  call scale_one_tsum(T1sum(52)%cmp, -2)
  call scale_one_tsum(T1sum(53)%cmp, -2)
  call scale_one_tsum(T1sum(54)%cmp, -2)
  call scale_one_tsum(T1sum(55)%cmp, -2)
  call scale_one_tsum(T1sum(56)%cmp, -2)
  call scale_one_tsum(T1sum(57)%cmp, -2)
  call scale_one_tsum(T1sum(58)%cmp, -2)
  call scale_one_tsum(T0sum(1)%cmp, -4)
  call scale_one_tsum(T0sum(2)%cmp, -4)
  call scale_one_tsum(T0sum(3)%cmp, -4)
  call scale_one_tsum(T0sum(4)%cmp, -4)
  call scale_one_tsum(T0sum(5)%cmp, -4)
  call scale_one_tsum(T0sum(6)%cmp, -4)
  call scale_one_tsum(T0sum(7)%cmp, -4)
  call scale_one_tsum(T0sum(8)%cmp, -4)
  call scale_one_tsum(T0sum(9)%cmp, -4)
  call scale_one_tsum(T0sum(10)%cmp, -4)
  call scale_one_tsum(T0sum(11)%cmp, -4)
  call scale_one_tsum(T0sum(12)%cmp, -4)
  call scale_one_tsum(T0sum(13)%cmp, -4)
  call scale_one_tsum(T0sum(14)%cmp, -4)
  call scale_one_tsum(T0sum(15)%cmp, -4)
  call scale_one_tsum(T0sum(16)%cmp, -4)
  call scale_one_tsum(T0sum(17)%cmp, -4)
  call scale_one_tsum(T0sum(18)%cmp, -4)
  call scale_one_tsum(T0sum(19)%cmp, -4)
  call scale_one_tsum(T0sum(20)%cmp, -4)
  call scale_one_tsum(T0sum(21)%cmp, -4)
  call scale_one_tsum(T0sum(22)%cmp, -4)
  call scale_one_tsum(T0sum(23)%cmp, -4)
  call scale_one_tsum(T0sum(24)%cmp, -4)
  call scale_one_tsum(T0sum(25)%cmp, -4)
  call scale_one_tsum(T0sum(26)%cmp, -4)
  call scale_one_tsum(T0sum(27)%cmp, -4)
  call scale_one_tsum(T0sum(28)%cmp, -4)
  call scale_one_tsum(T0sum(29)%cmp, -4)
  call scale_one_tsum(T0sum(30)%cmp, -4)
  call scale_one_tsum(T0sum(31)%cmp, -4)
  call scale_one_tsum(T0sum(32)%cmp, -4)
  call scale_one_tsum(T0sum(33)%cmp, -4)
  call scale_one_tsum(T0sum(34)%cmp, -4)
  call scale_one_tsum(T0sum(35)%cmp, -4)
  call scale_one_tsum(T0sum(36)%cmp, -4)
  call scale_one_tsum(T0sum(37)%cmp, -4)
  call scale_one_tsum(T0sum(38)%cmp, -4)
  call scale_one_tsum(T0sum(39)%cmp, -4)
  call scale_one_tsum(T0sum(40)%cmp, -4)
  call scale_one_tsum(T0sum(41)%cmp, -4)
  call scale_one_tsum(T0sum(42)%cmp, -4)
  call scale_one_tsum(T0sum(43)%cmp, -4)
  call scale_one_tsum(T0sum(44)%cmp, -4)
  call scale_one_tsum(T0sum(45)%cmp, -4)
  call scale_one_tsum(T0sum(46)%cmp, -4)
  call scale_one_tsum(T0sum(47)%cmp, -4)
  call scale_one_tsum(T0sum(48)%cmp, -4)
  call scale_one_tsum(T0sum(49)%cmp, -4)
  call scale_one_tsum(T0sum(50)%cmp, -4)
  call scale_one_tsum(T0sum(51)%cmp, -4)
  call scale_one_tsum(T0sum(52)%cmp, -4)
  call scale_one_tsum(T0sum(53)%cmp, -4)
  call scale_one_tsum(T0sum(54)%cmp, -4)
  call scale_one_tsum(T0sum(55)%cmp, -4)
  call scale_one_tsum(T0sum(56)%cmp, -4)
  call scale_one_tsum(T0sum(57)%cmp, -4)
  call scale_one_tsum(T0sum(58)%cmp, -4)
  call scale_one_tsum(T0sum(59)%cmp, -4)
  call scale_one_tsum(T0sum(60)%cmp, -4)
  call scale_one_tsum(T0sum(61)%cmp, -4)
  call scale_one_tsum(T0sum(62)%cmp, -4)
  call scale_one_tsum(T0sum(63)%cmp, -4)
  call scale_one_tsum(T0sum(64)%cmp, -4)
  call scale_one_tsum(T0sum(65)%cmp, -4)
  call scale_one_tsum(T0sum(66)%cmp, -4)
  call scale_one_tsum(T0sum(67)%cmp, -4)
  call scale_one_tsum(T0sum(68)%cmp, -4)
  call scale_one_tsum(T0sum(69)%cmp, -4)
  call scale_one_tsum(T0sum(70)%cmp, -4)
  call scale_one_tsum(T0sum(71)%cmp, -4)
  call scale_one_tsum(T0sum(72)%cmp, -4)
  call scale_one_tsum(T0sum(73)%cmp, -4)
  call scale_one_tsum(T0sum(74)%cmp, -4)
  call scale_one_tsum(T0sum(75)%cmp, -4)
  call scale_one_tsum(T0sum(76)%cmp, -4)
  call scale_one_tsum(T0sum(77)%cmp, -4)
  call scale_one_tsum(T0sum(78)%cmp, -4)
  call scale_one_tsum(T0sum(79)%cmp, -4)
  call scale_one_tsum(T0sum(80)%cmp, -4)
  call scale_one_tsum(T0sum(81)%cmp, -4)
  call scale_one_tsum(T0sum(82)%cmp, -4)
  call scale_one_tsum(T0sum(83)%cmp, -4)
  call scale_one_tsum(T0sum(84)%cmp, -4)
  call scale_one_tsum(T0sum(85)%cmp, -4)
  call scale_one_tsum(T0sum(86)%cmp, -4)
  call scale_one_tsum(T0sum(87)%cmp, -4)
  call scale_one_tsum(T0sum(88)%cmp, -4)
  call scale_one_tsum(T0sum(89)%cmp, -4)
  call scale_one_tsum(T0sum(90)%cmp, -4)
  call scale_one_tsum(T0sum(91)%cmp, -4)
  call scale_one_tsum(T0sum(92)%cmp, -4)
  call scale_one_tsum(T0sum(93)%cmp, -4)
  call scale_one_tsum(T0sum(94)%cmp, -4)
  call scale_one_tsum(T0sum(95)%cmp, -4)
  call scale_one_tsum(T0sum(96)%cmp, -4)
  call scale_one_tsum(T0sum(97)%cmp, -4)
  call scale_one_tsum(T0sum(98)%cmp, -4)
  call scale_one_tsum(T0sum(99)%cmp, -4)
  call scale_one_tsum(T0sum(100)%cmp, -4)
  call scale_one_tsum(T0sum(101)%cmp, -4)
  call scale_one_tsum(T0sum(102)%cmp, -4)
  call scale_one_tsum(T0sum(103)%cmp, -4)
  call scale_one_tsum(T0sum(104)%cmp, -4)
  call scale_one_tsum(T0sum(105)%cmp, -4)
  call scale_one_tsum(T0sum(106)%cmp, -4)
  call scale_one_tsum(T0sum(107)%cmp, -4)
  call scale_one_tsum(T0sum(108)%cmp, -4)
  call scale_one_tsum(T0sum(109)%cmp, -4)
  call scale_one_tsum(T0sum(110)%cmp, -4)
  call scale_one_tsum(T0sum(111)%cmp, -4)
  call scale_one_tsum(T0sum(112)%cmp, -4)
  call scale_one_tsum(T0sum(113)%cmp, -4)
  call scale_one_tsum(T0sum(114)%cmp, -4)
  call scale_one_tsum(T0sum(115)%cmp, -4)
  call scale_one_tsum(T0sum(116)%cmp, -4)
  call scale_one_tsum(T0sum(117)%cmp, -4)
  call scale_one_tsum(T0sum(118)%cmp, -4)
  call scale_one_tsum(T0sum(119)%cmp, -4)
  call scale_one_tsum(T0sum(120)%cmp, -4)
  call scale_one_tsum(T0sum(121)%cmp, -4)
  call scale_one_tsum(T0sum(122)%cmp, -4)
  call scale_one_tsum(T0sum(123)%cmp, -6)
  call scale_one_tsum(T0sum(124)%cmp, -6)
  call scale_one_tsum(T0sum(125)%cmp, -6)
  call scale_one_tsum(T0sum(126)%cmp, -6)
  call scale_one_tsum(T0sum(127)%cmp, -6)
  call scale_one_tsum(T0sum(128)%cmp, -6)
  call scale_one_tsum(T0sum(129)%cmp, -6)
  call scale_one_tsum(T0sum(130)%cmp, -6)
  call scale_one_tsum(T0sum(131)%cmp, -6)
  call scale_one_tsum(T0sum(132)%cmp, -6)
  call scale_one_tsum(T0sum(133)%cmp, -6)
  call scale_one_tsum(T0sum(134)%cmp, -6)
  call scale_one_tsum(T0sum(135)%cmp, -6)
  call scale_one_tsum(T0sum(136)%cmp, -6)
  call scale_one_tsum(T0sum(137)%cmp, -6)
  call scale_one_tsum(T0sum(138)%cmp, -6)
  call scale_one_tsum(T0sum(139)%cmp, -6)
  call scale_one_tsum(T0sum(140)%cmp, -6)
  call scale_one_tsum(T0sum(141)%cmp, -6)
  call scale_one_tsum(T0sum(142)%cmp, -6)
  call scale_one_tsum(T0sum(143)%cmp, -6)
  call scale_one_tsum(T0sum(144)%cmp, -6)
  call scale_one_tsum(T0sum(145)%cmp, -6)
  call scale_one_tsum(T0sum(146)%cmp, -6)
  call scale_one_tsum(T0sum(147)%cmp, -6)
  call scale_one_tsum(T0sum(148)%cmp, -6)
  call scale_one_tsum(T0sum(149)%cmp, -6)
  call scale_one_tsum(T0sum(150)%cmp, -6)
  call scale_one_tsum(T0sum(151)%cmp, -6)
  call scale_one_tsum(T0sum(152)%cmp, -6)
  call scale_one_tsum(T0sum(153)%cmp, -6)
  call scale_one_tsum(T0sum(154)%cmp, -6)
  call scale_one_tsum(T0sum(155)%cmp, -6)
  call scale_one_tsum(T0sum(156)%cmp, -6)
  call scale_one_tsum(T0sum(157)%cmp, -6)
  call scale_one_tsum(T0sum(158)%cmp, -6)
  call scale_one_tsum(T0sum(159)%cmp, -6)
  call scale_one_tsum(T0sum(160)%cmp, -6)
  call scale_one_tsum(T0sum(161)%cmp, -6)
  call scale_one_tsum(T0sum(162)%cmp, -6)
  call scale_one_tsum(T0sum(163)%cmp, -6)
  call scale_one_tsum(T0sum(164)%cmp, -6)
  call scale_one_tsum(T0sum(165)%cmp, -6)
  call scale_one_tsum(T0sum(166)%cmp, -6)
  call scale_one_tsum(T0sum(167)%cmp, -6)
  call scale_one_tsum(T0sum(168)%cmp, -6)
  call scale_one_tsum(T0sum(169)%cmp, -6)
  call scale_one_tsum(T0sum(170)%cmp, -6)
  call scale_one_tsum(T0sum(171)%cmp, -6)
  call scale_one_tsum(T0sum(172)%cmp, -6)
  call scale_one_tsum(T0sum(173)%cmp, -6)
  call scale_one_tsum(T0sum(174)%cmp, -6)
  call scale_one_tsum(T0sum(175)%cmp, -6)
  call scale_one_tsum(T0sum(176)%cmp, -6)
  call scale_one_tsum(T0sum(177)%cmp, -6)
  call scale_one_tsum(T0sum(178)%cmp, -6)
  call scale_one_tsum(T0sum(179)%cmp, -6)
  call scale_one_tsum(T0sum(180)%cmp, -6)
  call scale_one_tsum(T0sum(181)%cmp, -6)
  call scale_one_tsum(T0sum(182)%cmp, -6)
  call scale_one_tsum(T0sum(183)%cmp, -6)
  call scale_one_tsum(T0sum(184)%cmp, -6)
  call scale_one_tsum(T0sum(185)%cmp, -6)
  call scale_one_tsum(T0sum(186)%cmp, -6)
  call scale_one_tsum(T0sum(187)%cmp, -6)
  call scale_one_tsum(T0sum(188)%cmp, -6)
  call scale_one_tsum(T0sum(189)%cmp, -6)
  call scale_one_tsum(T0sum(190)%cmp, -6)
  call scale_one_tsum(T0sum(191)%cmp, -6)
  call scale_one_tsum(T0sum(192)%cmp, -6)
  call scale_one_tsum(T0sum(193)%cmp, -6)
  call scale_one_tsum(T0sum(194)%cmp, -6)
  call scale_one_tsum(T0sum(195)%cmp, -6)
  call scale_one_tsum(T0sum(196)%cmp, -6)
  call scale_one_tsum(T0sum(197)%cmp, -6)
  call scale_one_tsum(T0sum(198)%cmp, -6)
  call scale_one_tsum(T0sum(199)%cmp, -6)
  call scale_one_tsum(T0sum(200)%cmp, -6)
  call scale_one_tsum(T0sum(201)%cmp, -6)
  call scale_one_tsum(T0sum(202)%cmp, -6)
  call scale_one_tsum(T0sum(203)%cmp, -6)
  call scale_one_tsum(T0sum(204)%cmp, -6)
  call scale_one_tsum(T0sum(205)%cmp, -6)
  call scale_one_tsum(T0sum(206)%cmp, -6)
  call scale_one_tsum(T0sum(207)%cmp, -6)
  call scale_one_tsum(T0sum(208)%cmp, -6)
  call scale_one_tsum(T0sum(209)%cmp, -6)
  call scale_one_tsum(T0sum(210)%cmp, -6)
  call scale_one_tsum(T0sum(211)%cmp, -6)
  call scale_one_tsum(T0sum(212)%cmp, -6)
  call scale_one_tsum(T0sum(213)%cmp, -6)
  call scale_one_tsum(T0sum(214)%cmp, -6)
  call scale_one_tsum(T0sum(215)%cmp, -6)
  call scale_one_tsum(T0sum(216)%cmp, -6)
  call scale_one_tsum(T0sum(217)%cmp, -6)
  call scale_one_tsum(T0sum(218)%cmp, -6)
  call scale_one_tsum(T0sum(219)%cmp, -6)
  call scale_one_tsum(T0sum(220)%cmp, -6)
  call scale_one_tsum(T0sum(221)%cmp, -6)
  call scale_one_tsum(T0sum(222)%cmp, -6)
  call scale_one_tsum(T0sum(223)%cmp, -6)
  call scale_one_tsum(T0sum(224)%cmp, -6)
  call scale_one_tsum(T0sum(225)%cmp, -6)
  call scale_one_tsum(T0sum(226)%cmp, -6)
  call scale_one_tsum(T0sum(227)%cmp, -6)
  call scale_one_tsum(T0sum(228)%cmp, -6)
  call scale_one_tsum(T0sum(229)%cmp, -6)
  call scale_one_tsum(T0sum(230)%cmp, -6)
  call scale_one_tsum(T0sum(231)%cmp, -6)
  call scale_one_tsum(T0sum(232)%cmp, -6)
  call scale_one_tsum(T0sum(233)%cmp, -6)
  call scale_one_tsum(T0sum(234)%cmp, -8)
  call scale_one_tsum(T0sum(235)%cmp, -8)
  call scale_one_tsum(T0sum(236)%cmp, -8)
  call scale_one_tsum(T0sum(237)%cmp, -8)
  call scale_one_tsum(T0sum(238)%cmp, -8)
  call scale_one_tsum(T0sum(239)%cmp, -8)
  call scale_one_tsum(T0sum(240)%cmp, -8)
  call scale_one_tsum(T0sum(241)%cmp, -8)
  call scale_one_tsum(T0sum(242)%cmp, -8)
  call scale_one_tsum(T0sum(243)%cmp, -8)
  call scale_one_tsum(T0sum(244)%cmp, -8)
  call scale_one_tsum(T0sum(245)%cmp, -8)
  call scale_one_tsum(T0sum(246)%cmp, -8)
  call scale_one_tsum(T0sum(247)%cmp, -8)
  call scale_one_tsum(T0sum(248)%cmp, -8)
  call scale_one_tsum(T0sum(249)%cmp, -8)
  call scale_one_tsum(T0sum(250)%cmp, -8)
  call scale_one_tsum(T0sum(251)%cmp, -8)
  call scale_one_tsum(T0sum(252)%cmp, -8)
  call scale_one_tsum(T0sum(253)%cmp, -8)
  call scale_one_tsum(T0sum(254)%cmp, -8)
  call scale_one_tsum(T0sum(255)%cmp, -8)
  call scale_one_tsum(T0sum(256)%cmp, -8)
  call scale_one_tsum(T0sum(257)%cmp, -8)
  call scale_one_tsum(T0sum(258)%cmp, -8)
  call scale_one_tsum(T0sum(259)%cmp, -8)
  call scale_one_tsum(T0sum(260)%cmp, -8)
  call scale_one_tsum(T0sum(261)%cmp, -8)
  call scale_one_tsum(T0sum(262)%cmp, -8)
  call scale_one_tsum(T0sum(263)%cmp, -8)
  call scale_one_tsum(T0sum(264)%cmp, -8)
  call scale_one_tsum(T0sum(265)%cmp, -8)
  call scale_one_tsum(T0sum(266)%cmp, -8)
  call scale_one_tsum(T0sum(267)%cmp, -8)
  call scale_one_tsum(T0sum(268)%cmp, -8)
  call scale_one_tsum(T0sum(269)%cmp, -8)

end subroutine scale_tensor_sum

! **********************************************************************
subroutine set_integral_masses_and_momenta()
! **********************************************************************

  use ol_parameters_decl_/**/REALKIND
  momenta_1 = [ 0, 0 ]
  momenta_2 = [ 128, 127 ]
  momenta_3 = [ 133, 122 ]
  momenta_4 = [ 138, 117 ]
  momenta_5 = [ 144, 111 ]
  momenta_6 = [ 149, 106 ]
  momenta_7 = [ 154, 101 ]
  momenta_8 = [ 159, 96 ]
  momenta_9 = [ 160, 95 ]
  momenta_10 = [ 165, 90 ]
  momenta_11 = [ 170, 85 ]
  momenta_12 = [ 175, 80 ]
  momenta_13 = [ 181, 74 ]
  momenta_14 = [ 186, 69 ]
  momenta_15 = [ 191, 64 ]
  momenta_16 = [ 192, 63 ]
  momenta_17 = [ 197, 58 ]
  momenta_18 = [ 202, 53 ]
  momenta_19 = [ 207, 48 ]
  momenta_20 = [ 213, 42 ]
  momenta_21 = [ 218, 37 ]
  momenta_22 = [ 223, 32 ]
  momenta_23 = [ 229, 26 ]
  momenta_24 = [ 234, 21 ]
  momenta_25 = [ 239, 16 ]
  momenta_26 = [ 245, 10 ]
  momenta_27 = [ 250, 5 ]
  momenta_28 = [ 128, 5, 122 ]
  momenta_29 = [ 128, 10, 117 ]
  momenta_30 = [ 128, 16, 111 ]
  momenta_31 = [ 128, 21, 106 ]
  momenta_32 = [ 128, 26, 101 ]
  momenta_33 = [ 128, 32, 95 ]
  momenta_34 = [ 128, 37, 90 ]
  momenta_35 = [ 128, 42, 85 ]
  momenta_36 = [ 128, 53, 74 ]
  momenta_37 = [ 128, 58, 69 ]
  momenta_38 = [ 128, 63, 64 ]
  momenta_39 = [ 128, 85, 42 ]
  momenta_40 = [ 128, 90, 37 ]
  momenta_41 = [ 128, 95, 32 ]
  momenta_42 = [ 128, 101, 26 ]
  momenta_43 = [ 128, 106, 21 ]
  momenta_44 = [ 128, 111, 16 ]
  momenta_45 = [ 133, 16, 106 ]
  momenta_46 = [ 133, 26, 96 ]
  momenta_47 = [ 133, 32, 90 ]
  momenta_48 = [ 133, 48, 74 ]
  momenta_49 = [ 133, 58, 64 ]
  momenta_50 = [ 133, 80, 42 ]
  momenta_51 = [ 133, 90, 32 ]
  momenta_52 = [ 133, 96, 26 ]
  momenta_53 = [ 133, 106, 16 ]
  momenta_54 = [ 138, 16, 101 ]
  momenta_55 = [ 138, 21, 96 ]
  momenta_56 = [ 138, 32, 85 ]
  momenta_57 = [ 138, 48, 69 ]
  momenta_58 = [ 138, 53, 64 ]
  momenta_59 = [ 138, 80, 37 ]
  momenta_60 = [ 138, 85, 32 ]
  momenta_61 = [ 138, 96, 21 ]
  momenta_62 = [ 138, 101, 16 ]
  momenta_63 = [ 144, 5, 106 ]
  momenta_64 = [ 144, 10, 101 ]
  momenta_65 = [ 144, 37, 74 ]
  momenta_66 = [ 144, 42, 69 ]
  momenta_67 = [ 144, 69, 42 ]
  momenta_68 = [ 144, 74, 37 ]
  momenta_69 = [ 144, 101, 10 ]
  momenta_70 = [ 144, 106, 5 ]
  momenta_71 = [ 149, 10, 96 ]
  momenta_72 = [ 149, 32, 74 ]
  momenta_73 = [ 149, 42, 64 ]
  momenta_74 = [ 149, 64, 42 ]
  momenta_75 = [ 149, 74, 32 ]
  momenta_76 = [ 149, 96, 10 ]
  momenta_77 = [ 154, 5, 96 ]
  momenta_78 = [ 154, 32, 69 ]
  momenta_79 = [ 154, 37, 64 ]
  momenta_80 = [ 154, 64, 37 ]
  momenta_81 = [ 154, 69, 32 ]
  momenta_82 = [ 154, 96, 5 ]
  momenta_83 = [ 159, 32, 64 ]
  momenta_84 = [ 159, 64, 32 ]
  momenta_85 = [ 160, 5, 90 ]
  momenta_86 = [ 160, 10, 85 ]
  momenta_87 = [ 160, 21, 74 ]
  momenta_88 = [ 160, 26, 69 ]
  momenta_89 = [ 160, 85, 10 ]
  momenta_90 = [ 160, 90, 5 ]
  momenta_91 = [ 165, 10, 80 ]
  momenta_92 = [ 165, 16, 74 ]
  momenta_93 = [ 165, 26, 64 ]
  momenta_94 = [ 165, 64, 26 ]
  momenta_95 = [ 165, 74, 16 ]
  momenta_96 = [ 165, 80, 10 ]
  momenta_97 = [ 170, 5, 80 ]
  momenta_98 = [ 170, 16, 69 ]
  momenta_99 = [ 170, 21, 64 ]
  momenta_100 = [ 170, 64, 21 ]
  momenta_101 = [ 170, 69, 16 ]
  momenta_102 = [ 170, 80, 5 ]
  momenta_103 = [ 175, 16, 64 ]
  momenta_104 = [ 175, 64, 16 ]
  momenta_105 = [ 181, 10, 64 ]
  momenta_106 = [ 181, 64, 10 ]
  momenta_107 = [ 186, 5, 64 ]
  momenta_108 = [ 186, 64, 5 ]
  momenta_109 = [ 192, 5, 58 ]
  momenta_110 = [ 192, 10, 53 ]
  momenta_111 = [ 192, 21, 42 ]
  momenta_112 = [ 192, 26, 37 ]
  momenta_113 = [ 192, 37, 26 ]
  momenta_114 = [ 192, 42, 21 ]
  momenta_115 = [ 192, 53, 10 ]
  momenta_116 = [ 192, 58, 5 ]
  momenta_117 = [ 197, 10, 48 ]
  momenta_118 = [ 197, 16, 42 ]
  momenta_119 = [ 197, 26, 32 ]
  momenta_120 = [ 197, 32, 26 ]
  momenta_121 = [ 197, 42, 16 ]
  momenta_122 = [ 197, 48, 10 ]
  momenta_123 = [ 202, 5, 48 ]
  momenta_124 = [ 202, 16, 37 ]
  momenta_125 = [ 202, 21, 32 ]
  momenta_126 = [ 202, 32, 21 ]
  momenta_127 = [ 202, 37, 16 ]
  momenta_128 = [ 202, 48, 5 ]
  momenta_129 = [ 207, 16, 32 ]
  momenta_130 = [ 207, 32, 16 ]
  momenta_131 = [ 213, 10, 32 ]
  momenta_132 = [ 213, 32, 10 ]
  momenta_133 = [ 218, 5, 32 ]
  momenta_134 = [ 218, 32, 5 ]
  momenta_135 = [ 229, 10, 16 ]
  momenta_136 = [ 229, 16, 10 ]
  momenta_137 = [ 234, 5, 16 ]
  momenta_138 = [ 234, 16, 5 ]
  momenta_139 = [ 128, 5, 16, 106 ]
  momenta_140 = [ 128, 5, 32, 90 ]
  momenta_141 = [ 128, 5, 48, 74 ]
  momenta_142 = [ 128, 5, 58, 64 ]
  momenta_143 = [ 128, 5, 80, 42 ]
  momenta_144 = [ 128, 5, 90, 32 ]
  momenta_145 = [ 128, 5, 96, 26 ]
  momenta_146 = [ 128, 5, 106, 16 ]
  momenta_147 = [ 128, 10, 16, 101 ]
  momenta_148 = [ 128, 10, 32, 85 ]
  momenta_149 = [ 128, 10, 48, 69 ]
  momenta_150 = [ 128, 10, 53, 64 ]
  momenta_151 = [ 128, 10, 80, 37 ]
  momenta_152 = [ 128, 10, 85, 32 ]
  momenta_153 = [ 128, 10, 96, 21 ]
  momenta_154 = [ 128, 10, 101, 16 ]
  momenta_155 = [ 128, 16, 5, 106 ]
  momenta_156 = [ 128, 16, 10, 101 ]
  momenta_157 = [ 128, 16, 69, 42 ]
  momenta_158 = [ 128, 16, 74, 37 ]
  momenta_159 = [ 128, 21, 32, 74 ]
  momenta_160 = [ 128, 21, 42, 64 ]
  momenta_161 = [ 128, 21, 64, 42 ]
  momenta_162 = [ 128, 21, 74, 32 ]
  momenta_163 = [ 128, 26, 32, 69 ]
  momenta_164 = [ 128, 26, 37, 64 ]
  momenta_165 = [ 128, 26, 64, 37 ]
  momenta_166 = [ 128, 26, 69, 32 ]
  momenta_167 = [ 128, 32, 5, 90 ]
  momenta_168 = [ 128, 32, 10, 85 ]
  momenta_169 = [ 128, 37, 16, 74 ]
  momenta_170 = [ 128, 37, 26, 64 ]
  momenta_171 = [ 128, 37, 64, 26 ]
  momenta_172 = [ 128, 37, 74, 16 ]
  momenta_173 = [ 128, 42, 16, 69 ]
  momenta_174 = [ 128, 42, 21, 64 ]
  momenta_175 = [ 128, 42, 64, 21 ]
  momenta_176 = [ 128, 42, 69, 16 ]
  momenta_177 = [ 128, 53, 10, 64 ]
  momenta_178 = [ 128, 58, 5, 64 ]
  momenta_179 = [ 128, 85, 10, 32 ]
  momenta_180 = [ 128, 90, 5, 32 ]
  momenta_181 = [ 128, 101, 10, 16 ]
  momenta_182 = [ 128, 106, 5, 16 ]
  momenta_183 = [ 133, 16, 10, 96 ]
  momenta_184 = [ 133, 16, 32, 74 ]
  momenta_185 = [ 133, 16, 42, 64 ]
  momenta_186 = [ 133, 16, 64, 42 ]
  momenta_187 = [ 133, 16, 74, 32 ]
  momenta_188 = [ 133, 26, 64, 32 ]
  momenta_189 = [ 133, 32, 16, 74 ]
  momenta_190 = [ 133, 32, 26, 64 ]
  momenta_191 = [ 133, 32, 64, 26 ]
  momenta_192 = [ 133, 32, 74, 16 ]
  momenta_193 = [ 133, 48, 10, 64 ]
  momenta_194 = [ 133, 80, 10, 32 ]
  momenta_195 = [ 133, 96, 10, 16 ]
  momenta_196 = [ 138, 16, 5, 96 ]
  momenta_197 = [ 138, 16, 32, 69 ]
  momenta_198 = [ 138, 16, 37, 64 ]
  momenta_199 = [ 138, 16, 64, 37 ]
  momenta_200 = [ 138, 16, 69, 32 ]
  momenta_201 = [ 138, 21, 64, 32 ]
  momenta_202 = [ 138, 32, 16, 69 ]
  momenta_203 = [ 138, 32, 21, 64 ]
  momenta_204 = [ 138, 32, 64, 21 ]
  momenta_205 = [ 138, 32, 69, 16 ]
  momenta_206 = [ 138, 48, 5, 64 ]
  momenta_207 = [ 138, 80, 5, 32 ]
  momenta_208 = [ 138, 96, 5, 16 ]
  momenta_209 = [ 144, 5, 32, 74 ]
  momenta_210 = [ 144, 5, 64, 42 ]
  momenta_211 = [ 144, 5, 96, 10 ]
  momenta_212 = [ 144, 10, 32, 69 ]
  momenta_213 = [ 144, 10, 64, 37 ]
  momenta_214 = [ 144, 10, 96, 5 ]
  momenta_215 = [ 144, 37, 64, 10 ]
  momenta_216 = [ 144, 42, 64, 5 ]
  momenta_217 = [ 149, 10, 32, 64 ]
  momenta_218 = [ 149, 10, 64, 32 ]
  momenta_219 = [ 149, 32, 10, 64 ]
  momenta_220 = [ 149, 32, 64, 10 ]
  momenta_221 = [ 149, 64, 10, 32 ]
  momenta_222 = [ 154, 5, 32, 64 ]
  momenta_223 = [ 154, 5, 64, 32 ]
  momenta_224 = [ 154, 32, 5, 64 ]
  momenta_225 = [ 154, 32, 64, 5 ]
  momenta_226 = [ 154, 64, 5, 32 ]
  momenta_227 = [ 160, 5, 16, 74 ]
  momenta_228 = [ 160, 5, 80, 10 ]
  momenta_229 = [ 160, 10, 16, 69 ]
  momenta_230 = [ 160, 10, 80, 5 ]
  momenta_231 = [ 160, 21, 64, 10 ]
  momenta_232 = [ 160, 26, 64, 5 ]
  momenta_233 = [ 165, 10, 16, 64 ]
  momenta_234 = [ 165, 10, 64, 16 ]
  momenta_235 = [ 165, 16, 10, 64 ]
  momenta_236 = [ 165, 16, 64, 10 ]
  momenta_237 = [ 165, 64, 10, 16 ]
  momenta_238 = [ 170, 5, 16, 64 ]
  momenta_239 = [ 170, 5, 64, 16 ]
  momenta_240 = [ 170, 16, 5, 64 ]
  momenta_241 = [ 170, 16, 64, 5 ]
  momenta_242 = [ 170, 64, 5, 16 ]
  momenta_243 = [ 192, 5, 16, 42 ]
  momenta_244 = [ 192, 5, 32, 26 ]
  momenta_245 = [ 192, 5, 48, 10 ]
  momenta_246 = [ 192, 10, 16, 37 ]
  momenta_247 = [ 192, 10, 32, 21 ]
  momenta_248 = [ 192, 10, 48, 5 ]
  momenta_249 = [ 192, 21, 32, 10 ]
  momenta_250 = [ 192, 26, 32, 5 ]
  momenta_251 = [ 192, 37, 16, 10 ]
  momenta_252 = [ 192, 42, 16, 5 ]
  momenta_253 = [ 197, 10, 16, 32 ]
  momenta_254 = [ 197, 10, 32, 16 ]
  momenta_255 = [ 197, 16, 32, 10 ]
  momenta_256 = [ 197, 32, 16, 10 ]
  momenta_257 = [ 202, 5, 16, 32 ]
  momenta_258 = [ 202, 5, 32, 16 ]
  momenta_259 = [ 202, 16, 32, 5 ]
  momenta_260 = [ 202, 32, 16, 5 ]
  momenta_261 = [ 128, 5, 16, 32, 74 ]
  momenta_262 = [ 128, 5, 16, 42, 64 ]
  momenta_263 = [ 128, 5, 16, 64, 42 ]
  momenta_264 = [ 128, 5, 16, 74, 32 ]
  momenta_265 = [ 128, 5, 32, 16, 74 ]
  momenta_266 = [ 128, 5, 32, 26, 64 ]
  momenta_267 = [ 128, 5, 32, 64, 26 ]
  momenta_268 = [ 128, 5, 32, 74, 16 ]
  momenta_269 = [ 128, 5, 48, 10, 64 ]
  momenta_270 = [ 128, 5, 80, 10, 32 ]
  momenta_271 = [ 128, 5, 96, 10, 16 ]
  momenta_272 = [ 128, 10, 16, 32, 69 ]
  momenta_273 = [ 128, 10, 16, 37, 64 ]
  momenta_274 = [ 128, 10, 16, 64, 37 ]
  momenta_275 = [ 128, 10, 16, 69, 32 ]
  momenta_276 = [ 128, 10, 32, 16, 69 ]
  momenta_277 = [ 128, 10, 32, 21, 64 ]
  momenta_278 = [ 128, 10, 32, 64, 21 ]
  momenta_279 = [ 128, 10, 32, 69, 16 ]
  momenta_280 = [ 128, 10, 48, 5, 64 ]
  momenta_281 = [ 128, 10, 80, 5, 32 ]
  momenta_282 = [ 128, 10, 96, 5, 16 ]
  momenta_283 = [ 128, 16, 5, 64, 42 ]
  momenta_284 = [ 128, 16, 10, 64, 37 ]
  momenta_285 = [ 128, 21, 32, 10, 64 ]
  momenta_286 = [ 128, 21, 64, 10, 32 ]
  momenta_287 = [ 128, 26, 32, 5, 64 ]
  momenta_288 = [ 128, 26, 64, 5, 32 ]
  momenta_289 = [ 128, 37, 16, 10, 64 ]
  momenta_290 = [ 128, 37, 64, 10, 16 ]
  momenta_291 = [ 128, 42, 16, 5, 64 ]
  momenta_292 = [ 128, 42, 64, 5, 16 ]
  momenta_293 = [ 133, 16, 10, 64, 32 ]
  momenta_294 = [ 133, 16, 32, 10, 64 ]
  momenta_295 = [ 133, 16, 64, 10, 32 ]
  momenta_296 = [ 133, 32, 16, 10, 64 ]
  momenta_297 = [ 133, 32, 64, 10, 16 ]
  momenta_298 = [ 138, 16, 5, 64, 32 ]
  momenta_299 = [ 138, 16, 32, 5, 64 ]
  momenta_300 = [ 138, 16, 64, 5, 32 ]
  momenta_301 = [ 138, 32, 16, 5, 64 ]
  momenta_302 = [ 138, 32, 64, 5, 16 ]
  momenta_303 = [ 144, 5, 32, 64, 10 ]
  momenta_304 = [ 144, 10, 32, 64, 5 ]
  momenta_305 = [ 160, 5, 16, 64, 10 ]
  momenta_306 = [ 160, 10, 16, 64, 5 ]
  momenta_307 = [ 192, 5, 16, 32, 10 ]
  momenta_308 = [ 192, 5, 32, 16, 10 ]
  momenta_309 = [ 192, 10, 16, 32, 5 ]
  momenta_310 = [ 192, 10, 32, 16, 5 ]
  momenta_311 = [ 128, 5, 16, 32, 10, 64 ]
  momenta_312 = [ 128, 5, 16, 64, 10, 32 ]
  momenta_313 = [ 128, 5, 32, 16, 10, 64 ]
  momenta_314 = [ 128, 5, 32, 64, 10, 16 ]
  momenta_315 = [ 128, 10, 16, 32, 5, 64 ]
  momenta_316 = [ 128, 10, 16, 64, 5, 32 ]
  momenta_317 = [ 128, 10, 32, 16, 5, 64 ]
  momenta_318 = [ 128, 10, 32, 64, 5, 16 ]

  masses2_1 = [ 0, 0 ]
  masses2_2 = [ nMB, 0 ]
  masses2_3 = [ nMT, 0 ]
  masses2_4 = [ nMB, nMB ]
  masses2_5 = [ nMT, nMT ]
  masses2_6 = [ 0, 0, 0 ]
  masses2_7 = [ 0, 0, 0, 0 ]
  masses2_8 = [ 0, 0, 0, 0, 0 ]
  masses2_9 = [ 0, 0, 0, 0, 0, 0 ]


end subroutine  set_integral_masses_and_momenta

! **********************************************************************
subroutine integrate_tensor_sum(M2out)
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! only: ZERO, masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: a_switch
#endif
  use ol_parameters_init_/**/REALKIND, only: init_met, add_met, met_to_real
  use ol_loop_routines_/**/REALKIND, only: TI_call_OL
  implicit none
  real(REALKIND), intent(out) :: M2out
  type(met) :: M2
  call init_met(M2)

sbarray_1 = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
sbarray_2 = [16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30]
sbarray_3 = [31, 2, 32, 33, 34, 6, 35, 36, 37, 10, 11, 12, 38, 39, 40]
sbarray_4 = [41, 17, 42, 43, 44, 21, 45, 46, 47, 25, 26, 27, 48, 49, 50]
sbarray_5 = [51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 28, 63, 64]
sbarray_6 = [65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 38, 77, 78]
sbarray_7 = [79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 13, 91, 92]
sbarray_8 = [93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 48, 105, 106]
sbarray_9 = [107, 108, 109, 110, 15]
sbarray_10 = [1, 2, 3, 4, 5]
sbarray_11 = [1, 6, 7, 8, 9]
sbarray_12 = [2, 6, 10, 11, 12]
sbarray_13 = [3, 7, 10, 13, 14]
sbarray_14 = [111, 112, 113, 114, 30]
sbarray_15 = [16, 17, 18, 19, 20]
sbarray_16 = [16, 21, 22, 23, 24]
sbarray_17 = [17, 21, 25, 26, 27]
sbarray_18 = [18, 22, 25, 28, 29]
sbarray_19 = [115, 116, 109, 117, 40]
sbarray_20 = [31, 2, 32, 33, 34]
sbarray_21 = [31, 6, 35, 36, 37]
sbarray_22 = [32, 35, 10, 38, 39]
sbarray_23 = [118, 119, 113, 120, 50]
sbarray_24 = [41, 17, 42, 43, 44]
sbarray_25 = [41, 21, 45, 46, 47]
sbarray_26 = [42, 45, 25, 48, 49]
sbarray_27 = [121, 122, 123, 124, 64]
sbarray_28 = [51, 52, 53, 54, 55]
sbarray_29 = [51, 56, 57, 58, 59]
sbarray_30 = [52, 56, 60, 61, 62]
sbarray_31 = [53, 57, 60, 28, 63]
sbarray_32 = [125, 126, 127, 128, 78]
sbarray_33 = [65, 66, 67, 68, 69]
sbarray_34 = [65, 70, 71, 72, 73]
sbarray_35 = [66, 70, 74, 75, 76]
sbarray_36 = [67, 71, 74, 38, 77]
sbarray_37 = [129, 130, 131, 132, 92]
sbarray_38 = [79, 80, 81, 82, 83]
sbarray_39 = [79, 84, 85, 86, 87]
sbarray_40 = [80, 84, 88, 89, 90]
sbarray_41 = [81, 85, 88, 13, 91]
sbarray_42 = [133, 134, 135, 136, 106]
sbarray_43 = [93, 94, 95, 96, 97]
sbarray_44 = [93, 98, 99, 100, 101]
sbarray_45 = [94, 98, 102, 103, 104]
sbarray_46 = [95, 99, 102, 48, 105]
sbarray_47 = [82, 86, 89, 13, 92]
sbarray_48 = [68, 72, 75, 38, 78]
sbarray_49 = [33, 36, 11, 38, 40]
sbarray_50 = [4, 8, 11, 13, 15]
sbarray_51 = [96, 100, 103, 48, 106]
sbarray_52 = [54, 58, 61, 28, 64]
sbarray_53 = [19, 23, 26, 28, 30]
sbarray_54 = [43, 46, 26, 48, 50]
sbarray_55 = [137, 72, 138, 139, 140]
sbarray_56 = [141, 142, 53, 143, 140]
sbarray_57 = [144, 58, 145, 146, 147]
sbarray_58 = [148, 149, 67, 150, 147]


#ifdef LOOPSQUARED
  if (a_switch == 1 .or. a_switch == 7) then
#endif
  call TI_call_OL(0,0, momenta_247, masses2_7, T0sum(1), M2,[110], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_148, masses2_7, T0sum(2), M2,[13], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_243, masses2_7, T0sum(3), M2,[114], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_139, masses2_7, T0sum(4), M2,[28], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_246, masses2_7, T0sum(5), M2,[117], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_147, masses2_7, T0sum(6), M2,[38], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_244, masses2_7, T0sum(7), M2,[120], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_140, masses2_7, T0sum(8), M2,[48], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_227, masses2_7, T0sum(9), M2,[124], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_229, masses2_7, T0sum(10), M2,[128], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_212, masses2_7, T0sum(11), M2,[132], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_209, masses2_7, T0sum(12), M2,[136], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_149, masses2_7, T0sum(13), M2,[11], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_141, masses2_7, T0sum(14), M2,[26], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_143, masses2_7, T0sum(15), M2,[61], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_151, masses2_7, T0sum(16), M2,[75], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_153, masses2_7, T0sum(17), M2,[89], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_145, masses2_7, T0sum(18), M2,[103], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_202, masses2_7, T0sum(19), M2,[4], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_173, masses2_7, T0sum(20), M2,[8], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_184, masses2_7, T0sum(21), M2,[19], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_159, masses2_7, T0sum(22), M2,[23], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_197, masses2_7, T0sum(23), M2,[33], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_163, masses2_7, T0sum(24), M2,[36], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_189, masses2_7, T0sum(25), M2,[43], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_169, masses2_7, T0sum(26), M2,[46], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_186, masses2_7, T0sum(27), M2,[54], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_161, masses2_7, T0sum(28), M2,[58], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_199, masses2_7, T0sum(29), M2,[68], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_165, masses2_7, T0sum(30), M2,[72], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_204, masses2_7, T0sum(31), M2,[82], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_175, masses2_7, T0sum(32), M2,[86], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_191, masses2_7, T0sum(33), M2,[96], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_171, masses2_7, T0sum(34), M2,[100], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_254, masses2_7, T0sum(35), M2,[15], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_257, masses2_7, T0sum(36), M2,[30], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_253, masses2_7, T0sum(37), M2,[40], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_258, masses2_7, T0sum(38), M2,[50], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_238, masses2_7, T0sum(39), M2,[64], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_233, masses2_7, T0sum(40), M2,[78], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_217, masses2_7, T0sum(41), M2,[92], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_222, masses2_7, T0sum(42), M2,[106], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_235, masses2_7, T0sum(43), M2,[41], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_156, masses2_7, T0sum(44), M2,[139], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_183, masses2_7, T0sum(45), M2,[143], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_240, masses2_7, T0sum(46), M2,[1], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_155, masses2_7, T0sum(47), M2,[146], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_196, masses2_7, T0sum(48), M2,[150], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_260, masses2_7, T0sum(49), M2,[107], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_252, masses2_7, T0sum(50), M2,[108], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_248, masses2_7, T0sum(51), M2,[109], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_206, masses2_7, T0sum(52), M2,[2], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_203, masses2_7, T0sum(53), M2,[3], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_178, masses2_7, T0sum(54), M2,[6], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_174, masses2_7, T0sum(55), M2,[7], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_150, masses2_7, T0sum(56), M2,[10], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_255, masses2_7, T0sum(57), M2,[111], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_249, masses2_7, T0sum(58), M2,[112], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_245, masses2_7, T0sum(59), M2,[113], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_219, masses2_7, T0sum(60), M2,[16], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_193, masses2_7, T0sum(61), M2,[17], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_185, masses2_7, T0sum(62), M2,[18], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_177, masses2_7, T0sum(63), M2,[21], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_160, masses2_7, T0sum(64), M2,[22], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_142, masses2_7, T0sum(65), M2,[25], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_259, masses2_7, T0sum(66), M2,[115], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_250, masses2_7, T0sum(67), M2,[116], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_224, masses2_7, T0sum(68), M2,[31], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_198, masses2_7, T0sum(69), M2,[32], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_164, masses2_7, T0sum(70), M2,[35], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_256, masses2_7, T0sum(71), M2,[118], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_251, masses2_7, T0sum(72), M2,[119], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_190, masses2_7, T0sum(73), M2,[42], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_170, masses2_7, T0sum(74), M2,[45], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_236, masses2_7, T0sum(75), M2,[121], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_231, masses2_7, T0sum(76), M2,[122], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_228, masses2_7, T0sum(77), M2,[123], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_221, masses2_7, T0sum(78), M2,[51], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_194, masses2_7, T0sum(79), M2,[52], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_187, masses2_7, T0sum(80), M2,[53], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_179, masses2_7, T0sum(81), M2,[56], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_162, masses2_7, T0sum(82), M2,[57], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_144, masses2_7, T0sum(83), M2,[60], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_241, masses2_7, T0sum(84), M2,[125], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_232, masses2_7, T0sum(85), M2,[126], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_230, masses2_7, T0sum(86), M2,[127], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_226, masses2_7, T0sum(87), M2,[65], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_207, masses2_7, T0sum(88), M2,[66], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_200, masses2_7, T0sum(89), M2,[67], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_180, masses2_7, T0sum(90), M2,[70], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_166, masses2_7, T0sum(91), M2,[71], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_152, masses2_7, T0sum(92), M2,[74], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_225, masses2_7, T0sum(93), M2,[129], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_216, masses2_7, T0sum(94), M2,[130], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_214, masses2_7, T0sum(95), M2,[131], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_242, masses2_7, T0sum(96), M2,[79], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_208, masses2_7, T0sum(97), M2,[80], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_205, masses2_7, T0sum(98), M2,[81], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_182, masses2_7, T0sum(99), M2,[84], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_176, masses2_7, T0sum(100), M2,[85], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_154, masses2_7, T0sum(101), M2,[88], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_220, masses2_7, T0sum(102), M2,[133], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_215, masses2_7, T0sum(103), M2,[134], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_211, masses2_7, T0sum(104), M2,[135], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_237, masses2_7, T0sum(105), M2,[93], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_195, masses2_7, T0sum(106), M2,[94], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_192, masses2_7, T0sum(107), M2,[95], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_181, masses2_7, T0sum(108), M2,[98], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_172, masses2_7, T0sum(109), M2,[99], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_146, masses2_7, T0sum(110), M2,[102], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_213, masses2_7, T0sum(111), M2,[137], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_158, masses2_7, T0sum(112), M2,[138], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_218, masses2_7, T0sum(113), M2,[141], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_188, masses2_7, T0sum(114), M2,[142], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_210, masses2_7, T0sum(115), M2,[144], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_157, masses2_7, T0sum(116), M2,[145], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_223, masses2_7, T0sum(117), M2,[148], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_201, masses2_7, T0sum(118), M2,[149], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_168, masses2_7, T0sum(119), M2,[56], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_234, masses2_7, T0sum(120), M2,[121], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_167, masses2_7, T0sum(121), M2,[70], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_239, masses2_7, T0sum(122), M2,[125], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_98, masses2_6, T0sum(123), M2)
  call TI_call_OL(0,0, momenta_72, masses2_6, T0sum(124), M2)
  call TI_call_OL(0,0, momenta_78, masses2_6, T0sum(125), M2)
  call TI_call_OL(0,0, momenta_92, masses2_6, T0sum(126), M2)
  call TI_call_OL(0,0, momenta_29, masses2_6, T0sum(127), M2)
  call TI_call_OL(0,0, momenta_28, masses2_6, T0sum(128), M2)
  call TI_call_OL(0,0, momenta_131, masses2_6, T0sum(129), M2)
  call TI_call_OL(0,0, momenta_71, masses2_6, T0sum(130), M2)
  call TI_call_OL(0,0, momenta_135, masses2_6, T0sum(131), M2)
  call TI_call_OL(0,0, momenta_91, masses2_6, T0sum(132), M2)
  call TI_call_OL(0,0, momenta_133, masses2_6, T0sum(133), M2)
  call TI_call_OL(0,0, momenta_77, masses2_6, T0sum(134), M2)
  call TI_call_OL(0,0, momenta_137, masses2_6, T0sum(135), M2)
  call TI_call_OL(0,0, momenta_97, masses2_6, T0sum(136), M2)
  call TI_call_OL(0,0, momenta_105, masses2_6, T0sum(137), M2)
  call TI_call_OL(0,0, momenta_107, masses2_6, T0sum(138), M2)
  call TI_call_OL(0,0, momenta_132, masses2_6, T0sum(139), M2)
  call TI_call_OL(0,0, momenta_33, masses2_6, T0sum(140), M2)
  call TI_call_OL(0,0, momenta_136, masses2_6, T0sum(141), M2)
  call TI_call_OL(0,0, momenta_30, masses2_6, T0sum(142), M2)
  call TI_call_OL(0,0, momenta_134, masses2_6, T0sum(143), M2)
  call TI_call_OL(0,0, momenta_138, masses2_6, T0sum(144), M2)
  call TI_call_OL(0,0, momenta_126, masses2_6, T0sum(145), M2)
  call TI_call_OL(0,0, momenta_114, masses2_6, T0sum(146), M2)
  call TI_call_OL(0,0, momenta_110, masses2_6, T0sum(147), M2)
  call TI_call_OL(0,0, momenta_56, masses2_6, T0sum(148), M2)
  call TI_call_OL(0,0, momenta_35, masses2_6, T0sum(149), M2)
  call TI_call_OL(0,0, momenta_118, masses2_6, T0sum(150), M2)
  call TI_call_OL(0,0, momenta_111, masses2_6, T0sum(151), M2)
  call TI_call_OL(0,0, momenta_109, masses2_6, T0sum(152), M2)
  call TI_call_OL(0,0, momenta_45, masses2_6, T0sum(153), M2)
  call TI_call_OL(0,0, momenta_31, masses2_6, T0sum(154), M2)
  call TI_call_OL(0,0, momenta_124, masses2_6, T0sum(155), M2)
  call TI_call_OL(0,0, momenta_112, masses2_6, T0sum(156), M2)
  call TI_call_OL(0,0, momenta_54, masses2_6, T0sum(157), M2)
  call TI_call_OL(0,0, momenta_32, masses2_6, T0sum(158), M2)
  call TI_call_OL(0,0, momenta_120, masses2_6, T0sum(159), M2)
  call TI_call_OL(0,0, momenta_113, masses2_6, T0sum(160), M2)
  call TI_call_OL(0,0, momenta_47, masses2_6, T0sum(161), M2)
  call TI_call_OL(0,0, momenta_34, masses2_6, T0sum(162), M2)
  call TI_call_OL(0,0, momenta_87, masses2_6, T0sum(163), M2)
  call TI_call_OL(0,0, momenta_85, masses2_6, T0sum(164), M2)
  call TI_call_OL(0,0, momenta_88, masses2_6, T0sum(165), M2)
  call TI_call_OL(0,0, momenta_86, masses2_6, T0sum(166), M2)
  call TI_call_OL(0,0, momenta_66, masses2_6, T0sum(167), M2)
  call TI_call_OL(0,0, momenta_64, masses2_6, T0sum(168), M2)
  call TI_call_OL(0,0, momenta_65, masses2_6, T0sum(169), M2)
  call TI_call_OL(0,0, momenta_63, masses2_6, T0sum(170), M2)
  call TI_call_OL(0,0, momenta_117, masses2_6, T0sum(171), M2)
  call TI_call_OL(0,0, momenta_57, masses2_6, T0sum(172), M2)
  call TI_call_OL(0,0, momenta_37, masses2_6, T0sum(173), M2)
  call TI_call_OL(0,0, momenta_123, masses2_6, T0sum(174), M2)
  call TI_call_OL(0,0, momenta_48, masses2_6, T0sum(175), M2)
  call TI_call_OL(0,0, momenta_36, masses2_6, T0sum(176), M2)
  call TI_call_OL(0,0, momenta_50, masses2_6, T0sum(177), M2)
  call TI_call_OL(0,0, momenta_39, masses2_6, T0sum(178), M2)
  call TI_call_OL(0,0, momenta_59, masses2_6, T0sum(179), M2)
  call TI_call_OL(0,0, momenta_40, masses2_6, T0sum(180), M2)
  call TI_call_OL(0,0, momenta_61, masses2_6, T0sum(181), M2)
  call TI_call_OL(0,0, momenta_43, masses2_6, T0sum(182), M2)
  call TI_call_OL(0,0, momenta_52, masses2_6, T0sum(183), M2)
  call TI_call_OL(0,0, momenta_42, masses2_6, T0sum(184), M2)
  call TI_call_OL(0,0, momenta_130, masses2_6, T0sum(185), M2)
  call TI_call_OL(0,0, momenta_121, masses2_6, T0sum(186), M2)
  call TI_call_OL(0,0, momenta_129, masses2_6, T0sum(187), M2)
  call TI_call_OL(0,0, momenta_125, masses2_6, T0sum(188), M2)
  call TI_call_OL(0,0, momenta_119, masses2_6, T0sum(189), M2)
  call TI_call_OL(0,0, momenta_127, masses2_6, T0sum(190), M2)
  call TI_call_OL(0,0, momenta_103, masses2_6, T0sum(191), M2)
  call TI_call_OL(0,0, momenta_74, masses2_6, T0sum(192), M2)
  call TI_call_OL(0,0, momenta_99, masses2_6, T0sum(193), M2)
  call TI_call_OL(0,0, momenta_80, masses2_6, T0sum(194), M2)
  call TI_call_OL(0,0, momenta_93, masses2_6, T0sum(195), M2)
  call TI_call_OL(0,0, momenta_83, masses2_6, T0sum(196), M2)
  call TI_call_OL(0,0, momenta_100, masses2_6, T0sum(197), M2)
  call TI_call_OL(0,0, momenta_73, masses2_6, T0sum(198), M2)
  call TI_call_OL(0,0, momenta_94, masses2_6, T0sum(199), M2)
  call TI_call_OL(0,0, momenta_79, masses2_6, T0sum(200), M2)
  call TI_call_OL(0,0, momenta_46, masses2_6, T0sum(201), M2)
  call TI_call_OL(0,0, momenta_55, masses2_6, T0sum(202), M2)
  call TI_call_OL(0,0, momenta_128, masses2_6, T0sum(203), M2)
  call TI_call_OL(0,0, momenta_116, masses2_6, T0sum(204), M2)
  call TI_call_OL(0,0, momenta_58, masses2_6, T0sum(205), M2)
  call TI_call_OL(0,0, momenta_38, masses2_6, T0sum(206), M2)
  call TI_call_OL(0,0, momenta_122, masses2_6, T0sum(207), M2)
  call TI_call_OL(0,0, momenta_115, masses2_6, T0sum(208), M2)
  call TI_call_OL(0,0, momenta_49, masses2_6, T0sum(209), M2)
  call TI_call_OL(0,0, momenta_106, masses2_6, T0sum(210), M2)
  call TI_call_OL(0,0, momenta_96, masses2_6, T0sum(211), M2)
  call TI_call_OL(0,0, momenta_89, masses2_6, T0sum(212), M2)
  call TI_call_OL(0,0, momenta_75, masses2_6, T0sum(213), M2)
  call TI_call_OL(0,0, momenta_51, masses2_6, T0sum(214), M2)
  call TI_call_OL(0,0, momenta_41, masses2_6, T0sum(215), M2)
  call TI_call_OL(0,0, momenta_108, masses2_6, T0sum(216), M2)
  call TI_call_OL(0,0, momenta_102, masses2_6, T0sum(217), M2)
  call TI_call_OL(0,0, momenta_90, masses2_6, T0sum(218), M2)
  call TI_call_OL(0,0, momenta_81, masses2_6, T0sum(219), M2)
  call TI_call_OL(0,0, momenta_60, masses2_6, T0sum(220), M2)
  call TI_call_OL(0,0, momenta_82, masses2_6, T0sum(221), M2)
  call TI_call_OL(0,0, momenta_70, masses2_6, T0sum(222), M2)
  call TI_call_OL(0,0, momenta_101, masses2_6, T0sum(223), M2)
  call TI_call_OL(0,0, momenta_62, masses2_6, T0sum(224), M2)
  call TI_call_OL(0,0, momenta_44, masses2_6, T0sum(225), M2)
  call TI_call_OL(0,0, momenta_76, masses2_6, T0sum(226), M2)
  call TI_call_OL(0,0, momenta_69, masses2_6, T0sum(227), M2)
  call TI_call_OL(0,0, momenta_95, masses2_6, T0sum(228), M2)
  call TI_call_OL(0,0, momenta_53, masses2_6, T0sum(229), M2)
  call TI_call_OL(0,0, momenta_68, masses2_6, T0sum(230), M2)
  call TI_call_OL(0,0, momenta_84, masses2_6, T0sum(231), M2)
  call TI_call_OL(0,0, momenta_67, masses2_6, T0sum(232), M2)
  call TI_call_OL(0,0, momenta_104, masses2_6, T0sum(233), M2)
  call TI_call_OL(0,0, momenta_25, masses2_1, T0sum(234), M2)
  call TI_call_OL(0,0, momenta_14, masses2_1, T0sum(235), M2)
  call TI_call_OL(0,0, momenta_11, masses2_1, T0sum(236), M2)
  call TI_call_OL(0,0, momenta_22, masses2_1, T0sum(237), M2)
  call TI_call_OL(0,0, momenta_13, masses2_1, T0sum(238), M2)
  call TI_call_OL(0,0, momenta_6, masses2_1, T0sum(239), M2)
  call TI_call_OL(0,0, momenta_7, masses2_1, T0sum(240), M2)
  call TI_call_OL(0,0, momenta_10, masses2_1, T0sum(241), M2)
  call TI_call_OL(0,0, momenta_26, masses2_1, T0sum(242), M2)
  call TI_call_OL(0,0, momenta_4, masses2_1, T0sum(243), M2)
  call TI_call_OL(0,0, momenta_2, masses2_1, T0sum(244), M2)
  call TI_call_OL(0,0, momenta_27, masses2_1, T0sum(245), M2)
  call TI_call_OL(0,0, momenta_3, masses2_1, T0sum(246), M2)
  call TI_call_OL(0,0, momenta_20, masses2_1, T0sum(247), M2)
  call TI_call_OL(0,0, momenta_8, masses2_1, T0sum(248), M2)
  call TI_call_OL(0,0, momenta_23, masses2_1, T0sum(249), M2)
  call TI_call_OL(0,0, momenta_12, masses2_1, T0sum(250), M2)
  call TI_call_OL(0,0, momenta_21, masses2_1, T0sum(251), M2)
  call TI_call_OL(0,0, momenta_24, masses2_1, T0sum(252), M2)
  call TI_call_OL(0,0, momenta_15, masses2_1, T0sum(253), M2)
  call TI_call_OL(0,0, momenta_9, masses2_1, T0sum(254), M2)
  call TI_call_OL(0,0, momenta_5, masses2_1, T0sum(255), M2)
  call TI_call_OL(0,0, momenta_18, masses2_1, T0sum(256), M2)
  call TI_call_OL(0,0, momenta_16, masses2_1, T0sum(257), M2)
  call TI_call_OL(0,0, momenta_17, masses2_1, T0sum(258), M2)
  call TI_call_OL(0,0, momenta_19, masses2_1, T0sum(259), M2)
  call TI_call_OL(0,0, momenta_11, masses2_5, T0sum(260), M2)
  call TI_call_OL(0,0, momenta_1, masses2_3, T0sum(261), M2)
  call TI_call_OL(0,0, momenta_11, masses2_4, T0sum(262), M2)
  call TI_call_OL(0,0, momenta_1, masses2_2, T0sum(263), M2)
  call TI_call_OL(0,0, momenta_6, masses2_5, T0sum(264), M2)
  call TI_call_OL(0,0, momenta_6, masses2_4, T0sum(265), M2)
  call TI_call_OL(0,0, momenta_10, masses2_5, T0sum(266), M2)
  call TI_call_OL(0,0, momenta_10, masses2_4, T0sum(267), M2)
  call TI_call_OL(0,0, momenta_7, masses2_5, T0sum(268), M2)
  call TI_call_OL(0,0, momenta_7, masses2_4, T0sum(269), M2)

  call TI_call_OL(0,1, momenta_317, masses2_9, T1sum(1), M2,sbarray_1, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_311, masses2_9, T1sum(2), M2,sbarray_2, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_315, masses2_9, T1sum(3), M2,sbarray_3, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_313, masses2_9, T1sum(4), M2,sbarray_4, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_312, masses2_9, T1sum(5), M2,sbarray_5, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_316, masses2_9, T1sum(6), M2,sbarray_6, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_318, masses2_9, T1sum(7), M2,sbarray_7, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_314, masses2_9, T1sum(8), M2,sbarray_8, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_310, masses2_8, T1sum(9), M2,sbarray_9, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_301, masses2_8, T1sum(10), M2,sbarray_10, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_291, masses2_8, T1sum(11), M2,sbarray_11, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_280, masses2_8, T1sum(12), M2,sbarray_12, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_277, masses2_8, T1sum(13), M2,sbarray_13, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_307, masses2_8, T1sum(14), M2,sbarray_14, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_294, masses2_8, T1sum(15), M2,sbarray_15, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_285, masses2_8, T1sum(16), M2,sbarray_16, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_269, masses2_8, T1sum(17), M2,sbarray_17, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_262, masses2_8, T1sum(18), M2,sbarray_18, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_309, masses2_8, T1sum(19), M2,sbarray_19, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_299, masses2_8, T1sum(20), M2,sbarray_20, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_287, masses2_8, T1sum(21), M2,sbarray_21, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_273, masses2_8, T1sum(22), M2,sbarray_22, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_308, masses2_8, T1sum(23), M2,sbarray_23, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_296, masses2_8, T1sum(24), M2,sbarray_24, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_289, masses2_8, T1sum(25), M2,sbarray_25, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_266, masses2_8, T1sum(26), M2,sbarray_26, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_305, masses2_8, T1sum(27), M2,sbarray_27, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_295, masses2_8, T1sum(28), M2,sbarray_28, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_286, masses2_8, T1sum(29), M2,sbarray_29, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_270, masses2_8, T1sum(30), M2,sbarray_30, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_264, masses2_8, T1sum(31), M2,sbarray_31, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_306, masses2_8, T1sum(32), M2,sbarray_32, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_300, masses2_8, T1sum(33), M2,sbarray_33, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_288, masses2_8, T1sum(34), M2,sbarray_34, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_281, masses2_8, T1sum(35), M2,sbarray_35, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_275, masses2_8, T1sum(36), M2,sbarray_36, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_304, masses2_8, T1sum(37), M2,sbarray_37, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_302, masses2_8, T1sum(38), M2,sbarray_38, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_292, masses2_8, T1sum(39), M2,sbarray_39, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_282, masses2_8, T1sum(40), M2,sbarray_40, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_279, masses2_8, T1sum(41), M2,sbarray_41, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_303, masses2_8, T1sum(42), M2,sbarray_42, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_297, masses2_8, T1sum(43), M2,sbarray_43, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_290, masses2_8, T1sum(44), M2,sbarray_44, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_271, masses2_8, T1sum(45), M2,sbarray_45, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_268, masses2_8, T1sum(46), M2,sbarray_46, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_278, masses2_8, T1sum(47), M2,sbarray_47, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_274, masses2_8, T1sum(48), M2,sbarray_48, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_272, masses2_8, T1sum(49), M2,sbarray_49, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_276, masses2_8, T1sum(50), M2,sbarray_50, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_267, masses2_8, T1sum(51), M2,sbarray_51, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_263, masses2_8, T1sum(52), M2,sbarray_52, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_261, masses2_8, T1sum(53), M2,sbarray_53, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_265, masses2_8, T1sum(54), M2,sbarray_54, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_284, masses2_8, T1sum(55), M2,sbarray_55, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_293, masses2_8, T1sum(56), M2,sbarray_56, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_283, masses2_8, T1sum(57), M2,sbarray_57, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_298, masses2_8, T1sum(58), M2,sbarray_58, ScalarBoxes(:))

  call add_met(M2,M2L1R1)

#ifdef LOOPSQUARED
  end if
#endif

  call met_to_real(M2out,M2)

#ifdef PRECISION_dp
  call HOL_memory_deallocation_/**/REALKIND(1)
  call HCL_memory_deallocation_/**/REALKIND(1)
#endif

end subroutine integrate_tensor_sum

end module ol_tensor_sum_storage_ppllnnjj_ew_nexnmxemuudxdx_1_/**/REALKIND
