
! **********************************************************************
module ol_tables_storage_ppllnnjj_ew_nexnmxemucdxsx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  ! helicity tables for the 1-loop recursion
integer(intkind2), save :: h0tab(256,172)
integer(intkind2), save :: heltab2x2(2,2,111)
integer(intkind2), save :: heltab2x4(2,4,38)
integer(intkind2), save :: heltab2x8(2,8,154)
integer(intkind2), save :: heltab2x16(2,16,162)
integer(intkind2), save :: heltab2x32(2,32,64)
integer(intkind2), save :: heltab2x64(2,64,8)
integer(intkind2), save :: heltab2x128(2,128,48)
integer(intkind2), save :: heltab2x256(2,256,172)


  ! number of helicity states for openloops recursion steps
integer(intkind2), save :: m0h(172)
integer(intkind2), save :: m3h2x1(3,111)
integer(intkind2), save :: m3h4x1(3,30)
integer(intkind2), save :: m3h8x1(3,46)
integer(intkind2), save :: m3h16x1(3,68)
integer(intkind2), save :: m3h32x1(3,8)
integer(intkind2), save :: m3h2x2(3,8)
integer(intkind2), save :: m3h4x2(3,82)
integer(intkind2), save :: m3h8x2(3,30)
integer(intkind2), save :: m3h16x2(3,16)
integer(intkind2), save :: m3h2x4(3,26)
integer(intkind2), save :: m3h4x4(3,6)
integer(intkind2), save :: m3h8x4(3,2)
integer(intkind2), save :: m3h2x8(3,58)
integer(intkind2), save :: m3h8x8(3,2)
integer(intkind2), save :: m3h32x8(3,24)
integer(intkind2), save :: m3h2x16(3,38)
integer(intkind2), save :: m3h4x16(3,6)
integer(intkind2), save :: m3h8x16(3,16)
integer(intkind2), save :: m3h16x16(3,76)
integer(intkind2), save :: m3h4x32(3,24)
integer(intkind2), save :: m3h8x32(3,24)
integer(intkind2), save :: m3h2x64(3,8)
integer(intkind2), save :: m3h2x128(3,48)

integer(intkind2), save :: n2h1(128)
integer(intkind2), save :: n2h2(120)
integer(intkind2), save :: n2h4(12)
integer(intkind2), save :: n2h8(86)
integer(intkind2), save :: n2h16(80)
integer(intkind2), save :: n2h32(42)
integer(intkind2), save :: n2h64(8)
integer(intkind2), save :: n2h128(34)


contains

!**********************************************************************
subroutine HOL_m3_init()
!**********************************************************************
! initialize m3 arrays for helicity summation
!**********************************************************************
  use KIND_TYPES, only: REALKIND, intkind2

m3h2x1(1,:)=2
m3h2x1(2,:)=1
m3h2x1(3,:)=2
m3h4x1(1,:)=4
m3h4x1(2,:)=1
m3h4x1(3,:)=4
m3h8x1(1,:)=8
m3h8x1(2,:)=1
m3h8x1(3,:)=8
m3h16x1(1,:)=16
m3h16x1(2,:)=1
m3h16x1(3,:)=16
m3h32x1(1,:)=32
m3h32x1(2,:)=1
m3h32x1(3,:)=32
m3h2x2(1,:)=2
m3h2x2(2,:)=2
m3h2x2(3,:)=4
m3h4x2(1,:)=4
m3h4x2(2,:)=2
m3h4x2(3,:)=8
m3h8x2(1,:)=8
m3h8x2(2,:)=2
m3h8x2(3,:)=16
m3h16x2(1,:)=16
m3h16x2(2,:)=2
m3h16x2(3,:)=32
m3h2x4(1,:)=2
m3h2x4(2,:)=4
m3h2x4(3,:)=8
m3h4x4(1,:)=4
m3h4x4(2,:)=4
m3h4x4(3,:)=16
m3h8x4(1,:)=8
m3h8x4(2,:)=4
m3h8x4(3,:)=32
m3h2x8(1,:)=2
m3h2x8(2,:)=8
m3h2x8(3,:)=16
m3h8x8(1,:)=8
m3h8x8(2,:)=8
m3h8x8(3,:)=64
m3h32x8(1,:)=32
m3h32x8(2,:)=8
m3h32x8(3,:)=256
m3h2x16(1,:)=2
m3h2x16(2,:)=16
m3h2x16(3,:)=32
m3h4x16(1,:)=4
m3h4x16(2,:)=16
m3h4x16(3,:)=64
m3h8x16(1,:)=8
m3h8x16(2,:)=16
m3h8x16(3,:)=128
m3h16x16(1,:)=16
m3h16x16(2,:)=16
m3h16x16(3,:)=256
m3h4x32(1,:)=4
m3h4x32(2,:)=32
m3h4x32(3,:)=128
m3h8x32(1,:)=8
m3h8x32(2,:)=32
m3h8x32(3,:)=256
m3h2x64(1,:)=2
m3h2x64(2,:)=64
m3h2x64(3,:)=128
m3h2x128(1,:)=2
m3h2x128(2,:)=128
m3h2x128(3,:)=256

n2h1(:)=1
n2h2(:)=2
n2h4(:)=4
n2h8(:)=8
n2h16(:)=16
n2h32(:)=32
n2h64(:)=64
n2h128(:)=128


end subroutine HOL_m3_init

!**********************************************************************

end module ol_tables_storage_ppllnnjj_ew_nexnmxemucdxsx_1_/**/REALKIND

! **********************************************************************
module ol_tensor_sum_storage_ppllnnjj_ew_nexnmxemucdxsx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol, hcl, met
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  type(met), save :: M2L1R1

  ! Declarations of loop wave function tensors

  type(hol), save :: G0H1(1)
  type(hol), save :: G1H1(1)
  type(hol), save :: G1H2(20)
  type(hol), save :: G2H2(70)
  type(hol), save :: G0H4(1)
  type(hol), save :: G1H4(37)
  type(hol), save :: G2H4(6)
  type(hol), save :: G0H8(4)
  type(hol), save :: G1H8(75)
  type(hol), save :: G2H8(14)
  type(hol), save :: G0H16(1)
  type(hol), save :: G1H16(48)
  type(hol), save :: G2H16(10)
  type(hol), save :: G0H32(5)
  type(hol), save :: G1H32(20)
  type(hol), save :: G2H32(8)
  type(hol), save :: G0H64(1)
  type(hol), save :: G1H64(6)
  type(hol), save :: G0H128(9)
  type(hol), save :: G1H128(12)
  type(hol), save :: G0H256(1)
  type(hcl), save, dimension(410) :: G0tensor
  type(hcl), save, dimension(410) :: G1tensor
  type(hcl), save, dimension(150) :: G2tensor



  ! Declarations for on-the-fly tensor reduction
type (basis),      save :: RedBasis(134)
type (redset4),    save :: RedSet_4(104)
type (redset5),    save :: RedSet_5(28)
integer, save :: mass2set(0:1,3)
integer, save :: mass3set(0:2,1)
integer, save :: mass4set(0:3,1)
integer, save :: mass5set(0:4,1)



  ! Declarations for TI calls

  integer, save :: momenta_1(2)
  integer, save :: momenta_2(2)
  integer, save :: momenta_3(2)
  integer, save :: momenta_4(2)
  integer, save :: momenta_5(2)
  integer, save :: momenta_6(2)
  integer, save :: momenta_7(2)
  integer, save :: momenta_8(2)
  integer, save :: momenta_9(2)
  integer, save :: momenta_10(2)
  integer, save :: momenta_11(2)
  integer, save :: momenta_12(2)
  integer, save :: momenta_13(2)
  integer, save :: momenta_14(2)
  integer, save :: momenta_15(2)
  integer, save :: momenta_16(2)
  integer, save :: momenta_17(2)
  integer, save :: momenta_18(2)
  integer, save :: momenta_19(2)
  integer, save :: momenta_20(2)
  integer, save :: momenta_21(2)
  integer, save :: momenta_22(2)
  integer, save :: momenta_23(2)
  integer, save :: momenta_24(2)
  integer, save :: momenta_25(2)
  integer, save :: momenta_26(2)
  integer, save :: momenta_27(2)
  integer, save :: momenta_28(3)
  integer, save :: momenta_29(3)
  integer, save :: momenta_30(3)
  integer, save :: momenta_31(3)
  integer, save :: momenta_32(3)
  integer, save :: momenta_33(3)
  integer, save :: momenta_34(3)
  integer, save :: momenta_35(3)
  integer, save :: momenta_36(3)
  integer, save :: momenta_37(3)
  integer, save :: momenta_38(3)
  integer, save :: momenta_39(3)
  integer, save :: momenta_40(3)
  integer, save :: momenta_41(3)
  integer, save :: momenta_42(3)
  integer, save :: momenta_43(3)
  integer, save :: momenta_44(3)
  integer, save :: momenta_45(3)
  integer, save :: momenta_46(3)
  integer, save :: momenta_47(3)
  integer, save :: momenta_48(3)
  integer, save :: momenta_49(3)
  integer, save :: momenta_50(3)
  integer, save :: momenta_51(3)
  integer, save :: momenta_52(3)
  integer, save :: momenta_53(3)
  integer, save :: momenta_54(3)
  integer, save :: momenta_55(3)
  integer, save :: momenta_56(3)
  integer, save :: momenta_57(3)
  integer, save :: momenta_58(3)
  integer, save :: momenta_59(3)
  integer, save :: momenta_60(3)
  integer, save :: momenta_61(3)
  integer, save :: momenta_62(3)
  integer, save :: momenta_63(3)
  integer, save :: momenta_64(3)
  integer, save :: momenta_65(3)
  integer, save :: momenta_66(3)
  integer, save :: momenta_67(3)
  integer, save :: momenta_68(3)
  integer, save :: momenta_69(3)
  integer, save :: momenta_70(3)
  integer, save :: momenta_71(3)
  integer, save :: momenta_72(3)
  integer, save :: momenta_73(3)
  integer, save :: momenta_74(3)
  integer, save :: momenta_75(3)
  integer, save :: momenta_76(3)
  integer, save :: momenta_77(3)
  integer, save :: momenta_78(3)
  integer, save :: momenta_79(3)
  integer, save :: momenta_80(3)
  integer, save :: momenta_81(3)
  integer, save :: momenta_82(3)
  integer, save :: momenta_83(3)
  integer, save :: momenta_84(3)
  integer, save :: momenta_85(3)
  integer, save :: momenta_86(3)
  integer, save :: momenta_87(3)
  integer, save :: momenta_88(3)
  integer, save :: momenta_89(3)
  integer, save :: momenta_90(3)
  integer, save :: momenta_91(3)
  integer, save :: momenta_92(3)
  integer, save :: momenta_93(3)
  integer, save :: momenta_94(3)
  integer, save :: momenta_95(3)
  integer, save :: momenta_96(3)
  integer, save :: momenta_97(3)
  integer, save :: momenta_98(3)
  integer, save :: momenta_99(3)
  integer, save :: momenta_100(3)
  integer, save :: momenta_101(3)
  integer, save :: momenta_102(3)
  integer, save :: momenta_103(3)
  integer, save :: momenta_104(3)
  integer, save :: momenta_105(3)
  integer, save :: momenta_106(3)
  integer, save :: momenta_107(3)
  integer, save :: momenta_108(3)
  integer, save :: momenta_109(3)
  integer, save :: momenta_110(3)
  integer, save :: momenta_111(3)
  integer, save :: momenta_112(3)
  integer, save :: momenta_113(3)
  integer, save :: momenta_114(3)
  integer, save :: momenta_115(3)
  integer, save :: momenta_116(3)
  integer, save :: momenta_117(3)
  integer, save :: momenta_118(3)
  integer, save :: momenta_119(3)
  integer, save :: momenta_120(3)
  integer, save :: momenta_121(3)
  integer, save :: momenta_122(3)
  integer, save :: momenta_123(3)
  integer, save :: momenta_124(4)
  integer, save :: momenta_125(4)
  integer, save :: momenta_126(4)
  integer, save :: momenta_127(4)
  integer, save :: momenta_128(4)
  integer, save :: momenta_129(4)
  integer, save :: momenta_130(4)
  integer, save :: momenta_131(4)
  integer, save :: momenta_132(4)
  integer, save :: momenta_133(4)
  integer, save :: momenta_134(4)
  integer, save :: momenta_135(4)
  integer, save :: momenta_136(4)
  integer, save :: momenta_137(4)
  integer, save :: momenta_138(4)
  integer, save :: momenta_139(4)
  integer, save :: momenta_140(4)
  integer, save :: momenta_141(4)
  integer, save :: momenta_142(4)
  integer, save :: momenta_143(4)
  integer, save :: momenta_144(4)
  integer, save :: momenta_145(4)
  integer, save :: momenta_146(4)
  integer, save :: momenta_147(4)
  integer, save :: momenta_148(4)
  integer, save :: momenta_149(4)
  integer, save :: momenta_150(4)
  integer, save :: momenta_151(4)
  integer, save :: momenta_152(4)
  integer, save :: momenta_153(4)
  integer, save :: momenta_154(4)
  integer, save :: momenta_155(4)
  integer, save :: momenta_156(4)
  integer, save :: momenta_157(4)
  integer, save :: momenta_158(4)
  integer, save :: momenta_159(4)
  integer, save :: momenta_160(4)
  integer, save :: momenta_161(4)
  integer, save :: momenta_162(4)
  integer, save :: momenta_163(4)
  integer, save :: momenta_164(4)
  integer, save :: momenta_165(4)
  integer, save :: momenta_166(4)
  integer, save :: momenta_167(4)
  integer, save :: momenta_168(4)
  integer, save :: momenta_169(4)
  integer, save :: momenta_170(4)
  integer, save :: momenta_171(4)
  integer, save :: momenta_172(4)
  integer, save :: momenta_173(4)
  integer, save :: momenta_174(4)
  integer, save :: momenta_175(4)
  integer, save :: momenta_176(4)
  integer, save :: momenta_177(4)
  integer, save :: momenta_178(4)
  integer, save :: momenta_179(4)
  integer, save :: momenta_180(4)
  integer, save :: momenta_181(4)
  integer, save :: momenta_182(4)
  integer, save :: momenta_183(4)
  integer, save :: momenta_184(4)
  integer, save :: momenta_185(4)
  integer, save :: momenta_186(4)
  integer, save :: momenta_187(4)
  integer, save :: momenta_188(4)
  integer, save :: momenta_189(4)
  integer, save :: momenta_190(4)
  integer, save :: momenta_191(4)
  integer, save :: momenta_192(4)
  integer, save :: momenta_193(4)
  integer, save :: momenta_194(4)
  integer, save :: momenta_195(4)
  integer, save :: momenta_196(4)
  integer, save :: momenta_197(4)
  integer, save :: momenta_198(4)
  integer, save :: momenta_199(4)
  integer, save :: momenta_200(4)
  integer, save :: momenta_201(4)
  integer, save :: momenta_202(4)
  integer, save :: momenta_203(4)
  integer, save :: momenta_204(4)
  integer, save :: momenta_205(4)
  integer, save :: momenta_206(5)
  integer, save :: momenta_207(5)
  integer, save :: momenta_208(5)
  integer, save :: momenta_209(5)
  integer, save :: momenta_210(5)
  integer, save :: momenta_211(5)
  integer, save :: momenta_212(5)
  integer, save :: momenta_213(5)
  integer, save :: momenta_214(5)
  integer, save :: momenta_215(5)
  integer, save :: momenta_216(5)
  integer, save :: momenta_217(5)
  integer, save :: momenta_218(5)
  integer, save :: momenta_219(5)
  integer, save :: momenta_220(5)
  integer, save :: momenta_221(5)
  integer, save :: momenta_222(5)
  integer, save :: momenta_223(5)
  integer, save :: momenta_224(5)
  integer, save :: momenta_225(5)
  integer, save :: momenta_226(5)
  integer, save :: momenta_227(5)
  integer, save :: momenta_228(5)
  integer, save :: momenta_229(5)
  integer, save :: momenta_230(5)
  integer, save :: momenta_231(5)
  integer, save :: momenta_232(5)
  integer, save :: momenta_233(5)
  integer, save :: momenta_234(6)
  integer, save :: momenta_235(6)
  integer, save :: momenta_236(6)
  integer, save :: momenta_237(6)

  integer, save :: masses2_1(2)
  integer, save :: masses2_2(2)
  integer, save :: masses2_3(2)
  integer, save :: masses2_4(2)
  integer, save :: masses2_5(2)
  integer, save :: masses2_6(3)
  integer, save :: masses2_7(4)
  integer, save :: masses2_8(5)
  integer, save :: masses2_9(6)

type(scalarbox), save :: ScalarBoxes(92)

integer, save :: sbarray_1(15)
integer, save :: sbarray_2(15)
integer, save :: sbarray_3(15)
integer, save :: sbarray_4(15)
integer, save :: sbarray_5(5)
integer, save :: sbarray_6(5)
integer, save :: sbarray_7(5)
integer, save :: sbarray_8(5)
integer, save :: sbarray_9(5)
integer, save :: sbarray_10(5)
integer, save :: sbarray_11(5)
integer, save :: sbarray_12(5)
integer, save :: sbarray_13(5)
integer, save :: sbarray_14(5)
integer, save :: sbarray_15(5)
integer, save :: sbarray_16(5)
integer, save :: sbarray_17(5)
integer, save :: sbarray_18(5)
integer, save :: sbarray_19(5)
integer, save :: sbarray_20(5)
integer, save :: sbarray_21(5)
integer, save :: sbarray_22(5)
integer, save :: sbarray_23(5)
integer, save :: sbarray_24(5)
integer, save :: sbarray_25(5)
integer, save :: sbarray_26(5)
integer, save :: sbarray_27(5)
integer, save :: sbarray_28(5)
integer, save :: sbarray_29(5)
integer, save :: sbarray_30(5)
integer, save :: sbarray_31(5)
integer, save :: sbarray_32(5)

  type(hcl), save, dimension(210) :: T0sum
  type(hcl), save, dimension(32) :: T1sum


  contains

!**********************************************************************
subroutine HOL_memory_allocation_full()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_loop_storage_ppllnnjj_ew_nexnmxemucdxsx_1_/**/DREALKIND, only: nhel
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none

    call hol_allocation(4,1,4,1,G0H1,1)
  call hol_allocation(4,5,4,1,G1H1,1)
  call hol_allocation(4,5,4,2,G1H2,20)
  call hol_allocation(4,15,4,2,G2H2,70)
  call hol_allocation(4,1,4,4,G0H4,1)
  call hol_allocation(4,5,4,4,G1H4,37)
  call hol_allocation(4,15,4,4,G2H4,6)
  call hol_allocation(4,1,4,8,G0H8,4)
  call hol_allocation(4,5,4,8,G1H8,75)
  call hol_allocation(4,15,4,8,G2H8,14)
  call hol_allocation(4,1,4,16,G0H16,1)
  call hol_allocation(4,5,4,16,G1H16,48)
  call hol_allocation(4,15,4,16,G2H16,10)
  call hol_allocation(4,1,4,32,G0H32,5)
  call hol_allocation(4,5,4,32,G1H32,20)
  call hol_allocation(4,15,4,32,G2H32,8)
  call hol_allocation(4,1,4,64,G0H64,1)
  call hol_allocation(4,5,4,64,G1H64,6)
  call hol_allocation(4,1,4,128,G0H128,9)
  call hol_allocation(4,5,4,128,G1H128,12)
  call hol_allocation(4,1,4,256,G0H256,1)


end subroutine HOL_memory_allocation_full

!**********************************************************************
subroutine HOL_memory_allocation_optimized()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_loop_storage_ppllnnjj_ew_nexnmxemucdxsx_1_/**/DREALKIND, only: nhel
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none

    call hol_allocation(4,1,4,min(nhel,1),G0H1,1)
  call hol_allocation(4,5,4,min(nhel,1),G1H1,1)
  call hol_allocation(4,5,4,min(nhel,2),G1H2,20)
  call hol_allocation(4,15,4,min(nhel,2),G2H2,70)
  call hol_allocation(4,1,4,min(nhel,4),G0H4,1)
  call hol_allocation(4,5,4,min(nhel,4),G1H4,37)
  call hol_allocation(4,15,4,min(nhel,4),G2H4,6)
  call hol_allocation(4,1,4,min(nhel,8),G0H8,4)
  call hol_allocation(4,5,4,min(nhel,8),G1H8,75)
  call hol_allocation(4,15,4,min(nhel,8),G2H8,14)
  call hol_allocation(4,1,4,min(nhel,16),G0H16,1)
  call hol_allocation(4,5,4,min(nhel,16),G1H16,48)
  call hol_allocation(4,15,4,min(nhel,16),G2H16,10)
  call hol_allocation(4,1,4,min(nhel,32),G0H32,5)
  call hol_allocation(4,5,4,min(nhel,32),G1H32,20)
  call hol_allocation(4,15,4,min(nhel,32),G2H32,8)
  call hol_allocation(4,1,4,min(nhel,64),G0H64,1)
  call hol_allocation(4,5,4,min(nhel,64),G1H64,6)
  call hol_allocation(4,1,4,min(nhel,128),G0H128,9)
  call hol_allocation(4,5,4,min(nhel,128),G1H128,12)
  call hol_allocation(4,1,4,min(nhel,256),G0H256,1)


end subroutine HOL_memory_allocation_optimized

!**********************************************************************
subroutine HOL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_deallocation
  implicit none
  integer,   intent(in)    :: dmode

    call hol_deallocation(G0H1,1,dmode)
  call hol_deallocation(G1H1,1,dmode)
  call hol_deallocation(G1H2,20,dmode)
  call hol_deallocation(G2H2,70,dmode)
  call hol_deallocation(G0H4,1,dmode)
  call hol_deallocation(G1H4,37,dmode)
  call hol_deallocation(G2H4,6,dmode)
  call hol_deallocation(G0H8,4,dmode)
  call hol_deallocation(G1H8,75,dmode)
  call hol_deallocation(G2H8,14,dmode)
  call hol_deallocation(G0H16,1,dmode)
  call hol_deallocation(G1H16,48,dmode)
  call hol_deallocation(G2H16,10,dmode)
  call hol_deallocation(G0H32,5,dmode)
  call hol_deallocation(G1H32,20,dmode)
  call hol_deallocation(G2H32,8,dmode)
  call hol_deallocation(G0H64,1,dmode)
  call hol_deallocation(G1H64,6,dmode)
  call hol_deallocation(G0H128,9,dmode)
  call hol_deallocation(G1H128,12,dmode)
  call hol_deallocation(G0H256,1,dmode)


end subroutine HOL_memory_deallocation_/**/REALKIND

!**********************************************************************
subroutine HCL_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

  call hcl_allocation(1,G0tensor, 410)
call hcl_allocation(5,G1tensor, 410)
call hcl_allocation(15,G2tensor, 150)


end subroutine HCL_memory_allocation


!**********************************************************************
subroutine HCL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! deallocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_deallocation
  implicit none
  integer,   intent(in)    :: dmode

  call hcl_deallocation(G0tensor, 410,dmode)
call hcl_deallocation(G1tensor, 410,dmode)
call hcl_deallocation(G2tensor, 150,dmode)

    call hcl_deallocation(T0sum,210,dmode)
  call hcl_deallocation(T1sum,32,dmode)


end subroutine HCL_memory_deallocation_/**/REALKIND


!**********************************************************************
subroutine Tsum_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

    call hcl_allocation(1,T0sum,210)
  call hcl_allocation(5,T1sum,32)


end subroutine Tsum_memory_allocation


#ifdef PRECISION_dp
subroutine max_point(r) &
    & bind(c,name="ol_f_max_point_ppllnnjj_ew_nexnmxemucdxsx_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 6
end subroutine max_point

subroutine tensor_rank(r) &
    & bind(c,name="ol_f_tensor_rank_ppllnnjj_ew_nexnmxemucdxsx_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 1
end subroutine tensor_rank
#endif

subroutine reset_tensor_sum()
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  use ol_parameters_init_/**/REALKIND, only: init_hcl
  implicit none
  integer :: i

  do i = 1,210
    call init_hcl(T0sum(i))
  end do
  do i = 1,32
    call init_hcl(T1sum(i))
  end do

end subroutine reset_tensor_sum


subroutine scale_one_tsum(tsum, spow)
  use ol_parameters_decl_/**/REALKIND, only: scalefactor
  implicit none
  complex(REALKIND), intent(inout) :: tsum(:)
  integer, intent(in) :: spow ! rank 0 scale power
  real(REALKIND) :: sfinv, sfac
  integer :: sz
  sfinv = 1/scalefactor
  sfac = scalefactor**spow
  sz = size(tsum)
  tsum(1) = sfac*tsum(1)
  if (sz > 1) then ! rank 1
    sfac = sfac*sfinv
    tsum(2:5) = sfac*tsum(2:5)
  end if
  if (sz > 5) then ! rank 2
    sfac = sfac*sfinv
    tsum(6:15) = sfac*tsum(6:15)
  end if
  if (sz > 15) then ! rank 3
    sfac = sfac*sfinv
    tsum(16:35) = sfac*tsum(16:35)
  end if
  if (sz > 35) then ! rank 4
    sfac = sfac*sfinv
    tsum(36:70) = sfac*tsum(36:70)
  end if
  if (sz > 70) then ! rank 5
    sfac = sfac*sfinv
    tsum(71:126) = sfac*tsum(71:126)
  end if
  if (sz > 126) then ! rank 6
    sfac = sfac*sfinv
    tsum(127:210) = sfac*tsum(127:210)
  end if
  if (sz > 210) then ! rank 7
    sfac = sfac*sfinv
    tsum(211:330) = sfac*tsum(211:330)
  end if
end subroutine scale_one_tsum


subroutine scale_tensor_sum()
  implicit none
  call scale_one_tsum(T1sum(1)%cmp, 0)
  call scale_one_tsum(T1sum(2)%cmp, 0)
  call scale_one_tsum(T1sum(3)%cmp, 0)
  call scale_one_tsum(T1sum(4)%cmp, 0)
  call scale_one_tsum(T1sum(5)%cmp, -2)
  call scale_one_tsum(T1sum(6)%cmp, -2)
  call scale_one_tsum(T1sum(7)%cmp, -2)
  call scale_one_tsum(T1sum(8)%cmp, -2)
  call scale_one_tsum(T1sum(9)%cmp, -2)
  call scale_one_tsum(T1sum(10)%cmp, -2)
  call scale_one_tsum(T1sum(11)%cmp, -2)
  call scale_one_tsum(T1sum(12)%cmp, -2)
  call scale_one_tsum(T1sum(13)%cmp, -2)
  call scale_one_tsum(T1sum(14)%cmp, -2)
  call scale_one_tsum(T1sum(15)%cmp, -2)
  call scale_one_tsum(T1sum(16)%cmp, -2)
  call scale_one_tsum(T1sum(17)%cmp, -2)
  call scale_one_tsum(T1sum(18)%cmp, -2)
  call scale_one_tsum(T1sum(19)%cmp, -2)
  call scale_one_tsum(T1sum(20)%cmp, -2)
  call scale_one_tsum(T1sum(21)%cmp, -2)
  call scale_one_tsum(T1sum(22)%cmp, -2)
  call scale_one_tsum(T1sum(23)%cmp, -2)
  call scale_one_tsum(T1sum(24)%cmp, -2)
  call scale_one_tsum(T1sum(25)%cmp, -2)
  call scale_one_tsum(T1sum(26)%cmp, -2)
  call scale_one_tsum(T1sum(27)%cmp, -2)
  call scale_one_tsum(T1sum(28)%cmp, -2)
  call scale_one_tsum(T1sum(29)%cmp, -2)
  call scale_one_tsum(T1sum(30)%cmp, -2)
  call scale_one_tsum(T1sum(31)%cmp, -2)
  call scale_one_tsum(T1sum(32)%cmp, -2)
  call scale_one_tsum(T0sum(1)%cmp, -4)
  call scale_one_tsum(T0sum(2)%cmp, -4)
  call scale_one_tsum(T0sum(3)%cmp, -4)
  call scale_one_tsum(T0sum(4)%cmp, -4)
  call scale_one_tsum(T0sum(5)%cmp, -4)
  call scale_one_tsum(T0sum(6)%cmp, -4)
  call scale_one_tsum(T0sum(7)%cmp, -4)
  call scale_one_tsum(T0sum(8)%cmp, -4)
  call scale_one_tsum(T0sum(9)%cmp, -4)
  call scale_one_tsum(T0sum(10)%cmp, -4)
  call scale_one_tsum(T0sum(11)%cmp, -4)
  call scale_one_tsum(T0sum(12)%cmp, -4)
  call scale_one_tsum(T0sum(13)%cmp, -4)
  call scale_one_tsum(T0sum(14)%cmp, -4)
  call scale_one_tsum(T0sum(15)%cmp, -4)
  call scale_one_tsum(T0sum(16)%cmp, -4)
  call scale_one_tsum(T0sum(17)%cmp, -4)
  call scale_one_tsum(T0sum(18)%cmp, -4)
  call scale_one_tsum(T0sum(19)%cmp, -4)
  call scale_one_tsum(T0sum(20)%cmp, -4)
  call scale_one_tsum(T0sum(21)%cmp, -4)
  call scale_one_tsum(T0sum(22)%cmp, -4)
  call scale_one_tsum(T0sum(23)%cmp, -4)
  call scale_one_tsum(T0sum(24)%cmp, -4)
  call scale_one_tsum(T0sum(25)%cmp, -4)
  call scale_one_tsum(T0sum(26)%cmp, -4)
  call scale_one_tsum(T0sum(27)%cmp, -4)
  call scale_one_tsum(T0sum(28)%cmp, -4)
  call scale_one_tsum(T0sum(29)%cmp, -4)
  call scale_one_tsum(T0sum(30)%cmp, -4)
  call scale_one_tsum(T0sum(31)%cmp, -4)
  call scale_one_tsum(T0sum(32)%cmp, -4)
  call scale_one_tsum(T0sum(33)%cmp, -4)
  call scale_one_tsum(T0sum(34)%cmp, -4)
  call scale_one_tsum(T0sum(35)%cmp, -4)
  call scale_one_tsum(T0sum(36)%cmp, -4)
  call scale_one_tsum(T0sum(37)%cmp, -4)
  call scale_one_tsum(T0sum(38)%cmp, -4)
  call scale_one_tsum(T0sum(39)%cmp, -4)
  call scale_one_tsum(T0sum(40)%cmp, -4)
  call scale_one_tsum(T0sum(41)%cmp, -4)
  call scale_one_tsum(T0sum(42)%cmp, -4)
  call scale_one_tsum(T0sum(43)%cmp, -4)
  call scale_one_tsum(T0sum(44)%cmp, -4)
  call scale_one_tsum(T0sum(45)%cmp, -4)
  call scale_one_tsum(T0sum(46)%cmp, -4)
  call scale_one_tsum(T0sum(47)%cmp, -4)
  call scale_one_tsum(T0sum(48)%cmp, -4)
  call scale_one_tsum(T0sum(49)%cmp, -4)
  call scale_one_tsum(T0sum(50)%cmp, -4)
  call scale_one_tsum(T0sum(51)%cmp, -4)
  call scale_one_tsum(T0sum(52)%cmp, -4)
  call scale_one_tsum(T0sum(53)%cmp, -4)
  call scale_one_tsum(T0sum(54)%cmp, -4)
  call scale_one_tsum(T0sum(55)%cmp, -4)
  call scale_one_tsum(T0sum(56)%cmp, -4)
  call scale_one_tsum(T0sum(57)%cmp, -4)
  call scale_one_tsum(T0sum(58)%cmp, -4)
  call scale_one_tsum(T0sum(59)%cmp, -4)
  call scale_one_tsum(T0sum(60)%cmp, -4)
  call scale_one_tsum(T0sum(61)%cmp, -4)
  call scale_one_tsum(T0sum(62)%cmp, -4)
  call scale_one_tsum(T0sum(63)%cmp, -4)
  call scale_one_tsum(T0sum(64)%cmp, -4)
  call scale_one_tsum(T0sum(65)%cmp, -4)
  call scale_one_tsum(T0sum(66)%cmp, -4)
  call scale_one_tsum(T0sum(67)%cmp, -4)
  call scale_one_tsum(T0sum(68)%cmp, -4)
  call scale_one_tsum(T0sum(69)%cmp, -4)
  call scale_one_tsum(T0sum(70)%cmp, -4)
  call scale_one_tsum(T0sum(71)%cmp, -4)
  call scale_one_tsum(T0sum(72)%cmp, -4)
  call scale_one_tsum(T0sum(73)%cmp, -4)
  call scale_one_tsum(T0sum(74)%cmp, -4)
  call scale_one_tsum(T0sum(75)%cmp, -4)
  call scale_one_tsum(T0sum(76)%cmp, -4)
  call scale_one_tsum(T0sum(77)%cmp, -4)
  call scale_one_tsum(T0sum(78)%cmp, -4)
  call scale_one_tsum(T0sum(79)%cmp, -4)
  call scale_one_tsum(T0sum(80)%cmp, -4)
  call scale_one_tsum(T0sum(81)%cmp, -4)
  call scale_one_tsum(T0sum(82)%cmp, -4)
  call scale_one_tsum(T0sum(83)%cmp, -6)
  call scale_one_tsum(T0sum(84)%cmp, -6)
  call scale_one_tsum(T0sum(85)%cmp, -6)
  call scale_one_tsum(T0sum(86)%cmp, -6)
  call scale_one_tsum(T0sum(87)%cmp, -6)
  call scale_one_tsum(T0sum(88)%cmp, -6)
  call scale_one_tsum(T0sum(89)%cmp, -6)
  call scale_one_tsum(T0sum(90)%cmp, -6)
  call scale_one_tsum(T0sum(91)%cmp, -6)
  call scale_one_tsum(T0sum(92)%cmp, -6)
  call scale_one_tsum(T0sum(93)%cmp, -6)
  call scale_one_tsum(T0sum(94)%cmp, -6)
  call scale_one_tsum(T0sum(95)%cmp, -6)
  call scale_one_tsum(T0sum(96)%cmp, -6)
  call scale_one_tsum(T0sum(97)%cmp, -6)
  call scale_one_tsum(T0sum(98)%cmp, -6)
  call scale_one_tsum(T0sum(99)%cmp, -6)
  call scale_one_tsum(T0sum(100)%cmp, -6)
  call scale_one_tsum(T0sum(101)%cmp, -6)
  call scale_one_tsum(T0sum(102)%cmp, -6)
  call scale_one_tsum(T0sum(103)%cmp, -6)
  call scale_one_tsum(T0sum(104)%cmp, -6)
  call scale_one_tsum(T0sum(105)%cmp, -6)
  call scale_one_tsum(T0sum(106)%cmp, -6)
  call scale_one_tsum(T0sum(107)%cmp, -6)
  call scale_one_tsum(T0sum(108)%cmp, -6)
  call scale_one_tsum(T0sum(109)%cmp, -6)
  call scale_one_tsum(T0sum(110)%cmp, -6)
  call scale_one_tsum(T0sum(111)%cmp, -6)
  call scale_one_tsum(T0sum(112)%cmp, -6)
  call scale_one_tsum(T0sum(113)%cmp, -6)
  call scale_one_tsum(T0sum(114)%cmp, -6)
  call scale_one_tsum(T0sum(115)%cmp, -6)
  call scale_one_tsum(T0sum(116)%cmp, -6)
  call scale_one_tsum(T0sum(117)%cmp, -6)
  call scale_one_tsum(T0sum(118)%cmp, -6)
  call scale_one_tsum(T0sum(119)%cmp, -6)
  call scale_one_tsum(T0sum(120)%cmp, -6)
  call scale_one_tsum(T0sum(121)%cmp, -6)
  call scale_one_tsum(T0sum(122)%cmp, -6)
  call scale_one_tsum(T0sum(123)%cmp, -6)
  call scale_one_tsum(T0sum(124)%cmp, -6)
  call scale_one_tsum(T0sum(125)%cmp, -6)
  call scale_one_tsum(T0sum(126)%cmp, -6)
  call scale_one_tsum(T0sum(127)%cmp, -6)
  call scale_one_tsum(T0sum(128)%cmp, -6)
  call scale_one_tsum(T0sum(129)%cmp, -6)
  call scale_one_tsum(T0sum(130)%cmp, -6)
  call scale_one_tsum(T0sum(131)%cmp, -6)
  call scale_one_tsum(T0sum(132)%cmp, -6)
  call scale_one_tsum(T0sum(133)%cmp, -6)
  call scale_one_tsum(T0sum(134)%cmp, -6)
  call scale_one_tsum(T0sum(135)%cmp, -6)
  call scale_one_tsum(T0sum(136)%cmp, -6)
  call scale_one_tsum(T0sum(137)%cmp, -6)
  call scale_one_tsum(T0sum(138)%cmp, -6)
  call scale_one_tsum(T0sum(139)%cmp, -6)
  call scale_one_tsum(T0sum(140)%cmp, -6)
  call scale_one_tsum(T0sum(141)%cmp, -6)
  call scale_one_tsum(T0sum(142)%cmp, -6)
  call scale_one_tsum(T0sum(143)%cmp, -6)
  call scale_one_tsum(T0sum(144)%cmp, -6)
  call scale_one_tsum(T0sum(145)%cmp, -6)
  call scale_one_tsum(T0sum(146)%cmp, -6)
  call scale_one_tsum(T0sum(147)%cmp, -6)
  call scale_one_tsum(T0sum(148)%cmp, -6)
  call scale_one_tsum(T0sum(149)%cmp, -6)
  call scale_one_tsum(T0sum(150)%cmp, -6)
  call scale_one_tsum(T0sum(151)%cmp, -6)
  call scale_one_tsum(T0sum(152)%cmp, -6)
  call scale_one_tsum(T0sum(153)%cmp, -6)
  call scale_one_tsum(T0sum(154)%cmp, -6)
  call scale_one_tsum(T0sum(155)%cmp, -6)
  call scale_one_tsum(T0sum(156)%cmp, -6)
  call scale_one_tsum(T0sum(157)%cmp, -6)
  call scale_one_tsum(T0sum(158)%cmp, -6)
  call scale_one_tsum(T0sum(159)%cmp, -6)
  call scale_one_tsum(T0sum(160)%cmp, -6)
  call scale_one_tsum(T0sum(161)%cmp, -6)
  call scale_one_tsum(T0sum(162)%cmp, -6)
  call scale_one_tsum(T0sum(163)%cmp, -6)
  call scale_one_tsum(T0sum(164)%cmp, -6)
  call scale_one_tsum(T0sum(165)%cmp, -6)
  call scale_one_tsum(T0sum(166)%cmp, -6)
  call scale_one_tsum(T0sum(167)%cmp, -6)
  call scale_one_tsum(T0sum(168)%cmp, -6)
  call scale_one_tsum(T0sum(169)%cmp, -6)
  call scale_one_tsum(T0sum(170)%cmp, -6)
  call scale_one_tsum(T0sum(171)%cmp, -6)
  call scale_one_tsum(T0sum(172)%cmp, -6)
  call scale_one_tsum(T0sum(173)%cmp, -6)
  call scale_one_tsum(T0sum(174)%cmp, -6)
  call scale_one_tsum(T0sum(175)%cmp, -6)
  call scale_one_tsum(T0sum(176)%cmp, -6)
  call scale_one_tsum(T0sum(177)%cmp, -6)
  call scale_one_tsum(T0sum(178)%cmp, -6)
  call scale_one_tsum(T0sum(179)%cmp, -8)
  call scale_one_tsum(T0sum(180)%cmp, -8)
  call scale_one_tsum(T0sum(181)%cmp, -8)
  call scale_one_tsum(T0sum(182)%cmp, -8)
  call scale_one_tsum(T0sum(183)%cmp, -8)
  call scale_one_tsum(T0sum(184)%cmp, -8)
  call scale_one_tsum(T0sum(185)%cmp, -8)
  call scale_one_tsum(T0sum(186)%cmp, -8)
  call scale_one_tsum(T0sum(187)%cmp, -8)
  call scale_one_tsum(T0sum(188)%cmp, -8)
  call scale_one_tsum(T0sum(189)%cmp, -8)
  call scale_one_tsum(T0sum(190)%cmp, -8)
  call scale_one_tsum(T0sum(191)%cmp, -8)
  call scale_one_tsum(T0sum(192)%cmp, -8)
  call scale_one_tsum(T0sum(193)%cmp, -8)
  call scale_one_tsum(T0sum(194)%cmp, -8)
  call scale_one_tsum(T0sum(195)%cmp, -8)
  call scale_one_tsum(T0sum(196)%cmp, -8)
  call scale_one_tsum(T0sum(197)%cmp, -8)
  call scale_one_tsum(T0sum(198)%cmp, -8)
  call scale_one_tsum(T0sum(199)%cmp, -8)
  call scale_one_tsum(T0sum(200)%cmp, -8)
  call scale_one_tsum(T0sum(201)%cmp, -8)
  call scale_one_tsum(T0sum(202)%cmp, -8)
  call scale_one_tsum(T0sum(203)%cmp, -8)
  call scale_one_tsum(T0sum(204)%cmp, -8)
  call scale_one_tsum(T0sum(205)%cmp, -8)
  call scale_one_tsum(T0sum(206)%cmp, -8)
  call scale_one_tsum(T0sum(207)%cmp, -8)
  call scale_one_tsum(T0sum(208)%cmp, -8)
  call scale_one_tsum(T0sum(209)%cmp, -8)
  call scale_one_tsum(T0sum(210)%cmp, -8)

end subroutine scale_tensor_sum

! **********************************************************************
subroutine set_integral_masses_and_momenta()
! **********************************************************************

  use ol_parameters_decl_/**/REALKIND
  momenta_1 = [ 0, 0 ]
  momenta_2 = [ 128, 127 ]
  momenta_3 = [ 133, 122 ]
  momenta_4 = [ 138, 117 ]
  momenta_5 = [ 144, 111 ]
  momenta_6 = [ 149, 106 ]
  momenta_7 = [ 154, 101 ]
  momenta_8 = [ 159, 96 ]
  momenta_9 = [ 160, 95 ]
  momenta_10 = [ 165, 90 ]
  momenta_11 = [ 170, 85 ]
  momenta_12 = [ 175, 80 ]
  momenta_13 = [ 181, 74 ]
  momenta_14 = [ 186, 69 ]
  momenta_15 = [ 191, 64 ]
  momenta_16 = [ 192, 63 ]
  momenta_17 = [ 197, 58 ]
  momenta_18 = [ 202, 53 ]
  momenta_19 = [ 207, 48 ]
  momenta_20 = [ 213, 42 ]
  momenta_21 = [ 218, 37 ]
  momenta_22 = [ 223, 32 ]
  momenta_23 = [ 229, 26 ]
  momenta_24 = [ 234, 21 ]
  momenta_25 = [ 239, 16 ]
  momenta_26 = [ 245, 10 ]
  momenta_27 = [ 250, 5 ]
  momenta_28 = [ 128, 5, 122 ]
  momenta_29 = [ 128, 10, 117 ]
  momenta_30 = [ 128, 16, 111 ]
  momenta_31 = [ 128, 21, 106 ]
  momenta_32 = [ 128, 26, 101 ]
  momenta_33 = [ 128, 32, 95 ]
  momenta_34 = [ 128, 37, 90 ]
  momenta_35 = [ 128, 42, 85 ]
  momenta_36 = [ 128, 53, 74 ]
  momenta_37 = [ 128, 58, 69 ]
  momenta_38 = [ 128, 63, 64 ]
  momenta_39 = [ 128, 85, 42 ]
  momenta_40 = [ 128, 90, 37 ]
  momenta_41 = [ 128, 95, 32 ]
  momenta_42 = [ 128, 101, 26 ]
  momenta_43 = [ 128, 106, 21 ]
  momenta_44 = [ 128, 111, 16 ]
  momenta_45 = [ 133, 16, 106 ]
  momenta_46 = [ 133, 26, 96 ]
  momenta_47 = [ 133, 32, 90 ]
  momenta_48 = [ 133, 48, 74 ]
  momenta_49 = [ 133, 58, 64 ]
  momenta_50 = [ 133, 90, 32 ]
  momenta_51 = [ 133, 96, 26 ]
  momenta_52 = [ 133, 106, 16 ]
  momenta_53 = [ 138, 16, 101 ]
  momenta_54 = [ 138, 21, 96 ]
  momenta_55 = [ 138, 32, 85 ]
  momenta_56 = [ 138, 48, 69 ]
  momenta_57 = [ 138, 53, 64 ]
  momenta_58 = [ 138, 85, 32 ]
  momenta_59 = [ 138, 96, 21 ]
  momenta_60 = [ 138, 101, 16 ]
  momenta_61 = [ 144, 5, 106 ]
  momenta_62 = [ 144, 10, 101 ]
  momenta_63 = [ 144, 37, 74 ]
  momenta_64 = [ 144, 42, 69 ]
  momenta_65 = [ 144, 69, 42 ]
  momenta_66 = [ 144, 74, 37 ]
  momenta_67 = [ 144, 101, 10 ]
  momenta_68 = [ 144, 106, 5 ]
  momenta_69 = [ 149, 10, 96 ]
  momenta_70 = [ 149, 32, 74 ]
  momenta_71 = [ 149, 42, 64 ]
  momenta_72 = [ 149, 64, 42 ]
  momenta_73 = [ 149, 74, 32 ]
  momenta_74 = [ 149, 96, 10 ]
  momenta_75 = [ 154, 5, 96 ]
  momenta_76 = [ 154, 32, 69 ]
  momenta_77 = [ 154, 37, 64 ]
  momenta_78 = [ 154, 64, 37 ]
  momenta_79 = [ 154, 69, 32 ]
  momenta_80 = [ 154, 96, 5 ]
  momenta_81 = [ 159, 32, 64 ]
  momenta_82 = [ 159, 64, 32 ]
  momenta_83 = [ 160, 5, 90 ]
  momenta_84 = [ 160, 10, 85 ]
  momenta_85 = [ 165, 10, 80 ]
  momenta_86 = [ 165, 16, 74 ]
  momenta_87 = [ 165, 26, 64 ]
  momenta_88 = [ 165, 64, 26 ]
  momenta_89 = [ 165, 74, 16 ]
  momenta_90 = [ 170, 5, 80 ]
  momenta_91 = [ 170, 16, 69 ]
  momenta_92 = [ 170, 21, 64 ]
  momenta_93 = [ 170, 64, 21 ]
  momenta_94 = [ 170, 69, 16 ]
  momenta_95 = [ 175, 16, 64 ]
  momenta_96 = [ 175, 64, 16 ]
  momenta_97 = [ 181, 10, 64 ]
  momenta_98 = [ 181, 64, 10 ]
  momenta_99 = [ 186, 5, 64 ]
  momenta_100 = [ 186, 64, 5 ]
  momenta_101 = [ 192, 5, 58 ]
  momenta_102 = [ 192, 10, 53 ]
  momenta_103 = [ 192, 37, 26 ]
  momenta_104 = [ 192, 42, 21 ]
  momenta_105 = [ 192, 53, 10 ]
  momenta_106 = [ 192, 58, 5 ]
  momenta_107 = [ 197, 10, 48 ]
  momenta_108 = [ 197, 32, 26 ]
  momenta_109 = [ 197, 42, 16 ]
  momenta_110 = [ 197, 48, 10 ]
  momenta_111 = [ 202, 5, 48 ]
  momenta_112 = [ 202, 32, 21 ]
  momenta_113 = [ 202, 37, 16 ]
  momenta_114 = [ 202, 48, 5 ]
  momenta_115 = [ 207, 32, 16 ]
  momenta_116 = [ 213, 10, 32 ]
  momenta_117 = [ 213, 32, 10 ]
  momenta_118 = [ 218, 5, 32 ]
  momenta_119 = [ 218, 32, 5 ]
  momenta_120 = [ 229, 10, 16 ]
  momenta_121 = [ 229, 16, 10 ]
  momenta_122 = [ 234, 5, 16 ]
  momenta_123 = [ 234, 16, 5 ]
  momenta_124 = [ 128, 5, 32, 90 ]
  momenta_125 = [ 128, 5, 48, 74 ]
  momenta_126 = [ 128, 5, 58, 64 ]
  momenta_127 = [ 128, 5, 90, 32 ]
  momenta_128 = [ 128, 5, 96, 26 ]
  momenta_129 = [ 128, 5, 106, 16 ]
  momenta_130 = [ 128, 10, 32, 85 ]
  momenta_131 = [ 128, 10, 48, 69 ]
  momenta_132 = [ 128, 10, 53, 64 ]
  momenta_133 = [ 128, 10, 85, 32 ]
  momenta_134 = [ 128, 10, 96, 21 ]
  momenta_135 = [ 128, 10, 101, 16 ]
  momenta_136 = [ 128, 16, 5, 106 ]
  momenta_137 = [ 128, 16, 10, 101 ]
  momenta_138 = [ 128, 16, 69, 42 ]
  momenta_139 = [ 128, 16, 74, 37 ]
  momenta_140 = [ 128, 21, 64, 42 ]
  momenta_141 = [ 128, 26, 64, 37 ]
  momenta_142 = [ 128, 32, 5, 90 ]
  momenta_143 = [ 128, 32, 10, 85 ]
  momenta_144 = [ 128, 37, 16, 74 ]
  momenta_145 = [ 128, 37, 26, 64 ]
  momenta_146 = [ 128, 37, 64, 26 ]
  momenta_147 = [ 128, 37, 74, 16 ]
  momenta_148 = [ 128, 42, 16, 69 ]
  momenta_149 = [ 128, 42, 21, 64 ]
  momenta_150 = [ 128, 42, 64, 21 ]
  momenta_151 = [ 128, 42, 69, 16 ]
  momenta_152 = [ 128, 53, 10, 64 ]
  momenta_153 = [ 128, 58, 5, 64 ]
  momenta_154 = [ 128, 101, 10, 16 ]
  momenta_155 = [ 128, 106, 5, 16 ]
  momenta_156 = [ 133, 16, 10, 96 ]
  momenta_157 = [ 133, 16, 74, 32 ]
  momenta_158 = [ 133, 26, 64, 32 ]
  momenta_159 = [ 133, 32, 16, 74 ]
  momenta_160 = [ 133, 32, 26, 64 ]
  momenta_161 = [ 133, 32, 64, 26 ]
  momenta_162 = [ 133, 32, 74, 16 ]
  momenta_163 = [ 133, 48, 10, 64 ]
  momenta_164 = [ 133, 96, 10, 16 ]
  momenta_165 = [ 138, 16, 5, 96 ]
  momenta_166 = [ 138, 16, 69, 32 ]
  momenta_167 = [ 138, 21, 64, 32 ]
  momenta_168 = [ 138, 32, 16, 69 ]
  momenta_169 = [ 138, 32, 21, 64 ]
  momenta_170 = [ 138, 32, 64, 21 ]
  momenta_171 = [ 138, 32, 69, 16 ]
  momenta_172 = [ 138, 48, 5, 64 ]
  momenta_173 = [ 138, 96, 5, 16 ]
  momenta_174 = [ 144, 5, 32, 74 ]
  momenta_175 = [ 144, 5, 64, 42 ]
  momenta_176 = [ 144, 5, 96, 10 ]
  momenta_177 = [ 144, 10, 32, 69 ]
  momenta_178 = [ 144, 10, 64, 37 ]
  momenta_179 = [ 144, 10, 96, 5 ]
  momenta_180 = [ 144, 37, 64, 10 ]
  momenta_181 = [ 144, 42, 64, 5 ]
  momenta_182 = [ 149, 10, 32, 64 ]
  momenta_183 = [ 149, 10, 64, 32 ]
  momenta_184 = [ 149, 32, 64, 10 ]
  momenta_185 = [ 154, 5, 32, 64 ]
  momenta_186 = [ 154, 5, 64, 32 ]
  momenta_187 = [ 154, 32, 64, 5 ]
  momenta_188 = [ 165, 10, 16, 64 ]
  momenta_189 = [ 165, 10, 64, 16 ]
  momenta_190 = [ 165, 16, 10, 64 ]
  momenta_191 = [ 165, 64, 10, 16 ]
  momenta_192 = [ 170, 5, 16, 64 ]
  momenta_193 = [ 170, 5, 64, 16 ]
  momenta_194 = [ 170, 16, 5, 64 ]
  momenta_195 = [ 170, 64, 5, 16 ]
  momenta_196 = [ 192, 5, 32, 26 ]
  momenta_197 = [ 192, 5, 48, 10 ]
  momenta_198 = [ 192, 10, 32, 21 ]
  momenta_199 = [ 192, 10, 48, 5 ]
  momenta_200 = [ 192, 37, 16, 10 ]
  momenta_201 = [ 192, 42, 16, 5 ]
  momenta_202 = [ 197, 10, 32, 16 ]
  momenta_203 = [ 197, 32, 16, 10 ]
  momenta_204 = [ 202, 5, 32, 16 ]
  momenta_205 = [ 202, 32, 16, 5 ]
  momenta_206 = [ 128, 5, 32, 16, 74 ]
  momenta_207 = [ 128, 5, 32, 26, 64 ]
  momenta_208 = [ 128, 5, 32, 64, 26 ]
  momenta_209 = [ 128, 5, 32, 74, 16 ]
  momenta_210 = [ 128, 5, 48, 10, 64 ]
  momenta_211 = [ 128, 5, 96, 10, 16 ]
  momenta_212 = [ 128, 10, 32, 16, 69 ]
  momenta_213 = [ 128, 10, 32, 21, 64 ]
  momenta_214 = [ 128, 10, 32, 64, 21 ]
  momenta_215 = [ 128, 10, 32, 69, 16 ]
  momenta_216 = [ 128, 10, 48, 5, 64 ]
  momenta_217 = [ 128, 10, 96, 5, 16 ]
  momenta_218 = [ 128, 16, 5, 64, 42 ]
  momenta_219 = [ 128, 16, 10, 64, 37 ]
  momenta_220 = [ 128, 37, 16, 10, 64 ]
  momenta_221 = [ 128, 37, 64, 10, 16 ]
  momenta_222 = [ 128, 42, 16, 5, 64 ]
  momenta_223 = [ 128, 42, 64, 5, 16 ]
  momenta_224 = [ 133, 16, 10, 64, 32 ]
  momenta_225 = [ 133, 32, 16, 10, 64 ]
  momenta_226 = [ 133, 32, 64, 10, 16 ]
  momenta_227 = [ 138, 16, 5, 64, 32 ]
  momenta_228 = [ 138, 32, 16, 5, 64 ]
  momenta_229 = [ 138, 32, 64, 5, 16 ]
  momenta_230 = [ 144, 5, 32, 64, 10 ]
  momenta_231 = [ 144, 10, 32, 64, 5 ]
  momenta_232 = [ 192, 5, 32, 16, 10 ]
  momenta_233 = [ 192, 10, 32, 16, 5 ]
  momenta_234 = [ 128, 5, 32, 16, 10, 64 ]
  momenta_235 = [ 128, 5, 32, 64, 10, 16 ]
  momenta_236 = [ 128, 10, 32, 16, 5, 64 ]
  momenta_237 = [ 128, 10, 32, 64, 5, 16 ]

  masses2_1 = [ 0, 0 ]
  masses2_2 = [ nMB, 0 ]
  masses2_3 = [ nMT, 0 ]
  masses2_4 = [ nMB, nMB ]
  masses2_5 = [ nMT, nMT ]
  masses2_6 = [ 0, 0, 0 ]
  masses2_7 = [ 0, 0, 0, 0 ]
  masses2_8 = [ 0, 0, 0, 0, 0 ]
  masses2_9 = [ 0, 0, 0, 0, 0, 0 ]


end subroutine  set_integral_masses_and_momenta

! **********************************************************************
subroutine integrate_tensor_sum(M2out)
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! only: ZERO, masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: a_switch
#endif
  use ol_parameters_init_/**/REALKIND, only: init_met, add_met, met_to_real
  use ol_loop_routines_/**/REALKIND, only: TI_call_OL
  implicit none
  real(REALKIND), intent(out) :: M2out
  type(met) :: M2
  call init_met(M2)

sbarray_1 = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
sbarray_2 = [16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30]
sbarray_3 = [31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 13, 43, 44]
sbarray_4 = [45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 28, 57, 58]
sbarray_5 = [59, 60, 61, 62, 15]
sbarray_6 = [1, 2, 3, 4, 5]
sbarray_7 = [1, 6, 7, 8, 9]
sbarray_8 = [2, 6, 10, 11, 12]
sbarray_9 = [3, 7, 10, 13, 14]
sbarray_10 = [63, 64, 65, 66, 30]
sbarray_11 = [16, 17, 18, 19, 20]
sbarray_12 = [16, 21, 22, 23, 24]
sbarray_13 = [17, 21, 25, 26, 27]
sbarray_14 = [18, 22, 25, 28, 29]
sbarray_15 = [67, 68, 69, 70, 44]
sbarray_16 = [31, 32, 33, 34, 35]
sbarray_17 = [31, 36, 37, 38, 39]
sbarray_18 = [32, 36, 40, 41, 42]
sbarray_19 = [33, 37, 40, 13, 43]
sbarray_20 = [71, 72, 73, 74, 58]
sbarray_21 = [45, 46, 47, 48, 49]
sbarray_22 = [45, 50, 51, 52, 53]
sbarray_23 = [46, 50, 54, 55, 56]
sbarray_24 = [47, 51, 54, 28, 57]
sbarray_25 = [34, 38, 41, 13, 44]
sbarray_26 = [4, 8, 11, 13, 15]
sbarray_27 = [48, 52, 55, 28, 58]
sbarray_28 = [19, 23, 26, 28, 30]
sbarray_29 = [75, 76, 77, 78, 79]
sbarray_30 = [80, 81, 82, 83, 79]
sbarray_31 = [84, 85, 86, 87, 88]
sbarray_32 = [89, 90, 91, 92, 88]


#ifdef LOOPSQUARED
  if (a_switch == 1 .or. a_switch == 7) then
#endif
  call TI_call_OL(0,0, momenta_198, masses2_7, T0sum(1), M2,[62], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_130, masses2_7, T0sum(2), M2,[13], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_196, masses2_7, T0sum(3), M2,[66], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_124, masses2_7, T0sum(4), M2,[28], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_177, masses2_7, T0sum(5), M2,[70], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_174, masses2_7, T0sum(6), M2,[74], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_131, masses2_7, T0sum(7), M2,[11], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_125, masses2_7, T0sum(8), M2,[26], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_134, masses2_7, T0sum(9), M2,[41], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_128, masses2_7, T0sum(10), M2,[55], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_168, masses2_7, T0sum(11), M2,[4], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_148, masses2_7, T0sum(12), M2,[8], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_159, masses2_7, T0sum(13), M2,[19], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_144, masses2_7, T0sum(14), M2,[23], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_170, masses2_7, T0sum(15), M2,[34], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_150, masses2_7, T0sum(16), M2,[38], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_161, masses2_7, T0sum(17), M2,[48], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_146, masses2_7, T0sum(18), M2,[52], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_202, masses2_7, T0sum(19), M2,[15], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_204, masses2_7, T0sum(20), M2,[30], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_182, masses2_7, T0sum(21), M2,[44], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_185, masses2_7, T0sum(22), M2,[58], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_190, masses2_7, T0sum(23), M2,[16], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_137, masses2_7, T0sum(24), M2,[78], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_156, masses2_7, T0sum(25), M2,[83], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_194, masses2_7, T0sum(26), M2,[1], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_136, masses2_7, T0sum(27), M2,[87], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_165, masses2_7, T0sum(28), M2,[92], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_205, masses2_7, T0sum(29), M2,[59], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_201, masses2_7, T0sum(30), M2,[60], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_199, masses2_7, T0sum(31), M2,[61], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_172, masses2_7, T0sum(32), M2,[2], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_169, masses2_7, T0sum(33), M2,[3], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_153, masses2_7, T0sum(34), M2,[6], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_149, masses2_7, T0sum(35), M2,[7], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_132, masses2_7, T0sum(36), M2,[10], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_203, masses2_7, T0sum(37), M2,[63], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_200, masses2_7, T0sum(38), M2,[64], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_197, masses2_7, T0sum(39), M2,[65], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_163, masses2_7, T0sum(40), M2,[17], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_160, masses2_7, T0sum(41), M2,[18], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_152, masses2_7, T0sum(42), M2,[21], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_145, masses2_7, T0sum(43), M2,[22], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_126, masses2_7, T0sum(44), M2,[25], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_187, masses2_7, T0sum(45), M2,[67], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_181, masses2_7, T0sum(46), M2,[68], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_179, masses2_7, T0sum(47), M2,[69], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_195, masses2_7, T0sum(48), M2,[31], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_173, masses2_7, T0sum(49), M2,[32], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_171, masses2_7, T0sum(50), M2,[33], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_155, masses2_7, T0sum(51), M2,[36], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_151, masses2_7, T0sum(52), M2,[37], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_135, masses2_7, T0sum(53), M2,[40], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_184, masses2_7, T0sum(54), M2,[71], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_180, masses2_7, T0sum(55), M2,[72], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_176, masses2_7, T0sum(56), M2,[73], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_191, masses2_7, T0sum(57), M2,[45], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_164, masses2_7, T0sum(58), M2,[46], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_162, masses2_7, T0sum(59), M2,[47], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_154, masses2_7, T0sum(60), M2,[50], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_147, masses2_7, T0sum(61), M2,[51], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_129, masses2_7, T0sum(62), M2,[54], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_178, masses2_7, T0sum(63), M2,[75], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_141, masses2_7, T0sum(64), M2,[76], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_139, masses2_7, T0sum(65), M2,[77], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_183, masses2_7, T0sum(66), M2,[80], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_158, masses2_7, T0sum(67), M2,[81], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_157, masses2_7, T0sum(68), M2,[82], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_175, masses2_7, T0sum(69), M2,[84], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_140, masses2_7, T0sum(70), M2,[85], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_138, masses2_7, T0sum(71), M2,[86], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_186, masses2_7, T0sum(72), M2,[89], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_167, masses2_7, T0sum(73), M2,[90], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_166, masses2_7, T0sum(74), M2,[91], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_133, masses2_7, T0sum(75), M2)
  call TI_call_OL(0,0, momenta_127, masses2_7, T0sum(76), M2)
  call TI_call_OL(0,0, momenta_143, masses2_7, T0sum(77), M2)
  call TI_call_OL(0,0, momenta_188, masses2_7, T0sum(78), M2)
  call TI_call_OL(0,0, momenta_189, masses2_7, T0sum(79), M2)
  call TI_call_OL(0,0, momenta_142, masses2_7, T0sum(80), M2)
  call TI_call_OL(0,0, momenta_192, masses2_7, T0sum(81), M2)
  call TI_call_OL(0,0, momenta_193, masses2_7, T0sum(82), M2)
  call TI_call_OL(0,0, momenta_91, masses2_6, T0sum(83), M2)
  call TI_call_OL(0,0, momenta_86, masses2_6, T0sum(84), M2)
  call TI_call_OL(0,0, momenta_29, masses2_6, T0sum(85), M2)
  call TI_call_OL(0,0, momenta_28, masses2_6, T0sum(86), M2)
  call TI_call_OL(0,0, momenta_117, masses2_6, T0sum(87), M2)
  call TI_call_OL(0,0, momenta_33, masses2_6, T0sum(88), M2)
  call TI_call_OL(0,0, momenta_116, masses2_6, T0sum(89), M2)
  call TI_call_OL(0,0, momenta_120, masses2_6, T0sum(90), M2)
  call TI_call_OL(0,0, momenta_85, masses2_6, T0sum(91), M2)
  call TI_call_OL(0,0, momenta_97, masses2_6, T0sum(92), M2)
  call TI_call_OL(0,0, momenta_119, masses2_6, T0sum(93), M2)
  call TI_call_OL(0,0, momenta_118, masses2_6, T0sum(94), M2)
  call TI_call_OL(0,0, momenta_122, masses2_6, T0sum(95), M2)
  call TI_call_OL(0,0, momenta_90, masses2_6, T0sum(96), M2)
  call TI_call_OL(0,0, momenta_99, masses2_6, T0sum(97), M2)
  call TI_call_OL(0,0, momenta_112, masses2_6, T0sum(98), M2)
  call TI_call_OL(0,0, momenta_104, masses2_6, T0sum(99), M2)
  call TI_call_OL(0,0, momenta_102, masses2_6, T0sum(100), M2)
  call TI_call_OL(0,0, momenta_55, masses2_6, T0sum(101), M2)
  call TI_call_OL(0,0, momenta_35, masses2_6, T0sum(102), M2)
  call TI_call_OL(0,0, momenta_108, masses2_6, T0sum(103), M2)
  call TI_call_OL(0,0, momenta_103, masses2_6, T0sum(104), M2)
  call TI_call_OL(0,0, momenta_101, masses2_6, T0sum(105), M2)
  call TI_call_OL(0,0, momenta_47, masses2_6, T0sum(106), M2)
  call TI_call_OL(0,0, momenta_34, masses2_6, T0sum(107), M2)
  call TI_call_OL(0,0, momenta_76, masses2_6, T0sum(108), M2)
  call TI_call_OL(0,0, momenta_64, masses2_6, T0sum(109), M2)
  call TI_call_OL(0,0, momenta_62, masses2_6, T0sum(110), M2)
  call TI_call_OL(0,0, momenta_70, masses2_6, T0sum(111), M2)
  call TI_call_OL(0,0, momenta_63, masses2_6, T0sum(112), M2)
  call TI_call_OL(0,0, momenta_61, masses2_6, T0sum(113), M2)
  call TI_call_OL(0,0, momenta_107, masses2_6, T0sum(114), M2)
  call TI_call_OL(0,0, momenta_56, masses2_6, T0sum(115), M2)
  call TI_call_OL(0,0, momenta_37, masses2_6, T0sum(116), M2)
  call TI_call_OL(0,0, momenta_111, masses2_6, T0sum(117), M2)
  call TI_call_OL(0,0, momenta_48, masses2_6, T0sum(118), M2)
  call TI_call_OL(0,0, momenta_36, masses2_6, T0sum(119), M2)
  call TI_call_OL(0,0, momenta_69, masses2_6, T0sum(120), M2)
  call TI_call_OL(0,0, momenta_59, masses2_6, T0sum(121), M2)
  call TI_call_OL(0,0, momenta_43, masses2_6, T0sum(122), M2)
  call TI_call_OL(0,0, momenta_75, masses2_6, T0sum(123), M2)
  call TI_call_OL(0,0, momenta_51, masses2_6, T0sum(124), M2)
  call TI_call_OL(0,0, momenta_42, masses2_6, T0sum(125), M2)
  call TI_call_OL(0,0, momenta_115, masses2_6, T0sum(126), M2)
  call TI_call_OL(0,0, momenta_109, masses2_6, T0sum(127), M2)
  call TI_call_OL(0,0, momenta_113, masses2_6, T0sum(128), M2)
  call TI_call_OL(0,0, momenta_81, masses2_6, T0sum(129), M2)
  call TI_call_OL(0,0, momenta_93, masses2_6, T0sum(130), M2)
  call TI_call_OL(0,0, momenta_71, masses2_6, T0sum(131), M2)
  call TI_call_OL(0,0, momenta_88, masses2_6, T0sum(132), M2)
  call TI_call_OL(0,0, momenta_77, masses2_6, T0sum(133), M2)
  call TI_call_OL(0,0, momenta_121, masses2_6, T0sum(134), M2)
  call TI_call_OL(0,0, momenta_87, masses2_6, T0sum(135), M2)
  call TI_call_OL(0,0, momenta_32, masses2_6, T0sum(136), M2)
  call TI_call_OL(0,0, momenta_30, masses2_6, T0sum(137), M2)
  call TI_call_OL(0,0, momenta_46, masses2_6, T0sum(138), M2)
  call TI_call_OL(0,0, momenta_45, masses2_6, T0sum(139), M2)
  call TI_call_OL(0,0, momenta_123, masses2_6, T0sum(140), M2)
  call TI_call_OL(0,0, momenta_92, masses2_6, T0sum(141), M2)
  call TI_call_OL(0,0, momenta_31, masses2_6, T0sum(142), M2)
  call TI_call_OL(0,0, momenta_54, masses2_6, T0sum(143), M2)
  call TI_call_OL(0,0, momenta_53, masses2_6, T0sum(144), M2)
  call TI_call_OL(0,0, momenta_114, masses2_6, T0sum(145), M2)
  call TI_call_OL(0,0, momenta_106, masses2_6, T0sum(146), M2)
  call TI_call_OL(0,0, momenta_57, masses2_6, T0sum(147), M2)
  call TI_call_OL(0,0, momenta_38, masses2_6, T0sum(148), M2)
  call TI_call_OL(0,0, momenta_110, masses2_6, T0sum(149), M2)
  call TI_call_OL(0,0, momenta_105, masses2_6, T0sum(150), M2)
  call TI_call_OL(0,0, momenta_49, masses2_6, T0sum(151), M2)
  call TI_call_OL(0,0, momenta_100, masses2_6, T0sum(152), M2)
  call TI_call_OL(0,0, momenta_80, masses2_6, T0sum(153), M2)
  call TI_call_OL(0,0, momenta_68, masses2_6, T0sum(154), M2)
  call TI_call_OL(0,0, momenta_94, masses2_6, T0sum(155), M2)
  call TI_call_OL(0,0, momenta_60, masses2_6, T0sum(156), M2)
  call TI_call_OL(0,0, momenta_44, masses2_6, T0sum(157), M2)
  call TI_call_OL(0,0, momenta_98, masses2_6, T0sum(158), M2)
  call TI_call_OL(0,0, momenta_74, masses2_6, T0sum(159), M2)
  call TI_call_OL(0,0, momenta_67, masses2_6, T0sum(160), M2)
  call TI_call_OL(0,0, momenta_89, masses2_6, T0sum(161), M2)
  call TI_call_OL(0,0, momenta_52, masses2_6, T0sum(162), M2)
  call TI_call_OL(0,0, momenta_78, masses2_6, T0sum(163), M2)
  call TI_call_OL(0,0, momenta_66, masses2_6, T0sum(164), M2)
  call TI_call_OL(0,0, momenta_40, masses2_6, T0sum(165), M2)
  call TI_call_OL(0,0, momenta_82, masses2_6, T0sum(166), M2)
  call TI_call_OL(0,0, momenta_73, masses2_6, T0sum(167), M2)
  call TI_call_OL(0,0, momenta_50, masses2_6, T0sum(168), M2)
  call TI_call_OL(0,0, momenta_72, masses2_6, T0sum(169), M2)
  call TI_call_OL(0,0, momenta_65, masses2_6, T0sum(170), M2)
  call TI_call_OL(0,0, momenta_39, masses2_6, T0sum(171), M2)
  call TI_call_OL(0,0, momenta_79, masses2_6, T0sum(172), M2)
  call TI_call_OL(0,0, momenta_58, masses2_6, T0sum(173), M2)
  call TI_call_OL(0,0, momenta_84, masses2_6, T0sum(174), M2)
  call TI_call_OL(0,0, momenta_41, masses2_6, T0sum(175), M2)
  call TI_call_OL(0,0, momenta_83, masses2_6, T0sum(176), M2)
  call TI_call_OL(0,0, momenta_95, masses2_6, T0sum(177), M2)
  call TI_call_OL(0,0, momenta_96, masses2_6, T0sum(178), M2)
  call TI_call_OL(0,0, momenta_25, masses2_1, T0sum(179), M2)
  call TI_call_OL(0,0, momenta_14, masses2_1, T0sum(180), M2)
  call TI_call_OL(0,0, momenta_11, masses2_1, T0sum(181), M2)
  call TI_call_OL(0,0, momenta_13, masses2_1, T0sum(182), M2)
  call TI_call_OL(0,0, momenta_10, masses2_1, T0sum(183), M2)
  call TI_call_OL(0,0, momenta_26, masses2_1, T0sum(184), M2)
  call TI_call_OL(0,0, momenta_4, masses2_1, T0sum(185), M2)
  call TI_call_OL(0,0, momenta_2, masses2_1, T0sum(186), M2)
  call TI_call_OL(0,0, momenta_27, masses2_1, T0sum(187), M2)
  call TI_call_OL(0,0, momenta_3, masses2_1, T0sum(188), M2)
  call TI_call_OL(0,0, momenta_22, masses2_1, T0sum(189), M2)
  call TI_call_OL(0,0, momenta_20, masses2_1, T0sum(190), M2)
  call TI_call_OL(0,0, momenta_9, masses2_1, T0sum(191), M2)
  call TI_call_OL(0,0, momenta_23, masses2_1, T0sum(192), M2)
  call TI_call_OL(0,0, momenta_12, masses2_1, T0sum(193), M2)
  call TI_call_OL(0,0, momenta_15, masses2_1, T0sum(194), M2)
  call TI_call_OL(0,0, momenta_21, masses2_1, T0sum(195), M2)
  call TI_call_OL(0,0, momenta_24, masses2_1, T0sum(196), M2)
  call TI_call_OL(0,0, momenta_18, masses2_1, T0sum(197), M2)
  call TI_call_OL(0,0, momenta_16, masses2_1, T0sum(198), M2)
  call TI_call_OL(0,0, momenta_17, masses2_1, T0sum(199), M2)
  call TI_call_OL(0,0, momenta_7, masses2_1, T0sum(200), M2)
  call TI_call_OL(0,0, momenta_5, masses2_1, T0sum(201), M2)
  call TI_call_OL(0,0, momenta_6, masses2_1, T0sum(202), M2)
  call TI_call_OL(0,0, momenta_19, masses2_1, T0sum(203), M2)
  call TI_call_OL(0,0, momenta_8, masses2_1, T0sum(204), M2)
  call TI_call_OL(0,0, momenta_11, masses2_5, T0sum(205), M2)
  call TI_call_OL(0,0, momenta_1, masses2_3, T0sum(206), M2)
  call TI_call_OL(0,0, momenta_11, masses2_4, T0sum(207), M2)
  call TI_call_OL(0,0, momenta_1, masses2_2, T0sum(208), M2)
  call TI_call_OL(0,0, momenta_10, masses2_5, T0sum(209), M2)
  call TI_call_OL(0,0, momenta_10, masses2_4, T0sum(210), M2)

  call TI_call_OL(0,1, momenta_236, masses2_9, T1sum(1), M2,sbarray_1, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_234, masses2_9, T1sum(2), M2,sbarray_2, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_237, masses2_9, T1sum(3), M2,sbarray_3, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_235, masses2_9, T1sum(4), M2,sbarray_4, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_233, masses2_8, T1sum(5), M2,sbarray_5, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_228, masses2_8, T1sum(6), M2,sbarray_6, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_222, masses2_8, T1sum(7), M2,sbarray_7, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_216, masses2_8, T1sum(8), M2,sbarray_8, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_213, masses2_8, T1sum(9), M2,sbarray_9, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_232, masses2_8, T1sum(10), M2,sbarray_10, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_225, masses2_8, T1sum(11), M2,sbarray_11, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_220, masses2_8, T1sum(12), M2,sbarray_12, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_210, masses2_8, T1sum(13), M2,sbarray_13, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_207, masses2_8, T1sum(14), M2,sbarray_14, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_231, masses2_8, T1sum(15), M2,sbarray_15, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_229, masses2_8, T1sum(16), M2,sbarray_16, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_223, masses2_8, T1sum(17), M2,sbarray_17, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_217, masses2_8, T1sum(18), M2,sbarray_18, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_215, masses2_8, T1sum(19), M2,sbarray_19, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_230, masses2_8, T1sum(20), M2,sbarray_20, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_226, masses2_8, T1sum(21), M2,sbarray_21, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_221, masses2_8, T1sum(22), M2,sbarray_22, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_211, masses2_8, T1sum(23), M2,sbarray_23, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_209, masses2_8, T1sum(24), M2,sbarray_24, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_214, masses2_8, T1sum(25), M2,sbarray_25, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_212, masses2_8, T1sum(26), M2,sbarray_26, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_208, masses2_8, T1sum(27), M2,sbarray_27, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_206, masses2_8, T1sum(28), M2,sbarray_28, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_219, masses2_8, T1sum(29), M2,sbarray_29, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_224, masses2_8, T1sum(30), M2,sbarray_30, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_218, masses2_8, T1sum(31), M2,sbarray_31, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_227, masses2_8, T1sum(32), M2,sbarray_32, ScalarBoxes(:))

  call add_met(M2,M2L1R1)

#ifdef LOOPSQUARED
  end if
#endif

  call met_to_real(M2out,M2)

#ifdef PRECISION_dp
  call HOL_memory_deallocation_/**/REALKIND(1)
  call HCL_memory_deallocation_/**/REALKIND(1)
#endif

end subroutine integrate_tensor_sum

end module ol_tensor_sum_storage_ppllnnjj_ew_nexnmxemucdxsx_1_/**/REALKIND
