
module ol_colourmatrix_ppllnnjj_ew_nexnmxemucdxsx_4_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(38,1), K2(1,1), KL(1,1), Cas(8) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [ 9]
  K1( 2,:) = [ 0]
  K1( 3,:) = [ 0]
  K1( 4,:) = [ 0]
  K1( 5,:) = [ 0]
  K1( 6,:) = [ 0]
  K1( 7,:) = [ 0]
  K1( 8,:) = [ 0]
  K1( 9,:) = [ 0]
  K1(10,:) = [ 0]
  K1(11,:) = [ 0]
  K1(12,:) = [ 0]
  K1(13,:) = [ 0]
  K1(14,:) = [ 0]
  K1(15,:) = [ 0]
  K1(16,:) = [ 0]
  K1(17,:) = [ 0]
  K1(18,:) = [ 0]
  K1(19,:) = [ 0]
  K1(20,:) = [ 0]
  K1(21,:) = [ 0]
  K1(22,:) = [ 0]
  K1(23,:) = [ 0]
  K1(24,:) = [ 0]
  K1(25,:) = [ 0]
  K1(26,:) = [ 0]
  K1(27,:) = [ 0]
  K1(28,:) = [ 0]
  K1(29,:) = [ 0]
  K1(30,:) = [ 0]
  K1(31,:) = [ 0]
  K1(32,:) = [ 0]
  K1(33,:) = [ 0]
  K1(34,:) = [ 0]
  K1(35,:) = [ 0]
  K1(36,:) = [ 0]
  K1(37,:) = [ 0]
  K1(38,:) = [ 9]

  K2(1,:) = [ 9]

  KL(1,:) = [ 9]

#if -1 > 0
    co = 0
    do k = 1, 8
      co = co + k
      Cas(k) = K1(1+1*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_ppllnnjj_ew_nexnmxemucdxsx_4_/**/REALKIND



module ol_forced_parameters_ppllnnjj_ew_nexnmxemucdxsx_4_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (MM /= 0) write(*,101) 'MM = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppllnnjj_ew_nexnmxemucdxsx_4_/**/REALKIND


! **********************************************************************
module ol_loop_storage_ppllnnjj_ew_nexnmxemucdxsx_4_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 256 ! number of helicity configurations
  integer(intkind2), save :: nhel = 256 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: hel_states = 256 ! number of helicity configurations needed for mem-allocation
  integer(intkind2), save :: Hel(256) ! physical helicity states
#endif

  type(Hpolcont), save, allocatable :: A(:,:), M1helarray(:,:), M1helarray_ct(:,:)
  complex(REALKIND), save :: den(2149)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2), ex7(2), ex8(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,17), wf8(8,160), wf16(16,298), wf32(32,328), wf64(64,304), wf256(256,1310)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(292), c(262)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save, allocatable :: M0_col1_helarray(:,:), M0M1_hel_cc(:,:,:)
  complex(REALKIND), save :: M2ctcc(37)

end module ol_loop_storage_ppllnnjj_ew_nexnmxemucdxsx_4_/**/REALKIND






! **********************************************************************
module ol_loop_ppllnnjj_ew_nexnmxemucdxsx_4_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppllnnjj_ew_nexnmxemucdxsx_4_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(  1) = (CI*eQED**6)/(8._/**/REALKIND*sw**6)
    f(  2) = (CI*eQED**6)/(4._/**/REALKIND*sw**6)
    f(  3) = (CI*cw**2*eQED**6)/(4._/**/REALKIND*sw**6)
    f(  4) = (CI*countertermnorm*eQED**8)/(8._/**/REALKIND*sw**6)
    f(  5) = (CI*countertermnorm*eQED**8)/(4._/**/REALKIND*sw**6)
    f(  6) = (CI*countertermnorm*cw**2*eQED**8)/(4._/**/REALKIND*sw**6)
    f(  7) = (CI*countertermnorm*eQED**8*EWctVdu)/(8._/**/REALKIND*sw**6)
    f(  8) = (CI*countertermnorm*eQED**8*EWctVdu)/(4._/**/REALKIND*sw**6)
    f(  9) = (CI*countertermnorm*cw**2*eQED**8*EWctVdu)/(4._/**/REALKIND*sw**6)
    f( 10) = (CI*countertermnorm*eQED**8*EWctVen)/(8._/**/REALKIND*sw**6)
    f( 11) = (CI*countertermnorm*eQED**8*EWctVen)/(4._/**/REALKIND*sw**6)
    f( 12) = (CI*countertermnorm*cw**2*eQED**8*EWctVen)/(4._/**/REALKIND*sw**6)
    f( 13) = (CI*countertermnorm*eQED**8*EWctVne)/(8._/**/REALKIND*sw**6)
    f( 14) = (CI*countertermnorm*eQED**8*EWctVud)/(8._/**/REALKIND*sw**6)
    f( 15) = (CI*countertermnorm*eQED**8*MW)/(8._/**/REALKIND*sw**6)
    f( 16) = (CI*eQED**6*MW**2)/(4._/**/REALKIND*sw**6)
    f( 17) = (CI*countertermnorm*eQED**8*MW**2)/(4._/**/REALKIND*sw**6)
    f( 18) = (CI*countertermnorm*eQED**8*EWctVdu*MW**2)/(4._/**/REALKIND*sw**6)
    f( 19) = (CI*countertermnorm*eQED**8*EWctVen*MW**2)/(4._/**/REALKIND*sw**6)
    f( 20) = (CI*cw*eQED**6)/(4._/**/REALKIND*sw**5)
    f( 21) = (CI*countertermnorm*cw*eQED**8)/(12._/**/REALKIND*sw**5)
    f( 22) = (CI*countertermnorm*cw*eQED**8)/(6._/**/REALKIND*sw**5)
    f( 23) = (CI*countertermnorm*cw*eQED**8)/(4._/**/REALKIND*sw**5)
    f( 24) = (CI*countertermnorm*cw*eQED**8*EWctVdu)/(4._/**/REALKIND*sw**5)
    f( 25) = (CI*countertermnorm*cw*eQED**8*EWctVen)/(4._/**/REALKIND*sw**5)
    f( 26) = (CI*countertermnorm*cw*eQED**8*EWctZWW)/(4._/**/REALKIND*sw**5)
    f( 27) = (CI*countertermnorm*eQED**8*EWctHWW*MW)/(4._/**/REALKIND*sw**5)
    f( 28) = (CI*countertermnorm*eQED**8*sqrt2)/(8._/**/REALKIND*sw**5)
    f( 29) = (CI*eQED**6)/(36._/**/REALKIND*sw**4)
    f( 30) = (CI*eQED**6)/(18._/**/REALKIND*sw**4)
    f( 31) = (CI*eQED**6)/(12._/**/REALKIND*sw**4)
    f( 32) = (CI*eQED**6)/(9._/**/REALKIND*sw**4)
    f( 33) = (CI*eQED**6)/(6._/**/REALKIND*sw**4)
    f( 34) = (CI*eQED**6)/(4._/**/REALKIND*sw**4)
    f( 35) = (CI*countertermnorm*eQED**8)/(36._/**/REALKIND*sw**4)
    f( 36) = (CI*countertermnorm*eQED**8)/(18._/**/REALKIND*sw**4)
    f( 37) = (CI*countertermnorm*eQED**8)/(12._/**/REALKIND*sw**4)
    f( 38) = (CI*countertermnorm*eQED**8)/(9._/**/REALKIND*sw**4)
    f( 39) = (CI*countertermnorm*eQED**8)/(6._/**/REALKIND*sw**4)
    f( 40) = (CI*countertermnorm*eQED**8)/(4._/**/REALKIND*sw**4)
    f( 41) = (CI*countertermnorm*eQED**8*EWctAWW)/(12._/**/REALKIND*sw**4)
    f( 42) = (CI*countertermnorm*eQED**8*EWctAWW)/(6._/**/REALKIND*sw**4)
    f( 43) = (CI*countertermnorm*eQED**8*EWctAWW)/(4._/**/REALKIND*sw**4)
    f( 44) = (CI*countertermnorm*eQED**8*EWctVdu)/(36._/**/REALKIND*sw**4)
    f( 45) = (CI*countertermnorm*eQED**8*EWctVdu)/(18._/**/REALKIND*sw**4)
    f( 46) = (CI*countertermnorm*eQED**8*EWctVdu)/(12._/**/REALKIND*sw**4)
    f( 47) = (CI*countertermnorm*eQED**8*EWctVdu)/(9._/**/REALKIND*sw**4)
    f( 48) = (CI*countertermnorm*eQED**8*EWctVdu)/(6._/**/REALKIND*sw**4)
    f( 49) = (CI*countertermnorm*eQED**8*EWctVdu)/(4._/**/REALKIND*sw**4)
    f( 50) = (CI*countertermnorm*eQED**8*EWctVen)/(36._/**/REALKIND*sw**4)
    f( 51) = (CI*countertermnorm*eQED**8*EWctVen)/(18._/**/REALKIND*sw**4)
    f( 52) = (CI*countertermnorm*eQED**8*EWctVen)/(12._/**/REALKIND*sw**4)
    f( 53) = (CI*countertermnorm*eQED**8*EWctVen)/(9._/**/REALKIND*sw**4)
    f( 54) = (CI*countertermnorm*eQED**8*EWctVen)/(6._/**/REALKIND*sw**4)
    f( 55) = (CI*countertermnorm*eQED**8*EWctVen)/(4._/**/REALKIND*sw**4)
    f( 56) = (CI*countertermnorm*eQED**8*EWctZWW)/(4._/**/REALKIND*sw**4)
    f( 57) = (CI*countertermnorm*eQED**8*MW)/(12._/**/REALKIND*sw**4)
    f( 58) = (CI*countertermnorm*eQED**8*MW)/(6._/**/REALKIND*sw**4)
    f( 59) = (CI*countertermnorm*eQED**8*MW)/(4._/**/REALKIND*sw**4)
    f( 60) = (CI*countertermnorm*eQED**8*MW)/(4._/**/REALKIND*cw*sw**3)
    f( 61) = (CI*countertermnorm*eQED**8*sqrt2)/(12._/**/REALKIND*sw**3)
    f( 62) = (CI*countertermnorm*eQED**8*sqrt2)/(6._/**/REALKIND*sw**3)
    f( 63) = (CI*countertermnorm*eQED**8*sqrt2)/(4._/**/REALKIND*sw**3)
    f( 64) = (CI*countertermnorm*eQED**8*sqrt2)/(4._/**/REALKIND*cw*sw**2)
    f( 65) = (eQED**8*integralnorm*MW**4*SwB)/(cw**4*4._/**/REALKIND)
    f( 66) = (eQED**8*integralnorm*SwB)/(sw**8*64._/**/REALKIND)
    f( 67) = (eQED**8*integralnorm*SwB)/(sw**8*32._/**/REALKIND)
    f( 68) = (eQED**8*integralnorm*SwB)/(sw**8*16._/**/REALKIND)
    f( 69) = (eQED**8*integralnorm*SwB)/(sw**8*8._/**/REALKIND)
    f( 70) = (eQED**8*integralnorm*SwB)/(sw**8*4._/**/REALKIND)
    f( 71) = (cw**2*eQED**8*integralnorm*SwB)/(sw**8*16._/**/REALKIND)
    f( 72) = (cw**2*eQED**8*integralnorm*SwB)/(sw**8*8._/**/REALKIND)
    f( 73) = (cw**2*eQED**8*integralnorm*SwB)/(sw**8*4._/**/REALKIND)
    f( 74) = (cw**4*eQED**8*integralnorm*SwB)/(sw**8*8._/**/REALKIND)
    f( 75) = (cw**4*eQED**8*integralnorm*SwB)/(sw**8*4._/**/REALKIND)
    f( 76) = (eQED**8*integralnorm*MH**2*SwB)/(sw**8*32._/**/REALKIND)
    f( 77) = (eQED**8*integralnorm*MH**2*SwB)/(sw**8*16._/**/REALKIND)
    f( 78) = (3*eQED**8*integralnorm*lambdaHHH*MH**2*SwB)/(sw**8*32._/**/REALKIND)
    f( 79) = (eQED**8*integralnorm*MH**4*SwB)/(sw**8*32._/**/REALKIND)
    f( 80) = (eQED**8*integralnorm*MH**4*SwB)/(sw**8*16._/**/REALKIND)
    f( 81) = (9*eQED**8*integralnorm*lambdaHHH**2*MH**4*SwB)/(sw**8*32._/**/REALKIND)
    f( 82) = (eQED**8*integralnorm*MW**2*SwB)/(sw**8*16._/**/REALKIND)
    f( 83) = (eQED**8*integralnorm*MW**2*SwB)/(sw**8*8._/**/REALKIND)
    f( 84) = (eQED**8*integralnorm*MW**2*SwB)/(sw**8*4._/**/REALKIND)
    f( 85) = (eQED**8*integralnorm*MW**2*SwB)/(cw**2*sw**8*16._/**/REALKIND)
    f( 86) = (eQED**8*integralnorm*MW**2*SwB)/(cw**2*sw**8*4._/**/REALKIND)
    f( 87) = (cw**2*eQED**8*integralnorm*MW**2*SwB)/(sw**8*8._/**/REALKIND)
    f( 88) = (cw**2*eQED**8*integralnorm*MW**2*SwB)/(sw**8*4._/**/REALKIND)
    f( 89) = (3*eQED**8*integralnorm*lambdaHHH*MH**2*MW**2*SwB)/(sw**8*8._/**/REALKIND)
    f( 90) = (eQED**8*integralnorm*MW**4*SwB)/(sw**8*16._/**/REALKIND)
    f( 91) = (eQED**8*integralnorm*MW**4*SwB)/(sw**8*4._/**/REALKIND)
    f( 92) = (eQED**8*integralnorm*MW**4*SwB)/(cw**4*sw**8*16._/**/REALKIND)
    f( 93) = (eQED**8*integralnorm*MW**4*SwB)/(cw**4*sw**8*8._/**/REALKIND)
    f( 94) = (eQED**8*integralnorm*SwB)/(cw*sw**7*32._/**/REALKIND)
    f( 95) = (eQED**8*integralnorm*SwB)/(cw*sw**7*16._/**/REALKIND)
    f( 96) = (cw*eQED**8*integralnorm*SwB)/(sw**7*16._/**/REALKIND)
    f( 97) = (cw*eQED**8*integralnorm*SwB)/(sw**7*8._/**/REALKIND)
    f( 98) = (cw*eQED**8*integralnorm*SwB)/(sw**7*4._/**/REALKIND)
    f( 99) = (cw**3*eQED**8*integralnorm*SwB)/(sw**7*4._/**/REALKIND)
    f(100) = (eQED**8*integralnorm*MW**2*SwB)/(cw**3*sw**7*4._/**/REALKIND)
    f(101) = (eQED**8*integralnorm*MW**2*SwB)/(cw*sw**7*4._/**/REALKIND)
    f(102) = (cw*eQED**8*integralnorm*MW**2*SwB)/(sw**7*8._/**/REALKIND)
    f(103) = (cw*eQED**8*integralnorm*MW**2*SwB)/(sw**7*4._/**/REALKIND)
    f(104) = (eQED**8*integralnorm*SwB)/(sw**6*144._/**/REALKIND)
    f(105) = (eQED**8*integralnorm*SwB)/(sw**6*72._/**/REALKIND)
    f(106) = (eQED**8*integralnorm*SwB)/(sw**6*48._/**/REALKIND)
    f(107) = (eQED**8*integralnorm*SwB)/(sw**6*36._/**/REALKIND)
    f(108) = (eQED**8*integralnorm*SwB)/(sw**6*24._/**/REALKIND)
    f(109) = (eQED**8*integralnorm*SwB)/(sw**6*18._/**/REALKIND)
    f(110) = (eQED**8*integralnorm*SwB)/(sw**6*16._/**/REALKIND)
    f(111) = (eQED**8*integralnorm*SwB)/(sw**6*12._/**/REALKIND)
    f(112) = (eQED**8*integralnorm*SwB)/(sw**6*9._/**/REALKIND)
    f(113) = (eQED**8*integralnorm*SwB)/(sw**6*8._/**/REALKIND)
    f(114) = (eQED**8*integralnorm*SwB)/(sw**6*6._/**/REALKIND)
    f(115) = (eQED**8*integralnorm*SwB)/(sw**6*4._/**/REALKIND)
    f(116) = (eQED**8*integralnorm*SwB)/(cw**2*sw**6*16._/**/REALKIND)
    f(117) = (cw**2*eQED**8*integralnorm*SwB)/(sw**6*36._/**/REALKIND)
    f(118) = (cw**2*eQED**8*integralnorm*SwB)/(sw**6*18._/**/REALKIND)
    f(119) = (cw**2*eQED**8*integralnorm*SwB)/(sw**6*12._/**/REALKIND)
    f(120) = (cw**2*eQED**8*integralnorm*SwB)/(sw**6*9._/**/REALKIND)
    f(121) = (cw**2*eQED**8*integralnorm*SwB)/(sw**6*6._/**/REALKIND)
    f(122) = (cw**2*eQED**8*integralnorm*SwB)/(sw**6*4._/**/REALKIND)
    f(123) = (eQED**8*integralnorm*MH**2*SwB)/(sw**6*48._/**/REALKIND)
    f(124) = (eQED**8*integralnorm*MH**2*SwB)/(sw**6*24._/**/REALKIND)
    f(125) = (eQED**8*integralnorm*MH**2*SwB)/(sw**6*16._/**/REALKIND)
    f(126) = (eQED**8*integralnorm*MH**2*SwB)/(sw**6*12._/**/REALKIND)
    f(127) = (eQED**8*integralnorm*MH**2*SwB)/(sw**6*8._/**/REALKIND)
    f(128) = (eQED**8*integralnorm*MW**2*SwB)/(sw**6*36._/**/REALKIND)
    f(129) = (eQED**8*integralnorm*MW**2*SwB)/(sw**6*24._/**/REALKIND)
    f(130) = (eQED**8*integralnorm*MW**2*SwB)/(sw**6*18._/**/REALKIND)
    f(131) = (eQED**8*integralnorm*MW**2*SwB)/(sw**6*16._/**/REALKIND)
    f(132) = (eQED**8*integralnorm*MW**2*SwB)/(sw**6*12._/**/REALKIND)
    f(133) = (eQED**8*integralnorm*MW**2*SwB)/(sw**6*9._/**/REALKIND)
    f(134) = (eQED**8*integralnorm*MW**2*SwB)/(sw**6*8._/**/REALKIND)
    f(135) = (eQED**8*integralnorm*MW**2*SwB)/(sw**6*6._/**/REALKIND)
    f(136) = (eQED**8*integralnorm*MW**2*SwB)/(sw**6*4._/**/REALKIND)
    f(137) = (eQED**8*integralnorm*MW**2*SwB)/(cw**4*sw**6*4._/**/REALKIND)
    f(138) = (eQED**8*integralnorm*MW**2*SwB)/(cw**2*sw**6*16._/**/REALKIND)
    f(139) = (eQED**8*integralnorm*MW**2*SwB)/(cw**2*sw**6*8._/**/REALKIND)
    f(140) = (eQED**8*integralnorm*MW**2*SwB)/(cw**2*sw**6*4._/**/REALKIND)
    f(141) = (cw**2*eQED**8*integralnorm*MW**2*SwB)/(sw**6*4._/**/REALKIND)
    f(142) = (eQED**8*integralnorm*MH**2*MW**2*SwB)/(sw**6*8._/**/REALKIND)
    f(143) = (eQED**8*integralnorm*MW**4*SwB)/(sw**6*4._/**/REALKIND)
    f(144) = (eQED**8*integralnorm*SwB)/(cw*sw**5*16._/**/REALKIND)
    f(145) = (cw*eQED**8*integralnorm*SwB)/(sw**5*36._/**/REALKIND)
    f(146) = (cw*eQED**8*integralnorm*SwB)/(sw**5*18._/**/REALKIND)
    f(147) = (cw*eQED**8*integralnorm*SwB)/(sw**5*12._/**/REALKIND)
    f(148) = (cw*eQED**8*integralnorm*SwB)/(sw**5*9._/**/REALKIND)
    f(149) = (cw*eQED**8*integralnorm*SwB)/(sw**5*6._/**/REALKIND)
    f(150) = (cw*eQED**8*integralnorm*SwB)/(sw**5*4._/**/REALKIND)
    f(151) = (eQED**8*integralnorm*MH**2*SwB)/(cw*sw**5*16._/**/REALKIND)
    f(152) = (eQED**8*integralnorm*MW**2*SwB)/(cw**3*sw**5*8._/**/REALKIND)
    f(153) = (eQED**8*integralnorm*MW**2*SwB)/(cw*sw**5*8._/**/REALKIND)
    f(154) = (cw*eQED**8*integralnorm*MW**2*SwB)/(sw**5*4._/**/REALKIND)
    f(155) = (eQED**8*integralnorm*SwB)/(sw**4*324._/**/REALKIND)
    f(156) = (eQED**8*integralnorm*SwB)/(sw**4*162._/**/REALKIND)
    f(157) = (eQED**8*integralnorm*SwB)/(sw**4*108._/**/REALKIND)
    f(158) = (eQED**8*integralnorm*SwB)/(sw**4*81._/**/REALKIND)
    f(159) = (eQED**8*integralnorm*SwB)/(sw**4*54._/**/REALKIND)
    f(160) = (2*eQED**8*integralnorm*SwB)/(sw**4*81._/**/REALKIND)
    f(161) = (eQED**8*integralnorm*SwB)/(sw**4*36._/**/REALKIND)
    f(162) = (eQED**8*integralnorm*SwB)/(sw**4*27._/**/REALKIND)
    f(163) = (4*eQED**8*integralnorm*SwB)/(sw**4*81._/**/REALKIND)
    f(164) = (eQED**8*integralnorm*SwB)/(sw**4*18._/**/REALKIND)
    f(165) = (2*eQED**8*integralnorm*SwB)/(sw**4*27._/**/REALKIND)
    f(166) = (eQED**8*integralnorm*SwB)/(sw**4*12._/**/REALKIND)
    f(167) = (eQED**8*integralnorm*SwB)/(sw**4*9._/**/REALKIND)
    f(168) = (eQED**8*integralnorm*SwB)/(sw**4*8._/**/REALKIND)
    f(169) = (eQED**8*integralnorm*SwB)/(sw**4*6._/**/REALKIND)
    f(170) = (eQED**8*integralnorm*SwB)/(sw**4*4._/**/REALKIND)
    f(171) = (eQED**8*integralnorm*MW**2*SwB)/(sw**4*36._/**/REALKIND)
    f(172) = (eQED**8*integralnorm*MW**2*SwB)/(sw**4*18._/**/REALKIND)
    f(173) = (eQED**8*integralnorm*MW**2*SwB)/(sw**4*12._/**/REALKIND)
    f(174) = (eQED**8*integralnorm*MW**2*SwB)/(sw**4*9._/**/REALKIND)
    f(175) = (eQED**8*integralnorm*MW**2*SwB)/(sw**4*6._/**/REALKIND)
    f(176) = (eQED**8*integralnorm*MW**2*SwB)/(sw**4*4._/**/REALKIND)
    f(177) = (eQED**8*integralnorm*MW**2*SwB)/(cw**2*sw**4*16._/**/REALKIND)
    f(178) = (eQED**8*integralnorm*MW**2*SwB)/(cw**2*sw**4*8._/**/REALKIND)
    f(179) = (eQED**8*integralnorm*MW**2*SwB)/(cw**2*sw**4*4._/**/REALKIND)
    f(180) = (eQED**8*integralnorm*MH**2*MW**2*SwB)/(cw**2*sw**4*8._/**/REALKIND)
    f(181) = (eQED**8*integralnorm*MW**4*SwB)/(sw**4*4._/**/REALKIND)
    f(182) = (eQED**8*integralnorm*MW**4*SwB)/(cw**4*sw**4*4._/**/REALKIND)
    f(183) = (eQED**8*integralnorm*MW**4*SwB)/(cw**2*sw**4*4._/**/REALKIND)
    f(184) = (eQED**8*integralnorm*MW**2*SwB)/(cw*sw**3*12._/**/REALKIND)
    f(185) = (eQED**8*integralnorm*MW**2*SwB)/(cw*sw**3*6._/**/REALKIND)
    f(186) = (eQED**8*integralnorm*MW**2*SwB)/(cw*sw**3*4._/**/REALKIND)
    f(187) = (eQED**8*integralnorm*MW**2*SwB)/(cw**2*sw**2*36._/**/REALKIND)
    f(188) = (eQED**8*integralnorm*MW**2*SwB)/(cw**2*sw**2*18._/**/REALKIND)
    f(189) = (eQED**8*integralnorm*MW**2*SwB)/(cw**2*sw**2*12._/**/REALKIND)
    f(190) = (eQED**8*integralnorm*MW**2*SwB)/(cw**2*sw**2*9._/**/REALKIND)
    f(191) = (eQED**8*integralnorm*MW**2*SwB)/(cw**2*sw**2*6._/**/REALKIND)
    f(192) = (eQED**8*integralnorm*MW**2*SwB)/(cw**2*sw**2*4._/**/REALKIND)
    f(193) = (eQED**8*integralnorm*MW**4*SwB)/(cw**2*sw**2*4._/**/REALKIND)
    f(194) = -((eQED**8*integralnorm*(cw - sw)*(cw + sw)*SwB)/(sw**8*32._/**/REALKIND))
    f(195) = -((eQED**8*integralnorm*(cw - sw)*(cw + sw)*SwB)/(sw**8*16._/**/REALKIND))
    f(196) = -((eQED**8*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(sw**8*16._/**/REALKIND))
    f(197) = -((eQED**8*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(sw**8*16._/**/REALKIND))
    f(198) = -((eQED**8*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**7*32._/**/REALKIND))
    f(199) = -((eQED**8*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**7*16._/**/REALKIND))
    f(200) = -((eQED**8*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw**7*16._/**/REALKIND))
    f(201) = -((eQED**8*integralnorm*(cw - sw)*(cw + sw)*SwB)/(sw**6*24._/**/REALKIND))
    f(202) = (eQED**8*integralnorm*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(sw**8*16._/**/REALKIND*8._/**/REALKIND)
    f(203) = -((eQED**8*integralnorm*(cw - sw)*(cw + sw)*SwB)/(sw**6*12._/**/REALKIND))
    f(204) = -((eQED**8*integralnorm*(cw - sw)*(cw + sw)*SwB)/(sw**6*8._/**/REALKIND))
    f(205) = -((eQED**8*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(sw**6*24._/**/REALKIND))
    f(206) = -((eQED**8*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(sw**6*12._/**/REALKIND))
    f(207) = -((eQED**8*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(sw**6*8._/**/REALKIND))
    f(208) = (eQED**8*integralnorm*MW**2*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**6*16._/**/REALKIND)
    f(209) = -((eQED**8*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**5*24._/**/REALKIND))
    f(210) = (eQED**8*integralnorm*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw*sw**7*16._/**/REALKIND*8._/**/REALKIND)
    f(211) = -((eQED**8*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**5*12._/**/REALKIND))
    f(212) = -((eQED**8*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**5*8._/**/REALKIND))
    f(213) = -((eQED**8*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw**5*8._/**/REALKIND))
    f(214) = (eQED**8*integralnorm*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw**2*sw**6*16._/**/REALKIND*8._/**/REALKIND)
    f(215) = (eQED**8*integralnorm*MW**2*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**4*24._/**/REALKIND)
    f(216) = (eQED**8*integralnorm*MW**2*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**4*12._/**/REALKIND)
    f(217) = (eQED**8*integralnorm*MW**2*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**4*8._/**/REALKIND)
    f(218) = -((eQED**8*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**3*8._/**/REALKIND))
    f(219) = (eQED**8*integralnorm*SwF)/(sw**8*16._/**/REALKIND)
    f(220) = (eQED**8*integralnorm*SwF)/(sw**8*8._/**/REALKIND)
    f(221) = (eQED**8*integralnorm*SwF)/(sw**8*4._/**/REALKIND)
    f(222) = (cw**2*eQED**8*integralnorm*SwF)/(sw**8*8._/**/REALKIND)
    f(223) = (cw**2*eQED**8*integralnorm*SwF)/(sw**8*4._/**/REALKIND)
    f(224) = (eQED**8*integralnorm*MB*SwF)/(sw**8*16._/**/REALKIND)
    f(225) = (eQED**8*integralnorm*MB**2*SwF)/(sw**8*16._/**/REALKIND)
    f(226) = (eQED**8*integralnorm*ML*SwF)/(sw**8*16._/**/REALKIND)
    f(227) = (eQED**8*integralnorm*ML**2*SwF)/(sw**8*16._/**/REALKIND)
    f(228) = (eQED**8*integralnorm*MT*SwF)/(sw**8*16._/**/REALKIND)
    f(229) = (eQED**8*integralnorm*MT**2*SwF)/(sw**8*16._/**/REALKIND)
    f(230) = (eQED**8*integralnorm*MW**2*SwF)/(sw**8*8._/**/REALKIND)
    f(231) = (eQED**8*integralnorm*MW**2*SwF)/(sw**8*4._/**/REALKIND)
    f(232) = (cw*eQED**8*integralnorm*SwF)/(sw**7*8._/**/REALKIND)
    f(233) = (cw*eQED**8*integralnorm*SwF)/(sw**7*4._/**/REALKIND)
    f(234) = (cw*eQED**8*integralnorm*MB*SwF)/(sw**7*8._/**/REALKIND)
    f(235) = (cw*eQED**8*integralnorm*ML*SwF)/(sw**7*8._/**/REALKIND)
    f(236) = (cw*eQED**8*integralnorm*MT*SwF)/(sw**7*8._/**/REALKIND)
    f(237) = (eQED**8*integralnorm*SwF)/(sw**6*72._/**/REALKIND)
    f(238) = (eQED**8*integralnorm*SwF)/(sw**6*36._/**/REALKIND)
    f(239) = (eQED**8*integralnorm*SwF)/(sw**6*24._/**/REALKIND)
    f(240) = (eQED**8*integralnorm*SwF)/(sw**6*18._/**/REALKIND)
    f(241) = (eQED**8*integralnorm*SwF)/(sw**6*12._/**/REALKIND)
    f(242) = (eQED**8*integralnorm*SwF)/(sw**6*9._/**/REALKIND)
    f(243) = (eQED**8*integralnorm*SwF)/(sw**6*8._/**/REALKIND)
    f(244) = (eQED**8*integralnorm*SwF)/(sw**6*6._/**/REALKIND)
    f(245) = (eQED**8*integralnorm*SwF)/(sw**6*4._/**/REALKIND)
    f(246) = (cw**2*eQED**8*integralnorm*SwF)/(sw**6*4._/**/REALKIND)
    f(247) = (cw**2*eQED**8*integralnorm*SwF)/(sw**6*2._/**/REALKIND)
    f(248) = (3*cw**2*eQED**8*integralnorm*SwF)/(sw**6*4._/**/REALKIND)
    f(249) = (eQED**8*integralnorm*MB*SwF)/(sw**6*72._/**/REALKIND)
    f(250) = (eQED**8*integralnorm*MB*SwF)/(sw**6*36._/**/REALKIND)
    f(251) = (eQED**8*integralnorm*MB*SwF)/(sw**6*24._/**/REALKIND)
    f(252) = (eQED**8*integralnorm*MB*SwF)/(sw**6*8._/**/REALKIND)
    f(253) = (eQED**8*integralnorm*ML*SwF)/(sw**6*24._/**/REALKIND)
    f(254) = (eQED**8*integralnorm*ML*SwF)/(sw**6*12._/**/REALKIND)
    f(255) = (eQED**8*integralnorm*ML*SwF)/(sw**6*8._/**/REALKIND)
    f(256) = (eQED**8*integralnorm*MT*SwF)/(sw**6*36._/**/REALKIND)
    f(257) = (eQED**8*integralnorm*MT*SwF)/(sw**6*18._/**/REALKIND)
    f(258) = (eQED**8*integralnorm*MT*SwF)/(sw**6*12._/**/REALKIND)
    f(259) = (eQED**8*integralnorm*MT*SwF)/(sw**6*8._/**/REALKIND)
    f(260) = (eQED**8*integralnorm*SwF)/(cw*sw**5*8._/**/REALKIND)
    f(261) = (cw*eQED**8*integralnorm*SwF)/(sw**5*36._/**/REALKIND)
    f(262) = (cw*eQED**8*integralnorm*SwF)/(sw**5*18._/**/REALKIND)
    f(263) = (cw*eQED**8*integralnorm*SwF)/(sw**5*12._/**/REALKIND)
    f(264) = (cw*eQED**8*integralnorm*SwF)/(sw**5*9._/**/REALKIND)
    f(265) = (cw*eQED**8*integralnorm*SwF)/(sw**5*6._/**/REALKIND)
    f(266) = (2*cw*eQED**8*integralnorm*SwF)/(sw**5*9._/**/REALKIND)
    f(267) = (cw*eQED**8*integralnorm*SwF)/(sw**5*4._/**/REALKIND)
    f(268) = (cw*eQED**8*integralnorm*SwF)/(sw**5*3._/**/REALKIND)
    f(269) = (cw*eQED**8*integralnorm*SwF)/(sw**5*2._/**/REALKIND)
    f(270) = (3*cw*eQED**8*integralnorm*SwF)/(sw**5*4._/**/REALKIND)
    f(271) = (eQED**8*integralnorm*ML*SwF)/(cw*sw**5*8._/**/REALKIND)
    f(272) = (eQED**8*integralnorm*SwF)/(sw**4*324._/**/REALKIND)
    f(273) = (eQED**8*integralnorm*SwF)/(sw**4*162._/**/REALKIND)
    f(274) = (eQED**8*integralnorm*SwF)/(sw**4*108._/**/REALKIND)
    f(275) = (eQED**8*integralnorm*SwF)/(sw**4*81._/**/REALKIND)
    f(276) = (eQED**8*integralnorm*SwF)/(sw**4*54._/**/REALKIND)
    f(277) = (2*eQED**8*integralnorm*SwF)/(sw**4*81._/**/REALKIND)
    f(278) = (eQED**8*integralnorm*SwF)/(sw**4*36._/**/REALKIND)
    f(279) = (eQED**8*integralnorm*SwF)/(sw**4*27._/**/REALKIND)
    f(280) = (4*eQED**8*integralnorm*SwF)/(sw**4*81._/**/REALKIND)
    f(281) = (eQED**8*integralnorm*SwF)/(sw**4*18._/**/REALKIND)
    f(282) = (2*eQED**8*integralnorm*SwF)/(sw**4*27._/**/REALKIND)
    f(283) = (eQED**8*integralnorm*SwF)/(sw**4*12._/**/REALKIND)
    f(284) = (8*eQED**8*integralnorm*SwF)/(sw**4*81._/**/REALKIND)
    f(285) = (eQED**8*integralnorm*SwF)/(sw**4*9._/**/REALKIND)
    f(286) = (4*eQED**8*integralnorm*SwF)/(sw**4*27._/**/REALKIND)
    f(287) = (eQED**8*integralnorm*SwF)/(sw**4*6._/**/REALKIND)
    f(288) = (2*eQED**8*integralnorm*SwF)/(sw**4*9._/**/REALKIND)
    f(289) = (eQED**8*integralnorm*SwF)/(sw**4*4._/**/REALKIND)
    f(290) = (eQED**8*integralnorm*SwF)/(sw**4*3._/**/REALKIND)
    f(291) = (eQED**8*integralnorm*SwF)/(sw**4*2._/**/REALKIND)
    f(292) = (3*eQED**8*integralnorm*SwF)/(sw**4*4._/**/REALKIND)

  c = [ f(65), f(66), f(67), f(68), f(69), f(70), f(71), f(72), f(73), f(74), f(75), f(76), f(77), f(78), f(79), f(80), f(81) &
    , f(82), f(83), f(84), f(85), f(86), f(87), f(88), f(89), f(90), f(91), f(92), f(93), f(94), f(95), f(96), f(97), f(98), f(99) &
    , f(100), f(101), f(102), f(103), f(104), f(105), f(106), f(107), f(108), f(109), f(110), f(111), f(112), f(113), f(114) &
    , f(115), f(116), f(117), f(118), f(119), f(120), f(121), f(122), f(123), f(124), f(125), f(126), f(127), f(128), f(129) &
    , f(130), f(131), f(132), f(133), f(134), f(135), f(136), f(137), f(138), f(139), f(140), f(141), f(142), f(143), f(144) &
    , f(145), f(146), f(147), f(148), f(149), f(150), f(151), f(152), f(153), f(154), f(155), f(156), f(157), f(158), f(159) &
    , f(160), f(161), f(162), f(163), f(164), f(165), f(166), f(167), f(168), f(169), f(170), f(171), f(172), f(173), f(174) &
    , f(175), f(176), f(177), f(178), f(179), f(180), f(181), f(182), f(183), f(184), f(185), f(186), f(187), f(188), f(189) &
    , f(190), f(191), f(192), f(193), f(194), f(195), f(196), f(197), f(198), f(199), f(200), f(201), f(202), f(203), f(204) &
    , f(205), f(206), f(207), f(208), f(209), f(210), f(211), f(212), f(213), f(214), f(215), f(216), f(217), f(218), f(219) &
    , 3*f(219), f(220), 3*f(220), f(221), 3*f(221), f(222), 3*f(222), f(223), 3*f(223), 3*f(224), 3*f(225), f(226), f(227) &
    , 3*f(228), 3*f(229), f(230), 3*f(230), f(231), 3*f(231), f(232), 3*f(232), f(233), 3*f(233), 3*f(234), f(235), 3*f(236) &
    , f(237), 3*f(237), f(238), 3*f(238), f(239), 3*f(239), f(240), 3*f(240), f(241), 3*f(241), f(242), 3*f(242), f(243), 3*f(243) &
    , f(244), 3*f(244), f(245), 3*f(245), f(246), 3*f(246), f(247), 3*f(247), f(248), 3*f(249), 3*f(250), 3*f(251), 3*f(252) &
    , f(253), f(254), f(255), 3*f(256), 3*f(257), 3*f(258), 3*f(259), 3*f(260), 3*f(261), 3*f(262), f(263), 3*f(263), 3*f(264) &
    , f(265), 3*f(265), 3*f(266), f(267), 3*f(267), f(268), 3*f(268), f(269), 3*f(269), f(270), f(271), 3*f(272), 3*f(273) &
    , 3*f(274), 3*f(275), 3*f(276), 3*f(277), f(278), 3*f(278), 3*f(279), 3*f(280), f(281), 3*f(281), 3*f(282), f(283), 3*f(283) &
    , 3*f(284), f(285), 3*f(285), 3*f(286), f(287), 3*f(287), f(288), 3*f(288), f(289), 3*f(289), f(290), 3*f(290), f(291) &
    , 3*f(291), f(292) ]
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,5) - MW2)+L(6,5))
  den(2) = 1 /((L(5,10) - MW2)+L(6,10))
  den(3) = 1 /((L(5,80) - MW2)+L(6,80))
  den(4) = 1 /((L(5,160) - MW2)+L(6,160))
  den(9) = 1 /((L(5,85) - MH2)+L(6,85))
  den(12) = 1 /((L(5,85))+L(6,85))
  den(15) = 1 /((L(5,85) - MZ2)+L(6,85))
  den(20) = 1 /((L(5,165) - MH2)+L(6,165))
  den(23) = 1 /((L(5,165))+L(6,165))
  den(26) = 1 /((L(5,165) - MZ2)+L(6,165))
  den(29) = 1 /((L(5,37))+L(6,37))
  den(31) = 1 /((L(5,138))+L(6,138))
  den(35) = 1 /((L(5,90))+L(6,90))
  den(38) = 1 /((L(5,90) - MZ2)+L(6,90))
  den(41) = 1 /((L(5,42))+L(6,42))
  den(43) = 1 /((L(5,133))+L(6,133))
  den(53) = 1 /((L(5,21))+L(6,21))
  den(55) = 1 /((L(5,74))+L(6,74))
  den(59) = 1 /((L(5,170))+L(6,170))
  den(62) = 1 /((L(5,170) - MZ2)+L(6,170))
  den(65) = 1 /((L(5,26))+L(6,26))
  den(67) = 1 /((L(5,69))+L(6,69))
  den(105) = 1 /((L(5,82))+L(6,82))
  den(109) = 1 /((L(5,162))+L(6,162))
  den(113) = 1 /((L(5,88))+L(6,88))
  den(116) = 1 /((L(5,168))+L(6,168))
  den(141) = 1 /((L(5,81))+L(6,81))
  den(145) = 1 /((L(5,161))+L(6,161))
  den(149) = 1 /((L(5,84))+L(6,84))
  den(152) = 1 /((L(5,164))+L(6,164))
  den(187) = 1 /((L(5,90) - MH2)+L(6,90))
  den(192) = 1 /((L(5,170) - MH2)+L(6,170))
  den(198) = 1 /((L(5,250) - MW2)+L(6,250))
  den(202) = 1 /((L(5,245) - MW2)+L(6,245))
  den(206) = 1 /((L(5,175) - MW2)+L(6,175))
  den(209) = 1 /((L(5,95) - MW2)+L(6,95))
  den(335) = 1 /((L(5,122))+L(6,122))
  den(351) = 1 /((L(5,117))+L(6,117))
  den(372) = 1 /((L(5,218))+L(6,218))
  den(379) = 1 /((L(5,213))+L(6,213))
  den(417) = 1 /((L(5,186))+L(6,186))
  den(433) = 1 /((L(5,181))+L(6,181))
  den(442) = 1 /((L(5,234))+L(6,234))
  den(449) = 1 /((L(5,229))+L(6,229))
  den(606) = 1 /((L(5,173))+L(6,173))
  den(611) = 1 /((L(5,93))+L(6,93))
  den(616) = 1 /((L(5,167))+L(6,167))
  den(619) = 1 /((L(5,87))+L(6,87))
  den(740) = 1 /((L(5,174))+L(6,174))
  den(745) = 1 /((L(5,94))+L(6,94))
  den(750) = 1 /((L(5,171))+L(6,171))
  den(753) = 1 /((L(5,91))+L(6,91))

  ! denominators
  den(5) = den(1)*den(2)*den(3)
  den(6) = den(4)*den(5)
  den(7) = den(1)*den(3)
  den(8) = den(2)*den(4)
  den(10) = den(7)*den(9)
  den(11) = den(8)*den(10)
  den(13) = den(7)*den(12)
  den(14) = den(8)*den(13)
  den(16) = den(7)*den(15)
  den(17) = den(8)*den(16)
  den(18) = den(1)*den(4)
  den(19) = den(2)*den(3)
  den(21) = den(18)*den(20)
  den(22) = den(19)*den(21)
  den(24) = den(18)*den(23)
  den(25) = den(19)*den(24)
  den(27) = den(18)*den(26)
  den(28) = den(19)*den(27)
  den(30) = den(1)*den(29)
  den(32) = den(2)*den(31)
  den(33) = den(3)*den(30)
  den(34) = den(32)*den(33)
  den(36) = den(19)*den(35)
  den(37) = den(30)*den(36)
  den(39) = den(19)*den(38)
  den(40) = den(30)*den(39)
  den(42) = den(2)*den(41)
  den(44) = den(1)*den(43)
  den(45) = den(3)*den(42)
  den(46) = den(44)*den(45)
  den(47) = den(36)*den(44)
  den(48) = den(39)*den(44)
  den(49) = den(13)*den(42)
  den(50) = den(16)*den(42)
  den(51) = den(13)*den(32)
  den(52) = den(16)*den(32)
  den(54) = den(1)*den(53)
  den(56) = den(2)*den(55)
  den(57) = den(4)*den(54)
  den(58) = den(56)*den(57)
  den(60) = den(8)*den(59)
  den(61) = den(54)*den(60)
  den(63) = den(8)*den(62)
  den(64) = den(54)*den(63)
  den(66) = den(2)*den(65)
  den(68) = den(1)*den(67)
  den(69) = den(4)*den(66)
  den(70) = den(68)*den(69)
  den(71) = den(60)*den(68)
  den(72) = den(63)*den(68)
  den(73) = den(24)*den(66)
  den(74) = den(27)*den(66)
  den(75) = den(24)*den(56)
  den(76) = den(27)*den(56)
  den(77) = den(12)*den(54)
  den(78) = den(42)*den(77)
  den(79) = den(15)*den(54)
  den(80) = den(42)*den(79)
  den(81) = den(32)*den(59)
  den(82) = den(54)*den(81)
  den(83) = den(32)*den(62)
  den(84) = den(54)*den(83)
  den(85) = den(35)*den(66)
  den(86) = den(30)*den(85)
  den(87) = den(38)*den(66)
  den(88) = den(30)*den(87)
  den(89) = den(35)*den(56)
  den(90) = den(30)*den(89)
  den(91) = den(38)*den(56)
  den(92) = den(30)*den(91)
  den(93) = den(12)*den(68)
  den(94) = den(42)*den(93)
  den(95) = den(15)*den(68)
  den(96) = den(42)*den(95)
  den(97) = den(32)*den(93)
  den(98) = den(32)*den(95)
  den(99) = den(23)*den(44)
  den(100) = den(66)*den(99)
  den(101) = den(26)*den(44)
  den(102) = den(66)*den(101)
  den(103) = den(44)*den(89)
  den(104) = den(44)*den(91)
  den(106) = den(3)*den(105)
  den(107) = den(24)*den(106)
  den(108) = den(27)*den(106)
  den(110) = den(4)*den(109)
  den(111) = den(13)*den(110)
  den(112) = den(16)*den(110)
  den(114) = den(3)*den(113)
  den(115) = den(27)*den(114)
  den(117) = den(4)*den(116)
  den(118) = den(16)*den(117)
  den(119) = den(1)*den(106)
  den(120) = den(117)*den(119)
  den(121) = den(1)*den(110)
  den(122) = den(114)*den(121)
  den(123) = den(35)*den(106)
  den(124) = den(30)*den(123)
  den(125) = den(38)*den(106)
  den(126) = den(30)*den(125)
  den(127) = den(38)*den(114)
  den(128) = den(30)*den(127)
  den(129) = den(44)*den(123)
  den(130) = den(44)*den(125)
  den(131) = den(44)*den(127)
  den(132) = den(59)*den(110)
  den(133) = den(54)*den(132)
  den(134) = den(62)*den(110)
  den(135) = den(54)*den(134)
  den(136) = den(62)*den(117)
  den(137) = den(54)*den(136)
  den(138) = den(68)*den(136)
  den(139) = den(68)*den(132)
  den(140) = den(68)*den(134)
  den(142) = den(3)*den(141)
  den(143) = den(60)*den(142)
  den(144) = den(63)*den(142)
  den(146) = den(4)*den(145)
  den(147) = den(36)*den(146)
  den(148) = den(39)*den(146)
  den(150) = den(3)*den(149)
  den(151) = den(63)*den(150)
  den(153) = den(4)*den(152)
  den(154) = den(39)*den(153)
  den(155) = den(2)*den(142)
  den(156) = den(153)*den(155)
  den(157) = den(2)*den(146)
  den(158) = den(150)*den(157)
  den(159) = den(12)*den(142)
  den(160) = den(42)*den(159)
  den(161) = den(15)*den(142)
  den(162) = den(42)*den(161)
  den(163) = den(32)*den(159)
  den(164) = den(32)*den(161)
  den(165) = den(15)*den(150)
  den(166) = den(32)*den(165)
  den(167) = den(42)*den(165)
  den(168) = den(26)*den(153)
  den(169) = den(56)*den(168)
  den(170) = den(23)*den(146)
  den(171) = den(66)*den(170)
  den(172) = den(26)*den(146)
  den(173) = den(66)*den(172)
  den(174) = den(56)*den(170)
  den(175) = den(56)*den(172)
  den(176) = den(66)*den(168)
  den(177) = den(117)*den(165)
  den(178) = den(114)*den(168)
  den(179) = den(106)*den(168)
  den(180) = den(110)*den(165)
  den(181) = den(136)*den(142)
  den(182) = den(110)*den(159)
  den(183) = den(110)*den(161)
  den(184) = den(127)*den(146)
  den(185) = den(106)*den(170)
  den(186) = den(106)*den(172)
  den(188) = den(19)*den(187)
  den(189) = den(18)*den(188)
  den(190) = den(18)*den(36)
  den(191) = den(18)*den(39)
  den(193) = den(8)*den(192)
  den(194) = den(7)*den(193)
  den(195) = den(7)*den(60)
  den(196) = den(7)*den(63)
  den(197) = den(2)*den(3)*den(4)
  den(199) = den(197)*den(198)
  den(200) = den(1)*den(199)
  den(201) = den(1)*den(3)*den(4)
  den(203) = den(201)*den(202)
  den(204) = den(2)*den(203)
  den(205) = den(1)*den(2)*den(4)
  den(207) = den(205)*den(206)
  den(208) = den(3)*den(207)
  den(210) = den(5)*den(209)
  den(211) = den(4)*den(210)
  den(212) = den(42)*den(59)
  den(213) = den(54)*den(212)
  den(214) = den(42)*den(62)
  den(215) = den(54)*den(214)
  den(216) = den(23)*den(30)
  den(217) = den(66)*den(216)
  den(218) = den(26)*den(30)
  den(219) = den(66)*den(218)
  den(220) = den(32)*den(77)
  den(221) = den(32)*den(79)
  den(222) = den(44)*den(85)
  den(223) = den(44)*den(87)
  den(224) = den(56)*den(216)
  den(225) = den(56)*den(218)
  den(226) = den(68)*den(212)
  den(227) = den(68)*den(214)
  den(228) = den(68)*den(81)
  den(229) = den(68)*den(83)
  den(230) = den(56)*den(99)
  den(231) = den(56)*den(101)
  den(232) = den(106)*den(216)
  den(233) = den(106)*den(218)
  den(234) = den(99)*den(106)
  den(235) = den(101)*den(106)
  den(236) = den(77)*den(110)
  den(237) = den(79)*den(110)
  den(238) = den(93)*den(110)
  den(239) = den(95)*den(110)
  den(240) = den(142)*den(212)
  den(241) = den(142)*den(214)
  den(242) = den(81)*den(142)
  den(243) = den(83)*den(142)
  den(244) = den(85)*den(146)
  den(245) = den(87)*den(146)
  den(246) = den(89)*den(146)
  den(247) = den(91)*den(146)
  den(248) = den(132)*den(142)
  den(249) = den(134)*den(142)
  den(250) = den(123)*den(146)
  den(251) = den(125)*den(146)
  den(252) = den(24)*den(114)
  den(253) = den(13)*den(117)
  den(254) = den(114)*den(216)
  den(255) = den(114)*den(218)
  den(256) = den(99)*den(114)
  den(257) = den(101)*den(114)
  den(258) = den(77)*den(117)
  den(259) = den(79)*den(117)
  den(260) = den(93)*den(117)
  den(261) = den(95)*den(117)
  den(262) = den(117)*den(159)
  den(263) = den(117)*den(161)
  den(264) = den(114)*den(170)
  den(265) = den(114)*den(172)
  den(266) = den(60)*den(150)
  den(267) = den(36)*den(153)
  den(268) = den(81)*den(150)
  den(269) = den(83)*den(150)
  den(270) = den(150)*den(212)
  den(271) = den(150)*den(214)
  den(272) = den(89)*den(153)
  den(273) = den(91)*den(153)
  den(274) = den(85)*den(153)
  den(275) = den(87)*den(153)
  den(276) = den(136)*den(150)
  den(277) = den(127)*den(153)
  den(278) = den(123)*den(153)
  den(279) = den(125)*den(153)
  den(280) = den(132)*den(150)
  den(281) = den(134)*den(150)
  den(282) = den(1)**2
  den(283) = den(3)*den(282)
  den(284) = den(193)*den(283)
  den(285) = den(60)*den(283)
  den(286) = den(63)*den(283)
  den(287) = den(4)*den(282)
  den(288) = den(188)*den(287)
  den(289) = den(36)*den(287)
  den(290) = den(39)*den(287)
  den(291) = den(2)**2
  den(292) = den(3)*den(291)
  den(293) = den(21)*den(292)
  den(294) = den(24)*den(292)
  den(295) = den(27)*den(292)
  den(296) = den(4)*den(291)
  den(297) = den(10)*den(296)
  den(298) = den(13)*den(296)
  den(299) = den(16)*den(296)
  den(300) = den(3)**2
  den(301) = den(1)*den(300)
  den(302) = den(193)*den(301)
  den(303) = den(60)*den(301)
  den(304) = den(63)*den(301)
  den(305) = den(2)*den(300)
  den(306) = den(21)*den(305)
  den(307) = den(24)*den(305)
  den(308) = den(27)*den(305)
  den(309) = den(4)**2
  den(310) = den(1)*den(309)
  den(311) = den(188)*den(310)
  den(312) = den(36)*den(310)
  den(313) = den(39)*den(310)
  den(314) = den(2)*den(309)
  den(315) = den(10)*den(314)
  den(316) = den(13)*den(314)
  den(317) = den(16)*den(314)
  den(318) = den(10)*den(193)
  den(319) = den(13)*den(60)
  den(320) = den(13)*den(63)
  den(321) = den(16)*den(60)
  den(322) = den(16)*den(63)
  den(323) = den(21)*den(188)
  den(324) = den(24)*den(36)
  den(325) = den(27)*den(36)
  den(326) = den(24)*den(39)
  den(327) = den(27)*den(39)
  den(328) = den(3)*den(32)
  den(329) = den(29)*den(282)
  den(330) = den(328)*den(329)
  den(331) = den(36)*den(329)
  den(332) = den(39)*den(329)
  den(333) = den(43)*den(282)
  den(334) = den(45)*den(333)
  den(336) = den(36)*den(335)
  den(337) = den(282)*den(336)
  den(338) = den(39)*den(335)
  den(339) = den(282)*den(338)
  den(340) = den(212)*den(283)
  den(341) = den(214)*den(283)
  den(342) = den(81)*den(283)
  den(343) = den(83)*den(283)
  den(344) = den(3)*den(44)
  den(345) = den(41)*den(291)
  den(346) = den(344)*den(345)
  den(347) = den(13)*den(345)
  den(348) = den(16)*den(345)
  den(349) = den(31)*den(291)
  den(350) = den(33)*den(349)
  den(352) = den(13)*den(351)
  den(353) = den(291)*den(352)
  den(354) = den(16)*den(351)
  den(355) = den(291)*den(354)
  den(356) = den(216)*den(292)
  den(357) = den(218)*den(292)
  den(358) = den(99)*den(292)
  den(359) = den(101)*den(292)
  den(360) = den(30)*den(300)
  den(361) = den(32)*den(360)
  den(362) = den(216)*den(305)
  den(363) = den(218)*den(305)
  den(364) = den(42)*den(300)
  den(365) = den(44)*den(364)
  den(366) = den(99)*den(305)
  den(367) = den(101)*den(305)
  den(368) = den(212)*den(301)
  den(369) = den(214)*den(301)
  den(370) = den(81)*den(301)
  den(371) = den(83)*den(301)
  den(373) = den(36)*den(372)
  den(374) = den(30)*den(373)
  den(375) = den(39)*den(372)
  den(376) = den(30)*den(375)
  den(377) = den(44)*den(336)
  den(378) = den(44)*den(338)
  den(380) = den(13)*den(379)
  den(381) = den(42)*den(380)
  den(382) = den(16)*den(379)
  den(383) = den(42)*den(382)
  den(384) = den(32)*den(352)
  den(385) = den(32)*den(354)
  den(386) = den(328)*den(372)
  den(387) = den(30)*den(386)
  den(388) = den(344)*den(379)
  den(389) = den(42)*den(388)
  den(390) = den(36)*den(99)
  den(391) = den(39)*den(99)
  den(392) = den(36)*den(101)
  den(393) = den(39)*den(101)
  den(394) = den(13)*den(81)
  den(395) = den(16)*den(81)
  den(396) = den(13)*den(83)
  den(397) = den(16)*den(83)
  den(398) = den(33)*den(351)
  den(399) = den(32)*den(398)
  den(400) = den(36)*den(216)
  den(401) = den(39)*den(216)
  den(402) = den(36)*den(218)
  den(403) = den(39)*den(218)
  den(404) = den(45)*den(335)
  den(405) = den(44)*den(404)
  den(406) = den(13)*den(212)
  den(407) = den(16)*den(212)
  den(408) = den(13)*den(214)
  den(409) = den(16)*den(214)
  den(410) = den(4)*den(56)
  den(411) = den(53)*den(282)
  den(412) = den(410)*den(411)
  den(413) = den(60)*den(411)
  den(414) = den(63)*den(411)
  den(415) = den(67)*den(282)
  den(416) = den(69)*den(415)
  den(418) = den(60)*den(417)
  den(419) = den(282)*den(418)
  den(420) = den(63)*den(417)
  den(421) = den(282)*den(420)
  den(422) = den(85)*den(287)
  den(423) = den(87)*den(287)
  den(424) = den(89)*den(287)
  den(425) = den(91)*den(287)
  den(426) = den(4)*den(68)
  den(427) = den(65)*den(291)
  den(428) = den(426)*den(427)
  den(429) = den(24)*den(427)
  den(430) = den(27)*den(427)
  den(431) = den(55)*den(291)
  den(432) = den(57)*den(431)
  den(434) = den(24)*den(433)
  den(435) = den(291)*den(434)
  den(436) = den(27)*den(433)
  den(437) = den(291)*den(436)
  den(438) = den(77)*den(296)
  den(439) = den(79)*den(296)
  den(440) = den(93)*den(296)
  den(441) = den(95)*den(296)
  den(443) = den(60)*den(442)
  den(444) = den(54)*den(443)
  den(445) = den(63)*den(442)
  den(446) = den(54)*den(445)
  den(447) = den(68)*den(418)
  den(448) = den(68)*den(420)
  den(450) = den(24)*den(449)
  den(451) = den(66)*den(450)
  den(452) = den(27)*den(449)
  den(453) = den(66)*den(452)
  den(454) = den(56)*den(434)
  den(455) = den(56)*den(436)
  den(456) = den(410)*den(442)
  den(457) = den(54)*den(456)
  den(458) = den(426)*den(449)
  den(459) = den(66)*den(458)
  den(460) = den(60)*den(93)
  den(461) = den(63)*den(93)
  den(462) = den(60)*den(95)
  den(463) = den(63)*den(95)
  den(464) = den(24)*den(89)
  den(465) = den(27)*den(89)
  den(466) = den(24)*den(91)
  den(467) = den(27)*den(91)
  den(468) = den(54)*den(309)
  den(469) = den(56)*den(468)
  den(470) = den(77)*den(314)
  den(471) = den(79)*den(314)
  den(472) = den(66)*den(309)
  den(473) = den(68)*den(472)
  den(474) = den(93)*den(314)
  den(475) = den(95)*den(314)
  den(476) = den(85)*den(310)
  den(477) = den(87)*den(310)
  den(478) = den(89)*den(310)
  den(479) = den(91)*den(310)
  den(480) = den(57)*den(433)
  den(481) = den(56)*den(480)
  den(482) = den(60)*den(77)
  den(483) = den(63)*den(77)
  den(484) = den(60)*den(79)
  den(485) = den(63)*den(79)
  den(486) = den(69)*den(417)
  den(487) = den(68)*den(486)
  den(488) = den(24)*den(85)
  den(489) = den(27)*den(85)
  den(490) = den(24)*den(87)
  den(491) = den(27)*den(87)
  den(492) = den(212)*den(411)
  den(493) = den(214)*den(411)
  den(494) = den(81)*den(411)
  den(495) = den(83)*den(411)
  den(496) = den(85)*den(329)
  den(497) = den(87)*den(329)
  den(498) = den(89)*den(329)
  den(499) = den(91)*den(329)
  den(500) = den(212)*den(415)
  den(501) = den(214)*den(415)
  den(502) = den(81)*den(415)
  den(503) = den(83)*den(415)
  den(504) = den(85)*den(333)
  den(505) = den(87)*den(333)
  den(506) = den(89)*den(333)
  den(507) = den(91)*den(333)
  den(508) = den(216)*den(427)
  den(509) = den(218)*den(427)
  den(510) = den(99)*den(427)
  den(511) = den(101)*den(427)
  den(512) = den(77)*den(345)
  den(513) = den(79)*den(345)
  den(514) = den(93)*den(345)
  den(515) = den(95)*den(345)
  den(516) = den(216)*den(431)
  den(517) = den(218)*den(431)
  den(518) = den(99)*den(431)
  den(519) = den(101)*den(431)
  den(520) = den(77)*den(349)
  den(521) = den(79)*den(349)
  den(522) = den(93)*den(349)
  den(523) = den(95)*den(349)
  den(524) = den(81)*den(93)
  den(525) = den(83)*den(93)
  den(526) = den(81)*den(95)
  den(527) = den(83)*den(95)
  den(528) = den(89)*den(99)
  den(529) = den(89)*den(101)
  den(530) = den(91)*den(99)
  den(531) = den(91)*den(101)
  den(532) = den(53)*den(54)
  den(533) = den(212)*den(532)
  den(534) = den(214)*den(532)
  den(535) = den(81)*den(532)
  den(536) = den(83)*den(532)
  den(537) = den(65)*den(66)
  den(538) = den(216)*den(537)
  den(539) = den(218)*den(537)
  den(540) = den(55)*den(56)
  den(541) = den(216)*den(540)
  den(542) = den(218)*den(540)
  den(543) = den(67)*den(68)
  den(544) = den(212)*den(543)
  den(545) = den(214)*den(543)
  den(546) = den(81)*den(543)
  den(547) = den(83)*den(543)
  den(548) = den(99)*den(537)
  den(549) = den(101)*den(537)
  den(550) = den(99)*den(540)
  den(551) = den(101)*den(540)
  den(552) = den(89)*den(216)
  den(553) = den(89)*den(218)
  den(554) = den(91)*den(216)
  den(555) = den(91)*den(218)
  den(556) = den(93)*den(212)
  den(557) = den(93)*den(214)
  den(558) = den(95)*den(212)
  den(559) = den(95)*den(214)
  den(560) = den(77)*den(81)
  den(561) = den(79)*den(81)
  den(562) = den(77)*den(83)
  den(563) = den(79)*den(83)
  den(564) = den(85)*den(99)
  den(565) = den(87)*den(99)
  den(566) = den(85)*den(101)
  den(567) = den(87)*den(101)
  den(568) = den(41)*den(42)
  den(569) = den(77)*den(568)
  den(570) = den(79)*den(568)
  den(571) = den(31)*den(32)
  den(572) = den(77)*den(571)
  den(573) = den(79)*den(571)
  den(574) = den(29)*den(30)
  den(575) = den(85)*den(574)
  den(576) = den(87)*den(574)
  den(577) = den(89)*den(574)
  den(578) = den(91)*den(574)
  den(579) = den(93)*den(568)
  den(580) = den(95)*den(568)
  den(581) = den(93)*den(571)
  den(582) = den(95)*den(571)
  den(583) = den(43)*den(44)
  den(584) = den(85)*den(583)
  den(585) = den(87)*den(583)
  den(586) = den(89)*den(583)
  den(587) = den(91)*den(583)
  den(588) = den(77)*den(212)
  den(589) = den(77)*den(214)
  den(590) = den(79)*den(212)
  den(591) = den(79)*den(214)
  den(592) = den(85)*den(216)
  den(593) = den(85)*den(218)
  den(594) = den(87)*den(216)
  den(595) = den(87)*den(218)
  den(596) = den(123)*den(287)
  den(597) = den(125)*den(287)
  den(598) = den(132)*den(283)
  den(599) = den(134)*den(283)
  den(600) = den(127)*den(287)
  den(601) = den(136)*den(283)
  den(602) = den(106)*den(282)
  den(603) = den(117)*den(602)
  den(604) = den(110)*den(282)
  den(605) = den(114)*den(604)
  den(607) = den(24)*den(606)
  den(608) = den(106)*den(607)
  den(609) = den(27)*den(606)
  den(610) = den(106)*den(609)
  den(612) = den(13)*den(611)
  den(613) = den(110)*den(612)
  den(614) = den(16)*den(611)
  den(615) = den(110)*den(614)
  den(617) = den(27)*den(616)
  den(618) = den(114)*den(617)
  den(620) = den(16)*den(619)
  den(621) = den(117)*den(620)
  den(622) = den(105)*den(300)
  den(623) = den(24)*den(622)
  den(624) = den(27)*den(622)
  den(625) = den(1)*den(117)
  den(626) = den(622)*den(625)
  den(627) = den(109)*den(309)
  den(628) = den(13)*den(627)
  den(629) = den(16)*den(627)
  den(630) = den(1)*den(114)
  den(631) = den(627)*den(630)
  den(632) = den(24)*den(127)
  den(633) = den(27)*den(127)
  den(634) = den(13)*den(136)
  den(635) = den(16)*den(136)
  den(636) = den(606)*den(625)
  den(637) = den(106)*den(636)
  den(638) = den(611)*den(630)
  den(639) = den(110)*den(638)
  den(640) = den(300)*den(617)
  den(641) = den(113)*den(300)
  den(642) = den(121)*den(641)
  den(643) = den(309)*den(620)
  den(644) = den(116)*den(309)
  den(645) = den(119)*den(644)
  den(646) = den(24)*den(123)
  den(647) = den(27)*den(123)
  den(648) = den(24)*den(125)
  den(649) = den(27)*den(125)
  den(650) = den(13)*den(132)
  den(651) = den(16)*den(132)
  den(652) = den(13)*den(134)
  den(653) = den(16)*den(134)
  den(654) = den(119)*den(619)
  den(655) = den(117)*den(654)
  den(656) = den(121)*den(616)
  den(657) = den(114)*den(656)
  den(658) = den(132)*den(301)
  den(659) = den(134)*den(301)
  den(660) = den(136)*den(301)
  den(661) = den(123)*den(310)
  den(662) = den(125)*den(310)
  den(663) = den(127)*den(310)
  den(664) = den(123)*den(329)
  den(665) = den(125)*den(329)
  den(666) = den(127)*den(329)
  den(667) = den(123)*den(333)
  den(668) = den(125)*den(333)
  den(669) = den(127)*den(333)
  den(670) = den(105)*den(106)
  den(671) = den(216)*den(670)
  den(672) = den(218)*den(670)
  den(673) = den(113)*den(114)
  den(674) = den(218)*den(673)
  den(675) = den(99)*den(670)
  den(676) = den(101)*den(670)
  den(677) = den(101)*den(673)
  den(678) = den(216)*den(622)
  den(679) = den(218)*den(622)
  den(680) = den(99)*den(622)
  den(681) = den(101)*den(622)
  den(682) = den(99)*den(127)
  den(683) = den(101)*den(127)
  den(684) = den(127)*den(216)
  den(685) = den(127)*den(218)
  den(686) = den(218)*den(641)
  den(687) = den(101)*den(641)
  den(688) = den(99)*den(123)
  den(689) = den(101)*den(123)
  den(690) = den(99)*den(125)
  den(691) = den(101)*den(125)
  den(692) = den(123)*den(216)
  den(693) = den(123)*den(218)
  den(694) = den(125)*den(216)
  den(695) = den(125)*den(218)
  den(696) = den(123)*den(574)
  den(697) = den(125)*den(574)
  den(698) = den(127)*den(574)
  den(699) = den(123)*den(583)
  den(700) = den(125)*den(583)
  den(701) = den(127)*den(583)
  den(702) = den(132)*den(411)
  den(703) = den(134)*den(411)
  den(704) = den(136)*den(411)
  den(705) = den(136)*den(415)
  den(706) = den(132)*den(415)
  den(707) = den(134)*den(415)
  den(708) = den(109)*den(110)
  den(709) = den(77)*den(708)
  den(710) = den(79)*den(708)
  den(711) = den(116)*den(117)
  den(712) = den(79)*den(711)
  den(713) = den(95)*den(711)
  den(714) = den(93)*den(708)
  den(715) = den(95)*den(708)
  den(716) = den(93)*den(136)
  den(717) = den(95)*den(136)
  den(718) = den(77)*den(627)
  den(719) = den(79)*den(627)
  den(720) = den(93)*den(627)
  den(721) = den(95)*den(627)
  den(722) = den(77)*den(136)
  den(723) = den(79)*den(136)
  den(724) = den(93)*den(132)
  den(725) = den(95)*den(132)
  den(726) = den(93)*den(134)
  den(727) = den(95)*den(134)
  den(728) = den(79)*den(644)
  den(729) = den(95)*den(644)
  den(730) = den(77)*den(132)
  den(731) = den(79)*den(132)
  den(732) = den(77)*den(134)
  den(733) = den(79)*den(134)
  den(734) = den(132)*den(532)
  den(735) = den(134)*den(532)
  den(736) = den(136)*den(532)
  den(737) = den(136)*den(543)
  den(738) = den(132)*den(543)
  den(739) = den(134)*den(543)
  den(741) = den(60)*den(740)
  den(742) = den(142)*den(741)
  den(743) = den(63)*den(740)
  den(744) = den(142)*den(743)
  den(746) = den(36)*den(745)
  den(747) = den(146)*den(746)
  den(748) = den(39)*den(745)
  den(749) = den(146)*den(748)
  den(751) = den(63)*den(750)
  den(752) = den(150)*den(751)
  den(754) = den(39)*den(753)
  den(755) = den(153)*den(754)
  den(756) = den(141)*den(300)
  den(757) = den(60)*den(756)
  den(758) = den(63)*den(756)
  den(759) = den(2)*den(153)
  den(760) = den(756)*den(759)
  den(761) = den(145)*den(309)
  den(762) = den(36)*den(761)
  den(763) = den(39)*den(761)
  den(764) = den(2)*den(150)
  den(765) = den(761)*den(764)
  den(766) = den(60)*den(165)
  den(767) = den(63)*den(165)
  den(768) = den(36)*den(168)
  den(769) = den(39)*den(168)
  den(770) = den(740)*den(759)
  den(771) = den(142)*den(770)
  den(772) = den(745)*den(764)
  den(773) = den(146)*den(772)
  den(774) = den(159)*den(296)
  den(775) = den(161)*den(296)
  den(776) = den(170)*den(292)
  den(777) = den(172)*den(292)
  den(778) = den(165)*den(296)
  den(779) = den(168)*den(292)
  den(780) = den(142)*den(291)
  den(781) = den(153)*den(780)
  den(782) = den(146)*den(291)
  den(783) = den(150)*den(782)
  den(784) = den(300)*den(751)
  den(785) = den(149)*den(300)
  den(786) = den(157)*den(785)
  den(787) = den(309)*den(754)
  den(788) = den(152)*den(309)
  den(789) = den(155)*den(788)
  den(790) = den(60)*den(159)
  den(791) = den(63)*den(159)
  den(792) = den(60)*den(161)
  den(793) = den(63)*den(161)
  den(794) = den(36)*den(170)
  den(795) = den(39)*den(170)
  den(796) = den(36)*den(172)
  den(797) = den(39)*den(172)
  den(798) = den(155)*den(753)
  den(799) = den(153)*den(798)
  den(800) = den(157)*den(750)
  den(801) = den(150)*den(800)
  den(802) = den(170)*den(305)
  den(803) = den(172)*den(305)
  den(804) = den(168)*den(305)
  den(805) = den(159)*den(314)
  den(806) = den(161)*den(314)
  den(807) = den(165)*den(314)
  den(808) = den(141)*den(142)
  den(809) = den(212)*den(808)
  den(810) = den(214)*den(808)
  den(811) = den(81)*den(808)
  den(812) = den(83)*den(808)
  den(813) = den(149)*den(150)
  den(814) = den(83)*den(813)
  den(815) = den(214)*den(813)
  den(816) = den(212)*den(756)
  den(817) = den(214)*den(756)
  den(818) = den(81)*den(756)
  den(819) = den(83)*den(756)
  den(820) = den(81)*den(165)
  den(821) = den(83)*den(165)
  den(822) = den(165)*den(212)
  den(823) = den(165)*den(214)
  den(824) = den(159)*den(345)
  den(825) = den(161)*den(345)
  den(826) = den(165)*den(345)
  den(827) = den(159)*den(349)
  den(828) = den(161)*den(349)
  den(829) = den(165)*den(349)
  den(830) = den(83)*den(785)
  den(831) = den(214)*den(785)
  den(832) = den(81)*den(159)
  den(833) = den(83)*den(159)
  den(834) = den(81)*den(161)
  den(835) = den(83)*den(161)
  den(836) = den(159)*den(212)
  den(837) = den(159)*den(214)
  den(838) = den(161)*den(212)
  den(839) = den(161)*den(214)
  den(840) = den(159)*den(568)
  den(841) = den(161)*den(568)
  den(842) = den(159)*den(571)
  den(843) = den(161)*den(571)
  den(844) = den(165)*den(571)
  den(845) = den(165)*den(568)
  den(846) = den(152)*den(153)
  den(847) = den(91)*den(846)
  den(848) = den(145)*den(146)
  den(849) = den(85)*den(848)
  den(850) = den(87)*den(848)
  den(851) = den(89)*den(848)
  den(852) = den(91)*den(848)
  den(853) = den(87)*den(846)
  den(854) = den(89)*den(168)
  den(855) = den(91)*den(168)
  den(856) = den(85)*den(761)
  den(857) = den(87)*den(761)
  den(858) = den(89)*den(761)
  den(859) = den(91)*den(761)
  den(860) = den(85)*den(168)
  den(861) = den(87)*den(168)
  den(862) = den(170)*den(427)
  den(863) = den(172)*den(427)
  den(864) = den(168)*den(427)
  den(865) = den(168)*den(431)
  den(866) = den(170)*den(431)
  den(867) = den(172)*den(431)
  den(868) = den(89)*den(170)
  den(869) = den(91)*den(170)
  den(870) = den(89)*den(172)
  den(871) = den(91)*den(172)
  den(872) = den(91)*den(788)
  den(873) = den(87)*den(788)
  den(874) = den(85)*den(170)
  den(875) = den(87)*den(170)
  den(876) = den(85)*den(172)
  den(877) = den(87)*den(172)
  den(878) = den(168)*den(540)
  den(879) = den(170)*den(537)
  den(880) = den(172)*den(537)
  den(881) = den(170)*den(540)
  den(882) = den(172)*den(540)
  den(883) = den(168)*den(537)
  den(884) = den(136)*den(165)
  den(885) = den(127)*den(168)
  den(886) = den(136)*den(813)
  den(887) = den(127)*den(846)
  den(888) = den(125)*den(846)
  den(889) = den(134)*den(813)
  den(890) = den(136)*den(808)
  den(891) = den(132)*den(808)
  den(892) = den(134)*den(808)
  den(893) = den(127)*den(848)
  den(894) = den(123)*den(848)
  den(895) = den(125)*den(848)
  den(896) = den(123)*den(168)
  den(897) = den(125)*den(168)
  den(898) = den(132)*den(165)
  den(899) = den(134)*den(165)
  den(900) = den(136)*den(756)
  den(901) = den(132)*den(756)
  den(902) = den(134)*den(756)
  den(903) = den(127)*den(761)
  den(904) = den(123)*den(761)
  den(905) = den(125)*den(761)
  den(906) = den(136)*den(159)
  den(907) = den(136)*den(161)
  den(908) = den(127)*den(170)
  den(909) = den(127)*den(172)
  den(910) = den(165)*den(711)
  den(911) = den(168)*den(673)
  den(912) = den(168)*den(670)
  den(913) = den(165)*den(708)
  den(914) = den(161)*den(711)
  den(915) = den(159)*den(708)
  den(916) = den(161)*den(708)
  den(917) = den(172)*den(673)
  den(918) = den(170)*den(670)
  den(919) = den(172)*den(670)
  den(920) = den(168)*den(622)
  den(921) = den(170)*den(622)
  den(922) = den(172)*den(622)
  den(923) = den(165)*den(627)
  den(924) = den(159)*den(627)
  den(925) = den(161)*den(627)
  den(926) = den(132)*den(159)
  den(927) = den(134)*den(159)
  den(928) = den(132)*den(161)
  den(929) = den(134)*den(161)
  den(930) = den(123)*den(170)
  den(931) = den(125)*den(170)
  den(932) = den(123)*den(172)
  den(933) = den(125)*den(172)
  den(934) = den(136)*den(785)
  den(935) = den(134)*den(785)
  den(936) = den(127)*den(788)
  den(937) = den(125)*den(788)
  den(938) = den(168)*den(641)
  den(939) = den(172)*den(641)
  den(940) = den(165)*den(644)
  den(941) = den(161)*den(644)
  den(942) = den(2)*den(10)
  den(943) = den(209)*den(942)
  den(944) = den(2)*den(13)
  den(945) = den(209)*den(944)
  den(946) = den(2)*den(16)
  den(947) = den(209)*den(946)
  den(948) = den(1)*den(188)
  den(949) = den(209)*den(948)
  den(950) = den(1)*den(36)
  den(951) = den(209)*den(950)
  den(952) = den(1)*den(39)
  den(953) = den(209)*den(952)
  den(954) = den(2)*den(21)
  den(955) = den(206)*den(954)
  den(956) = den(2)*den(24)
  den(957) = den(206)*den(956)
  den(958) = den(2)*den(27)
  den(959) = den(206)*den(958)
  den(960) = den(1)*den(193)
  den(961) = den(206)*den(960)
  den(962) = den(1)*den(60)
  den(963) = den(206)*den(962)
  den(964) = den(1)*den(63)
  den(965) = den(206)*den(964)
  den(966) = den(54)*den(56)
  den(967) = den(209)*den(966)
  den(968) = den(77)*den(351)
  den(969) = den(79)*den(351)
  den(970) = den(77)*den(379)
  den(971) = den(79)*den(379)
  den(972) = den(2)*den(77)
  den(973) = den(209)*den(972)
  den(974) = den(2)*den(79)
  den(975) = den(209)*den(974)
  den(976) = den(30)*den(32)
  den(977) = den(206)*den(976)
  den(978) = den(216)*den(433)
  den(979) = den(218)*den(433)
  den(980) = den(216)*den(449)
  den(981) = den(218)*den(449)
  den(982) = den(2)*den(216)
  den(983) = den(206)*den(982)
  den(984) = den(2)*den(218)
  den(985) = den(206)*den(984)
  den(986) = den(66)*den(68)
  den(987) = den(209)*den(986)
  den(988) = den(93)*den(351)
  den(989) = den(95)*den(351)
  den(990) = den(93)*den(379)
  den(991) = den(95)*den(379)
  den(992) = den(2)*den(93)
  den(993) = den(209)*den(992)
  den(994) = den(2)*den(95)
  den(995) = den(209)*den(994)
  den(996) = den(42)*den(44)
  den(997) = den(206)*den(996)
  den(998) = den(99)*den(433)
  den(999) = den(101)*den(433)
  den(1000) = den(99)*den(449)
  den(1001) = den(101)*den(449)
  den(1002) = den(2)*den(99)
  den(1003) = den(206)*den(1002)
  den(1004) = den(2)*den(101)
  den(1005) = den(206)*den(1004)
  den(1006) = den(85)*den(335)
  den(1007) = den(87)*den(335)
  den(1008) = den(85)*den(372)
  den(1009) = den(87)*den(372)
  den(1010) = den(1)*den(85)
  den(1011) = den(209)*den(1010)
  den(1012) = den(1)*den(87)
  den(1013) = den(209)*den(1012)
  den(1014) = den(212)*den(417)
  den(1015) = den(214)*den(417)
  den(1016) = den(212)*den(442)
  den(1017) = den(214)*den(442)
  den(1018) = den(1)*den(212)
  den(1019) = den(206)*den(1018)
  den(1020) = den(1)*den(214)
  den(1021) = den(206)*den(1020)
  den(1022) = den(89)*den(335)
  den(1023) = den(91)*den(335)
  den(1024) = den(89)*den(372)
  den(1025) = den(91)*den(372)
  den(1026) = den(1)*den(89)
  den(1027) = den(209)*den(1026)
  den(1028) = den(1)*den(91)
  den(1029) = den(209)*den(1028)
  den(1030) = den(81)*den(417)
  den(1031) = den(83)*den(417)
  den(1032) = den(81)*den(442)
  den(1033) = den(83)*den(442)
  den(1034) = den(1)*den(81)
  den(1035) = den(206)*den(1034)
  den(1036) = den(1)*den(83)
  den(1037) = den(206)*den(1036)
  den(1038) = den(4)*den(10)
  den(1039) = den(202)*den(1038)
  den(1040) = den(4)*den(13)
  den(1041) = den(202)*den(1040)
  den(1042) = den(4)*den(16)
  den(1043) = den(202)*den(1042)
  den(1044) = den(3)*den(21)
  den(1045) = den(202)*den(1044)
  den(1046) = den(3)*den(24)
  den(1047) = den(202)*den(1046)
  den(1048) = den(3)*den(27)
  den(1049) = den(202)*den(1048)
  den(1050) = den(218)*den(616)
  den(1051) = den(216)*den(606)
  den(1052) = den(218)*den(606)
  den(1053) = den(3)*den(216)
  den(1054) = den(202)*den(1053)
  den(1055) = den(3)*den(218)
  den(1056) = den(202)*den(1055)
  den(1057) = den(202)*den(398)
  den(1058) = den(101)*den(616)
  den(1059) = den(99)*den(606)
  den(1060) = den(101)*den(606)
  den(1061) = den(3)*den(99)
  den(1062) = den(202)*den(1061)
  den(1063) = den(3)*den(101)
  den(1064) = den(202)*den(1063)
  den(1065) = den(202)*den(388)
  den(1066) = den(123)*den(335)
  den(1067) = den(125)*den(335)
  den(1068) = den(123)*den(372)
  den(1069) = den(125)*den(372)
  den(1070) = den(1)*den(123)
  den(1071) = den(209)*den(1070)
  den(1072) = den(1)*den(125)
  den(1073) = den(209)*den(1072)
  den(1074) = den(127)*den(335)
  den(1075) = den(127)*den(372)
  den(1076) = den(1)*den(127)
  den(1077) = den(209)*den(1076)
  den(1078) = den(209)*den(620)
  den(1079) = den(209)*den(612)
  den(1080) = den(209)*den(614)
  den(1081) = den(209)*den(654)
  den(1082) = den(209)*den(638)
  den(1083) = den(202)*den(352)
  den(1084) = den(202)*den(354)
  den(1085) = den(202)*den(380)
  den(1086) = den(202)*den(382)
  den(1087) = den(79)*den(619)
  den(1088) = den(77)*den(611)
  den(1089) = den(79)*den(611)
  den(1090) = den(4)*den(77)
  den(1091) = den(202)*den(1090)
  den(1092) = den(4)*den(79)
  den(1093) = den(202)*den(1092)
  den(1094) = den(202)*den(480)
  den(1095) = den(95)*den(619)
  den(1096) = den(93)*den(611)
  den(1097) = den(95)*den(611)
  den(1098) = den(4)*den(93)
  den(1099) = den(202)*den(1098)
  den(1100) = den(4)*den(95)
  den(1101) = den(202)*den(1100)
  den(1102) = den(202)*den(458)
  den(1103) = den(136)*den(417)
  den(1104) = den(132)*den(417)
  den(1105) = den(134)*den(417)
  den(1106) = den(132)*den(442)
  den(1107) = den(134)*den(442)
  den(1108) = den(1)*den(132)
  den(1109) = den(206)*den(1108)
  den(1110) = den(1)*den(134)
  den(1111) = den(206)*den(1110)
  den(1112) = den(136)*den(442)
  den(1113) = den(1)*den(136)
  den(1114) = den(206)*den(1113)
  den(1115) = den(206)*den(617)
  den(1116) = den(206)*den(607)
  den(1117) = den(206)*den(609)
  den(1118) = den(206)*den(656)
  den(1119) = den(206)*den(636)
  den(1120) = den(202)*den(434)
  den(1121) = den(202)*den(436)
  den(1122) = den(202)*den(450)
  den(1123) = den(202)*den(452)
  den(1124) = den(209)*den(1087)
  den(1125) = den(209)*den(1088)
  den(1126) = den(209)*den(1089)
  den(1127) = den(202)*den(968)
  den(1128) = den(202)*den(969)
  den(1129) = den(202)*den(970)
  den(1130) = den(202)*den(971)
  den(1131) = den(206)*den(1050)
  den(1132) = den(206)*den(1051)
  den(1133) = den(206)*den(1052)
  den(1134) = den(202)*den(978)
  den(1135) = den(202)*den(979)
  den(1136) = den(202)*den(980)
  den(1137) = den(202)*den(981)
  den(1138) = den(209)*den(1095)
  den(1139) = den(209)*den(1096)
  den(1140) = den(209)*den(1097)
  den(1141) = den(202)*den(988)
  den(1142) = den(202)*den(989)
  den(1143) = den(202)*den(990)
  den(1144) = den(202)*den(991)
  den(1145) = den(206)*den(1058)
  den(1146) = den(206)*den(1059)
  den(1147) = den(206)*den(1060)
  den(1148) = den(202)*den(998)
  den(1149) = den(202)*den(999)
  den(1150) = den(202)*den(1000)
  den(1151) = den(202)*den(1001)
  den(1152) = den(4)*den(188)
  den(1153) = den(198)*den(1152)
  den(1154) = den(4)*den(36)
  den(1155) = den(198)*den(1154)
  den(1156) = den(4)*den(39)
  den(1157) = den(198)*den(1156)
  den(1158) = den(3)*den(193)
  den(1159) = den(198)*den(1158)
  den(1160) = den(3)*den(60)
  den(1161) = den(198)*den(1160)
  den(1162) = den(3)*den(63)
  den(1163) = den(198)*den(1162)
  den(1164) = den(159)*den(351)
  den(1165) = den(161)*den(351)
  den(1166) = den(159)*den(379)
  den(1167) = den(161)*den(379)
  den(1168) = den(2)*den(159)
  den(1169) = den(209)*den(1168)
  den(1170) = den(2)*den(161)
  den(1171) = den(209)*den(1170)
  den(1172) = den(165)*den(351)
  den(1173) = den(165)*den(379)
  den(1174) = den(2)*den(165)
  den(1175) = den(209)*den(1174)
  den(1176) = den(209)*den(754)
  den(1177) = den(209)*den(746)
  den(1178) = den(209)*den(748)
  den(1179) = den(209)*den(798)
  den(1180) = den(83)*den(750)
  den(1181) = den(214)*den(750)
  den(1182) = den(209)*den(772)
  den(1183) = den(212)*den(740)
  den(1184) = den(214)*den(740)
  den(1185) = den(3)*den(212)
  den(1186) = den(198)*den(1185)
  den(1187) = den(3)*den(214)
  den(1188) = den(198)*den(1187)
  den(1189) = den(198)*den(404)
  den(1190) = den(81)*den(740)
  den(1191) = den(83)*den(740)
  den(1192) = den(3)*den(81)
  den(1193) = den(198)*den(1192)
  den(1194) = den(3)*den(83)
  den(1195) = den(198)*den(1194)
  den(1196) = den(198)*den(386)
  den(1197) = den(198)*den(336)
  den(1198) = den(198)*den(338)
  den(1199) = den(198)*den(373)
  den(1200) = den(198)*den(375)
  den(1201) = den(168)*den(433)
  den(1202) = den(170)*den(433)
  den(1203) = den(172)*den(433)
  den(1204) = den(170)*den(449)
  den(1205) = den(172)*den(449)
  den(1206) = den(2)*den(170)
  den(1207) = den(206)*den(1206)
  den(1208) = den(2)*den(172)
  den(1209) = den(206)*den(1208)
  den(1210) = den(168)*den(449)
  den(1211) = den(2)*den(168)
  den(1212) = den(206)*den(1211)
  den(1213) = den(206)*den(751)
  den(1214) = den(206)*den(741)
  den(1215) = den(206)*den(743)
  den(1216) = den(91)*den(753)
  den(1217) = den(206)*den(800)
  den(1218) = den(87)*den(753)
  den(1219) = den(206)*den(770)
  den(1220) = den(85)*den(745)
  den(1221) = den(87)*den(745)
  den(1222) = den(4)*den(85)
  den(1223) = den(198)*den(1222)
  den(1224) = den(4)*den(87)
  den(1225) = den(198)*den(1224)
  den(1226) = den(198)*den(486)
  den(1227) = den(89)*den(745)
  den(1228) = den(91)*den(745)
  den(1229) = den(4)*den(89)
  den(1230) = den(198)*den(1229)
  den(1231) = den(4)*den(91)
  den(1232) = den(198)*den(1231)
  den(1233) = den(198)*den(456)
  den(1234) = den(198)*den(418)
  den(1235) = den(198)*den(420)
  den(1236) = den(198)*den(443)
  den(1237) = den(198)*den(445)
  den(1238) = den(209)*den(1216)
  den(1239) = den(206)*den(1180)
  den(1240) = den(209)*den(1218)
  den(1241) = den(206)*den(1181)
  den(1242) = den(209)*den(1220)
  den(1243) = den(209)*den(1221)
  den(1244) = den(206)*den(1183)
  den(1245) = den(206)*den(1184)
  den(1246) = den(209)*den(1227)
  den(1247) = den(209)*den(1228)
  den(1248) = den(206)*den(1190)
  den(1249) = den(206)*den(1191)
  den(1250) = den(198)*den(1006)
  den(1251) = den(198)*den(1007)
  den(1252) = den(198)*den(1008)
  den(1253) = den(198)*den(1009)
  den(1254) = den(198)*den(1014)
  den(1255) = den(198)*den(1015)
  den(1256) = den(198)*den(1016)
  den(1257) = den(198)*den(1017)
  den(1258) = den(198)*den(1022)
  den(1259) = den(198)*den(1023)
  den(1260) = den(198)*den(1024)
  den(1261) = den(198)*den(1025)
  den(1262) = den(198)*den(1030)
  den(1263) = den(198)*den(1031)
  den(1264) = den(198)*den(1032)
  den(1265) = den(198)*den(1033)
  den(1266) = den(165)*den(619)
  den(1267) = den(168)*den(616)
  den(1268) = den(127)*den(753)
  den(1269) = den(136)*den(750)
  den(1270) = den(165)*den(611)
  den(1271) = den(168)*den(606)
  den(1272) = den(161)*den(619)
  den(1273) = den(159)*den(611)
  den(1274) = den(161)*den(611)
  den(1275) = den(4)*den(159)
  den(1276) = den(202)*den(1275)
  den(1277) = den(4)*den(161)
  den(1278) = den(202)*den(1277)
  den(1279) = den(172)*den(616)
  den(1280) = den(170)*den(606)
  den(1281) = den(172)*den(606)
  den(1282) = den(3)*den(170)
  den(1283) = den(202)*den(1282)
  den(1284) = den(3)*den(172)
  den(1285) = den(202)*den(1284)
  den(1286) = den(4)*den(165)
  den(1287) = den(202)*den(1286)
  den(1288) = den(3)*den(168)
  den(1289) = den(202)*den(1288)
  den(1290) = den(125)*den(753)
  den(1291) = den(134)*den(750)
  den(1292) = den(142)*den(153)
  den(1293) = den(202)*den(1292)
  den(1294) = den(146)*den(150)
  den(1295) = den(202)*den(1294)
  den(1296) = den(127)*den(745)
  den(1297) = den(136)*den(740)
  den(1298) = den(123)*den(745)
  den(1299) = den(125)*den(745)
  den(1300) = den(4)*den(123)
  den(1301) = den(198)*den(1300)
  den(1302) = den(4)*den(125)
  den(1303) = den(198)*den(1302)
  den(1304) = den(132)*den(740)
  den(1305) = den(134)*den(740)
  den(1306) = den(3)*den(132)
  den(1307) = den(198)*den(1306)
  den(1308) = den(3)*den(134)
  den(1309) = den(198)*den(1308)
  den(1310) = den(4)*den(127)
  den(1311) = den(198)*den(1310)
  den(1312) = den(3)*den(136)
  den(1313) = den(198)*den(1312)
  den(1314) = den(106)*den(117)
  den(1315) = den(198)*den(1314)
  den(1316) = den(110)*den(114)
  den(1317) = den(198)*den(1316)
  den(1318) = den(209)*den(1266)
  den(1319) = den(209)*den(1268)
  den(1320) = den(209)*den(1290)
  den(1321) = den(209)*den(1270)
  den(1322) = den(209)*den(1272)
  den(1323) = den(209)*den(1273)
  den(1324) = den(209)*den(1274)
  den(1325) = den(202)*den(1164)
  den(1326) = den(202)*den(1165)
  den(1327) = den(202)*den(1166)
  den(1328) = den(202)*den(1167)
  den(1329) = den(202)*den(1172)
  den(1330) = den(202)*den(1173)
  den(1331) = den(209)*den(1296)
  den(1332) = den(209)*den(1298)
  den(1333) = den(209)*den(1299)
  den(1334) = den(198)*den(1066)
  den(1335) = den(198)*den(1067)
  den(1336) = den(198)*den(1068)
  den(1337) = den(198)*den(1069)
  den(1338) = den(198)*den(1074)
  den(1339) = den(198)*den(1075)
  den(1340) = den(206)*den(1267)
  den(1341) = den(206)*den(1269)
  den(1342) = den(206)*den(1291)
  den(1343) = den(206)*den(1271)
  den(1344) = den(202)*den(1201)
  den(1345) = den(206)*den(1279)
  den(1346) = den(206)*den(1280)
  den(1347) = den(206)*den(1281)
  den(1348) = den(202)*den(1202)
  den(1349) = den(202)*den(1203)
  den(1350) = den(202)*den(1204)
  den(1351) = den(202)*den(1205)
  den(1352) = den(202)*den(1210)
  den(1353) = den(206)*den(1297)
  den(1354) = den(206)*den(1304)
  den(1355) = den(206)*den(1305)
  den(1356) = den(198)*den(1103)
  den(1357) = den(198)*den(1104)
  den(1358) = den(198)*den(1105)
  den(1359) = den(198)*den(1106)
  den(1360) = den(198)*den(1107)
  den(1361) = den(198)*den(1112)
  den(1362) = den(3)*den(4)
  den(1363) = den(1)*den(2)*den(1362)
  den(1364) = den(1)*den(3)*den(8)
  den(1365) = den(1)*den(4)*den(19)
  den(1366) = den(2)*den(3)*den(18)
  den(1367) = den(2)*den(4)*den(7)
  den(1368) = den(1)*den(2)
  den(1369) = den(3)*den(4)*den(1368)
  den(1370) = den(19)*den(30)
  den(1371) = den(19)*den(44)
  den(1372) = den(1)*den(19)
  den(1373) = den(7)*den(42)
  den(1374) = den(7)*den(32)
  den(1375) = den(2)*den(7)
  den(1376) = den(3)*den(1368)
  den(1377) = den(8)*den(54)
  den(1378) = den(8)*den(68)
  den(1379) = den(1)*den(8)
  den(1380) = den(18)*den(66)
  den(1381) = den(18)*den(56)
  den(1382) = den(2)*den(18)
  den(1383) = den(4)*den(1368)
  den(1384) = den(1)*den(1362)
  den(1385) = den(18)*den(106)
  den(1386) = den(7)*den(110)
  den(1387) = den(18)*den(114)
  den(1388) = den(7)*den(117)
  den(1389) = den(3)*den(18)
  den(1390) = den(4)*den(7)
  den(1391) = den(8)*den(142)
  den(1392) = den(19)*den(146)
  den(1393) = den(2)*den(1362)
  den(1394) = den(8)*den(150)
  den(1395) = den(19)*den(153)
  den(1396) = den(3)*den(8)
  den(1397) = den(4)*den(19)
  den(1398) = den(2)*den(4)*den(10)
  den(1399) = den(2)*den(4)*den(13)
  den(1400) = den(2)*den(4)*den(16)
  den(1401) = den(1)*den(4)*den(188)
  den(1402) = den(1)*den(4)*den(36)
  den(1403) = den(1)*den(4)*den(39)
  den(1404) = den(2)*den(3)*den(21)
  den(1405) = den(2)*den(3)*den(24)
  den(1406) = den(2)*den(3)*den(27)
  den(1407) = den(1)*den(3)*den(193)
  den(1408) = den(1)*den(3)*den(60)
  den(1409) = den(1)*den(3)*den(63)
  den(1410) = den(1)*den(2)*den(3)*den(4)
  den(1411) = den(3)*den(30)*den(32)
  den(1412) = den(30)*den(188)
  den(1413) = den(2)*den(3)*den(216)
  den(1414) = den(2)*den(3)*den(218)
  den(1415) = den(2)*den(398)
  den(1416) = den(2)*den(3)*den(30)
  den(1417) = den(3)*den(42)*den(44)
  den(1418) = den(44)*den(188)
  den(1419) = den(2)*den(3)*den(99)
  den(1420) = den(2)*den(3)*den(101)
  den(1421) = den(2)*den(388)
  den(1422) = den(2)*den(3)*den(44)
  den(1423) = den(10)*den(42)
  den(1424) = den(1)*den(3)*den(212)
  den(1425) = den(1)*den(3)*den(214)
  den(1426) = den(1)*den(404)
  den(1427) = den(1)*den(3)*den(42)
  den(1428) = den(10)*den(32)
  den(1429) = den(1)*den(3)*den(81)
  den(1430) = den(1)*den(3)*den(83)
  den(1431) = den(1)*den(386)
  den(1432) = den(1)*den(3)*den(32)
  den(1433) = den(2)*den(352)
  den(1434) = den(2)*den(354)
  den(1435) = den(2)*den(380)
  den(1436) = den(2)*den(382)
  den(1437) = den(1)*den(336)
  den(1438) = den(1)*den(338)
  den(1439) = den(1)*den(373)
  den(1440) = den(1)*den(375)
  den(1441) = den(4)*den(54)*den(56)
  den(1442) = den(2)*den(4)*den(77)
  den(1443) = den(2)*den(4)*den(79)
  den(1444) = den(54)*den(193)
  den(1445) = den(2)*den(480)
  den(1446) = den(2)*den(4)*den(54)
  den(1447) = den(4)*den(66)*den(68)
  den(1448) = den(2)*den(4)*den(93)
  den(1449) = den(2)*den(4)*den(95)
  den(1450) = den(68)*den(193)
  den(1451) = den(2)*den(458)
  den(1452) = den(2)*den(4)*den(68)
  den(1453) = den(1)*den(4)*den(85)
  den(1454) = den(1)*den(4)*den(87)
  den(1455) = den(21)*den(66)
  den(1456) = den(1)*den(486)
  den(1457) = den(1)*den(4)*den(66)
  den(1458) = den(1)*den(4)*den(89)
  den(1459) = den(1)*den(4)*den(91)
  den(1460) = den(21)*den(56)
  den(1461) = den(1)*den(456)
  den(1462) = den(1)*den(4)*den(56)
  den(1463) = den(2)*den(434)
  den(1464) = den(2)*den(436)
  den(1465) = den(1)*den(418)
  den(1466) = den(1)*den(420)
  den(1467) = den(2)*den(450)
  den(1468) = den(2)*den(452)
  den(1469) = den(1)*den(443)
  den(1470) = den(1)*den(445)
  den(1471) = den(42)*den(54)
  den(1472) = den(32)*den(54)
  den(1473) = den(2)*den(968)
  den(1474) = den(2)*den(969)
  den(1475) = den(2)*den(970)
  den(1476) = den(2)*den(971)
  den(1477) = den(2)*den(54)
  den(1478) = den(30)*den(66)
  den(1479) = den(30)*den(56)
  den(1480) = den(2)*den(978)
  den(1481) = den(2)*den(979)
  den(1482) = den(2)*den(980)
  den(1483) = den(2)*den(981)
  den(1484) = den(2)*den(30)
  den(1485) = den(42)*den(68)
  den(1486) = den(32)*den(68)
  den(1487) = den(2)*den(988)
  den(1488) = den(2)*den(989)
  den(1489) = den(2)*den(990)
  den(1490) = den(2)*den(991)
  den(1491) = den(2)*den(68)
  den(1492) = den(44)*den(66)
  den(1493) = den(44)*den(56)
  den(1494) = den(2)*den(998)
  den(1495) = den(2)*den(999)
  den(1496) = den(2)*den(1000)
  den(1497) = den(2)*den(1001)
  den(1498) = den(2)*den(44)
  den(1499) = den(1)*den(1006)
  den(1500) = den(1)*den(1007)
  den(1501) = den(1)*den(1008)
  den(1502) = den(1)*den(1009)
  den(1503) = den(1)*den(66)
  den(1504) = den(1)*den(1014)
  den(1505) = den(1)*den(1015)
  den(1506) = den(1)*den(1016)
  den(1507) = den(1)*den(1017)
  den(1508) = den(1)*den(42)
  den(1509) = den(1)*den(1022)
  den(1510) = den(1)*den(1023)
  den(1511) = den(1)*den(1024)
  den(1512) = den(1)*den(1025)
  den(1513) = den(1)*den(56)
  den(1514) = den(1)*den(1030)
  den(1515) = den(1)*den(1031)
  den(1516) = den(1)*den(1032)
  den(1517) = den(1)*den(1033)
  den(1518) = den(1)*den(32)
  den(1519) = den(1)*den(4)*den(123)
  den(1520) = den(1)*den(4)*den(125)
  den(1521) = den(1)*den(3)*den(132)
  den(1522) = den(1)*den(3)*den(134)
  den(1523) = den(1)*den(4)*den(127)
  den(1524) = den(1)*den(3)*den(136)
  den(1525) = den(4)*den(654)
  den(1526) = den(1)*den(106)*den(117)
  den(1527) = den(21)*den(106)
  den(1528) = den(1)*den(4)*den(106)
  den(1529) = den(3)*den(656)
  den(1530) = den(1)*den(110)*den(114)
  den(1531) = den(10)*den(110)
  den(1532) = den(1)*den(3)*den(110)
  den(1533) = den(4)*den(620)
  den(1534) = den(3)*den(617)
  den(1535) = den(4)*den(638)
  den(1536) = den(21)*den(114)
  den(1537) = den(1)*den(4)*den(114)
  den(1538) = den(3)*den(636)
  den(1539) = den(10)*den(117)
  den(1540) = den(1)*den(3)*den(117)
  den(1541) = den(4)*den(612)
  den(1542) = den(4)*den(614)
  den(1543) = den(3)*den(607)
  den(1544) = den(3)*den(609)
  den(1545) = den(30)*den(106)
  den(1546) = den(3)*den(1050)
  den(1547) = den(30)*den(114)
  den(1548) = den(3)*den(1051)
  den(1549) = den(3)*den(1052)
  den(1550) = den(44)*den(106)
  den(1551) = den(3)*den(1058)
  den(1552) = den(44)*den(114)
  den(1553) = den(3)*den(1059)
  den(1554) = den(3)*den(1060)
  den(1555) = den(1)*den(1066)
  den(1556) = den(1)*den(1067)
  den(1557) = den(1)*den(1068)
  den(1558) = den(1)*den(1069)
  den(1559) = den(1)*den(1074)
  den(1560) = den(1)*den(1075)
  den(1561) = den(54)*den(110)
  den(1562) = den(4)*den(1087)
  den(1563) = den(54)*den(117)
  den(1564) = den(4)*den(1088)
  den(1565) = den(4)*den(1089)
  den(1566) = den(4)*den(1095)
  den(1567) = den(68)*den(110)
  den(1568) = den(4)*den(1096)
  den(1569) = den(4)*den(1097)
  den(1570) = den(68)*den(117)
  den(1571) = den(1)*den(1103)
  den(1572) = den(1)*den(1104)
  den(1573) = den(1)*den(1105)
  den(1574) = den(1)*den(1106)
  den(1575) = den(1)*den(1107)
  den(1576) = den(1)*den(1112)
  den(1577) = den(2)*den(4)*den(159)
  den(1578) = den(2)*den(4)*den(161)
  den(1579) = den(2)*den(3)*den(170)
  den(1580) = den(2)*den(3)*den(172)
  den(1581) = den(2)*den(4)*den(165)
  den(1582) = den(2)*den(3)*den(168)
  den(1583) = den(4)*den(798)
  den(1584) = den(2)*den(142)*den(153)
  den(1585) = den(142)*den(193)
  den(1586) = den(2)*den(4)*den(142)
  den(1587) = den(3)*den(800)
  den(1588) = den(2)*den(146)*den(150)
  den(1589) = den(146)*den(188)
  den(1590) = den(2)*den(3)*den(146)
  den(1591) = den(4)*den(754)
  den(1592) = den(3)*den(751)
  den(1593) = den(4)*den(772)
  den(1594) = den(150)*den(193)
  den(1595) = den(2)*den(4)*den(150)
  den(1596) = den(3)*den(770)
  den(1597) = den(153)*den(188)
  den(1598) = den(2)*den(3)*den(153)
  den(1599) = den(4)*den(746)
  den(1600) = den(4)*den(748)
  den(1601) = den(3)*den(741)
  den(1602) = den(3)*den(743)
  den(1603) = den(2)*den(1164)
  den(1604) = den(2)*den(1165)
  den(1605) = den(2)*den(1166)
  den(1606) = den(2)*den(1167)
  den(1607) = den(2)*den(1172)
  den(1608) = den(2)*den(1173)
  den(1609) = den(42)*den(142)
  den(1610) = den(32)*den(142)
  den(1611) = den(3)*den(1180)
  den(1612) = den(3)*den(1181)
  den(1613) = den(42)*den(150)
  den(1614) = den(3)*den(1183)
  den(1615) = den(3)*den(1184)
  den(1616) = den(32)*den(150)
  den(1617) = den(3)*den(1190)
  den(1618) = den(3)*den(1191)
  den(1619) = den(2)*den(1201)
  den(1620) = den(2)*den(1202)
  den(1621) = den(2)*den(1203)
  den(1622) = den(2)*den(1204)
  den(1623) = den(2)*den(1205)
  den(1624) = den(2)*den(1210)
  den(1625) = den(4)*den(1216)
  den(1626) = den(66)*den(146)
  den(1627) = den(56)*den(146)
  den(1628) = den(4)*den(1218)
  den(1629) = den(66)*den(153)
  den(1630) = den(4)*den(1220)
  den(1631) = den(4)*den(1221)
  den(1632) = den(4)*den(1227)
  den(1633) = den(4)*den(1228)
  den(1634) = den(56)*den(153)
  den(1635) = den(4)*den(1266)
  den(1636) = den(3)*den(1267)
  den(1637) = den(4)*den(1268)
  den(1638) = den(3)*den(1269)
  den(1639) = den(4)*den(1270)
  den(1640) = den(3)*den(1271)
  den(1641) = den(4)*den(1272)
  den(1642) = den(4)*den(1273)
  den(1643) = den(4)*den(1274)
  den(1644) = den(3)*den(1279)
  den(1645) = den(3)*den(1280)
  den(1646) = den(3)*den(1281)
  den(1647) = den(4)*den(1290)
  den(1648) = den(3)*den(1291)
  den(1649) = den(110)*den(142)
  den(1650) = den(117)*den(142)
  den(1651) = den(4)*den(142)
  den(1652) = den(106)*den(146)
  den(1653) = den(114)*den(146)
  den(1654) = den(3)*den(146)
  den(1655) = den(4)*den(1296)
  den(1656) = den(3)*den(1297)
  den(1657) = den(4)*den(1298)
  den(1658) = den(4)*den(1299)
  den(1659) = den(3)*den(1304)
  den(1660) = den(3)*den(1305)
  den(1661) = den(106)*den(153)
  den(1662) = den(4)*den(106)
  den(1663) = den(110)*den(150)
  den(1664) = den(3)*den(110)
  den(1665) = den(117)*den(150)
  den(1666) = den(4)*den(150)
  den(1667) = den(114)*den(153)
  den(1668) = den(3)*den(153)
  den(1669) = den(4)*den(114)
  den(1670) = den(3)*den(117)
  den(1671) = den(1362)*den(1368)
  den(1672) = den(7)*den(8)
  den(1673) = den(18)*den(19)
  den(1674) = den(2)*den(1038)
  den(1675) = den(2)*den(1040)
  den(1676) = den(2)*den(1042)
  den(1677) = den(1)*den(1152)
  den(1678) = den(1)*den(1154)
  den(1679) = den(1)*den(1156)
  den(1680) = den(2)*den(1044)
  den(1681) = den(2)*den(1046)
  den(1682) = den(2)*den(1048)
  den(1683) = den(1)*den(1158)
  den(1684) = den(1)*den(1160)
  den(1685) = den(1)*den(1162)
  den(1686) = den(4)*den(942)
  den(1687) = den(4)*den(944)
  den(1688) = den(4)*den(946)
  den(1689) = den(3)*den(954)
  den(1690) = den(3)*den(956)
  den(1691) = den(3)*den(958)
  den(1692) = den(4)*den(948)
  den(1693) = den(4)*den(950)
  den(1694) = den(4)*den(952)
  den(1695) = den(3)*den(960)
  den(1696) = den(3)*den(962)
  den(1697) = den(3)*den(964)
  den(1698) = den(2)*den(1053)
  den(1699) = den(2)*den(1055)
  den(1700) = den(3)*den(982)
  den(1701) = den(3)*den(984)
  den(1702) = den(19)*den(216)
  den(1703) = den(19)*den(218)
  den(1704) = den(2)*den(1061)
  den(1705) = den(2)*den(1063)
  den(1706) = den(3)*den(1002)
  den(1707) = den(3)*den(1004)
  den(1708) = den(19)*den(99)
  den(1709) = den(19)*den(101)
  den(1710) = den(1)*den(1185)
  den(1711) = den(1)*den(1187)
  den(1712) = den(1)*den(1192)
  den(1713) = den(1)*den(1194)
  den(1714) = den(3)*den(1018)
  den(1715) = den(3)*den(1020)
  den(1716) = den(7)*den(212)
  den(1717) = den(7)*den(214)
  den(1718) = den(3)*den(1034)
  den(1719) = den(3)*den(1036)
  den(1720) = den(7)*den(81)
  den(1721) = den(7)*den(83)
  den(1722) = den(2)*den(1090)
  den(1723) = den(2)*den(1092)
  den(1724) = den(4)*den(972)
  den(1725) = den(4)*den(974)
  den(1726) = den(8)*den(77)
  den(1727) = den(8)*den(79)
  den(1728) = den(2)*den(1098)
  den(1729) = den(2)*den(1100)
  den(1730) = den(8)*den(93)
  den(1731) = den(8)*den(95)
  den(1732) = den(4)*den(992)
  den(1733) = den(4)*den(994)
  den(1734) = den(1)*den(1222)
  den(1735) = den(1)*den(1224)
  den(1736) = den(1)*den(1229)
  den(1737) = den(1)*den(1231)
  den(1738) = den(4)*den(1010)
  den(1739) = den(4)*den(1012)
  den(1740) = den(18)*den(85)
  den(1741) = den(18)*den(87)
  den(1742) = den(18)*den(89)
  den(1743) = den(18)*den(91)
  den(1744) = den(4)*den(1026)
  den(1745) = den(4)*den(1028)
  den(1746) = den(1)*den(1300)
  den(1747) = den(1)*den(1302)
  den(1748) = den(1)*den(1306)
  den(1749) = den(1)*den(1308)
  den(1750) = den(1)*den(1310)
  den(1751) = den(1)*den(1312)
  den(1752) = den(18)*den(123)
  den(1753) = den(18)*den(125)
  den(1754) = den(4)*den(1070)
  den(1755) = den(4)*den(1072)
  den(1756) = den(7)*den(132)
  den(1757) = den(7)*den(134)
  den(1758) = den(3)*den(1108)
  den(1759) = den(3)*den(1110)
  den(1760) = den(18)*den(127)
  den(1761) = den(7)*den(136)
  den(1762) = den(4)*den(1076)
  den(1763) = den(3)*den(1113)
  den(1764) = den(2)*den(1275)
  den(1765) = den(2)*den(1277)
  den(1766) = den(8)*den(159)
  den(1767) = den(8)*den(161)
  den(1768) = den(4)*den(1168)
  den(1769) = den(4)*den(1170)
  den(1770) = den(2)*den(1282)
  den(1771) = den(2)*den(1284)
  den(1772) = den(19)*den(170)
  den(1773) = den(19)*den(172)
  den(1774) = den(3)*den(1206)
  den(1775) = den(3)*den(1208)
  den(1776) = den(8)*den(165)
  den(1777) = den(19)*den(168)
  den(1778) = den(2)*den(1286)
  den(1779) = den(2)*den(1288)
  den(1780) = den(4)*den(1174)
  den(1781) = den(3)*den(1211)
  den(1782) = den(10)*den(60)
  den(1783) = den(10)*den(63)
  den(1784) = den(13)*den(193)
  den(1785) = den(16)*den(193)
  den(1786) = den(4)*den(943)
  den(1787) = den(4)*den(945)
  den(1788) = den(4)*den(947)
  den(1789) = den(2)*den(1039)
  den(1790) = den(2)*den(1041)
  den(1791) = den(2)*den(1043)
  den(1792) = den(21)*den(36)
  den(1793) = den(21)*den(39)
  den(1794) = den(24)*den(188)
  den(1795) = den(27)*den(188)
  den(1796) = den(4)*den(949)
  den(1797) = den(4)*den(951)
  den(1798) = den(4)*den(953)
  den(1799) = den(1)*den(1153)
  den(1800) = den(1)*den(1155)
  den(1801) = den(1)*den(1157)
  den(1802) = den(3)*den(955)
  den(1803) = den(3)*den(957)
  den(1804) = den(3)*den(959)
  den(1805) = den(2)*den(1045)
  den(1806) = den(2)*den(1047)
  den(1807) = den(2)*den(1049)
  den(1808) = den(3)*den(961)
  den(1809) = den(3)*den(963)
  den(1810) = den(3)*den(965)
  den(1811) = den(1)*den(1159)
  den(1812) = den(1)*den(1161)
  den(1813) = den(1)*den(1163)
  den(1814) = den(3)*den(977)
  den(1815) = den(188)*den(216)
  den(1816) = den(188)*den(218)
  den(1817) = den(3)*den(983)
  den(1818) = den(3)*den(985)
  den(1819) = den(2)*den(1054)
  den(1820) = den(2)*den(1056)
  den(1821) = den(2)*den(1057)
  den(1822) = den(3)*den(997)
  den(1823) = den(99)*den(188)
  den(1824) = den(101)*den(188)
  den(1825) = den(3)*den(1003)
  den(1826) = den(3)*den(1005)
  den(1827) = den(2)*den(1062)
  den(1828) = den(2)*den(1064)
  den(1829) = den(2)*den(1065)
  den(1830) = den(10)*den(212)
  den(1831) = den(10)*den(214)
  den(1832) = den(3)*den(1019)
  den(1833) = den(3)*den(1021)
  den(1834) = den(1)*den(1186)
  den(1835) = den(1)*den(1188)
  den(1836) = den(1)*den(1189)
  den(1837) = den(10)*den(81)
  den(1838) = den(10)*den(83)
  den(1839) = den(3)*den(1035)
  den(1840) = den(3)*den(1037)
  den(1841) = den(1)*den(1193)
  den(1842) = den(1)*den(1195)
  den(1843) = den(1)*den(1196)
  den(1844) = den(2)*den(1083)
  den(1845) = den(2)*den(1084)
  den(1846) = den(2)*den(1085)
  den(1847) = den(2)*den(1086)
  den(1848) = den(1)*den(1197)
  den(1849) = den(1)*den(1198)
  den(1850) = den(1)*den(1199)
  den(1851) = den(1)*den(1200)
  den(1852) = den(4)*den(967)
  den(1853) = den(77)*den(193)
  den(1854) = den(79)*den(193)
  den(1855) = den(4)*den(973)
  den(1856) = den(4)*den(975)
  den(1857) = den(2)*den(1091)
  den(1858) = den(2)*den(1093)
  den(1859) = den(2)*den(1094)
  den(1860) = den(4)*den(987)
  den(1861) = den(4)*den(993)
  den(1862) = den(4)*den(995)
  den(1863) = den(93)*den(193)
  den(1864) = den(95)*den(193)
  den(1865) = den(2)*den(1099)
  den(1866) = den(2)*den(1101)
  den(1867) = den(2)*den(1102)
  den(1868) = den(21)*den(85)
  den(1869) = den(21)*den(87)
  den(1870) = den(4)*den(1011)
  den(1871) = den(4)*den(1013)
  den(1872) = den(1)*den(1223)
  den(1873) = den(1)*den(1225)
  den(1874) = den(1)*den(1226)
  den(1875) = den(4)*den(1027)
  den(1876) = den(4)*den(1029)
  den(1877) = den(21)*den(89)
  den(1878) = den(21)*den(91)
  den(1879) = den(1)*den(1230)
  den(1880) = den(1)*den(1232)
  den(1881) = den(1)*den(1233)
  den(1882) = den(2)*den(1120)
  den(1883) = den(2)*den(1121)
  den(1884) = den(1)*den(1234)
  den(1885) = den(1)*den(1235)
  den(1886) = den(2)*den(1122)
  den(1887) = den(2)*den(1123)
  den(1888) = den(1)*den(1236)
  den(1889) = den(1)*den(1237)
  den(1890) = den(42)*den(970)
  den(1891) = den(42)*den(971)
  den(1892) = den(54)*den(1016)
  den(1893) = den(54)*den(1017)
  den(1894) = den(32)*den(968)
  den(1895) = den(32)*den(969)
  den(1896) = den(54)*den(1032)
  den(1897) = den(54)*den(1033)
  den(1898) = den(2)*den(1127)
  den(1899) = den(2)*den(1128)
  den(1900) = den(2)*den(1129)
  den(1901) = den(2)*den(1130)
  den(1902) = den(30)*den(1008)
  den(1903) = den(30)*den(1009)
  den(1904) = den(66)*den(980)
  den(1905) = den(66)*den(981)
  den(1906) = den(30)*den(1024)
  den(1907) = den(30)*den(1025)
  den(1908) = den(56)*den(978)
  den(1909) = den(56)*den(979)
  den(1910) = den(2)*den(1134)
  den(1911) = den(2)*den(1135)
  den(1912) = den(2)*den(1136)
  den(1913) = den(2)*den(1137)
  den(1914) = den(42)*den(990)
  den(1915) = den(42)*den(991)
  den(1916) = den(68)*den(1014)
  den(1917) = den(68)*den(1015)
  den(1918) = den(32)*den(988)
  den(1919) = den(32)*den(989)
  den(1920) = den(68)*den(1030)
  den(1921) = den(68)*den(1031)
  den(1922) = den(2)*den(1141)
  den(1923) = den(2)*den(1142)
  den(1924) = den(2)*den(1143)
  den(1925) = den(2)*den(1144)
  den(1926) = den(44)*den(1006)
  den(1927) = den(44)*den(1007)
  den(1928) = den(66)*den(1000)
  den(1929) = den(66)*den(1001)
  den(1930) = den(44)*den(1022)
  den(1931) = den(44)*den(1023)
  den(1932) = den(56)*den(998)
  den(1933) = den(56)*den(999)
  den(1934) = den(2)*den(1148)
  den(1935) = den(2)*den(1149)
  den(1936) = den(2)*den(1150)
  den(1937) = den(2)*den(1151)
  den(1938) = den(1)*den(1250)
  den(1939) = den(1)*den(1251)
  den(1940) = den(1)*den(1252)
  den(1941) = den(1)*den(1253)
  den(1942) = den(1)*den(1254)
  den(1943) = den(1)*den(1255)
  den(1944) = den(1)*den(1256)
  den(1945) = den(1)*den(1257)
  den(1946) = den(1)*den(1258)
  den(1947) = den(1)*den(1259)
  den(1948) = den(1)*den(1260)
  den(1949) = den(1)*den(1261)
  den(1950) = den(1)*den(1262)
  den(1951) = den(1)*den(1263)
  den(1952) = den(1)*den(1264)
  den(1953) = den(1)*den(1265)
  den(1954) = den(4)*den(1071)
  den(1955) = den(4)*den(1073)
  den(1956) = den(21)*den(123)
  den(1957) = den(21)*den(125)
  den(1958) = den(1)*den(1301)
  den(1959) = den(1)*den(1303)
  den(1960) = den(3)*den(1109)
  den(1961) = den(3)*den(1111)
  den(1962) = den(10)*den(132)
  den(1963) = den(10)*den(134)
  den(1964) = den(1)*den(1307)
  den(1965) = den(1)*den(1309)
  den(1966) = den(4)*den(1077)
  den(1967) = den(3)*den(1114)
  den(1968) = den(4)*den(1078)
  den(1969) = den(3)*den(1115)
  den(1970) = den(21)*den(127)
  den(1971) = den(1)*den(1311)
  den(1972) = den(10)*den(136)
  den(1973) = den(1)*den(1313)
  den(1974) = den(4)*den(1079)
  den(1975) = den(4)*den(1080)
  den(1976) = den(3)*den(1116)
  den(1977) = den(3)*den(1117)
  den(1978) = den(4)*den(1081)
  den(1979) = den(1)*den(1315)
  den(1980) = den(3)*den(1118)
  den(1981) = den(1)*den(1317)
  den(1982) = den(4)*den(1082)
  den(1983) = den(3)*den(1119)
  den(1984) = den(30)*den(1068)
  den(1985) = den(30)*den(1069)
  den(1986) = den(30)*den(1075)
  den(1987) = den(3)*den(1131)
  den(1988) = den(3)*den(1132)
  den(1989) = den(3)*den(1133)
  den(1990) = den(106)*den(1051)
  den(1991) = den(106)*den(1052)
  den(1992) = den(114)*den(1050)
  den(1993) = den(44)*den(1066)
  den(1994) = den(44)*den(1067)
  den(1995) = den(44)*den(1074)
  den(1996) = den(3)*den(1145)
  den(1997) = den(3)*den(1146)
  den(1998) = den(3)*den(1147)
  den(1999) = den(106)*den(1059)
  den(2000) = den(106)*den(1060)
  den(2001) = den(114)*den(1058)
  den(2002) = den(1)*den(1334)
  den(2003) = den(1)*den(1335)
  den(2004) = den(1)*den(1336)
  den(2005) = den(1)*den(1337)
  den(2006) = den(1)*den(1338)
  den(2007) = den(1)*den(1339)
  den(2008) = den(54)*den(1106)
  den(2009) = den(54)*den(1107)
  den(2010) = den(54)*den(1112)
  den(2011) = den(4)*den(1124)
  den(2012) = den(4)*den(1125)
  den(2013) = den(4)*den(1126)
  den(2014) = den(110)*den(1088)
  den(2015) = den(110)*den(1089)
  den(2016) = den(117)*den(1087)
  den(2017) = den(68)*den(1103)
  den(2018) = den(4)*den(1138)
  den(2019) = den(68)*den(1104)
  den(2020) = den(68)*den(1105)
  den(2021) = den(4)*den(1139)
  den(2022) = den(4)*den(1140)
  den(2023) = den(117)*den(1095)
  den(2024) = den(110)*den(1096)
  den(2025) = den(110)*den(1097)
  den(2026) = den(1)*den(1356)
  den(2027) = den(1)*den(1357)
  den(2028) = den(1)*den(1358)
  den(2029) = den(1)*den(1359)
  den(2030) = den(1)*den(1360)
  den(2031) = den(1)*den(1361)
  den(2032) = den(4)*den(1169)
  den(2033) = den(4)*den(1171)
  den(2034) = den(159)*den(193)
  den(2035) = den(161)*den(193)
  den(2036) = den(2)*den(1276)
  den(2037) = den(2)*den(1278)
  den(2038) = den(3)*den(1207)
  den(2039) = den(3)*den(1209)
  den(2040) = den(170)*den(188)
  den(2041) = den(172)*den(188)
  den(2042) = den(2)*den(1283)
  den(2043) = den(2)*den(1285)
  den(2044) = den(4)*den(1175)
  den(2045) = den(3)*den(1212)
  den(2046) = den(4)*den(1176)
  den(2047) = den(3)*den(1213)
  den(2048) = den(2)*den(1287)
  den(2049) = den(165)*den(193)
  den(2050) = den(2)*den(1289)
  den(2051) = den(168)*den(188)
  den(2052) = den(4)*den(1177)
  den(2053) = den(4)*den(1178)
  den(2054) = den(3)*den(1214)
  den(2055) = den(3)*den(1215)
  den(2056) = den(4)*den(1179)
  den(2057) = den(2)*den(1293)
  den(2058) = den(3)*den(1217)
  den(2059) = den(2)*den(1295)
  den(2060) = den(4)*den(1182)
  den(2061) = den(3)*den(1219)
  den(2062) = den(42)*den(1166)
  den(2063) = den(42)*den(1167)
  den(2064) = den(32)*den(1164)
  den(2065) = den(32)*den(1165)
  den(2066) = den(2)*den(1325)
  den(2067) = den(2)*den(1326)
  den(2068) = den(2)*den(1327)
  den(2069) = den(2)*den(1328)
  den(2070) = den(32)*den(1172)
  den(2071) = den(3)*den(1239)
  den(2072) = den(2)*den(1329)
  den(2073) = den(42)*den(1173)
  den(2074) = den(3)*den(1241)
  den(2075) = den(2)*den(1330)
  den(2076) = den(3)*den(1244)
  den(2077) = den(3)*den(1245)
  den(2078) = den(3)*den(1248)
  den(2079) = den(3)*den(1249)
  den(2080) = den(142)*den(1183)
  den(2081) = den(142)*den(1184)
  den(2082) = den(142)*den(1190)
  den(2083) = den(142)*den(1191)
  den(2084) = den(150)*den(1180)
  den(2085) = den(150)*den(1181)
  den(2086) = den(56)*den(1201)
  den(2087) = den(4)*den(1238)
  den(2088) = den(2)*den(1344)
  den(2089) = den(66)*den(1204)
  den(2090) = den(66)*den(1205)
  den(2091) = den(56)*den(1202)
  den(2092) = den(56)*den(1203)
  den(2093) = den(2)*den(1348)
  den(2094) = den(2)*den(1349)
  den(2095) = den(2)*den(1350)
  den(2096) = den(2)*den(1351)
  den(2097) = den(66)*den(1210)
  den(2098) = den(4)*den(1240)
  den(2099) = den(2)*den(1352)
  den(2100) = den(4)*den(1242)
  den(2101) = den(4)*den(1243)
  den(2102) = den(4)*den(1246)
  den(2103) = den(4)*den(1247)
  den(2104) = den(153)*den(1216)
  den(2105) = den(146)*den(1220)
  den(2106) = den(146)*den(1221)
  den(2107) = den(146)*den(1227)
  den(2108) = den(146)*den(1228)
  den(2109) = den(153)*den(1218)
  den(2110) = den(4)*den(1318)
  den(2111) = den(3)*den(1340)
  den(2112) = den(4)*den(1319)
  den(2113) = den(3)*den(1341)
  den(2114) = den(117)*den(1266)
  den(2115) = den(114)*den(1267)
  den(2116) = den(150)*den(1269)
  den(2117) = den(153)*den(1268)
  den(2118) = den(4)*den(1320)
  den(2119) = den(3)*den(1342)
  den(2120) = den(4)*den(1321)
  den(2121) = den(3)*den(1343)
  den(2122) = den(106)*den(1271)
  den(2123) = den(110)*den(1270)
  den(2124) = den(4)*den(1322)
  den(2125) = den(117)*den(1272)
  den(2126) = den(4)*den(1323)
  den(2127) = den(4)*den(1324)
  den(2128) = den(110)*den(1273)
  den(2129) = den(110)*den(1274)
  den(2130) = den(3)*den(1345)
  den(2131) = den(114)*den(1279)
  den(2132) = den(3)*den(1346)
  den(2133) = den(3)*den(1347)
  den(2134) = den(106)*den(1280)
  den(2135) = den(106)*den(1281)
  den(2136) = den(4)*den(1331)
  den(2137) = den(3)*den(1353)
  den(2138) = den(4)*den(1332)
  den(2139) = den(4)*den(1333)
  den(2140) = den(3)*den(1354)
  den(2141) = den(3)*den(1355)
  den(2142) = den(153)*den(1290)
  den(2143) = den(150)*den(1291)
  den(2144) = den(142)*den(1297)
  den(2145) = den(142)*den(1304)
  den(2146) = den(142)*den(1305)
  den(2147) = den(146)*den(1296)
  den(2148) = den(146)*den(1298)
  den(2149) = den(146)*den(1299)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif

! **********************************************************************
subroutine allocate_diagrams()
!-----------------------------------------------------------------------
! After the first Born evaluation, colour-stripped amplitudes and
! colour vectors are initialiased with the minimum number of relevant
! helicity states.
! **********************************************************************
#ifndef PRECISION_dp
  use ol_loop_storage_ppllnnjj_ew_nexnmxemucdxsx_4_/**/DREALKIND, only: hel_states
#endif
  implicit none

  if (allocated(A)) deallocate(A)
  if (allocated(M1helarray)) deallocate(M1helarray)
  if (allocated(M1helarray_ct)) deallocate(M1helarray_ct)
  if (allocated(M0_col1_helarray)) deallocate(M0_col1_helarray)
  allocate(A(hel_states,1310))
  allocate(M1helarray(1,hel_states))
  allocate(M1helarray_ct(1,hel_states))
  allocate(M0_col1_helarray(1,hel_states))
#if -1 > 0
  if (allocated(M0M1_hel_cc)) deallocate(M0M1_hel_cc)
  allocate(M0M1_hel_cc(1,hel_states,37))
#endif
end subroutine allocate_diagrams

!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
#else
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
  use ol_loop_storage_ppllnnjj_ew_nexnmxemucdxsx_4_/**/DREALKIND, only: &
  nhel, Hel, hel_states
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for anti-nu_e anti-nu_mu e- mu- up charm anti-down anti-strange -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init, ensure_mp_loop_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_settings_ppllnnjj_ew_nexnmxemucdxsx_4, only: hel_mem_opt, loopcc
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppllnnjj_ew_nexnmxemucdxsx_4, only: &
    & external_perm_ppllnnjj_ew_nexnmxemucdxsx_4, &
    & external_perm_inv_ppllnnjj_ew_nexnmxemucdxsx_4, &
    & extcomb_perm_ppllnnjj_ew_nexnmxemucdxsx_4, &
    & average_factor_ppllnnjj_ew_nexnmxemucdxsx_4
  use ol_external_ppllnnjj_ew_nexnmxemucdxsx_4, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppllnnjj_ew_nexnmxemucdxsx_4_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppllnnjj_ew_nexnmxemucdxsx_4_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_ppllnnjj_ew_nexnmxemucdxsx_4
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,8)
  real(REALKIND),  intent(out) :: M02
  logical, intent(in) :: qp_kinematics
  real(REALKIND),  intent(out), optional :: M2ct
  real(REALKIND),  intent(out), optional :: M2colint(37)
  real(REALKIND) :: iM2ct
  real(REALKIND) :: iM2colint(37)

  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,8)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,8)
#endif
  integer           :: extmasses2(8)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(37)
  complex(REALKIND) :: M1(1), M2(1)
  real(REALKIND)    :: P_scatt_intern(0:3,8)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(37), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak
  logical              :: do_ct, do_colint
#if 8 > 3
  integer :: ind_cc_comb(20)
#endif
  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if (present(M2ct)) then
    do_ct = .true.
  else
    do_ct = .false.
  end if

  if (present(M2colint)) then
    do_colint = .true.
  else
    do_colint = .false.
  end if

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, qp_kinematics, M2ct=iM2ct, M2colint=iM2colint)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,1310))
  end if

  if (do_ct) call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()
  if (do_ct) call ensure_mp_loop_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    call check_forced_parameters()
  end if
  if (do_ct) call fac_init_loop()

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, 0, 0, 0, 0, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_ppllnnjj_ew_nexnmxemucdxsx_4, 8, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_A(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_Q(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_Q(P(:,4), rZERO, H4, ex4, POLSEL(4),4)
  call pol_wf_Q(P(:,5), rZERO, H5, ex5, POLSEL(5),5)
  call pol_wf_Q(P(:,6), rZERO, H6, ex6, POLSEL(6),6)
  call pol_wf_A(P(:,7), rZERO, H7, ex7, POLSEL(7),7)
  call pol_wf_A(P(:,8), rZERO, H8, ex8, POLSEL(8),8)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_W(ntry, ex3(:), ex1(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_QA_W(ntry, ex4(:), ex2(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_QA_W(ntry, ex5(:), ex7(:), wf4(:,3), n3(:,3), t3x4(:,:,3))
  call vert_QA_W(ntry, ex6(:), ex8(:), wf4(:,4), n3(:,4), t3x4(:,:,4))
  call vert_WWV_V(ntry, wf4(:,1), wf4(:,2), wf4(:,3), wf64(:,1), n4(:,1), t4x64(:,:,1))
  call vert_VV_S(ntry, wf4(:,1), wf4(:,3), wf16(:,1), n3(:,5), t3x16(:,:,1))
  call vert_VV_S(ntry, wf4(:,2), wf4(:,4), wf16(:,2), n3(:,6), t3x16(:,:,2))
  call vert_UV_W(ntry, wf4(:,3), 80, wf4(:,1), 5, wf16(:,3), n3(:,7), t3x16(:,:,3))
  call vert_UV_W(ntry, wf4(:,4), 160, wf4(:,2), 10, wf16(:,4), n3(:,8), t3x16(:,:,4))
  call vert_VV_S(ntry, wf4(:,1), wf4(:,4), wf16(:,5), n3(:,9), t3x16(:,:,5))
  call vert_VV_S(ntry, wf4(:,2), wf4(:,3), wf16(:,6), n3(:,10), t3x16(:,:,6))
  call vert_UV_W(ntry, wf4(:,4), 160, wf4(:,1), 5, wf16(:,7), n3(:,11), t3x16(:,:,7))
  call vert_UV_W(ntry, wf4(:,3), 80, wf4(:,2), 10, wf16(:,8), n3(:,12), t3x16(:,:,8))
  call vert_WQ_A(ntry, wf4(:,1), ex6(:), wf8(:,1), n3(:,13), t3x8(:,:,1))
  call vert_AW_Q(ntry, ex8(:), wf4(:,2), wf8(:,2), n3(:,14), t3x8(:,:,2))
  call prop_Q_A(ntry, wf8(:,1), 37, ZERO, 0_intkind1, wf8(:,3), n2(1))
  call prop_A_Q(ntry, wf8(:,2), 138, ZERO, 0_intkind1, wf8(:,4), n2(2))
  call vert_WQ_A(ntry, wf4(:,3), wf8(:,3), wf32(:,1), n3(:,15), t3x32(:,:,1))
  call vert_QA_V(ntry, wf8(:,3), ex8(:), wf16(:,9), n3(:,16), t3x16(:,:,9))
  call vert_QA_Z(gZd,ntry, wf8(:,3), ex8(:), wf16(:,10), n3(:,17), t3x16(:,:,10))
  call vert_WQ_A(ntry, wf4(:,2), ex6(:), wf8(:,5), n3(:,18), t3x8(:,:,3))
  call vert_AW_Q(ntry, ex8(:), wf4(:,1), wf8(:,6), n3(:,19), t3x8(:,:,4))
  call prop_Q_A(ntry, wf8(:,5), 42, ZERO, 0_intkind1, wf8(:,7), n2(3))
  call prop_A_Q(ntry, wf8(:,6), 133, ZERO, 0_intkind1, wf8(:,8), n2(4))
  call vert_WQ_A(ntry, wf4(:,3), wf8(:,7), wf32(:,2), n3(:,20), t3x32(:,:,2))
  call vert_QA_V(ntry, ex6(:), wf8(:,8), wf16(:,11), n3(:,21), t3x16(:,:,11))
  call vert_QA_Z(gZu,ntry, ex6(:), wf8(:,8), wf16(:,12), n3(:,22), t3x16(:,:,12))
  call vert_QA_V(ntry, wf8(:,7), ex8(:), wf16(:,13), n3(:,23), t3x16(:,:,13))
  call vert_QA_Z(gZd,ntry, wf8(:,7), ex8(:), wf16(:,14), n3(:,24), t3x16(:,:,14))
  call vert_QA_V(ntry, ex6(:), wf8(:,4), wf16(:,15), n3(:,25), t3x16(:,:,15))
  call vert_QA_Z(gZu,ntry, ex6(:), wf8(:,4), wf16(:,16), n3(:,26), t3x16(:,:,16))
  call vert_WQ_A(ntry, wf4(:,1), ex5(:), wf8(:,9), n3(:,27), t3x8(:,:,5))
  call vert_AW_Q(ntry, ex7(:), wf4(:,2), wf8(:,10), n3(:,28), t3x8(:,:,6))
  call prop_Q_A(ntry, wf8(:,9), 21, ZERO, 0_intkind1, wf8(:,11), n2(5))
  call prop_A_Q(ntry, wf8(:,10), 74, ZERO, 0_intkind1, wf8(:,12), n2(6))
  call vert_WQ_A(ntry, wf4(:,4), wf8(:,11), wf32(:,3), n3(:,29), t3x32(:,:,3))
  call vert_QA_V(ntry, wf8(:,11), ex7(:), wf16(:,17), n3(:,30), t3x16(:,:,17))
  call vert_QA_Z(gZd,ntry, wf8(:,11), ex7(:), wf16(:,18), n3(:,31), t3x16(:,:,18))
  call vert_WQ_A(ntry, wf4(:,2), ex5(:), wf8(:,13), n3(:,32), t3x8(:,:,7))
  call vert_AW_Q(ntry, ex7(:), wf4(:,1), wf8(:,14), n3(:,33), t3x8(:,:,8))
  call prop_Q_A(ntry, wf8(:,13), 26, ZERO, 0_intkind1, wf8(:,15), n2(7))
  call prop_A_Q(ntry, wf8(:,14), 69, ZERO, 0_intkind1, wf8(:,16), n2(8))
  call vert_WQ_A(ntry, wf4(:,4), wf8(:,15), wf32(:,4), n3(:,34), t3x32(:,:,4))
  call vert_QA_V(ntry, ex5(:), wf8(:,16), wf16(:,19), n3(:,35), t3x16(:,:,19))
  call vert_QA_Z(gZu,ntry, ex5(:), wf8(:,16), wf16(:,20), n3(:,36), t3x16(:,:,20))
  call vert_QA_V(ntry, wf8(:,15), ex7(:), wf16(:,21), n3(:,37), t3x16(:,:,21))
  call vert_QA_Z(gZd,ntry, wf8(:,15), ex7(:), wf16(:,22), n3(:,38), t3x16(:,:,22))
  call vert_QA_V(ntry, ex5(:), wf8(:,12), wf16(:,23), n3(:,39), t3x16(:,:,23))
  call vert_QA_Z(gZu,ntry, ex5(:), wf8(:,12), wf16(:,24), n3(:,40), t3x16(:,:,24))
  call vert_AW_Q(ntry, ex2(:), wf4(:,3), wf8(:,17), n3(:,41), t3x8(:,:,9))
  call prop_A_Q(ntry, wf8(:,17), 82, ZERO, 0_intkind1, wf8(:,18), n2(9))
  call vert_QA_V(ntry, ex4(:), wf8(:,18), wf16(:,25), n3(:,42), t3x16(:,:,25))
  call vert_QA_Z(gZl,ntry, ex4(:), wf8(:,18), wf16(:,26), n3(:,43), t3x16(:,:,26))
  call vert_AW_Q(ntry, ex2(:), wf4(:,4), wf8(:,19), n3(:,44), t3x8(:,:,10))
  call prop_A_Q(ntry, wf8(:,19), 162, ZERO, 0_intkind1, wf8(:,20), n2(10))
  call vert_QA_V(ntry, ex4(:), wf8(:,20), wf16(:,27), n3(:,45), t3x16(:,:,27))
  call vert_QA_Z(gZl,ntry, ex4(:), wf8(:,20), wf16(:,28), n3(:,46), t3x16(:,:,28))
  call vert_WQ_A(ntry, wf4(:,3), ex4(:), wf8(:,21), n3(:,47), t3x8(:,:,11))
  call prop_Q_A(ntry, wf8(:,21), 88, ZERO, 0_intkind1, wf8(:,22), n2(11))
  call vert_QA_Z(gZn,ntry, wf8(:,22), ex2(:), wf16(:,29), n3(:,48), t3x16(:,:,29))
  call vert_WQ_A(ntry, wf4(:,4), ex4(:), wf8(:,23), n3(:,49), t3x8(:,:,12))
  call prop_Q_A(ntry, wf8(:,23), 168, ZERO, 0_intkind1, wf8(:,24), n2(12))
  call vert_QA_Z(gZn,ntry, wf8(:,24), ex2(:), wf16(:,30), n3(:,50), t3x16(:,:,30))
  call vert_AW_Q(ntry, wf8(:,18), wf4(:,1), wf32(:,5), n3(:,51), t3x32(:,:,5))
  call vert_AW_Q(ntry, wf8(:,20), wf4(:,1), wf32(:,6), n3(:,52), t3x32(:,:,6))
  call vert_AW_Q(ntry, ex1(:), wf4(:,3), wf8(:,25), n3(:,53), t3x8(:,:,13))
  call prop_A_Q(ntry, wf8(:,25), 81, ZERO, 0_intkind1, wf8(:,26), n2(13))
  call vert_QA_V(ntry, ex3(:), wf8(:,26), wf16(:,31), n3(:,54), t3x16(:,:,31))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,26), wf16(:,32), n3(:,55), t3x16(:,:,32))
  call vert_AW_Q(ntry, ex1(:), wf4(:,4), wf8(:,27), n3(:,56), t3x8(:,:,14))
  call prop_A_Q(ntry, wf8(:,27), 161, ZERO, 0_intkind1, wf8(:,28), n2(14))
  call vert_QA_V(ntry, ex3(:), wf8(:,28), wf16(:,33), n3(:,57), t3x16(:,:,33))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,28), wf16(:,34), n3(:,58), t3x16(:,:,34))
  call vert_WQ_A(ntry, wf4(:,3), ex3(:), wf8(:,29), n3(:,59), t3x8(:,:,15))
  call prop_Q_A(ntry, wf8(:,29), 84, ZERO, 0_intkind1, wf8(:,30), n2(15))
  call vert_QA_Z(gZn,ntry, wf8(:,30), ex1(:), wf16(:,35), n3(:,60), t3x16(:,:,35))
  call vert_WQ_A(ntry, wf4(:,4), ex3(:), wf8(:,31), n3(:,61), t3x8(:,:,16))
  call prop_Q_A(ntry, wf8(:,31), 164, ZERO, 0_intkind1, wf8(:,32), n2(16))
  call vert_QA_Z(gZn,ntry, wf8(:,32), ex1(:), wf16(:,36), n3(:,62), t3x16(:,:,36))
  call vert_AW_Q(ntry, wf8(:,26), wf4(:,2), wf32(:,7), n3(:,63), t3x32(:,:,7))
  call vert_AW_Q(ntry, wf8(:,28), wf4(:,2), wf32(:,8), n3(:,64), t3x32(:,:,8))
  call counter_WWV_V(EWctWWWW,ntry, wf4(:,1), wf4(:,2), wf4(:,3), wf64(:,2), n4(:,2), t4x64(:,:,2))
  call counter_QA_W(ntry, ex6(:), ex8(:), wf4(:,5), n3(:,65), t3x4(:,:,5))
  call counter_QA_W(ntry, ex5(:), ex7(:), wf4(:,6), n3(:,66), t3x4(:,:,6))
  call vert_WWV_V(ntry, wf4(:,1), wf4(:,2), wf4(:,6), wf64(:,3), n4(:,3), t4x64(:,:,3))
  call counter_QA_W(ntry, ex4(:), ex2(:), wf4(:,7), n3(:,67), t3x4(:,:,7))
  call vert_WWV_V(ntry, wf4(:,1), wf4(:,7), wf4(:,3), wf64(:,4), n4(:,4), t4x64(:,:,4))
  call counter_QA_W(ntry, ex3(:), ex1(:), wf4(:,8), n3(:,68), t3x4(:,:,8))
  call vert_WWV_V(ntry, wf4(:,8), wf4(:,2), wf4(:,3), wf64(:,5), n4(:,5), t4x64(:,:,5))
  call counter_VV_S(ntry, wf4(:,2), wf4(:,4), wf16(:,37), n3(:,69), t3x16(:,:,37))
  call counter_UV_W(ntry, wf4(:,4), 160, wf4(:,2), 10, wf16(:,38), n3(:,70), t3x16(:,:,38))
  call counter_VV_S(ntry, wf4(:,2), wf4(:,3), wf16(:,39), n3(:,71), t3x16(:,:,39))
  call counter_UV_W(ntry, wf4(:,3), 80, wf4(:,2), 10, wf16(:,40), n3(:,72), t3x16(:,:,40))
  call counter_VV_S(ntry, wf4(:,1), wf4(:,4), wf16(:,41), n3(:,73), t3x16(:,:,41))
  call counter_UV_W(ntry, wf4(:,4), 160, wf4(:,1), 5, wf16(:,42), n3(:,74), t3x16(:,:,42))
  call counter_VV_S(ntry, wf4(:,1), wf4(:,3), wf16(:,43), n3(:,75), t3x16(:,:,43))
  call counter_UV_W(ntry, wf4(:,3), 80, wf4(:,1), 5, wf16(:,44), n3(:,76), t3x16(:,:,44))
  call vert_WWV_V(ntry, wf4(:,3), wf4(:,4), wf4(:,2), wf64(:,6), n4(:,6), t4x64(:,:,6))
  call counter_V_V(EWctWW,ntry, wf4(:,1), 5, wf4(:,9), n2(17))
  call vert_WWV_V(ntry, wf4(:,3), wf4(:,4), wf4(:,1), wf64(:,7), n4(:,7), t4x64(:,:,7))
  call counter_V_V(EWctWW,ntry, wf4(:,2), 10, wf4(:,10), n2(18))
  call vert_WWV_V(ntry, wf4(:,1), wf4(:,2), wf4(:,4), wf64(:,8), n4(:,8), t4x64(:,:,8))
  call counter_V_V(EWctWW,ntry, wf4(:,3), 80, wf4(:,11), n2(19))
  call counter_V_V(EWctWW,ntry, wf4(:,4), 160, wf4(:,12), n2(20))
  call counter_WQ_A(ntry, wf4(:,3), wf8(:,3), wf32(:,9), n3(:,77), t3x32(:,:,9))
  call counter_WQ_A(ntry, wf4(:,3), wf8(:,7), wf32(:,10), n3(:,78), t3x32(:,:,10))
  call counter_QA_V_LR(EWctAdd,ntry, wf8(:,3), ex8(:), wf16(:,45), n3(:,79), t3x16(:,:,45))
  call counter_QA_Z(EWctVdd,ntry, wf8(:,3), ex8(:), wf16(:,46), n3(:,80), t3x16(:,:,46))
  call counter_AW_Q(ntry, ex8(:), wf4(:,2), wf8(:,33), n3(:,81), t3x8(:,:,17))
  call prop_A_Q(ntry, wf8(:,33), 138, ZERO, 0_intkind1, wf8(:,34), n2(21))
  call counter_QA_V_LR(EWctAdd,ntry, wf8(:,7), ex8(:), wf16(:,47), n3(:,82), t3x16(:,:,47))
  call counter_QA_Z(EWctVdd,ntry, wf8(:,7), ex8(:), wf16(:,48), n3(:,83), t3x16(:,:,48))
  call vert_QA_V(ntry, ex6(:), wf8(:,34), wf16(:,49), n3(:,84), t3x16(:,:,49))
  call vert_QA_Z(gZu,ntry, ex6(:), wf8(:,34), wf16(:,50), n3(:,85), t3x16(:,:,50))
  call counter_AW_Q(ntry, ex8(:), wf4(:,1), wf8(:,35), n3(:,86), t3x8(:,:,18))
  call prop_A_Q(ntry, wf8(:,35), 133, ZERO, 0_intkind1, wf8(:,36), n2(22))
  call vert_QA_V(ntry, ex6(:), wf8(:,36), wf16(:,51), n3(:,87), t3x16(:,:,51))
  call vert_QA_Z(gZu,ntry, ex6(:), wf8(:,36), wf16(:,52), n3(:,88), t3x16(:,:,52))
  call counter_WQ_A(ntry, wf4(:,4), wf8(:,11), wf32(:,11), n3(:,89), t3x32(:,:,11))
  call counter_WQ_A(ntry, wf4(:,4), wf8(:,15), wf32(:,12), n3(:,90), t3x32(:,:,12))
  call counter_QA_V_LR(EWctAdd,ntry, wf8(:,11), ex7(:), wf16(:,53), n3(:,91), t3x16(:,:,53))
  call counter_QA_Z(EWctVdd,ntry, wf8(:,11), ex7(:), wf16(:,54), n3(:,92), t3x16(:,:,54))
  call counter_AW_Q(ntry, ex7(:), wf4(:,2), wf8(:,37), n3(:,93), t3x8(:,:,19))
  call prop_A_Q(ntry, wf8(:,37), 74, ZERO, 0_intkind1, wf8(:,38), n2(23))
  call counter_QA_V_LR(EWctAdd,ntry, wf8(:,15), ex7(:), wf16(:,55), n3(:,94), t3x16(:,:,55))
  call counter_QA_Z(EWctVdd,ntry, wf8(:,15), ex7(:), wf16(:,56), n3(:,95), t3x16(:,:,56))
  call vert_QA_V(ntry, ex5(:), wf8(:,38), wf16(:,57), n3(:,96), t3x16(:,:,57))
  call vert_QA_Z(gZu,ntry, ex5(:), wf8(:,38), wf16(:,58), n3(:,97), t3x16(:,:,58))
  call counter_AW_Q(ntry, ex7(:), wf4(:,1), wf8(:,39), n3(:,98), t3x8(:,:,20))
  call prop_A_Q(ntry, wf8(:,39), 69, ZERO, 0_intkind1, wf8(:,40), n2(24))
  call vert_QA_V(ntry, ex5(:), wf8(:,40), wf16(:,59), n3(:,99), t3x16(:,:,59))
  call vert_QA_Z(gZu,ntry, ex5(:), wf8(:,40), wf16(:,60), n3(:,100), t3x16(:,:,60))
  call counter_QA_V_LR(EWctAuu,ntry, ex6(:), wf8(:,8), wf16(:,61), n3(:,101), t3x16(:,:,61))
  call counter_QA_Z(EWctVuu,ntry, ex6(:), wf8(:,8), wf16(:,62), n3(:,102), t3x16(:,:,62))
  call counter_WQ_A(ntry, wf4(:,2), ex6(:), wf8(:,41), n3(:,103), t3x8(:,:,21))
  call prop_Q_A(ntry, wf8(:,41), 42, ZERO, 0_intkind1, wf8(:,42), n2(25))
  call vert_WQ_A(ntry, wf4(:,3), wf8(:,42), wf32(:,13), n3(:,104), t3x32(:,:,13))
  call counter_QA_V_LR(EWctAuu,ntry, ex6(:), wf8(:,4), wf16(:,63), n3(:,105), t3x16(:,:,63))
  call counter_QA_Z(EWctVuu,ntry, ex6(:), wf8(:,4), wf16(:,64), n3(:,106), t3x16(:,:,64))
  call vert_QA_V(ntry, wf8(:,42), ex8(:), wf16(:,65), n3(:,107), t3x16(:,:,65))
  call vert_QA_Z(gZd,ntry, wf8(:,42), ex8(:), wf16(:,66), n3(:,108), t3x16(:,:,66))
  call counter_WQ_A(ntry, wf4(:,1), ex6(:), wf8(:,43), n3(:,109), t3x8(:,:,22))
  call prop_Q_A(ntry, wf8(:,43), 37, ZERO, 0_intkind1, wf8(:,44), n2(26))
  call vert_WQ_A(ntry, wf4(:,3), wf8(:,44), wf32(:,14), n3(:,110), t3x32(:,:,14))
  call vert_QA_V(ntry, wf8(:,44), ex8(:), wf16(:,67), n3(:,111), t3x16(:,:,67))
  call vert_QA_Z(gZd,ntry, wf8(:,44), ex8(:), wf16(:,68), n3(:,112), t3x16(:,:,68))
  call counter_AQ_S(EWctPdu,ntry, ex8(:), ex6(:), wf4(:,13), n3(:,113), t3x4(:,:,9))
  call vert_VS_T(ntry, wf4(:,2), 10, wf4(:,13), 160, wf16(:,69), n3(:,114), t3x16(:,:,69))
  call vert_SV_V(ntry, wf4(:,13), wf4(:,2), wf16(:,70), n3(:,115), t3x16(:,:,70))
  call vert_VV_S(ntry, wf4(:,2), wf4(:,5), wf16(:,71), n3(:,116), t3x16(:,:,71))
  call vert_UV_W(ntry, wf4(:,5), 160, wf4(:,2), 10, wf16(:,72), n3(:,117), t3x16(:,:,72))
  call vert_VS_T(ntry, wf4(:,1), 5, wf4(:,13), 160, wf16(:,73), n3(:,118), t3x16(:,:,73))
  call vert_SV_V(ntry, wf4(:,13), wf4(:,1), wf16(:,74), n3(:,119), t3x16(:,:,74))
  call vert_VV_S(ntry, wf4(:,1), wf4(:,5), wf16(:,75), n3(:,120), t3x16(:,:,75))
  call vert_UV_W(ntry, wf4(:,5), 160, wf4(:,1), 5, wf16(:,76), n3(:,121), t3x16(:,:,76))
  call vert_WQ_A(ntry, wf4(:,5), wf8(:,11), wf32(:,15), n3(:,122), t3x32(:,:,15))
  call vert_WQ_A(ntry, wf4(:,5), wf8(:,15), wf32(:,16), n3(:,123), t3x32(:,:,16))
  call counter_QA_V_LR(EWctAuu,ntry, ex5(:), wf8(:,16), wf16(:,77), n3(:,124), t3x16(:,:,77))
  call counter_QA_Z(EWctVuu,ntry, ex5(:), wf8(:,16), wf16(:,78), n3(:,125), t3x16(:,:,78))
  call counter_WQ_A(ntry, wf4(:,2), ex5(:), wf8(:,45), n3(:,126), t3x8(:,:,23))
  call prop_Q_A(ntry, wf8(:,45), 26, ZERO, 0_intkind1, wf8(:,46), n2(27))
  call vert_WQ_A(ntry, wf4(:,4), wf8(:,46), wf32(:,17), n3(:,127), t3x32(:,:,17))
  call counter_QA_V_LR(EWctAuu,ntry, ex5(:), wf8(:,12), wf16(:,79), n3(:,128), t3x16(:,:,79))
  call counter_QA_Z(EWctVuu,ntry, ex5(:), wf8(:,12), wf16(:,80), n3(:,129), t3x16(:,:,80))
  call vert_QA_V(ntry, wf8(:,46), ex7(:), wf16(:,81), n3(:,130), t3x16(:,:,81))
  call vert_QA_Z(gZd,ntry, wf8(:,46), ex7(:), wf16(:,82), n3(:,131), t3x16(:,:,82))
  call counter_WQ_A(ntry, wf4(:,1), ex5(:), wf8(:,47), n3(:,132), t3x8(:,:,24))
  call prop_Q_A(ntry, wf8(:,47), 21, ZERO, 0_intkind1, wf8(:,48), n2(28))
  call vert_WQ_A(ntry, wf4(:,4), wf8(:,48), wf32(:,18), n3(:,133), t3x32(:,:,18))
  call vert_QA_V(ntry, wf8(:,48), ex7(:), wf16(:,83), n3(:,134), t3x16(:,:,83))
  call vert_QA_Z(gZd,ntry, wf8(:,48), ex7(:), wf16(:,84), n3(:,135), t3x16(:,:,84))
  call vert_VV_S(ntry, wf4(:,1), wf4(:,6), wf16(:,85), n3(:,136), t3x16(:,:,85))
  call vert_UV_W(ntry, wf4(:,6), 80, wf4(:,1), 5, wf16(:,86), n3(:,137), t3x16(:,:,86))
  call vert_VV_S(ntry, wf4(:,2), wf4(:,6), wf16(:,87), n3(:,138), t3x16(:,:,87))
  call vert_UV_W(ntry, wf4(:,6), 80, wf4(:,2), 10, wf16(:,88), n3(:,139), t3x16(:,:,88))
  call vert_WQ_A(ntry, wf4(:,6), wf8(:,3), wf32(:,19), n3(:,140), t3x32(:,:,19))
  call vert_WQ_A(ntry, wf4(:,6), wf8(:,7), wf32(:,20), n3(:,141), t3x32(:,:,20))
  call counter_AW_Q(ntry, wf8(:,18), wf4(:,1), wf32(:,21), n3(:,142), t3x32(:,:,21))
  call counter_AW_Q(ntry, wf8(:,20), wf4(:,1), wf32(:,22), n3(:,143), t3x32(:,:,22))
  call vert_WQ_A(ntry, wf4(:,5), ex4(:), wf8(:,49), n3(:,144), t3x8(:,:,25))
  call prop_Q_A(ntry, wf8(:,49), 168, ZERO, 0_intkind1, wf8(:,50), n2(29))
  call vert_QA_Z(gZn,ntry, wf8(:,50), ex2(:), wf16(:,89), n3(:,145), t3x16(:,:,89))
  call vert_AW_Q(ntry, ex2(:), wf4(:,5), wf8(:,51), n3(:,146), t3x8(:,:,26))
  call prop_A_Q(ntry, wf8(:,51), 162, ZERO, 0_intkind1, wf8(:,52), n2(30))
  call vert_QA_V(ntry, ex4(:), wf8(:,52), wf16(:,90), n3(:,147), t3x16(:,:,90))
  call vert_QA_Z(gZl,ntry, ex4(:), wf8(:,52), wf16(:,91), n3(:,148), t3x16(:,:,91))
  call vert_AW_Q(ntry, wf8(:,52), wf4(:,1), wf32(:,23), n3(:,149), t3x32(:,:,23))
  call vert_WQ_A(ntry, wf4(:,6), ex4(:), wf8(:,53), n3(:,150), t3x8(:,:,27))
  call prop_Q_A(ntry, wf8(:,53), 88, ZERO, 0_intkind1, wf8(:,54), n2(31))
  call vert_QA_Z(gZn,ntry, wf8(:,54), ex2(:), wf16(:,92), n3(:,151), t3x16(:,:,92))
  call vert_AW_Q(ntry, ex2(:), wf4(:,6), wf8(:,55), n3(:,152), t3x8(:,:,28))
  call prop_A_Q(ntry, wf8(:,55), 82, ZERO, 0_intkind1, wf8(:,56), n2(32))
  call vert_QA_V(ntry, ex4(:), wf8(:,56), wf16(:,93), n3(:,153), t3x16(:,:,93))
  call vert_QA_Z(gZl,ntry, ex4(:), wf8(:,56), wf16(:,94), n3(:,154), t3x16(:,:,94))
  call vert_AW_Q(ntry, wf8(:,56), wf4(:,1), wf32(:,24), n3(:,155), t3x32(:,:,24))
  call counter_WQ_A(ntry, wf4(:,4), ex4(:), wf8(:,57), n3(:,156), t3x8(:,:,29))
  call prop_Q_A(ntry, wf8(:,57), 168, ZERO, 0_intkind1, wf8(:,58), n2(33))
  call counter_WQ_A(ntry, wf4(:,3), ex4(:), wf8(:,59), n3(:,157), t3x8(:,:,30))
  call prop_Q_A(ntry, wf8(:,59), 88, ZERO, 0_intkind1, wf8(:,60), n2(34))
  call counter_QA_Z(EWctAee,ntry, ex4(:), wf8(:,18), wf16(:,95), n3(:,158), t3x16(:,:,95))
  call counter_QA_Z(EWctVee,ntry, ex4(:), wf8(:,18), wf16(:,96), n3(:,159), t3x16(:,:,96))
  call counter_QA_Z(EWctAee,ntry, ex4(:), wf8(:,20), wf16(:,97), n3(:,160), t3x16(:,:,97))
  call counter_QA_Z(EWctVee,ntry, ex4(:), wf8(:,20), wf16(:,98), n3(:,161), t3x16(:,:,98))
  call vert_QA_Z(gZn,ntry, wf8(:,60), ex2(:), wf16(:,99), n3(:,162), t3x16(:,:,99))
  call vert_QA_Z(gZn,ntry, wf8(:,58), ex2(:), wf16(:,100), n3(:,163), t3x16(:,:,100))
  call counter_AW_Q(ntry, wf8(:,26), wf4(:,2), wf32(:,25), n3(:,164), t3x32(:,:,25))
  call counter_AW_Q(ntry, wf8(:,28), wf4(:,2), wf32(:,26), n3(:,165), t3x32(:,:,26))
  call vert_WQ_A(ntry, wf4(:,5), ex3(:), wf8(:,61), n3(:,166), t3x8(:,:,31))
  call prop_Q_A(ntry, wf8(:,61), 164, ZERO, 0_intkind1, wf8(:,62), n2(35))
  call vert_QA_Z(gZn,ntry, wf8(:,62), ex1(:), wf16(:,101), n3(:,167), t3x16(:,:,101))
  call vert_AW_Q(ntry, ex1(:), wf4(:,5), wf8(:,63), n3(:,168), t3x8(:,:,32))
  call prop_A_Q(ntry, wf8(:,63), 161, ZERO, 0_intkind1, wf8(:,64), n2(36))
  call vert_QA_V(ntry, ex3(:), wf8(:,64), wf16(:,102), n3(:,169), t3x16(:,:,102))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,64), wf16(:,103), n3(:,170), t3x16(:,:,103))
  call vert_AW_Q(ntry, wf8(:,64), wf4(:,2), wf32(:,27), n3(:,171), t3x32(:,:,27))
  call vert_WQ_A(ntry, wf4(:,6), ex3(:), wf8(:,65), n3(:,172), t3x8(:,:,33))
  call prop_Q_A(ntry, wf8(:,65), 84, ZERO, 0_intkind1, wf8(:,66), n2(37))
  call vert_QA_Z(gZn,ntry, wf8(:,66), ex1(:), wf16(:,104), n3(:,173), t3x16(:,:,104))
  call vert_AW_Q(ntry, ex1(:), wf4(:,6), wf8(:,67), n3(:,174), t3x8(:,:,34))
  call prop_A_Q(ntry, wf8(:,67), 81, ZERO, 0_intkind1, wf8(:,68), n2(38))
  call vert_QA_V(ntry, ex3(:), wf8(:,68), wf16(:,105), n3(:,175), t3x16(:,:,105))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,68), wf16(:,106), n3(:,176), t3x16(:,:,106))
  call vert_AW_Q(ntry, wf8(:,68), wf4(:,2), wf32(:,28), n3(:,177), t3x32(:,:,28))
  call counter_WQ_A(ntry, wf4(:,4), ex3(:), wf8(:,69), n3(:,178), t3x8(:,:,35))
  call prop_Q_A(ntry, wf8(:,69), 164, ZERO, 0_intkind1, wf8(:,70), n2(39))
  call counter_WQ_A(ntry, wf4(:,3), ex3(:), wf8(:,71), n3(:,179), t3x8(:,:,36))
  call prop_Q_A(ntry, wf8(:,71), 84, ZERO, 0_intkind1, wf8(:,72), n2(40))
  call counter_QA_Z(EWctAee,ntry, ex3(:), wf8(:,26), wf16(:,107), n3(:,180), t3x16(:,:,107))
  call counter_QA_Z(EWctVee,ntry, ex3(:), wf8(:,26), wf16(:,108), n3(:,181), t3x16(:,:,108))
  call counter_QA_Z(EWctAee,ntry, ex3(:), wf8(:,28), wf16(:,109), n3(:,182), t3x16(:,:,109))
  call counter_QA_Z(EWctVee,ntry, ex3(:), wf8(:,28), wf16(:,110), n3(:,183), t3x16(:,:,110))
  call vert_QA_Z(gZn,ntry, wf8(:,72), ex1(:), wf16(:,111), n3(:,184), t3x16(:,:,111))
  call vert_QA_Z(gZn,ntry, wf8(:,70), ex1(:), wf16(:,112), n3(:,185), t3x16(:,:,112))
  call counter_AW_Q(ntry, ex2(:), wf4(:,3), wf8(:,73), n3(:,186), t3x8(:,:,37))
  call prop_A_Q(ntry, wf8(:,73), 82, ZERO, 0_intkind1, wf8(:,74), n2(41))
  call vert_QA_V(ntry, ex4(:), wf8(:,74), wf16(:,113), n3(:,187), t3x16(:,:,113))
  call vert_QA_Z(gZl,ntry, ex4(:), wf8(:,74), wf16(:,114), n3(:,188), t3x16(:,:,114))
  call counter_AW_Q(ntry, ex2(:), wf4(:,4), wf8(:,75), n3(:,189), t3x8(:,:,38))
  call prop_A_Q(ntry, wf8(:,75), 162, ZERO, 0_intkind1, wf8(:,76), n2(42))
  call vert_QA_V(ntry, ex4(:), wf8(:,76), wf16(:,115), n3(:,190), t3x16(:,:,115))
  call vert_QA_Z(gZl,ntry, ex4(:), wf8(:,76), wf16(:,116), n3(:,191), t3x16(:,:,116))
  call counter_QA_Z(EWctAnn,ntry, wf8(:,22), ex2(:), wf16(:,117), n3(:,192), t3x16(:,:,117))
  call counter_QA_Z(EWctVnn,ntry, wf8(:,22), ex2(:), wf16(:,118), n3(:,193), t3x16(:,:,118))
  call counter_QA_Z(EWctAnn,ntry, wf8(:,24), ex2(:), wf16(:,119), n3(:,194), t3x16(:,:,119))
  call counter_QA_Z(EWctVnn,ntry, wf8(:,24), ex2(:), wf16(:,120), n3(:,195), t3x16(:,:,120))
  call vert_AW_Q(ntry, wf8(:,74), wf4(:,1), wf32(:,29), n3(:,196), t3x32(:,:,29))
  call vert_AW_Q(ntry, wf8(:,76), wf4(:,1), wf32(:,30), n3(:,197), t3x32(:,:,30))
  call vert_VV_S(ntry, wf4(:,7), wf4(:,4), wf16(:,121), n3(:,198), t3x16(:,:,121))
  call vert_UV_W(ntry, wf4(:,4), 160, wf4(:,7), 10, wf16(:,122), n3(:,199), t3x16(:,:,122))
  call vert_VV_S(ntry, wf4(:,7), wf4(:,3), wf16(:,123), n3(:,200), t3x16(:,:,123))
  call vert_UV_W(ntry, wf4(:,3), 80, wf4(:,7), 10, wf16(:,124), n3(:,201), t3x16(:,:,124))
  call vert_AW_Q(ntry, ex8(:), wf4(:,7), wf8(:,77), n3(:,202), t3x8(:,:,39))
  call prop_A_Q(ntry, wf8(:,77), 138, ZERO, 0_intkind1, wf8(:,78), n2(43))
  call vert_WQ_A(ntry, wf4(:,7), ex6(:), wf8(:,79), n3(:,203), t3x8(:,:,40))
  call prop_Q_A(ntry, wf8(:,79), 42, ZERO, 0_intkind1, wf8(:,80), n2(44))
  call vert_WQ_A(ntry, wf4(:,3), wf8(:,80), wf32(:,31), n3(:,204), t3x32(:,:,31))
  call vert_QA_V(ntry, wf8(:,80), ex8(:), wf16(:,125), n3(:,205), t3x16(:,:,125))
  call vert_QA_Z(gZd,ntry, wf8(:,80), ex8(:), wf16(:,126), n3(:,206), t3x16(:,:,126))
  call vert_QA_V(ntry, ex6(:), wf8(:,78), wf16(:,127), n3(:,207), t3x16(:,:,127))
  call vert_QA_Z(gZu,ntry, ex6(:), wf8(:,78), wf16(:,128), n3(:,208), t3x16(:,:,128))
  call vert_AW_Q(ntry, ex7(:), wf4(:,7), wf8(:,81), n3(:,209), t3x8(:,:,41))
  call prop_A_Q(ntry, wf8(:,81), 74, ZERO, 0_intkind1, wf8(:,82), n2(45))
  call vert_WQ_A(ntry, wf4(:,7), ex5(:), wf8(:,83), n3(:,210), t3x8(:,:,42))
  call prop_Q_A(ntry, wf8(:,83), 26, ZERO, 0_intkind1, wf8(:,84), n2(46))
  call vert_WQ_A(ntry, wf4(:,4), wf8(:,84), wf32(:,32), n3(:,211), t3x32(:,:,32))
  call vert_QA_V(ntry, wf8(:,84), ex7(:), wf16(:,129), n3(:,212), t3x16(:,:,129))
  call vert_QA_Z(gZd,ntry, wf8(:,84), ex7(:), wf16(:,130), n3(:,213), t3x16(:,:,130))
  call vert_QA_V(ntry, ex5(:), wf8(:,82), wf16(:,131), n3(:,214), t3x16(:,:,131))
  call vert_QA_Z(gZu,ntry, ex5(:), wf8(:,82), wf16(:,132), n3(:,215), t3x16(:,:,132))
  call vert_AW_Q(ntry, wf8(:,26), wf4(:,7), wf32(:,33), n3(:,216), t3x32(:,:,33))
  call vert_AW_Q(ntry, wf8(:,28), wf4(:,7), wf32(:,34), n3(:,217), t3x32(:,:,34))
  call counter_AW_Q(ntry, ex1(:), wf4(:,3), wf8(:,85), n3(:,218), t3x8(:,:,43))
  call prop_A_Q(ntry, wf8(:,85), 81, ZERO, 0_intkind1, wf8(:,86), n2(47))
  call vert_QA_V(ntry, ex3(:), wf8(:,86), wf16(:,133), n3(:,219), t3x16(:,:,133))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,86), wf16(:,134), n3(:,220), t3x16(:,:,134))
  call counter_AW_Q(ntry, ex1(:), wf4(:,4), wf8(:,87), n3(:,221), t3x8(:,:,44))
  call prop_A_Q(ntry, wf8(:,87), 161, ZERO, 0_intkind1, wf8(:,88), n2(48))
  call vert_QA_V(ntry, ex3(:), wf8(:,88), wf16(:,135), n3(:,222), t3x16(:,:,135))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,88), wf16(:,136), n3(:,223), t3x16(:,:,136))
  call counter_QA_Z(EWctAnn,ntry, wf8(:,30), ex1(:), wf16(:,137), n3(:,224), t3x16(:,:,137))
  call counter_QA_Z(EWctVnn,ntry, wf8(:,30), ex1(:), wf16(:,138), n3(:,225), t3x16(:,:,138))
  call counter_QA_Z(EWctAnn,ntry, wf8(:,32), ex1(:), wf16(:,139), n3(:,226), t3x16(:,:,139))
  call counter_QA_Z(EWctVnn,ntry, wf8(:,32), ex1(:), wf16(:,140), n3(:,227), t3x16(:,:,140))
  call vert_AW_Q(ntry, wf8(:,86), wf4(:,2), wf32(:,35), n3(:,228), t3x32(:,:,35))
  call vert_AW_Q(ntry, wf8(:,88), wf4(:,2), wf32(:,36), n3(:,229), t3x32(:,:,36))
  call vert_VV_S(ntry, wf4(:,8), wf4(:,3), wf16(:,141), n3(:,230), t3x16(:,:,141))
  call vert_UV_W(ntry, wf4(:,3), 80, wf4(:,8), 5, wf16(:,142), n3(:,231), t3x16(:,:,142))
  call vert_VV_S(ntry, wf4(:,8), wf4(:,4), wf16(:,143), n3(:,232), t3x16(:,:,143))
  call vert_UV_W(ntry, wf4(:,4), 160, wf4(:,8), 5, wf16(:,144), n3(:,233), t3x16(:,:,144))
  call vert_WQ_A(ntry, wf4(:,8), ex6(:), wf8(:,89), n3(:,234), t3x8(:,:,45))
  call prop_Q_A(ntry, wf8(:,89), 37, ZERO, 0_intkind1, wf8(:,90), n2(49))
  call vert_WQ_A(ntry, wf4(:,3), wf8(:,90), wf32(:,37), n3(:,235), t3x32(:,:,37))
  call vert_QA_V(ntry, wf8(:,90), ex8(:), wf16(:,145), n3(:,236), t3x16(:,:,145))
  call vert_QA_Z(gZd,ntry, wf8(:,90), ex8(:), wf16(:,146), n3(:,237), t3x16(:,:,146))
  call vert_AW_Q(ntry, ex8(:), wf4(:,8), wf8(:,91), n3(:,238), t3x8(:,:,46))
  call prop_A_Q(ntry, wf8(:,91), 133, ZERO, 0_intkind1, wf8(:,92), n2(50))
  call vert_QA_V(ntry, ex6(:), wf8(:,92), wf16(:,147), n3(:,239), t3x16(:,:,147))
  call vert_QA_Z(gZu,ntry, ex6(:), wf8(:,92), wf16(:,148), n3(:,240), t3x16(:,:,148))
  call vert_WQ_A(ntry, wf4(:,8), ex5(:), wf8(:,93), n3(:,241), t3x8(:,:,47))
  call prop_Q_A(ntry, wf8(:,93), 21, ZERO, 0_intkind1, wf8(:,94), n2(51))
  call vert_WQ_A(ntry, wf4(:,4), wf8(:,94), wf32(:,38), n3(:,242), t3x32(:,:,38))
  call vert_QA_V(ntry, wf8(:,94), ex7(:), wf16(:,149), n3(:,243), t3x16(:,:,149))
  call vert_QA_Z(gZd,ntry, wf8(:,94), ex7(:), wf16(:,150), n3(:,244), t3x16(:,:,150))
  call vert_AW_Q(ntry, ex7(:), wf4(:,8), wf8(:,95), n3(:,245), t3x8(:,:,48))
  call prop_A_Q(ntry, wf8(:,95), 69, ZERO, 0_intkind1, wf8(:,96), n2(52))
  call vert_QA_V(ntry, ex5(:), wf8(:,96), wf16(:,151), n3(:,246), t3x16(:,:,151))
  call vert_QA_Z(gZu,ntry, ex5(:), wf8(:,96), wf16(:,152), n3(:,247), t3x16(:,:,152))
  call vert_AW_Q(ntry, wf8(:,18), wf4(:,8), wf32(:,39), n3(:,248), t3x32(:,:,39))
  call vert_AW_Q(ntry, wf8(:,20), wf4(:,8), wf32(:,40), n3(:,249), t3x32(:,:,40))
  call counter_V_S(EWctPW,ntry, wf4(:,1), 5, wf4(:,14), n2(53))
  call vert_VS_T(ntry, wf4(:,3), 80, wf4(:,14), 5, wf16(:,153), n3(:,250), t3x16(:,:,153))
  call vert_SV_V(ntry, wf4(:,14), wf4(:,3), wf16(:,154), n3(:,251), t3x16(:,:,154))
  call vert_VV_S(ntry, wf4(:,9), wf4(:,3), wf16(:,155), n3(:,252), t3x16(:,:,155))
  call vert_UV_W(ntry, wf4(:,3), 80, wf4(:,9), 5, wf16(:,156), n3(:,253), t3x16(:,:,156))
  call vert_VS_T(ntry, wf4(:,4), 160, wf4(:,14), 5, wf16(:,157), n3(:,254), t3x16(:,:,157))
  call vert_SV_V(ntry, wf4(:,14), wf4(:,4), wf16(:,158), n3(:,255), t3x16(:,:,158))
  call vert_VV_S(ntry, wf4(:,9), wf4(:,4), wf16(:,159), n3(:,256), t3x16(:,:,159))
  call vert_UV_W(ntry, wf4(:,4), 160, wf4(:,9), 5, wf16(:,160), n3(:,257), t3x16(:,:,160))
  call counter_V_S(EWctPW,ntry, wf4(:,2), 10, wf4(:,15), n2(54))
  call vert_VS_T(ntry, wf4(:,3), 80, wf4(:,15), 10, wf16(:,161), n3(:,258), t3x16(:,:,161))
  call vert_SV_V(ntry, wf4(:,15), wf4(:,3), wf16(:,162), n3(:,259), t3x16(:,:,162))
  call vert_VV_S(ntry, wf4(:,10), wf4(:,3), wf16(:,163), n3(:,260), t3x16(:,:,163))
  call vert_UV_W(ntry, wf4(:,3), 80, wf4(:,10), 10, wf16(:,164), n3(:,261), t3x16(:,:,164))
  call vert_VS_T(ntry, wf4(:,4), 160, wf4(:,15), 10, wf16(:,165), n3(:,262), t3x16(:,:,165))
  call vert_SV_V(ntry, wf4(:,15), wf4(:,4), wf16(:,166), n3(:,263), t3x16(:,:,166))
  call vert_VV_S(ntry, wf4(:,10), wf4(:,4), wf16(:,167), n3(:,264), t3x16(:,:,167))
  call vert_UV_W(ntry, wf4(:,4), 160, wf4(:,10), 10, wf16(:,168), n3(:,265), t3x16(:,:,168))
  call counter_V_S(EWctPW,ntry, wf4(:,3), 80, wf4(:,16), n2(55))
  call vert_VS_T(ntry, wf4(:,1), 5, wf4(:,16), 80, wf16(:,169), n3(:,266), t3x16(:,:,169))
  call vert_SV_V(ntry, wf4(:,16), wf4(:,1), wf16(:,170), n3(:,267), t3x16(:,:,170))
  call vert_VV_S(ntry, wf4(:,1), wf4(:,11), wf16(:,171), n3(:,268), t3x16(:,:,171))
  call vert_UV_W(ntry, wf4(:,11), 80, wf4(:,1), 5, wf16(:,172), n3(:,269), t3x16(:,:,172))
  call vert_VS_T(ntry, wf4(:,2), 10, wf4(:,16), 80, wf16(:,173), n3(:,270), t3x16(:,:,173))
  call vert_SV_V(ntry, wf4(:,16), wf4(:,2), wf16(:,174), n3(:,271), t3x16(:,:,174))
  call vert_VV_S(ntry, wf4(:,2), wf4(:,11), wf16(:,175), n3(:,272), t3x16(:,:,175))
  call vert_UV_W(ntry, wf4(:,11), 80, wf4(:,2), 10, wf16(:,176), n3(:,273), t3x16(:,:,176))
  call counter_V_S(EWctPW,ntry, wf4(:,4), 160, wf4(:,17), n2(56))
  call vert_VS_T(ntry, wf4(:,1), 5, wf4(:,17), 160, wf16(:,177), n3(:,274), t3x16(:,:,177))
  call vert_SV_V(ntry, wf4(:,17), wf4(:,1), wf16(:,178), n3(:,275), t3x16(:,:,178))
  call vert_VV_S(ntry, wf4(:,1), wf4(:,12), wf16(:,179), n3(:,276), t3x16(:,:,179))
  call vert_UV_W(ntry, wf4(:,12), 160, wf4(:,1), 5, wf16(:,180), n3(:,277), t3x16(:,:,180))
  call vert_VS_T(ntry, wf4(:,2), 10, wf4(:,17), 160, wf16(:,181), n3(:,278), t3x16(:,:,181))
  call vert_SV_V(ntry, wf4(:,17), wf4(:,2), wf16(:,182), n3(:,279), t3x16(:,:,182))
  call vert_VV_S(ntry, wf4(:,2), wf4(:,12), wf16(:,183), n3(:,280), t3x16(:,:,183))
  call vert_UV_W(ntry, wf4(:,12), 160, wf4(:,2), 10, wf16(:,184), n3(:,281), t3x16(:,:,184))
  call counter_S_S(EWctHH,ntry, wf16(:,1), 85, wf16(:,185), n2(57))
  call counter_V_V(EWctAA,ntry, wf16(:,3), 85, wf16(:,186), n2(58))
  call counter_V_V(EWctAZ,ntry, wf16(:,3), 85, wf16(:,187), n2(59))
  call counter_V_V(EWctZZ,ntry, wf16(:,3), 85, wf16(:,188), n2(60))
  call counter_S_S(EWctHH,ntry, wf16(:,6), 90, wf16(:,189), n2(61))
  call counter_V_V(EWctAA,ntry, wf16(:,8), 90, wf16(:,190), n2(62))
  call counter_V_V(EWctAZ,ntry, wf16(:,8), 90, wf16(:,191), n2(63))
  call counter_V_V(EWctZZ,ntry, wf16(:,8), 90, wf16(:,192), n2(64))
  call vert_WQ_A(ntry, wf4(:,9), ex6(:), wf8(:,97), n3(:,282), t3x8(:,:,49))
  call vert_AW_Q(ntry, wf8(:,4), wf4(:,3), wf32(:,41), n3(:,283), t3x32(:,:,41))
  call prop_Q_A(ntry, wf8(:,97), 37, ZERO, 0_intkind1, wf8(:,98), n2(65))
  call vert_AV_Q(ntry, ex8(:), wf16(:,8), wf32(:,42), n3(:,284), t3x32(:,:,42))
  call vert_AZ_Q(gZd,ntry, ex8(:), wf16(:,8), wf32(:,43), n3(:,285), t3x32(:,:,43))
  call vert_AW_Q(ntry, ex8(:), wf4(:,9), wf8(:,99), n3(:,286), t3x8(:,:,50))
  call prop_A_Q(ntry, wf8(:,99), 133, ZERO, 0_intkind1, wf8(:,100), n2(66))
  call vert_VQ_A(ntry, wf16(:,8), ex6(:), wf32(:,44), n3(:,287), t3x32(:,:,44))
  call prop_Q_A(ntry, wf32(:,44), 122, ZERO, 0_intkind1, wf32(:,45), n2(67))
  call vert_ZQ_A(gZu,ntry, wf16(:,8), ex6(:), wf32(:,46), n3(:,288), t3x32(:,:,45))
  call prop_Q_A(ntry, wf32(:,46), 122, ZERO, 0_intkind1, wf32(:,47), n2(68))
  call vert_WQ_A(ntry, wf4(:,10), ex6(:), wf8(:,101), n3(:,289), t3x8(:,:,51))
  call vert_AW_Q(ntry, wf8(:,8), wf4(:,3), wf32(:,48), n3(:,290), t3x32(:,:,46))
  call prop_Q_A(ntry, wf8(:,101), 42, ZERO, 0_intkind1, wf8(:,102), n2(69))
  call vert_AV_Q(ntry, ex8(:), wf16(:,3), wf32(:,49), n3(:,291), t3x32(:,:,47))
  call vert_AZ_Q(gZd,ntry, ex8(:), wf16(:,3), wf32(:,50), n3(:,292), t3x32(:,:,48))
  call vert_AW_Q(ntry, ex8(:), wf4(:,10), wf8(:,103), n3(:,293), t3x8(:,:,52))
  call prop_A_Q(ntry, wf8(:,103), 138, ZERO, 0_intkind1, wf8(:,104), n2(70))
  call vert_VQ_A(ntry, wf16(:,3), ex6(:), wf32(:,51), n3(:,294), t3x32(:,:,49))
  call prop_Q_A(ntry, wf32(:,51), 117, ZERO, 0_intkind1, wf32(:,52), n2(71))
  call vert_ZQ_A(gZu,ntry, wf16(:,3), ex6(:), wf32(:,53), n3(:,295), t3x32(:,:,50))
  call prop_Q_A(ntry, wf32(:,53), 117, ZERO, 0_intkind1, wf32(:,54), n2(72))
  call vert_WQ_A(ntry, wf4(:,11), wf8(:,3), wf32(:,55), n3(:,296), t3x32(:,:,51))
  call vert_WQ_A(ntry, wf4(:,11), wf8(:,7), wf32(:,56), n3(:,297), t3x32(:,:,52))
  call counter_Q_A_LR(EWctdd,ntry, wf8(:,3), 37, wf8(:,105), n2(73))
  call prop_A_Q(ntry, wf32(:,42), 218, ZERO, 0_intkind1, wf32(:,57), n2(74))
  call prop_A_Q(ntry, wf32(:,43), 218, ZERO, 0_intkind1, wf32(:,58), n2(75))
  call counter_A_Q_LR(EWctuu,ntry, wf8(:,8), 133, wf8(:,106), n2(76))
  call counter_Q_A_LR(EWctdd,ntry, wf8(:,7), 42, wf8(:,107), n2(77))
  call prop_A_Q(ntry, wf32(:,49), 213, ZERO, 0_intkind1, wf32(:,59), n2(78))
  call prop_A_Q(ntry, wf32(:,50), 213, ZERO, 0_intkind1, wf32(:,60), n2(79))
  call counter_A_Q_LR(EWctuu,ntry, wf8(:,4), 138, wf8(:,108), n2(80))
  call prop_A_Q(ntry, wf32(:,41), 218, ZERO, 0_intkind1, wf32(:,61), n2(81))
  call prop_A_Q(ntry, wf32(:,48), 213, ZERO, 0_intkind1, wf32(:,62), n2(82))
  call prop_Q_A(ntry, wf32(:,1), 117, ZERO, 0_intkind1, wf32(:,63), n2(83))
  call prop_Q_A(ntry, wf32(:,2), 122, ZERO, 0_intkind1, wf32(:,64), n2(84))
  call vert_WQ_A(ntry, wf4(:,9), ex5(:), wf8(:,109), n3(:,298), t3x8(:,:,53))
  call vert_AW_Q(ntry, wf8(:,12), wf4(:,4), wf32(:,65), n3(:,299), t3x32(:,:,53))
  call prop_Q_A(ntry, wf8(:,109), 21, ZERO, 0_intkind1, wf8(:,110), n2(85))
  call vert_AV_Q(ntry, ex7(:), wf16(:,4), wf32(:,66), n3(:,300), t3x32(:,:,54))
  call vert_AZ_Q(gZd,ntry, ex7(:), wf16(:,4), wf32(:,67), n3(:,301), t3x32(:,:,55))
  call vert_AW_Q(ntry, ex7(:), wf4(:,9), wf8(:,111), n3(:,302), t3x8(:,:,54))
  call prop_A_Q(ntry, wf8(:,111), 69, ZERO, 0_intkind1, wf8(:,112), n2(86))
  call vert_VQ_A(ntry, wf16(:,4), ex5(:), wf32(:,68), n3(:,303), t3x32(:,:,56))
  call prop_Q_A(ntry, wf32(:,68), 186, ZERO, 0_intkind1, wf32(:,69), n2(87))
  call vert_ZQ_A(gZu,ntry, wf16(:,4), ex5(:), wf32(:,70), n3(:,304), t3x32(:,:,57))
  call prop_Q_A(ntry, wf32(:,70), 186, ZERO, 0_intkind1, wf32(:,71), n2(88))
  call vert_WQ_A(ntry, wf4(:,10), ex5(:), wf8(:,113), n3(:,305), t3x8(:,:,55))
  call vert_AW_Q(ntry, wf8(:,16), wf4(:,4), wf32(:,72), n3(:,306), t3x32(:,:,58))
  call prop_Q_A(ntry, wf8(:,113), 26, ZERO, 0_intkind1, wf8(:,114), n2(89))
  call vert_AV_Q(ntry, ex7(:), wf16(:,7), wf32(:,73), n3(:,307), t3x32(:,:,59))
  call vert_AZ_Q(gZd,ntry, ex7(:), wf16(:,7), wf32(:,74), n3(:,308), t3x32(:,:,60))
  call vert_AW_Q(ntry, ex7(:), wf4(:,10), wf8(:,115), n3(:,309), t3x8(:,:,56))
  call prop_A_Q(ntry, wf8(:,115), 74, ZERO, 0_intkind1, wf8(:,116), n2(90))
  call vert_VQ_A(ntry, wf16(:,7), ex5(:), wf32(:,75), n3(:,310), t3x32(:,:,61))
  call prop_Q_A(ntry, wf32(:,75), 181, ZERO, 0_intkind1, wf32(:,76), n2(91))
  call vert_ZQ_A(gZu,ntry, wf16(:,7), ex5(:), wf32(:,77), n3(:,311), t3x32(:,:,62))
  call prop_Q_A(ntry, wf32(:,77), 181, ZERO, 0_intkind1, wf32(:,78), n2(92))
  call counter_Q_A_LR(EWctdd,ntry, wf8(:,11), 21, wf8(:,117), n2(93))
  call prop_A_Q(ntry, wf32(:,66), 234, ZERO, 0_intkind1, wf32(:,79), n2(94))
  call prop_A_Q(ntry, wf32(:,67), 234, ZERO, 0_intkind1, wf32(:,80), n2(95))
  call counter_A_Q_LR(EWctuu,ntry, wf8(:,16), 69, wf8(:,118), n2(96))
  call counter_Q_A_LR(EWctdd,ntry, wf8(:,15), 26, wf8(:,119), n2(97))
  call prop_A_Q(ntry, wf32(:,73), 229, ZERO, 0_intkind1, wf32(:,81), n2(98))
  call prop_A_Q(ntry, wf32(:,74), 229, ZERO, 0_intkind1, wf32(:,82), n2(99))
  call counter_A_Q_LR(EWctuu,ntry, wf8(:,12), 74, wf8(:,120), n2(100))
  call prop_A_Q(ntry, wf32(:,65), 234, ZERO, 0_intkind1, wf32(:,83), n2(101))
  call prop_A_Q(ntry, wf32(:,72), 229, ZERO, 0_intkind1, wf32(:,84), n2(102))
  call counter_V_V(EWctAA,ntry, wf16(:,4), 170, wf16(:,193), n2(103))
  call counter_V_V(EWctAZ,ntry, wf16(:,4), 170, wf16(:,194), n2(104))
  call counter_V_V(EWctZZ,ntry, wf16(:,4), 170, wf16(:,195), n2(105))
  call counter_V_V(EWctAA,ntry, wf16(:,7), 165, wf16(:,196), n2(106))
  call counter_V_V(EWctAZ,ntry, wf16(:,7), 165, wf16(:,197), n2(107))
  call counter_V_V(EWctZZ,ntry, wf16(:,7), 165, wf16(:,198), n2(108))
  call vert_WQ_A(ntry, wf4(:,12), wf8(:,11), wf32(:,85), n3(:,312), t3x32(:,:,63))
  call vert_WQ_A(ntry, wf4(:,12), wf8(:,15), wf32(:,86), n3(:,313), t3x32(:,:,64))
  call prop_Q_A(ntry, wf32(:,3), 181, ZERO, 0_intkind1, wf32(:,87), n2(109))
  call prop_Q_A(ntry, wf32(:,4), 186, ZERO, 0_intkind1, wf32(:,88), n2(110))
  call vert_QA_V(ntry, wf8(:,110), ex7(:), wf16(:,199), n3(:,314), t3x16(:,:,185))
  call vert_QA_Z(gZd,ntry, wf8(:,110), ex7(:), wf16(:,200), n3(:,315), t3x16(:,:,186))
  call vert_QA_V(ntry, wf8(:,98), ex8(:), wf16(:,201), n3(:,316), t3x16(:,:,187))
  call vert_QA_Z(gZd,ntry, wf8(:,98), ex8(:), wf16(:,202), n3(:,317), t3x16(:,:,188))
  call vert_AV_Q(ntry, ex8(:), wf16(:,23), wf32(:,89), n3(:,318), t3x32(:,:,65))
  call vert_AZ_Q(gZd,ntry, ex8(:), wf16(:,24), wf32(:,90), n3(:,319), t3x32(:,:,66))
  call vert_QA_V(ntry, ex5(:), wf8(:,112), wf16(:,203), n3(:,320), t3x16(:,:,189))
  call vert_QA_Z(gZu,ntry, ex5(:), wf8(:,112), wf16(:,204), n3(:,321), t3x16(:,:,190))
  call vert_VQ_A(ntry, wf16(:,15), ex5(:), wf32(:,91), n3(:,322), t3x32(:,:,67))
  call vert_ZQ_A(gZu,ntry, wf16(:,16), ex5(:), wf32(:,92), n3(:,323), t3x32(:,:,68))
  call vert_VQ_A(ntry, wf16(:,21), ex6(:), wf32(:,93), n3(:,324), t3x32(:,:,69))
  call vert_ZQ_A(gZu,ntry, wf16(:,22), ex6(:), wf32(:,94), n3(:,325), t3x32(:,:,70))
  call vert_VQ_A(ntry, wf16(:,23), ex6(:), wf32(:,95), n3(:,326), t3x32(:,:,71))
  call vert_ZQ_A(gZu,ntry, wf16(:,24), ex6(:), wf32(:,96), n3(:,327), t3x32(:,:,72))
  call vert_QA_V(ntry, wf8(:,114), ex7(:), wf16(:,205), n3(:,328), t3x16(:,:,191))
  call vert_QA_Z(gZd,ntry, wf8(:,114), ex7(:), wf16(:,206), n3(:,329), t3x16(:,:,192))
  call vert_QA_V(ntry, wf8(:,102), ex8(:), wf16(:,207), n3(:,330), t3x16(:,:,193))
  call vert_QA_Z(gZd,ntry, wf8(:,102), ex8(:), wf16(:,208), n3(:,331), t3x16(:,:,194))
  call vert_AV_Q(ntry, ex8(:), wf16(:,19), wf32(:,97), n3(:,332), t3x32(:,:,73))
  call vert_AZ_Q(gZd,ntry, ex8(:), wf16(:,20), wf32(:,98), n3(:,333), t3x32(:,:,74))
  call vert_QA_V(ntry, ex5(:), wf8(:,116), wf16(:,209), n3(:,334), t3x16(:,:,195))
  call vert_QA_Z(gZu,ntry, ex5(:), wf8(:,116), wf16(:,210), n3(:,335), t3x16(:,:,196))
  call vert_VQ_A(ntry, wf16(:,11), ex5(:), wf32(:,99), n3(:,336), t3x32(:,:,75))
  call vert_ZQ_A(gZu,ntry, wf16(:,12), ex5(:), wf32(:,100), n3(:,337), t3x32(:,:,76))
  call vert_VQ_A(ntry, wf16(:,17), ex6(:), wf32(:,101), n3(:,338), t3x32(:,:,77))
  call vert_ZQ_A(gZu,ntry, wf16(:,18), ex6(:), wf32(:,102), n3(:,339), t3x32(:,:,78))
  call vert_VQ_A(ntry, wf16(:,19), ex6(:), wf32(:,103), n3(:,340), t3x32(:,:,79))
  call vert_ZQ_A(gZu,ntry, wf16(:,20), ex6(:), wf32(:,104), n3(:,341), t3x32(:,:,80))
  call counter_V_V(EWctAA,ntry, wf16(:,19), 85, wf16(:,211), n2(111))
  call counter_V_V(EWctAZ,ntry, wf16(:,19), 85, wf16(:,212), n2(112))
  call counter_V_V(EWctAZ,ntry, wf16(:,20), 85, wf16(:,213), n2(113))
  call counter_V_V(EWctZZ,ntry, wf16(:,20), 85, wf16(:,214), n2(114))
  call counter_V_V(EWctAA,ntry, wf16(:,23), 90, wf16(:,215), n2(115))
  call counter_V_V(EWctAZ,ntry, wf16(:,23), 90, wf16(:,216), n2(116))
  call counter_V_V(EWctAZ,ntry, wf16(:,24), 90, wf16(:,217), n2(117))
  call counter_V_V(EWctZZ,ntry, wf16(:,24), 90, wf16(:,218), n2(118))
  call prop_Q_A(ntry, wf8(:,117), 21, ZERO, 0_intkind1, wf8(:,121), n2(119))
  call vert_QA_V(ntry, wf8(:,121), ex7(:), wf16(:,219), n3(:,342), t3x16(:,:,197))
  call vert_QA_Z(gZd,ntry, wf8(:,121), ex7(:), wf16(:,220), n3(:,343), t3x16(:,:,198))
  call prop_Q_A(ntry, wf8(:,119), 26, ZERO, 0_intkind1, wf8(:,122), n2(120))
  call vert_QA_V(ntry, wf8(:,122), ex7(:), wf16(:,221), n3(:,344), t3x16(:,:,199))
  call vert_QA_Z(gZd,ntry, wf8(:,122), ex7(:), wf16(:,222), n3(:,345), t3x16(:,:,200))
  call prop_A_Q(ntry, wf8(:,120), 74, ZERO, 0_intkind1, wf8(:,123), n2(121))
  call vert_QA_V(ntry, ex5(:), wf8(:,123), wf16(:,223), n3(:,346), t3x16(:,:,201))
  call vert_QA_Z(gZu,ntry, ex5(:), wf8(:,123), wf16(:,224), n3(:,347), t3x16(:,:,202))
  call prop_A_Q(ntry, wf8(:,118), 69, ZERO, 0_intkind1, wf8(:,124), n2(122))
  call vert_QA_V(ntry, ex5(:), wf8(:,124), wf16(:,225), n3(:,348), t3x16(:,:,203))
  call vert_QA_Z(gZu,ntry, ex5(:), wf8(:,124), wf16(:,226), n3(:,349), t3x16(:,:,204))
  call counter_V_V(EWctAA,ntry, wf16(:,15), 170, wf16(:,227), n2(123))
  call counter_V_V(EWctAZ,ntry, wf16(:,15), 170, wf16(:,228), n2(124))
  call counter_V_V(EWctAZ,ntry, wf16(:,16), 170, wf16(:,229), n2(125))
  call counter_V_V(EWctZZ,ntry, wf16(:,16), 170, wf16(:,230), n2(126))
  call counter_V_V(EWctAA,ntry, wf16(:,11), 165, wf16(:,231), n2(127))
  call counter_V_V(EWctAZ,ntry, wf16(:,11), 165, wf16(:,232), n2(128))
  call counter_V_V(EWctAZ,ntry, wf16(:,12), 165, wf16(:,233), n2(129))
  call counter_V_V(EWctZZ,ntry, wf16(:,12), 165, wf16(:,234), n2(130))
  call prop_Q_A(ntry, wf8(:,107), 42, ZERO, 0_intkind1, wf8(:,125), n2(131))
  call vert_QA_V(ntry, wf8(:,125), ex8(:), wf16(:,235), n3(:,350), t3x16(:,:,205))
  call vert_QA_Z(gZd,ntry, wf8(:,125), ex8(:), wf16(:,236), n3(:,351), t3x16(:,:,206))
  call prop_A_Q(ntry, wf8(:,108), 138, ZERO, 0_intkind1, wf8(:,126), n2(132))
  call vert_QA_V(ntry, ex6(:), wf8(:,126), wf16(:,237), n3(:,352), t3x16(:,:,207))
  call vert_QA_Z(gZu,ntry, ex6(:), wf8(:,126), wf16(:,238), n3(:,353), t3x16(:,:,208))
  call prop_Q_A(ntry, wf8(:,105), 37, ZERO, 0_intkind1, wf8(:,127), n2(133))
  call vert_QA_V(ntry, wf8(:,127), ex8(:), wf16(:,239), n3(:,354), t3x16(:,:,209))
  call vert_QA_Z(gZd,ntry, wf8(:,127), ex8(:), wf16(:,240), n3(:,355), t3x16(:,:,210))
  call prop_A_Q(ntry, wf8(:,106), 133, ZERO, 0_intkind1, wf8(:,128), n2(134))
  call vert_QA_V(ntry, ex6(:), wf8(:,128), wf16(:,241), n3(:,356), t3x16(:,:,211))
  call vert_QA_Z(gZu,ntry, ex6(:), wf8(:,128), wf16(:,242), n3(:,357), t3x16(:,:,212))
  call counter_V_V(EWctAA,ntry, wf16(:,17), 85, wf16(:,243), n2(135))
  call counter_V_V(EWctAZ,ntry, wf16(:,17), 85, wf16(:,244), n2(136))
  call counter_V_V(EWctAZ,ntry, wf16(:,18), 85, wf16(:,245), n2(137))
  call counter_V_V(EWctZZ,ntry, wf16(:,18), 85, wf16(:,246), n2(138))
  call counter_V_V(EWctAA,ntry, wf16(:,21), 90, wf16(:,247), n2(139))
  call counter_V_V(EWctAZ,ntry, wf16(:,21), 90, wf16(:,248), n2(140))
  call counter_V_V(EWctAZ,ntry, wf16(:,22), 90, wf16(:,249), n2(141))
  call counter_V_V(EWctZZ,ntry, wf16(:,22), 90, wf16(:,250), n2(142))
  call vert_AW_Q(ntry, wf8(:,18), wf4(:,9), wf32(:,105), n3(:,358), t3x32(:,:,81))
  call vert_AW_Q(ntry, wf8(:,20), wf4(:,9), wf32(:,106), n3(:,359), t3x32(:,:,82))
  call vert_VQ_A(ntry, wf16(:,7), ex4(:), wf32(:,107), n3(:,360), t3x32(:,:,83))
  call counter_A_Q_LR(EWctee,ntry, wf8(:,18), 82, wf8(:,129), n2(143))
  call prop_Q_A(ntry, wf32(:,107), 173, ZERO, 0_intkind1, wf32(:,108), n2(144))
  call vert_ZQ_A(gZl,ntry, wf16(:,7), ex4(:), wf32(:,109), n3(:,361), t3x32(:,:,84))
  call prop_Q_A(ntry, wf32(:,109), 173, ZERO, 0_intkind1, wf32(:,110), n2(145))
  call vert_VQ_A(ntry, wf16(:,3), ex4(:), wf32(:,111), n3(:,362), t3x32(:,:,85))
  call counter_A_Q_LR(EWctee,ntry, wf8(:,20), 162, wf8(:,130), n2(146))
  call prop_Q_A(ntry, wf32(:,111), 93, ZERO, 0_intkind1, wf32(:,112), n2(147))
  call vert_ZQ_A(gZl,ntry, wf16(:,3), ex4(:), wf32(:,113), n3(:,363), t3x32(:,:,86))
  call prop_Q_A(ntry, wf32(:,113), 93, ZERO, 0_intkind1, wf32(:,114), n2(148))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf16(:,7), wf32(:,115), n3(:,364), t3x32(:,:,87))
  call counter_Q_A_LR(EWctnn,ntry, wf8(:,22), 88, wf8(:,131), n2(149))
  call prop_A_Q(ntry, wf32(:,115), 167, ZERO, 0_intkind1, wf32(:,116), n2(150))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf16(:,3), wf32(:,117), n3(:,365), t3x32(:,:,88))
  call counter_Q_A_LR(EWctnn,ntry, wf8(:,24), 168, wf8(:,132), n2(151))
  call prop_A_Q(ntry, wf32(:,117), 87, ZERO, 0_intkind1, wf32(:,118), n2(152))
  call vert_AW_Q(ntry, ex2(:), wf4(:,11), wf8(:,133), n3(:,366), t3x8(:,:,57))
  call prop_A_Q(ntry, wf8(:,133), 82, ZERO, 0_intkind1, wf8(:,134), n2(153))
  call vert_WQ_A(ntry, wf4(:,1), wf8(:,24), wf32(:,119), n3(:,367), t3x32(:,:,89))
  call vert_AW_Q(ntry, ex2(:), wf4(:,12), wf8(:,135), n3(:,368), t3x8(:,:,58))
  call prop_A_Q(ntry, wf8(:,135), 162, ZERO, 0_intkind1, wf8(:,136), n2(154))
  call vert_WQ_A(ntry, wf4(:,1), wf8(:,22), wf32(:,120), n3(:,369), t3x32(:,:,90))
  call prop_Q_A(ntry, wf32(:,119), 173, ZERO, 0_intkind1, wf32(:,121), n2(155))
  call prop_Q_A(ntry, wf32(:,120), 93, ZERO, 0_intkind1, wf32(:,122), n2(156))
  call vert_WQ_A(ntry, wf4(:,11), ex4(:), wf8(:,137), n3(:,370), t3x8(:,:,59))
  call prop_Q_A(ntry, wf8(:,137), 88, ZERO, 0_intkind1, wf8(:,138), n2(157))
  call vert_WQ_A(ntry, wf4(:,12), ex4(:), wf8(:,139), n3(:,371), t3x8(:,:,60))
  call prop_Q_A(ntry, wf8(:,139), 168, ZERO, 0_intkind1, wf8(:,140), n2(158))
  call prop_A_Q(ntry, wf32(:,5), 87, ZERO, 0_intkind1, wf32(:,123), n2(159))
  call prop_A_Q(ntry, wf32(:,6), 167, ZERO, 0_intkind1, wf32(:,124), n2(160))
  call vert_AV_Q(ntry, ex8(:), wf16(:,25), wf32(:,125), n3(:,372), t3x32(:,:,91))
  call vert_AZ_Q(gZd,ntry, ex8(:), wf16(:,26), wf32(:,126), n3(:,373), t3x32(:,:,92))
  call vert_AZ_Q(gZd,ntry, ex8(:), wf16(:,29), wf32(:,127), n3(:,374), t3x32(:,:,93))
  call vert_VQ_A(ntry, wf16(:,25), ex6(:), wf32(:,128), n3(:,375), t3x32(:,:,94))
  call vert_ZQ_A(gZu,ntry, wf16(:,26), ex6(:), wf32(:,129), n3(:,376), t3x32(:,:,95))
  call vert_ZQ_A(gZu,ntry, wf16(:,29), ex6(:), wf32(:,130), n3(:,377), t3x32(:,:,96))
  call prop_A_Q(ntry, wf8(:,129), 82, ZERO, 0_intkind1, wf8(:,141), n2(161))
  call vert_QA_V(ntry, ex4(:), wf8(:,141), wf16(:,251), n3(:,378), t3x16(:,:,213))
  call vert_QA_Z(gZl,ntry, ex4(:), wf8(:,141), wf16(:,252), n3(:,379), t3x16(:,:,214))
  call prop_Q_A(ntry, wf8(:,131), 88, ZERO, 0_intkind1, wf8(:,142), n2(162))
  call vert_QA_Z(gZn,ntry, wf8(:,142), ex2(:), wf16(:,253), n3(:,380), t3x16(:,:,215))
  call vert_QA_V(ntry, ex4(:), wf8(:,134), wf16(:,254), n3(:,381), t3x16(:,:,216))
  call vert_QA_Z(gZl,ntry, ex4(:), wf8(:,134), wf16(:,255), n3(:,382), t3x16(:,:,217))
  call counter_V_V(EWctAZ,ntry, wf16(:,29), 90, wf16(:,256), n2(163))
  call counter_V_V(EWctZZ,ntry, wf16(:,29), 90, wf16(:,257), n2(164))
  call vert_QA_Z(gZn,ntry, wf8(:,138), ex2(:), wf16(:,258), n3(:,383), t3x16(:,:,218))
  call counter_V_V(EWctAA,ntry, wf16(:,25), 90, wf16(:,259), n2(165))
  call counter_V_V(EWctAZ,ntry, wf16(:,25), 90, wf16(:,260), n2(166))
  call counter_V_V(EWctAZ,ntry, wf16(:,26), 90, wf16(:,261), n2(167))
  call counter_V_V(EWctZZ,ntry, wf16(:,26), 90, wf16(:,262), n2(168))
  call vert_AV_Q(ntry, ex7(:), wf16(:,27), wf32(:,131), n3(:,384), t3x32(:,:,97))
  call vert_AZ_Q(gZd,ntry, ex7(:), wf16(:,28), wf32(:,132), n3(:,385), t3x32(:,:,98))
  call vert_AZ_Q(gZd,ntry, ex7(:), wf16(:,30), wf32(:,133), n3(:,386), t3x32(:,:,99))
  call vert_ZQ_A(gZu,ntry, wf16(:,30), ex5(:), wf32(:,134), n3(:,387), t3x32(:,:,100))
  call vert_VQ_A(ntry, wf16(:,27), ex5(:), wf32(:,135), n3(:,388), t3x32(:,:,101))
  call vert_ZQ_A(gZu,ntry, wf16(:,28), ex5(:), wf32(:,136), n3(:,389), t3x32(:,:,102))
  call prop_A_Q(ntry, wf8(:,130), 162, ZERO, 0_intkind1, wf8(:,143), n2(169))
  call vert_QA_V(ntry, ex4(:), wf8(:,143), wf16(:,263), n3(:,390), t3x16(:,:,219))
  call vert_QA_Z(gZl,ntry, ex4(:), wf8(:,143), wf16(:,264), n3(:,391), t3x16(:,:,220))
  call prop_Q_A(ntry, wf8(:,132), 168, ZERO, 0_intkind1, wf8(:,144), n2(170))
  call vert_QA_Z(gZn,ntry, wf8(:,144), ex2(:), wf16(:,265), n3(:,392), t3x16(:,:,221))
  call counter_V_V(EWctAZ,ntry, wf16(:,30), 170, wf16(:,266), n2(171))
  call counter_V_V(EWctZZ,ntry, wf16(:,30), 170, wf16(:,267), n2(172))
  call vert_QA_V(ntry, ex4(:), wf8(:,136), wf16(:,268), n3(:,393), t3x16(:,:,222))
  call vert_QA_Z(gZl,ntry, ex4(:), wf8(:,136), wf16(:,269), n3(:,394), t3x16(:,:,223))
  call counter_V_V(EWctAA,ntry, wf16(:,27), 170, wf16(:,270), n2(173))
  call counter_V_V(EWctAZ,ntry, wf16(:,27), 170, wf16(:,271), n2(174))
  call counter_V_V(EWctAZ,ntry, wf16(:,28), 170, wf16(:,272), n2(175))
  call counter_V_V(EWctZZ,ntry, wf16(:,28), 170, wf16(:,273), n2(176))
  call vert_QA_Z(gZn,ntry, wf8(:,140), ex2(:), wf16(:,274), n3(:,395), t3x16(:,:,224))
  call vert_VQ_A(ntry, wf16(:,4), ex3(:), wf32(:,137), n3(:,396), t3x32(:,:,103))
  call counter_A_Q_LR(EWctee,ntry, wf8(:,26), 81, wf8(:,145), n2(177))
  call prop_Q_A(ntry, wf32(:,137), 174, ZERO, 0_intkind1, wf32(:,138), n2(178))
  call vert_ZQ_A(gZl,ntry, wf16(:,4), ex3(:), wf32(:,139), n3(:,397), t3x32(:,:,104))
  call prop_Q_A(ntry, wf32(:,139), 174, ZERO, 0_intkind1, wf32(:,140), n2(179))
  call vert_VQ_A(ntry, wf16(:,8), ex3(:), wf32(:,141), n3(:,398), t3x32(:,:,105))
  call counter_A_Q_LR(EWctee,ntry, wf8(:,28), 161, wf8(:,146), n2(180))
  call prop_Q_A(ntry, wf32(:,141), 94, ZERO, 0_intkind1, wf32(:,142), n2(181))
  call vert_ZQ_A(gZl,ntry, wf16(:,8), ex3(:), wf32(:,143), n3(:,399), t3x32(:,:,106))
  call prop_Q_A(ntry, wf32(:,143), 94, ZERO, 0_intkind1, wf32(:,144), n2(182))
  call vert_AZ_Q(gZn,ntry, ex1(:), wf16(:,4), wf32(:,145), n3(:,400), t3x32(:,:,107))
  call counter_Q_A_LR(EWctnn,ntry, wf8(:,30), 84, wf8(:,147), n2(183))
  call prop_A_Q(ntry, wf32(:,145), 171, ZERO, 0_intkind1, wf32(:,146), n2(184))
  call vert_AZ_Q(gZn,ntry, ex1(:), wf16(:,8), wf32(:,147), n3(:,401), t3x32(:,:,108))
  call counter_Q_A_LR(EWctnn,ntry, wf8(:,32), 164, wf8(:,148), n2(185))
  call prop_A_Q(ntry, wf32(:,147), 91, ZERO, 0_intkind1, wf32(:,148), n2(186))
  call vert_AW_Q(ntry, ex1(:), wf4(:,11), wf8(:,149), n3(:,402), t3x8(:,:,61))
  call prop_A_Q(ntry, wf8(:,149), 81, ZERO, 0_intkind1, wf8(:,150), n2(187))
  call vert_WQ_A(ntry, wf4(:,2), wf8(:,32), wf32(:,149), n3(:,403), t3x32(:,:,109))
  call vert_AW_Q(ntry, ex1(:), wf4(:,12), wf8(:,151), n3(:,404), t3x8(:,:,62))
  call prop_A_Q(ntry, wf8(:,151), 161, ZERO, 0_intkind1, wf8(:,152), n2(188))
  call vert_WQ_A(ntry, wf4(:,2), wf8(:,30), wf32(:,150), n3(:,405), t3x32(:,:,110))
  call prop_Q_A(ntry, wf32(:,149), 174, ZERO, 0_intkind1, wf32(:,151), n2(189))
  call prop_Q_A(ntry, wf32(:,150), 94, ZERO, 0_intkind1, wf32(:,152), n2(190))
  call vert_AW_Q(ntry, wf8(:,26), wf4(:,10), wf32(:,153), n3(:,406), t3x32(:,:,111))
  call vert_AW_Q(ntry, wf8(:,28), wf4(:,10), wf32(:,154), n3(:,407), t3x32(:,:,112))
  call vert_WQ_A(ntry, wf4(:,11), ex3(:), wf8(:,153), n3(:,408), t3x8(:,:,63))
  call prop_Q_A(ntry, wf8(:,153), 84, ZERO, 0_intkind1, wf8(:,154), n2(191))
  call vert_WQ_A(ntry, wf4(:,12), ex3(:), wf8(:,155), n3(:,409), t3x8(:,:,64))
  call prop_Q_A(ntry, wf8(:,155), 164, ZERO, 0_intkind1, wf8(:,156), n2(192))
  call prop_A_Q(ntry, wf32(:,7), 91, ZERO, 0_intkind1, wf32(:,155), n2(193))
  call prop_A_Q(ntry, wf32(:,8), 171, ZERO, 0_intkind1, wf32(:,156), n2(194))
  call prop_A_Q(ntry, wf8(:,145), 81, ZERO, 0_intkind1, wf8(:,157), n2(195))
  call vert_QA_V(ntry, ex3(:), wf8(:,157), wf16(:,275), n3(:,410), t3x16(:,:,225))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,157), wf16(:,276), n3(:,411), t3x16(:,:,226))
  call prop_Q_A(ntry, wf8(:,147), 84, ZERO, 0_intkind1, wf8(:,158), n2(196))
  call vert_QA_Z(gZn,ntry, wf8(:,158), ex1(:), wf16(:,277), n3(:,412), t3x16(:,:,227))
  call vert_QA_V(ntry, ex3(:), wf8(:,150), wf16(:,278), n3(:,413), t3x16(:,:,228))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,150), wf16(:,279), n3(:,414), t3x16(:,:,229))
  call counter_V_V(EWctAZ,ntry, wf16(:,35), 85, wf16(:,280), n2(197))
  call counter_V_V(EWctZZ,ntry, wf16(:,35), 85, wf16(:,281), n2(198))
  call vert_AV_Q(ntry, ex8(:), wf16(:,31), wf32(:,157), n3(:,415), t3x32(:,:,113))
  call vert_AZ_Q(gZd,ntry, ex8(:), wf16(:,32), wf32(:,158), n3(:,416), t3x32(:,:,114))
  call vert_AZ_Q(gZd,ntry, ex8(:), wf16(:,35), wf32(:,159), n3(:,417), t3x32(:,:,115))
  call vert_VQ_A(ntry, wf16(:,31), ex6(:), wf32(:,160), n3(:,418), t3x32(:,:,116))
  call vert_ZQ_A(gZu,ntry, wf16(:,32), ex6(:), wf32(:,161), n3(:,419), t3x32(:,:,117))
  call vert_ZQ_A(gZu,ntry, wf16(:,35), ex6(:), wf32(:,162), n3(:,420), t3x32(:,:,118))
  call vert_QA_Z(gZn,ntry, wf8(:,154), ex1(:), wf16(:,282), n3(:,421), t3x16(:,:,230))
  call counter_V_V(EWctAA,ntry, wf16(:,31), 85, wf16(:,283), n2(199))
  call counter_V_V(EWctAZ,ntry, wf16(:,31), 85, wf16(:,284), n2(200))
  call counter_V_V(EWctAZ,ntry, wf16(:,32), 85, wf16(:,285), n2(201))
  call counter_V_V(EWctZZ,ntry, wf16(:,32), 85, wf16(:,286), n2(202))
  call prop_Q_A(ntry, wf8(:,148), 164, ZERO, 0_intkind1, wf8(:,159), n2(203))
  call vert_QA_Z(gZn,ntry, wf8(:,159), ex1(:), wf16(:,287), n3(:,422), t3x16(:,:,231))
  call prop_A_Q(ntry, wf8(:,146), 161, ZERO, 0_intkind1, wf8(:,160), n2(204))
  call vert_QA_V(ntry, ex3(:), wf8(:,160), wf16(:,288), n3(:,423), t3x16(:,:,232))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,160), wf16(:,289), n3(:,424), t3x16(:,:,233))
  call counter_V_V(EWctAZ,ntry, wf16(:,36), 165, wf16(:,290), n2(205))
  call counter_V_V(EWctZZ,ntry, wf16(:,36), 165, wf16(:,291), n2(206))
  call vert_QA_V(ntry, ex3(:), wf8(:,152), wf16(:,292), n3(:,425), t3x16(:,:,234))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,152), wf16(:,293), n3(:,426), t3x16(:,:,235))
  call vert_AV_Q(ntry, ex7(:), wf16(:,33), wf32(:,163), n3(:,427), t3x32(:,:,119))
  call vert_AZ_Q(gZd,ntry, ex7(:), wf16(:,34), wf32(:,164), n3(:,428), t3x32(:,:,120))
  call vert_AZ_Q(gZd,ntry, ex7(:), wf16(:,36), wf32(:,165), n3(:,429), t3x32(:,:,121))
  call vert_ZQ_A(gZu,ntry, wf16(:,36), ex5(:), wf32(:,166), n3(:,430), t3x32(:,:,122))
  call vert_VQ_A(ntry, wf16(:,33), ex5(:), wf32(:,167), n3(:,431), t3x32(:,:,123))
  call vert_ZQ_A(gZu,ntry, wf16(:,34), ex5(:), wf32(:,168), n3(:,432), t3x32(:,:,124))
  call counter_V_V(EWctAA,ntry, wf16(:,33), 165, wf16(:,294), n2(207))
  call counter_V_V(EWctAZ,ntry, wf16(:,33), 165, wf16(:,295), n2(208))
  call counter_V_V(EWctAZ,ntry, wf16(:,34), 165, wf16(:,296), n2(209))
  call counter_V_V(EWctZZ,ntry, wf16(:,34), 165, wf16(:,297), n2(210))
  call vert_QA_Z(gZn,ntry, wf8(:,156), ex1(:), wf16(:,298), n3(:,433), t3x16(:,:,236))
  call vert_ZQ_A(gZl,ntry, wf16(:,36), ex4(:), wf32(:,169), n3(:,434), t3x32(:,:,125))
  call vert_ZQ_A(gZl,ntry, wf16(:,35), ex4(:), wf32(:,170), n3(:,435), t3x32(:,:,126))
  call vert_AZ_Q(gZn,ntry, ex1(:), wf16(:,30), wf32(:,171), n3(:,436), t3x32(:,:,127))
  call vert_AZ_Q(gZn,ntry, ex1(:), wf16(:,29), wf32(:,172), n3(:,437), t3x32(:,:,128))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf16(:,36), wf32(:,173), n3(:,438), t3x32(:,:,129))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf16(:,34), wf32(:,174), n3(:,439), t3x32(:,:,130))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf16(:,35), wf32(:,175), n3(:,440), t3x32(:,:,131))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf16(:,32), wf32(:,176), n3(:,441), t3x32(:,:,132))
  call vert_TV_S(ntry, wf16(:,1), 85, wf4(:,2), 10, wf64(:,9), n3(:,442), t3x64(:,:,1))
  call vert_SV_V(ntry, wf16(:,1), wf4(:,2), wf64(:,10), n3(:,443), t3x64(:,:,2))
  call vert_VV_S(ntry, wf4(:,2), wf16(:,3), wf64(:,11), n3(:,444), t3x64(:,:,3))
  call vert_UV_W(ntry, wf4(:,2), 10, wf16(:,3), 85, wf64(:,12), n3(:,445), t3x64(:,:,4))
  call vert_TV_S(ntry, wf16(:,6), 90, wf4(:,1), 5, wf64(:,13), n3(:,446), t3x64(:,:,5))
  call vert_SV_V(ntry, wf16(:,6), wf4(:,1), wf64(:,14), n3(:,447), t3x64(:,:,6))
  call vert_VV_S(ntry, wf4(:,1), wf16(:,8), wf64(:,15), n3(:,448), t3x64(:,:,7))
  call vert_UV_W(ntry, wf4(:,1), 5, wf16(:,8), 90, wf64(:,16), n3(:,449), t3x64(:,:,8))
  call vert_TV_S(ntry, wf16(:,5), 165, wf4(:,2), 10, wf64(:,17), n3(:,450), t3x64(:,:,9))
  call vert_SV_V(ntry, wf16(:,5), wf4(:,2), wf64(:,18), n3(:,451), t3x64(:,:,10))
  call vert_VV_S(ntry, wf4(:,2), wf16(:,7), wf64(:,19), n3(:,452), t3x64(:,:,11))
  call vert_UV_W(ntry, wf4(:,2), 10, wf16(:,7), 165, wf64(:,20), n3(:,453), t3x64(:,:,12))
  call vert_TV_S(ntry, wf16(:,2), 170, wf4(:,1), 5, wf64(:,21), n3(:,454), t3x64(:,:,13))
  call vert_SV_V(ntry, wf16(:,2), wf4(:,1), wf64(:,22), n3(:,455), t3x64(:,:,14))
  call vert_VV_S(ntry, wf4(:,1), wf16(:,4), wf64(:,23), n3(:,456), t3x64(:,:,15))
  call vert_UV_W(ntry, wf4(:,1), 5, wf16(:,4), 170, wf64(:,24), n3(:,457), t3x64(:,:,16))
  call vert_QA_W(ntry, wf8(:,11), wf8(:,12), wf64(:,25), n3(:,458), t3x64(:,:,17))
  call prop_Q_A(ntry, wf32(:,101), 117, ZERO, 0_intkind1, wf32(:,177), n2(211))
  call prop_Q_A(ntry, wf32(:,102), 117, ZERO, 0_intkind1, wf32(:,178), n2(212))
  call vert_AV_Q(ntry, ex8(:), wf16(:,17), wf32(:,179), n3(:,459), t3x32(:,:,133))
  call prop_A_Q(ntry, wf32(:,179), 213, ZERO, 0_intkind1, wf32(:,180), n2(213))
  call vert_AZ_Q(gZd,ntry, ex8(:), wf16(:,18), wf32(:,181), n3(:,460), t3x32(:,:,134))
  call prop_A_Q(ntry, wf32(:,181), 213, ZERO, 0_intkind1, wf32(:,182), n2(214))
  call vert_VV_S(ntry, wf4(:,2), wf16(:,17), wf64(:,26), n3(:,461), t3x64(:,:,18))
  call vert_VV_S(ntry, wf4(:,2), wf16(:,18), wf64(:,27), n3(:,462), t3x64(:,:,19))
  call vert_UV_W(ntry, wf4(:,2), 10, wf16(:,17), 85, wf64(:,28), n3(:,463), t3x64(:,:,20))
  call vert_UV_W(ntry, wf4(:,2), 10, wf16(:,18), 85, wf64(:,29), n3(:,464), t3x64(:,:,21))
  call vert_QA_W(ntry, wf8(:,3), wf8(:,4), wf64(:,30), n3(:,465), t3x64(:,:,22))
  call vert_VQ_A(ntry, wf16(:,9), ex5(:), wf32(:,183), n3(:,466), t3x32(:,:,135))
  call prop_Q_A(ntry, wf32(:,183), 181, ZERO, 0_intkind1, wf32(:,184), n2(215))
  call vert_ZQ_A(gZu,ntry, wf16(:,10), ex5(:), wf32(:,185), n3(:,467), t3x32(:,:,136))
  call prop_Q_A(ntry, wf32(:,185), 181, ZERO, 0_intkind1, wf32(:,186), n2(216))
  call vert_AV_Q(ntry, ex7(:), wf16(:,9), wf32(:,187), n3(:,468), t3x32(:,:,137))
  call prop_A_Q(ntry, wf32(:,187), 229, ZERO, 0_intkind1, wf32(:,188), n2(217))
  call vert_AZ_Q(gZd,ntry, ex7(:), wf16(:,10), wf32(:,189), n3(:,469), t3x32(:,:,138))
  call prop_A_Q(ntry, wf32(:,189), 229, ZERO, 0_intkind1, wf32(:,190), n2(218))
  call vert_VV_S(ntry, wf4(:,2), wf16(:,9), wf64(:,31), n3(:,470), t3x64(:,:,23))
  call vert_VV_S(ntry, wf4(:,2), wf16(:,10), wf64(:,32), n3(:,471), t3x64(:,:,24))
  call vert_UV_W(ntry, wf4(:,2), 10, wf16(:,9), 165, wf64(:,33), n3(:,472), t3x64(:,:,25))
  call vert_UV_W(ntry, wf4(:,2), 10, wf16(:,10), 165, wf64(:,34), n3(:,473), t3x64(:,:,26))
  call vert_QA_W(ntry, wf8(:,15), wf8(:,16), wf64(:,35), n3(:,474), t3x64(:,:,27))
  call prop_Q_A(ntry, wf32(:,103), 117, ZERO, 0_intkind1, wf32(:,191), n2(219))
  call prop_Q_A(ntry, wf32(:,104), 117, ZERO, 0_intkind1, wf32(:,192), n2(220))
  call prop_A_Q(ntry, wf32(:,97), 213, ZERO, 0_intkind1, wf32(:,193), n2(221))
  call prop_A_Q(ntry, wf32(:,98), 213, ZERO, 0_intkind1, wf32(:,194), n2(222))
  call vert_VV_S(ntry, wf4(:,2), wf16(:,19), wf64(:,36), n3(:,475), t3x64(:,:,28))
  call vert_VV_S(ntry, wf4(:,2), wf16(:,20), wf64(:,37), n3(:,476), t3x64(:,:,29))
  call vert_UV_W(ntry, wf4(:,2), 10, wf16(:,19), 85, wf64(:,38), n3(:,477), t3x64(:,:,30))
  call vert_UV_W(ntry, wf4(:,2), 10, wf16(:,20), 85, wf64(:,39), n3(:,478), t3x64(:,:,31))
  call vert_QA_W(ntry, wf8(:,7), wf8(:,8), wf64(:,40), n3(:,479), t3x64(:,:,32))
  call prop_Q_A(ntry, wf32(:,99), 181, ZERO, 0_intkind1, wf32(:,195), n2(223))
  call prop_Q_A(ntry, wf32(:,100), 181, ZERO, 0_intkind1, wf32(:,196), n2(224))
  call vert_AV_Q(ntry, ex7(:), wf16(:,11), wf32(:,197), n3(:,480), t3x32(:,:,139))
  call prop_A_Q(ntry, wf32(:,197), 229, ZERO, 0_intkind1, wf32(:,198), n2(225))
  call vert_AZ_Q(gZd,ntry, ex7(:), wf16(:,12), wf32(:,199), n3(:,481), t3x32(:,:,140))
  call prop_A_Q(ntry, wf32(:,199), 229, ZERO, 0_intkind1, wf32(:,200), n2(226))
  call vert_VV_S(ntry, wf4(:,2), wf16(:,11), wf64(:,41), n3(:,482), t3x64(:,:,33))
  call vert_VV_S(ntry, wf4(:,2), wf16(:,12), wf64(:,42), n3(:,483), t3x64(:,:,34))
  call vert_UV_W(ntry, wf4(:,2), 10, wf16(:,11), 165, wf64(:,43), n3(:,484), t3x64(:,:,35))
  call vert_UV_W(ntry, wf4(:,2), 10, wf16(:,12), 165, wf64(:,44), n3(:,485), t3x64(:,:,36))
  call prop_Q_A(ntry, wf32(:,93), 122, ZERO, 0_intkind1, wf32(:,201), n2(227))
  call prop_Q_A(ntry, wf32(:,94), 122, ZERO, 0_intkind1, wf32(:,202), n2(228))
  call vert_AV_Q(ntry, ex8(:), wf16(:,21), wf32(:,203), n3(:,486), t3x32(:,:,141))
  call prop_A_Q(ntry, wf32(:,203), 218, ZERO, 0_intkind1, wf32(:,204), n2(229))
  call vert_AZ_Q(gZd,ntry, ex8(:), wf16(:,22), wf32(:,205), n3(:,487), t3x32(:,:,142))
  call prop_A_Q(ntry, wf32(:,205), 218, ZERO, 0_intkind1, wf32(:,206), n2(230))
  call vert_VV_S(ntry, wf4(:,1), wf16(:,21), wf64(:,45), n3(:,488), t3x64(:,:,37))
  call vert_VV_S(ntry, wf4(:,1), wf16(:,22), wf64(:,46), n3(:,489), t3x64(:,:,38))
  call vert_UV_W(ntry, wf4(:,1), 5, wf16(:,21), 90, wf64(:,47), n3(:,490), t3x64(:,:,39))
  call vert_UV_W(ntry, wf4(:,1), 5, wf16(:,22), 90, wf64(:,48), n3(:,491), t3x64(:,:,40))
  call vert_VQ_A(ntry, wf16(:,13), ex5(:), wf32(:,207), n3(:,492), t3x32(:,:,143))
  call prop_Q_A(ntry, wf32(:,207), 186, ZERO, 0_intkind1, wf32(:,208), n2(231))
  call vert_ZQ_A(gZu,ntry, wf16(:,14), ex5(:), wf32(:,209), n3(:,493), t3x32(:,:,144))
  call prop_Q_A(ntry, wf32(:,209), 186, ZERO, 0_intkind1, wf32(:,210), n2(232))
  call vert_AV_Q(ntry, ex7(:), wf16(:,13), wf32(:,211), n3(:,494), t3x32(:,:,145))
  call prop_A_Q(ntry, wf32(:,211), 234, ZERO, 0_intkind1, wf32(:,212), n2(233))
  call vert_AZ_Q(gZd,ntry, ex7(:), wf16(:,14), wf32(:,213), n3(:,495), t3x32(:,:,146))
  call prop_A_Q(ntry, wf32(:,213), 234, ZERO, 0_intkind1, wf32(:,214), n2(234))
  call vert_VV_S(ntry, wf4(:,1), wf16(:,13), wf64(:,49), n3(:,496), t3x64(:,:,41))
  call vert_VV_S(ntry, wf4(:,1), wf16(:,14), wf64(:,50), n3(:,497), t3x64(:,:,42))
  call vert_UV_W(ntry, wf4(:,1), 5, wf16(:,13), 170, wf64(:,51), n3(:,498), t3x64(:,:,43))
  call vert_UV_W(ntry, wf4(:,1), 5, wf16(:,14), 170, wf64(:,52), n3(:,499), t3x64(:,:,44))
  call prop_Q_A(ntry, wf32(:,95), 122, ZERO, 0_intkind1, wf32(:,215), n2(235))
  call prop_Q_A(ntry, wf32(:,96), 122, ZERO, 0_intkind1, wf32(:,216), n2(236))
  call prop_A_Q(ntry, wf32(:,89), 218, ZERO, 0_intkind1, wf32(:,217), n2(237))
  call prop_A_Q(ntry, wf32(:,90), 218, ZERO, 0_intkind1, wf32(:,218), n2(238))
  call vert_VV_S(ntry, wf4(:,1), wf16(:,23), wf64(:,53), n3(:,500), t3x64(:,:,45))
  call vert_VV_S(ntry, wf4(:,1), wf16(:,24), wf64(:,54), n3(:,501), t3x64(:,:,46))
  call vert_UV_W(ntry, wf4(:,1), 5, wf16(:,23), 90, wf64(:,55), n3(:,502), t3x64(:,:,47))
  call vert_UV_W(ntry, wf4(:,1), 5, wf16(:,24), 90, wf64(:,56), n3(:,503), t3x64(:,:,48))
  call prop_Q_A(ntry, wf32(:,91), 186, ZERO, 0_intkind1, wf32(:,219), n2(239))
  call prop_Q_A(ntry, wf32(:,92), 186, ZERO, 0_intkind1, wf32(:,220), n2(240))
  call vert_AV_Q(ntry, ex7(:), wf16(:,15), wf32(:,221), n3(:,504), t3x32(:,:,147))
  call prop_A_Q(ntry, wf32(:,221), 234, ZERO, 0_intkind1, wf32(:,222), n2(241))
  call vert_AZ_Q(gZd,ntry, ex7(:), wf16(:,16), wf32(:,223), n3(:,505), t3x32(:,:,148))
  call prop_A_Q(ntry, wf32(:,223), 234, ZERO, 0_intkind1, wf32(:,224), n2(242))
  call vert_VV_S(ntry, wf4(:,1), wf16(:,15), wf64(:,57), n3(:,506), t3x64(:,:,49))
  call vert_VV_S(ntry, wf4(:,1), wf16(:,16), wf64(:,58), n3(:,507), t3x64(:,:,50))
  call vert_UV_W(ntry, wf4(:,1), 5, wf16(:,15), 170, wf64(:,59), n3(:,508), t3x64(:,:,51))
  call vert_UV_W(ntry, wf4(:,1), 5, wf16(:,16), 170, wf64(:,60), n3(:,509), t3x64(:,:,52))
  call vert_TV_S(ntry, wf16(:,1), 85, wf4(:,4), 160, wf64(:,61), n3(:,510), t3x64(:,:,53))
  call vert_SV_V(ntry, wf16(:,1), wf4(:,4), wf64(:,62), n3(:,511), t3x64(:,:,54))
  call vert_VV_S(ntry, wf16(:,3), wf4(:,4), wf64(:,63), n3(:,512), t3x64(:,:,55))
  call vert_UV_W(ntry, wf16(:,3), 85, wf4(:,4), 160, wf64(:,64), n3(:,513), t3x64(:,:,56))
  call vert_TV_S(ntry, wf16(:,5), 165, wf4(:,3), 80, wf64(:,65), n3(:,514), t3x64(:,:,57))
  call vert_SV_V(ntry, wf16(:,5), wf4(:,3), wf64(:,66), n3(:,515), t3x64(:,:,58))
  call vert_VV_S(ntry, wf4(:,3), wf16(:,7), wf64(:,67), n3(:,516), t3x64(:,:,59))
  call vert_UV_W(ntry, wf16(:,7), 165, wf4(:,3), 80, wf64(:,68), n3(:,517), t3x64(:,:,60))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf16(:,10), wf32(:,225), n3(:,518), t3x32(:,:,149))
  call prop_A_Q(ntry, wf32(:,225), 167, ZERO, 0_intkind1, wf32(:,226), n2(243))
  call vert_VQ_A(ntry, wf16(:,9), ex4(:), wf32(:,227), n3(:,519), t3x32(:,:,150))
  call prop_Q_A(ntry, wf32(:,227), 173, ZERO, 0_intkind1, wf32(:,228), n2(244))
  call vert_ZQ_A(gZl,ntry, wf16(:,10), ex4(:), wf32(:,229), n3(:,520), t3x32(:,:,151))
  call prop_Q_A(ntry, wf32(:,229), 173, ZERO, 0_intkind1, wf32(:,230), n2(245))
  call vert_VV_S(ntry, wf4(:,3), wf16(:,9), wf64(:,69), n3(:,521), t3x64(:,:,61))
  call vert_VV_S(ntry, wf4(:,3), wf16(:,10), wf64(:,70), n3(:,522), t3x64(:,:,62))
  call vert_UV_W(ntry, wf16(:,9), 165, wf4(:,3), 80, wf64(:,71), n3(:,523), t3x64(:,:,63))
  call vert_UV_W(ntry, wf16(:,10), 165, wf4(:,3), 80, wf64(:,72), n3(:,524), t3x64(:,:,64))
  call vert_QA_W(ntry, wf32(:,63), ex8(:), wf64(:,73), n3(:,525), t3x64(:,:,65))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf16(:,12), wf32(:,231), n3(:,526), t3x32(:,:,152))
  call prop_A_Q(ntry, wf32(:,231), 167, ZERO, 0_intkind1, wf32(:,232), n2(246))
  call vert_VQ_A(ntry, wf16(:,11), ex4(:), wf32(:,233), n3(:,527), t3x32(:,:,153))
  call prop_Q_A(ntry, wf32(:,233), 173, ZERO, 0_intkind1, wf32(:,234), n2(247))
  call vert_ZQ_A(gZl,ntry, wf16(:,12), ex4(:), wf32(:,235), n3(:,528), t3x32(:,:,154))
  call prop_Q_A(ntry, wf32(:,235), 173, ZERO, 0_intkind1, wf32(:,236), n2(248))
  call vert_VV_S(ntry, wf4(:,3), wf16(:,11), wf64(:,74), n3(:,529), t3x64(:,:,66))
  call vert_VV_S(ntry, wf4(:,3), wf16(:,12), wf64(:,75), n3(:,530), t3x64(:,:,67))
  call vert_UV_W(ntry, wf16(:,11), 165, wf4(:,3), 80, wf64(:,76), n3(:,531), t3x64(:,:,68))
  call vert_UV_W(ntry, wf16(:,12), 165, wf4(:,3), 80, wf64(:,77), n3(:,532), t3x64(:,:,69))
  call vert_QA_W(ntry, ex6(:), wf32(:,62), wf64(:,78), n3(:,533), t3x64(:,:,70))
  call prop_Q_A(ntry, wf32(:,128), 122, ZERO, 0_intkind1, wf32(:,237), n2(249))
  call prop_Q_A(ntry, wf32(:,129), 122, ZERO, 0_intkind1, wf32(:,238), n2(250))
  call prop_A_Q(ntry, wf32(:,125), 218, ZERO, 0_intkind1, wf32(:,239), n2(251))
  call prop_A_Q(ntry, wf32(:,126), 218, ZERO, 0_intkind1, wf32(:,240), n2(252))
  call vert_VV_S(ntry, wf4(:,1), wf16(:,25), wf64(:,79), n3(:,534), t3x64(:,:,71))
  call vert_VV_S(ntry, wf4(:,1), wf16(:,26), wf64(:,80), n3(:,535), t3x64(:,:,72))
  call vert_UV_W(ntry, wf4(:,1), 5, wf16(:,25), 90, wf64(:,81), n3(:,536), t3x64(:,:,73))
  call vert_UV_W(ntry, wf4(:,1), 5, wf16(:,26), 90, wf64(:,82), n3(:,537), t3x64(:,:,74))
  call prop_Q_A(ntry, wf32(:,130), 122, ZERO, 0_intkind1, wf32(:,241), n2(253))
  call prop_A_Q(ntry, wf32(:,127), 218, ZERO, 0_intkind1, wf32(:,242), n2(254))
  call vert_VV_S(ntry, wf4(:,1), wf16(:,29), wf64(:,83), n3(:,538), t3x64(:,:,75))
  call vert_UV_W(ntry, wf4(:,1), 5, wf16(:,29), 90, wf64(:,84), n3(:,539), t3x64(:,:,76))
  call vert_QA_W(ntry, ex4(:), wf32(:,118), wf64(:,85), n3(:,540), t3x64(:,:,77))
  call vert_QA_W(ntry, wf32(:,112), ex2(:), wf64(:,86), n3(:,541), t3x64(:,:,78))
  call vert_QA_W(ntry, wf32(:,114), ex2(:), wf64(:,87), n3(:,542), t3x64(:,:,79))
  call vert_QA_W(ntry, ex4(:), wf32(:,123), wf64(:,88), n3(:,543), t3x64(:,:,80))
  call vert_QA_W(ntry, wf32(:,122), ex2(:), wf64(:,89), n3(:,544), t3x64(:,:,81))
  call vert_QA_W(ntry, wf32(:,52), ex8(:), wf64(:,90), n3(:,545), t3x64(:,:,82))
  call vert_QA_W(ntry, wf32(:,54), ex8(:), wf64(:,91), n3(:,546), t3x64(:,:,83))
  call vert_QA_W(ntry, ex6(:), wf32(:,59), wf64(:,92), n3(:,547), t3x64(:,:,84))
  call vert_QA_W(ntry, ex6(:), wf32(:,60), wf64(:,93), n3(:,548), t3x64(:,:,85))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf16(:,18), wf32(:,243), n3(:,549), t3x32(:,:,155))
  call prop_A_Q(ntry, wf32(:,243), 87, ZERO, 0_intkind1, wf32(:,244), n2(255))
  call vert_VQ_A(ntry, wf16(:,17), ex4(:), wf32(:,245), n3(:,550), t3x32(:,:,156))
  call prop_Q_A(ntry, wf32(:,245), 93, ZERO, 0_intkind1, wf32(:,246), n2(256))
  call vert_ZQ_A(gZl,ntry, wf16(:,18), ex4(:), wf32(:,247), n3(:,551), t3x32(:,:,157))
  call prop_Q_A(ntry, wf32(:,247), 93, ZERO, 0_intkind1, wf32(:,248), n2(257))
  call vert_VV_S(ntry, wf16(:,17), wf4(:,4), wf64(:,94), n3(:,552), t3x64(:,:,86))
  call vert_VV_S(ntry, wf16(:,18), wf4(:,4), wf64(:,95), n3(:,553), t3x64(:,:,87))
  call vert_UV_W(ntry, wf16(:,17), 85, wf4(:,4), 160, wf64(:,96), n3(:,554), t3x64(:,:,88))
  call vert_UV_W(ntry, wf16(:,18), 85, wf4(:,4), 160, wf64(:,97), n3(:,555), t3x64(:,:,89))
  call vert_QA_W(ntry, wf32(:,87), ex7(:), wf64(:,98), n3(:,556), t3x64(:,:,90))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf16(:,20), wf32(:,249), n3(:,557), t3x32(:,:,158))
  call prop_A_Q(ntry, wf32(:,249), 87, ZERO, 0_intkind1, wf32(:,250), n2(258))
  call vert_VQ_A(ntry, wf16(:,19), ex4(:), wf32(:,251), n3(:,558), t3x32(:,:,159))
  call prop_Q_A(ntry, wf32(:,251), 93, ZERO, 0_intkind1, wf32(:,252), n2(259))
  call vert_ZQ_A(gZl,ntry, wf16(:,20), ex4(:), wf32(:,253), n3(:,559), t3x32(:,:,160))
  call prop_Q_A(ntry, wf32(:,253), 93, ZERO, 0_intkind1, wf32(:,254), n2(260))
  call vert_VV_S(ntry, wf16(:,19), wf4(:,4), wf64(:,99), n3(:,560), t3x64(:,:,91))
  call vert_VV_S(ntry, wf16(:,20), wf4(:,4), wf64(:,100), n3(:,561), t3x64(:,:,92))
  call vert_UV_W(ntry, wf16(:,19), 85, wf4(:,4), 160, wf64(:,101), n3(:,562), t3x64(:,:,93))
  call vert_UV_W(ntry, wf16(:,20), 85, wf4(:,4), 160, wf64(:,102), n3(:,563), t3x64(:,:,94))
  call vert_QA_W(ntry, ex5(:), wf32(:,84), wf64(:,103), n3(:,564), t3x64(:,:,95))
  call prop_Q_A(ntry, wf32(:,134), 186, ZERO, 0_intkind1, wf32(:,255), n2(261))
  call prop_Q_A(ntry, wf32(:,135), 186, ZERO, 0_intkind1, wf32(:,256), n2(262))
  call prop_Q_A(ntry, wf32(:,136), 186, ZERO, 0_intkind1, wf32(:,257), n2(263))
  call prop_A_Q(ntry, wf32(:,131), 234, ZERO, 0_intkind1, wf32(:,258), n2(264))
  call prop_A_Q(ntry, wf32(:,132), 234, ZERO, 0_intkind1, wf32(:,259), n2(265))
  call vert_VV_S(ntry, wf4(:,1), wf16(:,27), wf64(:,104), n3(:,565), t3x64(:,:,96))
  call vert_VV_S(ntry, wf4(:,1), wf16(:,28), wf64(:,105), n3(:,566), t3x64(:,:,97))
  call vert_UV_W(ntry, wf4(:,1), 5, wf16(:,27), 170, wf64(:,106), n3(:,567), t3x64(:,:,98))
  call vert_UV_W(ntry, wf4(:,1), 5, wf16(:,28), 170, wf64(:,107), n3(:,568), t3x64(:,:,99))
  call prop_A_Q(ntry, wf32(:,133), 234, ZERO, 0_intkind1, wf32(:,260), n2(266))
  call vert_VV_S(ntry, wf4(:,1), wf16(:,30), wf64(:,108), n3(:,569), t3x64(:,:,100))
  call vert_UV_W(ntry, wf4(:,1), 5, wf16(:,30), 170, wf64(:,109), n3(:,570), t3x64(:,:,101))
  call vert_QA_W(ntry, ex4(:), wf32(:,116), wf64(:,110), n3(:,571), t3x64(:,:,102))
  call vert_QA_W(ntry, wf32(:,108), ex2(:), wf64(:,111), n3(:,572), t3x64(:,:,103))
  call vert_QA_W(ntry, wf32(:,110), ex2(:), wf64(:,112), n3(:,573), t3x64(:,:,104))
  call vert_QA_W(ntry, ex4(:), wf32(:,124), wf64(:,113), n3(:,574), t3x64(:,:,105))
  call vert_QA_W(ntry, wf32(:,121), ex2(:), wf64(:,114), n3(:,575), t3x64(:,:,106))
  call vert_QA_W(ntry, wf32(:,76), ex7(:), wf64(:,115), n3(:,576), t3x64(:,:,107))
  call vert_QA_W(ntry, wf32(:,78), ex7(:), wf64(:,116), n3(:,577), t3x64(:,:,108))
  call vert_QA_W(ntry, ex5(:), wf32(:,81), wf64(:,117), n3(:,578), t3x64(:,:,109))
  call vert_QA_W(ntry, ex5(:), wf32(:,82), wf64(:,118), n3(:,579), t3x64(:,:,110))
  call vert_QA_W(ntry, ex4(:), wf32(:,244), wf64(:,119), n3(:,580), t3x64(:,:,111))
  call vert_QA_W(ntry, wf32(:,246), ex2(:), wf64(:,120), n3(:,581), t3x64(:,:,112))
  call vert_QA_W(ntry, wf32(:,248), ex2(:), wf64(:,121), n3(:,582), t3x64(:,:,113))
  call vert_QA_W(ntry, wf32(:,177), ex8(:), wf64(:,122), n3(:,583), t3x64(:,:,114))
  call vert_QA_W(ntry, wf32(:,178), ex8(:), wf64(:,123), n3(:,584), t3x64(:,:,115))
  call vert_QA_W(ntry, ex6(:), wf32(:,180), wf64(:,124), n3(:,585), t3x64(:,:,116))
  call vert_QA_W(ntry, ex6(:), wf32(:,182), wf64(:,125), n3(:,586), t3x64(:,:,117))
  call vert_QA_W(ntry, ex4(:), wf32(:,226), wf64(:,126), n3(:,587), t3x64(:,:,118))
  call vert_QA_W(ntry, wf32(:,228), ex2(:), wf64(:,127), n3(:,588), t3x64(:,:,119))
  call vert_QA_W(ntry, wf32(:,230), ex2(:), wf64(:,128), n3(:,589), t3x64(:,:,120))
  call vert_QA_W(ntry, wf32(:,184), ex7(:), wf64(:,129), n3(:,590), t3x64(:,:,121))
  call vert_QA_W(ntry, wf32(:,186), ex7(:), wf64(:,130), n3(:,591), t3x64(:,:,122))
  call vert_QA_W(ntry, ex5(:), wf32(:,188), wf64(:,131), n3(:,592), t3x64(:,:,123))
  call vert_QA_W(ntry, ex5(:), wf32(:,190), wf64(:,132), n3(:,593), t3x64(:,:,124))
  call vert_QA_W(ntry, ex4(:), wf32(:,250), wf64(:,133), n3(:,594), t3x64(:,:,125))
  call vert_QA_W(ntry, wf32(:,252), ex2(:), wf64(:,134), n3(:,595), t3x64(:,:,126))
  call vert_QA_W(ntry, wf32(:,254), ex2(:), wf64(:,135), n3(:,596), t3x64(:,:,127))
  call vert_QA_W(ntry, wf32(:,191), ex8(:), wf64(:,136), n3(:,597), t3x64(:,:,128))
  call vert_QA_W(ntry, wf32(:,192), ex8(:), wf64(:,137), n3(:,598), t3x64(:,:,129))
  call vert_QA_W(ntry, ex6(:), wf32(:,193), wf64(:,138), n3(:,599), t3x64(:,:,130))
  call vert_QA_W(ntry, ex6(:), wf32(:,194), wf64(:,139), n3(:,600), t3x64(:,:,131))
  call vert_QA_W(ntry, ex4(:), wf32(:,232), wf64(:,140), n3(:,601), t3x64(:,:,132))
  call vert_QA_W(ntry, wf32(:,234), ex2(:), wf64(:,141), n3(:,602), t3x64(:,:,133))
  call vert_QA_W(ntry, wf32(:,236), ex2(:), wf64(:,142), n3(:,603), t3x64(:,:,134))
  call vert_QA_W(ntry, wf32(:,195), ex7(:), wf64(:,143), n3(:,604), t3x64(:,:,135))
  call vert_QA_W(ntry, wf32(:,196), ex7(:), wf64(:,144), n3(:,605), t3x64(:,:,136))
  call vert_QA_W(ntry, ex5(:), wf32(:,198), wf64(:,145), n3(:,606), t3x64(:,:,137))
  call vert_QA_W(ntry, ex5(:), wf32(:,200), wf64(:,146), n3(:,607), t3x64(:,:,138))
  call vert_TV_S(ntry, wf16(:,6), 90, wf4(:,4), 160, wf64(:,147), n3(:,608), t3x64(:,:,139))
  call vert_SV_V(ntry, wf16(:,6), wf4(:,4), wf64(:,148), n3(:,609), t3x64(:,:,140))
  call vert_VV_S(ntry, wf16(:,8), wf4(:,4), wf64(:,149), n3(:,610), t3x64(:,:,141))
  call vert_UV_W(ntry, wf16(:,8), 90, wf4(:,4), 160, wf64(:,150), n3(:,611), t3x64(:,:,142))
  call vert_TV_S(ntry, wf16(:,2), 170, wf4(:,3), 80, wf64(:,151), n3(:,612), t3x64(:,:,143))
  call vert_SV_V(ntry, wf16(:,2), wf4(:,3), wf64(:,152), n3(:,613), t3x64(:,:,144))
  call vert_VV_S(ntry, wf4(:,3), wf16(:,4), wf64(:,153), n3(:,614), t3x64(:,:,145))
  call vert_UV_W(ntry, wf16(:,4), 170, wf4(:,3), 80, wf64(:,154), n3(:,615), t3x64(:,:,146))
  call prop_Q_A(ntry, wf32(:,160), 117, ZERO, 0_intkind1, wf32(:,261), n2(267))
  call prop_Q_A(ntry, wf32(:,161), 117, ZERO, 0_intkind1, wf32(:,262), n2(268))
  call prop_A_Q(ntry, wf32(:,157), 213, ZERO, 0_intkind1, wf32(:,263), n2(269))
  call prop_A_Q(ntry, wf32(:,158), 213, ZERO, 0_intkind1, wf32(:,264), n2(270))
  call vert_VV_S(ntry, wf4(:,2), wf16(:,31), wf64(:,155), n3(:,616), t3x64(:,:,147))
  call vert_VV_S(ntry, wf4(:,2), wf16(:,32), wf64(:,156), n3(:,617), t3x64(:,:,148))
  call vert_UV_W(ntry, wf4(:,2), 10, wf16(:,31), 85, wf64(:,157), n3(:,618), t3x64(:,:,149))
  call vert_UV_W(ntry, wf4(:,2), 10, wf16(:,32), 85, wf64(:,158), n3(:,619), t3x64(:,:,150))
  call prop_Q_A(ntry, wf32(:,162), 117, ZERO, 0_intkind1, wf32(:,265), n2(271))
  call prop_A_Q(ntry, wf32(:,159), 213, ZERO, 0_intkind1, wf32(:,266), n2(272))
  call vert_VV_S(ntry, wf4(:,2), wf16(:,35), wf64(:,159), n3(:,620), t3x64(:,:,151))
  call vert_UV_W(ntry, wf4(:,2), 10, wf16(:,35), 85, wf64(:,160), n3(:,621), t3x64(:,:,152))
  call vert_QA_W(ntry, ex3(:), wf32(:,148), wf64(:,161), n3(:,622), t3x64(:,:,153))
  call vert_QA_W(ntry, wf32(:,142), ex1(:), wf64(:,162), n3(:,623), t3x64(:,:,154))
  call vert_QA_W(ntry, wf32(:,144), ex1(:), wf64(:,163), n3(:,624), t3x64(:,:,155))
  call vert_QA_W(ntry, ex3(:), wf32(:,155), wf64(:,164), n3(:,625), t3x64(:,:,156))
  call vert_AZ_Q(gZn,ntry, ex1(:), wf16(:,16), wf32(:,267), n3(:,626), t3x32(:,:,161))
  call prop_A_Q(ntry, wf32(:,267), 171, ZERO, 0_intkind1, wf32(:,268), n2(273))
  call vert_AZ_Q(gZn,ntry, ex1(:), wf16(:,14), wf32(:,269), n3(:,627), t3x32(:,:,162))
  call prop_A_Q(ntry, wf32(:,269), 171, ZERO, 0_intkind1, wf32(:,270), n2(274))
  call vert_QA_W(ntry, wf32(:,152), ex1(:), wf64(:,165), n3(:,628), t3x64(:,:,157))
  call vert_VQ_A(ntry, wf16(:,13), ex3(:), wf32(:,271), n3(:,629), t3x32(:,:,163))
  call prop_Q_A(ntry, wf32(:,271), 174, ZERO, 0_intkind1, wf32(:,272), n2(275))
  call vert_ZQ_A(gZl,ntry, wf16(:,14), ex3(:), wf32(:,273), n3(:,630), t3x32(:,:,164))
  call prop_Q_A(ntry, wf32(:,273), 174, ZERO, 0_intkind1, wf32(:,274), n2(276))
  call vert_VV_S(ntry, wf4(:,3), wf16(:,13), wf64(:,166), n3(:,631), t3x64(:,:,158))
  call vert_VV_S(ntry, wf4(:,3), wf16(:,14), wf64(:,167), n3(:,632), t3x64(:,:,159))
  call vert_UV_W(ntry, wf16(:,13), 170, wf4(:,3), 80, wf64(:,168), n3(:,633), t3x64(:,:,160))
  call vert_UV_W(ntry, wf16(:,14), 170, wf4(:,3), 80, wf64(:,169), n3(:,634), t3x64(:,:,161))
  call vert_QA_W(ntry, wf32(:,64), ex8(:), wf64(:,170), n3(:,635), t3x64(:,:,162))
  call vert_VQ_A(ntry, wf16(:,15), ex3(:), wf32(:,275), n3(:,636), t3x32(:,:,165))
  call prop_Q_A(ntry, wf32(:,275), 174, ZERO, 0_intkind1, wf32(:,276), n2(277))
  call vert_ZQ_A(gZl,ntry, wf16(:,16), ex3(:), wf32(:,277), n3(:,637), t3x32(:,:,166))
  call prop_Q_A(ntry, wf32(:,277), 174, ZERO, 0_intkind1, wf32(:,278), n2(278))
  call vert_VV_S(ntry, wf4(:,3), wf16(:,15), wf64(:,171), n3(:,638), t3x64(:,:,163))
  call vert_VV_S(ntry, wf4(:,3), wf16(:,16), wf64(:,172), n3(:,639), t3x64(:,:,164))
  call vert_UV_W(ntry, wf16(:,15), 170, wf4(:,3), 80, wf64(:,173), n3(:,640), t3x64(:,:,165))
  call vert_UV_W(ntry, wf16(:,16), 170, wf4(:,3), 80, wf64(:,174), n3(:,641), t3x64(:,:,166))
  call vert_QA_W(ntry, ex6(:), wf32(:,61), wf64(:,175), n3(:,642), t3x64(:,:,167))
  call vert_QA_W(ntry, wf32(:,45), ex8(:), wf64(:,176), n3(:,643), t3x64(:,:,168))
  call vert_QA_W(ntry, wf32(:,47), ex8(:), wf64(:,177), n3(:,644), t3x64(:,:,169))
  call vert_QA_W(ntry, ex6(:), wf32(:,57), wf64(:,178), n3(:,645), t3x64(:,:,170))
  call vert_QA_W(ntry, ex6(:), wf32(:,58), wf64(:,179), n3(:,646), t3x64(:,:,171))
  call prop_Q_A(ntry, wf32(:,166), 181, ZERO, 0_intkind1, wf32(:,279), n2(279))
  call prop_Q_A(ntry, wf32(:,167), 181, ZERO, 0_intkind1, wf32(:,280), n2(280))
  call prop_Q_A(ntry, wf32(:,168), 181, ZERO, 0_intkind1, wf32(:,281), n2(281))
  call prop_A_Q(ntry, wf32(:,163), 229, ZERO, 0_intkind1, wf32(:,282), n2(282))
  call prop_A_Q(ntry, wf32(:,164), 229, ZERO, 0_intkind1, wf32(:,283), n2(283))
  call vert_VV_S(ntry, wf4(:,2), wf16(:,33), wf64(:,180), n3(:,647), t3x64(:,:,172))
  call vert_VV_S(ntry, wf4(:,2), wf16(:,34), wf64(:,181), n3(:,648), t3x64(:,:,173))
  call vert_UV_W(ntry, wf4(:,2), 10, wf16(:,33), 165, wf64(:,182), n3(:,649), t3x64(:,:,174))
  call vert_UV_W(ntry, wf4(:,2), 10, wf16(:,34), 165, wf64(:,183), n3(:,650), t3x64(:,:,175))
  call prop_A_Q(ntry, wf32(:,165), 229, ZERO, 0_intkind1, wf32(:,284), n2(284))
  call vert_VV_S(ntry, wf4(:,2), wf16(:,36), wf64(:,184), n3(:,651), t3x64(:,:,176))
  call vert_UV_W(ntry, wf4(:,2), 10, wf16(:,36), 165, wf64(:,185), n3(:,652), t3x64(:,:,177))
  call vert_QA_W(ntry, ex3(:), wf32(:,146), wf64(:,186), n3(:,653), t3x64(:,:,178))
  call vert_QA_W(ntry, wf32(:,138), ex1(:), wf64(:,187), n3(:,654), t3x64(:,:,179))
  call vert_QA_W(ntry, wf32(:,140), ex1(:), wf64(:,188), n3(:,655), t3x64(:,:,180))
  call vert_AZ_Q(gZn,ntry, ex1(:), wf16(:,24), wf32(:,285), n3(:,656), t3x32(:,:,167))
  call prop_A_Q(ntry, wf32(:,285), 91, ZERO, 0_intkind1, wf32(:,286), n2(285))
  call vert_QA_W(ntry, ex3(:), wf32(:,156), wf64(:,189), n3(:,657), t3x64(:,:,181))
  call vert_AZ_Q(gZn,ntry, ex1(:), wf16(:,22), wf32(:,287), n3(:,658), t3x32(:,:,168))
  call prop_A_Q(ntry, wf32(:,287), 91, ZERO, 0_intkind1, wf32(:,288), n2(286))
  call vert_QA_W(ntry, wf32(:,151), ex1(:), wf64(:,190), n3(:,659), t3x64(:,:,182))
  call vert_VQ_A(ntry, wf16(:,21), ex3(:), wf32(:,289), n3(:,660), t3x32(:,:,169))
  call prop_Q_A(ntry, wf32(:,289), 94, ZERO, 0_intkind1, wf32(:,290), n2(287))
  call vert_ZQ_A(gZl,ntry, wf16(:,22), ex3(:), wf32(:,291), n3(:,661), t3x32(:,:,170))
  call prop_Q_A(ntry, wf32(:,291), 94, ZERO, 0_intkind1, wf32(:,292), n2(288))
  call vert_VV_S(ntry, wf16(:,21), wf4(:,4), wf64(:,191), n3(:,662), t3x64(:,:,183))
  call vert_VV_S(ntry, wf16(:,22), wf4(:,4), wf64(:,192), n3(:,663), t3x64(:,:,184))
  call vert_UV_W(ntry, wf16(:,21), 90, wf4(:,4), 160, wf64(:,193), n3(:,664), t3x64(:,:,185))
  call vert_UV_W(ntry, wf16(:,22), 90, wf4(:,4), 160, wf64(:,194), n3(:,665), t3x64(:,:,186))
  call vert_QA_W(ntry, wf32(:,88), ex7(:), wf64(:,195), n3(:,666), t3x64(:,:,187))
  call vert_VQ_A(ntry, wf16(:,23), ex3(:), wf32(:,293), n3(:,667), t3x32(:,:,171))
  call prop_Q_A(ntry, wf32(:,293), 94, ZERO, 0_intkind1, wf32(:,294), n2(289))
  call vert_ZQ_A(gZl,ntry, wf16(:,24), ex3(:), wf32(:,295), n3(:,668), t3x32(:,:,172))
  call prop_Q_A(ntry, wf32(:,295), 94, ZERO, 0_intkind1, wf32(:,296), n2(290))
  call vert_VV_S(ntry, wf16(:,23), wf4(:,4), wf64(:,196), n3(:,669), t3x64(:,:,188))
  call vert_VV_S(ntry, wf16(:,24), wf4(:,4), wf64(:,197), n3(:,670), t3x64(:,:,189))
  call vert_UV_W(ntry, wf16(:,23), 90, wf4(:,4), 160, wf64(:,198), n3(:,671), t3x64(:,:,190))
  call vert_UV_W(ntry, wf16(:,24), 90, wf4(:,4), 160, wf64(:,199), n3(:,672), t3x64(:,:,191))
  call vert_QA_W(ntry, ex5(:), wf32(:,83), wf64(:,200), n3(:,673), t3x64(:,:,192))
  call vert_QA_W(ntry, wf32(:,69), ex7(:), wf64(:,201), n3(:,674), t3x64(:,:,193))
  call vert_QA_W(ntry, wf32(:,71), ex7(:), wf64(:,202), n3(:,675), t3x64(:,:,194))
  call vert_QA_W(ntry, ex5(:), wf32(:,79), wf64(:,203), n3(:,676), t3x64(:,:,195))
  call vert_QA_W(ntry, ex5(:), wf32(:,80), wf64(:,204), n3(:,677), t3x64(:,:,196))
  call vert_QA_W(ntry, ex3(:), wf32(:,286), wf64(:,205), n3(:,678), t3x64(:,:,197))
  call vert_QA_W(ntry, ex3(:), wf32(:,268), wf64(:,206), n3(:,679), t3x64(:,:,198))
  call vert_QA_W(ntry, ex3(:), wf32(:,288), wf64(:,207), n3(:,680), t3x64(:,:,199))
  call vert_QA_W(ntry, ex3(:), wf32(:,270), wf64(:,208), n3(:,681), t3x64(:,:,200))
  call vert_QA_W(ntry, wf32(:,290), ex1(:), wf64(:,209), n3(:,682), t3x64(:,:,201))
  call vert_QA_W(ntry, wf32(:,292), ex1(:), wf64(:,210), n3(:,683), t3x64(:,:,202))
  call vert_QA_W(ntry, wf32(:,272), ex1(:), wf64(:,211), n3(:,684), t3x64(:,:,203))
  call vert_QA_W(ntry, wf32(:,274), ex1(:), wf64(:,212), n3(:,685), t3x64(:,:,204))
  call vert_QA_W(ntry, wf32(:,294), ex1(:), wf64(:,213), n3(:,686), t3x64(:,:,205))
  call vert_QA_W(ntry, wf32(:,296), ex1(:), wf64(:,214), n3(:,687), t3x64(:,:,206))
  call vert_QA_W(ntry, wf32(:,276), ex1(:), wf64(:,215), n3(:,688), t3x64(:,:,207))
  call vert_QA_W(ntry, wf32(:,278), ex1(:), wf64(:,216), n3(:,689), t3x64(:,:,208))
  call vert_QA_W(ntry, wf32(:,201), ex8(:), wf64(:,217), n3(:,690), t3x64(:,:,209))
  call vert_QA_W(ntry, wf32(:,202), ex8(:), wf64(:,218), n3(:,691), t3x64(:,:,210))
  call vert_QA_W(ntry, ex6(:), wf32(:,204), wf64(:,219), n3(:,692), t3x64(:,:,211))
  call vert_QA_W(ntry, ex6(:), wf32(:,206), wf64(:,220), n3(:,693), t3x64(:,:,212))
  call vert_QA_W(ntry, wf32(:,208), ex7(:), wf64(:,221), n3(:,694), t3x64(:,:,213))
  call vert_QA_W(ntry, wf32(:,210), ex7(:), wf64(:,222), n3(:,695), t3x64(:,:,214))
  call vert_QA_W(ntry, ex5(:), wf32(:,212), wf64(:,223), n3(:,696), t3x64(:,:,215))
  call vert_QA_W(ntry, ex5(:), wf32(:,214), wf64(:,224), n3(:,697), t3x64(:,:,216))
  call vert_QA_W(ntry, wf32(:,215), ex8(:), wf64(:,225), n3(:,698), t3x64(:,:,217))
  call vert_QA_W(ntry, wf32(:,216), ex8(:), wf64(:,226), n3(:,699), t3x64(:,:,218))
  call vert_QA_W(ntry, ex6(:), wf32(:,217), wf64(:,227), n3(:,700), t3x64(:,:,219))
  call vert_QA_W(ntry, ex6(:), wf32(:,218), wf64(:,228), n3(:,701), t3x64(:,:,220))
  call vert_QA_W(ntry, wf32(:,219), ex7(:), wf64(:,229), n3(:,702), t3x64(:,:,221))
  call vert_QA_W(ntry, wf32(:,220), ex7(:), wf64(:,230), n3(:,703), t3x64(:,:,222))
  call vert_QA_W(ntry, ex5(:), wf32(:,222), wf64(:,231), n3(:,704), t3x64(:,:,223))
  call vert_QA_W(ntry, ex5(:), wf32(:,224), wf64(:,232), n3(:,705), t3x64(:,:,224))
  call prop_A_Q(ntry, wf32(:,175), 87, ZERO, 0_intkind1, wf32(:,297), n2(291))
  call prop_A_Q(ntry, wf32(:,173), 167, ZERO, 0_intkind1, wf32(:,298), n2(292))
  call prop_A_Q(ntry, wf32(:,172), 91, ZERO, 0_intkind1, wf32(:,299), n2(293))
  call prop_A_Q(ntry, wf32(:,171), 171, ZERO, 0_intkind1, wf32(:,300), n2(294))
  call prop_Q_A(ntry, wf32(:,170), 93, ZERO, 0_intkind1, wf32(:,301), n2(295))
  call prop_Q_A(ntry, wf32(:,169), 173, ZERO, 0_intkind1, wf32(:,302), n2(296))
  call prop_A_Q(ntry, wf32(:,176), 87, ZERO, 0_intkind1, wf32(:,303), n2(297))
  call vert_VQ_A(ntry, wf16(:,31), ex4(:), wf32(:,304), n3(:,706), t3x32(:,:,173))
  call prop_Q_A(ntry, wf32(:,304), 93, ZERO, 0_intkind1, wf32(:,305), n2(298))
  call vert_ZQ_A(gZl,ntry, wf16(:,32), ex4(:), wf32(:,306), n3(:,707), t3x32(:,:,174))
  call prop_Q_A(ntry, wf32(:,306), 93, ZERO, 0_intkind1, wf32(:,307), n2(299))
  call vert_VV_S(ntry, wf16(:,31), wf4(:,4), wf64(:,233), n3(:,708), t3x64(:,:,225))
  call vert_VV_S(ntry, wf16(:,32), wf4(:,4), wf64(:,234), n3(:,709), t3x64(:,:,226))
  call vert_UV_W(ntry, wf16(:,31), 85, wf4(:,4), 160, wf64(:,235), n3(:,710), t3x64(:,:,227))
  call vert_UV_W(ntry, wf16(:,32), 85, wf4(:,4), 160, wf64(:,236), n3(:,711), t3x64(:,:,228))
  call prop_A_Q(ntry, wf32(:,174), 167, ZERO, 0_intkind1, wf32(:,308), n2(300))
  call vert_VQ_A(ntry, wf16(:,33), ex4(:), wf32(:,309), n3(:,712), t3x32(:,:,175))
  call prop_Q_A(ntry, wf32(:,309), 173, ZERO, 0_intkind1, wf32(:,310), n2(301))
  call vert_ZQ_A(gZl,ntry, wf16(:,34), ex4(:), wf32(:,311), n3(:,713), t3x32(:,:,176))
  call prop_Q_A(ntry, wf32(:,311), 173, ZERO, 0_intkind1, wf32(:,312), n2(302))
  call vert_VV_S(ntry, wf4(:,3), wf16(:,33), wf64(:,237), n3(:,714), t3x64(:,:,229))
  call vert_VV_S(ntry, wf4(:,3), wf16(:,34), wf64(:,238), n3(:,715), t3x64(:,:,230))
  call vert_UV_W(ntry, wf16(:,33), 165, wf4(:,3), 80, wf64(:,239), n3(:,716), t3x64(:,:,231))
  call vert_UV_W(ntry, wf16(:,34), 165, wf4(:,3), 80, wf64(:,240), n3(:,717), t3x64(:,:,232))
  call vert_VV_S(ntry, wf16(:,35), wf4(:,4), wf64(:,241), n3(:,718), t3x64(:,:,233))
  call vert_UV_W(ntry, wf16(:,35), 85, wf4(:,4), 160, wf64(:,242), n3(:,719), t3x64(:,:,234))
  call vert_VV_S(ntry, wf4(:,3), wf16(:,36), wf64(:,243), n3(:,720), t3x64(:,:,235))
  call vert_UV_W(ntry, wf16(:,36), 165, wf4(:,3), 80, wf64(:,244), n3(:,721), t3x64(:,:,236))
  call vert_AZ_Q(gZn,ntry, ex1(:), wf16(:,26), wf32(:,313), n3(:,722), t3x32(:,:,177))
  call prop_A_Q(ntry, wf32(:,313), 91, ZERO, 0_intkind1, wf32(:,314), n2(303))
  call vert_AZ_Q(gZn,ntry, ex1(:), wf16(:,28), wf32(:,315), n3(:,723), t3x32(:,:,178))
  call prop_A_Q(ntry, wf32(:,315), 171, ZERO, 0_intkind1, wf32(:,316), n2(304))
  call vert_QA_W(ntry, wf8(:,32), wf8(:,26), wf64(:,245), n3(:,724), t3x64(:,:,237))
  call vert_QA_W(ntry, wf8(:,30), wf8(:,28), wf64(:,246), n3(:,725), t3x64(:,:,238))
  call vert_ZQ_A(gZl,ntry, wf16(:,29), ex3(:), wf32(:,317), n3(:,726), t3x32(:,:,179))
  call prop_Q_A(ntry, wf32(:,317), 94, ZERO, 0_intkind1, wf32(:,318), n2(305))
  call vert_ZQ_A(gZl,ntry, wf16(:,30), ex3(:), wf32(:,319), n3(:,727), t3x32(:,:,180))
  call prop_Q_A(ntry, wf32(:,319), 174, ZERO, 0_intkind1, wf32(:,320), n2(306))
  call vert_VQ_A(ntry, wf16(:,25), ex3(:), wf32(:,321), n3(:,728), t3x32(:,:,181))
  call prop_Q_A(ntry, wf32(:,321), 94, ZERO, 0_intkind1, wf32(:,322), n2(307))
  call vert_ZQ_A(gZl,ntry, wf16(:,26), ex3(:), wf32(:,323), n3(:,729), t3x32(:,:,182))
  call prop_Q_A(ntry, wf32(:,323), 94, ZERO, 0_intkind1, wf32(:,324), n2(308))
  call vert_VV_S(ntry, wf16(:,25), wf4(:,4), wf64(:,247), n3(:,730), t3x64(:,:,239))
  call vert_VV_S(ntry, wf16(:,26), wf4(:,4), wf64(:,248), n3(:,731), t3x64(:,:,240))
  call vert_UV_W(ntry, wf16(:,25), 90, wf4(:,4), 160, wf64(:,249), n3(:,732), t3x64(:,:,241))
  call vert_UV_W(ntry, wf16(:,26), 90, wf4(:,4), 160, wf64(:,250), n3(:,733), t3x64(:,:,242))
  call vert_VQ_A(ntry, wf16(:,27), ex3(:), wf32(:,325), n3(:,734), t3x32(:,:,183))
  call prop_Q_A(ntry, wf32(:,325), 174, ZERO, 0_intkind1, wf32(:,326), n2(309))
  call vert_ZQ_A(gZl,ntry, wf16(:,28), ex3(:), wf32(:,327), n3(:,735), t3x32(:,:,184))
  call prop_Q_A(ntry, wf32(:,327), 174, ZERO, 0_intkind1, wf32(:,328), n2(310))
  call vert_VV_S(ntry, wf4(:,3), wf16(:,27), wf64(:,251), n3(:,736), t3x64(:,:,243))
  call vert_VV_S(ntry, wf4(:,3), wf16(:,28), wf64(:,252), n3(:,737), t3x64(:,:,244))
  call vert_UV_W(ntry, wf16(:,27), 170, wf4(:,3), 80, wf64(:,253), n3(:,738), t3x64(:,:,245))
  call vert_UV_W(ntry, wf16(:,28), 170, wf4(:,3), 80, wf64(:,254), n3(:,739), t3x64(:,:,246))
  call vert_VV_S(ntry, wf16(:,29), wf4(:,4), wf64(:,255), n3(:,740), t3x64(:,:,247))
  call vert_UV_W(ntry, wf16(:,29), 90, wf4(:,4), 160, wf64(:,256), n3(:,741), t3x64(:,:,248))
  call vert_VV_S(ntry, wf4(:,3), wf16(:,30), wf64(:,257), n3(:,742), t3x64(:,:,249))
  call vert_UV_W(ntry, wf16(:,30), 170, wf4(:,3), 80, wf64(:,258), n3(:,743), t3x64(:,:,250))
  call vert_QA_W(ntry, wf8(:,24), wf8(:,18), wf64(:,259), n3(:,744), t3x64(:,:,251))
  call vert_QA_W(ntry, wf8(:,22), wf8(:,20), wf64(:,260), n3(:,745), t3x64(:,:,252))
  call vert_QA_W(ntry, ex4(:), wf32(:,297), wf64(:,261), n3(:,746), t3x64(:,:,253))
  call vert_QA_W(ntry, ex3(:), wf32(:,299), wf64(:,262), n3(:,747), t3x64(:,:,254))
  call vert_QA_W(ntry, ex3(:), wf32(:,314), wf64(:,263), n3(:,748), t3x64(:,:,255))
  call vert_QA_W(ntry, wf32(:,301), ex2(:), wf64(:,264), n3(:,749), t3x64(:,:,256))
  call vert_QA_W(ntry, ex4(:), wf32(:,303), wf64(:,265), n3(:,750), t3x64(:,:,257))
  call vert_QA_W(ntry, wf32(:,305), ex2(:), wf64(:,266), n3(:,751), t3x64(:,:,258))
  call vert_QA_W(ntry, wf32(:,307), ex2(:), wf64(:,267), n3(:,752), t3x64(:,:,259))
  call vert_QA_W(ntry, wf32(:,261), ex8(:), wf64(:,268), n3(:,753), t3x64(:,:,260))
  call vert_QA_W(ntry, wf32(:,262), ex8(:), wf64(:,269), n3(:,754), t3x64(:,:,261))
  call vert_QA_W(ntry, ex6(:), wf32(:,263), wf64(:,270), n3(:,755), t3x64(:,:,262))
  call vert_QA_W(ntry, ex6(:), wf32(:,264), wf64(:,271), n3(:,756), t3x64(:,:,263))
  call vert_QA_W(ntry, wf32(:,265), ex8(:), wf64(:,272), n3(:,757), t3x64(:,:,264))
  call vert_QA_W(ntry, ex6(:), wf32(:,266), wf64(:,273), n3(:,758), t3x64(:,:,265))
  call vert_QA_W(ntry, wf32(:,318), ex1(:), wf64(:,274), n3(:,759), t3x64(:,:,266))
  call vert_QA_W(ntry, wf32(:,322), ex1(:), wf64(:,275), n3(:,760), t3x64(:,:,267))
  call vert_QA_W(ntry, wf32(:,324), ex1(:), wf64(:,276), n3(:,761), t3x64(:,:,268))
  call vert_QA_W(ntry, wf32(:,237), ex8(:), wf64(:,277), n3(:,762), t3x64(:,:,269))
  call vert_QA_W(ntry, wf32(:,238), ex8(:), wf64(:,278), n3(:,763), t3x64(:,:,270))
  call vert_QA_W(ntry, ex6(:), wf32(:,239), wf64(:,279), n3(:,764), t3x64(:,:,271))
  call vert_QA_W(ntry, ex6(:), wf32(:,240), wf64(:,280), n3(:,765), t3x64(:,:,272))
  call vert_QA_W(ntry, wf32(:,241), ex8(:), wf64(:,281), n3(:,766), t3x64(:,:,273))
  call vert_QA_W(ntry, ex6(:), wf32(:,242), wf64(:,282), n3(:,767), t3x64(:,:,274))
  call vert_QA_W(ntry, ex4(:), wf32(:,298), wf64(:,283), n3(:,768), t3x64(:,:,275))
  call vert_QA_W(ntry, ex3(:), wf32(:,300), wf64(:,284), n3(:,769), t3x64(:,:,276))
  call vert_QA_W(ntry, ex3(:), wf32(:,316), wf64(:,285), n3(:,770), t3x64(:,:,277))
  call vert_QA_W(ntry, wf32(:,302), ex2(:), wf64(:,286), n3(:,771), t3x64(:,:,278))
  call vert_QA_W(ntry, wf32(:,279), ex7(:), wf64(:,287), n3(:,772), t3x64(:,:,279))
  call vert_QA_W(ntry, ex4(:), wf32(:,308), wf64(:,288), n3(:,773), t3x64(:,:,280))
  call vert_QA_W(ntry, wf32(:,310), ex2(:), wf64(:,289), n3(:,774), t3x64(:,:,281))
  call vert_QA_W(ntry, wf32(:,312), ex2(:), wf64(:,290), n3(:,775), t3x64(:,:,282))
  call vert_QA_W(ntry, wf32(:,280), ex7(:), wf64(:,291), n3(:,776), t3x64(:,:,283))
  call vert_QA_W(ntry, wf32(:,281), ex7(:), wf64(:,292), n3(:,777), t3x64(:,:,284))
  call vert_QA_W(ntry, ex5(:), wf32(:,282), wf64(:,293), n3(:,778), t3x64(:,:,285))
  call vert_QA_W(ntry, ex5(:), wf32(:,283), wf64(:,294), n3(:,779), t3x64(:,:,286))
  call vert_QA_W(ntry, ex5(:), wf32(:,284), wf64(:,295), n3(:,780), t3x64(:,:,287))
  call vert_QA_W(ntry, wf32(:,320), ex1(:), wf64(:,296), n3(:,781), t3x64(:,:,288))
  call vert_QA_W(ntry, wf32(:,326), ex1(:), wf64(:,297), n3(:,782), t3x64(:,:,289))
  call vert_QA_W(ntry, wf32(:,328), ex1(:), wf64(:,298), n3(:,783), t3x64(:,:,290))
  call vert_QA_W(ntry, wf32(:,255), ex7(:), wf64(:,299), n3(:,784), t3x64(:,:,291))
  call vert_QA_W(ntry, wf32(:,256), ex7(:), wf64(:,300), n3(:,785), t3x64(:,:,292))
  call vert_QA_W(ntry, wf32(:,257), ex7(:), wf64(:,301), n3(:,786), t3x64(:,:,293))
  call vert_QA_W(ntry, ex5(:), wf32(:,258), wf64(:,302), n3(:,787), t3x64(:,:,294))
  call vert_QA_W(ntry, ex5(:), wf32(:,259), wf64(:,303), n3(:,788), t3x64(:,:,295))
  call vert_QA_W(ntry, ex5(:), wf32(:,260), wf64(:,304), n3(:,789), t3x64(:,:,296))


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  if (ntry < 2) then
    if(hel_mem_opt) hel_states = nhel
    call allocate_diagrams()
  end if

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    if (do_ct) call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  if (do_ct) M2ct = 0
  if (do_colint) M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    if (do_ct) call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      if (do_colint) call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    if (do_ct) M2ct = M2ct + M2add_ct
    if (do_colint) M2colint = M2colint + M2add_colint
  end do

#if -1 > 0 && 8 > 3
  if (loopcc) then
    !!Born-loop colour correlators interference
    
    M0M1_hel_cc(:,:,:)%j = 0
    M2ctcc = 0
    do n = 1, 20
      M2add_ct = 0
      m = ind_cc_comb(n)
        do k = 1, nhel
          call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
          call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
          M2ctcc(m) = M2ctcc(m) + M2add_ct
        end do
    end do
    M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
    M0M1_hel_cc(:,nhel+1:,:)%j = 0
  end if
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5,i6,i7,i8
integer :: n

n=0

do i8= 1, 2
do i7= 1, 2
do i6= 1, 2
do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2) .OR. (ex7(i7)%hf==-1_intkind2)  &
    .OR. (ex8(i8)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf + ex7(i7)%hf + ex8(i8)%hf
 end if
end do
end do
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_VV(nsync, wf4(:,4), wf64(:,1), A(:,1), n3(:,790), t3x256(:,:,1), nhel, den(6))
    call Hcont_SS(nsync, wf16(:,1), wf16(:,2), A(:,2), n3(:,791), t3x256(:,:,2), nhel, den(11))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,4), A(:,3), n3(:,792), t3x256(:,:,3), nhel, den(14))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,4), A(:,4), n3(:,793), t3x256(:,:,4), nhel, den(17))
    call Hcont_SS(nsync, wf16(:,5), wf16(:,6), A(:,5), n3(:,794), t3x256(:,:,5), nhel, den(22))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,8), A(:,6), n3(:,795), t3x256(:,:,6), nhel, den(25))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,8), A(:,7), n3(:,796), t3x256(:,:,7), nhel, den(28))
    call Hcont_QA(nsync, wf8(:,4), wf32(:,1), A(:,8), n3(:,797), t3x256(:,:,8), nhel, den(34))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,9), A(:,9), n3(:,798), t3x256(:,:,9), nhel, den(37))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,10), A(:,10), n3(:,799), t3x256(:,:,10), nhel, den(40))
    call Hcont_QA(nsync, wf8(:,8), wf32(:,2), A(:,11), n3(:,800), t3x256(:,:,11), nhel, den(46))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,11), A(:,12), n3(:,801), t3x256(:,:,12), nhel, den(47))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,12), A(:,13), n3(:,802), t3x256(:,:,13), nhel, den(48))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,13), A(:,14), n3(:,803), t3x256(:,:,14), nhel, den(49))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,14), A(:,15), n3(:,804), t3x256(:,:,15), nhel, den(50))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,15), A(:,16), n3(:,805), t3x256(:,:,16), nhel, den(51))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,16), A(:,17), n3(:,806), t3x256(:,:,17), nhel, den(52))
    call Hcont_QA(nsync, wf8(:,12), wf32(:,3), A(:,18), n3(:,807), t3x256(:,:,18), nhel, den(58))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,17), A(:,19), n3(:,808), t3x256(:,:,19), nhel, den(61))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,18), A(:,20), n3(:,809), t3x256(:,:,20), nhel, den(64))
    call Hcont_QA(nsync, wf8(:,16), wf32(:,4), A(:,21), n3(:,810), t3x256(:,:,21), nhel, den(70))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,19), A(:,22), n3(:,811), t3x256(:,:,22), nhel, den(71))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,20), A(:,23), n3(:,812), t3x256(:,:,23), nhel, den(72))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,21), A(:,24), n3(:,813), t3x256(:,:,24), nhel, den(73))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,22), A(:,25), n3(:,814), t3x256(:,:,25), nhel, den(74))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,23), A(:,26), n3(:,815), t3x256(:,:,26), nhel, den(75))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,24), A(:,27), n3(:,816), t3x256(:,:,27), nhel, den(76))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,17), A(:,28), n3(:,817), t3x256(:,:,28), nhel, den(78))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,18), A(:,29), n3(:,818), t3x256(:,:,29), nhel, den(80))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,17), A(:,30), n3(:,819), t3x256(:,:,30), nhel, den(82))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,18), A(:,31), n3(:,820), t3x256(:,:,31), nhel, den(84))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,21), A(:,32), n3(:,821), t3x256(:,:,32), nhel, den(86))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,22), A(:,33), n3(:,822), t3x256(:,:,33), nhel, den(88))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,23), A(:,34), n3(:,823), t3x256(:,:,34), nhel, den(90))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,24), A(:,35), n3(:,824), t3x256(:,:,35), nhel, den(92))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,19), A(:,36), n3(:,825), t3x256(:,:,36), nhel, den(94))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,20), A(:,37), n3(:,826), t3x256(:,:,37), nhel, den(96))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,19), A(:,38), n3(:,827), t3x256(:,:,38), nhel, den(97))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,20), A(:,39), n3(:,828), t3x256(:,:,39), nhel, den(98))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,21), A(:,40), n3(:,829), t3x256(:,:,40), nhel, den(100))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,22), A(:,41), n3(:,830), t3x256(:,:,41), nhel, den(102))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,23), A(:,42), n3(:,831), t3x256(:,:,42), nhel, den(103))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,24), A(:,43), n3(:,832), t3x256(:,:,43), nhel, den(104))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,25), A(:,44), n3(:,833), t3x256(:,:,44), nhel, den(107))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,26), A(:,45), n3(:,834), t3x256(:,:,45), nhel, den(108))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,27), A(:,46), n3(:,835), t3x256(:,:,46), nhel, den(111))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,28), A(:,47), n3(:,836), t3x256(:,:,47), nhel, den(112))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,29), A(:,48), n3(:,837), t3x256(:,:,48), nhel, den(115))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,30), A(:,49), n3(:,838), t3x256(:,:,49), nhel, den(118))
    call Hcont_QA(nsync, wf8(:,24), wf32(:,5), A(:,50), n3(:,839), t3x256(:,:,50), nhel, den(120))
    call Hcont_QA(nsync, wf8(:,22), wf32(:,6), A(:,51), n3(:,840), t3x256(:,:,51), nhel, den(122))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,25), A(:,52), n3(:,841), t3x256(:,:,52), nhel, den(124))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,26), A(:,53), n3(:,842), t3x256(:,:,53), nhel, den(126))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,29), A(:,54), n3(:,843), t3x256(:,:,54), nhel, den(128))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,25), A(:,55), n3(:,844), t3x256(:,:,55), nhel, den(129))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,26), A(:,56), n3(:,845), t3x256(:,:,56), nhel, den(130))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,29), A(:,57), n3(:,846), t3x256(:,:,57), nhel, den(131))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,27), A(:,58), n3(:,847), t3x256(:,:,58), nhel, den(133))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,28), A(:,59), n3(:,848), t3x256(:,:,59), nhel, den(135))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,30), A(:,60), n3(:,849), t3x256(:,:,60), nhel, den(137))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,30), A(:,61), n3(:,850), t3x256(:,:,61), nhel, den(138))
    call Hcont_VV(nsync, wf16(:,19), wf16(:,27), A(:,62), n3(:,851), t3x256(:,:,62), nhel, den(139))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,28), A(:,63), n3(:,852), t3x256(:,:,63), nhel, den(140))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,31), A(:,64), n3(:,853), t3x256(:,:,64), nhel, den(143))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,32), A(:,65), n3(:,854), t3x256(:,:,65), nhel, den(144))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,33), A(:,66), n3(:,855), t3x256(:,:,66), nhel, den(147))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,34), A(:,67), n3(:,856), t3x256(:,:,67), nhel, den(148))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,35), A(:,68), n3(:,857), t3x256(:,:,68), nhel, den(151))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,36), A(:,69), n3(:,858), t3x256(:,:,69), nhel, den(154))
    call Hcont_QA(nsync, wf8(:,32), wf32(:,7), A(:,70), n3(:,859), t3x256(:,:,70), nhel, den(156))
    call Hcont_QA(nsync, wf8(:,30), wf32(:,8), A(:,71), n3(:,860), t3x256(:,:,71), nhel, den(158))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,31), A(:,72), n3(:,861), t3x256(:,:,72), nhel, den(160))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,32), A(:,73), n3(:,862), t3x256(:,:,73), nhel, den(162))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,31), A(:,74), n3(:,863), t3x256(:,:,74), nhel, den(163))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,32), A(:,75), n3(:,864), t3x256(:,:,75), nhel, den(164))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,35), A(:,76), n3(:,865), t3x256(:,:,76), nhel, den(166))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,35), A(:,77), n3(:,866), t3x256(:,:,77), nhel, den(167))
    call Hcont_VV(nsync, wf16(:,24), wf16(:,36), A(:,78), n3(:,867), t3x256(:,:,78), nhel, den(169))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,33), A(:,79), n3(:,868), t3x256(:,:,79), nhel, den(171))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,34), A(:,80), n3(:,869), t3x256(:,:,80), nhel, den(173))
    call Hcont_VV(nsync, wf16(:,23), wf16(:,33), A(:,81), n3(:,870), t3x256(:,:,81), nhel, den(174))
    call Hcont_VV(nsync, wf16(:,24), wf16(:,34), A(:,82), n3(:,871), t3x256(:,:,82), nhel, den(175))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,36), A(:,83), n3(:,872), t3x256(:,:,83), nhel, den(176))
    call Hcont_VV(nsync, wf16(:,30), wf16(:,35), A(:,84), n3(:,873), t3x256(:,:,84), nhel, den(177))
    call Hcont_VV(nsync, wf16(:,29), wf16(:,36), A(:,85), n3(:,874), t3x256(:,:,85), nhel, den(178))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,36), A(:,86), n3(:,875), t3x256(:,:,86), nhel, den(179))
    call Hcont_VV(nsync, wf16(:,28), wf16(:,35), A(:,87), n3(:,876), t3x256(:,:,87), nhel, den(180))
    call Hcont_VV(nsync, wf16(:,30), wf16(:,32), A(:,88), n3(:,877), t3x256(:,:,88), nhel, den(181))
    call Hcont_VV(nsync, wf16(:,27), wf16(:,31), A(:,89), n3(:,878), t3x256(:,:,89), nhel, den(182))
    call Hcont_VV(nsync, wf16(:,28), wf16(:,32), A(:,90), n3(:,879), t3x256(:,:,90), nhel, den(183))
    call Hcont_VV(nsync, wf16(:,29), wf16(:,34), A(:,91), n3(:,880), t3x256(:,:,91), nhel, den(184))
    call Hcont_VV(nsync, wf16(:,25), wf16(:,33), A(:,92), n3(:,881), t3x256(:,:,92), nhel, den(185))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,34), A(:,93), n3(:,882), t3x256(:,:,93), nhel, den(186))

    call Hcont_VV(nsync, wf4(:,4), wf64(:,2), A(:,94), n3(:,883), t3x256(:,:,94), nhel, den(6))
    call Hcont_VV(nsync, wf64(:,1), wf4(:,5), A(:,95), n3(:,884), t3x256(:,:,95), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,4), wf64(:,3), A(:,96), n3(:,885), t3x256(:,:,96), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,4), wf64(:,4), A(:,97), n3(:,886), t3x256(:,:,97), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,4), wf64(:,5), A(:,98), n3(:,887), t3x256(:,:,98), nhel, den(6))
    call Hcont_SS(nsync, wf16(:,1), wf16(:,37), A(:,99), n3(:,888), t3x256(:,:,99), nhel, den(11))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,38), A(:,100), n3(:,889), t3x256(:,:,100), nhel, den(14))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,38), A(:,101), n3(:,890), t3x256(:,:,101), nhel, den(17))
    call Hcont_SS(nsync, wf16(:,5), wf16(:,39), A(:,102), n3(:,891), t3x256(:,:,102), nhel, den(22))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,40), A(:,103), n3(:,892), t3x256(:,:,103), nhel, den(25))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,40), A(:,104), n3(:,893), t3x256(:,:,104), nhel, den(28))
    call Hcont_SS(nsync, wf16(:,6), wf16(:,41), A(:,105), n3(:,894), t3x256(:,:,105), nhel, den(189))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,42), A(:,106), n3(:,895), t3x256(:,:,106), nhel, den(190))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,42), A(:,107), n3(:,896), t3x256(:,:,107), nhel, den(191))
    call Hcont_SS(nsync, wf16(:,2), wf16(:,43), A(:,108), n3(:,897), t3x256(:,:,108), nhel, den(194))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,44), A(:,109), n3(:,898), t3x256(:,:,109), nhel, den(195))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,44), A(:,110), n3(:,899), t3x256(:,:,110), nhel, den(196))
    call Hcont_VV(nsync, wf64(:,6), wf4(:,9), A(:,111), n3(:,900), t3x256(:,:,111), nhel, den(200))
    call Hcont_VV(nsync, wf64(:,7), wf4(:,10), A(:,112), n3(:,901), t3x256(:,:,112), nhel, den(204))
    call Hcont_VV(nsync, wf64(:,8), wf4(:,11), A(:,113), n3(:,902), t3x256(:,:,113), nhel, den(208))
    call Hcont_VV(nsync, wf64(:,1), wf4(:,12), A(:,114), n3(:,903), t3x256(:,:,114), nhel, den(211))
    call Hcont_QA(nsync, wf8(:,4), wf32(:,9), A(:,115), n3(:,904), t3x256(:,:,115), nhel, den(34))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,40), A(:,116), n3(:,905), t3x256(:,:,116), nhel, den(37))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,40), A(:,117), n3(:,906), t3x256(:,:,117), nhel, den(40))
    call Hcont_QA(nsync, wf8(:,8), wf32(:,10), A(:,118), n3(:,907), t3x256(:,:,118), nhel, den(46))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,40), A(:,119), n3(:,908), t3x256(:,:,119), nhel, den(47))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,40), A(:,120), n3(:,909), t3x256(:,:,120), nhel, den(48))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,44), A(:,121), n3(:,910), t3x256(:,:,121), nhel, den(49))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,44), A(:,122), n3(:,911), t3x256(:,:,122), nhel, den(50))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,44), A(:,123), n3(:,912), t3x256(:,:,123), nhel, den(51))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,44), A(:,124), n3(:,913), t3x256(:,:,124), nhel, den(52))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,45), A(:,125), n3(:,914), t3x256(:,:,125), nhel, den(37))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,46), A(:,126), n3(:,915), t3x256(:,:,126), nhel, den(40))
    call Hcont_QA(nsync, wf32(:,1), wf8(:,34), A(:,127), n3(:,916), t3x256(:,:,127), nhel, den(34))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,47), A(:,128), n3(:,917), t3x256(:,:,128), nhel, den(49))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,48), A(:,129), n3(:,918), t3x256(:,:,129), nhel, den(50))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,49), A(:,130), n3(:,919), t3x256(:,:,130), nhel, den(51))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,50), A(:,131), n3(:,920), t3x256(:,:,131), nhel, den(52))
    call Hcont_QA(nsync, wf32(:,2), wf8(:,36), A(:,132), n3(:,921), t3x256(:,:,132), nhel, den(46))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,51), A(:,133), n3(:,922), t3x256(:,:,133), nhel, den(47))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,52), A(:,134), n3(:,923), t3x256(:,:,134), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,12), wf32(:,11), A(:,135), n3(:,924), t3x256(:,:,135), nhel, den(58))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,38), A(:,136), n3(:,925), t3x256(:,:,136), nhel, den(61))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,38), A(:,137), n3(:,926), t3x256(:,:,137), nhel, den(64))
    call Hcont_QA(nsync, wf8(:,16), wf32(:,12), A(:,138), n3(:,927), t3x256(:,:,138), nhel, den(70))
    call Hcont_VV(nsync, wf16(:,19), wf16(:,38), A(:,139), n3(:,928), t3x256(:,:,139), nhel, den(71))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,38), A(:,140), n3(:,929), t3x256(:,:,140), nhel, den(72))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,42), A(:,141), n3(:,930), t3x256(:,:,141), nhel, den(73))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,42), A(:,142), n3(:,931), t3x256(:,:,142), nhel, den(74))
    call Hcont_VV(nsync, wf16(:,23), wf16(:,42), A(:,143), n3(:,932), t3x256(:,:,143), nhel, den(75))
    call Hcont_VV(nsync, wf16(:,24), wf16(:,42), A(:,144), n3(:,933), t3x256(:,:,144), nhel, den(76))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,47), A(:,145), n3(:,934), t3x256(:,:,145), nhel, den(78))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,48), A(:,146), n3(:,935), t3x256(:,:,146), nhel, den(80))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,49), A(:,147), n3(:,936), t3x256(:,:,147), nhel, den(82))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,50), A(:,148), n3(:,937), t3x256(:,:,148), nhel, den(84))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,45), A(:,149), n3(:,938), t3x256(:,:,149), nhel, den(86))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,46), A(:,150), n3(:,939), t3x256(:,:,150), nhel, den(88))
    call Hcont_VV(nsync, wf16(:,23), wf16(:,45), A(:,151), n3(:,940), t3x256(:,:,151), nhel, den(90))
    call Hcont_VV(nsync, wf16(:,24), wf16(:,46), A(:,152), n3(:,941), t3x256(:,:,152), nhel, den(92))
    call Hcont_VV(nsync, wf16(:,19), wf16(:,47), A(:,153), n3(:,942), t3x256(:,:,153), nhel, den(94))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,48), A(:,154), n3(:,943), t3x256(:,:,154), nhel, den(96))
    call Hcont_VV(nsync, wf16(:,19), wf16(:,49), A(:,155), n3(:,944), t3x256(:,:,155), nhel, den(97))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,50), A(:,156), n3(:,945), t3x256(:,:,156), nhel, den(98))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,51), A(:,157), n3(:,946), t3x256(:,:,157), nhel, den(100))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,52), A(:,158), n3(:,947), t3x256(:,:,158), nhel, den(102))
    call Hcont_VV(nsync, wf16(:,23), wf16(:,51), A(:,159), n3(:,948), t3x256(:,:,159), nhel, den(103))
    call Hcont_VV(nsync, wf16(:,24), wf16(:,52), A(:,160), n3(:,949), t3x256(:,:,160), nhel, den(104))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,53), A(:,161), n3(:,950), t3x256(:,:,161), nhel, den(61))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,54), A(:,162), n3(:,951), t3x256(:,:,162), nhel, den(64))
    call Hcont_QA(nsync, wf32(:,3), wf8(:,38), A(:,163), n3(:,952), t3x256(:,:,163), nhel, den(58))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,55), A(:,164), n3(:,953), t3x256(:,:,164), nhel, den(73))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,56), A(:,165), n3(:,954), t3x256(:,:,165), nhel, den(74))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,57), A(:,166), n3(:,955), t3x256(:,:,166), nhel, den(75))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,58), A(:,167), n3(:,956), t3x256(:,:,167), nhel, den(76))
    call Hcont_QA(nsync, wf32(:,4), wf8(:,40), A(:,168), n3(:,957), t3x256(:,:,168), nhel, den(70))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,59), A(:,169), n3(:,958), t3x256(:,:,169), nhel, den(71))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,60), A(:,170), n3(:,959), t3x256(:,:,170), nhel, den(72))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,53), A(:,171), n3(:,960), t3x256(:,:,171), nhel, den(213))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,54), A(:,172), n3(:,961), t3x256(:,:,172), nhel, den(215))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,53), A(:,173), n3(:,962), t3x256(:,:,173), nhel, den(82))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,54), A(:,174), n3(:,963), t3x256(:,:,174), nhel, den(84))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,55), A(:,175), n3(:,964), t3x256(:,:,175), nhel, den(217))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,56), A(:,176), n3(:,965), t3x256(:,:,176), nhel, den(219))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,57), A(:,177), n3(:,966), t3x256(:,:,177), nhel, den(90))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,58), A(:,178), n3(:,967), t3x256(:,:,178), nhel, den(92))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,55), A(:,179), n3(:,968), t3x256(:,:,179), nhel, den(100))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,56), A(:,180), n3(:,969), t3x256(:,:,180), nhel, den(102))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,57), A(:,181), n3(:,970), t3x256(:,:,181), nhel, den(103))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,58), A(:,182), n3(:,971), t3x256(:,:,182), nhel, den(104))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,59), A(:,183), n3(:,972), t3x256(:,:,183), nhel, den(94))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,60), A(:,184), n3(:,973), t3x256(:,:,184), nhel, den(96))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,59), A(:,185), n3(:,974), t3x256(:,:,185), nhel, den(97))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,60), A(:,186), n3(:,975), t3x256(:,:,186), nhel, den(98))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,61), A(:,187), n3(:,976), t3x256(:,:,187), nhel, den(47))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,62), A(:,188), n3(:,977), t3x256(:,:,188), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,8), wf32(:,13), A(:,189), n3(:,978), t3x256(:,:,189), nhel, den(46))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,63), A(:,190), n3(:,979), t3x256(:,:,190), nhel, den(51))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,64), A(:,191), n3(:,980), t3x256(:,:,191), nhel, den(52))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,65), A(:,192), n3(:,981), t3x256(:,:,192), nhel, den(49))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,66), A(:,193), n3(:,982), t3x256(:,:,193), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,4), wf32(:,14), A(:,194), n3(:,983), t3x256(:,:,194), nhel, den(34))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,67), A(:,195), n3(:,984), t3x256(:,:,195), nhel, den(37))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,68), A(:,196), n3(:,985), t3x256(:,:,196), nhel, den(40))
    call Hcont_SS(nsync, wf16(:,1), wf16(:,69), A(:,197), n3(:,986), t3x256(:,:,197), nhel, den(11))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,70), A(:,198), n3(:,987), t3x256(:,:,198), nhel, den(14))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,70), A(:,199), n3(:,988), t3x256(:,:,199), nhel, den(17))
    call Hcont_SS(nsync, wf16(:,1), wf16(:,71), A(:,200), n3(:,989), t3x256(:,:,200), nhel, den(11))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,72), A(:,201), n3(:,990), t3x256(:,:,201), nhel, den(14))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,72), A(:,202), n3(:,991), t3x256(:,:,202), nhel, den(17))
    call Hcont_SS(nsync, wf16(:,6), wf16(:,73), A(:,203), n3(:,992), t3x256(:,:,203), nhel, den(22))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,74), A(:,204), n3(:,993), t3x256(:,:,204), nhel, den(25))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,74), A(:,205), n3(:,994), t3x256(:,:,205), nhel, den(28))
    call Hcont_SS(nsync, wf16(:,6), wf16(:,75), A(:,206), n3(:,995), t3x256(:,:,206), nhel, den(22))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,76), A(:,207), n3(:,996), t3x256(:,:,207), nhel, den(25))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,76), A(:,208), n3(:,997), t3x256(:,:,208), nhel, den(28))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,63), A(:,209), n3(:,998), t3x256(:,:,209), nhel, den(220))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,64), A(:,210), n3(:,999), t3x256(:,:,210), nhel, den(221))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,65), A(:,211), n3(:,1000), t3x256(:,:,211), nhel, den(78))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,66), A(:,212), n3(:,1001), t3x256(:,:,212), nhel, den(80))
    call Hcont_VV(nsync, wf16(:,19), wf16(:,63), A(:,213), n3(:,1002), t3x256(:,:,213), nhel, den(97))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,64), A(:,214), n3(:,1003), t3x256(:,:,214), nhel, den(98))
    call Hcont_VV(nsync, wf16(:,19), wf16(:,65), A(:,215), n3(:,1004), t3x256(:,:,215), nhel, den(94))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,66), A(:,216), n3(:,1005), t3x256(:,:,216), nhel, den(96))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,61), A(:,217), n3(:,1006), t3x256(:,:,217), nhel, den(222))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,62), A(:,218), n3(:,1007), t3x256(:,:,218), nhel, den(223))
    call Hcont_VV(nsync, wf16(:,23), wf16(:,61), A(:,219), n3(:,1008), t3x256(:,:,219), nhel, den(103))
    call Hcont_VV(nsync, wf16(:,24), wf16(:,62), A(:,220), n3(:,1009), t3x256(:,:,220), nhel, den(104))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,67), A(:,221), n3(:,1010), t3x256(:,:,221), nhel, den(86))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,68), A(:,222), n3(:,1011), t3x256(:,:,222), nhel, den(88))
    call Hcont_VV(nsync, wf16(:,23), wf16(:,67), A(:,223), n3(:,1012), t3x256(:,:,223), nhel, den(90))
    call Hcont_VV(nsync, wf16(:,24), wf16(:,68), A(:,224), n3(:,1013), t3x256(:,:,224), nhel, den(92))
    call Hcont_QA(nsync, wf8(:,12), wf32(:,15), A(:,225), n3(:,1014), t3x256(:,:,225), nhel, den(58))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,70), A(:,226), n3(:,1015), t3x256(:,:,226), nhel, den(61))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,70), A(:,227), n3(:,1016), t3x256(:,:,227), nhel, den(64))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,72), A(:,228), n3(:,1017), t3x256(:,:,228), nhel, den(61))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,72), A(:,229), n3(:,1018), t3x256(:,:,229), nhel, den(64))
    call Hcont_QA(nsync, wf8(:,16), wf32(:,16), A(:,230), n3(:,1019), t3x256(:,:,230), nhel, den(70))
    call Hcont_VV(nsync, wf16(:,19), wf16(:,70), A(:,231), n3(:,1020), t3x256(:,:,231), nhel, den(71))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,70), A(:,232), n3(:,1021), t3x256(:,:,232), nhel, den(72))
    call Hcont_VV(nsync, wf16(:,19), wf16(:,72), A(:,233), n3(:,1022), t3x256(:,:,233), nhel, den(71))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,72), A(:,234), n3(:,1023), t3x256(:,:,234), nhel, den(72))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,74), A(:,235), n3(:,1024), t3x256(:,:,235), nhel, den(73))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,74), A(:,236), n3(:,1025), t3x256(:,:,236), nhel, den(74))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,76), A(:,237), n3(:,1026), t3x256(:,:,237), nhel, den(73))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,76), A(:,238), n3(:,1027), t3x256(:,:,238), nhel, den(74))
    call Hcont_VV(nsync, wf16(:,23), wf16(:,74), A(:,239), n3(:,1028), t3x256(:,:,239), nhel, den(75))
    call Hcont_VV(nsync, wf16(:,24), wf16(:,74), A(:,240), n3(:,1029), t3x256(:,:,240), nhel, den(76))
    call Hcont_VV(nsync, wf16(:,23), wf16(:,76), A(:,241), n3(:,1030), t3x256(:,:,241), nhel, den(75))
    call Hcont_VV(nsync, wf16(:,24), wf16(:,76), A(:,242), n3(:,1031), t3x256(:,:,242), nhel, den(76))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,77), A(:,243), n3(:,1032), t3x256(:,:,243), nhel, den(71))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,78), A(:,244), n3(:,1033), t3x256(:,:,244), nhel, den(72))
    call Hcont_QA(nsync, wf8(:,16), wf32(:,17), A(:,245), n3(:,1034), t3x256(:,:,245), nhel, den(70))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,79), A(:,246), n3(:,1035), t3x256(:,:,246), nhel, den(75))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,80), A(:,247), n3(:,1036), t3x256(:,:,247), nhel, den(76))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,81), A(:,248), n3(:,1037), t3x256(:,:,248), nhel, den(73))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,82), A(:,249), n3(:,1038), t3x256(:,:,249), nhel, den(74))
    call Hcont_QA(nsync, wf8(:,12), wf32(:,18), A(:,250), n3(:,1039), t3x256(:,:,250), nhel, den(58))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,83), A(:,251), n3(:,1040), t3x256(:,:,251), nhel, den(61))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,84), A(:,252), n3(:,1041), t3x256(:,:,252), nhel, den(64))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,79), A(:,253), n3(:,1042), t3x256(:,:,253), nhel, den(224))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,80), A(:,254), n3(:,1043), t3x256(:,:,254), nhel, den(225))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,81), A(:,255), n3(:,1044), t3x256(:,:,255), nhel, den(86))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,82), A(:,256), n3(:,1045), t3x256(:,:,256), nhel, den(88))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,77), A(:,257), n3(:,1046), t3x256(:,:,257), nhel, den(226))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,78), A(:,258), n3(:,1047), t3x256(:,:,258), nhel, den(227))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,77), A(:,259), n3(:,1048), t3x256(:,:,259), nhel, den(228))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,78), A(:,260), n3(:,1049), t3x256(:,:,260), nhel, den(229))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,79), A(:,261), n3(:,1050), t3x256(:,:,261), nhel, den(230))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,80), A(:,262), n3(:,1051), t3x256(:,:,262), nhel, den(231))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,81), A(:,263), n3(:,1052), t3x256(:,:,263), nhel, den(100))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,82), A(:,264), n3(:,1053), t3x256(:,:,264), nhel, den(102))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,83), A(:,265), n3(:,1054), t3x256(:,:,265), nhel, den(78))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,84), A(:,266), n3(:,1055), t3x256(:,:,266), nhel, den(80))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,83), A(:,267), n3(:,1056), t3x256(:,:,267), nhel, den(82))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,84), A(:,268), n3(:,1057), t3x256(:,:,268), nhel, den(84))
    call Hcont_SS(nsync, wf16(:,2), wf16(:,85), A(:,269), n3(:,1058), t3x256(:,:,269), nhel, den(11))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,86), A(:,270), n3(:,1059), t3x256(:,:,270), nhel, den(14))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,86), A(:,271), n3(:,1060), t3x256(:,:,271), nhel, den(17))
    call Hcont_SS(nsync, wf16(:,5), wf16(:,87), A(:,272), n3(:,1061), t3x256(:,:,272), nhel, den(22))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,88), A(:,273), n3(:,1062), t3x256(:,:,273), nhel, den(25))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,88), A(:,274), n3(:,1063), t3x256(:,:,274), nhel, den(28))
    call Hcont_QA(nsync, wf8(:,4), wf32(:,19), A(:,275), n3(:,1064), t3x256(:,:,275), nhel, den(34))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,88), A(:,276), n3(:,1065), t3x256(:,:,276), nhel, den(37))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,88), A(:,277), n3(:,1066), t3x256(:,:,277), nhel, den(40))
    call Hcont_QA(nsync, wf8(:,8), wf32(:,20), A(:,278), n3(:,1067), t3x256(:,:,278), nhel, den(46))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,88), A(:,279), n3(:,1068), t3x256(:,:,279), nhel, den(47))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,88), A(:,280), n3(:,1069), t3x256(:,:,280), nhel, den(48))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,86), A(:,281), n3(:,1070), t3x256(:,:,281), nhel, den(49))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,86), A(:,282), n3(:,1071), t3x256(:,:,282), nhel, den(50))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,86), A(:,283), n3(:,1072), t3x256(:,:,283), nhel, den(51))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,86), A(:,284), n3(:,1073), t3x256(:,:,284), nhel, den(52))
    call Hcont_VV(nsync, wf16(:,25), wf16(:,42), A(:,285), n3(:,1074), t3x256(:,:,285), nhel, den(107))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,42), A(:,286), n3(:,1075), t3x256(:,:,286), nhel, den(108))
    call Hcont_VV(nsync, wf16(:,27), wf16(:,44), A(:,287), n3(:,1076), t3x256(:,:,287), nhel, den(111))
    call Hcont_VV(nsync, wf16(:,28), wf16(:,44), A(:,288), n3(:,1077), t3x256(:,:,288), nhel, den(112))
    call Hcont_VV(nsync, wf16(:,29), wf16(:,42), A(:,289), n3(:,1078), t3x256(:,:,289), nhel, den(115))
    call Hcont_VV(nsync, wf16(:,30), wf16(:,44), A(:,290), n3(:,1079), t3x256(:,:,290), nhel, den(118))
    call Hcont_QA(nsync, wf8(:,24), wf32(:,21), A(:,291), n3(:,1080), t3x256(:,:,291), nhel, den(120))
    call Hcont_QA(nsync, wf8(:,22), wf32(:,22), A(:,292), n3(:,1081), t3x256(:,:,292), nhel, den(122))
    call Hcont_VV(nsync, wf16(:,25), wf16(:,45), A(:,293), n3(:,1082), t3x256(:,:,293), nhel, den(124))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,46), A(:,294), n3(:,1083), t3x256(:,:,294), nhel, den(126))
    call Hcont_VV(nsync, wf16(:,29), wf16(:,46), A(:,295), n3(:,1084), t3x256(:,:,295), nhel, den(128))
    call Hcont_VV(nsync, wf16(:,25), wf16(:,51), A(:,296), n3(:,1085), t3x256(:,:,296), nhel, den(129))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,52), A(:,297), n3(:,1086), t3x256(:,:,297), nhel, den(130))
    call Hcont_VV(nsync, wf16(:,29), wf16(:,52), A(:,298), n3(:,1087), t3x256(:,:,298), nhel, den(131))
    call Hcont_VV(nsync, wf16(:,27), wf16(:,53), A(:,299), n3(:,1088), t3x256(:,:,299), nhel, den(133))
    call Hcont_VV(nsync, wf16(:,28), wf16(:,54), A(:,300), n3(:,1089), t3x256(:,:,300), nhel, den(135))
    call Hcont_VV(nsync, wf16(:,30), wf16(:,54), A(:,301), n3(:,1090), t3x256(:,:,301), nhel, den(137))
    call Hcont_VV(nsync, wf16(:,30), wf16(:,60), A(:,302), n3(:,1091), t3x256(:,:,302), nhel, den(138))
    call Hcont_VV(nsync, wf16(:,27), wf16(:,59), A(:,303), n3(:,1092), t3x256(:,:,303), nhel, den(139))
    call Hcont_VV(nsync, wf16(:,28), wf16(:,60), A(:,304), n3(:,1093), t3x256(:,:,304), nhel, den(140))
    call Hcont_VV(nsync, wf16(:,25), wf16(:,61), A(:,305), n3(:,1094), t3x256(:,:,305), nhel, den(129))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,62), A(:,306), n3(:,1095), t3x256(:,:,306), nhel, den(130))
    call Hcont_VV(nsync, wf16(:,29), wf16(:,62), A(:,307), n3(:,1096), t3x256(:,:,307), nhel, den(131))
    call Hcont_VV(nsync, wf16(:,25), wf16(:,67), A(:,308), n3(:,1097), t3x256(:,:,308), nhel, den(124))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,68), A(:,309), n3(:,1098), t3x256(:,:,309), nhel, den(126))
    call Hcont_VV(nsync, wf16(:,29), wf16(:,68), A(:,310), n3(:,1099), t3x256(:,:,310), nhel, den(128))
    call Hcont_VV(nsync, wf16(:,25), wf16(:,74), A(:,311), n3(:,1100), t3x256(:,:,311), nhel, den(107))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,74), A(:,312), n3(:,1101), t3x256(:,:,312), nhel, den(108))
    call Hcont_VV(nsync, wf16(:,25), wf16(:,76), A(:,313), n3(:,1102), t3x256(:,:,313), nhel, den(107))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,76), A(:,314), n3(:,1103), t3x256(:,:,314), nhel, den(108))
    call Hcont_VV(nsync, wf16(:,29), wf16(:,74), A(:,315), n3(:,1104), t3x256(:,:,315), nhel, den(115))
    call Hcont_VV(nsync, wf16(:,29), wf16(:,76), A(:,316), n3(:,1105), t3x256(:,:,316), nhel, den(115))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,89), A(:,317), n3(:,1106), t3x256(:,:,317), nhel, den(118))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,90), A(:,318), n3(:,1107), t3x256(:,:,318), nhel, den(111))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,91), A(:,319), n3(:,1108), t3x256(:,:,319), nhel, den(112))
    call Hcont_QA(nsync, wf32(:,5), wf8(:,50), A(:,320), n3(:,1109), t3x256(:,:,320), nhel, den(120))
    call Hcont_QA(nsync, wf8(:,22), wf32(:,23), A(:,321), n3(:,1110), t3x256(:,:,321), nhel, den(122))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,89), A(:,322), n3(:,1111), t3x256(:,:,322), nhel, den(137))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,90), A(:,323), n3(:,1112), t3x256(:,:,323), nhel, den(133))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,91), A(:,324), n3(:,1113), t3x256(:,:,324), nhel, den(135))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,89), A(:,325), n3(:,1114), t3x256(:,:,325), nhel, den(138))
    call Hcont_VV(nsync, wf16(:,19), wf16(:,90), A(:,326), n3(:,1115), t3x256(:,:,326), nhel, den(139))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,91), A(:,327), n3(:,1116), t3x256(:,:,327), nhel, den(140))
    call Hcont_VV(nsync, wf16(:,27), wf16(:,77), A(:,328), n3(:,1117), t3x256(:,:,328), nhel, den(139))
    call Hcont_VV(nsync, wf16(:,28), wf16(:,78), A(:,329), n3(:,1118), t3x256(:,:,329), nhel, den(140))
    call Hcont_VV(nsync, wf16(:,30), wf16(:,78), A(:,330), n3(:,1119), t3x256(:,:,330), nhel, den(138))
    call Hcont_VV(nsync, wf16(:,27), wf16(:,83), A(:,331), n3(:,1120), t3x256(:,:,331), nhel, den(133))
    call Hcont_VV(nsync, wf16(:,28), wf16(:,84), A(:,332), n3(:,1121), t3x256(:,:,332), nhel, den(135))
    call Hcont_VV(nsync, wf16(:,30), wf16(:,84), A(:,333), n3(:,1122), t3x256(:,:,333), nhel, den(137))
    call Hcont_VV(nsync, wf16(:,27), wf16(:,86), A(:,334), n3(:,1123), t3x256(:,:,334), nhel, den(111))
    call Hcont_VV(nsync, wf16(:,28), wf16(:,86), A(:,335), n3(:,1124), t3x256(:,:,335), nhel, den(112))
    call Hcont_VV(nsync, wf16(:,30), wf16(:,86), A(:,336), n3(:,1125), t3x256(:,:,336), nhel, den(118))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,92), A(:,337), n3(:,1126), t3x256(:,:,337), nhel, den(115))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,93), A(:,338), n3(:,1127), t3x256(:,:,338), nhel, den(107))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,94), A(:,339), n3(:,1128), t3x256(:,:,339), nhel, den(108))
    call Hcont_QA(nsync, wf32(:,6), wf8(:,54), A(:,340), n3(:,1129), t3x256(:,:,340), nhel, den(122))
    call Hcont_QA(nsync, wf8(:,24), wf32(:,24), A(:,341), n3(:,1130), t3x256(:,:,341), nhel, den(120))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,92), A(:,342), n3(:,1131), t3x256(:,:,342), nhel, den(128))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,93), A(:,343), n3(:,1132), t3x256(:,:,343), nhel, den(124))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,94), A(:,344), n3(:,1133), t3x256(:,:,344), nhel, den(126))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,92), A(:,345), n3(:,1134), t3x256(:,:,345), nhel, den(131))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,93), A(:,346), n3(:,1135), t3x256(:,:,346), nhel, den(129))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,94), A(:,347), n3(:,1136), t3x256(:,:,347), nhel, den(130))
    call Hcont_QA(nsync, wf32(:,5), wf8(:,58), A(:,348), n3(:,1137), t3x256(:,:,348), nhel, den(120))
    call Hcont_QA(nsync, wf32(:,6), wf8(:,60), A(:,349), n3(:,1138), t3x256(:,:,349), nhel, den(122))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,95), A(:,350), n3(:,1139), t3x256(:,:,350), nhel, den(107))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,96), A(:,351), n3(:,1140), t3x256(:,:,351), nhel, den(108))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,97), A(:,352), n3(:,1141), t3x256(:,:,352), nhel, den(111))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,98), A(:,353), n3(:,1142), t3x256(:,:,353), nhel, den(112))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,99), A(:,354), n3(:,1143), t3x256(:,:,354), nhel, den(115))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,100), A(:,355), n3(:,1144), t3x256(:,:,355), nhel, den(118))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,95), A(:,356), n3(:,1145), t3x256(:,:,356), nhel, den(232))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,96), A(:,357), n3(:,1146), t3x256(:,:,357), nhel, den(233))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,99), A(:,358), n3(:,1147), t3x256(:,:,358), nhel, den(128))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,95), A(:,359), n3(:,1148), t3x256(:,:,359), nhel, den(234))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,96), A(:,360), n3(:,1149), t3x256(:,:,360), nhel, den(235))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,99), A(:,361), n3(:,1150), t3x256(:,:,361), nhel, den(131))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,97), A(:,362), n3(:,1151), t3x256(:,:,362), nhel, den(236))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,98), A(:,363), n3(:,1152), t3x256(:,:,363), nhel, den(237))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,100), A(:,364), n3(:,1153), t3x256(:,:,364), nhel, den(137))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,100), A(:,365), n3(:,1154), t3x256(:,:,365), nhel, den(138))
    call Hcont_VV(nsync, wf16(:,19), wf16(:,97), A(:,366), n3(:,1155), t3x256(:,:,366), nhel, den(238))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,98), A(:,367), n3(:,1156), t3x256(:,:,367), nhel, den(239))
    call Hcont_VV(nsync, wf16(:,31), wf16(:,38), A(:,368), n3(:,1157), t3x256(:,:,368), nhel, den(143))
    call Hcont_VV(nsync, wf16(:,32), wf16(:,38), A(:,369), n3(:,1158), t3x256(:,:,369), nhel, den(144))
    call Hcont_VV(nsync, wf16(:,33), wf16(:,40), A(:,370), n3(:,1159), t3x256(:,:,370), nhel, den(147))
    call Hcont_VV(nsync, wf16(:,34), wf16(:,40), A(:,371), n3(:,1160), t3x256(:,:,371), nhel, den(148))
    call Hcont_VV(nsync, wf16(:,35), wf16(:,38), A(:,372), n3(:,1161), t3x256(:,:,372), nhel, den(151))
    call Hcont_VV(nsync, wf16(:,36), wf16(:,40), A(:,373), n3(:,1162), t3x256(:,:,373), nhel, den(154))
    call Hcont_QA(nsync, wf8(:,32), wf32(:,25), A(:,374), n3(:,1163), t3x256(:,:,374), nhel, den(156))
    call Hcont_QA(nsync, wf8(:,30), wf32(:,26), A(:,375), n3(:,1164), t3x256(:,:,375), nhel, den(158))
    call Hcont_VV(nsync, wf16(:,31), wf16(:,47), A(:,376), n3(:,1165), t3x256(:,:,376), nhel, den(160))
    call Hcont_VV(nsync, wf16(:,32), wf16(:,48), A(:,377), n3(:,1166), t3x256(:,:,377), nhel, den(162))
    call Hcont_VV(nsync, wf16(:,31), wf16(:,49), A(:,378), n3(:,1167), t3x256(:,:,378), nhel, den(163))
    call Hcont_VV(nsync, wf16(:,32), wf16(:,50), A(:,379), n3(:,1168), t3x256(:,:,379), nhel, den(164))
    call Hcont_VV(nsync, wf16(:,35), wf16(:,50), A(:,380), n3(:,1169), t3x256(:,:,380), nhel, den(166))
    call Hcont_VV(nsync, wf16(:,35), wf16(:,48), A(:,381), n3(:,1170), t3x256(:,:,381), nhel, den(167))
    call Hcont_VV(nsync, wf16(:,36), wf16(:,58), A(:,382), n3(:,1171), t3x256(:,:,382), nhel, den(169))
    call Hcont_VV(nsync, wf16(:,33), wf16(:,55), A(:,383), n3(:,1172), t3x256(:,:,383), nhel, den(171))
    call Hcont_VV(nsync, wf16(:,34), wf16(:,56), A(:,384), n3(:,1173), t3x256(:,:,384), nhel, den(173))
    call Hcont_VV(nsync, wf16(:,33), wf16(:,57), A(:,385), n3(:,1174), t3x256(:,:,385), nhel, den(174))
    call Hcont_VV(nsync, wf16(:,34), wf16(:,58), A(:,386), n3(:,1175), t3x256(:,:,386), nhel, den(175))
    call Hcont_VV(nsync, wf16(:,36), wf16(:,56), A(:,387), n3(:,1176), t3x256(:,:,387), nhel, den(176))
    call Hcont_VV(nsync, wf16(:,31), wf16(:,63), A(:,388), n3(:,1177), t3x256(:,:,388), nhel, den(163))
    call Hcont_VV(nsync, wf16(:,32), wf16(:,64), A(:,389), n3(:,1178), t3x256(:,:,389), nhel, den(164))
    call Hcont_VV(nsync, wf16(:,31), wf16(:,65), A(:,390), n3(:,1179), t3x256(:,:,390), nhel, den(160))
    call Hcont_VV(nsync, wf16(:,32), wf16(:,66), A(:,391), n3(:,1180), t3x256(:,:,391), nhel, den(162))
    call Hcont_VV(nsync, wf16(:,35), wf16(:,66), A(:,392), n3(:,1181), t3x256(:,:,392), nhel, den(167))
    call Hcont_VV(nsync, wf16(:,35), wf16(:,64), A(:,393), n3(:,1182), t3x256(:,:,393), nhel, den(166))
    call Hcont_VV(nsync, wf16(:,31), wf16(:,70), A(:,394), n3(:,1183), t3x256(:,:,394), nhel, den(143))
    call Hcont_VV(nsync, wf16(:,32), wf16(:,70), A(:,395), n3(:,1184), t3x256(:,:,395), nhel, den(144))
    call Hcont_VV(nsync, wf16(:,31), wf16(:,72), A(:,396), n3(:,1185), t3x256(:,:,396), nhel, den(143))
    call Hcont_VV(nsync, wf16(:,32), wf16(:,72), A(:,397), n3(:,1186), t3x256(:,:,397), nhel, den(144))
    call Hcont_VV(nsync, wf16(:,35), wf16(:,70), A(:,398), n3(:,1187), t3x256(:,:,398), nhel, den(151))
    call Hcont_VV(nsync, wf16(:,35), wf16(:,72), A(:,399), n3(:,1188), t3x256(:,:,399), nhel, den(151))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,101), A(:,400), n3(:,1189), t3x256(:,:,400), nhel, den(154))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,102), A(:,401), n3(:,1190), t3x256(:,:,401), nhel, den(147))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,103), A(:,402), n3(:,1191), t3x256(:,:,402), nhel, den(148))
    call Hcont_QA(nsync, wf32(:,7), wf8(:,62), A(:,403), n3(:,1192), t3x256(:,:,403), nhel, den(156))
    call Hcont_QA(nsync, wf8(:,30), wf32(:,27), A(:,404), n3(:,1193), t3x256(:,:,404), nhel, den(158))
    call Hcont_VV(nsync, wf16(:,24), wf16(:,101), A(:,405), n3(:,1194), t3x256(:,:,405), nhel, den(169))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,101), A(:,406), n3(:,1195), t3x256(:,:,406), nhel, den(176))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,102), A(:,407), n3(:,1196), t3x256(:,:,407), nhel, den(171))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,103), A(:,408), n3(:,1197), t3x256(:,:,408), nhel, den(173))
    call Hcont_VV(nsync, wf16(:,23), wf16(:,102), A(:,409), n3(:,1198), t3x256(:,:,409), nhel, den(174))
    call Hcont_VV(nsync, wf16(:,24), wf16(:,103), A(:,410), n3(:,1199), t3x256(:,:,410), nhel, den(175))
    call Hcont_VV(nsync, wf16(:,33), wf16(:,79), A(:,411), n3(:,1200), t3x256(:,:,411), nhel, den(174))
    call Hcont_VV(nsync, wf16(:,34), wf16(:,80), A(:,412), n3(:,1201), t3x256(:,:,412), nhel, den(175))
    call Hcont_VV(nsync, wf16(:,33), wf16(:,81), A(:,413), n3(:,1202), t3x256(:,:,413), nhel, den(171))
    call Hcont_VV(nsync, wf16(:,34), wf16(:,82), A(:,414), n3(:,1203), t3x256(:,:,414), nhel, den(173))
    call Hcont_VV(nsync, wf16(:,36), wf16(:,82), A(:,415), n3(:,1204), t3x256(:,:,415), nhel, den(176))
    call Hcont_VV(nsync, wf16(:,36), wf16(:,80), A(:,416), n3(:,1205), t3x256(:,:,416), nhel, den(169))
    call Hcont_VV(nsync, wf16(:,33), wf16(:,88), A(:,417), n3(:,1206), t3x256(:,:,417), nhel, den(147))
    call Hcont_VV(nsync, wf16(:,34), wf16(:,88), A(:,418), n3(:,1207), t3x256(:,:,418), nhel, den(148))
    call Hcont_VV(nsync, wf16(:,36), wf16(:,88), A(:,419), n3(:,1208), t3x256(:,:,419), nhel, den(154))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,104), A(:,420), n3(:,1209), t3x256(:,:,420), nhel, den(151))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,105), A(:,421), n3(:,1210), t3x256(:,:,421), nhel, den(143))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,106), A(:,422), n3(:,1211), t3x256(:,:,422), nhel, den(144))
    call Hcont_QA(nsync, wf32(:,8), wf8(:,66), A(:,423), n3(:,1212), t3x256(:,:,423), nhel, den(158))
    call Hcont_QA(nsync, wf8(:,32), wf32(:,28), A(:,424), n3(:,1213), t3x256(:,:,424), nhel, den(156))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,104), A(:,425), n3(:,1214), t3x256(:,:,425), nhel, den(166))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,104), A(:,426), n3(:,1215), t3x256(:,:,426), nhel, den(167))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,105), A(:,427), n3(:,1216), t3x256(:,:,427), nhel, den(160))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,106), A(:,428), n3(:,1217), t3x256(:,:,428), nhel, den(162))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,105), A(:,429), n3(:,1218), t3x256(:,:,429), nhel, den(163))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,106), A(:,430), n3(:,1219), t3x256(:,:,430), nhel, den(164))
    call Hcont_VV(nsync, wf16(:,35), wf16(:,89), A(:,431), n3(:,1220), t3x256(:,:,431), nhel, den(177))
    call Hcont_VV(nsync, wf16(:,29), wf16(:,101), A(:,432), n3(:,1221), t3x256(:,:,432), nhel, den(178))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,101), A(:,433), n3(:,1222), t3x256(:,:,433), nhel, den(179))
    call Hcont_VV(nsync, wf16(:,35), wf16(:,91), A(:,434), n3(:,1223), t3x256(:,:,434), nhel, den(180))
    call Hcont_VV(nsync, wf16(:,32), wf16(:,89), A(:,435), n3(:,1224), t3x256(:,:,435), nhel, den(181))
    call Hcont_VV(nsync, wf16(:,31), wf16(:,90), A(:,436), n3(:,1225), t3x256(:,:,436), nhel, den(182))
    call Hcont_VV(nsync, wf16(:,32), wf16(:,91), A(:,437), n3(:,1226), t3x256(:,:,437), nhel, den(183))
    call Hcont_VV(nsync, wf16(:,29), wf16(:,103), A(:,438), n3(:,1227), t3x256(:,:,438), nhel, den(184))
    call Hcont_VV(nsync, wf16(:,25), wf16(:,102), A(:,439), n3(:,1228), t3x256(:,:,439), nhel, den(185))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,103), A(:,440), n3(:,1229), t3x256(:,:,440), nhel, den(186))
    call Hcont_VV(nsync, wf16(:,36), wf16(:,92), A(:,441), n3(:,1230), t3x256(:,:,441), nhel, den(178))
    call Hcont_VV(nsync, wf16(:,30), wf16(:,104), A(:,442), n3(:,1231), t3x256(:,:,442), nhel, den(177))
    call Hcont_VV(nsync, wf16(:,28), wf16(:,104), A(:,443), n3(:,1232), t3x256(:,:,443), nhel, den(180))
    call Hcont_VV(nsync, wf16(:,36), wf16(:,94), A(:,444), n3(:,1233), t3x256(:,:,444), nhel, den(179))
    call Hcont_VV(nsync, wf16(:,34), wf16(:,92), A(:,445), n3(:,1234), t3x256(:,:,445), nhel, den(184))
    call Hcont_VV(nsync, wf16(:,33), wf16(:,93), A(:,446), n3(:,1235), t3x256(:,:,446), nhel, den(185))
    call Hcont_VV(nsync, wf16(:,34), wf16(:,94), A(:,447), n3(:,1236), t3x256(:,:,447), nhel, den(186))
    call Hcont_VV(nsync, wf16(:,30), wf16(:,106), A(:,448), n3(:,1237), t3x256(:,:,448), nhel, den(181))
    call Hcont_VV(nsync, wf16(:,27), wf16(:,105), A(:,449), n3(:,1238), t3x256(:,:,449), nhel, den(182))
    call Hcont_VV(nsync, wf16(:,28), wf16(:,106), A(:,450), n3(:,1239), t3x256(:,:,450), nhel, den(183))
    call Hcont_VV(nsync, wf16(:,35), wf16(:,100), A(:,451), n3(:,1240), t3x256(:,:,451), nhel, den(177))
    call Hcont_VV(nsync, wf16(:,36), wf16(:,99), A(:,452), n3(:,1241), t3x256(:,:,452), nhel, den(178))
    call Hcont_VV(nsync, wf16(:,32), wf16(:,100), A(:,453), n3(:,1242), t3x256(:,:,453), nhel, den(181))
    call Hcont_VV(nsync, wf16(:,31), wf16(:,97), A(:,454), n3(:,1243), t3x256(:,:,454), nhel, den(182))
    call Hcont_VV(nsync, wf16(:,32), wf16(:,98), A(:,455), n3(:,1244), t3x256(:,:,455), nhel, den(183))
    call Hcont_VV(nsync, wf16(:,34), wf16(:,99), A(:,456), n3(:,1245), t3x256(:,:,456), nhel, den(184))
    call Hcont_VV(nsync, wf16(:,33), wf16(:,95), A(:,457), n3(:,1246), t3x256(:,:,457), nhel, den(185))
    call Hcont_VV(nsync, wf16(:,34), wf16(:,96), A(:,458), n3(:,1247), t3x256(:,:,458), nhel, den(186))
    call Hcont_VV(nsync, wf16(:,36), wf16(:,96), A(:,459), n3(:,1248), t3x256(:,:,459), nhel, den(179))
    call Hcont_VV(nsync, wf16(:,35), wf16(:,98), A(:,460), n3(:,1249), t3x256(:,:,460), nhel, den(180))
    call Hcont_QA(nsync, wf32(:,7), wf8(:,70), A(:,461), n3(:,1250), t3x256(:,:,461), nhel, den(156))
    call Hcont_QA(nsync, wf32(:,8), wf8(:,72), A(:,462), n3(:,1251), t3x256(:,:,462), nhel, den(158))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,107), A(:,463), n3(:,1252), t3x256(:,:,463), nhel, den(143))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,108), A(:,464), n3(:,1253), t3x256(:,:,464), nhel, den(144))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,109), A(:,465), n3(:,1254), t3x256(:,:,465), nhel, den(147))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,110), A(:,466), n3(:,1255), t3x256(:,:,466), nhel, den(148))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,111), A(:,467), n3(:,1256), t3x256(:,:,467), nhel, den(151))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,112), A(:,468), n3(:,1257), t3x256(:,:,468), nhel, den(154))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,107), A(:,469), n3(:,1258), t3x256(:,:,469), nhel, den(240))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,108), A(:,470), n3(:,1259), t3x256(:,:,470), nhel, den(241))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,107), A(:,471), n3(:,1260), t3x256(:,:,471), nhel, den(242))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,108), A(:,472), n3(:,1261), t3x256(:,:,472), nhel, den(243))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,111), A(:,473), n3(:,1262), t3x256(:,:,473), nhel, den(166))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,111), A(:,474), n3(:,1263), t3x256(:,:,474), nhel, den(167))
    call Hcont_VV(nsync, wf16(:,24), wf16(:,112), A(:,475), n3(:,1264), t3x256(:,:,475), nhel, den(169))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,109), A(:,476), n3(:,1265), t3x256(:,:,476), nhel, den(244))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,110), A(:,477), n3(:,1266), t3x256(:,:,477), nhel, den(245))
    call Hcont_VV(nsync, wf16(:,23), wf16(:,109), A(:,478), n3(:,1267), t3x256(:,:,478), nhel, den(246))
    call Hcont_VV(nsync, wf16(:,24), wf16(:,110), A(:,479), n3(:,1268), t3x256(:,:,479), nhel, den(247))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,112), A(:,480), n3(:,1269), t3x256(:,:,480), nhel, den(176))
    call Hcont_VV(nsync, wf16(:,30), wf16(:,111), A(:,481), n3(:,1270), t3x256(:,:,481), nhel, den(177))
    call Hcont_VV(nsync, wf16(:,29), wf16(:,112), A(:,482), n3(:,1271), t3x256(:,:,482), nhel, den(178))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,112), A(:,483), n3(:,1272), t3x256(:,:,483), nhel, den(179))
    call Hcont_VV(nsync, wf16(:,28), wf16(:,111), A(:,484), n3(:,1273), t3x256(:,:,484), nhel, den(180))
    call Hcont_VV(nsync, wf16(:,27), wf16(:,107), A(:,485), n3(:,1274), t3x256(:,:,485), nhel, den(248))
    call Hcont_VV(nsync, wf16(:,28), wf16(:,108), A(:,486), n3(:,1275), t3x256(:,:,486), nhel, den(249))
    call Hcont_VV(nsync, wf16(:,30), wf16(:,108), A(:,487), n3(:,1276), t3x256(:,:,487), nhel, den(181))
    call Hcont_VV(nsync, wf16(:,25), wf16(:,109), A(:,488), n3(:,1277), t3x256(:,:,488), nhel, den(250))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,110), A(:,489), n3(:,1278), t3x256(:,:,489), nhel, den(251))
    call Hcont_VV(nsync, wf16(:,29), wf16(:,110), A(:,490), n3(:,1279), t3x256(:,:,490), nhel, den(184))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,113), A(:,491), n3(:,1280), t3x256(:,:,491), nhel, den(107))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,114), A(:,492), n3(:,1281), t3x256(:,:,492), nhel, den(108))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,115), A(:,493), n3(:,1282), t3x256(:,:,493), nhel, den(111))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,116), A(:,494), n3(:,1283), t3x256(:,:,494), nhel, den(112))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,117), A(:,495), n3(:,1284), t3x256(:,:,495), nhel, den(252))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,118), A(:,496), n3(:,1285), t3x256(:,:,496), nhel, den(115))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,119), A(:,497), n3(:,1286), t3x256(:,:,497), nhel, den(253))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,120), A(:,498), n3(:,1287), t3x256(:,:,498), nhel, den(118))
    call Hcont_QA(nsync, wf8(:,24), wf32(:,29), A(:,499), n3(:,1288), t3x256(:,:,499), nhel, den(120))
    call Hcont_QA(nsync, wf8(:,22), wf32(:,30), A(:,500), n3(:,1289), t3x256(:,:,500), nhel, den(122))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,113), A(:,501), n3(:,1290), t3x256(:,:,501), nhel, den(124))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,114), A(:,502), n3(:,1291), t3x256(:,:,502), nhel, den(126))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,117), A(:,503), n3(:,1292), t3x256(:,:,503), nhel, den(254))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,118), A(:,504), n3(:,1293), t3x256(:,:,504), nhel, den(255))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,113), A(:,505), n3(:,1294), t3x256(:,:,505), nhel, den(129))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,114), A(:,506), n3(:,1295), t3x256(:,:,506), nhel, den(130))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,117), A(:,507), n3(:,1296), t3x256(:,:,507), nhel, den(256))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,118), A(:,508), n3(:,1297), t3x256(:,:,508), nhel, den(257))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,115), A(:,509), n3(:,1298), t3x256(:,:,509), nhel, den(133))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,116), A(:,510), n3(:,1299), t3x256(:,:,510), nhel, den(135))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,119), A(:,511), n3(:,1300), t3x256(:,:,511), nhel, den(258))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,120), A(:,512), n3(:,1301), t3x256(:,:,512), nhel, den(259))
    call Hcont_VV(nsync, wf16(:,19), wf16(:,119), A(:,513), n3(:,1302), t3x256(:,:,513), nhel, den(260))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,120), A(:,514), n3(:,1303), t3x256(:,:,514), nhel, den(261))
    call Hcont_VV(nsync, wf16(:,19), wf16(:,115), A(:,515), n3(:,1304), t3x256(:,:,515), nhel, den(139))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,116), A(:,516), n3(:,1305), t3x256(:,:,516), nhel, den(140))
    call Hcont_SS(nsync, wf16(:,1), wf16(:,121), A(:,517), n3(:,1306), t3x256(:,:,517), nhel, den(11))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,122), A(:,518), n3(:,1307), t3x256(:,:,518), nhel, den(14))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,122), A(:,519), n3(:,1308), t3x256(:,:,519), nhel, den(17))
    call Hcont_SS(nsync, wf16(:,5), wf16(:,123), A(:,520), n3(:,1309), t3x256(:,:,520), nhel, den(22))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,124), A(:,521), n3(:,1310), t3x256(:,:,521), nhel, den(25))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,124), A(:,522), n3(:,1311), t3x256(:,:,522), nhel, den(28))
    call Hcont_QA(nsync, wf32(:,1), wf8(:,78), A(:,523), n3(:,1312), t3x256(:,:,523), nhel, den(34))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,124), A(:,524), n3(:,1313), t3x256(:,:,524), nhel, den(37))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,124), A(:,525), n3(:,1314), t3x256(:,:,525), nhel, den(40))
    call Hcont_QA(nsync, wf8(:,8), wf32(:,31), A(:,526), n3(:,1315), t3x256(:,:,526), nhel, den(46))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,124), A(:,527), n3(:,1316), t3x256(:,:,527), nhel, den(47))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,124), A(:,528), n3(:,1317), t3x256(:,:,528), nhel, den(48))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,125), A(:,529), n3(:,1318), t3x256(:,:,529), nhel, den(49))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,126), A(:,530), n3(:,1319), t3x256(:,:,530), nhel, den(50))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,127), A(:,531), n3(:,1320), t3x256(:,:,531), nhel, den(51))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,128), A(:,532), n3(:,1321), t3x256(:,:,532), nhel, den(52))
    call Hcont_QA(nsync, wf32(:,3), wf8(:,82), A(:,533), n3(:,1322), t3x256(:,:,533), nhel, den(58))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,122), A(:,534), n3(:,1323), t3x256(:,:,534), nhel, den(61))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,122), A(:,535), n3(:,1324), t3x256(:,:,535), nhel, den(64))
    call Hcont_QA(nsync, wf8(:,16), wf32(:,32), A(:,536), n3(:,1325), t3x256(:,:,536), nhel, den(70))
    call Hcont_VV(nsync, wf16(:,19), wf16(:,122), A(:,537), n3(:,1326), t3x256(:,:,537), nhel, den(71))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,122), A(:,538), n3(:,1327), t3x256(:,:,538), nhel, den(72))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,129), A(:,539), n3(:,1328), t3x256(:,:,539), nhel, den(73))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,130), A(:,540), n3(:,1329), t3x256(:,:,540), nhel, den(74))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,131), A(:,541), n3(:,1330), t3x256(:,:,541), nhel, den(75))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,132), A(:,542), n3(:,1331), t3x256(:,:,542), nhel, den(76))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,125), A(:,543), n3(:,1332), t3x256(:,:,543), nhel, den(78))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,126), A(:,544), n3(:,1333), t3x256(:,:,544), nhel, den(80))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,127), A(:,545), n3(:,1334), t3x256(:,:,545), nhel, den(82))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,128), A(:,546), n3(:,1335), t3x256(:,:,546), nhel, den(84))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,129), A(:,547), n3(:,1336), t3x256(:,:,547), nhel, den(86))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,130), A(:,548), n3(:,1337), t3x256(:,:,548), nhel, den(88))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,131), A(:,549), n3(:,1338), t3x256(:,:,549), nhel, den(90))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,132), A(:,550), n3(:,1339), t3x256(:,:,550), nhel, den(92))
    call Hcont_VV(nsync, wf16(:,19), wf16(:,125), A(:,551), n3(:,1340), t3x256(:,:,551), nhel, den(94))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,126), A(:,552), n3(:,1341), t3x256(:,:,552), nhel, den(96))
    call Hcont_VV(nsync, wf16(:,19), wf16(:,127), A(:,553), n3(:,1342), t3x256(:,:,553), nhel, den(97))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,128), A(:,554), n3(:,1343), t3x256(:,:,554), nhel, den(98))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,129), A(:,555), n3(:,1344), t3x256(:,:,555), nhel, den(100))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,130), A(:,556), n3(:,1345), t3x256(:,:,556), nhel, den(102))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,131), A(:,557), n3(:,1346), t3x256(:,:,557), nhel, den(103))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,132), A(:,558), n3(:,1347), t3x256(:,:,558), nhel, den(104))
    call Hcont_VV(nsync, wf16(:,36), wf16(:,114), A(:,559), n3(:,1348), t3x256(:,:,559), nhel, den(179))
    call Hcont_VV(nsync, wf16(:,35), wf16(:,116), A(:,560), n3(:,1349), t3x256(:,:,560), nhel, den(180))
    call Hcont_VV(nsync, wf16(:,31), wf16(:,119), A(:,561), n3(:,1350), t3x256(:,:,561), nhel, den(262))
    call Hcont_VV(nsync, wf16(:,32), wf16(:,120), A(:,562), n3(:,1351), t3x256(:,:,562), nhel, den(263))
    call Hcont_VV(nsync, wf16(:,31), wf16(:,115), A(:,563), n3(:,1352), t3x256(:,:,563), nhel, den(182))
    call Hcont_VV(nsync, wf16(:,32), wf16(:,116), A(:,564), n3(:,1353), t3x256(:,:,564), nhel, den(183))
    call Hcont_VV(nsync, wf16(:,33), wf16(:,117), A(:,565), n3(:,1354), t3x256(:,:,565), nhel, den(264))
    call Hcont_VV(nsync, wf16(:,34), wf16(:,118), A(:,566), n3(:,1355), t3x256(:,:,566), nhel, den(265))
    call Hcont_VV(nsync, wf16(:,33), wf16(:,113), A(:,567), n3(:,1356), t3x256(:,:,567), nhel, den(185))
    call Hcont_VV(nsync, wf16(:,34), wf16(:,114), A(:,568), n3(:,1357), t3x256(:,:,568), nhel, den(186))
    call Hcont_VV(nsync, wf16(:,35), wf16(:,120), A(:,569), n3(:,1358), t3x256(:,:,569), nhel, den(177))
    call Hcont_VV(nsync, wf16(:,36), wf16(:,118), A(:,570), n3(:,1359), t3x256(:,:,570), nhel, den(178))
    call Hcont_VV(nsync, wf16(:,31), wf16(:,122), A(:,571), n3(:,1360), t3x256(:,:,571), nhel, den(143))
    call Hcont_VV(nsync, wf16(:,32), wf16(:,122), A(:,572), n3(:,1361), t3x256(:,:,572), nhel, den(144))
    call Hcont_VV(nsync, wf16(:,33), wf16(:,124), A(:,573), n3(:,1362), t3x256(:,:,573), nhel, den(147))
    call Hcont_VV(nsync, wf16(:,34), wf16(:,124), A(:,574), n3(:,1363), t3x256(:,:,574), nhel, den(148))
    call Hcont_VV(nsync, wf16(:,35), wf16(:,122), A(:,575), n3(:,1364), t3x256(:,:,575), nhel, den(151))
    call Hcont_VV(nsync, wf16(:,36), wf16(:,124), A(:,576), n3(:,1365), t3x256(:,:,576), nhel, den(154))
    call Hcont_QA(nsync, wf8(:,32), wf32(:,33), A(:,577), n3(:,1366), t3x256(:,:,577), nhel, den(156))
    call Hcont_QA(nsync, wf8(:,30), wf32(:,34), A(:,578), n3(:,1367), t3x256(:,:,578), nhel, den(158))
    call Hcont_VV(nsync, wf16(:,31), wf16(:,125), A(:,579), n3(:,1368), t3x256(:,:,579), nhel, den(160))
    call Hcont_VV(nsync, wf16(:,32), wf16(:,126), A(:,580), n3(:,1369), t3x256(:,:,580), nhel, den(162))
    call Hcont_VV(nsync, wf16(:,31), wf16(:,127), A(:,581), n3(:,1370), t3x256(:,:,581), nhel, den(163))
    call Hcont_VV(nsync, wf16(:,32), wf16(:,128), A(:,582), n3(:,1371), t3x256(:,:,582), nhel, den(164))
    call Hcont_VV(nsync, wf16(:,35), wf16(:,128), A(:,583), n3(:,1372), t3x256(:,:,583), nhel, den(166))
    call Hcont_VV(nsync, wf16(:,35), wf16(:,126), A(:,584), n3(:,1373), t3x256(:,:,584), nhel, den(167))
    call Hcont_VV(nsync, wf16(:,36), wf16(:,132), A(:,585), n3(:,1374), t3x256(:,:,585), nhel, den(169))
    call Hcont_VV(nsync, wf16(:,33), wf16(:,129), A(:,586), n3(:,1375), t3x256(:,:,586), nhel, den(171))
    call Hcont_VV(nsync, wf16(:,34), wf16(:,130), A(:,587), n3(:,1376), t3x256(:,:,587), nhel, den(173))
    call Hcont_VV(nsync, wf16(:,33), wf16(:,131), A(:,588), n3(:,1377), t3x256(:,:,588), nhel, den(174))
    call Hcont_VV(nsync, wf16(:,34), wf16(:,132), A(:,589), n3(:,1378), t3x256(:,:,589), nhel, den(175))
    call Hcont_VV(nsync, wf16(:,36), wf16(:,130), A(:,590), n3(:,1379), t3x256(:,:,590), nhel, den(176))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,133), A(:,591), n3(:,1380), t3x256(:,:,591), nhel, den(143))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,134), A(:,592), n3(:,1381), t3x256(:,:,592), nhel, den(144))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,135), A(:,593), n3(:,1382), t3x256(:,:,593), nhel, den(147))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,136), A(:,594), n3(:,1383), t3x256(:,:,594), nhel, den(148))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,137), A(:,595), n3(:,1384), t3x256(:,:,595), nhel, den(266))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,138), A(:,596), n3(:,1385), t3x256(:,:,596), nhel, den(151))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,139), A(:,597), n3(:,1386), t3x256(:,:,597), nhel, den(267))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,140), A(:,598), n3(:,1387), t3x256(:,:,598), nhel, den(154))
    call Hcont_QA(nsync, wf8(:,32), wf32(:,35), A(:,599), n3(:,1388), t3x256(:,:,599), nhel, den(156))
    call Hcont_QA(nsync, wf8(:,30), wf32(:,36), A(:,600), n3(:,1389), t3x256(:,:,600), nhel, den(158))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,133), A(:,601), n3(:,1390), t3x256(:,:,601), nhel, den(160))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,134), A(:,602), n3(:,1391), t3x256(:,:,602), nhel, den(162))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,133), A(:,603), n3(:,1392), t3x256(:,:,603), nhel, den(163))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,134), A(:,604), n3(:,1393), t3x256(:,:,604), nhel, den(164))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,137), A(:,605), n3(:,1394), t3x256(:,:,605), nhel, den(268))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,138), A(:,606), n3(:,1395), t3x256(:,:,606), nhel, den(269))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,137), A(:,607), n3(:,1396), t3x256(:,:,607), nhel, den(270))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,138), A(:,608), n3(:,1397), t3x256(:,:,608), nhel, den(271))
    call Hcont_VV(nsync, wf16(:,23), wf16(:,139), A(:,609), n3(:,1398), t3x256(:,:,609), nhel, den(272))
    call Hcont_VV(nsync, wf16(:,24), wf16(:,140), A(:,610), n3(:,1399), t3x256(:,:,610), nhel, den(273))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,135), A(:,611), n3(:,1400), t3x256(:,:,611), nhel, den(171))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,136), A(:,612), n3(:,1401), t3x256(:,:,612), nhel, den(173))
    call Hcont_VV(nsync, wf16(:,23), wf16(:,135), A(:,613), n3(:,1402), t3x256(:,:,613), nhel, den(174))
    call Hcont_VV(nsync, wf16(:,24), wf16(:,136), A(:,614), n3(:,1403), t3x256(:,:,614), nhel, den(175))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,139), A(:,615), n3(:,1404), t3x256(:,:,615), nhel, den(274))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,140), A(:,616), n3(:,1405), t3x256(:,:,616), nhel, den(275))
    call Hcont_VV(nsync, wf16(:,30), wf16(:,138), A(:,617), n3(:,1406), t3x256(:,:,617), nhel, den(276))
    call Hcont_VV(nsync, wf16(:,29), wf16(:,140), A(:,618), n3(:,1407), t3x256(:,:,618), nhel, den(277))
    call Hcont_VV(nsync, wf16(:,25), wf16(:,139), A(:,619), n3(:,1408), t3x256(:,:,619), nhel, den(278))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,140), A(:,620), n3(:,1409), t3x256(:,:,620), nhel, den(279))
    call Hcont_VV(nsync, wf16(:,27), wf16(:,137), A(:,621), n3(:,1410), t3x256(:,:,621), nhel, den(280))
    call Hcont_VV(nsync, wf16(:,28), wf16(:,138), A(:,622), n3(:,1411), t3x256(:,:,622), nhel, den(281))
    call Hcont_VV(nsync, wf16(:,30), wf16(:,134), A(:,623), n3(:,1412), t3x256(:,:,623), nhel, den(181))
    call Hcont_VV(nsync, wf16(:,27), wf16(:,133), A(:,624), n3(:,1413), t3x256(:,:,624), nhel, den(182))
    call Hcont_VV(nsync, wf16(:,28), wf16(:,134), A(:,625), n3(:,1414), t3x256(:,:,625), nhel, den(183))
    call Hcont_VV(nsync, wf16(:,29), wf16(:,136), A(:,626), n3(:,1415), t3x256(:,:,626), nhel, den(184))
    call Hcont_VV(nsync, wf16(:,25), wf16(:,135), A(:,627), n3(:,1416), t3x256(:,:,627), nhel, den(185))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,136), A(:,628), n3(:,1417), t3x256(:,:,628), nhel, den(186))
    call Hcont_SS(nsync, wf16(:,2), wf16(:,141), A(:,629), n3(:,1418), t3x256(:,:,629), nhel, den(11))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,142), A(:,630), n3(:,1419), t3x256(:,:,630), nhel, den(14))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,142), A(:,631), n3(:,1420), t3x256(:,:,631), nhel, den(17))
    call Hcont_SS(nsync, wf16(:,6), wf16(:,143), A(:,632), n3(:,1421), t3x256(:,:,632), nhel, den(22))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,144), A(:,633), n3(:,1422), t3x256(:,:,633), nhel, den(25))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,144), A(:,634), n3(:,1423), t3x256(:,:,634), nhel, den(28))
    call Hcont_QA(nsync, wf8(:,4), wf32(:,37), A(:,635), n3(:,1424), t3x256(:,:,635), nhel, den(34))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,145), A(:,636), n3(:,1425), t3x256(:,:,636), nhel, den(37))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,146), A(:,637), n3(:,1426), t3x256(:,:,637), nhel, den(40))
    call Hcont_QA(nsync, wf32(:,2), wf8(:,92), A(:,638), n3(:,1427), t3x256(:,:,638), nhel, den(46))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,147), A(:,639), n3(:,1428), t3x256(:,:,639), nhel, den(47))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,148), A(:,640), n3(:,1429), t3x256(:,:,640), nhel, den(48))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,142), A(:,641), n3(:,1430), t3x256(:,:,641), nhel, den(49))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,142), A(:,642), n3(:,1431), t3x256(:,:,642), nhel, den(50))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,142), A(:,643), n3(:,1432), t3x256(:,:,643), nhel, den(51))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,142), A(:,644), n3(:,1433), t3x256(:,:,644), nhel, den(52))
    call Hcont_QA(nsync, wf8(:,12), wf32(:,38), A(:,645), n3(:,1434), t3x256(:,:,645), nhel, den(58))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,149), A(:,646), n3(:,1435), t3x256(:,:,646), nhel, den(61))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,150), A(:,647), n3(:,1436), t3x256(:,:,647), nhel, den(64))
    call Hcont_QA(nsync, wf32(:,4), wf8(:,96), A(:,648), n3(:,1437), t3x256(:,:,648), nhel, den(70))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,151), A(:,649), n3(:,1438), t3x256(:,:,649), nhel, den(71))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,152), A(:,650), n3(:,1439), t3x256(:,:,650), nhel, den(72))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,144), A(:,651), n3(:,1440), t3x256(:,:,651), nhel, den(73))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,144), A(:,652), n3(:,1441), t3x256(:,:,652), nhel, den(74))
    call Hcont_VV(nsync, wf16(:,23), wf16(:,144), A(:,653), n3(:,1442), t3x256(:,:,653), nhel, den(75))
    call Hcont_VV(nsync, wf16(:,24), wf16(:,144), A(:,654), n3(:,1443), t3x256(:,:,654), nhel, den(76))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,149), A(:,655), n3(:,1444), t3x256(:,:,655), nhel, den(78))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,150), A(:,656), n3(:,1445), t3x256(:,:,656), nhel, den(80))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,149), A(:,657), n3(:,1446), t3x256(:,:,657), nhel, den(82))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,150), A(:,658), n3(:,1447), t3x256(:,:,658), nhel, den(84))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,145), A(:,659), n3(:,1448), t3x256(:,:,659), nhel, den(86))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,146), A(:,660), n3(:,1449), t3x256(:,:,660), nhel, den(88))
    call Hcont_VV(nsync, wf16(:,23), wf16(:,145), A(:,661), n3(:,1450), t3x256(:,:,661), nhel, den(90))
    call Hcont_VV(nsync, wf16(:,24), wf16(:,146), A(:,662), n3(:,1451), t3x256(:,:,662), nhel, den(92))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,151), A(:,663), n3(:,1452), t3x256(:,:,663), nhel, den(94))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,152), A(:,664), n3(:,1453), t3x256(:,:,664), nhel, den(96))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,151), A(:,665), n3(:,1454), t3x256(:,:,665), nhel, den(97))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,152), A(:,666), n3(:,1455), t3x256(:,:,666), nhel, den(98))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,147), A(:,667), n3(:,1456), t3x256(:,:,667), nhel, den(100))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,148), A(:,668), n3(:,1457), t3x256(:,:,668), nhel, den(102))
    call Hcont_VV(nsync, wf16(:,23), wf16(:,147), A(:,669), n3(:,1458), t3x256(:,:,669), nhel, den(103))
    call Hcont_VV(nsync, wf16(:,24), wf16(:,148), A(:,670), n3(:,1459), t3x256(:,:,670), nhel, den(104))
    call Hcont_VV(nsync, wf16(:,25), wf16(:,144), A(:,671), n3(:,1460), t3x256(:,:,671), nhel, den(107))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,144), A(:,672), n3(:,1461), t3x256(:,:,672), nhel, den(108))
    call Hcont_VV(nsync, wf16(:,27), wf16(:,142), A(:,673), n3(:,1462), t3x256(:,:,673), nhel, den(111))
    call Hcont_VV(nsync, wf16(:,28), wf16(:,142), A(:,674), n3(:,1463), t3x256(:,:,674), nhel, den(112))
    call Hcont_VV(nsync, wf16(:,29), wf16(:,144), A(:,675), n3(:,1464), t3x256(:,:,675), nhel, den(115))
    call Hcont_VV(nsync, wf16(:,30), wf16(:,142), A(:,676), n3(:,1465), t3x256(:,:,676), nhel, den(118))
    call Hcont_QA(nsync, wf8(:,24), wf32(:,39), A(:,677), n3(:,1466), t3x256(:,:,677), nhel, den(120))
    call Hcont_QA(nsync, wf8(:,22), wf32(:,40), A(:,678), n3(:,1467), t3x256(:,:,678), nhel, den(122))
    call Hcont_VV(nsync, wf16(:,25), wf16(:,145), A(:,679), n3(:,1468), t3x256(:,:,679), nhel, den(124))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,146), A(:,680), n3(:,1469), t3x256(:,:,680), nhel, den(126))
    call Hcont_VV(nsync, wf16(:,29), wf16(:,146), A(:,681), n3(:,1470), t3x256(:,:,681), nhel, den(128))
    call Hcont_VV(nsync, wf16(:,25), wf16(:,147), A(:,682), n3(:,1471), t3x256(:,:,682), nhel, den(129))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,148), A(:,683), n3(:,1472), t3x256(:,:,683), nhel, den(130))
    call Hcont_VV(nsync, wf16(:,29), wf16(:,148), A(:,684), n3(:,1473), t3x256(:,:,684), nhel, den(131))
    call Hcont_VV(nsync, wf16(:,27), wf16(:,149), A(:,685), n3(:,1474), t3x256(:,:,685), nhel, den(133))
    call Hcont_VV(nsync, wf16(:,28), wf16(:,150), A(:,686), n3(:,1475), t3x256(:,:,686), nhel, den(135))
    call Hcont_VV(nsync, wf16(:,30), wf16(:,150), A(:,687), n3(:,1476), t3x256(:,:,687), nhel, den(137))
    call Hcont_VV(nsync, wf16(:,30), wf16(:,152), A(:,688), n3(:,1477), t3x256(:,:,688), nhel, den(138))
    call Hcont_VV(nsync, wf16(:,27), wf16(:,151), A(:,689), n3(:,1478), t3x256(:,:,689), nhel, den(139))
    call Hcont_VV(nsync, wf16(:,28), wf16(:,152), A(:,690), n3(:,1479), t3x256(:,:,690), nhel, den(140))
    call Hcont_SS(nsync, wf16(:,2), wf16(:,153), A(:,691), n3(:,1480), t3x256(:,:,691), nhel, den(284))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,154), A(:,692), n3(:,1481), t3x256(:,:,692), nhel, den(285))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,154), A(:,693), n3(:,1482), t3x256(:,:,693), nhel, den(286))
    call Hcont_SS(nsync, wf16(:,2), wf16(:,155), A(:,694), n3(:,1483), t3x256(:,:,694), nhel, den(284))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,156), A(:,695), n3(:,1484), t3x256(:,:,695), nhel, den(285))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,156), A(:,696), n3(:,1485), t3x256(:,:,696), nhel, den(286))
    call Hcont_SS(nsync, wf16(:,6), wf16(:,157), A(:,697), n3(:,1486), t3x256(:,:,697), nhel, den(288))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,158), A(:,698), n3(:,1487), t3x256(:,:,698), nhel, den(289))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,158), A(:,699), n3(:,1488), t3x256(:,:,699), nhel, den(290))
    call Hcont_SS(nsync, wf16(:,6), wf16(:,159), A(:,700), n3(:,1489), t3x256(:,:,700), nhel, den(288))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,160), A(:,701), n3(:,1490), t3x256(:,:,701), nhel, den(289))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,160), A(:,702), n3(:,1491), t3x256(:,:,702), nhel, den(290))
    call Hcont_SS(nsync, wf16(:,5), wf16(:,161), A(:,703), n3(:,1492), t3x256(:,:,703), nhel, den(293))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,162), A(:,704), n3(:,1493), t3x256(:,:,704), nhel, den(294))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,162), A(:,705), n3(:,1494), t3x256(:,:,705), nhel, den(295))
    call Hcont_SS(nsync, wf16(:,5), wf16(:,163), A(:,706), n3(:,1495), t3x256(:,:,706), nhel, den(293))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,164), A(:,707), n3(:,1496), t3x256(:,:,707), nhel, den(294))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,164), A(:,708), n3(:,1497), t3x256(:,:,708), nhel, den(295))
    call Hcont_SS(nsync, wf16(:,1), wf16(:,165), A(:,709), n3(:,1498), t3x256(:,:,709), nhel, den(297))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,166), A(:,710), n3(:,1499), t3x256(:,:,710), nhel, den(298))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,166), A(:,711), n3(:,1500), t3x256(:,:,711), nhel, den(299))
    call Hcont_SS(nsync, wf16(:,1), wf16(:,167), A(:,712), n3(:,1501), t3x256(:,:,712), nhel, den(297))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,168), A(:,713), n3(:,1502), t3x256(:,:,713), nhel, den(298))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,168), A(:,714), n3(:,1503), t3x256(:,:,714), nhel, den(299))
    call Hcont_SS(nsync, wf16(:,2), wf16(:,169), A(:,715), n3(:,1504), t3x256(:,:,715), nhel, den(302))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,170), A(:,716), n3(:,1505), t3x256(:,:,716), nhel, den(303))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,170), A(:,717), n3(:,1506), t3x256(:,:,717), nhel, den(304))
    call Hcont_SS(nsync, wf16(:,2), wf16(:,171), A(:,718), n3(:,1507), t3x256(:,:,718), nhel, den(302))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,172), A(:,719), n3(:,1508), t3x256(:,:,719), nhel, den(303))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,172), A(:,720), n3(:,1509), t3x256(:,:,720), nhel, den(304))
    call Hcont_SS(nsync, wf16(:,5), wf16(:,173), A(:,721), n3(:,1510), t3x256(:,:,721), nhel, den(306))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,174), A(:,722), n3(:,1511), t3x256(:,:,722), nhel, den(307))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,174), A(:,723), n3(:,1512), t3x256(:,:,723), nhel, den(308))
    call Hcont_SS(nsync, wf16(:,5), wf16(:,175), A(:,724), n3(:,1513), t3x256(:,:,724), nhel, den(306))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,176), A(:,725), n3(:,1514), t3x256(:,:,725), nhel, den(307))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,176), A(:,726), n3(:,1515), t3x256(:,:,726), nhel, den(308))
    call Hcont_SS(nsync, wf16(:,6), wf16(:,177), A(:,727), n3(:,1516), t3x256(:,:,727), nhel, den(311))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,178), A(:,728), n3(:,1517), t3x256(:,:,728), nhel, den(312))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,178), A(:,729), n3(:,1518), t3x256(:,:,729), nhel, den(313))
    call Hcont_SS(nsync, wf16(:,6), wf16(:,179), A(:,730), n3(:,1519), t3x256(:,:,730), nhel, den(311))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,180), A(:,731), n3(:,1520), t3x256(:,:,731), nhel, den(312))
    call Hcont_VV(nsync, wf16(:,8), wf16(:,180), A(:,732), n3(:,1521), t3x256(:,:,732), nhel, den(313))
    call Hcont_SS(nsync, wf16(:,1), wf16(:,181), A(:,733), n3(:,1522), t3x256(:,:,733), nhel, den(315))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,182), A(:,734), n3(:,1523), t3x256(:,:,734), nhel, den(316))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,182), A(:,735), n3(:,1524), t3x256(:,:,735), nhel, den(317))
    call Hcont_SS(nsync, wf16(:,1), wf16(:,183), A(:,736), n3(:,1525), t3x256(:,:,736), nhel, den(315))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,184), A(:,737), n3(:,1526), t3x256(:,:,737), nhel, den(316))
    call Hcont_VV(nsync, wf16(:,3), wf16(:,184), A(:,738), n3(:,1527), t3x256(:,:,738), nhel, den(317))
    call Hcont_SS(nsync, wf16(:,2), wf16(:,185), A(:,739), n3(:,1528), t3x256(:,:,739), nhel, den(318))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,186), A(:,740), n3(:,1529), t3x256(:,:,740), nhel, den(319))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,187), A(:,741), n3(:,1530), t3x256(:,:,741), nhel, den(320))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,187), A(:,742), n3(:,1531), t3x256(:,:,742), nhel, den(321))
    call Hcont_VV(nsync, wf16(:,4), wf16(:,188), A(:,743), n3(:,1532), t3x256(:,:,743), nhel, den(322))
    call Hcont_SS(nsync, wf16(:,5), wf16(:,189), A(:,744), n3(:,1533), t3x256(:,:,744), nhel, den(323))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,190), A(:,745), n3(:,1534), t3x256(:,:,745), nhel, den(324))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,191), A(:,746), n3(:,1535), t3x256(:,:,746), nhel, den(325))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,191), A(:,747), n3(:,1536), t3x256(:,:,747), nhel, den(326))
    call Hcont_VV(nsync, wf16(:,7), wf16(:,192), A(:,748), n3(:,1537), t3x256(:,:,748), nhel, den(327))
    call Hcont_QA(nsync, wf32(:,41), wf8(:,98), A(:,749), n3(:,1538), t3x256(:,:,749), nhel, den(330))
    call Hcont_QA(nsync, wf8(:,98), wf32(:,42), A(:,750), n3(:,1539), t3x256(:,:,750), nhel, den(331))
    call Hcont_QA(nsync, wf8(:,98), wf32(:,43), A(:,751), n3(:,1540), t3x256(:,:,751), nhel, den(332))
    call Hcont_QA(nsync, wf32(:,2), wf8(:,100), A(:,752), n3(:,1541), t3x256(:,:,752), nhel, den(334))
    call Hcont_QA(nsync, wf8(:,99), wf32(:,45), A(:,753), n3(:,1542), t3x256(:,:,753), nhel, den(337))
    call Hcont_QA(nsync, wf8(:,99), wf32(:,47), A(:,754), n3(:,1543), t3x256(:,:,754), nhel, den(339))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,154), A(:,755), n3(:,1544), t3x256(:,:,755), nhel, den(340))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,154), A(:,756), n3(:,1545), t3x256(:,:,756), nhel, den(341))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,156), A(:,757), n3(:,1546), t3x256(:,:,757), nhel, den(340))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,156), A(:,758), n3(:,1547), t3x256(:,:,758), nhel, den(341))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,154), A(:,759), n3(:,1548), t3x256(:,:,759), nhel, den(342))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,154), A(:,760), n3(:,1549), t3x256(:,:,760), nhel, den(343))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,156), A(:,761), n3(:,1550), t3x256(:,:,761), nhel, den(342))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,156), A(:,762), n3(:,1551), t3x256(:,:,762), nhel, den(343))
    call Hcont_QA(nsync, wf32(:,48), wf8(:,102), A(:,763), n3(:,1552), t3x256(:,:,763), nhel, den(346))
    call Hcont_QA(nsync, wf8(:,102), wf32(:,49), A(:,764), n3(:,1553), t3x256(:,:,764), nhel, den(347))
    call Hcont_QA(nsync, wf8(:,102), wf32(:,50), A(:,765), n3(:,1554), t3x256(:,:,765), nhel, den(348))
    call Hcont_QA(nsync, wf32(:,1), wf8(:,104), A(:,766), n3(:,1555), t3x256(:,:,766), nhel, den(350))
    call Hcont_QA(nsync, wf8(:,103), wf32(:,52), A(:,767), n3(:,1556), t3x256(:,:,767), nhel, den(353))
    call Hcont_QA(nsync, wf8(:,103), wf32(:,54), A(:,768), n3(:,1557), t3x256(:,:,768), nhel, den(355))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,162), A(:,769), n3(:,1558), t3x256(:,:,769), nhel, den(356))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,162), A(:,770), n3(:,1559), t3x256(:,:,770), nhel, den(357))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,164), A(:,771), n3(:,1560), t3x256(:,:,771), nhel, den(356))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,164), A(:,772), n3(:,1561), t3x256(:,:,772), nhel, den(357))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,162), A(:,773), n3(:,1562), t3x256(:,:,773), nhel, den(358))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,162), A(:,774), n3(:,1563), t3x256(:,:,774), nhel, den(359))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,164), A(:,775), n3(:,1564), t3x256(:,:,775), nhel, den(358))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,164), A(:,776), n3(:,1565), t3x256(:,:,776), nhel, den(359))
    call Hcont_QA(nsync, wf8(:,4), wf32(:,55), A(:,777), n3(:,1566), t3x256(:,:,777), nhel, den(361))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,174), A(:,778), n3(:,1567), t3x256(:,:,778), nhel, den(362))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,174), A(:,779), n3(:,1568), t3x256(:,:,779), nhel, den(363))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,176), A(:,780), n3(:,1569), t3x256(:,:,780), nhel, den(362))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,176), A(:,781), n3(:,1570), t3x256(:,:,781), nhel, den(363))
    call Hcont_QA(nsync, wf8(:,8), wf32(:,56), A(:,782), n3(:,1571), t3x256(:,:,782), nhel, den(365))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,174), A(:,783), n3(:,1572), t3x256(:,:,783), nhel, den(366))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,174), A(:,784), n3(:,1573), t3x256(:,:,784), nhel, den(367))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,176), A(:,785), n3(:,1574), t3x256(:,:,785), nhel, den(366))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,176), A(:,786), n3(:,1575), t3x256(:,:,786), nhel, den(367))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,170), A(:,787), n3(:,1576), t3x256(:,:,787), nhel, den(368))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,170), A(:,788), n3(:,1577), t3x256(:,:,788), nhel, den(369))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,172), A(:,789), n3(:,1578), t3x256(:,:,789), nhel, den(368))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,172), A(:,790), n3(:,1579), t3x256(:,:,790), nhel, den(369))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,170), A(:,791), n3(:,1580), t3x256(:,:,791), nhel, den(370))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,170), A(:,792), n3(:,1581), t3x256(:,:,792), nhel, den(371))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,172), A(:,793), n3(:,1582), t3x256(:,:,793), nhel, den(370))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,172), A(:,794), n3(:,1583), t3x256(:,:,794), nhel, den(371))
    call Hcont_QA(nsync, wf8(:,105), wf32(:,57), A(:,795), n3(:,1584), t3x256(:,:,795), nhel, den(374))
    call Hcont_QA(nsync, wf8(:,105), wf32(:,58), A(:,796), n3(:,1585), t3x256(:,:,796), nhel, den(376))
    call Hcont_QA(nsync, wf32(:,45), wf8(:,106), A(:,797), n3(:,1586), t3x256(:,:,797), nhel, den(377))
    call Hcont_QA(nsync, wf32(:,47), wf8(:,106), A(:,798), n3(:,1587), t3x256(:,:,798), nhel, den(378))
    call Hcont_QA(nsync, wf8(:,107), wf32(:,59), A(:,799), n3(:,1588), t3x256(:,:,799), nhel, den(381))
    call Hcont_QA(nsync, wf8(:,107), wf32(:,60), A(:,800), n3(:,1589), t3x256(:,:,800), nhel, den(383))
    call Hcont_QA(nsync, wf32(:,52), wf8(:,108), A(:,801), n3(:,1590), t3x256(:,:,801), nhel, den(384))
    call Hcont_QA(nsync, wf32(:,54), wf8(:,108), A(:,802), n3(:,1591), t3x256(:,:,802), nhel, den(385))
    call Hcont_QA(nsync, wf8(:,105), wf32(:,61), A(:,803), n3(:,1592), t3x256(:,:,803), nhel, den(387))
    call Hcont_QA(nsync, wf8(:,107), wf32(:,62), A(:,804), n3(:,1593), t3x256(:,:,804), nhel, den(389))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,190), A(:,805), n3(:,1594), t3x256(:,:,805), nhel, den(390))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,191), A(:,806), n3(:,1595), t3x256(:,:,806), nhel, den(391))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,191), A(:,807), n3(:,1596), t3x256(:,:,807), nhel, den(392))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,192), A(:,808), n3(:,1597), t3x256(:,:,808), nhel, den(393))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,186), A(:,809), n3(:,1598), t3x256(:,:,809), nhel, den(394))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,187), A(:,810), n3(:,1599), t3x256(:,:,810), nhel, den(395))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,187), A(:,811), n3(:,1600), t3x256(:,:,811), nhel, den(396))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,188), A(:,812), n3(:,1601), t3x256(:,:,812), nhel, den(397))
    call Hcont_QA(nsync, wf8(:,108), wf32(:,63), A(:,813), n3(:,1602), t3x256(:,:,813), nhel, den(399))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,190), A(:,814), n3(:,1603), t3x256(:,:,814), nhel, den(400))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,191), A(:,815), n3(:,1604), t3x256(:,:,815), nhel, den(401))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,191), A(:,816), n3(:,1605), t3x256(:,:,816), nhel, den(402))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,192), A(:,817), n3(:,1606), t3x256(:,:,817), nhel, den(403))
    call Hcont_QA(nsync, wf8(:,106), wf32(:,64), A(:,818), n3(:,1607), t3x256(:,:,818), nhel, den(405))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,186), A(:,819), n3(:,1608), t3x256(:,:,819), nhel, den(406))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,187), A(:,820), n3(:,1609), t3x256(:,:,820), nhel, den(407))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,187), A(:,821), n3(:,1610), t3x256(:,:,821), nhel, den(408))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,188), A(:,822), n3(:,1611), t3x256(:,:,822), nhel, den(409))
    call Hcont_QA(nsync, wf32(:,65), wf8(:,110), A(:,823), n3(:,1612), t3x256(:,:,823), nhel, den(412))
    call Hcont_QA(nsync, wf8(:,110), wf32(:,66), A(:,824), n3(:,1613), t3x256(:,:,824), nhel, den(413))
    call Hcont_QA(nsync, wf8(:,110), wf32(:,67), A(:,825), n3(:,1614), t3x256(:,:,825), nhel, den(414))
    call Hcont_QA(nsync, wf32(:,4), wf8(:,112), A(:,826), n3(:,1615), t3x256(:,:,826), nhel, den(416))
    call Hcont_QA(nsync, wf8(:,111), wf32(:,69), A(:,827), n3(:,1616), t3x256(:,:,827), nhel, den(419))
    call Hcont_QA(nsync, wf8(:,111), wf32(:,71), A(:,828), n3(:,1617), t3x256(:,:,828), nhel, den(421))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,158), A(:,829), n3(:,1618), t3x256(:,:,829), nhel, den(422))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,158), A(:,830), n3(:,1619), t3x256(:,:,830), nhel, den(423))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,160), A(:,831), n3(:,1620), t3x256(:,:,831), nhel, den(422))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,160), A(:,832), n3(:,1621), t3x256(:,:,832), nhel, den(423))
    call Hcont_VV(nsync, wf16(:,23), wf16(:,158), A(:,833), n3(:,1622), t3x256(:,:,833), nhel, den(424))
    call Hcont_VV(nsync, wf16(:,24), wf16(:,158), A(:,834), n3(:,1623), t3x256(:,:,834), nhel, den(425))
    call Hcont_VV(nsync, wf16(:,23), wf16(:,160), A(:,835), n3(:,1624), t3x256(:,:,835), nhel, den(424))
    call Hcont_VV(nsync, wf16(:,24), wf16(:,160), A(:,836), n3(:,1625), t3x256(:,:,836), nhel, den(425))
    call Hcont_QA(nsync, wf32(:,72), wf8(:,114), A(:,837), n3(:,1626), t3x256(:,:,837), nhel, den(428))
    call Hcont_QA(nsync, wf8(:,114), wf32(:,73), A(:,838), n3(:,1627), t3x256(:,:,838), nhel, den(429))
    call Hcont_QA(nsync, wf8(:,114), wf32(:,74), A(:,839), n3(:,1628), t3x256(:,:,839), nhel, den(430))
    call Hcont_QA(nsync, wf32(:,3), wf8(:,116), A(:,840), n3(:,1629), t3x256(:,:,840), nhel, den(432))
    call Hcont_QA(nsync, wf8(:,115), wf32(:,76), A(:,841), n3(:,1630), t3x256(:,:,841), nhel, den(435))
    call Hcont_QA(nsync, wf8(:,115), wf32(:,78), A(:,842), n3(:,1631), t3x256(:,:,842), nhel, den(437))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,166), A(:,843), n3(:,1632), t3x256(:,:,843), nhel, den(438))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,166), A(:,844), n3(:,1633), t3x256(:,:,844), nhel, den(439))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,168), A(:,845), n3(:,1634), t3x256(:,:,845), nhel, den(438))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,168), A(:,846), n3(:,1635), t3x256(:,:,846), nhel, den(439))
    call Hcont_VV(nsync, wf16(:,19), wf16(:,166), A(:,847), n3(:,1636), t3x256(:,:,847), nhel, den(440))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,166), A(:,848), n3(:,1637), t3x256(:,:,848), nhel, den(441))
    call Hcont_VV(nsync, wf16(:,19), wf16(:,168), A(:,849), n3(:,1638), t3x256(:,:,849), nhel, den(440))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,168), A(:,850), n3(:,1639), t3x256(:,:,850), nhel, den(441))
    call Hcont_QA(nsync, wf8(:,117), wf32(:,79), A(:,851), n3(:,1640), t3x256(:,:,851), nhel, den(444))
    call Hcont_QA(nsync, wf8(:,117), wf32(:,80), A(:,852), n3(:,1641), t3x256(:,:,852), nhel, den(446))
    call Hcont_QA(nsync, wf32(:,69), wf8(:,118), A(:,853), n3(:,1642), t3x256(:,:,853), nhel, den(447))
    call Hcont_QA(nsync, wf32(:,71), wf8(:,118), A(:,854), n3(:,1643), t3x256(:,:,854), nhel, den(448))
    call Hcont_QA(nsync, wf8(:,119), wf32(:,81), A(:,855), n3(:,1644), t3x256(:,:,855), nhel, den(451))
    call Hcont_QA(nsync, wf8(:,119), wf32(:,82), A(:,856), n3(:,1645), t3x256(:,:,856), nhel, den(453))
    call Hcont_QA(nsync, wf32(:,76), wf8(:,120), A(:,857), n3(:,1646), t3x256(:,:,857), nhel, den(454))
    call Hcont_QA(nsync, wf32(:,78), wf8(:,120), A(:,858), n3(:,1647), t3x256(:,:,858), nhel, den(455))
    call Hcont_QA(nsync, wf8(:,117), wf32(:,83), A(:,859), n3(:,1648), t3x256(:,:,859), nhel, den(457))
    call Hcont_QA(nsync, wf8(:,119), wf32(:,84), A(:,860), n3(:,1649), t3x256(:,:,860), nhel, den(459))
    call Hcont_VV(nsync, wf16(:,19), wf16(:,193), A(:,861), n3(:,1650), t3x256(:,:,861), nhel, den(460))
    call Hcont_VV(nsync, wf16(:,19), wf16(:,194), A(:,862), n3(:,1651), t3x256(:,:,862), nhel, den(461))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,194), A(:,863), n3(:,1652), t3x256(:,:,863), nhel, den(462))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,195), A(:,864), n3(:,1653), t3x256(:,:,864), nhel, den(463))
    call Hcont_VV(nsync, wf16(:,23), wf16(:,196), A(:,865), n3(:,1654), t3x256(:,:,865), nhel, den(464))
    call Hcont_VV(nsync, wf16(:,23), wf16(:,197), A(:,866), n3(:,1655), t3x256(:,:,866), nhel, den(465))
    call Hcont_VV(nsync, wf16(:,24), wf16(:,197), A(:,867), n3(:,1656), t3x256(:,:,867), nhel, den(466))
    call Hcont_VV(nsync, wf16(:,24), wf16(:,198), A(:,868), n3(:,1657), t3x256(:,:,868), nhel, den(467))
    call Hcont_QA(nsync, wf8(:,12), wf32(:,85), A(:,869), n3(:,1658), t3x256(:,:,869), nhel, den(469))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,182), A(:,870), n3(:,1659), t3x256(:,:,870), nhel, den(470))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,182), A(:,871), n3(:,1660), t3x256(:,:,871), nhel, den(471))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,184), A(:,872), n3(:,1661), t3x256(:,:,872), nhel, den(470))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,184), A(:,873), n3(:,1662), t3x256(:,:,873), nhel, den(471))
    call Hcont_QA(nsync, wf8(:,16), wf32(:,86), A(:,874), n3(:,1663), t3x256(:,:,874), nhel, den(473))
    call Hcont_VV(nsync, wf16(:,19), wf16(:,182), A(:,875), n3(:,1664), t3x256(:,:,875), nhel, den(474))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,182), A(:,876), n3(:,1665), t3x256(:,:,876), nhel, den(475))
    call Hcont_VV(nsync, wf16(:,19), wf16(:,184), A(:,877), n3(:,1666), t3x256(:,:,877), nhel, den(474))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,184), A(:,878), n3(:,1667), t3x256(:,:,878), nhel, den(475))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,178), A(:,879), n3(:,1668), t3x256(:,:,879), nhel, den(476))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,178), A(:,880), n3(:,1669), t3x256(:,:,880), nhel, den(477))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,180), A(:,881), n3(:,1670), t3x256(:,:,881), nhel, den(476))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,180), A(:,882), n3(:,1671), t3x256(:,:,882), nhel, den(477))
    call Hcont_VV(nsync, wf16(:,23), wf16(:,178), A(:,883), n3(:,1672), t3x256(:,:,883), nhel, den(478))
    call Hcont_VV(nsync, wf16(:,24), wf16(:,178), A(:,884), n3(:,1673), t3x256(:,:,884), nhel, den(479))
    call Hcont_VV(nsync, wf16(:,23), wf16(:,180), A(:,885), n3(:,1674), t3x256(:,:,885), nhel, den(478))
    call Hcont_VV(nsync, wf16(:,24), wf16(:,180), A(:,886), n3(:,1675), t3x256(:,:,886), nhel, den(479))
    call Hcont_QA(nsync, wf8(:,120), wf32(:,87), A(:,887), n3(:,1676), t3x256(:,:,887), nhel, den(481))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,193), A(:,888), n3(:,1677), t3x256(:,:,888), nhel, den(482))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,194), A(:,889), n3(:,1678), t3x256(:,:,889), nhel, den(483))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,194), A(:,890), n3(:,1679), t3x256(:,:,890), nhel, den(484))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,195), A(:,891), n3(:,1680), t3x256(:,:,891), nhel, den(485))
    call Hcont_QA(nsync, wf8(:,118), wf32(:,88), A(:,892), n3(:,1681), t3x256(:,:,892), nhel, den(487))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,196), A(:,893), n3(:,1682), t3x256(:,:,893), nhel, den(488))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,197), A(:,894), n3(:,1683), t3x256(:,:,894), nhel, den(489))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,197), A(:,895), n3(:,1684), t3x256(:,:,895), nhel, den(490))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,198), A(:,896), n3(:,1685), t3x256(:,:,896), nhel, den(491))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,199), A(:,897), n3(:,1686), t3x256(:,:,897), nhel, den(492))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,200), A(:,898), n3(:,1687), t3x256(:,:,898), nhel, den(493))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,199), A(:,899), n3(:,1688), t3x256(:,:,899), nhel, den(494))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,200), A(:,900), n3(:,1689), t3x256(:,:,900), nhel, den(495))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,201), A(:,901), n3(:,1690), t3x256(:,:,901), nhel, den(496))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,202), A(:,902), n3(:,1691), t3x256(:,:,902), nhel, den(497))
    call Hcont_QA(nsync, wf8(:,98), wf32(:,89), A(:,903), n3(:,1692), t3x256(:,:,903), nhel, den(498))
    call Hcont_QA(nsync, wf8(:,98), wf32(:,90), A(:,904), n3(:,1693), t3x256(:,:,904), nhel, den(499))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,203), A(:,905), n3(:,1694), t3x256(:,:,905), nhel, den(500))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,204), A(:,906), n3(:,1695), t3x256(:,:,906), nhel, den(501))
    call Hcont_QA(nsync, wf8(:,112), wf32(:,91), A(:,907), n3(:,1696), t3x256(:,:,907), nhel, den(502))
    call Hcont_QA(nsync, wf8(:,112), wf32(:,92), A(:,908), n3(:,1697), t3x256(:,:,908), nhel, den(503))
    call Hcont_QA(nsync, wf8(:,100), wf32(:,93), A(:,909), n3(:,1698), t3x256(:,:,909), nhel, den(504))
    call Hcont_QA(nsync, wf8(:,100), wf32(:,94), A(:,910), n3(:,1699), t3x256(:,:,910), nhel, den(505))
    call Hcont_QA(nsync, wf8(:,100), wf32(:,95), A(:,911), n3(:,1700), t3x256(:,:,911), nhel, den(506))
    call Hcont_QA(nsync, wf8(:,100), wf32(:,96), A(:,912), n3(:,1701), t3x256(:,:,912), nhel, den(507))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,205), A(:,913), n3(:,1702), t3x256(:,:,913), nhel, den(508))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,206), A(:,914), n3(:,1703), t3x256(:,:,914), nhel, den(509))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,205), A(:,915), n3(:,1704), t3x256(:,:,915), nhel, den(510))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,206), A(:,916), n3(:,1705), t3x256(:,:,916), nhel, den(511))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,207), A(:,917), n3(:,1706), t3x256(:,:,917), nhel, den(512))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,208), A(:,918), n3(:,1707), t3x256(:,:,918), nhel, den(513))
    call Hcont_QA(nsync, wf8(:,102), wf32(:,97), A(:,919), n3(:,1708), t3x256(:,:,919), nhel, den(514))
    call Hcont_QA(nsync, wf8(:,102), wf32(:,98), A(:,920), n3(:,1709), t3x256(:,:,920), nhel, den(515))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,209), A(:,921), n3(:,1710), t3x256(:,:,921), nhel, den(516))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,210), A(:,922), n3(:,1711), t3x256(:,:,922), nhel, den(517))
    call Hcont_QA(nsync, wf8(:,116), wf32(:,99), A(:,923), n3(:,1712), t3x256(:,:,923), nhel, den(518))
    call Hcont_QA(nsync, wf8(:,116), wf32(:,100), A(:,924), n3(:,1713), t3x256(:,:,924), nhel, den(519))
    call Hcont_QA(nsync, wf8(:,104), wf32(:,101), A(:,925), n3(:,1714), t3x256(:,:,925), nhel, den(520))
    call Hcont_QA(nsync, wf8(:,104), wf32(:,102), A(:,926), n3(:,1715), t3x256(:,:,926), nhel, den(521))
    call Hcont_QA(nsync, wf8(:,104), wf32(:,103), A(:,927), n3(:,1716), t3x256(:,:,927), nhel, den(522))
    call Hcont_QA(nsync, wf8(:,104), wf32(:,104), A(:,928), n3(:,1717), t3x256(:,:,928), nhel, den(523))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,211), A(:,929), n3(:,1718), t3x256(:,:,929), nhel, den(524))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,212), A(:,930), n3(:,1719), t3x256(:,:,930), nhel, den(525))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,213), A(:,931), n3(:,1720), t3x256(:,:,931), nhel, den(526))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,214), A(:,932), n3(:,1721), t3x256(:,:,932), nhel, den(527))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,215), A(:,933), n3(:,1722), t3x256(:,:,933), nhel, den(528))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,216), A(:,934), n3(:,1723), t3x256(:,:,934), nhel, den(529))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,217), A(:,935), n3(:,1724), t3x256(:,:,935), nhel, den(530))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,218), A(:,936), n3(:,1725), t3x256(:,:,936), nhel, den(531))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,219), A(:,937), n3(:,1726), t3x256(:,:,937), nhel, den(533))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,220), A(:,938), n3(:,1727), t3x256(:,:,938), nhel, den(534))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,219), A(:,939), n3(:,1728), t3x256(:,:,939), nhel, den(535))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,220), A(:,940), n3(:,1729), t3x256(:,:,940), nhel, den(536))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,221), A(:,941), n3(:,1730), t3x256(:,:,941), nhel, den(538))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,222), A(:,942), n3(:,1731), t3x256(:,:,942), nhel, den(539))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,223), A(:,943), n3(:,1732), t3x256(:,:,943), nhel, den(541))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,224), A(:,944), n3(:,1733), t3x256(:,:,944), nhel, den(542))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,225), A(:,945), n3(:,1734), t3x256(:,:,945), nhel, den(544))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,226), A(:,946), n3(:,1735), t3x256(:,:,946), nhel, den(545))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,225), A(:,947), n3(:,1736), t3x256(:,:,947), nhel, den(546))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,226), A(:,948), n3(:,1737), t3x256(:,:,948), nhel, den(547))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,221), A(:,949), n3(:,1738), t3x256(:,:,949), nhel, den(548))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,222), A(:,950), n3(:,1739), t3x256(:,:,950), nhel, den(549))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,223), A(:,951), n3(:,1740), t3x256(:,:,951), nhel, den(550))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,224), A(:,952), n3(:,1741), t3x256(:,:,952), nhel, den(551))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,215), A(:,953), n3(:,1742), t3x256(:,:,953), nhel, den(552))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,216), A(:,954), n3(:,1743), t3x256(:,:,954), nhel, den(553))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,217), A(:,955), n3(:,1744), t3x256(:,:,955), nhel, den(554))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,218), A(:,956), n3(:,1745), t3x256(:,:,956), nhel, den(555))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,211), A(:,957), n3(:,1746), t3x256(:,:,957), nhel, den(556))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,212), A(:,958), n3(:,1747), t3x256(:,:,958), nhel, den(557))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,213), A(:,959), n3(:,1748), t3x256(:,:,959), nhel, den(558))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,214), A(:,960), n3(:,1749), t3x256(:,:,960), nhel, den(559))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,227), A(:,961), n3(:,1750), t3x256(:,:,961), nhel, den(560))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,228), A(:,962), n3(:,1751), t3x256(:,:,962), nhel, den(561))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,229), A(:,963), n3(:,1752), t3x256(:,:,963), nhel, den(562))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,230), A(:,964), n3(:,1753), t3x256(:,:,964), nhel, den(563))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,231), A(:,965), n3(:,1754), t3x256(:,:,965), nhel, den(564))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,232), A(:,966), n3(:,1755), t3x256(:,:,966), nhel, den(565))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,233), A(:,967), n3(:,1756), t3x256(:,:,967), nhel, den(566))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,234), A(:,968), n3(:,1757), t3x256(:,:,968), nhel, den(567))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,235), A(:,969), n3(:,1758), t3x256(:,:,969), nhel, den(569))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,236), A(:,970), n3(:,1759), t3x256(:,:,970), nhel, den(570))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,237), A(:,971), n3(:,1760), t3x256(:,:,971), nhel, den(572))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,238), A(:,972), n3(:,1761), t3x256(:,:,972), nhel, den(573))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,239), A(:,973), n3(:,1762), t3x256(:,:,973), nhel, den(575))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,240), A(:,974), n3(:,1763), t3x256(:,:,974), nhel, den(576))
    call Hcont_VV(nsync, wf16(:,23), wf16(:,239), A(:,975), n3(:,1764), t3x256(:,:,975), nhel, den(577))
    call Hcont_VV(nsync, wf16(:,24), wf16(:,240), A(:,976), n3(:,1765), t3x256(:,:,976), nhel, den(578))
    call Hcont_VV(nsync, wf16(:,19), wf16(:,235), A(:,977), n3(:,1766), t3x256(:,:,977), nhel, den(579))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,236), A(:,978), n3(:,1767), t3x256(:,:,978), nhel, den(580))
    call Hcont_VV(nsync, wf16(:,19), wf16(:,237), A(:,979), n3(:,1768), t3x256(:,:,979), nhel, den(581))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,238), A(:,980), n3(:,1769), t3x256(:,:,980), nhel, den(582))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,241), A(:,981), n3(:,1770), t3x256(:,:,981), nhel, den(584))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,242), A(:,982), n3(:,1771), t3x256(:,:,982), nhel, den(585))
    call Hcont_VV(nsync, wf16(:,23), wf16(:,241), A(:,983), n3(:,1772), t3x256(:,:,983), nhel, den(586))
    call Hcont_VV(nsync, wf16(:,24), wf16(:,242), A(:,984), n3(:,1773), t3x256(:,:,984), nhel, den(587))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,243), A(:,985), n3(:,1774), t3x256(:,:,985), nhel, den(588))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,244), A(:,986), n3(:,1775), t3x256(:,:,986), nhel, den(589))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,245), A(:,987), n3(:,1776), t3x256(:,:,987), nhel, den(590))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,246), A(:,988), n3(:,1777), t3x256(:,:,988), nhel, den(591))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,247), A(:,989), n3(:,1778), t3x256(:,:,989), nhel, den(592))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,248), A(:,990), n3(:,1779), t3x256(:,:,990), nhel, den(593))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,249), A(:,991), n3(:,1780), t3x256(:,:,991), nhel, den(594))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,250), A(:,992), n3(:,1781), t3x256(:,:,992), nhel, den(595))
    call Hcont_VV(nsync, wf16(:,25), wf16(:,158), A(:,993), n3(:,1782), t3x256(:,:,993), nhel, den(596))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,158), A(:,994), n3(:,1783), t3x256(:,:,994), nhel, den(597))
    call Hcont_VV(nsync, wf16(:,25), wf16(:,160), A(:,995), n3(:,1784), t3x256(:,:,995), nhel, den(596))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,160), A(:,996), n3(:,1785), t3x256(:,:,996), nhel, den(597))
    call Hcont_VV(nsync, wf16(:,27), wf16(:,154), A(:,997), n3(:,1786), t3x256(:,:,997), nhel, den(598))
    call Hcont_VV(nsync, wf16(:,28), wf16(:,154), A(:,998), n3(:,1787), t3x256(:,:,998), nhel, den(599))
    call Hcont_VV(nsync, wf16(:,27), wf16(:,156), A(:,999), n3(:,1788), t3x256(:,:,999), nhel, den(598))
    call Hcont_VV(nsync, wf16(:,28), wf16(:,156), A(:,1000), n3(:,1789), t3x256(:,:,1000), nhel, den(599))
    call Hcont_VV(nsync, wf16(:,29), wf16(:,158), A(:,1001), n3(:,1790), t3x256(:,:,1001), nhel, den(600))
    call Hcont_VV(nsync, wf16(:,29), wf16(:,160), A(:,1002), n3(:,1791), t3x256(:,:,1002), nhel, den(600))
    call Hcont_VV(nsync, wf16(:,30), wf16(:,154), A(:,1003), n3(:,1792), t3x256(:,:,1003), nhel, den(601))
    call Hcont_VV(nsync, wf16(:,30), wf16(:,156), A(:,1004), n3(:,1793), t3x256(:,:,1004), nhel, den(601))
    call Hcont_QA(nsync, wf8(:,24), wf32(:,105), A(:,1005), n3(:,1794), t3x256(:,:,1005), nhel, den(603))
    call Hcont_QA(nsync, wf8(:,22), wf32(:,106), A(:,1006), n3(:,1795), t3x256(:,:,1006), nhel, den(605))
    call Hcont_QA(nsync, wf8(:,129), wf32(:,108), A(:,1007), n3(:,1796), t3x256(:,:,1007), nhel, den(608))
    call Hcont_QA(nsync, wf8(:,129), wf32(:,110), A(:,1008), n3(:,1797), t3x256(:,:,1008), nhel, den(610))
    call Hcont_QA(nsync, wf8(:,130), wf32(:,112), A(:,1009), n3(:,1798), t3x256(:,:,1009), nhel, den(613))
    call Hcont_QA(nsync, wf8(:,130), wf32(:,114), A(:,1010), n3(:,1799), t3x256(:,:,1010), nhel, den(615))
    call Hcont_QA(nsync, wf8(:,131), wf32(:,116), A(:,1011), n3(:,1800), t3x256(:,:,1011), nhel, den(618))
    call Hcont_QA(nsync, wf8(:,132), wf32(:,118), A(:,1012), n3(:,1801), t3x256(:,:,1012), nhel, den(621))
    call Hcont_QA(nsync, wf32(:,107), wf8(:,134), A(:,1013), n3(:,1802), t3x256(:,:,1013), nhel, den(623))
    call Hcont_QA(nsync, wf32(:,109), wf8(:,134), A(:,1014), n3(:,1803), t3x256(:,:,1014), nhel, den(624))
    call Hcont_QA(nsync, wf8(:,134), wf32(:,119), A(:,1015), n3(:,1804), t3x256(:,:,1015), nhel, den(626))
    call Hcont_QA(nsync, wf32(:,111), wf8(:,136), A(:,1016), n3(:,1805), t3x256(:,:,1016), nhel, den(628))
    call Hcont_QA(nsync, wf32(:,113), wf8(:,136), A(:,1017), n3(:,1806), t3x256(:,:,1017), nhel, den(629))
    call Hcont_QA(nsync, wf8(:,136), wf32(:,120), A(:,1018), n3(:,1807), t3x256(:,:,1018), nhel, den(631))
    call Hcont_VV(nsync, wf16(:,29), wf16(:,197), A(:,1019), n3(:,1808), t3x256(:,:,1019), nhel, den(632))
    call Hcont_VV(nsync, wf16(:,29), wf16(:,198), A(:,1020), n3(:,1809), t3x256(:,:,1020), nhel, den(633))
    call Hcont_VV(nsync, wf16(:,30), wf16(:,187), A(:,1021), n3(:,1810), t3x256(:,:,1021), nhel, den(634))
    call Hcont_VV(nsync, wf16(:,30), wf16(:,188), A(:,1022), n3(:,1811), t3x256(:,:,1022), nhel, den(635))
    call Hcont_QA(nsync, wf8(:,129), wf32(:,121), A(:,1023), n3(:,1812), t3x256(:,:,1023), nhel, den(637))
    call Hcont_QA(nsync, wf8(:,130), wf32(:,122), A(:,1024), n3(:,1813), t3x256(:,:,1024), nhel, den(639))
    call Hcont_QA(nsync, wf32(:,116), wf8(:,137), A(:,1025), n3(:,1814), t3x256(:,:,1025), nhel, den(640))
    call Hcont_QA(nsync, wf32(:,6), wf8(:,138), A(:,1026), n3(:,1815), t3x256(:,:,1026), nhel, den(642))
    call Hcont_QA(nsync, wf32(:,118), wf8(:,139), A(:,1027), n3(:,1816), t3x256(:,:,1027), nhel, den(643))
    call Hcont_QA(nsync, wf32(:,5), wf8(:,140), A(:,1028), n3(:,1817), t3x256(:,:,1028), nhel, den(645))
    call Hcont_VV(nsync, wf16(:,25), wf16(:,196), A(:,1029), n3(:,1818), t3x256(:,:,1029), nhel, den(646))
    call Hcont_VV(nsync, wf16(:,25), wf16(:,197), A(:,1030), n3(:,1819), t3x256(:,:,1030), nhel, den(647))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,197), A(:,1031), n3(:,1820), t3x256(:,:,1031), nhel, den(648))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,198), A(:,1032), n3(:,1821), t3x256(:,:,1032), nhel, den(649))
    call Hcont_VV(nsync, wf16(:,27), wf16(:,186), A(:,1033), n3(:,1822), t3x256(:,:,1033), nhel, den(650))
    call Hcont_VV(nsync, wf16(:,27), wf16(:,187), A(:,1034), n3(:,1823), t3x256(:,:,1034), nhel, den(651))
    call Hcont_VV(nsync, wf16(:,28), wf16(:,187), A(:,1035), n3(:,1824), t3x256(:,:,1035), nhel, den(652))
    call Hcont_VV(nsync, wf16(:,28), wf16(:,188), A(:,1036), n3(:,1825), t3x256(:,:,1036), nhel, den(653))
    call Hcont_QA(nsync, wf8(:,132), wf32(:,123), A(:,1037), n3(:,1826), t3x256(:,:,1037), nhel, den(655))
    call Hcont_QA(nsync, wf8(:,131), wf32(:,124), A(:,1038), n3(:,1827), t3x256(:,:,1038), nhel, den(657))
    call Hcont_VV(nsync, wf16(:,27), wf16(:,170), A(:,1039), n3(:,1828), t3x256(:,:,1039), nhel, den(658))
    call Hcont_VV(nsync, wf16(:,28), wf16(:,170), A(:,1040), n3(:,1829), t3x256(:,:,1040), nhel, den(659))
    call Hcont_VV(nsync, wf16(:,27), wf16(:,172), A(:,1041), n3(:,1830), t3x256(:,:,1041), nhel, den(658))
    call Hcont_VV(nsync, wf16(:,28), wf16(:,172), A(:,1042), n3(:,1831), t3x256(:,:,1042), nhel, den(659))
    call Hcont_VV(nsync, wf16(:,30), wf16(:,170), A(:,1043), n3(:,1832), t3x256(:,:,1043), nhel, den(660))
    call Hcont_VV(nsync, wf16(:,30), wf16(:,172), A(:,1044), n3(:,1833), t3x256(:,:,1044), nhel, den(660))
    call Hcont_VV(nsync, wf16(:,25), wf16(:,178), A(:,1045), n3(:,1834), t3x256(:,:,1045), nhel, den(661))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,178), A(:,1046), n3(:,1835), t3x256(:,:,1046), nhel, den(662))
    call Hcont_VV(nsync, wf16(:,25), wf16(:,180), A(:,1047), n3(:,1836), t3x256(:,:,1047), nhel, den(661))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,180), A(:,1048), n3(:,1837), t3x256(:,:,1048), nhel, den(662))
    call Hcont_VV(nsync, wf16(:,29), wf16(:,178), A(:,1049), n3(:,1838), t3x256(:,:,1049), nhel, den(663))
    call Hcont_VV(nsync, wf16(:,29), wf16(:,180), A(:,1050), n3(:,1839), t3x256(:,:,1050), nhel, den(663))
    call Hcont_QA(nsync, wf8(:,98), wf32(:,125), A(:,1051), n3(:,1840), t3x256(:,:,1051), nhel, den(664))
    call Hcont_QA(nsync, wf8(:,98), wf32(:,126), A(:,1052), n3(:,1841), t3x256(:,:,1052), nhel, den(665))
    call Hcont_QA(nsync, wf8(:,98), wf32(:,127), A(:,1053), n3(:,1842), t3x256(:,:,1053), nhel, den(666))
    call Hcont_QA(nsync, wf8(:,100), wf32(:,128), A(:,1054), n3(:,1843), t3x256(:,:,1054), nhel, den(667))
    call Hcont_QA(nsync, wf8(:,100), wf32(:,129), A(:,1055), n3(:,1844), t3x256(:,:,1055), nhel, den(668))
    call Hcont_QA(nsync, wf8(:,100), wf32(:,130), A(:,1056), n3(:,1845), t3x256(:,:,1056), nhel, den(669))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,251), A(:,1057), n3(:,1846), t3x256(:,:,1057), nhel, den(671))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,252), A(:,1058), n3(:,1847), t3x256(:,:,1058), nhel, den(672))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,253), A(:,1059), n3(:,1848), t3x256(:,:,1059), nhel, den(674))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,251), A(:,1060), n3(:,1849), t3x256(:,:,1060), nhel, den(675))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,252), A(:,1061), n3(:,1850), t3x256(:,:,1061), nhel, den(676))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,253), A(:,1062), n3(:,1851), t3x256(:,:,1062), nhel, den(677))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,254), A(:,1063), n3(:,1852), t3x256(:,:,1063), nhel, den(678))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,255), A(:,1064), n3(:,1853), t3x256(:,:,1064), nhel, den(679))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,254), A(:,1065), n3(:,1854), t3x256(:,:,1065), nhel, den(680))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,255), A(:,1066), n3(:,1855), t3x256(:,:,1066), nhel, den(681))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,256), A(:,1067), n3(:,1856), t3x256(:,:,1067), nhel, den(682))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,257), A(:,1068), n3(:,1857), t3x256(:,:,1068), nhel, den(683))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,256), A(:,1069), n3(:,1858), t3x256(:,:,1069), nhel, den(684))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,257), A(:,1070), n3(:,1859), t3x256(:,:,1070), nhel, den(685))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,258), A(:,1071), n3(:,1860), t3x256(:,:,1071), nhel, den(686))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,258), A(:,1072), n3(:,1861), t3x256(:,:,1072), nhel, den(687))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,259), A(:,1073), n3(:,1862), t3x256(:,:,1073), nhel, den(688))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,260), A(:,1074), n3(:,1863), t3x256(:,:,1074), nhel, den(689))
    call Hcont_VV(nsync, wf16(:,11), wf16(:,261), A(:,1075), n3(:,1864), t3x256(:,:,1075), nhel, den(690))
    call Hcont_VV(nsync, wf16(:,12), wf16(:,262), A(:,1076), n3(:,1865), t3x256(:,:,1076), nhel, den(691))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,259), A(:,1077), n3(:,1866), t3x256(:,:,1077), nhel, den(692))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,260), A(:,1078), n3(:,1867), t3x256(:,:,1078), nhel, den(693))
    call Hcont_VV(nsync, wf16(:,9), wf16(:,261), A(:,1079), n3(:,1868), t3x256(:,:,1079), nhel, den(694))
    call Hcont_VV(nsync, wf16(:,10), wf16(:,262), A(:,1080), n3(:,1869), t3x256(:,:,1080), nhel, den(695))
    call Hcont_VV(nsync, wf16(:,25), wf16(:,239), A(:,1081), n3(:,1870), t3x256(:,:,1081), nhel, den(696))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,240), A(:,1082), n3(:,1871), t3x256(:,:,1082), nhel, den(697))
    call Hcont_VV(nsync, wf16(:,29), wf16(:,240), A(:,1083), n3(:,1872), t3x256(:,:,1083), nhel, den(698))
    call Hcont_VV(nsync, wf16(:,25), wf16(:,241), A(:,1084), n3(:,1873), t3x256(:,:,1084), nhel, den(699))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,242), A(:,1085), n3(:,1874), t3x256(:,:,1085), nhel, den(700))
    call Hcont_VV(nsync, wf16(:,29), wf16(:,242), A(:,1086), n3(:,1875), t3x256(:,:,1086), nhel, den(701))
    call Hcont_QA(nsync, wf8(:,110), wf32(:,131), A(:,1087), n3(:,1876), t3x256(:,:,1087), nhel, den(702))
    call Hcont_QA(nsync, wf8(:,110), wf32(:,132), A(:,1088), n3(:,1877), t3x256(:,:,1088), nhel, den(703))
    call Hcont_QA(nsync, wf8(:,110), wf32(:,133), A(:,1089), n3(:,1878), t3x256(:,:,1089), nhel, den(704))
    call Hcont_QA(nsync, wf8(:,112), wf32(:,134), A(:,1090), n3(:,1879), t3x256(:,:,1090), nhel, den(705))
    call Hcont_QA(nsync, wf8(:,112), wf32(:,135), A(:,1091), n3(:,1880), t3x256(:,:,1091), nhel, den(706))
    call Hcont_QA(nsync, wf8(:,112), wf32(:,136), A(:,1092), n3(:,1881), t3x256(:,:,1092), nhel, den(707))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,263), A(:,1093), n3(:,1882), t3x256(:,:,1093), nhel, den(709))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,264), A(:,1094), n3(:,1883), t3x256(:,:,1094), nhel, den(710))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,265), A(:,1095), n3(:,1884), t3x256(:,:,1095), nhel, den(712))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,265), A(:,1096), n3(:,1885), t3x256(:,:,1096), nhel, den(713))
    call Hcont_VV(nsync, wf16(:,19), wf16(:,263), A(:,1097), n3(:,1886), t3x256(:,:,1097), nhel, den(714))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,264), A(:,1098), n3(:,1887), t3x256(:,:,1098), nhel, den(715))
    call Hcont_VV(nsync, wf16(:,19), wf16(:,266), A(:,1099), n3(:,1888), t3x256(:,:,1099), nhel, den(716))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,267), A(:,1100), n3(:,1889), t3x256(:,:,1100), nhel, den(717))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,268), A(:,1101), n3(:,1890), t3x256(:,:,1101), nhel, den(718))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,269), A(:,1102), n3(:,1891), t3x256(:,:,1102), nhel, den(719))
    call Hcont_VV(nsync, wf16(:,19), wf16(:,268), A(:,1103), n3(:,1892), t3x256(:,:,1103), nhel, den(720))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,269), A(:,1104), n3(:,1893), t3x256(:,:,1104), nhel, den(721))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,266), A(:,1105), n3(:,1894), t3x256(:,:,1105), nhel, den(722))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,267), A(:,1106), n3(:,1895), t3x256(:,:,1106), nhel, den(723))
    call Hcont_VV(nsync, wf16(:,19), wf16(:,270), A(:,1107), n3(:,1896), t3x256(:,:,1107), nhel, den(724))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,271), A(:,1108), n3(:,1897), t3x256(:,:,1108), nhel, den(725))
    call Hcont_VV(nsync, wf16(:,19), wf16(:,272), A(:,1109), n3(:,1898), t3x256(:,:,1109), nhel, den(726))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,273), A(:,1110), n3(:,1899), t3x256(:,:,1110), nhel, den(727))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,274), A(:,1111), n3(:,1900), t3x256(:,:,1111), nhel, den(728))
    call Hcont_VV(nsync, wf16(:,20), wf16(:,274), A(:,1112), n3(:,1901), t3x256(:,:,1112), nhel, den(729))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,270), A(:,1113), n3(:,1902), t3x256(:,:,1113), nhel, den(730))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,271), A(:,1114), n3(:,1903), t3x256(:,:,1114), nhel, den(731))
    call Hcont_VV(nsync, wf16(:,17), wf16(:,272), A(:,1115), n3(:,1904), t3x256(:,:,1115), nhel, den(732))
    call Hcont_VV(nsync, wf16(:,18), wf16(:,273), A(:,1116), n3(:,1905), t3x256(:,:,1116), nhel, den(733))
    call Hcont_VV(nsync, wf16(:,27), wf16(:,219), A(:,1117), n3(:,1906), t3x256(:,:,1117), nhel, den(734))
    call Hcont_VV(nsync, wf16(:,28), wf16(:,220), A(:,1118), n3(:,1907), t3x256(:,:,1118), nhel, den(735))
    call Hcont_VV(nsync, wf16(:,30), wf16(:,220), A(:,1119), n3(:,1908), t3x256(:,:,1119), nhel, den(736))
    call Hcont_VV(nsync, wf16(:,30), wf16(:,226), A(:,1120), n3(:,1909), t3x256(:,:,1120), nhel, den(737))
    call Hcont_VV(nsync, wf16(:,27), wf16(:,225), A(:,1121), n3(:,1910), t3x256(:,:,1121), nhel, den(738))
    call Hcont_VV(nsync, wf16(:,28), wf16(:,226), A(:,1122), n3(:,1911), t3x256(:,:,1122), nhel, den(739))
    call Hcont_QA(nsync, wf8(:,145), wf32(:,138), A(:,1123), n3(:,1912), t3x256(:,:,1123), nhel, den(742))
    call Hcont_QA(nsync, wf8(:,145), wf32(:,140), A(:,1124), n3(:,1913), t3x256(:,:,1124), nhel, den(744))
    call Hcont_QA(nsync, wf8(:,146), wf32(:,142), A(:,1125), n3(:,1914), t3x256(:,:,1125), nhel, den(747))
    call Hcont_QA(nsync, wf8(:,146), wf32(:,144), A(:,1126), n3(:,1915), t3x256(:,:,1126), nhel, den(749))
    call Hcont_QA(nsync, wf8(:,147), wf32(:,146), A(:,1127), n3(:,1916), t3x256(:,:,1127), nhel, den(752))
    call Hcont_QA(nsync, wf8(:,148), wf32(:,148), A(:,1128), n3(:,1917), t3x256(:,:,1128), nhel, den(755))
    call Hcont_QA(nsync, wf32(:,137), wf8(:,150), A(:,1129), n3(:,1918), t3x256(:,:,1129), nhel, den(757))
    call Hcont_QA(nsync, wf32(:,139), wf8(:,150), A(:,1130), n3(:,1919), t3x256(:,:,1130), nhel, den(758))
    call Hcont_QA(nsync, wf8(:,150), wf32(:,149), A(:,1131), n3(:,1920), t3x256(:,:,1131), nhel, den(760))
    call Hcont_QA(nsync, wf32(:,141), wf8(:,152), A(:,1132), n3(:,1921), t3x256(:,:,1132), nhel, den(762))
    call Hcont_QA(nsync, wf32(:,143), wf8(:,152), A(:,1133), n3(:,1922), t3x256(:,:,1133), nhel, den(763))
    call Hcont_QA(nsync, wf8(:,152), wf32(:,150), A(:,1134), n3(:,1923), t3x256(:,:,1134), nhel, den(765))
    call Hcont_VV(nsync, wf16(:,35), wf16(:,194), A(:,1135), n3(:,1924), t3x256(:,:,1135), nhel, den(766))
    call Hcont_VV(nsync, wf16(:,35), wf16(:,195), A(:,1136), n3(:,1925), t3x256(:,:,1136), nhel, den(767))
    call Hcont_VV(nsync, wf16(:,36), wf16(:,191), A(:,1137), n3(:,1926), t3x256(:,:,1137), nhel, den(768))
    call Hcont_VV(nsync, wf16(:,36), wf16(:,192), A(:,1138), n3(:,1927), t3x256(:,:,1138), nhel, den(769))
    call Hcont_QA(nsync, wf8(:,145), wf32(:,151), A(:,1139), n3(:,1928), t3x256(:,:,1139), nhel, den(771))
    call Hcont_QA(nsync, wf8(:,146), wf32(:,152), A(:,1140), n3(:,1929), t3x256(:,:,1140), nhel, den(773))
    call Hcont_VV(nsync, wf16(:,31), wf16(:,166), A(:,1141), n3(:,1930), t3x256(:,:,1141), nhel, den(774))
    call Hcont_VV(nsync, wf16(:,32), wf16(:,166), A(:,1142), n3(:,1931), t3x256(:,:,1142), nhel, den(775))
    call Hcont_VV(nsync, wf16(:,31), wf16(:,168), A(:,1143), n3(:,1932), t3x256(:,:,1143), nhel, den(774))
    call Hcont_VV(nsync, wf16(:,32), wf16(:,168), A(:,1144), n3(:,1933), t3x256(:,:,1144), nhel, den(775))
    call Hcont_VV(nsync, wf16(:,33), wf16(:,162), A(:,1145), n3(:,1934), t3x256(:,:,1145), nhel, den(776))
    call Hcont_VV(nsync, wf16(:,34), wf16(:,162), A(:,1146), n3(:,1935), t3x256(:,:,1146), nhel, den(777))
    call Hcont_VV(nsync, wf16(:,33), wf16(:,164), A(:,1147), n3(:,1936), t3x256(:,:,1147), nhel, den(776))
    call Hcont_VV(nsync, wf16(:,34), wf16(:,164), A(:,1148), n3(:,1937), t3x256(:,:,1148), nhel, den(777))
    call Hcont_VV(nsync, wf16(:,35), wf16(:,166), A(:,1149), n3(:,1938), t3x256(:,:,1149), nhel, den(778))
    call Hcont_VV(nsync, wf16(:,35), wf16(:,168), A(:,1150), n3(:,1939), t3x256(:,:,1150), nhel, den(778))
    call Hcont_VV(nsync, wf16(:,36), wf16(:,162), A(:,1151), n3(:,1940), t3x256(:,:,1151), nhel, den(779))
    call Hcont_VV(nsync, wf16(:,36), wf16(:,164), A(:,1152), n3(:,1941), t3x256(:,:,1152), nhel, den(779))
    call Hcont_QA(nsync, wf8(:,32), wf32(:,153), A(:,1153), n3(:,1942), t3x256(:,:,1153), nhel, den(781))
    call Hcont_QA(nsync, wf8(:,30), wf32(:,154), A(:,1154), n3(:,1943), t3x256(:,:,1154), nhel, den(783))
    call Hcont_QA(nsync, wf32(:,146), wf8(:,153), A(:,1155), n3(:,1944), t3x256(:,:,1155), nhel, den(784))
    call Hcont_QA(nsync, wf32(:,8), wf8(:,154), A(:,1156), n3(:,1945), t3x256(:,:,1156), nhel, den(786))
    call Hcont_QA(nsync, wf32(:,148), wf8(:,155), A(:,1157), n3(:,1946), t3x256(:,:,1157), nhel, den(787))
    call Hcont_QA(nsync, wf32(:,7), wf8(:,156), A(:,1158), n3(:,1947), t3x256(:,:,1158), nhel, den(789))
    call Hcont_VV(nsync, wf16(:,31), wf16(:,193), A(:,1159), n3(:,1948), t3x256(:,:,1159), nhel, den(790))
    call Hcont_VV(nsync, wf16(:,31), wf16(:,194), A(:,1160), n3(:,1949), t3x256(:,:,1160), nhel, den(791))
    call Hcont_VV(nsync, wf16(:,32), wf16(:,194), A(:,1161), n3(:,1950), t3x256(:,:,1161), nhel, den(792))
    call Hcont_VV(nsync, wf16(:,32), wf16(:,195), A(:,1162), n3(:,1951), t3x256(:,:,1162), nhel, den(793))
    call Hcont_VV(nsync, wf16(:,33), wf16(:,190), A(:,1163), n3(:,1952), t3x256(:,:,1163), nhel, den(794))
    call Hcont_VV(nsync, wf16(:,33), wf16(:,191), A(:,1164), n3(:,1953), t3x256(:,:,1164), nhel, den(795))
    call Hcont_VV(nsync, wf16(:,34), wf16(:,191), A(:,1165), n3(:,1954), t3x256(:,:,1165), nhel, den(796))
    call Hcont_VV(nsync, wf16(:,34), wf16(:,192), A(:,1166), n3(:,1955), t3x256(:,:,1166), nhel, den(797))
    call Hcont_QA(nsync, wf8(:,148), wf32(:,155), A(:,1167), n3(:,1956), t3x256(:,:,1167), nhel, den(799))
    call Hcont_QA(nsync, wf8(:,147), wf32(:,156), A(:,1168), n3(:,1957), t3x256(:,:,1168), nhel, den(801))
    call Hcont_VV(nsync, wf16(:,33), wf16(:,174), A(:,1169), n3(:,1958), t3x256(:,:,1169), nhel, den(802))
    call Hcont_VV(nsync, wf16(:,34), wf16(:,174), A(:,1170), n3(:,1959), t3x256(:,:,1170), nhel, den(803))
    call Hcont_VV(nsync, wf16(:,33), wf16(:,176), A(:,1171), n3(:,1960), t3x256(:,:,1171), nhel, den(802))
    call Hcont_VV(nsync, wf16(:,34), wf16(:,176), A(:,1172), n3(:,1961), t3x256(:,:,1172), nhel, den(803))
    call Hcont_VV(nsync, wf16(:,36), wf16(:,174), A(:,1173), n3(:,1962), t3x256(:,:,1173), nhel, den(804))
    call Hcont_VV(nsync, wf16(:,36), wf16(:,176), A(:,1174), n3(:,1963), t3x256(:,:,1174), nhel, den(804))
    call Hcont_VV(nsync, wf16(:,31), wf16(:,182), A(:,1175), n3(:,1964), t3x256(:,:,1175), nhel, den(805))
    call Hcont_VV(nsync, wf16(:,32), wf16(:,182), A(:,1176), n3(:,1965), t3x256(:,:,1176), nhel, den(806))
    call Hcont_VV(nsync, wf16(:,31), wf16(:,184), A(:,1177), n3(:,1966), t3x256(:,:,1177), nhel, den(805))
    call Hcont_VV(nsync, wf16(:,32), wf16(:,184), A(:,1178), n3(:,1967), t3x256(:,:,1178), nhel, den(806))
    call Hcont_VV(nsync, wf16(:,35), wf16(:,182), A(:,1179), n3(:,1968), t3x256(:,:,1179), nhel, den(807))
    call Hcont_VV(nsync, wf16(:,35), wf16(:,184), A(:,1180), n3(:,1969), t3x256(:,:,1180), nhel, den(807))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,275), A(:,1181), n3(:,1970), t3x256(:,:,1181), nhel, den(809))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,276), A(:,1182), n3(:,1971), t3x256(:,:,1182), nhel, den(810))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,275), A(:,1183), n3(:,1972), t3x256(:,:,1183), nhel, den(811))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,276), A(:,1184), n3(:,1973), t3x256(:,:,1184), nhel, den(812))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,277), A(:,1185), n3(:,1974), t3x256(:,:,1185), nhel, den(814))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,277), A(:,1186), n3(:,1975), t3x256(:,:,1186), nhel, den(815))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,278), A(:,1187), n3(:,1976), t3x256(:,:,1187), nhel, den(816))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,279), A(:,1188), n3(:,1977), t3x256(:,:,1188), nhel, den(817))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,278), A(:,1189), n3(:,1978), t3x256(:,:,1189), nhel, den(818))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,279), A(:,1190), n3(:,1979), t3x256(:,:,1190), nhel, den(819))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,280), A(:,1191), n3(:,1980), t3x256(:,:,1191), nhel, den(820))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,281), A(:,1192), n3(:,1981), t3x256(:,:,1192), nhel, den(821))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,280), A(:,1193), n3(:,1982), t3x256(:,:,1193), nhel, den(822))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,281), A(:,1194), n3(:,1983), t3x256(:,:,1194), nhel, den(823))
    call Hcont_QA(nsync, wf8(:,102), wf32(:,157), A(:,1195), n3(:,1984), t3x256(:,:,1195), nhel, den(824))
    call Hcont_QA(nsync, wf8(:,102), wf32(:,158), A(:,1196), n3(:,1985), t3x256(:,:,1196), nhel, den(825))
    call Hcont_QA(nsync, wf8(:,102), wf32(:,159), A(:,1197), n3(:,1986), t3x256(:,:,1197), nhel, den(826))
    call Hcont_QA(nsync, wf8(:,104), wf32(:,160), A(:,1198), n3(:,1987), t3x256(:,:,1198), nhel, den(827))
    call Hcont_QA(nsync, wf8(:,104), wf32(:,161), A(:,1199), n3(:,1988), t3x256(:,:,1199), nhel, den(828))
    call Hcont_QA(nsync, wf8(:,104), wf32(:,162), A(:,1200), n3(:,1989), t3x256(:,:,1200), nhel, den(829))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,282), A(:,1201), n3(:,1990), t3x256(:,:,1201), nhel, den(830))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,282), A(:,1202), n3(:,1991), t3x256(:,:,1202), nhel, den(831))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,283), A(:,1203), n3(:,1992), t3x256(:,:,1203), nhel, den(832))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,284), A(:,1204), n3(:,1993), t3x256(:,:,1204), nhel, den(833))
    call Hcont_VV(nsync, wf16(:,15), wf16(:,285), A(:,1205), n3(:,1994), t3x256(:,:,1205), nhel, den(834))
    call Hcont_VV(nsync, wf16(:,16), wf16(:,286), A(:,1206), n3(:,1995), t3x256(:,:,1206), nhel, den(835))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,283), A(:,1207), n3(:,1996), t3x256(:,:,1207), nhel, den(836))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,284), A(:,1208), n3(:,1997), t3x256(:,:,1208), nhel, den(837))
    call Hcont_VV(nsync, wf16(:,13), wf16(:,285), A(:,1209), n3(:,1998), t3x256(:,:,1209), nhel, den(838))
    call Hcont_VV(nsync, wf16(:,14), wf16(:,286), A(:,1210), n3(:,1999), t3x256(:,:,1210), nhel, den(839))
    call Hcont_VV(nsync, wf16(:,31), wf16(:,235), A(:,1211), n3(:,2000), t3x256(:,:,1211), nhel, den(840))
    call Hcont_VV(nsync, wf16(:,32), wf16(:,236), A(:,1212), n3(:,2001), t3x256(:,:,1212), nhel, den(841))
    call Hcont_VV(nsync, wf16(:,31), wf16(:,237), A(:,1213), n3(:,2002), t3x256(:,:,1213), nhel, den(842))
    call Hcont_VV(nsync, wf16(:,32), wf16(:,238), A(:,1214), n3(:,2003), t3x256(:,:,1214), nhel, den(843))
    call Hcont_VV(nsync, wf16(:,35), wf16(:,238), A(:,1215), n3(:,2004), t3x256(:,:,1215), nhel, den(844))
    call Hcont_VV(nsync, wf16(:,35), wf16(:,236), A(:,1216), n3(:,2005), t3x256(:,:,1216), nhel, den(845))
    call Hcont_VV(nsync, wf16(:,24), wf16(:,287), A(:,1217), n3(:,2006), t3x256(:,:,1217), nhel, den(847))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,288), A(:,1218), n3(:,2007), t3x256(:,:,1218), nhel, den(849))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,289), A(:,1219), n3(:,2008), t3x256(:,:,1219), nhel, den(850))
    call Hcont_VV(nsync, wf16(:,23), wf16(:,288), A(:,1220), n3(:,2009), t3x256(:,:,1220), nhel, den(851))
    call Hcont_VV(nsync, wf16(:,24), wf16(:,289), A(:,1221), n3(:,2010), t3x256(:,:,1221), nhel, den(852))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,287), A(:,1222), n3(:,2011), t3x256(:,:,1222), nhel, den(853))
    call Hcont_VV(nsync, wf16(:,23), wf16(:,290), A(:,1223), n3(:,2012), t3x256(:,:,1223), nhel, den(854))
    call Hcont_VV(nsync, wf16(:,24), wf16(:,291), A(:,1224), n3(:,2013), t3x256(:,:,1224), nhel, den(855))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,292), A(:,1225), n3(:,2014), t3x256(:,:,1225), nhel, den(856))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,293), A(:,1226), n3(:,2015), t3x256(:,:,1226), nhel, den(857))
    call Hcont_VV(nsync, wf16(:,23), wf16(:,292), A(:,1227), n3(:,2016), t3x256(:,:,1227), nhel, den(858))
    call Hcont_VV(nsync, wf16(:,24), wf16(:,293), A(:,1228), n3(:,2017), t3x256(:,:,1228), nhel, den(859))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,290), A(:,1229), n3(:,2018), t3x256(:,:,1229), nhel, den(860))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,291), A(:,1230), n3(:,2019), t3x256(:,:,1230), nhel, den(861))
    call Hcont_QA(nsync, wf8(:,114), wf32(:,163), A(:,1231), n3(:,2020), t3x256(:,:,1231), nhel, den(862))
    call Hcont_QA(nsync, wf8(:,114), wf32(:,164), A(:,1232), n3(:,2021), t3x256(:,:,1232), nhel, den(863))
    call Hcont_QA(nsync, wf8(:,114), wf32(:,165), A(:,1233), n3(:,2022), t3x256(:,:,1233), nhel, den(864))
    call Hcont_QA(nsync, wf8(:,116), wf32(:,166), A(:,1234), n3(:,2023), t3x256(:,:,1234), nhel, den(865))
    call Hcont_QA(nsync, wf8(:,116), wf32(:,167), A(:,1235), n3(:,2024), t3x256(:,:,1235), nhel, den(866))
    call Hcont_QA(nsync, wf8(:,116), wf32(:,168), A(:,1236), n3(:,2025), t3x256(:,:,1236), nhel, den(867))
    call Hcont_VV(nsync, wf16(:,23), wf16(:,294), A(:,1237), n3(:,2026), t3x256(:,:,1237), nhel, den(868))
    call Hcont_VV(nsync, wf16(:,24), wf16(:,295), A(:,1238), n3(:,2027), t3x256(:,:,1238), nhel, den(869))
    call Hcont_VV(nsync, wf16(:,23), wf16(:,296), A(:,1239), n3(:,2028), t3x256(:,:,1239), nhel, den(870))
    call Hcont_VV(nsync, wf16(:,24), wf16(:,297), A(:,1240), n3(:,2029), t3x256(:,:,1240), nhel, den(871))
    call Hcont_VV(nsync, wf16(:,24), wf16(:,298), A(:,1241), n3(:,2030), t3x256(:,:,1241), nhel, den(872))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,298), A(:,1242), n3(:,2031), t3x256(:,:,1242), nhel, den(873))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,294), A(:,1243), n3(:,2032), t3x256(:,:,1243), nhel, den(874))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,295), A(:,1244), n3(:,2033), t3x256(:,:,1244), nhel, den(875))
    call Hcont_VV(nsync, wf16(:,21), wf16(:,296), A(:,1245), n3(:,2034), t3x256(:,:,1245), nhel, den(876))
    call Hcont_VV(nsync, wf16(:,22), wf16(:,297), A(:,1246), n3(:,2035), t3x256(:,:,1246), nhel, den(877))
    call Hcont_VV(nsync, wf16(:,36), wf16(:,224), A(:,1247), n3(:,2036), t3x256(:,:,1247), nhel, den(878))
    call Hcont_VV(nsync, wf16(:,33), wf16(:,221), A(:,1248), n3(:,2037), t3x256(:,:,1248), nhel, den(879))
    call Hcont_VV(nsync, wf16(:,34), wf16(:,222), A(:,1249), n3(:,2038), t3x256(:,:,1249), nhel, den(880))
    call Hcont_VV(nsync, wf16(:,33), wf16(:,223), A(:,1250), n3(:,2039), t3x256(:,:,1250), nhel, den(881))
    call Hcont_VV(nsync, wf16(:,34), wf16(:,224), A(:,1251), n3(:,2040), t3x256(:,:,1251), nhel, den(882))
    call Hcont_VV(nsync, wf16(:,36), wf16(:,222), A(:,1252), n3(:,2041), t3x256(:,:,1252), nhel, den(883))
    call Hcont_VV(nsync, wf16(:,30), wf16(:,281), A(:,1253), n3(:,2042), t3x256(:,:,1253), nhel, den(884))
    call Hcont_VV(nsync, wf16(:,29), wf16(:,291), A(:,1254), n3(:,2043), t3x256(:,:,1254), nhel, den(885))
    call Hcont_VV(nsync, wf16(:,30), wf16(:,277), A(:,1255), n3(:,2044), t3x256(:,:,1255), nhel, den(886))
    call Hcont_VV(nsync, wf16(:,29), wf16(:,287), A(:,1256), n3(:,2045), t3x256(:,:,1256), nhel, den(887))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,287), A(:,1257), n3(:,2046), t3x256(:,:,1257), nhel, den(888))
    call Hcont_VV(nsync, wf16(:,28), wf16(:,277), A(:,1258), n3(:,2047), t3x256(:,:,1258), nhel, den(889))
    call Hcont_VV(nsync, wf16(:,30), wf16(:,276), A(:,1259), n3(:,2048), t3x256(:,:,1259), nhel, den(890))
    call Hcont_VV(nsync, wf16(:,27), wf16(:,275), A(:,1260), n3(:,2049), t3x256(:,:,1260), nhel, den(891))
    call Hcont_VV(nsync, wf16(:,28), wf16(:,276), A(:,1261), n3(:,2050), t3x256(:,:,1261), nhel, den(892))
    call Hcont_VV(nsync, wf16(:,29), wf16(:,289), A(:,1262), n3(:,2051), t3x256(:,:,1262), nhel, den(893))
    call Hcont_VV(nsync, wf16(:,25), wf16(:,288), A(:,1263), n3(:,2052), t3x256(:,:,1263), nhel, den(894))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,289), A(:,1264), n3(:,2053), t3x256(:,:,1264), nhel, den(895))
    call Hcont_VV(nsync, wf16(:,25), wf16(:,290), A(:,1265), n3(:,2054), t3x256(:,:,1265), nhel, den(896))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,291), A(:,1266), n3(:,2055), t3x256(:,:,1266), nhel, den(897))
    call Hcont_VV(nsync, wf16(:,27), wf16(:,280), A(:,1267), n3(:,2056), t3x256(:,:,1267), nhel, den(898))
    call Hcont_VV(nsync, wf16(:,28), wf16(:,281), A(:,1268), n3(:,2057), t3x256(:,:,1268), nhel, den(899))
    call Hcont_VV(nsync, wf16(:,30), wf16(:,279), A(:,1269), n3(:,2058), t3x256(:,:,1269), nhel, den(900))
    call Hcont_VV(nsync, wf16(:,27), wf16(:,278), A(:,1270), n3(:,2059), t3x256(:,:,1270), nhel, den(901))
    call Hcont_VV(nsync, wf16(:,28), wf16(:,279), A(:,1271), n3(:,2060), t3x256(:,:,1271), nhel, den(902))
    call Hcont_VV(nsync, wf16(:,29), wf16(:,293), A(:,1272), n3(:,2061), t3x256(:,:,1272), nhel, den(903))
    call Hcont_VV(nsync, wf16(:,25), wf16(:,292), A(:,1273), n3(:,2062), t3x256(:,:,1273), nhel, den(904))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,293), A(:,1274), n3(:,2063), t3x256(:,:,1274), nhel, den(905))
    call Hcont_VV(nsync, wf16(:,31), wf16(:,266), A(:,1275), n3(:,2064), t3x256(:,:,1275), nhel, den(906))
    call Hcont_VV(nsync, wf16(:,32), wf16(:,267), A(:,1276), n3(:,2065), t3x256(:,:,1276), nhel, den(907))
    call Hcont_VV(nsync, wf16(:,33), wf16(:,256), A(:,1277), n3(:,2066), t3x256(:,:,1277), nhel, den(908))
    call Hcont_VV(nsync, wf16(:,34), wf16(:,257), A(:,1278), n3(:,2067), t3x256(:,:,1278), nhel, den(909))
    call Hcont_VV(nsync, wf16(:,35), wf16(:,265), A(:,1279), n3(:,2068), t3x256(:,:,1279), nhel, den(910))
    call Hcont_VV(nsync, wf16(:,36), wf16(:,253), A(:,1280), n3(:,2069), t3x256(:,:,1280), nhel, den(911))
    call Hcont_VV(nsync, wf16(:,36), wf16(:,252), A(:,1281), n3(:,2070), t3x256(:,:,1281), nhel, den(912))
    call Hcont_VV(nsync, wf16(:,35), wf16(:,264), A(:,1282), n3(:,2071), t3x256(:,:,1282), nhel, den(913))
    call Hcont_VV(nsync, wf16(:,32), wf16(:,265), A(:,1283), n3(:,2072), t3x256(:,:,1283), nhel, den(914))
    call Hcont_VV(nsync, wf16(:,31), wf16(:,263), A(:,1284), n3(:,2073), t3x256(:,:,1284), nhel, den(915))
    call Hcont_VV(nsync, wf16(:,32), wf16(:,264), A(:,1285), n3(:,2074), t3x256(:,:,1285), nhel, den(916))
    call Hcont_VV(nsync, wf16(:,34), wf16(:,253), A(:,1286), n3(:,2075), t3x256(:,:,1286), nhel, den(917))
    call Hcont_VV(nsync, wf16(:,33), wf16(:,251), A(:,1287), n3(:,2076), t3x256(:,:,1287), nhel, den(918))
    call Hcont_VV(nsync, wf16(:,34), wf16(:,252), A(:,1288), n3(:,2077), t3x256(:,:,1288), nhel, den(919))
    call Hcont_QA(nsync, wf8(:,134), wf32(:,169), A(:,1289), n3(:,2078), t3x256(:,:,1289), nhel, den(920))
    call Hcont_VV(nsync, wf16(:,33), wf16(:,254), A(:,1290), n3(:,2079), t3x256(:,:,1290), nhel, den(921))
    call Hcont_VV(nsync, wf16(:,34), wf16(:,255), A(:,1291), n3(:,2080), t3x256(:,:,1291), nhel, den(922))
    call Hcont_QA(nsync, wf8(:,136), wf32(:,170), A(:,1292), n3(:,2081), t3x256(:,:,1292), nhel, den(923))
    call Hcont_VV(nsync, wf16(:,31), wf16(:,268), A(:,1293), n3(:,2082), t3x256(:,:,1293), nhel, den(924))
    call Hcont_VV(nsync, wf16(:,32), wf16(:,269), A(:,1294), n3(:,2083), t3x256(:,:,1294), nhel, den(925))
    call Hcont_VV(nsync, wf16(:,27), wf16(:,283), A(:,1295), n3(:,2084), t3x256(:,:,1295), nhel, den(926))
    call Hcont_VV(nsync, wf16(:,28), wf16(:,284), A(:,1296), n3(:,2085), t3x256(:,:,1296), nhel, den(927))
    call Hcont_VV(nsync, wf16(:,27), wf16(:,285), A(:,1297), n3(:,2086), t3x256(:,:,1297), nhel, den(928))
    call Hcont_VV(nsync, wf16(:,28), wf16(:,286), A(:,1298), n3(:,2087), t3x256(:,:,1298), nhel, den(929))
    call Hcont_VV(nsync, wf16(:,25), wf16(:,294), A(:,1299), n3(:,2088), t3x256(:,:,1299), nhel, den(930))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,295), A(:,1300), n3(:,2089), t3x256(:,:,1300), nhel, den(931))
    call Hcont_VV(nsync, wf16(:,25), wf16(:,296), A(:,1301), n3(:,2090), t3x256(:,:,1301), nhel, den(932))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,297), A(:,1302), n3(:,2091), t3x256(:,:,1302), nhel, den(933))
    call Hcont_QA(nsync, wf8(:,154), wf32(:,171), A(:,1303), n3(:,2092), t3x256(:,:,1303), nhel, den(934))
    call Hcont_VV(nsync, wf16(:,28), wf16(:,282), A(:,1304), n3(:,2093), t3x256(:,:,1304), nhel, den(935))
    call Hcont_QA(nsync, wf8(:,156), wf32(:,172), A(:,1305), n3(:,2094), t3x256(:,:,1305), nhel, den(936))
    call Hcont_VV(nsync, wf16(:,26), wf16(:,298), A(:,1306), n3(:,2095), t3x256(:,:,1306), nhel, den(937))
    call Hcont_QA(nsync, wf8(:,138), wf32(:,173), A(:,1307), n3(:,2096), t3x256(:,:,1307), nhel, den(938))
    call Hcont_QA(nsync, wf8(:,138), wf32(:,174), A(:,1308), n3(:,2097), t3x256(:,:,1308), nhel, den(939))
    call Hcont_QA(nsync, wf8(:,140), wf32(:,175), A(:,1309), n3(:,2098), t3x256(:,:,1309), nhel, den(940))
    call Hcont_QA(nsync, wf8(:,140), wf32(:,176), A(:,1310), n3(:,2099), t3x256(:,:,1310), nhel, den(941))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(1), M2(1) ! M1helarray(1,nhel)
  integer :: empty(0), i

  M1(1)%j = (A(j,8)%j+A(j,11)%j+A(j,18)%j+A(j,21)%j+A(j,50)%j+A(j,51)%j+A(j,70)%j+A(j,71)%j)*f(1)+A(j,1)%j*f(2)+(A(j,4)%j &
       +A(j,7)%j)*f(3)+(-A(j,2)%j-A(j,5)%j)*f(16)+(A(j,10)%j+A(j,13)%j+A(j,15)%j+A(j,17)%j+A(j,20)%j+A(j,23)%j+A(j,25)%j+A(j,27)%j &
       +A(j,45)%j+A(j,47)%j+A(j,48)%j+A(j,49)%j+A(j,65)%j+A(j,67)%j+A(j,68)%j+A(j,69)%j)*f(20)+(A(j,28)%j+A(j,32)%j)*f(29)+( &
       -A(j,30)%j-A(j,34)%j-A(j,36)%j-A(j,40)%j)*f(30)+(-A(j,9)%j-A(j,14)%j-A(j,19)%j-A(j,24)%j+A(j,52)%j+A(j,58)%j+A(j,72)%j &
       +A(j,79)%j)*f(31)+(A(j,38)%j+A(j,42)%j)*f(32)+(A(j,12)%j+A(j,16)%j+A(j,22)%j+A(j,26)%j-A(j,55)%j-A(j,62)%j-A(j,74)%j &
       -A(j,81)%j)*f(33)+(A(j,3)%j+A(j,6)%j+A(j,29)%j+A(j,31)%j+A(j,33)%j+A(j,35)%j+A(j,37)%j+A(j,39)%j+A(j,41)%j+A(j,43)%j &
       -A(j,44)%j-A(j,46)%j+A(j,53)%j+A(j,54)%j+A(j,56)%j+A(j,57)%j+A(j,59)%j+A(j,60)%j+A(j,61)%j+A(j,63)%j-A(j,64)%j-A(j,66)%j &
       +A(j,73)%j+A(j,75)%j+A(j,76)%j+A(j,77)%j+A(j,78)%j+A(j,80)%j+A(j,82)%j+A(j,83)%j+A(j,84)%j+A(j,85)%j+A(j,86)%j+A(j,87)%j &
       +A(j,88)%j+A(j,89)%j+A(j,90)%j+A(j,91)%j+A(j,92)%j+A(j,93)%j)*f(34)

  M2(1)%j = (-A(j,749)%j-A(j,752)%j-A(j,763)%j-A(j,766)%j-A(j,777)%j-A(j,782)%j-A(j,803)%j-A(j,804)%j-A(j,813)%j-A(j,818)%j &
       -A(j,823)%j-A(j,826)%j-A(j,837)%j-A(j,840)%j-A(j,859)%j-A(j,860)%j-A(j,869)%j-A(j,874)%j-A(j,887)%j-A(j,892)%j-A(j,1005)%j &
       -A(j,1006)%j-A(j,1015)%j-A(j,1018)%j-A(j,1023)%j-A(j,1024)%j-A(j,1026)%j-A(j,1028)%j-A(j,1037)%j-A(j,1038)%j-A(j,1131)%j &
       -A(j,1134)%j-A(j,1139)%j-A(j,1140)%j-A(j,1153)%j-A(j,1154)%j-A(j,1156)%j-A(j,1158)%j-A(j,1167)%j-A(j,1168)%j)*f(4)+( &
       -A(j,111)%j-A(j,112)%j-A(j,113)%j-A(j,114)%j)*f(5)+(-A(j,696)%j-A(j,702)%j-A(j,708)%j-A(j,714)%j-A(j,720)%j-A(j,726)%j &
       -A(j,732)%j-A(j,738)%j-A(j,743)%j-A(j,748)%j)*f(6)+(A(j,127)%j+A(j,132)%j+A(j,163)%j+A(j,168)%j+A(j,189)%j+A(j,194)%j &
       +A(j,225)%j+A(j,230)%j+A(j,245)%j+A(j,250)%j+A(j,275)%j+A(j,278)%j+A(j,320)%j+A(j,321)%j+A(j,340)%j+A(j,341)%j+A(j,403)%j &
       +A(j,404)%j+A(j,423)%j+A(j,424)%j)*f(7)+(A(j,95)%j+A(j,96)%j)*f(8)+(A(j,202)%j+A(j,208)%j+A(j,271)%j+A(j,274)%j)*f(9) &
       +(A(j,348)%j+A(j,349)%j+A(j,461)%j+A(j,462)%j+A(j,499)%j+A(j,500)%j+A(j,523)%j+A(j,526)%j+A(j,533)%j+A(j,536)%j+A(j,577)%j &
       +A(j,578)%j+A(j,599)%j+A(j,600)%j+A(j,635)%j+A(j,638)%j+A(j,645)%j+A(j,648)%j+A(j,677)%j+A(j,678)%j)*f(10)+(A(j,97)%j &
       +A(j,98)%j)*f(11)+(A(j,519)%j+A(j,522)%j+A(j,631)%j+A(j,634)%j)*f(12)+(A(j,291)%j+A(j,292)%j+A(j,374)%j+A(j,375)%j)*f(13) &
       +(A(j,115)%j+A(j,118)%j+A(j,135)%j+A(j,138)%j)*f(14)+(-A(j,691)%j-A(j,697)%j-A(j,703)%j-A(j,709)%j+A(j,715)%j+A(j,721)%j &
       +A(j,727)%j+A(j,733)%j)*f(15)+(A(j,694)%j+A(j,700)%j+A(j,706)%j+A(j,712)%j+A(j,718)%j+A(j,724)%j+A(j,730)%j+A(j,736)%j &
       +A(j,739)%j+A(j,744)%j)*f(17)+(-A(j,200)%j-A(j,206)%j-A(j,269)%j-A(j,272)%j)*f(18)+(-A(j,517)%j-A(j,520)%j-A(j,629)%j &
       -A(j,632)%j)*f(19)+(-A(j,815)%j-A(j,820)%j-A(j,889)%j-A(j,894)%j)*f(21)+(A(j,806)%j+A(j,810)%j+A(j,862)%j+A(j,866)%j)*f(22) &
       +(A(j,126)%j+A(j,129)%j+A(j,162)%j+A(j,165)%j+A(j,188)%j+A(j,191)%j+A(j,244)%j+A(j,247)%j+A(j,351)%j+A(j,353)%j+A(j,464)%j &
       +A(j,466)%j+A(j,496)%j+A(j,498)%j+A(j,596)%j+A(j,598)%j+A(j,741)%j+A(j,742)%j+A(j,746)%j+A(j,747)%j-A(j,751)%j-A(j,754)%j &
       -A(j,758)%j-A(j,762)%j-A(j,765)%j-A(j,768)%j-A(j,772)%j-A(j,776)%j-A(j,781)%j-A(j,786)%j-A(j,790)%j-A(j,794)%j-A(j,796)%j &
       -A(j,798)%j-A(j,800)%j-A(j,802)%j-A(j,808)%j-A(j,812)%j-A(j,817)%j-A(j,822)%j-A(j,825)%j-A(j,828)%j-A(j,832)%j-A(j,836)%j &
       -A(j,839)%j-A(j,842)%j-A(j,846)%j-A(j,850)%j-A(j,852)%j-A(j,854)%j-A(j,856)%j-A(j,858)%j-A(j,864)%j-A(j,868)%j-A(j,873)%j &
       -A(j,878)%j-A(j,882)%j-A(j,886)%j-A(j,891)%j-A(j,896)%j-A(j,996)%j-A(j,1000)%j-A(j,1002)%j-A(j,1004)%j-A(j,1008)%j &
       -A(j,1010)%j-A(j,1011)%j-A(j,1012)%j-A(j,1014)%j-A(j,1017)%j-A(j,1020)%j-A(j,1022)%j-A(j,1025)%j-A(j,1027)%j-A(j,1030)%j &
       -A(j,1032)%j-A(j,1034)%j-A(j,1036)%j-A(j,1042)%j-A(j,1044)%j-A(j,1048)%j-A(j,1050)%j-A(j,1124)%j-A(j,1126)%j-A(j,1127)%j &
       -A(j,1128)%j-A(j,1130)%j-A(j,1133)%j-A(j,1136)%j-A(j,1138)%j-A(j,1144)%j-A(j,1148)%j-A(j,1150)%j-A(j,1152)%j-A(j,1155)%j &
       -A(j,1157)%j-A(j,1160)%j-A(j,1162)%j-A(j,1164)%j-A(j,1166)%j-A(j,1172)%j-A(j,1174)%j-A(j,1178)%j-A(j,1180)%j)*f(23) &
       +(A(j,131)%j+A(j,134)%j+A(j,167)%j+A(j,170)%j+A(j,193)%j+A(j,196)%j+A(j,229)%j+A(j,234)%j+A(j,238)%j+A(j,242)%j+A(j,249)%j &
       +A(j,252)%j+A(j,277)%j+A(j,280)%j+A(j,282)%j+A(j,284)%j+A(j,314)%j+A(j,316)%j+A(j,317)%j+A(j,319)%j+A(j,335)%j+A(j,336)%j &
       +A(j,337)%j+A(j,339)%j+A(j,397)%j+A(j,399)%j+A(j,400)%j+A(j,402)%j+A(j,418)%j+A(j,419)%j+A(j,420)%j+A(j,422)%j)*f(24) &
       +(A(j,354)%j+A(j,355)%j+A(j,467)%j+A(j,468)%j+A(j,492)%j+A(j,494)%j+A(j,525)%j+A(j,528)%j+A(j,530)%j+A(j,532)%j+A(j,535)%j &
       +A(j,538)%j+A(j,540)%j+A(j,542)%j+A(j,572)%j+A(j,574)%j+A(j,575)%j+A(j,576)%j+A(j,592)%j+A(j,594)%j+A(j,637)%j+A(j,640)%j &
       +A(j,642)%j+A(j,644)%j+A(j,647)%j+A(j,650)%j+A(j,652)%j+A(j,654)%j+A(j,672)%j+A(j,674)%j+A(j,675)%j+A(j,676)%j)*f(25)+( &
       -A(j,101)%j-A(j,104)%j-A(j,107)%j-A(j,110)%j)*f(26)+(-A(j,99)%j-A(j,102)%j-A(j,105)%j-A(j,108)%j)*f(27)+(A(j,197)%j &
       +A(j,203)%j)*f(28)+(-A(j,897)%j-A(j,901)%j-A(j,913)%j-A(j,917)%j-A(j,937)%j-A(j,941)%j-A(j,969)%j-A(j,973)%j-A(j,985)%j &
       -A(j,989)%j)*f(35)+(A(j,899)%j+A(j,903)%j+A(j,905)%j+A(j,909)%j+A(j,915)%j+A(j,919)%j+A(j,921)%j+A(j,925)%j+A(j,939)%j &
       +A(j,943)%j+A(j,945)%j+A(j,949)%j+A(j,953)%j+A(j,957)%j+A(j,961)%j+A(j,965)%j+A(j,971)%j+A(j,975)%j+A(j,977)%j &
       +A(j,981)%j)*f(36)+(A(j,145)%j+A(j,149)%j+A(j,171)%j+A(j,175)%j+A(j,209)%j+A(j,217)%j+A(j,253)%j+A(j,257)%j+A(j,356)%j &
       +A(j,362)%j+A(j,469)%j+A(j,476)%j+A(j,503)%j+A(j,511)%j+A(j,607)%j+A(j,615)%j+A(j,750)%j+A(j,757)%j+A(j,764)%j+A(j,771)%j &
       +A(j,780)%j+A(j,789)%j+A(j,795)%j+A(j,799)%j+A(j,814)%j+A(j,819)%j+A(j,824)%j+A(j,831)%j+A(j,838)%j+A(j,845)%j+A(j,851)%j &
       +A(j,855)%j+A(j,872)%j+A(j,881)%j+A(j,888)%j+A(j,893)%j-A(j,955)%j-A(j,959)%j-A(j,963)%j-A(j,967)%j-A(j,986)%j-A(j,987)%j &
       -A(j,990)%j-A(j,991)%j-A(j,1051)%j-A(j,1057)%j-A(j,1063)%j-A(j,1069)%j-A(j,1077)%j-A(j,1079)%j-A(j,1081)%j-A(j,1087)%j &
       -A(j,1093)%j-A(j,1101)%j-A(j,1105)%j-A(j,1113)%j-A(j,1115)%j-A(j,1117)%j-A(j,1181)%j-A(j,1187)%j-A(j,1193)%j-A(j,1195)%j &
       -A(j,1207)%j-A(j,1209)%j-A(j,1211)%j-A(j,1218)%j-A(j,1225)%j-A(j,1229)%j-A(j,1231)%j-A(j,1243)%j-A(j,1245)%j &
       -A(j,1248)%j)*f(37)+(-A(j,907)%j-A(j,911)%j-A(j,923)%j-A(j,927)%j-A(j,929)%j-A(j,933)%j-A(j,947)%j-A(j,951)%j-A(j,979)%j &
       -A(j,983)%j)*f(38)+(-A(j,151)%j-A(j,153)%j-A(j,173)%j-A(j,179)%j-A(j,213)%j-A(j,219)%j-A(j,259)%j-A(j,261)%j-A(j,359)%j &
       -A(j,366)%j-A(j,471)%j-A(j,478)%j-A(j,507)%j-A(j,513)%j-A(j,605)%j-A(j,609)%j-A(j,753)%j-A(j,761)%j-A(j,767)%j-A(j,775)%j &
       -A(j,785)%j-A(j,793)%j-A(j,797)%j-A(j,801)%j-A(j,805)%j-A(j,809)%j-A(j,827)%j-A(j,835)%j-A(j,841)%j-A(j,849)%j-A(j,853)%j &
       -A(j,857)%j-A(j,861)%j-A(j,865)%j-A(j,877)%j-A(j,885)%j+A(j,930)%j+A(j,931)%j+A(j,934)%j+A(j,935)%j+A(j,954)%j+A(j,958)%j &
       +A(j,962)%j+A(j,966)%j+A(j,1054)%j+A(j,1060)%j+A(j,1065)%j+A(j,1067)%j+A(j,1073)%j+A(j,1075)%j+A(j,1084)%j+A(j,1091)%j &
       +A(j,1097)%j+A(j,1099)%j+A(j,1103)%j+A(j,1107)%j+A(j,1109)%j+A(j,1121)%j+A(j,1183)%j+A(j,1189)%j+A(j,1191)%j+A(j,1198)%j &
       +A(j,1203)%j+A(j,1205)%j+A(j,1213)%j+A(j,1220)%j+A(j,1223)%j+A(j,1227)%j+A(j,1235)%j+A(j,1237)%j+A(j,1239)%j &
       +A(j,1250)%j)*f(39)+(A(j,94)%j-A(j,125)%j-A(j,128)%j+A(j,146)%j+A(j,150)%j+A(j,152)%j+A(j,154)%j-A(j,161)%j-A(j,164)%j &
       +A(j,172)%j+A(j,174)%j+A(j,176)%j+A(j,180)%j-A(j,187)%j-A(j,190)%j+A(j,210)%j+A(j,214)%j+A(j,218)%j+A(j,220)%j-A(j,243)%j &
       -A(j,246)%j+A(j,254)%j+A(j,258)%j+A(j,260)%j+A(j,262)%j+A(j,293)%j+A(j,294)%j+A(j,295)%j+A(j,299)%j+A(j,300)%j+A(j,301)%j &
       +A(j,305)%j+A(j,306)%j+A(j,307)%j+A(j,328)%j+A(j,329)%j+A(j,330)%j-A(j,350)%j-A(j,352)%j+A(j,357)%j+A(j,360)%j+A(j,363)%j &
       +A(j,367)%j+A(j,376)%j+A(j,377)%j+A(j,381)%j+A(j,383)%j+A(j,384)%j+A(j,387)%j+A(j,388)%j+A(j,389)%j+A(j,393)%j+A(j,411)%j &
       +A(j,412)%j+A(j,416)%j+A(j,454)%j+A(j,455)%j+A(j,457)%j+A(j,458)%j+A(j,459)%j+A(j,460)%j-A(j,463)%j-A(j,465)%j+A(j,470)%j &
       +A(j,472)%j+A(j,477)%j+A(j,479)%j+A(j,485)%j+A(j,486)%j+A(j,487)%j+A(j,488)%j+A(j,489)%j+A(j,490)%j-A(j,495)%j-A(j,497)%j &
       +A(j,504)%j+A(j,508)%j+A(j,512)%j+A(j,514)%j+A(j,561)%j+A(j,562)%j+A(j,565)%j+A(j,566)%j+A(j,569)%j+A(j,570)%j-A(j,595)%j &
       -A(j,597)%j+A(j,606)%j+A(j,608)%j+A(j,610)%j+A(j,616)%j+A(j,617)%j+A(j,618)%j+A(j,619)%j+A(j,620)%j+A(j,621)%j+A(j,622)%j &
       -A(j,695)%j-A(j,701)%j-A(j,707)%j-A(j,713)%j-A(j,719)%j-A(j,725)%j-A(j,731)%j-A(j,737)%j-A(j,740)%j-A(j,745)%j+A(j,807)%j &
       +A(j,811)%j+A(j,816)%j+A(j,821)%j+A(j,863)%j+A(j,867)%j+A(j,890)%j+A(j,895)%j-A(j,898)%j-A(j,900)%j-A(j,902)%j-A(j,904)%j &
       -A(j,906)%j-A(j,908)%j-A(j,910)%j-A(j,912)%j-A(j,914)%j-A(j,916)%j-A(j,918)%j-A(j,920)%j-A(j,922)%j-A(j,924)%j-A(j,926)%j &
       -A(j,928)%j-A(j,932)%j-A(j,936)%j-A(j,938)%j-A(j,940)%j-A(j,942)%j-A(j,944)%j-A(j,946)%j-A(j,948)%j-A(j,950)%j-A(j,952)%j &
       -A(j,956)%j-A(j,960)%j-A(j,964)%j-A(j,968)%j-A(j,970)%j-A(j,972)%j-A(j,974)%j-A(j,976)%j-A(j,978)%j-A(j,980)%j-A(j,982)%j &
       -A(j,984)%j-A(j,988)%j-A(j,992)%j+A(j,995)%j+A(j,999)%j+A(j,1007)%j+A(j,1009)%j+A(j,1013)%j+A(j,1016)%j+A(j,1019)%j &
       +A(j,1021)%j+A(j,1029)%j+A(j,1031)%j+A(j,1033)%j+A(j,1035)%j+A(j,1041)%j+A(j,1047)%j-A(j,1052)%j-A(j,1053)%j-A(j,1055)%j &
       -A(j,1056)%j-A(j,1058)%j-A(j,1059)%j-A(j,1061)%j-A(j,1062)%j-A(j,1064)%j-A(j,1066)%j-A(j,1068)%j-A(j,1070)%j-A(j,1071)%j &
       -A(j,1072)%j-A(j,1074)%j-A(j,1076)%j-A(j,1078)%j-A(j,1080)%j-A(j,1082)%j-A(j,1083)%j-A(j,1085)%j-A(j,1086)%j-A(j,1088)%j &
       -A(j,1089)%j-A(j,1090)%j-A(j,1092)%j-A(j,1094)%j-A(j,1095)%j-A(j,1096)%j-A(j,1098)%j-A(j,1100)%j-A(j,1102)%j-A(j,1104)%j &
       -A(j,1106)%j-A(j,1108)%j-A(j,1110)%j-A(j,1111)%j-A(j,1112)%j-A(j,1114)%j-A(j,1116)%j-A(j,1118)%j-A(j,1119)%j-A(j,1120)%j &
       -A(j,1122)%j+A(j,1123)%j+A(j,1125)%j+A(j,1129)%j+A(j,1132)%j+A(j,1135)%j+A(j,1137)%j+A(j,1143)%j+A(j,1147)%j+A(j,1159)%j &
       +A(j,1161)%j+A(j,1163)%j+A(j,1165)%j+A(j,1171)%j+A(j,1177)%j-A(j,1182)%j-A(j,1184)%j-A(j,1185)%j-A(j,1186)%j-A(j,1188)%j &
       -A(j,1190)%j-A(j,1192)%j-A(j,1194)%j-A(j,1196)%j-A(j,1197)%j-A(j,1199)%j-A(j,1200)%j-A(j,1201)%j-A(j,1202)%j-A(j,1204)%j &
       -A(j,1206)%j-A(j,1208)%j-A(j,1210)%j-A(j,1212)%j-A(j,1214)%j-A(j,1215)%j-A(j,1216)%j-A(j,1217)%j-A(j,1219)%j-A(j,1221)%j &
       -A(j,1222)%j-A(j,1224)%j-A(j,1226)%j-A(j,1228)%j-A(j,1230)%j-A(j,1232)%j-A(j,1233)%j-A(j,1234)%j-A(j,1236)%j-A(j,1238)%j &
       -A(j,1240)%j-A(j,1241)%j-A(j,1242)%j-A(j,1244)%j-A(j,1246)%j-A(j,1247)%j-A(j,1249)%j-A(j,1251)%j-A(j,1252)%j-A(j,1253)%j &
       -A(j,1254)%j-A(j,1255)%j-A(j,1256)%j-A(j,1257)%j-A(j,1258)%j-A(j,1259)%j-A(j,1260)%j-A(j,1261)%j-A(j,1262)%j-A(j,1263)%j &
       -A(j,1264)%j-A(j,1265)%j-A(j,1266)%j-A(j,1267)%j-A(j,1268)%j-A(j,1269)%j-A(j,1270)%j-A(j,1271)%j-A(j,1272)%j-A(j,1273)%j &
       -A(j,1274)%j-A(j,1275)%j-A(j,1276)%j-A(j,1277)%j-A(j,1278)%j-A(j,1279)%j-A(j,1280)%j-A(j,1281)%j-A(j,1282)%j-A(j,1283)%j &
       -A(j,1284)%j-A(j,1285)%j-A(j,1286)%j-A(j,1287)%j-A(j,1288)%j-A(j,1289)%j-A(j,1290)%j-A(j,1291)%j-A(j,1292)%j-A(j,1293)%j &
       -A(j,1294)%j-A(j,1295)%j-A(j,1296)%j-A(j,1297)%j-A(j,1298)%j-A(j,1299)%j-A(j,1300)%j-A(j,1301)%j-A(j,1302)%j-A(j,1303)%j &
       -A(j,1304)%j-A(j,1305)%j-A(j,1306)%j-A(j,1307)%j-A(j,1308)%j-A(j,1309)%j-A(j,1310)%j)*f(40)+(-A(j,116)%j-A(j,121)%j &
       -A(j,136)%j-A(j,141)%j)*f(41)+(A(j,119)%j+A(j,123)%j+A(j,139)%j+A(j,143)%j)*f(42)+(A(j,100)%j+A(j,103)%j+A(j,106)%j &
       +A(j,109)%j-A(j,285)%j-A(j,287)%j-A(j,368)%j-A(j,370)%j)*f(43)+(A(j,211)%j+A(j,221)%j+A(j,255)%j+A(j,265)%j)*f(44)+( &
       -A(j,147)%j-A(j,157)%j-A(j,177)%j-A(j,183)%j-A(j,215)%j-A(j,223)%j-A(j,263)%j-A(j,267)%j)*f(45)+(-A(j,192)%j-A(j,195)%j &
       -A(j,228)%j-A(j,237)%j-A(j,248)%j-A(j,251)%j-A(j,276)%j-A(j,281)%j+A(j,308)%j+A(j,323)%j+A(j,331)%j+A(j,343)%j+A(j,390)%j &
       +A(j,407)%j+A(j,413)%j+A(j,427)%j)*f(46)+(A(j,155)%j+A(j,159)%j+A(j,181)%j+A(j,185)%j)*f(47)+(A(j,130)%j+A(j,133)%j &
       +A(j,166)%j+A(j,169)%j+A(j,233)%j+A(j,241)%j+A(j,279)%j+A(j,283)%j-A(j,296)%j-A(j,303)%j-A(j,326)%j-A(j,346)%j-A(j,378)%j &
       -A(j,385)%j-A(j,409)%j-A(j,429)%j)*f(48)+(A(j,148)%j+A(j,156)%j+A(j,158)%j+A(j,160)%j+A(j,178)%j+A(j,182)%j+A(j,184)%j &
       +A(j,186)%j+A(j,201)%j+A(j,207)%j+A(j,212)%j+A(j,216)%j+A(j,222)%j+A(j,224)%j+A(j,256)%j+A(j,264)%j+A(j,266)%j+A(j,268)%j &
       +A(j,270)%j+A(j,273)%j+A(j,297)%j+A(j,298)%j+A(j,302)%j+A(j,304)%j+A(j,309)%j+A(j,310)%j-A(j,313)%j-A(j,318)%j+A(j,322)%j &
       +A(j,324)%j+A(j,325)%j+A(j,327)%j+A(j,332)%j+A(j,333)%j-A(j,334)%j-A(j,338)%j+A(j,342)%j+A(j,344)%j+A(j,345)%j+A(j,347)%j &
       +A(j,379)%j+A(j,380)%j+A(j,382)%j+A(j,386)%j+A(j,391)%j+A(j,392)%j-A(j,396)%j-A(j,401)%j+A(j,405)%j+A(j,406)%j+A(j,408)%j &
       +A(j,410)%j+A(j,414)%j+A(j,415)%j-A(j,417)%j-A(j,421)%j+A(j,425)%j+A(j,426)%j+A(j,428)%j+A(j,430)%j+A(j,431)%j+A(j,432)%j &
       +A(j,433)%j+A(j,434)%j+A(j,435)%j+A(j,436)%j+A(j,437)%j+A(j,438)%j+A(j,439)%j+A(j,440)%j+A(j,441)%j+A(j,442)%j+A(j,443)%j &
       +A(j,444)%j+A(j,445)%j+A(j,446)%j+A(j,447)%j+A(j,448)%j+A(j,449)%j+A(j,450)%j)*f(49)+(A(j,543)%j+A(j,547)%j+A(j,655)%j &
       +A(j,659)%j)*f(50)+(-A(j,545)%j-A(j,549)%j-A(j,551)%j-A(j,555)%j-A(j,657)%j-A(j,661)%j-A(j,663)%j-A(j,667)%j)*f(51) &
       +(A(j,501)%j+A(j,509)%j-A(j,524)%j-A(j,529)%j-A(j,534)%j-A(j,539)%j+A(j,579)%j+A(j,586)%j+A(j,601)%j+A(j,611)%j-A(j,636)%j &
       -A(j,641)%j-A(j,646)%j-A(j,651)%j+A(j,679)%j+A(j,685)%j)*f(52)+(A(j,553)%j+A(j,557)%j+A(j,665)%j+A(j,669)%j)*f(53)+( &
       -A(j,505)%j-A(j,515)%j+A(j,527)%j+A(j,531)%j+A(j,537)%j+A(j,541)%j-A(j,581)%j-A(j,588)%j-A(j,603)%j-A(j,613)%j+A(j,639)%j &
       +A(j,643)%j+A(j,649)%j+A(j,653)%j-A(j,682)%j-A(j,689)%j)*f(54)+(A(j,358)%j+A(j,361)%j+A(j,364)%j+A(j,365)%j+A(j,451)%j &
       +A(j,452)%j+A(j,453)%j+A(j,456)%j+A(j,473)%j+A(j,474)%j+A(j,475)%j+A(j,480)%j+A(j,481)%j+A(j,482)%j+A(j,483)%j+A(j,484)%j &
       -A(j,491)%j-A(j,493)%j+A(j,502)%j+A(j,506)%j+A(j,510)%j+A(j,516)%j+A(j,518)%j+A(j,521)%j+A(j,544)%j+A(j,546)%j+A(j,548)%j &
       +A(j,550)%j+A(j,552)%j+A(j,554)%j+A(j,556)%j+A(j,558)%j+A(j,559)%j+A(j,560)%j+A(j,563)%j+A(j,564)%j+A(j,567)%j+A(j,568)%j &
       -A(j,571)%j-A(j,573)%j+A(j,580)%j+A(j,582)%j+A(j,583)%j+A(j,584)%j+A(j,585)%j+A(j,587)%j+A(j,589)%j+A(j,590)%j-A(j,591)%j &
       -A(j,593)%j+A(j,602)%j+A(j,604)%j+A(j,612)%j+A(j,614)%j+A(j,623)%j+A(j,624)%j+A(j,625)%j+A(j,626)%j+A(j,627)%j+A(j,628)%j &
       +A(j,630)%j+A(j,633)%j+A(j,656)%j+A(j,658)%j+A(j,660)%j+A(j,662)%j+A(j,664)%j+A(j,666)%j+A(j,668)%j+A(j,670)%j-A(j,671)%j &
       -A(j,673)%j+A(j,680)%j+A(j,681)%j+A(j,683)%j+A(j,684)%j+A(j,686)%j+A(j,687)%j+A(j,688)%j+A(j,690)%j)*f(55)+(-A(j,117)%j &
       -A(j,120)%j-A(j,122)%j-A(j,124)%j-A(j,137)%j-A(j,140)%j-A(j,142)%j-A(j,144)%j-A(j,286)%j-A(j,288)%j-A(j,289)%j-A(j,290)%j &
       -A(j,369)%j-A(j,371)%j-A(j,372)%j-A(j,373)%j)*f(56)+(-A(j,755)%j-A(j,769)%j-A(j,778)%j-A(j,787)%j-A(j,829)%j-A(j,843)%j &
       -A(j,870)%j-A(j,879)%j)*f(57)+(A(j,759)%j+A(j,773)%j+A(j,783)%j+A(j,791)%j+A(j,833)%j+A(j,847)%j+A(j,875)%j &
       +A(j,883)%j)*f(58)+(A(j,692)%j-A(j,693)%j+A(j,698)%j-A(j,699)%j+A(j,704)%j-A(j,705)%j+A(j,710)%j-A(j,711)%j+A(j,716)%j &
       -A(j,717)%j+A(j,722)%j-A(j,723)%j+A(j,728)%j-A(j,729)%j+A(j,734)%j-A(j,735)%j-A(j,993)%j-A(j,997)%j-A(j,1039)%j-A(j,1045)%j &
       -A(j,1141)%j-A(j,1145)%j-A(j,1169)%j-A(j,1175)%j)*f(59)+(-A(j,756)%j-A(j,760)%j-A(j,770)%j-A(j,774)%j-A(j,779)%j-A(j,784)%j &
       -A(j,788)%j-A(j,792)%j-A(j,830)%j-A(j,834)%j-A(j,844)%j-A(j,848)%j-A(j,871)%j-A(j,876)%j-A(j,880)%j-A(j,884)%j-A(j,994)%j &
       -A(j,998)%j-A(j,1001)%j-A(j,1003)%j-A(j,1040)%j-A(j,1043)%j-A(j,1046)%j-A(j,1049)%j-A(j,1142)%j-A(j,1146)%j-A(j,1149)%j &
       -A(j,1151)%j-A(j,1170)%j-A(j,1173)%j-A(j,1176)%j-A(j,1179)%j)*f(60)+(-A(j,226)%j-A(j,235)%j)*f(61)+(A(j,231)%j &
       +A(j,239)%j)*f(62)+(A(j,198)%j-A(j,199)%j+A(j,204)%j-A(j,205)%j-A(j,311)%j-A(j,394)%j)*f(63)+(-A(j,227)%j-A(j,232)%j &
       -A(j,236)%j-A(j,240)%j-A(j,312)%j-A(j,315)%j-A(j,395)%j-A(j,398)%j)*f(64)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppllnnjj_ew_nexnmxemucdxsx_4_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 1
      do j = 1, 1
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppllnnjj_ew_nexnmxemucdxsx_4_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mct(1)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 1
    do j = 1, 1
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+1*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppllnnjj_ew_nexnmxemucdxsx_4_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2IRadd(37)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 38-1
    colmatpos = 1*k
    do i = 1, 1
      do j = 1, 1
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppllnnjj_ew_nexnmxemucdxsx_4_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppllnnjj_ew_nexnmxemucdxsx_4_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(1)
  type(Hpolcont), intent(out)  :: M0_col(1)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 1 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 1 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+1*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppllnnjj_ew_nexnmxemucdxsx_4_/**/REALKIND
