
module ol_external_ppllnnjj_ew_nexnmxemuudxdx_3
  implicit none
  integer :: dummy_counter
  ! Permutation and inverse permutation of external particles
  integer, save :: external_perm_ppllnnjj_ew_nexnmxemuudxdx_3(8) = &
                     [ (dummy_counter, dummy_counter = 1, 8) ]
  integer, save :: external_perm_inv_ppllnnjj_ew_nexnmxemuudxdx_3(8) = &
                     [ (dummy_counter, dummy_counter = 1, 8) ]
  integer, save :: extcomb_perm_ppllnnjj_ew_nexnmxemuudxdx_3(0:37) = &
                     [ (dummy_counter, dummy_counter = 0, 37) ]
  ! Particle types (mapping of fields to integers is not fixed!)
  integer, save :: particle_types_ppllnnjj_ew_nexnmxemuudxdx_3(8) = &
                     [ 1, 2, 3, 4, 5, 5, 6, 6 ]
  ! Colour and helicity average factors per particle
  integer, save :: average_factors_ppllnnjj_ew_nexnmxemuudxdx_3(8) = &
                     [ 2, 2, 2, 2, 6, 6, 6, 6 ]
  ! Average factor; initialised to the identity permutation
  integer, save :: average_factor_ppllnnjj_ew_nexnmxemuudxdx_3 = &
                     16
  integer, save :: channel_number_ppllnnjj_ew_nexnmxemuudxdx_3 = -1
  ! external particle helicities
  logical, save :: hel_not_initialised = .true.
  integer, save :: H(8,256) ! H(i,la) = helicity of particle i in configuration la
  integer, save :: H_HC(256,8)
  integer, save :: POLSEL(8) = 0
  integer, save :: photonid_ppllnnjj_ew_nexnmxemuudxdx_3(8) = 0

  contains

  subroutine n_external(n) &
      & bind(c,name="ol_f_n_external_ppllnnjj_ew_nexnmxemuudxdx_3")
    ! Return the number of external particles
    implicit none
    integer, intent(out) :: n
    n = 8
  end subroutine n_external


  subroutine n_external_c(n) &
      & bind(c,name="ol_n_external_ppllnnjj_ew_nexnmxemuudxdx_3")
    use, intrinsic :: iso_c_binding, only: c_int
    implicit none
    integer(c_int) :: n
    n = 8
  end subroutine n_external_c


  subroutine set_permutation(perm) &
      & bind(c,name="ol_f_set_permutation_ppllnnjj_ew_nexnmxemuudxdx_3")
    use ol_parameters_decl_/**/DREALKIND, only: out_symmetry_on
    use ol_external_decl_/**/DREALKIND, only: n_scatt
    use ol_generic, only: factorial
    implicit none
    integer, intent(in) :: perm(8)
    integer :: i, j, ii, jj
    integer :: particle_types_perm_ppllnnjj_ew_nexnmxemuudxdx_3(8)
    external_perm_ppllnnjj_ew_nexnmxemuudxdx_3 = perm
    do i = 1, 8
      external_perm_inv_ppllnnjj_ew_nexnmxemuudxdx_3( &
        external_perm_ppllnnjj_ew_nexnmxemuudxdx_3(i)) = i
      particle_types_perm_ppllnnjj_ew_nexnmxemuudxdx_3(i) = &
        particle_types_ppllnnjj_ew_nexnmxemuudxdx_3( &
        external_perm_ppllnnjj_ew_nexnmxemuudxdx_3(i))
    end do
    do i = 1, 8
      do j = 1, i
        if (external_perm_ppllnnjj_ew_nexnmxemuudxdx_3(i) >= &
          external_perm_ppllnnjj_ew_nexnmxemuudxdx_3(j)) then
          ii = external_perm_ppllnnjj_ew_nexnmxemuudxdx_3(i)
          jj = external_perm_ppllnnjj_ew_nexnmxemuudxdx_3(j)
        else
          ii = external_perm_ppllnnjj_ew_nexnmxemuudxdx_3(j)
          jj = external_perm_ppllnnjj_ew_nexnmxemuudxdx_3(i)
        end if
        extcomb_perm_ppllnnjj_ew_nexnmxemuudxdx_3((i*(i-1))/2 + j) = (ii*(ii-1))/2 + jj
      end do
    end do
    ! Colour and helicity average factor
    average_factor_ppllnnjj_ew_nexnmxemuudxdx_3 = 1
    do i = 1, n_scatt
      average_factor_ppllnnjj_ew_nexnmxemuudxdx_3 = &
        average_factor_ppllnnjj_ew_nexnmxemuudxdx_3 &
        * average_factors_ppllnnjj_ew_nexnmxemuudxdx_3( &
        external_perm_ppllnnjj_ew_nexnmxemuudxdx_3(i))
    end do
    ! Symmetry factor for outgoing particles
    if (out_symmetry_on /= 0) then
      do i = 1, 8
        average_factor_ppllnnjj_ew_nexnmxemuudxdx_3 = &
          average_factor_ppllnnjj_ew_nexnmxemuudxdx_3 &
          * factorial(count(particle_types_perm_ppllnnjj_ew_nexnmxemuudxdx_3(n_scatt+1:8) == i))
      end do
    end if
  end subroutine set_permutation


  subroutine set_permutation_c(perm) &
      & bind(c,name="ol_set_permutation_ppllnnjj_ew_nexnmxemuudxdx_3")
    use, intrinsic :: iso_c_binding, only: c_int
    implicit none
    integer(c_int), intent(in) :: perm(8)
    integer :: f_perm(8)
    f_perm = perm
    call set_permutation(f_perm)
  end subroutine set_permutation_c


  subroutine get_masses(m_ex) &
      & bind(c,name="ol_f_get_masses_ppllnnjj_ew_nexnmxemuudxdx_3")
    ! Return the masses of the external particles in the current permutation.
    use KIND_TYPES, only: DREALKIND
    use ol_parameters_decl_/**/DREALKIND
    implicit none
    real(DREALKIND), intent(out) :: m_ex(8)
    integer        :: i
    real(DREALKIND) :: m_ex_orig(8)
    ! External particle masses for in the identity permutation
    m_ex_orig = [ rZERO, rZERO, rZERO, rZERO, rZERO, rZERO, rZERO, rZERO ]
    do i = 1, 8
      m_ex(i) = m_ex_orig(external_perm_ppllnnjj_ew_nexnmxemuudxdx_3(i))
    end do
  end subroutine get_masses


  subroutine get_masses_c(m_ex) &
      & bind(c,name="ol_get_masses_ppllnnjj_ew_nexnmxemuudxdx_3")
    use KIND_TYPES, only: DREALKIND
    use, intrinsic :: iso_c_binding, only: c_double
    implicit none
    real(c_double), intent(out) :: m_ex(8)
    real(DREALKIND) :: f_m_ex(8)
    call get_masses(f_m_ex)
    m_ex = f_m_ex
  end subroutine get_masses_c


  subroutine rambo(sqrt_s, p_rambo) &
      & bind(c,name="ol_f_rambo_ppllnnjj_ew_nexnmxemuudxdx_3")
    use KIND_TYPES, only: DREALKIND
    use ol_kinematics_/**/DREALKIND, only: rambo_generic => rambo
    implicit none
    real(DREALKIND), intent(in) :: sqrt_s
    real(DREALKIND), intent(out) :: p_rambo(0:3,8)
    real(DREALKIND) :: m_ex(8)
    call get_masses(m_ex)
    call rambo_generic(sqrt_s, m_ex, p_rambo)
  end subroutine rambo


  subroutine rambo_c(sqrt_s, p_rambo) &
      & bind(c,name="ol_rambo_ppllnnjj_ew_nexnmxemuudxdx_3")
    use KIND_TYPES, only: DREALKIND
    use, intrinsic :: iso_c_binding, only: c_double
    implicit none
    real(c_double), intent(in) :: sqrt_s
    real(c_double), intent(out) :: p_rambo(0:3,8)
    real(DREALKIND) :: f_sqrt_s
    real(DREALKIND) :: f_p_rambo(0:3,8)
    f_sqrt_s = sqrt_s
    call rambo(f_sqrt_s, f_p_rambo)
    p_rambo = f_p_rambo
  end subroutine rambo_c


  subroutine hel_init
    implicit none
    integer :: binpos, flip, binco
    hel_not_initialised = .false.
    ! helicity configurations for this process
  H(:,  1) = [ -1, -1, -1, -1, -1, -1, -1, -1 ]
  H(:,  2) = [ -1, -1, -1, -1, -1, -1, -1,  1 ]
  H(:,  3) = [ -1, -1, -1, -1, -1, -1,  1, -1 ]
  H(:,  4) = [ -1, -1, -1, -1, -1, -1,  1,  1 ]
  H(:,  5) = [ -1, -1, -1, -1, -1,  1, -1, -1 ]
  H(:,  6) = [ -1, -1, -1, -1, -1,  1, -1,  1 ]
  H(:,  7) = [ -1, -1, -1, -1, -1,  1,  1, -1 ]
  H(:,  8) = [ -1, -1, -1, -1, -1,  1,  1,  1 ]
  H(:,  9) = [ -1, -1, -1, -1,  1, -1, -1, -1 ]
  H(:, 10) = [ -1, -1, -1, -1,  1, -1, -1,  1 ]
  H(:, 11) = [ -1, -1, -1, -1,  1, -1,  1, -1 ]
  H(:, 12) = [ -1, -1, -1, -1,  1, -1,  1,  1 ]
  H(:, 13) = [ -1, -1, -1, -1,  1,  1, -1, -1 ]
  H(:, 14) = [ -1, -1, -1, -1,  1,  1, -1,  1 ]
  H(:, 15) = [ -1, -1, -1, -1,  1,  1,  1, -1 ]
  H(:, 16) = [ -1, -1, -1, -1,  1,  1,  1,  1 ]
  H(:, 17) = [ -1, -1, -1,  1, -1, -1, -1, -1 ]
  H(:, 18) = [ -1, -1, -1,  1, -1, -1, -1,  1 ]
  H(:, 19) = [ -1, -1, -1,  1, -1, -1,  1, -1 ]
  H(:, 20) = [ -1, -1, -1,  1, -1, -1,  1,  1 ]
  H(:, 21) = [ -1, -1, -1,  1, -1,  1, -1, -1 ]
  H(:, 22) = [ -1, -1, -1,  1, -1,  1, -1,  1 ]
  H(:, 23) = [ -1, -1, -1,  1, -1,  1,  1, -1 ]
  H(:, 24) = [ -1, -1, -1,  1, -1,  1,  1,  1 ]
  H(:, 25) = [ -1, -1, -1,  1,  1, -1, -1, -1 ]
  H(:, 26) = [ -1, -1, -1,  1,  1, -1, -1,  1 ]
  H(:, 27) = [ -1, -1, -1,  1,  1, -1,  1, -1 ]
  H(:, 28) = [ -1, -1, -1,  1,  1, -1,  1,  1 ]
  H(:, 29) = [ -1, -1, -1,  1,  1,  1, -1, -1 ]
  H(:, 30) = [ -1, -1, -1,  1,  1,  1, -1,  1 ]
  H(:, 31) = [ -1, -1, -1,  1,  1,  1,  1, -1 ]
  H(:, 32) = [ -1, -1, -1,  1,  1,  1,  1,  1 ]
  H(:, 33) = [ -1, -1,  1, -1, -1, -1, -1, -1 ]
  H(:, 34) = [ -1, -1,  1, -1, -1, -1, -1,  1 ]
  H(:, 35) = [ -1, -1,  1, -1, -1, -1,  1, -1 ]
  H(:, 36) = [ -1, -1,  1, -1, -1, -1,  1,  1 ]
  H(:, 37) = [ -1, -1,  1, -1, -1,  1, -1, -1 ]
  H(:, 38) = [ -1, -1,  1, -1, -1,  1, -1,  1 ]
  H(:, 39) = [ -1, -1,  1, -1, -1,  1,  1, -1 ]
  H(:, 40) = [ -1, -1,  1, -1, -1,  1,  1,  1 ]
  H(:, 41) = [ -1, -1,  1, -1,  1, -1, -1, -1 ]
  H(:, 42) = [ -1, -1,  1, -1,  1, -1, -1,  1 ]
  H(:, 43) = [ -1, -1,  1, -1,  1, -1,  1, -1 ]
  H(:, 44) = [ -1, -1,  1, -1,  1, -1,  1,  1 ]
  H(:, 45) = [ -1, -1,  1, -1,  1,  1, -1, -1 ]
  H(:, 46) = [ -1, -1,  1, -1,  1,  1, -1,  1 ]
  H(:, 47) = [ -1, -1,  1, -1,  1,  1,  1, -1 ]
  H(:, 48) = [ -1, -1,  1, -1,  1,  1,  1,  1 ]
  H(:, 49) = [ -1, -1,  1,  1, -1, -1, -1, -1 ]
  H(:, 50) = [ -1, -1,  1,  1, -1, -1, -1,  1 ]
  H(:, 51) = [ -1, -1,  1,  1, -1, -1,  1, -1 ]
  H(:, 52) = [ -1, -1,  1,  1, -1, -1,  1,  1 ]
  H(:, 53) = [ -1, -1,  1,  1, -1,  1, -1, -1 ]
  H(:, 54) = [ -1, -1,  1,  1, -1,  1, -1,  1 ]
  H(:, 55) = [ -1, -1,  1,  1, -1,  1,  1, -1 ]
  H(:, 56) = [ -1, -1,  1,  1, -1,  1,  1,  1 ]
  H(:, 57) = [ -1, -1,  1,  1,  1, -1, -1, -1 ]
  H(:, 58) = [ -1, -1,  1,  1,  1, -1, -1,  1 ]
  H(:, 59) = [ -1, -1,  1,  1,  1, -1,  1, -1 ]
  H(:, 60) = [ -1, -1,  1,  1,  1, -1,  1,  1 ]
  H(:, 61) = [ -1, -1,  1,  1,  1,  1, -1, -1 ]
  H(:, 62) = [ -1, -1,  1,  1,  1,  1, -1,  1 ]
  H(:, 63) = [ -1, -1,  1,  1,  1,  1,  1, -1 ]
  H(:, 64) = [ -1, -1,  1,  1,  1,  1,  1,  1 ]
  H(:, 65) = [ -1,  1, -1, -1, -1, -1, -1, -1 ]
  H(:, 66) = [ -1,  1, -1, -1, -1, -1, -1,  1 ]
  H(:, 67) = [ -1,  1, -1, -1, -1, -1,  1, -1 ]
  H(:, 68) = [ -1,  1, -1, -1, -1, -1,  1,  1 ]
  H(:, 69) = [ -1,  1, -1, -1, -1,  1, -1, -1 ]
  H(:, 70) = [ -1,  1, -1, -1, -1,  1, -1,  1 ]
  H(:, 71) = [ -1,  1, -1, -1, -1,  1,  1, -1 ]
  H(:, 72) = [ -1,  1, -1, -1, -1,  1,  1,  1 ]
  H(:, 73) = [ -1,  1, -1, -1,  1, -1, -1, -1 ]
  H(:, 74) = [ -1,  1, -1, -1,  1, -1, -1,  1 ]
  H(:, 75) = [ -1,  1, -1, -1,  1, -1,  1, -1 ]
  H(:, 76) = [ -1,  1, -1, -1,  1, -1,  1,  1 ]
  H(:, 77) = [ -1,  1, -1, -1,  1,  1, -1, -1 ]
  H(:, 78) = [ -1,  1, -1, -1,  1,  1, -1,  1 ]
  H(:, 79) = [ -1,  1, -1, -1,  1,  1,  1, -1 ]
  H(:, 80) = [ -1,  1, -1, -1,  1,  1,  1,  1 ]
  H(:, 81) = [ -1,  1, -1,  1, -1, -1, -1, -1 ]
  H(:, 82) = [ -1,  1, -1,  1, -1, -1, -1,  1 ]
  H(:, 83) = [ -1,  1, -1,  1, -1, -1,  1, -1 ]
  H(:, 84) = [ -1,  1, -1,  1, -1, -1,  1,  1 ]
  H(:, 85) = [ -1,  1, -1,  1, -1,  1, -1, -1 ]
  H(:, 86) = [ -1,  1, -1,  1, -1,  1, -1,  1 ]
  H(:, 87) = [ -1,  1, -1,  1, -1,  1,  1, -1 ]
  H(:, 88) = [ -1,  1, -1,  1, -1,  1,  1,  1 ]
  H(:, 89) = [ -1,  1, -1,  1,  1, -1, -1, -1 ]
  H(:, 90) = [ -1,  1, -1,  1,  1, -1, -1,  1 ]
  H(:, 91) = [ -1,  1, -1,  1,  1, -1,  1, -1 ]
  H(:, 92) = [ -1,  1, -1,  1,  1, -1,  1,  1 ]
  H(:, 93) = [ -1,  1, -1,  1,  1,  1, -1, -1 ]
  H(:, 94) = [ -1,  1, -1,  1,  1,  1, -1,  1 ]
  H(:, 95) = [ -1,  1, -1,  1,  1,  1,  1, -1 ]
  H(:, 96) = [ -1,  1, -1,  1,  1,  1,  1,  1 ]
  H(:, 97) = [ -1,  1,  1, -1, -1, -1, -1, -1 ]
  H(:, 98) = [ -1,  1,  1, -1, -1, -1, -1,  1 ]
  H(:, 99) = [ -1,  1,  1, -1, -1, -1,  1, -1 ]
  H(:,100) = [ -1,  1,  1, -1, -1, -1,  1,  1 ]
  H(:,101) = [ -1,  1,  1, -1, -1,  1, -1, -1 ]
  H(:,102) = [ -1,  1,  1, -1, -1,  1, -1,  1 ]
  H(:,103) = [ -1,  1,  1, -1, -1,  1,  1, -1 ]
  H(:,104) = [ -1,  1,  1, -1, -1,  1,  1,  1 ]
  H(:,105) = [ -1,  1,  1, -1,  1, -1, -1, -1 ]
  H(:,106) = [ -1,  1,  1, -1,  1, -1, -1,  1 ]
  H(:,107) = [ -1,  1,  1, -1,  1, -1,  1, -1 ]
  H(:,108) = [ -1,  1,  1, -1,  1, -1,  1,  1 ]
  H(:,109) = [ -1,  1,  1, -1,  1,  1, -1, -1 ]
  H(:,110) = [ -1,  1,  1, -1,  1,  1, -1,  1 ]
  H(:,111) = [ -1,  1,  1, -1,  1,  1,  1, -1 ]
  H(:,112) = [ -1,  1,  1, -1,  1,  1,  1,  1 ]
  H(:,113) = [ -1,  1,  1,  1, -1, -1, -1, -1 ]
  H(:,114) = [ -1,  1,  1,  1, -1, -1, -1,  1 ]
  H(:,115) = [ -1,  1,  1,  1, -1, -1,  1, -1 ]
  H(:,116) = [ -1,  1,  1,  1, -1, -1,  1,  1 ]
  H(:,117) = [ -1,  1,  1,  1, -1,  1, -1, -1 ]
  H(:,118) = [ -1,  1,  1,  1, -1,  1, -1,  1 ]
  H(:,119) = [ -1,  1,  1,  1, -1,  1,  1, -1 ]
  H(:,120) = [ -1,  1,  1,  1, -1,  1,  1,  1 ]
  H(:,121) = [ -1,  1,  1,  1,  1, -1, -1, -1 ]
  H(:,122) = [ -1,  1,  1,  1,  1, -1, -1,  1 ]
  H(:,123) = [ -1,  1,  1,  1,  1, -1,  1, -1 ]
  H(:,124) = [ -1,  1,  1,  1,  1, -1,  1,  1 ]
  H(:,125) = [ -1,  1,  1,  1,  1,  1, -1, -1 ]
  H(:,126) = [ -1,  1,  1,  1,  1,  1, -1,  1 ]
  H(:,127) = [ -1,  1,  1,  1,  1,  1,  1, -1 ]
  H(:,128) = [ -1,  1,  1,  1,  1,  1,  1,  1 ]
  H(:,129) = [  1, -1, -1, -1, -1, -1, -1, -1 ]
  H(:,130) = [  1, -1, -1, -1, -1, -1, -1,  1 ]
  H(:,131) = [  1, -1, -1, -1, -1, -1,  1, -1 ]
  H(:,132) = [  1, -1, -1, -1, -1, -1,  1,  1 ]
  H(:,133) = [  1, -1, -1, -1, -1,  1, -1, -1 ]
  H(:,134) = [  1, -1, -1, -1, -1,  1, -1,  1 ]
  H(:,135) = [  1, -1, -1, -1, -1,  1,  1, -1 ]
  H(:,136) = [  1, -1, -1, -1, -1,  1,  1,  1 ]
  H(:,137) = [  1, -1, -1, -1,  1, -1, -1, -1 ]
  H(:,138) = [  1, -1, -1, -1,  1, -1, -1,  1 ]
  H(:,139) = [  1, -1, -1, -1,  1, -1,  1, -1 ]
  H(:,140) = [  1, -1, -1, -1,  1, -1,  1,  1 ]
  H(:,141) = [  1, -1, -1, -1,  1,  1, -1, -1 ]
  H(:,142) = [  1, -1, -1, -1,  1,  1, -1,  1 ]
  H(:,143) = [  1, -1, -1, -1,  1,  1,  1, -1 ]
  H(:,144) = [  1, -1, -1, -1,  1,  1,  1,  1 ]
  H(:,145) = [  1, -1, -1,  1, -1, -1, -1, -1 ]
  H(:,146) = [  1, -1, -1,  1, -1, -1, -1,  1 ]
  H(:,147) = [  1, -1, -1,  1, -1, -1,  1, -1 ]
  H(:,148) = [  1, -1, -1,  1, -1, -1,  1,  1 ]
  H(:,149) = [  1, -1, -1,  1, -1,  1, -1, -1 ]
  H(:,150) = [  1, -1, -1,  1, -1,  1, -1,  1 ]
  H(:,151) = [  1, -1, -1,  1, -1,  1,  1, -1 ]
  H(:,152) = [  1, -1, -1,  1, -1,  1,  1,  1 ]
  H(:,153) = [  1, -1, -1,  1,  1, -1, -1, -1 ]
  H(:,154) = [  1, -1, -1,  1,  1, -1, -1,  1 ]
  H(:,155) = [  1, -1, -1,  1,  1, -1,  1, -1 ]
  H(:,156) = [  1, -1, -1,  1,  1, -1,  1,  1 ]
  H(:,157) = [  1, -1, -1,  1,  1,  1, -1, -1 ]
  H(:,158) = [  1, -1, -1,  1,  1,  1, -1,  1 ]
  H(:,159) = [  1, -1, -1,  1,  1,  1,  1, -1 ]
  H(:,160) = [  1, -1, -1,  1,  1,  1,  1,  1 ]
  H(:,161) = [  1, -1,  1, -1, -1, -1, -1, -1 ]
  H(:,162) = [  1, -1,  1, -1, -1, -1, -1,  1 ]
  H(:,163) = [  1, -1,  1, -1, -1, -1,  1, -1 ]
  H(:,164) = [  1, -1,  1, -1, -1, -1,  1,  1 ]
  H(:,165) = [  1, -1,  1, -1, -1,  1, -1, -1 ]
  H(:,166) = [  1, -1,  1, -1, -1,  1, -1,  1 ]
  H(:,167) = [  1, -1,  1, -1, -1,  1,  1, -1 ]
  H(:,168) = [  1, -1,  1, -1, -1,  1,  1,  1 ]
  H(:,169) = [  1, -1,  1, -1,  1, -1, -1, -1 ]
  H(:,170) = [  1, -1,  1, -1,  1, -1, -1,  1 ]
  H(:,171) = [  1, -1,  1, -1,  1, -1,  1, -1 ]
  H(:,172) = [  1, -1,  1, -1,  1, -1,  1,  1 ]
  H(:,173) = [  1, -1,  1, -1,  1,  1, -1, -1 ]
  H(:,174) = [  1, -1,  1, -1,  1,  1, -1,  1 ]
  H(:,175) = [  1, -1,  1, -1,  1,  1,  1, -1 ]
  H(:,176) = [  1, -1,  1, -1,  1,  1,  1,  1 ]
  H(:,177) = [  1, -1,  1,  1, -1, -1, -1, -1 ]
  H(:,178) = [  1, -1,  1,  1, -1, -1, -1,  1 ]
  H(:,179) = [  1, -1,  1,  1, -1, -1,  1, -1 ]
  H(:,180) = [  1, -1,  1,  1, -1, -1,  1,  1 ]
  H(:,181) = [  1, -1,  1,  1, -1,  1, -1, -1 ]
  H(:,182) = [  1, -1,  1,  1, -1,  1, -1,  1 ]
  H(:,183) = [  1, -1,  1,  1, -1,  1,  1, -1 ]
  H(:,184) = [  1, -1,  1,  1, -1,  1,  1,  1 ]
  H(:,185) = [  1, -1,  1,  1,  1, -1, -1, -1 ]
  H(:,186) = [  1, -1,  1,  1,  1, -1, -1,  1 ]
  H(:,187) = [  1, -1,  1,  1,  1, -1,  1, -1 ]
  H(:,188) = [  1, -1,  1,  1,  1, -1,  1,  1 ]
  H(:,189) = [  1, -1,  1,  1,  1,  1, -1, -1 ]
  H(:,190) = [  1, -1,  1,  1,  1,  1, -1,  1 ]
  H(:,191) = [  1, -1,  1,  1,  1,  1,  1, -1 ]
  H(:,192) = [  1, -1,  1,  1,  1,  1,  1,  1 ]
  H(:,193) = [  1,  1, -1, -1, -1, -1, -1, -1 ]
  H(:,194) = [  1,  1, -1, -1, -1, -1, -1,  1 ]
  H(:,195) = [  1,  1, -1, -1, -1, -1,  1, -1 ]
  H(:,196) = [  1,  1, -1, -1, -1, -1,  1,  1 ]
  H(:,197) = [  1,  1, -1, -1, -1,  1, -1, -1 ]
  H(:,198) = [  1,  1, -1, -1, -1,  1, -1,  1 ]
  H(:,199) = [  1,  1, -1, -1, -1,  1,  1, -1 ]
  H(:,200) = [  1,  1, -1, -1, -1,  1,  1,  1 ]
  H(:,201) = [  1,  1, -1, -1,  1, -1, -1, -1 ]
  H(:,202) = [  1,  1, -1, -1,  1, -1, -1,  1 ]
  H(:,203) = [  1,  1, -1, -1,  1, -1,  1, -1 ]
  H(:,204) = [  1,  1, -1, -1,  1, -1,  1,  1 ]
  H(:,205) = [  1,  1, -1, -1,  1,  1, -1, -1 ]
  H(:,206) = [  1,  1, -1, -1,  1,  1, -1,  1 ]
  H(:,207) = [  1,  1, -1, -1,  1,  1,  1, -1 ]
  H(:,208) = [  1,  1, -1, -1,  1,  1,  1,  1 ]
  H(:,209) = [  1,  1, -1,  1, -1, -1, -1, -1 ]
  H(:,210) = [  1,  1, -1,  1, -1, -1, -1,  1 ]
  H(:,211) = [  1,  1, -1,  1, -1, -1,  1, -1 ]
  H(:,212) = [  1,  1, -1,  1, -1, -1,  1,  1 ]
  H(:,213) = [  1,  1, -1,  1, -1,  1, -1, -1 ]
  H(:,214) = [  1,  1, -1,  1, -1,  1, -1,  1 ]
  H(:,215) = [  1,  1, -1,  1, -1,  1,  1, -1 ]
  H(:,216) = [  1,  1, -1,  1, -1,  1,  1,  1 ]
  H(:,217) = [  1,  1, -1,  1,  1, -1, -1, -1 ]
  H(:,218) = [  1,  1, -1,  1,  1, -1, -1,  1 ]
  H(:,219) = [  1,  1, -1,  1,  1, -1,  1, -1 ]
  H(:,220) = [  1,  1, -1,  1,  1, -1,  1,  1 ]
  H(:,221) = [  1,  1, -1,  1,  1,  1, -1, -1 ]
  H(:,222) = [  1,  1, -1,  1,  1,  1, -1,  1 ]
  H(:,223) = [  1,  1, -1,  1,  1,  1,  1, -1 ]
  H(:,224) = [  1,  1, -1,  1,  1,  1,  1,  1 ]
  H(:,225) = [  1,  1,  1, -1, -1, -1, -1, -1 ]
  H(:,226) = [  1,  1,  1, -1, -1, -1, -1,  1 ]
  H(:,227) = [  1,  1,  1, -1, -1, -1,  1, -1 ]
  H(:,228) = [  1,  1,  1, -1, -1, -1,  1,  1 ]
  H(:,229) = [  1,  1,  1, -1, -1,  1, -1, -1 ]
  H(:,230) = [  1,  1,  1, -1, -1,  1, -1,  1 ]
  H(:,231) = [  1,  1,  1, -1, -1,  1,  1, -1 ]
  H(:,232) = [  1,  1,  1, -1, -1,  1,  1,  1 ]
  H(:,233) = [  1,  1,  1, -1,  1, -1, -1, -1 ]
  H(:,234) = [  1,  1,  1, -1,  1, -1, -1,  1 ]
  H(:,235) = [  1,  1,  1, -1,  1, -1,  1, -1 ]
  H(:,236) = [  1,  1,  1, -1,  1, -1,  1,  1 ]
  H(:,237) = [  1,  1,  1, -1,  1,  1, -1, -1 ]
  H(:,238) = [  1,  1,  1, -1,  1,  1, -1,  1 ]
  H(:,239) = [  1,  1,  1, -1,  1,  1,  1, -1 ]
  H(:,240) = [  1,  1,  1, -1,  1,  1,  1,  1 ]
  H(:,241) = [  1,  1,  1,  1, -1, -1, -1, -1 ]
  H(:,242) = [  1,  1,  1,  1, -1, -1, -1,  1 ]
  H(:,243) = [  1,  1,  1,  1, -1, -1,  1, -1 ]
  H(:,244) = [  1,  1,  1,  1, -1, -1,  1,  1 ]
  H(:,245) = [  1,  1,  1,  1, -1,  1, -1, -1 ]
  H(:,246) = [  1,  1,  1,  1, -1,  1, -1,  1 ]
  H(:,247) = [  1,  1,  1,  1, -1,  1,  1, -1 ]
  H(:,248) = [  1,  1,  1,  1, -1,  1,  1,  1 ]
  H(:,249) = [  1,  1,  1,  1,  1, -1, -1, -1 ]
  H(:,250) = [  1,  1,  1,  1,  1, -1, -1,  1 ]
  H(:,251) = [  1,  1,  1,  1,  1, -1,  1, -1 ]
  H(:,252) = [  1,  1,  1,  1,  1, -1,  1,  1 ]
  H(:,253) = [  1,  1,  1,  1,  1,  1, -1, -1 ]
  H(:,254) = [  1,  1,  1,  1,  1,  1, -1,  1 ]
  H(:,255) = [  1,  1,  1,  1,  1,  1,  1, -1 ]
  H(:,256) = [  1,  1,  1,  1,  1,  1,  1,  1 ]

  end subroutine hel_init


  subroutine pol_init(pol) &
      & bind(c,name="ol_f_pol_init_ppllnnjj_ew_nexnmxemuudxdx_3")
    implicit none
    integer, intent(in) :: pol(8)
    POLSEL = pol
  end subroutine pol_init


  subroutine set_photons(photon_id) &
      & bind(c,name="ol_f_set_photons_ppllnnjj_ew_nexnmxemuudxdx_3")
    implicit none
    integer, intent(in) :: photon_id(8)
    photonid_ppllnnjj_ew_nexnmxemuudxdx_3 = photon_id
  end subroutine set_photons


end module ol_external_ppllnnjj_ew_nexnmxemuudxdx_3


module ol_settings_ppllnnjj_ew_nexnmxemuudxdx_3
  implicit none
  ! Activates optimized helicity bookkeeping. Default=false
    logical, save :: hel_mem_opt = .false.
  ! Calculate loop correlators
    logical, save :: loopcc = .false.

  contains

  subroutine set_hel_mem_opt(set) &
      & bind(c,name="ol_hel_mem_opt_ppllnnjj_ew_nexnmxemuudxdx_3")
    implicit none
    logical, intent(in) :: set
    hel_mem_opt = set
  end subroutine set_hel_mem_opt

  subroutine set_loopcc(set,was) &
      & bind(c,name="ol_loopcc_ppllnnjj_ew_nexnmxemuudxdx_3")
    implicit none
    logical, intent(in) :: set
    logical :: was
    was = loopcc
    loopcc = set
  end subroutine set_loopcc

end module ol_settings_ppllnnjj_ew_nexnmxemuudxdx_3

module colour_basis_ppllnnjj_ew_nexnmxemuudxdx_3
  implicit none
  ! tree colour basis
  integer, save :: extcolours(8) = [0,0,0,0,1,1,1,1]
  contains

  pure subroutine tree_colbasis_dim(extcols, ncolb, ncoupl, maxpows, nhel) &
    & bind(c, name="ol_tree_colbasis_dim_ppllnnjj_ew_nexnmxemuudxdx_3")
    implicit none
    ! colour representation of external particles: 0=neutral, 1=fundamental, 2=adjoint
    integer, intent(out) :: extcols(8)
    ! number of tree colour basis elements; number of selected couplings, number of selected powers per coupling
    integer, intent(out) :: ncolb, ncoupl, maxpows
    ! number of helicity configurations (all, not just non-vanishing)
    integer, intent(out) :: nhel
    extcols = extcolours
    ncolb = 4
    ncoupl = 1
    maxpows = 1
    nhel = 256
  end subroutine tree_colbasis_dim

  subroutine tree_colbasis(basis, powers) &
    & bind(c, name="ol_tree_colbasis_ppllnnjj_ew_nexnmxemuudxdx_3")
    implicit none
    integer, intent(out) :: powers(1,1)
    integer, intent(out) :: basis(3,4)
#if 1 > 0
    ! selected powers for each selected coupling
    powers = reshape([12], [1,1])
#endif
#if 4 > 0
    ! tree colour basis: [[composition_number, permutation_number, *coupling_powers], ...]
    basis = reshape( &
      [1,16,4,1,16,6,1,14,4,1,14,6], &
      [3,4])
#endif
  end subroutine tree_colbasis

end module colour_basis_ppllnnjj_ew_nexnmxemuudxdx_3

! **********************************************************************
module ol_heltables_OLR_ppllnnjj_ew_nexnmxemuudxdx_3
! **********************************************************************
  use KIND_TYPES, only: intkind2
  implicit none

  logical :: heltables_not_init = .true.

  ! helicity states of external particles
  ! integer, save :: &
  !   H1(2) = [-1,1], &
  !   H2(3) = [-1,0,1]
  !   ...
  integer, save :: &
    H1(2) = [-1,1], &
    H2(2) = [-1,1], &
    H3(2) = [-1,1], &
    H4(2) = [-1,1], &
    H5(2) = [-1,1], &
    H6(2) = [-1,1], &
    H7(2) = [-1,1], &
    H8(2) = [-1,1]

  ! number of helicity states for wave functions returned by a propagator call: n2(sz)
  ! number of helicity states for wave functions in a v-point vertex call (v >= 3)
  ! or a contraction (v = 3): n<v>(v,sz)
  integer(intkind2), save :: n2(584), n3(3,5160), n4(4,16)

  ! helicity tables used in the construction of the h helicity states of a wave function (amplitude)
  ! from an v-point vertex (contraction): t<v>x<h>(v-1,h,sz)
  integer(intkind2), save :: t3x4(2,4,16), t3x8(2,8,96), t3x32(2,32,368), t3x16(2,16,560), t3x64(2,64,592), t3x256(2,256,3528), &
    t4x64(3,64,16)

  ! change of global-helicity state resulting from flip of individual-particle helicity
  integer(intkind2), save :: eflip(256,8)
  integer,           save :: exthel(256,8)
  integer,           save :: firstpol(8)

  contains

! **********************************************************************
subroutine init_heltables
! **********************************************************************
  use ol_helicity_init, only: heltable
  implicit none

  ! I/O helicity tables for vertices, propagators and contractions;
  ! helicity table for a vertex call: n_in/n_out are the number helicity states of the incoming/outgoing wave functions
  ! call heltable([<n_in1>, <n_in2>, ..., <n_out>], n, t)
  ! propagators only need the number of helicity configurations which is equal for the incoming and outgoing wave function
  ! n = <n>
  call heltable([2,2,4], n3(:,1), t3x4(:,:,1))
  call heltable([2,2,4], n3(:,2), t3x4(:,:,2))
  call heltable([2,2,4], n3(:,3), t3x4(:,:,3))
  call heltable([2,2,4], n3(:,4), t3x4(:,:,4))
  call heltable([4,4,4,64], n4(:,1), t4x64(:,:,1))
  call heltable([2,2,4], n3(:,5), t3x4(:,:,5))
  call heltable([2,2,4], n3(:,6), t3x4(:,:,6))
  call heltable([4,4,4,64], n4(:,2), t4x64(:,:,2))
  call heltable([4,4,16], n3(:,7), t3x16(:,:,1))
  call heltable([4,4,16], n3(:,8), t3x16(:,:,2))
  call heltable([4,4,16], n3(:,9), t3x16(:,:,3))
  call heltable([4,4,16], n3(:,10), t3x16(:,:,4))
  call heltable([4,4,16], n3(:,11), t3x16(:,:,5))
  call heltable([4,4,16], n3(:,12), t3x16(:,:,6))
  call heltable([4,4,16], n3(:,13), t3x16(:,:,7))
  call heltable([4,4,16], n3(:,14), t3x16(:,:,8))
  call heltable([4,2,8], n3(:,15), t3x8(:,:,1))
  call heltable([2,4,8], n3(:,16), t3x8(:,:,2))
  n2(1) = 8
  n2(2) = 8
  call heltable([4,8,32], n3(:,17), t3x32(:,:,1))
  call heltable([8,2,16], n3(:,18), t3x16(:,:,9))
  call heltable([8,2,16], n3(:,19), t3x16(:,:,10))
  call heltable([4,2,8], n3(:,20), t3x8(:,:,3))
  call heltable([2,4,8], n3(:,21), t3x8(:,:,4))
  n2(3) = 8
  n2(4) = 8
  call heltable([4,8,32], n3(:,22), t3x32(:,:,2))
  call heltable([2,8,16], n3(:,23), t3x16(:,:,11))
  call heltable([2,8,16], n3(:,24), t3x16(:,:,12))
  call heltable([8,2,16], n3(:,25), t3x16(:,:,13))
  call heltable([8,2,16], n3(:,26), t3x16(:,:,14))
  call heltable([2,8,16], n3(:,27), t3x16(:,:,15))
  call heltable([2,8,16], n3(:,28), t3x16(:,:,16))
  call heltable([4,4,16], n3(:,29), t3x16(:,:,17))
  call heltable([4,4,16], n3(:,30), t3x16(:,:,18))
  call heltable([4,4,16], n3(:,31), t3x16(:,:,19))
  call heltable([4,4,16], n3(:,32), t3x16(:,:,20))
  call heltable([4,4,16], n3(:,33), t3x16(:,:,21))
  call heltable([4,4,16], n3(:,34), t3x16(:,:,22))
  call heltable([4,4,16], n3(:,35), t3x16(:,:,23))
  call heltable([4,4,16], n3(:,36), t3x16(:,:,24))
  call heltable([4,2,8], n3(:,37), t3x8(:,:,5))
  n2(5) = 8
  call heltable([4,8,32], n3(:,38), t3x32(:,:,3))
  call heltable([8,2,16], n3(:,39), t3x16(:,:,25))
  call heltable([8,2,16], n3(:,40), t3x16(:,:,26))
  call heltable([4,2,8], n3(:,41), t3x8(:,:,6))
  n2(6) = 8
  call heltable([4,8,32], n3(:,42), t3x32(:,:,4))
  call heltable([2,8,16], n3(:,43), t3x16(:,:,27))
  call heltable([2,8,16], n3(:,44), t3x16(:,:,28))
  call heltable([8,2,16], n3(:,45), t3x16(:,:,29))
  call heltable([8,2,16], n3(:,46), t3x16(:,:,30))
  call heltable([2,8,16], n3(:,47), t3x16(:,:,31))
  call heltable([2,8,16], n3(:,48), t3x16(:,:,32))
  call heltable([2,4,8], n3(:,49), t3x8(:,:,7))
  n2(7) = 8
  call heltable([4,8,32], n3(:,50), t3x32(:,:,5))
  call heltable([8,2,16], n3(:,51), t3x16(:,:,33))
  call heltable([8,2,16], n3(:,52), t3x16(:,:,34))
  call heltable([2,4,8], n3(:,53), t3x8(:,:,8))
  n2(8) = 8
  call heltable([4,8,32], n3(:,54), t3x32(:,:,6))
  call heltable([2,8,16], n3(:,55), t3x16(:,:,35))
  call heltable([2,8,16], n3(:,56), t3x16(:,:,36))
  call heltable([8,2,16], n3(:,57), t3x16(:,:,37))
  call heltable([8,2,16], n3(:,58), t3x16(:,:,38))
  call heltable([2,8,16], n3(:,59), t3x16(:,:,39))
  call heltable([2,8,16], n3(:,60), t3x16(:,:,40))
  call heltable([4,8,32], n3(:,61), t3x32(:,:,7))
  call heltable([8,2,16], n3(:,62), t3x16(:,:,41))
  call heltable([8,2,16], n3(:,63), t3x16(:,:,42))
  call heltable([4,8,32], n3(:,64), t3x32(:,:,8))
  call heltable([2,8,16], n3(:,65), t3x16(:,:,43))
  call heltable([2,8,16], n3(:,66), t3x16(:,:,44))
  call heltable([8,2,16], n3(:,67), t3x16(:,:,45))
  call heltable([8,2,16], n3(:,68), t3x16(:,:,46))
  call heltable([2,8,16], n3(:,69), t3x16(:,:,47))
  call heltable([2,8,16], n3(:,70), t3x16(:,:,48))
  call heltable([2,4,8], n3(:,71), t3x8(:,:,9))
  n2(9) = 8
  call heltable([2,8,16], n3(:,72), t3x16(:,:,49))
  call heltable([2,8,16], n3(:,73), t3x16(:,:,50))
  call heltable([2,4,8], n3(:,74), t3x8(:,:,10))
  n2(10) = 8
  call heltable([2,8,16], n3(:,75), t3x16(:,:,51))
  call heltable([2,8,16], n3(:,76), t3x16(:,:,52))
  call heltable([4,2,8], n3(:,77), t3x8(:,:,11))
  n2(11) = 8
  call heltable([8,2,16], n3(:,78), t3x16(:,:,53))
  call heltable([4,2,8], n3(:,79), t3x8(:,:,12))
  n2(12) = 8
  call heltable([8,2,16], n3(:,80), t3x16(:,:,54))
  call heltable([8,4,32], n3(:,81), t3x32(:,:,9))
  call heltable([8,4,32], n3(:,82), t3x32(:,:,10))
  call heltable([2,4,8], n3(:,83), t3x8(:,:,13))
  n2(13) = 8
  call heltable([2,8,16], n3(:,84), t3x16(:,:,55))
  call heltable([2,8,16], n3(:,85), t3x16(:,:,56))
  call heltable([2,4,8], n3(:,86), t3x8(:,:,14))
  n2(14) = 8
  call heltable([2,8,16], n3(:,87), t3x16(:,:,57))
  call heltable([2,8,16], n3(:,88), t3x16(:,:,58))
  call heltable([4,2,8], n3(:,89), t3x8(:,:,15))
  n2(15) = 8
  call heltable([8,2,16], n3(:,90), t3x16(:,:,59))
  call heltable([4,2,8], n3(:,91), t3x8(:,:,16))
  n2(16) = 8
  call heltable([8,2,16], n3(:,92), t3x16(:,:,60))
  call heltable([8,4,32], n3(:,93), t3x32(:,:,11))
  call heltable([8,4,32], n3(:,94), t3x32(:,:,12))
  call heltable([2,4,8], n3(:,95), t3x8(:,:,17))
  n2(17) = 8
  call heltable([2,8,16], n3(:,96), t3x16(:,:,61))
  call heltable([2,8,16], n3(:,97), t3x16(:,:,62))
  call heltable([2,4,8], n3(:,98), t3x8(:,:,18))
  n2(18) = 8
  call heltable([2,8,16], n3(:,99), t3x16(:,:,63))
  call heltable([2,8,16], n3(:,100), t3x16(:,:,64))
  call heltable([4,2,8], n3(:,101), t3x8(:,:,19))
  n2(19) = 8
  call heltable([8,2,16], n3(:,102), t3x16(:,:,65))
  call heltable([4,2,8], n3(:,103), t3x8(:,:,20))
  n2(20) = 8
  call heltable([8,2,16], n3(:,104), t3x16(:,:,66))
  call heltable([8,4,32], n3(:,105), t3x32(:,:,13))
  call heltable([8,4,32], n3(:,106), t3x32(:,:,14))
  call heltable([2,4,8], n3(:,107), t3x8(:,:,21))
  n2(21) = 8
  call heltable([2,8,16], n3(:,108), t3x16(:,:,67))
  call heltable([2,8,16], n3(:,109), t3x16(:,:,68))
  call heltable([2,4,8], n3(:,110), t3x8(:,:,22))
  n2(22) = 8
  call heltable([2,8,16], n3(:,111), t3x16(:,:,69))
  call heltable([2,8,16], n3(:,112), t3x16(:,:,70))
  call heltable([4,2,8], n3(:,113), t3x8(:,:,23))
  n2(23) = 8
  call heltable([8,2,16], n3(:,114), t3x16(:,:,71))
  call heltable([4,2,8], n3(:,115), t3x8(:,:,24))
  n2(24) = 8
  call heltable([8,2,16], n3(:,116), t3x16(:,:,72))
  call heltable([8,4,32], n3(:,117), t3x32(:,:,15))
  call heltable([8,4,32], n3(:,118), t3x32(:,:,16))
  call heltable([4,4,4,64], n4(:,3), t4x64(:,:,3))
  call heltable([4,4,4,64], n4(:,4), t4x64(:,:,4))
  call heltable([2,2,4], n3(:,119), t3x4(:,:,7))
  call heltable([2,2,4], n3(:,120), t3x4(:,:,8))
  call heltable([2,2,4], n3(:,121), t3x4(:,:,9))
  call heltable([4,4,4,64], n4(:,5), t4x64(:,:,5))
  call heltable([2,2,4], n3(:,122), t3x4(:,:,10))
  call heltable([4,4,4,64], n4(:,6), t4x64(:,:,6))
  call heltable([2,2,4], n3(:,123), t3x4(:,:,11))
  call heltable([4,4,4,64], n4(:,7), t4x64(:,:,7))
  call heltable([4,4,4,64], n4(:,8), t4x64(:,:,8))
  call heltable([2,2,4], n3(:,124), t3x4(:,:,12))
  call heltable([4,4,4,64], n4(:,9), t4x64(:,:,9))
  call heltable([4,4,4,64], n4(:,10), t4x64(:,:,10))
  call heltable([4,4,16], n3(:,125), t3x16(:,:,73))
  call heltable([4,4,16], n3(:,126), t3x16(:,:,74))
  call heltable([4,4,16], n3(:,127), t3x16(:,:,75))
  call heltable([4,4,16], n3(:,128), t3x16(:,:,76))
  call heltable([4,4,16], n3(:,129), t3x16(:,:,77))
  call heltable([4,4,16], n3(:,130), t3x16(:,:,78))
  call heltable([4,4,16], n3(:,131), t3x16(:,:,79))
  call heltable([4,4,16], n3(:,132), t3x16(:,:,80))
  call heltable([4,4,4,64], n4(:,11), t4x64(:,:,11))
  n2(25) = 4
  call heltable([4,4,4,64], n4(:,12), t4x64(:,:,12))
  n2(26) = 4
  call heltable([4,4,4,64], n4(:,13), t4x64(:,:,13))
  n2(27) = 4
  n2(28) = 4
  call heltable([4,8,32], n3(:,133), t3x32(:,:,17))
  call heltable([4,8,32], n3(:,134), t3x32(:,:,18))
  call heltable([8,2,16], n3(:,135), t3x16(:,:,81))
  call heltable([8,2,16], n3(:,136), t3x16(:,:,82))
  call heltable([8,2,16], n3(:,137), t3x16(:,:,83))
  call heltable([8,2,16], n3(:,138), t3x16(:,:,84))
  call heltable([2,4,8], n3(:,139), t3x8(:,:,25))
  n2(29) = 8
  call heltable([8,2,16], n3(:,140), t3x16(:,:,85))
  call heltable([8,2,16], n3(:,141), t3x16(:,:,86))
  call heltable([8,2,16], n3(:,142), t3x16(:,:,87))
  call heltable([8,2,16], n3(:,143), t3x16(:,:,88))
  call heltable([2,8,16], n3(:,144), t3x16(:,:,89))
  call heltable([2,8,16], n3(:,145), t3x16(:,:,90))
  call heltable([2,4,8], n3(:,146), t3x8(:,:,26))
  n2(30) = 8
  call heltable([2,8,16], n3(:,147), t3x16(:,:,91))
  call heltable([2,8,16], n3(:,148), t3x16(:,:,92))
  call heltable([4,4,16], n3(:,149), t3x16(:,:,93))
  call heltable([4,4,16], n3(:,150), t3x16(:,:,94))
  call heltable([4,4,16], n3(:,151), t3x16(:,:,95))
  call heltable([4,4,16], n3(:,152), t3x16(:,:,96))
  call heltable([4,4,16], n3(:,153), t3x16(:,:,97))
  call heltable([4,4,16], n3(:,154), t3x16(:,:,98))
  call heltable([4,4,16], n3(:,155), t3x16(:,:,99))
  call heltable([4,4,16], n3(:,156), t3x16(:,:,100))
  call heltable([4,4,4,64], n4(:,14), t4x64(:,:,14))
  call heltable([4,4,4,64], n4(:,15), t4x64(:,:,15))
  call heltable([4,4,4,64], n4(:,16), t4x64(:,:,16))
  n2(31) = 4
  n2(32) = 4
  call heltable([4,8,32], n3(:,157), t3x32(:,:,19))
  call heltable([4,8,32], n3(:,158), t3x32(:,:,20))
  call heltable([8,2,16], n3(:,159), t3x16(:,:,101))
  call heltable([8,2,16], n3(:,160), t3x16(:,:,102))
  call heltable([8,2,16], n3(:,161), t3x16(:,:,103))
  call heltable([8,2,16], n3(:,162), t3x16(:,:,104))
  call heltable([8,2,16], n3(:,163), t3x16(:,:,105))
  call heltable([8,2,16], n3(:,164), t3x16(:,:,106))
  call heltable([8,2,16], n3(:,165), t3x16(:,:,107))
  call heltable([8,2,16], n3(:,166), t3x16(:,:,108))
  call heltable([2,8,16], n3(:,167), t3x16(:,:,109))
  call heltable([2,8,16], n3(:,168), t3x16(:,:,110))
  call heltable([2,8,16], n3(:,169), t3x16(:,:,111))
  call heltable([2,8,16], n3(:,170), t3x16(:,:,112))
  call heltable([4,8,32], n3(:,171), t3x32(:,:,21))
  call heltable([4,8,32], n3(:,172), t3x32(:,:,22))
  call heltable([4,8,32], n3(:,173), t3x32(:,:,23))
  call heltable([4,8,32], n3(:,174), t3x32(:,:,24))
  call heltable([8,2,16], n3(:,175), t3x16(:,:,113))
  call heltable([8,2,16], n3(:,176), t3x16(:,:,114))
  call heltable([8,2,16], n3(:,177), t3x16(:,:,115))
  call heltable([8,2,16], n3(:,178), t3x16(:,:,116))
  call heltable([8,2,16], n3(:,179), t3x16(:,:,117))
  call heltable([8,2,16], n3(:,180), t3x16(:,:,118))
  call heltable([8,2,16], n3(:,181), t3x16(:,:,119))
  call heltable([8,2,16], n3(:,182), t3x16(:,:,120))
  call heltable([2,4,8], n3(:,183), t3x8(:,:,27))
  n2(33) = 8
  call heltable([8,2,16], n3(:,184), t3x16(:,:,121))
  call heltable([8,2,16], n3(:,185), t3x16(:,:,122))
  call heltable([8,2,16], n3(:,186), t3x16(:,:,123))
  call heltable([8,2,16], n3(:,187), t3x16(:,:,124))
  call heltable([2,8,16], n3(:,188), t3x16(:,:,125))
  call heltable([2,8,16], n3(:,189), t3x16(:,:,126))
  call heltable([2,4,8], n3(:,190), t3x8(:,:,28))
  n2(34) = 8
  call heltable([2,8,16], n3(:,191), t3x16(:,:,127))
  call heltable([2,8,16], n3(:,192), t3x16(:,:,128))
  call heltable([8,2,16], n3(:,193), t3x16(:,:,129))
  call heltable([8,2,16], n3(:,194), t3x16(:,:,130))
  call heltable([8,2,16], n3(:,195), t3x16(:,:,131))
  call heltable([8,2,16], n3(:,196), t3x16(:,:,132))
  call heltable([8,2,16], n3(:,197), t3x16(:,:,133))
  call heltable([8,2,16], n3(:,198), t3x16(:,:,134))
  call heltable([8,2,16], n3(:,199), t3x16(:,:,135))
  call heltable([8,2,16], n3(:,200), t3x16(:,:,136))
  call heltable([2,8,16], n3(:,201), t3x16(:,:,137))
  call heltable([2,8,16], n3(:,202), t3x16(:,:,138))
  call heltable([2,8,16], n3(:,203), t3x16(:,:,139))
  call heltable([2,8,16], n3(:,204), t3x16(:,:,140))
  call heltable([8,2,16], n3(:,205), t3x16(:,:,141))
  call heltable([8,2,16], n3(:,206), t3x16(:,:,142))
  call heltable([8,2,16], n3(:,207), t3x16(:,:,143))
  call heltable([8,2,16], n3(:,208), t3x16(:,:,144))
  call heltable([2,8,16], n3(:,209), t3x16(:,:,145))
  call heltable([2,8,16], n3(:,210), t3x16(:,:,146))
  call heltable([2,8,16], n3(:,211), t3x16(:,:,147))
  call heltable([2,8,16], n3(:,212), t3x16(:,:,148))
  call heltable([4,2,8], n3(:,213), t3x8(:,:,29))
  n2(35) = 8
  call heltable([4,8,32], n3(:,214), t3x32(:,:,25))
  call heltable([2,8,16], n3(:,215), t3x16(:,:,149))
  call heltable([2,8,16], n3(:,216), t3x16(:,:,150))
  call heltable([2,8,16], n3(:,217), t3x16(:,:,151))
  call heltable([2,8,16], n3(:,218), t3x16(:,:,152))
  call heltable([8,2,16], n3(:,219), t3x16(:,:,153))
  call heltable([8,2,16], n3(:,220), t3x16(:,:,154))
  call heltable([4,2,8], n3(:,221), t3x8(:,:,30))
  n2(36) = 8
  call heltable([4,8,32], n3(:,222), t3x32(:,:,26))
  call heltable([8,2,16], n3(:,223), t3x16(:,:,155))
  call heltable([8,2,16], n3(:,224), t3x16(:,:,156))
  call heltable([2,2,4], n3(:,225), t3x4(:,:,13))
  call heltable([4,4,16], n3(:,226), t3x16(:,:,157))
  call heltable([4,4,16], n3(:,227), t3x16(:,:,158))
  call heltable([4,4,16], n3(:,228), t3x16(:,:,159))
  call heltable([4,4,16], n3(:,229), t3x16(:,:,160))
  call heltable([4,4,16], n3(:,230), t3x16(:,:,161))
  call heltable([4,4,16], n3(:,231), t3x16(:,:,162))
  call heltable([4,4,16], n3(:,232), t3x16(:,:,163))
  call heltable([4,4,16], n3(:,233), t3x16(:,:,164))
  call heltable([2,8,16], n3(:,234), t3x16(:,:,165))
  call heltable([2,8,16], n3(:,235), t3x16(:,:,166))
  call heltable([2,8,16], n3(:,236), t3x16(:,:,167))
  call heltable([2,8,16], n3(:,237), t3x16(:,:,168))
  call heltable([4,8,32], n3(:,238), t3x32(:,:,27))
  call heltable([2,8,16], n3(:,239), t3x16(:,:,169))
  call heltable([2,8,16], n3(:,240), t3x16(:,:,170))
  call heltable([2,8,16], n3(:,241), t3x16(:,:,171))
  call heltable([2,8,16], n3(:,242), t3x16(:,:,172))
  call heltable([8,2,16], n3(:,243), t3x16(:,:,173))
  call heltable([8,2,16], n3(:,244), t3x16(:,:,174))
  call heltable([4,8,32], n3(:,245), t3x32(:,:,28))
  call heltable([8,2,16], n3(:,246), t3x16(:,:,175))
  call heltable([8,2,16], n3(:,247), t3x16(:,:,176))
  call heltable([2,8,16], n3(:,248), t3x16(:,:,177))
  call heltable([2,8,16], n3(:,249), t3x16(:,:,178))
  call heltable([2,8,16], n3(:,250), t3x16(:,:,179))
  call heltable([2,8,16], n3(:,251), t3x16(:,:,180))
  call heltable([4,8,32], n3(:,252), t3x32(:,:,29))
  call heltable([4,8,32], n3(:,253), t3x32(:,:,30))
  call heltable([2,2,4], n3(:,254), t3x4(:,:,14))
  call heltable([4,4,16], n3(:,255), t3x16(:,:,181))
  call heltable([4,4,16], n3(:,256), t3x16(:,:,182))
  call heltable([4,4,16], n3(:,257), t3x16(:,:,183))
  call heltable([4,4,16], n3(:,258), t3x16(:,:,184))
  call heltable([4,4,16], n3(:,259), t3x16(:,:,185))
  call heltable([4,4,16], n3(:,260), t3x16(:,:,186))
  call heltable([4,4,16], n3(:,261), t3x16(:,:,187))
  call heltable([4,4,16], n3(:,262), t3x16(:,:,188))
  call heltable([4,8,32], n3(:,263), t3x32(:,:,31))
  call heltable([4,8,32], n3(:,264), t3x32(:,:,32))
  call heltable([2,8,16], n3(:,265), t3x16(:,:,189))
  call heltable([2,8,16], n3(:,266), t3x16(:,:,190))
  call heltable([2,8,16], n3(:,267), t3x16(:,:,191))
  call heltable([2,8,16], n3(:,268), t3x16(:,:,192))
  call heltable([4,2,8], n3(:,269), t3x8(:,:,31))
  n2(37) = 8
  call heltable([4,8,32], n3(:,270), t3x32(:,:,33))
  call heltable([2,8,16], n3(:,271), t3x16(:,:,193))
  call heltable([2,8,16], n3(:,272), t3x16(:,:,194))
  call heltable([2,8,16], n3(:,273), t3x16(:,:,195))
  call heltable([2,8,16], n3(:,274), t3x16(:,:,196))
  call heltable([8,2,16], n3(:,275), t3x16(:,:,197))
  call heltable([8,2,16], n3(:,276), t3x16(:,:,198))
  call heltable([4,2,8], n3(:,277), t3x8(:,:,32))
  n2(38) = 8
  call heltable([4,8,32], n3(:,278), t3x32(:,:,34))
  call heltable([8,2,16], n3(:,279), t3x16(:,:,199))
  call heltable([8,2,16], n3(:,280), t3x16(:,:,200))
  call heltable([2,2,4], n3(:,281), t3x4(:,:,15))
  call heltable([4,4,16], n3(:,282), t3x16(:,:,201))
  call heltable([4,4,16], n3(:,283), t3x16(:,:,202))
  call heltable([4,4,16], n3(:,284), t3x16(:,:,203))
  call heltable([4,4,16], n3(:,285), t3x16(:,:,204))
  call heltable([4,4,16], n3(:,286), t3x16(:,:,205))
  call heltable([4,4,16], n3(:,287), t3x16(:,:,206))
  call heltable([4,4,16], n3(:,288), t3x16(:,:,207))
  call heltable([4,4,16], n3(:,289), t3x16(:,:,208))
  call heltable([2,8,16], n3(:,290), t3x16(:,:,209))
  call heltable([2,8,16], n3(:,291), t3x16(:,:,210))
  call heltable([2,8,16], n3(:,292), t3x16(:,:,211))
  call heltable([2,8,16], n3(:,293), t3x16(:,:,212))
  call heltable([4,8,32], n3(:,294), t3x32(:,:,35))
  call heltable([2,8,16], n3(:,295), t3x16(:,:,213))
  call heltable([2,8,16], n3(:,296), t3x16(:,:,214))
  call heltable([2,8,16], n3(:,297), t3x16(:,:,215))
  call heltable([2,8,16], n3(:,298), t3x16(:,:,216))
  call heltable([8,2,16], n3(:,299), t3x16(:,:,217))
  call heltable([8,2,16], n3(:,300), t3x16(:,:,218))
  call heltable([4,8,32], n3(:,301), t3x32(:,:,36))
  call heltable([8,2,16], n3(:,302), t3x16(:,:,219))
  call heltable([8,2,16], n3(:,303), t3x16(:,:,220))
  call heltable([2,8,16], n3(:,304), t3x16(:,:,221))
  call heltable([2,8,16], n3(:,305), t3x16(:,:,222))
  call heltable([2,8,16], n3(:,306), t3x16(:,:,223))
  call heltable([2,8,16], n3(:,307), t3x16(:,:,224))
  call heltable([4,8,32], n3(:,308), t3x32(:,:,37))
  call heltable([4,8,32], n3(:,309), t3x32(:,:,38))
  call heltable([2,2,4], n3(:,310), t3x4(:,:,16))
  call heltable([4,4,16], n3(:,311), t3x16(:,:,225))
  call heltable([4,4,16], n3(:,312), t3x16(:,:,226))
  call heltable([4,4,16], n3(:,313), t3x16(:,:,227))
  call heltable([4,4,16], n3(:,314), t3x16(:,:,228))
  call heltable([4,4,16], n3(:,315), t3x16(:,:,229))
  call heltable([4,4,16], n3(:,316), t3x16(:,:,230))
  call heltable([4,4,16], n3(:,317), t3x16(:,:,231))
  call heltable([4,4,16], n3(:,318), t3x16(:,:,232))
  call heltable([4,8,32], n3(:,319), t3x32(:,:,39))
  call heltable([4,8,32], n3(:,320), t3x32(:,:,40))
  call heltable([8,4,32], n3(:,321), t3x32(:,:,41))
  call heltable([8,4,32], n3(:,322), t3x32(:,:,42))
  call heltable([8,4,32], n3(:,323), t3x32(:,:,43))
  call heltable([8,4,32], n3(:,324), t3x32(:,:,44))
  call heltable([4,2,8], n3(:,325), t3x8(:,:,33))
  n2(39) = 8
  call heltable([8,2,16], n3(:,326), t3x16(:,:,233))
  call heltable([2,4,8], n3(:,327), t3x8(:,:,34))
  n2(40) = 8
  call heltable([2,8,16], n3(:,328), t3x16(:,:,234))
  call heltable([2,8,16], n3(:,329), t3x16(:,:,235))
  call heltable([8,4,32], n3(:,330), t3x32(:,:,45))
  call heltable([4,2,8], n3(:,331), t3x8(:,:,35))
  n2(41) = 8
  call heltable([8,2,16], n3(:,332), t3x16(:,:,236))
  call heltable([2,4,8], n3(:,333), t3x8(:,:,36))
  n2(42) = 8
  call heltable([2,8,16], n3(:,334), t3x16(:,:,237))
  call heltable([2,8,16], n3(:,335), t3x16(:,:,238))
  call heltable([8,4,32], n3(:,336), t3x32(:,:,46))
  call heltable([4,2,8], n3(:,337), t3x8(:,:,37))
  n2(43) = 8
  call heltable([8,2,16], n3(:,338), t3x16(:,:,239))
  call heltable([2,4,8], n3(:,339), t3x8(:,:,38))
  n2(44) = 8
  call heltable([2,8,16], n3(:,340), t3x16(:,:,240))
  call heltable([2,8,16], n3(:,341), t3x16(:,:,241))
  call heltable([8,4,32], n3(:,342), t3x32(:,:,47))
  call heltable([4,2,8], n3(:,343), t3x8(:,:,39))
  n2(45) = 8
  call heltable([8,2,16], n3(:,344), t3x16(:,:,242))
  call heltable([2,4,8], n3(:,345), t3x8(:,:,40))
  n2(46) = 8
  call heltable([2,8,16], n3(:,346), t3x16(:,:,243))
  call heltable([2,8,16], n3(:,347), t3x16(:,:,244))
  call heltable([8,4,32], n3(:,348), t3x32(:,:,48))
  call heltable([4,2,8], n3(:,349), t3x8(:,:,41))
  n2(47) = 8
  call heltable([4,2,8], n3(:,350), t3x8(:,:,42))
  n2(48) = 8
  call heltable([2,8,16], n3(:,351), t3x16(:,:,245))
  call heltable([2,8,16], n3(:,352), t3x16(:,:,246))
  call heltable([2,8,16], n3(:,353), t3x16(:,:,247))
  call heltable([2,8,16], n3(:,354), t3x16(:,:,248))
  call heltable([8,2,16], n3(:,355), t3x16(:,:,249))
  call heltable([8,2,16], n3(:,356), t3x16(:,:,250))
  call heltable([4,2,8], n3(:,357), t3x8(:,:,43))
  n2(49) = 8
  call heltable([4,2,8], n3(:,358), t3x8(:,:,44))
  n2(50) = 8
  call heltable([2,8,16], n3(:,359), t3x16(:,:,251))
  call heltable([2,8,16], n3(:,360), t3x16(:,:,252))
  call heltable([2,8,16], n3(:,361), t3x16(:,:,253))
  call heltable([2,8,16], n3(:,362), t3x16(:,:,254))
  call heltable([8,2,16], n3(:,363), t3x16(:,:,255))
  call heltable([8,2,16], n3(:,364), t3x16(:,:,256))
  call heltable([8,4,32], n3(:,365), t3x32(:,:,49))
  call heltable([8,4,32], n3(:,366), t3x32(:,:,50))
  call heltable([8,4,32], n3(:,367), t3x32(:,:,51))
  call heltable([8,4,32], n3(:,368), t3x32(:,:,52))
  call heltable([4,2,8], n3(:,369), t3x8(:,:,45))
  n2(51) = 8
  call heltable([8,2,16], n3(:,370), t3x16(:,:,257))
  call heltable([2,4,8], n3(:,371), t3x8(:,:,46))
  n2(52) = 8
  call heltable([2,8,16], n3(:,372), t3x16(:,:,258))
  call heltable([2,8,16], n3(:,373), t3x16(:,:,259))
  call heltable([8,4,32], n3(:,374), t3x32(:,:,53))
  call heltable([4,2,8], n3(:,375), t3x8(:,:,47))
  n2(53) = 8
  call heltable([8,2,16], n3(:,376), t3x16(:,:,260))
  call heltable([2,4,8], n3(:,377), t3x8(:,:,48))
  n2(54) = 8
  call heltable([2,8,16], n3(:,378), t3x16(:,:,261))
  call heltable([2,8,16], n3(:,379), t3x16(:,:,262))
  call heltable([8,4,32], n3(:,380), t3x32(:,:,54))
  call heltable([4,2,8], n3(:,381), t3x8(:,:,49))
  n2(55) = 8
  call heltable([8,2,16], n3(:,382), t3x16(:,:,263))
  call heltable([2,4,8], n3(:,383), t3x8(:,:,50))
  n2(56) = 8
  call heltable([2,8,16], n3(:,384), t3x16(:,:,264))
  call heltable([2,8,16], n3(:,385), t3x16(:,:,265))
  call heltable([8,4,32], n3(:,386), t3x32(:,:,55))
  call heltable([4,2,8], n3(:,387), t3x8(:,:,51))
  n2(57) = 8
  call heltable([8,2,16], n3(:,388), t3x16(:,:,266))
  call heltable([2,4,8], n3(:,389), t3x8(:,:,52))
  n2(58) = 8
  call heltable([2,8,16], n3(:,390), t3x16(:,:,267))
  call heltable([2,8,16], n3(:,391), t3x16(:,:,268))
  call heltable([8,4,32], n3(:,392), t3x32(:,:,56))
  call heltable([4,2,8], n3(:,393), t3x8(:,:,53))
  n2(59) = 8
  call heltable([4,2,8], n3(:,394), t3x8(:,:,54))
  n2(60) = 8
  call heltable([2,8,16], n3(:,395), t3x16(:,:,269))
  call heltable([2,8,16], n3(:,396), t3x16(:,:,270))
  call heltable([2,8,16], n3(:,397), t3x16(:,:,271))
  call heltable([2,8,16], n3(:,398), t3x16(:,:,272))
  call heltable([8,2,16], n3(:,399), t3x16(:,:,273))
  call heltable([8,2,16], n3(:,400), t3x16(:,:,274))
  call heltable([4,2,8], n3(:,401), t3x8(:,:,55))
  n2(61) = 8
  call heltable([4,2,8], n3(:,402), t3x8(:,:,56))
  n2(62) = 8
  call heltable([2,8,16], n3(:,403), t3x16(:,:,275))
  call heltable([2,8,16], n3(:,404), t3x16(:,:,276))
  call heltable([2,8,16], n3(:,405), t3x16(:,:,277))
  call heltable([2,8,16], n3(:,406), t3x16(:,:,278))
  call heltable([8,2,16], n3(:,407), t3x16(:,:,279))
  call heltable([8,2,16], n3(:,408), t3x16(:,:,280))
  call heltable([2,4,8], n3(:,409), t3x8(:,:,57))
  n2(63) = 8
  call heltable([2,8,16], n3(:,410), t3x16(:,:,281))
  call heltable([2,8,16], n3(:,411), t3x16(:,:,282))
  call heltable([2,4,8], n3(:,412), t3x8(:,:,58))
  n2(64) = 8
  call heltable([2,8,16], n3(:,413), t3x16(:,:,283))
  call heltable([2,8,16], n3(:,414), t3x16(:,:,284))
  call heltable([8,2,16], n3(:,415), t3x16(:,:,285))
  call heltable([8,2,16], n3(:,416), t3x16(:,:,286))
  call heltable([8,2,16], n3(:,417), t3x16(:,:,287))
  call heltable([8,2,16], n3(:,418), t3x16(:,:,288))
  call heltable([8,4,32], n3(:,419), t3x32(:,:,57))
  call heltable([8,4,32], n3(:,420), t3x32(:,:,58))
  call heltable([2,4,8], n3(:,421), t3x8(:,:,59))
  n2(65) = 8
  call heltable([2,8,16], n3(:,422), t3x16(:,:,289))
  call heltable([2,8,16], n3(:,423), t3x16(:,:,290))
  call heltable([2,4,8], n3(:,424), t3x8(:,:,60))
  n2(66) = 8
  call heltable([2,8,16], n3(:,425), t3x16(:,:,291))
  call heltable([2,8,16], n3(:,426), t3x16(:,:,292))
  call heltable([8,2,16], n3(:,427), t3x16(:,:,293))
  call heltable([8,2,16], n3(:,428), t3x16(:,:,294))
  call heltable([8,2,16], n3(:,429), t3x16(:,:,295))
  call heltable([8,2,16], n3(:,430), t3x16(:,:,296))
  call heltable([8,4,32], n3(:,431), t3x32(:,:,59))
  call heltable([8,4,32], n3(:,432), t3x32(:,:,60))
  call heltable([4,4,16], n3(:,433), t3x16(:,:,297))
  call heltable([4,4,16], n3(:,434), t3x16(:,:,298))
  call heltable([4,4,16], n3(:,435), t3x16(:,:,299))
  call heltable([4,4,16], n3(:,436), t3x16(:,:,300))
  call heltable([2,4,8], n3(:,437), t3x8(:,:,61))
  n2(67) = 8
  call heltable([4,2,8], n3(:,438), t3x8(:,:,62))
  n2(68) = 8
  call heltable([4,8,32], n3(:,439), t3x32(:,:,61))
  call heltable([8,2,16], n3(:,440), t3x16(:,:,301))
  call heltable([8,2,16], n3(:,441), t3x16(:,:,302))
  call heltable([2,8,16], n3(:,442), t3x16(:,:,303))
  call heltable([2,8,16], n3(:,443), t3x16(:,:,304))
  call heltable([4,4,16], n3(:,444), t3x16(:,:,305))
  call heltable([4,4,16], n3(:,445), t3x16(:,:,306))
  call heltable([4,4,16], n3(:,446), t3x16(:,:,307))
  call heltable([4,4,16], n3(:,447), t3x16(:,:,308))
  call heltable([4,2,8], n3(:,448), t3x8(:,:,63))
  n2(69) = 8
  call heltable([4,8,32], n3(:,449), t3x32(:,:,62))
  call heltable([8,2,16], n3(:,450), t3x16(:,:,309))
  call heltable([8,2,16], n3(:,451), t3x16(:,:,310))
  call heltable([2,8,16], n3(:,452), t3x16(:,:,311))
  call heltable([2,8,16], n3(:,453), t3x16(:,:,312))
  call heltable([2,4,8], n3(:,454), t3x8(:,:,64))
  n2(70) = 8
  call heltable([4,8,32], n3(:,455), t3x32(:,:,63))
  call heltable([8,2,16], n3(:,456), t3x16(:,:,313))
  call heltable([8,2,16], n3(:,457), t3x16(:,:,314))
  call heltable([2,8,16], n3(:,458), t3x16(:,:,315))
  call heltable([2,8,16], n3(:,459), t3x16(:,:,316))
  call heltable([4,8,32], n3(:,460), t3x32(:,:,64))
  call heltable([8,2,16], n3(:,461), t3x16(:,:,317))
  call heltable([8,2,16], n3(:,462), t3x16(:,:,318))
  call heltable([2,8,16], n3(:,463), t3x16(:,:,319))
  call heltable([2,8,16], n3(:,464), t3x16(:,:,320))
  call heltable([8,4,32], n3(:,465), t3x32(:,:,65))
  call heltable([8,4,32], n3(:,466), t3x32(:,:,66))
  call heltable([8,4,32], n3(:,467), t3x32(:,:,67))
  call heltable([8,4,32], n3(:,468), t3x32(:,:,68))
  call heltable([2,4,8], n3(:,469), t3x8(:,:,65))
  n2(71) = 8
  call heltable([2,8,16], n3(:,470), t3x16(:,:,321))
  call heltable([2,8,16], n3(:,471), t3x16(:,:,322))
  call heltable([2,4,8], n3(:,472), t3x8(:,:,66))
  n2(72) = 8
  call heltable([2,8,16], n3(:,473), t3x16(:,:,323))
  call heltable([2,8,16], n3(:,474), t3x16(:,:,324))
  call heltable([8,2,16], n3(:,475), t3x16(:,:,325))
  call heltable([8,2,16], n3(:,476), t3x16(:,:,326))
  call heltable([8,2,16], n3(:,477), t3x16(:,:,327))
  call heltable([8,2,16], n3(:,478), t3x16(:,:,328))
  call heltable([8,4,32], n3(:,479), t3x32(:,:,69))
  call heltable([8,4,32], n3(:,480), t3x32(:,:,70))
  call heltable([2,4,8], n3(:,481), t3x8(:,:,67))
  n2(73) = 8
  call heltable([2,8,16], n3(:,482), t3x16(:,:,329))
  call heltable([2,8,16], n3(:,483), t3x16(:,:,330))
  call heltable([2,4,8], n3(:,484), t3x8(:,:,68))
  n2(74) = 8
  call heltable([2,8,16], n3(:,485), t3x16(:,:,331))
  call heltable([2,8,16], n3(:,486), t3x16(:,:,332))
  call heltable([8,2,16], n3(:,487), t3x16(:,:,333))
  call heltable([8,2,16], n3(:,488), t3x16(:,:,334))
  call heltable([8,2,16], n3(:,489), t3x16(:,:,335))
  call heltable([8,2,16], n3(:,490), t3x16(:,:,336))
  call heltable([8,4,32], n3(:,491), t3x32(:,:,71))
  call heltable([8,4,32], n3(:,492), t3x32(:,:,72))
  call heltable([4,4,16], n3(:,493), t3x16(:,:,337))
  call heltable([4,4,16], n3(:,494), t3x16(:,:,338))
  call heltable([4,4,16], n3(:,495), t3x16(:,:,339))
  call heltable([4,4,16], n3(:,496), t3x16(:,:,340))
  call heltable([4,2,8], n3(:,497), t3x8(:,:,69))
  n2(75) = 8
  call heltable([4,8,32], n3(:,498), t3x32(:,:,73))
  call heltable([8,2,16], n3(:,499), t3x16(:,:,341))
  call heltable([8,2,16], n3(:,500), t3x16(:,:,342))
  call heltable([2,4,8], n3(:,501), t3x8(:,:,70))
  n2(76) = 8
  call heltable([2,8,16], n3(:,502), t3x16(:,:,343))
  call heltable([2,8,16], n3(:,503), t3x16(:,:,344))
  call heltable([4,4,16], n3(:,504), t3x16(:,:,345))
  call heltable([4,4,16], n3(:,505), t3x16(:,:,346))
  call heltable([4,4,16], n3(:,506), t3x16(:,:,347))
  call heltable([4,4,16], n3(:,507), t3x16(:,:,348))
  call heltable([4,2,8], n3(:,508), t3x8(:,:,71))
  n2(77) = 8
  call heltable([4,8,32], n3(:,509), t3x32(:,:,74))
  call heltable([8,2,16], n3(:,510), t3x16(:,:,349))
  call heltable([8,2,16], n3(:,511), t3x16(:,:,350))
  call heltable([2,8,16], n3(:,512), t3x16(:,:,351))
  call heltable([2,8,16], n3(:,513), t3x16(:,:,352))
  call heltable([4,8,32], n3(:,514), t3x32(:,:,75))
  call heltable([8,2,16], n3(:,515), t3x16(:,:,353))
  call heltable([8,2,16], n3(:,516), t3x16(:,:,354))
  call heltable([2,4,8], n3(:,517), t3x8(:,:,72))
  n2(78) = 8
  call heltable([2,8,16], n3(:,518), t3x16(:,:,355))
  call heltable([2,8,16], n3(:,519), t3x16(:,:,356))
  call heltable([4,8,32], n3(:,520), t3x32(:,:,76))
  call heltable([8,2,16], n3(:,521), t3x16(:,:,357))
  call heltable([8,2,16], n3(:,522), t3x16(:,:,358))
  call heltable([2,8,16], n3(:,523), t3x16(:,:,359))
  call heltable([2,8,16], n3(:,524), t3x16(:,:,360))
  call heltable([8,4,32], n3(:,525), t3x32(:,:,77))
  call heltable([8,4,32], n3(:,526), t3x32(:,:,78))
  call heltable([8,4,32], n3(:,527), t3x32(:,:,79))
  call heltable([8,4,32], n3(:,528), t3x32(:,:,80))
  n2(79) = 4
  call heltable([4,4,16], n3(:,529), t3x16(:,:,361))
  call heltable([4,4,16], n3(:,530), t3x16(:,:,362))
  call heltable([4,4,16], n3(:,531), t3x16(:,:,363))
  call heltable([4,4,16], n3(:,532), t3x16(:,:,364))
  call heltable([4,4,16], n3(:,533), t3x16(:,:,365))
  call heltable([4,4,16], n3(:,534), t3x16(:,:,366))
  call heltable([4,4,16], n3(:,535), t3x16(:,:,367))
  call heltable([4,4,16], n3(:,536), t3x16(:,:,368))
  n2(80) = 4
  call heltable([4,4,16], n3(:,537), t3x16(:,:,369))
  call heltable([4,4,16], n3(:,538), t3x16(:,:,370))
  call heltable([4,4,16], n3(:,539), t3x16(:,:,371))
  call heltable([4,4,16], n3(:,540), t3x16(:,:,372))
  call heltable([4,4,16], n3(:,541), t3x16(:,:,373))
  call heltable([4,4,16], n3(:,542), t3x16(:,:,374))
  call heltable([4,4,16], n3(:,543), t3x16(:,:,375))
  call heltable([4,4,16], n3(:,544), t3x16(:,:,376))
  n2(81) = 4
  call heltable([4,4,16], n3(:,545), t3x16(:,:,377))
  call heltable([4,4,16], n3(:,546), t3x16(:,:,378))
  call heltable([4,4,16], n3(:,547), t3x16(:,:,379))
  call heltable([4,4,16], n3(:,548), t3x16(:,:,380))
  call heltable([4,4,16], n3(:,549), t3x16(:,:,381))
  call heltable([4,4,16], n3(:,550), t3x16(:,:,382))
  call heltable([4,4,16], n3(:,551), t3x16(:,:,383))
  call heltable([4,4,16], n3(:,552), t3x16(:,:,384))
  n2(82) = 4
  call heltable([4,4,16], n3(:,553), t3x16(:,:,385))
  call heltable([4,4,16], n3(:,554), t3x16(:,:,386))
  call heltable([4,4,16], n3(:,555), t3x16(:,:,387))
  call heltable([4,4,16], n3(:,556), t3x16(:,:,388))
  call heltable([4,4,16], n3(:,557), t3x16(:,:,389))
  call heltable([4,4,16], n3(:,558), t3x16(:,:,390))
  call heltable([4,4,16], n3(:,559), t3x16(:,:,391))
  call heltable([4,4,16], n3(:,560), t3x16(:,:,392))
  n2(83) = 16
  n2(84) = 16
  n2(85) = 16
  n2(86) = 16
  n2(87) = 16
  n2(88) = 16
  n2(89) = 16
  n2(90) = 16
  call heltable([4,2,8], n3(:,561), t3x8(:,:,73))
  call heltable([8,4,32], n3(:,562), t3x32(:,:,81))
  n2(91) = 8
  call heltable([2,16,32], n3(:,563), t3x32(:,:,82))
  call heltable([2,16,32], n3(:,564), t3x32(:,:,83))
  call heltable([2,4,8], n3(:,565), t3x8(:,:,74))
  n2(92) = 8
  call heltable([16,2,32], n3(:,566), t3x32(:,:,84))
  n2(93) = 32
  call heltable([16,2,32], n3(:,567), t3x32(:,:,85))
  n2(94) = 32
  call heltable([4,2,8], n3(:,568), t3x8(:,:,75))
  call heltable([8,4,32], n3(:,569), t3x32(:,:,86))
  n2(95) = 8
  call heltable([2,16,32], n3(:,570), t3x32(:,:,87))
  call heltable([2,16,32], n3(:,571), t3x32(:,:,88))
  call heltable([2,4,8], n3(:,572), t3x8(:,:,76))
  n2(96) = 8
  call heltable([16,2,32], n3(:,573), t3x32(:,:,89))
  n2(97) = 32
  call heltable([16,2,32], n3(:,574), t3x32(:,:,90))
  n2(98) = 32
  call heltable([4,8,32], n3(:,575), t3x32(:,:,91))
  call heltable([4,8,32], n3(:,576), t3x32(:,:,92))
  n2(99) = 8
  n2(100) = 32
  n2(101) = 8
  n2(102) = 32
  n2(103) = 8
  n2(104) = 8
  n2(105) = 8
  n2(106) = 32
  n2(107) = 8
  n2(108) = 32
  n2(109) = 8
  n2(110) = 8
  n2(111) = 32
  n2(112) = 32
  n2(113) = 32
  n2(114) = 32
  call heltable([4,4,16], n3(:,577), t3x16(:,:,393))
  call heltable([4,4,16], n3(:,578), t3x16(:,:,394))
  call heltable([4,4,16], n3(:,579), t3x16(:,:,395))
  call heltable([4,4,16], n3(:,580), t3x16(:,:,396))
  call heltable([4,4,16], n3(:,581), t3x16(:,:,397))
  call heltable([4,4,16], n3(:,582), t3x16(:,:,398))
  call heltable([4,4,16], n3(:,583), t3x16(:,:,399))
  call heltable([4,4,16], n3(:,584), t3x16(:,:,400))
  call heltable([4,4,16], n3(:,585), t3x16(:,:,401))
  call heltable([4,4,16], n3(:,586), t3x16(:,:,402))
  call heltable([4,4,16], n3(:,587), t3x16(:,:,403))
  call heltable([4,4,16], n3(:,588), t3x16(:,:,404))
  call heltable([4,4,16], n3(:,589), t3x16(:,:,405))
  call heltable([4,4,16], n3(:,590), t3x16(:,:,406))
  call heltable([4,4,16], n3(:,591), t3x16(:,:,407))
  call heltable([4,4,16], n3(:,592), t3x16(:,:,408))
  n2(115) = 4
  call heltable([4,4,16], n3(:,593), t3x16(:,:,409))
  call heltable([4,4,16], n3(:,594), t3x16(:,:,410))
  call heltable([4,4,16], n3(:,595), t3x16(:,:,411))
  call heltable([4,4,16], n3(:,596), t3x16(:,:,412))
  call heltable([4,4,16], n3(:,597), t3x16(:,:,413))
  call heltable([4,4,16], n3(:,598), t3x16(:,:,414))
  call heltable([4,4,16], n3(:,599), t3x16(:,:,415))
  call heltable([4,4,16], n3(:,600), t3x16(:,:,416))
  n2(116) = 4
  call heltable([4,4,16], n3(:,601), t3x16(:,:,417))
  call heltable([4,4,16], n3(:,602), t3x16(:,:,418))
  call heltable([4,4,16], n3(:,603), t3x16(:,:,419))
  call heltable([4,4,16], n3(:,604), t3x16(:,:,420))
  call heltable([4,4,16], n3(:,605), t3x16(:,:,421))
  call heltable([4,4,16], n3(:,606), t3x16(:,:,422))
  call heltable([4,4,16], n3(:,607), t3x16(:,:,423))
  call heltable([4,4,16], n3(:,608), t3x16(:,:,424))
  n2(117) = 16
  n2(118) = 16
  n2(119) = 16
  n2(120) = 16
  n2(121) = 16
  n2(122) = 16
  n2(123) = 16
  n2(124) = 16
  call heltable([4,2,8], n3(:,609), t3x8(:,:,77))
  call heltable([8,4,32], n3(:,610), t3x32(:,:,93))
  n2(125) = 8
  call heltable([2,16,32], n3(:,611), t3x32(:,:,94))
  call heltable([2,16,32], n3(:,612), t3x32(:,:,95))
  call heltable([16,2,32], n3(:,613), t3x32(:,:,96))
  n2(126) = 32
  call heltable([16,2,32], n3(:,614), t3x32(:,:,97))
  n2(127) = 32
  call heltable([4,2,8], n3(:,615), t3x8(:,:,78))
  call heltable([8,4,32], n3(:,616), t3x32(:,:,98))
  n2(128) = 8
  call heltable([2,16,32], n3(:,617), t3x32(:,:,99))
  call heltable([2,16,32], n3(:,618), t3x32(:,:,100))
  call heltable([16,2,32], n3(:,619), t3x32(:,:,101))
  n2(129) = 32
  call heltable([16,2,32], n3(:,620), t3x32(:,:,102))
  n2(130) = 32
  n2(131) = 8
  n2(132) = 32
  n2(133) = 8
  n2(134) = 32
  n2(135) = 8
  n2(136) = 32
  n2(137) = 8
  n2(138) = 32
  n2(139) = 32
  n2(140) = 32
  n2(141) = 16
  n2(142) = 16
  n2(143) = 16
  n2(144) = 16
  n2(145) = 16
  n2(146) = 16
  call heltable([4,8,32], n3(:,621), t3x32(:,:,103))
  call heltable([4,8,32], n3(:,622), t3x32(:,:,104))
  n2(147) = 32
  n2(148) = 32
  call heltable([8,4,32], n3(:,623), t3x32(:,:,105))
  call heltable([2,16,32], n3(:,624), t3x32(:,:,106))
  call heltable([2,16,32], n3(:,625), t3x32(:,:,107))
  call heltable([2,4,8], n3(:,626), t3x8(:,:,79))
  n2(149) = 8
  call heltable([16,2,32], n3(:,627), t3x32(:,:,108))
  n2(150) = 32
  call heltable([16,2,32], n3(:,628), t3x32(:,:,109))
  n2(151) = 32
  call heltable([8,4,32], n3(:,629), t3x32(:,:,110))
  call heltable([2,16,32], n3(:,630), t3x32(:,:,111))
  call heltable([2,16,32], n3(:,631), t3x32(:,:,112))
  call heltable([2,4,8], n3(:,632), t3x8(:,:,80))
  n2(152) = 8
  call heltable([16,2,32], n3(:,633), t3x32(:,:,113))
  n2(153) = 32
  call heltable([16,2,32], n3(:,634), t3x32(:,:,114))
  n2(154) = 32
  call heltable([4,8,32], n3(:,635), t3x32(:,:,115))
  call heltable([4,8,32], n3(:,636), t3x32(:,:,116))
  n2(155) = 32
  n2(156) = 32
  n2(157) = 8
  n2(158) = 8
  n2(159) = 32
  n2(160) = 32
  n2(161) = 8
  n2(162) = 8
  n2(163) = 32
  n2(164) = 32
  n2(165) = 32
  n2(166) = 32
  call heltable([8,4,32], n3(:,637), t3x32(:,:,117))
  call heltable([2,16,32], n3(:,638), t3x32(:,:,118))
  call heltable([2,16,32], n3(:,639), t3x32(:,:,119))
  call heltable([16,2,32], n3(:,640), t3x32(:,:,120))
  n2(167) = 32
  call heltable([16,2,32], n3(:,641), t3x32(:,:,121))
  n2(168) = 32
  call heltable([8,4,32], n3(:,642), t3x32(:,:,122))
  call heltable([2,16,32], n3(:,643), t3x32(:,:,123))
  call heltable([2,16,32], n3(:,644), t3x32(:,:,124))
  call heltable([16,2,32], n3(:,645), t3x32(:,:,125))
  n2(169) = 32
  call heltable([16,2,32], n3(:,646), t3x32(:,:,126))
  n2(170) = 32
  n2(171) = 32
  n2(172) = 32
  n2(173) = 32
  n2(174) = 32
  n2(175) = 32
  n2(176) = 32
  n2(177) = 16
  n2(178) = 16
  n2(179) = 16
  n2(180) = 16
  n2(181) = 16
  n2(182) = 16
  call heltable([4,8,32], n3(:,647), t3x32(:,:,127))
  call heltable([4,8,32], n3(:,648), t3x32(:,:,128))
  n2(183) = 32
  n2(184) = 32
  call heltable([8,2,16], n3(:,649), t3x16(:,:,425))
  call heltable([8,2,16], n3(:,650), t3x16(:,:,426))
  call heltable([8,2,16], n3(:,651), t3x16(:,:,427))
  call heltable([8,2,16], n3(:,652), t3x16(:,:,428))
  call heltable([8,2,16], n3(:,653), t3x16(:,:,429))
  call heltable([8,2,16], n3(:,654), t3x16(:,:,430))
  call heltable([8,2,16], n3(:,655), t3x16(:,:,431))
  call heltable([8,2,16], n3(:,656), t3x16(:,:,432))
  call heltable([2,16,32], n3(:,657), t3x32(:,:,129))
  call heltable([2,16,32], n3(:,658), t3x32(:,:,130))
  call heltable([2,16,32], n3(:,659), t3x32(:,:,131))
  call heltable([2,16,32], n3(:,660), t3x32(:,:,132))
  call heltable([2,8,16], n3(:,661), t3x16(:,:,433))
  call heltable([2,8,16], n3(:,662), t3x16(:,:,434))
  call heltable([2,8,16], n3(:,663), t3x16(:,:,435))
  call heltable([2,8,16], n3(:,664), t3x16(:,:,436))
  call heltable([16,2,32], n3(:,665), t3x32(:,:,133))
  call heltable([16,2,32], n3(:,666), t3x32(:,:,134))
  call heltable([16,2,32], n3(:,667), t3x32(:,:,135))
  call heltable([16,2,32], n3(:,668), t3x32(:,:,136))
  call heltable([16,2,32], n3(:,669), t3x32(:,:,137))
  call heltable([16,2,32], n3(:,670), t3x32(:,:,138))
  call heltable([16,2,32], n3(:,671), t3x32(:,:,139))
  call heltable([16,2,32], n3(:,672), t3x32(:,:,140))
  call heltable([16,2,32], n3(:,673), t3x32(:,:,141))
  call heltable([16,2,32], n3(:,674), t3x32(:,:,142))
  call heltable([16,2,32], n3(:,675), t3x32(:,:,143))
  call heltable([16,2,32], n3(:,676), t3x32(:,:,144))
  call heltable([8,2,16], n3(:,677), t3x16(:,:,437))
  call heltable([8,2,16], n3(:,678), t3x16(:,:,438))
  call heltable([8,2,16], n3(:,679), t3x16(:,:,439))
  call heltable([8,2,16], n3(:,680), t3x16(:,:,440))
  call heltable([8,2,16], n3(:,681), t3x16(:,:,441))
  call heltable([8,2,16], n3(:,682), t3x16(:,:,442))
  call heltable([8,2,16], n3(:,683), t3x16(:,:,443))
  call heltable([8,2,16], n3(:,684), t3x16(:,:,444))
  call heltable([2,16,32], n3(:,685), t3x32(:,:,145))
  call heltable([2,16,32], n3(:,686), t3x32(:,:,146))
  call heltable([2,16,32], n3(:,687), t3x32(:,:,147))
  call heltable([2,16,32], n3(:,688), t3x32(:,:,148))
  call heltable([2,8,16], n3(:,689), t3x16(:,:,445))
  call heltable([2,8,16], n3(:,690), t3x16(:,:,446))
  call heltable([2,8,16], n3(:,691), t3x16(:,:,447))
  call heltable([2,8,16], n3(:,692), t3x16(:,:,448))
  call heltable([16,2,32], n3(:,693), t3x32(:,:,149))
  call heltable([16,2,32], n3(:,694), t3x32(:,:,150))
  call heltable([16,2,32], n3(:,695), t3x32(:,:,151))
  call heltable([16,2,32], n3(:,696), t3x32(:,:,152))
  call heltable([16,2,32], n3(:,697), t3x32(:,:,153))
  call heltable([16,2,32], n3(:,698), t3x32(:,:,154))
  call heltable([16,2,32], n3(:,699), t3x32(:,:,155))
  call heltable([16,2,32], n3(:,700), t3x32(:,:,156))
  call heltable([16,2,32], n3(:,701), t3x32(:,:,157))
  call heltable([16,2,32], n3(:,702), t3x32(:,:,158))
  call heltable([16,2,32], n3(:,703), t3x32(:,:,159))
  call heltable([16,2,32], n3(:,704), t3x32(:,:,160))
  n2(185) = 16
  n2(186) = 16
  n2(187) = 16
  n2(188) = 16
  n2(189) = 16
  n2(190) = 16
  n2(191) = 16
  n2(192) = 16
  n2(193) = 16
  n2(194) = 16
  n2(195) = 16
  n2(196) = 16
  n2(197) = 16
  n2(198) = 16
  n2(199) = 16
  n2(200) = 16
  n2(201) = 8
  call heltable([8,2,16], n3(:,705), t3x16(:,:,449))
  n2(202) = 8
  call heltable([8,2,16], n3(:,706), t3x16(:,:,450))
  call heltable([8,2,16], n3(:,707), t3x16(:,:,451))
  call heltable([8,2,16], n3(:,708), t3x16(:,:,452))
  n2(203) = 8
  call heltable([8,2,16], n3(:,709), t3x16(:,:,453))
  n2(204) = 8
  call heltable([8,2,16], n3(:,710), t3x16(:,:,454))
  call heltable([8,2,16], n3(:,711), t3x16(:,:,455))
  call heltable([8,2,16], n3(:,712), t3x16(:,:,456))
  n2(205) = 8
  call heltable([2,8,16], n3(:,713), t3x16(:,:,457))
  n2(206) = 8
  call heltable([2,8,16], n3(:,714), t3x16(:,:,458))
  call heltable([2,8,16], n3(:,715), t3x16(:,:,459))
  call heltable([2,8,16], n3(:,716), t3x16(:,:,460))
  n2(207) = 8
  call heltable([2,8,16], n3(:,717), t3x16(:,:,461))
  n2(208) = 8
  call heltable([2,8,16], n3(:,718), t3x16(:,:,462))
  call heltable([2,8,16], n3(:,719), t3x16(:,:,463))
  call heltable([2,8,16], n3(:,720), t3x16(:,:,464))
  call heltable([8,2,16], n3(:,721), t3x16(:,:,465))
  call heltable([8,2,16], n3(:,722), t3x16(:,:,466))
  call heltable([8,2,16], n3(:,723), t3x16(:,:,467))
  call heltable([8,2,16], n3(:,724), t3x16(:,:,468))
  call heltable([8,2,16], n3(:,725), t3x16(:,:,469))
  call heltable([8,2,16], n3(:,726), t3x16(:,:,470))
  call heltable([8,2,16], n3(:,727), t3x16(:,:,471))
  call heltable([8,2,16], n3(:,728), t3x16(:,:,472))
  n2(209) = 8
  call heltable([2,8,16], n3(:,729), t3x16(:,:,473))
  n2(210) = 8
  call heltable([2,8,16], n3(:,730), t3x16(:,:,474))
  call heltable([2,8,16], n3(:,731), t3x16(:,:,475))
  call heltable([2,8,16], n3(:,732), t3x16(:,:,476))
  n2(211) = 8
  call heltable([2,8,16], n3(:,733), t3x16(:,:,477))
  n2(212) = 8
  call heltable([2,8,16], n3(:,734), t3x16(:,:,478))
  call heltable([2,8,16], n3(:,735), t3x16(:,:,479))
  call heltable([2,8,16], n3(:,736), t3x16(:,:,480))
  n2(213) = 8
  call heltable([8,2,16], n3(:,737), t3x16(:,:,481))
  n2(214) = 8
  call heltable([8,2,16], n3(:,738), t3x16(:,:,482))
  call heltable([8,2,16], n3(:,739), t3x16(:,:,483))
  call heltable([8,2,16], n3(:,740), t3x16(:,:,484))
  call heltable([2,8,16], n3(:,741), t3x16(:,:,485))
  call heltable([2,8,16], n3(:,742), t3x16(:,:,486))
  call heltable([2,8,16], n3(:,743), t3x16(:,:,487))
  call heltable([2,8,16], n3(:,744), t3x16(:,:,488))
  n2(215) = 16
  n2(216) = 16
  n2(217) = 16
  n2(218) = 16
  n2(219) = 8
  call heltable([8,2,16], n3(:,745), t3x16(:,:,489))
  n2(220) = 8
  call heltable([8,2,16], n3(:,746), t3x16(:,:,490))
  call heltable([8,2,16], n3(:,747), t3x16(:,:,491))
  call heltable([8,2,16], n3(:,748), t3x16(:,:,492))
  call heltable([2,8,16], n3(:,749), t3x16(:,:,493))
  call heltable([2,8,16], n3(:,750), t3x16(:,:,494))
  call heltable([2,8,16], n3(:,751), t3x16(:,:,495))
  call heltable([2,8,16], n3(:,752), t3x16(:,:,496))
  n2(221) = 16
  n2(222) = 16
  n2(223) = 16
  n2(224) = 16
  call heltable([8,2,16], n3(:,753), t3x16(:,:,497))
  call heltable([8,2,16], n3(:,754), t3x16(:,:,498))
  call heltable([8,2,16], n3(:,755), t3x16(:,:,499))
  call heltable([8,2,16], n3(:,756), t3x16(:,:,500))
  n2(225) = 16
  n2(226) = 16
  n2(227) = 16
  n2(228) = 16
  call heltable([2,8,16], n3(:,757), t3x16(:,:,501))
  call heltable([2,8,16], n3(:,758), t3x16(:,:,502))
  call heltable([2,8,16], n3(:,759), t3x16(:,:,503))
  call heltable([2,8,16], n3(:,760), t3x16(:,:,504))
  call heltable([8,2,16], n3(:,761), t3x16(:,:,505))
  call heltable([8,2,16], n3(:,762), t3x16(:,:,506))
  call heltable([8,2,16], n3(:,763), t3x16(:,:,507))
  call heltable([8,2,16], n3(:,764), t3x16(:,:,508))
  n2(229) = 16
  n2(230) = 16
  n2(231) = 16
  n2(232) = 16
  call heltable([2,8,16], n3(:,765), t3x16(:,:,509))
  call heltable([2,8,16], n3(:,766), t3x16(:,:,510))
  call heltable([2,8,16], n3(:,767), t3x16(:,:,511))
  call heltable([2,8,16], n3(:,768), t3x16(:,:,512))
  n2(233) = 16
  n2(234) = 16
  n2(235) = 16
  n2(236) = 16
  n2(237) = 16
  n2(238) = 16
  n2(239) = 16
  n2(240) = 16
  n2(241) = 16
  n2(242) = 16
  n2(243) = 16
  n2(244) = 16
  n2(245) = 16
  n2(246) = 16
  n2(247) = 16
  n2(248) = 16
  call heltable([8,4,32], n3(:,769), t3x32(:,:,161))
  call heltable([8,4,32], n3(:,770), t3x32(:,:,162))
  call heltable([16,2,32], n3(:,771), t3x32(:,:,163))
  n2(249) = 8
  n2(250) = 32
  call heltable([16,2,32], n3(:,772), t3x32(:,:,164))
  n2(251) = 32
  call heltable([16,2,32], n3(:,773), t3x32(:,:,165))
  n2(252) = 8
  n2(253) = 32
  call heltable([16,2,32], n3(:,774), t3x32(:,:,166))
  n2(254) = 32
  call heltable([2,16,32], n3(:,775), t3x32(:,:,167))
  n2(255) = 8
  n2(256) = 32
  call heltable([2,16,32], n3(:,776), t3x32(:,:,168))
  n2(257) = 8
  n2(258) = 32
  call heltable([2,4,8], n3(:,777), t3x8(:,:,81))
  n2(259) = 8
  call heltable([4,8,32], n3(:,778), t3x32(:,:,169))
  call heltable([2,4,8], n3(:,779), t3x8(:,:,82))
  n2(260) = 8
  call heltable([4,8,32], n3(:,780), t3x32(:,:,170))
  n2(261) = 32
  n2(262) = 32
  call heltable([4,2,8], n3(:,781), t3x8(:,:,83))
  n2(263) = 8
  call heltable([4,2,8], n3(:,782), t3x8(:,:,84))
  n2(264) = 8
  n2(265) = 32
  n2(266) = 32
  call heltable([2,16,32], n3(:,783), t3x32(:,:,171))
  call heltable([2,16,32], n3(:,784), t3x32(:,:,172))
  call heltable([2,16,32], n3(:,785), t3x32(:,:,173))
  call heltable([16,2,32], n3(:,786), t3x32(:,:,174))
  call heltable([16,2,32], n3(:,787), t3x32(:,:,175))
  call heltable([16,2,32], n3(:,788), t3x32(:,:,176))
  n2(267) = 8
  call heltable([2,8,16], n3(:,789), t3x16(:,:,513))
  call heltable([2,8,16], n3(:,790), t3x16(:,:,514))
  n2(268) = 8
  call heltable([8,2,16], n3(:,791), t3x16(:,:,515))
  call heltable([2,8,16], n3(:,792), t3x16(:,:,516))
  call heltable([2,8,16], n3(:,793), t3x16(:,:,517))
  n2(269) = 16
  n2(270) = 16
  call heltable([8,2,16], n3(:,794), t3x16(:,:,518))
  n2(271) = 16
  n2(272) = 16
  n2(273) = 16
  n2(274) = 16
  call heltable([8,4,32], n3(:,795), t3x32(:,:,177))
  call heltable([8,4,32], n3(:,796), t3x32(:,:,178))
  call heltable([16,2,32], n3(:,797), t3x32(:,:,179))
  n2(275) = 8
  n2(276) = 32
  call heltable([16,2,32], n3(:,798), t3x32(:,:,180))
  n2(277) = 32
  call heltable([16,2,32], n3(:,799), t3x32(:,:,181))
  n2(278) = 8
  n2(279) = 32
  call heltable([16,2,32], n3(:,800), t3x32(:,:,182))
  n2(280) = 32
  call heltable([2,16,32], n3(:,801), t3x32(:,:,183))
  n2(281) = 8
  n2(282) = 32
  call heltable([2,16,32], n3(:,802), t3x32(:,:,184))
  n2(283) = 8
  n2(284) = 32
  call heltable([2,4,8], n3(:,803), t3x8(:,:,85))
  n2(285) = 8
  call heltable([4,8,32], n3(:,804), t3x32(:,:,185))
  call heltable([2,4,8], n3(:,805), t3x8(:,:,86))
  n2(286) = 8
  call heltable([4,8,32], n3(:,806), t3x32(:,:,186))
  n2(287) = 32
  n2(288) = 32
  call heltable([4,2,8], n3(:,807), t3x8(:,:,87))
  n2(289) = 8
  call heltable([4,2,8], n3(:,808), t3x8(:,:,88))
  n2(290) = 8
  n2(291) = 32
  n2(292) = 32
  call heltable([2,16,32], n3(:,809), t3x32(:,:,187))
  call heltable([2,16,32], n3(:,810), t3x32(:,:,188))
  call heltable([2,16,32], n3(:,811), t3x32(:,:,189))
  call heltable([16,2,32], n3(:,812), t3x32(:,:,190))
  call heltable([16,2,32], n3(:,813), t3x32(:,:,191))
  call heltable([16,2,32], n3(:,814), t3x32(:,:,192))
  n2(293) = 8
  call heltable([2,8,16], n3(:,815), t3x16(:,:,519))
  call heltable([2,8,16], n3(:,816), t3x16(:,:,520))
  n2(294) = 8
  call heltable([8,2,16], n3(:,817), t3x16(:,:,521))
  n2(295) = 16
  n2(296) = 16
  call heltable([2,8,16], n3(:,818), t3x16(:,:,522))
  call heltable([2,8,16], n3(:,819), t3x16(:,:,523))
  n2(297) = 16
  n2(298) = 16
  n2(299) = 16
  n2(300) = 16
  call heltable([8,2,16], n3(:,820), t3x16(:,:,524))
  call heltable([2,16,32], n3(:,821), t3x32(:,:,193))
  call heltable([2,16,32], n3(:,822), t3x32(:,:,194))
  call heltable([2,16,32], n3(:,823), t3x32(:,:,195))
  call heltable([16,2,32], n3(:,824), t3x32(:,:,196))
  call heltable([16,2,32], n3(:,825), t3x32(:,:,197))
  call heltable([16,2,32], n3(:,826), t3x32(:,:,198))
  n2(301) = 8
  call heltable([2,8,16], n3(:,827), t3x16(:,:,525))
  call heltable([2,8,16], n3(:,828), t3x16(:,:,526))
  n2(302) = 8
  call heltable([8,2,16], n3(:,829), t3x16(:,:,527))
  call heltable([2,8,16], n3(:,830), t3x16(:,:,528))
  call heltable([2,8,16], n3(:,831), t3x16(:,:,529))
  n2(303) = 16
  n2(304) = 16
  call heltable([8,2,16], n3(:,832), t3x16(:,:,530))
  n2(305) = 16
  n2(306) = 16
  n2(307) = 16
  n2(308) = 16
  call heltable([2,16,32], n3(:,833), t3x32(:,:,199))
  call heltable([2,16,32], n3(:,834), t3x32(:,:,200))
  call heltable([2,16,32], n3(:,835), t3x32(:,:,201))
  call heltable([16,2,32], n3(:,836), t3x32(:,:,202))
  call heltable([16,2,32], n3(:,837), t3x32(:,:,203))
  call heltable([16,2,32], n3(:,838), t3x32(:,:,204))
  n2(309) = 8
  call heltable([2,8,16], n3(:,839), t3x16(:,:,531))
  call heltable([2,8,16], n3(:,840), t3x16(:,:,532))
  n2(310) = 8
  call heltable([8,2,16], n3(:,841), t3x16(:,:,533))
  n2(311) = 16
  n2(312) = 16
  call heltable([2,8,16], n3(:,842), t3x16(:,:,534))
  call heltable([2,8,16], n3(:,843), t3x16(:,:,535))
  n2(313) = 16
  n2(314) = 16
  n2(315) = 16
  n2(316) = 16
  call heltable([8,2,16], n3(:,844), t3x16(:,:,536))
  call heltable([16,2,32], n3(:,845), t3x32(:,:,205))
  n2(317) = 8
  n2(318) = 32
  call heltable([16,2,32], n3(:,846), t3x32(:,:,206))
  n2(319) = 32
  call heltable([16,2,32], n3(:,847), t3x32(:,:,207))
  n2(320) = 8
  n2(321) = 32
  call heltable([16,2,32], n3(:,848), t3x32(:,:,208))
  n2(322) = 32
  call heltable([2,16,32], n3(:,849), t3x32(:,:,209))
  n2(323) = 8
  n2(324) = 32
  call heltable([2,16,32], n3(:,850), t3x32(:,:,210))
  n2(325) = 8
  n2(326) = 32
  call heltable([2,4,8], n3(:,851), t3x8(:,:,89))
  n2(327) = 8
  call heltable([4,8,32], n3(:,852), t3x32(:,:,211))
  call heltable([2,4,8], n3(:,853), t3x8(:,:,90))
  n2(328) = 8
  call heltable([4,8,32], n3(:,854), t3x32(:,:,212))
  n2(329) = 32
  n2(330) = 32
  call heltable([8,4,32], n3(:,855), t3x32(:,:,213))
  call heltable([8,4,32], n3(:,856), t3x32(:,:,214))
  call heltable([4,2,8], n3(:,857), t3x8(:,:,91))
  n2(331) = 8
  call heltable([4,2,8], n3(:,858), t3x8(:,:,92))
  n2(332) = 8
  n2(333) = 32
  n2(334) = 32
  n2(335) = 8
  call heltable([2,8,16], n3(:,859), t3x16(:,:,537))
  call heltable([2,8,16], n3(:,860), t3x16(:,:,538))
  n2(336) = 8
  call heltable([8,2,16], n3(:,861), t3x16(:,:,539))
  call heltable([2,8,16], n3(:,862), t3x16(:,:,540))
  call heltable([2,8,16], n3(:,863), t3x16(:,:,541))
  n2(337) = 16
  n2(338) = 16
  call heltable([2,16,32], n3(:,864), t3x32(:,:,215))
  call heltable([2,16,32], n3(:,865), t3x32(:,:,216))
  call heltable([2,16,32], n3(:,866), t3x32(:,:,217))
  call heltable([16,2,32], n3(:,867), t3x32(:,:,218))
  call heltable([16,2,32], n3(:,868), t3x32(:,:,219))
  call heltable([16,2,32], n3(:,869), t3x32(:,:,220))
  call heltable([8,2,16], n3(:,870), t3x16(:,:,542))
  n2(339) = 16
  n2(340) = 16
  n2(341) = 16
  n2(342) = 16
  call heltable([16,2,32], n3(:,871), t3x32(:,:,221))
  n2(343) = 8
  n2(344) = 32
  call heltable([16,2,32], n3(:,872), t3x32(:,:,222))
  n2(345) = 32
  call heltable([16,2,32], n3(:,873), t3x32(:,:,223))
  n2(346) = 8
  n2(347) = 32
  call heltable([16,2,32], n3(:,874), t3x32(:,:,224))
  n2(348) = 32
  call heltable([2,16,32], n3(:,875), t3x32(:,:,225))
  n2(349) = 8
  n2(350) = 32
  call heltable([2,16,32], n3(:,876), t3x32(:,:,226))
  n2(351) = 8
  n2(352) = 32
  call heltable([2,4,8], n3(:,877), t3x8(:,:,93))
  n2(353) = 8
  call heltable([4,8,32], n3(:,878), t3x32(:,:,227))
  call heltable([2,4,8], n3(:,879), t3x8(:,:,94))
  n2(354) = 8
  call heltable([4,8,32], n3(:,880), t3x32(:,:,228))
  n2(355) = 32
  n2(356) = 32
  call heltable([8,4,32], n3(:,881), t3x32(:,:,229))
  call heltable([8,4,32], n3(:,882), t3x32(:,:,230))
  call heltable([4,2,8], n3(:,883), t3x8(:,:,95))
  n2(357) = 8
  call heltable([4,2,8], n3(:,884), t3x8(:,:,96))
  n2(358) = 8
  n2(359) = 32
  n2(360) = 32
  n2(361) = 8
  call heltable([8,2,16], n3(:,885), t3x16(:,:,543))
  n2(362) = 8
  call heltable([2,8,16], n3(:,886), t3x16(:,:,544))
  call heltable([2,8,16], n3(:,887), t3x16(:,:,545))
  n2(363) = 16
  n2(364) = 16
  call heltable([2,8,16], n3(:,888), t3x16(:,:,546))
  call heltable([2,8,16], n3(:,889), t3x16(:,:,547))
  call heltable([2,16,32], n3(:,890), t3x32(:,:,231))
  call heltable([2,16,32], n3(:,891), t3x32(:,:,232))
  call heltable([2,16,32], n3(:,892), t3x32(:,:,233))
  call heltable([16,2,32], n3(:,893), t3x32(:,:,234))
  call heltable([16,2,32], n3(:,894), t3x32(:,:,235))
  call heltable([16,2,32], n3(:,895), t3x32(:,:,236))
  n2(365) = 16
  n2(366) = 16
  n2(367) = 16
  n2(368) = 16
  call heltable([8,2,16], n3(:,896), t3x16(:,:,548))
  n2(369) = 8
  call heltable([2,8,16], n3(:,897), t3x16(:,:,549))
  call heltable([2,8,16], n3(:,898), t3x16(:,:,550))
  n2(370) = 8
  call heltable([8,2,16], n3(:,899), t3x16(:,:,551))
  call heltable([2,8,16], n3(:,900), t3x16(:,:,552))
  call heltable([2,8,16], n3(:,901), t3x16(:,:,553))
  n2(371) = 16
  n2(372) = 16
  call heltable([2,16,32], n3(:,902), t3x32(:,:,237))
  call heltable([2,16,32], n3(:,903), t3x32(:,:,238))
  call heltable([2,16,32], n3(:,904), t3x32(:,:,239))
  call heltable([16,2,32], n3(:,905), t3x32(:,:,240))
  call heltable([16,2,32], n3(:,906), t3x32(:,:,241))
  call heltable([16,2,32], n3(:,907), t3x32(:,:,242))
  call heltable([8,2,16], n3(:,908), t3x16(:,:,554))
  n2(373) = 16
  n2(374) = 16
  n2(375) = 16
  n2(376) = 16
  n2(377) = 8
  call heltable([8,2,16], n3(:,909), t3x16(:,:,555))
  n2(378) = 8
  call heltable([2,8,16], n3(:,910), t3x16(:,:,556))
  call heltable([2,8,16], n3(:,911), t3x16(:,:,557))
  n2(379) = 16
  n2(380) = 16
  call heltable([2,8,16], n3(:,912), t3x16(:,:,558))
  call heltable([2,8,16], n3(:,913), t3x16(:,:,559))
  call heltable([2,16,32], n3(:,914), t3x32(:,:,243))
  call heltable([2,16,32], n3(:,915), t3x32(:,:,244))
  call heltable([2,16,32], n3(:,916), t3x32(:,:,245))
  call heltable([16,2,32], n3(:,917), t3x32(:,:,246))
  call heltable([16,2,32], n3(:,918), t3x32(:,:,247))
  call heltable([16,2,32], n3(:,919), t3x32(:,:,248))
  n2(381) = 16
  n2(382) = 16
  n2(383) = 16
  n2(384) = 16
  call heltable([8,2,16], n3(:,920), t3x16(:,:,560))
  call heltable([16,2,32], n3(:,921), t3x32(:,:,249))
  call heltable([16,2,32], n3(:,922), t3x32(:,:,250))
  call heltable([2,16,32], n3(:,923), t3x32(:,:,251))
  call heltable([2,16,32], n3(:,924), t3x32(:,:,252))
  call heltable([2,16,32], n3(:,925), t3x32(:,:,253))
  call heltable([2,16,32], n3(:,926), t3x32(:,:,254))
  call heltable([2,16,32], n3(:,927), t3x32(:,:,255))
  call heltable([2,16,32], n3(:,928), t3x32(:,:,256))
  call heltable([16,2,32], n3(:,929), t3x32(:,:,257))
  call heltable([16,2,32], n3(:,930), t3x32(:,:,258))
  call heltable([2,16,32], n3(:,931), t3x32(:,:,259))
  call heltable([2,16,32], n3(:,932), t3x32(:,:,260))
  call heltable([2,16,32], n3(:,933), t3x32(:,:,261))
  call heltable([2,16,32], n3(:,934), t3x32(:,:,262))
  call heltable([2,16,32], n3(:,935), t3x32(:,:,263))
  call heltable([2,16,32], n3(:,936), t3x32(:,:,264))
  call heltable([16,4,64], n3(:,937), t3x64(:,:,1))
  call heltable([16,4,64], n3(:,938), t3x64(:,:,2))
  call heltable([4,16,64], n3(:,939), t3x64(:,:,3))
  call heltable([4,16,64], n3(:,940), t3x64(:,:,4))
  call heltable([16,4,64], n3(:,941), t3x64(:,:,5))
  call heltable([16,4,64], n3(:,942), t3x64(:,:,6))
  call heltable([4,16,64], n3(:,943), t3x64(:,:,7))
  call heltable([4,16,64], n3(:,944), t3x64(:,:,8))
  call heltable([16,4,64], n3(:,945), t3x64(:,:,9))
  call heltable([16,4,64], n3(:,946), t3x64(:,:,10))
  call heltable([4,16,64], n3(:,947), t3x64(:,:,11))
  call heltable([4,16,64], n3(:,948), t3x64(:,:,12))
  call heltable([16,4,64], n3(:,949), t3x64(:,:,13))
  call heltable([16,4,64], n3(:,950), t3x64(:,:,14))
  call heltable([4,16,64], n3(:,951), t3x64(:,:,15))
  call heltable([4,16,64], n3(:,952), t3x64(:,:,16))
  call heltable([16,4,64], n3(:,953), t3x64(:,:,17))
  call heltable([16,4,64], n3(:,954), t3x64(:,:,18))
  call heltable([4,16,64], n3(:,955), t3x64(:,:,19))
  call heltable([4,16,64], n3(:,956), t3x64(:,:,20))
  call heltable([16,4,64], n3(:,957), t3x64(:,:,21))
  call heltable([16,4,64], n3(:,958), t3x64(:,:,22))
  call heltable([4,16,64], n3(:,959), t3x64(:,:,23))
  call heltable([4,16,64], n3(:,960), t3x64(:,:,24))
  call heltable([16,4,64], n3(:,961), t3x64(:,:,25))
  call heltable([16,4,64], n3(:,962), t3x64(:,:,26))
  call heltable([4,16,64], n3(:,963), t3x64(:,:,27))
  call heltable([4,16,64], n3(:,964), t3x64(:,:,28))
  call heltable([16,4,64], n3(:,965), t3x64(:,:,29))
  call heltable([16,4,64], n3(:,966), t3x64(:,:,30))
  call heltable([4,16,64], n3(:,967), t3x64(:,:,31))
  call heltable([4,16,64], n3(:,968), t3x64(:,:,32))
  call heltable([8,8,64], n3(:,969), t3x64(:,:,33))
  call heltable([8,8,64], n3(:,970), t3x64(:,:,34))
  n2(385) = 32
  n2(386) = 32
  call heltable([2,16,32], n3(:,971), t3x32(:,:,265))
  n2(387) = 32
  call heltable([2,16,32], n3(:,972), t3x32(:,:,266))
  n2(388) = 32
  call heltable([4,16,64], n3(:,973), t3x64(:,:,35))
  call heltable([4,16,64], n3(:,974), t3x64(:,:,36))
  call heltable([4,16,64], n3(:,975), t3x64(:,:,37))
  call heltable([4,16,64], n3(:,976), t3x64(:,:,38))
  call heltable([16,2,32], n3(:,977), t3x32(:,:,267))
  n2(389) = 32
  call heltable([16,2,32], n3(:,978), t3x32(:,:,268))
  n2(390) = 32
  call heltable([2,16,32], n3(:,979), t3x32(:,:,269))
  n2(391) = 32
  call heltable([2,16,32], n3(:,980), t3x32(:,:,270))
  n2(392) = 32
  call heltable([4,16,64], n3(:,981), t3x64(:,:,39))
  call heltable([4,16,64], n3(:,982), t3x64(:,:,40))
  call heltable([4,16,64], n3(:,983), t3x64(:,:,41))
  call heltable([4,16,64], n3(:,984), t3x64(:,:,42))
  call heltable([8,8,64], n3(:,985), t3x64(:,:,43))
  call heltable([8,8,64], n3(:,986), t3x64(:,:,44))
  n2(393) = 32
  n2(394) = 32
  call heltable([16,2,32], n3(:,987), t3x32(:,:,271))
  n2(395) = 32
  call heltable([16,2,32], n3(:,988), t3x32(:,:,272))
  n2(396) = 32
  call heltable([2,16,32], n3(:,989), t3x32(:,:,273))
  n2(397) = 32
  call heltable([2,16,32], n3(:,990), t3x32(:,:,274))
  n2(398) = 32
  call heltable([4,16,64], n3(:,991), t3x64(:,:,45))
  call heltable([4,16,64], n3(:,992), t3x64(:,:,46))
  call heltable([4,16,64], n3(:,993), t3x64(:,:,47))
  call heltable([4,16,64], n3(:,994), t3x64(:,:,48))
  call heltable([2,16,32], n3(:,995), t3x32(:,:,275))
  n2(399) = 32
  call heltable([2,16,32], n3(:,996), t3x32(:,:,276))
  n2(400) = 32
  call heltable([4,16,64], n3(:,997), t3x64(:,:,49))
  call heltable([4,16,64], n3(:,998), t3x64(:,:,50))
  call heltable([4,16,64], n3(:,999), t3x64(:,:,51))
  call heltable([4,16,64], n3(:,1000), t3x64(:,:,52))
  call heltable([8,8,64], n3(:,1001), t3x64(:,:,53))
  call heltable([8,8,64], n3(:,1002), t3x64(:,:,54))
  n2(401) = 32
  n2(402) = 32
  n2(403) = 32
  n2(404) = 32
  n2(405) = 32
  n2(406) = 32
  call heltable([4,16,64], n3(:,1003), t3x64(:,:,55))
  call heltable([4,16,64], n3(:,1004), t3x64(:,:,56))
  call heltable([4,16,64], n3(:,1005), t3x64(:,:,57))
  call heltable([4,16,64], n3(:,1006), t3x64(:,:,58))
  call heltable([2,16,32], n3(:,1007), t3x32(:,:,277))
  n2(407) = 32
  call heltable([2,16,32], n3(:,1008), t3x32(:,:,278))
  n2(408) = 32
  call heltable([4,16,64], n3(:,1009), t3x64(:,:,59))
  call heltable([4,16,64], n3(:,1010), t3x64(:,:,60))
  call heltable([4,16,64], n3(:,1011), t3x64(:,:,61))
  call heltable([4,16,64], n3(:,1012), t3x64(:,:,62))
  call heltable([8,8,64], n3(:,1013), t3x64(:,:,63))
  call heltable([8,8,64], n3(:,1014), t3x64(:,:,64))
  n2(409) = 32
  n2(410) = 32
  n2(411) = 32
  n2(412) = 32
  n2(413) = 32
  n2(414) = 32
  call heltable([4,16,64], n3(:,1015), t3x64(:,:,65))
  call heltable([4,16,64], n3(:,1016), t3x64(:,:,66))
  call heltable([4,16,64], n3(:,1017), t3x64(:,:,67))
  call heltable([4,16,64], n3(:,1018), t3x64(:,:,68))
  call heltable([2,16,32], n3(:,1019), t3x32(:,:,279))
  n2(415) = 32
  call heltable([2,16,32], n3(:,1020), t3x32(:,:,280))
  n2(416) = 32
  call heltable([4,16,64], n3(:,1021), t3x64(:,:,69))
  call heltable([4,16,64], n3(:,1022), t3x64(:,:,70))
  call heltable([4,16,64], n3(:,1023), t3x64(:,:,71))
  call heltable([4,16,64], n3(:,1024), t3x64(:,:,72))
  n2(417) = 32
  n2(418) = 32
  call heltable([2,16,32], n3(:,1025), t3x32(:,:,281))
  n2(419) = 32
  call heltable([2,16,32], n3(:,1026), t3x32(:,:,282))
  n2(420) = 32
  call heltable([4,16,64], n3(:,1027), t3x64(:,:,73))
  call heltable([4,16,64], n3(:,1028), t3x64(:,:,74))
  call heltable([4,16,64], n3(:,1029), t3x64(:,:,75))
  call heltable([4,16,64], n3(:,1030), t3x64(:,:,76))
  call heltable([16,2,32], n3(:,1031), t3x32(:,:,283))
  n2(421) = 32
  call heltable([16,2,32], n3(:,1032), t3x32(:,:,284))
  n2(422) = 32
  call heltable([2,16,32], n3(:,1033), t3x32(:,:,285))
  n2(423) = 32
  call heltable([2,16,32], n3(:,1034), t3x32(:,:,286))
  n2(424) = 32
  call heltable([4,16,64], n3(:,1035), t3x64(:,:,77))
  call heltable([4,16,64], n3(:,1036), t3x64(:,:,78))
  call heltable([4,16,64], n3(:,1037), t3x64(:,:,79))
  call heltable([4,16,64], n3(:,1038), t3x64(:,:,80))
  n2(425) = 32
  n2(426) = 32
  call heltable([16,2,32], n3(:,1039), t3x32(:,:,287))
  n2(427) = 32
  call heltable([16,2,32], n3(:,1040), t3x32(:,:,288))
  n2(428) = 32
  call heltable([2,16,32], n3(:,1041), t3x32(:,:,289))
  n2(429) = 32
  call heltable([2,16,32], n3(:,1042), t3x32(:,:,290))
  n2(430) = 32
  call heltable([4,16,64], n3(:,1043), t3x64(:,:,81))
  call heltable([4,16,64], n3(:,1044), t3x64(:,:,82))
  call heltable([4,16,64], n3(:,1045), t3x64(:,:,83))
  call heltable([4,16,64], n3(:,1046), t3x64(:,:,84))
  call heltable([2,16,32], n3(:,1047), t3x32(:,:,291))
  n2(431) = 32
  call heltable([2,16,32], n3(:,1048), t3x32(:,:,292))
  n2(432) = 32
  call heltable([4,16,64], n3(:,1049), t3x64(:,:,85))
  call heltable([4,16,64], n3(:,1050), t3x64(:,:,86))
  call heltable([4,16,64], n3(:,1051), t3x64(:,:,87))
  call heltable([4,16,64], n3(:,1052), t3x64(:,:,88))
  n2(433) = 32
  n2(434) = 32
  n2(435) = 32
  n2(436) = 32
  n2(437) = 32
  n2(438) = 32
  call heltable([4,16,64], n3(:,1053), t3x64(:,:,89))
  call heltable([4,16,64], n3(:,1054), t3x64(:,:,90))
  call heltable([4,16,64], n3(:,1055), t3x64(:,:,91))
  call heltable([4,16,64], n3(:,1056), t3x64(:,:,92))
  call heltable([2,16,32], n3(:,1057), t3x32(:,:,293))
  n2(439) = 32
  call heltable([2,16,32], n3(:,1058), t3x32(:,:,294))
  n2(440) = 32
  call heltable([4,16,64], n3(:,1059), t3x64(:,:,93))
  call heltable([4,16,64], n3(:,1060), t3x64(:,:,94))
  call heltable([4,16,64], n3(:,1061), t3x64(:,:,95))
  call heltable([4,16,64], n3(:,1062), t3x64(:,:,96))
  n2(441) = 32
  n2(442) = 32
  n2(443) = 32
  n2(444) = 32
  n2(445) = 32
  n2(446) = 32
  call heltable([4,16,64], n3(:,1063), t3x64(:,:,97))
  call heltable([4,16,64], n3(:,1064), t3x64(:,:,98))
  call heltable([4,16,64], n3(:,1065), t3x64(:,:,99))
  call heltable([4,16,64], n3(:,1066), t3x64(:,:,100))
  call heltable([2,16,32], n3(:,1067), t3x32(:,:,295))
  n2(447) = 32
  call heltable([2,16,32], n3(:,1068), t3x32(:,:,296))
  n2(448) = 32
  call heltable([4,16,64], n3(:,1069), t3x64(:,:,101))
  call heltable([4,16,64], n3(:,1070), t3x64(:,:,102))
  call heltable([4,16,64], n3(:,1071), t3x64(:,:,103))
  call heltable([4,16,64], n3(:,1072), t3x64(:,:,104))
  call heltable([16,4,64], n3(:,1073), t3x64(:,:,105))
  call heltable([16,4,64], n3(:,1074), t3x64(:,:,106))
  call heltable([16,4,64], n3(:,1075), t3x64(:,:,107))
  call heltable([16,4,64], n3(:,1076), t3x64(:,:,108))
  call heltable([16,4,64], n3(:,1077), t3x64(:,:,109))
  call heltable([16,4,64], n3(:,1078), t3x64(:,:,110))
  call heltable([4,16,64], n3(:,1079), t3x64(:,:,111))
  call heltable([16,4,64], n3(:,1080), t3x64(:,:,112))
  call heltable([2,16,32], n3(:,1081), t3x32(:,:,297))
  n2(449) = 32
  call heltable([16,2,32], n3(:,1082), t3x32(:,:,298))
  n2(450) = 32
  call heltable([16,2,32], n3(:,1083), t3x32(:,:,299))
  n2(451) = 32
  call heltable([4,16,64], n3(:,1084), t3x64(:,:,113))
  call heltable([4,16,64], n3(:,1085), t3x64(:,:,114))
  call heltable([16,4,64], n3(:,1086), t3x64(:,:,115))
  call heltable([16,4,64], n3(:,1087), t3x64(:,:,116))
  call heltable([32,2,64], n3(:,1088), t3x64(:,:,117))
  call heltable([2,16,32], n3(:,1089), t3x32(:,:,300))
  n2(452) = 32
  call heltable([16,2,32], n3(:,1090), t3x32(:,:,301))
  n2(453) = 32
  call heltable([16,2,32], n3(:,1091), t3x32(:,:,302))
  n2(454) = 32
  call heltable([4,16,64], n3(:,1092), t3x64(:,:,118))
  call heltable([4,16,64], n3(:,1093), t3x64(:,:,119))
  call heltable([16,4,64], n3(:,1094), t3x64(:,:,120))
  call heltable([16,4,64], n3(:,1095), t3x64(:,:,121))
  call heltable([2,32,64], n3(:,1096), t3x64(:,:,122))
  n2(455) = 32
  n2(456) = 32
  n2(457) = 32
  n2(458) = 32
  call heltable([4,16,64], n3(:,1097), t3x64(:,:,123))
  call heltable([4,16,64], n3(:,1098), t3x64(:,:,124))
  call heltable([4,16,64], n3(:,1099), t3x64(:,:,125))
  call heltable([4,16,64], n3(:,1100), t3x64(:,:,126))
  n2(459) = 32
  n2(460) = 32
  call heltable([4,16,64], n3(:,1101), t3x64(:,:,127))
  call heltable([4,16,64], n3(:,1102), t3x64(:,:,128))
  call heltable([2,32,64], n3(:,1103), t3x64(:,:,129))
  call heltable([32,2,64], n3(:,1104), t3x64(:,:,130))
  call heltable([32,2,64], n3(:,1105), t3x64(:,:,131))
  call heltable([2,32,64], n3(:,1106), t3x64(:,:,132))
  call heltable([32,2,64], n3(:,1107), t3x64(:,:,133))
  call heltable([32,2,64], n3(:,1108), t3x64(:,:,134))
  call heltable([32,2,64], n3(:,1109), t3x64(:,:,135))
  call heltable([2,32,64], n3(:,1110), t3x64(:,:,136))
  call heltable([2,32,64], n3(:,1111), t3x64(:,:,137))
  call heltable([16,4,64], n3(:,1112), t3x64(:,:,138))
  call heltable([16,4,64], n3(:,1113), t3x64(:,:,139))
  call heltable([4,16,64], n3(:,1114), t3x64(:,:,140))
  call heltable([16,4,64], n3(:,1115), t3x64(:,:,141))
  call heltable([16,4,64], n3(:,1116), t3x64(:,:,142))
  call heltable([16,4,64], n3(:,1117), t3x64(:,:,143))
  call heltable([16,4,64], n3(:,1118), t3x64(:,:,144))
  call heltable([16,4,64], n3(:,1119), t3x64(:,:,145))
  call heltable([2,16,32], n3(:,1120), t3x32(:,:,303))
  n2(461) = 32
  call heltable([16,2,32], n3(:,1121), t3x32(:,:,304))
  n2(462) = 32
  call heltable([16,2,32], n3(:,1122), t3x32(:,:,305))
  n2(463) = 32
  call heltable([4,16,64], n3(:,1123), t3x64(:,:,146))
  call heltable([4,16,64], n3(:,1124), t3x64(:,:,147))
  call heltable([16,4,64], n3(:,1125), t3x64(:,:,148))
  call heltable([16,4,64], n3(:,1126), t3x64(:,:,149))
  call heltable([32,2,64], n3(:,1127), t3x64(:,:,150))
  call heltable([2,16,32], n3(:,1128), t3x32(:,:,306))
  n2(464) = 32
  call heltable([16,2,32], n3(:,1129), t3x32(:,:,307))
  n2(465) = 32
  call heltable([16,2,32], n3(:,1130), t3x32(:,:,308))
  n2(466) = 32
  call heltable([4,16,64], n3(:,1131), t3x64(:,:,151))
  call heltable([4,16,64], n3(:,1132), t3x64(:,:,152))
  call heltable([16,4,64], n3(:,1133), t3x64(:,:,153))
  call heltable([16,4,64], n3(:,1134), t3x64(:,:,154))
  call heltable([2,32,64], n3(:,1135), t3x64(:,:,155))
  n2(467) = 32
  n2(468) = 32
  n2(469) = 32
  n2(470) = 32
  n2(471) = 32
  call heltable([4,16,64], n3(:,1136), t3x64(:,:,156))
  call heltable([4,16,64], n3(:,1137), t3x64(:,:,157))
  call heltable([4,16,64], n3(:,1138), t3x64(:,:,158))
  call heltable([4,16,64], n3(:,1139), t3x64(:,:,159))
  n2(472) = 32
  call heltable([4,16,64], n3(:,1140), t3x64(:,:,160))
  call heltable([4,16,64], n3(:,1141), t3x64(:,:,161))
  call heltable([2,32,64], n3(:,1142), t3x64(:,:,162))
  call heltable([32,2,64], n3(:,1143), t3x64(:,:,163))
  call heltable([32,2,64], n3(:,1144), t3x64(:,:,164))
  call heltable([2,32,64], n3(:,1145), t3x64(:,:,165))
  call heltable([32,2,64], n3(:,1146), t3x64(:,:,166))
  call heltable([32,2,64], n3(:,1147), t3x64(:,:,167))
  call heltable([32,2,64], n3(:,1148), t3x64(:,:,168))
  call heltable([2,32,64], n3(:,1149), t3x64(:,:,169))
  call heltable([2,32,64], n3(:,1150), t3x64(:,:,170))
  call heltable([2,16,32], n3(:,1151), t3x32(:,:,309))
  n2(473) = 32
  call heltable([16,2,32], n3(:,1152), t3x32(:,:,310))
  n2(474) = 32
  call heltable([16,2,32], n3(:,1153), t3x32(:,:,311))
  n2(475) = 32
  call heltable([16,4,64], n3(:,1154), t3x64(:,:,171))
  call heltable([16,4,64], n3(:,1155), t3x64(:,:,172))
  call heltable([16,4,64], n3(:,1156), t3x64(:,:,173))
  call heltable([16,4,64], n3(:,1157), t3x64(:,:,174))
  call heltable([32,2,64], n3(:,1158), t3x64(:,:,175))
  call heltable([2,16,32], n3(:,1159), t3x32(:,:,312))
  n2(476) = 32
  call heltable([16,2,32], n3(:,1160), t3x32(:,:,313))
  n2(477) = 32
  call heltable([16,2,32], n3(:,1161), t3x32(:,:,314))
  n2(478) = 32
  call heltable([16,4,64], n3(:,1162), t3x64(:,:,176))
  call heltable([16,4,64], n3(:,1163), t3x64(:,:,177))
  call heltable([16,4,64], n3(:,1164), t3x64(:,:,178))
  call heltable([16,4,64], n3(:,1165), t3x64(:,:,179))
  call heltable([2,32,64], n3(:,1166), t3x64(:,:,180))
  n2(479) = 32
  n2(480) = 32
  n2(481) = 32
  n2(482) = 32
  call heltable([4,16,64], n3(:,1167), t3x64(:,:,181))
  call heltable([4,16,64], n3(:,1168), t3x64(:,:,182))
  call heltable([4,16,64], n3(:,1169), t3x64(:,:,183))
  call heltable([4,16,64], n3(:,1170), t3x64(:,:,184))
  n2(483) = 32
  n2(484) = 32
  call heltable([4,16,64], n3(:,1171), t3x64(:,:,185))
  call heltable([4,16,64], n3(:,1172), t3x64(:,:,186))
  call heltable([2,32,64], n3(:,1173), t3x64(:,:,187))
  call heltable([32,2,64], n3(:,1174), t3x64(:,:,188))
  call heltable([32,2,64], n3(:,1175), t3x64(:,:,189))
  call heltable([2,32,64], n3(:,1176), t3x64(:,:,190))
  call heltable([32,2,64], n3(:,1177), t3x64(:,:,191))
  call heltable([32,2,64], n3(:,1178), t3x64(:,:,192))
  call heltable([32,2,64], n3(:,1179), t3x64(:,:,193))
  call heltable([2,32,64], n3(:,1180), t3x64(:,:,194))
  call heltable([2,32,64], n3(:,1181), t3x64(:,:,195))
  call heltable([2,16,32], n3(:,1182), t3x32(:,:,315))
  n2(485) = 32
  call heltable([16,2,32], n3(:,1183), t3x32(:,:,316))
  n2(486) = 32
  call heltable([16,2,32], n3(:,1184), t3x32(:,:,317))
  n2(487) = 32
  call heltable([16,4,64], n3(:,1185), t3x64(:,:,196))
  call heltable([16,4,64], n3(:,1186), t3x64(:,:,197))
  call heltable([16,4,64], n3(:,1187), t3x64(:,:,198))
  call heltable([16,4,64], n3(:,1188), t3x64(:,:,199))
  call heltable([32,2,64], n3(:,1189), t3x64(:,:,200))
  call heltable([2,16,32], n3(:,1190), t3x32(:,:,318))
  n2(488) = 32
  call heltable([16,2,32], n3(:,1191), t3x32(:,:,319))
  n2(489) = 32
  call heltable([16,2,32], n3(:,1192), t3x32(:,:,320))
  n2(490) = 32
  call heltable([16,4,64], n3(:,1193), t3x64(:,:,201))
  call heltable([16,4,64], n3(:,1194), t3x64(:,:,202))
  call heltable([16,4,64], n3(:,1195), t3x64(:,:,203))
  call heltable([16,4,64], n3(:,1196), t3x64(:,:,204))
  call heltable([2,32,64], n3(:,1197), t3x64(:,:,205))
  n2(491) = 32
  n2(492) = 32
  n2(493) = 32
  n2(494) = 32
  n2(495) = 32
  call heltable([4,16,64], n3(:,1198), t3x64(:,:,206))
  call heltable([4,16,64], n3(:,1199), t3x64(:,:,207))
  call heltable([4,16,64], n3(:,1200), t3x64(:,:,208))
  call heltable([4,16,64], n3(:,1201), t3x64(:,:,209))
  n2(496) = 32
  call heltable([4,16,64], n3(:,1202), t3x64(:,:,210))
  call heltable([4,16,64], n3(:,1203), t3x64(:,:,211))
  call heltable([2,32,64], n3(:,1204), t3x64(:,:,212))
  call heltable([32,2,64], n3(:,1205), t3x64(:,:,213))
  call heltable([32,2,64], n3(:,1206), t3x64(:,:,214))
  call heltable([2,32,64], n3(:,1207), t3x64(:,:,215))
  call heltable([32,2,64], n3(:,1208), t3x64(:,:,216))
  call heltable([32,2,64], n3(:,1209), t3x64(:,:,217))
  call heltable([32,2,64], n3(:,1210), t3x64(:,:,218))
  call heltable([2,32,64], n3(:,1211), t3x64(:,:,219))
  call heltable([2,32,64], n3(:,1212), t3x64(:,:,220))
  call heltable([2,32,64], n3(:,1213), t3x64(:,:,221))
  call heltable([2,32,64], n3(:,1214), t3x64(:,:,222))
  call heltable([32,2,64], n3(:,1215), t3x64(:,:,223))
  call heltable([32,2,64], n3(:,1216), t3x64(:,:,224))
  call heltable([32,2,64], n3(:,1217), t3x64(:,:,225))
  call heltable([32,2,64], n3(:,1218), t3x64(:,:,226))
  call heltable([32,2,64], n3(:,1219), t3x64(:,:,227))
  call heltable([32,2,64], n3(:,1220), t3x64(:,:,228))
  call heltable([2,32,64], n3(:,1221), t3x64(:,:,229))
  call heltable([2,32,64], n3(:,1222), t3x64(:,:,230))
  call heltable([32,2,64], n3(:,1223), t3x64(:,:,231))
  call heltable([32,2,64], n3(:,1224), t3x64(:,:,232))
  call heltable([2,32,64], n3(:,1225), t3x64(:,:,233))
  call heltable([2,32,64], n3(:,1226), t3x64(:,:,234))
  call heltable([2,32,64], n3(:,1227), t3x64(:,:,235))
  call heltable([2,32,64], n3(:,1228), t3x64(:,:,236))
  call heltable([32,2,64], n3(:,1229), t3x64(:,:,237))
  call heltable([32,2,64], n3(:,1230), t3x64(:,:,238))
  call heltable([32,2,64], n3(:,1231), t3x64(:,:,239))
  call heltable([32,2,64], n3(:,1232), t3x64(:,:,240))
  call heltable([32,2,64], n3(:,1233), t3x64(:,:,241))
  call heltable([32,2,64], n3(:,1234), t3x64(:,:,242))
  call heltable([32,2,64], n3(:,1235), t3x64(:,:,243))
  call heltable([32,2,64], n3(:,1236), t3x64(:,:,244))
  call heltable([2,32,64], n3(:,1237), t3x64(:,:,245))
  call heltable([2,32,64], n3(:,1238), t3x64(:,:,246))
  call heltable([2,32,64], n3(:,1239), t3x64(:,:,247))
  call heltable([2,32,64], n3(:,1240), t3x64(:,:,248))
  call heltable([2,32,64], n3(:,1241), t3x64(:,:,249))
  call heltable([2,32,64], n3(:,1242), t3x64(:,:,250))
  call heltable([32,2,64], n3(:,1243), t3x64(:,:,251))
  call heltable([32,2,64], n3(:,1244), t3x64(:,:,252))
  call heltable([32,2,64], n3(:,1245), t3x64(:,:,253))
  call heltable([32,2,64], n3(:,1246), t3x64(:,:,254))
  call heltable([32,2,64], n3(:,1247), t3x64(:,:,255))
  call heltable([32,2,64], n3(:,1248), t3x64(:,:,256))
  call heltable([32,2,64], n3(:,1249), t3x64(:,:,257))
  call heltable([32,2,64], n3(:,1250), t3x64(:,:,258))
  call heltable([2,32,64], n3(:,1251), t3x64(:,:,259))
  call heltable([2,32,64], n3(:,1252), t3x64(:,:,260))
  call heltable([2,32,64], n3(:,1253), t3x64(:,:,261))
  call heltable([2,32,64], n3(:,1254), t3x64(:,:,262))
  call heltable([2,32,64], n3(:,1255), t3x64(:,:,263))
  call heltable([2,32,64], n3(:,1256), t3x64(:,:,264))
  call heltable([32,2,64], n3(:,1257), t3x64(:,:,265))
  call heltable([32,2,64], n3(:,1258), t3x64(:,:,266))
  call heltable([32,2,64], n3(:,1259), t3x64(:,:,267))
  call heltable([32,2,64], n3(:,1260), t3x64(:,:,268))
  call heltable([32,2,64], n3(:,1261), t3x64(:,:,269))
  call heltable([32,2,64], n3(:,1262), t3x64(:,:,270))
  call heltable([32,2,64], n3(:,1263), t3x64(:,:,271))
  call heltable([32,2,64], n3(:,1264), t3x64(:,:,272))
  call heltable([2,32,64], n3(:,1265), t3x64(:,:,273))
  call heltable([2,32,64], n3(:,1266), t3x64(:,:,274))
  call heltable([2,32,64], n3(:,1267), t3x64(:,:,275))
  call heltable([2,32,64], n3(:,1268), t3x64(:,:,276))
  call heltable([16,4,64], n3(:,1269), t3x64(:,:,277))
  call heltable([16,4,64], n3(:,1270), t3x64(:,:,278))
  call heltable([16,4,64], n3(:,1271), t3x64(:,:,279))
  call heltable([16,4,64], n3(:,1272), t3x64(:,:,280))
  call heltable([16,4,64], n3(:,1273), t3x64(:,:,281))
  call heltable([16,4,64], n3(:,1274), t3x64(:,:,282))
  call heltable([4,16,64], n3(:,1275), t3x64(:,:,283))
  call heltable([16,4,64], n3(:,1276), t3x64(:,:,284))
  n2(497) = 32
  n2(498) = 32
  n2(499) = 32
  n2(500) = 32
  call heltable([4,16,64], n3(:,1277), t3x64(:,:,285))
  call heltable([4,16,64], n3(:,1278), t3x64(:,:,286))
  call heltable([4,16,64], n3(:,1279), t3x64(:,:,287))
  call heltable([4,16,64], n3(:,1280), t3x64(:,:,288))
  n2(501) = 32
  n2(502) = 32
  call heltable([4,16,64], n3(:,1281), t3x64(:,:,289))
  call heltable([4,16,64], n3(:,1282), t3x64(:,:,290))
  call heltable([2,32,64], n3(:,1283), t3x64(:,:,291))
  call heltable([32,2,64], n3(:,1284), t3x64(:,:,292))
  call heltable([32,2,64], n3(:,1285), t3x64(:,:,293))
  call heltable([2,32,64], n3(:,1286), t3x64(:,:,294))
  call heltable([2,16,32], n3(:,1287), t3x32(:,:,321))
  n2(503) = 32
  call heltable([2,16,32], n3(:,1288), t3x32(:,:,322))
  n2(504) = 32
  call heltable([32,2,64], n3(:,1289), t3x64(:,:,295))
  call heltable([16,2,32], n3(:,1290), t3x32(:,:,323))
  n2(505) = 32
  call heltable([16,2,32], n3(:,1291), t3x32(:,:,324))
  n2(506) = 32
  call heltable([4,16,64], n3(:,1292), t3x64(:,:,296))
  call heltable([4,16,64], n3(:,1293), t3x64(:,:,297))
  call heltable([16,4,64], n3(:,1294), t3x64(:,:,298))
  call heltable([16,4,64], n3(:,1295), t3x64(:,:,299))
  call heltable([32,2,64], n3(:,1296), t3x64(:,:,300))
  call heltable([16,2,32], n3(:,1297), t3x32(:,:,325))
  n2(507) = 32
  call heltable([16,2,32], n3(:,1298), t3x32(:,:,326))
  n2(508) = 32
  call heltable([4,16,64], n3(:,1299), t3x64(:,:,301))
  call heltable([4,16,64], n3(:,1300), t3x64(:,:,302))
  call heltable([16,4,64], n3(:,1301), t3x64(:,:,303))
  call heltable([16,4,64], n3(:,1302), t3x64(:,:,304))
  call heltable([2,32,64], n3(:,1303), t3x64(:,:,305))
  call heltable([32,2,64], n3(:,1304), t3x64(:,:,306))
  call heltable([32,2,64], n3(:,1305), t3x64(:,:,307))
  call heltable([2,32,64], n3(:,1306), t3x64(:,:,308))
  call heltable([2,32,64], n3(:,1307), t3x64(:,:,309))
  call heltable([16,4,64], n3(:,1308), t3x64(:,:,310))
  call heltable([16,4,64], n3(:,1309), t3x64(:,:,311))
  call heltable([4,16,64], n3(:,1310), t3x64(:,:,312))
  call heltable([16,4,64], n3(:,1311), t3x64(:,:,313))
  call heltable([16,4,64], n3(:,1312), t3x64(:,:,314))
  call heltable([16,4,64], n3(:,1313), t3x64(:,:,315))
  call heltable([16,4,64], n3(:,1314), t3x64(:,:,316))
  call heltable([16,4,64], n3(:,1315), t3x64(:,:,317))
  n2(509) = 32
  n2(510) = 32
  n2(511) = 32
  n2(512) = 32
  n2(513) = 32
  call heltable([4,16,64], n3(:,1316), t3x64(:,:,318))
  call heltable([4,16,64], n3(:,1317), t3x64(:,:,319))
  call heltable([4,16,64], n3(:,1318), t3x64(:,:,320))
  call heltable([4,16,64], n3(:,1319), t3x64(:,:,321))
  n2(514) = 32
  call heltable([4,16,64], n3(:,1320), t3x64(:,:,322))
  call heltable([4,16,64], n3(:,1321), t3x64(:,:,323))
  call heltable([2,32,64], n3(:,1322), t3x64(:,:,324))
  call heltable([32,2,64], n3(:,1323), t3x64(:,:,325))
  call heltable([32,2,64], n3(:,1324), t3x64(:,:,326))
  call heltable([2,16,32], n3(:,1325), t3x32(:,:,327))
  n2(515) = 32
  call heltable([2,32,64], n3(:,1326), t3x64(:,:,327))
  call heltable([2,16,32], n3(:,1327), t3x32(:,:,328))
  n2(516) = 32
  call heltable([32,2,64], n3(:,1328), t3x64(:,:,328))
  call heltable([16,2,32], n3(:,1329), t3x32(:,:,329))
  n2(517) = 32
  call heltable([16,2,32], n3(:,1330), t3x32(:,:,330))
  n2(518) = 32
  call heltable([4,16,64], n3(:,1331), t3x64(:,:,329))
  call heltable([4,16,64], n3(:,1332), t3x64(:,:,330))
  call heltable([16,4,64], n3(:,1333), t3x64(:,:,331))
  call heltable([16,4,64], n3(:,1334), t3x64(:,:,332))
  call heltable([32,2,64], n3(:,1335), t3x64(:,:,333))
  call heltable([16,2,32], n3(:,1336), t3x32(:,:,331))
  n2(519) = 32
  call heltable([16,2,32], n3(:,1337), t3x32(:,:,332))
  n2(520) = 32
  call heltable([4,16,64], n3(:,1338), t3x64(:,:,334))
  call heltable([4,16,64], n3(:,1339), t3x64(:,:,335))
  call heltable([16,4,64], n3(:,1340), t3x64(:,:,336))
  call heltable([16,4,64], n3(:,1341), t3x64(:,:,337))
  call heltable([2,32,64], n3(:,1342), t3x64(:,:,338))
  call heltable([32,2,64], n3(:,1343), t3x64(:,:,339))
  call heltable([32,2,64], n3(:,1344), t3x64(:,:,340))
  call heltable([2,32,64], n3(:,1345), t3x64(:,:,341))
  call heltable([2,32,64], n3(:,1346), t3x64(:,:,342))
  n2(521) = 32
  n2(522) = 32
  n2(523) = 32
  n2(524) = 32
  call heltable([4,16,64], n3(:,1347), t3x64(:,:,343))
  call heltable([4,16,64], n3(:,1348), t3x64(:,:,344))
  call heltable([4,16,64], n3(:,1349), t3x64(:,:,345))
  call heltable([4,16,64], n3(:,1350), t3x64(:,:,346))
  n2(525) = 32
  n2(526) = 32
  call heltable([4,16,64], n3(:,1351), t3x64(:,:,347))
  call heltable([4,16,64], n3(:,1352), t3x64(:,:,348))
  call heltable([2,32,64], n3(:,1353), t3x64(:,:,349))
  call heltable([32,2,64], n3(:,1354), t3x64(:,:,350))
  call heltable([32,2,64], n3(:,1355), t3x64(:,:,351))
  call heltable([2,32,64], n3(:,1356), t3x64(:,:,352))
  call heltable([2,16,32], n3(:,1357), t3x32(:,:,333))
  n2(527) = 32
  call heltable([2,16,32], n3(:,1358), t3x32(:,:,334))
  n2(528) = 32
  call heltable([32,2,64], n3(:,1359), t3x64(:,:,353))
  call heltable([16,2,32], n3(:,1360), t3x32(:,:,335))
  n2(529) = 32
  call heltable([16,2,32], n3(:,1361), t3x32(:,:,336))
  n2(530) = 32
  call heltable([16,4,64], n3(:,1362), t3x64(:,:,354))
  call heltable([16,4,64], n3(:,1363), t3x64(:,:,355))
  call heltable([16,4,64], n3(:,1364), t3x64(:,:,356))
  call heltable([16,4,64], n3(:,1365), t3x64(:,:,357))
  call heltable([32,2,64], n3(:,1366), t3x64(:,:,358))
  call heltable([16,2,32], n3(:,1367), t3x32(:,:,337))
  n2(531) = 32
  call heltable([16,2,32], n3(:,1368), t3x32(:,:,338))
  n2(532) = 32
  call heltable([16,4,64], n3(:,1369), t3x64(:,:,359))
  call heltable([16,4,64], n3(:,1370), t3x64(:,:,360))
  call heltable([16,4,64], n3(:,1371), t3x64(:,:,361))
  call heltable([16,4,64], n3(:,1372), t3x64(:,:,362))
  call heltable([2,32,64], n3(:,1373), t3x64(:,:,363))
  call heltable([32,2,64], n3(:,1374), t3x64(:,:,364))
  call heltable([32,2,64], n3(:,1375), t3x64(:,:,365))
  call heltable([2,32,64], n3(:,1376), t3x64(:,:,366))
  call heltable([2,32,64], n3(:,1377), t3x64(:,:,367))
  n2(533) = 32
  n2(534) = 32
  n2(535) = 32
  n2(536) = 32
  n2(537) = 32
  call heltable([4,16,64], n3(:,1378), t3x64(:,:,368))
  call heltable([4,16,64], n3(:,1379), t3x64(:,:,369))
  call heltable([4,16,64], n3(:,1380), t3x64(:,:,370))
  call heltable([4,16,64], n3(:,1381), t3x64(:,:,371))
  n2(538) = 32
  call heltable([4,16,64], n3(:,1382), t3x64(:,:,372))
  call heltable([4,16,64], n3(:,1383), t3x64(:,:,373))
  call heltable([2,32,64], n3(:,1384), t3x64(:,:,374))
  call heltable([32,2,64], n3(:,1385), t3x64(:,:,375))
  call heltable([32,2,64], n3(:,1386), t3x64(:,:,376))
  call heltable([2,16,32], n3(:,1387), t3x32(:,:,339))
  n2(539) = 32
  call heltable([2,32,64], n3(:,1388), t3x64(:,:,377))
  call heltable([2,16,32], n3(:,1389), t3x32(:,:,340))
  n2(540) = 32
  call heltable([32,2,64], n3(:,1390), t3x64(:,:,378))
  call heltable([16,2,32], n3(:,1391), t3x32(:,:,341))
  n2(541) = 32
  call heltable([16,2,32], n3(:,1392), t3x32(:,:,342))
  n2(542) = 32
  call heltable([16,4,64], n3(:,1393), t3x64(:,:,379))
  call heltable([16,4,64], n3(:,1394), t3x64(:,:,380))
  call heltable([16,4,64], n3(:,1395), t3x64(:,:,381))
  call heltable([16,4,64], n3(:,1396), t3x64(:,:,382))
  call heltable([32,2,64], n3(:,1397), t3x64(:,:,383))
  call heltable([16,2,32], n3(:,1398), t3x32(:,:,343))
  n2(543) = 32
  call heltable([16,2,32], n3(:,1399), t3x32(:,:,344))
  n2(544) = 32
  call heltable([16,4,64], n3(:,1400), t3x64(:,:,384))
  call heltable([16,4,64], n3(:,1401), t3x64(:,:,385))
  call heltable([16,4,64], n3(:,1402), t3x64(:,:,386))
  call heltable([16,4,64], n3(:,1403), t3x64(:,:,387))
  call heltable([2,32,64], n3(:,1404), t3x64(:,:,388))
  call heltable([32,2,64], n3(:,1405), t3x64(:,:,389))
  call heltable([32,2,64], n3(:,1406), t3x64(:,:,390))
  call heltable([2,32,64], n3(:,1407), t3x64(:,:,391))
  call heltable([2,32,64], n3(:,1408), t3x64(:,:,392))
  call heltable([2,32,64], n3(:,1409), t3x64(:,:,393))
  call heltable([2,32,64], n3(:,1410), t3x64(:,:,394))
  call heltable([2,32,64], n3(:,1411), t3x64(:,:,395))
  call heltable([2,32,64], n3(:,1412), t3x64(:,:,396))
  call heltable([2,32,64], n3(:,1413), t3x64(:,:,397))
  call heltable([2,32,64], n3(:,1414), t3x64(:,:,398))
  call heltable([2,32,64], n3(:,1415), t3x64(:,:,399))
  call heltable([2,32,64], n3(:,1416), t3x64(:,:,400))
  call heltable([32,2,64], n3(:,1417), t3x64(:,:,401))
  call heltable([32,2,64], n3(:,1418), t3x64(:,:,402))
  call heltable([32,2,64], n3(:,1419), t3x64(:,:,403))
  call heltable([32,2,64], n3(:,1420), t3x64(:,:,404))
  call heltable([32,2,64], n3(:,1421), t3x64(:,:,405))
  call heltable([32,2,64], n3(:,1422), t3x64(:,:,406))
  call heltable([32,2,64], n3(:,1423), t3x64(:,:,407))
  call heltable([32,2,64], n3(:,1424), t3x64(:,:,408))
  call heltable([32,2,64], n3(:,1425), t3x64(:,:,409))
  call heltable([32,2,64], n3(:,1426), t3x64(:,:,410))
  call heltable([32,2,64], n3(:,1427), t3x64(:,:,411))
  call heltable([32,2,64], n3(:,1428), t3x64(:,:,412))
  call heltable([32,2,64], n3(:,1429), t3x64(:,:,413))
  call heltable([32,2,64], n3(:,1430), t3x64(:,:,414))
  call heltable([32,2,64], n3(:,1431), t3x64(:,:,415))
  call heltable([32,2,64], n3(:,1432), t3x64(:,:,416))
  call heltable([32,2,64], n3(:,1433), t3x64(:,:,417))
  call heltable([32,2,64], n3(:,1434), t3x64(:,:,418))
  call heltable([2,32,64], n3(:,1435), t3x64(:,:,419))
  call heltable([2,32,64], n3(:,1436), t3x64(:,:,420))
  call heltable([32,2,64], n3(:,1437), t3x64(:,:,421))
  call heltable([32,2,64], n3(:,1438), t3x64(:,:,422))
  call heltable([2,32,64], n3(:,1439), t3x64(:,:,423))
  call heltable([2,32,64], n3(:,1440), t3x64(:,:,424))
  call heltable([32,2,64], n3(:,1441), t3x64(:,:,425))
  call heltable([32,2,64], n3(:,1442), t3x64(:,:,426))
  call heltable([32,2,64], n3(:,1443), t3x64(:,:,427))
  call heltable([32,2,64], n3(:,1444), t3x64(:,:,428))
  call heltable([2,32,64], n3(:,1445), t3x64(:,:,429))
  call heltable([2,32,64], n3(:,1446), t3x64(:,:,430))
  call heltable([2,32,64], n3(:,1447), t3x64(:,:,431))
  call heltable([2,32,64], n3(:,1448), t3x64(:,:,432))
  call heltable([32,2,64], n3(:,1449), t3x64(:,:,433))
  call heltable([32,2,64], n3(:,1450), t3x64(:,:,434))
  call heltable([32,2,64], n3(:,1451), t3x64(:,:,435))
  call heltable([32,2,64], n3(:,1452), t3x64(:,:,436))
  call heltable([2,32,64], n3(:,1453), t3x64(:,:,437))
  call heltable([2,32,64], n3(:,1454), t3x64(:,:,438))
  call heltable([2,32,64], n3(:,1455), t3x64(:,:,439))
  call heltable([2,32,64], n3(:,1456), t3x64(:,:,440))
  call heltable([32,2,64], n3(:,1457), t3x64(:,:,441))
  call heltable([32,2,64], n3(:,1458), t3x64(:,:,442))
  call heltable([32,2,64], n3(:,1459), t3x64(:,:,443))
  call heltable([32,2,64], n3(:,1460), t3x64(:,:,444))
  call heltable([2,32,64], n3(:,1461), t3x64(:,:,445))
  call heltable([2,32,64], n3(:,1462), t3x64(:,:,446))
  call heltable([2,32,64], n3(:,1463), t3x64(:,:,447))
  call heltable([2,32,64], n3(:,1464), t3x64(:,:,448))
  n2(545) = 32
  n2(546) = 32
  n2(547) = 32
  n2(548) = 32
  n2(549) = 32
  n2(550) = 32
  n2(551) = 32
  call heltable([16,2,32], n3(:,1465), t3x32(:,:,345))
  n2(552) = 32
  call heltable([16,2,32], n3(:,1466), t3x32(:,:,346))
  n2(553) = 32
  call heltable([16,4,64], n3(:,1467), t3x64(:,:,449))
  call heltable([16,4,64], n3(:,1468), t3x64(:,:,450))
  call heltable([16,4,64], n3(:,1469), t3x64(:,:,451))
  call heltable([16,4,64], n3(:,1470), t3x64(:,:,452))
  n2(554) = 32
  call heltable([16,2,32], n3(:,1471), t3x32(:,:,347))
  n2(555) = 32
  call heltable([16,2,32], n3(:,1472), t3x32(:,:,348))
  n2(556) = 32
  call heltable([4,16,64], n3(:,1473), t3x64(:,:,453))
  call heltable([4,16,64], n3(:,1474), t3x64(:,:,454))
  call heltable([16,4,64], n3(:,1475), t3x64(:,:,455))
  call heltable([16,4,64], n3(:,1476), t3x64(:,:,456))
  call heltable([16,4,64], n3(:,1477), t3x64(:,:,457))
  call heltable([16,4,64], n3(:,1478), t3x64(:,:,458))
  call heltable([4,16,64], n3(:,1479), t3x64(:,:,459))
  call heltable([16,4,64], n3(:,1480), t3x64(:,:,460))
  call heltable([2,16,32], n3(:,1481), t3x32(:,:,349))
  n2(557) = 32
  call heltable([2,16,32], n3(:,1482), t3x32(:,:,350))
  n2(558) = 32
  call heltable([8,8,64], n3(:,1483), t3x64(:,:,461))
  call heltable([8,8,64], n3(:,1484), t3x64(:,:,462))
  call heltable([16,2,32], n3(:,1485), t3x32(:,:,351))
  n2(559) = 32
  call heltable([16,2,32], n3(:,1486), t3x32(:,:,352))
  n2(560) = 32
  call heltable([16,2,32], n3(:,1487), t3x32(:,:,353))
  n2(561) = 32
  call heltable([16,2,32], n3(:,1488), t3x32(:,:,354))
  n2(562) = 32
  call heltable([16,4,64], n3(:,1489), t3x64(:,:,463))
  call heltable([16,4,64], n3(:,1490), t3x64(:,:,464))
  call heltable([16,4,64], n3(:,1491), t3x64(:,:,465))
  call heltable([16,4,64], n3(:,1492), t3x64(:,:,466))
  call heltable([16,2,32], n3(:,1493), t3x32(:,:,355))
  n2(563) = 32
  call heltable([16,2,32], n3(:,1494), t3x32(:,:,356))
  n2(564) = 32
  call heltable([4,16,64], n3(:,1495), t3x64(:,:,467))
  call heltable([4,16,64], n3(:,1496), t3x64(:,:,468))
  call heltable([16,4,64], n3(:,1497), t3x64(:,:,469))
  call heltable([16,4,64], n3(:,1498), t3x64(:,:,470))
  call heltable([16,4,64], n3(:,1499), t3x64(:,:,471))
  call heltable([16,4,64], n3(:,1500), t3x64(:,:,472))
  call heltable([4,16,64], n3(:,1501), t3x64(:,:,473))
  call heltable([16,4,64], n3(:,1502), t3x64(:,:,474))
  call heltable([8,8,64], n3(:,1503), t3x64(:,:,475))
  call heltable([8,8,64], n3(:,1504), t3x64(:,:,476))
  call heltable([2,32,64], n3(:,1505), t3x64(:,:,477))
  call heltable([2,32,64], n3(:,1506), t3x64(:,:,478))
  call heltable([2,32,64], n3(:,1507), t3x64(:,:,479))
  call heltable([32,2,64], n3(:,1508), t3x64(:,:,480))
  call heltable([2,32,64], n3(:,1509), t3x64(:,:,481))
  call heltable([32,2,64], n3(:,1510), t3x64(:,:,482))
  call heltable([32,2,64], n3(:,1511), t3x64(:,:,483))
  call heltable([32,2,64], n3(:,1512), t3x64(:,:,484))
  call heltable([32,2,64], n3(:,1513), t3x64(:,:,485))
  call heltable([2,32,64], n3(:,1514), t3x64(:,:,486))
  call heltable([2,32,64], n3(:,1515), t3x64(:,:,487))
  call heltable([32,2,64], n3(:,1516), t3x64(:,:,488))
  call heltable([2,32,64], n3(:,1517), t3x64(:,:,489))
  call heltable([32,2,64], n3(:,1518), t3x64(:,:,490))
  call heltable([32,2,64], n3(:,1519), t3x64(:,:,491))
  call heltable([32,2,64], n3(:,1520), t3x64(:,:,492))
  call heltable([32,2,64], n3(:,1521), t3x64(:,:,493))
  call heltable([32,2,64], n3(:,1522), t3x64(:,:,494))
  call heltable([2,32,64], n3(:,1523), t3x64(:,:,495))
  call heltable([2,32,64], n3(:,1524), t3x64(:,:,496))
  call heltable([32,2,64], n3(:,1525), t3x64(:,:,497))
  call heltable([2,32,64], n3(:,1526), t3x64(:,:,498))
  n2(565) = 32
  n2(566) = 32
  n2(567) = 32
  n2(568) = 32
  n2(569) = 32
  n2(570) = 32
  n2(571) = 32
  call heltable([16,2,32], n3(:,1527), t3x32(:,:,357))
  n2(572) = 32
  call heltable([16,2,32], n3(:,1528), t3x32(:,:,358))
  n2(573) = 32
  call heltable([4,16,64], n3(:,1529), t3x64(:,:,499))
  call heltable([4,16,64], n3(:,1530), t3x64(:,:,500))
  call heltable([16,4,64], n3(:,1531), t3x64(:,:,501))
  call heltable([16,4,64], n3(:,1532), t3x64(:,:,502))
  n2(574) = 32
  call heltable([16,2,32], n3(:,1533), t3x32(:,:,359))
  n2(575) = 32
  call heltable([16,2,32], n3(:,1534), t3x32(:,:,360))
  n2(576) = 32
  call heltable([16,4,64], n3(:,1535), t3x64(:,:,503))
  call heltable([16,4,64], n3(:,1536), t3x64(:,:,504))
  call heltable([16,4,64], n3(:,1537), t3x64(:,:,505))
  call heltable([16,4,64], n3(:,1538), t3x64(:,:,506))
  call heltable([4,16,64], n3(:,1539), t3x64(:,:,507))
  call heltable([16,4,64], n3(:,1540), t3x64(:,:,508))
  call heltable([16,4,64], n3(:,1541), t3x64(:,:,509))
  call heltable([16,4,64], n3(:,1542), t3x64(:,:,510))
  call heltable([2,16,32], n3(:,1543), t3x32(:,:,361))
  n2(577) = 32
  call heltable([2,16,32], n3(:,1544), t3x32(:,:,362))
  n2(578) = 32
  call heltable([8,8,64], n3(:,1545), t3x64(:,:,511))
  call heltable([8,8,64], n3(:,1546), t3x64(:,:,512))
  call heltable([16,2,32], n3(:,1547), t3x32(:,:,363))
  n2(579) = 32
  call heltable([16,2,32], n3(:,1548), t3x32(:,:,364))
  n2(580) = 32
  call heltable([16,2,32], n3(:,1549), t3x32(:,:,365))
  n2(581) = 32
  call heltable([16,2,32], n3(:,1550), t3x32(:,:,366))
  n2(582) = 32
  call heltable([4,16,64], n3(:,1551), t3x64(:,:,513))
  call heltable([4,16,64], n3(:,1552), t3x64(:,:,514))
  call heltable([16,4,64], n3(:,1553), t3x64(:,:,515))
  call heltable([16,4,64], n3(:,1554), t3x64(:,:,516))
  call heltable([16,2,32], n3(:,1555), t3x32(:,:,367))
  n2(583) = 32
  call heltable([16,2,32], n3(:,1556), t3x32(:,:,368))
  n2(584) = 32
  call heltable([16,4,64], n3(:,1557), t3x64(:,:,517))
  call heltable([16,4,64], n3(:,1558), t3x64(:,:,518))
  call heltable([16,4,64], n3(:,1559), t3x64(:,:,519))
  call heltable([16,4,64], n3(:,1560), t3x64(:,:,520))
  call heltable([4,16,64], n3(:,1561), t3x64(:,:,521))
  call heltable([16,4,64], n3(:,1562), t3x64(:,:,522))
  call heltable([16,4,64], n3(:,1563), t3x64(:,:,523))
  call heltable([16,4,64], n3(:,1564), t3x64(:,:,524))
  call heltable([8,8,64], n3(:,1565), t3x64(:,:,525))
  call heltable([8,8,64], n3(:,1566), t3x64(:,:,526))
  call heltable([2,32,64], n3(:,1567), t3x64(:,:,527))
  call heltable([2,32,64], n3(:,1568), t3x64(:,:,528))
  call heltable([2,32,64], n3(:,1569), t3x64(:,:,529))
  call heltable([32,2,64], n3(:,1570), t3x64(:,:,530))
  call heltable([32,2,64], n3(:,1571), t3x64(:,:,531))
  call heltable([2,32,64], n3(:,1572), t3x64(:,:,532))
  call heltable([32,2,64], n3(:,1573), t3x64(:,:,533))
  call heltable([32,2,64], n3(:,1574), t3x64(:,:,534))
  call heltable([32,2,64], n3(:,1575), t3x64(:,:,535))
  call heltable([32,2,64], n3(:,1576), t3x64(:,:,536))
  call heltable([2,32,64], n3(:,1577), t3x64(:,:,537))
  call heltable([2,32,64], n3(:,1578), t3x64(:,:,538))
  call heltable([2,32,64], n3(:,1579), t3x64(:,:,539))
  call heltable([32,2,64], n3(:,1580), t3x64(:,:,540))
  call heltable([32,2,64], n3(:,1581), t3x64(:,:,541))
  call heltable([32,2,64], n3(:,1582), t3x64(:,:,542))
  call heltable([32,2,64], n3(:,1583), t3x64(:,:,543))
  call heltable([32,2,64], n3(:,1584), t3x64(:,:,544))
  call heltable([32,2,64], n3(:,1585), t3x64(:,:,545))
  call heltable([2,32,64], n3(:,1586), t3x64(:,:,546))
  call heltable([2,32,64], n3(:,1587), t3x64(:,:,547))
  call heltable([2,32,64], n3(:,1588), t3x64(:,:,548))
  call heltable([2,32,64], n3(:,1589), t3x64(:,:,549))
  call heltable([2,32,64], n3(:,1590), t3x64(:,:,550))
  call heltable([2,32,64], n3(:,1591), t3x64(:,:,551))
  call heltable([32,2,64], n3(:,1592), t3x64(:,:,552))
  call heltable([2,32,64], n3(:,1593), t3x64(:,:,553))
  call heltable([32,2,64], n3(:,1594), t3x64(:,:,554))
  call heltable([32,2,64], n3(:,1595), t3x64(:,:,555))
  call heltable([32,2,64], n3(:,1596), t3x64(:,:,556))
  call heltable([32,2,64], n3(:,1597), t3x64(:,:,557))
  call heltable([2,32,64], n3(:,1598), t3x64(:,:,558))
  call heltable([2,32,64], n3(:,1599), t3x64(:,:,559))
  call heltable([32,2,64], n3(:,1600), t3x64(:,:,560))
  call heltable([2,32,64], n3(:,1601), t3x64(:,:,561))
  call heltable([32,2,64], n3(:,1602), t3x64(:,:,562))
  call heltable([32,2,64], n3(:,1603), t3x64(:,:,563))
  call heltable([32,2,64], n3(:,1604), t3x64(:,:,564))
  call heltable([32,2,64], n3(:,1605), t3x64(:,:,565))
  call heltable([32,2,64], n3(:,1606), t3x64(:,:,566))
  call heltable([2,32,64], n3(:,1607), t3x64(:,:,567))
  call heltable([2,32,64], n3(:,1608), t3x64(:,:,568))
  call heltable([32,2,64], n3(:,1609), t3x64(:,:,569))
  call heltable([2,32,64], n3(:,1610), t3x64(:,:,570))
  call heltable([2,32,64], n3(:,1611), t3x64(:,:,571))
  call heltable([2,32,64], n3(:,1612), t3x64(:,:,572))
  call heltable([2,32,64], n3(:,1613), t3x64(:,:,573))
  call heltable([32,2,64], n3(:,1614), t3x64(:,:,574))
  call heltable([32,2,64], n3(:,1615), t3x64(:,:,575))
  call heltable([2,32,64], n3(:,1616), t3x64(:,:,576))
  call heltable([32,2,64], n3(:,1617), t3x64(:,:,577))
  call heltable([32,2,64], n3(:,1618), t3x64(:,:,578))
  call heltable([32,2,64], n3(:,1619), t3x64(:,:,579))
  call heltable([32,2,64], n3(:,1620), t3x64(:,:,580))
  call heltable([2,32,64], n3(:,1621), t3x64(:,:,581))
  call heltable([2,32,64], n3(:,1622), t3x64(:,:,582))
  call heltable([2,32,64], n3(:,1623), t3x64(:,:,583))
  call heltable([32,2,64], n3(:,1624), t3x64(:,:,584))
  call heltable([32,2,64], n3(:,1625), t3x64(:,:,585))
  call heltable([32,2,64], n3(:,1626), t3x64(:,:,586))
  call heltable([32,2,64], n3(:,1627), t3x64(:,:,587))
  call heltable([32,2,64], n3(:,1628), t3x64(:,:,588))
  call heltable([32,2,64], n3(:,1629), t3x64(:,:,589))
  call heltable([2,32,64], n3(:,1630), t3x64(:,:,590))
  call heltable([2,32,64], n3(:,1631), t3x64(:,:,591))
  call heltable([2,32,64], n3(:,1632), t3x64(:,:,592))
  call heltable([4,64,256], n3(:,1633), t3x256(:,:,1))
  call heltable([4,64,256], n3(:,1634), t3x256(:,:,2))
  call heltable([16,16,256], n3(:,1635), t3x256(:,:,3))
  call heltable([16,16,256], n3(:,1636), t3x256(:,:,4))
  call heltable([16,16,256], n3(:,1637), t3x256(:,:,5))
  call heltable([16,16,256], n3(:,1638), t3x256(:,:,6))
  call heltable([16,16,256], n3(:,1639), t3x256(:,:,7))
  call heltable([16,16,256], n3(:,1640), t3x256(:,:,8))
  call heltable([8,32,256], n3(:,1641), t3x256(:,:,9))
  call heltable([16,16,256], n3(:,1642), t3x256(:,:,10))
  call heltable([16,16,256], n3(:,1643), t3x256(:,:,11))
  call heltable([8,32,256], n3(:,1644), t3x256(:,:,12))
  call heltable([16,16,256], n3(:,1645), t3x256(:,:,13))
  call heltable([16,16,256], n3(:,1646), t3x256(:,:,14))
  call heltable([16,16,256], n3(:,1647), t3x256(:,:,15))
  call heltable([16,16,256], n3(:,1648), t3x256(:,:,16))
  call heltable([16,16,256], n3(:,1649), t3x256(:,:,17))
  call heltable([16,16,256], n3(:,1650), t3x256(:,:,18))
  call heltable([16,16,256], n3(:,1651), t3x256(:,:,19))
  call heltable([16,16,256], n3(:,1652), t3x256(:,:,20))
  call heltable([16,16,256], n3(:,1653), t3x256(:,:,21))
  call heltable([16,16,256], n3(:,1654), t3x256(:,:,22))
  call heltable([16,16,256], n3(:,1655), t3x256(:,:,23))
  call heltable([16,16,256], n3(:,1656), t3x256(:,:,24))
  call heltable([8,32,256], n3(:,1657), t3x256(:,:,25))
  call heltable([16,16,256], n3(:,1658), t3x256(:,:,26))
  call heltable([16,16,256], n3(:,1659), t3x256(:,:,27))
  call heltable([8,32,256], n3(:,1660), t3x256(:,:,28))
  call heltable([16,16,256], n3(:,1661), t3x256(:,:,29))
  call heltable([16,16,256], n3(:,1662), t3x256(:,:,30))
  call heltable([16,16,256], n3(:,1663), t3x256(:,:,31))
  call heltable([16,16,256], n3(:,1664), t3x256(:,:,32))
  call heltable([16,16,256], n3(:,1665), t3x256(:,:,33))
  call heltable([16,16,256], n3(:,1666), t3x256(:,:,34))
  call heltable([8,32,256], n3(:,1667), t3x256(:,:,35))
  call heltable([16,16,256], n3(:,1668), t3x256(:,:,36))
  call heltable([16,16,256], n3(:,1669), t3x256(:,:,37))
  call heltable([8,32,256], n3(:,1670), t3x256(:,:,38))
  call heltable([16,16,256], n3(:,1671), t3x256(:,:,39))
  call heltable([16,16,256], n3(:,1672), t3x256(:,:,40))
  call heltable([16,16,256], n3(:,1673), t3x256(:,:,41))
  call heltable([16,16,256], n3(:,1674), t3x256(:,:,42))
  call heltable([16,16,256], n3(:,1675), t3x256(:,:,43))
  call heltable([16,16,256], n3(:,1676), t3x256(:,:,44))
  call heltable([8,32,256], n3(:,1677), t3x256(:,:,45))
  call heltable([16,16,256], n3(:,1678), t3x256(:,:,46))
  call heltable([16,16,256], n3(:,1679), t3x256(:,:,47))
  call heltable([8,32,256], n3(:,1680), t3x256(:,:,48))
  call heltable([16,16,256], n3(:,1681), t3x256(:,:,49))
  call heltable([16,16,256], n3(:,1682), t3x256(:,:,50))
  call heltable([16,16,256], n3(:,1683), t3x256(:,:,51))
  call heltable([16,16,256], n3(:,1684), t3x256(:,:,52))
  call heltable([16,16,256], n3(:,1685), t3x256(:,:,53))
  call heltable([16,16,256], n3(:,1686), t3x256(:,:,54))
  call heltable([16,16,256], n3(:,1687), t3x256(:,:,55))
  call heltable([16,16,256], n3(:,1688), t3x256(:,:,56))
  call heltable([16,16,256], n3(:,1689), t3x256(:,:,57))
  call heltable([16,16,256], n3(:,1690), t3x256(:,:,58))
  call heltable([16,16,256], n3(:,1691), t3x256(:,:,59))
  call heltable([16,16,256], n3(:,1692), t3x256(:,:,60))
  call heltable([16,16,256], n3(:,1693), t3x256(:,:,61))
  call heltable([16,16,256], n3(:,1694), t3x256(:,:,62))
  call heltable([16,16,256], n3(:,1695), t3x256(:,:,63))
  call heltable([16,16,256], n3(:,1696), t3x256(:,:,64))
  call heltable([16,16,256], n3(:,1697), t3x256(:,:,65))
  call heltable([16,16,256], n3(:,1698), t3x256(:,:,66))
  call heltable([16,16,256], n3(:,1699), t3x256(:,:,67))
  call heltable([16,16,256], n3(:,1700), t3x256(:,:,68))
  call heltable([16,16,256], n3(:,1701), t3x256(:,:,69))
  call heltable([16,16,256], n3(:,1702), t3x256(:,:,70))
  call heltable([16,16,256], n3(:,1703), t3x256(:,:,71))
  call heltable([16,16,256], n3(:,1704), t3x256(:,:,72))
  call heltable([16,16,256], n3(:,1705), t3x256(:,:,73))
  call heltable([16,16,256], n3(:,1706), t3x256(:,:,74))
  call heltable([16,16,256], n3(:,1707), t3x256(:,:,75))
  call heltable([16,16,256], n3(:,1708), t3x256(:,:,76))
  call heltable([16,16,256], n3(:,1709), t3x256(:,:,77))
  call heltable([16,16,256], n3(:,1710), t3x256(:,:,78))
  call heltable([16,16,256], n3(:,1711), t3x256(:,:,79))
  call heltable([16,16,256], n3(:,1712), t3x256(:,:,80))
  call heltable([16,16,256], n3(:,1713), t3x256(:,:,81))
  call heltable([16,16,256], n3(:,1714), t3x256(:,:,82))
  call heltable([16,16,256], n3(:,1715), t3x256(:,:,83))
  call heltable([16,16,256], n3(:,1716), t3x256(:,:,84))
  call heltable([16,16,256], n3(:,1717), t3x256(:,:,85))
  call heltable([16,16,256], n3(:,1718), t3x256(:,:,86))
  call heltable([16,16,256], n3(:,1719), t3x256(:,:,87))
  call heltable([16,16,256], n3(:,1720), t3x256(:,:,88))
  call heltable([16,16,256], n3(:,1721), t3x256(:,:,89))
  call heltable([16,16,256], n3(:,1722), t3x256(:,:,90))
  call heltable([16,16,256], n3(:,1723), t3x256(:,:,91))
  call heltable([16,16,256], n3(:,1724), t3x256(:,:,92))
  call heltable([16,16,256], n3(:,1725), t3x256(:,:,93))
  call heltable([16,16,256], n3(:,1726), t3x256(:,:,94))
  call heltable([16,16,256], n3(:,1727), t3x256(:,:,95))
  call heltable([16,16,256], n3(:,1728), t3x256(:,:,96))
  call heltable([16,16,256], n3(:,1729), t3x256(:,:,97))
  call heltable([16,16,256], n3(:,1730), t3x256(:,:,98))
  call heltable([16,16,256], n3(:,1731), t3x256(:,:,99))
  call heltable([16,16,256], n3(:,1732), t3x256(:,:,100))
  call heltable([16,16,256], n3(:,1733), t3x256(:,:,101))
  call heltable([16,16,256], n3(:,1734), t3x256(:,:,102))
  call heltable([16,16,256], n3(:,1735), t3x256(:,:,103))
  call heltable([16,16,256], n3(:,1736), t3x256(:,:,104))
  call heltable([16,16,256], n3(:,1737), t3x256(:,:,105))
  call heltable([16,16,256], n3(:,1738), t3x256(:,:,106))
  call heltable([16,16,256], n3(:,1739), t3x256(:,:,107))
  call heltable([16,16,256], n3(:,1740), t3x256(:,:,108))
  call heltable([8,32,256], n3(:,1741), t3x256(:,:,109))
  call heltable([8,32,256], n3(:,1742), t3x256(:,:,110))
  call heltable([16,16,256], n3(:,1743), t3x256(:,:,111))
  call heltable([16,16,256], n3(:,1744), t3x256(:,:,112))
  call heltable([16,16,256], n3(:,1745), t3x256(:,:,113))
  call heltable([16,16,256], n3(:,1746), t3x256(:,:,114))
  call heltable([16,16,256], n3(:,1747), t3x256(:,:,115))
  call heltable([16,16,256], n3(:,1748), t3x256(:,:,116))
  call heltable([16,16,256], n3(:,1749), t3x256(:,:,117))
  call heltable([16,16,256], n3(:,1750), t3x256(:,:,118))
  call heltable([16,16,256], n3(:,1751), t3x256(:,:,119))
  call heltable([16,16,256], n3(:,1752), t3x256(:,:,120))
  call heltable([16,16,256], n3(:,1753), t3x256(:,:,121))
  call heltable([16,16,256], n3(:,1754), t3x256(:,:,122))
  call heltable([8,32,256], n3(:,1755), t3x256(:,:,123))
  call heltable([8,32,256], n3(:,1756), t3x256(:,:,124))
  call heltable([16,16,256], n3(:,1757), t3x256(:,:,125))
  call heltable([16,16,256], n3(:,1758), t3x256(:,:,126))
  call heltable([16,16,256], n3(:,1759), t3x256(:,:,127))
  call heltable([16,16,256], n3(:,1760), t3x256(:,:,128))
  call heltable([16,16,256], n3(:,1761), t3x256(:,:,129))
  call heltable([16,16,256], n3(:,1762), t3x256(:,:,130))
  call heltable([16,16,256], n3(:,1763), t3x256(:,:,131))
  call heltable([16,16,256], n3(:,1764), t3x256(:,:,132))
  call heltable([16,16,256], n3(:,1765), t3x256(:,:,133))
  call heltable([16,16,256], n3(:,1766), t3x256(:,:,134))
  call heltable([16,16,256], n3(:,1767), t3x256(:,:,135))
  call heltable([16,16,256], n3(:,1768), t3x256(:,:,136))
  call heltable([16,16,256], n3(:,1769), t3x256(:,:,137))
  call heltable([16,16,256], n3(:,1770), t3x256(:,:,138))
  call heltable([16,16,256], n3(:,1771), t3x256(:,:,139))
  call heltable([16,16,256], n3(:,1772), t3x256(:,:,140))
  call heltable([16,16,256], n3(:,1773), t3x256(:,:,141))
  call heltable([16,16,256], n3(:,1774), t3x256(:,:,142))
  call heltable([16,16,256], n3(:,1775), t3x256(:,:,143))
  call heltable([16,16,256], n3(:,1776), t3x256(:,:,144))
  call heltable([16,16,256], n3(:,1777), t3x256(:,:,145))
  call heltable([16,16,256], n3(:,1778), t3x256(:,:,146))
  call heltable([16,16,256], n3(:,1779), t3x256(:,:,147))
  call heltable([16,16,256], n3(:,1780), t3x256(:,:,148))
  call heltable([8,32,256], n3(:,1781), t3x256(:,:,149))
  call heltable([8,32,256], n3(:,1782), t3x256(:,:,150))
  call heltable([16,16,256], n3(:,1783), t3x256(:,:,151))
  call heltable([16,16,256], n3(:,1784), t3x256(:,:,152))
  call heltable([16,16,256], n3(:,1785), t3x256(:,:,153))
  call heltable([16,16,256], n3(:,1786), t3x256(:,:,154))
  call heltable([16,16,256], n3(:,1787), t3x256(:,:,155))
  call heltable([16,16,256], n3(:,1788), t3x256(:,:,156))
  call heltable([16,16,256], n3(:,1789), t3x256(:,:,157))
  call heltable([16,16,256], n3(:,1790), t3x256(:,:,158))
  call heltable([16,16,256], n3(:,1791), t3x256(:,:,159))
  call heltable([16,16,256], n3(:,1792), t3x256(:,:,160))
  call heltable([16,16,256], n3(:,1793), t3x256(:,:,161))
  call heltable([16,16,256], n3(:,1794), t3x256(:,:,162))
  call heltable([8,32,256], n3(:,1795), t3x256(:,:,163))
  call heltable([8,32,256], n3(:,1796), t3x256(:,:,164))
  call heltable([16,16,256], n3(:,1797), t3x256(:,:,165))
  call heltable([16,16,256], n3(:,1798), t3x256(:,:,166))
  call heltable([16,16,256], n3(:,1799), t3x256(:,:,167))
  call heltable([16,16,256], n3(:,1800), t3x256(:,:,168))
  call heltable([16,16,256], n3(:,1801), t3x256(:,:,169))
  call heltable([16,16,256], n3(:,1802), t3x256(:,:,170))
  call heltable([16,16,256], n3(:,1803), t3x256(:,:,171))
  call heltable([16,16,256], n3(:,1804), t3x256(:,:,172))
  call heltable([16,16,256], n3(:,1805), t3x256(:,:,173))
  call heltable([16,16,256], n3(:,1806), t3x256(:,:,174))
  call heltable([16,16,256], n3(:,1807), t3x256(:,:,175))
  call heltable([16,16,256], n3(:,1808), t3x256(:,:,176))
  call heltable([16,16,256], n3(:,1809), t3x256(:,:,177))
  call heltable([16,16,256], n3(:,1810), t3x256(:,:,178))
  call heltable([16,16,256], n3(:,1811), t3x256(:,:,179))
  call heltable([16,16,256], n3(:,1812), t3x256(:,:,180))
  call heltable([16,16,256], n3(:,1813), t3x256(:,:,181))
  call heltable([16,16,256], n3(:,1814), t3x256(:,:,182))
  call heltable([16,16,256], n3(:,1815), t3x256(:,:,183))
  call heltable([16,16,256], n3(:,1816), t3x256(:,:,184))
  call heltable([16,16,256], n3(:,1817), t3x256(:,:,185))
  call heltable([16,16,256], n3(:,1818), t3x256(:,:,186))
  call heltable([16,16,256], n3(:,1819), t3x256(:,:,187))
  call heltable([16,16,256], n3(:,1820), t3x256(:,:,188))
  call heltable([16,16,256], n3(:,1821), t3x256(:,:,189))
  call heltable([16,16,256], n3(:,1822), t3x256(:,:,190))
  call heltable([16,16,256], n3(:,1823), t3x256(:,:,191))
  call heltable([16,16,256], n3(:,1824), t3x256(:,:,192))
  call heltable([16,16,256], n3(:,1825), t3x256(:,:,193))
  call heltable([16,16,256], n3(:,1826), t3x256(:,:,194))
  call heltable([16,16,256], n3(:,1827), t3x256(:,:,195))
  call heltable([16,16,256], n3(:,1828), t3x256(:,:,196))
  call heltable([16,16,256], n3(:,1829), t3x256(:,:,197))
  call heltable([16,16,256], n3(:,1830), t3x256(:,:,198))
  call heltable([16,16,256], n3(:,1831), t3x256(:,:,199))
  call heltable([16,16,256], n3(:,1832), t3x256(:,:,200))
  call heltable([16,16,256], n3(:,1833), t3x256(:,:,201))
  call heltable([16,16,256], n3(:,1834), t3x256(:,:,202))
  call heltable([4,64,256], n3(:,1835), t3x256(:,:,203))
  call heltable([4,64,256], n3(:,1836), t3x256(:,:,204))
  call heltable([64,4,256], n3(:,1837), t3x256(:,:,205))
  call heltable([64,4,256], n3(:,1838), t3x256(:,:,206))
  call heltable([64,4,256], n3(:,1839), t3x256(:,:,207))
  call heltable([64,4,256], n3(:,1840), t3x256(:,:,208))
  call heltable([4,64,256], n3(:,1841), t3x256(:,:,209))
  call heltable([4,64,256], n3(:,1842), t3x256(:,:,210))
  call heltable([4,64,256], n3(:,1843), t3x256(:,:,211))
  call heltable([4,64,256], n3(:,1844), t3x256(:,:,212))
  call heltable([4,64,256], n3(:,1845), t3x256(:,:,213))
  call heltable([4,64,256], n3(:,1846), t3x256(:,:,214))
  call heltable([4,64,256], n3(:,1847), t3x256(:,:,215))
  call heltable([4,64,256], n3(:,1848), t3x256(:,:,216))
  call heltable([16,16,256], n3(:,1849), t3x256(:,:,217))
  call heltable([16,16,256], n3(:,1850), t3x256(:,:,218))
  call heltable([16,16,256], n3(:,1851), t3x256(:,:,219))
  call heltable([16,16,256], n3(:,1852), t3x256(:,:,220))
  call heltable([16,16,256], n3(:,1853), t3x256(:,:,221))
  call heltable([16,16,256], n3(:,1854), t3x256(:,:,222))
  call heltable([16,16,256], n3(:,1855), t3x256(:,:,223))
  call heltable([16,16,256], n3(:,1856), t3x256(:,:,224))
  call heltable([16,16,256], n3(:,1857), t3x256(:,:,225))
  call heltable([16,16,256], n3(:,1858), t3x256(:,:,226))
  call heltable([16,16,256], n3(:,1859), t3x256(:,:,227))
  call heltable([16,16,256], n3(:,1860), t3x256(:,:,228))
  call heltable([64,4,256], n3(:,1861), t3x256(:,:,229))
  call heltable([64,4,256], n3(:,1862), t3x256(:,:,230))
  call heltable([64,4,256], n3(:,1863), t3x256(:,:,231))
  call heltable([64,4,256], n3(:,1864), t3x256(:,:,232))
  call heltable([8,32,256], n3(:,1865), t3x256(:,:,233))
  call heltable([8,32,256], n3(:,1866), t3x256(:,:,234))
  call heltable([16,16,256], n3(:,1867), t3x256(:,:,235))
  call heltable([16,16,256], n3(:,1868), t3x256(:,:,236))
  call heltable([8,32,256], n3(:,1869), t3x256(:,:,237))
  call heltable([8,32,256], n3(:,1870), t3x256(:,:,238))
  call heltable([16,16,256], n3(:,1871), t3x256(:,:,239))
  call heltable([16,16,256], n3(:,1872), t3x256(:,:,240))
  call heltable([16,16,256], n3(:,1873), t3x256(:,:,241))
  call heltable([16,16,256], n3(:,1874), t3x256(:,:,242))
  call heltable([16,16,256], n3(:,1875), t3x256(:,:,243))
  call heltable([16,16,256], n3(:,1876), t3x256(:,:,244))
  call heltable([16,16,256], n3(:,1877), t3x256(:,:,245))
  call heltable([16,16,256], n3(:,1878), t3x256(:,:,246))
  call heltable([16,16,256], n3(:,1879), t3x256(:,:,247))
  call heltable([16,16,256], n3(:,1880), t3x256(:,:,248))
  call heltable([32,8,256], n3(:,1881), t3x256(:,:,249))
  call heltable([32,8,256], n3(:,1882), t3x256(:,:,250))
  call heltable([16,16,256], n3(:,1883), t3x256(:,:,251))
  call heltable([16,16,256], n3(:,1884), t3x256(:,:,252))
  call heltable([16,16,256], n3(:,1885), t3x256(:,:,253))
  call heltable([16,16,256], n3(:,1886), t3x256(:,:,254))
  call heltable([16,16,256], n3(:,1887), t3x256(:,:,255))
  call heltable([16,16,256], n3(:,1888), t3x256(:,:,256))
  call heltable([16,16,256], n3(:,1889), t3x256(:,:,257))
  call heltable([16,16,256], n3(:,1890), t3x256(:,:,258))
  call heltable([32,8,256], n3(:,1891), t3x256(:,:,259))
  call heltable([32,8,256], n3(:,1892), t3x256(:,:,260))
  call heltable([16,16,256], n3(:,1893), t3x256(:,:,261))
  call heltable([16,16,256], n3(:,1894), t3x256(:,:,262))
  call heltable([16,16,256], n3(:,1895), t3x256(:,:,263))
  call heltable([16,16,256], n3(:,1896), t3x256(:,:,264))
  call heltable([16,16,256], n3(:,1897), t3x256(:,:,265))
  call heltable([16,16,256], n3(:,1898), t3x256(:,:,266))
  call heltable([16,16,256], n3(:,1899), t3x256(:,:,267))
  call heltable([16,16,256], n3(:,1900), t3x256(:,:,268))
  call heltable([16,16,256], n3(:,1901), t3x256(:,:,269))
  call heltable([16,16,256], n3(:,1902), t3x256(:,:,270))
  call heltable([16,16,256], n3(:,1903), t3x256(:,:,271))
  call heltable([16,16,256], n3(:,1904), t3x256(:,:,272))
  call heltable([16,16,256], n3(:,1905), t3x256(:,:,273))
  call heltable([16,16,256], n3(:,1906), t3x256(:,:,274))
  call heltable([16,16,256], n3(:,1907), t3x256(:,:,275))
  call heltable([16,16,256], n3(:,1908), t3x256(:,:,276))
  call heltable([4,64,256], n3(:,1909), t3x256(:,:,277))
  call heltable([4,64,256], n3(:,1910), t3x256(:,:,278))
  call heltable([64,4,256], n3(:,1911), t3x256(:,:,279))
  call heltable([64,4,256], n3(:,1912), t3x256(:,:,280))
  call heltable([8,32,256], n3(:,1913), t3x256(:,:,281))
  call heltable([8,32,256], n3(:,1914), t3x256(:,:,282))
  call heltable([16,16,256], n3(:,1915), t3x256(:,:,283))
  call heltable([16,16,256], n3(:,1916), t3x256(:,:,284))
  call heltable([8,32,256], n3(:,1917), t3x256(:,:,285))
  call heltable([8,32,256], n3(:,1918), t3x256(:,:,286))
  call heltable([16,16,256], n3(:,1919), t3x256(:,:,287))
  call heltable([16,16,256], n3(:,1920), t3x256(:,:,288))
  call heltable([16,16,256], n3(:,1921), t3x256(:,:,289))
  call heltable([16,16,256], n3(:,1922), t3x256(:,:,290))
  call heltable([16,16,256], n3(:,1923), t3x256(:,:,291))
  call heltable([16,16,256], n3(:,1924), t3x256(:,:,292))
  call heltable([16,16,256], n3(:,1925), t3x256(:,:,293))
  call heltable([16,16,256], n3(:,1926), t3x256(:,:,294))
  call heltable([16,16,256], n3(:,1927), t3x256(:,:,295))
  call heltable([16,16,256], n3(:,1928), t3x256(:,:,296))
  call heltable([32,8,256], n3(:,1929), t3x256(:,:,297))
  call heltable([32,8,256], n3(:,1930), t3x256(:,:,298))
  call heltable([16,16,256], n3(:,1931), t3x256(:,:,299))
  call heltable([16,16,256], n3(:,1932), t3x256(:,:,300))
  call heltable([16,16,256], n3(:,1933), t3x256(:,:,301))
  call heltable([16,16,256], n3(:,1934), t3x256(:,:,302))
  call heltable([16,16,256], n3(:,1935), t3x256(:,:,303))
  call heltable([16,16,256], n3(:,1936), t3x256(:,:,304))
  call heltable([16,16,256], n3(:,1937), t3x256(:,:,305))
  call heltable([16,16,256], n3(:,1938), t3x256(:,:,306))
  call heltable([32,8,256], n3(:,1939), t3x256(:,:,307))
  call heltable([32,8,256], n3(:,1940), t3x256(:,:,308))
  call heltable([16,16,256], n3(:,1941), t3x256(:,:,309))
  call heltable([16,16,256], n3(:,1942), t3x256(:,:,310))
  call heltable([16,16,256], n3(:,1943), t3x256(:,:,311))
  call heltable([16,16,256], n3(:,1944), t3x256(:,:,312))
  call heltable([8,32,256], n3(:,1945), t3x256(:,:,313))
  call heltable([8,32,256], n3(:,1946), t3x256(:,:,314))
  call heltable([16,16,256], n3(:,1947), t3x256(:,:,315))
  call heltable([16,16,256], n3(:,1948), t3x256(:,:,316))
  call heltable([8,32,256], n3(:,1949), t3x256(:,:,317))
  call heltable([8,32,256], n3(:,1950), t3x256(:,:,318))
  call heltable([16,16,256], n3(:,1951), t3x256(:,:,319))
  call heltable([16,16,256], n3(:,1952), t3x256(:,:,320))
  call heltable([16,16,256], n3(:,1953), t3x256(:,:,321))
  call heltable([16,16,256], n3(:,1954), t3x256(:,:,322))
  call heltable([16,16,256], n3(:,1955), t3x256(:,:,323))
  call heltable([16,16,256], n3(:,1956), t3x256(:,:,324))
  call heltable([8,32,256], n3(:,1957), t3x256(:,:,325))
  call heltable([8,32,256], n3(:,1958), t3x256(:,:,326))
  call heltable([16,16,256], n3(:,1959), t3x256(:,:,327))
  call heltable([16,16,256], n3(:,1960), t3x256(:,:,328))
  call heltable([8,32,256], n3(:,1961), t3x256(:,:,329))
  call heltable([8,32,256], n3(:,1962), t3x256(:,:,330))
  call heltable([16,16,256], n3(:,1963), t3x256(:,:,331))
  call heltable([16,16,256], n3(:,1964), t3x256(:,:,332))
  call heltable([16,16,256], n3(:,1965), t3x256(:,:,333))
  call heltable([16,16,256], n3(:,1966), t3x256(:,:,334))
  call heltable([16,16,256], n3(:,1967), t3x256(:,:,335))
  call heltable([16,16,256], n3(:,1968), t3x256(:,:,336))
  call heltable([16,16,256], n3(:,1969), t3x256(:,:,337))
  call heltable([16,16,256], n3(:,1970), t3x256(:,:,338))
  call heltable([16,16,256], n3(:,1971), t3x256(:,:,339))
  call heltable([16,16,256], n3(:,1972), t3x256(:,:,340))
  call heltable([16,16,256], n3(:,1973), t3x256(:,:,341))
  call heltable([16,16,256], n3(:,1974), t3x256(:,:,342))
  call heltable([16,16,256], n3(:,1975), t3x256(:,:,343))
  call heltable([16,16,256], n3(:,1976), t3x256(:,:,344))
  call heltable([16,16,256], n3(:,1977), t3x256(:,:,345))
  call heltable([16,16,256], n3(:,1978), t3x256(:,:,346))
  call heltable([16,16,256], n3(:,1979), t3x256(:,:,347))
  call heltable([16,16,256], n3(:,1980), t3x256(:,:,348))
  call heltable([16,16,256], n3(:,1981), t3x256(:,:,349))
  call heltable([16,16,256], n3(:,1982), t3x256(:,:,350))
  call heltable([16,16,256], n3(:,1983), t3x256(:,:,351))
  call heltable([16,16,256], n3(:,1984), t3x256(:,:,352))
  call heltable([16,16,256], n3(:,1985), t3x256(:,:,353))
  call heltable([16,16,256], n3(:,1986), t3x256(:,:,354))
  call heltable([16,16,256], n3(:,1987), t3x256(:,:,355))
  call heltable([16,16,256], n3(:,1988), t3x256(:,:,356))
  call heltable([16,16,256], n3(:,1989), t3x256(:,:,357))
  call heltable([16,16,256], n3(:,1990), t3x256(:,:,358))
  call heltable([16,16,256], n3(:,1991), t3x256(:,:,359))
  call heltable([16,16,256], n3(:,1992), t3x256(:,:,360))
  call heltable([16,16,256], n3(:,1993), t3x256(:,:,361))
  call heltable([16,16,256], n3(:,1994), t3x256(:,:,362))
  call heltable([16,16,256], n3(:,1995), t3x256(:,:,363))
  call heltable([16,16,256], n3(:,1996), t3x256(:,:,364))
  call heltable([16,16,256], n3(:,1997), t3x256(:,:,365))
  call heltable([16,16,256], n3(:,1998), t3x256(:,:,366))
  call heltable([16,16,256], n3(:,1999), t3x256(:,:,367))
  call heltable([16,16,256], n3(:,2000), t3x256(:,:,368))
  call heltable([16,16,256], n3(:,2001), t3x256(:,:,369))
  call heltable([16,16,256], n3(:,2002), t3x256(:,:,370))
  call heltable([16,16,256], n3(:,2003), t3x256(:,:,371))
  call heltable([16,16,256], n3(:,2004), t3x256(:,:,372))
  call heltable([16,16,256], n3(:,2005), t3x256(:,:,373))
  call heltable([16,16,256], n3(:,2006), t3x256(:,:,374))
  call heltable([16,16,256], n3(:,2007), t3x256(:,:,375))
  call heltable([16,16,256], n3(:,2008), t3x256(:,:,376))
  call heltable([16,16,256], n3(:,2009), t3x256(:,:,377))
  call heltable([16,16,256], n3(:,2010), t3x256(:,:,378))
  call heltable([16,16,256], n3(:,2011), t3x256(:,:,379))
  call heltable([16,16,256], n3(:,2012), t3x256(:,:,380))
  call heltable([16,16,256], n3(:,2013), t3x256(:,:,381))
  call heltable([16,16,256], n3(:,2014), t3x256(:,:,382))
  call heltable([16,16,256], n3(:,2015), t3x256(:,:,383))
  call heltable([16,16,256], n3(:,2016), t3x256(:,:,384))
  call heltable([16,16,256], n3(:,2017), t3x256(:,:,385))
  call heltable([16,16,256], n3(:,2018), t3x256(:,:,386))
  call heltable([16,16,256], n3(:,2019), t3x256(:,:,387))
  call heltable([16,16,256], n3(:,2020), t3x256(:,:,388))
  call heltable([16,16,256], n3(:,2021), t3x256(:,:,389))
  call heltable([16,16,256], n3(:,2022), t3x256(:,:,390))
  call heltable([16,16,256], n3(:,2023), t3x256(:,:,391))
  call heltable([16,16,256], n3(:,2024), t3x256(:,:,392))
  call heltable([16,16,256], n3(:,2025), t3x256(:,:,393))
  call heltable([16,16,256], n3(:,2026), t3x256(:,:,394))
  call heltable([16,16,256], n3(:,2027), t3x256(:,:,395))
  call heltable([16,16,256], n3(:,2028), t3x256(:,:,396))
  call heltable([16,16,256], n3(:,2029), t3x256(:,:,397))
  call heltable([16,16,256], n3(:,2030), t3x256(:,:,398))
  call heltable([16,16,256], n3(:,2031), t3x256(:,:,399))
  call heltable([16,16,256], n3(:,2032), t3x256(:,:,400))
  call heltable([16,16,256], n3(:,2033), t3x256(:,:,401))
  call heltable([16,16,256], n3(:,2034), t3x256(:,:,402))
  call heltable([16,16,256], n3(:,2035), t3x256(:,:,403))
  call heltable([16,16,256], n3(:,2036), t3x256(:,:,404))
  call heltable([16,16,256], n3(:,2037), t3x256(:,:,405))
  call heltable([16,16,256], n3(:,2038), t3x256(:,:,406))
  call heltable([16,16,256], n3(:,2039), t3x256(:,:,407))
  call heltable([16,16,256], n3(:,2040), t3x256(:,:,408))
  call heltable([16,16,256], n3(:,2041), t3x256(:,:,409))
  call heltable([16,16,256], n3(:,2042), t3x256(:,:,410))
  call heltable([16,16,256], n3(:,2043), t3x256(:,:,411))
  call heltable([16,16,256], n3(:,2044), t3x256(:,:,412))
  call heltable([16,16,256], n3(:,2045), t3x256(:,:,413))
  call heltable([16,16,256], n3(:,2046), t3x256(:,:,414))
  call heltable([16,16,256], n3(:,2047), t3x256(:,:,415))
  call heltable([16,16,256], n3(:,2048), t3x256(:,:,416))
  call heltable([16,16,256], n3(:,2049), t3x256(:,:,417))
  call heltable([16,16,256], n3(:,2050), t3x256(:,:,418))
  call heltable([16,16,256], n3(:,2051), t3x256(:,:,419))
  call heltable([16,16,256], n3(:,2052), t3x256(:,:,420))
  call heltable([32,8,256], n3(:,2053), t3x256(:,:,421))
  call heltable([32,8,256], n3(:,2054), t3x256(:,:,422))
  call heltable([16,16,256], n3(:,2055), t3x256(:,:,423))
  call heltable([16,16,256], n3(:,2056), t3x256(:,:,424))
  call heltable([16,16,256], n3(:,2057), t3x256(:,:,425))
  call heltable([16,16,256], n3(:,2058), t3x256(:,:,426))
  call heltable([16,16,256], n3(:,2059), t3x256(:,:,427))
  call heltable([16,16,256], n3(:,2060), t3x256(:,:,428))
  call heltable([16,16,256], n3(:,2061), t3x256(:,:,429))
  call heltable([16,16,256], n3(:,2062), t3x256(:,:,430))
  call heltable([32,8,256], n3(:,2063), t3x256(:,:,431))
  call heltable([32,8,256], n3(:,2064), t3x256(:,:,432))
  call heltable([16,16,256], n3(:,2065), t3x256(:,:,433))
  call heltable([16,16,256], n3(:,2066), t3x256(:,:,434))
  call heltable([16,16,256], n3(:,2067), t3x256(:,:,435))
  call heltable([16,16,256], n3(:,2068), t3x256(:,:,436))
  call heltable([16,16,256], n3(:,2069), t3x256(:,:,437))
  call heltable([16,16,256], n3(:,2070), t3x256(:,:,438))
  call heltable([16,16,256], n3(:,2071), t3x256(:,:,439))
  call heltable([16,16,256], n3(:,2072), t3x256(:,:,440))
  call heltable([32,8,256], n3(:,2073), t3x256(:,:,441))
  call heltable([32,8,256], n3(:,2074), t3x256(:,:,442))
  call heltable([16,16,256], n3(:,2075), t3x256(:,:,443))
  call heltable([16,16,256], n3(:,2076), t3x256(:,:,444))
  call heltable([16,16,256], n3(:,2077), t3x256(:,:,445))
  call heltable([16,16,256], n3(:,2078), t3x256(:,:,446))
  call heltable([16,16,256], n3(:,2079), t3x256(:,:,447))
  call heltable([16,16,256], n3(:,2080), t3x256(:,:,448))
  call heltable([16,16,256], n3(:,2081), t3x256(:,:,449))
  call heltable([16,16,256], n3(:,2082), t3x256(:,:,450))
  call heltable([32,8,256], n3(:,2083), t3x256(:,:,451))
  call heltable([32,8,256], n3(:,2084), t3x256(:,:,452))
  call heltable([16,16,256], n3(:,2085), t3x256(:,:,453))
  call heltable([16,16,256], n3(:,2086), t3x256(:,:,454))
  call heltable([16,16,256], n3(:,2087), t3x256(:,:,455))
  call heltable([16,16,256], n3(:,2088), t3x256(:,:,456))
  call heltable([16,16,256], n3(:,2089), t3x256(:,:,457))
  call heltable([16,16,256], n3(:,2090), t3x256(:,:,458))
  call heltable([16,16,256], n3(:,2091), t3x256(:,:,459))
  call heltable([16,16,256], n3(:,2092), t3x256(:,:,460))
  call heltable([16,16,256], n3(:,2093), t3x256(:,:,461))
  call heltable([16,16,256], n3(:,2094), t3x256(:,:,462))
  call heltable([16,16,256], n3(:,2095), t3x256(:,:,463))
  call heltable([16,16,256], n3(:,2096), t3x256(:,:,464))
  call heltable([16,16,256], n3(:,2097), t3x256(:,:,465))
  call heltable([16,16,256], n3(:,2098), t3x256(:,:,466))
  call heltable([16,16,256], n3(:,2099), t3x256(:,:,467))
  call heltable([16,16,256], n3(:,2100), t3x256(:,:,468))
  call heltable([16,16,256], n3(:,2101), t3x256(:,:,469))
  call heltable([16,16,256], n3(:,2102), t3x256(:,:,470))
  call heltable([16,16,256], n3(:,2103), t3x256(:,:,471))
  call heltable([16,16,256], n3(:,2104), t3x256(:,:,472))
  call heltable([16,16,256], n3(:,2105), t3x256(:,:,473))
  call heltable([16,16,256], n3(:,2106), t3x256(:,:,474))
  call heltable([16,16,256], n3(:,2107), t3x256(:,:,475))
  call heltable([16,16,256], n3(:,2108), t3x256(:,:,476))
  call heltable([16,16,256], n3(:,2109), t3x256(:,:,477))
  call heltable([16,16,256], n3(:,2110), t3x256(:,:,478))
  call heltable([16,16,256], n3(:,2111), t3x256(:,:,479))
  call heltable([16,16,256], n3(:,2112), t3x256(:,:,480))
  call heltable([16,16,256], n3(:,2113), t3x256(:,:,481))
  call heltable([16,16,256], n3(:,2114), t3x256(:,:,482))
  call heltable([16,16,256], n3(:,2115), t3x256(:,:,483))
  call heltable([16,16,256], n3(:,2116), t3x256(:,:,484))
  call heltable([16,16,256], n3(:,2117), t3x256(:,:,485))
  call heltable([16,16,256], n3(:,2118), t3x256(:,:,486))
  call heltable([16,16,256], n3(:,2119), t3x256(:,:,487))
  call heltable([16,16,256], n3(:,2120), t3x256(:,:,488))
  call heltable([16,16,256], n3(:,2121), t3x256(:,:,489))
  call heltable([16,16,256], n3(:,2122), t3x256(:,:,490))
  call heltable([16,16,256], n3(:,2123), t3x256(:,:,491))
  call heltable([16,16,256], n3(:,2124), t3x256(:,:,492))
  call heltable([16,16,256], n3(:,2125), t3x256(:,:,493))
  call heltable([16,16,256], n3(:,2126), t3x256(:,:,494))
  call heltable([16,16,256], n3(:,2127), t3x256(:,:,495))
  call heltable([16,16,256], n3(:,2128), t3x256(:,:,496))
  call heltable([16,16,256], n3(:,2129), t3x256(:,:,497))
  call heltable([16,16,256], n3(:,2130), t3x256(:,:,498))
  call heltable([16,16,256], n3(:,2131), t3x256(:,:,499))
  call heltable([16,16,256], n3(:,2132), t3x256(:,:,500))
  call heltable([16,16,256], n3(:,2133), t3x256(:,:,501))
  call heltable([16,16,256], n3(:,2134), t3x256(:,:,502))
  call heltable([16,16,256], n3(:,2135), t3x256(:,:,503))
  call heltable([16,16,256], n3(:,2136), t3x256(:,:,504))
  call heltable([16,16,256], n3(:,2137), t3x256(:,:,505))
  call heltable([16,16,256], n3(:,2138), t3x256(:,:,506))
  call heltable([16,16,256], n3(:,2139), t3x256(:,:,507))
  call heltable([16,16,256], n3(:,2140), t3x256(:,:,508))
  call heltable([16,16,256], n3(:,2141), t3x256(:,:,509))
  call heltable([16,16,256], n3(:,2142), t3x256(:,:,510))
  call heltable([16,16,256], n3(:,2143), t3x256(:,:,511))
  call heltable([16,16,256], n3(:,2144), t3x256(:,:,512))
  call heltable([16,16,256], n3(:,2145), t3x256(:,:,513))
  call heltable([16,16,256], n3(:,2146), t3x256(:,:,514))
  call heltable([16,16,256], n3(:,2147), t3x256(:,:,515))
  call heltable([16,16,256], n3(:,2148), t3x256(:,:,516))
  call heltable([16,16,256], n3(:,2149), t3x256(:,:,517))
  call heltable([16,16,256], n3(:,2150), t3x256(:,:,518))
  call heltable([16,16,256], n3(:,2151), t3x256(:,:,519))
  call heltable([16,16,256], n3(:,2152), t3x256(:,:,520))
  call heltable([16,16,256], n3(:,2153), t3x256(:,:,521))
  call heltable([16,16,256], n3(:,2154), t3x256(:,:,522))
  call heltable([16,16,256], n3(:,2155), t3x256(:,:,523))
  call heltable([16,16,256], n3(:,2156), t3x256(:,:,524))
  call heltable([16,16,256], n3(:,2157), t3x256(:,:,525))
  call heltable([16,16,256], n3(:,2158), t3x256(:,:,526))
  call heltable([16,16,256], n3(:,2159), t3x256(:,:,527))
  call heltable([16,16,256], n3(:,2160), t3x256(:,:,528))
  call heltable([16,16,256], n3(:,2161), t3x256(:,:,529))
  call heltable([16,16,256], n3(:,2162), t3x256(:,:,530))
  call heltable([16,16,256], n3(:,2163), t3x256(:,:,531))
  call heltable([16,16,256], n3(:,2164), t3x256(:,:,532))
  call heltable([16,16,256], n3(:,2165), t3x256(:,:,533))
  call heltable([16,16,256], n3(:,2166), t3x256(:,:,534))
  call heltable([16,16,256], n3(:,2167), t3x256(:,:,535))
  call heltable([16,16,256], n3(:,2168), t3x256(:,:,536))
  call heltable([16,16,256], n3(:,2169), t3x256(:,:,537))
  call heltable([16,16,256], n3(:,2170), t3x256(:,:,538))
  call heltable([16,16,256], n3(:,2171), t3x256(:,:,539))
  call heltable([16,16,256], n3(:,2172), t3x256(:,:,540))
  call heltable([8,32,256], n3(:,2173), t3x256(:,:,541))
  call heltable([8,32,256], n3(:,2174), t3x256(:,:,542))
  call heltable([16,16,256], n3(:,2175), t3x256(:,:,543))
  call heltable([16,16,256], n3(:,2176), t3x256(:,:,544))
  call heltable([16,16,256], n3(:,2177), t3x256(:,:,545))
  call heltable([16,16,256], n3(:,2178), t3x256(:,:,546))
  call heltable([16,16,256], n3(:,2179), t3x256(:,:,547))
  call heltable([16,16,256], n3(:,2180), t3x256(:,:,548))
  call heltable([16,16,256], n3(:,2181), t3x256(:,:,549))
  call heltable([16,16,256], n3(:,2182), t3x256(:,:,550))
  call heltable([8,32,256], n3(:,2183), t3x256(:,:,551))
  call heltable([8,32,256], n3(:,2184), t3x256(:,:,552))
  call heltable([16,16,256], n3(:,2185), t3x256(:,:,553))
  call heltable([16,16,256], n3(:,2186), t3x256(:,:,554))
  call heltable([16,16,256], n3(:,2187), t3x256(:,:,555))
  call heltable([16,16,256], n3(:,2188), t3x256(:,:,556))
  call heltable([16,16,256], n3(:,2189), t3x256(:,:,557))
  call heltable([16,16,256], n3(:,2190), t3x256(:,:,558))
  call heltable([16,16,256], n3(:,2191), t3x256(:,:,559))
  call heltable([16,16,256], n3(:,2192), t3x256(:,:,560))
  call heltable([16,16,256], n3(:,2193), t3x256(:,:,561))
  call heltable([16,16,256], n3(:,2194), t3x256(:,:,562))
  call heltable([16,16,256], n3(:,2195), t3x256(:,:,563))
  call heltable([16,16,256], n3(:,2196), t3x256(:,:,564))
  call heltable([16,16,256], n3(:,2197), t3x256(:,:,565))
  call heltable([16,16,256], n3(:,2198), t3x256(:,:,566))
  call heltable([16,16,256], n3(:,2199), t3x256(:,:,567))
  call heltable([16,16,256], n3(:,2200), t3x256(:,:,568))
  call heltable([16,16,256], n3(:,2201), t3x256(:,:,569))
  call heltable([16,16,256], n3(:,2202), t3x256(:,:,570))
  call heltable([16,16,256], n3(:,2203), t3x256(:,:,571))
  call heltable([16,16,256], n3(:,2204), t3x256(:,:,572))
  call heltable([16,16,256], n3(:,2205), t3x256(:,:,573))
  call heltable([16,16,256], n3(:,2206), t3x256(:,:,574))
  call heltable([16,16,256], n3(:,2207), t3x256(:,:,575))
  call heltable([16,16,256], n3(:,2208), t3x256(:,:,576))
  call heltable([16,16,256], n3(:,2209), t3x256(:,:,577))
  call heltable([16,16,256], n3(:,2210), t3x256(:,:,578))
  call heltable([8,32,256], n3(:,2211), t3x256(:,:,579))
  call heltable([8,32,256], n3(:,2212), t3x256(:,:,580))
  call heltable([16,16,256], n3(:,2213), t3x256(:,:,581))
  call heltable([16,16,256], n3(:,2214), t3x256(:,:,582))
  call heltable([16,16,256], n3(:,2215), t3x256(:,:,583))
  call heltable([16,16,256], n3(:,2216), t3x256(:,:,584))
  call heltable([16,16,256], n3(:,2217), t3x256(:,:,585))
  call heltable([16,16,256], n3(:,2218), t3x256(:,:,586))
  call heltable([16,16,256], n3(:,2219), t3x256(:,:,587))
  call heltable([16,16,256], n3(:,2220), t3x256(:,:,588))
  call heltable([8,32,256], n3(:,2221), t3x256(:,:,589))
  call heltable([8,32,256], n3(:,2222), t3x256(:,:,590))
  call heltable([16,16,256], n3(:,2223), t3x256(:,:,591))
  call heltable([16,16,256], n3(:,2224), t3x256(:,:,592))
  call heltable([16,16,256], n3(:,2225), t3x256(:,:,593))
  call heltable([16,16,256], n3(:,2226), t3x256(:,:,594))
  call heltable([16,16,256], n3(:,2227), t3x256(:,:,595))
  call heltable([16,16,256], n3(:,2228), t3x256(:,:,596))
  call heltable([16,16,256], n3(:,2229), t3x256(:,:,597))
  call heltable([16,16,256], n3(:,2230), t3x256(:,:,598))
  call heltable([16,16,256], n3(:,2231), t3x256(:,:,599))
  call heltable([16,16,256], n3(:,2232), t3x256(:,:,600))
  call heltable([16,16,256], n3(:,2233), t3x256(:,:,601))
  call heltable([16,16,256], n3(:,2234), t3x256(:,:,602))
  call heltable([16,16,256], n3(:,2235), t3x256(:,:,603))
  call heltable([16,16,256], n3(:,2236), t3x256(:,:,604))
  call heltable([16,16,256], n3(:,2237), t3x256(:,:,605))
  call heltable([16,16,256], n3(:,2238), t3x256(:,:,606))
  call heltable([16,16,256], n3(:,2239), t3x256(:,:,607))
  call heltable([16,16,256], n3(:,2240), t3x256(:,:,608))
  call heltable([16,16,256], n3(:,2241), t3x256(:,:,609))
  call heltable([16,16,256], n3(:,2242), t3x256(:,:,610))
  call heltable([16,16,256], n3(:,2243), t3x256(:,:,611))
  call heltable([16,16,256], n3(:,2244), t3x256(:,:,612))
  call heltable([16,16,256], n3(:,2245), t3x256(:,:,613))
  call heltable([16,16,256], n3(:,2246), t3x256(:,:,614))
  call heltable([16,16,256], n3(:,2247), t3x256(:,:,615))
  call heltable([16,16,256], n3(:,2248), t3x256(:,:,616))
  call heltable([16,16,256], n3(:,2249), t3x256(:,:,617))
  call heltable([16,16,256], n3(:,2250), t3x256(:,:,618))
  call heltable([16,16,256], n3(:,2251), t3x256(:,:,619))
  call heltable([16,16,256], n3(:,2252), t3x256(:,:,620))
  call heltable([16,16,256], n3(:,2253), t3x256(:,:,621))
  call heltable([16,16,256], n3(:,2254), t3x256(:,:,622))
  call heltable([16,16,256], n3(:,2255), t3x256(:,:,623))
  call heltable([16,16,256], n3(:,2256), t3x256(:,:,624))
  call heltable([16,16,256], n3(:,2257), t3x256(:,:,625))
  call heltable([16,16,256], n3(:,2258), t3x256(:,:,626))
  call heltable([16,16,256], n3(:,2259), t3x256(:,:,627))
  call heltable([16,16,256], n3(:,2260), t3x256(:,:,628))
  call heltable([16,16,256], n3(:,2261), t3x256(:,:,629))
  call heltable([16,16,256], n3(:,2262), t3x256(:,:,630))
  call heltable([16,16,256], n3(:,2263), t3x256(:,:,631))
  call heltable([16,16,256], n3(:,2264), t3x256(:,:,632))
  call heltable([16,16,256], n3(:,2265), t3x256(:,:,633))
  call heltable([16,16,256], n3(:,2266), t3x256(:,:,634))
  call heltable([16,16,256], n3(:,2267), t3x256(:,:,635))
  call heltable([16,16,256], n3(:,2268), t3x256(:,:,636))
  call heltable([16,16,256], n3(:,2269), t3x256(:,:,637))
  call heltable([16,16,256], n3(:,2270), t3x256(:,:,638))
  call heltable([16,16,256], n3(:,2271), t3x256(:,:,639))
  call heltable([16,16,256], n3(:,2272), t3x256(:,:,640))
  call heltable([16,16,256], n3(:,2273), t3x256(:,:,641))
  call heltable([16,16,256], n3(:,2274), t3x256(:,:,642))
  call heltable([16,16,256], n3(:,2275), t3x256(:,:,643))
  call heltable([16,16,256], n3(:,2276), t3x256(:,:,644))
  call heltable([16,16,256], n3(:,2277), t3x256(:,:,645))
  call heltable([16,16,256], n3(:,2278), t3x256(:,:,646))
  call heltable([16,16,256], n3(:,2279), t3x256(:,:,647))
  call heltable([16,16,256], n3(:,2280), t3x256(:,:,648))
  call heltable([16,16,256], n3(:,2281), t3x256(:,:,649))
  call heltable([16,16,256], n3(:,2282), t3x256(:,:,650))
  call heltable([16,16,256], n3(:,2283), t3x256(:,:,651))
  call heltable([16,16,256], n3(:,2284), t3x256(:,:,652))
  call heltable([16,16,256], n3(:,2285), t3x256(:,:,653))
  call heltable([16,16,256], n3(:,2286), t3x256(:,:,654))
  call heltable([16,16,256], n3(:,2287), t3x256(:,:,655))
  call heltable([16,16,256], n3(:,2288), t3x256(:,:,656))
  call heltable([16,16,256], n3(:,2289), t3x256(:,:,657))
  call heltable([16,16,256], n3(:,2290), t3x256(:,:,658))
  call heltable([16,16,256], n3(:,2291), t3x256(:,:,659))
  call heltable([16,16,256], n3(:,2292), t3x256(:,:,660))
  call heltable([16,16,256], n3(:,2293), t3x256(:,:,661))
  call heltable([16,16,256], n3(:,2294), t3x256(:,:,662))
  call heltable([16,16,256], n3(:,2295), t3x256(:,:,663))
  call heltable([16,16,256], n3(:,2296), t3x256(:,:,664))
  call heltable([16,16,256], n3(:,2297), t3x256(:,:,665))
  call heltable([16,16,256], n3(:,2298), t3x256(:,:,666))
  call heltable([16,16,256], n3(:,2299), t3x256(:,:,667))
  call heltable([16,16,256], n3(:,2300), t3x256(:,:,668))
  call heltable([16,16,256], n3(:,2301), t3x256(:,:,669))
  call heltable([16,16,256], n3(:,2302), t3x256(:,:,670))
  call heltable([16,16,256], n3(:,2303), t3x256(:,:,671))
  call heltable([16,16,256], n3(:,2304), t3x256(:,:,672))
  call heltable([16,16,256], n3(:,2305), t3x256(:,:,673))
  call heltable([16,16,256], n3(:,2306), t3x256(:,:,674))
  call heltable([8,32,256], n3(:,2307), t3x256(:,:,675))
  call heltable([8,32,256], n3(:,2308), t3x256(:,:,676))
  call heltable([16,16,256], n3(:,2309), t3x256(:,:,677))
  call heltable([16,16,256], n3(:,2310), t3x256(:,:,678))
  call heltable([16,16,256], n3(:,2311), t3x256(:,:,679))
  call heltable([16,16,256], n3(:,2312), t3x256(:,:,680))
  call heltable([16,16,256], n3(:,2313), t3x256(:,:,681))
  call heltable([16,16,256], n3(:,2314), t3x256(:,:,682))
  call heltable([8,32,256], n3(:,2315), t3x256(:,:,683))
  call heltable([8,32,256], n3(:,2316), t3x256(:,:,684))
  call heltable([16,16,256], n3(:,2317), t3x256(:,:,685))
  call heltable([16,16,256], n3(:,2318), t3x256(:,:,686))
  call heltable([16,16,256], n3(:,2319), t3x256(:,:,687))
  call heltable([16,16,256], n3(:,2320), t3x256(:,:,688))
  call heltable([16,16,256], n3(:,2321), t3x256(:,:,689))
  call heltable([16,16,256], n3(:,2322), t3x256(:,:,690))
  call heltable([16,16,256], n3(:,2323), t3x256(:,:,691))
  call heltable([16,16,256], n3(:,2324), t3x256(:,:,692))
  call heltable([16,16,256], n3(:,2325), t3x256(:,:,693))
  call heltable([16,16,256], n3(:,2326), t3x256(:,:,694))
  call heltable([16,16,256], n3(:,2327), t3x256(:,:,695))
  call heltable([16,16,256], n3(:,2328), t3x256(:,:,696))
  call heltable([16,16,256], n3(:,2329), t3x256(:,:,697))
  call heltable([16,16,256], n3(:,2330), t3x256(:,:,698))
  call heltable([16,16,256], n3(:,2331), t3x256(:,:,699))
  call heltable([16,16,256], n3(:,2332), t3x256(:,:,700))
  call heltable([16,16,256], n3(:,2333), t3x256(:,:,701))
  call heltable([16,16,256], n3(:,2334), t3x256(:,:,702))
  call heltable([16,16,256], n3(:,2335), t3x256(:,:,703))
  call heltable([16,16,256], n3(:,2336), t3x256(:,:,704))
  call heltable([16,16,256], n3(:,2337), t3x256(:,:,705))
  call heltable([16,16,256], n3(:,2338), t3x256(:,:,706))
  call heltable([16,16,256], n3(:,2339), t3x256(:,:,707))
  call heltable([16,16,256], n3(:,2340), t3x256(:,:,708))
  call heltable([16,16,256], n3(:,2341), t3x256(:,:,709))
  call heltable([16,16,256], n3(:,2342), t3x256(:,:,710))
  call heltable([16,16,256], n3(:,2343), t3x256(:,:,711))
  call heltable([16,16,256], n3(:,2344), t3x256(:,:,712))
  call heltable([16,16,256], n3(:,2345), t3x256(:,:,713))
  call heltable([16,16,256], n3(:,2346), t3x256(:,:,714))
  call heltable([16,16,256], n3(:,2347), t3x256(:,:,715))
  call heltable([16,16,256], n3(:,2348), t3x256(:,:,716))
  call heltable([16,16,256], n3(:,2349), t3x256(:,:,717))
  call heltable([16,16,256], n3(:,2350), t3x256(:,:,718))
  call heltable([16,16,256], n3(:,2351), t3x256(:,:,719))
  call heltable([16,16,256], n3(:,2352), t3x256(:,:,720))
  call heltable([8,32,256], n3(:,2353), t3x256(:,:,721))
  call heltable([8,32,256], n3(:,2354), t3x256(:,:,722))
  call heltable([16,16,256], n3(:,2355), t3x256(:,:,723))
  call heltable([16,16,256], n3(:,2356), t3x256(:,:,724))
  call heltable([16,16,256], n3(:,2357), t3x256(:,:,725))
  call heltable([16,16,256], n3(:,2358), t3x256(:,:,726))
  call heltable([16,16,256], n3(:,2359), t3x256(:,:,727))
  call heltable([16,16,256], n3(:,2360), t3x256(:,:,728))
  call heltable([8,32,256], n3(:,2361), t3x256(:,:,729))
  call heltable([8,32,256], n3(:,2362), t3x256(:,:,730))
  call heltable([16,16,256], n3(:,2363), t3x256(:,:,731))
  call heltable([16,16,256], n3(:,2364), t3x256(:,:,732))
  call heltable([16,16,256], n3(:,2365), t3x256(:,:,733))
  call heltable([16,16,256], n3(:,2366), t3x256(:,:,734))
  call heltable([16,16,256], n3(:,2367), t3x256(:,:,735))
  call heltable([16,16,256], n3(:,2368), t3x256(:,:,736))
  call heltable([16,16,256], n3(:,2369), t3x256(:,:,737))
  call heltable([16,16,256], n3(:,2370), t3x256(:,:,738))
  call heltable([16,16,256], n3(:,2371), t3x256(:,:,739))
  call heltable([16,16,256], n3(:,2372), t3x256(:,:,740))
  call heltable([16,16,256], n3(:,2373), t3x256(:,:,741))
  call heltable([16,16,256], n3(:,2374), t3x256(:,:,742))
  call heltable([16,16,256], n3(:,2375), t3x256(:,:,743))
  call heltable([16,16,256], n3(:,2376), t3x256(:,:,744))
  call heltable([16,16,256], n3(:,2377), t3x256(:,:,745))
  call heltable([16,16,256], n3(:,2378), t3x256(:,:,746))
  call heltable([16,16,256], n3(:,2379), t3x256(:,:,747))
  call heltable([16,16,256], n3(:,2380), t3x256(:,:,748))
  call heltable([16,16,256], n3(:,2381), t3x256(:,:,749))
  call heltable([16,16,256], n3(:,2382), t3x256(:,:,750))
  call heltable([16,16,256], n3(:,2383), t3x256(:,:,751))
  call heltable([16,16,256], n3(:,2384), t3x256(:,:,752))
  call heltable([8,32,256], n3(:,2385), t3x256(:,:,753))
  call heltable([8,32,256], n3(:,2386), t3x256(:,:,754))
  call heltable([16,16,256], n3(:,2387), t3x256(:,:,755))
  call heltable([16,16,256], n3(:,2388), t3x256(:,:,756))
  call heltable([16,16,256], n3(:,2389), t3x256(:,:,757))
  call heltable([16,16,256], n3(:,2390), t3x256(:,:,758))
  call heltable([16,16,256], n3(:,2391), t3x256(:,:,759))
  call heltable([16,16,256], n3(:,2392), t3x256(:,:,760))
  call heltable([16,16,256], n3(:,2393), t3x256(:,:,761))
  call heltable([16,16,256], n3(:,2394), t3x256(:,:,762))
  call heltable([8,32,256], n3(:,2395), t3x256(:,:,763))
  call heltable([8,32,256], n3(:,2396), t3x256(:,:,764))
  call heltable([16,16,256], n3(:,2397), t3x256(:,:,765))
  call heltable([16,16,256], n3(:,2398), t3x256(:,:,766))
  call heltable([16,16,256], n3(:,2399), t3x256(:,:,767))
  call heltable([16,16,256], n3(:,2400), t3x256(:,:,768))
  call heltable([16,16,256], n3(:,2401), t3x256(:,:,769))
  call heltable([16,16,256], n3(:,2402), t3x256(:,:,770))
  call heltable([16,16,256], n3(:,2403), t3x256(:,:,771))
  call heltable([16,16,256], n3(:,2404), t3x256(:,:,772))
  call heltable([16,16,256], n3(:,2405), t3x256(:,:,773))
  call heltable([16,16,256], n3(:,2406), t3x256(:,:,774))
  call heltable([16,16,256], n3(:,2407), t3x256(:,:,775))
  call heltable([16,16,256], n3(:,2408), t3x256(:,:,776))
  call heltable([16,16,256], n3(:,2409), t3x256(:,:,777))
  call heltable([16,16,256], n3(:,2410), t3x256(:,:,778))
  call heltable([16,16,256], n3(:,2411), t3x256(:,:,779))
  call heltable([16,16,256], n3(:,2412), t3x256(:,:,780))
  call heltable([16,16,256], n3(:,2413), t3x256(:,:,781))
  call heltable([16,16,256], n3(:,2414), t3x256(:,:,782))
  call heltable([16,16,256], n3(:,2415), t3x256(:,:,783))
  call heltable([16,16,256], n3(:,2416), t3x256(:,:,784))
  call heltable([16,16,256], n3(:,2417), t3x256(:,:,785))
  call heltable([16,16,256], n3(:,2418), t3x256(:,:,786))
  call heltable([16,16,256], n3(:,2419), t3x256(:,:,787))
  call heltable([16,16,256], n3(:,2420), t3x256(:,:,788))
  call heltable([16,16,256], n3(:,2421), t3x256(:,:,789))
  call heltable([16,16,256], n3(:,2422), t3x256(:,:,790))
  call heltable([8,32,256], n3(:,2423), t3x256(:,:,791))
  call heltable([8,32,256], n3(:,2424), t3x256(:,:,792))
  call heltable([16,16,256], n3(:,2425), t3x256(:,:,793))
  call heltable([16,16,256], n3(:,2426), t3x256(:,:,794))
  call heltable([16,16,256], n3(:,2427), t3x256(:,:,795))
  call heltable([16,16,256], n3(:,2428), t3x256(:,:,796))
  call heltable([16,16,256], n3(:,2429), t3x256(:,:,797))
  call heltable([16,16,256], n3(:,2430), t3x256(:,:,798))
  call heltable([16,16,256], n3(:,2431), t3x256(:,:,799))
  call heltable([16,16,256], n3(:,2432), t3x256(:,:,800))
  call heltable([8,32,256], n3(:,2433), t3x256(:,:,801))
  call heltable([8,32,256], n3(:,2434), t3x256(:,:,802))
  call heltable([16,16,256], n3(:,2435), t3x256(:,:,803))
  call heltable([16,16,256], n3(:,2436), t3x256(:,:,804))
  call heltable([16,16,256], n3(:,2437), t3x256(:,:,805))
  call heltable([16,16,256], n3(:,2438), t3x256(:,:,806))
  call heltable([16,16,256], n3(:,2439), t3x256(:,:,807))
  call heltable([16,16,256], n3(:,2440), t3x256(:,:,808))
  call heltable([16,16,256], n3(:,2441), t3x256(:,:,809))
  call heltable([16,16,256], n3(:,2442), t3x256(:,:,810))
  call heltable([16,16,256], n3(:,2443), t3x256(:,:,811))
  call heltable([16,16,256], n3(:,2444), t3x256(:,:,812))
  call heltable([16,16,256], n3(:,2445), t3x256(:,:,813))
  call heltable([16,16,256], n3(:,2446), t3x256(:,:,814))
  call heltable([16,16,256], n3(:,2447), t3x256(:,:,815))
  call heltable([16,16,256], n3(:,2448), t3x256(:,:,816))
  call heltable([16,16,256], n3(:,2449), t3x256(:,:,817))
  call heltable([16,16,256], n3(:,2450), t3x256(:,:,818))
  call heltable([16,16,256], n3(:,2451), t3x256(:,:,819))
  call heltable([16,16,256], n3(:,2452), t3x256(:,:,820))
  call heltable([16,16,256], n3(:,2453), t3x256(:,:,821))
  call heltable([16,16,256], n3(:,2454), t3x256(:,:,822))
  call heltable([16,16,256], n3(:,2455), t3x256(:,:,823))
  call heltable([16,16,256], n3(:,2456), t3x256(:,:,824))
  call heltable([16,16,256], n3(:,2457), t3x256(:,:,825))
  call heltable([16,16,256], n3(:,2458), t3x256(:,:,826))
  call heltable([16,16,256], n3(:,2459), t3x256(:,:,827))
  call heltable([16,16,256], n3(:,2460), t3x256(:,:,828))
  call heltable([16,16,256], n3(:,2461), t3x256(:,:,829))
  call heltable([16,16,256], n3(:,2462), t3x256(:,:,830))
  call heltable([16,16,256], n3(:,2463), t3x256(:,:,831))
  call heltable([16,16,256], n3(:,2464), t3x256(:,:,832))
  call heltable([16,16,256], n3(:,2465), t3x256(:,:,833))
  call heltable([16,16,256], n3(:,2466), t3x256(:,:,834))
  call heltable([16,16,256], n3(:,2467), t3x256(:,:,835))
  call heltable([16,16,256], n3(:,2468), t3x256(:,:,836))
  call heltable([16,16,256], n3(:,2469), t3x256(:,:,837))
  call heltable([16,16,256], n3(:,2470), t3x256(:,:,838))
  call heltable([16,16,256], n3(:,2471), t3x256(:,:,839))
  call heltable([16,16,256], n3(:,2472), t3x256(:,:,840))
  call heltable([16,16,256], n3(:,2473), t3x256(:,:,841))
  call heltable([16,16,256], n3(:,2474), t3x256(:,:,842))
  call heltable([16,16,256], n3(:,2475), t3x256(:,:,843))
  call heltable([16,16,256], n3(:,2476), t3x256(:,:,844))
  call heltable([16,16,256], n3(:,2477), t3x256(:,:,845))
  call heltable([16,16,256], n3(:,2478), t3x256(:,:,846))
  call heltable([16,16,256], n3(:,2479), t3x256(:,:,847))
  call heltable([16,16,256], n3(:,2480), t3x256(:,:,848))
  call heltable([16,16,256], n3(:,2481), t3x256(:,:,849))
  call heltable([16,16,256], n3(:,2482), t3x256(:,:,850))
  call heltable([16,16,256], n3(:,2483), t3x256(:,:,851))
  call heltable([16,16,256], n3(:,2484), t3x256(:,:,852))
  call heltable([16,16,256], n3(:,2485), t3x256(:,:,853))
  call heltable([16,16,256], n3(:,2486), t3x256(:,:,854))
  call heltable([16,16,256], n3(:,2487), t3x256(:,:,855))
  call heltable([16,16,256], n3(:,2488), t3x256(:,:,856))
  call heltable([16,16,256], n3(:,2489), t3x256(:,:,857))
  call heltable([16,16,256], n3(:,2490), t3x256(:,:,858))
  call heltable([16,16,256], n3(:,2491), t3x256(:,:,859))
  call heltable([16,16,256], n3(:,2492), t3x256(:,:,860))
  call heltable([16,16,256], n3(:,2493), t3x256(:,:,861))
  call heltable([16,16,256], n3(:,2494), t3x256(:,:,862))
  call heltable([16,16,256], n3(:,2495), t3x256(:,:,863))
  call heltable([16,16,256], n3(:,2496), t3x256(:,:,864))
  call heltable([16,16,256], n3(:,2497), t3x256(:,:,865))
  call heltable([16,16,256], n3(:,2498), t3x256(:,:,866))
  call heltable([16,16,256], n3(:,2499), t3x256(:,:,867))
  call heltable([16,16,256], n3(:,2500), t3x256(:,:,868))
  call heltable([16,16,256], n3(:,2501), t3x256(:,:,869))
  call heltable([16,16,256], n3(:,2502), t3x256(:,:,870))
  call heltable([16,16,256], n3(:,2503), t3x256(:,:,871))
  call heltable([16,16,256], n3(:,2504), t3x256(:,:,872))
  call heltable([16,16,256], n3(:,2505), t3x256(:,:,873))
  call heltable([16,16,256], n3(:,2506), t3x256(:,:,874))
  call heltable([16,16,256], n3(:,2507), t3x256(:,:,875))
  call heltable([16,16,256], n3(:,2508), t3x256(:,:,876))
  call heltable([16,16,256], n3(:,2509), t3x256(:,:,877))
  call heltable([16,16,256], n3(:,2510), t3x256(:,:,878))
  call heltable([16,16,256], n3(:,2511), t3x256(:,:,879))
  call heltable([16,16,256], n3(:,2512), t3x256(:,:,880))
  call heltable([16,16,256], n3(:,2513), t3x256(:,:,881))
  call heltable([16,16,256], n3(:,2514), t3x256(:,:,882))
  call heltable([16,16,256], n3(:,2515), t3x256(:,:,883))
  call heltable([16,16,256], n3(:,2516), t3x256(:,:,884))
  call heltable([16,16,256], n3(:,2517), t3x256(:,:,885))
  call heltable([16,16,256], n3(:,2518), t3x256(:,:,886))
  call heltable([8,32,256], n3(:,2519), t3x256(:,:,887))
  call heltable([8,32,256], n3(:,2520), t3x256(:,:,888))
  call heltable([16,16,256], n3(:,2521), t3x256(:,:,889))
  call heltable([16,16,256], n3(:,2522), t3x256(:,:,890))
  call heltable([16,16,256], n3(:,2523), t3x256(:,:,891))
  call heltable([16,16,256], n3(:,2524), t3x256(:,:,892))
  call heltable([16,16,256], n3(:,2525), t3x256(:,:,893))
  call heltable([16,16,256], n3(:,2526), t3x256(:,:,894))
  call heltable([8,32,256], n3(:,2527), t3x256(:,:,895))
  call heltable([8,32,256], n3(:,2528), t3x256(:,:,896))
  call heltable([16,16,256], n3(:,2529), t3x256(:,:,897))
  call heltable([16,16,256], n3(:,2530), t3x256(:,:,898))
  call heltable([16,16,256], n3(:,2531), t3x256(:,:,899))
  call heltable([16,16,256], n3(:,2532), t3x256(:,:,900))
  call heltable([16,16,256], n3(:,2533), t3x256(:,:,901))
  call heltable([16,16,256], n3(:,2534), t3x256(:,:,902))
  call heltable([16,16,256], n3(:,2535), t3x256(:,:,903))
  call heltable([16,16,256], n3(:,2536), t3x256(:,:,904))
  call heltable([16,16,256], n3(:,2537), t3x256(:,:,905))
  call heltable([16,16,256], n3(:,2538), t3x256(:,:,906))
  call heltable([16,16,256], n3(:,2539), t3x256(:,:,907))
  call heltable([16,16,256], n3(:,2540), t3x256(:,:,908))
  call heltable([16,16,256], n3(:,2541), t3x256(:,:,909))
  call heltable([16,16,256], n3(:,2542), t3x256(:,:,910))
  call heltable([16,16,256], n3(:,2543), t3x256(:,:,911))
  call heltable([16,16,256], n3(:,2544), t3x256(:,:,912))
  call heltable([16,16,256], n3(:,2545), t3x256(:,:,913))
  call heltable([16,16,256], n3(:,2546), t3x256(:,:,914))
  call heltable([16,16,256], n3(:,2547), t3x256(:,:,915))
  call heltable([16,16,256], n3(:,2548), t3x256(:,:,916))
  call heltable([16,16,256], n3(:,2549), t3x256(:,:,917))
  call heltable([16,16,256], n3(:,2550), t3x256(:,:,918))
  call heltable([16,16,256], n3(:,2551), t3x256(:,:,919))
  call heltable([16,16,256], n3(:,2552), t3x256(:,:,920))
  call heltable([16,16,256], n3(:,2553), t3x256(:,:,921))
  call heltable([16,16,256], n3(:,2554), t3x256(:,:,922))
  call heltable([16,16,256], n3(:,2555), t3x256(:,:,923))
  call heltable([16,16,256], n3(:,2556), t3x256(:,:,924))
  call heltable([16,16,256], n3(:,2557), t3x256(:,:,925))
  call heltable([16,16,256], n3(:,2558), t3x256(:,:,926))
  call heltable([16,16,256], n3(:,2559), t3x256(:,:,927))
  call heltable([16,16,256], n3(:,2560), t3x256(:,:,928))
  call heltable([16,16,256], n3(:,2561), t3x256(:,:,929))
  call heltable([16,16,256], n3(:,2562), t3x256(:,:,930))
  call heltable([16,16,256], n3(:,2563), t3x256(:,:,931))
  call heltable([16,16,256], n3(:,2564), t3x256(:,:,932))
  call heltable([8,32,256], n3(:,2565), t3x256(:,:,933))
  call heltable([8,32,256], n3(:,2566), t3x256(:,:,934))
  call heltable([16,16,256], n3(:,2567), t3x256(:,:,935))
  call heltable([16,16,256], n3(:,2568), t3x256(:,:,936))
  call heltable([16,16,256], n3(:,2569), t3x256(:,:,937))
  call heltable([16,16,256], n3(:,2570), t3x256(:,:,938))
  call heltable([16,16,256], n3(:,2571), t3x256(:,:,939))
  call heltable([16,16,256], n3(:,2572), t3x256(:,:,940))
  call heltable([8,32,256], n3(:,2573), t3x256(:,:,941))
  call heltable([8,32,256], n3(:,2574), t3x256(:,:,942))
  call heltable([16,16,256], n3(:,2575), t3x256(:,:,943))
  call heltable([16,16,256], n3(:,2576), t3x256(:,:,944))
  call heltable([16,16,256], n3(:,2577), t3x256(:,:,945))
  call heltable([16,16,256], n3(:,2578), t3x256(:,:,946))
  call heltable([16,16,256], n3(:,2579), t3x256(:,:,947))
  call heltable([16,16,256], n3(:,2580), t3x256(:,:,948))
  call heltable([16,16,256], n3(:,2581), t3x256(:,:,949))
  call heltable([16,16,256], n3(:,2582), t3x256(:,:,950))
  call heltable([16,16,256], n3(:,2583), t3x256(:,:,951))
  call heltable([16,16,256], n3(:,2584), t3x256(:,:,952))
  call heltable([16,16,256], n3(:,2585), t3x256(:,:,953))
  call heltable([16,16,256], n3(:,2586), t3x256(:,:,954))
  call heltable([16,16,256], n3(:,2587), t3x256(:,:,955))
  call heltable([16,16,256], n3(:,2588), t3x256(:,:,956))
  call heltable([16,16,256], n3(:,2589), t3x256(:,:,957))
  call heltable([16,16,256], n3(:,2590), t3x256(:,:,958))
  call heltable([16,16,256], n3(:,2591), t3x256(:,:,959))
  call heltable([16,16,256], n3(:,2592), t3x256(:,:,960))
  call heltable([16,16,256], n3(:,2593), t3x256(:,:,961))
  call heltable([16,16,256], n3(:,2594), t3x256(:,:,962))
  call heltable([16,16,256], n3(:,2595), t3x256(:,:,963))
  call heltable([16,16,256], n3(:,2596), t3x256(:,:,964))
  call heltable([16,16,256], n3(:,2597), t3x256(:,:,965))
  call heltable([16,16,256], n3(:,2598), t3x256(:,:,966))
  call heltable([8,32,256], n3(:,2599), t3x256(:,:,967))
  call heltable([8,32,256], n3(:,2600), t3x256(:,:,968))
  call heltable([16,16,256], n3(:,2601), t3x256(:,:,969))
  call heltable([16,16,256], n3(:,2602), t3x256(:,:,970))
  call heltable([16,16,256], n3(:,2603), t3x256(:,:,971))
  call heltable([16,16,256], n3(:,2604), t3x256(:,:,972))
  call heltable([16,16,256], n3(:,2605), t3x256(:,:,973))
  call heltable([16,16,256], n3(:,2606), t3x256(:,:,974))
  call heltable([16,16,256], n3(:,2607), t3x256(:,:,975))
  call heltable([16,16,256], n3(:,2608), t3x256(:,:,976))
  call heltable([16,16,256], n3(:,2609), t3x256(:,:,977))
  call heltable([16,16,256], n3(:,2610), t3x256(:,:,978))
  call heltable([16,16,256], n3(:,2611), t3x256(:,:,979))
  call heltable([16,16,256], n3(:,2612), t3x256(:,:,980))
  call heltable([16,16,256], n3(:,2613), t3x256(:,:,981))
  call heltable([16,16,256], n3(:,2614), t3x256(:,:,982))
  call heltable([16,16,256], n3(:,2615), t3x256(:,:,983))
  call heltable([16,16,256], n3(:,2616), t3x256(:,:,984))
  call heltable([16,16,256], n3(:,2617), t3x256(:,:,985))
  call heltable([16,16,256], n3(:,2618), t3x256(:,:,986))
  call heltable([8,32,256], n3(:,2619), t3x256(:,:,987))
  call heltable([8,32,256], n3(:,2620), t3x256(:,:,988))
  call heltable([16,16,256], n3(:,2621), t3x256(:,:,989))
  call heltable([16,16,256], n3(:,2622), t3x256(:,:,990))
  call heltable([16,16,256], n3(:,2623), t3x256(:,:,991))
  call heltable([16,16,256], n3(:,2624), t3x256(:,:,992))
  call heltable([16,16,256], n3(:,2625), t3x256(:,:,993))
  call heltable([16,16,256], n3(:,2626), t3x256(:,:,994))
  call heltable([16,16,256], n3(:,2627), t3x256(:,:,995))
  call heltable([16,16,256], n3(:,2628), t3x256(:,:,996))
  call heltable([16,16,256], n3(:,2629), t3x256(:,:,997))
  call heltable([16,16,256], n3(:,2630), t3x256(:,:,998))
  call heltable([16,16,256], n3(:,2631), t3x256(:,:,999))
  call heltable([16,16,256], n3(:,2632), t3x256(:,:,1000))
  call heltable([16,16,256], n3(:,2633), t3x256(:,:,1001))
  call heltable([16,16,256], n3(:,2634), t3x256(:,:,1002))
  call heltable([16,16,256], n3(:,2635), t3x256(:,:,1003))
  call heltable([16,16,256], n3(:,2636), t3x256(:,:,1004))
  call heltable([16,16,256], n3(:,2637), t3x256(:,:,1005))
  call heltable([16,16,256], n3(:,2638), t3x256(:,:,1006))
  call heltable([16,16,256], n3(:,2639), t3x256(:,:,1007))
  call heltable([16,16,256], n3(:,2640), t3x256(:,:,1008))
  call heltable([16,16,256], n3(:,2641), t3x256(:,:,1009))
  call heltable([16,16,256], n3(:,2642), t3x256(:,:,1010))
  call heltable([16,16,256], n3(:,2643), t3x256(:,:,1011))
  call heltable([16,16,256], n3(:,2644), t3x256(:,:,1012))
  call heltable([16,16,256], n3(:,2645), t3x256(:,:,1013))
  call heltable([16,16,256], n3(:,2646), t3x256(:,:,1014))
  call heltable([16,16,256], n3(:,2647), t3x256(:,:,1015))
  call heltable([16,16,256], n3(:,2648), t3x256(:,:,1016))
  call heltable([16,16,256], n3(:,2649), t3x256(:,:,1017))
  call heltable([16,16,256], n3(:,2650), t3x256(:,:,1018))
  call heltable([16,16,256], n3(:,2651), t3x256(:,:,1019))
  call heltable([16,16,256], n3(:,2652), t3x256(:,:,1020))
  call heltable([16,16,256], n3(:,2653), t3x256(:,:,1021))
  call heltable([16,16,256], n3(:,2654), t3x256(:,:,1022))
  call heltable([16,16,256], n3(:,2655), t3x256(:,:,1023))
  call heltable([16,16,256], n3(:,2656), t3x256(:,:,1024))
  call heltable([16,16,256], n3(:,2657), t3x256(:,:,1025))
  call heltable([16,16,256], n3(:,2658), t3x256(:,:,1026))
  call heltable([16,16,256], n3(:,2659), t3x256(:,:,1027))
  call heltable([16,16,256], n3(:,2660), t3x256(:,:,1028))
  call heltable([16,16,256], n3(:,2661), t3x256(:,:,1029))
  call heltable([16,16,256], n3(:,2662), t3x256(:,:,1030))
  call heltable([16,16,256], n3(:,2663), t3x256(:,:,1031))
  call heltable([16,16,256], n3(:,2664), t3x256(:,:,1032))
  call heltable([16,16,256], n3(:,2665), t3x256(:,:,1033))
  call heltable([16,16,256], n3(:,2666), t3x256(:,:,1034))
  call heltable([16,16,256], n3(:,2667), t3x256(:,:,1035))
  call heltable([16,16,256], n3(:,2668), t3x256(:,:,1036))
  call heltable([16,16,256], n3(:,2669), t3x256(:,:,1037))
  call heltable([16,16,256], n3(:,2670), t3x256(:,:,1038))
  call heltable([16,16,256], n3(:,2671), t3x256(:,:,1039))
  call heltable([16,16,256], n3(:,2672), t3x256(:,:,1040))
  call heltable([16,16,256], n3(:,2673), t3x256(:,:,1041))
  call heltable([16,16,256], n3(:,2674), t3x256(:,:,1042))
  call heltable([16,16,256], n3(:,2675), t3x256(:,:,1043))
  call heltable([16,16,256], n3(:,2676), t3x256(:,:,1044))
  call heltable([16,16,256], n3(:,2677), t3x256(:,:,1045))
  call heltable([16,16,256], n3(:,2678), t3x256(:,:,1046))
  call heltable([16,16,256], n3(:,2679), t3x256(:,:,1047))
  call heltable([16,16,256], n3(:,2680), t3x256(:,:,1048))
  call heltable([16,16,256], n3(:,2681), t3x256(:,:,1049))
  call heltable([16,16,256], n3(:,2682), t3x256(:,:,1050))
  call heltable([16,16,256], n3(:,2683), t3x256(:,:,1051))
  call heltable([32,8,256], n3(:,2684), t3x256(:,:,1052))
  call heltable([32,8,256], n3(:,2685), t3x256(:,:,1053))
  call heltable([8,32,256], n3(:,2686), t3x256(:,:,1054))
  call heltable([8,32,256], n3(:,2687), t3x256(:,:,1055))
  call heltable([16,16,256], n3(:,2688), t3x256(:,:,1056))
  call heltable([16,16,256], n3(:,2689), t3x256(:,:,1057))
  call heltable([16,16,256], n3(:,2690), t3x256(:,:,1058))
  call heltable([16,16,256], n3(:,2691), t3x256(:,:,1059))
  call heltable([16,16,256], n3(:,2692), t3x256(:,:,1060))
  call heltable([16,16,256], n3(:,2693), t3x256(:,:,1061))
  call heltable([16,16,256], n3(:,2694), t3x256(:,:,1062))
  call heltable([16,16,256], n3(:,2695), t3x256(:,:,1063))
  call heltable([16,16,256], n3(:,2696), t3x256(:,:,1064))
  call heltable([16,16,256], n3(:,2697), t3x256(:,:,1065))
  call heltable([16,16,256], n3(:,2698), t3x256(:,:,1066))
  call heltable([16,16,256], n3(:,2699), t3x256(:,:,1067))
  call heltable([16,16,256], n3(:,2700), t3x256(:,:,1068))
  call heltable([16,16,256], n3(:,2701), t3x256(:,:,1069))
  call heltable([16,16,256], n3(:,2702), t3x256(:,:,1070))
  call heltable([16,16,256], n3(:,2703), t3x256(:,:,1071))
  call heltable([16,16,256], n3(:,2704), t3x256(:,:,1072))
  call heltable([16,16,256], n3(:,2705), t3x256(:,:,1073))
  call heltable([16,16,256], n3(:,2706), t3x256(:,:,1074))
  call heltable([16,16,256], n3(:,2707), t3x256(:,:,1075))
  call heltable([16,16,256], n3(:,2708), t3x256(:,:,1076))
  call heltable([16,16,256], n3(:,2709), t3x256(:,:,1077))
  call heltable([16,16,256], n3(:,2710), t3x256(:,:,1078))
  call heltable([16,16,256], n3(:,2711), t3x256(:,:,1079))
  call heltable([16,16,256], n3(:,2712), t3x256(:,:,1080))
  call heltable([16,16,256], n3(:,2713), t3x256(:,:,1081))
  call heltable([16,16,256], n3(:,2714), t3x256(:,:,1082))
  call heltable([16,16,256], n3(:,2715), t3x256(:,:,1083))
  call heltable([16,16,256], n3(:,2716), t3x256(:,:,1084))
  call heltable([16,16,256], n3(:,2717), t3x256(:,:,1085))
  call heltable([16,16,256], n3(:,2718), t3x256(:,:,1086))
  call heltable([16,16,256], n3(:,2719), t3x256(:,:,1087))
  call heltable([16,16,256], n3(:,2720), t3x256(:,:,1088))
  call heltable([16,16,256], n3(:,2721), t3x256(:,:,1089))
  call heltable([16,16,256], n3(:,2722), t3x256(:,:,1090))
  call heltable([16,16,256], n3(:,2723), t3x256(:,:,1091))
  call heltable([16,16,256], n3(:,2724), t3x256(:,:,1092))
  call heltable([16,16,256], n3(:,2725), t3x256(:,:,1093))
  call heltable([16,16,256], n3(:,2726), t3x256(:,:,1094))
  call heltable([32,8,256], n3(:,2727), t3x256(:,:,1095))
  call heltable([32,8,256], n3(:,2728), t3x256(:,:,1096))
  call heltable([8,32,256], n3(:,2729), t3x256(:,:,1097))
  call heltable([8,32,256], n3(:,2730), t3x256(:,:,1098))
  call heltable([16,16,256], n3(:,2731), t3x256(:,:,1099))
  call heltable([16,16,256], n3(:,2732), t3x256(:,:,1100))
  call heltable([16,16,256], n3(:,2733), t3x256(:,:,1101))
  call heltable([16,16,256], n3(:,2734), t3x256(:,:,1102))
  call heltable([16,16,256], n3(:,2735), t3x256(:,:,1103))
  call heltable([16,16,256], n3(:,2736), t3x256(:,:,1104))
  call heltable([16,16,256], n3(:,2737), t3x256(:,:,1105))
  call heltable([16,16,256], n3(:,2738), t3x256(:,:,1106))
  call heltable([16,16,256], n3(:,2739), t3x256(:,:,1107))
  call heltable([16,16,256], n3(:,2740), t3x256(:,:,1108))
  call heltable([16,16,256], n3(:,2741), t3x256(:,:,1109))
  call heltable([16,16,256], n3(:,2742), t3x256(:,:,1110))
  call heltable([16,16,256], n3(:,2743), t3x256(:,:,1111))
  call heltable([16,16,256], n3(:,2744), t3x256(:,:,1112))
  call heltable([16,16,256], n3(:,2745), t3x256(:,:,1113))
  call heltable([16,16,256], n3(:,2746), t3x256(:,:,1114))
  call heltable([16,16,256], n3(:,2747), t3x256(:,:,1115))
  call heltable([16,16,256], n3(:,2748), t3x256(:,:,1116))
  call heltable([16,16,256], n3(:,2749), t3x256(:,:,1117))
  call heltable([16,16,256], n3(:,2750), t3x256(:,:,1118))
  call heltable([16,16,256], n3(:,2751), t3x256(:,:,1119))
  call heltable([16,16,256], n3(:,2752), t3x256(:,:,1120))
  call heltable([16,16,256], n3(:,2753), t3x256(:,:,1121))
  call heltable([16,16,256], n3(:,2754), t3x256(:,:,1122))
  call heltable([16,16,256], n3(:,2755), t3x256(:,:,1123))
  call heltable([16,16,256], n3(:,2756), t3x256(:,:,1124))
  call heltable([16,16,256], n3(:,2757), t3x256(:,:,1125))
  call heltable([16,16,256], n3(:,2758), t3x256(:,:,1126))
  call heltable([16,16,256], n3(:,2759), t3x256(:,:,1127))
  call heltable([16,16,256], n3(:,2760), t3x256(:,:,1128))
  call heltable([16,16,256], n3(:,2761), t3x256(:,:,1129))
  call heltable([16,16,256], n3(:,2762), t3x256(:,:,1130))
  call heltable([16,16,256], n3(:,2763), t3x256(:,:,1131))
  call heltable([16,16,256], n3(:,2764), t3x256(:,:,1132))
  call heltable([16,16,256], n3(:,2765), t3x256(:,:,1133))
  call heltable([16,16,256], n3(:,2766), t3x256(:,:,1134))
  call heltable([16,16,256], n3(:,2767), t3x256(:,:,1135))
  call heltable([16,16,256], n3(:,2768), t3x256(:,:,1136))
  call heltable([16,16,256], n3(:,2769), t3x256(:,:,1137))
  call heltable([32,8,256], n3(:,2770), t3x256(:,:,1138))
  call heltable([32,8,256], n3(:,2771), t3x256(:,:,1139))
  call heltable([8,32,256], n3(:,2772), t3x256(:,:,1140))
  call heltable([8,32,256], n3(:,2773), t3x256(:,:,1141))
  call heltable([16,16,256], n3(:,2774), t3x256(:,:,1142))
  call heltable([16,16,256], n3(:,2775), t3x256(:,:,1143))
  call heltable([16,16,256], n3(:,2776), t3x256(:,:,1144))
  call heltable([16,16,256], n3(:,2777), t3x256(:,:,1145))
  call heltable([16,16,256], n3(:,2778), t3x256(:,:,1146))
  call heltable([16,16,256], n3(:,2779), t3x256(:,:,1147))
  call heltable([16,16,256], n3(:,2780), t3x256(:,:,1148))
  call heltable([16,16,256], n3(:,2781), t3x256(:,:,1149))
  call heltable([16,16,256], n3(:,2782), t3x256(:,:,1150))
  call heltable([16,16,256], n3(:,2783), t3x256(:,:,1151))
  call heltable([16,16,256], n3(:,2784), t3x256(:,:,1152))
  call heltable([16,16,256], n3(:,2785), t3x256(:,:,1153))
  call heltable([16,16,256], n3(:,2786), t3x256(:,:,1154))
  call heltable([16,16,256], n3(:,2787), t3x256(:,:,1155))
  call heltable([16,16,256], n3(:,2788), t3x256(:,:,1156))
  call heltable([16,16,256], n3(:,2789), t3x256(:,:,1157))
  call heltable([16,16,256], n3(:,2790), t3x256(:,:,1158))
  call heltable([16,16,256], n3(:,2791), t3x256(:,:,1159))
  call heltable([16,16,256], n3(:,2792), t3x256(:,:,1160))
  call heltable([16,16,256], n3(:,2793), t3x256(:,:,1161))
  call heltable([16,16,256], n3(:,2794), t3x256(:,:,1162))
  call heltable([16,16,256], n3(:,2795), t3x256(:,:,1163))
  call heltable([16,16,256], n3(:,2796), t3x256(:,:,1164))
  call heltable([16,16,256], n3(:,2797), t3x256(:,:,1165))
  call heltable([16,16,256], n3(:,2798), t3x256(:,:,1166))
  call heltable([16,16,256], n3(:,2799), t3x256(:,:,1167))
  call heltable([16,16,256], n3(:,2800), t3x256(:,:,1168))
  call heltable([16,16,256], n3(:,2801), t3x256(:,:,1169))
  call heltable([16,16,256], n3(:,2802), t3x256(:,:,1170))
  call heltable([16,16,256], n3(:,2803), t3x256(:,:,1171))
  call heltable([16,16,256], n3(:,2804), t3x256(:,:,1172))
  call heltable([16,16,256], n3(:,2805), t3x256(:,:,1173))
  call heltable([16,16,256], n3(:,2806), t3x256(:,:,1174))
  call heltable([16,16,256], n3(:,2807), t3x256(:,:,1175))
  call heltable([16,16,256], n3(:,2808), t3x256(:,:,1176))
  call heltable([16,16,256], n3(:,2809), t3x256(:,:,1177))
  call heltable([16,16,256], n3(:,2810), t3x256(:,:,1178))
  call heltable([16,16,256], n3(:,2811), t3x256(:,:,1179))
  call heltable([16,16,256], n3(:,2812), t3x256(:,:,1180))
  call heltable([32,8,256], n3(:,2813), t3x256(:,:,1181))
  call heltable([32,8,256], n3(:,2814), t3x256(:,:,1182))
  call heltable([8,32,256], n3(:,2815), t3x256(:,:,1183))
  call heltable([8,32,256], n3(:,2816), t3x256(:,:,1184))
  call heltable([16,16,256], n3(:,2817), t3x256(:,:,1185))
  call heltable([16,16,256], n3(:,2818), t3x256(:,:,1186))
  call heltable([16,16,256], n3(:,2819), t3x256(:,:,1187))
  call heltable([16,16,256], n3(:,2820), t3x256(:,:,1188))
  call heltable([16,16,256], n3(:,2821), t3x256(:,:,1189))
  call heltable([16,16,256], n3(:,2822), t3x256(:,:,1190))
  call heltable([16,16,256], n3(:,2823), t3x256(:,:,1191))
  call heltable([16,16,256], n3(:,2824), t3x256(:,:,1192))
  call heltable([16,16,256], n3(:,2825), t3x256(:,:,1193))
  call heltable([16,16,256], n3(:,2826), t3x256(:,:,1194))
  call heltable([16,16,256], n3(:,2827), t3x256(:,:,1195))
  call heltable([16,16,256], n3(:,2828), t3x256(:,:,1196))
  call heltable([32,8,256], n3(:,2829), t3x256(:,:,1197))
  call heltable([32,8,256], n3(:,2830), t3x256(:,:,1198))
  call heltable([16,16,256], n3(:,2831), t3x256(:,:,1199))
  call heltable([16,16,256], n3(:,2832), t3x256(:,:,1200))
  call heltable([16,16,256], n3(:,2833), t3x256(:,:,1201))
  call heltable([16,16,256], n3(:,2834), t3x256(:,:,1202))
  call heltable([16,16,256], n3(:,2835), t3x256(:,:,1203))
  call heltable([16,16,256], n3(:,2836), t3x256(:,:,1204))
  call heltable([16,16,256], n3(:,2837), t3x256(:,:,1205))
  call heltable([16,16,256], n3(:,2838), t3x256(:,:,1206))
  call heltable([16,16,256], n3(:,2839), t3x256(:,:,1207))
  call heltable([16,16,256], n3(:,2840), t3x256(:,:,1208))
  call heltable([16,16,256], n3(:,2841), t3x256(:,:,1209))
  call heltable([16,16,256], n3(:,2842), t3x256(:,:,1210))
  call heltable([32,8,256], n3(:,2843), t3x256(:,:,1211))
  call heltable([32,8,256], n3(:,2844), t3x256(:,:,1212))
  call heltable([16,16,256], n3(:,2845), t3x256(:,:,1213))
  call heltable([16,16,256], n3(:,2846), t3x256(:,:,1214))
  call heltable([16,16,256], n3(:,2847), t3x256(:,:,1215))
  call heltable([16,16,256], n3(:,2848), t3x256(:,:,1216))
  call heltable([16,16,256], n3(:,2849), t3x256(:,:,1217))
  call heltable([16,16,256], n3(:,2850), t3x256(:,:,1218))
  call heltable([16,16,256], n3(:,2851), t3x256(:,:,1219))
  call heltable([16,16,256], n3(:,2852), t3x256(:,:,1220))
  call heltable([16,16,256], n3(:,2853), t3x256(:,:,1221))
  call heltable([16,16,256], n3(:,2854), t3x256(:,:,1222))
  call heltable([16,16,256], n3(:,2855), t3x256(:,:,1223))
  call heltable([16,16,256], n3(:,2856), t3x256(:,:,1224))
  call heltable([16,16,256], n3(:,2857), t3x256(:,:,1225))
  call heltable([16,16,256], n3(:,2858), t3x256(:,:,1226))
  call heltable([16,16,256], n3(:,2859), t3x256(:,:,1227))
  call heltable([16,16,256], n3(:,2860), t3x256(:,:,1228))
  call heltable([16,16,256], n3(:,2861), t3x256(:,:,1229))
  call heltable([16,16,256], n3(:,2862), t3x256(:,:,1230))
  call heltable([16,16,256], n3(:,2863), t3x256(:,:,1231))
  call heltable([16,16,256], n3(:,2864), t3x256(:,:,1232))
  call heltable([16,16,256], n3(:,2865), t3x256(:,:,1233))
  call heltable([16,16,256], n3(:,2866), t3x256(:,:,1234))
  call heltable([16,16,256], n3(:,2867), t3x256(:,:,1235))
  call heltable([16,16,256], n3(:,2868), t3x256(:,:,1236))
  call heltable([16,16,256], n3(:,2869), t3x256(:,:,1237))
  call heltable([16,16,256], n3(:,2870), t3x256(:,:,1238))
  call heltable([16,16,256], n3(:,2871), t3x256(:,:,1239))
  call heltable([16,16,256], n3(:,2872), t3x256(:,:,1240))
  call heltable([16,16,256], n3(:,2873), t3x256(:,:,1241))
  call heltable([16,16,256], n3(:,2874), t3x256(:,:,1242))
  call heltable([8,32,256], n3(:,2875), t3x256(:,:,1243))
  call heltable([8,32,256], n3(:,2876), t3x256(:,:,1244))
  call heltable([16,16,256], n3(:,2877), t3x256(:,:,1245))
  call heltable([16,16,256], n3(:,2878), t3x256(:,:,1246))
  call heltable([16,16,256], n3(:,2879), t3x256(:,:,1247))
  call heltable([16,16,256], n3(:,2880), t3x256(:,:,1248))
  call heltable([16,16,256], n3(:,2881), t3x256(:,:,1249))
  call heltable([16,16,256], n3(:,2882), t3x256(:,:,1250))
  call heltable([16,16,256], n3(:,2883), t3x256(:,:,1251))
  call heltable([16,16,256], n3(:,2884), t3x256(:,:,1252))
  call heltable([16,16,256], n3(:,2885), t3x256(:,:,1253))
  call heltable([16,16,256], n3(:,2886), t3x256(:,:,1254))
  call heltable([16,16,256], n3(:,2887), t3x256(:,:,1255))
  call heltable([16,16,256], n3(:,2888), t3x256(:,:,1256))
  call heltable([16,16,256], n3(:,2889), t3x256(:,:,1257))
  call heltable([16,16,256], n3(:,2890), t3x256(:,:,1258))
  call heltable([16,16,256], n3(:,2891), t3x256(:,:,1259))
  call heltable([16,16,256], n3(:,2892), t3x256(:,:,1260))
  call heltable([16,16,256], n3(:,2893), t3x256(:,:,1261))
  call heltable([16,16,256], n3(:,2894), t3x256(:,:,1262))
  call heltable([8,32,256], n3(:,2895), t3x256(:,:,1263))
  call heltable([8,32,256], n3(:,2896), t3x256(:,:,1264))
  call heltable([16,16,256], n3(:,2897), t3x256(:,:,1265))
  call heltable([16,16,256], n3(:,2898), t3x256(:,:,1266))
  call heltable([16,16,256], n3(:,2899), t3x256(:,:,1267))
  call heltable([16,16,256], n3(:,2900), t3x256(:,:,1268))
  call heltable([16,16,256], n3(:,2901), t3x256(:,:,1269))
  call heltable([16,16,256], n3(:,2902), t3x256(:,:,1270))
  call heltable([16,16,256], n3(:,2903), t3x256(:,:,1271))
  call heltable([16,16,256], n3(:,2904), t3x256(:,:,1272))
  call heltable([16,16,256], n3(:,2905), t3x256(:,:,1273))
  call heltable([16,16,256], n3(:,2906), t3x256(:,:,1274))
  call heltable([16,16,256], n3(:,2907), t3x256(:,:,1275))
  call heltable([16,16,256], n3(:,2908), t3x256(:,:,1276))
  call heltable([16,16,256], n3(:,2909), t3x256(:,:,1277))
  call heltable([16,16,256], n3(:,2910), t3x256(:,:,1278))
  call heltable([16,16,256], n3(:,2911), t3x256(:,:,1279))
  call heltable([16,16,256], n3(:,2912), t3x256(:,:,1280))
  call heltable([16,16,256], n3(:,2913), t3x256(:,:,1281))
  call heltable([16,16,256], n3(:,2914), t3x256(:,:,1282))
  call heltable([16,16,256], n3(:,2915), t3x256(:,:,1283))
  call heltable([16,16,256], n3(:,2916), t3x256(:,:,1284))
  call heltable([16,16,256], n3(:,2917), t3x256(:,:,1285))
  call heltable([16,16,256], n3(:,2918), t3x256(:,:,1286))
  call heltable([16,16,256], n3(:,2919), t3x256(:,:,1287))
  call heltable([16,16,256], n3(:,2920), t3x256(:,:,1288))
  call heltable([16,16,256], n3(:,2921), t3x256(:,:,1289))
  call heltable([16,16,256], n3(:,2922), t3x256(:,:,1290))
  call heltable([16,16,256], n3(:,2923), t3x256(:,:,1291))
  call heltable([16,16,256], n3(:,2924), t3x256(:,:,1292))
  call heltable([16,16,256], n3(:,2925), t3x256(:,:,1293))
  call heltable([16,16,256], n3(:,2926), t3x256(:,:,1294))
  call heltable([16,16,256], n3(:,2927), t3x256(:,:,1295))
  call heltable([16,16,256], n3(:,2928), t3x256(:,:,1296))
  call heltable([16,16,256], n3(:,2929), t3x256(:,:,1297))
  call heltable([16,16,256], n3(:,2930), t3x256(:,:,1298))
  call heltable([16,16,256], n3(:,2931), t3x256(:,:,1299))
  call heltable([16,16,256], n3(:,2932), t3x256(:,:,1300))
  call heltable([16,16,256], n3(:,2933), t3x256(:,:,1301))
  call heltable([16,16,256], n3(:,2934), t3x256(:,:,1302))
  call heltable([16,16,256], n3(:,2935), t3x256(:,:,1303))
  call heltable([16,16,256], n3(:,2936), t3x256(:,:,1304))
  call heltable([16,16,256], n3(:,2937), t3x256(:,:,1305))
  call heltable([16,16,256], n3(:,2938), t3x256(:,:,1306))
  call heltable([16,16,256], n3(:,2939), t3x256(:,:,1307))
  call heltable([16,16,256], n3(:,2940), t3x256(:,:,1308))
  call heltable([16,16,256], n3(:,2941), t3x256(:,:,1309))
  call heltable([16,16,256], n3(:,2942), t3x256(:,:,1310))
  call heltable([16,16,256], n3(:,2943), t3x256(:,:,1311))
  call heltable([16,16,256], n3(:,2944), t3x256(:,:,1312))
  call heltable([16,16,256], n3(:,2945), t3x256(:,:,1313))
  call heltable([16,16,256], n3(:,2946), t3x256(:,:,1314))
  call heltable([16,16,256], n3(:,2947), t3x256(:,:,1315))
  call heltable([16,16,256], n3(:,2948), t3x256(:,:,1316))
  call heltable([16,16,256], n3(:,2949), t3x256(:,:,1317))
  call heltable([16,16,256], n3(:,2950), t3x256(:,:,1318))
  call heltable([16,16,256], n3(:,2951), t3x256(:,:,1319))
  call heltable([16,16,256], n3(:,2952), t3x256(:,:,1320))
  call heltable([16,16,256], n3(:,2953), t3x256(:,:,1321))
  call heltable([16,16,256], n3(:,2954), t3x256(:,:,1322))
  call heltable([16,16,256], n3(:,2955), t3x256(:,:,1323))
  call heltable([16,16,256], n3(:,2956), t3x256(:,:,1324))
  call heltable([16,16,256], n3(:,2957), t3x256(:,:,1325))
  call heltable([16,16,256], n3(:,2958), t3x256(:,:,1326))
  call heltable([16,16,256], n3(:,2959), t3x256(:,:,1327))
  call heltable([32,8,256], n3(:,2960), t3x256(:,:,1328))
  call heltable([32,8,256], n3(:,2961), t3x256(:,:,1329))
  call heltable([8,32,256], n3(:,2962), t3x256(:,:,1330))
  call heltable([8,32,256], n3(:,2963), t3x256(:,:,1331))
  call heltable([16,16,256], n3(:,2964), t3x256(:,:,1332))
  call heltable([16,16,256], n3(:,2965), t3x256(:,:,1333))
  call heltable([16,16,256], n3(:,2966), t3x256(:,:,1334))
  call heltable([16,16,256], n3(:,2967), t3x256(:,:,1335))
  call heltable([16,16,256], n3(:,2968), t3x256(:,:,1336))
  call heltable([16,16,256], n3(:,2969), t3x256(:,:,1337))
  call heltable([16,16,256], n3(:,2970), t3x256(:,:,1338))
  call heltable([16,16,256], n3(:,2971), t3x256(:,:,1339))
  call heltable([16,16,256], n3(:,2972), t3x256(:,:,1340))
  call heltable([16,16,256], n3(:,2973), t3x256(:,:,1341))
  call heltable([16,16,256], n3(:,2974), t3x256(:,:,1342))
  call heltable([16,16,256], n3(:,2975), t3x256(:,:,1343))
  call heltable([16,16,256], n3(:,2976), t3x256(:,:,1344))
  call heltable([16,16,256], n3(:,2977), t3x256(:,:,1345))
  call heltable([16,16,256], n3(:,2978), t3x256(:,:,1346))
  call heltable([16,16,256], n3(:,2979), t3x256(:,:,1347))
  call heltable([16,16,256], n3(:,2980), t3x256(:,:,1348))
  call heltable([16,16,256], n3(:,2981), t3x256(:,:,1349))
  call heltable([16,16,256], n3(:,2982), t3x256(:,:,1350))
  call heltable([16,16,256], n3(:,2983), t3x256(:,:,1351))
  call heltable([16,16,256], n3(:,2984), t3x256(:,:,1352))
  call heltable([16,16,256], n3(:,2985), t3x256(:,:,1353))
  call heltable([16,16,256], n3(:,2986), t3x256(:,:,1354))
  call heltable([16,16,256], n3(:,2987), t3x256(:,:,1355))
  call heltable([16,16,256], n3(:,2988), t3x256(:,:,1356))
  call heltable([16,16,256], n3(:,2989), t3x256(:,:,1357))
  call heltable([16,16,256], n3(:,2990), t3x256(:,:,1358))
  call heltable([16,16,256], n3(:,2991), t3x256(:,:,1359))
  call heltable([16,16,256], n3(:,2992), t3x256(:,:,1360))
  call heltable([16,16,256], n3(:,2993), t3x256(:,:,1361))
  call heltable([16,16,256], n3(:,2994), t3x256(:,:,1362))
  call heltable([16,16,256], n3(:,2995), t3x256(:,:,1363))
  call heltable([16,16,256], n3(:,2996), t3x256(:,:,1364))
  call heltable([16,16,256], n3(:,2997), t3x256(:,:,1365))
  call heltable([16,16,256], n3(:,2998), t3x256(:,:,1366))
  call heltable([16,16,256], n3(:,2999), t3x256(:,:,1367))
  call heltable([16,16,256], n3(:,3000), t3x256(:,:,1368))
  call heltable([16,16,256], n3(:,3001), t3x256(:,:,1369))
  call heltable([16,16,256], n3(:,3002), t3x256(:,:,1370))
  call heltable([32,8,256], n3(:,3003), t3x256(:,:,1371))
  call heltable([32,8,256], n3(:,3004), t3x256(:,:,1372))
  call heltable([8,32,256], n3(:,3005), t3x256(:,:,1373))
  call heltable([8,32,256], n3(:,3006), t3x256(:,:,1374))
  call heltable([16,16,256], n3(:,3007), t3x256(:,:,1375))
  call heltable([16,16,256], n3(:,3008), t3x256(:,:,1376))
  call heltable([16,16,256], n3(:,3009), t3x256(:,:,1377))
  call heltable([16,16,256], n3(:,3010), t3x256(:,:,1378))
  call heltable([16,16,256], n3(:,3011), t3x256(:,:,1379))
  call heltable([16,16,256], n3(:,3012), t3x256(:,:,1380))
  call heltable([16,16,256], n3(:,3013), t3x256(:,:,1381))
  call heltable([16,16,256], n3(:,3014), t3x256(:,:,1382))
  call heltable([16,16,256], n3(:,3015), t3x256(:,:,1383))
  call heltable([16,16,256], n3(:,3016), t3x256(:,:,1384))
  call heltable([16,16,256], n3(:,3017), t3x256(:,:,1385))
  call heltable([16,16,256], n3(:,3018), t3x256(:,:,1386))
  call heltable([16,16,256], n3(:,3019), t3x256(:,:,1387))
  call heltable([16,16,256], n3(:,3020), t3x256(:,:,1388))
  call heltable([16,16,256], n3(:,3021), t3x256(:,:,1389))
  call heltable([16,16,256], n3(:,3022), t3x256(:,:,1390))
  call heltable([16,16,256], n3(:,3023), t3x256(:,:,1391))
  call heltable([16,16,256], n3(:,3024), t3x256(:,:,1392))
  call heltable([16,16,256], n3(:,3025), t3x256(:,:,1393))
  call heltable([16,16,256], n3(:,3026), t3x256(:,:,1394))
  call heltable([16,16,256], n3(:,3027), t3x256(:,:,1395))
  call heltable([16,16,256], n3(:,3028), t3x256(:,:,1396))
  call heltable([16,16,256], n3(:,3029), t3x256(:,:,1397))
  call heltable([16,16,256], n3(:,3030), t3x256(:,:,1398))
  call heltable([16,16,256], n3(:,3031), t3x256(:,:,1399))
  call heltable([16,16,256], n3(:,3032), t3x256(:,:,1400))
  call heltable([16,16,256], n3(:,3033), t3x256(:,:,1401))
  call heltable([16,16,256], n3(:,3034), t3x256(:,:,1402))
  call heltable([16,16,256], n3(:,3035), t3x256(:,:,1403))
  call heltable([16,16,256], n3(:,3036), t3x256(:,:,1404))
  call heltable([16,16,256], n3(:,3037), t3x256(:,:,1405))
  call heltable([16,16,256], n3(:,3038), t3x256(:,:,1406))
  call heltable([16,16,256], n3(:,3039), t3x256(:,:,1407))
  call heltable([16,16,256], n3(:,3040), t3x256(:,:,1408))
  call heltable([16,16,256], n3(:,3041), t3x256(:,:,1409))
  call heltable([16,16,256], n3(:,3042), t3x256(:,:,1410))
  call heltable([16,16,256], n3(:,3043), t3x256(:,:,1411))
  call heltable([16,16,256], n3(:,3044), t3x256(:,:,1412))
  call heltable([16,16,256], n3(:,3045), t3x256(:,:,1413))
  call heltable([32,8,256], n3(:,3046), t3x256(:,:,1414))
  call heltable([32,8,256], n3(:,3047), t3x256(:,:,1415))
  call heltable([8,32,256], n3(:,3048), t3x256(:,:,1416))
  call heltable([8,32,256], n3(:,3049), t3x256(:,:,1417))
  call heltable([16,16,256], n3(:,3050), t3x256(:,:,1418))
  call heltable([16,16,256], n3(:,3051), t3x256(:,:,1419))
  call heltable([16,16,256], n3(:,3052), t3x256(:,:,1420))
  call heltable([16,16,256], n3(:,3053), t3x256(:,:,1421))
  call heltable([16,16,256], n3(:,3054), t3x256(:,:,1422))
  call heltable([16,16,256], n3(:,3055), t3x256(:,:,1423))
  call heltable([16,16,256], n3(:,3056), t3x256(:,:,1424))
  call heltable([16,16,256], n3(:,3057), t3x256(:,:,1425))
  call heltable([16,16,256], n3(:,3058), t3x256(:,:,1426))
  call heltable([16,16,256], n3(:,3059), t3x256(:,:,1427))
  call heltable([16,16,256], n3(:,3060), t3x256(:,:,1428))
  call heltable([16,16,256], n3(:,3061), t3x256(:,:,1429))
  call heltable([16,16,256], n3(:,3062), t3x256(:,:,1430))
  call heltable([16,16,256], n3(:,3063), t3x256(:,:,1431))
  call heltable([16,16,256], n3(:,3064), t3x256(:,:,1432))
  call heltable([16,16,256], n3(:,3065), t3x256(:,:,1433))
  call heltable([16,16,256], n3(:,3066), t3x256(:,:,1434))
  call heltable([16,16,256], n3(:,3067), t3x256(:,:,1435))
  call heltable([16,16,256], n3(:,3068), t3x256(:,:,1436))
  call heltable([16,16,256], n3(:,3069), t3x256(:,:,1437))
  call heltable([16,16,256], n3(:,3070), t3x256(:,:,1438))
  call heltable([16,16,256], n3(:,3071), t3x256(:,:,1439))
  call heltable([16,16,256], n3(:,3072), t3x256(:,:,1440))
  call heltable([16,16,256], n3(:,3073), t3x256(:,:,1441))
  call heltable([16,16,256], n3(:,3074), t3x256(:,:,1442))
  call heltable([16,16,256], n3(:,3075), t3x256(:,:,1443))
  call heltable([16,16,256], n3(:,3076), t3x256(:,:,1444))
  call heltable([16,16,256], n3(:,3077), t3x256(:,:,1445))
  call heltable([16,16,256], n3(:,3078), t3x256(:,:,1446))
  call heltable([16,16,256], n3(:,3079), t3x256(:,:,1447))
  call heltable([16,16,256], n3(:,3080), t3x256(:,:,1448))
  call heltable([16,16,256], n3(:,3081), t3x256(:,:,1449))
  call heltable([16,16,256], n3(:,3082), t3x256(:,:,1450))
  call heltable([16,16,256], n3(:,3083), t3x256(:,:,1451))
  call heltable([16,16,256], n3(:,3084), t3x256(:,:,1452))
  call heltable([16,16,256], n3(:,3085), t3x256(:,:,1453))
  call heltable([16,16,256], n3(:,3086), t3x256(:,:,1454))
  call heltable([16,16,256], n3(:,3087), t3x256(:,:,1455))
  call heltable([16,16,256], n3(:,3088), t3x256(:,:,1456))
  call heltable([32,8,256], n3(:,3089), t3x256(:,:,1457))
  call heltable([32,8,256], n3(:,3090), t3x256(:,:,1458))
  call heltable([8,32,256], n3(:,3091), t3x256(:,:,1459))
  call heltable([8,32,256], n3(:,3092), t3x256(:,:,1460))
  call heltable([16,16,256], n3(:,3093), t3x256(:,:,1461))
  call heltable([16,16,256], n3(:,3094), t3x256(:,:,1462))
  call heltable([16,16,256], n3(:,3095), t3x256(:,:,1463))
  call heltable([16,16,256], n3(:,3096), t3x256(:,:,1464))
  call heltable([16,16,256], n3(:,3097), t3x256(:,:,1465))
  call heltable([16,16,256], n3(:,3098), t3x256(:,:,1466))
  call heltable([16,16,256], n3(:,3099), t3x256(:,:,1467))
  call heltable([16,16,256], n3(:,3100), t3x256(:,:,1468))
  call heltable([16,16,256], n3(:,3101), t3x256(:,:,1469))
  call heltable([16,16,256], n3(:,3102), t3x256(:,:,1470))
  call heltable([16,16,256], n3(:,3103), t3x256(:,:,1471))
  call heltable([16,16,256], n3(:,3104), t3x256(:,:,1472))
  call heltable([16,16,256], n3(:,3105), t3x256(:,:,1473))
  call heltable([16,16,256], n3(:,3106), t3x256(:,:,1474))
  call heltable([16,16,256], n3(:,3107), t3x256(:,:,1475))
  call heltable([16,16,256], n3(:,3108), t3x256(:,:,1476))
  call heltable([16,16,256], n3(:,3109), t3x256(:,:,1477))
  call heltable([16,16,256], n3(:,3110), t3x256(:,:,1478))
  call heltable([16,16,256], n3(:,3111), t3x256(:,:,1479))
  call heltable([16,16,256], n3(:,3112), t3x256(:,:,1480))
  call heltable([16,16,256], n3(:,3113), t3x256(:,:,1481))
  call heltable([16,16,256], n3(:,3114), t3x256(:,:,1482))
  call heltable([16,16,256], n3(:,3115), t3x256(:,:,1483))
  call heltable([16,16,256], n3(:,3116), t3x256(:,:,1484))
  call heltable([16,16,256], n3(:,3117), t3x256(:,:,1485))
  call heltable([16,16,256], n3(:,3118), t3x256(:,:,1486))
  call heltable([16,16,256], n3(:,3119), t3x256(:,:,1487))
  call heltable([16,16,256], n3(:,3120), t3x256(:,:,1488))
  call heltable([16,16,256], n3(:,3121), t3x256(:,:,1489))
  call heltable([16,16,256], n3(:,3122), t3x256(:,:,1490))
  call heltable([16,16,256], n3(:,3123), t3x256(:,:,1491))
  call heltable([16,16,256], n3(:,3124), t3x256(:,:,1492))
  call heltable([16,16,256], n3(:,3125), t3x256(:,:,1493))
  call heltable([16,16,256], n3(:,3126), t3x256(:,:,1494))
  call heltable([16,16,256], n3(:,3127), t3x256(:,:,1495))
  call heltable([16,16,256], n3(:,3128), t3x256(:,:,1496))
  call heltable([16,16,256], n3(:,3129), t3x256(:,:,1497))
  call heltable([16,16,256], n3(:,3130), t3x256(:,:,1498))
  call heltable([16,16,256], n3(:,3131), t3x256(:,:,1499))
  call heltable([16,16,256], n3(:,3132), t3x256(:,:,1500))
  call heltable([16,16,256], n3(:,3133), t3x256(:,:,1501))
  call heltable([16,16,256], n3(:,3134), t3x256(:,:,1502))
  call heltable([16,16,256], n3(:,3135), t3x256(:,:,1503))
  call heltable([16,16,256], n3(:,3136), t3x256(:,:,1504))
  call heltable([16,16,256], n3(:,3137), t3x256(:,:,1505))
  call heltable([16,16,256], n3(:,3138), t3x256(:,:,1506))
  call heltable([16,16,256], n3(:,3139), t3x256(:,:,1507))
  call heltable([16,16,256], n3(:,3140), t3x256(:,:,1508))
  call heltable([16,16,256], n3(:,3141), t3x256(:,:,1509))
  call heltable([16,16,256], n3(:,3142), t3x256(:,:,1510))
  call heltable([16,16,256], n3(:,3143), t3x256(:,:,1511))
  call heltable([16,16,256], n3(:,3144), t3x256(:,:,1512))
  call heltable([16,16,256], n3(:,3145), t3x256(:,:,1513))
  call heltable([16,16,256], n3(:,3146), t3x256(:,:,1514))
  call heltable([16,16,256], n3(:,3147), t3x256(:,:,1515))
  call heltable([16,16,256], n3(:,3148), t3x256(:,:,1516))
  call heltable([16,16,256], n3(:,3149), t3x256(:,:,1517))
  call heltable([16,16,256], n3(:,3150), t3x256(:,:,1518))
  call heltable([16,16,256], n3(:,3151), t3x256(:,:,1519))
  call heltable([16,16,256], n3(:,3152), t3x256(:,:,1520))
  call heltable([16,16,256], n3(:,3153), t3x256(:,:,1521))
  call heltable([16,16,256], n3(:,3154), t3x256(:,:,1522))
  call heltable([16,16,256], n3(:,3155), t3x256(:,:,1523))
  call heltable([16,16,256], n3(:,3156), t3x256(:,:,1524))
  call heltable([16,16,256], n3(:,3157), t3x256(:,:,1525))
  call heltable([16,16,256], n3(:,3158), t3x256(:,:,1526))
  call heltable([16,16,256], n3(:,3159), t3x256(:,:,1527))
  call heltable([16,16,256], n3(:,3160), t3x256(:,:,1528))
  call heltable([16,16,256], n3(:,3161), t3x256(:,:,1529))
  call heltable([16,16,256], n3(:,3162), t3x256(:,:,1530))
  call heltable([16,16,256], n3(:,3163), t3x256(:,:,1531))
  call heltable([16,16,256], n3(:,3164), t3x256(:,:,1532))
  call heltable([16,16,256], n3(:,3165), t3x256(:,:,1533))
  call heltable([16,16,256], n3(:,3166), t3x256(:,:,1534))
  call heltable([16,16,256], n3(:,3167), t3x256(:,:,1535))
  call heltable([16,16,256], n3(:,3168), t3x256(:,:,1536))
  call heltable([16,16,256], n3(:,3169), t3x256(:,:,1537))
  call heltable([16,16,256], n3(:,3170), t3x256(:,:,1538))
  call heltable([16,16,256], n3(:,3171), t3x256(:,:,1539))
  call heltable([16,16,256], n3(:,3172), t3x256(:,:,1540))
  call heltable([16,16,256], n3(:,3173), t3x256(:,:,1541))
  call heltable([16,16,256], n3(:,3174), t3x256(:,:,1542))
  call heltable([16,16,256], n3(:,3175), t3x256(:,:,1543))
  call heltable([16,16,256], n3(:,3176), t3x256(:,:,1544))
  call heltable([16,16,256], n3(:,3177), t3x256(:,:,1545))
  call heltable([16,16,256], n3(:,3178), t3x256(:,:,1546))
  call heltable([16,16,256], n3(:,3179), t3x256(:,:,1547))
  call heltable([16,16,256], n3(:,3180), t3x256(:,:,1548))
  call heltable([16,16,256], n3(:,3181), t3x256(:,:,1549))
  call heltable([16,16,256], n3(:,3182), t3x256(:,:,1550))
  call heltable([16,16,256], n3(:,3183), t3x256(:,:,1551))
  call heltable([16,16,256], n3(:,3184), t3x256(:,:,1552))
  call heltable([16,16,256], n3(:,3185), t3x256(:,:,1553))
  call heltable([16,16,256], n3(:,3186), t3x256(:,:,1554))
  call heltable([16,16,256], n3(:,3187), t3x256(:,:,1555))
  call heltable([16,16,256], n3(:,3188), t3x256(:,:,1556))
  call heltable([16,16,256], n3(:,3189), t3x256(:,:,1557))
  call heltable([16,16,256], n3(:,3190), t3x256(:,:,1558))
  call heltable([16,16,256], n3(:,3191), t3x256(:,:,1559))
  call heltable([16,16,256], n3(:,3192), t3x256(:,:,1560))
  call heltable([16,16,256], n3(:,3193), t3x256(:,:,1561))
  call heltable([16,16,256], n3(:,3194), t3x256(:,:,1562))
  call heltable([16,16,256], n3(:,3195), t3x256(:,:,1563))
  call heltable([16,16,256], n3(:,3196), t3x256(:,:,1564))
  call heltable([16,16,256], n3(:,3197), t3x256(:,:,1565))
  call heltable([16,16,256], n3(:,3198), t3x256(:,:,1566))
  call heltable([16,16,256], n3(:,3199), t3x256(:,:,1567))
  call heltable([16,16,256], n3(:,3200), t3x256(:,:,1568))
  call heltable([16,16,256], n3(:,3201), t3x256(:,:,1569))
  call heltable([16,16,256], n3(:,3202), t3x256(:,:,1570))
  call heltable([16,16,256], n3(:,3203), t3x256(:,:,1571))
  call heltable([16,16,256], n3(:,3204), t3x256(:,:,1572))
  call heltable([32,8,256], n3(:,3205), t3x256(:,:,1573))
  call heltable([32,8,256], n3(:,3206), t3x256(:,:,1574))
  call heltable([16,16,256], n3(:,3207), t3x256(:,:,1575))
  call heltable([16,16,256], n3(:,3208), t3x256(:,:,1576))
  call heltable([16,16,256], n3(:,3209), t3x256(:,:,1577))
  call heltable([16,16,256], n3(:,3210), t3x256(:,:,1578))
  call heltable([16,16,256], n3(:,3211), t3x256(:,:,1579))
  call heltable([16,16,256], n3(:,3212), t3x256(:,:,1580))
  call heltable([16,16,256], n3(:,3213), t3x256(:,:,1581))
  call heltable([16,16,256], n3(:,3214), t3x256(:,:,1582))
  call heltable([16,16,256], n3(:,3215), t3x256(:,:,1583))
  call heltable([16,16,256], n3(:,3216), t3x256(:,:,1584))
  call heltable([16,16,256], n3(:,3217), t3x256(:,:,1585))
  call heltable([16,16,256], n3(:,3218), t3x256(:,:,1586))
  call heltable([32,8,256], n3(:,3219), t3x256(:,:,1587))
  call heltable([32,8,256], n3(:,3220), t3x256(:,:,1588))
  call heltable([16,16,256], n3(:,3221), t3x256(:,:,1589))
  call heltable([16,16,256], n3(:,3222), t3x256(:,:,1590))
  call heltable([16,16,256], n3(:,3223), t3x256(:,:,1591))
  call heltable([16,16,256], n3(:,3224), t3x256(:,:,1592))
  call heltable([16,16,256], n3(:,3225), t3x256(:,:,1593))
  call heltable([16,16,256], n3(:,3226), t3x256(:,:,1594))
  call heltable([16,16,256], n3(:,3227), t3x256(:,:,1595))
  call heltable([16,16,256], n3(:,3228), t3x256(:,:,1596))
  call heltable([16,16,256], n3(:,3229), t3x256(:,:,1597))
  call heltable([16,16,256], n3(:,3230), t3x256(:,:,1598))
  call heltable([16,16,256], n3(:,3231), t3x256(:,:,1599))
  call heltable([16,16,256], n3(:,3232), t3x256(:,:,1600))
  call heltable([16,16,256], n3(:,3233), t3x256(:,:,1601))
  call heltable([16,16,256], n3(:,3234), t3x256(:,:,1602))
  call heltable([16,16,256], n3(:,3235), t3x256(:,:,1603))
  call heltable([16,16,256], n3(:,3236), t3x256(:,:,1604))
  call heltable([16,16,256], n3(:,3237), t3x256(:,:,1605))
  call heltable([16,16,256], n3(:,3238), t3x256(:,:,1606))
  call heltable([16,16,256], n3(:,3239), t3x256(:,:,1607))
  call heltable([16,16,256], n3(:,3240), t3x256(:,:,1608))
  call heltable([16,16,256], n3(:,3241), t3x256(:,:,1609))
  call heltable([16,16,256], n3(:,3242), t3x256(:,:,1610))
  call heltable([16,16,256], n3(:,3243), t3x256(:,:,1611))
  call heltable([16,16,256], n3(:,3244), t3x256(:,:,1612))
  call heltable([16,16,256], n3(:,3245), t3x256(:,:,1613))
  call heltable([16,16,256], n3(:,3246), t3x256(:,:,1614))
  call heltable([16,16,256], n3(:,3247), t3x256(:,:,1615))
  call heltable([16,16,256], n3(:,3248), t3x256(:,:,1616))
  call heltable([16,16,256], n3(:,3249), t3x256(:,:,1617))
  call heltable([16,16,256], n3(:,3250), t3x256(:,:,1618))
  call heltable([16,16,256], n3(:,3251), t3x256(:,:,1619))
  call heltable([16,16,256], n3(:,3252), t3x256(:,:,1620))
  call heltable([16,16,256], n3(:,3253), t3x256(:,:,1621))
  call heltable([16,16,256], n3(:,3254), t3x256(:,:,1622))
  call heltable([16,16,256], n3(:,3255), t3x256(:,:,1623))
  call heltable([16,16,256], n3(:,3256), t3x256(:,:,1624))
  call heltable([16,16,256], n3(:,3257), t3x256(:,:,1625))
  call heltable([16,16,256], n3(:,3258), t3x256(:,:,1626))
  call heltable([16,16,256], n3(:,3259), t3x256(:,:,1627))
  call heltable([16,16,256], n3(:,3260), t3x256(:,:,1628))
  call heltable([16,16,256], n3(:,3261), t3x256(:,:,1629))
  call heltable([16,16,256], n3(:,3262), t3x256(:,:,1630))
  call heltable([16,16,256], n3(:,3263), t3x256(:,:,1631))
  call heltable([16,16,256], n3(:,3264), t3x256(:,:,1632))
  call heltable([16,16,256], n3(:,3265), t3x256(:,:,1633))
  call heltable([16,16,256], n3(:,3266), t3x256(:,:,1634))
  call heltable([16,16,256], n3(:,3267), t3x256(:,:,1635))
  call heltable([16,16,256], n3(:,3268), t3x256(:,:,1636))
  call heltable([16,16,256], n3(:,3269), t3x256(:,:,1637))
  call heltable([16,16,256], n3(:,3270), t3x256(:,:,1638))
  call heltable([16,16,256], n3(:,3271), t3x256(:,:,1639))
  call heltable([16,16,256], n3(:,3272), t3x256(:,:,1640))
  call heltable([8,32,256], n3(:,3273), t3x256(:,:,1641))
  call heltable([8,32,256], n3(:,3274), t3x256(:,:,1642))
  call heltable([16,16,256], n3(:,3275), t3x256(:,:,1643))
  call heltable([16,16,256], n3(:,3276), t3x256(:,:,1644))
  call heltable([16,16,256], n3(:,3277), t3x256(:,:,1645))
  call heltable([16,16,256], n3(:,3278), t3x256(:,:,1646))
  call heltable([16,16,256], n3(:,3279), t3x256(:,:,1647))
  call heltable([16,16,256], n3(:,3280), t3x256(:,:,1648))
  call heltable([16,16,256], n3(:,3281), t3x256(:,:,1649))
  call heltable([16,16,256], n3(:,3282), t3x256(:,:,1650))
  call heltable([16,16,256], n3(:,3283), t3x256(:,:,1651))
  call heltable([16,16,256], n3(:,3284), t3x256(:,:,1652))
  call heltable([16,16,256], n3(:,3285), t3x256(:,:,1653))
  call heltable([16,16,256], n3(:,3286), t3x256(:,:,1654))
  call heltable([16,16,256], n3(:,3287), t3x256(:,:,1655))
  call heltable([16,16,256], n3(:,3288), t3x256(:,:,1656))
  call heltable([16,16,256], n3(:,3289), t3x256(:,:,1657))
  call heltable([16,16,256], n3(:,3290), t3x256(:,:,1658))
  call heltable([8,32,256], n3(:,3291), t3x256(:,:,1659))
  call heltable([8,32,256], n3(:,3292), t3x256(:,:,1660))
  call heltable([16,16,256], n3(:,3293), t3x256(:,:,1661))
  call heltable([16,16,256], n3(:,3294), t3x256(:,:,1662))
  call heltable([16,16,256], n3(:,3295), t3x256(:,:,1663))
  call heltable([16,16,256], n3(:,3296), t3x256(:,:,1664))
  call heltable([16,16,256], n3(:,3297), t3x256(:,:,1665))
  call heltable([16,16,256], n3(:,3298), t3x256(:,:,1666))
  call heltable([16,16,256], n3(:,3299), t3x256(:,:,1667))
  call heltable([16,16,256], n3(:,3300), t3x256(:,:,1668))
  call heltable([16,16,256], n3(:,3301), t3x256(:,:,1669))
  call heltable([16,16,256], n3(:,3302), t3x256(:,:,1670))
  call heltable([16,16,256], n3(:,3303), t3x256(:,:,1671))
  call heltable([16,16,256], n3(:,3304), t3x256(:,:,1672))
  call heltable([16,16,256], n3(:,3305), t3x256(:,:,1673))
  call heltable([16,16,256], n3(:,3306), t3x256(:,:,1674))
  call heltable([16,16,256], n3(:,3307), t3x256(:,:,1675))
  call heltable([16,16,256], n3(:,3308), t3x256(:,:,1676))
  call heltable([16,16,256], n3(:,3309), t3x256(:,:,1677))
  call heltable([16,16,256], n3(:,3310), t3x256(:,:,1678))
  call heltable([16,16,256], n3(:,3311), t3x256(:,:,1679))
  call heltable([16,16,256], n3(:,3312), t3x256(:,:,1680))
  call heltable([16,16,256], n3(:,3313), t3x256(:,:,1681))
  call heltable([16,16,256], n3(:,3314), t3x256(:,:,1682))
  call heltable([16,16,256], n3(:,3315), t3x256(:,:,1683))
  call heltable([16,16,256], n3(:,3316), t3x256(:,:,1684))
  call heltable([16,16,256], n3(:,3317), t3x256(:,:,1685))
  call heltable([16,16,256], n3(:,3318), t3x256(:,:,1686))
  call heltable([16,16,256], n3(:,3319), t3x256(:,:,1687))
  call heltable([16,16,256], n3(:,3320), t3x256(:,:,1688))
  call heltable([16,16,256], n3(:,3321), t3x256(:,:,1689))
  call heltable([16,16,256], n3(:,3322), t3x256(:,:,1690))
  call heltable([32,8,256], n3(:,3323), t3x256(:,:,1691))
  call heltable([16,16,256], n3(:,3324), t3x256(:,:,1692))
  call heltable([16,16,256], n3(:,3325), t3x256(:,:,1693))
  call heltable([8,32,256], n3(:,3326), t3x256(:,:,1694))
  call heltable([16,16,256], n3(:,3327), t3x256(:,:,1695))
  call heltable([16,16,256], n3(:,3328), t3x256(:,:,1696))
  call heltable([16,16,256], n3(:,3329), t3x256(:,:,1697))
  call heltable([16,16,256], n3(:,3330), t3x256(:,:,1698))
  call heltable([16,16,256], n3(:,3331), t3x256(:,:,1699))
  call heltable([16,16,256], n3(:,3332), t3x256(:,:,1700))
  call heltable([16,16,256], n3(:,3333), t3x256(:,:,1701))
  call heltable([16,16,256], n3(:,3334), t3x256(:,:,1702))
  call heltable([16,16,256], n3(:,3335), t3x256(:,:,1703))
  call heltable([16,16,256], n3(:,3336), t3x256(:,:,1704))
  call heltable([16,16,256], n3(:,3337), t3x256(:,:,1705))
  call heltable([16,16,256], n3(:,3338), t3x256(:,:,1706))
  call heltable([32,8,256], n3(:,3339), t3x256(:,:,1707))
  call heltable([16,16,256], n3(:,3340), t3x256(:,:,1708))
  call heltable([16,16,256], n3(:,3341), t3x256(:,:,1709))
  call heltable([8,32,256], n3(:,3342), t3x256(:,:,1710))
  call heltable([16,16,256], n3(:,3343), t3x256(:,:,1711))
  call heltable([16,16,256], n3(:,3344), t3x256(:,:,1712))
  call heltable([16,16,256], n3(:,3345), t3x256(:,:,1713))
  call heltable([16,16,256], n3(:,3346), t3x256(:,:,1714))
  call heltable([16,16,256], n3(:,3347), t3x256(:,:,1715))
  call heltable([16,16,256], n3(:,3348), t3x256(:,:,1716))
  call heltable([32,8,256], n3(:,3349), t3x256(:,:,1717))
  call heltable([16,16,256], n3(:,3350), t3x256(:,:,1718))
  call heltable([16,16,256], n3(:,3351), t3x256(:,:,1719))
  call heltable([8,32,256], n3(:,3352), t3x256(:,:,1720))
  call heltable([16,16,256], n3(:,3353), t3x256(:,:,1721))
  call heltable([16,16,256], n3(:,3354), t3x256(:,:,1722))
  call heltable([16,16,256], n3(:,3355), t3x256(:,:,1723))
  call heltable([16,16,256], n3(:,3356), t3x256(:,:,1724))
  call heltable([16,16,256], n3(:,3357), t3x256(:,:,1725))
  call heltable([16,16,256], n3(:,3358), t3x256(:,:,1726))
  call heltable([32,8,256], n3(:,3359), t3x256(:,:,1727))
  call heltable([16,16,256], n3(:,3360), t3x256(:,:,1728))
  call heltable([16,16,256], n3(:,3361), t3x256(:,:,1729))
  call heltable([8,32,256], n3(:,3362), t3x256(:,:,1730))
  call heltable([16,16,256], n3(:,3363), t3x256(:,:,1731))
  call heltable([16,16,256], n3(:,3364), t3x256(:,:,1732))
  call heltable([16,16,256], n3(:,3365), t3x256(:,:,1733))
  call heltable([16,16,256], n3(:,3366), t3x256(:,:,1734))
  call heltable([16,16,256], n3(:,3367), t3x256(:,:,1735))
  call heltable([16,16,256], n3(:,3368), t3x256(:,:,1736))
  call heltable([16,16,256], n3(:,3369), t3x256(:,:,1737))
  call heltable([16,16,256], n3(:,3370), t3x256(:,:,1738))
  call heltable([16,16,256], n3(:,3371), t3x256(:,:,1739))
  call heltable([16,16,256], n3(:,3372), t3x256(:,:,1740))
  call heltable([16,16,256], n3(:,3373), t3x256(:,:,1741))
  call heltable([16,16,256], n3(:,3374), t3x256(:,:,1742))
  call heltable([16,16,256], n3(:,3375), t3x256(:,:,1743))
  call heltable([16,16,256], n3(:,3376), t3x256(:,:,1744))
  call heltable([16,16,256], n3(:,3377), t3x256(:,:,1745))
  call heltable([16,16,256], n3(:,3378), t3x256(:,:,1746))
  call heltable([16,16,256], n3(:,3379), t3x256(:,:,1747))
  call heltable([16,16,256], n3(:,3380), t3x256(:,:,1748))
  call heltable([16,16,256], n3(:,3381), t3x256(:,:,1749))
  call heltable([16,16,256], n3(:,3382), t3x256(:,:,1750))
  call heltable([16,16,256], n3(:,3383), t3x256(:,:,1751))
  call heltable([16,16,256], n3(:,3384), t3x256(:,:,1752))
  call heltable([16,16,256], n3(:,3385), t3x256(:,:,1753))
  call heltable([16,16,256], n3(:,3386), t3x256(:,:,1754))
  call heltable([16,16,256], n3(:,3387), t3x256(:,:,1755))
  call heltable([16,16,256], n3(:,3388), t3x256(:,:,1756))
  call heltable([16,16,256], n3(:,3389), t3x256(:,:,1757))
  call heltable([16,16,256], n3(:,3390), t3x256(:,:,1758))
  call heltable([16,16,256], n3(:,3391), t3x256(:,:,1759))
  call heltable([16,16,256], n3(:,3392), t3x256(:,:,1760))
  call heltable([16,16,256], n3(:,3393), t3x256(:,:,1761))
  call heltable([16,16,256], n3(:,3394), t3x256(:,:,1762))
  call heltable([16,16,256], n3(:,3395), t3x256(:,:,1763))
  call heltable([16,16,256], n3(:,3396), t3x256(:,:,1764))
  call heltable([16,16,256], n3(:,3397), t3x256(:,:,1765))
  call heltable([16,16,256], n3(:,3398), t3x256(:,:,1766))
  call heltable([16,16,256], n3(:,3399), t3x256(:,:,1767))
  call heltable([16,16,256], n3(:,3400), t3x256(:,:,1768))
  call heltable([16,16,256], n3(:,3401), t3x256(:,:,1769))
  call heltable([16,16,256], n3(:,3402), t3x256(:,:,1770))
  call heltable([16,16,256], n3(:,3403), t3x256(:,:,1771))
  call heltable([16,16,256], n3(:,3404), t3x256(:,:,1772))
  call heltable([16,16,256], n3(:,3405), t3x256(:,:,1773))
  call heltable([16,16,256], n3(:,3406), t3x256(:,:,1774))
  call heltable([16,16,256], n3(:,3407), t3x256(:,:,1775))
  call heltable([16,16,256], n3(:,3408), t3x256(:,:,1776))
  call heltable([16,16,256], n3(:,3409), t3x256(:,:,1777))
  call heltable([16,16,256], n3(:,3410), t3x256(:,:,1778))
  call heltable([16,16,256], n3(:,3411), t3x256(:,:,1779))
  call heltable([16,16,256], n3(:,3412), t3x256(:,:,1780))
  call heltable([16,16,256], n3(:,3413), t3x256(:,:,1781))
  call heltable([16,16,256], n3(:,3414), t3x256(:,:,1782))
  call heltable([16,16,256], n3(:,3415), t3x256(:,:,1783))
  call heltable([16,16,256], n3(:,3416), t3x256(:,:,1784))
  call heltable([16,16,256], n3(:,3417), t3x256(:,:,1785))
  call heltable([16,16,256], n3(:,3418), t3x256(:,:,1786))
  call heltable([16,16,256], n3(:,3419), t3x256(:,:,1787))
  call heltable([16,16,256], n3(:,3420), t3x256(:,:,1788))
  call heltable([16,16,256], n3(:,3421), t3x256(:,:,1789))
  call heltable([16,16,256], n3(:,3422), t3x256(:,:,1790))
  call heltable([16,16,256], n3(:,3423), t3x256(:,:,1791))
  call heltable([16,16,256], n3(:,3424), t3x256(:,:,1792))
  call heltable([16,16,256], n3(:,3425), t3x256(:,:,1793))
  call heltable([16,16,256], n3(:,3426), t3x256(:,:,1794))
  call heltable([16,16,256], n3(:,3427), t3x256(:,:,1795))
  call heltable([16,16,256], n3(:,3428), t3x256(:,:,1796))
  call heltable([16,16,256], n3(:,3429), t3x256(:,:,1797))
  call heltable([16,16,256], n3(:,3430), t3x256(:,:,1798))
  call heltable([16,16,256], n3(:,3431), t3x256(:,:,1799))
  call heltable([16,16,256], n3(:,3432), t3x256(:,:,1800))
  call heltable([16,16,256], n3(:,3433), t3x256(:,:,1801))
  call heltable([16,16,256], n3(:,3434), t3x256(:,:,1802))
  call heltable([16,16,256], n3(:,3435), t3x256(:,:,1803))
  call heltable([16,16,256], n3(:,3436), t3x256(:,:,1804))
  call heltable([16,16,256], n3(:,3437), t3x256(:,:,1805))
  call heltable([16,16,256], n3(:,3438), t3x256(:,:,1806))
  call heltable([16,16,256], n3(:,3439), t3x256(:,:,1807))
  call heltable([16,16,256], n3(:,3440), t3x256(:,:,1808))
  call heltable([16,16,256], n3(:,3441), t3x256(:,:,1809))
  call heltable([16,16,256], n3(:,3442), t3x256(:,:,1810))
  call heltable([16,16,256], n3(:,3443), t3x256(:,:,1811))
  call heltable([16,16,256], n3(:,3444), t3x256(:,:,1812))
  call heltable([16,16,256], n3(:,3445), t3x256(:,:,1813))
  call heltable([16,16,256], n3(:,3446), t3x256(:,:,1814))
  call heltable([8,32,256], n3(:,3447), t3x256(:,:,1815))
  call heltable([8,32,256], n3(:,3448), t3x256(:,:,1816))
  call heltable([16,16,256], n3(:,3449), t3x256(:,:,1817))
  call heltable([16,16,256], n3(:,3450), t3x256(:,:,1818))
  call heltable([16,16,256], n3(:,3451), t3x256(:,:,1819))
  call heltable([16,16,256], n3(:,3452), t3x256(:,:,1820))
  call heltable([16,16,256], n3(:,3453), t3x256(:,:,1821))
  call heltable([16,16,256], n3(:,3454), t3x256(:,:,1822))
  call heltable([16,16,256], n3(:,3455), t3x256(:,:,1823))
  call heltable([16,16,256], n3(:,3456), t3x256(:,:,1824))
  call heltable([16,16,256], n3(:,3457), t3x256(:,:,1825))
  call heltable([16,16,256], n3(:,3458), t3x256(:,:,1826))
  call heltable([16,16,256], n3(:,3459), t3x256(:,:,1827))
  call heltable([16,16,256], n3(:,3460), t3x256(:,:,1828))
  call heltable([8,32,256], n3(:,3461), t3x256(:,:,1829))
  call heltable([8,32,256], n3(:,3462), t3x256(:,:,1830))
  call heltable([16,16,256], n3(:,3463), t3x256(:,:,1831))
  call heltable([16,16,256], n3(:,3464), t3x256(:,:,1832))
  call heltable([16,16,256], n3(:,3465), t3x256(:,:,1833))
  call heltable([16,16,256], n3(:,3466), t3x256(:,:,1834))
  call heltable([16,16,256], n3(:,3467), t3x256(:,:,1835))
  call heltable([16,16,256], n3(:,3468), t3x256(:,:,1836))
  call heltable([16,16,256], n3(:,3469), t3x256(:,:,1837))
  call heltable([16,16,256], n3(:,3470), t3x256(:,:,1838))
  call heltable([16,16,256], n3(:,3471), t3x256(:,:,1839))
  call heltable([16,16,256], n3(:,3472), t3x256(:,:,1840))
  call heltable([16,16,256], n3(:,3473), t3x256(:,:,1841))
  call heltable([16,16,256], n3(:,3474), t3x256(:,:,1842))
  call heltable([16,16,256], n3(:,3475), t3x256(:,:,1843))
  call heltable([16,16,256], n3(:,3476), t3x256(:,:,1844))
  call heltable([16,16,256], n3(:,3477), t3x256(:,:,1845))
  call heltable([16,16,256], n3(:,3478), t3x256(:,:,1846))
  call heltable([16,16,256], n3(:,3479), t3x256(:,:,1847))
  call heltable([16,16,256], n3(:,3480), t3x256(:,:,1848))
  call heltable([16,16,256], n3(:,3481), t3x256(:,:,1849))
  call heltable([16,16,256], n3(:,3482), t3x256(:,:,1850))
  call heltable([16,16,256], n3(:,3483), t3x256(:,:,1851))
  call heltable([16,16,256], n3(:,3484), t3x256(:,:,1852))
  call heltable([16,16,256], n3(:,3485), t3x256(:,:,1853))
  call heltable([16,16,256], n3(:,3486), t3x256(:,:,1854))
  call heltable([16,16,256], n3(:,3487), t3x256(:,:,1855))
  call heltable([16,16,256], n3(:,3488), t3x256(:,:,1856))
  call heltable([8,32,256], n3(:,3489), t3x256(:,:,1857))
  call heltable([8,32,256], n3(:,3490), t3x256(:,:,1858))
  call heltable([16,16,256], n3(:,3491), t3x256(:,:,1859))
  call heltable([16,16,256], n3(:,3492), t3x256(:,:,1860))
  call heltable([16,16,256], n3(:,3493), t3x256(:,:,1861))
  call heltable([16,16,256], n3(:,3494), t3x256(:,:,1862))
  call heltable([16,16,256], n3(:,3495), t3x256(:,:,1863))
  call heltable([16,16,256], n3(:,3496), t3x256(:,:,1864))
  call heltable([16,16,256], n3(:,3497), t3x256(:,:,1865))
  call heltable([16,16,256], n3(:,3498), t3x256(:,:,1866))
  call heltable([16,16,256], n3(:,3499), t3x256(:,:,1867))
  call heltable([16,16,256], n3(:,3500), t3x256(:,:,1868))
  call heltable([16,16,256], n3(:,3501), t3x256(:,:,1869))
  call heltable([16,16,256], n3(:,3502), t3x256(:,:,1870))
  call heltable([16,16,256], n3(:,3503), t3x256(:,:,1871))
  call heltable([16,16,256], n3(:,3504), t3x256(:,:,1872))
  call heltable([16,16,256], n3(:,3505), t3x256(:,:,1873))
  call heltable([16,16,256], n3(:,3506), t3x256(:,:,1874))
  call heltable([8,32,256], n3(:,3507), t3x256(:,:,1875))
  call heltable([8,32,256], n3(:,3508), t3x256(:,:,1876))
  call heltable([16,16,256], n3(:,3509), t3x256(:,:,1877))
  call heltable([16,16,256], n3(:,3510), t3x256(:,:,1878))
  call heltable([16,16,256], n3(:,3511), t3x256(:,:,1879))
  call heltable([16,16,256], n3(:,3512), t3x256(:,:,1880))
  call heltable([16,16,256], n3(:,3513), t3x256(:,:,1881))
  call heltable([16,16,256], n3(:,3514), t3x256(:,:,1882))
  call heltable([16,16,256], n3(:,3515), t3x256(:,:,1883))
  call heltable([16,16,256], n3(:,3516), t3x256(:,:,1884))
  call heltable([16,16,256], n3(:,3517), t3x256(:,:,1885))
  call heltable([16,16,256], n3(:,3518), t3x256(:,:,1886))
  call heltable([16,16,256], n3(:,3519), t3x256(:,:,1887))
  call heltable([16,16,256], n3(:,3520), t3x256(:,:,1888))
  call heltable([16,16,256], n3(:,3521), t3x256(:,:,1889))
  call heltable([16,16,256], n3(:,3522), t3x256(:,:,1890))
  call heltable([16,16,256], n3(:,3523), t3x256(:,:,1891))
  call heltable([16,16,256], n3(:,3524), t3x256(:,:,1892))
  call heltable([16,16,256], n3(:,3525), t3x256(:,:,1893))
  call heltable([16,16,256], n3(:,3526), t3x256(:,:,1894))
  call heltable([16,16,256], n3(:,3527), t3x256(:,:,1895))
  call heltable([16,16,256], n3(:,3528), t3x256(:,:,1896))
  call heltable([16,16,256], n3(:,3529), t3x256(:,:,1897))
  call heltable([16,16,256], n3(:,3530), t3x256(:,:,1898))
  call heltable([16,16,256], n3(:,3531), t3x256(:,:,1899))
  call heltable([16,16,256], n3(:,3532), t3x256(:,:,1900))
  call heltable([16,16,256], n3(:,3533), t3x256(:,:,1901))
  call heltable([16,16,256], n3(:,3534), t3x256(:,:,1902))
  call heltable([16,16,256], n3(:,3535), t3x256(:,:,1903))
  call heltable([16,16,256], n3(:,3536), t3x256(:,:,1904))
  call heltable([16,16,256], n3(:,3537), t3x256(:,:,1905))
  call heltable([16,16,256], n3(:,3538), t3x256(:,:,1906))
  call heltable([16,16,256], n3(:,3539), t3x256(:,:,1907))
  call heltable([16,16,256], n3(:,3540), t3x256(:,:,1908))
  call heltable([16,16,256], n3(:,3541), t3x256(:,:,1909))
  call heltable([16,16,256], n3(:,3542), t3x256(:,:,1910))
  call heltable([16,16,256], n3(:,3543), t3x256(:,:,1911))
  call heltable([16,16,256], n3(:,3544), t3x256(:,:,1912))
  call heltable([16,16,256], n3(:,3545), t3x256(:,:,1913))
  call heltable([16,16,256], n3(:,3546), t3x256(:,:,1914))
  call heltable([16,16,256], n3(:,3547), t3x256(:,:,1915))
  call heltable([16,16,256], n3(:,3548), t3x256(:,:,1916))
  call heltable([16,16,256], n3(:,3549), t3x256(:,:,1917))
  call heltable([16,16,256], n3(:,3550), t3x256(:,:,1918))
  call heltable([16,16,256], n3(:,3551), t3x256(:,:,1919))
  call heltable([16,16,256], n3(:,3552), t3x256(:,:,1920))
  call heltable([16,16,256], n3(:,3553), t3x256(:,:,1921))
  call heltable([16,16,256], n3(:,3554), t3x256(:,:,1922))
  call heltable([16,16,256], n3(:,3555), t3x256(:,:,1923))
  call heltable([16,16,256], n3(:,3556), t3x256(:,:,1924))
  call heltable([16,16,256], n3(:,3557), t3x256(:,:,1925))
  call heltable([16,16,256], n3(:,3558), t3x256(:,:,1926))
  call heltable([16,16,256], n3(:,3559), t3x256(:,:,1927))
  call heltable([16,16,256], n3(:,3560), t3x256(:,:,1928))
  call heltable([16,16,256], n3(:,3561), t3x256(:,:,1929))
  call heltable([16,16,256], n3(:,3562), t3x256(:,:,1930))
  call heltable([8,32,256], n3(:,3563), t3x256(:,:,1931))
  call heltable([16,16,256], n3(:,3564), t3x256(:,:,1932))
  call heltable([16,16,256], n3(:,3565), t3x256(:,:,1933))
  call heltable([32,8,256], n3(:,3566), t3x256(:,:,1934))
  call heltable([16,16,256], n3(:,3567), t3x256(:,:,1935))
  call heltable([16,16,256], n3(:,3568), t3x256(:,:,1936))
  call heltable([16,16,256], n3(:,3569), t3x256(:,:,1937))
  call heltable([16,16,256], n3(:,3570), t3x256(:,:,1938))
  call heltable([16,16,256], n3(:,3571), t3x256(:,:,1939))
  call heltable([16,16,256], n3(:,3572), t3x256(:,:,1940))
  call heltable([16,16,256], n3(:,3573), t3x256(:,:,1941))
  call heltable([16,16,256], n3(:,3574), t3x256(:,:,1942))
  call heltable([16,16,256], n3(:,3575), t3x256(:,:,1943))
  call heltable([16,16,256], n3(:,3576), t3x256(:,:,1944))
  call heltable([16,16,256], n3(:,3577), t3x256(:,:,1945))
  call heltable([16,16,256], n3(:,3578), t3x256(:,:,1946))
  call heltable([8,32,256], n3(:,3579), t3x256(:,:,1947))
  call heltable([16,16,256], n3(:,3580), t3x256(:,:,1948))
  call heltable([16,16,256], n3(:,3581), t3x256(:,:,1949))
  call heltable([32,8,256], n3(:,3582), t3x256(:,:,1950))
  call heltable([16,16,256], n3(:,3583), t3x256(:,:,1951))
  call heltable([16,16,256], n3(:,3584), t3x256(:,:,1952))
  call heltable([16,16,256], n3(:,3585), t3x256(:,:,1953))
  call heltable([16,16,256], n3(:,3586), t3x256(:,:,1954))
  call heltable([16,16,256], n3(:,3587), t3x256(:,:,1955))
  call heltable([16,16,256], n3(:,3588), t3x256(:,:,1956))
  call heltable([8,32,256], n3(:,3589), t3x256(:,:,1957))
  call heltable([16,16,256], n3(:,3590), t3x256(:,:,1958))
  call heltable([16,16,256], n3(:,3591), t3x256(:,:,1959))
  call heltable([32,8,256], n3(:,3592), t3x256(:,:,1960))
  call heltable([16,16,256], n3(:,3593), t3x256(:,:,1961))
  call heltable([16,16,256], n3(:,3594), t3x256(:,:,1962))
  call heltable([16,16,256], n3(:,3595), t3x256(:,:,1963))
  call heltable([16,16,256], n3(:,3596), t3x256(:,:,1964))
  call heltable([16,16,256], n3(:,3597), t3x256(:,:,1965))
  call heltable([16,16,256], n3(:,3598), t3x256(:,:,1966))
  call heltable([8,32,256], n3(:,3599), t3x256(:,:,1967))
  call heltable([16,16,256], n3(:,3600), t3x256(:,:,1968))
  call heltable([16,16,256], n3(:,3601), t3x256(:,:,1969))
  call heltable([32,8,256], n3(:,3602), t3x256(:,:,1970))
  call heltable([16,16,256], n3(:,3603), t3x256(:,:,1971))
  call heltable([16,16,256], n3(:,3604), t3x256(:,:,1972))
  call heltable([16,16,256], n3(:,3605), t3x256(:,:,1973))
  call heltable([16,16,256], n3(:,3606), t3x256(:,:,1974))
  call heltable([16,16,256], n3(:,3607), t3x256(:,:,1975))
  call heltable([16,16,256], n3(:,3608), t3x256(:,:,1976))
  call heltable([16,16,256], n3(:,3609), t3x256(:,:,1977))
  call heltable([16,16,256], n3(:,3610), t3x256(:,:,1978))
  call heltable([16,16,256], n3(:,3611), t3x256(:,:,1979))
  call heltable([16,16,256], n3(:,3612), t3x256(:,:,1980))
  call heltable([16,16,256], n3(:,3613), t3x256(:,:,1981))
  call heltable([16,16,256], n3(:,3614), t3x256(:,:,1982))
  call heltable([16,16,256], n3(:,3615), t3x256(:,:,1983))
  call heltable([16,16,256], n3(:,3616), t3x256(:,:,1984))
  call heltable([16,16,256], n3(:,3617), t3x256(:,:,1985))
  call heltable([16,16,256], n3(:,3618), t3x256(:,:,1986))
  call heltable([16,16,256], n3(:,3619), t3x256(:,:,1987))
  call heltable([16,16,256], n3(:,3620), t3x256(:,:,1988))
  call heltable([16,16,256], n3(:,3621), t3x256(:,:,1989))
  call heltable([16,16,256], n3(:,3622), t3x256(:,:,1990))
  call heltable([16,16,256], n3(:,3623), t3x256(:,:,1991))
  call heltable([16,16,256], n3(:,3624), t3x256(:,:,1992))
  call heltable([16,16,256], n3(:,3625), t3x256(:,:,1993))
  call heltable([16,16,256], n3(:,3626), t3x256(:,:,1994))
  call heltable([16,16,256], n3(:,3627), t3x256(:,:,1995))
  call heltable([16,16,256], n3(:,3628), t3x256(:,:,1996))
  call heltable([16,16,256], n3(:,3629), t3x256(:,:,1997))
  call heltable([16,16,256], n3(:,3630), t3x256(:,:,1998))
  call heltable([16,16,256], n3(:,3631), t3x256(:,:,1999))
  call heltable([16,16,256], n3(:,3632), t3x256(:,:,2000))
  call heltable([16,16,256], n3(:,3633), t3x256(:,:,2001))
  call heltable([16,16,256], n3(:,3634), t3x256(:,:,2002))
  call heltable([16,16,256], n3(:,3635), t3x256(:,:,2003))
  call heltable([16,16,256], n3(:,3636), t3x256(:,:,2004))
  call heltable([16,16,256], n3(:,3637), t3x256(:,:,2005))
  call heltable([16,16,256], n3(:,3638), t3x256(:,:,2006))
  call heltable([16,16,256], n3(:,3639), t3x256(:,:,2007))
  call heltable([16,16,256], n3(:,3640), t3x256(:,:,2008))
  call heltable([16,16,256], n3(:,3641), t3x256(:,:,2009))
  call heltable([16,16,256], n3(:,3642), t3x256(:,:,2010))
  call heltable([16,16,256], n3(:,3643), t3x256(:,:,2011))
  call heltable([16,16,256], n3(:,3644), t3x256(:,:,2012))
  call heltable([16,16,256], n3(:,3645), t3x256(:,:,2013))
  call heltable([16,16,256], n3(:,3646), t3x256(:,:,2014))
  call heltable([16,16,256], n3(:,3647), t3x256(:,:,2015))
  call heltable([16,16,256], n3(:,3648), t3x256(:,:,2016))
  call heltable([16,16,256], n3(:,3649), t3x256(:,:,2017))
  call heltable([16,16,256], n3(:,3650), t3x256(:,:,2018))
  call heltable([16,16,256], n3(:,3651), t3x256(:,:,2019))
  call heltable([16,16,256], n3(:,3652), t3x256(:,:,2020))
  call heltable([16,16,256], n3(:,3653), t3x256(:,:,2021))
  call heltable([16,16,256], n3(:,3654), t3x256(:,:,2022))
  call heltable([16,16,256], n3(:,3655), t3x256(:,:,2023))
  call heltable([16,16,256], n3(:,3656), t3x256(:,:,2024))
  call heltable([16,16,256], n3(:,3657), t3x256(:,:,2025))
  call heltable([16,16,256], n3(:,3658), t3x256(:,:,2026))
  call heltable([16,16,256], n3(:,3659), t3x256(:,:,2027))
  call heltable([16,16,256], n3(:,3660), t3x256(:,:,2028))
  call heltable([16,16,256], n3(:,3661), t3x256(:,:,2029))
  call heltable([16,16,256], n3(:,3662), t3x256(:,:,2030))
  call heltable([8,32,256], n3(:,3663), t3x256(:,:,2031))
  call heltable([8,32,256], n3(:,3664), t3x256(:,:,2032))
  call heltable([16,16,256], n3(:,3665), t3x256(:,:,2033))
  call heltable([16,16,256], n3(:,3666), t3x256(:,:,2034))
  call heltable([16,16,256], n3(:,3667), t3x256(:,:,2035))
  call heltable([16,16,256], n3(:,3668), t3x256(:,:,2036))
  call heltable([16,16,256], n3(:,3669), t3x256(:,:,2037))
  call heltable([16,16,256], n3(:,3670), t3x256(:,:,2038))
  call heltable([16,16,256], n3(:,3671), t3x256(:,:,2039))
  call heltable([16,16,256], n3(:,3672), t3x256(:,:,2040))
  call heltable([16,16,256], n3(:,3673), t3x256(:,:,2041))
  call heltable([16,16,256], n3(:,3674), t3x256(:,:,2042))
  call heltable([16,16,256], n3(:,3675), t3x256(:,:,2043))
  call heltable([16,16,256], n3(:,3676), t3x256(:,:,2044))
  call heltable([8,32,256], n3(:,3677), t3x256(:,:,2045))
  call heltable([8,32,256], n3(:,3678), t3x256(:,:,2046))
  call heltable([16,16,256], n3(:,3679), t3x256(:,:,2047))
  call heltable([16,16,256], n3(:,3680), t3x256(:,:,2048))
  call heltable([16,16,256], n3(:,3681), t3x256(:,:,2049))
  call heltable([16,16,256], n3(:,3682), t3x256(:,:,2050))
  call heltable([16,16,256], n3(:,3683), t3x256(:,:,2051))
  call heltable([16,16,256], n3(:,3684), t3x256(:,:,2052))
  call heltable([16,16,256], n3(:,3685), t3x256(:,:,2053))
  call heltable([16,16,256], n3(:,3686), t3x256(:,:,2054))
  call heltable([16,16,256], n3(:,3687), t3x256(:,:,2055))
  call heltable([16,16,256], n3(:,3688), t3x256(:,:,2056))
  call heltable([16,16,256], n3(:,3689), t3x256(:,:,2057))
  call heltable([16,16,256], n3(:,3690), t3x256(:,:,2058))
  call heltable([16,16,256], n3(:,3691), t3x256(:,:,2059))
  call heltable([16,16,256], n3(:,3692), t3x256(:,:,2060))
  call heltable([16,16,256], n3(:,3693), t3x256(:,:,2061))
  call heltable([16,16,256], n3(:,3694), t3x256(:,:,2062))
  call heltable([16,16,256], n3(:,3695), t3x256(:,:,2063))
  call heltable([16,16,256], n3(:,3696), t3x256(:,:,2064))
  call heltable([16,16,256], n3(:,3697), t3x256(:,:,2065))
  call heltable([16,16,256], n3(:,3698), t3x256(:,:,2066))
  call heltable([16,16,256], n3(:,3699), t3x256(:,:,2067))
  call heltable([16,16,256], n3(:,3700), t3x256(:,:,2068))
  call heltable([16,16,256], n3(:,3701), t3x256(:,:,2069))
  call heltable([16,16,256], n3(:,3702), t3x256(:,:,2070))
  call heltable([16,16,256], n3(:,3703), t3x256(:,:,2071))
  call heltable([16,16,256], n3(:,3704), t3x256(:,:,2072))
  call heltable([16,16,256], n3(:,3705), t3x256(:,:,2073))
  call heltable([16,16,256], n3(:,3706), t3x256(:,:,2074))
  call heltable([16,16,256], n3(:,3707), t3x256(:,:,2075))
  call heltable([16,16,256], n3(:,3708), t3x256(:,:,2076))
  call heltable([16,16,256], n3(:,3709), t3x256(:,:,2077))
  call heltable([16,16,256], n3(:,3710), t3x256(:,:,2078))
  call heltable([16,16,256], n3(:,3711), t3x256(:,:,2079))
  call heltable([16,16,256], n3(:,3712), t3x256(:,:,2080))
  call heltable([16,16,256], n3(:,3713), t3x256(:,:,2081))
  call heltable([16,16,256], n3(:,3714), t3x256(:,:,2082))
  call heltable([16,16,256], n3(:,3715), t3x256(:,:,2083))
  call heltable([16,16,256], n3(:,3716), t3x256(:,:,2084))
  call heltable([16,16,256], n3(:,3717), t3x256(:,:,2085))
  call heltable([16,16,256], n3(:,3718), t3x256(:,:,2086))
  call heltable([16,16,256], n3(:,3719), t3x256(:,:,2087))
  call heltable([16,16,256], n3(:,3720), t3x256(:,:,2088))
  call heltable([16,16,256], n3(:,3721), t3x256(:,:,2089))
  call heltable([16,16,256], n3(:,3722), t3x256(:,:,2090))
  call heltable([16,16,256], n3(:,3723), t3x256(:,:,2091))
  call heltable([16,16,256], n3(:,3724), t3x256(:,:,2092))
  call heltable([16,16,256], n3(:,3725), t3x256(:,:,2093))
  call heltable([16,16,256], n3(:,3726), t3x256(:,:,2094))
  call heltable([16,16,256], n3(:,3727), t3x256(:,:,2095))
  call heltable([16,16,256], n3(:,3728), t3x256(:,:,2096))
  call heltable([16,16,256], n3(:,3729), t3x256(:,:,2097))
  call heltable([16,16,256], n3(:,3730), t3x256(:,:,2098))
  call heltable([16,16,256], n3(:,3731), t3x256(:,:,2099))
  call heltable([16,16,256], n3(:,3732), t3x256(:,:,2100))
  call heltable([16,16,256], n3(:,3733), t3x256(:,:,2101))
  call heltable([16,16,256], n3(:,3734), t3x256(:,:,2102))
  call heltable([16,16,256], n3(:,3735), t3x256(:,:,2103))
  call heltable([16,16,256], n3(:,3736), t3x256(:,:,2104))
  call heltable([16,16,256], n3(:,3737), t3x256(:,:,2105))
  call heltable([16,16,256], n3(:,3738), t3x256(:,:,2106))
  call heltable([16,16,256], n3(:,3739), t3x256(:,:,2107))
  call heltable([16,16,256], n3(:,3740), t3x256(:,:,2108))
  call heltable([16,16,256], n3(:,3741), t3x256(:,:,2109))
  call heltable([16,16,256], n3(:,3742), t3x256(:,:,2110))
  call heltable([16,16,256], n3(:,3743), t3x256(:,:,2111))
  call heltable([16,16,256], n3(:,3744), t3x256(:,:,2112))
  call heltable([16,16,256], n3(:,3745), t3x256(:,:,2113))
  call heltable([16,16,256], n3(:,3746), t3x256(:,:,2114))
  call heltable([16,16,256], n3(:,3747), t3x256(:,:,2115))
  call heltable([16,16,256], n3(:,3748), t3x256(:,:,2116))
  call heltable([16,16,256], n3(:,3749), t3x256(:,:,2117))
  call heltable([16,16,256], n3(:,3750), t3x256(:,:,2118))
  call heltable([16,16,256], n3(:,3751), t3x256(:,:,2119))
  call heltable([16,16,256], n3(:,3752), t3x256(:,:,2120))
  call heltable([16,16,256], n3(:,3753), t3x256(:,:,2121))
  call heltable([16,16,256], n3(:,3754), t3x256(:,:,2122))
  call heltable([32,8,256], n3(:,3755), t3x256(:,:,2123))
  call heltable([8,32,256], n3(:,3756), t3x256(:,:,2124))
  call heltable([8,32,256], n3(:,3757), t3x256(:,:,2125))
  call heltable([32,8,256], n3(:,3758), t3x256(:,:,2126))
  call heltable([8,32,256], n3(:,3759), t3x256(:,:,2127))
  call heltable([8,32,256], n3(:,3760), t3x256(:,:,2128))
  call heltable([16,16,256], n3(:,3761), t3x256(:,:,2129))
  call heltable([16,16,256], n3(:,3762), t3x256(:,:,2130))
  call heltable([16,16,256], n3(:,3763), t3x256(:,:,2131))
  call heltable([16,16,256], n3(:,3764), t3x256(:,:,2132))
  call heltable([16,16,256], n3(:,3765), t3x256(:,:,2133))
  call heltable([16,16,256], n3(:,3766), t3x256(:,:,2134))
  call heltable([16,16,256], n3(:,3767), t3x256(:,:,2135))
  call heltable([16,16,256], n3(:,3768), t3x256(:,:,2136))
  call heltable([32,8,256], n3(:,3769), t3x256(:,:,2137))
  call heltable([8,32,256], n3(:,3770), t3x256(:,:,2138))
  call heltable([8,32,256], n3(:,3771), t3x256(:,:,2139))
  call heltable([32,8,256], n3(:,3772), t3x256(:,:,2140))
  call heltable([8,32,256], n3(:,3773), t3x256(:,:,2141))
  call heltable([8,32,256], n3(:,3774), t3x256(:,:,2142))
  call heltable([16,16,256], n3(:,3775), t3x256(:,:,2143))
  call heltable([16,16,256], n3(:,3776), t3x256(:,:,2144))
  call heltable([16,16,256], n3(:,3777), t3x256(:,:,2145))
  call heltable([16,16,256], n3(:,3778), t3x256(:,:,2146))
  call heltable([16,16,256], n3(:,3779), t3x256(:,:,2147))
  call heltable([16,16,256], n3(:,3780), t3x256(:,:,2148))
  call heltable([16,16,256], n3(:,3781), t3x256(:,:,2149))
  call heltable([16,16,256], n3(:,3782), t3x256(:,:,2150))
  call heltable([8,32,256], n3(:,3783), t3x256(:,:,2151))
  call heltable([16,16,256], n3(:,3784), t3x256(:,:,2152))
  call heltable([16,16,256], n3(:,3785), t3x256(:,:,2153))
  call heltable([16,16,256], n3(:,3786), t3x256(:,:,2154))
  call heltable([16,16,256], n3(:,3787), t3x256(:,:,2155))
  call heltable([8,32,256], n3(:,3788), t3x256(:,:,2156))
  call heltable([16,16,256], n3(:,3789), t3x256(:,:,2157))
  call heltable([16,16,256], n3(:,3790), t3x256(:,:,2158))
  call heltable([16,16,256], n3(:,3791), t3x256(:,:,2159))
  call heltable([16,16,256], n3(:,3792), t3x256(:,:,2160))
  call heltable([16,16,256], n3(:,3793), t3x256(:,:,2161))
  call heltable([16,16,256], n3(:,3794), t3x256(:,:,2162))
  call heltable([16,16,256], n3(:,3795), t3x256(:,:,2163))
  call heltable([16,16,256], n3(:,3796), t3x256(:,:,2164))
  call heltable([16,16,256], n3(:,3797), t3x256(:,:,2165))
  call heltable([16,16,256], n3(:,3798), t3x256(:,:,2166))
  call heltable([16,16,256], n3(:,3799), t3x256(:,:,2167))
  call heltable([16,16,256], n3(:,3800), t3x256(:,:,2168))
  call heltable([8,32,256], n3(:,3801), t3x256(:,:,2169))
  call heltable([32,8,256], n3(:,3802), t3x256(:,:,2170))
  call heltable([8,32,256], n3(:,3803), t3x256(:,:,2171))
  call heltable([8,32,256], n3(:,3804), t3x256(:,:,2172))
  call heltable([32,8,256], n3(:,3805), t3x256(:,:,2173))
  call heltable([32,8,256], n3(:,3806), t3x256(:,:,2174))
  call heltable([32,8,256], n3(:,3807), t3x256(:,:,2175))
  call heltable([32,8,256], n3(:,3808), t3x256(:,:,2176))
  call heltable([8,32,256], n3(:,3809), t3x256(:,:,2177))
  call heltable([32,8,256], n3(:,3810), t3x256(:,:,2178))
  call heltable([8,32,256], n3(:,3811), t3x256(:,:,2179))
  call heltable([8,32,256], n3(:,3812), t3x256(:,:,2180))
  call heltable([32,8,256], n3(:,3813), t3x256(:,:,2181))
  call heltable([32,8,256], n3(:,3814), t3x256(:,:,2182))
  call heltable([32,8,256], n3(:,3815), t3x256(:,:,2183))
  call heltable([32,8,256], n3(:,3816), t3x256(:,:,2184))
  call heltable([8,32,256], n3(:,3817), t3x256(:,:,2185))
  call heltable([8,32,256], n3(:,3818), t3x256(:,:,2186))
  call heltable([8,32,256], n3(:,3819), t3x256(:,:,2187))
  call heltable([8,32,256], n3(:,3820), t3x256(:,:,2188))
  call heltable([16,16,256], n3(:,3821), t3x256(:,:,2189))
  call heltable([16,16,256], n3(:,3822), t3x256(:,:,2190))
  call heltable([16,16,256], n3(:,3823), t3x256(:,:,2191))
  call heltable([16,16,256], n3(:,3824), t3x256(:,:,2192))
  call heltable([16,16,256], n3(:,3825), t3x256(:,:,2193))
  call heltable([16,16,256], n3(:,3826), t3x256(:,:,2194))
  call heltable([16,16,256], n3(:,3827), t3x256(:,:,2195))
  call heltable([16,16,256], n3(:,3828), t3x256(:,:,2196))
  call heltable([8,32,256], n3(:,3829), t3x256(:,:,2197))
  call heltable([8,32,256], n3(:,3830), t3x256(:,:,2198))
  call heltable([16,16,256], n3(:,3831), t3x256(:,:,2199))
  call heltable([16,16,256], n3(:,3832), t3x256(:,:,2200))
  call heltable([16,16,256], n3(:,3833), t3x256(:,:,2201))
  call heltable([16,16,256], n3(:,3834), t3x256(:,:,2202))
  call heltable([8,32,256], n3(:,3835), t3x256(:,:,2203))
  call heltable([8,32,256], n3(:,3836), t3x256(:,:,2204))
  call heltable([16,16,256], n3(:,3837), t3x256(:,:,2205))
  call heltable([16,16,256], n3(:,3838), t3x256(:,:,2206))
  call heltable([16,16,256], n3(:,3839), t3x256(:,:,2207))
  call heltable([16,16,256], n3(:,3840), t3x256(:,:,2208))
  call heltable([16,16,256], n3(:,3841), t3x256(:,:,2209))
  call heltable([16,16,256], n3(:,3842), t3x256(:,:,2210))
  call heltable([16,16,256], n3(:,3843), t3x256(:,:,2211))
  call heltable([16,16,256], n3(:,3844), t3x256(:,:,2212))
  call heltable([16,16,256], n3(:,3845), t3x256(:,:,2213))
  call heltable([16,16,256], n3(:,3846), t3x256(:,:,2214))
  call heltable([16,16,256], n3(:,3847), t3x256(:,:,2215))
  call heltable([16,16,256], n3(:,3848), t3x256(:,:,2216))
  call heltable([16,16,256], n3(:,3849), t3x256(:,:,2217))
  call heltable([16,16,256], n3(:,3850), t3x256(:,:,2218))
  call heltable([16,16,256], n3(:,3851), t3x256(:,:,2219))
  call heltable([16,16,256], n3(:,3852), t3x256(:,:,2220))
  call heltable([16,16,256], n3(:,3853), t3x256(:,:,2221))
  call heltable([16,16,256], n3(:,3854), t3x256(:,:,2222))
  call heltable([16,16,256], n3(:,3855), t3x256(:,:,2223))
  call heltable([16,16,256], n3(:,3856), t3x256(:,:,2224))
  call heltable([16,16,256], n3(:,3857), t3x256(:,:,2225))
  call heltable([16,16,256], n3(:,3858), t3x256(:,:,2226))
  call heltable([16,16,256], n3(:,3859), t3x256(:,:,2227))
  call heltable([16,16,256], n3(:,3860), t3x256(:,:,2228))
  call heltable([16,16,256], n3(:,3861), t3x256(:,:,2229))
  call heltable([16,16,256], n3(:,3862), t3x256(:,:,2230))
  call heltable([16,16,256], n3(:,3863), t3x256(:,:,2231))
  call heltable([16,16,256], n3(:,3864), t3x256(:,:,2232))
  call heltable([16,16,256], n3(:,3865), t3x256(:,:,2233))
  call heltable([16,16,256], n3(:,3866), t3x256(:,:,2234))
  call heltable([16,16,256], n3(:,3867), t3x256(:,:,2235))
  call heltable([16,16,256], n3(:,3868), t3x256(:,:,2236))
  call heltable([16,16,256], n3(:,3869), t3x256(:,:,2237))
  call heltable([16,16,256], n3(:,3870), t3x256(:,:,2238))
  call heltable([16,16,256], n3(:,3871), t3x256(:,:,2239))
  call heltable([16,16,256], n3(:,3872), t3x256(:,:,2240))
  call heltable([16,16,256], n3(:,3873), t3x256(:,:,2241))
  call heltable([16,16,256], n3(:,3874), t3x256(:,:,2242))
  call heltable([16,16,256], n3(:,3875), t3x256(:,:,2243))
  call heltable([16,16,256], n3(:,3876), t3x256(:,:,2244))
  call heltable([16,16,256], n3(:,3877), t3x256(:,:,2245))
  call heltable([16,16,256], n3(:,3878), t3x256(:,:,2246))
  call heltable([16,16,256], n3(:,3879), t3x256(:,:,2247))
  call heltable([16,16,256], n3(:,3880), t3x256(:,:,2248))
  call heltable([16,16,256], n3(:,3881), t3x256(:,:,2249))
  call heltable([16,16,256], n3(:,3882), t3x256(:,:,2250))
  call heltable([16,16,256], n3(:,3883), t3x256(:,:,2251))
  call heltable([16,16,256], n3(:,3884), t3x256(:,:,2252))
  call heltable([16,16,256], n3(:,3885), t3x256(:,:,2253))
  call heltable([16,16,256], n3(:,3886), t3x256(:,:,2254))
  call heltable([16,16,256], n3(:,3887), t3x256(:,:,2255))
  call heltable([16,16,256], n3(:,3888), t3x256(:,:,2256))
  call heltable([16,16,256], n3(:,3889), t3x256(:,:,2257))
  call heltable([16,16,256], n3(:,3890), t3x256(:,:,2258))
  call heltable([16,16,256], n3(:,3891), t3x256(:,:,2259))
  call heltable([16,16,256], n3(:,3892), t3x256(:,:,2260))
  call heltable([16,16,256], n3(:,3893), t3x256(:,:,2261))
  call heltable([16,16,256], n3(:,3894), t3x256(:,:,2262))
  call heltable([16,16,256], n3(:,3895), t3x256(:,:,2263))
  call heltable([16,16,256], n3(:,3896), t3x256(:,:,2264))
  call heltable([16,16,256], n3(:,3897), t3x256(:,:,2265))
  call heltable([16,16,256], n3(:,3898), t3x256(:,:,2266))
  call heltable([32,8,256], n3(:,3899), t3x256(:,:,2267))
  call heltable([8,32,256], n3(:,3900), t3x256(:,:,2268))
  call heltable([8,32,256], n3(:,3901), t3x256(:,:,2269))
  call heltable([32,8,256], n3(:,3902), t3x256(:,:,2270))
  call heltable([8,32,256], n3(:,3903), t3x256(:,:,2271))
  call heltable([8,32,256], n3(:,3904), t3x256(:,:,2272))
  call heltable([16,16,256], n3(:,3905), t3x256(:,:,2273))
  call heltable([16,16,256], n3(:,3906), t3x256(:,:,2274))
  call heltable([16,16,256], n3(:,3907), t3x256(:,:,2275))
  call heltable([16,16,256], n3(:,3908), t3x256(:,:,2276))
  call heltable([16,16,256], n3(:,3909), t3x256(:,:,2277))
  call heltable([16,16,256], n3(:,3910), t3x256(:,:,2278))
  call heltable([16,16,256], n3(:,3911), t3x256(:,:,2279))
  call heltable([16,16,256], n3(:,3912), t3x256(:,:,2280))
  call heltable([32,8,256], n3(:,3913), t3x256(:,:,2281))
  call heltable([8,32,256], n3(:,3914), t3x256(:,:,2282))
  call heltable([8,32,256], n3(:,3915), t3x256(:,:,2283))
  call heltable([32,8,256], n3(:,3916), t3x256(:,:,2284))
  call heltable([8,32,256], n3(:,3917), t3x256(:,:,2285))
  call heltable([8,32,256], n3(:,3918), t3x256(:,:,2286))
  call heltable([16,16,256], n3(:,3919), t3x256(:,:,2287))
  call heltable([16,16,256], n3(:,3920), t3x256(:,:,2288))
  call heltable([16,16,256], n3(:,3921), t3x256(:,:,2289))
  call heltable([16,16,256], n3(:,3922), t3x256(:,:,2290))
  call heltable([16,16,256], n3(:,3923), t3x256(:,:,2291))
  call heltable([16,16,256], n3(:,3924), t3x256(:,:,2292))
  call heltable([16,16,256], n3(:,3925), t3x256(:,:,2293))
  call heltable([16,16,256], n3(:,3926), t3x256(:,:,2294))
  call heltable([8,32,256], n3(:,3927), t3x256(:,:,2295))
  call heltable([32,8,256], n3(:,3928), t3x256(:,:,2296))
  call heltable([8,32,256], n3(:,3929), t3x256(:,:,2297))
  call heltable([8,32,256], n3(:,3930), t3x256(:,:,2298))
  call heltable([8,32,256], n3(:,3931), t3x256(:,:,2299))
  call heltable([8,32,256], n3(:,3932), t3x256(:,:,2300))
  call heltable([8,32,256], n3(:,3933), t3x256(:,:,2301))
  call heltable([8,32,256], n3(:,3934), t3x256(:,:,2302))
  call heltable([8,32,256], n3(:,3935), t3x256(:,:,2303))
  call heltable([32,8,256], n3(:,3936), t3x256(:,:,2304))
  call heltable([8,32,256], n3(:,3937), t3x256(:,:,2305))
  call heltable([8,32,256], n3(:,3938), t3x256(:,:,2306))
  call heltable([8,32,256], n3(:,3939), t3x256(:,:,2307))
  call heltable([8,32,256], n3(:,3940), t3x256(:,:,2308))
  call heltable([8,32,256], n3(:,3941), t3x256(:,:,2309))
  call heltable([8,32,256], n3(:,3942), t3x256(:,:,2310))
  call heltable([8,32,256], n3(:,3943), t3x256(:,:,2311))
  call heltable([8,32,256], n3(:,3944), t3x256(:,:,2312))
  call heltable([8,32,256], n3(:,3945), t3x256(:,:,2313))
  call heltable([8,32,256], n3(:,3946), t3x256(:,:,2314))
  call heltable([16,16,256], n3(:,3947), t3x256(:,:,2315))
  call heltable([16,16,256], n3(:,3948), t3x256(:,:,2316))
  call heltable([16,16,256], n3(:,3949), t3x256(:,:,2317))
  call heltable([16,16,256], n3(:,3950), t3x256(:,:,2318))
  call heltable([16,16,256], n3(:,3951), t3x256(:,:,2319))
  call heltable([16,16,256], n3(:,3952), t3x256(:,:,2320))
  call heltable([16,16,256], n3(:,3953), t3x256(:,:,2321))
  call heltable([16,16,256], n3(:,3954), t3x256(:,:,2322))
  call heltable([8,32,256], n3(:,3955), t3x256(:,:,2323))
  call heltable([16,16,256], n3(:,3956), t3x256(:,:,2324))
  call heltable([16,16,256], n3(:,3957), t3x256(:,:,2325))
  call heltable([16,16,256], n3(:,3958), t3x256(:,:,2326))
  call heltable([16,16,256], n3(:,3959), t3x256(:,:,2327))
  call heltable([8,32,256], n3(:,3960), t3x256(:,:,2328))
  call heltable([16,16,256], n3(:,3961), t3x256(:,:,2329))
  call heltable([16,16,256], n3(:,3962), t3x256(:,:,2330))
  call heltable([16,16,256], n3(:,3963), t3x256(:,:,2331))
  call heltable([16,16,256], n3(:,3964), t3x256(:,:,2332))
  call heltable([16,16,256], n3(:,3965), t3x256(:,:,2333))
  call heltable([16,16,256], n3(:,3966), t3x256(:,:,2334))
  call heltable([16,16,256], n3(:,3967), t3x256(:,:,2335))
  call heltable([16,16,256], n3(:,3968), t3x256(:,:,2336))
  call heltable([16,16,256], n3(:,3969), t3x256(:,:,2337))
  call heltable([16,16,256], n3(:,3970), t3x256(:,:,2338))
  call heltable([16,16,256], n3(:,3971), t3x256(:,:,2339))
  call heltable([16,16,256], n3(:,3972), t3x256(:,:,2340))
  call heltable([8,32,256], n3(:,3973), t3x256(:,:,2341))
  call heltable([8,32,256], n3(:,3974), t3x256(:,:,2342))
  call heltable([16,16,256], n3(:,3975), t3x256(:,:,2343))
  call heltable([16,16,256], n3(:,3976), t3x256(:,:,2344))
  call heltable([16,16,256], n3(:,3977), t3x256(:,:,2345))
  call heltable([16,16,256], n3(:,3978), t3x256(:,:,2346))
  call heltable([8,32,256], n3(:,3979), t3x256(:,:,2347))
  call heltable([8,32,256], n3(:,3980), t3x256(:,:,2348))
  call heltable([16,16,256], n3(:,3981), t3x256(:,:,2349))
  call heltable([16,16,256], n3(:,3982), t3x256(:,:,2350))
  call heltable([16,16,256], n3(:,3983), t3x256(:,:,2351))
  call heltable([16,16,256], n3(:,3984), t3x256(:,:,2352))
  call heltable([8,32,256], n3(:,3985), t3x256(:,:,2353))
  call heltable([8,32,256], n3(:,3986), t3x256(:,:,2354))
  call heltable([8,32,256], n3(:,3987), t3x256(:,:,2355))
  call heltable([32,8,256], n3(:,3988), t3x256(:,:,2356))
  call heltable([8,32,256], n3(:,3989), t3x256(:,:,2357))
  call heltable([8,32,256], n3(:,3990), t3x256(:,:,2358))
  call heltable([16,16,256], n3(:,3991), t3x256(:,:,2359))
  call heltable([16,16,256], n3(:,3992), t3x256(:,:,2360))
  call heltable([16,16,256], n3(:,3993), t3x256(:,:,2361))
  call heltable([16,16,256], n3(:,3994), t3x256(:,:,2362))
  call heltable([16,16,256], n3(:,3995), t3x256(:,:,2363))
  call heltable([16,16,256], n3(:,3996), t3x256(:,:,2364))
  call heltable([16,16,256], n3(:,3997), t3x256(:,:,2365))
  call heltable([16,16,256], n3(:,3998), t3x256(:,:,2366))
  call heltable([8,32,256], n3(:,3999), t3x256(:,:,2367))
  call heltable([8,32,256], n3(:,4000), t3x256(:,:,2368))
  call heltable([8,32,256], n3(:,4001), t3x256(:,:,2369))
  call heltable([32,8,256], n3(:,4002), t3x256(:,:,2370))
  call heltable([8,32,256], n3(:,4003), t3x256(:,:,2371))
  call heltable([8,32,256], n3(:,4004), t3x256(:,:,2372))
  call heltable([16,16,256], n3(:,4005), t3x256(:,:,2373))
  call heltable([16,16,256], n3(:,4006), t3x256(:,:,2374))
  call heltable([16,16,256], n3(:,4007), t3x256(:,:,2375))
  call heltable([16,16,256], n3(:,4008), t3x256(:,:,2376))
  call heltable([16,16,256], n3(:,4009), t3x256(:,:,2377))
  call heltable([16,16,256], n3(:,4010), t3x256(:,:,2378))
  call heltable([16,16,256], n3(:,4011), t3x256(:,:,2379))
  call heltable([16,16,256], n3(:,4012), t3x256(:,:,2380))
  call heltable([8,32,256], n3(:,4013), t3x256(:,:,2381))
  call heltable([16,16,256], n3(:,4014), t3x256(:,:,2382))
  call heltable([16,16,256], n3(:,4015), t3x256(:,:,2383))
  call heltable([16,16,256], n3(:,4016), t3x256(:,:,2384))
  call heltable([16,16,256], n3(:,4017), t3x256(:,:,2385))
  call heltable([8,32,256], n3(:,4018), t3x256(:,:,2386))
  call heltable([16,16,256], n3(:,4019), t3x256(:,:,2387))
  call heltable([16,16,256], n3(:,4020), t3x256(:,:,2388))
  call heltable([16,16,256], n3(:,4021), t3x256(:,:,2389))
  call heltable([16,16,256], n3(:,4022), t3x256(:,:,2390))
  call heltable([16,16,256], n3(:,4023), t3x256(:,:,2391))
  call heltable([16,16,256], n3(:,4024), t3x256(:,:,2392))
  call heltable([16,16,256], n3(:,4025), t3x256(:,:,2393))
  call heltable([16,16,256], n3(:,4026), t3x256(:,:,2394))
  call heltable([16,16,256], n3(:,4027), t3x256(:,:,2395))
  call heltable([16,16,256], n3(:,4028), t3x256(:,:,2396))
  call heltable([16,16,256], n3(:,4029), t3x256(:,:,2397))
  call heltable([16,16,256], n3(:,4030), t3x256(:,:,2398))
  call heltable([8,32,256], n3(:,4031), t3x256(:,:,2399))
  call heltable([8,32,256], n3(:,4032), t3x256(:,:,2400))
  call heltable([8,32,256], n3(:,4033), t3x256(:,:,2401))
  call heltable([8,32,256], n3(:,4034), t3x256(:,:,2402))
  call heltable([32,8,256], n3(:,4035), t3x256(:,:,2403))
  call heltable([32,8,256], n3(:,4036), t3x256(:,:,2404))
  call heltable([32,8,256], n3(:,4037), t3x256(:,:,2405))
  call heltable([32,8,256], n3(:,4038), t3x256(:,:,2406))
  call heltable([8,32,256], n3(:,4039), t3x256(:,:,2407))
  call heltable([8,32,256], n3(:,4040), t3x256(:,:,2408))
  call heltable([8,32,256], n3(:,4041), t3x256(:,:,2409))
  call heltable([8,32,256], n3(:,4042), t3x256(:,:,2410))
  call heltable([32,8,256], n3(:,4043), t3x256(:,:,2411))
  call heltable([32,8,256], n3(:,4044), t3x256(:,:,2412))
  call heltable([32,8,256], n3(:,4045), t3x256(:,:,2413))
  call heltable([32,8,256], n3(:,4046), t3x256(:,:,2414))
  call heltable([8,32,256], n3(:,4047), t3x256(:,:,2415))
  call heltable([8,32,256], n3(:,4048), t3x256(:,:,2416))
  call heltable([8,32,256], n3(:,4049), t3x256(:,:,2417))
  call heltable([8,32,256], n3(:,4050), t3x256(:,:,2418))
  call heltable([16,16,256], n3(:,4051), t3x256(:,:,2419))
  call heltable([16,16,256], n3(:,4052), t3x256(:,:,2420))
  call heltable([16,16,256], n3(:,4053), t3x256(:,:,2421))
  call heltable([16,16,256], n3(:,4054), t3x256(:,:,2422))
  call heltable([16,16,256], n3(:,4055), t3x256(:,:,2423))
  call heltable([16,16,256], n3(:,4056), t3x256(:,:,2424))
  call heltable([16,16,256], n3(:,4057), t3x256(:,:,2425))
  call heltable([16,16,256], n3(:,4058), t3x256(:,:,2426))
  call heltable([8,32,256], n3(:,4059), t3x256(:,:,2427))
  call heltable([8,32,256], n3(:,4060), t3x256(:,:,2428))
  call heltable([16,16,256], n3(:,4061), t3x256(:,:,2429))
  call heltable([16,16,256], n3(:,4062), t3x256(:,:,2430))
  call heltable([16,16,256], n3(:,4063), t3x256(:,:,2431))
  call heltable([16,16,256], n3(:,4064), t3x256(:,:,2432))
  call heltable([8,32,256], n3(:,4065), t3x256(:,:,2433))
  call heltable([8,32,256], n3(:,4066), t3x256(:,:,2434))
  call heltable([16,16,256], n3(:,4067), t3x256(:,:,2435))
  call heltable([16,16,256], n3(:,4068), t3x256(:,:,2436))
  call heltable([16,16,256], n3(:,4069), t3x256(:,:,2437))
  call heltable([16,16,256], n3(:,4070), t3x256(:,:,2438))
  call heltable([8,32,256], n3(:,4071), t3x256(:,:,2439))
  call heltable([8,32,256], n3(:,4072), t3x256(:,:,2440))
  call heltable([8,32,256], n3(:,4073), t3x256(:,:,2441))
  call heltable([32,8,256], n3(:,4074), t3x256(:,:,2442))
  call heltable([8,32,256], n3(:,4075), t3x256(:,:,2443))
  call heltable([8,32,256], n3(:,4076), t3x256(:,:,2444))
  call heltable([16,16,256], n3(:,4077), t3x256(:,:,2445))
  call heltable([16,16,256], n3(:,4078), t3x256(:,:,2446))
  call heltable([16,16,256], n3(:,4079), t3x256(:,:,2447))
  call heltable([16,16,256], n3(:,4080), t3x256(:,:,2448))
  call heltable([16,16,256], n3(:,4081), t3x256(:,:,2449))
  call heltable([16,16,256], n3(:,4082), t3x256(:,:,2450))
  call heltable([16,16,256], n3(:,4083), t3x256(:,:,2451))
  call heltable([16,16,256], n3(:,4084), t3x256(:,:,2452))
  call heltable([8,32,256], n3(:,4085), t3x256(:,:,2453))
  call heltable([8,32,256], n3(:,4086), t3x256(:,:,2454))
  call heltable([8,32,256], n3(:,4087), t3x256(:,:,2455))
  call heltable([32,8,256], n3(:,4088), t3x256(:,:,2456))
  call heltable([8,32,256], n3(:,4089), t3x256(:,:,2457))
  call heltable([8,32,256], n3(:,4090), t3x256(:,:,2458))
  call heltable([16,16,256], n3(:,4091), t3x256(:,:,2459))
  call heltable([16,16,256], n3(:,4092), t3x256(:,:,2460))
  call heltable([16,16,256], n3(:,4093), t3x256(:,:,2461))
  call heltable([16,16,256], n3(:,4094), t3x256(:,:,2462))
  call heltable([16,16,256], n3(:,4095), t3x256(:,:,2463))
  call heltable([16,16,256], n3(:,4096), t3x256(:,:,2464))
  call heltable([16,16,256], n3(:,4097), t3x256(:,:,2465))
  call heltable([16,16,256], n3(:,4098), t3x256(:,:,2466))
  call heltable([8,32,256], n3(:,4099), t3x256(:,:,2467))
  call heltable([8,32,256], n3(:,4100), t3x256(:,:,2468))
  call heltable([8,32,256], n3(:,4101), t3x256(:,:,2469))
  call heltable([8,32,256], n3(:,4102), t3x256(:,:,2470))
  call heltable([8,32,256], n3(:,4103), t3x256(:,:,2471))
  call heltable([8,32,256], n3(:,4104), t3x256(:,:,2472))
  call heltable([8,32,256], n3(:,4105), t3x256(:,:,2473))
  call heltable([8,32,256], n3(:,4106), t3x256(:,:,2474))
  call heltable([8,32,256], n3(:,4107), t3x256(:,:,2475))
  call heltable([8,32,256], n3(:,4108), t3x256(:,:,2476))
  call heltable([8,32,256], n3(:,4109), t3x256(:,:,2477))
  call heltable([8,32,256], n3(:,4110), t3x256(:,:,2478))
  call heltable([8,32,256], n3(:,4111), t3x256(:,:,2479))
  call heltable([8,32,256], n3(:,4112), t3x256(:,:,2480))
  call heltable([8,32,256], n3(:,4113), t3x256(:,:,2481))
  call heltable([8,32,256], n3(:,4114), t3x256(:,:,2482))
  call heltable([8,32,256], n3(:,4115), t3x256(:,:,2483))
  call heltable([8,32,256], n3(:,4116), t3x256(:,:,2484))
  call heltable([8,32,256], n3(:,4117), t3x256(:,:,2485))
  call heltable([8,32,256], n3(:,4118), t3x256(:,:,2486))
  call heltable([16,16,256], n3(:,4119), t3x256(:,:,2487))
  call heltable([16,16,256], n3(:,4120), t3x256(:,:,2488))
  call heltable([16,16,256], n3(:,4121), t3x256(:,:,2489))
  call heltable([16,16,256], n3(:,4122), t3x256(:,:,2490))
  call heltable([16,16,256], n3(:,4123), t3x256(:,:,2491))
  call heltable([16,16,256], n3(:,4124), t3x256(:,:,2492))
  call heltable([16,16,256], n3(:,4125), t3x256(:,:,2493))
  call heltable([16,16,256], n3(:,4126), t3x256(:,:,2494))
  call heltable([8,32,256], n3(:,4127), t3x256(:,:,2495))
  call heltable([16,16,256], n3(:,4128), t3x256(:,:,2496))
  call heltable([16,16,256], n3(:,4129), t3x256(:,:,2497))
  call heltable([16,16,256], n3(:,4130), t3x256(:,:,2498))
  call heltable([16,16,256], n3(:,4131), t3x256(:,:,2499))
  call heltable([8,32,256], n3(:,4132), t3x256(:,:,2500))
  call heltable([16,16,256], n3(:,4133), t3x256(:,:,2501))
  call heltable([16,16,256], n3(:,4134), t3x256(:,:,2502))
  call heltable([16,16,256], n3(:,4135), t3x256(:,:,2503))
  call heltable([16,16,256], n3(:,4136), t3x256(:,:,2504))
  call heltable([16,16,256], n3(:,4137), t3x256(:,:,2505))
  call heltable([16,16,256], n3(:,4138), t3x256(:,:,2506))
  call heltable([16,16,256], n3(:,4139), t3x256(:,:,2507))
  call heltable([16,16,256], n3(:,4140), t3x256(:,:,2508))
  call heltable([16,16,256], n3(:,4141), t3x256(:,:,2509))
  call heltable([16,16,256], n3(:,4142), t3x256(:,:,2510))
  call heltable([16,16,256], n3(:,4143), t3x256(:,:,2511))
  call heltable([16,16,256], n3(:,4144), t3x256(:,:,2512))
  call heltable([8,32,256], n3(:,4145), t3x256(:,:,2513))
  call heltable([8,32,256], n3(:,4146), t3x256(:,:,2514))
  call heltable([16,16,256], n3(:,4147), t3x256(:,:,2515))
  call heltable([16,16,256], n3(:,4148), t3x256(:,:,2516))
  call heltable([16,16,256], n3(:,4149), t3x256(:,:,2517))
  call heltable([16,16,256], n3(:,4150), t3x256(:,:,2518))
  call heltable([8,32,256], n3(:,4151), t3x256(:,:,2519))
  call heltable([8,32,256], n3(:,4152), t3x256(:,:,2520))
  call heltable([16,16,256], n3(:,4153), t3x256(:,:,2521))
  call heltable([16,16,256], n3(:,4154), t3x256(:,:,2522))
  call heltable([16,16,256], n3(:,4155), t3x256(:,:,2523))
  call heltable([16,16,256], n3(:,4156), t3x256(:,:,2524))
  call heltable([16,16,256], n3(:,4157), t3x256(:,:,2525))
  call heltable([16,16,256], n3(:,4158), t3x256(:,:,2526))
  call heltable([16,16,256], n3(:,4159), t3x256(:,:,2527))
  call heltable([16,16,256], n3(:,4160), t3x256(:,:,2528))
  call heltable([16,16,256], n3(:,4161), t3x256(:,:,2529))
  call heltable([16,16,256], n3(:,4162), t3x256(:,:,2530))
  call heltable([16,16,256], n3(:,4163), t3x256(:,:,2531))
  call heltable([16,16,256], n3(:,4164), t3x256(:,:,2532))
  call heltable([16,16,256], n3(:,4165), t3x256(:,:,2533))
  call heltable([16,16,256], n3(:,4166), t3x256(:,:,2534))
  call heltable([16,16,256], n3(:,4167), t3x256(:,:,2535))
  call heltable([16,16,256], n3(:,4168), t3x256(:,:,2536))
  call heltable([16,16,256], n3(:,4169), t3x256(:,:,2537))
  call heltable([16,16,256], n3(:,4170), t3x256(:,:,2538))
  call heltable([16,16,256], n3(:,4171), t3x256(:,:,2539))
  call heltable([16,16,256], n3(:,4172), t3x256(:,:,2540))
  call heltable([16,16,256], n3(:,4173), t3x256(:,:,2541))
  call heltable([16,16,256], n3(:,4174), t3x256(:,:,2542))
  call heltable([8,32,256], n3(:,4175), t3x256(:,:,2543))
  call heltable([8,32,256], n3(:,4176), t3x256(:,:,2544))
  call heltable([8,32,256], n3(:,4177), t3x256(:,:,2545))
  call heltable([8,32,256], n3(:,4178), t3x256(:,:,2546))
  call heltable([8,32,256], n3(:,4179), t3x256(:,:,2547))
  call heltable([8,32,256], n3(:,4180), t3x256(:,:,2548))
  call heltable([16,16,256], n3(:,4181), t3x256(:,:,2549))
  call heltable([16,16,256], n3(:,4182), t3x256(:,:,2550))
  call heltable([16,16,256], n3(:,4183), t3x256(:,:,2551))
  call heltable([16,16,256], n3(:,4184), t3x256(:,:,2552))
  call heltable([16,16,256], n3(:,4185), t3x256(:,:,2553))
  call heltable([16,16,256], n3(:,4186), t3x256(:,:,2554))
  call heltable([8,32,256], n3(:,4187), t3x256(:,:,2555))
  call heltable([8,32,256], n3(:,4188), t3x256(:,:,2556))
  call heltable([8,32,256], n3(:,4189), t3x256(:,:,2557))
  call heltable([8,32,256], n3(:,4190), t3x256(:,:,2558))
  call heltable([8,32,256], n3(:,4191), t3x256(:,:,2559))
  call heltable([8,32,256], n3(:,4192), t3x256(:,:,2560))
  call heltable([8,32,256], n3(:,4193), t3x256(:,:,2561))
  call heltable([8,32,256], n3(:,4194), t3x256(:,:,2562))
  call heltable([8,32,256], n3(:,4195), t3x256(:,:,2563))
  call heltable([8,32,256], n3(:,4196), t3x256(:,:,2564))
  call heltable([8,32,256], n3(:,4197), t3x256(:,:,2565))
  call heltable([8,32,256], n3(:,4198), t3x256(:,:,2566))
  call heltable([8,32,256], n3(:,4199), t3x256(:,:,2567))
  call heltable([8,32,256], n3(:,4200), t3x256(:,:,2568))
  call heltable([8,32,256], n3(:,4201), t3x256(:,:,2569))
  call heltable([8,32,256], n3(:,4202), t3x256(:,:,2570))
  call heltable([8,32,256], n3(:,4203), t3x256(:,:,2571))
  call heltable([8,32,256], n3(:,4204), t3x256(:,:,2572))
  call heltable([16,16,256], n3(:,4205), t3x256(:,:,2573))
  call heltable([16,16,256], n3(:,4206), t3x256(:,:,2574))
  call heltable([16,16,256], n3(:,4207), t3x256(:,:,2575))
  call heltable([16,16,256], n3(:,4208), t3x256(:,:,2576))
  call heltable([16,16,256], n3(:,4209), t3x256(:,:,2577))
  call heltable([16,16,256], n3(:,4210), t3x256(:,:,2578))
  call heltable([16,16,256], n3(:,4211), t3x256(:,:,2579))
  call heltable([16,16,256], n3(:,4212), t3x256(:,:,2580))
  call heltable([16,16,256], n3(:,4213), t3x256(:,:,2581))
  call heltable([16,16,256], n3(:,4214), t3x256(:,:,2582))
  call heltable([16,16,256], n3(:,4215), t3x256(:,:,2583))
  call heltable([16,16,256], n3(:,4216), t3x256(:,:,2584))
  call heltable([16,16,256], n3(:,4217), t3x256(:,:,2585))
  call heltable([16,16,256], n3(:,4218), t3x256(:,:,2586))
  call heltable([16,16,256], n3(:,4219), t3x256(:,:,2587))
  call heltable([16,16,256], n3(:,4220), t3x256(:,:,2588))
  call heltable([16,16,256], n3(:,4221), t3x256(:,:,2589))
  call heltable([16,16,256], n3(:,4222), t3x256(:,:,2590))
  call heltable([8,32,256], n3(:,4223), t3x256(:,:,2591))
  call heltable([8,32,256], n3(:,4224), t3x256(:,:,2592))
  call heltable([8,32,256], n3(:,4225), t3x256(:,:,2593))
  call heltable([8,32,256], n3(:,4226), t3x256(:,:,2594))
  call heltable([8,32,256], n3(:,4227), t3x256(:,:,2595))
  call heltable([8,32,256], n3(:,4228), t3x256(:,:,2596))
  call heltable([16,16,256], n3(:,4229), t3x256(:,:,2597))
  call heltable([16,16,256], n3(:,4230), t3x256(:,:,2598))
  call heltable([16,16,256], n3(:,4231), t3x256(:,:,2599))
  call heltable([16,16,256], n3(:,4232), t3x256(:,:,2600))
  call heltable([16,16,256], n3(:,4233), t3x256(:,:,2601))
  call heltable([16,16,256], n3(:,4234), t3x256(:,:,2602))
  call heltable([8,32,256], n3(:,4235), t3x256(:,:,2603))
  call heltable([8,32,256], n3(:,4236), t3x256(:,:,2604))
  call heltable([8,32,256], n3(:,4237), t3x256(:,:,2605))
  call heltable([8,32,256], n3(:,4238), t3x256(:,:,2606))
  call heltable([8,32,256], n3(:,4239), t3x256(:,:,2607))
  call heltable([8,32,256], n3(:,4240), t3x256(:,:,2608))
  call heltable([8,32,256], n3(:,4241), t3x256(:,:,2609))
  call heltable([8,32,256], n3(:,4242), t3x256(:,:,2610))
  call heltable([8,32,256], n3(:,4243), t3x256(:,:,2611))
  call heltable([8,32,256], n3(:,4244), t3x256(:,:,2612))
  call heltable([8,32,256], n3(:,4245), t3x256(:,:,2613))
  call heltable([8,32,256], n3(:,4246), t3x256(:,:,2614))
  call heltable([8,32,256], n3(:,4247), t3x256(:,:,2615))
  call heltable([8,32,256], n3(:,4248), t3x256(:,:,2616))
  call heltable([8,32,256], n3(:,4249), t3x256(:,:,2617))
  call heltable([8,32,256], n3(:,4250), t3x256(:,:,2618))
  call heltable([8,32,256], n3(:,4251), t3x256(:,:,2619))
  call heltable([8,32,256], n3(:,4252), t3x256(:,:,2620))
  call heltable([16,16,256], n3(:,4253), t3x256(:,:,2621))
  call heltable([16,16,256], n3(:,4254), t3x256(:,:,2622))
  call heltable([16,16,256], n3(:,4255), t3x256(:,:,2623))
  call heltable([16,16,256], n3(:,4256), t3x256(:,:,2624))
  call heltable([16,16,256], n3(:,4257), t3x256(:,:,2625))
  call heltable([16,16,256], n3(:,4258), t3x256(:,:,2626))
  call heltable([16,16,256], n3(:,4259), t3x256(:,:,2627))
  call heltable([16,16,256], n3(:,4260), t3x256(:,:,2628))
  call heltable([16,16,256], n3(:,4261), t3x256(:,:,2629))
  call heltable([16,16,256], n3(:,4262), t3x256(:,:,2630))
  call heltable([16,16,256], n3(:,4263), t3x256(:,:,2631))
  call heltable([16,16,256], n3(:,4264), t3x256(:,:,2632))
  call heltable([16,16,256], n3(:,4265), t3x256(:,:,2633))
  call heltable([16,16,256], n3(:,4266), t3x256(:,:,2634))
  call heltable([16,16,256], n3(:,4267), t3x256(:,:,2635))
  call heltable([16,16,256], n3(:,4268), t3x256(:,:,2636))
  call heltable([16,16,256], n3(:,4269), t3x256(:,:,2637))
  call heltable([16,16,256], n3(:,4270), t3x256(:,:,2638))
  call heltable([16,16,256], n3(:,4271), t3x256(:,:,2639))
  call heltable([16,16,256], n3(:,4272), t3x256(:,:,2640))
  call heltable([16,16,256], n3(:,4273), t3x256(:,:,2641))
  call heltable([16,16,256], n3(:,4274), t3x256(:,:,2642))
  call heltable([16,16,256], n3(:,4275), t3x256(:,:,2643))
  call heltable([16,16,256], n3(:,4276), t3x256(:,:,2644))
  call heltable([16,16,256], n3(:,4277), t3x256(:,:,2645))
  call heltable([16,16,256], n3(:,4278), t3x256(:,:,2646))
  call heltable([16,16,256], n3(:,4279), t3x256(:,:,2647))
  call heltable([16,16,256], n3(:,4280), t3x256(:,:,2648))
  call heltable([16,16,256], n3(:,4281), t3x256(:,:,2649))
  call heltable([16,16,256], n3(:,4282), t3x256(:,:,2650))
  call heltable([16,16,256], n3(:,4283), t3x256(:,:,2651))
  call heltable([16,16,256], n3(:,4284), t3x256(:,:,2652))
  call heltable([16,16,256], n3(:,4285), t3x256(:,:,2653))
  call heltable([16,16,256], n3(:,4286), t3x256(:,:,2654))
  call heltable([16,16,256], n3(:,4287), t3x256(:,:,2655))
  call heltable([16,16,256], n3(:,4288), t3x256(:,:,2656))
  call heltable([16,16,256], n3(:,4289), t3x256(:,:,2657))
  call heltable([16,16,256], n3(:,4290), t3x256(:,:,2658))
  call heltable([16,16,256], n3(:,4291), t3x256(:,:,2659))
  call heltable([16,16,256], n3(:,4292), t3x256(:,:,2660))
  call heltable([16,16,256], n3(:,4293), t3x256(:,:,2661))
  call heltable([16,16,256], n3(:,4294), t3x256(:,:,2662))
  call heltable([16,16,256], n3(:,4295), t3x256(:,:,2663))
  call heltable([16,16,256], n3(:,4296), t3x256(:,:,2664))
  call heltable([16,16,256], n3(:,4297), t3x256(:,:,2665))
  call heltable([16,16,256], n3(:,4298), t3x256(:,:,2666))
  call heltable([16,16,256], n3(:,4299), t3x256(:,:,2667))
  call heltable([16,16,256], n3(:,4300), t3x256(:,:,2668))
  call heltable([16,16,256], n3(:,4301), t3x256(:,:,2669))
  call heltable([16,16,256], n3(:,4302), t3x256(:,:,2670))
  call heltable([16,16,256], n3(:,4303), t3x256(:,:,2671))
  call heltable([16,16,256], n3(:,4304), t3x256(:,:,2672))
  call heltable([16,16,256], n3(:,4305), t3x256(:,:,2673))
  call heltable([16,16,256], n3(:,4306), t3x256(:,:,2674))
  call heltable([16,16,256], n3(:,4307), t3x256(:,:,2675))
  call heltable([16,16,256], n3(:,4308), t3x256(:,:,2676))
  call heltable([16,16,256], n3(:,4309), t3x256(:,:,2677))
  call heltable([16,16,256], n3(:,4310), t3x256(:,:,2678))
  call heltable([16,16,256], n3(:,4311), t3x256(:,:,2679))
  call heltable([16,16,256], n3(:,4312), t3x256(:,:,2680))
  call heltable([16,16,256], n3(:,4313), t3x256(:,:,2681))
  call heltable([16,16,256], n3(:,4314), t3x256(:,:,2682))
  call heltable([16,16,256], n3(:,4315), t3x256(:,:,2683))
  call heltable([16,16,256], n3(:,4316), t3x256(:,:,2684))
  call heltable([16,16,256], n3(:,4317), t3x256(:,:,2685))
  call heltable([16,16,256], n3(:,4318), t3x256(:,:,2686))
  call heltable([16,16,256], n3(:,4319), t3x256(:,:,2687))
  call heltable([16,16,256], n3(:,4320), t3x256(:,:,2688))
  call heltable([16,16,256], n3(:,4321), t3x256(:,:,2689))
  call heltable([16,16,256], n3(:,4322), t3x256(:,:,2690))
  call heltable([16,16,256], n3(:,4323), t3x256(:,:,2691))
  call heltable([16,16,256], n3(:,4324), t3x256(:,:,2692))
  call heltable([16,16,256], n3(:,4325), t3x256(:,:,2693))
  call heltable([16,16,256], n3(:,4326), t3x256(:,:,2694))
  call heltable([16,16,256], n3(:,4327), t3x256(:,:,2695))
  call heltable([16,16,256], n3(:,4328), t3x256(:,:,2696))
  call heltable([16,16,256], n3(:,4329), t3x256(:,:,2697))
  call heltable([16,16,256], n3(:,4330), t3x256(:,:,2698))
  call heltable([16,16,256], n3(:,4331), t3x256(:,:,2699))
  call heltable([16,16,256], n3(:,4332), t3x256(:,:,2700))
  call heltable([16,16,256], n3(:,4333), t3x256(:,:,2701))
  call heltable([16,16,256], n3(:,4334), t3x256(:,:,2702))
  call heltable([16,16,256], n3(:,4335), t3x256(:,:,2703))
  call heltable([16,16,256], n3(:,4336), t3x256(:,:,2704))
  call heltable([16,16,256], n3(:,4337), t3x256(:,:,2705))
  call heltable([16,16,256], n3(:,4338), t3x256(:,:,2706))
  call heltable([16,16,256], n3(:,4339), t3x256(:,:,2707))
  call heltable([16,16,256], n3(:,4340), t3x256(:,:,2708))
  call heltable([16,16,256], n3(:,4341), t3x256(:,:,2709))
  call heltable([16,16,256], n3(:,4342), t3x256(:,:,2710))
  call heltable([16,16,256], n3(:,4343), t3x256(:,:,2711))
  call heltable([16,16,256], n3(:,4344), t3x256(:,:,2712))
  call heltable([16,16,256], n3(:,4345), t3x256(:,:,2713))
  call heltable([16,16,256], n3(:,4346), t3x256(:,:,2714))
  call heltable([16,16,256], n3(:,4347), t3x256(:,:,2715))
  call heltable([16,16,256], n3(:,4348), t3x256(:,:,2716))
  call heltable([16,16,256], n3(:,4349), t3x256(:,:,2717))
  call heltable([16,16,256], n3(:,4350), t3x256(:,:,2718))
  call heltable([16,16,256], n3(:,4351), t3x256(:,:,2719))
  call heltable([16,16,256], n3(:,4352), t3x256(:,:,2720))
  call heltable([16,16,256], n3(:,4353), t3x256(:,:,2721))
  call heltable([16,16,256], n3(:,4354), t3x256(:,:,2722))
  call heltable([16,16,256], n3(:,4355), t3x256(:,:,2723))
  call heltable([16,16,256], n3(:,4356), t3x256(:,:,2724))
  call heltable([16,16,256], n3(:,4357), t3x256(:,:,2725))
  call heltable([16,16,256], n3(:,4358), t3x256(:,:,2726))
  call heltable([16,16,256], n3(:,4359), t3x256(:,:,2727))
  call heltable([16,16,256], n3(:,4360), t3x256(:,:,2728))
  call heltable([16,16,256], n3(:,4361), t3x256(:,:,2729))
  call heltable([16,16,256], n3(:,4362), t3x256(:,:,2730))
  call heltable([16,16,256], n3(:,4363), t3x256(:,:,2731))
  call heltable([16,16,256], n3(:,4364), t3x256(:,:,2732))
  call heltable([16,16,256], n3(:,4365), t3x256(:,:,2733))
  call heltable([16,16,256], n3(:,4366), t3x256(:,:,2734))
  call heltable([16,16,256], n3(:,4367), t3x256(:,:,2735))
  call heltable([16,16,256], n3(:,4368), t3x256(:,:,2736))
  call heltable([16,16,256], n3(:,4369), t3x256(:,:,2737))
  call heltable([16,16,256], n3(:,4370), t3x256(:,:,2738))
  call heltable([16,16,256], n3(:,4371), t3x256(:,:,2739))
  call heltable([16,16,256], n3(:,4372), t3x256(:,:,2740))
  call heltable([16,16,256], n3(:,4373), t3x256(:,:,2741))
  call heltable([16,16,256], n3(:,4374), t3x256(:,:,2742))
  call heltable([16,16,256], n3(:,4375), t3x256(:,:,2743))
  call heltable([16,16,256], n3(:,4376), t3x256(:,:,2744))
  call heltable([16,16,256], n3(:,4377), t3x256(:,:,2745))
  call heltable([16,16,256], n3(:,4378), t3x256(:,:,2746))
  call heltable([16,16,256], n3(:,4379), t3x256(:,:,2747))
  call heltable([16,16,256], n3(:,4380), t3x256(:,:,2748))
  call heltable([16,16,256], n3(:,4381), t3x256(:,:,2749))
  call heltable([16,16,256], n3(:,4382), t3x256(:,:,2750))
  call heltable([16,16,256], n3(:,4383), t3x256(:,:,2751))
  call heltable([16,16,256], n3(:,4384), t3x256(:,:,2752))
  call heltable([16,16,256], n3(:,4385), t3x256(:,:,2753))
  call heltable([16,16,256], n3(:,4386), t3x256(:,:,2754))
  call heltable([16,16,256], n3(:,4387), t3x256(:,:,2755))
  call heltable([16,16,256], n3(:,4388), t3x256(:,:,2756))
  call heltable([16,16,256], n3(:,4389), t3x256(:,:,2757))
  call heltable([16,16,256], n3(:,4390), t3x256(:,:,2758))
  call heltable([16,16,256], n3(:,4391), t3x256(:,:,2759))
  call heltable([16,16,256], n3(:,4392), t3x256(:,:,2760))
  call heltable([16,16,256], n3(:,4393), t3x256(:,:,2761))
  call heltable([16,16,256], n3(:,4394), t3x256(:,:,2762))
  call heltable([16,16,256], n3(:,4395), t3x256(:,:,2763))
  call heltable([16,16,256], n3(:,4396), t3x256(:,:,2764))
  call heltable([16,16,256], n3(:,4397), t3x256(:,:,2765))
  call heltable([16,16,256], n3(:,4398), t3x256(:,:,2766))
  call heltable([16,16,256], n3(:,4399), t3x256(:,:,2767))
  call heltable([16,16,256], n3(:,4400), t3x256(:,:,2768))
  call heltable([16,16,256], n3(:,4401), t3x256(:,:,2769))
  call heltable([16,16,256], n3(:,4402), t3x256(:,:,2770))
  call heltable([16,16,256], n3(:,4403), t3x256(:,:,2771))
  call heltable([16,16,256], n3(:,4404), t3x256(:,:,2772))
  call heltable([16,16,256], n3(:,4405), t3x256(:,:,2773))
  call heltable([16,16,256], n3(:,4406), t3x256(:,:,2774))
  call heltable([16,16,256], n3(:,4407), t3x256(:,:,2775))
  call heltable([16,16,256], n3(:,4408), t3x256(:,:,2776))
  call heltable([16,16,256], n3(:,4409), t3x256(:,:,2777))
  call heltable([16,16,256], n3(:,4410), t3x256(:,:,2778))
  call heltable([16,16,256], n3(:,4411), t3x256(:,:,2779))
  call heltable([16,16,256], n3(:,4412), t3x256(:,:,2780))
  call heltable([16,16,256], n3(:,4413), t3x256(:,:,2781))
  call heltable([16,16,256], n3(:,4414), t3x256(:,:,2782))
  call heltable([16,16,256], n3(:,4415), t3x256(:,:,2783))
  call heltable([16,16,256], n3(:,4416), t3x256(:,:,2784))
  call heltable([16,16,256], n3(:,4417), t3x256(:,:,2785))
  call heltable([16,16,256], n3(:,4418), t3x256(:,:,2786))
  call heltable([16,16,256], n3(:,4419), t3x256(:,:,2787))
  call heltable([16,16,256], n3(:,4420), t3x256(:,:,2788))
  call heltable([16,16,256], n3(:,4421), t3x256(:,:,2789))
  call heltable([16,16,256], n3(:,4422), t3x256(:,:,2790))
  call heltable([16,16,256], n3(:,4423), t3x256(:,:,2791))
  call heltable([16,16,256], n3(:,4424), t3x256(:,:,2792))
  call heltable([16,16,256], n3(:,4425), t3x256(:,:,2793))
  call heltable([16,16,256], n3(:,4426), t3x256(:,:,2794))
  call heltable([16,16,256], n3(:,4427), t3x256(:,:,2795))
  call heltable([16,16,256], n3(:,4428), t3x256(:,:,2796))
  call heltable([16,16,256], n3(:,4429), t3x256(:,:,2797))
  call heltable([16,16,256], n3(:,4430), t3x256(:,:,2798))
  call heltable([16,16,256], n3(:,4431), t3x256(:,:,2799))
  call heltable([16,16,256], n3(:,4432), t3x256(:,:,2800))
  call heltable([16,16,256], n3(:,4433), t3x256(:,:,2801))
  call heltable([16,16,256], n3(:,4434), t3x256(:,:,2802))
  call heltable([16,16,256], n3(:,4435), t3x256(:,:,2803))
  call heltable([16,16,256], n3(:,4436), t3x256(:,:,2804))
  call heltable([16,16,256], n3(:,4437), t3x256(:,:,2805))
  call heltable([16,16,256], n3(:,4438), t3x256(:,:,2806))
  call heltable([16,16,256], n3(:,4439), t3x256(:,:,2807))
  call heltable([16,16,256], n3(:,4440), t3x256(:,:,2808))
  call heltable([16,16,256], n3(:,4441), t3x256(:,:,2809))
  call heltable([16,16,256], n3(:,4442), t3x256(:,:,2810))
  call heltable([16,16,256], n3(:,4443), t3x256(:,:,2811))
  call heltable([16,16,256], n3(:,4444), t3x256(:,:,2812))
  call heltable([16,16,256], n3(:,4445), t3x256(:,:,2813))
  call heltable([16,16,256], n3(:,4446), t3x256(:,:,2814))
  call heltable([16,16,256], n3(:,4447), t3x256(:,:,2815))
  call heltable([16,16,256], n3(:,4448), t3x256(:,:,2816))
  call heltable([16,16,256], n3(:,4449), t3x256(:,:,2817))
  call heltable([16,16,256], n3(:,4450), t3x256(:,:,2818))
  call heltable([16,16,256], n3(:,4451), t3x256(:,:,2819))
  call heltable([16,16,256], n3(:,4452), t3x256(:,:,2820))
  call heltable([16,16,256], n3(:,4453), t3x256(:,:,2821))
  call heltable([16,16,256], n3(:,4454), t3x256(:,:,2822))
  call heltable([16,16,256], n3(:,4455), t3x256(:,:,2823))
  call heltable([16,16,256], n3(:,4456), t3x256(:,:,2824))
  call heltable([16,16,256], n3(:,4457), t3x256(:,:,2825))
  call heltable([16,16,256], n3(:,4458), t3x256(:,:,2826))
  call heltable([16,16,256], n3(:,4459), t3x256(:,:,2827))
  call heltable([16,16,256], n3(:,4460), t3x256(:,:,2828))
  call heltable([16,16,256], n3(:,4461), t3x256(:,:,2829))
  call heltable([16,16,256], n3(:,4462), t3x256(:,:,2830))
  call heltable([16,16,256], n3(:,4463), t3x256(:,:,2831))
  call heltable([16,16,256], n3(:,4464), t3x256(:,:,2832))
  call heltable([16,16,256], n3(:,4465), t3x256(:,:,2833))
  call heltable([16,16,256], n3(:,4466), t3x256(:,:,2834))
  call heltable([16,16,256], n3(:,4467), t3x256(:,:,2835))
  call heltable([16,16,256], n3(:,4468), t3x256(:,:,2836))
  call heltable([16,16,256], n3(:,4469), t3x256(:,:,2837))
  call heltable([16,16,256], n3(:,4470), t3x256(:,:,2838))
  call heltable([16,16,256], n3(:,4471), t3x256(:,:,2839))
  call heltable([16,16,256], n3(:,4472), t3x256(:,:,2840))
  call heltable([16,16,256], n3(:,4473), t3x256(:,:,2841))
  call heltable([16,16,256], n3(:,4474), t3x256(:,:,2842))
  call heltable([16,16,256], n3(:,4475), t3x256(:,:,2843))
  call heltable([16,16,256], n3(:,4476), t3x256(:,:,2844))
  call heltable([16,16,256], n3(:,4477), t3x256(:,:,2845))
  call heltable([16,16,256], n3(:,4478), t3x256(:,:,2846))
  call heltable([16,16,256], n3(:,4479), t3x256(:,:,2847))
  call heltable([16,16,256], n3(:,4480), t3x256(:,:,2848))
  call heltable([16,16,256], n3(:,4481), t3x256(:,:,2849))
  call heltable([16,16,256], n3(:,4482), t3x256(:,:,2850))
  call heltable([16,16,256], n3(:,4483), t3x256(:,:,2851))
  call heltable([16,16,256], n3(:,4484), t3x256(:,:,2852))
  call heltable([16,16,256], n3(:,4485), t3x256(:,:,2853))
  call heltable([16,16,256], n3(:,4486), t3x256(:,:,2854))
  call heltable([16,16,256], n3(:,4487), t3x256(:,:,2855))
  call heltable([16,16,256], n3(:,4488), t3x256(:,:,2856))
  call heltable([8,32,256], n3(:,4489), t3x256(:,:,2857))
  call heltable([8,32,256], n3(:,4490), t3x256(:,:,2858))
  call heltable([8,32,256], n3(:,4491), t3x256(:,:,2859))
  call heltable([8,32,256], n3(:,4492), t3x256(:,:,2860))
  call heltable([8,32,256], n3(:,4493), t3x256(:,:,2861))
  call heltable([8,32,256], n3(:,4494), t3x256(:,:,2862))
  call heltable([8,32,256], n3(:,4495), t3x256(:,:,2863))
  call heltable([8,32,256], n3(:,4496), t3x256(:,:,2864))
  call heltable([32,8,256], n3(:,4497), t3x256(:,:,2865))
  call heltable([32,8,256], n3(:,4498), t3x256(:,:,2866))
  call heltable([8,32,256], n3(:,4499), t3x256(:,:,2867))
  call heltable([32,8,256], n3(:,4500), t3x256(:,:,2868))
  call heltable([32,8,256], n3(:,4501), t3x256(:,:,2869))
  call heltable([8,32,256], n3(:,4502), t3x256(:,:,2870))
  call heltable([16,16,256], n3(:,4503), t3x256(:,:,2871))
  call heltable([16,16,256], n3(:,4504), t3x256(:,:,2872))
  call heltable([16,16,256], n3(:,4505), t3x256(:,:,2873))
  call heltable([16,16,256], n3(:,4506), t3x256(:,:,2874))
  call heltable([8,32,256], n3(:,4507), t3x256(:,:,2875))
  call heltable([8,32,256], n3(:,4508), t3x256(:,:,2876))
  call heltable([32,8,256], n3(:,4509), t3x256(:,:,2877))
  call heltable([32,8,256], n3(:,4510), t3x256(:,:,2878))
  call heltable([32,8,256], n3(:,4511), t3x256(:,:,2879))
  call heltable([32,8,256], n3(:,4512), t3x256(:,:,2880))
  call heltable([16,16,256], n3(:,4513), t3x256(:,:,2881))
  call heltable([16,16,256], n3(:,4514), t3x256(:,:,2882))
  call heltable([16,16,256], n3(:,4515), t3x256(:,:,2883))
  call heltable([16,16,256], n3(:,4516), t3x256(:,:,2884))
  call heltable([16,16,256], n3(:,4517), t3x256(:,:,2885))
  call heltable([16,16,256], n3(:,4518), t3x256(:,:,2886))
  call heltable([16,16,256], n3(:,4519), t3x256(:,:,2887))
  call heltable([16,16,256], n3(:,4520), t3x256(:,:,2888))
  call heltable([8,32,256], n3(:,4521), t3x256(:,:,2889))
  call heltable([8,32,256], n3(:,4522), t3x256(:,:,2890))
  call heltable([16,16,256], n3(:,4523), t3x256(:,:,2891))
  call heltable([16,16,256], n3(:,4524), t3x256(:,:,2892))
  call heltable([16,16,256], n3(:,4525), t3x256(:,:,2893))
  call heltable([16,16,256], n3(:,4526), t3x256(:,:,2894))
  call heltable([16,16,256], n3(:,4527), t3x256(:,:,2895))
  call heltable([16,16,256], n3(:,4528), t3x256(:,:,2896))
  call heltable([16,16,256], n3(:,4529), t3x256(:,:,2897))
  call heltable([16,16,256], n3(:,4530), t3x256(:,:,2898))
  call heltable([16,16,256], n3(:,4531), t3x256(:,:,2899))
  call heltable([16,16,256], n3(:,4532), t3x256(:,:,2900))
  call heltable([16,16,256], n3(:,4533), t3x256(:,:,2901))
  call heltable([16,16,256], n3(:,4534), t3x256(:,:,2902))
  call heltable([8,32,256], n3(:,4535), t3x256(:,:,2903))
  call heltable([8,32,256], n3(:,4536), t3x256(:,:,2904))
  call heltable([8,32,256], n3(:,4537), t3x256(:,:,2905))
  call heltable([8,32,256], n3(:,4538), t3x256(:,:,2906))
  call heltable([8,32,256], n3(:,4539), t3x256(:,:,2907))
  call heltable([8,32,256], n3(:,4540), t3x256(:,:,2908))
  call heltable([16,16,256], n3(:,4541), t3x256(:,:,2909))
  call heltable([16,16,256], n3(:,4542), t3x256(:,:,2910))
  call heltable([16,16,256], n3(:,4543), t3x256(:,:,2911))
  call heltable([16,16,256], n3(:,4544), t3x256(:,:,2912))
  call heltable([16,16,256], n3(:,4545), t3x256(:,:,2913))
  call heltable([16,16,256], n3(:,4546), t3x256(:,:,2914))
  call heltable([16,16,256], n3(:,4547), t3x256(:,:,2915))
  call heltable([16,16,256], n3(:,4548), t3x256(:,:,2916))
  call heltable([16,16,256], n3(:,4549), t3x256(:,:,2917))
  call heltable([16,16,256], n3(:,4550), t3x256(:,:,2918))
  call heltable([16,16,256], n3(:,4551), t3x256(:,:,2919))
  call heltable([16,16,256], n3(:,4552), t3x256(:,:,2920))
  call heltable([16,16,256], n3(:,4553), t3x256(:,:,2921))
  call heltable([16,16,256], n3(:,4554), t3x256(:,:,2922))
  call heltable([16,16,256], n3(:,4555), t3x256(:,:,2923))
  call heltable([16,16,256], n3(:,4556), t3x256(:,:,2924))
  call heltable([16,16,256], n3(:,4557), t3x256(:,:,2925))
  call heltable([16,16,256], n3(:,4558), t3x256(:,:,2926))
  call heltable([16,16,256], n3(:,4559), t3x256(:,:,2927))
  call heltable([16,16,256], n3(:,4560), t3x256(:,:,2928))
  call heltable([16,16,256], n3(:,4561), t3x256(:,:,2929))
  call heltable([16,16,256], n3(:,4562), t3x256(:,:,2930))
  call heltable([16,16,256], n3(:,4563), t3x256(:,:,2931))
  call heltable([16,16,256], n3(:,4564), t3x256(:,:,2932))
  call heltable([16,16,256], n3(:,4565), t3x256(:,:,2933))
  call heltable([16,16,256], n3(:,4566), t3x256(:,:,2934))
  call heltable([16,16,256], n3(:,4567), t3x256(:,:,2935))
  call heltable([16,16,256], n3(:,4568), t3x256(:,:,2936))
  call heltable([16,16,256], n3(:,4569), t3x256(:,:,2937))
  call heltable([16,16,256], n3(:,4570), t3x256(:,:,2938))
  call heltable([16,16,256], n3(:,4571), t3x256(:,:,2939))
  call heltable([16,16,256], n3(:,4572), t3x256(:,:,2940))
  call heltable([16,16,256], n3(:,4573), t3x256(:,:,2941))
  call heltable([16,16,256], n3(:,4574), t3x256(:,:,2942))
  call heltable([16,16,256], n3(:,4575), t3x256(:,:,2943))
  call heltable([16,16,256], n3(:,4576), t3x256(:,:,2944))
  call heltable([16,16,256], n3(:,4577), t3x256(:,:,2945))
  call heltable([16,16,256], n3(:,4578), t3x256(:,:,2946))
  call heltable([16,16,256], n3(:,4579), t3x256(:,:,2947))
  call heltable([16,16,256], n3(:,4580), t3x256(:,:,2948))
  call heltable([16,16,256], n3(:,4581), t3x256(:,:,2949))
  call heltable([16,16,256], n3(:,4582), t3x256(:,:,2950))
  call heltable([16,16,256], n3(:,4583), t3x256(:,:,2951))
  call heltable([16,16,256], n3(:,4584), t3x256(:,:,2952))
  call heltable([16,16,256], n3(:,4585), t3x256(:,:,2953))
  call heltable([16,16,256], n3(:,4586), t3x256(:,:,2954))
  call heltable([16,16,256], n3(:,4587), t3x256(:,:,2955))
  call heltable([16,16,256], n3(:,4588), t3x256(:,:,2956))
  call heltable([8,32,256], n3(:,4589), t3x256(:,:,2957))
  call heltable([8,32,256], n3(:,4590), t3x256(:,:,2958))
  call heltable([8,32,256], n3(:,4591), t3x256(:,:,2959))
  call heltable([8,32,256], n3(:,4592), t3x256(:,:,2960))
  call heltable([8,32,256], n3(:,4593), t3x256(:,:,2961))
  call heltable([8,32,256], n3(:,4594), t3x256(:,:,2962))
  call heltable([8,32,256], n3(:,4595), t3x256(:,:,2963))
  call heltable([8,32,256], n3(:,4596), t3x256(:,:,2964))
  call heltable([32,8,256], n3(:,4597), t3x256(:,:,2965))
  call heltable([32,8,256], n3(:,4598), t3x256(:,:,2966))
  call heltable([8,32,256], n3(:,4599), t3x256(:,:,2967))
  call heltable([32,8,256], n3(:,4600), t3x256(:,:,2968))
  call heltable([32,8,256], n3(:,4601), t3x256(:,:,2969))
  call heltable([8,32,256], n3(:,4602), t3x256(:,:,2970))
  call heltable([16,16,256], n3(:,4603), t3x256(:,:,2971))
  call heltable([16,16,256], n3(:,4604), t3x256(:,:,2972))
  call heltable([16,16,256], n3(:,4605), t3x256(:,:,2973))
  call heltable([16,16,256], n3(:,4606), t3x256(:,:,2974))
  call heltable([8,32,256], n3(:,4607), t3x256(:,:,2975))
  call heltable([8,32,256], n3(:,4608), t3x256(:,:,2976))
  call heltable([32,8,256], n3(:,4609), t3x256(:,:,2977))
  call heltable([32,8,256], n3(:,4610), t3x256(:,:,2978))
  call heltable([32,8,256], n3(:,4611), t3x256(:,:,2979))
  call heltable([32,8,256], n3(:,4612), t3x256(:,:,2980))
  call heltable([16,16,256], n3(:,4613), t3x256(:,:,2981))
  call heltable([16,16,256], n3(:,4614), t3x256(:,:,2982))
  call heltable([16,16,256], n3(:,4615), t3x256(:,:,2983))
  call heltable([16,16,256], n3(:,4616), t3x256(:,:,2984))
  call heltable([16,16,256], n3(:,4617), t3x256(:,:,2985))
  call heltable([16,16,256], n3(:,4618), t3x256(:,:,2986))
  call heltable([16,16,256], n3(:,4619), t3x256(:,:,2987))
  call heltable([16,16,256], n3(:,4620), t3x256(:,:,2988))
  call heltable([8,32,256], n3(:,4621), t3x256(:,:,2989))
  call heltable([8,32,256], n3(:,4622), t3x256(:,:,2990))
  call heltable([16,16,256], n3(:,4623), t3x256(:,:,2991))
  call heltable([16,16,256], n3(:,4624), t3x256(:,:,2992))
  call heltable([16,16,256], n3(:,4625), t3x256(:,:,2993))
  call heltable([16,16,256], n3(:,4626), t3x256(:,:,2994))
  call heltable([16,16,256], n3(:,4627), t3x256(:,:,2995))
  call heltable([16,16,256], n3(:,4628), t3x256(:,:,2996))
  call heltable([16,16,256], n3(:,4629), t3x256(:,:,2997))
  call heltable([16,16,256], n3(:,4630), t3x256(:,:,2998))
  call heltable([16,16,256], n3(:,4631), t3x256(:,:,2999))
  call heltable([16,16,256], n3(:,4632), t3x256(:,:,3000))
  call heltable([16,16,256], n3(:,4633), t3x256(:,:,3001))
  call heltable([16,16,256], n3(:,4634), t3x256(:,:,3002))
  call heltable([8,32,256], n3(:,4635), t3x256(:,:,3003))
  call heltable([8,32,256], n3(:,4636), t3x256(:,:,3004))
  call heltable([8,32,256], n3(:,4637), t3x256(:,:,3005))
  call heltable([8,32,256], n3(:,4638), t3x256(:,:,3006))
  call heltable([8,32,256], n3(:,4639), t3x256(:,:,3007))
  call heltable([8,32,256], n3(:,4640), t3x256(:,:,3008))
  call heltable([16,16,256], n3(:,4641), t3x256(:,:,3009))
  call heltable([16,16,256], n3(:,4642), t3x256(:,:,3010))
  call heltable([16,16,256], n3(:,4643), t3x256(:,:,3011))
  call heltable([16,16,256], n3(:,4644), t3x256(:,:,3012))
  call heltable([16,16,256], n3(:,4645), t3x256(:,:,3013))
  call heltable([16,16,256], n3(:,4646), t3x256(:,:,3014))
  call heltable([16,16,256], n3(:,4647), t3x256(:,:,3015))
  call heltable([16,16,256], n3(:,4648), t3x256(:,:,3016))
  call heltable([16,16,256], n3(:,4649), t3x256(:,:,3017))
  call heltable([16,16,256], n3(:,4650), t3x256(:,:,3018))
  call heltable([16,16,256], n3(:,4651), t3x256(:,:,3019))
  call heltable([16,16,256], n3(:,4652), t3x256(:,:,3020))
  call heltable([16,16,256], n3(:,4653), t3x256(:,:,3021))
  call heltable([16,16,256], n3(:,4654), t3x256(:,:,3022))
  call heltable([16,16,256], n3(:,4655), t3x256(:,:,3023))
  call heltable([16,16,256], n3(:,4656), t3x256(:,:,3024))
  call heltable([16,16,256], n3(:,4657), t3x256(:,:,3025))
  call heltable([16,16,256], n3(:,4658), t3x256(:,:,3026))
  call heltable([16,16,256], n3(:,4659), t3x256(:,:,3027))
  call heltable([16,16,256], n3(:,4660), t3x256(:,:,3028))
  call heltable([16,16,256], n3(:,4661), t3x256(:,:,3029))
  call heltable([16,16,256], n3(:,4662), t3x256(:,:,3030))
  call heltable([16,16,256], n3(:,4663), t3x256(:,:,3031))
  call heltable([16,16,256], n3(:,4664), t3x256(:,:,3032))
  call heltable([16,16,256], n3(:,4665), t3x256(:,:,3033))
  call heltable([16,16,256], n3(:,4666), t3x256(:,:,3034))
  call heltable([16,16,256], n3(:,4667), t3x256(:,:,3035))
  call heltable([16,16,256], n3(:,4668), t3x256(:,:,3036))
  call heltable([16,16,256], n3(:,4669), t3x256(:,:,3037))
  call heltable([16,16,256], n3(:,4670), t3x256(:,:,3038))
  call heltable([16,16,256], n3(:,4671), t3x256(:,:,3039))
  call heltable([16,16,256], n3(:,4672), t3x256(:,:,3040))
  call heltable([16,16,256], n3(:,4673), t3x256(:,:,3041))
  call heltable([16,16,256], n3(:,4674), t3x256(:,:,3042))
  call heltable([16,16,256], n3(:,4675), t3x256(:,:,3043))
  call heltable([16,16,256], n3(:,4676), t3x256(:,:,3044))
  call heltable([8,32,256], n3(:,4677), t3x256(:,:,3045))
  call heltable([8,32,256], n3(:,4678), t3x256(:,:,3046))
  call heltable([8,32,256], n3(:,4679), t3x256(:,:,3047))
  call heltable([8,32,256], n3(:,4680), t3x256(:,:,3048))
  call heltable([8,32,256], n3(:,4681), t3x256(:,:,3049))
  call heltable([8,32,256], n3(:,4682), t3x256(:,:,3050))
  call heltable([16,16,256], n3(:,4683), t3x256(:,:,3051))
  call heltable([16,16,256], n3(:,4684), t3x256(:,:,3052))
  call heltable([16,16,256], n3(:,4685), t3x256(:,:,3053))
  call heltable([16,16,256], n3(:,4686), t3x256(:,:,3054))
  call heltable([16,16,256], n3(:,4687), t3x256(:,:,3055))
  call heltable([16,16,256], n3(:,4688), t3x256(:,:,3056))
  call heltable([16,16,256], n3(:,4689), t3x256(:,:,3057))
  call heltable([16,16,256], n3(:,4690), t3x256(:,:,3058))
  call heltable([16,16,256], n3(:,4691), t3x256(:,:,3059))
  call heltable([16,16,256], n3(:,4692), t3x256(:,:,3060))
  call heltable([16,16,256], n3(:,4693), t3x256(:,:,3061))
  call heltable([16,16,256], n3(:,4694), t3x256(:,:,3062))
  call heltable([16,16,256], n3(:,4695), t3x256(:,:,3063))
  call heltable([16,16,256], n3(:,4696), t3x256(:,:,3064))
  call heltable([16,16,256], n3(:,4697), t3x256(:,:,3065))
  call heltable([16,16,256], n3(:,4698), t3x256(:,:,3066))
  call heltable([16,16,256], n3(:,4699), t3x256(:,:,3067))
  call heltable([16,16,256], n3(:,4700), t3x256(:,:,3068))
  call heltable([16,16,256], n3(:,4701), t3x256(:,:,3069))
  call heltable([16,16,256], n3(:,4702), t3x256(:,:,3070))
  call heltable([16,16,256], n3(:,4703), t3x256(:,:,3071))
  call heltable([16,16,256], n3(:,4704), t3x256(:,:,3072))
  call heltable([16,16,256], n3(:,4705), t3x256(:,:,3073))
  call heltable([16,16,256], n3(:,4706), t3x256(:,:,3074))
  call heltable([16,16,256], n3(:,4707), t3x256(:,:,3075))
  call heltable([16,16,256], n3(:,4708), t3x256(:,:,3076))
  call heltable([16,16,256], n3(:,4709), t3x256(:,:,3077))
  call heltable([16,16,256], n3(:,4710), t3x256(:,:,3078))
  call heltable([16,16,256], n3(:,4711), t3x256(:,:,3079))
  call heltable([16,16,256], n3(:,4712), t3x256(:,:,3080))
  call heltable([16,16,256], n3(:,4713), t3x256(:,:,3081))
  call heltable([16,16,256], n3(:,4714), t3x256(:,:,3082))
  call heltable([16,16,256], n3(:,4715), t3x256(:,:,3083))
  call heltable([16,16,256], n3(:,4716), t3x256(:,:,3084))
  call heltable([16,16,256], n3(:,4717), t3x256(:,:,3085))
  call heltable([16,16,256], n3(:,4718), t3x256(:,:,3086))
  call heltable([8,32,256], n3(:,4719), t3x256(:,:,3087))
  call heltable([8,32,256], n3(:,4720), t3x256(:,:,3088))
  call heltable([8,32,256], n3(:,4721), t3x256(:,:,3089))
  call heltable([8,32,256], n3(:,4722), t3x256(:,:,3090))
  call heltable([8,32,256], n3(:,4723), t3x256(:,:,3091))
  call heltable([8,32,256], n3(:,4724), t3x256(:,:,3092))
  call heltable([16,16,256], n3(:,4725), t3x256(:,:,3093))
  call heltable([16,16,256], n3(:,4726), t3x256(:,:,3094))
  call heltable([16,16,256], n3(:,4727), t3x256(:,:,3095))
  call heltable([16,16,256], n3(:,4728), t3x256(:,:,3096))
  call heltable([16,16,256], n3(:,4729), t3x256(:,:,3097))
  call heltable([16,16,256], n3(:,4730), t3x256(:,:,3098))
  call heltable([16,16,256], n3(:,4731), t3x256(:,:,3099))
  call heltable([16,16,256], n3(:,4732), t3x256(:,:,3100))
  call heltable([16,16,256], n3(:,4733), t3x256(:,:,3101))
  call heltable([16,16,256], n3(:,4734), t3x256(:,:,3102))
  call heltable([16,16,256], n3(:,4735), t3x256(:,:,3103))
  call heltable([16,16,256], n3(:,4736), t3x256(:,:,3104))
  call heltable([16,16,256], n3(:,4737), t3x256(:,:,3105))
  call heltable([16,16,256], n3(:,4738), t3x256(:,:,3106))
  call heltable([16,16,256], n3(:,4739), t3x256(:,:,3107))
  call heltable([16,16,256], n3(:,4740), t3x256(:,:,3108))
  call heltable([16,16,256], n3(:,4741), t3x256(:,:,3109))
  call heltable([16,16,256], n3(:,4742), t3x256(:,:,3110))
  call heltable([16,16,256], n3(:,4743), t3x256(:,:,3111))
  call heltable([16,16,256], n3(:,4744), t3x256(:,:,3112))
  call heltable([16,16,256], n3(:,4745), t3x256(:,:,3113))
  call heltable([16,16,256], n3(:,4746), t3x256(:,:,3114))
  call heltable([16,16,256], n3(:,4747), t3x256(:,:,3115))
  call heltable([16,16,256], n3(:,4748), t3x256(:,:,3116))
  call heltable([16,16,256], n3(:,4749), t3x256(:,:,3117))
  call heltable([16,16,256], n3(:,4750), t3x256(:,:,3118))
  call heltable([16,16,256], n3(:,4751), t3x256(:,:,3119))
  call heltable([16,16,256], n3(:,4752), t3x256(:,:,3120))
  call heltable([16,16,256], n3(:,4753), t3x256(:,:,3121))
  call heltable([16,16,256], n3(:,4754), t3x256(:,:,3122))
  call heltable([16,16,256], n3(:,4755), t3x256(:,:,3123))
  call heltable([16,16,256], n3(:,4756), t3x256(:,:,3124))
  call heltable([16,16,256], n3(:,4757), t3x256(:,:,3125))
  call heltable([16,16,256], n3(:,4758), t3x256(:,:,3126))
  call heltable([16,16,256], n3(:,4759), t3x256(:,:,3127))
  call heltable([16,16,256], n3(:,4760), t3x256(:,:,3128))
  call heltable([8,32,256], n3(:,4761), t3x256(:,:,3129))
  call heltable([8,32,256], n3(:,4762), t3x256(:,:,3130))
  call heltable([8,32,256], n3(:,4763), t3x256(:,:,3131))
  call heltable([8,32,256], n3(:,4764), t3x256(:,:,3132))
  call heltable([8,32,256], n3(:,4765), t3x256(:,:,3133))
  call heltable([8,32,256], n3(:,4766), t3x256(:,:,3134))
  call heltable([32,8,256], n3(:,4767), t3x256(:,:,3135))
  call heltable([32,8,256], n3(:,4768), t3x256(:,:,3136))
  call heltable([8,32,256], n3(:,4769), t3x256(:,:,3137))
  call heltable([32,8,256], n3(:,4770), t3x256(:,:,3138))
  call heltable([32,8,256], n3(:,4771), t3x256(:,:,3139))
  call heltable([8,32,256], n3(:,4772), t3x256(:,:,3140))
  call heltable([16,16,256], n3(:,4773), t3x256(:,:,3141))
  call heltable([16,16,256], n3(:,4774), t3x256(:,:,3142))
  call heltable([16,16,256], n3(:,4775), t3x256(:,:,3143))
  call heltable([16,16,256], n3(:,4776), t3x256(:,:,3144))
  call heltable([8,32,256], n3(:,4777), t3x256(:,:,3145))
  call heltable([8,32,256], n3(:,4778), t3x256(:,:,3146))
  call heltable([16,16,256], n3(:,4779), t3x256(:,:,3147))
  call heltable([16,16,256], n3(:,4780), t3x256(:,:,3148))
  call heltable([16,16,256], n3(:,4781), t3x256(:,:,3149))
  call heltable([16,16,256], n3(:,4782), t3x256(:,:,3150))
  call heltable([16,16,256], n3(:,4783), t3x256(:,:,3151))
  call heltable([16,16,256], n3(:,4784), t3x256(:,:,3152))
  call heltable([16,16,256], n3(:,4785), t3x256(:,:,3153))
  call heltable([16,16,256], n3(:,4786), t3x256(:,:,3154))
  call heltable([16,16,256], n3(:,4787), t3x256(:,:,3155))
  call heltable([16,16,256], n3(:,4788), t3x256(:,:,3156))
  call heltable([16,16,256], n3(:,4789), t3x256(:,:,3157))
  call heltable([16,16,256], n3(:,4790), t3x256(:,:,3158))
  call heltable([8,32,256], n3(:,4791), t3x256(:,:,3159))
  call heltable([8,32,256], n3(:,4792), t3x256(:,:,3160))
  call heltable([32,8,256], n3(:,4793), t3x256(:,:,3161))
  call heltable([32,8,256], n3(:,4794), t3x256(:,:,3162))
  call heltable([32,8,256], n3(:,4795), t3x256(:,:,3163))
  call heltable([32,8,256], n3(:,4796), t3x256(:,:,3164))
  call heltable([16,16,256], n3(:,4797), t3x256(:,:,3165))
  call heltable([16,16,256], n3(:,4798), t3x256(:,:,3166))
  call heltable([16,16,256], n3(:,4799), t3x256(:,:,3167))
  call heltable([16,16,256], n3(:,4800), t3x256(:,:,3168))
  call heltable([16,16,256], n3(:,4801), t3x256(:,:,3169))
  call heltable([16,16,256], n3(:,4802), t3x256(:,:,3170))
  call heltable([16,16,256], n3(:,4803), t3x256(:,:,3171))
  call heltable([16,16,256], n3(:,4804), t3x256(:,:,3172))
  call heltable([8,32,256], n3(:,4805), t3x256(:,:,3173))
  call heltable([8,32,256], n3(:,4806), t3x256(:,:,3174))
  call heltable([16,16,256], n3(:,4807), t3x256(:,:,3175))
  call heltable([16,16,256], n3(:,4808), t3x256(:,:,3176))
  call heltable([16,16,256], n3(:,4809), t3x256(:,:,3177))
  call heltable([16,16,256], n3(:,4810), t3x256(:,:,3178))
  call heltable([16,16,256], n3(:,4811), t3x256(:,:,3179))
  call heltable([16,16,256], n3(:,4812), t3x256(:,:,3180))
  call heltable([16,16,256], n3(:,4813), t3x256(:,:,3181))
  call heltable([16,16,256], n3(:,4814), t3x256(:,:,3182))
  call heltable([16,16,256], n3(:,4815), t3x256(:,:,3183))
  call heltable([16,16,256], n3(:,4816), t3x256(:,:,3184))
  call heltable([16,16,256], n3(:,4817), t3x256(:,:,3185))
  call heltable([16,16,256], n3(:,4818), t3x256(:,:,3186))
  call heltable([16,16,256], n3(:,4819), t3x256(:,:,3187))
  call heltable([16,16,256], n3(:,4820), t3x256(:,:,3188))
  call heltable([16,16,256], n3(:,4821), t3x256(:,:,3189))
  call heltable([16,16,256], n3(:,4822), t3x256(:,:,3190))
  call heltable([16,16,256], n3(:,4823), t3x256(:,:,3191))
  call heltable([16,16,256], n3(:,4824), t3x256(:,:,3192))
  call heltable([16,16,256], n3(:,4825), t3x256(:,:,3193))
  call heltable([16,16,256], n3(:,4826), t3x256(:,:,3194))
  call heltable([16,16,256], n3(:,4827), t3x256(:,:,3195))
  call heltable([16,16,256], n3(:,4828), t3x256(:,:,3196))
  call heltable([16,16,256], n3(:,4829), t3x256(:,:,3197))
  call heltable([16,16,256], n3(:,4830), t3x256(:,:,3198))
  call heltable([16,16,256], n3(:,4831), t3x256(:,:,3199))
  call heltable([16,16,256], n3(:,4832), t3x256(:,:,3200))
  call heltable([8,32,256], n3(:,4833), t3x256(:,:,3201))
  call heltable([8,32,256], n3(:,4834), t3x256(:,:,3202))
  call heltable([8,32,256], n3(:,4835), t3x256(:,:,3203))
  call heltable([8,32,256], n3(:,4836), t3x256(:,:,3204))
  call heltable([8,32,256], n3(:,4837), t3x256(:,:,3205))
  call heltable([8,32,256], n3(:,4838), t3x256(:,:,3206))
  call heltable([16,16,256], n3(:,4839), t3x256(:,:,3207))
  call heltable([16,16,256], n3(:,4840), t3x256(:,:,3208))
  call heltable([16,16,256], n3(:,4841), t3x256(:,:,3209))
  call heltable([16,16,256], n3(:,4842), t3x256(:,:,3210))
  call heltable([16,16,256], n3(:,4843), t3x256(:,:,3211))
  call heltable([16,16,256], n3(:,4844), t3x256(:,:,3212))
  call heltable([16,16,256], n3(:,4845), t3x256(:,:,3213))
  call heltable([16,16,256], n3(:,4846), t3x256(:,:,3214))
  call heltable([16,16,256], n3(:,4847), t3x256(:,:,3215))
  call heltable([16,16,256], n3(:,4848), t3x256(:,:,3216))
  call heltable([16,16,256], n3(:,4849), t3x256(:,:,3217))
  call heltable([16,16,256], n3(:,4850), t3x256(:,:,3218))
  call heltable([16,16,256], n3(:,4851), t3x256(:,:,3219))
  call heltable([16,16,256], n3(:,4852), t3x256(:,:,3220))
  call heltable([16,16,256], n3(:,4853), t3x256(:,:,3221))
  call heltable([16,16,256], n3(:,4854), t3x256(:,:,3222))
  call heltable([16,16,256], n3(:,4855), t3x256(:,:,3223))
  call heltable([16,16,256], n3(:,4856), t3x256(:,:,3224))
  call heltable([16,16,256], n3(:,4857), t3x256(:,:,3225))
  call heltable([16,16,256], n3(:,4858), t3x256(:,:,3226))
  call heltable([16,16,256], n3(:,4859), t3x256(:,:,3227))
  call heltable([16,16,256], n3(:,4860), t3x256(:,:,3228))
  call heltable([8,32,256], n3(:,4861), t3x256(:,:,3229))
  call heltable([8,32,256], n3(:,4862), t3x256(:,:,3230))
  call heltable([8,32,256], n3(:,4863), t3x256(:,:,3231))
  call heltable([8,32,256], n3(:,4864), t3x256(:,:,3232))
  call heltable([8,32,256], n3(:,4865), t3x256(:,:,3233))
  call heltable([8,32,256], n3(:,4866), t3x256(:,:,3234))
  call heltable([32,8,256], n3(:,4867), t3x256(:,:,3235))
  call heltable([32,8,256], n3(:,4868), t3x256(:,:,3236))
  call heltable([8,32,256], n3(:,4869), t3x256(:,:,3237))
  call heltable([32,8,256], n3(:,4870), t3x256(:,:,3238))
  call heltable([32,8,256], n3(:,4871), t3x256(:,:,3239))
  call heltable([8,32,256], n3(:,4872), t3x256(:,:,3240))
  call heltable([16,16,256], n3(:,4873), t3x256(:,:,3241))
  call heltable([16,16,256], n3(:,4874), t3x256(:,:,3242))
  call heltable([16,16,256], n3(:,4875), t3x256(:,:,3243))
  call heltable([16,16,256], n3(:,4876), t3x256(:,:,3244))
  call heltable([8,32,256], n3(:,4877), t3x256(:,:,3245))
  call heltable([8,32,256], n3(:,4878), t3x256(:,:,3246))
  call heltable([16,16,256], n3(:,4879), t3x256(:,:,3247))
  call heltable([16,16,256], n3(:,4880), t3x256(:,:,3248))
  call heltable([16,16,256], n3(:,4881), t3x256(:,:,3249))
  call heltable([16,16,256], n3(:,4882), t3x256(:,:,3250))
  call heltable([16,16,256], n3(:,4883), t3x256(:,:,3251))
  call heltable([16,16,256], n3(:,4884), t3x256(:,:,3252))
  call heltable([16,16,256], n3(:,4885), t3x256(:,:,3253))
  call heltable([16,16,256], n3(:,4886), t3x256(:,:,3254))
  call heltable([16,16,256], n3(:,4887), t3x256(:,:,3255))
  call heltable([16,16,256], n3(:,4888), t3x256(:,:,3256))
  call heltable([16,16,256], n3(:,4889), t3x256(:,:,3257))
  call heltable([16,16,256], n3(:,4890), t3x256(:,:,3258))
  call heltable([8,32,256], n3(:,4891), t3x256(:,:,3259))
  call heltable([8,32,256], n3(:,4892), t3x256(:,:,3260))
  call heltable([32,8,256], n3(:,4893), t3x256(:,:,3261))
  call heltable([32,8,256], n3(:,4894), t3x256(:,:,3262))
  call heltable([32,8,256], n3(:,4895), t3x256(:,:,3263))
  call heltable([32,8,256], n3(:,4896), t3x256(:,:,3264))
  call heltable([16,16,256], n3(:,4897), t3x256(:,:,3265))
  call heltable([16,16,256], n3(:,4898), t3x256(:,:,3266))
  call heltable([16,16,256], n3(:,4899), t3x256(:,:,3267))
  call heltable([16,16,256], n3(:,4900), t3x256(:,:,3268))
  call heltable([16,16,256], n3(:,4901), t3x256(:,:,3269))
  call heltable([16,16,256], n3(:,4902), t3x256(:,:,3270))
  call heltable([16,16,256], n3(:,4903), t3x256(:,:,3271))
  call heltable([16,16,256], n3(:,4904), t3x256(:,:,3272))
  call heltable([8,32,256], n3(:,4905), t3x256(:,:,3273))
  call heltable([8,32,256], n3(:,4906), t3x256(:,:,3274))
  call heltable([16,16,256], n3(:,4907), t3x256(:,:,3275))
  call heltable([16,16,256], n3(:,4908), t3x256(:,:,3276))
  call heltable([16,16,256], n3(:,4909), t3x256(:,:,3277))
  call heltable([16,16,256], n3(:,4910), t3x256(:,:,3278))
  call heltable([16,16,256], n3(:,4911), t3x256(:,:,3279))
  call heltable([16,16,256], n3(:,4912), t3x256(:,:,3280))
  call heltable([16,16,256], n3(:,4913), t3x256(:,:,3281))
  call heltable([16,16,256], n3(:,4914), t3x256(:,:,3282))
  call heltable([16,16,256], n3(:,4915), t3x256(:,:,3283))
  call heltable([16,16,256], n3(:,4916), t3x256(:,:,3284))
  call heltable([16,16,256], n3(:,4917), t3x256(:,:,3285))
  call heltable([16,16,256], n3(:,4918), t3x256(:,:,3286))
  call heltable([16,16,256], n3(:,4919), t3x256(:,:,3287))
  call heltable([16,16,256], n3(:,4920), t3x256(:,:,3288))
  call heltable([16,16,256], n3(:,4921), t3x256(:,:,3289))
  call heltable([16,16,256], n3(:,4922), t3x256(:,:,3290))
  call heltable([16,16,256], n3(:,4923), t3x256(:,:,3291))
  call heltable([16,16,256], n3(:,4924), t3x256(:,:,3292))
  call heltable([16,16,256], n3(:,4925), t3x256(:,:,3293))
  call heltable([16,16,256], n3(:,4926), t3x256(:,:,3294))
  call heltable([16,16,256], n3(:,4927), t3x256(:,:,3295))
  call heltable([16,16,256], n3(:,4928), t3x256(:,:,3296))
  call heltable([16,16,256], n3(:,4929), t3x256(:,:,3297))
  call heltable([16,16,256], n3(:,4930), t3x256(:,:,3298))
  call heltable([16,16,256], n3(:,4931), t3x256(:,:,3299))
  call heltable([16,16,256], n3(:,4932), t3x256(:,:,3300))
  call heltable([8,32,256], n3(:,4933), t3x256(:,:,3301))
  call heltable([8,32,256], n3(:,4934), t3x256(:,:,3302))
  call heltable([8,32,256], n3(:,4935), t3x256(:,:,3303))
  call heltable([8,32,256], n3(:,4936), t3x256(:,:,3304))
  call heltable([8,32,256], n3(:,4937), t3x256(:,:,3305))
  call heltable([8,32,256], n3(:,4938), t3x256(:,:,3306))
  call heltable([16,16,256], n3(:,4939), t3x256(:,:,3307))
  call heltable([16,16,256], n3(:,4940), t3x256(:,:,3308))
  call heltable([16,16,256], n3(:,4941), t3x256(:,:,3309))
  call heltable([16,16,256], n3(:,4942), t3x256(:,:,3310))
  call heltable([16,16,256], n3(:,4943), t3x256(:,:,3311))
  call heltable([16,16,256], n3(:,4944), t3x256(:,:,3312))
  call heltable([16,16,256], n3(:,4945), t3x256(:,:,3313))
  call heltable([16,16,256], n3(:,4946), t3x256(:,:,3314))
  call heltable([16,16,256], n3(:,4947), t3x256(:,:,3315))
  call heltable([16,16,256], n3(:,4948), t3x256(:,:,3316))
  call heltable([16,16,256], n3(:,4949), t3x256(:,:,3317))
  call heltable([16,16,256], n3(:,4950), t3x256(:,:,3318))
  call heltable([16,16,256], n3(:,4951), t3x256(:,:,3319))
  call heltable([16,16,256], n3(:,4952), t3x256(:,:,3320))
  call heltable([16,16,256], n3(:,4953), t3x256(:,:,3321))
  call heltable([16,16,256], n3(:,4954), t3x256(:,:,3322))
  call heltable([16,16,256], n3(:,4955), t3x256(:,:,3323))
  call heltable([16,16,256], n3(:,4956), t3x256(:,:,3324))
  call heltable([16,16,256], n3(:,4957), t3x256(:,:,3325))
  call heltable([16,16,256], n3(:,4958), t3x256(:,:,3326))
  call heltable([16,16,256], n3(:,4959), t3x256(:,:,3327))
  call heltable([16,16,256], n3(:,4960), t3x256(:,:,3328))
  call heltable([16,16,256], n3(:,4961), t3x256(:,:,3329))
  call heltable([16,16,256], n3(:,4962), t3x256(:,:,3330))
  call heltable([16,16,256], n3(:,4963), t3x256(:,:,3331))
  call heltable([16,16,256], n3(:,4964), t3x256(:,:,3332))
  call heltable([16,16,256], n3(:,4965), t3x256(:,:,3333))
  call heltable([16,16,256], n3(:,4966), t3x256(:,:,3334))
  call heltable([16,16,256], n3(:,4967), t3x256(:,:,3335))
  call heltable([16,16,256], n3(:,4968), t3x256(:,:,3336))
  call heltable([16,16,256], n3(:,4969), t3x256(:,:,3337))
  call heltable([16,16,256], n3(:,4970), t3x256(:,:,3338))
  call heltable([16,16,256], n3(:,4971), t3x256(:,:,3339))
  call heltable([16,16,256], n3(:,4972), t3x256(:,:,3340))
  call heltable([16,16,256], n3(:,4973), t3x256(:,:,3341))
  call heltable([16,16,256], n3(:,4974), t3x256(:,:,3342))
  call heltable([8,32,256], n3(:,4975), t3x256(:,:,3343))
  call heltable([8,32,256], n3(:,4976), t3x256(:,:,3344))
  call heltable([8,32,256], n3(:,4977), t3x256(:,:,3345))
  call heltable([8,32,256], n3(:,4978), t3x256(:,:,3346))
  call heltable([8,32,256], n3(:,4979), t3x256(:,:,3347))
  call heltable([8,32,256], n3(:,4980), t3x256(:,:,3348))
  call heltable([16,16,256], n3(:,4981), t3x256(:,:,3349))
  call heltable([16,16,256], n3(:,4982), t3x256(:,:,3350))
  call heltable([16,16,256], n3(:,4983), t3x256(:,:,3351))
  call heltable([16,16,256], n3(:,4984), t3x256(:,:,3352))
  call heltable([16,16,256], n3(:,4985), t3x256(:,:,3353))
  call heltable([16,16,256], n3(:,4986), t3x256(:,:,3354))
  call heltable([16,16,256], n3(:,4987), t3x256(:,:,3355))
  call heltable([16,16,256], n3(:,4988), t3x256(:,:,3356))
  call heltable([16,16,256], n3(:,4989), t3x256(:,:,3357))
  call heltable([16,16,256], n3(:,4990), t3x256(:,:,3358))
  call heltable([16,16,256], n3(:,4991), t3x256(:,:,3359))
  call heltable([16,16,256], n3(:,4992), t3x256(:,:,3360))
  call heltable([16,16,256], n3(:,4993), t3x256(:,:,3361))
  call heltable([16,16,256], n3(:,4994), t3x256(:,:,3362))
  call heltable([16,16,256], n3(:,4995), t3x256(:,:,3363))
  call heltable([16,16,256], n3(:,4996), t3x256(:,:,3364))
  call heltable([16,16,256], n3(:,4997), t3x256(:,:,3365))
  call heltable([16,16,256], n3(:,4998), t3x256(:,:,3366))
  call heltable([16,16,256], n3(:,4999), t3x256(:,:,3367))
  call heltable([16,16,256], n3(:,5000), t3x256(:,:,3368))
  call heltable([16,16,256], n3(:,5001), t3x256(:,:,3369))
  call heltable([16,16,256], n3(:,5002), t3x256(:,:,3370))
  call heltable([16,16,256], n3(:,5003), t3x256(:,:,3371))
  call heltable([16,16,256], n3(:,5004), t3x256(:,:,3372))
  call heltable([16,16,256], n3(:,5005), t3x256(:,:,3373))
  call heltable([16,16,256], n3(:,5006), t3x256(:,:,3374))
  call heltable([16,16,256], n3(:,5007), t3x256(:,:,3375))
  call heltable([16,16,256], n3(:,5008), t3x256(:,:,3376))
  call heltable([16,16,256], n3(:,5009), t3x256(:,:,3377))
  call heltable([16,16,256], n3(:,5010), t3x256(:,:,3378))
  call heltable([16,16,256], n3(:,5011), t3x256(:,:,3379))
  call heltable([16,16,256], n3(:,5012), t3x256(:,:,3380))
  call heltable([16,16,256], n3(:,5013), t3x256(:,:,3381))
  call heltable([16,16,256], n3(:,5014), t3x256(:,:,3382))
  call heltable([16,16,256], n3(:,5015), t3x256(:,:,3383))
  call heltable([16,16,256], n3(:,5016), t3x256(:,:,3384))
  call heltable([8,32,256], n3(:,5017), t3x256(:,:,3385))
  call heltable([8,32,256], n3(:,5018), t3x256(:,:,3386))
  call heltable([8,32,256], n3(:,5019), t3x256(:,:,3387))
  call heltable([8,32,256], n3(:,5020), t3x256(:,:,3388))
  call heltable([8,32,256], n3(:,5021), t3x256(:,:,3389))
  call heltable([8,32,256], n3(:,5022), t3x256(:,:,3390))
  call heltable([16,16,256], n3(:,5023), t3x256(:,:,3391))
  call heltable([16,16,256], n3(:,5024), t3x256(:,:,3392))
  call heltable([16,16,256], n3(:,5025), t3x256(:,:,3393))
  call heltable([16,16,256], n3(:,5026), t3x256(:,:,3394))
  call heltable([16,16,256], n3(:,5027), t3x256(:,:,3395))
  call heltable([16,16,256], n3(:,5028), t3x256(:,:,3396))
  call heltable([16,16,256], n3(:,5029), t3x256(:,:,3397))
  call heltable([16,16,256], n3(:,5030), t3x256(:,:,3398))
  call heltable([16,16,256], n3(:,5031), t3x256(:,:,3399))
  call heltable([16,16,256], n3(:,5032), t3x256(:,:,3400))
  call heltable([16,16,256], n3(:,5033), t3x256(:,:,3401))
  call heltable([16,16,256], n3(:,5034), t3x256(:,:,3402))
  call heltable([16,16,256], n3(:,5035), t3x256(:,:,3403))
  call heltable([16,16,256], n3(:,5036), t3x256(:,:,3404))
  call heltable([16,16,256], n3(:,5037), t3x256(:,:,3405))
  call heltable([16,16,256], n3(:,5038), t3x256(:,:,3406))
  call heltable([16,16,256], n3(:,5039), t3x256(:,:,3407))
  call heltable([16,16,256], n3(:,5040), t3x256(:,:,3408))
  call heltable([16,16,256], n3(:,5041), t3x256(:,:,3409))
  call heltable([16,16,256], n3(:,5042), t3x256(:,:,3410))
  call heltable([16,16,256], n3(:,5043), t3x256(:,:,3411))
  call heltable([16,16,256], n3(:,5044), t3x256(:,:,3412))
  call heltable([16,16,256], n3(:,5045), t3x256(:,:,3413))
  call heltable([16,16,256], n3(:,5046), t3x256(:,:,3414))
  call heltable([16,16,256], n3(:,5047), t3x256(:,:,3415))
  call heltable([16,16,256], n3(:,5048), t3x256(:,:,3416))
  call heltable([16,16,256], n3(:,5049), t3x256(:,:,3417))
  call heltable([16,16,256], n3(:,5050), t3x256(:,:,3418))
  call heltable([16,16,256], n3(:,5051), t3x256(:,:,3419))
  call heltable([16,16,256], n3(:,5052), t3x256(:,:,3420))
  call heltable([16,16,256], n3(:,5053), t3x256(:,:,3421))
  call heltable([16,16,256], n3(:,5054), t3x256(:,:,3422))
  call heltable([16,16,256], n3(:,5055), t3x256(:,:,3423))
  call heltable([16,16,256], n3(:,5056), t3x256(:,:,3424))
  call heltable([16,16,256], n3(:,5057), t3x256(:,:,3425))
  call heltable([16,16,256], n3(:,5058), t3x256(:,:,3426))
  call heltable([16,16,256], n3(:,5059), t3x256(:,:,3427))
  call heltable([16,16,256], n3(:,5060), t3x256(:,:,3428))
  call heltable([16,16,256], n3(:,5061), t3x256(:,:,3429))
  call heltable([16,16,256], n3(:,5062), t3x256(:,:,3430))
  call heltable([16,16,256], n3(:,5063), t3x256(:,:,3431))
  call heltable([16,16,256], n3(:,5064), t3x256(:,:,3432))
  call heltable([16,16,256], n3(:,5065), t3x256(:,:,3433))
  call heltable([16,16,256], n3(:,5066), t3x256(:,:,3434))
  call heltable([16,16,256], n3(:,5067), t3x256(:,:,3435))
  call heltable([16,16,256], n3(:,5068), t3x256(:,:,3436))
  call heltable([16,16,256], n3(:,5069), t3x256(:,:,3437))
  call heltable([16,16,256], n3(:,5070), t3x256(:,:,3438))
  call heltable([16,16,256], n3(:,5071), t3x256(:,:,3439))
  call heltable([16,16,256], n3(:,5072), t3x256(:,:,3440))
  call heltable([16,16,256], n3(:,5073), t3x256(:,:,3441))
  call heltable([16,16,256], n3(:,5074), t3x256(:,:,3442))
  call heltable([16,16,256], n3(:,5075), t3x256(:,:,3443))
  call heltable([16,16,256], n3(:,5076), t3x256(:,:,3444))
  call heltable([16,16,256], n3(:,5077), t3x256(:,:,3445))
  call heltable([16,16,256], n3(:,5078), t3x256(:,:,3446))
  call heltable([16,16,256], n3(:,5079), t3x256(:,:,3447))
  call heltable([16,16,256], n3(:,5080), t3x256(:,:,3448))
  call heltable([8,32,256], n3(:,5081), t3x256(:,:,3449))
  call heltable([16,16,256], n3(:,5082), t3x256(:,:,3450))
  call heltable([16,16,256], n3(:,5083), t3x256(:,:,3451))
  call heltable([8,32,256], n3(:,5084), t3x256(:,:,3452))
  call heltable([16,16,256], n3(:,5085), t3x256(:,:,3453))
  call heltable([16,16,256], n3(:,5086), t3x256(:,:,3454))
  call heltable([16,16,256], n3(:,5087), t3x256(:,:,3455))
  call heltable([16,16,256], n3(:,5088), t3x256(:,:,3456))
  call heltable([16,16,256], n3(:,5089), t3x256(:,:,3457))
  call heltable([16,16,256], n3(:,5090), t3x256(:,:,3458))
  call heltable([16,16,256], n3(:,5091), t3x256(:,:,3459))
  call heltable([16,16,256], n3(:,5092), t3x256(:,:,3460))
  call heltable([16,16,256], n3(:,5093), t3x256(:,:,3461))
  call heltable([16,16,256], n3(:,5094), t3x256(:,:,3462))
  call heltable([8,32,256], n3(:,5095), t3x256(:,:,3463))
  call heltable([16,16,256], n3(:,5096), t3x256(:,:,3464))
  call heltable([8,32,256], n3(:,5097), t3x256(:,:,3465))
  call heltable([16,16,256], n3(:,5098), t3x256(:,:,3466))
  call heltable([8,32,256], n3(:,5099), t3x256(:,:,3467))
  call heltable([8,32,256], n3(:,5100), t3x256(:,:,3468))
  call heltable([8,32,256], n3(:,5101), t3x256(:,:,3469))
  call heltable([8,32,256], n3(:,5102), t3x256(:,:,3470))
  call heltable([16,16,256], n3(:,5103), t3x256(:,:,3471))
  call heltable([16,16,256], n3(:,5104), t3x256(:,:,3472))
  call heltable([16,16,256], n3(:,5105), t3x256(:,:,3473))
  call heltable([16,16,256], n3(:,5106), t3x256(:,:,3474))
  call heltable([16,16,256], n3(:,5107), t3x256(:,:,3475))
  call heltable([16,16,256], n3(:,5108), t3x256(:,:,3476))
  call heltable([16,16,256], n3(:,5109), t3x256(:,:,3477))
  call heltable([16,16,256], n3(:,5110), t3x256(:,:,3478))
  call heltable([16,16,256], n3(:,5111), t3x256(:,:,3479))
  call heltable([16,16,256], n3(:,5112), t3x256(:,:,3480))
  call heltable([16,16,256], n3(:,5113), t3x256(:,:,3481))
  call heltable([16,16,256], n3(:,5114), t3x256(:,:,3482))
  call heltable([16,16,256], n3(:,5115), t3x256(:,:,3483))
  call heltable([16,16,256], n3(:,5116), t3x256(:,:,3484))
  call heltable([16,16,256], n3(:,5117), t3x256(:,:,3485))
  call heltable([16,16,256], n3(:,5118), t3x256(:,:,3486))
  call heltable([16,16,256], n3(:,5119), t3x256(:,:,3487))
  call heltable([16,16,256], n3(:,5120), t3x256(:,:,3488))
  call heltable([16,16,256], n3(:,5121), t3x256(:,:,3489))
  call heltable([16,16,256], n3(:,5122), t3x256(:,:,3490))
  call heltable([16,16,256], n3(:,5123), t3x256(:,:,3491))
  call heltable([16,16,256], n3(:,5124), t3x256(:,:,3492))
  call heltable([16,16,256], n3(:,5125), t3x256(:,:,3493))
  call heltable([16,16,256], n3(:,5126), t3x256(:,:,3494))
  call heltable([16,16,256], n3(:,5127), t3x256(:,:,3495))
  call heltable([16,16,256], n3(:,5128), t3x256(:,:,3496))
  call heltable([16,16,256], n3(:,5129), t3x256(:,:,3497))
  call heltable([16,16,256], n3(:,5130), t3x256(:,:,3498))
  call heltable([16,16,256], n3(:,5131), t3x256(:,:,3499))
  call heltable([16,16,256], n3(:,5132), t3x256(:,:,3500))
  call heltable([16,16,256], n3(:,5133), t3x256(:,:,3501))
  call heltable([16,16,256], n3(:,5134), t3x256(:,:,3502))
  call heltable([16,16,256], n3(:,5135), t3x256(:,:,3503))
  call heltable([16,16,256], n3(:,5136), t3x256(:,:,3504))
  call heltable([16,16,256], n3(:,5137), t3x256(:,:,3505))
  call heltable([16,16,256], n3(:,5138), t3x256(:,:,3506))
  call heltable([8,32,256], n3(:,5139), t3x256(:,:,3507))
  call heltable([16,16,256], n3(:,5140), t3x256(:,:,3508))
  call heltable([16,16,256], n3(:,5141), t3x256(:,:,3509))
  call heltable([8,32,256], n3(:,5142), t3x256(:,:,3510))
  call heltable([16,16,256], n3(:,5143), t3x256(:,:,3511))
  call heltable([16,16,256], n3(:,5144), t3x256(:,:,3512))
  call heltable([16,16,256], n3(:,5145), t3x256(:,:,3513))
  call heltable([16,16,256], n3(:,5146), t3x256(:,:,3514))
  call heltable([16,16,256], n3(:,5147), t3x256(:,:,3515))
  call heltable([16,16,256], n3(:,5148), t3x256(:,:,3516))
  call heltable([16,16,256], n3(:,5149), t3x256(:,:,3517))
  call heltable([16,16,256], n3(:,5150), t3x256(:,:,3518))
  call heltable([16,16,256], n3(:,5151), t3x256(:,:,3519))
  call heltable([16,16,256], n3(:,5152), t3x256(:,:,3520))
  call heltable([8,32,256], n3(:,5153), t3x256(:,:,3521))
  call heltable([16,16,256], n3(:,5154), t3x256(:,:,3522))
  call heltable([8,32,256], n3(:,5155), t3x256(:,:,3523))
  call heltable([16,16,256], n3(:,5156), t3x256(:,:,3524))
  call heltable([8,32,256], n3(:,5157), t3x256(:,:,3525))
  call heltable([8,32,256], n3(:,5158), t3x256(:,:,3526))
  call heltable([8,32,256], n3(:,5159), t3x256(:,:,3527))
  call heltable([8,32,256], n3(:,5160), t3x256(:,:,3528))

  heltables_not_init = .false.

end subroutine init_heltables

end module ol_heltables_OLR_ppllnnjj_ew_nexnmxemuudxdx_3
