
! **********************************************************************
module ol_heltables_ppllnnjj_ew_nexnmxemuudxdx_3
! **********************************************************************
  use KIND_TYPES, only: intkind2
  implicit none

  logical :: heltables_not_init = .true.

  ! helicity states of external particles
  ! integer, save :: &
  !   H1(2) = [-1,1], &
  !   H2(3) = [-1,0,1]
  !   ...
  integer, save :: &
    H1(2) = [-1,1], &
    H2(2) = [-1,1], &
    H3(2) = [-1,1], &
    H4(2) = [-1,1], &
    H5(2) = [-1,1], &
    H6(2) = [-1,1], &
    H7(2) = [-1,1], &
    H8(2) = [-1,1]

  ! number of helicity states for wave functions returned by a propagator call: n2(sz)
  ! number of helicity states for wave functions in a v-point vertex call (v >= 3)
  ! or a contraction (v = 3): n<v>(v,sz)
  integer(intkind2), save :: n2(24), n3(3,320), n4(4,2)

  ! helicity tables used in the construction of the h helicity states of a wave function (amplitude)
  ! from an v-point vertex (contraction): t<v>x<h>(v-1,h,sz)
  integer(intkind2), save :: t3x4(2,4,6), t3x32(2,32,16), t3x8(2,8,24), t3x16(2,16,72), t3x256(2,256,202), t4x64(3,64,2)

  ! change of global-helicity state resulting from flip of individual-particle helicity
  integer(intkind2), save :: eflip(256,8)
  integer,           save :: exthel(256,8)
  integer,           save :: firstpol(8)

  contains

! **********************************************************************
subroutine init_heltables
! **********************************************************************
  use ol_helicity_init, only: heltable
  implicit none

  ! I/O helicity tables for vertices, propagators and contractions;
  ! helicity table for a vertex call: n_in/n_out are the number helicity states of the incoming/outgoing wave functions
  ! call heltable([<n_in1>, <n_in2>, ..., <n_out>], n, t)
  ! propagators only need the number of helicity configurations which is equal for the incoming and outgoing wave function
  ! n = <n>
  call heltable([2,2,4], n3(:,1), t3x4(:,:,1))
  call heltable([2,2,4], n3(:,2), t3x4(:,:,2))
  call heltable([2,2,4], n3(:,3), t3x4(:,:,3))
  call heltable([2,2,4], n3(:,4), t3x4(:,:,4))
  call heltable([4,4,4,64], n4(:,1), t4x64(:,:,1))
  call heltable([2,2,4], n3(:,5), t3x4(:,:,5))
  call heltable([2,2,4], n3(:,6), t3x4(:,:,6))
  call heltable([4,4,4,64], n4(:,2), t4x64(:,:,2))
  call heltable([4,4,16], n3(:,7), t3x16(:,:,1))
  call heltable([4,4,16], n3(:,8), t3x16(:,:,2))
  call heltable([4,4,16], n3(:,9), t3x16(:,:,3))
  call heltable([4,4,16], n3(:,10), t3x16(:,:,4))
  call heltable([4,4,16], n3(:,11), t3x16(:,:,5))
  call heltable([4,4,16], n3(:,12), t3x16(:,:,6))
  call heltable([4,4,16], n3(:,13), t3x16(:,:,7))
  call heltable([4,4,16], n3(:,14), t3x16(:,:,8))
  call heltable([4,2,8], n3(:,15), t3x8(:,:,1))
  call heltable([2,4,8], n3(:,16), t3x8(:,:,2))
  n2(1) = 8
  n2(2) = 8
  call heltable([4,8,32], n3(:,17), t3x32(:,:,1))
  call heltable([8,2,16], n3(:,18), t3x16(:,:,9))
  call heltable([8,2,16], n3(:,19), t3x16(:,:,10))
  call heltable([4,2,8], n3(:,20), t3x8(:,:,3))
  call heltable([2,4,8], n3(:,21), t3x8(:,:,4))
  n2(3) = 8
  n2(4) = 8
  call heltable([4,8,32], n3(:,22), t3x32(:,:,2))
  call heltable([2,8,16], n3(:,23), t3x16(:,:,11))
  call heltable([2,8,16], n3(:,24), t3x16(:,:,12))
  call heltable([8,2,16], n3(:,25), t3x16(:,:,13))
  call heltable([8,2,16], n3(:,26), t3x16(:,:,14))
  call heltable([2,8,16], n3(:,27), t3x16(:,:,15))
  call heltable([2,8,16], n3(:,28), t3x16(:,:,16))
  call heltable([4,4,16], n3(:,29), t3x16(:,:,17))
  call heltable([4,4,16], n3(:,30), t3x16(:,:,18))
  call heltable([4,4,16], n3(:,31), t3x16(:,:,19))
  call heltable([4,4,16], n3(:,32), t3x16(:,:,20))
  call heltable([4,4,16], n3(:,33), t3x16(:,:,21))
  call heltable([4,4,16], n3(:,34), t3x16(:,:,22))
  call heltable([4,4,16], n3(:,35), t3x16(:,:,23))
  call heltable([4,4,16], n3(:,36), t3x16(:,:,24))
  call heltable([4,2,8], n3(:,37), t3x8(:,:,5))
  n2(5) = 8
  call heltable([4,8,32], n3(:,38), t3x32(:,:,3))
  call heltable([8,2,16], n3(:,39), t3x16(:,:,25))
  call heltable([8,2,16], n3(:,40), t3x16(:,:,26))
  call heltable([4,2,8], n3(:,41), t3x8(:,:,6))
  n2(6) = 8
  call heltable([4,8,32], n3(:,42), t3x32(:,:,4))
  call heltable([2,8,16], n3(:,43), t3x16(:,:,27))
  call heltable([2,8,16], n3(:,44), t3x16(:,:,28))
  call heltable([8,2,16], n3(:,45), t3x16(:,:,29))
  call heltable([8,2,16], n3(:,46), t3x16(:,:,30))
  call heltable([2,8,16], n3(:,47), t3x16(:,:,31))
  call heltable([2,8,16], n3(:,48), t3x16(:,:,32))
  call heltable([2,4,8], n3(:,49), t3x8(:,:,7))
  n2(7) = 8
  call heltable([4,8,32], n3(:,50), t3x32(:,:,5))
  call heltable([8,2,16], n3(:,51), t3x16(:,:,33))
  call heltable([8,2,16], n3(:,52), t3x16(:,:,34))
  call heltable([2,4,8], n3(:,53), t3x8(:,:,8))
  n2(8) = 8
  call heltable([4,8,32], n3(:,54), t3x32(:,:,6))
  call heltable([2,8,16], n3(:,55), t3x16(:,:,35))
  call heltable([2,8,16], n3(:,56), t3x16(:,:,36))
  call heltable([8,2,16], n3(:,57), t3x16(:,:,37))
  call heltable([8,2,16], n3(:,58), t3x16(:,:,38))
  call heltable([2,8,16], n3(:,59), t3x16(:,:,39))
  call heltable([2,8,16], n3(:,60), t3x16(:,:,40))
  call heltable([4,8,32], n3(:,61), t3x32(:,:,7))
  call heltable([8,2,16], n3(:,62), t3x16(:,:,41))
  call heltable([8,2,16], n3(:,63), t3x16(:,:,42))
  call heltable([4,8,32], n3(:,64), t3x32(:,:,8))
  call heltable([2,8,16], n3(:,65), t3x16(:,:,43))
  call heltable([2,8,16], n3(:,66), t3x16(:,:,44))
  call heltable([8,2,16], n3(:,67), t3x16(:,:,45))
  call heltable([8,2,16], n3(:,68), t3x16(:,:,46))
  call heltable([2,8,16], n3(:,69), t3x16(:,:,47))
  call heltable([2,8,16], n3(:,70), t3x16(:,:,48))
  call heltable([2,4,8], n3(:,71), t3x8(:,:,9))
  n2(9) = 8
  call heltable([2,8,16], n3(:,72), t3x16(:,:,49))
  call heltable([2,8,16], n3(:,73), t3x16(:,:,50))
  call heltable([2,4,8], n3(:,74), t3x8(:,:,10))
  n2(10) = 8
  call heltable([2,8,16], n3(:,75), t3x16(:,:,51))
  call heltable([2,8,16], n3(:,76), t3x16(:,:,52))
  call heltable([4,2,8], n3(:,77), t3x8(:,:,11))
  n2(11) = 8
  call heltable([8,2,16], n3(:,78), t3x16(:,:,53))
  call heltable([4,2,8], n3(:,79), t3x8(:,:,12))
  n2(12) = 8
  call heltable([8,2,16], n3(:,80), t3x16(:,:,54))
  call heltable([8,4,32], n3(:,81), t3x32(:,:,9))
  call heltable([8,4,32], n3(:,82), t3x32(:,:,10))
  call heltable([2,4,8], n3(:,83), t3x8(:,:,13))
  n2(13) = 8
  call heltable([2,8,16], n3(:,84), t3x16(:,:,55))
  call heltable([2,8,16], n3(:,85), t3x16(:,:,56))
  call heltable([2,4,8], n3(:,86), t3x8(:,:,14))
  n2(14) = 8
  call heltable([2,8,16], n3(:,87), t3x16(:,:,57))
  call heltable([2,8,16], n3(:,88), t3x16(:,:,58))
  call heltable([4,2,8], n3(:,89), t3x8(:,:,15))
  n2(15) = 8
  call heltable([8,2,16], n3(:,90), t3x16(:,:,59))
  call heltable([4,2,8], n3(:,91), t3x8(:,:,16))
  n2(16) = 8
  call heltable([8,2,16], n3(:,92), t3x16(:,:,60))
  call heltable([8,4,32], n3(:,93), t3x32(:,:,11))
  call heltable([8,4,32], n3(:,94), t3x32(:,:,12))
  call heltable([2,4,8], n3(:,95), t3x8(:,:,17))
  n2(17) = 8
  call heltable([2,8,16], n3(:,96), t3x16(:,:,61))
  call heltable([2,8,16], n3(:,97), t3x16(:,:,62))
  call heltable([2,4,8], n3(:,98), t3x8(:,:,18))
  n2(18) = 8
  call heltable([2,8,16], n3(:,99), t3x16(:,:,63))
  call heltable([2,8,16], n3(:,100), t3x16(:,:,64))
  call heltable([4,2,8], n3(:,101), t3x8(:,:,19))
  n2(19) = 8
  call heltable([8,2,16], n3(:,102), t3x16(:,:,65))
  call heltable([4,2,8], n3(:,103), t3x8(:,:,20))
  n2(20) = 8
  call heltable([8,2,16], n3(:,104), t3x16(:,:,66))
  call heltable([8,4,32], n3(:,105), t3x32(:,:,13))
  call heltable([8,4,32], n3(:,106), t3x32(:,:,14))
  call heltable([2,4,8], n3(:,107), t3x8(:,:,21))
  n2(21) = 8
  call heltable([2,8,16], n3(:,108), t3x16(:,:,67))
  call heltable([2,8,16], n3(:,109), t3x16(:,:,68))
  call heltable([2,4,8], n3(:,110), t3x8(:,:,22))
  n2(22) = 8
  call heltable([2,8,16], n3(:,111), t3x16(:,:,69))
  call heltable([2,8,16], n3(:,112), t3x16(:,:,70))
  call heltable([4,2,8], n3(:,113), t3x8(:,:,23))
  n2(23) = 8
  call heltable([8,2,16], n3(:,114), t3x16(:,:,71))
  call heltable([4,2,8], n3(:,115), t3x8(:,:,24))
  n2(24) = 8
  call heltable([8,2,16], n3(:,116), t3x16(:,:,72))
  call heltable([8,4,32], n3(:,117), t3x32(:,:,15))
  call heltable([8,4,32], n3(:,118), t3x32(:,:,16))
  call heltable([4,64,256], n3(:,119), t3x256(:,:,1))
  call heltable([4,64,256], n3(:,120), t3x256(:,:,2))
  call heltable([16,16,256], n3(:,121), t3x256(:,:,3))
  call heltable([16,16,256], n3(:,122), t3x256(:,:,4))
  call heltable([16,16,256], n3(:,123), t3x256(:,:,5))
  call heltable([16,16,256], n3(:,124), t3x256(:,:,6))
  call heltable([16,16,256], n3(:,125), t3x256(:,:,7))
  call heltable([16,16,256], n3(:,126), t3x256(:,:,8))
  call heltable([8,32,256], n3(:,127), t3x256(:,:,9))
  call heltable([16,16,256], n3(:,128), t3x256(:,:,10))
  call heltable([16,16,256], n3(:,129), t3x256(:,:,11))
  call heltable([8,32,256], n3(:,130), t3x256(:,:,12))
  call heltable([16,16,256], n3(:,131), t3x256(:,:,13))
  call heltable([16,16,256], n3(:,132), t3x256(:,:,14))
  call heltable([16,16,256], n3(:,133), t3x256(:,:,15))
  call heltable([16,16,256], n3(:,134), t3x256(:,:,16))
  call heltable([16,16,256], n3(:,135), t3x256(:,:,17))
  call heltable([16,16,256], n3(:,136), t3x256(:,:,18))
  call heltable([16,16,256], n3(:,137), t3x256(:,:,19))
  call heltable([16,16,256], n3(:,138), t3x256(:,:,20))
  call heltable([16,16,256], n3(:,139), t3x256(:,:,21))
  call heltable([16,16,256], n3(:,140), t3x256(:,:,22))
  call heltable([16,16,256], n3(:,141), t3x256(:,:,23))
  call heltable([16,16,256], n3(:,142), t3x256(:,:,24))
  call heltable([8,32,256], n3(:,143), t3x256(:,:,25))
  call heltable([16,16,256], n3(:,144), t3x256(:,:,26))
  call heltable([16,16,256], n3(:,145), t3x256(:,:,27))
  call heltable([8,32,256], n3(:,146), t3x256(:,:,28))
  call heltable([16,16,256], n3(:,147), t3x256(:,:,29))
  call heltable([16,16,256], n3(:,148), t3x256(:,:,30))
  call heltable([16,16,256], n3(:,149), t3x256(:,:,31))
  call heltable([16,16,256], n3(:,150), t3x256(:,:,32))
  call heltable([16,16,256], n3(:,151), t3x256(:,:,33))
  call heltable([16,16,256], n3(:,152), t3x256(:,:,34))
  call heltable([8,32,256], n3(:,153), t3x256(:,:,35))
  call heltable([16,16,256], n3(:,154), t3x256(:,:,36))
  call heltable([16,16,256], n3(:,155), t3x256(:,:,37))
  call heltable([8,32,256], n3(:,156), t3x256(:,:,38))
  call heltable([16,16,256], n3(:,157), t3x256(:,:,39))
  call heltable([16,16,256], n3(:,158), t3x256(:,:,40))
  call heltable([16,16,256], n3(:,159), t3x256(:,:,41))
  call heltable([16,16,256], n3(:,160), t3x256(:,:,42))
  call heltable([16,16,256], n3(:,161), t3x256(:,:,43))
  call heltable([16,16,256], n3(:,162), t3x256(:,:,44))
  call heltable([8,32,256], n3(:,163), t3x256(:,:,45))
  call heltable([16,16,256], n3(:,164), t3x256(:,:,46))
  call heltable([16,16,256], n3(:,165), t3x256(:,:,47))
  call heltable([8,32,256], n3(:,166), t3x256(:,:,48))
  call heltable([16,16,256], n3(:,167), t3x256(:,:,49))
  call heltable([16,16,256], n3(:,168), t3x256(:,:,50))
  call heltable([16,16,256], n3(:,169), t3x256(:,:,51))
  call heltable([16,16,256], n3(:,170), t3x256(:,:,52))
  call heltable([16,16,256], n3(:,171), t3x256(:,:,53))
  call heltable([16,16,256], n3(:,172), t3x256(:,:,54))
  call heltable([16,16,256], n3(:,173), t3x256(:,:,55))
  call heltable([16,16,256], n3(:,174), t3x256(:,:,56))
  call heltable([16,16,256], n3(:,175), t3x256(:,:,57))
  call heltable([16,16,256], n3(:,176), t3x256(:,:,58))
  call heltable([16,16,256], n3(:,177), t3x256(:,:,59))
  call heltable([16,16,256], n3(:,178), t3x256(:,:,60))
  call heltable([16,16,256], n3(:,179), t3x256(:,:,61))
  call heltable([16,16,256], n3(:,180), t3x256(:,:,62))
  call heltable([16,16,256], n3(:,181), t3x256(:,:,63))
  call heltable([16,16,256], n3(:,182), t3x256(:,:,64))
  call heltable([16,16,256], n3(:,183), t3x256(:,:,65))
  call heltable([16,16,256], n3(:,184), t3x256(:,:,66))
  call heltable([16,16,256], n3(:,185), t3x256(:,:,67))
  call heltable([16,16,256], n3(:,186), t3x256(:,:,68))
  call heltable([16,16,256], n3(:,187), t3x256(:,:,69))
  call heltable([16,16,256], n3(:,188), t3x256(:,:,70))
  call heltable([16,16,256], n3(:,189), t3x256(:,:,71))
  call heltable([16,16,256], n3(:,190), t3x256(:,:,72))
  call heltable([16,16,256], n3(:,191), t3x256(:,:,73))
  call heltable([16,16,256], n3(:,192), t3x256(:,:,74))
  call heltable([16,16,256], n3(:,193), t3x256(:,:,75))
  call heltable([16,16,256], n3(:,194), t3x256(:,:,76))
  call heltable([16,16,256], n3(:,195), t3x256(:,:,77))
  call heltable([16,16,256], n3(:,196), t3x256(:,:,78))
  call heltable([16,16,256], n3(:,197), t3x256(:,:,79))
  call heltable([16,16,256], n3(:,198), t3x256(:,:,80))
  call heltable([16,16,256], n3(:,199), t3x256(:,:,81))
  call heltable([16,16,256], n3(:,200), t3x256(:,:,82))
  call heltable([16,16,256], n3(:,201), t3x256(:,:,83))
  call heltable([16,16,256], n3(:,202), t3x256(:,:,84))
  call heltable([16,16,256], n3(:,203), t3x256(:,:,85))
  call heltable([16,16,256], n3(:,204), t3x256(:,:,86))
  call heltable([16,16,256], n3(:,205), t3x256(:,:,87))
  call heltable([16,16,256], n3(:,206), t3x256(:,:,88))
  call heltable([16,16,256], n3(:,207), t3x256(:,:,89))
  call heltable([16,16,256], n3(:,208), t3x256(:,:,90))
  call heltable([16,16,256], n3(:,209), t3x256(:,:,91))
  call heltable([16,16,256], n3(:,210), t3x256(:,:,92))
  call heltable([16,16,256], n3(:,211), t3x256(:,:,93))
  call heltable([16,16,256], n3(:,212), t3x256(:,:,94))
  call heltable([16,16,256], n3(:,213), t3x256(:,:,95))
  call heltable([16,16,256], n3(:,214), t3x256(:,:,96))
  call heltable([16,16,256], n3(:,215), t3x256(:,:,97))
  call heltable([16,16,256], n3(:,216), t3x256(:,:,98))
  call heltable([16,16,256], n3(:,217), t3x256(:,:,99))
  call heltable([16,16,256], n3(:,218), t3x256(:,:,100))
  call heltable([16,16,256], n3(:,219), t3x256(:,:,101))
  call heltable([16,16,256], n3(:,220), t3x256(:,:,102))
  call heltable([16,16,256], n3(:,221), t3x256(:,:,103))
  call heltable([16,16,256], n3(:,222), t3x256(:,:,104))
  call heltable([16,16,256], n3(:,223), t3x256(:,:,105))
  call heltable([16,16,256], n3(:,224), t3x256(:,:,106))
  call heltable([16,16,256], n3(:,225), t3x256(:,:,107))
  call heltable([16,16,256], n3(:,226), t3x256(:,:,108))
  call heltable([8,32,256], n3(:,227), t3x256(:,:,109))
  call heltable([8,32,256], n3(:,228), t3x256(:,:,110))
  call heltable([16,16,256], n3(:,229), t3x256(:,:,111))
  call heltable([16,16,256], n3(:,230), t3x256(:,:,112))
  call heltable([16,16,256], n3(:,231), t3x256(:,:,113))
  call heltable([16,16,256], n3(:,232), t3x256(:,:,114))
  call heltable([16,16,256], n3(:,233), t3x256(:,:,115))
  call heltable([16,16,256], n3(:,234), t3x256(:,:,116))
  call heltable([16,16,256], n3(:,235), t3x256(:,:,117))
  call heltable([16,16,256], n3(:,236), t3x256(:,:,118))
  call heltable([16,16,256], n3(:,237), t3x256(:,:,119))
  call heltable([16,16,256], n3(:,238), t3x256(:,:,120))
  call heltable([16,16,256], n3(:,239), t3x256(:,:,121))
  call heltable([16,16,256], n3(:,240), t3x256(:,:,122))
  call heltable([8,32,256], n3(:,241), t3x256(:,:,123))
  call heltable([8,32,256], n3(:,242), t3x256(:,:,124))
  call heltable([16,16,256], n3(:,243), t3x256(:,:,125))
  call heltable([16,16,256], n3(:,244), t3x256(:,:,126))
  call heltable([16,16,256], n3(:,245), t3x256(:,:,127))
  call heltable([16,16,256], n3(:,246), t3x256(:,:,128))
  call heltable([16,16,256], n3(:,247), t3x256(:,:,129))
  call heltable([16,16,256], n3(:,248), t3x256(:,:,130))
  call heltable([16,16,256], n3(:,249), t3x256(:,:,131))
  call heltable([16,16,256], n3(:,250), t3x256(:,:,132))
  call heltable([16,16,256], n3(:,251), t3x256(:,:,133))
  call heltable([16,16,256], n3(:,252), t3x256(:,:,134))
  call heltable([16,16,256], n3(:,253), t3x256(:,:,135))
  call heltable([16,16,256], n3(:,254), t3x256(:,:,136))
  call heltable([16,16,256], n3(:,255), t3x256(:,:,137))
  call heltable([16,16,256], n3(:,256), t3x256(:,:,138))
  call heltable([16,16,256], n3(:,257), t3x256(:,:,139))
  call heltable([16,16,256], n3(:,258), t3x256(:,:,140))
  call heltable([16,16,256], n3(:,259), t3x256(:,:,141))
  call heltable([16,16,256], n3(:,260), t3x256(:,:,142))
  call heltable([16,16,256], n3(:,261), t3x256(:,:,143))
  call heltable([16,16,256], n3(:,262), t3x256(:,:,144))
  call heltable([16,16,256], n3(:,263), t3x256(:,:,145))
  call heltable([16,16,256], n3(:,264), t3x256(:,:,146))
  call heltable([16,16,256], n3(:,265), t3x256(:,:,147))
  call heltable([16,16,256], n3(:,266), t3x256(:,:,148))
  call heltable([8,32,256], n3(:,267), t3x256(:,:,149))
  call heltable([8,32,256], n3(:,268), t3x256(:,:,150))
  call heltable([16,16,256], n3(:,269), t3x256(:,:,151))
  call heltable([16,16,256], n3(:,270), t3x256(:,:,152))
  call heltable([16,16,256], n3(:,271), t3x256(:,:,153))
  call heltable([16,16,256], n3(:,272), t3x256(:,:,154))
  call heltable([16,16,256], n3(:,273), t3x256(:,:,155))
  call heltable([16,16,256], n3(:,274), t3x256(:,:,156))
  call heltable([16,16,256], n3(:,275), t3x256(:,:,157))
  call heltable([16,16,256], n3(:,276), t3x256(:,:,158))
  call heltable([16,16,256], n3(:,277), t3x256(:,:,159))
  call heltable([16,16,256], n3(:,278), t3x256(:,:,160))
  call heltable([16,16,256], n3(:,279), t3x256(:,:,161))
  call heltable([16,16,256], n3(:,280), t3x256(:,:,162))
  call heltable([8,32,256], n3(:,281), t3x256(:,:,163))
  call heltable([8,32,256], n3(:,282), t3x256(:,:,164))
  call heltable([16,16,256], n3(:,283), t3x256(:,:,165))
  call heltable([16,16,256], n3(:,284), t3x256(:,:,166))
  call heltable([16,16,256], n3(:,285), t3x256(:,:,167))
  call heltable([16,16,256], n3(:,286), t3x256(:,:,168))
  call heltable([16,16,256], n3(:,287), t3x256(:,:,169))
  call heltable([16,16,256], n3(:,288), t3x256(:,:,170))
  call heltable([16,16,256], n3(:,289), t3x256(:,:,171))
  call heltable([16,16,256], n3(:,290), t3x256(:,:,172))
  call heltable([16,16,256], n3(:,291), t3x256(:,:,173))
  call heltable([16,16,256], n3(:,292), t3x256(:,:,174))
  call heltable([16,16,256], n3(:,293), t3x256(:,:,175))
  call heltable([16,16,256], n3(:,294), t3x256(:,:,176))
  call heltable([16,16,256], n3(:,295), t3x256(:,:,177))
  call heltable([16,16,256], n3(:,296), t3x256(:,:,178))
  call heltable([16,16,256], n3(:,297), t3x256(:,:,179))
  call heltable([16,16,256], n3(:,298), t3x256(:,:,180))
  call heltable([16,16,256], n3(:,299), t3x256(:,:,181))
  call heltable([16,16,256], n3(:,300), t3x256(:,:,182))
  call heltable([16,16,256], n3(:,301), t3x256(:,:,183))
  call heltable([16,16,256], n3(:,302), t3x256(:,:,184))
  call heltable([16,16,256], n3(:,303), t3x256(:,:,185))
  call heltable([16,16,256], n3(:,304), t3x256(:,:,186))
  call heltable([16,16,256], n3(:,305), t3x256(:,:,187))
  call heltable([16,16,256], n3(:,306), t3x256(:,:,188))
  call heltable([16,16,256], n3(:,307), t3x256(:,:,189))
  call heltable([16,16,256], n3(:,308), t3x256(:,:,190))
  call heltable([16,16,256], n3(:,309), t3x256(:,:,191))
  call heltable([16,16,256], n3(:,310), t3x256(:,:,192))
  call heltable([16,16,256], n3(:,311), t3x256(:,:,193))
  call heltable([16,16,256], n3(:,312), t3x256(:,:,194))
  call heltable([16,16,256], n3(:,313), t3x256(:,:,195))
  call heltable([16,16,256], n3(:,314), t3x256(:,:,196))
  call heltable([16,16,256], n3(:,315), t3x256(:,:,197))
  call heltable([16,16,256], n3(:,316), t3x256(:,:,198))
  call heltable([16,16,256], n3(:,317), t3x256(:,:,199))
  call heltable([16,16,256], n3(:,318), t3x256(:,:,200))
  call heltable([16,16,256], n3(:,319), t3x256(:,:,201))
  call heltable([16,16,256], n3(:,320), t3x256(:,:,202))

  heltables_not_init = .false.

end subroutine init_heltables

end module ol_heltables_ppllnnjj_ew_nexnmxemuudxdx_3
