
module ol_vamp_1_ppllllj_nmeexmxuxdg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllllj_nmeexmxuxdg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllllj_nmeexmxuxdg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppllllj_nmeexmxuxdg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppllllj_nmeexmxuxdg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppllllj_nmeexmxuxdg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppllllj_nmeexmxuxdg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1),h0tab(:,1),[64,6,9,32,16],[0,0,0,0,0],5,2,wf4(:,2),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1),heltab2x128(:,:,1))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(1),n2h64(1))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(2),h0tab(:,2),[64,6,9,32,16],[0,0,0,0,0],5,2,wf4(:,7),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,2),heltab2x128(:,:,2))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(2),n2h64(2))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(3),h0tab(:,3),[64,9,6,32,16],[0,0,0,0,0],5,2,wf4(:,4),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,3),heltab2x128(:,:,3))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(3),n2h64(3))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(4),h0tab(:,4),[64,9,6,32,16],[0,0,0,0,0],5,2,wf4(:,4),wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,4),heltab2x128(:,:,4))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(4),n2h64(4))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(5),h0tab(:,5),[64,6,9,16,32],[0,0,0,0,0],5,2,wf4(:,2),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,5),heltab2x128(:,:,5))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(5),n2h64(5))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(6),h0tab(:,6),[64,6,9,16,32],[0,0,0,0,0],5,2,wf4(:,7),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,6),heltab2x128(:,:,6))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(6),n2h64(6))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(7),h0tab(:,7),[64,6,32,16,9],[0,0,0,0,0],5,2,wf4(:,2),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,7),heltab2x128(:,:,7))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(7),n2h64(7))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(8),h0tab(:,8),[64,6,32,16,9],[0,0,0,0,0],5,2,wf4(:,7),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,8),heltab2x128(:,:,8))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(8),n2h64(8))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(9),h0tab(:,9),[64,9,6,16,32],[0,0,0,0,0],5,2,wf4(:,4),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,9),heltab2x128(:,:,9))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(9),n2h64(9))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(10),h0tab(:,10),[64,9,6,16,32],[0,0,0,0,0],5,2,wf4(:,4),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,10),heltab2x128(:,:,10))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(10),n2h64(10))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(11),h0tab(:,11),[64,6,16,32,9],[0,0,0,0,0],5,2,wf4(:,2),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,11),heltab2x128(:,:,11))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(11),n2h64(11))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(12),h0tab(:,12),[64,6,16,32,9],[0,0,0,0,0],5,2,wf4(:,7),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,12),heltab2x128(:,:,12))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(12),n2h64(12))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(13),h0tab(:,13),[64,16,9,6,32],[0,0,0,0,0],5,2,wf4(:,4),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(13),m3h2x64(:,13),heltab2x128(:,:,13))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(14),h0tab(:,14),[64,16,9,6,32],[0,0,0,0,0],5,2,wf4(:,4),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(14),m3h2x64(:,14),heltab2x128(:,:,14))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(15),h0tab(:,15),[64,16,6,9,32],[0,0,0,0,0],5,2,wf4(:,2),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(15),m3h2x64(:,15),heltab2x128(:,:,15))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(16),h0tab(:,16),[64,16,6,9,32],[0,0,0,0,0],5,2,wf4(:,7),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(16),m3h2x64(:,16),heltab2x128(:,:,16))
  call Hloop_AV_Q(ntryL,G1H64(1),wf4(:,2),G1H16(1),m3h4x16(:,1),heltab2x64(:,:,1))
  call Hloop_A_Q(ntryL,G1H16(1),70,0,G2H16(1),n2h16(1))
  call Hloop_AZ_Q(ntryL,G1H64(2),wf4(:,7),G1H16(1),ngZu,m3h4x16(:,2),heltab2x64(:,:,2))
  call Hloop_A_Q(ntryL,G1H16(1),70,0,G2H16(2),n2h16(2))
  call Hloop_AW_Q(ntryL,G1H64(3),wf4(:,4),G1H16(1),m3h4x16(:,3),heltab2x64(:,:,3))
  call Hloop_A_Q(ntryL,G1H16(1),73,0,G2H16(3),n2h16(3))
  call Hloop_AW_Q(ntryL,G1H64(4),wf4(:,4),G1H16(1),m3h4x16(:,4),heltab2x64(:,:,4))
  call Hloop_A_Q(ntryL,G1H16(1),73,0,G2H16(4),n2h16(4))
  call Hloop_QV_A(ntryL,G1H64(5),wf4(:,2),G1H16(1),m3h4x16(:,5),heltab2x64(:,:,5))
  call Hloop_Q_A(ntryL,G1H16(1),70,0,G2H16(5),n2h16(5))
  call Hloop_QZ_A(ntryL,G1H64(6),wf4(:,7),G1H16(1),ngZd,m3h4x16(:,6),heltab2x64(:,:,6))
  call Hloop_Q_A(ntryL,G1H16(1),70,0,G2H16(6),n2h16(6))
  call Hloop_AV_Q(ntryL,G1H64(7),wf4(:,2),G1H16(1),m3h4x16(:,7),heltab2x64(:,:,7))
  call Hloop_A_Q(ntryL,G1H16(1),70,0,G2H16(7),n2h16(7))
  call Hloop_AZ_Q(ntryL,G1H64(8),wf4(:,7),G1H16(1),ngZd,m3h4x16(:,8),heltab2x64(:,:,8))
  call Hloop_A_Q(ntryL,G1H16(1),70,0,G2H16(8),n2h16(8))
  call Hloop_QW_A(ntryL,G1H64(9),wf4(:,4),G1H16(1),m3h4x16(:,9),heltab2x64(:,:,9))
  call Hloop_Q_A(ntryL,G1H16(1),73,0,G2H16(9),n2h16(9))
  call Hloop_QW_A(ntryL,G1H64(10),wf4(:,4),G1H16(1),m3h4x16(:,10),heltab2x64(:,:,10))
  call Hloop_Q_A(ntryL,G1H16(1),73,0,G2H16(10),n2h16(10))
  call Hloop_QV_A(ntryL,G1H64(11),wf4(:,2),G1H16(1),m3h4x16(:,11),heltab2x64(:,:,11))
  call Hloop_Q_A(ntryL,G1H16(1),70,0,G2H16(11),n2h16(11))
  call Hloop_QZ_A(ntryL,G1H64(12),wf4(:,7),G1H16(1),ngZu,m3h4x16(:,12),heltab2x64(:,:,12))
  call Hloop_Q_A(ntryL,G1H16(1),70,0,G2H16(12),n2h16(12))
  call Hloop_VA_Q(ntryL,G1H64(13),ex5(:),G1H32(1),m3h2x32(:,1),heltab2x64(:,:,13))
  call Hloop_A_Q(ntryL,G1H32(1),80,0,G2H32(1),n2h32(1))
  call Hloop_VA_Q(ntryL,G1H64(14),ex5(:),G1H32(1),m3h2x32(:,2),heltab2x64(:,:,14))
  call Hloop_A_Q(ntryL,G1H32(1),80,0,G2H32(2),n2h32(2))
  call Hloop_VA_Q(ntryL,G1H64(15),ex5(:),G1H32(1),m3h2x32(:,3),heltab2x64(:,:,15))
  call Hloop_A_Q(ntryL,G1H32(1),80,0,G2H32(3),n2h32(3))
  call Hloop_VA_Q(ntryL,G1H64(16),ex5(:),G1H32(1),m3h2x32(:,4),heltab2x64(:,:,16))
  call Hloop_A_Q(ntryL,G1H32(1),80,0,G2H32(4),n2h32(4))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(2),[G2H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(6),[G2H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(8),[G2H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(12),[G2H16(11)])
  call Hotf_5pt_reduction(G2H16(2),RedSet_5(1),mass5set(:,1),  & 
G1H16(1),G1H16(2),G1H16(3),G1H16(4),G1H16(5),G1H16(6),16)
  call HG1shiftOLR(G1H16(2),16,16)
  call Hotf_5pt_reduction(G2H16(3),RedSet_5(2),mass5set(:,1),  & 
G1H16(7),G1H16(8),G1H16(9),G1H16(10),G1H16(11),G1H16(12),16)
  call HG1shiftOLR(G1H16(8),16,16)
  call Hotf_5pt_reduction(G2H16(4),RedSet_5(2),mass5set(:,1),  & 
G1H16(13),G1H16(14),G1H16(15),G1H16(16),G1H16(17),G1H16(18),16)
  call HG1shiftOLR(G1H16(14),16,16)
  call Hotf_5pt_reduction(G2H16(6),RedSet_5(3),mass5set(:,1),  & 
G1H16(19),G1H16(20),G1H16(21),G1H16(22),G1H16(23),G1H16(24),16)
  call HG1shiftOLR(G1H16(20),32,16)
  call Hloop_AQ_V(ntryL,G2H16(8),ex6(:),G2H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hotf_5pt_reduction(G2H16(9),RedSet_5(4),mass5set(:,1),  & 
G1H16(25),G1H16(26),G1H16(27),G1H16(28),G1H16(29),G1H16(30),16)
  call HG1shiftOLR(G1H16(26),32,16)
  call Hotf_5pt_reduction(G2H16(10),RedSet_5(4),mass5set(:,1),  & 
G1H16(31),G1H16(32),G1H16(33),G1H16(34),G1H16(35),G1H16(36),16)
  call HG1shiftOLR(G1H16(32),32,16)
  call Hloop_QA_V(ntryL,G2H16(12),ex5(:),G2H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hotf_5pt_reduction(G2H32(1),RedSet_5(5),mass5set(:,1),  & 
G1H32(1),G1H32(2),G1H32(3),G1H32(4),G1H32(5),G1H32(6),32)
  call HG1shiftOLR(G1H32(2),32,32)
  call Hotf_5pt_reduction(G2H32(2),RedSet_5(5),mass5set(:,1),  & 
G1H32(7),G1H32(8),G1H32(9),G1H32(10),G1H32(11),G1H32(12),32)
  call HG1shiftOLR(G1H32(8),32,32)
  call Hotf_5pt_reduction(G2H32(3),RedSet_5(6),mass5set(:,1),  & 
G1H32(13),G1H32(14),G1H32(15),G1H32(16),G1H32(17),G1H32(18),32)
  call HG1shiftOLR(G1H32(14),32,32)
  call Hotf_5pt_reduction(G2H32(4),RedSet_5(6),mass5set(:,1),  & 
G1H32(19),G1H32(20),G1H32(21),G1H32(22),G1H32(23),G1H32(24),32)
  call HG1shiftOLR(G1H32(20),32,32)
  call Hloop_AW_Q(ntryL,G1H16(1),wf4(:,4),G1H4(1),m3h4x4(:,1),heltab2x16(:,:,3))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(1),n2h4(1))
call HGT_OLR(G1H16(2),1,1,16)
call HGT_invQ_OLR(G1H16(2),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(2),-16,0,G2H16(1),n2h16(13))
  call Hloop_QA_V(ntryL,G2H16(1),ex5(:),G2H8(3),m3h2x8(:,3),heltab2x16(:,:,4))
  call Hloop_AW_Q(ntryL,G1H16(4),wf4(:,4),G1H4(1),m3h4x4(:,2),heltab2x16(:,:,5))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(2),n2h4(2))
  call Hloop_AW_Q(ntryL,G1H16(5),wf4(:,4),G1H4(1),m3h4x4(:,3),heltab2x16(:,:,6))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(3),n2h4(3))
  call Hloop_AW_Q(ntryL,G1H16(6),wf4(:,4),G1H4(1),m3h4x4(:,4),heltab2x16(:,:,7))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(4),n2h4(4))
  call Hloop_AV_Q(ntryL,G1H16(7),wf4(:,2),G1H4(1),m3h4x4(:,5),heltab2x16(:,:,8))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(5),n2h4(5))
call HGT_OLR(G1H16(8),1,1,16)
call HGT_invQ_OLR(G1H16(8),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(8),-16,0,G2H16(5),n2h16(14))
  call Hloop_QA_V(ntryL,G2H16(5),ex5(:),G2H8(4),m3h2x8(:,4),heltab2x16(:,:,9))
  call Hloop_AV_Q(ntryL,G1H16(10),wf4(:,2),G1H4(1),m3h4x4(:,6),heltab2x16(:,:,10))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(6),n2h4(6))
  call Hloop_AV_Q(ntryL,G1H16(11),wf4(:,2),G1H4(1),m3h4x4(:,7),heltab2x16(:,:,11))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(7),n2h4(7))
  call Hloop_AV_Q(ntryL,G1H16(12),wf4(:,2),G1H4(1),m3h4x4(:,8),heltab2x16(:,:,12))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(8),n2h4(8))
  call Hloop_AZ_Q(ntryL,G1H16(13),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,9),heltab2x16(:,:,13))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(9),n2h4(9))
call HGT_OLR(G1H16(14),1,1,16)
call HGT_invQ_OLR(G1H16(14),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(14),-16,0,G2H16(7),n2h16(15))
  call Hloop_QA_V(ntryL,G2H16(7),ex5(:),G2H8(5),m3h2x8(:,5),heltab2x16(:,:,14))
  call Hloop_AZ_Q(ntryL,G1H16(16),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,10),heltab2x16(:,:,15))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(10),n2h4(10))
  call Hloop_AZ_Q(ntryL,G1H16(17),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,11),heltab2x16(:,:,16))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(11),n2h4(11))
  call Hloop_AZ_Q(ntryL,G1H16(18),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,12),heltab2x16(:,:,17))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(12),n2h4(12))
  call Hloop_QW_A(ntryL,G1H16(19),wf4(:,4),G1H4(1),m3h4x4(:,13),heltab2x16(:,:,18))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(13),n2h4(13))
call HGT_OLR(G1H16(20),1,1,16)
call HGT_invQ_OLR(G1H16(20),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(20),-32,0,G2H16(11),n2h16(16))
  call Hloop_AQ_V(ntryL,G2H16(11),ex6(:),G2H8(6),m3h2x8(:,6),heltab2x16(:,:,19))
  call Hloop_QW_A(ntryL,G1H16(22),wf4(:,4),G1H4(1),m3h4x4(:,14),heltab2x16(:,:,20))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(14),n2h4(14))
  call Hloop_QW_A(ntryL,G1H16(23),wf4(:,4),G1H4(1),m3h4x4(:,15),heltab2x16(:,:,21))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(15),n2h4(15))
  call Hloop_QW_A(ntryL,G1H16(24),wf4(:,4),G1H4(1),m3h4x4(:,16),heltab2x16(:,:,22))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(16),n2h4(16))
  call Hloop_QV_A(ntryL,G1H16(25),wf4(:,2),G1H4(1),m3h4x4(:,17),heltab2x16(:,:,23))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(17),n2h4(17))
call HGT_OLR(G1H16(26),1,1,16)
call HGT_invQ_OLR(G1H16(26),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(26),-32,0,G2H16(2),n2h16(17))
  call Hloop_AQ_V(ntryL,G2H16(2),ex6(:),G2H8(7),m3h2x8(:,7),heltab2x16(:,:,24))
  call Hloop_QV_A(ntryL,G1H16(28),wf4(:,2),G1H4(1),m3h4x4(:,18),heltab2x16(:,:,25))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(18),n2h4(18))
  call Hloop_QV_A(ntryL,G1H16(29),wf4(:,2),G1H4(1),m3h4x4(:,19),heltab2x16(:,:,26))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(19),n2h4(19))
  call Hloop_QV_A(ntryL,G1H16(30),wf4(:,2),G1H4(1),m3h4x4(:,20),heltab2x16(:,:,27))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(20),n2h4(20))
  call Hloop_QZ_A(ntryL,G1H16(31),wf4(:,7),G1H4(1),ngZu,m3h4x4(:,21),heltab2x16(:,:,28))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(21),n2h4(21))
call HGT_OLR(G1H16(32),1,1,16)
call HGT_invQ_OLR(G1H16(32),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(32),-32,0,G2H16(3),n2h16(18))
  call Hloop_AQ_V(ntryL,G2H16(3),ex6(:),G2H8(8),m3h2x8(:,8),heltab2x16(:,:,29))
  call Hloop_QZ_A(ntryL,G1H16(34),wf4(:,7),G1H4(1),ngZu,m3h4x4(:,22),heltab2x16(:,:,30))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(22),n2h4(22))
  call Hloop_QZ_A(ntryL,G1H16(35),wf4(:,7),G1H4(1),ngZu,m3h4x4(:,23),heltab2x16(:,:,31))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(23),n2h4(23))
  call Hloop_QZ_A(ntryL,G1H16(36),wf4(:,7),G1H4(1),ngZu,m3h4x4(:,24),heltab2x16(:,:,32))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(24),n2h4(24))
  call Hloop_AW_Q(ntryL,G1H32(1),wf4(:,4),G1H8(1),m3h4x8(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(1),89,0,G2H8(9),n2h8(1))
call HGT_raise_alpha_OLR(G1H32(2),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(2),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(2),ex6(:),G1H16(1),m3h2x16(:,1),heltab2x32(:,:,2))
  call Hloop_AW_Q(ntryL,G1H32(4),wf4(:,4),G1H8(1),m3h4x8(:,2),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G1H8(1),89,0,G2H8(10),n2h8(2))
  call Hloop_AW_Q(ntryL,G1H32(5),wf4(:,4),G1H8(1),m3h4x8(:,3),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G1H8(1),89,0,G2H8(11),n2h8(3))
  call Hloop_AW_Q(ntryL,G1H32(6),wf4(:,4),G1H8(1),m3h4x8(:,4),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G1H8(1),89,0,G2H8(12),n2h8(4))
  call Hloop_AW_Q(ntryL,G1H32(7),wf4(:,4),G1H8(1),m3h4x8(:,5),heltab2x32(:,:,6))
  call Hloop_A_Q(ntryL,G1H8(1),89,0,G2H8(13),n2h8(5))
call HGT_raise_alpha_OLR(G1H32(8),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(8),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(8),ex6(:),G1H16(2),m3h2x16(:,2),heltab2x32(:,:,7))
  call Hloop_AW_Q(ntryL,G1H32(10),wf4(:,4),G1H8(1),m3h4x8(:,6),heltab2x32(:,:,8))
  call Hloop_A_Q(ntryL,G1H8(1),89,0,G2H8(14),n2h8(6))
  call Hloop_AW_Q(ntryL,G1H32(11),wf4(:,4),G1H8(1),m3h4x8(:,7),heltab2x32(:,:,9))
  call Hloop_A_Q(ntryL,G1H8(1),89,0,G2H8(15),n2h8(7))
  call Hloop_AW_Q(ntryL,G1H32(12),wf4(:,4),G1H8(1),m3h4x8(:,8),heltab2x32(:,:,10))
  call Hloop_A_Q(ntryL,G1H8(1),89,0,G2H8(16),n2h8(8))
  call Hloop_AV_Q(ntryL,G1H32(13),wf4(:,2),G1H8(1),m3h4x8(:,9),heltab2x32(:,:,11))
  call Hloop_A_Q(ntryL,G1H8(1),86,0,G2H8(17),n2h8(9))
call HGT_raise_alpha_OLR(G1H32(14),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(14),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(14),ex6(:),G1H16(4),m3h2x16(:,3),heltab2x32(:,:,12))
  call Hloop_AV_Q(ntryL,G1H32(16),wf4(:,2),G1H8(1),m3h4x8(:,10),heltab2x32(:,:,13))
  call Hloop_A_Q(ntryL,G1H8(1),86,0,G2H8(18),n2h8(10))
  call Hloop_AV_Q(ntryL,G1H32(17),wf4(:,2),G1H8(1),m3h4x8(:,11),heltab2x32(:,:,14))
  call Hloop_A_Q(ntryL,G1H8(1),86,0,G2H8(19),n2h8(11))
  call Hloop_AV_Q(ntryL,G1H32(18),wf4(:,2),G1H8(1),m3h4x8(:,12),heltab2x32(:,:,15))
  call Hloop_A_Q(ntryL,G1H8(1),86,0,G2H8(20),n2h8(12))
  call Hloop_AZ_Q(ntryL,G1H32(19),wf4(:,7),G1H8(1),ngZu,m3h4x8(:,13),heltab2x32(:,:,16))
  call Hloop_A_Q(ntryL,G1H8(1),86,0,G2H8(21),n2h8(13))
call HGT_raise_alpha_OLR(G1H32(20),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(20),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(20),ex6(:),G1H16(5),m3h2x16(:,4),heltab2x32(:,:,17))
  call Hloop_AZ_Q(ntryL,G1H32(22),wf4(:,7),G1H8(1),ngZu,m3h4x8(:,14),heltab2x32(:,:,18))
  call Hloop_A_Q(ntryL,G1H8(1),86,0,G2H8(22),n2h8(14))
  call Hloop_AZ_Q(ntryL,G1H32(23),wf4(:,7),G1H8(1),ngZu,m3h4x8(:,15),heltab2x32(:,:,19))
  call Hloop_A_Q(ntryL,G1H8(1),86,0,G2H8(23),n2h8(15))
  call Hloop_AZ_Q(ntryL,G1H32(24),wf4(:,7),G1H8(1),ngZu,m3h4x8(:,16),heltab2x32(:,:,20))
  call Hloop_A_Q(ntryL,G1H8(1),86,0,G2H8(24),n2h8(16))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G2H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G2H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G2H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(21),[G2H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(23),[G2H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(24),[G2H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(21),[G2H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(23),[G2H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(24),[G2H8(20)])
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(7),mass5set(:,1),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),G1H8(6),8)
  call HG1shiftOLR(G1H8(2),9,8)
  call Hotf_5pt_reduction(G2H8(2),RedSet_5(8),mass5set(:,1),  & 
G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),G1H8(12),8)
  call HG1shiftOLR(G1H8(8),9,8)
  call Hloop_AQ_V(ntryL,G2H4(1),ex6(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_AQ_V(ntryL,G2H4(3),ex6(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_AQ_V(ntryL,G2H4(4),ex6(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_AQ_V(ntryL,G2H4(9),ex6(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_AQ_V(ntryL,G2H4(11),ex6(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_V(ntryL,G2H4(12),ex6(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_QA_V(ntryL,G2H4(13),ex5(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_QA_V(ntryL,G2H4(15),ex5(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_QA_V(ntryL,G2H4(16),ex5(:),G2H2(9),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_QA_V(ntryL,G2H4(21),ex5(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_QA_V(ntryL,G2H4(23),ex5(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_QA_V(ntryL,G2H4(24),ex5(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(5),mass5set(:,1),  & 
G1H8(13),G1H8(14),G1H8(15),G1H8(16),G1H8(17),G1H8(18),8)
  call HG1shiftOLR(G1H8(14),32,8)
  call Hotf_4pt_reduction(G2H8(11),RedSet_4(1),mass4set(:,1),  & 
G1H8(19),G1H8(20),G1H8(21),G1H8(22),G1H8(23),8)
  call HG1shiftOLR(G1H8(20),32,8)
  call Hotf_4pt_reduction(G2H8(12),RedSet_4(2),mass4set(:,1),  & 
G1H8(24),G1H8(25),G1H8(26),G1H8(27),G1H8(28),8)
  call HG1shiftOLR(G1H8(25),38,8)
  call Hotf_5pt_reduction(G2H8(13),RedSet_5(5),mass5set(:,1),  & 
G1H8(29),G1H8(30),G1H8(31),G1H8(32),G1H8(33),G1H8(34),8)
  call HG1shiftOLR(G1H8(30),32,8)
  call Hotf_4pt_reduction(G2H8(15),RedSet_4(1),mass4set(:,1),  & 
G1H8(35),G1H8(36),G1H8(37),G1H8(38),G1H8(39),8)
  call HG1shiftOLR(G1H8(36),32,8)
  call Hotf_4pt_reduction(G2H8(16),RedSet_4(2),mass4set(:,1),  & 
G1H8(40),G1H8(41),G1H8(42),G1H8(43),G1H8(44),8)
  call HG1shiftOLR(G1H8(41),38,8)
  call Hotf_5pt_reduction(G2H8(21),RedSet_5(6),mass5set(:,1),  & 
G1H8(45),G1H8(46),G1H8(47),G1H8(48),G1H8(49),G1H8(50),8)
  call HG1shiftOLR(G1H8(46),32,8)
  call Hotf_4pt_reduction(G2H8(23),RedSet_4(1),mass4set(:,1),  & 
G1H8(51),G1H8(52),G1H8(53),G1H8(54),G1H8(55),8)
  call HG1shiftOLR(G1H8(52),32,8)
  call Hotf_4pt_reduction(G2H8(24),RedSet_4(3),mass4set(:,1),  & 
G1H8(56),G1H8(57),G1H8(58),G1H8(59),G1H8(60),8)
  call HG1shiftOLR(G1H8(57),41,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(19),[G1H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(24),[G1H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(35),[G1H8(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(40),[G1H8(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(51),[G1H8(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(56),[G1H8(50)])
  call Hloop_VA_Q(ntryL,G1H8(1),ex5(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_A_Q(ntryL,G1H4(1),118,0,G2H4(5),n2h4(25))
call HGT_OLR(G1H8(2),1,1,8)
call HGT_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(2),-9,0,G2H8(17),n2h8(17))
  call Hloop_QW_A(ntryL,G2H8(17),wf4(:,4),G2H2(13),m3h4x2(:,1),heltab2x8(:,:,2))
  call Hloop_VA_Q(ntryL,G1H8(5),ex5(:),G1H4(1),m3h2x4(:,2),heltab2x8(:,:,3))
  call Hloop_A_Q(ntryL,G1H4(1),118,0,G2H4(7),n2h4(26))
  call Hloop_VA_Q(ntryL,G1H8(6),ex5(:),G1H4(1),m3h2x4(:,3),heltab2x8(:,:,4))
  call Hloop_A_Q(ntryL,G1H4(1),118,0,G2H4(8),n2h4(27))
  call Hloop_VQ_A(ntryL,G1H8(7),ex6(:),G1H4(1),m3h2x4(:,4),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(1),118,0,G2H4(17),n2h4(28))
call HGT_OLR(G1H8(8),1,1,8)
call HGT_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(8),-9,0,G2H8(19),n2h8(18))
  call Hloop_AW_Q(ntryL,G2H8(19),wf4(:,4),G2H2(14),m3h4x2(:,2),heltab2x8(:,:,6))
  call Hloop_VQ_A(ntryL,G1H8(11),ex6(:),G1H4(1),m3h2x4(:,5),heltab2x8(:,:,7))
  call Hloop_Q_A(ntryL,G1H4(1),118,0,G2H4(19),n2h4(29))
  call Hloop_VQ_A(ntryL,G1H8(12),ex6(:),G1H4(1),m3h2x4(:,6),heltab2x8(:,:,8))
  call Hloop_Q_A(ntryL,G1H4(1),118,0,G2H4(20),n2h4(30))
  call Hloop_AV_Q(ntryL,G1H8(13),wf4(:,2),G1H2(1),m3h4x2(:,3),heltab2x8(:,:,9))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(15),n2h2(1))
call HGT_raise_alpha_OLR(G1H8(14),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(14),ex6(:),G1H4(1),m3h2x4(:,7),heltab2x8(:,:,10))
  call Hloop_AV_Q(ntryL,G1H8(19),wf4(:,2),G1H2(1),m3h4x2(:,4),heltab2x8(:,:,11))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(16),n2h2(2))
  call Hloop_AV_Q(ntryL,G1H8(24),wf4(:,2),G1H2(1),m3h4x2(:,5),heltab2x8(:,:,12))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(17),n2h2(3))
call HGT_raise_alpha_OLR(G1H8(20),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(20),ex6(:),G1H4(2),m3h2x4(:,8),heltab2x8(:,:,13))
  call Hloop_AV_Q(ntryL,G1H8(23),wf4(:,2),G1H2(1),m3h4x2(:,6),heltab2x8(:,:,14))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(18),n2h2(4))
call HGT_raise_alpha_OLR(G1H8(25),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(25),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(25),ex6(:),G1H4(3),m3h2x4(:,9),heltab2x8(:,:,15))
  call Hloop_AV_Q(ntryL,G1H8(28),wf4(:,2),G1H2(1),m3h4x2(:,7),heltab2x8(:,:,16))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(19),n2h2(5))
  call Hloop_AZ_Q(ntryL,G1H8(29),wf4(:,7),G1H2(1),ngZd,m3h4x2(:,8),heltab2x8(:,:,17))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(20),n2h2(6))
call HGT_raise_alpha_OLR(G1H8(30),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(30),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(30),ex6(:),G1H4(4),m3h2x4(:,10),heltab2x8(:,:,18))
  call Hloop_AZ_Q(ntryL,G1H8(35),wf4(:,7),G1H2(1),ngZd,m3h4x2(:,9),heltab2x8(:,:,19))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(21),n2h2(7))
  call Hloop_AZ_Q(ntryL,G1H8(40),wf4(:,7),G1H2(1),ngZd,m3h4x2(:,10),heltab2x8(:,:,20))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(22),n2h2(8))
call HGT_raise_alpha_OLR(G1H8(36),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(36),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(36),ex6(:),G1H4(5),m3h2x4(:,11),heltab2x8(:,:,21))
  call Hloop_AZ_Q(ntryL,G1H8(39),wf4(:,7),G1H2(1),ngZd,m3h4x2(:,11),heltab2x8(:,:,22))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(23),n2h2(9))
call HGT_raise_alpha_OLR(G1H8(41),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(41),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(41),ex6(:),G1H4(6),m3h2x4(:,12),heltab2x8(:,:,23))
  call Hloop_AZ_Q(ntryL,G1H8(44),wf4(:,7),G1H2(1),ngZd,m3h4x2(:,12),heltab2x8(:,:,24))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(24),n2h2(10))
  call Hloop_AW_Q(ntryL,G1H8(45),wf4(:,4),G1H2(1),m3h4x2(:,13),heltab2x8(:,:,25))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(25),n2h2(11))
call HGT_raise_alpha_OLR(G1H8(46),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(46),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(46),ex6(:),G1H4(7),m3h2x4(:,13),heltab2x8(:,:,26))
  call Hloop_AW_Q(ntryL,G1H8(51),wf4(:,4),G1H2(1),m3h4x2(:,14),heltab2x8(:,:,27))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(26),n2h2(12))
  call Hloop_AW_Q(ntryL,G1H8(56),wf4(:,4),G1H2(1),m3h4x2(:,15),heltab2x8(:,:,28))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(27),n2h2(13))
call HGT_raise_alpha_OLR(G1H8(52),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(52),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(52),ex6(:),G1H4(8),m3h2x4(:,14),heltab2x8(:,:,29))
  call Hloop_AW_Q(ntryL,G1H8(55),wf4(:,4),G1H2(1),m3h4x2(:,16),heltab2x8(:,:,30))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(28),n2h2(14))
call HGT_raise_alpha_OLR(G1H8(57),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(57),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(57),ex6(:),G1H4(9),m3h2x4(:,15),heltab2x8(:,:,31))
  call Hloop_AW_Q(ntryL,G1H8(60),wf4(:,4),G1H2(1),m3h4x2(:,17),heltab2x8(:,:,32))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(29),n2h2(15))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G2H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(22),[G2H2(17)])
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(2),16,2)
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(4),mass4set(:,1),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),2)
  call HG1shiftOLR(G1H2(8),48,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(2),mass5set(:,1),  & 
G1H2(12),G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),2)
  call HG1shiftOLR(G1H2(13),16,2)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(5),mass4set(:,1),  & 
G1H2(18),G1H2(19),G1H2(20),G1H2(21),G1H2(22),2)
  call HG1shiftOLR(G1H2(19),48,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(3),mass5set(:,1),  & 
G1H2(23),G1H2(24),G1H2(25),G1H2(26),G1H2(27),G1H2(28),2)
  call HG1shiftOLR(G1H2(24),32,2)
  call Hotf_4pt_reduction(G2H2(9),RedSet_4(4),mass4set(:,1),  & 
G1H2(29),G1H2(30),G1H2(31),G1H2(32),G1H2(33),2)
  call HG1shiftOLR(G1H2(30),48,2)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(4),mass5set(:,1),  & 
G1H2(34),G1H2(35),G1H2(36),G1H2(37),G1H2(38),G1H2(39),2)
  call HG1shiftOLR(G1H2(35),32,2)
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(5),mass4set(:,1),  & 
G1H2(40),G1H2(41),G1H2(42),G1H2(43),G1H2(44),2)
  call HG1shiftOLR(G1H2(41),48,2)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(7),mass5set(:,1),  & 
G1H4(10),G1H4(11),G1H4(12),G1H4(13),G1H4(14),G1H4(15),4)
  call HG1shiftOLR(G1H4(11),9,4)
  call Hotf_4pt_reduction(G2H4(8),RedSet_4(6),mass4set(:,1),  & 
G1H4(16),G1H4(17),G1H4(18),G1H4(19),G1H4(20),4)
  call HG1shiftOLR(G1H4(17),25,4)
  call Hotf_5pt_reduction(G2H4(17),RedSet_5(8),mass5set(:,1),  & 
G1H4(21),G1H4(22),G1H4(23),G1H4(24),G1H4(25),G1H4(26),4)
  call HG1shiftOLR(G1H4(22),9,4)
  call Hotf_4pt_reduction(G2H4(20),RedSet_4(7),mass4set(:,1),  & 
G1H4(27),G1H4(28),G1H4(29),G1H4(30),G1H4(31),4)
  call HG1shiftOLR(G1H4(28),41,4)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(20),ex6(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(22),ex6(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(25),ex6(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(27),ex6(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(7),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(18),[G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(29),[G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(40),[G1H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(16),[G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(27),[G1H4(26)])
  call Hloop_VA_Q(ntryL,G1H2(1),ex5(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(5),n2h1(1))
  call Hloop_VA_Q(ntryL,G1H2(2),ex5(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(6),n2h1(2))
  call Hloop_VA_Q(ntryL,G1H2(7),ex5(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(7),n2h1(3))
  call Hloop_VA_Q(ntryL,G1H2(8),ex5(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,0,G2tensor(8),n2h1(4))
  call Hloop_VA_Q(ntryL,G1H2(12),ex5(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(9),n2h1(5))
  call Hloop_VA_Q(ntryL,G1H2(13),ex5(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(10),n2h1(6))
  call Hloop_VA_Q(ntryL,G1H2(18),ex5(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(11),n2h1(7))
  call Hloop_VA_Q(ntryL,G1H2(19),ex5(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,0,G2tensor(12),n2h1(8))
  call Hloop_VQ_A(ntryL,G1H2(23),ex6(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(13),n2h1(9))
  call Hloop_VQ_A(ntryL,G1H2(24),ex6(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),32,0,G2tensor(14),n2h1(10))
  call Hloop_VQ_A(ntryL,G1H2(29),ex6(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(15),n2h1(11))
  call Hloop_VQ_A(ntryL,G1H2(30),ex6(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,0,G2tensor(16),n2h1(12))
  call Hloop_VQ_A(ntryL,G1H2(34),ex6(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(17),n2h1(13))
  call Hloop_VQ_A(ntryL,G1H2(35),ex6(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),32,0,G2tensor(18),n2h1(14))
  call Hloop_VQ_A(ntryL,G1H2(40),ex6(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(19),n2h1(15))
  call Hloop_VQ_A(ntryL,G1H2(41),ex6(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,0,G2tensor(20),n2h1(16))
  call Hloop_AW_Q(ntryL,G1H4(10),wf4(:,4),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(21),n2h1(17))
  call Hloop_AW_Q(ntryL,G1H4(11),wf4(:,4),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,0,G2tensor(22),n2h1(18))
  call Hloop_AW_Q(ntryL,G1H4(16),wf4(:,4),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(23),n2h1(19))
  call Hloop_AW_Q(ntryL,G1H4(17),wf4(:,4),G1H1(1),m3h4x1(:,4),heltab2x4(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),25,0,G2tensor(24),n2h1(20))
  call Hloop_QW_A(ntryL,G1H4(21),wf4(:,4),G1H1(1),m3h4x1(:,5),heltab2x4(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(25),n2h1(21))
  call Hloop_QW_A(ntryL,G1H4(22),wf4(:,4),G1H1(1),m3h4x1(:,6),heltab2x4(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(26),n2h1(22))
  call Hloop_QW_A(ntryL,G1H4(27),wf4(:,4),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(27),n2h1(23))
  call Hloop_QW_A(ntryL,G1H4(28),wf4(:,4),G1H1(1),m3h4x1(:,8),heltab2x4(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),41,0,G2tensor(28),n2h1(24))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(5),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),32)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(6),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),32)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(1),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),16)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(2),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),16)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(3),mass5set(:,1),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),32)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(4),mass5set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),32)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(7),mass5set(:,1),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),9)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(8),mass5set(:,1),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),9)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(178)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(17),h0tab(:,17),[80,6,9,32],[0,0,0,0],4,3,wf4(:,5),wf4(:,2),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,5),G0H32(1),m3h4x32(:,1),heltab2x128(:,:,17))
  call Hloop_A_Q(ntryL,G0H32(1),80,0,G1H32(1),n2h32(9))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(179)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(18),h0tab(:,18),[80,6,9,32],[0,0,0,0],4,3,wf4(:,5),wf4(:,7),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,5),G0H32(1),m3h4x32(:,2),heltab2x128(:,:,18))
  call Hloop_A_Q(ntryL,G0H32(1),80,0,G1H32(2),n2h32(10))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(178)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(19),h0tab(:,19),[80,9,6,32],[0,0,0,0],4,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,5),G0H32(1),m3h4x32(:,3),heltab2x128(:,:,19))
  call Hloop_A_Q(ntryL,G0H32(1),80,0,G1H32(4),n2h32(11))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(179)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(20),h0tab(:,20),[80,9,6,32],[0,0,0,0],4,3,wf4(:,5),wf4(:,4),wf4(:,7))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,5),G0H32(1),m3h4x32(:,4),heltab2x128(:,:,20))
  call Hloop_A_Q(ntryL,G0H32(1),80,0,G1H32(5),n2h32(12))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(184)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(21),h0tab(:,21),[96,6,9,16],[0,0,0,0],4,3,wf4(:,9),wf4(:,2),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,5),heltab2x128(:,:,21))
  call Hloop_Q_A(ntryL,G0H32(1),96,0,G1H32(6),n2h32(13))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(22),h0tab(:,22),[96,6,9,16],[0,0,0,0],4,3,wf4(:,9),wf4(:,7),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,6),heltab2x128(:,:,22))
  call Hloop_Q_A(ntryL,G0H32(1),96,0,G1H32(7),n2h32(14))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(184)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(23),h0tab(:,23),[96,9,6,16],[0,0,0,0],4,3,wf4(:,9),wf4(:,4),wf4(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,7),heltab2x128(:,:,23))
  call Hloop_Q_A(ntryL,G0H32(1),96,0,G1H32(8),n2h32(15))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(24),h0tab(:,24),[96,9,6,16],[0,0,0,0],4,3,wf4(:,9),wf4(:,4),wf4(:,7))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,8),heltab2x128(:,:,24))
  call Hloop_Q_A(ntryL,G0H32(1),96,0,G1H32(10),n2h32(16))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(143)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(25),h0tab(:,25),[64,25,6,32],[0,0,0,0],4,2,wf8(:,10),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(1),m3h2x64(:,17),heltab2x128(:,:,25))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(146)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(26),h0tab(:,26),[64,25,6,32],[0,0,0,0],4,2,wf8(:,10),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(2),m3h2x64(:,18),heltab2x128(:,:,26))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(143)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(27),h0tab(:,27),[64,6,25,32],[0,0,0,0],4,2,wf4(:,2),wf8(:,10))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,19),heltab2x128(:,:,27))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(3),n2h64(13))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(146)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(28),h0tab(:,28),[64,6,25,32],[0,0,0,0],4,2,wf4(:,7),wf8(:,10))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,20),heltab2x128(:,:,28))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(4),n2h64(14))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(143)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(29),h0tab(:,29),[64,6,32,25],[0,0,0,0],4,2,wf4(:,2),wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,21),heltab2x128(:,:,29))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(5),n2h64(15))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(146)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(30),h0tab(:,30),[64,6,32,25],[0,0,0,0],4,2,wf4(:,7),wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,22),heltab2x128(:,:,30))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(6),n2h64(16))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(149)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(31),h0tab(:,31),[64,16,6,41],[0,0,0,0],4,2,wf4(:,2),wf8(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(7),m3h2x64(:,23),heltab2x128(:,:,31))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(152)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(32),h0tab(:,32),[64,16,6,41],[0,0,0,0],4,2,wf4(:,7),wf8(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(8),m3h2x64(:,24),heltab2x128(:,:,32))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(149)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(33),h0tab(:,33),[64,6,41,16],[0,0,0,0],4,2,wf4(:,2),wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,25),heltab2x128(:,:,33))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(9),n2h64(17))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(152)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(34),h0tab(:,34),[64,6,41,16],[0,0,0,0],4,2,wf4(:,7),wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,26),heltab2x128(:,:,34))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(10),n2h64(18))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(149)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(35),h0tab(:,35),[64,6,16,41],[0,0,0,0],4,2,wf4(:,2),wf8(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,27),heltab2x128(:,:,35))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(11),n2h64(19))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(152)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(36),h0tab(:,36),[64,6,16,41],[0,0,0,0],4,2,wf4(:,7),wf8(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,28),heltab2x128(:,:,36))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(12),n2h64(20))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(154)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(37),h0tab(:,37),[64,22,9,32],[0,0,0,0],4,2,wf8(:,12),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(13),m3h2x64(:,29),heltab2x128(:,:,37))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(156)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(38),h0tab(:,38),[64,22,9,32],[0,0,0,0],4,2,wf8(:,14),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(14),m3h2x64(:,30),heltab2x128(:,:,38))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(154)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(39),h0tab(:,39),[64,9,22,32],[0,0,0,0],4,2,wf4(:,4),wf8(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,31),heltab2x128(:,:,39))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(15),n2h64(21))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(156)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(40),h0tab(:,40),[64,9,22,32],[0,0,0,0],4,2,wf4(:,4),wf8(:,14))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,32),heltab2x128(:,:,40))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(16),n2h64(22))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(154)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(41),h0tab(:,41),[64,9,32,22],[0,0,0,0],4,2,wf4(:,4),wf8(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,33),heltab2x128(:,:,41))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(17),n2h64(23))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(156)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(42),h0tab(:,42),[64,9,32,22],[0,0,0,0],4,2,wf4(:,4),wf8(:,14))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,34),heltab2x128(:,:,42))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(18),n2h64(24))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(158)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(43),h0tab(:,43),[64,16,9,38],[0,0,0,0],4,2,wf4(:,4),wf8(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(19),m3h2x64(:,35),heltab2x128(:,:,43))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(160)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(44),h0tab(:,44),[64,16,9,38],[0,0,0,0],4,2,wf4(:,4),wf8(:,6))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(20),m3h2x64(:,36),heltab2x128(:,:,44))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(158)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(45),h0tab(:,45),[64,9,38,16],[0,0,0,0],4,2,wf4(:,4),wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,37),heltab2x128(:,:,45))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(21),n2h64(25))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(160)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(46),h0tab(:,46),[64,9,38,16],[0,0,0,0],4,2,wf4(:,4),wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,38),heltab2x128(:,:,46))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(22),n2h64(26))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(158)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(47),h0tab(:,47),[64,9,16,38],[0,0,0,0],4,2,wf4(:,4),wf8(:,4))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,39),heltab2x128(:,:,47))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(23),n2h64(27))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(160)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(48),h0tab(:,48),[64,9,16,38],[0,0,0,0],4,2,wf4(:,4),wf8(:,6))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,40),heltab2x128(:,:,48))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(24),n2h64(28))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(49),h0tab(:,49),[64,15,32,16],[0,0,0,0],4,1,wf16(:,27))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,41),heltab2x128(:,:,49))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(25),n2h64(29))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(50),h0tab(:,50),[64,15,32,16],[0,0,0,0],4,1,wf16(:,28))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,42),heltab2x128(:,:,50))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(26),n2h64(30))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(51),h0tab(:,51),[64,15,16,32],[0,0,0,0],4,1,wf16(:,27))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,43),heltab2x128(:,:,51))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(27),n2h64(31))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(52),h0tab(:,52),[64,15,16,32],[0,0,0,0],4,1,wf16(:,28))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,44),heltab2x128(:,:,52))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(28),n2h64(32))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(53),h0tab(:,53),[64,16,15,32],[0,0,0,0],4,1,wf16(:,27))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(29),m3h2x64(:,45),heltab2x128(:,:,53))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(54),h0tab(:,54),[64,16,15,32],[0,0,0,0],4,1,wf16(:,28))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(30),m3h2x64(:,46),heltab2x128(:,:,54))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(129)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(55),h0tab(:,55),[64,15,32,16],[0,0,0,0],4,1,wf16(:,59))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,47),heltab2x128(:,:,55))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(31),n2h64(33))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(129)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(56),h0tab(:,56),[64,15,16,32],[0,0,0,0],4,1,wf16(:,59))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,48),heltab2x128(:,:,56))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(32),n2h64(34))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(129)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(57),h0tab(:,57),[64,16,15,32],[0,0,0,0],4,1,wf16(:,59))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(33),m3h2x64(:,49),heltab2x128(:,:,57))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(131)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(58),h0tab(:,58),[64,15,32,16],[0,0,0,0],4,1,wf16(:,60))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,50),heltab2x128(:,:,58))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(34),n2h64(35))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(59),h0tab(:,59),[64,15,32,16],[0,0,0,0],4,1,wf16(:,61))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,51),heltab2x128(:,:,59))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(35),n2h64(36))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(131)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(60),h0tab(:,60),[64,15,16,32],[0,0,0,0],4,1,wf16(:,60))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,52),heltab2x128(:,:,60))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(36),n2h64(37))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(61),h0tab(:,61),[64,15,16,32],[0,0,0,0],4,1,wf16(:,61))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,53),heltab2x128(:,:,61))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(37),n2h64(38))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(131)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(62),h0tab(:,62),[64,16,15,32],[0,0,0,0],4,1,wf16(:,60))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(38),m3h2x64(:,54),heltab2x128(:,:,62))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(63),h0tab(:,63),[64,16,15,32],[0,0,0,0],4,1,wf16(:,61))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(39),m3h2x64(:,55),heltab2x128(:,:,63))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(64),h0tab(:,64),[64,15,32,16],[0,0,0,0],4,1,wf16(:,62))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,56),heltab2x128(:,:,64))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(40),n2h64(39))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(65),h0tab(:,65),[64,15,16,32],[0,0,0,0],4,1,wf16(:,62))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,57),heltab2x128(:,:,65))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(41),n2h64(40))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(66),h0tab(:,66),[64,16,15,32],[0,0,0,0],4,1,wf16(:,62))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(42),m3h2x64(:,58),heltab2x128(:,:,66))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(4),[G1H32(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(5),[G1H32(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(1),[G1H32(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(2),[G1H32(21)])
  call Hloop_AW_Q(ntryL,G1H16(3),wf4(:,4),G1H4(15),m3h4x4(:,25),heltab2x16(:,:,33))
  call Hloop_A_Q(ntryL,G1H4(15),79,0,G2H4(1),n2h4(31))
  call Hloop_AV_Q(ntryL,G1H16(9),wf4(:,2),G1H4(26),m3h4x4(:,26),heltab2x16(:,:,34))
  call Hloop_A_Q(ntryL,G1H4(26),79,0,G2H4(3),n2h4(32))
  call Hloop_AZ_Q(ntryL,G1H16(15),wf4(:,7),G1H4(10),ngZd,m3h4x4(:,27),heltab2x16(:,:,35))
  call Hloop_A_Q(ntryL,G1H4(10),79,0,G2H4(4),n2h4(33))
  call Hloop_QW_A(ntryL,G1H16(21),wf4(:,4),G1H4(11),m3h4x4(:,28),heltab2x16(:,:,36))
  call Hloop_Q_A(ntryL,G1H4(11),79,0,G2H4(9),n2h4(34))
  call Hloop_QV_A(ntryL,G1H16(27),wf4(:,2),G1H4(16),m3h4x4(:,29),heltab2x16(:,:,37))
  call Hloop_Q_A(ntryL,G1H4(16),79,0,G2H4(11),n2h4(35))
  call Hloop_QZ_A(ntryL,G1H16(33),wf4(:,7),G1H4(17),ngZu,m3h4x4(:,30),heltab2x16(:,:,38))
  call Hloop_Q_A(ntryL,G1H4(17),79,0,G2H4(12),n2h4(36))
  call Hloop_AW_Q(ntryL,G1H32(4),wf4(:,4),G1H8(17),m3h4x8(:,17),heltab2x32(:,:,21))
  call Hloop_A_Q(ntryL,G1H8(17),89,0,G2H8(20),n2h8(28))
  call Hloop_AW_Q(ntryL,G1H32(5),wf4(:,4),G1H8(18),m3h4x8(:,18),heltab2x32(:,:,22))
  call Hloop_A_Q(ntryL,G1H8(18),89,0,G2H8(1),n2h8(29))
  call Hloop_AV_Q(ntryL,G1H32(1),wf4(:,2),G1H8(33),m3h4x8(:,19),heltab2x32(:,:,23))
  call Hloop_A_Q(ntryL,G1H8(33),86,0,G2H8(2),n2h8(30))
  call Hloop_AZ_Q(ntryL,G1H32(2),wf4(:,7),G1H8(34),ngZu,m3h4x8(:,20),heltab2x32(:,:,24))
  call Hloop_A_Q(ntryL,G1H8(34),86,0,G2H8(9),n2h8(31))
  call Hloop_QV_A(ntryL,G1H32(6),wf4(:,2),G1H8(49),m3h4x8(:,21),heltab2x32(:,:,25))
  call Hloop_Q_A(ntryL,G1H8(49),102,0,G2H8(11),n2h8(32))
  call Hloop_QZ_A(ntryL,G1H32(7),wf4(:,7),G1H8(50),ngZd,m3h4x8(:,22),heltab2x32(:,:,26))
  call Hloop_Q_A(ntryL,G1H8(50),102,0,G2H8(12),n2h8(33))
  call Hloop_QW_A(ntryL,G1H32(8),wf4(:,4),G1H8(1),m3h4x8(:,23),heltab2x32(:,:,27))
  call Hloop_Q_A(ntryL,G1H8(1),105,0,G2H8(13),n2h8(34))
  call Hloop_QW_A(ntryL,G1H32(10),wf4(:,4),G1H8(2),m3h4x8(:,24),heltab2x32(:,:,28))
  call Hloop_Q_A(ntryL,G1H8(2),105,0,G2H8(15),n2h8(35))
  call Hloop_VA_Q(ntryL,G1H64(1),wf8(:,10),G1H8(5),m3h8x8(:,1),heltab2x64(:,:,17))
  call Hloop_A_Q(ntryL,G1H8(5),89,0,G2H8(16),n2h8(36))
  call Hloop_VA_Q(ntryL,G1H64(2),wf8(:,10),G1H8(6),m3h8x8(:,2),heltab2x64(:,:,18))
  call Hloop_A_Q(ntryL,G1H8(6),89,0,G2H8(21),n2h8(37))
  call Hloop_QV_A(ntryL,G1H64(3),wf4(:,2),G1H16(6),m3h4x16(:,13),heltab2x64(:,:,19))
  call Hloop_Q_A(ntryL,G1H16(6),70,0,G2H16(4),n2h16(19))
  call Hloop_QZ_A(ntryL,G1H64(4),wf4(:,7),G1H16(7),ngZd,m3h4x16(:,14),heltab2x64(:,:,20))
  call Hloop_Q_A(ntryL,G1H16(7),70,0,G2H16(6),n2h16(20))
  call Hloop_AV_Q(ntryL,G1H64(5),wf4(:,2),G1H16(8),m3h4x16(:,15),heltab2x64(:,:,21))
  call Hloop_A_Q(ntryL,G1H16(8),70,0,G2H16(8),n2h16(21))
  call Hloop_AZ_Q(ntryL,G1H64(6),wf4(:,7),G1H16(10),ngZd,m3h4x16(:,16),heltab2x64(:,:,22))
  call Hloop_A_Q(ntryL,G1H16(10),70,0,G2H16(9),n2h16(22))
  call Hloop_VA_Q(ntryL,G1H64(7),ex5(:),G1H32(11),m3h2x32(:,5),heltab2x64(:,:,23))
  call Hloop_A_Q(ntryL,G1H32(11),80,0,G2H32(1),n2h32(17))
  call Hloop_VA_Q(ntryL,G1H64(8),ex5(:),G1H32(12),m3h2x32(:,6),heltab2x64(:,:,24))
  call Hloop_A_Q(ntryL,G1H32(12),80,0,G2H32(2),n2h32(18))
  call Hloop_AV_Q(ntryL,G1H64(9),wf4(:,2),G1H16(11),m3h4x16(:,17),heltab2x64(:,:,25))
  call Hloop_A_Q(ntryL,G1H16(11),70,0,G2H16(10),n2h16(23))
  call Hloop_AZ_Q(ntryL,G1H64(10),wf4(:,7),G1H16(12),ngZu,m3h4x16(:,18),heltab2x64(:,:,26))
  call Hloop_A_Q(ntryL,G1H16(12),70,0,G2H16(12),n2h16(24))
  call Hloop_QV_A(ntryL,G1H64(11),wf4(:,2),G1H16(13),m3h4x16(:,19),heltab2x64(:,:,27))
  call Hloop_Q_A(ntryL,G1H16(13),70,0,G2H16(1),n2h16(25))
  call Hloop_QZ_A(ntryL,G1H64(12),wf4(:,7),G1H16(14),ngZu,m3h4x16(:,20),heltab2x64(:,:,28))
  call Hloop_Q_A(ntryL,G1H16(14),70,0,G2H16(5),n2h16(26))
  call Hloop_VA_Q(ntryL,G1H64(13),wf8(:,12),G1H8(7),m3h8x8(:,3),heltab2x64(:,:,29))
  call Hloop_A_Q(ntryL,G1H8(7),86,0,G2H8(23),n2h8(38))
  call Hloop_VA_Q(ntryL,G1H64(14),wf8(:,14),G1H8(8),m3h8x8(:,4),heltab2x64(:,:,30))
  call Hloop_A_Q(ntryL,G1H8(8),86,0,G2H8(24),n2h8(39))
  call Hloop_QW_A(ntryL,G1H64(15),wf4(:,4),G1H16(16),m3h4x16(:,21),heltab2x64(:,:,31))
  call Hloop_Q_A(ntryL,G1H16(16),73,0,G2H16(7),n2h16(27))
  call Hloop_QW_A(ntryL,G1H64(16),wf4(:,4),G1H16(17),m3h4x16(:,22),heltab2x64(:,:,32))
  call Hloop_Q_A(ntryL,G1H16(17),73,0,G2H16(11),n2h16(28))
  call Hloop_AW_Q(ntryL,G1H64(17),wf4(:,4),G1H16(18),m3h4x16(:,23),heltab2x64(:,:,33))
  call Hloop_A_Q(ntryL,G1H16(18),73,0,G2H16(2),n2h16(29))
  call Hloop_AW_Q(ntryL,G1H64(18),wf4(:,4),G1H16(19),m3h4x16(:,24),heltab2x64(:,:,34))
  call Hloop_A_Q(ntryL,G1H16(19),73,0,G2H16(3),n2h16(30))
  call Hloop_VA_Q(ntryL,G1H64(19),ex5(:),G1H32(13),m3h2x32(:,7),heltab2x64(:,:,35))
  call Hloop_A_Q(ntryL,G1H32(13),80,0,G2H32(3),n2h32(19))
  call Hloop_VA_Q(ntryL,G1H64(20),ex5(:),G1H32(14),m3h2x32(:,8),heltab2x64(:,:,36))
  call Hloop_A_Q(ntryL,G1H32(14),80,0,G2H32(4),n2h32(20))
  call Hloop_AW_Q(ntryL,G1H64(21),wf4(:,4),G1H16(20),m3h4x16(:,25),heltab2x64(:,:,37))
  call Hloop_A_Q(ntryL,G1H16(20),73,0,G2H16(13),n2h16(31))
  call Hloop_AW_Q(ntryL,G1H64(22),wf4(:,4),G1H16(22),m3h4x16(:,26),heltab2x64(:,:,38))
  call Hloop_A_Q(ntryL,G1H16(22),73,0,G2H16(14),n2h16(32))
  call Hloop_QW_A(ntryL,G1H64(23),wf4(:,4),G1H16(23),m3h4x16(:,27),heltab2x64(:,:,39))
  call Hloop_Q_A(ntryL,G1H16(23),73,0,G2H16(15),n2h16(33))
  call Hloop_QW_A(ntryL,G1H64(24),wf4(:,4),G1H16(24),m3h4x16(:,28),heltab2x64(:,:,40))
  call Hloop_Q_A(ntryL,G1H16(24),73,0,G2H16(16),n2h16(34))
  call Hloop_AW_Q(ntryL,G1H64(25),wf16(:,27),G1H4(21),m3h16x4(:,1),heltab2x64(:,:,41))
  call Hloop_A_Q(ntryL,G1H4(21),79,0,G2H4(13),n2h4(37))
  call Hloop_AW_Q(ntryL,G1H64(26),wf16(:,28),G1H4(22),m3h16x4(:,2),heltab2x64(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(22),79,0,G2H4(15),n2h4(38))
  call Hloop_QW_A(ntryL,G1H64(27),wf16(:,27),G1H4(27),m3h16x4(:,3),heltab2x64(:,:,43))
  call Hloop_Q_A(ntryL,G1H4(27),79,0,G2H4(16),n2h4(39))
  call Hloop_QW_A(ntryL,G1H64(28),wf16(:,28),G1H4(28),m3h16x4(:,4),heltab2x64(:,:,44))
  call Hloop_Q_A(ntryL,G1H4(28),79,0,G2H4(21),n2h4(40))
  call Hloop_VA_Q(ntryL,G1H64(29),ex5(:),G1H32(16),m3h2x32(:,9),heltab2x64(:,:,45))
  call Hloop_A_Q(ntryL,G1H32(16),80,0,G2H32(5),n2h32(21))
  call Hloop_VA_Q(ntryL,G1H64(30),ex5(:),G1H32(17),m3h2x32(:,10),heltab2x64(:,:,46))
  call Hloop_A_Q(ntryL,G1H32(17),80,0,G2H32(6),n2h32(22))
  call Hloop_AW_Q(ntryL,G1H64(31),wf16(:,59),G1H4(15),m3h16x4(:,5),heltab2x64(:,:,47))
  call Hloop_A_Q(ntryL,G1H4(15),79,0,G2H4(23),n2h4(41))
  call Hloop_QW_A(ntryL,G1H64(32),wf16(:,59),G1H4(26),m3h16x4(:,6),heltab2x64(:,:,48))
  call Hloop_Q_A(ntryL,G1H4(26),79,0,G2H4(24),n2h4(42))
  call Hloop_VA_Q(ntryL,G1H64(33),ex5(:),G1H32(18),m3h2x32(:,11),heltab2x64(:,:,49))
  call Hloop_A_Q(ntryL,G1H32(18),80,0,G2H32(7),n2h32(23))
  call Hloop_AW_Q(ntryL,G1H64(34),wf16(:,60),G1H4(10),m3h16x4(:,7),heltab2x64(:,:,50))
  call Hloop_A_Q(ntryL,G1H4(10),79,0,G2H4(5),n2h4(43))
  call Hloop_AW_Q(ntryL,G1H64(35),wf16(:,61),G1H4(11),m3h16x4(:,8),heltab2x64(:,:,51))
  call Hloop_A_Q(ntryL,G1H4(11),79,0,G2H4(8),n2h4(44))
  call Hloop_QW_A(ntryL,G1H64(36),wf16(:,60),G1H4(16),m3h16x4(:,9),heltab2x64(:,:,52))
  call Hloop_Q_A(ntryL,G1H4(16),79,0,G2H4(17),n2h4(45))
  call Hloop_QW_A(ntryL,G1H64(37),wf16(:,61),G1H4(17),m3h16x4(:,10),heltab2x64(:,:,53))
  call Hloop_Q_A(ntryL,G1H4(17),79,0,G2H4(20),n2h4(46))
  call Hloop_VA_Q(ntryL,G1H64(38),ex5(:),G1H32(19),m3h2x32(:,12),heltab2x64(:,:,54))
  call Hloop_A_Q(ntryL,G1H32(19),80,0,G2H32(8),n2h32(24))
  call Hloop_VA_Q(ntryL,G1H64(39),ex5(:),G1H32(20),m3h2x32(:,13),heltab2x64(:,:,55))
  call Hloop_A_Q(ntryL,G1H32(20),80,0,G2H32(9),n2h32(25))
  call Hloop_AW_Q(ntryL,G1H64(40),wf16(:,62),G1H4(21),m3h16x4(:,11),heltab2x64(:,:,56))
  call Hloop_A_Q(ntryL,G1H4(21),79,0,G2H4(25),n2h4(47))
  call Hloop_QW_A(ntryL,G1H64(41),wf16(:,62),G1H4(22),m3h16x4(:,12),heltab2x64(:,:,57))
  call Hloop_Q_A(ntryL,G1H4(22),79,0,G2H4(26),n2h4(48))
  call Hloop_VA_Q(ntryL,G1H64(42),ex5(:),G1H32(22),m3h2x32(:,14),heltab2x64(:,:,58))
  call Hloop_A_Q(ntryL,G1H32(22),80,0,G2H32(10),n2h32(26))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(9),[G2H8(2),G1H8(47)])
call HGT_lower_alpha_w2_OLR(G2H8(3),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(3),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(3),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(3),[G2H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(25),[G2H4(8),G2H4(5),G2H4(23),G2H4(15),G2H4(13),G2H4(10) &
    ,G2H4(6),G2H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(20),[G1H8(15)])
call HGT_lower_alpha_w2_OLR(G2H8(4),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(4),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(4),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(4),[G2H8(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(1),[G1H8(31)])
call HGT_lower_alpha_w2_OLR(G2H8(5),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(5),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(5),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(5),[G2H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(12),[G2H8(11)])
call HGT_lower_alpha_w2_OLR(G2H8(6),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(6),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(6),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(6),[G2H8(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(26),[G2H4(20),G2H4(17),G2H4(24),G2H4(21),G2H4(16) &
    ,G2H4(22),G2H4(18),G2H4(14)])
call HGT_lower_alpha_w2_OLR(G2H8(7),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(7),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(7),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(7),[G2H8(13)])
call HGT_lower_alpha_w2_OLR(G2H8(8),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(8),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(8),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(8),[G2H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(16),[G2H8(10),G1H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(21),[G2H8(14),G1H8(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(24),[G2H8(23),G2H8(22),G2H8(18),G1H8(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G2H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G2H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(6),[G2H16(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(9),[G2H16(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(12),[G2H16(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(5),[G2H16(1)])
  call Hotf_4pt_reduction(G2H8(3),RedSet_4(11),mass4set(:,1),  & 
G1H8(11),G1H8(12),G1H8(13),G1H8(14),G1H8(19),8)
  call HG1shiftOLR(G1H8(12),32,8)
  call Hloop_AQ_V(ntryL,G2H4(25),ex6(:),G2H2(15),m3h2x2(:,13),heltab2x4(:,:,21))
  call Hotf_4pt_reduction(G2H8(4),RedSet_4(8),mass4set(:,1),  & 
G1H8(24),G1H8(20),G1H8(23),G1H8(25),G1H8(28),8)
  call HG1shiftOLR(G1H8(20),32,8)
  call Hotf_4pt_reduction(G2H8(5),RedSet_4(8),mass4set(:,1),  & 
G1H8(29),G1H8(30),G1H8(35),G1H8(40),G1H8(36),8)
  call HG1shiftOLR(G1H8(30),32,8)
  call Hotf_4pt_reduction(G2H8(6),RedSet_4(35),mass4set(:,1),  & 
G1H8(39),G1H8(41),G1H8(44),G1H8(45),G1H8(46),8)
  call HG1shiftOLR(G1H8(41),16,8)
  call Hloop_QA_V(ntryL,G2H4(26),ex5(:),G2H2(17),m3h2x2(:,14),heltab2x4(:,:,22))
  call Hotf_4pt_reduction(G2H8(7),RedSet_4(36),mass4set(:,1),  & 
G1H8(51),G1H8(56),G1H8(52),G1H8(55),G1H8(57),8)
  call HG1shiftOLR(G1H8(56),16,8)
  call Hotf_4pt_reduction(G2H8(8),RedSet_4(36),mass4set(:,1),  & 
G1H8(60),G1H8(17),G1H8(18),G1H8(33),G1H8(34),8)
  call HG1shiftOLR(G1H8(17),16,8)
call HGT_w2_OLR(G1H16(1),1,1,16)
call HGT_w2_invQ_OLR(G1H16(1),2,5,16)
  call Hloop_AW_Q(ntryL,G1H16(1),wf4(:,4),G1H4(27),m3h4x4(:,31),heltab2x16(:,:,39))
  call Hloop_A_Q(ntryL,G1H4(27),121,0,G2H4(8),n2h4(49))
  call Hotf_4pt_reduction(G2H8(16),RedSet_4(9),mass4set(:,1),  & 
G1H8(49),G1H8(50),G1H8(1),G1H8(2),G1H8(5),8)
  call HG1shiftOLR(G1H8(50),32,8)
call HGT_w2_OLR(G1H16(2),1,1,16)
call HGT_w2_invQ_OLR(G1H16(2),2,5,16)
  call Hloop_AW_Q(ntryL,G1H16(2),wf4(:,4),G1H4(28),m3h4x4(:,32),heltab2x16(:,:,40))
  call Hloop_A_Q(ntryL,G1H4(28),121,0,G2H4(5),n2h4(50))
  call Hotf_4pt_reduction(G2H8(21),RedSet_4(9),mass4set(:,1),  & 
G1H8(6),G1H8(7),G1H8(8),G1H8(47),G1H8(15),8)
  call HG1shiftOLR(G1H8(7),32,8)
call HGT_w2_OLR(G1H16(4),1,1,16)
call HGT_w2_invQ_OLR(G1H16(4),2,5,16)
  call Hloop_AV_Q(ntryL,G1H16(4),wf4(:,2),G1H4(15),m3h4x4(:,33),heltab2x16(:,:,41))
  call Hloop_A_Q(ntryL,G1H4(15),118,0,G2H4(23),n2h4(51))
  call Hotf_4pt_reduction(G2H8(24),RedSet_4(12),mass4set(:,1),  & 
G1H8(31),G1H8(16),G1H8(32),G1H8(48),G1H8(61),8)
  call HG1shiftOLR(G1H8(16),32,8)
call HGT_w2_OLR(G1H16(5),1,1,16)
call HGT_w2_invQ_OLR(G1H16(5),2,5,16)
  call Hloop_AZ_Q(ntryL,G1H16(5),wf4(:,7),G1H4(26),ngZu,m3h4x4(:,34),heltab2x16(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(26),118,0,G2H4(15),n2h4(52))
  call Hloop_VA_Q(ntryL,G1H8(3),ex5(:),G1H4(10),m3h2x4(:,16),heltab2x8(:,:,33))
  call Hloop_A_Q(ntryL,G1H4(10),118,0,G2H4(13),n2h4(53))
  call Hloop_VA_Q(ntryL,G1H8(4),ex5(:),G1H4(11),m3h2x4(:,17),heltab2x8(:,:,34))
  call Hloop_A_Q(ntryL,G1H4(11),118,0,G2H4(10),n2h4(54))
  call Hloop_VQ_A(ntryL,G1H8(9),ex6(:),G1H4(16),m3h2x4(:,18),heltab2x8(:,:,35))
  call Hloop_Q_A(ntryL,G1H4(16),118,0,G2H4(6),n2h4(55))
  call Hloop_VQ_A(ntryL,G1H8(10),ex6(:),G1H4(17),m3h2x4(:,19),heltab2x8(:,:,36))
  call Hloop_Q_A(ntryL,G1H4(17),118,0,G2H4(2),n2h4(56))
  call Hloop_AV_Q(ntryL,G1H8(21),wf4(:,2),G1H2(6),m3h4x2(:,18),heltab2x8(:,:,37))
  call Hloop_A_Q(ntryL,G1H2(6),95,0,G2H2(1),n2h2(16))
  call Hloop_AV_Q(ntryL,G1H8(22),wf4(:,2),G1H2(17),m3h4x2(:,19),heltab2x8(:,:,38))
  call Hloop_A_Q(ntryL,G1H2(17),95,0,G2H2(3),n2h2(17))
  call Hloop_AV_Q(ntryL,G1H8(26),wf4(:,2),G1H2(28),m3h4x2(:,20),heltab2x8(:,:,39))
  call Hloop_A_Q(ntryL,G1H2(28),95,0,G2H2(4),n2h2(18))
  call Hloop_AV_Q(ntryL,G1H8(27),wf4(:,2),G1H2(39),m3h4x2(:,21),heltab2x8(:,:,40))
  call Hloop_A_Q(ntryL,G1H2(39),95,0,G2H2(6),n2h2(19))
  call Hloop_AZ_Q(ntryL,G1H8(37),wf4(:,7),G1H2(1),ngZd,m3h4x2(:,22),heltab2x8(:,:,41))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(7),n2h2(20))
  call Hloop_AZ_Q(ntryL,G1H8(38),wf4(:,7),G1H2(2),ngZd,m3h4x2(:,23),heltab2x8(:,:,42))
  call Hloop_A_Q(ntryL,G1H2(2),95,0,G2H2(9),n2h2(21))
  call Hloop_AZ_Q(ntryL,G1H8(42),wf4(:,7),G1H2(7),ngZd,m3h4x2(:,24),heltab2x8(:,:,43))
  call Hloop_A_Q(ntryL,G1H2(7),95,0,G2H2(10),n2h2(22))
  call Hloop_AZ_Q(ntryL,G1H8(43),wf4(:,7),G1H2(8),ngZd,m3h4x2(:,25),heltab2x8(:,:,44))
  call Hloop_A_Q(ntryL,G1H2(8),95,0,G2H2(12),n2h2(23))
  call Hloop_AW_Q(ntryL,G1H8(53),wf4(:,4),G1H2(12),m3h4x2(:,26),heltab2x8(:,:,45))
  call Hloop_A_Q(ntryL,G1H2(12),95,0,G2H2(20),n2h2(24))
  call Hloop_AW_Q(ntryL,G1H8(54),wf4(:,4),G1H2(13),m3h4x2(:,27),heltab2x8(:,:,46))
  call Hloop_A_Q(ntryL,G1H2(13),95,0,G2H2(22),n2h2(25))
  call Hloop_AW_Q(ntryL,G1H8(58),wf4(:,4),G1H2(18),m3h4x2(:,28),heltab2x8(:,:,47))
  call Hloop_A_Q(ntryL,G1H2(18),95,0,G2H2(25),n2h2(26))
  call Hloop_AW_Q(ntryL,G1H8(59),wf4(:,4),G1H2(19),m3h4x2(:,29),heltab2x8(:,:,48))
  call Hloop_A_Q(ntryL,G1H2(19),95,0,G2H2(27),n2h2(27))
  call Hloop_AQ_V(ntryL,G2H4(1),ex6(:),G2H2(30),m3h2x2(:,15),heltab2x4(:,:,23))
  call Hloop_AQ_V(ntryL,G2H4(4),ex6(:),G2H2(31),m3h2x2(:,16),heltab2x4(:,:,24))
  call Hloop_QA_V(ntryL,G2H4(9),ex5(:),G2H2(32),m3h2x2(:,17),heltab2x4(:,:,25))
  call Hloop_QA_V(ntryL,G2H4(12),ex5(:),G2H2(33),m3h2x2(:,18),heltab2x4(:,:,26))
  call Hloop_QA_V(ntryL,G2H16(6),wf8(:,10),G2H2(34),m3h8x2(:,1),heltab2x16(:,:,43))
  call Hloop_AQ_V(ntryL,G2H16(9),ex6(:),G2H8(17),m3h2x8(:,9),heltab2x16(:,:,44))
  call Hotf_4pt_reduction(G2H32(1),RedSet_4(3),mass4set(:,1),  & 
G1H32(23),G1H32(24),G1H32(3),G1H32(9),G1H32(15),32)
  call HG1shiftOLR(G1H32(24),41,32)
  call Hotf_4pt_reduction(G2H32(2),RedSet_4(3),mass4set(:,1),  & 
G1H32(21),G1H32(4),G1H32(5),G1H32(1),G1H32(2),32)
  call HG1shiftOLR(G1H32(4),41,32)
  call Hloop_AQ_V(ntryL,G2H16(12),wf8(:,2),G2H2(35),m3h8x2(:,2),heltab2x16(:,:,45))
  call Hloop_QA_V(ntryL,G2H16(5),ex5(:),G2H8(19),m3h2x8(:,10),heltab2x16(:,:,46))
  call Hloop_QA_V(ntryL,G2H16(7),wf8(:,12),G2H2(36),m3h8x2(:,3),heltab2x16(:,:,47))
  call Hloop_QA_V(ntryL,G2H16(11),wf8(:,14),G2H2(37),m3h8x2(:,4),heltab2x16(:,:,48))
  call Hloop_AQ_V(ntryL,G2H16(2),ex6(:),G2H8(2),m3h2x8(:,11),heltab2x16(:,:,49))
  call Hloop_AQ_V(ntryL,G2H16(3),ex6(:),G2H8(9),m3h2x8(:,12),heltab2x16(:,:,50))
  call Hotf_4pt_reduction(G2H32(3),RedSet_4(2),mass4set(:,1),  & 
G1H32(6),G1H32(7),G1H32(8),G1H32(10),G1H32(11),32)
  call HG1shiftOLR(G1H32(7),38,32)
  call Hotf_4pt_reduction(G2H32(4),RedSet_4(2),mass4set(:,1),  & 
G1H32(12),G1H32(13),G1H32(14),G1H32(16),G1H32(17),32)
  call HG1shiftOLR(G1H32(13),38,32)
  call Hloop_AQ_V(ntryL,G2H16(13),wf8(:,4),G2H2(38),m3h8x2(:,5),heltab2x16(:,:,51))
  call Hloop_AQ_V(ntryL,G2H16(14),wf8(:,6),G2H2(39),m3h8x2(:,6),heltab2x16(:,:,52))
  call Hloop_QA_V(ntryL,G2H16(15),ex5(:),G2H8(20),m3h2x8(:,13),heltab2x16(:,:,53))
  call Hloop_QA_V(ntryL,G2H16(16),ex5(:),G2H8(1),m3h2x8(:,14),heltab2x16(:,:,54))
  call Hotf_4pt_reduction(G2H32(5),RedSet_4(1),mass4set(:,1),  & 
G1H32(18),G1H32(19),G1H32(20),G1H32(22),G1H32(25),32)
  call HG1shiftOLR(G1H32(19),32,32)
  call Hotf_4pt_reduction(G2H32(6),RedSet_4(1),mass4set(:,1),  & 
G1H32(26),G1H32(27),G1H32(28),G1H32(29),G1H32(30),32)
  call HG1shiftOLR(G1H32(27),32,32)
  call Hotf_4pt_reduction(G2H32(7),RedSet_4(1),mass4set(:,1),  & 
G1H32(31),G1H32(32),G1H32(33),G1H32(34),G1H32(35),32)
  call HG1shiftOLR(G1H32(32),32,32)
  call Hotf_4pt_reduction(G2H32(8),RedSet_4(1),mass4set(:,1),  & 
G1H32(36),G1H32(37),G1H32(38),G1H32(39),G1H32(40),32)
  call HG1shiftOLR(G1H32(37),32,32)
  call Hotf_4pt_reduction(G2H32(9),RedSet_4(1),mass4set(:,1),  & 
G1H32(41),G1H32(42),G1H32(43),G1H32(44),G1H32(45),32)
  call HG1shiftOLR(G1H32(42),32,32)
  call Hotf_4pt_reduction(G2H32(10),RedSet_4(1),mass4set(:,1),  & 
G1H32(46),G1H32(47),G1H32(48),G1H32(49),G1H32(50),32)
  call HG1shiftOLR(G1H32(47),32,32)
  call Hloop_AW_Q(ntryL,G1H8(11),wf4(:,4),G1H2(23),m3h4x2(:,30),heltab2x8(:,:,49))
  call Hloop_A_Q(ntryL,G1H2(23),95,0,G2H2(40),n2h2(28))
call HGT_raise_alpha_OLR(G1H8(12),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(12),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(12),ex6(:),G1H4(21),m3h2x4(:,20),heltab2x8(:,:,50))
  call Hloop_AW_Q(ntryL,G1H8(14),wf4(:,4),G1H2(24),m3h4x2(:,31),heltab2x8(:,:,51))
  call Hloop_A_Q(ntryL,G1H2(24),95,0,G2H2(41),n2h2(29))
  call Hloop_AW_Q(ntryL,G1H8(19),wf4(:,4),G1H2(29),m3h4x2(:,32),heltab2x8(:,:,52))
  call Hloop_A_Q(ntryL,G1H2(29),95,0,G2H2(42),n2h2(30))
  call Hloop_AV_Q(ntryL,G1H8(24),wf4(:,2),G1H2(30),m3h4x2(:,33),heltab2x8(:,:,53))
  call Hloop_A_Q(ntryL,G1H2(30),95,0,G2H2(43),n2h2(31))
call HGT_raise_alpha_OLR(G1H8(20),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(20),ex6(:),G1H4(22),m3h2x4(:,21),heltab2x8(:,:,54))
  call Hloop_AV_Q(ntryL,G1H8(25),wf4(:,2),G1H2(34),m3h4x2(:,34),heltab2x8(:,:,55))
  call Hloop_A_Q(ntryL,G1H2(34),95,0,G2H2(44),n2h2(32))
  call Hloop_AV_Q(ntryL,G1H8(28),wf4(:,2),G1H2(35),m3h4x2(:,35),heltab2x8(:,:,56))
  call Hloop_A_Q(ntryL,G1H2(35),95,0,G2H2(45),n2h2(33))
  call Hloop_AZ_Q(ntryL,G1H8(29),wf4(:,7),G1H2(40),ngZd,m3h4x2(:,36),heltab2x8(:,:,57))
  call Hloop_A_Q(ntryL,G1H2(40),95,0,G2H2(46),n2h2(34))
call HGT_raise_alpha_OLR(G1H8(30),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(30),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(30),ex6(:),G1H4(27),m3h2x4(:,22),heltab2x8(:,:,58))
  call Hloop_AZ_Q(ntryL,G1H8(40),wf4(:,7),G1H2(41),ngZd,m3h4x2(:,37),heltab2x8(:,:,59))
  call Hloop_A_Q(ntryL,G1H2(41),95,0,G2H2(47),n2h2(35))
  call Hloop_AZ_Q(ntryL,G1H8(36),wf4(:,7),G1H2(6),ngZd,m3h4x2(:,38),heltab2x8(:,:,60))
  call Hloop_A_Q(ntryL,G1H2(6),95,0,G2H2(48),n2h2(36))
  call Hloop_QW_A(ntryL,G1H8(39),wf4(:,4),G1H2(17),m3h4x2(:,39),heltab2x8(:,:,61))
  call Hloop_Q_A(ntryL,G1H2(17),111,0,G2H2(49),n2h2(37))
call HGT_raise_alpha_OLR(G1H8(41),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(41),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(41),ex5(:),G1H4(28),m3h2x4(:,23),heltab2x8(:,:,62))
  call Hloop_QW_A(ntryL,G1H8(45),wf4(:,4),G1H2(28),m3h4x2(:,40),heltab2x8(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(28),111,0,G2H2(50),n2h2(38))
  call Hloop_QW_A(ntryL,G1H8(46),wf4(:,4),G1H2(39),m3h4x2(:,41),heltab2x8(:,:,64))
  call Hloop_Q_A(ntryL,G1H2(39),111,0,G2H2(51),n2h2(39))
  call Hloop_QV_A(ntryL,G1H8(51),wf4(:,2),G1H2(1),m3h4x2(:,42),heltab2x8(:,:,65))
  call Hloop_Q_A(ntryL,G1H2(1),111,0,G2H2(52),n2h2(40))
call HGT_raise_alpha_OLR(G1H8(56),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(56),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(56),ex5(:),G1H4(15),m3h2x4(:,24),heltab2x8(:,:,66))
  call Hloop_QV_A(ntryL,G1H8(55),wf4(:,2),G1H2(2),m3h4x2(:,43),heltab2x8(:,:,67))
  call Hloop_Q_A(ntryL,G1H2(2),111,0,G2H2(53),n2h2(41))
  call Hloop_QV_A(ntryL,G1H8(57),wf4(:,2),G1H2(7),m3h4x2(:,44),heltab2x8(:,:,68))
  call Hloop_Q_A(ntryL,G1H2(7),111,0,G2H2(54),n2h2(42))
  call Hloop_QZ_A(ntryL,G1H8(60),wf4(:,7),G1H2(8),ngZu,m3h4x2(:,45),heltab2x8(:,:,69))
  call Hloop_Q_A(ntryL,G1H2(8),111,0,G2H2(55),n2h2(43))
call HGT_raise_alpha_OLR(G1H8(17),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(17),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(17),ex5(:),G1H4(26),m3h2x4(:,25),heltab2x8(:,:,70))
  call Hloop_QZ_A(ntryL,G1H8(33),wf4(:,7),G1H2(12),ngZu,m3h4x2(:,46),heltab2x8(:,:,71))
  call Hloop_Q_A(ntryL,G1H2(12),111,0,G2H2(56),n2h2(44))
  call Hloop_QZ_A(ntryL,G1H8(34),wf4(:,7),G1H2(13),ngZu,m3h4x2(:,47),heltab2x8(:,:,72))
  call Hloop_Q_A(ntryL,G1H2(13),111,0,G2H2(57),n2h2(45))
  call Hloop_AV_Q(ntryL,G1H8(49),wf4(:,2),G1H2(18),m3h4x2(:,48),heltab2x8(:,:,73))
  call Hloop_A_Q(ntryL,G1H2(18),95,0,G2H2(58),n2h2(46))
call HGT_raise_alpha_OLR(G1H8(50),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(50),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(50),ex6(:),G1H4(10),m3h2x4(:,26),heltab2x8(:,:,74))
  call Hloop_AV_Q(ntryL,G1H8(2),wf4(:,2),G1H2(19),m3h4x2(:,49),heltab2x8(:,:,75))
  call Hloop_A_Q(ntryL,G1H2(19),95,0,G2H2(59),n2h2(47))
  call Hloop_AV_Q(ntryL,G1H8(5),wf4(:,2),G1H2(23),m3h4x2(:,50),heltab2x8(:,:,76))
  call Hloop_A_Q(ntryL,G1H2(23),95,0,G2H2(60),n2h2(48))
  call Hloop_AZ_Q(ntryL,G1H8(6),wf4(:,7),G1H2(24),ngZd,m3h4x2(:,51),heltab2x8(:,:,77))
  call Hloop_A_Q(ntryL,G1H2(24),95,0,G2H2(61),n2h2(49))
call HGT_raise_alpha_OLR(G1H8(7),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(7),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(7),ex6(:),G1H4(11),m3h2x4(:,27),heltab2x8(:,:,78))
  call Hloop_AZ_Q(ntryL,G1H8(47),wf4(:,7),G1H2(29),ngZd,m3h4x2(:,52),heltab2x8(:,:,79))
  call Hloop_A_Q(ntryL,G1H2(29),95,0,G2H2(62),n2h2(50))
  call Hloop_AZ_Q(ntryL,G1H8(15),wf4(:,7),G1H2(30),ngZd,m3h4x2(:,53),heltab2x8(:,:,80))
  call Hloop_A_Q(ntryL,G1H2(30),95,0,G2H2(63),n2h2(51))
  call Hloop_AW_Q(ntryL,G1H8(31),wf4(:,4),G1H2(34),m3h4x2(:,54),heltab2x8(:,:,81))
  call Hloop_A_Q(ntryL,G1H2(34),95,0,G2H2(64),n2h2(52))
call HGT_raise_alpha_OLR(G1H8(16),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(16),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(16),ex6(:),G1H4(16),m3h2x4(:,28),heltab2x8(:,:,82))
  call Hloop_AW_Q(ntryL,G1H8(48),wf4(:,4),G1H2(35),m3h4x2(:,55),heltab2x8(:,:,83))
  call Hloop_A_Q(ntryL,G1H2(35),95,0,G2H2(65),n2h2(53))
  call Hloop_AW_Q(ntryL,G1H8(61),wf4(:,4),G1H2(40),m3h4x2(:,56),heltab2x8(:,:,84))
  call Hloop_A_Q(ntryL,G1H2(40),95,0,G2H2(66),n2h2(54))
  call Hloop_AV_Q(ntryL,G1H32(23),wf4(:,2),G1H8(3),m3h4x8(:,25),heltab2x32(:,:,29))
  call Hloop_A_Q(ntryL,G1H8(3),86,0,G2H8(11),n2h8(49))
call HGT_raise_alpha_OLR(G1H32(24),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(24),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(24),wf8(:,2),G1H4(17),m3h8x4(:,1),heltab2x32(:,:,30))
  call Hloop_AV_Q(ntryL,G1H32(9),wf4(:,2),G1H8(4),m3h4x8(:,26),heltab2x32(:,:,31))
  call Hloop_A_Q(ntryL,G1H8(4),86,0,G2H8(12),n2h8(50))
  call Hloop_AV_Q(ntryL,G1H32(15),wf4(:,2),G1H8(9),m3h4x8(:,27),heltab2x32(:,:,32))
  call Hloop_A_Q(ntryL,G1H8(9),86,0,G2H8(13),n2h8(51))
  call Hloop_AZ_Q(ntryL,G1H32(21),wf4(:,7),G1H8(10),ngZu,m3h4x8(:,28),heltab2x32(:,:,33))
  call Hloop_A_Q(ntryL,G1H8(10),86,0,G2H8(15),n2h8(52))
call HGT_raise_alpha_OLR(G1H32(4),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(4),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(4),wf8(:,2),G1H4(32),m3h8x4(:,2),heltab2x32(:,:,34))
  call Hloop_AZ_Q(ntryL,G1H32(1),wf4(:,7),G1H8(21),ngZu,m3h4x8(:,29),heltab2x32(:,:,35))
  call Hloop_A_Q(ntryL,G1H8(21),86,0,G2H8(10),n2h8(53))
  call Hloop_AZ_Q(ntryL,G1H32(2),wf4(:,7),G1H8(22),ngZu,m3h4x8(:,30),heltab2x32(:,:,36))
  call Hloop_A_Q(ntryL,G1H8(22),86,0,G2H8(14),n2h8(54))
  call Hloop_AW_Q(ntryL,G1H32(6),wf4(:,4),G1H8(26),m3h4x8(:,31),heltab2x32(:,:,37))
  call Hloop_A_Q(ntryL,G1H8(26),89,0,G2H8(23),n2h8(55))
call HGT_raise_alpha_OLR(G1H32(7),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(7),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(7),wf8(:,4),G1H4(33),m3h8x4(:,3),heltab2x32(:,:,38))
  call Hloop_AW_Q(ntryL,G1H32(10),wf4(:,4),G1H8(27),m3h4x8(:,32),heltab2x32(:,:,39))
  call Hloop_A_Q(ntryL,G1H8(27),89,0,G2H8(22),n2h8(56))
  call Hloop_AW_Q(ntryL,G1H32(11),wf4(:,4),G1H8(37),m3h4x8(:,33),heltab2x32(:,:,40))
  call Hloop_A_Q(ntryL,G1H8(37),89,0,G2H8(18),n2h8(57))
  call Hloop_AW_Q(ntryL,G1H32(12),wf4(:,4),G1H8(38),m3h4x8(:,34),heltab2x32(:,:,41))
  call Hloop_A_Q(ntryL,G1H8(38),89,0,G2H8(3),n2h8(58))
call HGT_raise_alpha_OLR(G1H32(13),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(13),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(13),wf8(:,6),G1H4(34),m3h8x4(:,4),heltab2x32(:,:,42))
  call Hloop_AW_Q(ntryL,G1H32(16),wf4(:,4),G1H8(42),m3h4x8(:,35),heltab2x32(:,:,43))
  call Hloop_A_Q(ntryL,G1H8(42),89,0,G2H8(4),n2h8(59))
  call Hloop_AW_Q(ntryL,G1H32(17),wf4(:,4),G1H8(43),m3h4x8(:,36),heltab2x32(:,:,44))
  call Hloop_A_Q(ntryL,G1H8(43),89,0,G2H8(5),n2h8(60))
  call Hloop_AW_Q(ntryL,G1H32(18),wf16(:,27),G1H2(41),m3h16x2(:,1),heltab2x32(:,:,45))
  call Hloop_A_Q(ntryL,G1H2(41),95,0,G2H2(67),n2h2(55))
call HGT_raise_alpha_OLR(G1H32(19),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(19),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(19),ex6(:),G1H16(25),m3h2x16(:,5),heltab2x32(:,:,46))
  call Hloop_AW_Q(ntryL,G1H32(22),wf16(:,27),G1H2(6),m3h16x2(:,2),heltab2x32(:,:,47))
  call Hloop_A_Q(ntryL,G1H2(6),95,0,G2H2(68),n2h2(56))
  call Hloop_AW_Q(ntryL,G1H32(25),wf16(:,27),G1H2(17),m3h16x2(:,3),heltab2x32(:,:,48))
  call Hloop_A_Q(ntryL,G1H2(17),95,0,G2H2(69),n2h2(57))
  call Hloop_AW_Q(ntryL,G1H32(26),wf16(:,28),G1H2(28),m3h16x2(:,4),heltab2x32(:,:,49))
  call Hloop_A_Q(ntryL,G1H2(28),95,0,G2H2(70),n2h2(58))
call HGT_raise_alpha_OLR(G1H32(27),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(27),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(27),ex6(:),G1H16(26),m3h2x16(:,6),heltab2x32(:,:,50))
  call Hloop_AW_Q(ntryL,G1H32(29),wf16(:,28),G1H2(39),m3h16x2(:,5),heltab2x32(:,:,51))
  call Hloop_A_Q(ntryL,G1H2(39),95,0,G2H2(71),n2h2(59))
  call Hloop_AW_Q(ntryL,G1H32(30),wf16(:,28),G1H2(1),m3h16x2(:,6),heltab2x32(:,:,52))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(72),n2h2(60))
  call Hloop_AW_Q(ntryL,G1H32(31),wf16(:,59),G1H2(2),m3h16x2(:,7),heltab2x32(:,:,53))
  call Hloop_A_Q(ntryL,G1H2(2),95,0,G2H2(73),n2h2(61))
call HGT_raise_alpha_OLR(G1H32(32),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(32),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(32),ex6(:),G1H16(28),m3h2x16(:,7),heltab2x32(:,:,54))
  call Hloop_AW_Q(ntryL,G1H32(34),wf16(:,59),G1H2(7),m3h16x2(:,8),heltab2x32(:,:,55))
  call Hloop_A_Q(ntryL,G1H2(7),95,0,G2H2(74),n2h2(62))
  call Hloop_AW_Q(ntryL,G1H32(35),wf16(:,59),G1H2(8),m3h16x2(:,9),heltab2x32(:,:,56))
  call Hloop_A_Q(ntryL,G1H2(8),95,0,G2H2(75),n2h2(63))
  call Hloop_AW_Q(ntryL,G1H32(36),wf16(:,60),G1H2(12),m3h16x2(:,10),heltab2x32(:,:,57))
  call Hloop_A_Q(ntryL,G1H2(12),95,0,G2H2(76),n2h2(64))
call HGT_raise_alpha_OLR(G1H32(37),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(37),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(37),ex6(:),G1H16(29),m3h2x16(:,8),heltab2x32(:,:,58))
  call Hloop_AW_Q(ntryL,G1H32(39),wf16(:,60),G1H2(13),m3h16x2(:,11),heltab2x32(:,:,59))
  call Hloop_A_Q(ntryL,G1H2(13),95,0,G2H2(77),n2h2(65))
  call Hloop_AW_Q(ntryL,G1H32(40),wf16(:,60),G1H2(18),m3h16x2(:,12),heltab2x32(:,:,60))
  call Hloop_A_Q(ntryL,G1H2(18),95,0,G2H2(78),n2h2(66))
  call Hloop_AW_Q(ntryL,G1H32(41),wf16(:,61),G1H2(19),m3h16x2(:,13),heltab2x32(:,:,61))
  call Hloop_A_Q(ntryL,G1H2(19),95,0,G2H2(79),n2h2(67))
call HGT_raise_alpha_OLR(G1H32(42),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(42),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(42),ex6(:),G1H16(30),m3h2x16(:,9),heltab2x32(:,:,62))
  call Hloop_AW_Q(ntryL,G1H32(44),wf16(:,61),G1H2(23),m3h16x2(:,14),heltab2x32(:,:,63))
  call Hloop_A_Q(ntryL,G1H2(23),95,0,G2H2(80),n2h2(68))
  call Hloop_AW_Q(ntryL,G1H32(45),wf16(:,61),G1H2(24),m3h16x2(:,15),heltab2x32(:,:,64))
  call Hloop_A_Q(ntryL,G1H2(24),95,0,G2H2(81),n2h2(69))
  call Hloop_AW_Q(ntryL,G1H32(46),wf16(:,62),G1H2(29),m3h16x2(:,16),heltab2x32(:,:,65))
  call Hloop_A_Q(ntryL,G1H2(29),95,0,G2H2(82),n2h2(70))
call HGT_raise_alpha_OLR(G1H32(47),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(47),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(47),ex6(:),G1H16(31),m3h2x16(:,10),heltab2x32(:,:,66))
  call Hloop_AW_Q(ntryL,G1H32(49),wf16(:,62),G1H2(30),m3h16x2(:,17),heltab2x32(:,:,67))
  call Hloop_A_Q(ntryL,G1H2(30),95,0,G2H2(83),n2h2(71))
  call Hloop_AW_Q(ntryL,G1H32(50),wf16(:,62),G1H2(34),m3h16x2(:,18),heltab2x32(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(34),95,0,G2H2(84),n2h2(72))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(35),[G2H2(2),G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(39),[G2H2(38),G2H2(5),G1H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(34),[G2H2(8),G1H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(37),[G2H2(36),G2H2(11),G1H2(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(31),[G1H2(14)])
call HGT_OLR(G2H2(13),1,1,2)
call HGT_invQ_OLR(G2H2(13),2,5,2)
call HGT_OLR(G2H2(13),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G2H2(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G1H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(33),[G1H2(36)])
call HGT_OLR(G2H2(14),1,1,2)
call HGT_invQ_OLR(G2H2(14),2,5,2)
call HGT_OLR(G2H2(14),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G2H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(19),[G1H4(25)])
call HGT_w2_OLR(G1H4(1),1,1,4)
call HGT_w2_invQ_OLR(G1H4(1),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(82),[G2H2(79),G2H2(76),G2H2(73),G2H2(70),G2H2(67) &
    ,G2H2(26),G2H2(21),G2H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(84),[G2H2(81),G2H2(78),G2H2(75),G2H2(72),G2H2(69) &
    ,G2H2(29),G2H2(28),G2H2(24),G2H2(23),G2H2(19),G2H2(18)])
call HGT_w2_OLR(G1H4(4),1,1,4)
call HGT_w2_invQ_OLR(G1H4(4),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(5),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(15),[G2H4(23)])
call HGT_w2_OLR(G1H4(7),1,1,4)
call HGT_w2_invQ_OLR(G1H4(7),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(15),[G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(30),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(15),[G1H2(15),G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(21),[G1H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G1H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G1H2(37),G1H2(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(43),[G1H2(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(10),[G1H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(2),[G1H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(48),[G2H2(45),G2H2(10),G2H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(63),[G2H2(60),G2H2(12),G2H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(42),[G2H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(66),[G2H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(46),[G2H2(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(55),[G2H2(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(57),[G2H2(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(61),[G2H2(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(15),[G2H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(14),[G2H8(13)])
  call Hotf_4pt_reduction(G2H2(35),RedSet_4(16),mass4set(:,1),  & 
G1H2(35),G1H2(40),G1H2(41),G1H2(6),G1H2(17),2)
  call HG1shiftOLR(G1H2(40),16,2)
  call Hotf_4pt_reduction(G2H2(39),RedSet_4(19),mass4set(:,1),  & 
G1H2(28),G1H2(39),G1H2(1),G1H2(2),G1H2(7),2)
  call HG1shiftOLR(G1H2(39),16,2)
  call Hotf_4pt_reduction(G2H2(34),RedSet_4(23),mass4set(:,1),  & 
G1H2(8),G1H2(12),G1H2(13),G1H2(18),G1H2(19),2)
  call HG1shiftOLR(G1H2(12),32,2)
  call Hotf_4pt_reduction(G2H2(37),RedSet_4(26),mass4set(:,1),  & 
G1H2(23),G1H2(24),G1H2(29),G1H2(30),G1H2(34),2)
  call HG1shiftOLR(G1H2(24),32,2)
  call Hotf_4pt_reduction(G2H2(13),RedSet_4(18),mass4set(:,1),  & 
G1H2(5),G1H2(16),G1H2(27),G1H2(38),G1H2(14),2)
  call HG1shiftOLR(G1H2(16),16,2)
  call Hotf_4pt_reduction(G2H4(7),RedSet_4(30),mass4set(:,1),  & 
G1H4(14),G1H4(25),G1H4(1),G1H4(4),G1H4(7),4)
  call HG1shiftOLR(G1H4(25),9,4)
  call Hotf_4pt_reduction(G2H2(14),RedSet_4(25),mass4set(:,1),  & 
G1H2(36),G1H2(3),G1H2(15),G1H2(4),G1H2(10),2)
  call HG1shiftOLR(G1H2(3),32,2)
  call Hotf_4pt_reduction(G2H4(19),RedSet_4(30),mass4set(:,1),  & 
G1H4(12),G1H4(13),G1H4(23),G1H4(24),G1H4(35),4)
  call HG1shiftOLR(G1H4(13),9,4)
  call Hotf_4pt_reduction(G2H4(8),RedSet_4(37),mass4set(:,1),  & 
G1H4(36),G1H4(37),G1H4(38),G1H4(39),G1H4(40),4)
  call HG1shiftOLR(G1H4(37),6,4)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(82),ex6(:),G2tensor(1),m3h2x1(:,21),heltab2x2(:,:,21))
call HGT_w2_OLR(G1H4(2),1,1,4)
call HGT_w2_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_AV_Q(ntryL,G1H4(2),wf4(:,2),G1H1(1),m3h4x1(:,9),heltab2x4(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(3),n2h1(25))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(84),ex6(:),G2tensor(5),m3h2x1(:,22),heltab2x2(:,:,22))
call HGT_w2_OLR(G1H4(3),1,1,4)
call HGT_w2_invQ_OLR(G1H4(3),2,5,4)
  call Hloop_AV_Q(ntryL,G1H4(3),wf4(:,2),G1H1(1),m3h4x1(:,10),heltab2x4(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,0,G2tensor(9),n2h1(26))
  call Hotf_4pt_reduction(G2H4(5),RedSet_4(37),mass4set(:,1),  & 
G1H4(2),G1H4(3),G1H4(41),G1H4(42),G1H4(43),4)
  call HG1shiftOLR(G1H4(3),6,4)
call HGT_w2_OLR(G1H4(5),1,1,4)
call HGT_w2_invQ_OLR(G1H4(5),2,5,4)
  call Hloop_AZ_Q(ntryL,G1H4(5),wf4(:,7),G1H1(1),ngZd,m3h4x1(:,11),heltab2x4(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(13),n2h1(27))
call HGT_w2_OLR(G1H4(6),1,1,4)
call HGT_w2_invQ_OLR(G1H4(6),2,5,4)
  call Hloop_AZ_Q(ntryL,G1H4(6),wf4(:,7),G1H1(1),ngZd,m3h4x1(:,12),heltab2x4(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,0,G2tensor(17),n2h1(28))
  call Hotf_4pt_reduction(G2H4(15),RedSet_4(38),mass4set(:,1),  & 
G1H4(5),G1H4(6),G1H4(44),G1H4(45),G1H4(46),4)
  call HG1shiftOLR(G1H4(6),9,4)
call HGT_w2_OLR(G1H4(8),1,1,4)
call HGT_w2_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_AW_Q(ntryL,G1H4(8),wf4(:,4),G1H1(1),m3h4x1(:,13),heltab2x4(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(21),n2h1(29))
call HGT_w2_OLR(G1H4(9),1,1,4)
call HGT_w2_invQ_OLR(G1H4(9),2,5,4)
  call Hloop_AW_Q(ntryL,G1H4(9),wf4(:,4),G1H1(1),m3h4x1(:,14),heltab2x4(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,0,G2tensor(25),n2h1(30))
  call Hotf_4pt_reduction(G2H2(30),RedSet_4(14),mass4set(:,1),  & 
G1H2(25),G1H2(37),G1H2(26),G1H2(32),G1H2(45),2)
  call HG1shiftOLR(G1H2(37),16,2)
  call Hotf_4pt_reduction(G2H2(15),RedSet_4(15),mass4set(:,1),  & 
G1H2(46),G1H2(47),G1H2(48),G1H2(49),G1H2(50),2)
  call HG1shiftOLR(G1H2(47),16,2)
  call Hloop_VA_Q(ntryL,G1H2(9),ex5(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(29),n2h1(31))
  call Hloop_VA_Q(ntryL,G1H2(21),ex5(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(30),n2h1(32))
  call Hloop_VA_Q(ntryL,G1H2(11),ex5(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(31),n2h1(33))
  call Hloop_VA_Q(ntryL,G1H2(20),ex5(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(32),n2h1(34))
  call Hloop_VA_Q(ntryL,G1H2(22),ex5(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(33),n2h1(35))
  call Hotf_4pt_reduction(G2H2(32),RedSet_4(21),mass4set(:,1),  & 
G1H2(9),G1H2(21),G1H2(11),G1H2(20),G1H2(22),2)
  call HG1shiftOLR(G1H2(21),32,2)
  call Hotf_4pt_reduction(G2H2(17),RedSet_4(22),mass4set(:,1),  & 
G1H2(51),G1H2(52),G1H2(53),G1H2(54),G1H2(55),2)
  call HG1shiftOLR(G1H2(52),32,2)
  call Hloop_VQ_A(ntryL,G1H2(31),ex6(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(34),n2h1(36))
  call Hloop_VQ_A(ntryL,G1H2(43),ex6(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(35),n2h1(37))
  call Hloop_VQ_A(ntryL,G1H2(33),ex6(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(36),n2h1(38))
  call Hloop_VQ_A(ntryL,G1H2(42),ex6(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(37),n2h1(39))
  call Hloop_VQ_A(ntryL,G1H2(44),ex6(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(38),n2h1(40))
  call Hotf_4pt_reduction(G2H4(13),RedSet_4(28),mass4set(:,1),  & 
G1H4(8),G1H4(9),G1H4(47),G1H4(48),G1H4(49),4)
  call HG1shiftOLR(G1H4(9),9,4)
  call Hotf_4pt_reduction(G2H4(10),RedSet_4(29),mass4set(:,1),  & 
G1H4(50),G1H4(51),G1H4(52),G1H4(53),G1H4(54),4)
  call HG1shiftOLR(G1H4(51),9,4)
  call Hloop_AW_Q(ntryL,G1H4(18),wf4(:,4),G1H1(1),m3h4x1(:,15),heltab2x4(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(39),n2h1(41))
  call Hloop_AW_Q(ntryL,G1H4(19),wf4(:,4),G1H1(1),m3h4x1(:,16),heltab2x4(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(40),n2h1(42))
  call Hloop_AW_Q(ntryL,G1H4(20),wf4(:,4),G1H1(1),m3h4x1(:,17),heltab2x4(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(41),n2h1(43))
  call Hotf_4pt_reduction(G2H4(6),RedSet_4(32),mass4set(:,1),  & 
G1H4(18),G1H4(19),G1H4(20),G1H4(55),G1H4(56),4)
  call HG1shiftOLR(G1H4(19),9,4)
  call Hotf_4pt_reduction(G2H4(2),RedSet_4(33),mass4set(:,1),  & 
G1H4(57),G1H4(58),G1H4(59),G1H4(60),G1H4(61),4)
  call HG1shiftOLR(G1H4(58),9,4)
  call Hloop_QW_A(ntryL,G1H4(29),wf4(:,4),G1H1(1),m3h4x1(:,18),heltab2x4(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(42),n2h1(44))
  call Hloop_QW_A(ntryL,G1H4(30),wf4(:,4),G1H1(1),m3h4x1(:,19),heltab2x4(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(43),n2h1(45))
  call Hloop_QW_A(ntryL,G1H4(31),wf4(:,4),G1H1(1),m3h4x1(:,20),heltab2x4(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(44),n2h1(46))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(48),ex6(:),G2tensor(45),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(63),ex6(:),G2tensor(46),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(42),ex6(:),G2tensor(47),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(66),ex6(:),G2tensor(48),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hotf_4pt_reduction(G2H8(17),RedSet_4(6),mass4set(:,1),  & 
G1H8(53),G1H8(54),G1H8(58),G1H8(59),G1H8(11),8)
  call HG1shiftOLR(G1H8(54),25,8)
  call Hotf_4pt_reduction(G2H8(19),RedSet_4(7),mass4set(:,1),  & 
G1H8(12),G1H8(14),G1H8(19),G1H8(24),G1H8(20),8)
  call HG1shiftOLR(G1H8(14),41,8)
  call Hotf_4pt_reduction(G2H8(2),RedSet_4(39),mass4set(:,1),  & 
G1H8(25),G1H8(28),G1H8(29),G1H8(30),G1H8(40),8)
  call HG1shiftOLR(G1H8(28),22,8)
  call Hotf_4pt_reduction(G2H8(9),RedSet_4(39),mass4set(:,1),  & 
G1H8(36),G1H8(39),G1H8(41),G1H8(45),G1H8(46),8)
  call HG1shiftOLR(G1H8(39),22,8)
  call Hotf_4pt_reduction(G2H8(20),RedSet_4(40),mass4set(:,1),  & 
G1H8(51),G1H8(56),G1H8(55),G1H8(57),G1H8(60),8)
  call HG1shiftOLR(G1H8(56),38,8)
  call Hotf_4pt_reduction(G2H8(1),RedSet_4(40),mass4set(:,1),  & 
G1H8(17),G1H8(33),G1H8(34),G1H8(49),G1H8(50),8)
  call HG1shiftOLR(G1H8(33),38,8)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(40),ex6(:),G2tensor(49),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(46),ex6(:),G2tensor(50),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(49),ex5(:),G2tensor(51),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(51),ex5(:),G2tensor(52),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(55),ex5(:),G2tensor(53),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(57),ex5(:),G2tensor(54),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(61),ex6(:),G2tensor(55),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(64),ex6(:),G2tensor(56),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(15),wf8(:,2),G2tensor(57),m3h8x1(:,1),heltab2x8(:,:,85))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(14),wf8(:,2),G2tensor(58),m3h8x1(:,2),heltab2x8(:,:,86))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(23),wf8(:,4),G2tensor(59),m3h8x1(:,3),heltab2x8(:,:,87))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(18),wf8(:,4),G2tensor(60),m3h8x1(:,4),heltab2x8(:,:,88))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(3),wf8(:,6),G2tensor(61),m3h8x1(:,5),heltab2x8(:,:,89))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(5),wf8(:,6),G2tensor(62),m3h8x1(:,6),heltab2x8(:,:,90))
  call Hloop_VA_Q(ntryL,G1H2(35),ex5(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(63),n2h1(47))
  call Hloop_VA_Q(ntryL,G1H2(40),ex5(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(64),n2h1(48))
  call Hloop_VA_Q(ntryL,G1H2(17),ex5(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(65),n2h1(49))
  call Hloop_VA_Q(ntryL,G1H2(28),ex5(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(66),n2h1(50))
  call Hloop_VA_Q(ntryL,G1H2(39),ex5(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(67),n2h1(51))
  call Hloop_VA_Q(ntryL,G1H2(7),ex5(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(68),n2h1(52))
  call Hloop_VQ_A(ntryL,G1H2(8),ex6(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(69),n2h1(53))
  call Hloop_VQ_A(ntryL,G1H2(12),ex6(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),32,0,G2tensor(70),n2h1(54))
  call Hloop_VQ_A(ntryL,G1H2(19),ex6(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(71),n2h1(55))
  call Hloop_VQ_A(ntryL,G1H2(23),ex6(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(72),n2h1(56))
  call Hloop_VQ_A(ntryL,G1H2(24),ex6(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),32,0,G2tensor(73),n2h1(57))
  call Hloop_VQ_A(ntryL,G1H2(34),ex6(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(74),n2h1(58))
  call Hloop_VA_Q(ntryL,G1H2(5),ex5(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(75),n2h1(59))
  call Hloop_VA_Q(ntryL,G1H2(16),ex5(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(76),n2h1(60))
  call Hloop_VA_Q(ntryL,G1H2(14),ex5(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(77),n2h1(61))
  call Hloop_AW_Q(ntryL,G1H4(14),wf4(:,4),G1H1(1),m3h4x1(:,21),heltab2x4(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(78),n2h1(62))
  call Hloop_AW_Q(ntryL,G1H4(25),wf4(:,4),G1H1(1),m3h4x1(:,22),heltab2x4(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,0,G2tensor(79),n2h1(63))
  call Hloop_AW_Q(ntryL,G1H4(7),wf4(:,4),G1H1(1),m3h4x1(:,23),heltab2x4(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(80),n2h1(64))
  call Hloop_VQ_A(ntryL,G1H2(36),ex6(:),G1H1(1),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(81),n2h1(65))
  call Hloop_VQ_A(ntryL,G1H2(3),ex6(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),32,0,G2tensor(82),n2h1(66))
  call Hloop_VQ_A(ntryL,G1H2(10),ex6(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(83),n2h1(67))
  call Hloop_QW_A(ntryL,G1H4(12),wf4(:,4),G1H1(1),m3h4x1(:,24),heltab2x4(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(84),n2h1(68))
  call Hloop_QW_A(ntryL,G1H4(13),wf4(:,4),G1H1(1),m3h4x1(:,25),heltab2x4(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(85),n2h1(69))
  call Hloop_QW_A(ntryL,G1H4(35),wf4(:,4),G1H1(1),m3h4x1(:,26),heltab2x4(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(86),n2h1(70))
  call Hloop_AV_Q(ntryL,G1H4(36),wf4(:,2),G1H1(1),m3h4x1(:,27),heltab2x4(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(87),n2h1(71))
  call Hloop_AV_Q(ntryL,G1H4(37),wf4(:,2),G1H1(1),m3h4x1(:,28),heltab2x4(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,0,G2tensor(88),n2h1(72))
  call Hloop_AV_Q(ntryL,G1H4(40),wf4(:,2),G1H1(1),m3h4x1(:,29),heltab2x4(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(89),n2h1(73))
  call Hloop_AZ_Q(ntryL,G1H4(2),wf4(:,7),G1H1(1),ngZd,m3h4x1(:,30),heltab2x4(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(90),n2h1(74))
  call Hloop_AZ_Q(ntryL,G1H4(3),wf4(:,7),G1H1(1),ngZd,m3h4x1(:,31),heltab2x4(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,0,G2tensor(91),n2h1(75))
  call Hloop_AZ_Q(ntryL,G1H4(43),wf4(:,7),G1H1(1),ngZd,m3h4x1(:,32),heltab2x4(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(92),n2h1(76))
  call Hloop_AW_Q(ntryL,G1H4(5),wf4(:,4),G1H1(1),m3h4x1(:,33),heltab2x4(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(93),n2h1(77))
  call Hloop_AW_Q(ntryL,G1H4(6),wf4(:,4),G1H1(1),m3h4x1(:,34),heltab2x4(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,0,G2tensor(94),n2h1(78))
  call Hloop_AW_Q(ntryL,G1H4(46),wf4(:,4),G1H1(1),m3h4x1(:,35),heltab2x4(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(95),n2h1(79))
  call Hloop_VA_Q(ntryL,G1H2(25),ex5(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(96),n2h1(80))
  call Hloop_VA_Q(ntryL,G1H2(37),ex5(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(97),n2h1(81))
  call Hloop_VA_Q(ntryL,G1H2(45),ex5(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(98),n2h1(82))
  call Hloop_VA_Q(ntryL,G1H2(46),ex5(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(99),n2h1(83))
  call Hloop_VA_Q(ntryL,G1H2(47),ex5(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(100),n2h1(84))
  call Hloop_VA_Q(ntryL,G1H2(50),ex5(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(101),n2h1(85))
  call Hloop_VQ_A(ntryL,G1H2(9),ex6(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(102),n2h1(86))
  call Hloop_VQ_A(ntryL,G1H2(21),ex6(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),32,0,G2tensor(103),n2h1(87))
  call Hloop_VQ_A(ntryL,G1H2(22),ex6(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(104),n2h1(88))
  call Hloop_VQ_A(ntryL,G1H2(51),ex6(:),G1H1(1),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(105),n2h1(89))
  call Hloop_VQ_A(ntryL,G1H2(52),ex6(:),G1H1(1),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),32,0,G2tensor(106),n2h1(90))
  call Hloop_VQ_A(ntryL,G1H2(55),ex6(:),G1H1(1),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(107),n2h1(91))
  call Hloop_AW_Q(ntryL,G1H4(8),wf4(:,4),G1H1(1),m3h4x1(:,36),heltab2x4(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(108),n2h1(92))
  call Hloop_AW_Q(ntryL,G1H4(9),wf4(:,4),G1H1(1),m3h4x1(:,37),heltab2x4(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,0,G2tensor(109),n2h1(93))
  call Hloop_AW_Q(ntryL,G1H4(49),wf4(:,4),G1H1(1),m3h4x1(:,38),heltab2x4(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(110),n2h1(94))
  call Hloop_AW_Q(ntryL,G1H4(50),wf4(:,4),G1H1(1),m3h4x1(:,39),heltab2x4(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(111),n2h1(95))
  call Hloop_AW_Q(ntryL,G1H4(51),wf4(:,4),G1H1(1),m3h4x1(:,40),heltab2x4(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,0,G2tensor(112),n2h1(96))
  call Hloop_AW_Q(ntryL,G1H4(54),wf4(:,4),G1H1(1),m3h4x1(:,41),heltab2x4(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(113),n2h1(97))
  call Hloop_QW_A(ntryL,G1H4(18),wf4(:,4),G1H1(1),m3h4x1(:,42),heltab2x4(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(114),n2h1(98))
  call Hloop_QW_A(ntryL,G1H4(19),wf4(:,4),G1H1(1),m3h4x1(:,43),heltab2x4(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(115),n2h1(99))
  call Hloop_QW_A(ntryL,G1H4(56),wf4(:,4),G1H1(1),m3h4x1(:,44),heltab2x4(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(116),n2h1(100))
  call Hloop_QW_A(ntryL,G1H4(57),wf4(:,4),G1H1(1),m3h4x1(:,45),heltab2x4(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(117),n2h1(101))
  call Hloop_QW_A(ntryL,G1H4(58),wf4(:,4),G1H1(1),m3h4x1(:,46),heltab2x4(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(118),n2h1(102))
  call Hloop_QW_A(ntryL,G1H4(61),wf4(:,4),G1H1(1),m3h4x1(:,47),heltab2x4(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(119),n2h1(103))
  call Hloop_VA_Q(ntryL,G1H8(53),wf8(:,10),G1H1(1),m3h8x1(:,7),heltab2x8(:,:,91))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(120),n2h1(104))
  call Hloop_VA_Q(ntryL,G1H8(54),wf8(:,10),G1H1(1),m3h8x1(:,8),heltab2x8(:,:,92))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),25,0,G2tensor(121),n2h1(105))
  call Hloop_VA_Q(ntryL,G1H8(11),wf8(:,10),G1H1(1),m3h8x1(:,9),heltab2x8(:,:,93))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(122),n2h1(106))
  call Hloop_VQ_A(ntryL,G1H8(12),wf8(:,2),G1H1(1),m3h8x1(:,10),heltab2x8(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(123),n2h1(107))
  call Hloop_VQ_A(ntryL,G1H8(14),wf8(:,2),G1H1(1),m3h8x1(:,11),heltab2x8(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),41,0,G2tensor(124),n2h1(108))
  call Hloop_VQ_A(ntryL,G1H8(20),wf8(:,2),G1H1(1),m3h8x1(:,12),heltab2x8(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(125),n2h1(109))
  call Hloop_VA_Q(ntryL,G1H8(25),wf8(:,12),G1H1(1),m3h8x1(:,13),heltab2x8(:,:,97))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(126),n2h1(110))
  call Hloop_VA_Q(ntryL,G1H8(28),wf8(:,12),G1H1(1),m3h8x1(:,14),heltab2x8(:,:,98))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),22,0,G2tensor(127),n2h1(111))
  call Hloop_VA_Q(ntryL,G1H8(40),wf8(:,12),G1H1(1),m3h8x1(:,15),heltab2x8(:,:,99))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(128),n2h1(112))
  call Hloop_VA_Q(ntryL,G1H8(36),wf8(:,14),G1H1(1),m3h8x1(:,16),heltab2x8(:,:,100))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(129),n2h1(113))
  call Hloop_VA_Q(ntryL,G1H8(39),wf8(:,14),G1H1(1),m3h8x1(:,17),heltab2x8(:,:,101))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),22,0,G2tensor(130),n2h1(114))
  call Hloop_VA_Q(ntryL,G1H8(46),wf8(:,14),G1H1(1),m3h8x1(:,18),heltab2x8(:,:,102))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(131),n2h1(115))
  call Hloop_VQ_A(ntryL,G1H8(51),wf8(:,4),G1H1(1),m3h8x1(:,19),heltab2x8(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(132),n2h1(116))
  call Hloop_VQ_A(ntryL,G1H8(56),wf8(:,4),G1H1(1),m3h8x1(:,20),heltab2x8(:,:,104))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),38,0,G2tensor(133),n2h1(117))
  call Hloop_VQ_A(ntryL,G1H8(60),wf8(:,4),G1H1(1),m3h8x1(:,21),heltab2x8(:,:,105))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(134),n2h1(118))
  call Hloop_VQ_A(ntryL,G1H8(17),wf8(:,6),G1H1(1),m3h8x1(:,22),heltab2x8(:,:,106))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(135),n2h1(119))
  call Hloop_VQ_A(ntryL,G1H8(33),wf8(:,6),G1H1(1),m3h8x1(:,23),heltab2x8(:,:,107))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),38,0,G2tensor(136),n2h1(120))
  call Hloop_VQ_A(ntryL,G1H8(50),wf8(:,6),G1H1(1),m3h8x1(:,24),heltab2x8(:,:,108))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(137),n2h1(121))
  call ol_merge_tensors(G2tensor(61),[G2tensor(59),G2tensor(2),G1tensor(6)])
  call ol_merge_tensors(G2tensor(57),[G2tensor(4),G1tensor(12)])
  call ol_merge_tensors(G2tensor(49),[G2tensor(6),G1tensor(14),G1tensor(9)])
  call ol_merge_tensors(G2tensor(15),[G2tensor(7),G1tensor(30),G1tensor(18)])
  call ol_merge_tensors(G2tensor(50),[G2tensor(10),G1tensor(20),G1tensor(3)])
  call ol_merge_tensors(G2tensor(19),[G2tensor(11),G1tensor(36),G1tensor(24)])
  call ol_merge_tensors(G2tensor(51),[G2tensor(14),G1tensor(26)])
  call ol_merge_tensors(G2tensor(53),[G2tensor(18),G1tensor(32)])
  call ol_merge_tensors(G2tensor(75),[G2tensor(22),G1tensor(38),G1tensor(21)])
  call ol_merge_tensors(G2tensor(120),[G2tensor(23),G1tensor(42)])
  call ol_merge_tensors(G2tensor(81),[G2tensor(26),G1tensor(44),G1tensor(33)])
  call ol_merge_tensors(G2tensor(123),[G2tensor(27),G1tensor(48)])
  call ol_merge_tensors(G2tensor(90),[G2tensor(87),G1tensor(2)])
  call ol_merge_tensors(G2tensor(55),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(11),G1tensor(5)])
  call ol_merge_tensors(G2tensor(93),[G1tensor(8)])
  call ol_merge_tensors(G2tensor(56),[G1tensor(10)])
  call ol_merge_tensors(G2tensor(96),[G1tensor(15)])
  call ol_merge_tensors(G2tensor(99),[G1tensor(22),G1tensor(16)])
  call ol_merge_tensors(G2tensor(63),[G1tensor(17)])
  call ol_merge_tensors(G2tensor(66),[G1tensor(23)])
  call ol_merge_tensors(G2tensor(102),[G1tensor(27)])
  call ol_merge_tensors(G2tensor(105),[G1tensor(34),G1tensor(28)])
  call ol_merge_tensors(G2tensor(69),[G1tensor(29)])
  call ol_merge_tensors(G2tensor(72),[G1tensor(35)])
  call ol_merge_tensors(G2tensor(108),[G1tensor(39)])
  call ol_merge_tensors(G2tensor(111),[G1tensor(40)])
  call ol_merge_tensors(G2tensor(84),[G2tensor(78),G1tensor(47),G1tensor(41)])
  call ol_merge_tensors(G2tensor(114),[G1tensor(45)])
  call ol_merge_tensors(G2tensor(117),[G1tensor(46)])
  call ol_merge_tensors(G2tensor(129),[G2tensor(126)])
  call ol_merge_tensors(G2tensor(135),[G2tensor(132)])
  call Hotf_4pt_reduction_last(G2tensor(61),RedSet_4(2),mass4set(:,1),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25))
  call G_TensorShift(G1tensor(7),38)
  call Hotf_4pt_reduction_last(G2tensor(57),RedSet_4(3),mass4set(:,1),  & 
G1tensor(31),G1tensor(37),G1tensor(43),G1tensor(6),G1tensor(12))
  call G_TensorShift(G1tensor(37),41)
  call Hotf_4pt_reduction_last(G2tensor(49),RedSet_4(11),mass4set(:,1),  & 
G1tensor(14),G1tensor(9),G1tensor(30),G1tensor(18),G1tensor(20))
  call G_TensorShift(G1tensor(9),32)
  call Hotf_4pt_reduction_last(G2tensor(15),RedSet_4(4),mass4set(:,1),  & 
G1tensor(3),G1tensor(36),G1tensor(24),G1tensor(26),G1tensor(32))
  call G_TensorShift(G1tensor(36),48)
  call Hotf_4pt_reduction_last(G2tensor(50),RedSet_4(8),mass4set(:,1),  & 
G1tensor(38),G1tensor(21),G1tensor(42),G1tensor(44),G1tensor(33))
  call G_TensorShift(G1tensor(21),32)
  call Hotf_4pt_reduction_last(G2tensor(19),RedSet_4(5),mass4set(:,1),  & 
G1tensor(48),G1tensor(2),G1tensor(4),G1tensor(11),G1tensor(5))
  call G_TensorShift(G1tensor(2),48)
  call Hotf_4pt_reduction_last(G2tensor(51),RedSet_4(35),mass4set(:,1),  & 
G1tensor(8),G1tensor(10),G1tensor(15),G1tensor(22),G1tensor(16))
  call G_TensorShift(G1tensor(10),16)
  call Hotf_4pt_reduction_last(G2tensor(53),RedSet_4(36),mass4set(:,1),  & 
G1tensor(17),G1tensor(23),G1tensor(27),G1tensor(34),G1tensor(28))
  call G_TensorShift(G1tensor(23),16)
  call Hotf_4pt_reduction_last(G2tensor(75),RedSet_4(18),mass4set(:,1),  & 
G1tensor(29),G1tensor(35),G1tensor(39),G1tensor(40),G1tensor(47))
  call G_TensorShift(G1tensor(35),16)
  call Hotf_4pt_reduction_last(G2tensor(120),RedSet_4(6),mass4set(:,1),  & 
G1tensor(41),G1tensor(45),G1tensor(46),G1tensor(49),G1tensor(50))
  call G_TensorShift(G1tensor(45),25)
  call Hotf_4pt_reduction_last(G2tensor(81),RedSet_4(25),mass4set(:,1),  & 
G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54),G1tensor(55))
  call G_TensorShift(G1tensor(52),32)
  call Hotf_4pt_reduction_last(G2tensor(123),RedSet_4(7),mass4set(:,1),  & 
G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(57),41)
  call Hotf_4pt_reduction_last(G2tensor(90),RedSet_4(37),mass4set(:,1),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65))
  call G_TensorShift(G1tensor(62),6)
  call Hotf_4pt_reduction_last(G2tensor(55),RedSet_4(9),mass4set(:,1),  & 
G1tensor(66),G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70))
  call G_TensorShift(G1tensor(67),32)
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,1),  & 
G1tensor(71),G1tensor(72),G1tensor(73),G1tensor(74),G1tensor(75))
  call G_TensorShift(G1tensor(72),32)
  call Hotf_4pt_reduction_last(G2tensor(93),RedSet_4(38),mass4set(:,1),  & 
G1tensor(76),G1tensor(77),G1tensor(78),G1tensor(79),G1tensor(80))
  call G_TensorShift(G1tensor(77),9)
  call Hotf_4pt_reduction_last(G2tensor(56),RedSet_4(12),mass4set(:,1),  & 
G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84),G1tensor(85))
  call G_TensorShift(G1tensor(82),32)
  call Hotf_4pt_reduction_last(G2tensor(96),RedSet_4(14),mass4set(:,1),  & 
G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(87),16)
  call Hotf_4pt_reduction_last(G2tensor(99),RedSet_4(15),mass4set(:,1),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95))
  call G_TensorShift(G1tensor(92),16)
  call Hotf_4pt_reduction_last(G2tensor(63),RedSet_4(16),mass4set(:,1),  & 
G1tensor(96),G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100))
  call G_TensorShift(G1tensor(97),16)
  call Hotf_4pt_reduction_last(G2tensor(66),RedSet_4(19),mass4set(:,1),  & 
G1tensor(101),G1tensor(102),G1tensor(103),G1tensor(104),G1tensor(105))
  call G_TensorShift(G1tensor(102),16)
  call Hotf_4pt_reduction_last(G2tensor(102),RedSet_4(21),mass4set(:,1),  & 
G1tensor(106),G1tensor(107),G1tensor(108),G1tensor(109),G1tensor(110))
  call G_TensorShift(G1tensor(107),32)
  call Hotf_4pt_reduction_last(G2tensor(105),RedSet_4(22),mass4set(:,1),  & 
G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114),G1tensor(115))
  call G_TensorShift(G1tensor(112),32)
  call Hotf_4pt_reduction_last(G2tensor(69),RedSet_4(23),mass4set(:,1),  & 
G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(117),32)
  call Hotf_4pt_reduction_last(G2tensor(72),RedSet_4(26),mass4set(:,1),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125))
  call G_TensorShift(G1tensor(122),32)
  call Hotf_4pt_reduction_last(G2tensor(108),RedSet_4(28),mass4set(:,1),  & 
G1tensor(126),G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130))
  call G_TensorShift(G1tensor(127),9)
  call Hotf_4pt_reduction_last(G2tensor(111),RedSet_4(29),mass4set(:,1),  & 
G1tensor(131),G1tensor(132),G1tensor(133),G1tensor(134),G1tensor(135))
  call G_TensorShift(G1tensor(132),9)
  call Hotf_4pt_reduction_last(G2tensor(84),RedSet_4(30),mass4set(:,1),  & 
G1tensor(136),G1tensor(137),G1tensor(138),G1tensor(139),G1tensor(140))
  call G_TensorShift(G1tensor(137),9)
  call Hotf_4pt_reduction_last(G2tensor(114),RedSet_4(32),mass4set(:,1),  & 
G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144),G1tensor(145))
  call G_TensorShift(G1tensor(142),9)
  call Hotf_4pt_reduction_last(G2tensor(117),RedSet_4(33),mass4set(:,1),  & 
G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(147),9)
  call Hotf_4pt_reduction_last(G2tensor(129),RedSet_4(39),mass4set(:,1),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155))
  call G_TensorShift(G1tensor(152),22)
  call Hotf_4pt_reduction_last(G2tensor(135),RedSet_4(40),mass4set(:,1),  & 
G1tensor(156),G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160))
  call G_TensorShift(G1tensor(157),38)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(2),mass4set(:,1),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(3),mass4set(:,1),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(14),RedSet_4(11),mass4set(:,1),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(3),RedSet_4(4),mass4set(:,1),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(38),RedSet_4(8),mass4set(:,1),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(48),RedSet_4(5),mass4set(:,1),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(8),RedSet_4(35),mass4set(:,1),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(17),RedSet_4(36),mass4set(:,1),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(29),RedSet_4(18),mass4set(:,1),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(6),mass4set(:,1),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(25),mass4set(:,1),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(56),RedSet_4(7),mass4set(:,1),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(37),mass4set(:,1),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(9),mass4set(:,1),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call Hotf_4pt_reduction_last(G1tensor(71),RedSet_4(1),mass4set(:,1),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
  call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(38),mass4set(:,1),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
  call Hotf_4pt_reduction_last(G1tensor(81),RedSet_4(12),mass4set(:,1),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
  call Hotf_4pt_reduction_last(G1tensor(86),RedSet_4(14),mass4set(:,1),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
  call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(15),mass4set(:,1),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
  call Hotf_4pt_reduction_last(G1tensor(96),RedSet_4(16),mass4set(:,1),  & 
G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100))
  call Hotf_4pt_reduction_last(G1tensor(101),RedSet_4(19),mass4set(:,1),  & 
G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104),G0tensor(105))
  call Hotf_4pt_reduction_last(G1tensor(106),RedSet_4(21),mass4set(:,1),  & 
G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110))
  call Hotf_4pt_reduction_last(G1tensor(111),RedSet_4(22),mass4set(:,1),  & 
G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114),G0tensor(115))
  call Hotf_4pt_reduction_last(G1tensor(116),RedSet_4(23),mass4set(:,1),  & 
G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119),G0tensor(120))
  call Hotf_4pt_reduction_last(G1tensor(121),RedSet_4(26),mass4set(:,1),  & 
G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124),G0tensor(125))
  call Hotf_4pt_reduction_last(G1tensor(126),RedSet_4(28),mass4set(:,1),  & 
G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129),G0tensor(130))
  call Hotf_4pt_reduction_last(G1tensor(131),RedSet_4(29),mass4set(:,1),  & 
G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134),G0tensor(135))
  call Hotf_4pt_reduction_last(G1tensor(136),RedSet_4(30),mass4set(:,1),  & 
G0tensor(136),G0tensor(137),G0tensor(138),G0tensor(139),G0tensor(140))
  call Hotf_4pt_reduction_last(G1tensor(141),RedSet_4(32),mass4set(:,1),  & 
G0tensor(141),G0tensor(142),G0tensor(143),G0tensor(144),G0tensor(145))
  call Hotf_4pt_reduction_last(G1tensor(146),RedSet_4(33),mass4set(:,1),  & 
G0tensor(146),G0tensor(147),G0tensor(148),G0tensor(149),G0tensor(150))
  call Hotf_4pt_reduction_last(G1tensor(151),RedSet_4(39),mass4set(:,1),  & 
G0tensor(151),G0tensor(152),G0tensor(153),G0tensor(154),G0tensor(155))
  call Hotf_4pt_reduction_last(G1tensor(156),RedSet_4(40),mass4set(:,1),  & 
G0tensor(156),G0tensor(157),G0tensor(158),G0tensor(159),G0tensor(160))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  call ol_merge_tensors(T0sum(12),[G0tensor(56)])
  call ol_merge_tensors(T0sum(13),[G0tensor(61)])
  call ol_merge_tensors(T0sum(14),[G0tensor(66)])
  call ol_merge_tensors(T0sum(15),[G0tensor(71)])
  call ol_merge_tensors(T0sum(16),[G0tensor(76)])
  call ol_merge_tensors(T0sum(17),[G0tensor(81)])
  call ol_merge_tensors(T0sum(18),[G0tensor(86)])
  call ol_merge_tensors(T0sum(19),[G0tensor(91)])
  call ol_merge_tensors(T0sum(20),[G0tensor(96)])
  call ol_merge_tensors(T0sum(21),[G0tensor(101)])
  call ol_merge_tensors(T0sum(22),[G0tensor(106)])
  call ol_merge_tensors(T0sum(23),[G0tensor(111)])
  call ol_merge_tensors(T0sum(24),[G0tensor(116)])
  call ol_merge_tensors(T0sum(25),[G0tensor(121)])
  call ol_merge_tensors(T0sum(26),[G0tensor(126)])
  call ol_merge_tensors(T0sum(27),[G0tensor(131)])
  call ol_merge_tensors(T0sum(28),[G0tensor(136)])
  call ol_merge_tensors(T0sum(29),[G0tensor(141)])
  call ol_merge_tensors(T0sum(30),[G0tensor(146)])
  call ol_merge_tensors(T0sum(31),[G0tensor(151)])
  call ol_merge_tensors(T0sum(32),[G0tensor(156)])
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(174)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(67),h0tab(:,67),[80,6,41],[0,0,0],3,3,wf4(:,5),wf4(:,2),wf8(:,2))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,5),G0H32(1),m3h4x32(:,9),heltab2x128(:,:,67))
  call Hloop_A_Q(ntryL,G0H32(1),80,0,G1H32(23),n2h32(37))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(175)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(68),h0tab(:,68),[80,6,41],[0,0,0],3,3,wf4(:,5),wf4(:,7),wf8(:,2))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,5),G0H32(1),m3h4x32(:,10),heltab2x128(:,:,68))
  call Hloop_A_Q(ntryL,G0H32(1),80,0,G1H32(24),n2h32(38))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(176)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(69),h0tab(:,69),[80,9,38],[0,0,0],3,3,wf4(:,5),wf4(:,4),wf8(:,4))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,5),G0H32(1),m3h4x32(:,11),heltab2x128(:,:,69))
  call Hloop_A_Q(ntryL,G0H32(1),80,0,G1H32(9),n2h32(39))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(177)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(70),h0tab(:,70),[80,9,38],[0,0,0],3,3,wf4(:,5),wf4(:,4),wf8(:,6))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,5),G0H32(1),m3h4x32(:,12),heltab2x128(:,:,70))
  call Hloop_A_Q(ntryL,G0H32(1),80,0,G1H32(15),n2h32(40))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(71),h0tab(:,71),[80,15,32],[0,0,0],3,2,wf4(:,5),wf16(:,27))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,5),G0H32(1),m3h4x32(:,13),heltab2x128(:,:,71))
  call Hloop_A_Q(ntryL,G0H32(1),80,0,G1H32(21),n2h32(41))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(72),h0tab(:,72),[80,15,32],[0,0,0],3,2,wf4(:,5),wf16(:,28))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,5),G0H32(1),m3h4x32(:,14),heltab2x128(:,:,72))
  call Hloop_A_Q(ntryL,G0H32(1),80,0,G1H32(4),n2h32(42))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(73),h0tab(:,73),[89,6,32],[0,0,0],3,2,wf16(:,29),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,29),G0H8(1),m3h16x8(:,1),heltab2x128(:,:,73))
  call Hloop_A_Q(ntryL,G0H8(1),89,0,G1H8(2),n2h8(61))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(74),h0tab(:,74),[89,6,32],[0,0,0],3,2,wf16(:,29),wf4(:,7))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,29),G0H8(1),m3h16x8(:,2),heltab2x128(:,:,74))
  call Hloop_A_Q(ntryL,G0H8(1),89,0,G1H8(5),n2h8(62))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(75),h0tab(:,75),[86,9,32],[0,0,0],3,2,wf16(:,30),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,30),G0H8(1),m3h16x8(:,3),heltab2x128(:,:,75))
  call Hloop_A_Q(ntryL,G0H8(1),86,0,G1H8(6),n2h8(63))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(76),h0tab(:,76),[86,9,32],[0,0,0],3,2,wf16(:,31),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,31),G0H8(1),m3h16x8(:,4),heltab2x128(:,:,76))
  call Hloop_A_Q(ntryL,G0H8(1),86,0,G1H8(7),n2h8(64))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(180)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(77),h0tab(:,77),[96,6,25],[0,0,0],3,3,wf4(:,9),wf4(:,2),wf8(:,10))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,15),heltab2x128(:,:,77))
  call Hloop_Q_A(ntryL,G0H32(1),96,0,G1H32(1),n2h32(43))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(181)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(78),h0tab(:,78),[96,6,25],[0,0,0],3,3,wf4(:,9),wf4(:,7),wf8(:,10))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,16),heltab2x128(:,:,78))
  call Hloop_Q_A(ntryL,G0H32(1),96,0,G1H32(2),n2h32(44))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(182)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(79),h0tab(:,79),[96,9,22],[0,0,0],3,3,wf4(:,9),wf4(:,4),wf8(:,12))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,17),heltab2x128(:,:,79))
  call Hloop_Q_A(ntryL,G0H32(1),96,0,G1H32(6),n2h32(45))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(183)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(80),h0tab(:,80),[96,9,22],[0,0,0],3,3,wf4(:,9),wf4(:,4),wf8(:,14))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,18),heltab2x128(:,:,80))
  call Hloop_Q_A(ntryL,G0H32(1),96,0,G1H32(7),n2h32(46))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(81),h0tab(:,81),[96,15,16],[0,0,0],3,2,wf4(:,9),wf16(:,27))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,19),heltab2x128(:,:,81))
  call Hloop_Q_A(ntryL,G0H32(1),96,0,G1H32(10),n2h32(47))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(82),h0tab(:,82),[96,15,16],[0,0,0],3,2,wf4(:,9),wf16(:,28))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,20),heltab2x128(:,:,82))
  call Hloop_Q_A(ntryL,G0H32(1),96,0,G1H32(11),n2h32(48))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(83),h0tab(:,83),[105,6,16],[0,0,0],3,2,wf16(:,35),wf4(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,35),G0H8(1),m3h16x8(:,5),heltab2x128(:,:,83))
  call Hloop_Q_A(ntryL,G0H8(1),105,0,G1H8(47),n2h8(65))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(84),h0tab(:,84),[105,6,16],[0,0,0],3,2,wf16(:,35),wf4(:,7))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,35),G0H8(1),m3h16x8(:,6),heltab2x128(:,:,84))
  call Hloop_Q_A(ntryL,G0H8(1),105,0,G1H8(15),n2h8(66))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(85),h0tab(:,85),[102,9,16],[0,0,0],3,2,wf16(:,36),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,36),G0H8(1),m3h16x8(:,7),heltab2x128(:,:,85))
  call Hloop_Q_A(ntryL,G0H8(1),102,0,G1H8(31),n2h8(67))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(86),h0tab(:,86),[102,9,16],[0,0,0],3,2,wf16(:,37),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,37),G0H8(1),m3h16x8(:,8),heltab2x128(:,:,86))
  call Hloop_Q_A(ntryL,G0H8(1),102,0,G1H8(16),n2h8(68))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(87),h0tab(:,87),[64,25,38],[0,0,0],3,2,wf8(:,10),wf8(:,4))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,59),heltab2x128(:,:,87))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(1),n2h64(41))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(88),h0tab(:,88),[64,25,38],[0,0,0],3,2,wf8(:,10),wf8(:,6))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,60),heltab2x128(:,:,88))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(2),n2h64(42))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(89),h0tab(:,89),[64,25,38],[0,0,0],3,2,wf8(:,10),wf8(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(3),m3h2x64(:,61),heltab2x128(:,:,89))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(90),h0tab(:,90),[64,25,38],[0,0,0],3,2,wf8(:,10),wf8(:,6))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(4),m3h2x64(:,62),heltab2x128(:,:,90))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(186)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(91),h0tab(:,91),[64,6,57],[0,0,0],3,2,wf4(:,2),wf16(:,23))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,63),heltab2x128(:,:,91))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(5),n2h64(43))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(186)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(92),h0tab(:,92),[64,6,57],[nMT,nMT,nMT],3,2,wf4(:,2),wf16(:,23))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,64),heltab2x128(:,:,92))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(6),n2h64(44))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(186)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(93),h0tab(:,93),[64,6,57],[0,0,0],3,2,wf4(:,2),wf16(:,23))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,65),heltab2x128(:,:,93))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(7),n2h64(45))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(186)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(94),h0tab(:,94),[64,6,57],[nMT,nMT,nMT],3,2,wf4(:,2),wf16(:,23))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,66),heltab2x128(:,:,94))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(8),n2h64(46))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(186)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(95),h0tab(:,95),[64,6,57],[0,0,0],3,2,wf4(:,2),wf16(:,23))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,67),heltab2x128(:,:,95))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(9),n2h64(47))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(186)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(96),h0tab(:,96),[64,6,57],[nMB,nMB,nMB],3,2,wf4(:,2),wf16(:,23))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,68),heltab2x128(:,:,96))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(10),n2h64(48))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(186)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(97),h0tab(:,97),[64,6,57],[0,0,0],3,2,wf4(:,2),wf16(:,23))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,69),heltab2x128(:,:,97))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(11),n2h64(49))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(186)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(98),h0tab(:,98),[64,6,57],[nMB,nMB,nMB],3,2,wf4(:,2),wf16(:,23))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,70),heltab2x128(:,:,98))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(12),n2h64(50))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(187)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(99),h0tab(:,99),[64,6,57],[0,0,0],3,2,wf4(:,7),wf16(:,23))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,71),heltab2x128(:,:,99))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(13),n2h64(51))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(187)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(100),h0tab(:,100),[64,6,57],[nMT,nMT,nMT],3,2,wf4(:,7),wf16(:,23))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,72),heltab2x128(:,:,100))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(14),n2h64(52))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(187)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(101),h0tab(:,101),[64,6,57],[0,0,0],3,2,wf4(:,7),wf16(:,23))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,73),heltab2x128(:,:,101))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(15),n2h64(53))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(187)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(102),h0tab(:,102),[64,6,57],[nMT,nMT,nMT],3,2,wf4(:,7),wf16(:,23))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,74),heltab2x128(:,:,102))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(16),n2h64(54))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(187)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(103),h0tab(:,103),[64,6,57],[0,0,0],3,2,wf4(:,7),wf16(:,23))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,75),heltab2x128(:,:,103))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(17),n2h64(55))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(187)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(104),h0tab(:,104),[64,6,57],[nMB,nMB,nMB],3,2,wf4(:,7),wf16(:,23))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,76),heltab2x128(:,:,104))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(18),n2h64(56))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(187)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(105),h0tab(:,105),[64,6,57],[0,0,0],3,2,wf4(:,7),wf16(:,23))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,77),heltab2x128(:,:,105))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(19),n2h64(57))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(187)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(106),h0tab(:,106),[64,6,57],[nMB,nMB,nMB],3,2,wf4(:,7),wf16(:,23))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,78),heltab2x128(:,:,106))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(20),n2h64(58))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(188)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(107),h0tab(:,107),[89,6,32],[0,0,0],3,2,wf16(:,56),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,56),G0H8(1),m3h16x8(:,9),heltab2x128(:,:,107))
  call Hloop_A_Q(ntryL,G0H8(1),89,0,G1H8(48),n2h8(69))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(189)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(108),h0tab(:,108),[89,6,32],[0,0,0],3,2,wf16(:,56),wf4(:,7))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,56),G0H8(1),m3h16x8(:,10),heltab2x128(:,:,108))
  call Hloop_A_Q(ntryL,G0H8(1),89,0,G1H8(61),n2h8(70))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(145)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(109),h0tab(:,109),[64,31,32],[0,0,0],3,1,wf32(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,79),heltab2x128(:,:,109))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(21),n2h64(59))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(147)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(110),h0tab(:,110),[64,31,32],[0,0,0],3,1,wf32(:,4))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,80),heltab2x128(:,:,110))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(22),n2h64(60))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(145)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(111),h0tab(:,111),[64,31,32],[0,0,0],3,1,wf32(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(23),m3h2x64(:,81),heltab2x128(:,:,111))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(147)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(112),h0tab(:,112),[64,31,32],[0,0,0],3,1,wf32(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(24),m3h2x64(:,82),heltab2x128(:,:,112))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(113),h0tab(:,113),[64,22,41],[0,0,0],3,2,wf8(:,12),wf8(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,83),heltab2x128(:,:,113))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(25),n2h64(61))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(114),h0tab(:,114),[64,22,41],[0,0,0],3,2,wf8(:,14),wf8(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,84),heltab2x128(:,:,114))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(26),n2h64(62))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(115),h0tab(:,115),[64,22,41],[0,0,0],3,2,wf8(:,12),wf8(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(27),m3h2x64(:,85),heltab2x128(:,:,115))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(116),h0tab(:,116),[64,22,41],[0,0,0],3,2,wf8(:,14),wf8(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(28),m3h2x64(:,86),heltab2x128(:,:,116))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(190)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(117),h0tab(:,117),[64,6,57],[0,0,0],3,2,wf4(:,2),wf16(:,26))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,87),heltab2x128(:,:,117))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(29),n2h64(63))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(190)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(118),h0tab(:,118),[64,6,57],[nMT,nMT,nMT],3,2,wf4(:,2),wf16(:,26))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,88),heltab2x128(:,:,118))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(30),n2h64(64))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(190)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(119),h0tab(:,119),[64,6,57],[0,0,0],3,2,wf4(:,2),wf16(:,26))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,89),heltab2x128(:,:,119))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(31),n2h64(65))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(190)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(120),h0tab(:,120),[64,6,57],[nMT,nMT,nMT],3,2,wf4(:,2),wf16(:,26))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,90),heltab2x128(:,:,120))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(32),n2h64(66))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(190)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(121),h0tab(:,121),[64,6,57],[0,0,0],3,2,wf4(:,2),wf16(:,26))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,91),heltab2x128(:,:,121))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(33),n2h64(67))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(190)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(122),h0tab(:,122),[64,6,57],[nMB,nMB,nMB],3,2,wf4(:,2),wf16(:,26))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,92),heltab2x128(:,:,122))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(34),n2h64(68))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(190)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(123),h0tab(:,123),[64,6,57],[0,0,0],3,2,wf4(:,2),wf16(:,26))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,93),heltab2x128(:,:,123))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(35),n2h64(69))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(190)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(124),h0tab(:,124),[64,6,57],[nMB,nMB,nMB],3,2,wf4(:,2),wf16(:,26))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,94),heltab2x128(:,:,124))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(36),n2h64(70))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(191)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(125),h0tab(:,125),[64,6,57],[0,0,0],3,2,wf4(:,7),wf16(:,26))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,95),heltab2x128(:,:,125))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(37),n2h64(71))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(191)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(126),h0tab(:,126),[64,6,57],[nMT,nMT,nMT],3,2,wf4(:,7),wf16(:,26))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,96),heltab2x128(:,:,126))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(38),n2h64(72))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(191)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(127),h0tab(:,127),[64,6,57],[0,0,0],3,2,wf4(:,7),wf16(:,26))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,97),heltab2x128(:,:,127))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(39),n2h64(73))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(191)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(128),h0tab(:,128),[64,6,57],[nMT,nMT,nMT],3,2,wf4(:,7),wf16(:,26))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,98),heltab2x128(:,:,128))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(40),n2h64(74))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(191)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(129),h0tab(:,129),[64,6,57],[0,0,0],3,2,wf4(:,7),wf16(:,26))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,99),heltab2x128(:,:,129))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(41),n2h64(75))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(191)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(130),h0tab(:,130),[64,6,57],[nMB,nMB,nMB],3,2,wf4(:,7),wf16(:,26))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,100),heltab2x128(:,:,130))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(42),n2h64(76))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(191)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(131),h0tab(:,131),[64,6,57],[0,0,0],3,2,wf4(:,7),wf16(:,26))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,101),heltab2x128(:,:,131))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(43),n2h64(77))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(191)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(132),h0tab(:,132),[64,6,57],[nMB,nMB,nMB],3,2,wf4(:,7),wf16(:,26))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,102),heltab2x128(:,:,132))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(44),n2h64(78))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(192)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(133),h0tab(:,133),[105,6,16],[0,0,0],3,2,wf16(:,55),wf4(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,55),G0H8(1),m3h16x8(:,11),heltab2x128(:,:,133))
  call Hloop_Q_A(ntryL,G0H8(1),105,0,G1H8(3),n2h8(71))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(193)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(134),h0tab(:,134),[105,6,16],[0,0,0],3,2,wf16(:,55),wf4(:,7))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,55),G0H8(1),m3h16x8(:,12),heltab2x128(:,:,134))
  call Hloop_Q_A(ntryL,G0H8(1),105,0,G1H8(4),n2h8(72))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(151)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(135),h0tab(:,135),[64,16,47],[0,0,0],3,1,wf32(:,6))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,103),heltab2x128(:,:,135))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(45),n2h64(79))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(153)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(136),h0tab(:,136),[64,16,47],[0,0,0],3,1,wf32(:,8))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,104),heltab2x128(:,:,136))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(46),n2h64(80))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(151)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(137),h0tab(:,137),[64,16,47],[0,0,0],3,1,wf32(:,6))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(47),m3h2x64(:,105),heltab2x128(:,:,137))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(153)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(138),h0tab(:,138),[64,16,47],[0,0,0],3,1,wf32(:,8))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(48),m3h2x64(:,106),heltab2x128(:,:,138))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(194)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(139),h0tab(:,139),[86,9,32],[0,0,0],3,2,wf16(:,57),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,57),G0H8(1),m3h16x8(:,13),heltab2x128(:,:,139))
  call Hloop_A_Q(ntryL,G0H8(1),86,0,G1H8(9),n2h8(73))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(195)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(140),h0tab(:,140),[86,9,32],[0,0,0],3,2,wf16(:,58),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,58),G0H8(1),m3h16x8(:,14),heltab2x128(:,:,140))
  call Hloop_A_Q(ntryL,G0H8(1),86,0,G1H8(10),n2h8(74))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(155)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(141),h0tab(:,141),[64,31,32],[0,0,0],3,1,wf32(:,10))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,107),heltab2x128(:,:,141))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(49),n2h64(81))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(157)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(142),h0tab(:,142),[64,31,32],[0,0,0],3,1,wf32(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,108),heltab2x128(:,:,142))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(50),n2h64(82))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(155)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(143),h0tab(:,143),[64,31,32],[0,0,0],3,1,wf32(:,10))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(51),m3h2x64(:,109),heltab2x128(:,:,143))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(157)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(144),h0tab(:,144),[64,31,32],[0,0,0],3,1,wf32(:,12))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(52),m3h2x64(:,110),heltab2x128(:,:,144))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(145),h0tab(:,145),[102,9,16],[0,0,0],3,2,wf16(:,51),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,51),G0H8(1),m3h16x8(:,15),heltab2x128(:,:,145))
  call Hloop_Q_A(ntryL,G0H8(1),102,0,G1H8(21),n2h8(75))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(197)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(146),h0tab(:,146),[102,9,16],[0,0,0],3,2,wf16(:,53),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,53),G0H8(1),m3h16x8(:,16),heltab2x128(:,:,146))
  call Hloop_Q_A(ntryL,G0H8(1),102,0,G1H8(22),n2h8(76))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(159)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(147),h0tab(:,147),[64,16,47],[0,0,0],3,1,wf32(:,14))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,111),heltab2x128(:,:,147))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(53),n2h64(83))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(161)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(148),h0tab(:,148),[64,16,47],[0,0,0],3,1,wf32(:,16))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,112),heltab2x128(:,:,148))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(54),n2h64(84))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(159)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(149),h0tab(:,149),[64,16,47],[0,0,0],3,1,wf32(:,14))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(55),m3h2x64(:,113),heltab2x128(:,:,149))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(161)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(150),h0tab(:,150),[64,16,47],[0,0,0],3,1,wf32(:,16))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(56),m3h2x64(:,114),heltab2x128(:,:,150))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(162)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(151),h0tab(:,151),[64,31,32],[0,0,0],3,1,wf32(:,18))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,115),heltab2x128(:,:,151))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(57),n2h64(85))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(163)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(152),h0tab(:,152),[64,31,32],[0,0,0],3,1,wf32(:,20))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,116),heltab2x128(:,:,152))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(58),n2h64(86))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(162)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(153),h0tab(:,153),[64,31,32],[0,0,0],3,1,wf32(:,18))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(59),m3h2x64(:,117),heltab2x128(:,:,153))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(163)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(154),h0tab(:,154),[64,31,32],[0,0,0],3,1,wf32(:,20))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(60),m3h2x64(:,118),heltab2x128(:,:,154))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(164)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(155),h0tab(:,155),[64,16,47],[0,0,0],3,1,wf32(:,22))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,119),heltab2x128(:,:,155))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(61),n2h64(87))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(165)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(156),h0tab(:,156),[64,16,47],[0,0,0],3,1,wf32(:,24))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,120),heltab2x128(:,:,156))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(62),n2h64(88))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(164)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(157),h0tab(:,157),[64,16,47],[0,0,0],3,1,wf32(:,22))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(63),m3h2x64(:,121),heltab2x128(:,:,157))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(165)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(158),h0tab(:,158),[64,16,47],[0,0,0],3,1,wf32(:,24))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(64),m3h2x64(:,122),heltab2x128(:,:,158))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(198)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(159),h0tab(:,159),[80,15,32],[0,0,0],3,2,wf4(:,5),wf16(:,59))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,5),G0H32(1),m3h4x32(:,21),heltab2x128(:,:,159))
  call Hloop_A_Q(ntryL,G0H32(1),80,0,G1H32(12),n2h32(49))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(199)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(160),h0tab(:,160),[80,15,32],[0,0,0],3,2,wf4(:,5),wf16(:,60))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,5),G0H32(1),m3h4x32(:,22),heltab2x128(:,:,160))
  call Hloop_A_Q(ntryL,G0H32(1),80,0,G1H32(13),n2h32(50))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(200)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(161),h0tab(:,161),[80,15,32],[0,0,0],3,2,wf4(:,5),wf16(:,61))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,5),G0H32(1),m3h4x32(:,23),heltab2x128(:,:,161))
  call Hloop_A_Q(ntryL,G0H32(1),80,0,G1H32(16),n2h32(51))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(201)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(162),h0tab(:,162),[96,15,16],[0,0,0],3,2,wf4(:,9),wf16(:,59))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,24),heltab2x128(:,:,162))
  call Hloop_Q_A(ntryL,G0H32(1),96,0,G1H32(17),n2h32(52))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(202)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(163),h0tab(:,163),[96,15,16],[0,0,0],3,2,wf4(:,9),wf16(:,60))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,25),heltab2x128(:,:,163))
  call Hloop_Q_A(ntryL,G0H32(1),96,0,G1H32(18),n2h32(53))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(203)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(164),h0tab(:,164),[96,15,16],[0,0,0],3,2,wf4(:,9),wf16(:,61))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,26),heltab2x128(:,:,164))
  call Hloop_Q_A(ntryL,G0H32(1),96,0,G1H32(19),n2h32(54))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(166)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(165),h0tab(:,165),[64,31,32],[0,0,0],3,1,wf32(:,26))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,123),heltab2x128(:,:,165))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(65),n2h64(89))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(166)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(166),h0tab(:,166),[64,31,32],[0,0,0],3,1,wf32(:,26))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(66),m3h2x64(:,124),heltab2x128(:,:,166))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(167)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(167),h0tab(:,167),[64,16,47],[0,0,0],3,1,wf32(:,28))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,125),heltab2x128(:,:,167))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(67),n2h64(90))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(167)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(168),h0tab(:,168),[64,16,47],[0,0,0],3,1,wf32(:,28))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(68),m3h2x64(:,126),heltab2x128(:,:,168))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(168)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(169),h0tab(:,169),[64,31,32],[0,0,0],3,1,wf32(:,30))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,127),heltab2x128(:,:,169))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(69),n2h64(91))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(169)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(170),h0tab(:,170),[64,31,32],[0,0,0],3,1,wf32(:,32))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,128),heltab2x128(:,:,170))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(70),n2h64(92))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(168)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(171),h0tab(:,171),[64,31,32],[0,0,0],3,1,wf32(:,30))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(71),m3h2x64(:,129),heltab2x128(:,:,171))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(169)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(172),h0tab(:,172),[64,31,32],[0,0,0],3,1,wf32(:,32))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(72),m3h2x64(:,130),heltab2x128(:,:,172))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(170)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(173),h0tab(:,173),[64,16,47],[0,0,0],3,1,wf32(:,34))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,131),heltab2x128(:,:,173))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(73),n2h64(93))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(171)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(174),h0tab(:,174),[64,16,47],[0,0,0],3,1,wf32(:,36))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,132),heltab2x128(:,:,174))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(74),n2h64(94))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(170)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(175),h0tab(:,175),[64,16,47],[0,0,0],3,1,wf32(:,34))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(75),m3h2x64(:,133),heltab2x128(:,:,175))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(171)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(176),h0tab(:,176),[64,16,47],[0,0,0],3,1,wf32(:,36))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(76),m3h2x64(:,134),heltab2x128(:,:,176))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(204)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(177),h0tab(:,177),[80,15,32],[0,0,0],3,2,wf4(:,5),wf16(:,62))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,5),G0H32(1),m3h4x32(:,27),heltab2x128(:,:,177))
  call Hloop_A_Q(ntryL,G0H32(1),80,0,G1H32(22),n2h32(55))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(205)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(178),h0tab(:,178),[96,15,16],[0,0,0],3,2,wf4(:,9),wf16(:,62))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,28),heltab2x128(:,:,178))
  call Hloop_Q_A(ntryL,G0H32(1),96,0,G1H32(25),n2h32(56))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(172)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(179),h0tab(:,179),[64,31,32],[0,0,0],3,1,wf32(:,38))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,135),heltab2x128(:,:,179))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(77),n2h64(95))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(172)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(180),h0tab(:,180),[64,31,32],[0,0,0],3,1,wf32(:,38))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(78),m3h2x64(:,136),heltab2x128(:,:,180))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(173)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(181),h0tab(:,181),[64,16,47],[0,0,0],3,1,wf32(:,40))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,137),heltab2x128(:,:,181))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(79),n2h64(96))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(173)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(182),h0tab(:,182),[64,16,47],[0,0,0],3,1,wf32(:,40))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(80),m3h2x64(:,138),heltab2x128(:,:,182))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(10),[G1H8(9),G1H8(7),G1H8(6),G1H8(32),G1H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(48),[G1H8(2),G1H8(1),G1H8(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(61),[G1H8(5),G1H8(8),G1H8(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(22),[G1H8(21),G1H8(16),G1H8(31),G1H8(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(3),[G1H8(47),G1H8(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(4),[G1H8(15),G1H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(23),[G1H32(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(24),[G1H32(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(9),[G1H32(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(15),[G1H32(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(21),[G1H32(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(4),[G1H32(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(12),[G1H32(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(13),[G1H32(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(16),[G1H32(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(22),[G1H32(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H64(9),[G1H64(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H64(11),[G1H64(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H64(33),[G1H64(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H64(35),[G1H64(31)])
  call Hloop_AW_Q(ntryL,G1H8(10),wf4(:,4),G1H2(31),m3h4x2(:,57),heltab2x8(:,:,109))
  call Hloop_A_Q(ntryL,G1H2(31),95,0,G2H2(2),n2h2(73))
  call Hloop_AV_Q(ntryL,G1H8(48),wf4(:,2),G1H2(43),m3h4x2(:,58),heltab2x8(:,:,110))
  call Hloop_A_Q(ntryL,G1H2(43),95,0,G2H2(38),n2h2(74))
  call Hloop_AZ_Q(ntryL,G1H8(61),wf4(:,7),G1H2(33),ngZd,m3h4x2(:,59),heltab2x8(:,:,111))
  call Hloop_A_Q(ntryL,G1H2(33),95,0,G2H2(5),n2h2(75))
  call Hloop_QW_A(ntryL,G1H8(22),wf4(:,4),G1H2(42),m3h4x2(:,60),heltab2x8(:,:,112))
  call Hloop_Q_A(ntryL,G1H2(42),111,0,G2H2(8),n2h2(76))
  call Hloop_QV_A(ntryL,G1H8(3),wf4(:,2),G1H2(44),m3h4x2(:,61),heltab2x8(:,:,113))
  call Hloop_Q_A(ntryL,G1H2(44),111,0,G2H2(36),n2h2(77))
  call Hloop_QZ_A(ntryL,G1H8(4),wf4(:,7),G1H2(35),ngZu,m3h4x2(:,62),heltab2x8(:,:,114))
  call Hloop_Q_A(ntryL,G1H2(35),111,0,G2H2(11),n2h2(78))
  call Hloop_AV_Q(ntryL,G1H32(23),wf4(:,2),G1H8(26),m3h4x8(:,37),heltab2x32(:,:,69))
  call Hloop_A_Q(ntryL,G1H8(26),86,0,G2H8(6),n2h8(77))
  call Hloop_AZ_Q(ntryL,G1H32(24),wf4(:,7),G1H8(27),ngZu,m3h4x8(:,38),heltab2x32(:,:,70))
  call Hloop_A_Q(ntryL,G1H8(27),86,0,G2H8(7),n2h8(78))
  call Hloop_AW_Q(ntryL,G1H32(9),wf4(:,4),G1H8(37),m3h4x8(:,39),heltab2x32(:,:,71))
  call Hloop_A_Q(ntryL,G1H8(37),89,0,G2H8(8),n2h8(79))
  call Hloop_AW_Q(ntryL,G1H32(15),wf4(:,4),G1H8(38),m3h4x8(:,40),heltab2x32(:,:,72))
  call Hloop_A_Q(ntryL,G1H8(38),89,0,G2H8(16),n2h8(80))
  call Hloop_AW_Q(ntryL,G1H32(21),wf16(:,27),G1H2(40),m3h16x2(:,19),heltab2x32(:,:,73))
  call Hloop_A_Q(ntryL,G1H2(40),95,0,G2H2(31),n2h2(79))
  call Hloop_AW_Q(ntryL,G1H32(4),wf16(:,28),G1H2(17),m3h16x2(:,20),heltab2x32(:,:,74))
  call Hloop_A_Q(ntryL,G1H2(17),95,0,G2H2(33),n2h2(80))
  call Hloop_AW_Q(ntryL,G1H32(12),wf16(:,59),G1H2(28),m3h16x2(:,21),heltab2x32(:,:,75))
  call Hloop_A_Q(ntryL,G1H2(28),95,0,G2H2(79),n2h2(81))
  call Hloop_AW_Q(ntryL,G1H32(13),wf16(:,60),G1H2(39),m3h16x2(:,22),heltab2x32(:,:,76))
  call Hloop_A_Q(ntryL,G1H2(39),95,0,G2H2(76),n2h2(82))
  call Hloop_AW_Q(ntryL,G1H32(16),wf16(:,61),G1H2(7),m3h16x2(:,23),heltab2x32(:,:,77))
  call Hloop_A_Q(ntryL,G1H2(7),95,0,G2H2(73),n2h2(83))
  call Hloop_AW_Q(ntryL,G1H32(22),wf16(:,62),G1H2(8),m3h16x2(:,24),heltab2x32(:,:,78))
  call Hloop_A_Q(ntryL,G1H2(8),95,0,G2H2(70),n2h2(84))
  call Hloop_QV_A(ntryL,G1H32(1),wf4(:,2),G1H8(42),m3h4x8(:,41),heltab2x32(:,:,79))
  call Hloop_Q_A(ntryL,G1H8(42),102,0,G2H8(21),n2h8(81))
  call Hloop_QZ_A(ntryL,G1H32(2),wf4(:,7),G1H8(43),ngZd,m3h4x8(:,42),heltab2x32(:,:,80))
  call Hloop_Q_A(ntryL,G1H8(43),102,0,G2H8(24),n2h8(82))
  call Hloop_QW_A(ntryL,G1H32(6),wf4(:,4),G1H8(53),m3h4x8(:,43),heltab2x32(:,:,81))
  call Hloop_Q_A(ntryL,G1H8(53),105,0,G2H8(11),n2h8(83))
  call Hloop_QW_A(ntryL,G1H32(7),wf4(:,4),G1H8(54),m3h4x8(:,44),heltab2x32(:,:,82))
  call Hloop_Q_A(ntryL,G1H8(54),105,0,G2H8(13),n2h8(84))
  call Hloop_QW_A(ntryL,G1H32(10),wf16(:,27),G1H2(12),m3h16x2(:,25),heltab2x32(:,:,83))
  call Hloop_Q_A(ntryL,G1H2(12),111,0,G2H2(67),n2h2(85))
  call Hloop_QW_A(ntryL,G1H32(11),wf16(:,28),G1H2(19),m3h16x2(:,26),heltab2x32(:,:,84))
  call Hloop_Q_A(ntryL,G1H2(19),111,0,G2H2(26),n2h2(86))
  call Hloop_QA_V(ntryL,G1H64(1),wf8(:,10),G1H8(11),m3h8x8(:,5),heltab2x64(:,:,59))
  call Hloop_QA_V(ntryL,G1H64(2),wf8(:,10),G1H8(12),m3h8x8(:,6),heltab2x64(:,:,60))
  call Hloop_VA_Q(ntryL,G1H64(3),wf8(:,10),G1H8(14),m3h8x8(:,7),heltab2x64(:,:,61))
  call Hloop_A_Q(ntryL,G1H8(14),89,0,G2H8(17),n2h8(85))
  call Hloop_VA_Q(ntryL,G1H64(4),wf8(:,10),G1H8(20),m3h8x8(:,8),heltab2x64(:,:,62))
  call Hloop_A_Q(ntryL,G1H8(20),89,0,G2H8(19),n2h8(86))
  call Hloop_AV_Q(ntryL,G1H64(9),wf4(:,2),G1H16(32),m3h4x16(:,29),heltab2x64(:,:,63))
  call Hloop_A_Q(ntryL,G1H16(32),70,0,G2H16(4),n2h16(35))
  call Hloop_AV_Q(ntryL,G1H64(6),wf4(:,2),G1H16(34),m3h4x16(:,30),heltab2x64(:,:,64))
  call Hloop_A_Q(ntryL,G1H16(34),70,nMT,G2H16(8),n2h16(36))
  call Hloop_QV_A(ntryL,G1H64(11),wf4(:,2),G1H16(35),m3h4x16(:,31),heltab2x64(:,:,65))
  call Hloop_Q_A(ntryL,G1H16(35),70,0,G2H16(10),n2h16(37))
  call Hloop_QV_A(ntryL,G1H64(8),wf4(:,2),G1H16(36),m3h4x16(:,32),heltab2x64(:,:,66))
  call Hloop_Q_A(ntryL,G1H16(36),70,nMT,G2H16(1),n2h16(38))
  call Hloop_AV_Q(ntryL,G1H64(10),wf4(:,2),G1H16(3),m3h4x16(:,33),heltab2x64(:,:,67))
  call Hloop_A_Q(ntryL,G1H16(3),70,nMB,G2H16(6),n2h16(39))
  call Hloop_QV_A(ntryL,G1H64(12),wf4(:,2),G1H16(9),m3h4x16(:,34),heltab2x64(:,:,68))
  call Hloop_Q_A(ntryL,G1H16(9),70,nMB,G2H16(9),n2h16(40))
  call Hloop_AZ_Q(ntryL,G1H64(13),wf4(:,7),G1H16(15),ngZu,m3h4x16(:,35),heltab2x64(:,:,69))
  call Hloop_A_Q(ntryL,G1H16(15),70,0,G2H16(12),n2h16(41))
  call Hloop_AZ_Q(ntryL,G1H64(14),wf4(:,7),G1H16(21),ngZu,m3h4x16(:,36),heltab2x64(:,:,70))
  call Hloop_A_Q(ntryL,G1H16(21),70,nMT,G2H16(5),n2h16(42))
  call Hloop_QZ_A(ntryL,G1H64(15),wf4(:,7),G1H16(27),ngZu,m3h4x16(:,37),heltab2x64(:,:,71))
  call Hloop_Q_A(ntryL,G1H16(27),70,0,G2H16(7),n2h16(43))
  call Hloop_QZ_A(ntryL,G1H64(16),wf4(:,7),G1H16(33),ngZu,m3h4x16(:,38),heltab2x64(:,:,72))
  call Hloop_Q_A(ntryL,G1H16(33),70,nMT,G2H16(11),n2h16(44))
  call Hloop_AZ_Q(ntryL,G1H64(17),wf4(:,7),G1H16(6),ngZd,m3h4x16(:,39),heltab2x64(:,:,73))
  call Hloop_A_Q(ntryL,G1H16(6),70,0,G2H16(2),n2h16(45))
  call Hloop_AZ_Q(ntryL,G1H64(18),wf4(:,7),G1H16(7),ngZd,m3h4x16(:,40),heltab2x64(:,:,74))
  call Hloop_A_Q(ntryL,G1H16(7),70,nMB,G2H16(3),n2h16(46))
  call Hloop_QZ_A(ntryL,G1H64(19),wf4(:,7),G1H16(8),ngZd,m3h4x16(:,41),heltab2x64(:,:,75))
  call Hloop_Q_A(ntryL,G1H16(8),70,0,G2H16(13),n2h16(47))
  call Hloop_QZ_A(ntryL,G1H64(20),wf4(:,7),G1H16(10),ngZd,m3h4x16(:,42),heltab2x64(:,:,76))
  call Hloop_Q_A(ntryL,G1H16(10),70,nMB,G2H16(14),n2h16(48))
  call Hloop_QA_V(ntryL,G1H64(21),wf32(:,2),G1H2(23),m3h32x2(:,1),heltab2x64(:,:,77))
  call Hloop_QA_V(ntryL,G1H64(22),wf32(:,4),G1H2(24),m3h32x2(:,2),heltab2x64(:,:,78))
  call Hloop_VA_Q(ntryL,G1H64(23),wf32(:,2),G1H2(34),m3h32x2(:,3),heltab2x64(:,:,79))
  call Hloop_A_Q(ntryL,G1H2(34),95,0,G2H2(21),n2h2(87))
  call Hloop_VA_Q(ntryL,G1H64(24),wf32(:,4),G1H2(5),m3h32x2(:,4),heltab2x64(:,:,80))
  call Hloop_A_Q(ntryL,G1H2(5),95,0,G2H2(16),n2h2(88))
  call Hloop_QA_V(ntryL,G1H64(25),wf8(:,12),G1H8(25),m3h8x8(:,9),heltab2x64(:,:,81))
  call Hloop_QA_V(ntryL,G1H64(26),wf8(:,14),G1H8(28),m3h8x8(:,10),heltab2x64(:,:,82))
  call Hloop_VA_Q(ntryL,G1H64(27),wf8(:,12),G1H8(40),m3h8x8(:,11),heltab2x64(:,:,83))
  call Hloop_A_Q(ntryL,G1H8(40),86,0,G2H8(2),n2h8(87))
  call Hloop_VA_Q(ntryL,G1H64(28),wf8(:,14),G1H8(36),m3h8x8(:,12),heltab2x64(:,:,84))
  call Hloop_A_Q(ntryL,G1H8(36),86,0,G2H8(9),n2h8(88))
  call Hloop_AV_Q(ntryL,G1H64(33),wf4(:,2),G1H16(11),m3h4x16(:,43),heltab2x64(:,:,85))
  call Hloop_A_Q(ntryL,G1H16(11),70,0,G2H16(15),n2h16(49))
  call Hloop_AV_Q(ntryL,G1H64(30),wf4(:,2),G1H16(12),m3h4x16(:,44),heltab2x64(:,:,86))
  call Hloop_A_Q(ntryL,G1H16(12),70,nMT,G2H16(16),n2h16(50))
  call Hloop_QV_A(ntryL,G1H64(35),wf4(:,2),G1H16(13),m3h4x16(:,45),heltab2x64(:,:,87))
  call Hloop_Q_A(ntryL,G1H16(13),70,0,G2H16(17),n2h16(51))
  call Hloop_QV_A(ntryL,G1H64(32),wf4(:,2),G1H16(14),m3h4x16(:,46),heltab2x64(:,:,88))
  call Hloop_Q_A(ntryL,G1H16(14),70,nMT,G2H16(18),n2h16(52))
  call Hloop_AV_Q(ntryL,G1H64(34),wf4(:,2),G1H16(16),m3h4x16(:,47),heltab2x64(:,:,89))
  call Hloop_A_Q(ntryL,G1H16(16),70,nMB,G2H16(19),n2h16(53))
  call Hloop_QV_A(ntryL,G1H64(36),wf4(:,2),G1H16(17),m3h4x16(:,48),heltab2x64(:,:,90))
  call Hloop_Q_A(ntryL,G1H16(17),70,nMB,G2H16(20),n2h16(54))
  call Hloop_AZ_Q(ntryL,G1H64(37),wf4(:,7),G1H16(18),ngZu,m3h4x16(:,49),heltab2x64(:,:,91))
  call Hloop_A_Q(ntryL,G1H16(18),70,0,G2H16(21),n2h16(55))
  call Hloop_AZ_Q(ntryL,G1H64(38),wf4(:,7),G1H16(19),ngZu,m3h4x16(:,50),heltab2x64(:,:,92))
  call Hloop_A_Q(ntryL,G1H16(19),70,nMT,G2H16(22),n2h16(56))
  call Hloop_QZ_A(ntryL,G1H64(39),wf4(:,7),G1H16(20),ngZu,m3h4x16(:,51),heltab2x64(:,:,93))
  call Hloop_Q_A(ntryL,G1H16(20),70,0,G2H16(23),n2h16(57))
  call Hloop_QZ_A(ntryL,G1H64(40),wf4(:,7),G1H16(22),ngZu,m3h4x16(:,52),heltab2x64(:,:,94))
  call Hloop_Q_A(ntryL,G1H16(22),70,nMT,G2H16(24),n2h16(58))
  call Hloop_AZ_Q(ntryL,G1H64(41),wf4(:,7),G1H16(23),ngZd,m3h4x16(:,53),heltab2x64(:,:,95))
  call Hloop_A_Q(ntryL,G1H16(23),70,0,G2H16(25),n2h16(59))
  call Hloop_AZ_Q(ntryL,G1H64(42),wf4(:,7),G1H16(24),ngZd,m3h4x16(:,54),heltab2x64(:,:,96))
  call Hloop_A_Q(ntryL,G1H16(24),70,nMB,G2H16(26),n2h16(60))
  call Hloop_QZ_A(ntryL,G1H64(43),wf4(:,7),G1H16(1),ngZd,m3h4x16(:,55),heltab2x64(:,:,97))
  call Hloop_Q_A(ntryL,G1H16(1),70,0,G2H16(27),n2h16(61))
  call Hloop_QZ_A(ntryL,G1H64(44),wf4(:,7),G1H16(2),ngZd,m3h4x16(:,56),heltab2x64(:,:,98))
  call Hloop_Q_A(ntryL,G1H16(2),70,nMB,G2H16(28),n2h16(62))
  call Hloop_QA_V(ntryL,G1H64(45),ex5(:),G1H32(26),m3h2x32(:,15),heltab2x64(:,:,99))
  call Hloop_QA_V(ntryL,G1H64(46),ex5(:),G1H32(27),m3h2x32(:,16),heltab2x64(:,:,100))
  call Hloop_VA_Q(ntryL,G1H64(47),ex5(:),G1H32(29),m3h2x32(:,17),heltab2x64(:,:,101))
  call Hloop_A_Q(ntryL,G1H32(29),80,0,G2H32(1),n2h32(57))
  call Hloop_VA_Q(ntryL,G1H64(48),ex5(:),G1H32(30),m3h2x32(:,18),heltab2x64(:,:,102))
  call Hloop_A_Q(ntryL,G1H32(30),80,0,G2H32(2),n2h32(58))
  call Hloop_QA_V(ntryL,G1H64(49),wf32(:,10),G1H2(16),m3h32x2(:,5),heltab2x64(:,:,103))
  call Hloop_QA_V(ntryL,G1H64(50),wf32(:,12),G1H2(14),m3h32x2(:,6),heltab2x64(:,:,104))
  call Hloop_VA_Q(ntryL,G1H64(51),wf32(:,10),G1H2(36),m3h32x2(:,7),heltab2x64(:,:,105))
  call Hloop_A_Q(ntryL,G1H2(36),95,0,G2H2(81),n2h2(89))
  call Hloop_VA_Q(ntryL,G1H64(52),wf32(:,12),G1H2(3),m3h32x2(:,8),heltab2x64(:,:,106))
  call Hloop_A_Q(ntryL,G1H2(3),95,0,G2H2(78),n2h2(90))
  call Hloop_QA_V(ntryL,G1H64(53),ex5(:),G1H32(31),m3h2x32(:,19),heltab2x64(:,:,107))
  call Hloop_QA_V(ntryL,G1H64(54),ex5(:),G1H32(32),m3h2x32(:,20),heltab2x64(:,:,108))
  call Hloop_VA_Q(ntryL,G1H64(55),ex5(:),G1H32(34),m3h2x32(:,21),heltab2x64(:,:,109))
  call Hloop_A_Q(ntryL,G1H32(34),80,0,G2H32(3),n2h32(59))
  call Hloop_VA_Q(ntryL,G1H64(56),ex5(:),G1H32(35),m3h2x32(:,22),heltab2x64(:,:,110))
  call Hloop_A_Q(ntryL,G1H32(35),80,0,G2H32(4),n2h32(60))
  call Hloop_QA_V(ntryL,G1H64(57),wf32(:,18),G1H2(10),m3h32x2(:,9),heltab2x64(:,:,111))
  call Hloop_QA_V(ntryL,G1H64(58),wf32(:,20),G1H2(25),m3h32x2(:,10),heltab2x64(:,:,112))
  call Hloop_VA_Q(ntryL,G1H64(59),wf32(:,18),G1H2(37),m3h32x2(:,11),heltab2x64(:,:,113))
  call Hloop_A_Q(ntryL,G1H2(37),95,0,G2H2(75),n2h2(91))
  call Hloop_VA_Q(ntryL,G1H64(60),wf32(:,20),G1H2(45),m3h32x2(:,12),heltab2x64(:,:,114))
  call Hloop_A_Q(ntryL,G1H2(45),95,0,G2H2(72),n2h2(92))
  call Hloop_QA_V(ntryL,G1H64(61),ex5(:),G1H32(36),m3h2x32(:,23),heltab2x64(:,:,115))
  call Hloop_QA_V(ntryL,G1H64(62),ex5(:),G1H32(37),m3h2x32(:,24),heltab2x64(:,:,116))
  call Hloop_VA_Q(ntryL,G1H64(63),ex5(:),G1H32(39),m3h2x32(:,25),heltab2x64(:,:,117))
  call Hloop_A_Q(ntryL,G1H32(39),80,0,G2H32(5),n2h32(61))
  call Hloop_VA_Q(ntryL,G1H64(64),ex5(:),G1H32(40),m3h2x32(:,26),heltab2x64(:,:,118))
  call Hloop_A_Q(ntryL,G1H32(40),80,0,G2H32(6),n2h32(62))
  call Hloop_QW_A(ntryL,G1H32(17),wf16(:,59),G1H2(46),m3h16x2(:,27),heltab2x32(:,:,85))
  call Hloop_Q_A(ntryL,G1H2(46),111,0,G2H2(69),n2h2(93))
  call Hloop_QW_A(ntryL,G1H32(18),wf16(:,60),G1H2(47),m3h16x2(:,28),heltab2x32(:,:,86))
  call Hloop_Q_A(ntryL,G1H2(47),111,0,G2H2(29),n2h2(94))
  call Hloop_QW_A(ntryL,G1H32(19),wf16(:,61),G1H2(50),m3h16x2(:,29),heltab2x32(:,:,87))
  call Hloop_Q_A(ntryL,G1H2(50),111,0,G2H2(28),n2h2(95))
  call Hloop_QA_V(ntryL,G1H64(65),wf32(:,26),G1H2(9),m3h32x2(:,13),heltab2x64(:,:,119))
  call Hloop_VA_Q(ntryL,G1H64(66),wf32(:,26),G1H2(21),m3h32x2(:,14),heltab2x64(:,:,120))
  call Hloop_A_Q(ntryL,G1H2(21),95,0,G2H2(24),n2h2(96))
  call Hloop_QA_V(ntryL,G1H64(67),ex5(:),G1H32(41),m3h2x32(:,27),heltab2x64(:,:,121))
  call Hloop_VA_Q(ntryL,G1H64(68),ex5(:),G1H32(42),m3h2x32(:,28),heltab2x64(:,:,122))
  call Hloop_A_Q(ntryL,G1H32(42),80,0,G2H32(7),n2h32(63))
  call Hloop_QA_V(ntryL,G1H64(69),wf32(:,30),G1H2(22),m3h32x2(:,15),heltab2x64(:,:,123))
  call Hloop_QA_V(ntryL,G1H64(70),wf32(:,32),G1H2(51),m3h32x2(:,16),heltab2x64(:,:,124))
  call Hloop_VA_Q(ntryL,G1H64(71),wf32(:,30),G1H2(52),m3h32x2(:,17),heltab2x64(:,:,125))
  call Hloop_A_Q(ntryL,G1H2(52),95,0,G2H2(23),n2h2(97))
  call Hloop_VA_Q(ntryL,G1H64(72),wf32(:,32),G1H2(55),m3h32x2(:,18),heltab2x64(:,:,126))
  call Hloop_A_Q(ntryL,G1H2(55),95,0,G2H2(19),n2h2(98))
  call Hloop_QA_V(ntryL,G1H64(73),ex5(:),G1H32(44),m3h2x32(:,29),heltab2x64(:,:,127))
  call Hloop_QA_V(ntryL,G1H64(74),ex5(:),G1H32(45),m3h2x32(:,30),heltab2x64(:,:,128))
  call Hloop_VA_Q(ntryL,G1H64(75),ex5(:),G1H32(46),m3h2x32(:,31),heltab2x64(:,:,129))
  call Hloop_A_Q(ntryL,G1H32(46),80,0,G2H32(8),n2h32(64))
  call Hloop_VA_Q(ntryL,G1H64(76),ex5(:),G1H32(47),m3h2x32(:,32),heltab2x64(:,:,130))
  call Hloop_A_Q(ntryL,G1H32(47),80,0,G2H32(9),n2h32(65))
  call Hloop_QW_A(ntryL,G1H32(25),wf16(:,62),G1H2(31),m3h16x2(:,30),heltab2x32(:,:,88))
  call Hloop_Q_A(ntryL,G1H2(31),111,0,G2H2(18),n2h2(99))
  call Hloop_QA_V(ntryL,G1H64(77),wf32(:,38),G1H2(43),m3h32x2(:,19),heltab2x64(:,:,131))
  call Hloop_VA_Q(ntryL,G1H64(78),wf32(:,38),G1H2(33),m3h32x2(:,20),heltab2x64(:,:,132))
  call Hloop_A_Q(ntryL,G1H2(33),95,0,G2H2(45),n2h2(100))
  call Hloop_QA_V(ntryL,G1H64(79),ex5(:),G1H32(49),m3h2x32(:,33),heltab2x64(:,:,133))
  call Hloop_VA_Q(ntryL,G1H64(80),ex5(:),G1H32(50),m3h2x32(:,34),heltab2x64(:,:,134))
  call Hloop_A_Q(ntryL,G1H32(50),80,0,G2H32(10),n2h32(66))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(70),[G2H2(73),G2H2(76),G2H2(79),G2H2(33),G2H2(31) &
    ,G2H2(47),G2H2(44),G2H2(41),G2H2(20),G2H2(7),G2H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(45),[G2H2(19),G2H2(23),G2H2(24),G2H2(72),G2H2(75) &
    ,G2H2(78),G2H2(81),G2H2(16),G2H2(21),G2H2(83),G2H2(80),G2H2(77),G2H2(74),G2H2(71),G2H2(68),G2H2(65),G2H2(62),G2H2(59),G2H2(22) &
    ,G2H2(9),G2H2(3)])
call HGT_w2_OLR(G1H4(21),1,1,4)
call HGT_w2_invQ_OLR(G1H4(21),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(21),[G1H4(44)])
call HGT_w2_OLR(G1H4(22),1,1,4)
call HGT_w2_invQ_OLR(G1H4(22),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(22),[G1H4(38)])
call HGT_w2_OLR(G1H4(27),1,1,4)
call HGT_w2_invQ_OLR(G1H4(27),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(27),[G1H4(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(18),[G2H2(28),G2H2(29),G2H2(69),G2H2(26),G2H2(67) &
    ,G2H2(56),G2H2(53),G2H2(50)])
call HGT_w2_OLR(G1H4(10),1,1,4)
call HGT_w2_invQ_OLR(G1H4(10),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(10),[G1H4(39)])
call HGT_w2_OLR(G1H4(11),1,1,4)
call HGT_w2_invQ_OLR(G1H4(11),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(11),[G1H4(42)])
call HGT_w2_OLR(G1H4(16),1,1,4)
call HGT_w2_invQ_OLR(G1H4(16),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(16),[G1H4(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(9),[G2H8(2),G2H8(10),G2H8(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(34),[G1H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(52),[G1H4(47)])
call HGT_w2_OLR(G1H4(34),1,1,4)
call HGT_w2_invQ_OLR(G1H4(34),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(34),[G1H4(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(17),[G2H8(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(19),[G2H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(32),[G1H2(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(49),[G1H2(2),G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(38),[G1H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(20),[G1H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(43),[G1H2(51),G1H2(22),G1H2(9),G1H2(25),G1H2(10),G1H2(14) &
    ,G1H2(16),G1H2(24),G1H2(23),G1H2(54),G1H2(30),G1H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(4),[G1H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(48),[G1H2(26),G1H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(48),[G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(53),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(53),[G1H2(11),G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(55),[G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(60),[G1H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(59),[G1H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(28),[G1H8(25),G1H8(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(11),[G1H8(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(12),[G1H8(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G2H2(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(11),[G2H2(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(7),[G2H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(24),[G2H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(2),[G2H16(12),G2H16(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(5),[G2H16(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(13),[G2H16(7),G2H16(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(11),[G2H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(3),[G2H16(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(14),[G2H16(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(25),[G2H16(21),G2H16(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(22),[G2H16(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(27),[G2H16(23),G2H16(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(24),[G2H16(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(26),[G2H16(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(28),[G2H16(20)])
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(70),ex6(:),G2tensor(59),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(45),ex6(:),G2tensor(2),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hloop_AW_Q(ntryL,G1H4(21),wf4(:,4),G1H1(1),m3h4x1(:,48),heltab2x4(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(4),n2h1(122))
  call Hloop_AV_Q(ntryL,G1H4(22),wf4(:,2),G1H1(1),m3h4x1(:,49),heltab2x4(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(6),n2h1(123))
  call Hloop_AZ_Q(ntryL,G1H4(27),wf4(:,7),G1H1(1),ngZd,m3h4x1(:,50),heltab2x4(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(7),n2h1(124))
call HGT_w2_OLR(G1H4(28),1,1,4)
call HGT_w2_invQ_OLR(G1H4(28),2,5,4)
  call Hloop_QW_A(ntryL,G1H4(28),wf4(:,4),G1H1(1),m3h4x1(:,51),heltab2x4(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(10),n2h1(125))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(18),ex5(:),G2tensor(11),m3h2x1(:,77),heltab2x2(:,:,77))
call HGT_w2_OLR(G1H4(15),1,1,4)
call HGT_w2_invQ_OLR(G1H4(15),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(15),wf4(:,2),G1H1(1),m3h4x1(:,52),heltab2x4(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(14),n2h1(126))
call HGT_w2_OLR(G1H4(26),1,1,4)
call HGT_w2_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(26),wf4(:,7),G1H1(1),ngZu,m3h4x1(:,53),heltab2x4(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(18),n2h1(127))
  call Hloop_AV_Q(ntryL,G1H4(10),wf4(:,2),G1H1(1),m3h4x1(:,54),heltab2x4(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(22),n2h1(128))
  call Hloop_AZ_Q(ntryL,G1H4(11),wf4(:,7),G1H1(1),ngZd,m3h4x1(:,55),heltab2x4(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(23),n2h1(129))
  call Hloop_AW_Q(ntryL,G1H4(16),wf4(:,4),G1H1(1),m3h4x1(:,56),heltab2x4(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(26),n2h1(130))
call HGT_w2_OLR(G1H4(17),1,1,4)
call HGT_w2_invQ_OLR(G1H4(17),2,5,4)
  call Hloop_AV_Q(ntryL,G1H4(17),wf4(:,2),G1H1(1),m3h4x1(:,57),heltab2x4(:,:,75))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(27),n2h1(131))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(9),wf8(:,2),G2tensor(87),m3h8x1(:,25),heltab2x8(:,:,115))
call HGT_w2_OLR(G1H4(32),1,1,4)
call HGT_w2_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_AZ_Q(ntryL,G1H4(32),wf4(:,7),G1H1(1),ngZu,m3h4x1(:,58),heltab2x4(:,:,76))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(78),n2h1(132))
  call Hloop_AW_Q(ntryL,G1H4(34),wf4(:,4),G1H1(1),m3h4x1(:,59),heltab2x4(:,:,77))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(126),n2h1(133))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(17),wf8(:,4),G2tensor(132),m3h8x1(:,26),heltab2x8(:,:,116))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(19),wf8(:,6),G2tensor(61),m3h8x1(:,27),heltab2x8(:,:,117))
call HGT_w2_OLR(G1H16(25),1,1,16)
call HGT_w2_invQ_OLR(G1H16(25),2,5,16)
  call Hloop_AW_Q(ntryL,G1H16(25),wf16(:,27),G1H1(1),m3h16x1(:,1),heltab2x16(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(57),n2h1(134))
call HGT_w2_OLR(G1H16(26),1,1,16)
call HGT_w2_invQ_OLR(G1H16(26),2,5,16)
  call Hloop_AW_Q(ntryL,G1H16(26),wf16(:,28),G1H1(1),m3h16x1(:,2),heltab2x16(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(49),n2h1(135))
call HGT_w2_OLR(G1H16(28),1,1,16)
call HGT_w2_invQ_OLR(G1H16(28),2,5,16)
  call Hloop_AW_Q(ntryL,G1H16(28),wf16(:,59),G1H1(1),m3h16x1(:,3),heltab2x16(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(15),n2h1(136))
call HGT_w2_OLR(G1H16(29),1,1,16)
call HGT_w2_invQ_OLR(G1H16(29),2,5,16)
  call Hloop_AW_Q(ntryL,G1H16(29),wf16(:,60),G1H1(1),m3h16x1(:,4),heltab2x16(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(50),n2h1(137))
call HGT_w2_OLR(G1H16(30),1,1,16)
call HGT_w2_invQ_OLR(G1H16(30),2,5,16)
  call Hloop_AW_Q(ntryL,G1H16(30),wf16(:,61),G1H1(1),m3h16x1(:,5),heltab2x16(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(19),n2h1(138))
call HGT_w2_OLR(G1H16(31),1,1,16)
call HGT_w2_invQ_OLR(G1H16(31),2,5,16)
  call Hloop_AW_Q(ntryL,G1H16(31),wf16(:,62),G1H1(1),m3h16x1(:,6),heltab2x16(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(51),n2h1(139))
  call Hloop_VA_Q(ntryL,G1H2(32),ex5(:),G1H1(1),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(53),n2h1(140))
  call Hloop_VA_Q(ntryL,G1H2(49),ex5(:),G1H1(1),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(75),n2h1(141))
  call Hloop_VA_Q(ntryL,G1H2(38),ex5(:),G1H1(1),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(120),n2h1(142))
  call Hloop_VQ_A(ntryL,G1H2(20),ex6(:),G1H1(1),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(81),n2h1(143))
  call Hloop_VQ_A(ntryL,G1H2(43),ex6(:),G1H1(1),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(123),n2h1(144))
  call Hloop_VQ_A(ntryL,G1H2(4),ex6(:),G1H1(1),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(90),n2h1(145))
  call Hloop_VA_Q(ntryL,G1H2(48),ex5(:),G1H1(1),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(55),n2h1(146))
  call Hloop_AW_Q(ntryL,G1H4(48),wf4(:,4),G1H1(1),m3h4x1(:,60),heltab2x4(:,:,78))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(1),n2h1(147))
  call Hloop_AW_Q(ntryL,G1H4(53),wf4(:,4),G1H1(1),m3h4x1(:,61),heltab2x4(:,:,79))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(93),n2h1(148))
  call Hloop_VQ_A(ntryL,G1H2(53),ex6(:),G1H1(1),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(56),n2h1(149))
  call Hloop_QW_A(ntryL,G1H4(55),wf4(:,4),G1H1(1),m3h4x1(:,62),heltab2x4(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(96),n2h1(150))
  call Hloop_QW_A(ntryL,G1H4(60),wf4(:,4),G1H1(1),m3h4x1(:,63),heltab2x4(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(99),n2h1(151))
  call Hloop_QW_A(ntryL,G1H4(59),wf4(:,4),G1H1(1),m3h4x1(:,64),heltab2x4(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(63),n2h1(152))
  call Hloop_VA_Q(ntryL,G1H8(58),wf8(:,10),G1H1(1),m3h8x1(:,28),heltab2x8(:,:,118))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(66),n2h1(153))
  call Hloop_VA_Q(ntryL,G1H8(59),wf8(:,10),G1H1(1),m3h8x1(:,29),heltab2x8(:,:,119))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(102),n2h1(154))
  call Hloop_VQ_A(ntryL,G1H8(19),wf8(:,2),G1H1(1),m3h8x1(:,30),heltab2x8(:,:,120))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(105),n2h1(155))
  call Hloop_VQ_A(ntryL,G1H8(28),wf8(:,2),G1H1(1),m3h8x1(:,31),heltab2x8(:,:,121))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(69),n2h1(156))
  call Hloop_VA_Q(ntryL,G1H8(29),wf8(:,12),G1H1(1),m3h8x1(:,32),heltab2x8(:,:,122))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(72),n2h1(157))
  call Hloop_VA_Q(ntryL,G1H8(30),wf8(:,12),G1H1(1),m3h8x1(:,33),heltab2x8(:,:,123))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(108),n2h1(158))
  call Hloop_VA_Q(ntryL,G1H8(41),wf8(:,14),G1H1(1),m3h8x1(:,34),heltab2x8(:,:,124))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(111),n2h1(159))
  call Hloop_VA_Q(ntryL,G1H8(45),wf8(:,14),G1H1(1),m3h8x1(:,35),heltab2x8(:,:,125))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(84),n2h1(160))
  call Hloop_VQ_A(ntryL,G1H8(55),wf8(:,4),G1H1(1),m3h8x1(:,36),heltab2x8(:,:,126))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(114),n2h1(161))
  call Hloop_VQ_A(ntryL,G1H8(11),wf8(:,4),G1H1(1),m3h8x1(:,37),heltab2x8(:,:,127))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(117),n2h1(162))
  call Hloop_VQ_A(ntryL,G1H8(34),wf8(:,6),G1H1(1),m3h8x1(:,38),heltab2x8(:,:,128))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(129),n2h1(163))
  call Hloop_VQ_A(ntryL,G1H8(12),wf8(:,6),G1H1(1),m3h8x1(:,39),heltab2x8(:,:,129))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(135),n2h1(164))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(2),ex6(:),G2tensor(138),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(5),ex6(:),G2tensor(139),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(8),ex5(:),G2tensor(140),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(11),ex5(:),G2tensor(141),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(7),wf8(:,2),G2tensor(142),m3h8x1(:,40),heltab2x8(:,:,130))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(8),wf8(:,4),G2tensor(143),m3h8x1(:,41),heltab2x8(:,:,131))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(16),wf8(:,6),G2tensor(144),m3h8x1(:,42),heltab2x8(:,:,132))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(24),wf8(:,10),G2tensor(145),m3h8x1(:,43),heltab2x8(:,:,133))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(11),wf8(:,12),G2tensor(146),m3h8x1(:,44),heltab2x8(:,:,134))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(13),wf8(:,14),G2tensor(147),m3h8x1(:,45),heltab2x8(:,:,135))
  call Hloop_AV_Q(ntryL,G2H16(2),wf16(:,23),G2H1(1),m3h16x1(:,7),heltab2x16(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(1),n2h1(165))
  call Hloop_AV_Q(ntryL,G2H16(5),wf16(:,23),G2H1(1),m3h16x1(:,8),heltab2x16(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(2),n2h1(166))
  call Hloop_QV_A(ntryL,G2H16(13),wf16(:,23),G2H1(1),m3h16x1(:,9),heltab2x16(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(3),n2h1(167))
  call Hloop_QV_A(ntryL,G2H16(11),wf16(:,23),G2H1(1),m3h16x1(:,10),heltab2x16(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(4),n2h1(168))
  call Hloop_AV_Q(ntryL,G2H16(3),wf16(:,23),G2H1(1),m3h16x1(:,11),heltab2x16(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(5),n2h1(169))
  call Hloop_QV_A(ntryL,G2H16(14),wf16(:,23),G2H1(1),m3h16x1(:,12),heltab2x16(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(6),n2h1(170))
  call Hloop_AV_Q(ntryL,G2H16(25),wf16(:,26),G2H1(1),m3h16x1(:,13),heltab2x16(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(7),n2h1(171))
  call Hloop_AV_Q(ntryL,G2H16(22),wf16(:,26),G2H1(1),m3h16x1(:,14),heltab2x16(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(8),n2h1(172))
  call Hloop_QV_A(ntryL,G2H16(27),wf16(:,26),G2H1(1),m3h16x1(:,15),heltab2x16(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(9),n2h1(173))
  call Hloop_QV_A(ntryL,G2H16(24),wf16(:,26),G2H1(1),m3h16x1(:,16),heltab2x16(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(10),n2h1(174))
  call Hloop_AV_Q(ntryL,G2H16(26),wf16(:,26),G2H1(1),m3h16x1(:,17),heltab2x16(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(11),n2h1(175))
  call Hloop_QV_A(ntryL,G2H16(28),wf16(:,26),G2H1(1),m3h16x1(:,18),heltab2x16(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(12),n2h1(176))
  call Hloop_VQ_A(ntryL,G1H32(26),wf32(:,6),G1H1(1),m3h32x1(:,1),heltab2x32(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(148),n2h1(177))
  call Hloop_VQ_A(ntryL,G1H32(27),wf32(:,8),G1H1(1),m3h32x1(:,2),heltab2x32(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(149),n2h1(178))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H32(1),wf32(:,6),G2tensor(150),m3h32x1(:,3),heltab2x32(:,:,91))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H32(2),wf32(:,8),G2tensor(151),m3h32x1(:,4),heltab2x32(:,:,92))
  call Hloop_VQ_A(ntryL,G1H32(31),wf32(:,14),G1H1(1),m3h32x1(:,5),heltab2x32(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(152),n2h1(179))
  call Hloop_VQ_A(ntryL,G1H32(32),wf32(:,16),G1H1(1),m3h32x1(:,6),heltab2x32(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(153),n2h1(180))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H32(3),wf32(:,14),G2tensor(154),m3h32x1(:,7),heltab2x32(:,:,95))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H32(4),wf32(:,16),G2tensor(155),m3h32x1(:,8),heltab2x32(:,:,96))
  call Hloop_VQ_A(ntryL,G1H32(36),wf32(:,22),G1H1(1),m3h32x1(:,9),heltab2x32(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(156),n2h1(181))
  call Hloop_VQ_A(ntryL,G1H32(37),wf32(:,24),G1H1(1),m3h32x1(:,10),heltab2x32(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(157),n2h1(182))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H32(5),wf32(:,22),G2tensor(158),m3h32x1(:,11),heltab2x32(:,:,99))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H32(6),wf32(:,24),G2tensor(159),m3h32x1(:,12),heltab2x32(:,:,100))
  call Hloop_VQ_A(ntryL,G1H32(41),wf32(:,28),G1H1(1),m3h32x1(:,13),heltab2x32(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(160),n2h1(183))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H32(7),wf32(:,28),G2tensor(161),m3h32x1(:,14),heltab2x32(:,:,102))
  call Hloop_VQ_A(ntryL,G1H32(44),wf32(:,34),G1H1(1),m3h32x1(:,15),heltab2x32(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(162),n2h1(184))
  call Hloop_VQ_A(ntryL,G1H32(45),wf32(:,36),G1H1(1),m3h32x1(:,16),heltab2x32(:,:,104))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(163),n2h1(185))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H32(8),wf32(:,34),G2tensor(164),m3h32x1(:,17),heltab2x32(:,:,105))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H32(9),wf32(:,36),G2tensor(165),m3h32x1(:,18),heltab2x32(:,:,106))
  call Hloop_VQ_A(ntryL,G1H32(49),wf32(:,40),G1H1(1),m3h32x1(:,19),heltab2x32(:,:,107))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(166),n2h1(186))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H32(10),wf32(:,40),G2tensor(167),m3h32x1(:,20),heltab2x32(:,:,108))
  call ol_merge_tensors(G2tensor(10),[G2tensor(4),G2tensor(16),G2tensor(8),G1tensor(78),G1tensor(10),G1tensor(36),G1tensor(9) &
    ,G0tensor(78),G0tensor(32),G0tensor(17),G0tensor(12)])
  call ol_merge_tensors(G2tensor(18),[G2tensor(14),G2tensor(7),G2tensor(6),G2tensor(20),G2tensor(12),G1tensor(63),G1tensor(23) &
    ,G1tensor(2),G1tensor(21),G0tensor(63),G0tensor(37),G0tensor(27),G0tensor(22)])
  call ol_merge_tensors(G2tensor(139),[G2tensor(121),G2tensor(76),G2tensor(24),G1tensor(68),G1tensor(45),G1tensor(35),G1tensor(42) &
    ,G0tensor(68),G0tensor(47),G0tensor(42),G0tensor(23)])
  call ol_merge_tensors(G2tensor(141),[G2tensor(124),G2tensor(82),G2tensor(28),G1tensor(57),G1tensor(52),G1tensor(27),G0tensor(57) &
    ,G0tensor(52),G0tensor(38)])
  call ol_merge_tensors(G2tensor(51),[G2tensor(19),G2tensor(50),G2tensor(15),G2tensor(49),G2tensor(57),G2tensor(95),G2tensor(92) &
    ,G2tensor(89),G2tensor(21),G2tensor(13),G2tensor(3),G1tensor(80),G1tensor(72),G1tensor(65),G0tensor(80),G0tensor(72) &
    ,G0tensor(65)])
  call ol_merge_tensors(G2tensor(167),[G2tensor(166),G2tensor(165),G2tensor(164),G2tensor(163),G2tensor(162),G2tensor(161) &
    ,G2tensor(160),G2tensor(159),G2tensor(158),G2tensor(157),G2tensor(156),G2tensor(155),G2tensor(154),G2tensor(153),G2tensor(152) &
    ,G2tensor(151),G2tensor(150),G2tensor(149),G2tensor(148),G2tensor(62),G2tensor(60),G2tensor(58),G2tensor(5),G1tensor(75) &
    ,G1tensor(12),G1tensor(25),G0tensor(75),G0tensor(10),G0tensor(5)])
  call ol_merge_tensors(G2tensor(126),[G2tensor(91),G2tensor(88),G2tensor(17),G2tensor(9),G1tensor(133),G1tensor(128),G1tensor(62) &
    ,G1tensor(7),G0tensor(133),G0tensor(128),G0tensor(62),G0tensor(2)])
  call ol_merge_tensors(G2tensor(78),[G2tensor(27),G2tensor(94),G2tensor(25),G1tensor(77),G1tensor(37),G0tensor(77),G0tensor(7)])
  call ol_merge_tensors(G2tensor(104),[G2tensor(98),G2tensor(34),G2tensor(29),G1tensor(110),G1tensor(90),G1tensor(24) &
    ,G0tensor(110),G0tensor(90),G0tensor(18)])
  call ol_merge_tensors(G2tensor(107),[G2tensor(101),G2tensor(35),G2tensor(30),G1tensor(115),G1tensor(95),G1tensor(11) &
    ,G1tensor(26),G0tensor(115),G0tensor(95),G0tensor(29),G0tensor(19)])
  call ol_merge_tensors(G3tensor(9),[G3tensor(7),G3tensor(3),G3tensor(1),G2tensor(125),G2tensor(122),G2tensor(86),G2tensor(80) &
    ,G2tensor(71),G2tensor(65),G2tensor(44),G2tensor(41),G2tensor(36),G2tensor(31),G1tensor(140),G1tensor(120),G1tensor(100) &
    ,G1tensor(60),G1tensor(50),G1tensor(32),G0tensor(140),G0tensor(120),G0tensor(100),G0tensor(60),G0tensor(50),G0tensor(20)])
  call ol_merge_tensors(G2tensor(85),[G2tensor(83),G2tensor(79),G2tensor(77),G2tensor(37),G2tensor(32),G1tensor(137),G1tensor(55) &
    ,G1tensor(47),G1tensor(4),G0tensor(137),G0tensor(55),G0tensor(45),G0tensor(28)])
  call ol_merge_tensors(G2tensor(137),[G2tensor(134),G2tensor(131),G2tensor(128),G2tensor(74),G2tensor(68),G2tensor(38) &
    ,G2tensor(33),G1tensor(160),G1tensor(155),G1tensor(125),G1tensor(105),G1tensor(5),G0tensor(160),G0tensor(155),G0tensor(125) &
    ,G0tensor(105),G0tensor(30)])
  call ol_merge_tensors(G2tensor(66),[G2tensor(110),G2tensor(39),G1tensor(130),G1tensor(46),G0tensor(130),G0tensor(48)])
  call ol_merge_tensors(G2tensor(102),[G2tensor(113),G2tensor(40),G1tensor(135),G1tensor(49),G0tensor(135),G0tensor(49)])
  call ol_merge_tensors(G2tensor(105),[G2tensor(116),G2tensor(42),G1tensor(145),G1tensor(58),G0tensor(145),G0tensor(58)])
  call ol_merge_tensors(G2tensor(69),[G2tensor(87),G2tensor(119),G2tensor(48),G2tensor(43),G1tensor(150),G1tensor(85),G1tensor(59) &
    ,G1tensor(6),G0tensor(150),G0tensor(85),G0tensor(59),G0tensor(9)])
  call ol_merge_tensors(G2tensor(144),[G2tensor(143),G2tensor(67),G2tensor(45),G1tensor(102),G1tensor(33),G1tensor(13) &
    ,G0tensor(102),G0tensor(25),G0tensor(3)])
  call ol_merge_tensors(G2tensor(135),[G2tensor(117),G2tensor(61),G2tensor(132),G2tensor(46),G1tensor(159),G1tensor(70) &
    ,G1tensor(19),G0tensor(159),G0tensor(70),G0tensor(4)])
  call ol_merge_tensors(G2tensor(142),[G2tensor(64),G2tensor(47),G1tensor(97),G1tensor(20),G1tensor(43),G0tensor(97),G0tensor(15) &
    ,G0tensor(8)])
  call ol_merge_tensors(G2tensor(145),[G2tensor(70),G2tensor(52),G1tensor(117),G1tensor(16),G0tensor(117),G0tensor(35)])
  call ol_merge_tensors(G2tensor(147),[G2tensor(146),G2tensor(73),G2tensor(54),G1tensor(122),G1tensor(28),G0tensor(122) &
    ,G0tensor(40)])
  call ol_merge_tensors(G2tensor(138),[G2tensor(130),G2tensor(127),G2tensor(97),G1tensor(152),G1tensor(87),G1tensor(83) &
    ,G1tensor(30),G0tensor(152),G0tensor(87),G0tensor(83),G0tensor(13)])
  call ol_merge_tensors(G2tensor(59),[G2tensor(100),G1tensor(92),G1tensor(73),G1tensor(44),G1tensor(18),G0tensor(92),G0tensor(73) &
    ,G0tensor(24),G0tensor(14)])
  call ol_merge_tensors(G2tensor(140),[G2tensor(136),G2tensor(133),G2tensor(103),G1tensor(157),G1tensor(107),G1tensor(15) &
    ,G0tensor(157),G0tensor(107),G0tensor(33)])
  call ol_merge_tensors(G2tensor(11),[G2tensor(106),G1tensor(112),G1tensor(34),G1tensor(22),G0tensor(112),G0tensor(39) &
    ,G0tensor(34)])
  call ol_merge_tensors(G2tensor(55),[G2tensor(109),G1tensor(127),G1tensor(93),G1tensor(88),G1tensor(39),G0tensor(127) &
    ,G0tensor(93),G0tensor(88),G0tensor(43)])
  call ol_merge_tensors(G2tensor(120),[G2tensor(112),G1tensor(132),G1tensor(103),G1tensor(40),G0tensor(132),G0tensor(103) &
    ,G0tensor(44)])
  call ol_merge_tensors(G2tensor(56),[G2tensor(115),G1tensor(142),G1tensor(113),G1tensor(108),G1tensor(53),G0tensor(142) &
    ,G0tensor(113),G0tensor(108),G0tensor(53)])
  call ol_merge_tensors(G2tensor(90),[G2tensor(118),G1tensor(147),G1tensor(123),G1tensor(54),G0tensor(147),G0tensor(123) &
    ,G0tensor(54)])
  call ol_merge_tensors(G2tensor(23),[G2tensor(22),G1tensor(67),G1tensor(64),G0tensor(67),G0tensor(64)])
  call ol_merge_tensors(G2tensor(123),[G2tensor(2),G1tensor(124),G1tensor(119),G1tensor(114),G1tensor(84),G1tensor(74) &
    ,G1tensor(69),G0tensor(124),G0tensor(119),G0tensor(114),G0tensor(84),G0tensor(74),G0tensor(69)])
  call ol_merge_tensors(G2tensor(26),[G1tensor(82),G1tensor(79),G0tensor(82),G0tensor(79)])
  call ol_merge_tensors(G2tensor(53),[G1tensor(98),G1tensor(89),G0tensor(98),G0tensor(89)])
  call ol_merge_tensors(G2tensor(75),[G1tensor(104),G1tensor(99),G1tensor(94),G0tensor(104),G0tensor(99),G0tensor(94)])
  call ol_merge_tensors(G2tensor(81),[G1tensor(118),G1tensor(109),G0tensor(118),G0tensor(109)])
  call ol_merge_tensors(G2tensor(96),[G2tensor(1),G1tensor(144),G1tensor(138),G1tensor(129),G0tensor(144),G0tensor(138) &
    ,G0tensor(129)])
  call ol_merge_tensors(G2tensor(99),[G2tensor(93),G1tensor(149),G1tensor(139),G1tensor(134),G0tensor(149),G0tensor(139) &
    ,G0tensor(134)])
  call ol_merge_tensors(G2tensor(63),[G1tensor(148),G1tensor(143),G0tensor(148),G0tensor(143)])
  call ol_merge_tensors(G2tensor(111),[G2tensor(72),G1tensor(153),G0tensor(153)])
  call ol_merge_tensors(G2tensor(84),[G2tensor(108),G1tensor(154),G0tensor(154)])
  call ol_merge_tensors(G2tensor(129),[G2tensor(114),G1tensor(158),G0tensor(158)])
  call ol_merge_tensors(G3tensor(10),[G3tensor(8),G3tensor(4),G3tensor(2)])
  call ol_merge_tensors(G3tensor(12),[G3tensor(11),G3tensor(6),G3tensor(5)])
  call TI_triangle_red(G2tensor(10),RedBasis(56),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1)
  call TI_triangle_red(G2tensor(18),RedBasis(54),mass3set(:,1),G0tensor(21),G0tensor(26),G0tensor(31),G0tensor(36),M2L1R1)
  call TI_triangle_red(G2tensor(139),RedBasis(18),mass3set(:,1),G0tensor(41),G0tensor(46),G0tensor(51),G0tensor(56),M2L1R1)
  call TI_triangle_red(G2tensor(141),RedBasis(51),mass3set(:,1),G0tensor(61),G0tensor(66),G0tensor(71),G0tensor(76),M2L1R1)
  call TI_triangle_red(G2tensor(51),RedBasis(52),mass3set(:,1),G0tensor(81),G0tensor(86),G0tensor(91),G0tensor(96),M2L1R1)
  call TI_triangle_red(G2tensor(167),RedBasis(14),mass3set(:,1),G0tensor(101),G0tensor(106),G0tensor(111),G0tensor(116),M2L1R1)
  call TI_triangle_red(G2tensor(126),RedBasis(26),mass3set(:,1),G0tensor(121),G0tensor(126),G0tensor(131),G0tensor(136),M2L1R1)
  call TI_triangle_red(G2tensor(78),RedBasis(60),mass3set(:,1),G0tensor(141),G0tensor(146),G0tensor(151),G0tensor(156),M2L1R1)
  call TI_triangle_red(G2tensor(104),RedBasis(4),mass3set(:,1),G0tensor(78),G0tensor(32),G0tensor(17),G0tensor(12),M2L1R1)
  call TI_triangle_red(G2tensor(107),RedBasis(2),mass3set(:,1),G0tensor(63),G0tensor(37),G0tensor(27),G0tensor(22),M2L1R1)
  call TI_triangle_red(G3tensor(9),RedBasis(1),mass3set(:,1),G0tensor(68),G0tensor(47),G0tensor(42),G0tensor(23),M2L1R1)
  call TI_triangle_red(G2tensor(85),RedBasis(8),mass3set(:,1),G0tensor(57),G0tensor(52),G0tensor(38),G0tensor(80),M2L1R1)
  call TI_triangle_red(G2tensor(137),RedBasis(7),mass3set(:,1),G0tensor(72),G0tensor(65),G0tensor(75),G0tensor(10),M2L1R1)
  call TI_triangle_red(G2tensor(66),RedBasis(24),mass3set(:,1),G0tensor(5),G0tensor(133),G0tensor(128),G0tensor(62),M2L1R1)
  call TI_triangle_red(G2tensor(102),RedBasis(22),mass3set(:,1),G0tensor(2),G0tensor(77),G0tensor(7),G0tensor(110),M2L1R1)
  call TI_triangle_red(G2tensor(105),RedBasis(27),mass3set(:,1),G0tensor(90),G0tensor(18),G0tensor(115),G0tensor(95),M2L1R1)
  call TI_triangle_red(G2tensor(69),RedBasis(19),mass3set(:,1),G0tensor(29),G0tensor(19),G0tensor(140),G0tensor(120),M2L1R1)
  call TI_triangle_red(G2tensor(144),RedBasis(16),mass3set(:,1),G0tensor(100),G0tensor(60),G0tensor(50),G0tensor(20),M2L1R1)
  call TI_triangle_red(G2tensor(135),RedBasis(15),mass3set(:,1),G0tensor(137),G0tensor(55),G0tensor(45),G0tensor(28),M2L1R1)
  call TI_triangle_red(G2tensor(142),RedBasis(20),mass3set(:,1),G0tensor(160),G0tensor(155),G0tensor(125),G0tensor(105),M2L1R1)
  call TI_triangle_red(G2tensor(145),RedBasis(47),mass3set(:,1),G0tensor(30),G0tensor(130),G0tensor(48),G0tensor(135),M2L1R1)
  call TI_triangle_red(G2tensor(147),RedBasis(50),mass3set(:,1),G0tensor(49),G0tensor(145),G0tensor(58),G0tensor(150),M2L1R1)
  call TI_triangle_red(G2tensor(138),RedBasis(21),mass3set(:,1),G0tensor(85),G0tensor(59),G0tensor(9),G0tensor(102),M2L1R1)
  call TI_triangle_red(G2tensor(59),RedBasis(17),mass3set(:,1),G0tensor(25),G0tensor(3),G0tensor(159),G0tensor(70),M2L1R1)
  call TI_triangle_red(G2tensor(140),RedBasis(49),mass3set(:,1),G0tensor(4),G0tensor(97),G0tensor(15),G0tensor(8),M2L1R1)
  call TI_triangle_red(G2tensor(11),RedBasis(48),mass3set(:,1),G0tensor(117),G0tensor(35),G0tensor(122),G0tensor(40),M2L1R1)
  call TI_triangle_red(G2tensor(55),RedBasis(6),mass3set(:,1),G0tensor(152),G0tensor(87),G0tensor(83),G0tensor(13),M2L1R1)
  call TI_triangle_red(G2tensor(120),RedBasis(9),mass3set(:,1),G0tensor(92),G0tensor(73),G0tensor(24),G0tensor(14),M2L1R1)
  call TI_triangle_red(G2tensor(56),RedBasis(12),mass3set(:,1),G0tensor(157),G0tensor(107),G0tensor(33),G0tensor(112),M2L1R1)
  call TI_triangle_red(G2tensor(90),RedBasis(13),mass3set(:,1),G0tensor(39),G0tensor(34),G0tensor(127),G0tensor(93),M2L1R1)
  call TI_triangle_red(G2tensor(23),RedBasis(53),mass3set(:,1),G0tensor(88),G0tensor(43),G0tensor(132),G0tensor(103),M2L1R1)
  call TI_triangle_red(G2tensor(123),RedBasis(10),mass3set(:,1),G0tensor(44),G0tensor(142),G0tensor(113),G0tensor(108),M2L1R1)
  call TI_triangle_red(G2tensor(26),RedBasis(55),mass3set(:,1),G0tensor(53),G0tensor(147),G0tensor(123),G0tensor(54),M2L1R1)
  call TI_triangle_red(G2tensor(53),RedBasis(5),mass3set(:,1),G0tensor(67),G0tensor(64),G0tensor(124),G0tensor(119),M2L1R1)
  call TI_triangle_red(G2tensor(75),RedBasis(3),mass3set(:,1),G0tensor(114),G0tensor(84),G0tensor(74),G0tensor(69),M2L1R1)
  call TI_triangle_red(G2tensor(81),RedBasis(11),mass3set(:,1),G0tensor(82),G0tensor(79),G0tensor(98),G0tensor(89),M2L1R1)
  call TI_triangle_red(G2tensor(96),RedBasis(25),mass3set(:,1),G0tensor(104),G0tensor(99),G0tensor(94),G0tensor(118),M2L1R1)
  call TI_triangle_red(G2tensor(99),RedBasis(23),mass3set(:,1),G0tensor(109),G0tensor(144),G0tensor(138),G0tensor(129),M2L1R1)
  call TI_triangle_red(G2tensor(63),RedBasis(28),mass3set(:,1),G0tensor(149),G0tensor(139),G0tensor(134),G0tensor(148),M2L1R1)
  call TI_triangle_red(G2tensor(111),RedBasis(58),mass3set(:,1),G0tensor(143),G0tensor(153),G0tensor(154),G0tensor(158),M2L1R1)
  call TI_triangle_red(G2tensor(84),RedBasis(57),mass3set(:,1),G0tensor(161),G0tensor(162),G0tensor(163),G0tensor(164),M2L1R1)
  call TI_triangle_red(G2tensor(129),RedBasis(59),mass3set(:,1),G0tensor(165),G0tensor(166),G0tensor(167),G0tensor(168),M2L1R1)
  call TI_triangle_red(G3tensor(10),RedBasis(1),mass3set(:,2),G0tensor(169),G0tensor(170),G0tensor(171), &
    G0tensor(172),M2L1R1,[nMT],G0tensor(173))
  call TI_triangle_red(G3tensor(12),RedBasis(1),mass3set(:,3),G0tensor(174),G0tensor(175),G0tensor(176), &
    G0tensor(177),M2L1R1,[nMB],G0tensor(178))
  call ol_merge_tensors(T0sum(33),[G0tensor(1)])
  call ol_merge_tensors(T0sum(34),[G0tensor(21)])
  call ol_merge_tensors(T0sum(35),[G0tensor(41)])
  call ol_merge_tensors(T0sum(36),[G0tensor(61)])
  call ol_merge_tensors(T0sum(37),[G0tensor(81)])
  call ol_merge_tensors(T0sum(38),[G0tensor(101)])
  call ol_merge_tensors(T0sum(39),[G0tensor(121)])
  call ol_merge_tensors(T0sum(40),[G0tensor(141)])
  call ol_merge_tensors(T0sum(41),[G0tensor(78)])
  call ol_merge_tensors(T0sum(42),[G0tensor(63)])
  call ol_merge_tensors(T0sum(43),[G0tensor(68)])
  call ol_merge_tensors(T0sum(44),[G0tensor(57)])
  call ol_merge_tensors(T0sum(45),[G0tensor(72)])
  call ol_merge_tensors(T0sum(46),[G0tensor(5)])
  call ol_merge_tensors(T0sum(47),[G0tensor(2)])
  call ol_merge_tensors(T0sum(48),[G0tensor(90)])
  call ol_merge_tensors(T0sum(49),[G0tensor(29)])
  call ol_merge_tensors(T0sum(50),[G0tensor(100)])
  call ol_merge_tensors(T0sum(51),[G0tensor(137)])
  call ol_merge_tensors(T0sum(52),[G0tensor(160)])
  call ol_merge_tensors(T0sum(53),[G0tensor(30)])
  call ol_merge_tensors(T0sum(54),[G0tensor(49)])
  call ol_merge_tensors(T0sum(55),[G0tensor(85)])
  call ol_merge_tensors(T0sum(56),[G0tensor(25)])
  call ol_merge_tensors(T0sum(57),[G0tensor(4)])
  call ol_merge_tensors(T0sum(58),[G0tensor(117)])
  call ol_merge_tensors(T0sum(59),[G0tensor(152)])
  call ol_merge_tensors(T0sum(60),[G0tensor(92)])
  call ol_merge_tensors(T0sum(61),[G0tensor(157)])
  call ol_merge_tensors(T0sum(62),[G0tensor(39)])
  call ol_merge_tensors(T0sum(63),[G0tensor(88)])
  call ol_merge_tensors(T0sum(64),[G0tensor(44)])
  call ol_merge_tensors(T0sum(65),[G0tensor(53)])
  call ol_merge_tensors(T0sum(66),[G0tensor(67)])
  call ol_merge_tensors(T0sum(67),[G0tensor(114)])
  call ol_merge_tensors(T0sum(68),[G0tensor(82)])
  call ol_merge_tensors(T0sum(69),[G0tensor(104)])
  call ol_merge_tensors(T0sum(70),[G0tensor(109)])
  call ol_merge_tensors(T0sum(71),[G0tensor(149)])
  call ol_merge_tensors(T0sum(72),[G0tensor(143)])
  call ol_merge_tensors(T0sum(73),[G0tensor(161)])
  call ol_merge_tensors(T0sum(74),[G0tensor(165)])
  call ol_merge_tensors(T0sum(75),[G0tensor(169)])
  call ol_merge_tensors(T0sum(76),[G0tensor(174)])
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(97)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(183),h0tab(:,183),[86,41],[0,0],2,2,wf16(:,30),wf8(:,2))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,30),G0H8(1),m3h16x8(:,17),heltab2x128(:,:,183))
  call Hloop_A_Q(ntryL,G0H8(1),86,0,G1H8(39),n2h8(89))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(184),h0tab(:,184),[86,41],[0,0],2,2,wf16(:,31),wf8(:,2))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,31),G0H8(1),m3h16x8(:,18),heltab2x128(:,:,184))
  call Hloop_A_Q(ntryL,G0H8(1),86,0,G1H8(46),n2h8(90))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(206)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(185),h0tab(:,185),[80,47],[0,0],2,2,wf4(:,5),wf32(:,6))
  call Hloop_QA_V(ntryL,G0H128(1),wf4(:,5),G0H32(1),m3h4x32(:,29),heltab2x128(:,:,185))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(207)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(186),h0tab(:,186),[80,47],[0,0],2,2,wf4(:,5),wf32(:,8))
  call Hloop_QA_V(ntryL,G0H128(1),wf4(:,5),G0H32(2),m3h4x32(:,30),heltab2x128(:,:,186))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(187),h0tab(:,187),[89,38],[0,0],2,2,wf16(:,29),wf8(:,4))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,29),G0H8(1),m3h16x8(:,19),heltab2x128(:,:,187))
  call Hloop_A_Q(ntryL,G0H8(1),89,0,G1H8(51),n2h8(91))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(188),h0tab(:,188),[89,38],[0,0],2,2,wf16(:,29),wf8(:,6))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,29),G0H8(1),m3h16x8(:,20),heltab2x128(:,:,188))
  call Hloop_A_Q(ntryL,G0H8(1),89,0,G1H8(56),n2h8(92))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(208)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(189),h0tab(:,189),[80,47],[0,0],2,2,wf4(:,5),wf32(:,14))
  call Hloop_QA_V(ntryL,G0H128(1),wf4(:,5),G0H32(3),m3h4x32(:,31),heltab2x128(:,:,189))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(209)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(190),h0tab(:,190),[80,47],[0,0],2,2,wf4(:,5),wf32(:,16))
  call Hloop_QA_V(ntryL,G0H128(1),wf4(:,5),G0H32(4),m3h4x32(:,32),heltab2x128(:,:,190))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(210)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(191),h0tab(:,191),[80,47],[0,0],2,2,wf4(:,5),wf32(:,22))
  call Hloop_QA_V(ntryL,G0H128(1),wf4(:,5),G0H32(5),m3h4x32(:,33),heltab2x128(:,:,191))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(211)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(192),h0tab(:,192),[80,47],[0,0],2,2,wf4(:,5),wf32(:,24))
  call Hloop_QA_V(ntryL,G0H128(1),wf4(:,5),G0H32(6),m3h4x32(:,34),heltab2x128(:,:,192))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(212)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(193),h0tab(:,193),[96,31],[0,0],2,2,wf4(:,9),wf32(:,2))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,9),G0H32(7),m3h4x32(:,35),heltab2x128(:,:,193))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(213)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(194),h0tab(:,194),[96,31],[0,0],2,2,wf4(:,9),wf32(:,4))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,9),G0H32(8),m3h4x32(:,36),heltab2x128(:,:,194))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(195),h0tab(:,195),[102,25],[0,0],2,2,wf16(:,36),wf8(:,10))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,36),G0H8(1),m3h16x8(:,21),heltab2x128(:,:,195))
  call Hloop_Q_A(ntryL,G0H8(1),102,0,G1H8(60),n2h8(93))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(196),h0tab(:,196),[102,25],[0,0],2,2,wf16(:,37),wf8(:,10))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,37),G0H8(1),m3h16x8(:,22),heltab2x128(:,:,196))
  call Hloop_Q_A(ntryL,G0H8(1),102,0,G1H8(17),n2h8(94))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(214)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(197),h0tab(:,197),[96,31],[0,0],2,2,wf4(:,9),wf32(:,10))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,9),G0H32(9),m3h4x32(:,37),heltab2x128(:,:,197))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(198),h0tab(:,198),[96,31],[0,0],2,2,wf4(:,9),wf32(:,12))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,9),G0H32(10),m3h4x32(:,38),heltab2x128(:,:,198))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(199),h0tab(:,199),[105,22],[0,0],2,2,wf16(:,35),wf8(:,12))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,35),G0H8(1),m3h16x8(:,23),heltab2x128(:,:,199))
  call Hloop_Q_A(ntryL,G0H8(1),105,0,G1H8(33),n2h8(95))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(200),h0tab(:,200),[105,22],[0,0],2,2,wf16(:,35),wf8(:,14))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,35),G0H8(1),m3h16x8(:,24),heltab2x128(:,:,200))
  call Hloop_Q_A(ntryL,G0H8(1),105,0,G1H8(50),n2h8(96))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(201),h0tab(:,201),[96,31],[0,0],2,2,wf4(:,9),wf32(:,18))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(11),m3h4x32(:,39),heltab2x128(:,:,201))
  call Hloop_Q_A(ntryL,G0H32(11),96,0,G1H32(3),n2h32(67))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(202),h0tab(:,202),[96,31],[0,0],2,2,wf4(:,9),wf32(:,20))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(11),m3h4x32(:,40),heltab2x128(:,:,202))
  call Hloop_Q_A(ntryL,G0H32(11),96,0,G1H32(5),n2h32(68))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(203),h0tab(:,203),[89,38],[0,0],2,2,wf16(:,56),wf8(:,4))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,56),G0H8(1),m3h16x8(:,25),heltab2x128(:,:,203))
  call Hloop_A_Q(ntryL,G0H8(1),89,0,G1H8(9),n2h8(97))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(204),h0tab(:,204),[89,38],[0,0],2,2,wf16(:,56),wf8(:,6))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,56),G0H8(1),m3h16x8(:,26),heltab2x128(:,:,204))
  call Hloop_A_Q(ntryL,G0H8(1),89,0,G1H8(7),n2h8(98))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(205),h0tab(:,205),[102,25],[0,0],2,2,wf16(:,51),wf8(:,10))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,51),G0H8(1),m3h16x8(:,27),heltab2x128(:,:,205))
  call Hloop_Q_A(ntryL,G0H8(1),102,0,G1H8(6),n2h8(99))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(206),h0tab(:,206),[102,25],[0,0],2,2,wf16(:,53),wf8(:,10))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,53),G0H8(1),m3h16x8(:,28),heltab2x128(:,:,206))
  call Hloop_Q_A(ntryL,G0H8(1),102,0,G1H8(32),n2h8(100))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(207),h0tab(:,207),[86,41],[0,0],2,2,wf16(:,57),wf8(:,2))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,57),G0H8(1),m3h16x8(:,29),heltab2x128(:,:,207))
  call Hloop_A_Q(ntryL,G0H8(1),86,0,G1H8(13),n2h8(101))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(208),h0tab(:,208),[86,41],[0,0],2,2,wf16(:,58),wf8(:,2))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,58),G0H8(1),m3h16x8(:,30),heltab2x128(:,:,208))
  call Hloop_A_Q(ntryL,G0H8(1),86,0,G1H8(2),n2h8(102))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(120)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(209),h0tab(:,209),[105,22],[0,0],2,2,wf16(:,55),wf8(:,12))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,55),G0H8(1),m3h16x8(:,31),heltab2x128(:,:,209))
  call Hloop_Q_A(ntryL,G0H8(1),105,0,G1H8(1),n2h8(103))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(121)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(210),h0tab(:,210),[105,22],[0,0],2,2,wf16(:,55),wf8(:,14))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,55),G0H8(1),m3h16x8(:,32),heltab2x128(:,:,210))
  call Hloop_Q_A(ntryL,G0H8(1),105,0,G1H8(23),n2h8(104))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(211),h0tab(:,211),[80,47],[0,0],2,2,wf4(:,5),wf32(:,28))
  call Hloop_QA_V(ntryL,G0H128(1),wf4(:,5),G0H32(11),m3h4x32(:,41),heltab2x128(:,:,211))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(212),h0tab(:,212),[80,47],[0,0],2,2,wf4(:,5),wf32(:,34))
  call Hloop_QA_V(ntryL,G0H128(1),wf4(:,5),G0H32(12),m3h4x32(:,42),heltab2x128(:,:,212))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(213),h0tab(:,213),[80,47],[0,0],2,2,wf4(:,5),wf32(:,36))
  call Hloop_QA_V(ntryL,G0H128(1),wf4(:,5),G0H32(13),m3h4x32(:,43),heltab2x128(:,:,213))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(214),h0tab(:,214),[96,31],[0,0],2,2,wf4(:,9),wf32(:,26))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(14),m3h4x32(:,44),heltab2x128(:,:,214))
  call Hloop_Q_A(ntryL,G0H32(14),96,0,G1H32(8),n2h32(69))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(215),h0tab(:,215),[96,31],[0,0],2,2,wf4(:,9),wf32(:,30))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(14),m3h4x32(:,45),heltab2x128(:,:,215))
  call Hloop_Q_A(ntryL,G0H32(14),96,0,G1H32(14),n2h32(70))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(223)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(216),h0tab(:,216),[96,31],[0,0],2,2,wf4(:,9),wf32(:,32))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(14),m3h4x32(:,46),heltab2x128(:,:,216))
  call Hloop_Q_A(ntryL,G0H32(14),96,0,G1H32(20),n2h32(71))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(224)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(217),h0tab(:,217),[80,47],[0,0],2,2,wf4(:,5),wf32(:,40))
  call Hloop_QA_V(ntryL,G0H128(1),wf4(:,5),G0H32(14),m3h4x32(:,47),heltab2x128(:,:,217))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(225)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(218),h0tab(:,218),[96,31],[0,0],2,2,wf4(:,9),wf32(:,38))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(15),m3h4x32(:,48),heltab2x128(:,:,218))
  call Hloop_Q_A(ntryL,G0H32(15),96,0,G1H32(28),n2h32(72))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(2),[G1H8(13),G1H8(46),G1H8(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(9),[G1H8(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(7),[G1H8(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(32),[G1H8(6),G1H8(17),G1H8(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1),[G1H8(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(23),[G1H8(50)])
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(2),wf8(:,2),G1tensor(1),m3h8x1(:,46),heltab2x8(:,:,136))
  call Hloop_VQ_A(ntryL,G0H32(1),wf32(:,6),G0H1(1),m3h32x1(:,21),heltab2x32(:,:,109))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),127,0,G1tensor(31),n2h1(187))
  call Hloop_VQ_A(ntryL,G0H32(2),wf32(:,8),G0H1(1),m3h32x1(:,22),heltab2x32(:,:,110))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),127,0,G1tensor(14),n2h1(188))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(9),wf8(:,4),G1tensor(3),m3h8x1(:,47),heltab2x8(:,:,137))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(7),wf8(:,6),G1tensor(38),m3h8x1(:,48),heltab2x8(:,:,138))
  call Hloop_VQ_A(ntryL,G0H32(3),wf32(:,14),G0H1(1),m3h32x1(:,23),heltab2x32(:,:,111))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),127,0,G1tensor(48),n2h1(189))
  call Hloop_VQ_A(ntryL,G0H32(4),wf32(:,16),G0H1(1),m3h32x1(:,24),heltab2x32(:,:,112))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),127,0,G1tensor(8),n2h1(190))
  call Hloop_VQ_A(ntryL,G0H32(5),wf32(:,22),G0H1(1),m3h32x1(:,25),heltab2x32(:,:,113))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),127,0,G1tensor(17),n2h1(191))
  call Hloop_VQ_A(ntryL,G0H32(6),wf32(:,24),G0H1(1),m3h32x1(:,26),heltab2x32(:,:,114))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),127,0,G1tensor(29),n2h1(192))
  call Hloop_VA_Q(ntryL,G0H32(7),wf32(:,2),G0H1(1),m3h32x1(:,27),heltab2x32(:,:,115))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,0,G1tensor(41),n2h1(193))
  call Hloop_VA_Q(ntryL,G0H32(8),wf32(:,4),G0H1(1),m3h32x1(:,28),heltab2x32(:,:,116))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,0,G1tensor(51),n2h1(194))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H8(32),wf8(:,10),G1tensor(56),m3h8x1(:,49),heltab2x8(:,:,139))
  call Hloop_VA_Q(ntryL,G0H32(9),wf32(:,10),G0H1(1),m3h32x1(:,29),heltab2x32(:,:,117))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,0,G1tensor(61),n2h1(195))
  call Hloop_VA_Q(ntryL,G0H32(10),wf32(:,12),G0H1(1),m3h32x1(:,30),heltab2x32(:,:,118))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,0,G1tensor(66),n2h1(196))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H8(1),wf8(:,12),G1tensor(71),m3h8x1(:,50),heltab2x8(:,:,140))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H8(23),wf8(:,14),G1tensor(76),m3h8x1(:,51),heltab2x8(:,:,141))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H32(3),wf32(:,18),G1tensor(81),m3h32x1(:,31),heltab2x32(:,:,119))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H32(5),wf32(:,20),G1tensor(86),m3h32x1(:,32),heltab2x32(:,:,120))
  call Hloop_VQ_A(ntryL,G0H32(11),wf32(:,28),G0H1(1),m3h32x1(:,33),heltab2x32(:,:,121))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),127,0,G1tensor(91),n2h1(197))
  call Hloop_VQ_A(ntryL,G0H32(12),wf32(:,34),G0H1(1),m3h32x1(:,34),heltab2x32(:,:,122))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),127,0,G1tensor(96),n2h1(198))
  call Hloop_VQ_A(ntryL,G0H32(13),wf32(:,36),G0H1(1),m3h32x1(:,35),heltab2x32(:,:,123))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),127,0,G1tensor(101),n2h1(199))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H32(8),wf32(:,26),G1tensor(106),m3h32x1(:,36),heltab2x32(:,:,124))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H32(14),wf32(:,30),G1tensor(111),m3h32x1(:,37),heltab2x32(:,:,125))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H32(20),wf32(:,32),G1tensor(116),m3h32x1(:,38),heltab2x32(:,:,126))
  call Hloop_VQ_A(ntryL,G0H32(14),wf32(:,40),G0H1(1),m3h32x1(:,39),heltab2x32(:,:,127))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),127,0,G1tensor(121),n2h1(200))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H32(28),wf32(:,38),G1tensor(126),m3h32x1(:,40),heltab2x32(:,:,128))
  call ol_merge_tensors(G0tensor(132),[G0tensor(130),G0tensor(155),G0tensor(52),G0tensor(47),G0tensor(151),G0tensor(66) &
    ,G0tensor(46),G0tensor(31),G0tensor(6)])
  call ol_merge_tensors(G0tensor(134),[G0tensor(138),G0tensor(94),G0tensor(123),G0tensor(97),G0tensor(59),G0tensor(145) &
    ,G0tensor(60),G0tensor(65),G0tensor(32),G0tensor(131),G0tensor(26),G0tensor(11)])
  call ol_merge_tensors(G0tensor(35),[G0tensor(3),G0tensor(37),G0tensor(91),G0tensor(36),G0tensor(16)])
  call ol_merge_tensors(G0tensor(153),[G0tensor(139),G0tensor(98),G0tensor(113),G0tensor(127),G0tensor(33),G0tensor(87) &
    ,G0tensor(159),G0tensor(9),G0tensor(133),G0tensor(51)])
  call ol_merge_tensors(G1tensor(38),[G1tensor(3),G0tensor(167),G0tensor(73),G0tensor(45),G0tensor(50),G0tensor(77) &
    ,G0tensor(56)])
  call ol_merge_tensors(G0tensor(166),[G0tensor(74),G0tensor(124),G0tensor(107),G0tensor(24),G0tensor(83),G0tensor(122) &
    ,G0tensor(15),G0tensor(18),G0tensor(146),G0tensor(126),G0tensor(106),G0tensor(86),G0tensor(71)])
  call ol_merge_tensors(G1tensor(76),[G1tensor(71),G0tensor(163),G0tensor(154),G0tensor(147),G0tensor(34),G0tensor(58) &
    ,G0tensor(19),G0tensor(156),G0tensor(76)])
  call ol_merge_tensors(G1tensor(126),[G1tensor(116),G1tensor(111),G1tensor(106),G1tensor(86),G1tensor(81),G1tensor(66) &
    ,G1tensor(61),G1tensor(51),G1tensor(41),G0tensor(54),G0tensor(142),G0tensor(103),G0tensor(40),G0tensor(150),G0tensor(135) &
    ,G0tensor(96)])
  call ol_merge_tensors(G1tensor(121),[G1tensor(101),G1tensor(96),G1tensor(91),G1tensor(29),G1tensor(17),G1tensor(8),G1tensor(48) &
    ,G1tensor(14),G1tensor(31),G0tensor(84),G0tensor(70),G0tensor(105),G0tensor(20),G0tensor(111)])
  call ol_merge_tensors(G0tensor(164),[G0tensor(129),G0tensor(69),G0tensor(108),G0tensor(28),G0tensor(120),G0tensor(110) &
    ,G0tensor(10),G0tensor(23),G0tensor(22),G0tensor(116)])
  call ol_merge_tensors(G1tensor(56),[G0tensor(79),G0tensor(43),G0tensor(8),G0tensor(48),G0tensor(55),G0tensor(7),G0tensor(128) &
    ,G0tensor(136)])
  call ol_merge_tensors(G0tensor(99),[G0tensor(112),G0tensor(13),G0tensor(38),G0tensor(27),G0tensor(17)])
  call ol_merge_tensors(G0tensor(118),[G0tensor(89),G0tensor(119),G0tensor(95),G0tensor(62),G0tensor(42),G0tensor(12)])
  call ol_merge_tensors(G0tensor(168),[G0tensor(158),G0tensor(144),G0tensor(93),G0tensor(14),G0tensor(75),G0tensor(80)])
  call ol_merge_tensors(G1tensor(1),[G0tensor(162),G0tensor(148),G0tensor(64),G0tensor(102),G0tensor(125),G0tensor(140) &
    ,G0tensor(115)])
call TI_bubble_red(G1tensor(38),89,mass2set(:,1),G0tensor(1),M2L1R1)
call TI_bubble_red(G1tensor(76),105,mass2set(:,1),G0tensor(21),M2L1R1)
call TI_bubble_red(G1tensor(126),96,mass2set(:,1),G0tensor(41),M2L1R1)
call TI_bubble_red(G1tensor(121),80,mass2set(:,1),G0tensor(61),M2L1R1)
call TI_bubble_red(G1tensor(56),102,mass2set(:,1),G0tensor(81),M2L1R1)
call TI_bubble_red(G1tensor(1),86,mass2set(:,1),G0tensor(101),M2L1R1)
  call ol_merge_tensors(T0sum(77),[G0tensor(132)])
  call ol_merge_tensors(T0sum(78),[G0tensor(134)])
  call ol_merge_tensors(T0sum(79),[G0tensor(35)])
  call ol_merge_tensors(T0sum(80),[G0tensor(153)])
  call ol_merge_tensors(T0sum(81),[G0tensor(1)])
  call ol_merge_tensors(T0sum(82),[G0tensor(166)])
  call ol_merge_tensors(T0sum(83),[G0tensor(21)])
  call ol_merge_tensors(T0sum(84),[G0tensor(41)])
  call ol_merge_tensors(T0sum(85),[G0tensor(61)])
  call ol_merge_tensors(T0sum(86),[G0tensor(164)])
  call ol_merge_tensors(T0sum(87),[G0tensor(81)])
  call ol_merge_tensors(T0sum(88),[G0tensor(99)])
  call ol_merge_tensors(T0sum(89),[G0tensor(118)])
  call ol_merge_tensors(T0sum(90),[G0tensor(168)])
  call ol_merge_tensors(T0sum(91),[G0tensor(101)])
  call ol_merge_tensors(T0sum(92),[G0tensor(170)])
  call ol_merge_tensors(T0sum(93),[G0tensor(171)])
  call ol_merge_tensors(T0sum(94),[G0tensor(172)])
  call ol_merge_tensors(T0sum(95),[G0tensor(173)])
  call ol_merge_tensors(T0sum(96),[G0tensor(175)])
  call ol_merge_tensors(T0sum(97),[G0tensor(176)])
  call ol_merge_tensors(T0sum(98),[G0tensor(177)])
  call ol_merge_tensors(T0sum(99),[G0tensor(178)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 80, 89, 95 ],masses2_9,RedSet_4(8),ScalarBoxes(1))
  call compute_scalar_box([ 64, 89, 95 ],masses2_9,RedSet_4(9),ScalarBoxes(2))
  call compute_scalar_box([ 64, 80, 95 ],masses2_9,RedSet_4(1),ScalarBoxes(3))
  call compute_scalar_box([ 64, 80, 89 ],masses2_9,RedSet_4(2),ScalarBoxes(4))
  call compute_scalar_box([ 16, 25, 31 ],masses2_9,RedSet_4(10),ScalarBoxes(5))
  call compute_scalar_box([ 80, 86, 95 ],masses2_9,RedSet_4(11),ScalarBoxes(6))
  call compute_scalar_box([ 64, 86, 95 ],masses2_9,RedSet_4(12),ScalarBoxes(7))
  call compute_scalar_box([ 64, 80, 86 ],masses2_9,RedSet_4(3),ScalarBoxes(8))
  call compute_scalar_box([ 16, 22, 31 ],masses2_9,RedSet_4(13),ScalarBoxes(9))
  call compute_scalar_box([ 70, 79, 111 ],masses2_9,RedSet_4(14),ScalarBoxes(10))
  call compute_scalar_box([ 64, 79, 111 ],masses2_9,RedSet_4(15),ScalarBoxes(11))
  call compute_scalar_box([ 64, 70, 111 ],masses2_9,RedSet_4(16),ScalarBoxes(12))
  call compute_scalar_box([ 64, 70, 79 ],masses2_9,RedSet_4(4),ScalarBoxes(13))
  call compute_scalar_box([ 6, 15, 47 ],masses2_9,RedSet_4(17),ScalarBoxes(14))
  call compute_scalar_box([ 73, 79, 111 ],masses2_9,RedSet_4(18),ScalarBoxes(15))
  call compute_scalar_box([ 64, 73, 111 ],masses2_9,RedSet_4(19),ScalarBoxes(16))
  call compute_scalar_box([ 64, 73, 79 ],masses2_9,RedSet_4(5),ScalarBoxes(17))
  call compute_scalar_box([ 9, 15, 47 ],masses2_9,RedSet_4(20),ScalarBoxes(18))
  call compute_scalar_box([ 70, 79, 95 ],masses2_9,RedSet_4(21),ScalarBoxes(19))
  call compute_scalar_box([ 64, 79, 95 ],masses2_9,RedSet_4(22),ScalarBoxes(20))
  call compute_scalar_box([ 64, 70, 95 ],masses2_9,RedSet_4(23),ScalarBoxes(21))
  call compute_scalar_box([ 6, 15, 31 ],masses2_9,RedSet_4(24),ScalarBoxes(22))
  call compute_scalar_box([ 73, 79, 95 ],masses2_9,RedSet_4(25),ScalarBoxes(23))
  call compute_scalar_box([ 64, 73, 95 ],masses2_9,RedSet_4(26),ScalarBoxes(24))
  call compute_scalar_box([ 9, 15, 31 ],masses2_9,RedSet_4(27),ScalarBoxes(25))
  call compute_scalar_box([ 70, 102, 118 ],masses2_9,RedSet_4(28),ScalarBoxes(26))
  call compute_scalar_box([ 64, 102, 118 ],masses2_9,RedSet_4(29),ScalarBoxes(27))
  call compute_scalar_box([ 64, 70, 118 ],masses2_9,RedSet_4(30),ScalarBoxes(28))
  call compute_scalar_box([ 64, 70, 102 ],masses2_9,RedSet_4(6),ScalarBoxes(29))
  call compute_scalar_box([ 6, 38, 54 ],masses2_9,RedSet_4(31),ScalarBoxes(30))
  call compute_scalar_box([ 70, 86, 118 ],masses2_9,RedSet_4(32),ScalarBoxes(31))
  call compute_scalar_box([ 64, 86, 118 ],masses2_9,RedSet_4(33),ScalarBoxes(32))
  call compute_scalar_box([ 64, 70, 86 ],masses2_9,RedSet_4(7),ScalarBoxes(33))
  call compute_scalar_box([ 6, 22, 54 ],masses2_9,RedSet_4(34),ScalarBoxes(34))
! end of process


end subroutine vamp_1

end module ol_vamp_1_ppllllj_nmeexmxuxdg_1_/**/REALKIND
