
module ol_vamp_1_ppllllj_nenenexnexbbxg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllllj_nenenexnexbbxg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllllj_nenenexnexbbxg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppllllj_nenenexnexbbxg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppllllj_nenenexnexbbxg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppllllj_nenenexnexbbxg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppllllj_nenenexnexbbxg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1),h0tab(:,1),[64,10,5,32,16],[nMB,nMB,nMB,0,nMB],5,2,wf4(:,5),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1),heltab2x128(:,:,1))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(1),n2h64(1))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(2),h0tab(:,2),[64,5,10,32,16],[nMB,nMB,nMB,0,nMB],5,2,wf4(:,4),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,2),heltab2x128(:,:,2))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(2),n2h64(2))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(3),h0tab(:,3),[64,10,5,16,32],[nMB,nMB,nMB,0,nMB],5,2,wf4(:,5),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,3),heltab2x128(:,:,3))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(3),n2h64(3))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(4),h0tab(:,4),[64,5,16,32,10],[nMB,nMB,0,nMB,nMB],5,2,wf4(:,4),wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,4),heltab2x128(:,:,4))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(4),n2h64(4))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(5),h0tab(:,5),[64,5,10,16,32],[nMB,nMB,nMB,0,nMB],5,2,wf4(:,4),wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,5),heltab2x128(:,:,5))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(5),n2h64(5))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(6),h0tab(:,6),[64,5,32,16,10],[nMB,nMB,0,nMB,nMB],5,2,wf4(:,4),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,6),heltab2x128(:,:,6))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(6),n2h64(6))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(7),h0tab(:,7),[64,16,5,10,32],[0,nMB,nMB,nMB,0],5,2,wf4(:,4),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(7),m3h2x64(:,7),heltab2x128(:,:,7))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(8),h0tab(:,8),[64,16,10,5,32],[0,nMB,nMB,nMB,0],5,2,wf4(:,5),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(8),m3h2x64(:,8),heltab2x128(:,:,8))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(9),h0tab(:,9),[64,6,9,32,16],[nMB,nMB,nMB,0,nMB],5,2,wf4(:,12),wf4(:,11))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,9),heltab2x128(:,:,9))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(9),n2h64(7))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(10),h0tab(:,10),[64,9,6,32,16],[nMB,nMB,nMB,0,nMB],5,2,wf4(:,11),wf4(: &
    ,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,10),heltab2x128(:,:,10))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(10),n2h64(8))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(11),h0tab(:,11),[64,6,9,16,32],[nMB,nMB,nMB,0,nMB],5,2,wf4(:,12),wf4(: &
    ,11))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,11),heltab2x128(:,:,11))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(11),n2h64(9))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(12),h0tab(:,12),[64,6,32,16,9],[nMB,nMB,0,nMB,nMB],5,2,wf4(:,12),wf4(: &
    ,11))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,12),heltab2x128(:,:,12))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(12),n2h64(10))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(13),h0tab(:,13),[64,9,6,16,32],[nMB,nMB,nMB,0,nMB],5,2,wf4(:,11),wf4(: &
    ,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,13),heltab2x128(:,:,13))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(13),n2h64(11))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(14),h0tab(:,14),[64,6,16,32,9],[nMB,nMB,0,nMB,nMB],5,2,wf4(:,12),wf4(: &
    ,11))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,14),heltab2x128(:,:,14))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(14),n2h64(12))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(15),h0tab(:,15),[64,16,9,6,32],[0,nMB,nMB,nMB,0],5,2,wf4(:,11),wf4(:,12))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(15),m3h2x64(:,15),heltab2x128(:,:,15))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(16),h0tab(:,16),[64,16,6,9,32],[0,nMB,nMB,nMB,0],5,2,wf4(:,12),wf4(:,11))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(16),m3h2x64(:,16),heltab2x128(:,:,16))
  call Hloop_QZ_A(ntryL,G1H64(1),wf4(:,5),G1H16(1),ngZd,m3h4x16(:,1),heltab2x64(:,:,1))
  call Hloop_Q_A(ntryL,G1H16(1),74,nMB,G2H16(1),n2h16(1))
  call Hloop_QZ_A(ntryL,G1H64(2),wf4(:,4),G1H16(1),ngZd,m3h4x16(:,2),heltab2x64(:,:,2))
  call Hloop_Q_A(ntryL,G1H16(1),69,nMB,G2H16(2),n2h16(2))
  call Hloop_AZ_Q(ntryL,G1H64(3),wf4(:,5),G1H16(1),ngZd,m3h4x16(:,3),heltab2x64(:,:,3))
  call Hloop_A_Q(ntryL,G1H16(1),74,nMB,G2H16(3),n2h16(3))
  call Hloop_AZ_Q(ntryL,G1H64(4),wf4(:,4),G1H16(1),ngZd,m3h4x16(:,4),heltab2x64(:,:,4))
  call Hloop_A_Q(ntryL,G1H16(1),69,nMB,G2H16(4),n2h16(4))
  call Hloop_AZ_Q(ntryL,G1H64(5),wf4(:,4),G1H16(1),ngZd,m3h4x16(:,5),heltab2x64(:,:,5))
  call Hloop_A_Q(ntryL,G1H16(1),69,nMB,G2H16(5),n2h16(5))
  call Hloop_QZ_A(ntryL,G1H64(6),wf4(:,4),G1H16(1),ngZd,m3h4x16(:,6),heltab2x64(:,:,6))
  call Hloop_Q_A(ntryL,G1H16(1),69,nMB,G2H16(6),n2h16(6))
  call Hloop_VQ_A(ntryL,G1H64(7),ex5(:),G1H32(1),m3h2x32(:,1),heltab2x64(:,:,7))
  call Hloop_Q_A(ntryL,G1H32(1),80,nMB,G2H32(1),n2h32(1))
  call Hloop_VQ_A(ntryL,G1H64(8),ex5(:),G1H32(1),m3h2x32(:,2),heltab2x64(:,:,8))
  call Hloop_Q_A(ntryL,G1H32(1),80,nMB,G2H32(2),n2h32(2))
  call Hloop_QZ_A(ntryL,G1H64(9),wf4(:,12),G1H16(1),ngZd,m3h4x16(:,7),heltab2x64(:,:,9))
  call Hloop_Q_A(ntryL,G1H16(1),70,nMB,G2H16(7),n2h16(7))
  call Hloop_QZ_A(ntryL,G1H64(10),wf4(:,11),G1H16(1),ngZd,m3h4x16(:,8),heltab2x64(:,:,10))
  call Hloop_Q_A(ntryL,G1H16(1),73,nMB,G2H16(8),n2h16(8))
  call Hloop_AZ_Q(ntryL,G1H64(11),wf4(:,12),G1H16(1),ngZd,m3h4x16(:,9),heltab2x64(:,:,11))
  call Hloop_A_Q(ntryL,G1H16(1),70,nMB,G2H16(9),n2h16(9))
  call Hloop_QZ_A(ntryL,G1H64(12),wf4(:,12),G1H16(1),ngZd,m3h4x16(:,10),heltab2x64(:,:,12))
  call Hloop_Q_A(ntryL,G1H16(1),70,nMB,G2H16(10),n2h16(10))
  call Hloop_AZ_Q(ntryL,G1H64(13),wf4(:,11),G1H16(1),ngZd,m3h4x16(:,11),heltab2x64(:,:,13))
  call Hloop_A_Q(ntryL,G1H16(1),73,nMB,G2H16(11),n2h16(11))
  call Hloop_AZ_Q(ntryL,G1H64(14),wf4(:,12),G1H16(1),ngZd,m3h4x16(:,12),heltab2x64(:,:,14))
  call Hloop_A_Q(ntryL,G1H16(1),70,nMB,G2H16(12),n2h16(12))
  call Hloop_VQ_A(ntryL,G1H64(15),ex5(:),G1H32(1),m3h2x32(:,3),heltab2x64(:,:,15))
  call Hloop_Q_A(ntryL,G1H32(1),80,nMB,G2H32(3),n2h32(3))
  call Hloop_VQ_A(ntryL,G1H64(16),ex5(:),G1H32(1),m3h2x32(:,4),heltab2x64(:,:,16))
  call Hloop_Q_A(ntryL,G1H32(1),80,nMB,G2H32(4),n2h32(4))
  call Hotf_5pt_reduction(G2H16(1),RedSet_5(1),mass5set(:,1),  & 
G1H16(1),G1H16(2),G1H16(3),G1H16(4),G1H16(5),G1H16(6),16)
  call HG1shiftOLR(G1H16(2),16,16)
  call Hotf_5pt_reduction(G2H16(2),RedSet_5(2),mass5set(:,1),  & 
G1H16(7),G1H16(8),G1H16(9),G1H16(10),G1H16(11),G1H16(12),16)
  call HG1shiftOLR(G1H16(8),16,16)
  call Hotf_5pt_reduction(G2H16(3),RedSet_5(3),mass5set(:,1),  & 
G1H16(13),G1H16(14),G1H16(15),G1H16(16),G1H16(17),G1H16(18),16)
  call HG1shiftOLR(G1H16(14),32,16)
  call Hloop_AQ_V(ntryL,G2H16(4),ex5(:),G2H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hotf_5pt_reduction(G2H16(5),RedSet_5(4),mass5set(:,1),  & 
G1H16(19),G1H16(20),G1H16(21),G1H16(22),G1H16(23),G1H16(24),16)
  call HG1shiftOLR(G1H16(20),32,16)
  call Hloop_QA_V(ntryL,G2H16(6),ex6(:),G2H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hotf_5pt_reduction(G2H32(1),RedSet_5(5),mass5set(:,2),  & 
G1H32(1),G1H32(2),G1H32(3),G1H32(4),G1H32(5),G1H32(6),32)
  call HG1shiftOLR(G1H32(2),32,32)
  call Hotf_5pt_reduction(G2H32(2),RedSet_5(6),mass5set(:,2),  & 
G1H32(7),G1H32(8),G1H32(9),G1H32(10),G1H32(11),G1H32(12),32)
  call HG1shiftOLR(G1H32(8),32,32)
  call Hotf_5pt_reduction(G2H16(7),RedSet_5(7),mass5set(:,1),  & 
G1H16(25),G1H16(26),G1H16(27),G1H16(28),G1H16(29),G1H16(30),16)
  call HG1shiftOLR(G1H16(26),16,16)
  call Hotf_5pt_reduction(G2H16(8),RedSet_5(8),mass5set(:,1),  & 
G1H16(31),G1H16(32),G1H16(33),G1H16(34),G1H16(35),G1H16(36),16)
  call HG1shiftOLR(G1H16(32),16,16)
  call Hotf_5pt_reduction(G2H16(9),RedSet_5(9),mass5set(:,1),  & 
G1H16(37),G1H16(38),G1H16(39),G1H16(40),G1H16(41),G1H16(42),16)
  call HG1shiftOLR(G1H16(38),32,16)
  call Hloop_QA_V(ntryL,G2H16(10),ex6(:),G2H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hotf_5pt_reduction(G2H16(11),RedSet_5(10),mass5set(:,1),  & 
G1H16(43),G1H16(44),G1H16(45),G1H16(46),G1H16(47),G1H16(48),16)
  call HG1shiftOLR(G1H16(44),32,16)
  call Hloop_AQ_V(ntryL,G2H16(12),ex5(:),G2H8(4),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hotf_5pt_reduction(G2H32(3),RedSet_5(11),mass5set(:,2),  & 
G1H32(13),G1H32(14),G1H32(15),G1H32(16),G1H32(17),G1H32(18),32)
  call HG1shiftOLR(G1H32(14),32,32)
  call Hotf_5pt_reduction(G2H32(4),RedSet_5(12),mass5set(:,2),  & 
G1H32(19),G1H32(20),G1H32(21),G1H32(22),G1H32(23),G1H32(24),32)
  call HG1shiftOLR(G1H32(20),32,32)
  call Hloop_QZ_A(ntryL,G1H16(1),wf4(:,4),G1H4(1),ngZd,m3h4x4(:,1),heltab2x16(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(1),n2h4(1))
call HGT_OLR(G1H16(2),1,1,16)
call HGT_invQ_OLR(G1H16(2),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(2),-16,nMB,G2H16(1),n2h16(13))
  call Hloop_AQ_V(ntryL,G2H16(1),ex5(:),G2H8(5),m3h2x8(:,5),heltab2x16(:,:,6))
  call Hloop_QZ_A(ntryL,G1H16(4),wf4(:,4),G1H4(1),ngZd,m3h4x4(:,2),heltab2x16(:,:,7))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(2),n2h4(2))
  call Hloop_QZ_A(ntryL,G1H16(5),wf4(:,4),G1H4(1),ngZd,m3h4x4(:,3),heltab2x16(:,:,8))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(3),n2h4(3))
  call Hloop_QZ_A(ntryL,G1H16(6),wf4(:,4),G1H4(1),ngZd,m3h4x4(:,4),heltab2x16(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(4),n2h4(4))
  call Hloop_QZ_A(ntryL,G1H16(7),wf4(:,5),G1H4(1),ngZd,m3h4x4(:,5),heltab2x16(:,:,10))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(5),n2h4(5))
call HGT_OLR(G1H16(8),1,1,16)
call HGT_invQ_OLR(G1H16(8),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(8),-16,nMB,G2H16(2),n2h16(14))
  call Hloop_AQ_V(ntryL,G2H16(2),ex5(:),G2H8(6),m3h2x8(:,6),heltab2x16(:,:,11))
  call Hloop_QZ_A(ntryL,G1H16(10),wf4(:,5),G1H4(1),ngZd,m3h4x4(:,6),heltab2x16(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(6),n2h4(6))
  call Hloop_QZ_A(ntryL,G1H16(11),wf4(:,5),G1H4(1),ngZd,m3h4x4(:,7),heltab2x16(:,:,13))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(7),n2h4(7))
  call Hloop_QZ_A(ntryL,G1H16(12),wf4(:,5),G1H4(1),ngZd,m3h4x4(:,8),heltab2x16(:,:,14))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(8),n2h4(8))
  call Hloop_AZ_Q(ntryL,G1H16(13),wf4(:,4),G1H4(1),ngZd,m3h4x4(:,9),heltab2x16(:,:,15))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(9),n2h4(9))
call HGT_OLR(G1H16(14),1,1,16)
call HGT_invQ_OLR(G1H16(14),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(14),-32,nMB,G2H16(3),n2h16(15))
  call Hloop_QA_V(ntryL,G2H16(3),ex6(:),G2H8(7),m3h2x8(:,7),heltab2x16(:,:,16))
  call Hloop_AZ_Q(ntryL,G1H16(16),wf4(:,4),G1H4(1),ngZd,m3h4x4(:,10),heltab2x16(:,:,17))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(10),n2h4(10))
  call Hloop_AZ_Q(ntryL,G1H16(17),wf4(:,4),G1H4(1),ngZd,m3h4x4(:,11),heltab2x16(:,:,18))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(11),n2h4(11))
  call Hloop_AZ_Q(ntryL,G1H16(18),wf4(:,4),G1H4(1),ngZd,m3h4x4(:,12),heltab2x16(:,:,19))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(12),n2h4(12))
  call Hloop_AZ_Q(ntryL,G1H16(19),wf4(:,5),G1H4(1),ngZd,m3h4x4(:,13),heltab2x16(:,:,20))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(13),n2h4(13))
call HGT_OLR(G1H16(20),1,1,16)
call HGT_invQ_OLR(G1H16(20),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(20),-32,nMB,G2H16(4),n2h16(16))
  call Hloop_QA_V(ntryL,G2H16(4),ex6(:),G2H8(8),m3h2x8(:,8),heltab2x16(:,:,21))
  call Hloop_AZ_Q(ntryL,G1H16(22),wf4(:,5),G1H4(1),ngZd,m3h4x4(:,14),heltab2x16(:,:,22))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(14),n2h4(14))
  call Hloop_AZ_Q(ntryL,G1H16(23),wf4(:,5),G1H4(1),ngZd,m3h4x4(:,15),heltab2x16(:,:,23))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(15),n2h4(15))
  call Hloop_AZ_Q(ntryL,G1H16(24),wf4(:,5),G1H4(1),ngZd,m3h4x4(:,16),heltab2x16(:,:,24))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(16),n2h4(16))
  call Hloop_QZ_A(ntryL,G1H32(1),wf4(:,4),G1H8(1),ngZd,m3h4x8(:,1),heltab2x32(:,:,1))
  call Hloop_Q_A(ntryL,G1H8(1),85,nMB,G2H8(9),n2h8(1))
call HGT_raise_alpha_OLR(G1H32(2),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(2),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(2),ex6(:),G1H16(1),m3h2x16(:,1),heltab2x32(:,:,2))
  call Hloop_QZ_A(ntryL,G1H32(4),wf4(:,4),G1H8(1),ngZd,m3h4x8(:,2),heltab2x32(:,:,3))
  call Hloop_Q_A(ntryL,G1H8(1),85,nMB,G2H8(10),n2h8(2))
  call Hloop_QZ_A(ntryL,G1H32(5),wf4(:,4),G1H8(1),ngZd,m3h4x8(:,3),heltab2x32(:,:,4))
  call Hloop_Q_A(ntryL,G1H8(1),85,nMB,G2H8(11),n2h8(3))
  call Hloop_QZ_A(ntryL,G1H32(6),wf4(:,4),G1H8(1),ngZd,m3h4x8(:,4),heltab2x32(:,:,5))
  call Hloop_Q_A(ntryL,G1H8(1),85,nMB,G2H8(12),n2h8(4))
  call Hloop_QZ_A(ntryL,G1H32(7),wf4(:,5),G1H8(1),ngZd,m3h4x8(:,5),heltab2x32(:,:,6))
  call Hloop_Q_A(ntryL,G1H8(1),90,nMB,G2H8(13),n2h8(5))
call HGT_raise_alpha_OLR(G1H32(8),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(8),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(8),ex6(:),G1H16(2),m3h2x16(:,2),heltab2x32(:,:,7))
  call Hloop_QZ_A(ntryL,G1H32(10),wf4(:,5),G1H8(1),ngZd,m3h4x8(:,6),heltab2x32(:,:,8))
  call Hloop_Q_A(ntryL,G1H8(1),90,nMB,G2H8(14),n2h8(6))
  call Hloop_QZ_A(ntryL,G1H32(11),wf4(:,5),G1H8(1),ngZd,m3h4x8(:,7),heltab2x32(:,:,9))
  call Hloop_Q_A(ntryL,G1H8(1),90,nMB,G2H8(15),n2h8(7))
  call Hloop_QZ_A(ntryL,G1H32(12),wf4(:,5),G1H8(1),ngZd,m3h4x8(:,8),heltab2x32(:,:,10))
  call Hloop_Q_A(ntryL,G1H8(1),90,nMB,G2H8(16),n2h8(8))
  call Hloop_QZ_A(ntryL,G1H16(25),wf4(:,11),G1H4(1),ngZd,m3h4x4(:,17),heltab2x16(:,:,25))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(17),n2h4(17))
call HGT_OLR(G1H16(26),1,1,16)
call HGT_invQ_OLR(G1H16(26),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(26),-16,nMB,G2H16(5),n2h16(17))
  call Hloop_AQ_V(ntryL,G2H16(5),ex5(:),G2H8(17),m3h2x8(:,9),heltab2x16(:,:,26))
  call Hloop_QZ_A(ntryL,G1H16(28),wf4(:,11),G1H4(1),ngZd,m3h4x4(:,18),heltab2x16(:,:,27))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(18),n2h4(18))
  call Hloop_QZ_A(ntryL,G1H16(29),wf4(:,11),G1H4(1),ngZd,m3h4x4(:,19),heltab2x16(:,:,28))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(19),n2h4(19))
  call Hloop_QZ_A(ntryL,G1H16(30),wf4(:,11),G1H4(1),ngZd,m3h4x4(:,20),heltab2x16(:,:,29))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(20),n2h4(20))
  call Hloop_QZ_A(ntryL,G1H16(31),wf4(:,12),G1H4(1),ngZd,m3h4x4(:,21),heltab2x16(:,:,30))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(21),n2h4(21))
call HGT_OLR(G1H16(32),1,1,16)
call HGT_invQ_OLR(G1H16(32),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(32),-16,nMB,G2H16(6),n2h16(18))
  call Hloop_AQ_V(ntryL,G2H16(6),ex5(:),G2H8(18),m3h2x8(:,10),heltab2x16(:,:,31))
  call Hloop_QZ_A(ntryL,G1H16(34),wf4(:,12),G1H4(1),ngZd,m3h4x4(:,22),heltab2x16(:,:,32))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(22),n2h4(22))
  call Hloop_QZ_A(ntryL,G1H16(35),wf4(:,12),G1H4(1),ngZd,m3h4x4(:,23),heltab2x16(:,:,33))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(23),n2h4(23))
  call Hloop_QZ_A(ntryL,G1H16(36),wf4(:,12),G1H4(1),ngZd,m3h4x4(:,24),heltab2x16(:,:,34))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(24),n2h4(24))
  call Hloop_AZ_Q(ntryL,G1H16(37),wf4(:,11),G1H4(1),ngZd,m3h4x4(:,25),heltab2x16(:,:,35))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(25),n2h4(25))
call HGT_OLR(G1H16(38),1,1,16)
call HGT_invQ_OLR(G1H16(38),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(38),-32,nMB,G2H16(7),n2h16(19))
  call Hloop_QA_V(ntryL,G2H16(7),ex6(:),G2H8(19),m3h2x8(:,11),heltab2x16(:,:,36))
  call Hloop_AZ_Q(ntryL,G1H16(40),wf4(:,11),G1H4(1),ngZd,m3h4x4(:,26),heltab2x16(:,:,37))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(26),n2h4(26))
  call Hloop_AZ_Q(ntryL,G1H16(41),wf4(:,11),G1H4(1),ngZd,m3h4x4(:,27),heltab2x16(:,:,38))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(27),n2h4(27))
  call Hloop_AZ_Q(ntryL,G1H16(42),wf4(:,11),G1H4(1),ngZd,m3h4x4(:,28),heltab2x16(:,:,39))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(28),n2h4(28))
  call Hloop_AZ_Q(ntryL,G1H16(43),wf4(:,12),G1H4(1),ngZd,m3h4x4(:,29),heltab2x16(:,:,40))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(29),n2h4(29))
call HGT_OLR(G1H16(44),1,1,16)
call HGT_invQ_OLR(G1H16(44),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(44),-32,nMB,G2H16(8),n2h16(20))
  call Hloop_QA_V(ntryL,G2H16(8),ex6(:),G2H8(20),m3h2x8(:,12),heltab2x16(:,:,41))
  call Hloop_AZ_Q(ntryL,G1H16(46),wf4(:,12),G1H4(1),ngZd,m3h4x4(:,30),heltab2x16(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(30),n2h4(30))
  call Hloop_AZ_Q(ntryL,G1H16(47),wf4(:,12),G1H4(1),ngZd,m3h4x4(:,31),heltab2x16(:,:,43))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(31),n2h4(31))
  call Hloop_AZ_Q(ntryL,G1H16(48),wf4(:,12),G1H4(1),ngZd,m3h4x4(:,32),heltab2x16(:,:,44))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(32),n2h4(32))
  call Hloop_QZ_A(ntryL,G1H32(13),wf4(:,11),G1H8(1),ngZd,m3h4x8(:,9),heltab2x32(:,:,11))
  call Hloop_Q_A(ntryL,G1H8(1),89,nMB,G2H8(21),n2h8(9))
call HGT_raise_alpha_OLR(G1H32(14),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(14),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(14),ex6(:),G1H16(4),m3h2x16(:,3),heltab2x32(:,:,12))
  call Hloop_QZ_A(ntryL,G1H32(16),wf4(:,11),G1H8(1),ngZd,m3h4x8(:,10),heltab2x32(:,:,13))
  call Hloop_Q_A(ntryL,G1H8(1),89,nMB,G2H8(22),n2h8(10))
  call Hloop_QZ_A(ntryL,G1H32(17),wf4(:,11),G1H8(1),ngZd,m3h4x8(:,11),heltab2x32(:,:,14))
  call Hloop_Q_A(ntryL,G1H8(1),89,nMB,G2H8(23),n2h8(11))
  call Hloop_QZ_A(ntryL,G1H32(18),wf4(:,11),G1H8(1),ngZd,m3h4x8(:,12),heltab2x32(:,:,15))
  call Hloop_Q_A(ntryL,G1H8(1),89,nMB,G2H8(24),n2h8(12))
  call Hloop_QZ_A(ntryL,G1H32(19),wf4(:,12),G1H8(1),ngZd,m3h4x8(:,13),heltab2x32(:,:,16))
  call Hloop_Q_A(ntryL,G1H8(1),86,nMB,G2H8(25),n2h8(13))
call HGT_raise_alpha_OLR(G1H32(20),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(20),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(20),ex6(:),G1H16(5),m3h2x16(:,4),heltab2x32(:,:,17))
  call Hloop_QZ_A(ntryL,G1H32(22),wf4(:,12),G1H8(1),ngZd,m3h4x8(:,14),heltab2x32(:,:,18))
  call Hloop_Q_A(ntryL,G1H8(1),86,nMB,G2H8(26),n2h8(14))
  call Hloop_QZ_A(ntryL,G1H32(23),wf4(:,12),G1H8(1),ngZd,m3h4x8(:,15),heltab2x32(:,:,19))
  call Hloop_Q_A(ntryL,G1H8(1),86,nMB,G2H8(27),n2h8(15))
  call Hloop_QZ_A(ntryL,G1H32(24),wf4(:,12),G1H8(1),ngZd,m3h4x8(:,16),heltab2x32(:,:,20))
  call Hloop_Q_A(ntryL,G1H8(1),86,nMB,G2H8(28),n2h8(16))
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(13),mass5set(:,3),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),G1H8(6),8)
  call HG1shiftOLR(G1H8(2),10,8)
  call Hotf_5pt_reduction(G2H8(2),RedSet_5(14),mass5set(:,3),  & 
G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),G1H8(12),8)
  call HG1shiftOLR(G1H8(8),10,8)
  call Hotf_5pt_reduction(G2H8(3),RedSet_5(15),mass5set(:,3),  & 
G1H8(13),G1H8(14),G1H8(15),G1H8(16),G1H8(17),G1H8(18),8)
  call HG1shiftOLR(G1H8(14),9,8)
  call Hotf_5pt_reduction(G2H8(4),RedSet_5(16),mass5set(:,3),  & 
G1H8(19),G1H8(20),G1H8(21),G1H8(22),G1H8(23),G1H8(24),8)
  call HG1shiftOLR(G1H8(20),9,8)
  call Hloop_QA_V(ntryL,G2H4(1),ex6(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_V(ntryL,G2H4(3),ex6(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_V(ntryL,G2H4(4),ex6(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_V(ntryL,G2H4(5),ex6(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_QA_V(ntryL,G2H4(7),ex6(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QA_V(ntryL,G2H4(8),ex6(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_AQ_V(ntryL,G2H4(9),ex5(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_V(ntryL,G2H4(11),ex5(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_AQ_V(ntryL,G2H4(12),ex5(:),G2H2(9),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_AQ_V(ntryL,G2H4(13),ex5(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_AQ_V(ntryL,G2H4(15),ex5(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_AQ_V(ntryL,G2H4(16),ex5(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(5),mass5set(:,2),  & 
G1H8(25),G1H8(26),G1H8(27),G1H8(28),G1H8(29),G1H8(30),8)
  call HG1shiftOLR(G1H8(26),32,8)
  call Hotf_4pt_reduction(G2H8(11),RedSet_4(1),mass4set(:,1),  & 
G1H8(31),G1H8(32),G1H8(33),G1H8(34),G1H8(35),8)
  call HG1shiftOLR(G1H8(32),32,8)
  call Hotf_4pt_reduction(G2H8(12),RedSet_4(2),mass4set(:,1),  & 
G1H8(36),G1H8(37),G1H8(38),G1H8(39),G1H8(40),8)
  call HG1shiftOLR(G1H8(37),42,8)
  call Hotf_5pt_reduction(G2H8(13),RedSet_5(6),mass5set(:,2),  & 
G1H8(41),G1H8(42),G1H8(43),G1H8(44),G1H8(45),G1H8(46),8)
  call HG1shiftOLR(G1H8(42),32,8)
  call Hotf_4pt_reduction(G2H8(15),RedSet_4(1),mass4set(:,1),  & 
G1H8(47),G1H8(48),G1H8(49),G1H8(50),G1H8(51),8)
  call HG1shiftOLR(G1H8(48),32,8)
  call Hotf_4pt_reduction(G2H8(16),RedSet_4(3),mass4set(:,1),  & 
G1H8(52),G1H8(53),G1H8(54),G1H8(55),G1H8(56),8)
  call HG1shiftOLR(G1H8(53),37,8)
  call Hloop_QA_V(ntryL,G2H4(17),ex6(:),G2H2(13),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_QA_V(ntryL,G2H4(19),ex6(:),G2H2(14),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_QA_V(ntryL,G2H4(20),ex6(:),G2H2(15),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_QA_V(ntryL,G2H4(21),ex6(:),G2H2(16),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_QA_V(ntryL,G2H4(23),ex6(:),G2H2(17),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_QA_V(ntryL,G2H4(24),ex6(:),G2H2(18),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_AQ_V(ntryL,G2H4(25),ex5(:),G2H2(19),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_AQ_V(ntryL,G2H4(27),ex5(:),G2H2(20),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_AQ_V(ntryL,G2H4(28),ex5(:),G2H2(21),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_AQ_V(ntryL,G2H4(29),ex5(:),G2H2(22),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_AQ_V(ntryL,G2H4(31),ex5(:),G2H2(23),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_AQ_V(ntryL,G2H4(32),ex5(:),G2H2(24),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hotf_5pt_reduction(G2H8(21),RedSet_5(11),mass5set(:,2),  & 
G1H8(57),G1H8(58),G1H8(59),G1H8(60),G1H8(61),G1H8(62),8)
  call HG1shiftOLR(G1H8(58),32,8)
  call Hotf_4pt_reduction(G2H8(23),RedSet_4(1),mass4set(:,1),  & 
G1H8(63),G1H8(64),G1H8(65),G1H8(66),G1H8(67),8)
  call HG1shiftOLR(G1H8(64),32,8)
  call Hotf_4pt_reduction(G2H8(24),RedSet_4(4),mass4set(:,1),  & 
G1H8(68),G1H8(69),G1H8(70),G1H8(71),G1H8(72),8)
  call HG1shiftOLR(G1H8(69),38,8)
  call Hotf_5pt_reduction(G2H8(25),RedSet_5(12),mass5set(:,2),  & 
G1H8(73),G1H8(74),G1H8(75),G1H8(76),G1H8(77),G1H8(78),8)
  call HG1shiftOLR(G1H8(74),32,8)
  call Hotf_4pt_reduction(G2H8(27),RedSet_4(1),mass4set(:,1),  & 
G1H8(79),G1H8(80),G1H8(81),G1H8(82),G1H8(83),8)
  call HG1shiftOLR(G1H8(80),32,8)
  call Hotf_4pt_reduction(G2H8(28),RedSet_4(5),mass4set(:,1),  & 
G1H8(84),G1H8(85),G1H8(86),G1H8(87),G1H8(88),8)
  call HG1shiftOLR(G1H8(85),41,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(31),[G1H8(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(36),[G1H8(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(47),[G1H8(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(52),[G1H8(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(63),[G1H8(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(68),[G1H8(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(79),[G1H8(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(84),[G1H8(78)])
  call Hloop_VA_Q(ntryL,G1H8(1),ex6(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_A_Q(ntryL,G1H4(1),117,nMB,G2H4(1),n2h4(33))
call HGT_OLR(G1H8(2),1,1,8)
call HGT_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(2),-10,nMB,G2H8(1),n2h8(17))
  call Hloop_QZ_A(ntryL,G2H8(1),wf4(:,5),G2H2(25),ngZd,m3h4x2(:,1),heltab2x8(:,:,2))
  call Hloop_VA_Q(ntryL,G1H8(5),ex6(:),G1H4(1),m3h2x4(:,2),heltab2x8(:,:,3))
  call Hloop_A_Q(ntryL,G1H4(1),117,nMB,G2H4(3),n2h4(34))
  call Hloop_VA_Q(ntryL,G1H8(6),ex6(:),G1H4(1),m3h2x4(:,3),heltab2x8(:,:,4))
  call Hloop_A_Q(ntryL,G1H4(1),117,nMB,G2H4(4),n2h4(35))
  call Hloop_VQ_A(ntryL,G1H8(7),ex5(:),G1H4(1),m3h2x4(:,4),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(1),117,nMB,G2H4(5),n2h4(36))
call HGT_OLR(G1H8(8),1,1,8)
call HGT_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(8),-10,nMB,G2H8(2),n2h8(18))
  call Hloop_AZ_Q(ntryL,G2H8(2),wf4(:,5),G2H2(26),ngZd,m3h4x2(:,2),heltab2x8(:,:,6))
  call Hloop_VQ_A(ntryL,G1H8(11),ex5(:),G1H4(1),m3h2x4(:,5),heltab2x8(:,:,7))
  call Hloop_Q_A(ntryL,G1H4(1),117,nMB,G2H4(7),n2h4(37))
  call Hloop_VQ_A(ntryL,G1H8(12),ex5(:),G1H4(1),m3h2x4(:,6),heltab2x8(:,:,8))
  call Hloop_Q_A(ntryL,G1H4(1),117,nMB,G2H4(8),n2h4(38))
  call Hloop_VQ_A(ntryL,G1H8(13),ex5(:),G1H4(1),m3h2x4(:,7),heltab2x8(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(1),118,nMB,G2H4(9),n2h4(39))
call HGT_OLR(G1H8(14),1,1,8)
call HGT_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(14),-9,nMB,G2H8(3),n2h8(19))
  call Hloop_AZ_Q(ntryL,G2H8(3),wf4(:,11),G2H2(27),ngZd,m3h4x2(:,3),heltab2x8(:,:,10))
  call Hloop_VQ_A(ntryL,G1H8(17),ex5(:),G1H4(1),m3h2x4(:,8),heltab2x8(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(1),118,nMB,G2H4(11),n2h4(40))
  call Hloop_VQ_A(ntryL,G1H8(18),ex5(:),G1H4(1),m3h2x4(:,9),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(1),118,nMB,G2H4(12),n2h4(41))
  call Hloop_VA_Q(ntryL,G1H8(19),ex6(:),G1H4(1),m3h2x4(:,10),heltab2x8(:,:,13))
  call Hloop_A_Q(ntryL,G1H4(1),118,nMB,G2H4(13),n2h4(42))
call HGT_OLR(G1H8(20),1,1,8)
call HGT_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(20),-9,nMB,G2H8(4),n2h8(20))
  call Hloop_QZ_A(ntryL,G2H8(4),wf4(:,11),G2H2(28),ngZd,m3h4x2(:,4),heltab2x8(:,:,14))
  call Hloop_VA_Q(ntryL,G1H8(23),ex6(:),G1H4(1),m3h2x4(:,11),heltab2x8(:,:,15))
  call Hloop_A_Q(ntryL,G1H4(1),118,nMB,G2H4(15),n2h4(43))
  call Hloop_VA_Q(ntryL,G1H8(24),ex6(:),G1H4(1),m3h2x4(:,12),heltab2x8(:,:,16))
  call Hloop_A_Q(ntryL,G1H4(1),118,nMB,G2H4(16),n2h4(44))
  call Hloop_QZ_A(ntryL,G1H8(25),wf4(:,5),G1H2(1),ngZd,m3h4x2(:,5),heltab2x8(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(29),n2h2(1))
call HGT_raise_alpha_OLR(G1H8(26),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(26),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(26),ex6(:),G1H4(1),m3h2x4(:,13),heltab2x8(:,:,18))
  call Hloop_QZ_A(ntryL,G1H8(31),wf4(:,5),G1H2(1),ngZd,m3h4x2(:,6),heltab2x8(:,:,19))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(30),n2h2(2))
  call Hloop_QZ_A(ntryL,G1H8(36),wf4(:,5),G1H2(1),ngZd,m3h4x2(:,7),heltab2x8(:,:,20))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(31),n2h2(3))
call HGT_raise_alpha_OLR(G1H8(32),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(32),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(32),ex6(:),G1H4(2),m3h2x4(:,14),heltab2x8(:,:,21))
  call Hloop_QZ_A(ntryL,G1H8(35),wf4(:,5),G1H2(1),ngZd,m3h4x2(:,8),heltab2x8(:,:,22))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(32),n2h2(4))
call HGT_raise_alpha_OLR(G1H8(37),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(37),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(37),ex6(:),G1H4(3),m3h2x4(:,15),heltab2x8(:,:,23))
  call Hloop_QZ_A(ntryL,G1H8(40),wf4(:,5),G1H2(1),ngZd,m3h4x2(:,9),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(33),n2h2(5))
  call Hloop_QZ_A(ntryL,G1H8(41),wf4(:,4),G1H2(1),ngZd,m3h4x2(:,10),heltab2x8(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(34),n2h2(6))
call HGT_raise_alpha_OLR(G1H8(42),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(42),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(42),ex6(:),G1H4(4),m3h2x4(:,16),heltab2x8(:,:,26))
  call Hloop_QZ_A(ntryL,G1H8(47),wf4(:,4),G1H2(1),ngZd,m3h4x2(:,11),heltab2x8(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(35),n2h2(7))
  call Hloop_QZ_A(ntryL,G1H8(52),wf4(:,4),G1H2(1),ngZd,m3h4x2(:,12),heltab2x8(:,:,28))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(36),n2h2(8))
call HGT_raise_alpha_OLR(G1H8(48),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(48),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(48),ex6(:),G1H4(5),m3h2x4(:,17),heltab2x8(:,:,29))
  call Hloop_QZ_A(ntryL,G1H8(51),wf4(:,4),G1H2(1),ngZd,m3h4x2(:,13),heltab2x8(:,:,30))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(37),n2h2(9))
call HGT_raise_alpha_OLR(G1H8(53),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(53),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(53),ex6(:),G1H4(6),m3h2x4(:,18),heltab2x8(:,:,31))
  call Hloop_QZ_A(ntryL,G1H8(56),wf4(:,4),G1H2(1),ngZd,m3h4x2(:,14),heltab2x8(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(38),n2h2(10))
  call Hloop_QZ_A(ntryL,G1H8(57),wf4(:,12),G1H2(1),ngZd,m3h4x2(:,15),heltab2x8(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(39),n2h2(11))
call HGT_raise_alpha_OLR(G1H8(58),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(58),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(58),ex6(:),G1H4(7),m3h2x4(:,19),heltab2x8(:,:,34))
  call Hloop_QZ_A(ntryL,G1H8(63),wf4(:,12),G1H2(1),ngZd,m3h4x2(:,16),heltab2x8(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(40),n2h2(12))
  call Hloop_QZ_A(ntryL,G1H8(68),wf4(:,12),G1H2(1),ngZd,m3h4x2(:,17),heltab2x8(:,:,36))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(41),n2h2(13))
call HGT_raise_alpha_OLR(G1H8(64),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(64),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(64),ex6(:),G1H4(8),m3h2x4(:,20),heltab2x8(:,:,37))
  call Hloop_QZ_A(ntryL,G1H8(67),wf4(:,12),G1H2(1),ngZd,m3h4x2(:,18),heltab2x8(:,:,38))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(42),n2h2(14))
call HGT_raise_alpha_OLR(G1H8(69),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(69),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(69),ex6(:),G1H4(9),m3h2x4(:,21),heltab2x8(:,:,39))
  call Hloop_QZ_A(ntryL,G1H8(72),wf4(:,12),G1H2(1),ngZd,m3h4x2(:,19),heltab2x8(:,:,40))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(43),n2h2(15))
  call Hloop_QZ_A(ntryL,G1H8(73),wf4(:,11),G1H2(1),ngZd,m3h4x2(:,20),heltab2x8(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(44),n2h2(16))
call HGT_raise_alpha_OLR(G1H8(74),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(74),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(74),ex6(:),G1H4(10),m3h2x4(:,22),heltab2x8(:,:,42))
  call Hloop_QZ_A(ntryL,G1H8(79),wf4(:,11),G1H2(1),ngZd,m3h4x2(:,21),heltab2x8(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(45),n2h2(17))
  call Hloop_QZ_A(ntryL,G1H8(84),wf4(:,11),G1H2(1),ngZd,m3h4x2(:,22),heltab2x8(:,:,44))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(46),n2h2(18))
call HGT_raise_alpha_OLR(G1H8(80),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(80),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(80),ex6(:),G1H4(11),m3h2x4(:,23),heltab2x8(:,:,45))
  call Hloop_QZ_A(ntryL,G1H8(83),wf4(:,11),G1H2(1),ngZd,m3h4x2(:,23),heltab2x8(:,:,46))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(47),n2h2(19))
call HGT_raise_alpha_OLR(G1H8(85),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(85),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(85),ex6(:),G1H4(12),m3h2x4(:,24),heltab2x8(:,:,47))
  call Hloop_QZ_A(ntryL,G1H8(88),wf4(:,11),G1H2(1),ngZd,m3h4x2(:,24),heltab2x8(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(48),n2h2(20))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(2),16,2)
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(6),mass4set(:,2),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),2)
  call HG1shiftOLR(G1H2(8),48,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(2),mass5set(:,1),  & 
G1H2(12),G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),2)
  call HG1shiftOLR(G1H2(13),16,2)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(7),mass4set(:,2),  & 
G1H2(18),G1H2(19),G1H2(20),G1H2(21),G1H2(22),2)
  call HG1shiftOLR(G1H2(19),48,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(3),mass5set(:,1),  & 
G1H2(23),G1H2(24),G1H2(25),G1H2(26),G1H2(27),G1H2(28),2)
  call HG1shiftOLR(G1H2(24),32,2)
  call Hotf_4pt_reduction(G2H2(9),RedSet_4(6),mass4set(:,2),  & 
G1H2(29),G1H2(30),G1H2(31),G1H2(32),G1H2(33),2)
  call HG1shiftOLR(G1H2(30),48,2)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(4),mass5set(:,1),  & 
G1H2(34),G1H2(35),G1H2(36),G1H2(37),G1H2(38),G1H2(39),2)
  call HG1shiftOLR(G1H2(35),32,2)
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(7),mass4set(:,2),  & 
G1H2(40),G1H2(41),G1H2(42),G1H2(43),G1H2(44),2)
  call HG1shiftOLR(G1H2(41),48,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(7),mass5set(:,1),  & 
G1H2(45),G1H2(46),G1H2(47),G1H2(48),G1H2(49),G1H2(50),2)
  call HG1shiftOLR(G1H2(46),16,2)
  call Hotf_4pt_reduction(G2H2(15),RedSet_4(8),mass4set(:,2),  & 
G1H2(51),G1H2(52),G1H2(53),G1H2(54),G1H2(55),2)
  call HG1shiftOLR(G1H2(52),48,2)
  call Hotf_5pt_reduction(G2H2(16),RedSet_5(8),mass5set(:,1),  & 
G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),G1H2(61),2)
  call HG1shiftOLR(G1H2(57),16,2)
  call Hotf_4pt_reduction(G2H2(18),RedSet_4(9),mass4set(:,2),  & 
G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(63),48,2)
  call Hotf_5pt_reduction(G2H2(19),RedSet_5(9),mass5set(:,1),  & 
G1H2(67),G1H2(68),G1H2(69),G1H2(70),G1H2(71),G1H2(72),2)
  call HG1shiftOLR(G1H2(68),32,2)
  call Hotf_4pt_reduction(G2H2(21),RedSet_4(8),mass4set(:,2),  & 
G1H2(73),G1H2(74),G1H2(75),G1H2(76),G1H2(77),2)
  call HG1shiftOLR(G1H2(74),48,2)
  call Hotf_5pt_reduction(G2H2(22),RedSet_5(10),mass5set(:,1),  & 
G1H2(78),G1H2(79),G1H2(80),G1H2(81),G1H2(82),G1H2(83),2)
  call HG1shiftOLR(G1H2(79),32,2)
  call Hotf_4pt_reduction(G2H2(24),RedSet_4(9),mass4set(:,2),  & 
G1H2(84),G1H2(85),G1H2(86),G1H2(87),G1H2(88),2)
  call HG1shiftOLR(G1H2(85),48,2)
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(13),mass5set(:,3),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(14),10,4)
  call Hotf_4pt_reduction(G2H4(4),RedSet_4(10),mass4set(:,3),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),4)
  call HG1shiftOLR(G1H4(20),42,4)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(14),mass5set(:,3),  & 
G1H4(24),G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),4)
  call HG1shiftOLR(G1H4(25),10,4)
  call Hotf_4pt_reduction(G2H4(8),RedSet_4(11),mass4set(:,3),  & 
G1H4(30),G1H4(31),G1H4(32),G1H4(33),G1H4(34),4)
  call HG1shiftOLR(G1H4(31),26,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(15),mass5set(:,3),  & 
G1H4(35),G1H4(36),G1H4(37),G1H4(38),G1H4(39),G1H4(40),4)
  call HG1shiftOLR(G1H4(36),9,4)
  call Hotf_4pt_reduction(G2H4(12),RedSet_4(12),mass4set(:,3),  & 
G1H4(41),G1H4(42),G1H4(43),G1H4(44),G1H4(45),4)
  call HG1shiftOLR(G1H4(42),25,4)
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(16),mass5set(:,3),  & 
G1H4(46),G1H4(47),G1H4(48),G1H4(49),G1H4(50),G1H4(51),4)
  call HG1shiftOLR(G1H4(47),9,4)
  call Hotf_4pt_reduction(G2H4(16),RedSet_4(13),mass4set(:,3),  & 
G1H4(52),G1H4(53),G1H4(54),G1H4(55),G1H4(56),4)
  call HG1shiftOLR(G1H4(53),41,4)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(29),ex6(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(31),ex6(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(34),ex6(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(36),ex6(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(39),ex6(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(41),ex6(:),G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(44),ex6(:),G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(46),ex6(:),G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(7),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(18),[G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(29),[G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(40),[G1H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(51),[G1H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(62),[G1H2(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(73),[G1H2(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(84),[G1H2(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(19),[G1H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(30),[G1H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(41),[G1H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(52),[G1H4(51)])
  call Hloop_VQ_A(ntryL,G1H2(1),ex5(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(9),n2h1(1))
  call Hloop_VQ_A(ntryL,G1H2(2),ex5(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(10),n2h1(2))
  call Hloop_VQ_A(ntryL,G1H2(7),ex5(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(11),n2h1(3))
  call Hloop_VQ_A(ntryL,G1H2(8),ex5(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,nMB,G2tensor(12),n2h1(4))
  call Hloop_VQ_A(ntryL,G1H2(12),ex5(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(13),n2h1(5))
  call Hloop_VQ_A(ntryL,G1H2(13),ex5(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(14),n2h1(6))
  call Hloop_VQ_A(ntryL,G1H2(18),ex5(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(15),n2h1(7))
  call Hloop_VQ_A(ntryL,G1H2(19),ex5(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,nMB,G2tensor(16),n2h1(8))
  call Hloop_VA_Q(ntryL,G1H2(23),ex6(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(17),n2h1(9))
  call Hloop_VA_Q(ntryL,G1H2(24),ex6(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,nMB,G2tensor(18),n2h1(10))
  call Hloop_VA_Q(ntryL,G1H2(29),ex6(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(19),n2h1(11))
  call Hloop_VA_Q(ntryL,G1H2(30),ex6(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,nMB,G2tensor(20),n2h1(12))
  call Hloop_VA_Q(ntryL,G1H2(34),ex6(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(21),n2h1(13))
  call Hloop_VA_Q(ntryL,G1H2(35),ex6(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,nMB,G2tensor(22),n2h1(14))
  call Hloop_VA_Q(ntryL,G1H2(40),ex6(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(23),n2h1(15))
  call Hloop_VA_Q(ntryL,G1H2(41),ex6(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,nMB,G2tensor(24),n2h1(16))
  call Hloop_VQ_A(ntryL,G1H2(45),ex5(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(25),n2h1(17))
  call Hloop_VQ_A(ntryL,G1H2(46),ex5(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(26),n2h1(18))
  call Hloop_VQ_A(ntryL,G1H2(51),ex5(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(27),n2h1(19))
  call Hloop_VQ_A(ntryL,G1H2(52),ex5(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,nMB,G2tensor(28),n2h1(20))
  call Hloop_VQ_A(ntryL,G1H2(56),ex5(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(29),n2h1(21))
  call Hloop_VQ_A(ntryL,G1H2(57),ex5(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(30),n2h1(22))
  call Hloop_VQ_A(ntryL,G1H2(62),ex5(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(31),n2h1(23))
  call Hloop_VQ_A(ntryL,G1H2(63),ex5(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,nMB,G2tensor(32),n2h1(24))
  call Hloop_VA_Q(ntryL,G1H2(67),ex6(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(33),n2h1(25))
  call Hloop_VA_Q(ntryL,G1H2(68),ex6(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,nMB,G2tensor(34),n2h1(26))
  call Hloop_VA_Q(ntryL,G1H2(73),ex6(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(35),n2h1(27))
  call Hloop_VA_Q(ntryL,G1H2(74),ex6(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,nMB,G2tensor(36),n2h1(28))
  call Hloop_VA_Q(ntryL,G1H2(78),ex6(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(37),n2h1(29))
  call Hloop_VA_Q(ntryL,G1H2(79),ex6(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,nMB,G2tensor(38),n2h1(30))
  call Hloop_VA_Q(ntryL,G1H2(84),ex6(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(39),n2h1(31))
  call Hloop_VA_Q(ntryL,G1H2(85),ex6(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,nMB,G2tensor(40),n2h1(32))
  call Hloop_AZ_Q(ntryL,G1H4(13),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,1),heltab2x4(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(41),n2h1(33))
  call Hloop_AZ_Q(ntryL,G1H4(14),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,2),heltab2x4(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(42),n2h1(34))
  call Hloop_AZ_Q(ntryL,G1H4(19),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,3),heltab2x4(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(43),n2h1(35))
  call Hloop_AZ_Q(ntryL,G1H4(20),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,4),heltab2x4(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),42,nMB,G2tensor(44),n2h1(36))
  call Hloop_QZ_A(ntryL,G1H4(24),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,5),heltab2x4(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(45),n2h1(37))
  call Hloop_QZ_A(ntryL,G1H4(25),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,6),heltab2x4(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(46),n2h1(38))
  call Hloop_QZ_A(ntryL,G1H4(30),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,7),heltab2x4(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(47),n2h1(39))
  call Hloop_QZ_A(ntryL,G1H4(31),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,8),heltab2x4(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),26,nMB,G2tensor(48),n2h1(40))
  call Hloop_QZ_A(ntryL,G1H4(35),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,9),heltab2x4(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(49),n2h1(41))
  call Hloop_QZ_A(ntryL,G1H4(36),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,10),heltab2x4(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(50),n2h1(42))
  call Hloop_QZ_A(ntryL,G1H4(41),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,11),heltab2x4(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(51),n2h1(43))
  call Hloop_QZ_A(ntryL,G1H4(42),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,12),heltab2x4(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),25,nMB,G2tensor(52),n2h1(44))
  call Hloop_AZ_Q(ntryL,G1H4(46),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,13),heltab2x4(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(53),n2h1(45))
  call Hloop_AZ_Q(ntryL,G1H4(47),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,14),heltab2x4(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(54),n2h1(46))
  call Hloop_AZ_Q(ntryL,G1H4(52),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,15),heltab2x4(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(55),n2h1(47))
  call Hloop_AZ_Q(ntryL,G1H4(53),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,16),heltab2x4(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),41,nMB,G2tensor(56),n2h1(48))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(5),mass5set(:,2),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),32)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(6),mass5set(:,2),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),32)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(11),mass5set(:,2),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),32)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(12),mass5set(:,2),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),32)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(1),mass5set(:,1),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),16)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(2),mass5set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),16)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(3),mass5set(:,1),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),32)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(4),mass5set(:,1),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),32)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(7),mass5set(:,1),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),16)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(8),mass5set(:,1),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),16)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(9),mass5set(:,1),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),32)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(10),mass5set(:,1),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),32)
  call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(13),mass5set(:,3),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),10)
  call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(14),mass5set(:,3),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),10)
  call Hotf_5pt_reduction_last(G2tensor(49),RedSet_5(15),mass5set(:,3),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),9)
  call Hotf_5pt_reduction_last(G2tensor(53),RedSet_5(16),mass5set(:,3),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),9)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(17),h0tab(:,17),[64,5,48,10],[0,0,0,0],4,3,wf4(:,4),wf4(:,13),wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,17),heltab2x128(:,:,17))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(1),n2h64(13))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(18),h0tab(:,18),[64,5,48,10],[nMT,nMT,nMT,nMT],4,3,wf4(:,4),wf4(:,13) &
    ,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,18),heltab2x128(:,:,18))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(2),n2h64(14))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(19),h0tab(:,19),[64,5,48,10],[0,0,0,0],4,3,wf4(:,4),wf4(:,13),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,19),heltab2x128(:,:,19))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(3),n2h64(15))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(20),h0tab(:,20),[64,5,48,10],[nMT,nMT,nMT,nMT],4,3,wf4(:,4),wf4(:,13) &
    ,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,20),heltab2x128(:,:,20))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(4),n2h64(16))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(21),h0tab(:,21),[64,5,48,10],[0,0,0,0],4,3,wf4(:,4),wf4(:,13),wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,21),heltab2x128(:,:,21))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(5),n2h64(17))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(22),h0tab(:,22),[64,5,48,10],[nMB,nMB,nMB,nMB],4,3,wf4(:,4),wf4(:,13) &
    ,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,22),heltab2x128(:,:,22))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(6),n2h64(18))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(23),h0tab(:,23),[64,5,48,10],[0,0,0,0],4,3,wf4(:,4),wf4(:,13),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,23),heltab2x128(:,:,23))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(7),n2h64(19))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(24),h0tab(:,24),[64,5,48,10],[nMB,nMB,nMB,nMB],4,3,wf4(:,4),wf4(:,13) &
    ,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,24),heltab2x128(:,:,24))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(8),n2h64(20))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(25),h0tab(:,25),[64,5,10,48],[0,0,0,0],4,3,wf4(:,4),wf4(:,5),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,25),heltab2x128(:,:,25))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(9),n2h64(21))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(26),h0tab(:,26),[64,5,10,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,4),wf4(:,5),wf4(: &
    ,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,26),heltab2x128(:,:,26))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(10),n2h64(22))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(27),h0tab(:,27),[64,5,10,48],[0,0,0,0],4,3,wf4(:,4),wf4(:,5),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,27),heltab2x128(:,:,27))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(11),n2h64(23))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(28),h0tab(:,28),[64,5,10,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,4),wf4(:,5),wf4(: &
    ,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,28),heltab2x128(:,:,28))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(12),n2h64(24))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(29),h0tab(:,29),[64,5,10,48],[0,0,0,0],4,3,wf4(:,4),wf4(:,5),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,29),heltab2x128(:,:,29))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(13),n2h64(25))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(30),h0tab(:,30),[64,5,10,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,4),wf4(:,5),wf4(: &
    ,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,30),heltab2x128(:,:,30))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(14),n2h64(26))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(31),h0tab(:,31),[64,5,10,48],[0,0,0,0],4,3,wf4(:,4),wf4(:,5),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,31),heltab2x128(:,:,31))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(15),n2h64(27))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(32),h0tab(:,32),[64,5,10,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,4),wf4(:,5),wf4(: &
    ,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,32),heltab2x128(:,:,32))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(16),n2h64(28))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(33),h0tab(:,33),[64,10,5,48],[0,0,0,0],4,3,wf4(:,5),wf4(:,4),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,33),heltab2x128(:,:,33))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(17),n2h64(29))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(34),h0tab(:,34),[64,10,5,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,5),wf4(:,4),wf4(: &
    ,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,34),heltab2x128(:,:,34))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(18),n2h64(30))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(35),h0tab(:,35),[64,10,5,48],[0,0,0,0],4,3,wf4(:,5),wf4(:,4),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,35),heltab2x128(:,:,35))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(19),n2h64(31))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(36),h0tab(:,36),[64,10,5,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,5),wf4(:,4),wf4(: &
    ,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,36),heltab2x128(:,:,36))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(20),n2h64(32))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(37),h0tab(:,37),[64,10,5,48],[0,0,0,0],4,3,wf4(:,5),wf4(:,4),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,37),heltab2x128(:,:,37))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(21),n2h64(33))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(38),h0tab(:,38),[64,10,5,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,5),wf4(:,4),wf4(: &
    ,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,38),heltab2x128(:,:,38))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(22),n2h64(34))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(39),h0tab(:,39),[64,10,5,48],[0,0,0,0],4,3,wf4(:,5),wf4(:,4),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,39),heltab2x128(:,:,39))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(23),n2h64(35))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(40),h0tab(:,40),[64,10,5,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,5),wf4(:,4),wf4(: &
    ,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,40),heltab2x128(:,:,40))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(24),n2h64(36))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(41),h0tab(:,41),[80,10,5,32],[nMB,nMB,nMB,0],4,3,wf4(:,6),wf4(:,5),wf4(: &
    ,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,6),G0H32(1),m3h4x32(:,1),heltab2x128(:,:,41))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(1),n2h32(9))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(42),h0tab(:,42),[80,5,10,32],[nMB,nMB,nMB,0],4,3,wf4(:,6),wf4(:,4),wf4(: &
    ,5))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,6),G0H32(1),m3h4x32(:,2),heltab2x128(:,:,42))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(2),n2h32(10))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(43),h0tab(:,43),[96,10,5,16],[nMB,nMB,nMB,0],4,3,wf4(:,8),wf4(:,5),wf4(: &
    ,4))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(1),m3h4x32(:,3),heltab2x128(:,:,43))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(4),n2h32(11))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(44),h0tab(:,44),[96,5,10,16],[nMB,nMB,nMB,0],4,3,wf4(:,8),wf4(:,4),wf4(: &
    ,5))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(1),m3h4x32(:,4),heltab2x128(:,:,44))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(5),n2h32(12))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(45),h0tab(:,45),[64,21,10,32],[0,nMB,nMB,0],4,2,wf8(:,7),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(25),m3h2x64(:,41),heltab2x128(:,:,45))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(46),h0tab(:,46),[64,10,21,32],[nMB,nMB,0,nMB],4,2,wf4(:,5),wf8(:,7))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,42),heltab2x128(:,:,46))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(26),n2h64(37))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(47),h0tab(:,47),[64,10,32,21],[nMB,nMB,0,nMB],4,2,wf4(:,5),wf8(:,7))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,43),heltab2x128(:,:,47))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(27),n2h64(38))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(48),h0tab(:,48),[64,16,10,37],[0,nMB,nMB,0],4,2,wf4(:,5),wf8(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(28),m3h2x64(:,44),heltab2x128(:,:,48))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(49),h0tab(:,49),[64,10,37,16],[nMB,nMB,0,nMB],4,2,wf4(:,5),wf8(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,45),heltab2x128(:,:,49))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(29),n2h64(39))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(50),h0tab(:,50),[64,10,16,37],[nMB,nMB,0,nMB],4,2,wf4(:,5),wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,46),heltab2x128(:,:,50))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(30),n2h64(40))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(226)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(51),h0tab(:,51),[64,26,5,32],[0,nMB,nMB,0],4,2,wf8(:,9),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(31),m3h2x64(:,47),heltab2x128(:,:,51))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(226)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(52),h0tab(:,52),[64,5,26,32],[nMB,nMB,0,nMB],4,2,wf4(:,4),wf8(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,48),heltab2x128(:,:,52))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(32),n2h64(41))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(226)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(53),h0tab(:,53),[64,5,32,26],[nMB,nMB,0,nMB],4,2,wf4(:,4),wf8(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,49),heltab2x128(:,:,53))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(33),n2h64(42))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(229)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(54),h0tab(:,54),[64,16,5,42],[0,nMB,nMB,0],4,2,wf4(:,4),wf8(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(34),m3h2x64(:,50),heltab2x128(:,:,54))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(229)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(55),h0tab(:,55),[64,5,42,16],[nMB,nMB,0,nMB],4,2,wf4(:,4),wf8(:,4))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,51),heltab2x128(:,:,55))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(35),n2h64(43))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(229)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(56),h0tab(:,56),[64,5,16,42],[nMB,nMB,0,nMB],4,2,wf4(:,4),wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,52),heltab2x128(:,:,56))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(36),n2h64(44))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(87)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(57),h0tab(:,57),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,3))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,53),heltab2x128(:,:,57))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(37),n2h64(45))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(87)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(58),h0tab(:,58),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,3))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,54),heltab2x128(:,:,58))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(38),n2h64(46))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(87)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(59),h0tab(:,59),[64,16,15,32],[0,nMB,nMB,0],4,1,wf16(:,3))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(39),m3h2x64(:,55),heltab2x128(:,:,59))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(169)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(60),h0tab(:,60),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,73))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,56),heltab2x128(:,:,60))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(40),n2h64(47))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(169)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(61),h0tab(:,61),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,73))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,57),heltab2x128(:,:,61))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(41),n2h64(48))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(169)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(62),h0tab(:,62),[64,16,15,32],[0,nMB,nMB,0],4,1,wf16(:,73))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(42),m3h2x64(:,58),heltab2x128(:,:,62))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(171)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(63),h0tab(:,63),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,74))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,59),heltab2x128(:,:,63))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(43),n2h64(49))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(171)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(64),h0tab(:,64),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,74))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,60),heltab2x128(:,:,64))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(44),n2h64(50))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(171)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(65),h0tab(:,65),[64,16,15,32],[0,nMB,nMB,0],4,1,wf16(:,74))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(45),m3h2x64(:,61),heltab2x128(:,:,65))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(286)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(66),h0tab(:,66),[64,6,48,9],[0,0,0,0],4,3,wf4(:,12),wf4(:,13),wf4(:,11))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,62),heltab2x128(:,:,66))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(46),n2h64(51))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(286)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(67),h0tab(:,67),[64,6,48,9],[nMT,nMT,nMT,nMT],4,3,wf4(:,12),wf4(:,13) &
    ,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,63),heltab2x128(:,:,67))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(47),n2h64(52))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(286)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(68),h0tab(:,68),[64,6,48,9],[0,0,0,0],4,3,wf4(:,12),wf4(:,13),wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,64),heltab2x128(:,:,68))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(48),n2h64(53))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(286)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(69),h0tab(:,69),[64,6,48,9],[nMT,nMT,nMT,nMT],4,3,wf4(:,12),wf4(:,13) &
    ,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,65),heltab2x128(:,:,69))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(49),n2h64(54))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(286)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(70),h0tab(:,70),[64,6,48,9],[0,0,0,0],4,3,wf4(:,12),wf4(:,13),wf4(:,11))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,66),heltab2x128(:,:,70))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(50),n2h64(55))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(286)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(71),h0tab(:,71),[64,6,48,9],[nMB,nMB,nMB,nMB],4,3,wf4(:,12),wf4(:,13) &
    ,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,67),heltab2x128(:,:,71))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(51),n2h64(56))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(286)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(72),h0tab(:,72),[64,6,48,9],[0,0,0,0],4,3,wf4(:,12),wf4(:,13),wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,68),heltab2x128(:,:,72))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(52),n2h64(57))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(286)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(73),h0tab(:,73),[64,6,48,9],[nMB,nMB,nMB,nMB],4,3,wf4(:,12),wf4(:,13) &
    ,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,69),heltab2x128(:,:,73))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(53),n2h64(58))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(286)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(74),h0tab(:,74),[64,9,6,48],[0,0,0,0],4,3,wf4(:,11),wf4(:,12),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,70),heltab2x128(:,:,74))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(54),n2h64(59))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(286)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(75),h0tab(:,75),[64,9,6,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,11),wf4(:,12) &
    ,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,71),heltab2x128(:,:,75))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(55),n2h64(60))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(286)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(76),h0tab(:,76),[64,9,6,48],[0,0,0,0],4,3,wf4(:,11),wf4(:,12),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,72),heltab2x128(:,:,76))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(56),n2h64(61))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(286)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(77),h0tab(:,77),[64,9,6,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,11),wf4(:,12) &
    ,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,73),heltab2x128(:,:,77))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(57),n2h64(62))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(286)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(78),h0tab(:,78),[64,9,6,48],[0,0,0,0],4,3,wf4(:,11),wf4(:,12),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,74),heltab2x128(:,:,78))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(58),n2h64(63))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(286)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(79),h0tab(:,79),[64,9,6,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,11),wf4(:,12) &
    ,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,75),heltab2x128(:,:,79))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(59),n2h64(64))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(286)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(80),h0tab(:,80),[64,9,6,48],[0,0,0,0],4,3,wf4(:,11),wf4(:,12),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,76),heltab2x128(:,:,80))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(60),n2h64(65))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(286)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(81),h0tab(:,81),[64,9,6,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,11),wf4(:,12) &
    ,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,77),heltab2x128(:,:,81))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(61),n2h64(66))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(286)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(82),h0tab(:,82),[64,6,9,48],[0,0,0,0],4,3,wf4(:,12),wf4(:,11),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,78),heltab2x128(:,:,82))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(62),n2h64(67))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(286)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(83),h0tab(:,83),[64,6,9,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,12),wf4(:,11) &
    ,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,79),heltab2x128(:,:,83))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(63),n2h64(68))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(286)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(84),h0tab(:,84),[64,6,9,48],[0,0,0,0],4,3,wf4(:,12),wf4(:,11),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,80),heltab2x128(:,:,84))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(64),n2h64(69))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(286)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(85),h0tab(:,85),[64,6,9,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,12),wf4(:,11) &
    ,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,81),heltab2x128(:,:,85))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(65),n2h64(70))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(286)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(86),h0tab(:,86),[64,6,9,48],[0,0,0,0],4,3,wf4(:,12),wf4(:,11),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,82),heltab2x128(:,:,86))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(66),n2h64(71))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(286)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(87),h0tab(:,87),[64,6,9,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,12),wf4(:,11) &
    ,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,83),heltab2x128(:,:,87))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(67),n2h64(72))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(286)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(88),h0tab(:,88),[64,6,9,48],[0,0,0,0],4,3,wf4(:,12),wf4(:,11),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,84),heltab2x128(:,:,88))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(68),n2h64(73))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(286)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(89),h0tab(:,89),[64,6,9,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,12),wf4(:,11) &
    ,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,85),heltab2x128(:,:,89))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(69),n2h64(74))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(289)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(90),h0tab(:,90),[80,6,9,32],[nMB,nMB,nMB,0],4,3,wf4(:,6),wf4(:,12),wf4(: &
    ,11))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,6),G0H32(1),m3h4x32(:,5),heltab2x128(:,:,90))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(6),n2h32(13))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(289)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(91),h0tab(:,91),[80,9,6,32],[nMB,nMB,nMB,0],4,3,wf4(:,6),wf4(:,11),wf4(: &
    ,12))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,6),G0H32(1),m3h4x32(:,6),heltab2x128(:,:,91))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(7),n2h32(14))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(292)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(92),h0tab(:,92),[96,6,9,16],[nMB,nMB,nMB,0],4,3,wf4(:,8),wf4(:,12),wf4(: &
    ,11))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(1),m3h4x32(:,7),heltab2x128(:,:,92))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(8),n2h32(15))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(292)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(93),h0tab(:,93),[96,9,6,16],[nMB,nMB,nMB,0],4,3,wf4(:,8),wf4(:,11),wf4(: &
    ,12))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(1),m3h4x32(:,8),heltab2x128(:,:,93))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(10),n2h32(16))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(239)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(94),h0tab(:,94),[64,25,6,32],[0,nMB,nMB,0],4,2,wf8(:,24),wf4(:,12))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(70),m3h2x64(:,86),heltab2x128(:,:,94))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(239)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(95),h0tab(:,95),[64,6,25,32],[nMB,nMB,0,nMB],4,2,wf4(:,12),wf8(:,24))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,87),heltab2x128(:,:,95))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(71),n2h64(75))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(239)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(96),h0tab(:,96),[64,6,32,25],[nMB,nMB,0,nMB],4,2,wf4(:,12),wf8(:,24))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,88),heltab2x128(:,:,96))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(72),n2h64(76))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(242)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(97),h0tab(:,97),[64,16,6,41],[0,nMB,nMB,0],4,2,wf4(:,12),wf8(:,20))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(73),m3h2x64(:,89),heltab2x128(:,:,97))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(242)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(98),h0tab(:,98),[64,6,41,16],[nMB,nMB,0,nMB],4,2,wf4(:,12),wf8(:,20))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,90),heltab2x128(:,:,98))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(74),n2h64(77))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(242)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(99),h0tab(:,99),[64,6,16,41],[nMB,nMB,0,nMB],4,2,wf4(:,12),wf8(:,20))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,91),heltab2x128(:,:,99))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(75),n2h64(78))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(246)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(100),h0tab(:,100),[64,22,9,32],[0,nMB,nMB,0],4,2,wf8(:,26),wf4(:,11))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(76),m3h2x64(:,92),heltab2x128(:,:,100))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(246)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(101),h0tab(:,101),[64,9,22,32],[nMB,nMB,0,nMB],4,2,wf4(:,11),wf8(:,26))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,93),heltab2x128(:,:,101))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(77),n2h64(79))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(246)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(102),h0tab(:,102),[64,9,32,22],[nMB,nMB,0,nMB],4,2,wf4(:,11),wf8(:,26))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,94),heltab2x128(:,:,102))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(78),n2h64(80))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(249)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(103),h0tab(:,103),[64,16,9,38],[0,nMB,nMB,0],4,2,wf4(:,11),wf8(:,22))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(79),m3h2x64(:,95),heltab2x128(:,:,103))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(249)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(104),h0tab(:,104),[64,9,38,16],[nMB,nMB,0,nMB],4,2,wf4(:,11),wf8(:,22))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,96),heltab2x128(:,:,104))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(80),n2h64(81))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(249)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(105),h0tab(:,105),[64,9,16,38],[nMB,nMB,0,nMB],4,2,wf4(:,11),wf8(:,22))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,97),heltab2x128(:,:,105))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(81),n2h64(82))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(106),h0tab(:,106),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,98),heltab2x128(:,:,106))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(82),n2h64(83))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(107),h0tab(:,107),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,99),heltab2x128(:,:,107))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(83),n2h64(84))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(108),h0tab(:,108),[64,16,15,32],[0,nMB,nMB,0],4,1,wf16(:,12))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(84),m3h2x64(:,100),heltab2x128(:,:,108))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(197)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(109),h0tab(:,109),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,85))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,101),heltab2x128(:,:,109))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(85),n2h64(85))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(197)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(110),h0tab(:,110),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,85))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,102),heltab2x128(:,:,110))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(86),n2h64(86))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(197)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(111),h0tab(:,111),[64,16,15,32],[0,nMB,nMB,0],4,1,wf16(:,85))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(87),m3h2x64(:,103),heltab2x128(:,:,111))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(199)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(112),h0tab(:,112),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,86))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,104),heltab2x128(:,:,112))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(88),n2h64(87))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(199)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(113),h0tab(:,113),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,86))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,105),heltab2x128(:,:,113))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(89),n2h64(88))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(199)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(114),h0tab(:,114),[64,16,15,32],[0,nMB,nMB,0],4,1,wf16(:,86))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(90),m3h2x64(:,106),heltab2x128(:,:,114))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(203)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(115),h0tab(:,115),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,87))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,107),heltab2x128(:,:,115))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(91),n2h64(89))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(203)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(116),h0tab(:,116),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,87))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,108),heltab2x128(:,:,116))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(92),n2h64(90))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(203)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(117),h0tab(:,117),[64,16,15,32],[0,nMB,nMB,0],4,1,wf16(:,87))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(93),m3h2x64(:,109),heltab2x128(:,:,117))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(205)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(118),h0tab(:,118),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,88))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,110),heltab2x128(:,:,118))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(94),n2h64(91))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(205)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(119),h0tab(:,119),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,88))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,111),heltab2x128(:,:,119))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(95),n2h64(92))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(205)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(120),h0tab(:,120),[64,16,15,32],[0,nMB,nMB,0],4,1,wf16(:,88))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(96),m3h2x64(:,112),heltab2x128(:,:,120))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(209)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(121),h0tab(:,121),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,89))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,113),heltab2x128(:,:,121))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(97),n2h64(93))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(209)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(122),h0tab(:,122),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,89))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,114),heltab2x128(:,:,122))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(98),n2h64(94))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(209)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(123),h0tab(:,123),[64,16,15,32],[0,nMB,nMB,0],4,1,wf16(:,89))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(99),m3h2x64(:,115),heltab2x128(:,:,123))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(211)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(124),h0tab(:,124),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,90))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,116),heltab2x128(:,:,124))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(100),n2h64(95))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(211)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(125),h0tab(:,125),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,90))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,117),heltab2x128(:,:,125))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(101),n2h64(96))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(211)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(126),h0tab(:,126),[64,16,15,32],[0,nMB,nMB,0],4,1,wf16(:,90))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(102),m3h2x64(:,118),heltab2x128(:,:,126))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(2),[G1H32(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(1),[G1H32(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(7),[G1H32(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(6),[G1H32(21)])
  call Hloop_QZ_A(ntryL,G1H16(3),wf4(:,4),G1H4(18),ngZd,m3h4x4(:,33),heltab2x16(:,:,45))
  call Hloop_Q_A(ntryL,G1H4(18),79,nMB,G2H4(17),n2h4(45))
  call Hloop_QZ_A(ntryL,G1H16(9),wf4(:,5),G1H4(29),ngZd,m3h4x4(:,34),heltab2x16(:,:,46))
  call Hloop_Q_A(ntryL,G1H4(29),79,nMB,G2H4(19),n2h4(46))
  call Hloop_AZ_Q(ntryL,G1H16(15),wf4(:,4),G1H4(40),ngZd,m3h4x4(:,35),heltab2x16(:,:,47))
  call Hloop_A_Q(ntryL,G1H4(40),79,nMB,G2H4(20),n2h4(47))
  call Hloop_AZ_Q(ntryL,G1H16(21),wf4(:,5),G1H4(51),ngZd,m3h4x4(:,36),heltab2x16(:,:,48))
  call Hloop_A_Q(ntryL,G1H4(51),79,nMB,G2H4(21),n2h4(48))
  call Hloop_QZ_A(ntryL,G1H32(2),wf4(:,4),G1H8(29),ngZd,m3h4x8(:,17),heltab2x32(:,:,21))
  call Hloop_Q_A(ntryL,G1H8(29),85,nMB,G2H8(9),n2h8(33))
  call Hloop_QZ_A(ntryL,G1H32(1),wf4(:,5),G1H8(30),ngZd,m3h4x8(:,18),heltab2x32(:,:,22))
  call Hloop_Q_A(ntryL,G1H8(30),90,nMB,G2H8(11),n2h8(34))
  call Hloop_QZ_A(ntryL,G1H16(27),wf4(:,11),G1H4(13),ngZd,m3h4x4(:,37),heltab2x16(:,:,49))
  call Hloop_Q_A(ntryL,G1H4(13),79,nMB,G2H4(23),n2h4(49))
  call Hloop_QZ_A(ntryL,G1H16(33),wf4(:,12),G1H4(14),ngZd,m3h4x4(:,38),heltab2x16(:,:,50))
  call Hloop_Q_A(ntryL,G1H4(14),79,nMB,G2H4(24),n2h4(50))
  call Hloop_AZ_Q(ntryL,G1H16(39),wf4(:,11),G1H4(19),ngZd,m3h4x4(:,39),heltab2x16(:,:,51))
  call Hloop_A_Q(ntryL,G1H4(19),79,nMB,G2H4(25),n2h4(51))
  call Hloop_AZ_Q(ntryL,G1H16(45),wf4(:,12),G1H4(20),ngZd,m3h4x4(:,40),heltab2x16(:,:,52))
  call Hloop_A_Q(ntryL,G1H4(20),79,nMB,G2H4(27),n2h4(52))
  call Hloop_QZ_A(ntryL,G1H32(7),wf4(:,11),G1H8(45),ngZd,m3h4x8(:,19),heltab2x32(:,:,23))
  call Hloop_Q_A(ntryL,G1H8(45),89,nMB,G2H8(12),n2h8(35))
  call Hloop_QZ_A(ntryL,G1H32(6),wf4(:,12),G1H8(46),ngZd,m3h4x8(:,20),heltab2x32(:,:,24))
  call Hloop_Q_A(ntryL,G1H8(46),86,nMB,G2H8(13),n2h8(36))
  call Hloop_AZ_Q(ntryL,G1H64(1),wf4(:,4),G1H16(6),ngZu,m3h4x16(:,13),heltab2x64(:,:,17))
  call Hloop_A_Q(ntryL,G1H16(6),69,0,G2H16(9),n2h16(21))
  call Hloop_AZ_Q(ntryL,G1H64(2),wf4(:,4),G1H16(7),ngZu,m3h4x16(:,14),heltab2x64(:,:,18))
  call Hloop_A_Q(ntryL,G1H16(7),69,nMT,G2H16(10),n2h16(22))
  call Hloop_QZ_A(ntryL,G1H64(3),wf4(:,4),G1H16(8),ngZu,m3h4x16(:,15),heltab2x64(:,:,19))
  call Hloop_Q_A(ntryL,G1H16(8),69,0,G2H16(11),n2h16(23))
  call Hloop_QZ_A(ntryL,G1H64(4),wf4(:,4),G1H16(10),ngZu,m3h4x16(:,16),heltab2x64(:,:,20))
  call Hloop_Q_A(ntryL,G1H16(10),69,nMT,G2H16(12),n2h16(24))
  call Hloop_AZ_Q(ntryL,G1H64(5),wf4(:,4),G1H16(11),ngZd,m3h4x16(:,17),heltab2x64(:,:,21))
  call Hloop_A_Q(ntryL,G1H16(11),69,0,G2H16(1),n2h16(25))
  call Hloop_AZ_Q(ntryL,G1H64(6),wf4(:,4),G1H16(12),ngZd,m3h4x16(:,18),heltab2x64(:,:,22))
  call Hloop_A_Q(ntryL,G1H16(12),69,nMB,G2H16(2),n2h16(26))
  call Hloop_QZ_A(ntryL,G1H64(7),wf4(:,4),G1H16(13),ngZd,m3h4x16(:,19),heltab2x64(:,:,23))
  call Hloop_Q_A(ntryL,G1H16(13),69,0,G2H16(3),n2h16(27))
  call Hloop_QZ_A(ntryL,G1H64(8),wf4(:,4),G1H16(14),ngZd,m3h4x16(:,20),heltab2x64(:,:,24))
  call Hloop_Q_A(ntryL,G1H16(14),69,nMB,G2H16(4),n2h16(28))
  call Hloop_AZ_Q(ntryL,G1H64(9),wf4(:,4),G1H16(16),ngZu,m3h4x16(:,21),heltab2x64(:,:,25))
  call Hloop_A_Q(ntryL,G1H16(16),69,0,G2H16(5),n2h16(29))
  call Hloop_AZ_Q(ntryL,G1H64(10),wf4(:,4),G1H16(17),ngZu,m3h4x16(:,22),heltab2x64(:,:,26))
  call Hloop_A_Q(ntryL,G1H16(17),69,nMT,G2H16(6),n2h16(30))
  call Hloop_QZ_A(ntryL,G1H64(11),wf4(:,4),G1H16(18),ngZu,m3h4x16(:,23),heltab2x64(:,:,27))
  call Hloop_Q_A(ntryL,G1H16(18),69,0,G2H16(7),n2h16(31))
  call Hloop_QZ_A(ntryL,G1H64(12),wf4(:,4),G1H16(19),ngZu,m3h4x16(:,24),heltab2x64(:,:,28))
  call Hloop_Q_A(ntryL,G1H16(19),69,nMT,G2H16(8),n2h16(32))
  call Hloop_AZ_Q(ntryL,G1H64(13),wf4(:,4),G1H16(20),ngZd,m3h4x16(:,25),heltab2x64(:,:,29))
  call Hloop_A_Q(ntryL,G1H16(20),69,0,G2H16(13),n2h16(33))
  call Hloop_AZ_Q(ntryL,G1H64(14),wf4(:,4),G1H16(22),ngZd,m3h4x16(:,26),heltab2x64(:,:,30))
  call Hloop_A_Q(ntryL,G1H16(22),69,nMB,G2H16(14),n2h16(34))
  call Hloop_QZ_A(ntryL,G1H64(15),wf4(:,4),G1H16(23),ngZd,m3h4x16(:,27),heltab2x64(:,:,31))
  call Hloop_Q_A(ntryL,G1H16(23),69,0,G2H16(15),n2h16(35))
  call Hloop_QZ_A(ntryL,G1H64(16),wf4(:,4),G1H16(24),ngZd,m3h4x16(:,28),heltab2x64(:,:,32))
  call Hloop_Q_A(ntryL,G1H16(24),69,nMB,G2H16(16),n2h16(36))
  call Hloop_AZ_Q(ntryL,G1H64(17),wf4(:,5),G1H16(25),ngZu,m3h4x16(:,29),heltab2x64(:,:,33))
  call Hloop_A_Q(ntryL,G1H16(25),74,0,G2H16(17),n2h16(37))
  call Hloop_AZ_Q(ntryL,G1H64(18),wf4(:,5),G1H16(26),ngZu,m3h4x16(:,30),heltab2x64(:,:,34))
  call Hloop_A_Q(ntryL,G1H16(26),74,nMT,G2H16(18),n2h16(38))
  call Hloop_QZ_A(ntryL,G1H64(19),wf4(:,5),G1H16(28),ngZu,m3h4x16(:,31),heltab2x64(:,:,35))
  call Hloop_Q_A(ntryL,G1H16(28),74,0,G2H16(19),n2h16(39))
  call Hloop_QZ_A(ntryL,G1H64(20),wf4(:,5),G1H16(29),ngZu,m3h4x16(:,32),heltab2x64(:,:,36))
  call Hloop_Q_A(ntryL,G1H16(29),74,nMT,G2H16(20),n2h16(40))
  call Hloop_AZ_Q(ntryL,G1H64(21),wf4(:,5),G1H16(30),ngZd,m3h4x16(:,33),heltab2x64(:,:,37))
  call Hloop_A_Q(ntryL,G1H16(30),74,0,G2H16(21),n2h16(41))
  call Hloop_AZ_Q(ntryL,G1H64(22),wf4(:,5),G1H16(31),ngZd,m3h4x16(:,34),heltab2x64(:,:,38))
  call Hloop_A_Q(ntryL,G1H16(31),74,nMB,G2H16(22),n2h16(42))
  call Hloop_QZ_A(ntryL,G1H64(23),wf4(:,5),G1H16(32),ngZd,m3h4x16(:,35),heltab2x64(:,:,39))
  call Hloop_Q_A(ntryL,G1H16(32),74,0,G2H16(23),n2h16(43))
  call Hloop_QZ_A(ntryL,G1H64(24),wf4(:,5),G1H16(34),ngZd,m3h4x16(:,36),heltab2x64(:,:,40))
  call Hloop_Q_A(ntryL,G1H16(34),74,nMB,G2H16(24),n2h16(44))
  call Hloop_AZ_Q(ntryL,G1H32(4),wf4(:,5),G1H8(61),ngZd,m3h4x8(:,21),heltab2x32(:,:,25))
  call Hloop_A_Q(ntryL,G1H8(61),106,nMB,G2H8(15),n2h8(37))
  call Hloop_AZ_Q(ntryL,G1H32(5),wf4(:,4),G1H8(62),ngZd,m3h4x8(:,22),heltab2x32(:,:,26))
  call Hloop_A_Q(ntryL,G1H8(62),101,nMB,G2H8(16),n2h8(38))
  call Hloop_VQ_A(ntryL,G1H64(25),wf8(:,7),G1H8(77),m3h8x8(:,1),heltab2x64(:,:,41))
  call Hloop_Q_A(ntryL,G1H8(77),85,nMB,G2H8(21),n2h8(39))
  call Hloop_AZ_Q(ntryL,G1H64(26),wf4(:,5),G1H16(35),ngZd,m3h4x16(:,37),heltab2x64(:,:,42))
  call Hloop_A_Q(ntryL,G1H16(35),74,nMB,G2H16(25),n2h16(45))
  call Hloop_QZ_A(ntryL,G1H64(27),wf4(:,5),G1H16(36),ngZd,m3h4x16(:,38),heltab2x64(:,:,43))
  call Hloop_Q_A(ntryL,G1H16(36),74,nMB,G2H16(26),n2h16(46))
  call Hloop_VQ_A(ntryL,G1H64(28),ex5(:),G1H32(11),m3h2x32(:,5),heltab2x64(:,:,44))
  call Hloop_Q_A(ntryL,G1H32(11),80,nMB,G2H32(1),n2h32(17))
  call Hloop_QZ_A(ntryL,G1H64(29),wf4(:,5),G1H16(37),ngZd,m3h4x16(:,39),heltab2x64(:,:,45))
  call Hloop_Q_A(ntryL,G1H16(37),74,nMB,G2H16(27),n2h16(47))
  call Hloop_AZ_Q(ntryL,G1H64(30),wf4(:,5),G1H16(38),ngZd,m3h4x16(:,40),heltab2x64(:,:,46))
  call Hloop_A_Q(ntryL,G1H16(38),74,nMB,G2H16(28),n2h16(48))
  call Hloop_VQ_A(ntryL,G1H64(31),wf8(:,9),G1H8(78),m3h8x8(:,2),heltab2x64(:,:,47))
  call Hloop_Q_A(ntryL,G1H8(78),90,nMB,G2H8(23),n2h8(40))
  call Hloop_AZ_Q(ntryL,G1H64(32),wf4(:,4),G1H16(40),ngZd,m3h4x16(:,41),heltab2x64(:,:,48))
  call Hloop_A_Q(ntryL,G1H16(40),69,nMB,G2H16(29),n2h16(49))
  call Hloop_QZ_A(ntryL,G1H64(33),wf4(:,4),G1H16(41),ngZd,m3h4x16(:,42),heltab2x64(:,:,49))
  call Hloop_Q_A(ntryL,G1H16(41),69,nMB,G2H16(30),n2h16(50))
  call Hloop_VQ_A(ntryL,G1H64(34),ex5(:),G1H32(12),m3h2x32(:,6),heltab2x64(:,:,50))
  call Hloop_Q_A(ntryL,G1H32(12),80,nMB,G2H32(2),n2h32(18))
  call Hloop_QZ_A(ntryL,G1H64(35),wf4(:,4),G1H16(42),ngZd,m3h4x16(:,43),heltab2x64(:,:,51))
  call Hloop_Q_A(ntryL,G1H16(42),69,nMB,G2H16(31),n2h16(51))
  call Hloop_AZ_Q(ntryL,G1H64(36),wf4(:,4),G1H16(43),ngZd,m3h4x16(:,44),heltab2x64(:,:,52))
  call Hloop_A_Q(ntryL,G1H16(43),69,nMB,G2H16(32),n2h16(52))
  call Hloop_QS_A(ntryL,G1H64(37),wf16(:,3),G1H4(24),ngH,m3h16x4(:,1),heltab2x64(:,:,53))
  call Hloop_Q_A(ntryL,G1H4(24),79,nMB,G2H4(28),n2h4(53))
  call Hloop_AS_Q(ntryL,G1H64(38),wf16(:,3),G1H4(25),ngH,m3h16x4(:,2),heltab2x64(:,:,54))
  call Hloop_A_Q(ntryL,G1H4(25),79,nMB,G2H4(29),n2h4(54))
  call Hloop_VQ_A(ntryL,G1H64(39),ex5(:),G1H32(13),m3h2x32(:,7),heltab2x64(:,:,55))
  call Hloop_Q_A(ntryL,G1H32(13),80,nMB,G2H32(3),n2h32(19))
  call Hloop_QZ_A(ntryL,G1H64(40),wf16(:,73),G1H4(30),ngZd,m3h16x4(:,3),heltab2x64(:,:,56))
  call Hloop_Q_A(ntryL,G1H4(30),79,nMB,G2H4(31),n2h4(55))
  call Hloop_AZ_Q(ntryL,G1H64(41),wf16(:,73),G1H4(31),ngZd,m3h16x4(:,4),heltab2x64(:,:,57))
  call Hloop_A_Q(ntryL,G1H4(31),79,nMB,G2H4(32),n2h4(56))
  call Hloop_VQ_A(ntryL,G1H64(42),ex5(:),G1H32(14),m3h2x32(:,8),heltab2x64(:,:,58))
  call Hloop_Q_A(ntryL,G1H32(14),80,nMB,G2H32(4),n2h32(20))
  call Hloop_QZ_A(ntryL,G1H64(43),wf16(:,74),G1H4(35),ngZd,m3h16x4(:,5),heltab2x64(:,:,59))
  call Hloop_Q_A(ntryL,G1H4(35),79,nMB,G2H4(1),n2h4(57))
  call Hloop_AZ_Q(ntryL,G1H64(44),wf16(:,74),G1H4(36),ngZd,m3h16x4(:,6),heltab2x64(:,:,60))
  call Hloop_A_Q(ntryL,G1H4(36),79,nMB,G2H4(4),n2h4(58))
  call Hloop_VQ_A(ntryL,G1H64(45),ex5(:),G1H32(16),m3h2x32(:,9),heltab2x64(:,:,61))
  call Hloop_Q_A(ntryL,G1H32(16),80,nMB,G2H32(5),n2h32(21))
  call Hloop_QZ_A(ntryL,G1H64(46),wf4(:,12),G1H16(44),ngZu,m3h4x16(:,45),heltab2x64(:,:,62))
  call Hloop_Q_A(ntryL,G1H16(44),70,0,G2H16(33),n2h16(53))
  call Hloop_QZ_A(ntryL,G1H64(47),wf4(:,12),G1H16(46),ngZu,m3h4x16(:,46),heltab2x64(:,:,63))
  call Hloop_Q_A(ntryL,G1H16(46),70,nMT,G2H16(34),n2h16(54))
  call Hloop_AZ_Q(ntryL,G1H64(48),wf4(:,12),G1H16(47),ngZu,m3h4x16(:,47),heltab2x64(:,:,64))
  call Hloop_A_Q(ntryL,G1H16(47),70,0,G2H16(35),n2h16(55))
  call Hloop_AZ_Q(ntryL,G1H64(49),wf4(:,12),G1H16(48),ngZu,m3h4x16(:,48),heltab2x64(:,:,65))
  call Hloop_A_Q(ntryL,G1H16(48),70,nMT,G2H16(36),n2h16(56))
  call Hloop_QZ_A(ntryL,G1H64(50),wf4(:,12),G1H16(3),ngZd,m3h4x16(:,49),heltab2x64(:,:,66))
  call Hloop_Q_A(ntryL,G1H16(3),70,0,G2H16(37),n2h16(57))
  call Hloop_QZ_A(ntryL,G1H64(51),wf4(:,12),G1H16(9),ngZd,m3h4x16(:,50),heltab2x64(:,:,67))
  call Hloop_Q_A(ntryL,G1H16(9),70,nMB,G2H16(38),n2h16(58))
  call Hloop_AZ_Q(ntryL,G1H64(52),wf4(:,12),G1H16(15),ngZd,m3h4x16(:,51),heltab2x64(:,:,68))
  call Hloop_A_Q(ntryL,G1H16(15),70,0,G2H16(39),n2h16(59))
  call Hloop_AZ_Q(ntryL,G1H64(53),wf4(:,12),G1H16(21),ngZd,m3h4x16(:,52),heltab2x64(:,:,69))
  call Hloop_A_Q(ntryL,G1H16(21),70,nMB,G2H16(40),n2h16(60))
  call Hloop_AZ_Q(ntryL,G1H64(54),wf4(:,11),G1H16(27),ngZu,m3h4x16(:,53),heltab2x64(:,:,70))
  call Hloop_A_Q(ntryL,G1H16(27),73,0,G2H16(41),n2h16(61))
  call Hloop_AZ_Q(ntryL,G1H64(55),wf4(:,11),G1H16(33),ngZu,m3h4x16(:,54),heltab2x64(:,:,71))
  call Hloop_A_Q(ntryL,G1H16(33),73,nMT,G2H16(42),n2h16(62))
  call Hloop_QZ_A(ntryL,G1H64(56),wf4(:,11),G1H16(39),ngZu,m3h4x16(:,55),heltab2x64(:,:,72))
  call Hloop_Q_A(ntryL,G1H16(39),73,0,G2H16(43),n2h16(63))
  call Hloop_QZ_A(ntryL,G1H64(57),wf4(:,11),G1H16(45),ngZu,m3h4x16(:,56),heltab2x64(:,:,73))
  call Hloop_Q_A(ntryL,G1H16(45),73,nMT,G2H16(44),n2h16(64))
  call Hloop_AZ_Q(ntryL,G1H64(58),wf4(:,11),G1H16(6),ngZd,m3h4x16(:,57),heltab2x64(:,:,74))
  call Hloop_A_Q(ntryL,G1H16(6),73,0,G2H16(45),n2h16(65))
  call Hloop_AZ_Q(ntryL,G1H64(59),wf4(:,11),G1H16(7),ngZd,m3h4x16(:,58),heltab2x64(:,:,75))
  call Hloop_A_Q(ntryL,G1H16(7),73,nMB,G2H16(46),n2h16(66))
  call Hloop_QZ_A(ntryL,G1H64(60),wf4(:,11),G1H16(8),ngZd,m3h4x16(:,59),heltab2x64(:,:,76))
  call Hloop_Q_A(ntryL,G1H16(8),73,0,G2H16(47),n2h16(67))
  call Hloop_QZ_A(ntryL,G1H64(61),wf4(:,11),G1H16(10),ngZd,m3h4x16(:,60),heltab2x64(:,:,77))
  call Hloop_Q_A(ntryL,G1H16(10),73,nMB,G2H16(48),n2h16(68))
  call Hloop_AZ_Q(ntryL,G1H64(62),wf4(:,12),G1H16(11),ngZu,m3h4x16(:,61),heltab2x64(:,:,78))
  call Hloop_A_Q(ntryL,G1H16(11),70,0,G2H16(49),n2h16(69))
  call Hloop_AZ_Q(ntryL,G1H64(63),wf4(:,12),G1H16(12),ngZu,m3h4x16(:,62),heltab2x64(:,:,79))
  call Hloop_A_Q(ntryL,G1H16(12),70,nMT,G2H16(50),n2h16(70))
  call Hloop_QZ_A(ntryL,G1H64(64),wf4(:,12),G1H16(13),ngZu,m3h4x16(:,63),heltab2x64(:,:,80))
  call Hloop_Q_A(ntryL,G1H16(13),70,0,G2H16(51),n2h16(71))
  call Hloop_QZ_A(ntryL,G1H64(65),wf4(:,12),G1H16(14),ngZu,m3h4x16(:,64),heltab2x64(:,:,81))
  call Hloop_Q_A(ntryL,G1H16(14),70,nMT,G2H16(52),n2h16(72))
  call Hloop_AZ_Q(ntryL,G1H64(66),wf4(:,12),G1H16(16),ngZd,m3h4x16(:,65),heltab2x64(:,:,82))
  call Hloop_A_Q(ntryL,G1H16(16),70,0,G2H16(53),n2h16(73))
  call Hloop_AZ_Q(ntryL,G1H64(67),wf4(:,12),G1H16(17),ngZd,m3h4x16(:,66),heltab2x64(:,:,83))
  call Hloop_A_Q(ntryL,G1H16(17),70,nMB,G2H16(54),n2h16(74))
  call Hloop_QZ_A(ntryL,G1H64(68),wf4(:,12),G1H16(18),ngZd,m3h4x16(:,67),heltab2x64(:,:,84))
  call Hloop_Q_A(ntryL,G1H16(18),70,0,G2H16(55),n2h16(75))
  call Hloop_QZ_A(ntryL,G1H64(69),wf4(:,12),G1H16(19),ngZd,m3h4x16(:,68),heltab2x64(:,:,85))
  call Hloop_Q_A(ntryL,G1H16(19),70,nMB,G2H16(56),n2h16(76))
  call Hloop_AZ_Q(ntryL,G1H32(8),wf4(:,12),G1H8(1),ngZd,m3h4x8(:,23),heltab2x32(:,:,27))
  call Hloop_A_Q(ntryL,G1H8(1),102,nMB,G2H8(24),n2h8(41))
  call Hloop_AZ_Q(ntryL,G1H32(10),wf4(:,11),G1H8(2),ngZd,m3h4x8(:,24),heltab2x32(:,:,28))
  call Hloop_A_Q(ntryL,G1H8(2),105,nMB,G2H8(25),n2h8(42))
  call Hloop_VQ_A(ntryL,G1H64(70),wf8(:,24),G1H8(5),m3h8x8(:,3),heltab2x64(:,:,86))
  call Hloop_Q_A(ntryL,G1H8(5),89,nMB,G2H8(27),n2h8(43))
  call Hloop_AZ_Q(ntryL,G1H64(71),wf4(:,12),G1H16(20),ngZd,m3h4x16(:,69),heltab2x64(:,:,87))
  call Hloop_A_Q(ntryL,G1H16(20),70,nMB,G2H16(57),n2h16(77))
  call Hloop_QZ_A(ntryL,G1H64(72),wf4(:,12),G1H16(22),ngZd,m3h4x16(:,70),heltab2x64(:,:,88))
  call Hloop_Q_A(ntryL,G1H16(22),70,nMB,G2H16(58),n2h16(78))
  call Hloop_VQ_A(ntryL,G1H64(73),ex5(:),G1H32(17),m3h2x32(:,10),heltab2x64(:,:,89))
  call Hloop_Q_A(ntryL,G1H32(17),80,nMB,G2H32(6),n2h32(22))
  call Hloop_QZ_A(ntryL,G1H64(74),wf4(:,12),G1H16(23),ngZd,m3h4x16(:,71),heltab2x64(:,:,90))
  call Hloop_Q_A(ntryL,G1H16(23),70,nMB,G2H16(59),n2h16(79))
  call Hloop_AZ_Q(ntryL,G1H64(75),wf4(:,12),G1H16(24),ngZd,m3h4x16(:,72),heltab2x64(:,:,91))
  call Hloop_A_Q(ntryL,G1H16(24),70,nMB,G2H16(60),n2h16(80))
  call Hloop_VQ_A(ntryL,G1H64(76),wf8(:,26),G1H8(6),m3h8x8(:,4),heltab2x64(:,:,92))
  call Hloop_Q_A(ntryL,G1H8(6),86,nMB,G2H8(28),n2h8(44))
  call Hloop_AZ_Q(ntryL,G1H64(77),wf4(:,11),G1H16(25),ngZd,m3h4x16(:,73),heltab2x64(:,:,93))
  call Hloop_A_Q(ntryL,G1H16(25),73,nMB,G2H16(61),n2h16(81))
  call Hloop_QZ_A(ntryL,G1H64(78),wf4(:,11),G1H16(26),ngZd,m3h4x16(:,74),heltab2x64(:,:,94))
  call Hloop_Q_A(ntryL,G1H16(26),73,nMB,G2H16(62),n2h16(82))
  call Hloop_VQ_A(ntryL,G1H64(79),ex5(:),G1H32(18),m3h2x32(:,11),heltab2x64(:,:,95))
  call Hloop_Q_A(ntryL,G1H32(18),80,nMB,G2H32(7),n2h32(23))
  call Hloop_QZ_A(ntryL,G1H64(80),wf4(:,11),G1H16(28),ngZd,m3h4x16(:,75),heltab2x64(:,:,96))
  call Hloop_Q_A(ntryL,G1H16(28),73,nMB,G2H16(63),n2h16(83))
  call Hloop_AZ_Q(ntryL,G1H64(81),wf4(:,11),G1H16(29),ngZd,m3h4x16(:,76),heltab2x64(:,:,97))
  call Hloop_A_Q(ntryL,G1H16(29),73,nMB,G2H16(64),n2h16(84))
  call Hloop_QS_A(ntryL,G1H64(82),wf16(:,12),G1H4(41),ngH,m3h16x4(:,7),heltab2x64(:,:,98))
  call Hloop_Q_A(ntryL,G1H4(41),79,nMB,G2H4(5),n2h4(59))
  call Hloop_AS_Q(ntryL,G1H64(83),wf16(:,12),G1H4(42),ngH,m3h16x4(:,8),heltab2x64(:,:,99))
  call Hloop_A_Q(ntryL,G1H4(42),79,nMB,G2H4(8),n2h4(60))
  call Hloop_VQ_A(ntryL,G1H64(84),ex5(:),G1H32(19),m3h2x32(:,12),heltab2x64(:,:,100))
  call Hloop_Q_A(ntryL,G1H32(19),80,nMB,G2H32(8),n2h32(24))
  call Hloop_QZ_A(ntryL,G1H64(85),wf16(:,85),G1H4(46),ngZd,m3h16x4(:,9),heltab2x64(:,:,101))
  call Hloop_Q_A(ntryL,G1H4(46),79,nMB,G2H4(9),n2h4(61))
  call Hloop_AZ_Q(ntryL,G1H64(86),wf16(:,85),G1H4(47),ngZd,m3h16x4(:,10),heltab2x64(:,:,102))
  call Hloop_A_Q(ntryL,G1H4(47),79,nMB,G2H4(12),n2h4(62))
  call Hloop_VQ_A(ntryL,G1H64(87),ex5(:),G1H32(20),m3h2x32(:,13),heltab2x64(:,:,103))
  call Hloop_Q_A(ntryL,G1H32(20),80,nMB,G2H32(9),n2h32(25))
  call Hloop_QZ_A(ntryL,G1H64(88),wf16(:,86),G1H4(52),ngZd,m3h16x4(:,11),heltab2x64(:,:,104))
  call Hloop_Q_A(ntryL,G1H4(52),79,nMB,G2H4(13),n2h4(63))
  call Hloop_AZ_Q(ntryL,G1H64(89),wf16(:,86),G1H4(53),ngZd,m3h16x4(:,12),heltab2x64(:,:,105))
  call Hloop_A_Q(ntryL,G1H4(53),79,nMB,G2H4(16),n2h4(64))
  call Hloop_VQ_A(ntryL,G1H64(90),ex5(:),G1H32(22),m3h2x32(:,14),heltab2x64(:,:,106))
  call Hloop_Q_A(ntryL,G1H32(22),80,nMB,G2H32(10),n2h32(26))
  call Hloop_QZ_A(ntryL,G1H64(91),wf16(:,87),G1H4(18),ngZd,m3h16x4(:,13),heltab2x64(:,:,107))
  call Hloop_Q_A(ntryL,G1H4(18),79,nMB,G2H4(33),n2h4(65))
  call Hloop_AZ_Q(ntryL,G1H64(92),wf16(:,87),G1H4(29),ngZd,m3h16x4(:,14),heltab2x64(:,:,108))
  call Hloop_A_Q(ntryL,G1H4(29),79,nMB,G2H4(34),n2h4(66))
  call Hloop_VQ_A(ntryL,G1H64(93),ex5(:),G1H32(23),m3h2x32(:,15),heltab2x64(:,:,109))
  call Hloop_Q_A(ntryL,G1H32(23),80,nMB,G2H32(11),n2h32(27))
  call Hloop_QZ_A(ntryL,G1H64(94),wf16(:,88),G1H4(40),ngZd,m3h16x4(:,15),heltab2x64(:,:,110))
  call Hloop_Q_A(ntryL,G1H4(40),79,nMB,G2H4(35),n2h4(67))
  call Hloop_AZ_Q(ntryL,G1H64(95),wf16(:,88),G1H4(51),ngZd,m3h16x4(:,16),heltab2x64(:,:,111))
  call Hloop_A_Q(ntryL,G1H4(51),79,nMB,G2H4(36),n2h4(68))
  call Hloop_VQ_A(ntryL,G1H64(96),ex5(:),G1H32(24),m3h2x32(:,16),heltab2x64(:,:,112))
  call Hloop_Q_A(ntryL,G1H32(24),80,nMB,G2H32(12),n2h32(28))
  call Hloop_QZ_A(ntryL,G1H64(97),wf16(:,89),G1H4(13),ngZd,m3h16x4(:,17),heltab2x64(:,:,113))
  call Hloop_Q_A(ntryL,G1H4(13),79,nMB,G2H4(37),n2h4(69))
  call Hloop_AZ_Q(ntryL,G1H64(98),wf16(:,89),G1H4(14),ngZd,m3h16x4(:,18),heltab2x64(:,:,114))
  call Hloop_A_Q(ntryL,G1H4(14),79,nMB,G2H4(38),n2h4(70))
  call Hloop_VQ_A(ntryL,G1H64(99),ex5(:),G1H32(3),m3h2x32(:,17),heltab2x64(:,:,115))
  call Hloop_Q_A(ntryL,G1H32(3),80,nMB,G2H32(13),n2h32(29))
  call Hloop_QZ_A(ntryL,G1H64(100),wf16(:,90),G1H4(19),ngZd,m3h16x4(:,19),heltab2x64(:,:,116))
  call Hloop_Q_A(ntryL,G1H4(19),79,nMB,G2H4(39),n2h4(71))
  call Hloop_AZ_Q(ntryL,G1H64(101),wf16(:,90),G1H4(20),ngZd,m3h16x4(:,20),heltab2x64(:,:,117))
  call Hloop_A_Q(ntryL,G1H4(20),79,nMB,G2H4(40),n2h4(72))
  call Hloop_VQ_A(ntryL,G1H64(102),ex5(:),G1H32(9),m3h2x32(:,18),heltab2x64(:,:,118))
  call Hloop_Q_A(ntryL,G1H32(9),80,nMB,G2H32(14),n2h32(30))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(11),[G1H8(43)])
call HGT_lower_alpha_w2_OLR(G2H8(5),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(5),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(5),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(5),[G2H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(39),[G2H4(37),G2H4(35),G2H4(33),G2H4(13),G2H4(9),G2H4(5) &
    ,G2H4(1),G2H4(31),G2H4(28),G2H4(22),G2H4(18),G2H4(6),G2H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(9),[G1H8(27)])
call HGT_lower_alpha_w2_OLR(G2H8(6),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(6),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(6),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(6),[G2H8(9)])
call HGT_lower_alpha_w2_OLR(G2H8(7),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(7),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(7),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(7),[G2H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(40),[G2H4(38),G2H4(36),G2H4(34),G2H4(16),G2H4(12),G2H4(8) &
    ,G2H4(4),G2H4(32),G2H4(29),G2H4(30),G2H4(26),G2H4(14),G2H4(10)])
call HGT_lower_alpha_w2_OLR(G2H8(8),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(8),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(8),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(8),[G2H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(21),[G2H8(10),G1H8(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(23),[G2H8(14),G1H8(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(13),[G1H8(75)])
call HGT_lower_alpha_w2_OLR(G2H8(17),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(17),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(17),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(17),[G2H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(12),[G1H8(59)])
call HGT_lower_alpha_w2_OLR(G2H8(18),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(18),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(18),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(18),[G2H8(12)])
call HGT_lower_alpha_w2_OLR(G2H8(19),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(19),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(19),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(19),[G2H8(24)])
call HGT_lower_alpha_w2_OLR(G2H8(20),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(20),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(20),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(20),[G2H8(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(27),[G2H8(22),G1H8(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(28),[G2H8(26),G1H8(76)])
  call Hotf_4pt_reduction(G2H8(5),RedSet_4(17),mass4set(:,4),  & 
G1H8(7),G1H8(8),G1H8(11),G1H8(12),G1H8(13),8)
  call HG1shiftOLR(G1H8(8),32,8)
  call Hloop_QA_V(ntryL,G2H4(39),ex6(:),G2H2(1),m3h2x2(:,25),heltab2x4(:,:,41))
  call Hotf_4pt_reduction(G2H8(6),RedSet_4(14),mass4set(:,4),  & 
G1H8(14),G1H8(17),G1H8(18),G1H8(19),G1H8(20),8)
  call HG1shiftOLR(G1H8(17),32,8)
  call Hotf_4pt_reduction(G2H8(7),RedSet_4(66),mass4set(:,4),  & 
G1H8(23),G1H8(24),G1H8(25),G1H8(26),G1H8(31),8)
  call HG1shiftOLR(G1H8(24),16,8)
  call Hloop_AQ_V(ntryL,G2H4(40),ex5(:),G2H2(3),m3h2x2(:,26),heltab2x4(:,:,42))
  call Hotf_4pt_reduction(G2H8(8),RedSet_4(67),mass4set(:,4),  & 
G1H8(36),G1H8(32),G1H8(35),G1H8(37),G1H8(40),8)
  call HG1shiftOLR(G1H8(32),16,8)
call HGT_w2_OLR(G1H16(1),1,1,16)
call HGT_w2_invQ_OLR(G1H16(1),2,5,16)
  call Hloop_QZ_A(ntryL,G1H16(1),wf4(:,4),G1H4(24),ngZd,m3h4x4(:,41),heltab2x16(:,:,53))
  call Hloop_Q_A(ntryL,G1H4(24),117,nMB,G2H4(37),n2h4(73))
  call Hotf_4pt_reduction(G2H8(21),RedSet_4(15),mass4set(:,1),  & 
G1H8(41),G1H8(42),G1H8(47),G1H8(52),G1H8(48),8)
  call HG1shiftOLR(G1H8(42),32,8)
call HGT_w2_OLR(G1H16(2),1,1,16)
call HGT_w2_invQ_OLR(G1H16(2),2,5,16)
  call Hloop_QZ_A(ntryL,G1H16(2),wf4(:,5),G1H4(25),ngZd,m3h4x4(:,42),heltab2x16(:,:,54))
  call Hloop_Q_A(ntryL,G1H4(25),122,nMB,G2H4(35),n2h4(74))
  call Hotf_4pt_reduction(G2H8(23),RedSet_4(18),mass4set(:,1),  & 
G1H8(51),G1H8(53),G1H8(56),G1H8(57),G1H8(58),8)
  call HG1shiftOLR(G1H8(53),32,8)
  call Hotf_4pt_reduction(G2H8(17),RedSet_4(23),mass4set(:,4),  & 
G1H8(63),G1H8(68),G1H8(64),G1H8(67),G1H8(69),8)
  call HG1shiftOLR(G1H8(68),32,8)
  call Hotf_4pt_reduction(G2H8(18),RedSet_4(20),mass4set(:,4),  & 
G1H8(72),G1H8(73),G1H8(74),G1H8(79),G1H8(84),8)
  call HG1shiftOLR(G1H8(73),32,8)
  call Hotf_4pt_reduction(G2H8(19),RedSet_4(68),mass4set(:,4),  & 
G1H8(80),G1H8(83),G1H8(85),G1H8(88),G1H8(29),8)
  call HG1shiftOLR(G1H8(83),16,8)
  call Hotf_4pt_reduction(G2H8(20),RedSet_4(69),mass4set(:,4),  & 
G1H8(30),G1H8(45),G1H8(46),G1H8(61),G1H8(62),8)
  call HG1shiftOLR(G1H8(45),16,8)
call HGT_w2_OLR(G1H16(4),1,1,16)
call HGT_w2_invQ_OLR(G1H16(4),2,5,16)
  call Hloop_QZ_A(ntryL,G1H16(4),wf4(:,11),G1H4(30),ngZd,m3h4x4(:,43),heltab2x16(:,:,55))
  call Hloop_Q_A(ntryL,G1H4(30),121,nMB,G2H4(33),n2h4(75))
  call Hotf_4pt_reduction(G2H8(27),RedSet_4(21),mass4set(:,1),  & 
G1H8(77),G1H8(78),G1H8(1),G1H8(2),G1H8(5),8)
  call HG1shiftOLR(G1H8(78),32,8)
call HGT_w2_OLR(G1H16(5),1,1,16)
call HGT_w2_invQ_OLR(G1H16(5),2,5,16)
  call Hloop_QZ_A(ntryL,G1H16(5),wf4(:,12),G1H4(31),ngZd,m3h4x4(:,44),heltab2x16(:,:,56))
  call Hloop_Q_A(ntryL,G1H4(31),118,nMB,G2H4(13),n2h4(76))
  call Hotf_4pt_reduction(G2H8(28),RedSet_4(24),mass4set(:,1),  & 
G1H8(6),G1H8(43),G1H8(27),G1H8(28),G1H8(44),8)
  call HG1shiftOLR(G1H8(43),32,8)
  call Hloop_VA_Q(ntryL,G1H8(3),ex6(:),G1H4(35),m3h2x4(:,25),heltab2x8(:,:,49))
  call Hloop_A_Q(ntryL,G1H4(35),117,nMB,G2H4(9),n2h4(77))
  call Hloop_VA_Q(ntryL,G1H8(4),ex6(:),G1H4(36),m3h2x4(:,26),heltab2x8(:,:,50))
  call Hloop_A_Q(ntryL,G1H4(36),117,nMB,G2H4(5),n2h4(78))
  call Hloop_VQ_A(ntryL,G1H8(9),ex5(:),G1H4(41),m3h2x4(:,27),heltab2x8(:,:,51))
  call Hloop_Q_A(ntryL,G1H4(41),117,nMB,G2H4(1),n2h4(79))
  call Hloop_VQ_A(ntryL,G1H8(10),ex5(:),G1H4(42),m3h2x4(:,28),heltab2x8(:,:,52))
  call Hloop_Q_A(ntryL,G1H4(42),117,nMB,G2H4(31),n2h4(80))
  call Hloop_VQ_A(ntryL,G1H8(15),ex5(:),G1H4(46),m3h2x4(:,29),heltab2x8(:,:,53))
  call Hloop_Q_A(ntryL,G1H4(46),118,nMB,G2H4(28),n2h4(81))
  call Hloop_VQ_A(ntryL,G1H8(16),ex5(:),G1H4(47),m3h2x4(:,30),heltab2x8(:,:,54))
  call Hloop_Q_A(ntryL,G1H4(47),118,nMB,G2H4(22),n2h4(82))
  call Hloop_VA_Q(ntryL,G1H8(21),ex6(:),G1H4(52),m3h2x4(:,31),heltab2x8(:,:,55))
  call Hloop_A_Q(ntryL,G1H4(52),118,nMB,G2H4(18),n2h4(83))
  call Hloop_VA_Q(ntryL,G1H8(22),ex6(:),G1H4(53),m3h2x4(:,32),heltab2x8(:,:,56))
  call Hloop_A_Q(ntryL,G1H4(53),118,nMB,G2H4(6),n2h4(84))
  call Hloop_QZ_A(ntryL,G1H8(33),wf4(:,5),G1H2(6),ngZd,m3h4x2(:,25),heltab2x8(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(6),95,nMB,G2H2(4),n2h2(21))
  call Hloop_QZ_A(ntryL,G1H8(34),wf4(:,5),G1H2(17),ngZd,m3h4x2(:,26),heltab2x8(:,:,58))
  call Hloop_Q_A(ntryL,G1H2(17),95,nMB,G2H2(6),n2h2(22))
  call Hloop_QZ_A(ntryL,G1H8(38),wf4(:,5),G1H2(28),ngZd,m3h4x2(:,27),heltab2x8(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(28),95,nMB,G2H2(7),n2h2(23))
  call Hloop_QZ_A(ntryL,G1H8(39),wf4(:,5),G1H2(39),ngZd,m3h4x2(:,28),heltab2x8(:,:,60))
  call Hloop_Q_A(ntryL,G1H2(39),95,nMB,G2H2(9),n2h2(24))
  call Hloop_QZ_A(ntryL,G1H8(49),wf4(:,4),G1H2(50),ngZd,m3h4x2(:,29),heltab2x8(:,:,61))
  call Hloop_Q_A(ntryL,G1H2(50),95,nMB,G2H2(10),n2h2(25))
  call Hloop_QZ_A(ntryL,G1H8(50),wf4(:,4),G1H2(61),ngZd,m3h4x2(:,30),heltab2x8(:,:,62))
  call Hloop_Q_A(ntryL,G1H2(61),95,nMB,G2H2(12),n2h2(26))
  call Hloop_QZ_A(ntryL,G1H8(54),wf4(:,4),G1H2(72),ngZd,m3h4x2(:,31),heltab2x8(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(72),95,nMB,G2H2(13),n2h2(27))
  call Hloop_QZ_A(ntryL,G1H8(55),wf4(:,4),G1H2(83),ngZd,m3h4x2(:,32),heltab2x8(:,:,64))
  call Hloop_Q_A(ntryL,G1H2(83),95,nMB,G2H2(15),n2h2(28))
  call Hloop_QZ_A(ntryL,G1H8(65),wf4(:,12),G1H2(1),ngZd,m3h4x2(:,33),heltab2x8(:,:,65))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(16),n2h2(29))
  call Hloop_QZ_A(ntryL,G1H8(66),wf4(:,12),G1H2(2),ngZd,m3h4x2(:,34),heltab2x8(:,:,66))
  call Hloop_Q_A(ntryL,G1H2(2),95,nMB,G2H2(18),n2h2(30))
  call Hloop_QZ_A(ntryL,G1H8(70),wf4(:,12),G1H2(7),ngZd,m3h4x2(:,35),heltab2x8(:,:,67))
  call Hloop_Q_A(ntryL,G1H2(7),95,nMB,G2H2(19),n2h2(31))
  call Hloop_QZ_A(ntryL,G1H8(71),wf4(:,12),G1H2(8),ngZd,m3h4x2(:,36),heltab2x8(:,:,68))
  call Hloop_Q_A(ntryL,G1H2(8),95,nMB,G2H2(21),n2h2(32))
  call Hloop_QZ_A(ntryL,G1H8(81),wf4(:,11),G1H2(12),ngZd,m3h4x2(:,37),heltab2x8(:,:,69))
  call Hloop_Q_A(ntryL,G1H2(12),95,nMB,G2H2(22),n2h2(33))
  call Hloop_QZ_A(ntryL,G1H8(82),wf4(:,11),G1H2(13),ngZd,m3h4x2(:,38),heltab2x8(:,:,70))
  call Hloop_Q_A(ntryL,G1H2(13),95,nMB,G2H2(24),n2h2(34))
  call Hloop_QZ_A(ntryL,G1H8(86),wf4(:,11),G1H2(18),ngZd,m3h4x2(:,39),heltab2x8(:,:,71))
  call Hloop_Q_A(ntryL,G1H2(18),95,nMB,G2H2(29),n2h2(35))
  call Hloop_QZ_A(ntryL,G1H8(87),wf4(:,11),G1H2(19),ngZd,m3h4x2(:,40),heltab2x8(:,:,72))
  call Hloop_Q_A(ntryL,G1H2(19),95,nMB,G2H2(31),n2h2(36))
  call Hloop_QA_V(ntryL,G2H4(17),ex6(:),G2H2(34),m3h2x2(:,27),heltab2x4(:,:,43))
  call Hloop_QA_V(ntryL,G2H4(19),ex6(:),G2H2(36),m3h2x2(:,28),heltab2x4(:,:,44))
  call Hloop_AQ_V(ntryL,G2H4(20),ex5(:),G2H2(39),m3h2x2(:,29),heltab2x4(:,:,45))
  call Hloop_AQ_V(ntryL,G2H4(21),ex5(:),G2H2(41),m3h2x2(:,30),heltab2x4(:,:,46))
  call Hloop_QA_V(ntryL,G2H4(23),ex6(:),G2H2(44),m3h2x2(:,31),heltab2x4(:,:,47))
  call Hloop_QA_V(ntryL,G2H4(24),ex6(:),G2H2(46),m3h2x2(:,32),heltab2x4(:,:,48))
  call Hloop_AQ_V(ntryL,G2H4(25),ex5(:),G2H2(49),m3h2x2(:,33),heltab2x4(:,:,49))
  call Hloop_AQ_V(ntryL,G2H4(27),ex5(:),G2H2(50),m3h2x2(:,34),heltab2x4(:,:,50))
  call Hotf_4pt_reduction(G2H16(9),RedSet_4(54),mass4set(:,5),  & 
G1H16(30),G1H16(31),G1H16(32),G1H16(34),G1H16(35),G0H16(1),16)
  call HG1shiftOLR(G1H16(31),10,16)
  call Hotf_4pt_reduction(G2H16(10),RedSet_4(54),mass4set(:,6),  & 
G1H16(36),G1H16(37),G1H16(38),G1H16(40),G1H16(41),G0H16(2),16)
  call HG1shiftOLR(G1H16(37),10,16)
  call Hotf_4pt_reduction(G2H16(11),RedSet_4(54),mass4set(:,5),  & 
G1H16(42),G1H16(43),G1H16(44),G1H16(46),G1H16(47),G0H16(3),16)
  call HG1shiftOLR(G1H16(43),10,16)
  call Hotf_4pt_reduction(G2H16(12),RedSet_4(54),mass4set(:,6),  & 
G1H16(48),G1H16(3),G1H16(9),G1H16(15),G1H16(21),G0H16(4),16)
  call HG1shiftOLR(G1H16(3),10,16)
  call Hotf_4pt_reduction(G2H16(1),RedSet_4(54),mass4set(:,5),  & 
G1H16(27),G1H16(33),G1H16(39),G1H16(45),G1H16(6),G0H16(5),16)
  call HG1shiftOLR(G1H16(33),10,16)
  call Hotf_4pt_reduction(G2H16(2),RedSet_4(54),mass4set(:,2),  & 
G1H16(7),G1H16(8),G1H16(10),G1H16(11),G1H16(12),G0H16(6),16)
  call HG1shiftOLR(G1H16(8),10,16)
  call Hotf_4pt_reduction(G2H16(3),RedSet_4(54),mass4set(:,5),  & 
G1H16(13),G1H16(14),G1H16(16),G1H16(17),G1H16(18),G0H16(7),16)
  call HG1shiftOLR(G1H16(14),10,16)
  call Hotf_4pt_reduction(G2H16(4),RedSet_4(54),mass4set(:,2),  & 
G1H16(19),G1H16(20),G1H16(22),G1H16(23),G1H16(24),G0H16(8),16)
  call HG1shiftOLR(G1H16(20),10,16)
  call Hotf_4pt_reduction(G2H16(5),RedSet_4(7),mass4set(:,5),  & 
G1H16(25),G1H16(26),G1H16(28),G1H16(29),G1H16(1),G0H16(9),16)
  call HG1shiftOLR(G1H16(26),48,16)
  call Hotf_4pt_reduction(G2H16(6),RedSet_4(7),mass4set(:,6),  & 
G1H16(2),G1H16(4),G1H16(5),G1H16(49),G1H16(50),G0H16(10),16)
  call HG1shiftOLR(G1H16(4),48,16)
  call Hotf_4pt_reduction(G2H16(7),RedSet_4(7),mass4set(:,5),  & 
G1H16(51),G1H16(52),G1H16(53),G1H16(54),G1H16(55),G0H16(11),16)
  call HG1shiftOLR(G1H16(52),48,16)
  call Hotf_4pt_reduction(G2H16(8),RedSet_4(7),mass4set(:,6),  & 
G1H16(56),G1H16(57),G1H16(58),G1H16(59),G1H16(60),G0H16(12),16)
  call HG1shiftOLR(G1H16(57),48,16)
  call Hotf_4pt_reduction(G2H16(13),RedSet_4(7),mass4set(:,5),  & 
G1H16(61),G1H16(62),G1H16(63),G1H16(64),G1H16(65),G0H16(13),16)
  call HG1shiftOLR(G1H16(62),48,16)
  call Hotf_4pt_reduction(G2H16(14),RedSet_4(7),mass4set(:,2),  & 
G1H16(66),G1H16(67),G1H16(68),G1H16(69),G1H16(70),G0H16(14),16)
  call HG1shiftOLR(G1H16(67),48,16)
  call Hotf_4pt_reduction(G2H16(15),RedSet_4(7),mass4set(:,5),  & 
G1H16(71),G1H16(72),G1H16(73),G1H16(74),G1H16(75),G0H16(15),16)
  call HG1shiftOLR(G1H16(72),48,16)
  call Hotf_4pt_reduction(G2H16(16),RedSet_4(7),mass4set(:,2),  & 
G1H16(76),G1H16(77),G1H16(78),G1H16(79),G1H16(80),G0H16(16),16)
  call HG1shiftOLR(G1H16(77),48,16)
  call Hotf_4pt_reduction(G2H16(17),RedSet_4(6),mass4set(:,5),  & 
G1H16(81),G1H16(82),G1H16(83),G1H16(84),G1H16(85),G0H16(17),16)
  call HG1shiftOLR(G1H16(82),48,16)
  call Hotf_4pt_reduction(G2H16(18),RedSet_4(6),mass4set(:,6),  & 
G1H16(86),G1H16(87),G1H16(88),G1H16(89),G1H16(90),G0H16(18),16)
  call HG1shiftOLR(G1H16(87),48,16)
  call Hotf_4pt_reduction(G2H16(19),RedSet_4(6),mass4set(:,5),  & 
G1H16(91),G1H16(92),G1H16(93),G1H16(94),G1H16(95),G0H16(19),16)
  call HG1shiftOLR(G1H16(92),48,16)
  call Hotf_4pt_reduction(G2H16(20),RedSet_4(6),mass4set(:,6),  & 
G1H16(96),G1H16(97),G1H16(98),G1H16(99),G1H16(100),G0H16(20),16)
  call HG1shiftOLR(G1H16(97),48,16)
  call Hotf_4pt_reduction(G2H16(21),RedSet_4(6),mass4set(:,5),  & 
G1H16(101),G1H16(102),G1H16(103),G1H16(104),G1H16(105),G0H16(21),16)
  call HG1shiftOLR(G1H16(102),48,16)
  call Hotf_4pt_reduction(G2H16(22),RedSet_4(6),mass4set(:,2),  & 
G1H16(106),G1H16(107),G1H16(108),G1H16(109),G1H16(110),G0H16(22),16)
  call HG1shiftOLR(G1H16(107),48,16)
  call Hotf_4pt_reduction(G2H16(23),RedSet_4(6),mass4set(:,5),  & 
G1H16(111),G1H16(112),G1H16(113),G1H16(114),G1H16(115),G0H16(23),16)
  call HG1shiftOLR(G1H16(112),48,16)
  call Hotf_4pt_reduction(G2H16(24),RedSet_4(6),mass4set(:,2),  & 
G1H16(116),G1H16(117),G1H16(118),G1H16(119),G1H16(120),G0H16(24),16)
  call HG1shiftOLR(G1H16(117),48,16)
  call Hloop_AQ_V(ntryL,G2H16(25),wf8(:,7),G2H2(51),m3h8x2(:,1),heltab2x16(:,:,57))
  call Hloop_QA_V(ntryL,G2H16(26),ex6(:),G2H8(1),m3h2x8(:,13),heltab2x16(:,:,58))
  call Hotf_4pt_reduction(G2H32(1),RedSet_4(3),mass4set(:,1),  & 
G1H32(15),G1H32(21),G1H32(2),G1H32(1),G1H32(7),32)
  call HG1shiftOLR(G1H32(21),37,32)
  call Hloop_QA_V(ntryL,G2H16(27),wf8(:,2),G2H2(52),m3h8x2(:,2),heltab2x16(:,:,59))
  call Hloop_AQ_V(ntryL,G2H16(28),ex5(:),G2H8(2),m3h2x8(:,14),heltab2x16(:,:,60))
  call Hloop_AQ_V(ntryL,G2H16(29),wf8(:,9),G2H2(53),m3h8x2(:,3),heltab2x16(:,:,61))
  call Hloop_QA_V(ntryL,G2H16(30),ex6(:),G2H8(3),m3h2x8(:,15),heltab2x16(:,:,62))
  call Hotf_4pt_reduction(G2H32(2),RedSet_4(2),mass4set(:,1),  & 
G1H32(6),G1H32(4),G1H32(5),G1H32(11),G1H32(12),32)
  call HG1shiftOLR(G1H32(4),42,32)
  call Hloop_QA_V(ntryL,G2H16(31),wf8(:,4),G2H2(54),m3h8x2(:,4),heltab2x16(:,:,63))
  call Hloop_AQ_V(ntryL,G2H16(32),ex5(:),G2H8(4),m3h2x8(:,16),heltab2x16(:,:,64))
  call Hotf_4pt_reduction(G2H32(3),RedSet_4(1),mass4set(:,1),  & 
G1H32(13),G1H32(14),G1H32(16),G1H32(8),G1H32(10),32)
  call HG1shiftOLR(G1H32(14),32,32)
  call Hotf_4pt_reduction(G2H32(4),RedSet_4(1),mass4set(:,1),  & 
G1H32(17),G1H32(18),G1H32(19),G1H32(20),G1H32(22),32)
  call HG1shiftOLR(G1H32(18),32,32)
  call Hotf_4pt_reduction(G2H32(5),RedSet_4(1),mass4set(:,1),  & 
G1H32(23),G1H32(24),G1H32(3),G1H32(9),G1H32(25),32)
  call HG1shiftOLR(G1H32(24),32,32)
  call Hotf_4pt_reduction(G2H16(33),RedSet_4(61),mass4set(:,5),  & 
G1H16(121),G1H16(122),G1H16(123),G1H16(124),G1H16(125),G0H16(25),16)
  call HG1shiftOLR(G1H16(122),9,16)
  call Hotf_4pt_reduction(G2H16(34),RedSet_4(61),mass4set(:,6),  & 
G1H16(126),G1H16(127),G1H16(128),G1H16(129),G1H16(130),G0H16(26),16)
  call HG1shiftOLR(G1H16(127),9,16)
  call Hotf_4pt_reduction(G2H16(35),RedSet_4(61),mass4set(:,5),  & 
G1H16(131),G1H16(132),G1H16(133),G1H16(134),G1H16(135),G0H16(27),16)
  call HG1shiftOLR(G1H16(132),9,16)
  call Hotf_4pt_reduction(G2H16(36),RedSet_4(61),mass4set(:,6),  & 
G1H16(136),G1H16(137),G1H16(138),G1H16(139),G1H16(140),G0H16(28),16)
  call HG1shiftOLR(G1H16(137),9,16)
  call Hotf_4pt_reduction(G2H16(37),RedSet_4(61),mass4set(:,5),  & 
G1H16(141),G1H16(142),G1H16(143),G1H16(144),G1H16(145),G0H16(29),16)
  call HG1shiftOLR(G1H16(142),9,16)
  call Hotf_4pt_reduction(G2H16(38),RedSet_4(61),mass4set(:,2),  & 
G1H16(146),G1H16(147),G1H16(148),G1H16(149),G1H16(150),G0H16(30),16)
  call HG1shiftOLR(G1H16(147),9,16)
  call Hotf_4pt_reduction(G2H16(39),RedSet_4(61),mass4set(:,5),  & 
G1H16(151),G1H16(152),G1H16(153),G1H16(154),G1H16(155),G0H16(31),16)
  call HG1shiftOLR(G1H16(152),9,16)
  call Hotf_4pt_reduction(G2H16(40),RedSet_4(61),mass4set(:,2),  & 
G1H16(156),G1H16(157),G1H16(158),G1H16(159),G1H16(160),G0H16(32),16)
  call HG1shiftOLR(G1H16(157),9,16)
  call Hotf_4pt_reduction(G2H16(41),RedSet_4(9),mass4set(:,5),  & 
G1H16(161),G1H16(162),G1H16(163),G1H16(164),G1H16(165),G0H16(33),16)
  call HG1shiftOLR(G1H16(162),48,16)
  call Hotf_4pt_reduction(G2H16(42),RedSet_4(9),mass4set(:,6),  & 
G1H16(166),G1H16(167),G1H16(168),G1H16(169),G1H16(170),G0H16(34),16)
  call HG1shiftOLR(G1H16(167),48,16)
  call Hotf_4pt_reduction(G2H16(43),RedSet_4(9),mass4set(:,5),  & 
G1H16(171),G1H16(172),G1H16(173),G1H16(174),G1H16(175),G0H16(35),16)
  call HG1shiftOLR(G1H16(172),48,16)
  call Hotf_4pt_reduction(G2H16(44),RedSet_4(9),mass4set(:,6),  & 
G1H16(176),G1H16(177),G1H16(178),G1H16(179),G1H16(180),G0H16(36),16)
  call HG1shiftOLR(G1H16(177),48,16)
  call Hotf_4pt_reduction(G2H16(45),RedSet_4(9),mass4set(:,5),  & 
G1H16(181),G1H16(182),G1H16(183),G1H16(184),G1H16(185),G0H16(37),16)
  call HG1shiftOLR(G1H16(182),48,16)
  call Hotf_4pt_reduction(G2H16(46),RedSet_4(9),mass4set(:,2),  & 
G1H16(186),G1H16(187),G1H16(188),G1H16(189),G1H16(190),G0H16(38),16)
  call HG1shiftOLR(G1H16(187),48,16)
  call Hotf_4pt_reduction(G2H16(47),RedSet_4(9),mass4set(:,5),  & 
G1H16(191),G1H16(192),G1H16(193),G1H16(194),G1H16(195),G0H16(39),16)
  call HG1shiftOLR(G1H16(192),48,16)
  call Hotf_4pt_reduction(G2H16(48),RedSet_4(9),mass4set(:,2),  & 
G1H16(196),G1H16(197),G1H16(198),G1H16(199),G1H16(200),G0H16(40),16)
  call HG1shiftOLR(G1H16(197),48,16)
  call Hotf_4pt_reduction(G2H16(49),RedSet_4(8),mass4set(:,5),  & 
G1H16(201),G1H16(202),G1H16(203),G1H16(204),G1H16(205),G0H16(41),16)
  call HG1shiftOLR(G1H16(202),48,16)
  call Hotf_4pt_reduction(G2H16(50),RedSet_4(8),mass4set(:,6),  & 
G1H16(206),G1H16(207),G1H16(208),G1H16(209),G1H16(210),G0H16(42),16)
  call HG1shiftOLR(G1H16(207),48,16)
  call Hotf_4pt_reduction(G2H16(51),RedSet_4(8),mass4set(:,5),  & 
G1H16(211),G1H16(212),G1H16(213),G1H16(214),G1H16(215),G0H16(43),16)
  call HG1shiftOLR(G1H16(212),48,16)
  call Hotf_4pt_reduction(G2H16(52),RedSet_4(8),mass4set(:,6),  & 
G1H16(216),G1H16(217),G1H16(218),G1H16(219),G1H16(220),G0H16(44),16)
  call HG1shiftOLR(G1H16(217),48,16)
  call Hotf_4pt_reduction(G2H16(53),RedSet_4(8),mass4set(:,5),  & 
G1H16(221),G1H16(222),G1H16(223),G1H16(224),G1H16(225),G0H16(45),16)
  call HG1shiftOLR(G1H16(222),48,16)
  call Hotf_4pt_reduction(G2H16(54),RedSet_4(8),mass4set(:,2),  & 
G1H16(226),G1H16(227),G1H16(228),G1H16(229),G1H16(230),G0H16(46),16)
  call HG1shiftOLR(G1H16(227),48,16)
  call Hotf_4pt_reduction(G2H16(55),RedSet_4(8),mass4set(:,5),  & 
G1H16(231),G1H16(232),G1H16(233),G1H16(234),G1H16(235),G0H16(47),16)
  call HG1shiftOLR(G1H16(232),48,16)
  call Hotf_4pt_reduction(G2H16(56),RedSet_4(8),mass4set(:,2),  & 
G1H16(236),G1H16(237),G1H16(238),G1H16(239),G1H16(240),G0H16(48),16)
  call HG1shiftOLR(G1H16(237),48,16)
  call Hloop_AQ_V(ntryL,G2H16(57),wf8(:,24),G2H2(55),m3h8x2(:,5),heltab2x16(:,:,65))
  call Hloop_QA_V(ntryL,G2H16(58),ex6(:),G2H8(11),m3h2x8(:,17),heltab2x16(:,:,66))
  call Hotf_4pt_reduction(G2H32(6),RedSet_4(5),mass4set(:,1),  & 
G1H32(26),G1H32(27),G1H32(28),G1H32(29),G1H32(30),32)
  call HG1shiftOLR(G1H32(27),41,32)
  call Hloop_QA_V(ntryL,G2H16(59),wf8(:,20),G2H2(56),m3h8x2(:,6),heltab2x16(:,:,67))
  call Hloop_AQ_V(ntryL,G2H16(60),ex5(:),G2H8(9),m3h2x8(:,18),heltab2x16(:,:,68))
  call Hloop_AQ_V(ntryL,G2H16(61),wf8(:,26),G2H2(57),m3h8x2(:,7),heltab2x16(:,:,69))
  call Hloop_QA_V(ntryL,G2H16(62),ex6(:),G2H8(15),m3h2x8(:,19),heltab2x16(:,:,70))
  call Hotf_4pt_reduction(G2H32(7),RedSet_4(4),mass4set(:,1),  & 
G1H32(31),G1H32(32),G1H32(33),G1H32(34),G1H32(35),32)
  call HG1shiftOLR(G1H32(32),38,32)
  call Hloop_QA_V(ntryL,G2H16(63),wf8(:,22),G2H2(58),m3h8x2(:,8),heltab2x16(:,:,71))
  call Hloop_AQ_V(ntryL,G2H16(64),ex5(:),G2H8(16),m3h2x8(:,20),heltab2x16(:,:,72))
  call Hotf_4pt_reduction(G2H32(8),RedSet_4(1),mass4set(:,1),  & 
G1H32(36),G1H32(37),G1H32(38),G1H32(39),G1H32(40),32)
  call HG1shiftOLR(G1H32(37),32,32)
  call Hotf_4pt_reduction(G2H32(9),RedSet_4(1),mass4set(:,1),  & 
G1H32(41),G1H32(42),G1H32(43),G1H32(44),G1H32(45),32)
  call HG1shiftOLR(G1H32(42),32,32)
  call Hotf_4pt_reduction(G2H32(10),RedSet_4(1),mass4set(:,1),  & 
G1H32(46),G1H32(47),G1H32(48),G1H32(49),G1H32(50),32)
  call HG1shiftOLR(G1H32(47),32,32)
  call Hotf_4pt_reduction(G2H32(11),RedSet_4(1),mass4set(:,1),  & 
G1H32(51),G1H32(52),G1H32(53),G1H32(54),G1H32(55),32)
  call HG1shiftOLR(G1H32(52),32,32)
  call Hotf_4pt_reduction(G2H32(12),RedSet_4(1),mass4set(:,1),  & 
G1H32(56),G1H32(57),G1H32(58),G1H32(59),G1H32(60),32)
  call HG1shiftOLR(G1H32(57),32,32)
  call Hotf_4pt_reduction(G2H32(13),RedSet_4(1),mass4set(:,1),  & 
G1H32(61),G1H32(62),G1H32(63),G1H32(64),G1H32(65),32)
  call HG1shiftOLR(G1H32(62),32,32)
  call Hotf_4pt_reduction(G2H32(14),RedSet_4(1),mass4set(:,1),  & 
G1H32(66),G1H32(67),G1H32(68),G1H32(69),G1H32(70),32)
  call HG1shiftOLR(G1H32(67),32,32)
  call Hloop_QZ_A(ntryL,G1H8(7),wf4(:,4),G1H2(23),ngZd,m3h4x2(:,41),heltab2x8(:,:,73))
  call Hloop_Q_A(ntryL,G1H2(23),95,nMB,G2H2(59),n2h2(37))
call HGT_raise_alpha_OLR(G1H8(8),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(8),ex6(:),G1H4(18),m3h2x4(:,33),heltab2x8(:,:,74))
  call Hloop_QZ_A(ntryL,G1H8(12),wf4(:,4),G1H2(24),ngZd,m3h4x2(:,42),heltab2x8(:,:,75))
  call Hloop_Q_A(ntryL,G1H2(24),95,nMB,G2H2(60),n2h2(38))
  call Hloop_QZ_A(ntryL,G1H8(13),wf4(:,4),G1H2(29),ngZd,m3h4x2(:,43),heltab2x8(:,:,76))
  call Hloop_Q_A(ntryL,G1H2(29),95,nMB,G2H2(61),n2h2(39))
  call Hloop_QZ_A(ntryL,G1H8(14),wf4(:,5),G1H2(30),ngZd,m3h4x2(:,44),heltab2x8(:,:,77))
  call Hloop_Q_A(ntryL,G1H2(30),95,nMB,G2H2(62),n2h2(40))
call HGT_raise_alpha_OLR(G1H8(17),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(17),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(17),ex6(:),G1H4(29),m3h2x4(:,34),heltab2x8(:,:,78))
  call Hloop_QZ_A(ntryL,G1H8(19),wf4(:,5),G1H2(34),ngZd,m3h4x2(:,45),heltab2x8(:,:,79))
  call Hloop_Q_A(ntryL,G1H2(34),95,nMB,G2H2(63),n2h2(41))
  call Hloop_QZ_A(ntryL,G1H8(20),wf4(:,5),G1H2(35),ngZd,m3h4x2(:,46),heltab2x8(:,:,80))
  call Hloop_Q_A(ntryL,G1H2(35),95,nMB,G2H2(64),n2h2(42))
  call Hloop_AZ_Q(ntryL,G1H8(23),wf4(:,4),G1H2(40),ngZd,m3h4x2(:,47),heltab2x8(:,:,81))
  call Hloop_A_Q(ntryL,G1H2(40),111,nMB,G2H2(65),n2h2(43))
call HGT_raise_alpha_OLR(G1H8(24),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(24),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(24),ex5(:),G1H4(40),m3h2x4(:,35),heltab2x8(:,:,82))
  call Hloop_AZ_Q(ntryL,G1H8(26),wf4(:,4),G1H2(41),ngZd,m3h4x2(:,48),heltab2x8(:,:,83))
  call Hloop_A_Q(ntryL,G1H2(41),111,nMB,G2H2(66),n2h2(44))
  call Hloop_AZ_Q(ntryL,G1H8(31),wf4(:,4),G1H2(45),ngZd,m3h4x2(:,49),heltab2x8(:,:,84))
  call Hloop_A_Q(ntryL,G1H2(45),111,nMB,G2H2(67),n2h2(45))
  call Hloop_AZ_Q(ntryL,G1H8(36),wf4(:,5),G1H2(46),ngZd,m3h4x2(:,50),heltab2x8(:,:,85))
  call Hloop_A_Q(ntryL,G1H2(46),111,nMB,G2H2(68),n2h2(46))
call HGT_raise_alpha_OLR(G1H8(32),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(32),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(32),ex5(:),G1H4(51),m3h2x4(:,36),heltab2x8(:,:,86))
  call Hloop_AZ_Q(ntryL,G1H8(37),wf4(:,5),G1H2(51),ngZd,m3h4x2(:,51),heltab2x8(:,:,87))
  call Hloop_A_Q(ntryL,G1H2(51),111,nMB,G2H2(69),n2h2(47))
  call Hloop_AZ_Q(ntryL,G1H8(40),wf4(:,5),G1H2(52),ngZd,m3h4x2(:,52),heltab2x8(:,:,88))
  call Hloop_A_Q(ntryL,G1H2(52),111,nMB,G2H2(70),n2h2(48))
  call Hloop_QZ_A(ntryL,G1H8(41),wf4(:,5),G1H2(56),ngZd,m3h4x2(:,53),heltab2x8(:,:,89))
  call Hloop_Q_A(ntryL,G1H2(56),95,nMB,G2H2(71),n2h2(49))
call HGT_raise_alpha_OLR(G1H8(42),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(42),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(42),ex6(:),G1H4(13),m3h2x4(:,37),heltab2x8(:,:,90))
  call Hloop_QZ_A(ntryL,G1H8(52),wf4(:,5),G1H2(57),ngZd,m3h4x2(:,54),heltab2x8(:,:,91))
  call Hloop_Q_A(ntryL,G1H2(57),95,nMB,G2H2(72),n2h2(50))
  call Hloop_QZ_A(ntryL,G1H8(48),wf4(:,5),G1H2(62),ngZd,m3h4x2(:,55),heltab2x8(:,:,92))
  call Hloop_Q_A(ntryL,G1H2(62),95,nMB,G2H2(73),n2h2(51))
  call Hloop_QZ_A(ntryL,G1H8(51),wf4(:,4),G1H2(63),ngZd,m3h4x2(:,56),heltab2x8(:,:,93))
  call Hloop_Q_A(ntryL,G1H2(63),95,nMB,G2H2(74),n2h2(52))
call HGT_raise_alpha_OLR(G1H8(53),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(53),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(53),ex6(:),G1H4(14),m3h2x4(:,38),heltab2x8(:,:,94))
  call Hloop_QZ_A(ntryL,G1H8(57),wf4(:,4),G1H2(67),ngZd,m3h4x2(:,57),heltab2x8(:,:,95))
  call Hloop_Q_A(ntryL,G1H2(67),95,nMB,G2H2(75),n2h2(53))
  call Hloop_QZ_A(ntryL,G1H8(58),wf4(:,4),G1H2(68),ngZd,m3h4x2(:,58),heltab2x8(:,:,96))
  call Hloop_Q_A(ntryL,G1H2(68),95,nMB,G2H2(76),n2h2(54))
  call Hloop_QZ_A(ntryL,G1H8(63),wf4(:,11),G1H2(73),ngZd,m3h4x2(:,59),heltab2x8(:,:,97))
  call Hloop_Q_A(ntryL,G1H2(73),95,nMB,G2H2(77),n2h2(55))
call HGT_raise_alpha_OLR(G1H8(68),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(68),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(68),ex6(:),G1H4(19),m3h2x4(:,39),heltab2x8(:,:,98))
  call Hloop_QZ_A(ntryL,G1H8(67),wf4(:,11),G1H2(74),ngZd,m3h4x2(:,60),heltab2x8(:,:,99))
  call Hloop_Q_A(ntryL,G1H2(74),95,nMB,G2H2(78),n2h2(56))
  call Hloop_QZ_A(ntryL,G1H8(69),wf4(:,11),G1H2(78),ngZd,m3h4x2(:,61),heltab2x8(:,:,100))
  call Hloop_Q_A(ntryL,G1H2(78),95,nMB,G2H2(79),n2h2(57))
  call Hloop_QZ_A(ntryL,G1H8(72),wf4(:,12),G1H2(79),ngZd,m3h4x2(:,62),heltab2x8(:,:,101))
  call Hloop_Q_A(ntryL,G1H2(79),95,nMB,G2H2(80),n2h2(58))
call HGT_raise_alpha_OLR(G1H8(73),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(73),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(73),ex6(:),G1H4(20),m3h2x4(:,40),heltab2x8(:,:,102))
  call Hloop_QZ_A(ntryL,G1H8(79),wf4(:,12),G1H2(84),ngZd,m3h4x2(:,63),heltab2x8(:,:,103))
  call Hloop_Q_A(ntryL,G1H2(84),95,nMB,G2H2(81),n2h2(59))
  call Hloop_QZ_A(ntryL,G1H8(84),wf4(:,12),G1H2(85),ngZd,m3h4x2(:,64),heltab2x8(:,:,104))
  call Hloop_Q_A(ntryL,G1H2(85),95,nMB,G2H2(82),n2h2(60))
  call Hloop_AZ_Q(ntryL,G1H8(80),wf4(:,11),G1H2(6),ngZd,m3h4x2(:,65),heltab2x8(:,:,105))
  call Hloop_A_Q(ntryL,G1H2(6),111,nMB,G2H2(83),n2h2(61))
call HGT_raise_alpha_OLR(G1H8(83),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(83),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(83),ex5(:),G1H4(24),m3h2x4(:,41),heltab2x8(:,:,106))
  call Hloop_AZ_Q(ntryL,G1H8(88),wf4(:,11),G1H2(17),ngZd,m3h4x2(:,66),heltab2x8(:,:,107))
  call Hloop_A_Q(ntryL,G1H2(17),111,nMB,G2H2(84),n2h2(62))
  call Hloop_AZ_Q(ntryL,G1H8(29),wf4(:,11),G1H2(28),ngZd,m3h4x2(:,67),heltab2x8(:,:,108))
  call Hloop_A_Q(ntryL,G1H2(28),111,nMB,G2H2(85),n2h2(63))
  call Hloop_AZ_Q(ntryL,G1H8(30),wf4(:,12),G1H2(39),ngZd,m3h4x2(:,68),heltab2x8(:,:,109))
  call Hloop_A_Q(ntryL,G1H2(39),111,nMB,G2H2(86),n2h2(64))
call HGT_raise_alpha_OLR(G1H8(45),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(45),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(45),ex5(:),G1H4(25),m3h2x4(:,42),heltab2x8(:,:,110))
  call Hloop_AZ_Q(ntryL,G1H8(61),wf4(:,12),G1H2(50),ngZd,m3h4x2(:,69),heltab2x8(:,:,111))
  call Hloop_A_Q(ntryL,G1H2(50),111,nMB,G2H2(87),n2h2(65))
  call Hloop_AZ_Q(ntryL,G1H8(62),wf4(:,12),G1H2(61),ngZd,m3h4x2(:,70),heltab2x8(:,:,112))
  call Hloop_A_Q(ntryL,G1H2(61),111,nMB,G2H2(88),n2h2(66))
  call Hloop_QZ_A(ntryL,G1H8(77),wf4(:,12),G1H2(72),ngZd,m3h4x2(:,71),heltab2x8(:,:,113))
  call Hloop_Q_A(ntryL,G1H2(72),95,nMB,G2H2(89),n2h2(67))
call HGT_raise_alpha_OLR(G1H8(78),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(78),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(78),ex6(:),G1H4(30),m3h2x4(:,43),heltab2x8(:,:,114))
  call Hloop_QZ_A(ntryL,G1H8(2),wf4(:,12),G1H2(83),ngZd,m3h4x2(:,72),heltab2x8(:,:,115))
  call Hloop_Q_A(ntryL,G1H2(83),95,nMB,G2H2(90),n2h2(68))
  call Hloop_QZ_A(ntryL,G1H8(5),wf4(:,12),G1H2(1),ngZd,m3h4x2(:,73),heltab2x8(:,:,116))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(91),n2h2(69))
  call Hloop_QZ_A(ntryL,G1H8(6),wf4(:,11),G1H2(2),ngZd,m3h4x2(:,74),heltab2x8(:,:,117))
  call Hloop_Q_A(ntryL,G1H2(2),95,nMB,G2H2(92),n2h2(70))
call HGT_raise_alpha_OLR(G1H8(43),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(43),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(43),ex6(:),G1H4(31),m3h2x4(:,44),heltab2x8(:,:,118))
  call Hloop_QZ_A(ntryL,G1H8(28),wf4(:,11),G1H2(7),ngZd,m3h4x2(:,75),heltab2x8(:,:,119))
  call Hloop_Q_A(ntryL,G1H2(7),95,nMB,G2H2(93),n2h2(71))
  call Hloop_QZ_A(ntryL,G1H8(44),wf4(:,11),G1H2(8),ngZd,m3h4x2(:,76),heltab2x8(:,:,120))
  call Hloop_Q_A(ntryL,G1H2(8),95,nMB,G2H2(94),n2h2(72))
  call Hloop_AV_Q(ntryL,G1H16(30),wf4(:,13),G1H4(35),m3h4x4(:,45),heltab2x16(:,:,73))
  call Hloop_A_Q(ntryL,G1H4(35),117,0,G2H4(2),n2h4(85))
call HGT_OLR(G1H16(31),1,1,16)
call HGT_invQ_OLR(G1H16(31),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(31),-10,0,G2H16(9),n2h16(85))
  call Hloop_QZ_A(ntryL,G2H16(9),wf4(:,5),G2H4(38),ngZu,m3h4x4(:,46),heltab2x16(:,:,74))
  call Hloop_AV_Q(ntryL,G1H16(34),wf4(:,13),G1H4(36),m3h4x4(:,47),heltab2x16(:,:,75))
  call Hloop_A_Q(ntryL,G1H4(36),117,0,G2H4(36),n2h4(86))
  call Hloop_AV_Q(ntryL,G1H16(35),wf4(:,13),G1H4(41),m3h4x4(:,48),heltab2x16(:,:,76))
  call Hloop_A_Q(ntryL,G1H4(41),117,0,G2H4(34),n2h4(87))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,13),G0H4(1),m3h4x4(:,49),heltab2x16(:,:,77))
  call Hloop_A_Q(ntryL,G0H4(1),117,0,G1H4(42),n2h4(88))
  call Hloop_AV_Q(ntryL,G1H16(36),wf4(:,13),G1H4(46),m3h4x4(:,50),heltab2x16(:,:,78))
  call Hloop_A_Q(ntryL,G1H4(46),117,nMT,G2H4(16),n2h4(89))
call HGT_OLR(G1H16(37),1,1,16)
call HGT_invQ_OLR(G1H16(37),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(37),-10,nMT,G2H16(10),n2h16(86))
  call Hloop_QZ_A(ntryL,G2H16(10),wf4(:,5),G2H4(12),ngZu,m3h4x4(:,51),heltab2x16(:,:,79))
  call Hloop_AV_Q(ntryL,G1H16(40),wf4(:,13),G1H4(47),m3h4x4(:,52),heltab2x16(:,:,80))
  call Hloop_A_Q(ntryL,G1H4(47),117,nMT,G2H4(8),n2h4(90))
  call Hloop_AV_Q(ntryL,G1H16(41),wf4(:,13),G1H4(52),m3h4x4(:,53),heltab2x16(:,:,81))
  call Hloop_A_Q(ntryL,G1H4(52),117,nMT,G2H4(4),n2h4(91))
  call Hloop_AV_Q(ntryL,G0H16(2),wf4(:,13),G0H4(1),m3h4x4(:,54),heltab2x16(:,:,82))
  call Hloop_A_Q(ntryL,G0H4(1),117,nMT,G1H4(53),n2h4(92))
  call Hloop_QV_A(ntryL,G1H16(42),wf4(:,13),G1H4(35),m3h4x4(:,55),heltab2x16(:,:,83))
  call Hloop_Q_A(ntryL,G1H4(35),117,0,G2H4(32),n2h4(93))
call HGT_OLR(G1H16(43),1,1,16)
call HGT_invQ_OLR(G1H16(43),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(43),-10,0,G2H16(11),n2h16(87))
  call Hloop_AZ_Q(ntryL,G2H16(11),wf4(:,5),G2H4(29),ngZu,m3h4x4(:,56),heltab2x16(:,:,84))
  call Hloop_QV_A(ntryL,G1H16(46),wf4(:,13),G1H4(36),m3h4x4(:,57),heltab2x16(:,:,85))
  call Hloop_Q_A(ntryL,G1H4(36),117,0,G2H4(30),n2h4(94))
  call Hloop_QV_A(ntryL,G1H16(47),wf4(:,13),G1H4(41),m3h4x4(:,58),heltab2x16(:,:,86))
  call Hloop_Q_A(ntryL,G1H4(41),117,0,G2H4(26),n2h4(95))
  call Hloop_QV_A(ntryL,G0H16(3),wf4(:,13),G0H4(1),m3h4x4(:,59),heltab2x16(:,:,87))
  call Hloop_Q_A(ntryL,G0H4(1),117,0,G1H4(46),n2h4(96))
  call Hloop_QV_A(ntryL,G1H16(48),wf4(:,13),G1H4(47),m3h4x4(:,60),heltab2x16(:,:,88))
  call Hloop_Q_A(ntryL,G1H4(47),117,nMT,G2H4(14),n2h4(97))
call HGT_OLR(G1H16(3),1,1,16)
call HGT_invQ_OLR(G1H16(3),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(3),-10,nMT,G2H16(12),n2h16(88))
  call Hloop_AZ_Q(ntryL,G2H16(12),wf4(:,5),G2H4(10),ngZu,m3h4x4(:,61),heltab2x16(:,:,89))
  call Hloop_QV_A(ntryL,G1H16(15),wf4(:,13),G1H4(52),m3h4x4(:,62),heltab2x16(:,:,90))
  call Hloop_Q_A(ntryL,G1H4(52),117,nMT,G2H4(39),n2h4(98))
  call Hloop_QV_A(ntryL,G1H16(21),wf4(:,13),G1H4(35),m3h4x4(:,63),heltab2x16(:,:,91))
  call Hloop_Q_A(ntryL,G1H4(35),117,nMT,G2H4(40),n2h4(99))
  call Hloop_QV_A(ntryL,G0H16(4),wf4(:,13),G0H4(1),m3h4x4(:,64),heltab2x16(:,:,92))
  call Hloop_Q_A(ntryL,G0H4(1),117,nMT,G1H4(36),n2h4(100))
  call Hloop_AV_Q(ntryL,G1H16(27),wf4(:,13),G1H4(41),m3h4x4(:,65),heltab2x16(:,:,93))
  call Hloop_A_Q(ntryL,G1H4(41),117,0,G2H4(17),n2h4(101))
call HGT_OLR(G1H16(33),1,1,16)
call HGT_invQ_OLR(G1H16(33),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(33),-10,0,G2H16(1),n2h16(89))
  call Hloop_QZ_A(ntryL,G2H16(1),wf4(:,5),G2H4(19),ngZd,m3h4x4(:,66),heltab2x16(:,:,94))
  call Hloop_AV_Q(ntryL,G1H16(45),wf4(:,13),G1H4(47),m3h4x4(:,67),heltab2x16(:,:,95))
  call Hloop_A_Q(ntryL,G1H4(47),117,0,G2H4(20),n2h4(102))
  call Hloop_AV_Q(ntryL,G1H16(6),wf4(:,13),G1H4(52),m3h4x4(:,68),heltab2x16(:,:,96))
  call Hloop_A_Q(ntryL,G1H4(52),117,0,G2H4(21),n2h4(103))
  call Hloop_AV_Q(ntryL,G0H16(5),wf4(:,13),G0H4(1),m3h4x4(:,69),heltab2x16(:,:,97))
  call Hloop_A_Q(ntryL,G0H4(1),117,0,G1H4(35),n2h4(104))
  call Hloop_AV_Q(ntryL,G1H16(7),wf4(:,13),G1H4(41),m3h4x4(:,70),heltab2x16(:,:,98))
  call Hloop_A_Q(ntryL,G1H4(41),117,nMB,G2H4(23),n2h4(105))
call HGT_OLR(G1H16(8),1,1,16)
call HGT_invQ_OLR(G1H16(8),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(8),-10,nMB,G2H16(2),n2h16(90))
  call Hloop_QZ_A(ntryL,G2H16(2),wf4(:,5),G2H4(24),ngZd,m3h4x4(:,71),heltab2x16(:,:,99))
  call Hloop_AV_Q(ntryL,G1H16(11),wf4(:,13),G1H4(47),m3h4x4(:,72),heltab2x16(:,:,100))
  call Hloop_A_Q(ntryL,G1H4(47),117,nMB,G2H4(25),n2h4(106))
  call Hloop_AV_Q(ntryL,G1H16(12),wf4(:,13),G1H4(52),m3h4x4(:,73),heltab2x16(:,:,101))
  call Hloop_A_Q(ntryL,G1H4(52),117,nMB,G2H4(27),n2h4(107))
  call Hloop_AV_Q(ntryL,G0H16(6),wf4(:,13),G0H4(1),m3h4x4(:,74),heltab2x16(:,:,102))
  call Hloop_A_Q(ntryL,G0H4(1),117,nMB,G1H4(41),n2h4(108))
  call Hloop_QV_A(ntryL,G1H16(13),wf4(:,13),G1H4(47),m3h4x4(:,75),heltab2x16(:,:,103))
  call Hloop_Q_A(ntryL,G1H4(47),117,0,G2H4(41),n2h4(109))
call HGT_OLR(G1H16(14),1,1,16)
call HGT_invQ_OLR(G1H16(14),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(14),-10,0,G2H16(3),n2h16(91))
  call Hloop_AZ_Q(ntryL,G2H16(3),wf4(:,5),G2H4(42),ngZd,m3h4x4(:,76),heltab2x16(:,:,104))
  call Hloop_QV_A(ntryL,G1H16(17),wf4(:,13),G1H4(52),m3h4x4(:,77),heltab2x16(:,:,105))
  call Hloop_Q_A(ntryL,G1H4(52),117,0,G2H4(43),n2h4(110))
  call Hloop_QV_A(ntryL,G1H16(18),wf4(:,13),G1H4(47),m3h4x4(:,78),heltab2x16(:,:,106))
  call Hloop_Q_A(ntryL,G1H4(47),117,0,G2H4(44),n2h4(111))
  call Hloop_QV_A(ntryL,G0H16(7),wf4(:,13),G0H4(1),m3h4x4(:,79),heltab2x16(:,:,107))
  call Hloop_Q_A(ntryL,G0H4(1),117,0,G1H4(52),n2h4(112))
  call Hloop_QV_A(ntryL,G1H16(19),wf4(:,13),G1H4(47),m3h4x4(:,80),heltab2x16(:,:,108))
  call Hloop_Q_A(ntryL,G1H4(47),117,nMB,G2H4(45),n2h4(113))
call HGT_OLR(G1H16(20),1,1,16)
call HGT_invQ_OLR(G1H16(20),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(20),-10,nMB,G2H16(4),n2h16(92))
  call Hloop_AZ_Q(ntryL,G2H16(4),wf4(:,5),G2H4(46),ngZd,m3h4x4(:,81),heltab2x16(:,:,109))
  call Hloop_QV_A(ntryL,G1H16(23),wf4(:,13),G1H4(47),m3h4x4(:,82),heltab2x16(:,:,110))
  call Hloop_Q_A(ntryL,G1H4(47),117,nMB,G2H4(47),n2h4(114))
  call Hloop_QV_A(ntryL,G1H16(24),wf4(:,13),G1H4(47),m3h4x4(:,83),heltab2x16(:,:,111))
  call Hloop_Q_A(ntryL,G1H4(47),117,nMB,G2H4(48),n2h4(115))
  call Hloop_QV_A(ntryL,G0H16(8),wf4(:,13),G0H4(1),m3h4x4(:,84),heltab2x16(:,:,112))
  call Hloop_Q_A(ntryL,G0H4(1),117,nMB,G1H4(47),n2h4(116))
  call Hloop_AZ_Q(ntryL,G1H16(25),wf4(:,5),G1H4(57),ngZu,m3h4x4(:,85),heltab2x16(:,:,113))
  call Hloop_A_Q(ntryL,G1H4(57),79,0,G2H4(49),n2h4(117))
call HGT_OLR(G1H16(26),1,1,16)
call HGT_invQ_OLR(G1H16(26),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(26),-48,0,G2H16(5),n2h16(93))
  call Hloop_QV_A(ntryL,G2H16(5),wf4(:,13),G2H4(50),m3h4x4(:,86),heltab2x16(:,:,114))
  call Hloop_AZ_Q(ntryL,G1H16(29),wf4(:,5),G1H4(57),ngZu,m3h4x4(:,87),heltab2x16(:,:,115))
  call Hloop_A_Q(ntryL,G1H4(57),79,0,G2H4(51),n2h4(118))
  call Hloop_AZ_Q(ntryL,G1H16(1),wf4(:,5),G1H4(57),ngZu,m3h4x4(:,88),heltab2x16(:,:,116))
  call Hloop_A_Q(ntryL,G1H4(57),79,0,G2H4(52),n2h4(119))
  call Hloop_AZ_Q(ntryL,G0H16(9),wf4(:,5),G0H4(1),ngZu,m3h4x4(:,89),heltab2x16(:,:,117))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(57),n2h4(120))
  call Hloop_AZ_Q(ntryL,G1H16(2),wf4(:,5),G1H4(58),ngZu,m3h4x4(:,90),heltab2x16(:,:,118))
  call Hloop_A_Q(ntryL,G1H4(58),79,nMT,G2H4(53),n2h4(121))
call HGT_OLR(G1H16(4),1,1,16)
call HGT_invQ_OLR(G1H16(4),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(4),-48,nMT,G2H16(6),n2h16(94))
  call Hloop_QV_A(ntryL,G2H16(6),wf4(:,13),G2H4(54),m3h4x4(:,91),heltab2x16(:,:,119))
  call Hloop_AZ_Q(ntryL,G1H16(49),wf4(:,5),G1H4(58),ngZu,m3h4x4(:,92),heltab2x16(:,:,120))
  call Hloop_A_Q(ntryL,G1H4(58),79,nMT,G2H4(55),n2h4(122))
  call Hloop_AZ_Q(ntryL,G1H16(50),wf4(:,5),G1H4(58),ngZu,m3h4x4(:,93),heltab2x16(:,:,121))
  call Hloop_A_Q(ntryL,G1H4(58),79,nMT,G2H4(56),n2h4(123))
  call Hloop_AZ_Q(ntryL,G0H16(10),wf4(:,5),G0H4(1),ngZu,m3h4x4(:,94),heltab2x16(:,:,122))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMT,G1H4(58),n2h4(124))
  call Hloop_QZ_A(ntryL,G1H16(51),wf4(:,5),G1H4(59),ngZu,m3h4x4(:,95),heltab2x16(:,:,123))
  call Hloop_Q_A(ntryL,G1H4(59),79,0,G2H4(57),n2h4(125))
call HGT_OLR(G1H16(52),1,1,16)
call HGT_invQ_OLR(G1H16(52),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(52),-48,0,G2H16(7),n2h16(95))
  call Hloop_AV_Q(ntryL,G2H16(7),wf4(:,13),G2H4(58),m3h4x4(:,96),heltab2x16(:,:,124))
  call Hloop_QZ_A(ntryL,G1H16(54),wf4(:,5),G1H4(59),ngZu,m3h4x4(:,97),heltab2x16(:,:,125))
  call Hloop_Q_A(ntryL,G1H4(59),79,0,G2H4(59),n2h4(126))
  call Hloop_QZ_A(ntryL,G1H16(55),wf4(:,5),G1H4(59),ngZu,m3h4x4(:,98),heltab2x16(:,:,126))
  call Hloop_Q_A(ntryL,G1H4(59),79,0,G2H4(60),n2h4(127))
  call Hloop_QZ_A(ntryL,G0H16(11),wf4(:,5),G0H4(1),ngZu,m3h4x4(:,99),heltab2x16(:,:,127))
  call Hloop_Q_A(ntryL,G0H4(1),79,0,G1H4(59),n2h4(128))
  call Hloop_QZ_A(ntryL,G1H16(56),wf4(:,5),G1H4(60),ngZu,m3h4x4(:,100),heltab2x16(:,:,128))
  call Hloop_Q_A(ntryL,G1H4(60),79,nMT,G2H4(61),n2h4(129))
call HGT_OLR(G1H16(57),1,1,16)
call HGT_invQ_OLR(G1H16(57),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(57),-48,nMT,G2H16(8),n2h16(96))
  call Hloop_AV_Q(ntryL,G2H16(8),wf4(:,13),G2H4(62),m3h4x4(:,101),heltab2x16(:,:,129))
  call Hloop_QZ_A(ntryL,G1H16(59),wf4(:,5),G1H4(60),ngZu,m3h4x4(:,102),heltab2x16(:,:,130))
  call Hloop_Q_A(ntryL,G1H4(60),79,nMT,G2H4(63),n2h4(130))
  call Hloop_QZ_A(ntryL,G1H16(60),wf4(:,5),G1H4(60),ngZu,m3h4x4(:,103),heltab2x16(:,:,131))
  call Hloop_Q_A(ntryL,G1H4(60),79,nMT,G2H4(64),n2h4(131))
  call Hloop_QZ_A(ntryL,G0H16(12),wf4(:,5),G0H4(1),ngZu,m3h4x4(:,104),heltab2x16(:,:,132))
  call Hloop_Q_A(ntryL,G0H4(1),79,nMT,G1H4(60),n2h4(132))
  call Hloop_AZ_Q(ntryL,G1H16(61),wf4(:,5),G1H4(61),ngZd,m3h4x4(:,105),heltab2x16(:,:,133))
  call Hloop_A_Q(ntryL,G1H4(61),79,0,G2H4(65),n2h4(133))
call HGT_OLR(G1H16(62),1,1,16)
call HGT_invQ_OLR(G1H16(62),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(62),-48,0,G2H16(13),n2h16(97))
  call Hloop_QV_A(ntryL,G2H16(13),wf4(:,13),G2H4(66),m3h4x4(:,106),heltab2x16(:,:,134))
  call Hloop_AZ_Q(ntryL,G1H16(64),wf4(:,5),G1H4(61),ngZd,m3h4x4(:,107),heltab2x16(:,:,135))
  call Hloop_A_Q(ntryL,G1H4(61),79,0,G2H4(67),n2h4(134))
  call Hloop_AZ_Q(ntryL,G1H16(65),wf4(:,5),G1H4(61),ngZd,m3h4x4(:,108),heltab2x16(:,:,136))
  call Hloop_A_Q(ntryL,G1H4(61),79,0,G2H4(68),n2h4(135))
  call Hloop_AZ_Q(ntryL,G0H16(13),wf4(:,5),G0H4(1),ngZd,m3h4x4(:,109),heltab2x16(:,:,137))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(61),n2h4(136))
  call Hloop_AZ_Q(ntryL,G1H16(66),wf4(:,5),G1H4(62),ngZd,m3h4x4(:,110),heltab2x16(:,:,138))
  call Hloop_A_Q(ntryL,G1H4(62),79,nMB,G2H4(69),n2h4(137))
call HGT_OLR(G1H16(67),1,1,16)
call HGT_invQ_OLR(G1H16(67),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(67),-48,nMB,G2H16(14),n2h16(98))
  call Hloop_QV_A(ntryL,G2H16(14),wf4(:,13),G2H4(70),m3h4x4(:,111),heltab2x16(:,:,139))
  call Hloop_AZ_Q(ntryL,G1H16(69),wf4(:,5),G1H4(62),ngZd,m3h4x4(:,112),heltab2x16(:,:,140))
  call Hloop_A_Q(ntryL,G1H4(62),79,nMB,G2H4(71),n2h4(138))
  call Hloop_AZ_Q(ntryL,G1H16(70),wf4(:,5),G1H4(62),ngZd,m3h4x4(:,113),heltab2x16(:,:,141))
  call Hloop_A_Q(ntryL,G1H4(62),79,nMB,G2H4(72),n2h4(139))
  call Hloop_AZ_Q(ntryL,G0H16(14),wf4(:,5),G0H4(1),ngZd,m3h4x4(:,114),heltab2x16(:,:,142))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(62),n2h4(140))
  call Hloop_QZ_A(ntryL,G1H16(71),wf4(:,5),G1H4(63),ngZd,m3h4x4(:,115),heltab2x16(:,:,143))
  call Hloop_Q_A(ntryL,G1H4(63),79,0,G2H4(73),n2h4(141))
call HGT_OLR(G1H16(72),1,1,16)
call HGT_invQ_OLR(G1H16(72),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(72),-48,0,G2H16(15),n2h16(99))
  call Hloop_AV_Q(ntryL,G2H16(15),wf4(:,13),G2H4(74),m3h4x4(:,116),heltab2x16(:,:,144))
  call Hloop_QZ_A(ntryL,G1H16(74),wf4(:,5),G1H4(63),ngZd,m3h4x4(:,117),heltab2x16(:,:,145))
  call Hloop_Q_A(ntryL,G1H4(63),79,0,G2H4(75),n2h4(142))
  call Hloop_QZ_A(ntryL,G1H16(75),wf4(:,5),G1H4(63),ngZd,m3h4x4(:,118),heltab2x16(:,:,146))
  call Hloop_Q_A(ntryL,G1H4(63),79,0,G2H4(76),n2h4(143))
  call Hloop_QZ_A(ntryL,G0H16(15),wf4(:,5),G0H4(1),ngZd,m3h4x4(:,119),heltab2x16(:,:,147))
  call Hloop_Q_A(ntryL,G0H4(1),79,0,G1H4(63),n2h4(144))
  call Hloop_QZ_A(ntryL,G1H16(76),wf4(:,5),G1H4(64),ngZd,m3h4x4(:,120),heltab2x16(:,:,148))
  call Hloop_Q_A(ntryL,G1H4(64),79,nMB,G2H4(77),n2h4(145))
call HGT_OLR(G1H16(77),1,1,16)
call HGT_invQ_OLR(G1H16(77),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(77),-48,nMB,G2H16(16),n2h16(100))
  call Hloop_AV_Q(ntryL,G2H16(16),wf4(:,13),G2H4(78),m3h4x4(:,121),heltab2x16(:,:,149))
  call Hloop_QZ_A(ntryL,G1H16(79),wf4(:,5),G1H4(64),ngZd,m3h4x4(:,122),heltab2x16(:,:,150))
  call Hloop_Q_A(ntryL,G1H4(64),79,nMB,G2H4(79),n2h4(146))
  call Hloop_QZ_A(ntryL,G1H16(80),wf4(:,5),G1H4(64),ngZd,m3h4x4(:,123),heltab2x16(:,:,151))
  call Hloop_Q_A(ntryL,G1H4(64),79,nMB,G2H4(80),n2h4(147))
  call Hloop_QZ_A(ntryL,G0H16(16),wf4(:,5),G0H4(1),ngZd,m3h4x4(:,124),heltab2x16(:,:,152))
  call Hloop_Q_A(ntryL,G0H4(1),79,nMB,G1H4(64),n2h4(148))
  call Hloop_AZ_Q(ntryL,G1H16(81),wf4(:,4),G1H4(65),ngZu,m3h4x4(:,125),heltab2x16(:,:,153))
  call Hloop_A_Q(ntryL,G1H4(65),79,0,G2H4(81),n2h4(149))
call HGT_OLR(G1H16(82),1,1,16)
call HGT_invQ_OLR(G1H16(82),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(82),-48,0,G2H16(17),n2h16(101))
  call Hloop_QV_A(ntryL,G2H16(17),wf4(:,13),G2H4(82),m3h4x4(:,126),heltab2x16(:,:,154))
  call Hloop_AZ_Q(ntryL,G1H16(84),wf4(:,4),G1H4(65),ngZu,m3h4x4(:,127),heltab2x16(:,:,155))
  call Hloop_A_Q(ntryL,G1H4(65),79,0,G2H4(83),n2h4(150))
  call Hloop_AZ_Q(ntryL,G1H16(85),wf4(:,4),G1H4(65),ngZu,m3h4x4(:,128),heltab2x16(:,:,156))
  call Hloop_A_Q(ntryL,G1H4(65),79,0,G2H4(84),n2h4(151))
  call Hloop_AZ_Q(ntryL,G0H16(17),wf4(:,4),G0H4(1),ngZu,m3h4x4(:,129),heltab2x16(:,:,157))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(65),n2h4(152))
  call Hloop_AZ_Q(ntryL,G1H16(86),wf4(:,4),G1H4(66),ngZu,m3h4x4(:,130),heltab2x16(:,:,158))
  call Hloop_A_Q(ntryL,G1H4(66),79,nMT,G2H4(85),n2h4(153))
call HGT_OLR(G1H16(87),1,1,16)
call HGT_invQ_OLR(G1H16(87),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(87),-48,nMT,G2H16(18),n2h16(102))
  call Hloop_QV_A(ntryL,G2H16(18),wf4(:,13),G2H4(86),m3h4x4(:,131),heltab2x16(:,:,159))
  call Hloop_AZ_Q(ntryL,G1H16(89),wf4(:,4),G1H4(66),ngZu,m3h4x4(:,132),heltab2x16(:,:,160))
  call Hloop_A_Q(ntryL,G1H4(66),79,nMT,G2H4(87),n2h4(154))
  call Hloop_AZ_Q(ntryL,G1H16(90),wf4(:,4),G1H4(66),ngZu,m3h4x4(:,133),heltab2x16(:,:,161))
  call Hloop_A_Q(ntryL,G1H4(66),79,nMT,G2H4(88),n2h4(155))
  call Hloop_AZ_Q(ntryL,G0H16(18),wf4(:,4),G0H4(1),ngZu,m3h4x4(:,134),heltab2x16(:,:,162))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMT,G1H4(66),n2h4(156))
  call Hloop_QZ_A(ntryL,G1H16(91),wf4(:,4),G1H4(67),ngZu,m3h4x4(:,135),heltab2x16(:,:,163))
  call Hloop_Q_A(ntryL,G1H4(67),79,0,G2H4(89),n2h4(157))
call HGT_OLR(G1H16(92),1,1,16)
call HGT_invQ_OLR(G1H16(92),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(92),-48,0,G2H16(19),n2h16(103))
  call Hloop_AV_Q(ntryL,G2H16(19),wf4(:,13),G2H4(90),m3h4x4(:,136),heltab2x16(:,:,164))
  call Hloop_QZ_A(ntryL,G1H16(94),wf4(:,4),G1H4(67),ngZu,m3h4x4(:,137),heltab2x16(:,:,165))
  call Hloop_Q_A(ntryL,G1H4(67),79,0,G2H4(91),n2h4(158))
  call Hloop_QZ_A(ntryL,G1H16(95),wf4(:,4),G1H4(67),ngZu,m3h4x4(:,138),heltab2x16(:,:,166))
  call Hloop_Q_A(ntryL,G1H4(67),79,0,G2H4(92),n2h4(159))
  call Hloop_QZ_A(ntryL,G0H16(19),wf4(:,4),G0H4(1),ngZu,m3h4x4(:,139),heltab2x16(:,:,167))
  call Hloop_Q_A(ntryL,G0H4(1),79,0,G1H4(67),n2h4(160))
  call Hloop_QZ_A(ntryL,G1H16(96),wf4(:,4),G1H4(68),ngZu,m3h4x4(:,140),heltab2x16(:,:,168))
  call Hloop_Q_A(ntryL,G1H4(68),79,nMT,G2H4(93),n2h4(161))
call HGT_OLR(G1H16(97),1,1,16)
call HGT_invQ_OLR(G1H16(97),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(97),-48,nMT,G2H16(20),n2h16(104))
  call Hloop_AV_Q(ntryL,G2H16(20),wf4(:,13),G2H4(94),m3h4x4(:,141),heltab2x16(:,:,169))
  call Hloop_QZ_A(ntryL,G1H16(99),wf4(:,4),G1H4(68),ngZu,m3h4x4(:,142),heltab2x16(:,:,170))
  call Hloop_Q_A(ntryL,G1H4(68),79,nMT,G2H4(95),n2h4(162))
  call Hloop_QZ_A(ntryL,G1H16(100),wf4(:,4),G1H4(68),ngZu,m3h4x4(:,143),heltab2x16(:,:,171))
  call Hloop_Q_A(ntryL,G1H4(68),79,nMT,G2H4(96),n2h4(163))
  call Hloop_QZ_A(ntryL,G0H16(20),wf4(:,4),G0H4(1),ngZu,m3h4x4(:,144),heltab2x16(:,:,172))
  call Hloop_Q_A(ntryL,G0H4(1),79,nMT,G1H4(68),n2h4(164))
  call Hloop_AZ_Q(ntryL,G1H16(101),wf4(:,4),G1H4(69),ngZd,m3h4x4(:,145),heltab2x16(:,:,173))
  call Hloop_A_Q(ntryL,G1H4(69),79,0,G2H4(97),n2h4(165))
call HGT_OLR(G1H16(102),1,1,16)
call HGT_invQ_OLR(G1H16(102),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(102),-48,0,G2H16(21),n2h16(105))
  call Hloop_QV_A(ntryL,G2H16(21),wf4(:,13),G2H4(98),m3h4x4(:,146),heltab2x16(:,:,174))
  call Hloop_AZ_Q(ntryL,G1H16(104),wf4(:,4),G1H4(69),ngZd,m3h4x4(:,147),heltab2x16(:,:,175))
  call Hloop_A_Q(ntryL,G1H4(69),79,0,G2H4(99),n2h4(166))
  call Hloop_AZ_Q(ntryL,G1H16(105),wf4(:,4),G1H4(69),ngZd,m3h4x4(:,148),heltab2x16(:,:,176))
  call Hloop_A_Q(ntryL,G1H4(69),79,0,G2H4(100),n2h4(167))
  call Hloop_AZ_Q(ntryL,G0H16(21),wf4(:,4),G0H4(1),ngZd,m3h4x4(:,149),heltab2x16(:,:,177))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(69),n2h4(168))
  call Hloop_AZ_Q(ntryL,G1H16(106),wf4(:,4),G1H4(70),ngZd,m3h4x4(:,150),heltab2x16(:,:,178))
  call Hloop_A_Q(ntryL,G1H4(70),79,nMB,G2H4(101),n2h4(169))
call HGT_OLR(G1H16(107),1,1,16)
call HGT_invQ_OLR(G1H16(107),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(107),-48,nMB,G2H16(22),n2h16(106))
  call Hloop_QV_A(ntryL,G2H16(22),wf4(:,13),G2H4(102),m3h4x4(:,151),heltab2x16(:,:,179))
  call Hloop_AZ_Q(ntryL,G1H16(109),wf4(:,4),G1H4(70),ngZd,m3h4x4(:,152),heltab2x16(:,:,180))
  call Hloop_A_Q(ntryL,G1H4(70),79,nMB,G2H4(103),n2h4(170))
  call Hloop_AZ_Q(ntryL,G1H16(110),wf4(:,4),G1H4(70),ngZd,m3h4x4(:,153),heltab2x16(:,:,181))
  call Hloop_A_Q(ntryL,G1H4(70),79,nMB,G2H4(104),n2h4(171))
  call Hloop_AZ_Q(ntryL,G0H16(22),wf4(:,4),G0H4(1),ngZd,m3h4x4(:,154),heltab2x16(:,:,182))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(70),n2h4(172))
  call Hloop_QZ_A(ntryL,G1H16(111),wf4(:,4),G1H4(71),ngZd,m3h4x4(:,155),heltab2x16(:,:,183))
  call Hloop_Q_A(ntryL,G1H4(71),79,0,G2H4(105),n2h4(173))
call HGT_OLR(G1H16(112),1,1,16)
call HGT_invQ_OLR(G1H16(112),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(112),-48,0,G2H16(23),n2h16(107))
  call Hloop_AV_Q(ntryL,G2H16(23),wf4(:,13),G2H4(106),m3h4x4(:,156),heltab2x16(:,:,184))
  call Hloop_QZ_A(ntryL,G1H16(114),wf4(:,4),G1H4(71),ngZd,m3h4x4(:,157),heltab2x16(:,:,185))
  call Hloop_Q_A(ntryL,G1H4(71),79,0,G2H4(107),n2h4(174))
  call Hloop_QZ_A(ntryL,G1H16(115),wf4(:,4),G1H4(71),ngZd,m3h4x4(:,158),heltab2x16(:,:,186))
  call Hloop_Q_A(ntryL,G1H4(71),79,0,G2H4(108),n2h4(175))
  call Hloop_QZ_A(ntryL,G0H16(23),wf4(:,4),G0H4(1),ngZd,m3h4x4(:,159),heltab2x16(:,:,187))
  call Hloop_Q_A(ntryL,G0H4(1),79,0,G1H4(71),n2h4(176))
  call Hloop_QZ_A(ntryL,G1H16(116),wf4(:,4),G1H4(72),ngZd,m3h4x4(:,160),heltab2x16(:,:,188))
  call Hloop_Q_A(ntryL,G1H4(72),79,nMB,G2H4(109),n2h4(177))
call HGT_OLR(G1H16(117),1,1,16)
call HGT_invQ_OLR(G1H16(117),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(117),-48,nMB,G2H16(24),n2h16(108))
  call Hloop_AV_Q(ntryL,G2H16(24),wf4(:,13),G2H4(110),m3h4x4(:,161),heltab2x16(:,:,189))
  call Hloop_QZ_A(ntryL,G1H16(119),wf4(:,4),G1H4(72),ngZd,m3h4x4(:,162),heltab2x16(:,:,190))
  call Hloop_Q_A(ntryL,G1H4(72),79,nMB,G2H4(111),n2h4(178))
  call Hloop_QZ_A(ntryL,G1H16(120),wf4(:,4),G1H4(72),ngZd,m3h4x4(:,163),heltab2x16(:,:,191))
  call Hloop_Q_A(ntryL,G1H4(72),79,nMB,G2H4(112),n2h4(179))
  call Hloop_QZ_A(ntryL,G0H16(24),wf4(:,4),G0H4(1),ngZd,m3h4x4(:,164),heltab2x16(:,:,192))
  call Hloop_Q_A(ntryL,G0H4(1),79,nMB,G1H4(72),n2h4(180))
  call Hloop_QZ_A(ntryL,G1H32(15),wf4(:,5),G1H8(75),ngZd,m3h4x8(:,25),heltab2x32(:,:,29))
  call Hloop_Q_A(ntryL,G1H8(75),90,nMB,G2H8(10),n2h8(57))
call HGT_raise_alpha_OLR(G1H32(21),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(21),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(21),wf8(:,2),G1H4(73),m3h8x4(:,1),heltab2x32(:,:,30))
  call Hloop_QZ_A(ntryL,G1H32(1),wf4(:,5),G1H8(59),ngZd,m3h4x8(:,26),heltab2x32(:,:,31))
  call Hloop_Q_A(ntryL,G1H8(59),90,nMB,G2H8(14),n2h8(58))
  call Hloop_QZ_A(ntryL,G1H32(7),wf4(:,5),G1H8(60),ngZd,m3h4x8(:,27),heltab2x32(:,:,32))
  call Hloop_Q_A(ntryL,G1H8(60),90,nMB,G2H8(13),n2h8(59))
  call Hloop_QZ_A(ntryL,G1H32(6),wf4(:,4),G1H8(76),ngZd,m3h4x8(:,28),heltab2x32(:,:,33))
  call Hloop_Q_A(ntryL,G1H8(76),85,nMB,G2H8(12),n2h8(60))
call HGT_raise_alpha_OLR(G1H32(4),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(4),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(4),wf8(:,4),G1H4(74),m3h8x4(:,2),heltab2x32(:,:,34))
  call Hloop_QZ_A(ntryL,G1H32(11),wf4(:,4),G1H8(3),ngZd,m3h4x8(:,29),heltab2x32(:,:,35))
  call Hloop_Q_A(ntryL,G1H8(3),85,nMB,G2H8(24),n2h8(61))
  call Hloop_QZ_A(ntryL,G1H32(12),wf4(:,4),G1H8(4),ngZd,m3h4x8(:,30),heltab2x32(:,:,36))
  call Hloop_Q_A(ntryL,G1H8(4),85,nMB,G2H8(25),n2h8(62))
  call Hloop_QS_A(ntryL,G1H32(13),wf16(:,3),G1H2(12),ngH,m3h16x2(:,1),heltab2x32(:,:,37))
  call Hloop_Q_A(ntryL,G1H2(12),95,nMB,G2H2(95),n2h2(73))
call HGT_raise_alpha_OLR(G1H32(14),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(14),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(14),ex6(:),G1H16(30),m3h2x16(:,5),heltab2x32(:,:,38))
  call Hloop_QS_A(ntryL,G1H32(8),wf16(:,3),G1H2(13),ngH,m3h16x2(:,2),heltab2x32(:,:,39))
  call Hloop_Q_A(ntryL,G1H2(13),95,nMB,G2H2(96),n2h2(74))
  call Hloop_QS_A(ntryL,G1H32(10),wf16(:,3),G1H2(18),ngH,m3h16x2(:,3),heltab2x32(:,:,40))
  call Hloop_Q_A(ntryL,G1H2(18),95,nMB,G2H2(97),n2h2(75))
  call Hloop_QZ_A(ntryL,G1H32(17),wf16(:,73),G1H2(19),ngZd,m3h16x2(:,4),heltab2x32(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(19),95,nMB,G2H2(98),n2h2(76))
call HGT_raise_alpha_OLR(G1H32(18),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(18),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(18),ex6(:),G1H16(31),m3h2x16(:,6),heltab2x32(:,:,42))
  call Hloop_QZ_A(ntryL,G1H32(20),wf16(:,73),G1H2(23),ngZd,m3h16x2(:,5),heltab2x32(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(23),95,nMB,G2H2(99),n2h2(77))
  call Hloop_QZ_A(ntryL,G1H32(22),wf16(:,73),G1H2(24),ngZd,m3h16x2(:,6),heltab2x32(:,:,44))
  call Hloop_Q_A(ntryL,G1H2(24),95,nMB,G2H2(100),n2h2(78))
  call Hloop_QZ_A(ntryL,G1H32(23),wf16(:,74),G1H2(29),ngZd,m3h16x2(:,7),heltab2x32(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(29),95,nMB,G2H2(101),n2h2(79))
call HGT_raise_alpha_OLR(G1H32(24),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(24),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(24),ex6(:),G1H16(34),m3h2x16(:,7),heltab2x32(:,:,46))
  call Hloop_QZ_A(ntryL,G1H32(9),wf16(:,74),G1H2(30),ngZd,m3h16x2(:,8),heltab2x32(:,:,47))
  call Hloop_Q_A(ntryL,G1H2(30),95,nMB,G2H2(102),n2h2(80))
  call Hloop_QZ_A(ntryL,G1H32(25),wf16(:,74),G1H2(34),ngZd,m3h16x2(:,9),heltab2x32(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(34),95,nMB,G2H2(103),n2h2(81))
  call Hloop_QV_A(ntryL,G1H16(121),wf4(:,13),G1H4(75),m3h4x4(:,165),heltab2x16(:,:,193))
  call Hloop_Q_A(ntryL,G1H4(75),118,0,G2H4(113),n2h4(181))
call HGT_OLR(G1H16(122),1,1,16)
call HGT_invQ_OLR(G1H16(122),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(122),-9,0,G2H16(25),n2h16(109))
  call Hloop_AZ_Q(ntryL,G2H16(25),wf4(:,11),G2H4(114),ngZu,m3h4x4(:,166),heltab2x16(:,:,194))
  call Hloop_QV_A(ntryL,G1H16(124),wf4(:,13),G1H4(75),m3h4x4(:,167),heltab2x16(:,:,195))
  call Hloop_Q_A(ntryL,G1H4(75),118,0,G2H4(115),n2h4(182))
  call Hloop_QV_A(ntryL,G1H16(125),wf4(:,13),G1H4(75),m3h4x4(:,168),heltab2x16(:,:,196))
  call Hloop_Q_A(ntryL,G1H4(75),118,0,G2H4(116),n2h4(183))
  call Hloop_QV_A(ntryL,G0H16(25),wf4(:,13),G0H4(1),m3h4x4(:,169),heltab2x16(:,:,197))
  call Hloop_Q_A(ntryL,G0H4(1),118,0,G1H4(75),n2h4(184))
  call Hloop_QV_A(ntryL,G1H16(126),wf4(:,13),G1H4(76),m3h4x4(:,170),heltab2x16(:,:,198))
  call Hloop_Q_A(ntryL,G1H4(76),118,nMT,G2H4(117),n2h4(185))
call HGT_OLR(G1H16(127),1,1,16)
call HGT_invQ_OLR(G1H16(127),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(127),-9,nMT,G2H16(26),n2h16(110))
  call Hloop_AZ_Q(ntryL,G2H16(26),wf4(:,11),G2H4(118),ngZu,m3h4x4(:,171),heltab2x16(:,:,199))
  call Hloop_QV_A(ntryL,G1H16(129),wf4(:,13),G1H4(76),m3h4x4(:,172),heltab2x16(:,:,200))
  call Hloop_Q_A(ntryL,G1H4(76),118,nMT,G2H4(119),n2h4(186))
  call Hloop_QV_A(ntryL,G1H16(130),wf4(:,13),G1H4(76),m3h4x4(:,173),heltab2x16(:,:,201))
  call Hloop_Q_A(ntryL,G1H4(76),118,nMT,G2H4(120),n2h4(187))
  call Hloop_QV_A(ntryL,G0H16(26),wf4(:,13),G0H4(1),m3h4x4(:,174),heltab2x16(:,:,202))
  call Hloop_Q_A(ntryL,G0H4(1),118,nMT,G1H4(76),n2h4(188))
  call Hloop_AV_Q(ntryL,G1H16(131),wf4(:,13),G1H4(77),m3h4x4(:,175),heltab2x16(:,:,203))
  call Hloop_A_Q(ntryL,G1H4(77),118,0,G2H4(121),n2h4(189))
call HGT_OLR(G1H16(132),1,1,16)
call HGT_invQ_OLR(G1H16(132),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(132),-9,0,G2H16(27),n2h16(111))
  call Hloop_QZ_A(ntryL,G2H16(27),wf4(:,11),G2H4(122),ngZu,m3h4x4(:,176),heltab2x16(:,:,204))
  call Hloop_AV_Q(ntryL,G1H16(134),wf4(:,13),G1H4(77),m3h4x4(:,177),heltab2x16(:,:,205))
  call Hloop_A_Q(ntryL,G1H4(77),118,0,G2H4(123),n2h4(190))
  call Hloop_AV_Q(ntryL,G1H16(135),wf4(:,13),G1H4(77),m3h4x4(:,178),heltab2x16(:,:,206))
  call Hloop_A_Q(ntryL,G1H4(77),118,0,G2H4(124),n2h4(191))
  call Hloop_AV_Q(ntryL,G0H16(27),wf4(:,13),G0H4(1),m3h4x4(:,179),heltab2x16(:,:,207))
  call Hloop_A_Q(ntryL,G0H4(1),118,0,G1H4(77),n2h4(192))
  call Hloop_AV_Q(ntryL,G1H16(136),wf4(:,13),G1H4(78),m3h4x4(:,180),heltab2x16(:,:,208))
  call Hloop_A_Q(ntryL,G1H4(78),118,nMT,G2H4(125),n2h4(193))
call HGT_OLR(G1H16(137),1,1,16)
call HGT_invQ_OLR(G1H16(137),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(137),-9,nMT,G2H16(28),n2h16(112))
  call Hloop_QZ_A(ntryL,G2H16(28),wf4(:,11),G2H4(126),ngZu,m3h4x4(:,181),heltab2x16(:,:,209))
  call Hloop_AV_Q(ntryL,G1H16(139),wf4(:,13),G1H4(78),m3h4x4(:,182),heltab2x16(:,:,210))
  call Hloop_A_Q(ntryL,G1H4(78),118,nMT,G2H4(127),n2h4(194))
  call Hloop_AV_Q(ntryL,G1H16(140),wf4(:,13),G1H4(78),m3h4x4(:,183),heltab2x16(:,:,211))
  call Hloop_A_Q(ntryL,G1H4(78),118,nMT,G2H4(128),n2h4(195))
  call Hloop_AV_Q(ntryL,G0H16(28),wf4(:,13),G0H4(1),m3h4x4(:,184),heltab2x16(:,:,212))
  call Hloop_A_Q(ntryL,G0H4(1),118,nMT,G1H4(78),n2h4(196))
  call Hloop_QV_A(ntryL,G1H16(141),wf4(:,13),G1H4(79),m3h4x4(:,185),heltab2x16(:,:,213))
  call Hloop_Q_A(ntryL,G1H4(79),118,0,G2H4(129),n2h4(197))
call HGT_OLR(G1H16(142),1,1,16)
call HGT_invQ_OLR(G1H16(142),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(142),-9,0,G2H16(29),n2h16(113))
  call Hloop_AZ_Q(ntryL,G2H16(29),wf4(:,11),G2H4(130),ngZd,m3h4x4(:,186),heltab2x16(:,:,214))
  call Hloop_QV_A(ntryL,G1H16(144),wf4(:,13),G1H4(79),m3h4x4(:,187),heltab2x16(:,:,215))
  call Hloop_Q_A(ntryL,G1H4(79),118,0,G2H4(131),n2h4(198))
  call Hloop_QV_A(ntryL,G1H16(145),wf4(:,13),G1H4(79),m3h4x4(:,188),heltab2x16(:,:,216))
  call Hloop_Q_A(ntryL,G1H4(79),118,0,G2H4(132),n2h4(199))
  call Hloop_QV_A(ntryL,G0H16(29),wf4(:,13),G0H4(1),m3h4x4(:,189),heltab2x16(:,:,217))
  call Hloop_Q_A(ntryL,G0H4(1),118,0,G1H4(79),n2h4(200))
  call Hloop_QV_A(ntryL,G1H16(146),wf4(:,13),G1H4(80),m3h4x4(:,190),heltab2x16(:,:,218))
  call Hloop_Q_A(ntryL,G1H4(80),118,nMB,G2H4(133),n2h4(201))
call HGT_OLR(G1H16(147),1,1,16)
call HGT_invQ_OLR(G1H16(147),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(147),-9,nMB,G2H16(30),n2h16(114))
  call Hloop_AZ_Q(ntryL,G2H16(30),wf4(:,11),G2H4(134),ngZd,m3h4x4(:,191),heltab2x16(:,:,219))
  call Hloop_QV_A(ntryL,G1H16(149),wf4(:,13),G1H4(80),m3h4x4(:,192),heltab2x16(:,:,220))
  call Hloop_Q_A(ntryL,G1H4(80),118,nMB,G2H4(135),n2h4(202))
  call Hloop_QV_A(ntryL,G1H16(150),wf4(:,13),G1H4(80),m3h4x4(:,193),heltab2x16(:,:,221))
  call Hloop_Q_A(ntryL,G1H4(80),118,nMB,G2H4(136),n2h4(203))
  call Hloop_QV_A(ntryL,G0H16(30),wf4(:,13),G0H4(1),m3h4x4(:,194),heltab2x16(:,:,222))
  call Hloop_Q_A(ntryL,G0H4(1),118,nMB,G1H4(80),n2h4(204))
  call Hloop_AV_Q(ntryL,G1H16(151),wf4(:,13),G1H4(81),m3h4x4(:,195),heltab2x16(:,:,223))
  call Hloop_A_Q(ntryL,G1H4(81),118,0,G2H4(137),n2h4(205))
call HGT_OLR(G1H16(152),1,1,16)
call HGT_invQ_OLR(G1H16(152),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(152),-9,0,G2H16(31),n2h16(115))
  call Hloop_QZ_A(ntryL,G2H16(31),wf4(:,11),G2H4(138),ngZd,m3h4x4(:,196),heltab2x16(:,:,224))
  call Hloop_AV_Q(ntryL,G1H16(154),wf4(:,13),G1H4(81),m3h4x4(:,197),heltab2x16(:,:,225))
  call Hloop_A_Q(ntryL,G1H4(81),118,0,G2H4(139),n2h4(206))
  call Hloop_AV_Q(ntryL,G1H16(155),wf4(:,13),G1H4(81),m3h4x4(:,198),heltab2x16(:,:,226))
  call Hloop_A_Q(ntryL,G1H4(81),118,0,G2H4(140),n2h4(207))
  call Hloop_AV_Q(ntryL,G0H16(31),wf4(:,13),G0H4(1),m3h4x4(:,199),heltab2x16(:,:,227))
  call Hloop_A_Q(ntryL,G0H4(1),118,0,G1H4(81),n2h4(208))
  call Hloop_AV_Q(ntryL,G1H16(156),wf4(:,13),G1H4(82),m3h4x4(:,200),heltab2x16(:,:,228))
  call Hloop_A_Q(ntryL,G1H4(82),118,nMB,G2H4(141),n2h4(209))
call HGT_OLR(G1H16(157),1,1,16)
call HGT_invQ_OLR(G1H16(157),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(157),-9,nMB,G2H16(32),n2h16(116))
  call Hloop_QZ_A(ntryL,G2H16(32),wf4(:,11),G2H4(142),ngZd,m3h4x4(:,201),heltab2x16(:,:,229))
  call Hloop_AV_Q(ntryL,G1H16(159),wf4(:,13),G1H4(82),m3h4x4(:,202),heltab2x16(:,:,230))
  call Hloop_A_Q(ntryL,G1H4(82),118,nMB,G2H4(143),n2h4(210))
  call Hloop_AV_Q(ntryL,G1H16(160),wf4(:,13),G1H4(82),m3h4x4(:,203),heltab2x16(:,:,231))
  call Hloop_A_Q(ntryL,G1H4(82),118,nMB,G2H4(144),n2h4(211))
  call Hloop_AV_Q(ntryL,G0H16(32),wf4(:,13),G0H4(1),m3h4x4(:,204),heltab2x16(:,:,232))
  call Hloop_A_Q(ntryL,G0H4(1),118,nMB,G1H4(82),n2h4(212))
  call Hloop_AZ_Q(ntryL,G1H16(161),wf4(:,12),G1H4(83),ngZu,m3h4x4(:,205),heltab2x16(:,:,233))
  call Hloop_A_Q(ntryL,G1H4(83),79,0,G2H4(145),n2h4(213))
call HGT_OLR(G1H16(162),1,1,16)
call HGT_invQ_OLR(G1H16(162),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(162),-48,0,G2H16(33),n2h16(117))
  call Hloop_QV_A(ntryL,G2H16(33),wf4(:,13),G2H4(146),m3h4x4(:,206),heltab2x16(:,:,234))
  call Hloop_AZ_Q(ntryL,G1H16(164),wf4(:,12),G1H4(83),ngZu,m3h4x4(:,207),heltab2x16(:,:,235))
  call Hloop_A_Q(ntryL,G1H4(83),79,0,G2H4(147),n2h4(214))
  call Hloop_AZ_Q(ntryL,G1H16(165),wf4(:,12),G1H4(83),ngZu,m3h4x4(:,208),heltab2x16(:,:,236))
  call Hloop_A_Q(ntryL,G1H4(83),79,0,G2H4(148),n2h4(215))
  call Hloop_AZ_Q(ntryL,G0H16(33),wf4(:,12),G0H4(1),ngZu,m3h4x4(:,209),heltab2x16(:,:,237))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(83),n2h4(216))
  call Hloop_AZ_Q(ntryL,G1H16(166),wf4(:,12),G1H4(84),ngZu,m3h4x4(:,210),heltab2x16(:,:,238))
  call Hloop_A_Q(ntryL,G1H4(84),79,nMT,G2H4(149),n2h4(217))
call HGT_OLR(G1H16(167),1,1,16)
call HGT_invQ_OLR(G1H16(167),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(167),-48,nMT,G2H16(34),n2h16(118))
  call Hloop_QV_A(ntryL,G2H16(34),wf4(:,13),G2H4(150),m3h4x4(:,211),heltab2x16(:,:,239))
  call Hloop_AZ_Q(ntryL,G1H16(169),wf4(:,12),G1H4(84),ngZu,m3h4x4(:,212),heltab2x16(:,:,240))
  call Hloop_A_Q(ntryL,G1H4(84),79,nMT,G2H4(151),n2h4(218))
  call Hloop_AZ_Q(ntryL,G1H16(170),wf4(:,12),G1H4(84),ngZu,m3h4x4(:,213),heltab2x16(:,:,241))
  call Hloop_A_Q(ntryL,G1H4(84),79,nMT,G2H4(152),n2h4(219))
  call Hloop_AZ_Q(ntryL,G0H16(34),wf4(:,12),G0H4(1),ngZu,m3h4x4(:,214),heltab2x16(:,:,242))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMT,G1H4(84),n2h4(220))
  call Hloop_QZ_A(ntryL,G1H16(171),wf4(:,12),G1H4(85),ngZu,m3h4x4(:,215),heltab2x16(:,:,243))
  call Hloop_Q_A(ntryL,G1H4(85),79,0,G2H4(153),n2h4(221))
call HGT_OLR(G1H16(172),1,1,16)
call HGT_invQ_OLR(G1H16(172),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(172),-48,0,G2H16(35),n2h16(119))
  call Hloop_AV_Q(ntryL,G2H16(35),wf4(:,13),G2H4(154),m3h4x4(:,216),heltab2x16(:,:,244))
  call Hloop_QZ_A(ntryL,G1H16(174),wf4(:,12),G1H4(85),ngZu,m3h4x4(:,217),heltab2x16(:,:,245))
  call Hloop_Q_A(ntryL,G1H4(85),79,0,G2H4(155),n2h4(222))
  call Hloop_QZ_A(ntryL,G1H16(175),wf4(:,12),G1H4(85),ngZu,m3h4x4(:,218),heltab2x16(:,:,246))
  call Hloop_Q_A(ntryL,G1H4(85),79,0,G2H4(156),n2h4(223))
  call Hloop_QZ_A(ntryL,G0H16(35),wf4(:,12),G0H4(1),ngZu,m3h4x4(:,219),heltab2x16(:,:,247))
  call Hloop_Q_A(ntryL,G0H4(1),79,0,G1H4(85),n2h4(224))
  call Hloop_QZ_A(ntryL,G1H16(176),wf4(:,12),G1H4(86),ngZu,m3h4x4(:,220),heltab2x16(:,:,248))
  call Hloop_Q_A(ntryL,G1H4(86),79,nMT,G2H4(157),n2h4(225))
call HGT_OLR(G1H16(177),1,1,16)
call HGT_invQ_OLR(G1H16(177),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(177),-48,nMT,G2H16(36),n2h16(120))
  call Hloop_AV_Q(ntryL,G2H16(36),wf4(:,13),G2H4(158),m3h4x4(:,221),heltab2x16(:,:,249))
  call Hloop_QZ_A(ntryL,G1H16(179),wf4(:,12),G1H4(86),ngZu,m3h4x4(:,222),heltab2x16(:,:,250))
  call Hloop_Q_A(ntryL,G1H4(86),79,nMT,G2H4(159),n2h4(226))
  call Hloop_QZ_A(ntryL,G1H16(180),wf4(:,12),G1H4(86),ngZu,m3h4x4(:,223),heltab2x16(:,:,251))
  call Hloop_Q_A(ntryL,G1H4(86),79,nMT,G2H4(160),n2h4(227))
  call Hloop_QZ_A(ntryL,G0H16(36),wf4(:,12),G0H4(1),ngZu,m3h4x4(:,224),heltab2x16(:,:,252))
  call Hloop_Q_A(ntryL,G0H4(1),79,nMT,G1H4(86),n2h4(228))
  call Hloop_AZ_Q(ntryL,G1H16(181),wf4(:,12),G1H4(87),ngZd,m3h4x4(:,225),heltab2x16(:,:,253))
  call Hloop_A_Q(ntryL,G1H4(87),79,0,G2H4(161),n2h4(229))
call HGT_OLR(G1H16(182),1,1,16)
call HGT_invQ_OLR(G1H16(182),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(182),-48,0,G2H16(37),n2h16(121))
  call Hloop_QV_A(ntryL,G2H16(37),wf4(:,13),G2H4(162),m3h4x4(:,226),heltab2x16(:,:,254))
  call Hloop_AZ_Q(ntryL,G1H16(184),wf4(:,12),G1H4(87),ngZd,m3h4x4(:,227),heltab2x16(:,:,255))
  call Hloop_A_Q(ntryL,G1H4(87),79,0,G2H4(163),n2h4(230))
  call Hloop_AZ_Q(ntryL,G1H16(185),wf4(:,12),G1H4(87),ngZd,m3h4x4(:,228),heltab2x16(:,:,256))
  call Hloop_A_Q(ntryL,G1H4(87),79,0,G2H4(164),n2h4(231))
  call Hloop_AZ_Q(ntryL,G0H16(37),wf4(:,12),G0H4(1),ngZd,m3h4x4(:,229),heltab2x16(:,:,257))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(87),n2h4(232))
  call Hloop_AZ_Q(ntryL,G1H16(186),wf4(:,12),G1H4(88),ngZd,m3h4x4(:,230),heltab2x16(:,:,258))
  call Hloop_A_Q(ntryL,G1H4(88),79,nMB,G2H4(165),n2h4(233))
call HGT_OLR(G1H16(187),1,1,16)
call HGT_invQ_OLR(G1H16(187),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(187),-48,nMB,G2H16(38),n2h16(122))
  call Hloop_QV_A(ntryL,G2H16(38),wf4(:,13),G2H4(166),m3h4x4(:,231),heltab2x16(:,:,259))
  call Hloop_AZ_Q(ntryL,G1H16(189),wf4(:,12),G1H4(88),ngZd,m3h4x4(:,232),heltab2x16(:,:,260))
  call Hloop_A_Q(ntryL,G1H4(88),79,nMB,G2H4(167),n2h4(234))
  call Hloop_AZ_Q(ntryL,G1H16(190),wf4(:,12),G1H4(88),ngZd,m3h4x4(:,233),heltab2x16(:,:,261))
  call Hloop_A_Q(ntryL,G1H4(88),79,nMB,G2H4(168),n2h4(235))
  call Hloop_AZ_Q(ntryL,G0H16(38),wf4(:,12),G0H4(1),ngZd,m3h4x4(:,234),heltab2x16(:,:,262))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(88),n2h4(236))
  call Hloop_QZ_A(ntryL,G1H16(191),wf4(:,12),G1H4(89),ngZd,m3h4x4(:,235),heltab2x16(:,:,263))
  call Hloop_Q_A(ntryL,G1H4(89),79,0,G2H4(169),n2h4(237))
call HGT_OLR(G1H16(192),1,1,16)
call HGT_invQ_OLR(G1H16(192),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(192),-48,0,G2H16(39),n2h16(123))
  call Hloop_AV_Q(ntryL,G2H16(39),wf4(:,13),G2H4(170),m3h4x4(:,236),heltab2x16(:,:,264))
  call Hloop_QZ_A(ntryL,G1H16(194),wf4(:,12),G1H4(89),ngZd,m3h4x4(:,237),heltab2x16(:,:,265))
  call Hloop_Q_A(ntryL,G1H4(89),79,0,G2H4(171),n2h4(238))
  call Hloop_QZ_A(ntryL,G1H16(195),wf4(:,12),G1H4(89),ngZd,m3h4x4(:,238),heltab2x16(:,:,266))
  call Hloop_Q_A(ntryL,G1H4(89),79,0,G2H4(172),n2h4(239))
  call Hloop_QZ_A(ntryL,G0H16(39),wf4(:,12),G0H4(1),ngZd,m3h4x4(:,239),heltab2x16(:,:,267))
  call Hloop_Q_A(ntryL,G0H4(1),79,0,G1H4(89),n2h4(240))
  call Hloop_QZ_A(ntryL,G1H16(196),wf4(:,12),G1H4(90),ngZd,m3h4x4(:,240),heltab2x16(:,:,268))
  call Hloop_Q_A(ntryL,G1H4(90),79,nMB,G2H4(173),n2h4(241))
call HGT_OLR(G1H16(197),1,1,16)
call HGT_invQ_OLR(G1H16(197),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(197),-48,nMB,G2H16(40),n2h16(124))
  call Hloop_AV_Q(ntryL,G2H16(40),wf4(:,13),G2H4(174),m3h4x4(:,241),heltab2x16(:,:,269))
  call Hloop_QZ_A(ntryL,G1H16(199),wf4(:,12),G1H4(90),ngZd,m3h4x4(:,242),heltab2x16(:,:,270))
  call Hloop_Q_A(ntryL,G1H4(90),79,nMB,G2H4(175),n2h4(242))
  call Hloop_QZ_A(ntryL,G1H16(200),wf4(:,12),G1H4(90),ngZd,m3h4x4(:,243),heltab2x16(:,:,271))
  call Hloop_Q_A(ntryL,G1H4(90),79,nMB,G2H4(176),n2h4(243))
  call Hloop_QZ_A(ntryL,G0H16(40),wf4(:,12),G0H4(1),ngZd,m3h4x4(:,244),heltab2x16(:,:,272))
  call Hloop_Q_A(ntryL,G0H4(1),79,nMB,G1H4(90),n2h4(244))
  call Hloop_AZ_Q(ntryL,G1H16(201),wf4(:,11),G1H4(91),ngZu,m3h4x4(:,245),heltab2x16(:,:,273))
  call Hloop_A_Q(ntryL,G1H4(91),79,0,G2H4(177),n2h4(245))
call HGT_OLR(G1H16(202),1,1,16)
call HGT_invQ_OLR(G1H16(202),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(202),-48,0,G2H16(41),n2h16(125))
  call Hloop_QV_A(ntryL,G2H16(41),wf4(:,13),G2H4(178),m3h4x4(:,246),heltab2x16(:,:,274))
  call Hloop_AZ_Q(ntryL,G1H16(204),wf4(:,11),G1H4(91),ngZu,m3h4x4(:,247),heltab2x16(:,:,275))
  call Hloop_A_Q(ntryL,G1H4(91),79,0,G2H4(179),n2h4(246))
  call Hloop_AZ_Q(ntryL,G1H16(205),wf4(:,11),G1H4(91),ngZu,m3h4x4(:,248),heltab2x16(:,:,276))
  call Hloop_A_Q(ntryL,G1H4(91),79,0,G2H4(180),n2h4(247))
  call Hloop_AZ_Q(ntryL,G0H16(41),wf4(:,11),G0H4(1),ngZu,m3h4x4(:,249),heltab2x16(:,:,277))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(91),n2h4(248))
  call Hloop_AZ_Q(ntryL,G1H16(206),wf4(:,11),G1H4(92),ngZu,m3h4x4(:,250),heltab2x16(:,:,278))
  call Hloop_A_Q(ntryL,G1H4(92),79,nMT,G2H4(181),n2h4(249))
call HGT_OLR(G1H16(207),1,1,16)
call HGT_invQ_OLR(G1H16(207),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(207),-48,nMT,G2H16(42),n2h16(126))
  call Hloop_QV_A(ntryL,G2H16(42),wf4(:,13),G2H4(182),m3h4x4(:,251),heltab2x16(:,:,279))
  call Hloop_AZ_Q(ntryL,G1H16(209),wf4(:,11),G1H4(92),ngZu,m3h4x4(:,252),heltab2x16(:,:,280))
  call Hloop_A_Q(ntryL,G1H4(92),79,nMT,G2H4(183),n2h4(250))
  call Hloop_AZ_Q(ntryL,G1H16(210),wf4(:,11),G1H4(92),ngZu,m3h4x4(:,253),heltab2x16(:,:,281))
  call Hloop_A_Q(ntryL,G1H4(92),79,nMT,G2H4(184),n2h4(251))
  call Hloop_AZ_Q(ntryL,G0H16(42),wf4(:,11),G0H4(1),ngZu,m3h4x4(:,254),heltab2x16(:,:,282))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMT,G1H4(92),n2h4(252))
  call Hloop_QZ_A(ntryL,G1H16(211),wf4(:,11),G1H4(93),ngZu,m3h4x4(:,255),heltab2x16(:,:,283))
  call Hloop_Q_A(ntryL,G1H4(93),79,0,G2H4(185),n2h4(253))
call HGT_OLR(G1H16(212),1,1,16)
call HGT_invQ_OLR(G1H16(212),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(212),-48,0,G2H16(43),n2h16(127))
  call Hloop_AV_Q(ntryL,G2H16(43),wf4(:,13),G2H4(186),m3h4x4(:,256),heltab2x16(:,:,284))
  call Hloop_QZ_A(ntryL,G1H16(214),wf4(:,11),G1H4(93),ngZu,m3h4x4(:,257),heltab2x16(:,:,285))
  call Hloop_Q_A(ntryL,G1H4(93),79,0,G2H4(187),n2h4(254))
  call Hloop_QZ_A(ntryL,G1H16(215),wf4(:,11),G1H4(93),ngZu,m3h4x4(:,258),heltab2x16(:,:,286))
  call Hloop_Q_A(ntryL,G1H4(93),79,0,G2H4(188),n2h4(255))
  call Hloop_QZ_A(ntryL,G0H16(43),wf4(:,11),G0H4(1),ngZu,m3h4x4(:,259),heltab2x16(:,:,287))
  call Hloop_Q_A(ntryL,G0H4(1),79,0,G1H4(93),n2h4(256))
  call Hloop_QZ_A(ntryL,G1H16(216),wf4(:,11),G1H4(94),ngZu,m3h4x4(:,260),heltab2x16(:,:,288))
  call Hloop_Q_A(ntryL,G1H4(94),79,nMT,G2H4(189),n2h4(257))
call HGT_OLR(G1H16(217),1,1,16)
call HGT_invQ_OLR(G1H16(217),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(217),-48,nMT,G2H16(44),n2h16(128))
  call Hloop_AV_Q(ntryL,G2H16(44),wf4(:,13),G2H4(190),m3h4x4(:,261),heltab2x16(:,:,289))
  call Hloop_QZ_A(ntryL,G1H16(219),wf4(:,11),G1H4(94),ngZu,m3h4x4(:,262),heltab2x16(:,:,290))
  call Hloop_Q_A(ntryL,G1H4(94),79,nMT,G2H4(191),n2h4(258))
  call Hloop_QZ_A(ntryL,G1H16(220),wf4(:,11),G1H4(94),ngZu,m3h4x4(:,263),heltab2x16(:,:,291))
  call Hloop_Q_A(ntryL,G1H4(94),79,nMT,G2H4(192),n2h4(259))
  call Hloop_QZ_A(ntryL,G0H16(44),wf4(:,11),G0H4(1),ngZu,m3h4x4(:,264),heltab2x16(:,:,292))
  call Hloop_Q_A(ntryL,G0H4(1),79,nMT,G1H4(94),n2h4(260))
  call Hloop_AZ_Q(ntryL,G1H16(221),wf4(:,11),G1H4(95),ngZd,m3h4x4(:,265),heltab2x16(:,:,293))
  call Hloop_A_Q(ntryL,G1H4(95),79,0,G2H4(193),n2h4(261))
call HGT_OLR(G1H16(222),1,1,16)
call HGT_invQ_OLR(G1H16(222),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(222),-48,0,G2H16(45),n2h16(129))
  call Hloop_QV_A(ntryL,G2H16(45),wf4(:,13),G2H4(194),m3h4x4(:,266),heltab2x16(:,:,294))
  call Hloop_AZ_Q(ntryL,G1H16(224),wf4(:,11),G1H4(95),ngZd,m3h4x4(:,267),heltab2x16(:,:,295))
  call Hloop_A_Q(ntryL,G1H4(95),79,0,G2H4(195),n2h4(262))
  call Hloop_AZ_Q(ntryL,G1H16(225),wf4(:,11),G1H4(95),ngZd,m3h4x4(:,268),heltab2x16(:,:,296))
  call Hloop_A_Q(ntryL,G1H4(95),79,0,G2H4(196),n2h4(263))
  call Hloop_AZ_Q(ntryL,G0H16(45),wf4(:,11),G0H4(1),ngZd,m3h4x4(:,269),heltab2x16(:,:,297))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(95),n2h4(264))
  call Hloop_AZ_Q(ntryL,G1H16(226),wf4(:,11),G1H4(96),ngZd,m3h4x4(:,270),heltab2x16(:,:,298))
  call Hloop_A_Q(ntryL,G1H4(96),79,nMB,G2H4(197),n2h4(265))
call HGT_OLR(G1H16(227),1,1,16)
call HGT_invQ_OLR(G1H16(227),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(227),-48,nMB,G2H16(46),n2h16(130))
  call Hloop_QV_A(ntryL,G2H16(46),wf4(:,13),G2H4(198),m3h4x4(:,271),heltab2x16(:,:,299))
  call Hloop_AZ_Q(ntryL,G1H16(229),wf4(:,11),G1H4(96),ngZd,m3h4x4(:,272),heltab2x16(:,:,300))
  call Hloop_A_Q(ntryL,G1H4(96),79,nMB,G2H4(199),n2h4(266))
  call Hloop_AZ_Q(ntryL,G1H16(230),wf4(:,11),G1H4(96),ngZd,m3h4x4(:,273),heltab2x16(:,:,301))
  call Hloop_A_Q(ntryL,G1H4(96),79,nMB,G2H4(200),n2h4(267))
  call Hloop_AZ_Q(ntryL,G0H16(46),wf4(:,11),G0H4(1),ngZd,m3h4x4(:,274),heltab2x16(:,:,302))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(96),n2h4(268))
  call Hloop_QZ_A(ntryL,G1H16(231),wf4(:,11),G1H4(97),ngZd,m3h4x4(:,275),heltab2x16(:,:,303))
  call Hloop_Q_A(ntryL,G1H4(97),79,0,G2H4(201),n2h4(269))
call HGT_OLR(G1H16(232),1,1,16)
call HGT_invQ_OLR(G1H16(232),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(232),-48,0,G2H16(47),n2h16(131))
  call Hloop_AV_Q(ntryL,G2H16(47),wf4(:,13),G2H4(202),m3h4x4(:,276),heltab2x16(:,:,304))
  call Hloop_QZ_A(ntryL,G1H16(234),wf4(:,11),G1H4(97),ngZd,m3h4x4(:,277),heltab2x16(:,:,305))
  call Hloop_Q_A(ntryL,G1H4(97),79,0,G2H4(203),n2h4(270))
  call Hloop_QZ_A(ntryL,G1H16(235),wf4(:,11),G1H4(97),ngZd,m3h4x4(:,278),heltab2x16(:,:,306))
  call Hloop_Q_A(ntryL,G1H4(97),79,0,G2H4(204),n2h4(271))
  call Hloop_QZ_A(ntryL,G0H16(47),wf4(:,11),G0H4(1),ngZd,m3h4x4(:,279),heltab2x16(:,:,307))
  call Hloop_Q_A(ntryL,G0H4(1),79,0,G1H4(97),n2h4(272))
  call Hloop_QZ_A(ntryL,G1H16(236),wf4(:,11),G1H4(98),ngZd,m3h4x4(:,280),heltab2x16(:,:,308))
  call Hloop_Q_A(ntryL,G1H4(98),79,nMB,G2H4(205),n2h4(273))
call HGT_OLR(G1H16(237),1,1,16)
call HGT_invQ_OLR(G1H16(237),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(237),-48,nMB,G2H16(48),n2h16(132))
  call Hloop_AV_Q(ntryL,G2H16(48),wf4(:,13),G2H4(206),m3h4x4(:,281),heltab2x16(:,:,309))
  call Hloop_QZ_A(ntryL,G1H16(239),wf4(:,11),G1H4(98),ngZd,m3h4x4(:,282),heltab2x16(:,:,310))
  call Hloop_Q_A(ntryL,G1H4(98),79,nMB,G2H4(207),n2h4(274))
  call Hloop_QZ_A(ntryL,G1H16(240),wf4(:,11),G1H4(98),ngZd,m3h4x4(:,283),heltab2x16(:,:,311))
  call Hloop_Q_A(ntryL,G1H4(98),79,nMB,G2H4(208),n2h4(275))
  call Hloop_QZ_A(ntryL,G0H16(48),wf4(:,11),G0H4(1),ngZd,m3h4x4(:,284),heltab2x16(:,:,312))
  call Hloop_Q_A(ntryL,G0H4(1),79,nMB,G1H4(98),n2h4(276))
  call Hloop_QZ_A(ntryL,G1H32(26),wf4(:,12),G1H8(9),ngZd,m3h4x8(:,31),heltab2x32(:,:,49))
  call Hloop_Q_A(ntryL,G1H8(9),86,nMB,G2H8(22),n2h8(63))
call HGT_raise_alpha_OLR(G1H32(27),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(27),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(27),wf8(:,20),G1H4(99),m3h8x4(:,3),heltab2x32(:,:,50))
  call Hloop_QZ_A(ntryL,G1H32(29),wf4(:,12),G1H8(10),ngZd,m3h4x8(:,32),heltab2x32(:,:,51))
  call Hloop_Q_A(ntryL,G1H8(10),86,nMB,G2H8(26),n2h8(64))
  call Hloop_QZ_A(ntryL,G1H32(30),wf4(:,12),G1H8(15),ngZd,m3h4x8(:,33),heltab2x32(:,:,52))
  call Hloop_Q_A(ntryL,G1H8(15),86,nMB,G2H8(5),n2h8(65))
  call Hloop_QZ_A(ntryL,G1H32(31),wf4(:,11),G1H8(16),ngZd,m3h4x8(:,34),heltab2x32(:,:,53))
  call Hloop_Q_A(ntryL,G1H8(16),89,nMB,G2H8(6),n2h8(66))
call HGT_raise_alpha_OLR(G1H32(32),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(32),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(32),wf8(:,22),G1H4(100),m3h8x4(:,4),heltab2x32(:,:,54))
  call Hloop_QZ_A(ntryL,G1H32(34),wf4(:,11),G1H8(21),ngZd,m3h4x8(:,35),heltab2x32(:,:,55))
  call Hloop_Q_A(ntryL,G1H8(21),89,nMB,G2H8(7),n2h8(67))
  call Hloop_QZ_A(ntryL,G1H32(35),wf4(:,11),G1H8(22),ngZd,m3h4x8(:,36),heltab2x32(:,:,56))
  call Hloop_Q_A(ntryL,G1H8(22),89,nMB,G2H8(8),n2h8(68))
  call Hloop_QS_A(ntryL,G1H32(36),wf16(:,12),G1H2(35),ngH,m3h16x2(:,10),heltab2x32(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(35),95,nMB,G2H2(104),n2h2(82))
call HGT_raise_alpha_OLR(G1H32(37),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(37),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(37),ex6(:),G1H16(35),m3h2x16(:,8),heltab2x32(:,:,58))
  call Hloop_QS_A(ntryL,G1H32(39),wf16(:,12),G1H2(40),ngH,m3h16x2(:,11),heltab2x32(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(40),95,nMB,G2H2(105),n2h2(83))
  call Hloop_QS_A(ntryL,G1H32(40),wf16(:,12),G1H2(41),ngH,m3h16x2(:,12),heltab2x32(:,:,60))
  call Hloop_Q_A(ntryL,G1H2(41),95,nMB,G2H2(106),n2h2(84))
  call Hloop_QZ_A(ntryL,G1H32(41),wf16(:,85),G1H2(45),ngZd,m3h16x2(:,13),heltab2x32(:,:,61))
  call Hloop_Q_A(ntryL,G1H2(45),95,nMB,G2H2(107),n2h2(85))
call HGT_raise_alpha_OLR(G1H32(42),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(42),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(42),ex6(:),G1H16(36),m3h2x16(:,9),heltab2x32(:,:,62))
  call Hloop_QZ_A(ntryL,G1H32(44),wf16(:,85),G1H2(46),ngZd,m3h16x2(:,14),heltab2x32(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(46),95,nMB,G2H2(108),n2h2(86))
  call Hloop_QZ_A(ntryL,G1H32(45),wf16(:,85),G1H2(51),ngZd,m3h16x2(:,15),heltab2x32(:,:,64))
  call Hloop_Q_A(ntryL,G1H2(51),95,nMB,G2H2(109),n2h2(87))
  call Hloop_QZ_A(ntryL,G1H32(46),wf16(:,86),G1H2(52),ngZd,m3h16x2(:,16),heltab2x32(:,:,65))
  call Hloop_Q_A(ntryL,G1H2(52),95,nMB,G2H2(110),n2h2(88))
call HGT_raise_alpha_OLR(G1H32(47),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(47),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(47),ex6(:),G1H16(37),m3h2x16(:,10),heltab2x32(:,:,66))
  call Hloop_QZ_A(ntryL,G1H32(49),wf16(:,86),G1H2(56),ngZd,m3h16x2(:,17),heltab2x32(:,:,67))
  call Hloop_Q_A(ntryL,G1H2(56),95,nMB,G2H2(111),n2h2(89))
  call Hloop_QZ_A(ntryL,G1H32(50),wf16(:,86),G1H2(57),ngZd,m3h16x2(:,18),heltab2x32(:,:,68))
  call Hloop_Q_A(ntryL,G1H2(57),95,nMB,G2H2(112),n2h2(90))
  call Hloop_QZ_A(ntryL,G1H32(51),wf16(:,87),G1H2(62),ngZd,m3h16x2(:,19),heltab2x32(:,:,69))
  call Hloop_Q_A(ntryL,G1H2(62),95,nMB,G2H2(113),n2h2(91))
call HGT_raise_alpha_OLR(G1H32(52),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(52),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(52),ex6(:),G1H16(40),m3h2x16(:,11),heltab2x32(:,:,70))
  call Hloop_QZ_A(ntryL,G1H32(54),wf16(:,87),G1H2(63),ngZd,m3h16x2(:,20),heltab2x32(:,:,71))
  call Hloop_Q_A(ntryL,G1H2(63),95,nMB,G2H2(114),n2h2(92))
  call Hloop_QZ_A(ntryL,G1H32(55),wf16(:,87),G1H2(67),ngZd,m3h16x2(:,21),heltab2x32(:,:,72))
  call Hloop_Q_A(ntryL,G1H2(67),95,nMB,G2H2(115),n2h2(93))
  call Hloop_QZ_A(ntryL,G1H32(56),wf16(:,88),G1H2(68),ngZd,m3h16x2(:,22),heltab2x32(:,:,73))
  call Hloop_Q_A(ntryL,G1H2(68),95,nMB,G2H2(116),n2h2(94))
call HGT_raise_alpha_OLR(G1H32(57),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(57),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(57),ex6(:),G1H16(41),m3h2x16(:,12),heltab2x32(:,:,74))
  call Hloop_QZ_A(ntryL,G1H32(59),wf16(:,88),G1H2(73),ngZd,m3h16x2(:,23),heltab2x32(:,:,75))
  call Hloop_Q_A(ntryL,G1H2(73),95,nMB,G2H2(117),n2h2(95))
  call Hloop_QZ_A(ntryL,G1H32(60),wf16(:,88),G1H2(74),ngZd,m3h16x2(:,24),heltab2x32(:,:,76))
  call Hloop_Q_A(ntryL,G1H2(74),95,nMB,G2H2(118),n2h2(96))
  call Hloop_QZ_A(ntryL,G1H32(61),wf16(:,89),G1H2(78),ngZd,m3h16x2(:,25),heltab2x32(:,:,77))
  call Hloop_Q_A(ntryL,G1H2(78),95,nMB,G2H2(119),n2h2(97))
call HGT_raise_alpha_OLR(G1H32(62),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(62),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(62),ex6(:),G1H16(42),m3h2x16(:,13),heltab2x32(:,:,78))
  call Hloop_QZ_A(ntryL,G1H32(64),wf16(:,89),G1H2(79),ngZd,m3h16x2(:,26),heltab2x32(:,:,79))
  call Hloop_Q_A(ntryL,G1H2(79),95,nMB,G2H2(120),n2h2(98))
  call Hloop_QZ_A(ntryL,G1H32(65),wf16(:,89),G1H2(84),ngZd,m3h16x2(:,27),heltab2x32(:,:,80))
  call Hloop_Q_A(ntryL,G1H2(84),95,nMB,G2H2(121),n2h2(99))
  call Hloop_QZ_A(ntryL,G1H32(66),wf16(:,90),G1H2(85),ngZd,m3h16x2(:,28),heltab2x32(:,:,81))
  call Hloop_Q_A(ntryL,G1H2(85),95,nMB,G2H2(122),n2h2(100))
call HGT_raise_alpha_OLR(G1H32(67),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(67),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(67),ex6(:),G1H16(43),m3h2x16(:,14),heltab2x32(:,:,82))
  call Hloop_QZ_A(ntryL,G1H32(69),wf16(:,90),G1H2(6),ngZd,m3h16x2(:,29),heltab2x32(:,:,83))
  call Hloop_Q_A(ntryL,G1H2(6),95,nMB,G2H2(123),n2h2(101))
  call Hloop_QZ_A(ntryL,G1H32(70),wf16(:,90),G1H2(17),ngZd,m3h16x2(:,30),heltab2x32(:,:,84))
  call Hloop_Q_A(ntryL,G1H2(17),95,nMB,G2H2(124),n2h2(102))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(52),[G2H2(2),G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(54),[G2H2(5),G1H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(51),[G2H2(8),G1H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(53),[G2H2(11),G1H2(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(56),[G2H2(14),G1H2(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(58),[G2H2(17),G1H2(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(55),[G2H2(20),G1H2(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(57),[G2H2(23),G1H2(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(39),[G1H2(25)])
call HGT_OLR(G2H2(25),1,1,2)
call HGT_invQ_OLR(G2H2(25),2,5,2)
call HGT_OLR(G2H2(25),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(25),[G2H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(23),[G2H4(3),G1H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(34),[G1H2(3)])
call HGT_OLR(G2H2(26),1,1,2)
call HGT_invQ_OLR(G2H2(26),2,5,2)
call HGT_OLR(G2H2(26),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(26),[G2H2(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(45),[G2H4(7),G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(46),[G1H2(58)])
call HGT_OLR(G2H2(27),1,1,2)
call HGT_invQ_OLR(G2H2(27),2,5,2)
call HGT_OLR(G2H2(27),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(27),[G2H2(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(133),[G2H4(11),G1H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(50),[G1H2(80)])
call HGT_OLR(G2H2(28),1,1,2)
call HGT_invQ_OLR(G2H2(28),2,5,2)
call HGT_OLR(G2H2(28),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(28),[G2H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(141),[G2H4(15),G1H4(50)])
call HGT_w2_OLR(G1H4(1),1,1,4)
call HGT_w2_invQ_OLR(G1H4(1),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(37),[G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(122),[G2H2(119),G2H2(116),G2H2(113),G2H2(110),G2H2(107) &
    ,G2H2(104),G2H2(101),G2H2(98),G2H2(95),G2H2(45),G2H2(40),G2H2(35),G2H2(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(124),[G2H2(121),G2H2(118),G2H2(115),G2H2(112),G2H2(109) &
    ,G2H2(106),G2H2(103),G2H2(100),G2H2(97),G2H2(48),G2H2(47),G2H2(43),G2H2(42),G2H2(38),G2H2(37),G2H2(33),G2H2(32)])
call HGT_w2_OLR(G1H4(4),1,1,4)
call HGT_w2_invQ_OLR(G1H4(4),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(35),[G1H4(4)])
call HGT_w2_OLR(G1H4(7),1,1,4)
call HGT_w2_invQ_OLR(G1H4(7),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(33),[G1H4(7)])
call HGT_w2_OLR(G1H4(10),1,1,4)
call HGT_w2_invQ_OLR(G1H4(10),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G1H2(59),G1H2(48),G1H2(15),G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(65),[G1H2(54),G1H2(21),G1H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(36),[G1H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G1H2(81),G1H2(70),G1H2(37),G1H2(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(87),[G1H2(76),G1H2(43),G1H2(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(41),[G1H2(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(44),[G1H2(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(49),[G1H2(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(5),[G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(27),[G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1),[G1H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(31),[G1H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(48),[G1H4(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(28),[G1H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(22),[G1H4(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(136),[G1H4(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(18),[G1H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G1H4(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(144),[G1H4(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(64),[G2H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(73),[G2H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(61),[G2H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(76),[G2H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(82),[G2H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(91),[G2H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(79),[G2H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(94),[G2H2(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(65),[G2H4(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(68),[G2H4(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(61),[G1H4(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(73),[G2H4(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(76),[G2H4(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(63),[G1H4(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(97),[G2H4(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(100),[G2H4(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(69),[G1H4(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(105),[G2H4(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(108),[G2H4(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(71),[G1H4(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(161),[G2H4(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(164),[G2H4(148)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(87),[G1H4(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(169),[G2H4(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(172),[G2H4(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(89),[G1H4(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(193),[G2H4(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(196),[G2H4(180)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(95),[G1H4(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(201),[G2H4(185)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(204),[G2H4(188)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(97),[G1H4(93)])
  call Hotf_4pt_reduction(G2H2(52),RedSet_4(28),mass4set(:,3),  & 
G1H2(28),G1H2(39),G1H2(50),G1H2(61),G1H2(72),2)
  call HG1shiftOLR(G1H2(39),16,2)
  call Hotf_4pt_reduction(G2H2(54),RedSet_4(31),mass4set(:,3),  & 
G1H2(83),G1H2(1),G1H2(2),G1H2(7),G1H2(8),2)
  call HG1shiftOLR(G1H2(1),16,2)
  call Hotf_4pt_reduction(G2H2(51),RedSet_4(35),mass4set(:,3),  & 
G1H2(12),G1H2(13),G1H2(18),G1H2(19),G1H2(23),2)
  call HG1shiftOLR(G1H2(13),32,2)
  call Hotf_4pt_reduction(G2H2(53),RedSet_4(38),mass4set(:,3),  & 
G1H2(24),G1H2(29),G1H2(30),G1H2(34),G1H2(35),2)
  call HG1shiftOLR(G1H2(29),32,2)
  call Hotf_4pt_reduction(G2H2(56),RedSet_4(41),mass4set(:,3),  & 
G1H2(40),G1H2(41),G1H2(45),G1H2(46),G1H2(51),2)
  call HG1shiftOLR(G1H2(41),16,2)
  call Hotf_4pt_reduction(G2H2(58),RedSet_4(44),mass4set(:,3),  & 
G1H2(52),G1H2(56),G1H2(57),G1H2(62),G1H2(63),2)
  call HG1shiftOLR(G1H2(56),16,2)
  call Hotf_4pt_reduction(G2H2(55),RedSet_4(47),mass4set(:,3),  & 
G1H2(67),G1H2(68),G1H2(73),G1H2(74),G1H2(78),2)
  call HG1shiftOLR(G1H2(68),32,2)
  call Hotf_4pt_reduction(G2H2(57),RedSet_4(50),mass4set(:,3),  & 
G1H2(79),G1H2(84),G1H2(85),G1H2(6),G1H2(17),2)
  call HG1shiftOLR(G1H2(84),32,2)
  call Hotf_4pt_reduction(G2H2(25),RedSet_4(33),mass4set(:,3),  & 
G1H2(5),G1H2(16),G1H2(27),G1H2(38),G1H2(49),2)
  call HG1shiftOLR(G1H2(16),32,2)
  call Hotf_4pt_reduction(G2H4(23),RedSet_4(54),mass4set(:,2),  & 
G1H4(17),G1H4(28),G1H4(39),G1H4(50),G1H4(1),4)
  call HG1shiftOLR(G1H4(28),10,4)
  call Hotf_4pt_reduction(G2H2(26),RedSet_4(26),mass4set(:,3),  & 
G1H2(60),G1H2(71),G1H2(82),G1H2(25),G1H2(3),2)
  call HG1shiftOLR(G1H2(71),16,2)
  call Hotf_4pt_reduction(G2H4(45),RedSet_4(54),mass4set(:,2),  & 
G1H4(4),G1H4(7),G1H4(10),G1H4(15),G1H4(16),4)
  call HG1shiftOLR(G1H4(7),10,4)
  call Hotf_4pt_reduction(G2H2(27),RedSet_4(43),mass4set(:,3),  & 
G1H2(58),G1H2(80),G1H2(59),G1H2(48),G1H2(15),2)
  call HG1shiftOLR(G1H2(80),16,2)
  call Hotf_4pt_reduction(G2H4(133),RedSet_4(61),mass4set(:,2),  & 
G1H4(23),G1H4(26),G1H4(27),G1H4(34),G1H4(37),4)
  call HG1shiftOLR(G1H4(26),9,4)
  call Hotf_4pt_reduction(G2H2(28),RedSet_4(49),mass4set(:,3),  & 
G1H2(4),G1H2(54),G1H2(21),G1H2(10),G1H2(14),2)
  call HG1shiftOLR(G1H2(54),32,2)
  call Hotf_4pt_reduction(G2H4(141),RedSet_4(61),mass4set(:,2),  & 
G1H4(38),G1H4(45),G1H4(48),G1H4(49),G1H4(56),4)
  call HG1shiftOLR(G1H4(45),9,4)
  call Hotf_4pt_reduction(G2H4(37),RedSet_4(70),mass4set(:,7),  & 
G1H4(57),G1H4(59),G1H4(65),G1H4(67),G1H4(83),4)
  call HG1shiftOLR(G1H4(59),10,4)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(122),ex6(:),G2tensor(1),m3h2x1(:,41),heltab2x2(:,:,41))
call HGT_w2_OLR(G1H4(2),1,1,4)
call HGT_w2_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(2),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,17),heltab2x4(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(3),n2h1(49))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(124),ex6(:),G2tensor(5),m3h2x1(:,42),heltab2x2(:,:,42))
call HGT_w2_OLR(G1H4(3),1,1,4)
call HGT_w2_invQ_OLR(G1H4(3),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(3),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,18),heltab2x4(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(7),n2h1(50))
  call Hotf_4pt_reduction(G2H4(35),RedSet_4(71),mass4set(:,7),  & 
G1H4(85),G1H4(91),G1H4(93),G1H4(2),G1H4(3),4)
  call HG1shiftOLR(G1H4(91),5,4)
call HGT_w2_OLR(G1H4(5),1,1,4)
call HGT_w2_invQ_OLR(G1H4(5),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(5),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,19),heltab2x4(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(9),n2h1(51))
call HGT_w2_OLR(G1H4(6),1,1,4)
call HGT_w2_invQ_OLR(G1H4(6),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(6),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,20),heltab2x4(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,nMB,G2tensor(13),n2h1(52))
  call Hotf_4pt_reduction(G2H4(33),RedSet_4(72),mass4set(:,7),  & 
G1H4(5),G1H4(6),G1H4(101),G1H4(102),G1H4(103),4)
  call HG1shiftOLR(G1H4(6),6,4)
call HGT_w2_OLR(G1H4(8),1,1,4)
call HGT_w2_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(8),wf4(:,12),G1H1(1),ngZd,m3h4x1(:,21),heltab2x4(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(17),n2h1(53))
call HGT_w2_OLR(G1H4(9),1,1,4)
call HGT_w2_invQ_OLR(G1H4(9),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(9),wf4(:,12),G1H1(1),ngZd,m3h4x1(:,22),heltab2x4(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),6,nMB,G2tensor(21),n2h1(54))
  call Hotf_4pt_reduction(G2H4(13),RedSet_4(73),mass4set(:,7),  & 
G1H4(8),G1H4(9),G1H4(104),G1H4(105),G1H4(106),4)
  call HG1shiftOLR(G1H4(9),9,4)
call HGT_w2_OLR(G1H4(11),1,1,4)
call HGT_w2_invQ_OLR(G1H4(11),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(11),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,23),heltab2x4(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(25),n2h1(55))
call HGT_w2_OLR(G1H4(12),1,1,4)
call HGT_w2_invQ_OLR(G1H4(12),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(12),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,24),heltab2x4(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(29),n2h1(56))
  call Hotf_4pt_reduction(G2H2(1),RedSet_4(27),mass4set(:,3),  & 
G1H2(81),G1H2(70),G1H2(37),G1H2(26),G1H2(76),2)
  call HG1shiftOLR(G1H2(70),16,2)
  call Hloop_VQ_A(ntryL,G1H2(9),ex5(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(33),n2h1(57))
  call Hloop_VQ_A(ntryL,G1H2(65),ex5(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(37),n2h1(58))
  call Hloop_VQ_A(ntryL,G1H2(11),ex5(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(41),n2h1(59))
  call Hotf_4pt_reduction(G2H2(36),RedSet_4(30),mass4set(:,3),  & 
G1H2(43),G1H2(32),G1H2(36),G1H2(47),G1H2(69),2)
  call HG1shiftOLR(G1H2(32),16,2)
  call Hloop_VQ_A(ntryL,G1H2(20),ex5(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(45),n2h1(60))
  call Hloop_VQ_A(ntryL,G1H2(22),ex5(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(49),n2h1(61))
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(34),mass4set(:,3),  & 
G1H2(9),G1H2(65),G1H2(11),G1H2(20),G1H2(22),2)
  call HG1shiftOLR(G1H2(65),32,2)
  call Hloop_VA_Q(ntryL,G1H2(31),ex6(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(53),n2h1(62))
  call Hloop_VA_Q(ntryL,G1H2(87),ex6(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(57),n2h1(63))
  call Hloop_VA_Q(ntryL,G1H2(33),ex6(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(58),n2h1(64))
  call Hotf_4pt_reduction(G2H2(41),RedSet_4(37),mass4set(:,3),  & 
G1H2(31),G1H2(87),G1H2(33),G1H2(89),G1H2(90),2)
  call HG1shiftOLR(G1H2(87),32,2)
  call Hloop_VA_Q(ntryL,G1H2(42),ex6(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(59),n2h1(65))
  call Hloop_VA_Q(ntryL,G1H2(44),ex6(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(60),n2h1(66))
  call Hotf_4pt_reduction(G2H2(44),RedSet_4(40),mass4set(:,3),  & 
G1H2(42),G1H2(44),G1H2(91),G1H2(92),G1H2(93),2)
  call HG1shiftOLR(G1H2(44),16,2)
  call Hloop_VQ_A(ntryL,G1H2(53),ex5(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(61),n2h1(67))
  call Hloop_VQ_A(ntryL,G1H2(55),ex5(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(62),n2h1(68))
  call Hloop_VQ_A(ntryL,G1H2(64),ex5(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(63),n2h1(69))
  call Hloop_VQ_A(ntryL,G1H2(66),ex5(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(64),n2h1(70))
  call Hotf_4pt_reduction(G2H2(49),RedSet_4(46),mass4set(:,3),  & 
G1H2(53),G1H2(55),G1H2(64),G1H2(66),G1H2(94),2)
  call HG1shiftOLR(G1H2(55),32,2)
  call Hloop_VA_Q(ntryL,G1H2(75),ex6(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(65),n2h1(71))
  call Hloop_VA_Q(ntryL,G1H2(77),ex6(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(66),n2h1(72))
  call Hloop_VA_Q(ntryL,G1H2(86),ex6(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(67),n2h1(73))
  call Hloop_VA_Q(ntryL,G1H2(88),ex6(:),G1H1(1),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(68),n2h1(74))
  call Hotf_4pt_reduction(G2H4(9),RedSet_4(52),mass4set(:,8),  & 
G1H4(11),G1H4(12),G1H4(107),G1H4(108),G1H4(109),4)
  call HG1shiftOLR(G1H4(12),10,4)
  call Hotf_4pt_reduction(G2H4(5),RedSet_4(53),mass4set(:,8),  & 
G1H4(110),G1H4(111),G1H4(112),G1H4(113),G1H4(114),4)
  call HG1shiftOLR(G1H4(111),10,4)
  call Hloop_AZ_Q(ntryL,G1H4(21),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,25),heltab2x4(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(69),n2h1(75))
  call Hloop_AZ_Q(ntryL,G1H4(22),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,26),heltab2x4(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(70),n2h1(76))
  call Hloop_AZ_Q(ntryL,G2H4(27),wf4(:,5),G2H1(1),ngZd,m3h4x1(:,27),heltab2x4(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(1),n2h1(77))
  call Hotf_4pt_reduction(G2H4(1),RedSet_4(56),mass4set(:,8),  & 
G1H4(21),G1H4(22),G1H4(115),G1H4(116),G1H4(117),4)
  call HG1shiftOLR(G1H4(22),10,4)
  call Hotf_4pt_reduction(G2H4(31),RedSet_4(57),mass4set(:,8),  & 
G1H4(118),G1H4(119),G1H4(120),G1H4(121),G1H4(122),4)
  call HG1shiftOLR(G1H4(119),10,4)
  call Hloop_QZ_A(ntryL,G1H4(32),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,28),heltab2x4(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(71),n2h1(78))
  call Hloop_QZ_A(ntryL,G1H4(33),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,29),heltab2x4(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(72),n2h1(79))
  call Hloop_QZ_A(ntryL,G2H4(48),wf4(:,5),G2H1(1),ngZd,m3h4x1(:,30),heltab2x4(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(2),n2h1(80))
  call Hotf_4pt_reduction(G2H4(28),RedSet_4(59),mass4set(:,8),  & 
G1H4(32),G1H4(33),G1H4(123),G1H4(124),G1H4(125),4)
  call HG1shiftOLR(G1H4(33),9,4)
  call Hotf_4pt_reduction(G2H4(22),RedSet_4(60),mass4set(:,8),  & 
G1H4(126),G1H4(127),G1H4(128),G1H4(129),G1H4(130),4)
  call HG1shiftOLR(G1H4(127),9,4)
  call Hloop_QZ_A(ntryL,G1H4(43),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,31),heltab2x4(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(73),n2h1(81))
  call Hloop_QZ_A(ntryL,G1H4(44),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,32),heltab2x4(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(74),n2h1(82))
  call Hloop_QZ_A(ntryL,G2H4(136),wf4(:,11),G2H1(1),ngZd,m3h4x1(:,33),heltab2x4(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(3),n2h1(83))
  call Hotf_4pt_reduction(G2H4(18),RedSet_4(63),mass4set(:,8),  & 
G1H4(43),G1H4(44),G1H4(131),G1H4(132),G1H4(133),4)
  call HG1shiftOLR(G1H4(44),9,4)
  call Hotf_4pt_reduction(G2H4(6),RedSet_4(64),mass4set(:,8),  & 
G1H4(134),G1H4(135),G1H4(136),G1H4(137),G1H4(138),4)
  call HG1shiftOLR(G1H4(135),9,4)
  call Hloop_AZ_Q(ntryL,G1H4(54),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,34),heltab2x4(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(75),n2h1(84))
  call Hloop_AZ_Q(ntryL,G1H4(55),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,35),heltab2x4(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(76),n2h1(85))
  call Hloop_AZ_Q(ntryL,G2H4(144),wf4(:,11),G2H1(1),ngZd,m3h4x1(:,36),heltab2x4(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(4),n2h1(86))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(64),ex6(:),G2tensor(77),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(73),ex6(:),G2tensor(78),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(61),ex6(:),G2tensor(79),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(76),ex6(:),G2tensor(80),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(82),ex6(:),G2tensor(81),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(91),ex6(:),G2tensor(82),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(79),ex6(:),G2tensor(83),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(94),ex6(:),G2tensor(84),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hotf_4pt_reduction(G2H8(1),RedSet_4(74),mass4set(:,3),  & 
G1H8(33),G1H8(34),G1H8(38),G1H8(39),G1H8(49),8)
  call HG1shiftOLR(G1H8(34),21,8)
  call Hotf_4pt_reduction(G2H8(2),RedSet_4(75),mass4set(:,3),  & 
G1H8(50),G1H8(54),G1H8(55),G1H8(65),G1H8(66),8)
  call HG1shiftOLR(G1H8(54),37,8)
  call Hotf_4pt_reduction(G2H8(3),RedSet_4(11),mass4set(:,3),  & 
G1H8(70),G1H8(71),G1H8(81),G1H8(82),G1H8(86),8)
  call HG1shiftOLR(G1H8(71),26,8)
  call Hotf_4pt_reduction(G2H8(4),RedSet_4(10),mass4set(:,3),  & 
G1H8(87),G1H8(7),G1H8(8),G1H8(12),G1H8(13),8)
  call HG1shiftOLR(G1H8(7),42,8)
  call Hotf_4pt_reduction(G2H8(11),RedSet_4(12),mass4set(:,3),  & 
G1H8(14),G1H8(17),G1H8(19),G1H8(20),G1H8(23),8)
  call HG1shiftOLR(G1H8(17),25,8)
  call Hotf_4pt_reduction(G2H8(9),RedSet_4(13),mass4set(:,3),  & 
G1H8(24),G1H8(26),G1H8(31),G1H8(36),G1H8(32),8)
  call HG1shiftOLR(G1H8(26),41,8)
  call Hotf_4pt_reduction(G2H8(15),RedSet_4(76),mass4set(:,3),  & 
G1H8(37),G1H8(40),G1H8(41),G1H8(42),G1H8(52),8)
  call HG1shiftOLR(G1H8(40),22,8)
  call Hotf_4pt_reduction(G2H8(16),RedSet_4(77),mass4set(:,3),  & 
G1H8(48),G1H8(51),G1H8(53),G1H8(57),G1H8(58),8)
  call HG1shiftOLR(G1H8(51),38,8)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(59),ex6(:),G2tensor(85),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(62),ex6(:),G2tensor(86),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(65),ex5(:),G2tensor(87),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(67),ex5(:),G2tensor(88),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(68),ex5(:),G2tensor(89),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(70),ex5(:),G2tensor(90),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(71),ex6(:),G2tensor(91),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(74),ex6(:),G2tensor(92),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(77),ex6(:),G2tensor(93),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(80),ex6(:),G2tensor(94),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(83),ex5(:),G2tensor(95),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(85),ex5(:),G2tensor(96),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(86),ex5(:),G2tensor(97),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(88),ex5(:),G2tensor(98),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(89),ex6(:),G2tensor(99),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(92),ex6(:),G2tensor(100),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hotf_4pt_reduction(G2H4(2),RedSet_4(54),mass4set(:,5),  & 
G1H4(54),G1H4(55),G1H4(139),G1H4(140),G1H4(141),4)
  call HG1shiftOLR(G1H4(55),10,4)
  call Hloop_AZ_Q(ntryL,G2H4(34),wf4(:,5),G2H1(1),ngZu,m3h4x1(:,37),heltab2x4(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(5),n2h1(87))
  call Hloop_AZ_Q(ntryL,G1H4(42),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,38),heltab2x4(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(101),n2h1(88))
  call Hotf_4pt_reduction(G2H4(16),RedSet_4(54),mass4set(:,6),  & 
G1H4(42),G1H4(142),G1H4(143),G1H4(144),G1H4(145),4)
  call HG1shiftOLR(G1H4(142),10,4)
  call Hloop_AZ_Q(ntryL,G2H4(4),wf4(:,5),G2H1(1),ngZu,m3h4x1(:,39),heltab2x4(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(6),n2h1(89))
  call Hloop_AZ_Q(ntryL,G1H4(53),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,40),heltab2x4(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(102),n2h1(90))
  call Hotf_4pt_reduction(G2H4(32),RedSet_4(54),mass4set(:,5),  & 
G1H4(53),G1H4(146),G1H4(147),G1H4(148),G1H4(149),4)
  call HG1shiftOLR(G1H4(146),10,4)
  call Hloop_QZ_A(ntryL,G2H4(26),wf4(:,5),G2H1(1),ngZu,m3h4x1(:,41),heltab2x4(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(7),n2h1(91))
  call Hloop_QZ_A(ntryL,G1H4(46),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,42),heltab2x4(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(103),n2h1(92))
  call Hotf_4pt_reduction(G2H4(14),RedSet_4(54),mass4set(:,6),  & 
G1H4(46),G1H4(150),G1H4(151),G1H4(152),G1H4(153),4)
  call HG1shiftOLR(G1H4(150),10,4)
  call Hloop_QZ_A(ntryL,G2H4(40),wf4(:,5),G2H1(1),ngZu,m3h4x1(:,43),heltab2x4(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(8),n2h1(93))
  call Hloop_QZ_A(ntryL,G1H4(36),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,44),heltab2x4(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(104),n2h1(94))
  call Hotf_4pt_reduction(G2H4(17),RedSet_4(54),mass4set(:,5),  & 
G1H4(36),G1H4(154),G1H4(155),G1H4(156),G1H4(157),4)
  call HG1shiftOLR(G1H4(154),10,4)
  call Hloop_AZ_Q(ntryL,G2H4(21),wf4(:,5),G2H1(1),ngZd,m3h4x1(:,45),heltab2x4(:,:,79))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(9),n2h1(95))
  call Hloop_AZ_Q(ntryL,G1H4(35),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,46),heltab2x4(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(105),n2h1(96))
  call Hloop_AZ_Q(ntryL,G1H4(41),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,47),heltab2x4(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(106),n2h1(97))
  call Hotf_4pt_reduction(G2H4(41),RedSet_4(54),mass4set(:,5),  & 
G1H4(35),G1H4(41),G1H4(158),G1H4(159),G1H4(160),4)
  call HG1shiftOLR(G1H4(41),10,4)
  call Hloop_QZ_A(ntryL,G2H4(44),wf4(:,5),G2H1(1),ngZd,m3h4x1(:,48),heltab2x4(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(10),n2h1(98))
  call Hloop_QZ_A(ntryL,G1H4(52),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,49),heltab2x4(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(107),n2h1(99))
  call Hloop_QZ_A(ntryL,G1H4(47),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,50),heltab2x4(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(108),n2h1(100))
  call Hotf_4pt_reduction(G2H4(65),RedSet_4(7),mass4set(:,5),  & 
G1H4(52),G1H4(47),G1H4(161),G1H4(162),G1H4(163),4)
  call HG1shiftOLR(G1H4(47),48,4)
  call Hloop_AV_Q(ntryL,G2H4(68),wf4(:,13),G2H1(1),m3h4x1(:,51),heltab2x4(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(11),n2h1(101))
  call Hloop_AV_Q(ntryL,G1H4(61),wf4(:,13),G1H1(1),m3h4x1(:,52),heltab2x4(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(109),n2h1(102))
  call Hotf_4pt_reduction(G2H4(53),RedSet_4(7),mass4set(:,6),  & 
G1H4(61),G1H4(164),G1H4(165),G1H4(166),G1H4(167),4)
  call HG1shiftOLR(G1H4(164),48,4)
  call Hloop_AV_Q(ntryL,G2H4(56),wf4(:,13),G2H1(1),m3h4x1(:,53),heltab2x4(:,:,87))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(12),n2h1(103))
  call Hloop_AV_Q(ntryL,G1H4(58),wf4(:,13),G1H1(1),m3h4x1(:,54),heltab2x4(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(110),n2h1(104))
  call Hotf_4pt_reduction(G2H4(73),RedSet_4(7),mass4set(:,5),  & 
G1H4(58),G1H4(168),G1H4(169),G1H4(170),G1H4(171),4)
  call HG1shiftOLR(G1H4(168),48,4)
  call Hloop_QV_A(ntryL,G2H4(76),wf4(:,13),G2H1(1),m3h4x1(:,55),heltab2x4(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(13),n2h1(105))
  call Hloop_QV_A(ntryL,G1H4(63),wf4(:,13),G1H1(1),m3h4x1(:,56),heltab2x4(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(111),n2h1(106))
  call Hotf_4pt_reduction(G2H4(61),RedSet_4(7),mass4set(:,6),  & 
G1H4(63),G1H4(172),G1H4(173),G1H4(174),G1H4(175),4)
  call HG1shiftOLR(G1H4(172),48,4)
  call Hloop_QV_A(ntryL,G2H4(64),wf4(:,13),G2H1(1),m3h4x1(:,57),heltab2x4(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(14),n2h1(107))
  call Hloop_QV_A(ntryL,G1H4(60),wf4(:,13),G1H1(1),m3h4x1(:,58),heltab2x4(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(112),n2h1(108))
  call Hotf_4pt_reduction(G2H4(69),RedSet_4(7),mass4set(:,2),  & 
G1H4(60),G1H4(176),G1H4(177),G1H4(178),G1H4(179),4)
  call HG1shiftOLR(G1H4(176),48,4)
  call Hloop_AV_Q(ntryL,G2H4(72),wf4(:,13),G2H1(1),m3h4x1(:,59),heltab2x4(:,:,93))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(15),n2h1(109))
  call Hloop_AV_Q(ntryL,G1H4(62),wf4(:,13),G1H1(1),m3h4x1(:,60),heltab2x4(:,:,94))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(113),n2h1(110))
  call Hotf_4pt_reduction(G2H4(77),RedSet_4(7),mass4set(:,2),  & 
G1H4(62),G1H4(180),G1H4(181),G1H4(182),G1H4(183),4)
  call HG1shiftOLR(G1H4(180),48,4)
  call Hloop_QV_A(ntryL,G2H4(80),wf4(:,13),G2H1(1),m3h4x1(:,61),heltab2x4(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(16),n2h1(111))
  call Hloop_QV_A(ntryL,G1H4(64),wf4(:,13),G1H1(1),m3h4x1(:,62),heltab2x4(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(114),n2h1(112))
  call Hotf_4pt_reduction(G2H4(97),RedSet_4(6),mass4set(:,5),  & 
G1H4(64),G1H4(184),G1H4(185),G1H4(186),G1H4(187),4)
  call HG1shiftOLR(G1H4(184),48,4)
  call Hloop_AV_Q(ntryL,G2H4(100),wf4(:,13),G2H1(1),m3h4x1(:,63),heltab2x4(:,:,97))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(17),n2h1(113))
  call Hloop_AV_Q(ntryL,G1H4(69),wf4(:,13),G1H1(1),m3h4x1(:,64),heltab2x4(:,:,98))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(115),n2h1(114))
  call Hotf_4pt_reduction(G2H4(85),RedSet_4(6),mass4set(:,6),  & 
G1H4(69),G1H4(188),G1H4(189),G1H4(190),G1H4(191),4)
  call HG1shiftOLR(G1H4(188),48,4)
  call Hloop_AV_Q(ntryL,G2H4(88),wf4(:,13),G2H1(1),m3h4x1(:,65),heltab2x4(:,:,99))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(18),n2h1(115))
  call Hloop_AV_Q(ntryL,G1H4(66),wf4(:,13),G1H1(1),m3h4x1(:,66),heltab2x4(:,:,100))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(116),n2h1(116))
  call Hotf_4pt_reduction(G2H4(105),RedSet_4(6),mass4set(:,5),  & 
G1H4(66),G1H4(192),G1H4(193),G1H4(194),G1H4(195),4)
  call HG1shiftOLR(G1H4(192),48,4)
  call Hloop_QV_A(ntryL,G2H4(108),wf4(:,13),G2H1(1),m3h4x1(:,67),heltab2x4(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(19),n2h1(117))
  call Hloop_QV_A(ntryL,G1H4(71),wf4(:,13),G1H1(1),m3h4x1(:,68),heltab2x4(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(117),n2h1(118))
  call Hotf_4pt_reduction(G2H4(93),RedSet_4(6),mass4set(:,6),  & 
G1H4(71),G1H4(196),G1H4(197),G1H4(198),G1H4(199),4)
  call HG1shiftOLR(G1H4(196),48,4)
  call Hloop_QV_A(ntryL,G2H4(96),wf4(:,13),G2H1(1),m3h4x1(:,69),heltab2x4(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(20),n2h1(119))
  call Hloop_QV_A(ntryL,G1H4(68),wf4(:,13),G1H1(1),m3h4x1(:,70),heltab2x4(:,:,104))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(118),n2h1(120))
  call Hotf_4pt_reduction(G2H4(101),RedSet_4(6),mass4set(:,2),  & 
G1H4(68),G1H4(200),G1H4(201),G1H4(202),G1H4(203),4)
  call HG1shiftOLR(G1H4(200),48,4)
  call Hloop_AV_Q(ntryL,G2H4(104),wf4(:,13),G2H1(1),m3h4x1(:,71),heltab2x4(:,:,105))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(21),n2h1(121))
  call Hloop_AV_Q(ntryL,G1H4(70),wf4(:,13),G1H1(1),m3h4x1(:,72),heltab2x4(:,:,106))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(119),n2h1(122))
  call Hotf_4pt_reduction(G2H4(109),RedSet_4(6),mass4set(:,2),  & 
G1H4(70),G1H4(204),G1H4(205),G1H4(206),G1H4(207),4)
  call HG1shiftOLR(G1H4(204),48,4)
  call Hloop_QV_A(ntryL,G2H4(112),wf4(:,13),G2H1(1),m3h4x1(:,73),heltab2x4(:,:,107))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(22),n2h1(123))
  call Hloop_QV_A(ntryL,G1H4(72),wf4(:,13),G1H1(1),m3h4x1(:,74),heltab2x4(:,:,108))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(120),n2h1(124))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(10),wf8(:,2),G2tensor(121),m3h8x1(:,1),heltab2x8(:,:,121))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(13),wf8(:,2),G2tensor(122),m3h8x1(:,2),heltab2x8(:,:,122))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(12),wf8(:,4),G2tensor(123),m3h8x1(:,3),heltab2x8(:,:,123))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(25),wf8(:,4),G2tensor(124),m3h8x1(:,4),heltab2x8(:,:,124))
  call Hotf_4pt_reduction(G2H4(113),RedSet_4(61),mass4set(:,5),  & 
G1H4(72),G1H4(208),G1H4(209),G1H4(210),G1H4(211),4)
  call HG1shiftOLR(G1H4(208),9,4)
  call Hloop_QZ_A(ntryL,G2H4(116),wf4(:,11),G2H1(1),ngZu,m3h4x1(:,75),heltab2x4(:,:,109))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(23),n2h1(125))
  call Hloop_QZ_A(ntryL,G1H4(75),wf4(:,11),G1H1(1),ngZu,m3h4x1(:,76),heltab2x4(:,:,110))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(125),n2h1(126))
  call Hotf_4pt_reduction(G2H4(117),RedSet_4(61),mass4set(:,6),  & 
G1H4(75),G1H4(212),G1H4(213),G1H4(214),G1H4(215),4)
  call HG1shiftOLR(G1H4(212),9,4)
  call Hloop_QZ_A(ntryL,G2H4(120),wf4(:,11),G2H1(1),ngZu,m3h4x1(:,77),heltab2x4(:,:,111))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(24),n2h1(127))
  call Hloop_QZ_A(ntryL,G1H4(76),wf4(:,11),G1H1(1),ngZu,m3h4x1(:,78),heltab2x4(:,:,112))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(126),n2h1(128))
  call Hotf_4pt_reduction(G2H4(121),RedSet_4(61),mass4set(:,5),  & 
G1H4(76),G1H4(216),G1H4(217),G1H4(218),G1H4(219),4)
  call HG1shiftOLR(G1H4(216),9,4)
  call Hloop_AZ_Q(ntryL,G2H4(124),wf4(:,11),G2H1(1),ngZu,m3h4x1(:,79),heltab2x4(:,:,113))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(25),n2h1(129))
  call Hloop_AZ_Q(ntryL,G1H4(77),wf4(:,11),G1H1(1),ngZu,m3h4x1(:,80),heltab2x4(:,:,114))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(127),n2h1(130))
  call Hotf_4pt_reduction(G2H4(125),RedSet_4(61),mass4set(:,6),  & 
G1H4(77),G1H4(220),G1H4(221),G1H4(222),G1H4(223),4)
  call HG1shiftOLR(G1H4(220),9,4)
  call Hloop_AZ_Q(ntryL,G2H4(128),wf4(:,11),G2H1(1),ngZu,m3h4x1(:,81),heltab2x4(:,:,115))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(26),n2h1(131))
  call Hloop_AZ_Q(ntryL,G1H4(78),wf4(:,11),G1H1(1),ngZu,m3h4x1(:,82),heltab2x4(:,:,116))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(128),n2h1(132))
  call Hotf_4pt_reduction(G2H4(129),RedSet_4(61),mass4set(:,5),  & 
G1H4(78),G1H4(224),G1H4(225),G1H4(226),G1H4(227),4)
  call HG1shiftOLR(G1H4(224),9,4)
  call Hloop_QZ_A(ntryL,G2H4(132),wf4(:,11),G2H1(1),ngZd,m3h4x1(:,83),heltab2x4(:,:,117))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(27),n2h1(133))
  call Hloop_QZ_A(ntryL,G1H4(79),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,84),heltab2x4(:,:,118))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(129),n2h1(134))
  call Hloop_QZ_A(ntryL,G1H4(80),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,85),heltab2x4(:,:,119))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(130),n2h1(135))
  call Hotf_4pt_reduction(G2H4(137),RedSet_4(61),mass4set(:,5),  & 
G1H4(79),G1H4(80),G1H4(228),G1H4(229),G1H4(230),4)
  call HG1shiftOLR(G1H4(80),9,4)
  call Hloop_AZ_Q(ntryL,G2H4(140),wf4(:,11),G2H1(1),ngZd,m3h4x1(:,86),heltab2x4(:,:,120))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(28),n2h1(136))
  call Hloop_AZ_Q(ntryL,G1H4(81),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,87),heltab2x4(:,:,121))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(131),n2h1(137))
  call Hloop_AZ_Q(ntryL,G1H4(82),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,88),heltab2x4(:,:,122))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(132),n2h1(138))
  call Hotf_4pt_reduction(G2H4(161),RedSet_4(9),mass4set(:,5),  & 
G1H4(81),G1H4(82),G1H4(231),G1H4(232),G1H4(233),4)
  call HG1shiftOLR(G1H4(82),48,4)
  call Hloop_AV_Q(ntryL,G2H4(164),wf4(:,13),G2H1(1),m3h4x1(:,89),heltab2x4(:,:,123))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(29),n2h1(139))
  call Hloop_AV_Q(ntryL,G1H4(87),wf4(:,13),G1H1(1),m3h4x1(:,90),heltab2x4(:,:,124))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(133),n2h1(140))
  call Hotf_4pt_reduction(G2H4(149),RedSet_4(9),mass4set(:,6),  & 
G1H4(87),G1H4(234),G1H4(235),G1H4(236),G1H4(237),4)
  call HG1shiftOLR(G1H4(234),48,4)
  call Hloop_AV_Q(ntryL,G2H4(152),wf4(:,13),G2H1(1),m3h4x1(:,91),heltab2x4(:,:,125))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(30),n2h1(141))
  call Hloop_AV_Q(ntryL,G1H4(84),wf4(:,13),G1H1(1),m3h4x1(:,92),heltab2x4(:,:,126))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(134),n2h1(142))
  call Hotf_4pt_reduction(G2H4(169),RedSet_4(9),mass4set(:,5),  & 
G1H4(84),G1H4(238),G1H4(239),G1H4(240),G1H4(241),4)
  call HG1shiftOLR(G1H4(238),48,4)
  call Hloop_QV_A(ntryL,G2H4(172),wf4(:,13),G2H1(1),m3h4x1(:,93),heltab2x4(:,:,127))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(31),n2h1(143))
  call Hloop_QV_A(ntryL,G1H4(89),wf4(:,13),G1H1(1),m3h4x1(:,94),heltab2x4(:,:,128))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(135),n2h1(144))
  call Hotf_4pt_reduction(G2H4(157),RedSet_4(9),mass4set(:,6),  & 
G1H4(89),G1H4(242),G1H4(243),G1H4(244),G1H4(245),4)
  call HG1shiftOLR(G1H4(242),48,4)
  call Hloop_QV_A(ntryL,G2H4(160),wf4(:,13),G2H1(1),m3h4x1(:,95),heltab2x4(:,:,129))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(32),n2h1(145))
  call Hloop_QV_A(ntryL,G1H4(86),wf4(:,13),G1H1(1),m3h4x1(:,96),heltab2x4(:,:,130))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(136),n2h1(146))
  call Hotf_4pt_reduction(G2H4(165),RedSet_4(9),mass4set(:,2),  & 
G1H4(86),G1H4(246),G1H4(247),G1H4(248),G1H4(249),4)
  call HG1shiftOLR(G1H4(246),48,4)
  call Hloop_AV_Q(ntryL,G2H4(168),wf4(:,13),G2H1(1),m3h4x1(:,97),heltab2x4(:,:,131))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(33),n2h1(147))
  call Hloop_AV_Q(ntryL,G1H4(88),wf4(:,13),G1H1(1),m3h4x1(:,98),heltab2x4(:,:,132))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(137),n2h1(148))
  call Hotf_4pt_reduction(G2H4(173),RedSet_4(9),mass4set(:,2),  & 
G1H4(88),G1H4(250),G1H4(251),G1H4(252),G1H4(253),4)
  call HG1shiftOLR(G1H4(250),48,4)
  call Hloop_QV_A(ntryL,G2H4(176),wf4(:,13),G2H1(1),m3h4x1(:,99),heltab2x4(:,:,133))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(34),n2h1(149))
  call Hloop_QV_A(ntryL,G1H4(90),wf4(:,13),G1H1(1),m3h4x1(:,100),heltab2x4(:,:,134))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(138),n2h1(150))
  call Hotf_4pt_reduction(G2H4(193),RedSet_4(8),mass4set(:,5),  & 
G1H4(90),G1H4(254),G1H4(255),G1H4(256),G1H4(257),4)
  call HG1shiftOLR(G1H4(254),48,4)
  call Hloop_AV_Q(ntryL,G2H4(196),wf4(:,13),G2H1(1),m3h4x1(:,101),heltab2x4(:,:,135))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(35),n2h1(151))
  call Hloop_AV_Q(ntryL,G1H4(95),wf4(:,13),G1H1(1),m3h4x1(:,102),heltab2x4(:,:,136))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(139),n2h1(152))
  call Hotf_4pt_reduction(G2H4(181),RedSet_4(8),mass4set(:,6),  & 
G1H4(95),G1H4(258),G1H4(259),G1H4(260),G1H4(261),4)
  call HG1shiftOLR(G1H4(258),48,4)
  call Hloop_AV_Q(ntryL,G2H4(184),wf4(:,13),G2H1(1),m3h4x1(:,103),heltab2x4(:,:,137))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(36),n2h1(153))
  call Hloop_AV_Q(ntryL,G1H4(92),wf4(:,13),G1H1(1),m3h4x1(:,104),heltab2x4(:,:,138))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(140),n2h1(154))
  call Hotf_4pt_reduction(G2H4(201),RedSet_4(8),mass4set(:,5),  & 
G1H4(92),G1H4(262),G1H4(263),G1H4(264),G1H4(265),4)
  call HG1shiftOLR(G1H4(262),48,4)
  call Hloop_QV_A(ntryL,G2H4(204),wf4(:,13),G2H1(1),m3h4x1(:,105),heltab2x4(:,:,139))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(37),n2h1(155))
  call Hloop_QV_A(ntryL,G1H4(97),wf4(:,13),G1H1(1),m3h4x1(:,106),heltab2x4(:,:,140))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(141),n2h1(156))
  call Hotf_4pt_reduction(G2H4(189),RedSet_4(8),mass4set(:,6),  & 
G1H4(97),G1H4(266),G1H4(267),G1H4(268),G1H4(269),4)
  call HG1shiftOLR(G1H4(266),48,4)
  call Hloop_QV_A(ntryL,G2H4(192),wf4(:,13),G2H1(1),m3h4x1(:,107),heltab2x4(:,:,141))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(38),n2h1(157))
  call Hloop_QV_A(ntryL,G1H4(94),wf4(:,13),G1H1(1),m3h4x1(:,108),heltab2x4(:,:,142))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(142),n2h1(158))
  call Hotf_4pt_reduction(G2H4(197),RedSet_4(8),mass4set(:,2),  & 
G1H4(94),G1H4(270),G1H4(271),G1H4(272),G1H4(273),4)
  call HG1shiftOLR(G1H4(270),48,4)
  call Hloop_AV_Q(ntryL,G2H4(200),wf4(:,13),G2H1(1),m3h4x1(:,109),heltab2x4(:,:,143))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(39),n2h1(159))
  call Hloop_AV_Q(ntryL,G1H4(96),wf4(:,13),G1H1(1),m3h4x1(:,110),heltab2x4(:,:,144))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(143),n2h1(160))
  call Hotf_4pt_reduction(G2H4(205),RedSet_4(8),mass4set(:,2),  & 
G1H4(96),G1H4(274),G1H4(275),G1H4(276),G1H4(277),4)
  call HG1shiftOLR(G1H4(274),48,4)
  call Hloop_QV_A(ntryL,G2H4(208),wf4(:,13),G2H1(1),m3h4x1(:,111),heltab2x4(:,:,145))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(40),n2h1(161))
  call Hloop_QV_A(ntryL,G1H4(98),wf4(:,13),G1H1(1),m3h4x1(:,112),heltab2x4(:,:,146))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(144),n2h1(162))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(22),wf8(:,20),G2tensor(145),m3h8x1(:,5),heltab2x8(:,:,125))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(5),wf8(:,20),G2tensor(146),m3h8x1(:,6),heltab2x8(:,:,126))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(6),wf8(:,22),G2tensor(147),m3h8x1(:,7),heltab2x8(:,:,127))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(8),wf8(:,22),G2tensor(148),m3h8x1(:,8),heltab2x8(:,:,128))
  call Hloop_VQ_A(ntryL,G1H2(28),ex5(:),G1H1(1),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(149),n2h1(163))
  call Hloop_VQ_A(ntryL,G1H2(39),ex5(:),G1H1(1),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(150),n2h1(164))
  call Hloop_VQ_A(ntryL,G1H2(72),ex5(:),G1H1(1),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(151),n2h1(165))
  call Hloop_VQ_A(ntryL,G1H2(83),ex5(:),G1H1(1),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(152),n2h1(166))
  call Hloop_VQ_A(ntryL,G1H2(1),ex5(:),G1H1(1),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(153),n2h1(167))
  call Hloop_VQ_A(ntryL,G1H2(8),ex5(:),G1H1(1),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(154),n2h1(168))
  call Hloop_VA_Q(ntryL,G1H2(12),ex6(:),G1H1(1),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(155),n2h1(169))
  call Hloop_VA_Q(ntryL,G1H2(13),ex6(:),G1H1(1),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,nMB,G2tensor(156),n2h1(170))
  call Hloop_VA_Q(ntryL,G1H2(23),ex6(:),G1H1(1),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(157),n2h1(171))
  call Hloop_VA_Q(ntryL,G1H2(24),ex6(:),G1H1(1),m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(158),n2h1(172))
  call Hloop_VA_Q(ntryL,G1H2(29),ex6(:),G1H1(1),m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,nMB,G2tensor(159),n2h1(173))
  call Hloop_VA_Q(ntryL,G1H2(35),ex6(:),G1H1(1),m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(160),n2h1(174))
  call Hloop_VQ_A(ntryL,G1H2(40),ex5(:),G1H1(1),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(161),n2h1(175))
  call Hloop_VQ_A(ntryL,G1H2(41),ex5(:),G1H1(1),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(162),n2h1(176))
  call Hloop_VQ_A(ntryL,G1H2(51),ex5(:),G1H1(1),m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(163),n2h1(177))
  call Hloop_VQ_A(ntryL,G1H2(52),ex5(:),G1H1(1),m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(164),n2h1(178))
  call Hloop_VQ_A(ntryL,G1H2(56),ex5(:),G1H1(1),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(165),n2h1(179))
  call Hloop_VQ_A(ntryL,G1H2(63),ex5(:),G1H1(1),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(166),n2h1(180))
  call Hloop_VA_Q(ntryL,G1H2(67),ex6(:),G1H1(1),m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(167),n2h1(181))
  call Hloop_VA_Q(ntryL,G1H2(68),ex6(:),G1H1(1),m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,nMB,G2tensor(168),n2h1(182))
  call Hloop_VA_Q(ntryL,G1H2(78),ex6(:),G1H1(1),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(169),n2h1(183))
  call Hloop_VA_Q(ntryL,G1H2(79),ex6(:),G1H1(1),m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(170),n2h1(184))
  call Hloop_VA_Q(ntryL,G1H2(84),ex6(:),G1H1(1),m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,nMB,G2tensor(171),n2h1(185))
  call Hloop_VA_Q(ntryL,G1H2(17),ex6(:),G1H1(1),m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(172),n2h1(186))
  call Hloop_VA_Q(ntryL,G1H2(5),ex6(:),G1H1(1),m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(173),n2h1(187))
  call Hloop_VA_Q(ntryL,G1H2(16),ex6(:),G1H1(1),m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,nMB,G2tensor(174),n2h1(188))
  call Hloop_VA_Q(ntryL,G1H2(49),ex6(:),G1H1(1),m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(175),n2h1(189))
  call Hloop_AZ_Q(ntryL,G1H4(17),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,113),heltab2x4(:,:,147))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(176),n2h1(190))
  call Hloop_AZ_Q(ntryL,G1H4(28),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,114),heltab2x4(:,:,148))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(177),n2h1(191))
  call Hloop_AZ_Q(ntryL,G1H4(1),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,115),heltab2x4(:,:,149))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(178),n2h1(192))
  call Hloop_VQ_A(ntryL,G1H2(60),ex5(:),G1H1(1),m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(179),n2h1(193))
  call Hloop_VQ_A(ntryL,G1H2(71),ex5(:),G1H1(1),m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(180),n2h1(194))
  call Hloop_VQ_A(ntryL,G1H2(3),ex5(:),G1H1(1),m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(181),n2h1(195))
  call Hloop_QZ_A(ntryL,G1H4(4),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,116),heltab2x4(:,:,150))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(182),n2h1(196))
  call Hloop_QZ_A(ntryL,G1H4(7),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,117),heltab2x4(:,:,151))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(183),n2h1(197))
  call Hloop_QZ_A(ntryL,G1H4(16),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,118),heltab2x4(:,:,152))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(184),n2h1(198))
  call Hloop_VQ_A(ntryL,G1H2(58),ex5(:),G1H1(1),m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(185),n2h1(199))
  call Hloop_VQ_A(ntryL,G1H2(80),ex5(:),G1H1(1),m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(186),n2h1(200))
  call Hloop_VQ_A(ntryL,G1H2(15),ex5(:),G1H1(1),m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(187),n2h1(201))
  call Hloop_QZ_A(ntryL,G1H4(23),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,119),heltab2x4(:,:,153))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(188),n2h1(202))
  call Hloop_QZ_A(ntryL,G1H4(26),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,120),heltab2x4(:,:,154))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(189),n2h1(203))
  call Hloop_QZ_A(ntryL,G1H4(37),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,121),heltab2x4(:,:,155))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(190),n2h1(204))
  call Hloop_VA_Q(ntryL,G1H2(4),ex6(:),G1H1(1),m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(191),n2h1(205))
  call Hloop_VA_Q(ntryL,G1H2(54),ex6(:),G1H1(1),m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,nMB,G2tensor(192),n2h1(206))
  call Hloop_VA_Q(ntryL,G1H2(14),ex6(:),G1H1(1),m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(193),n2h1(207))
  call Hloop_AZ_Q(ntryL,G1H4(38),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,122),heltab2x4(:,:,156))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(194),n2h1(208))
  call Hloop_AZ_Q(ntryL,G1H4(45),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,123),heltab2x4(:,:,157))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(195),n2h1(209))
  call Hloop_AZ_Q(ntryL,G1H4(56),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,124),heltab2x4(:,:,158))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(196),n2h1(210))
  call Hloop_QZ_A(ntryL,G1H4(57),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,125),heltab2x4(:,:,159))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(197),n2h1(211))
  call Hloop_QZ_A(ntryL,G1H4(59),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,126),heltab2x4(:,:,160))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(198),n2h1(212))
  call Hloop_QZ_A(ntryL,G1H4(83),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,127),heltab2x4(:,:,161))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(199),n2h1(213))
  call Hloop_QZ_A(ntryL,G1H4(85),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,128),heltab2x4(:,:,162))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(200),n2h1(214))
  call Hloop_QZ_A(ntryL,G1H4(91),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,129),heltab2x4(:,:,163))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,nMB,G2tensor(201),n2h1(215))
  call Hloop_QZ_A(ntryL,G1H4(3),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,130),heltab2x4(:,:,164))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(202),n2h1(216))
  call Hloop_QZ_A(ntryL,G1H4(5),wf4(:,12),G1H1(1),ngZd,m3h4x1(:,131),heltab2x4(:,:,165))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(203),n2h1(217))
  call Hloop_QZ_A(ntryL,G1H4(6),wf4(:,12),G1H1(1),ngZd,m3h4x1(:,132),heltab2x4(:,:,166))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),6,nMB,G2tensor(204),n2h1(218))
  call Hloop_QZ_A(ntryL,G1H4(103),wf4(:,12),G1H1(1),ngZd,m3h4x1(:,133),heltab2x4(:,:,167))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(205),n2h1(219))
  call Hloop_QZ_A(ntryL,G1H4(8),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,134),heltab2x4(:,:,168))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(206),n2h1(220))
  call Hloop_QZ_A(ntryL,G1H4(9),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,135),heltab2x4(:,:,169))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(207),n2h1(221))
  call Hloop_QZ_A(ntryL,G1H4(106),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,136),heltab2x4(:,:,170))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(208),n2h1(222))
  call Hloop_VQ_A(ntryL,G1H2(81),ex5(:),G1H1(1),m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(209),n2h1(223))
  call Hloop_VQ_A(ntryL,G1H2(70),ex5(:),G1H1(1),m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(210),n2h1(224))
  call Hloop_VQ_A(ntryL,G1H2(76),ex5(:),G1H1(1),m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(211),n2h1(225))
  call Hloop_VQ_A(ntryL,G1H2(43),ex5(:),G1H1(1),m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(212),n2h1(226))
  call Hloop_VQ_A(ntryL,G1H2(32),ex5(:),G1H1(1),m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(213),n2h1(227))
  call Hloop_VQ_A(ntryL,G1H2(69),ex5(:),G1H1(1),m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(214),n2h1(228))
  call Hloop_VA_Q(ntryL,G1H2(9),ex6(:),G1H1(1),m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(215),n2h1(229))
  call Hloop_VA_Q(ntryL,G1H2(65),ex6(:),G1H1(1),m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,nMB,G2tensor(216),n2h1(230))
  call Hloop_VA_Q(ntryL,G1H2(22),ex6(:),G1H1(1),m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(217),n2h1(231))
  call Hloop_VA_Q(ntryL,G1H2(31),ex6(:),G1H1(1),m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(218),n2h1(232))
  call Hloop_VA_Q(ntryL,G1H2(87),ex6(:),G1H1(1),m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,nMB,G2tensor(219),n2h1(233))
  call Hloop_VA_Q(ntryL,G1H2(90),ex6(:),G1H1(1),m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(220),n2h1(234))
  call Hloop_VQ_A(ntryL,G1H2(42),ex5(:),G1H1(1),m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(221),n2h1(235))
  call Hloop_VQ_A(ntryL,G1H2(44),ex5(:),G1H1(1),m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(222),n2h1(236))
  call Hloop_VQ_A(ntryL,G1H2(93),ex5(:),G1H1(1),m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(223),n2h1(237))
  call Hloop_VA_Q(ntryL,G1H2(53),ex6(:),G1H1(1),m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(224),n2h1(238))
  call Hloop_VA_Q(ntryL,G1H2(55),ex6(:),G1H1(1),m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,nMB,G2tensor(225),n2h1(239))
  call Hloop_VA_Q(ntryL,G1H2(94),ex6(:),G1H1(1),m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(226),n2h1(240))
  call Hloop_AZ_Q(ntryL,G1H4(11),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,137),heltab2x4(:,:,171))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(227),n2h1(241))
  call Hloop_AZ_Q(ntryL,G1H4(12),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,138),heltab2x4(:,:,172))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(228),n2h1(242))
  call Hloop_AZ_Q(ntryL,G1H4(109),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,139),heltab2x4(:,:,173))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(229),n2h1(243))
  call Hloop_AZ_Q(ntryL,G1H4(110),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,140),heltab2x4(:,:,174))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(230),n2h1(244))
  call Hloop_AZ_Q(ntryL,G1H4(111),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,141),heltab2x4(:,:,175))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(231),n2h1(245))
  call Hloop_AZ_Q(ntryL,G1H4(114),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,142),heltab2x4(:,:,176))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(232),n2h1(246))
  call Hloop_QZ_A(ntryL,G1H4(21),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,143),heltab2x4(:,:,177))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(233),n2h1(247))
  call Hloop_QZ_A(ntryL,G1H4(22),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,144),heltab2x4(:,:,178))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(234),n2h1(248))
  call Hloop_QZ_A(ntryL,G1H4(117),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,145),heltab2x4(:,:,179))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(235),n2h1(249))
  call Hloop_QZ_A(ntryL,G1H4(118),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,146),heltab2x4(:,:,180))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(236),n2h1(250))
  call Hloop_QZ_A(ntryL,G1H4(119),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,147),heltab2x4(:,:,181))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(237),n2h1(251))
  call Hloop_QZ_A(ntryL,G1H4(122),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,148),heltab2x4(:,:,182))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(238),n2h1(252))
  call Hloop_QZ_A(ntryL,G1H4(32),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,149),heltab2x4(:,:,183))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(239),n2h1(253))
  call Hloop_QZ_A(ntryL,G1H4(33),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,150),heltab2x4(:,:,184))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(240),n2h1(254))
  call Hloop_QZ_A(ntryL,G1H4(125),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,151),heltab2x4(:,:,185))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(241),n2h1(255))
  call Hloop_QZ_A(ntryL,G1H4(126),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,152),heltab2x4(:,:,186))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(242),n2h1(256))
  call Hloop_QZ_A(ntryL,G1H4(127),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,153),heltab2x4(:,:,187))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(243),n2h1(257))
  call Hloop_QZ_A(ntryL,G1H4(130),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,154),heltab2x4(:,:,188))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(244),n2h1(258))
  call Hloop_AZ_Q(ntryL,G1H4(43),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,155),heltab2x4(:,:,189))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(245),n2h1(259))
  call Hloop_AZ_Q(ntryL,G1H4(44),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,156),heltab2x4(:,:,190))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(246),n2h1(260))
  call Hloop_AZ_Q(ntryL,G1H4(133),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,157),heltab2x4(:,:,191))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(247),n2h1(261))
  call Hloop_AZ_Q(ntryL,G1H4(134),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,158),heltab2x4(:,:,192))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(248),n2h1(262))
  call Hloop_AZ_Q(ntryL,G1H4(135),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,159),heltab2x4(:,:,193))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(249),n2h1(263))
  call Hloop_AZ_Q(ntryL,G1H4(138),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,160),heltab2x4(:,:,194))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(250),n2h1(264))
  call Hloop_VQ_A(ntryL,G1H8(33),wf8(:,7),G1H1(1),m3h8x1(:,9),heltab2x8(:,:,129))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(251),n2h1(265))
  call Hloop_VQ_A(ntryL,G1H8(34),wf8(:,7),G1H1(1),m3h8x1(:,10),heltab2x8(:,:,130))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),21,nMB,G2tensor(252),n2h1(266))
  call Hloop_VQ_A(ntryL,G1H8(49),wf8(:,7),G1H1(1),m3h8x1(:,11),heltab2x8(:,:,131))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(253),n2h1(267))
  call Hloop_VA_Q(ntryL,G1H8(50),wf8(:,2),G1H1(1),m3h8x1(:,12),heltab2x8(:,:,132))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(254),n2h1(268))
  call Hloop_VA_Q(ntryL,G1H8(54),wf8(:,2),G1H1(1),m3h8x1(:,13),heltab2x8(:,:,133))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),37,nMB,G2tensor(255),n2h1(269))
  call Hloop_VA_Q(ntryL,G1H8(66),wf8(:,2),G1H1(1),m3h8x1(:,14),heltab2x8(:,:,134))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(256),n2h1(270))
  call Hloop_VQ_A(ntryL,G1H8(70),wf8(:,9),G1H1(1),m3h8x1(:,15),heltab2x8(:,:,135))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(257),n2h1(271))
  call Hloop_VQ_A(ntryL,G1H8(71),wf8(:,9),G1H1(1),m3h8x1(:,16),heltab2x8(:,:,136))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),26,nMB,G2tensor(258),n2h1(272))
  call Hloop_VQ_A(ntryL,G1H8(86),wf8(:,9),G1H1(1),m3h8x1(:,17),heltab2x8(:,:,137))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(259),n2h1(273))
  call Hloop_VA_Q(ntryL,G1H8(87),wf8(:,4),G1H1(1),m3h8x1(:,18),heltab2x8(:,:,138))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(260),n2h1(274))
  call Hloop_VA_Q(ntryL,G1H8(7),wf8(:,4),G1H1(1),m3h8x1(:,19),heltab2x8(:,:,139))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),42,nMB,G2tensor(261),n2h1(275))
  call Hloop_VA_Q(ntryL,G1H8(13),wf8(:,4),G1H1(1),m3h8x1(:,20),heltab2x8(:,:,140))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(262),n2h1(276))
  call Hloop_VQ_A(ntryL,G1H8(14),wf8(:,24),G1H1(1),m3h8x1(:,21),heltab2x8(:,:,141))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(263),n2h1(277))
  call Hloop_VQ_A(ntryL,G1H8(17),wf8(:,24),G1H1(1),m3h8x1(:,22),heltab2x8(:,:,142))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),25,nMB,G2tensor(264),n2h1(278))
  call Hloop_VQ_A(ntryL,G1H8(23),wf8(:,24),G1H1(1),m3h8x1(:,23),heltab2x8(:,:,143))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(265),n2h1(279))
  call Hloop_VA_Q(ntryL,G1H8(24),wf8(:,20),G1H1(1),m3h8x1(:,24),heltab2x8(:,:,144))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(266),n2h1(280))
  call Hloop_VA_Q(ntryL,G1H8(26),wf8(:,20),G1H1(1),m3h8x1(:,25),heltab2x8(:,:,145))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),41,nMB,G2tensor(267),n2h1(281))
  call Hloop_VA_Q(ntryL,G1H8(32),wf8(:,20),G1H1(1),m3h8x1(:,26),heltab2x8(:,:,146))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(268),n2h1(282))
  call Hloop_VQ_A(ntryL,G1H8(37),wf8(:,26),G1H1(1),m3h8x1(:,27),heltab2x8(:,:,147))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(269),n2h1(283))
  call Hloop_VQ_A(ntryL,G1H8(40),wf8(:,26),G1H1(1),m3h8x1(:,28),heltab2x8(:,:,148))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),22,nMB,G2tensor(270),n2h1(284))
  call Hloop_VQ_A(ntryL,G1H8(52),wf8(:,26),G1H1(1),m3h8x1(:,29),heltab2x8(:,:,149))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(271),n2h1(285))
  call Hloop_VA_Q(ntryL,G1H8(48),wf8(:,22),G1H1(1),m3h8x1(:,30),heltab2x8(:,:,150))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(272),n2h1(286))
  call Hloop_VA_Q(ntryL,G1H8(51),wf8(:,22),G1H1(1),m3h8x1(:,31),heltab2x8(:,:,151))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),38,nMB,G2tensor(273),n2h1(287))
  call Hloop_VA_Q(ntryL,G1H8(58),wf8(:,22),G1H1(1),m3h8x1(:,32),heltab2x8(:,:,152))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(274),n2h1(288))
  call Hloop_AZ_Q(ntryL,G1H4(54),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,161),heltab2x4(:,:,195))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(275),n2h1(289))
  call Hloop_AZ_Q(ntryL,G1H4(55),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,162),heltab2x4(:,:,196))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(276),n2h1(290))
  call Hloop_AZ_Q(ntryL,G1H4(141),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,163),heltab2x4(:,:,197))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(277),n2h1(291))
  call Hloop_AZ_Q(ntryL,G1H4(42),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,164),heltab2x4(:,:,198))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(278),n2h1(292))
  call Hloop_AZ_Q(ntryL,G1H4(142),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,165),heltab2x4(:,:,199))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMT,G2tensor(279),n2h1(293))
  call Hloop_AZ_Q(ntryL,G1H4(145),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,166),heltab2x4(:,:,200))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(280),n2h1(294))
  call Hloop_QZ_A(ntryL,G1H4(53),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,167),heltab2x4(:,:,201))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(281),n2h1(295))
  call Hloop_QZ_A(ntryL,G1H4(146),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,168),heltab2x4(:,:,202))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(282),n2h1(296))
  call Hloop_QZ_A(ntryL,G1H4(149),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,169),heltab2x4(:,:,203))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(283),n2h1(297))
  call Hloop_QZ_A(ntryL,G1H4(46),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,170),heltab2x4(:,:,204))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(284),n2h1(298))
  call Hloop_QZ_A(ntryL,G1H4(150),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,171),heltab2x4(:,:,205))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,nMT,G2tensor(285),n2h1(299))
  call Hloop_QZ_A(ntryL,G1H4(153),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,172),heltab2x4(:,:,206))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(286),n2h1(300))
  call Hloop_AZ_Q(ntryL,G1H4(36),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,173),heltab2x4(:,:,207))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(287),n2h1(301))
  call Hloop_AZ_Q(ntryL,G1H4(154),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,174),heltab2x4(:,:,208))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(288),n2h1(302))
  call Hloop_AZ_Q(ntryL,G1H4(157),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,175),heltab2x4(:,:,209))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(289),n2h1(303))
  call Hloop_QZ_A(ntryL,G1H4(35),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,176),heltab2x4(:,:,210))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(290),n2h1(304))
  call Hloop_QZ_A(ntryL,G1H4(41),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,177),heltab2x4(:,:,211))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(291),n2h1(305))
  call Hloop_QZ_A(ntryL,G1H4(160),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,178),heltab2x4(:,:,212))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(292),n2h1(306))
  call Hloop_AV_Q(ntryL,G1H4(52),wf4(:,13),G1H1(1),m3h4x1(:,179),heltab2x4(:,:,213))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(293),n2h1(307))
  call Hloop_AV_Q(ntryL,G1H4(47),wf4(:,13),G1H1(1),m3h4x1(:,180),heltab2x4(:,:,214))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,0,G2tensor(294),n2h1(308))
  call Hloop_AV_Q(ntryL,G1H4(163),wf4(:,13),G1H1(1),m3h4x1(:,181),heltab2x4(:,:,215))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(295),n2h1(309))
  call Hloop_AV_Q(ntryL,G1H4(61),wf4(:,13),G1H1(1),m3h4x1(:,182),heltab2x4(:,:,216))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(296),n2h1(310))
  call Hloop_AV_Q(ntryL,G1H4(164),wf4(:,13),G1H1(1),m3h4x1(:,183),heltab2x4(:,:,217))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,nMT,G2tensor(297),n2h1(311))
  call Hloop_AV_Q(ntryL,G1H4(167),wf4(:,13),G1H1(1),m3h4x1(:,184),heltab2x4(:,:,218))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(298),n2h1(312))
  call Hloop_QV_A(ntryL,G1H4(58),wf4(:,13),G1H1(1),m3h4x1(:,185),heltab2x4(:,:,219))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(299),n2h1(313))
  call Hloop_QV_A(ntryL,G1H4(168),wf4(:,13),G1H1(1),m3h4x1(:,186),heltab2x4(:,:,220))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,0,G2tensor(300),n2h1(314))
  call Hloop_QV_A(ntryL,G1H4(171),wf4(:,13),G1H1(1),m3h4x1(:,187),heltab2x4(:,:,221))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(301),n2h1(315))
  call Hloop_QV_A(ntryL,G1H4(63),wf4(:,13),G1H1(1),m3h4x1(:,188),heltab2x4(:,:,222))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(302),n2h1(316))
  call Hloop_QV_A(ntryL,G1H4(172),wf4(:,13),G1H1(1),m3h4x1(:,189),heltab2x4(:,:,223))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,nMT,G2tensor(303),n2h1(317))
  call Hloop_QV_A(ntryL,G1H4(175),wf4(:,13),G1H1(1),m3h4x1(:,190),heltab2x4(:,:,224))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(304),n2h1(318))
  call Hloop_AV_Q(ntryL,G1H4(60),wf4(:,13),G1H1(1),m3h4x1(:,191),heltab2x4(:,:,225))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(305),n2h1(319))
  call Hloop_AV_Q(ntryL,G1H4(176),wf4(:,13),G1H1(1),m3h4x1(:,192),heltab2x4(:,:,226))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,nMB,G2tensor(306),n2h1(320))
  call Hloop_AV_Q(ntryL,G1H4(179),wf4(:,13),G1H1(1),m3h4x1(:,193),heltab2x4(:,:,227))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(307),n2h1(321))
  call Hloop_QV_A(ntryL,G1H4(62),wf4(:,13),G1H1(1),m3h4x1(:,194),heltab2x4(:,:,228))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(308),n2h1(322))
  call Hloop_QV_A(ntryL,G1H4(180),wf4(:,13),G1H1(1),m3h4x1(:,195),heltab2x4(:,:,229))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,nMB,G2tensor(309),n2h1(323))
  call Hloop_QV_A(ntryL,G1H4(183),wf4(:,13),G1H1(1),m3h4x1(:,196),heltab2x4(:,:,230))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(310),n2h1(324))
  call Hloop_AV_Q(ntryL,G1H4(64),wf4(:,13),G1H1(1),m3h4x1(:,197),heltab2x4(:,:,231))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(311),n2h1(325))
  call Hloop_AV_Q(ntryL,G1H4(184),wf4(:,13),G1H1(1),m3h4x1(:,198),heltab2x4(:,:,232))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,0,G2tensor(312),n2h1(326))
  call Hloop_AV_Q(ntryL,G1H4(187),wf4(:,13),G1H1(1),m3h4x1(:,199),heltab2x4(:,:,233))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(313),n2h1(327))
  call Hloop_AV_Q(ntryL,G1H4(69),wf4(:,13),G1H1(1),m3h4x1(:,200),heltab2x4(:,:,234))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(314),n2h1(328))
  call Hloop_AV_Q(ntryL,G1H4(188),wf4(:,13),G1H1(1),m3h4x1(:,201),heltab2x4(:,:,235))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,nMT,G2tensor(315),n2h1(329))
  call Hloop_AV_Q(ntryL,G1H4(191),wf4(:,13),G1H1(1),m3h4x1(:,202),heltab2x4(:,:,236))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(316),n2h1(330))
  call Hloop_QV_A(ntryL,G1H4(66),wf4(:,13),G1H1(1),m3h4x1(:,203),heltab2x4(:,:,237))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(317),n2h1(331))
  call Hloop_QV_A(ntryL,G1H4(192),wf4(:,13),G1H1(1),m3h4x1(:,204),heltab2x4(:,:,238))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,0,G2tensor(318),n2h1(332))
  call Hloop_QV_A(ntryL,G1H4(195),wf4(:,13),G1H1(1),m3h4x1(:,205),heltab2x4(:,:,239))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(319),n2h1(333))
  call Hloop_QV_A(ntryL,G1H4(71),wf4(:,13),G1H1(1),m3h4x1(:,206),heltab2x4(:,:,240))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(320),n2h1(334))
  call Hloop_QV_A(ntryL,G1H4(196),wf4(:,13),G1H1(1),m3h4x1(:,207),heltab2x4(:,:,241))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,nMT,G2tensor(321),n2h1(335))
  call Hloop_QV_A(ntryL,G1H4(199),wf4(:,13),G1H1(1),m3h4x1(:,208),heltab2x4(:,:,242))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(322),n2h1(336))
  call Hloop_AV_Q(ntryL,G1H4(68),wf4(:,13),G1H1(1),m3h4x1(:,209),heltab2x4(:,:,243))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(323),n2h1(337))
  call Hloop_AV_Q(ntryL,G1H4(200),wf4(:,13),G1H1(1),m3h4x1(:,210),heltab2x4(:,:,244))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,nMB,G2tensor(324),n2h1(338))
  call Hloop_AV_Q(ntryL,G1H4(203),wf4(:,13),G1H1(1),m3h4x1(:,211),heltab2x4(:,:,245))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(325),n2h1(339))
  call Hloop_QV_A(ntryL,G1H4(70),wf4(:,13),G1H1(1),m3h4x1(:,212),heltab2x4(:,:,246))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(326),n2h1(340))
  call Hloop_QV_A(ntryL,G1H4(204),wf4(:,13),G1H1(1),m3h4x1(:,213),heltab2x4(:,:,247))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,nMB,G2tensor(327),n2h1(341))
  call Hloop_QV_A(ntryL,G1H4(207),wf4(:,13),G1H1(1),m3h4x1(:,214),heltab2x4(:,:,248))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(328),n2h1(342))
  call Hloop_QZ_A(ntryL,G1H4(72),wf4(:,11),G1H1(1),ngZu,m3h4x1(:,215),heltab2x4(:,:,249))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(329),n2h1(343))
  call Hloop_QZ_A(ntryL,G1H4(208),wf4(:,11),G1H1(1),ngZu,m3h4x1(:,216),heltab2x4(:,:,250))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(330),n2h1(344))
  call Hloop_QZ_A(ntryL,G1H4(211),wf4(:,11),G1H1(1),ngZu,m3h4x1(:,217),heltab2x4(:,:,251))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(331),n2h1(345))
  call Hloop_QZ_A(ntryL,G1H4(75),wf4(:,11),G1H1(1),ngZu,m3h4x1(:,218),heltab2x4(:,:,252))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(332),n2h1(346))
  call Hloop_QZ_A(ntryL,G1H4(212),wf4(:,11),G1H1(1),ngZu,m3h4x1(:,219),heltab2x4(:,:,253))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(333),n2h1(347))
  call Hloop_QZ_A(ntryL,G1H4(215),wf4(:,11),G1H1(1),ngZu,m3h4x1(:,220),heltab2x4(:,:,254))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(334),n2h1(348))
  call Hloop_AZ_Q(ntryL,G1H4(76),wf4(:,11),G1H1(1),ngZu,m3h4x1(:,221),heltab2x4(:,:,255))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(335),n2h1(349))
  call Hloop_AZ_Q(ntryL,G1H4(216),wf4(:,11),G1H1(1),ngZu,m3h4x1(:,222),heltab2x4(:,:,256))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,0,G2tensor(336),n2h1(350))
  call Hloop_AZ_Q(ntryL,G1H4(219),wf4(:,11),G1H1(1),ngZu,m3h4x1(:,223),heltab2x4(:,:,257))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(337),n2h1(351))
  call Hloop_AZ_Q(ntryL,G1H4(77),wf4(:,11),G1H1(1),ngZu,m3h4x1(:,224),heltab2x4(:,:,258))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(338),n2h1(352))
  call Hloop_AZ_Q(ntryL,G1H4(220),wf4(:,11),G1H1(1),ngZu,m3h4x1(:,225),heltab2x4(:,:,259))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(339),n2h1(353))
  call Hloop_AZ_Q(ntryL,G1H4(223),wf4(:,11),G1H1(1),ngZu,m3h4x1(:,226),heltab2x4(:,:,260))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(340),n2h1(354))
  call Hloop_QZ_A(ntryL,G1H4(78),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,227),heltab2x4(:,:,261))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(341),n2h1(355))
  call Hloop_QZ_A(ntryL,G1H4(224),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,228),heltab2x4(:,:,262))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(342),n2h1(356))
  call Hloop_QZ_A(ntryL,G1H4(227),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,229),heltab2x4(:,:,263))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(343),n2h1(357))
  call Hloop_AZ_Q(ntryL,G1H4(79),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,230),heltab2x4(:,:,264))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(344),n2h1(358))
  call Hloop_AZ_Q(ntryL,G1H4(80),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,231),heltab2x4(:,:,265))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,0,G2tensor(345),n2h1(359))
  call Hloop_AZ_Q(ntryL,G1H4(230),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,232),heltab2x4(:,:,266))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(346),n2h1(360))
  call Hloop_AV_Q(ntryL,G1H4(81),wf4(:,13),G1H1(1),m3h4x1(:,233),heltab2x4(:,:,267))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(347),n2h1(361))
  call Hloop_AV_Q(ntryL,G1H4(82),wf4(:,13),G1H1(1),m3h4x1(:,234),heltab2x4(:,:,268))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,0,G2tensor(348),n2h1(362))
  call Hloop_AV_Q(ntryL,G1H4(233),wf4(:,13),G1H1(1),m3h4x1(:,235),heltab2x4(:,:,269))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(349),n2h1(363))
  call Hloop_AV_Q(ntryL,G1H4(87),wf4(:,13),G1H1(1),m3h4x1(:,236),heltab2x4(:,:,270))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(350),n2h1(364))
  call Hloop_AV_Q(ntryL,G1H4(234),wf4(:,13),G1H1(1),m3h4x1(:,237),heltab2x4(:,:,271))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,nMT,G2tensor(351),n2h1(365))
  call Hloop_AV_Q(ntryL,G1H4(237),wf4(:,13),G1H1(1),m3h4x1(:,238),heltab2x4(:,:,272))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(352),n2h1(366))
  call Hloop_QV_A(ntryL,G1H4(84),wf4(:,13),G1H1(1),m3h4x1(:,239),heltab2x4(:,:,273))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(353),n2h1(367))
  call Hloop_QV_A(ntryL,G1H4(238),wf4(:,13),G1H1(1),m3h4x1(:,240),heltab2x4(:,:,274))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,0,G2tensor(354),n2h1(368))
  call Hloop_QV_A(ntryL,G1H4(241),wf4(:,13),G1H1(1),m3h4x1(:,241),heltab2x4(:,:,275))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(355),n2h1(369))
  call Hloop_QV_A(ntryL,G1H4(89),wf4(:,13),G1H1(1),m3h4x1(:,242),heltab2x4(:,:,276))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(356),n2h1(370))
  call Hloop_QV_A(ntryL,G1H4(242),wf4(:,13),G1H1(1),m3h4x1(:,243),heltab2x4(:,:,277))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,nMT,G2tensor(357),n2h1(371))
  call Hloop_QV_A(ntryL,G1H4(245),wf4(:,13),G1H1(1),m3h4x1(:,244),heltab2x4(:,:,278))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(358),n2h1(372))
  call Hloop_AV_Q(ntryL,G1H4(86),wf4(:,13),G1H1(1),m3h4x1(:,245),heltab2x4(:,:,279))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(359),n2h1(373))
  call Hloop_AV_Q(ntryL,G1H4(246),wf4(:,13),G1H1(1),m3h4x1(:,246),heltab2x4(:,:,280))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,nMB,G2tensor(360),n2h1(374))
  call Hloop_AV_Q(ntryL,G1H4(249),wf4(:,13),G1H1(1),m3h4x1(:,247),heltab2x4(:,:,281))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(361),n2h1(375))
  call Hloop_QV_A(ntryL,G1H4(88),wf4(:,13),G1H1(1),m3h4x1(:,248),heltab2x4(:,:,282))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(362),n2h1(376))
  call Hloop_QV_A(ntryL,G1H4(250),wf4(:,13),G1H1(1),m3h4x1(:,249),heltab2x4(:,:,283))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,nMB,G2tensor(363),n2h1(377))
  call Hloop_QV_A(ntryL,G1H4(253),wf4(:,13),G1H1(1),m3h4x1(:,250),heltab2x4(:,:,284))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(364),n2h1(378))
  call Hloop_AV_Q(ntryL,G1H4(90),wf4(:,13),G1H1(1),m3h4x1(:,251),heltab2x4(:,:,285))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(365),n2h1(379))
  call Hloop_AV_Q(ntryL,G1H4(254),wf4(:,13),G1H1(1),m3h4x1(:,252),heltab2x4(:,:,286))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,0,G2tensor(366),n2h1(380))
  call Hloop_AV_Q(ntryL,G1H4(257),wf4(:,13),G1H1(1),m3h4x1(:,253),heltab2x4(:,:,287))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(367),n2h1(381))
  call Hloop_AV_Q(ntryL,G1H4(95),wf4(:,13),G1H1(1),m3h4x1(:,254),heltab2x4(:,:,288))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(368),n2h1(382))
  call Hloop_AV_Q(ntryL,G1H4(258),wf4(:,13),G1H1(1),m3h4x1(:,255),heltab2x4(:,:,289))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,nMT,G2tensor(369),n2h1(383))
  call Hloop_AV_Q(ntryL,G1H4(261),wf4(:,13),G1H1(1),m3h4x1(:,256),heltab2x4(:,:,290))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(370),n2h1(384))
  call Hloop_QV_A(ntryL,G1H4(92),wf4(:,13),G1H1(1),m3h4x1(:,257),heltab2x4(:,:,291))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(371),n2h1(385))
  call Hloop_QV_A(ntryL,G1H4(262),wf4(:,13),G1H1(1),m3h4x1(:,258),heltab2x4(:,:,292))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,0,G2tensor(372),n2h1(386))
  call Hloop_QV_A(ntryL,G1H4(265),wf4(:,13),G1H1(1),m3h4x1(:,259),heltab2x4(:,:,293))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(373),n2h1(387))
  call Hloop_QV_A(ntryL,G1H4(97),wf4(:,13),G1H1(1),m3h4x1(:,260),heltab2x4(:,:,294))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(374),n2h1(388))
  call Hloop_QV_A(ntryL,G1H4(266),wf4(:,13),G1H1(1),m3h4x1(:,261),heltab2x4(:,:,295))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,nMT,G2tensor(375),n2h1(389))
  call Hloop_QV_A(ntryL,G1H4(269),wf4(:,13),G1H1(1),m3h4x1(:,262),heltab2x4(:,:,296))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(376),n2h1(390))
  call Hloop_AV_Q(ntryL,G1H4(94),wf4(:,13),G1H1(1),m3h4x1(:,263),heltab2x4(:,:,297))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(377),n2h1(391))
  call Hloop_AV_Q(ntryL,G1H4(270),wf4(:,13),G1H1(1),m3h4x1(:,264),heltab2x4(:,:,298))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,nMB,G2tensor(378),n2h1(392))
  call Hloop_AV_Q(ntryL,G1H4(273),wf4(:,13),G1H1(1),m3h4x1(:,265),heltab2x4(:,:,299))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(379),n2h1(393))
  call Hloop_QV_A(ntryL,G1H4(96),wf4(:,13),G1H1(1),m3h4x1(:,266),heltab2x4(:,:,300))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(380),n2h1(394))
  call Hloop_QV_A(ntryL,G1H4(274),wf4(:,13),G1H1(1),m3h4x1(:,267),heltab2x4(:,:,301))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,nMB,G2tensor(381),n2h1(395))
  call Hloop_QV_A(ntryL,G1H4(277),wf4(:,13),G1H1(1),m3h4x1(:,268),heltab2x4(:,:,302))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(382),n2h1(396))
  call ol_merge_tensors(G2tensor(123),[G2tensor(2),G1tensor(6)])
  call ol_merge_tensors(G2tensor(121),[G2tensor(4),G1tensor(12)])
  call ol_merge_tensors(G2tensor(147),[G2tensor(6),G1tensor(18)])
  call ol_merge_tensors(G2tensor(145),[G2tensor(8),G1tensor(24)])
  call ol_merge_tensors(G2tensor(85),[G2tensor(10),G1tensor(26),G1tensor(9)])
  call ol_merge_tensors(G2tensor(326),[G2tensor(323),G2tensor(19),G2tensor(11),G1tensor(42),G1tensor(30)])
  call ol_merge_tensors(G2tensor(86),[G2tensor(14),G1tensor(32),G1tensor(3)])
  call ol_merge_tensors(G2tensor(308),[G2tensor(305),G2tensor(23),G2tensor(15),G1tensor(48),G1tensor(36)])
  call ol_merge_tensors(G2tensor(87),[G2tensor(18),G1tensor(38)])
  call ol_merge_tensors(G2tensor(89),[G2tensor(22),G1tensor(44)])
  call ol_merge_tensors(G2tensor(93),[G2tensor(26),G1tensor(50),G1tensor(21)])
  call ol_merge_tensors(G2tensor(380),[G2tensor(377),G2tensor(35),G2tensor(27),G1tensor(66),G1tensor(54)])
  call ol_merge_tensors(G2tensor(94),[G2tensor(30),G1tensor(56),G1tensor(15)])
  call ol_merge_tensors(G2tensor(362),[G2tensor(359),G2tensor(39),G2tensor(31),G1tensor(72),G1tensor(60)])
  call ol_merge_tensors(G2tensor(95),[G2tensor(34),G1tensor(62)])
  call ol_merge_tensors(G2tensor(97),[G2tensor(38),G1tensor(68)])
  call ol_merge_tensors(G2tensor(173),[G2tensor(42),G1tensor(74),G1tensor(39)])
  call ol_merge_tensors(G2tensor(260),[G2tensor(43),G1tensor(78)])
  call ol_merge_tensors(G2tensor(179),[G2tensor(46),G1tensor(80),G1tensor(27)])
  call ol_merge_tensors(G2tensor(257),[G2tensor(47),G1tensor(84)])
  call ol_merge_tensors(G2tensor(185),[G2tensor(50),G1tensor(86),G1tensor(57)])
  call ol_merge_tensors(G2tensor(263),[G2tensor(51),G1tensor(90)])
  call ol_merge_tensors(G2tensor(191),[G2tensor(54),G1tensor(92),G1tensor(69)])
  call ol_merge_tensors(G2tensor(266),[G2tensor(55),G1tensor(96)])
  call ol_merge_tensors(G2tensor(197),[G1tensor(2)])
  call ol_merge_tensors(G2tensor(91),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(23),G1tensor(17),G1tensor(11),G1tensor(5)])
  call ol_merge_tensors(G2tensor(200),[G1tensor(8)])
  call ol_merge_tensors(G2tensor(92),[G1tensor(10)])
  call ol_merge_tensors(G2tensor(203),[G1tensor(14)])
  call ol_merge_tensors(G2tensor(99),[G1tensor(16)])
  call ol_merge_tensors(G2tensor(206),[G1tensor(20)])
  call ol_merge_tensors(G2tensor(100),[G1tensor(22)])
  call ol_merge_tensors(G2tensor(209),[G1tensor(58),G1tensor(52),G1tensor(34),G1tensor(28)])
  call ol_merge_tensors(G2tensor(149),[G1tensor(29)])
  call ol_merge_tensors(G2tensor(212),[G1tensor(33)])
  call ol_merge_tensors(G2tensor(152),[G1tensor(35)])
  call ol_merge_tensors(G2tensor(215),[G1tensor(70),G1tensor(64),G1tensor(46),G1tensor(40)])
  call ol_merge_tensors(G2tensor(155),[G1tensor(41)])
  call ol_merge_tensors(G2tensor(218),[G1tensor(45)])
  call ol_merge_tensors(G2tensor(158),[G1tensor(47)])
  call ol_merge_tensors(G2tensor(221),[G1tensor(51)])
  call ol_merge_tensors(G2tensor(161),[G1tensor(53)])
  call ol_merge_tensors(G2tensor(164),[G1tensor(59)])
  call ol_merge_tensors(G2tensor(224),[G1tensor(63)])
  call ol_merge_tensors(G2tensor(167),[G1tensor(65)])
  call ol_merge_tensors(G2tensor(170),[G1tensor(71)])
  call ol_merge_tensors(G2tensor(227),[G1tensor(75)])
  call ol_merge_tensors(G2tensor(230),[G1tensor(76)])
  call ol_merge_tensors(G2tensor(182),[G2tensor(176),G1tensor(83),G1tensor(77)])
  call ol_merge_tensors(G2tensor(233),[G1tensor(81)])
  call ol_merge_tensors(G2tensor(236),[G1tensor(82)])
  call ol_merge_tensors(G2tensor(239),[G1tensor(87)])
  call ol_merge_tensors(G2tensor(242),[G1tensor(88)])
  call ol_merge_tensors(G2tensor(194),[G2tensor(188),G1tensor(95),G1tensor(89)])
  call ol_merge_tensors(G2tensor(245),[G1tensor(93)])
  call ol_merge_tensors(G2tensor(248),[G1tensor(94)])
  call ol_merge_tensors(G2tensor(107),[G2tensor(105),G2tensor(103),G2tensor(101)])
  call ol_merge_tensors(G2tensor(104),[G2tensor(102)])
  call ol_merge_tensors(G2tensor(108),[G2tensor(106)])
  call ol_merge_tensors(G2tensor(111),[G2tensor(109)])
  call ol_merge_tensors(G2tensor(112),[G2tensor(110)])
  call ol_merge_tensors(G2tensor(114),[G2tensor(113)])
  call ol_merge_tensors(G2tensor(117),[G2tensor(115)])
  call ol_merge_tensors(G2tensor(118),[G2tensor(116)])
  call ol_merge_tensors(G2tensor(120),[G2tensor(119)])
  call ol_merge_tensors(G2tensor(131),[G2tensor(129),G2tensor(127),G2tensor(125)])
  call ol_merge_tensors(G2tensor(128),[G2tensor(126)])
  call ol_merge_tensors(G2tensor(132),[G2tensor(130)])
  call ol_merge_tensors(G2tensor(135),[G2tensor(133)])
  call ol_merge_tensors(G2tensor(136),[G2tensor(134)])
  call ol_merge_tensors(G2tensor(138),[G2tensor(137)])
  call ol_merge_tensors(G2tensor(141),[G2tensor(139)])
  call ol_merge_tensors(G2tensor(142),[G2tensor(140)])
  call ol_merge_tensors(G2tensor(144),[G2tensor(143)])
  call ol_merge_tensors(G2tensor(290),[G2tensor(287),G2tensor(281),G2tensor(275)])
  call ol_merge_tensors(G2tensor(284),[G2tensor(278)])
  call ol_merge_tensors(G2tensor(299),[G2tensor(293)])
  call ol_merge_tensors(G2tensor(302),[G2tensor(296)])
  call ol_merge_tensors(G2tensor(317),[G2tensor(311)])
  call ol_merge_tensors(G2tensor(320),[G2tensor(314)])
  call ol_merge_tensors(G2tensor(344),[G2tensor(341),G2tensor(335),G2tensor(329)])
  call ol_merge_tensors(G2tensor(338),[G2tensor(332)])
  call ol_merge_tensors(G2tensor(353),[G2tensor(347)])
  call ol_merge_tensors(G2tensor(356),[G2tensor(350)])
  call ol_merge_tensors(G2tensor(371),[G2tensor(365)])
  call ol_merge_tensors(G2tensor(374),[G2tensor(368)])
  call Hotf_4pt_reduction_last(G2tensor(123),RedSet_4(2),mass4set(:,1),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25))
  call G_TensorShift(G1tensor(7),42)
  call Hotf_4pt_reduction_last(G2tensor(121),RedSet_4(3),mass4set(:,1),  & 
G1tensor(31),G1tensor(37),G1tensor(43),G1tensor(49),G1tensor(55))
  call G_TensorShift(G1tensor(37),37)
  call Hotf_4pt_reduction_last(G2tensor(147),RedSet_4(4),mass4set(:,1),  & 
G1tensor(61),G1tensor(67),G1tensor(73),G1tensor(79),G1tensor(85))
  call G_TensorShift(G1tensor(67),38)
  call Hotf_4pt_reduction_last(G2tensor(145),RedSet_4(5),mass4set(:,1),  & 
G1tensor(91),G1tensor(6),G1tensor(12),G1tensor(18),G1tensor(24))
  call G_TensorShift(G1tensor(6),41)
  call Hotf_4pt_reduction_last(G2tensor(85),RedSet_4(17),mass4set(:,4),  & 
G1tensor(26),G1tensor(9),G1tensor(42),G1tensor(30),G1tensor(32))
  call G_TensorShift(G1tensor(9),32)
  call Hotf_4pt_reduction_last(G2tensor(326),RedSet_4(6),mass4set(:,2),  & 
G1tensor(3),G1tensor(48),G1tensor(36),G1tensor(38),G1tensor(44))
  call G_TensorShift(G1tensor(48),48)
  call Hotf_4pt_reduction_last(G2tensor(86),RedSet_4(14),mass4set(:,4),  & 
G1tensor(50),G1tensor(21),G1tensor(66),G1tensor(54),G1tensor(56))
  call G_TensorShift(G1tensor(21),32)
  call Hotf_4pt_reduction_last(G2tensor(308),RedSet_4(7),mass4set(:,2),  & 
G1tensor(15),G1tensor(72),G1tensor(60),G1tensor(62),G1tensor(68))
  call G_TensorShift(G1tensor(72),48)
  call Hotf_4pt_reduction_last(G2tensor(87),RedSet_4(66),mass4set(:,4),  & 
G1tensor(74),G1tensor(39),G1tensor(78),G1tensor(80),G1tensor(27))
  call G_TensorShift(G1tensor(39),16)
  call Hotf_4pt_reduction_last(G2tensor(89),RedSet_4(67),mass4set(:,4),  & 
G1tensor(84),G1tensor(86),G1tensor(57),G1tensor(90),G1tensor(92))
  call G_TensorShift(G1tensor(86),16)
  call Hotf_4pt_reduction_last(G2tensor(93),RedSet_4(23),mass4set(:,4),  & 
G1tensor(69),G1tensor(96),G1tensor(2),G1tensor(4),G1tensor(23))
  call G_TensorShift(G1tensor(96),32)
  call Hotf_4pt_reduction_last(G2tensor(380),RedSet_4(8),mass4set(:,2),  & 
G1tensor(17),G1tensor(11),G1tensor(5),G1tensor(8),G1tensor(10))
  call G_TensorShift(G1tensor(11),48)
  call Hotf_4pt_reduction_last(G2tensor(94),RedSet_4(20),mass4set(:,4),  & 
G1tensor(14),G1tensor(16),G1tensor(20),G1tensor(22),G1tensor(58))
  call G_TensorShift(G1tensor(16),32)
  call Hotf_4pt_reduction_last(G2tensor(362),RedSet_4(9),mass4set(:,2),  & 
G1tensor(52),G1tensor(34),G1tensor(28),G1tensor(29),G1tensor(33))
  call G_TensorShift(G1tensor(34),48)
  call Hotf_4pt_reduction_last(G2tensor(95),RedSet_4(68),mass4set(:,4),  & 
G1tensor(35),G1tensor(70),G1tensor(64),G1tensor(46),G1tensor(40))
  call G_TensorShift(G1tensor(70),16)
  call Hotf_4pt_reduction_last(G2tensor(97),RedSet_4(69),mass4set(:,4),  & 
G1tensor(41),G1tensor(45),G1tensor(47),G1tensor(51),G1tensor(53))
  call G_TensorShift(G1tensor(45),16)
  call Hotf_4pt_reduction_last(G2tensor(173),RedSet_4(33),mass4set(:,3),  & 
G1tensor(59),G1tensor(63),G1tensor(65),G1tensor(71),G1tensor(75))
  call G_TensorShift(G1tensor(63),32)
  call Hotf_4pt_reduction_last(G2tensor(260),RedSet_4(10),mass4set(:,3),  & 
G1tensor(76),G1tensor(83),G1tensor(77),G1tensor(81),G1tensor(82))
  call G_TensorShift(G1tensor(83),42)
  call Hotf_4pt_reduction_last(G2tensor(179),RedSet_4(26),mass4set(:,3),  & 
G1tensor(87),G1tensor(88),G1tensor(95),G1tensor(89),G1tensor(93))
  call G_TensorShift(G1tensor(88),16)
  call Hotf_4pt_reduction_last(G2tensor(257),RedSet_4(11),mass4set(:,3),  & 
G1tensor(94),G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100))
  call G_TensorShift(G1tensor(97),26)
  call Hotf_4pt_reduction_last(G2tensor(185),RedSet_4(43),mass4set(:,3),  & 
G1tensor(101),G1tensor(102),G1tensor(103),G1tensor(104),G1tensor(105))
  call G_TensorShift(G1tensor(102),16)
  call Hotf_4pt_reduction_last(G2tensor(263),RedSet_4(12),mass4set(:,3),  & 
G1tensor(106),G1tensor(107),G1tensor(108),G1tensor(109),G1tensor(110))
  call G_TensorShift(G1tensor(107),25)
  call Hotf_4pt_reduction_last(G2tensor(191),RedSet_4(49),mass4set(:,3),  & 
G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114),G1tensor(115))
  call G_TensorShift(G1tensor(112),32)
  call Hotf_4pt_reduction_last(G2tensor(266),RedSet_4(13),mass4set(:,3),  & 
G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(117),41)
  call Hotf_4pt_reduction_last(G2tensor(197),RedSet_4(70),mass4set(:,7),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125))
  call G_TensorShift(G1tensor(122),10)
  call Hotf_4pt_reduction_last(G2tensor(91),RedSet_4(15),mass4set(:,1),  & 
G1tensor(126),G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130))
  call G_TensorShift(G1tensor(127),32)
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,1),  & 
G1tensor(131),G1tensor(132),G1tensor(133),G1tensor(134),G1tensor(135))
  call G_TensorShift(G1tensor(132),32)
  call Hotf_4pt_reduction_last(G2tensor(200),RedSet_4(71),mass4set(:,7),  & 
G1tensor(136),G1tensor(137),G1tensor(138),G1tensor(139),G1tensor(140))
  call G_TensorShift(G1tensor(137),5)
  call Hotf_4pt_reduction_last(G2tensor(92),RedSet_4(18),mass4set(:,1),  & 
G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144),G1tensor(145))
  call G_TensorShift(G1tensor(142),32)
  call Hotf_4pt_reduction_last(G2tensor(203),RedSet_4(72),mass4set(:,7),  & 
G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(147),6)
  call Hotf_4pt_reduction_last(G2tensor(99),RedSet_4(21),mass4set(:,1),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155))
  call G_TensorShift(G1tensor(152),32)
  call Hotf_4pt_reduction_last(G2tensor(206),RedSet_4(73),mass4set(:,7),  & 
G1tensor(156),G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160))
  call G_TensorShift(G1tensor(157),9)
  call Hotf_4pt_reduction_last(G2tensor(100),RedSet_4(24),mass4set(:,1),  & 
G1tensor(161),G1tensor(162),G1tensor(163),G1tensor(164),G1tensor(165))
  call G_TensorShift(G1tensor(162),32)
  call Hotf_4pt_reduction_last(G2tensor(209),RedSet_4(27),mass4set(:,3),  & 
G1tensor(166),G1tensor(167),G1tensor(168),G1tensor(169),G1tensor(170))
  call G_TensorShift(G1tensor(167),16)
  call Hotf_4pt_reduction_last(G2tensor(149),RedSet_4(28),mass4set(:,3),  & 
G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174),G1tensor(175))
  call G_TensorShift(G1tensor(172),16)
  call Hotf_4pt_reduction_last(G2tensor(212),RedSet_4(30),mass4set(:,3),  & 
G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(177),16)
  call Hotf_4pt_reduction_last(G2tensor(152),RedSet_4(31),mass4set(:,3),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185))
  call G_TensorShift(G1tensor(182),16)
  call Hotf_4pt_reduction_last(G2tensor(215),RedSet_4(34),mass4set(:,3),  & 
G1tensor(186),G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190))
  call G_TensorShift(G1tensor(187),32)
  call Hotf_4pt_reduction_last(G2tensor(155),RedSet_4(35),mass4set(:,3),  & 
G1tensor(191),G1tensor(192),G1tensor(193),G1tensor(194),G1tensor(195))
  call G_TensorShift(G1tensor(192),32)
  call Hotf_4pt_reduction_last(G2tensor(218),RedSet_4(37),mass4set(:,3),  & 
G1tensor(196),G1tensor(197),G1tensor(198),G1tensor(199),G1tensor(200))
  call G_TensorShift(G1tensor(197),32)
  call Hotf_4pt_reduction_last(G2tensor(158),RedSet_4(38),mass4set(:,3),  & 
G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204),G1tensor(205))
  call G_TensorShift(G1tensor(202),32)
  call Hotf_4pt_reduction_last(G2tensor(221),RedSet_4(40),mass4set(:,3),  & 
G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(207),16)
  call Hotf_4pt_reduction_last(G2tensor(161),RedSet_4(41),mass4set(:,3),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215))
  call G_TensorShift(G1tensor(212),16)
  call Hotf_4pt_reduction_last(G2tensor(164),RedSet_4(44),mass4set(:,3),  & 
G1tensor(216),G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220))
  call G_TensorShift(G1tensor(217),16)
  call Hotf_4pt_reduction_last(G2tensor(224),RedSet_4(46),mass4set(:,3),  & 
G1tensor(221),G1tensor(222),G1tensor(223),G1tensor(224),G1tensor(225))
  call G_TensorShift(G1tensor(222),32)
  call Hotf_4pt_reduction_last(G2tensor(167),RedSet_4(47),mass4set(:,3),  & 
G1tensor(226),G1tensor(227),G1tensor(228),G1tensor(229),G1tensor(230))
  call G_TensorShift(G1tensor(227),32)
  call Hotf_4pt_reduction_last(G2tensor(170),RedSet_4(50),mass4set(:,3),  & 
G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234),G1tensor(235))
  call G_TensorShift(G1tensor(232),32)
  call Hotf_4pt_reduction_last(G2tensor(227),RedSet_4(52),mass4set(:,8),  & 
G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(237),10)
  call Hotf_4pt_reduction_last(G2tensor(230),RedSet_4(53),mass4set(:,8),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245))
  call G_TensorShift(G1tensor(242),10)
  call Hotf_4pt_reduction_last(G2tensor(182),RedSet_4(54),mass4set(:,2),  & 
G1tensor(246),G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250))
  call G_TensorShift(G1tensor(247),10)
  call Hotf_4pt_reduction_last(G2tensor(233),RedSet_4(56),mass4set(:,8),  & 
G1tensor(251),G1tensor(252),G1tensor(253),G1tensor(254),G1tensor(255))
  call G_TensorShift(G1tensor(252),10)
  call Hotf_4pt_reduction_last(G2tensor(236),RedSet_4(57),mass4set(:,8),  & 
G1tensor(256),G1tensor(257),G1tensor(258),G1tensor(259),G1tensor(260))
  call G_TensorShift(G1tensor(257),10)
  call Hotf_4pt_reduction_last(G2tensor(239),RedSet_4(59),mass4set(:,8),  & 
G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264),G1tensor(265))
  call G_TensorShift(G1tensor(262),9)
  call Hotf_4pt_reduction_last(G2tensor(242),RedSet_4(60),mass4set(:,8),  & 
G1tensor(266),G1tensor(267),G1tensor(268),G1tensor(269),G1tensor(270))
  call G_TensorShift(G1tensor(267),9)
  call Hotf_4pt_reduction_last(G2tensor(194),RedSet_4(61),mass4set(:,2),  & 
G1tensor(271),G1tensor(272),G1tensor(273),G1tensor(274),G1tensor(275))
  call G_TensorShift(G1tensor(272),9)
  call Hotf_4pt_reduction_last(G2tensor(245),RedSet_4(63),mass4set(:,8),  & 
G1tensor(276),G1tensor(277),G1tensor(278),G1tensor(279),G1tensor(280))
  call G_TensorShift(G1tensor(277),9)
  call Hotf_4pt_reduction_last(G2tensor(248),RedSet_4(64),mass4set(:,8),  & 
G1tensor(281),G1tensor(282),G1tensor(283),G1tensor(284),G1tensor(285))
  call G_TensorShift(G1tensor(282),9)
  call Hotf_4pt_reduction_last(G2tensor(107),RedSet_4(54),mass4set(:,5),  & 
G1tensor(286),G1tensor(287),G1tensor(288),G1tensor(289),G1tensor(290),G0tensor(1))
  call G_TensorShift(G1tensor(287),10)
  call Hotf_4pt_reduction_last(G2tensor(104),RedSet_4(54),mass4set(:,6),  & 
G1tensor(286),G1tensor(291),G1tensor(292),G1tensor(293),G1tensor(294),G0tensor(2))
  call G_TensorShift(G1tensor(291),10)
  call Hotf_4pt_reduction_last(G2tensor(108),RedSet_4(54),mass4set(:,2),  & 
G1tensor(286),G1tensor(295),G1tensor(296),G1tensor(297),G1tensor(298),G0tensor(3))
  call G_TensorShift(G1tensor(295),10)
  call Hotf_4pt_reduction_last(G2tensor(111),RedSet_4(7),mass4set(:,5),  & 
G1tensor(286),G1tensor(299),G1tensor(300),G1tensor(301),G1tensor(302),G0tensor(4))
  call G_TensorShift(G1tensor(299),48)
  call Hotf_4pt_reduction_last(G2tensor(112),RedSet_4(7),mass4set(:,6),  & 
G1tensor(286),G1tensor(303),G1tensor(304),G1tensor(305),G1tensor(306),G0tensor(5))
  call G_TensorShift(G1tensor(303),48)
  call Hotf_4pt_reduction_last(G2tensor(114),RedSet_4(7),mass4set(:,2),  & 
G1tensor(286),G1tensor(307),G1tensor(308),G1tensor(309),G1tensor(310),G0tensor(6))
  call G_TensorShift(G1tensor(307),48)
  call Hotf_4pt_reduction_last(G2tensor(117),RedSet_4(6),mass4set(:,5),  & 
G1tensor(286),G1tensor(311),G1tensor(312),G1tensor(313),G1tensor(314),G0tensor(7))
  call G_TensorShift(G1tensor(311),48)
  call Hotf_4pt_reduction_last(G2tensor(118),RedSet_4(6),mass4set(:,6),  & 
G1tensor(286),G1tensor(315),G1tensor(316),G1tensor(317),G1tensor(318),G0tensor(8))
  call G_TensorShift(G1tensor(315),48)
  call Hotf_4pt_reduction_last(G2tensor(120),RedSet_4(6),mass4set(:,2),  & 
G1tensor(286),G1tensor(319),G1tensor(320),G1tensor(321),G1tensor(322),G0tensor(9))
  call G_TensorShift(G1tensor(319),48)
  call Hotf_4pt_reduction_last(G2tensor(131),RedSet_4(61),mass4set(:,5),  & 
G1tensor(286),G1tensor(323),G1tensor(324),G1tensor(325),G1tensor(326),G0tensor(10))
  call G_TensorShift(G1tensor(323),9)
  call Hotf_4pt_reduction_last(G2tensor(128),RedSet_4(61),mass4set(:,6),  & 
G1tensor(286),G1tensor(327),G1tensor(328),G1tensor(329),G1tensor(330),G0tensor(11))
  call G_TensorShift(G1tensor(327),9)
  call Hotf_4pt_reduction_last(G2tensor(132),RedSet_4(61),mass4set(:,2),  & 
G1tensor(286),G1tensor(331),G1tensor(332),G1tensor(333),G1tensor(334),G0tensor(12))
  call G_TensorShift(G1tensor(331),9)
  call Hotf_4pt_reduction_last(G2tensor(135),RedSet_4(9),mass4set(:,5),  & 
G1tensor(286),G1tensor(335),G1tensor(336),G1tensor(337),G1tensor(338),G0tensor(13))
  call G_TensorShift(G1tensor(335),48)
  call Hotf_4pt_reduction_last(G2tensor(136),RedSet_4(9),mass4set(:,6),  & 
G1tensor(286),G1tensor(339),G1tensor(340),G1tensor(341),G1tensor(342),G0tensor(14))
  call G_TensorShift(G1tensor(339),48)
  call Hotf_4pt_reduction_last(G2tensor(138),RedSet_4(9),mass4set(:,2),  & 
G1tensor(286),G1tensor(343),G1tensor(344),G1tensor(345),G1tensor(346),G0tensor(15))
  call G_TensorShift(G1tensor(343),48)
  call Hotf_4pt_reduction_last(G2tensor(141),RedSet_4(8),mass4set(:,5),  & 
G1tensor(286),G1tensor(347),G1tensor(348),G1tensor(349),G1tensor(350),G0tensor(16))
  call G_TensorShift(G1tensor(347),48)
  call Hotf_4pt_reduction_last(G2tensor(142),RedSet_4(8),mass4set(:,6),  & 
G1tensor(286),G1tensor(351),G1tensor(352),G1tensor(353),G1tensor(354),G0tensor(17))
  call G_TensorShift(G1tensor(351),48)
  call Hotf_4pt_reduction_last(G2tensor(144),RedSet_4(8),mass4set(:,2),  & 
G1tensor(286),G1tensor(355),G1tensor(356),G1tensor(357),G1tensor(358),G0tensor(18))
  call G_TensorShift(G1tensor(355),48)
  call Hotf_4pt_reduction_last(G2tensor(251),RedSet_4(74),mass4set(:,3),  & 
G1tensor(286),G1tensor(359),G1tensor(360),G1tensor(361),G1tensor(362))
  call G_TensorShift(G1tensor(359),21)
  call Hotf_4pt_reduction_last(G2tensor(254),RedSet_4(75),mass4set(:,3),  & 
G1tensor(363),G1tensor(364),G1tensor(365),G1tensor(366),G1tensor(367))
  call G_TensorShift(G1tensor(364),37)
  call Hotf_4pt_reduction_last(G2tensor(269),RedSet_4(76),mass4set(:,3),  & 
G1tensor(368),G1tensor(369),G1tensor(370),G1tensor(371),G1tensor(372))
  call G_TensorShift(G1tensor(369),22)
  call Hotf_4pt_reduction_last(G2tensor(272),RedSet_4(77),mass4set(:,3),  & 
G1tensor(373),G1tensor(374),G1tensor(375),G1tensor(376),G1tensor(377))
  call G_TensorShift(G1tensor(374),38)
  call Hotf_4pt_reduction_last(G2tensor(290),RedSet_4(54),mass4set(:,5),  & 
G1tensor(378),G1tensor(379),G1tensor(380),G1tensor(381),G1tensor(382))
  call G_TensorShift(G1tensor(379),10)
  call Hotf_4pt_reduction_last(G2tensor(284),RedSet_4(54),mass4set(:,6),  & 
G1tensor(383),G1tensor(384),G1tensor(385),G1tensor(386),G1tensor(387))
  call G_TensorShift(G1tensor(384),10)
  call Hotf_4pt_reduction_last(G2tensor(299),RedSet_4(7),mass4set(:,5),  & 
G1tensor(388),G1tensor(389),G1tensor(390),G1tensor(391),G1tensor(392))
  call G_TensorShift(G1tensor(389),48)
  call Hotf_4pt_reduction_last(G2tensor(302),RedSet_4(7),mass4set(:,6),  & 
G1tensor(393),G1tensor(394),G1tensor(395),G1tensor(396),G1tensor(397))
  call G_TensorShift(G1tensor(394),48)
  call Hotf_4pt_reduction_last(G2tensor(317),RedSet_4(6),mass4set(:,5),  & 
G1tensor(398),G1tensor(399),G1tensor(400),G1tensor(401),G1tensor(402))
  call G_TensorShift(G1tensor(399),48)
  call Hotf_4pt_reduction_last(G2tensor(320),RedSet_4(6),mass4set(:,6),  & 
G1tensor(403),G1tensor(404),G1tensor(405),G1tensor(406),G1tensor(407))
  call G_TensorShift(G1tensor(404),48)
  call Hotf_4pt_reduction_last(G2tensor(344),RedSet_4(61),mass4set(:,5),  & 
G1tensor(408),G1tensor(409),G1tensor(410),G1tensor(411),G1tensor(412))
  call G_TensorShift(G1tensor(409),9)
  call Hotf_4pt_reduction_last(G2tensor(338),RedSet_4(61),mass4set(:,6),  & 
G1tensor(413),G1tensor(414),G1tensor(415),G1tensor(416),G1tensor(417))
  call G_TensorShift(G1tensor(414),9)
  call Hotf_4pt_reduction_last(G2tensor(353),RedSet_4(9),mass4set(:,5),  & 
G1tensor(418),G1tensor(419),G1tensor(420),G1tensor(421),G1tensor(422))
  call G_TensorShift(G1tensor(419),48)
  call Hotf_4pt_reduction_last(G2tensor(356),RedSet_4(9),mass4set(:,6),  & 
G1tensor(423),G1tensor(424),G1tensor(425),G1tensor(426),G1tensor(427))
  call G_TensorShift(G1tensor(424),48)
  call Hotf_4pt_reduction_last(G2tensor(371),RedSet_4(8),mass4set(:,5),  & 
G1tensor(428),G1tensor(429),G1tensor(430),G1tensor(431),G1tensor(432))
  call G_TensorShift(G1tensor(429),48)
  call Hotf_4pt_reduction_last(G2tensor(374),RedSet_4(8),mass4set(:,6),  & 
G1tensor(433),G1tensor(434),G1tensor(435),G1tensor(436),G1tensor(437))
  call G_TensorShift(G1tensor(434),48)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(2),mass4set(:,1),  & 
G0tensor(19),G0tensor(20),G0tensor(21),G0tensor(22),G0tensor(23))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(3),mass4set(:,1),  & 
G0tensor(24),G0tensor(25),G0tensor(26),G0tensor(27),G0tensor(28))
  call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(4),mass4set(:,1),  & 
G0tensor(29),G0tensor(30),G0tensor(31),G0tensor(32),G0tensor(33))
  call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(5),mass4set(:,1),  & 
G0tensor(34),G0tensor(35),G0tensor(36),G0tensor(37),G0tensor(38))
  call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(17),mass4set(:,4),  & 
G0tensor(39),G0tensor(40),G0tensor(41),G0tensor(42),G0tensor(43))
  call Hotf_4pt_reduction_last(G1tensor(3),RedSet_4(6),mass4set(:,2),  & 
G0tensor(44),G0tensor(45),G0tensor(46),G0tensor(47),G0tensor(48))
  call Hotf_4pt_reduction_last(G1tensor(50),RedSet_4(14),mass4set(:,4),  & 
G0tensor(49),G0tensor(50),G0tensor(51),G0tensor(52),G0tensor(53))
  call Hotf_4pt_reduction_last(G1tensor(15),RedSet_4(7),mass4set(:,2),  & 
G0tensor(54),G0tensor(55),G0tensor(56),G0tensor(57),G0tensor(58))
  call Hotf_4pt_reduction_last(G1tensor(74),RedSet_4(66),mass4set(:,4),  & 
G0tensor(59),G0tensor(60),G0tensor(61),G0tensor(62),G0tensor(63))
  call Hotf_4pt_reduction_last(G1tensor(84),RedSet_4(67),mass4set(:,4),  & 
G0tensor(64),G0tensor(65),G0tensor(66),G0tensor(67),G0tensor(68))
  call Hotf_4pt_reduction_last(G1tensor(69),RedSet_4(23),mass4set(:,4),  & 
G0tensor(69),G0tensor(70),G0tensor(71),G0tensor(72),G0tensor(73))
  call Hotf_4pt_reduction_last(G1tensor(17),RedSet_4(8),mass4set(:,2),  & 
G0tensor(74),G0tensor(75),G0tensor(76),G0tensor(77),G0tensor(78))
  call Hotf_4pt_reduction_last(G1tensor(14),RedSet_4(20),mass4set(:,4),  & 
G0tensor(79),G0tensor(80),G0tensor(81),G0tensor(82),G0tensor(83))
  call Hotf_4pt_reduction_last(G1tensor(52),RedSet_4(9),mass4set(:,2),  & 
G0tensor(84),G0tensor(85),G0tensor(86),G0tensor(87),G0tensor(88))
  call Hotf_4pt_reduction_last(G1tensor(35),RedSet_4(68),mass4set(:,4),  & 
G0tensor(89),G0tensor(90),G0tensor(91),G0tensor(92),G0tensor(93))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(69),mass4set(:,4),  & 
G0tensor(94),G0tensor(95),G0tensor(96),G0tensor(97),G0tensor(98))
  call Hotf_4pt_reduction_last(G1tensor(59),RedSet_4(33),mass4set(:,3),  & 
G0tensor(99),G0tensor(100),G0tensor(101),G0tensor(102),G0tensor(103))
  call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(10),mass4set(:,3),  & 
G0tensor(104),G0tensor(105),G0tensor(106),G0tensor(107),G0tensor(108))
  call Hotf_4pt_reduction_last(G1tensor(87),RedSet_4(26),mass4set(:,3),  & 
G0tensor(109),G0tensor(110),G0tensor(111),G0tensor(112),G0tensor(113))
  call Hotf_4pt_reduction_last(G1tensor(94),RedSet_4(11),mass4set(:,3),  & 
G0tensor(114),G0tensor(115),G0tensor(116),G0tensor(117),G0tensor(118))
  call Hotf_4pt_reduction_last(G1tensor(101),RedSet_4(43),mass4set(:,3),  & 
G0tensor(119),G0tensor(120),G0tensor(121),G0tensor(122),G0tensor(123))
  call Hotf_4pt_reduction_last(G1tensor(106),RedSet_4(12),mass4set(:,3),  & 
G0tensor(124),G0tensor(125),G0tensor(126),G0tensor(127),G0tensor(128))
  call Hotf_4pt_reduction_last(G1tensor(111),RedSet_4(49),mass4set(:,3),  & 
G0tensor(129),G0tensor(130),G0tensor(131),G0tensor(132),G0tensor(133))
  call Hotf_4pt_reduction_last(G1tensor(116),RedSet_4(13),mass4set(:,3),  & 
G0tensor(134),G0tensor(135),G0tensor(136),G0tensor(137),G0tensor(138))
  call Hotf_4pt_reduction_last(G1tensor(121),RedSet_4(70),mass4set(:,7),  & 
G0tensor(139),G0tensor(140),G0tensor(141),G0tensor(142),G0tensor(143))
  call Hotf_4pt_reduction_last(G1tensor(126),RedSet_4(15),mass4set(:,1),  & 
G0tensor(144),G0tensor(145),G0tensor(146),G0tensor(147),G0tensor(148))
  call Hotf_4pt_reduction_last(G1tensor(131),RedSet_4(1),mass4set(:,1),  & 
G0tensor(149),G0tensor(150),G0tensor(151),G0tensor(152),G0tensor(153))
  call Hotf_4pt_reduction_last(G1tensor(136),RedSet_4(71),mass4set(:,7),  & 
G0tensor(154),G0tensor(155),G0tensor(156),G0tensor(157),G0tensor(158))
  call Hotf_4pt_reduction_last(G1tensor(141),RedSet_4(18),mass4set(:,1),  & 
G0tensor(159),G0tensor(160),G0tensor(161),G0tensor(162),G0tensor(163))
  call Hotf_4pt_reduction_last(G1tensor(146),RedSet_4(72),mass4set(:,7),  & 
G0tensor(164),G0tensor(165),G0tensor(166),G0tensor(167),G0tensor(168))
  call Hotf_4pt_reduction_last(G1tensor(151),RedSet_4(21),mass4set(:,1),  & 
G0tensor(169),G0tensor(170),G0tensor(171),G0tensor(172),G0tensor(173))
  call Hotf_4pt_reduction_last(G1tensor(156),RedSet_4(73),mass4set(:,7),  & 
G0tensor(174),G0tensor(175),G0tensor(176),G0tensor(177),G0tensor(178))
  call Hotf_4pt_reduction_last(G1tensor(161),RedSet_4(24),mass4set(:,1),  & 
G0tensor(179),G0tensor(180),G0tensor(181),G0tensor(182),G0tensor(183))
  call Hotf_4pt_reduction_last(G1tensor(166),RedSet_4(27),mass4set(:,3),  & 
G0tensor(184),G0tensor(185),G0tensor(186),G0tensor(187),G0tensor(188))
  call Hotf_4pt_reduction_last(G1tensor(171),RedSet_4(28),mass4set(:,3),  & 
G0tensor(189),G0tensor(190),G0tensor(191),G0tensor(192),G0tensor(193))
  call Hotf_4pt_reduction_last(G1tensor(176),RedSet_4(30),mass4set(:,3),  & 
G0tensor(194),G0tensor(195),G0tensor(196),G0tensor(197),G0tensor(198))
  call Hotf_4pt_reduction_last(G1tensor(181),RedSet_4(31),mass4set(:,3),  & 
G0tensor(199),G0tensor(200),G0tensor(201),G0tensor(202),G0tensor(203))
  call Hotf_4pt_reduction_last(G1tensor(186),RedSet_4(34),mass4set(:,3),  & 
G0tensor(204),G0tensor(205),G0tensor(206),G0tensor(207),G0tensor(208))
  call Hotf_4pt_reduction_last(G1tensor(191),RedSet_4(35),mass4set(:,3),  & 
G0tensor(209),G0tensor(210),G0tensor(211),G0tensor(212),G0tensor(213))
  call Hotf_4pt_reduction_last(G1tensor(196),RedSet_4(37),mass4set(:,3),  & 
G0tensor(214),G0tensor(215),G0tensor(216),G0tensor(217),G0tensor(218))
  call Hotf_4pt_reduction_last(G1tensor(201),RedSet_4(38),mass4set(:,3),  & 
G0tensor(219),G0tensor(220),G0tensor(221),G0tensor(222),G0tensor(223))
  call Hotf_4pt_reduction_last(G1tensor(206),RedSet_4(40),mass4set(:,3),  & 
G0tensor(224),G0tensor(225),G0tensor(226),G0tensor(227),G0tensor(228))
  call Hotf_4pt_reduction_last(G1tensor(211),RedSet_4(41),mass4set(:,3),  & 
G0tensor(229),G0tensor(230),G0tensor(231),G0tensor(232),G0tensor(233))
  call Hotf_4pt_reduction_last(G1tensor(216),RedSet_4(44),mass4set(:,3),  & 
G0tensor(234),G0tensor(235),G0tensor(236),G0tensor(237),G0tensor(238))
  call Hotf_4pt_reduction_last(G1tensor(221),RedSet_4(46),mass4set(:,3),  & 
G0tensor(239),G0tensor(240),G0tensor(241),G0tensor(242),G0tensor(243))
  call Hotf_4pt_reduction_last(G1tensor(226),RedSet_4(47),mass4set(:,3),  & 
G0tensor(244),G0tensor(245),G0tensor(246),G0tensor(247),G0tensor(248))
  call Hotf_4pt_reduction_last(G1tensor(231),RedSet_4(50),mass4set(:,3),  & 
G0tensor(249),G0tensor(250),G0tensor(251),G0tensor(252),G0tensor(253))
  call Hotf_4pt_reduction_last(G1tensor(236),RedSet_4(52),mass4set(:,8),  & 
G0tensor(254),G0tensor(255),G0tensor(256),G0tensor(257),G0tensor(258))
  call Hotf_4pt_reduction_last(G1tensor(241),RedSet_4(53),mass4set(:,8),  & 
G0tensor(259),G0tensor(260),G0tensor(261),G0tensor(262),G0tensor(263))
  call Hotf_4pt_reduction_last(G1tensor(246),RedSet_4(54),mass4set(:,2),  & 
G0tensor(264),G0tensor(265),G0tensor(266),G0tensor(267),G0tensor(268))
  call Hotf_4pt_reduction_last(G1tensor(251),RedSet_4(56),mass4set(:,8),  & 
G0tensor(269),G0tensor(270),G0tensor(271),G0tensor(272),G0tensor(273))
  call Hotf_4pt_reduction_last(G1tensor(256),RedSet_4(57),mass4set(:,8),  & 
G0tensor(274),G0tensor(275),G0tensor(276),G0tensor(277),G0tensor(278))
  call Hotf_4pt_reduction_last(G1tensor(261),RedSet_4(59),mass4set(:,8),  & 
G0tensor(279),G0tensor(280),G0tensor(281),G0tensor(282),G0tensor(283))
  call Hotf_4pt_reduction_last(G1tensor(266),RedSet_4(60),mass4set(:,8),  & 
G0tensor(284),G0tensor(285),G0tensor(286),G0tensor(287),G0tensor(288))
  call Hotf_4pt_reduction_last(G1tensor(271),RedSet_4(61),mass4set(:,2),  & 
G0tensor(289),G0tensor(290),G0tensor(291),G0tensor(292),G0tensor(293))
  call Hotf_4pt_reduction_last(G1tensor(276),RedSet_4(63),mass4set(:,8),  & 
G0tensor(294),G0tensor(295),G0tensor(296),G0tensor(297),G0tensor(298))
  call Hotf_4pt_reduction_last(G1tensor(281),RedSet_4(64),mass4set(:,8),  & 
G0tensor(299),G0tensor(300),G0tensor(301),G0tensor(302),G0tensor(303))
  call Hotf_4pt_reduction_last(G1tensor(286),RedSet_4(74),mass4set(:,3),  & 
G0tensor(304),G0tensor(305),G0tensor(306),G0tensor(307),G0tensor(308))
  call Hotf_4pt_reduction_last(G1tensor(363),RedSet_4(75),mass4set(:,3),  & 
G0tensor(309),G0tensor(310),G0tensor(311),G0tensor(312),G0tensor(313))
  call Hotf_4pt_reduction_last(G1tensor(368),RedSet_4(76),mass4set(:,3),  & 
G0tensor(314),G0tensor(315),G0tensor(316),G0tensor(317),G0tensor(318))
  call Hotf_4pt_reduction_last(G1tensor(373),RedSet_4(77),mass4set(:,3),  & 
G0tensor(319),G0tensor(320),G0tensor(321),G0tensor(322),G0tensor(323))
  call Hotf_4pt_reduction_last(G1tensor(378),RedSet_4(54),mass4set(:,5),  & 
G0tensor(324),G0tensor(325),G0tensor(326),G0tensor(327),G0tensor(328))
  call Hotf_4pt_reduction_last(G1tensor(383),RedSet_4(54),mass4set(:,6),  & 
G0tensor(329),G0tensor(330),G0tensor(331),G0tensor(332),G0tensor(333))
  call Hotf_4pt_reduction_last(G1tensor(388),RedSet_4(7),mass4set(:,5),  & 
G0tensor(334),G0tensor(335),G0tensor(336),G0tensor(337),G0tensor(338))
  call Hotf_4pt_reduction_last(G1tensor(393),RedSet_4(7),mass4set(:,6),  & 
G0tensor(339),G0tensor(340),G0tensor(341),G0tensor(342),G0tensor(343))
  call Hotf_4pt_reduction_last(G1tensor(398),RedSet_4(6),mass4set(:,5),  & 
G0tensor(344),G0tensor(345),G0tensor(346),G0tensor(347),G0tensor(348))
  call Hotf_4pt_reduction_last(G1tensor(403),RedSet_4(6),mass4set(:,6),  & 
G0tensor(349),G0tensor(350),G0tensor(351),G0tensor(352),G0tensor(353))
  call Hotf_4pt_reduction_last(G1tensor(408),RedSet_4(61),mass4set(:,5),  & 
G0tensor(354),G0tensor(355),G0tensor(356),G0tensor(357),G0tensor(358))
  call Hotf_4pt_reduction_last(G1tensor(413),RedSet_4(61),mass4set(:,6),  & 
G0tensor(359),G0tensor(360),G0tensor(361),G0tensor(362),G0tensor(363))
  call Hotf_4pt_reduction_last(G1tensor(418),RedSet_4(9),mass4set(:,5),  & 
G0tensor(364),G0tensor(365),G0tensor(366),G0tensor(367),G0tensor(368))
  call Hotf_4pt_reduction_last(G1tensor(423),RedSet_4(9),mass4set(:,6),  & 
G0tensor(369),G0tensor(370),G0tensor(371),G0tensor(372),G0tensor(373))
  call Hotf_4pt_reduction_last(G1tensor(428),RedSet_4(8),mass4set(:,5),  & 
G0tensor(374),G0tensor(375),G0tensor(376),G0tensor(377),G0tensor(378))
  call Hotf_4pt_reduction_last(G1tensor(433),RedSet_4(8),mass4set(:,6),  & 
G0tensor(379),G0tensor(380),G0tensor(381),G0tensor(382),G0tensor(383))
  call ol_merge_tensors(T0sum(1),[G0tensor(19)])
  call ol_merge_tensors(T0sum(2),[G0tensor(24)])
  call ol_merge_tensors(T0sum(3),[G0tensor(29)])
  call ol_merge_tensors(T0sum(4),[G0tensor(34)])
  call ol_merge_tensors(T0sum(5),[G0tensor(39)])
  call ol_merge_tensors(T0sum(6),[G0tensor(44)])
  call ol_merge_tensors(T0sum(7),[G0tensor(49)])
  call ol_merge_tensors(T0sum(8),[G0tensor(54)])
  call ol_merge_tensors(T0sum(9),[G0tensor(59)])
  call ol_merge_tensors(T0sum(10),[G0tensor(64)])
  call ol_merge_tensors(T0sum(11),[G0tensor(69)])
  call ol_merge_tensors(T0sum(12),[G0tensor(74)])
  call ol_merge_tensors(T0sum(13),[G0tensor(79)])
  call ol_merge_tensors(T0sum(14),[G0tensor(84)])
  call ol_merge_tensors(T0sum(15),[G0tensor(89)])
  call ol_merge_tensors(T0sum(16),[G0tensor(94)])
  call ol_merge_tensors(T0sum(17),[G0tensor(99)])
  call ol_merge_tensors(T0sum(18),[G0tensor(104)])
  call ol_merge_tensors(T0sum(19),[G0tensor(109)])
  call ol_merge_tensors(T0sum(20),[G0tensor(114)])
  call ol_merge_tensors(T0sum(21),[G0tensor(119)])
  call ol_merge_tensors(T0sum(22),[G0tensor(124)])
  call ol_merge_tensors(T0sum(23),[G0tensor(129)])
  call ol_merge_tensors(T0sum(24),[G0tensor(134)])
  call ol_merge_tensors(T0sum(25),[G0tensor(139)])
  call ol_merge_tensors(T0sum(26),[G0tensor(144)])
  call ol_merge_tensors(T0sum(27),[G0tensor(149)])
  call ol_merge_tensors(T0sum(28),[G0tensor(154)])
  call ol_merge_tensors(T0sum(29),[G0tensor(159)])
  call ol_merge_tensors(T0sum(30),[G0tensor(164)])
  call ol_merge_tensors(T0sum(31),[G0tensor(169)])
  call ol_merge_tensors(T0sum(32),[G0tensor(174)])
  call ol_merge_tensors(T0sum(33),[G0tensor(179)])
  call ol_merge_tensors(T0sum(34),[G0tensor(184)])
  call ol_merge_tensors(T0sum(35),[G0tensor(189)])
  call ol_merge_tensors(T0sum(36),[G0tensor(194)])
  call ol_merge_tensors(T0sum(37),[G0tensor(199)])
  call ol_merge_tensors(T0sum(38),[G0tensor(204)])
  call ol_merge_tensors(T0sum(39),[G0tensor(209)])
  call ol_merge_tensors(T0sum(40),[G0tensor(214)])
  call ol_merge_tensors(T0sum(41),[G0tensor(219)])
  call ol_merge_tensors(T0sum(42),[G0tensor(224)])
  call ol_merge_tensors(T0sum(43),[G0tensor(229)])
  call ol_merge_tensors(T0sum(44),[G0tensor(234)])
  call ol_merge_tensors(T0sum(45),[G0tensor(239)])
  call ol_merge_tensors(T0sum(46),[G0tensor(244)])
  call ol_merge_tensors(T0sum(47),[G0tensor(249)])
  call ol_merge_tensors(T0sum(48),[G0tensor(254)])
  call ol_merge_tensors(T0sum(49),[G0tensor(259)])
  call ol_merge_tensors(T0sum(50),[G0tensor(264)])
  call ol_merge_tensors(T0sum(51),[G0tensor(269)])
  call ol_merge_tensors(T0sum(52),[G0tensor(274)])
  call ol_merge_tensors(T0sum(53),[G0tensor(279)])
  call ol_merge_tensors(T0sum(54),[G0tensor(284)])
  call ol_merge_tensors(T0sum(55),[G0tensor(289)])
  call ol_merge_tensors(T0sum(56),[G0tensor(294)])
  call ol_merge_tensors(T0sum(57),[G0tensor(299)])
  call ol_merge_tensors(T0sum(58),[G0tensor(1)])
  call ol_merge_tensors(T0sum(59),[G0tensor(2)])
  call ol_merge_tensors(T0sum(60),[G0tensor(3)])
  call ol_merge_tensors(T0sum(61),[G0tensor(4)])
  call ol_merge_tensors(T0sum(62),[G0tensor(5)])
  call ol_merge_tensors(T0sum(63),[G0tensor(6)])
  call ol_merge_tensors(T0sum(64),[G0tensor(7)])
  call ol_merge_tensors(T0sum(65),[G0tensor(8)])
  call ol_merge_tensors(T0sum(66),[G0tensor(9)])
  call ol_merge_tensors(T0sum(67),[G0tensor(10)])
  call ol_merge_tensors(T0sum(68),[G0tensor(11)])
  call ol_merge_tensors(T0sum(69),[G0tensor(12)])
  call ol_merge_tensors(T0sum(70),[G0tensor(13)])
  call ol_merge_tensors(T0sum(71),[G0tensor(14)])
  call ol_merge_tensors(T0sum(72),[G0tensor(15)])
  call ol_merge_tensors(T0sum(73),[G0tensor(16)])
  call ol_merge_tensors(T0sum(74),[G0tensor(17)])
  call ol_merge_tensors(T0sum(75),[G0tensor(18)])
  call ol_merge_tensors(T0sum(76),[G0tensor(304)])
  call ol_merge_tensors(T0sum(77),[G0tensor(309)])
  call ol_merge_tensors(T0sum(78),[G0tensor(314)])
  call ol_merge_tensors(T0sum(79),[G0tensor(319)])
  call ol_merge_tensors(T0sum(80),[G0tensor(324)])
  call ol_merge_tensors(T0sum(81),[G0tensor(329)])
  call ol_merge_tensors(T0sum(82),[G0tensor(334)])
  call ol_merge_tensors(T0sum(83),[G0tensor(339)])
  call ol_merge_tensors(T0sum(84),[G0tensor(344)])
  call ol_merge_tensors(T0sum(85),[G0tensor(349)])
  call ol_merge_tensors(T0sum(86),[G0tensor(354)])
  call ol_merge_tensors(T0sum(87),[G0tensor(359)])
  call ol_merge_tensors(T0sum(88),[G0tensor(364)])
  call ol_merge_tensors(T0sum(89),[G0tensor(369)])
  call ol_merge_tensors(T0sum(90),[G0tensor(374)])
  call ol_merge_tensors(T0sum(91),[G0tensor(379)])
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(127),h0tab(:,127),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,3),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,119),heltab2x128(:,:,127))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(1),n2h64(97))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(128),h0tab(:,128),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,3),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,120),heltab2x128(:,:,128))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(2),n2h64(98))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(129),h0tab(:,129),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,3),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,121),heltab2x128(:,:,129))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(3),n2h64(99))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(130),h0tab(:,130),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,3),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,122),heltab2x128(:,:,130))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(4),n2h64(100))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(131),h0tab(:,131),[80,10,37],[nMB,nMB,0],3,3,wf4(:,6),wf4(:,5),wf8(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,6),G0H32(1),m3h4x32(:,9),heltab2x128(:,:,131))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(15),n2h32(45))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(267)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(132),h0tab(:,132),[80,5,42],[nMB,nMB,0],3,3,wf4(:,6),wf4(:,4),wf8(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,6),G0H32(1),m3h4x32(:,10),heltab2x128(:,:,132))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(21),n2h32(46))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(97)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(133),h0tab(:,133),[80,15,32],[nMB,nMB,0],3,2,wf4(:,6),wf16(:,3))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,6),G0H32(1),m3h4x32(:,11),heltab2x128(:,:,133))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(1),n2h32(47))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(134),h0tab(:,134),[85,10,32],[nMB,nMB,0],3,2,wf16(:,33),wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,33),G0H8(1),m3h16x8(:,1),heltab2x128(:,:,134))
  call Hloop_Q_A(ntryL,G0H8(1),85,nMB,G1H8(63),n2h8(69))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(135),h0tab(:,135),[90,5,32],[nMB,nMB,0],3,2,wf16(:,34),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,34),G0H8(1),m3h16x8(:,2),heltab2x128(:,:,135))
  call Hloop_Q_A(ntryL,G0H8(1),90,nMB,G1H8(68),n2h8(70))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(136),h0tab(:,136),[96,10,21],[nMB,nMB,0],3,3,wf4(:,8),wf4(:,5),wf8(:,7))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(1),m3h4x32(:,12),heltab2x128(:,:,136))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(7),n2h32(48))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(137),h0tab(:,137),[96,5,26],[nMB,nMB,0],3,3,wf4(:,8),wf4(:,4),wf8(:,9))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(1),m3h4x32(:,13),heltab2x128(:,:,137))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(6),n2h32(49))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(138),h0tab(:,138),[96,15,16],[nMB,nMB,0],3,2,wf4(:,8),wf16(:,3))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(1),m3h4x32(:,14),heltab2x128(:,:,138))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(4),n2h32(50))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(139),h0tab(:,139),[101,10,16],[nMB,nMB,0],3,2,wf16(:,37),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,37),G0H8(1),m3h16x8(:,3),heltab2x128(:,:,139))
  call Hloop_A_Q(ntryL,G0H8(1),101,nMB,G1H8(67),n2h8(71))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(140),h0tab(:,140),[106,5,16],[nMB,nMB,0],3,2,wf16(:,38),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,38),G0H8(1),m3h16x8(:,4),heltab2x128(:,:,140))
  call Hloop_A_Q(ntryL,G0H8(1),106,nMB,G1H8(69),n2h8(72))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(141),h0tab(:,141),[64,21,42],[nMB,0,nMB],3,2,wf8(:,7),wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,123),heltab2x128(:,:,141))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(5),n2h64(101))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(142),h0tab(:,142),[64,21,42],[0,nMB,0],3,2,wf8(:,7),wf8(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(6),m3h2x64(:,124),heltab2x128(:,:,142))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(143),h0tab(:,143),[64,10,53],[0,0,0],3,2,wf4(:,5),wf16(:,28))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,125),heltab2x128(:,:,143))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(7),n2h64(102))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(144),h0tab(:,144),[64,10,53],[nMT,nMT,nMT],3,2,wf4(:,5),wf16(:,28))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,126),heltab2x128(:,:,144))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(8),n2h64(103))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(145),h0tab(:,145),[64,10,53],[0,0,0],3,2,wf4(:,5),wf16(:,28))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,127),heltab2x128(:,:,145))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(9),n2h64(104))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(146),h0tab(:,146),[64,10,53],[nMT,nMT,nMT],3,2,wf4(:,5),wf16(:,28))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,128),heltab2x128(:,:,146))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(10),n2h64(105))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(147),h0tab(:,147),[64,10,53],[0,0,0],3,2,wf4(:,5),wf16(:,28))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,129),heltab2x128(:,:,147))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(11),n2h64(106))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(148),h0tab(:,148),[64,10,53],[nMB,nMB,nMB],3,2,wf4(:,5),wf16(:,28))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,130),heltab2x128(:,:,148))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(12),n2h64(107))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(149),h0tab(:,149),[64,10,53],[0,0,0],3,2,wf4(:,5),wf16(:,28))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,131),heltab2x128(:,:,149))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(13),n2h64(108))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(150),h0tab(:,150),[64,10,53],[nMB,nMB,nMB],3,2,wf4(:,5),wf16(:,28))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,132),heltab2x128(:,:,150))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(14),n2h64(109))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(151),h0tab(:,151),[85,10,32],[nMB,nMB,0],3,2,wf16(:,71),wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,71),G0H8(1),m3h16x8(:,5),heltab2x128(:,:,151))
  call Hloop_Q_A(ntryL,G0H8(1),85,nMB,G1H8(72),n2h8(73))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(152),h0tab(:,152),[64,31,32],[nMB,0,nMB],3,1,wf32(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,133),heltab2x128(:,:,152))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(15),n2h64(110))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(153),h0tab(:,153),[64,31,32],[0,nMB,0],3,1,wf32(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(16),m3h2x64(:,134),heltab2x128(:,:,153))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(154),h0tab(:,154),[64,26,37],[nMB,0,nMB],3,2,wf8(:,9),wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,135),heltab2x128(:,:,154))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(17),n2h64(111))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(155),h0tab(:,155),[64,26,37],[0,nMB,0],3,2,wf8(:,9),wf8(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(18),m3h2x64(:,136),heltab2x128(:,:,155))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(156),h0tab(:,156),[64,10,53],[0,0,0],3,2,wf4(:,5),wf16(:,30))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,137),heltab2x128(:,:,156))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(19),n2h64(112))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(157),h0tab(:,157),[64,10,53],[nMT,nMT,nMT],3,2,wf4(:,5),wf16(:,30))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,138),heltab2x128(:,:,157))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(20),n2h64(113))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(158),h0tab(:,158),[64,10,53],[0,0,0],3,2,wf4(:,5),wf16(:,30))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,139),heltab2x128(:,:,158))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(21),n2h64(114))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(159),h0tab(:,159),[64,10,53],[nMT,nMT,nMT],3,2,wf4(:,5),wf16(:,30))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,140),heltab2x128(:,:,159))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(22),n2h64(115))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(160),h0tab(:,160),[64,10,53],[0,0,0],3,2,wf4(:,5),wf16(:,30))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,141),heltab2x128(:,:,160))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(23),n2h64(116))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(161),h0tab(:,161),[64,10,53],[nMB,nMB,nMB],3,2,wf4(:,5),wf16(:,30))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,142),heltab2x128(:,:,161))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(24),n2h64(117))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(162),h0tab(:,162),[64,10,53],[0,0,0],3,2,wf4(:,5),wf16(:,30))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,143),heltab2x128(:,:,162))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(25),n2h64(118))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(163),h0tab(:,163),[64,10,53],[nMB,nMB,nMB],3,2,wf4(:,5),wf16(:,30))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,144),heltab2x128(:,:,163))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(26),n2h64(119))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(164),h0tab(:,164),[101,10,16],[nMB,nMB,0],3,2,wf16(:,70),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,70),G0H8(1),m3h16x8(:,6),heltab2x128(:,:,164))
  call Hloop_A_Q(ntryL,G0H8(1),101,nMB,G1H8(73),n2h8(74))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(223)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(165),h0tab(:,165),[64,16,47],[nMB,0,nMB],3,1,wf32(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,145),heltab2x128(:,:,165))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(27),n2h64(120))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(223)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(166),h0tab(:,166),[64,16,47],[0,nMB,0],3,1,wf32(:,6))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(28),m3h2x64(:,146),heltab2x128(:,:,166))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(276)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(167),h0tab(:,167),[64,5,58],[0,0,0],3,2,wf4(:,4),wf16(:,31))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,147),heltab2x128(:,:,167))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(29),n2h64(121))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(276)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(168),h0tab(:,168),[64,5,58],[nMT,nMT,nMT],3,2,wf4(:,4),wf16(:,31))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,148),heltab2x128(:,:,168))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(30),n2h64(122))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(276)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(169),h0tab(:,169),[64,5,58],[0,0,0],3,2,wf4(:,4),wf16(:,31))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,149),heltab2x128(:,:,169))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(31),n2h64(123))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(276)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(170),h0tab(:,170),[64,5,58],[nMT,nMT,nMT],3,2,wf4(:,4),wf16(:,31))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,150),heltab2x128(:,:,170))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(32),n2h64(124))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(276)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(171),h0tab(:,171),[64,5,58],[0,0,0],3,2,wf4(:,4),wf16(:,31))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,151),heltab2x128(:,:,171))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(33),n2h64(125))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(276)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(172),h0tab(:,172),[64,5,58],[nMB,nMB,nMB],3,2,wf4(:,4),wf16(:,31))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,152),heltab2x128(:,:,172))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(34),n2h64(126))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(276)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(173),h0tab(:,173),[64,5,58],[0,0,0],3,2,wf4(:,4),wf16(:,31))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,153),heltab2x128(:,:,173))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(35),n2h64(127))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(276)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(174),h0tab(:,174),[64,5,58],[nMB,nMB,nMB],3,2,wf4(:,4),wf16(:,31))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,154),heltab2x128(:,:,174))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(36),n2h64(128))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(175),h0tab(:,175),[90,5,32],[nMB,nMB,0],3,2,wf16(:,72),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,72),G0H8(1),m3h16x8(:,7),heltab2x128(:,:,175))
  call Hloop_Q_A(ntryL,G0H8(1),90,nMB,G1H8(79),n2h8(75))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(227)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(176),h0tab(:,176),[64,31,32],[nMB,0,nMB],3,1,wf32(:,8))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,155),heltab2x128(:,:,176))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(37),n2h64(129))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(227)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(177),h0tab(:,177),[64,31,32],[0,nMB,0],3,1,wf32(:,8))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(38),m3h2x64(:,156),heltab2x128(:,:,177))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(278)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(178),h0tab(:,178),[64,5,58],[0,0,0],3,2,wf4(:,4),wf16(:,32))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,157),heltab2x128(:,:,178))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(39),n2h64(130))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(278)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(179),h0tab(:,179),[64,5,58],[nMT,nMT,nMT],3,2,wf4(:,4),wf16(:,32))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,158),heltab2x128(:,:,179))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(40),n2h64(131))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(278)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(180),h0tab(:,180),[64,5,58],[0,0,0],3,2,wf4(:,4),wf16(:,32))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,159),heltab2x128(:,:,180))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(41),n2h64(132))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(278)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(181),h0tab(:,181),[64,5,58],[nMT,nMT,nMT],3,2,wf4(:,4),wf16(:,32))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,160),heltab2x128(:,:,181))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(42),n2h64(133))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(278)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(182),h0tab(:,182),[64,5,58],[0,0,0],3,2,wf4(:,4),wf16(:,32))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,161),heltab2x128(:,:,182))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(43),n2h64(134))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(278)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(183),h0tab(:,183),[64,5,58],[nMB,nMB,nMB],3,2,wf4(:,4),wf16(:,32))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,162),heltab2x128(:,:,183))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(44),n2h64(135))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(278)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(184),h0tab(:,184),[64,5,58],[0,0,0],3,2,wf4(:,4),wf16(:,32))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,163),heltab2x128(:,:,184))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(45),n2h64(136))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(278)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(185),h0tab(:,185),[64,5,58],[nMB,nMB,nMB],3,2,wf4(:,4),wf16(:,32))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,164),heltab2x128(:,:,185))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(46),n2h64(137))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(279)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(186),h0tab(:,186),[106,5,16],[nMB,nMB,0],3,2,wf16(:,68),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,68),G0H8(1),m3h16x8(:,8),heltab2x128(:,:,186))
  call Hloop_A_Q(ntryL,G0H8(1),106,nMB,G1H8(84),n2h8(76))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(230)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(187),h0tab(:,187),[64,16,47],[nMB,0,nMB],3,1,wf32(:,10))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,165),heltab2x128(:,:,187))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(47),n2h64(138))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(230)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(188),h0tab(:,188),[64,16,47],[0,nMB,0],3,1,wf32(:,10))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(48),m3h2x64(:,166),heltab2x128(:,:,188))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(231)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(189),h0tab(:,189),[64,31,32],[nMB,0,nMB],3,1,wf32(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,167),heltab2x128(:,:,189))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(49),n2h64(139))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(231)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(190),h0tab(:,190),[64,31,32],[0,nMB,0],3,1,wf32(:,12))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(50),m3h2x64(:,168),heltab2x128(:,:,190))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(191),h0tab(:,191),[64,16,47],[nMB,0,nMB],3,1,wf32(:,14))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,169),heltab2x128(:,:,191))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(51),n2h64(140))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(192),h0tab(:,192),[64,16,47],[0,nMB,0],3,1,wf32(:,14))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(52),m3h2x64(:,170),heltab2x128(:,:,192))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(280)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(193),h0tab(:,193),[64,15,48],[0,0,0],3,2,wf16(:,73),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,171),heltab2x128(:,:,193))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(53),n2h64(141))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(280)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(194),h0tab(:,194),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,73),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,172),heltab2x128(:,:,194))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(54),n2h64(142))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(280)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(195),h0tab(:,195),[64,15,48],[0,0,0],3,2,wf16(:,73),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,173),heltab2x128(:,:,195))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(55),n2h64(143))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(280)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(196),h0tab(:,196),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,73),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,174),heltab2x128(:,:,196))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(56),n2h64(144))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(280)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(197),h0tab(:,197),[64,15,48],[0,0,0],3,2,wf16(:,73),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,175),heltab2x128(:,:,197))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(57),n2h64(145))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(280)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(198),h0tab(:,198),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,73),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,176),heltab2x128(:,:,198))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(58),n2h64(146))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(280)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(199),h0tab(:,199),[64,15,48],[0,0,0],3,2,wf16(:,73),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,177),heltab2x128(:,:,199))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(59),n2h64(147))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(280)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(200),h0tab(:,200),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,73),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,178),heltab2x128(:,:,200))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(60),n2h64(148))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(281)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(201),h0tab(:,201),[64,15,48],[0,0,0],3,2,wf16(:,74),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,179),heltab2x128(:,:,201))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(61),n2h64(149))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(281)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(202),h0tab(:,202),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,74),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,180),heltab2x128(:,:,202))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(62),n2h64(150))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(281)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(203),h0tab(:,203),[64,15,48],[0,0,0],3,2,wf16(:,74),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,181),heltab2x128(:,:,203))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(63),n2h64(151))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(281)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(204),h0tab(:,204),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,74),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,182),heltab2x128(:,:,204))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(64),n2h64(152))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(281)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(205),h0tab(:,205),[64,15,48],[0,0,0],3,2,wf16(:,74),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,183),heltab2x128(:,:,205))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(65),n2h64(153))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(281)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(206),h0tab(:,206),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,74),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,184),heltab2x128(:,:,206))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(66),n2h64(154))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(281)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(207),h0tab(:,207),[64,15,48],[0,0,0],3,2,wf16(:,74),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,185),heltab2x128(:,:,207))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(67),n2h64(155))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(281)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(208),h0tab(:,208),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,74),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,186),heltab2x128(:,:,208))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(68),n2h64(156))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(282)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(209),h0tab(:,209),[80,15,32],[nMB,nMB,0],3,2,wf4(:,6),wf16(:,73))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,6),G0H32(1),m3h4x32(:,15),heltab2x128(:,:,209))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(11),n2h32(51))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(283)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(210),h0tab(:,210),[80,15,32],[nMB,nMB,0],3,2,wf4(:,6),wf16(:,74))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,6),G0H32(1),m3h4x32(:,16),heltab2x128(:,:,210))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(12),n2h32(52))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(284)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(211),h0tab(:,211),[96,15,16],[nMB,nMB,0],3,2,wf4(:,8),wf16(:,73))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(1),m3h4x32(:,17),heltab2x128(:,:,211))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(13),n2h32(53))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(285)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(212),h0tab(:,212),[96,15,16],[nMB,nMB,0],3,2,wf4(:,8),wf16(:,74))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(1),m3h4x32(:,18),heltab2x128(:,:,212))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(14),n2h32(54))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(213),h0tab(:,213),[64,31,32],[nMB,0,nMB],3,1,wf32(:,16))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,187),heltab2x128(:,:,213))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(69),n2h64(157))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(214),h0tab(:,214),[64,31,32],[0,nMB,0],3,1,wf32(:,16))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(70),m3h2x64(:,188),heltab2x128(:,:,214))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(215),h0tab(:,215),[64,16,47],[nMB,0,nMB],3,1,wf32(:,18))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,189),heltab2x128(:,:,215))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(71),n2h64(158))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(216),h0tab(:,216),[64,16,47],[0,nMB,0],3,1,wf32(:,18))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(72),m3h2x64(:,190),heltab2x128(:,:,216))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(217),h0tab(:,217),[64,31,32],[nMB,0,nMB],3,1,wf32(:,20))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,191),heltab2x128(:,:,217))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(73),n2h64(159))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(218),h0tab(:,218),[64,31,32],[0,nMB,0],3,1,wf32(:,20))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(74),m3h2x64(:,192),heltab2x128(:,:,218))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(236)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(219),h0tab(:,219),[64,16,47],[nMB,0,nMB],3,1,wf32(:,22))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,193),heltab2x128(:,:,219))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(75),n2h64(160))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(236)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(220),h0tab(:,220),[64,16,47],[0,nMB,0],3,1,wf32(:,22))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(76),m3h2x64(:,194),heltab2x128(:,:,220))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(115)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(221),h0tab(:,221),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,12),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,195),heltab2x128(:,:,221))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(77),n2h64(161))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(115)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(222),h0tab(:,222),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,12),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,196),heltab2x128(:,:,222))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(78),n2h64(162))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(115)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(223),h0tab(:,223),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,12),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,197),heltab2x128(:,:,223))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(79),n2h64(163))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(115)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(224),h0tab(:,224),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,12),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,198),heltab2x128(:,:,224))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(80),n2h64(164))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(287)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(225),h0tab(:,225),[80,6,41],[nMB,nMB,0],3,3,wf4(:,6),wf4(:,12),wf8(:,20))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,6),G0H32(1),m3h4x32(:,19),heltab2x128(:,:,225))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(8),n2h32(55))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(288)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(226),h0tab(:,226),[80,9,38],[nMB,nMB,0],3,3,wf4(:,6),wf4(:,11),wf8(:,22))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,6),G0H32(1),m3h4x32(:,20),heltab2x128(:,:,226))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(10),n2h32(56))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(227),h0tab(:,227),[80,15,32],[nMB,nMB,0],3,2,wf4(:,6),wf16(:,12))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,6),G0H32(1),m3h4x32(:,21),heltab2x128(:,:,227))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(17),n2h32(57))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(228),h0tab(:,228),[89,6,32],[nMB,nMB,0],3,2,wf16(:,53),wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,53),G0H8(1),m3h16x8(:,9),heltab2x128(:,:,228))
  call Hloop_Q_A(ntryL,G0H8(1),89,nMB,G1H8(80),n2h8(77))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(130)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(229),h0tab(:,229),[86,9,32],[nMB,nMB,0],3,2,wf16(:,54),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,54),G0H8(1),m3h16x8(:,10),heltab2x128(:,:,229))
  call Hloop_Q_A(ntryL,G0H8(1),86,nMB,G1H8(83),n2h8(78))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(290)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(230),h0tab(:,230),[96,6,25],[nMB,nMB,0],3,3,wf4(:,8),wf4(:,12),wf8(:,24))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(1),m3h4x32(:,22),heltab2x128(:,:,230))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(18),n2h32(58))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(291)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(231),h0tab(:,231),[96,9,22],[nMB,nMB,0],3,3,wf4(:,8),wf4(:,11),wf8(:,26))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(1),m3h4x32(:,23),heltab2x128(:,:,231))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(20),n2h32(59))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(131)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(232),h0tab(:,232),[96,15,16],[nMB,nMB,0],3,2,wf4(:,8),wf16(:,12))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(1),m3h4x32(:,24),heltab2x128(:,:,232))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(22),n2h32(60))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(134)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(233),h0tab(:,233),[105,6,16],[nMB,nMB,0],3,2,wf16(:,57),wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,57),G0H8(1),m3h16x8(:,11),heltab2x128(:,:,233))
  call Hloop_A_Q(ntryL,G0H8(1),105,nMB,G1H8(88),n2h8(79))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(137)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(234),h0tab(:,234),[102,9,16],[nMB,nMB,0],3,2,wf16(:,58),wf4(:,11))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,58),G0H8(1),m3h16x8(:,12),heltab2x128(:,:,234))
  call Hloop_A_Q(ntryL,G0H8(1),102,nMB,G1H8(29),n2h8(80))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(235),h0tab(:,235),[64,25,38],[nMB,0,nMB],3,2,wf8(:,24),wf8(:,22))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,199),heltab2x128(:,:,235))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(81),n2h64(165))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(236),h0tab(:,236),[64,25,38],[0,nMB,0],3,2,wf8(:,24),wf8(:,22))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(82),m3h2x64(:,200),heltab2x128(:,:,236))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(293)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(237),h0tab(:,237),[64,6,57],[0,0,0],3,2,wf4(:,12),wf16(:,48))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,201),heltab2x128(:,:,237))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(83),n2h64(166))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(293)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(238),h0tab(:,238),[64,6,57],[nMT,nMT,nMT],3,2,wf4(:,12),wf16(:,48))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,202),heltab2x128(:,:,238))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(84),n2h64(167))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(293)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(239),h0tab(:,239),[64,6,57],[0,0,0],3,2,wf4(:,12),wf16(:,48))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,203),heltab2x128(:,:,239))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(85),n2h64(168))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(293)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(240),h0tab(:,240),[64,6,57],[nMT,nMT,nMT],3,2,wf4(:,12),wf16(:,48))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,204),heltab2x128(:,:,240))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(86),n2h64(169))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(293)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(241),h0tab(:,241),[64,6,57],[0,0,0],3,2,wf4(:,12),wf16(:,48))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,205),heltab2x128(:,:,241))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(87),n2h64(170))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(293)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(242),h0tab(:,242),[64,6,57],[nMB,nMB,nMB],3,2,wf4(:,12),wf16(:,48))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,206),heltab2x128(:,:,242))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(88),n2h64(171))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(293)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(243),h0tab(:,243),[64,6,57],[0,0,0],3,2,wf4(:,12),wf16(:,48))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,207),heltab2x128(:,:,243))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(89),n2h64(172))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(293)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(244),h0tab(:,244),[64,6,57],[nMB,nMB,nMB],3,2,wf4(:,12),wf16(:,48))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,208),heltab2x128(:,:,244))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(90),n2h64(173))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(294)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(245),h0tab(:,245),[89,6,32],[nMB,nMB,0],3,2,wf16(:,83),wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,83),G0H8(1),m3h16x8(:,13),heltab2x128(:,:,245))
  call Hloop_Q_A(ntryL,G0H8(1),89,nMB,G1H8(30),n2h8(81))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(240)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(246),h0tab(:,246),[64,31,32],[nMB,0,nMB],3,1,wf32(:,24))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,209),heltab2x128(:,:,246))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(91),n2h64(174))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(240)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(247),h0tab(:,247),[64,31,32],[0,nMB,0],3,1,wf32(:,24))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(92),m3h2x64(:,210),heltab2x128(:,:,247))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(248),h0tab(:,248),[64,22,41],[nMB,0,nMB],3,2,wf8(:,26),wf8(:,20))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,211),heltab2x128(:,:,248))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(93),n2h64(175))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(249),h0tab(:,249),[64,22,41],[0,nMB,0],3,2,wf8(:,26),wf8(:,20))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(94),m3h2x64(:,212),heltab2x128(:,:,249))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(295)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(250),h0tab(:,250),[64,6,57],[0,0,0],3,2,wf4(:,12),wf16(:,50))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,213),heltab2x128(:,:,250))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(95),n2h64(176))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(295)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(251),h0tab(:,251),[64,6,57],[nMT,nMT,nMT],3,2,wf4(:,12),wf16(:,50))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,214),heltab2x128(:,:,251))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(96),n2h64(177))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(295)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(252),h0tab(:,252),[64,6,57],[0,0,0],3,2,wf4(:,12),wf16(:,50))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,215),heltab2x128(:,:,252))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(97),n2h64(178))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(295)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(253),h0tab(:,253),[64,6,57],[nMT,nMT,nMT],3,2,wf4(:,12),wf16(:,50))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,216),heltab2x128(:,:,253))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(98),n2h64(179))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(295)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(254),h0tab(:,254),[64,6,57],[0,0,0],3,2,wf4(:,12),wf16(:,50))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,217),heltab2x128(:,:,254))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(99),n2h64(180))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(295)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(255),h0tab(:,255),[64,6,57],[nMB,nMB,nMB],3,2,wf4(:,12),wf16(:,50))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,218),heltab2x128(:,:,255))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(100),n2h64(181))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(295)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(256),h0tab(:,256),[64,6,57],[0,0,0],3,2,wf4(:,12),wf16(:,50))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,219),heltab2x128(:,:,256))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(101),n2h64(182))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(295)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(257),h0tab(:,257),[64,6,57],[nMB,nMB,nMB],3,2,wf4(:,12),wf16(:,50))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,220),heltab2x128(:,:,257))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(102),n2h64(183))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(296)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(258),h0tab(:,258),[105,6,16],[nMB,nMB,0],3,2,wf16(:,82),wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,82),G0H8(1),m3h16x8(:,14),heltab2x128(:,:,258))
  call Hloop_A_Q(ntryL,G0H8(1),105,nMB,G1H8(45),n2h8(82))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(243)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(259),h0tab(:,259),[64,16,47],[nMB,0,nMB],3,1,wf32(:,26))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,221),heltab2x128(:,:,259))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(103),n2h64(184))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(243)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(260),h0tab(:,260),[64,16,47],[0,nMB,0],3,1,wf32(:,26))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(104),m3h2x64(:,222),heltab2x128(:,:,260))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(297)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(261),h0tab(:,261),[64,9,54],[0,0,0],3,2,wf4(:,11),wf16(:,51))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,223),heltab2x128(:,:,261))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(105),n2h64(185))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(297)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(262),h0tab(:,262),[64,9,54],[nMT,nMT,nMT],3,2,wf4(:,11),wf16(:,51))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,224),heltab2x128(:,:,262))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(106),n2h64(186))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(297)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(263),h0tab(:,263),[64,9,54],[0,0,0],3,2,wf4(:,11),wf16(:,51))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,225),heltab2x128(:,:,263))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(107),n2h64(187))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(297)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(264),h0tab(:,264),[64,9,54],[nMT,nMT,nMT],3,2,wf4(:,11),wf16(:,51))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,226),heltab2x128(:,:,264))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(108),n2h64(188))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(297)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(265),h0tab(:,265),[64,9,54],[0,0,0],3,2,wf4(:,11),wf16(:,51))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,227),heltab2x128(:,:,265))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(109),n2h64(189))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(297)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(266),h0tab(:,266),[64,9,54],[nMB,nMB,nMB],3,2,wf4(:,11),wf16(:,51))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,228),heltab2x128(:,:,266))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(110),n2h64(190))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(297)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(267),h0tab(:,267),[64,9,54],[0,0,0],3,2,wf4(:,11),wf16(:,51))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,229),heltab2x128(:,:,267))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(111),n2h64(191))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(297)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(268),h0tab(:,268),[64,9,54],[nMB,nMB,nMB],3,2,wf4(:,11),wf16(:,51))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,230),heltab2x128(:,:,268))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(112),n2h64(192))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(298)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(269),h0tab(:,269),[86,9,32],[nMB,nMB,0],3,2,wf16(:,84),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,84),G0H8(1),m3h16x8(:,15),heltab2x128(:,:,269))
  call Hloop_Q_A(ntryL,G0H8(1),86,nMB,G1H8(61),n2h8(83))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(247)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(270),h0tab(:,270),[64,31,32],[nMB,0,nMB],3,1,wf32(:,28))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,231),heltab2x128(:,:,270))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(113),n2h64(193))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(247)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(271),h0tab(:,271),[64,31,32],[0,nMB,0],3,1,wf32(:,28))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(114),m3h2x64(:,232),heltab2x128(:,:,271))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(299)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(272),h0tab(:,272),[64,9,54],[0,0,0],3,2,wf4(:,11),wf16(:,52))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,233),heltab2x128(:,:,272))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(115),n2h64(194))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(299)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(273),h0tab(:,273),[64,9,54],[nMT,nMT,nMT],3,2,wf4(:,11),wf16(:,52))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,234),heltab2x128(:,:,273))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(116),n2h64(195))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(299)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(274),h0tab(:,274),[64,9,54],[0,0,0],3,2,wf4(:,11),wf16(:,52))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,235),heltab2x128(:,:,274))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(117),n2h64(196))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(299)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(275),h0tab(:,275),[64,9,54],[nMT,nMT,nMT],3,2,wf4(:,11),wf16(:,52))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,236),heltab2x128(:,:,275))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(118),n2h64(197))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(299)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(276),h0tab(:,276),[64,9,54],[0,0,0],3,2,wf4(:,11),wf16(:,52))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,237),heltab2x128(:,:,276))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(119),n2h64(198))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(299)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(277),h0tab(:,277),[64,9,54],[nMB,nMB,nMB],3,2,wf4(:,11),wf16(:,52))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,238),heltab2x128(:,:,277))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(120),n2h64(199))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(299)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(278),h0tab(:,278),[64,9,54],[0,0,0],3,2,wf4(:,11),wf16(:,52))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,239),heltab2x128(:,:,278))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(121),n2h64(200))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(299)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(279),h0tab(:,279),[64,9,54],[nMB,nMB,nMB],3,2,wf4(:,11),wf16(:,52))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,240),heltab2x128(:,:,279))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(122),n2h64(201))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(300)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(280),h0tab(:,280),[102,9,16],[nMB,nMB,0],3,2,wf16(:,80),wf4(:,11))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,80),G0H8(1),m3h16x8(:,16),heltab2x128(:,:,280))
  call Hloop_A_Q(ntryL,G0H8(1),102,nMB,G1H8(62),n2h8(84))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(281),h0tab(:,281),[64,16,47],[nMB,0,nMB],3,1,wf32(:,30))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,241),heltab2x128(:,:,281))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(123),n2h64(202))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(282),h0tab(:,282),[64,16,47],[0,nMB,0],3,1,wf32(:,30))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(124),m3h2x64(:,242),heltab2x128(:,:,282))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(251)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(283),h0tab(:,283),[64,31,32],[nMB,0,nMB],3,1,wf32(:,32))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,243),heltab2x128(:,:,283))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(125),n2h64(203))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(251)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(284),h0tab(:,284),[64,31,32],[0,nMB,0],3,1,wf32(:,32))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(126),m3h2x64(:,244),heltab2x128(:,:,284))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(252)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(285),h0tab(:,285),[64,16,47],[nMB,0,nMB],3,1,wf32(:,34))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,245),heltab2x128(:,:,285))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(127),n2h64(204))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(252)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(286),h0tab(:,286),[64,16,47],[0,nMB,0],3,1,wf32(:,34))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(128),m3h2x64(:,246),heltab2x128(:,:,286))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(287),h0tab(:,287),[64,15,48],[0,0,0],3,2,wf16(:,85),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,247),heltab2x128(:,:,287))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(129),n2h64(205))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(288),h0tab(:,288),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,85),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,248),heltab2x128(:,:,288))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(130),n2h64(206))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(289),h0tab(:,289),[64,15,48],[0,0,0],3,2,wf16(:,85),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,249),heltab2x128(:,:,289))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(131),n2h64(207))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(290),h0tab(:,290),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,85),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,250),heltab2x128(:,:,290))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(132),n2h64(208))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(291),h0tab(:,291),[64,15,48],[0,0,0],3,2,wf16(:,85),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,251),heltab2x128(:,:,291))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(133),n2h64(209))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(292),h0tab(:,292),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,85),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,252),heltab2x128(:,:,292))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(134),n2h64(210))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(293),h0tab(:,293),[64,15,48],[0,0,0],3,2,wf16(:,85),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,253),heltab2x128(:,:,293))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(135),n2h64(211))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(294),h0tab(:,294),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,85),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,254),heltab2x128(:,:,294))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(136),n2h64(212))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(295),h0tab(:,295),[64,15,48],[0,0,0],3,2,wf16(:,86),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,255),heltab2x128(:,:,295))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(137),n2h64(213))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(296),h0tab(:,296),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,86),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,256),heltab2x128(:,:,296))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(138),n2h64(214))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(297),h0tab(:,297),[64,15,48],[0,0,0],3,2,wf16(:,86),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,257),heltab2x128(:,:,297))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(139),n2h64(215))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(298),h0tab(:,298),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,86),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,258),heltab2x128(:,:,298))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(140),n2h64(216))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(299),h0tab(:,299),[64,15,48],[0,0,0],3,2,wf16(:,86),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,259),heltab2x128(:,:,299))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(141),n2h64(217))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(300),h0tab(:,300),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,86),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,260),heltab2x128(:,:,300))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(142),n2h64(218))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(301),h0tab(:,301),[64,15,48],[0,0,0],3,2,wf16(:,86),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,261),heltab2x128(:,:,301))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(143),n2h64(219))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(302),h0tab(:,302),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,86),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,262),heltab2x128(:,:,302))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(144),n2h64(220))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(303)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(303),h0tab(:,303),[80,15,32],[nMB,nMB,0],3,2,wf4(:,6),wf16(:,85))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,6),G0H32(1),m3h4x32(:,25),heltab2x128(:,:,303))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(23),n2h32(61))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(304)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(304),h0tab(:,304),[80,15,32],[nMB,nMB,0],3,2,wf4(:,6),wf16(:,86))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,6),G0H32(1),m3h4x32(:,26),heltab2x128(:,:,304))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(24),n2h32(62))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(305)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(305),h0tab(:,305),[96,15,16],[nMB,nMB,0],3,2,wf4(:,8),wf16(:,85))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(1),m3h4x32(:,27),heltab2x128(:,:,305))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(9),n2h32(63))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(306)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(306),h0tab(:,306),[96,15,16],[nMB,nMB,0],3,2,wf4(:,8),wf16(:,86))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(1),m3h4x32(:,28),heltab2x128(:,:,306))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(25),n2h32(64))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(253)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(307),h0tab(:,307),[64,31,32],[nMB,0,nMB],3,1,wf32(:,36))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,263),heltab2x128(:,:,307))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(145),n2h64(221))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(253)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(308),h0tab(:,308),[64,31,32],[0,nMB,0],3,1,wf32(:,36))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(146),m3h2x64(:,264),heltab2x128(:,:,308))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(254)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(309),h0tab(:,309),[64,16,47],[nMB,0,nMB],3,1,wf32(:,38))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,265),heltab2x128(:,:,309))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(147),n2h64(222))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(254)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(310),h0tab(:,310),[64,16,47],[0,nMB,0],3,1,wf32(:,38))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(148),m3h2x64(:,266),heltab2x128(:,:,310))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(255)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(311),h0tab(:,311),[64,31,32],[nMB,0,nMB],3,1,wf32(:,40))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,267),heltab2x128(:,:,311))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(149),n2h64(223))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(255)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(312),h0tab(:,312),[64,31,32],[0,nMB,0],3,1,wf32(:,40))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(150),m3h2x64(:,268),heltab2x128(:,:,312))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(256)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(313),h0tab(:,313),[64,16,47],[nMB,0,nMB],3,1,wf32(:,42))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,269),heltab2x128(:,:,313))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(151),n2h64(224))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(256)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(314),h0tab(:,314),[64,16,47],[0,nMB,0],3,1,wf32(:,42))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(152),m3h2x64(:,270),heltab2x128(:,:,314))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(307)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(315),h0tab(:,315),[64,15,48],[0,0,0],3,2,wf16(:,87),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,271),heltab2x128(:,:,315))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(153),n2h64(225))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(307)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(316),h0tab(:,316),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,87),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,272),heltab2x128(:,:,316))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(154),n2h64(226))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(307)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(317),h0tab(:,317),[64,15,48],[0,0,0],3,2,wf16(:,87),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,273),heltab2x128(:,:,317))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(155),n2h64(227))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(307)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(318),h0tab(:,318),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,87),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,274),heltab2x128(:,:,318))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(156),n2h64(228))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(307)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(319),h0tab(:,319),[64,15,48],[0,0,0],3,2,wf16(:,87),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,275),heltab2x128(:,:,319))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(157),n2h64(229))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(307)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(320),h0tab(:,320),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,87),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,276),heltab2x128(:,:,320))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(158),n2h64(230))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(307)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(321),h0tab(:,321),[64,15,48],[0,0,0],3,2,wf16(:,87),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,277),heltab2x128(:,:,321))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(159),n2h64(231))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(307)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(322),h0tab(:,322),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,87),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,278),heltab2x128(:,:,322))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(160),n2h64(232))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(308)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(323),h0tab(:,323),[64,15,48],[0,0,0],3,2,wf16(:,88),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,279),heltab2x128(:,:,323))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(161),n2h64(233))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(308)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(324),h0tab(:,324),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,88),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,280),heltab2x128(:,:,324))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(162),n2h64(234))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(308)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(325),h0tab(:,325),[64,15,48],[0,0,0],3,2,wf16(:,88),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,281),heltab2x128(:,:,325))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(163),n2h64(235))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(308)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(326),h0tab(:,326),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,88),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,282),heltab2x128(:,:,326))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(164),n2h64(236))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(308)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(327),h0tab(:,327),[64,15,48],[0,0,0],3,2,wf16(:,88),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,283),heltab2x128(:,:,327))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(165),n2h64(237))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(308)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(328),h0tab(:,328),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,88),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,284),heltab2x128(:,:,328))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(166),n2h64(238))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(308)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(329),h0tab(:,329),[64,15,48],[0,0,0],3,2,wf16(:,88),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,285),heltab2x128(:,:,329))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(167),n2h64(239))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(308)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(330),h0tab(:,330),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,88),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,286),heltab2x128(:,:,330))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(168),n2h64(240))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(309)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(331),h0tab(:,331),[80,15,32],[nMB,nMB,0],3,2,wf4(:,6),wf16(:,87))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,6),G0H32(1),m3h4x32(:,29),heltab2x128(:,:,331))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(26),n2h32(65))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(310)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(332),h0tab(:,332),[80,15,32],[nMB,nMB,0],3,2,wf4(:,6),wf16(:,88))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,6),G0H32(1),m3h4x32(:,30),heltab2x128(:,:,332))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(27),n2h32(66))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(311)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(333),h0tab(:,333),[96,15,16],[nMB,nMB,0],3,2,wf4(:,8),wf16(:,87))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(1),m3h4x32(:,31),heltab2x128(:,:,333))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(29),n2h32(67))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(312)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(334),h0tab(:,334),[96,15,16],[nMB,nMB,0],3,2,wf4(:,8),wf16(:,88))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(1),m3h4x32(:,32),heltab2x128(:,:,334))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(30),n2h32(68))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(257)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(335),h0tab(:,335),[64,31,32],[nMB,0,nMB],3,1,wf32(:,44))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,287),heltab2x128(:,:,335))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(169),n2h64(241))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(257)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(336),h0tab(:,336),[64,31,32],[0,nMB,0],3,1,wf32(:,44))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(170),m3h2x64(:,288),heltab2x128(:,:,336))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(258)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(337),h0tab(:,337),[64,16,47],[nMB,0,nMB],3,1,wf32(:,46))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,289),heltab2x128(:,:,337))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(171),n2h64(242))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(258)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(338),h0tab(:,338),[64,16,47],[0,nMB,0],3,1,wf32(:,46))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(172),m3h2x64(:,290),heltab2x128(:,:,338))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(259)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(339),h0tab(:,339),[64,31,32],[nMB,0,nMB],3,1,wf32(:,48))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,291),heltab2x128(:,:,339))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(173),n2h64(243))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(259)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(340),h0tab(:,340),[64,31,32],[0,nMB,0],3,1,wf32(:,48))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(174),m3h2x64(:,292),heltab2x128(:,:,340))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(260)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(341),h0tab(:,341),[64,16,47],[nMB,0,nMB],3,1,wf32(:,50))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,293),heltab2x128(:,:,341))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(175),n2h64(244))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(260)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(342),h0tab(:,342),[64,16,47],[0,nMB,0],3,1,wf32(:,50))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(176),m3h2x64(:,294),heltab2x128(:,:,342))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(313)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(343),h0tab(:,343),[64,15,48],[0,0,0],3,2,wf16(:,89),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,295),heltab2x128(:,:,343))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(177),n2h64(245))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(313)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(344),h0tab(:,344),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,89),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,296),heltab2x128(:,:,344))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(178),n2h64(246))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(313)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(345),h0tab(:,345),[64,15,48],[0,0,0],3,2,wf16(:,89),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,297),heltab2x128(:,:,345))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(179),n2h64(247))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(313)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(346),h0tab(:,346),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,89),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,298),heltab2x128(:,:,346))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(180),n2h64(248))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(313)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(347),h0tab(:,347),[64,15,48],[0,0,0],3,2,wf16(:,89),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,299),heltab2x128(:,:,347))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(181),n2h64(249))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(313)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(348),h0tab(:,348),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,89),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,300),heltab2x128(:,:,348))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(182),n2h64(250))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(313)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(349),h0tab(:,349),[64,15,48],[0,0,0],3,2,wf16(:,89),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,301),heltab2x128(:,:,349))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(183),n2h64(251))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(313)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(350),h0tab(:,350),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,89),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,302),heltab2x128(:,:,350))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(184),n2h64(252))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(314)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(351),h0tab(:,351),[64,15,48],[0,0,0],3,2,wf16(:,90),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,303),heltab2x128(:,:,351))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(185),n2h64(253))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(314)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(352),h0tab(:,352),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,90),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,304),heltab2x128(:,:,352))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(186),n2h64(254))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(314)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(353),h0tab(:,353),[64,15,48],[0,0,0],3,2,wf16(:,90),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,305),heltab2x128(:,:,353))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(187),n2h64(255))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(314)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(354),h0tab(:,354),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,90),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,306),heltab2x128(:,:,354))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(188),n2h64(256))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(314)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(355),h0tab(:,355),[64,15,48],[0,0,0],3,2,wf16(:,90),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,307),heltab2x128(:,:,355))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(189),n2h64(257))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(314)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(356),h0tab(:,356),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,90),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,308),heltab2x128(:,:,356))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(190),n2h64(258))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(314)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(357),h0tab(:,357),[64,15,48],[0,0,0],3,2,wf16(:,90),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,309),heltab2x128(:,:,357))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(191),n2h64(259))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(314)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(358),h0tab(:,358),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,90),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,310),heltab2x128(:,:,358))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(192),n2h64(260))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(315)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(359),h0tab(:,359),[80,15,32],[nMB,nMB,0],3,2,wf4(:,6),wf16(:,89))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,6),G0H32(1),m3h4x32(:,33),heltab2x128(:,:,359))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(31),n2h32(69))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(316)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(360),h0tab(:,360),[80,15,32],[nMB,nMB,0],3,2,wf4(:,6),wf16(:,90))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,6),G0H32(1),m3h4x32(:,34),heltab2x128(:,:,360))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(32),n2h32(70))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(317)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(361),h0tab(:,361),[96,15,16],[nMB,nMB,0],3,2,wf4(:,8),wf16(:,89))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(1),m3h4x32(:,35),heltab2x128(:,:,361))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(34),n2h32(71))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(318)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(362),h0tab(:,362),[96,15,16],[nMB,nMB,0],3,2,wf4(:,8),wf16(:,90))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(1),m3h4x32(:,36),heltab2x128(:,:,362))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(35),n2h32(72))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(363),h0tab(:,363),[64,31,32],[nMB,0,nMB],3,1,wf32(:,52))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,311),heltab2x128(:,:,363))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(193),n2h64(261))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(364),h0tab(:,364),[64,31,32],[0,nMB,0],3,1,wf32(:,52))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(194),m3h2x64(:,312),heltab2x128(:,:,364))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(262)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(365),h0tab(:,365),[64,16,47],[nMB,0,nMB],3,1,wf32(:,54))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,313),heltab2x128(:,:,365))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(195),n2h64(262))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(262)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(366),h0tab(:,366),[64,16,47],[0,nMB,0],3,1,wf32(:,54))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(196),m3h2x64(:,314),heltab2x128(:,:,366))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(263)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(367),h0tab(:,367),[64,31,32],[nMB,0,nMB],3,1,wf32(:,56))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,315),heltab2x128(:,:,367))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(197),n2h64(263))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(263)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(368),h0tab(:,368),[64,31,32],[0,nMB,0],3,1,wf32(:,56))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(198),m3h2x64(:,316),heltab2x128(:,:,368))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(369),h0tab(:,369),[64,16,47],[nMB,0,nMB],3,1,wf32(:,58))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,317),heltab2x128(:,:,369))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(199),n2h64(264))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(370),h0tab(:,370),[64,16,47],[0,nMB,0],3,1,wf32(:,58))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(200),m3h2x64(:,318),heltab2x128(:,:,370))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(79),[G1H8(68),G1H8(56),G1H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(72),[G1H8(63),G1H8(47),G1H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(84),[G1H8(69),G1H8(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(73),[G1H8(67),G1H8(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(61),[G1H8(83),G1H8(27),G1H8(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(30),[G1H8(80),G1H8(1),G1H8(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(62),[G1H8(29),G1H8(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(45),[G1H8(88),G1H8(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(15),[G1H32(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(21),[G1H32(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(1),[G1H32(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(11),[G1H32(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(12),[G1H32(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(8),[G1H32(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(10),[G1H32(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(17),[G1H32(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(23),[G1H32(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(24),[G1H32(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(26),[G1H32(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(27),[G1H32(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(31),[G1H32(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(32),[G1H32(68)])
  call Hloop_QZ_A(ntryL,G1H8(79),wf4(:,4),G1H2(75),ngZd,m3h4x2(:,77),heltab2x8(:,:,153))
  call Hloop_Q_A(ntryL,G1H2(75),95,nMB,G2H2(2),n2h2(103))
  call Hloop_QZ_A(ntryL,G1H8(72),wf4(:,5),G1H2(77),ngZd,m3h4x2(:,78),heltab2x8(:,:,154))
  call Hloop_Q_A(ntryL,G1H2(77),95,nMB,G2H2(5),n2h2(104))
  call Hloop_AZ_Q(ntryL,G1H8(84),wf4(:,4),G1H2(86),ngZd,m3h4x2(:,79),heltab2x8(:,:,155))
  call Hloop_A_Q(ntryL,G1H2(86),111,nMB,G2H2(8),n2h2(105))
  call Hloop_AZ_Q(ntryL,G1H8(73),wf4(:,5),G1H2(88),ngZd,m3h4x2(:,80),heltab2x8(:,:,156))
  call Hloop_A_Q(ntryL,G1H2(88),111,nMB,G2H2(11),n2h2(106))
  call Hloop_QZ_A(ntryL,G1H8(61),wf4(:,11),G1H2(28),ngZd,m3h4x2(:,81),heltab2x8(:,:,157))
  call Hloop_Q_A(ntryL,G1H2(28),95,nMB,G2H2(14),n2h2(107))
  call Hloop_QZ_A(ntryL,G1H8(30),wf4(:,12),G1H2(39),ngZd,m3h4x2(:,82),heltab2x8(:,:,158))
  call Hloop_Q_A(ntryL,G1H2(39),95,nMB,G2H2(17),n2h2(108))
  call Hloop_AZ_Q(ntryL,G1H8(62),wf4(:,11),G1H2(72),ngZd,m3h4x2(:,83),heltab2x8(:,:,159))
  call Hloop_A_Q(ntryL,G1H2(72),111,nMB,G2H2(20),n2h2(109))
  call Hloop_AZ_Q(ntryL,G1H8(45),wf4(:,12),G1H2(83),ngZd,m3h4x2(:,84),heltab2x8(:,:,160))
  call Hloop_A_Q(ntryL,G1H2(83),111,nMB,G2H2(23),n2h2(110))
  call Hloop_AV_Q(ntryL,G1H16(32),wf4(:,13),G1H4(98),m3h4x4(:,285),heltab2x16(:,:,313))
  call Hloop_A_Q(ntryL,G1H4(98),117,0,G2H4(3),n2h4(277))
  call Hloop_AV_Q(ntryL,G1H16(38),wf4(:,13),G1H4(17),m3h4x4(:,286),heltab2x16(:,:,314))
  call Hloop_A_Q(ntryL,G1H4(17),117,nMT,G2H4(7),n2h4(278))
  call Hloop_QV_A(ntryL,G1H16(44),wf4(:,13),G1H4(28),m3h4x4(:,287),heltab2x16(:,:,315))
  call Hloop_Q_A(ntryL,G1H4(28),117,0,G2H4(11),n2h4(279))
  call Hloop_QV_A(ntryL,G1H16(9),wf4(:,13),G1H4(1),m3h4x4(:,288),heltab2x16(:,:,316))
  call Hloop_Q_A(ntryL,G1H4(1),117,nMT,G2H4(15),n2h4(280))
  call Hloop_AV_Q(ntryL,G1H16(39),wf4(:,13),G1H4(4),m3h4x4(:,289),heltab2x16(:,:,317))
  call Hloop_A_Q(ntryL,G1H4(4),117,0,G2H4(49),n2h4(281))
  call Hloop_AV_Q(ntryL,G1H16(10),wf4(:,13),G1H4(7),m3h4x4(:,290),heltab2x16(:,:,318))
  call Hloop_A_Q(ntryL,G1H4(7),117,nMB,G2H4(52),n2h4(282))
  call Hloop_QV_A(ntryL,G1H16(16),wf4(:,13),G1H4(16),m3h4x4(:,291),heltab2x16(:,:,319))
  call Hloop_Q_A(ntryL,G1H4(16),117,0,G2H4(57),n2h4(283))
  call Hloop_QV_A(ntryL,G1H16(22),wf4(:,13),G1H4(23),m3h4x4(:,292),heltab2x16(:,:,320))
  call Hloop_Q_A(ntryL,G1H4(23),117,nMB,G2H4(60),n2h4(284))
  call Hloop_AZ_Q(ntryL,G1H16(28),wf4(:,5),G1H4(26),ngZu,m3h4x4(:,293),heltab2x16(:,:,321))
  call Hloop_A_Q(ntryL,G1H4(26),79,0,G2H4(81),n2h4(285))
  call Hloop_AZ_Q(ntryL,G1H16(5),wf4(:,5),G1H4(37),ngZu,m3h4x4(:,294),heltab2x16(:,:,322))
  call Hloop_A_Q(ntryL,G1H4(37),79,nMT,G2H4(84),n2h4(286))
  call Hloop_QZ_A(ntryL,G1H16(53),wf4(:,5),G1H4(38),ngZu,m3h4x4(:,295),heltab2x16(:,:,323))
  call Hloop_Q_A(ntryL,G1H4(38),79,0,G2H4(89),n2h4(287))
  call Hloop_QZ_A(ntryL,G1H16(58),wf4(:,5),G1H4(45),ngZu,m3h4x4(:,296),heltab2x16(:,:,324))
  call Hloop_Q_A(ntryL,G1H4(45),79,nMT,G2H4(92),n2h4(288))
  call Hloop_AZ_Q(ntryL,G1H16(63),wf4(:,5),G1H4(56),ngZd,m3h4x4(:,297),heltab2x16(:,:,325))
  call Hloop_A_Q(ntryL,G1H4(56),79,0,G2H4(145),n2h4(289))
  call Hloop_AZ_Q(ntryL,G1H16(68),wf4(:,5),G1H4(57),ngZd,m3h4x4(:,298),heltab2x16(:,:,326))
  call Hloop_A_Q(ntryL,G1H4(57),79,nMB,G2H4(148),n2h4(290))
  call Hloop_QZ_A(ntryL,G1H16(73),wf4(:,5),G1H4(59),ngZd,m3h4x4(:,299),heltab2x16(:,:,327))
  call Hloop_Q_A(ntryL,G1H4(59),79,0,G2H4(153),n2h4(291))
  call Hloop_QZ_A(ntryL,G1H16(78),wf4(:,5),G1H4(83),ngZd,m3h4x4(:,300),heltab2x16(:,:,328))
  call Hloop_Q_A(ntryL,G1H4(83),79,nMB,G2H4(156),n2h4(292))
  call Hloop_AZ_Q(ntryL,G1H16(83),wf4(:,4),G1H4(85),ngZu,m3h4x4(:,301),heltab2x16(:,:,329))
  call Hloop_A_Q(ntryL,G1H4(85),79,0,G2H4(177),n2h4(293))
  call Hloop_AZ_Q(ntryL,G1H16(88),wf4(:,4),G1H4(91),ngZu,m3h4x4(:,302),heltab2x16(:,:,330))
  call Hloop_A_Q(ntryL,G1H4(91),79,nMT,G2H4(180),n2h4(294))
  call Hloop_QZ_A(ntryL,G1H16(93),wf4(:,4),G1H4(3),ngZu,m3h4x4(:,303),heltab2x16(:,:,331))
  call Hloop_Q_A(ntryL,G1H4(3),79,0,G2H4(185),n2h4(295))
  call Hloop_QZ_A(ntryL,G1H16(98),wf4(:,4),G1H4(5),ngZu,m3h4x4(:,304),heltab2x16(:,:,332))
  call Hloop_Q_A(ntryL,G1H4(5),79,nMT,G2H4(188),n2h4(296))
  call Hloop_AZ_Q(ntryL,G1H16(103),wf4(:,4),G1H4(6),ngZd,m3h4x4(:,305),heltab2x16(:,:,333))
  call Hloop_A_Q(ntryL,G1H4(6),79,0,G2H4(23),n2h4(297))
  call Hloop_AZ_Q(ntryL,G1H16(108),wf4(:,4),G1H4(103),ngZd,m3h4x4(:,306),heltab2x16(:,:,334))
  call Hloop_A_Q(ntryL,G1H4(103),79,nMB,G2H4(45),n2h4(298))
  call Hloop_QZ_A(ntryL,G1H16(113),wf4(:,4),G1H4(8),ngZd,m3h4x4(:,307),heltab2x16(:,:,335))
  call Hloop_Q_A(ntryL,G1H4(8),79,0,G2H4(133),n2h4(299))
  call Hloop_QZ_A(ntryL,G1H16(118),wf4(:,4),G1H4(9),ngZd,m3h4x4(:,308),heltab2x16(:,:,336))
  call Hloop_Q_A(ntryL,G1H4(9),79,nMB,G2H4(141),n2h4(300))
  call Hloop_QZ_A(ntryL,G1H32(15),wf4(:,5),G1H8(77),ngZd,m3h4x8(:,37),heltab2x32(:,:,85))
  call Hloop_Q_A(ntryL,G1H8(77),90,nMB,G2H8(21),n2h8(85))
  call Hloop_QZ_A(ntryL,G1H32(21),wf4(:,4),G1H8(78),ngZd,m3h4x8(:,38),heltab2x32(:,:,86))
  call Hloop_Q_A(ntryL,G1H8(78),85,nMB,G2H8(23),n2h8(86))
  call Hloop_QS_A(ntryL,G1H32(1),wf16(:,3),G1H2(1),ngH,m3h16x2(:,31),heltab2x32(:,:,87))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(39),n2h2(111))
  call Hloop_QZ_A(ntryL,G1H32(11),wf16(:,73),G1H2(8),ngZd,m3h16x2(:,32),heltab2x32(:,:,88))
  call Hloop_Q_A(ntryL,G1H2(8),95,nMB,G2H2(34),n2h2(112))
  call Hloop_QZ_A(ntryL,G1H32(12),wf16(:,74),G1H2(12),ngZd,m3h16x2(:,33),heltab2x32(:,:,89))
  call Hloop_Q_A(ntryL,G1H2(12),95,nMB,G2H2(46),n2h2(113))
  call Hloop_QV_A(ntryL,G1H16(123),wf4(:,13),G1H4(106),m3h4x4(:,309),heltab2x16(:,:,337))
  call Hloop_Q_A(ntryL,G1H4(106),118,0,G2H4(37),n2h4(301))
  call Hloop_QV_A(ntryL,G1H16(128),wf4(:,13),G1H4(11),m3h4x4(:,310),heltab2x16(:,:,338))
  call Hloop_Q_A(ntryL,G1H4(11),118,nMT,G2H4(35),n2h4(302))
  call Hloop_AV_Q(ntryL,G1H16(133),wf4(:,13),G1H4(12),m3h4x4(:,311),heltab2x16(:,:,339))
  call Hloop_A_Q(ntryL,G1H4(12),118,0,G2H4(33),n2h4(303))
  call Hloop_AV_Q(ntryL,G1H16(138),wf4(:,13),G1H4(109),m3h4x4(:,312),heltab2x16(:,:,340))
  call Hloop_A_Q(ntryL,G1H4(109),118,nMT,G2H4(13),n2h4(304))
  call Hloop_QV_A(ntryL,G1H16(143),wf4(:,13),G1H4(110),m3h4x4(:,313),heltab2x16(:,:,341))
  call Hloop_Q_A(ntryL,G1H4(110),118,0,G2H4(9),n2h4(305))
  call Hloop_QV_A(ntryL,G1H16(148),wf4(:,13),G1H4(111),m3h4x4(:,314),heltab2x16(:,:,342))
  call Hloop_Q_A(ntryL,G1H4(111),118,nMB,G2H4(5),n2h4(306))
  call Hloop_AV_Q(ntryL,G1H16(153),wf4(:,13),G1H4(114),m3h4x4(:,315),heltab2x16(:,:,343))
  call Hloop_A_Q(ntryL,G1H4(114),118,0,G2H4(27),n2h4(307))
  call Hloop_AV_Q(ntryL,G1H16(158),wf4(:,13),G1H4(21),m3h4x4(:,316),heltab2x16(:,:,344))
  call Hloop_A_Q(ntryL,G1H4(21),118,nMB,G2H4(1),n2h4(308))
  call Hloop_AZ_Q(ntryL,G1H16(163),wf4(:,12),G1H4(22),ngZu,m3h4x4(:,317),heltab2x16(:,:,345))
  call Hloop_A_Q(ntryL,G1H4(22),79,0,G2H4(31),n2h4(309))
  call Hloop_AZ_Q(ntryL,G1H16(168),wf4(:,12),G1H4(117),ngZu,m3h4x4(:,318),heltab2x16(:,:,346))
  call Hloop_A_Q(ntryL,G1H4(117),79,nMT,G2H4(48),n2h4(310))
  call Hloop_QZ_A(ntryL,G1H16(173),wf4(:,12),G1H4(118),ngZu,m3h4x4(:,319),heltab2x16(:,:,347))
  call Hloop_Q_A(ntryL,G1H4(118),79,0,G2H4(28),n2h4(311))
  call Hloop_QZ_A(ntryL,G1H16(178),wf4(:,12),G1H4(119),ngZu,m3h4x4(:,320),heltab2x16(:,:,348))
  call Hloop_Q_A(ntryL,G1H4(119),79,nMT,G2H4(22),n2h4(312))
  call Hloop_AZ_Q(ntryL,G1H16(183),wf4(:,12),G1H4(122),ngZd,m3h4x4(:,321),heltab2x16(:,:,349))
  call Hloop_A_Q(ntryL,G1H4(122),79,0,G2H4(136),n2h4(313))
  call Hloop_AZ_Q(ntryL,G1H16(188),wf4(:,12),G1H4(32),ngZd,m3h4x4(:,322),heltab2x16(:,:,350))
  call Hloop_A_Q(ntryL,G1H4(32),79,nMB,G2H4(18),n2h4(314))
  call Hloop_QZ_A(ntryL,G1H16(193),wf4(:,12),G1H4(33),ngZd,m3h4x4(:,323),heltab2x16(:,:,351))
  call Hloop_Q_A(ntryL,G1H4(33),79,0,G2H4(6),n2h4(315))
  call Hloop_QZ_A(ntryL,G1H16(198),wf4(:,12),G1H4(125),ngZd,m3h4x4(:,324),heltab2x16(:,:,352))
  call Hloop_Q_A(ntryL,G1H4(125),79,nMB,G2H4(144),n2h4(316))
  call Hloop_AZ_Q(ntryL,G1H16(203),wf4(:,11),G1H4(126),ngZu,m3h4x4(:,325),heltab2x16(:,:,353))
  call Hloop_A_Q(ntryL,G1H4(126),79,0,G2H4(2),n2h4(317))
  call Hloop_AZ_Q(ntryL,G1H16(208),wf4(:,11),G1H4(127),ngZu,m3h4x4(:,326),heltab2x16(:,:,354))
  call Hloop_A_Q(ntryL,G1H4(127),79,nMT,G2H4(34),n2h4(318))
  call Hloop_QZ_A(ntryL,G1H16(213),wf4(:,11),G1H4(130),ngZu,m3h4x4(:,327),heltab2x16(:,:,355))
  call Hloop_Q_A(ntryL,G1H4(130),79,0,G2H4(16),n2h4(319))
  call Hloop_QZ_A(ntryL,G1H16(218),wf4(:,11),G1H4(43),ngZu,m3h4x4(:,328),heltab2x16(:,:,356))
  call Hloop_Q_A(ntryL,G1H4(43),79,nMT,G2H4(4),n2h4(320))
  call Hloop_AZ_Q(ntryL,G1H16(223),wf4(:,11),G1H4(44),ngZd,m3h4x4(:,329),heltab2x16(:,:,357))
  call Hloop_A_Q(ntryL,G1H4(44),79,0,G2H4(32),n2h4(321))
  call Hloop_AZ_Q(ntryL,G1H16(228),wf4(:,11),G1H4(133),ngZd,m3h4x4(:,330),heltab2x16(:,:,358))
  call Hloop_A_Q(ntryL,G1H4(133),79,nMB,G2H4(26),n2h4(322))
  call Hloop_QZ_A(ntryL,G1H16(233),wf4(:,11),G1H4(134),ngZd,m3h4x4(:,331),heltab2x16(:,:,359))
  call Hloop_Q_A(ntryL,G1H4(134),79,0,G2H4(14),n2h4(323))
  call Hloop_QZ_A(ntryL,G1H16(238),wf4(:,11),G1H4(135),ngZd,m3h4x4(:,332),heltab2x16(:,:,360))
  call Hloop_Q_A(ntryL,G1H4(135),79,nMB,G2H4(40),n2h4(324))
  call Hloop_QZ_A(ntryL,G1H32(8),wf4(:,12),G1H8(2),ngZd,m3h4x8(:,39),heltab2x32(:,:,90))
  call Hloop_Q_A(ntryL,G1H8(2),86,nMB,G2H8(17),n2h8(87))
  call Hloop_QZ_A(ntryL,G1H32(10),wf4(:,11),G1H8(5),ngZd,m3h4x8(:,40),heltab2x32(:,:,91))
  call Hloop_Q_A(ntryL,G1H8(5),89,nMB,G2H8(18),n2h8(88))
  call Hloop_QS_A(ntryL,G1H32(17),wf16(:,12),G1H2(13),ngH,m3h16x2(:,34),heltab2x32(:,:,92))
  call Hloop_Q_A(ntryL,G1H2(13),95,nMB,G2H2(50),n2h2(114))
  call Hloop_QZ_A(ntryL,G1H32(23),wf16(:,85),G1H2(23),ngZd,m3h16x2(:,35),heltab2x32(:,:,93))
  call Hloop_Q_A(ntryL,G1H2(23),95,nMB,G2H2(119),n2h2(115))
  call Hloop_QZ_A(ntryL,G1H32(24),wf16(:,86),G1H2(24),ngZd,m3h16x2(:,36),heltab2x32(:,:,94))
  call Hloop_Q_A(ntryL,G1H2(24),95,nMB,G2H2(116),n2h2(116))
  call Hloop_QZ_A(ntryL,G1H32(26),wf16(:,87),G1H2(29),ngZd,m3h16x2(:,37),heltab2x32(:,:,95))
  call Hloop_Q_A(ntryL,G1H2(29),95,nMB,G2H2(113),n2h2(117))
  call Hloop_QZ_A(ntryL,G1H32(27),wf16(:,88),G1H2(35),ngZd,m3h16x2(:,38),heltab2x32(:,:,96))
  call Hloop_Q_A(ntryL,G1H2(35),95,nMB,G2H2(110),n2h2(118))
  call Hloop_QZ_A(ntryL,G1H32(31),wf16(:,89),G1H2(40),ngZd,m3h16x2(:,39),heltab2x32(:,:,97))
  call Hloop_Q_A(ntryL,G1H2(40),95,nMB,G2H2(107),n2h2(119))
  call Hloop_QZ_A(ntryL,G1H32(32),wf16(:,90),G1H2(41),ngZd,m3h16x2(:,40),heltab2x32(:,:,98))
  call Hloop_Q_A(ntryL,G1H2(41),95,nMB,G2H2(104),n2h2(120))
  call Hloop_QS_A(ntryL,G1H64(1),wf16(:,3),G1H4(138),ngH,m3h16x4(:,21),heltab2x64(:,:,119))
  call Hloop_Q_A(ntryL,G1H4(138),79,nMT,G2H4(17),n2h4(325))
  call Hloop_AS_Q(ntryL,G1H64(2),wf16(:,3),G1H4(54),ngH,m3h16x4(:,22),heltab2x64(:,:,120))
  call Hloop_A_Q(ntryL,G1H4(54),79,nMT,G2H4(21),n2h4(326))
  call Hloop_QS_A(ntryL,G1H64(3),wf16(:,3),G1H4(55),ngH,m3h16x4(:,23),heltab2x64(:,:,121))
  call Hloop_Q_A(ntryL,G1H4(55),79,nMB,G2H4(41),n2h4(327))
  call Hloop_AS_Q(ntryL,G1H64(4),wf16(:,3),G1H4(141),ngH,m3h16x4(:,24),heltab2x64(:,:,122))
  call Hloop_A_Q(ntryL,G1H4(141),79,nMB,G2H4(44),n2h4(328))
  call Hloop_AZ_Q(ntryL,G1H32(7),wf4(:,5),G1H8(6),ngZd,m3h4x8(:,41),heltab2x32(:,:,99))
  call Hloop_A_Q(ntryL,G1H8(6),106,nMB,G2H8(19),n2h8(89))
  call Hloop_AZ_Q(ntryL,G1H32(6),wf4(:,4),G1H8(43),ngZd,m3h4x8(:,42),heltab2x32(:,:,100))
  call Hloop_A_Q(ntryL,G1H8(43),101,nMB,G2H8(20),n2h8(90))
  call Hloop_AS_Q(ntryL,G1H32(4),wf16(:,3),G1H2(51),ngH,m3h16x2(:,41),heltab2x32(:,:,101))
  call Hloop_A_Q(ntryL,G1H2(51),111,nMB,G2H2(101),n2h2(121))
  call Hloop_AQ_V(ntryL,G1H64(5),wf8(:,7),G1H8(28),m3h8x8(:,5),heltab2x64(:,:,123))
  call Hloop_VQ_A(ntryL,G1H64(6),wf8(:,7),G1H8(44),m3h8x8(:,6),heltab2x64(:,:,124))
  call Hloop_Q_A(ntryL,G1H8(44),85,nMB,G2H8(27),n2h8(91))
  call Hloop_AZ_Q(ntryL,G1H64(7),wf4(:,5),G1H16(46),ngZu,m3h4x16(:,77),heltab2x64(:,:,125))
  call Hloop_A_Q(ntryL,G1H16(46),74,0,G2H16(49),n2h16(133))
  call Hloop_AZ_Q(ntryL,G1H64(8),wf4(:,5),G1H16(47),ngZu,m3h4x16(:,78),heltab2x64(:,:,126))
  call Hloop_A_Q(ntryL,G1H16(47),74,nMT,G2H16(50),n2h16(134))
  call Hloop_QZ_A(ntryL,G1H64(9),wf4(:,5),G1H16(48),ngZu,m3h4x16(:,79),heltab2x64(:,:,127))
  call Hloop_Q_A(ntryL,G1H16(48),74,0,G2H16(51),n2h16(135))
  call Hloop_QZ_A(ntryL,G1H64(10),wf4(:,5),G1H16(3),ngZu,m3h4x16(:,80),heltab2x64(:,:,128))
  call Hloop_Q_A(ntryL,G1H16(3),74,nMT,G2H16(52),n2h16(136))
  call Hloop_AZ_Q(ntryL,G1H64(11),wf4(:,5),G1H16(15),ngZd,m3h4x16(:,81),heltab2x64(:,:,129))
  call Hloop_A_Q(ntryL,G1H16(15),74,0,G2H16(53),n2h16(137))
  call Hloop_AZ_Q(ntryL,G1H64(12),wf4(:,5),G1H16(21),ngZd,m3h4x16(:,82),heltab2x64(:,:,130))
  call Hloop_A_Q(ntryL,G1H16(21),74,nMB,G2H16(54),n2h16(138))
  call Hloop_QZ_A(ntryL,G1H64(13),wf4(:,5),G1H16(27),ngZd,m3h4x16(:,83),heltab2x64(:,:,131))
  call Hloop_Q_A(ntryL,G1H16(27),74,0,G2H16(55),n2h16(139))
  call Hloop_QZ_A(ntryL,G1H64(14),wf4(:,5),G1H16(33),ngZd,m3h4x16(:,84),heltab2x64(:,:,132))
  call Hloop_Q_A(ntryL,G1H16(33),74,nMB,G2H16(56),n2h16(140))
  call Hloop_AQ_V(ntryL,G1H64(15),wf32(:,4),G1H2(52),m3h32x2(:,1),heltab2x64(:,:,133))
  call Hloop_VQ_A(ntryL,G1H64(16),wf32(:,4),G1H2(56),m3h32x2(:,2),heltab2x64(:,:,134))
  call Hloop_Q_A(ntryL,G1H2(56),95,nMB,G2H2(98),n2h2(122))
  call Hloop_AQ_V(ntryL,G1H64(17),wf8(:,9),G1H8(75),m3h8x8(:,7),heltab2x64(:,:,135))
  call Hloop_VQ_A(ntryL,G1H64(18),wf8(:,9),G1H8(59),m3h8x8(:,8),heltab2x64(:,:,136))
  call Hloop_Q_A(ntryL,G1H8(59),90,nMB,G2H8(28),n2h8(92))
  call Hloop_AZ_Q(ntryL,G1H64(19),wf4(:,5),G1H16(45),ngZu,m3h4x16(:,85),heltab2x64(:,:,137))
  call Hloop_A_Q(ntryL,G1H16(45),74,0,G2H16(57),n2h16(141))
  call Hloop_AZ_Q(ntryL,G1H64(20),wf4(:,5),G1H16(6),ngZu,m3h4x16(:,86),heltab2x64(:,:,138))
  call Hloop_A_Q(ntryL,G1H16(6),74,nMT,G2H16(58),n2h16(142))
  call Hloop_QZ_A(ntryL,G1H64(21),wf4(:,5),G1H16(7),ngZu,m3h4x16(:,87),heltab2x64(:,:,139))
  call Hloop_Q_A(ntryL,G1H16(7),74,0,G2H16(59),n2h16(143))
  call Hloop_QZ_A(ntryL,G1H64(22),wf4(:,5),G1H16(8),ngZu,m3h4x16(:,88),heltab2x64(:,:,140))
  call Hloop_Q_A(ntryL,G1H16(8),74,nMT,G2H16(60),n2h16(144))
  call Hloop_AZ_Q(ntryL,G1H64(23),wf4(:,5),G1H16(11),ngZd,m3h4x16(:,89),heltab2x64(:,:,141))
  call Hloop_A_Q(ntryL,G1H16(11),74,0,G2H16(61),n2h16(145))
  call Hloop_AZ_Q(ntryL,G1H64(24),wf4(:,5),G1H16(12),ngZd,m3h4x16(:,90),heltab2x64(:,:,142))
  call Hloop_A_Q(ntryL,G1H16(12),74,nMB,G2H16(62),n2h16(146))
  call Hloop_QZ_A(ntryL,G1H64(25),wf4(:,5),G1H16(13),ngZd,m3h4x16(:,91),heltab2x64(:,:,143))
  call Hloop_Q_A(ntryL,G1H16(13),74,0,G2H16(63),n2h16(147))
  call Hloop_QZ_A(ntryL,G1H64(26),wf4(:,5),G1H16(14),ngZd,m3h4x16(:,92),heltab2x64(:,:,144))
  call Hloop_Q_A(ntryL,G1H16(14),74,nMB,G2H16(64),n2h16(148))
  call Hloop_AQ_V(ntryL,G1H64(27),ex5(:),G1H32(36),m3h2x32(:,19),heltab2x64(:,:,145))
  call Hloop_VQ_A(ntryL,G1H64(28),ex5(:),G1H32(37),m3h2x32(:,20),heltab2x64(:,:,146))
  call Hloop_Q_A(ntryL,G1H32(37),80,nMB,G2H32(1),n2h32(73))
  call Hloop_AZ_Q(ntryL,G1H64(29),wf4(:,4),G1H16(17),ngZu,m3h4x16(:,93),heltab2x64(:,:,147))
  call Hloop_A_Q(ntryL,G1H16(17),69,0,G2H16(9),n2h16(149))
  call Hloop_AZ_Q(ntryL,G1H64(30),wf4(:,4),G1H16(18),ngZu,m3h4x16(:,94),heltab2x64(:,:,148))
  call Hloop_A_Q(ntryL,G1H16(18),69,nMT,G2H16(10),n2h16(150))
  call Hloop_QZ_A(ntryL,G1H64(31),wf4(:,4),G1H16(19),ngZu,m3h4x16(:,95),heltab2x64(:,:,149))
  call Hloop_Q_A(ntryL,G1H16(19),69,0,G2H16(11),n2h16(151))
  call Hloop_QZ_A(ntryL,G1H64(32),wf4(:,4),G1H16(20),ngZu,m3h4x16(:,96),heltab2x64(:,:,150))
  call Hloop_Q_A(ntryL,G1H16(20),69,nMT,G2H16(12),n2h16(152))
  call Hloop_AZ_Q(ntryL,G1H64(33),wf4(:,4),G1H16(23),ngZd,m3h4x16(:,97),heltab2x64(:,:,151))
  call Hloop_A_Q(ntryL,G1H16(23),69,0,G2H16(1),n2h16(153))
  call Hloop_AZ_Q(ntryL,G1H64(34),wf4(:,4),G1H16(24),ngZd,m3h4x16(:,98),heltab2x64(:,:,152))
  call Hloop_A_Q(ntryL,G1H16(24),69,nMB,G2H16(2),n2h16(154))
  call Hloop_QZ_A(ntryL,G1H64(35),wf4(:,4),G1H16(25),ngZd,m3h4x16(:,99),heltab2x64(:,:,153))
  call Hloop_Q_A(ntryL,G1H16(25),69,0,G2H16(3),n2h16(155))
  call Hloop_QZ_A(ntryL,G1H64(36),wf4(:,4),G1H16(26),ngZd,m3h4x16(:,100),heltab2x64(:,:,154))
  call Hloop_Q_A(ntryL,G1H16(26),69,nMB,G2H16(4),n2h16(156))
  call Hloop_AQ_V(ntryL,G1H64(37),wf32(:,8),G1H2(63),m3h32x2(:,3),heltab2x64(:,:,155))
  call Hloop_VQ_A(ntryL,G1H64(38),wf32(:,8),G1H2(67),m3h32x2(:,4),heltab2x64(:,:,156))
  call Hloop_Q_A(ntryL,G1H2(67),95,nMB,G2H2(95),n2h2(123))
  call Hloop_AZ_Q(ntryL,G1H64(39),wf4(:,4),G1H16(29),ngZu,m3h4x16(:,101),heltab2x64(:,:,157))
  call Hloop_A_Q(ntryL,G1H16(29),69,0,G2H16(5),n2h16(157))
  call Hloop_AZ_Q(ntryL,G1H64(40),wf4(:,4),G1H16(1),ngZu,m3h4x16(:,102),heltab2x64(:,:,158))
  call Hloop_A_Q(ntryL,G1H16(1),69,nMT,G2H16(6),n2h16(158))
  call Hloop_QZ_A(ntryL,G1H64(41),wf4(:,4),G1H16(2),ngZu,m3h4x16(:,103),heltab2x64(:,:,159))
  call Hloop_Q_A(ntryL,G1H16(2),69,0,G2H16(7),n2h16(159))
  call Hloop_QZ_A(ntryL,G1H64(42),wf4(:,4),G1H16(4),ngZu,m3h4x16(:,104),heltab2x64(:,:,160))
  call Hloop_Q_A(ntryL,G1H16(4),69,nMT,G2H16(8),n2h16(160))
  call Hloop_AZ_Q(ntryL,G1H64(43),wf4(:,4),G1H16(49),ngZd,m3h4x16(:,105),heltab2x64(:,:,161))
  call Hloop_A_Q(ntryL,G1H16(49),69,0,G2H16(13),n2h16(161))
  call Hloop_AZ_Q(ntryL,G1H64(44),wf4(:,4),G1H16(50),ngZd,m3h4x16(:,106),heltab2x64(:,:,162))
  call Hloop_A_Q(ntryL,G1H16(50),69,nMB,G2H16(14),n2h16(162))
  call Hloop_QZ_A(ntryL,G1H64(45),wf4(:,4),G1H16(51),ngZd,m3h4x16(:,107),heltab2x64(:,:,163))
  call Hloop_Q_A(ntryL,G1H16(51),69,0,G2H16(15),n2h16(163))
  call Hloop_QZ_A(ntryL,G1H64(46),wf4(:,4),G1H16(52),ngZd,m3h4x16(:,108),heltab2x64(:,:,164))
  call Hloop_Q_A(ntryL,G1H16(52),69,nMB,G2H16(16),n2h16(164))
  call Hloop_AQ_V(ntryL,G1H64(47),ex5(:),G1H32(39),m3h2x32(:,21),heltab2x64(:,:,165))
  call Hloop_VQ_A(ntryL,G1H64(48),ex5(:),G1H32(40),m3h2x32(:,22),heltab2x64(:,:,166))
  call Hloop_Q_A(ntryL,G1H32(40),80,nMB,G2H32(2),n2h32(74))
  call Hloop_AQ_V(ntryL,G1H64(49),wf32(:,12),G1H2(68),m3h32x2(:,5),heltab2x64(:,:,167))
  call Hloop_VQ_A(ntryL,G1H64(50),wf32(:,12),G1H2(78),m3h32x2(:,6),heltab2x64(:,:,168))
  call Hloop_Q_A(ntryL,G1H2(78),95,nMB,G2H2(45),n2h2(124))
  call Hloop_AQ_V(ntryL,G1H64(51),ex5(:),G1H32(41),m3h2x32(:,23),heltab2x64(:,:,169))
  call Hloop_VQ_A(ntryL,G1H64(52),ex5(:),G1H32(42),m3h2x32(:,24),heltab2x64(:,:,170))
  call Hloop_Q_A(ntryL,G1H32(42),80,nMB,G2H32(3),n2h32(75))
  call Hloop_AZ_Q(ntryL,G1H64(53),wf16(:,73),G1H4(42),ngZu,m3h16x4(:,25),heltab2x64(:,:,171))
  call Hloop_A_Q(ntryL,G1H4(42),79,0,G2H4(65),n2h4(329))
  call Hloop_AZ_Q(ntryL,G1H64(54),wf16(:,73),G1H4(142),ngZu,m3h16x4(:,26),heltab2x64(:,:,172))
  call Hloop_A_Q(ntryL,G1H4(142),79,nMT,G2H4(68),n2h4(330))
  call Hloop_QZ_A(ntryL,G1H64(55),wf16(:,73),G1H4(145),ngZu,m3h16x4(:,27),heltab2x64(:,:,173))
  call Hloop_Q_A(ntryL,G1H4(145),79,0,G2H4(53),n2h4(331))
  call Hloop_QZ_A(ntryL,G1H64(56),wf16(:,73),G1H4(53),ngZu,m3h16x4(:,28),heltab2x64(:,:,174))
  call Hloop_Q_A(ntryL,G1H4(53),79,nMT,G2H4(56),n2h4(332))
  call Hloop_AZ_Q(ntryL,G1H64(57),wf16(:,73),G1H4(146),ngZd,m3h16x4(:,29),heltab2x64(:,:,175))
  call Hloop_A_Q(ntryL,G1H4(146),79,0,G2H4(73),n2h4(333))
  call Hloop_AZ_Q(ntryL,G1H64(58),wf16(:,73),G1H4(149),ngZd,m3h16x4(:,30),heltab2x64(:,:,176))
  call Hloop_A_Q(ntryL,G1H4(149),79,nMB,G2H4(76),n2h4(334))
  call Hloop_QZ_A(ntryL,G1H64(59),wf16(:,73),G1H4(46),ngZd,m3h16x4(:,31),heltab2x64(:,:,177))
  call Hloop_Q_A(ntryL,G1H4(46),79,0,G2H4(61),n2h4(335))
  call Hloop_QZ_A(ntryL,G1H64(60),wf16(:,73),G1H4(150),ngZd,m3h16x4(:,32),heltab2x64(:,:,178))
  call Hloop_Q_A(ntryL,G1H4(150),79,nMB,G2H4(64),n2h4(336))
  call Hloop_AZ_Q(ntryL,G1H64(61),wf16(:,74),G1H4(153),ngZu,m3h16x4(:,33),heltab2x64(:,:,179))
  call Hloop_A_Q(ntryL,G1H4(153),79,0,G2H4(69),n2h4(337))
  call Hloop_AZ_Q(ntryL,G1H64(62),wf16(:,74),G1H4(36),ngZu,m3h16x4(:,34),heltab2x64(:,:,180))
  call Hloop_A_Q(ntryL,G1H4(36),79,nMT,G2H4(72),n2h4(338))
  call Hloop_QZ_A(ntryL,G1H64(63),wf16(:,74),G1H4(154),ngZu,m3h16x4(:,35),heltab2x64(:,:,181))
  call Hloop_Q_A(ntryL,G1H4(154),79,0,G2H4(77),n2h4(339))
  call Hloop_QZ_A(ntryL,G1H64(64),wf16(:,74),G1H4(157),ngZu,m3h16x4(:,36),heltab2x64(:,:,182))
  call Hloop_Q_A(ntryL,G1H4(157),79,nMT,G2H4(80),n2h4(340))
  call Hloop_AZ_Q(ntryL,G1H64(65),wf16(:,74),G1H4(35),ngZd,m3h16x4(:,37),heltab2x64(:,:,183))
  call Hloop_A_Q(ntryL,G1H4(35),79,0,G2H4(97),n2h4(341))
  call Hloop_AZ_Q(ntryL,G1H64(66),wf16(:,74),G1H4(41),ngZd,m3h16x4(:,38),heltab2x64(:,:,184))
  call Hloop_A_Q(ntryL,G1H4(41),79,nMB,G2H4(100),n2h4(342))
  call Hloop_QZ_A(ntryL,G1H64(67),wf16(:,74),G1H4(160),ngZd,m3h16x4(:,39),heltab2x64(:,:,185))
  call Hloop_Q_A(ntryL,G1H4(160),79,0,G2H4(85),n2h4(343))
  call Hloop_QZ_A(ntryL,G1H64(68),wf16(:,74),G1H4(52),ngZd,m3h16x4(:,40),heltab2x64(:,:,186))
  call Hloop_Q_A(ntryL,G1H4(52),79,nMB,G2H4(88),n2h4(344))
  call Hloop_AZ_Q(ntryL,G1H32(13),wf16(:,73),G1H2(79),ngZd,m3h16x2(:,42),heltab2x32(:,:,102))
  call Hloop_A_Q(ntryL,G1H2(79),111,nMB,G2H2(40),n2h2(125))
  call Hloop_AZ_Q(ntryL,G1H32(14),wf16(:,74),G1H2(84),ngZd,m3h16x2(:,43),heltab2x32(:,:,103))
  call Hloop_A_Q(ntryL,G1H2(84),111,nMB,G2H2(35),n2h2(126))
  call Hloop_AQ_V(ntryL,G1H64(69),wf32(:,16),G1H2(17),m3h32x2(:,7),heltab2x64(:,:,187))
  call Hloop_VQ_A(ntryL,G1H64(70),wf32(:,16),G1H2(5),m3h32x2(:,8),heltab2x64(:,:,188))
  call Hloop_Q_A(ntryL,G1H2(5),95,nMB,G2H2(30),n2h2(127))
  call Hloop_AQ_V(ntryL,G1H64(71),ex5(:),G1H32(44),m3h2x32(:,25),heltab2x64(:,:,189))
  call Hloop_VQ_A(ntryL,G1H64(72),ex5(:),G1H32(45),m3h2x32(:,26),heltab2x64(:,:,190))
  call Hloop_Q_A(ntryL,G1H32(45),80,nMB,G2H32(4),n2h32(76))
  call Hloop_AQ_V(ntryL,G1H64(73),wf32(:,20),G1H2(16),m3h32x2(:,9),heltab2x64(:,:,191))
  call Hloop_VQ_A(ntryL,G1H64(74),wf32(:,20),G1H2(49),m3h32x2(:,10),heltab2x64(:,:,192))
  call Hloop_Q_A(ntryL,G1H2(49),95,nMB,G2H2(121),n2h2(128))
  call Hloop_AQ_V(ntryL,G1H64(75),ex5(:),G1H32(46),m3h2x32(:,27),heltab2x64(:,:,193))
  call Hloop_VQ_A(ntryL,G1H64(76),ex5(:),G1H32(47),m3h2x32(:,28),heltab2x64(:,:,194))
  call Hloop_Q_A(ntryL,G1H32(47),80,nMB,G2H32(5),n2h32(77))
  call Hloop_QS_A(ntryL,G1H64(77),wf16(:,12),G1H4(47),ngH,m3h16x4(:,41),heltab2x64(:,:,195))
  call Hloop_Q_A(ntryL,G1H4(47),79,nMT,G2H4(105),n2h4(345))
  call Hloop_AS_Q(ntryL,G1H64(78),wf16(:,12),G1H4(163),ngH,m3h16x4(:,42),heltab2x64(:,:,196))
  call Hloop_A_Q(ntryL,G1H4(163),79,nMT,G2H4(108),n2h4(346))
  call Hloop_QS_A(ntryL,G1H64(79),wf16(:,12),G1H4(61),ngH,m3h16x4(:,43),heltab2x64(:,:,197))
  call Hloop_Q_A(ntryL,G1H4(61),79,nMB,G2H4(93),n2h4(347))
  call Hloop_AS_Q(ntryL,G1H64(80),wf16(:,12),G1H4(164),ngH,m3h16x4(:,44),heltab2x64(:,:,198))
  call Hloop_A_Q(ntryL,G1H4(164),79,nMB,G2H4(96),n2h4(348))
  call Hloop_AZ_Q(ntryL,G1H32(18),wf4(:,12),G1H8(60),ngZd,m3h4x8(:,43),heltab2x32(:,:,104))
  call Hloop_A_Q(ntryL,G1H8(60),102,nMB,G2H8(1),n2h8(93))
  call Hloop_AZ_Q(ntryL,G1H32(20),wf4(:,11),G1H8(76),ngZd,m3h4x8(:,44),heltab2x32(:,:,105))
  call Hloop_A_Q(ntryL,G1H8(76),105,nMB,G2H8(2),n2h8(94))
  call Hloop_AS_Q(ntryL,G1H32(22),wf16(:,12),G1H2(60),ngH,m3h16x2(:,44),heltab2x32(:,:,106))
  call Hloop_A_Q(ntryL,G1H2(60),111,nMB,G2H2(118),n2h2(129))
  call Hloop_AQ_V(ntryL,G1H64(81),wf8(:,24),G1H8(3),m3h8x8(:,9),heltab2x64(:,:,199))
  call Hloop_VQ_A(ntryL,G1H64(82),wf8(:,24),G1H8(4),m3h8x8(:,10),heltab2x64(:,:,200))
  call Hloop_Q_A(ntryL,G1H8(4),89,nMB,G2H8(3),n2h8(95))
  call Hloop_AZ_Q(ntryL,G1H64(83),wf4(:,12),G1H16(54),ngZu,m3h4x16(:,109),heltab2x64(:,:,201))
  call Hloop_A_Q(ntryL,G1H16(54),70,0,G2H16(17),n2h16(165))
  call Hloop_AZ_Q(ntryL,G1H64(84),wf4(:,12),G1H16(55),ngZu,m3h4x16(:,110),heltab2x64(:,:,202))
  call Hloop_A_Q(ntryL,G1H16(55),70,nMT,G2H16(18),n2h16(166))
  call Hloop_QZ_A(ntryL,G1H64(85),wf4(:,12),G1H16(56),ngZu,m3h4x16(:,111),heltab2x64(:,:,203))
  call Hloop_Q_A(ntryL,G1H16(56),70,0,G2H16(19),n2h16(167))
  call Hloop_QZ_A(ntryL,G1H64(86),wf4(:,12),G1H16(57),ngZu,m3h4x16(:,112),heltab2x64(:,:,204))
  call Hloop_Q_A(ntryL,G1H16(57),70,nMT,G2H16(20),n2h16(168))
  call Hloop_AZ_Q(ntryL,G1H64(87),wf4(:,12),G1H16(59),ngZd,m3h4x16(:,113),heltab2x64(:,:,205))
  call Hloop_A_Q(ntryL,G1H16(59),70,0,G2H16(21),n2h16(169))
  call Hloop_AZ_Q(ntryL,G1H64(88),wf4(:,12),G1H16(60),ngZd,m3h4x16(:,114),heltab2x64(:,:,206))
  call Hloop_A_Q(ntryL,G1H16(60),70,nMB,G2H16(22),n2h16(170))
  call Hloop_QZ_A(ntryL,G1H64(89),wf4(:,12),G1H16(61),ngZd,m3h4x16(:,115),heltab2x64(:,:,207))
  call Hloop_Q_A(ntryL,G1H16(61),70,0,G2H16(23),n2h16(171))
  call Hloop_QZ_A(ntryL,G1H64(90),wf4(:,12),G1H16(62),ngZd,m3h4x16(:,116),heltab2x64(:,:,208))
  call Hloop_Q_A(ntryL,G1H16(62),70,nMB,G2H16(24),n2h16(172))
  call Hloop_AQ_V(ntryL,G1H64(91),wf32(:,24),G1H2(71),m3h32x2(:,11),heltab2x64(:,:,209))
  call Hloop_VQ_A(ntryL,G1H64(92),wf32(:,24),G1H2(3),m3h32x2(:,12),heltab2x64(:,:,210))
  call Hloop_Q_A(ntryL,G1H2(3),95,nMB,G2H2(115),n2h2(130))
  call Hloop_AQ_V(ntryL,G1H64(93),wf8(:,26),G1H8(9),m3h8x8(:,11),heltab2x64(:,:,211))
  call Hloop_VQ_A(ntryL,G1H64(94),wf8(:,26),G1H8(10),m3h8x8(:,12),heltab2x64(:,:,212))
  call Hloop_Q_A(ntryL,G1H8(10),86,nMB,G2H8(4),n2h8(96))
  call Hloop_AZ_Q(ntryL,G1H64(95),wf4(:,12),G1H16(64),ngZu,m3h4x16(:,117),heltab2x64(:,:,213))
  call Hloop_A_Q(ntryL,G1H16(64),70,0,G2H16(25),n2h16(173))
  call Hloop_AZ_Q(ntryL,G1H64(96),wf4(:,12),G1H16(65),ngZu,m3h4x16(:,118),heltab2x64(:,:,214))
  call Hloop_A_Q(ntryL,G1H16(65),70,nMT,G2H16(26),n2h16(174))
  call Hloop_QZ_A(ntryL,G1H64(97),wf4(:,12),G1H16(66),ngZu,m3h4x16(:,119),heltab2x64(:,:,215))
  call Hloop_Q_A(ntryL,G1H16(66),70,0,G2H16(27),n2h16(175))
  call Hloop_QZ_A(ntryL,G1H64(98),wf4(:,12),G1H16(67),ngZu,m3h4x16(:,120),heltab2x64(:,:,216))
  call Hloop_Q_A(ntryL,G1H16(67),70,nMT,G2H16(28),n2h16(176))
  call Hloop_AZ_Q(ntryL,G1H64(99),wf4(:,12),G1H16(69),ngZd,m3h4x16(:,121),heltab2x64(:,:,217))
  call Hloop_A_Q(ntryL,G1H16(69),70,0,G2H16(29),n2h16(177))
  call Hloop_AZ_Q(ntryL,G1H64(100),wf4(:,12),G1H16(70),ngZd,m3h4x16(:,122),heltab2x64(:,:,218))
  call Hloop_A_Q(ntryL,G1H16(70),70,nMB,G2H16(30),n2h16(178))
  call Hloop_QZ_A(ntryL,G1H64(101),wf4(:,12),G1H16(71),ngZd,m3h4x16(:,123),heltab2x64(:,:,219))
  call Hloop_Q_A(ntryL,G1H16(71),70,0,G2H16(31),n2h16(179))
  call Hloop_QZ_A(ntryL,G1H64(102),wf4(:,12),G1H16(72),ngZd,m3h4x16(:,124),heltab2x64(:,:,220))
  call Hloop_Q_A(ntryL,G1H16(72),70,nMB,G2H16(32),n2h16(180))
  call Hloop_AQ_V(ntryL,G1H64(103),ex5(:),G1H32(49),m3h2x32(:,29),heltab2x64(:,:,221))
  call Hloop_VQ_A(ntryL,G1H64(104),ex5(:),G1H32(50),m3h2x32(:,30),heltab2x64(:,:,222))
  call Hloop_Q_A(ntryL,G1H32(50),80,nMB,G2H32(6),n2h32(78))
  call Hloop_AZ_Q(ntryL,G1H64(105),wf4(:,11),G1H16(74),ngZu,m3h4x16(:,125),heltab2x64(:,:,223))
  call Hloop_A_Q(ntryL,G1H16(74),73,0,G2H16(33),n2h16(181))
  call Hloop_AZ_Q(ntryL,G1H64(106),wf4(:,11),G1H16(75),ngZu,m3h4x16(:,126),heltab2x64(:,:,224))
  call Hloop_A_Q(ntryL,G1H16(75),73,nMT,G2H16(34),n2h16(182))
  call Hloop_QZ_A(ntryL,G1H64(107),wf4(:,11),G1H16(76),ngZu,m3h4x16(:,127),heltab2x64(:,:,225))
  call Hloop_Q_A(ntryL,G1H16(76),73,0,G2H16(35),n2h16(183))
  call Hloop_QZ_A(ntryL,G1H64(108),wf4(:,11),G1H16(77),ngZu,m3h4x16(:,128),heltab2x64(:,:,226))
  call Hloop_Q_A(ntryL,G1H16(77),73,nMT,G2H16(36),n2h16(184))
  call Hloop_AZ_Q(ntryL,G1H64(109),wf4(:,11),G1H16(79),ngZd,m3h4x16(:,129),heltab2x64(:,:,227))
  call Hloop_A_Q(ntryL,G1H16(79),73,0,G2H16(37),n2h16(185))
  call Hloop_AZ_Q(ntryL,G1H64(110),wf4(:,11),G1H16(80),ngZd,m3h4x16(:,130),heltab2x64(:,:,228))
  call Hloop_A_Q(ntryL,G1H16(80),73,nMB,G2H16(38),n2h16(186))
  call Hloop_QZ_A(ntryL,G1H64(111),wf4(:,11),G1H16(81),ngZd,m3h4x16(:,131),heltab2x64(:,:,229))
  call Hloop_Q_A(ntryL,G1H16(81),73,0,G2H16(39),n2h16(187))
  call Hloop_QZ_A(ntryL,G1H64(112),wf4(:,11),G1H16(82),ngZd,m3h4x16(:,132),heltab2x64(:,:,230))
  call Hloop_Q_A(ntryL,G1H16(82),73,nMB,G2H16(40),n2h16(188))
  call Hloop_AQ_V(ntryL,G1H64(113),wf32(:,28),G1H2(58),m3h32x2(:,13),heltab2x64(:,:,231))
  call Hloop_VQ_A(ntryL,G1H64(114),wf32(:,28),G1H2(80),m3h32x2(:,14),heltab2x64(:,:,232))
  call Hloop_Q_A(ntryL,G1H2(80),95,nMB,G2H2(112),n2h2(131))
  call Hloop_AZ_Q(ntryL,G1H64(115),wf4(:,11),G1H16(84),ngZu,m3h4x16(:,133),heltab2x64(:,:,233))
  call Hloop_A_Q(ntryL,G1H16(84),73,0,G2H16(41),n2h16(189))
  call Hloop_AZ_Q(ntryL,G1H64(116),wf4(:,11),G1H16(85),ngZu,m3h4x16(:,134),heltab2x64(:,:,234))
  call Hloop_A_Q(ntryL,G1H16(85),73,nMT,G2H16(42),n2h16(190))
  call Hloop_QZ_A(ntryL,G1H64(117),wf4(:,11),G1H16(86),ngZu,m3h4x16(:,135),heltab2x64(:,:,235))
  call Hloop_Q_A(ntryL,G1H16(86),73,0,G2H16(43),n2h16(191))
  call Hloop_QZ_A(ntryL,G1H64(118),wf4(:,11),G1H16(87),ngZu,m3h4x16(:,136),heltab2x64(:,:,236))
  call Hloop_Q_A(ntryL,G1H16(87),73,nMT,G2H16(44),n2h16(192))
  call Hloop_AZ_Q(ntryL,G1H64(119),wf4(:,11),G1H16(89),ngZd,m3h4x16(:,137),heltab2x64(:,:,237))
  call Hloop_A_Q(ntryL,G1H16(89),73,0,G2H16(45),n2h16(193))
  call Hloop_AZ_Q(ntryL,G1H64(120),wf4(:,11),G1H16(90),ngZd,m3h4x16(:,138),heltab2x64(:,:,238))
  call Hloop_A_Q(ntryL,G1H16(90),73,nMB,G2H16(46),n2h16(194))
  call Hloop_QZ_A(ntryL,G1H64(121),wf4(:,11),G1H16(91),ngZd,m3h4x16(:,139),heltab2x64(:,:,239))
  call Hloop_Q_A(ntryL,G1H16(91),73,0,G2H16(47),n2h16(195))
  call Hloop_QZ_A(ntryL,G1H64(122),wf4(:,11),G1H16(92),ngZd,m3h4x16(:,140),heltab2x64(:,:,240))
  call Hloop_Q_A(ntryL,G1H16(92),73,nMB,G2H16(48),n2h16(196))
  call Hloop_AQ_V(ntryL,G1H64(123),ex5(:),G1H32(51),m3h2x32(:,31),heltab2x64(:,:,241))
  call Hloop_VQ_A(ntryL,G1H64(124),ex5(:),G1H32(52),m3h2x32(:,32),heltab2x64(:,:,242))
  call Hloop_Q_A(ntryL,G1H32(52),80,nMB,G2H32(7),n2h32(79))
  call Hloop_AQ_V(ntryL,G1H64(125),wf32(:,32),G1H2(15),m3h32x2(:,15),heltab2x64(:,:,243))
  call Hloop_VQ_A(ntryL,G1H64(126),wf32(:,32),G1H2(4),m3h32x2(:,16),heltab2x64(:,:,244))
  call Hloop_Q_A(ntryL,G1H2(4),95,nMB,G2H2(109),n2h2(132))
  call Hloop_AQ_V(ntryL,G1H64(127),ex5(:),G1H32(54),m3h2x32(:,33),heltab2x64(:,:,245))
  call Hloop_VQ_A(ntryL,G1H64(128),ex5(:),G1H32(55),m3h2x32(:,34),heltab2x64(:,:,246))
  call Hloop_Q_A(ntryL,G1H32(55),80,nMB,G2H32(8),n2h32(80))
  call Hloop_AZ_Q(ntryL,G1H64(129),wf16(:,85),G1H4(167),ngZu,m3h16x4(:,45),heltab2x64(:,:,247))
  call Hloop_A_Q(ntryL,G1H4(167),79,0,G2H4(101),n2h4(349))
  call Hloop_AZ_Q(ntryL,G1H64(130),wf16(:,85),G1H4(58),ngZu,m3h16x4(:,46),heltab2x64(:,:,248))
  call Hloop_A_Q(ntryL,G1H4(58),79,nMT,G2H4(104),n2h4(350))
  call Hloop_QZ_A(ntryL,G1H64(131),wf16(:,85),G1H4(168),ngZu,m3h16x4(:,47),heltab2x64(:,:,249))
  call Hloop_Q_A(ntryL,G1H4(168),79,0,G2H4(109),n2h4(351))
  call Hloop_QZ_A(ntryL,G1H64(132),wf16(:,85),G1H4(171),ngZu,m3h16x4(:,48),heltab2x64(:,:,250))
  call Hloop_Q_A(ntryL,G1H4(171),79,nMT,G2H4(112),n2h4(352))
  call Hloop_AZ_Q(ntryL,G1H64(133),wf16(:,85),G1H4(63),ngZd,m3h16x4(:,49),heltab2x64(:,:,251))
  call Hloop_A_Q(ntryL,G1H4(63),79,0,G2H4(113),n2h4(353))
  call Hloop_AZ_Q(ntryL,G1H64(134),wf16(:,85),G1H4(172),ngZd,m3h16x4(:,50),heltab2x64(:,:,252))
  call Hloop_A_Q(ntryL,G1H4(172),79,nMB,G2H4(116),n2h4(354))
  call Hloop_QZ_A(ntryL,G1H64(135),wf16(:,85),G1H4(175),ngZd,m3h16x4(:,51),heltab2x64(:,:,253))
  call Hloop_Q_A(ntryL,G1H4(175),79,0,G2H4(117),n2h4(355))
  call Hloop_QZ_A(ntryL,G1H64(136),wf16(:,85),G1H4(60),ngZd,m3h16x4(:,52),heltab2x64(:,:,254))
  call Hloop_Q_A(ntryL,G1H4(60),79,nMB,G2H4(120),n2h4(356))
  call Hloop_AZ_Q(ntryL,G1H64(137),wf16(:,86),G1H4(176),ngZu,m3h16x4(:,53),heltab2x64(:,:,255))
  call Hloop_A_Q(ntryL,G1H4(176),79,0,G2H4(121),n2h4(357))
  call Hloop_AZ_Q(ntryL,G1H64(138),wf16(:,86),G1H4(179),ngZu,m3h16x4(:,54),heltab2x64(:,:,256))
  call Hloop_A_Q(ntryL,G1H4(179),79,nMT,G2H4(124),n2h4(358))
  call Hloop_QZ_A(ntryL,G1H64(139),wf16(:,86),G1H4(62),ngZu,m3h16x4(:,55),heltab2x64(:,:,257))
  call Hloop_Q_A(ntryL,G1H4(62),79,0,G2H4(125),n2h4(359))
  call Hloop_QZ_A(ntryL,G1H64(140),wf16(:,86),G1H4(180),ngZu,m3h16x4(:,56),heltab2x64(:,:,258))
  call Hloop_Q_A(ntryL,G1H4(180),79,nMT,G2H4(128),n2h4(360))
  call Hloop_AZ_Q(ntryL,G1H64(141),wf16(:,86),G1H4(183),ngZd,m3h16x4(:,57),heltab2x64(:,:,259))
  call Hloop_A_Q(ntryL,G1H4(183),79,0,G2H4(129),n2h4(361))
  call Hloop_AZ_Q(ntryL,G1H64(142),wf16(:,86),G1H4(64),ngZd,m3h16x4(:,58),heltab2x64(:,:,260))
  call Hloop_A_Q(ntryL,G1H4(64),79,nMB,G2H4(132),n2h4(362))
  call Hloop_QZ_A(ntryL,G1H64(143),wf16(:,86),G1H4(184),ngZd,m3h16x4(:,59),heltab2x64(:,:,261))
  call Hloop_Q_A(ntryL,G1H4(184),79,0,G2H4(137),n2h4(363))
  call Hloop_QZ_A(ntryL,G1H64(144),wf16(:,86),G1H4(187),ngZd,m3h16x4(:,60),heltab2x64(:,:,262))
  call Hloop_Q_A(ntryL,G1H4(187),79,nMB,G2H4(140),n2h4(364))
  call Hloop_AZ_Q(ntryL,G1H32(9),wf16(:,85),G1H2(54),ngZd,m3h16x2(:,45),heltab2x32(:,:,107))
  call Hloop_A_Q(ntryL,G1H2(54),111,nMB,G2H2(106),n2h2(133))
  call Hloop_AZ_Q(ntryL,G1H32(25),wf16(:,86),G1H2(14),ngZd,m3h16x2(:,46),heltab2x32(:,:,108))
  call Hloop_A_Q(ntryL,G1H2(14),111,nMB,G2H2(103),n2h2(134))
  call Hloop_AQ_V(ntryL,G1H64(145),wf32(:,36),G1H2(81),m3h32x2(:,17),heltab2x64(:,:,263))
  call Hloop_VQ_A(ntryL,G1H64(146),wf32(:,36),G1H2(70),m3h32x2(:,18),heltab2x64(:,:,264))
  call Hloop_Q_A(ntryL,G1H2(70),95,nMB,G2H2(100),n2h2(135))
  call Hloop_AQ_V(ntryL,G1H64(147),ex5(:),G1H32(56),m3h2x32(:,35),heltab2x64(:,:,265))
  call Hloop_VQ_A(ntryL,G1H64(148),ex5(:),G1H32(57),m3h2x32(:,36),heltab2x64(:,:,266))
  call Hloop_Q_A(ntryL,G1H32(57),80,nMB,G2H32(9),n2h32(81))
  call Hloop_AQ_V(ntryL,G1H64(149),wf32(:,40),G1H2(76),m3h32x2(:,19),heltab2x64(:,:,267))
  call Hloop_VQ_A(ntryL,G1H64(150),wf32(:,40),G1H2(43),m3h32x2(:,20),heltab2x64(:,:,268))
  call Hloop_Q_A(ntryL,G1H2(43),95,nMB,G2H2(97),n2h2(136))
  call Hloop_AQ_V(ntryL,G1H64(151),ex5(:),G1H32(59),m3h2x32(:,37),heltab2x64(:,:,269))
  call Hloop_VQ_A(ntryL,G1H64(152),ex5(:),G1H32(60),m3h2x32(:,38),heltab2x64(:,:,270))
  call Hloop_Q_A(ntryL,G1H32(60),80,nMB,G2H32(10),n2h32(82))
  call Hloop_AZ_Q(ntryL,G1H64(153),wf16(:,87),G1H4(69),ngZu,m3h16x4(:,61),heltab2x64(:,:,271))
  call Hloop_A_Q(ntryL,G1H4(69),79,0,G2H4(161),n2h4(365))
  call Hloop_AZ_Q(ntryL,G1H64(154),wf16(:,87),G1H4(188),ngZu,m3h16x4(:,62),heltab2x64(:,:,272))
  call Hloop_A_Q(ntryL,G1H4(188),79,nMT,G2H4(164),n2h4(366))
  call Hloop_QZ_A(ntryL,G1H64(155),wf16(:,87),G1H4(191),ngZu,m3h16x4(:,63),heltab2x64(:,:,273))
  call Hloop_Q_A(ntryL,G1H4(191),79,0,G2H4(149),n2h4(367))
  call Hloop_QZ_A(ntryL,G1H64(156),wf16(:,87),G1H4(66),ngZu,m3h16x4(:,64),heltab2x64(:,:,274))
  call Hloop_Q_A(ntryL,G1H4(66),79,nMT,G2H4(152),n2h4(368))
  call Hloop_AZ_Q(ntryL,G1H64(157),wf16(:,87),G1H4(192),ngZd,m3h16x4(:,65),heltab2x64(:,:,275))
  call Hloop_A_Q(ntryL,G1H4(192),79,0,G2H4(169),n2h4(369))
  call Hloop_AZ_Q(ntryL,G1H64(158),wf16(:,87),G1H4(195),ngZd,m3h16x4(:,66),heltab2x64(:,:,276))
  call Hloop_A_Q(ntryL,G1H4(195),79,nMB,G2H4(172),n2h4(370))
  call Hloop_QZ_A(ntryL,G1H64(159),wf16(:,87),G1H4(71),ngZd,m3h16x4(:,67),heltab2x64(:,:,277))
  call Hloop_Q_A(ntryL,G1H4(71),79,0,G2H4(157),n2h4(371))
  call Hloop_QZ_A(ntryL,G1H64(160),wf16(:,87),G1H4(196),ngZd,m3h16x4(:,68),heltab2x64(:,:,278))
  call Hloop_Q_A(ntryL,G1H4(196),79,nMB,G2H4(160),n2h4(372))
  call Hloop_AZ_Q(ntryL,G1H64(161),wf16(:,88),G1H4(199),ngZu,m3h16x4(:,69),heltab2x64(:,:,279))
  call Hloop_A_Q(ntryL,G1H4(199),79,0,G2H4(165),n2h4(373))
  call Hloop_AZ_Q(ntryL,G1H64(162),wf16(:,88),G1H4(68),ngZu,m3h16x4(:,70),heltab2x64(:,:,280))
  call Hloop_A_Q(ntryL,G1H4(68),79,nMT,G2H4(168),n2h4(374))
  call Hloop_QZ_A(ntryL,G1H64(163),wf16(:,88),G1H4(200),ngZu,m3h16x4(:,71),heltab2x64(:,:,281))
  call Hloop_Q_A(ntryL,G1H4(200),79,0,G2H4(173),n2h4(375))
  call Hloop_QZ_A(ntryL,G1H64(164),wf16(:,88),G1H4(203),ngZu,m3h16x4(:,72),heltab2x64(:,:,282))
  call Hloop_Q_A(ntryL,G1H4(203),79,nMT,G2H4(176),n2h4(376))
  call Hloop_AZ_Q(ntryL,G1H64(165),wf16(:,88),G1H4(70),ngZd,m3h16x4(:,73),heltab2x64(:,:,283))
  call Hloop_A_Q(ntryL,G1H4(70),79,0,G2H4(193),n2h4(377))
  call Hloop_AZ_Q(ntryL,G1H64(166),wf16(:,88),G1H4(204),ngZd,m3h16x4(:,74),heltab2x64(:,:,284))
  call Hloop_A_Q(ntryL,G1H4(204),79,nMB,G2H4(196),n2h4(378))
  call Hloop_QZ_A(ntryL,G1H64(167),wf16(:,88),G1H4(207),ngZd,m3h16x4(:,75),heltab2x64(:,:,285))
  call Hloop_Q_A(ntryL,G1H4(207),79,0,G2H4(181),n2h4(379))
  call Hloop_QZ_A(ntryL,G1H64(168),wf16(:,88),G1H4(72),ngZd,m3h16x4(:,76),heltab2x64(:,:,286))
  call Hloop_Q_A(ntryL,G1H4(72),79,nMB,G2H4(184),n2h4(380))
  call Hloop_AZ_Q(ntryL,G1H32(29),wf16(:,87),G1H2(32),ngZd,m3h16x2(:,47),heltab2x32(:,:,109))
  call Hloop_A_Q(ntryL,G1H2(32),111,nMB,G2H2(48),n2h2(137))
  call Hloop_AZ_Q(ntryL,G1H32(30),wf16(:,88),G1H2(69),ngZd,m3h16x2(:,48),heltab2x32(:,:,110))
  call Hloop_A_Q(ntryL,G1H2(69),111,nMB,G2H2(47),n2h2(138))
  call Hloop_AQ_V(ntryL,G1H64(169),wf32(:,44),G1H2(9),m3h32x2(:,21),heltab2x64(:,:,287))
  call Hloop_VQ_A(ntryL,G1H64(170),wf32(:,44),G1H2(65),m3h32x2(:,22),heltab2x64(:,:,288))
  call Hloop_Q_A(ntryL,G1H2(65),95,nMB,G2H2(43),n2h2(139))
  call Hloop_AQ_V(ntryL,G1H64(171),ex5(:),G1H32(61),m3h2x32(:,39),heltab2x64(:,:,289))
  call Hloop_VQ_A(ntryL,G1H64(172),ex5(:),G1H32(62),m3h2x32(:,40),heltab2x64(:,:,290))
  call Hloop_Q_A(ntryL,G1H32(62),80,nMB,G2H32(11),n2h32(83))
  call Hloop_AQ_V(ntryL,G1H64(173),wf32(:,48),G1H2(22),m3h32x2(:,23),heltab2x64(:,:,291))
  call Hloop_VQ_A(ntryL,G1H64(174),wf32(:,48),G1H2(31),m3h32x2(:,24),heltab2x64(:,:,292))
  call Hloop_Q_A(ntryL,G1H2(31),95,nMB,G2H2(42),n2h2(140))
  call Hloop_AQ_V(ntryL,G1H64(175),ex5(:),G1H32(64),m3h2x32(:,41),heltab2x64(:,:,293))
  call Hloop_VQ_A(ntryL,G1H64(176),ex5(:),G1H32(65),m3h2x32(:,42),heltab2x64(:,:,294))
  call Hloop_Q_A(ntryL,G1H32(65),80,nMB,G2H32(12),n2h32(84))
  call Hloop_AZ_Q(ntryL,G1H64(177),wf16(:,89),G1H4(208),ngZu,m3h16x4(:,77),heltab2x64(:,:,295))
  call Hloop_A_Q(ntryL,G1H4(208),79,0,G2H4(201),n2h4(381))
  call Hloop_AZ_Q(ntryL,G1H64(178),wf16(:,89),G1H4(211),ngZu,m3h16x4(:,78),heltab2x64(:,:,296))
  call Hloop_A_Q(ntryL,G1H4(211),79,nMT,G2H4(204),n2h4(382))
  call Hloop_QZ_A(ntryL,G1H64(179),wf16(:,89),G1H4(75),ngZu,m3h16x4(:,79),heltab2x64(:,:,297))
  call Hloop_Q_A(ntryL,G1H4(75),79,0,G2H4(189),n2h4(383))
  call Hloop_QZ_A(ntryL,G1H64(180),wf16(:,89),G1H4(212),ngZu,m3h16x4(:,80),heltab2x64(:,:,298))
  call Hloop_Q_A(ntryL,G1H4(212),79,nMT,G2H4(192),n2h4(384))
  call Hloop_AZ_Q(ntryL,G1H64(181),wf16(:,89),G1H4(215),ngZd,m3h16x4(:,81),heltab2x64(:,:,299))
  call Hloop_A_Q(ntryL,G1H4(215),79,0,G2H4(197),n2h4(385))
  call Hloop_AZ_Q(ntryL,G1H64(182),wf16(:,89),G1H4(76),ngZd,m3h16x4(:,82),heltab2x64(:,:,300))
  call Hloop_A_Q(ntryL,G1H4(76),79,nMB,G2H4(200),n2h4(386))
  call Hloop_QZ_A(ntryL,G1H64(183),wf16(:,89),G1H4(216),ngZd,m3h16x4(:,83),heltab2x64(:,:,301))
  call Hloop_Q_A(ntryL,G1H4(216),79,0,G2H4(205),n2h4(387))
  call Hloop_QZ_A(ntryL,G1H64(184),wf16(:,89),G1H4(219),ngZd,m3h16x4(:,84),heltab2x64(:,:,302))
  call Hloop_Q_A(ntryL,G1H4(219),79,nMB,G2H4(208),n2h4(388))
  call Hloop_AZ_Q(ntryL,G1H64(185),wf16(:,90),G1H4(77),ngZu,m3h16x4(:,85),heltab2x64(:,:,303))
  call Hloop_A_Q(ntryL,G1H4(77),79,0,G2H4(209),n2h4(389))
  call Hloop_AZ_Q(ntryL,G1H64(186),wf16(:,90),G1H4(220),ngZu,m3h16x4(:,86),heltab2x64(:,:,304))
  call Hloop_A_Q(ntryL,G1H4(220),79,nMT,G2H4(210),n2h4(390))
  call Hloop_QZ_A(ntryL,G1H64(187),wf16(:,90),G1H4(223),ngZu,m3h16x4(:,87),heltab2x64(:,:,305))
  call Hloop_Q_A(ntryL,G1H4(223),79,0,G2H4(211),n2h4(391))
  call Hloop_QZ_A(ntryL,G1H64(188),wf16(:,90),G1H4(78),ngZu,m3h16x4(:,88),heltab2x64(:,:,306))
  call Hloop_Q_A(ntryL,G1H4(78),79,nMT,G2H4(212),n2h4(392))
  call Hloop_AZ_Q(ntryL,G1H64(189),wf16(:,90),G1H4(224),ngZd,m3h16x4(:,89),heltab2x64(:,:,307))
  call Hloop_A_Q(ntryL,G1H4(224),79,0,G2H4(213),n2h4(393))
  call Hloop_AZ_Q(ntryL,G1H64(190),wf16(:,90),G1H4(227),ngZd,m3h16x4(:,90),heltab2x64(:,:,308))
  call Hloop_A_Q(ntryL,G1H4(227),79,nMB,G2H4(214),n2h4(394))
  call Hloop_QZ_A(ntryL,G1H64(191),wf16(:,90),G1H4(79),ngZd,m3h16x4(:,91),heltab2x64(:,:,309))
  call Hloop_Q_A(ntryL,G1H4(79),79,0,G2H4(215),n2h4(395))
  call Hloop_QZ_A(ntryL,G1H64(192),wf16(:,90),G1H4(80),ngZd,m3h16x4(:,92),heltab2x64(:,:,310))
  call Hloop_Q_A(ntryL,G1H4(80),79,nMB,G2H4(216),n2h4(396))
  call Hloop_AZ_Q(ntryL,G1H32(34),wf16(:,89),G1H2(87),ngZd,m3h16x2(:,49),heltab2x32(:,:,111))
  call Hloop_A_Q(ntryL,G1H2(87),111,nMB,G2H2(38),n2h2(141))
  call Hloop_AZ_Q(ntryL,G1H32(35),wf16(:,90),G1H2(90),ngZd,m3h16x2(:,50),heltab2x32(:,:,112))
  call Hloop_A_Q(ntryL,G1H2(90),111,nMB,G2H2(37),n2h2(142))
  call Hloop_AQ_V(ntryL,G1H64(193),wf32(:,52),G1H2(42),m3h32x2(:,25),heltab2x64(:,:,311))
  call Hloop_VQ_A(ntryL,G1H64(194),wf32(:,52),G1H2(44),m3h32x2(:,26),heltab2x64(:,:,312))
  call Hloop_Q_A(ntryL,G1H2(44),95,nMB,G2H2(33),n2h2(143))
  call Hloop_AQ_V(ntryL,G1H64(195),ex5(:),G1H32(66),m3h2x32(:,43),heltab2x64(:,:,313))
  call Hloop_VQ_A(ntryL,G1H64(196),ex5(:),G1H32(67),m3h2x32(:,44),heltab2x64(:,:,314))
  call Hloop_Q_A(ntryL,G1H32(67),80,nMB,G2H32(13),n2h32(85))
  call Hloop_AQ_V(ntryL,G1H64(197),wf32(:,56),G1H2(93),m3h32x2(:,27),heltab2x64(:,:,315))
  call Hloop_VQ_A(ntryL,G1H64(198),wf32(:,56),G1H2(53),m3h32x2(:,28),heltab2x64(:,:,316))
  call Hloop_Q_A(ntryL,G1H2(53),95,nMB,G2H2(32),n2h2(144))
  call Hloop_AQ_V(ntryL,G1H64(199),ex5(:),G1H32(69),m3h2x32(:,45),heltab2x64(:,:,317))
  call Hloop_VQ_A(ntryL,G1H64(200),ex5(:),G1H32(70),m3h2x32(:,46),heltab2x64(:,:,318))
  call Hloop_Q_A(ntryL,G1H32(70),80,nMB,G2H32(14),n2h32(86))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(104),[G2H2(107),G2H2(110),G2H2(113),G2H2(116),G2H2(119) &
    ,G2H2(50),G2H2(46),G2H2(34),G2H2(39),G2H2(81),G2H2(78),G2H2(63),G2H2(60),G2H2(22),G2H2(16),G2H2(10),G2H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G2H2(33),G2H2(42),G2H2(43),G2H2(97),G2H2(100) &
    ,G2H2(109),G2H2(112),G2H2(115),G2H2(121),G2H2(30),G2H2(45),G2H2(95),G2H2(98),G2H2(123),G2H2(120),G2H2(117),G2H2(114),G2H2(111) &
    ,G2H2(108),G2H2(105),G2H2(102),G2H2(99),G2H2(96),G2H2(93),G2H2(90),G2H2(75),G2H2(72),G2H2(24),G2H2(18),G2H2(12),G2H2(6)])
call ol_merge_last(G1H4(18), G1H4(18)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(110),[G1H4(18)])
call HGT_OLR(G2H4(110),1,1,4)
call HGT_invQ_OLR(G2H4(110),2,5,4)
call HGT_OLR(G2H4(110),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(110),[G1H4(93)])
call ol_merge_last(G1H4(29), G1H4(29)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(78),[G1H4(29)])
call HGT_OLR(G2H4(78),1,1,4)
call HGT_invQ_OLR(G2H4(78),2,5,4)
call HGT_OLR(G2H4(78),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(78),[G1H4(65)])
call ol_merge_last(G1H4(40), G1H4(40)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(102),[G1H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(37),[G2H2(38),G2H2(47),G2H2(48),G2H2(103),G2H2(106) &
    ,G2H2(118),G2H2(35),G2H2(40),G2H2(101),G2H2(87),G2H2(84),G2H2(69),G2H2(66)])
call ol_merge_last(G1H4(51), G1H4(51)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(70),[G1H4(51)])
call HGT_w2_OLR(G1H4(13),1,1,4)
call HGT_w2_invQ_OLR(G1H4(13),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(13),[G1H4(67)])
call HGT_w2_OLR(G1H4(14),1,1,4)
call HGT_w2_invQ_OLR(G1H4(14),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(14),[G1H4(2)])
call ol_merge_last(G1H4(19), G1H4(19)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(206),[G1H4(19)])
call HGT_OLR(G2H4(206),1,1,4)
call HGT_invQ_OLR(G2H4(206),2,5,4)
call HGT_OLR(G2H4(206),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(206),[G1H4(104)])
call ol_merge_last(G1H4(20), G1H4(20)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(174),[G1H4(20)])
call HGT_OLR(G2H4(174),1,1,4)
call HGT_invQ_OLR(G2H4(174),2,5,4)
call HGT_OLR(G2H4(174),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(174),[G1H4(101)])
call ol_merge_last(G1H4(24), G1H4(24)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(198),[G1H4(24)])
call ol_merge_last(G1H4(25), G1H4(25)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(166),[G1H4(25)])
call HGT_w2_OLR(G1H4(30),1,1,4)
call HGT_w2_invQ_OLR(G1H4(30),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(30),[G1H4(102)])
call HGT_w2_OLR(G1H4(31),1,1,4)
call HGT_w2_invQ_OLR(G1H4(31),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(31),[G1H4(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(19),[G2H4(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(23),[G2H4(177),G1H4(185)])
call HGT_OLR(G2H4(19),1,1,4)
call HGT_invQ_OLR(G2H4(19),2,5,4)
call HGT_OLR(G2H4(19),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(19),[G2H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(36),[G1H4(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(180),[G1H4(189)])
call HGT_OLR(G2H4(12),1,1,4)
call HGT_invQ_OLR(G2H4(12),2,5,4)
call HGT_OLR(G2H4(12),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G2H4(180)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G1H4(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(42),[G2H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(133),[G2H4(185),G1H4(193)])
call HGT_OLR(G2H4(42),1,1,4)
call HGT_invQ_OLR(G2H4(42),2,5,4)
call HGT_OLR(G2H4(42),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(42),[G2H4(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(30),[G1H4(148)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(188),[G1H4(197)])
call HGT_OLR(G2H4(10),1,1,4)
call HGT_invQ_OLR(G2H4(10),2,5,4)
call HGT_OLR(G2H4(10),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(10),[G2H4(188)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(39),[G1H4(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(20),[G1H4(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(45),[G1H4(201)])
call HGT_OLR(G2H4(24),1,1,4)
call HGT_invQ_OLR(G2H4(24),2,5,4)
call HGT_OLR(G2H4(24),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(24),[G2H4(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(25),[G1H4(113),G1H4(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(43),[G1H4(159)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(141),[G1H4(205)])
call HGT_OLR(G2H4(46),1,1,4)
call HGT_invQ_OLR(G2H4(46),2,5,4)
call HGT_OLR(G2H4(46),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(46),[G2H4(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(47),[G1H4(121),G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(213),[G2H4(209),G2H4(197),G2H4(201),G2H4(193),G2H4(165) &
    ,G2H4(169),G2H4(161),G2H4(129),G2H4(121),G2H4(113),G2H4(101),G2H4(97),G2H4(69),G2H4(73),G2H4(65),G2H4(195),G2H4(179),G2H4(163) &
    ,G2H4(147),G2H4(99),G2H4(83),G2H4(67),G2H4(51),G1H4(256),G1H4(232),G1H4(186),G1H4(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(210),[G2H4(204),G2H4(168),G2H4(164),G2H4(124),G2H4(104) &
    ,G2H4(108),G2H4(72),G2H4(68),G2H4(21),G2H4(183),G2H4(151),G2H4(87),G2H4(55),G1H4(260),G1H4(236),G1H4(190),G1H4(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(215),[G2H4(211),G2H4(205),G2H4(189),G2H4(181),G2H4(173) &
    ,G2H4(157),G2H4(149),G2H4(137),G2H4(125),G2H4(117),G2H4(109),G2H4(85),G2H4(77),G2H4(61),G2H4(53),G2H4(203),G2H4(187),G2H4(171) &
    ,G2H4(155),G2H4(107),G2H4(91),G2H4(75),G2H4(59),G1H4(264),G1H4(240),G1H4(194),G1H4(170)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(212),[G2H4(192),G2H4(176),G2H4(152),G2H4(128),G2H4(112) &
    ,G2H4(105),G2H4(80),G2H4(56),G2H4(17),G2H4(191),G2H4(159),G2H4(95),G2H4(63),G1H4(268),G1H4(244),G1H4(198),G1H4(174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(214),[G2H4(200),G2H4(196),G2H4(172),G2H4(132),G2H4(116) &
    ,G2H4(96),G2H4(100),G2H4(76),G2H4(44),G2H4(199),G2H4(167),G2H4(103),G2H4(71),G1H4(272),G1H4(248),G1H4(202),G1H4(178)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(216),[G2H4(208),G2H4(184),G2H4(160),G2H4(140),G2H4(120) &
    ,G2H4(93),G2H4(88),G2H4(64),G2H4(41),G2H4(207),G2H4(175),G2H4(111),G2H4(79),G1H4(276),G1H4(252),G1H4(206),G1H4(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(120),[G1H4(115)])
call HGT_w2_OLR(G1H4(73),1,1,4)
call HGT_w2_invQ_OLR(G1H4(73),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(73),[G1H4(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(28),[G2H8(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(27),[G2H8(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(130),[G2H4(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G2H4(28),G1H4(239)])
call HGT_OLR(G2H4(130),1,1,4)
call HGT_invQ_OLR(G2H4(130),2,5,4)
call HGT_OLR(G2H4(130),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(130),[G2H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(115),[G1H4(210)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(22),[G1H4(243)])
call HGT_OLR(G2H4(118),1,1,4)
call HGT_invQ_OLR(G2H4(118),2,5,4)
call HGT_OLR(G2H4(118),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(118),[G2H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(119),[G1H4(214)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(138),[G2H4(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(136),[G2H4(31),G1H4(231)])
call HGT_OLR(G2H4(138),1,1,4)
call HGT_invQ_OLR(G2H4(138),2,5,4)
call HGT_OLR(G2H4(138),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(138),[G2H4(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(123),[G1H4(218)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(48),[G1H4(235)])
call HGT_OLR(G2H4(126),1,1,4)
call HGT_invQ_OLR(G2H4(126),2,5,4)
call HGT_OLR(G2H4(126),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(126),[G2H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(127),[G1H4(222)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(131),[G1H4(226)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(144),[G1H4(251)])
call HGT_OLR(G2H4(134),1,1,4)
call HGT_invQ_OLR(G2H4(134),2,5,4)
call HGT_OLR(G2H4(134),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(134),[G2H4(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(135),[G1H4(129),G1H4(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(139),[G1H4(229)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(18),[G1H4(247)])
call HGT_OLR(G2H4(142),1,1,4)
call HGT_invQ_OLR(G2H4(142),2,5,4)
call HGT_OLR(G2H4(142),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(142),[G2H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(143),[G1H4(137),G1H4(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(4),[G2H8(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(128),[G1H4(123)])
call HGT_w2_OLR(G1H4(100),1,1,4)
call HGT_w2_invQ_OLR(G1H4(100),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(100),[G1H4(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(3),[G2H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(25),[G1H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(26),[G1H2(62),G1H2(46),G1H2(7),G1H2(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(47),[G1H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(38),[G1H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(93),[G1H2(42),G1H2(22),G1H2(9),G1H2(76),G1H2(81),G1H2(15) &
    ,G1H2(58),G1H2(71),G1H2(16),G1H2(17),G1H2(68),G1H2(63),G1H2(52),G1H2(20),G1H2(6),G1H2(74),G1H2(34),G1H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(89),[G1H2(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(92),[G1H2(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(48),[G1H2(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(66),[G1H2(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(10),[G1H2(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(64),[G1H2(33),G1H2(11),G1H2(21),G1H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(52),[G1H4(108),G1H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(91),[G1H2(36),G1H2(37),G1H2(59),G1H2(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(60),[G1H4(116),G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(5),[G1H4(124),G1H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1),[G1H4(132),G1H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(112),[G1H4(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(136),[G1H4(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(75),[G1H8(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(28),[G1H8(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(9),[G1H8(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(3),[G1H8(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(3),[G1H4(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G1H4(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G1H4(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(15),[G1H4(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(49),[G1H4(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(57),[G1H4(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(145),[G2H4(81),G1H4(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(84),[G1H4(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(153),[G2H4(89),G1H4(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(92),[G1H4(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(148),[G1H4(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(156),[G1H4(181)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(37),[G1H4(209)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(35),[G1H4(213)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(33),[G1H4(217)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G1H4(221)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G1H4(225)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(27),[G1H4(228)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(32),[G2H4(2),G1H4(255)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(34),[G1H4(259)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(14),[G2H4(16),G1H4(263)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G1H4(267)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(26),[G1H4(271)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(40),[G1H4(275)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(53),[G2H16(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(55),[G2H16(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(61),[G2H16(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(63),[G2H16(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(1),[G2H16(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(3),[G2H16(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(13),[G2H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(15),[G2H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(21),[G2H16(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(23),[G2H16(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(29),[G2H16(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(31),[G2H16(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(37),[G2H16(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(39),[G2H16(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(45),[G2H16(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(47),[G2H16(43)])
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(104),ex6(:),G2tensor(2),m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(32),ex6(:),G2tensor(4),m3h2x1(:,140),heltab2x2(:,:,140))
  call Hloop_QZ_A(ntryL,G2H4(110),wf4(:,4),G2H1(1),ngZd,m3h4x1(:,269),heltab2x4(:,:,303))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(41),n2h1(397))
  call Hloop_QZ_A(ntryL,G2H4(78),wf4(:,5),G2H1(1),ngZd,m3h4x1(:,270),heltab2x4(:,:,304))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(42),n2h1(398))
call HGT_OLR(G2H4(102),1,1,4)
call HGT_invQ_OLR(G2H4(102),2,5,4)
call HGT_OLR(G2H4(102),6,15,4)
  call Hloop_AZ_Q(ntryL,G2H4(102),wf4(:,4),G2H1(1),ngZd,m3h4x1(:,271),heltab2x4(:,:,305))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(43),n2h1(399))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(37),ex5(:),G2tensor(6),m3h2x1(:,141),heltab2x2(:,:,141))
call HGT_OLR(G2H4(70),1,1,4)
call HGT_invQ_OLR(G2H4(70),2,5,4)
call HGT_OLR(G2H4(70),6,15,4)
  call Hloop_AZ_Q(ntryL,G2H4(70),wf4(:,5),G2H1(1),ngZd,m3h4x1(:,272),heltab2x4(:,:,306))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(44),n2h1(400))
  call Hloop_QZ_A(ntryL,G1H4(13),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,273),heltab2x4(:,:,307))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(8),n2h1(401))
  call Hloop_QZ_A(ntryL,G1H4(14),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,274),heltab2x4(:,:,308))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(10),n2h1(402))
  call Hloop_QZ_A(ntryL,G2H4(206),wf4(:,11),G2H1(1),ngZd,m3h4x1(:,275),heltab2x4(:,:,309))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(45),n2h1(403))
  call Hloop_QZ_A(ntryL,G2H4(174),wf4(:,12),G2H1(1),ngZd,m3h4x1(:,276),heltab2x4(:,:,310))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(46),n2h1(404))
call HGT_OLR(G2H4(198),1,1,4)
call HGT_invQ_OLR(G2H4(198),2,5,4)
call HGT_OLR(G2H4(198),6,15,4)
  call Hloop_AZ_Q(ntryL,G2H4(198),wf4(:,11),G2H1(1),ngZd,m3h4x1(:,277),heltab2x4(:,:,311))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(47),n2h1(405))
call HGT_OLR(G2H4(166),1,1,4)
call HGT_invQ_OLR(G2H4(166),2,5,4)
call HGT_OLR(G2H4(166),6,15,4)
  call Hloop_AZ_Q(ntryL,G2H4(166),wf4(:,12),G2H1(1),ngZd,m3h4x1(:,278),heltab2x4(:,:,312))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(48),n2h1(406))
  call Hloop_QZ_A(ntryL,G1H4(30),wf4(:,12),G1H1(1),ngZd,m3h4x1(:,279),heltab2x4(:,:,313))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(323),n2h1(407))
  call Hloop_QZ_A(ntryL,G1H4(31),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,280),heltab2x4(:,:,314))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(19),n2h1(408))
  call Hloop_AV_Q(ntryL,G2H4(19),wf4(:,13),G2H1(1),m3h4x1(:,281),heltab2x4(:,:,315))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(49),n2h1(409))
  call Hloop_AZ_Q(ntryL,G2H4(36),wf4(:,5),G2H1(1),ngZu,m3h4x1(:,282),heltab2x4(:,:,316))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(50),n2h1(410))
  call Hloop_AV_Q(ntryL,G2H4(12),wf4(:,13),G2H1(1),m3h4x1(:,283),heltab2x4(:,:,317))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(51),n2h1(411))
  call Hloop_AZ_Q(ntryL,G2H4(8),wf4(:,5),G2H1(1),ngZu,m3h4x1(:,284),heltab2x4(:,:,318))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(52),n2h1(412))
  call Hloop_QV_A(ntryL,G2H4(42),wf4(:,13),G2H1(1),m3h4x1(:,285),heltab2x4(:,:,319))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(53),n2h1(413))
  call Hloop_QZ_A(ntryL,G2H4(30),wf4(:,5),G2H1(1),ngZu,m3h4x1(:,286),heltab2x4(:,:,320))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(54),n2h1(414))
  call Hloop_QV_A(ntryL,G2H4(10),wf4(:,13),G2H1(1),m3h4x1(:,287),heltab2x4(:,:,321))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(55),n2h1(415))
  call Hloop_QZ_A(ntryL,G2H4(39),wf4(:,5),G2H1(1),ngZu,m3h4x1(:,288),heltab2x4(:,:,322))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(56),n2h1(416))
  call Hloop_AZ_Q(ntryL,G2H4(20),wf4(:,5),G2H1(1),ngZd,m3h4x1(:,289),heltab2x4(:,:,323))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(57),n2h1(417))
  call Hloop_AV_Q(ntryL,G2H4(24),wf4(:,13),G2H1(1),m3h4x1(:,290),heltab2x4(:,:,324))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(58),n2h1(418))
  call Hloop_AZ_Q(ntryL,G2H4(25),wf4(:,5),G2H1(1),ngZd,m3h4x1(:,291),heltab2x4(:,:,325))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(59),n2h1(419))
  call Hloop_QZ_A(ntryL,G2H4(43),wf4(:,5),G2H1(1),ngZd,m3h4x1(:,292),heltab2x4(:,:,326))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(60),n2h1(420))
  call Hloop_QV_A(ntryL,G2H4(46),wf4(:,13),G2H1(1),m3h4x1(:,293),heltab2x4(:,:,327))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(61),n2h1(421))
  call Hloop_QZ_A(ntryL,G2H4(47),wf4(:,5),G2H1(1),ngZd,m3h4x1(:,294),heltab2x4(:,:,328))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(62),n2h1(422))
call HGT_OLR(G2H4(50),1,1,4)
call HGT_invQ_OLR(G2H4(50),2,5,4)
call HGT_OLR(G2H4(50),6,15,4)
  call Hloop_AZ_Q(ntryL,G2H4(50),wf4(:,5),G2H1(1),ngZu,m3h4x1(:,295),heltab2x4(:,:,329))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(63),n2h1(423))
  call Hloop_AV_Q(ntryL,G2H4(213),wf4(:,13),G2H1(1),m3h4x1(:,296),heltab2x4(:,:,330))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(64),n2h1(424))
call HGT_OLR(G2H4(54),1,1,4)
call HGT_invQ_OLR(G2H4(54),2,5,4)
call HGT_OLR(G2H4(54),6,15,4)
  call Hloop_AZ_Q(ntryL,G2H4(54),wf4(:,5),G2H1(1),ngZu,m3h4x1(:,297),heltab2x4(:,:,331))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(65),n2h1(425))
  call Hloop_AV_Q(ntryL,G2H4(210),wf4(:,13),G2H1(1),m3h4x1(:,298),heltab2x4(:,:,332))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(66),n2h1(426))
call HGT_OLR(G2H4(58),1,1,4)
call HGT_invQ_OLR(G2H4(58),2,5,4)
call HGT_OLR(G2H4(58),6,15,4)
  call Hloop_QZ_A(ntryL,G2H4(58),wf4(:,5),G2H1(1),ngZu,m3h4x1(:,299),heltab2x4(:,:,333))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(67),n2h1(427))
  call Hloop_QV_A(ntryL,G2H4(215),wf4(:,13),G2H1(1),m3h4x1(:,300),heltab2x4(:,:,334))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(68),n2h1(428))
call HGT_OLR(G2H4(62),1,1,4)
call HGT_invQ_OLR(G2H4(62),2,5,4)
call HGT_OLR(G2H4(62),6,15,4)
  call Hloop_QZ_A(ntryL,G2H4(62),wf4(:,5),G2H1(1),ngZu,m3h4x1(:,301),heltab2x4(:,:,335))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(69),n2h1(429))
  call Hloop_QV_A(ntryL,G2H4(212),wf4(:,13),G2H1(1),m3h4x1(:,302),heltab2x4(:,:,336))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(70),n2h1(430))
call HGT_OLR(G2H4(66),1,1,4)
call HGT_invQ_OLR(G2H4(66),2,5,4)
call HGT_OLR(G2H4(66),6,15,4)
  call Hloop_AZ_Q(ntryL,G2H4(66),wf4(:,5),G2H1(1),ngZd,m3h4x1(:,303),heltab2x4(:,:,337))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(71),n2h1(431))
  call Hloop_AV_Q(ntryL,G2H4(214),wf4(:,13),G2H1(1),m3h4x1(:,304),heltab2x4(:,:,338))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(72),n2h1(432))
call HGT_OLR(G2H4(74),1,1,4)
call HGT_invQ_OLR(G2H4(74),2,5,4)
call HGT_OLR(G2H4(74),6,15,4)
  call Hloop_QZ_A(ntryL,G2H4(74),wf4(:,5),G2H1(1),ngZd,m3h4x1(:,305),heltab2x4(:,:,339))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(73),n2h1(433))
  call Hloop_QV_A(ntryL,G2H4(216),wf4(:,13),G2H1(1),m3h4x1(:,306),heltab2x4(:,:,340))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(74),n2h1(434))
call HGT_OLR(G2H4(82),1,1,4)
call HGT_invQ_OLR(G2H4(82),2,5,4)
call HGT_OLR(G2H4(82),6,15,4)
  call Hloop_AZ_Q(ntryL,G2H4(82),wf4(:,4),G2H1(1),ngZu,m3h4x1(:,307),heltab2x4(:,:,341))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(75),n2h1(435))
call HGT_OLR(G2H4(86),1,1,4)
call HGT_invQ_OLR(G2H4(86),2,5,4)
call HGT_OLR(G2H4(86),6,15,4)
  call Hloop_AZ_Q(ntryL,G2H4(86),wf4(:,4),G2H1(1),ngZu,m3h4x1(:,308),heltab2x4(:,:,342))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(76),n2h1(436))
call HGT_OLR(G2H4(90),1,1,4)
call HGT_invQ_OLR(G2H4(90),2,5,4)
call HGT_OLR(G2H4(90),6,15,4)
  call Hloop_QZ_A(ntryL,G2H4(90),wf4(:,4),G2H1(1),ngZu,m3h4x1(:,309),heltab2x4(:,:,343))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(77),n2h1(437))
call HGT_OLR(G2H4(94),1,1,4)
call HGT_invQ_OLR(G2H4(94),2,5,4)
call HGT_OLR(G2H4(94),6,15,4)
  call Hloop_QZ_A(ntryL,G2H4(94),wf4(:,4),G2H1(1),ngZu,m3h4x1(:,310),heltab2x4(:,:,344))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(78),n2h1(438))
call HGT_OLR(G2H4(98),1,1,4)
call HGT_invQ_OLR(G2H4(98),2,5,4)
call HGT_OLR(G2H4(98),6,15,4)
  call Hloop_AZ_Q(ntryL,G2H4(98),wf4(:,4),G2H1(1),ngZd,m3h4x1(:,311),heltab2x4(:,:,345))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(79),n2h1(439))
call HGT_OLR(G2H4(106),1,1,4)
call HGT_invQ_OLR(G2H4(106),2,5,4)
call HGT_OLR(G2H4(106),6,15,4)
  call Hloop_QZ_A(ntryL,G2H4(106),wf4(:,4),G2H1(1),ngZd,m3h4x1(:,312),heltab2x4(:,:,346))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(80),n2h1(440))
  call Hloop_QZ_A(ntryL,G1H4(73),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,313),heltab2x4(:,:,347))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(11),n2h1(441))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(28),wf8(:,2),G2tensor(14),m3h8x1(:,33),heltab2x8(:,:,161))
call HGT_w2_OLR(G1H4(74),1,1,4)
call HGT_w2_invQ_OLR(G1H4(74),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(74),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,314),heltab2x4(:,:,348))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(305),n2h1(442))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(27),wf8(:,4),G2tensor(23),m3h8x1(:,34),heltab2x8(:,:,162))
call HGT_w2_OLR(G1H16(30),1,1,16)
call HGT_w2_invQ_OLR(G1H16(30),2,5,16)
  call Hloop_QS_A(ntryL,G1H16(30),wf16(:,3),G1H1(1),ngH,m3h16x1(:,1),heltab2x16(:,:,361))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(15),n2h1(443))
call HGT_w2_OLR(G1H16(31),1,1,16)
call HGT_w2_invQ_OLR(G1H16(31),2,5,16)
  call Hloop_QZ_A(ntryL,G1H16(31),wf16(:,73),G1H1(1),ngZd,m3h16x1(:,2),heltab2x16(:,:,362))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(18),n2h1(444))
call HGT_w2_OLR(G1H16(34),1,1,16)
call HGT_w2_invQ_OLR(G1H16(34),2,5,16)
  call Hloop_QZ_A(ntryL,G1H16(34),wf16(:,74),G1H1(1),ngZd,m3h16x1(:,3),heltab2x16(:,:,363))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(22),n2h1(445))
  call Hloop_QV_A(ntryL,G2H4(130),wf4(:,13),G2H1(1),m3h4x1(:,315),heltab2x4(:,:,349))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(81),n2h1(446))
  call Hloop_QZ_A(ntryL,G2H4(115),wf4(:,11),G2H1(1),ngZu,m3h4x1(:,316),heltab2x4(:,:,350))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(82),n2h1(447))
  call Hloop_QV_A(ntryL,G2H4(118),wf4(:,13),G2H1(1),m3h4x1(:,317),heltab2x4(:,:,351))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(83),n2h1(448))
  call Hloop_QZ_A(ntryL,G2H4(119),wf4(:,11),G2H1(1),ngZu,m3h4x1(:,318),heltab2x4(:,:,352))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(84),n2h1(449))
  call Hloop_AV_Q(ntryL,G2H4(138),wf4(:,13),G2H1(1),m3h4x1(:,319),heltab2x4(:,:,353))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(85),n2h1(450))
  call Hloop_AZ_Q(ntryL,G2H4(123),wf4(:,11),G2H1(1),ngZu,m3h4x1(:,320),heltab2x4(:,:,354))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(86),n2h1(451))
  call Hloop_AV_Q(ntryL,G2H4(126),wf4(:,13),G2H1(1),m3h4x1(:,321),heltab2x4(:,:,355))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(87),n2h1(452))
  call Hloop_AZ_Q(ntryL,G2H4(127),wf4(:,11),G2H1(1),ngZu,m3h4x1(:,322),heltab2x4(:,:,356))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(88),n2h1(453))
  call Hloop_QZ_A(ntryL,G2H4(131),wf4(:,11),G2H1(1),ngZd,m3h4x1(:,323),heltab2x4(:,:,357))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(89),n2h1(454))
  call Hloop_QV_A(ntryL,G2H4(134),wf4(:,13),G2H1(1),m3h4x1(:,324),heltab2x4(:,:,358))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(90),n2h1(455))
  call Hloop_QZ_A(ntryL,G2H4(135),wf4(:,11),G2H1(1),ngZd,m3h4x1(:,325),heltab2x4(:,:,359))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(91),n2h1(456))
  call Hloop_AZ_Q(ntryL,G2H4(139),wf4(:,11),G2H1(1),ngZd,m3h4x1(:,326),heltab2x4(:,:,360))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(92),n2h1(457))
  call Hloop_AV_Q(ntryL,G2H4(142),wf4(:,13),G2H1(1),m3h4x1(:,327),heltab2x4(:,:,361))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(93),n2h1(458))
  call Hloop_AZ_Q(ntryL,G2H4(143),wf4(:,11),G2H1(1),ngZd,m3h4x1(:,328),heltab2x4(:,:,362))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(94),n2h1(459))
call HGT_OLR(G2H4(146),1,1,4)
call HGT_invQ_OLR(G2H4(146),2,5,4)
call HGT_OLR(G2H4(146),6,15,4)
  call Hloop_AZ_Q(ntryL,G2H4(146),wf4(:,12),G2H1(1),ngZu,m3h4x1(:,329),heltab2x4(:,:,363))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(95),n2h1(460))
call HGT_OLR(G2H4(150),1,1,4)
call HGT_invQ_OLR(G2H4(150),2,5,4)
call HGT_OLR(G2H4(150),6,15,4)
  call Hloop_AZ_Q(ntryL,G2H4(150),wf4(:,12),G2H1(1),ngZu,m3h4x1(:,330),heltab2x4(:,:,364))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(96),n2h1(461))
call HGT_OLR(G2H4(154),1,1,4)
call HGT_invQ_OLR(G2H4(154),2,5,4)
call HGT_OLR(G2H4(154),6,15,4)
  call Hloop_QZ_A(ntryL,G2H4(154),wf4(:,12),G2H1(1),ngZu,m3h4x1(:,331),heltab2x4(:,:,365))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(97),n2h1(462))
call HGT_OLR(G2H4(158),1,1,4)
call HGT_invQ_OLR(G2H4(158),2,5,4)
call HGT_OLR(G2H4(158),6,15,4)
  call Hloop_QZ_A(ntryL,G2H4(158),wf4(:,12),G2H1(1),ngZu,m3h4x1(:,332),heltab2x4(:,:,366))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(98),n2h1(463))
call HGT_OLR(G2H4(162),1,1,4)
call HGT_invQ_OLR(G2H4(162),2,5,4)
call HGT_OLR(G2H4(162),6,15,4)
  call Hloop_AZ_Q(ntryL,G2H4(162),wf4(:,12),G2H1(1),ngZd,m3h4x1(:,333),heltab2x4(:,:,367))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(99),n2h1(464))
call HGT_OLR(G2H4(170),1,1,4)
call HGT_invQ_OLR(G2H4(170),2,5,4)
call HGT_OLR(G2H4(170),6,15,4)
  call Hloop_QZ_A(ntryL,G2H4(170),wf4(:,12),G2H1(1),ngZd,m3h4x1(:,334),heltab2x4(:,:,368))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(100),n2h1(465))
call HGT_OLR(G2H4(178),1,1,4)
call HGT_invQ_OLR(G2H4(178),2,5,4)
call HGT_OLR(G2H4(178),6,15,4)
  call Hloop_AZ_Q(ntryL,G2H4(178),wf4(:,11),G2H1(1),ngZu,m3h4x1(:,335),heltab2x4(:,:,369))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(101),n2h1(466))
call HGT_OLR(G2H4(182),1,1,4)
call HGT_invQ_OLR(G2H4(182),2,5,4)
call HGT_OLR(G2H4(182),6,15,4)
  call Hloop_AZ_Q(ntryL,G2H4(182),wf4(:,11),G2H1(1),ngZu,m3h4x1(:,336),heltab2x4(:,:,370))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(102),n2h1(467))
call HGT_OLR(G2H4(186),1,1,4)
call HGT_invQ_OLR(G2H4(186),2,5,4)
call HGT_OLR(G2H4(186),6,15,4)
  call Hloop_QZ_A(ntryL,G2H4(186),wf4(:,11),G2H1(1),ngZu,m3h4x1(:,337),heltab2x4(:,:,371))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(103),n2h1(468))
call HGT_OLR(G2H4(190),1,1,4)
call HGT_invQ_OLR(G2H4(190),2,5,4)
call HGT_OLR(G2H4(190),6,15,4)
  call Hloop_QZ_A(ntryL,G2H4(190),wf4(:,11),G2H1(1),ngZu,m3h4x1(:,338),heltab2x4(:,:,372))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(104),n2h1(469))
call HGT_OLR(G2H4(194),1,1,4)
call HGT_invQ_OLR(G2H4(194),2,5,4)
call HGT_OLR(G2H4(194),6,15,4)
  call Hloop_AZ_Q(ntryL,G2H4(194),wf4(:,11),G2H1(1),ngZd,m3h4x1(:,339),heltab2x4(:,:,373))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(105),n2h1(470))
call HGT_OLR(G2H4(202),1,1,4)
call HGT_invQ_OLR(G2H4(202),2,5,4)
call HGT_OLR(G2H4(202),6,15,4)
  call Hloop_QZ_A(ntryL,G2H4(202),wf4(:,11),G2H1(1),ngZd,m3h4x1(:,340),heltab2x4(:,:,374))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(106),n2h1(471))
call HGT_w2_OLR(G1H4(99),1,1,4)
call HGT_w2_invQ_OLR(G1H4(99),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(99),wf4(:,12),G1H1(1),ngZd,m3h4x1(:,341),heltab2x4(:,:,375))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(26),n2h1(472))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(4),wf8(:,20),G2tensor(377),m3h8x1(:,35),heltab2x8(:,:,163))
  call Hloop_QZ_A(ntryL,G1H4(100),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,342),heltab2x4(:,:,376))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(35),n2h1(473))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(3),wf8(:,22),G2tensor(27),m3h8x1(:,36),heltab2x8(:,:,164))
call HGT_w2_OLR(G1H16(35),1,1,16)
call HGT_w2_invQ_OLR(G1H16(35),2,5,16)
  call Hloop_QS_A(ntryL,G1H16(35),wf16(:,12),G1H1(1),ngH,m3h16x1(:,4),heltab2x16(:,:,364))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(30),n2h1(474))
call HGT_w2_OLR(G1H16(36),1,1,16)
call HGT_w2_invQ_OLR(G1H16(36),2,5,16)
  call Hloop_QZ_A(ntryL,G1H16(36),wf16(:,85),G1H1(1),ngZd,m3h16x1(:,5),heltab2x16(:,:,365))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(359),n2h1(475))
call HGT_w2_OLR(G1H16(37),1,1,16)
call HGT_w2_invQ_OLR(G1H16(37),2,5,16)
  call Hloop_QZ_A(ntryL,G1H16(37),wf16(:,86),G1H1(1),ngZd,m3h16x1(:,6),heltab2x16(:,:,366))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(39),n2h1(476))
call HGT_w2_OLR(G1H16(40),1,1,16)
call HGT_w2_invQ_OLR(G1H16(40),2,5,16)
  call Hloop_QZ_A(ntryL,G1H16(40),wf16(:,87),G1H1(1),ngZd,m3h16x1(:,7),heltab2x16(:,:,367))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(31),n2h1(477))
call HGT_w2_OLR(G1H16(41),1,1,16)
call HGT_w2_invQ_OLR(G1H16(41),2,5,16)
  call Hloop_QZ_A(ntryL,G1H16(41),wf16(:,88),G1H1(1),ngZd,m3h16x1(:,8),heltab2x16(:,:,368))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(34),n2h1(478))
call HGT_w2_OLR(G1H16(42),1,1,16)
call HGT_w2_invQ_OLR(G1H16(42),2,5,16)
  call Hloop_QZ_A(ntryL,G1H16(42),wf16(:,89),G1H1(1),ngZd,m3h16x1(:,9),heltab2x16(:,:,369))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(38),n2h1(479))
call HGT_w2_OLR(G1H16(43),1,1,16)
call HGT_w2_invQ_OLR(G1H16(43),2,5,16)
  call Hloop_QZ_A(ntryL,G1H16(43),wf16(:,90),G1H1(1),ngZd,m3h16x1(:,10),heltab2x16(:,:,370))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(42),n2h1(480))
  call Hloop_VQ_A(ntryL,G1H2(25),ex5(:),G1H1(1),m3h2x1(:,142),heltab2x2(:,:,142))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(43),n2h1(481))
  call Hloop_VQ_A(ntryL,G1H2(26),ex5(:),G1H1(1),m3h2x1(:,143),heltab2x2(:,:,143))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(46),n2h1(482))
  call Hloop_VQ_A(ntryL,G1H2(47),ex5(:),G1H1(1),m3h2x1(:,144),heltab2x2(:,:,144))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(47),n2h1(483))
  call Hloop_VA_Q(ntryL,G1H2(38),ex6(:),G1H1(1),m3h2x1(:,145),heltab2x2(:,:,145))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(50),n2h1(484))
  call Hloop_VA_Q(ntryL,G1H2(93),ex6(:),G1H1(1),m3h2x1(:,146),heltab2x2(:,:,146))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(51),n2h1(485))
  call Hloop_VA_Q(ntryL,G1H2(89),ex6(:),G1H1(1),m3h2x1(:,147),heltab2x2(:,:,147))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(54),n2h1(486))
  call Hloop_VQ_A(ntryL,G1H2(92),ex5(:),G1H1(1),m3h2x1(:,148),heltab2x2(:,:,148))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(55),n2h1(487))
  call Hloop_VQ_A(ntryL,G1H2(48),ex5(:),G1H1(1),m3h2x1(:,149),heltab2x2(:,:,149))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(176),n2h1(488))
  call Hloop_VA_Q(ntryL,G1H2(66),ex6(:),G1H1(1),m3h2x1(:,150),heltab2x2(:,:,150))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(188),n2h1(489))
  call Hloop_VA_Q(ntryL,G1H2(10),ex6(:),G1H1(1),m3h2x1(:,151),heltab2x2(:,:,151))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(105),n2h1(490))
  call Hloop_VA_Q(ntryL,G1H2(64),ex6(:),G1H1(1),m3h2x1(:,152),heltab2x2(:,:,152))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(103),n2h1(491))
  call Hloop_AZ_Q(ntryL,G2H4(52),wf4(:,5),G2H1(1),ngZd,m3h4x1(:,343),heltab2x4(:,:,377))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(107),n2h1(492))
  call Hloop_VQ_A(ntryL,G1H2(91),ex5(:),G1H1(1),m3h2x1(:,153),heltab2x2(:,:,153))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(101),n2h1(493))
  call Hloop_QZ_A(ntryL,G2H4(60),wf4(:,5),G2H1(1),ngZd,m3h4x1(:,344),heltab2x4(:,:,378))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(108),n2h1(494))
  call Hloop_QZ_A(ntryL,G2H4(5),wf4(:,11),G2H1(1),ngZd,m3h4x1(:,345),heltab2x4(:,:,379))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(109),n2h1(495))
  call Hloop_AZ_Q(ntryL,G2H4(1),wf4(:,11),G2H1(1),ngZd,m3h4x1(:,346),heltab2x4(:,:,380))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(110),n2h1(496))
  call Hloop_AZ_Q(ntryL,G1H4(112),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,347),heltab2x4(:,:,381))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(102),n2h1(497))
  call Hloop_AZ_Q(ntryL,G1H4(136),wf4(:,11),G1H1(1),ngZd,m3h4x1(:,348),heltab2x4(:,:,382))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(106),n2h1(498))
  call Hloop_VQ_A(ntryL,G1H8(38),wf8(:,7),G1H1(1),m3h8x1(:,37),heltab2x8(:,:,165))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(109),n2h1(499))
  call Hloop_VQ_A(ntryL,G1H8(39),wf8(:,7),G1H1(1),m3h8x1(:,38),heltab2x8(:,:,166))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(110),n2h1(500))
  call Hloop_VA_Q(ntryL,G1H8(55),wf8(:,2),G1H1(1),m3h8x1(:,39),heltab2x8(:,:,167))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(113),n2h1(501))
  call Hloop_VA_Q(ntryL,G1H8(75),wf8(:,2),G1H1(1),m3h8x1(:,40),heltab2x8(:,:,168))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(115),n2h1(502))
  call Hloop_VQ_A(ntryL,G1H8(81),wf8(:,9),G1H1(1),m3h8x1(:,41),heltab2x8(:,:,169))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(116),n2h1(503))
  call Hloop_VQ_A(ntryL,G1H8(82),wf8(:,9),G1H1(1),m3h8x1(:,42),heltab2x8(:,:,170))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(119),n2h1(504))
  call Hloop_VA_Q(ntryL,G1H8(8),wf8(:,4),G1H1(1),m3h8x1(:,43),heltab2x8(:,:,171))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(129),n2h1(505))
  call Hloop_VA_Q(ntryL,G1H8(28),wf8(:,4),G1H1(1),m3h8x1(:,44),heltab2x8(:,:,172))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(127),n2h1(506))
  call Hloop_VQ_A(ntryL,G1H8(19),wf8(:,24),G1H1(1),m3h8x1(:,45),heltab2x8(:,:,173))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(125),n2h1(507))
  call Hloop_VQ_A(ntryL,G1H8(20),wf8(:,24),G1H1(1),m3h8x1(:,46),heltab2x8(:,:,174))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(126),n2h1(508))
  call Hloop_VA_Q(ntryL,G1H8(31),wf8(:,20),G1H1(1),m3h8x1(:,47),heltab2x8(:,:,175))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(130),n2h1(509))
  call Hloop_VA_Q(ntryL,G1H8(9),wf8(:,20),G1H1(1),m3h8x1(:,48),heltab2x8(:,:,176))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(133),n2h1(510))
  call Hloop_VQ_A(ntryL,G1H8(41),wf8(:,26),G1H1(1),m3h8x1(:,49),heltab2x8(:,:,177))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(134),n2h1(511))
  call Hloop_VQ_A(ntryL,G1H8(42),wf8(:,26),G1H1(1),m3h8x1(:,50),heltab2x8(:,:,178))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(137),n2h1(512))
  call Hloop_VA_Q(ntryL,G1H8(53),wf8(:,22),G1H1(1),m3h8x1(:,51),heltab2x8(:,:,179))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(139),n2h1(513))
  call Hloop_VA_Q(ntryL,G1H8(3),wf8(:,22),G1H1(1),m3h8x1(:,52),heltab2x8(:,:,180))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(140),n2h1(514))
  call Hloop_AZ_Q(ntryL,G2H4(3),wf4(:,5),G2H1(1),ngZu,m3h4x1(:,349),heltab2x4(:,:,383))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(111),n2h1(515))
  call Hloop_AZ_Q(ntryL,G2H4(7),wf4(:,5),G2H1(1),ngZu,m3h4x1(:,350),heltab2x4(:,:,384))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(112),n2h1(516))
  call Hloop_QZ_A(ntryL,G2H4(11),wf4(:,5),G2H1(1),ngZu,m3h4x1(:,351),heltab2x4(:,:,385))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(113),n2h1(517))
  call Hloop_QZ_A(ntryL,G2H4(15),wf4(:,5),G2H1(1),ngZu,m3h4x1(:,352),heltab2x4(:,:,386))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(114),n2h1(518))
  call Hloop_AZ_Q(ntryL,G2H4(49),wf4(:,5),G2H1(1),ngZd,m3h4x1(:,353),heltab2x4(:,:,387))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(115),n2h1(519))
  call Hloop_QZ_A(ntryL,G2H4(57),wf4(:,5),G2H1(1),ngZd,m3h4x1(:,354),heltab2x4(:,:,388))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(116),n2h1(520))
  call Hloop_AV_Q(ntryL,G2H4(145),wf4(:,13),G2H1(1),m3h4x1(:,355),heltab2x4(:,:,389))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(117),n2h1(521))
  call Hloop_AV_Q(ntryL,G2H4(84),wf4(:,13),G2H1(1),m3h4x1(:,356),heltab2x4(:,:,390))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(118),n2h1(522))
  call Hloop_QV_A(ntryL,G2H4(153),wf4(:,13),G2H1(1),m3h4x1(:,357),heltab2x4(:,:,391))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(119),n2h1(523))
  call Hloop_QV_A(ntryL,G2H4(92),wf4(:,13),G2H1(1),m3h4x1(:,358),heltab2x4(:,:,392))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(120),n2h1(524))
  call Hloop_AV_Q(ntryL,G2H4(148),wf4(:,13),G2H1(1),m3h4x1(:,359),heltab2x4(:,:,393))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(121),n2h1(525))
  call Hloop_QV_A(ntryL,G2H4(156),wf4(:,13),G2H1(1),m3h4x1(:,360),heltab2x4(:,:,394))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(122),n2h1(526))
  call Hloop_QZ_A(ntryL,G2H4(37),wf4(:,11),G2H1(1),ngZu,m3h4x1(:,361),heltab2x4(:,:,395))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(123),n2h1(527))
  call Hloop_QZ_A(ntryL,G2H4(35),wf4(:,11),G2H1(1),ngZu,m3h4x1(:,362),heltab2x4(:,:,396))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(124),n2h1(528))
  call Hloop_AZ_Q(ntryL,G2H4(33),wf4(:,11),G2H1(1),ngZu,m3h4x1(:,363),heltab2x4(:,:,397))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(125),n2h1(529))
  call Hloop_AZ_Q(ntryL,G2H4(13),wf4(:,11),G2H1(1),ngZu,m3h4x1(:,364),heltab2x4(:,:,398))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(126),n2h1(530))
  call Hloop_QZ_A(ntryL,G2H4(9),wf4(:,11),G2H1(1),ngZd,m3h4x1(:,365),heltab2x4(:,:,399))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(127),n2h1(531))
  call Hloop_AZ_Q(ntryL,G2H4(27),wf4(:,11),G2H1(1),ngZd,m3h4x1(:,366),heltab2x4(:,:,400))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(128),n2h1(532))
  call Hloop_AV_Q(ntryL,G2H4(32),wf4(:,13),G2H1(1),m3h4x1(:,367),heltab2x4(:,:,401))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(129),n2h1(533))
  call Hloop_AV_Q(ntryL,G2H4(34),wf4(:,13),G2H1(1),m3h4x1(:,368),heltab2x4(:,:,402))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(130),n2h1(534))
  call Hloop_QV_A(ntryL,G2H4(14),wf4(:,13),G2H1(1),m3h4x1(:,369),heltab2x4(:,:,403))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(131),n2h1(535))
  call Hloop_QV_A(ntryL,G2H4(4),wf4(:,13),G2H1(1),m3h4x1(:,370),heltab2x4(:,:,404))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(132),n2h1(536))
  call Hloop_AV_Q(ntryL,G2H4(26),wf4(:,13),G2H1(1),m3h4x1(:,371),heltab2x4(:,:,405))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(133),n2h1(537))
  call Hloop_QV_A(ntryL,G2H4(40),wf4(:,13),G2H1(1),m3h4x1(:,372),heltab2x4(:,:,406))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(134),n2h1(538))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(2),ex6(:),G2tensor(143),m3h2x1(:,154),heltab2x2(:,:,154))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(5),ex6(:),G2tensor(287),m3h2x1(:,155),heltab2x2(:,:,155))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(8),ex5(:),G2tensor(281),m3h2x1(:,156),heltab2x2(:,:,156))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(11),ex5(:),G2tensor(275),m3h2x1(:,157),heltab2x2(:,:,157))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(14),ex6(:),G2tensor(278),m3h2x1(:,158),heltab2x2(:,:,158))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(17),ex6(:),G2tensor(293),m3h2x1(:,159),heltab2x2(:,:,159))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(20),ex5(:),G2tensor(296),m3h2x1(:,160),heltab2x2(:,:,160))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(23),ex5(:),G2tensor(311),m3h2x1(:,161),heltab2x2(:,:,161))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(21),wf8(:,2),G2tensor(314),m3h8x1(:,53),heltab2x8(:,:,181))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(23),wf8(:,4),G2tensor(341),m3h8x1(:,54),heltab2x8(:,:,182))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(17),wf8(:,20),G2tensor(335),m3h8x1(:,55),heltab2x8(:,:,183))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(18),wf8(:,22),G2tensor(329),m3h8x1(:,56),heltab2x8(:,:,184))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(19),wf8(:,7),G2tensor(332),m3h8x1(:,57),heltab2x8(:,:,185))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(20),wf8(:,9),G2tensor(347),m3h8x1(:,58),heltab2x8(:,:,186))
  call Hloop_AV_Q(ntryL,G2H16(53),wf16(:,28),G2H1(1),m3h16x1(:,11),heltab2x16(:,:,371))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(135),n2h1(539))
  call Hloop_AV_Q(ntryL,G2H16(50),wf16(:,28),G2H1(1),m3h16x1(:,12),heltab2x16(:,:,372))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(136),n2h1(540))
  call Hloop_QV_A(ntryL,G2H16(55),wf16(:,28),G2H1(1),m3h16x1(:,13),heltab2x16(:,:,373))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(137),n2h1(541))
  call Hloop_QV_A(ntryL,G2H16(52),wf16(:,28),G2H1(1),m3h16x1(:,14),heltab2x16(:,:,374))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(138),n2h1(542))
  call Hloop_AV_Q(ntryL,G2H16(54),wf16(:,28),G2H1(1),m3h16x1(:,15),heltab2x16(:,:,375))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(139),n2h1(543))
  call Hloop_QV_A(ntryL,G2H16(56),wf16(:,28),G2H1(1),m3h16x1(:,16),heltab2x16(:,:,376))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(140),n2h1(544))
  call Hloop_AV_Q(ntryL,G2H16(61),wf16(:,30),G2H1(1),m3h16x1(:,17),heltab2x16(:,:,377))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(141),n2h1(545))
  call Hloop_AV_Q(ntryL,G2H16(58),wf16(:,30),G2H1(1),m3h16x1(:,18),heltab2x16(:,:,378))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(142),n2h1(546))
  call Hloop_QV_A(ntryL,G2H16(63),wf16(:,30),G2H1(1),m3h16x1(:,19),heltab2x16(:,:,379))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(143),n2h1(547))
  call Hloop_QV_A(ntryL,G2H16(60),wf16(:,30),G2H1(1),m3h16x1(:,20),heltab2x16(:,:,380))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(144),n2h1(548))
  call Hloop_AV_Q(ntryL,G2H16(62),wf16(:,30),G2H1(1),m3h16x1(:,21),heltab2x16(:,:,381))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(145),n2h1(549))
  call Hloop_QV_A(ntryL,G2H16(64),wf16(:,30),G2H1(1),m3h16x1(:,22),heltab2x16(:,:,382))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(146),n2h1(550))
  call Hloop_VA_Q(ntryL,G1H32(36),wf32(:,6),G1H1(1),m3h32x1(:,1),heltab2x32(:,:,113))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(350),n2h1(551))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H32(1),wf32(:,6),G2tensor(365),m3h32x1(:,2),heltab2x32(:,:,114))
  call Hloop_AV_Q(ntryL,G2H16(1),wf16(:,31),G2H1(1),m3h16x1(:,23),heltab2x16(:,:,383))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(147),n2h1(552))
  call Hloop_AV_Q(ntryL,G2H16(10),wf16(:,31),G2H1(1),m3h16x1(:,24),heltab2x16(:,:,384))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(148),n2h1(553))
  call Hloop_QV_A(ntryL,G2H16(3),wf16(:,31),G2H1(1),m3h16x1(:,25),heltab2x16(:,:,385))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(149),n2h1(554))
  call Hloop_QV_A(ntryL,G2H16(12),wf16(:,31),G2H1(1),m3h16x1(:,26),heltab2x16(:,:,386))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(150),n2h1(555))
  call Hloop_AV_Q(ntryL,G2H16(2),wf16(:,31),G2H1(1),m3h16x1(:,27),heltab2x16(:,:,387))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(151),n2h1(556))
  call Hloop_QV_A(ntryL,G2H16(4),wf16(:,31),G2H1(1),m3h16x1(:,28),heltab2x16(:,:,388))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(152),n2h1(557))
  call Hloop_AV_Q(ntryL,G2H16(13),wf16(:,32),G2H1(1),m3h16x1(:,29),heltab2x16(:,:,389))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(153),n2h1(558))
  call Hloop_AV_Q(ntryL,G2H16(6),wf16(:,32),G2H1(1),m3h16x1(:,30),heltab2x16(:,:,390))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(154),n2h1(559))
  call Hloop_QV_A(ntryL,G2H16(15),wf16(:,32),G2H1(1),m3h16x1(:,31),heltab2x16(:,:,391))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(155),n2h1(560))
  call Hloop_QV_A(ntryL,G2H16(8),wf16(:,32),G2H1(1),m3h16x1(:,32),heltab2x16(:,:,392))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(156),n2h1(561))
  call Hloop_AV_Q(ntryL,G2H16(14),wf16(:,32),G2H1(1),m3h16x1(:,33),heltab2x16(:,:,393))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(157),n2h1(562))
  call Hloop_QV_A(ntryL,G2H16(16),wf16(:,32),G2H1(1),m3h16x1(:,34),heltab2x16(:,:,394))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(158),n2h1(563))
  call Hloop_VA_Q(ntryL,G1H32(39),wf32(:,10),G1H1(1),m3h32x1(:,3),heltab2x32(:,:,115))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(368),n2h1(564))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H32(2),wf32(:,10),G2tensor(123),m3h32x1(:,4),heltab2x32(:,:,116))
  call Hloop_VA_Q(ntryL,G1H32(41),wf32(:,14),G1H1(1),m3h32x1(:,5),heltab2x32(:,:,117))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(121),n2h1(565))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H32(3),wf32(:,14),G2tensor(147),m3h32x1(:,6),heltab2x32(:,:,118))
  call Hloop_VA_Q(ntryL,G1H32(44),wf32(:,18),G1H1(1),m3h32x1(:,7),heltab2x32(:,:,119))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(145),n2h1(566))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H32(4),wf32(:,18),G2tensor(85),m3h32x1(:,8),heltab2x32(:,:,120))
  call Hloop_VA_Q(ntryL,G1H32(46),wf32(:,22),G1H1(1),m3h32x1(:,9),heltab2x32(:,:,121))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(326),n2h1(567))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H32(5),wf32(:,22),G2tensor(86),m3h32x1(:,10),heltab2x32(:,:,122))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(1),wf8(:,24),G2tensor(308),m3h8x1(:,59),heltab2x8(:,:,187))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(2),wf8(:,26),G2tensor(87),m3h8x1(:,60),heltab2x8(:,:,188))
  call Hloop_AV_Q(ntryL,G2H16(21),wf16(:,48),G2H1(1),m3h16x1(:,35),heltab2x16(:,:,395))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(159),n2h1(568))
  call Hloop_AV_Q(ntryL,G2H16(18),wf16(:,48),G2H1(1),m3h16x1(:,36),heltab2x16(:,:,396))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(160),n2h1(569))
  call Hloop_QV_A(ntryL,G2H16(23),wf16(:,48),G2H1(1),m3h16x1(:,37),heltab2x16(:,:,397))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(161),n2h1(570))
  call Hloop_QV_A(ntryL,G2H16(20),wf16(:,48),G2H1(1),m3h16x1(:,38),heltab2x16(:,:,398))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(162),n2h1(571))
  call Hloop_AV_Q(ntryL,G2H16(22),wf16(:,48),G2H1(1),m3h16x1(:,39),heltab2x16(:,:,399))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(163),n2h1(572))
  call Hloop_QV_A(ntryL,G2H16(24),wf16(:,48),G2H1(1),m3h16x1(:,40),heltab2x16(:,:,400))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(164),n2h1(573))
  call Hloop_AV_Q(ntryL,G2H16(29),wf16(:,50),G2H1(1),m3h16x1(:,41),heltab2x16(:,:,401))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(165),n2h1(574))
  call Hloop_AV_Q(ntryL,G2H16(26),wf16(:,50),G2H1(1),m3h16x1(:,42),heltab2x16(:,:,402))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(166),n2h1(575))
  call Hloop_QV_A(ntryL,G2H16(31),wf16(:,50),G2H1(1),m3h16x1(:,43),heltab2x16(:,:,403))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(167),n2h1(576))
  call Hloop_QV_A(ntryL,G2H16(28),wf16(:,50),G2H1(1),m3h16x1(:,44),heltab2x16(:,:,404))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(168),n2h1(577))
  call Hloop_AV_Q(ntryL,G2H16(30),wf16(:,50),G2H1(1),m3h16x1(:,45),heltab2x16(:,:,405))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(169),n2h1(578))
  call Hloop_QV_A(ntryL,G2H16(32),wf16(:,50),G2H1(1),m3h16x1(:,46),heltab2x16(:,:,406))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(170),n2h1(579))
  call Hloop_VA_Q(ntryL,G1H32(49),wf32(:,26),G1H1(1),m3h32x1(:,11),heltab2x32(:,:,123))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(89),n2h1(580))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H32(6),wf32(:,26),G2tensor(93),m3h32x1(:,12),heltab2x32(:,:,124))
  call Hloop_AV_Q(ntryL,G2H16(37),wf16(:,51),G2H1(1),m3h16x1(:,47),heltab2x16(:,:,407))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(171),n2h1(581))
  call Hloop_AV_Q(ntryL,G2H16(34),wf16(:,51),G2H1(1),m3h16x1(:,48),heltab2x16(:,:,408))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(172),n2h1(582))
  call Hloop_QV_A(ntryL,G2H16(39),wf16(:,51),G2H1(1),m3h16x1(:,49),heltab2x16(:,:,409))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(173),n2h1(583))
  call Hloop_QV_A(ntryL,G2H16(36),wf16(:,51),G2H1(1),m3h16x1(:,50),heltab2x16(:,:,410))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(174),n2h1(584))
  call Hloop_AV_Q(ntryL,G2H16(38),wf16(:,51),G2H1(1),m3h16x1(:,51),heltab2x16(:,:,411))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(175),n2h1(585))
  call Hloop_QV_A(ntryL,G2H16(40),wf16(:,51),G2H1(1),m3h16x1(:,52),heltab2x16(:,:,412))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(176),n2h1(586))
  call Hloop_AV_Q(ntryL,G2H16(45),wf16(:,52),G2H1(1),m3h16x1(:,53),heltab2x16(:,:,413))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(177),n2h1(587))
  call Hloop_AV_Q(ntryL,G2H16(42),wf16(:,52),G2H1(1),m3h16x1(:,54),heltab2x16(:,:,414))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(178),n2h1(588))
  call Hloop_QV_A(ntryL,G2H16(47),wf16(:,52),G2H1(1),m3h16x1(:,55),heltab2x16(:,:,415))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(179),n2h1(589))
  call Hloop_QV_A(ntryL,G2H16(44),wf16(:,52),G2H1(1),m3h16x1(:,56),heltab2x16(:,:,416))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(180),n2h1(590))
  call Hloop_AV_Q(ntryL,G2H16(46),wf16(:,52),G2H1(1),m3h16x1(:,57),heltab2x16(:,:,417))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(181),n2h1(591))
  call Hloop_QV_A(ntryL,G2H16(48),wf16(:,52),G2H1(1),m3h16x1(:,58),heltab2x16(:,:,418))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(182),n2h1(592))
  call Hloop_VA_Q(ntryL,G1H32(51),wf32(:,30),G1H1(1),m3h32x1(:,13),heltab2x32(:,:,125))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(380),n2h1(593))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H32(7),wf32(:,30),G2tensor(94),m3h32x1(:,14),heltab2x32(:,:,126))
  call Hloop_VA_Q(ntryL,G1H32(54),wf32(:,34),G1H1(1),m3h32x1(:,15),heltab2x32(:,:,127))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(362),n2h1(594))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H32(8),wf32(:,34),G2tensor(95),m3h32x1(:,16),heltab2x32(:,:,128))
  call Hloop_VA_Q(ntryL,G1H32(56),wf32(:,38),G1H1(1),m3h32x1(:,17),heltab2x32(:,:,129))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(97),n2h1(595))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H32(9),wf32(:,38),G2tensor(173),m3h32x1(:,18),heltab2x32(:,:,130))
  call Hloop_VA_Q(ntryL,G1H32(59),wf32(:,42),G1H1(1),m3h32x1(:,19),heltab2x32(:,:,131))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(260),n2h1(596))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H32(10),wf32(:,42),G2tensor(179),m3h32x1(:,20),heltab2x32(:,:,132))
  call Hloop_VA_Q(ntryL,G1H32(61),wf32(:,46),G1H1(1),m3h32x1(:,21),heltab2x32(:,:,133))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(257),n2h1(597))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H32(11),wf32(:,46),G2tensor(185),m3h32x1(:,22),heltab2x32(:,:,134))
  call Hloop_VA_Q(ntryL,G1H32(64),wf32(:,50),G1H1(1),m3h32x1(:,23),heltab2x32(:,:,135))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(263),n2h1(598))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H32(12),wf32(:,50),G2tensor(191),m3h32x1(:,24),heltab2x32(:,:,136))
  call Hloop_VA_Q(ntryL,G1H32(66),wf32(:,54),G1H1(1),m3h32x1(:,25),heltab2x32(:,:,137))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(266),n2h1(599))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H32(13),wf32(:,54),G2tensor(197),m3h32x1(:,26),heltab2x32(:,:,138))
  call Hloop_VA_Q(ntryL,G1H32(69),wf32(:,58),G1H1(1),m3h32x1(:,27),heltab2x32(:,:,139))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(91),n2h1(600))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H32(14),wf32(:,58),G2tensor(1),m3h32x1(:,28),heltab2x32(:,:,140))
  call ol_merge_tensors(G3tensor(43),[G3tensor(41),G2tensor(327),G2tensor(324),G2tensor(20),G2tensor(12),G1tensor(138) &
    ,G1tensor(39),G1tensor(48),G1tensor(9),G0tensor(156),G0tensor(60),G0tensor(45),G0tensor(40)])
  call ol_merge_tensors(G3tensor(44),[G3tensor(42),G2tensor(309),G2tensor(306),G2tensor(24),G2tensor(16),G1tensor(123) &
    ,G1tensor(86),G1tensor(72),G1tensor(21),G0tensor(141),G0tensor(65),G0tensor(55),G0tensor(50)])
  call ol_merge_tensors(G3tensor(47),[G3tensor(45),G2tensor(381),G2tensor(378),G2tensor(36),G2tensor(28),G1tensor(158) &
    ,G1tensor(70),G1tensor(11),G1tensor(96),G0tensor(176),G0tensor(90),G0tensor(75),G0tensor(70)])
  call ol_merge_tensors(G3tensor(48),[G3tensor(46),G2tensor(363),G2tensor(360),G2tensor(40),G2tensor(32),G1tensor(148) &
    ,G1tensor(45),G1tensor(34),G1tensor(16),G0tensor(166),G0tensor(95),G0tensor(85),G0tensor(80)])
  call ol_merge_tensors(G2tensor(281),[G2tensor(261),G2tensor(174),G2tensor(44),G1tensor(83),G1tensor(63),G1tensor(78) &
    ,G0tensor(105),G0tensor(100),G0tensor(61)])
  call ol_merge_tensors(G2tensor(143),[G2tensor(258),G2tensor(180),G2tensor(48),G1tensor(143),G1tensor(97),G1tensor(88) &
    ,G1tensor(42),G0tensor(161),G0tensor(115),G0tensor(110),G0tensor(41)])
  call ol_merge_tensors(G2tensor(293),[G2tensor(264),G2tensor(186),G2tensor(52),G1tensor(153),G1tensor(107),G1tensor(102) &
    ,G1tensor(20),G0tensor(171),G0tensor(125),G0tensor(120),G0tensor(81)])
  call ol_merge_tensors(G2tensor(311),[G2tensor(267),G2tensor(192),G2tensor(56),G1tensor(117),G1tensor(112),G1tensor(47) &
    ,G0tensor(135),G0tensor(130),G0tensor(96)])
  call ol_merge_tensors(G2tensor(42),[G2tensor(38),G2tensor(34),G2tensor(31),G2tensor(39),G2tensor(359),G2tensor(30),G2tensor(22) &
    ,G2tensor(18),G2tensor(15),G2tensor(208),G2tensor(205),G2tensor(202),G2tensor(199),G2tensor(25),G2tensor(17),G2tensor(9) &
    ,G2tensor(3),G1tensor(160),G1tensor(150),G1tensor(140),G1tensor(132),G1tensor(125),G0tensor(178),G0tensor(168),G0tensor(158) &
    ,G0tensor(150),G0tensor(143)])
  call ol_merge_tensors(G2tensor(1),[G2tensor(197),G2tensor(191),G2tensor(185),G2tensor(179),G2tensor(173),G2tensor(95) &
    ,G2tensor(94),G2tensor(93),G2tensor(86),G2tensor(85),G2tensor(147),G2tensor(123),G2tensor(365),G2tensor(148),G2tensor(146) &
    ,G2tensor(124),G2tensor(122),G2tensor(5),G1tensor(135),G1tensor(24),G1tensor(85),G1tensor(55),G1tensor(25),G0tensor(153) &
    ,G0tensor(38),G0tensor(33),G0tensor(28),G0tensor(23)])
  call ol_merge_tensors(G2tensor(305),[G2tensor(198),G2tensor(7),G1tensor(122),G1tensor(7),G0tensor(140),G0tensor(20)])
  call ol_merge_tensors(G2tensor(11),[G2tensor(201),G2tensor(13),G1tensor(258),G1tensor(253),G1tensor(137),G1tensor(37) &
    ,G0tensor(276),G0tensor(271),G0tensor(155),G0tensor(25)])
  call ol_merge_tensors(G2tensor(35),[G2tensor(204),G2tensor(21),G1tensor(268),G1tensor(263),G1tensor(147),G1tensor(67) &
    ,G0tensor(286),G0tensor(281),G0tensor(165),G0tensor(30)])
  call ol_merge_tensors(G2tensor(26),[G2tensor(207),G2tensor(29),G1tensor(157),G1tensor(6),G0tensor(175),G0tensor(35)])
  call ol_merge_tensors(G3tensor(61),[G3tensor(58),G2tensor(183),G2tensor(181),G2tensor(177),G2tensor(175),G2tensor(53) &
    ,G2tensor(33),G1tensor(247),G1tensor(93),G1tensor(75),G1tensor(36),G0tensor(265),G0tensor(113),G0tensor(103),G0tensor(46)])
  call ol_merge_tensors(G3tensor(74),[G3tensor(72),G2tensor(217),G2tensor(211),G2tensor(57),G2tensor(37),G1tensor(190) &
    ,G1tensor(170),G1tensor(29),G1tensor(8),G1tensor(62),G1tensor(38),G0tensor(208),G0tensor(188),G0tensor(87),G0tensor(77) &
    ,G0tensor(57),G0tensor(47)])
  call ol_merge_tensors(G3tensor(146),[G3tensor(145),G3tensor(140),G3tensor(139),G3tensor(22),G3tensor(21),G2tensor(328) &
    ,G2tensor(325),G2tensor(256),G2tensor(253),G2tensor(157),G2tensor(151),G2tensor(58),G2tensor(41),G1tensor(367),G1tensor(362) &
    ,G1tensor(195),G1tensor(175),G1tensor(44),G0tensor(313),G0tensor(308),G0tensor(213),G0tensor(193),G0tensor(48)])
  call ol_merge_tensors(G3tensor(122),[G3tensor(121),G2tensor(220),G2tensor(214),G2tensor(59),G2tensor(45),G1tensor(200) &
    ,G1tensor(180),G1tensor(60),G0tensor(218),G0tensor(198),G0tensor(56)])
  call ol_merge_tensors(G3tensor(158),[G3tensor(157),G3tensor(152),G3tensor(151),G3tensor(16),G3tensor(15),G3tensor(2),G3tensor(1) &
    ,G2tensor(310),G2tensor(307),G2tensor(262),G2tensor(259),G2tensor(184),G2tensor(178),G2tensor(160),G2tensor(154),G2tensor(60) &
    ,G2tensor(49),G1tensor(250),G1tensor(205),G1tensor(185),G1tensor(100),G1tensor(82),G1tensor(68),G0tensor(268),G0tensor(223) &
    ,G0tensor(203),G0tensor(118),G0tensor(108),G0tensor(58)])
  call ol_merge_tensors(G3tensor(134),[G3tensor(133),G2tensor(226),G2tensor(223),G2tensor(65),G2tensor(61),G1tensor(225) &
    ,G1tensor(210),G1tensor(5),G0tensor(243),G0tensor(228),G0tensor(76)])
  call ol_merge_tensors(G3tensor(170),[G3tensor(169),G3tensor(164),G3tensor(163),G3tensor(40),G3tensor(39),G3tensor(4),G3tensor(3) &
    ,G2tensor(382),G2tensor(379),G2tensor(268),G2tensor(265),G2tensor(196),G2tensor(190),G2tensor(169),G2tensor(163),G2tensor(66) &
    ,G2tensor(62),G1tensor(275),G1tensor(230),G1tensor(215),G1tensor(120),G1tensor(110),G1tensor(10),G0tensor(293),G0tensor(248) &
    ,G0tensor(233),G0tensor(138),G0tensor(128),G0tensor(78)])
  call ol_merge_tensors(G3tensor(93),[G3tensor(90),G2tensor(195),G2tensor(193),G2tensor(189),G2tensor(187),G2tensor(67) &
    ,G2tensor(63),G1tensor(272),G1tensor(115),G1tensor(105),G1tensor(28),G0tensor(290),G0tensor(133),G0tensor(123),G0tensor(86)])
  call ol_merge_tensors(G3tensor(182),[G3tensor(181),G3tensor(176),G3tensor(175),G3tensor(34),G3tensor(33),G2tensor(364) &
    ,G2tensor(361),G2tensor(274),G2tensor(271),G2tensor(172),G2tensor(166),G2tensor(68),G2tensor(64),G1tensor(377),G1tensor(372) &
    ,G1tensor(235),G1tensor(220),G1tensor(33),G0tensor(323),G0tensor(318),G0tensor(253),G0tensor(238),G0tensor(88)])
  call ol_merge_tensors(G2tensor(129),[G2tensor(229),G2tensor(69),G1tensor(240),G1tensor(77),G0tensor(258),G0tensor(106)])
  call ol_merge_tensors(G2tensor(127),[G2tensor(232),G2tensor(70),G1tensor(245),G1tensor(81),G0tensor(263),G0tensor(107)])
  call ol_merge_tensors(G2tensor(116),[G2tensor(235),G2tensor(71),G1tensor(255),G1tensor(98),G0tensor(273),G0tensor(116)])
  call ol_merge_tensors(G2tensor(119),[G2tensor(238),G2tensor(72),G1tensor(260),G1tensor(99),G0tensor(278),G0tensor(117)])
  call ol_merge_tensors(G2tensor(125),[G2tensor(241),G2tensor(73),G1tensor(265),G1tensor(108),G0tensor(283),G0tensor(126)])
  call ol_merge_tensors(G2tensor(126),[G2tensor(244),G2tensor(74),G1tensor(270),G1tensor(109),G0tensor(288),G0tensor(127)])
  call ol_merge_tensors(G2tensor(130),[G2tensor(247),G2tensor(75),G1tensor(280),G1tensor(118),G0tensor(298),G0tensor(136)])
  call ol_merge_tensors(G2tensor(133),[G2tensor(250),G2tensor(76),G1tensor(285),G1tensor(119),G0tensor(303),G0tensor(137)])
  call ol_merge_tensors(G2tensor(341),[G2tensor(153),G2tensor(77),G1tensor(182),G1tensor(56),G1tensor(13),G0tensor(200) &
    ,G0tensor(53),G0tensor(21)])
  call ol_merge_tensors(G2tensor(23),[G2tensor(78),G1tensor(130),G1tensor(19),G0tensor(148),G0tensor(22)])
  call ol_merge_tensors(G2tensor(314),[G2tensor(150),G2tensor(79),G1tensor(172),G1tensor(32),G1tensor(43),G0tensor(190) &
    ,G0tensor(43),G0tensor(26)])
  call ol_merge_tensors(G2tensor(14),[G2tensor(80),G1tensor(145),G1tensor(49),G0tensor(163),G0tensor(27)])
  call ol_merge_tensors(G2tensor(329),[G2tensor(165),G2tensor(81),G1tensor(217),G1tensor(58),G1tensor(73),G0tensor(235) &
    ,G0tensor(83),G0tensor(31)])
  call ol_merge_tensors(G2tensor(27),[G2tensor(82),G1tensor(155),G1tensor(79),G0tensor(173),G0tensor(32)])
  call ol_merge_tensors(G2tensor(335),[G2tensor(162),G2tensor(83),G1tensor(212),G1tensor(23),G1tensor(12),G0tensor(230) &
    ,G0tensor(73),G0tensor(36)])
  call ol_merge_tensors(G2tensor(377),[G2tensor(84),G1tensor(165),G1tensor(18),G0tensor(183),G0tensor(37)])
  call ol_merge_tensors(G2tensor(332),[G2tensor(156),G2tensor(88),G1tensor(192),G1tensor(27),G0tensor(210),G0tensor(63)])
  call ol_merge_tensors(G2tensor(347),[G2tensor(159),G2tensor(90),G1tensor(202),G1tensor(92),G0tensor(220),G0tensor(68)])
  call ol_merge_tensors(G2tensor(308),[G2tensor(168),G2tensor(96),G1tensor(227),G1tensor(40),G0tensor(245),G0tensor(93)])
  call ol_merge_tensors(G2tensor(87),[G2tensor(171),G2tensor(98),G1tensor(232),G1tensor(53),G0tensor(250),G0tensor(98)])
  call ol_merge_tensors(G3tensor(155),[G3tensor(153),G3tensor(149),G3tensor(147),G3tensor(13),G3tensor(11),G3tensor(10) &
    ,G3tensor(9),G3tensor(7),G3tensor(5),G2tensor(301),G2tensor(295),G2tensor(292),G2tensor(289),G2tensor(283),G2tensor(277) &
    ,G1tensor(392),G1tensor(382),G0tensor(338),G0tensor(328)])
  call ol_merge_tensors(G3tensor(156),[G3tensor(154),G3tensor(150),G3tensor(148),G3tensor(14),G3tensor(12),G3tensor(8),G3tensor(6) &
    ,G2tensor(304),G2tensor(298),G2tensor(286),G2tensor(280),G1tensor(397),G1tensor(387),G0tensor(343),G0tensor(333)])
  call ol_merge_tensors(G3tensor(143),[G3tensor(141),G3tensor(137),G3tensor(135),G3tensor(19),G3tensor(17),G2tensor(319) &
    ,G2tensor(313),G1tensor(402),G0tensor(348)])
  call ol_merge_tensors(G3tensor(144),[G3tensor(142),G3tensor(138),G3tensor(136),G3tensor(20),G3tensor(18),G2tensor(322) &
    ,G2tensor(316),G1tensor(407),G0tensor(353)])
  call ol_merge_tensors(G3tensor(167),[G3tensor(165),G3tensor(161),G3tensor(159),G3tensor(37),G3tensor(35),G3tensor(28) &
    ,G3tensor(27),G3tensor(25),G3tensor(23),G2tensor(373),G2tensor(367),G2tensor(346),G2tensor(343),G2tensor(337),G2tensor(331) &
    ,G1tensor(432),G1tensor(412),G0tensor(378),G0tensor(358)])
  call ol_merge_tensors(G3tensor(168),[G3tensor(166),G3tensor(162),G3tensor(160),G3tensor(38),G3tensor(36),G3tensor(26) &
    ,G3tensor(24),G2tensor(376),G2tensor(370),G2tensor(340),G2tensor(334),G1tensor(437),G1tensor(417),G0tensor(383) &
    ,G0tensor(363)])
  call ol_merge_tensors(G3tensor(179),[G3tensor(177),G3tensor(173),G3tensor(171),G3tensor(31),G3tensor(29),G2tensor(355) &
    ,G2tensor(349),G1tensor(422),G0tensor(368)])
  call ol_merge_tensors(G3tensor(180),[G3tensor(178),G3tensor(174),G3tensor(172),G3tensor(32),G3tensor(30),G2tensor(358) &
    ,G2tensor(352),G1tensor(427),G0tensor(373)])
  call ol_merge_tensors(G2tensor(2),[G2tensor(210),G1tensor(167),G1tensor(133),G1tensor(22),G1tensor(4),G1tensor(54),G1tensor(30) &
    ,G0tensor(185),G0tensor(151),G0tensor(82),G0tensor(72),G0tensor(52),G0tensor(42)])
  call ol_merge_tensors(G2tensor(287),[G2tensor(252),G2tensor(213),G1tensor(359),G1tensor(177),G1tensor(128),G1tensor(66) &
    ,G0tensor(305),G0tensor(195),G0tensor(146),G0tensor(51)])
  call ol_merge_tensors(G2tensor(6),[G2tensor(216),G1tensor(187),G1tensor(51),G1tensor(46),G1tensor(90),G1tensor(80),G0tensor(205) &
    ,G0tensor(97),G0tensor(92),G0tensor(67),G0tensor(62)])
  call ol_merge_tensors(G2tensor(275),[G2tensor(255),G2tensor(219),G1tensor(364),G1tensor(197),G1tensor(57),G0tensor(310) &
    ,G0tensor(215),G0tensor(66)])
  call ol_merge_tensors(G2tensor(278),[G2tensor(270),G2tensor(222),G1tensor(369),G1tensor(207),G1tensor(163),G1tensor(2) &
    ,G0tensor(315),G0tensor(225),G0tensor(181),G0tensor(71)])
  call ol_merge_tensors(G2tensor(296),[G2tensor(273),G2tensor(225),G1tensor(374),G1tensor(222),G1tensor(64),G0tensor(320) &
    ,G0tensor(240),G0tensor(91)])
  call ol_merge_tensors(G2tensor(103),[G2tensor(246),G2tensor(228),G1tensor(277),G1tensor(237),G1tensor(223),G1tensor(198) &
    ,G1tensor(188),G1tensor(113),G1tensor(65),G0tensor(295),G0tensor(255),G0tensor(241),G0tensor(216),G0tensor(206),G0tensor(131) &
    ,G0tensor(101)])
  call ol_merge_tensors(G2tensor(50),[G2tensor(231),G1tensor(242),G1tensor(193),G1tensor(71),G0tensor(260),G0tensor(211) &
    ,G0tensor(102)])
  call ol_merge_tensors(G2tensor(101),[G2tensor(240),G2tensor(234),G1tensor(262),G1tensor(252),G1tensor(208),G1tensor(178) &
    ,G1tensor(168),G1tensor(103),G1tensor(95),G0tensor(280),G0tensor(270),G0tensor(226),G0tensor(196),G0tensor(186),G0tensor(121) &
    ,G0tensor(111)])
  call ol_merge_tensors(G2tensor(43),[G2tensor(237),G1tensor(257),G1tensor(173),G1tensor(89),G0tensor(275),G0tensor(191) &
    ,G0tensor(112)])
  call ol_merge_tensors(G2tensor(176),[G2tensor(243),G1tensor(267),G1tensor(218),G1tensor(104),G0tensor(285),G0tensor(236) &
    ,G0tensor(122)])
  call ol_merge_tensors(G2tensor(105),[G2tensor(249),G1tensor(282),G1tensor(233),G1tensor(114),G0tensor(300),G0tensor(251) &
    ,G0tensor(132)])
  call ol_merge_tensors(G3tensor(53),[G3tensor(49),G2tensor(291),G2tensor(288),G2tensor(282),G2tensor(276),G1tensor(400) &
    ,G1tensor(379),G0tensor(346),G0tensor(325)])
  call ol_merge_tensors(G3tensor(55),[G3tensor(51),G2tensor(285),G2tensor(279),G1tensor(405),G1tensor(384),G0tensor(351) &
    ,G0tensor(330)])
  call ol_merge_tensors(G3tensor(73),[G3tensor(71),G3tensor(67),G3tensor(63),G2tensor(300),G2tensor(294),G1tensor(389) &
    ,G0tensor(335)])
  call ol_merge_tensors(G3tensor(69),[G3tensor(65),G2tensor(303),G2tensor(297),G1tensor(394),G0tensor(340)])
  call ol_merge_tensors(G3tensor(80),[G3tensor(79),G3tensor(77),G3tensor(75),G2tensor(318),G2tensor(312),G1tensor(399) &
    ,G0tensor(345)])
  call ol_merge_tensors(G3tensor(78),[G3tensor(76),G2tensor(321),G2tensor(315),G1tensor(404),G0tensor(350)])
  call ol_merge_tensors(G3tensor(85),[G3tensor(81),G2tensor(345),G2tensor(342),G2tensor(336),G2tensor(330),G1tensor(420) &
    ,G1tensor(409),G0tensor(366),G0tensor(355)])
  call ol_merge_tensors(G3tensor(87),[G3tensor(83),G2tensor(339),G2tensor(333),G1tensor(425),G1tensor(414),G0tensor(371) &
    ,G0tensor(360)])
  call ol_merge_tensors(G3tensor(100),[G3tensor(99),G3tensor(97),G3tensor(95),G2tensor(354),G2tensor(348),G1tensor(419) &
    ,G0tensor(365)])
  call ol_merge_tensors(G3tensor(98),[G3tensor(96),G2tensor(357),G2tensor(351),G1tensor(424),G0tensor(370)])
  call ol_merge_tensors(G3tensor(106),[G3tensor(105),G3tensor(103),G3tensor(101),G2tensor(372),G2tensor(366),G1tensor(429) &
    ,G0tensor(375)])
  call ol_merge_tensors(G3tensor(104),[G3tensor(102),G2tensor(375),G2tensor(369),G1tensor(434),G0tensor(380)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(127),G1tensor(124),G0tensor(145),G0tensor(142)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(164),G1tensor(154),G1tensor(144),G1tensor(134),G1tensor(129),G0tensor(182) &
    ,G0tensor(172),G0tensor(162),G0tensor(152),G0tensor(147)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(142),G1tensor(139),G0tensor(160),G0tensor(157)])
  call ol_merge_tensors(G2tensor(323),[G1tensor(152),G1tensor(149),G0tensor(170),G0tensor(167)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(162),G1tensor(159),G0tensor(180),G0tensor(177)])
  call ol_merge_tensors(G2tensor(46),[G1tensor(219),G1tensor(214),G1tensor(184),G1tensor(174),G1tensor(169),G0tensor(237) &
    ,G0tensor(232),G0tensor(202),G0tensor(192),G0tensor(187)])
  call ol_merge_tensors(G2tensor(47),[G1tensor(183),G1tensor(179),G0tensor(201),G0tensor(197)])
  call ol_merge_tensors(G2tensor(51),[G1tensor(234),G1tensor(229),G1tensor(204),G1tensor(194),G1tensor(189),G0tensor(252) &
    ,G0tensor(247),G0tensor(222),G0tensor(212),G0tensor(207)])
  call ol_merge_tensors(G2tensor(54),[G1tensor(203),G1tensor(199),G0tensor(221),G0tensor(217)])
  call ol_merge_tensors(G2tensor(55),[G1tensor(213),G1tensor(209),G0tensor(231),G0tensor(227)])
  call ol_merge_tensors(G2tensor(188),[G1tensor(228),G1tensor(224),G0tensor(246),G0tensor(242)])
  call ol_merge_tensors(G2tensor(102),[G1tensor(243),G1tensor(238),G0tensor(261),G0tensor(256)])
  call ol_merge_tensors(G3tensor(108),[G3tensor(107),G1tensor(254),G1tensor(248),G1tensor(239),G0tensor(272),G0tensor(266) &
    ,G0tensor(257)])
  call ol_merge_tensors(G3tensor(62),[G3tensor(59),G1tensor(259),G1tensor(249),G1tensor(244),G0tensor(277),G0tensor(267) &
    ,G0tensor(262)])
  call ol_merge_tensors(G3tensor(110),[G3tensor(109),G1tensor(279),G1tensor(273),G1tensor(264),G0tensor(297),G0tensor(291) &
    ,G0tensor(282)])
  call ol_merge_tensors(G3tensor(94),[G3tensor(91),G1tensor(284),G1tensor(274),G1tensor(269),G0tensor(302),G0tensor(292) &
    ,G0tensor(287)])
  call ol_merge_tensors(G2tensor(106),[G1tensor(283),G1tensor(278),G0tensor(301),G0tensor(296)])
  call ol_merge_tensors(G1tensor(312),[G1tensor(287)])
  call ol_merge_tensors(G1tensor(302),[G1tensor(290)])
  call ol_merge_tensors(G1tensor(316),[G1tensor(291)])
  call ol_merge_tensors(G1tensor(306),[G1tensor(294)])
  call ol_merge_tensors(G1tensor(320),[G1tensor(295)])
  call ol_merge_tensors(G1tensor(310),[G1tensor(298)])
  call ol_merge_tensors(G1tensor(349),[G1tensor(337),G1tensor(313),G1tensor(301)])
  call ol_merge_tensors(G1tensor(353),[G1tensor(341),G1tensor(317),G1tensor(305)])
  call ol_merge_tensors(G1tensor(357),[G1tensor(345),G1tensor(321),G1tensor(309)])
  call ol_merge_tensors(G1tensor(336),[G1tensor(323)])
  call ol_merge_tensors(G1tensor(350),[G1tensor(326)])
  call ol_merge_tensors(G1tensor(340),[G1tensor(327)])
  call ol_merge_tensors(G1tensor(354),[G1tensor(330)])
  call ol_merge_tensors(G1tensor(344),[G1tensor(331)])
  call ol_merge_tensors(G1tensor(358),[G1tensor(334)])
  call ol_merge_tensors(G2tensor(109),[G1tensor(360),G0tensor(306)])
  call ol_merge_tensors(G2tensor(110),[G1tensor(361),G0tensor(307)])
  call ol_merge_tensors(G2tensor(113),[G1tensor(365),G0tensor(311)])
  call ol_merge_tensors(G2tensor(115),[G1tensor(366),G0tensor(312)])
  call ol_merge_tensors(G2tensor(134),[G1tensor(370),G0tensor(316)])
  call ol_merge_tensors(G2tensor(137),[G1tensor(371),G0tensor(317)])
  call ol_merge_tensors(G2tensor(139),[G1tensor(375),G0tensor(321)])
  call ol_merge_tensors(G2tensor(140),[G1tensor(376),G0tensor(322)])
  call ol_merge_tensors(G3tensor(116),[G3tensor(115),G3tensor(113),G3tensor(111),G1tensor(380),G0tensor(326)])
  call ol_merge_tensors(G3tensor(60),[G3tensor(57),G3tensor(54),G3tensor(50),G1tensor(381),G0tensor(327)])
  call ol_merge_tensors(G3tensor(114),[G3tensor(112),G1tensor(385),G0tensor(331)])
  call ol_merge_tensors(G3tensor(56),[G3tensor(52),G1tensor(386),G0tensor(332)])
  call ol_merge_tensors(G3tensor(119),[G3tensor(117),G1tensor(390),G0tensor(336)])
  call ol_merge_tensors(G3tensor(68),[G3tensor(64),G1tensor(431),G1tensor(421),G1tensor(401),G1tensor(391),G0tensor(377) &
    ,G0tensor(367),G0tensor(347),G0tensor(337)])
  call ol_merge_tensors(G3tensor(120),[G3tensor(118),G1tensor(395),G0tensor(341)])
  call ol_merge_tensors(G3tensor(70),[G3tensor(66),G1tensor(436),G1tensor(426),G1tensor(406),G1tensor(396),G0tensor(382) &
    ,G0tensor(372),G0tensor(352),G0tensor(342)])
  call ol_merge_tensors(G3tensor(128),[G3tensor(127),G3tensor(125),G3tensor(123),G1tensor(410),G0tensor(356)])
  call ol_merge_tensors(G3tensor(92),[G3tensor(89),G3tensor(86),G3tensor(82),G1tensor(411),G0tensor(357)])
  call ol_merge_tensors(G3tensor(126),[G3tensor(124),G1tensor(415),G0tensor(361)])
  call ol_merge_tensors(G3tensor(88),[G3tensor(84),G1tensor(416),G0tensor(362)])
  call ol_merge_tensors(G3tensor(131),[G3tensor(129),G1tensor(430),G0tensor(376)])
  call ol_merge_tensors(G3tensor(132),[G3tensor(130),G1tensor(435),G0tensor(381)])
  call ol_merge_tensors(G2tensor(91),[G2tensor(266),G2tensor(263),G2tensor(257),G2tensor(260),G2tensor(97),G2tensor(362) &
    ,G2tensor(380),G2tensor(89),G2tensor(326),G2tensor(145),G2tensor(121),G2tensor(368),G2tensor(350)])
  call TI_triangle_red(G3tensor(43),RedBasis(96),mass3set(:,1),G0tensor(19),G0tensor(24),G0tensor(29),G0tensor(34),M2L1R1,[nMB], &
    G0tensor(39))
  call TI_triangle_red(G3tensor(44),RedBasis(94),mass3set(:,1),G0tensor(44),G0tensor(49),G0tensor(54),G0tensor(59),M2L1R1,[nMB], &
    G0tensor(64))
  call TI_triangle_red(G3tensor(47),RedBasis(100),mass3set(:,1),G0tensor(69),G0tensor(74),G0tensor(79),G0tensor(84),M2L1R1,[nMB], &
    G0tensor(89))
  call TI_triangle_red(G3tensor(48),RedBasis(98),mass3set(:,1),G0tensor(94),G0tensor(99),G0tensor(104),G0tensor(109),M2L1R1,[nMB], &
    G0tensor(114))
  call TI_triangle_red(G2tensor(281),RedBasis(85),mass3set(:,2),G0tensor(119),G0tensor(124),G0tensor(129), &
    G0tensor(134),M2L1R1,[nMB],G0tensor(139))
  call TI_triangle_red(G2tensor(143),RedBasis(21),mass3set(:,2),G0tensor(144),G0tensor(149),G0tensor(154), &
    G0tensor(159),M2L1R1,[nMB],G0tensor(164))
  call TI_triangle_red(G2tensor(293),RedBasis(32),mass3set(:,2),G0tensor(169),G0tensor(174),G0tensor(179), &
    G0tensor(184),M2L1R1,[nMB],G0tensor(189))
  call TI_triangle_red(G2tensor(311),RedBasis(91),mass3set(:,2),G0tensor(194),G0tensor(199),G0tensor(204), &
    G0tensor(209),M2L1R1,[nMB],G0tensor(214))
  call TI_triangle_red(G2tensor(42),RedBasis(92),mass3set(:,3),G0tensor(219),G0tensor(224),G0tensor(229), &
    G0tensor(234),M2L1R1,[nMB],G0tensor(239))
  call TI_triangle_red(G2tensor(1),RedBasis(14),mass3set(:,4),G0tensor(244),G0tensor(249),G0tensor(254), &
    G0tensor(259),M2L1R1,[nMB],G0tensor(264))
  call TI_triangle_red(G2tensor(305),RedBasis(107),mass3set(:,3),G0tensor(269),G0tensor(274),G0tensor(279), &
    G0tensor(284),M2L1R1,[nMB],G0tensor(289))
  call TI_triangle_red(G2tensor(11),RedBasis(42),mass3set(:,3),G0tensor(294),G0tensor(299),G0tensor(1),G0tensor(2),M2L1R1,[nMB], &
    G0tensor(3))
  call TI_triangle_red(G2tensor(35),RedBasis(47),mass3set(:,3),G0tensor(4),G0tensor(5),G0tensor(6),G0tensor(7),M2L1R1,[nMB], &
    G0tensor(8))
  call TI_triangle_red(G2tensor(26),RedBasis(108),mass3set(:,3),G0tensor(9),G0tensor(10),G0tensor(11),G0tensor(12),M2L1R1,[nMB], &
    G0tensor(13))
  call TI_triangle_red(G3tensor(61),RedBasis(4),mass3set(:,1),G0tensor(14),G0tensor(15),G0tensor(16),G0tensor(17),M2L1R1,[nMB], &
    G0tensor(18))
  call TI_triangle_red(G3tensor(74),RedBasis(2),mass3set(:,1),G0tensor(304),G0tensor(309),G0tensor(314), &
    G0tensor(319),M2L1R1,[nMB],G0tensor(324))
  call TI_triangle_red(G3tensor(146),RedBasis(1),mass3set(:,1),G0tensor(329),G0tensor(334),G0tensor(339), &
    G0tensor(344),M2L1R1,[nMB],G0tensor(349))
  call TI_triangle_red(G3tensor(122),RedBasis(8),mass3set(:,1),G0tensor(354),G0tensor(359),G0tensor(364), &
    G0tensor(369),M2L1R1,[nMB],G0tensor(374))
  call TI_triangle_red(G3tensor(158),RedBasis(7),mass3set(:,1),G0tensor(379),G0tensor(156),G0tensor(60),G0tensor(45),M2L1R1,[nMB], &
    G0tensor(40))
  call TI_triangle_red(G3tensor(134),RedBasis(23),mass3set(:,1),G0tensor(141),G0tensor(65),G0tensor(55),G0tensor(50),M2L1R1,[nMB], &
    G0tensor(176))
  call TI_triangle_red(G3tensor(170),RedBasis(22),mass3set(:,1),G0tensor(90),G0tensor(75),G0tensor(70),G0tensor(166),M2L1R1,[nMB], &
    G0tensor(95))
  call TI_triangle_red(G3tensor(93),RedBasis(26),mass3set(:,1),G0tensor(85),G0tensor(80),G0tensor(105),G0tensor(100),M2L1R1,[nMB], &
    G0tensor(61))
  call TI_triangle_red(G3tensor(182),RedBasis(25),mass3set(:,1),G0tensor(161),G0tensor(115),G0tensor(110), &
    G0tensor(41),M2L1R1,[nMB],G0tensor(171))
  call TI_triangle_red(G2tensor(129),RedBasis(37),mass3set(:,5),G0tensor(125),G0tensor(120),G0tensor(81), &
    G0tensor(135),M2L1R1,[nMB],G0tensor(130))
  call TI_triangle_red(G2tensor(127),RedBasis(15),mass3set(:,5),G0tensor(96),G0tensor(178),G0tensor(168), &
    G0tensor(158),M2L1R1,[nMB],G0tensor(150))
  call TI_triangle_red(G2tensor(116),RedBasis(41),mass3set(:,5),G0tensor(143),G0tensor(153),G0tensor(38), &
    G0tensor(33),M2L1R1,[nMB],G0tensor(28))
  call TI_triangle_red(G2tensor(119),RedBasis(40),mass3set(:,5),G0tensor(23),G0tensor(140),G0tensor(20), &
    G0tensor(276),M2L1R1,[nMB],G0tensor(271))
  call TI_triangle_red(G2tensor(125),RedBasis(45),mass3set(:,5),G0tensor(155),G0tensor(25),G0tensor(286), &
    G0tensor(281),M2L1R1,[nMB],G0tensor(165))
  call TI_triangle_red(G2tensor(126),RedBasis(43),mass3set(:,5),G0tensor(30),G0tensor(175),G0tensor(35), &
    G0tensor(265),M2L1R1,[nMB],G0tensor(113))
  call TI_triangle_red(G2tensor(130),RedBasis(48),mass3set(:,5),G0tensor(103),G0tensor(46),G0tensor(208), &
    G0tensor(188),M2L1R1,[nMB],G0tensor(87))
  call TI_triangle_red(G2tensor(133),RedBasis(33),mass3set(:,5),G0tensor(77),G0tensor(57),G0tensor(47),G0tensor(313),M2L1R1,[nMB], &
    G0tensor(308))
  call TI_triangle_red(G2tensor(341),RedBasis(16),mass3set(:,2),G0tensor(213),G0tensor(193),G0tensor(48), &
    G0tensor(218),M2L1R1,[nMB],G0tensor(198))
  call TI_triangle_red(G2tensor(23),RedBasis(15),mass3set(:,4),G0tensor(56),G0tensor(268),G0tensor(223), &
    G0tensor(203),M2L1R1,[nMB],G0tensor(118))
  call TI_triangle_red(G2tensor(314),RedBasis(20),mass3set(:,2),G0tensor(108),G0tensor(58),G0tensor(243), &
    G0tensor(228),M2L1R1,[nMB],G0tensor(76))
  call TI_triangle_red(G2tensor(14),RedBasis(19),mass3set(:,4),G0tensor(293),G0tensor(248),G0tensor(233), &
    G0tensor(138),M2L1R1,[nMB],G0tensor(128))
  call TI_triangle_red(G2tensor(329),RedBasis(31),mass3set(:,2),G0tensor(78),G0tensor(290),G0tensor(133), &
    G0tensor(123),M2L1R1,[nMB],G0tensor(86))
  call TI_triangle_red(G2tensor(27),RedBasis(30),mass3set(:,4),G0tensor(323),G0tensor(318),G0tensor(253), &
    G0tensor(238),M2L1R1,[nMB],G0tensor(88))
  call TI_triangle_red(G2tensor(335),RedBasis(34),mass3set(:,2),G0tensor(258),G0tensor(106),G0tensor(263), &
    G0tensor(107),M2L1R1,[nMB],G0tensor(273))
  call TI_triangle_red(G2tensor(377),RedBasis(33),mass3set(:,4),G0tensor(116),G0tensor(278),G0tensor(117), &
    G0tensor(283),M2L1R1,[nMB],G0tensor(126))
  call TI_triangle_red(G2tensor(332),RedBasis(83),mass3set(:,2),G0tensor(288),G0tensor(127),G0tensor(298), &
    G0tensor(136),M2L1R1,[nMB],G0tensor(303))
  call TI_triangle_red(G2tensor(347),RedBasis(86),mass3set(:,2),G0tensor(137),G0tensor(200),G0tensor(53), &
    G0tensor(21),M2L1R1,[nMB],G0tensor(148))
  call TI_triangle_red(G2tensor(308),RedBasis(88),mass3set(:,2),G0tensor(22),G0tensor(190),G0tensor(43),G0tensor(26),M2L1R1,[nMB], &
    G0tensor(163))
  call TI_triangle_red(G2tensor(87),RedBasis(90),mass3set(:,2),G0tensor(27),G0tensor(235),G0tensor(83),G0tensor(31),M2L1R1,[nMB], &
    G0tensor(173))
  call TI_triangle_red(G3tensor(155),RedBasis(7),mass3set(:,6),G0tensor(32),G0tensor(230),G0tensor(73),G0tensor(36),M2L1R1)
  call TI_triangle_red(G3tensor(156),RedBasis(7),mass3set(:,7),G0tensor(183),G0tensor(37),G0tensor(210),G0tensor(63),M2L1R1,[nMT], &
    G0tensor(220))
  call TI_triangle_red(G3tensor(143),RedBasis(1),mass3set(:,6),G0tensor(68),G0tensor(245),G0tensor(93),G0tensor(250),M2L1R1)
  call TI_triangle_red(G3tensor(144),RedBasis(1),mass3set(:,7),G0tensor(98),G0tensor(338),G0tensor(328), &
    G0tensor(343),M2L1R1,[nMT],G0tensor(333))
  call TI_triangle_red(G3tensor(167),RedBasis(22),mass3set(:,6),G0tensor(348),G0tensor(353),G0tensor(378),G0tensor(358),M2L1R1)
  call TI_triangle_red(G3tensor(168),RedBasis(22),mass3set(:,7),G0tensor(383),G0tensor(363),G0tensor(368), &
    G0tensor(373),M2L1R1,[nMT],G0tensor(185))
  call TI_triangle_red(G3tensor(179),RedBasis(25),mass3set(:,6),G0tensor(151),G0tensor(82),G0tensor(72),G0tensor(52),M2L1R1)
  call TI_triangle_red(G3tensor(180),RedBasis(25),mass3set(:,7),G0tensor(42),G0tensor(305),G0tensor(195), &
    G0tensor(146),M2L1R1,[nMT],G0tensor(51))
  call TI_triangle_red(G2tensor(2),RedBasis(17),mass3set(:,2),G0tensor(205),G0tensor(97),G0tensor(92),G0tensor(67),M2L1R1,[nMB], &
    G0tensor(62))
  call TI_triangle_red(G2tensor(287),RedBasis(18),mass3set(:,2),G0tensor(310),G0tensor(215),G0tensor(66), &
    G0tensor(315),M2L1R1,[nMB],G0tensor(225))
  call TI_triangle_red(G2tensor(6),RedBasis(84),mass3set(:,2),G0tensor(181),G0tensor(71),G0tensor(320),G0tensor(240),M2L1R1,[nMB], &
    G0tensor(91))
  call TI_triangle_red(G2tensor(275),RedBasis(87),mass3set(:,2),G0tensor(295),G0tensor(255),G0tensor(241), &
    G0tensor(216),M2L1R1,[nMB],G0tensor(206))
  call TI_triangle_red(G2tensor(278),RedBasis(35),mass3set(:,2),G0tensor(131),G0tensor(101),G0tensor(260), &
    G0tensor(211),M2L1R1,[nMB],G0tensor(102))
  call TI_triangle_red(G2tensor(296),RedBasis(89),mass3set(:,2),G0tensor(280),G0tensor(270),G0tensor(226), &
    G0tensor(196),M2L1R1,[nMB],G0tensor(186))
  call TI_triangle_red(G2tensor(103),RedBasis(12),mass3set(:,5),G0tensor(121),G0tensor(111),G0tensor(275), &
    G0tensor(191),M2L1R1,[nMB],G0tensor(112))
  call TI_triangle_red(G2tensor(50),RedBasis(11),mass3set(:,5),G0tensor(285),G0tensor(236),G0tensor(122), &
    G0tensor(300),M2L1R1,[nMB],G0tensor(251))
  call TI_triangle_red(G2tensor(101),RedBasis(6),mass3set(:,5),G0tensor(132),G0tensor(346),G0tensor(325), &
    G0tensor(351),M2L1R1,[nMB],G0tensor(330))
  call TI_triangle_red(G2tensor(43),RedBasis(5),mass3set(:,5),G0tensor(335),G0tensor(340),G0tensor(345), &
    G0tensor(350),M2L1R1,[nMB],G0tensor(366))
  call TI_triangle_red(G2tensor(176),RedBasis(27),mass3set(:,5),G0tensor(355),G0tensor(371),G0tensor(360), &
    G0tensor(365),M2L1R1,[nMB],G0tensor(370))
  call TI_triangle_red(G2tensor(105),RedBasis(29),mass3set(:,5),G0tensor(375),G0tensor(380),G0tensor(145), &
    G0tensor(142),M2L1R1,[nMB],G0tensor(182))
  call TI_triangle_red(G3tensor(53),RedBasis(4),mass3set(:,6),G0tensor(172),G0tensor(162),G0tensor(152),G0tensor(147),M2L1R1)
  call TI_triangle_red(G3tensor(55),RedBasis(4),mass3set(:,7),G0tensor(160),G0tensor(157),G0tensor(170), &
    G0tensor(167),M2L1R1,[nMT],G0tensor(180))
  call TI_triangle_red(G3tensor(73),RedBasis(94),mass3set(:,6),G0tensor(177),G0tensor(237),G0tensor(232),G0tensor(202),M2L1R1)
  call TI_triangle_red(G3tensor(69),RedBasis(94),mass3set(:,7),G0tensor(192),G0tensor(187),G0tensor(201), &
    G0tensor(197),M2L1R1,[nMT],G0tensor(252))
  call TI_triangle_red(G3tensor(80),RedBasis(96),mass3set(:,6),G0tensor(247),G0tensor(222),G0tensor(212),G0tensor(207),M2L1R1)
  call TI_triangle_red(G3tensor(78),RedBasis(96),mass3set(:,7),G0tensor(221),G0tensor(217),G0tensor(231), &
    G0tensor(227),M2L1R1,[nMT],G0tensor(246))
  call TI_triangle_red(G3tensor(85),RedBasis(26),mass3set(:,6),G0tensor(242),G0tensor(261),G0tensor(256),G0tensor(272),M2L1R1)
  call TI_triangle_red(G3tensor(87),RedBasis(26),mass3set(:,7),G0tensor(266),G0tensor(257),G0tensor(277), &
    G0tensor(267),M2L1R1,[nMT],G0tensor(262))
  call TI_triangle_red(G3tensor(100),RedBasis(98),mass3set(:,6),G0tensor(297),G0tensor(291),G0tensor(282),G0tensor(302),M2L1R1)
  call TI_triangle_red(G3tensor(98),RedBasis(98),mass3set(:,7),G0tensor(292),G0tensor(287),G0tensor(301), &
    G0tensor(296),M2L1R1,[nMT],G0tensor(306))
  call TI_triangle_red(G3tensor(106),RedBasis(100),mass3set(:,6),G0tensor(307),G0tensor(311),G0tensor(312),G0tensor(316),M2L1R1)
  call TI_triangle_red(G3tensor(104),RedBasis(100),mass3set(:,7),G0tensor(317),G0tensor(321),G0tensor(322), &
    G0tensor(326),M2L1R1,[nMT],G0tensor(327))
  call TI_triangle_red(G2tensor(8),RedBasis(93),mass3set(:,3),G0tensor(331),G0tensor(332),G0tensor(336), &
    G0tensor(377),M2L1R1,[nMB],G0tensor(367))
  call TI_triangle_red(G2tensor(4),RedBasis(10),mass3set(:,4),G0tensor(347),G0tensor(337),G0tensor(341), &
    G0tensor(382),M2L1R1,[nMB],G0tensor(372))
  call TI_triangle_red(G2tensor(10),RedBasis(95),mass3set(:,3),G0tensor(352),G0tensor(342),G0tensor(356), &
    G0tensor(357),M2L1R1,[nMB],G0tensor(361))
  call TI_triangle_red(G2tensor(323),RedBasis(97),mass3set(:,3),G0tensor(362),G0tensor(376),G0tensor(381), &
    G0tensor(384),M2L1R1,[nMB],G0tensor(385))
  call TI_triangle_red(G2tensor(19),RedBasis(99),mass3set(:,3),G0tensor(386),G0tensor(387),G0tensor(388), &
    G0tensor(389),M2L1R1,[nMB],G0tensor(390))
  call TI_triangle_red(G2tensor(46),RedBasis(3),mass3set(:,5),G0tensor(391),G0tensor(392),G0tensor(393), &
    G0tensor(394),M2L1R1,[nMB],G0tensor(395))
  call TI_triangle_red(G2tensor(47),RedBasis(9),mass3set(:,5),G0tensor(396),G0tensor(397),G0tensor(398), &
    G0tensor(399),M2L1R1,[nMB],G0tensor(400))
  call TI_triangle_red(G2tensor(51),RedBasis(10),mass3set(:,5),G0tensor(401),G0tensor(402),G0tensor(403), &
    G0tensor(404),M2L1R1,[nMB],G0tensor(405))
  call TI_triangle_red(G2tensor(54),RedBasis(13),mass3set(:,5),G0tensor(406),G0tensor(407),G0tensor(408), &
    G0tensor(409),M2L1R1,[nMB],G0tensor(410))
  call TI_triangle_red(G2tensor(55),RedBasis(24),mass3set(:,5),G0tensor(411),G0tensor(412),G0tensor(413), &
    G0tensor(414),M2L1R1,[nMB],G0tensor(415))
  call TI_triangle_red(G2tensor(188),RedBasis(28),mass3set(:,5),G0tensor(416),G0tensor(417),G0tensor(418), &
    G0tensor(419),M2L1R1,[nMB],G0tensor(420))
  call TI_triangle_red(G2tensor(102),RedBasis(39),mass3set(:,3),G0tensor(421),G0tensor(422),G0tensor(423), &
    G0tensor(424),M2L1R1,[nMB],G0tensor(425))
  call TI_triangle_red(G3tensor(108),RedBasis(38),mass3set(:,1),G0tensor(426),G0tensor(427),G0tensor(428), &
    G0tensor(429),M2L1R1,[nMB],G0tensor(430))
  call TI_triangle_red(G3tensor(62),RedBasis(36),mass3set(:,1),G0tensor(431),G0tensor(432),G0tensor(433), &
    G0tensor(434),M2L1R1,[nMB],G0tensor(435))
  call TI_triangle_red(G3tensor(110),RedBasis(46),mass3set(:,1),G0tensor(436),G0tensor(437),G0tensor(438), &
    G0tensor(439),M2L1R1,[nMB],G0tensor(440))
  call TI_triangle_red(G3tensor(94),RedBasis(44),mass3set(:,1),G0tensor(441),G0tensor(442),G0tensor(443), &
    G0tensor(444),M2L1R1,[nMB],G0tensor(445))
  call TI_triangle_red(G2tensor(106),RedBasis(49),mass3set(:,3),G0tensor(446),G0tensor(447),G0tensor(448), &
    G0tensor(449),M2L1R1,[nMB],G0tensor(450))
  call TI_triangle_red(G2tensor(109),RedBasis(102),mass3set(:,5),G0tensor(451),G0tensor(452),G0tensor(453), &
    G0tensor(454),M2L1R1,[nMB],G0tensor(455))
  call TI_triangle_red(G2tensor(110),RedBasis(101),mass3set(:,5),G0tensor(456),G0tensor(457),G0tensor(458), &
    G0tensor(459),M2L1R1,[nMB],G0tensor(460))
  call TI_triangle_red(G2tensor(113),RedBasis(103),mass3set(:,5),G0tensor(461),G0tensor(462),G0tensor(463), &
    G0tensor(464),M2L1R1,[nMB],G0tensor(465))
  call TI_triangle_red(G2tensor(115),RedBasis(19),mass3set(:,5),G0tensor(466),G0tensor(467),G0tensor(468), &
    G0tensor(469),M2L1R1,[nMB],G0tensor(470))
  call TI_triangle_red(G2tensor(134),RedBasis(105),mass3set(:,5),G0tensor(471),G0tensor(472),G0tensor(473), &
    G0tensor(474),M2L1R1,[nMB],G0tensor(475))
  call TI_triangle_red(G2tensor(137),RedBasis(104),mass3set(:,5),G0tensor(476),G0tensor(477),G0tensor(478), &
    G0tensor(479),M2L1R1,[nMB],G0tensor(480))
  call TI_triangle_red(G2tensor(139),RedBasis(106),mass3set(:,5),G0tensor(481),G0tensor(482),G0tensor(483), &
    G0tensor(484),M2L1R1,[nMB],G0tensor(485))
  call TI_triangle_red(G2tensor(140),RedBasis(30),mass3set(:,5),G0tensor(486),G0tensor(487),G0tensor(488), &
    G0tensor(489),M2L1R1,[nMB],G0tensor(490))
  call TI_triangle_red(G3tensor(116),RedBasis(38),mass3set(:,6),G0tensor(491),G0tensor(492),G0tensor(493),G0tensor(494),M2L1R1)
  call TI_triangle_red(G3tensor(60),RedBasis(36),mass3set(:,6),G0tensor(495),G0tensor(496),G0tensor(497),G0tensor(498),M2L1R1)
  call TI_triangle_red(G3tensor(114),RedBasis(38),mass3set(:,7),G0tensor(499),G0tensor(500),G0tensor(501), &
    G0tensor(502),M2L1R1,[nMT],G0tensor(503))
  call TI_triangle_red(G3tensor(56),RedBasis(36),mass3set(:,7),G0tensor(504),G0tensor(505),G0tensor(506), &
    G0tensor(507),M2L1R1,[nMT],G0tensor(508))
  call TI_triangle_red(G3tensor(119),RedBasis(8),mass3set(:,6),G0tensor(509),G0tensor(510),G0tensor(511),G0tensor(512),M2L1R1)
  call TI_triangle_red(G3tensor(68),RedBasis(2),mass3set(:,6),G0tensor(513),G0tensor(514),G0tensor(515),G0tensor(516),M2L1R1)
  call TI_triangle_red(G3tensor(120),RedBasis(8),mass3set(:,7),G0tensor(517),G0tensor(518),G0tensor(519), &
    G0tensor(520),M2L1R1,[nMT],G0tensor(521))
  call TI_triangle_red(G3tensor(70),RedBasis(2),mass3set(:,7),G0tensor(522),G0tensor(523),G0tensor(524), &
    G0tensor(525),M2L1R1,[nMT],G0tensor(526))
  call TI_triangle_red(G3tensor(128),RedBasis(46),mass3set(:,6),G0tensor(527),G0tensor(528),G0tensor(529),G0tensor(530),M2L1R1)
  call TI_triangle_red(G3tensor(92),RedBasis(44),mass3set(:,6),G0tensor(531),G0tensor(532),G0tensor(533),G0tensor(534),M2L1R1)
  call TI_triangle_red(G3tensor(126),RedBasis(46),mass3set(:,7),G0tensor(535),G0tensor(536),G0tensor(537), &
    G0tensor(538),M2L1R1,[nMT],G0tensor(539))
  call TI_triangle_red(G3tensor(88),RedBasis(44),mass3set(:,7),G0tensor(540),G0tensor(541),G0tensor(542), &
    G0tensor(543),M2L1R1,[nMT],G0tensor(544))
  call TI_triangle_red(G3tensor(131),RedBasis(23),mass3set(:,6),G0tensor(545),G0tensor(546),G0tensor(547),G0tensor(548),M2L1R1)
  call TI_triangle_red(G3tensor(132),RedBasis(23),mass3set(:,7),G0tensor(549),G0tensor(550),G0tensor(551), &
    G0tensor(552),M2L1R1,[nMT],G0tensor(553))
  call TI_triangle_red(G2tensor(91),RedBasis(14),mass3set(:,5),G0tensor(554),G0tensor(555),G0tensor(556), &
    G0tensor(557),M2L1R1,[nMB],G0tensor(558))
  call ol_merge_tensors(T0sum(92),[G0tensor(19)])
  call ol_merge_tensors(T0sum(93),[G0tensor(44)])
  call ol_merge_tensors(T0sum(94),[G0tensor(69)])
  call ol_merge_tensors(T0sum(95),[G0tensor(94)])
  call ol_merge_tensors(T0sum(96),[G0tensor(119)])
  call ol_merge_tensors(T0sum(97),[G0tensor(144)])
  call ol_merge_tensors(T0sum(98),[G0tensor(169)])
  call ol_merge_tensors(T0sum(99),[G0tensor(194)])
  call ol_merge_tensors(T0sum(100),[G0tensor(219)])
  call ol_merge_tensors(T0sum(101),[G0tensor(244)])
  call ol_merge_tensors(T0sum(102),[G0tensor(269)])
  call ol_merge_tensors(T0sum(103),[G0tensor(294)])
  call ol_merge_tensors(T0sum(104),[G0tensor(4)])
  call ol_merge_tensors(T0sum(105),[G0tensor(9)])
  call ol_merge_tensors(T0sum(106),[G0tensor(14)])
  call ol_merge_tensors(T0sum(107),[G0tensor(304)])
  call ol_merge_tensors(T0sum(108),[G0tensor(329)])
  call ol_merge_tensors(T0sum(109),[G0tensor(354)])
  call ol_merge_tensors(T0sum(110),[G0tensor(379)])
  call ol_merge_tensors(T0sum(111),[G0tensor(141)])
  call ol_merge_tensors(T0sum(112),[G0tensor(90)])
  call ol_merge_tensors(T0sum(113),[G0tensor(85)])
  call ol_merge_tensors(T0sum(114),[G0tensor(161)])
  call ol_merge_tensors(T0sum(115),[G0tensor(125)])
  call ol_merge_tensors(T0sum(116),[G0tensor(96)])
  call ol_merge_tensors(T0sum(117),[G0tensor(143)])
  call ol_merge_tensors(T0sum(118),[G0tensor(23)])
  call ol_merge_tensors(T0sum(119),[G0tensor(155)])
  call ol_merge_tensors(T0sum(120),[G0tensor(30)])
  call ol_merge_tensors(T0sum(121),[G0tensor(103)])
  call ol_merge_tensors(T0sum(122),[G0tensor(77)])
  call ol_merge_tensors(T0sum(123),[G0tensor(213)])
  call ol_merge_tensors(T0sum(124),[G0tensor(56)])
  call ol_merge_tensors(T0sum(125),[G0tensor(108)])
  call ol_merge_tensors(T0sum(126),[G0tensor(293)])
  call ol_merge_tensors(T0sum(127),[G0tensor(78)])
  call ol_merge_tensors(T0sum(128),[G0tensor(323)])
  call ol_merge_tensors(T0sum(129),[G0tensor(258)])
  call ol_merge_tensors(T0sum(130),[G0tensor(116)])
  call ol_merge_tensors(T0sum(131),[G0tensor(288)])
  call ol_merge_tensors(T0sum(132),[G0tensor(137)])
  call ol_merge_tensors(T0sum(133),[G0tensor(22)])
  call ol_merge_tensors(T0sum(134),[G0tensor(27)])
  call ol_merge_tensors(T0sum(135),[G0tensor(32)])
  call ol_merge_tensors(T0sum(136),[G0tensor(183)])
  call ol_merge_tensors(T0sum(137),[G0tensor(68)])
  call ol_merge_tensors(T0sum(138),[G0tensor(98)])
  call ol_merge_tensors(T0sum(139),[G0tensor(348)])
  call ol_merge_tensors(T0sum(140),[G0tensor(383)])
  call ol_merge_tensors(T0sum(141),[G0tensor(151)])
  call ol_merge_tensors(T0sum(142),[G0tensor(42)])
  call ol_merge_tensors(T0sum(143),[G0tensor(205)])
  call ol_merge_tensors(T0sum(144),[G0tensor(310)])
  call ol_merge_tensors(T0sum(145),[G0tensor(181)])
  call ol_merge_tensors(T0sum(146),[G0tensor(295)])
  call ol_merge_tensors(T0sum(147),[G0tensor(131)])
  call ol_merge_tensors(T0sum(148),[G0tensor(280)])
  call ol_merge_tensors(T0sum(149),[G0tensor(121)])
  call ol_merge_tensors(T0sum(150),[G0tensor(285)])
  call ol_merge_tensors(T0sum(151),[G0tensor(132)])
  call ol_merge_tensors(T0sum(152),[G0tensor(335)])
  call ol_merge_tensors(T0sum(153),[G0tensor(355)])
  call ol_merge_tensors(T0sum(154),[G0tensor(375)])
  call ol_merge_tensors(T0sum(155),[G0tensor(172)])
  call ol_merge_tensors(T0sum(156),[G0tensor(160)])
  call ol_merge_tensors(T0sum(157),[G0tensor(177)])
  call ol_merge_tensors(T0sum(158),[G0tensor(192)])
  call ol_merge_tensors(T0sum(159),[G0tensor(247)])
  call ol_merge_tensors(T0sum(160),[G0tensor(221)])
  call ol_merge_tensors(T0sum(161),[G0tensor(242)])
  call ol_merge_tensors(T0sum(162),[G0tensor(266)])
  call ol_merge_tensors(T0sum(163),[G0tensor(297)])
  call ol_merge_tensors(T0sum(164),[G0tensor(292)])
  call ol_merge_tensors(T0sum(165),[G0tensor(307)])
  call ol_merge_tensors(T0sum(166),[G0tensor(317)])
  call ol_merge_tensors(T0sum(167),[G0tensor(331)])
  call ol_merge_tensors(T0sum(168),[G0tensor(347)])
  call ol_merge_tensors(T0sum(169),[G0tensor(352)])
  call ol_merge_tensors(T0sum(170),[G0tensor(362)])
  call ol_merge_tensors(T0sum(171),[G0tensor(386)])
  call ol_merge_tensors(T0sum(172),[G0tensor(391)])
  call ol_merge_tensors(T0sum(173),[G0tensor(396)])
  call ol_merge_tensors(T0sum(174),[G0tensor(401)])
  call ol_merge_tensors(T0sum(175),[G0tensor(406)])
  call ol_merge_tensors(T0sum(176),[G0tensor(411)])
  call ol_merge_tensors(T0sum(177),[G0tensor(416)])
  call ol_merge_tensors(T0sum(178),[G0tensor(421)])
  call ol_merge_tensors(T0sum(179),[G0tensor(426)])
  call ol_merge_tensors(T0sum(180),[G0tensor(431)])
  call ol_merge_tensors(T0sum(181),[G0tensor(436)])
  call ol_merge_tensors(T0sum(182),[G0tensor(441)])
  call ol_merge_tensors(T0sum(183),[G0tensor(446)])
  call ol_merge_tensors(T1sum(17),[G1tensor(312)])
  call ol_merge_tensors(T1sum(18),[G1tensor(288)])
  call ol_merge_tensors(T1sum(19),[G1tensor(289)])
  call ol_merge_tensors(T1sum(20),[G1tensor(302)])
  call ol_merge_tensors(T1sum(21),[G1tensor(316)])
  call ol_merge_tensors(T1sum(22),[G1tensor(292)])
  call ol_merge_tensors(T1sum(23),[G1tensor(293)])
  call ol_merge_tensors(T1sum(24),[G1tensor(306)])
  call ol_merge_tensors(T1sum(25),[G1tensor(320)])
  call ol_merge_tensors(T1sum(26),[G1tensor(296)])
  call ol_merge_tensors(T1sum(27),[G1tensor(297)])
  call ol_merge_tensors(T1sum(28),[G1tensor(310)])
  call ol_merge_tensors(T1sum(29),[G1tensor(299)])
  call ol_merge_tensors(T1sum(30),[G1tensor(300)])
  call ol_merge_tensors(T1sum(31),[G1tensor(349)])
  call ol_merge_tensors(T1sum(32),[G1tensor(303)])
  call ol_merge_tensors(T1sum(33),[G1tensor(304)])
  call ol_merge_tensors(T1sum(34),[G1tensor(353)])
  call ol_merge_tensors(T1sum(35),[G1tensor(307)])
  call ol_merge_tensors(T1sum(36),[G1tensor(308)])
  call ol_merge_tensors(T1sum(37),[G1tensor(357)])
  call ol_merge_tensors(T1sum(38),[G1tensor(311)])
  call ol_merge_tensors(T1sum(39),[G1tensor(314)])
  call ol_merge_tensors(T1sum(40),[G1tensor(315)])
  call ol_merge_tensors(T1sum(41),[G1tensor(318)])
  call ol_merge_tensors(T1sum(42),[G1tensor(319)])
  call ol_merge_tensors(T1sum(43),[G1tensor(322)])
  call ol_merge_tensors(T1sum(44),[G1tensor(336)])
  call ol_merge_tensors(T1sum(45),[G1tensor(324)])
  call ol_merge_tensors(T1sum(46),[G1tensor(325)])
  call ol_merge_tensors(T1sum(47),[G1tensor(350)])
  call ol_merge_tensors(T1sum(48),[G1tensor(340)])
  call ol_merge_tensors(T1sum(49),[G1tensor(328)])
  call ol_merge_tensors(T1sum(50),[G1tensor(329)])
  call ol_merge_tensors(T1sum(51),[G1tensor(354)])
  call ol_merge_tensors(T1sum(52),[G1tensor(344)])
  call ol_merge_tensors(T1sum(53),[G1tensor(332)])
  call ol_merge_tensors(T1sum(54),[G1tensor(333)])
  call ol_merge_tensors(T1sum(55),[G1tensor(358)])
  call ol_merge_tensors(T1sum(56),[G1tensor(335)])
  call ol_merge_tensors(T1sum(57),[G1tensor(338)])
  call ol_merge_tensors(T1sum(58),[G1tensor(339)])
  call ol_merge_tensors(T1sum(59),[G1tensor(342)])
  call ol_merge_tensors(T1sum(60),[G1tensor(343)])
  call ol_merge_tensors(T1sum(61),[G1tensor(346)])
  call ol_merge_tensors(T1sum(62),[G1tensor(347)])
  call ol_merge_tensors(T1sum(63),[G1tensor(348)])
  call ol_merge_tensors(T1sum(64),[G1tensor(351)])
  call ol_merge_tensors(T1sum(65),[G1tensor(352)])
  call ol_merge_tensors(T1sum(66),[G1tensor(355)])
  call ol_merge_tensors(T1sum(67),[G1tensor(356)])
  call ol_merge_tensors(T0sum(184),[G0tensor(451)])
  call ol_merge_tensors(T0sum(185),[G0tensor(456)])
  call ol_merge_tensors(T0sum(186),[G0tensor(461)])
  call ol_merge_tensors(T0sum(187),[G0tensor(466)])
  call ol_merge_tensors(T0sum(188),[G0tensor(471)])
  call ol_merge_tensors(T0sum(189),[G0tensor(476)])
  call ol_merge_tensors(T0sum(190),[G0tensor(481)])
  call ol_merge_tensors(T0sum(191),[G0tensor(486)])
  call ol_merge_tensors(T0sum(192),[G0tensor(491)])
  call ol_merge_tensors(T0sum(193),[G0tensor(495)])
  call ol_merge_tensors(T0sum(194),[G0tensor(499)])
  call ol_merge_tensors(T0sum(195),[G0tensor(504)])
  call ol_merge_tensors(T0sum(196),[G0tensor(509)])
  call ol_merge_tensors(T0sum(197),[G0tensor(513)])
  call ol_merge_tensors(T0sum(198),[G0tensor(517)])
  call ol_merge_tensors(T0sum(199),[G0tensor(522)])
  call ol_merge_tensors(T0sum(200),[G0tensor(527)])
  call ol_merge_tensors(T0sum(201),[G0tensor(531)])
  call ol_merge_tensors(T0sum(202),[G0tensor(535)])
  call ol_merge_tensors(T0sum(203),[G0tensor(540)])
  call ol_merge_tensors(T0sum(204),[G0tensor(545)])
  call ol_merge_tensors(T0sum(205),[G0tensor(549)])
  call ol_merge_tensors(T0sum(206),[G0tensor(554)])
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(150)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(371),h0tab(:,371),[90,37],[nMB,0],2,2,wf16(:,34),wf8(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,34),G0H8(1),m3h16x8(:,17),heltab2x128(:,:,371))
  call Hloop_Q_A(ntryL,G0H8(1),90,nMB,G1H8(15),n2h8(97))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(319)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(372),h0tab(:,372),[80,47],[0,nMB],2,2,wf4(:,6),wf32(:,6))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,6),G0H32(1),m3h4x32(:,37),heltab2x128(:,:,372))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(151)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(373),h0tab(:,373),[85,42],[nMB,0],2,2,wf16(:,33),wf8(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,33),G0H8(1),m3h16x8(:,18),heltab2x128(:,:,373))
  call Hloop_Q_A(ntryL,G0H8(1),85,nMB,G1H8(16),n2h8(98))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(320)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(374),h0tab(:,374),[80,47],[0,nMB],2,2,wf4(:,6),wf32(:,10))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,6),G0H32(2),m3h4x32(:,38),heltab2x128(:,:,374))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(321)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(375),h0tab(:,375),[80,47],[0,nMB],2,2,wf4(:,6),wf32(:,14))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,6),G0H32(3),m3h4x32(:,39),heltab2x128(:,:,375))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(322)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(376),h0tab(:,376),[96,31],[0,nMB],2,2,wf4(:,8),wf32(:,4))
  call Hloop_QA_V(ntryL,G0H128(1),wf4(:,8),G0H32(4),m3h4x32(:,40),heltab2x128(:,:,376))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(154)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(377),h0tab(:,377),[106,21],[nMB,0],2,2,wf16(:,38),wf8(:,7))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,38),G0H8(1),m3h16x8(:,19),heltab2x128(:,:,377))
  call Hloop_A_Q(ntryL,G0H8(1),106,nMB,G1H8(21),n2h8(99))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(323)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(378),h0tab(:,378),[96,31],[0,nMB],2,2,wf4(:,8),wf32(:,8))
  call Hloop_QA_V(ntryL,G0H128(1),wf4(:,8),G0H32(5),m3h4x32(:,41),heltab2x128(:,:,378))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(155)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(379),h0tab(:,379),[101,26],[nMB,0],2,2,wf16(:,37),wf8(:,9))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,37),G0H8(1),m3h16x8(:,20),heltab2x128(:,:,379))
  call Hloop_A_Q(ntryL,G0H8(1),101,nMB,G1H8(22),n2h8(100))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(324)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(380),h0tab(:,380),[96,31],[nMB,0],2,2,wf4(:,8),wf32(:,12))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(6),m3h4x32(:,42),heltab2x128(:,:,380))
  call Hloop_A_Q(ntryL,G0H32(6),96,nMB,G1H32(2),n2h32(87))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(165)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(381),h0tab(:,381),[85,42],[nMB,0],2,2,wf16(:,71),wf8(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,71),G0H8(1),m3h16x8(:,21),heltab2x128(:,:,381))
  call Hloop_Q_A(ntryL,G0H8(1),85,nMB,G1H8(33),n2h8(101))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(161)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(382),h0tab(:,382),[106,21],[nMB,0],2,2,wf16(:,68),wf8(:,7))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,68),G0H8(1),m3h16x8(:,22),heltab2x128(:,:,382))
  call Hloop_A_Q(ntryL,G0H8(1),106,nMB,G1H8(34),n2h8(102))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(167)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(383),h0tab(:,383),[90,37],[nMB,0],2,2,wf16(:,72),wf8(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,72),G0H8(1),m3h16x8(:,23),heltab2x128(:,:,383))
  call Hloop_Q_A(ntryL,G0H8(1),90,nMB,G1H8(49),n2h8(103))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(163)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(384),h0tab(:,384),[101,26],[nMB,0],2,2,wf16(:,70),wf8(:,9))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,70),G0H8(1),m3h16x8(:,24),heltab2x128(:,:,384))
  call Hloop_A_Q(ntryL,G0H8(1),101,nMB,G1H8(50),n2h8(104))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(325)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(385),h0tab(:,385),[80,47],[0,nMB],2,2,wf4(:,6),wf32(:,18))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,6),G0H32(6),m3h4x32(:,43),heltab2x128(:,:,385))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(326)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(386),h0tab(:,386),[80,47],[0,nMB],2,2,wf4(:,6),wf32(:,22))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,6),G0H32(7),m3h4x32(:,44),heltab2x128(:,:,386))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(327)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(387),h0tab(:,387),[96,31],[nMB,0],2,2,wf4(:,8),wf32(:,16))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(8),m3h4x32(:,45),heltab2x128(:,:,387))
  call Hloop_A_Q(ntryL,G0H32(8),96,nMB,G1H32(5),n2h32(88))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(328)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(388),h0tab(:,388),[96,31],[nMB,0],2,2,wf4(:,8),wf32(:,20))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(8),m3h4x32(:,46),heltab2x128(:,:,388))
  call Hloop_A_Q(ntryL,G0H32(8),96,nMB,G1H32(16),n2h32(89))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(180)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(389),h0tab(:,389),[86,41],[nMB,0],2,2,wf16(:,54),wf8(:,20))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,54),G0H8(1),m3h16x8(:,25),heltab2x128(:,:,389))
  call Hloop_Q_A(ntryL,G0H8(1),86,nMB,G1H8(54),n2h8(105))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(329)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(390),h0tab(:,390),[80,47],[0,nMB],2,2,wf4(:,6),wf32(:,26))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,6),G0H32(8),m3h4x32(:,47),heltab2x128(:,:,390))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(181)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(391),h0tab(:,391),[89,38],[nMB,0],2,2,wf16(:,53),wf8(:,22))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,53),G0H8(1),m3h16x8(:,26),heltab2x128(:,:,391))
  call Hloop_Q_A(ntryL,G0H8(1),89,nMB,G1H8(66),n2h8(106))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(330)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(392),h0tab(:,392),[80,47],[0,nMB],2,2,wf4(:,6),wf32(:,30))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,6),G0H32(9),m3h4x32(:,48),heltab2x128(:,:,392))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(331)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(393),h0tab(:,393),[80,47],[0,nMB],2,2,wf4(:,6),wf32(:,34))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,6),G0H32(10),m3h4x32(:,49),heltab2x128(:,:,393))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(332)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(394),h0tab(:,394),[96,31],[0,nMB],2,2,wf4(:,8),wf32(:,24))
  call Hloop_QA_V(ntryL,G0H128(1),wf4(:,8),G0H32(11),m3h4x32(:,50),heltab2x128(:,:,394))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(183)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(395),h0tab(:,395),[102,25],[nMB,0],2,2,wf16(:,58),wf8(:,24))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,58),G0H8(1),m3h16x8(:,27),heltab2x128(:,:,395))
  call Hloop_A_Q(ntryL,G0H8(1),102,nMB,G1H8(70),n2h8(107))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(333)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(396),h0tab(:,396),[96,31],[0,nMB],2,2,wf4(:,8),wf32(:,28))
  call Hloop_QA_V(ntryL,G0H128(1),wf4(:,8),G0H32(12),m3h4x32(:,51),heltab2x128(:,:,396))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(184)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(397),h0tab(:,397),[105,22],[nMB,0],2,2,wf16(:,57),wf8(:,26))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,57),G0H8(1),m3h16x8(:,28),heltab2x128(:,:,397))
  call Hloop_A_Q(ntryL,G0H8(1),105,nMB,G1H8(71),n2h8(108))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(334)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(398),h0tab(:,398),[96,31],[nMB,0],2,2,wf4(:,8),wf32(:,32))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(13),m3h4x32(:,52),heltab2x128(:,:,398))
  call Hloop_A_Q(ntryL,G0H32(13),96,nMB,G1H32(19),n2h32(90))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(194)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(399),h0tab(:,399),[89,38],[nMB,0],2,2,wf16(:,83),wf8(:,22))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,83),G0H8(1),m3h16x8(:,29),heltab2x128(:,:,399))
  call Hloop_Q_A(ntryL,G0H8(1),89,nMB,G1H8(86),n2h8(109))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(190)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(400),h0tab(:,400),[102,25],[nMB,0],2,2,wf16(:,80),wf8(:,24))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,80),G0H8(1),m3h16x8(:,30),heltab2x128(:,:,400))
  call Hloop_A_Q(ntryL,G0H8(1),102,nMB,G1H8(87),n2h8(110))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(401),h0tab(:,401),[86,41],[nMB,0],2,2,wf16(:,84),wf8(:,20))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,84),G0H8(1),m3h16x8(:,31),heltab2x128(:,:,401))
  call Hloop_Q_A(ntryL,G0H8(1),86,nMB,G1H8(7),n2h8(111))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(192)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(402),h0tab(:,402),[105,22],[nMB,0],2,2,wf16(:,82),wf8(:,26))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,82),G0H8(1),m3h16x8(:,32),heltab2x128(:,:,402))
  call Hloop_A_Q(ntryL,G0H8(1),105,nMB,G1H8(13),n2h8(112))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(335)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(403),h0tab(:,403),[80,47],[0,nMB],2,2,wf4(:,6),wf32(:,38))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,6),G0H32(13),m3h4x32(:,53),heltab2x128(:,:,403))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(336)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(404),h0tab(:,404),[80,47],[0,nMB],2,2,wf4(:,6),wf32(:,42))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,6),G0H32(14),m3h4x32(:,54),heltab2x128(:,:,404))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(337)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(405),h0tab(:,405),[96,31],[nMB,0],2,2,wf4(:,8),wf32(:,36))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(15),m3h4x32(:,55),heltab2x128(:,:,405))
  call Hloop_A_Q(ntryL,G0H32(15),96,nMB,G1H32(3),n2h32(91))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(338)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(406),h0tab(:,406),[96,31],[nMB,0],2,2,wf4(:,8),wf32(:,40))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(15),m3h4x32(:,56),heltab2x128(:,:,406))
  call Hloop_A_Q(ntryL,G0H32(15),96,nMB,G1H32(28),n2h32(92))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(339)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(407),h0tab(:,407),[80,47],[0,nMB],2,2,wf4(:,6),wf32(:,46))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,6),G0H32(15),m3h4x32(:,57),heltab2x128(:,:,407))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(340)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(408),h0tab(:,408),[80,47],[0,nMB],2,2,wf4(:,6),wf32(:,50))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,6),G0H32(16),m3h4x32(:,58),heltab2x128(:,:,408))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(341)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(409),h0tab(:,409),[96,31],[nMB,0],2,2,wf4(:,8),wf32(:,44))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(17),m3h4x32(:,59),heltab2x128(:,:,409))
  call Hloop_A_Q(ntryL,G0H32(17),96,nMB,G1H32(33),n2h32(93))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(342)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(410),h0tab(:,410),[96,31],[nMB,0],2,2,wf4(:,8),wf32(:,48))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(17),m3h4x32(:,60),heltab2x128(:,:,410))
  call Hloop_A_Q(ntryL,G0H32(17),96,nMB,G1H32(38),n2h32(94))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(343)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(411),h0tab(:,411),[80,47],[0,nMB],2,2,wf4(:,6),wf32(:,54))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,6),G0H32(17),m3h4x32(:,61),heltab2x128(:,:,411))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(344)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(412),h0tab(:,412),[80,47],[0,nMB],2,2,wf4(:,6),wf32(:,58))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,6),G0H32(18),m3h4x32(:,62),heltab2x128(:,:,412))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(345)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(413),h0tab(:,413),[96,31],[nMB,0],2,2,wf4(:,8),wf32(:,52))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(19),m3h4x32(:,63),heltab2x128(:,:,413))
  call Hloop_A_Q(ntryL,G0H32(19),96,nMB,G1H32(43),n2h32(95))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(346)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(414),h0tab(:,414),[96,31],[nMB,0],2,2,wf4(:,8),wf32(:,56))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(19),m3h4x32(:,64),heltab2x128(:,:,414))
  call Hloop_A_Q(ntryL,G0H32(19),96,nMB,G1H32(48),n2h32(96))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(49),[G1H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(33),[G1H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(34),[G1H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(50),[G1H8(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(7),[G1H8(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(86),[G1H8(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(87),[G1H8(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(13),[G1H8(71)])
  call Hcheck_last_QA_V(ntryL,l_switch,G1H8(49),wf8(:,2),G1tensor(1),m3h8x1(:,61),heltab2x8(:,:,189))
  call Hloop_VA_Q(ntryL,G0H32(1),wf32(:,6),G0H1(1),m3h32x1(:,29),heltab2x32(:,:,141))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(31),n2h1(601))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H8(33),wf8(:,4),G1tensor(61),m3h8x1(:,62),heltab2x8(:,:,190))
  call Hloop_VA_Q(ntryL,G0H32(2),wf32(:,10),G0H1(1),m3h32x1(:,30),heltab2x32(:,:,142))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(91),n2h1(602))
  call Hloop_VA_Q(ntryL,G0H32(3),wf32(:,14),G0H1(1),m3h32x1(:,31),heltab2x32(:,:,143))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(26),n2h1(603))
  call Hloop_VQ_A(ntryL,G0H32(4),wf32(:,4),G0H1(1),m3h32x1(:,32),heltab2x32(:,:,144))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(3),n2h1(604))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(34),wf8(:,7),G1tensor(50),m3h8x1(:,63),heltab2x8(:,:,191))
  call Hloop_VQ_A(ntryL,G0H32(5),wf32(:,8),G0H1(1),m3h32x1(:,33),heltab2x32(:,:,145))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(15),n2h1(605))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(50),wf8(:,9),G1tensor(74),m3h8x1(:,64),heltab2x8(:,:,192))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H32(2),wf32(:,12),G1tensor(84),m3h32x1(:,34),heltab2x32(:,:,146))
  call Hloop_VA_Q(ntryL,G0H32(6),wf32(:,18),G0H1(1),m3h32x1(:,35),heltab2x32(:,:,147))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(69),n2h1(606))
  call Hloop_VA_Q(ntryL,G0H32(7),wf32(:,22),G0H1(1),m3h32x1(:,36),heltab2x32(:,:,148))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(17),n2h1(607))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H32(5),wf32(:,16),G1tensor(14),m3h32x1(:,37),heltab2x32(:,:,149))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H32(16),wf32(:,20),G1tensor(52),m3h32x1(:,38),heltab2x32(:,:,150))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H8(7),wf8(:,20),G1tensor(35),m3h8x1(:,65),heltab2x8(:,:,193))
  call Hloop_VA_Q(ntryL,G0H32(8),wf32(:,26),G0H1(1),m3h32x1(:,39),heltab2x32(:,:,151))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(41),n2h1(608))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H8(86),wf8(:,22),G1tensor(59),m3h8x1(:,66),heltab2x8(:,:,194))
  call Hloop_VA_Q(ntryL,G0H32(9),wf32(:,30),G0H1(1),m3h32x1(:,40),heltab2x32(:,:,152))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(76),n2h1(609))
  call Hloop_VA_Q(ntryL,G0H32(10),wf32(:,34),G0H1(1),m3h32x1(:,41),heltab2x32(:,:,153))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(87),n2h1(610))
  call Hloop_VQ_A(ntryL,G0H32(11),wf32(:,24),G0H1(1),m3h32x1(:,42),heltab2x32(:,:,154))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(94),n2h1(611))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(87),wf8(:,24),G1tensor(101),m3h8x1(:,67),heltab2x8(:,:,195))
  call Hloop_VQ_A(ntryL,G0H32(12),wf32(:,28),G0H1(1),m3h32x1(:,43),heltab2x32(:,:,155))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(106),n2h1(612))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(13),wf8(:,26),G1tensor(111),m3h8x1(:,68),heltab2x8(:,:,196))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H32(19),wf32(:,32),G1tensor(116),m3h32x1(:,44),heltab2x32(:,:,156))
  call Hloop_VA_Q(ntryL,G0H32(13),wf32(:,38),G0H1(1),m3h32x1(:,45),heltab2x32(:,:,157))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(121),n2h1(613))
  call Hloop_VA_Q(ntryL,G0H32(14),wf32(:,42),G0H1(1),m3h32x1(:,46),heltab2x32(:,:,158))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(126),n2h1(614))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H32(3),wf32(:,36),G1tensor(131),m3h32x1(:,47),heltab2x32(:,:,159))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H32(28),wf32(:,40),G1tensor(136),m3h32x1(:,48),heltab2x32(:,:,160))
  call Hloop_VA_Q(ntryL,G0H32(15),wf32(:,46),G0H1(1),m3h32x1(:,49),heltab2x32(:,:,161))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(141),n2h1(615))
  call Hloop_VA_Q(ntryL,G0H32(16),wf32(:,50),G0H1(1),m3h32x1(:,50),heltab2x32(:,:,162))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(146),n2h1(616))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H32(33),wf32(:,44),G1tensor(151),m3h32x1(:,51),heltab2x32(:,:,163))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H32(38),wf32(:,48),G1tensor(156),m3h32x1(:,52),heltab2x32(:,:,164))
  call Hloop_VA_Q(ntryL,G0H32(17),wf32(:,54),G0H1(1),m3h32x1(:,53),heltab2x32(:,:,165))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(161),n2h1(617))
  call Hloop_VA_Q(ntryL,G0H32(18),wf32(:,58),G0H1(1),m3h32x1(:,54),heltab2x32(:,:,166))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(166),n2h1(618))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H32(43),wf32(:,52),G1tensor(171),m3h32x1(:,55),heltab2x32(:,:,167))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H32(48),wf32(:,56),G1tensor(176),m3h32x1(:,56),heltab2x32(:,:,168))
  call ol_merge_tensors(G0tensor(433),[G0tensor(428),G0tensor(423),G0tensor(336),G0tensor(255),G0tensor(215),G0tensor(127) &
    ,G0tensor(58),G0tensor(359),G0tensor(334),G0tensor(1),G0tensor(54),G0tensor(24)])
  call ol_merge_tensors(G0tensor(356),[G0tensor(200),G0tensor(193),G0tensor(156),G0tensor(15),G0tensor(279),G0tensor(149) &
    ,G0tensor(124),G0tensor(49),G0tensor(29)])
  call ol_merge_tensors(G0tensor(71),[G0tensor(97),G0tensor(309),G0tensor(229),G0tensor(109),G0tensor(84),G0tensor(59) &
    ,G0tensor(34)])
  call ol_merge_tensors(G0tensor(558),[G0tensor(490),G0tensor(485),G0tensor(480),G0tensor(475),G0tensor(470),G0tensor(465) &
    ,G0tensor(460),G0tensor(455),G0tensor(450),G0tensor(445),G0tensor(440),G0tensor(435),G0tensor(430),G0tensor(425),G0tensor(420) &
    ,G0tensor(415),G0tensor(410),G0tensor(405),G0tensor(400),G0tensor(395),G0tensor(390),G0tensor(385),G0tensor(361),G0tensor(372) &
    ,G0tensor(367),G0tensor(182),G0tensor(370),G0tensor(366),G0tensor(330),G0tensor(251),G0tensor(112),G0tensor(186),G0tensor(102) &
    ,G0tensor(206),G0tensor(91),G0tensor(225),G0tensor(62),G0tensor(173),G0tensor(163),G0tensor(148),G0tensor(303),G0tensor(126) &
    ,G0tensor(273),G0tensor(88),G0tensor(86),G0tensor(128),G0tensor(76),G0tensor(118),G0tensor(198),G0tensor(308),G0tensor(87) &
    ,G0tensor(113),G0tensor(165),G0tensor(271),G0tensor(28),G0tensor(150),G0tensor(130),G0tensor(171),G0tensor(61),G0tensor(95) &
    ,G0tensor(176),G0tensor(40),G0tensor(374),G0tensor(349),G0tensor(324),G0tensor(18),G0tensor(13),G0tensor(8),G0tensor(3) &
    ,G0tensor(289),G0tensor(264),G0tensor(239),G0tensor(214),G0tensor(189),G0tensor(164),G0tensor(139),G0tensor(114),G0tensor(89) &
    ,G0tensor(64),G0tensor(39)])
  call ol_merge_tensors(G0tensor(381),[G0tensor(190),G0tensor(106),G0tensor(80),G0tensor(75),G0tensor(11),G0tensor(199) &
    ,G0tensor(174),G0tensor(104),G0tensor(74)])
  call ol_merge_tensors(G0tensor(448),[G0tensor(443),G0tensor(438),G0tensor(388),G0tensor(270),G0tensor(101),G0tensor(235) &
    ,G0tensor(290),G0tensor(115),G0tensor(65),G0tensor(6),G0tensor(99),G0tensor(79)])
  call ol_merge_tensors(G0tensor(555),[G0tensor(482),G0tensor(462),G0tensor(111),G0tensor(226),G0tensor(241),G0tensor(320) &
    ,G0tensor(46),G0tensor(120),G0tensor(204),G0tensor(129)])
  call ol_merge_tensors(G1tensor(50),[G0tensor(236),G0tensor(298),G0tensor(178),G0tensor(134)])
  call ol_merge_tensors(G0tensor(472),[G0tensor(452),G0tensor(341),G0tensor(346),G0tensor(260),G0tensor(66),G0tensor(92) &
    ,G0tensor(25),G0tensor(153),G0tensor(179),G0tensor(154)])
  call ol_merge_tensors(G1tensor(1),[G0tensor(340),G0tensor(233),G0tensor(243),G0tensor(140),G0tensor(159)])
  call ol_merge_tensors(G1tensor(59),[G0tensor(371),G0tensor(253),G0tensor(133),G0tensor(175),G0tensor(184)])
  call ol_merge_tensors(G1tensor(111),[G0tensor(380),G0tensor(83),G0tensor(57),G0tensor(209)])
  call ol_merge_tensors(G0tensor(413),[G0tensor(398),G0tensor(393),G0tensor(360),G0tensor(345),G0tensor(325),G0tensor(10) &
    ,G0tensor(5),G0tensor(299),G0tensor(274),G0tensor(249),G0tensor(224)])
  call ol_merge_tensors(G1tensor(106),[G1tensor(94),G1tensor(15),G1tensor(3),G0tensor(389),G0tensor(384),G0tensor(357) &
    ,G0tensor(337),G0tensor(377),G0tensor(234)])
  call ol_merge_tensors(G0tensor(392),[G0tensor(67),G0tensor(107),G0tensor(123),G0tensor(228),G0tensor(218),G0tensor(254)])
  call ol_merge_tensors(G0tensor(534),[G0tensor(516),G0tensor(498),G0tensor(382),G0tensor(52),G0tensor(358),G0tensor(250) &
    ,G0tensor(36),G0tensor(283),G0tensor(238),G0tensor(138),G0tensor(203),G0tensor(259)])
  call ol_merge_tensors(G0tensor(458),[G0tensor(453),G0tensor(332),G0tensor(268),G0tensor(284)])
  call ol_merge_tensors(G0tensor(342),[G0tensor(248),G0tensor(20),G0tensor(38),G0tensor(2)])
  call ol_merge_tensors(G0tensor(376),[G0tensor(318),G0tensor(35),G0tensor(286),G0tensor(7)])
  call ol_merge_tensors(G0tensor(478),[G0tensor(473),G0tensor(387),G0tensor(278),G0tensor(12)])
  call ol_merge_tensors(G0tensor(437),[G0tensor(427),G0tensor(351),G0tensor(191),G0tensor(105),G0tensor(55),G0tensor(364) &
    ,G0tensor(314),G0tensor(16)])
  call ol_merge_tensors(G0tensor(464),[G0tensor(454),G0tensor(432),G0tensor(350),G0tensor(300),G0tensor(339),G0tensor(17)])
  call ol_merge_tensors(G0tensor(557),[G0tensor(489),G0tensor(479),G0tensor(469),G0tensor(459),G0tensor(444),G0tensor(434) &
    ,G0tensor(404),G0tensor(394),G0tensor(313),G0tensor(265),G0tensor(276),G0tensor(158),G0tensor(41),G0tensor(166),G0tensor(45) &
    ,G0tensor(344),G0tensor(319)])
  call ol_merge_tensors(G0tensor(429),[G0tensor(409),G0tensor(399),G0tensor(33),G0tensor(135),G0tensor(60),G0tensor(369)])
  call ol_merge_tensors(G0tensor(439),[G0tensor(419),G0tensor(414),G0tensor(188),G0tensor(281),G0tensor(70),G0tensor(50)])
  call ol_merge_tensors(G0tensor(484),[G0tensor(474),G0tensor(442),G0tensor(142),G0tensor(365),G0tensor(110),G0tensor(100)])
  call ol_merge_tensors(G0tensor(424),[G0tensor(168),G0tensor(81)])
  call ol_merge_tensors(G0tensor(449),[G0tensor(47),G0tensor(208)])
  call ol_merge_tensors(G1tensor(61),[G0tensor(457),G0tensor(397),G0tensor(315),G0tensor(223),G0tensor(48)])
  call ol_merge_tensors(G1tensor(35),[G0tensor(477),G0tensor(412),G0tensor(211),G0tensor(117),G0tensor(263)])
  call ol_merge_tensors(G1tensor(176),[G1tensor(171),G1tensor(156),G1tensor(151),G1tensor(136),G1tensor(131),G1tensor(116) &
    ,G1tensor(52),G1tensor(14),G1tensor(84),G0tensor(402),G0tensor(240),G0tensor(31),G0tensor(26),G0tensor(21),G0tensor(136)])
  call ol_merge_tensors(G1tensor(74),[G0tensor(467),G0tensor(407),G0tensor(216),G0tensor(53)])
  call ol_merge_tensors(G1tensor(101),[G0tensor(487),G0tensor(417),G0tensor(196),G0tensor(43)])
  call ol_merge_tensors(G0tensor(212),[G0tensor(237),G0tensor(162),G0tensor(230)])
  call ol_merge_tensors(G0tensor(512),[G0tensor(494),G0tensor(73)])
  call ol_merge_tensors(G0tensor(231),[G0tensor(187),G0tensor(157),G0tensor(37)])
  call ol_merge_tensors(G0tensor(520),[G0tensor(502),G0tensor(210)])
  call ol_merge_tensors(G0tensor(543),[G0tensor(525),G0tensor(507),G0tensor(146),G0tensor(373),G0tensor(343),G0tensor(63)])
  call ol_merge_tensors(G0tensor(553),[G0tensor(544),G0tensor(539),G0tensor(526),G0tensor(521),G0tensor(508),G0tensor(503) &
    ,G0tensor(327),G0tensor(306),G0tensor(262),G0tensor(246),G0tensor(252),G0tensor(180),G0tensor(51),G0tensor(185),G0tensor(333) &
    ,G0tensor(220)])
  call ol_merge_tensors(G0tensor(510),[G0tensor(497),G0tensor(493),G0tensor(222),G0tensor(232),G0tensor(245)])
  call ol_merge_tensors(G0tensor(496),[G0tensor(147),G0tensor(93)])
  call ol_merge_tensors(G0tensor(518),[G0tensor(506),G0tensor(501),G0tensor(217),G0tensor(201),G0tensor(338)])
  call ol_merge_tensors(G0tensor(505),[G0tensor(167),G0tensor(328)])
  call ol_merge_tensors(G0tensor(311),[G0tensor(282),G0tensor(261),G0tensor(353)])
  call ol_merge_tensors(G0tensor(548),[G0tensor(530),G0tensor(378)])
  call ol_merge_tensors(G0tensor(321),[G0tensor(301),G0tensor(257),G0tensor(363)])
  call ol_merge_tensors(G0tensor(552),[G0tensor(538),G0tensor(368)])
  call ol_merge_tensors(G0tensor(546),[G0tensor(533),G0tensor(529),G0tensor(312),G0tensor(291),G0tensor(82)])
  call ol_merge_tensors(G0tensor(532),[G0tensor(272),G0tensor(72)])
  call ol_merge_tensors(G0tensor(550),[G0tensor(542),G0tensor(537),G0tensor(322),G0tensor(287),G0tensor(305)])
  call ol_merge_tensors(G0tensor(541),[G0tensor(267),G0tensor(195)])
  call ol_merge_tensors(G0tensor(447),[G0tensor(422),G0tensor(418),G0tensor(408),G0tensor(403),G0tensor(145),G0tensor(122) &
    ,G0tensor(275)])
  call ol_merge_tensors(G0tensor(547),[G0tensor(528),G0tensor(515),G0tensor(511),G0tensor(492),G0tensor(256),G0tensor(152)])
  call ol_merge_tensors(G0tensor(551),[G0tensor(536),G0tensor(524),G0tensor(519),G0tensor(500),G0tensor(277),G0tensor(170)])
  call ol_merge_tensors(G0tensor(514),[G0tensor(316),G0tensor(302),G0tensor(207),G0tensor(202)])
  call ol_merge_tensors(G0tensor(523),[G0tensor(326),G0tensor(296),G0tensor(227),G0tensor(197)])
  call ol_merge_tensors(G0tensor(468),[G0tensor(463)])
  call ol_merge_tensors(G0tensor(488),[G0tensor(483)])
  call ol_merge_tensors(G1tensor(166),[G1tensor(161),G1tensor(146),G1tensor(141),G1tensor(126),G1tensor(121),G1tensor(87) &
    ,G1tensor(76),G1tensor(41),G1tensor(17),G1tensor(69),G1tensor(26),G1tensor(91),G1tensor(31),G0tensor(556)])
call TI_bubble_red(G1tensor(50),106,mass2set(:,1),G0tensor(19),M2L1R1,G0tensor(44))
call TI_bubble_red(G1tensor(1),90,mass2set(:,1),G0tensor(69),M2L1R1,G0tensor(94))
call TI_bubble_red(G1tensor(59),89,mass2set(:,1),G0tensor(119),M2L1R1,G0tensor(144))
call TI_bubble_red(G1tensor(111),105,mass2set(:,1),G0tensor(169),M2L1R1,G0tensor(194))
call TI_bubble_red(G1tensor(106),96,mass2set(:,2),G0tensor(219),M2L1R1,G0tensor(244))
call TI_bubble_red(G1tensor(61),85,mass2set(:,1),G0tensor(269),M2L1R1,G0tensor(294))
call TI_bubble_red(G1tensor(35),86,mass2set(:,1),G0tensor(4),M2L1R1,G0tensor(9))
call TI_bubble_red(G1tensor(176),96,mass2set(:,1),G0tensor(14),M2L1R1,G0tensor(304))
call TI_bubble_red(G1tensor(74),101,mass2set(:,1),G0tensor(329),M2L1R1,G0tensor(354))
call TI_bubble_red(G1tensor(101),102,mass2set(:,1),G0tensor(379),M2L1R1,G0tensor(141))
call TI_bubble_red(G1tensor(166),80,mass2set(:,2),G0tensor(90),M2L1R1,G0tensor(85))
  call ol_merge_tensors(G0tensor(85),[G0tensor(141),G0tensor(354),G0tensor(304),G0tensor(9),G0tensor(294),G0tensor(244) &
    ,G0tensor(194),G0tensor(144),G0tensor(94),G0tensor(44),G0tensor(558)])
  call ol_merge_tensors(T0sum(207),[G0tensor(433)])
  call ol_merge_tensors(T0sum(208),[G0tensor(356)])
  call ol_merge_tensors(T0sum(209),[G0tensor(71)])
  call ol_merge_tensors(T0sum(210),[G0tensor(85)])
  call ol_merge_tensors(T0sum(211),[G0tensor(381)])
  call ol_merge_tensors(T0sum(212),[G0tensor(448)])
  call ol_merge_tensors(T0sum(213),[G0tensor(555)])
  call ol_merge_tensors(T0sum(214),[G0tensor(19)])
  call ol_merge_tensors(T0sum(215),[G0tensor(472)])
  call ol_merge_tensors(T0sum(216),[G0tensor(69)])
  call ol_merge_tensors(T0sum(217),[G0tensor(119)])
  call ol_merge_tensors(T0sum(218),[G0tensor(169)])
  call ol_merge_tensors(T0sum(219),[G0tensor(413)])
  call ol_merge_tensors(T0sum(220),[G0tensor(219)])
  call ol_merge_tensors(T0sum(221),[G0tensor(392)])
  call ol_merge_tensors(T0sum(222),[G0tensor(534)])
  call ol_merge_tensors(T0sum(223),[G0tensor(458)])
  call ol_merge_tensors(T0sum(224),[G0tensor(342)])
  call ol_merge_tensors(T0sum(225),[G0tensor(376)])
  call ol_merge_tensors(T0sum(226),[G0tensor(478)])
  call ol_merge_tensors(T0sum(227),[G0tensor(437)])
  call ol_merge_tensors(T0sum(228),[G0tensor(464)])
  call ol_merge_tensors(T0sum(229),[G0tensor(557)])
  call ol_merge_tensors(T0sum(230),[G0tensor(429)])
  call ol_merge_tensors(T0sum(231),[G0tensor(439)])
  call ol_merge_tensors(T0sum(232),[G0tensor(484)])
  call ol_merge_tensors(T0sum(233),[G0tensor(424)])
  call ol_merge_tensors(T0sum(234),[G0tensor(449)])
  call ol_merge_tensors(T0sum(235),[G0tensor(269)])
  call ol_merge_tensors(T0sum(236),[G0tensor(4)])
  call ol_merge_tensors(T0sum(237),[G0tensor(14)])
  call ol_merge_tensors(T0sum(238),[G0tensor(329)])
  call ol_merge_tensors(T0sum(239),[G0tensor(379)])
  call ol_merge_tensors(T0sum(240),[G0tensor(212)])
  call ol_merge_tensors(T0sum(241),[G0tensor(512)])
  call ol_merge_tensors(T0sum(242),[G0tensor(231)])
  call ol_merge_tensors(T0sum(243),[G0tensor(520)])
  call ol_merge_tensors(T0sum(244),[G0tensor(543)])
  call ol_merge_tensors(T0sum(245),[G0tensor(553)])
  call ol_merge_tensors(T0sum(246),[G0tensor(510)])
  call ol_merge_tensors(T0sum(247),[G0tensor(496)])
  call ol_merge_tensors(T0sum(248),[G0tensor(518)])
  call ol_merge_tensors(T0sum(249),[G0tensor(505)])
  call ol_merge_tensors(T0sum(250),[G0tensor(311)])
  call ol_merge_tensors(T0sum(251),[G0tensor(548)])
  call ol_merge_tensors(T0sum(252),[G0tensor(321)])
  call ol_merge_tensors(T0sum(253),[G0tensor(552)])
  call ol_merge_tensors(T0sum(254),[G0tensor(546)])
  call ol_merge_tensors(T0sum(255),[G0tensor(532)])
  call ol_merge_tensors(T0sum(256),[G0tensor(550)])
  call ol_merge_tensors(T0sum(257),[G0tensor(541)])
  call ol_merge_tensors(T0sum(258),[G0tensor(447)])
  call ol_merge_tensors(T0sum(259),[G0tensor(547)])
  call ol_merge_tensors(T0sum(260),[G0tensor(551)])
  call ol_merge_tensors(T0sum(261),[G0tensor(514)])
  call ol_merge_tensors(T0sum(262),[G0tensor(523)])
  call ol_merge_tensors(T0sum(263),[G0tensor(468)])
  call ol_merge_tensors(T0sum(264),[G0tensor(488)])
  call ol_merge_tensors(T0sum(265),[G0tensor(90)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 80, 85, 95 ],masses2_19,RedSet_4(14),ScalarBoxes(1))
  call compute_scalar_box([ 64, 85, 95 ],masses2_15,RedSet_4(15),ScalarBoxes(2))
  call compute_scalar_box([ 64, 80, 95 ],masses2_15,RedSet_4(1),ScalarBoxes(3))
  call compute_scalar_box([ 64, 80, 85 ],masses2_15,RedSet_4(2),ScalarBoxes(4))
  call compute_scalar_box([ 16, 21, 31 ],masses2_19,RedSet_4(16),ScalarBoxes(5))
  call compute_scalar_box([ 80, 90, 95 ],masses2_19,RedSet_4(17),ScalarBoxes(6))
  call compute_scalar_box([ 64, 90, 95 ],masses2_15,RedSet_4(18),ScalarBoxes(7))
  call compute_scalar_box([ 64, 80, 90 ],masses2_15,RedSet_4(3),ScalarBoxes(8))
  call compute_scalar_box([ 16, 26, 31 ],masses2_19,RedSet_4(19),ScalarBoxes(9))
  call compute_scalar_box([ 80, 89, 95 ],masses2_19,RedSet_4(20),ScalarBoxes(10))
  call compute_scalar_box([ 64, 89, 95 ],masses2_15,RedSet_4(21),ScalarBoxes(11))
  call compute_scalar_box([ 64, 80, 89 ],masses2_15,RedSet_4(4),ScalarBoxes(12))
  call compute_scalar_box([ 16, 25, 31 ],masses2_19,RedSet_4(22),ScalarBoxes(13))
  call compute_scalar_box([ 80, 86, 95 ],masses2_19,RedSet_4(23),ScalarBoxes(14))
  call compute_scalar_box([ 64, 86, 95 ],masses2_15,RedSet_4(24),ScalarBoxes(15))
  call compute_scalar_box([ 64, 80, 86 ],masses2_15,RedSet_4(5),ScalarBoxes(16))
  call compute_scalar_box([ 16, 22, 31 ],masses2_19,RedSet_4(25),ScalarBoxes(17))
  call compute_scalar_box([ 74, 79, 111 ],masses2_18,RedSet_4(26),ScalarBoxes(18))
  call compute_scalar_box([ 64, 79, 111 ],masses2_18,RedSet_4(27),ScalarBoxes(19))
  call compute_scalar_box([ 64, 74, 111 ],masses2_18,RedSet_4(28),ScalarBoxes(20))
  call compute_scalar_box([ 64, 74, 79 ],masses2_20,RedSet_4(6),ScalarBoxes(21))
  call compute_scalar_box([ 10, 15, 47 ],masses2_18,RedSet_4(29),ScalarBoxes(22))
  call compute_scalar_box([ 69, 79, 111 ],masses2_18,RedSet_4(30),ScalarBoxes(23))
  call compute_scalar_box([ 64, 69, 111 ],masses2_18,RedSet_4(31),ScalarBoxes(24))
  call compute_scalar_box([ 64, 69, 79 ],masses2_20,RedSet_4(7),ScalarBoxes(25))
  call compute_scalar_box([ 5, 15, 47 ],masses2_18,RedSet_4(32),ScalarBoxes(26))
  call compute_scalar_box([ 74, 79, 95 ],masses2_18,RedSet_4(33),ScalarBoxes(27))
  call compute_scalar_box([ 64, 79, 95 ],masses2_18,RedSet_4(34),ScalarBoxes(28))
  call compute_scalar_box([ 64, 74, 95 ],masses2_18,RedSet_4(35),ScalarBoxes(29))
  call compute_scalar_box([ 10, 15, 31 ],masses2_18,RedSet_4(36),ScalarBoxes(30))
  call compute_scalar_box([ 69, 79, 95 ],masses2_18,RedSet_4(37),ScalarBoxes(31))
  call compute_scalar_box([ 64, 69, 95 ],masses2_18,RedSet_4(38),ScalarBoxes(32))
  call compute_scalar_box([ 5, 15, 31 ],masses2_18,RedSet_4(39),ScalarBoxes(33))
  call compute_scalar_box([ 70, 79, 111 ],masses2_18,RedSet_4(40),ScalarBoxes(34))
  call compute_scalar_box([ 64, 70, 111 ],masses2_18,RedSet_4(41),ScalarBoxes(35))
  call compute_scalar_box([ 64, 70, 79 ],masses2_20,RedSet_4(8),ScalarBoxes(36))
  call compute_scalar_box([ 6, 15, 47 ],masses2_18,RedSet_4(42),ScalarBoxes(37))
  call compute_scalar_box([ 73, 79, 111 ],masses2_18,RedSet_4(43),ScalarBoxes(38))
  call compute_scalar_box([ 64, 73, 111 ],masses2_18,RedSet_4(44),ScalarBoxes(39))
  call compute_scalar_box([ 64, 73, 79 ],masses2_20,RedSet_4(9),ScalarBoxes(40))
  call compute_scalar_box([ 9, 15, 47 ],masses2_18,RedSet_4(45),ScalarBoxes(41))
  call compute_scalar_box([ 70, 79, 95 ],masses2_18,RedSet_4(46),ScalarBoxes(42))
  call compute_scalar_box([ 64, 70, 95 ],masses2_18,RedSet_4(47),ScalarBoxes(43))
  call compute_scalar_box([ 6, 15, 31 ],masses2_18,RedSet_4(48),ScalarBoxes(44))
  call compute_scalar_box([ 73, 79, 95 ],masses2_18,RedSet_4(49),ScalarBoxes(45))
  call compute_scalar_box([ 64, 73, 95 ],masses2_18,RedSet_4(50),ScalarBoxes(46))
  call compute_scalar_box([ 9, 15, 31 ],masses2_18,RedSet_4(51),ScalarBoxes(47))
  call compute_scalar_box([ 69, 85, 117 ],masses2_17,RedSet_4(52),ScalarBoxes(48))
  call compute_scalar_box([ 64, 85, 117 ],masses2_17,RedSet_4(53),ScalarBoxes(49))
  call compute_scalar_box([ 64, 69, 117 ],masses2_20,RedSet_4(54),ScalarBoxes(50))
  call compute_scalar_box([ 64, 69, 85 ],masses2_18,RedSet_4(10),ScalarBoxes(51))
  call compute_scalar_box([ 5, 21, 53 ],masses2_17,RedSet_4(55),ScalarBoxes(52))
  call compute_scalar_box([ 69, 101, 117 ],masses2_17,RedSet_4(56),ScalarBoxes(53))
  call compute_scalar_box([ 64, 101, 117 ],masses2_17,RedSet_4(57),ScalarBoxes(54))
  call compute_scalar_box([ 64, 69, 101 ],masses2_18,RedSet_4(11),ScalarBoxes(55))
  call compute_scalar_box([ 5, 37, 53 ],masses2_17,RedSet_4(58),ScalarBoxes(56))
  call compute_scalar_box([ 70, 102, 118 ],masses2_17,RedSet_4(59),ScalarBoxes(57))
  call compute_scalar_box([ 64, 102, 118 ],masses2_17,RedSet_4(60),ScalarBoxes(58))
  call compute_scalar_box([ 64, 70, 118 ],masses2_20,RedSet_4(61),ScalarBoxes(59))
  call compute_scalar_box([ 64, 70, 102 ],masses2_18,RedSet_4(12),ScalarBoxes(60))
  call compute_scalar_box([ 6, 38, 54 ],masses2_17,RedSet_4(62),ScalarBoxes(61))
  call compute_scalar_box([ 70, 86, 118 ],masses2_17,RedSet_4(63),ScalarBoxes(62))
  call compute_scalar_box([ 64, 86, 118 ],masses2_17,RedSet_4(64),ScalarBoxes(63))
  call compute_scalar_box([ 64, 70, 86 ],masses2_18,RedSet_4(13),ScalarBoxes(64))
  call compute_scalar_box([ 6, 22, 54 ],masses2_17,RedSet_4(65),ScalarBoxes(65))
! end of process


end subroutine vamp_1

end module ol_vamp_1_ppllllj_nenenexnexbbxg_1_/**/REALKIND
