
module ol_vamp_1_ppllllj_eeexexddxg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllllj_eeexexddxg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllllj_eeexexddxg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppllllj_eeexexddxg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppllllj_eeexexddxg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppllllj_eeexexddxg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppllllj_eeexexddxg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(190)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1),h0tab(:,1),[64,10,5,32,16],[0,0,0,0,0],5,2,wf4(:,2),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1),heltab2x128(:,:,1))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(1),n2h64(1))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(192)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(2),h0tab(:,2),[64,10,5,32,16],[0,0,0,0,0],5,2,wf4(:,6),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,2),heltab2x128(:,:,2))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(2),n2h64(2))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(194)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(3),h0tab(:,3),[64,10,5,32,16],[0,0,0,0,0],5,2,wf4(:,2),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,3),heltab2x128(:,:,3))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(3),n2h64(3))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(4),h0tab(:,4),[64,10,5,32,16],[0,0,0,0,0],5,2,wf4(:,6),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,4),heltab2x128(:,:,4))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(4),n2h64(4))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(190)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(5),h0tab(:,5),[64,5,10,32,16],[0,0,0,0,0],5,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,5),heltab2x128(:,:,5))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(5),n2h64(5))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(192)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(6),h0tab(:,6),[64,5,10,32,16],[0,0,0,0,0],5,2,wf4(:,1),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,6),heltab2x128(:,:,6))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(6),n2h64(6))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(194)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(7),h0tab(:,7),[64,5,10,32,16],[0,0,0,0,0],5,2,wf4(:,8),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,7),heltab2x128(:,:,7))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(7),n2h64(7))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(8),h0tab(:,8),[64,5,10,32,16],[0,0,0,0,0],5,2,wf4(:,8),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,8),heltab2x128(:,:,8))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(8),n2h64(8))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(190)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(9),h0tab(:,9),[64,10,5,16,32],[0,0,0,0,0],5,2,wf4(:,2),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,9),heltab2x128(:,:,9))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(9),n2h64(9))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(192)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(10),h0tab(:,10),[64,10,5,16,32],[0,0,0,0,0],5,2,wf4(:,6),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,10),heltab2x128(:,:,10))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(10),n2h64(10))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(194)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(11),h0tab(:,11),[64,10,5,16,32],[0,0,0,0,0],5,2,wf4(:,2),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,11),heltab2x128(:,:,11))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(11),n2h64(11))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(12),h0tab(:,12),[64,10,5,16,32],[0,0,0,0,0],5,2,wf4(:,6),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,12),heltab2x128(:,:,12))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(12),n2h64(12))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(190)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(13),h0tab(:,13),[64,5,16,32,10],[0,0,0,0,0],5,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,13),heltab2x128(:,:,13))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(13),n2h64(13))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(192)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(14),h0tab(:,14),[64,5,16,32,10],[0,0,0,0,0],5,2,wf4(:,1),wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,14),heltab2x128(:,:,14))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(14),n2h64(14))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(194)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(15),h0tab(:,15),[64,5,16,32,10],[0,0,0,0,0],5,2,wf4(:,8),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,15),heltab2x128(:,:,15))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(15),n2h64(15))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(16),h0tab(:,16),[64,5,16,32,10],[0,0,0,0,0],5,2,wf4(:,8),wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,16),heltab2x128(:,:,16))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(16),n2h64(16))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(190)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(17),h0tab(:,17),[64,5,10,16,32],[0,0,0,0,0],5,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,17),heltab2x128(:,:,17))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(17),n2h64(17))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(192)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(18),h0tab(:,18),[64,5,10,16,32],[0,0,0,0,0],5,2,wf4(:,1),wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,18),heltab2x128(:,:,18))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(18),n2h64(18))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(194)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(19),h0tab(:,19),[64,5,10,16,32],[0,0,0,0,0],5,2,wf4(:,8),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,19),heltab2x128(:,:,19))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(19),n2h64(19))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(20),h0tab(:,20),[64,5,10,16,32],[0,0,0,0,0],5,2,wf4(:,8),wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,20),heltab2x128(:,:,20))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(20),n2h64(20))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(190)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(21),h0tab(:,21),[64,5,32,16,10],[0,0,0,0,0],5,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,21),heltab2x128(:,:,21))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(21),n2h64(21))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(192)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(22),h0tab(:,22),[64,5,32,16,10],[0,0,0,0,0],5,2,wf4(:,1),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,22),heltab2x128(:,:,22))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(22),n2h64(22))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(194)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(23),h0tab(:,23),[64,5,32,16,10],[0,0,0,0,0],5,2,wf4(:,8),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,23),heltab2x128(:,:,23))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(23),n2h64(23))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(24),h0tab(:,24),[64,5,32,16,10],[0,0,0,0,0],5,2,wf4(:,8),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,24),heltab2x128(:,:,24))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(24),n2h64(24))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(190)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(25),h0tab(:,25),[64,16,5,10,32],[0,0,0,0,0],5,2,wf4(:,1),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(25),m3h2x64(:,25),heltab2x128(:,:,25))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(192)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(26),h0tab(:,26),[64,16,5,10,32],[0,0,0,0,0],5,2,wf4(:,1),wf4(:,6))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(26),m3h2x64(:,26),heltab2x128(:,:,26))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(194)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(27),h0tab(:,27),[64,16,5,10,32],[0,0,0,0,0],5,2,wf4(:,8),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(27),m3h2x64(:,27),heltab2x128(:,:,27))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(28),h0tab(:,28),[64,16,5,10,32],[0,0,0,0,0],5,2,wf4(:,8),wf4(:,6))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(28),m3h2x64(:,28),heltab2x128(:,:,28))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(190)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(29),h0tab(:,29),[64,16,10,5,32],[0,0,0,0,0],5,2,wf4(:,2),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(29),m3h2x64(:,29),heltab2x128(:,:,29))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(192)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(30),h0tab(:,30),[64,16,10,5,32],[0,0,0,0,0],5,2,wf4(:,6),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(30),m3h2x64(:,30),heltab2x128(:,:,30))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(194)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(31),h0tab(:,31),[64,16,10,5,32],[0,0,0,0,0],5,2,wf4(:,2),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(31),m3h2x64(:,31),heltab2x128(:,:,31))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(32),h0tab(:,32),[64,16,10,5,32],[0,0,0,0,0],5,2,wf4(:,6),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(32),m3h2x64(:,32),heltab2x128(:,:,32))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(198)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(33),h0tab(:,33),[64,6,9,32,16],[0,0,0,0,0],5,2,wf4(:,12),wf4(:,11))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,33),heltab2x128(:,:,33))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(33),n2h64(25))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(200)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(34),h0tab(:,34),[64,6,9,32,16],[0,0,0,0,0],5,2,wf4(:,14),wf4(:,11))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,34),heltab2x128(:,:,34))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(34),n2h64(26))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(202)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(35),h0tab(:,35),[64,6,9,32,16],[0,0,0,0,0],5,2,wf4(:,12),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,35),heltab2x128(:,:,35))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(35),n2h64(27))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(204)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(36),h0tab(:,36),[64,6,9,32,16],[0,0,0,0,0],5,2,wf4(:,14),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,36),heltab2x128(:,:,36))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(36),n2h64(28))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(198)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(37),h0tab(:,37),[64,9,6,32,16],[0,0,0,0,0],5,2,wf4(:,11),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,37),heltab2x128(:,:,37))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(37),n2h64(29))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(200)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(38),h0tab(:,38),[64,9,6,32,16],[0,0,0,0,0],5,2,wf4(:,11),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,38),heltab2x128(:,:,38))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(38),n2h64(30))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(202)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(39),h0tab(:,39),[64,9,6,32,16],[0,0,0,0,0],5,2,wf4(:,16),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,39),heltab2x128(:,:,39))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(39),n2h64(31))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(204)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(40),h0tab(:,40),[64,9,6,32,16],[0,0,0,0,0],5,2,wf4(:,16),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,40),heltab2x128(:,:,40))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(40),n2h64(32))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(198)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(41),h0tab(:,41),[64,6,9,16,32],[0,0,0,0,0],5,2,wf4(:,12),wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,41),heltab2x128(:,:,41))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(41),n2h64(33))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(200)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(42),h0tab(:,42),[64,6,9,16,32],[0,0,0,0,0],5,2,wf4(:,14),wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,42),heltab2x128(:,:,42))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(42),n2h64(34))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(202)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(43),h0tab(:,43),[64,6,9,16,32],[0,0,0,0,0],5,2,wf4(:,12),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,43),heltab2x128(:,:,43))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(43),n2h64(35))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(204)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(44),h0tab(:,44),[64,6,9,16,32],[0,0,0,0,0],5,2,wf4(:,14),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,44),heltab2x128(:,:,44))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(44),n2h64(36))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(198)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(45),h0tab(:,45),[64,6,32,16,9],[0,0,0,0,0],5,2,wf4(:,12),wf4(:,11))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,45),heltab2x128(:,:,45))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(45),n2h64(37))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(200)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(46),h0tab(:,46),[64,6,32,16,9],[0,0,0,0,0],5,2,wf4(:,14),wf4(:,11))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,46),heltab2x128(:,:,46))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(46),n2h64(38))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(202)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(47),h0tab(:,47),[64,6,32,16,9],[0,0,0,0,0],5,2,wf4(:,12),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,47),heltab2x128(:,:,47))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(47),n2h64(39))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(204)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(48),h0tab(:,48),[64,6,32,16,9],[0,0,0,0,0],5,2,wf4(:,14),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,48),heltab2x128(:,:,48))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(48),n2h64(40))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(198)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(49),h0tab(:,49),[64,9,6,16,32],[0,0,0,0,0],5,2,wf4(:,11),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,49),heltab2x128(:,:,49))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(49),n2h64(41))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(200)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(50),h0tab(:,50),[64,9,6,16,32],[0,0,0,0,0],5,2,wf4(:,11),wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,50),heltab2x128(:,:,50))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(50),n2h64(42))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(202)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(51),h0tab(:,51),[64,9,6,16,32],[0,0,0,0,0],5,2,wf4(:,16),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,51),heltab2x128(:,:,51))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(51),n2h64(43))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(204)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(52),h0tab(:,52),[64,9,6,16,32],[0,0,0,0,0],5,2,wf4(:,16),wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,52),heltab2x128(:,:,52))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(52),n2h64(44))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(198)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(53),h0tab(:,53),[64,6,16,32,9],[0,0,0,0,0],5,2,wf4(:,12),wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,53),heltab2x128(:,:,53))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(53),n2h64(45))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(200)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(54),h0tab(:,54),[64,6,16,32,9],[0,0,0,0,0],5,2,wf4(:,14),wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,54),heltab2x128(:,:,54))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(54),n2h64(46))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(202)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(55),h0tab(:,55),[64,6,16,32,9],[0,0,0,0,0],5,2,wf4(:,12),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,55),heltab2x128(:,:,55))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(55),n2h64(47))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(204)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(56),h0tab(:,56),[64,6,16,32,9],[0,0,0,0,0],5,2,wf4(:,14),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,56),heltab2x128(:,:,56))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(56),n2h64(48))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(198)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(57),h0tab(:,57),[64,16,9,6,32],[0,0,0,0,0],5,2,wf4(:,11),wf4(:,12))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(57),m3h2x64(:,57),heltab2x128(:,:,57))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(200)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(58),h0tab(:,58),[64,16,9,6,32],[0,0,0,0,0],5,2,wf4(:,11),wf4(:,14))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(58),m3h2x64(:,58),heltab2x128(:,:,58))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(202)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(59),h0tab(:,59),[64,16,9,6,32],[0,0,0,0,0],5,2,wf4(:,16),wf4(:,12))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(59),m3h2x64(:,59),heltab2x128(:,:,59))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(204)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(60),h0tab(:,60),[64,16,9,6,32],[0,0,0,0,0],5,2,wf4(:,16),wf4(:,14))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(60),m3h2x64(:,60),heltab2x128(:,:,60))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(198)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(61),h0tab(:,61),[64,16,6,9,32],[0,0,0,0,0],5,2,wf4(:,12),wf4(:,11))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(61),m3h2x64(:,61),heltab2x128(:,:,61))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(200)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(62),h0tab(:,62),[64,16,6,9,32],[0,0,0,0,0],5,2,wf4(:,14),wf4(:,11))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(62),m3h2x64(:,62),heltab2x128(:,:,62))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(202)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(63),h0tab(:,63),[64,16,6,9,32],[0,0,0,0,0],5,2,wf4(:,12),wf4(:,16))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(63),m3h2x64(:,63),heltab2x128(:,:,63))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(204)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(64),h0tab(:,64),[64,16,6,9,32],[0,0,0,0,0],5,2,wf4(:,14),wf4(:,16))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(64),m3h2x64(:,64),heltab2x128(:,:,64))
  call Hloop_QV_A(ntryL,G1H64(1),wf4(:,2),G1H16(1),m3h4x16(:,1),heltab2x64(:,:,1))
  call Hloop_Q_A(ntryL,G1H16(1),74,0,G2H16(1),n2h16(1))
  call Hloop_QZ_A(ntryL,G1H64(2),wf4(:,6),G1H16(1),ngZd,m3h4x16(:,2),heltab2x64(:,:,2))
  call Hloop_Q_A(ntryL,G1H16(1),74,0,G2H16(2),n2h16(2))
  call Hloop_QV_A(ntryL,G1H64(3),wf4(:,2),G1H16(1),m3h4x16(:,3),heltab2x64(:,:,3))
  call Hloop_Q_A(ntryL,G1H16(1),74,0,G2H16(3),n2h16(3))
  call Hloop_QZ_A(ntryL,G1H64(4),wf4(:,6),G1H16(1),ngZd,m3h4x16(:,4),heltab2x64(:,:,4))
  call Hloop_Q_A(ntryL,G1H16(1),74,0,G2H16(4),n2h16(4))
  call Hloop_QV_A(ntryL,G1H64(5),wf4(:,1),G1H16(1),m3h4x16(:,5),heltab2x64(:,:,5))
  call Hloop_Q_A(ntryL,G1H16(1),69,0,G2H16(5),n2h16(5))
  call Hloop_QV_A(ntryL,G1H64(6),wf4(:,1),G1H16(1),m3h4x16(:,6),heltab2x64(:,:,6))
  call Hloop_Q_A(ntryL,G1H16(1),69,0,G2H16(6),n2h16(6))
  call Hloop_QZ_A(ntryL,G1H64(7),wf4(:,8),G1H16(1),ngZd,m3h4x16(:,7),heltab2x64(:,:,7))
  call Hloop_Q_A(ntryL,G1H16(1),69,0,G2H16(7),n2h16(7))
  call Hloop_QZ_A(ntryL,G1H64(8),wf4(:,8),G1H16(1),ngZd,m3h4x16(:,8),heltab2x64(:,:,8))
  call Hloop_Q_A(ntryL,G1H16(1),69,0,G2H16(8),n2h16(8))
  call Hloop_AV_Q(ntryL,G1H64(9),wf4(:,2),G1H16(1),m3h4x16(:,9),heltab2x64(:,:,9))
  call Hloop_A_Q(ntryL,G1H16(1),74,0,G2H16(9),n2h16(9))
  call Hloop_AZ_Q(ntryL,G1H64(10),wf4(:,6),G1H16(1),ngZd,m3h4x16(:,10),heltab2x64(:,:,10))
  call Hloop_A_Q(ntryL,G1H16(1),74,0,G2H16(10),n2h16(10))
  call Hloop_AV_Q(ntryL,G1H64(11),wf4(:,2),G1H16(1),m3h4x16(:,11),heltab2x64(:,:,11))
  call Hloop_A_Q(ntryL,G1H16(1),74,0,G2H16(11),n2h16(11))
  call Hloop_AZ_Q(ntryL,G1H64(12),wf4(:,6),G1H16(1),ngZd,m3h4x16(:,12),heltab2x64(:,:,12))
  call Hloop_A_Q(ntryL,G1H16(1),74,0,G2H16(12),n2h16(12))
  call Hloop_AV_Q(ntryL,G1H64(13),wf4(:,1),G1H16(1),m3h4x16(:,13),heltab2x64(:,:,13))
  call Hloop_A_Q(ntryL,G1H16(1),69,0,G2H16(13),n2h16(13))
  call Hloop_AV_Q(ntryL,G1H64(14),wf4(:,1),G1H16(1),m3h4x16(:,14),heltab2x64(:,:,14))
  call Hloop_A_Q(ntryL,G1H16(1),69,0,G2H16(14),n2h16(14))
  call Hloop_AZ_Q(ntryL,G1H64(15),wf4(:,8),G1H16(1),ngZd,m3h4x16(:,15),heltab2x64(:,:,15))
  call Hloop_A_Q(ntryL,G1H16(1),69,0,G2H16(15),n2h16(15))
  call Hloop_AZ_Q(ntryL,G1H64(16),wf4(:,8),G1H16(1),ngZd,m3h4x16(:,16),heltab2x64(:,:,16))
  call Hloop_A_Q(ntryL,G1H16(1),69,0,G2H16(16),n2h16(16))
  call Hloop_AV_Q(ntryL,G1H64(17),wf4(:,1),G1H16(1),m3h4x16(:,17),heltab2x64(:,:,17))
  call Hloop_A_Q(ntryL,G1H16(1),69,0,G2H16(17),n2h16(17))
  call Hloop_AV_Q(ntryL,G1H64(18),wf4(:,1),G1H16(1),m3h4x16(:,18),heltab2x64(:,:,18))
  call Hloop_A_Q(ntryL,G1H16(1),69,0,G2H16(18),n2h16(18))
  call Hloop_AZ_Q(ntryL,G1H64(19),wf4(:,8),G1H16(1),ngZd,m3h4x16(:,19),heltab2x64(:,:,19))
  call Hloop_A_Q(ntryL,G1H16(1),69,0,G2H16(19),n2h16(19))
  call Hloop_AZ_Q(ntryL,G1H64(20),wf4(:,8),G1H16(1),ngZd,m3h4x16(:,20),heltab2x64(:,:,20))
  call Hloop_A_Q(ntryL,G1H16(1),69,0,G2H16(20),n2h16(20))
  call Hloop_QV_A(ntryL,G1H64(21),wf4(:,1),G1H16(1),m3h4x16(:,21),heltab2x64(:,:,21))
  call Hloop_Q_A(ntryL,G1H16(1),69,0,G2H16(21),n2h16(21))
  call Hloop_QV_A(ntryL,G1H64(22),wf4(:,1),G1H16(1),m3h4x16(:,22),heltab2x64(:,:,22))
  call Hloop_Q_A(ntryL,G1H16(1),69,0,G2H16(22),n2h16(22))
  call Hloop_QZ_A(ntryL,G1H64(23),wf4(:,8),G1H16(1),ngZd,m3h4x16(:,23),heltab2x64(:,:,23))
  call Hloop_Q_A(ntryL,G1H16(1),69,0,G2H16(23),n2h16(23))
  call Hloop_QZ_A(ntryL,G1H64(24),wf4(:,8),G1H16(1),ngZd,m3h4x16(:,24),heltab2x64(:,:,24))
  call Hloop_Q_A(ntryL,G1H16(1),69,0,G2H16(24),n2h16(24))
  call Hloop_VQ_A(ntryL,G1H64(25),ex5(:),G1H32(1),m3h2x32(:,1),heltab2x64(:,:,25))
  call Hloop_Q_A(ntryL,G1H32(1),80,0,G2H32(1),n2h32(1))
  call Hloop_VQ_A(ntryL,G1H64(26),ex5(:),G1H32(1),m3h2x32(:,2),heltab2x64(:,:,26))
  call Hloop_Q_A(ntryL,G1H32(1),80,0,G2H32(2),n2h32(2))
  call Hloop_VQ_A(ntryL,G1H64(27),ex5(:),G1H32(1),m3h2x32(:,3),heltab2x64(:,:,27))
  call Hloop_Q_A(ntryL,G1H32(1),80,0,G2H32(3),n2h32(3))
  call Hloop_VQ_A(ntryL,G1H64(28),ex5(:),G1H32(1),m3h2x32(:,4),heltab2x64(:,:,28))
  call Hloop_Q_A(ntryL,G1H32(1),80,0,G2H32(4),n2h32(4))
  call Hloop_VQ_A(ntryL,G1H64(29),ex5(:),G1H32(1),m3h2x32(:,5),heltab2x64(:,:,29))
  call Hloop_Q_A(ntryL,G1H32(1),80,0,G2H32(5),n2h32(5))
  call Hloop_VQ_A(ntryL,G1H64(30),ex5(:),G1H32(1),m3h2x32(:,6),heltab2x64(:,:,30))
  call Hloop_Q_A(ntryL,G1H32(1),80,0,G2H32(6),n2h32(6))
  call Hloop_VQ_A(ntryL,G1H64(31),ex5(:),G1H32(1),m3h2x32(:,7),heltab2x64(:,:,31))
  call Hloop_Q_A(ntryL,G1H32(1),80,0,G2H32(7),n2h32(7))
  call Hloop_VQ_A(ntryL,G1H64(32),ex5(:),G1H32(1),m3h2x32(:,8),heltab2x64(:,:,32))
  call Hloop_Q_A(ntryL,G1H32(1),80,0,G2H32(8),n2h32(8))
  call Hloop_QV_A(ntryL,G1H64(33),wf4(:,12),G1H16(1),m3h4x16(:,25),heltab2x64(:,:,33))
  call Hloop_Q_A(ntryL,G1H16(1),70,0,G2H16(25),n2h16(25))
  call Hloop_QZ_A(ntryL,G1H64(34),wf4(:,14),G1H16(1),ngZd,m3h4x16(:,26),heltab2x64(:,:,34))
  call Hloop_Q_A(ntryL,G1H16(1),70,0,G2H16(26),n2h16(26))
  call Hloop_QV_A(ntryL,G1H64(35),wf4(:,12),G1H16(1),m3h4x16(:,27),heltab2x64(:,:,35))
  call Hloop_Q_A(ntryL,G1H16(1),70,0,G2H16(27),n2h16(27))
  call Hloop_QZ_A(ntryL,G1H64(36),wf4(:,14),G1H16(1),ngZd,m3h4x16(:,28),heltab2x64(:,:,36))
  call Hloop_Q_A(ntryL,G1H16(1),70,0,G2H16(28),n2h16(28))
  call Hloop_QV_A(ntryL,G1H64(37),wf4(:,11),G1H16(1),m3h4x16(:,29),heltab2x64(:,:,37))
  call Hloop_Q_A(ntryL,G1H16(1),73,0,G2H16(29),n2h16(29))
  call Hloop_QV_A(ntryL,G1H64(38),wf4(:,11),G1H16(1),m3h4x16(:,30),heltab2x64(:,:,38))
  call Hloop_Q_A(ntryL,G1H16(1),73,0,G2H16(30),n2h16(30))
  call Hloop_QZ_A(ntryL,G1H64(39),wf4(:,16),G1H16(1),ngZd,m3h4x16(:,31),heltab2x64(:,:,39))
  call Hloop_Q_A(ntryL,G1H16(1),73,0,G2H16(31),n2h16(31))
  call Hloop_QZ_A(ntryL,G1H64(40),wf4(:,16),G1H16(1),ngZd,m3h4x16(:,32),heltab2x64(:,:,40))
  call Hloop_Q_A(ntryL,G1H16(1),73,0,G2H16(32),n2h16(32))
  call Hloop_AV_Q(ntryL,G1H64(41),wf4(:,12),G1H16(1),m3h4x16(:,33),heltab2x64(:,:,41))
  call Hloop_A_Q(ntryL,G1H16(1),70,0,G2H16(33),n2h16(33))
  call Hloop_AZ_Q(ntryL,G1H64(42),wf4(:,14),G1H16(1),ngZd,m3h4x16(:,34),heltab2x64(:,:,42))
  call Hloop_A_Q(ntryL,G1H16(1),70,0,G2H16(34),n2h16(34))
  call Hloop_AV_Q(ntryL,G1H64(43),wf4(:,12),G1H16(1),m3h4x16(:,35),heltab2x64(:,:,43))
  call Hloop_A_Q(ntryL,G1H16(1),70,0,G2H16(35),n2h16(35))
  call Hloop_AZ_Q(ntryL,G1H64(44),wf4(:,14),G1H16(1),ngZd,m3h4x16(:,36),heltab2x64(:,:,44))
  call Hloop_A_Q(ntryL,G1H16(1),70,0,G2H16(36),n2h16(36))
  call Hloop_QV_A(ntryL,G1H64(45),wf4(:,12),G1H16(1),m3h4x16(:,37),heltab2x64(:,:,45))
  call Hloop_Q_A(ntryL,G1H16(1),70,0,G2H16(37),n2h16(37))
  call Hloop_QZ_A(ntryL,G1H64(46),wf4(:,14),G1H16(1),ngZd,m3h4x16(:,38),heltab2x64(:,:,46))
  call Hloop_Q_A(ntryL,G1H16(1),70,0,G2H16(38),n2h16(38))
  call Hloop_QV_A(ntryL,G1H64(47),wf4(:,12),G1H16(1),m3h4x16(:,39),heltab2x64(:,:,47))
  call Hloop_Q_A(ntryL,G1H16(1),70,0,G2H16(39),n2h16(39))
  call Hloop_QZ_A(ntryL,G1H64(48),wf4(:,14),G1H16(1),ngZd,m3h4x16(:,40),heltab2x64(:,:,48))
  call Hloop_Q_A(ntryL,G1H16(1),70,0,G2H16(40),n2h16(40))
  call Hloop_AV_Q(ntryL,G1H64(49),wf4(:,11),G1H16(1),m3h4x16(:,41),heltab2x64(:,:,49))
  call Hloop_A_Q(ntryL,G1H16(1),73,0,G2H16(41),n2h16(41))
  call Hloop_AV_Q(ntryL,G1H64(50),wf4(:,11),G1H16(1),m3h4x16(:,42),heltab2x64(:,:,50))
  call Hloop_A_Q(ntryL,G1H16(1),73,0,G2H16(42),n2h16(42))
  call Hloop_AZ_Q(ntryL,G1H64(51),wf4(:,16),G1H16(1),ngZd,m3h4x16(:,43),heltab2x64(:,:,51))
  call Hloop_A_Q(ntryL,G1H16(1),73,0,G2H16(43),n2h16(43))
  call Hloop_AZ_Q(ntryL,G1H64(52),wf4(:,16),G1H16(1),ngZd,m3h4x16(:,44),heltab2x64(:,:,52))
  call Hloop_A_Q(ntryL,G1H16(1),73,0,G2H16(44),n2h16(44))
  call Hloop_AV_Q(ntryL,G1H64(53),wf4(:,12),G1H16(1),m3h4x16(:,45),heltab2x64(:,:,53))
  call Hloop_A_Q(ntryL,G1H16(1),70,0,G2H16(45),n2h16(45))
  call Hloop_AZ_Q(ntryL,G1H64(54),wf4(:,14),G1H16(1),ngZd,m3h4x16(:,46),heltab2x64(:,:,54))
  call Hloop_A_Q(ntryL,G1H16(1),70,0,G2H16(46),n2h16(46))
  call Hloop_AV_Q(ntryL,G1H64(55),wf4(:,12),G1H16(1),m3h4x16(:,47),heltab2x64(:,:,55))
  call Hloop_A_Q(ntryL,G1H16(1),70,0,G2H16(47),n2h16(47))
  call Hloop_AZ_Q(ntryL,G1H64(56),wf4(:,14),G1H16(1),ngZd,m3h4x16(:,48),heltab2x64(:,:,56))
  call Hloop_A_Q(ntryL,G1H16(1),70,0,G2H16(48),n2h16(48))
  call Hloop_VQ_A(ntryL,G1H64(57),ex5(:),G1H32(1),m3h2x32(:,9),heltab2x64(:,:,57))
  call Hloop_Q_A(ntryL,G1H32(1),80,0,G2H32(9),n2h32(9))
  call Hloop_VQ_A(ntryL,G1H64(58),ex5(:),G1H32(1),m3h2x32(:,10),heltab2x64(:,:,58))
  call Hloop_Q_A(ntryL,G1H32(1),80,0,G2H32(10),n2h32(10))
  call Hloop_VQ_A(ntryL,G1H64(59),ex5(:),G1H32(1),m3h2x32(:,11),heltab2x64(:,:,59))
  call Hloop_Q_A(ntryL,G1H32(1),80,0,G2H32(11),n2h32(11))
  call Hloop_VQ_A(ntryL,G1H64(60),ex5(:),G1H32(1),m3h2x32(:,12),heltab2x64(:,:,60))
  call Hloop_Q_A(ntryL,G1H32(1),80,0,G2H32(12),n2h32(12))
  call Hloop_VQ_A(ntryL,G1H64(61),ex5(:),G1H32(1),m3h2x32(:,13),heltab2x64(:,:,61))
  call Hloop_Q_A(ntryL,G1H32(1),80,0,G2H32(13),n2h32(13))
  call Hloop_VQ_A(ntryL,G1H64(62),ex5(:),G1H32(1),m3h2x32(:,14),heltab2x64(:,:,62))
  call Hloop_Q_A(ntryL,G1H32(1),80,0,G2H32(14),n2h32(14))
  call Hloop_VQ_A(ntryL,G1H64(63),ex5(:),G1H32(1),m3h2x32(:,15),heltab2x64(:,:,63))
  call Hloop_Q_A(ntryL,G1H32(1),80,0,G2H32(15),n2h32(15))
  call Hloop_VQ_A(ntryL,G1H64(64),ex5(:),G1H32(1),m3h2x32(:,16),heltab2x64(:,:,64))
  call Hloop_Q_A(ntryL,G1H32(1),80,0,G2H32(16),n2h32(16))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(2),[G2H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(4),[G2H16(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(7),[G2H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(8),[G2H16(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(10),[G2H16(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(12),[G2H16(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(15),[G2H16(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(16),[G2H16(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(19),[G2H16(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(20),[G2H16(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(23),[G2H16(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(24),[G2H16(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(26),[G2H16(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(28),[G2H16(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(31),[G2H16(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(32),[G2H16(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(34),[G2H16(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(36),[G2H16(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(38),[G2H16(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(40),[G2H16(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(43),[G2H16(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(44),[G2H16(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(46),[G2H16(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(48),[G2H16(47)])
  call Hotf_5pt_reduction(G2H16(2),RedSet_5(1),mass5set(:,1),  & 
G1H16(1),G1H16(2),G1H16(3),G1H16(4),G1H16(5),G1H16(6),16)
  call HG1shiftOLR(G1H16(2),16,16)
  call Hotf_5pt_reduction(G2H16(4),RedSet_5(1),mass5set(:,1),  & 
G1H16(7),G1H16(8),G1H16(9),G1H16(10),G1H16(11),G1H16(12),16)
  call HG1shiftOLR(G1H16(8),16,16)
  call Hotf_5pt_reduction(G2H16(7),RedSet_5(2),mass5set(:,1),  & 
G1H16(13),G1H16(14),G1H16(15),G1H16(16),G1H16(17),G1H16(18),16)
  call HG1shiftOLR(G1H16(14),16,16)
  call Hotf_5pt_reduction(G2H16(8),RedSet_5(2),mass5set(:,1),  & 
G1H16(19),G1H16(20),G1H16(21),G1H16(22),G1H16(23),G1H16(24),16)
  call HG1shiftOLR(G1H16(20),16,16)
  call Hotf_5pt_reduction(G2H16(10),RedSet_5(3),mass5set(:,1),  & 
G1H16(25),G1H16(26),G1H16(27),G1H16(28),G1H16(29),G1H16(30),16)
  call HG1shiftOLR(G1H16(26),32,16)
  call Hotf_5pt_reduction(G2H16(12),RedSet_5(3),mass5set(:,1),  & 
G1H16(31),G1H16(32),G1H16(33),G1H16(34),G1H16(35),G1H16(36),16)
  call HG1shiftOLR(G1H16(32),32,16)
  call Hloop_AQ_V(ntryL,G2H16(15),ex5(:),G2H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_AQ_V(ntryL,G2H16(16),ex5(:),G2H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hotf_5pt_reduction(G2H16(19),RedSet_5(4),mass5set(:,1),  & 
G1H16(37),G1H16(38),G1H16(39),G1H16(40),G1H16(41),G1H16(42),16)
  call HG1shiftOLR(G1H16(38),32,16)
  call Hotf_5pt_reduction(G2H16(20),RedSet_5(4),mass5set(:,1),  & 
G1H16(43),G1H16(44),G1H16(45),G1H16(46),G1H16(47),G1H16(48),16)
  call HG1shiftOLR(G1H16(44),32,16)
  call Hloop_QA_V(ntryL,G2H16(23),ex6(:),G2H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_QA_V(ntryL,G2H16(24),ex6(:),G2H8(4),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hotf_5pt_reduction(G2H32(1),RedSet_5(5),mass5set(:,1),  & 
G1H32(1),G1H32(2),G1H32(3),G1H32(4),G1H32(5),G1H32(6),32)
  call HG1shiftOLR(G1H32(2),32,32)
  call Hotf_5pt_reduction(G2H32(2),RedSet_5(5),mass5set(:,1),  & 
G1H32(7),G1H32(8),G1H32(9),G1H32(10),G1H32(11),G1H32(12),32)
  call HG1shiftOLR(G1H32(8),32,32)
  call Hotf_5pt_reduction(G2H32(3),RedSet_5(5),mass5set(:,1),  & 
G1H32(13),G1H32(14),G1H32(15),G1H32(16),G1H32(17),G1H32(18),32)
  call HG1shiftOLR(G1H32(14),32,32)
  call Hotf_5pt_reduction(G2H32(4),RedSet_5(5),mass5set(:,1),  & 
G1H32(19),G1H32(20),G1H32(21),G1H32(22),G1H32(23),G1H32(24),32)
  call HG1shiftOLR(G1H32(20),32,32)
  call Hotf_5pt_reduction(G2H32(5),RedSet_5(6),mass5set(:,1),  & 
G1H32(25),G1H32(26),G1H32(27),G1H32(28),G1H32(29),G1H32(30),32)
  call HG1shiftOLR(G1H32(26),32,32)
  call Hotf_5pt_reduction(G2H32(6),RedSet_5(6),mass5set(:,1),  & 
G1H32(31),G1H32(32),G1H32(33),G1H32(34),G1H32(35),G1H32(36),32)
  call HG1shiftOLR(G1H32(32),32,32)
  call Hotf_5pt_reduction(G2H32(7),RedSet_5(6),mass5set(:,1),  & 
G1H32(37),G1H32(38),G1H32(39),G1H32(40),G1H32(41),G1H32(42),32)
  call HG1shiftOLR(G1H32(38),32,32)
  call Hotf_5pt_reduction(G2H32(8),RedSet_5(6),mass5set(:,1),  & 
G1H32(43),G1H32(44),G1H32(45),G1H32(46),G1H32(47),G1H32(48),32)
  call HG1shiftOLR(G1H32(44),32,32)
  call Hotf_5pt_reduction(G2H16(26),RedSet_5(7),mass5set(:,1),  & 
G1H16(49),G1H16(50),G1H16(51),G1H16(52),G1H16(53),G1H16(54),16)
  call HG1shiftOLR(G1H16(50),16,16)
  call Hotf_5pt_reduction(G2H16(28),RedSet_5(7),mass5set(:,1),  & 
G1H16(55),G1H16(56),G1H16(57),G1H16(58),G1H16(59),G1H16(60),16)
  call HG1shiftOLR(G1H16(56),16,16)
  call Hotf_5pt_reduction(G2H16(31),RedSet_5(8),mass5set(:,1),  & 
G1H16(61),G1H16(62),G1H16(63),G1H16(64),G1H16(65),G1H16(66),16)
  call HG1shiftOLR(G1H16(62),16,16)
  call Hotf_5pt_reduction(G2H16(32),RedSet_5(8),mass5set(:,1),  & 
G1H16(67),G1H16(68),G1H16(69),G1H16(70),G1H16(71),G1H16(72),16)
  call HG1shiftOLR(G1H16(68),16,16)
  call Hotf_5pt_reduction(G2H16(34),RedSet_5(9),mass5set(:,1),  & 
G1H16(73),G1H16(74),G1H16(75),G1H16(76),G1H16(77),G1H16(78),16)
  call HG1shiftOLR(G1H16(74),32,16)
  call Hotf_5pt_reduction(G2H16(36),RedSet_5(9),mass5set(:,1),  & 
G1H16(79),G1H16(80),G1H16(81),G1H16(82),G1H16(83),G1H16(84),16)
  call HG1shiftOLR(G1H16(80),32,16)
  call Hloop_QA_V(ntryL,G2H16(38),ex6(:),G2H8(5),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_QA_V(ntryL,G2H16(40),ex6(:),G2H8(6),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hotf_5pt_reduction(G2H16(43),RedSet_5(10),mass5set(:,1),  & 
G1H16(85),G1H16(86),G1H16(87),G1H16(88),G1H16(89),G1H16(90),16)
  call HG1shiftOLR(G1H16(86),32,16)
  call Hotf_5pt_reduction(G2H16(44),RedSet_5(10),mass5set(:,1),  & 
G1H16(91),G1H16(92),G1H16(93),G1H16(94),G1H16(95),G1H16(96),16)
  call HG1shiftOLR(G1H16(92),32,16)
  call Hloop_AQ_V(ntryL,G2H16(46),ex5(:),G2H8(7),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_AQ_V(ntryL,G2H16(48),ex5(:),G2H8(8),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hotf_5pt_reduction(G2H32(9),RedSet_5(11),mass5set(:,1),  & 
G1H32(49),G1H32(50),G1H32(51),G1H32(52),G1H32(53),G1H32(54),32)
  call HG1shiftOLR(G1H32(50),32,32)
  call Hotf_5pt_reduction(G2H32(10),RedSet_5(11),mass5set(:,1),  & 
G1H32(55),G1H32(56),G1H32(57),G1H32(58),G1H32(59),G1H32(60),32)
  call HG1shiftOLR(G1H32(56),32,32)
  call Hotf_5pt_reduction(G2H32(11),RedSet_5(11),mass5set(:,1),  & 
G1H32(61),G1H32(62),G1H32(63),G1H32(64),G1H32(65),G1H32(66),32)
  call HG1shiftOLR(G1H32(62),32,32)
  call Hotf_5pt_reduction(G2H32(12),RedSet_5(11),mass5set(:,1),  & 
G1H32(67),G1H32(68),G1H32(69),G1H32(70),G1H32(71),G1H32(72),32)
  call HG1shiftOLR(G1H32(68),32,32)
  call Hotf_5pt_reduction(G2H32(13),RedSet_5(12),mass5set(:,1),  & 
G1H32(73),G1H32(74),G1H32(75),G1H32(76),G1H32(77),G1H32(78),32)
  call HG1shiftOLR(G1H32(74),32,32)
  call Hotf_5pt_reduction(G2H32(14),RedSet_5(12),mass5set(:,1),  & 
G1H32(79),G1H32(80),G1H32(81),G1H32(82),G1H32(83),G1H32(84),32)
  call HG1shiftOLR(G1H32(80),32,32)
  call Hotf_5pt_reduction(G2H32(15),RedSet_5(12),mass5set(:,1),  & 
G1H32(85),G1H32(86),G1H32(87),G1H32(88),G1H32(89),G1H32(90),32)
  call HG1shiftOLR(G1H32(86),32,32)
  call Hotf_5pt_reduction(G2H32(16),RedSet_5(12),mass5set(:,1),  & 
G1H32(91),G1H32(92),G1H32(93),G1H32(94),G1H32(95),G1H32(96),32)
  call HG1shiftOLR(G1H32(92),32,32)
  call Hloop_QV_A(ntryL,G1H16(1),wf4(:,1),G1H4(1),m3h4x4(:,1),heltab2x16(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(1),n2h4(1))
call HGT_OLR(G1H16(2),1,1,16)
call HGT_invQ_OLR(G1H16(2),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(2),-16,0,G2H16(1),n2h16(49))
  call Hloop_AQ_V(ntryL,G2H16(1),ex5(:),G2H8(9),m3h2x8(:,9),heltab2x16(:,:,10))
  call Hloop_QV_A(ntryL,G1H16(4),wf4(:,1),G1H4(1),m3h4x4(:,2),heltab2x16(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(2),n2h4(2))
  call Hloop_QV_A(ntryL,G1H16(5),wf4(:,1),G1H4(1),m3h4x4(:,3),heltab2x16(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(3),n2h4(3))
  call Hloop_QV_A(ntryL,G1H16(6),wf4(:,1),G1H4(1),m3h4x4(:,4),heltab2x16(:,:,13))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(4),n2h4(4))
  call Hloop_QZ_A(ntryL,G1H16(7),wf4(:,8),G1H4(1),ngZd,m3h4x4(:,5),heltab2x16(:,:,14))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(5),n2h4(5))
call HGT_OLR(G1H16(8),1,1,16)
call HGT_invQ_OLR(G1H16(8),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(8),-16,0,G2H16(3),n2h16(50))
  call Hloop_AQ_V(ntryL,G2H16(3),ex5(:),G2H8(10),m3h2x8(:,10),heltab2x16(:,:,15))
  call Hloop_QZ_A(ntryL,G1H16(10),wf4(:,8),G1H4(1),ngZd,m3h4x4(:,6),heltab2x16(:,:,16))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(6),n2h4(6))
  call Hloop_QZ_A(ntryL,G1H16(11),wf4(:,8),G1H4(1),ngZd,m3h4x4(:,7),heltab2x16(:,:,17))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(7),n2h4(7))
  call Hloop_QZ_A(ntryL,G1H16(12),wf4(:,8),G1H4(1),ngZd,m3h4x4(:,8),heltab2x16(:,:,18))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(8),n2h4(8))
  call Hloop_QV_A(ntryL,G1H16(13),wf4(:,2),G1H4(1),m3h4x4(:,9),heltab2x16(:,:,19))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(9),n2h4(9))
call HGT_OLR(G1H16(14),1,1,16)
call HGT_invQ_OLR(G1H16(14),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(14),-16,0,G2H16(5),n2h16(51))
  call Hloop_AQ_V(ntryL,G2H16(5),ex5(:),G2H8(11),m3h2x8(:,11),heltab2x16(:,:,20))
  call Hloop_QV_A(ntryL,G1H16(16),wf4(:,2),G1H4(1),m3h4x4(:,10),heltab2x16(:,:,21))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(10),n2h4(10))
  call Hloop_QV_A(ntryL,G1H16(17),wf4(:,2),G1H4(1),m3h4x4(:,11),heltab2x16(:,:,22))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(11),n2h4(11))
  call Hloop_QV_A(ntryL,G1H16(18),wf4(:,2),G1H4(1),m3h4x4(:,12),heltab2x16(:,:,23))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(12),n2h4(12))
  call Hloop_QZ_A(ntryL,G1H16(19),wf4(:,6),G1H4(1),ngZd,m3h4x4(:,13),heltab2x16(:,:,24))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(13),n2h4(13))
call HGT_OLR(G1H16(20),1,1,16)
call HGT_invQ_OLR(G1H16(20),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(20),-16,0,G2H16(6),n2h16(52))
  call Hloop_AQ_V(ntryL,G2H16(6),ex5(:),G2H8(12),m3h2x8(:,12),heltab2x16(:,:,25))
  call Hloop_QZ_A(ntryL,G1H16(22),wf4(:,6),G1H4(1),ngZd,m3h4x4(:,14),heltab2x16(:,:,26))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(14),n2h4(14))
  call Hloop_QZ_A(ntryL,G1H16(23),wf4(:,6),G1H4(1),ngZd,m3h4x4(:,15),heltab2x16(:,:,27))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(15),n2h4(15))
  call Hloop_QZ_A(ntryL,G1H16(24),wf4(:,6),G1H4(1),ngZd,m3h4x4(:,16),heltab2x16(:,:,28))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(16),n2h4(16))
  call Hloop_AV_Q(ntryL,G1H16(25),wf4(:,1),G1H4(1),m3h4x4(:,17),heltab2x16(:,:,29))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(17),n2h4(17))
call HGT_OLR(G1H16(26),1,1,16)
call HGT_invQ_OLR(G1H16(26),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(26),-32,0,G2H16(9),n2h16(53))
  call Hloop_QA_V(ntryL,G2H16(9),ex6(:),G2H8(13),m3h2x8(:,13),heltab2x16(:,:,30))
  call Hloop_AV_Q(ntryL,G1H16(28),wf4(:,1),G1H4(1),m3h4x4(:,18),heltab2x16(:,:,31))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(18),n2h4(18))
  call Hloop_AV_Q(ntryL,G1H16(29),wf4(:,1),G1H4(1),m3h4x4(:,19),heltab2x16(:,:,32))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(19),n2h4(19))
  call Hloop_AV_Q(ntryL,G1H16(30),wf4(:,1),G1H4(1),m3h4x4(:,20),heltab2x16(:,:,33))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(20),n2h4(20))
  call Hloop_AZ_Q(ntryL,G1H16(31),wf4(:,8),G1H4(1),ngZd,m3h4x4(:,21),heltab2x16(:,:,34))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(21),n2h4(21))
call HGT_OLR(G1H16(32),1,1,16)
call HGT_invQ_OLR(G1H16(32),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(32),-32,0,G2H16(11),n2h16(54))
  call Hloop_QA_V(ntryL,G2H16(11),ex6(:),G2H8(14),m3h2x8(:,14),heltab2x16(:,:,35))
  call Hloop_AZ_Q(ntryL,G1H16(34),wf4(:,8),G1H4(1),ngZd,m3h4x4(:,22),heltab2x16(:,:,36))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(22),n2h4(22))
  call Hloop_AZ_Q(ntryL,G1H16(35),wf4(:,8),G1H4(1),ngZd,m3h4x4(:,23),heltab2x16(:,:,37))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(23),n2h4(23))
  call Hloop_AZ_Q(ntryL,G1H16(36),wf4(:,8),G1H4(1),ngZd,m3h4x4(:,24),heltab2x16(:,:,38))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(24),n2h4(24))
  call Hloop_AV_Q(ntryL,G1H16(37),wf4(:,2),G1H4(1),m3h4x4(:,25),heltab2x16(:,:,39))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(25),n2h4(25))
call HGT_OLR(G1H16(38),1,1,16)
call HGT_invQ_OLR(G1H16(38),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(38),-32,0,G2H16(13),n2h16(55))
  call Hloop_QA_V(ntryL,G2H16(13),ex6(:),G2H8(15),m3h2x8(:,15),heltab2x16(:,:,40))
  call Hloop_AV_Q(ntryL,G1H16(40),wf4(:,2),G1H4(1),m3h4x4(:,26),heltab2x16(:,:,41))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(26),n2h4(26))
  call Hloop_AV_Q(ntryL,G1H16(41),wf4(:,2),G1H4(1),m3h4x4(:,27),heltab2x16(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(27),n2h4(27))
  call Hloop_AV_Q(ntryL,G1H16(42),wf4(:,2),G1H4(1),m3h4x4(:,28),heltab2x16(:,:,43))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(28),n2h4(28))
  call Hloop_AZ_Q(ntryL,G1H16(43),wf4(:,6),G1H4(1),ngZd,m3h4x4(:,29),heltab2x16(:,:,44))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(29),n2h4(29))
call HGT_OLR(G1H16(44),1,1,16)
call HGT_invQ_OLR(G1H16(44),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(44),-32,0,G2H16(14),n2h16(56))
  call Hloop_QA_V(ntryL,G2H16(14),ex6(:),G2H8(16),m3h2x8(:,16),heltab2x16(:,:,45))
  call Hloop_AZ_Q(ntryL,G1H16(46),wf4(:,6),G1H4(1),ngZd,m3h4x4(:,30),heltab2x16(:,:,46))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(30),n2h4(30))
  call Hloop_AZ_Q(ntryL,G1H16(47),wf4(:,6),G1H4(1),ngZd,m3h4x4(:,31),heltab2x16(:,:,47))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(31),n2h4(31))
  call Hloop_AZ_Q(ntryL,G1H16(48),wf4(:,6),G1H4(1),ngZd,m3h4x4(:,32),heltab2x16(:,:,48))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(32),n2h4(32))
  call Hloop_QV_A(ntryL,G1H32(1),wf4(:,1),G1H8(1),m3h4x8(:,1),heltab2x32(:,:,1))
  call Hloop_Q_A(ntryL,G1H8(1),85,0,G2H8(17),n2h8(1))
call HGT_raise_alpha_OLR(G1H32(2),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(2),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(2),ex6(:),G1H16(1),m3h2x16(:,1),heltab2x32(:,:,2))
  call Hloop_QV_A(ntryL,G1H32(4),wf4(:,1),G1H8(1),m3h4x8(:,2),heltab2x32(:,:,3))
  call Hloop_Q_A(ntryL,G1H8(1),85,0,G2H8(18),n2h8(2))
  call Hloop_QV_A(ntryL,G1H32(5),wf4(:,1),G1H8(1),m3h4x8(:,3),heltab2x32(:,:,4))
  call Hloop_Q_A(ntryL,G1H8(1),85,0,G2H8(19),n2h8(3))
  call Hloop_QV_A(ntryL,G1H32(6),wf4(:,1),G1H8(1),m3h4x8(:,4),heltab2x32(:,:,5))
  call Hloop_Q_A(ntryL,G1H8(1),85,0,G2H8(20),n2h8(4))
  call Hloop_QV_A(ntryL,G1H32(7),wf4(:,1),G1H8(1),m3h4x8(:,5),heltab2x32(:,:,6))
  call Hloop_Q_A(ntryL,G1H8(1),85,0,G2H8(21),n2h8(5))
call HGT_raise_alpha_OLR(G1H32(8),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(8),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(8),ex6(:),G1H16(2),m3h2x16(:,2),heltab2x32(:,:,7))
  call Hloop_QV_A(ntryL,G1H32(10),wf4(:,1),G1H8(1),m3h4x8(:,6),heltab2x32(:,:,8))
  call Hloop_Q_A(ntryL,G1H8(1),85,0,G2H8(22),n2h8(6))
  call Hloop_QV_A(ntryL,G1H32(11),wf4(:,1),G1H8(1),m3h4x8(:,7),heltab2x32(:,:,9))
  call Hloop_Q_A(ntryL,G1H8(1),85,0,G2H8(23),n2h8(7))
  call Hloop_QV_A(ntryL,G1H32(12),wf4(:,1),G1H8(1),m3h4x8(:,8),heltab2x32(:,:,10))
  call Hloop_Q_A(ntryL,G1H8(1),85,0,G2H8(24),n2h8(8))
  call Hloop_QZ_A(ntryL,G1H32(13),wf4(:,8),G1H8(1),ngZd,m3h4x8(:,9),heltab2x32(:,:,11))
  call Hloop_Q_A(ntryL,G1H8(1),85,0,G2H8(25),n2h8(9))
call HGT_raise_alpha_OLR(G1H32(14),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(14),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(14),ex6(:),G1H16(4),m3h2x16(:,3),heltab2x32(:,:,12))
  call Hloop_QZ_A(ntryL,G1H32(16),wf4(:,8),G1H8(1),ngZd,m3h4x8(:,10),heltab2x32(:,:,13))
  call Hloop_Q_A(ntryL,G1H8(1),85,0,G2H8(26),n2h8(10))
  call Hloop_QZ_A(ntryL,G1H32(17),wf4(:,8),G1H8(1),ngZd,m3h4x8(:,11),heltab2x32(:,:,14))
  call Hloop_Q_A(ntryL,G1H8(1),85,0,G2H8(27),n2h8(11))
  call Hloop_QZ_A(ntryL,G1H32(18),wf4(:,8),G1H8(1),ngZd,m3h4x8(:,12),heltab2x32(:,:,15))
  call Hloop_Q_A(ntryL,G1H8(1),85,0,G2H8(28),n2h8(12))
  call Hloop_QZ_A(ntryL,G1H32(19),wf4(:,8),G1H8(1),ngZd,m3h4x8(:,13),heltab2x32(:,:,16))
  call Hloop_Q_A(ntryL,G1H8(1),85,0,G2H8(29),n2h8(13))
call HGT_raise_alpha_OLR(G1H32(20),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(20),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(20),ex6(:),G1H16(5),m3h2x16(:,4),heltab2x32(:,:,17))
  call Hloop_QZ_A(ntryL,G1H32(22),wf4(:,8),G1H8(1),ngZd,m3h4x8(:,14),heltab2x32(:,:,18))
  call Hloop_Q_A(ntryL,G1H8(1),85,0,G2H8(30),n2h8(14))
  call Hloop_QZ_A(ntryL,G1H32(23),wf4(:,8),G1H8(1),ngZd,m3h4x8(:,15),heltab2x32(:,:,19))
  call Hloop_Q_A(ntryL,G1H8(1),85,0,G2H8(31),n2h8(15))
  call Hloop_QZ_A(ntryL,G1H32(24),wf4(:,8),G1H8(1),ngZd,m3h4x8(:,16),heltab2x32(:,:,20))
  call Hloop_Q_A(ntryL,G1H8(1),85,0,G2H8(32),n2h8(16))
  call Hloop_QV_A(ntryL,G1H32(25),wf4(:,2),G1H8(1),m3h4x8(:,17),heltab2x32(:,:,21))
  call Hloop_Q_A(ntryL,G1H8(1),90,0,G2H8(33),n2h8(17))
call HGT_raise_alpha_OLR(G1H32(26),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(26),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(26),ex6(:),G1H16(6),m3h2x16(:,5),heltab2x32(:,:,22))
  call Hloop_QV_A(ntryL,G1H32(28),wf4(:,2),G1H8(1),m3h4x8(:,18),heltab2x32(:,:,23))
  call Hloop_Q_A(ntryL,G1H8(1),90,0,G2H8(34),n2h8(18))
  call Hloop_QV_A(ntryL,G1H32(29),wf4(:,2),G1H8(1),m3h4x8(:,19),heltab2x32(:,:,24))
  call Hloop_Q_A(ntryL,G1H8(1),90,0,G2H8(35),n2h8(19))
  call Hloop_QV_A(ntryL,G1H32(30),wf4(:,2),G1H8(1),m3h4x8(:,20),heltab2x32(:,:,25))
  call Hloop_Q_A(ntryL,G1H8(1),90,0,G2H8(36),n2h8(20))
  call Hloop_QZ_A(ntryL,G1H32(31),wf4(:,6),G1H8(1),ngZd,m3h4x8(:,21),heltab2x32(:,:,26))
  call Hloop_Q_A(ntryL,G1H8(1),90,0,G2H8(37),n2h8(21))
call HGT_raise_alpha_OLR(G1H32(32),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(32),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(32),ex6(:),G1H16(7),m3h2x16(:,6),heltab2x32(:,:,27))
  call Hloop_QZ_A(ntryL,G1H32(34),wf4(:,6),G1H8(1),ngZd,m3h4x8(:,22),heltab2x32(:,:,28))
  call Hloop_Q_A(ntryL,G1H8(1),90,0,G2H8(38),n2h8(22))
  call Hloop_QZ_A(ntryL,G1H32(35),wf4(:,6),G1H8(1),ngZd,m3h4x8(:,23),heltab2x32(:,:,29))
  call Hloop_Q_A(ntryL,G1H8(1),90,0,G2H8(39),n2h8(23))
  call Hloop_QZ_A(ntryL,G1H32(36),wf4(:,6),G1H8(1),ngZd,m3h4x8(:,24),heltab2x32(:,:,30))
  call Hloop_Q_A(ntryL,G1H8(1),90,0,G2H8(40),n2h8(24))
  call Hloop_QV_A(ntryL,G1H32(37),wf4(:,2),G1H8(1),m3h4x8(:,25),heltab2x32(:,:,31))
  call Hloop_Q_A(ntryL,G1H8(1),90,0,G2H8(41),n2h8(25))
call HGT_raise_alpha_OLR(G1H32(38),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(38),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(38),ex6(:),G1H16(8),m3h2x16(:,7),heltab2x32(:,:,32))
  call Hloop_QV_A(ntryL,G1H32(40),wf4(:,2),G1H8(1),m3h4x8(:,26),heltab2x32(:,:,33))
  call Hloop_Q_A(ntryL,G1H8(1),90,0,G2H8(42),n2h8(26))
  call Hloop_QV_A(ntryL,G1H32(41),wf4(:,2),G1H8(1),m3h4x8(:,27),heltab2x32(:,:,34))
  call Hloop_Q_A(ntryL,G1H8(1),90,0,G2H8(43),n2h8(27))
  call Hloop_QV_A(ntryL,G1H32(42),wf4(:,2),G1H8(1),m3h4x8(:,28),heltab2x32(:,:,35))
  call Hloop_Q_A(ntryL,G1H8(1),90,0,G2H8(44),n2h8(28))
  call Hloop_QZ_A(ntryL,G1H32(43),wf4(:,6),G1H8(1),ngZd,m3h4x8(:,29),heltab2x32(:,:,36))
  call Hloop_Q_A(ntryL,G1H8(1),90,0,G2H8(45),n2h8(29))
call HGT_raise_alpha_OLR(G1H32(44),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(44),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(44),ex6(:),G1H16(10),m3h2x16(:,8),heltab2x32(:,:,37))
  call Hloop_QZ_A(ntryL,G1H32(46),wf4(:,6),G1H8(1),ngZd,m3h4x8(:,30),heltab2x32(:,:,38))
  call Hloop_Q_A(ntryL,G1H8(1),90,0,G2H8(46),n2h8(30))
  call Hloop_QZ_A(ntryL,G1H32(47),wf4(:,6),G1H8(1),ngZd,m3h4x8(:,31),heltab2x32(:,:,39))
  call Hloop_Q_A(ntryL,G1H8(1),90,0,G2H8(47),n2h8(31))
  call Hloop_QZ_A(ntryL,G1H32(48),wf4(:,6),G1H8(1),ngZd,m3h4x8(:,32),heltab2x32(:,:,40))
  call Hloop_Q_A(ntryL,G1H8(1),90,0,G2H8(48),n2h8(32))
  call Hloop_QV_A(ntryL,G1H16(49),wf4(:,11),G1H4(1),m3h4x4(:,33),heltab2x16(:,:,49))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(33),n2h4(33))
call HGT_OLR(G1H16(50),1,1,16)
call HGT_invQ_OLR(G1H16(50),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(50),-16,0,G2H16(17),n2h16(57))
  call Hloop_AQ_V(ntryL,G2H16(17),ex5(:),G2H8(49),m3h2x8(:,17),heltab2x16(:,:,50))
  call Hloop_QV_A(ntryL,G1H16(52),wf4(:,11),G1H4(1),m3h4x4(:,34),heltab2x16(:,:,51))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(34),n2h4(34))
  call Hloop_QV_A(ntryL,G1H16(53),wf4(:,11),G1H4(1),m3h4x4(:,35),heltab2x16(:,:,52))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(35),n2h4(35))
  call Hloop_QV_A(ntryL,G1H16(54),wf4(:,11),G1H4(1),m3h4x4(:,36),heltab2x16(:,:,53))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(36),n2h4(36))
  call Hloop_QZ_A(ntryL,G1H16(55),wf4(:,16),G1H4(1),ngZd,m3h4x4(:,37),heltab2x16(:,:,54))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(37),n2h4(37))
call HGT_OLR(G1H16(56),1,1,16)
call HGT_invQ_OLR(G1H16(56),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(56),-16,0,G2H16(18),n2h16(58))
  call Hloop_AQ_V(ntryL,G2H16(18),ex5(:),G2H8(50),m3h2x8(:,18),heltab2x16(:,:,55))
  call Hloop_QZ_A(ntryL,G1H16(58),wf4(:,16),G1H4(1),ngZd,m3h4x4(:,38),heltab2x16(:,:,56))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(38),n2h4(38))
  call Hloop_QZ_A(ntryL,G1H16(59),wf4(:,16),G1H4(1),ngZd,m3h4x4(:,39),heltab2x16(:,:,57))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(39),n2h4(39))
  call Hloop_QZ_A(ntryL,G1H16(60),wf4(:,16),G1H4(1),ngZd,m3h4x4(:,40),heltab2x16(:,:,58))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(40),n2h4(40))
  call Hloop_QV_A(ntryL,G1H16(61),wf4(:,12),G1H4(1),m3h4x4(:,41),heltab2x16(:,:,59))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(41),n2h4(41))
call HGT_OLR(G1H16(62),1,1,16)
call HGT_invQ_OLR(G1H16(62),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(62),-16,0,G2H16(21),n2h16(59))
  call Hloop_AQ_V(ntryL,G2H16(21),ex5(:),G2H8(51),m3h2x8(:,19),heltab2x16(:,:,60))
  call Hloop_QV_A(ntryL,G1H16(64),wf4(:,12),G1H4(1),m3h4x4(:,42),heltab2x16(:,:,61))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(42),n2h4(42))
  call Hloop_QV_A(ntryL,G1H16(65),wf4(:,12),G1H4(1),m3h4x4(:,43),heltab2x16(:,:,62))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(43),n2h4(43))
  call Hloop_QV_A(ntryL,G1H16(66),wf4(:,12),G1H4(1),m3h4x4(:,44),heltab2x16(:,:,63))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(44),n2h4(44))
  call Hloop_QZ_A(ntryL,G1H16(67),wf4(:,14),G1H4(1),ngZd,m3h4x4(:,45),heltab2x16(:,:,64))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(45),n2h4(45))
call HGT_OLR(G1H16(68),1,1,16)
call HGT_invQ_OLR(G1H16(68),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(68),-16,0,G2H16(22),n2h16(60))
  call Hloop_AQ_V(ntryL,G2H16(22),ex5(:),G2H8(52),m3h2x8(:,20),heltab2x16(:,:,65))
  call Hloop_QZ_A(ntryL,G1H16(70),wf4(:,14),G1H4(1),ngZd,m3h4x4(:,46),heltab2x16(:,:,66))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(46),n2h4(46))
  call Hloop_QZ_A(ntryL,G1H16(71),wf4(:,14),G1H4(1),ngZd,m3h4x4(:,47),heltab2x16(:,:,67))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(47),n2h4(47))
  call Hloop_QZ_A(ntryL,G1H16(72),wf4(:,14),G1H4(1),ngZd,m3h4x4(:,48),heltab2x16(:,:,68))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(48),n2h4(48))
  call Hloop_AV_Q(ntryL,G1H16(73),wf4(:,11),G1H4(1),m3h4x4(:,49),heltab2x16(:,:,69))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(49),n2h4(49))
call HGT_OLR(G1H16(74),1,1,16)
call HGT_invQ_OLR(G1H16(74),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(74),-32,0,G2H16(25),n2h16(61))
  call Hloop_QA_V(ntryL,G2H16(25),ex6(:),G2H8(53),m3h2x8(:,21),heltab2x16(:,:,70))
  call Hloop_AV_Q(ntryL,G1H16(76),wf4(:,11),G1H4(1),m3h4x4(:,50),heltab2x16(:,:,71))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(50),n2h4(50))
  call Hloop_AV_Q(ntryL,G1H16(77),wf4(:,11),G1H4(1),m3h4x4(:,51),heltab2x16(:,:,72))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(51),n2h4(51))
  call Hloop_AV_Q(ntryL,G1H16(78),wf4(:,11),G1H4(1),m3h4x4(:,52),heltab2x16(:,:,73))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(52),n2h4(52))
  call Hloop_AZ_Q(ntryL,G1H16(79),wf4(:,16),G1H4(1),ngZd,m3h4x4(:,53),heltab2x16(:,:,74))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(53),n2h4(53))
call HGT_OLR(G1H16(80),1,1,16)
call HGT_invQ_OLR(G1H16(80),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(80),-32,0,G2H16(27),n2h16(62))
  call Hloop_QA_V(ntryL,G2H16(27),ex6(:),G2H8(54),m3h2x8(:,22),heltab2x16(:,:,75))
  call Hloop_AZ_Q(ntryL,G1H16(82),wf4(:,16),G1H4(1),ngZd,m3h4x4(:,54),heltab2x16(:,:,76))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(54),n2h4(54))
  call Hloop_AZ_Q(ntryL,G1H16(83),wf4(:,16),G1H4(1),ngZd,m3h4x4(:,55),heltab2x16(:,:,77))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(55),n2h4(55))
  call Hloop_AZ_Q(ntryL,G1H16(84),wf4(:,16),G1H4(1),ngZd,m3h4x4(:,56),heltab2x16(:,:,78))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(56),n2h4(56))
  call Hloop_AV_Q(ntryL,G1H16(85),wf4(:,12),G1H4(1),m3h4x4(:,57),heltab2x16(:,:,79))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(57),n2h4(57))
call HGT_OLR(G1H16(86),1,1,16)
call HGT_invQ_OLR(G1H16(86),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(86),-32,0,G2H16(29),n2h16(63))
  call Hloop_QA_V(ntryL,G2H16(29),ex6(:),G2H8(55),m3h2x8(:,23),heltab2x16(:,:,80))
  call Hloop_AV_Q(ntryL,G1H16(88),wf4(:,12),G1H4(1),m3h4x4(:,58),heltab2x16(:,:,81))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(58),n2h4(58))
  call Hloop_AV_Q(ntryL,G1H16(89),wf4(:,12),G1H4(1),m3h4x4(:,59),heltab2x16(:,:,82))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(59),n2h4(59))
  call Hloop_AV_Q(ntryL,G1H16(90),wf4(:,12),G1H4(1),m3h4x4(:,60),heltab2x16(:,:,83))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(60),n2h4(60))
  call Hloop_AZ_Q(ntryL,G1H16(91),wf4(:,14),G1H4(1),ngZd,m3h4x4(:,61),heltab2x16(:,:,84))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(61),n2h4(61))
call HGT_OLR(G1H16(92),1,1,16)
call HGT_invQ_OLR(G1H16(92),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(92),-32,0,G2H16(30),n2h16(64))
  call Hloop_QA_V(ntryL,G2H16(30),ex6(:),G2H8(56),m3h2x8(:,24),heltab2x16(:,:,85))
  call Hloop_AZ_Q(ntryL,G1H16(94),wf4(:,14),G1H4(1),ngZd,m3h4x4(:,62),heltab2x16(:,:,86))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(62),n2h4(62))
  call Hloop_AZ_Q(ntryL,G1H16(95),wf4(:,14),G1H4(1),ngZd,m3h4x4(:,63),heltab2x16(:,:,87))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(63),n2h4(63))
  call Hloop_AZ_Q(ntryL,G1H16(96),wf4(:,14),G1H4(1),ngZd,m3h4x4(:,64),heltab2x16(:,:,88))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(64),n2h4(64))
  call Hloop_QV_A(ntryL,G1H32(49),wf4(:,11),G1H8(1),m3h4x8(:,33),heltab2x32(:,:,41))
  call Hloop_Q_A(ntryL,G1H8(1),89,0,G2H8(57),n2h8(33))
call HGT_raise_alpha_OLR(G1H32(50),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(50),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(50),ex6(:),G1H16(11),m3h2x16(:,9),heltab2x32(:,:,42))
  call Hloop_QV_A(ntryL,G1H32(52),wf4(:,11),G1H8(1),m3h4x8(:,34),heltab2x32(:,:,43))
  call Hloop_Q_A(ntryL,G1H8(1),89,0,G2H8(58),n2h8(34))
  call Hloop_QV_A(ntryL,G1H32(53),wf4(:,11),G1H8(1),m3h4x8(:,35),heltab2x32(:,:,44))
  call Hloop_Q_A(ntryL,G1H8(1),89,0,G2H8(59),n2h8(35))
  call Hloop_QV_A(ntryL,G1H32(54),wf4(:,11),G1H8(1),m3h4x8(:,36),heltab2x32(:,:,45))
  call Hloop_Q_A(ntryL,G1H8(1),89,0,G2H8(60),n2h8(36))
  call Hloop_QV_A(ntryL,G1H32(55),wf4(:,11),G1H8(1),m3h4x8(:,37),heltab2x32(:,:,46))
  call Hloop_Q_A(ntryL,G1H8(1),89,0,G2H8(61),n2h8(37))
call HGT_raise_alpha_OLR(G1H32(56),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(56),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(56),ex6(:),G1H16(12),m3h2x16(:,10),heltab2x32(:,:,47))
  call Hloop_QV_A(ntryL,G1H32(58),wf4(:,11),G1H8(1),m3h4x8(:,38),heltab2x32(:,:,48))
  call Hloop_Q_A(ntryL,G1H8(1),89,0,G2H8(62),n2h8(38))
  call Hloop_QV_A(ntryL,G1H32(59),wf4(:,11),G1H8(1),m3h4x8(:,39),heltab2x32(:,:,49))
  call Hloop_Q_A(ntryL,G1H8(1),89,0,G2H8(63),n2h8(39))
  call Hloop_QV_A(ntryL,G1H32(60),wf4(:,11),G1H8(1),m3h4x8(:,40),heltab2x32(:,:,50))
  call Hloop_Q_A(ntryL,G1H8(1),89,0,G2H8(64),n2h8(40))
  call Hloop_QZ_A(ntryL,G1H32(61),wf4(:,16),G1H8(1),ngZd,m3h4x8(:,41),heltab2x32(:,:,51))
  call Hloop_Q_A(ntryL,G1H8(1),89,0,G2H8(65),n2h8(41))
call HGT_raise_alpha_OLR(G1H32(62),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(62),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(62),ex6(:),G1H16(13),m3h2x16(:,11),heltab2x32(:,:,52))
  call Hloop_QZ_A(ntryL,G1H32(64),wf4(:,16),G1H8(1),ngZd,m3h4x8(:,42),heltab2x32(:,:,53))
  call Hloop_Q_A(ntryL,G1H8(1),89,0,G2H8(66),n2h8(42))
  call Hloop_QZ_A(ntryL,G1H32(65),wf4(:,16),G1H8(1),ngZd,m3h4x8(:,43),heltab2x32(:,:,54))
  call Hloop_Q_A(ntryL,G1H8(1),89,0,G2H8(67),n2h8(43))
  call Hloop_QZ_A(ntryL,G1H32(66),wf4(:,16),G1H8(1),ngZd,m3h4x8(:,44),heltab2x32(:,:,55))
  call Hloop_Q_A(ntryL,G1H8(1),89,0,G2H8(68),n2h8(44))
  call Hloop_QZ_A(ntryL,G1H32(67),wf4(:,16),G1H8(1),ngZd,m3h4x8(:,45),heltab2x32(:,:,56))
  call Hloop_Q_A(ntryL,G1H8(1),89,0,G2H8(69),n2h8(45))
call HGT_raise_alpha_OLR(G1H32(68),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(68),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(68),ex6(:),G1H16(14),m3h2x16(:,12),heltab2x32(:,:,57))
  call Hloop_QZ_A(ntryL,G1H32(70),wf4(:,16),G1H8(1),ngZd,m3h4x8(:,46),heltab2x32(:,:,58))
  call Hloop_Q_A(ntryL,G1H8(1),89,0,G2H8(70),n2h8(46))
  call Hloop_QZ_A(ntryL,G1H32(71),wf4(:,16),G1H8(1),ngZd,m3h4x8(:,47),heltab2x32(:,:,59))
  call Hloop_Q_A(ntryL,G1H8(1),89,0,G2H8(71),n2h8(47))
  call Hloop_QZ_A(ntryL,G1H32(72),wf4(:,16),G1H8(1),ngZd,m3h4x8(:,48),heltab2x32(:,:,60))
  call Hloop_Q_A(ntryL,G1H8(1),89,0,G2H8(72),n2h8(48))
  call Hloop_QV_A(ntryL,G1H32(73),wf4(:,12),G1H8(1),m3h4x8(:,49),heltab2x32(:,:,61))
  call Hloop_Q_A(ntryL,G1H8(1),86,0,G2H8(73),n2h8(49))
call HGT_raise_alpha_OLR(G1H32(74),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(74),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(74),ex6(:),G1H16(16),m3h2x16(:,13),heltab2x32(:,:,62))
  call Hloop_QV_A(ntryL,G1H32(76),wf4(:,12),G1H8(1),m3h4x8(:,50),heltab2x32(:,:,63))
  call Hloop_Q_A(ntryL,G1H8(1),86,0,G2H8(74),n2h8(50))
  call Hloop_QV_A(ntryL,G1H32(77),wf4(:,12),G1H8(1),m3h4x8(:,51),heltab2x32(:,:,64))
  call Hloop_Q_A(ntryL,G1H8(1),86,0,G2H8(75),n2h8(51))
  call Hloop_QV_A(ntryL,G1H32(78),wf4(:,12),G1H8(1),m3h4x8(:,52),heltab2x32(:,:,65))
  call Hloop_Q_A(ntryL,G1H8(1),86,0,G2H8(76),n2h8(52))
  call Hloop_QZ_A(ntryL,G1H32(79),wf4(:,14),G1H8(1),ngZd,m3h4x8(:,53),heltab2x32(:,:,66))
  call Hloop_Q_A(ntryL,G1H8(1),86,0,G2H8(77),n2h8(53))
call HGT_raise_alpha_OLR(G1H32(80),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(80),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(80),ex6(:),G1H16(17),m3h2x16(:,14),heltab2x32(:,:,67))
  call Hloop_QZ_A(ntryL,G1H32(82),wf4(:,14),G1H8(1),ngZd,m3h4x8(:,54),heltab2x32(:,:,68))
  call Hloop_Q_A(ntryL,G1H8(1),86,0,G2H8(78),n2h8(54))
  call Hloop_QZ_A(ntryL,G1H32(83),wf4(:,14),G1H8(1),ngZd,m3h4x8(:,55),heltab2x32(:,:,69))
  call Hloop_Q_A(ntryL,G1H8(1),86,0,G2H8(79),n2h8(55))
  call Hloop_QZ_A(ntryL,G1H32(84),wf4(:,14),G1H8(1),ngZd,m3h4x8(:,56),heltab2x32(:,:,70))
  call Hloop_Q_A(ntryL,G1H8(1),86,0,G2H8(80),n2h8(56))
  call Hloop_QV_A(ntryL,G1H32(85),wf4(:,12),G1H8(1),m3h4x8(:,57),heltab2x32(:,:,71))
  call Hloop_Q_A(ntryL,G1H8(1),86,0,G2H8(81),n2h8(57))
call HGT_raise_alpha_OLR(G1H32(86),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(86),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(86),ex6(:),G1H16(18),m3h2x16(:,15),heltab2x32(:,:,72))
  call Hloop_QV_A(ntryL,G1H32(88),wf4(:,12),G1H8(1),m3h4x8(:,58),heltab2x32(:,:,73))
  call Hloop_Q_A(ntryL,G1H8(1),86,0,G2H8(82),n2h8(58))
  call Hloop_QV_A(ntryL,G1H32(89),wf4(:,12),G1H8(1),m3h4x8(:,59),heltab2x32(:,:,74))
  call Hloop_Q_A(ntryL,G1H8(1),86,0,G2H8(83),n2h8(59))
  call Hloop_QV_A(ntryL,G1H32(90),wf4(:,12),G1H8(1),m3h4x8(:,60),heltab2x32(:,:,75))
  call Hloop_Q_A(ntryL,G1H8(1),86,0,G2H8(84),n2h8(60))
  call Hloop_QZ_A(ntryL,G1H32(91),wf4(:,14),G1H8(1),ngZd,m3h4x8(:,61),heltab2x32(:,:,76))
  call Hloop_Q_A(ntryL,G1H8(1),86,0,G2H8(85),n2h8(61))
call HGT_raise_alpha_OLR(G1H32(92),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(92),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(92),ex6(:),G1H16(19),m3h2x16(:,16),heltab2x32(:,:,77))
  call Hloop_QZ_A(ntryL,G1H32(94),wf4(:,14),G1H8(1),ngZd,m3h4x8(:,62),heltab2x32(:,:,78))
  call Hloop_Q_A(ntryL,G1H8(1),86,0,G2H8(86),n2h8(62))
  call Hloop_QZ_A(ntryL,G1H32(95),wf4(:,14),G1H8(1),ngZd,m3h4x8(:,63),heltab2x32(:,:,79))
  call Hloop_Q_A(ntryL,G1H8(1),86,0,G2H8(87),n2h8(63))
  call Hloop_QZ_A(ntryL,G1H32(96),wf4(:,14),G1H8(1),ngZd,m3h4x8(:,64),heltab2x32(:,:,80))
  call Hloop_Q_A(ntryL,G1H8(1),86,0,G2H8(88),n2h8(64))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(5),[G2H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G2H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G2H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G2H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(15),[G2H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(16),[G2H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(21),[G2H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(23),[G2H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(24),[G2H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(29),[G2H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(31),[G2H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(32),[G2H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(25),[G2H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(27),[G2H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(28),[G2H8(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(29),[G2H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(31),[G2H8(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(32),[G2H8(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(37),[G2H8(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(39),[G2H8(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(40),[G2H8(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(45),[G2H8(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(47),[G2H8(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(48),[G2H8(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(37),[G2H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(39),[G2H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(40),[G2H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(45),[G2H4(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(47),[G2H4(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(48),[G2H4(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(53),[G2H4(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(55),[G2H4(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(56),[G2H4(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(61),[G2H4(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(63),[G2H4(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(64),[G2H4(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(65),[G2H8(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(67),[G2H8(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(68),[G2H8(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(69),[G2H8(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(71),[G2H8(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(72),[G2H8(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(77),[G2H8(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(79),[G2H8(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(80),[G2H8(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(85),[G2H8(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(87),[G2H8(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(88),[G2H8(84)])
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(13),mass5set(:,1),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),G1H8(6),8)
  call HG1shiftOLR(G1H8(2),10,8)
  call Hotf_5pt_reduction(G2H8(2),RedSet_5(13),mass5set(:,1),  & 
G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),G1H8(12),8)
  call HG1shiftOLR(G1H8(8),10,8)
  call Hotf_5pt_reduction(G2H8(3),RedSet_5(14),mass5set(:,1),  & 
G1H8(13),G1H8(14),G1H8(15),G1H8(16),G1H8(17),G1H8(18),8)
  call HG1shiftOLR(G1H8(14),10,8)
  call Hotf_5pt_reduction(G2H8(4),RedSet_5(14),mass5set(:,1),  & 
G1H8(19),G1H8(20),G1H8(21),G1H8(22),G1H8(23),G1H8(24),8)
  call HG1shiftOLR(G1H8(20),10,8)
  call Hotf_5pt_reduction(G2H8(5),RedSet_5(15),mass5set(:,1),  & 
G1H8(25),G1H8(26),G1H8(27),G1H8(28),G1H8(29),G1H8(30),8)
  call HG1shiftOLR(G1H8(26),9,8)
  call Hotf_5pt_reduction(G2H8(6),RedSet_5(15),mass5set(:,1),  & 
G1H8(31),G1H8(32),G1H8(33),G1H8(34),G1H8(35),G1H8(36),8)
  call HG1shiftOLR(G1H8(32),9,8)
  call Hotf_5pt_reduction(G2H8(7),RedSet_5(16),mass5set(:,1),  & 
G1H8(37),G1H8(38),G1H8(39),G1H8(40),G1H8(41),G1H8(42),8)
  call HG1shiftOLR(G1H8(38),9,8)
  call Hotf_5pt_reduction(G2H8(8),RedSet_5(16),mass5set(:,1),  & 
G1H8(43),G1H8(44),G1H8(45),G1H8(46),G1H8(47),G1H8(48),8)
  call HG1shiftOLR(G1H8(44),9,8)
  call Hloop_QA_V(ntryL,G2H4(5),ex6(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_V(ntryL,G2H4(7),ex6(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_V(ntryL,G2H4(8),ex6(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_V(ntryL,G2H4(13),ex6(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_QA_V(ntryL,G2H4(15),ex6(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QA_V(ntryL,G2H4(16),ex6(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_AQ_V(ntryL,G2H4(21),ex5(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_V(ntryL,G2H4(23),ex5(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_AQ_V(ntryL,G2H4(24),ex5(:),G2H2(9),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_AQ_V(ntryL,G2H4(29),ex5(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_AQ_V(ntryL,G2H4(31),ex5(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_AQ_V(ntryL,G2H4(32),ex5(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hotf_5pt_reduction(G2H8(25),RedSet_5(5),mass5set(:,1),  & 
G1H8(49),G1H8(50),G1H8(51),G1H8(52),G1H8(53),G1H8(54),8)
  call HG1shiftOLR(G1H8(50),32,8)
  call Hotf_4pt_reduction(G2H8(27),RedSet_4(1),mass4set(:,1),  & 
G1H8(55),G1H8(56),G1H8(57),G1H8(58),G1H8(59),8)
  call HG1shiftOLR(G1H8(56),32,8)
  call Hotf_4pt_reduction(G2H8(28),RedSet_4(2),mass4set(:,1),  & 
G1H8(60),G1H8(61),G1H8(62),G1H8(63),G1H8(64),8)
  call HG1shiftOLR(G1H8(61),42,8)
  call Hotf_5pt_reduction(G2H8(29),RedSet_5(5),mass5set(:,1),  & 
G1H8(65),G1H8(66),G1H8(67),G1H8(68),G1H8(69),G1H8(70),8)
  call HG1shiftOLR(G1H8(66),32,8)
  call Hotf_4pt_reduction(G2H8(31),RedSet_4(1),mass4set(:,1),  & 
G1H8(71),G1H8(72),G1H8(73),G1H8(74),G1H8(75),8)
  call HG1shiftOLR(G1H8(72),32,8)
  call Hotf_4pt_reduction(G2H8(32),RedSet_4(2),mass4set(:,1),  & 
G1H8(76),G1H8(77),G1H8(78),G1H8(79),G1H8(80),8)
  call HG1shiftOLR(G1H8(77),42,8)
  call Hotf_5pt_reduction(G2H8(37),RedSet_5(6),mass5set(:,1),  & 
G1H8(81),G1H8(82),G1H8(83),G1H8(84),G1H8(85),G1H8(86),8)
  call HG1shiftOLR(G1H8(82),32,8)
  call Hotf_4pt_reduction(G2H8(39),RedSet_4(1),mass4set(:,1),  & 
G1H8(87),G1H8(88),G1H8(89),G1H8(90),G1H8(91),8)
  call HG1shiftOLR(G1H8(88),32,8)
  call Hotf_4pt_reduction(G2H8(40),RedSet_4(3),mass4set(:,1),  & 
G1H8(92),G1H8(93),G1H8(94),G1H8(95),G1H8(96),8)
  call HG1shiftOLR(G1H8(93),37,8)
  call Hotf_5pt_reduction(G2H8(45),RedSet_5(6),mass5set(:,1),  & 
G1H8(97),G1H8(98),G1H8(99),G1H8(100),G1H8(101),G1H8(102),8)
  call HG1shiftOLR(G1H8(98),32,8)
  call Hotf_4pt_reduction(G2H8(47),RedSet_4(1),mass4set(:,1),  & 
G1H8(103),G1H8(104),G1H8(105),G1H8(106),G1H8(107),8)
  call HG1shiftOLR(G1H8(104),32,8)
  call Hotf_4pt_reduction(G2H8(48),RedSet_4(3),mass4set(:,1),  & 
G1H8(108),G1H8(109),G1H8(110),G1H8(111),G1H8(112),8)
  call HG1shiftOLR(G1H8(109),37,8)
  call Hloop_QA_V(ntryL,G2H4(37),ex6(:),G2H2(13),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_QA_V(ntryL,G2H4(39),ex6(:),G2H2(14),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_QA_V(ntryL,G2H4(40),ex6(:),G2H2(15),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_QA_V(ntryL,G2H4(45),ex6(:),G2H2(16),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_QA_V(ntryL,G2H4(47),ex6(:),G2H2(17),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_QA_V(ntryL,G2H4(48),ex6(:),G2H2(18),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_AQ_V(ntryL,G2H4(53),ex5(:),G2H2(19),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_AQ_V(ntryL,G2H4(55),ex5(:),G2H2(20),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_AQ_V(ntryL,G2H4(56),ex5(:),G2H2(21),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_AQ_V(ntryL,G2H4(61),ex5(:),G2H2(22),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_AQ_V(ntryL,G2H4(63),ex5(:),G2H2(23),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_AQ_V(ntryL,G2H4(64),ex5(:),G2H2(24),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hotf_5pt_reduction(G2H8(65),RedSet_5(11),mass5set(:,1),  & 
G1H8(113),G1H8(114),G1H8(115),G1H8(116),G1H8(117),G1H8(118),8)
  call HG1shiftOLR(G1H8(114),32,8)
  call Hotf_4pt_reduction(G2H8(67),RedSet_4(1),mass4set(:,1),  & 
G1H8(119),G1H8(120),G1H8(121),G1H8(122),G1H8(123),8)
  call HG1shiftOLR(G1H8(120),32,8)
  call Hotf_4pt_reduction(G2H8(68),RedSet_4(4),mass4set(:,1),  & 
G1H8(124),G1H8(125),G1H8(126),G1H8(127),G1H8(128),8)
  call HG1shiftOLR(G1H8(125),38,8)
  call Hotf_5pt_reduction(G2H8(69),RedSet_5(11),mass5set(:,1),  & 
G1H8(129),G1H8(130),G1H8(131),G1H8(132),G1H8(133),G1H8(134),8)
  call HG1shiftOLR(G1H8(130),32,8)
  call Hotf_4pt_reduction(G2H8(71),RedSet_4(1),mass4set(:,1),  & 
G1H8(135),G1H8(136),G1H8(137),G1H8(138),G1H8(139),8)
  call HG1shiftOLR(G1H8(136),32,8)
  call Hotf_4pt_reduction(G2H8(72),RedSet_4(4),mass4set(:,1),  & 
G1H8(140),G1H8(141),G1H8(142),G1H8(143),G1H8(144),8)
  call HG1shiftOLR(G1H8(141),38,8)
  call Hotf_5pt_reduction(G2H8(77),RedSet_5(12),mass5set(:,1),  & 
G1H8(145),G1H8(146),G1H8(147),G1H8(148),G1H8(149),G1H8(150),8)
  call HG1shiftOLR(G1H8(146),32,8)
  call Hotf_4pt_reduction(G2H8(79),RedSet_4(1),mass4set(:,1),  & 
G1H8(151),G1H8(152),G1H8(153),G1H8(154),G1H8(155),8)
  call HG1shiftOLR(G1H8(152),32,8)
  call Hotf_4pt_reduction(G2H8(80),RedSet_4(5),mass4set(:,1),  & 
G1H8(156),G1H8(157),G1H8(158),G1H8(159),G1H8(160),8)
  call HG1shiftOLR(G1H8(157),41,8)
  call Hotf_5pt_reduction(G2H8(85),RedSet_5(12),mass5set(:,1),  & 
G1H8(161),G1H8(162),G1H8(163),G1H8(164),G1H8(165),G1H8(166),8)
  call HG1shiftOLR(G1H8(162),32,8)
  call Hotf_4pt_reduction(G2H8(87),RedSet_4(1),mass4set(:,1),  & 
G1H8(167),G1H8(168),G1H8(169),G1H8(170),G1H8(171),8)
  call HG1shiftOLR(G1H8(168),32,8)
  call Hotf_4pt_reduction(G2H8(88),RedSet_4(5),mass4set(:,1),  & 
G1H8(172),G1H8(173),G1H8(174),G1H8(175),G1H8(176),8)
  call HG1shiftOLR(G1H8(173),41,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(55),[G1H8(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(60),[G1H8(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(71),[G1H8(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(76),[G1H8(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(87),[G1H8(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(92),[G1H8(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(103),[G1H8(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(108),[G1H8(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(119),[G1H8(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(124),[G1H8(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(135),[G1H8(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(140),[G1H8(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(151),[G1H8(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(156),[G1H8(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(167),[G1H8(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(172),[G1H8(166)])
  call Hloop_VA_Q(ntryL,G1H8(1),ex6(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_A_Q(ntryL,G1H4(1),117,0,G2H4(1),n2h4(65))
call HGT_OLR(G1H8(2),1,1,8)
call HGT_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(2),-10,0,G2H8(17),n2h8(65))
  call Hloop_QV_A(ntryL,G2H8(17),wf4(:,2),G2H2(25),m3h4x2(:,1),heltab2x8(:,:,2))
  call Hloop_VA_Q(ntryL,G1H8(5),ex6(:),G1H4(1),m3h2x4(:,2),heltab2x8(:,:,3))
  call Hloop_A_Q(ntryL,G1H4(1),117,0,G2H4(3),n2h4(66))
  call Hloop_VA_Q(ntryL,G1H8(6),ex6(:),G1H4(1),m3h2x4(:,3),heltab2x8(:,:,4))
  call Hloop_A_Q(ntryL,G1H4(1),117,0,G2H4(4),n2h4(67))
  call Hloop_VA_Q(ntryL,G1H8(7),ex6(:),G1H4(1),m3h2x4(:,4),heltab2x8(:,:,5))
  call Hloop_A_Q(ntryL,G1H4(1),117,0,G2H4(9),n2h4(68))
call HGT_OLR(G1H8(8),1,1,8)
call HGT_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(8),-10,0,G2H8(19),n2h8(66))
  call Hloop_QZ_A(ntryL,G2H8(19),wf4(:,6),G2H2(26),ngZd,m3h4x2(:,2),heltab2x8(:,:,6))
  call Hloop_VA_Q(ntryL,G1H8(11),ex6(:),G1H4(1),m3h2x4(:,5),heltab2x8(:,:,7))
  call Hloop_A_Q(ntryL,G1H4(1),117,0,G2H4(11),n2h4(69))
  call Hloop_VA_Q(ntryL,G1H8(12),ex6(:),G1H4(1),m3h2x4(:,6),heltab2x8(:,:,8))
  call Hloop_A_Q(ntryL,G1H4(1),117,0,G2H4(12),n2h4(70))
  call Hloop_VQ_A(ntryL,G1H8(13),ex5(:),G1H4(1),m3h2x4(:,7),heltab2x8(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(1),117,0,G2H4(17),n2h4(71))
call HGT_OLR(G1H8(14),1,1,8)
call HGT_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(14),-10,0,G2H8(20),n2h8(67))
  call Hloop_AV_Q(ntryL,G2H8(20),wf4(:,2),G2H2(27),m3h4x2(:,3),heltab2x8(:,:,10))
  call Hloop_VQ_A(ntryL,G1H8(17),ex5(:),G1H4(1),m3h2x4(:,8),heltab2x8(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(1),117,0,G2H4(19),n2h4(72))
  call Hloop_VQ_A(ntryL,G1H8(18),ex5(:),G1H4(1),m3h2x4(:,9),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(1),117,0,G2H4(20),n2h4(73))
  call Hloop_VQ_A(ntryL,G1H8(19),ex5(:),G1H4(1),m3h2x4(:,10),heltab2x8(:,:,13))
  call Hloop_Q_A(ntryL,G1H4(1),117,0,G2H4(25),n2h4(74))
call HGT_OLR(G1H8(20),1,1,8)
call HGT_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(20),-10,0,G2H8(21),n2h8(68))
  call Hloop_AZ_Q(ntryL,G2H8(21),wf4(:,6),G2H2(28),ngZd,m3h4x2(:,4),heltab2x8(:,:,14))
  call Hloop_VQ_A(ntryL,G1H8(23),ex5(:),G1H4(1),m3h2x4(:,11),heltab2x8(:,:,15))
  call Hloop_Q_A(ntryL,G1H4(1),117,0,G2H4(27),n2h4(75))
  call Hloop_VQ_A(ntryL,G1H8(24),ex5(:),G1H4(1),m3h2x4(:,12),heltab2x8(:,:,16))
  call Hloop_Q_A(ntryL,G1H4(1),117,0,G2H4(28),n2h4(76))
  call Hloop_VQ_A(ntryL,G1H8(25),ex5(:),G1H4(1),m3h2x4(:,13),heltab2x8(:,:,17))
  call Hloop_Q_A(ntryL,G1H4(1),118,0,G2H4(33),n2h4(77))
call HGT_OLR(G1H8(26),1,1,8)
call HGT_invQ_OLR(G1H8(26),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(26),-9,0,G2H8(23),n2h8(69))
  call Hloop_AV_Q(ntryL,G2H8(23),wf4(:,11),G2H2(29),m3h4x2(:,5),heltab2x8(:,:,18))
  call Hloop_VQ_A(ntryL,G1H8(29),ex5(:),G1H4(1),m3h2x4(:,14),heltab2x8(:,:,19))
  call Hloop_Q_A(ntryL,G1H4(1),118,0,G2H4(35),n2h4(78))
  call Hloop_VQ_A(ntryL,G1H8(30),ex5(:),G1H4(1),m3h2x4(:,15),heltab2x8(:,:,20))
  call Hloop_Q_A(ntryL,G1H4(1),118,0,G2H4(36),n2h4(79))
  call Hloop_VQ_A(ntryL,G1H8(31),ex5(:),G1H4(1),m3h2x4(:,16),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G1H4(1),118,0,G2H4(41),n2h4(80))
call HGT_OLR(G1H8(32),1,1,8)
call HGT_invQ_OLR(G1H8(32),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(32),-9,0,G2H8(24),n2h8(70))
  call Hloop_AZ_Q(ntryL,G2H8(24),wf4(:,16),G2H2(30),ngZd,m3h4x2(:,6),heltab2x8(:,:,22))
  call Hloop_VQ_A(ntryL,G1H8(35),ex5(:),G1H4(1),m3h2x4(:,17),heltab2x8(:,:,23))
  call Hloop_Q_A(ntryL,G1H4(1),118,0,G2H4(43),n2h4(81))
  call Hloop_VQ_A(ntryL,G1H8(36),ex5(:),G1H4(1),m3h2x4(:,18),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G1H4(1),118,0,G2H4(44),n2h4(82))
  call Hloop_VA_Q(ntryL,G1H8(37),ex6(:),G1H4(1),m3h2x4(:,19),heltab2x8(:,:,25))
  call Hloop_A_Q(ntryL,G1H4(1),118,0,G2H4(49),n2h4(83))
call HGT_OLR(G1H8(38),1,1,8)
call HGT_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(38),-9,0,G2H8(33),n2h8(71))
  call Hloop_QV_A(ntryL,G2H8(33),wf4(:,11),G2H2(31),m3h4x2(:,7),heltab2x8(:,:,26))
  call Hloop_VA_Q(ntryL,G1H8(41),ex6(:),G1H4(1),m3h2x4(:,20),heltab2x8(:,:,27))
  call Hloop_A_Q(ntryL,G1H4(1),118,0,G2H4(51),n2h4(84))
  call Hloop_VA_Q(ntryL,G1H8(42),ex6(:),G1H4(1),m3h2x4(:,21),heltab2x8(:,:,28))
  call Hloop_A_Q(ntryL,G1H4(1),118,0,G2H4(52),n2h4(85))
  call Hloop_VA_Q(ntryL,G1H8(43),ex6(:),G1H4(1),m3h2x4(:,22),heltab2x8(:,:,29))
  call Hloop_A_Q(ntryL,G1H4(1),118,0,G2H4(57),n2h4(86))
call HGT_OLR(G1H8(44),1,1,8)
call HGT_invQ_OLR(G1H8(44),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(44),-9,0,G2H8(35),n2h8(72))
  call Hloop_QZ_A(ntryL,G2H8(35),wf4(:,16),G2H2(32),ngZd,m3h4x2(:,8),heltab2x8(:,:,30))
  call Hloop_VA_Q(ntryL,G1H8(47),ex6(:),G1H4(1),m3h2x4(:,23),heltab2x8(:,:,31))
  call Hloop_A_Q(ntryL,G1H4(1),118,0,G2H4(59),n2h4(87))
  call Hloop_VA_Q(ntryL,G1H8(48),ex6(:),G1H4(1),m3h2x4(:,24),heltab2x8(:,:,32))
  call Hloop_A_Q(ntryL,G1H4(1),118,0,G2H4(60),n2h4(88))
  call Hloop_QV_A(ntryL,G1H8(49),wf4(:,2),G1H2(1),m3h4x2(:,9),heltab2x8(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(33),n2h2(1))
call HGT_raise_alpha_OLR(G1H8(50),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(50),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(50),ex6(:),G1H4(1),m3h2x4(:,25),heltab2x8(:,:,34))
  call Hloop_QV_A(ntryL,G1H8(55),wf4(:,2),G1H2(1),m3h4x2(:,10),heltab2x8(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(34),n2h2(2))
  call Hloop_QV_A(ntryL,G1H8(60),wf4(:,2),G1H2(1),m3h4x2(:,11),heltab2x8(:,:,36))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(35),n2h2(3))
call HGT_raise_alpha_OLR(G1H8(56),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(56),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(56),ex6(:),G1H4(2),m3h2x4(:,26),heltab2x8(:,:,37))
  call Hloop_QV_A(ntryL,G1H8(59),wf4(:,2),G1H2(1),m3h4x2(:,12),heltab2x8(:,:,38))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(36),n2h2(4))
call HGT_raise_alpha_OLR(G1H8(61),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(61),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(61),ex6(:),G1H4(3),m3h2x4(:,27),heltab2x8(:,:,39))
  call Hloop_QV_A(ntryL,G1H8(64),wf4(:,2),G1H2(1),m3h4x2(:,13),heltab2x8(:,:,40))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(37),n2h2(5))
  call Hloop_QZ_A(ntryL,G1H8(65),wf4(:,6),G1H2(1),ngZd,m3h4x2(:,14),heltab2x8(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(38),n2h2(6))
call HGT_raise_alpha_OLR(G1H8(66),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(66),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(66),ex6(:),G1H4(4),m3h2x4(:,28),heltab2x8(:,:,42))
  call Hloop_QZ_A(ntryL,G1H8(71),wf4(:,6),G1H2(1),ngZd,m3h4x2(:,15),heltab2x8(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(39),n2h2(7))
  call Hloop_QZ_A(ntryL,G1H8(76),wf4(:,6),G1H2(1),ngZd,m3h4x2(:,16),heltab2x8(:,:,44))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(40),n2h2(8))
call HGT_raise_alpha_OLR(G1H8(72),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(72),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(72),ex6(:),G1H4(5),m3h2x4(:,29),heltab2x8(:,:,45))
  call Hloop_QZ_A(ntryL,G1H8(75),wf4(:,6),G1H2(1),ngZd,m3h4x2(:,17),heltab2x8(:,:,46))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(41),n2h2(9))
call HGT_raise_alpha_OLR(G1H8(77),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(77),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(77),ex6(:),G1H4(6),m3h2x4(:,30),heltab2x8(:,:,47))
  call Hloop_QZ_A(ntryL,G1H8(80),wf4(:,6),G1H2(1),ngZd,m3h4x2(:,18),heltab2x8(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(42),n2h2(10))
  call Hloop_QV_A(ntryL,G1H8(81),wf4(:,1),G1H2(1),m3h4x2(:,19),heltab2x8(:,:,49))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(43),n2h2(11))
call HGT_raise_alpha_OLR(G1H8(82),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(82),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(82),ex6(:),G1H4(7),m3h2x4(:,31),heltab2x8(:,:,50))
  call Hloop_QV_A(ntryL,G1H8(87),wf4(:,1),G1H2(1),m3h4x2(:,20),heltab2x8(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(44),n2h2(12))
  call Hloop_QV_A(ntryL,G1H8(92),wf4(:,1),G1H2(1),m3h4x2(:,21),heltab2x8(:,:,52))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(45),n2h2(13))
call HGT_raise_alpha_OLR(G1H8(88),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(88),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(88),ex6(:),G1H4(8),m3h2x4(:,32),heltab2x8(:,:,53))
  call Hloop_QV_A(ntryL,G1H8(91),wf4(:,1),G1H2(1),m3h4x2(:,22),heltab2x8(:,:,54))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(46),n2h2(14))
call HGT_raise_alpha_OLR(G1H8(93),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(93),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(93),ex6(:),G1H4(9),m3h2x4(:,33),heltab2x8(:,:,55))
  call Hloop_QV_A(ntryL,G1H8(96),wf4(:,1),G1H2(1),m3h4x2(:,23),heltab2x8(:,:,56))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(47),n2h2(15))
  call Hloop_QZ_A(ntryL,G1H8(97),wf4(:,8),G1H2(1),ngZd,m3h4x2(:,24),heltab2x8(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(48),n2h2(16))
call HGT_raise_alpha_OLR(G1H8(98),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(98),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(98),ex6(:),G1H4(10),m3h2x4(:,34),heltab2x8(:,:,58))
  call Hloop_QZ_A(ntryL,G1H8(103),wf4(:,8),G1H2(1),ngZd,m3h4x2(:,25),heltab2x8(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(49),n2h2(17))
  call Hloop_QZ_A(ntryL,G1H8(108),wf4(:,8),G1H2(1),ngZd,m3h4x2(:,26),heltab2x8(:,:,60))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(50),n2h2(18))
call HGT_raise_alpha_OLR(G1H8(104),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(104),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(104),ex6(:),G1H4(11),m3h2x4(:,35),heltab2x8(:,:,61))
  call Hloop_QZ_A(ntryL,G1H8(107),wf4(:,8),G1H2(1),ngZd,m3h4x2(:,27),heltab2x8(:,:,62))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(51),n2h2(19))
call HGT_raise_alpha_OLR(G1H8(109),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(109),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(109),ex6(:),G1H4(12),m3h2x4(:,36),heltab2x8(:,:,63))
  call Hloop_QZ_A(ntryL,G1H8(112),wf4(:,8),G1H2(1),ngZd,m3h4x2(:,28),heltab2x8(:,:,64))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(52),n2h2(20))
  call Hloop_QV_A(ntryL,G1H8(113),wf4(:,12),G1H2(1),m3h4x2(:,29),heltab2x8(:,:,65))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(53),n2h2(21))
call HGT_raise_alpha_OLR(G1H8(114),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(114),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(114),ex6(:),G1H4(13),m3h2x4(:,37),heltab2x8(:,:,66))
  call Hloop_QV_A(ntryL,G1H8(119),wf4(:,12),G1H2(1),m3h4x2(:,30),heltab2x8(:,:,67))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(54),n2h2(22))
  call Hloop_QV_A(ntryL,G1H8(124),wf4(:,12),G1H2(1),m3h4x2(:,31),heltab2x8(:,:,68))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(55),n2h2(23))
call HGT_raise_alpha_OLR(G1H8(120),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(120),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(120),ex6(:),G1H4(14),m3h2x4(:,38),heltab2x8(:,:,69))
  call Hloop_QV_A(ntryL,G1H8(123),wf4(:,12),G1H2(1),m3h4x2(:,32),heltab2x8(:,:,70))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(56),n2h2(24))
call HGT_raise_alpha_OLR(G1H8(125),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(125),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(125),ex6(:),G1H4(15),m3h2x4(:,39),heltab2x8(:,:,71))
  call Hloop_QV_A(ntryL,G1H8(128),wf4(:,12),G1H2(1),m3h4x2(:,33),heltab2x8(:,:,72))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(57),n2h2(25))
  call Hloop_QZ_A(ntryL,G1H8(129),wf4(:,14),G1H2(1),ngZd,m3h4x2(:,34),heltab2x8(:,:,73))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(58),n2h2(26))
call HGT_raise_alpha_OLR(G1H8(130),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(130),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(130),ex6(:),G1H4(16),m3h2x4(:,40),heltab2x8(:,:,74))
  call Hloop_QZ_A(ntryL,G1H8(135),wf4(:,14),G1H2(1),ngZd,m3h4x2(:,35),heltab2x8(:,:,75))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(59),n2h2(27))
  call Hloop_QZ_A(ntryL,G1H8(140),wf4(:,14),G1H2(1),ngZd,m3h4x2(:,36),heltab2x8(:,:,76))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(60),n2h2(28))
call HGT_raise_alpha_OLR(G1H8(136),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(136),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(136),ex6(:),G1H4(17),m3h2x4(:,41),heltab2x8(:,:,77))
  call Hloop_QZ_A(ntryL,G1H8(139),wf4(:,14),G1H2(1),ngZd,m3h4x2(:,37),heltab2x8(:,:,78))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(61),n2h2(29))
call HGT_raise_alpha_OLR(G1H8(141),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(141),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(141),ex6(:),G1H4(18),m3h2x4(:,42),heltab2x8(:,:,79))
  call Hloop_QZ_A(ntryL,G1H8(144),wf4(:,14),G1H2(1),ngZd,m3h4x2(:,38),heltab2x8(:,:,80))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(62),n2h2(30))
  call Hloop_QV_A(ntryL,G1H8(145),wf4(:,11),G1H2(1),m3h4x2(:,39),heltab2x8(:,:,81))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(63),n2h2(31))
call HGT_raise_alpha_OLR(G1H8(146),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(146),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(146),ex6(:),G1H4(19),m3h2x4(:,43),heltab2x8(:,:,82))
  call Hloop_QV_A(ntryL,G1H8(151),wf4(:,11),G1H2(1),m3h4x2(:,40),heltab2x8(:,:,83))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(64),n2h2(32))
  call Hloop_QV_A(ntryL,G1H8(156),wf4(:,11),G1H2(1),m3h4x2(:,41),heltab2x8(:,:,84))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(65),n2h2(33))
call HGT_raise_alpha_OLR(G1H8(152),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(152),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(152),ex6(:),G1H4(20),m3h2x4(:,44),heltab2x8(:,:,85))
  call Hloop_QV_A(ntryL,G1H8(155),wf4(:,11),G1H2(1),m3h4x2(:,42),heltab2x8(:,:,86))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(66),n2h2(34))
call HGT_raise_alpha_OLR(G1H8(157),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(157),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(157),ex6(:),G1H4(21),m3h2x4(:,45),heltab2x8(:,:,87))
  call Hloop_QV_A(ntryL,G1H8(160),wf4(:,11),G1H2(1),m3h4x2(:,43),heltab2x8(:,:,88))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(67),n2h2(35))
  call Hloop_QZ_A(ntryL,G1H8(161),wf4(:,16),G1H2(1),ngZd,m3h4x2(:,44),heltab2x8(:,:,89))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(68),n2h2(36))
call HGT_raise_alpha_OLR(G1H8(162),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(162),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(162),ex6(:),G1H4(22),m3h2x4(:,46),heltab2x8(:,:,90))
  call Hloop_QZ_A(ntryL,G1H8(167),wf4(:,16),G1H2(1),ngZd,m3h4x2(:,45),heltab2x8(:,:,91))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(69),n2h2(37))
  call Hloop_QZ_A(ntryL,G1H8(172),wf4(:,16),G1H2(1),ngZd,m3h4x2(:,46),heltab2x8(:,:,92))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(70),n2h2(38))
call HGT_raise_alpha_OLR(G1H8(168),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(168),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(168),ex6(:),G1H4(23),m3h2x4(:,47),heltab2x8(:,:,93))
  call Hloop_QZ_A(ntryL,G1H8(171),wf4(:,16),G1H2(1),ngZd,m3h4x2(:,47),heltab2x8(:,:,94))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(71),n2h2(39))
call HGT_raise_alpha_OLR(G1H8(173),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(173),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(173),ex6(:),G1H4(24),m3h2x4(:,48),heltab2x8(:,:,95))
  call Hloop_QZ_A(ntryL,G1H8(176),wf4(:,16),G1H2(1),ngZd,m3h4x2(:,48),heltab2x8(:,:,96))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(72),n2h2(40))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(38),[G2H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(40),[G2H2(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(48),[G2H2(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(50),[G2H2(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(58),[G2H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(60),[G2H2(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(68),[G2H2(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(70),[G2H2(65)])
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(2),16,2)
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(6),mass4set(:,1),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),2)
  call HG1shiftOLR(G1H2(8),48,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(2),mass5set(:,1),  & 
G1H2(12),G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),2)
  call HG1shiftOLR(G1H2(13),16,2)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(7),mass4set(:,1),  & 
G1H2(18),G1H2(19),G1H2(20),G1H2(21),G1H2(22),2)
  call HG1shiftOLR(G1H2(19),48,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(3),mass5set(:,1),  & 
G1H2(23),G1H2(24),G1H2(25),G1H2(26),G1H2(27),G1H2(28),2)
  call HG1shiftOLR(G1H2(24),32,2)
  call Hotf_4pt_reduction(G2H2(9),RedSet_4(6),mass4set(:,1),  & 
G1H2(29),G1H2(30),G1H2(31),G1H2(32),G1H2(33),2)
  call HG1shiftOLR(G1H2(30),48,2)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(4),mass5set(:,1),  & 
G1H2(34),G1H2(35),G1H2(36),G1H2(37),G1H2(38),G1H2(39),2)
  call HG1shiftOLR(G1H2(35),32,2)
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(7),mass4set(:,1),  & 
G1H2(40),G1H2(41),G1H2(42),G1H2(43),G1H2(44),2)
  call HG1shiftOLR(G1H2(41),48,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(7),mass5set(:,1),  & 
G1H2(45),G1H2(46),G1H2(47),G1H2(48),G1H2(49),G1H2(50),2)
  call HG1shiftOLR(G1H2(46),16,2)
  call Hotf_4pt_reduction(G2H2(15),RedSet_4(8),mass4set(:,1),  & 
G1H2(51),G1H2(52),G1H2(53),G1H2(54),G1H2(55),2)
  call HG1shiftOLR(G1H2(52),48,2)
  call Hotf_5pt_reduction(G2H2(16),RedSet_5(8),mass5set(:,1),  & 
G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),G1H2(61),2)
  call HG1shiftOLR(G1H2(57),16,2)
  call Hotf_4pt_reduction(G2H2(18),RedSet_4(9),mass4set(:,1),  & 
G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(63),48,2)
  call Hotf_5pt_reduction(G2H2(19),RedSet_5(9),mass5set(:,1),  & 
G1H2(67),G1H2(68),G1H2(69),G1H2(70),G1H2(71),G1H2(72),2)
  call HG1shiftOLR(G1H2(68),32,2)
  call Hotf_4pt_reduction(G2H2(21),RedSet_4(8),mass4set(:,1),  & 
G1H2(73),G1H2(74),G1H2(75),G1H2(76),G1H2(77),2)
  call HG1shiftOLR(G1H2(74),48,2)
  call Hotf_5pt_reduction(G2H2(22),RedSet_5(10),mass5set(:,1),  & 
G1H2(78),G1H2(79),G1H2(80),G1H2(81),G1H2(82),G1H2(83),2)
  call HG1shiftOLR(G1H2(79),32,2)
  call Hotf_4pt_reduction(G2H2(24),RedSet_4(9),mass4set(:,1),  & 
G1H2(84),G1H2(85),G1H2(86),G1H2(87),G1H2(88),2)
  call HG1shiftOLR(G1H2(85),48,2)
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(13),mass5set(:,1),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
  call HG1shiftOLR(G1H4(26),10,4)
  call Hotf_4pt_reduction(G2H4(4),RedSet_4(10),mass4set(:,1),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),4)
  call HG1shiftOLR(G1H4(32),42,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(13),mass5set(:,1),  & 
G1H4(36),G1H4(37),G1H4(38),G1H4(39),G1H4(40),G1H4(41),4)
  call HG1shiftOLR(G1H4(37),10,4)
  call Hotf_4pt_reduction(G2H4(12),RedSet_4(10),mass4set(:,1),  & 
G1H4(42),G1H4(43),G1H4(44),G1H4(45),G1H4(46),4)
  call HG1shiftOLR(G1H4(43),42,4)
  call Hotf_5pt_reduction(G2H4(17),RedSet_5(14),mass5set(:,1),  & 
G1H4(47),G1H4(48),G1H4(49),G1H4(50),G1H4(51),G1H4(52),4)
  call HG1shiftOLR(G1H4(48),10,4)
  call Hotf_4pt_reduction(G2H4(20),RedSet_4(11),mass4set(:,1),  & 
G1H4(53),G1H4(54),G1H4(55),G1H4(56),G1H4(57),4)
  call HG1shiftOLR(G1H4(54),26,4)
  call Hotf_5pt_reduction(G2H4(25),RedSet_5(14),mass5set(:,1),  & 
G1H4(58),G1H4(59),G1H4(60),G1H4(61),G1H4(62),G1H4(63),4)
  call HG1shiftOLR(G1H4(59),10,4)
  call Hotf_4pt_reduction(G2H4(28),RedSet_4(11),mass4set(:,1),  & 
G1H4(64),G1H4(65),G1H4(66),G1H4(67),G1H4(68),4)
  call HG1shiftOLR(G1H4(65),26,4)
  call Hotf_5pt_reduction(G2H4(33),RedSet_5(15),mass5set(:,1),  & 
G1H4(69),G1H4(70),G1H4(71),G1H4(72),G1H4(73),G1H4(74),4)
  call HG1shiftOLR(G1H4(70),9,4)
  call Hotf_4pt_reduction(G2H4(36),RedSet_4(12),mass4set(:,1),  & 
G1H4(75),G1H4(76),G1H4(77),G1H4(78),G1H4(79),4)
  call HG1shiftOLR(G1H4(76),25,4)
  call Hotf_5pt_reduction(G2H4(41),RedSet_5(15),mass5set(:,1),  & 
G1H4(80),G1H4(81),G1H4(82),G1H4(83),G1H4(84),G1H4(85),4)
  call HG1shiftOLR(G1H4(81),9,4)
  call Hotf_4pt_reduction(G2H4(44),RedSet_4(12),mass4set(:,1),  & 
G1H4(86),G1H4(87),G1H4(88),G1H4(89),G1H4(90),4)
  call HG1shiftOLR(G1H4(87),25,4)
  call Hotf_5pt_reduction(G2H4(49),RedSet_5(16),mass5set(:,1),  & 
G1H4(91),G1H4(92),G1H4(93),G1H4(94),G1H4(95),G1H4(96),4)
  call HG1shiftOLR(G1H4(92),9,4)
  call Hotf_4pt_reduction(G2H4(52),RedSet_4(13),mass4set(:,1),  & 
G1H4(97),G1H4(98),G1H4(99),G1H4(100),G1H4(101),4)
  call HG1shiftOLR(G1H4(98),41,4)
  call Hotf_5pt_reduction(G2H4(57),RedSet_5(16),mass5set(:,1),  & 
G1H4(102),G1H4(103),G1H4(104),G1H4(105),G1H4(106),G1H4(107),4)
  call HG1shiftOLR(G1H4(103),9,4)
  call Hotf_4pt_reduction(G2H4(60),RedSet_4(13),mass4set(:,1),  & 
G1H4(108),G1H4(109),G1H4(110),G1H4(111),G1H4(112),4)
  call HG1shiftOLR(G1H4(109),41,4)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(38),ex6(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(40),ex6(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(48),ex6(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(50),ex6(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(58),ex6(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(60),ex6(:),G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(68),ex6(:),G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(70),ex6(:),G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(7),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(18),[G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(29),[G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(40),[G1H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(51),[G1H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(62),[G1H2(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(73),[G1H2(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(84),[G1H2(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(31),[G1H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(42),[G1H4(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(53),[G1H4(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(64),[G1H4(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(75),[G1H4(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(86),[G1H4(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(97),[G1H4(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(108),[G1H4(107)])
  call Hloop_VQ_A(ntryL,G1H2(1),ex5(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(9),n2h1(1))
  call Hloop_VQ_A(ntryL,G1H2(2),ex5(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(10),n2h1(2))
  call Hloop_VQ_A(ntryL,G1H2(7),ex5(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(11),n2h1(3))
  call Hloop_VQ_A(ntryL,G1H2(8),ex5(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,0,G2tensor(12),n2h1(4))
  call Hloop_VQ_A(ntryL,G1H2(12),ex5(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(13),n2h1(5))
  call Hloop_VQ_A(ntryL,G1H2(13),ex5(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(14),n2h1(6))
  call Hloop_VQ_A(ntryL,G1H2(18),ex5(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(15),n2h1(7))
  call Hloop_VQ_A(ntryL,G1H2(19),ex5(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,0,G2tensor(16),n2h1(8))
  call Hloop_VA_Q(ntryL,G1H2(23),ex6(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(17),n2h1(9))
  call Hloop_VA_Q(ntryL,G1H2(24),ex6(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(18),n2h1(10))
  call Hloop_VA_Q(ntryL,G1H2(29),ex6(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(19),n2h1(11))
  call Hloop_VA_Q(ntryL,G1H2(30),ex6(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,0,G2tensor(20),n2h1(12))
  call Hloop_VA_Q(ntryL,G1H2(34),ex6(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(21),n2h1(13))
  call Hloop_VA_Q(ntryL,G1H2(35),ex6(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(22),n2h1(14))
  call Hloop_VA_Q(ntryL,G1H2(40),ex6(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(23),n2h1(15))
  call Hloop_VA_Q(ntryL,G1H2(41),ex6(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,0,G2tensor(24),n2h1(16))
  call Hloop_VQ_A(ntryL,G1H2(45),ex5(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(25),n2h1(17))
  call Hloop_VQ_A(ntryL,G1H2(46),ex5(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(26),n2h1(18))
  call Hloop_VQ_A(ntryL,G1H2(51),ex5(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(27),n2h1(19))
  call Hloop_VQ_A(ntryL,G1H2(52),ex5(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,0,G2tensor(28),n2h1(20))
  call Hloop_VQ_A(ntryL,G1H2(56),ex5(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(29),n2h1(21))
  call Hloop_VQ_A(ntryL,G1H2(57),ex5(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(30),n2h1(22))
  call Hloop_VQ_A(ntryL,G1H2(62),ex5(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(31),n2h1(23))
  call Hloop_VQ_A(ntryL,G1H2(63),ex5(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,0,G2tensor(32),n2h1(24))
  call Hloop_VA_Q(ntryL,G1H2(67),ex6(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(33),n2h1(25))
  call Hloop_VA_Q(ntryL,G1H2(68),ex6(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(34),n2h1(26))
  call Hloop_VA_Q(ntryL,G1H2(73),ex6(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(35),n2h1(27))
  call Hloop_VA_Q(ntryL,G1H2(74),ex6(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,0,G2tensor(36),n2h1(28))
  call Hloop_VA_Q(ntryL,G1H2(78),ex6(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(37),n2h1(29))
  call Hloop_VA_Q(ntryL,G1H2(79),ex6(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(38),n2h1(30))
  call Hloop_VA_Q(ntryL,G1H2(84),ex6(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(39),n2h1(31))
  call Hloop_VA_Q(ntryL,G1H2(85),ex6(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,0,G2tensor(40),n2h1(32))
  call Hloop_AV_Q(ntryL,G1H4(25),wf4(:,2),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(41),n2h1(33))
  call Hloop_AV_Q(ntryL,G1H4(26),wf4(:,2),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(42),n2h1(34))
  call Hloop_AV_Q(ntryL,G1H4(31),wf4(:,2),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(43),n2h1(35))
  call Hloop_AV_Q(ntryL,G1H4(32),wf4(:,2),G1H1(1),m3h4x1(:,4),heltab2x4(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),42,0,G2tensor(44),n2h1(36))
  call Hloop_AZ_Q(ntryL,G1H4(36),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,5),heltab2x4(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(45),n2h1(37))
  call Hloop_AZ_Q(ntryL,G1H4(37),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,6),heltab2x4(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(46),n2h1(38))
  call Hloop_AZ_Q(ntryL,G1H4(42),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,7),heltab2x4(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(47),n2h1(39))
  call Hloop_AZ_Q(ntryL,G1H4(43),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,8),heltab2x4(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),42,0,G2tensor(48),n2h1(40))
  call Hloop_QV_A(ntryL,G1H4(47),wf4(:,2),G1H1(1),m3h4x1(:,9),heltab2x4(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(49),n2h1(41))
  call Hloop_QV_A(ntryL,G1H4(48),wf4(:,2),G1H1(1),m3h4x1(:,10),heltab2x4(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(50),n2h1(42))
  call Hloop_QV_A(ntryL,G1H4(53),wf4(:,2),G1H1(1),m3h4x1(:,11),heltab2x4(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(51),n2h1(43))
  call Hloop_QV_A(ntryL,G1H4(54),wf4(:,2),G1H1(1),m3h4x1(:,12),heltab2x4(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),26,0,G2tensor(52),n2h1(44))
  call Hloop_QZ_A(ntryL,G1H4(58),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,13),heltab2x4(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(53),n2h1(45))
  call Hloop_QZ_A(ntryL,G1H4(59),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,14),heltab2x4(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(54),n2h1(46))
  call Hloop_QZ_A(ntryL,G1H4(64),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,15),heltab2x4(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(55),n2h1(47))
  call Hloop_QZ_A(ntryL,G1H4(65),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,16),heltab2x4(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),26,0,G2tensor(56),n2h1(48))
  call Hloop_QV_A(ntryL,G1H4(69),wf4(:,11),G1H1(1),m3h4x1(:,17),heltab2x4(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(57),n2h1(49))
  call Hloop_QV_A(ntryL,G1H4(70),wf4(:,11),G1H1(1),m3h4x1(:,18),heltab2x4(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(58),n2h1(50))
  call Hloop_QV_A(ntryL,G1H4(75),wf4(:,11),G1H1(1),m3h4x1(:,19),heltab2x4(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(59),n2h1(51))
  call Hloop_QV_A(ntryL,G1H4(76),wf4(:,11),G1H1(1),m3h4x1(:,20),heltab2x4(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),25,0,G2tensor(60),n2h1(52))
  call Hloop_QZ_A(ntryL,G1H4(80),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,21),heltab2x4(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(61),n2h1(53))
  call Hloop_QZ_A(ntryL,G1H4(81),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,22),heltab2x4(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(62),n2h1(54))
  call Hloop_QZ_A(ntryL,G1H4(86),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,23),heltab2x4(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(63),n2h1(55))
  call Hloop_QZ_A(ntryL,G1H4(87),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,24),heltab2x4(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),25,0,G2tensor(64),n2h1(56))
  call Hloop_AV_Q(ntryL,G1H4(91),wf4(:,11),G1H1(1),m3h4x1(:,25),heltab2x4(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(65),n2h1(57))
  call Hloop_AV_Q(ntryL,G1H4(92),wf4(:,11),G1H1(1),m3h4x1(:,26),heltab2x4(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,0,G2tensor(66),n2h1(58))
  call Hloop_AV_Q(ntryL,G1H4(97),wf4(:,11),G1H1(1),m3h4x1(:,27),heltab2x4(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(67),n2h1(59))
  call Hloop_AV_Q(ntryL,G1H4(98),wf4(:,11),G1H1(1),m3h4x1(:,28),heltab2x4(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),41,0,G2tensor(68),n2h1(60))
  call Hloop_AZ_Q(ntryL,G1H4(102),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,29),heltab2x4(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(69),n2h1(61))
  call Hloop_AZ_Q(ntryL,G1H4(103),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,30),heltab2x4(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,0,G2tensor(70),n2h1(62))
  call Hloop_AZ_Q(ntryL,G1H4(108),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,31),heltab2x4(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(71),n2h1(63))
  call Hloop_AZ_Q(ntryL,G1H4(109),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,32),heltab2x4(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),41,0,G2tensor(72),n2h1(64))
  call ol_merge_tensors(G2tensor(45),[G2tensor(41)])
  call ol_merge_tensors(G2tensor(53),[G2tensor(49)])
  call ol_merge_tensors(G2tensor(61),[G2tensor(57)])
  call ol_merge_tensors(G2tensor(69),[G2tensor(65)])
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(5),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),32)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(6),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),32)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(11),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),32)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(12),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),32)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(1),mass5set(:,1),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),16)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(2),mass5set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),16)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(3),mass5set(:,1),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),32)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(4),mass5set(:,1),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),32)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(7),mass5set(:,1),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),16)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(8),mass5set(:,1),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),16)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(9),mass5set(:,1),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),32)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(10),mass5set(:,1),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),32)
  call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(13),mass5set(:,1),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),10)
  call Hotf_5pt_reduction_last(G2tensor(53),RedSet_5(14),mass5set(:,1),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),10)
  call Hotf_5pt_reduction_last(G2tensor(61),RedSet_5(15),mass5set(:,1),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),9)
  call Hotf_5pt_reduction_last(G2tensor(69),RedSet_5(16),mass5set(:,1),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),9)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(686)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(65),h0tab(:,65),[64,5,48,10],[0,0,0,0],4,3,wf4(:,1),wf4(:,17),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,65),heltab2x128(:,:,65))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(1),n2h64(49))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(686)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(66),h0tab(:,66),[64,5,48,10],[nMT,nMT,nMT,nMT],4,3,wf4(:,1),wf4(:,17) &
    ,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,66),heltab2x128(:,:,66))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(2),n2h64(50))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(686)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(67),h0tab(:,67),[64,5,48,10],[0,0,0,0],4,3,wf4(:,1),wf4(:,17),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,67),heltab2x128(:,:,67))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(3),n2h64(51))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(686)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(68),h0tab(:,68),[64,5,48,10],[nMT,nMT,nMT,nMT],4,3,wf4(:,1),wf4(:,17) &
    ,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,68),heltab2x128(:,:,68))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(4),n2h64(52))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(686)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(69),h0tab(:,69),[64,5,48,10],[0,0,0,0],4,3,wf4(:,1),wf4(:,17),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,69),heltab2x128(:,:,69))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(5),n2h64(53))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(686)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(70),h0tab(:,70),[64,5,48,10],[nMB,nMB,nMB,nMB],4,3,wf4(:,1),wf4(:,17) &
    ,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,70),heltab2x128(:,:,70))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(6),n2h64(54))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(686)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(71),h0tab(:,71),[64,5,48,10],[0,0,0,0],4,3,wf4(:,1),wf4(:,17),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,71),heltab2x128(:,:,71))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(7),n2h64(55))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(686)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(72),h0tab(:,72),[64,5,48,10],[nMB,nMB,nMB,nMB],4,3,wf4(:,1),wf4(:,17) &
    ,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,72),heltab2x128(:,:,72))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(8),n2h64(56))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(687)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(73),h0tab(:,73),[64,5,48,10],[0,0,0,0],4,3,wf4(:,1),wf4(:,17),wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,73),heltab2x128(:,:,73))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(9),n2h64(57))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(687)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(74),h0tab(:,74),[64,5,48,10],[nMT,nMT,nMT,nMT],4,3,wf4(:,1),wf4(:,17) &
    ,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,74),heltab2x128(:,:,74))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(10),n2h64(58))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(687)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(75),h0tab(:,75),[64,5,48,10],[0,0,0,0],4,3,wf4(:,1),wf4(:,17),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,75),heltab2x128(:,:,75))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(11),n2h64(59))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(687)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(76),h0tab(:,76),[64,5,48,10],[nMT,nMT,nMT,nMT],4,3,wf4(:,1),wf4(:,17) &
    ,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,76),heltab2x128(:,:,76))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(12),n2h64(60))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(687)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(77),h0tab(:,77),[64,5,48,10],[0,0,0,0],4,3,wf4(:,1),wf4(:,17),wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,77),heltab2x128(:,:,77))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(13),n2h64(61))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(687)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(78),h0tab(:,78),[64,5,48,10],[nMB,nMB,nMB,nMB],4,3,wf4(:,1),wf4(:,17) &
    ,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,78),heltab2x128(:,:,78))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(14),n2h64(62))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(687)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(79),h0tab(:,79),[64,5,48,10],[0,0,0,0],4,3,wf4(:,1),wf4(:,17),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,79),heltab2x128(:,:,79))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(15),n2h64(63))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(687)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(80),h0tab(:,80),[64,5,48,10],[nMB,nMB,nMB,nMB],4,3,wf4(:,1),wf4(:,17) &
    ,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,80),heltab2x128(:,:,80))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(16),n2h64(64))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(688)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(81),h0tab(:,81),[64,5,48,10],[0,0,0,0],4,3,wf4(:,8),wf4(:,17),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,81),heltab2x128(:,:,81))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(17),n2h64(65))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(688)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(82),h0tab(:,82),[64,5,48,10],[nMT,nMT,nMT,nMT],4,3,wf4(:,8),wf4(:,17) &
    ,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,82),heltab2x128(:,:,82))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(18),n2h64(66))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(688)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(83),h0tab(:,83),[64,5,48,10],[0,0,0,0],4,3,wf4(:,8),wf4(:,17),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,83),heltab2x128(:,:,83))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(19),n2h64(67))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(688)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(84),h0tab(:,84),[64,5,48,10],[nMT,nMT,nMT,nMT],4,3,wf4(:,8),wf4(:,17) &
    ,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,84),heltab2x128(:,:,84))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(20),n2h64(68))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(688)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(85),h0tab(:,85),[64,5,48,10],[0,0,0,0],4,3,wf4(:,8),wf4(:,17),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,85),heltab2x128(:,:,85))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(21),n2h64(69))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(688)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(86),h0tab(:,86),[64,5,48,10],[nMB,nMB,nMB,nMB],4,3,wf4(:,8),wf4(:,17) &
    ,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,86),heltab2x128(:,:,86))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(22),n2h64(70))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(688)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(87),h0tab(:,87),[64,5,48,10],[0,0,0,0],4,3,wf4(:,8),wf4(:,17),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,87),heltab2x128(:,:,87))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(23),n2h64(71))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(688)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(88),h0tab(:,88),[64,5,48,10],[nMB,nMB,nMB,nMB],4,3,wf4(:,8),wf4(:,17) &
    ,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,88),heltab2x128(:,:,88))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(24),n2h64(72))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(689)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(89),h0tab(:,89),[64,5,48,10],[0,0,0,0],4,3,wf4(:,8),wf4(:,17),wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,89),heltab2x128(:,:,89))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(25),n2h64(73))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(689)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(90),h0tab(:,90),[64,5,48,10],[nMT,nMT,nMT,nMT],4,3,wf4(:,8),wf4(:,17) &
    ,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,90),heltab2x128(:,:,90))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(26),n2h64(74))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(689)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(91),h0tab(:,91),[64,5,48,10],[0,0,0,0],4,3,wf4(:,8),wf4(:,17),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,91),heltab2x128(:,:,91))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(27),n2h64(75))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(689)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(92),h0tab(:,92),[64,5,48,10],[nMT,nMT,nMT,nMT],4,3,wf4(:,8),wf4(:,17) &
    ,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,92),heltab2x128(:,:,92))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(28),n2h64(76))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(689)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(93),h0tab(:,93),[64,5,48,10],[0,0,0,0],4,3,wf4(:,8),wf4(:,17),wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,93),heltab2x128(:,:,93))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(29),n2h64(77))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(689)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(94),h0tab(:,94),[64,5,48,10],[nMB,nMB,nMB,nMB],4,3,wf4(:,8),wf4(:,17) &
    ,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,94),heltab2x128(:,:,94))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(30),n2h64(78))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(689)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(95),h0tab(:,95),[64,5,48,10],[0,0,0,0],4,3,wf4(:,8),wf4(:,17),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,95),heltab2x128(:,:,95))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(31),n2h64(79))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(689)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(96),h0tab(:,96),[64,5,48,10],[nMB,nMB,nMB,nMB],4,3,wf4(:,8),wf4(:,17) &
    ,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,96),heltab2x128(:,:,96))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(32),n2h64(80))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(686)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(97),h0tab(:,97),[64,5,10,48],[0,0,0,0],4,3,wf4(:,1),wf4(:,2),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,97),heltab2x128(:,:,97))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(33),n2h64(81))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(686)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(98),h0tab(:,98),[64,5,10,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,1),wf4(:,2),wf4(: &
    ,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,98),heltab2x128(:,:,98))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(34),n2h64(82))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(686)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(99),h0tab(:,99),[64,5,10,48],[0,0,0,0],4,3,wf4(:,1),wf4(:,2),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,99),heltab2x128(:,:,99))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(35),n2h64(83))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(686)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(100),h0tab(:,100),[64,5,10,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,1),wf4(:,2) &
    ,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,100),heltab2x128(:,:,100))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(36),n2h64(84))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(686)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(101),h0tab(:,101),[64,5,10,48],[0,0,0,0],4,3,wf4(:,1),wf4(:,2),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,101),heltab2x128(:,:,101))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(37),n2h64(85))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(686)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(102),h0tab(:,102),[64,5,10,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,1),wf4(:,2) &
    ,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,102),heltab2x128(:,:,102))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(38),n2h64(86))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(686)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(103),h0tab(:,103),[64,5,10,48],[0,0,0,0],4,3,wf4(:,1),wf4(:,2),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,103),heltab2x128(:,:,103))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(39),n2h64(87))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(686)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(104),h0tab(:,104),[64,5,10,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,1),wf4(:,2) &
    ,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,104),heltab2x128(:,:,104))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(40),n2h64(88))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(687)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(105),h0tab(:,105),[64,5,10,48],[0,0,0,0],4,3,wf4(:,1),wf4(:,6),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,105),heltab2x128(:,:,105))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(41),n2h64(89))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(687)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(106),h0tab(:,106),[64,5,10,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,1),wf4(:,6) &
    ,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,106),heltab2x128(:,:,106))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(42),n2h64(90))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(687)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(107),h0tab(:,107),[64,5,10,48],[0,0,0,0],4,3,wf4(:,1),wf4(:,6),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,107),heltab2x128(:,:,107))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(43),n2h64(91))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(687)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(108),h0tab(:,108),[64,5,10,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,1),wf4(:,6) &
    ,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,108),heltab2x128(:,:,108))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(44),n2h64(92))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(687)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(109),h0tab(:,109),[64,5,10,48],[0,0,0,0],4,3,wf4(:,1),wf4(:,6),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,109),heltab2x128(:,:,109))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(45),n2h64(93))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(687)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(110),h0tab(:,110),[64,5,10,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,1),wf4(:,6) &
    ,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,110),heltab2x128(:,:,110))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(46),n2h64(94))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(687)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(111),h0tab(:,111),[64,5,10,48],[0,0,0,0],4,3,wf4(:,1),wf4(:,6),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,111),heltab2x128(:,:,111))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(47),n2h64(95))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(687)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(112),h0tab(:,112),[64,5,10,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,1),wf4(:,6) &
    ,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,112),heltab2x128(:,:,112))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(48),n2h64(96))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(688)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(113),h0tab(:,113),[64,5,10,48],[0,0,0,0],4,3,wf4(:,8),wf4(:,2),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,113),heltab2x128(:,:,113))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(49),n2h64(97))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(688)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(114),h0tab(:,114),[64,5,10,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,8),wf4(:,2) &
    ,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,114),heltab2x128(:,:,114))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(50),n2h64(98))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(688)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(115),h0tab(:,115),[64,5,10,48],[0,0,0,0],4,3,wf4(:,8),wf4(:,2),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,115),heltab2x128(:,:,115))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(51),n2h64(99))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(688)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(116),h0tab(:,116),[64,5,10,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,8),wf4(:,2) &
    ,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,116),heltab2x128(:,:,116))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(52),n2h64(100))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(688)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(117),h0tab(:,117),[64,5,10,48],[0,0,0,0],4,3,wf4(:,8),wf4(:,2),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,117),heltab2x128(:,:,117))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(53),n2h64(101))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(688)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(118),h0tab(:,118),[64,5,10,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,8),wf4(:,2) &
    ,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,118),heltab2x128(:,:,118))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(54),n2h64(102))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(688)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(119),h0tab(:,119),[64,5,10,48],[0,0,0,0],4,3,wf4(:,8),wf4(:,2),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,119),heltab2x128(:,:,119))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(55),n2h64(103))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(688)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(120),h0tab(:,120),[64,5,10,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,8),wf4(:,2) &
    ,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,120),heltab2x128(:,:,120))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(56),n2h64(104))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(689)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(121),h0tab(:,121),[64,5,10,48],[0,0,0,0],4,3,wf4(:,8),wf4(:,6),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,121),heltab2x128(:,:,121))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(57),n2h64(105))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(689)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(122),h0tab(:,122),[64,5,10,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,8),wf4(:,6) &
    ,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,122),heltab2x128(:,:,122))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(58),n2h64(106))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(689)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(123),h0tab(:,123),[64,5,10,48],[0,0,0,0],4,3,wf4(:,8),wf4(:,6),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,123),heltab2x128(:,:,123))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(59),n2h64(107))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(689)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(124),h0tab(:,124),[64,5,10,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,8),wf4(:,6) &
    ,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,124),heltab2x128(:,:,124))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(60),n2h64(108))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(689)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(125),h0tab(:,125),[64,5,10,48],[0,0,0,0],4,3,wf4(:,8),wf4(:,6),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,125),heltab2x128(:,:,125))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(61),n2h64(109))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(689)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(126),h0tab(:,126),[64,5,10,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,8),wf4(:,6) &
    ,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,126),heltab2x128(:,:,126))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(62),n2h64(110))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(689)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(127),h0tab(:,127),[64,5,10,48],[0,0,0,0],4,3,wf4(:,8),wf4(:,6),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,127),heltab2x128(:,:,127))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(63),n2h64(111))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(689)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(128),h0tab(:,128),[64,5,10,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,8),wf4(:,6) &
    ,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,128),heltab2x128(:,:,128))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(64),n2h64(112))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(686)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(129),h0tab(:,129),[64,10,5,48],[0,0,0,0],4,3,wf4(:,2),wf4(:,1),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,129),heltab2x128(:,:,129))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(65),n2h64(113))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(686)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(130),h0tab(:,130),[64,10,5,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,2),wf4(:,1) &
    ,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,130),heltab2x128(:,:,130))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(66),n2h64(114))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(686)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(131),h0tab(:,131),[64,10,5,48],[0,0,0,0],4,3,wf4(:,2),wf4(:,1),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,131),heltab2x128(:,:,131))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(67),n2h64(115))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(686)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(132),h0tab(:,132),[64,10,5,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,2),wf4(:,1) &
    ,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,132),heltab2x128(:,:,132))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(68),n2h64(116))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(686)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(133),h0tab(:,133),[64,10,5,48],[0,0,0,0],4,3,wf4(:,2),wf4(:,1),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,133),heltab2x128(:,:,133))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(69),n2h64(117))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(686)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(134),h0tab(:,134),[64,10,5,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,2),wf4(:,1) &
    ,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,134),heltab2x128(:,:,134))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(70),n2h64(118))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(686)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(135),h0tab(:,135),[64,10,5,48],[0,0,0,0],4,3,wf4(:,2),wf4(:,1),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,135),heltab2x128(:,:,135))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(71),n2h64(119))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(686)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(136),h0tab(:,136),[64,10,5,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,2),wf4(:,1) &
    ,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,136),heltab2x128(:,:,136))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(72),n2h64(120))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(687)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(137),h0tab(:,137),[64,10,5,48],[0,0,0,0],4,3,wf4(:,6),wf4(:,1),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,137),heltab2x128(:,:,137))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(73),n2h64(121))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(687)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(138),h0tab(:,138),[64,10,5,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,6),wf4(:,1) &
    ,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,138),heltab2x128(:,:,138))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(74),n2h64(122))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(687)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(139),h0tab(:,139),[64,10,5,48],[0,0,0,0],4,3,wf4(:,6),wf4(:,1),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,139),heltab2x128(:,:,139))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(75),n2h64(123))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(687)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(140),h0tab(:,140),[64,10,5,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,6),wf4(:,1) &
    ,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,140),heltab2x128(:,:,140))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(76),n2h64(124))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(687)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(141),h0tab(:,141),[64,10,5,48],[0,0,0,0],4,3,wf4(:,6),wf4(:,1),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,141),heltab2x128(:,:,141))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(77),n2h64(125))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(687)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(142),h0tab(:,142),[64,10,5,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,6),wf4(:,1) &
    ,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,142),heltab2x128(:,:,142))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(78),n2h64(126))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(687)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(143),h0tab(:,143),[64,10,5,48],[0,0,0,0],4,3,wf4(:,6),wf4(:,1),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,143),heltab2x128(:,:,143))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(79),n2h64(127))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(687)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(144),h0tab(:,144),[64,10,5,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,6),wf4(:,1) &
    ,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,144),heltab2x128(:,:,144))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(80),n2h64(128))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(688)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(145),h0tab(:,145),[64,10,5,48],[0,0,0,0],4,3,wf4(:,2),wf4(:,8),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,145),heltab2x128(:,:,145))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(81),n2h64(129))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(688)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(146),h0tab(:,146),[64,10,5,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,2),wf4(:,8) &
    ,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,146),heltab2x128(:,:,146))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(82),n2h64(130))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(688)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(147),h0tab(:,147),[64,10,5,48],[0,0,0,0],4,3,wf4(:,2),wf4(:,8),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,147),heltab2x128(:,:,147))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(83),n2h64(131))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(688)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(148),h0tab(:,148),[64,10,5,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,2),wf4(:,8) &
    ,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,148),heltab2x128(:,:,148))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(84),n2h64(132))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(688)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(149),h0tab(:,149),[64,10,5,48],[0,0,0,0],4,3,wf4(:,2),wf4(:,8),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,149),heltab2x128(:,:,149))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(85),n2h64(133))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(688)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(150),h0tab(:,150),[64,10,5,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,2),wf4(:,8) &
    ,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,150),heltab2x128(:,:,150))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(86),n2h64(134))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(688)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(151),h0tab(:,151),[64,10,5,48],[0,0,0,0],4,3,wf4(:,2),wf4(:,8),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,151),heltab2x128(:,:,151))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(87),n2h64(135))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(688)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(152),h0tab(:,152),[64,10,5,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,2),wf4(:,8) &
    ,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,152),heltab2x128(:,:,152))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(88),n2h64(136))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(689)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(153),h0tab(:,153),[64,10,5,48],[0,0,0,0],4,3,wf4(:,6),wf4(:,8),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,153),heltab2x128(:,:,153))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(89),n2h64(137))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(689)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(154),h0tab(:,154),[64,10,5,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,6),wf4(:,8) &
    ,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,154),heltab2x128(:,:,154))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(90),n2h64(138))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(689)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(155),h0tab(:,155),[64,10,5,48],[0,0,0,0],4,3,wf4(:,6),wf4(:,8),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,155),heltab2x128(:,:,155))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(91),n2h64(139))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(689)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(156),h0tab(:,156),[64,10,5,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,6),wf4(:,8) &
    ,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,156),heltab2x128(:,:,156))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(92),n2h64(140))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(689)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(157),h0tab(:,157),[64,10,5,48],[0,0,0,0],4,3,wf4(:,6),wf4(:,8),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,157),heltab2x128(:,:,157))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(93),n2h64(141))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(689)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(158),h0tab(:,158),[64,10,5,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,6),wf4(:,8) &
    ,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,158),heltab2x128(:,:,158))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(94),n2h64(142))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(689)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(159),h0tab(:,159),[64,10,5,48],[0,0,0,0],4,3,wf4(:,6),wf4(:,8),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,159),heltab2x128(:,:,159))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(95),n2h64(143))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(689)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(160),h0tab(:,160),[64,10,5,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,6),wf4(:,8) &
    ,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,160),heltab2x128(:,:,160))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(96),n2h64(144))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(698)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(161),h0tab(:,161),[80,10,5,32],[0,0,0,0],4,3,wf4(:,4),wf4(:,2),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,1),heltab2x128(:,:,161))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(1),n2h32(33))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(699)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(162),h0tab(:,162),[80,10,5,32],[0,0,0,0],4,3,wf4(:,4),wf4(:,6),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,2),heltab2x128(:,:,162))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(2),n2h32(34))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(700)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(163),h0tab(:,163),[80,10,5,32],[0,0,0,0],4,3,wf4(:,4),wf4(:,2),wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,3),heltab2x128(:,:,163))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(4),n2h32(35))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(701)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(164),h0tab(:,164),[80,10,5,32],[0,0,0,0],4,3,wf4(:,4),wf4(:,6),wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,4),heltab2x128(:,:,164))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(5),n2h32(36))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(698)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(165),h0tab(:,165),[80,5,10,32],[0,0,0,0],4,3,wf4(:,4),wf4(:,1),wf4(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,5),heltab2x128(:,:,165))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(6),n2h32(37))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(699)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(166),h0tab(:,166),[80,5,10,32],[0,0,0,0],4,3,wf4(:,4),wf4(:,1),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,6),heltab2x128(:,:,166))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(7),n2h32(38))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(700)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(167),h0tab(:,167),[80,5,10,32],[0,0,0,0],4,3,wf4(:,4),wf4(:,8),wf4(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,7),heltab2x128(:,:,167))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(8),n2h32(39))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(701)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(168),h0tab(:,168),[80,5,10,32],[0,0,0,0],4,3,wf4(:,4),wf4(:,8),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,8),heltab2x128(:,:,168))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(10),n2h32(40))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(710)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(169),h0tab(:,169),[96,10,5,16],[0,0,0,0],4,3,wf4(:,10),wf4(:,2),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,9),heltab2x128(:,:,169))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(11),n2h32(41))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(711)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(170),h0tab(:,170),[96,10,5,16],[0,0,0,0],4,3,wf4(:,10),wf4(:,6),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,10),heltab2x128(:,:,170))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(12),n2h32(42))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(712)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(171),h0tab(:,171),[96,10,5,16],[0,0,0,0],4,3,wf4(:,10),wf4(:,2),wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,11),heltab2x128(:,:,171))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(13),n2h32(43))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(713)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(172),h0tab(:,172),[96,10,5,16],[0,0,0,0],4,3,wf4(:,10),wf4(:,6),wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,12),heltab2x128(:,:,172))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(14),n2h32(44))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(710)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(173),h0tab(:,173),[96,5,10,16],[0,0,0,0],4,3,wf4(:,10),wf4(:,1),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,13),heltab2x128(:,:,173))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(16),n2h32(45))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(711)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(174),h0tab(:,174),[96,5,10,16],[0,0,0,0],4,3,wf4(:,10),wf4(:,1),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,14),heltab2x128(:,:,174))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(17),n2h32(46))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(712)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(175),h0tab(:,175),[96,5,10,16],[0,0,0,0],4,3,wf4(:,10),wf4(:,8),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,15),heltab2x128(:,:,175))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(18),n2h32(47))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(713)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(176),h0tab(:,176),[96,5,10,16],[0,0,0,0],4,3,wf4(:,10),wf4(:,8),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,16),heltab2x128(:,:,176))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(19),n2h32(48))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(539)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(177),h0tab(:,177),[64,21,10,32],[0,0,0,0],4,2,wf8(:,10),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(97),m3h2x64(:,161),heltab2x128(:,:,177))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(542)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(178),h0tab(:,178),[64,21,10,32],[0,0,0,0],4,2,wf8(:,10),wf4(:,6))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(98),m3h2x64(:,162),heltab2x128(:,:,178))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(544)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(179),h0tab(:,179),[64,21,10,32],[0,0,0,0],4,2,wf8(:,12),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(99),m3h2x64(:,163),heltab2x128(:,:,179))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(546)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(180),h0tab(:,180),[64,21,10,32],[0,0,0,0],4,2,wf8(:,12),wf4(:,6))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(100),m3h2x64(:,164),heltab2x128(:,:,180))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(539)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(181),h0tab(:,181),[64,10,21,32],[0,0,0,0],4,2,wf4(:,2),wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,165),heltab2x128(:,:,181))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(101),n2h64(145))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(542)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(182),h0tab(:,182),[64,10,21,32],[0,0,0,0],4,2,wf4(:,6),wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,166),heltab2x128(:,:,182))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(102),n2h64(146))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(544)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(183),h0tab(:,183),[64,10,21,32],[0,0,0,0],4,2,wf4(:,2),wf8(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,167),heltab2x128(:,:,183))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(103),n2h64(147))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(546)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(184),h0tab(:,184),[64,10,21,32],[0,0,0,0],4,2,wf4(:,6),wf8(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,168),heltab2x128(:,:,184))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(104),n2h64(148))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(539)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(185),h0tab(:,185),[64,10,32,21],[0,0,0,0],4,2,wf4(:,2),wf8(:,10))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,169),heltab2x128(:,:,185))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(105),n2h64(149))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(542)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(186),h0tab(:,186),[64,10,32,21],[0,0,0,0],4,2,wf4(:,6),wf8(:,10))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,170),heltab2x128(:,:,186))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(106),n2h64(150))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(544)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(187),h0tab(:,187),[64,10,32,21],[0,0,0,0],4,2,wf4(:,2),wf8(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,171),heltab2x128(:,:,187))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(107),n2h64(151))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(546)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(188),h0tab(:,188),[64,10,32,21],[0,0,0,0],4,2,wf4(:,6),wf8(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,172),heltab2x128(:,:,188))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(108),n2h64(152))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(550)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(189),h0tab(:,189),[64,16,10,37],[0,0,0,0],4,2,wf4(:,2),wf8(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(109),m3h2x64(:,173),heltab2x128(:,:,189))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(553)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(190),h0tab(:,190),[64,16,10,37],[0,0,0,0],4,2,wf4(:,6),wf8(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(110),m3h2x64(:,174),heltab2x128(:,:,190))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(555)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(191),h0tab(:,191),[64,16,10,37],[0,0,0,0],4,2,wf4(:,2),wf8(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(111),m3h2x64(:,175),heltab2x128(:,:,191))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(557)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(192),h0tab(:,192),[64,16,10,37],[0,0,0,0],4,2,wf4(:,6),wf8(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(112),m3h2x64(:,176),heltab2x128(:,:,192))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(550)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(193),h0tab(:,193),[64,10,37,16],[0,0,0,0],4,2,wf4(:,2),wf8(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,177),heltab2x128(:,:,193))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(113),n2h64(153))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(553)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(194),h0tab(:,194),[64,10,37,16],[0,0,0,0],4,2,wf4(:,6),wf8(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,178),heltab2x128(:,:,194))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(114),n2h64(154))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(555)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(195),h0tab(:,195),[64,10,37,16],[0,0,0,0],4,2,wf4(:,2),wf8(:,4))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,179),heltab2x128(:,:,195))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(115),n2h64(155))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(557)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(196),h0tab(:,196),[64,10,37,16],[0,0,0,0],4,2,wf4(:,6),wf8(:,4))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,180),heltab2x128(:,:,196))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(116),n2h64(156))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(550)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(197),h0tab(:,197),[64,10,16,37],[0,0,0,0],4,2,wf4(:,2),wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,181),heltab2x128(:,:,197))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(117),n2h64(157))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(553)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(198),h0tab(:,198),[64,10,16,37],[0,0,0,0],4,2,wf4(:,6),wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,182),heltab2x128(:,:,198))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(118),n2h64(158))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(555)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(199),h0tab(:,199),[64,10,16,37],[0,0,0,0],4,2,wf4(:,2),wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,183),heltab2x128(:,:,199))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(119),n2h64(159))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(557)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(200),h0tab(:,200),[64,10,16,37],[0,0,0,0],4,2,wf4(:,6),wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,184),heltab2x128(:,:,200))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(120),n2h64(160))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(562)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(201),h0tab(:,201),[64,26,5,32],[0,0,0,0],4,2,wf8(:,14),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(121),m3h2x64(:,185),heltab2x128(:,:,201))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(564)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(202),h0tab(:,202),[64,26,5,32],[0,0,0,0],4,2,wf8(:,16),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(122),m3h2x64(:,186),heltab2x128(:,:,202))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(566)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(203),h0tab(:,203),[64,26,5,32],[0,0,0,0],4,2,wf8(:,14),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(123),m3h2x64(:,187),heltab2x128(:,:,203))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(568)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(204),h0tab(:,204),[64,26,5,32],[0,0,0,0],4,2,wf8(:,16),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(124),m3h2x64(:,188),heltab2x128(:,:,204))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(562)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(205),h0tab(:,205),[64,5,26,32],[0,0,0,0],4,2,wf4(:,1),wf8(:,14))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,189),heltab2x128(:,:,205))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(125),n2h64(161))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(564)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(206),h0tab(:,206),[64,5,26,32],[0,0,0,0],4,2,wf4(:,1),wf8(:,16))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,190),heltab2x128(:,:,206))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(126),n2h64(162))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(566)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(207),h0tab(:,207),[64,5,26,32],[0,0,0,0],4,2,wf4(:,8),wf8(:,14))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,191),heltab2x128(:,:,207))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(127),n2h64(163))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(568)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(208),h0tab(:,208),[64,5,26,32],[0,0,0,0],4,2,wf4(:,8),wf8(:,16))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,192),heltab2x128(:,:,208))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(128),n2h64(164))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(562)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(209),h0tab(:,209),[64,5,32,26],[0,0,0,0],4,2,wf4(:,1),wf8(:,14))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,193),heltab2x128(:,:,209))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(129),n2h64(165))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(564)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(210),h0tab(:,210),[64,5,32,26],[0,0,0,0],4,2,wf4(:,1),wf8(:,16))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,194),heltab2x128(:,:,210))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(130),n2h64(166))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(566)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(211),h0tab(:,211),[64,5,32,26],[0,0,0,0],4,2,wf4(:,8),wf8(:,14))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,195),heltab2x128(:,:,211))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(131),n2h64(167))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(568)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(212),h0tab(:,212),[64,5,32,26],[0,0,0,0],4,2,wf4(:,8),wf8(:,16))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,196),heltab2x128(:,:,212))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(132),n2h64(168))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(572)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(213),h0tab(:,213),[64,16,5,42],[0,0,0,0],4,2,wf4(:,1),wf8(:,6))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(133),m3h2x64(:,197),heltab2x128(:,:,213))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(574)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(214),h0tab(:,214),[64,16,5,42],[0,0,0,0],4,2,wf4(:,1),wf8(:,8))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(134),m3h2x64(:,198),heltab2x128(:,:,214))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(576)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(215),h0tab(:,215),[64,16,5,42],[0,0,0,0],4,2,wf4(:,8),wf8(:,6))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(135),m3h2x64(:,199),heltab2x128(:,:,215))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(578)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(216),h0tab(:,216),[64,16,5,42],[0,0,0,0],4,2,wf4(:,8),wf8(:,8))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(136),m3h2x64(:,200),heltab2x128(:,:,216))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(572)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(217),h0tab(:,217),[64,5,42,16],[0,0,0,0],4,2,wf4(:,1),wf8(:,6))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,201),heltab2x128(:,:,217))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(137),n2h64(169))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(574)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(218),h0tab(:,218),[64,5,42,16],[0,0,0,0],4,2,wf4(:,1),wf8(:,8))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,202),heltab2x128(:,:,218))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(138),n2h64(170))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(576)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(219),h0tab(:,219),[64,5,42,16],[0,0,0,0],4,2,wf4(:,8),wf8(:,6))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,203),heltab2x128(:,:,219))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(139),n2h64(171))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(578)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(220),h0tab(:,220),[64,5,42,16],[0,0,0,0],4,2,wf4(:,8),wf8(:,8))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,204),heltab2x128(:,:,220))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(140),n2h64(172))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(572)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(221),h0tab(:,221),[64,5,16,42],[0,0,0,0],4,2,wf4(:,1),wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,205),heltab2x128(:,:,221))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(141),n2h64(173))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(574)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(222),h0tab(:,222),[64,5,16,42],[0,0,0,0],4,2,wf4(:,1),wf8(:,8))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,206),heltab2x128(:,:,222))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(142),n2h64(174))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(576)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(223),h0tab(:,223),[64,5,16,42],[0,0,0,0],4,2,wf4(:,8),wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,207),heltab2x128(:,:,223))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(143),n2h64(175))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(578)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(224),h0tab(:,224),[64,5,16,42],[0,0,0,0],4,2,wf4(:,8),wf8(:,8))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,208),heltab2x128(:,:,224))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(144),n2h64(176))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(375)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(225),h0tab(:,225),[64,15,32,16],[0,0,0,0],4,1,wf16(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,209),heltab2x128(:,:,225))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(145),n2h64(177))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(378)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(226),h0tab(:,226),[64,15,32,16],[0,0,0,0],4,1,wf16(:,159))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,210),heltab2x128(:,:,226))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(146),n2h64(178))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(380)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(227),h0tab(:,227),[64,15,32,16],[0,0,0,0],4,1,wf16(:,15))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,211),heltab2x128(:,:,227))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(147),n2h64(179))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(382)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(228),h0tab(:,228),[64,15,32,16],[0,0,0,0],4,1,wf16(:,160))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,212),heltab2x128(:,:,228))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(148),n2h64(180))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(375)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(229),h0tab(:,229),[64,15,16,32],[0,0,0,0],4,1,wf16(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,213),heltab2x128(:,:,229))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(149),n2h64(181))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(378)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(230),h0tab(:,230),[64,15,16,32],[0,0,0,0],4,1,wf16(:,159))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,214),heltab2x128(:,:,230))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(150),n2h64(182))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(380)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(231),h0tab(:,231),[64,15,16,32],[0,0,0,0],4,1,wf16(:,15))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,215),heltab2x128(:,:,231))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(151),n2h64(183))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(382)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(232),h0tab(:,232),[64,15,16,32],[0,0,0,0],4,1,wf16(:,160))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,216),heltab2x128(:,:,232))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(152),n2h64(184))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(375)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(233),h0tab(:,233),[64,16,15,32],[0,0,0,0],4,1,wf16(:,13))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(153),m3h2x64(:,217),heltab2x128(:,:,233))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(378)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(234),h0tab(:,234),[64,16,15,32],[0,0,0,0],4,1,wf16(:,159))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(154),m3h2x64(:,218),heltab2x128(:,:,234))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(380)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(235),h0tab(:,235),[64,16,15,32],[0,0,0,0],4,1,wf16(:,15))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(155),m3h2x64(:,219),heltab2x128(:,:,235))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(382)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(236),h0tab(:,236),[64,16,15,32],[0,0,0,0],4,1,wf16(:,160))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(156),m3h2x64(:,220),heltab2x128(:,:,236))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(384)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(237),h0tab(:,237),[64,15,32,16],[0,0,0,0],4,1,wf16(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,221),heltab2x128(:,:,237))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(157),n2h64(185))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(386)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(238),h0tab(:,238),[64,15,32,16],[0,0,0,0],4,1,wf16(:,161))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,222),heltab2x128(:,:,238))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(158),n2h64(186))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(388)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(239),h0tab(:,239),[64,15,32,16],[0,0,0,0],4,1,wf16(:,19))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,223),heltab2x128(:,:,239))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(159),n2h64(187))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(390)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(240),h0tab(:,240),[64,15,32,16],[0,0,0,0],4,1,wf16(:,162))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,224),heltab2x128(:,:,240))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(160),n2h64(188))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(384)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(241),h0tab(:,241),[64,15,16,32],[0,0,0,0],4,1,wf16(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,225),heltab2x128(:,:,241))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(161),n2h64(189))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(386)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(242),h0tab(:,242),[64,15,16,32],[0,0,0,0],4,1,wf16(:,161))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,226),heltab2x128(:,:,242))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(162),n2h64(190))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(388)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(243),h0tab(:,243),[64,15,16,32],[0,0,0,0],4,1,wf16(:,19))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,227),heltab2x128(:,:,243))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(163),n2h64(191))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(390)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(244),h0tab(:,244),[64,15,16,32],[0,0,0,0],4,1,wf16(:,162))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,228),heltab2x128(:,:,244))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(164),n2h64(192))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(384)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(245),h0tab(:,245),[64,16,15,32],[0,0,0,0],4,1,wf16(:,17))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(165),m3h2x64(:,229),heltab2x128(:,:,245))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(386)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(246),h0tab(:,246),[64,16,15,32],[0,0,0,0],4,1,wf16(:,161))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(166),m3h2x64(:,230),heltab2x128(:,:,246))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(388)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(247),h0tab(:,247),[64,16,15,32],[0,0,0,0],4,1,wf16(:,19))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(167),m3h2x64(:,231),heltab2x128(:,:,247))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(390)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(248),h0tab(:,248),[64,16,15,32],[0,0,0,0],4,1,wf16(:,162))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(168),m3h2x64(:,232),heltab2x128(:,:,248))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(770)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(249),h0tab(:,249),[64,6,48,9],[0,0,0,0],4,3,wf4(:,12),wf4(:,17),wf4(: &
    ,11))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,233),heltab2x128(:,:,249))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(169),n2h64(193))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(770)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(250),h0tab(:,250),[64,6,48,9],[nMT,nMT,nMT,nMT],4,3,wf4(:,12),wf4(:,17) &
    ,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,234),heltab2x128(:,:,250))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(170),n2h64(194))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(770)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(251),h0tab(:,251),[64,6,48,9],[0,0,0,0],4,3,wf4(:,12),wf4(:,17),wf4(: &
    ,11))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,235),heltab2x128(:,:,251))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(171),n2h64(195))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(770)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(252),h0tab(:,252),[64,6,48,9],[nMT,nMT,nMT,nMT],4,3,wf4(:,12),wf4(:,17) &
    ,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,236),heltab2x128(:,:,252))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(172),n2h64(196))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(770)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(253),h0tab(:,253),[64,6,48,9],[0,0,0,0],4,3,wf4(:,12),wf4(:,17),wf4(: &
    ,11))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,237),heltab2x128(:,:,253))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(173),n2h64(197))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(770)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(254),h0tab(:,254),[64,6,48,9],[nMB,nMB,nMB,nMB],4,3,wf4(:,12),wf4(:,17) &
    ,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,238),heltab2x128(:,:,254))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(174),n2h64(198))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(770)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(255),h0tab(:,255),[64,6,48,9],[0,0,0,0],4,3,wf4(:,12),wf4(:,17),wf4(: &
    ,11))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,239),heltab2x128(:,:,255))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(175),n2h64(199))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(770)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(256),h0tab(:,256),[64,6,48,9],[nMB,nMB,nMB,nMB],4,3,wf4(:,12),wf4(:,17) &
    ,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,240),heltab2x128(:,:,256))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(176),n2h64(200))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(771)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(257),h0tab(:,257),[64,6,48,9],[0,0,0,0],4,3,wf4(:,14),wf4(:,17),wf4(: &
    ,11))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,241),heltab2x128(:,:,257))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(177),n2h64(201))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(771)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(258),h0tab(:,258),[64,6,48,9],[nMT,nMT,nMT,nMT],4,3,wf4(:,14),wf4(:,17) &
    ,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,242),heltab2x128(:,:,258))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(178),n2h64(202))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(771)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(259),h0tab(:,259),[64,6,48,9],[0,0,0,0],4,3,wf4(:,14),wf4(:,17),wf4(: &
    ,11))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,243),heltab2x128(:,:,259))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(179),n2h64(203))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(771)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(260),h0tab(:,260),[64,6,48,9],[nMT,nMT,nMT,nMT],4,3,wf4(:,14),wf4(:,17) &
    ,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,244),heltab2x128(:,:,260))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(180),n2h64(204))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(771)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(261),h0tab(:,261),[64,6,48,9],[0,0,0,0],4,3,wf4(:,14),wf4(:,17),wf4(: &
    ,11))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,245),heltab2x128(:,:,261))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(181),n2h64(205))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(771)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(262),h0tab(:,262),[64,6,48,9],[nMB,nMB,nMB,nMB],4,3,wf4(:,14),wf4(:,17) &
    ,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,246),heltab2x128(:,:,262))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(182),n2h64(206))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(771)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(263),h0tab(:,263),[64,6,48,9],[0,0,0,0],4,3,wf4(:,14),wf4(:,17),wf4(: &
    ,11))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,247),heltab2x128(:,:,263))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(183),n2h64(207))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(771)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(264),h0tab(:,264),[64,6,48,9],[nMB,nMB,nMB,nMB],4,3,wf4(:,14),wf4(:,17) &
    ,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,248),heltab2x128(:,:,264))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(184),n2h64(208))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(772)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(265),h0tab(:,265),[64,6,48,9],[0,0,0,0],4,3,wf4(:,12),wf4(:,17),wf4(: &
    ,16))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,249),heltab2x128(:,:,265))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(185),n2h64(209))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(772)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(266),h0tab(:,266),[64,6,48,9],[nMT,nMT,nMT,nMT],4,3,wf4(:,12),wf4(:,17) &
    ,wf4(:,16))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,250),heltab2x128(:,:,266))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(186),n2h64(210))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(772)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(267),h0tab(:,267),[64,6,48,9],[0,0,0,0],4,3,wf4(:,12),wf4(:,17),wf4(: &
    ,16))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,251),heltab2x128(:,:,267))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(187),n2h64(211))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(772)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(268),h0tab(:,268),[64,6,48,9],[nMT,nMT,nMT,nMT],4,3,wf4(:,12),wf4(:,17) &
    ,wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,252),heltab2x128(:,:,268))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(188),n2h64(212))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(772)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(269),h0tab(:,269),[64,6,48,9],[0,0,0,0],4,3,wf4(:,12),wf4(:,17),wf4(: &
    ,16))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,253),heltab2x128(:,:,269))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(189),n2h64(213))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(772)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(270),h0tab(:,270),[64,6,48,9],[nMB,nMB,nMB,nMB],4,3,wf4(:,12),wf4(:,17) &
    ,wf4(:,16))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,254),heltab2x128(:,:,270))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(190),n2h64(214))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(772)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(271),h0tab(:,271),[64,6,48,9],[0,0,0,0],4,3,wf4(:,12),wf4(:,17),wf4(: &
    ,16))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,255),heltab2x128(:,:,271))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(191),n2h64(215))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(772)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(272),h0tab(:,272),[64,6,48,9],[nMB,nMB,nMB,nMB],4,3,wf4(:,12),wf4(:,17) &
    ,wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,256),heltab2x128(:,:,272))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(192),n2h64(216))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(773)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(273),h0tab(:,273),[64,6,48,9],[0,0,0,0],4,3,wf4(:,14),wf4(:,17),wf4(: &
    ,16))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,257),heltab2x128(:,:,273))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(193),n2h64(217))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(773)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(274),h0tab(:,274),[64,6,48,9],[nMT,nMT,nMT,nMT],4,3,wf4(:,14),wf4(:,17) &
    ,wf4(:,16))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,258),heltab2x128(:,:,274))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(194),n2h64(218))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(773)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(275),h0tab(:,275),[64,6,48,9],[0,0,0,0],4,3,wf4(:,14),wf4(:,17),wf4(: &
    ,16))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,259),heltab2x128(:,:,275))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(195),n2h64(219))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(773)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(276),h0tab(:,276),[64,6,48,9],[nMT,nMT,nMT,nMT],4,3,wf4(:,14),wf4(:,17) &
    ,wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,260),heltab2x128(:,:,276))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(196),n2h64(220))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(773)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(277),h0tab(:,277),[64,6,48,9],[0,0,0,0],4,3,wf4(:,14),wf4(:,17),wf4(: &
    ,16))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,261),heltab2x128(:,:,277))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(197),n2h64(221))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(773)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(278),h0tab(:,278),[64,6,48,9],[nMB,nMB,nMB,nMB],4,3,wf4(:,14),wf4(:,17) &
    ,wf4(:,16))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,262),heltab2x128(:,:,278))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(198),n2h64(222))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(773)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(279),h0tab(:,279),[64,6,48,9],[0,0,0,0],4,3,wf4(:,14),wf4(:,17),wf4(: &
    ,16))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,263),heltab2x128(:,:,279))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(199),n2h64(223))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(773)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(280),h0tab(:,280),[64,6,48,9],[nMB,nMB,nMB,nMB],4,3,wf4(:,14),wf4(:,17) &
    ,wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,264),heltab2x128(:,:,280))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(200),n2h64(224))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(770)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(281),h0tab(:,281),[64,9,6,48],[0,0,0,0],4,3,wf4(:,11),wf4(:,12),wf4(: &
    ,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,265),heltab2x128(:,:,281))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(201),n2h64(225))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(770)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(282),h0tab(:,282),[64,9,6,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,11),wf4(:,12) &
    ,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,266),heltab2x128(:,:,282))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(202),n2h64(226))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(770)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(283),h0tab(:,283),[64,9,6,48],[0,0,0,0],4,3,wf4(:,11),wf4(:,12),wf4(: &
    ,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,267),heltab2x128(:,:,283))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(203),n2h64(227))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(770)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(284),h0tab(:,284),[64,9,6,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,11),wf4(:,12) &
    ,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,268),heltab2x128(:,:,284))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(204),n2h64(228))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(770)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(285),h0tab(:,285),[64,9,6,48],[0,0,0,0],4,3,wf4(:,11),wf4(:,12),wf4(: &
    ,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,269),heltab2x128(:,:,285))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(205),n2h64(229))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(770)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(286),h0tab(:,286),[64,9,6,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,11),wf4(:,12) &
    ,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,270),heltab2x128(:,:,286))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(206),n2h64(230))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(770)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(287),h0tab(:,287),[64,9,6,48],[0,0,0,0],4,3,wf4(:,11),wf4(:,12),wf4(: &
    ,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,271),heltab2x128(:,:,287))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(207),n2h64(231))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(770)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(288),h0tab(:,288),[64,9,6,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,11),wf4(:,12) &
    ,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,272),heltab2x128(:,:,288))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(208),n2h64(232))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(771)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(289),h0tab(:,289),[64,9,6,48],[0,0,0,0],4,3,wf4(:,11),wf4(:,14),wf4(: &
    ,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,273),heltab2x128(:,:,289))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(209),n2h64(233))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(771)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(290),h0tab(:,290),[64,9,6,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,11),wf4(:,14) &
    ,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,274),heltab2x128(:,:,290))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(210),n2h64(234))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(771)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(291),h0tab(:,291),[64,9,6,48],[0,0,0,0],4,3,wf4(:,11),wf4(:,14),wf4(: &
    ,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,275),heltab2x128(:,:,291))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(211),n2h64(235))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(771)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(292),h0tab(:,292),[64,9,6,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,11),wf4(:,14) &
    ,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,276),heltab2x128(:,:,292))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(212),n2h64(236))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(771)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(293),h0tab(:,293),[64,9,6,48],[0,0,0,0],4,3,wf4(:,11),wf4(:,14),wf4(: &
    ,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,277),heltab2x128(:,:,293))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(213),n2h64(237))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(771)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(294),h0tab(:,294),[64,9,6,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,11),wf4(:,14) &
    ,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,278),heltab2x128(:,:,294))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(214),n2h64(238))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(771)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(295),h0tab(:,295),[64,9,6,48],[0,0,0,0],4,3,wf4(:,11),wf4(:,14),wf4(: &
    ,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,279),heltab2x128(:,:,295))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(215),n2h64(239))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(771)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(296),h0tab(:,296),[64,9,6,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,11),wf4(:,14) &
    ,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,280),heltab2x128(:,:,296))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(216),n2h64(240))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(772)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(297),h0tab(:,297),[64,9,6,48],[0,0,0,0],4,3,wf4(:,16),wf4(:,12),wf4(: &
    ,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,281),heltab2x128(:,:,297))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(217),n2h64(241))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(772)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(298),h0tab(:,298),[64,9,6,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,16),wf4(:,12) &
    ,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,282),heltab2x128(:,:,298))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(218),n2h64(242))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(772)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(299),h0tab(:,299),[64,9,6,48],[0,0,0,0],4,3,wf4(:,16),wf4(:,12),wf4(: &
    ,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,283),heltab2x128(:,:,299))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(219),n2h64(243))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(772)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(300),h0tab(:,300),[64,9,6,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,16),wf4(:,12) &
    ,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,284),heltab2x128(:,:,300))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(220),n2h64(244))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(772)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(301),h0tab(:,301),[64,9,6,48],[0,0,0,0],4,3,wf4(:,16),wf4(:,12),wf4(: &
    ,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,285),heltab2x128(:,:,301))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(221),n2h64(245))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(772)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(302),h0tab(:,302),[64,9,6,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,16),wf4(:,12) &
    ,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,286),heltab2x128(:,:,302))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(222),n2h64(246))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(772)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(303),h0tab(:,303),[64,9,6,48],[0,0,0,0],4,3,wf4(:,16),wf4(:,12),wf4(: &
    ,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,287),heltab2x128(:,:,303))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(223),n2h64(247))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(772)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(304),h0tab(:,304),[64,9,6,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,16),wf4(:,12) &
    ,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,288),heltab2x128(:,:,304))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(224),n2h64(248))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(773)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(305),h0tab(:,305),[64,9,6,48],[0,0,0,0],4,3,wf4(:,16),wf4(:,14),wf4(: &
    ,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,289),heltab2x128(:,:,305))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(225),n2h64(249))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(773)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(306),h0tab(:,306),[64,9,6,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,16),wf4(:,14) &
    ,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,290),heltab2x128(:,:,306))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(226),n2h64(250))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(773)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(307),h0tab(:,307),[64,9,6,48],[0,0,0,0],4,3,wf4(:,16),wf4(:,14),wf4(: &
    ,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,291),heltab2x128(:,:,307))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(227),n2h64(251))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(773)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(308),h0tab(:,308),[64,9,6,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,16),wf4(:,14) &
    ,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,292),heltab2x128(:,:,308))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(228),n2h64(252))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(773)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(309),h0tab(:,309),[64,9,6,48],[0,0,0,0],4,3,wf4(:,16),wf4(:,14),wf4(: &
    ,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,293),heltab2x128(:,:,309))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(229),n2h64(253))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(773)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(310),h0tab(:,310),[64,9,6,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,16),wf4(:,14) &
    ,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,294),heltab2x128(:,:,310))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(230),n2h64(254))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(773)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(311),h0tab(:,311),[64,9,6,48],[0,0,0,0],4,3,wf4(:,16),wf4(:,14),wf4(: &
    ,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,295),heltab2x128(:,:,311))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(231),n2h64(255))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(773)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(312),h0tab(:,312),[64,9,6,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,16),wf4(:,14) &
    ,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,296),heltab2x128(:,:,312))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(232),n2h64(256))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(770)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(313),h0tab(:,313),[64,6,9,48],[0,0,0,0],4,3,wf4(:,12),wf4(:,11),wf4(: &
    ,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,297),heltab2x128(:,:,313))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(233),n2h64(257))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(770)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(314),h0tab(:,314),[64,6,9,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,12),wf4(:,11) &
    ,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,298),heltab2x128(:,:,314))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(234),n2h64(258))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(770)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(315),h0tab(:,315),[64,6,9,48],[0,0,0,0],4,3,wf4(:,12),wf4(:,11),wf4(: &
    ,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,299),heltab2x128(:,:,315))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(235),n2h64(259))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(770)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(316),h0tab(:,316),[64,6,9,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,12),wf4(:,11) &
    ,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,300),heltab2x128(:,:,316))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(236),n2h64(260))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(770)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(317),h0tab(:,317),[64,6,9,48],[0,0,0,0],4,3,wf4(:,12),wf4(:,11),wf4(: &
    ,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,301),heltab2x128(:,:,317))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(237),n2h64(261))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(770)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(318),h0tab(:,318),[64,6,9,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,12),wf4(:,11) &
    ,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,302),heltab2x128(:,:,318))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(238),n2h64(262))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(770)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(319),h0tab(:,319),[64,6,9,48],[0,0,0,0],4,3,wf4(:,12),wf4(:,11),wf4(: &
    ,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,303),heltab2x128(:,:,319))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(239),n2h64(263))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(770)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(320),h0tab(:,320),[64,6,9,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,12),wf4(:,11) &
    ,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,304),heltab2x128(:,:,320))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(240),n2h64(264))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(771)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(321),h0tab(:,321),[64,6,9,48],[0,0,0,0],4,3,wf4(:,14),wf4(:,11),wf4(: &
    ,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,305),heltab2x128(:,:,321))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(241),n2h64(265))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(771)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(322),h0tab(:,322),[64,6,9,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,14),wf4(:,11) &
    ,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,306),heltab2x128(:,:,322))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(242),n2h64(266))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(771)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(323),h0tab(:,323),[64,6,9,48],[0,0,0,0],4,3,wf4(:,14),wf4(:,11),wf4(: &
    ,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,307),heltab2x128(:,:,323))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(243),n2h64(267))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(771)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(324),h0tab(:,324),[64,6,9,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,14),wf4(:,11) &
    ,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,308),heltab2x128(:,:,324))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(244),n2h64(268))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(771)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(325),h0tab(:,325),[64,6,9,48],[0,0,0,0],4,3,wf4(:,14),wf4(:,11),wf4(: &
    ,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,309),heltab2x128(:,:,325))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(245),n2h64(269))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(771)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(326),h0tab(:,326),[64,6,9,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,14),wf4(:,11) &
    ,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,310),heltab2x128(:,:,326))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(246),n2h64(270))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(771)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(327),h0tab(:,327),[64,6,9,48],[0,0,0,0],4,3,wf4(:,14),wf4(:,11),wf4(: &
    ,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,311),heltab2x128(:,:,327))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(247),n2h64(271))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(771)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(328),h0tab(:,328),[64,6,9,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,14),wf4(:,11) &
    ,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,312),heltab2x128(:,:,328))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(248),n2h64(272))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(772)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(329),h0tab(:,329),[64,6,9,48],[0,0,0,0],4,3,wf4(:,12),wf4(:,16),wf4(: &
    ,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,313),heltab2x128(:,:,329))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(249),n2h64(273))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(772)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(330),h0tab(:,330),[64,6,9,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,12),wf4(:,16) &
    ,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,314),heltab2x128(:,:,330))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(250),n2h64(274))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(772)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(331),h0tab(:,331),[64,6,9,48],[0,0,0,0],4,3,wf4(:,12),wf4(:,16),wf4(: &
    ,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,315),heltab2x128(:,:,331))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(251),n2h64(275))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(772)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(332),h0tab(:,332),[64,6,9,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,12),wf4(:,16) &
    ,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,316),heltab2x128(:,:,332))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(252),n2h64(276))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(772)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(333),h0tab(:,333),[64,6,9,48],[0,0,0,0],4,3,wf4(:,12),wf4(:,16),wf4(: &
    ,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,317),heltab2x128(:,:,333))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(253),n2h64(277))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(772)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(334),h0tab(:,334),[64,6,9,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,12),wf4(:,16) &
    ,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,318),heltab2x128(:,:,334))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(254),n2h64(278))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(772)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(335),h0tab(:,335),[64,6,9,48],[0,0,0,0],4,3,wf4(:,12),wf4(:,16),wf4(: &
    ,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,319),heltab2x128(:,:,335))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(255),n2h64(279))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(772)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(336),h0tab(:,336),[64,6,9,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,12),wf4(:,16) &
    ,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,320),heltab2x128(:,:,336))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(256),n2h64(280))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(773)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(337),h0tab(:,337),[64,6,9,48],[0,0,0,0],4,3,wf4(:,14),wf4(:,16),wf4(: &
    ,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,321),heltab2x128(:,:,337))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(257),n2h64(281))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(773)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(338),h0tab(:,338),[64,6,9,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,14),wf4(:,16) &
    ,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,322),heltab2x128(:,:,338))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(258),n2h64(282))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(773)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(339),h0tab(:,339),[64,6,9,48],[0,0,0,0],4,3,wf4(:,14),wf4(:,16),wf4(: &
    ,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,323),heltab2x128(:,:,339))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(259),n2h64(283))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(773)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(340),h0tab(:,340),[64,6,9,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,14),wf4(:,16) &
    ,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,324),heltab2x128(:,:,340))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(260),n2h64(284))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(773)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(341),h0tab(:,341),[64,6,9,48],[0,0,0,0],4,3,wf4(:,14),wf4(:,16),wf4(: &
    ,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,325),heltab2x128(:,:,341))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(261),n2h64(285))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(773)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(342),h0tab(:,342),[64,6,9,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,14),wf4(:,16) &
    ,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,326),heltab2x128(:,:,342))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(262),n2h64(286))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(773)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(343),h0tab(:,343),[64,6,9,48],[0,0,0,0],4,3,wf4(:,14),wf4(:,16),wf4(: &
    ,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,327),heltab2x128(:,:,343))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(263),n2h64(287))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(773)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(344),h0tab(:,344),[64,6,9,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,14),wf4(:,16) &
    ,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,328),heltab2x128(:,:,344))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(264),n2h64(288))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(782)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(345),h0tab(:,345),[80,6,9,32],[0,0,0,0],4,3,wf4(:,4),wf4(:,12),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,17),heltab2x128(:,:,345))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(20),n2h32(49))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(783)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(346),h0tab(:,346),[80,6,9,32],[0,0,0,0],4,3,wf4(:,4),wf4(:,14),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,18),heltab2x128(:,:,346))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(22),n2h32(50))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(784)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(347),h0tab(:,347),[80,6,9,32],[0,0,0,0],4,3,wf4(:,4),wf4(:,12),wf4(:,16))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,19),heltab2x128(:,:,347))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(23),n2h32(51))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(785)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(348),h0tab(:,348),[80,6,9,32],[0,0,0,0],4,3,wf4(:,4),wf4(:,14),wf4(:,16))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,20),heltab2x128(:,:,348))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(24),n2h32(52))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(782)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(349),h0tab(:,349),[80,9,6,32],[0,0,0,0],4,3,wf4(:,4),wf4(:,11),wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,21),heltab2x128(:,:,349))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(25),n2h32(53))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(783)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(350),h0tab(:,350),[80,9,6,32],[0,0,0,0],4,3,wf4(:,4),wf4(:,11),wf4(:,14))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,22),heltab2x128(:,:,350))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(26),n2h32(54))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(784)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(351),h0tab(:,351),[80,9,6,32],[0,0,0,0],4,3,wf4(:,4),wf4(:,16),wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,23),heltab2x128(:,:,351))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(28),n2h32(55))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(785)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(352),h0tab(:,352),[80,9,6,32],[0,0,0,0],4,3,wf4(:,4),wf4(:,16),wf4(:,14))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,24),heltab2x128(:,:,352))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(29),n2h32(56))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(794)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(353),h0tab(:,353),[96,6,9,16],[0,0,0,0],4,3,wf4(:,10),wf4(:,12),wf4(: &
    ,11))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,25),heltab2x128(:,:,353))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(30),n2h32(57))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(795)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(354),h0tab(:,354),[96,6,9,16],[0,0,0,0],4,3,wf4(:,10),wf4(:,14),wf4(: &
    ,11))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,26),heltab2x128(:,:,354))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(31),n2h32(58))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(796)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(355),h0tab(:,355),[96,6,9,16],[0,0,0,0],4,3,wf4(:,10),wf4(:,12),wf4(: &
    ,16))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,27),heltab2x128(:,:,355))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(32),n2h32(59))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(797)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(356),h0tab(:,356),[96,6,9,16],[0,0,0,0],4,3,wf4(:,10),wf4(:,14),wf4(: &
    ,16))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,28),heltab2x128(:,:,356))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(34),n2h32(60))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(794)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(357),h0tab(:,357),[96,9,6,16],[0,0,0,0],4,3,wf4(:,10),wf4(:,11),wf4(: &
    ,12))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,29),heltab2x128(:,:,357))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(35),n2h32(61))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(795)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(358),h0tab(:,358),[96,9,6,16],[0,0,0,0],4,3,wf4(:,10),wf4(:,11),wf4(: &
    ,14))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,30),heltab2x128(:,:,358))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(36),n2h32(62))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(796)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(359),h0tab(:,359),[96,9,6,16],[0,0,0,0],4,3,wf4(:,10),wf4(:,16),wf4(: &
    ,12))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,31),heltab2x128(:,:,359))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(37),n2h32(63))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(797)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(360),h0tab(:,360),[96,9,6,16],[0,0,0,0],4,3,wf4(:,10),wf4(:,16),wf4(: &
    ,14))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,32),heltab2x128(:,:,360))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(38),n2h32(64))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(599)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(361),h0tab(:,361),[64,25,6,32],[0,0,0,0],4,2,wf8(:,40),wf4(:,12))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(265),m3h2x64(:,329),heltab2x128(:,:,361))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(601)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(362),h0tab(:,362),[64,25,6,32],[0,0,0,0],4,2,wf8(:,40),wf4(:,14))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(266),m3h2x64(:,330),heltab2x128(:,:,362))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(603)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(363),h0tab(:,363),[64,25,6,32],[0,0,0,0],4,2,wf8(:,42),wf4(:,12))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(267),m3h2x64(:,331),heltab2x128(:,:,363))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(605)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(364),h0tab(:,364),[64,25,6,32],[0,0,0,0],4,2,wf8(:,42),wf4(:,14))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(268),m3h2x64(:,332),heltab2x128(:,:,364))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(599)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(365),h0tab(:,365),[64,6,25,32],[0,0,0,0],4,2,wf4(:,12),wf8(:,40))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,333),heltab2x128(:,:,365))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(269),n2h64(289))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(601)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(366),h0tab(:,366),[64,6,25,32],[0,0,0,0],4,2,wf4(:,14),wf8(:,40))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,334),heltab2x128(:,:,366))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(270),n2h64(290))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(603)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(367),h0tab(:,367),[64,6,25,32],[0,0,0,0],4,2,wf4(:,12),wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,335),heltab2x128(:,:,367))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(271),n2h64(291))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(605)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(368),h0tab(:,368),[64,6,25,32],[0,0,0,0],4,2,wf4(:,14),wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,336),heltab2x128(:,:,368))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(272),n2h64(292))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(599)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(369),h0tab(:,369),[64,6,32,25],[0,0,0,0],4,2,wf4(:,12),wf8(:,40))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,337),heltab2x128(:,:,369))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(273),n2h64(293))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(601)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(370),h0tab(:,370),[64,6,32,25],[0,0,0,0],4,2,wf4(:,14),wf8(:,40))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,338),heltab2x128(:,:,370))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(274),n2h64(294))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(603)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(371),h0tab(:,371),[64,6,32,25],[0,0,0,0],4,2,wf4(:,12),wf8(:,42))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,339),heltab2x128(:,:,371))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(275),n2h64(295))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(605)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(372),h0tab(:,372),[64,6,32,25],[0,0,0,0],4,2,wf4(:,14),wf8(:,42))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,340),heltab2x128(:,:,372))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(276),n2h64(296))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(609)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(373),h0tab(:,373),[64,16,6,41],[0,0,0,0],4,2,wf4(:,12),wf8(:,32))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(277),m3h2x64(:,341),heltab2x128(:,:,373))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(611)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(374),h0tab(:,374),[64,16,6,41],[0,0,0,0],4,2,wf4(:,14),wf8(:,32))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(278),m3h2x64(:,342),heltab2x128(:,:,374))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(613)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(375),h0tab(:,375),[64,16,6,41],[0,0,0,0],4,2,wf4(:,12),wf8(:,34))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(279),m3h2x64(:,343),heltab2x128(:,:,375))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(615)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(376),h0tab(:,376),[64,16,6,41],[0,0,0,0],4,2,wf4(:,14),wf8(:,34))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(280),m3h2x64(:,344),heltab2x128(:,:,376))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(609)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(377),h0tab(:,377),[64,6,41,16],[0,0,0,0],4,2,wf4(:,12),wf8(:,32))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,345),heltab2x128(:,:,377))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(281),n2h64(297))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(611)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(378),h0tab(:,378),[64,6,41,16],[0,0,0,0],4,2,wf4(:,14),wf8(:,32))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,346),heltab2x128(:,:,378))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(282),n2h64(298))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(613)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(379),h0tab(:,379),[64,6,41,16],[0,0,0,0],4,2,wf4(:,12),wf8(:,34))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,347),heltab2x128(:,:,379))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(283),n2h64(299))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(615)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(380),h0tab(:,380),[64,6,41,16],[0,0,0,0],4,2,wf4(:,14),wf8(:,34))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,348),heltab2x128(:,:,380))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(284),n2h64(300))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(609)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(381),h0tab(:,381),[64,6,16,41],[0,0,0,0],4,2,wf4(:,12),wf8(:,32))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,349),heltab2x128(:,:,381))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(285),n2h64(301))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(611)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(382),h0tab(:,382),[64,6,16,41],[0,0,0,0],4,2,wf4(:,14),wf8(:,32))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,350),heltab2x128(:,:,382))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(286),n2h64(302))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(613)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(383),h0tab(:,383),[64,6,16,41],[0,0,0,0],4,2,wf4(:,12),wf8(:,34))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,351),heltab2x128(:,:,383))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(287),n2h64(303))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(615)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(384),h0tab(:,384),[64,6,16,41],[0,0,0,0],4,2,wf4(:,14),wf8(:,34))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,352),heltab2x128(:,:,384))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(288),n2h64(304))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(620)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(385),h0tab(:,385),[64,22,9,32],[0,0,0,0],4,2,wf8(:,44),wf4(:,11))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(289),m3h2x64(:,353),heltab2x128(:,:,385))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(622)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(386),h0tab(:,386),[64,22,9,32],[0,0,0,0],4,2,wf8(:,46),wf4(:,11))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(290),m3h2x64(:,354),heltab2x128(:,:,386))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(624)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(387),h0tab(:,387),[64,22,9,32],[0,0,0,0],4,2,wf8(:,44),wf4(:,16))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(291),m3h2x64(:,355),heltab2x128(:,:,387))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(626)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(388),h0tab(:,388),[64,22,9,32],[0,0,0,0],4,2,wf8(:,46),wf4(:,16))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(292),m3h2x64(:,356),heltab2x128(:,:,388))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(620)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(389),h0tab(:,389),[64,9,22,32],[0,0,0,0],4,2,wf4(:,11),wf8(:,44))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,357),heltab2x128(:,:,389))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(293),n2h64(305))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(622)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(390),h0tab(:,390),[64,9,22,32],[0,0,0,0],4,2,wf4(:,11),wf8(:,46))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,358),heltab2x128(:,:,390))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(294),n2h64(306))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(624)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(391),h0tab(:,391),[64,9,22,32],[0,0,0,0],4,2,wf4(:,16),wf8(:,44))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,359),heltab2x128(:,:,391))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(295),n2h64(307))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(626)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(392),h0tab(:,392),[64,9,22,32],[0,0,0,0],4,2,wf4(:,16),wf8(:,46))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,360),heltab2x128(:,:,392))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(296),n2h64(308))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(620)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(393),h0tab(:,393),[64,9,32,22],[0,0,0,0],4,2,wf4(:,11),wf8(:,44))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,361),heltab2x128(:,:,393))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(297),n2h64(309))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(622)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(394),h0tab(:,394),[64,9,32,22],[0,0,0,0],4,2,wf4(:,11),wf8(:,46))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,362),heltab2x128(:,:,394))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(298),n2h64(310))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(624)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(395),h0tab(:,395),[64,9,32,22],[0,0,0,0],4,2,wf4(:,16),wf8(:,44))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,363),heltab2x128(:,:,395))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(299),n2h64(311))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(626)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(396),h0tab(:,396),[64,9,32,22],[0,0,0,0],4,2,wf4(:,16),wf8(:,46))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,364),heltab2x128(:,:,396))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(300),n2h64(312))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(630)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(397),h0tab(:,397),[64,16,9,38],[0,0,0,0],4,2,wf4(:,11),wf8(:,36))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(301),m3h2x64(:,365),heltab2x128(:,:,397))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(632)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(398),h0tab(:,398),[64,16,9,38],[0,0,0,0],4,2,wf4(:,11),wf8(:,38))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(302),m3h2x64(:,366),heltab2x128(:,:,398))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(634)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(399),h0tab(:,399),[64,16,9,38],[0,0,0,0],4,2,wf4(:,16),wf8(:,36))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(303),m3h2x64(:,367),heltab2x128(:,:,399))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(636)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(400),h0tab(:,400),[64,16,9,38],[0,0,0,0],4,2,wf4(:,16),wf8(:,38))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(304),m3h2x64(:,368),heltab2x128(:,:,400))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(630)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(401),h0tab(:,401),[64,9,38,16],[0,0,0,0],4,2,wf4(:,11),wf8(:,36))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,369),heltab2x128(:,:,401))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(305),n2h64(313))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(632)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(402),h0tab(:,402),[64,9,38,16],[0,0,0,0],4,2,wf4(:,11),wf8(:,38))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,370),heltab2x128(:,:,402))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(306),n2h64(314))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(634)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(403),h0tab(:,403),[64,9,38,16],[0,0,0,0],4,2,wf4(:,16),wf8(:,36))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,371),heltab2x128(:,:,403))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(307),n2h64(315))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(636)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(404),h0tab(:,404),[64,9,38,16],[0,0,0,0],4,2,wf4(:,16),wf8(:,38))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,372),heltab2x128(:,:,404))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(308),n2h64(316))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(630)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(405),h0tab(:,405),[64,9,16,38],[0,0,0,0],4,2,wf4(:,11),wf8(:,36))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,373),heltab2x128(:,:,405))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(309),n2h64(317))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(632)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(406),h0tab(:,406),[64,9,16,38],[0,0,0,0],4,2,wf4(:,11),wf8(:,38))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,374),heltab2x128(:,:,406))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(310),n2h64(318))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(634)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(407),h0tab(:,407),[64,9,16,38],[0,0,0,0],4,2,wf4(:,16),wf8(:,36))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,375),heltab2x128(:,:,407))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(311),n2h64(319))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(636)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(408),h0tab(:,408),[64,9,16,38],[0,0,0,0],4,2,wf4(:,16),wf8(:,38))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,376),heltab2x128(:,:,408))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(312),n2h64(320))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(464)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(409),h0tab(:,409),[64,15,32,16],[0,0,0,0],4,1,wf16(:,33))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,377),heltab2x128(:,:,409))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(313),n2h64(321))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(466)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(410),h0tab(:,410),[64,15,32,16],[0,0,0,0],4,1,wf16(:,183))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,378),heltab2x128(:,:,410))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(314),n2h64(322))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(468)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(411),h0tab(:,411),[64,15,32,16],[0,0,0,0],4,1,wf16(:,35))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,379),heltab2x128(:,:,411))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(315),n2h64(323))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(470)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(412),h0tab(:,412),[64,15,32,16],[0,0,0,0],4,1,wf16(:,184))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,380),heltab2x128(:,:,412))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(316),n2h64(324))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(464)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(413),h0tab(:,413),[64,15,16,32],[0,0,0,0],4,1,wf16(:,33))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,381),heltab2x128(:,:,413))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(317),n2h64(325))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(466)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(414),h0tab(:,414),[64,15,16,32],[0,0,0,0],4,1,wf16(:,183))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,382),heltab2x128(:,:,414))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(318),n2h64(326))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(468)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(415),h0tab(:,415),[64,15,16,32],[0,0,0,0],4,1,wf16(:,35))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,383),heltab2x128(:,:,415))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(319),n2h64(327))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(470)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(416),h0tab(:,416),[64,15,16,32],[0,0,0,0],4,1,wf16(:,184))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,384),heltab2x128(:,:,416))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(320),n2h64(328))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(464)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(417),h0tab(:,417),[64,16,15,32],[0,0,0,0],4,1,wf16(:,33))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(321),m3h2x64(:,385),heltab2x128(:,:,417))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(466)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(418),h0tab(:,418),[64,16,15,32],[0,0,0,0],4,1,wf16(:,183))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(322),m3h2x64(:,386),heltab2x128(:,:,418))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(468)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(419),h0tab(:,419),[64,16,15,32],[0,0,0,0],4,1,wf16(:,35))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(323),m3h2x64(:,387),heltab2x128(:,:,419))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(470)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(420),h0tab(:,420),[64,16,15,32],[0,0,0,0],4,1,wf16(:,184))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(324),m3h2x64(:,388),heltab2x128(:,:,420))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(472)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(421),h0tab(:,421),[64,15,32,16],[0,0,0,0],4,1,wf16(:,37))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,389),heltab2x128(:,:,421))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(325),n2h64(329))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(474)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(422),h0tab(:,422),[64,15,32,16],[0,0,0,0],4,1,wf16(:,38))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,390),heltab2x128(:,:,422))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(326),n2h64(330))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(476)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(423),h0tab(:,423),[64,15,32,16],[0,0,0,0],4,1,wf16(:,185))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,391),heltab2x128(:,:,423))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(327),n2h64(331))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(478)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(424),h0tab(:,424),[64,15,32,16],[0,0,0,0],4,1,wf16(:,186))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,392),heltab2x128(:,:,424))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(328),n2h64(332))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(472)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(425),h0tab(:,425),[64,15,16,32],[0,0,0,0],4,1,wf16(:,37))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,393),heltab2x128(:,:,425))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(329),n2h64(333))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(474)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(426),h0tab(:,426),[64,15,16,32],[0,0,0,0],4,1,wf16(:,38))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,394),heltab2x128(:,:,426))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(330),n2h64(334))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(476)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(427),h0tab(:,427),[64,15,16,32],[0,0,0,0],4,1,wf16(:,185))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,395),heltab2x128(:,:,427))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(331),n2h64(335))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(478)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(428),h0tab(:,428),[64,15,16,32],[0,0,0,0],4,1,wf16(:,186))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,396),heltab2x128(:,:,428))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(332),n2h64(336))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(472)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(429),h0tab(:,429),[64,16,15,32],[0,0,0,0],4,1,wf16(:,37))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(333),m3h2x64(:,397),heltab2x128(:,:,429))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(474)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(430),h0tab(:,430),[64,16,15,32],[0,0,0,0],4,1,wf16(:,38))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(334),m3h2x64(:,398),heltab2x128(:,:,430))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(476)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(431),h0tab(:,431),[64,16,15,32],[0,0,0,0],4,1,wf16(:,185))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(335),m3h2x64(:,399),heltab2x128(:,:,431))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(478)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(432),h0tab(:,432),[64,16,15,32],[0,0,0,0],4,1,wf16(:,186))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(336),m3h2x64(:,400),heltab2x128(:,:,432))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(488)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(433),h0tab(:,433),[64,15,32,16],[0,0,0,0],4,1,wf16(:,41))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,401),heltab2x128(:,:,433))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(337),n2h64(337))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(490)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(434),h0tab(:,434),[64,15,32,16],[0,0,0,0],4,1,wf16(:,187))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,402),heltab2x128(:,:,434))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(338),n2h64(338))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(492)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(435),h0tab(:,435),[64,15,32,16],[0,0,0,0],4,1,wf16(:,43))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,403),heltab2x128(:,:,435))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(339),n2h64(339))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(494)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(436),h0tab(:,436),[64,15,32,16],[0,0,0,0],4,1,wf16(:,188))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,404),heltab2x128(:,:,436))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(340),n2h64(340))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(488)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(437),h0tab(:,437),[64,15,16,32],[0,0,0,0],4,1,wf16(:,41))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,405),heltab2x128(:,:,437))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(341),n2h64(341))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(490)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(438),h0tab(:,438),[64,15,16,32],[0,0,0,0],4,1,wf16(:,187))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,406),heltab2x128(:,:,438))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(342),n2h64(342))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(492)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(439),h0tab(:,439),[64,15,16,32],[0,0,0,0],4,1,wf16(:,43))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,407),heltab2x128(:,:,439))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(343),n2h64(343))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(494)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(440),h0tab(:,440),[64,15,16,32],[0,0,0,0],4,1,wf16(:,188))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,408),heltab2x128(:,:,440))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(344),n2h64(344))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(488)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(441),h0tab(:,441),[64,16,15,32],[0,0,0,0],4,1,wf16(:,41))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(345),m3h2x64(:,409),heltab2x128(:,:,441))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(490)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(442),h0tab(:,442),[64,16,15,32],[0,0,0,0],4,1,wf16(:,187))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(346),m3h2x64(:,410),heltab2x128(:,:,442))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(492)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(443),h0tab(:,443),[64,16,15,32],[0,0,0,0],4,1,wf16(:,43))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(347),m3h2x64(:,411),heltab2x128(:,:,443))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(494)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(444),h0tab(:,444),[64,16,15,32],[0,0,0,0],4,1,wf16(:,188))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(348),m3h2x64(:,412),heltab2x128(:,:,444))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(496)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(445),h0tab(:,445),[64,15,32,16],[0,0,0,0],4,1,wf16(:,45))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,413),heltab2x128(:,:,445))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(349),n2h64(345))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(498)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(446),h0tab(:,446),[64,15,32,16],[0,0,0,0],4,1,wf16(:,189))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,414),heltab2x128(:,:,446))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(350),n2h64(346))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(500)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(447),h0tab(:,447),[64,15,32,16],[0,0,0,0],4,1,wf16(:,47))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,415),heltab2x128(:,:,447))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(351),n2h64(347))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(502)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(448),h0tab(:,448),[64,15,32,16],[0,0,0,0],4,1,wf16(:,190))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,416),heltab2x128(:,:,448))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(352),n2h64(348))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(496)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(449),h0tab(:,449),[64,15,16,32],[0,0,0,0],4,1,wf16(:,45))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,417),heltab2x128(:,:,449))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(353),n2h64(349))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(498)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(450),h0tab(:,450),[64,15,16,32],[0,0,0,0],4,1,wf16(:,189))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,418),heltab2x128(:,:,450))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(354),n2h64(350))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(500)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(451),h0tab(:,451),[64,15,16,32],[0,0,0,0],4,1,wf16(:,47))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,419),heltab2x128(:,:,451))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(355),n2h64(351))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(502)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(452),h0tab(:,452),[64,15,16,32],[0,0,0,0],4,1,wf16(:,190))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,420),heltab2x128(:,:,452))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(356),n2h64(352))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(496)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(453),h0tab(:,453),[64,16,15,32],[0,0,0,0],4,1,wf16(:,45))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(357),m3h2x64(:,421),heltab2x128(:,:,453))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(498)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(454),h0tab(:,454),[64,16,15,32],[0,0,0,0],4,1,wf16(:,189))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(358),m3h2x64(:,422),heltab2x128(:,:,454))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(500)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(455),h0tab(:,455),[64,16,15,32],[0,0,0,0],4,1,wf16(:,47))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(359),m3h2x64(:,423),heltab2x128(:,:,455))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(502)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(456),h0tab(:,456),[64,16,15,32],[0,0,0,0],4,1,wf16(:,190))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(360),m3h2x64(:,424),heltab2x128(:,:,456))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(512)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(457),h0tab(:,457),[64,15,32,16],[0,0,0,0],4,1,wf16(:,49))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,425),heltab2x128(:,:,457))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(361),n2h64(353))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(514)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(458),h0tab(:,458),[64,15,32,16],[0,0,0,0],4,1,wf16(:,191))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,426),heltab2x128(:,:,458))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(362),n2h64(354))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(516)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(459),h0tab(:,459),[64,15,32,16],[0,0,0,0],4,1,wf16(:,51))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,427),heltab2x128(:,:,459))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(363),n2h64(355))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(518)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(460),h0tab(:,460),[64,15,32,16],[0,0,0,0],4,1,wf16(:,192))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,428),heltab2x128(:,:,460))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(364),n2h64(356))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(512)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(461),h0tab(:,461),[64,15,16,32],[0,0,0,0],4,1,wf16(:,49))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,429),heltab2x128(:,:,461))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(365),n2h64(357))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(514)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(462),h0tab(:,462),[64,15,16,32],[0,0,0,0],4,1,wf16(:,191))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,430),heltab2x128(:,:,462))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(366),n2h64(358))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(516)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(463),h0tab(:,463),[64,15,16,32],[0,0,0,0],4,1,wf16(:,51))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,431),heltab2x128(:,:,463))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(367),n2h64(359))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(518)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(464),h0tab(:,464),[64,15,16,32],[0,0,0,0],4,1,wf16(:,192))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,432),heltab2x128(:,:,464))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(368),n2h64(360))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(512)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(465),h0tab(:,465),[64,16,15,32],[0,0,0,0],4,1,wf16(:,49))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(369),m3h2x64(:,433),heltab2x128(:,:,465))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(514)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(466),h0tab(:,466),[64,16,15,32],[0,0,0,0],4,1,wf16(:,191))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(370),m3h2x64(:,434),heltab2x128(:,:,466))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(516)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(467),h0tab(:,467),[64,16,15,32],[0,0,0,0],4,1,wf16(:,51))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(371),m3h2x64(:,435),heltab2x128(:,:,467))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(518)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(468),h0tab(:,468),[64,16,15,32],[0,0,0,0],4,1,wf16(:,192))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(372),m3h2x64(:,436),heltab2x128(:,:,468))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(520)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(469),h0tab(:,469),[64,15,32,16],[0,0,0,0],4,1,wf16(:,53))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,437),heltab2x128(:,:,469))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(373),n2h64(361))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(522)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(470),h0tab(:,470),[64,15,32,16],[0,0,0,0],4,1,wf16(:,54))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,438),heltab2x128(:,:,470))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(374),n2h64(362))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(524)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(471),h0tab(:,471),[64,15,32,16],[0,0,0,0],4,1,wf16(:,193))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,439),heltab2x128(:,:,471))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(375),n2h64(363))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(526)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(472),h0tab(:,472),[64,15,32,16],[0,0,0,0],4,1,wf16(:,194))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,440),heltab2x128(:,:,472))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(376),n2h64(364))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(520)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(473),h0tab(:,473),[64,15,16,32],[0,0,0,0],4,1,wf16(:,53))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,441),heltab2x128(:,:,473))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(377),n2h64(365))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(522)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(474),h0tab(:,474),[64,15,16,32],[0,0,0,0],4,1,wf16(:,54))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,442),heltab2x128(:,:,474))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(378),n2h64(366))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(524)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(475),h0tab(:,475),[64,15,16,32],[0,0,0,0],4,1,wf16(:,193))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,443),heltab2x128(:,:,475))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(379),n2h64(367))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(526)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(476),h0tab(:,476),[64,15,16,32],[0,0,0,0],4,1,wf16(:,194))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,444),heltab2x128(:,:,476))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(380),n2h64(368))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(520)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(477),h0tab(:,477),[64,16,15,32],[0,0,0,0],4,1,wf16(:,53))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(381),m3h2x64(:,445),heltab2x128(:,:,477))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(522)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(478),h0tab(:,478),[64,16,15,32],[0,0,0,0],4,1,wf16(:,54))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(382),m3h2x64(:,446),heltab2x128(:,:,478))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(524)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(479),h0tab(:,479),[64,16,15,32],[0,0,0,0],4,1,wf16(:,193))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(383),m3h2x64(:,447),heltab2x128(:,:,479))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(526)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(480),h0tab(:,480),[64,16,15,32],[0,0,0,0],4,1,wf16(:,194))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(384),m3h2x64(:,448),heltab2x128(:,:,480))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(6),[G1H32(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(7),[G1H32(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(8),[G1H32(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(10),[G1H32(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(1),[G1H32(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(2),[G1H32(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(4),[G1H32(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(5),[G1H32(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(25),[G1H32(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(26),[G1H32(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(28),[G1H32(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(29),[G1H32(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(20),[G1H32(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(22),[G1H32(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(23),[G1H32(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(24),[G1H32(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H64(5),[G1H64(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H64(7),[G1H64(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H64(37),[G1H64(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H64(39),[G1H64(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H64(69),[G1H64(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H64(71),[G1H64(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H64(173),[G1H64(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H64(175),[G1H64(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H64(205),[G1H64(201)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H64(207),[G1H64(203)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H64(237),[G1H64(233)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H64(239),[G1H64(235)])
  call Hloop_QV_A(ntryL,G1H16(3),wf4(:,1),G1H4(30),m3h4x4(:,65),heltab2x16(:,:,89))
  call Hloop_Q_A(ntryL,G1H4(30),79,0,G2H4(5),n2h4(89))
  call Hloop_QZ_A(ntryL,G1H16(9),wf4(:,8),G1H4(41),ngZd,m3h4x4(:,66),heltab2x16(:,:,90))
  call Hloop_Q_A(ntryL,G1H4(41),79,0,G2H4(7),n2h4(90))
  call Hloop_QV_A(ntryL,G1H16(15),wf4(:,2),G1H4(52),m3h4x4(:,67),heltab2x16(:,:,91))
  call Hloop_Q_A(ntryL,G1H4(52),79,0,G2H4(8),n2h4(91))
  call Hloop_QZ_A(ntryL,G1H16(21),wf4(:,6),G1H4(63),ngZd,m3h4x4(:,68),heltab2x16(:,:,92))
  call Hloop_Q_A(ntryL,G1H4(63),79,0,G2H4(13),n2h4(92))
  call Hloop_AV_Q(ntryL,G1H16(27),wf4(:,1),G1H4(74),m3h4x4(:,69),heltab2x16(:,:,93))
  call Hloop_A_Q(ntryL,G1H4(74),79,0,G2H4(15),n2h4(93))
  call Hloop_AZ_Q(ntryL,G1H16(33),wf4(:,8),G1H4(85),ngZd,m3h4x4(:,70),heltab2x16(:,:,94))
  call Hloop_A_Q(ntryL,G1H4(85),79,0,G2H4(16),n2h4(94))
  call Hloop_AV_Q(ntryL,G1H16(39),wf4(:,2),G1H4(96),m3h4x4(:,71),heltab2x16(:,:,95))
  call Hloop_A_Q(ntryL,G1H4(96),79,0,G2H4(21),n2h4(95))
  call Hloop_AZ_Q(ntryL,G1H16(45),wf4(:,6),G1H4(107),ngZd,m3h4x4(:,72),heltab2x16(:,:,96))
  call Hloop_A_Q(ntryL,G1H4(107),79,0,G2H4(23),n2h4(96))
  call Hloop_QV_A(ntryL,G1H32(6),wf4(:,1),G1H8(53),m3h4x8(:,65),heltab2x32(:,:,81))
  call Hloop_Q_A(ntryL,G1H8(53),85,0,G2H8(36),n2h8(97))
  call Hloop_QV_A(ntryL,G1H32(7),wf4(:,1),G1H8(54),m3h4x8(:,66),heltab2x32(:,:,82))
  call Hloop_Q_A(ntryL,G1H8(54),85,0,G2H8(41),n2h8(98))
  call Hloop_QZ_A(ntryL,G1H32(8),wf4(:,8),G1H8(69),ngZd,m3h4x8(:,67),heltab2x32(:,:,83))
  call Hloop_Q_A(ntryL,G1H8(69),85,0,G2H8(43),n2h8(99))
  call Hloop_QZ_A(ntryL,G1H32(10),wf4(:,8),G1H8(70),ngZd,m3h4x8(:,68),heltab2x32(:,:,84))
  call Hloop_Q_A(ntryL,G1H8(70),85,0,G2H8(44),n2h8(100))
  call Hloop_QV_A(ntryL,G1H32(1),wf4(:,2),G1H8(85),m3h4x8(:,69),heltab2x32(:,:,85))
  call Hloop_Q_A(ntryL,G1H8(85),90,0,G2H8(57),n2h8(101))
  call Hloop_QZ_A(ntryL,G1H32(2),wf4(:,6),G1H8(86),ngZd,m3h4x8(:,70),heltab2x32(:,:,86))
  call Hloop_Q_A(ntryL,G1H8(86),90,0,G2H8(59),n2h8(102))
  call Hloop_QV_A(ntryL,G1H32(4),wf4(:,2),G1H8(101),m3h4x8(:,71),heltab2x32(:,:,87))
  call Hloop_Q_A(ntryL,G1H8(101),90,0,G2H8(60),n2h8(103))
  call Hloop_QZ_A(ntryL,G1H32(5),wf4(:,6),G1H8(102),ngZd,m3h4x8(:,72),heltab2x32(:,:,88))
  call Hloop_Q_A(ntryL,G1H8(102),90,0,G2H8(61),n2h8(104))
  call Hloop_QV_A(ntryL,G1H16(51),wf4(:,11),G1H4(25),m3h4x4(:,73),heltab2x16(:,:,97))
  call Hloop_Q_A(ntryL,G1H4(25),79,0,G2H4(24),n2h4(97))
  call Hloop_QZ_A(ntryL,G1H16(57),wf4(:,16),G1H4(26),ngZd,m3h4x4(:,74),heltab2x16(:,:,98))
  call Hloop_Q_A(ntryL,G1H4(26),79,0,G2H4(29),n2h4(98))
  call Hloop_QV_A(ntryL,G1H16(63),wf4(:,12),G1H4(31),m3h4x4(:,75),heltab2x16(:,:,99))
  call Hloop_Q_A(ntryL,G1H4(31),79,0,G2H4(31),n2h4(99))
  call Hloop_QZ_A(ntryL,G1H16(69),wf4(:,14),G1H4(32),ngZd,m3h4x4(:,76),heltab2x16(:,:,100))
  call Hloop_Q_A(ntryL,G1H4(32),79,0,G2H4(32),n2h4(100))
  call Hloop_AV_Q(ntryL,G1H16(75),wf4(:,11),G1H4(36),m3h4x4(:,77),heltab2x16(:,:,101))
  call Hloop_A_Q(ntryL,G1H4(36),79,0,G2H4(37),n2h4(101))
  call Hloop_AZ_Q(ntryL,G1H16(81),wf4(:,16),G1H4(37),ngZd,m3h4x4(:,78),heltab2x16(:,:,102))
  call Hloop_A_Q(ntryL,G1H4(37),79,0,G2H4(39),n2h4(102))
  call Hloop_AV_Q(ntryL,G1H16(87),wf4(:,12),G1H4(42),m3h4x4(:,79),heltab2x16(:,:,103))
  call Hloop_A_Q(ntryL,G1H4(42),79,0,G2H4(40),n2h4(103))
  call Hloop_AZ_Q(ntryL,G1H16(93),wf4(:,14),G1H4(43),ngZd,m3h4x4(:,80),heltab2x16(:,:,104))
  call Hloop_A_Q(ntryL,G1H4(43),79,0,G2H4(45),n2h4(104))
  call Hloop_QV_A(ntryL,G1H32(25),wf4(:,11),G1H8(117),m3h4x8(:,73),heltab2x32(:,:,89))
  call Hloop_Q_A(ntryL,G1H8(117),89,0,G2H8(63),n2h8(105))
  call Hloop_QV_A(ntryL,G1H32(26),wf4(:,11),G1H8(118),m3h4x8(:,74),heltab2x32(:,:,90))
  call Hloop_Q_A(ntryL,G1H8(118),89,0,G2H8(64),n2h8(106))
  call Hloop_QZ_A(ntryL,G1H32(28),wf4(:,16),G1H8(133),ngZd,m3h4x8(:,75),heltab2x32(:,:,91))
  call Hloop_Q_A(ntryL,G1H8(133),89,0,G2H8(73),n2h8(107))
  call Hloop_QZ_A(ntryL,G1H32(29),wf4(:,16),G1H8(134),ngZd,m3h4x8(:,76),heltab2x32(:,:,92))
  call Hloop_Q_A(ntryL,G1H8(134),89,0,G2H8(75),n2h8(108))
  call Hloop_QV_A(ntryL,G1H32(20),wf4(:,12),G1H8(149),m3h4x8(:,77),heltab2x32(:,:,93))
  call Hloop_Q_A(ntryL,G1H8(149),86,0,G2H8(76),n2h8(109))
  call Hloop_QZ_A(ntryL,G1H32(22),wf4(:,14),G1H8(150),ngZd,m3h4x8(:,78),heltab2x32(:,:,94))
  call Hloop_Q_A(ntryL,G1H8(150),86,0,G2H8(81),n2h8(110))
  call Hloop_QV_A(ntryL,G1H32(23),wf4(:,12),G1H8(165),m3h4x8(:,79),heltab2x32(:,:,95))
  call Hloop_Q_A(ntryL,G1H8(165),86,0,G2H8(83),n2h8(111))
  call Hloop_QZ_A(ntryL,G1H32(24),wf4(:,14),G1H8(166),ngZd,m3h4x8(:,80),heltab2x32(:,:,96))
  call Hloop_Q_A(ntryL,G1H8(166),86,0,G2H8(84),n2h8(112))
  call Hloop_AV_Q(ntryL,G1H64(5),wf4(:,1),G1H16(20),m3h4x16(:,49),heltab2x64(:,:,65))
  call Hloop_A_Q(ntryL,G1H16(20),69,0,G2H16(33),n2h16(65))
  call Hloop_AV_Q(ntryL,G1H64(2),wf4(:,1),G1H16(22),m3h4x16(:,50),heltab2x64(:,:,66))
  call Hloop_A_Q(ntryL,G1H16(22),69,nMT,G2H16(35),n2h16(66))
  call Hloop_QV_A(ntryL,G1H64(7),wf4(:,1),G1H16(23),m3h4x16(:,51),heltab2x64(:,:,67))
  call Hloop_Q_A(ntryL,G1H16(23),69,0,G2H16(37),n2h16(67))
  call Hloop_QV_A(ntryL,G1H64(4),wf4(:,1),G1H16(24),m3h4x16(:,52),heltab2x64(:,:,68))
  call Hloop_Q_A(ntryL,G1H16(24),69,nMT,G2H16(39),n2h16(68))
  call Hloop_AV_Q(ntryL,G1H64(6),wf4(:,1),G1H16(25),m3h4x16(:,53),heltab2x64(:,:,69))
  call Hloop_A_Q(ntryL,G1H16(25),69,nMB,G2H16(41),n2h16(69))
  call Hloop_QV_A(ntryL,G1H64(8),wf4(:,1),G1H16(26),m3h4x16(:,54),heltab2x64(:,:,70))
  call Hloop_Q_A(ntryL,G1H16(26),69,nMB,G2H16(42),n2h16(70))
  call Hloop_AV_Q(ntryL,G1H64(9),wf4(:,1),G1H16(28),m3h4x16(:,55),heltab2x64(:,:,71))
  call Hloop_A_Q(ntryL,G1H16(28),69,0,G2H16(45),n2h16(71))
  call Hloop_AV_Q(ntryL,G1H64(10),wf4(:,1),G1H16(29),m3h4x16(:,56),heltab2x64(:,:,72))
  call Hloop_A_Q(ntryL,G1H16(29),69,nMT,G2H16(47),n2h16(72))
  call Hloop_QV_A(ntryL,G1H64(11),wf4(:,1),G1H16(30),m3h4x16(:,57),heltab2x64(:,:,73))
  call Hloop_Q_A(ntryL,G1H16(30),69,0,G2H16(2),n2h16(73))
  call Hloop_QV_A(ntryL,G1H64(12),wf4(:,1),G1H16(31),m3h4x16(:,58),heltab2x64(:,:,74))
  call Hloop_Q_A(ntryL,G1H16(31),69,nMT,G2H16(4),n2h16(74))
  call Hloop_AV_Q(ntryL,G1H64(13),wf4(:,1),G1H16(32),m3h4x16(:,59),heltab2x64(:,:,75))
  call Hloop_A_Q(ntryL,G1H16(32),69,0,G2H16(7),n2h16(75))
  call Hloop_AV_Q(ntryL,G1H64(14),wf4(:,1),G1H16(34),m3h4x16(:,60),heltab2x64(:,:,76))
  call Hloop_A_Q(ntryL,G1H16(34),69,nMB,G2H16(8),n2h16(76))
  call Hloop_QV_A(ntryL,G1H64(15),wf4(:,1),G1H16(35),m3h4x16(:,61),heltab2x64(:,:,77))
  call Hloop_Q_A(ntryL,G1H16(35),69,0,G2H16(10),n2h16(77))
  call Hloop_QV_A(ntryL,G1H64(16),wf4(:,1),G1H16(36),m3h4x16(:,62),heltab2x64(:,:,78))
  call Hloop_Q_A(ntryL,G1H16(36),69,nMB,G2H16(12),n2h16(78))
  call Hloop_AZ_Q(ntryL,G1H64(17),wf4(:,8),G1H16(37),ngZu,m3h4x16(:,63),heltab2x64(:,:,79))
  call Hloop_A_Q(ntryL,G1H16(37),69,0,G2H16(15),n2h16(79))
  call Hloop_AZ_Q(ntryL,G1H64(18),wf4(:,8),G1H16(38),ngZu,m3h4x16(:,64),heltab2x64(:,:,80))
  call Hloop_A_Q(ntryL,G1H16(38),69,nMT,G2H16(16),n2h16(80))
  call Hloop_QZ_A(ntryL,G1H64(19),wf4(:,8),G1H16(40),ngZu,m3h4x16(:,65),heltab2x64(:,:,81))
  call Hloop_Q_A(ntryL,G1H16(40),69,0,G2H16(19),n2h16(81))
  call Hloop_QZ_A(ntryL,G1H64(20),wf4(:,8),G1H16(41),ngZu,m3h4x16(:,66),heltab2x64(:,:,82))
  call Hloop_Q_A(ntryL,G1H16(41),69,nMT,G2H16(20),n2h16(82))
  call Hloop_AZ_Q(ntryL,G1H64(21),wf4(:,8),G1H16(42),ngZd,m3h4x16(:,67),heltab2x64(:,:,83))
  call Hloop_A_Q(ntryL,G1H16(42),69,0,G2H16(23),n2h16(83))
  call Hloop_AZ_Q(ntryL,G1H64(22),wf4(:,8),G1H16(43),ngZd,m3h4x16(:,68),heltab2x64(:,:,84))
  call Hloop_A_Q(ntryL,G1H16(43),69,nMB,G2H16(24),n2h16(84))
  call Hloop_QZ_A(ntryL,G1H64(23),wf4(:,8),G1H16(44),ngZd,m3h4x16(:,69),heltab2x64(:,:,85))
  call Hloop_Q_A(ntryL,G1H16(44),69,0,G2H16(26),n2h16(85))
  call Hloop_QZ_A(ntryL,G1H64(24),wf4(:,8),G1H16(46),ngZd,m3h4x16(:,70),heltab2x64(:,:,86))
  call Hloop_Q_A(ntryL,G1H16(46),69,nMB,G2H16(28),n2h16(86))
  call Hloop_AZ_Q(ntryL,G1H64(25),wf4(:,8),G1H16(47),ngZu,m3h4x16(:,71),heltab2x64(:,:,87))
  call Hloop_A_Q(ntryL,G1H16(47),69,0,G2H16(31),n2h16(87))
  call Hloop_AZ_Q(ntryL,G1H64(26),wf4(:,8),G1H16(48),ngZu,m3h4x16(:,72),heltab2x64(:,:,88))
  call Hloop_A_Q(ntryL,G1H16(48),69,nMT,G2H16(32),n2h16(88))
  call Hloop_QZ_A(ntryL,G1H64(27),wf4(:,8),G1H16(49),ngZu,m3h4x16(:,73),heltab2x64(:,:,89))
  call Hloop_Q_A(ntryL,G1H16(49),69,0,G2H16(34),n2h16(89))
  call Hloop_QZ_A(ntryL,G1H64(28),wf4(:,8),G1H16(50),ngZu,m3h4x16(:,74),heltab2x64(:,:,90))
  call Hloop_Q_A(ntryL,G1H16(50),69,nMT,G2H16(36),n2h16(90))
  call Hloop_AZ_Q(ntryL,G1H64(29),wf4(:,8),G1H16(52),ngZd,m3h4x16(:,75),heltab2x64(:,:,91))
  call Hloop_A_Q(ntryL,G1H16(52),69,0,G2H16(38),n2h16(91))
  call Hloop_AZ_Q(ntryL,G1H64(30),wf4(:,8),G1H16(53),ngZd,m3h4x16(:,76),heltab2x64(:,:,92))
  call Hloop_A_Q(ntryL,G1H16(53),69,nMB,G2H16(40),n2h16(92))
  call Hloop_QZ_A(ntryL,G1H64(31),wf4(:,8),G1H16(54),ngZd,m3h4x16(:,77),heltab2x64(:,:,93))
  call Hloop_Q_A(ntryL,G1H16(54),69,0,G2H16(43),n2h16(93))
  call Hloop_QZ_A(ntryL,G1H64(32),wf4(:,8),G1H16(55),ngZd,m3h4x16(:,78),heltab2x64(:,:,94))
  call Hloop_Q_A(ntryL,G1H16(55),69,nMB,G2H16(44),n2h16(94))
  call Hloop_AV_Q(ntryL,G1H64(37),wf4(:,1),G1H16(56),m3h4x16(:,79),heltab2x64(:,:,95))
  call Hloop_A_Q(ntryL,G1H16(56),69,0,G2H16(46),n2h16(95))
  call Hloop_AV_Q(ntryL,G1H64(34),wf4(:,1),G1H16(58),m3h4x16(:,80),heltab2x64(:,:,96))
  call Hloop_A_Q(ntryL,G1H16(58),69,nMT,G2H16(48),n2h16(96))
  call Hloop_QV_A(ntryL,G1H64(39),wf4(:,1),G1H16(59),m3h4x16(:,81),heltab2x64(:,:,97))
  call Hloop_Q_A(ntryL,G1H16(59),69,0,G2H16(1),n2h16(97))
  call Hloop_QV_A(ntryL,G1H64(36),wf4(:,1),G1H16(60),m3h4x16(:,82),heltab2x64(:,:,98))
  call Hloop_Q_A(ntryL,G1H16(60),69,nMT,G2H16(3),n2h16(98))
  call Hloop_AV_Q(ntryL,G1H64(38),wf4(:,1),G1H16(61),m3h4x16(:,83),heltab2x64(:,:,99))
  call Hloop_A_Q(ntryL,G1H16(61),69,nMB,G2H16(5),n2h16(99))
  call Hloop_QV_A(ntryL,G1H64(40),wf4(:,1),G1H16(62),m3h4x16(:,84),heltab2x64(:,:,100))
  call Hloop_Q_A(ntryL,G1H16(62),69,nMB,G2H16(6),n2h16(100))
  call Hloop_AV_Q(ntryL,G1H64(41),wf4(:,1),G1H16(64),m3h4x16(:,85),heltab2x64(:,:,101))
  call Hloop_A_Q(ntryL,G1H16(64),69,0,G2H16(9),n2h16(101))
  call Hloop_AV_Q(ntryL,G1H64(42),wf4(:,1),G1H16(65),m3h4x16(:,86),heltab2x64(:,:,102))
  call Hloop_A_Q(ntryL,G1H16(65),69,nMT,G2H16(11),n2h16(102))
  call Hloop_QV_A(ntryL,G1H64(43),wf4(:,1),G1H16(66),m3h4x16(:,87),heltab2x64(:,:,103))
  call Hloop_Q_A(ntryL,G1H16(66),69,0,G2H16(13),n2h16(103))
  call Hloop_QV_A(ntryL,G1H64(44),wf4(:,1),G1H16(67),m3h4x16(:,88),heltab2x64(:,:,104))
  call Hloop_Q_A(ntryL,G1H16(67),69,nMT,G2H16(14),n2h16(104))
  call Hloop_AV_Q(ntryL,G1H64(45),wf4(:,1),G1H16(68),m3h4x16(:,89),heltab2x64(:,:,105))
  call Hloop_A_Q(ntryL,G1H16(68),69,0,G2H16(17),n2h16(105))
  call Hloop_AV_Q(ntryL,G1H64(46),wf4(:,1),G1H16(70),m3h4x16(:,90),heltab2x64(:,:,106))
  call Hloop_A_Q(ntryL,G1H16(70),69,nMB,G2H16(18),n2h16(106))
  call Hloop_QV_A(ntryL,G1H64(47),wf4(:,1),G1H16(71),m3h4x16(:,91),heltab2x64(:,:,107))
  call Hloop_Q_A(ntryL,G1H16(71),69,0,G2H16(21),n2h16(107))
  call Hloop_QV_A(ntryL,G1H64(48),wf4(:,1),G1H16(72),m3h4x16(:,92),heltab2x64(:,:,108))
  call Hloop_Q_A(ntryL,G1H16(72),69,nMB,G2H16(22),n2h16(108))
  call Hloop_AZ_Q(ntryL,G1H64(49),wf4(:,8),G1H16(73),ngZu,m3h4x16(:,93),heltab2x64(:,:,109))
  call Hloop_A_Q(ntryL,G1H16(73),69,0,G2H16(25),n2h16(109))
  call Hloop_AZ_Q(ntryL,G1H64(50),wf4(:,8),G1H16(74),ngZu,m3h4x16(:,94),heltab2x64(:,:,110))
  call Hloop_A_Q(ntryL,G1H16(74),69,nMT,G2H16(27),n2h16(110))
  call Hloop_QZ_A(ntryL,G1H64(51),wf4(:,8),G1H16(76),ngZu,m3h4x16(:,95),heltab2x64(:,:,111))
  call Hloop_Q_A(ntryL,G1H16(76),69,0,G2H16(29),n2h16(111))
  call Hloop_QZ_A(ntryL,G1H64(52),wf4(:,8),G1H16(77),ngZu,m3h4x16(:,96),heltab2x64(:,:,112))
  call Hloop_Q_A(ntryL,G1H16(77),69,nMT,G2H16(30),n2h16(112))
  call Hloop_AZ_Q(ntryL,G1H64(53),wf4(:,8),G1H16(78),ngZd,m3h4x16(:,97),heltab2x64(:,:,113))
  call Hloop_A_Q(ntryL,G1H16(78),69,0,G2H16(49),n2h16(113))
  call Hloop_AZ_Q(ntryL,G1H64(54),wf4(:,8),G1H16(79),ngZd,m3h4x16(:,98),heltab2x64(:,:,114))
  call Hloop_A_Q(ntryL,G1H16(79),69,nMB,G2H16(50),n2h16(114))
  call Hloop_QZ_A(ntryL,G1H64(55),wf4(:,8),G1H16(80),ngZd,m3h4x16(:,99),heltab2x64(:,:,115))
  call Hloop_Q_A(ntryL,G1H16(80),69,0,G2H16(51),n2h16(115))
  call Hloop_QZ_A(ntryL,G1H64(56),wf4(:,8),G1H16(82),ngZd,m3h4x16(:,100),heltab2x64(:,:,116))
  call Hloop_Q_A(ntryL,G1H16(82),69,nMB,G2H16(52),n2h16(116))
  call Hloop_AZ_Q(ntryL,G1H64(57),wf4(:,8),G1H16(83),ngZu,m3h4x16(:,101),heltab2x64(:,:,117))
  call Hloop_A_Q(ntryL,G1H16(83),69,0,G2H16(53),n2h16(117))
  call Hloop_AZ_Q(ntryL,G1H64(58),wf4(:,8),G1H16(84),ngZu,m3h4x16(:,102),heltab2x64(:,:,118))
  call Hloop_A_Q(ntryL,G1H16(84),69,nMT,G2H16(54),n2h16(118))
  call Hloop_QZ_A(ntryL,G1H64(59),wf4(:,8),G1H16(85),ngZu,m3h4x16(:,103),heltab2x64(:,:,119))
  call Hloop_Q_A(ntryL,G1H16(85),69,0,G2H16(55),n2h16(119))
  call Hloop_QZ_A(ntryL,G1H64(60),wf4(:,8),G1H16(86),ngZu,m3h4x16(:,104),heltab2x64(:,:,120))
  call Hloop_Q_A(ntryL,G1H16(86),69,nMT,G2H16(56),n2h16(120))
  call Hloop_AZ_Q(ntryL,G1H64(61),wf4(:,8),G1H16(88),ngZd,m3h4x16(:,105),heltab2x64(:,:,121))
  call Hloop_A_Q(ntryL,G1H16(88),69,0,G2H16(57),n2h16(121))
  call Hloop_AZ_Q(ntryL,G1H64(62),wf4(:,8),G1H16(89),ngZd,m3h4x16(:,106),heltab2x64(:,:,122))
  call Hloop_A_Q(ntryL,G1H16(89),69,nMB,G2H16(58),n2h16(122))
  call Hloop_QZ_A(ntryL,G1H64(63),wf4(:,8),G1H16(90),ngZd,m3h4x16(:,107),heltab2x64(:,:,123))
  call Hloop_Q_A(ntryL,G1H16(90),69,0,G2H16(59),n2h16(123))
  call Hloop_QZ_A(ntryL,G1H64(64),wf4(:,8),G1H16(91),ngZd,m3h4x16(:,108),heltab2x64(:,:,124))
  call Hloop_Q_A(ntryL,G1H16(91),69,nMB,G2H16(60),n2h16(124))
  call Hloop_AV_Q(ntryL,G1H64(69),wf4(:,2),G1H16(92),m3h4x16(:,109),heltab2x64(:,:,125))
  call Hloop_A_Q(ntryL,G1H16(92),74,0,G2H16(61),n2h16(125))
  call Hloop_AV_Q(ntryL,G1H64(66),wf4(:,2),G1H16(94),m3h4x16(:,110),heltab2x64(:,:,126))
  call Hloop_A_Q(ntryL,G1H16(94),74,nMT,G2H16(62),n2h16(126))
  call Hloop_QV_A(ntryL,G1H64(71),wf4(:,2),G1H16(95),m3h4x16(:,111),heltab2x64(:,:,127))
  call Hloop_Q_A(ntryL,G1H16(95),74,0,G2H16(63),n2h16(127))
  call Hloop_QV_A(ntryL,G1H64(68),wf4(:,2),G1H16(96),m3h4x16(:,112),heltab2x64(:,:,128))
  call Hloop_Q_A(ntryL,G1H16(96),74,nMT,G2H16(64),n2h16(128))
  call Hloop_AV_Q(ntryL,G1H64(70),wf4(:,2),G1H16(3),m3h4x16(:,113),heltab2x64(:,:,129))
  call Hloop_A_Q(ntryL,G1H16(3),74,nMB,G2H16(65),n2h16(129))
  call Hloop_QV_A(ntryL,G1H64(72),wf4(:,2),G1H16(9),m3h4x16(:,114),heltab2x64(:,:,130))
  call Hloop_Q_A(ntryL,G1H16(9),74,nMB,G2H16(66),n2h16(130))
  call Hloop_AZ_Q(ntryL,G1H64(73),wf4(:,6),G1H16(15),ngZu,m3h4x16(:,115),heltab2x64(:,:,131))
  call Hloop_A_Q(ntryL,G1H16(15),74,0,G2H16(67),n2h16(131))
  call Hloop_AZ_Q(ntryL,G1H64(74),wf4(:,6),G1H16(21),ngZu,m3h4x16(:,116),heltab2x64(:,:,132))
  call Hloop_A_Q(ntryL,G1H16(21),74,nMT,G2H16(68),n2h16(132))
  call Hloop_QZ_A(ntryL,G1H64(75),wf4(:,6),G1H16(27),ngZu,m3h4x16(:,117),heltab2x64(:,:,133))
  call Hloop_Q_A(ntryL,G1H16(27),74,0,G2H16(69),n2h16(133))
  call Hloop_QZ_A(ntryL,G1H64(76),wf4(:,6),G1H16(33),ngZu,m3h4x16(:,118),heltab2x64(:,:,134))
  call Hloop_Q_A(ntryL,G1H16(33),74,nMT,G2H16(70),n2h16(134))
  call Hloop_AZ_Q(ntryL,G1H64(77),wf4(:,6),G1H16(39),ngZd,m3h4x16(:,119),heltab2x64(:,:,135))
  call Hloop_A_Q(ntryL,G1H16(39),74,0,G2H16(71),n2h16(135))
  call Hloop_AZ_Q(ntryL,G1H64(78),wf4(:,6),G1H16(45),ngZd,m3h4x16(:,120),heltab2x64(:,:,136))
  call Hloop_A_Q(ntryL,G1H16(45),74,nMB,G2H16(72),n2h16(136))
  call Hloop_QZ_A(ntryL,G1H64(79),wf4(:,6),G1H16(51),ngZd,m3h4x16(:,121),heltab2x64(:,:,137))
  call Hloop_Q_A(ntryL,G1H16(51),74,0,G2H16(73),n2h16(137))
  call Hloop_QZ_A(ntryL,G1H64(80),wf4(:,6),G1H16(57),ngZd,m3h4x16(:,122),heltab2x64(:,:,138))
  call Hloop_Q_A(ntryL,G1H16(57),74,nMB,G2H16(74),n2h16(138))
  call Hloop_AV_Q(ntryL,G1H64(81),wf4(:,2),G1H16(63),m3h4x16(:,123),heltab2x64(:,:,139))
  call Hloop_A_Q(ntryL,G1H16(63),74,0,G2H16(75),n2h16(139))
  call Hloop_AV_Q(ntryL,G1H64(82),wf4(:,2),G1H16(69),m3h4x16(:,124),heltab2x64(:,:,140))
  call Hloop_A_Q(ntryL,G1H16(69),74,nMT,G2H16(76),n2h16(140))
  call Hloop_QV_A(ntryL,G1H64(83),wf4(:,2),G1H16(75),m3h4x16(:,125),heltab2x64(:,:,141))
  call Hloop_Q_A(ntryL,G1H16(75),74,0,G2H16(77),n2h16(141))
  call Hloop_QV_A(ntryL,G1H64(84),wf4(:,2),G1H16(81),m3h4x16(:,126),heltab2x64(:,:,142))
  call Hloop_Q_A(ntryL,G1H16(81),74,nMT,G2H16(78),n2h16(142))
  call Hloop_AV_Q(ntryL,G1H64(85),wf4(:,2),G1H16(87),m3h4x16(:,127),heltab2x64(:,:,143))
  call Hloop_A_Q(ntryL,G1H16(87),74,0,G2H16(79),n2h16(143))
  call Hloop_AV_Q(ntryL,G1H64(86),wf4(:,2),G1H16(93),m3h4x16(:,128),heltab2x64(:,:,144))
  call Hloop_A_Q(ntryL,G1H16(93),74,nMB,G2H16(80),n2h16(144))
  call Hloop_QV_A(ntryL,G1H64(87),wf4(:,2),G1H16(20),m3h4x16(:,129),heltab2x64(:,:,145))
  call Hloop_Q_A(ntryL,G1H16(20),74,0,G2H16(81),n2h16(145))
  call Hloop_QV_A(ntryL,G1H64(88),wf4(:,2),G1H16(22),m3h4x16(:,130),heltab2x64(:,:,146))
  call Hloop_Q_A(ntryL,G1H16(22),74,nMB,G2H16(82),n2h16(146))
  call Hloop_AZ_Q(ntryL,G1H64(89),wf4(:,6),G1H16(23),ngZu,m3h4x16(:,131),heltab2x64(:,:,147))
  call Hloop_A_Q(ntryL,G1H16(23),74,0,G2H16(83),n2h16(147))
  call Hloop_AZ_Q(ntryL,G1H64(90),wf4(:,6),G1H16(24),ngZu,m3h4x16(:,132),heltab2x64(:,:,148))
  call Hloop_A_Q(ntryL,G1H16(24),74,nMT,G2H16(84),n2h16(148))
  call Hloop_QZ_A(ntryL,G1H64(91),wf4(:,6),G1H16(25),ngZu,m3h4x16(:,133),heltab2x64(:,:,149))
  call Hloop_Q_A(ntryL,G1H16(25),74,0,G2H16(85),n2h16(149))
  call Hloop_QZ_A(ntryL,G1H64(92),wf4(:,6),G1H16(26),ngZu,m3h4x16(:,134),heltab2x64(:,:,150))
  call Hloop_Q_A(ntryL,G1H16(26),74,nMT,G2H16(86),n2h16(150))
  call Hloop_AZ_Q(ntryL,G1H64(93),wf4(:,6),G1H16(28),ngZd,m3h4x16(:,135),heltab2x64(:,:,151))
  call Hloop_A_Q(ntryL,G1H16(28),74,0,G2H16(87),n2h16(151))
  call Hloop_AZ_Q(ntryL,G1H64(94),wf4(:,6),G1H16(29),ngZd,m3h4x16(:,136),heltab2x64(:,:,152))
  call Hloop_A_Q(ntryL,G1H16(29),74,nMB,G2H16(88),n2h16(152))
  call Hloop_QZ_A(ntryL,G1H64(95),wf4(:,6),G1H16(30),ngZd,m3h4x16(:,137),heltab2x64(:,:,153))
  call Hloop_Q_A(ntryL,G1H16(30),74,0,G2H16(89),n2h16(153))
  call Hloop_QZ_A(ntryL,G1H64(96),wf4(:,6),G1H16(31),ngZd,m3h4x16(:,138),heltab2x64(:,:,154))
  call Hloop_Q_A(ntryL,G1H16(31),74,nMB,G2H16(90),n2h16(154))
  call Hloop_AV_Q(ntryL,G1H32(11),wf4(:,2),G1H8(1),m3h4x8(:,81),heltab2x32(:,:,97))
  call Hloop_A_Q(ntryL,G1H8(1),106,0,G2H8(1),n2h8(113))
  call Hloop_AZ_Q(ntryL,G1H32(12),wf4(:,6),G1H8(2),ngZd,m3h4x8(:,82),heltab2x32(:,:,98))
  call Hloop_A_Q(ntryL,G1H8(2),106,0,G2H8(2),n2h8(114))
  call Hloop_AV_Q(ntryL,G1H32(13),wf4(:,2),G1H8(5),m3h4x8(:,83),heltab2x32(:,:,99))
  call Hloop_A_Q(ntryL,G1H8(5),106,0,G2H8(3),n2h8(115))
  call Hloop_AZ_Q(ntryL,G1H32(14),wf4(:,6),G1H8(6),ngZd,m3h4x8(:,84),heltab2x32(:,:,100))
  call Hloop_A_Q(ntryL,G1H8(6),106,0,G2H8(4),n2h8(116))
  call Hloop_AV_Q(ntryL,G1H32(16),wf4(:,1),G1H8(7),m3h4x8(:,85),heltab2x32(:,:,101))
  call Hloop_A_Q(ntryL,G1H8(7),101,0,G2H8(5),n2h8(117))
  call Hloop_AV_Q(ntryL,G1H32(17),wf4(:,1),G1H8(8),m3h4x8(:,86),heltab2x32(:,:,102))
  call Hloop_A_Q(ntryL,G1H8(8),101,0,G2H8(6),n2h8(118))
  call Hloop_AZ_Q(ntryL,G1H32(18),wf4(:,8),G1H8(11),ngZd,m3h4x8(:,87),heltab2x32(:,:,103))
  call Hloop_A_Q(ntryL,G1H8(11),101,0,G2H8(7),n2h8(119))
  call Hloop_AZ_Q(ntryL,G1H32(19),wf4(:,8),G1H8(12),ngZd,m3h4x8(:,88),heltab2x32(:,:,104))
  call Hloop_A_Q(ntryL,G1H8(12),101,0,G2H8(8),n2h8(120))
  call Hloop_VQ_A(ntryL,G1H64(97),wf8(:,10),G1H8(13),m3h8x8(:,1),heltab2x64(:,:,155))
  call Hloop_Q_A(ntryL,G1H8(13),85,0,G2H8(25),n2h8(121))
  call Hloop_VQ_A(ntryL,G1H64(98),wf8(:,10),G1H8(14),m3h8x8(:,2),heltab2x64(:,:,156))
  call Hloop_Q_A(ntryL,G1H8(14),85,0,G2H8(27),n2h8(122))
  call Hloop_VQ_A(ntryL,G1H64(99),wf8(:,12),G1H8(17),m3h8x8(:,3),heltab2x64(:,:,157))
  call Hloop_Q_A(ntryL,G1H8(17),85,0,G2H8(28),n2h8(123))
  call Hloop_VQ_A(ntryL,G1H64(100),wf8(:,12),G1H8(18),m3h8x8(:,4),heltab2x64(:,:,158))
  call Hloop_Q_A(ntryL,G1H8(18),85,0,G2H8(29),n2h8(124))
  call Hloop_AV_Q(ntryL,G1H64(101),wf4(:,2),G1H16(32),m3h4x16(:,139),heltab2x64(:,:,159))
  call Hloop_A_Q(ntryL,G1H16(32),74,0,G2H16(91),n2h16(155))
  call Hloop_AZ_Q(ntryL,G1H64(102),wf4(:,6),G1H16(34),ngZd,m3h4x16(:,140),heltab2x64(:,:,160))
  call Hloop_A_Q(ntryL,G1H16(34),74,0,G2H16(92),n2h16(156))
  call Hloop_AV_Q(ntryL,G1H64(103),wf4(:,2),G1H16(35),m3h4x16(:,141),heltab2x64(:,:,161))
  call Hloop_A_Q(ntryL,G1H16(35),74,0,G2H16(93),n2h16(157))
  call Hloop_AZ_Q(ntryL,G1H64(104),wf4(:,6),G1H16(36),ngZd,m3h4x16(:,142),heltab2x64(:,:,162))
  call Hloop_A_Q(ntryL,G1H16(36),74,0,G2H16(94),n2h16(158))
  call Hloop_QV_A(ntryL,G1H64(105),wf4(:,2),G1H16(37),m3h4x16(:,143),heltab2x64(:,:,163))
  call Hloop_Q_A(ntryL,G1H16(37),74,0,G2H16(95),n2h16(159))
  call Hloop_QZ_A(ntryL,G1H64(106),wf4(:,6),G1H16(38),ngZd,m3h4x16(:,144),heltab2x64(:,:,164))
  call Hloop_Q_A(ntryL,G1H16(38),74,0,G2H16(96),n2h16(160))
  call Hloop_QV_A(ntryL,G1H64(107),wf4(:,2),G1H16(40),m3h4x16(:,145),heltab2x64(:,:,165))
  call Hloop_Q_A(ntryL,G1H16(40),74,0,G2H16(97),n2h16(161))
  call Hloop_QZ_A(ntryL,G1H64(108),wf4(:,6),G1H16(41),ngZd,m3h4x16(:,146),heltab2x64(:,:,166))
  call Hloop_Q_A(ntryL,G1H16(41),74,0,G2H16(98),n2h16(162))
  call Hloop_VQ_A(ntryL,G1H64(109),ex5(:),G1H32(40),m3h2x32(:,17),heltab2x64(:,:,167))
  call Hloop_Q_A(ntryL,G1H32(40),80,0,G2H32(1),n2h32(65))
  call Hloop_VQ_A(ntryL,G1H64(110),ex5(:),G1H32(41),m3h2x32(:,18),heltab2x64(:,:,168))
  call Hloop_Q_A(ntryL,G1H32(41),80,0,G2H32(2),n2h32(66))
  call Hloop_VQ_A(ntryL,G1H64(111),ex5(:),G1H32(42),m3h2x32(:,19),heltab2x64(:,:,169))
  call Hloop_Q_A(ntryL,G1H32(42),80,0,G2H32(3),n2h32(67))
  call Hloop_VQ_A(ntryL,G1H64(112),ex5(:),G1H32(43),m3h2x32(:,20),heltab2x64(:,:,170))
  call Hloop_Q_A(ntryL,G1H32(43),80,0,G2H32(4),n2h32(68))
  call Hloop_QV_A(ntryL,G1H64(113),wf4(:,2),G1H16(42),m3h4x16(:,147),heltab2x64(:,:,171))
  call Hloop_Q_A(ntryL,G1H16(42),74,0,G2H16(99),n2h16(163))
  call Hloop_QZ_A(ntryL,G1H64(114),wf4(:,6),G1H16(43),ngZd,m3h4x16(:,148),heltab2x64(:,:,172))
  call Hloop_Q_A(ntryL,G1H16(43),74,0,G2H16(100),n2h16(164))
  call Hloop_QV_A(ntryL,G1H64(115),wf4(:,2),G1H16(44),m3h4x16(:,149),heltab2x64(:,:,173))
  call Hloop_Q_A(ntryL,G1H16(44),74,0,G2H16(101),n2h16(165))
  call Hloop_QZ_A(ntryL,G1H64(116),wf4(:,6),G1H16(46),ngZd,m3h4x16(:,150),heltab2x64(:,:,174))
  call Hloop_Q_A(ntryL,G1H16(46),74,0,G2H16(102),n2h16(166))
  call Hloop_AV_Q(ntryL,G1H64(117),wf4(:,2),G1H16(47),m3h4x16(:,151),heltab2x64(:,:,175))
  call Hloop_A_Q(ntryL,G1H16(47),74,0,G2H16(103),n2h16(167))
  call Hloop_AZ_Q(ntryL,G1H64(118),wf4(:,6),G1H16(48),ngZd,m3h4x16(:,152),heltab2x64(:,:,176))
  call Hloop_A_Q(ntryL,G1H16(48),74,0,G2H16(104),n2h16(168))
  call Hloop_AV_Q(ntryL,G1H64(119),wf4(:,2),G1H16(49),m3h4x16(:,153),heltab2x64(:,:,177))
  call Hloop_A_Q(ntryL,G1H16(49),74,0,G2H16(105),n2h16(169))
  call Hloop_AZ_Q(ntryL,G1H64(120),wf4(:,6),G1H16(50),ngZd,m3h4x16(:,154),heltab2x64(:,:,178))
  call Hloop_A_Q(ntryL,G1H16(50),74,0,G2H16(106),n2h16(170))
  call Hloop_VQ_A(ntryL,G1H64(121),wf8(:,14),G1H8(19),m3h8x8(:,5),heltab2x64(:,:,179))
  call Hloop_Q_A(ntryL,G1H8(19),90,0,G2H8(31),n2h8(125))
  call Hloop_VQ_A(ntryL,G1H64(122),wf8(:,16),G1H8(20),m3h8x8(:,6),heltab2x64(:,:,180))
  call Hloop_Q_A(ntryL,G1H8(20),90,0,G2H8(32),n2h8(126))
  call Hloop_VQ_A(ntryL,G1H64(123),wf8(:,14),G1H8(23),m3h8x8(:,7),heltab2x64(:,:,181))
  call Hloop_Q_A(ntryL,G1H8(23),90,0,G2H8(37),n2h8(127))
  call Hloop_VQ_A(ntryL,G1H64(124),wf8(:,16),G1H8(24),m3h8x8(:,8),heltab2x64(:,:,182))
  call Hloop_Q_A(ntryL,G1H8(24),90,0,G2H8(39),n2h8(128))
  call Hloop_AV_Q(ntryL,G1H64(125),wf4(:,1),G1H16(52),m3h4x16(:,155),heltab2x64(:,:,183))
  call Hloop_A_Q(ntryL,G1H16(52),69,0,G2H16(107),n2h16(171))
  call Hloop_AV_Q(ntryL,G1H64(126),wf4(:,1),G1H16(53),m3h4x16(:,156),heltab2x64(:,:,184))
  call Hloop_A_Q(ntryL,G1H16(53),69,0,G2H16(108),n2h16(172))
  call Hloop_AZ_Q(ntryL,G1H64(127),wf4(:,8),G1H16(54),ngZd,m3h4x16(:,157),heltab2x64(:,:,185))
  call Hloop_A_Q(ntryL,G1H16(54),69,0,G2H16(109),n2h16(173))
  call Hloop_AZ_Q(ntryL,G1H64(128),wf4(:,8),G1H16(55),ngZd,m3h4x16(:,158),heltab2x64(:,:,186))
  call Hloop_A_Q(ntryL,G1H16(55),69,0,G2H16(110),n2h16(174))
  call Hloop_QV_A(ntryL,G1H64(129),wf4(:,1),G1H16(56),m3h4x16(:,159),heltab2x64(:,:,187))
  call Hloop_Q_A(ntryL,G1H16(56),69,0,G2H16(111),n2h16(175))
  call Hloop_QV_A(ntryL,G1H64(130),wf4(:,1),G1H16(58),m3h4x16(:,160),heltab2x64(:,:,188))
  call Hloop_Q_A(ntryL,G1H16(58),69,0,G2H16(112),n2h16(176))
  call Hloop_QZ_A(ntryL,G1H64(131),wf4(:,8),G1H16(59),ngZd,m3h4x16(:,161),heltab2x64(:,:,189))
  call Hloop_Q_A(ntryL,G1H16(59),69,0,G2H16(113),n2h16(177))
  call Hloop_QZ_A(ntryL,G1H64(132),wf4(:,8),G1H16(60),ngZd,m3h4x16(:,162),heltab2x64(:,:,190))
  call Hloop_Q_A(ntryL,G1H16(60),69,0,G2H16(114),n2h16(178))
  call Hloop_VQ_A(ntryL,G1H64(133),ex5(:),G1H32(44),m3h2x32(:,21),heltab2x64(:,:,191))
  call Hloop_Q_A(ntryL,G1H32(44),80,0,G2H32(5),n2h32(69))
  call Hloop_VQ_A(ntryL,G1H64(134),ex5(:),G1H32(46),m3h2x32(:,22),heltab2x64(:,:,192))
  call Hloop_Q_A(ntryL,G1H32(46),80,0,G2H32(6),n2h32(70))
  call Hloop_VQ_A(ntryL,G1H64(135),ex5(:),G1H32(47),m3h2x32(:,23),heltab2x64(:,:,193))
  call Hloop_Q_A(ntryL,G1H32(47),80,0,G2H32(7),n2h32(71))
  call Hloop_VQ_A(ntryL,G1H64(136),ex5(:),G1H32(48),m3h2x32(:,24),heltab2x64(:,:,194))
  call Hloop_Q_A(ntryL,G1H32(48),80,0,G2H32(8),n2h32(72))
  call Hloop_QV_A(ntryL,G1H64(137),wf4(:,1),G1H16(61),m3h4x16(:,163),heltab2x64(:,:,195))
  call Hloop_Q_A(ntryL,G1H16(61),69,0,G2H16(115),n2h16(179))
  call Hloop_QV_A(ntryL,G1H64(138),wf4(:,1),G1H16(62),m3h4x16(:,164),heltab2x64(:,:,196))
  call Hloop_Q_A(ntryL,G1H16(62),69,0,G2H16(116),n2h16(180))
  call Hloop_QZ_A(ntryL,G1H64(139),wf4(:,8),G1H16(64),ngZd,m3h4x16(:,165),heltab2x64(:,:,197))
  call Hloop_Q_A(ntryL,G1H16(64),69,0,G2H16(117),n2h16(181))
  call Hloop_QZ_A(ntryL,G1H64(140),wf4(:,8),G1H16(65),ngZd,m3h4x16(:,166),heltab2x64(:,:,198))
  call Hloop_Q_A(ntryL,G1H16(65),69,0,G2H16(118),n2h16(182))
  call Hloop_AV_Q(ntryL,G1H64(141),wf4(:,1),G1H16(66),m3h4x16(:,167),heltab2x64(:,:,199))
  call Hloop_A_Q(ntryL,G1H16(66),69,0,G2H16(119),n2h16(183))
  call Hloop_AV_Q(ntryL,G1H64(142),wf4(:,1),G1H16(67),m3h4x16(:,168),heltab2x64(:,:,200))
  call Hloop_A_Q(ntryL,G1H16(67),69,0,G2H16(120),n2h16(184))
  call Hloop_AZ_Q(ntryL,G1H64(143),wf4(:,8),G1H16(68),ngZd,m3h4x16(:,169),heltab2x64(:,:,201))
  call Hloop_A_Q(ntryL,G1H16(68),69,0,G2H16(121),n2h16(185))
  call Hloop_AZ_Q(ntryL,G1H64(144),wf4(:,8),G1H16(70),ngZd,m3h4x16(:,170),heltab2x64(:,:,202))
  call Hloop_A_Q(ntryL,G1H16(70),69,0,G2H16(122),n2h16(186))
  call Hloop_QV_A(ntryL,G1H64(145),wf16(:,13),G1H4(47),m3h16x4(:,1),heltab2x64(:,:,203))
  call Hloop_Q_A(ntryL,G1H4(47),79,0,G2H4(47),n2h4(105))
  call Hloop_QZ_A(ntryL,G1H64(146),wf16(:,159),G1H4(48),ngZd,m3h16x4(:,2),heltab2x64(:,:,204))
  call Hloop_Q_A(ntryL,G1H4(48),79,0,G2H4(48),n2h4(106))
  call Hloop_QV_A(ntryL,G1H64(147),wf16(:,15),G1H4(53),m3h16x4(:,3),heltab2x64(:,:,205))
  call Hloop_Q_A(ntryL,G1H4(53),79,0,G2H4(53),n2h4(107))
  call Hloop_QZ_A(ntryL,G1H64(148),wf16(:,160),G1H4(54),ngZd,m3h16x4(:,4),heltab2x64(:,:,206))
  call Hloop_Q_A(ntryL,G1H4(54),79,0,G2H4(55),n2h4(108))
  call Hloop_AV_Q(ntryL,G1H64(149),wf16(:,13),G1H4(58),m3h16x4(:,5),heltab2x64(:,:,207))
  call Hloop_A_Q(ntryL,G1H4(58),79,0,G2H4(56),n2h4(109))
  call Hloop_AZ_Q(ntryL,G1H64(150),wf16(:,159),G1H4(59),ngZd,m3h16x4(:,6),heltab2x64(:,:,208))
  call Hloop_A_Q(ntryL,G1H4(59),79,0,G2H4(61),n2h4(110))
  call Hloop_AV_Q(ntryL,G1H64(151),wf16(:,15),G1H4(64),m3h16x4(:,7),heltab2x64(:,:,209))
  call Hloop_A_Q(ntryL,G1H4(64),79,0,G2H4(63),n2h4(111))
  call Hloop_AZ_Q(ntryL,G1H64(152),wf16(:,160),G1H4(65),ngZd,m3h16x4(:,8),heltab2x64(:,:,210))
  call Hloop_A_Q(ntryL,G1H4(65),79,0,G2H4(64),n2h4(112))
  call Hloop_VQ_A(ntryL,G1H64(153),ex5(:),G1H32(49),m3h2x32(:,25),heltab2x64(:,:,211))
  call Hloop_Q_A(ntryL,G1H32(49),80,0,G2H32(9),n2h32(73))
  call Hloop_VQ_A(ntryL,G1H64(154),ex5(:),G1H32(50),m3h2x32(:,26),heltab2x64(:,:,212))
  call Hloop_Q_A(ntryL,G1H32(50),80,0,G2H32(10),n2h32(74))
  call Hloop_VQ_A(ntryL,G1H64(155),ex5(:),G1H32(52),m3h2x32(:,27),heltab2x64(:,:,213))
  call Hloop_Q_A(ntryL,G1H32(52),80,0,G2H32(11),n2h32(75))
  call Hloop_VQ_A(ntryL,G1H64(156),ex5(:),G1H32(53),m3h2x32(:,28),heltab2x64(:,:,214))
  call Hloop_Q_A(ntryL,G1H32(53),80,0,G2H32(12),n2h32(76))
  call Hloop_QV_A(ntryL,G1H64(157),wf16(:,17),G1H4(69),m3h16x4(:,9),heltab2x64(:,:,215))
  call Hloop_Q_A(ntryL,G1H4(69),79,0,G2H4(1),n2h4(113))
  call Hloop_QZ_A(ntryL,G1H64(158),wf16(:,161),G1H4(70),ngZd,m3h16x4(:,10),heltab2x64(:,:,216))
  call Hloop_Q_A(ntryL,G1H4(70),79,0,G2H4(4),n2h4(114))
  call Hloop_QV_A(ntryL,G1H64(159),wf16(:,19),G1H4(75),m3h16x4(:,11),heltab2x64(:,:,217))
  call Hloop_Q_A(ntryL,G1H4(75),79,0,G2H4(9),n2h4(115))
  call Hloop_QZ_A(ntryL,G1H64(160),wf16(:,162),G1H4(76),ngZd,m3h16x4(:,12),heltab2x64(:,:,218))
  call Hloop_Q_A(ntryL,G1H4(76),79,0,G2H4(12),n2h4(116))
  call Hloop_AV_Q(ntryL,G1H64(161),wf16(:,17),G1H4(80),m3h16x4(:,13),heltab2x64(:,:,219))
  call Hloop_A_Q(ntryL,G1H4(80),79,0,G2H4(17),n2h4(117))
  call Hloop_AZ_Q(ntryL,G1H64(162),wf16(:,161),G1H4(81),ngZd,m3h16x4(:,14),heltab2x64(:,:,220))
  call Hloop_A_Q(ntryL,G1H4(81),79,0,G2H4(20),n2h4(118))
  call Hloop_AV_Q(ntryL,G1H64(163),wf16(:,19),G1H4(86),m3h16x4(:,15),heltab2x64(:,:,221))
  call Hloop_A_Q(ntryL,G1H4(86),79,0,G2H4(25),n2h4(119))
  call Hloop_AZ_Q(ntryL,G1H64(164),wf16(:,162),G1H4(87),ngZd,m3h16x4(:,16),heltab2x64(:,:,222))
  call Hloop_A_Q(ntryL,G1H4(87),79,0,G2H4(28),n2h4(120))
  call Hloop_VQ_A(ntryL,G1H64(165),ex5(:),G1H32(54),m3h2x32(:,29),heltab2x64(:,:,223))
  call Hloop_Q_A(ntryL,G1H32(54),80,0,G2H32(13),n2h32(77))
  call Hloop_VQ_A(ntryL,G1H64(166),ex5(:),G1H32(55),m3h2x32(:,30),heltab2x64(:,:,224))
  call Hloop_Q_A(ntryL,G1H32(55),80,0,G2H32(14),n2h32(78))
  call Hloop_VQ_A(ntryL,G1H64(167),ex5(:),G1H32(56),m3h2x32(:,31),heltab2x64(:,:,225))
  call Hloop_Q_A(ntryL,G1H32(56),80,0,G2H32(15),n2h32(79))
  call Hloop_VQ_A(ntryL,G1H64(168),ex5(:),G1H32(58),m3h2x32(:,32),heltab2x64(:,:,226))
  call Hloop_Q_A(ntryL,G1H32(58),80,0,G2H32(16),n2h32(80))
  call Hloop_QV_A(ntryL,G1H64(173),wf4(:,12),G1H16(71),m3h4x16(:,171),heltab2x64(:,:,227))
  call Hloop_Q_A(ntryL,G1H16(71),70,0,G2H16(123),n2h16(187))
  call Hloop_QV_A(ntryL,G1H64(170),wf4(:,12),G1H16(72),m3h4x16(:,172),heltab2x64(:,:,228))
  call Hloop_Q_A(ntryL,G1H16(72),70,nMT,G2H16(124),n2h16(188))
  call Hloop_AV_Q(ntryL,G1H64(175),wf4(:,12),G1H16(73),m3h4x16(:,173),heltab2x64(:,:,229))
  call Hloop_A_Q(ntryL,G1H16(73),70,0,G2H16(125),n2h16(189))
  call Hloop_AV_Q(ntryL,G1H64(172),wf4(:,12),G1H16(74),m3h4x16(:,174),heltab2x64(:,:,230))
  call Hloop_A_Q(ntryL,G1H16(74),70,nMT,G2H16(126),n2h16(190))
  call Hloop_QV_A(ntryL,G1H64(174),wf4(:,12),G1H16(76),m3h4x16(:,175),heltab2x64(:,:,231))
  call Hloop_Q_A(ntryL,G1H16(76),70,nMB,G2H16(127),n2h16(191))
  call Hloop_AV_Q(ntryL,G1H64(176),wf4(:,12),G1H16(77),m3h4x16(:,176),heltab2x64(:,:,232))
  call Hloop_A_Q(ntryL,G1H16(77),70,nMB,G2H16(128),n2h16(192))
  call Hloop_QZ_A(ntryL,G1H64(177),wf4(:,14),G1H16(78),ngZu,m3h4x16(:,177),heltab2x64(:,:,233))
  call Hloop_Q_A(ntryL,G1H16(78),70,0,G2H16(129),n2h16(193))
  call Hloop_QZ_A(ntryL,G1H64(178),wf4(:,14),G1H16(79),ngZu,m3h4x16(:,178),heltab2x64(:,:,234))
  call Hloop_Q_A(ntryL,G1H16(79),70,nMT,G2H16(130),n2h16(194))
  call Hloop_AZ_Q(ntryL,G1H64(179),wf4(:,14),G1H16(80),ngZu,m3h4x16(:,179),heltab2x64(:,:,235))
  call Hloop_A_Q(ntryL,G1H16(80),70,0,G2H16(131),n2h16(195))
  call Hloop_AZ_Q(ntryL,G1H64(180),wf4(:,14),G1H16(82),ngZu,m3h4x16(:,180),heltab2x64(:,:,236))
  call Hloop_A_Q(ntryL,G1H16(82),70,nMT,G2H16(132),n2h16(196))
  call Hloop_QZ_A(ntryL,G1H64(181),wf4(:,14),G1H16(83),ngZd,m3h4x16(:,181),heltab2x64(:,:,237))
  call Hloop_Q_A(ntryL,G1H16(83),70,0,G2H16(133),n2h16(197))
  call Hloop_QZ_A(ntryL,G1H64(182),wf4(:,14),G1H16(84),ngZd,m3h4x16(:,182),heltab2x64(:,:,238))
  call Hloop_Q_A(ntryL,G1H16(84),70,nMB,G2H16(134),n2h16(198))
  call Hloop_AZ_Q(ntryL,G1H64(183),wf4(:,14),G1H16(85),ngZd,m3h4x16(:,183),heltab2x64(:,:,239))
  call Hloop_A_Q(ntryL,G1H16(85),70,0,G2H16(135),n2h16(199))
  call Hloop_AZ_Q(ntryL,G1H64(184),wf4(:,14),G1H16(86),ngZd,m3h4x16(:,184),heltab2x64(:,:,240))
  call Hloop_A_Q(ntryL,G1H16(86),70,nMB,G2H16(136),n2h16(200))
  call Hloop_QV_A(ntryL,G1H64(185),wf4(:,12),G1H16(88),m3h4x16(:,185),heltab2x64(:,:,241))
  call Hloop_Q_A(ntryL,G1H16(88),70,0,G2H16(137),n2h16(201))
  call Hloop_QV_A(ntryL,G1H64(186),wf4(:,12),G1H16(89),m3h4x16(:,186),heltab2x64(:,:,242))
  call Hloop_Q_A(ntryL,G1H16(89),70,nMT,G2H16(138),n2h16(202))
  call Hloop_AV_Q(ntryL,G1H64(187),wf4(:,12),G1H16(90),m3h4x16(:,187),heltab2x64(:,:,243))
  call Hloop_A_Q(ntryL,G1H16(90),70,0,G2H16(139),n2h16(203))
  call Hloop_AV_Q(ntryL,G1H64(188),wf4(:,12),G1H16(91),m3h4x16(:,188),heltab2x64(:,:,244))
  call Hloop_A_Q(ntryL,G1H16(91),70,nMT,G2H16(140),n2h16(204))
  call Hloop_QV_A(ntryL,G1H64(189),wf4(:,12),G1H16(92),m3h4x16(:,189),heltab2x64(:,:,245))
  call Hloop_Q_A(ntryL,G1H16(92),70,0,G2H16(141),n2h16(205))
  call Hloop_QV_A(ntryL,G1H64(190),wf4(:,12),G1H16(94),m3h4x16(:,190),heltab2x64(:,:,246))
  call Hloop_Q_A(ntryL,G1H16(94),70,nMB,G2H16(142),n2h16(206))
  call Hloop_AV_Q(ntryL,G1H64(191),wf4(:,12),G1H16(95),m3h4x16(:,191),heltab2x64(:,:,247))
  call Hloop_A_Q(ntryL,G1H16(95),70,0,G2H16(143),n2h16(207))
  call Hloop_AV_Q(ntryL,G1H64(192),wf4(:,12),G1H16(96),m3h4x16(:,192),heltab2x64(:,:,248))
  call Hloop_A_Q(ntryL,G1H16(96),70,nMB,G2H16(144),n2h16(208))
  call Hloop_QZ_A(ntryL,G1H64(193),wf4(:,14),G1H16(3),ngZu,m3h4x16(:,193),heltab2x64(:,:,249))
  call Hloop_Q_A(ntryL,G1H16(3),70,0,G2H16(145),n2h16(209))
  call Hloop_QZ_A(ntryL,G1H64(194),wf4(:,14),G1H16(9),ngZu,m3h4x16(:,194),heltab2x64(:,:,250))
  call Hloop_Q_A(ntryL,G1H16(9),70,nMT,G2H16(146),n2h16(210))
  call Hloop_AZ_Q(ntryL,G1H64(195),wf4(:,14),G1H16(15),ngZu,m3h4x16(:,195),heltab2x64(:,:,251))
  call Hloop_A_Q(ntryL,G1H16(15),70,0,G2H16(147),n2h16(211))
  call Hloop_AZ_Q(ntryL,G1H64(196),wf4(:,14),G1H16(21),ngZu,m3h4x16(:,196),heltab2x64(:,:,252))
  call Hloop_A_Q(ntryL,G1H16(21),70,nMT,G2H16(148),n2h16(212))
  call Hloop_QZ_A(ntryL,G1H64(197),wf4(:,14),G1H16(27),ngZd,m3h4x16(:,197),heltab2x64(:,:,253))
  call Hloop_Q_A(ntryL,G1H16(27),70,0,G2H16(149),n2h16(213))
  call Hloop_QZ_A(ntryL,G1H64(198),wf4(:,14),G1H16(33),ngZd,m3h4x16(:,198),heltab2x64(:,:,254))
  call Hloop_Q_A(ntryL,G1H16(33),70,nMB,G2H16(150),n2h16(214))
  call Hloop_AZ_Q(ntryL,G1H64(199),wf4(:,14),G1H16(39),ngZd,m3h4x16(:,199),heltab2x64(:,:,255))
  call Hloop_A_Q(ntryL,G1H16(39),70,0,G2H16(151),n2h16(215))
  call Hloop_AZ_Q(ntryL,G1H64(200),wf4(:,14),G1H16(45),ngZd,m3h4x16(:,200),heltab2x64(:,:,256))
  call Hloop_A_Q(ntryL,G1H16(45),70,nMB,G2H16(152),n2h16(216))
  call Hloop_AV_Q(ntryL,G1H64(205),wf4(:,11),G1H16(51),m3h4x16(:,201),heltab2x64(:,:,257))
  call Hloop_A_Q(ntryL,G1H16(51),73,0,G2H16(153),n2h16(217))
  call Hloop_AV_Q(ntryL,G1H64(202),wf4(:,11),G1H16(57),m3h4x16(:,202),heltab2x64(:,:,258))
  call Hloop_A_Q(ntryL,G1H16(57),73,nMT,G2H16(154),n2h16(218))
  call Hloop_QV_A(ntryL,G1H64(207),wf4(:,11),G1H16(63),m3h4x16(:,203),heltab2x64(:,:,259))
  call Hloop_Q_A(ntryL,G1H16(63),73,0,G2H16(155),n2h16(219))
  call Hloop_QV_A(ntryL,G1H64(204),wf4(:,11),G1H16(69),m3h4x16(:,204),heltab2x64(:,:,260))
  call Hloop_Q_A(ntryL,G1H16(69),73,nMT,G2H16(156),n2h16(220))
  call Hloop_AV_Q(ntryL,G1H64(206),wf4(:,11),G1H16(75),m3h4x16(:,205),heltab2x64(:,:,261))
  call Hloop_A_Q(ntryL,G1H16(75),73,nMB,G2H16(157),n2h16(221))
  call Hloop_QV_A(ntryL,G1H64(208),wf4(:,11),G1H16(81),m3h4x16(:,206),heltab2x64(:,:,262))
  call Hloop_Q_A(ntryL,G1H16(81),73,nMB,G2H16(158),n2h16(222))
  call Hloop_AV_Q(ntryL,G1H64(209),wf4(:,11),G1H16(87),m3h4x16(:,207),heltab2x64(:,:,263))
  call Hloop_A_Q(ntryL,G1H16(87),73,0,G2H16(159),n2h16(223))
  call Hloop_AV_Q(ntryL,G1H64(210),wf4(:,11),G1H16(93),m3h4x16(:,208),heltab2x64(:,:,264))
  call Hloop_A_Q(ntryL,G1H16(93),73,nMT,G2H16(160),n2h16(224))
  call Hloop_QV_A(ntryL,G1H64(211),wf4(:,11),G1H16(20),m3h4x16(:,209),heltab2x64(:,:,265))
  call Hloop_Q_A(ntryL,G1H16(20),73,0,G2H16(161),n2h16(225))
  call Hloop_QV_A(ntryL,G1H64(212),wf4(:,11),G1H16(22),m3h4x16(:,210),heltab2x64(:,:,266))
  call Hloop_Q_A(ntryL,G1H16(22),73,nMT,G2H16(162),n2h16(226))
  call Hloop_AV_Q(ntryL,G1H64(213),wf4(:,11),G1H16(23),m3h4x16(:,211),heltab2x64(:,:,267))
  call Hloop_A_Q(ntryL,G1H16(23),73,0,G2H16(163),n2h16(227))
  call Hloop_AV_Q(ntryL,G1H64(214),wf4(:,11),G1H16(24),m3h4x16(:,212),heltab2x64(:,:,268))
  call Hloop_A_Q(ntryL,G1H16(24),73,nMB,G2H16(164),n2h16(228))
  call Hloop_QV_A(ntryL,G1H64(215),wf4(:,11),G1H16(25),m3h4x16(:,213),heltab2x64(:,:,269))
  call Hloop_Q_A(ntryL,G1H16(25),73,0,G2H16(165),n2h16(229))
  call Hloop_QV_A(ntryL,G1H64(216),wf4(:,11),G1H16(26),m3h4x16(:,214),heltab2x64(:,:,270))
  call Hloop_Q_A(ntryL,G1H16(26),73,nMB,G2H16(166),n2h16(230))
  call Hloop_AZ_Q(ntryL,G1H64(217),wf4(:,16),G1H16(28),ngZu,m3h4x16(:,215),heltab2x64(:,:,271))
  call Hloop_A_Q(ntryL,G1H16(28),73,0,G2H16(167),n2h16(231))
  call Hloop_AZ_Q(ntryL,G1H64(218),wf4(:,16),G1H16(29),ngZu,m3h4x16(:,216),heltab2x64(:,:,272))
  call Hloop_A_Q(ntryL,G1H16(29),73,nMT,G2H16(168),n2h16(232))
  call Hloop_QZ_A(ntryL,G1H64(219),wf4(:,16),G1H16(30),ngZu,m3h4x16(:,217),heltab2x64(:,:,273))
  call Hloop_Q_A(ntryL,G1H16(30),73,0,G2H16(169),n2h16(233))
  call Hloop_QZ_A(ntryL,G1H64(220),wf4(:,16),G1H16(31),ngZu,m3h4x16(:,218),heltab2x64(:,:,274))
  call Hloop_Q_A(ntryL,G1H16(31),73,nMT,G2H16(170),n2h16(234))
  call Hloop_AZ_Q(ntryL,G1H64(221),wf4(:,16),G1H16(32),ngZd,m3h4x16(:,219),heltab2x64(:,:,275))
  call Hloop_A_Q(ntryL,G1H16(32),73,0,G2H16(171),n2h16(235))
  call Hloop_AZ_Q(ntryL,G1H64(222),wf4(:,16),G1H16(34),ngZd,m3h4x16(:,220),heltab2x64(:,:,276))
  call Hloop_A_Q(ntryL,G1H16(34),73,nMB,G2H16(172),n2h16(236))
  call Hloop_QZ_A(ntryL,G1H64(223),wf4(:,16),G1H16(35),ngZd,m3h4x16(:,221),heltab2x64(:,:,277))
  call Hloop_Q_A(ntryL,G1H16(35),73,0,G2H16(173),n2h16(237))
  call Hloop_QZ_A(ntryL,G1H64(224),wf4(:,16),G1H16(36),ngZd,m3h4x16(:,222),heltab2x64(:,:,278))
  call Hloop_Q_A(ntryL,G1H16(36),73,nMB,G2H16(174),n2h16(238))
  call Hloop_AZ_Q(ntryL,G1H64(225),wf4(:,16),G1H16(37),ngZu,m3h4x16(:,223),heltab2x64(:,:,279))
  call Hloop_A_Q(ntryL,G1H16(37),73,0,G2H16(175),n2h16(239))
  call Hloop_AZ_Q(ntryL,G1H64(226),wf4(:,16),G1H16(38),ngZu,m3h4x16(:,224),heltab2x64(:,:,280))
  call Hloop_A_Q(ntryL,G1H16(38),73,nMT,G2H16(176),n2h16(240))
  call Hloop_QZ_A(ntryL,G1H64(227),wf4(:,16),G1H16(40),ngZu,m3h4x16(:,225),heltab2x64(:,:,281))
  call Hloop_Q_A(ntryL,G1H16(40),73,0,G2H16(177),n2h16(241))
  call Hloop_QZ_A(ntryL,G1H64(228),wf4(:,16),G1H16(41),ngZu,m3h4x16(:,226),heltab2x64(:,:,282))
  call Hloop_Q_A(ntryL,G1H16(41),73,nMT,G2H16(178),n2h16(242))
  call Hloop_AZ_Q(ntryL,G1H64(229),wf4(:,16),G1H16(42),ngZd,m3h4x16(:,227),heltab2x64(:,:,283))
  call Hloop_A_Q(ntryL,G1H16(42),73,0,G2H16(179),n2h16(243))
  call Hloop_AZ_Q(ntryL,G1H64(230),wf4(:,16),G1H16(43),ngZd,m3h4x16(:,228),heltab2x64(:,:,284))
  call Hloop_A_Q(ntryL,G1H16(43),73,nMB,G2H16(180),n2h16(244))
  call Hloop_QZ_A(ntryL,G1H64(231),wf4(:,16),G1H16(44),ngZd,m3h4x16(:,229),heltab2x64(:,:,285))
  call Hloop_Q_A(ntryL,G1H16(44),73,0,G2H16(181),n2h16(245))
  call Hloop_QZ_A(ntryL,G1H64(232),wf4(:,16),G1H16(46),ngZd,m3h4x16(:,230),heltab2x64(:,:,286))
  call Hloop_Q_A(ntryL,G1H16(46),73,nMB,G2H16(182),n2h16(246))
  call Hloop_AV_Q(ntryL,G1H64(237),wf4(:,12),G1H16(47),m3h4x16(:,231),heltab2x64(:,:,287))
  call Hloop_A_Q(ntryL,G1H16(47),70,0,G2H16(183),n2h16(247))
  call Hloop_AV_Q(ntryL,G1H64(234),wf4(:,12),G1H16(48),m3h4x16(:,232),heltab2x64(:,:,288))
  call Hloop_A_Q(ntryL,G1H16(48),70,nMT,G2H16(184),n2h16(248))
  call Hloop_QV_A(ntryL,G1H64(239),wf4(:,12),G1H16(49),m3h4x16(:,233),heltab2x64(:,:,289))
  call Hloop_Q_A(ntryL,G1H16(49),70,0,G2H16(185),n2h16(249))
  call Hloop_QV_A(ntryL,G1H64(236),wf4(:,12),G1H16(50),m3h4x16(:,234),heltab2x64(:,:,290))
  call Hloop_Q_A(ntryL,G1H16(50),70,nMT,G2H16(186),n2h16(250))
  call Hloop_AV_Q(ntryL,G1H64(238),wf4(:,12),G1H16(52),m3h4x16(:,235),heltab2x64(:,:,291))
  call Hloop_A_Q(ntryL,G1H16(52),70,nMB,G2H16(187),n2h16(251))
  call Hloop_QV_A(ntryL,G1H64(240),wf4(:,12),G1H16(53),m3h4x16(:,236),heltab2x64(:,:,292))
  call Hloop_Q_A(ntryL,G1H16(53),70,nMB,G2H16(188),n2h16(252))
  call Hloop_AZ_Q(ntryL,G1H64(241),wf4(:,14),G1H16(54),ngZu,m3h4x16(:,237),heltab2x64(:,:,293))
  call Hloop_A_Q(ntryL,G1H16(54),70,0,G2H16(189),n2h16(253))
  call Hloop_AZ_Q(ntryL,G1H64(242),wf4(:,14),G1H16(55),ngZu,m3h4x16(:,238),heltab2x64(:,:,294))
  call Hloop_A_Q(ntryL,G1H16(55),70,nMT,G2H16(190),n2h16(254))
  call Hloop_QZ_A(ntryL,G1H64(243),wf4(:,14),G1H16(56),ngZu,m3h4x16(:,239),heltab2x64(:,:,295))
  call Hloop_Q_A(ntryL,G1H16(56),70,0,G2H16(191),n2h16(255))
  call Hloop_QZ_A(ntryL,G1H64(244),wf4(:,14),G1H16(58),ngZu,m3h4x16(:,240),heltab2x64(:,:,296))
  call Hloop_Q_A(ntryL,G1H16(58),70,nMT,G2H16(192),n2h16(256))
  call Hloop_AZ_Q(ntryL,G1H64(245),wf4(:,14),G1H16(59),ngZd,m3h4x16(:,241),heltab2x64(:,:,297))
  call Hloop_A_Q(ntryL,G1H16(59),70,0,G2H16(193),n2h16(257))
  call Hloop_AZ_Q(ntryL,G1H64(246),wf4(:,14),G1H16(60),ngZd,m3h4x16(:,242),heltab2x64(:,:,298))
  call Hloop_A_Q(ntryL,G1H16(60),70,nMB,G2H16(194),n2h16(258))
  call Hloop_QZ_A(ntryL,G1H64(247),wf4(:,14),G1H16(61),ngZd,m3h4x16(:,243),heltab2x64(:,:,299))
  call Hloop_Q_A(ntryL,G1H16(61),70,0,G2H16(195),n2h16(259))
  call Hloop_QZ_A(ntryL,G1H64(248),wf4(:,14),G1H16(62),ngZd,m3h4x16(:,244),heltab2x64(:,:,300))
  call Hloop_Q_A(ntryL,G1H16(62),70,nMB,G2H16(196),n2h16(260))
  call Hloop_AV_Q(ntryL,G1H64(249),wf4(:,12),G1H16(64),m3h4x16(:,245),heltab2x64(:,:,301))
  call Hloop_A_Q(ntryL,G1H16(64),70,0,G2H16(197),n2h16(261))
  call Hloop_AV_Q(ntryL,G1H64(250),wf4(:,12),G1H16(65),m3h4x16(:,246),heltab2x64(:,:,302))
  call Hloop_A_Q(ntryL,G1H16(65),70,nMT,G2H16(198),n2h16(262))
  call Hloop_QV_A(ntryL,G1H64(251),wf4(:,12),G1H16(66),m3h4x16(:,247),heltab2x64(:,:,303))
  call Hloop_Q_A(ntryL,G1H16(66),70,0,G2H16(199),n2h16(263))
  call Hloop_QV_A(ntryL,G1H64(252),wf4(:,12),G1H16(67),m3h4x16(:,248),heltab2x64(:,:,304))
  call Hloop_Q_A(ntryL,G1H16(67),70,nMT,G2H16(200),n2h16(264))
  call Hloop_AV_Q(ntryL,G1H64(253),wf4(:,12),G1H16(68),m3h4x16(:,249),heltab2x64(:,:,305))
  call Hloop_A_Q(ntryL,G1H16(68),70,0,G2H16(201),n2h16(265))
  call Hloop_AV_Q(ntryL,G1H64(254),wf4(:,12),G1H16(70),m3h4x16(:,250),heltab2x64(:,:,306))
  call Hloop_A_Q(ntryL,G1H16(70),70,nMB,G2H16(202),n2h16(266))
  call Hloop_QV_A(ntryL,G1H64(255),wf4(:,12),G1H16(71),m3h4x16(:,251),heltab2x64(:,:,307))
  call Hloop_Q_A(ntryL,G1H16(71),70,0,G2H16(203),n2h16(267))
  call Hloop_QV_A(ntryL,G1H64(256),wf4(:,12),G1H16(72),m3h4x16(:,252),heltab2x64(:,:,308))
  call Hloop_Q_A(ntryL,G1H16(72),70,nMB,G2H16(204),n2h16(268))
  call Hloop_AZ_Q(ntryL,G1H64(257),wf4(:,14),G1H16(73),ngZu,m3h4x16(:,253),heltab2x64(:,:,309))
  call Hloop_A_Q(ntryL,G1H16(73),70,0,G2H16(205),n2h16(269))
  call Hloop_AZ_Q(ntryL,G1H64(258),wf4(:,14),G1H16(74),ngZu,m3h4x16(:,254),heltab2x64(:,:,310))
  call Hloop_A_Q(ntryL,G1H16(74),70,nMT,G2H16(206),n2h16(270))
  call Hloop_QZ_A(ntryL,G1H64(259),wf4(:,14),G1H16(76),ngZu,m3h4x16(:,255),heltab2x64(:,:,311))
  call Hloop_Q_A(ntryL,G1H16(76),70,0,G2H16(207),n2h16(271))
  call Hloop_QZ_A(ntryL,G1H64(260),wf4(:,14),G1H16(77),ngZu,m3h4x16(:,256),heltab2x64(:,:,312))
  call Hloop_Q_A(ntryL,G1H16(77),70,nMT,G2H16(208),n2h16(272))
  call Hloop_AZ_Q(ntryL,G1H64(261),wf4(:,14),G1H16(78),ngZd,m3h4x16(:,257),heltab2x64(:,:,313))
  call Hloop_A_Q(ntryL,G1H16(78),70,0,G2H16(209),n2h16(273))
  call Hloop_AZ_Q(ntryL,G1H64(262),wf4(:,14),G1H16(79),ngZd,m3h4x16(:,258),heltab2x64(:,:,314))
  call Hloop_A_Q(ntryL,G1H16(79),70,nMB,G2H16(210),n2h16(274))
  call Hloop_QZ_A(ntryL,G1H64(263),wf4(:,14),G1H16(80),ngZd,m3h4x16(:,259),heltab2x64(:,:,315))
  call Hloop_Q_A(ntryL,G1H16(80),70,0,G2H16(211),n2h16(275))
  call Hloop_QZ_A(ntryL,G1H64(264),wf4(:,14),G1H16(82),ngZd,m3h4x16(:,260),heltab2x64(:,:,316))
  call Hloop_Q_A(ntryL,G1H16(82),70,nMB,G2H16(212),n2h16(276))
  call Hloop_AV_Q(ntryL,G1H32(30),wf4(:,12),G1H8(25),m3h4x8(:,89),heltab2x32(:,:,105))
  call Hloop_A_Q(ntryL,G1H8(25),102,0,G2H8(40),n2h8(129))
  call Hloop_AZ_Q(ntryL,G1H32(31),wf4(:,14),G1H8(26),ngZd,m3h4x8(:,90),heltab2x32(:,:,106))
  call Hloop_A_Q(ntryL,G1H8(26),102,0,G2H8(45),n2h8(130))
  call Hloop_AV_Q(ntryL,G1H32(32),wf4(:,12),G1H8(29),m3h4x8(:,91),heltab2x32(:,:,107))
  call Hloop_A_Q(ntryL,G1H8(29),102,0,G2H8(47),n2h8(131))
  call Hloop_AZ_Q(ntryL,G1H32(34),wf4(:,14),G1H8(30),ngZd,m3h4x8(:,92),heltab2x32(:,:,108))
  call Hloop_A_Q(ntryL,G1H8(30),102,0,G2H8(48),n2h8(132))
  call Hloop_AV_Q(ntryL,G1H32(35),wf4(:,11),G1H8(31),m3h4x8(:,93),heltab2x32(:,:,109))
  call Hloop_A_Q(ntryL,G1H8(31),105,0,G2H8(65),n2h8(133))
  call Hloop_AV_Q(ntryL,G1H32(36),wf4(:,11),G1H8(32),m3h4x8(:,94),heltab2x32(:,:,110))
  call Hloop_A_Q(ntryL,G1H8(32),105,0,G2H8(67),n2h8(134))
  call Hloop_AZ_Q(ntryL,G1H32(37),wf4(:,16),G1H8(35),ngZd,m3h4x8(:,95),heltab2x32(:,:,111))
  call Hloop_A_Q(ntryL,G1H8(35),105,0,G2H8(68),n2h8(135))
  call Hloop_AZ_Q(ntryL,G1H32(38),wf4(:,16),G1H8(36),ngZd,m3h4x8(:,96),heltab2x32(:,:,112))
  call Hloop_A_Q(ntryL,G1H8(36),105,0,G2H8(69),n2h8(136))
  call Hloop_VQ_A(ntryL,G1H64(265),wf8(:,40),G1H8(37),m3h8x8(:,9),heltab2x64(:,:,317))
  call Hloop_Q_A(ntryL,G1H8(37),89,0,G2H8(71),n2h8(137))
  call Hloop_VQ_A(ntryL,G1H64(266),wf8(:,40),G1H8(38),m3h8x8(:,10),heltab2x64(:,:,318))
  call Hloop_Q_A(ntryL,G1H8(38),89,0,G2H8(72),n2h8(138))
  call Hloop_VQ_A(ntryL,G1H64(267),wf8(:,42),G1H8(41),m3h8x8(:,11),heltab2x64(:,:,319))
  call Hloop_Q_A(ntryL,G1H8(41),89,0,G2H8(77),n2h8(139))
  call Hloop_VQ_A(ntryL,G1H64(268),wf8(:,42),G1H8(42),m3h8x8(:,12),heltab2x64(:,:,320))
  call Hloop_Q_A(ntryL,G1H8(42),89,0,G2H8(79),n2h8(140))
  call Hloop_AV_Q(ntryL,G1H64(269),wf4(:,12),G1H16(83),m3h4x16(:,261),heltab2x64(:,:,321))
  call Hloop_A_Q(ntryL,G1H16(83),70,0,G2H16(213),n2h16(277))
  call Hloop_AZ_Q(ntryL,G1H64(270),wf4(:,14),G1H16(84),ngZd,m3h4x16(:,262),heltab2x64(:,:,322))
  call Hloop_A_Q(ntryL,G1H16(84),70,0,G2H16(214),n2h16(278))
  call Hloop_AV_Q(ntryL,G1H64(271),wf4(:,12),G1H16(85),m3h4x16(:,263),heltab2x64(:,:,323))
  call Hloop_A_Q(ntryL,G1H16(85),70,0,G2H16(215),n2h16(279))
  call Hloop_AZ_Q(ntryL,G1H64(272),wf4(:,14),G1H16(86),ngZd,m3h4x16(:,264),heltab2x64(:,:,324))
  call Hloop_A_Q(ntryL,G1H16(86),70,0,G2H16(216),n2h16(280))
  call Hloop_QV_A(ntryL,G1H64(273),wf4(:,12),G1H16(88),m3h4x16(:,265),heltab2x64(:,:,325))
  call Hloop_Q_A(ntryL,G1H16(88),70,0,G2H16(217),n2h16(281))
  call Hloop_QZ_A(ntryL,G1H64(274),wf4(:,14),G1H16(89),ngZd,m3h4x16(:,266),heltab2x64(:,:,326))
  call Hloop_Q_A(ntryL,G1H16(89),70,0,G2H16(218),n2h16(282))
  call Hloop_QV_A(ntryL,G1H64(275),wf4(:,12),G1H16(90),m3h4x16(:,267),heltab2x64(:,:,327))
  call Hloop_Q_A(ntryL,G1H16(90),70,0,G2H16(219),n2h16(283))
  call Hloop_QZ_A(ntryL,G1H64(276),wf4(:,14),G1H16(91),ngZd,m3h4x16(:,268),heltab2x64(:,:,328))
  call Hloop_Q_A(ntryL,G1H16(91),70,0,G2H16(220),n2h16(284))
  call Hloop_VQ_A(ntryL,G1H64(277),ex5(:),G1H32(59),m3h2x32(:,33),heltab2x64(:,:,329))
  call Hloop_Q_A(ntryL,G1H32(59),80,0,G2H32(17),n2h32(81))
  call Hloop_VQ_A(ntryL,G1H64(278),ex5(:),G1H32(60),m3h2x32(:,34),heltab2x64(:,:,330))
  call Hloop_Q_A(ntryL,G1H32(60),80,0,G2H32(18),n2h32(82))
  call Hloop_VQ_A(ntryL,G1H64(279),ex5(:),G1H32(61),m3h2x32(:,35),heltab2x64(:,:,331))
  call Hloop_Q_A(ntryL,G1H32(61),80,0,G2H32(19),n2h32(83))
  call Hloop_VQ_A(ntryL,G1H64(280),ex5(:),G1H32(62),m3h2x32(:,36),heltab2x64(:,:,332))
  call Hloop_Q_A(ntryL,G1H32(62),80,0,G2H32(20),n2h32(84))
  call Hloop_QV_A(ntryL,G1H64(281),wf4(:,12),G1H16(92),m3h4x16(:,269),heltab2x64(:,:,333))
  call Hloop_Q_A(ntryL,G1H16(92),70,0,G2H16(221),n2h16(285))
  call Hloop_QZ_A(ntryL,G1H64(282),wf4(:,14),G1H16(94),ngZd,m3h4x16(:,270),heltab2x64(:,:,334))
  call Hloop_Q_A(ntryL,G1H16(94),70,0,G2H16(222),n2h16(286))
  call Hloop_QV_A(ntryL,G1H64(283),wf4(:,12),G1H16(95),m3h4x16(:,271),heltab2x64(:,:,335))
  call Hloop_Q_A(ntryL,G1H16(95),70,0,G2H16(223),n2h16(287))
  call Hloop_QZ_A(ntryL,G1H64(284),wf4(:,14),G1H16(96),ngZd,m3h4x16(:,272),heltab2x64(:,:,336))
  call Hloop_Q_A(ntryL,G1H16(96),70,0,G2H16(224),n2h16(288))
  call Hloop_AV_Q(ntryL,G1H64(285),wf4(:,12),G1H16(3),m3h4x16(:,273),heltab2x64(:,:,337))
  call Hloop_A_Q(ntryL,G1H16(3),70,0,G2H16(225),n2h16(289))
  call Hloop_AZ_Q(ntryL,G1H64(286),wf4(:,14),G1H16(9),ngZd,m3h4x16(:,274),heltab2x64(:,:,338))
  call Hloop_A_Q(ntryL,G1H16(9),70,0,G2H16(226),n2h16(290))
  call Hloop_AV_Q(ntryL,G1H64(287),wf4(:,12),G1H16(15),m3h4x16(:,275),heltab2x64(:,:,339))
  call Hloop_A_Q(ntryL,G1H16(15),70,0,G2H16(227),n2h16(291))
  call Hloop_AZ_Q(ntryL,G1H64(288),wf4(:,14),G1H16(21),ngZd,m3h4x16(:,276),heltab2x64(:,:,340))
  call Hloop_A_Q(ntryL,G1H16(21),70,0,G2H16(228),n2h16(292))
  call Hloop_VQ_A(ntryL,G1H64(289),wf8(:,44),G1H8(43),m3h8x8(:,13),heltab2x64(:,:,341))
  call Hloop_Q_A(ntryL,G1H8(43),86,0,G2H8(80),n2h8(141))
  call Hloop_VQ_A(ntryL,G1H64(290),wf8(:,46),G1H8(44),m3h8x8(:,14),heltab2x64(:,:,342))
  call Hloop_Q_A(ntryL,G1H8(44),86,0,G2H8(85),n2h8(142))
  call Hloop_VQ_A(ntryL,G1H64(291),wf8(:,44),G1H8(47),m3h8x8(:,15),heltab2x64(:,:,343))
  call Hloop_Q_A(ntryL,G1H8(47),86,0,G2H8(87),n2h8(143))
  call Hloop_VQ_A(ntryL,G1H64(292),wf8(:,46),G1H8(48),m3h8x8(:,16),heltab2x64(:,:,344))
  call Hloop_Q_A(ntryL,G1H8(48),86,0,G2H8(88),n2h8(144))
  call Hloop_AV_Q(ntryL,G1H64(293),wf4(:,11),G1H16(27),m3h4x16(:,277),heltab2x64(:,:,345))
  call Hloop_A_Q(ntryL,G1H16(27),73,0,G2H16(229),n2h16(293))
  call Hloop_AV_Q(ntryL,G1H64(294),wf4(:,11),G1H16(33),m3h4x16(:,278),heltab2x64(:,:,346))
  call Hloop_A_Q(ntryL,G1H16(33),73,0,G2H16(230),n2h16(294))
  call Hloop_AZ_Q(ntryL,G1H64(295),wf4(:,16),G1H16(39),ngZd,m3h4x16(:,279),heltab2x64(:,:,347))
  call Hloop_A_Q(ntryL,G1H16(39),73,0,G2H16(231),n2h16(295))
  call Hloop_AZ_Q(ntryL,G1H64(296),wf4(:,16),G1H16(45),ngZd,m3h4x16(:,280),heltab2x64(:,:,348))
  call Hloop_A_Q(ntryL,G1H16(45),73,0,G2H16(232),n2h16(296))
  call Hloop_QV_A(ntryL,G1H64(297),wf4(:,11),G1H16(51),m3h4x16(:,281),heltab2x64(:,:,349))
  call Hloop_Q_A(ntryL,G1H16(51),73,0,G2H16(233),n2h16(297))
  call Hloop_QV_A(ntryL,G1H64(298),wf4(:,11),G1H16(57),m3h4x16(:,282),heltab2x64(:,:,350))
  call Hloop_Q_A(ntryL,G1H16(57),73,0,G2H16(234),n2h16(298))
  call Hloop_QZ_A(ntryL,G1H64(299),wf4(:,16),G1H16(63),ngZd,m3h4x16(:,283),heltab2x64(:,:,351))
  call Hloop_Q_A(ntryL,G1H16(63),73,0,G2H16(235),n2h16(299))
  call Hloop_QZ_A(ntryL,G1H64(300),wf4(:,16),G1H16(69),ngZd,m3h4x16(:,284),heltab2x64(:,:,352))
  call Hloop_Q_A(ntryL,G1H16(69),73,0,G2H16(236),n2h16(300))
  call Hloop_VQ_A(ntryL,G1H64(301),ex5(:),G1H32(64),m3h2x32(:,37),heltab2x64(:,:,353))
  call Hloop_Q_A(ntryL,G1H32(64),80,0,G2H32(21),n2h32(85))
  call Hloop_VQ_A(ntryL,G1H64(302),ex5(:),G1H32(65),m3h2x32(:,38),heltab2x64(:,:,354))
  call Hloop_Q_A(ntryL,G1H32(65),80,0,G2H32(22),n2h32(86))
  call Hloop_VQ_A(ntryL,G1H64(303),ex5(:),G1H32(66),m3h2x32(:,39),heltab2x64(:,:,355))
  call Hloop_Q_A(ntryL,G1H32(66),80,0,G2H32(23),n2h32(87))
  call Hloop_VQ_A(ntryL,G1H64(304),ex5(:),G1H32(67),m3h2x32(:,40),heltab2x64(:,:,356))
  call Hloop_Q_A(ntryL,G1H32(67),80,0,G2H32(24),n2h32(88))
  call Hloop_QV_A(ntryL,G1H64(305),wf4(:,11),G1H16(75),m3h4x16(:,285),heltab2x64(:,:,357))
  call Hloop_Q_A(ntryL,G1H16(75),73,0,G2H16(237),n2h16(301))
  call Hloop_QV_A(ntryL,G1H64(306),wf4(:,11),G1H16(81),m3h4x16(:,286),heltab2x64(:,:,358))
  call Hloop_Q_A(ntryL,G1H16(81),73,0,G2H16(238),n2h16(302))
  call Hloop_QZ_A(ntryL,G1H64(307),wf4(:,16),G1H16(87),ngZd,m3h4x16(:,287),heltab2x64(:,:,359))
  call Hloop_Q_A(ntryL,G1H16(87),73,0,G2H16(239),n2h16(303))
  call Hloop_QZ_A(ntryL,G1H64(308),wf4(:,16),G1H16(93),ngZd,m3h4x16(:,288),heltab2x64(:,:,360))
  call Hloop_Q_A(ntryL,G1H16(93),73,0,G2H16(240),n2h16(304))
  call Hloop_AV_Q(ntryL,G1H64(309),wf4(:,11),G1H16(20),m3h4x16(:,289),heltab2x64(:,:,361))
  call Hloop_A_Q(ntryL,G1H16(20),73,0,G2H16(241),n2h16(305))
  call Hloop_AV_Q(ntryL,G1H64(310),wf4(:,11),G1H16(22),m3h4x16(:,290),heltab2x64(:,:,362))
  call Hloop_A_Q(ntryL,G1H16(22),73,0,G2H16(242),n2h16(306))
  call Hloop_AZ_Q(ntryL,G1H64(311),wf4(:,16),G1H16(23),ngZd,m3h4x16(:,291),heltab2x64(:,:,363))
  call Hloop_A_Q(ntryL,G1H16(23),73,0,G2H16(243),n2h16(307))
  call Hloop_AZ_Q(ntryL,G1H64(312),wf4(:,16),G1H16(24),ngZd,m3h4x16(:,292),heltab2x64(:,:,364))
  call Hloop_A_Q(ntryL,G1H16(24),73,0,G2H16(244),n2h16(308))
  call Hloop_QV_A(ntryL,G1H64(313),wf16(:,33),G1H4(91),m3h16x4(:,17),heltab2x64(:,:,365))
  call Hloop_Q_A(ntryL,G1H4(91),79,0,G2H4(33),n2h4(121))
  call Hloop_QZ_A(ntryL,G1H64(314),wf16(:,183),G1H4(92),ngZd,m3h16x4(:,18),heltab2x64(:,:,366))
  call Hloop_Q_A(ntryL,G1H4(92),79,0,G2H4(36),n2h4(122))
  call Hloop_QV_A(ntryL,G1H64(315),wf16(:,35),G1H4(97),m3h16x4(:,19),heltab2x64(:,:,367))
  call Hloop_Q_A(ntryL,G1H4(97),79,0,G2H4(41),n2h4(123))
  call Hloop_QZ_A(ntryL,G1H64(316),wf16(:,184),G1H4(98),ngZd,m3h16x4(:,20),heltab2x64(:,:,368))
  call Hloop_Q_A(ntryL,G1H4(98),79,0,G2H4(44),n2h4(124))
  call Hloop_AV_Q(ntryL,G1H64(317),wf16(:,33),G1H4(102),m3h16x4(:,21),heltab2x64(:,:,369))
  call Hloop_A_Q(ntryL,G1H4(102),79,0,G2H4(49),n2h4(125))
  call Hloop_AZ_Q(ntryL,G1H64(318),wf16(:,183),G1H4(103),ngZd,m3h16x4(:,22),heltab2x64(:,:,370))
  call Hloop_A_Q(ntryL,G1H4(103),79,0,G2H4(52),n2h4(126))
  call Hloop_AV_Q(ntryL,G1H64(319),wf16(:,35),G1H4(108),m3h16x4(:,23),heltab2x64(:,:,371))
  call Hloop_A_Q(ntryL,G1H4(108),79,0,G2H4(57),n2h4(127))
  call Hloop_AZ_Q(ntryL,G1H64(320),wf16(:,184),G1H4(109),ngZd,m3h16x4(:,24),heltab2x64(:,:,372))
  call Hloop_A_Q(ntryL,G1H4(109),79,0,G2H4(60),n2h4(128))
  call Hloop_VQ_A(ntryL,G1H64(321),ex5(:),G1H32(68),m3h2x32(:,41),heltab2x64(:,:,373))
  call Hloop_Q_A(ntryL,G1H32(68),80,0,G2H32(25),n2h32(89))
  call Hloop_VQ_A(ntryL,G1H64(322),ex5(:),G1H32(70),m3h2x32(:,42),heltab2x64(:,:,374))
  call Hloop_Q_A(ntryL,G1H32(70),80,0,G2H32(26),n2h32(90))
  call Hloop_VQ_A(ntryL,G1H64(323),ex5(:),G1H32(71),m3h2x32(:,43),heltab2x64(:,:,375))
  call Hloop_Q_A(ntryL,G1H32(71),80,0,G2H32(27),n2h32(91))
  call Hloop_VQ_A(ntryL,G1H64(324),ex5(:),G1H32(72),m3h2x32(:,44),heltab2x64(:,:,376))
  call Hloop_Q_A(ntryL,G1H32(72),80,0,G2H32(28),n2h32(92))
  call Hloop_QV_A(ntryL,G1H64(325),wf16(:,37),G1H4(30),m3h16x4(:,25),heltab2x64(:,:,377))
  call Hloop_Q_A(ntryL,G1H4(30),79,0,G2H4(65),n2h4(129))
  call Hloop_QV_A(ntryL,G1H64(326),wf16(:,38),G1H4(41),m3h16x4(:,26),heltab2x64(:,:,378))
  call Hloop_Q_A(ntryL,G1H4(41),79,0,G2H4(66),n2h4(130))
  call Hloop_QZ_A(ntryL,G1H64(327),wf16(:,185),G1H4(52),ngZd,m3h16x4(:,27),heltab2x64(:,:,379))
  call Hloop_Q_A(ntryL,G1H4(52),79,0,G2H4(67),n2h4(131))
  call Hloop_QZ_A(ntryL,G1H64(328),wf16(:,186),G1H4(63),ngZd,m3h16x4(:,28),heltab2x64(:,:,380))
  call Hloop_Q_A(ntryL,G1H4(63),79,0,G2H4(68),n2h4(132))
  call Hloop_AV_Q(ntryL,G1H64(329),wf16(:,37),G1H4(74),m3h16x4(:,29),heltab2x64(:,:,381))
  call Hloop_A_Q(ntryL,G1H4(74),79,0,G2H4(69),n2h4(133))
  call Hloop_AV_Q(ntryL,G1H64(330),wf16(:,38),G1H4(85),m3h16x4(:,30),heltab2x64(:,:,382))
  call Hloop_A_Q(ntryL,G1H4(85),79,0,G2H4(70),n2h4(134))
  call Hloop_AZ_Q(ntryL,G1H64(331),wf16(:,185),G1H4(96),ngZd,m3h16x4(:,31),heltab2x64(:,:,383))
  call Hloop_A_Q(ntryL,G1H4(96),79,0,G2H4(71),n2h4(135))
  call Hloop_AZ_Q(ntryL,G1H64(332),wf16(:,186),G1H4(107),ngZd,m3h16x4(:,32),heltab2x64(:,:,384))
  call Hloop_A_Q(ntryL,G1H4(107),79,0,G2H4(72),n2h4(136))
  call Hloop_VQ_A(ntryL,G1H64(333),ex5(:),G1H32(73),m3h2x32(:,45),heltab2x64(:,:,385))
  call Hloop_Q_A(ntryL,G1H32(73),80,0,G2H32(29),n2h32(93))
  call Hloop_VQ_A(ntryL,G1H64(334),ex5(:),G1H32(74),m3h2x32(:,46),heltab2x64(:,:,386))
  call Hloop_Q_A(ntryL,G1H32(74),80,0,G2H32(30),n2h32(94))
  call Hloop_VQ_A(ntryL,G1H64(335),ex5(:),G1H32(76),m3h2x32(:,47),heltab2x64(:,:,387))
  call Hloop_Q_A(ntryL,G1H32(76),80,0,G2H32(31),n2h32(95))
  call Hloop_VQ_A(ntryL,G1H64(336),ex5(:),G1H32(77),m3h2x32(:,48),heltab2x64(:,:,388))
  call Hloop_Q_A(ntryL,G1H32(77),80,0,G2H32(32),n2h32(96))
  call Hloop_QV_A(ntryL,G1H64(337),wf16(:,41),G1H4(25),m3h16x4(:,33),heltab2x64(:,:,389))
  call Hloop_Q_A(ntryL,G1H4(25),79,0,G2H4(73),n2h4(137))
  call Hloop_QZ_A(ntryL,G1H64(338),wf16(:,187),G1H4(26),ngZd,m3h16x4(:,34),heltab2x64(:,:,390))
  call Hloop_Q_A(ntryL,G1H4(26),79,0,G2H4(74),n2h4(138))
  call Hloop_QV_A(ntryL,G1H64(339),wf16(:,43),G1H4(31),m3h16x4(:,35),heltab2x64(:,:,391))
  call Hloop_Q_A(ntryL,G1H4(31),79,0,G2H4(75),n2h4(139))
  call Hloop_QZ_A(ntryL,G1H64(340),wf16(:,188),G1H4(32),ngZd,m3h16x4(:,36),heltab2x64(:,:,392))
  call Hloop_Q_A(ntryL,G1H4(32),79,0,G2H4(76),n2h4(140))
  call Hloop_AV_Q(ntryL,G1H64(341),wf16(:,41),G1H4(36),m3h16x4(:,37),heltab2x64(:,:,393))
  call Hloop_A_Q(ntryL,G1H4(36),79,0,G2H4(77),n2h4(141))
  call Hloop_AZ_Q(ntryL,G1H64(342),wf16(:,187),G1H4(37),ngZd,m3h16x4(:,38),heltab2x64(:,:,394))
  call Hloop_A_Q(ntryL,G1H4(37),79,0,G2H4(78),n2h4(142))
  call Hloop_AV_Q(ntryL,G1H64(343),wf16(:,43),G1H4(42),m3h16x4(:,39),heltab2x64(:,:,395))
  call Hloop_A_Q(ntryL,G1H4(42),79,0,G2H4(79),n2h4(143))
  call Hloop_AZ_Q(ntryL,G1H64(344),wf16(:,188),G1H4(43),ngZd,m3h16x4(:,40),heltab2x64(:,:,396))
  call Hloop_A_Q(ntryL,G1H4(43),79,0,G2H4(80),n2h4(144))
  call Hloop_VQ_A(ntryL,G1H64(345),ex5(:),G1H32(78),m3h2x32(:,49),heltab2x64(:,:,397))
  call Hloop_Q_A(ntryL,G1H32(78),80,0,G2H32(33),n2h32(97))
  call Hloop_VQ_A(ntryL,G1H64(346),ex5(:),G1H32(79),m3h2x32(:,50),heltab2x64(:,:,398))
  call Hloop_Q_A(ntryL,G1H32(79),80,0,G2H32(34),n2h32(98))
  call Hloop_VQ_A(ntryL,G1H64(347),ex5(:),G1H32(80),m3h2x32(:,51),heltab2x64(:,:,399))
  call Hloop_Q_A(ntryL,G1H32(80),80,0,G2H32(35),n2h32(99))
  call Hloop_VQ_A(ntryL,G1H64(348),ex5(:),G1H32(82),m3h2x32(:,52),heltab2x64(:,:,400))
  call Hloop_Q_A(ntryL,G1H32(82),80,0,G2H32(36),n2h32(100))
  call Hloop_QV_A(ntryL,G1H64(349),wf16(:,45),G1H4(47),m3h16x4(:,41),heltab2x64(:,:,401))
  call Hloop_Q_A(ntryL,G1H4(47),79,0,G2H4(81),n2h4(145))
  call Hloop_QZ_A(ntryL,G1H64(350),wf16(:,189),G1H4(48),ngZd,m3h16x4(:,42),heltab2x64(:,:,402))
  call Hloop_Q_A(ntryL,G1H4(48),79,0,G2H4(82),n2h4(146))
  call Hloop_QV_A(ntryL,G1H64(351),wf16(:,47),G1H4(53),m3h16x4(:,43),heltab2x64(:,:,403))
  call Hloop_Q_A(ntryL,G1H4(53),79,0,G2H4(83),n2h4(147))
  call Hloop_QZ_A(ntryL,G1H64(352),wf16(:,190),G1H4(54),ngZd,m3h16x4(:,44),heltab2x64(:,:,404))
  call Hloop_Q_A(ntryL,G1H4(54),79,0,G2H4(84),n2h4(148))
  call Hloop_AV_Q(ntryL,G1H64(353),wf16(:,45),G1H4(58),m3h16x4(:,45),heltab2x64(:,:,405))
  call Hloop_A_Q(ntryL,G1H4(58),79,0,G2H4(85),n2h4(149))
  call Hloop_AZ_Q(ntryL,G1H64(354),wf16(:,189),G1H4(59),ngZd,m3h16x4(:,46),heltab2x64(:,:,406))
  call Hloop_A_Q(ntryL,G1H4(59),79,0,G2H4(86),n2h4(150))
  call Hloop_AV_Q(ntryL,G1H64(355),wf16(:,47),G1H4(64),m3h16x4(:,47),heltab2x64(:,:,407))
  call Hloop_A_Q(ntryL,G1H4(64),79,0,G2H4(87),n2h4(151))
  call Hloop_AZ_Q(ntryL,G1H64(356),wf16(:,190),G1H4(65),ngZd,m3h16x4(:,48),heltab2x64(:,:,408))
  call Hloop_A_Q(ntryL,G1H4(65),79,0,G2H4(88),n2h4(152))
  call Hloop_VQ_A(ntryL,G1H64(357),ex5(:),G1H32(83),m3h2x32(:,53),heltab2x64(:,:,409))
  call Hloop_Q_A(ntryL,G1H32(83),80,0,G2H32(37),n2h32(101))
  call Hloop_VQ_A(ntryL,G1H64(358),ex5(:),G1H32(84),m3h2x32(:,54),heltab2x64(:,:,410))
  call Hloop_Q_A(ntryL,G1H32(84),80,0,G2H32(38),n2h32(102))
  call Hloop_VQ_A(ntryL,G1H64(359),ex5(:),G1H32(85),m3h2x32(:,55),heltab2x64(:,:,411))
  call Hloop_Q_A(ntryL,G1H32(85),80,0,G2H32(39),n2h32(103))
  call Hloop_VQ_A(ntryL,G1H64(360),ex5(:),G1H32(86),m3h2x32(:,56),heltab2x64(:,:,412))
  call Hloop_Q_A(ntryL,G1H32(86),80,0,G2H32(40),n2h32(104))
  call Hloop_QV_A(ntryL,G1H64(361),wf16(:,49),G1H4(69),m3h16x4(:,49),heltab2x64(:,:,413))
  call Hloop_Q_A(ntryL,G1H4(69),79,0,G2H4(89),n2h4(153))
  call Hloop_QZ_A(ntryL,G1H64(362),wf16(:,191),G1H4(70),ngZd,m3h16x4(:,50),heltab2x64(:,:,414))
  call Hloop_Q_A(ntryL,G1H4(70),79,0,G2H4(90),n2h4(154))
  call Hloop_QV_A(ntryL,G1H64(363),wf16(:,51),G1H4(75),m3h16x4(:,51),heltab2x64(:,:,415))
  call Hloop_Q_A(ntryL,G1H4(75),79,0,G2H4(91),n2h4(155))
  call Hloop_QZ_A(ntryL,G1H64(364),wf16(:,192),G1H4(76),ngZd,m3h16x4(:,52),heltab2x64(:,:,416))
  call Hloop_Q_A(ntryL,G1H4(76),79,0,G2H4(92),n2h4(156))
  call Hloop_AV_Q(ntryL,G1H64(365),wf16(:,49),G1H4(80),m3h16x4(:,53),heltab2x64(:,:,417))
  call Hloop_A_Q(ntryL,G1H4(80),79,0,G2H4(93),n2h4(157))
  call Hloop_AZ_Q(ntryL,G1H64(366),wf16(:,191),G1H4(81),ngZd,m3h16x4(:,54),heltab2x64(:,:,418))
  call Hloop_A_Q(ntryL,G1H4(81),79,0,G2H4(94),n2h4(158))
  call Hloop_AV_Q(ntryL,G1H64(367),wf16(:,51),G1H4(86),m3h16x4(:,55),heltab2x64(:,:,419))
  call Hloop_A_Q(ntryL,G1H4(86),79,0,G2H4(95),n2h4(159))
  call Hloop_AZ_Q(ntryL,G1H64(368),wf16(:,192),G1H4(87),ngZd,m3h16x4(:,56),heltab2x64(:,:,420))
  call Hloop_A_Q(ntryL,G1H4(87),79,0,G2H4(96),n2h4(160))
  call Hloop_VQ_A(ntryL,G1H64(369),ex5(:),G1H32(88),m3h2x32(:,57),heltab2x64(:,:,421))
  call Hloop_Q_A(ntryL,G1H32(88),80,0,G2H32(41),n2h32(105))
  call Hloop_VQ_A(ntryL,G1H64(370),ex5(:),G1H32(89),m3h2x32(:,58),heltab2x64(:,:,422))
  call Hloop_Q_A(ntryL,G1H32(89),80,0,G2H32(42),n2h32(106))
  call Hloop_VQ_A(ntryL,G1H64(371),ex5(:),G1H32(90),m3h2x32(:,59),heltab2x64(:,:,423))
  call Hloop_Q_A(ntryL,G1H32(90),80,0,G2H32(43),n2h32(107))
  call Hloop_VQ_A(ntryL,G1H64(372),ex5(:),G1H32(91),m3h2x32(:,60),heltab2x64(:,:,424))
  call Hloop_Q_A(ntryL,G1H32(91),80,0,G2H32(44),n2h32(108))
  call Hloop_QV_A(ntryL,G1H64(373),wf16(:,53),G1H4(91),m3h16x4(:,57),heltab2x64(:,:,425))
  call Hloop_Q_A(ntryL,G1H4(91),79,0,G2H4(97),n2h4(161))
  call Hloop_QV_A(ntryL,G1H64(374),wf16(:,54),G1H4(92),m3h16x4(:,58),heltab2x64(:,:,426))
  call Hloop_Q_A(ntryL,G1H4(92),79,0,G2H4(98),n2h4(162))
  call Hloop_QZ_A(ntryL,G1H64(375),wf16(:,193),G1H4(97),ngZd,m3h16x4(:,59),heltab2x64(:,:,427))
  call Hloop_Q_A(ntryL,G1H4(97),79,0,G2H4(99),n2h4(163))
  call Hloop_QZ_A(ntryL,G1H64(376),wf16(:,194),G1H4(98),ngZd,m3h16x4(:,60),heltab2x64(:,:,428))
  call Hloop_Q_A(ntryL,G1H4(98),79,0,G2H4(100),n2h4(164))
  call Hloop_AV_Q(ntryL,G1H64(377),wf16(:,53),G1H4(102),m3h16x4(:,61),heltab2x64(:,:,429))
  call Hloop_A_Q(ntryL,G1H4(102),79,0,G2H4(101),n2h4(165))
  call Hloop_AV_Q(ntryL,G1H64(378),wf16(:,54),G1H4(103),m3h16x4(:,62),heltab2x64(:,:,430))
  call Hloop_A_Q(ntryL,G1H4(103),79,0,G2H4(102),n2h4(166))
  call Hloop_AZ_Q(ntryL,G1H64(379),wf16(:,193),G1H4(108),ngZd,m3h16x4(:,63),heltab2x64(:,:,431))
  call Hloop_A_Q(ntryL,G1H4(108),79,0,G2H4(103),n2h4(167))
  call Hloop_AZ_Q(ntryL,G1H64(380),wf16(:,194),G1H4(109),ngZd,m3h16x4(:,64),heltab2x64(:,:,432))
  call Hloop_A_Q(ntryL,G1H4(109),79,0,G2H4(104),n2h4(168))
  call Hloop_VQ_A(ntryL,G1H64(381),ex5(:),G1H32(92),m3h2x32(:,61),heltab2x64(:,:,433))
  call Hloop_Q_A(ntryL,G1H32(92),80,0,G2H32(45),n2h32(109))
  call Hloop_VQ_A(ntryL,G1H64(382),ex5(:),G1H32(94),m3h2x32(:,62),heltab2x64(:,:,434))
  call Hloop_Q_A(ntryL,G1H32(94),80,0,G2H32(46),n2h32(110))
  call Hloop_VQ_A(ntryL,G1H64(383),ex5(:),G1H32(95),m3h2x32(:,63),heltab2x64(:,:,435))
  call Hloop_Q_A(ntryL,G1H32(95),80,0,G2H32(47),n2h32(111))
  call Hloop_VQ_A(ntryL,G1H64(384),ex5(:),G1H32(96),m3h2x32(:,64),heltab2x64(:,:,436))
  call Hloop_Q_A(ntryL,G1H32(96),80,0,G2H32(48),n2h32(112))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(59),[G2H8(57),G1H8(83)])
call HGT_lower_alpha_w2_OLR(G2H8(9),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(9),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(9),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(9),[G2H8(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(100),[G2H4(99),G2H4(98),G2H4(97),G2H4(92),G2H4(91) &
    ,G2H4(90),G2H4(89),G2H4(84),G2H4(83),G2H4(82),G2H4(81),G2H4(76),G2H4(75),G2H4(74),G2H4(73),G2H4(68),G2H4(67),G2H4(66),G2H4(65) &
    ,G2H4(44),G2H4(41),G2H4(36),G2H4(33),G2H4(12),G2H4(9),G2H4(4),G2H4(1),G2H4(55),G2H4(53),G2H4(48),G2H4(47),G2H4(46),G2H4(42) &
    ,G2H4(38),G2H4(34),G2H4(14),G2H4(10),G2H4(6),G2H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(61),[G2H8(60),G1H8(99)])
call HGT_lower_alpha_w2_OLR(G2H8(10),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(10),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(10),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(10),[G2H8(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(43),[G2H8(36),G1H8(51)])
call HGT_lower_alpha_w2_OLR(G2H8(11),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(11),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(11),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(11),[G2H8(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(44),[G2H8(41),G1H8(67)])
call HGT_lower_alpha_w2_OLR(G2H8(12),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(12),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(12),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(12),[G2H8(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(2),[G2H8(1)])
call HGT_lower_alpha_w2_OLR(G2H8(13),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(13),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(13),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(13),[G2H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(104),[G2H4(103),G2H4(102),G2H4(101),G2H4(96),G2H4(95) &
    ,G2H4(94),G2H4(93),G2H4(88),G2H4(87),G2H4(86),G2H4(85),G2H4(80),G2H4(79),G2H4(78),G2H4(77),G2H4(72),G2H4(71),G2H4(70),G2H4(69) &
    ,G2H4(60),G2H4(57),G2H4(52),G2H4(49),G2H4(28),G2H4(25),G2H4(20),G2H4(17),G2H4(64),G2H4(63),G2H4(61),G2H4(56),G2H4(62),G2H4(58) &
    ,G2H4(54),G2H4(50),G2H4(30),G2H4(26),G2H4(22),G2H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(4),[G2H8(3)])
call HGT_lower_alpha_w2_OLR(G2H8(14),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(14),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(14),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(14),[G2H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(7),[G2H8(5)])
call HGT_lower_alpha_w2_OLR(G2H8(15),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(15),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(15),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(15),[G2H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(8),[G2H8(6)])
call HGT_lower_alpha_w2_OLR(G2H8(16),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(16),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(16),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(16),[G2H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(28),[G2H8(25),G2H8(26),G2H8(18),G1H8(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(29),[G2H8(27),G2H8(30),G2H8(22),G1H8(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(32),[G2H8(31),G2H8(38),G2H8(34),G1H8(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(39),[G2H8(37),G2H8(46),G2H8(42),G1H8(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(81),[G2H8(76),G1H8(147)])
call HGT_lower_alpha_w2_OLR(G2H8(49),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(49),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(49),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(49),[G2H8(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(84),[G2H8(83),G1H8(163)])
call HGT_lower_alpha_w2_OLR(G2H8(50),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(50),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(50),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(50),[G2H8(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(73),[G2H8(63),G1H8(115)])
call HGT_lower_alpha_w2_OLR(G2H8(51),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(51),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(51),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(51),[G2H8(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(75),[G2H8(64),G1H8(131)])
call HGT_lower_alpha_w2_OLR(G2H8(52),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(52),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(52),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(52),[G2H8(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(45),[G2H8(40)])
call HGT_lower_alpha_w2_OLR(G2H8(53),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(53),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(53),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(53),[G2H8(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(48),[G2H8(47)])
call HGT_lower_alpha_w2_OLR(G2H8(54),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(54),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(54),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(54),[G2H8(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(68),[G2H8(65)])
call HGT_lower_alpha_w2_OLR(G2H8(55),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(55),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(55),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(55),[G2H8(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(69),[G2H8(67)])
call HGT_lower_alpha_w2_OLR(G2H8(56),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(56),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(56),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(56),[G2H8(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(77),[G2H8(71),G2H8(66),G2H8(58),G1H8(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(79),[G2H8(72),G2H8(70),G2H8(62),G1H8(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(85),[G2H8(80),G2H8(78),G2H8(74),G1H8(148)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(88),[G2H8(87),G2H8(86),G2H8(82),G1H8(164)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G2H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G2H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(16),[G2H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(23),[G2H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(29),[G2H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(32),[G2H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(39),[G2H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(45),[G2H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(23),[G2H16(15),G2H16(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(16),[G2H16(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(26),[G2H16(19),G2H16(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(20),[G2H16(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(24),[G2H16(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(28),[G2H16(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(31),[G2H16(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(32),[G2H16(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(34),[G2H16(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(36),[G2H16(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(38),[G2H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(40),[G2H16(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(43),[G2H16(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(44),[G2H16(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(49),[G2H16(25),G2H16(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(27),[G2H16(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(51),[G2H16(29),G2H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(30),[G2H16(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(50),[G2H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(52),[G2H16(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(53),[G2H16(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(54),[G2H16(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(55),[G2H16(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(56),[G2H16(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(57),[G2H16(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(58),[G2H16(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(59),[G2H16(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(60),[G2H16(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(71),[G2H16(67),G2H16(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(68),[G2H16(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(73),[G2H16(69),G2H16(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(70),[G2H16(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(72),[G2H16(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(74),[G2H16(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(83),[G2H16(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(84),[G2H16(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(85),[G2H16(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(86),[G2H16(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(87),[G2H16(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(88),[G2H16(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(89),[G2H16(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(90),[G2H16(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(92),[G2H16(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(94),[G2H16(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(96),[G2H16(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(98),[G2H16(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(100),[G2H16(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(102),[G2H16(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(104),[G2H16(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(106),[G2H16(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(109),[G2H16(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(110),[G2H16(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(113),[G2H16(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(114),[G2H16(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(117),[G2H16(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(118),[G2H16(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(121),[G2H16(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(122),[G2H16(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(133),[G2H16(129),G2H16(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(130),[G2H16(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(135),[G2H16(131),G2H16(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(132),[G2H16(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(134),[G2H16(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(136),[G2H16(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(145),[G2H16(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(146),[G2H16(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(147),[G2H16(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(148),[G2H16(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(149),[G2H16(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(150),[G2H16(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(151),[G2H16(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(152),[G2H16(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(171),[G2H16(167),G2H16(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(168),[G2H16(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(173),[G2H16(169),G2H16(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(170),[G2H16(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(172),[G2H16(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(174),[G2H16(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(175),[G2H16(159)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(176),[G2H16(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(177),[G2H16(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(178),[G2H16(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(179),[G2H16(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(180),[G2H16(164)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(181),[G2H16(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(182),[G2H16(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(193),[G2H16(189),G2H16(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(190),[G2H16(184)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(195),[G2H16(191),G2H16(185)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(192),[G2H16(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(194),[G2H16(187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(196),[G2H16(188)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(205),[G2H16(197)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(206),[G2H16(198)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(207),[G2H16(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(208),[G2H16(200)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(209),[G2H16(201)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(210),[G2H16(202)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(211),[G2H16(203)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(212),[G2H16(204)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(214),[G2H16(213)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(216),[G2H16(215)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(218),[G2H16(217)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(220),[G2H16(219)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(222),[G2H16(221)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(224),[G2H16(223)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(226),[G2H16(225)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(228),[G2H16(227)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(231),[G2H16(229)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(232),[G2H16(230)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(235),[G2H16(233)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(236),[G2H16(234)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(239),[G2H16(237)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(240),[G2H16(238)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(243),[G2H16(241)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(244),[G2H16(242)])
  call Hotf_4pt_reduction(G2H8(9),RedSet_4(17),mass4set(:,1),  & 
G1H8(49),G1H8(50),G1H8(55),G1H8(60),G1H8(56),8)
  call HG1shiftOLR(G1H8(50),32,8)
  call Hloop_QA_V(ntryL,G2H4(100),ex6(:),G2H2(33),m3h2x2(:,25),heltab2x4(:,:,57))
  call Hotf_4pt_reduction(G2H8(10),RedSet_4(17),mass4set(:,1),  & 
G1H8(59),G1H8(61),G1H8(64),G1H8(65),G1H8(66),8)
  call HG1shiftOLR(G1H8(61),32,8)
  call Hotf_4pt_reduction(G2H8(11),RedSet_4(14),mass4set(:,1),  & 
G1H8(71),G1H8(76),G1H8(72),G1H8(75),G1H8(77),8)
  call HG1shiftOLR(G1H8(76),32,8)
  call Hotf_4pt_reduction(G2H8(12),RedSet_4(14),mass4set(:,1),  & 
G1H8(80),G1H8(81),G1H8(82),G1H8(87),G1H8(92),8)
  call HG1shiftOLR(G1H8(81),32,8)
  call Hotf_4pt_reduction(G2H8(13),RedSet_4(66),mass4set(:,1),  & 
G1H8(88),G1H8(91),G1H8(93),G1H8(96),G1H8(97),8)
  call HG1shiftOLR(G1H8(91),16,8)
  call Hloop_AQ_V(ntryL,G2H4(104),ex5(:),G2H2(35),m3h2x2(:,26),heltab2x4(:,:,58))
  call Hotf_4pt_reduction(G2H8(14),RedSet_4(66),mass4set(:,1),  & 
G1H8(98),G1H8(103),G1H8(108),G1H8(104),G1H8(107),8)
  call HG1shiftOLR(G1H8(103),16,8)
  call Hotf_4pt_reduction(G2H8(15),RedSet_4(67),mass4set(:,1),  & 
G1H8(109),G1H8(112),G1H8(113),G1H8(114),G1H8(119),8)
  call HG1shiftOLR(G1H8(112),16,8)
  call Hotf_4pt_reduction(G2H8(16),RedSet_4(67),mass4set(:,1),  & 
G1H8(124),G1H8(120),G1H8(123),G1H8(125),G1H8(128),8)
  call HG1shiftOLR(G1H8(120),16,8)
call HGT_w2_OLR(G1H16(1),1,1,16)
call HGT_w2_invQ_OLR(G1H16(1),2,5,16)
  call Hloop_QV_A(ntryL,G1H16(1),wf4(:,1),G1H4(30),m3h4x4(:,81),heltab2x16(:,:,105))
  call Hloop_Q_A(ntryL,G1H4(30),117,0,G2H4(99),n2h4(169))
  call Hotf_4pt_reduction(G2H8(28),RedSet_4(15),mass4set(:,1),  & 
G1H8(129),G1H8(130),G1H8(135),G1H8(140),G1H8(136),8)
  call HG1shiftOLR(G1H8(130),32,8)
call HGT_w2_OLR(G1H16(2),1,1,16)
call HGT_w2_invQ_OLR(G1H16(2),2,5,16)
  call Hloop_QV_A(ntryL,G1H16(2),wf4(:,1),G1H4(41),m3h4x4(:,82),heltab2x16(:,:,106))
  call Hloop_Q_A(ntryL,G1H4(41),117,0,G2H4(98),n2h4(170))
  call Hotf_4pt_reduction(G2H8(29),RedSet_4(15),mass4set(:,1),  & 
G1H8(139),G1H8(141),G1H8(144),G1H8(145),G1H8(146),8)
  call HG1shiftOLR(G1H8(141),32,8)
call HGT_w2_OLR(G1H16(4),1,1,16)
call HGT_w2_invQ_OLR(G1H16(4),2,5,16)
  call Hloop_QZ_A(ntryL,G1H16(4),wf4(:,8),G1H4(52),ngZd,m3h4x4(:,83),heltab2x16(:,:,107))
  call Hloop_Q_A(ntryL,G1H4(52),117,0,G2H4(97),n2h4(171))
call HGT_w2_OLR(G1H16(5),1,1,16)
call HGT_w2_invQ_OLR(G1H16(5),2,5,16)
  call Hloop_QZ_A(ntryL,G1H16(5),wf4(:,8),G1H4(63),ngZd,m3h4x4(:,84),heltab2x16(:,:,108))
  call Hloop_Q_A(ntryL,G1H4(63),117,0,G2H4(92),n2h4(172))
call HGT_w2_OLR(G1H16(6),1,1,16)
call HGT_w2_invQ_OLR(G1H16(6),2,5,16)
  call Hloop_QV_A(ntryL,G1H16(6),wf4(:,2),G1H4(74),m3h4x4(:,85),heltab2x16(:,:,109))
  call Hloop_Q_A(ntryL,G1H4(74),122,0,G2H4(91),n2h4(173))
  call Hotf_4pt_reduction(G2H8(32),RedSet_4(18),mass4set(:,1),  & 
G1H8(151),G1H8(156),G1H8(152),G1H8(155),G1H8(157),8)
  call HG1shiftOLR(G1H8(156),32,8)
call HGT_w2_OLR(G1H16(7),1,1,16)
call HGT_w2_invQ_OLR(G1H16(7),2,5,16)
  call Hloop_QZ_A(ntryL,G1H16(7),wf4(:,6),G1H4(85),ngZd,m3h4x4(:,86),heltab2x16(:,:,110))
  call Hloop_Q_A(ntryL,G1H4(85),122,0,G2H4(90),n2h4(174))
call HGT_w2_OLR(G1H16(8),1,1,16)
call HGT_w2_invQ_OLR(G1H16(8),2,5,16)
  call Hloop_QV_A(ntryL,G1H16(8),wf4(:,2),G1H4(96),m3h4x4(:,87),heltab2x16(:,:,111))
  call Hloop_Q_A(ntryL,G1H4(96),122,0,G2H4(89),n2h4(175))
  call Hotf_4pt_reduction(G2H8(39),RedSet_4(18),mass4set(:,1),  & 
G1H8(160),G1H8(161),G1H8(162),G1H8(167),G1H8(172),8)
  call HG1shiftOLR(G1H8(161),32,8)
call HGT_w2_OLR(G1H16(10),1,1,16)
call HGT_w2_invQ_OLR(G1H16(10),2,5,16)
  call Hloop_QZ_A(ntryL,G1H16(10),wf4(:,6),G1H4(107),ngZd,m3h4x4(:,88),heltab2x16(:,:,112))
  call Hloop_Q_A(ntryL,G1H4(107),122,0,G2H4(84),n2h4(176))
  call Hotf_4pt_reduction(G2H8(49),RedSet_4(23),mass4set(:,1),  & 
G1H8(168),G1H8(171),G1H8(173),G1H8(176),G1H8(53),8)
  call HG1shiftOLR(G1H8(171),32,8)
  call Hotf_4pt_reduction(G2H8(50),RedSet_4(23),mass4set(:,1),  & 
G1H8(54),G1H8(69),G1H8(70),G1H8(85),G1H8(86),8)
  call HG1shiftOLR(G1H8(69),32,8)
  call Hotf_4pt_reduction(G2H8(51),RedSet_4(20),mass4set(:,1),  & 
G1H8(101),G1H8(102),G1H8(117),G1H8(118),G1H8(133),8)
  call HG1shiftOLR(G1H8(102),32,8)
  call Hotf_4pt_reduction(G2H8(52),RedSet_4(20),mass4set(:,1),  & 
G1H8(134),G1H8(149),G1H8(150),G1H8(165),G1H8(166),8)
  call HG1shiftOLR(G1H8(149),32,8)
  call Hotf_4pt_reduction(G2H8(53),RedSet_4(68),mass4set(:,1),  & 
G1H8(1),G1H8(2),G1H8(5),G1H8(6),G1H8(7),8)
  call HG1shiftOLR(G1H8(2),16,8)
  call Hotf_4pt_reduction(G2H8(54),RedSet_4(68),mass4set(:,1),  & 
G1H8(8),G1H8(11),G1H8(12),G1H8(13),G1H8(14),8)
  call HG1shiftOLR(G1H8(11),16,8)
  call Hotf_4pt_reduction(G2H8(55),RedSet_4(69),mass4set(:,1),  & 
G1H8(17),G1H8(18),G1H8(19),G1H8(20),G1H8(23),8)
  call HG1shiftOLR(G1H8(18),16,8)
  call Hotf_4pt_reduction(G2H8(56),RedSet_4(69),mass4set(:,1),  & 
G1H8(24),G1H8(25),G1H8(26),G1H8(29),G1H8(30),8)
  call HG1shiftOLR(G1H8(25),16,8)
call HGT_w2_OLR(G1H16(11),1,1,16)
call HGT_w2_invQ_OLR(G1H16(11),2,5,16)
  call Hloop_QV_A(ntryL,G1H16(11),wf4(:,11),G1H4(25),m3h4x4(:,89),heltab2x16(:,:,113))
  call Hloop_Q_A(ntryL,G1H4(25),121,0,G2H4(83),n2h4(177))
  call Hotf_4pt_reduction(G2H8(77),RedSet_4(21),mass4set(:,1),  & 
G1H8(31),G1H8(32),G1H8(35),G1H8(36),G1H8(37),8)
  call HG1shiftOLR(G1H8(32),32,8)
call HGT_w2_OLR(G1H16(12),1,1,16)
call HGT_w2_invQ_OLR(G1H16(12),2,5,16)
  call Hloop_QV_A(ntryL,G1H16(12),wf4(:,11),G1H4(26),m3h4x4(:,90),heltab2x16(:,:,114))
  call Hloop_Q_A(ntryL,G1H4(26),121,0,G2H4(82),n2h4(178))
  call Hotf_4pt_reduction(G2H8(79),RedSet_4(21),mass4set(:,1),  & 
G1H8(38),G1H8(41),G1H8(42),G1H8(43),G1H8(44),8)
  call HG1shiftOLR(G1H8(41),32,8)
call HGT_w2_OLR(G1H16(13),1,1,16)
call HGT_w2_invQ_OLR(G1H16(13),2,5,16)
  call Hloop_QZ_A(ntryL,G1H16(13),wf4(:,16),G1H4(31),ngZd,m3h4x4(:,91),heltab2x16(:,:,115))
  call Hloop_Q_A(ntryL,G1H4(31),121,0,G2H4(81),n2h4(179))
call HGT_w2_OLR(G1H16(14),1,1,16)
call HGT_w2_invQ_OLR(G1H16(14),2,5,16)
  call Hloop_QZ_A(ntryL,G1H16(14),wf4(:,16),G1H4(32),ngZd,m3h4x4(:,92),heltab2x16(:,:,116))
  call Hloop_Q_A(ntryL,G1H4(32),121,0,G2H4(76),n2h4(180))
call HGT_w2_OLR(G1H16(16),1,1,16)
call HGT_w2_invQ_OLR(G1H16(16),2,5,16)
  call Hloop_QV_A(ntryL,G1H16(16),wf4(:,12),G1H4(36),m3h4x4(:,93),heltab2x16(:,:,117))
  call Hloop_Q_A(ntryL,G1H4(36),118,0,G2H4(75),n2h4(181))
  call Hotf_4pt_reduction(G2H8(85),RedSet_4(24),mass4set(:,1),  & 
G1H8(47),G1H8(48),G1H8(83),G1H8(99),G1H8(51),8)
  call HG1shiftOLR(G1H8(48),32,8)
call HGT_w2_OLR(G1H16(17),1,1,16)
call HGT_w2_invQ_OLR(G1H16(17),2,5,16)
  call Hloop_QZ_A(ntryL,G1H16(17),wf4(:,14),G1H4(37),ngZd,m3h4x4(:,94),heltab2x16(:,:,118))
  call Hloop_Q_A(ntryL,G1H4(37),118,0,G2H4(74),n2h4(182))
call HGT_w2_OLR(G1H16(18),1,1,16)
call HGT_w2_invQ_OLR(G1H16(18),2,5,16)
  call Hloop_QV_A(ntryL,G1H16(18),wf4(:,12),G1H4(42),m3h4x4(:,95),heltab2x16(:,:,119))
  call Hloop_Q_A(ntryL,G1H4(42),118,0,G2H4(73),n2h4(183))
  call Hotf_4pt_reduction(G2H8(88),RedSet_4(24),mass4set(:,1),  & 
G1H8(67),G1H8(52),G1H8(68),G1H8(84),G1H8(100),8)
  call HG1shiftOLR(G1H8(52),32,8)
call HGT_w2_OLR(G1H16(19),1,1,16)
call HGT_w2_invQ_OLR(G1H16(19),2,5,16)
  call Hloop_QZ_A(ntryL,G1H16(19),wf4(:,14),G1H4(43),ngZd,m3h4x4(:,96),heltab2x16(:,:,120))
  call Hloop_Q_A(ntryL,G1H4(43),118,0,G2H4(68),n2h4(184))
  call Hloop_VA_Q(ntryL,G1H8(3),ex6(:),G1H4(47),m3h2x4(:,49),heltab2x8(:,:,97))
  call Hloop_A_Q(ntryL,G1H4(47),117,0,G2H4(67),n2h4(185))
  call Hloop_VA_Q(ntryL,G1H8(4),ex6(:),G1H4(48),m3h2x4(:,50),heltab2x8(:,:,98))
  call Hloop_A_Q(ntryL,G1H4(48),117,0,G2H4(66),n2h4(186))
  call Hloop_VA_Q(ntryL,G1H8(9),ex6(:),G1H4(53),m3h2x4(:,51),heltab2x8(:,:,99))
  call Hloop_A_Q(ntryL,G1H4(53),117,0,G2H4(65),n2h4(187))
  call Hloop_VA_Q(ntryL,G1H8(10),ex6(:),G1H4(54),m3h2x4(:,52),heltab2x8(:,:,100))
  call Hloop_A_Q(ntryL,G1H4(54),117,0,G2H4(44),n2h4(188))
  call Hloop_VQ_A(ntryL,G1H8(15),ex5(:),G1H4(58),m3h2x4(:,53),heltab2x8(:,:,101))
  call Hloop_Q_A(ntryL,G1H4(58),117,0,G2H4(41),n2h4(189))
  call Hloop_VQ_A(ntryL,G1H8(16),ex5(:),G1H4(59),m3h2x4(:,54),heltab2x8(:,:,102))
  call Hloop_Q_A(ntryL,G1H4(59),117,0,G2H4(36),n2h4(190))
  call Hloop_VQ_A(ntryL,G1H8(21),ex5(:),G1H4(64),m3h2x4(:,55),heltab2x8(:,:,103))
  call Hloop_Q_A(ntryL,G1H4(64),117,0,G2H4(33),n2h4(191))
  call Hloop_VQ_A(ntryL,G1H8(22),ex5(:),G1H4(65),m3h2x4(:,56),heltab2x8(:,:,104))
  call Hloop_Q_A(ntryL,G1H4(65),117,0,G2H4(12),n2h4(192))
  call Hloop_VQ_A(ntryL,G1H8(27),ex5(:),G1H4(69),m3h2x4(:,57),heltab2x8(:,:,105))
  call Hloop_Q_A(ntryL,G1H4(69),118,0,G2H4(9),n2h4(193))
  call Hloop_VQ_A(ntryL,G1H8(28),ex5(:),G1H4(70),m3h2x4(:,58),heltab2x8(:,:,106))
  call Hloop_Q_A(ntryL,G1H4(70),118,0,G2H4(4),n2h4(194))
  call Hloop_VQ_A(ntryL,G1H8(33),ex5(:),G1H4(75),m3h2x4(:,59),heltab2x8(:,:,107))
  call Hloop_Q_A(ntryL,G1H4(75),118,0,G2H4(1),n2h4(195))
  call Hloop_VQ_A(ntryL,G1H8(34),ex5(:),G1H4(76),m3h2x4(:,60),heltab2x8(:,:,108))
  call Hloop_Q_A(ntryL,G1H4(76),118,0,G2H4(55),n2h4(196))
  call Hloop_VA_Q(ntryL,G1H8(39),ex6(:),G1H4(80),m3h2x4(:,61),heltab2x8(:,:,109))
  call Hloop_A_Q(ntryL,G1H4(80),118,0,G2H4(53),n2h4(197))
  call Hloop_VA_Q(ntryL,G1H8(40),ex6(:),G1H4(81),m3h2x4(:,62),heltab2x8(:,:,110))
  call Hloop_A_Q(ntryL,G1H4(81),118,0,G2H4(48),n2h4(198))
  call Hloop_VA_Q(ntryL,G1H8(45),ex6(:),G1H4(86),m3h2x4(:,63),heltab2x8(:,:,111))
  call Hloop_A_Q(ntryL,G1H4(86),118,0,G2H4(47),n2h4(199))
  call Hloop_VA_Q(ntryL,G1H8(46),ex6(:),G1H4(87),m3h2x4(:,64),heltab2x8(:,:,112))
  call Hloop_A_Q(ntryL,G1H4(87),118,0,G2H4(46),n2h4(200))
  call Hloop_QV_A(ntryL,G1H8(57),wf4(:,2),G1H2(6),m3h4x2(:,49),heltab2x8(:,:,113))
  call Hloop_Q_A(ntryL,G1H2(6),95,0,G2H2(43),n2h2(41))
  call Hloop_QV_A(ntryL,G1H8(58),wf4(:,2),G1H2(17),m3h4x2(:,50),heltab2x8(:,:,114))
  call Hloop_Q_A(ntryL,G1H2(17),95,0,G2H2(45),n2h2(42))
  call Hloop_QV_A(ntryL,G1H8(62),wf4(:,2),G1H2(28),m3h4x2(:,51),heltab2x8(:,:,115))
  call Hloop_Q_A(ntryL,G1H2(28),95,0,G2H2(53),n2h2(43))
  call Hloop_QV_A(ntryL,G1H8(63),wf4(:,2),G1H2(39),m3h4x2(:,52),heltab2x8(:,:,116))
  call Hloop_Q_A(ntryL,G1H2(39),95,0,G2H2(55),n2h2(44))
  call Hloop_QZ_A(ntryL,G1H8(73),wf4(:,6),G1H2(50),ngZd,m3h4x2(:,53),heltab2x8(:,:,117))
  call Hloop_Q_A(ntryL,G1H2(50),95,0,G2H2(63),n2h2(45))
  call Hloop_QZ_A(ntryL,G1H8(74),wf4(:,6),G1H2(61),ngZd,m3h4x2(:,54),heltab2x8(:,:,118))
  call Hloop_Q_A(ntryL,G1H2(61),95,0,G2H2(65),n2h2(46))
  call Hloop_QZ_A(ntryL,G1H8(78),wf4(:,6),G1H2(72),ngZd,m3h4x2(:,55),heltab2x8(:,:,119))
  call Hloop_Q_A(ntryL,G1H2(72),95,0,G2H2(1),n2h2(47))
  call Hloop_QZ_A(ntryL,G1H8(79),wf4(:,6),G1H2(83),ngZd,m3h4x2(:,56),heltab2x8(:,:,120))
  call Hloop_Q_A(ntryL,G1H2(83),95,0,G2H2(3),n2h2(48))
  call Hloop_QV_A(ntryL,G1H8(89),wf4(:,1),G1H2(1),m3h4x2(:,57),heltab2x8(:,:,121))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(4),n2h2(49))
  call Hloop_QV_A(ntryL,G1H8(90),wf4(:,1),G1H2(2),m3h4x2(:,58),heltab2x8(:,:,122))
  call Hloop_Q_A(ntryL,G1H2(2),95,0,G2H2(6),n2h2(50))
  call Hloop_QV_A(ntryL,G1H8(94),wf4(:,1),G1H2(7),m3h4x2(:,59),heltab2x8(:,:,123))
  call Hloop_Q_A(ntryL,G1H2(7),95,0,G2H2(7),n2h2(51))
  call Hloop_QV_A(ntryL,G1H8(95),wf4(:,1),G1H2(8),m3h4x2(:,60),heltab2x8(:,:,124))
  call Hloop_Q_A(ntryL,G1H2(8),95,0,G2H2(9),n2h2(52))
  call Hloop_QZ_A(ntryL,G1H8(105),wf4(:,8),G1H2(12),ngZd,m3h4x2(:,61),heltab2x8(:,:,125))
  call Hloop_Q_A(ntryL,G1H2(12),95,0,G2H2(10),n2h2(53))
  call Hloop_QZ_A(ntryL,G1H8(106),wf4(:,8),G1H2(13),ngZd,m3h4x2(:,62),heltab2x8(:,:,126))
  call Hloop_Q_A(ntryL,G1H2(13),95,0,G2H2(12),n2h2(54))
  call Hloop_QZ_A(ntryL,G1H8(110),wf4(:,8),G1H2(18),ngZd,m3h4x2(:,63),heltab2x8(:,:,127))
  call Hloop_Q_A(ntryL,G1H2(18),95,0,G2H2(13),n2h2(55))
  call Hloop_QZ_A(ntryL,G1H8(111),wf4(:,8),G1H2(19),ngZd,m3h4x2(:,64),heltab2x8(:,:,128))
  call Hloop_Q_A(ntryL,G1H2(19),95,0,G2H2(15),n2h2(56))
  call Hloop_QV_A(ntryL,G1H8(121),wf4(:,12),G1H2(23),m3h4x2(:,65),heltab2x8(:,:,129))
  call Hloop_Q_A(ntryL,G1H2(23),95,0,G2H2(16),n2h2(57))
  call Hloop_QV_A(ntryL,G1H8(122),wf4(:,12),G1H2(24),m3h4x2(:,66),heltab2x8(:,:,130))
  call Hloop_Q_A(ntryL,G1H2(24),95,0,G2H2(18),n2h2(58))
  call Hloop_QV_A(ntryL,G1H8(126),wf4(:,12),G1H2(29),m3h4x2(:,67),heltab2x8(:,:,131))
  call Hloop_Q_A(ntryL,G1H2(29),95,0,G2H2(19),n2h2(59))
  call Hloop_QV_A(ntryL,G1H8(127),wf4(:,12),G1H2(30),m3h4x2(:,68),heltab2x8(:,:,132))
  call Hloop_Q_A(ntryL,G1H2(30),95,0,G2H2(21),n2h2(60))
  call Hloop_QZ_A(ntryL,G1H8(137),wf4(:,14),G1H2(34),ngZd,m3h4x2(:,69),heltab2x8(:,:,133))
  call Hloop_Q_A(ntryL,G1H2(34),95,0,G2H2(22),n2h2(61))
  call Hloop_QZ_A(ntryL,G1H8(138),wf4(:,14),G1H2(35),ngZd,m3h4x2(:,70),heltab2x8(:,:,134))
  call Hloop_Q_A(ntryL,G1H2(35),95,0,G2H2(24),n2h2(62))
  call Hloop_QZ_A(ntryL,G1H8(142),wf4(:,14),G1H2(40),ngZd,m3h4x2(:,71),heltab2x8(:,:,135))
  call Hloop_Q_A(ntryL,G1H2(40),95,0,G2H2(38),n2h2(63))
  call Hloop_QZ_A(ntryL,G1H8(143),wf4(:,14),G1H2(41),ngZd,m3h4x2(:,72),heltab2x8(:,:,136))
  call Hloop_Q_A(ntryL,G1H2(41),95,0,G2H2(40),n2h2(64))
  call Hloop_QV_A(ntryL,G1H8(153),wf4(:,11),G1H2(45),m3h4x2(:,73),heltab2x8(:,:,137))
  call Hloop_Q_A(ntryL,G1H2(45),95,0,G2H2(48),n2h2(65))
  call Hloop_QV_A(ntryL,G1H8(154),wf4(:,11),G1H2(46),m3h4x2(:,74),heltab2x8(:,:,138))
  call Hloop_Q_A(ntryL,G1H2(46),95,0,G2H2(50),n2h2(66))
  call Hloop_QV_A(ntryL,G1H8(158),wf4(:,11),G1H2(51),m3h4x2(:,75),heltab2x8(:,:,139))
  call Hloop_Q_A(ntryL,G1H2(51),95,0,G2H2(58),n2h2(67))
  call Hloop_QV_A(ntryL,G1H8(159),wf4(:,11),G1H2(52),m3h4x2(:,76),heltab2x8(:,:,140))
  call Hloop_Q_A(ntryL,G1H2(52),95,0,G2H2(60),n2h2(68))
  call Hloop_QZ_A(ntryL,G1H8(169),wf4(:,16),G1H2(56),ngZd,m3h4x2(:,77),heltab2x8(:,:,141))
  call Hloop_Q_A(ntryL,G1H2(56),95,0,G2H2(68),n2h2(69))
  call Hloop_QZ_A(ntryL,G1H8(170),wf4(:,16),G1H2(57),ngZd,m3h4x2(:,78),heltab2x8(:,:,142))
  call Hloop_Q_A(ntryL,G1H2(57),95,0,G2H2(70),n2h2(70))
  call Hloop_QZ_A(ntryL,G1H8(174),wf4(:,16),G1H2(62),ngZd,m3h4x2(:,79),heltab2x8(:,:,143))
  call Hloop_Q_A(ntryL,G1H2(62),95,0,G2H2(73),n2h2(71))
  call Hloop_QZ_A(ntryL,G1H8(175),wf4(:,16),G1H2(63),ngZd,m3h4x2(:,80),heltab2x8(:,:,144))
  call Hloop_Q_A(ntryL,G1H2(63),95,0,G2H2(74),n2h2(72))
  call Hloop_QA_V(ntryL,G2H4(7),ex6(:),G2H2(75),m3h2x2(:,27),heltab2x4(:,:,59))
  call Hloop_QA_V(ntryL,G2H4(13),ex6(:),G2H2(76),m3h2x2(:,28),heltab2x4(:,:,60))
  call Hloop_AQ_V(ntryL,G2H4(16),ex5(:),G2H2(77),m3h2x2(:,29),heltab2x4(:,:,61))
  call Hloop_AQ_V(ntryL,G2H4(23),ex5(:),G2H2(78),m3h2x2(:,30),heltab2x4(:,:,62))
  call Hloop_QA_V(ntryL,G2H4(29),ex6(:),G2H2(79),m3h2x2(:,31),heltab2x4(:,:,63))
  call Hloop_QA_V(ntryL,G2H4(32),ex6(:),G2H2(80),m3h2x2(:,32),heltab2x4(:,:,64))
  call Hloop_AQ_V(ntryL,G2H4(39),ex5(:),G2H2(81),m3h2x2(:,33),heltab2x4(:,:,65))
  call Hloop_AQ_V(ntryL,G2H4(45),ex5(:),G2H2(82),m3h2x2(:,34),heltab2x4(:,:,66))
  call Hotf_4pt_reduction(G2H16(23),RedSet_4(54),mass4set(:,1),  & 
G1H16(25),G1H16(26),G1H16(28),G1H16(29),G1H16(30),G0H16(1),16)
  call HG1shiftOLR(G1H16(26),10,16)
  call Hotf_4pt_reduction(G2H16(16),RedSet_4(54),mass4set(:,2),  & 
G1H16(31),G1H16(32),G1H16(34),G1H16(35),G1H16(36),G0H16(2),16)
  call HG1shiftOLR(G1H16(32),10,16)
  call Hotf_4pt_reduction(G2H16(26),RedSet_4(54),mass4set(:,1),  & 
G1H16(37),G1H16(38),G1H16(40),G1H16(41),G1H16(42),G0H16(3),16)
  call HG1shiftOLR(G1H16(38),10,16)
  call Hotf_4pt_reduction(G2H16(20),RedSet_4(54),mass4set(:,2),  & 
G1H16(43),G1H16(44),G1H16(46),G1H16(47),G1H16(48),G0H16(4),16)
  call HG1shiftOLR(G1H16(44),10,16)
  call Hotf_4pt_reduction(G2H16(24),RedSet_4(54),mass4set(:,3),  & 
G1H16(49),G1H16(50),G1H16(52),G1H16(53),G1H16(54),G0H16(5),16)
  call HG1shiftOLR(G1H16(50),10,16)
  call Hotf_4pt_reduction(G2H16(28),RedSet_4(54),mass4set(:,3),  & 
G1H16(55),G1H16(56),G1H16(58),G1H16(59),G1H16(60),G0H16(6),16)
  call HG1shiftOLR(G1H16(56),10,16)
  call Hotf_4pt_reduction(G2H16(31),RedSet_4(54),mass4set(:,1),  & 
G1H16(61),G1H16(62),G1H16(64),G1H16(65),G1H16(66),G0H16(7),16)
  call HG1shiftOLR(G1H16(62),10,16)
  call Hotf_4pt_reduction(G2H16(32),RedSet_4(54),mass4set(:,2),  & 
G1H16(67),G1H16(68),G1H16(70),G1H16(71),G1H16(72),G0H16(8),16)
  call HG1shiftOLR(G1H16(68),10,16)
  call Hotf_4pt_reduction(G2H16(34),RedSet_4(54),mass4set(:,1),  & 
G1H16(73),G1H16(74),G1H16(76),G1H16(77),G1H16(78),G0H16(9),16)
  call HG1shiftOLR(G1H16(74),10,16)
  call Hotf_4pt_reduction(G2H16(36),RedSet_4(54),mass4set(:,2),  & 
G1H16(79),G1H16(80),G1H16(82),G1H16(83),G1H16(84),G0H16(10),16)
  call HG1shiftOLR(G1H16(80),10,16)
  call Hotf_4pt_reduction(G2H16(38),RedSet_4(54),mass4set(:,1),  & 
G1H16(85),G1H16(86),G1H16(88),G1H16(89),G1H16(90),G0H16(11),16)
  call HG1shiftOLR(G1H16(86),10,16)
  call Hotf_4pt_reduction(G2H16(40),RedSet_4(54),mass4set(:,3),  & 
G1H16(91),G1H16(92),G1H16(94),G1H16(95),G1H16(96),G0H16(12),16)
  call HG1shiftOLR(G1H16(92),10,16)
  call Hotf_4pt_reduction(G2H16(43),RedSet_4(54),mass4set(:,1),  & 
G1H16(3),G1H16(9),G1H16(15),G1H16(21),G1H16(27),G0H16(13),16)
  call HG1shiftOLR(G1H16(9),10,16)
  call Hotf_4pt_reduction(G2H16(44),RedSet_4(54),mass4set(:,3),  & 
G1H16(33),G1H16(39),G1H16(45),G1H16(51),G1H16(57),G0H16(14),16)
  call HG1shiftOLR(G1H16(39),10,16)
  call Hotf_4pt_reduction(G2H16(49),RedSet_4(7),mass4set(:,1),  & 
G1H16(63),G1H16(69),G1H16(75),G1H16(81),G1H16(87),G0H16(15),16)
  call HG1shiftOLR(G1H16(69),48,16)
  call Hotf_4pt_reduction(G2H16(27),RedSet_4(7),mass4set(:,2),  & 
G1H16(93),G1H16(20),G1H16(22),G1H16(23),G1H16(24),G0H16(16),16)
  call HG1shiftOLR(G1H16(20),48,16)
  call Hotf_4pt_reduction(G2H16(51),RedSet_4(7),mass4set(:,1),  & 
G1H16(1),G1H16(2),G1H16(4),G1H16(5),G1H16(6),G0H16(17),16)
  call HG1shiftOLR(G1H16(2),48,16)
  call Hotf_4pt_reduction(G2H16(30),RedSet_4(7),mass4set(:,2),  & 
G1H16(7),G1H16(8),G1H16(10),G1H16(11),G1H16(12),G0H16(18),16)
  call HG1shiftOLR(G1H16(8),48,16)
  call Hotf_4pt_reduction(G2H16(50),RedSet_4(7),mass4set(:,3),  & 
G1H16(13),G1H16(14),G1H16(16),G1H16(17),G1H16(18),G0H16(19),16)
  call HG1shiftOLR(G1H16(14),48,16)
  call Hotf_4pt_reduction(G2H16(52),RedSet_4(7),mass4set(:,3),  & 
G1H16(19),G1H16(97),G1H16(98),G1H16(99),G1H16(100),G0H16(20),16)
  call HG1shiftOLR(G1H16(97),48,16)
  call Hotf_4pt_reduction(G2H16(53),RedSet_4(7),mass4set(:,1),  & 
G1H16(101),G1H16(102),G1H16(103),G1H16(104),G1H16(105),G0H16(21),16)
  call HG1shiftOLR(G1H16(102),48,16)
  call Hotf_4pt_reduction(G2H16(54),RedSet_4(7),mass4set(:,2),  & 
G1H16(106),G1H16(107),G1H16(108),G1H16(109),G1H16(110),G0H16(22),16)
  call HG1shiftOLR(G1H16(107),48,16)
  call Hotf_4pt_reduction(G2H16(55),RedSet_4(7),mass4set(:,1),  & 
G1H16(111),G1H16(112),G1H16(113),G1H16(114),G1H16(115),G0H16(23),16)
  call HG1shiftOLR(G1H16(112),48,16)
  call Hotf_4pt_reduction(G2H16(56),RedSet_4(7),mass4set(:,2),  & 
G1H16(116),G1H16(117),G1H16(118),G1H16(119),G1H16(120),G0H16(24),16)
  call HG1shiftOLR(G1H16(117),48,16)
  call Hotf_4pt_reduction(G2H16(57),RedSet_4(7),mass4set(:,1),  & 
G1H16(121),G1H16(122),G1H16(123),G1H16(124),G1H16(125),G0H16(25),16)
  call HG1shiftOLR(G1H16(122),48,16)
  call Hotf_4pt_reduction(G2H16(58),RedSet_4(7),mass4set(:,3),  & 
G1H16(126),G1H16(127),G1H16(128),G1H16(129),G1H16(130),G0H16(26),16)
  call HG1shiftOLR(G1H16(127),48,16)
  call Hotf_4pt_reduction(G2H16(59),RedSet_4(7),mass4set(:,1),  & 
G1H16(131),G1H16(132),G1H16(133),G1H16(134),G1H16(135),G0H16(27),16)
  call HG1shiftOLR(G1H16(132),48,16)
  call Hotf_4pt_reduction(G2H16(60),RedSet_4(7),mass4set(:,3),  & 
G1H16(136),G1H16(137),G1H16(138),G1H16(139),G1H16(140),G0H16(28),16)
  call HG1shiftOLR(G1H16(137),48,16)
  call Hotf_4pt_reduction(G2H16(71),RedSet_4(6),mass4set(:,1),  & 
G1H16(141),G1H16(142),G1H16(143),G1H16(144),G1H16(145),G0H16(29),16)
  call HG1shiftOLR(G1H16(142),48,16)
  call Hotf_4pt_reduction(G2H16(68),RedSet_4(6),mass4set(:,2),  & 
G1H16(146),G1H16(147),G1H16(148),G1H16(149),G1H16(150),G0H16(30),16)
  call HG1shiftOLR(G1H16(147),48,16)
  call Hotf_4pt_reduction(G2H16(73),RedSet_4(6),mass4set(:,1),  & 
G1H16(151),G1H16(152),G1H16(153),G1H16(154),G1H16(155),G0H16(31),16)
  call HG1shiftOLR(G1H16(152),48,16)
  call Hotf_4pt_reduction(G2H16(70),RedSet_4(6),mass4set(:,2),  & 
G1H16(156),G1H16(157),G1H16(158),G1H16(159),G1H16(160),G0H16(32),16)
  call HG1shiftOLR(G1H16(157),48,16)
  call Hotf_4pt_reduction(G2H16(72),RedSet_4(6),mass4set(:,3),  & 
G1H16(161),G1H16(162),G1H16(163),G1H16(164),G1H16(165),G0H16(33),16)
  call HG1shiftOLR(G1H16(162),48,16)
  call Hotf_4pt_reduction(G2H16(74),RedSet_4(6),mass4set(:,3),  & 
G1H16(166),G1H16(167),G1H16(168),G1H16(169),G1H16(170),G0H16(34),16)
  call HG1shiftOLR(G1H16(167),48,16)
  call Hotf_4pt_reduction(G2H16(83),RedSet_4(6),mass4set(:,1),  & 
G1H16(171),G1H16(172),G1H16(173),G1H16(174),G1H16(175),G0H16(35),16)
  call HG1shiftOLR(G1H16(172),48,16)
  call Hotf_4pt_reduction(G2H16(84),RedSet_4(6),mass4set(:,2),  & 
G1H16(176),G1H16(177),G1H16(178),G1H16(179),G1H16(180),G0H16(36),16)
  call HG1shiftOLR(G1H16(177),48,16)
  call Hotf_4pt_reduction(G2H16(85),RedSet_4(6),mass4set(:,1),  & 
G1H16(181),G1H16(182),G1H16(183),G1H16(184),G1H16(185),G0H16(37),16)
  call HG1shiftOLR(G1H16(182),48,16)
  call Hotf_4pt_reduction(G2H16(86),RedSet_4(6),mass4set(:,2),  & 
G1H16(186),G1H16(187),G1H16(188),G1H16(189),G1H16(190),G0H16(38),16)
  call HG1shiftOLR(G1H16(187),48,16)
  call Hotf_4pt_reduction(G2H16(87),RedSet_4(6),mass4set(:,1),  & 
G1H16(191),G1H16(192),G1H16(193),G1H16(194),G1H16(195),G0H16(39),16)
  call HG1shiftOLR(G1H16(192),48,16)
  call Hotf_4pt_reduction(G2H16(88),RedSet_4(6),mass4set(:,3),  & 
G1H16(196),G1H16(197),G1H16(198),G1H16(199),G1H16(200),G0H16(40),16)
  call HG1shiftOLR(G1H16(197),48,16)
  call Hotf_4pt_reduction(G2H16(89),RedSet_4(6),mass4set(:,1),  & 
G1H16(201),G1H16(202),G1H16(203),G1H16(204),G1H16(205),G0H16(41),16)
  call HG1shiftOLR(G1H16(202),48,16)
  call Hotf_4pt_reduction(G2H16(90),RedSet_4(6),mass4set(:,3),  & 
G1H16(206),G1H16(207),G1H16(208),G1H16(209),G1H16(210),G0H16(42),16)
  call HG1shiftOLR(G1H16(207),48,16)
  call Hloop_AQ_V(ntryL,G2H16(92),wf8(:,10),G2H2(83),m3h8x2(:,1),heltab2x16(:,:,121))
  call Hloop_AQ_V(ntryL,G2H16(94),wf8(:,12),G2H2(84),m3h8x2(:,2),heltab2x16(:,:,122))
  call Hloop_QA_V(ntryL,G2H16(96),ex6(:),G2H8(17),m3h2x8(:,25),heltab2x16(:,:,123))
  call Hloop_QA_V(ntryL,G2H16(98),ex6(:),G2H8(19),m3h2x8(:,26),heltab2x16(:,:,124))
  call Hotf_4pt_reduction(G2H32(1),RedSet_4(3),mass4set(:,1),  & 
G1H32(3),G1H32(9),G1H32(15),G1H32(21),G1H32(27),32)
  call HG1shiftOLR(G1H32(9),37,32)
  call Hotf_4pt_reduction(G2H32(2),RedSet_4(3),mass4set(:,1),  & 
G1H32(33),G1H32(39),G1H32(45),G1H32(51),G1H32(57),32)
  call HG1shiftOLR(G1H32(39),37,32)
  call Hotf_4pt_reduction(G2H32(3),RedSet_4(3),mass4set(:,1),  & 
G1H32(63),G1H32(69),G1H32(75),G1H32(81),G1H32(87),32)
  call HG1shiftOLR(G1H32(69),37,32)
  call Hotf_4pt_reduction(G2H32(4),RedSet_4(3),mass4set(:,1),  & 
G1H32(93),G1H32(6),G1H32(7),G1H32(8),G1H32(10),32)
  call HG1shiftOLR(G1H32(6),37,32)
  call Hloop_QA_V(ntryL,G2H16(100),wf8(:,2),G2H2(85),m3h8x2(:,3),heltab2x16(:,:,125))
  call Hloop_QA_V(ntryL,G2H16(102),wf8(:,4),G2H2(86),m3h8x2(:,4),heltab2x16(:,:,126))
  call Hloop_AQ_V(ntryL,G2H16(104),ex5(:),G2H8(20),m3h2x8(:,27),heltab2x16(:,:,127))
  call Hloop_AQ_V(ntryL,G2H16(106),ex5(:),G2H8(21),m3h2x8(:,28),heltab2x16(:,:,128))
  call Hloop_AQ_V(ntryL,G2H16(109),wf8(:,14),G2H2(87),m3h8x2(:,5),heltab2x16(:,:,129))
  call Hloop_AQ_V(ntryL,G2H16(110),wf8(:,16),G2H2(88),m3h8x2(:,6),heltab2x16(:,:,130))
  call Hloop_QA_V(ntryL,G2H16(113),ex6(:),G2H8(23),m3h2x8(:,29),heltab2x16(:,:,131))
  call Hloop_QA_V(ntryL,G2H16(114),ex6(:),G2H8(24),m3h2x8(:,30),heltab2x16(:,:,132))
  call Hotf_4pt_reduction(G2H32(5),RedSet_4(2),mass4set(:,1),  & 
G1H32(1),G1H32(2),G1H32(4),G1H32(5),G1H32(25),32)
  call HG1shiftOLR(G1H32(2),42,32)
  call Hotf_4pt_reduction(G2H32(6),RedSet_4(2),mass4set(:,1),  & 
G1H32(26),G1H32(28),G1H32(29),G1H32(20),G1H32(22),32)
  call HG1shiftOLR(G1H32(28),42,32)
  call Hotf_4pt_reduction(G2H32(7),RedSet_4(2),mass4set(:,1),  & 
G1H32(23),G1H32(24),G1H32(11),G1H32(12),G1H32(13),32)
  call HG1shiftOLR(G1H32(24),42,32)
  call Hotf_4pt_reduction(G2H32(8),RedSet_4(2),mass4set(:,1),  & 
G1H32(14),G1H32(16),G1H32(17),G1H32(18),G1H32(19),32)
  call HG1shiftOLR(G1H32(16),42,32)
  call Hloop_QA_V(ntryL,G2H16(117),wf8(:,6),G2H2(89),m3h8x2(:,7),heltab2x16(:,:,133))
  call Hloop_QA_V(ntryL,G2H16(118),wf8(:,8),G2H2(90),m3h8x2(:,8),heltab2x16(:,:,134))
  call Hloop_AQ_V(ntryL,G2H16(121),ex5(:),G2H8(33),m3h2x8(:,31),heltab2x16(:,:,135))
  call Hloop_AQ_V(ntryL,G2H16(122),ex5(:),G2H8(35),m3h2x8(:,32),heltab2x16(:,:,136))
  call Hotf_4pt_reduction(G2H32(9),RedSet_4(1),mass4set(:,1),  & 
G1H32(40),G1H32(41),G1H32(42),G1H32(43),G1H32(44),32)
  call HG1shiftOLR(G1H32(41),32,32)
  call Hotf_4pt_reduction(G2H32(10),RedSet_4(1),mass4set(:,1),  & 
G1H32(46),G1H32(47),G1H32(48),G1H32(49),G1H32(50),32)
  call HG1shiftOLR(G1H32(47),32,32)
  call Hotf_4pt_reduction(G2H32(11),RedSet_4(1),mass4set(:,1),  & 
G1H32(52),G1H32(53),G1H32(54),G1H32(55),G1H32(56),32)
  call HG1shiftOLR(G1H32(53),32,32)
  call Hotf_4pt_reduction(G2H32(12),RedSet_4(1),mass4set(:,1),  & 
G1H32(58),G1H32(30),G1H32(31),G1H32(32),G1H32(34),32)
  call HG1shiftOLR(G1H32(30),32,32)
  call Hotf_4pt_reduction(G2H32(13),RedSet_4(1),mass4set(:,1),  & 
G1H32(35),G1H32(36),G1H32(37),G1H32(38),G1H32(59),32)
  call HG1shiftOLR(G1H32(36),32,32)
  call Hotf_4pt_reduction(G2H32(14),RedSet_4(1),mass4set(:,1),  & 
G1H32(60),G1H32(61),G1H32(62),G1H32(64),G1H32(65),32)
  call HG1shiftOLR(G1H32(61),32,32)
  call Hotf_4pt_reduction(G2H32(15),RedSet_4(1),mass4set(:,1),  & 
G1H32(66),G1H32(67),G1H32(68),G1H32(70),G1H32(71),32)
  call HG1shiftOLR(G1H32(67),32,32)
  call Hotf_4pt_reduction(G2H32(16),RedSet_4(1),mass4set(:,1),  & 
G1H32(72),G1H32(73),G1H32(74),G1H32(76),G1H32(77),32)
  call HG1shiftOLR(G1H32(73),32,32)
  call Hotf_4pt_reduction(G2H16(133),RedSet_4(61),mass4set(:,1),  & 
G1H16(211),G1H16(212),G1H16(213),G1H16(214),G1H16(215),G0H16(43),16)
  call HG1shiftOLR(G1H16(212),9,16)
  call Hotf_4pt_reduction(G2H16(130),RedSet_4(61),mass4set(:,2),  & 
G1H16(216),G1H16(217),G1H16(218),G1H16(219),G1H16(220),G0H16(44),16)
  call HG1shiftOLR(G1H16(217),9,16)
  call Hotf_4pt_reduction(G2H16(135),RedSet_4(61),mass4set(:,1),  & 
G1H16(221),G1H16(222),G1H16(223),G1H16(224),G1H16(225),G0H16(45),16)
  call HG1shiftOLR(G1H16(222),9,16)
  call Hotf_4pt_reduction(G2H16(132),RedSet_4(61),mass4set(:,2),  & 
G1H16(226),G1H16(227),G1H16(228),G1H16(229),G1H16(230),G0H16(46),16)
  call HG1shiftOLR(G1H16(227),9,16)
  call Hotf_4pt_reduction(G2H16(134),RedSet_4(61),mass4set(:,3),  & 
G1H16(231),G1H16(232),G1H16(233),G1H16(234),G1H16(235),G0H16(47),16)
  call HG1shiftOLR(G1H16(232),9,16)
  call Hotf_4pt_reduction(G2H16(136),RedSet_4(61),mass4set(:,3),  & 
G1H16(236),G1H16(237),G1H16(238),G1H16(239),G1H16(240),G0H16(48),16)
  call HG1shiftOLR(G1H16(237),9,16)
  call Hotf_4pt_reduction(G2H16(145),RedSet_4(61),mass4set(:,1),  & 
G1H16(241),G1H16(242),G1H16(243),G1H16(244),G1H16(245),G0H16(49),16)
  call HG1shiftOLR(G1H16(242),9,16)
  call Hotf_4pt_reduction(G2H16(146),RedSet_4(61),mass4set(:,2),  & 
G1H16(246),G1H16(247),G1H16(248),G1H16(249),G1H16(250),G0H16(50),16)
  call HG1shiftOLR(G1H16(247),9,16)
  call Hotf_4pt_reduction(G2H16(147),RedSet_4(61),mass4set(:,1),  & 
G1H16(251),G1H16(252),G1H16(253),G1H16(254),G1H16(255),G0H16(51),16)
  call HG1shiftOLR(G1H16(252),9,16)
  call Hotf_4pt_reduction(G2H16(148),RedSet_4(61),mass4set(:,2),  & 
G1H16(256),G1H16(257),G1H16(258),G1H16(259),G1H16(260),G0H16(52),16)
  call HG1shiftOLR(G1H16(257),9,16)
  call Hotf_4pt_reduction(G2H16(149),RedSet_4(61),mass4set(:,1),  & 
G1H16(261),G1H16(262),G1H16(263),G1H16(264),G1H16(265),G0H16(53),16)
  call HG1shiftOLR(G1H16(262),9,16)
  call Hotf_4pt_reduction(G2H16(150),RedSet_4(61),mass4set(:,3),  & 
G1H16(266),G1H16(267),G1H16(268),G1H16(269),G1H16(270),G0H16(54),16)
  call HG1shiftOLR(G1H16(267),9,16)
  call Hotf_4pt_reduction(G2H16(151),RedSet_4(61),mass4set(:,1),  & 
G1H16(271),G1H16(272),G1H16(273),G1H16(274),G1H16(275),G0H16(55),16)
  call HG1shiftOLR(G1H16(272),9,16)
  call Hotf_4pt_reduction(G2H16(152),RedSet_4(61),mass4set(:,3),  & 
G1H16(276),G1H16(277),G1H16(278),G1H16(279),G1H16(280),G0H16(56),16)
  call HG1shiftOLR(G1H16(277),9,16)
  call Hotf_4pt_reduction(G2H16(171),RedSet_4(9),mass4set(:,1),  & 
G1H16(281),G1H16(282),G1H16(283),G1H16(284),G1H16(285),G0H16(57),16)
  call HG1shiftOLR(G1H16(282),48,16)
  call Hotf_4pt_reduction(G2H16(168),RedSet_4(9),mass4set(:,2),  & 
G1H16(286),G1H16(287),G1H16(288),G1H16(289),G1H16(290),G0H16(58),16)
  call HG1shiftOLR(G1H16(287),48,16)
  call Hotf_4pt_reduction(G2H16(173),RedSet_4(9),mass4set(:,1),  & 
G1H16(291),G1H16(292),G1H16(293),G1H16(294),G1H16(295),G0H16(59),16)
  call HG1shiftOLR(G1H16(292),48,16)
  call Hotf_4pt_reduction(G2H16(170),RedSet_4(9),mass4set(:,2),  & 
G1H16(296),G1H16(297),G1H16(298),G1H16(299),G1H16(300),G0H16(60),16)
  call HG1shiftOLR(G1H16(297),48,16)
  call Hotf_4pt_reduction(G2H16(172),RedSet_4(9),mass4set(:,3),  & 
G1H16(301),G1H16(302),G1H16(303),G1H16(304),G1H16(305),G0H16(61),16)
  call HG1shiftOLR(G1H16(302),48,16)
  call Hotf_4pt_reduction(G2H16(174),RedSet_4(9),mass4set(:,3),  & 
G1H16(306),G1H16(307),G1H16(308),G1H16(309),G1H16(310),G0H16(62),16)
  call HG1shiftOLR(G1H16(307),48,16)
  call Hotf_4pt_reduction(G2H16(175),RedSet_4(9),mass4set(:,1),  & 
G1H16(311),G1H16(312),G1H16(313),G1H16(314),G1H16(315),G0H16(63),16)
  call HG1shiftOLR(G1H16(312),48,16)
  call Hotf_4pt_reduction(G2H16(176),RedSet_4(9),mass4set(:,2),  & 
G1H16(316),G1H16(317),G1H16(318),G1H16(319),G1H16(320),G0H16(64),16)
  call HG1shiftOLR(G1H16(317),48,16)
  call Hotf_4pt_reduction(G2H16(177),RedSet_4(9),mass4set(:,1),  & 
G1H16(321),G1H16(322),G1H16(323),G1H16(324),G1H16(325),G0H16(65),16)
  call HG1shiftOLR(G1H16(322),48,16)
  call Hotf_4pt_reduction(G2H16(178),RedSet_4(9),mass4set(:,2),  & 
G1H16(326),G1H16(327),G1H16(328),G1H16(329),G1H16(330),G0H16(66),16)
  call HG1shiftOLR(G1H16(327),48,16)
  call Hotf_4pt_reduction(G2H16(179),RedSet_4(9),mass4set(:,1),  & 
G1H16(331),G1H16(332),G1H16(333),G1H16(334),G1H16(335),G0H16(67),16)
  call HG1shiftOLR(G1H16(332),48,16)
  call Hotf_4pt_reduction(G2H16(180),RedSet_4(9),mass4set(:,3),  & 
G1H16(336),G1H16(337),G1H16(338),G1H16(339),G1H16(340),G0H16(68),16)
  call HG1shiftOLR(G1H16(337),48,16)
  call Hotf_4pt_reduction(G2H16(181),RedSet_4(9),mass4set(:,1),  & 
G1H16(341),G1H16(342),G1H16(343),G1H16(344),G1H16(345),G0H16(69),16)
  call HG1shiftOLR(G1H16(342),48,16)
  call Hotf_4pt_reduction(G2H16(182),RedSet_4(9),mass4set(:,3),  & 
G1H16(346),G1H16(347),G1H16(348),G1H16(349),G1H16(350),G0H16(70),16)
  call HG1shiftOLR(G1H16(347),48,16)
  call Hotf_4pt_reduction(G2H16(193),RedSet_4(8),mass4set(:,1),  & 
G1H16(351),G1H16(352),G1H16(353),G1H16(354),G1H16(355),G0H16(71),16)
  call HG1shiftOLR(G1H16(352),48,16)
  call Hotf_4pt_reduction(G2H16(190),RedSet_4(8),mass4set(:,2),  & 
G1H16(356),G1H16(357),G1H16(358),G1H16(359),G1H16(360),G0H16(72),16)
  call HG1shiftOLR(G1H16(357),48,16)
  call Hotf_4pt_reduction(G2H16(195),RedSet_4(8),mass4set(:,1),  & 
G1H16(361),G1H16(362),G1H16(363),G1H16(364),G1H16(365),G0H16(73),16)
  call HG1shiftOLR(G1H16(362),48,16)
  call Hotf_4pt_reduction(G2H16(192),RedSet_4(8),mass4set(:,2),  & 
G1H16(366),G1H16(367),G1H16(368),G1H16(369),G1H16(370),G0H16(74),16)
  call HG1shiftOLR(G1H16(367),48,16)
  call Hotf_4pt_reduction(G2H16(194),RedSet_4(8),mass4set(:,3),  & 
G1H16(371),G1H16(372),G1H16(373),G1H16(374),G1H16(375),G0H16(75),16)
  call HG1shiftOLR(G1H16(372),48,16)
  call Hotf_4pt_reduction(G2H16(196),RedSet_4(8),mass4set(:,3),  & 
G1H16(376),G1H16(377),G1H16(378),G1H16(379),G1H16(380),G0H16(76),16)
  call HG1shiftOLR(G1H16(377),48,16)
  call Hotf_4pt_reduction(G2H16(205),RedSet_4(8),mass4set(:,1),  & 
G1H16(381),G1H16(382),G1H16(383),G1H16(384),G1H16(385),G0H16(77),16)
  call HG1shiftOLR(G1H16(382),48,16)
  call Hotf_4pt_reduction(G2H16(206),RedSet_4(8),mass4set(:,2),  & 
G1H16(386),G1H16(387),G1H16(388),G1H16(389),G1H16(390),G0H16(78),16)
  call HG1shiftOLR(G1H16(387),48,16)
  call Hotf_4pt_reduction(G2H16(207),RedSet_4(8),mass4set(:,1),  & 
G1H16(391),G1H16(392),G1H16(393),G1H16(394),G1H16(395),G0H16(79),16)
  call HG1shiftOLR(G1H16(392),48,16)
  call Hotf_4pt_reduction(G2H16(208),RedSet_4(8),mass4set(:,2),  & 
G1H16(396),G1H16(397),G1H16(398),G1H16(399),G1H16(400),G0H16(80),16)
  call HG1shiftOLR(G1H16(397),48,16)
  call Hotf_4pt_reduction(G2H16(209),RedSet_4(8),mass4set(:,1),  & 
G1H16(401),G1H16(402),G1H16(403),G1H16(404),G1H16(405),G0H16(81),16)
  call HG1shiftOLR(G1H16(402),48,16)
  call Hotf_4pt_reduction(G2H16(210),RedSet_4(8),mass4set(:,3),  & 
G1H16(406),G1H16(407),G1H16(408),G1H16(409),G1H16(410),G0H16(82),16)
  call HG1shiftOLR(G1H16(407),48,16)
  call Hotf_4pt_reduction(G2H16(211),RedSet_4(8),mass4set(:,1),  & 
G1H16(411),G1H16(412),G1H16(413),G1H16(414),G1H16(415),G0H16(83),16)
  call HG1shiftOLR(G1H16(412),48,16)
  call Hotf_4pt_reduction(G2H16(212),RedSet_4(8),mass4set(:,3),  & 
G1H16(416),G1H16(417),G1H16(418),G1H16(419),G1H16(420),G0H16(84),16)
  call HG1shiftOLR(G1H16(417),48,16)
  call Hloop_AQ_V(ntryL,G2H16(214),wf8(:,40),G2H2(91),m3h8x2(:,9),heltab2x16(:,:,137))
  call Hloop_AQ_V(ntryL,G2H16(216),wf8(:,42),G2H2(92),m3h8x2(:,10),heltab2x16(:,:,138))
  call Hloop_QA_V(ntryL,G2H16(218),ex6(:),G2H8(57),m3h2x8(:,33),heltab2x16(:,:,139))
  call Hloop_QA_V(ntryL,G2H16(220),ex6(:),G2H8(59),m3h2x8(:,34),heltab2x16(:,:,140))
  call Hotf_4pt_reduction(G2H32(17),RedSet_4(5),mass4set(:,1),  & 
G1H32(78),G1H32(79),G1H32(80),G1H32(82),G1H32(83),32)
  call HG1shiftOLR(G1H32(79),41,32)
  call Hotf_4pt_reduction(G2H32(18),RedSet_4(5),mass4set(:,1),  & 
G1H32(84),G1H32(85),G1H32(86),G1H32(88),G1H32(89),32)
  call HG1shiftOLR(G1H32(85),41,32)
  call Hotf_4pt_reduction(G2H32(19),RedSet_4(5),mass4set(:,1),  & 
G1H32(90),G1H32(91),G1H32(92),G1H32(94),G1H32(95),32)
  call HG1shiftOLR(G1H32(91),41,32)
  call Hotf_4pt_reduction(G2H32(20),RedSet_4(5),mass4set(:,1),  & 
G1H32(96),G1H32(97),G1H32(98),G1H32(99),G1H32(100),32)
  call HG1shiftOLR(G1H32(97),41,32)
  call Hloop_QA_V(ntryL,G2H16(222),wf8(:,32),G2H2(93),m3h8x2(:,11),heltab2x16(:,:,141))
  call Hloop_QA_V(ntryL,G2H16(224),wf8(:,34),G2H2(94),m3h8x2(:,12),heltab2x16(:,:,142))
  call Hloop_AQ_V(ntryL,G2H16(226),ex5(:),G2H8(60),m3h2x8(:,35),heltab2x16(:,:,143))
  call Hloop_AQ_V(ntryL,G2H16(228),ex5(:),G2H8(61),m3h2x8(:,36),heltab2x16(:,:,144))
  call Hloop_AQ_V(ntryL,G2H16(231),wf8(:,44),G2H2(95),m3h8x2(:,13),heltab2x16(:,:,145))
  call Hloop_AQ_V(ntryL,G2H16(232),wf8(:,46),G2H2(96),m3h8x2(:,14),heltab2x16(:,:,146))
  call Hloop_QA_V(ntryL,G2H16(235),ex6(:),G2H8(36),m3h2x8(:,37),heltab2x16(:,:,147))
  call Hloop_QA_V(ntryL,G2H16(236),ex6(:),G2H8(43),m3h2x8(:,38),heltab2x16(:,:,148))
  call Hotf_4pt_reduction(G2H32(21),RedSet_4(4),mass4set(:,1),  & 
G1H32(101),G1H32(102),G1H32(103),G1H32(104),G1H32(105),32)
  call HG1shiftOLR(G1H32(102),38,32)
  call Hotf_4pt_reduction(G2H32(22),RedSet_4(4),mass4set(:,1),  & 
G1H32(106),G1H32(107),G1H32(108),G1H32(109),G1H32(110),32)
  call HG1shiftOLR(G1H32(107),38,32)
  call Hotf_4pt_reduction(G2H32(23),RedSet_4(4),mass4set(:,1),  & 
G1H32(111),G1H32(112),G1H32(113),G1H32(114),G1H32(115),32)
  call HG1shiftOLR(G1H32(112),38,32)
  call Hotf_4pt_reduction(G2H32(24),RedSet_4(4),mass4set(:,1),  & 
G1H32(116),G1H32(117),G1H32(118),G1H32(119),G1H32(120),32)
  call HG1shiftOLR(G1H32(117),38,32)
  call Hloop_QA_V(ntryL,G2H16(239),wf8(:,36),G2H2(97),m3h8x2(:,15),heltab2x16(:,:,149))
  call Hloop_QA_V(ntryL,G2H16(240),wf8(:,38),G2H2(98),m3h8x2(:,16),heltab2x16(:,:,150))
  call Hloop_AQ_V(ntryL,G2H16(243),ex5(:),G2H8(41),m3h2x8(:,39),heltab2x16(:,:,151))
  call Hloop_AQ_V(ntryL,G2H16(244),ex5(:),G2H8(44),m3h2x8(:,40),heltab2x16(:,:,152))
  call Hotf_4pt_reduction(G2H32(25),RedSet_4(1),mass4set(:,1),  & 
G1H32(121),G1H32(122),G1H32(123),G1H32(124),G1H32(125),32)
  call HG1shiftOLR(G1H32(122),32,32)
  call Hotf_4pt_reduction(G2H32(26),RedSet_4(1),mass4set(:,1),  & 
G1H32(126),G1H32(127),G1H32(128),G1H32(129),G1H32(130),32)
  call HG1shiftOLR(G1H32(127),32,32)
  call Hotf_4pt_reduction(G2H32(27),RedSet_4(1),mass4set(:,1),  & 
G1H32(131),G1H32(132),G1H32(133),G1H32(134),G1H32(135),32)
  call HG1shiftOLR(G1H32(132),32,32)
  call Hotf_4pt_reduction(G2H32(28),RedSet_4(1),mass4set(:,1),  & 
G1H32(136),G1H32(137),G1H32(138),G1H32(139),G1H32(140),32)
  call HG1shiftOLR(G1H32(137),32,32)
  call Hotf_4pt_reduction(G2H32(29),RedSet_4(1),mass4set(:,1),  & 
G1H32(141),G1H32(142),G1H32(143),G1H32(144),G1H32(145),32)
  call HG1shiftOLR(G1H32(142),32,32)
  call Hotf_4pt_reduction(G2H32(30),RedSet_4(1),mass4set(:,1),  & 
G1H32(146),G1H32(147),G1H32(148),G1H32(149),G1H32(150),32)
  call HG1shiftOLR(G1H32(147),32,32)
  call Hotf_4pt_reduction(G2H32(31),RedSet_4(1),mass4set(:,1),  & 
G1H32(151),G1H32(152),G1H32(153),G1H32(154),G1H32(155),32)
  call HG1shiftOLR(G1H32(152),32,32)
  call Hotf_4pt_reduction(G2H32(32),RedSet_4(1),mass4set(:,1),  & 
G1H32(156),G1H32(157),G1H32(158),G1H32(159),G1H32(160),32)
  call HG1shiftOLR(G1H32(157),32,32)
  call Hotf_4pt_reduction(G2H32(33),RedSet_4(1),mass4set(:,1),  & 
G1H32(161),G1H32(162),G1H32(163),G1H32(164),G1H32(165),32)
  call HG1shiftOLR(G1H32(162),32,32)
  call Hotf_4pt_reduction(G2H32(34),RedSet_4(1),mass4set(:,1),  & 
G1H32(166),G1H32(167),G1H32(168),G1H32(169),G1H32(170),32)
  call HG1shiftOLR(G1H32(167),32,32)
  call Hotf_4pt_reduction(G2H32(35),RedSet_4(1),mass4set(:,1),  & 
G1H32(171),G1H32(172),G1H32(173),G1H32(174),G1H32(175),32)
  call HG1shiftOLR(G1H32(172),32,32)
  call Hotf_4pt_reduction(G2H32(36),RedSet_4(1),mass4set(:,1),  & 
G1H32(176),G1H32(177),G1H32(178),G1H32(179),G1H32(180),32)
  call HG1shiftOLR(G1H32(177),32,32)
  call Hotf_4pt_reduction(G2H32(37),RedSet_4(1),mass4set(:,1),  & 
G1H32(181),G1H32(182),G1H32(183),G1H32(184),G1H32(185),32)
  call HG1shiftOLR(G1H32(182),32,32)
  call Hotf_4pt_reduction(G2H32(38),RedSet_4(1),mass4set(:,1),  & 
G1H32(186),G1H32(187),G1H32(188),G1H32(189),G1H32(190),32)
  call HG1shiftOLR(G1H32(187),32,32)
  call Hotf_4pt_reduction(G2H32(39),RedSet_4(1),mass4set(:,1),  & 
G1H32(191),G1H32(192),G1H32(193),G1H32(194),G1H32(195),32)
  call HG1shiftOLR(G1H32(192),32,32)
  call Hotf_4pt_reduction(G2H32(40),RedSet_4(1),mass4set(:,1),  & 
G1H32(196),G1H32(197),G1H32(198),G1H32(199),G1H32(200),32)
  call HG1shiftOLR(G1H32(197),32,32)
  call Hotf_4pt_reduction(G2H32(41),RedSet_4(1),mass4set(:,1),  & 
G1H32(201),G1H32(202),G1H32(203),G1H32(204),G1H32(205),32)
  call HG1shiftOLR(G1H32(202),32,32)
  call Hotf_4pt_reduction(G2H32(42),RedSet_4(1),mass4set(:,1),  & 
G1H32(206),G1H32(207),G1H32(208),G1H32(209),G1H32(210),32)
  call HG1shiftOLR(G1H32(207),32,32)
  call Hotf_4pt_reduction(G2H32(43),RedSet_4(1),mass4set(:,1),  & 
G1H32(211),G1H32(212),G1H32(213),G1H32(214),G1H32(215),32)
  call HG1shiftOLR(G1H32(212),32,32)
  call Hotf_4pt_reduction(G2H32(44),RedSet_4(1),mass4set(:,1),  & 
G1H32(216),G1H32(217),G1H32(218),G1H32(219),G1H32(220),32)
  call HG1shiftOLR(G1H32(217),32,32)
  call Hotf_4pt_reduction(G2H32(45),RedSet_4(1),mass4set(:,1),  & 
G1H32(221),G1H32(222),G1H32(223),G1H32(224),G1H32(225),32)
  call HG1shiftOLR(G1H32(222),32,32)
  call Hotf_4pt_reduction(G2H32(46),RedSet_4(1),mass4set(:,1),  & 
G1H32(226),G1H32(227),G1H32(228),G1H32(229),G1H32(230),32)
  call HG1shiftOLR(G1H32(227),32,32)
  call Hotf_4pt_reduction(G2H32(47),RedSet_4(1),mass4set(:,1),  & 
G1H32(231),G1H32(232),G1H32(233),G1H32(234),G1H32(235),32)
  call HG1shiftOLR(G1H32(232),32,32)
  call Hotf_4pt_reduction(G2H32(48),RedSet_4(1),mass4set(:,1),  & 
G1H32(236),G1H32(237),G1H32(238),G1H32(239),G1H32(240),32)
  call HG1shiftOLR(G1H32(237),32,32)
  call Hloop_QV_A(ntryL,G1H8(49),wf4(:,1),G1H2(67),m3h4x2(:,81),heltab2x8(:,:,145))
  call Hloop_Q_A(ntryL,G1H2(67),95,0,G2H2(99),n2h2(73))
call HGT_raise_alpha_OLR(G1H8(50),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(50),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(50),ex6(:),G1H4(91),m3h2x4(:,65),heltab2x8(:,:,146))
  call Hloop_QV_A(ntryL,G1H8(60),wf4(:,1),G1H2(68),m3h4x2(:,82),heltab2x8(:,:,147))
  call Hloop_Q_A(ntryL,G1H2(68),95,0,G2H2(100),n2h2(74))
  call Hloop_QV_A(ntryL,G1H8(56),wf4(:,1),G1H2(73),m3h4x2(:,83),heltab2x8(:,:,148))
  call Hloop_Q_A(ntryL,G1H2(73),95,0,G2H2(101),n2h2(75))
  call Hloop_QZ_A(ntryL,G1H8(59),wf4(:,8),G1H2(74),ngZd,m3h4x2(:,84),heltab2x8(:,:,149))
  call Hloop_Q_A(ntryL,G1H2(74),95,0,G2H2(102),n2h2(76))
call HGT_raise_alpha_OLR(G1H8(61),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(61),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(61),ex6(:),G1H4(92),m3h2x4(:,66),heltab2x8(:,:,150))
  call Hloop_QZ_A(ntryL,G1H8(65),wf4(:,8),G1H2(78),ngZd,m3h4x2(:,85),heltab2x8(:,:,151))
  call Hloop_Q_A(ntryL,G1H2(78),95,0,G2H2(103),n2h2(77))
  call Hloop_QZ_A(ntryL,G1H8(66),wf4(:,8),G1H2(79),ngZd,m3h4x2(:,86),heltab2x8(:,:,152))
  call Hloop_Q_A(ntryL,G1H2(79),95,0,G2H2(104),n2h2(78))
  call Hloop_QV_A(ntryL,G1H8(71),wf4(:,2),G1H2(84),m3h4x2(:,87),heltab2x8(:,:,153))
  call Hloop_Q_A(ntryL,G1H2(84),95,0,G2H2(105),n2h2(79))
call HGT_raise_alpha_OLR(G1H8(76),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(76),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(76),ex6(:),G1H4(97),m3h2x4(:,67),heltab2x8(:,:,154))
  call Hloop_QV_A(ntryL,G1H8(75),wf4(:,2),G1H2(85),m3h4x2(:,88),heltab2x8(:,:,155))
  call Hloop_Q_A(ntryL,G1H2(85),95,0,G2H2(106),n2h2(80))
  call Hloop_QV_A(ntryL,G1H8(77),wf4(:,2),G1H2(6),m3h4x2(:,89),heltab2x8(:,:,156))
  call Hloop_Q_A(ntryL,G1H2(6),95,0,G2H2(107),n2h2(81))
  call Hloop_QZ_A(ntryL,G1H8(80),wf4(:,6),G1H2(17),ngZd,m3h4x2(:,90),heltab2x8(:,:,157))
  call Hloop_Q_A(ntryL,G1H2(17),95,0,G2H2(108),n2h2(82))
call HGT_raise_alpha_OLR(G1H8(81),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(81),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(81),ex6(:),G1H4(98),m3h2x4(:,68),heltab2x8(:,:,158))
  call Hloop_QZ_A(ntryL,G1H8(87),wf4(:,6),G1H2(28),ngZd,m3h4x2(:,91),heltab2x8(:,:,159))
  call Hloop_Q_A(ntryL,G1H2(28),95,0,G2H2(109),n2h2(83))
  call Hloop_QZ_A(ntryL,G1H8(92),wf4(:,6),G1H2(39),ngZd,m3h4x2(:,92),heltab2x8(:,:,160))
  call Hloop_Q_A(ntryL,G1H2(39),95,0,G2H2(110),n2h2(84))
  call Hloop_AV_Q(ntryL,G1H8(88),wf4(:,1),G1H2(50),m3h4x2(:,93),heltab2x8(:,:,161))
  call Hloop_A_Q(ntryL,G1H2(50),111,0,G2H2(111),n2h2(85))
call HGT_raise_alpha_OLR(G1H8(91),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(91),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(91),ex5(:),G1H4(102),m3h2x4(:,69),heltab2x8(:,:,162))
  call Hloop_AV_Q(ntryL,G1H8(96),wf4(:,1),G1H2(61),m3h4x2(:,94),heltab2x8(:,:,163))
  call Hloop_A_Q(ntryL,G1H2(61),111,0,G2H2(112),n2h2(86))
  call Hloop_AV_Q(ntryL,G1H8(97),wf4(:,1),G1H2(72),m3h4x2(:,95),heltab2x8(:,:,164))
  call Hloop_A_Q(ntryL,G1H2(72),111,0,G2H2(113),n2h2(87))
  call Hloop_AZ_Q(ntryL,G1H8(98),wf4(:,8),G1H2(83),ngZd,m3h4x2(:,96),heltab2x8(:,:,165))
  call Hloop_A_Q(ntryL,G1H2(83),111,0,G2H2(114),n2h2(88))
call HGT_raise_alpha_OLR(G1H8(103),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(103),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(103),ex5(:),G1H4(103),m3h2x4(:,70),heltab2x8(:,:,166))
  call Hloop_AZ_Q(ntryL,G1H8(104),wf4(:,8),G1H2(1),ngZd,m3h4x2(:,97),heltab2x8(:,:,167))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(115),n2h2(89))
  call Hloop_AZ_Q(ntryL,G1H8(107),wf4(:,8),G1H2(2),ngZd,m3h4x2(:,98),heltab2x8(:,:,168))
  call Hloop_A_Q(ntryL,G1H2(2),111,0,G2H2(116),n2h2(90))
  call Hloop_AV_Q(ntryL,G1H8(109),wf4(:,2),G1H2(7),m3h4x2(:,99),heltab2x8(:,:,169))
  call Hloop_A_Q(ntryL,G1H2(7),111,0,G2H2(117),n2h2(91))
call HGT_raise_alpha_OLR(G1H8(112),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(112),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(112),ex5(:),G1H4(108),m3h2x4(:,71),heltab2x8(:,:,170))
  call Hloop_AV_Q(ntryL,G1H8(114),wf4(:,2),G1H2(8),m3h4x2(:,100),heltab2x8(:,:,171))
  call Hloop_A_Q(ntryL,G1H2(8),111,0,G2H2(118),n2h2(92))
  call Hloop_AV_Q(ntryL,G1H8(119),wf4(:,2),G1H2(12),m3h4x2(:,101),heltab2x8(:,:,172))
  call Hloop_A_Q(ntryL,G1H2(12),111,0,G2H2(119),n2h2(93))
  call Hloop_AZ_Q(ntryL,G1H8(124),wf4(:,6),G1H2(13),ngZd,m3h4x2(:,102),heltab2x8(:,:,173))
  call Hloop_A_Q(ntryL,G1H2(13),111,0,G2H2(120),n2h2(94))
call HGT_raise_alpha_OLR(G1H8(120),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(120),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(120),ex5(:),G1H4(109),m3h2x4(:,72),heltab2x8(:,:,174))
  call Hloop_AZ_Q(ntryL,G1H8(125),wf4(:,6),G1H2(18),ngZd,m3h4x2(:,103),heltab2x8(:,:,175))
  call Hloop_A_Q(ntryL,G1H2(18),111,0,G2H2(121),n2h2(95))
  call Hloop_AZ_Q(ntryL,G1H8(128),wf4(:,6),G1H2(19),ngZd,m3h4x2(:,104),heltab2x8(:,:,176))
  call Hloop_A_Q(ntryL,G1H2(19),111,0,G2H2(122),n2h2(96))
  call Hloop_QV_A(ntryL,G1H8(129),wf4(:,2),G1H2(23),m3h4x2(:,105),heltab2x8(:,:,177))
  call Hloop_Q_A(ntryL,G1H2(23),95,0,G2H2(123),n2h2(97))
call HGT_raise_alpha_OLR(G1H8(130),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(130),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(130),ex6(:),G1H4(30),m3h2x4(:,73),heltab2x8(:,:,178))
  call Hloop_QV_A(ntryL,G1H8(140),wf4(:,2),G1H2(24),m3h4x2(:,106),heltab2x8(:,:,179))
  call Hloop_Q_A(ntryL,G1H2(24),95,0,G2H2(124),n2h2(98))
  call Hloop_QV_A(ntryL,G1H8(136),wf4(:,2),G1H2(29),m3h4x2(:,107),heltab2x8(:,:,180))
  call Hloop_Q_A(ntryL,G1H2(29),95,0,G2H2(125),n2h2(99))
  call Hloop_QZ_A(ntryL,G1H8(139),wf4(:,6),G1H2(30),ngZd,m3h4x2(:,108),heltab2x8(:,:,181))
  call Hloop_Q_A(ntryL,G1H2(30),95,0,G2H2(126),n2h2(100))
call HGT_raise_alpha_OLR(G1H8(141),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(141),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(141),ex6(:),G1H4(41),m3h2x4(:,74),heltab2x8(:,:,182))
  call Hloop_QZ_A(ntryL,G1H8(145),wf4(:,6),G1H2(34),ngZd,m3h4x2(:,109),heltab2x8(:,:,183))
  call Hloop_Q_A(ntryL,G1H2(34),95,0,G2H2(127),n2h2(101))
  call Hloop_QZ_A(ntryL,G1H8(146),wf4(:,6),G1H2(35),ngZd,m3h4x2(:,110),heltab2x8(:,:,184))
  call Hloop_Q_A(ntryL,G1H2(35),95,0,G2H2(128),n2h2(102))
  call Hloop_QV_A(ntryL,G1H8(151),wf4(:,1),G1H2(40),m3h4x2(:,111),heltab2x8(:,:,185))
  call Hloop_Q_A(ntryL,G1H2(40),95,0,G2H2(129),n2h2(103))
call HGT_raise_alpha_OLR(G1H8(156),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(156),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(156),ex6(:),G1H4(52),m3h2x4(:,75),heltab2x8(:,:,186))
  call Hloop_QV_A(ntryL,G1H8(155),wf4(:,1),G1H2(41),m3h4x2(:,112),heltab2x8(:,:,187))
  call Hloop_Q_A(ntryL,G1H2(41),95,0,G2H2(130),n2h2(104))
  call Hloop_QV_A(ntryL,G1H8(157),wf4(:,1),G1H2(45),m3h4x2(:,113),heltab2x8(:,:,188))
  call Hloop_Q_A(ntryL,G1H2(45),95,0,G2H2(131),n2h2(105))
  call Hloop_QZ_A(ntryL,G1H8(160),wf4(:,8),G1H2(46),ngZd,m3h4x2(:,114),heltab2x8(:,:,189))
  call Hloop_Q_A(ntryL,G1H2(46),95,0,G2H2(132),n2h2(106))
call HGT_raise_alpha_OLR(G1H8(161),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(161),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(161),ex6(:),G1H4(63),m3h2x4(:,76),heltab2x8(:,:,190))
  call Hloop_QZ_A(ntryL,G1H8(167),wf4(:,8),G1H2(51),ngZd,m3h4x2(:,115),heltab2x8(:,:,191))
  call Hloop_Q_A(ntryL,G1H2(51),95,0,G2H2(133),n2h2(107))
  call Hloop_QZ_A(ntryL,G1H8(172),wf4(:,8),G1H2(52),ngZd,m3h4x2(:,116),heltab2x8(:,:,192))
  call Hloop_Q_A(ntryL,G1H2(52),95,0,G2H2(134),n2h2(108))
  call Hloop_QV_A(ntryL,G1H8(168),wf4(:,11),G1H2(56),m3h4x2(:,117),heltab2x8(:,:,193))
  call Hloop_Q_A(ntryL,G1H2(56),95,0,G2H2(135),n2h2(109))
call HGT_raise_alpha_OLR(G1H8(171),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(171),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(171),ex6(:),G1H4(74),m3h2x4(:,77),heltab2x8(:,:,194))
  call Hloop_QV_A(ntryL,G1H8(176),wf4(:,11),G1H2(57),m3h4x2(:,118),heltab2x8(:,:,195))
  call Hloop_Q_A(ntryL,G1H2(57),95,0,G2H2(136),n2h2(110))
  call Hloop_QV_A(ntryL,G1H8(53),wf4(:,11),G1H2(62),m3h4x2(:,119),heltab2x8(:,:,196))
  call Hloop_Q_A(ntryL,G1H2(62),95,0,G2H2(137),n2h2(111))
  call Hloop_QZ_A(ntryL,G1H8(54),wf4(:,16),G1H2(63),ngZd,m3h4x2(:,120),heltab2x8(:,:,197))
  call Hloop_Q_A(ntryL,G1H2(63),95,0,G2H2(138),n2h2(112))
call HGT_raise_alpha_OLR(G1H8(69),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(69),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(69),ex6(:),G1H4(85),m3h2x4(:,78),heltab2x8(:,:,198))
  call Hloop_QZ_A(ntryL,G1H8(85),wf4(:,16),G1H2(67),ngZd,m3h4x2(:,121),heltab2x8(:,:,199))
  call Hloop_Q_A(ntryL,G1H2(67),95,0,G2H2(139),n2h2(113))
  call Hloop_QZ_A(ntryL,G1H8(86),wf4(:,16),G1H2(68),ngZd,m3h4x2(:,122),heltab2x8(:,:,200))
  call Hloop_Q_A(ntryL,G1H2(68),95,0,G2H2(140),n2h2(114))
  call Hloop_QV_A(ntryL,G1H8(101),wf4(:,12),G1H2(73),m3h4x2(:,123),heltab2x8(:,:,201))
  call Hloop_Q_A(ntryL,G1H2(73),95,0,G2H2(141),n2h2(115))
call HGT_raise_alpha_OLR(G1H8(102),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(102),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(102),ex6(:),G1H4(96),m3h2x4(:,79),heltab2x8(:,:,202))
  call Hloop_QV_A(ntryL,G1H8(118),wf4(:,12),G1H2(74),m3h4x2(:,124),heltab2x8(:,:,203))
  call Hloop_Q_A(ntryL,G1H2(74),95,0,G2H2(142),n2h2(116))
  call Hloop_QV_A(ntryL,G1H8(133),wf4(:,12),G1H2(78),m3h4x2(:,125),heltab2x8(:,:,204))
  call Hloop_Q_A(ntryL,G1H2(78),95,0,G2H2(143),n2h2(117))
  call Hloop_QZ_A(ntryL,G1H8(134),wf4(:,14),G1H2(79),ngZd,m3h4x2(:,126),heltab2x8(:,:,205))
  call Hloop_Q_A(ntryL,G1H2(79),95,0,G2H2(144),n2h2(118))
call HGT_raise_alpha_OLR(G1H8(149),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(149),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(149),ex6(:),G1H4(107),m3h2x4(:,80),heltab2x8(:,:,206))
  call Hloop_QZ_A(ntryL,G1H8(165),wf4(:,14),G1H2(84),ngZd,m3h4x2(:,127),heltab2x8(:,:,207))
  call Hloop_Q_A(ntryL,G1H2(84),95,0,G2H2(145),n2h2(119))
  call Hloop_QZ_A(ntryL,G1H8(166),wf4(:,14),G1H2(85),ngZd,m3h4x2(:,128),heltab2x8(:,:,208))
  call Hloop_Q_A(ntryL,G1H2(85),95,0,G2H2(146),n2h2(120))
  call Hloop_AV_Q(ntryL,G1H8(1),wf4(:,11),G1H2(6),m3h4x2(:,129),heltab2x8(:,:,209))
  call Hloop_A_Q(ntryL,G1H2(6),111,0,G2H2(147),n2h2(121))
call HGT_raise_alpha_OLR(G1H8(2),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(2),ex5(:),G1H4(25),m3h2x4(:,81),heltab2x8(:,:,210))
  call Hloop_AV_Q(ntryL,G1H8(6),wf4(:,11),G1H2(17),m3h4x2(:,130),heltab2x8(:,:,211))
  call Hloop_A_Q(ntryL,G1H2(17),111,0,G2H2(148),n2h2(122))
  call Hloop_AV_Q(ntryL,G1H8(7),wf4(:,11),G1H2(28),m3h4x2(:,131),heltab2x8(:,:,212))
  call Hloop_A_Q(ntryL,G1H2(28),111,0,G2H2(149),n2h2(123))
  call Hloop_AZ_Q(ntryL,G1H8(8),wf4(:,16),G1H2(39),ngZd,m3h4x2(:,132),heltab2x8(:,:,213))
  call Hloop_A_Q(ntryL,G1H2(39),111,0,G2H2(150),n2h2(124))
call HGT_raise_alpha_OLR(G1H8(11),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(11),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(11),ex5(:),G1H4(26),m3h2x4(:,82),heltab2x8(:,:,214))
  call Hloop_AZ_Q(ntryL,G1H8(13),wf4(:,16),G1H2(50),ngZd,m3h4x2(:,133),heltab2x8(:,:,215))
  call Hloop_A_Q(ntryL,G1H2(50),111,0,G2H2(151),n2h2(125))
  call Hloop_AZ_Q(ntryL,G1H8(14),wf4(:,16),G1H2(61),ngZd,m3h4x2(:,134),heltab2x8(:,:,216))
  call Hloop_A_Q(ntryL,G1H2(61),111,0,G2H2(152),n2h2(126))
  call Hloop_AV_Q(ntryL,G1H8(17),wf4(:,12),G1H2(72),m3h4x2(:,135),heltab2x8(:,:,217))
  call Hloop_A_Q(ntryL,G1H2(72),111,0,G2H2(153),n2h2(127))
call HGT_raise_alpha_OLR(G1H8(18),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(18),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(18),ex5(:),G1H4(31),m3h2x4(:,83),heltab2x8(:,:,218))
  call Hloop_AV_Q(ntryL,G1H8(20),wf4(:,12),G1H2(83),m3h4x2(:,136),heltab2x8(:,:,219))
  call Hloop_A_Q(ntryL,G1H2(83),111,0,G2H2(154),n2h2(128))
  call Hloop_AV_Q(ntryL,G1H8(23),wf4(:,12),G1H2(1),m3h4x2(:,137),heltab2x8(:,:,220))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(155),n2h2(129))
  call Hloop_AZ_Q(ntryL,G1H8(24),wf4(:,14),G1H2(2),ngZd,m3h4x2(:,138),heltab2x8(:,:,221))
  call Hloop_A_Q(ntryL,G1H2(2),111,0,G2H2(156),n2h2(130))
call HGT_raise_alpha_OLR(G1H8(25),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(25),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(25),ex5(:),G1H4(32),m3h2x4(:,84),heltab2x8(:,:,222))
  call Hloop_AZ_Q(ntryL,G1H8(29),wf4(:,14),G1H2(7),ngZd,m3h4x2(:,139),heltab2x8(:,:,223))
  call Hloop_A_Q(ntryL,G1H2(7),111,0,G2H2(157),n2h2(131))
  call Hloop_AZ_Q(ntryL,G1H8(30),wf4(:,14),G1H2(8),ngZd,m3h4x2(:,140),heltab2x8(:,:,224))
  call Hloop_A_Q(ntryL,G1H2(8),111,0,G2H2(158),n2h2(132))
  call Hloop_QV_A(ntryL,G1H8(31),wf4(:,12),G1H2(12),m3h4x2(:,141),heltab2x8(:,:,225))
  call Hloop_Q_A(ntryL,G1H2(12),95,0,G2H2(159),n2h2(133))
call HGT_raise_alpha_OLR(G1H8(32),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(32),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(32),ex6(:),G1H4(36),m3h2x4(:,85),heltab2x8(:,:,226))
  call Hloop_QV_A(ntryL,G1H8(36),wf4(:,12),G1H2(13),m3h4x2(:,142),heltab2x8(:,:,227))
  call Hloop_Q_A(ntryL,G1H2(13),95,0,G2H2(160),n2h2(134))
  call Hloop_QV_A(ntryL,G1H8(37),wf4(:,12),G1H2(18),m3h4x2(:,143),heltab2x8(:,:,228))
  call Hloop_Q_A(ntryL,G1H2(18),95,0,G2H2(161),n2h2(135))
  call Hloop_QZ_A(ntryL,G1H8(38),wf4(:,14),G1H2(19),ngZd,m3h4x2(:,144),heltab2x8(:,:,229))
  call Hloop_Q_A(ntryL,G1H2(19),95,0,G2H2(162),n2h2(136))
call HGT_raise_alpha_OLR(G1H8(41),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(41),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(41),ex6(:),G1H4(37),m3h2x4(:,86),heltab2x8(:,:,230))
  call Hloop_QZ_A(ntryL,G1H8(43),wf4(:,14),G1H2(23),ngZd,m3h4x2(:,145),heltab2x8(:,:,231))
  call Hloop_Q_A(ntryL,G1H2(23),95,0,G2H2(163),n2h2(137))
  call Hloop_QZ_A(ntryL,G1H8(44),wf4(:,14),G1H2(24),ngZd,m3h4x2(:,146),heltab2x8(:,:,232))
  call Hloop_Q_A(ntryL,G1H2(24),95,0,G2H2(164),n2h2(138))
  call Hloop_QV_A(ntryL,G1H8(47),wf4(:,11),G1H2(29),m3h4x2(:,147),heltab2x8(:,:,233))
  call Hloop_Q_A(ntryL,G1H2(29),95,0,G2H2(165),n2h2(139))
call HGT_raise_alpha_OLR(G1H8(48),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(48),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(48),ex6(:),G1H4(42),m3h2x4(:,87),heltab2x8(:,:,234))
  call Hloop_QV_A(ntryL,G1H8(99),wf4(:,11),G1H2(30),m3h4x2(:,148),heltab2x8(:,:,235))
  call Hloop_Q_A(ntryL,G1H2(30),95,0,G2H2(166),n2h2(140))
  call Hloop_QV_A(ntryL,G1H8(51),wf4(:,11),G1H2(34),m3h4x2(:,149),heltab2x8(:,:,236))
  call Hloop_Q_A(ntryL,G1H2(34),95,0,G2H2(167),n2h2(141))
  call Hloop_QZ_A(ntryL,G1H8(67),wf4(:,16),G1H2(35),ngZd,m3h4x2(:,150),heltab2x8(:,:,237))
  call Hloop_Q_A(ntryL,G1H2(35),95,0,G2H2(168),n2h2(142))
call HGT_raise_alpha_OLR(G1H8(52),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(52),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(52),ex6(:),G1H4(43),m3h2x4(:,88),heltab2x8(:,:,238))
  call Hloop_QZ_A(ntryL,G1H8(84),wf4(:,16),G1H2(40),ngZd,m3h4x2(:,151),heltab2x8(:,:,239))
  call Hloop_Q_A(ntryL,G1H2(40),95,0,G2H2(169),n2h2(143))
  call Hloop_QZ_A(ntryL,G1H8(100),wf4(:,16),G1H2(41),ngZd,m3h4x2(:,152),heltab2x8(:,:,240))
  call Hloop_Q_A(ntryL,G1H2(41),95,0,G2H2(170),n2h2(144))
  call Hloop_AV_Q(ntryL,G1H16(25),wf4(:,17),G1H4(47),m3h4x4(:,97),heltab2x16(:,:,153))
  call Hloop_A_Q(ntryL,G1H4(47),117,0,G2H4(42),n2h4(201))
call HGT_OLR(G1H16(26),1,1,16)
call HGT_invQ_OLR(G1H16(26),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(26),-10,0,G2H16(15),n2h16(309))
  call Hloop_QV_A(ntryL,G2H16(15),wf4(:,2),G2H4(38),m3h4x4(:,98),heltab2x16(:,:,154))
  call Hloop_AV_Q(ntryL,G1H16(29),wf4(:,17),G1H4(48),m3h4x4(:,99),heltab2x16(:,:,155))
  call Hloop_A_Q(ntryL,G1H4(48),117,0,G2H4(34),n2h4(202))
  call Hloop_AV_Q(ntryL,G1H16(30),wf4(:,17),G1H4(53),m3h4x4(:,100),heltab2x16(:,:,156))
  call Hloop_A_Q(ntryL,G1H4(53),117,0,G2H4(14),n2h4(203))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,17),G0H4(1),m3h4x4(:,101),heltab2x16(:,:,157))
  call Hloop_A_Q(ntryL,G0H4(1),117,0,G1H4(54),n2h4(204))
  call Hloop_AV_Q(ntryL,G1H16(31),wf4(:,17),G1H4(58),m3h4x4(:,102),heltab2x16(:,:,158))
  call Hloop_A_Q(ntryL,G1H4(58),117,nMT,G2H4(10),n2h4(205))
call HGT_OLR(G1H16(32),1,1,16)
call HGT_invQ_OLR(G1H16(32),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(32),-10,nMT,G2H16(33),n2h16(310))
  call Hloop_QV_A(ntryL,G2H16(33),wf4(:,2),G2H4(6),m3h4x4(:,103),heltab2x16(:,:,159))
  call Hloop_AV_Q(ntryL,G1H16(35),wf4(:,17),G1H4(59),m3h4x4(:,104),heltab2x16(:,:,160))
  call Hloop_A_Q(ntryL,G1H4(59),117,nMT,G2H4(2),n2h4(206))
  call Hloop_AV_Q(ntryL,G1H16(36),wf4(:,17),G1H4(64),m3h4x4(:,105),heltab2x16(:,:,161))
  call Hloop_A_Q(ntryL,G1H4(64),117,nMT,G2H4(103),n2h4(207))
  call Hloop_AV_Q(ntryL,G0H16(2),wf4(:,17),G0H4(1),m3h4x4(:,106),heltab2x16(:,:,162))
  call Hloop_A_Q(ntryL,G0H4(1),117,nMT,G1H4(65),n2h4(208))
  call Hloop_QV_A(ntryL,G1H16(37),wf4(:,17),G1H4(69),m3h4x4(:,107),heltab2x16(:,:,163))
  call Hloop_Q_A(ntryL,G1H4(69),117,0,G2H4(102),n2h4(209))
call HGT_OLR(G1H16(38),1,1,16)
call HGT_invQ_OLR(G1H16(38),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(38),-10,0,G2H16(35),n2h16(311))
  call Hloop_AV_Q(ntryL,G2H16(35),wf4(:,2),G2H4(101),m3h4x4(:,108),heltab2x16(:,:,164))
  call Hloop_QV_A(ntryL,G1H16(41),wf4(:,17),G1H4(70),m3h4x4(:,109),heltab2x16(:,:,165))
  call Hloop_Q_A(ntryL,G1H4(70),117,0,G2H4(96),n2h4(210))
  call Hloop_QV_A(ntryL,G1H16(42),wf4(:,17),G1H4(75),m3h4x4(:,110),heltab2x16(:,:,166))
  call Hloop_Q_A(ntryL,G1H4(75),117,0,G2H4(95),n2h4(211))
  call Hloop_QV_A(ntryL,G0H16(3),wf4(:,17),G0H4(1),m3h4x4(:,111),heltab2x16(:,:,167))
  call Hloop_Q_A(ntryL,G0H4(1),117,0,G1H4(76),n2h4(212))
  call Hloop_QV_A(ntryL,G1H16(43),wf4(:,17),G1H4(80),m3h4x4(:,112),heltab2x16(:,:,168))
  call Hloop_Q_A(ntryL,G1H4(80),117,nMT,G2H4(94),n2h4(213))
call HGT_OLR(G1H16(44),1,1,16)
call HGT_invQ_OLR(G1H16(44),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(44),-10,nMT,G2H16(19),n2h16(312))
  call Hloop_AV_Q(ntryL,G2H16(19),wf4(:,2),G2H4(93),m3h4x4(:,113),heltab2x16(:,:,169))
  call Hloop_QV_A(ntryL,G1H16(47),wf4(:,17),G1H4(81),m3h4x4(:,114),heltab2x16(:,:,170))
  call Hloop_Q_A(ntryL,G1H4(81),117,nMT,G2H4(88),n2h4(214))
  call Hloop_QV_A(ntryL,G1H16(48),wf4(:,17),G1H4(86),m3h4x4(:,115),heltab2x16(:,:,171))
  call Hloop_Q_A(ntryL,G1H4(86),117,nMT,G2H4(87),n2h4(215))
  call Hloop_QV_A(ntryL,G0H16(4),wf4(:,17),G0H4(1),m3h4x4(:,116),heltab2x16(:,:,172))
  call Hloop_Q_A(ntryL,G0H4(1),117,nMT,G1H4(87),n2h4(216))
  call Hloop_AV_Q(ntryL,G1H16(49),wf4(:,17),G1H4(47),m3h4x4(:,117),heltab2x16(:,:,173))
  call Hloop_A_Q(ntryL,G1H4(47),117,nMB,G2H4(86),n2h4(217))
call HGT_OLR(G1H16(50),1,1,16)
call HGT_invQ_OLR(G1H16(50),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(50),-10,nMB,G2H16(37),n2h16(313))
  call Hloop_QV_A(ntryL,G2H16(37),wf4(:,2),G2H4(85),m3h4x4(:,118),heltab2x16(:,:,174))
  call Hloop_AV_Q(ntryL,G1H16(53),wf4(:,17),G1H4(48),m3h4x4(:,119),heltab2x16(:,:,175))
  call Hloop_A_Q(ntryL,G1H4(48),117,nMB,G2H4(80),n2h4(218))
  call Hloop_AV_Q(ntryL,G1H16(54),wf4(:,17),G1H4(53),m3h4x4(:,120),heltab2x16(:,:,176))
  call Hloop_A_Q(ntryL,G1H4(53),117,nMB,G2H4(79),n2h4(219))
  call Hloop_AV_Q(ntryL,G0H16(5),wf4(:,17),G0H4(1),m3h4x4(:,121),heltab2x16(:,:,177))
  call Hloop_A_Q(ntryL,G0H4(1),117,nMB,G1H4(58),n2h4(220))
  call Hloop_QV_A(ntryL,G1H16(55),wf4(:,17),G1H4(59),m3h4x4(:,122),heltab2x16(:,:,178))
  call Hloop_Q_A(ntryL,G1H4(59),117,nMB,G2H4(78),n2h4(221))
call HGT_OLR(G1H16(56),1,1,16)
call HGT_invQ_OLR(G1H16(56),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(56),-10,nMB,G2H16(39),n2h16(314))
  call Hloop_AV_Q(ntryL,G2H16(39),wf4(:,2),G2H4(77),m3h4x4(:,123),heltab2x16(:,:,179))
  call Hloop_QV_A(ntryL,G1H16(59),wf4(:,17),G1H4(64),m3h4x4(:,124),heltab2x16(:,:,180))
  call Hloop_Q_A(ntryL,G1H4(64),117,nMB,G2H4(72),n2h4(222))
  call Hloop_QV_A(ntryL,G1H16(60),wf4(:,17),G1H4(69),m3h4x4(:,125),heltab2x16(:,:,181))
  call Hloop_Q_A(ntryL,G1H4(69),117,nMB,G2H4(71),n2h4(223))
  call Hloop_QV_A(ntryL,G0H16(6),wf4(:,17),G0H4(1),m3h4x4(:,126),heltab2x16(:,:,182))
  call Hloop_Q_A(ntryL,G0H4(1),117,nMB,G1H4(70),n2h4(224))
  call Hloop_AV_Q(ntryL,G1H16(61),wf4(:,17),G1H4(75),m3h4x4(:,127),heltab2x16(:,:,183))
  call Hloop_A_Q(ntryL,G1H4(75),117,0,G2H4(70),n2h4(225))
call HGT_OLR(G1H16(62),1,1,16)
call HGT_invQ_OLR(G1H16(62),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(62),-10,0,G2H16(41),n2h16(315))
  call Hloop_QZ_A(ntryL,G2H16(41),wf4(:,6),G2H4(69),ngZu,m3h4x4(:,128),heltab2x16(:,:,184))
  call Hloop_AV_Q(ntryL,G1H16(65),wf4(:,17),G1H4(80),m3h4x4(:,129),heltab2x16(:,:,185))
  call Hloop_A_Q(ntryL,G1H4(80),117,0,G2H4(60),n2h4(226))
  call Hloop_AV_Q(ntryL,G1H16(66),wf4(:,17),G1H4(81),m3h4x4(:,130),heltab2x16(:,:,186))
  call Hloop_A_Q(ntryL,G1H4(81),117,0,G2H4(57),n2h4(227))
  call Hloop_AV_Q(ntryL,G0H16(7),wf4(:,17),G0H4(1),m3h4x4(:,131),heltab2x16(:,:,187))
  call Hloop_A_Q(ntryL,G0H4(1),117,0,G1H4(86),n2h4(228))
  call Hloop_AV_Q(ntryL,G1H16(67),wf4(:,17),G1H4(47),m3h4x4(:,132),heltab2x16(:,:,188))
  call Hloop_A_Q(ntryL,G1H4(47),117,nMT,G2H4(52),n2h4(229))
call HGT_OLR(G1H16(68),1,1,16)
call HGT_invQ_OLR(G1H16(68),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(68),-10,nMT,G2H16(42),n2h16(316))
  call Hloop_QZ_A(ntryL,G2H16(42),wf4(:,6),G2H4(49),ngZu,m3h4x4(:,133),heltab2x16(:,:,189))
  call Hloop_AV_Q(ntryL,G1H16(71),wf4(:,17),G1H4(48),m3h4x4(:,134),heltab2x16(:,:,190))
  call Hloop_A_Q(ntryL,G1H4(48),117,nMT,G2H4(28),n2h4(230))
  call Hloop_AV_Q(ntryL,G1H16(72),wf4(:,17),G1H4(53),m3h4x4(:,135),heltab2x16(:,:,191))
  call Hloop_A_Q(ntryL,G1H4(53),117,nMT,G2H4(25),n2h4(231))
  call Hloop_AV_Q(ntryL,G0H16(8),wf4(:,17),G0H4(1),m3h4x4(:,136),heltab2x16(:,:,192))
  call Hloop_A_Q(ntryL,G0H4(1),117,nMT,G1H4(59),n2h4(232))
  call Hloop_QV_A(ntryL,G1H16(73),wf4(:,17),G1H4(64),m3h4x4(:,137),heltab2x16(:,:,193))
  call Hloop_Q_A(ntryL,G1H4(64),117,0,G2H4(20),n2h4(233))
call HGT_OLR(G1H16(74),1,1,16)
call HGT_invQ_OLR(G1H16(74),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(74),-10,0,G2H16(45),n2h16(317))
  call Hloop_AZ_Q(ntryL,G2H16(45),wf4(:,6),G2H4(17),ngZu,m3h4x4(:,138),heltab2x16(:,:,194))
  call Hloop_QV_A(ntryL,G1H16(77),wf4(:,17),G1H4(69),m3h4x4(:,139),heltab2x16(:,:,195))
  call Hloop_Q_A(ntryL,G1H4(69),117,0,G2H4(64),n2h4(234))
  call Hloop_QV_A(ntryL,G1H16(78),wf4(:,17),G1H4(75),m3h4x4(:,140),heltab2x16(:,:,196))
  call Hloop_Q_A(ntryL,G1H4(75),117,0,G2H4(63),n2h4(235))
  call Hloop_QV_A(ntryL,G0H16(9),wf4(:,17),G0H4(1),m3h4x4(:,141),heltab2x16(:,:,197))
  call Hloop_Q_A(ntryL,G0H4(1),117,0,G1H4(80),n2h4(236))
  call Hloop_QV_A(ntryL,G1H16(79),wf4(:,17),G1H4(81),m3h4x4(:,142),heltab2x16(:,:,198))
  call Hloop_Q_A(ntryL,G1H4(81),117,nMT,G2H4(61),n2h4(237))
call HGT_OLR(G1H16(80),1,1,16)
call HGT_invQ_OLR(G1H16(80),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(80),-10,nMT,G2H16(47),n2h16(318))
  call Hloop_AZ_Q(ntryL,G2H16(47),wf4(:,6),G2H4(56),ngZu,m3h4x4(:,143),heltab2x16(:,:,199))
  call Hloop_QV_A(ntryL,G1H16(83),wf4(:,17),G1H4(47),m3h4x4(:,144),heltab2x16(:,:,200))
  call Hloop_Q_A(ntryL,G1H4(47),117,nMT,G2H4(62),n2h4(238))
  call Hloop_QV_A(ntryL,G1H16(84),wf4(:,17),G1H4(48),m3h4x4(:,145),heltab2x16(:,:,201))
  call Hloop_Q_A(ntryL,G1H4(48),117,nMT,G2H4(58),n2h4(239))
  call Hloop_QV_A(ntryL,G0H16(10),wf4(:,17),G0H4(1),m3h4x4(:,146),heltab2x16(:,:,202))
  call Hloop_Q_A(ntryL,G0H4(1),117,nMT,G1H4(53),n2h4(240))
  call Hloop_AV_Q(ntryL,G1H16(85),wf4(:,17),G1H4(64),m3h4x4(:,147),heltab2x16(:,:,203))
  call Hloop_A_Q(ntryL,G1H4(64),117,0,G2H4(54),n2h4(241))
call HGT_OLR(G1H16(86),1,1,16)
call HGT_invQ_OLR(G1H16(86),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(86),-10,0,G2H16(2),n2h16(319))
  call Hloop_QZ_A(ntryL,G2H16(2),wf4(:,6),G2H4(50),ngZd,m3h4x4(:,148),heltab2x16(:,:,204))
  call Hloop_AV_Q(ntryL,G1H16(89),wf4(:,17),G1H4(69),m3h4x4(:,149),heltab2x16(:,:,205))
  call Hloop_A_Q(ntryL,G1H4(69),117,0,G2H4(30),n2h4(242))
  call Hloop_AV_Q(ntryL,G1H16(90),wf4(:,17),G1H4(75),m3h4x4(:,150),heltab2x16(:,:,206))
  call Hloop_A_Q(ntryL,G1H4(75),117,0,G2H4(26),n2h4(243))
  call Hloop_AV_Q(ntryL,G0H16(11),wf4(:,17),G0H4(1),m3h4x4(:,151),heltab2x16(:,:,207))
  call Hloop_A_Q(ntryL,G0H4(1),117,0,G1H4(81),n2h4(244))
  call Hloop_AV_Q(ntryL,G1H16(91),wf4(:,17),G1H4(47),m3h4x4(:,152),heltab2x16(:,:,208))
  call Hloop_A_Q(ntryL,G1H4(47),117,nMB,G2H4(22),n2h4(245))
call HGT_OLR(G1H16(92),1,1,16)
call HGT_invQ_OLR(G1H16(92),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(92),-10,nMB,G2H16(4),n2h16(320))
  call Hloop_QZ_A(ntryL,G2H16(4),wf4(:,6),G2H4(18),ngZd,m3h4x4(:,153),heltab2x16(:,:,209))
  call Hloop_AV_Q(ntryL,G1H16(95),wf4(:,17),G1H4(48),m3h4x4(:,154),heltab2x16(:,:,210))
  call Hloop_A_Q(ntryL,G1H4(48),117,nMB,G2H4(5),n2h4(246))
  call Hloop_AV_Q(ntryL,G1H16(96),wf4(:,17),G1H4(64),m3h4x4(:,155),heltab2x16(:,:,211))
  call Hloop_A_Q(ntryL,G1H4(64),117,nMB,G2H4(8),n2h4(247))
  call Hloop_AV_Q(ntryL,G0H16(12),wf4(:,17),G0H4(1),m3h4x4(:,156),heltab2x16(:,:,212))
  call Hloop_A_Q(ntryL,G0H4(1),117,nMB,G1H4(69),n2h4(248))
  call Hloop_QV_A(ntryL,G1H16(3),wf4(:,17),G1H4(75),m3h4x4(:,157),heltab2x16(:,:,213))
  call Hloop_Q_A(ntryL,G1H4(75),117,0,G2H4(15),n2h4(249))
call HGT_OLR(G1H16(9),1,1,16)
call HGT_invQ_OLR(G1H16(9),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(9),-10,0,G2H16(7),n2h16(321))
  call Hloop_AZ_Q(ntryL,G2H16(7),wf4(:,6),G2H4(21),ngZd,m3h4x4(:,158),heltab2x16(:,:,214))
  call Hloop_QV_A(ntryL,G1H16(21),wf4(:,17),G1H4(47),m3h4x4(:,159),heltab2x16(:,:,215))
  call Hloop_Q_A(ntryL,G1H4(47),117,0,G2H4(24),n2h4(250))
  call Hloop_QV_A(ntryL,G1H16(27),wf4(:,17),G1H4(48),m3h4x4(:,160),heltab2x16(:,:,216))
  call Hloop_Q_A(ntryL,G1H4(48),117,0,G2H4(31),n2h4(251))
  call Hloop_QV_A(ntryL,G0H16(13),wf4(:,17),G0H4(1),m3h4x4(:,161),heltab2x16(:,:,217))
  call Hloop_Q_A(ntryL,G0H4(1),117,0,G1H4(64),n2h4(252))
  call Hloop_QV_A(ntryL,G1H16(33),wf4(:,17),G1H4(75),m3h4x4(:,162),heltab2x16(:,:,218))
  call Hloop_Q_A(ntryL,G1H4(75),117,nMB,G2H4(37),n2h4(253))
call HGT_OLR(G1H16(39),1,1,16)
call HGT_invQ_OLR(G1H16(39),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(39),-10,nMB,G2H16(8),n2h16(322))
  call Hloop_AZ_Q(ntryL,G2H16(8),wf4(:,6),G2H4(40),ngZd,m3h4x4(:,163),heltab2x16(:,:,219))
  call Hloop_QV_A(ntryL,G1H16(51),wf4(:,17),G1H4(47),m3h4x4(:,164),heltab2x16(:,:,220))
  call Hloop_Q_A(ntryL,G1H4(47),117,nMB,G2H4(100),n2h4(254))
  call Hloop_QV_A(ntryL,G1H16(57),wf4(:,17),G1H4(48),m3h4x4(:,165),heltab2x16(:,:,221))
  call Hloop_Q_A(ntryL,G1H4(48),117,nMB,G2H4(104),n2h4(255))
  call Hloop_QV_A(ntryL,G0H16(14),wf4(:,17),G0H4(1),m3h4x4(:,166),heltab2x16(:,:,222))
  call Hloop_Q_A(ntryL,G0H4(1),117,nMB,G1H4(75),n2h4(256))
  call Hloop_AV_Q(ntryL,G1H16(63),wf4(:,2),G1H4(47),m3h4x4(:,167),heltab2x16(:,:,223))
  call Hloop_A_Q(ntryL,G1H4(47),79,0,G2H4(7),n2h4(257))
call HGT_OLR(G1H16(69),1,1,16)
call HGT_invQ_OLR(G1H16(69),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(69),-48,0,G2H16(10),n2h16(323))
  call Hloop_QV_A(ntryL,G2H16(10),wf4(:,17),G2H4(13),m3h4x4(:,168),heltab2x16(:,:,224))
  call Hloop_AV_Q(ntryL,G1H16(81),wf4(:,2),G1H4(48),m3h4x4(:,169),heltab2x16(:,:,225))
  call Hloop_A_Q(ntryL,G1H4(48),79,0,G2H4(16),n2h4(258))
  call Hloop_AV_Q(ntryL,G1H16(87),wf4(:,2),G1H4(47),m3h4x4(:,170),heltab2x16(:,:,226))
  call Hloop_A_Q(ntryL,G1H4(47),79,0,G2H4(23),n2h4(259))
  call Hloop_AV_Q(ntryL,G0H16(15),wf4(:,2),G0H4(1),m3h4x4(:,171),heltab2x16(:,:,227))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(48),n2h4(260))
  call Hloop_AV_Q(ntryL,G1H16(93),wf4(:,2),G1H4(47),m3h4x4(:,172),heltab2x16(:,:,228))
  call Hloop_A_Q(ntryL,G1H4(47),79,nMT,G2H4(29),n2h4(261))
call HGT_OLR(G1H16(20),1,1,16)
call HGT_invQ_OLR(G1H16(20),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(20),-48,nMT,G2H16(12),n2h16(324))
  call Hloop_QV_A(ntryL,G2H16(12),wf4(:,17),G2H4(32),m3h4x4(:,173),heltab2x16(:,:,229))
  call Hloop_AV_Q(ntryL,G1H16(23),wf4(:,2),G1H4(47),m3h4x4(:,174),heltab2x16(:,:,230))
  call Hloop_A_Q(ntryL,G1H4(47),79,nMT,G2H4(39),n2h4(262))
  call Hloop_AV_Q(ntryL,G1H16(24),wf4(:,2),G1H4(47),m3h4x4(:,175),heltab2x16(:,:,231))
  call Hloop_A_Q(ntryL,G1H4(47),79,nMT,G2H4(45),n2h4(263))
  call Hloop_AV_Q(ntryL,G0H16(16),wf4(:,2),G0H4(1),m3h4x4(:,176),heltab2x16(:,:,232))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMT,G1H4(47),n2h4(264))
  call Hloop_QV_A(ntryL,G1H16(1),wf4(:,2),G1H4(113),m3h4x4(:,177),heltab2x16(:,:,233))
  call Hloop_Q_A(ntryL,G1H4(113),79,0,G2H4(105),n2h4(265))
call HGT_OLR(G1H16(2),1,1,16)
call HGT_invQ_OLR(G1H16(2),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(2),-48,0,G2H16(25),n2h16(325))
  call Hloop_AV_Q(ntryL,G2H16(25),wf4(:,17),G2H4(106),m3h4x4(:,178),heltab2x16(:,:,234))
  call Hloop_QV_A(ntryL,G1H16(5),wf4(:,2),G1H4(113),m3h4x4(:,179),heltab2x16(:,:,235))
  call Hloop_Q_A(ntryL,G1H4(113),79,0,G2H4(107),n2h4(266))
  call Hloop_QV_A(ntryL,G1H16(6),wf4(:,2),G1H4(113),m3h4x4(:,180),heltab2x16(:,:,236))
  call Hloop_Q_A(ntryL,G1H4(113),79,0,G2H4(108),n2h4(267))
  call Hloop_QV_A(ntryL,G0H16(17),wf4(:,2),G0H4(1),m3h4x4(:,181),heltab2x16(:,:,237))
  call Hloop_Q_A(ntryL,G0H4(1),79,0,G1H4(113),n2h4(268))
  call Hloop_QV_A(ntryL,G1H16(7),wf4(:,2),G1H4(114),m3h4x4(:,182),heltab2x16(:,:,238))
  call Hloop_Q_A(ntryL,G1H4(114),79,nMT,G2H4(109),n2h4(269))
call HGT_OLR(G1H16(8),1,1,16)
call HGT_invQ_OLR(G1H16(8),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(8),-48,nMT,G2H16(46),n2h16(326))
  call Hloop_AV_Q(ntryL,G2H16(46),wf4(:,17),G2H4(110),m3h4x4(:,183),heltab2x16(:,:,239))
  call Hloop_QV_A(ntryL,G1H16(11),wf4(:,2),G1H4(114),m3h4x4(:,184),heltab2x16(:,:,240))
  call Hloop_Q_A(ntryL,G1H4(114),79,nMT,G2H4(111),n2h4(270))
  call Hloop_QV_A(ntryL,G1H16(12),wf4(:,2),G1H4(114),m3h4x4(:,185),heltab2x16(:,:,241))
  call Hloop_Q_A(ntryL,G1H4(114),79,nMT,G2H4(112),n2h4(271))
  call Hloop_QV_A(ntryL,G0H16(18),wf4(:,2),G0H4(1),m3h4x4(:,186),heltab2x16(:,:,242))
  call Hloop_Q_A(ntryL,G0H4(1),79,nMT,G1H4(114),n2h4(272))
  call Hloop_AV_Q(ntryL,G1H16(13),wf4(:,2),G1H4(115),m3h4x4(:,187),heltab2x16(:,:,243))
  call Hloop_A_Q(ntryL,G1H4(115),79,nMB,G2H4(113),n2h4(273))
call HGT_OLR(G1H16(14),1,1,16)
call HGT_invQ_OLR(G1H16(14),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(14),-48,nMB,G2H16(48),n2h16(327))
  call Hloop_QV_A(ntryL,G2H16(48),wf4(:,17),G2H4(114),m3h4x4(:,188),heltab2x16(:,:,244))
  call Hloop_AV_Q(ntryL,G1H16(17),wf4(:,2),G1H4(115),m3h4x4(:,189),heltab2x16(:,:,245))
  call Hloop_A_Q(ntryL,G1H4(115),79,nMB,G2H4(115),n2h4(274))
  call Hloop_AV_Q(ntryL,G1H16(18),wf4(:,2),G1H4(115),m3h4x4(:,190),heltab2x16(:,:,246))
  call Hloop_A_Q(ntryL,G1H4(115),79,nMB,G2H4(116),n2h4(275))
  call Hloop_AV_Q(ntryL,G0H16(19),wf4(:,2),G0H4(1),m3h4x4(:,191),heltab2x16(:,:,247))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(115),n2h4(276))
  call Hloop_QV_A(ntryL,G1H16(19),wf4(:,2),G1H4(116),m3h4x4(:,192),heltab2x16(:,:,248))
  call Hloop_Q_A(ntryL,G1H4(116),79,nMB,G2H4(117),n2h4(277))
call HGT_OLR(G1H16(97),1,1,16)
call HGT_invQ_OLR(G1H16(97),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(97),-48,nMB,G2H16(29),n2h16(328))
  call Hloop_AV_Q(ntryL,G2H16(29),wf4(:,17),G2H4(118),m3h4x4(:,193),heltab2x16(:,:,249))
  call Hloop_QV_A(ntryL,G1H16(99),wf4(:,2),G1H4(116),m3h4x4(:,194),heltab2x16(:,:,250))
  call Hloop_Q_A(ntryL,G1H4(116),79,nMB,G2H4(119),n2h4(278))
  call Hloop_QV_A(ntryL,G1H16(100),wf4(:,2),G1H4(116),m3h4x4(:,195),heltab2x16(:,:,251))
  call Hloop_Q_A(ntryL,G1H4(116),79,nMB,G2H4(120),n2h4(279))
  call Hloop_QV_A(ntryL,G0H16(20),wf4(:,2),G0H4(1),m3h4x4(:,196),heltab2x16(:,:,252))
  call Hloop_Q_A(ntryL,G0H4(1),79,nMB,G1H4(116),n2h4(280))
  call Hloop_AZ_Q(ntryL,G1H16(101),wf4(:,6),G1H4(117),ngZu,m3h4x4(:,197),heltab2x16(:,:,253))
  call Hloop_A_Q(ntryL,G1H4(117),79,0,G2H4(121),n2h4(281))
call HGT_OLR(G1H16(102),1,1,16)
call HGT_invQ_OLR(G1H16(102),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(102),-48,0,G2H16(1),n2h16(329))
  call Hloop_QV_A(ntryL,G2H16(1),wf4(:,17),G2H4(122),m3h4x4(:,198),heltab2x16(:,:,254))
  call Hloop_AZ_Q(ntryL,G1H16(104),wf4(:,6),G1H4(117),ngZu,m3h4x4(:,199),heltab2x16(:,:,255))
  call Hloop_A_Q(ntryL,G1H4(117),79,0,G2H4(123),n2h4(282))
  call Hloop_AZ_Q(ntryL,G1H16(105),wf4(:,6),G1H4(117),ngZu,m3h4x4(:,200),heltab2x16(:,:,256))
  call Hloop_A_Q(ntryL,G1H4(117),79,0,G2H4(124),n2h4(283))
  call Hloop_AZ_Q(ntryL,G0H16(21),wf4(:,6),G0H4(1),ngZu,m3h4x4(:,201),heltab2x16(:,:,257))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(117),n2h4(284))
  call Hloop_AZ_Q(ntryL,G1H16(106),wf4(:,6),G1H4(118),ngZu,m3h4x4(:,202),heltab2x16(:,:,258))
  call Hloop_A_Q(ntryL,G1H4(118),79,nMT,G2H4(125),n2h4(285))
call HGT_OLR(G1H16(107),1,1,16)
call HGT_invQ_OLR(G1H16(107),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(107),-48,nMT,G2H16(3),n2h16(330))
  call Hloop_QV_A(ntryL,G2H16(3),wf4(:,17),G2H4(126),m3h4x4(:,203),heltab2x16(:,:,259))
  call Hloop_AZ_Q(ntryL,G1H16(109),wf4(:,6),G1H4(118),ngZu,m3h4x4(:,204),heltab2x16(:,:,260))
  call Hloop_A_Q(ntryL,G1H4(118),79,nMT,G2H4(127),n2h4(286))
  call Hloop_AZ_Q(ntryL,G1H16(110),wf4(:,6),G1H4(118),ngZu,m3h4x4(:,205),heltab2x16(:,:,261))
  call Hloop_A_Q(ntryL,G1H4(118),79,nMT,G2H4(128),n2h4(287))
  call Hloop_AZ_Q(ntryL,G0H16(22),wf4(:,6),G0H4(1),ngZu,m3h4x4(:,206),heltab2x16(:,:,262))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMT,G1H4(118),n2h4(288))
  call Hloop_QZ_A(ntryL,G1H16(111),wf4(:,6),G1H4(119),ngZu,m3h4x4(:,207),heltab2x16(:,:,263))
  call Hloop_Q_A(ntryL,G1H4(119),79,0,G2H4(129),n2h4(289))
call HGT_OLR(G1H16(112),1,1,16)
call HGT_invQ_OLR(G1H16(112),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(112),-48,0,G2H16(5),n2h16(331))
  call Hloop_AV_Q(ntryL,G2H16(5),wf4(:,17),G2H4(130),m3h4x4(:,208),heltab2x16(:,:,264))
  call Hloop_QZ_A(ntryL,G1H16(114),wf4(:,6),G1H4(119),ngZu,m3h4x4(:,209),heltab2x16(:,:,265))
  call Hloop_Q_A(ntryL,G1H4(119),79,0,G2H4(131),n2h4(290))
  call Hloop_QZ_A(ntryL,G1H16(115),wf4(:,6),G1H4(119),ngZu,m3h4x4(:,210),heltab2x16(:,:,266))
  call Hloop_Q_A(ntryL,G1H4(119),79,0,G2H4(132),n2h4(291))
  call Hloop_QZ_A(ntryL,G0H16(23),wf4(:,6),G0H4(1),ngZu,m3h4x4(:,211),heltab2x16(:,:,267))
  call Hloop_Q_A(ntryL,G0H4(1),79,0,G1H4(119),n2h4(292))
  call Hloop_QZ_A(ntryL,G1H16(116),wf4(:,6),G1H4(120),ngZu,m3h4x4(:,212),heltab2x16(:,:,268))
  call Hloop_Q_A(ntryL,G1H4(120),79,nMT,G2H4(133),n2h4(293))
call HGT_OLR(G1H16(117),1,1,16)
call HGT_invQ_OLR(G1H16(117),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(117),-48,nMT,G2H16(6),n2h16(332))
  call Hloop_AV_Q(ntryL,G2H16(6),wf4(:,17),G2H4(134),m3h4x4(:,213),heltab2x16(:,:,269))
  call Hloop_QZ_A(ntryL,G1H16(119),wf4(:,6),G1H4(120),ngZu,m3h4x4(:,214),heltab2x16(:,:,270))
  call Hloop_Q_A(ntryL,G1H4(120),79,nMT,G2H4(135),n2h4(294))
  call Hloop_QZ_A(ntryL,G1H16(120),wf4(:,6),G1H4(120),ngZu,m3h4x4(:,215),heltab2x16(:,:,271))
  call Hloop_Q_A(ntryL,G1H4(120),79,nMT,G2H4(136),n2h4(295))
  call Hloop_QZ_A(ntryL,G0H16(24),wf4(:,6),G0H4(1),ngZu,m3h4x4(:,216),heltab2x16(:,:,272))
  call Hloop_Q_A(ntryL,G0H4(1),79,nMT,G1H4(120),n2h4(296))
  call Hloop_AZ_Q(ntryL,G1H16(121),wf4(:,6),G1H4(121),ngZd,m3h4x4(:,217),heltab2x16(:,:,273))
  call Hloop_A_Q(ntryL,G1H4(121),79,0,G2H4(137),n2h4(297))
call HGT_OLR(G1H16(122),1,1,16)
call HGT_invQ_OLR(G1H16(122),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(122),-48,0,G2H16(9),n2h16(333))
  call Hloop_QV_A(ntryL,G2H16(9),wf4(:,17),G2H4(138),m3h4x4(:,218),heltab2x16(:,:,274))
  call Hloop_AZ_Q(ntryL,G1H16(124),wf4(:,6),G1H4(121),ngZd,m3h4x4(:,219),heltab2x16(:,:,275))
  call Hloop_A_Q(ntryL,G1H4(121),79,0,G2H4(139),n2h4(298))
  call Hloop_AZ_Q(ntryL,G1H16(125),wf4(:,6),G1H4(121),ngZd,m3h4x4(:,220),heltab2x16(:,:,276))
  call Hloop_A_Q(ntryL,G1H4(121),79,0,G2H4(140),n2h4(299))
  call Hloop_AZ_Q(ntryL,G0H16(25),wf4(:,6),G0H4(1),ngZd,m3h4x4(:,221),heltab2x16(:,:,277))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(121),n2h4(300))
  call Hloop_AZ_Q(ntryL,G1H16(126),wf4(:,6),G1H4(122),ngZd,m3h4x4(:,222),heltab2x16(:,:,278))
  call Hloop_A_Q(ntryL,G1H4(122),79,nMB,G2H4(141),n2h4(301))
call HGT_OLR(G1H16(127),1,1,16)
call HGT_invQ_OLR(G1H16(127),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(127),-48,nMB,G2H16(11),n2h16(334))
  call Hloop_QV_A(ntryL,G2H16(11),wf4(:,17),G2H4(142),m3h4x4(:,223),heltab2x16(:,:,279))
  call Hloop_AZ_Q(ntryL,G1H16(129),wf4(:,6),G1H4(122),ngZd,m3h4x4(:,224),heltab2x16(:,:,280))
  call Hloop_A_Q(ntryL,G1H4(122),79,nMB,G2H4(143),n2h4(302))
  call Hloop_AZ_Q(ntryL,G1H16(130),wf4(:,6),G1H4(122),ngZd,m3h4x4(:,225),heltab2x16(:,:,281))
  call Hloop_A_Q(ntryL,G1H4(122),79,nMB,G2H4(144),n2h4(303))
  call Hloop_AZ_Q(ntryL,G0H16(26),wf4(:,6),G0H4(1),ngZd,m3h4x4(:,226),heltab2x16(:,:,282))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(122),n2h4(304))
  call Hloop_QZ_A(ntryL,G1H16(131),wf4(:,6),G1H4(123),ngZd,m3h4x4(:,227),heltab2x16(:,:,283))
  call Hloop_Q_A(ntryL,G1H4(123),79,0,G2H4(145),n2h4(305))
call HGT_OLR(G1H16(132),1,1,16)
call HGT_invQ_OLR(G1H16(132),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(132),-48,0,G2H16(13),n2h16(335))
  call Hloop_AV_Q(ntryL,G2H16(13),wf4(:,17),G2H4(146),m3h4x4(:,228),heltab2x16(:,:,284))
  call Hloop_QZ_A(ntryL,G1H16(134),wf4(:,6),G1H4(123),ngZd,m3h4x4(:,229),heltab2x16(:,:,285))
  call Hloop_Q_A(ntryL,G1H4(123),79,0,G2H4(147),n2h4(306))
  call Hloop_QZ_A(ntryL,G1H16(135),wf4(:,6),G1H4(123),ngZd,m3h4x4(:,230),heltab2x16(:,:,286))
  call Hloop_Q_A(ntryL,G1H4(123),79,0,G2H4(148),n2h4(307))
  call Hloop_QZ_A(ntryL,G0H16(27),wf4(:,6),G0H4(1),ngZd,m3h4x4(:,231),heltab2x16(:,:,287))
  call Hloop_Q_A(ntryL,G0H4(1),79,0,G1H4(123),n2h4(308))
  call Hloop_QZ_A(ntryL,G1H16(136),wf4(:,6),G1H4(124),ngZd,m3h4x4(:,232),heltab2x16(:,:,288))
  call Hloop_Q_A(ntryL,G1H4(124),79,nMB,G2H4(149),n2h4(309))
call HGT_OLR(G1H16(137),1,1,16)
call HGT_invQ_OLR(G1H16(137),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(137),-48,nMB,G2H16(14),n2h16(336))
  call Hloop_AV_Q(ntryL,G2H16(14),wf4(:,17),G2H4(150),m3h4x4(:,233),heltab2x16(:,:,289))
  call Hloop_QZ_A(ntryL,G1H16(139),wf4(:,6),G1H4(124),ngZd,m3h4x4(:,234),heltab2x16(:,:,290))
  call Hloop_Q_A(ntryL,G1H4(124),79,nMB,G2H4(151),n2h4(310))
  call Hloop_QZ_A(ntryL,G1H16(140),wf4(:,6),G1H4(124),ngZd,m3h4x4(:,235),heltab2x16(:,:,291))
  call Hloop_Q_A(ntryL,G1H4(124),79,nMB,G2H4(152),n2h4(311))
  call Hloop_QZ_A(ntryL,G0H16(28),wf4(:,6),G0H4(1),ngZd,m3h4x4(:,236),heltab2x16(:,:,292))
  call Hloop_Q_A(ntryL,G0H4(1),79,nMB,G1H4(124),n2h4(312))
  call Hloop_AV_Q(ntryL,G1H16(141),wf4(:,1),G1H4(125),m3h4x4(:,237),heltab2x16(:,:,293))
  call Hloop_A_Q(ntryL,G1H4(125),79,0,G2H4(153),n2h4(313))
call HGT_OLR(G1H16(142),1,1,16)
call HGT_invQ_OLR(G1H16(142),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(142),-48,0,G2H16(17),n2h16(337))
  call Hloop_QV_A(ntryL,G2H16(17),wf4(:,17),G2H4(154),m3h4x4(:,238),heltab2x16(:,:,294))
  call Hloop_AV_Q(ntryL,G1H16(144),wf4(:,1),G1H4(125),m3h4x4(:,239),heltab2x16(:,:,295))
  call Hloop_A_Q(ntryL,G1H4(125),79,0,G2H4(155),n2h4(314))
  call Hloop_AV_Q(ntryL,G1H16(145),wf4(:,1),G1H4(125),m3h4x4(:,240),heltab2x16(:,:,296))
  call Hloop_A_Q(ntryL,G1H4(125),79,0,G2H4(156),n2h4(315))
  call Hloop_AV_Q(ntryL,G0H16(29),wf4(:,1),G0H4(1),m3h4x4(:,241),heltab2x16(:,:,297))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(125),n2h4(316))
  call Hloop_AV_Q(ntryL,G1H16(146),wf4(:,1),G1H4(126),m3h4x4(:,242),heltab2x16(:,:,298))
  call Hloop_A_Q(ntryL,G1H4(126),79,nMT,G2H4(157),n2h4(317))
call HGT_OLR(G1H16(147),1,1,16)
call HGT_invQ_OLR(G1H16(147),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(147),-48,nMT,G2H16(18),n2h16(338))
  call Hloop_QV_A(ntryL,G2H16(18),wf4(:,17),G2H4(158),m3h4x4(:,243),heltab2x16(:,:,299))
  call Hloop_AV_Q(ntryL,G1H16(149),wf4(:,1),G1H4(126),m3h4x4(:,244),heltab2x16(:,:,300))
  call Hloop_A_Q(ntryL,G1H4(126),79,nMT,G2H4(159),n2h4(318))
  call Hloop_AV_Q(ntryL,G1H16(150),wf4(:,1),G1H4(126),m3h4x4(:,245),heltab2x16(:,:,301))
  call Hloop_A_Q(ntryL,G1H4(126),79,nMT,G2H4(160),n2h4(319))
  call Hloop_AV_Q(ntryL,G0H16(30),wf4(:,1),G0H4(1),m3h4x4(:,246),heltab2x16(:,:,302))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMT,G1H4(126),n2h4(320))
  call Hloop_QV_A(ntryL,G1H16(151),wf4(:,1),G1H4(127),m3h4x4(:,247),heltab2x16(:,:,303))
  call Hloop_Q_A(ntryL,G1H4(127),79,0,G2H4(161),n2h4(321))
call HGT_OLR(G1H16(152),1,1,16)
call HGT_invQ_OLR(G1H16(152),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(152),-48,0,G2H16(21),n2h16(339))
  call Hloop_AV_Q(ntryL,G2H16(21),wf4(:,17),G2H4(162),m3h4x4(:,248),heltab2x16(:,:,304))
  call Hloop_QV_A(ntryL,G1H16(154),wf4(:,1),G1H4(127),m3h4x4(:,249),heltab2x16(:,:,305))
  call Hloop_Q_A(ntryL,G1H4(127),79,0,G2H4(163),n2h4(322))
  call Hloop_QV_A(ntryL,G1H16(155),wf4(:,1),G1H4(127),m3h4x4(:,250),heltab2x16(:,:,306))
  call Hloop_Q_A(ntryL,G1H4(127),79,0,G2H4(164),n2h4(323))
  call Hloop_QV_A(ntryL,G0H16(31),wf4(:,1),G0H4(1),m3h4x4(:,251),heltab2x16(:,:,307))
  call Hloop_Q_A(ntryL,G0H4(1),79,0,G1H4(127),n2h4(324))
  call Hloop_QV_A(ntryL,G1H16(156),wf4(:,1),G1H4(128),m3h4x4(:,252),heltab2x16(:,:,308))
  call Hloop_Q_A(ntryL,G1H4(128),79,nMT,G2H4(165),n2h4(325))
call HGT_OLR(G1H16(157),1,1,16)
call HGT_invQ_OLR(G1H16(157),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(157),-48,nMT,G2H16(22),n2h16(340))
  call Hloop_AV_Q(ntryL,G2H16(22),wf4(:,17),G2H4(166),m3h4x4(:,253),heltab2x16(:,:,309))
  call Hloop_QV_A(ntryL,G1H16(159),wf4(:,1),G1H4(128),m3h4x4(:,254),heltab2x16(:,:,310))
  call Hloop_Q_A(ntryL,G1H4(128),79,nMT,G2H4(167),n2h4(326))
  call Hloop_QV_A(ntryL,G1H16(160),wf4(:,1),G1H4(128),m3h4x4(:,255),heltab2x16(:,:,311))
  call Hloop_Q_A(ntryL,G1H4(128),79,nMT,G2H4(168),n2h4(327))
  call Hloop_QV_A(ntryL,G0H16(32),wf4(:,1),G0H4(1),m3h4x4(:,256),heltab2x16(:,:,312))
  call Hloop_Q_A(ntryL,G0H4(1),79,nMT,G1H4(128),n2h4(328))
  call Hloop_AV_Q(ntryL,G1H16(161),wf4(:,1),G1H4(129),m3h4x4(:,257),heltab2x16(:,:,313))
  call Hloop_A_Q(ntryL,G1H4(129),79,nMB,G2H4(169),n2h4(329))
call HGT_OLR(G1H16(162),1,1,16)
call HGT_invQ_OLR(G1H16(162),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(162),-48,nMB,G2H16(67),n2h16(341))
  call Hloop_QV_A(ntryL,G2H16(67),wf4(:,17),G2H4(170),m3h4x4(:,258),heltab2x16(:,:,314))
  call Hloop_AV_Q(ntryL,G1H16(164),wf4(:,1),G1H4(129),m3h4x4(:,259),heltab2x16(:,:,315))
  call Hloop_A_Q(ntryL,G1H4(129),79,nMB,G2H4(171),n2h4(330))
  call Hloop_AV_Q(ntryL,G1H16(165),wf4(:,1),G1H4(129),m3h4x4(:,260),heltab2x16(:,:,316))
  call Hloop_A_Q(ntryL,G1H4(129),79,nMB,G2H4(172),n2h4(331))
  call Hloop_AV_Q(ntryL,G0H16(33),wf4(:,1),G0H4(1),m3h4x4(:,261),heltab2x16(:,:,317))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(129),n2h4(332))
  call Hloop_QV_A(ntryL,G1H16(166),wf4(:,1),G1H4(130),m3h4x4(:,262),heltab2x16(:,:,318))
  call Hloop_Q_A(ntryL,G1H4(130),79,nMB,G2H4(173),n2h4(333))
call HGT_OLR(G1H16(167),1,1,16)
call HGT_invQ_OLR(G1H16(167),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(167),-48,nMB,G2H16(61),n2h16(342))
  call Hloop_AV_Q(ntryL,G2H16(61),wf4(:,17),G2H4(174),m3h4x4(:,263),heltab2x16(:,:,319))
  call Hloop_QV_A(ntryL,G1H16(169),wf4(:,1),G1H4(130),m3h4x4(:,264),heltab2x16(:,:,320))
  call Hloop_Q_A(ntryL,G1H4(130),79,nMB,G2H4(175),n2h4(334))
  call Hloop_QV_A(ntryL,G1H16(170),wf4(:,1),G1H4(130),m3h4x4(:,265),heltab2x16(:,:,321))
  call Hloop_Q_A(ntryL,G1H4(130),79,nMB,G2H4(176),n2h4(335))
  call Hloop_QV_A(ntryL,G0H16(34),wf4(:,1),G0H4(1),m3h4x4(:,266),heltab2x16(:,:,322))
  call Hloop_Q_A(ntryL,G0H4(1),79,nMB,G1H4(130),n2h4(336))
  call Hloop_AZ_Q(ntryL,G1H16(171),wf4(:,8),G1H4(131),ngZu,m3h4x4(:,267),heltab2x16(:,:,323))
  call Hloop_A_Q(ntryL,G1H4(131),79,0,G2H4(177),n2h4(337))
call HGT_OLR(G1H16(172),1,1,16)
call HGT_invQ_OLR(G1H16(172),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(172),-48,0,G2H16(62),n2h16(343))
  call Hloop_QV_A(ntryL,G2H16(62),wf4(:,17),G2H4(178),m3h4x4(:,268),heltab2x16(:,:,324))
  call Hloop_AZ_Q(ntryL,G1H16(174),wf4(:,8),G1H4(131),ngZu,m3h4x4(:,269),heltab2x16(:,:,325))
  call Hloop_A_Q(ntryL,G1H4(131),79,0,G2H4(179),n2h4(338))
  call Hloop_AZ_Q(ntryL,G1H16(175),wf4(:,8),G1H4(131),ngZu,m3h4x4(:,270),heltab2x16(:,:,326))
  call Hloop_A_Q(ntryL,G1H4(131),79,0,G2H4(180),n2h4(339))
  call Hloop_AZ_Q(ntryL,G0H16(35),wf4(:,8),G0H4(1),ngZu,m3h4x4(:,271),heltab2x16(:,:,327))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(131),n2h4(340))
  call Hloop_AZ_Q(ntryL,G1H16(176),wf4(:,8),G1H4(132),ngZu,m3h4x4(:,272),heltab2x16(:,:,328))
  call Hloop_A_Q(ntryL,G1H4(132),79,nMT,G2H4(181),n2h4(341))
call HGT_OLR(G1H16(177),1,1,16)
call HGT_invQ_OLR(G1H16(177),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(177),-48,nMT,G2H16(69),n2h16(344))
  call Hloop_QV_A(ntryL,G2H16(69),wf4(:,17),G2H4(182),m3h4x4(:,273),heltab2x16(:,:,329))
  call Hloop_AZ_Q(ntryL,G1H16(179),wf4(:,8),G1H4(132),ngZu,m3h4x4(:,274),heltab2x16(:,:,330))
  call Hloop_A_Q(ntryL,G1H4(132),79,nMT,G2H4(183),n2h4(342))
  call Hloop_AZ_Q(ntryL,G1H16(180),wf4(:,8),G1H4(132),ngZu,m3h4x4(:,275),heltab2x16(:,:,331))
  call Hloop_A_Q(ntryL,G1H4(132),79,nMT,G2H4(184),n2h4(343))
  call Hloop_AZ_Q(ntryL,G0H16(36),wf4(:,8),G0H4(1),ngZu,m3h4x4(:,276),heltab2x16(:,:,332))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMT,G1H4(132),n2h4(344))
  call Hloop_QZ_A(ntryL,G1H16(181),wf4(:,8),G1H4(133),ngZu,m3h4x4(:,277),heltab2x16(:,:,333))
  call Hloop_Q_A(ntryL,G1H4(133),79,0,G2H4(185),n2h4(345))
call HGT_OLR(G1H16(182),1,1,16)
call HGT_invQ_OLR(G1H16(182),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(182),-48,0,G2H16(63),n2h16(345))
  call Hloop_AV_Q(ntryL,G2H16(63),wf4(:,17),G2H4(186),m3h4x4(:,278),heltab2x16(:,:,334))
  call Hloop_QZ_A(ntryL,G1H16(184),wf4(:,8),G1H4(133),ngZu,m3h4x4(:,279),heltab2x16(:,:,335))
  call Hloop_Q_A(ntryL,G1H4(133),79,0,G2H4(187),n2h4(346))
  call Hloop_QZ_A(ntryL,G1H16(185),wf4(:,8),G1H4(133),ngZu,m3h4x4(:,280),heltab2x16(:,:,336))
  call Hloop_Q_A(ntryL,G1H4(133),79,0,G2H4(188),n2h4(347))
  call Hloop_QZ_A(ntryL,G0H16(37),wf4(:,8),G0H4(1),ngZu,m3h4x4(:,281),heltab2x16(:,:,337))
  call Hloop_Q_A(ntryL,G0H4(1),79,0,G1H4(133),n2h4(348))
  call Hloop_QZ_A(ntryL,G1H16(186),wf4(:,8),G1H4(134),ngZu,m3h4x4(:,282),heltab2x16(:,:,338))
  call Hloop_Q_A(ntryL,G1H4(134),79,nMT,G2H4(189),n2h4(349))
call HGT_OLR(G1H16(187),1,1,16)
call HGT_invQ_OLR(G1H16(187),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(187),-48,nMT,G2H16(64),n2h16(346))
  call Hloop_AV_Q(ntryL,G2H16(64),wf4(:,17),G2H4(190),m3h4x4(:,283),heltab2x16(:,:,339))
  call Hloop_QZ_A(ntryL,G1H16(189),wf4(:,8),G1H4(134),ngZu,m3h4x4(:,284),heltab2x16(:,:,340))
  call Hloop_Q_A(ntryL,G1H4(134),79,nMT,G2H4(191),n2h4(350))
  call Hloop_QZ_A(ntryL,G1H16(190),wf4(:,8),G1H4(134),ngZu,m3h4x4(:,285),heltab2x16(:,:,341))
  call Hloop_Q_A(ntryL,G1H4(134),79,nMT,G2H4(192),n2h4(351))
  call Hloop_QZ_A(ntryL,G0H16(38),wf4(:,8),G0H4(1),ngZu,m3h4x4(:,286),heltab2x16(:,:,342))
  call Hloop_Q_A(ntryL,G0H4(1),79,nMT,G1H4(134),n2h4(352))
  call Hloop_AZ_Q(ntryL,G1H16(191),wf4(:,8),G1H4(135),ngZd,m3h4x4(:,287),heltab2x16(:,:,343))
  call Hloop_A_Q(ntryL,G1H4(135),79,0,G2H4(193),n2h4(353))
call HGT_OLR(G1H16(192),1,1,16)
call HGT_invQ_OLR(G1H16(192),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(192),-48,0,G2H16(65),n2h16(347))
  call Hloop_QV_A(ntryL,G2H16(65),wf4(:,17),G2H4(194),m3h4x4(:,288),heltab2x16(:,:,344))
  call Hloop_AZ_Q(ntryL,G1H16(194),wf4(:,8),G1H4(135),ngZd,m3h4x4(:,289),heltab2x16(:,:,345))
  call Hloop_A_Q(ntryL,G1H4(135),79,0,G2H4(195),n2h4(354))
  call Hloop_AZ_Q(ntryL,G1H16(195),wf4(:,8),G1H4(135),ngZd,m3h4x4(:,290),heltab2x16(:,:,346))
  call Hloop_A_Q(ntryL,G1H4(135),79,0,G2H4(196),n2h4(355))
  call Hloop_AZ_Q(ntryL,G0H16(39),wf4(:,8),G0H4(1),ngZd,m3h4x4(:,291),heltab2x16(:,:,347))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(135),n2h4(356))
  call Hloop_AZ_Q(ntryL,G1H16(196),wf4(:,8),G1H4(136),ngZd,m3h4x4(:,292),heltab2x16(:,:,348))
  call Hloop_A_Q(ntryL,G1H4(136),79,nMB,G2H4(197),n2h4(357))
call HGT_OLR(G1H16(197),1,1,16)
call HGT_invQ_OLR(G1H16(197),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(197),-48,nMB,G2H16(66),n2h16(348))
  call Hloop_QV_A(ntryL,G2H16(66),wf4(:,17),G2H4(198),m3h4x4(:,293),heltab2x16(:,:,349))
  call Hloop_AZ_Q(ntryL,G1H16(199),wf4(:,8),G1H4(136),ngZd,m3h4x4(:,294),heltab2x16(:,:,350))
  call Hloop_A_Q(ntryL,G1H4(136),79,nMB,G2H4(199),n2h4(358))
  call Hloop_AZ_Q(ntryL,G1H16(200),wf4(:,8),G1H4(136),ngZd,m3h4x4(:,295),heltab2x16(:,:,351))
  call Hloop_A_Q(ntryL,G1H4(136),79,nMB,G2H4(200),n2h4(359))
  call Hloop_AZ_Q(ntryL,G0H16(40),wf4(:,8),G0H4(1),ngZd,m3h4x4(:,296),heltab2x16(:,:,352))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(136),n2h4(360))
  call Hloop_QZ_A(ntryL,G1H16(201),wf4(:,8),G1H4(137),ngZd,m3h4x4(:,297),heltab2x16(:,:,353))
  call Hloop_Q_A(ntryL,G1H4(137),79,0,G2H4(201),n2h4(361))
call HGT_OLR(G1H16(202),1,1,16)
call HGT_invQ_OLR(G1H16(202),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(202),-48,0,G2H16(75),n2h16(349))
  call Hloop_AV_Q(ntryL,G2H16(75),wf4(:,17),G2H4(202),m3h4x4(:,298),heltab2x16(:,:,354))
  call Hloop_QZ_A(ntryL,G1H16(204),wf4(:,8),G1H4(137),ngZd,m3h4x4(:,299),heltab2x16(:,:,355))
  call Hloop_Q_A(ntryL,G1H4(137),79,0,G2H4(203),n2h4(362))
  call Hloop_QZ_A(ntryL,G1H16(205),wf4(:,8),G1H4(137),ngZd,m3h4x4(:,300),heltab2x16(:,:,356))
  call Hloop_Q_A(ntryL,G1H4(137),79,0,G2H4(204),n2h4(363))
  call Hloop_QZ_A(ntryL,G0H16(41),wf4(:,8),G0H4(1),ngZd,m3h4x4(:,301),heltab2x16(:,:,357))
  call Hloop_Q_A(ntryL,G0H4(1),79,0,G1H4(137),n2h4(364))
  call Hloop_QZ_A(ntryL,G1H16(206),wf4(:,8),G1H4(138),ngZd,m3h4x4(:,302),heltab2x16(:,:,358))
  call Hloop_Q_A(ntryL,G1H4(138),79,nMB,G2H4(205),n2h4(365))
call HGT_OLR(G1H16(207),1,1,16)
call HGT_invQ_OLR(G1H16(207),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(207),-48,nMB,G2H16(76),n2h16(350))
  call Hloop_AV_Q(ntryL,G2H16(76),wf4(:,17),G2H4(206),m3h4x4(:,303),heltab2x16(:,:,359))
  call Hloop_QZ_A(ntryL,G1H16(209),wf4(:,8),G1H4(138),ngZd,m3h4x4(:,304),heltab2x16(:,:,360))
  call Hloop_Q_A(ntryL,G1H4(138),79,nMB,G2H4(207),n2h4(366))
  call Hloop_QZ_A(ntryL,G1H16(210),wf4(:,8),G1H4(138),ngZd,m3h4x4(:,305),heltab2x16(:,:,361))
  call Hloop_Q_A(ntryL,G1H4(138),79,nMB,G2H4(208),n2h4(367))
  call Hloop_QZ_A(ntryL,G0H16(42),wf4(:,8),G0H4(1),ngZd,m3h4x4(:,306),heltab2x16(:,:,362))
  call Hloop_Q_A(ntryL,G0H4(1),79,nMB,G1H4(138),n2h4(368))
  call Hloop_QV_A(ntryL,G1H32(3),wf4(:,2),G1H8(147),m3h4x8(:,97),heltab2x32(:,:,113))
  call Hloop_Q_A(ntryL,G1H8(147),90,0,G2H8(1),n2h8(169))
call HGT_raise_alpha_OLR(G1H32(9),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(9),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(9),wf8(:,2),G1H4(139),m3h8x4(:,1),heltab2x32(:,:,114))
  call Hloop_QV_A(ntryL,G1H32(21),wf4(:,2),G1H8(163),m3h4x8(:,98),heltab2x32(:,:,115))
  call Hloop_Q_A(ntryL,G1H8(163),90,0,G2H8(2),n2h8(170))
  call Hloop_QV_A(ntryL,G1H32(27),wf4(:,2),G1H8(115),m3h4x8(:,99),heltab2x32(:,:,116))
  call Hloop_Q_A(ntryL,G1H8(115),90,0,G2H8(3),n2h8(171))
  call Hloop_QZ_A(ntryL,G1H32(33),wf4(:,6),G1H8(131),ngZd,m3h4x8(:,100),heltab2x32(:,:,117))
  call Hloop_Q_A(ntryL,G1H8(131),90,0,G2H8(4),n2h8(172))
call HGT_raise_alpha_OLR(G1H32(39),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(39),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(39),wf8(:,2),G1H4(140),m3h8x4(:,2),heltab2x32(:,:,118))
  call Hloop_QZ_A(ntryL,G1H32(51),wf4(:,6),G1H8(116),ngZd,m3h4x8(:,101),heltab2x32(:,:,119))
  call Hloop_Q_A(ntryL,G1H8(116),90,0,G2H8(5),n2h8(173))
  call Hloop_QZ_A(ntryL,G1H32(57),wf4(:,6),G1H8(132),ngZd,m3h4x8(:,102),heltab2x32(:,:,120))
  call Hloop_Q_A(ntryL,G1H8(132),90,0,G2H8(7),n2h8(174))
  call Hloop_QV_A(ntryL,G1H32(63),wf4(:,2),G1H8(148),m3h4x8(:,103),heltab2x32(:,:,121))
  call Hloop_Q_A(ntryL,G1H8(148),90,0,G2H8(6),n2h8(175))
call HGT_raise_alpha_OLR(G1H32(69),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(69),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(69),wf8(:,4),G1H4(141),m3h8x4(:,3),heltab2x32(:,:,122))
  call Hloop_QV_A(ntryL,G1H32(81),wf4(:,2),G1H8(164),m3h4x8(:,104),heltab2x32(:,:,123))
  call Hloop_Q_A(ntryL,G1H8(164),90,0,G2H8(8),n2h8(176))
  call Hloop_QV_A(ntryL,G1H32(87),wf4(:,2),G1H8(3),m3h4x8(:,105),heltab2x32(:,:,124))
  call Hloop_Q_A(ntryL,G1H8(3),90,0,G2H8(25),n2h8(177))
  call Hloop_QZ_A(ntryL,G1H32(93),wf4(:,6),G1H8(4),ngZd,m3h4x8(:,106),heltab2x32(:,:,125))
  call Hloop_Q_A(ntryL,G1H8(4),90,0,G2H8(26),n2h8(178))
call HGT_raise_alpha_OLR(G1H32(6),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(6),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(6),wf8(:,4),G1H4(142),m3h8x4(:,4),heltab2x32(:,:,126))
  call Hloop_QZ_A(ntryL,G1H32(8),wf4(:,6),G1H8(9),ngZd,m3h4x8(:,107),heltab2x32(:,:,127))
  call Hloop_Q_A(ntryL,G1H8(9),90,0,G2H8(18),n2h8(179))
  call Hloop_QZ_A(ntryL,G1H32(10),wf4(:,6),G1H8(10),ngZd,m3h4x8(:,108),heltab2x32(:,:,128))
  call Hloop_Q_A(ntryL,G1H8(10),90,0,G2H8(27),n2h8(180))
  call Hloop_QV_A(ntryL,G1H32(1),wf4(:,1),G1H8(15),m3h4x8(:,109),heltab2x32(:,:,129))
  call Hloop_Q_A(ntryL,G1H8(15),85,0,G2H8(30),n2h8(181))
call HGT_raise_alpha_OLR(G1H32(2),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(2),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(2),wf8(:,6),G1H4(143),m3h8x4(:,5),heltab2x32(:,:,130))
  call Hloop_QV_A(ntryL,G1H32(5),wf4(:,1),G1H8(16),m3h4x8(:,110),heltab2x32(:,:,131))
  call Hloop_Q_A(ntryL,G1H8(16),85,0,G2H8(22),n2h8(182))
  call Hloop_QV_A(ntryL,G1H32(25),wf4(:,1),G1H8(21),m3h4x8(:,111),heltab2x32(:,:,132))
  call Hloop_Q_A(ntryL,G1H8(21),85,0,G2H8(31),n2h8(183))
  call Hloop_QV_A(ntryL,G1H32(26),wf4(:,1),G1H8(22),m3h4x8(:,112),heltab2x32(:,:,133))
  call Hloop_Q_A(ntryL,G1H8(22),85,0,G2H8(38),n2h8(184))
call HGT_raise_alpha_OLR(G1H32(28),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(28),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(28),wf8(:,8),G1H4(144),m3h8x4(:,6),heltab2x32(:,:,134))
  call Hloop_QV_A(ntryL,G1H32(20),wf4(:,1),G1H8(27),m3h4x8(:,113),heltab2x32(:,:,135))
  call Hloop_Q_A(ntryL,G1H8(27),85,0,G2H8(34),n2h8(185))
  call Hloop_QV_A(ntryL,G1H32(22),wf4(:,1),G1H8(28),m3h4x8(:,114),heltab2x32(:,:,136))
  call Hloop_Q_A(ntryL,G1H8(28),85,0,G2H8(37),n2h8(186))
  call Hloop_QZ_A(ntryL,G1H32(23),wf4(:,8),G1H8(33),ngZd,m3h4x8(:,115),heltab2x32(:,:,137))
  call Hloop_Q_A(ntryL,G1H8(33),85,0,G2H8(46),n2h8(187))
call HGT_raise_alpha_OLR(G1H32(24),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(24),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(24),wf8(:,6),G1H4(145),m3h8x4(:,7),heltab2x32(:,:,138))
  call Hloop_QZ_A(ntryL,G1H32(12),wf4(:,8),G1H8(34),ngZd,m3h4x8(:,116),heltab2x32(:,:,139))
  call Hloop_Q_A(ntryL,G1H8(34),85,0,G2H8(42),n2h8(188))
  call Hloop_QZ_A(ntryL,G1H32(13),wf4(:,8),G1H8(39),ngZd,m3h4x8(:,117),heltab2x32(:,:,140))
  call Hloop_Q_A(ntryL,G1H8(39),85,0,G2H8(76),n2h8(189))
  call Hloop_QZ_A(ntryL,G1H32(14),wf4(:,8),G1H8(40),ngZd,m3h4x8(:,118),heltab2x32(:,:,141))
  call Hloop_Q_A(ntryL,G1H8(40),85,0,G2H8(81),n2h8(190))
call HGT_raise_alpha_OLR(G1H32(16),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(16),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(16),wf8(:,8),G1H4(146),m3h8x4(:,8),heltab2x32(:,:,142))
  call Hloop_QZ_A(ntryL,G1H32(18),wf4(:,8),G1H8(45),ngZd,m3h4x8(:,119),heltab2x32(:,:,143))
  call Hloop_Q_A(ntryL,G1H8(45),85,0,G2H8(83),n2h8(191))
  call Hloop_QZ_A(ntryL,G1H32(19),wf4(:,8),G1H8(46),ngZd,m3h4x8(:,120),heltab2x32(:,:,144))
  call Hloop_Q_A(ntryL,G1H8(46),85,0,G2H8(84),n2h8(192))
  call Hloop_QV_A(ntryL,G1H32(40),wf16(:,13),G1H2(45),m3h16x2(:,1),heltab2x32(:,:,145))
  call Hloop_Q_A(ntryL,G1H2(45),95,0,G2H2(171),n2h2(145))
call HGT_raise_alpha_OLR(G1H32(41),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(41),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(41),ex6(:),G1H16(25),m3h2x16(:,17),heltab2x32(:,:,146))
  call Hloop_QV_A(ntryL,G1H32(43),wf16(:,13),G1H2(46),m3h16x2(:,2),heltab2x32(:,:,147))
  call Hloop_Q_A(ntryL,G1H2(46),95,0,G2H2(172),n2h2(146))
  call Hloop_QV_A(ntryL,G1H32(44),wf16(:,13),G1H2(51),m3h16x2(:,3),heltab2x32(:,:,148))
  call Hloop_Q_A(ntryL,G1H2(51),95,0,G2H2(173),n2h2(147))
  call Hloop_QZ_A(ntryL,G1H32(46),wf16(:,159),G1H2(52),ngZd,m3h16x2(:,4),heltab2x32(:,:,149))
  call Hloop_Q_A(ntryL,G1H2(52),95,0,G2H2(174),n2h2(148))
call HGT_raise_alpha_OLR(G1H32(47),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(47),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(47),ex6(:),G1H16(26),m3h2x16(:,18),heltab2x32(:,:,150))
  call Hloop_QZ_A(ntryL,G1H32(49),wf16(:,159),G1H2(56),ngZd,m3h16x2(:,5),heltab2x32(:,:,151))
  call Hloop_Q_A(ntryL,G1H2(56),95,0,G2H2(175),n2h2(149))
  call Hloop_QZ_A(ntryL,G1H32(50),wf16(:,159),G1H2(57),ngZd,m3h16x2(:,6),heltab2x32(:,:,152))
  call Hloop_Q_A(ntryL,G1H2(57),95,0,G2H2(176),n2h2(150))
  call Hloop_QV_A(ntryL,G1H32(52),wf16(:,15),G1H2(62),m3h16x2(:,7),heltab2x32(:,:,153))
  call Hloop_Q_A(ntryL,G1H2(62),95,0,G2H2(177),n2h2(151))
call HGT_raise_alpha_OLR(G1H32(53),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(53),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(53),ex6(:),G1H16(29),m3h2x16(:,19),heltab2x32(:,:,154))
  call Hloop_QV_A(ntryL,G1H32(55),wf16(:,15),G1H2(63),m3h16x2(:,8),heltab2x32(:,:,155))
  call Hloop_Q_A(ntryL,G1H2(63),95,0,G2H2(178),n2h2(152))
  call Hloop_QV_A(ntryL,G1H32(56),wf16(:,15),G1H2(67),m3h16x2(:,9),heltab2x32(:,:,156))
  call Hloop_Q_A(ntryL,G1H2(67),95,0,G2H2(179),n2h2(153))
  call Hloop_QZ_A(ntryL,G1H32(58),wf16(:,160),G1H2(68),ngZd,m3h16x2(:,10),heltab2x32(:,:,157))
  call Hloop_Q_A(ntryL,G1H2(68),95,0,G2H2(180),n2h2(154))
call HGT_raise_alpha_OLR(G1H32(30),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(30),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(30),ex6(:),G1H16(30),m3h2x16(:,20),heltab2x32(:,:,158))
  call Hloop_QZ_A(ntryL,G1H32(32),wf16(:,160),G1H2(73),ngZd,m3h16x2(:,11),heltab2x32(:,:,159))
  call Hloop_Q_A(ntryL,G1H2(73),95,0,G2H2(181),n2h2(155))
  call Hloop_QZ_A(ntryL,G1H32(34),wf16(:,160),G1H2(74),ngZd,m3h16x2(:,12),heltab2x32(:,:,160))
  call Hloop_Q_A(ntryL,G1H2(74),95,0,G2H2(182),n2h2(156))
  call Hloop_QV_A(ntryL,G1H32(35),wf16(:,17),G1H2(78),m3h16x2(:,13),heltab2x32(:,:,161))
  call Hloop_Q_A(ntryL,G1H2(78),95,0,G2H2(183),n2h2(157))
call HGT_raise_alpha_OLR(G1H32(36),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(36),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(36),ex6(:),G1H16(31),m3h2x16(:,21),heltab2x32(:,:,162))
  call Hloop_QV_A(ntryL,G1H32(38),wf16(:,17),G1H2(79),m3h16x2(:,14),heltab2x32(:,:,163))
  call Hloop_Q_A(ntryL,G1H2(79),95,0,G2H2(184),n2h2(158))
  call Hloop_QV_A(ntryL,G1H32(59),wf16(:,17),G1H2(84),m3h16x2(:,15),heltab2x32(:,:,164))
  call Hloop_Q_A(ntryL,G1H2(84),95,0,G2H2(185),n2h2(159))
  call Hloop_QZ_A(ntryL,G1H32(60),wf16(:,161),G1H2(85),ngZd,m3h16x2(:,16),heltab2x32(:,:,165))
  call Hloop_Q_A(ntryL,G1H2(85),95,0,G2H2(186),n2h2(160))
call HGT_raise_alpha_OLR(G1H32(61),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(61),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(61),ex6(:),G1H16(32),m3h2x16(:,22),heltab2x32(:,:,166))
  call Hloop_QZ_A(ntryL,G1H32(64),wf16(:,161),G1H2(6),ngZd,m3h16x2(:,17),heltab2x32(:,:,167))
  call Hloop_Q_A(ntryL,G1H2(6),95,0,G2H2(187),n2h2(161))
  call Hloop_QZ_A(ntryL,G1H32(65),wf16(:,161),G1H2(17),ngZd,m3h16x2(:,18),heltab2x32(:,:,168))
  call Hloop_Q_A(ntryL,G1H2(17),95,0,G2H2(188),n2h2(162))
  call Hloop_QV_A(ntryL,G1H32(66),wf16(:,19),G1H2(28),m3h16x2(:,19),heltab2x32(:,:,169))
  call Hloop_Q_A(ntryL,G1H2(28),95,0,G2H2(189),n2h2(163))
call HGT_raise_alpha_OLR(G1H32(67),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(67),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(67),ex6(:),G1H16(35),m3h2x16(:,23),heltab2x32(:,:,170))
  call Hloop_QV_A(ntryL,G1H32(70),wf16(:,19),G1H2(39),m3h16x2(:,20),heltab2x32(:,:,171))
  call Hloop_Q_A(ntryL,G1H2(39),95,0,G2H2(190),n2h2(164))
  call Hloop_QV_A(ntryL,G1H32(71),wf16(:,19),G1H2(50),m3h16x2(:,21),heltab2x32(:,:,172))
  call Hloop_Q_A(ntryL,G1H2(50),95,0,G2H2(191),n2h2(165))
  call Hloop_QZ_A(ntryL,G1H32(72),wf16(:,162),G1H2(61),ngZd,m3h16x2(:,22),heltab2x32(:,:,173))
  call Hloop_Q_A(ntryL,G1H2(61),95,0,G2H2(192),n2h2(166))
call HGT_raise_alpha_OLR(G1H32(73),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(73),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(73),ex6(:),G1H16(36),m3h2x16(:,24),heltab2x32(:,:,174))
  call Hloop_QZ_A(ntryL,G1H32(76),wf16(:,162),G1H2(72),ngZd,m3h16x2(:,23),heltab2x32(:,:,175))
  call Hloop_Q_A(ntryL,G1H2(72),95,0,G2H2(193),n2h2(167))
  call Hloop_QZ_A(ntryL,G1H32(77),wf16(:,162),G1H2(83),ngZd,m3h16x2(:,24),heltab2x32(:,:,176))
  call Hloop_Q_A(ntryL,G1H2(83),95,0,G2H2(194),n2h2(168))
  call Hloop_QV_A(ntryL,G1H16(211),wf4(:,17),G1H4(147),m3h4x4(:,307),heltab2x16(:,:,363))
  call Hloop_Q_A(ntryL,G1H4(147),118,0,G2H4(209),n2h4(369))
call HGT_OLR(G1H16(212),1,1,16)
call HGT_invQ_OLR(G1H16(212),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(212),-9,0,G2H16(77),n2h16(351))
  call Hloop_AV_Q(ntryL,G2H16(77),wf4(:,11),G2H4(210),m3h4x4(:,308),heltab2x16(:,:,364))
  call Hloop_QV_A(ntryL,G1H16(214),wf4(:,17),G1H4(147),m3h4x4(:,309),heltab2x16(:,:,365))
  call Hloop_Q_A(ntryL,G1H4(147),118,0,G2H4(211),n2h4(370))
  call Hloop_QV_A(ntryL,G1H16(215),wf4(:,17),G1H4(147),m3h4x4(:,310),heltab2x16(:,:,366))
  call Hloop_Q_A(ntryL,G1H4(147),118,0,G2H4(212),n2h4(371))
  call Hloop_QV_A(ntryL,G0H16(43),wf4(:,17),G0H4(1),m3h4x4(:,311),heltab2x16(:,:,367))
  call Hloop_Q_A(ntryL,G0H4(1),118,0,G1H4(147),n2h4(372))
  call Hloop_QV_A(ntryL,G1H16(216),wf4(:,17),G1H4(148),m3h4x4(:,312),heltab2x16(:,:,368))
  call Hloop_Q_A(ntryL,G1H4(148),118,nMT,G2H4(213),n2h4(373))
call HGT_OLR(G1H16(217),1,1,16)
call HGT_invQ_OLR(G1H16(217),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(217),-9,nMT,G2H16(78),n2h16(352))
  call Hloop_AV_Q(ntryL,G2H16(78),wf4(:,11),G2H4(214),m3h4x4(:,313),heltab2x16(:,:,369))
  call Hloop_QV_A(ntryL,G1H16(219),wf4(:,17),G1H4(148),m3h4x4(:,314),heltab2x16(:,:,370))
  call Hloop_Q_A(ntryL,G1H4(148),118,nMT,G2H4(215),n2h4(374))
  call Hloop_QV_A(ntryL,G1H16(220),wf4(:,17),G1H4(148),m3h4x4(:,315),heltab2x16(:,:,371))
  call Hloop_Q_A(ntryL,G1H4(148),118,nMT,G2H4(216),n2h4(375))
  call Hloop_QV_A(ntryL,G0H16(44),wf4(:,17),G0H4(1),m3h4x4(:,316),heltab2x16(:,:,372))
  call Hloop_Q_A(ntryL,G0H4(1),118,nMT,G1H4(148),n2h4(376))
  call Hloop_AV_Q(ntryL,G1H16(221),wf4(:,17),G1H4(149),m3h4x4(:,317),heltab2x16(:,:,373))
  call Hloop_A_Q(ntryL,G1H4(149),118,0,G2H4(217),n2h4(377))
call HGT_OLR(G1H16(222),1,1,16)
call HGT_invQ_OLR(G1H16(222),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(222),-9,0,G2H16(79),n2h16(353))
  call Hloop_QV_A(ntryL,G2H16(79),wf4(:,11),G2H4(218),m3h4x4(:,318),heltab2x16(:,:,374))
  call Hloop_AV_Q(ntryL,G1H16(224),wf4(:,17),G1H4(149),m3h4x4(:,319),heltab2x16(:,:,375))
  call Hloop_A_Q(ntryL,G1H4(149),118,0,G2H4(219),n2h4(378))
  call Hloop_AV_Q(ntryL,G1H16(225),wf4(:,17),G1H4(149),m3h4x4(:,320),heltab2x16(:,:,376))
  call Hloop_A_Q(ntryL,G1H4(149),118,0,G2H4(220),n2h4(379))
  call Hloop_AV_Q(ntryL,G0H16(45),wf4(:,17),G0H4(1),m3h4x4(:,321),heltab2x16(:,:,377))
  call Hloop_A_Q(ntryL,G0H4(1),118,0,G1H4(149),n2h4(380))
  call Hloop_AV_Q(ntryL,G1H16(226),wf4(:,17),G1H4(150),m3h4x4(:,322),heltab2x16(:,:,378))
  call Hloop_A_Q(ntryL,G1H4(150),118,nMT,G2H4(221),n2h4(381))
call HGT_OLR(G1H16(227),1,1,16)
call HGT_invQ_OLR(G1H16(227),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(227),-9,nMT,G2H16(80),n2h16(354))
  call Hloop_QV_A(ntryL,G2H16(80),wf4(:,11),G2H4(222),m3h4x4(:,323),heltab2x16(:,:,379))
  call Hloop_AV_Q(ntryL,G1H16(229),wf4(:,17),G1H4(150),m3h4x4(:,324),heltab2x16(:,:,380))
  call Hloop_A_Q(ntryL,G1H4(150),118,nMT,G2H4(223),n2h4(382))
  call Hloop_AV_Q(ntryL,G1H16(230),wf4(:,17),G1H4(150),m3h4x4(:,325),heltab2x16(:,:,381))
  call Hloop_A_Q(ntryL,G1H4(150),118,nMT,G2H4(224),n2h4(383))
  call Hloop_AV_Q(ntryL,G0H16(46),wf4(:,17),G0H4(1),m3h4x4(:,326),heltab2x16(:,:,382))
  call Hloop_A_Q(ntryL,G0H4(1),118,nMT,G1H4(150),n2h4(384))
  call Hloop_QV_A(ntryL,G1H16(231),wf4(:,17),G1H4(151),m3h4x4(:,327),heltab2x16(:,:,383))
  call Hloop_Q_A(ntryL,G1H4(151),118,nMB,G2H4(225),n2h4(385))
call HGT_OLR(G1H16(232),1,1,16)
call HGT_invQ_OLR(G1H16(232),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(232),-9,nMB,G2H16(81),n2h16(355))
  call Hloop_AV_Q(ntryL,G2H16(81),wf4(:,11),G2H4(226),m3h4x4(:,328),heltab2x16(:,:,384))
  call Hloop_QV_A(ntryL,G1H16(234),wf4(:,17),G1H4(151),m3h4x4(:,329),heltab2x16(:,:,385))
  call Hloop_Q_A(ntryL,G1H4(151),118,nMB,G2H4(227),n2h4(386))
  call Hloop_QV_A(ntryL,G1H16(235),wf4(:,17),G1H4(151),m3h4x4(:,330),heltab2x16(:,:,386))
  call Hloop_Q_A(ntryL,G1H4(151),118,nMB,G2H4(228),n2h4(387))
  call Hloop_QV_A(ntryL,G0H16(47),wf4(:,17),G0H4(1),m3h4x4(:,331),heltab2x16(:,:,387))
  call Hloop_Q_A(ntryL,G0H4(1),118,nMB,G1H4(151),n2h4(388))
  call Hloop_AV_Q(ntryL,G1H16(236),wf4(:,17),G1H4(152),m3h4x4(:,332),heltab2x16(:,:,388))
  call Hloop_A_Q(ntryL,G1H4(152),118,nMB,G2H4(229),n2h4(389))
call HGT_OLR(G1H16(237),1,1,16)
call HGT_invQ_OLR(G1H16(237),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(237),-9,nMB,G2H16(82),n2h16(356))
  call Hloop_QV_A(ntryL,G2H16(82),wf4(:,11),G2H4(230),m3h4x4(:,333),heltab2x16(:,:,389))
  call Hloop_AV_Q(ntryL,G1H16(239),wf4(:,17),G1H4(152),m3h4x4(:,334),heltab2x16(:,:,390))
  call Hloop_A_Q(ntryL,G1H4(152),118,nMB,G2H4(231),n2h4(390))
  call Hloop_AV_Q(ntryL,G1H16(240),wf4(:,17),G1H4(152),m3h4x4(:,335),heltab2x16(:,:,391))
  call Hloop_A_Q(ntryL,G1H4(152),118,nMB,G2H4(232),n2h4(391))
  call Hloop_AV_Q(ntryL,G0H16(48),wf4(:,17),G0H4(1),m3h4x4(:,336),heltab2x16(:,:,392))
  call Hloop_A_Q(ntryL,G0H4(1),118,nMB,G1H4(152),n2h4(392))
  call Hloop_QV_A(ntryL,G1H16(241),wf4(:,17),G1H4(153),m3h4x4(:,337),heltab2x16(:,:,393))
  call Hloop_Q_A(ntryL,G1H4(153),118,0,G2H4(233),n2h4(393))
call HGT_OLR(G1H16(242),1,1,16)
call HGT_invQ_OLR(G1H16(242),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(242),-9,0,G2H16(91),n2h16(357))
  call Hloop_AZ_Q(ntryL,G2H16(91),wf4(:,16),G2H4(234),ngZu,m3h4x4(:,338),heltab2x16(:,:,394))
  call Hloop_QV_A(ntryL,G1H16(244),wf4(:,17),G1H4(153),m3h4x4(:,339),heltab2x16(:,:,395))
  call Hloop_Q_A(ntryL,G1H4(153),118,0,G2H4(235),n2h4(394))
  call Hloop_QV_A(ntryL,G1H16(245),wf4(:,17),G1H4(153),m3h4x4(:,340),heltab2x16(:,:,396))
  call Hloop_Q_A(ntryL,G1H4(153),118,0,G2H4(236),n2h4(395))
  call Hloop_QV_A(ntryL,G0H16(49),wf4(:,17),G0H4(1),m3h4x4(:,341),heltab2x16(:,:,397))
  call Hloop_Q_A(ntryL,G0H4(1),118,0,G1H4(153),n2h4(396))
  call Hloop_QV_A(ntryL,G1H16(246),wf4(:,17),G1H4(154),m3h4x4(:,342),heltab2x16(:,:,398))
  call Hloop_Q_A(ntryL,G1H4(154),118,nMT,G2H4(237),n2h4(397))
call HGT_OLR(G1H16(247),1,1,16)
call HGT_invQ_OLR(G1H16(247),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(247),-9,nMT,G2H16(93),n2h16(358))
  call Hloop_AZ_Q(ntryL,G2H16(93),wf4(:,16),G2H4(238),ngZu,m3h4x4(:,343),heltab2x16(:,:,399))
  call Hloop_QV_A(ntryL,G1H16(249),wf4(:,17),G1H4(154),m3h4x4(:,344),heltab2x16(:,:,400))
  call Hloop_Q_A(ntryL,G1H4(154),118,nMT,G2H4(239),n2h4(398))
  call Hloop_QV_A(ntryL,G1H16(250),wf4(:,17),G1H4(154),m3h4x4(:,345),heltab2x16(:,:,401))
  call Hloop_Q_A(ntryL,G1H4(154),118,nMT,G2H4(240),n2h4(399))
  call Hloop_QV_A(ntryL,G0H16(50),wf4(:,17),G0H4(1),m3h4x4(:,346),heltab2x16(:,:,402))
  call Hloop_Q_A(ntryL,G0H4(1),118,nMT,G1H4(154),n2h4(400))
  call Hloop_AV_Q(ntryL,G1H16(251),wf4(:,17),G1H4(155),m3h4x4(:,347),heltab2x16(:,:,403))
  call Hloop_A_Q(ntryL,G1H4(155),118,0,G2H4(241),n2h4(401))
call HGT_OLR(G1H16(252),1,1,16)
call HGT_invQ_OLR(G1H16(252),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(252),-9,0,G2H16(95),n2h16(359))
  call Hloop_QZ_A(ntryL,G2H16(95),wf4(:,16),G2H4(242),ngZu,m3h4x4(:,348),heltab2x16(:,:,404))
  call Hloop_AV_Q(ntryL,G1H16(254),wf4(:,17),G1H4(155),m3h4x4(:,349),heltab2x16(:,:,405))
  call Hloop_A_Q(ntryL,G1H4(155),118,0,G2H4(243),n2h4(402))
  call Hloop_AV_Q(ntryL,G1H16(255),wf4(:,17),G1H4(155),m3h4x4(:,350),heltab2x16(:,:,406))
  call Hloop_A_Q(ntryL,G1H4(155),118,0,G2H4(244),n2h4(403))
  call Hloop_AV_Q(ntryL,G0H16(51),wf4(:,17),G0H4(1),m3h4x4(:,351),heltab2x16(:,:,407))
  call Hloop_A_Q(ntryL,G0H4(1),118,0,G1H4(155),n2h4(404))
  call Hloop_AV_Q(ntryL,G1H16(256),wf4(:,17),G1H4(156),m3h4x4(:,352),heltab2x16(:,:,408))
  call Hloop_A_Q(ntryL,G1H4(156),118,nMT,G2H4(245),n2h4(405))
call HGT_OLR(G1H16(257),1,1,16)
call HGT_invQ_OLR(G1H16(257),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(257),-9,nMT,G2H16(97),n2h16(360))
  call Hloop_QZ_A(ntryL,G2H16(97),wf4(:,16),G2H4(246),ngZu,m3h4x4(:,353),heltab2x16(:,:,409))
  call Hloop_AV_Q(ntryL,G1H16(259),wf4(:,17),G1H4(156),m3h4x4(:,354),heltab2x16(:,:,410))
  call Hloop_A_Q(ntryL,G1H4(156),118,nMT,G2H4(247),n2h4(406))
  call Hloop_AV_Q(ntryL,G1H16(260),wf4(:,17),G1H4(156),m3h4x4(:,355),heltab2x16(:,:,411))
  call Hloop_A_Q(ntryL,G1H4(156),118,nMT,G2H4(248),n2h4(407))
  call Hloop_AV_Q(ntryL,G0H16(52),wf4(:,17),G0H4(1),m3h4x4(:,356),heltab2x16(:,:,412))
  call Hloop_A_Q(ntryL,G0H4(1),118,nMT,G1H4(156),n2h4(408))
  call Hloop_QV_A(ntryL,G1H16(261),wf4(:,17),G1H4(157),m3h4x4(:,357),heltab2x16(:,:,413))
  call Hloop_Q_A(ntryL,G1H4(157),118,0,G2H4(249),n2h4(409))
call HGT_OLR(G1H16(262),1,1,16)
call HGT_invQ_OLR(G1H16(262),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(262),-9,0,G2H16(99),n2h16(361))
  call Hloop_AZ_Q(ntryL,G2H16(99),wf4(:,16),G2H4(250),ngZd,m3h4x4(:,358),heltab2x16(:,:,414))
  call Hloop_QV_A(ntryL,G1H16(264),wf4(:,17),G1H4(157),m3h4x4(:,359),heltab2x16(:,:,415))
  call Hloop_Q_A(ntryL,G1H4(157),118,0,G2H4(251),n2h4(410))
  call Hloop_QV_A(ntryL,G1H16(265),wf4(:,17),G1H4(157),m3h4x4(:,360),heltab2x16(:,:,416))
  call Hloop_Q_A(ntryL,G1H4(157),118,0,G2H4(252),n2h4(411))
  call Hloop_QV_A(ntryL,G0H16(53),wf4(:,17),G0H4(1),m3h4x4(:,361),heltab2x16(:,:,417))
  call Hloop_Q_A(ntryL,G0H4(1),118,0,G1H4(157),n2h4(412))
  call Hloop_QV_A(ntryL,G1H16(266),wf4(:,17),G1H4(158),m3h4x4(:,362),heltab2x16(:,:,418))
  call Hloop_Q_A(ntryL,G1H4(158),118,nMB,G2H4(253),n2h4(413))
call HGT_OLR(G1H16(267),1,1,16)
call HGT_invQ_OLR(G1H16(267),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(267),-9,nMB,G2H16(101),n2h16(362))
  call Hloop_AZ_Q(ntryL,G2H16(101),wf4(:,16),G2H4(254),ngZd,m3h4x4(:,363),heltab2x16(:,:,419))
  call Hloop_QV_A(ntryL,G1H16(269),wf4(:,17),G1H4(158),m3h4x4(:,364),heltab2x16(:,:,420))
  call Hloop_Q_A(ntryL,G1H4(158),118,nMB,G2H4(255),n2h4(414))
  call Hloop_QV_A(ntryL,G1H16(270),wf4(:,17),G1H4(158),m3h4x4(:,365),heltab2x16(:,:,421))
  call Hloop_Q_A(ntryL,G1H4(158),118,nMB,G2H4(256),n2h4(415))
  call Hloop_QV_A(ntryL,G0H16(54),wf4(:,17),G0H4(1),m3h4x4(:,366),heltab2x16(:,:,422))
  call Hloop_Q_A(ntryL,G0H4(1),118,nMB,G1H4(158),n2h4(416))
  call Hloop_AV_Q(ntryL,G1H16(271),wf4(:,17),G1H4(159),m3h4x4(:,367),heltab2x16(:,:,423))
  call Hloop_A_Q(ntryL,G1H4(159),118,0,G2H4(257),n2h4(417))
call HGT_OLR(G1H16(272),1,1,16)
call HGT_invQ_OLR(G1H16(272),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(272),-9,0,G2H16(103),n2h16(363))
  call Hloop_QZ_A(ntryL,G2H16(103),wf4(:,16),G2H4(258),ngZd,m3h4x4(:,368),heltab2x16(:,:,424))
  call Hloop_AV_Q(ntryL,G1H16(274),wf4(:,17),G1H4(159),m3h4x4(:,369),heltab2x16(:,:,425))
  call Hloop_A_Q(ntryL,G1H4(159),118,0,G2H4(259),n2h4(418))
  call Hloop_AV_Q(ntryL,G1H16(275),wf4(:,17),G1H4(159),m3h4x4(:,370),heltab2x16(:,:,426))
  call Hloop_A_Q(ntryL,G1H4(159),118,0,G2H4(260),n2h4(419))
  call Hloop_AV_Q(ntryL,G0H16(55),wf4(:,17),G0H4(1),m3h4x4(:,371),heltab2x16(:,:,427))
  call Hloop_A_Q(ntryL,G0H4(1),118,0,G1H4(159),n2h4(420))
  call Hloop_AV_Q(ntryL,G1H16(276),wf4(:,17),G1H4(160),m3h4x4(:,372),heltab2x16(:,:,428))
  call Hloop_A_Q(ntryL,G1H4(160),118,nMB,G2H4(261),n2h4(421))
call HGT_OLR(G1H16(277),1,1,16)
call HGT_invQ_OLR(G1H16(277),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(277),-9,nMB,G2H16(105),n2h16(364))
  call Hloop_QZ_A(ntryL,G2H16(105),wf4(:,16),G2H4(262),ngZd,m3h4x4(:,373),heltab2x16(:,:,429))
  call Hloop_AV_Q(ntryL,G1H16(279),wf4(:,17),G1H4(160),m3h4x4(:,374),heltab2x16(:,:,430))
  call Hloop_A_Q(ntryL,G1H4(160),118,nMB,G2H4(263),n2h4(422))
  call Hloop_AV_Q(ntryL,G1H16(280),wf4(:,17),G1H4(160),m3h4x4(:,375),heltab2x16(:,:,431))
  call Hloop_A_Q(ntryL,G1H4(160),118,nMB,G2H4(264),n2h4(423))
  call Hloop_AV_Q(ntryL,G0H16(56),wf4(:,17),G0H4(1),m3h4x4(:,376),heltab2x16(:,:,432))
  call Hloop_A_Q(ntryL,G0H4(1),118,nMB,G1H4(160),n2h4(424))
  call Hloop_AV_Q(ntryL,G1H16(281),wf4(:,12),G1H4(161),m3h4x4(:,377),heltab2x16(:,:,433))
  call Hloop_A_Q(ntryL,G1H4(161),79,0,G2H4(265),n2h4(425))
call HGT_OLR(G1H16(282),1,1,16)
call HGT_invQ_OLR(G1H16(282),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(282),-48,0,G2H16(107),n2h16(365))
  call Hloop_QV_A(ntryL,G2H16(107),wf4(:,17),G2H4(266),m3h4x4(:,378),heltab2x16(:,:,434))
  call Hloop_AV_Q(ntryL,G1H16(284),wf4(:,12),G1H4(161),m3h4x4(:,379),heltab2x16(:,:,435))
  call Hloop_A_Q(ntryL,G1H4(161),79,0,G2H4(267),n2h4(426))
  call Hloop_AV_Q(ntryL,G1H16(285),wf4(:,12),G1H4(161),m3h4x4(:,380),heltab2x16(:,:,436))
  call Hloop_A_Q(ntryL,G1H4(161),79,0,G2H4(268),n2h4(427))
  call Hloop_AV_Q(ntryL,G0H16(57),wf4(:,12),G0H4(1),m3h4x4(:,381),heltab2x16(:,:,437))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(161),n2h4(428))
  call Hloop_AV_Q(ntryL,G1H16(286),wf4(:,12),G1H4(162),m3h4x4(:,382),heltab2x16(:,:,438))
  call Hloop_A_Q(ntryL,G1H4(162),79,nMT,G2H4(269),n2h4(429))
call HGT_OLR(G1H16(287),1,1,16)
call HGT_invQ_OLR(G1H16(287),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(287),-48,nMT,G2H16(108),n2h16(366))
  call Hloop_QV_A(ntryL,G2H16(108),wf4(:,17),G2H4(270),m3h4x4(:,383),heltab2x16(:,:,439))
  call Hloop_AV_Q(ntryL,G1H16(289),wf4(:,12),G1H4(162),m3h4x4(:,384),heltab2x16(:,:,440))
  call Hloop_A_Q(ntryL,G1H4(162),79,nMT,G2H4(271),n2h4(430))
  call Hloop_AV_Q(ntryL,G1H16(290),wf4(:,12),G1H4(162),m3h4x4(:,385),heltab2x16(:,:,441))
  call Hloop_A_Q(ntryL,G1H4(162),79,nMT,G2H4(272),n2h4(431))
  call Hloop_AV_Q(ntryL,G0H16(58),wf4(:,12),G0H4(1),m3h4x4(:,386),heltab2x16(:,:,442))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMT,G1H4(162),n2h4(432))
  call Hloop_QV_A(ntryL,G1H16(291),wf4(:,12),G1H4(163),m3h4x4(:,387),heltab2x16(:,:,443))
  call Hloop_Q_A(ntryL,G1H4(163),79,0,G2H4(273),n2h4(433))
call HGT_OLR(G1H16(292),1,1,16)
call HGT_invQ_OLR(G1H16(292),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(292),-48,0,G2H16(111),n2h16(367))
  call Hloop_AV_Q(ntryL,G2H16(111),wf4(:,17),G2H4(274),m3h4x4(:,388),heltab2x16(:,:,444))
  call Hloop_QV_A(ntryL,G1H16(294),wf4(:,12),G1H4(163),m3h4x4(:,389),heltab2x16(:,:,445))
  call Hloop_Q_A(ntryL,G1H4(163),79,0,G2H4(275),n2h4(434))
  call Hloop_QV_A(ntryL,G1H16(295),wf4(:,12),G1H4(163),m3h4x4(:,390),heltab2x16(:,:,446))
  call Hloop_Q_A(ntryL,G1H4(163),79,0,G2H4(276),n2h4(435))
  call Hloop_QV_A(ntryL,G0H16(59),wf4(:,12),G0H4(1),m3h4x4(:,391),heltab2x16(:,:,447))
  call Hloop_Q_A(ntryL,G0H4(1),79,0,G1H4(163),n2h4(436))
  call Hloop_QV_A(ntryL,G1H16(296),wf4(:,12),G1H4(164),m3h4x4(:,392),heltab2x16(:,:,448))
  call Hloop_Q_A(ntryL,G1H4(164),79,nMT,G2H4(277),n2h4(437))
call HGT_OLR(G1H16(297),1,1,16)
call HGT_invQ_OLR(G1H16(297),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(297),-48,nMT,G2H16(112),n2h16(368))
  call Hloop_AV_Q(ntryL,G2H16(112),wf4(:,17),G2H4(278),m3h4x4(:,393),heltab2x16(:,:,449))
  call Hloop_QV_A(ntryL,G1H16(299),wf4(:,12),G1H4(164),m3h4x4(:,394),heltab2x16(:,:,450))
  call Hloop_Q_A(ntryL,G1H4(164),79,nMT,G2H4(279),n2h4(438))
  call Hloop_QV_A(ntryL,G1H16(300),wf4(:,12),G1H4(164),m3h4x4(:,395),heltab2x16(:,:,451))
  call Hloop_Q_A(ntryL,G1H4(164),79,nMT,G2H4(280),n2h4(439))
  call Hloop_QV_A(ntryL,G0H16(60),wf4(:,12),G0H4(1),m3h4x4(:,396),heltab2x16(:,:,452))
  call Hloop_Q_A(ntryL,G0H4(1),79,nMT,G1H4(164),n2h4(440))
  call Hloop_AV_Q(ntryL,G1H16(301),wf4(:,12),G1H4(165),m3h4x4(:,397),heltab2x16(:,:,453))
  call Hloop_A_Q(ntryL,G1H4(165),79,nMB,G2H4(281),n2h4(441))
call HGT_OLR(G1H16(302),1,1,16)
call HGT_invQ_OLR(G1H16(302),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(302),-48,nMB,G2H16(115),n2h16(369))
  call Hloop_QV_A(ntryL,G2H16(115),wf4(:,17),G2H4(282),m3h4x4(:,398),heltab2x16(:,:,454))
  call Hloop_AV_Q(ntryL,G1H16(304),wf4(:,12),G1H4(165),m3h4x4(:,399),heltab2x16(:,:,455))
  call Hloop_A_Q(ntryL,G1H4(165),79,nMB,G2H4(283),n2h4(442))
  call Hloop_AV_Q(ntryL,G1H16(305),wf4(:,12),G1H4(165),m3h4x4(:,400),heltab2x16(:,:,456))
  call Hloop_A_Q(ntryL,G1H4(165),79,nMB,G2H4(284),n2h4(443))
  call Hloop_AV_Q(ntryL,G0H16(61),wf4(:,12),G0H4(1),m3h4x4(:,401),heltab2x16(:,:,457))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(165),n2h4(444))
  call Hloop_QV_A(ntryL,G1H16(306),wf4(:,12),G1H4(166),m3h4x4(:,402),heltab2x16(:,:,458))
  call Hloop_Q_A(ntryL,G1H4(166),79,nMB,G2H4(285),n2h4(445))
call HGT_OLR(G1H16(307),1,1,16)
call HGT_invQ_OLR(G1H16(307),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(307),-48,nMB,G2H16(116),n2h16(370))
  call Hloop_AV_Q(ntryL,G2H16(116),wf4(:,17),G2H4(286),m3h4x4(:,403),heltab2x16(:,:,459))
  call Hloop_QV_A(ntryL,G1H16(309),wf4(:,12),G1H4(166),m3h4x4(:,404),heltab2x16(:,:,460))
  call Hloop_Q_A(ntryL,G1H4(166),79,nMB,G2H4(287),n2h4(446))
  call Hloop_QV_A(ntryL,G1H16(310),wf4(:,12),G1H4(166),m3h4x4(:,405),heltab2x16(:,:,461))
  call Hloop_Q_A(ntryL,G1H4(166),79,nMB,G2H4(288),n2h4(447))
  call Hloop_QV_A(ntryL,G0H16(62),wf4(:,12),G0H4(1),m3h4x4(:,406),heltab2x16(:,:,462))
  call Hloop_Q_A(ntryL,G0H4(1),79,nMB,G1H4(166),n2h4(448))
  call Hloop_AZ_Q(ntryL,G1H16(311),wf4(:,14),G1H4(167),ngZu,m3h4x4(:,407),heltab2x16(:,:,463))
  call Hloop_A_Q(ntryL,G1H4(167),79,0,G2H4(289),n2h4(449))
call HGT_OLR(G1H16(312),1,1,16)
call HGT_invQ_OLR(G1H16(312),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(312),-48,0,G2H16(119),n2h16(371))
  call Hloop_QV_A(ntryL,G2H16(119),wf4(:,17),G2H4(290),m3h4x4(:,408),heltab2x16(:,:,464))
  call Hloop_AZ_Q(ntryL,G1H16(314),wf4(:,14),G1H4(167),ngZu,m3h4x4(:,409),heltab2x16(:,:,465))
  call Hloop_A_Q(ntryL,G1H4(167),79,0,G2H4(291),n2h4(450))
  call Hloop_AZ_Q(ntryL,G1H16(315),wf4(:,14),G1H4(167),ngZu,m3h4x4(:,410),heltab2x16(:,:,466))
  call Hloop_A_Q(ntryL,G1H4(167),79,0,G2H4(292),n2h4(451))
  call Hloop_AZ_Q(ntryL,G0H16(63),wf4(:,14),G0H4(1),ngZu,m3h4x4(:,411),heltab2x16(:,:,467))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(167),n2h4(452))
  call Hloop_AZ_Q(ntryL,G1H16(316),wf4(:,14),G1H4(168),ngZu,m3h4x4(:,412),heltab2x16(:,:,468))
  call Hloop_A_Q(ntryL,G1H4(168),79,nMT,G2H4(293),n2h4(453))
call HGT_OLR(G1H16(317),1,1,16)
call HGT_invQ_OLR(G1H16(317),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(317),-48,nMT,G2H16(120),n2h16(372))
  call Hloop_QV_A(ntryL,G2H16(120),wf4(:,17),G2H4(294),m3h4x4(:,413),heltab2x16(:,:,469))
  call Hloop_AZ_Q(ntryL,G1H16(319),wf4(:,14),G1H4(168),ngZu,m3h4x4(:,414),heltab2x16(:,:,470))
  call Hloop_A_Q(ntryL,G1H4(168),79,nMT,G2H4(295),n2h4(454))
  call Hloop_AZ_Q(ntryL,G1H16(320),wf4(:,14),G1H4(168),ngZu,m3h4x4(:,415),heltab2x16(:,:,471))
  call Hloop_A_Q(ntryL,G1H4(168),79,nMT,G2H4(296),n2h4(455))
  call Hloop_AZ_Q(ntryL,G0H16(64),wf4(:,14),G0H4(1),ngZu,m3h4x4(:,416),heltab2x16(:,:,472))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMT,G1H4(168),n2h4(456))
  call Hloop_QZ_A(ntryL,G1H16(321),wf4(:,14),G1H4(169),ngZu,m3h4x4(:,417),heltab2x16(:,:,473))
  call Hloop_Q_A(ntryL,G1H4(169),79,0,G2H4(297),n2h4(457))
call HGT_OLR(G1H16(322),1,1,16)
call HGT_invQ_OLR(G1H16(322),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(322),-48,0,G2H16(129),n2h16(373))
  call Hloop_AV_Q(ntryL,G2H16(129),wf4(:,17),G2H4(298),m3h4x4(:,418),heltab2x16(:,:,474))
  call Hloop_QZ_A(ntryL,G1H16(324),wf4(:,14),G1H4(169),ngZu,m3h4x4(:,419),heltab2x16(:,:,475))
  call Hloop_Q_A(ntryL,G1H4(169),79,0,G2H4(299),n2h4(458))
  call Hloop_QZ_A(ntryL,G1H16(325),wf4(:,14),G1H4(169),ngZu,m3h4x4(:,420),heltab2x16(:,:,476))
  call Hloop_Q_A(ntryL,G1H4(169),79,0,G2H4(300),n2h4(459))
  call Hloop_QZ_A(ntryL,G0H16(65),wf4(:,14),G0H4(1),ngZu,m3h4x4(:,421),heltab2x16(:,:,477))
  call Hloop_Q_A(ntryL,G0H4(1),79,0,G1H4(169),n2h4(460))
  call Hloop_QZ_A(ntryL,G1H16(326),wf4(:,14),G1H4(170),ngZu,m3h4x4(:,422),heltab2x16(:,:,478))
  call Hloop_Q_A(ntryL,G1H4(170),79,nMT,G2H4(301),n2h4(461))
call HGT_OLR(G1H16(327),1,1,16)
call HGT_invQ_OLR(G1H16(327),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(327),-48,nMT,G2H16(123),n2h16(374))
  call Hloop_AV_Q(ntryL,G2H16(123),wf4(:,17),G2H4(302),m3h4x4(:,423),heltab2x16(:,:,479))
  call Hloop_QZ_A(ntryL,G1H16(329),wf4(:,14),G1H4(170),ngZu,m3h4x4(:,424),heltab2x16(:,:,480))
  call Hloop_Q_A(ntryL,G1H4(170),79,nMT,G2H4(303),n2h4(462))
  call Hloop_QZ_A(ntryL,G1H16(330),wf4(:,14),G1H4(170),ngZu,m3h4x4(:,425),heltab2x16(:,:,481))
  call Hloop_Q_A(ntryL,G1H4(170),79,nMT,G2H4(304),n2h4(463))
  call Hloop_QZ_A(ntryL,G0H16(66),wf4(:,14),G0H4(1),ngZu,m3h4x4(:,426),heltab2x16(:,:,482))
  call Hloop_Q_A(ntryL,G0H4(1),79,nMT,G1H4(170),n2h4(464))
  call Hloop_AZ_Q(ntryL,G1H16(331),wf4(:,14),G1H4(171),ngZd,m3h4x4(:,427),heltab2x16(:,:,483))
  call Hloop_A_Q(ntryL,G1H4(171),79,0,G2H4(305),n2h4(465))
call HGT_OLR(G1H16(332),1,1,16)
call HGT_invQ_OLR(G1H16(332),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(332),-48,0,G2H16(124),n2h16(375))
  call Hloop_QV_A(ntryL,G2H16(124),wf4(:,17),G2H4(306),m3h4x4(:,428),heltab2x16(:,:,484))
  call Hloop_AZ_Q(ntryL,G1H16(334),wf4(:,14),G1H4(171),ngZd,m3h4x4(:,429),heltab2x16(:,:,485))
  call Hloop_A_Q(ntryL,G1H4(171),79,0,G2H4(307),n2h4(466))
  call Hloop_AZ_Q(ntryL,G1H16(335),wf4(:,14),G1H4(171),ngZd,m3h4x4(:,430),heltab2x16(:,:,486))
  call Hloop_A_Q(ntryL,G1H4(171),79,0,G2H4(308),n2h4(467))
  call Hloop_AZ_Q(ntryL,G0H16(67),wf4(:,14),G0H4(1),ngZd,m3h4x4(:,431),heltab2x16(:,:,487))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(171),n2h4(468))
  call Hloop_AZ_Q(ntryL,G1H16(336),wf4(:,14),G1H4(172),ngZd,m3h4x4(:,432),heltab2x16(:,:,488))
  call Hloop_A_Q(ntryL,G1H4(172),79,nMB,G2H4(309),n2h4(469))
call HGT_OLR(G1H16(337),1,1,16)
call HGT_invQ_OLR(G1H16(337),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(337),-48,nMB,G2H16(131),n2h16(376))
  call Hloop_QV_A(ntryL,G2H16(131),wf4(:,17),G2H4(310),m3h4x4(:,433),heltab2x16(:,:,489))
  call Hloop_AZ_Q(ntryL,G1H16(339),wf4(:,14),G1H4(172),ngZd,m3h4x4(:,434),heltab2x16(:,:,490))
  call Hloop_A_Q(ntryL,G1H4(172),79,nMB,G2H4(311),n2h4(470))
  call Hloop_AZ_Q(ntryL,G1H16(340),wf4(:,14),G1H4(172),ngZd,m3h4x4(:,435),heltab2x16(:,:,491))
  call Hloop_A_Q(ntryL,G1H4(172),79,nMB,G2H4(312),n2h4(471))
  call Hloop_AZ_Q(ntryL,G0H16(68),wf4(:,14),G0H4(1),ngZd,m3h4x4(:,436),heltab2x16(:,:,492))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(172),n2h4(472))
  call Hloop_QZ_A(ntryL,G1H16(341),wf4(:,14),G1H4(173),ngZd,m3h4x4(:,437),heltab2x16(:,:,493))
  call Hloop_Q_A(ntryL,G1H4(173),79,0,G2H4(313),n2h4(473))
call HGT_OLR(G1H16(342),1,1,16)
call HGT_invQ_OLR(G1H16(342),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(342),-48,0,G2H16(125),n2h16(377))
  call Hloop_AV_Q(ntryL,G2H16(125),wf4(:,17),G2H4(314),m3h4x4(:,438),heltab2x16(:,:,494))
  call Hloop_QZ_A(ntryL,G1H16(344),wf4(:,14),G1H4(173),ngZd,m3h4x4(:,439),heltab2x16(:,:,495))
  call Hloop_Q_A(ntryL,G1H4(173),79,0,G2H4(315),n2h4(474))
  call Hloop_QZ_A(ntryL,G1H16(345),wf4(:,14),G1H4(173),ngZd,m3h4x4(:,440),heltab2x16(:,:,496))
  call Hloop_Q_A(ntryL,G1H4(173),79,0,G2H4(316),n2h4(475))
  call Hloop_QZ_A(ntryL,G0H16(69),wf4(:,14),G0H4(1),ngZd,m3h4x4(:,441),heltab2x16(:,:,497))
  call Hloop_Q_A(ntryL,G0H4(1),79,0,G1H4(173),n2h4(476))
  call Hloop_QZ_A(ntryL,G1H16(346),wf4(:,14),G1H4(174),ngZd,m3h4x4(:,442),heltab2x16(:,:,498))
  call Hloop_Q_A(ntryL,G1H4(174),79,nMB,G2H4(317),n2h4(477))
call HGT_OLR(G1H16(347),1,1,16)
call HGT_invQ_OLR(G1H16(347),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(347),-48,nMB,G2H16(126),n2h16(378))
  call Hloop_AV_Q(ntryL,G2H16(126),wf4(:,17),G2H4(318),m3h4x4(:,443),heltab2x16(:,:,499))
  call Hloop_QZ_A(ntryL,G1H16(349),wf4(:,14),G1H4(174),ngZd,m3h4x4(:,444),heltab2x16(:,:,500))
  call Hloop_Q_A(ntryL,G1H4(174),79,nMB,G2H4(319),n2h4(478))
  call Hloop_QZ_A(ntryL,G1H16(350),wf4(:,14),G1H4(174),ngZd,m3h4x4(:,445),heltab2x16(:,:,501))
  call Hloop_Q_A(ntryL,G1H4(174),79,nMB,G2H4(320),n2h4(479))
  call Hloop_QZ_A(ntryL,G0H16(70),wf4(:,14),G0H4(1),ngZd,m3h4x4(:,446),heltab2x16(:,:,502))
  call Hloop_Q_A(ntryL,G0H4(1),79,nMB,G1H4(174),n2h4(480))
  call Hloop_AV_Q(ntryL,G1H16(351),wf4(:,11),G1H4(175),m3h4x4(:,447),heltab2x16(:,:,503))
  call Hloop_A_Q(ntryL,G1H4(175),79,0,G2H4(321),n2h4(481))
call HGT_OLR(G1H16(352),1,1,16)
call HGT_invQ_OLR(G1H16(352),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(352),-48,0,G2H16(127),n2h16(379))
  call Hloop_QV_A(ntryL,G2H16(127),wf4(:,17),G2H4(322),m3h4x4(:,448),heltab2x16(:,:,504))
  call Hloop_AV_Q(ntryL,G1H16(354),wf4(:,11),G1H4(175),m3h4x4(:,449),heltab2x16(:,:,505))
  call Hloop_A_Q(ntryL,G1H4(175),79,0,G2H4(323),n2h4(482))
  call Hloop_AV_Q(ntryL,G1H16(355),wf4(:,11),G1H4(175),m3h4x4(:,450),heltab2x16(:,:,506))
  call Hloop_A_Q(ntryL,G1H4(175),79,0,G2H4(324),n2h4(483))
  call Hloop_AV_Q(ntryL,G0H16(71),wf4(:,11),G0H4(1),m3h4x4(:,451),heltab2x16(:,:,507))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(175),n2h4(484))
  call Hloop_AV_Q(ntryL,G1H16(356),wf4(:,11),G1H4(176),m3h4x4(:,452),heltab2x16(:,:,508))
  call Hloop_A_Q(ntryL,G1H4(176),79,nMT,G2H4(325),n2h4(485))
call HGT_OLR(G1H16(357),1,1,16)
call HGT_invQ_OLR(G1H16(357),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(357),-48,nMT,G2H16(128),n2h16(380))
  call Hloop_QV_A(ntryL,G2H16(128),wf4(:,17),G2H4(326),m3h4x4(:,453),heltab2x16(:,:,509))
  call Hloop_AV_Q(ntryL,G1H16(359),wf4(:,11),G1H4(176),m3h4x4(:,454),heltab2x16(:,:,510))
  call Hloop_A_Q(ntryL,G1H4(176),79,nMT,G2H4(327),n2h4(486))
  call Hloop_AV_Q(ntryL,G1H16(360),wf4(:,11),G1H4(176),m3h4x4(:,455),heltab2x16(:,:,511))
  call Hloop_A_Q(ntryL,G1H4(176),79,nMT,G2H4(328),n2h4(487))
  call Hloop_AV_Q(ntryL,G0H16(72),wf4(:,11),G0H4(1),m3h4x4(:,456),heltab2x16(:,:,512))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMT,G1H4(176),n2h4(488))
  call Hloop_QV_A(ntryL,G1H16(361),wf4(:,11),G1H4(177),m3h4x4(:,457),heltab2x16(:,:,513))
  call Hloop_Q_A(ntryL,G1H4(177),79,0,G2H4(329),n2h4(489))
call HGT_OLR(G1H16(362),1,1,16)
call HGT_invQ_OLR(G1H16(362),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(362),-48,0,G2H16(137),n2h16(381))
  call Hloop_AV_Q(ntryL,G2H16(137),wf4(:,17),G2H4(330),m3h4x4(:,458),heltab2x16(:,:,514))
  call Hloop_QV_A(ntryL,G1H16(364),wf4(:,11),G1H4(177),m3h4x4(:,459),heltab2x16(:,:,515))
  call Hloop_Q_A(ntryL,G1H4(177),79,0,G2H4(331),n2h4(490))
  call Hloop_QV_A(ntryL,G1H16(365),wf4(:,11),G1H4(177),m3h4x4(:,460),heltab2x16(:,:,516))
  call Hloop_Q_A(ntryL,G1H4(177),79,0,G2H4(332),n2h4(491))
  call Hloop_QV_A(ntryL,G0H16(73),wf4(:,11),G0H4(1),m3h4x4(:,461),heltab2x16(:,:,517))
  call Hloop_Q_A(ntryL,G0H4(1),79,0,G1H4(177),n2h4(492))
  call Hloop_QV_A(ntryL,G1H16(366),wf4(:,11),G1H4(178),m3h4x4(:,462),heltab2x16(:,:,518))
  call Hloop_Q_A(ntryL,G1H4(178),79,nMT,G2H4(333),n2h4(493))
call HGT_OLR(G1H16(367),1,1,16)
call HGT_invQ_OLR(G1H16(367),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(367),-48,nMT,G2H16(138),n2h16(382))
  call Hloop_AV_Q(ntryL,G2H16(138),wf4(:,17),G2H4(334),m3h4x4(:,463),heltab2x16(:,:,519))
  call Hloop_QV_A(ntryL,G1H16(369),wf4(:,11),G1H4(178),m3h4x4(:,464),heltab2x16(:,:,520))
  call Hloop_Q_A(ntryL,G1H4(178),79,nMT,G2H4(335),n2h4(494))
  call Hloop_QV_A(ntryL,G1H16(370),wf4(:,11),G1H4(178),m3h4x4(:,465),heltab2x16(:,:,521))
  call Hloop_Q_A(ntryL,G1H4(178),79,nMT,G2H4(336),n2h4(495))
  call Hloop_QV_A(ntryL,G0H16(74),wf4(:,11),G0H4(1),m3h4x4(:,466),heltab2x16(:,:,522))
  call Hloop_Q_A(ntryL,G0H4(1),79,nMT,G1H4(178),n2h4(496))
  call Hloop_AV_Q(ntryL,G1H16(371),wf4(:,11),G1H4(179),m3h4x4(:,467),heltab2x16(:,:,523))
  call Hloop_A_Q(ntryL,G1H4(179),79,nMB,G2H4(337),n2h4(497))
call HGT_OLR(G1H16(372),1,1,16)
call HGT_invQ_OLR(G1H16(372),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(372),-48,nMB,G2H16(139),n2h16(383))
  call Hloop_QV_A(ntryL,G2H16(139),wf4(:,17),G2H4(338),m3h4x4(:,468),heltab2x16(:,:,524))
  call Hloop_AV_Q(ntryL,G1H16(374),wf4(:,11),G1H4(179),m3h4x4(:,469),heltab2x16(:,:,525))
  call Hloop_A_Q(ntryL,G1H4(179),79,nMB,G2H4(339),n2h4(498))
  call Hloop_AV_Q(ntryL,G1H16(375),wf4(:,11),G1H4(179),m3h4x4(:,470),heltab2x16(:,:,526))
  call Hloop_A_Q(ntryL,G1H4(179),79,nMB,G2H4(340),n2h4(499))
  call Hloop_AV_Q(ntryL,G0H16(75),wf4(:,11),G0H4(1),m3h4x4(:,471),heltab2x16(:,:,527))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(179),n2h4(500))
  call Hloop_QV_A(ntryL,G1H16(376),wf4(:,11),G1H4(180),m3h4x4(:,472),heltab2x16(:,:,528))
  call Hloop_Q_A(ntryL,G1H4(180),79,nMB,G2H4(341),n2h4(501))
call HGT_OLR(G1H16(377),1,1,16)
call HGT_invQ_OLR(G1H16(377),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(377),-48,nMB,G2H16(140),n2h16(384))
  call Hloop_AV_Q(ntryL,G2H16(140),wf4(:,17),G2H4(342),m3h4x4(:,473),heltab2x16(:,:,529))
  call Hloop_QV_A(ntryL,G1H16(379),wf4(:,11),G1H4(180),m3h4x4(:,474),heltab2x16(:,:,530))
  call Hloop_Q_A(ntryL,G1H4(180),79,nMB,G2H4(343),n2h4(502))
  call Hloop_QV_A(ntryL,G1H16(380),wf4(:,11),G1H4(180),m3h4x4(:,475),heltab2x16(:,:,531))
  call Hloop_Q_A(ntryL,G1H4(180),79,nMB,G2H4(344),n2h4(503))
  call Hloop_QV_A(ntryL,G0H16(76),wf4(:,11),G0H4(1),m3h4x4(:,476),heltab2x16(:,:,532))
  call Hloop_Q_A(ntryL,G0H4(1),79,nMB,G1H4(180),n2h4(504))
  call Hloop_AZ_Q(ntryL,G1H16(381),wf4(:,16),G1H4(181),ngZu,m3h4x4(:,477),heltab2x16(:,:,533))
  call Hloop_A_Q(ntryL,G1H4(181),79,0,G2H4(345),n2h4(505))
call HGT_OLR(G1H16(382),1,1,16)
call HGT_invQ_OLR(G1H16(382),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(382),-48,0,G2H16(141),n2h16(385))
  call Hloop_QV_A(ntryL,G2H16(141),wf4(:,17),G2H4(346),m3h4x4(:,478),heltab2x16(:,:,534))
  call Hloop_AZ_Q(ntryL,G1H16(384),wf4(:,16),G1H4(181),ngZu,m3h4x4(:,479),heltab2x16(:,:,535))
  call Hloop_A_Q(ntryL,G1H4(181),79,0,G2H4(347),n2h4(506))
  call Hloop_AZ_Q(ntryL,G1H16(385),wf4(:,16),G1H4(181),ngZu,m3h4x4(:,480),heltab2x16(:,:,536))
  call Hloop_A_Q(ntryL,G1H4(181),79,0,G2H4(348),n2h4(507))
  call Hloop_AZ_Q(ntryL,G0H16(77),wf4(:,16),G0H4(1),ngZu,m3h4x4(:,481),heltab2x16(:,:,537))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(181),n2h4(508))
  call Hloop_AZ_Q(ntryL,G1H16(386),wf4(:,16),G1H4(182),ngZu,m3h4x4(:,482),heltab2x16(:,:,538))
  call Hloop_A_Q(ntryL,G1H4(182),79,nMT,G2H4(349),n2h4(509))
call HGT_OLR(G1H16(387),1,1,16)
call HGT_invQ_OLR(G1H16(387),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(387),-48,nMT,G2H16(142),n2h16(386))
  call Hloop_QV_A(ntryL,G2H16(142),wf4(:,17),G2H4(350),m3h4x4(:,483),heltab2x16(:,:,539))
  call Hloop_AZ_Q(ntryL,G1H16(389),wf4(:,16),G1H4(182),ngZu,m3h4x4(:,484),heltab2x16(:,:,540))
  call Hloop_A_Q(ntryL,G1H4(182),79,nMT,G2H4(351),n2h4(510))
  call Hloop_AZ_Q(ntryL,G1H16(390),wf4(:,16),G1H4(182),ngZu,m3h4x4(:,485),heltab2x16(:,:,541))
  call Hloop_A_Q(ntryL,G1H4(182),79,nMT,G2H4(352),n2h4(511))
  call Hloop_AZ_Q(ntryL,G0H16(78),wf4(:,16),G0H4(1),ngZu,m3h4x4(:,486),heltab2x16(:,:,542))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMT,G1H4(182),n2h4(512))
  call Hloop_QZ_A(ntryL,G1H16(391),wf4(:,16),G1H4(183),ngZu,m3h4x4(:,487),heltab2x16(:,:,543))
  call Hloop_Q_A(ntryL,G1H4(183),79,0,G2H4(353),n2h4(513))
call HGT_OLR(G1H16(392),1,1,16)
call HGT_invQ_OLR(G1H16(392),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(392),-48,0,G2H16(143),n2h16(387))
  call Hloop_AV_Q(ntryL,G2H16(143),wf4(:,17),G2H4(354),m3h4x4(:,488),heltab2x16(:,:,544))
  call Hloop_QZ_A(ntryL,G1H16(394),wf4(:,16),G1H4(183),ngZu,m3h4x4(:,489),heltab2x16(:,:,545))
  call Hloop_Q_A(ntryL,G1H4(183),79,0,G2H4(355),n2h4(514))
  call Hloop_QZ_A(ntryL,G1H16(395),wf4(:,16),G1H4(183),ngZu,m3h4x4(:,490),heltab2x16(:,:,546))
  call Hloop_Q_A(ntryL,G1H4(183),79,0,G2H4(356),n2h4(515))
  call Hloop_QZ_A(ntryL,G0H16(79),wf4(:,16),G0H4(1),ngZu,m3h4x4(:,491),heltab2x16(:,:,547))
  call Hloop_Q_A(ntryL,G0H4(1),79,0,G1H4(183),n2h4(516))
  call Hloop_QZ_A(ntryL,G1H16(396),wf4(:,16),G1H4(184),ngZu,m3h4x4(:,492),heltab2x16(:,:,548))
  call Hloop_Q_A(ntryL,G1H4(184),79,nMT,G2H4(357),n2h4(517))
call HGT_OLR(G1H16(397),1,1,16)
call HGT_invQ_OLR(G1H16(397),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(397),-48,nMT,G2H16(144),n2h16(388))
  call Hloop_AV_Q(ntryL,G2H16(144),wf4(:,17),G2H4(358),m3h4x4(:,493),heltab2x16(:,:,549))
  call Hloop_QZ_A(ntryL,G1H16(399),wf4(:,16),G1H4(184),ngZu,m3h4x4(:,494),heltab2x16(:,:,550))
  call Hloop_Q_A(ntryL,G1H4(184),79,nMT,G2H4(359),n2h4(518))
  call Hloop_QZ_A(ntryL,G1H16(400),wf4(:,16),G1H4(184),ngZu,m3h4x4(:,495),heltab2x16(:,:,551))
  call Hloop_Q_A(ntryL,G1H4(184),79,nMT,G2H4(360),n2h4(519))
  call Hloop_QZ_A(ntryL,G0H16(80),wf4(:,16),G0H4(1),ngZu,m3h4x4(:,496),heltab2x16(:,:,552))
  call Hloop_Q_A(ntryL,G0H4(1),79,nMT,G1H4(184),n2h4(520))
  call Hloop_AZ_Q(ntryL,G1H16(401),wf4(:,16),G1H4(185),ngZd,m3h4x4(:,497),heltab2x16(:,:,553))
  call Hloop_A_Q(ntryL,G1H4(185),79,0,G2H4(361),n2h4(521))
call HGT_OLR(G1H16(402),1,1,16)
call HGT_invQ_OLR(G1H16(402),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(402),-48,0,G2H16(167),n2h16(389))
  call Hloop_QV_A(ntryL,G2H16(167),wf4(:,17),G2H4(362),m3h4x4(:,498),heltab2x16(:,:,554))
  call Hloop_AZ_Q(ntryL,G1H16(404),wf4(:,16),G1H4(185),ngZd,m3h4x4(:,499),heltab2x16(:,:,555))
  call Hloop_A_Q(ntryL,G1H4(185),79,0,G2H4(363),n2h4(522))
  call Hloop_AZ_Q(ntryL,G1H16(405),wf4(:,16),G1H4(185),ngZd,m3h4x4(:,500),heltab2x16(:,:,556))
  call Hloop_A_Q(ntryL,G1H4(185),79,0,G2H4(364),n2h4(523))
  call Hloop_AZ_Q(ntryL,G0H16(81),wf4(:,16),G0H4(1),ngZd,m3h4x4(:,501),heltab2x16(:,:,557))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(185),n2h4(524))
  call Hloop_AZ_Q(ntryL,G1H16(406),wf4(:,16),G1H4(186),ngZd,m3h4x4(:,502),heltab2x16(:,:,558))
  call Hloop_A_Q(ntryL,G1H4(186),79,nMB,G2H4(365),n2h4(525))
call HGT_OLR(G1H16(407),1,1,16)
call HGT_invQ_OLR(G1H16(407),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(407),-48,nMB,G2H16(153),n2h16(390))
  call Hloop_QV_A(ntryL,G2H16(153),wf4(:,17),G2H4(366),m3h4x4(:,503),heltab2x16(:,:,559))
  call Hloop_AZ_Q(ntryL,G1H16(409),wf4(:,16),G1H4(186),ngZd,m3h4x4(:,504),heltab2x16(:,:,560))
  call Hloop_A_Q(ntryL,G1H4(186),79,nMB,G2H4(367),n2h4(526))
  call Hloop_AZ_Q(ntryL,G1H16(410),wf4(:,16),G1H4(186),ngZd,m3h4x4(:,505),heltab2x16(:,:,561))
  call Hloop_A_Q(ntryL,G1H4(186),79,nMB,G2H4(368),n2h4(527))
  call Hloop_AZ_Q(ntryL,G0H16(82),wf4(:,16),G0H4(1),ngZd,m3h4x4(:,506),heltab2x16(:,:,562))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(186),n2h4(528))
  call Hloop_QZ_A(ntryL,G1H16(411),wf4(:,16),G1H4(187),ngZd,m3h4x4(:,507),heltab2x16(:,:,563))
  call Hloop_Q_A(ntryL,G1H4(187),79,0,G2H4(369),n2h4(529))
call HGT_OLR(G1H16(412),1,1,16)
call HGT_invQ_OLR(G1H16(412),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(412),-48,0,G2H16(154),n2h16(391))
  call Hloop_AV_Q(ntryL,G2H16(154),wf4(:,17),G2H4(370),m3h4x4(:,508),heltab2x16(:,:,564))
  call Hloop_QZ_A(ntryL,G1H16(414),wf4(:,16),G1H4(187),ngZd,m3h4x4(:,509),heltab2x16(:,:,565))
  call Hloop_Q_A(ntryL,G1H4(187),79,0,G2H4(371),n2h4(530))
  call Hloop_QZ_A(ntryL,G1H16(415),wf4(:,16),G1H4(187),ngZd,m3h4x4(:,510),heltab2x16(:,:,566))
  call Hloop_Q_A(ntryL,G1H4(187),79,0,G2H4(372),n2h4(531))
  call Hloop_QZ_A(ntryL,G0H16(83),wf4(:,16),G0H4(1),ngZd,m3h4x4(:,511),heltab2x16(:,:,567))
  call Hloop_Q_A(ntryL,G0H4(1),79,0,G1H4(187),n2h4(532))
  call Hloop_QZ_A(ntryL,G1H16(416),wf4(:,16),G1H4(188),ngZd,m3h4x4(:,512),heltab2x16(:,:,568))
  call Hloop_Q_A(ntryL,G1H4(188),79,nMB,G2H4(373),n2h4(533))
call HGT_OLR(G1H16(417),1,1,16)
call HGT_invQ_OLR(G1H16(417),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(417),-48,nMB,G2H16(169),n2h16(392))
  call Hloop_AV_Q(ntryL,G2H16(169),wf4(:,17),G2H4(374),m3h4x4(:,513),heltab2x16(:,:,569))
  call Hloop_QZ_A(ntryL,G1H16(419),wf4(:,16),G1H4(188),ngZd,m3h4x4(:,514),heltab2x16(:,:,570))
  call Hloop_Q_A(ntryL,G1H4(188),79,nMB,G2H4(375),n2h4(534))
  call Hloop_QZ_A(ntryL,G1H16(420),wf4(:,16),G1H4(188),ngZd,m3h4x4(:,515),heltab2x16(:,:,571))
  call Hloop_Q_A(ntryL,G1H4(188),79,nMB,G2H4(376),n2h4(535))
  call Hloop_QZ_A(ntryL,G0H16(84),wf4(:,16),G0H4(1),ngZd,m3h4x4(:,516),heltab2x16(:,:,572))
  call Hloop_Q_A(ntryL,G0H4(1),79,nMB,G1H4(188),n2h4(536))
  call Hloop_QV_A(ntryL,G1H32(78),wf4(:,12),G1H8(57),m3h4x8(:,121),heltab2x32(:,:,177))
  call Hloop_Q_A(ntryL,G1H8(57),86,0,G2H8(63),n2h8(193))
call HGT_raise_alpha_OLR(G1H32(79),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(79),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(79),wf8(:,32),G1H4(189),m3h8x4(:,9),heltab2x32(:,:,178))
  call Hloop_QV_A(ntryL,G1H32(82),wf4(:,12),G1H8(58),m3h4x8(:,122),heltab2x32(:,:,179))
  call Hloop_Q_A(ntryL,G1H8(58),86,0,G2H8(73),n2h8(194))
  call Hloop_QV_A(ntryL,G1H32(83),wf4(:,12),G1H8(62),m3h4x8(:,123),heltab2x32(:,:,180))
  call Hloop_Q_A(ntryL,G1H8(62),86,0,G2H8(64),n2h8(195))
  call Hloop_QZ_A(ntryL,G1H32(84),wf4(:,14),G1H8(63),ngZd,m3h4x8(:,124),heltab2x32(:,:,181))
  call Hloop_Q_A(ntryL,G1H8(63),86,0,G2H8(75),n2h8(196))
call HGT_raise_alpha_OLR(G1H32(85),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(85),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(85),wf8(:,32),G1H4(190),m3h8x4(:,10),heltab2x32(:,:,182))
  call Hloop_QZ_A(ntryL,G1H32(88),wf4(:,14),G1H8(73),ngZd,m3h4x8(:,125),heltab2x32(:,:,183))
  call Hloop_Q_A(ntryL,G1H8(73),86,0,G2H8(40),n2h8(197))
  call Hloop_QZ_A(ntryL,G1H32(89),wf4(:,14),G1H8(74),ngZd,m3h4x8(:,126),heltab2x32(:,:,184))
  call Hloop_Q_A(ntryL,G1H8(74),86,0,G2H8(45),n2h8(198))
  call Hloop_QV_A(ntryL,G1H32(90),wf4(:,12),G1H8(78),m3h4x8(:,127),heltab2x32(:,:,185))
  call Hloop_Q_A(ntryL,G1H8(78),86,0,G2H8(47),n2h8(199))
call HGT_raise_alpha_OLR(G1H32(91),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(91),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(91),wf8(:,34),G1H4(191),m3h8x4(:,11),heltab2x32(:,:,186))
  call Hloop_QV_A(ntryL,G1H32(94),wf4(:,12),G1H8(79),m3h4x8(:,128),heltab2x32(:,:,187))
  call Hloop_Q_A(ntryL,G1H8(79),86,0,G2H8(48),n2h8(200))
  call Hloop_QV_A(ntryL,G1H32(95),wf4(:,12),G1H8(89),m3h4x8(:,129),heltab2x32(:,:,188))
  call Hloop_Q_A(ntryL,G1H8(89),86,0,G2H8(65),n2h8(201))
  call Hloop_QZ_A(ntryL,G1H32(96),wf4(:,14),G1H8(90),ngZd,m3h4x8(:,130),heltab2x32(:,:,189))
  call Hloop_Q_A(ntryL,G1H8(90),86,0,G2H8(68),n2h8(202))
call HGT_raise_alpha_OLR(G1H32(97),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(97),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(97),wf8(:,34),G1H4(192),m3h8x4(:,12),heltab2x32(:,:,190))
  call Hloop_QZ_A(ntryL,G1H32(99),wf4(:,14),G1H8(94),ngZd,m3h4x8(:,131),heltab2x32(:,:,191))
  call Hloop_Q_A(ntryL,G1H8(94),86,0,G2H8(67),n2h8(203))
  call Hloop_QZ_A(ntryL,G1H32(100),wf4(:,14),G1H8(95),ngZd,m3h4x8(:,132),heltab2x32(:,:,192))
  call Hloop_Q_A(ntryL,G1H8(95),86,0,G2H8(69),n2h8(204))
  call Hloop_QV_A(ntryL,G1H32(101),wf4(:,11),G1H8(105),m3h4x8(:,133),heltab2x32(:,:,193))
  call Hloop_Q_A(ntryL,G1H8(105),89,0,G2H8(71),n2h8(205))
call HGT_raise_alpha_OLR(G1H32(102),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(102),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(102),wf8(:,36),G1H4(193),m3h8x4(:,13),heltab2x32(:,:,194))
  call Hloop_QV_A(ntryL,G1H32(104),wf4(:,11),G1H8(106),m3h4x8(:,134),heltab2x32(:,:,195))
  call Hloop_Q_A(ntryL,G1H8(106),89,0,G2H8(66),n2h8(206))
  call Hloop_QV_A(ntryL,G1H32(105),wf4(:,11),G1H8(110),m3h4x8(:,135),heltab2x32(:,:,196))
  call Hloop_Q_A(ntryL,G1H8(110),89,0,G2H8(58),n2h8(207))
  call Hloop_QV_A(ntryL,G1H32(106),wf4(:,11),G1H8(111),m3h4x8(:,136),heltab2x32(:,:,197))
  call Hloop_Q_A(ntryL,G1H8(111),89,0,G2H8(72),n2h8(208))
call HGT_raise_alpha_OLR(G1H32(107),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(107),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(107),wf8(:,38),G1H4(194),m3h8x4(:,14),heltab2x32(:,:,198))
  call Hloop_QV_A(ntryL,G1H32(109),wf4(:,11),G1H8(121),m3h4x8(:,137),heltab2x32(:,:,199))
  call Hloop_Q_A(ntryL,G1H8(121),89,0,G2H8(70),n2h8(209))
  call Hloop_QV_A(ntryL,G1H32(110),wf4(:,11),G1H8(122),m3h4x8(:,138),heltab2x32(:,:,200))
  call Hloop_Q_A(ntryL,G1H8(122),89,0,G2H8(62),n2h8(210))
  call Hloop_QZ_A(ntryL,G1H32(111),wf4(:,16),G1H8(126),ngZd,m3h4x8(:,139),heltab2x32(:,:,201))
  call Hloop_Q_A(ntryL,G1H8(126),89,0,G2H8(80),n2h8(211))
call HGT_raise_alpha_OLR(G1H32(112),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(112),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(112),wf8(:,36),G1H4(195),m3h8x4(:,15),heltab2x32(:,:,202))
  call Hloop_QZ_A(ntryL,G1H32(114),wf4(:,16),G1H8(127),ngZd,m3h4x8(:,140),heltab2x32(:,:,203))
  call Hloop_Q_A(ntryL,G1H8(127),89,0,G2H8(78),n2h8(212))
  call Hloop_QZ_A(ntryL,G1H32(115),wf4(:,16),G1H8(137),ngZd,m3h4x8(:,141),heltab2x32(:,:,204))
  call Hloop_Q_A(ntryL,G1H8(137),89,0,G2H8(74),n2h8(213))
  call Hloop_QZ_A(ntryL,G1H32(116),wf4(:,16),G1H8(138),ngZd,m3h4x8(:,142),heltab2x32(:,:,205))
  call Hloop_Q_A(ntryL,G1H8(138),89,0,G2H8(87),n2h8(214))
call HGT_raise_alpha_OLR(G1H32(117),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(117),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(117),wf8(:,38),G1H4(196),m3h8x4(:,16),heltab2x32(:,:,206))
  call Hloop_QZ_A(ntryL,G1H32(119),wf4(:,16),G1H8(142),ngZd,m3h4x8(:,143),heltab2x32(:,:,207))
  call Hloop_Q_A(ntryL,G1H8(142),89,0,G2H8(86),n2h8(215))
  call Hloop_QZ_A(ntryL,G1H32(120),wf4(:,16),G1H8(143),ngZd,m3h4x8(:,144),heltab2x32(:,:,208))
  call Hloop_Q_A(ntryL,G1H8(143),89,0,G2H8(82),n2h8(216))
  call Hloop_QV_A(ntryL,G1H32(121),wf16(:,33),G1H2(1),m3h16x2(:,25),heltab2x32(:,:,209))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(195),n2h2(169))
call HGT_raise_alpha_OLR(G1H32(122),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(122),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(122),ex6(:),G1H16(37),m3h2x16(:,25),heltab2x32(:,:,210))
  call Hloop_QV_A(ntryL,G1H32(124),wf16(:,33),G1H2(2),m3h16x2(:,26),heltab2x32(:,:,211))
  call Hloop_Q_A(ntryL,G1H2(2),95,0,G2H2(196),n2h2(170))
  call Hloop_QV_A(ntryL,G1H32(125),wf16(:,33),G1H2(7),m3h16x2(:,27),heltab2x32(:,:,212))
  call Hloop_Q_A(ntryL,G1H2(7),95,0,G2H2(197),n2h2(171))
  call Hloop_QZ_A(ntryL,G1H32(126),wf16(:,183),G1H2(8),ngZd,m3h16x2(:,28),heltab2x32(:,:,213))
  call Hloop_Q_A(ntryL,G1H2(8),95,0,G2H2(198),n2h2(172))
call HGT_raise_alpha_OLR(G1H32(127),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(127),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(127),ex6(:),G1H16(38),m3h2x16(:,26),heltab2x32(:,:,214))
  call Hloop_QZ_A(ntryL,G1H32(129),wf16(:,183),G1H2(12),ngZd,m3h16x2(:,29),heltab2x32(:,:,215))
  call Hloop_Q_A(ntryL,G1H2(12),95,0,G2H2(199),n2h2(173))
  call Hloop_QZ_A(ntryL,G1H32(130),wf16(:,183),G1H2(13),ngZd,m3h16x2(:,30),heltab2x32(:,:,216))
  call Hloop_Q_A(ntryL,G1H2(13),95,0,G2H2(200),n2h2(174))
  call Hloop_QV_A(ntryL,G1H32(131),wf16(:,35),G1H2(18),m3h16x2(:,31),heltab2x32(:,:,217))
  call Hloop_Q_A(ntryL,G1H2(18),95,0,G2H2(201),n2h2(175))
call HGT_raise_alpha_OLR(G1H32(132),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(132),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(132),ex6(:),G1H16(41),m3h2x16(:,27),heltab2x32(:,:,218))
  call Hloop_QV_A(ntryL,G1H32(134),wf16(:,35),G1H2(19),m3h16x2(:,32),heltab2x32(:,:,219))
  call Hloop_Q_A(ntryL,G1H2(19),95,0,G2H2(202),n2h2(176))
  call Hloop_QV_A(ntryL,G1H32(135),wf16(:,35),G1H2(23),m3h16x2(:,33),heltab2x32(:,:,220))
  call Hloop_Q_A(ntryL,G1H2(23),95,0,G2H2(203),n2h2(177))
  call Hloop_QZ_A(ntryL,G1H32(136),wf16(:,184),G1H2(24),ngZd,m3h16x2(:,34),heltab2x32(:,:,221))
  call Hloop_Q_A(ntryL,G1H2(24),95,0,G2H2(204),n2h2(178))
call HGT_raise_alpha_OLR(G1H32(137),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(137),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(137),ex6(:),G1H16(42),m3h2x16(:,28),heltab2x32(:,:,222))
  call Hloop_QZ_A(ntryL,G1H32(139),wf16(:,184),G1H2(29),ngZd,m3h16x2(:,35),heltab2x32(:,:,223))
  call Hloop_Q_A(ntryL,G1H2(29),95,0,G2H2(205),n2h2(179))
  call Hloop_QZ_A(ntryL,G1H32(140),wf16(:,184),G1H2(30),ngZd,m3h16x2(:,36),heltab2x32(:,:,224))
  call Hloop_Q_A(ntryL,G1H2(30),95,0,G2H2(206),n2h2(180))
  call Hloop_QV_A(ntryL,G1H32(141),wf16(:,37),G1H2(34),m3h16x2(:,37),heltab2x32(:,:,225))
  call Hloop_Q_A(ntryL,G1H2(34),95,0,G2H2(207),n2h2(181))
call HGT_raise_alpha_OLR(G1H32(142),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(142),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(142),ex6(:),G1H16(43),m3h2x16(:,29),heltab2x32(:,:,226))
  call Hloop_QV_A(ntryL,G1H32(144),wf16(:,37),G1H2(35),m3h16x2(:,38),heltab2x32(:,:,227))
  call Hloop_Q_A(ntryL,G1H2(35),95,0,G2H2(208),n2h2(182))
  call Hloop_QV_A(ntryL,G1H32(145),wf16(:,37),G1H2(40),m3h16x2(:,39),heltab2x32(:,:,228))
  call Hloop_Q_A(ntryL,G1H2(40),95,0,G2H2(209),n2h2(183))
  call Hloop_QV_A(ntryL,G1H32(146),wf16(:,38),G1H2(41),m3h16x2(:,40),heltab2x32(:,:,229))
  call Hloop_Q_A(ntryL,G1H2(41),95,0,G2H2(210),n2h2(184))
call HGT_raise_alpha_OLR(G1H32(147),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(147),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(147),ex6(:),G1H16(44),m3h2x16(:,30),heltab2x32(:,:,230))
  call Hloop_QV_A(ntryL,G1H32(149),wf16(:,38),G1H2(45),m3h16x2(:,41),heltab2x32(:,:,231))
  call Hloop_Q_A(ntryL,G1H2(45),95,0,G2H2(211),n2h2(185))
  call Hloop_QV_A(ntryL,G1H32(150),wf16(:,38),G1H2(46),m3h16x2(:,42),heltab2x32(:,:,232))
  call Hloop_Q_A(ntryL,G1H2(46),95,0,G2H2(212),n2h2(186))
  call Hloop_QZ_A(ntryL,G1H32(151),wf16(:,185),G1H2(51),ngZd,m3h16x2(:,43),heltab2x32(:,:,233))
  call Hloop_Q_A(ntryL,G1H2(51),95,0,G2H2(213),n2h2(187))
call HGT_raise_alpha_OLR(G1H32(152),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(152),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(152),ex6(:),G1H16(47),m3h2x16(:,31),heltab2x32(:,:,234))
  call Hloop_QZ_A(ntryL,G1H32(154),wf16(:,185),G1H2(52),ngZd,m3h16x2(:,44),heltab2x32(:,:,235))
  call Hloop_Q_A(ntryL,G1H2(52),95,0,G2H2(214),n2h2(188))
  call Hloop_QZ_A(ntryL,G1H32(155),wf16(:,185),G1H2(56),ngZd,m3h16x2(:,45),heltab2x32(:,:,236))
  call Hloop_Q_A(ntryL,G1H2(56),95,0,G2H2(215),n2h2(189))
  call Hloop_QZ_A(ntryL,G1H32(156),wf16(:,186),G1H2(57),ngZd,m3h16x2(:,46),heltab2x32(:,:,237))
  call Hloop_Q_A(ntryL,G1H2(57),95,0,G2H2(216),n2h2(190))
call HGT_raise_alpha_OLR(G1H32(157),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(157),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(157),ex6(:),G1H16(48),m3h2x16(:,32),heltab2x32(:,:,238))
  call Hloop_QZ_A(ntryL,G1H32(159),wf16(:,186),G1H2(62),ngZd,m3h16x2(:,47),heltab2x32(:,:,239))
  call Hloop_Q_A(ntryL,G1H2(62),95,0,G2H2(217),n2h2(191))
  call Hloop_QZ_A(ntryL,G1H32(160),wf16(:,186),G1H2(63),ngZd,m3h16x2(:,48),heltab2x32(:,:,240))
  call Hloop_Q_A(ntryL,G1H2(63),95,0,G2H2(218),n2h2(192))
  call Hloop_QV_A(ntryL,G1H32(161),wf16(:,41),G1H2(67),m3h16x2(:,49),heltab2x32(:,:,241))
  call Hloop_Q_A(ntryL,G1H2(67),95,0,G2H2(219),n2h2(193))
call HGT_raise_alpha_OLR(G1H32(162),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(162),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(162),ex6(:),G1H16(49),m3h2x16(:,33),heltab2x32(:,:,242))
  call Hloop_QV_A(ntryL,G1H32(164),wf16(:,41),G1H2(68),m3h16x2(:,50),heltab2x32(:,:,243))
  call Hloop_Q_A(ntryL,G1H2(68),95,0,G2H2(220),n2h2(194))
  call Hloop_QV_A(ntryL,G1H32(165),wf16(:,41),G1H2(73),m3h16x2(:,51),heltab2x32(:,:,244))
  call Hloop_Q_A(ntryL,G1H2(73),95,0,G2H2(221),n2h2(195))
  call Hloop_QZ_A(ntryL,G1H32(166),wf16(:,187),G1H2(74),ngZd,m3h16x2(:,52),heltab2x32(:,:,245))
  call Hloop_Q_A(ntryL,G1H2(74),95,0,G2H2(222),n2h2(196))
call HGT_raise_alpha_OLR(G1H32(167),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(167),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(167),ex6(:),G1H16(50),m3h2x16(:,34),heltab2x32(:,:,246))
  call Hloop_QZ_A(ntryL,G1H32(169),wf16(:,187),G1H2(78),ngZd,m3h16x2(:,53),heltab2x32(:,:,247))
  call Hloop_Q_A(ntryL,G1H2(78),95,0,G2H2(223),n2h2(197))
  call Hloop_QZ_A(ntryL,G1H32(170),wf16(:,187),G1H2(79),ngZd,m3h16x2(:,54),heltab2x32(:,:,248))
  call Hloop_Q_A(ntryL,G1H2(79),95,0,G2H2(224),n2h2(198))
  call Hloop_QV_A(ntryL,G1H32(171),wf16(:,43),G1H2(84),m3h16x2(:,55),heltab2x32(:,:,249))
  call Hloop_Q_A(ntryL,G1H2(84),95,0,G2H2(225),n2h2(199))
call HGT_raise_alpha_OLR(G1H32(172),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(172),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(172),ex6(:),G1H16(53),m3h2x16(:,35),heltab2x32(:,:,250))
  call Hloop_QV_A(ntryL,G1H32(174),wf16(:,43),G1H2(85),m3h16x2(:,56),heltab2x32(:,:,251))
  call Hloop_Q_A(ntryL,G1H2(85),95,0,G2H2(226),n2h2(200))
  call Hloop_QV_A(ntryL,G1H32(175),wf16(:,43),G1H2(6),m3h16x2(:,57),heltab2x32(:,:,252))
  call Hloop_Q_A(ntryL,G1H2(6),95,0,G2H2(227),n2h2(201))
  call Hloop_QZ_A(ntryL,G1H32(176),wf16(:,188),G1H2(17),ngZd,m3h16x2(:,58),heltab2x32(:,:,253))
  call Hloop_Q_A(ntryL,G1H2(17),95,0,G2H2(228),n2h2(202))
call HGT_raise_alpha_OLR(G1H32(177),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(177),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(177),ex6(:),G1H16(54),m3h2x16(:,36),heltab2x32(:,:,254))
  call Hloop_QZ_A(ntryL,G1H32(179),wf16(:,188),G1H2(28),ngZd,m3h16x2(:,59),heltab2x32(:,:,255))
  call Hloop_Q_A(ntryL,G1H2(28),95,0,G2H2(229),n2h2(203))
  call Hloop_QZ_A(ntryL,G1H32(180),wf16(:,188),G1H2(39),ngZd,m3h16x2(:,60),heltab2x32(:,:,256))
  call Hloop_Q_A(ntryL,G1H2(39),95,0,G2H2(230),n2h2(204))
  call Hloop_QV_A(ntryL,G1H32(181),wf16(:,45),G1H2(50),m3h16x2(:,61),heltab2x32(:,:,257))
  call Hloop_Q_A(ntryL,G1H2(50),95,0,G2H2(231),n2h2(205))
call HGT_raise_alpha_OLR(G1H32(182),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(182),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(182),ex6(:),G1H16(55),m3h2x16(:,37),heltab2x32(:,:,258))
  call Hloop_QV_A(ntryL,G1H32(184),wf16(:,45),G1H2(61),m3h16x2(:,62),heltab2x32(:,:,259))
  call Hloop_Q_A(ntryL,G1H2(61),95,0,G2H2(232),n2h2(206))
  call Hloop_QV_A(ntryL,G1H32(185),wf16(:,45),G1H2(72),m3h16x2(:,63),heltab2x32(:,:,260))
  call Hloop_Q_A(ntryL,G1H2(72),95,0,G2H2(233),n2h2(207))
  call Hloop_QZ_A(ntryL,G1H32(186),wf16(:,189),G1H2(83),ngZd,m3h16x2(:,64),heltab2x32(:,:,261))
  call Hloop_Q_A(ntryL,G1H2(83),95,0,G2H2(234),n2h2(208))
call HGT_raise_alpha_OLR(G1H32(187),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(187),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(187),ex6(:),G1H16(56),m3h2x16(:,38),heltab2x32(:,:,262))
  call Hloop_QZ_A(ntryL,G1H32(189),wf16(:,189),G1H2(1),ngZd,m3h16x2(:,65),heltab2x32(:,:,263))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(235),n2h2(209))
  call Hloop_QZ_A(ntryL,G1H32(190),wf16(:,189),G1H2(2),ngZd,m3h16x2(:,66),heltab2x32(:,:,264))
  call Hloop_Q_A(ntryL,G1H2(2),95,0,G2H2(236),n2h2(210))
  call Hloop_QV_A(ntryL,G1H32(191),wf16(:,47),G1H2(7),m3h16x2(:,67),heltab2x32(:,:,265))
  call Hloop_Q_A(ntryL,G1H2(7),95,0,G2H2(237),n2h2(211))
call HGT_raise_alpha_OLR(G1H32(192),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(192),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(192),ex6(:),G1H16(59),m3h2x16(:,39),heltab2x32(:,:,266))
  call Hloop_QV_A(ntryL,G1H32(194),wf16(:,47),G1H2(8),m3h16x2(:,68),heltab2x32(:,:,267))
  call Hloop_Q_A(ntryL,G1H2(8),95,0,G2H2(238),n2h2(212))
  call Hloop_QV_A(ntryL,G1H32(195),wf16(:,47),G1H2(12),m3h16x2(:,69),heltab2x32(:,:,268))
  call Hloop_Q_A(ntryL,G1H2(12),95,0,G2H2(239),n2h2(213))
  call Hloop_QZ_A(ntryL,G1H32(196),wf16(:,190),G1H2(13),ngZd,m3h16x2(:,70),heltab2x32(:,:,269))
  call Hloop_Q_A(ntryL,G1H2(13),95,0,G2H2(240),n2h2(214))
call HGT_raise_alpha_OLR(G1H32(197),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(197),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(197),ex6(:),G1H16(60),m3h2x16(:,40),heltab2x32(:,:,270))
  call Hloop_QZ_A(ntryL,G1H32(199),wf16(:,190),G1H2(18),ngZd,m3h16x2(:,71),heltab2x32(:,:,271))
  call Hloop_Q_A(ntryL,G1H2(18),95,0,G2H2(241),n2h2(215))
  call Hloop_QZ_A(ntryL,G1H32(200),wf16(:,190),G1H2(19),ngZd,m3h16x2(:,72),heltab2x32(:,:,272))
  call Hloop_Q_A(ntryL,G1H2(19),95,0,G2H2(242),n2h2(216))
  call Hloop_QV_A(ntryL,G1H32(201),wf16(:,49),G1H2(23),m3h16x2(:,73),heltab2x32(:,:,273))
  call Hloop_Q_A(ntryL,G1H2(23),95,0,G2H2(243),n2h2(217))
call HGT_raise_alpha_OLR(G1H32(202),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(202),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(202),ex6(:),G1H16(61),m3h2x16(:,41),heltab2x32(:,:,274))
  call Hloop_QV_A(ntryL,G1H32(204),wf16(:,49),G1H2(24),m3h16x2(:,74),heltab2x32(:,:,275))
  call Hloop_Q_A(ntryL,G1H2(24),95,0,G2H2(244),n2h2(218))
  call Hloop_QV_A(ntryL,G1H32(205),wf16(:,49),G1H2(29),m3h16x2(:,75),heltab2x32(:,:,276))
  call Hloop_Q_A(ntryL,G1H2(29),95,0,G2H2(245),n2h2(219))
  call Hloop_QZ_A(ntryL,G1H32(206),wf16(:,191),G1H2(30),ngZd,m3h16x2(:,76),heltab2x32(:,:,277))
  call Hloop_Q_A(ntryL,G1H2(30),95,0,G2H2(246),n2h2(220))
call HGT_raise_alpha_OLR(G1H32(207),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(207),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(207),ex6(:),G1H16(62),m3h2x16(:,42),heltab2x32(:,:,278))
  call Hloop_QZ_A(ntryL,G1H32(209),wf16(:,191),G1H2(34),ngZd,m3h16x2(:,77),heltab2x32(:,:,279))
  call Hloop_Q_A(ntryL,G1H2(34),95,0,G2H2(247),n2h2(221))
  call Hloop_QZ_A(ntryL,G1H32(210),wf16(:,191),G1H2(35),ngZd,m3h16x2(:,78),heltab2x32(:,:,280))
  call Hloop_Q_A(ntryL,G1H2(35),95,0,G2H2(248),n2h2(222))
  call Hloop_QV_A(ntryL,G1H32(211),wf16(:,51),G1H2(40),m3h16x2(:,79),heltab2x32(:,:,281))
  call Hloop_Q_A(ntryL,G1H2(40),95,0,G2H2(249),n2h2(223))
call HGT_raise_alpha_OLR(G1H32(212),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(212),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(212),ex6(:),G1H16(65),m3h2x16(:,43),heltab2x32(:,:,282))
  call Hloop_QV_A(ntryL,G1H32(214),wf16(:,51),G1H2(41),m3h16x2(:,80),heltab2x32(:,:,283))
  call Hloop_Q_A(ntryL,G1H2(41),95,0,G2H2(250),n2h2(224))
  call Hloop_QV_A(ntryL,G1H32(215),wf16(:,51),G1H2(45),m3h16x2(:,81),heltab2x32(:,:,284))
  call Hloop_Q_A(ntryL,G1H2(45),95,0,G2H2(251),n2h2(225))
  call Hloop_QZ_A(ntryL,G1H32(216),wf16(:,192),G1H2(46),ngZd,m3h16x2(:,82),heltab2x32(:,:,285))
  call Hloop_Q_A(ntryL,G1H2(46),95,0,G2H2(252),n2h2(226))
call HGT_raise_alpha_OLR(G1H32(217),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(217),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(217),ex6(:),G1H16(66),m3h2x16(:,44),heltab2x32(:,:,286))
  call Hloop_QZ_A(ntryL,G1H32(219),wf16(:,192),G1H2(51),ngZd,m3h16x2(:,83),heltab2x32(:,:,287))
  call Hloop_Q_A(ntryL,G1H2(51),95,0,G2H2(253),n2h2(227))
  call Hloop_QZ_A(ntryL,G1H32(220),wf16(:,192),G1H2(52),ngZd,m3h16x2(:,84),heltab2x32(:,:,288))
  call Hloop_Q_A(ntryL,G1H2(52),95,0,G2H2(254),n2h2(228))
  call Hloop_QV_A(ntryL,G1H32(221),wf16(:,53),G1H2(56),m3h16x2(:,85),heltab2x32(:,:,289))
  call Hloop_Q_A(ntryL,G1H2(56),95,0,G2H2(255),n2h2(229))
call HGT_raise_alpha_OLR(G1H32(222),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(222),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(222),ex6(:),G1H16(67),m3h2x16(:,45),heltab2x32(:,:,290))
  call Hloop_QV_A(ntryL,G1H32(224),wf16(:,53),G1H2(57),m3h16x2(:,86),heltab2x32(:,:,291))
  call Hloop_Q_A(ntryL,G1H2(57),95,0,G2H2(256),n2h2(230))
  call Hloop_QV_A(ntryL,G1H32(225),wf16(:,53),G1H2(62),m3h16x2(:,87),heltab2x32(:,:,292))
  call Hloop_Q_A(ntryL,G1H2(62),95,0,G2H2(257),n2h2(231))
  call Hloop_QV_A(ntryL,G1H32(226),wf16(:,54),G1H2(63),m3h16x2(:,88),heltab2x32(:,:,293))
  call Hloop_Q_A(ntryL,G1H2(63),95,0,G2H2(258),n2h2(232))
call HGT_raise_alpha_OLR(G1H32(227),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(227),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(227),ex6(:),G1H16(68),m3h2x16(:,46),heltab2x32(:,:,294))
  call Hloop_QV_A(ntryL,G1H32(229),wf16(:,54),G1H2(67),m3h16x2(:,89),heltab2x32(:,:,295))
  call Hloop_Q_A(ntryL,G1H2(67),95,0,G2H2(259),n2h2(233))
  call Hloop_QV_A(ntryL,G1H32(230),wf16(:,54),G1H2(68),m3h16x2(:,90),heltab2x32(:,:,296))
  call Hloop_Q_A(ntryL,G1H2(68),95,0,G2H2(260),n2h2(234))
  call Hloop_QZ_A(ntryL,G1H32(231),wf16(:,193),G1H2(73),ngZd,m3h16x2(:,91),heltab2x32(:,:,297))
  call Hloop_Q_A(ntryL,G1H2(73),95,0,G2H2(261),n2h2(235))
call HGT_raise_alpha_OLR(G1H32(232),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(232),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(232),ex6(:),G1H16(71),m3h2x16(:,47),heltab2x32(:,:,298))
  call Hloop_QZ_A(ntryL,G1H32(234),wf16(:,193),G1H2(74),ngZd,m3h16x2(:,92),heltab2x32(:,:,299))
  call Hloop_Q_A(ntryL,G1H2(74),95,0,G2H2(262),n2h2(236))
  call Hloop_QZ_A(ntryL,G1H32(235),wf16(:,193),G1H2(78),ngZd,m3h16x2(:,93),heltab2x32(:,:,300))
  call Hloop_Q_A(ntryL,G1H2(78),95,0,G2H2(263),n2h2(237))
  call Hloop_QZ_A(ntryL,G1H32(236),wf16(:,194),G1H2(79),ngZd,m3h16x2(:,94),heltab2x32(:,:,301))
  call Hloop_Q_A(ntryL,G1H2(79),95,0,G2H2(264),n2h2(238))
call HGT_raise_alpha_OLR(G1H32(237),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(237),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(237),ex6(:),G1H16(72),m3h2x16(:,48),heltab2x32(:,:,302))
  call Hloop_QZ_A(ntryL,G1H32(239),wf16(:,194),G1H2(84),ngZd,m3h16x2(:,95),heltab2x32(:,:,303))
  call Hloop_Q_A(ntryL,G1H2(84),95,0,G2H2(265),n2h2(239))
  call Hloop_QZ_A(ntryL,G1H32(240),wf16(:,194),G1H2(85),ngZd,m3h16x2(:,96),heltab2x32(:,:,304))
  call Hloop_Q_A(ntryL,G1H2(85),95,0,G2H2(266),n2h2(240))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(86),[G2H2(85),G2H2(2),G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(90),[G2H2(89),G2H2(5),G1H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(84),[G2H2(83),G2H2(8),G1H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(88),[G2H2(87),G2H2(11),G1H2(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(94),[G2H2(93),G2H2(14),G1H2(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(98),[G2H2(97),G2H2(17),G1H2(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(92),[G2H2(91),G2H2(20),G1H2(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(96),[G2H2(95),G2H2(23),G1H2(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(26),[G2H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(77),[G1H2(25)])
call HGT_OLR(G2H2(26),1,1,2)
call HGT_invQ_OLR(G2H2(26),2,5,2)
call HGT_OLR(G2H2(26),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(26),[G2H2(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(42),[G2H4(3),G1H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(54),[G2H4(11),G1H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(28),[G2H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(75),[G1H2(3)])
call HGT_OLR(G2H2(28),1,1,2)
call HGT_invQ_OLR(G2H2(28),2,5,2)
call HGT_OLR(G2H2(28),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(28),[G2H2(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(102),[G2H4(19),G1H4(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(15),[G2H4(27),G1H4(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(30),[G2H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(80),[G1H2(58)])
call HGT_OLR(G2H2(30),1,1,2)
call HGT_invQ_OLR(G2H2(30),2,5,2)
call HGT_OLR(G2H2(30),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(30),[G2H2(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(209),[G2H4(35),G1H4(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(249),[G2H4(43),G1H4(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G2H2(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(82),[G1H2(80)])
call HGT_OLR(G2H2(32),1,1,2)
call HGT_invQ_OLR(G2H2(32),2,5,2)
call HGT_OLR(G2H2(32),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G2H2(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(217),[G2H4(51),G1H4(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(257),[G2H4(59),G1H4(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(97),[G2H4(99)])
call HGT_w2_OLR(G1H4(1),1,1,4)
call HGT_w2_invQ_OLR(G1H4(1),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(97),[G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(264),[G2H2(261),G2H2(258),G2H2(255),G2H2(252),G2H2(249) &
    ,G2H2(246),G2H2(243),G2H2(240),G2H2(237),G2H2(234),G2H2(231),G2H2(228),G2H2(225),G2H2(222),G2H2(219),G2H2(216),G2H2(213) &
    ,G2H2(210),G2H2(207),G2H2(204),G2H2(201),G2H2(198),G2H2(195),G2H2(192),G2H2(189),G2H2(186),G2H2(183),G2H2(180),G2H2(177) &
    ,G2H2(174),G2H2(171),G2H2(69),G2H2(64),G2H2(59),G2H2(54),G2H2(49),G2H2(44),G2H2(39),G2H2(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(266),[G2H2(263),G2H2(260),G2H2(257),G2H2(254),G2H2(251) &
    ,G2H2(248),G2H2(245),G2H2(242),G2H2(239),G2H2(236),G2H2(233),G2H2(230),G2H2(227),G2H2(224),G2H2(221),G2H2(218),G2H2(215) &
    ,G2H2(212),G2H2(209),G2H2(206),G2H2(203),G2H2(200),G2H2(197),G2H2(194),G2H2(191),G2H2(188),G2H2(185),G2H2(182),G2H2(179) &
    ,G2H2(176),G2H2(173),G2H2(72),G2H2(71),G2H2(67),G2H2(66),G2H2(62),G2H2(61),G2H2(57),G2H2(56),G2H2(52),G2H2(51),G2H2(47) &
    ,G2H2(46),G2H2(42),G2H2(41),G2H2(37),G2H2(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(92),[G2H4(98)])
call HGT_w2_OLR(G1H4(4),1,1,4)
call HGT_w2_invQ_OLR(G1H4(4),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(92),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(90),[G2H4(91)])
call HGT_w2_OLR(G1H4(7),1,1,4)
call HGT_w2_invQ_OLR(G1H4(7),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(90),[G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(84),[G2H4(89)])
call HGT_w2_OLR(G1H4(10),1,1,4)
call HGT_w2_invQ_OLR(G1H4(10),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(84),[G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(81),[G2H4(83)])
call HGT_w2_OLR(G1H4(13),1,1,4)
call HGT_w2_invQ_OLR(G1H4(13),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(81),[G1H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(76),[G2H4(82)])
call HGT_w2_OLR(G1H4(16),1,1,4)
call HGT_w2_invQ_OLR(G1H4(16),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(76),[G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(74),[G2H4(75)])
call HGT_w2_OLR(G1H4(19),1,1,4)
call HGT_w2_invQ_OLR(G1H4(19),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(74),[G1H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(68),[G2H4(73)])
call HGT_w2_OLR(G1H4(22),1,1,4)
call HGT_w2_invQ_OLR(G1H4(22),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(68),[G1H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(33),[G1H2(59),G1H2(48),G1H2(15),G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(65),[G1H2(54),G1H2(21),G1H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(76),[G1H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(35),[G1H2(81),G1H2(70),G1H2(37),G1H2(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(87),[G1H2(76),G1H2(43),G1H2(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(78),[G1H2(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(79),[G1H2(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(81),[G1H2(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(67),[G1H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(66),[G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(14),[G1H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(65),[G1H4(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(44),[G1H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(26),[G1H4(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(41),[G1H4(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(36),[G1H4(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(95),[G1H4(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(33),[G1H4(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G1H4(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(31),[G1H4(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G1H4(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G1H4(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(212),[G1H4(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1),[G1H4(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(55),[G1H4(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(252),[G1H4(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(53),[G1H4(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(48),[G1H4(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(220),[G1H4(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(47),[G1H4(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(46),[G1H4(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(260),[G1H4(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(110),[G2H2(107),G2H2(1),G2H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(128),[G2H2(125),G2H2(3),G2H2(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(104),[G2H2(101),G2H2(13),G2H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(134),[G2H2(131),G2H2(15),G2H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(146),[G2H2(143),G2H2(38),G2H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(164),[G2H2(161),G2H2(40),G2H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(140),[G2H2(137),G2H2(73),G2H2(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(170),[G2H2(167),G2H2(74),G2H2(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(102),[G2H2(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(108),[G2H2(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(114),[G2H2(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(116),[G2H2(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(120),[G2H2(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(122),[G2H2(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(126),[G2H2(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(132),[G2H2(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(138),[G2H2(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(144),[G2H2(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(150),[G2H2(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(152),[G2H2(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(156),[G2H2(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(158),[G2H2(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(162),[G2H2(159)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(168),[G2H2(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(137),[G2H4(121),G2H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(140),[G2H4(124),G2H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(121),[G1H4(117),G1H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(125),[G2H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(128),[G2H4(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(118),[G1H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(145),[G2H4(129),G2H4(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(148),[G2H4(132),G2H4(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(123),[G1H4(119),G1H4(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(133),[G2H4(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(136),[G2H4(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(120),[G1H4(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(141),[G2H4(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(144),[G2H4(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(122),[G1H4(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(149),[G2H4(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(152),[G2H4(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(124),[G1H4(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(193),[G2H4(177),G2H4(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(196),[G2H4(180),G2H4(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(135),[G1H4(131),G1H4(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(181),[G2H4(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(184),[G2H4(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(132),[G1H4(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(201),[G2H4(185),G2H4(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(204),[G2H4(188),G2H4(164)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(137),[G1H4(133),G1H4(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(189),[G2H4(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(192),[G2H4(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(134),[G1H4(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(197),[G2H4(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(200),[G2H4(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(136),[G1H4(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(205),[G2H4(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(208),[G2H4(176)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(138),[G1H4(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(4),[G2H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(7),[G2H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(26),[G2H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(27),[G2H8(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(46),[G2H8(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(76),[G2H8(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(81),[G2H8(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(84),[G2H8(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(305),[G2H4(289),G2H4(265)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(308),[G2H4(292),G2H4(268)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(171),[G1H4(167),G1H4(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(293),[G2H4(269)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(296),[G2H4(272)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(168),[G1H4(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(313),[G2H4(297),G2H4(273)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(316),[G2H4(300),G2H4(276)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(173),[G1H4(169),G1H4(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(301),[G2H4(277)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(304),[G2H4(280)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(170),[G1H4(164)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(309),[G2H4(281)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(312),[G2H4(284)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(172),[G1H4(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(317),[G2H4(285)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(320),[G2H4(288)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(174),[G1H4(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(361),[G2H4(345),G2H4(321)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(364),[G2H4(348),G2H4(324)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(185),[G1H4(181),G1H4(175)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(349),[G2H4(325)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(352),[G2H4(328)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(182),[G1H4(176)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(369),[G2H4(353),G2H4(329)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(372),[G2H4(356),G2H4(332)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(187),[G1H4(183),G1H4(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(357),[G2H4(333)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(360),[G2H4(336)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(184),[G1H4(178)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(365),[G2H4(337)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(368),[G2H4(340)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(186),[G1H4(179)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(373),[G2H4(341)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(376),[G2H4(344)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(188),[G1H4(180)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(75),[G2H8(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(45),[G2H8(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(68),[G2H8(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(69),[G2H8(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(80),[G2H8(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(74),[G2H8(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(87),[G2H8(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(82),[G2H8(62)])
  call Hotf_4pt_reduction(G2H2(86),RedSet_4(28),mass4set(:,1),  & 
G1H2(6),G1H2(17),G1H2(28),G1H2(39),G1H2(50),2)
  call HG1shiftOLR(G1H2(17),16,2)
  call Hotf_4pt_reduction(G2H2(90),RedSet_4(31),mass4set(:,1),  & 
G1H2(61),G1H2(72),G1H2(83),G1H2(1),G1H2(2),2)
  call HG1shiftOLR(G1H2(72),16,2)
  call Hotf_4pt_reduction(G2H2(84),RedSet_4(35),mass4set(:,1),  & 
G1H2(7),G1H2(8),G1H2(12),G1H2(13),G1H2(18),2)
  call HG1shiftOLR(G1H2(8),32,2)
  call Hotf_4pt_reduction(G2H2(88),RedSet_4(38),mass4set(:,1),  & 
G1H2(19),G1H2(23),G1H2(24),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(23),32,2)
  call Hotf_4pt_reduction(G2H2(94),RedSet_4(41),mass4set(:,1),  & 
G1H2(34),G1H2(35),G1H2(40),G1H2(41),G1H2(45),2)
  call HG1shiftOLR(G1H2(35),16,2)
  call Hotf_4pt_reduction(G2H2(98),RedSet_4(44),mass4set(:,1),  & 
G1H2(46),G1H2(51),G1H2(52),G1H2(56),G1H2(57),2)
  call HG1shiftOLR(G1H2(51),16,2)
  call Hotf_4pt_reduction(G2H2(92),RedSet_4(47),mass4set(:,1),  & 
G1H2(62),G1H2(63),G1H2(67),G1H2(68),G1H2(73),2)
  call HG1shiftOLR(G1H2(63),32,2)
  call Hotf_4pt_reduction(G2H2(96),RedSet_4(50),mass4set(:,1),  & 
G1H2(74),G1H2(78),G1H2(79),G1H2(84),G1H2(85),2)
  call HG1shiftOLR(G1H2(78),32,2)
  call Hotf_4pt_reduction(G2H2(26),RedSet_4(33),mass4set(:,1),  & 
G1H2(5),G1H2(16),G1H2(27),G1H2(38),G1H2(49),2)
  call HG1shiftOLR(G1H2(16),32,2)
  call Hotf_4pt_reduction(G2H4(42),RedSet_4(54),mass4set(:,1),  & 
G1H4(29),G1H4(40),G1H4(51),G1H4(62),G1H4(73),4)
  call HG1shiftOLR(G1H4(40),10,4)
  call Hotf_4pt_reduction(G2H4(54),RedSet_4(54),mass4set(:,1),  & 
G1H4(84),G1H4(95),G1H4(106),G1H4(1),G1H4(4),4)
  call HG1shiftOLR(G1H4(95),10,4)
  call Hotf_4pt_reduction(G2H2(28),RedSet_4(26),mass4set(:,1),  & 
G1H2(60),G1H2(71),G1H2(82),G1H2(25),G1H2(3),2)
  call HG1shiftOLR(G1H2(71),16,2)
  call Hotf_4pt_reduction(G2H4(102),RedSet_4(54),mass4set(:,1),  & 
G1H4(7),G1H4(10),G1H4(13),G1H4(16),G1H4(19),4)
  call HG1shiftOLR(G1H4(10),10,4)
  call Hotf_4pt_reduction(G2H4(15),RedSet_4(54),mass4set(:,1),  & 
G1H4(22),G1H4(27),G1H4(28),G1H4(35),G1H4(38),4)
  call HG1shiftOLR(G1H4(27),10,4)
  call Hotf_4pt_reduction(G2H2(30),RedSet_4(43),mass4set(:,1),  & 
G1H2(58),G1H2(80),G1H2(59),G1H2(48),G1H2(15),2)
  call HG1shiftOLR(G1H2(80),16,2)
  call Hotf_4pt_reduction(G2H4(209),RedSet_4(61),mass4set(:,1),  & 
G1H4(39),G1H4(46),G1H4(49),G1H4(50),G1H4(57),4)
  call HG1shiftOLR(G1H4(46),9,4)
  call Hotf_4pt_reduction(G2H4(249),RedSet_4(61),mass4set(:,1),  & 
G1H4(60),G1H4(61),G1H4(68),G1H4(71),G1H4(72),4)
  call HG1shiftOLR(G1H4(61),9,4)
  call Hotf_4pt_reduction(G2H2(32),RedSet_4(49),mass4set(:,1),  & 
G1H2(4),G1H2(54),G1H2(21),G1H2(10),G1H2(14),2)
  call HG1shiftOLR(G1H2(54),32,2)
  call Hotf_4pt_reduction(G2H4(217),RedSet_4(61),mass4set(:,1),  & 
G1H4(79),G1H4(82),G1H4(83),G1H4(90),G1H4(93),4)
  call HG1shiftOLR(G1H4(82),9,4)
  call Hotf_4pt_reduction(G2H4(257),RedSet_4(61),mass4set(:,1),  & 
G1H4(94),G1H4(101),G1H4(104),G1H4(105),G1H4(112),4)
  call HG1shiftOLR(G1H4(101),9,4)
  call Hotf_4pt_reduction(G2H4(97),RedSet_4(70),mass4set(:,1),  & 
G1H4(117),G1H4(48),G1H4(47),G1H4(119),G1H4(113),4)
  call HG1shiftOLR(G1H4(48),10,4)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(264),ex6(:),G2tensor(41),m3h2x1(:,41),heltab2x2(:,:,41))
call HGT_w2_OLR(G1H4(2),1,1,4)
call HGT_w2_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(2),wf4(:,2),G1H1(1),m3h4x1(:,33),heltab2x4(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(49),n2h1(65))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(266),ex6(:),G2tensor(57),m3h2x1(:,42),heltab2x2(:,:,42))
call HGT_w2_OLR(G1H4(3),1,1,4)
call HGT_w2_invQ_OLR(G1H4(3),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(3),wf4(:,2),G1H1(1),m3h4x1(:,34),heltab2x4(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(65),n2h1(66))
  call Hotf_4pt_reduction(G2H4(92),RedSet_4(70),mass4set(:,1),  & 
G1H4(114),G1H4(115),G1H4(116),G1H4(131),G1H4(125),4)
  call HG1shiftOLR(G1H4(115),10,4)
call HGT_w2_OLR(G1H4(5),1,1,4)
call HGT_w2_invQ_OLR(G1H4(5),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(5),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,35),heltab2x4(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(1),n2h1(67))
call HGT_w2_OLR(G1H4(6),1,1,4)
call HGT_w2_invQ_OLR(G1H4(6),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(6),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,36),heltab2x4(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(3),n2h1(68))
  call Hotf_4pt_reduction(G2H4(90),RedSet_4(71),mass4set(:,1),  & 
G1H4(126),G1H4(133),G1H4(127),G1H4(128),G1H4(129),4)
  call HG1shiftOLR(G1H4(133),5,4)
call HGT_w2_OLR(G1H4(8),1,1,4)
call HGT_w2_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(8),wf4(:,1),G1H1(1),m3h4x1(:,37),heltab2x4(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(5),n2h1(69))
call HGT_w2_OLR(G1H4(9),1,1,4)
call HGT_w2_invQ_OLR(G1H4(9),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(9),wf4(:,1),G1H1(1),m3h4x1(:,38),heltab2x4(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,0,G2tensor(7),n2h1(70))
  call Hotf_4pt_reduction(G2H4(84),RedSet_4(71),mass4set(:,1),  & 
G1H4(130),G1H4(167),G1H4(161),G1H4(162),G1H4(169),4)
  call HG1shiftOLR(G1H4(167),5,4)
call HGT_w2_OLR(G1H4(11),1,1,4)
call HGT_w2_invQ_OLR(G1H4(11),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(11),wf4(:,8),G1H1(1),ngZd,m3h4x1(:,39),heltab2x4(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(9),n2h1(71))
call HGT_w2_OLR(G1H4(12),1,1,4)
call HGT_w2_invQ_OLR(G1H4(12),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(12),wf4(:,8),G1H1(1),ngZd,m3h4x1(:,40),heltab2x4(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,0,G2tensor(13),n2h1(72))
  call Hotf_4pt_reduction(G2H4(81),RedSet_4(72),mass4set(:,1),  & 
G1H4(163),G1H4(164),G1H4(165),G1H4(166),G1H4(181),4)
  call HG1shiftOLR(G1H4(164),6,4)
call HGT_w2_OLR(G1H4(14),1,1,4)
call HGT_w2_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(14),wf4(:,12),G1H1(1),m3h4x1(:,41),heltab2x4(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(17),n2h1(73))
call HGT_w2_OLR(G1H4(15),1,1,4)
call HGT_w2_invQ_OLR(G1H4(15),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(15),wf4(:,12),G1H1(1),m3h4x1(:,42),heltab2x4(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),6,0,G2tensor(21),n2h1(74))
  call Hotf_4pt_reduction(G2H4(76),RedSet_4(72),mass4set(:,1),  & 
G1H4(175),G1H4(176),G1H4(183),G1H4(177),G1H4(178),4)
  call HG1shiftOLR(G1H4(176),6,4)
call HGT_w2_OLR(G1H4(17),1,1,4)
call HGT_w2_invQ_OLR(G1H4(17),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(17),wf4(:,14),G1H1(1),ngZd,m3h4x1(:,43),heltab2x4(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(25),n2h1(75))
call HGT_w2_OLR(G1H4(18),1,1,4)
call HGT_w2_invQ_OLR(G1H4(18),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(18),wf4(:,14),G1H1(1),ngZd,m3h4x1(:,44),heltab2x4(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),6,0,G2tensor(29),n2h1(76))
  call Hotf_4pt_reduction(G2H4(74),RedSet_4(73),mass4set(:,1),  & 
G1H4(179),G1H4(180),G1H4(2),G1H4(3),G1H4(5),4)
  call HG1shiftOLR(G1H4(180),9,4)
call HGT_w2_OLR(G1H4(20),1,1,4)
call HGT_w2_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(20),wf4(:,11),G1H1(1),m3h4x1(:,45),heltab2x4(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(33),n2h1(77))
call HGT_w2_OLR(G1H4(21),1,1,4)
call HGT_w2_invQ_OLR(G1H4(21),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(21),wf4(:,11),G1H1(1),m3h4x1(:,46),heltab2x4(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(37),n2h1(78))
  call Hotf_4pt_reduction(G2H4(68),RedSet_4(73),mass4set(:,1),  & 
G1H4(6),G1H4(8),G1H4(9),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(8),9,4)
call HGT_w2_OLR(G1H4(23),1,1,4)
call HGT_w2_invQ_OLR(G1H4(23),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(23),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,47),heltab2x4(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(45),n2h1(79))
call HGT_w2_OLR(G1H4(24),1,1,4)
call HGT_w2_invQ_OLR(G1H4(24),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(24),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,48),heltab2x4(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(53),n2h1(80))
  call Hotf_4pt_reduction(G2H2(33),RedSet_4(27),mass4set(:,1),  & 
G1H2(81),G1H2(70),G1H2(37),G1H2(26),G1H2(76),2)
  call HG1shiftOLR(G1H2(70),16,2)
  call Hloop_VQ_A(ntryL,G1H2(9),ex5(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(61),n2h1(81))
  call Hloop_VQ_A(ntryL,G1H2(65),ex5(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(69),n2h1(82))
  call Hloop_VQ_A(ntryL,G1H2(11),ex5(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(73),n2h1(83))
  call Hotf_4pt_reduction(G2H2(76),RedSet_4(30),mass4set(:,1),  & 
G1H2(43),G1H2(32),G1H2(36),G1H2(47),G1H2(69),2)
  call HG1shiftOLR(G1H2(32),16,2)
  call Hloop_VQ_A(ntryL,G1H2(20),ex5(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(74),n2h1(84))
  call Hloop_VQ_A(ntryL,G1H2(22),ex5(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(75),n2h1(85))
  call Hotf_4pt_reduction(G2H2(35),RedSet_4(34),mass4set(:,1),  & 
G1H2(9),G1H2(65),G1H2(11),G1H2(20),G1H2(22),2)
  call HG1shiftOLR(G1H2(65),32,2)
  call Hloop_VA_Q(ntryL,G1H2(31),ex6(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(76),n2h1(86))
  call Hloop_VA_Q(ntryL,G1H2(87),ex6(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(77),n2h1(87))
  call Hloop_VA_Q(ntryL,G1H2(33),ex6(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(78),n2h1(88))
  call Hotf_4pt_reduction(G2H2(78),RedSet_4(37),mass4set(:,1),  & 
G1H2(31),G1H2(87),G1H2(33),G1H2(89),G1H2(90),2)
  call HG1shiftOLR(G1H2(87),32,2)
  call Hloop_VA_Q(ntryL,G1H2(42),ex6(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(79),n2h1(89))
  call Hloop_VA_Q(ntryL,G1H2(44),ex6(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(80),n2h1(90))
  call Hotf_4pt_reduction(G2H2(79),RedSet_4(40),mass4set(:,1),  & 
G1H2(42),G1H2(44),G1H2(91),G1H2(92),G1H2(93),2)
  call HG1shiftOLR(G1H2(44),16,2)
  call Hloop_VQ_A(ntryL,G1H2(53),ex5(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(81),n2h1(91))
  call Hloop_VQ_A(ntryL,G1H2(55),ex5(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(82),n2h1(92))
  call Hloop_VQ_A(ntryL,G1H2(64),ex5(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(83),n2h1(93))
  call Hloop_VQ_A(ntryL,G1H2(66),ex5(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(84),n2h1(94))
  call Hotf_4pt_reduction(G2H2(81),RedSet_4(46),mass4set(:,1),  & 
G1H2(53),G1H2(55),G1H2(64),G1H2(66),G1H2(94),2)
  call HG1shiftOLR(G1H2(55),32,2)
  call Hloop_VA_Q(ntryL,G1H2(75),ex6(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(85),n2h1(95))
  call Hloop_VA_Q(ntryL,G1H2(77),ex6(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(86),n2h1(96))
  call Hloop_VA_Q(ntryL,G1H2(86),ex6(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(87),n2h1(97))
  call Hloop_VA_Q(ntryL,G1H2(88),ex6(:),G1H1(1),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(88),n2h1(98))
  call Hotf_4pt_reduction(G2H4(67),RedSet_4(52),mass4set(:,1),  & 
G1H4(14),G1H4(15),G1H4(17),G1H4(18),G1H4(20),4)
  call HG1shiftOLR(G1H4(15),10,4)
  call Hotf_4pt_reduction(G2H4(66),RedSet_4(53),mass4set(:,1),  & 
G1H4(21),G1H4(23),G1H4(24),G1H4(197),G1H4(198),4)
  call HG1shiftOLR(G1H4(23),10,4)
  call Hloop_AV_Q(ntryL,G1H4(33),wf4(:,2),G1H1(1),m3h4x1(:,49),heltab2x4(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(89),n2h1(99))
  call Hloop_AV_Q(ntryL,G1H4(34),wf4(:,2),G1H1(1),m3h4x1(:,50),heltab2x4(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(90),n2h1(100))
  call Hloop_AV_Q(ntryL,G2H4(14),wf4(:,2),G2H1(1),m3h4x1(:,51),heltab2x4(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(1),n2h1(101))
  call Hotf_4pt_reduction(G2H4(65),RedSet_4(52),mass4set(:,1),  & 
G1H4(33),G1H4(34),G1H4(199),G1H4(200),G1H4(201),4)
  call HG1shiftOLR(G1H4(34),10,4)
  call Hotf_4pt_reduction(G2H4(44),RedSet_4(53),mass4set(:,1),  & 
G1H4(202),G1H4(203),G1H4(204),G1H4(205),G1H4(206),4)
  call HG1shiftOLR(G1H4(203),10,4)
  call Hloop_AZ_Q(ntryL,G1H4(44),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,52),heltab2x4(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(91),n2h1(102))
  call Hloop_AZ_Q(ntryL,G1H4(45),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,53),heltab2x4(:,:,87))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(92),n2h1(103))
  call Hloop_AZ_Q(ntryL,G2H4(26),wf4(:,6),G2H1(1),ngZd,m3h4x1(:,54),heltab2x4(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(2),n2h1(104))
  call Hotf_4pt_reduction(G2H4(41),RedSet_4(56),mass4set(:,1),  & 
G1H4(44),G1H4(45),G1H4(207),G1H4(208),G1H4(209),4)
  call HG1shiftOLR(G1H4(45),10,4)
  call Hotf_4pt_reduction(G2H4(36),RedSet_4(57),mass4set(:,1),  & 
G1H4(210),G1H4(211),G1H4(212),G1H4(213),G1H4(214),4)
  call HG1shiftOLR(G1H4(211),10,4)
  call Hloop_QV_A(ntryL,G1H4(55),wf4(:,2),G1H1(1),m3h4x1(:,55),heltab2x4(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(93),n2h1(105))
  call Hloop_QV_A(ntryL,G1H4(56),wf4(:,2),G1H1(1),m3h4x1(:,56),heltab2x4(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(94),n2h1(106))
  call Hloop_QV_A(ntryL,G2H4(95),wf4(:,2),G2H1(1),m3h4x1(:,57),heltab2x4(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(3),n2h1(107))
  call Hotf_4pt_reduction(G2H4(33),RedSet_4(56),mass4set(:,1),  & 
G1H4(55),G1H4(56),G1H4(215),G1H4(216),G1H4(217),4)
  call HG1shiftOLR(G1H4(56),10,4)
  call Hotf_4pt_reduction(G2H4(12),RedSet_4(57),mass4set(:,1),  & 
G1H4(218),G1H4(219),G1H4(220),G1H4(221),G1H4(222),4)
  call HG1shiftOLR(G1H4(219),10,4)
  call Hloop_QZ_A(ntryL,G1H4(66),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,58),heltab2x4(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(95),n2h1(108))
  call Hloop_QZ_A(ntryL,G1H4(67),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,59),heltab2x4(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(96),n2h1(109))
  call Hloop_QZ_A(ntryL,G2H4(31),wf4(:,6),G2H1(1),ngZd,m3h4x1(:,60),heltab2x4(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(4),n2h1(110))
  call Hotf_4pt_reduction(G2H4(9),RedSet_4(59),mass4set(:,1),  & 
G1H4(66),G1H4(67),G1H4(223),G1H4(224),G1H4(225),4)
  call HG1shiftOLR(G1H4(67),9,4)
  call Hotf_4pt_reduction(G2H4(4),RedSet_4(60),mass4set(:,1),  & 
G1H4(226),G1H4(227),G1H4(228),G1H4(229),G1H4(230),4)
  call HG1shiftOLR(G1H4(227),9,4)
  call Hloop_QV_A(ntryL,G1H4(77),wf4(:,11),G1H1(1),m3h4x1(:,61),heltab2x4(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(97),n2h1(111))
  call Hloop_QV_A(ntryL,G1H4(78),wf4(:,11),G1H1(1),m3h4x1(:,62),heltab2x4(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(98),n2h1(112))
  call Hloop_QV_A(ntryL,G2H4(212),wf4(:,11),G2H1(1),m3h4x1(:,63),heltab2x4(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(5),n2h1(113))
  call Hotf_4pt_reduction(G2H4(1),RedSet_4(59),mass4set(:,1),  & 
G1H4(77),G1H4(78),G1H4(231),G1H4(232),G1H4(233),4)
  call HG1shiftOLR(G1H4(78),9,4)
  call Hotf_4pt_reduction(G2H4(55),RedSet_4(60),mass4set(:,1),  & 
G1H4(234),G1H4(235),G1H4(236),G1H4(237),G1H4(238),4)
  call HG1shiftOLR(G1H4(235),9,4)
  call Hloop_QZ_A(ntryL,G1H4(88),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,64),heltab2x4(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(99),n2h1(114))
  call Hloop_QZ_A(ntryL,G1H4(89),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,65),heltab2x4(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(100),n2h1(115))
  call Hloop_QZ_A(ntryL,G2H4(252),wf4(:,16),G2H1(1),ngZd,m3h4x1(:,66),heltab2x4(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(6),n2h1(116))
  call Hotf_4pt_reduction(G2H4(53),RedSet_4(63),mass4set(:,1),  & 
G1H4(88),G1H4(89),G1H4(239),G1H4(240),G1H4(241),4)
  call HG1shiftOLR(G1H4(89),9,4)
  call Hotf_4pt_reduction(G2H4(48),RedSet_4(64),mass4set(:,1),  & 
G1H4(242),G1H4(243),G1H4(244),G1H4(245),G1H4(246),4)
  call HG1shiftOLR(G1H4(243),9,4)
  call Hloop_AV_Q(ntryL,G1H4(99),wf4(:,11),G1H1(1),m3h4x1(:,67),heltab2x4(:,:,101))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(101),n2h1(117))
  call Hloop_AV_Q(ntryL,G1H4(100),wf4(:,11),G1H1(1),m3h4x1(:,68),heltab2x4(:,:,102))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(102),n2h1(118))
  call Hloop_AV_Q(ntryL,G2H4(220),wf4(:,11),G2H1(1),m3h4x1(:,69),heltab2x4(:,:,103))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(7),n2h1(119))
  call Hotf_4pt_reduction(G2H4(47),RedSet_4(63),mass4set(:,1),  & 
G1H4(99),G1H4(100),G1H4(247),G1H4(248),G1H4(249),4)
  call HG1shiftOLR(G1H4(100),9,4)
  call Hotf_4pt_reduction(G2H4(46),RedSet_4(64),mass4set(:,1),  & 
G1H4(250),G1H4(251),G1H4(252),G1H4(253),G1H4(254),4)
  call HG1shiftOLR(G1H4(251),9,4)
  call Hloop_AZ_Q(ntryL,G1H4(110),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,70),heltab2x4(:,:,104))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(103),n2h1(120))
  call Hloop_AZ_Q(ntryL,G1H4(111),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,71),heltab2x4(:,:,105))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(104),n2h1(121))
  call Hloop_AZ_Q(ntryL,G2H4(260),wf4(:,16),G2H1(1),ngZd,m3h4x1(:,72),heltab2x4(:,:,106))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(8),n2h1(122))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(110),ex6(:),G2tensor(105),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(128),ex6(:),G2tensor(106),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(104),ex6(:),G2tensor(107),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(134),ex6(:),G2tensor(108),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(146),ex6(:),G2tensor(109),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(164),ex6(:),G2tensor(110),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(140),ex6(:),G2tensor(111),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(170),ex6(:),G2tensor(112),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hotf_4pt_reduction(G2H8(17),RedSet_4(74),mass4set(:,1),  & 
G1H8(153),G1H8(154),G1H8(158),G1H8(159),G1H8(169),8)
  call HG1shiftOLR(G1H8(154),21,8)
  call Hotf_4pt_reduction(G2H8(19),RedSet_4(74),mass4set(:,1),  & 
G1H8(170),G1H8(174),G1H8(175),G1H8(49),G1H8(50),8)
  call HG1shiftOLR(G1H8(174),21,8)
  call Hotf_4pt_reduction(G2H8(20),RedSet_4(75),mass4set(:,1),  & 
G1H8(60),G1H8(56),G1H8(59),G1H8(61),G1H8(65),8)
  call HG1shiftOLR(G1H8(56),37,8)
  call Hotf_4pt_reduction(G2H8(21),RedSet_4(75),mass4set(:,1),  & 
G1H8(66),G1H8(71),G1H8(76),G1H8(75),G1H8(77),8)
  call HG1shiftOLR(G1H8(71),37,8)
  call Hotf_4pt_reduction(G2H8(23),RedSet_4(11),mass4set(:,1),  & 
G1H8(80),G1H8(81),G1H8(87),G1H8(92),G1H8(88),8)
  call HG1shiftOLR(G1H8(81),26,8)
  call Hotf_4pt_reduction(G2H8(24),RedSet_4(11),mass4set(:,1),  & 
G1H8(91),G1H8(96),G1H8(97),G1H8(98),G1H8(103),8)
  call HG1shiftOLR(G1H8(96),26,8)
  call Hotf_4pt_reduction(G2H8(33),RedSet_4(10),mass4set(:,1),  & 
G1H8(104),G1H8(107),G1H8(109),G1H8(112),G1H8(114),8)
  call HG1shiftOLR(G1H8(107),42,8)
  call Hotf_4pt_reduction(G2H8(35),RedSet_4(10),mass4set(:,1),  & 
G1H8(119),G1H8(124),G1H8(120),G1H8(125),G1H8(128),8)
  call HG1shiftOLR(G1H8(124),42,8)
  call Hotf_4pt_reduction(G2H8(57),RedSet_4(12),mass4set(:,1),  & 
G1H8(129),G1H8(130),G1H8(140),G1H8(136),G1H8(139),8)
  call HG1shiftOLR(G1H8(130),25,8)
  call Hotf_4pt_reduction(G2H8(59),RedSet_4(12),mass4set(:,1),  & 
G1H8(141),G1H8(145),G1H8(146),G1H8(151),G1H8(156),8)
  call HG1shiftOLR(G1H8(145),25,8)
  call Hotf_4pt_reduction(G2H8(60),RedSet_4(13),mass4set(:,1),  & 
G1H8(155),G1H8(157),G1H8(160),G1H8(161),G1H8(167),8)
  call HG1shiftOLR(G1H8(157),41,8)
  call Hotf_4pt_reduction(G2H8(61),RedSet_4(13),mass4set(:,1),  & 
G1H8(172),G1H8(168),G1H8(171),G1H8(176),G1H8(53),8)
  call HG1shiftOLR(G1H8(168),41,8)
  call Hotf_4pt_reduction(G2H8(36),RedSet_4(76),mass4set(:,1),  & 
G1H8(54),G1H8(69),G1H8(85),G1H8(86),G1H8(101),8)
  call HG1shiftOLR(G1H8(69),22,8)
  call Hotf_4pt_reduction(G2H8(43),RedSet_4(76),mass4set(:,1),  & 
G1H8(102),G1H8(118),G1H8(133),G1H8(134),G1H8(149),8)
  call HG1shiftOLR(G1H8(118),22,8)
  call Hotf_4pt_reduction(G2H8(41),RedSet_4(77),mass4set(:,1),  & 
G1H8(165),G1H8(166),G1H8(1),G1H8(2),G1H8(6),8)
  call HG1shiftOLR(G1H8(166),38,8)
  call Hotf_4pt_reduction(G2H8(44),RedSet_4(77),mass4set(:,1),  & 
G1H8(7),G1H8(8),G1H8(11),G1H8(13),G1H8(14),8)
  call HG1shiftOLR(G1H8(8),38,8)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(102),ex6(:),G2tensor(113),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(108),ex6(:),G2tensor(114),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(114),ex5(:),G2tensor(115),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(116),ex5(:),G2tensor(116),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(120),ex5(:),G2tensor(117),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(122),ex5(:),G2tensor(118),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(126),ex6(:),G2tensor(119),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(132),ex6(:),G2tensor(120),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(138),ex6(:),G2tensor(121),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(144),ex6(:),G2tensor(122),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(150),ex5(:),G2tensor(123),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(152),ex5(:),G2tensor(124),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(156),ex5(:),G2tensor(125),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(158),ex5(:),G2tensor(126),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(162),ex6(:),G2tensor(127),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(168),ex6(:),G2tensor(128),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hloop_AV_Q(ntryL,G1H4(54),wf4(:,2),G1H1(1),m3h4x1(:,73),heltab2x4(:,:,107))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(129),n2h1(123))
  call Hotf_4pt_reduction(G2H4(10),RedSet_4(54),mass4set(:,2),  & 
G1H4(110),G1H4(111),G1H4(54),G1H4(255),G1H4(256),4)
  call HG1shiftOLR(G1H4(111),10,4)
  call Hloop_AV_Q(ntryL,G2H4(103),wf4(:,2),G2H1(1),m3h4x1(:,74),heltab2x4(:,:,108))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(9),n2h1(124))
  call Hloop_AV_Q(ntryL,G1H4(65),wf4(:,2),G1H1(1),m3h4x1(:,75),heltab2x4(:,:,109))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(130),n2h1(125))
  call Hloop_QV_A(ntryL,G1H4(76),wf4(:,2),G1H1(1),m3h4x1(:,76),heltab2x4(:,:,110))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(131),n2h1(126))
  call Hotf_4pt_reduction(G2H4(94),RedSet_4(54),mass4set(:,2),  & 
G1H4(65),G1H4(76),G1H4(257),G1H4(258),G1H4(259),4)
  call HG1shiftOLR(G1H4(76),10,4)
  call Hloop_QV_A(ntryL,G2H4(87),wf4(:,2),G2H1(1),m3h4x1(:,77),heltab2x4(:,:,111))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(10),n2h1(127))
  call Hloop_QV_A(ntryL,G1H4(87),wf4(:,2),G1H1(1),m3h4x1(:,78),heltab2x4(:,:,112))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(132),n2h1(128))
  call Hotf_4pt_reduction(G2H4(86),RedSet_4(54),mass4set(:,3),  & 
G1H4(87),G1H4(260),G1H4(261),G1H4(262),G1H4(263),4)
  call HG1shiftOLR(G1H4(260),10,4)
  call Hloop_AV_Q(ntryL,G2H4(79),wf4(:,2),G2H1(1),m3h4x1(:,79),heltab2x4(:,:,113))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(11),n2h1(129))
  call Hloop_AV_Q(ntryL,G1H4(58),wf4(:,2),G1H1(1),m3h4x1(:,80),heltab2x4(:,:,114))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(133),n2h1(130))
  call Hotf_4pt_reduction(G2H4(78),RedSet_4(54),mass4set(:,3),  & 
G1H4(58),G1H4(264),G1H4(265),G1H4(266),G1H4(267),4)
  call HG1shiftOLR(G1H4(264),10,4)
  call Hloop_QV_A(ntryL,G2H4(71),wf4(:,2),G2H1(1),m3h4x1(:,81),heltab2x4(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(12),n2h1(131))
  call Hloop_QV_A(ntryL,G1H4(70),wf4(:,2),G1H1(1),m3h4x1(:,82),heltab2x4(:,:,116))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(134),n2h1(132))
  call Hotf_4pt_reduction(G2H4(70),RedSet_4(54),mass4set(:,1),  & 
G1H4(70),G1H4(268),G1H4(269),G1H4(270),G1H4(271),4)
  call HG1shiftOLR(G1H4(268),10,4)
  call Hloop_AZ_Q(ntryL,G2H4(57),wf4(:,6),G2H1(1),ngZu,m3h4x1(:,83),heltab2x4(:,:,117))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(13),n2h1(133))
  call Hloop_AZ_Q(ntryL,G1H4(86),wf4(:,6),G1H1(1),ngZu,m3h4x1(:,84),heltab2x4(:,:,118))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(135),n2h1(134))
  call Hotf_4pt_reduction(G2H4(52),RedSet_4(54),mass4set(:,2),  & 
G1H4(86),G1H4(272),G1H4(273),G1H4(274),G1H4(275),4)
  call HG1shiftOLR(G1H4(272),10,4)
  call Hloop_AZ_Q(ntryL,G2H4(25),wf4(:,6),G2H1(1),ngZu,m3h4x1(:,85),heltab2x4(:,:,119))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(14),n2h1(135))
  call Hloop_AZ_Q(ntryL,G1H4(59),wf4(:,6),G1H1(1),ngZu,m3h4x1(:,86),heltab2x4(:,:,120))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(136),n2h1(136))
  call Hotf_4pt_reduction(G2H4(20),RedSet_4(54),mass4set(:,1),  & 
G1H4(59),G1H4(276),G1H4(277),G1H4(278),G1H4(279),4)
  call HG1shiftOLR(G1H4(276),10,4)
  call Hloop_QZ_A(ntryL,G2H4(63),wf4(:,6),G2H1(1),ngZu,m3h4x1(:,87),heltab2x4(:,:,121))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(15),n2h1(137))
  call Hloop_QZ_A(ntryL,G1H4(80),wf4(:,6),G1H1(1),ngZu,m3h4x1(:,88),heltab2x4(:,:,122))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(137),n2h1(138))
  call Hotf_4pt_reduction(G2H4(61),RedSet_4(54),mass4set(:,2),  & 
G1H4(80),G1H4(280),G1H4(281),G1H4(282),G1H4(283),4)
  call HG1shiftOLR(G1H4(280),10,4)
  call Hloop_QZ_A(ntryL,G2H4(58),wf4(:,6),G2H1(1),ngZu,m3h4x1(:,89),heltab2x4(:,:,123))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(16),n2h1(139))
  call Hloop_QZ_A(ntryL,G1H4(53),wf4(:,6),G1H1(1),ngZu,m3h4x1(:,90),heltab2x4(:,:,124))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(138),n2h1(140))
  call Hloop_AZ_Q(ntryL,G1H4(81),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,91),heltab2x4(:,:,125))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(139),n2h1(141))
  call Hotf_4pt_reduction(G2H4(22),RedSet_4(54),mass4set(:,3),  & 
G1H4(53),G1H4(81),G1H4(284),G1H4(285),G1H4(286),4)
  call HG1shiftOLR(G1H4(81),10,4)
  call Hloop_AZ_Q(ntryL,G2H4(8),wf4(:,6),G2H1(1),ngZd,m3h4x1(:,92),heltab2x4(:,:,126))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(17),n2h1(142))
  call Hloop_AZ_Q(ntryL,G1H4(69),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,93),heltab2x4(:,:,127))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(140),n2h1(143))
  call Hloop_QZ_A(ntryL,G1H4(64),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,94),heltab2x4(:,:,128))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(141),n2h1(144))
  call Hotf_4pt_reduction(G2H4(37),RedSet_4(54),mass4set(:,3),  & 
G1H4(69),G1H4(64),G1H4(287),G1H4(288),G1H4(289),4)
  call HG1shiftOLR(G1H4(64),10,4)
  call Hloop_QZ_A(ntryL,G2H4(104),wf4(:,6),G2H1(1),ngZd,m3h4x1(:,95),heltab2x4(:,:,129))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(18),n2h1(145))
  call Hloop_QZ_A(ntryL,G1H4(75),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,96),heltab2x4(:,:,130))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(142),n2h1(146))
  call Hotf_4pt_reduction(G2H4(137),RedSet_4(7),mass4set(:,1),  & 
G1H4(75),G1H4(290),G1H4(291),G1H4(292),G1H4(293),4)
  call HG1shiftOLR(G1H4(290),48,4)
  call Hloop_AV_Q(ntryL,G2H4(140),wf4(:,17),G2H1(1),m3h4x1(:,97),heltab2x4(:,:,131))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(19),n2h1(147))
  call Hloop_AV_Q(ntryL,G1H4(121),wf4(:,17),G1H1(1),m3h4x1(:,98),heltab2x4(:,:,132))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(143),n2h1(148))
  call Hotf_4pt_reduction(G2H4(125),RedSet_4(7),mass4set(:,2),  & 
G1H4(121),G1H4(294),G1H4(295),G1H4(296),G1H4(297),4)
  call HG1shiftOLR(G1H4(294),48,4)
  call Hloop_AV_Q(ntryL,G2H4(128),wf4(:,17),G2H1(1),m3h4x1(:,99),heltab2x4(:,:,133))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(20),n2h1(149))
  call Hloop_AV_Q(ntryL,G1H4(118),wf4(:,17),G1H1(1),m3h4x1(:,100),heltab2x4(:,:,134))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(144),n2h1(150))
  call Hotf_4pt_reduction(G2H4(145),RedSet_4(7),mass4set(:,1),  & 
G1H4(118),G1H4(298),G1H4(299),G1H4(300),G1H4(301),4)
  call HG1shiftOLR(G1H4(298),48,4)
  call Hloop_QV_A(ntryL,G2H4(148),wf4(:,17),G2H1(1),m3h4x1(:,101),heltab2x4(:,:,135))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(21),n2h1(151))
  call Hloop_QV_A(ntryL,G1H4(123),wf4(:,17),G1H1(1),m3h4x1(:,102),heltab2x4(:,:,136))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(145),n2h1(152))
  call Hotf_4pt_reduction(G2H4(133),RedSet_4(7),mass4set(:,2),  & 
G1H4(123),G1H4(302),G1H4(303),G1H4(304),G1H4(305),4)
  call HG1shiftOLR(G1H4(302),48,4)
  call Hloop_QV_A(ntryL,G2H4(136),wf4(:,17),G2H1(1),m3h4x1(:,103),heltab2x4(:,:,137))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(22),n2h1(153))
  call Hloop_QV_A(ntryL,G1H4(120),wf4(:,17),G1H1(1),m3h4x1(:,104),heltab2x4(:,:,138))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(146),n2h1(154))
  call Hotf_4pt_reduction(G2H4(141),RedSet_4(7),mass4set(:,3),  & 
G1H4(120),G1H4(306),G1H4(307),G1H4(308),G1H4(309),4)
  call HG1shiftOLR(G1H4(306),48,4)
  call Hloop_AV_Q(ntryL,G2H4(144),wf4(:,17),G2H1(1),m3h4x1(:,105),heltab2x4(:,:,139))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(23),n2h1(155))
  call Hloop_AV_Q(ntryL,G1H4(122),wf4(:,17),G1H1(1),m3h4x1(:,106),heltab2x4(:,:,140))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(147),n2h1(156))
  call Hotf_4pt_reduction(G2H4(149),RedSet_4(7),mass4set(:,3),  & 
G1H4(122),G1H4(310),G1H4(311),G1H4(312),G1H4(313),4)
  call HG1shiftOLR(G1H4(310),48,4)
  call Hloop_QV_A(ntryL,G2H4(152),wf4(:,17),G2H1(1),m3h4x1(:,107),heltab2x4(:,:,141))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(24),n2h1(157))
  call Hloop_QV_A(ntryL,G1H4(124),wf4(:,17),G1H1(1),m3h4x1(:,108),heltab2x4(:,:,142))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(148),n2h1(158))
  call Hotf_4pt_reduction(G2H4(193),RedSet_4(6),mass4set(:,1),  & 
G1H4(124),G1H4(314),G1H4(315),G1H4(316),G1H4(317),4)
  call HG1shiftOLR(G1H4(314),48,4)
  call Hloop_AV_Q(ntryL,G2H4(196),wf4(:,17),G2H1(1),m3h4x1(:,109),heltab2x4(:,:,143))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(25),n2h1(159))
  call Hloop_AV_Q(ntryL,G1H4(135),wf4(:,17),G1H1(1),m3h4x1(:,110),heltab2x4(:,:,144))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(149),n2h1(160))
  call Hotf_4pt_reduction(G2H4(181),RedSet_4(6),mass4set(:,2),  & 
G1H4(135),G1H4(318),G1H4(319),G1H4(320),G1H4(321),4)
  call HG1shiftOLR(G1H4(318),48,4)
  call Hloop_AV_Q(ntryL,G2H4(184),wf4(:,17),G2H1(1),m3h4x1(:,111),heltab2x4(:,:,145))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(26),n2h1(161))
  call Hloop_AV_Q(ntryL,G1H4(132),wf4(:,17),G1H1(1),m3h4x1(:,112),heltab2x4(:,:,146))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(150),n2h1(162))
  call Hotf_4pt_reduction(G2H4(201),RedSet_4(6),mass4set(:,1),  & 
G1H4(132),G1H4(322),G1H4(323),G1H4(324),G1H4(325),4)
  call HG1shiftOLR(G1H4(322),48,4)
  call Hloop_QV_A(ntryL,G2H4(204),wf4(:,17),G2H1(1),m3h4x1(:,113),heltab2x4(:,:,147))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(27),n2h1(163))
  call Hloop_QV_A(ntryL,G1H4(137),wf4(:,17),G1H1(1),m3h4x1(:,114),heltab2x4(:,:,148))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(151),n2h1(164))
  call Hotf_4pt_reduction(G2H4(189),RedSet_4(6),mass4set(:,2),  & 
G1H4(137),G1H4(326),G1H4(327),G1H4(328),G1H4(329),4)
  call HG1shiftOLR(G1H4(326),48,4)
  call Hloop_QV_A(ntryL,G2H4(192),wf4(:,17),G2H1(1),m3h4x1(:,115),heltab2x4(:,:,149))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(28),n2h1(165))
  call Hloop_QV_A(ntryL,G1H4(134),wf4(:,17),G1H1(1),m3h4x1(:,116),heltab2x4(:,:,150))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(152),n2h1(166))
  call Hotf_4pt_reduction(G2H4(197),RedSet_4(6),mass4set(:,3),  & 
G1H4(134),G1H4(330),G1H4(331),G1H4(332),G1H4(333),4)
  call HG1shiftOLR(G1H4(330),48,4)
  call Hloop_AV_Q(ntryL,G2H4(200),wf4(:,17),G2H1(1),m3h4x1(:,117),heltab2x4(:,:,151))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(29),n2h1(167))
  call Hloop_AV_Q(ntryL,G1H4(136),wf4(:,17),G1H1(1),m3h4x1(:,118),heltab2x4(:,:,152))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(153),n2h1(168))
  call Hotf_4pt_reduction(G2H4(205),RedSet_4(6),mass4set(:,3),  & 
G1H4(136),G1H4(334),G1H4(335),G1H4(336),G1H4(337),4)
  call HG1shiftOLR(G1H4(334),48,4)
  call Hloop_QV_A(ntryL,G2H4(208),wf4(:,17),G2H1(1),m3h4x1(:,119),heltab2x4(:,:,153))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(30),n2h1(169))
  call Hloop_QV_A(ntryL,G1H4(138),wf4(:,17),G1H1(1),m3h4x1(:,120),heltab2x4(:,:,154))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(154),n2h1(170))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(4),wf8(:,2),G2tensor(155),m3h8x1(:,1),heltab2x8(:,:,241))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(7),wf8(:,2),G2tensor(156),m3h8x1(:,2),heltab2x8(:,:,242))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(26),wf8(:,4),G2tensor(157),m3h8x1(:,3),heltab2x8(:,:,243))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(27),wf8(:,4),G2tensor(158),m3h8x1(:,4),heltab2x8(:,:,244))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(46),wf8(:,6),G2tensor(159),m3h8x1(:,5),heltab2x8(:,:,245))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(76),wf8(:,6),G2tensor(160),m3h8x1(:,6),heltab2x8(:,:,246))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(81),wf8(:,8),G2tensor(161),m3h8x1(:,7),heltab2x8(:,:,247))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(84),wf8(:,8),G2tensor(162),m3h8x1(:,8),heltab2x8(:,:,248))
  call Hloop_QV_A(ntryL,G1H4(147),wf4(:,11),G1H1(1),m3h4x1(:,121),heltab2x4(:,:,155))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(163),n2h1(171))
  call Hotf_4pt_reduction(G2H4(213),RedSet_4(61),mass4set(:,2),  & 
G1H4(138),G1H4(147),G1H4(338),G1H4(339),G1H4(340),4)
  call HG1shiftOLR(G1H4(147),9,4)
  call Hloop_QV_A(ntryL,G2H4(216),wf4(:,11),G2H1(1),m3h4x1(:,122),heltab2x4(:,:,156))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(31),n2h1(172))
  call Hloop_QV_A(ntryL,G1H4(148),wf4(:,11),G1H1(1),m3h4x1(:,123),heltab2x4(:,:,157))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(164),n2h1(173))
  call Hloop_AV_Q(ntryL,G1H4(149),wf4(:,11),G1H1(1),m3h4x1(:,124),heltab2x4(:,:,158))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(165),n2h1(174))
  call Hotf_4pt_reduction(G2H4(221),RedSet_4(61),mass4set(:,2),  & 
G1H4(148),G1H4(149),G1H4(341),G1H4(342),G1H4(343),4)
  call HG1shiftOLR(G1H4(149),9,4)
  call Hloop_AV_Q(ntryL,G2H4(224),wf4(:,11),G2H1(1),m3h4x1(:,125),heltab2x4(:,:,159))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(32),n2h1(175))
  call Hloop_AV_Q(ntryL,G1H4(150),wf4(:,11),G1H1(1),m3h4x1(:,126),heltab2x4(:,:,160))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(166),n2h1(176))
  call Hotf_4pt_reduction(G2H4(225),RedSet_4(61),mass4set(:,3),  & 
G1H4(150),G1H4(344),G1H4(345),G1H4(346),G1H4(347),4)
  call HG1shiftOLR(G1H4(344),9,4)
  call Hloop_QV_A(ntryL,G2H4(228),wf4(:,11),G2H1(1),m3h4x1(:,127),heltab2x4(:,:,161))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(33),n2h1(177))
  call Hloop_QV_A(ntryL,G1H4(151),wf4(:,11),G1H1(1),m3h4x1(:,128),heltab2x4(:,:,162))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(167),n2h1(178))
  call Hotf_4pt_reduction(G2H4(229),RedSet_4(61),mass4set(:,3),  & 
G1H4(151),G1H4(348),G1H4(349),G1H4(350),G1H4(351),4)
  call HG1shiftOLR(G1H4(348),9,4)
  call Hloop_AV_Q(ntryL,G2H4(232),wf4(:,11),G2H1(1),m3h4x1(:,129),heltab2x4(:,:,163))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(34),n2h1(179))
  call Hloop_AV_Q(ntryL,G1H4(152),wf4(:,11),G1H1(1),m3h4x1(:,130),heltab2x4(:,:,164))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(168),n2h1(180))
  call Hotf_4pt_reduction(G2H4(233),RedSet_4(61),mass4set(:,1),  & 
G1H4(152),G1H4(352),G1H4(353),G1H4(354),G1H4(355),4)
  call HG1shiftOLR(G1H4(352),9,4)
  call Hloop_QZ_A(ntryL,G2H4(236),wf4(:,16),G2H1(1),ngZu,m3h4x1(:,131),heltab2x4(:,:,165))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(35),n2h1(181))
  call Hloop_QZ_A(ntryL,G1H4(153),wf4(:,16),G1H1(1),ngZu,m3h4x1(:,132),heltab2x4(:,:,166))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(169),n2h1(182))
  call Hotf_4pt_reduction(G2H4(237),RedSet_4(61),mass4set(:,2),  & 
G1H4(153),G1H4(356),G1H4(357),G1H4(358),G1H4(359),4)
  call HG1shiftOLR(G1H4(356),9,4)
  call Hloop_QZ_A(ntryL,G2H4(240),wf4(:,16),G2H1(1),ngZu,m3h4x1(:,133),heltab2x4(:,:,167))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(36),n2h1(183))
  call Hloop_QZ_A(ntryL,G1H4(154),wf4(:,16),G1H1(1),ngZu,m3h4x1(:,134),heltab2x4(:,:,168))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(170),n2h1(184))
  call Hotf_4pt_reduction(G2H4(241),RedSet_4(61),mass4set(:,1),  & 
G1H4(154),G1H4(360),G1H4(361),G1H4(362),G1H4(363),4)
  call HG1shiftOLR(G1H4(360),9,4)
  call Hloop_AZ_Q(ntryL,G2H4(244),wf4(:,16),G2H1(1),ngZu,m3h4x1(:,135),heltab2x4(:,:,169))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(37),n2h1(185))
  call Hloop_AZ_Q(ntryL,G1H4(155),wf4(:,16),G1H1(1),ngZu,m3h4x1(:,136),heltab2x4(:,:,170))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(171),n2h1(186))
  call Hotf_4pt_reduction(G2H4(245),RedSet_4(61),mass4set(:,2),  & 
G1H4(155),G1H4(364),G1H4(365),G1H4(366),G1H4(367),4)
  call HG1shiftOLR(G1H4(364),9,4)
  call Hloop_AZ_Q(ntryL,G2H4(248),wf4(:,16),G2H1(1),ngZu,m3h4x1(:,137),heltab2x4(:,:,171))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(38),n2h1(187))
  call Hloop_AZ_Q(ntryL,G1H4(156),wf4(:,16),G1H1(1),ngZu,m3h4x1(:,138),heltab2x4(:,:,172))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(172),n2h1(188))
  call Hloop_QZ_A(ntryL,G1H4(157),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,139),heltab2x4(:,:,173))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(173),n2h1(189))
  call Hotf_4pt_reduction(G2H4(253),RedSet_4(61),mass4set(:,3),  & 
G1H4(156),G1H4(157),G1H4(368),G1H4(369),G1H4(370),4)
  call HG1shiftOLR(G1H4(157),9,4)
  call Hloop_QZ_A(ntryL,G2H4(256),wf4(:,16),G2H1(1),ngZd,m3h4x1(:,140),heltab2x4(:,:,174))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(39),n2h1(190))
  call Hloop_QZ_A(ntryL,G1H4(158),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,141),heltab2x4(:,:,175))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(174),n2h1(191))
  call Hloop_AZ_Q(ntryL,G1H4(159),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,142),heltab2x4(:,:,176))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(175),n2h1(192))
  call Hotf_4pt_reduction(G2H4(261),RedSet_4(61),mass4set(:,3),  & 
G1H4(158),G1H4(159),G1H4(371),G1H4(372),G1H4(373),4)
  call HG1shiftOLR(G1H4(159),9,4)
  call Hloop_AZ_Q(ntryL,G2H4(264),wf4(:,16),G2H1(1),ngZd,m3h4x1(:,143),heltab2x4(:,:,177))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(40),n2h1(193))
  call Hloop_AZ_Q(ntryL,G1H4(160),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,144),heltab2x4(:,:,178))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(176),n2h1(194))
  call Hotf_4pt_reduction(G2H4(305),RedSet_4(9),mass4set(:,1),  & 
G1H4(160),G1H4(374),G1H4(375),G1H4(376),G1H4(377),4)
  call HG1shiftOLR(G1H4(374),48,4)
  call Hloop_AV_Q(ntryL,G2H4(308),wf4(:,17),G2H1(1),m3h4x1(:,145),heltab2x4(:,:,179))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(41),n2h1(195))
  call Hloop_AV_Q(ntryL,G1H4(171),wf4(:,17),G1H1(1),m3h4x1(:,146),heltab2x4(:,:,180))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(177),n2h1(196))
  call Hotf_4pt_reduction(G2H4(293),RedSet_4(9),mass4set(:,2),  & 
G1H4(171),G1H4(378),G1H4(379),G1H4(380),G1H4(381),4)
  call HG1shiftOLR(G1H4(378),48,4)
  call Hloop_AV_Q(ntryL,G2H4(296),wf4(:,17),G2H1(1),m3h4x1(:,147),heltab2x4(:,:,181))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(42),n2h1(197))
  call Hloop_AV_Q(ntryL,G1H4(168),wf4(:,17),G1H1(1),m3h4x1(:,148),heltab2x4(:,:,182))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(178),n2h1(198))
  call Hotf_4pt_reduction(G2H4(313),RedSet_4(9),mass4set(:,1),  & 
G1H4(168),G1H4(382),G1H4(383),G1H4(384),G1H4(385),4)
  call HG1shiftOLR(G1H4(382),48,4)
  call Hloop_QV_A(ntryL,G2H4(316),wf4(:,17),G2H1(1),m3h4x1(:,149),heltab2x4(:,:,183))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(43),n2h1(199))
  call Hloop_QV_A(ntryL,G1H4(173),wf4(:,17),G1H1(1),m3h4x1(:,150),heltab2x4(:,:,184))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(179),n2h1(200))
  call Hotf_4pt_reduction(G2H4(301),RedSet_4(9),mass4set(:,2),  & 
G1H4(173),G1H4(386),G1H4(387),G1H4(388),G1H4(389),4)
  call HG1shiftOLR(G1H4(386),48,4)
  call Hloop_QV_A(ntryL,G2H4(304),wf4(:,17),G2H1(1),m3h4x1(:,151),heltab2x4(:,:,185))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(44),n2h1(201))
  call Hloop_QV_A(ntryL,G1H4(170),wf4(:,17),G1H1(1),m3h4x1(:,152),heltab2x4(:,:,186))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(180),n2h1(202))
  call Hotf_4pt_reduction(G2H4(309),RedSet_4(9),mass4set(:,3),  & 
G1H4(170),G1H4(390),G1H4(391),G1H4(392),G1H4(393),4)
  call HG1shiftOLR(G1H4(390),48,4)
  call Hloop_AV_Q(ntryL,G2H4(312),wf4(:,17),G2H1(1),m3h4x1(:,153),heltab2x4(:,:,187))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(45),n2h1(203))
  call Hloop_AV_Q(ntryL,G1H4(172),wf4(:,17),G1H1(1),m3h4x1(:,154),heltab2x4(:,:,188))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(181),n2h1(204))
  call Hotf_4pt_reduction(G2H4(317),RedSet_4(9),mass4set(:,3),  & 
G1H4(172),G1H4(394),G1H4(395),G1H4(396),G1H4(397),4)
  call HG1shiftOLR(G1H4(394),48,4)
  call Hloop_QV_A(ntryL,G2H4(320),wf4(:,17),G2H1(1),m3h4x1(:,155),heltab2x4(:,:,189))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(46),n2h1(205))
  call Hloop_QV_A(ntryL,G1H4(174),wf4(:,17),G1H1(1),m3h4x1(:,156),heltab2x4(:,:,190))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(182),n2h1(206))
  call Hotf_4pt_reduction(G2H4(361),RedSet_4(8),mass4set(:,1),  & 
G1H4(174),G1H4(398),G1H4(399),G1H4(400),G1H4(401),4)
  call HG1shiftOLR(G1H4(398),48,4)
  call Hloop_AV_Q(ntryL,G2H4(364),wf4(:,17),G2H1(1),m3h4x1(:,157),heltab2x4(:,:,191))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(47),n2h1(207))
  call Hloop_AV_Q(ntryL,G1H4(185),wf4(:,17),G1H1(1),m3h4x1(:,158),heltab2x4(:,:,192))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(183),n2h1(208))
  call Hotf_4pt_reduction(G2H4(349),RedSet_4(8),mass4set(:,2),  & 
G1H4(185),G1H4(402),G1H4(403),G1H4(404),G1H4(405),4)
  call HG1shiftOLR(G1H4(402),48,4)
  call Hloop_AV_Q(ntryL,G2H4(352),wf4(:,17),G2H1(1),m3h4x1(:,159),heltab2x4(:,:,193))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(48),n2h1(209))
  call Hloop_AV_Q(ntryL,G1H4(182),wf4(:,17),G1H1(1),m3h4x1(:,160),heltab2x4(:,:,194))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(184),n2h1(210))
  call Hotf_4pt_reduction(G2H4(369),RedSet_4(8),mass4set(:,1),  & 
G1H4(182),G1H4(406),G1H4(407),G1H4(408),G1H4(409),4)
  call HG1shiftOLR(G1H4(406),48,4)
  call Hloop_QV_A(ntryL,G2H4(372),wf4(:,17),G2H1(1),m3h4x1(:,161),heltab2x4(:,:,195))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(49),n2h1(211))
  call Hloop_QV_A(ntryL,G1H4(187),wf4(:,17),G1H1(1),m3h4x1(:,162),heltab2x4(:,:,196))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(185),n2h1(212))
  call Hotf_4pt_reduction(G2H4(357),RedSet_4(8),mass4set(:,2),  & 
G1H4(187),G1H4(410),G1H4(411),G1H4(412),G1H4(413),4)
  call HG1shiftOLR(G1H4(410),48,4)
  call Hloop_QV_A(ntryL,G2H4(360),wf4(:,17),G2H1(1),m3h4x1(:,163),heltab2x4(:,:,197))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(50),n2h1(213))
  call Hloop_QV_A(ntryL,G1H4(184),wf4(:,17),G1H1(1),m3h4x1(:,164),heltab2x4(:,:,198))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(186),n2h1(214))
  call Hotf_4pt_reduction(G2H4(365),RedSet_4(8),mass4set(:,3),  & 
G1H4(184),G1H4(414),G1H4(415),G1H4(416),G1H4(417),4)
  call HG1shiftOLR(G1H4(414),48,4)
  call Hloop_AV_Q(ntryL,G2H4(368),wf4(:,17),G2H1(1),m3h4x1(:,165),heltab2x4(:,:,199))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(51),n2h1(215))
  call Hloop_AV_Q(ntryL,G1H4(186),wf4(:,17),G1H1(1),m3h4x1(:,166),heltab2x4(:,:,200))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(187),n2h1(216))
  call Hotf_4pt_reduction(G2H4(373),RedSet_4(8),mass4set(:,3),  & 
G1H4(186),G1H4(418),G1H4(419),G1H4(420),G1H4(421),4)
  call HG1shiftOLR(G1H4(418),48,4)
  call Hloop_QV_A(ntryL,G2H4(376),wf4(:,17),G2H1(1),m3h4x1(:,167),heltab2x4(:,:,201))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(52),n2h1(217))
  call Hloop_QV_A(ntryL,G1H4(188),wf4(:,17),G1H1(1),m3h4x1(:,168),heltab2x4(:,:,202))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(188),n2h1(218))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(75),wf8(:,32),G2tensor(189),m3h8x1(:,9),heltab2x8(:,:,249))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(45),wf8(:,32),G2tensor(190),m3h8x1(:,10),heltab2x8(:,:,250))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(68),wf8(:,34),G2tensor(191),m3h8x1(:,11),heltab2x8(:,:,251))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(69),wf8(:,34),G2tensor(192),m3h8x1(:,12),heltab2x8(:,:,252))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(80),wf8(:,36),G2tensor(193),m3h8x1(:,13),heltab2x8(:,:,253))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(74),wf8(:,36),G2tensor(194),m3h8x1(:,14),heltab2x8(:,:,254))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(87),wf8(:,38),G2tensor(195),m3h8x1(:,15),heltab2x8(:,:,255))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(82),wf8(:,38),G2tensor(196),m3h8x1(:,16),heltab2x8(:,:,256))
  call Hloop_VQ_A(ntryL,G1H2(6),ex5(:),G1H1(1),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(197),n2h1(219))
  call Hloop_VQ_A(ntryL,G1H2(17),ex5(:),G1H1(1),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(198),n2h1(220))
  call Hloop_VQ_A(ntryL,G1H2(50),ex5(:),G1H1(1),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(199),n2h1(221))
  call Hloop_VQ_A(ntryL,G1H2(61),ex5(:),G1H1(1),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(200),n2h1(222))
  call Hloop_VQ_A(ntryL,G1H2(72),ex5(:),G1H1(1),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(201),n2h1(223))
  call Hloop_VQ_A(ntryL,G1H2(2),ex5(:),G1H1(1),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(202),n2h1(224))
  call Hloop_VA_Q(ntryL,G1H2(7),ex6(:),G1H1(1),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(203),n2h1(225))
  call Hloop_VA_Q(ntryL,G1H2(8),ex6(:),G1H1(1),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(204),n2h1(226))
  call Hloop_VA_Q(ntryL,G1H2(18),ex6(:),G1H1(1),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(205),n2h1(227))
  call Hloop_VA_Q(ntryL,G1H2(19),ex6(:),G1H1(1),m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(206),n2h1(228))
  call Hloop_VA_Q(ntryL,G1H2(23),ex6(:),G1H1(1),m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(207),n2h1(229))
  call Hloop_VA_Q(ntryL,G1H2(30),ex6(:),G1H1(1),m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(208),n2h1(230))
  call Hloop_VQ_A(ntryL,G1H2(34),ex5(:),G1H1(1),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(209),n2h1(231))
  call Hloop_VQ_A(ntryL,G1H2(35),ex5(:),G1H1(1),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(210),n2h1(232))
  call Hloop_VQ_A(ntryL,G1H2(45),ex5(:),G1H1(1),m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(211),n2h1(233))
  call Hloop_VQ_A(ntryL,G1H2(46),ex5(:),G1H1(1),m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(212),n2h1(234))
  call Hloop_VQ_A(ntryL,G1H2(51),ex5(:),G1H1(1),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(213),n2h1(235))
  call Hloop_VQ_A(ntryL,G1H2(57),ex5(:),G1H1(1),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(214),n2h1(236))
  call Hloop_VA_Q(ntryL,G1H2(62),ex6(:),G1H1(1),m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(215),n2h1(237))
  call Hloop_VA_Q(ntryL,G1H2(63),ex6(:),G1H1(1),m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(216),n2h1(238))
  call Hloop_VA_Q(ntryL,G1H2(73),ex6(:),G1H1(1),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(217),n2h1(239))
  call Hloop_VA_Q(ntryL,G1H2(74),ex6(:),G1H1(1),m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(218),n2h1(240))
  call Hloop_VA_Q(ntryL,G1H2(78),ex6(:),G1H1(1),m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(219),n2h1(241))
  call Hloop_VA_Q(ntryL,G1H2(85),ex6(:),G1H1(1),m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(220),n2h1(242))
  call Hloop_VA_Q(ntryL,G1H2(5),ex6(:),G1H1(1),m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(221),n2h1(243))
  call Hloop_VA_Q(ntryL,G1H2(16),ex6(:),G1H1(1),m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(222),n2h1(244))
  call Hloop_VA_Q(ntryL,G1H2(49),ex6(:),G1H1(1),m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(223),n2h1(245))
  call Hloop_AV_Q(ntryL,G1H4(29),wf4(:,2),G1H1(1),m3h4x1(:,169),heltab2x4(:,:,203))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(224),n2h1(246))
  call Hloop_AV_Q(ntryL,G1H4(40),wf4(:,2),G1H1(1),m3h4x1(:,170),heltab2x4(:,:,204))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(225),n2h1(247))
  call Hloop_AV_Q(ntryL,G1H4(73),wf4(:,2),G1H1(1),m3h4x1(:,171),heltab2x4(:,:,205))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(226),n2h1(248))
  call Hloop_AZ_Q(ntryL,G1H4(84),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,172),heltab2x4(:,:,206))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(227),n2h1(249))
  call Hloop_AZ_Q(ntryL,G1H4(95),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,173),heltab2x4(:,:,207))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(228),n2h1(250))
  call Hloop_AZ_Q(ntryL,G1H4(4),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,174),heltab2x4(:,:,208))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(229),n2h1(251))
  call Hloop_VQ_A(ntryL,G1H2(60),ex5(:),G1H1(1),m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(230),n2h1(252))
  call Hloop_VQ_A(ntryL,G1H2(71),ex5(:),G1H1(1),m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(231),n2h1(253))
  call Hloop_VQ_A(ntryL,G1H2(3),ex5(:),G1H1(1),m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(232),n2h1(254))
  call Hloop_QV_A(ntryL,G1H4(7),wf4(:,2),G1H1(1),m3h4x1(:,175),heltab2x4(:,:,209))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(233),n2h1(255))
  call Hloop_QV_A(ntryL,G1H4(10),wf4(:,2),G1H1(1),m3h4x1(:,176),heltab2x4(:,:,210))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(234),n2h1(256))
  call Hloop_QV_A(ntryL,G1H4(19),wf4(:,2),G1H1(1),m3h4x1(:,177),heltab2x4(:,:,211))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(235),n2h1(257))
  call Hloop_QZ_A(ntryL,G1H4(22),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,178),heltab2x4(:,:,212))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(236),n2h1(258))
  call Hloop_QZ_A(ntryL,G1H4(27),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,179),heltab2x4(:,:,213))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(237),n2h1(259))
  call Hloop_QZ_A(ntryL,G1H4(38),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,180),heltab2x4(:,:,214))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(238),n2h1(260))
  call Hloop_VQ_A(ntryL,G1H2(58),ex5(:),G1H1(1),m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(239),n2h1(261))
  call Hloop_VQ_A(ntryL,G1H2(80),ex5(:),G1H1(1),m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(240),n2h1(262))
  call Hloop_VQ_A(ntryL,G1H2(15),ex5(:),G1H1(1),m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(241),n2h1(263))
  call Hloop_QV_A(ntryL,G1H4(39),wf4(:,11),G1H1(1),m3h4x1(:,181),heltab2x4(:,:,215))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(242),n2h1(264))
  call Hloop_QV_A(ntryL,G1H4(46),wf4(:,11),G1H1(1),m3h4x1(:,182),heltab2x4(:,:,216))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(243),n2h1(265))
  call Hloop_QV_A(ntryL,G1H4(57),wf4(:,11),G1H1(1),m3h4x1(:,183),heltab2x4(:,:,217))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(244),n2h1(266))
  call Hloop_QZ_A(ntryL,G1H4(60),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,184),heltab2x4(:,:,218))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(245),n2h1(267))
  call Hloop_QZ_A(ntryL,G1H4(61),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,185),heltab2x4(:,:,219))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(246),n2h1(268))
  call Hloop_QZ_A(ntryL,G1H4(72),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,186),heltab2x4(:,:,220))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(247),n2h1(269))
  call Hloop_VA_Q(ntryL,G1H2(4),ex6(:),G1H1(1),m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(248),n2h1(270))
  call Hloop_VA_Q(ntryL,G1H2(54),ex6(:),G1H1(1),m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(249),n2h1(271))
  call Hloop_VA_Q(ntryL,G1H2(14),ex6(:),G1H1(1),m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(250),n2h1(272))
  call Hloop_AV_Q(ntryL,G1H4(79),wf4(:,11),G1H1(1),m3h4x1(:,187),heltab2x4(:,:,221))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(251),n2h1(273))
  call Hloop_AV_Q(ntryL,G1H4(82),wf4(:,11),G1H1(1),m3h4x1(:,188),heltab2x4(:,:,222))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,0,G2tensor(252),n2h1(274))
  call Hloop_AV_Q(ntryL,G1H4(93),wf4(:,11),G1H1(1),m3h4x1(:,189),heltab2x4(:,:,223))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(253),n2h1(275))
  call Hloop_AZ_Q(ntryL,G1H4(94),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,190),heltab2x4(:,:,224))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(254),n2h1(276))
  call Hloop_AZ_Q(ntryL,G1H4(101),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,191),heltab2x4(:,:,225))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,0,G2tensor(255),n2h1(277))
  call Hloop_AZ_Q(ntryL,G1H4(112),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,192),heltab2x4(:,:,226))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(256),n2h1(278))
  call Hloop_QV_A(ntryL,G1H4(117),wf4(:,2),G1H1(1),m3h4x1(:,193),heltab2x4(:,:,227))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(257),n2h1(279))
  call Hloop_QV_A(ntryL,G1H4(48),wf4(:,2),G1H1(1),m3h4x1(:,194),heltab2x4(:,:,228))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(258),n2h1(280))
  call Hloop_QV_A(ntryL,G1H4(113),wf4(:,2),G1H1(1),m3h4x1(:,195),heltab2x4(:,:,229))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(259),n2h1(281))
  call Hloop_QZ_A(ntryL,G1H4(114),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,196),heltab2x4(:,:,230))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(260),n2h1(282))
  call Hloop_QZ_A(ntryL,G1H4(115),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,197),heltab2x4(:,:,231))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(261),n2h1(283))
  call Hloop_QZ_A(ntryL,G1H4(125),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,198),heltab2x4(:,:,232))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(262),n2h1(284))
  call Hloop_QV_A(ntryL,G1H4(126),wf4(:,1),G1H1(1),m3h4x1(:,199),heltab2x4(:,:,233))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(263),n2h1(285))
  call Hloop_QV_A(ntryL,G1H4(133),wf4(:,1),G1H1(1),m3h4x1(:,200),heltab2x4(:,:,234))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,0,G2tensor(264),n2h1(286))
  call Hloop_QV_A(ntryL,G1H4(129),wf4(:,1),G1H1(1),m3h4x1(:,201),heltab2x4(:,:,235))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(265),n2h1(287))
  call Hloop_QZ_A(ntryL,G1H4(130),wf4(:,8),G1H1(1),ngZd,m3h4x1(:,202),heltab2x4(:,:,236))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(266),n2h1(288))
  call Hloop_QZ_A(ntryL,G1H4(167),wf4(:,8),G1H1(1),ngZd,m3h4x1(:,203),heltab2x4(:,:,237))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,0,G2tensor(267),n2h1(289))
  call Hloop_QZ_A(ntryL,G1H4(169),wf4(:,8),G1H1(1),ngZd,m3h4x1(:,204),heltab2x4(:,:,238))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(268),n2h1(290))
  call Hloop_QV_A(ntryL,G1H4(163),wf4(:,12),G1H1(1),m3h4x1(:,205),heltab2x4(:,:,239))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(269),n2h1(291))
  call Hloop_QV_A(ntryL,G1H4(164),wf4(:,12),G1H1(1),m3h4x1(:,206),heltab2x4(:,:,240))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),6,0,G2tensor(270),n2h1(292))
  call Hloop_QV_A(ntryL,G1H4(181),wf4(:,12),G1H1(1),m3h4x1(:,207),heltab2x4(:,:,241))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(271),n2h1(293))
  call Hloop_QZ_A(ntryL,G1H4(175),wf4(:,14),G1H1(1),ngZd,m3h4x1(:,208),heltab2x4(:,:,242))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(272),n2h1(294))
  call Hloop_QZ_A(ntryL,G1H4(176),wf4(:,14),G1H1(1),ngZd,m3h4x1(:,209),heltab2x4(:,:,243))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),6,0,G2tensor(273),n2h1(295))
  call Hloop_QZ_A(ntryL,G1H4(178),wf4(:,14),G1H1(1),ngZd,m3h4x1(:,210),heltab2x4(:,:,244))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(274),n2h1(296))
  call Hloop_QV_A(ntryL,G1H4(179),wf4(:,11),G1H1(1),m3h4x1(:,211),heltab2x4(:,:,245))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(275),n2h1(297))
  call Hloop_QV_A(ntryL,G1H4(180),wf4(:,11),G1H1(1),m3h4x1(:,212),heltab2x4(:,:,246))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(276),n2h1(298))
  call Hloop_QV_A(ntryL,G1H4(5),wf4(:,11),G1H1(1),m3h4x1(:,213),heltab2x4(:,:,247))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(277),n2h1(299))
  call Hloop_QZ_A(ntryL,G1H4(6),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,214),heltab2x4(:,:,248))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(278),n2h1(300))
  call Hloop_QZ_A(ntryL,G1H4(8),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,215),heltab2x4(:,:,249))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(279),n2h1(301))
  call Hloop_QZ_A(ntryL,G1H4(12),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,216),heltab2x4(:,:,250))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(280),n2h1(302))
  call Hloop_VQ_A(ntryL,G1H2(81),ex5(:),G1H1(1),m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(281),n2h1(303))
  call Hloop_VQ_A(ntryL,G1H2(70),ex5(:),G1H1(1),m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(282),n2h1(304))
  call Hloop_VQ_A(ntryL,G1H2(76),ex5(:),G1H1(1),m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(283),n2h1(305))
  call Hloop_VQ_A(ntryL,G1H2(43),ex5(:),G1H1(1),m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(284),n2h1(306))
  call Hloop_VQ_A(ntryL,G1H2(32),ex5(:),G1H1(1),m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(285),n2h1(307))
  call Hloop_VQ_A(ntryL,G1H2(69),ex5(:),G1H1(1),m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(286),n2h1(308))
  call Hloop_VA_Q(ntryL,G1H2(9),ex6(:),G1H1(1),m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(287),n2h1(309))
  call Hloop_VA_Q(ntryL,G1H2(65),ex6(:),G1H1(1),m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(288),n2h1(310))
  call Hloop_VA_Q(ntryL,G1H2(22),ex6(:),G1H1(1),m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(289),n2h1(311))
  call Hloop_VA_Q(ntryL,G1H2(31),ex6(:),G1H1(1),m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(290),n2h1(312))
  call Hloop_VA_Q(ntryL,G1H2(87),ex6(:),G1H1(1),m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(291),n2h1(313))
  call Hloop_VA_Q(ntryL,G1H2(90),ex6(:),G1H1(1),m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(292),n2h1(314))
  call Hloop_VQ_A(ntryL,G1H2(42),ex5(:),G1H1(1),m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(293),n2h1(315))
  call Hloop_VQ_A(ntryL,G1H2(44),ex5(:),G1H1(1),m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(294),n2h1(316))
  call Hloop_VQ_A(ntryL,G1H2(93),ex5(:),G1H1(1),m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(295),n2h1(317))
  call Hloop_VA_Q(ntryL,G1H2(53),ex6(:),G1H1(1),m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(296),n2h1(318))
  call Hloop_VA_Q(ntryL,G1H2(55),ex6(:),G1H1(1),m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(297),n2h1(319))
  call Hloop_VA_Q(ntryL,G1H2(94),ex6(:),G1H1(1),m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(298),n2h1(320))
  call Hloop_AV_Q(ntryL,G1H4(14),wf4(:,2),G1H1(1),m3h4x1(:,217),heltab2x4(:,:,251))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(299),n2h1(321))
  call Hloop_AV_Q(ntryL,G1H4(15),wf4(:,2),G1H1(1),m3h4x1(:,218),heltab2x4(:,:,252))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(300),n2h1(322))
  call Hloop_AV_Q(ntryL,G1H4(20),wf4(:,2),G1H1(1),m3h4x1(:,219),heltab2x4(:,:,253))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(301),n2h1(323))
  call Hloop_AV_Q(ntryL,G1H4(21),wf4(:,2),G1H1(1),m3h4x1(:,220),heltab2x4(:,:,254))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(302),n2h1(324))
  call Hloop_AV_Q(ntryL,G1H4(23),wf4(:,2),G1H1(1),m3h4x1(:,221),heltab2x4(:,:,255))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(303),n2h1(325))
  call Hloop_AV_Q(ntryL,G1H4(198),wf4(:,2),G1H1(1),m3h4x1(:,222),heltab2x4(:,:,256))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(304),n2h1(326))
  call Hloop_AZ_Q(ntryL,G1H4(33),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,223),heltab2x4(:,:,257))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(305),n2h1(327))
  call Hloop_AZ_Q(ntryL,G1H4(34),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,224),heltab2x4(:,:,258))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(306),n2h1(328))
  call Hloop_AZ_Q(ntryL,G1H4(201),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,225),heltab2x4(:,:,259))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(307),n2h1(329))
  call Hloop_AZ_Q(ntryL,G1H4(202),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,226),heltab2x4(:,:,260))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(308),n2h1(330))
  call Hloop_AZ_Q(ntryL,G1H4(203),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,227),heltab2x4(:,:,261))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(309),n2h1(331))
  call Hloop_AZ_Q(ntryL,G1H4(206),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,228),heltab2x4(:,:,262))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(310),n2h1(332))
  call Hloop_QV_A(ntryL,G1H4(44),wf4(:,2),G1H1(1),m3h4x1(:,229),heltab2x4(:,:,263))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(311),n2h1(333))
  call Hloop_QV_A(ntryL,G1H4(45),wf4(:,2),G1H1(1),m3h4x1(:,230),heltab2x4(:,:,264))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(312),n2h1(334))
  call Hloop_QV_A(ntryL,G1H4(209),wf4(:,2),G1H1(1),m3h4x1(:,231),heltab2x4(:,:,265))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(313),n2h1(335))
  call Hloop_QV_A(ntryL,G1H4(210),wf4(:,2),G1H1(1),m3h4x1(:,232),heltab2x4(:,:,266))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(314),n2h1(336))
  call Hloop_QV_A(ntryL,G1H4(211),wf4(:,2),G1H1(1),m3h4x1(:,233),heltab2x4(:,:,267))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(315),n2h1(337))
  call Hloop_QV_A(ntryL,G1H4(214),wf4(:,2),G1H1(1),m3h4x1(:,234),heltab2x4(:,:,268))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(316),n2h1(338))
  call Hloop_QZ_A(ntryL,G1H4(55),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,235),heltab2x4(:,:,269))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(317),n2h1(339))
  call Hloop_QZ_A(ntryL,G1H4(56),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,236),heltab2x4(:,:,270))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(318),n2h1(340))
  call Hloop_QZ_A(ntryL,G1H4(217),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,237),heltab2x4(:,:,271))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(319),n2h1(341))
  call Hloop_QZ_A(ntryL,G1H4(218),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,238),heltab2x4(:,:,272))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(320),n2h1(342))
  call Hloop_QZ_A(ntryL,G1H4(219),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,239),heltab2x4(:,:,273))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(321),n2h1(343))
  call Hloop_QZ_A(ntryL,G1H4(222),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,240),heltab2x4(:,:,274))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(322),n2h1(344))
  call Hloop_QV_A(ntryL,G1H4(66),wf4(:,11),G1H1(1),m3h4x1(:,241),heltab2x4(:,:,275))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(323),n2h1(345))
  call Hloop_QV_A(ntryL,G1H4(67),wf4(:,11),G1H1(1),m3h4x1(:,242),heltab2x4(:,:,276))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(324),n2h1(346))
  call Hloop_QV_A(ntryL,G1H4(225),wf4(:,11),G1H1(1),m3h4x1(:,243),heltab2x4(:,:,277))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(325),n2h1(347))
  call Hloop_QV_A(ntryL,G1H4(226),wf4(:,11),G1H1(1),m3h4x1(:,244),heltab2x4(:,:,278))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(326),n2h1(348))
  call Hloop_QV_A(ntryL,G1H4(227),wf4(:,11),G1H1(1),m3h4x1(:,245),heltab2x4(:,:,279))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(327),n2h1(349))
  call Hloop_QV_A(ntryL,G1H4(230),wf4(:,11),G1H1(1),m3h4x1(:,246),heltab2x4(:,:,280))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(328),n2h1(350))
  call Hloop_QZ_A(ntryL,G1H4(77),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,247),heltab2x4(:,:,281))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(329),n2h1(351))
  call Hloop_QZ_A(ntryL,G1H4(78),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,248),heltab2x4(:,:,282))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(330),n2h1(352))
  call Hloop_QZ_A(ntryL,G1H4(233),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,249),heltab2x4(:,:,283))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(331),n2h1(353))
  call Hloop_QZ_A(ntryL,G1H4(234),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,250),heltab2x4(:,:,284))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(332),n2h1(354))
  call Hloop_QZ_A(ntryL,G1H4(235),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,251),heltab2x4(:,:,285))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(333),n2h1(355))
  call Hloop_QZ_A(ntryL,G1H4(238),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,252),heltab2x4(:,:,286))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(334),n2h1(356))
  call Hloop_AV_Q(ntryL,G1H4(88),wf4(:,11),G1H1(1),m3h4x1(:,253),heltab2x4(:,:,287))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(335),n2h1(357))
  call Hloop_AV_Q(ntryL,G1H4(89),wf4(:,11),G1H1(1),m3h4x1(:,254),heltab2x4(:,:,288))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,0,G2tensor(336),n2h1(358))
  call Hloop_AV_Q(ntryL,G1H4(241),wf4(:,11),G1H1(1),m3h4x1(:,255),heltab2x4(:,:,289))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(337),n2h1(359))
  call Hloop_AV_Q(ntryL,G1H4(242),wf4(:,11),G1H1(1),m3h4x1(:,256),heltab2x4(:,:,290))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(338),n2h1(360))
  call Hloop_AV_Q(ntryL,G1H4(243),wf4(:,11),G1H1(1),m3h4x1(:,257),heltab2x4(:,:,291))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,0,G2tensor(339),n2h1(361))
  call Hloop_AV_Q(ntryL,G1H4(246),wf4(:,11),G1H1(1),m3h4x1(:,258),heltab2x4(:,:,292))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(340),n2h1(362))
  call Hloop_AZ_Q(ntryL,G1H4(99),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,259),heltab2x4(:,:,293))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(341),n2h1(363))
  call Hloop_AZ_Q(ntryL,G1H4(100),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,260),heltab2x4(:,:,294))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,0,G2tensor(342),n2h1(364))
  call Hloop_AZ_Q(ntryL,G1H4(249),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,261),heltab2x4(:,:,295))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(343),n2h1(365))
  call Hloop_AZ_Q(ntryL,G1H4(250),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,262),heltab2x4(:,:,296))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(344),n2h1(366))
  call Hloop_AZ_Q(ntryL,G1H4(251),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,263),heltab2x4(:,:,297))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,0,G2tensor(345),n2h1(367))
  call Hloop_AZ_Q(ntryL,G1H4(254),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,264),heltab2x4(:,:,298))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(346),n2h1(368))
  call Hloop_VQ_A(ntryL,G1H8(153),wf8(:,10),G1H1(1),m3h8x1(:,17),heltab2x8(:,:,257))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(347),n2h1(369))
  call Hloop_VQ_A(ntryL,G1H8(154),wf8(:,10),G1H1(1),m3h8x1(:,18),heltab2x8(:,:,258))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),21,0,G2tensor(348),n2h1(370))
  call Hloop_VQ_A(ntryL,G1H8(169),wf8(:,10),G1H1(1),m3h8x1(:,19),heltab2x8(:,:,259))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(349),n2h1(371))
  call Hloop_VQ_A(ntryL,G1H8(170),wf8(:,12),G1H1(1),m3h8x1(:,20),heltab2x8(:,:,260))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(350),n2h1(372))
  call Hloop_VQ_A(ntryL,G1H8(174),wf8(:,12),G1H1(1),m3h8x1(:,21),heltab2x8(:,:,261))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),21,0,G2tensor(351),n2h1(373))
  call Hloop_VQ_A(ntryL,G1H8(50),wf8(:,12),G1H1(1),m3h8x1(:,22),heltab2x8(:,:,262))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(352),n2h1(374))
  call Hloop_VA_Q(ntryL,G1H8(60),wf8(:,2),G1H1(1),m3h8x1(:,23),heltab2x8(:,:,263))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(353),n2h1(375))
  call Hloop_VA_Q(ntryL,G1H8(56),wf8(:,2),G1H1(1),m3h8x1(:,24),heltab2x8(:,:,264))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),37,0,G2tensor(354),n2h1(376))
  call Hloop_VA_Q(ntryL,G1H8(65),wf8(:,2),G1H1(1),m3h8x1(:,25),heltab2x8(:,:,265))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(355),n2h1(377))
  call Hloop_VA_Q(ntryL,G1H8(66),wf8(:,4),G1H1(1),m3h8x1(:,26),heltab2x8(:,:,266))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(356),n2h1(378))
  call Hloop_VA_Q(ntryL,G1H8(71),wf8(:,4),G1H1(1),m3h8x1(:,27),heltab2x8(:,:,267))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),37,0,G2tensor(357),n2h1(379))
  call Hloop_VA_Q(ntryL,G1H8(77),wf8(:,4),G1H1(1),m3h8x1(:,28),heltab2x8(:,:,268))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(358),n2h1(380))
  call Hloop_VQ_A(ntryL,G1H8(80),wf8(:,14),G1H1(1),m3h8x1(:,29),heltab2x8(:,:,269))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(359),n2h1(381))
  call Hloop_VQ_A(ntryL,G1H8(81),wf8(:,14),G1H1(1),m3h8x1(:,30),heltab2x8(:,:,270))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),26,0,G2tensor(360),n2h1(382))
  call Hloop_VQ_A(ntryL,G1H8(88),wf8(:,14),G1H1(1),m3h8x1(:,31),heltab2x8(:,:,271))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(361),n2h1(383))
  call Hloop_VQ_A(ntryL,G1H8(91),wf8(:,16),G1H1(1),m3h8x1(:,32),heltab2x8(:,:,272))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(362),n2h1(384))
  call Hloop_VQ_A(ntryL,G1H8(96),wf8(:,16),G1H1(1),m3h8x1(:,33),heltab2x8(:,:,273))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),26,0,G2tensor(363),n2h1(385))
  call Hloop_VQ_A(ntryL,G1H8(103),wf8(:,16),G1H1(1),m3h8x1(:,34),heltab2x8(:,:,274))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(364),n2h1(386))
  call Hloop_VA_Q(ntryL,G1H8(104),wf8(:,6),G1H1(1),m3h8x1(:,35),heltab2x8(:,:,275))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(365),n2h1(387))
  call Hloop_VA_Q(ntryL,G1H8(107),wf8(:,6),G1H1(1),m3h8x1(:,36),heltab2x8(:,:,276))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),42,0,G2tensor(366),n2h1(388))
  call Hloop_VA_Q(ntryL,G1H8(114),wf8(:,6),G1H1(1),m3h8x1(:,37),heltab2x8(:,:,277))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(367),n2h1(389))
  call Hloop_VA_Q(ntryL,G1H8(119),wf8(:,8),G1H1(1),m3h8x1(:,38),heltab2x8(:,:,278))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(368),n2h1(390))
  call Hloop_VA_Q(ntryL,G1H8(124),wf8(:,8),G1H1(1),m3h8x1(:,39),heltab2x8(:,:,279))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),42,0,G2tensor(369),n2h1(391))
  call Hloop_VA_Q(ntryL,G1H8(128),wf8(:,8),G1H1(1),m3h8x1(:,40),heltab2x8(:,:,280))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(370),n2h1(392))
  call Hloop_VQ_A(ntryL,G1H8(129),wf8(:,40),G1H1(1),m3h8x1(:,41),heltab2x8(:,:,281))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(371),n2h1(393))
  call Hloop_VQ_A(ntryL,G1H8(130),wf8(:,40),G1H1(1),m3h8x1(:,42),heltab2x8(:,:,282))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),25,0,G2tensor(372),n2h1(394))
  call Hloop_VQ_A(ntryL,G1H8(139),wf8(:,40),G1H1(1),m3h8x1(:,43),heltab2x8(:,:,283))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(373),n2h1(395))
  call Hloop_VQ_A(ntryL,G1H8(141),wf8(:,42),G1H1(1),m3h8x1(:,44),heltab2x8(:,:,284))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(374),n2h1(396))
  call Hloop_VQ_A(ntryL,G1H8(145),wf8(:,42),G1H1(1),m3h8x1(:,45),heltab2x8(:,:,285))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),25,0,G2tensor(375),n2h1(397))
  call Hloop_VQ_A(ntryL,G1H8(156),wf8(:,42),G1H1(1),m3h8x1(:,46),heltab2x8(:,:,286))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(376),n2h1(398))
  call Hloop_VA_Q(ntryL,G1H8(155),wf8(:,32),G1H1(1),m3h8x1(:,47),heltab2x8(:,:,287))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(377),n2h1(399))
  call Hloop_VA_Q(ntryL,G1H8(157),wf8(:,32),G1H1(1),m3h8x1(:,48),heltab2x8(:,:,288))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),41,0,G2tensor(378),n2h1(400))
  call Hloop_VA_Q(ntryL,G1H8(167),wf8(:,32),G1H1(1),m3h8x1(:,49),heltab2x8(:,:,289))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(379),n2h1(401))
  call Hloop_VA_Q(ntryL,G1H8(172),wf8(:,34),G1H1(1),m3h8x1(:,50),heltab2x8(:,:,290))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(380),n2h1(402))
  call Hloop_VA_Q(ntryL,G1H8(168),wf8(:,34),G1H1(1),m3h8x1(:,51),heltab2x8(:,:,291))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),41,0,G2tensor(381),n2h1(403))
  call Hloop_VA_Q(ntryL,G1H8(53),wf8(:,34),G1H1(1),m3h8x1(:,52),heltab2x8(:,:,292))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(382),n2h1(404))
  call Hloop_VQ_A(ntryL,G1H8(54),wf8(:,44),G1H1(1),m3h8x1(:,53),heltab2x8(:,:,293))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(383),n2h1(405))
  call Hloop_VQ_A(ntryL,G1H8(69),wf8(:,44),G1H1(1),m3h8x1(:,54),heltab2x8(:,:,294))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),22,0,G2tensor(384),n2h1(406))
  call Hloop_VQ_A(ntryL,G1H8(101),wf8(:,44),G1H1(1),m3h8x1(:,55),heltab2x8(:,:,295))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(385),n2h1(407))
  call Hloop_VQ_A(ntryL,G1H8(102),wf8(:,46),G1H1(1),m3h8x1(:,56),heltab2x8(:,:,296))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(386),n2h1(408))
  call Hloop_VQ_A(ntryL,G1H8(118),wf8(:,46),G1H1(1),m3h8x1(:,57),heltab2x8(:,:,297))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),22,0,G2tensor(387),n2h1(409))
  call Hloop_VQ_A(ntryL,G1H8(149),wf8(:,46),G1H1(1),m3h8x1(:,58),heltab2x8(:,:,298))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(388),n2h1(410))
  call Hloop_VA_Q(ntryL,G1H8(165),wf8(:,36),G1H1(1),m3h8x1(:,59),heltab2x8(:,:,299))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(389),n2h1(411))
  call Hloop_VA_Q(ntryL,G1H8(166),wf8(:,36),G1H1(1),m3h8x1(:,60),heltab2x8(:,:,300))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),38,0,G2tensor(390),n2h1(412))
  call Hloop_VA_Q(ntryL,G1H8(6),wf8(:,36),G1H1(1),m3h8x1(:,61),heltab2x8(:,:,301))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(391),n2h1(413))
  call Hloop_VA_Q(ntryL,G1H8(7),wf8(:,38),G1H1(1),m3h8x1(:,62),heltab2x8(:,:,302))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(392),n2h1(414))
  call Hloop_VA_Q(ntryL,G1H8(8),wf8(:,38),G1H1(1),m3h8x1(:,63),heltab2x8(:,:,303))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),38,0,G2tensor(393),n2h1(415))
  call Hloop_VA_Q(ntryL,G1H8(14),wf8(:,38),G1H1(1),m3h8x1(:,64),heltab2x8(:,:,304))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(394),n2h1(416))
  call Hloop_AV_Q(ntryL,G1H4(110),wf4(:,2),G1H1(1),m3h4x1(:,265),heltab2x4(:,:,299))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(395),n2h1(417))
  call Hloop_AV_Q(ntryL,G1H4(111),wf4(:,2),G1H1(1),m3h4x1(:,266),heltab2x4(:,:,300))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMT,G2tensor(396),n2h1(418))
  call Hloop_AV_Q(ntryL,G1H4(256),wf4(:,2),G1H1(1),m3h4x1(:,267),heltab2x4(:,:,301))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(397),n2h1(419))
  call Hloop_QV_A(ntryL,G1H4(65),wf4(:,2),G1H1(1),m3h4x1(:,268),heltab2x4(:,:,302))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(398),n2h1(420))
  call Hloop_QV_A(ntryL,G1H4(76),wf4(:,2),G1H1(1),m3h4x1(:,269),heltab2x4(:,:,303))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,nMT,G2tensor(399),n2h1(421))
  call Hloop_QV_A(ntryL,G1H4(259),wf4(:,2),G1H1(1),m3h4x1(:,270),heltab2x4(:,:,304))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(400),n2h1(422))
  call Hloop_AV_Q(ntryL,G1H4(87),wf4(:,2),G1H1(1),m3h4x1(:,271),heltab2x4(:,:,305))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(401),n2h1(423))
  call Hloop_AV_Q(ntryL,G1H4(260),wf4(:,2),G1H1(1),m3h4x1(:,272),heltab2x4(:,:,306))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(402),n2h1(424))
  call Hloop_AV_Q(ntryL,G1H4(263),wf4(:,2),G1H1(1),m3h4x1(:,273),heltab2x4(:,:,307))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(403),n2h1(425))
  call Hloop_QV_A(ntryL,G1H4(58),wf4(:,2),G1H1(1),m3h4x1(:,274),heltab2x4(:,:,308))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(404),n2h1(426))
  call Hloop_QV_A(ntryL,G1H4(264),wf4(:,2),G1H1(1),m3h4x1(:,275),heltab2x4(:,:,309))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(405),n2h1(427))
  call Hloop_QV_A(ntryL,G1H4(267),wf4(:,2),G1H1(1),m3h4x1(:,276),heltab2x4(:,:,310))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(406),n2h1(428))
  call Hloop_AZ_Q(ntryL,G1H4(70),wf4(:,6),G1H1(1),ngZu,m3h4x1(:,277),heltab2x4(:,:,311))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(407),n2h1(429))
  call Hloop_AZ_Q(ntryL,G1H4(268),wf4(:,6),G1H1(1),ngZu,m3h4x1(:,278),heltab2x4(:,:,312))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(408),n2h1(430))
  call Hloop_AZ_Q(ntryL,G1H4(271),wf4(:,6),G1H1(1),ngZu,m3h4x1(:,279),heltab2x4(:,:,313))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(409),n2h1(431))
  call Hloop_AZ_Q(ntryL,G1H4(86),wf4(:,6),G1H1(1),ngZu,m3h4x1(:,280),heltab2x4(:,:,314))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(410),n2h1(432))
  call Hloop_AZ_Q(ntryL,G1H4(272),wf4(:,6),G1H1(1),ngZu,m3h4x1(:,281),heltab2x4(:,:,315))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMT,G2tensor(411),n2h1(433))
  call Hloop_AZ_Q(ntryL,G1H4(275),wf4(:,6),G1H1(1),ngZu,m3h4x1(:,282),heltab2x4(:,:,316))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(412),n2h1(434))
  call Hloop_QZ_A(ntryL,G1H4(59),wf4(:,6),G1H1(1),ngZu,m3h4x1(:,283),heltab2x4(:,:,317))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(413),n2h1(435))
  call Hloop_QZ_A(ntryL,G1H4(276),wf4(:,6),G1H1(1),ngZu,m3h4x1(:,284),heltab2x4(:,:,318))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(414),n2h1(436))
  call Hloop_QZ_A(ntryL,G1H4(279),wf4(:,6),G1H1(1),ngZu,m3h4x1(:,285),heltab2x4(:,:,319))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(415),n2h1(437))
  call Hloop_QZ_A(ntryL,G1H4(80),wf4(:,6),G1H1(1),ngZu,m3h4x1(:,286),heltab2x4(:,:,320))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(416),n2h1(438))
  call Hloop_QZ_A(ntryL,G1H4(280),wf4(:,6),G1H1(1),ngZu,m3h4x1(:,287),heltab2x4(:,:,321))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,nMT,G2tensor(417),n2h1(439))
  call Hloop_QZ_A(ntryL,G1H4(283),wf4(:,6),G1H1(1),ngZu,m3h4x1(:,288),heltab2x4(:,:,322))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(418),n2h1(440))
  call Hloop_AZ_Q(ntryL,G1H4(53),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,289),heltab2x4(:,:,323))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(419),n2h1(441))
  call Hloop_AZ_Q(ntryL,G1H4(81),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,290),heltab2x4(:,:,324))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(420),n2h1(442))
  call Hloop_AZ_Q(ntryL,G1H4(286),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,291),heltab2x4(:,:,325))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(421),n2h1(443))
  call Hloop_QZ_A(ntryL,G1H4(69),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,292),heltab2x4(:,:,326))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(422),n2h1(444))
  call Hloop_QZ_A(ntryL,G1H4(64),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,293),heltab2x4(:,:,327))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(423),n2h1(445))
  call Hloop_QZ_A(ntryL,G1H4(289),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,294),heltab2x4(:,:,328))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(424),n2h1(446))
  call Hloop_AV_Q(ntryL,G1H4(75),wf4(:,17),G1H1(1),m3h4x1(:,295),heltab2x4(:,:,329))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(425),n2h1(447))
  call Hloop_AV_Q(ntryL,G1H4(290),wf4(:,17),G1H1(1),m3h4x1(:,296),heltab2x4(:,:,330))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,0,G2tensor(426),n2h1(448))
  call Hloop_AV_Q(ntryL,G1H4(293),wf4(:,17),G1H1(1),m3h4x1(:,297),heltab2x4(:,:,331))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(427),n2h1(449))
  call Hloop_AV_Q(ntryL,G1H4(121),wf4(:,17),G1H1(1),m3h4x1(:,298),heltab2x4(:,:,332))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(428),n2h1(450))
  call Hloop_AV_Q(ntryL,G1H4(294),wf4(:,17),G1H1(1),m3h4x1(:,299),heltab2x4(:,:,333))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,nMT,G2tensor(429),n2h1(451))
  call Hloop_AV_Q(ntryL,G1H4(297),wf4(:,17),G1H1(1),m3h4x1(:,300),heltab2x4(:,:,334))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(430),n2h1(452))
  call Hloop_QV_A(ntryL,G1H4(118),wf4(:,17),G1H1(1),m3h4x1(:,301),heltab2x4(:,:,335))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(431),n2h1(453))
  call Hloop_QV_A(ntryL,G1H4(298),wf4(:,17),G1H1(1),m3h4x1(:,302),heltab2x4(:,:,336))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,0,G2tensor(432),n2h1(454))
  call Hloop_QV_A(ntryL,G1H4(301),wf4(:,17),G1H1(1),m3h4x1(:,303),heltab2x4(:,:,337))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(433),n2h1(455))
  call Hloop_QV_A(ntryL,G1H4(123),wf4(:,17),G1H1(1),m3h4x1(:,304),heltab2x4(:,:,338))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(434),n2h1(456))
  call Hloop_QV_A(ntryL,G1H4(302),wf4(:,17),G1H1(1),m3h4x1(:,305),heltab2x4(:,:,339))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,nMT,G2tensor(435),n2h1(457))
  call Hloop_QV_A(ntryL,G1H4(305),wf4(:,17),G1H1(1),m3h4x1(:,306),heltab2x4(:,:,340))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(436),n2h1(458))
  call Hloop_AV_Q(ntryL,G1H4(120),wf4(:,17),G1H1(1),m3h4x1(:,307),heltab2x4(:,:,341))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(437),n2h1(459))
  call Hloop_AV_Q(ntryL,G1H4(306),wf4(:,17),G1H1(1),m3h4x1(:,308),heltab2x4(:,:,342))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,nMB,G2tensor(438),n2h1(460))
  call Hloop_AV_Q(ntryL,G1H4(309),wf4(:,17),G1H1(1),m3h4x1(:,309),heltab2x4(:,:,343))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(439),n2h1(461))
  call Hloop_QV_A(ntryL,G1H4(122),wf4(:,17),G1H1(1),m3h4x1(:,310),heltab2x4(:,:,344))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(440),n2h1(462))
  call Hloop_QV_A(ntryL,G1H4(310),wf4(:,17),G1H1(1),m3h4x1(:,311),heltab2x4(:,:,345))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,nMB,G2tensor(441),n2h1(463))
  call Hloop_QV_A(ntryL,G1H4(313),wf4(:,17),G1H1(1),m3h4x1(:,312),heltab2x4(:,:,346))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(442),n2h1(464))
  call Hloop_AV_Q(ntryL,G1H4(124),wf4(:,17),G1H1(1),m3h4x1(:,313),heltab2x4(:,:,347))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(443),n2h1(465))
  call Hloop_AV_Q(ntryL,G1H4(314),wf4(:,17),G1H1(1),m3h4x1(:,314),heltab2x4(:,:,348))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,0,G2tensor(444),n2h1(466))
  call Hloop_AV_Q(ntryL,G1H4(317),wf4(:,17),G1H1(1),m3h4x1(:,315),heltab2x4(:,:,349))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(445),n2h1(467))
  call Hloop_AV_Q(ntryL,G1H4(135),wf4(:,17),G1H1(1),m3h4x1(:,316),heltab2x4(:,:,350))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(446),n2h1(468))
  call Hloop_AV_Q(ntryL,G1H4(318),wf4(:,17),G1H1(1),m3h4x1(:,317),heltab2x4(:,:,351))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,nMT,G2tensor(447),n2h1(469))
  call Hloop_AV_Q(ntryL,G1H4(321),wf4(:,17),G1H1(1),m3h4x1(:,318),heltab2x4(:,:,352))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(448),n2h1(470))
  call Hloop_QV_A(ntryL,G1H4(132),wf4(:,17),G1H1(1),m3h4x1(:,319),heltab2x4(:,:,353))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(449),n2h1(471))
  call Hloop_QV_A(ntryL,G1H4(322),wf4(:,17),G1H1(1),m3h4x1(:,320),heltab2x4(:,:,354))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,0,G2tensor(450),n2h1(472))
  call Hloop_QV_A(ntryL,G1H4(325),wf4(:,17),G1H1(1),m3h4x1(:,321),heltab2x4(:,:,355))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(451),n2h1(473))
  call Hloop_QV_A(ntryL,G1H4(137),wf4(:,17),G1H1(1),m3h4x1(:,322),heltab2x4(:,:,356))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(452),n2h1(474))
  call Hloop_QV_A(ntryL,G1H4(326),wf4(:,17),G1H1(1),m3h4x1(:,323),heltab2x4(:,:,357))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,nMT,G2tensor(453),n2h1(475))
  call Hloop_QV_A(ntryL,G1H4(329),wf4(:,17),G1H1(1),m3h4x1(:,324),heltab2x4(:,:,358))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(454),n2h1(476))
  call Hloop_AV_Q(ntryL,G1H4(134),wf4(:,17),G1H1(1),m3h4x1(:,325),heltab2x4(:,:,359))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(455),n2h1(477))
  call Hloop_AV_Q(ntryL,G1H4(330),wf4(:,17),G1H1(1),m3h4x1(:,326),heltab2x4(:,:,360))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,nMB,G2tensor(456),n2h1(478))
  call Hloop_AV_Q(ntryL,G1H4(333),wf4(:,17),G1H1(1),m3h4x1(:,327),heltab2x4(:,:,361))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(457),n2h1(479))
  call Hloop_QV_A(ntryL,G1H4(136),wf4(:,17),G1H1(1),m3h4x1(:,328),heltab2x4(:,:,362))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(458),n2h1(480))
  call Hloop_QV_A(ntryL,G1H4(334),wf4(:,17),G1H1(1),m3h4x1(:,329),heltab2x4(:,:,363))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,nMB,G2tensor(459),n2h1(481))
  call Hloop_QV_A(ntryL,G1H4(337),wf4(:,17),G1H1(1),m3h4x1(:,330),heltab2x4(:,:,364))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(460),n2h1(482))
  call Hloop_QV_A(ntryL,G1H4(138),wf4(:,11),G1H1(1),m3h4x1(:,331),heltab2x4(:,:,365))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(461),n2h1(483))
  call Hloop_QV_A(ntryL,G1H4(147),wf4(:,11),G1H1(1),m3h4x1(:,332),heltab2x4(:,:,366))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(462),n2h1(484))
  call Hloop_QV_A(ntryL,G1H4(340),wf4(:,11),G1H1(1),m3h4x1(:,333),heltab2x4(:,:,367))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(463),n2h1(485))
  call Hloop_AV_Q(ntryL,G1H4(148),wf4(:,11),G1H1(1),m3h4x1(:,334),heltab2x4(:,:,368))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(464),n2h1(486))
  call Hloop_AV_Q(ntryL,G1H4(149),wf4(:,11),G1H1(1),m3h4x1(:,335),heltab2x4(:,:,369))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(465),n2h1(487))
  call Hloop_AV_Q(ntryL,G1H4(343),wf4(:,11),G1H1(1),m3h4x1(:,336),heltab2x4(:,:,370))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(466),n2h1(488))
  call Hloop_QV_A(ntryL,G1H4(150),wf4(:,11),G1H1(1),m3h4x1(:,337),heltab2x4(:,:,371))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(467),n2h1(489))
  call Hloop_QV_A(ntryL,G1H4(344),wf4(:,11),G1H1(1),m3h4x1(:,338),heltab2x4(:,:,372))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(468),n2h1(490))
  call Hloop_QV_A(ntryL,G1H4(347),wf4(:,11),G1H1(1),m3h4x1(:,339),heltab2x4(:,:,373))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(469),n2h1(491))
  call Hloop_AV_Q(ntryL,G1H4(151),wf4(:,11),G1H1(1),m3h4x1(:,340),heltab2x4(:,:,374))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(470),n2h1(492))
  call Hloop_AV_Q(ntryL,G1H4(348),wf4(:,11),G1H1(1),m3h4x1(:,341),heltab2x4(:,:,375))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(471),n2h1(493))
  call Hloop_AV_Q(ntryL,G1H4(351),wf4(:,11),G1H1(1),m3h4x1(:,342),heltab2x4(:,:,376))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(472),n2h1(494))
  call Hloop_QZ_A(ntryL,G1H4(152),wf4(:,16),G1H1(1),ngZu,m3h4x1(:,343),heltab2x4(:,:,377))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(473),n2h1(495))
  call Hloop_QZ_A(ntryL,G1H4(352),wf4(:,16),G1H1(1),ngZu,m3h4x1(:,344),heltab2x4(:,:,378))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(474),n2h1(496))
  call Hloop_QZ_A(ntryL,G1H4(355),wf4(:,16),G1H1(1),ngZu,m3h4x1(:,345),heltab2x4(:,:,379))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(475),n2h1(497))
  call Hloop_QZ_A(ntryL,G1H4(153),wf4(:,16),G1H1(1),ngZu,m3h4x1(:,346),heltab2x4(:,:,380))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(476),n2h1(498))
  call Hloop_QZ_A(ntryL,G1H4(356),wf4(:,16),G1H1(1),ngZu,m3h4x1(:,347),heltab2x4(:,:,381))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(477),n2h1(499))
  call Hloop_QZ_A(ntryL,G1H4(359),wf4(:,16),G1H1(1),ngZu,m3h4x1(:,348),heltab2x4(:,:,382))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(478),n2h1(500))
  call Hloop_AZ_Q(ntryL,G1H4(154),wf4(:,16),G1H1(1),ngZu,m3h4x1(:,349),heltab2x4(:,:,383))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(479),n2h1(501))
  call Hloop_AZ_Q(ntryL,G1H4(360),wf4(:,16),G1H1(1),ngZu,m3h4x1(:,350),heltab2x4(:,:,384))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,0,G2tensor(480),n2h1(502))
  call Hloop_AZ_Q(ntryL,G1H4(363),wf4(:,16),G1H1(1),ngZu,m3h4x1(:,351),heltab2x4(:,:,385))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(481),n2h1(503))
  call Hloop_AZ_Q(ntryL,G1H4(155),wf4(:,16),G1H1(1),ngZu,m3h4x1(:,352),heltab2x4(:,:,386))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(482),n2h1(504))
  call Hloop_AZ_Q(ntryL,G1H4(364),wf4(:,16),G1H1(1),ngZu,m3h4x1(:,353),heltab2x4(:,:,387))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(483),n2h1(505))
  call Hloop_AZ_Q(ntryL,G1H4(367),wf4(:,16),G1H1(1),ngZu,m3h4x1(:,354),heltab2x4(:,:,388))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(484),n2h1(506))
  call Hloop_QZ_A(ntryL,G1H4(156),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,355),heltab2x4(:,:,389))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(485),n2h1(507))
  call Hloop_QZ_A(ntryL,G1H4(157),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,356),heltab2x4(:,:,390))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(486),n2h1(508))
  call Hloop_QZ_A(ntryL,G1H4(370),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,357),heltab2x4(:,:,391))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(487),n2h1(509))
  call Hloop_AZ_Q(ntryL,G1H4(158),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,358),heltab2x4(:,:,392))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(488),n2h1(510))
  call Hloop_AZ_Q(ntryL,G1H4(159),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,359),heltab2x4(:,:,393))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(489),n2h1(511))
  call Hloop_AZ_Q(ntryL,G1H4(373),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,360),heltab2x4(:,:,394))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(490),n2h1(512))
  call Hloop_AV_Q(ntryL,G1H4(160),wf4(:,17),G1H1(1),m3h4x1(:,361),heltab2x4(:,:,395))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(491),n2h1(513))
  call Hloop_AV_Q(ntryL,G1H4(374),wf4(:,17),G1H1(1),m3h4x1(:,362),heltab2x4(:,:,396))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,0,G2tensor(492),n2h1(514))
  call Hloop_AV_Q(ntryL,G1H4(377),wf4(:,17),G1H1(1),m3h4x1(:,363),heltab2x4(:,:,397))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(493),n2h1(515))
  call Hloop_AV_Q(ntryL,G1H4(171),wf4(:,17),G1H1(1),m3h4x1(:,364),heltab2x4(:,:,398))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(494),n2h1(516))
  call Hloop_AV_Q(ntryL,G1H4(378),wf4(:,17),G1H1(1),m3h4x1(:,365),heltab2x4(:,:,399))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,nMT,G2tensor(495),n2h1(517))
  call Hloop_AV_Q(ntryL,G1H4(381),wf4(:,17),G1H1(1),m3h4x1(:,366),heltab2x4(:,:,400))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(496),n2h1(518))
  call Hloop_QV_A(ntryL,G1H4(168),wf4(:,17),G1H1(1),m3h4x1(:,367),heltab2x4(:,:,401))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(497),n2h1(519))
  call Hloop_QV_A(ntryL,G1H4(382),wf4(:,17),G1H1(1),m3h4x1(:,368),heltab2x4(:,:,402))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,0,G2tensor(498),n2h1(520))
  call Hloop_QV_A(ntryL,G1H4(385),wf4(:,17),G1H1(1),m3h4x1(:,369),heltab2x4(:,:,403))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(499),n2h1(521))
  call Hloop_QV_A(ntryL,G1H4(173),wf4(:,17),G1H1(1),m3h4x1(:,370),heltab2x4(:,:,404))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(500),n2h1(522))
  call Hloop_QV_A(ntryL,G1H4(386),wf4(:,17),G1H1(1),m3h4x1(:,371),heltab2x4(:,:,405))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,nMT,G2tensor(501),n2h1(523))
  call Hloop_QV_A(ntryL,G1H4(389),wf4(:,17),G1H1(1),m3h4x1(:,372),heltab2x4(:,:,406))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(502),n2h1(524))
  call Hloop_AV_Q(ntryL,G1H4(170),wf4(:,17),G1H1(1),m3h4x1(:,373),heltab2x4(:,:,407))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(503),n2h1(525))
  call Hloop_AV_Q(ntryL,G1H4(390),wf4(:,17),G1H1(1),m3h4x1(:,374),heltab2x4(:,:,408))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,nMB,G2tensor(504),n2h1(526))
  call Hloop_AV_Q(ntryL,G1H4(393),wf4(:,17),G1H1(1),m3h4x1(:,375),heltab2x4(:,:,409))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(505),n2h1(527))
  call Hloop_QV_A(ntryL,G1H4(172),wf4(:,17),G1H1(1),m3h4x1(:,376),heltab2x4(:,:,410))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(506),n2h1(528))
  call Hloop_QV_A(ntryL,G1H4(394),wf4(:,17),G1H1(1),m3h4x1(:,377),heltab2x4(:,:,411))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,nMB,G2tensor(507),n2h1(529))
  call Hloop_QV_A(ntryL,G1H4(397),wf4(:,17),G1H1(1),m3h4x1(:,378),heltab2x4(:,:,412))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(508),n2h1(530))
  call Hloop_AV_Q(ntryL,G1H4(174),wf4(:,17),G1H1(1),m3h4x1(:,379),heltab2x4(:,:,413))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(509),n2h1(531))
  call Hloop_AV_Q(ntryL,G1H4(398),wf4(:,17),G1H1(1),m3h4x1(:,380),heltab2x4(:,:,414))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,0,G2tensor(510),n2h1(532))
  call Hloop_AV_Q(ntryL,G1H4(401),wf4(:,17),G1H1(1),m3h4x1(:,381),heltab2x4(:,:,415))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(511),n2h1(533))
  call Hloop_AV_Q(ntryL,G1H4(185),wf4(:,17),G1H1(1),m3h4x1(:,382),heltab2x4(:,:,416))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(512),n2h1(534))
  call Hloop_AV_Q(ntryL,G1H4(402),wf4(:,17),G1H1(1),m3h4x1(:,383),heltab2x4(:,:,417))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,nMT,G2tensor(513),n2h1(535))
  call Hloop_AV_Q(ntryL,G1H4(405),wf4(:,17),G1H1(1),m3h4x1(:,384),heltab2x4(:,:,418))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(514),n2h1(536))
  call Hloop_QV_A(ntryL,G1H4(182),wf4(:,17),G1H1(1),m3h4x1(:,385),heltab2x4(:,:,419))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(515),n2h1(537))
  call Hloop_QV_A(ntryL,G1H4(406),wf4(:,17),G1H1(1),m3h4x1(:,386),heltab2x4(:,:,420))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,0,G2tensor(516),n2h1(538))
  call Hloop_QV_A(ntryL,G1H4(409),wf4(:,17),G1H1(1),m3h4x1(:,387),heltab2x4(:,:,421))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(517),n2h1(539))
  call Hloop_QV_A(ntryL,G1H4(187),wf4(:,17),G1H1(1),m3h4x1(:,388),heltab2x4(:,:,422))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(518),n2h1(540))
  call Hloop_QV_A(ntryL,G1H4(410),wf4(:,17),G1H1(1),m3h4x1(:,389),heltab2x4(:,:,423))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,nMT,G2tensor(519),n2h1(541))
  call Hloop_QV_A(ntryL,G1H4(413),wf4(:,17),G1H1(1),m3h4x1(:,390),heltab2x4(:,:,424))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(520),n2h1(542))
  call Hloop_AV_Q(ntryL,G1H4(184),wf4(:,17),G1H1(1),m3h4x1(:,391),heltab2x4(:,:,425))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(521),n2h1(543))
  call Hloop_AV_Q(ntryL,G1H4(414),wf4(:,17),G1H1(1),m3h4x1(:,392),heltab2x4(:,:,426))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,nMB,G2tensor(522),n2h1(544))
  call Hloop_AV_Q(ntryL,G1H4(417),wf4(:,17),G1H1(1),m3h4x1(:,393),heltab2x4(:,:,427))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(523),n2h1(545))
  call Hloop_QV_A(ntryL,G1H4(186),wf4(:,17),G1H1(1),m3h4x1(:,394),heltab2x4(:,:,428))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(524),n2h1(546))
  call Hloop_QV_A(ntryL,G1H4(418),wf4(:,17),G1H1(1),m3h4x1(:,395),heltab2x4(:,:,429))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,nMB,G2tensor(525),n2h1(547))
  call Hloop_QV_A(ntryL,G1H4(421),wf4(:,17),G1H1(1),m3h4x1(:,396),heltab2x4(:,:,430))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(526),n2h1(548))
  call ol_merge_tensors(G2tensor(161),[G2tensor(159),G2tensor(2),G1tensor(6)])
  call ol_merge_tensors(G2tensor(157),[G2tensor(155),G2tensor(4),G1tensor(12)])
  call ol_merge_tensors(G2tensor(195),[G2tensor(193),G2tensor(6),G1tensor(18)])
  call ol_merge_tensors(G2tensor(191),[G2tensor(189),G2tensor(8),G1tensor(24)])
  call ol_merge_tensors(G2tensor(113),[G2tensor(10),G1tensor(26),G1tensor(9)])
  call ol_merge_tensors(G2tensor(449),[G2tensor(443),G2tensor(19),G2tensor(11),G1tensor(42),G1tensor(30)])
  call ol_merge_tensors(G2tensor(114),[G2tensor(14),G1tensor(32),G1tensor(3)])
  call ol_merge_tensors(G2tensor(431),[G2tensor(425),G2tensor(23),G2tensor(15),G1tensor(48),G1tensor(36)])
  call ol_merge_tensors(G2tensor(115),[G2tensor(18),G1tensor(38)])
  call ol_merge_tensors(G2tensor(117),[G2tensor(22),G1tensor(44)])
  call ol_merge_tensors(G2tensor(121),[G2tensor(26),G1tensor(50),G1tensor(21)])
  call ol_merge_tensors(G2tensor(515),[G2tensor(509),G2tensor(35),G2tensor(27),G1tensor(66),G1tensor(54)])
  call ol_merge_tensors(G2tensor(122),[G2tensor(30),G1tensor(56),G1tensor(15)])
  call ol_merge_tensors(G2tensor(497),[G2tensor(491),G2tensor(39),G2tensor(31),G1tensor(72),G1tensor(60)])
  call ol_merge_tensors(G2tensor(123),[G2tensor(34),G1tensor(62)])
  call ol_merge_tensors(G2tensor(125),[G2tensor(38),G1tensor(68)])
  call ol_merge_tensors(G2tensor(221),[G2tensor(46),G2tensor(42),G1tensor(74),G1tensor(39)])
  call ol_merge_tensors(G2tensor(368),[G2tensor(365),G2tensor(47),G2tensor(43),G1tensor(78)])
  call ol_merge_tensors(G2tensor(230),[G2tensor(54),G2tensor(50),G1tensor(80),G1tensor(27)])
  call ol_merge_tensors(G2tensor(362),[G2tensor(359),G2tensor(55),G2tensor(51),G1tensor(84)])
  call ol_merge_tensors(G2tensor(239),[G2tensor(62),G2tensor(58),G1tensor(86),G1tensor(57)])
  call ol_merge_tensors(G2tensor(374),[G2tensor(371),G2tensor(63),G2tensor(59),G1tensor(90)])
  call ol_merge_tensors(G2tensor(248),[G2tensor(70),G2tensor(66),G1tensor(92),G1tensor(69)])
  call ol_merge_tensors(G2tensor(380),[G2tensor(377),G2tensor(71),G2tensor(67),G1tensor(96)])
  call ol_merge_tensors(G2tensor(260),[G2tensor(257),G1tensor(2)])
  call ol_merge_tensors(G2tensor(119),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(41),[G1tensor(23),G1tensor(17),G1tensor(11),G1tensor(5)])
  call ol_merge_tensors(G2tensor(266),[G2tensor(263),G1tensor(8)])
  call ol_merge_tensors(G2tensor(120),[G1tensor(10)])
  call ol_merge_tensors(G2tensor(272),[G2tensor(269),G1tensor(14)])
  call ol_merge_tensors(G2tensor(127),[G1tensor(16)])
  call ol_merge_tensors(G2tensor(278),[G2tensor(275),G1tensor(20)])
  call ol_merge_tensors(G2tensor(128),[G1tensor(22)])
  call ol_merge_tensors(G2tensor(281),[G1tensor(58),G1tensor(52),G1tensor(34),G1tensor(28)])
  call ol_merge_tensors(G2tensor(197),[G1tensor(29)])
  call ol_merge_tensors(G2tensor(284),[G1tensor(33)])
  call ol_merge_tensors(G2tensor(200),[G1tensor(35)])
  call ol_merge_tensors(G2tensor(287),[G1tensor(70),G1tensor(64),G1tensor(46),G1tensor(40)])
  call ol_merge_tensors(G2tensor(203),[G1tensor(41)])
  call ol_merge_tensors(G2tensor(290),[G1tensor(45)])
  call ol_merge_tensors(G2tensor(206),[G1tensor(47)])
  call ol_merge_tensors(G2tensor(293),[G1tensor(51)])
  call ol_merge_tensors(G2tensor(209),[G1tensor(53)])
  call ol_merge_tensors(G2tensor(212),[G1tensor(59)])
  call ol_merge_tensors(G2tensor(296),[G1tensor(63)])
  call ol_merge_tensors(G2tensor(215),[G1tensor(65)])
  call ol_merge_tensors(G2tensor(218),[G1tensor(71)])
  call ol_merge_tensors(G2tensor(305),[G2tensor(299),G1tensor(75)])
  call ol_merge_tensors(G2tensor(308),[G2tensor(302),G1tensor(76)])
  call ol_merge_tensors(G2tensor(413),[G2tensor(407),G2tensor(236),G2tensor(233),G2tensor(227),G2tensor(224),G1tensor(83) &
    ,G1tensor(77)])
  call ol_merge_tensors(G2tensor(317),[G2tensor(311),G1tensor(81)])
  call ol_merge_tensors(G2tensor(320),[G2tensor(314),G1tensor(82)])
  call ol_merge_tensors(G2tensor(329),[G2tensor(323),G1tensor(87)])
  call ol_merge_tensors(G2tensor(332),[G2tensor(326),G1tensor(88)])
  call ol_merge_tensors(G2tensor(479),[G2tensor(473),G2tensor(254),G2tensor(251),G2tensor(245),G2tensor(242),G1tensor(95) &
    ,G1tensor(89)])
  call ol_merge_tensors(G2tensor(341),[G2tensor(335),G1tensor(93)])
  call ol_merge_tensors(G2tensor(344),[G2tensor(338),G1tensor(94)])
  call ol_merge_tensors(G2tensor(141),[G2tensor(139),G2tensor(137),G2tensor(135),G2tensor(131),G2tensor(129)])
  call ol_merge_tensors(G2tensor(138),[G2tensor(136),G2tensor(132),G2tensor(130)])
  call ol_merge_tensors(G2tensor(142),[G2tensor(140),G2tensor(134),G2tensor(133)])
  call ol_merge_tensors(G2tensor(145),[G2tensor(143)])
  call ol_merge_tensors(G2tensor(146),[G2tensor(144)])
  call ol_merge_tensors(G2tensor(148),[G2tensor(147)])
  call ol_merge_tensors(G2tensor(151),[G2tensor(149)])
  call ol_merge_tensors(G2tensor(152),[G2tensor(150)])
  call ol_merge_tensors(G2tensor(154),[G2tensor(153)])
  call ol_merge_tensors(G2tensor(175),[G2tensor(173),G2tensor(171),G2tensor(169),G2tensor(165),G2tensor(163)])
  call ol_merge_tensors(G2tensor(172),[G2tensor(170),G2tensor(166),G2tensor(164)])
  call ol_merge_tensors(G2tensor(176),[G2tensor(174),G2tensor(168),G2tensor(167)])
  call ol_merge_tensors(G2tensor(179),[G2tensor(177)])
  call ol_merge_tensors(G2tensor(180),[G2tensor(178)])
  call ol_merge_tensors(G2tensor(182),[G2tensor(181)])
  call ol_merge_tensors(G2tensor(185),[G2tensor(183)])
  call ol_merge_tensors(G2tensor(186),[G2tensor(184)])
  call ol_merge_tensors(G2tensor(188),[G2tensor(187)])
  call ol_merge_tensors(G2tensor(350),[G2tensor(347)])
  call ol_merge_tensors(G2tensor(356),[G2tensor(353)])
  call ol_merge_tensors(G2tensor(386),[G2tensor(383)])
  call ol_merge_tensors(G2tensor(392),[G2tensor(389)])
  call ol_merge_tensors(G2tensor(416),[G2tensor(410),G2tensor(398),G2tensor(395)])
  call ol_merge_tensors(G2tensor(422),[G2tensor(419),G2tensor(404),G2tensor(401)])
  call ol_merge_tensors(G2tensor(434),[G2tensor(428)])
  call ol_merge_tensors(G2tensor(440),[G2tensor(437)])
  call ol_merge_tensors(G2tensor(452),[G2tensor(446)])
  call ol_merge_tensors(G2tensor(458),[G2tensor(455)])
  call ol_merge_tensors(G2tensor(482),[G2tensor(476),G2tensor(464),G2tensor(461)])
  call ol_merge_tensors(G2tensor(488),[G2tensor(485),G2tensor(470),G2tensor(467)])
  call ol_merge_tensors(G2tensor(500),[G2tensor(494)])
  call ol_merge_tensors(G2tensor(506),[G2tensor(503)])
  call ol_merge_tensors(G2tensor(518),[G2tensor(512)])
  call ol_merge_tensors(G2tensor(524),[G2tensor(521)])
  call Hotf_4pt_reduction_last(G2tensor(161),RedSet_4(2),mass4set(:,1),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25))
  call G_TensorShift(G1tensor(7),42)
  call Hotf_4pt_reduction_last(G2tensor(157),RedSet_4(3),mass4set(:,1),  & 
G1tensor(31),G1tensor(37),G1tensor(43),G1tensor(49),G1tensor(55))
  call G_TensorShift(G1tensor(37),37)
  call Hotf_4pt_reduction_last(G2tensor(195),RedSet_4(4),mass4set(:,1),  & 
G1tensor(61),G1tensor(67),G1tensor(73),G1tensor(79),G1tensor(85))
  call G_TensorShift(G1tensor(67),38)
  call Hotf_4pt_reduction_last(G2tensor(191),RedSet_4(5),mass4set(:,1),  & 
G1tensor(91),G1tensor(6),G1tensor(12),G1tensor(18),G1tensor(24))
  call G_TensorShift(G1tensor(6),41)
  call Hotf_4pt_reduction_last(G2tensor(113),RedSet_4(17),mass4set(:,1),  & 
G1tensor(26),G1tensor(9),G1tensor(42),G1tensor(30),G1tensor(32))
  call G_TensorShift(G1tensor(9),32)
  call Hotf_4pt_reduction_last(G2tensor(449),RedSet_4(6),mass4set(:,1),  & 
G1tensor(3),G1tensor(48),G1tensor(36),G1tensor(38),G1tensor(44))
  call G_TensorShift(G1tensor(48),48)
  call Hotf_4pt_reduction_last(G2tensor(114),RedSet_4(14),mass4set(:,1),  & 
G1tensor(50),G1tensor(21),G1tensor(66),G1tensor(54),G1tensor(56))
  call G_TensorShift(G1tensor(21),32)
  call Hotf_4pt_reduction_last(G2tensor(431),RedSet_4(7),mass4set(:,1),  & 
G1tensor(15),G1tensor(72),G1tensor(60),G1tensor(62),G1tensor(68))
  call G_TensorShift(G1tensor(72),48)
  call Hotf_4pt_reduction_last(G2tensor(115),RedSet_4(66),mass4set(:,1),  & 
G1tensor(74),G1tensor(39),G1tensor(78),G1tensor(80),G1tensor(27))
  call G_TensorShift(G1tensor(39),16)
  call Hotf_4pt_reduction_last(G2tensor(117),RedSet_4(67),mass4set(:,1),  & 
G1tensor(84),G1tensor(86),G1tensor(57),G1tensor(90),G1tensor(92))
  call G_TensorShift(G1tensor(86),16)
  call Hotf_4pt_reduction_last(G2tensor(121),RedSet_4(23),mass4set(:,1),  & 
G1tensor(69),G1tensor(96),G1tensor(2),G1tensor(4),G1tensor(23))
  call G_TensorShift(G1tensor(96),32)
  call Hotf_4pt_reduction_last(G2tensor(515),RedSet_4(8),mass4set(:,1),  & 
G1tensor(17),G1tensor(11),G1tensor(5),G1tensor(8),G1tensor(10))
  call G_TensorShift(G1tensor(11),48)
  call Hotf_4pt_reduction_last(G2tensor(122),RedSet_4(20),mass4set(:,1),  & 
G1tensor(14),G1tensor(16),G1tensor(20),G1tensor(22),G1tensor(58))
  call G_TensorShift(G1tensor(16),32)
  call Hotf_4pt_reduction_last(G2tensor(497),RedSet_4(9),mass4set(:,1),  & 
G1tensor(52),G1tensor(34),G1tensor(28),G1tensor(29),G1tensor(33))
  call G_TensorShift(G1tensor(34),48)
  call Hotf_4pt_reduction_last(G2tensor(123),RedSet_4(68),mass4set(:,1),  & 
G1tensor(35),G1tensor(70),G1tensor(64),G1tensor(46),G1tensor(40))
  call G_TensorShift(G1tensor(70),16)
  call Hotf_4pt_reduction_last(G2tensor(125),RedSet_4(69),mass4set(:,1),  & 
G1tensor(41),G1tensor(45),G1tensor(47),G1tensor(51),G1tensor(53))
  call G_TensorShift(G1tensor(45),16)
  call Hotf_4pt_reduction_last(G2tensor(221),RedSet_4(33),mass4set(:,1),  & 
G1tensor(59),G1tensor(63),G1tensor(65),G1tensor(71),G1tensor(75))
  call G_TensorShift(G1tensor(63),32)
  call Hotf_4pt_reduction_last(G2tensor(368),RedSet_4(10),mass4set(:,1),  & 
G1tensor(76),G1tensor(83),G1tensor(77),G1tensor(81),G1tensor(82))
  call G_TensorShift(G1tensor(83),42)
  call Hotf_4pt_reduction_last(G2tensor(230),RedSet_4(26),mass4set(:,1),  & 
G1tensor(87),G1tensor(88),G1tensor(95),G1tensor(89),G1tensor(93))
  call G_TensorShift(G1tensor(88),16)
  call Hotf_4pt_reduction_last(G2tensor(362),RedSet_4(11),mass4set(:,1),  & 
G1tensor(94),G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100))
  call G_TensorShift(G1tensor(97),26)
  call Hotf_4pt_reduction_last(G2tensor(239),RedSet_4(43),mass4set(:,1),  & 
G1tensor(101),G1tensor(102),G1tensor(103),G1tensor(104),G1tensor(105))
  call G_TensorShift(G1tensor(102),16)
  call Hotf_4pt_reduction_last(G2tensor(374),RedSet_4(12),mass4set(:,1),  & 
G1tensor(106),G1tensor(107),G1tensor(108),G1tensor(109),G1tensor(110))
  call G_TensorShift(G1tensor(107),25)
  call Hotf_4pt_reduction_last(G2tensor(248),RedSet_4(49),mass4set(:,1),  & 
G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114),G1tensor(115))
  call G_TensorShift(G1tensor(112),32)
  call Hotf_4pt_reduction_last(G2tensor(380),RedSet_4(13),mass4set(:,1),  & 
G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(117),41)
  call Hotf_4pt_reduction_last(G2tensor(260),RedSet_4(70),mass4set(:,1),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125))
  call G_TensorShift(G1tensor(122),10)
  call Hotf_4pt_reduction_last(G2tensor(119),RedSet_4(15),mass4set(:,1),  & 
G1tensor(126),G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130))
  call G_TensorShift(G1tensor(127),32)
  call Hotf_4pt_reduction_last(G2tensor(41),RedSet_4(1),mass4set(:,1),  & 
G1tensor(131),G1tensor(132),G1tensor(133),G1tensor(134),G1tensor(135))
  call G_TensorShift(G1tensor(132),32)
  call Hotf_4pt_reduction_last(G2tensor(266),RedSet_4(71),mass4set(:,1),  & 
G1tensor(136),G1tensor(137),G1tensor(138),G1tensor(139),G1tensor(140))
  call G_TensorShift(G1tensor(137),5)
  call Hotf_4pt_reduction_last(G2tensor(120),RedSet_4(18),mass4set(:,1),  & 
G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144),G1tensor(145))
  call G_TensorShift(G1tensor(142),32)
  call Hotf_4pt_reduction_last(G2tensor(272),RedSet_4(72),mass4set(:,1),  & 
G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(147),6)
  call Hotf_4pt_reduction_last(G2tensor(127),RedSet_4(21),mass4set(:,1),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155))
  call G_TensorShift(G1tensor(152),32)
  call Hotf_4pt_reduction_last(G2tensor(278),RedSet_4(73),mass4set(:,1),  & 
G1tensor(156),G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160))
  call G_TensorShift(G1tensor(157),9)
  call Hotf_4pt_reduction_last(G2tensor(128),RedSet_4(24),mass4set(:,1),  & 
G1tensor(161),G1tensor(162),G1tensor(163),G1tensor(164),G1tensor(165))
  call G_TensorShift(G1tensor(162),32)
  call Hotf_4pt_reduction_last(G2tensor(281),RedSet_4(27),mass4set(:,1),  & 
G1tensor(166),G1tensor(167),G1tensor(168),G1tensor(169),G1tensor(170))
  call G_TensorShift(G1tensor(167),16)
  call Hotf_4pt_reduction_last(G2tensor(197),RedSet_4(28),mass4set(:,1),  & 
G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174),G1tensor(175))
  call G_TensorShift(G1tensor(172),16)
  call Hotf_4pt_reduction_last(G2tensor(284),RedSet_4(30),mass4set(:,1),  & 
G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(177),16)
  call Hotf_4pt_reduction_last(G2tensor(200),RedSet_4(31),mass4set(:,1),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185))
  call G_TensorShift(G1tensor(182),16)
  call Hotf_4pt_reduction_last(G2tensor(287),RedSet_4(34),mass4set(:,1),  & 
G1tensor(186),G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190))
  call G_TensorShift(G1tensor(187),32)
  call Hotf_4pt_reduction_last(G2tensor(203),RedSet_4(35),mass4set(:,1),  & 
G1tensor(191),G1tensor(192),G1tensor(193),G1tensor(194),G1tensor(195))
  call G_TensorShift(G1tensor(192),32)
  call Hotf_4pt_reduction_last(G2tensor(290),RedSet_4(37),mass4set(:,1),  & 
G1tensor(196),G1tensor(197),G1tensor(198),G1tensor(199),G1tensor(200))
  call G_TensorShift(G1tensor(197),32)
  call Hotf_4pt_reduction_last(G2tensor(206),RedSet_4(38),mass4set(:,1),  & 
G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204),G1tensor(205))
  call G_TensorShift(G1tensor(202),32)
  call Hotf_4pt_reduction_last(G2tensor(293),RedSet_4(40),mass4set(:,1),  & 
G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(207),16)
  call Hotf_4pt_reduction_last(G2tensor(209),RedSet_4(41),mass4set(:,1),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215))
  call G_TensorShift(G1tensor(212),16)
  call Hotf_4pt_reduction_last(G2tensor(212),RedSet_4(44),mass4set(:,1),  & 
G1tensor(216),G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220))
  call G_TensorShift(G1tensor(217),16)
  call Hotf_4pt_reduction_last(G2tensor(296),RedSet_4(46),mass4set(:,1),  & 
G1tensor(221),G1tensor(222),G1tensor(223),G1tensor(224),G1tensor(225))
  call G_TensorShift(G1tensor(222),32)
  call Hotf_4pt_reduction_last(G2tensor(215),RedSet_4(47),mass4set(:,1),  & 
G1tensor(226),G1tensor(227),G1tensor(228),G1tensor(229),G1tensor(230))
  call G_TensorShift(G1tensor(227),32)
  call Hotf_4pt_reduction_last(G2tensor(218),RedSet_4(50),mass4set(:,1),  & 
G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234),G1tensor(235))
  call G_TensorShift(G1tensor(232),32)
  call Hotf_4pt_reduction_last(G2tensor(305),RedSet_4(52),mass4set(:,1),  & 
G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(237),10)
  call Hotf_4pt_reduction_last(G2tensor(308),RedSet_4(53),mass4set(:,1),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245))
  call G_TensorShift(G1tensor(242),10)
  call Hotf_4pt_reduction_last(G2tensor(413),RedSet_4(54),mass4set(:,1),  & 
G1tensor(246),G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250))
  call G_TensorShift(G1tensor(247),10)
  call Hotf_4pt_reduction_last(G2tensor(317),RedSet_4(56),mass4set(:,1),  & 
G1tensor(251),G1tensor(252),G1tensor(253),G1tensor(254),G1tensor(255))
  call G_TensorShift(G1tensor(252),10)
  call Hotf_4pt_reduction_last(G2tensor(320),RedSet_4(57),mass4set(:,1),  & 
G1tensor(256),G1tensor(257),G1tensor(258),G1tensor(259),G1tensor(260))
  call G_TensorShift(G1tensor(257),10)
  call Hotf_4pt_reduction_last(G2tensor(329),RedSet_4(59),mass4set(:,1),  & 
G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264),G1tensor(265))
  call G_TensorShift(G1tensor(262),9)
  call Hotf_4pt_reduction_last(G2tensor(332),RedSet_4(60),mass4set(:,1),  & 
G1tensor(266),G1tensor(267),G1tensor(268),G1tensor(269),G1tensor(270))
  call G_TensorShift(G1tensor(267),9)
  call Hotf_4pt_reduction_last(G2tensor(479),RedSet_4(61),mass4set(:,1),  & 
G1tensor(271),G1tensor(272),G1tensor(273),G1tensor(274),G1tensor(275))
  call G_TensorShift(G1tensor(272),9)
  call Hotf_4pt_reduction_last(G2tensor(341),RedSet_4(63),mass4set(:,1),  & 
G1tensor(276),G1tensor(277),G1tensor(278),G1tensor(279),G1tensor(280))
  call G_TensorShift(G1tensor(277),9)
  call Hotf_4pt_reduction_last(G2tensor(344),RedSet_4(64),mass4set(:,1),  & 
G1tensor(281),G1tensor(282),G1tensor(283),G1tensor(284),G1tensor(285))
  call G_TensorShift(G1tensor(282),9)
  call Hotf_4pt_reduction_last(G2tensor(141),RedSet_4(54),mass4set(:,1),  & 
G1tensor(286),G1tensor(287),G1tensor(288),G1tensor(289),G1tensor(290),G0tensor(1))
  call G_TensorShift(G1tensor(287),10)
  call Hotf_4pt_reduction_last(G2tensor(138),RedSet_4(54),mass4set(:,2),  & 
G1tensor(286),G1tensor(291),G1tensor(292),G1tensor(293),G1tensor(294),G0tensor(2))
  call G_TensorShift(G1tensor(291),10)
  call Hotf_4pt_reduction_last(G2tensor(142),RedSet_4(54),mass4set(:,3),  & 
G1tensor(286),G1tensor(295),G1tensor(296),G1tensor(297),G1tensor(298),G0tensor(3))
  call G_TensorShift(G1tensor(295),10)
  call Hotf_4pt_reduction_last(G2tensor(145),RedSet_4(7),mass4set(:,1),  & 
G1tensor(286),G1tensor(299),G1tensor(300),G1tensor(301),G1tensor(302),G0tensor(4))
  call G_TensorShift(G1tensor(299),48)
  call Hotf_4pt_reduction_last(G2tensor(146),RedSet_4(7),mass4set(:,2),  & 
G1tensor(286),G1tensor(303),G1tensor(304),G1tensor(305),G1tensor(306),G0tensor(5))
  call G_TensorShift(G1tensor(303),48)
  call Hotf_4pt_reduction_last(G2tensor(148),RedSet_4(7),mass4set(:,3),  & 
G1tensor(286),G1tensor(307),G1tensor(308),G1tensor(309),G1tensor(310),G0tensor(6))
  call G_TensorShift(G1tensor(307),48)
  call Hotf_4pt_reduction_last(G2tensor(151),RedSet_4(6),mass4set(:,1),  & 
G1tensor(286),G1tensor(311),G1tensor(312),G1tensor(313),G1tensor(314),G0tensor(7))
  call G_TensorShift(G1tensor(311),48)
  call Hotf_4pt_reduction_last(G2tensor(152),RedSet_4(6),mass4set(:,2),  & 
G1tensor(286),G1tensor(315),G1tensor(316),G1tensor(317),G1tensor(318),G0tensor(8))
  call G_TensorShift(G1tensor(315),48)
  call Hotf_4pt_reduction_last(G2tensor(154),RedSet_4(6),mass4set(:,3),  & 
G1tensor(286),G1tensor(319),G1tensor(320),G1tensor(321),G1tensor(322),G0tensor(9))
  call G_TensorShift(G1tensor(319),48)
  call Hotf_4pt_reduction_last(G2tensor(175),RedSet_4(61),mass4set(:,1),  & 
G1tensor(286),G1tensor(323),G1tensor(324),G1tensor(325),G1tensor(326),G0tensor(10))
  call G_TensorShift(G1tensor(323),9)
  call Hotf_4pt_reduction_last(G2tensor(172),RedSet_4(61),mass4set(:,2),  & 
G1tensor(286),G1tensor(327),G1tensor(328),G1tensor(329),G1tensor(330),G0tensor(11))
  call G_TensorShift(G1tensor(327),9)
  call Hotf_4pt_reduction_last(G2tensor(176),RedSet_4(61),mass4set(:,3),  & 
G1tensor(286),G1tensor(331),G1tensor(332),G1tensor(333),G1tensor(334),G0tensor(12))
  call G_TensorShift(G1tensor(331),9)
  call Hotf_4pt_reduction_last(G2tensor(179),RedSet_4(9),mass4set(:,1),  & 
G1tensor(286),G1tensor(335),G1tensor(336),G1tensor(337),G1tensor(338),G0tensor(13))
  call G_TensorShift(G1tensor(335),48)
  call Hotf_4pt_reduction_last(G2tensor(180),RedSet_4(9),mass4set(:,2),  & 
G1tensor(286),G1tensor(339),G1tensor(340),G1tensor(341),G1tensor(342),G0tensor(14))
  call G_TensorShift(G1tensor(339),48)
  call Hotf_4pt_reduction_last(G2tensor(182),RedSet_4(9),mass4set(:,3),  & 
G1tensor(286),G1tensor(343),G1tensor(344),G1tensor(345),G1tensor(346),G0tensor(15))
  call G_TensorShift(G1tensor(343),48)
  call Hotf_4pt_reduction_last(G2tensor(185),RedSet_4(8),mass4set(:,1),  & 
G1tensor(286),G1tensor(347),G1tensor(348),G1tensor(349),G1tensor(350),G0tensor(16))
  call G_TensorShift(G1tensor(347),48)
  call Hotf_4pt_reduction_last(G2tensor(186),RedSet_4(8),mass4set(:,2),  & 
G1tensor(286),G1tensor(351),G1tensor(352),G1tensor(353),G1tensor(354),G0tensor(17))
  call G_TensorShift(G1tensor(351),48)
  call Hotf_4pt_reduction_last(G2tensor(188),RedSet_4(8),mass4set(:,3),  & 
G1tensor(286),G1tensor(355),G1tensor(356),G1tensor(357),G1tensor(358),G0tensor(18))
  call G_TensorShift(G1tensor(355),48)
  call Hotf_4pt_reduction_last(G2tensor(350),RedSet_4(74),mass4set(:,1),  & 
G1tensor(286),G1tensor(359),G1tensor(360),G1tensor(361),G1tensor(362))
  call G_TensorShift(G1tensor(359),21)
  call Hotf_4pt_reduction_last(G2tensor(356),RedSet_4(75),mass4set(:,1),  & 
G1tensor(363),G1tensor(364),G1tensor(365),G1tensor(366),G1tensor(367))
  call G_TensorShift(G1tensor(364),37)
  call Hotf_4pt_reduction_last(G2tensor(386),RedSet_4(76),mass4set(:,1),  & 
G1tensor(368),G1tensor(369),G1tensor(370),G1tensor(371),G1tensor(372))
  call G_TensorShift(G1tensor(369),22)
  call Hotf_4pt_reduction_last(G2tensor(392),RedSet_4(77),mass4set(:,1),  & 
G1tensor(373),G1tensor(374),G1tensor(375),G1tensor(376),G1tensor(377))
  call G_TensorShift(G1tensor(374),38)
  call Hotf_4pt_reduction_last(G2tensor(416),RedSet_4(54),mass4set(:,2),  & 
G1tensor(378),G1tensor(379),G1tensor(380),G1tensor(381),G1tensor(382))
  call G_TensorShift(G1tensor(379),10)
  call Hotf_4pt_reduction_last(G2tensor(422),RedSet_4(54),mass4set(:,3),  & 
G1tensor(383),G1tensor(384),G1tensor(385),G1tensor(386),G1tensor(387))
  call G_TensorShift(G1tensor(384),10)
  call Hotf_4pt_reduction_last(G2tensor(434),RedSet_4(7),mass4set(:,2),  & 
G1tensor(388),G1tensor(389),G1tensor(390),G1tensor(391),G1tensor(392))
  call G_TensorShift(G1tensor(389),48)
  call Hotf_4pt_reduction_last(G2tensor(440),RedSet_4(7),mass4set(:,3),  & 
G1tensor(393),G1tensor(394),G1tensor(395),G1tensor(396),G1tensor(397))
  call G_TensorShift(G1tensor(394),48)
  call Hotf_4pt_reduction_last(G2tensor(452),RedSet_4(6),mass4set(:,2),  & 
G1tensor(398),G1tensor(399),G1tensor(400),G1tensor(401),G1tensor(402))
  call G_TensorShift(G1tensor(399),48)
  call Hotf_4pt_reduction_last(G2tensor(458),RedSet_4(6),mass4set(:,3),  & 
G1tensor(403),G1tensor(404),G1tensor(405),G1tensor(406),G1tensor(407))
  call G_TensorShift(G1tensor(404),48)
  call Hotf_4pt_reduction_last(G2tensor(482),RedSet_4(61),mass4set(:,2),  & 
G1tensor(408),G1tensor(409),G1tensor(410),G1tensor(411),G1tensor(412))
  call G_TensorShift(G1tensor(409),9)
  call Hotf_4pt_reduction_last(G2tensor(488),RedSet_4(61),mass4set(:,3),  & 
G1tensor(413),G1tensor(414),G1tensor(415),G1tensor(416),G1tensor(417))
  call G_TensorShift(G1tensor(414),9)
  call Hotf_4pt_reduction_last(G2tensor(500),RedSet_4(9),mass4set(:,2),  & 
G1tensor(418),G1tensor(419),G1tensor(420),G1tensor(421),G1tensor(422))
  call G_TensorShift(G1tensor(419),48)
  call Hotf_4pt_reduction_last(G2tensor(506),RedSet_4(9),mass4set(:,3),  & 
G1tensor(423),G1tensor(424),G1tensor(425),G1tensor(426),G1tensor(427))
  call G_TensorShift(G1tensor(424),48)
  call Hotf_4pt_reduction_last(G2tensor(518),RedSet_4(8),mass4set(:,2),  & 
G1tensor(428),G1tensor(429),G1tensor(430),G1tensor(431),G1tensor(432))
  call G_TensorShift(G1tensor(429),48)
  call Hotf_4pt_reduction_last(G2tensor(524),RedSet_4(8),mass4set(:,3),  & 
G1tensor(433),G1tensor(434),G1tensor(435),G1tensor(436),G1tensor(437))
  call G_TensorShift(G1tensor(434),48)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(2),mass4set(:,1),  & 
G0tensor(19),G0tensor(20),G0tensor(21),G0tensor(22),G0tensor(23))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(3),mass4set(:,1),  & 
G0tensor(24),G0tensor(25),G0tensor(26),G0tensor(27),G0tensor(28))
  call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(4),mass4set(:,1),  & 
G0tensor(29),G0tensor(30),G0tensor(31),G0tensor(32),G0tensor(33))
  call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(5),mass4set(:,1),  & 
G0tensor(34),G0tensor(35),G0tensor(36),G0tensor(37),G0tensor(38))
  call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(17),mass4set(:,1),  & 
G0tensor(39),G0tensor(40),G0tensor(41),G0tensor(42),G0tensor(43))
  call Hotf_4pt_reduction_last(G1tensor(3),RedSet_4(6),mass4set(:,1),  & 
G0tensor(44),G0tensor(45),G0tensor(46),G0tensor(47),G0tensor(48))
  call Hotf_4pt_reduction_last(G1tensor(50),RedSet_4(14),mass4set(:,1),  & 
G0tensor(49),G0tensor(50),G0tensor(51),G0tensor(52),G0tensor(53))
  call Hotf_4pt_reduction_last(G1tensor(15),RedSet_4(7),mass4set(:,1),  & 
G0tensor(54),G0tensor(55),G0tensor(56),G0tensor(57),G0tensor(58))
  call Hotf_4pt_reduction_last(G1tensor(74),RedSet_4(66),mass4set(:,1),  & 
G0tensor(59),G0tensor(60),G0tensor(61),G0tensor(62),G0tensor(63))
  call Hotf_4pt_reduction_last(G1tensor(84),RedSet_4(67),mass4set(:,1),  & 
G0tensor(64),G0tensor(65),G0tensor(66),G0tensor(67),G0tensor(68))
  call Hotf_4pt_reduction_last(G1tensor(69),RedSet_4(23),mass4set(:,1),  & 
G0tensor(69),G0tensor(70),G0tensor(71),G0tensor(72),G0tensor(73))
  call Hotf_4pt_reduction_last(G1tensor(17),RedSet_4(8),mass4set(:,1),  & 
G0tensor(74),G0tensor(75),G0tensor(76),G0tensor(77),G0tensor(78))
  call Hotf_4pt_reduction_last(G1tensor(14),RedSet_4(20),mass4set(:,1),  & 
G0tensor(79),G0tensor(80),G0tensor(81),G0tensor(82),G0tensor(83))
  call Hotf_4pt_reduction_last(G1tensor(52),RedSet_4(9),mass4set(:,1),  & 
G0tensor(84),G0tensor(85),G0tensor(86),G0tensor(87),G0tensor(88))
  call Hotf_4pt_reduction_last(G1tensor(35),RedSet_4(68),mass4set(:,1),  & 
G0tensor(89),G0tensor(90),G0tensor(91),G0tensor(92),G0tensor(93))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(69),mass4set(:,1),  & 
G0tensor(94),G0tensor(95),G0tensor(96),G0tensor(97),G0tensor(98))
  call Hotf_4pt_reduction_last(G1tensor(59),RedSet_4(33),mass4set(:,1),  & 
G0tensor(99),G0tensor(100),G0tensor(101),G0tensor(102),G0tensor(103))
  call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(10),mass4set(:,1),  & 
G0tensor(104),G0tensor(105),G0tensor(106),G0tensor(107),G0tensor(108))
  call Hotf_4pt_reduction_last(G1tensor(87),RedSet_4(26),mass4set(:,1),  & 
G0tensor(109),G0tensor(110),G0tensor(111),G0tensor(112),G0tensor(113))
  call Hotf_4pt_reduction_last(G1tensor(94),RedSet_4(11),mass4set(:,1),  & 
G0tensor(114),G0tensor(115),G0tensor(116),G0tensor(117),G0tensor(118))
  call Hotf_4pt_reduction_last(G1tensor(101),RedSet_4(43),mass4set(:,1),  & 
G0tensor(119),G0tensor(120),G0tensor(121),G0tensor(122),G0tensor(123))
  call Hotf_4pt_reduction_last(G1tensor(106),RedSet_4(12),mass4set(:,1),  & 
G0tensor(124),G0tensor(125),G0tensor(126),G0tensor(127),G0tensor(128))
  call Hotf_4pt_reduction_last(G1tensor(111),RedSet_4(49),mass4set(:,1),  & 
G0tensor(129),G0tensor(130),G0tensor(131),G0tensor(132),G0tensor(133))
  call Hotf_4pt_reduction_last(G1tensor(116),RedSet_4(13),mass4set(:,1),  & 
G0tensor(134),G0tensor(135),G0tensor(136),G0tensor(137),G0tensor(138))
  call Hotf_4pt_reduction_last(G1tensor(121),RedSet_4(70),mass4set(:,1),  & 
G0tensor(139),G0tensor(140),G0tensor(141),G0tensor(142),G0tensor(143))
  call Hotf_4pt_reduction_last(G1tensor(126),RedSet_4(15),mass4set(:,1),  & 
G0tensor(144),G0tensor(145),G0tensor(146),G0tensor(147),G0tensor(148))
  call Hotf_4pt_reduction_last(G1tensor(131),RedSet_4(1),mass4set(:,1),  & 
G0tensor(149),G0tensor(150),G0tensor(151),G0tensor(152),G0tensor(153))
  call Hotf_4pt_reduction_last(G1tensor(136),RedSet_4(71),mass4set(:,1),  & 
G0tensor(154),G0tensor(155),G0tensor(156),G0tensor(157),G0tensor(158))
  call Hotf_4pt_reduction_last(G1tensor(141),RedSet_4(18),mass4set(:,1),  & 
G0tensor(159),G0tensor(160),G0tensor(161),G0tensor(162),G0tensor(163))
  call Hotf_4pt_reduction_last(G1tensor(146),RedSet_4(72),mass4set(:,1),  & 
G0tensor(164),G0tensor(165),G0tensor(166),G0tensor(167),G0tensor(168))
  call Hotf_4pt_reduction_last(G1tensor(151),RedSet_4(21),mass4set(:,1),  & 
G0tensor(169),G0tensor(170),G0tensor(171),G0tensor(172),G0tensor(173))
  call Hotf_4pt_reduction_last(G1tensor(156),RedSet_4(73),mass4set(:,1),  & 
G0tensor(174),G0tensor(175),G0tensor(176),G0tensor(177),G0tensor(178))
  call Hotf_4pt_reduction_last(G1tensor(161),RedSet_4(24),mass4set(:,1),  & 
G0tensor(179),G0tensor(180),G0tensor(181),G0tensor(182),G0tensor(183))
  call Hotf_4pt_reduction_last(G1tensor(166),RedSet_4(27),mass4set(:,1),  & 
G0tensor(184),G0tensor(185),G0tensor(186),G0tensor(187),G0tensor(188))
  call Hotf_4pt_reduction_last(G1tensor(171),RedSet_4(28),mass4set(:,1),  & 
G0tensor(189),G0tensor(190),G0tensor(191),G0tensor(192),G0tensor(193))
  call Hotf_4pt_reduction_last(G1tensor(176),RedSet_4(30),mass4set(:,1),  & 
G0tensor(194),G0tensor(195),G0tensor(196),G0tensor(197),G0tensor(198))
  call Hotf_4pt_reduction_last(G1tensor(181),RedSet_4(31),mass4set(:,1),  & 
G0tensor(199),G0tensor(200),G0tensor(201),G0tensor(202),G0tensor(203))
  call Hotf_4pt_reduction_last(G1tensor(186),RedSet_4(34),mass4set(:,1),  & 
G0tensor(204),G0tensor(205),G0tensor(206),G0tensor(207),G0tensor(208))
  call Hotf_4pt_reduction_last(G1tensor(191),RedSet_4(35),mass4set(:,1),  & 
G0tensor(209),G0tensor(210),G0tensor(211),G0tensor(212),G0tensor(213))
  call Hotf_4pt_reduction_last(G1tensor(196),RedSet_4(37),mass4set(:,1),  & 
G0tensor(214),G0tensor(215),G0tensor(216),G0tensor(217),G0tensor(218))
  call Hotf_4pt_reduction_last(G1tensor(201),RedSet_4(38),mass4set(:,1),  & 
G0tensor(219),G0tensor(220),G0tensor(221),G0tensor(222),G0tensor(223))
  call Hotf_4pt_reduction_last(G1tensor(206),RedSet_4(40),mass4set(:,1),  & 
G0tensor(224),G0tensor(225),G0tensor(226),G0tensor(227),G0tensor(228))
  call Hotf_4pt_reduction_last(G1tensor(211),RedSet_4(41),mass4set(:,1),  & 
G0tensor(229),G0tensor(230),G0tensor(231),G0tensor(232),G0tensor(233))
  call Hotf_4pt_reduction_last(G1tensor(216),RedSet_4(44),mass4set(:,1),  & 
G0tensor(234),G0tensor(235),G0tensor(236),G0tensor(237),G0tensor(238))
  call Hotf_4pt_reduction_last(G1tensor(221),RedSet_4(46),mass4set(:,1),  & 
G0tensor(239),G0tensor(240),G0tensor(241),G0tensor(242),G0tensor(243))
  call Hotf_4pt_reduction_last(G1tensor(226),RedSet_4(47),mass4set(:,1),  & 
G0tensor(244),G0tensor(245),G0tensor(246),G0tensor(247),G0tensor(248))
  call Hotf_4pt_reduction_last(G1tensor(231),RedSet_4(50),mass4set(:,1),  & 
G0tensor(249),G0tensor(250),G0tensor(251),G0tensor(252),G0tensor(253))
  call Hotf_4pt_reduction_last(G1tensor(236),RedSet_4(52),mass4set(:,1),  & 
G0tensor(254),G0tensor(255),G0tensor(256),G0tensor(257),G0tensor(258))
  call Hotf_4pt_reduction_last(G1tensor(241),RedSet_4(53),mass4set(:,1),  & 
G0tensor(259),G0tensor(260),G0tensor(261),G0tensor(262),G0tensor(263))
  call Hotf_4pt_reduction_last(G1tensor(246),RedSet_4(54),mass4set(:,1),  & 
G0tensor(264),G0tensor(265),G0tensor(266),G0tensor(267),G0tensor(268))
  call Hotf_4pt_reduction_last(G1tensor(251),RedSet_4(56),mass4set(:,1),  & 
G0tensor(269),G0tensor(270),G0tensor(271),G0tensor(272),G0tensor(273))
  call Hotf_4pt_reduction_last(G1tensor(256),RedSet_4(57),mass4set(:,1),  & 
G0tensor(274),G0tensor(275),G0tensor(276),G0tensor(277),G0tensor(278))
  call Hotf_4pt_reduction_last(G1tensor(261),RedSet_4(59),mass4set(:,1),  & 
G0tensor(279),G0tensor(280),G0tensor(281),G0tensor(282),G0tensor(283))
  call Hotf_4pt_reduction_last(G1tensor(266),RedSet_4(60),mass4set(:,1),  & 
G0tensor(284),G0tensor(285),G0tensor(286),G0tensor(287),G0tensor(288))
  call Hotf_4pt_reduction_last(G1tensor(271),RedSet_4(61),mass4set(:,1),  & 
G0tensor(289),G0tensor(290),G0tensor(291),G0tensor(292),G0tensor(293))
  call Hotf_4pt_reduction_last(G1tensor(276),RedSet_4(63),mass4set(:,1),  & 
G0tensor(294),G0tensor(295),G0tensor(296),G0tensor(297),G0tensor(298))
  call Hotf_4pt_reduction_last(G1tensor(281),RedSet_4(64),mass4set(:,1),  & 
G0tensor(299),G0tensor(300),G0tensor(301),G0tensor(302),G0tensor(303))
  call Hotf_4pt_reduction_last(G1tensor(286),RedSet_4(74),mass4set(:,1),  & 
G0tensor(304),G0tensor(305),G0tensor(306),G0tensor(307),G0tensor(308))
  call Hotf_4pt_reduction_last(G1tensor(363),RedSet_4(75),mass4set(:,1),  & 
G0tensor(309),G0tensor(310),G0tensor(311),G0tensor(312),G0tensor(313))
  call Hotf_4pt_reduction_last(G1tensor(368),RedSet_4(76),mass4set(:,1),  & 
G0tensor(314),G0tensor(315),G0tensor(316),G0tensor(317),G0tensor(318))
  call Hotf_4pt_reduction_last(G1tensor(373),RedSet_4(77),mass4set(:,1),  & 
G0tensor(319),G0tensor(320),G0tensor(321),G0tensor(322),G0tensor(323))
  call Hotf_4pt_reduction_last(G1tensor(378),RedSet_4(54),mass4set(:,2),  & 
G0tensor(324),G0tensor(325),G0tensor(326),G0tensor(327),G0tensor(328))
  call Hotf_4pt_reduction_last(G1tensor(383),RedSet_4(54),mass4set(:,3),  & 
G0tensor(329),G0tensor(330),G0tensor(331),G0tensor(332),G0tensor(333))
  call Hotf_4pt_reduction_last(G1tensor(388),RedSet_4(7),mass4set(:,2),  & 
G0tensor(334),G0tensor(335),G0tensor(336),G0tensor(337),G0tensor(338))
  call Hotf_4pt_reduction_last(G1tensor(393),RedSet_4(7),mass4set(:,3),  & 
G0tensor(339),G0tensor(340),G0tensor(341),G0tensor(342),G0tensor(343))
  call Hotf_4pt_reduction_last(G1tensor(398),RedSet_4(6),mass4set(:,2),  & 
G0tensor(344),G0tensor(345),G0tensor(346),G0tensor(347),G0tensor(348))
  call Hotf_4pt_reduction_last(G1tensor(403),RedSet_4(6),mass4set(:,3),  & 
G0tensor(349),G0tensor(350),G0tensor(351),G0tensor(352),G0tensor(353))
  call Hotf_4pt_reduction_last(G1tensor(408),RedSet_4(61),mass4set(:,2),  & 
G0tensor(354),G0tensor(355),G0tensor(356),G0tensor(357),G0tensor(358))
  call Hotf_4pt_reduction_last(G1tensor(413),RedSet_4(61),mass4set(:,3),  & 
G0tensor(359),G0tensor(360),G0tensor(361),G0tensor(362),G0tensor(363))
  call Hotf_4pt_reduction_last(G1tensor(418),RedSet_4(9),mass4set(:,2),  & 
G0tensor(364),G0tensor(365),G0tensor(366),G0tensor(367),G0tensor(368))
  call Hotf_4pt_reduction_last(G1tensor(423),RedSet_4(9),mass4set(:,3),  & 
G0tensor(369),G0tensor(370),G0tensor(371),G0tensor(372),G0tensor(373))
  call Hotf_4pt_reduction_last(G1tensor(428),RedSet_4(8),mass4set(:,2),  & 
G0tensor(374),G0tensor(375),G0tensor(376),G0tensor(377),G0tensor(378))
  call Hotf_4pt_reduction_last(G1tensor(433),RedSet_4(8),mass4set(:,3),  & 
G0tensor(379),G0tensor(380),G0tensor(381),G0tensor(382),G0tensor(383))
  call ol_merge_tensors(T0sum(1),[G0tensor(19)])
  call ol_merge_tensors(T0sum(2),[G0tensor(24)])
  call ol_merge_tensors(T0sum(3),[G0tensor(29)])
  call ol_merge_tensors(T0sum(4),[G0tensor(34)])
  call ol_merge_tensors(T0sum(5),[G0tensor(39)])
  call ol_merge_tensors(T0sum(6),[G0tensor(44)])
  call ol_merge_tensors(T0sum(7),[G0tensor(49)])
  call ol_merge_tensors(T0sum(8),[G0tensor(54)])
  call ol_merge_tensors(T0sum(9),[G0tensor(59)])
  call ol_merge_tensors(T0sum(10),[G0tensor(64)])
  call ol_merge_tensors(T0sum(11),[G0tensor(69)])
  call ol_merge_tensors(T0sum(12),[G0tensor(74)])
  call ol_merge_tensors(T0sum(13),[G0tensor(79)])
  call ol_merge_tensors(T0sum(14),[G0tensor(84)])
  call ol_merge_tensors(T0sum(15),[G0tensor(89)])
  call ol_merge_tensors(T0sum(16),[G0tensor(94)])
  call ol_merge_tensors(T0sum(17),[G0tensor(99)])
  call ol_merge_tensors(T0sum(18),[G0tensor(104)])
  call ol_merge_tensors(T0sum(19),[G0tensor(109)])
  call ol_merge_tensors(T0sum(20),[G0tensor(114)])
  call ol_merge_tensors(T0sum(21),[G0tensor(119)])
  call ol_merge_tensors(T0sum(22),[G0tensor(124)])
  call ol_merge_tensors(T0sum(23),[G0tensor(129)])
  call ol_merge_tensors(T0sum(24),[G0tensor(134)])
  call ol_merge_tensors(T0sum(25),[G0tensor(139)])
  call ol_merge_tensors(T0sum(26),[G0tensor(144)])
  call ol_merge_tensors(T0sum(27),[G0tensor(149)])
  call ol_merge_tensors(T0sum(28),[G0tensor(154)])
  call ol_merge_tensors(T0sum(29),[G0tensor(159)])
  call ol_merge_tensors(T0sum(30),[G0tensor(164)])
  call ol_merge_tensors(T0sum(31),[G0tensor(169)])
  call ol_merge_tensors(T0sum(32),[G0tensor(174)])
  call ol_merge_tensors(T0sum(33),[G0tensor(179)])
  call ol_merge_tensors(T0sum(34),[G0tensor(184)])
  call ol_merge_tensors(T0sum(35),[G0tensor(189)])
  call ol_merge_tensors(T0sum(36),[G0tensor(194)])
  call ol_merge_tensors(T0sum(37),[G0tensor(199)])
  call ol_merge_tensors(T0sum(38),[G0tensor(204)])
  call ol_merge_tensors(T0sum(39),[G0tensor(209)])
  call ol_merge_tensors(T0sum(40),[G0tensor(214)])
  call ol_merge_tensors(T0sum(41),[G0tensor(219)])
  call ol_merge_tensors(T0sum(42),[G0tensor(224)])
  call ol_merge_tensors(T0sum(43),[G0tensor(229)])
  call ol_merge_tensors(T0sum(44),[G0tensor(234)])
  call ol_merge_tensors(T0sum(45),[G0tensor(239)])
  call ol_merge_tensors(T0sum(46),[G0tensor(244)])
  call ol_merge_tensors(T0sum(47),[G0tensor(249)])
  call ol_merge_tensors(T0sum(48),[G0tensor(254)])
  call ol_merge_tensors(T0sum(49),[G0tensor(259)])
  call ol_merge_tensors(T0sum(50),[G0tensor(264)])
  call ol_merge_tensors(T0sum(51),[G0tensor(269)])
  call ol_merge_tensors(T0sum(52),[G0tensor(274)])
  call ol_merge_tensors(T0sum(53),[G0tensor(279)])
  call ol_merge_tensors(T0sum(54),[G0tensor(284)])
  call ol_merge_tensors(T0sum(55),[G0tensor(289)])
  call ol_merge_tensors(T0sum(56),[G0tensor(294)])
  call ol_merge_tensors(T0sum(57),[G0tensor(299)])
  call ol_merge_tensors(T0sum(58),[G0tensor(1)])
  call ol_merge_tensors(T0sum(59),[G0tensor(2)])
  call ol_merge_tensors(T0sum(60),[G0tensor(3)])
  call ol_merge_tensors(T0sum(61),[G0tensor(4)])
  call ol_merge_tensors(T0sum(62),[G0tensor(5)])
  call ol_merge_tensors(T0sum(63),[G0tensor(6)])
  call ol_merge_tensors(T0sum(64),[G0tensor(7)])
  call ol_merge_tensors(T0sum(65),[G0tensor(8)])
  call ol_merge_tensors(T0sum(66),[G0tensor(9)])
  call ol_merge_tensors(T0sum(67),[G0tensor(10)])
  call ol_merge_tensors(T0sum(68),[G0tensor(11)])
  call ol_merge_tensors(T0sum(69),[G0tensor(12)])
  call ol_merge_tensors(T0sum(70),[G0tensor(13)])
  call ol_merge_tensors(T0sum(71),[G0tensor(14)])
  call ol_merge_tensors(T0sum(72),[G0tensor(15)])
  call ol_merge_tensors(T0sum(73),[G0tensor(16)])
  call ol_merge_tensors(T0sum(74),[G0tensor(17)])
  call ol_merge_tensors(T0sum(75),[G0tensor(18)])
  call ol_merge_tensors(T0sum(76),[G0tensor(304)])
  call ol_merge_tensors(T0sum(77),[G0tensor(309)])
  call ol_merge_tensors(T0sum(78),[G0tensor(314)])
  call ol_merge_tensors(T0sum(79),[G0tensor(319)])
  call ol_merge_tensors(T0sum(80),[G0tensor(324)])
  call ol_merge_tensors(T0sum(81),[G0tensor(329)])
  call ol_merge_tensors(T0sum(82),[G0tensor(334)])
  call ol_merge_tensors(T0sum(83),[G0tensor(339)])
  call ol_merge_tensors(T0sum(84),[G0tensor(344)])
  call ol_merge_tensors(T0sum(85),[G0tensor(349)])
  call ol_merge_tensors(T0sum(86),[G0tensor(354)])
  call ol_merge_tensors(T0sum(87),[G0tensor(359)])
  call ol_merge_tensors(T0sum(88),[G0tensor(364)])
  call ol_merge_tensors(T0sum(89),[G0tensor(369)])
  call ol_merge_tensors(T0sum(90),[G0tensor(374)])
  call ol_merge_tensors(T0sum(91),[G0tensor(379)])
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(208)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(481),h0tab(:,481),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,57),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,449),heltab2x128(:,:,481))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(1),n2h64(369))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(208)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(482),h0tab(:,482),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,57),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,450),heltab2x128(:,:,482))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(3),n2h64(370))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(208)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(483),h0tab(:,483),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,57),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,451),heltab2x128(:,:,483))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(33),n2h64(371))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(208)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(484),h0tab(:,484),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,57),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,452),heltab2x128(:,:,484))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(35),n2h64(372))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(690)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(485),h0tab(:,485),[80,10,37],[0,0,0],3,3,wf4(:,4),wf4(:,2),wf8(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,33),heltab2x128(:,:,485))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(3),n2h32(161))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(691)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(486),h0tab(:,486),[80,10,37],[0,0,0],3,3,wf4(:,4),wf4(:,6),wf8(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,34),heltab2x128(:,:,486))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(9),n2h32(162))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(692)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(487),h0tab(:,487),[80,10,37],[0,0,0],3,3,wf4(:,4),wf4(:,2),wf8(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,35),heltab2x128(:,:,487))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(21),n2h32(163))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(693)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(488),h0tab(:,488),[80,10,37],[0,0,0],3,3,wf4(:,4),wf4(:,6),wf8(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,36),heltab2x128(:,:,488))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(27),n2h32(164))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(694)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(489),h0tab(:,489),[80,5,42],[0,0,0],3,3,wf4(:,4),wf4(:,1),wf8(:,6))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,37),heltab2x128(:,:,489))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(33),n2h32(165))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(695)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(490),h0tab(:,490),[80,5,42],[0,0,0],3,3,wf4(:,4),wf4(:,1),wf8(:,8))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,38),heltab2x128(:,:,490))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(39),n2h32(166))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(696)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(491),h0tab(:,491),[80,5,42],[0,0,0],3,3,wf4(:,4),wf4(:,8),wf8(:,6))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,39),heltab2x128(:,:,491))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(51),n2h32(167))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(697)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(492),h0tab(:,492),[80,5,42],[0,0,0],3,3,wf4(:,4),wf4(:,8),wf8(:,8))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,40),heltab2x128(:,:,492))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(57),n2h32(168))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(223)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(493),h0tab(:,493),[85,10,32],[0,0,0],3,2,wf16(:,78),wf4(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,78),G0H8(1),m3h16x8(:,1),heltab2x128(:,:,493))
  call Hloop_Q_A(ntryL,G0H8(1),85,0,G1H8(17),n2h8(217))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(224)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(494),h0tab(:,494),[85,10,32],[0,0,0],3,2,wf16(:,78),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,78),G0H8(1),m3h16x8(:,2),heltab2x128(:,:,494))
  call Hloop_Q_A(ntryL,G0H8(1),85,0,G1H8(18),n2h8(218))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(226)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(495),h0tab(:,495),[85,10,32],[0,0,0],3,2,wf16(:,79),wf4(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,79),G0H8(1),m3h16x8(:,3),heltab2x128(:,:,495))
  call Hloop_Q_A(ntryL,G0H8(1),85,0,G1H8(20),n2h8(219))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(227)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(496),h0tab(:,496),[85,10,32],[0,0,0],3,2,wf16(:,79),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,79),G0H8(1),m3h16x8(:,4),heltab2x128(:,:,496))
  call Hloop_Q_A(ntryL,G0H8(1),85,0,G1H8(23),n2h8(220))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(230)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(497),h0tab(:,497),[90,5,32],[0,0,0],3,2,wf16(:,80),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,80),G0H8(1),m3h16x8(:,5),heltab2x128(:,:,497))
  call Hloop_Q_A(ntryL,G0H8(1),90,0,G1H8(24),n2h8(221))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(498),h0tab(:,498),[90,5,32],[0,0,0],3,2,wf16(:,81),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,81),G0H8(1),m3h16x8(:,6),heltab2x128(:,:,498))
  call Hloop_Q_A(ntryL,G0H8(1),90,0,G1H8(25),n2h8(222))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(499),h0tab(:,499),[90,5,32],[0,0,0],3,2,wf16(:,80),wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,80),G0H8(1),m3h16x8(:,7),heltab2x128(:,:,499))
  call Hloop_Q_A(ntryL,G0H8(1),90,0,G1H8(29),n2h8(223))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(500),h0tab(:,500),[90,5,32],[0,0,0],3,2,wf16(:,81),wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,81),G0H8(1),m3h16x8(:,8),heltab2x128(:,:,500))
  call Hloop_Q_A(ntryL,G0H8(1),90,0,G1H8(30),n2h8(224))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(702)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(501),h0tab(:,501),[96,10,21],[0,0,0],3,3,wf4(:,10),wf4(:,2),wf8(:,10))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,41),heltab2x128(:,:,501))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(63),n2h32(169))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(703)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(502),h0tab(:,502),[96,10,21],[0,0,0],3,3,wf4(:,10),wf4(:,6),wf8(:,10))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,42),heltab2x128(:,:,502))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(69),n2h32(170))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(704)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(503),h0tab(:,503),[96,10,21],[0,0,0],3,3,wf4(:,10),wf4(:,2),wf8(:,12))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,43),heltab2x128(:,:,503))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(81),n2h32(171))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(705)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(504),h0tab(:,504),[96,10,21],[0,0,0],3,3,wf4(:,10),wf4(:,6),wf8(:,12))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,44),heltab2x128(:,:,504))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(87),n2h32(172))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(706)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(505),h0tab(:,505),[96,5,26],[0,0,0],3,3,wf4(:,10),wf4(:,1),wf8(:,14))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,45),heltab2x128(:,:,505))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(93),n2h32(173))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(707)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(506),h0tab(:,506),[96,5,26],[0,0,0],3,3,wf4(:,10),wf4(:,1),wf8(:,16))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,46),heltab2x128(:,:,506))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(6),n2h32(174))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(708)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(507),h0tab(:,507),[96,5,26],[0,0,0],3,3,wf4(:,10),wf4(:,8),wf8(:,14))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,47),heltab2x128(:,:,507))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(8),n2h32(175))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(709)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(508),h0tab(:,508),[96,5,26],[0,0,0],3,3,wf4(:,10),wf4(:,8),wf8(:,16))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,48),heltab2x128(:,:,508))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(10),n2h32(176))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(237)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(509),h0tab(:,509),[101,10,16],[0,0,0],3,2,wf16(:,86),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,86),G0H8(1),m3h16x8(:,9),heltab2x128(:,:,509))
  call Hloop_A_Q(ntryL,G0H8(1),101,0,G1H8(31),n2h8(225))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(238)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(510),h0tab(:,510),[101,10,16],[0,0,0],3,2,wf16(:,86),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,86),G0H8(1),m3h16x8(:,10),heltab2x128(:,:,510))
  call Hloop_A_Q(ntryL,G0H8(1),101,0,G1H8(32),n2h8(226))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(240)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(511),h0tab(:,511),[101,10,16],[0,0,0],3,2,wf16(:,87),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,87),G0H8(1),m3h16x8(:,11),heltab2x128(:,:,511))
  call Hloop_A_Q(ntryL,G0H8(1),101,0,G1H8(36),n2h8(227))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(241)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(512),h0tab(:,512),[101,10,16],[0,0,0],3,2,wf16(:,87),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,87),G0H8(1),m3h16x8(:,12),heltab2x128(:,:,512))
  call Hloop_A_Q(ntryL,G0H8(1),101,0,G1H8(37),n2h8(228))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(244)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(513),h0tab(:,513),[106,5,16],[0,0,0],3,2,wf16(:,88),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,88),G0H8(1),m3h16x8(:,13),heltab2x128(:,:,513))
  call Hloop_A_Q(ntryL,G0H8(1),106,0,G1H8(38),n2h8(229))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(246)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(514),h0tab(:,514),[106,5,16],[0,0,0],3,2,wf16(:,89),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,89),G0H8(1),m3h16x8(:,14),heltab2x128(:,:,514))
  call Hloop_A_Q(ntryL,G0H8(1),106,0,G1H8(41),n2h8(230))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(247)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(515),h0tab(:,515),[106,5,16],[0,0,0],3,2,wf16(:,88),wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,88),G0H8(1),m3h16x8(:,15),heltab2x128(:,:,515))
  call Hloop_A_Q(ntryL,G0H8(1),106,0,G1H8(43),n2h8(231))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(248)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(516),h0tab(:,516),[106,5,16],[0,0,0],3,2,wf16(:,89),wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,89),G0H8(1),m3h16x8(:,16),heltab2x128(:,:,516))
  call Hloop_A_Q(ntryL,G0H8(1),106,0,G1H8(44),n2h8(232))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(517),h0tab(:,517),[64,21,42],[0,0,0],3,2,wf8(:,10),wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,453),heltab2x128(:,:,517))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(65),n2h64(373))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(518),h0tab(:,518),[64,21,42],[0,0,0],3,2,wf8(:,10),wf8(:,8))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,454),heltab2x128(:,:,518))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(67),n2h64(374))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(519),h0tab(:,519),[64,21,42],[0,0,0],3,2,wf8(:,12),wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,455),heltab2x128(:,:,519))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(169),n2h64(375))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(520),h0tab(:,520),[64,21,42],[0,0,0],3,2,wf8(:,12),wf8(:,8))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,456),heltab2x128(:,:,520))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(171),n2h64(376))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(521),h0tab(:,521),[64,21,42],[0,0,0],3,2,wf8(:,10),wf8(:,6))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(201),m3h2x64(:,457),heltab2x128(:,:,521))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(522),h0tab(:,522),[64,21,42],[0,0,0],3,2,wf8(:,10),wf8(:,8))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(203),m3h2x64(:,458),heltab2x128(:,:,522))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(523),h0tab(:,523),[64,21,42],[0,0,0],3,2,wf8(:,12),wf8(:,6))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(233),m3h2x64(:,459),heltab2x128(:,:,523))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(524),h0tab(:,524),[64,21,42],[0,0,0],3,2,wf8(:,12),wf8(:,8))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(235),m3h2x64(:,460),heltab2x128(:,:,524))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(714)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(525),h0tab(:,525),[64,10,53],[0,0,0],3,2,wf4(:,2),wf16(:,68))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,461),heltab2x128(:,:,525))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(5),n2h64(377))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(714)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(526),h0tab(:,526),[64,10,53],[nMT,nMT,nMT],3,2,wf4(:,2),wf16(:,68))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,462),heltab2x128(:,:,526))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(2),n2h64(378))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(714)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(527),h0tab(:,527),[64,10,53],[0,0,0],3,2,wf4(:,2),wf16(:,68))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,463),heltab2x128(:,:,527))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(7),n2h64(379))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(714)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(528),h0tab(:,528),[64,10,53],[nMT,nMT,nMT],3,2,wf4(:,2),wf16(:,68))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,464),heltab2x128(:,:,528))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(4),n2h64(380))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(714)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(529),h0tab(:,529),[64,10,53],[0,0,0],3,2,wf4(:,2),wf16(:,68))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,465),heltab2x128(:,:,529))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(6),n2h64(381))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(714)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(530),h0tab(:,530),[64,10,53],[nMB,nMB,nMB],3,2,wf4(:,2),wf16(:,68))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,466),heltab2x128(:,:,530))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(8),n2h64(382))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(714)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(531),h0tab(:,531),[64,10,53],[0,0,0],3,2,wf4(:,2),wf16(:,68))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,467),heltab2x128(:,:,531))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(9),n2h64(383))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(714)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(532),h0tab(:,532),[64,10,53],[nMB,nMB,nMB],3,2,wf4(:,2),wf16(:,68))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,468),heltab2x128(:,:,532))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(10),n2h64(384))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(715)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(533),h0tab(:,533),[64,10,53],[0,0,0],3,2,wf4(:,6),wf16(:,68))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,469),heltab2x128(:,:,533))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(11),n2h64(385))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(715)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(534),h0tab(:,534),[64,10,53],[nMT,nMT,nMT],3,2,wf4(:,6),wf16(:,68))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,470),heltab2x128(:,:,534))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(12),n2h64(386))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(715)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(535),h0tab(:,535),[64,10,53],[0,0,0],3,2,wf4(:,6),wf16(:,68))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,471),heltab2x128(:,:,535))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(13),n2h64(387))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(715)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(536),h0tab(:,536),[64,10,53],[nMT,nMT,nMT],3,2,wf4(:,6),wf16(:,68))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,472),heltab2x128(:,:,536))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(14),n2h64(388))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(715)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(537),h0tab(:,537),[64,10,53],[0,0,0],3,2,wf4(:,6),wf16(:,68))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,473),heltab2x128(:,:,537))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(15),n2h64(389))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(715)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(538),h0tab(:,538),[64,10,53],[nMB,nMB,nMB],3,2,wf4(:,6),wf16(:,68))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,474),heltab2x128(:,:,538))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(16),n2h64(390))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(715)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(539),h0tab(:,539),[64,10,53],[0,0,0],3,2,wf4(:,6),wf16(:,68))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,475),heltab2x128(:,:,539))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(17),n2h64(391))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(715)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(540),h0tab(:,540),[64,10,53],[nMB,nMB,nMB],3,2,wf4(:,6),wf16(:,68))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,476),heltab2x128(:,:,540))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(18),n2h64(392))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(716)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(541),h0tab(:,541),[64,10,53],[0,0,0],3,2,wf4(:,2),wf16(:,69))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,477),heltab2x128(:,:,541))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(19),n2h64(393))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(716)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(542),h0tab(:,542),[64,10,53],[nMT,nMT,nMT],3,2,wf4(:,2),wf16(:,69))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,478),heltab2x128(:,:,542))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(20),n2h64(394))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(716)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(543),h0tab(:,543),[64,10,53],[0,0,0],3,2,wf4(:,2),wf16(:,69))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,479),heltab2x128(:,:,543))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(21),n2h64(395))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(716)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(544),h0tab(:,544),[64,10,53],[nMT,nMT,nMT],3,2,wf4(:,2),wf16(:,69))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,480),heltab2x128(:,:,544))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(22),n2h64(396))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(716)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(545),h0tab(:,545),[64,10,53],[0,0,0],3,2,wf4(:,2),wf16(:,69))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,481),heltab2x128(:,:,545))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(23),n2h64(397))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(716)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(546),h0tab(:,546),[64,10,53],[nMB,nMB,nMB],3,2,wf4(:,2),wf16(:,69))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,482),heltab2x128(:,:,546))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(24),n2h64(398))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(716)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(547),h0tab(:,547),[64,10,53],[0,0,0],3,2,wf4(:,2),wf16(:,69))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,483),heltab2x128(:,:,547))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(25),n2h64(399))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(716)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(548),h0tab(:,548),[64,10,53],[nMB,nMB,nMB],3,2,wf4(:,2),wf16(:,69))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,484),heltab2x128(:,:,548))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(26),n2h64(400))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(717)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(549),h0tab(:,549),[64,10,53],[0,0,0],3,2,wf4(:,6),wf16(:,69))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,485),heltab2x128(:,:,549))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(27),n2h64(401))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(717)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(550),h0tab(:,550),[64,10,53],[nMT,nMT,nMT],3,2,wf4(:,6),wf16(:,69))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,486),heltab2x128(:,:,550))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(28),n2h64(402))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(717)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(551),h0tab(:,551),[64,10,53],[0,0,0],3,2,wf4(:,6),wf16(:,69))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,487),heltab2x128(:,:,551))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(29),n2h64(403))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(717)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(552),h0tab(:,552),[64,10,53],[nMT,nMT,nMT],3,2,wf4(:,6),wf16(:,69))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,488),heltab2x128(:,:,552))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(30),n2h64(404))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(717)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(553),h0tab(:,553),[64,10,53],[0,0,0],3,2,wf4(:,6),wf16(:,69))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,489),heltab2x128(:,:,553))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(31),n2h64(405))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(717)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(554),h0tab(:,554),[64,10,53],[nMB,nMB,nMB],3,2,wf4(:,6),wf16(:,69))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,490),heltab2x128(:,:,554))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(32),n2h64(406))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(717)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(555),h0tab(:,555),[64,10,53],[0,0,0],3,2,wf4(:,6),wf16(:,69))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,491),heltab2x128(:,:,555))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(37),n2h64(407))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(717)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(556),h0tab(:,556),[64,10,53],[nMB,nMB,nMB],3,2,wf4(:,6),wf16(:,69))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,492),heltab2x128(:,:,556))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(34),n2h64(408))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(718)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(557),h0tab(:,557),[85,10,32],[0,0,0],3,2,wf16(:,155),wf4(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,155),G0H8(1),m3h16x8(:,17),heltab2x128(:,:,557))
  call Hloop_Q_A(ntryL,G0H8(1),85,0,G1H8(47),n2h8(233))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(719)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(558),h0tab(:,558),[85,10,32],[0,0,0],3,2,wf16(:,155),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,155),G0H8(1),m3h16x8(:,18),heltab2x128(:,:,558))
  call Hloop_Q_A(ntryL,G0H8(1),85,0,G1H8(48),n2h8(234))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(720)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(559),h0tab(:,559),[85,10,32],[0,0,0],3,2,wf16(:,156),wf4(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,156),G0H8(1),m3h16x8(:,19),heltab2x128(:,:,559))
  call Hloop_Q_A(ntryL,G0H8(1),85,0,G1H8(99),n2h8(235))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(721)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(560),h0tab(:,560),[85,10,32],[0,0,0],3,2,wf16(:,156),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,156),G0H8(1),m3h16x8(:,20),heltab2x128(:,:,560))
  call Hloop_Q_A(ntryL,G0H8(1),85,0,G1H8(51),n2h8(236))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(541)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(561),h0tab(:,561),[64,31,32],[0,0,0],3,1,wf32(:,10))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,493),heltab2x128(:,:,561))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(39),n2h64(409))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(543)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(562),h0tab(:,562),[64,31,32],[0,0,0],3,1,wf32(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,494),heltab2x128(:,:,562))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(36),n2h64(410))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(545)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(563),h0tab(:,563),[64,31,32],[0,0,0],3,1,wf32(:,14))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,495),heltab2x128(:,:,563))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(38),n2h64(411))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(547)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(564),h0tab(:,564),[64,31,32],[0,0,0],3,1,wf32(:,16))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,496),heltab2x128(:,:,564))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(40),n2h64(412))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(541)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(565),h0tab(:,565),[64,31,32],[0,0,0],3,1,wf32(:,10))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(41),m3h2x64(:,497),heltab2x128(:,:,565))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(543)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(566),h0tab(:,566),[64,31,32],[0,0,0],3,1,wf32(:,12))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(42),m3h2x64(:,498),heltab2x128(:,:,566))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(545)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(567),h0tab(:,567),[64,31,32],[0,0,0],3,1,wf32(:,14))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(43),m3h2x64(:,499),heltab2x128(:,:,567))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(547)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(568),h0tab(:,568),[64,31,32],[0,0,0],3,1,wf32(:,16))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(44),m3h2x64(:,500),heltab2x128(:,:,568))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(569),h0tab(:,569),[64,26,37],[0,0,0],3,2,wf8(:,14),wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,501),heltab2x128(:,:,569))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(45),n2h64(413))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(570),h0tab(:,570),[64,26,37],[0,0,0],3,2,wf8(:,16),wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,502),heltab2x128(:,:,570))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(46),n2h64(414))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(571),h0tab(:,571),[64,26,37],[0,0,0],3,2,wf8(:,14),wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,503),heltab2x128(:,:,571))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(47),n2h64(415))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(572),h0tab(:,572),[64,26,37],[0,0,0],3,2,wf8(:,16),wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,504),heltab2x128(:,:,572))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(48),n2h64(416))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(573),h0tab(:,573),[64,26,37],[0,0,0],3,2,wf8(:,14),wf8(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(49),m3h2x64(:,505),heltab2x128(:,:,573))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(574),h0tab(:,574),[64,26,37],[0,0,0],3,2,wf8(:,16),wf8(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(50),m3h2x64(:,506),heltab2x128(:,:,574))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(575),h0tab(:,575),[64,26,37],[0,0,0],3,2,wf8(:,14),wf8(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(51),m3h2x64(:,507),heltab2x128(:,:,575))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(576),h0tab(:,576),[64,26,37],[0,0,0],3,2,wf8(:,16),wf8(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(52),m3h2x64(:,508),heltab2x128(:,:,576))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(722)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(577),h0tab(:,577),[64,10,53],[0,0,0],3,2,wf4(:,2),wf16(:,72))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,509),heltab2x128(:,:,577))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(53),n2h64(417))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(722)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(578),h0tab(:,578),[64,10,53],[nMT,nMT,nMT],3,2,wf4(:,2),wf16(:,72))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,510),heltab2x128(:,:,578))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(54),n2h64(418))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(722)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(579),h0tab(:,579),[64,10,53],[0,0,0],3,2,wf4(:,2),wf16(:,72))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,511),heltab2x128(:,:,579))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(55),n2h64(419))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(722)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(580),h0tab(:,580),[64,10,53],[nMT,nMT,nMT],3,2,wf4(:,2),wf16(:,72))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,512),heltab2x128(:,:,580))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(56),n2h64(420))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(722)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(581),h0tab(:,581),[64,10,53],[0,0,0],3,2,wf4(:,2),wf16(:,72))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,513),heltab2x128(:,:,581))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(57),n2h64(421))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(722)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(582),h0tab(:,582),[64,10,53],[nMB,nMB,nMB],3,2,wf4(:,2),wf16(:,72))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,514),heltab2x128(:,:,582))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(58),n2h64(422))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(722)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(583),h0tab(:,583),[64,10,53],[0,0,0],3,2,wf4(:,2),wf16(:,72))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,515),heltab2x128(:,:,583))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(59),n2h64(423))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(722)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(584),h0tab(:,584),[64,10,53],[nMB,nMB,nMB],3,2,wf4(:,2),wf16(:,72))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,516),heltab2x128(:,:,584))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(60),n2h64(424))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(723)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(585),h0tab(:,585),[64,10,53],[0,0,0],3,2,wf4(:,6),wf16(:,72))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,517),heltab2x128(:,:,585))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(61),n2h64(425))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(723)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(586),h0tab(:,586),[64,10,53],[nMT,nMT,nMT],3,2,wf4(:,6),wf16(:,72))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,518),heltab2x128(:,:,586))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(62),n2h64(426))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(723)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(587),h0tab(:,587),[64,10,53],[0,0,0],3,2,wf4(:,6),wf16(:,72))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,519),heltab2x128(:,:,587))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(63),n2h64(427))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(723)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(588),h0tab(:,588),[64,10,53],[nMT,nMT,nMT],3,2,wf4(:,6),wf16(:,72))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,520),heltab2x128(:,:,588))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(64),n2h64(428))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(723)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(589),h0tab(:,589),[64,10,53],[0,0,0],3,2,wf4(:,6),wf16(:,72))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,521),heltab2x128(:,:,589))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(69),n2h64(429))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(723)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(590),h0tab(:,590),[64,10,53],[nMB,nMB,nMB],3,2,wf4(:,6),wf16(:,72))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,522),heltab2x128(:,:,590))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(66),n2h64(430))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(723)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(591),h0tab(:,591),[64,10,53],[0,0,0],3,2,wf4(:,6),wf16(:,72))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,523),heltab2x128(:,:,591))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(71),n2h64(431))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(723)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(592),h0tab(:,592),[64,10,53],[nMB,nMB,nMB],3,2,wf4(:,6),wf16(:,72))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,524),heltab2x128(:,:,592))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(68),n2h64(432))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(724)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(593),h0tab(:,593),[64,10,53],[0,0,0],3,2,wf4(:,2),wf16(:,73))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,525),heltab2x128(:,:,593))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(70),n2h64(433))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(724)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(594),h0tab(:,594),[64,10,53],[nMT,nMT,nMT],3,2,wf4(:,2),wf16(:,73))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,526),heltab2x128(:,:,594))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(72),n2h64(434))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(724)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(595),h0tab(:,595),[64,10,53],[0,0,0],3,2,wf4(:,2),wf16(:,73))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,527),heltab2x128(:,:,595))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(73),n2h64(435))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(724)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(596),h0tab(:,596),[64,10,53],[nMT,nMT,nMT],3,2,wf4(:,2),wf16(:,73))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,528),heltab2x128(:,:,596))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(74),n2h64(436))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(724)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(597),h0tab(:,597),[64,10,53],[0,0,0],3,2,wf4(:,2),wf16(:,73))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,529),heltab2x128(:,:,597))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(75),n2h64(437))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(724)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(598),h0tab(:,598),[64,10,53],[nMB,nMB,nMB],3,2,wf4(:,2),wf16(:,73))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,530),heltab2x128(:,:,598))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(76),n2h64(438))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(724)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(599),h0tab(:,599),[64,10,53],[0,0,0],3,2,wf4(:,2),wf16(:,73))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,531),heltab2x128(:,:,599))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(77),n2h64(439))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(724)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(600),h0tab(:,600),[64,10,53],[nMB,nMB,nMB],3,2,wf4(:,2),wf16(:,73))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,532),heltab2x128(:,:,600))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(78),n2h64(440))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(725)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(601),h0tab(:,601),[64,10,53],[0,0,0],3,2,wf4(:,6),wf16(:,73))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,533),heltab2x128(:,:,601))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(79),n2h64(441))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(725)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(602),h0tab(:,602),[64,10,53],[nMT,nMT,nMT],3,2,wf4(:,6),wf16(:,73))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,534),heltab2x128(:,:,602))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(80),n2h64(442))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(725)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(603),h0tab(:,603),[64,10,53],[0,0,0],3,2,wf4(:,6),wf16(:,73))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,535),heltab2x128(:,:,603))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(81),n2h64(443))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(725)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(604),h0tab(:,604),[64,10,53],[nMT,nMT,nMT],3,2,wf4(:,6),wf16(:,73))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,536),heltab2x128(:,:,604))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(82),n2h64(444))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(725)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(605),h0tab(:,605),[64,10,53],[0,0,0],3,2,wf4(:,6),wf16(:,73))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,537),heltab2x128(:,:,605))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(83),n2h64(445))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(725)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(606),h0tab(:,606),[64,10,53],[nMB,nMB,nMB],3,2,wf4(:,6),wf16(:,73))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,538),heltab2x128(:,:,606))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(84),n2h64(446))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(725)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(607),h0tab(:,607),[64,10,53],[0,0,0],3,2,wf4(:,6),wf16(:,73))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,539),heltab2x128(:,:,607))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(85),n2h64(447))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(725)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(608),h0tab(:,608),[64,10,53],[nMB,nMB,nMB],3,2,wf4(:,6),wf16(:,73))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,540),heltab2x128(:,:,608))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(86),n2h64(448))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(726)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(609),h0tab(:,609),[101,10,16],[0,0,0],3,2,wf16(:,152),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,152),G0H8(1),m3h16x8(:,21),heltab2x128(:,:,609))
  call Hloop_A_Q(ntryL,G0H8(1),101,0,G1H8(67),n2h8(237))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(727)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(610),h0tab(:,610),[101,10,16],[0,0,0],3,2,wf16(:,152),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,152),G0H8(1),m3h16x8(:,22),heltab2x128(:,:,610))
  call Hloop_A_Q(ntryL,G0H8(1),101,0,G1H8(52),n2h8(238))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(728)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(611),h0tab(:,611),[101,10,16],[0,0,0],3,2,wf16(:,154),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,154),G0H8(1),m3h16x8(:,23),heltab2x128(:,:,611))
  call Hloop_A_Q(ntryL,G0H8(1),101,0,G1H8(84),n2h8(239))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(729)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(612),h0tab(:,612),[101,10,16],[0,0,0],3,2,wf16(:,154),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,154),G0H8(1),m3h16x8(:,24),heltab2x128(:,:,612))
  call Hloop_A_Q(ntryL,G0H8(1),101,0,G1H8(100),n2h8(240))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(552)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(613),h0tab(:,613),[64,16,47],[0,0,0],3,1,wf32(:,18))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,541),heltab2x128(:,:,613))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(87),n2h64(449))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(554)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(614),h0tab(:,614),[64,16,47],[0,0,0],3,1,wf32(:,20))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,542),heltab2x128(:,:,614))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(88),n2h64(450))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(556)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(615),h0tab(:,615),[64,16,47],[0,0,0],3,1,wf32(:,22))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,543),heltab2x128(:,:,615))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(89),n2h64(451))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(558)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(616),h0tab(:,616),[64,16,47],[0,0,0],3,1,wf32(:,24))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,544),heltab2x128(:,:,616))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(90),n2h64(452))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(552)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(617),h0tab(:,617),[64,16,47],[0,0,0],3,1,wf32(:,18))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(91),m3h2x64(:,545),heltab2x128(:,:,617))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(554)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(618),h0tab(:,618),[64,16,47],[0,0,0],3,1,wf32(:,20))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(92),m3h2x64(:,546),heltab2x128(:,:,618))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(556)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(619),h0tab(:,619),[64,16,47],[0,0,0],3,1,wf32(:,22))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(93),m3h2x64(:,547),heltab2x128(:,:,619))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(558)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(620),h0tab(:,620),[64,16,47],[0,0,0],3,1,wf32(:,24))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(94),m3h2x64(:,548),heltab2x128(:,:,620))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(730)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(621),h0tab(:,621),[64,5,58],[0,0,0],3,2,wf4(:,1),wf16(:,74))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,549),heltab2x128(:,:,621))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(95),n2h64(453))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(730)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(622),h0tab(:,622),[64,5,58],[nMT,nMT,nMT],3,2,wf4(:,1),wf16(:,74))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,550),heltab2x128(:,:,622))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(96),n2h64(454))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(730)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(623),h0tab(:,623),[64,5,58],[0,0,0],3,2,wf4(:,1),wf16(:,74))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,551),heltab2x128(:,:,623))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(97),n2h64(455))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(730)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(624),h0tab(:,624),[64,5,58],[nMT,nMT,nMT],3,2,wf4(:,1),wf16(:,74))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,552),heltab2x128(:,:,624))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(98),n2h64(456))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(730)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(625),h0tab(:,625),[64,5,58],[0,0,0],3,2,wf4(:,1),wf16(:,74))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,553),heltab2x128(:,:,625))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(99),n2h64(457))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(730)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(626),h0tab(:,626),[64,5,58],[nMB,nMB,nMB],3,2,wf4(:,1),wf16(:,74))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,554),heltab2x128(:,:,626))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(100),n2h64(458))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(730)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(627),h0tab(:,627),[64,5,58],[0,0,0],3,2,wf4(:,1),wf16(:,74))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,555),heltab2x128(:,:,627))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(101),n2h64(459))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(730)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(628),h0tab(:,628),[64,5,58],[nMB,nMB,nMB],3,2,wf4(:,1),wf16(:,74))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,556),heltab2x128(:,:,628))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(102),n2h64(460))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(731)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(629),h0tab(:,629),[64,5,58],[0,0,0],3,2,wf4(:,1),wf16(:,75))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,557),heltab2x128(:,:,629))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(103),n2h64(461))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(731)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(630),h0tab(:,630),[64,5,58],[nMT,nMT,nMT],3,2,wf4(:,1),wf16(:,75))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,558),heltab2x128(:,:,630))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(104),n2h64(462))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(731)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(631),h0tab(:,631),[64,5,58],[0,0,0],3,2,wf4(:,1),wf16(:,75))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,559),heltab2x128(:,:,631))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(105),n2h64(463))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(731)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(632),h0tab(:,632),[64,5,58],[nMT,nMT,nMT],3,2,wf4(:,1),wf16(:,75))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,560),heltab2x128(:,:,632))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(106),n2h64(464))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(731)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(633),h0tab(:,633),[64,5,58],[0,0,0],3,2,wf4(:,1),wf16(:,75))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,561),heltab2x128(:,:,633))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(107),n2h64(465))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(731)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(634),h0tab(:,634),[64,5,58],[nMB,nMB,nMB],3,2,wf4(:,1),wf16(:,75))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,562),heltab2x128(:,:,634))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(108),n2h64(466))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(731)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(635),h0tab(:,635),[64,5,58],[0,0,0],3,2,wf4(:,1),wf16(:,75))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,563),heltab2x128(:,:,635))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(109),n2h64(467))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(731)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(636),h0tab(:,636),[64,5,58],[nMB,nMB,nMB],3,2,wf4(:,1),wf16(:,75))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,564),heltab2x128(:,:,636))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(110),n2h64(468))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(732)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(637),h0tab(:,637),[64,5,58],[0,0,0],3,2,wf4(:,8),wf16(:,74))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,565),heltab2x128(:,:,637))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(111),n2h64(469))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(732)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(638),h0tab(:,638),[64,5,58],[nMT,nMT,nMT],3,2,wf4(:,8),wf16(:,74))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,566),heltab2x128(:,:,638))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(112),n2h64(470))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(732)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(639),h0tab(:,639),[64,5,58],[0,0,0],3,2,wf4(:,8),wf16(:,74))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,567),heltab2x128(:,:,639))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(113),n2h64(471))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(732)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(640),h0tab(:,640),[64,5,58],[nMT,nMT,nMT],3,2,wf4(:,8),wf16(:,74))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,568),heltab2x128(:,:,640))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(114),n2h64(472))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(732)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(641),h0tab(:,641),[64,5,58],[0,0,0],3,2,wf4(:,8),wf16(:,74))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,569),heltab2x128(:,:,641))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(115),n2h64(473))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(732)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(642),h0tab(:,642),[64,5,58],[nMB,nMB,nMB],3,2,wf4(:,8),wf16(:,74))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,570),heltab2x128(:,:,642))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(116),n2h64(474))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(732)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(643),h0tab(:,643),[64,5,58],[0,0,0],3,2,wf4(:,8),wf16(:,74))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,571),heltab2x128(:,:,643))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(117),n2h64(475))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(732)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(644),h0tab(:,644),[64,5,58],[nMB,nMB,nMB],3,2,wf4(:,8),wf16(:,74))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,572),heltab2x128(:,:,644))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(118),n2h64(476))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(733)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(645),h0tab(:,645),[64,5,58],[0,0,0],3,2,wf4(:,8),wf16(:,75))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,573),heltab2x128(:,:,645))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(119),n2h64(477))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(733)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(646),h0tab(:,646),[64,5,58],[nMT,nMT,nMT],3,2,wf4(:,8),wf16(:,75))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,574),heltab2x128(:,:,646))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(120),n2h64(478))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(733)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(647),h0tab(:,647),[64,5,58],[0,0,0],3,2,wf4(:,8),wf16(:,75))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,575),heltab2x128(:,:,647))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(121),n2h64(479))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(733)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(648),h0tab(:,648),[64,5,58],[nMT,nMT,nMT],3,2,wf4(:,8),wf16(:,75))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,576),heltab2x128(:,:,648))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(122),n2h64(480))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(733)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(649),h0tab(:,649),[64,5,58],[0,0,0],3,2,wf4(:,8),wf16(:,75))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,577),heltab2x128(:,:,649))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(123),n2h64(481))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(733)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(650),h0tab(:,650),[64,5,58],[nMB,nMB,nMB],3,2,wf4(:,8),wf16(:,75))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,578),heltab2x128(:,:,650))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(124),n2h64(482))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(733)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(651),h0tab(:,651),[64,5,58],[0,0,0],3,2,wf4(:,8),wf16(:,75))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,579),heltab2x128(:,:,651))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(125),n2h64(483))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(733)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(652),h0tab(:,652),[64,5,58],[nMB,nMB,nMB],3,2,wf4(:,8),wf16(:,75))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,580),heltab2x128(:,:,652))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(126),n2h64(484))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(734)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(653),h0tab(:,653),[90,5,32],[0,0,0],3,2,wf16(:,157),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,157),G0H8(1),m3h16x8(:,25),heltab2x128(:,:,653))
  call Hloop_Q_A(ntryL,G0H8(1),90,0,G1H8(147),n2h8(241))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(735)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(654),h0tab(:,654),[90,5,32],[0,0,0],3,2,wf16(:,158),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,158),G0H8(1),m3h16x8(:,26),heltab2x128(:,:,654))
  call Hloop_Q_A(ntryL,G0H8(1),90,0,G1H8(163),n2h8(242))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(736)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(655),h0tab(:,655),[90,5,32],[0,0,0],3,2,wf16(:,157),wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,157),G0H8(1),m3h16x8(:,27),heltab2x128(:,:,655))
  call Hloop_Q_A(ntryL,G0H8(1),90,0,G1H8(115),n2h8(243))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(737)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(656),h0tab(:,656),[90,5,32],[0,0,0],3,2,wf16(:,158),wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,158),G0H8(1),m3h16x8(:,28),heltab2x128(:,:,656))
  call Hloop_Q_A(ntryL,G0H8(1),90,0,G1H8(131),n2h8(244))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(563)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(657),h0tab(:,657),[64,31,32],[0,0,0],3,1,wf32(:,26))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,581),heltab2x128(:,:,657))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(127),n2h64(485))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(565)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(658),h0tab(:,658),[64,31,32],[0,0,0],3,1,wf32(:,28))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,582),heltab2x128(:,:,658))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(128),n2h64(486))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(567)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(659),h0tab(:,659),[64,31,32],[0,0,0],3,1,wf32(:,30))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,583),heltab2x128(:,:,659))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(129),n2h64(487))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(569)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(660),h0tab(:,660),[64,31,32],[0,0,0],3,1,wf32(:,32))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,584),heltab2x128(:,:,660))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(130),n2h64(488))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(563)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(661),h0tab(:,661),[64,31,32],[0,0,0],3,1,wf32(:,26))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(131),m3h2x64(:,585),heltab2x128(:,:,661))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(565)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(662),h0tab(:,662),[64,31,32],[0,0,0],3,1,wf32(:,28))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(132),m3h2x64(:,586),heltab2x128(:,:,662))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(567)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(663),h0tab(:,663),[64,31,32],[0,0,0],3,1,wf32(:,30))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(133),m3h2x64(:,587),heltab2x128(:,:,663))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(569)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(664),h0tab(:,664),[64,31,32],[0,0,0],3,1,wf32(:,32))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(134),m3h2x64(:,588),heltab2x128(:,:,664))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(738)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(665),h0tab(:,665),[64,5,58],[0,0,0],3,2,wf4(:,1),wf16(:,76))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,589),heltab2x128(:,:,665))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(135),n2h64(489))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(738)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(666),h0tab(:,666),[64,5,58],[nMT,nMT,nMT],3,2,wf4(:,1),wf16(:,76))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,590),heltab2x128(:,:,666))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(136),n2h64(490))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(738)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(667),h0tab(:,667),[64,5,58],[0,0,0],3,2,wf4(:,1),wf16(:,76))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,591),heltab2x128(:,:,667))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(137),n2h64(491))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(738)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(668),h0tab(:,668),[64,5,58],[nMT,nMT,nMT],3,2,wf4(:,1),wf16(:,76))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,592),heltab2x128(:,:,668))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(138),n2h64(492))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(738)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(669),h0tab(:,669),[64,5,58],[0,0,0],3,2,wf4(:,1),wf16(:,76))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,593),heltab2x128(:,:,669))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(139),n2h64(493))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(738)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(670),h0tab(:,670),[64,5,58],[nMB,nMB,nMB],3,2,wf4(:,1),wf16(:,76))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,594),heltab2x128(:,:,670))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(140),n2h64(494))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(738)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(671),h0tab(:,671),[64,5,58],[0,0,0],3,2,wf4(:,1),wf16(:,76))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,595),heltab2x128(:,:,671))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(141),n2h64(495))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(738)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(672),h0tab(:,672),[64,5,58],[nMB,nMB,nMB],3,2,wf4(:,1),wf16(:,76))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,596),heltab2x128(:,:,672))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(142),n2h64(496))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(739)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(673),h0tab(:,673),[64,5,58],[0,0,0],3,2,wf4(:,1),wf16(:,77))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,597),heltab2x128(:,:,673))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(143),n2h64(497))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(739)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(674),h0tab(:,674),[64,5,58],[nMT,nMT,nMT],3,2,wf4(:,1),wf16(:,77))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,598),heltab2x128(:,:,674))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(144),n2h64(498))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(739)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(675),h0tab(:,675),[64,5,58],[0,0,0],3,2,wf4(:,1),wf16(:,77))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,599),heltab2x128(:,:,675))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(145),n2h64(499))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(739)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(676),h0tab(:,676),[64,5,58],[nMT,nMT,nMT],3,2,wf4(:,1),wf16(:,77))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,600),heltab2x128(:,:,676))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(146),n2h64(500))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(739)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(677),h0tab(:,677),[64,5,58],[0,0,0],3,2,wf4(:,1),wf16(:,77))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,601),heltab2x128(:,:,677))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(147),n2h64(501))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(739)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(678),h0tab(:,678),[64,5,58],[nMB,nMB,nMB],3,2,wf4(:,1),wf16(:,77))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,602),heltab2x128(:,:,678))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(148),n2h64(502))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(739)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(679),h0tab(:,679),[64,5,58],[0,0,0],3,2,wf4(:,1),wf16(:,77))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,603),heltab2x128(:,:,679))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(149),n2h64(503))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(739)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(680),h0tab(:,680),[64,5,58],[nMB,nMB,nMB],3,2,wf4(:,1),wf16(:,77))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,604),heltab2x128(:,:,680))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(150),n2h64(504))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(740)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(681),h0tab(:,681),[64,5,58],[0,0,0],3,2,wf4(:,8),wf16(:,76))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,605),heltab2x128(:,:,681))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(151),n2h64(505))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(740)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(682),h0tab(:,682),[64,5,58],[nMT,nMT,nMT],3,2,wf4(:,8),wf16(:,76))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,606),heltab2x128(:,:,682))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(152),n2h64(506))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(740)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(683),h0tab(:,683),[64,5,58],[0,0,0],3,2,wf4(:,8),wf16(:,76))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,607),heltab2x128(:,:,683))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(153),n2h64(507))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(740)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(684),h0tab(:,684),[64,5,58],[nMT,nMT,nMT],3,2,wf4(:,8),wf16(:,76))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,608),heltab2x128(:,:,684))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(154),n2h64(508))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(740)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(685),h0tab(:,685),[64,5,58],[0,0,0],3,2,wf4(:,8),wf16(:,76))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,609),heltab2x128(:,:,685))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(155),n2h64(509))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(740)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(686),h0tab(:,686),[64,5,58],[nMB,nMB,nMB],3,2,wf4(:,8),wf16(:,76))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,610),heltab2x128(:,:,686))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(156),n2h64(510))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(740)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(687),h0tab(:,687),[64,5,58],[0,0,0],3,2,wf4(:,8),wf16(:,76))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,611),heltab2x128(:,:,687))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(157),n2h64(511))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(740)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(688),h0tab(:,688),[64,5,58],[nMB,nMB,nMB],3,2,wf4(:,8),wf16(:,76))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,612),heltab2x128(:,:,688))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(158),n2h64(512))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(741)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(689),h0tab(:,689),[64,5,58],[0,0,0],3,2,wf4(:,8),wf16(:,77))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,613),heltab2x128(:,:,689))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(159),n2h64(513))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(741)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(690),h0tab(:,690),[64,5,58],[nMT,nMT,nMT],3,2,wf4(:,8),wf16(:,77))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,614),heltab2x128(:,:,690))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(160),n2h64(514))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(741)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(691),h0tab(:,691),[64,5,58],[0,0,0],3,2,wf4(:,8),wf16(:,77))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,615),heltab2x128(:,:,691))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(161),n2h64(515))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(741)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(692),h0tab(:,692),[64,5,58],[nMT,nMT,nMT],3,2,wf4(:,8),wf16(:,77))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,616),heltab2x128(:,:,692))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(162),n2h64(516))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(741)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(693),h0tab(:,693),[64,5,58],[0,0,0],3,2,wf4(:,8),wf16(:,77))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,617),heltab2x128(:,:,693))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(163),n2h64(517))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(741)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(694),h0tab(:,694),[64,5,58],[nMB,nMB,nMB],3,2,wf4(:,8),wf16(:,77))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,618),heltab2x128(:,:,694))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(164),n2h64(518))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(741)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(695),h0tab(:,695),[64,5,58],[0,0,0],3,2,wf4(:,8),wf16(:,77))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,619),heltab2x128(:,:,695))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(165),n2h64(519))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(741)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(696),h0tab(:,696),[64,5,58],[nMB,nMB,nMB],3,2,wf4(:,8),wf16(:,77))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,620),heltab2x128(:,:,696))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(166),n2h64(520))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(742)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(697),h0tab(:,697),[106,5,16],[0,0,0],3,2,wf16(:,148),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,148),G0H8(1),m3h16x8(:,29),heltab2x128(:,:,697))
  call Hloop_A_Q(ntryL,G0H8(1),106,0,G1H8(116),n2h8(245))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(743)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(698),h0tab(:,698),[106,5,16],[0,0,0],3,2,wf16(:,150),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,150),G0H8(1),m3h16x8(:,30),heltab2x128(:,:,698))
  call Hloop_A_Q(ntryL,G0H8(1),106,0,G1H8(132),n2h8(246))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(744)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(699),h0tab(:,699),[106,5,16],[0,0,0],3,2,wf16(:,148),wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,148),G0H8(1),m3h16x8(:,31),heltab2x128(:,:,699))
  call Hloop_A_Q(ntryL,G0H8(1),106,0,G1H8(148),n2h8(247))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(745)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(700),h0tab(:,700),[106,5,16],[0,0,0],3,2,wf16(:,150),wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,150),G0H8(1),m3h16x8(:,32),heltab2x128(:,:,700))
  call Hloop_A_Q(ntryL,G0H8(1),106,0,G1H8(164),n2h8(248))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(573)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(701),h0tab(:,701),[64,16,47],[0,0,0],3,1,wf32(:,34))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,621),heltab2x128(:,:,701))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(167),n2h64(521))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(575)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(702),h0tab(:,702),[64,16,47],[0,0,0],3,1,wf32(:,36))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,622),heltab2x128(:,:,702))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(168),n2h64(522))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(577)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(703),h0tab(:,703),[64,16,47],[0,0,0],3,1,wf32(:,38))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,623),heltab2x128(:,:,703))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(173),n2h64(523))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(579)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(704),h0tab(:,704),[64,16,47],[0,0,0],3,1,wf32(:,40))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,624),heltab2x128(:,:,704))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(170),n2h64(524))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(573)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(705),h0tab(:,705),[64,16,47],[0,0,0],3,1,wf32(:,34))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(175),m3h2x64(:,625),heltab2x128(:,:,705))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(575)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(706),h0tab(:,706),[64,16,47],[0,0,0],3,1,wf32(:,36))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(172),m3h2x64(:,626),heltab2x128(:,:,706))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(577)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(707),h0tab(:,707),[64,16,47],[0,0,0],3,1,wf32(:,38))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(174),m3h2x64(:,627),heltab2x128(:,:,707))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(579)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(708),h0tab(:,708),[64,16,47],[0,0,0],3,1,wf32(:,40))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(176),m3h2x64(:,628),heltab2x128(:,:,708))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(746)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(709),h0tab(:,709),[64,15,48],[0,0,0],3,2,wf16(:,13),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,629),heltab2x128(:,:,709))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(177),n2h64(525))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(746)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(710),h0tab(:,710),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,13),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,630),heltab2x128(:,:,710))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(178),n2h64(526))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(746)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(711),h0tab(:,711),[64,15,48],[0,0,0],3,2,wf16(:,13),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,631),heltab2x128(:,:,711))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(179),n2h64(527))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(746)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(712),h0tab(:,712),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,13),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,632),heltab2x128(:,:,712))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(180),n2h64(528))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(746)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(713),h0tab(:,713),[64,15,48],[0,0,0],3,2,wf16(:,13),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,633),heltab2x128(:,:,713))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(181),n2h64(529))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(746)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(714),h0tab(:,714),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,13),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,634),heltab2x128(:,:,714))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(182),n2h64(530))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(746)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(715),h0tab(:,715),[64,15,48],[0,0,0],3,2,wf16(:,13),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,635),heltab2x128(:,:,715))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(183),n2h64(531))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(746)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(716),h0tab(:,716),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,13),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,636),heltab2x128(:,:,716))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(184),n2h64(532))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(747)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(717),h0tab(:,717),[64,15,48],[0,0,0],3,2,wf16(:,159),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,637),heltab2x128(:,:,717))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(185),n2h64(533))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(747)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(718),h0tab(:,718),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,159),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,638),heltab2x128(:,:,718))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(186),n2h64(534))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(747)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(719),h0tab(:,719),[64,15,48],[0,0,0],3,2,wf16(:,159),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,639),heltab2x128(:,:,719))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(187),n2h64(535))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(747)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(720),h0tab(:,720),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,159),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,640),heltab2x128(:,:,720))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(188),n2h64(536))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(747)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(721),h0tab(:,721),[64,15,48],[0,0,0],3,2,wf16(:,159),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,641),heltab2x128(:,:,721))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(189),n2h64(537))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(747)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(722),h0tab(:,722),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,159),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,642),heltab2x128(:,:,722))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(190),n2h64(538))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(747)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(723),h0tab(:,723),[64,15,48],[0,0,0],3,2,wf16(:,159),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,643),heltab2x128(:,:,723))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(191),n2h64(539))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(747)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(724),h0tab(:,724),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,159),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,644),heltab2x128(:,:,724))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(192),n2h64(540))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(748)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(725),h0tab(:,725),[64,15,48],[0,0,0],3,2,wf16(:,15),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,645),heltab2x128(:,:,725))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(193),n2h64(541))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(748)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(726),h0tab(:,726),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,15),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,646),heltab2x128(:,:,726))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(194),n2h64(542))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(748)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(727),h0tab(:,727),[64,15,48],[0,0,0],3,2,wf16(:,15),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,647),heltab2x128(:,:,727))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(195),n2h64(543))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(748)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(728),h0tab(:,728),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,15),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,648),heltab2x128(:,:,728))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(196),n2h64(544))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(748)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(729),h0tab(:,729),[64,15,48],[0,0,0],3,2,wf16(:,15),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,649),heltab2x128(:,:,729))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(197),n2h64(545))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(748)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(730),h0tab(:,730),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,15),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,650),heltab2x128(:,:,730))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(198),n2h64(546))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(748)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(731),h0tab(:,731),[64,15,48],[0,0,0],3,2,wf16(:,15),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,651),heltab2x128(:,:,731))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(199),n2h64(547))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(748)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(732),h0tab(:,732),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,15),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,652),heltab2x128(:,:,732))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(200),n2h64(548))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(749)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(733),h0tab(:,733),[64,15,48],[0,0,0],3,2,wf16(:,160),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,653),heltab2x128(:,:,733))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(205),n2h64(549))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(749)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(734),h0tab(:,734),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,160),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,654),heltab2x128(:,:,734))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(202),n2h64(550))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(749)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(735),h0tab(:,735),[64,15,48],[0,0,0],3,2,wf16(:,160),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,655),heltab2x128(:,:,735))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(207),n2h64(551))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(749)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(736),h0tab(:,736),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,160),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,656),heltab2x128(:,:,736))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(204),n2h64(552))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(749)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(737),h0tab(:,737),[64,15,48],[0,0,0],3,2,wf16(:,160),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,657),heltab2x128(:,:,737))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(206),n2h64(553))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(749)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(738),h0tab(:,738),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,160),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,658),heltab2x128(:,:,738))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(208),n2h64(554))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(749)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(739),h0tab(:,739),[64,15,48],[0,0,0],3,2,wf16(:,160),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,659),heltab2x128(:,:,739))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(209),n2h64(555))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(749)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(740),h0tab(:,740),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,160),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,660),heltab2x128(:,:,740))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(210),n2h64(556))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(750)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(741),h0tab(:,741),[64,15,48],[0,0,0],3,2,wf16(:,17),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,661),heltab2x128(:,:,741))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(211),n2h64(557))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(750)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(742),h0tab(:,742),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,17),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,662),heltab2x128(:,:,742))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(212),n2h64(558))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(750)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(743),h0tab(:,743),[64,15,48],[0,0,0],3,2,wf16(:,17),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,663),heltab2x128(:,:,743))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(213),n2h64(559))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(750)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(744),h0tab(:,744),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,17),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,664),heltab2x128(:,:,744))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(214),n2h64(560))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(750)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(745),h0tab(:,745),[64,15,48],[0,0,0],3,2,wf16(:,17),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,665),heltab2x128(:,:,745))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(215),n2h64(561))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(750)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(746),h0tab(:,746),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,17),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,666),heltab2x128(:,:,746))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(216),n2h64(562))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(750)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(747),h0tab(:,747),[64,15,48],[0,0,0],3,2,wf16(:,17),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,667),heltab2x128(:,:,747))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(217),n2h64(563))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(750)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(748),h0tab(:,748),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,17),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,668),heltab2x128(:,:,748))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(218),n2h64(564))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(751)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(749),h0tab(:,749),[64,15,48],[0,0,0],3,2,wf16(:,161),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,669),heltab2x128(:,:,749))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(219),n2h64(565))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(751)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(750),h0tab(:,750),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,161),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,670),heltab2x128(:,:,750))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(220),n2h64(566))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(751)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(751),h0tab(:,751),[64,15,48],[0,0,0],3,2,wf16(:,161),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,671),heltab2x128(:,:,751))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(221),n2h64(567))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(751)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(752),h0tab(:,752),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,161),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,672),heltab2x128(:,:,752))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(222),n2h64(568))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(751)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(753),h0tab(:,753),[64,15,48],[0,0,0],3,2,wf16(:,161),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,673),heltab2x128(:,:,753))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(223),n2h64(569))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(751)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(754),h0tab(:,754),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,161),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,674),heltab2x128(:,:,754))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(224),n2h64(570))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(751)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(755),h0tab(:,755),[64,15,48],[0,0,0],3,2,wf16(:,161),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,675),heltab2x128(:,:,755))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(225),n2h64(571))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(751)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(756),h0tab(:,756),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,161),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,676),heltab2x128(:,:,756))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(226),n2h64(572))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(752)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(757),h0tab(:,757),[64,15,48],[0,0,0],3,2,wf16(:,19),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,677),heltab2x128(:,:,757))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(227),n2h64(573))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(752)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(758),h0tab(:,758),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,19),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,678),heltab2x128(:,:,758))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(228),n2h64(574))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(752)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(759),h0tab(:,759),[64,15,48],[0,0,0],3,2,wf16(:,19),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,679),heltab2x128(:,:,759))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(229),n2h64(575))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(752)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(760),h0tab(:,760),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,19),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,680),heltab2x128(:,:,760))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(230),n2h64(576))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(752)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(761),h0tab(:,761),[64,15,48],[0,0,0],3,2,wf16(:,19),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,681),heltab2x128(:,:,761))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(231),n2h64(577))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(752)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(762),h0tab(:,762),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,19),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,682),heltab2x128(:,:,762))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(232),n2h64(578))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(752)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(763),h0tab(:,763),[64,15,48],[0,0,0],3,2,wf16(:,19),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,683),heltab2x128(:,:,763))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(237),n2h64(579))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(752)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(764),h0tab(:,764),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,19),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,684),heltab2x128(:,:,764))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(234),n2h64(580))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(753)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(765),h0tab(:,765),[64,15,48],[0,0,0],3,2,wf16(:,162),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,685),heltab2x128(:,:,765))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(239),n2h64(581))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(753)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(766),h0tab(:,766),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,162),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,686),heltab2x128(:,:,766))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(236),n2h64(582))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(753)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(767),h0tab(:,767),[64,15,48],[0,0,0],3,2,wf16(:,162),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,687),heltab2x128(:,:,767))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(238),n2h64(583))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(753)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(768),h0tab(:,768),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,162),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,688),heltab2x128(:,:,768))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(240),n2h64(584))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(753)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(769),h0tab(:,769),[64,15,48],[0,0,0],3,2,wf16(:,162),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,689),heltab2x128(:,:,769))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(241),n2h64(585))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(753)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(770),h0tab(:,770),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,162),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,690),heltab2x128(:,:,770))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(242),n2h64(586))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(753)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(771),h0tab(:,771),[64,15,48],[0,0,0],3,2,wf16(:,162),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,691),heltab2x128(:,:,771))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(243),n2h64(587))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(753)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(772),h0tab(:,772),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,162),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,692),heltab2x128(:,:,772))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(244),n2h64(588))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(754)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(773),h0tab(:,773),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,13))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,49),heltab2x128(:,:,773))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(1),n2h32(177))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(755)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(774),h0tab(:,774),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,159))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,50),heltab2x128(:,:,774))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(2),n2h32(178))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(756)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(775),h0tab(:,775),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,15))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,51),heltab2x128(:,:,775))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(5),n2h32(179))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(757)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(776),h0tab(:,776),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,160))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,52),heltab2x128(:,:,776))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(25),n2h32(180))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(758)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(777),h0tab(:,777),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,17))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,53),heltab2x128(:,:,777))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(26),n2h32(181))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(759)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(778),h0tab(:,778),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,161))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,54),heltab2x128(:,:,778))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(28),n2h32(182))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(760)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(779),h0tab(:,779),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,19))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,55),heltab2x128(:,:,779))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(20),n2h32(183))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(761)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(780),h0tab(:,780),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,162))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,56),heltab2x128(:,:,780))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(22),n2h32(184))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(762)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(781),h0tab(:,781),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,13))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,57),heltab2x128(:,:,781))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(23),n2h32(185))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(763)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(782),h0tab(:,782),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,159))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,58),heltab2x128(:,:,782))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(24),n2h32(186))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(764)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(783),h0tab(:,783),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,15))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,59),heltab2x128(:,:,783))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(12),n2h32(187))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(765)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(784),h0tab(:,784),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,160))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,60),heltab2x128(:,:,784))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(13),n2h32(188))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(766)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(785),h0tab(:,785),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,17))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,61),heltab2x128(:,:,785))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(14),n2h32(189))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(767)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(786),h0tab(:,786),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,161))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,62),heltab2x128(:,:,786))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(16),n2h32(190))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(768)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(787),h0tab(:,787),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,19))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,63),heltab2x128(:,:,787))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(18),n2h32(191))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(769)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(788),h0tab(:,788),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,162))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,64),heltab2x128(:,:,788))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(19),n2h32(192))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(580)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(789),h0tab(:,789),[64,31,32],[0,0,0],3,1,wf32(:,42))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,693),heltab2x128(:,:,789))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(245),n2h64(589))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(581)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(790),h0tab(:,790),[64,31,32],[0,0,0],3,1,wf32(:,44))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,694),heltab2x128(:,:,790))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(246),n2h64(590))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(582)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(791),h0tab(:,791),[64,31,32],[0,0,0],3,1,wf32(:,46))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,695),heltab2x128(:,:,791))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(247),n2h64(591))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(583)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(792),h0tab(:,792),[64,31,32],[0,0,0],3,1,wf32(:,48))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,696),heltab2x128(:,:,792))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(248),n2h64(592))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(580)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(793),h0tab(:,793),[64,31,32],[0,0,0],3,1,wf32(:,42))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(249),m3h2x64(:,697),heltab2x128(:,:,793))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(581)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(794),h0tab(:,794),[64,31,32],[0,0,0],3,1,wf32(:,44))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(250),m3h2x64(:,698),heltab2x128(:,:,794))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(582)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(795),h0tab(:,795),[64,31,32],[0,0,0],3,1,wf32(:,46))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(251),m3h2x64(:,699),heltab2x128(:,:,795))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(583)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(796),h0tab(:,796),[64,31,32],[0,0,0],3,1,wf32(:,48))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(252),m3h2x64(:,700),heltab2x128(:,:,796))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(584)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(797),h0tab(:,797),[64,16,47],[0,0,0],3,1,wf32(:,50))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,701),heltab2x128(:,:,797))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(253),n2h64(593))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(585)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(798),h0tab(:,798),[64,16,47],[0,0,0],3,1,wf32(:,52))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,702),heltab2x128(:,:,798))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(254),n2h64(594))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(586)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(799),h0tab(:,799),[64,16,47],[0,0,0],3,1,wf32(:,54))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,703),heltab2x128(:,:,799))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(255),n2h64(595))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(587)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(800),h0tab(:,800),[64,16,47],[0,0,0],3,1,wf32(:,56))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,704),heltab2x128(:,:,800))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(256),n2h64(596))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(584)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(801),h0tab(:,801),[64,16,47],[0,0,0],3,1,wf32(:,50))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(257),m3h2x64(:,705),heltab2x128(:,:,801))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(585)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(802),h0tab(:,802),[64,16,47],[0,0,0],3,1,wf32(:,52))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(258),m3h2x64(:,706),heltab2x128(:,:,802))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(586)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(803),h0tab(:,803),[64,16,47],[0,0,0],3,1,wf32(:,54))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(259),m3h2x64(:,707),heltab2x128(:,:,803))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(587)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(804),h0tab(:,804),[64,16,47],[0,0,0],3,1,wf32(:,56))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(260),m3h2x64(:,708),heltab2x128(:,:,804))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(588)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(805),h0tab(:,805),[64,31,32],[0,0,0],3,1,wf32(:,58))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,709),heltab2x128(:,:,805))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(261),n2h64(597))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(589)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(806),h0tab(:,806),[64,31,32],[0,0,0],3,1,wf32(:,60))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,710),heltab2x128(:,:,806))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(262),n2h64(598))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(590)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(807),h0tab(:,807),[64,31,32],[0,0,0],3,1,wf32(:,62))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,711),heltab2x128(:,:,807))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(263),n2h64(599))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(591)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(808),h0tab(:,808),[64,31,32],[0,0,0],3,1,wf32(:,64))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,712),heltab2x128(:,:,808))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(264),n2h64(600))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(588)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(809),h0tab(:,809),[64,31,32],[0,0,0],3,1,wf32(:,58))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(265),m3h2x64(:,713),heltab2x128(:,:,809))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(589)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(810),h0tab(:,810),[64,31,32],[0,0,0],3,1,wf32(:,60))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(266),m3h2x64(:,714),heltab2x128(:,:,810))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(590)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(811),h0tab(:,811),[64,31,32],[0,0,0],3,1,wf32(:,62))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(267),m3h2x64(:,715),heltab2x128(:,:,811))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(591)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(812),h0tab(:,812),[64,31,32],[0,0,0],3,1,wf32(:,64))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(268),m3h2x64(:,716),heltab2x128(:,:,812))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(592)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(813),h0tab(:,813),[64,16,47],[0,0,0],3,1,wf32(:,66))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,717),heltab2x128(:,:,813))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(269),n2h64(601))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(593)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(814),h0tab(:,814),[64,16,47],[0,0,0],3,1,wf32(:,68))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,718),heltab2x128(:,:,814))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(270),n2h64(602))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(594)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(815),h0tab(:,815),[64,16,47],[0,0,0],3,1,wf32(:,70))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,719),heltab2x128(:,:,815))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(271),n2h64(603))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(595)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(816),h0tab(:,816),[64,16,47],[0,0,0],3,1,wf32(:,72))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,720),heltab2x128(:,:,816))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(272),n2h64(604))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(592)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(817),h0tab(:,817),[64,16,47],[0,0,0],3,1,wf32(:,66))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(273),m3h2x64(:,721),heltab2x128(:,:,817))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(593)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(818),h0tab(:,818),[64,16,47],[0,0,0],3,1,wf32(:,68))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(274),m3h2x64(:,722),heltab2x128(:,:,818))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(594)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(819),h0tab(:,819),[64,16,47],[0,0,0],3,1,wf32(:,70))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(275),m3h2x64(:,723),heltab2x128(:,:,819))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(595)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(820),h0tab(:,820),[64,16,47],[0,0,0],3,1,wf32(:,72))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(276),m3h2x64(:,724),heltab2x128(:,:,820))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(255)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(821),h0tab(:,821),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,98),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,725),heltab2x128(:,:,821))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(277),n2h64(605))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(255)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(822),h0tab(:,822),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,98),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,726),heltab2x128(:,:,822))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(278),n2h64(606))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(255)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(823),h0tab(:,823),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,98),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,727),heltab2x128(:,:,823))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(279),n2h64(607))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(255)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(824),h0tab(:,824),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,98),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,728),heltab2x128(:,:,824))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(280),n2h64(608))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(774)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(825),h0tab(:,825),[80,6,41],[0,0,0],3,3,wf4(:,4),wf4(:,12),wf8(:,32))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,65),heltab2x128(:,:,825))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(40),n2h32(193))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(775)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(826),h0tab(:,826),[80,6,41],[0,0,0],3,3,wf4(:,4),wf4(:,14),wf8(:,32))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,66),heltab2x128(:,:,826))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(41),n2h32(194))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(776)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(827),h0tab(:,827),[80,6,41],[0,0,0],3,3,wf4(:,4),wf4(:,12),wf8(:,34))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,67),heltab2x128(:,:,827))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(43),n2h32(195))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(777)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(828),h0tab(:,828),[80,6,41],[0,0,0],3,3,wf4(:,4),wf4(:,14),wf8(:,34))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,68),heltab2x128(:,:,828))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(44),n2h32(196))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(778)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(829),h0tab(:,829),[80,9,38],[0,0,0],3,3,wf4(:,4),wf4(:,11),wf8(:,36))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,69),heltab2x128(:,:,829))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(46),n2h32(197))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(779)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(830),h0tab(:,830),[80,9,38],[0,0,0],3,3,wf4(:,4),wf4(:,11),wf8(:,38))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,70),heltab2x128(:,:,830))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(47),n2h32(198))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(780)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(831),h0tab(:,831),[80,9,38],[0,0,0],3,3,wf4(:,4),wf4(:,16),wf8(:,36))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,71),heltab2x128(:,:,831))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(49),n2h32(199))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(781)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(832),h0tab(:,832),[80,9,38],[0,0,0],3,3,wf4(:,4),wf4(:,16),wf8(:,38))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,72),heltab2x128(:,:,832))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(50),n2h32(200))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(833),h0tab(:,833),[89,6,32],[0,0,0],3,2,wf16(:,119),wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,119),G0H8(1),m3h16x8(:,33),heltab2x128(:,:,833))
  call Hloop_Q_A(ntryL,G0H8(1),89,0,G1H8(3),n2h8(249))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(834),h0tab(:,834),[89,6,32],[0,0,0],3,2,wf16(:,119),wf4(:,14))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,119),G0H8(1),m3h16x8(:,34),heltab2x128(:,:,834))
  call Hloop_Q_A(ntryL,G0H8(1),89,0,G1H8(4),n2h8(250))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(835),h0tab(:,835),[89,6,32],[0,0,0],3,2,wf16(:,120),wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,120),G0H8(1),m3h16x8(:,35),heltab2x128(:,:,835))
  call Hloop_Q_A(ntryL,G0H8(1),89,0,G1H8(9),n2h8(251))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(836),h0tab(:,836),[89,6,32],[0,0,0],3,2,wf16(:,120),wf4(:,14))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,120),G0H8(1),m3h16x8(:,36),heltab2x128(:,:,836))
  call Hloop_Q_A(ntryL,G0H8(1),89,0,G1H8(10),n2h8(252))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(837),h0tab(:,837),[86,9,32],[0,0,0],3,2,wf16(:,121),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,121),G0H8(1),m3h16x8(:,37),heltab2x128(:,:,837))
  call Hloop_Q_A(ntryL,G0H8(1),86,0,G1H8(15),n2h8(253))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(279)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(838),h0tab(:,838),[86,9,32],[0,0,0],3,2,wf16(:,122),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,122),G0H8(1),m3h16x8(:,38),heltab2x128(:,:,838))
  call Hloop_Q_A(ntryL,G0H8(1),86,0,G1H8(16),n2h8(254))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(280)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(839),h0tab(:,839),[86,9,32],[0,0,0],3,2,wf16(:,121),wf4(:,16))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,121),G0H8(1),m3h16x8(:,39),heltab2x128(:,:,839))
  call Hloop_Q_A(ntryL,G0H8(1),86,0,G1H8(21),n2h8(255))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(281)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(840),h0tab(:,840),[86,9,32],[0,0,0],3,2,wf16(:,122),wf4(:,16))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,122),G0H8(1),m3h16x8(:,40),heltab2x128(:,:,840))
  call Hloop_Q_A(ntryL,G0H8(1),86,0,G1H8(22),n2h8(256))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(786)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(841),h0tab(:,841),[96,6,25],[0,0,0],3,3,wf4(:,10),wf4(:,12),wf8(:,40))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,73),heltab2x128(:,:,841))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(52),n2h32(201))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(787)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(842),h0tab(:,842),[96,6,25],[0,0,0],3,3,wf4(:,10),wf4(:,14),wf8(:,40))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,74),heltab2x128(:,:,842))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(53),n2h32(202))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(788)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(843),h0tab(:,843),[96,6,25],[0,0,0],3,3,wf4(:,10),wf4(:,12),wf8(:,42))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,75),heltab2x128(:,:,843))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(55),n2h32(203))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(789)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(844),h0tab(:,844),[96,6,25],[0,0,0],3,3,wf4(:,10),wf4(:,14),wf8(:,42))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,76),heltab2x128(:,:,844))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(56),n2h32(204))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(790)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(845),h0tab(:,845),[96,9,22],[0,0,0],3,3,wf4(:,10),wf4(:,11),wf8(:,44))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,77),heltab2x128(:,:,845))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(58),n2h32(205))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(791)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(846),h0tab(:,846),[96,9,22],[0,0,0],3,3,wf4(:,10),wf4(:,11),wf8(:,46))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,78),heltab2x128(:,:,846))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(30),n2h32(206))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(792)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(847),h0tab(:,847),[96,9,22],[0,0,0],3,3,wf4(:,10),wf4(:,16),wf8(:,44))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,79),heltab2x128(:,:,847))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(32),n2h32(207))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(793)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(848),h0tab(:,848),[96,9,22],[0,0,0],3,3,wf4(:,10),wf4(:,16),wf8(:,46))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,80),heltab2x128(:,:,848))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(34),n2h32(208))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(284)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(849),h0tab(:,849),[105,6,16],[0,0,0],3,2,wf16(:,127),wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,127),G0H8(1),m3h16x8(:,41),heltab2x128(:,:,849))
  call Hloop_A_Q(ntryL,G0H8(1),105,0,G1H8(27),n2h8(257))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(285)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(850),h0tab(:,850),[105,6,16],[0,0,0],3,2,wf16(:,127),wf4(:,14))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,127),G0H8(1),m3h16x8(:,42),heltab2x128(:,:,850))
  call Hloop_A_Q(ntryL,G0H8(1),105,0,G1H8(28),n2h8(258))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(287)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(851),h0tab(:,851),[105,6,16],[0,0,0],3,2,wf16(:,128),wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,128),G0H8(1),m3h16x8(:,43),heltab2x128(:,:,851))
  call Hloop_A_Q(ntryL,G0H8(1),105,0,G1H8(33),n2h8(259))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(288)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(852),h0tab(:,852),[105,6,16],[0,0,0],3,2,wf16(:,128),wf4(:,14))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,128),G0H8(1),m3h16x8(:,44),heltab2x128(:,:,852))
  call Hloop_A_Q(ntryL,G0H8(1),105,0,G1H8(34),n2h8(260))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(291)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(853),h0tab(:,853),[102,9,16],[0,0,0],3,2,wf16(:,129),wf4(:,11))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,129),G0H8(1),m3h16x8(:,45),heltab2x128(:,:,853))
  call Hloop_A_Q(ntryL,G0H8(1),102,0,G1H8(39),n2h8(261))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(293)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(854),h0tab(:,854),[102,9,16],[0,0,0],3,2,wf16(:,130),wf4(:,11))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,130),G0H8(1),m3h16x8(:,46),heltab2x128(:,:,854))
  call Hloop_A_Q(ntryL,G0H8(1),102,0,G1H8(40),n2h8(262))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(294)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(855),h0tab(:,855),[102,9,16],[0,0,0],3,2,wf16(:,129),wf4(:,16))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,129),G0H8(1),m3h16x8(:,47),heltab2x128(:,:,855))
  call Hloop_A_Q(ntryL,G0H8(1),102,0,G1H8(45),n2h8(263))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(295)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(856),h0tab(:,856),[102,9,16],[0,0,0],3,2,wf16(:,130),wf4(:,16))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,130),G0H8(1),m3h16x8(:,48),heltab2x128(:,:,856))
  call Hloop_A_Q(ntryL,G0H8(1),102,0,G1H8(46),n2h8(264))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(857),h0tab(:,857),[64,25,38],[0,0,0],3,2,wf8(:,40),wf8(:,36))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,729),heltab2x128(:,:,857))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(281),n2h64(609))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(120)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(858),h0tab(:,858),[64,25,38],[0,0,0],3,2,wf8(:,40),wf8(:,38))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,730),heltab2x128(:,:,858))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(282),n2h64(610))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(121)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(859),h0tab(:,859),[64,25,38],[0,0,0],3,2,wf8(:,42),wf8(:,36))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,731),heltab2x128(:,:,859))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(283),n2h64(611))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(860),h0tab(:,860),[64,25,38],[0,0,0],3,2,wf8(:,42),wf8(:,38))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,732),heltab2x128(:,:,860))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(284),n2h64(612))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(861),h0tab(:,861),[64,25,38],[0,0,0],3,2,wf8(:,40),wf8(:,36))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(285),m3h2x64(:,733),heltab2x128(:,:,861))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(120)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(862),h0tab(:,862),[64,25,38],[0,0,0],3,2,wf8(:,40),wf8(:,38))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(286),m3h2x64(:,734),heltab2x128(:,:,862))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(121)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(863),h0tab(:,863),[64,25,38],[0,0,0],3,2,wf8(:,42),wf8(:,36))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(287),m3h2x64(:,735),heltab2x128(:,:,863))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(864),h0tab(:,864),[64,25,38],[0,0,0],3,2,wf8(:,42),wf8(:,38))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(288),m3h2x64(:,736),heltab2x128(:,:,864))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(798)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(865),h0tab(:,865),[64,6,57],[0,0,0],3,2,wf4(:,12),wf16(:,109))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,737),heltab2x128(:,:,865))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(289),n2h64(613))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(798)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(866),h0tab(:,866),[64,6,57],[nMT,nMT,nMT],3,2,wf4(:,12),wf16(:,109))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,738),heltab2x128(:,:,866))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(290),n2h64(614))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(798)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(867),h0tab(:,867),[64,6,57],[0,0,0],3,2,wf4(:,12),wf16(:,109))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,739),heltab2x128(:,:,867))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(291),n2h64(615))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(798)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(868),h0tab(:,868),[64,6,57],[nMT,nMT,nMT],3,2,wf4(:,12),wf16(:,109))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,740),heltab2x128(:,:,868))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(292),n2h64(616))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(798)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(869),h0tab(:,869),[64,6,57],[0,0,0],3,2,wf4(:,12),wf16(:,109))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,741),heltab2x128(:,:,869))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(293),n2h64(617))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(798)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(870),h0tab(:,870),[64,6,57],[nMB,nMB,nMB],3,2,wf4(:,12),wf16(:,109))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,742),heltab2x128(:,:,870))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(294),n2h64(618))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(798)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(871),h0tab(:,871),[64,6,57],[0,0,0],3,2,wf4(:,12),wf16(:,109))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,743),heltab2x128(:,:,871))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(295),n2h64(619))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(798)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(872),h0tab(:,872),[64,6,57],[nMB,nMB,nMB],3,2,wf4(:,12),wf16(:,109))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,744),heltab2x128(:,:,872))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(296),n2h64(620))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(799)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(873),h0tab(:,873),[64,6,57],[0,0,0],3,2,wf4(:,14),wf16(:,109))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,745),heltab2x128(:,:,873))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(297),n2h64(621))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(799)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(874),h0tab(:,874),[64,6,57],[nMT,nMT,nMT],3,2,wf4(:,14),wf16(:,109))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,746),heltab2x128(:,:,874))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(298),n2h64(622))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(799)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(875),h0tab(:,875),[64,6,57],[0,0,0],3,2,wf4(:,14),wf16(:,109))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,747),heltab2x128(:,:,875))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(299),n2h64(623))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(799)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(876),h0tab(:,876),[64,6,57],[nMT,nMT,nMT],3,2,wf4(:,14),wf16(:,109))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,748),heltab2x128(:,:,876))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(300),n2h64(624))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(799)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(877),h0tab(:,877),[64,6,57],[0,0,0],3,2,wf4(:,14),wf16(:,109))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,749),heltab2x128(:,:,877))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(301),n2h64(625))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(799)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(878),h0tab(:,878),[64,6,57],[nMB,nMB,nMB],3,2,wf4(:,14),wf16(:,109))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,750),heltab2x128(:,:,878))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(302),n2h64(626))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(799)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(879),h0tab(:,879),[64,6,57],[0,0,0],3,2,wf4(:,14),wf16(:,109))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,751),heltab2x128(:,:,879))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(303),n2h64(627))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(799)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(880),h0tab(:,880),[64,6,57],[nMB,nMB,nMB],3,2,wf4(:,14),wf16(:,109))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,752),heltab2x128(:,:,880))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(304),n2h64(628))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(800)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(881),h0tab(:,881),[64,6,57],[0,0,0],3,2,wf4(:,12),wf16(:,110))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,753),heltab2x128(:,:,881))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(305),n2h64(629))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(800)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(882),h0tab(:,882),[64,6,57],[nMT,nMT,nMT],3,2,wf4(:,12),wf16(:,110))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,754),heltab2x128(:,:,882))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(306),n2h64(630))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(800)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(883),h0tab(:,883),[64,6,57],[0,0,0],3,2,wf4(:,12),wf16(:,110))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,755),heltab2x128(:,:,883))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(307),n2h64(631))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(800)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(884),h0tab(:,884),[64,6,57],[nMT,nMT,nMT],3,2,wf4(:,12),wf16(:,110))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,756),heltab2x128(:,:,884))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(308),n2h64(632))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(800)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(885),h0tab(:,885),[64,6,57],[0,0,0],3,2,wf4(:,12),wf16(:,110))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,757),heltab2x128(:,:,885))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(309),n2h64(633))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(800)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(886),h0tab(:,886),[64,6,57],[nMB,nMB,nMB],3,2,wf4(:,12),wf16(:,110))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,758),heltab2x128(:,:,886))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(310),n2h64(634))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(800)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(887),h0tab(:,887),[64,6,57],[0,0,0],3,2,wf4(:,12),wf16(:,110))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,759),heltab2x128(:,:,887))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(311),n2h64(635))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(800)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(888),h0tab(:,888),[64,6,57],[nMB,nMB,nMB],3,2,wf4(:,12),wf16(:,110))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,760),heltab2x128(:,:,888))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(312),n2h64(636))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(801)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(889),h0tab(:,889),[64,6,57],[0,0,0],3,2,wf4(:,14),wf16(:,110))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,761),heltab2x128(:,:,889))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(313),n2h64(637))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(801)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(890),h0tab(:,890),[64,6,57],[nMT,nMT,nMT],3,2,wf4(:,14),wf16(:,110))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,762),heltab2x128(:,:,890))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(314),n2h64(638))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(801)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(891),h0tab(:,891),[64,6,57],[0,0,0],3,2,wf4(:,14),wf16(:,110))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,763),heltab2x128(:,:,891))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(315),n2h64(639))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(801)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(892),h0tab(:,892),[64,6,57],[nMT,nMT,nMT],3,2,wf4(:,14),wf16(:,110))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,764),heltab2x128(:,:,892))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(316),n2h64(640))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(801)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(893),h0tab(:,893),[64,6,57],[0,0,0],3,2,wf4(:,14),wf16(:,110))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,765),heltab2x128(:,:,893))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(317),n2h64(641))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(801)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(894),h0tab(:,894),[64,6,57],[nMB,nMB,nMB],3,2,wf4(:,14),wf16(:,110))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,766),heltab2x128(:,:,894))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(318),n2h64(642))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(801)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(895),h0tab(:,895),[64,6,57],[0,0,0],3,2,wf4(:,14),wf16(:,110))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,767),heltab2x128(:,:,895))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(319),n2h64(643))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(801)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(896),h0tab(:,896),[64,6,57],[nMB,nMB,nMB],3,2,wf4(:,14),wf16(:,110))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,768),heltab2x128(:,:,896))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(320),n2h64(644))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(802)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(897),h0tab(:,897),[89,6,32],[0,0,0],3,2,wf16(:,179),wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,179),G0H8(1),m3h16x8(:,49),heltab2x128(:,:,897))
  call Hloop_Q_A(ntryL,G0H8(1),89,0,G1H8(57),n2h8(265))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(803)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(898),h0tab(:,898),[89,6,32],[0,0,0],3,2,wf16(:,179),wf4(:,14))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,179),G0H8(1),m3h16x8(:,50),heltab2x128(:,:,898))
  call Hloop_Q_A(ntryL,G0H8(1),89,0,G1H8(58),n2h8(266))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(804)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(899),h0tab(:,899),[89,6,32],[0,0,0],3,2,wf16(:,180),wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,180),G0H8(1),m3h16x8(:,51),heltab2x128(:,:,899))
  call Hloop_Q_A(ntryL,G0H8(1),89,0,G1H8(62),n2h8(267))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(805)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(900),h0tab(:,900),[89,6,32],[0,0,0],3,2,wf16(:,180),wf4(:,14))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,180),G0H8(1),m3h16x8(:,52),heltab2x128(:,:,900))
  call Hloop_Q_A(ntryL,G0H8(1),89,0,G1H8(63),n2h8(268))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(600)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(901),h0tab(:,901),[64,31,32],[0,0,0],3,1,wf32(:,74))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,769),heltab2x128(:,:,901))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(321),n2h64(645))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(602)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(902),h0tab(:,902),[64,31,32],[0,0,0],3,1,wf32(:,76))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,770),heltab2x128(:,:,902))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(322),n2h64(646))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(604)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(903),h0tab(:,903),[64,31,32],[0,0,0],3,1,wf32(:,78))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,771),heltab2x128(:,:,903))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(323),n2h64(647))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(606)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(904),h0tab(:,904),[64,31,32],[0,0,0],3,1,wf32(:,80))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,772),heltab2x128(:,:,904))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(324),n2h64(648))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(600)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(905),h0tab(:,905),[64,31,32],[0,0,0],3,1,wf32(:,74))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(325),m3h2x64(:,773),heltab2x128(:,:,905))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(602)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(906),h0tab(:,906),[64,31,32],[0,0,0],3,1,wf32(:,76))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(326),m3h2x64(:,774),heltab2x128(:,:,906))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(604)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(907),h0tab(:,907),[64,31,32],[0,0,0],3,1,wf32(:,78))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(327),m3h2x64(:,775),heltab2x128(:,:,907))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(606)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(908),h0tab(:,908),[64,31,32],[0,0,0],3,1,wf32(:,80))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(328),m3h2x64(:,776),heltab2x128(:,:,908))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(909),h0tab(:,909),[64,22,41],[0,0,0],3,2,wf8(:,44),wf8(:,32))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,777),heltab2x128(:,:,909))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(329),n2h64(649))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(910),h0tab(:,910),[64,22,41],[0,0,0],3,2,wf8(:,46),wf8(:,32))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,778),heltab2x128(:,:,910))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(330),n2h64(650))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(911),h0tab(:,911),[64,22,41],[0,0,0],3,2,wf8(:,44),wf8(:,34))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,779),heltab2x128(:,:,911))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(331),n2h64(651))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(912),h0tab(:,912),[64,22,41],[0,0,0],3,2,wf8(:,46),wf8(:,34))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,780),heltab2x128(:,:,912))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(332),n2h64(652))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(913),h0tab(:,913),[64,22,41],[0,0,0],3,2,wf8(:,44),wf8(:,32))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(333),m3h2x64(:,781),heltab2x128(:,:,913))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(914),h0tab(:,914),[64,22,41],[0,0,0],3,2,wf8(:,46),wf8(:,32))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(334),m3h2x64(:,782),heltab2x128(:,:,914))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(915),h0tab(:,915),[64,22,41],[0,0,0],3,2,wf8(:,44),wf8(:,34))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(335),m3h2x64(:,783),heltab2x128(:,:,915))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(916),h0tab(:,916),[64,22,41],[0,0,0],3,2,wf8(:,46),wf8(:,34))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(336),m3h2x64(:,784),heltab2x128(:,:,916))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(806)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(917),h0tab(:,917),[64,6,57],[0,0,0],3,2,wf4(:,12),wf16(:,113))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,785),heltab2x128(:,:,917))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(337),n2h64(653))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(806)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(918),h0tab(:,918),[64,6,57],[nMT,nMT,nMT],3,2,wf4(:,12),wf16(:,113))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,786),heltab2x128(:,:,918))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(338),n2h64(654))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(806)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(919),h0tab(:,919),[64,6,57],[0,0,0],3,2,wf4(:,12),wf16(:,113))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,787),heltab2x128(:,:,919))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(339),n2h64(655))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(806)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(920),h0tab(:,920),[64,6,57],[nMT,nMT,nMT],3,2,wf4(:,12),wf16(:,113))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,788),heltab2x128(:,:,920))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(340),n2h64(656))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(806)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(921),h0tab(:,921),[64,6,57],[0,0,0],3,2,wf4(:,12),wf16(:,113))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,789),heltab2x128(:,:,921))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(341),n2h64(657))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(806)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(922),h0tab(:,922),[64,6,57],[nMB,nMB,nMB],3,2,wf4(:,12),wf16(:,113))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,790),heltab2x128(:,:,922))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(342),n2h64(658))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(806)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(923),h0tab(:,923),[64,6,57],[0,0,0],3,2,wf4(:,12),wf16(:,113))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,791),heltab2x128(:,:,923))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(343),n2h64(659))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(806)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(924),h0tab(:,924),[64,6,57],[nMB,nMB,nMB],3,2,wf4(:,12),wf16(:,113))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,792),heltab2x128(:,:,924))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(344),n2h64(660))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(807)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(925),h0tab(:,925),[64,6,57],[0,0,0],3,2,wf4(:,14),wf16(:,113))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,793),heltab2x128(:,:,925))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(345),n2h64(661))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(807)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(926),h0tab(:,926),[64,6,57],[nMT,nMT,nMT],3,2,wf4(:,14),wf16(:,113))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,794),heltab2x128(:,:,926))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(346),n2h64(662))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(807)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(927),h0tab(:,927),[64,6,57],[0,0,0],3,2,wf4(:,14),wf16(:,113))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,795),heltab2x128(:,:,927))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(347),n2h64(663))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(807)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(928),h0tab(:,928),[64,6,57],[nMT,nMT,nMT],3,2,wf4(:,14),wf16(:,113))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,796),heltab2x128(:,:,928))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(348),n2h64(664))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(807)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(929),h0tab(:,929),[64,6,57],[0,0,0],3,2,wf4(:,14),wf16(:,113))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,797),heltab2x128(:,:,929))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(349),n2h64(665))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(807)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(930),h0tab(:,930),[64,6,57],[nMB,nMB,nMB],3,2,wf4(:,14),wf16(:,113))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,798),heltab2x128(:,:,930))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(350),n2h64(666))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(807)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(931),h0tab(:,931),[64,6,57],[0,0,0],3,2,wf4(:,14),wf16(:,113))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,799),heltab2x128(:,:,931))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(351),n2h64(667))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(807)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(932),h0tab(:,932),[64,6,57],[nMB,nMB,nMB],3,2,wf4(:,14),wf16(:,113))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,800),heltab2x128(:,:,932))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(352),n2h64(668))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(808)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(933),h0tab(:,933),[64,6,57],[0,0,0],3,2,wf4(:,12),wf16(:,114))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,801),heltab2x128(:,:,933))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(353),n2h64(669))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(808)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(934),h0tab(:,934),[64,6,57],[nMT,nMT,nMT],3,2,wf4(:,12),wf16(:,114))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,802),heltab2x128(:,:,934))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(354),n2h64(670))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(808)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(935),h0tab(:,935),[64,6,57],[0,0,0],3,2,wf4(:,12),wf16(:,114))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,803),heltab2x128(:,:,935))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(355),n2h64(671))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(808)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(936),h0tab(:,936),[64,6,57],[nMT,nMT,nMT],3,2,wf4(:,12),wf16(:,114))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,804),heltab2x128(:,:,936))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(356),n2h64(672))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(808)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(937),h0tab(:,937),[64,6,57],[0,0,0],3,2,wf4(:,12),wf16(:,114))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,805),heltab2x128(:,:,937))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(357),n2h64(673))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(808)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(938),h0tab(:,938),[64,6,57],[nMB,nMB,nMB],3,2,wf4(:,12),wf16(:,114))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,806),heltab2x128(:,:,938))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(358),n2h64(674))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(808)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(939),h0tab(:,939),[64,6,57],[0,0,0],3,2,wf4(:,12),wf16(:,114))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,807),heltab2x128(:,:,939))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(359),n2h64(675))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(808)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(940),h0tab(:,940),[64,6,57],[nMB,nMB,nMB],3,2,wf4(:,12),wf16(:,114))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,808),heltab2x128(:,:,940))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(360),n2h64(676))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(809)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(941),h0tab(:,941),[64,6,57],[0,0,0],3,2,wf4(:,14),wf16(:,114))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,809),heltab2x128(:,:,941))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(361),n2h64(677))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(809)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(942),h0tab(:,942),[64,6,57],[nMT,nMT,nMT],3,2,wf4(:,14),wf16(:,114))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,810),heltab2x128(:,:,942))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(362),n2h64(678))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(809)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(943),h0tab(:,943),[64,6,57],[0,0,0],3,2,wf4(:,14),wf16(:,114))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,811),heltab2x128(:,:,943))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(363),n2h64(679))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(809)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(944),h0tab(:,944),[64,6,57],[nMT,nMT,nMT],3,2,wf4(:,14),wf16(:,114))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,812),heltab2x128(:,:,944))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(364),n2h64(680))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(809)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(945),h0tab(:,945),[64,6,57],[0,0,0],3,2,wf4(:,14),wf16(:,114))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,813),heltab2x128(:,:,945))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(365),n2h64(681))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(809)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(946),h0tab(:,946),[64,6,57],[nMB,nMB,nMB],3,2,wf4(:,14),wf16(:,114))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,814),heltab2x128(:,:,946))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(366),n2h64(682))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(809)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(947),h0tab(:,947),[64,6,57],[0,0,0],3,2,wf4(:,14),wf16(:,114))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,815),heltab2x128(:,:,947))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(367),n2h64(683))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(809)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(948),h0tab(:,948),[64,6,57],[nMB,nMB,nMB],3,2,wf4(:,14),wf16(:,114))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,816),heltab2x128(:,:,948))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(368),n2h64(684))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(810)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(949),h0tab(:,949),[105,6,16],[0,0,0],3,2,wf16(:,176),wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,176),G0H8(1),m3h16x8(:,53),heltab2x128(:,:,949))
  call Hloop_A_Q(ntryL,G0H8(1),105,0,G1H8(73),n2h8(269))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(811)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(950),h0tab(:,950),[105,6,16],[0,0,0],3,2,wf16(:,176),wf4(:,14))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,176),G0H8(1),m3h16x8(:,54),heltab2x128(:,:,950))
  call Hloop_A_Q(ntryL,G0H8(1),105,0,G1H8(74),n2h8(270))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(812)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(951),h0tab(:,951),[105,6,16],[0,0,0],3,2,wf16(:,178),wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,178),G0H8(1),m3h16x8(:,55),heltab2x128(:,:,951))
  call Hloop_A_Q(ntryL,G0H8(1),105,0,G1H8(78),n2h8(271))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(813)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(952),h0tab(:,952),[105,6,16],[0,0,0],3,2,wf16(:,178),wf4(:,14))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,178),G0H8(1),m3h16x8(:,56),heltab2x128(:,:,952))
  call Hloop_A_Q(ntryL,G0H8(1),105,0,G1H8(79),n2h8(272))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(610)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(953),h0tab(:,953),[64,16,47],[0,0,0],3,1,wf32(:,82))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,817),heltab2x128(:,:,953))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(369),n2h64(685))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(612)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(954),h0tab(:,954),[64,16,47],[0,0,0],3,1,wf32(:,84))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,818),heltab2x128(:,:,954))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(370),n2h64(686))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(614)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(955),h0tab(:,955),[64,16,47],[0,0,0],3,1,wf32(:,86))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,819),heltab2x128(:,:,955))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(371),n2h64(687))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(616)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(956),h0tab(:,956),[64,16,47],[0,0,0],3,1,wf32(:,88))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,820),heltab2x128(:,:,956))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(372),n2h64(688))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(610)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(957),h0tab(:,957),[64,16,47],[0,0,0],3,1,wf32(:,82))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(373),m3h2x64(:,821),heltab2x128(:,:,957))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(612)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(958),h0tab(:,958),[64,16,47],[0,0,0],3,1,wf32(:,84))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(374),m3h2x64(:,822),heltab2x128(:,:,958))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(614)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(959),h0tab(:,959),[64,16,47],[0,0,0],3,1,wf32(:,86))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(375),m3h2x64(:,823),heltab2x128(:,:,959))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(616)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(960),h0tab(:,960),[64,16,47],[0,0,0],3,1,wf32(:,88))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(376),m3h2x64(:,824),heltab2x128(:,:,960))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(814)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(961),h0tab(:,961),[64,9,54],[0,0,0],3,2,wf4(:,11),wf16(:,115))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,825),heltab2x128(:,:,961))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(377),n2h64(689))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(814)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(962),h0tab(:,962),[64,9,54],[nMT,nMT,nMT],3,2,wf4(:,11),wf16(:,115))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,826),heltab2x128(:,:,962))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(378),n2h64(690))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(814)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(963),h0tab(:,963),[64,9,54],[0,0,0],3,2,wf4(:,11),wf16(:,115))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,827),heltab2x128(:,:,963))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(379),n2h64(691))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(814)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(964),h0tab(:,964),[64,9,54],[nMT,nMT,nMT],3,2,wf4(:,11),wf16(:,115))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,828),heltab2x128(:,:,964))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(380),n2h64(692))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(814)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(965),h0tab(:,965),[64,9,54],[0,0,0],3,2,wf4(:,11),wf16(:,115))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,829),heltab2x128(:,:,965))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(381),n2h64(693))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(814)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(966),h0tab(:,966),[64,9,54],[nMB,nMB,nMB],3,2,wf4(:,11),wf16(:,115))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,830),heltab2x128(:,:,966))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(382),n2h64(694))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(814)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(967),h0tab(:,967),[64,9,54],[0,0,0],3,2,wf4(:,11),wf16(:,115))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,831),heltab2x128(:,:,967))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(383),n2h64(695))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(814)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(968),h0tab(:,968),[64,9,54],[nMB,nMB,nMB],3,2,wf4(:,11),wf16(:,115))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,832),heltab2x128(:,:,968))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(384),n2h64(696))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(815)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(969),h0tab(:,969),[64,9,54],[0,0,0],3,2,wf4(:,11),wf16(:,116))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,833),heltab2x128(:,:,969))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(385),n2h64(697))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(815)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(970),h0tab(:,970),[64,9,54],[nMT,nMT,nMT],3,2,wf4(:,11),wf16(:,116))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,834),heltab2x128(:,:,970))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(386),n2h64(698))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(815)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(971),h0tab(:,971),[64,9,54],[0,0,0],3,2,wf4(:,11),wf16(:,116))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,835),heltab2x128(:,:,971))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(387),n2h64(699))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(815)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(972),h0tab(:,972),[64,9,54],[nMT,nMT,nMT],3,2,wf4(:,11),wf16(:,116))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,836),heltab2x128(:,:,972))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(388),n2h64(700))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(815)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(973),h0tab(:,973),[64,9,54],[0,0,0],3,2,wf4(:,11),wf16(:,116))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,837),heltab2x128(:,:,973))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(389),n2h64(701))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(815)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(974),h0tab(:,974),[64,9,54],[nMB,nMB,nMB],3,2,wf4(:,11),wf16(:,116))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,838),heltab2x128(:,:,974))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(390),n2h64(702))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(815)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(975),h0tab(:,975),[64,9,54],[0,0,0],3,2,wf4(:,11),wf16(:,116))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,839),heltab2x128(:,:,975))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(391),n2h64(703))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(815)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(976),h0tab(:,976),[64,9,54],[nMB,nMB,nMB],3,2,wf4(:,11),wf16(:,116))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,840),heltab2x128(:,:,976))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(392),n2h64(704))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(816)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(977),h0tab(:,977),[64,9,54],[0,0,0],3,2,wf4(:,16),wf16(:,115))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,841),heltab2x128(:,:,977))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(393),n2h64(705))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(816)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(978),h0tab(:,978),[64,9,54],[nMT,nMT,nMT],3,2,wf4(:,16),wf16(:,115))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,842),heltab2x128(:,:,978))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(394),n2h64(706))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(816)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(979),h0tab(:,979),[64,9,54],[0,0,0],3,2,wf4(:,16),wf16(:,115))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,843),heltab2x128(:,:,979))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(395),n2h64(707))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(816)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(980),h0tab(:,980),[64,9,54],[nMT,nMT,nMT],3,2,wf4(:,16),wf16(:,115))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,844),heltab2x128(:,:,980))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(396),n2h64(708))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(816)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(981),h0tab(:,981),[64,9,54],[0,0,0],3,2,wf4(:,16),wf16(:,115))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,845),heltab2x128(:,:,981))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(397),n2h64(709))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(816)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(982),h0tab(:,982),[64,9,54],[nMB,nMB,nMB],3,2,wf4(:,16),wf16(:,115))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,846),heltab2x128(:,:,982))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(398),n2h64(710))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(816)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(983),h0tab(:,983),[64,9,54],[0,0,0],3,2,wf4(:,16),wf16(:,115))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,847),heltab2x128(:,:,983))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(399),n2h64(711))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(816)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(984),h0tab(:,984),[64,9,54],[nMB,nMB,nMB],3,2,wf4(:,16),wf16(:,115))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,848),heltab2x128(:,:,984))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(400),n2h64(712))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(817)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(985),h0tab(:,985),[64,9,54],[0,0,0],3,2,wf4(:,16),wf16(:,116))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,849),heltab2x128(:,:,985))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(401),n2h64(713))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(817)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(986),h0tab(:,986),[64,9,54],[nMT,nMT,nMT],3,2,wf4(:,16),wf16(:,116))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,850),heltab2x128(:,:,986))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(402),n2h64(714))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(817)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(987),h0tab(:,987),[64,9,54],[0,0,0],3,2,wf4(:,16),wf16(:,116))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,851),heltab2x128(:,:,987))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(403),n2h64(715))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(817)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(988),h0tab(:,988),[64,9,54],[nMT,nMT,nMT],3,2,wf4(:,16),wf16(:,116))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,852),heltab2x128(:,:,988))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(404),n2h64(716))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(817)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(989),h0tab(:,989),[64,9,54],[0,0,0],3,2,wf4(:,16),wf16(:,116))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,853),heltab2x128(:,:,989))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(405),n2h64(717))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(817)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(990),h0tab(:,990),[64,9,54],[nMB,nMB,nMB],3,2,wf4(:,16),wf16(:,116))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,854),heltab2x128(:,:,990))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(406),n2h64(718))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(817)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(991),h0tab(:,991),[64,9,54],[0,0,0],3,2,wf4(:,16),wf16(:,116))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,855),heltab2x128(:,:,991))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(407),n2h64(719))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(817)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(992),h0tab(:,992),[64,9,54],[nMB,nMB,nMB],3,2,wf4(:,16),wf16(:,116))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,856),heltab2x128(:,:,992))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(408),n2h64(720))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(818)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(993),h0tab(:,993),[86,9,32],[0,0,0],3,2,wf16(:,181),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,181),G0H8(1),m3h16x8(:,57),heltab2x128(:,:,993))
  call Hloop_Q_A(ntryL,G0H8(1),86,0,G1H8(89),n2h8(273))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(819)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(994),h0tab(:,994),[86,9,32],[0,0,0],3,2,wf16(:,182),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,182),G0H8(1),m3h16x8(:,58),heltab2x128(:,:,994))
  call Hloop_Q_A(ntryL,G0H8(1),86,0,G1H8(90),n2h8(274))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(820)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(995),h0tab(:,995),[86,9,32],[0,0,0],3,2,wf16(:,181),wf4(:,16))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,181),G0H8(1),m3h16x8(:,59),heltab2x128(:,:,995))
  call Hloop_Q_A(ntryL,G0H8(1),86,0,G1H8(94),n2h8(275))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(821)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(996),h0tab(:,996),[86,9,32],[0,0,0],3,2,wf16(:,182),wf4(:,16))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,182),G0H8(1),m3h16x8(:,60),heltab2x128(:,:,996))
  call Hloop_Q_A(ntryL,G0H8(1),86,0,G1H8(95),n2h8(276))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(621)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(997),h0tab(:,997),[64,31,32],[0,0,0],3,1,wf32(:,90))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,857),heltab2x128(:,:,997))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(409),n2h64(721))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(623)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(998),h0tab(:,998),[64,31,32],[0,0,0],3,1,wf32(:,92))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,858),heltab2x128(:,:,998))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(410),n2h64(722))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(625)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(999),h0tab(:,999),[64,31,32],[0,0,0],3,1,wf32(:,94))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,859),heltab2x128(:,:,999))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(411),n2h64(723))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(627)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1000),h0tab(:,1000),[64,31,32],[0,0,0],3,1,wf32(:,96))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,860),heltab2x128(:,:,1000))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(412),n2h64(724))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(621)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1001),h0tab(:,1001),[64,31,32],[0,0,0],3,1,wf32(:,90))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(413),m3h2x64(:,861),heltab2x128(:,:,1001))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(623)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1002),h0tab(:,1002),[64,31,32],[0,0,0],3,1,wf32(:,92))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(414),m3h2x64(:,862),heltab2x128(:,:,1002))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(625)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1003),h0tab(:,1003),[64,31,32],[0,0,0],3,1,wf32(:,94))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(415),m3h2x64(:,863),heltab2x128(:,:,1003))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(627)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1004),h0tab(:,1004),[64,31,32],[0,0,0],3,1,wf32(:,96))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(416),m3h2x64(:,864),heltab2x128(:,:,1004))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(822)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1005),h0tab(:,1005),[64,9,54],[0,0,0],3,2,wf4(:,11),wf16(:,117))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,865),heltab2x128(:,:,1005))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(417),n2h64(725))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(822)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1006),h0tab(:,1006),[64,9,54],[nMT,nMT,nMT],3,2,wf4(:,11),wf16(:,117))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,866),heltab2x128(:,:,1006))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(418),n2h64(726))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(822)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1007),h0tab(:,1007),[64,9,54],[0,0,0],3,2,wf4(:,11),wf16(:,117))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,867),heltab2x128(:,:,1007))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(419),n2h64(727))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(822)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1008),h0tab(:,1008),[64,9,54],[nMT,nMT,nMT],3,2,wf4(:,11),wf16(:,117))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,868),heltab2x128(:,:,1008))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(420),n2h64(728))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(822)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1009),h0tab(:,1009),[64,9,54],[0,0,0],3,2,wf4(:,11),wf16(:,117))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,869),heltab2x128(:,:,1009))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(421),n2h64(729))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(822)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1010),h0tab(:,1010),[64,9,54],[nMB,nMB,nMB],3,2,wf4(:,11),wf16(:,117))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,870),heltab2x128(:,:,1010))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(422),n2h64(730))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(822)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1011),h0tab(:,1011),[64,9,54],[0,0,0],3,2,wf4(:,11),wf16(:,117))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,871),heltab2x128(:,:,1011))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(423),n2h64(731))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(822)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1012),h0tab(:,1012),[64,9,54],[nMB,nMB,nMB],3,2,wf4(:,11),wf16(:,117))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,872),heltab2x128(:,:,1012))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(424),n2h64(732))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(823)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1013),h0tab(:,1013),[64,9,54],[0,0,0],3,2,wf4(:,11),wf16(:,118))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,873),heltab2x128(:,:,1013))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(425),n2h64(733))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(823)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1014),h0tab(:,1014),[64,9,54],[nMT,nMT,nMT],3,2,wf4(:,11),wf16(:,118))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,874),heltab2x128(:,:,1014))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(426),n2h64(734))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(823)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1015),h0tab(:,1015),[64,9,54],[0,0,0],3,2,wf4(:,11),wf16(:,118))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,875),heltab2x128(:,:,1015))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(427),n2h64(735))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(823)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1016),h0tab(:,1016),[64,9,54],[nMT,nMT,nMT],3,2,wf4(:,11),wf16(:,118))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,876),heltab2x128(:,:,1016))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(428),n2h64(736))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(823)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1017),h0tab(:,1017),[64,9,54],[0,0,0],3,2,wf4(:,11),wf16(:,118))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,877),heltab2x128(:,:,1017))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(429),n2h64(737))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(823)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1018),h0tab(:,1018),[64,9,54],[nMB,nMB,nMB],3,2,wf4(:,11),wf16(:,118))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,878),heltab2x128(:,:,1018))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(430),n2h64(738))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(823)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1019),h0tab(:,1019),[64,9,54],[0,0,0],3,2,wf4(:,11),wf16(:,118))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,879),heltab2x128(:,:,1019))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(431),n2h64(739))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(823)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1020),h0tab(:,1020),[64,9,54],[nMB,nMB,nMB],3,2,wf4(:,11),wf16(:,118))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,880),heltab2x128(:,:,1020))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(432),n2h64(740))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(824)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1021),h0tab(:,1021),[64,9,54],[0,0,0],3,2,wf4(:,16),wf16(:,117))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,881),heltab2x128(:,:,1021))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(433),n2h64(741))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(824)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1022),h0tab(:,1022),[64,9,54],[nMT,nMT,nMT],3,2,wf4(:,16),wf16(:,117))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,882),heltab2x128(:,:,1022))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(434),n2h64(742))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(824)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1023),h0tab(:,1023),[64,9,54],[0,0,0],3,2,wf4(:,16),wf16(:,117))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,883),heltab2x128(:,:,1023))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(435),n2h64(743))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(824)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1024),h0tab(:,1024),[64,9,54],[nMT,nMT,nMT],3,2,wf4(:,16),wf16(:,117))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,884),heltab2x128(:,:,1024))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(436),n2h64(744))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(824)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1025),h0tab(:,1025),[64,9,54],[0,0,0],3,2,wf4(:,16),wf16(:,117))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,885),heltab2x128(:,:,1025))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(437),n2h64(745))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(824)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1026),h0tab(:,1026),[64,9,54],[nMB,nMB,nMB],3,2,wf4(:,16),wf16(:,117))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,886),heltab2x128(:,:,1026))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(438),n2h64(746))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(824)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1027),h0tab(:,1027),[64,9,54],[0,0,0],3,2,wf4(:,16),wf16(:,117))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,887),heltab2x128(:,:,1027))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(439),n2h64(747))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(824)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1028),h0tab(:,1028),[64,9,54],[nMB,nMB,nMB],3,2,wf4(:,16),wf16(:,117))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,888),heltab2x128(:,:,1028))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(440),n2h64(748))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(825)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1029),h0tab(:,1029),[64,9,54],[0,0,0],3,2,wf4(:,16),wf16(:,118))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,889),heltab2x128(:,:,1029))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(441),n2h64(749))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(825)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1030),h0tab(:,1030),[64,9,54],[nMT,nMT,nMT],3,2,wf4(:,16),wf16(:,118))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,890),heltab2x128(:,:,1030))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(442),n2h64(750))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(825)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1031),h0tab(:,1031),[64,9,54],[0,0,0],3,2,wf4(:,16),wf16(:,118))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,891),heltab2x128(:,:,1031))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(443),n2h64(751))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(825)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1032),h0tab(:,1032),[64,9,54],[nMT,nMT,nMT],3,2,wf4(:,16),wf16(:,118))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,892),heltab2x128(:,:,1032))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(444),n2h64(752))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(825)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1033),h0tab(:,1033),[64,9,54],[0,0,0],3,2,wf4(:,16),wf16(:,118))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,893),heltab2x128(:,:,1033))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(445),n2h64(753))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(825)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1034),h0tab(:,1034),[64,9,54],[nMB,nMB,nMB],3,2,wf4(:,16),wf16(:,118))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,894),heltab2x128(:,:,1034))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(446),n2h64(754))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(825)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1035),h0tab(:,1035),[64,9,54],[0,0,0],3,2,wf4(:,16),wf16(:,118))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,895),heltab2x128(:,:,1035))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(447),n2h64(755))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(825)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1036),h0tab(:,1036),[64,9,54],[nMB,nMB,nMB],3,2,wf4(:,16),wf16(:,118))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,896),heltab2x128(:,:,1036))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(448),n2h64(756))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(826)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1037),h0tab(:,1037),[102,9,16],[0,0,0],3,2,wf16(:,172),wf4(:,11))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,172),G0H8(1),m3h16x8(:,61),heltab2x128(:,:,1037))
  call Hloop_A_Q(ntryL,G0H8(1),102,0,G1H8(105),n2h8(277))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(827)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1038),h0tab(:,1038),[102,9,16],[0,0,0],3,2,wf16(:,174),wf4(:,11))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,174),G0H8(1),m3h16x8(:,62),heltab2x128(:,:,1038))
  call Hloop_A_Q(ntryL,G0H8(1),102,0,G1H8(106),n2h8(278))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(828)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1039),h0tab(:,1039),[102,9,16],[0,0,0],3,2,wf16(:,172),wf4(:,16))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,172),G0H8(1),m3h16x8(:,63),heltab2x128(:,:,1039))
  call Hloop_A_Q(ntryL,G0H8(1),102,0,G1H8(110),n2h8(279))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(829)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1040),h0tab(:,1040),[102,9,16],[0,0,0],3,2,wf16(:,174),wf4(:,16))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,174),G0H8(1),m3h16x8(:,64),heltab2x128(:,:,1040))
  call Hloop_A_Q(ntryL,G0H8(1),102,0,G1H8(111),n2h8(280))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(631)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1041),h0tab(:,1041),[64,16,47],[0,0,0],3,1,wf32(:,98))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,897),heltab2x128(:,:,1041))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(449),n2h64(757))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(633)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1042),h0tab(:,1042),[64,16,47],[0,0,0],3,1,wf32(:,100))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,898),heltab2x128(:,:,1042))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(450),n2h64(758))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(635)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1043),h0tab(:,1043),[64,16,47],[0,0,0],3,1,wf32(:,102))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,899),heltab2x128(:,:,1043))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(451),n2h64(759))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(637)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1044),h0tab(:,1044),[64,16,47],[0,0,0],3,1,wf32(:,104))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,900),heltab2x128(:,:,1044))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(452),n2h64(760))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(631)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1045),h0tab(:,1045),[64,16,47],[0,0,0],3,1,wf32(:,98))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(453),m3h2x64(:,901),heltab2x128(:,:,1045))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(633)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1046),h0tab(:,1046),[64,16,47],[0,0,0],3,1,wf32(:,100))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(454),m3h2x64(:,902),heltab2x128(:,:,1046))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(635)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1047),h0tab(:,1047),[64,16,47],[0,0,0],3,1,wf32(:,102))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(455),m3h2x64(:,903),heltab2x128(:,:,1047))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(637)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1048),h0tab(:,1048),[64,16,47],[0,0,0],3,1,wf32(:,104))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(456),m3h2x64(:,904),heltab2x128(:,:,1048))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(830)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1049),h0tab(:,1049),[64,15,48],[0,0,0],3,2,wf16(:,33),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,905),heltab2x128(:,:,1049))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(457),n2h64(761))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(830)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1050),h0tab(:,1050),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,33),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,906),heltab2x128(:,:,1050))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(458),n2h64(762))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(830)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1051),h0tab(:,1051),[64,15,48],[0,0,0],3,2,wf16(:,33),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,907),heltab2x128(:,:,1051))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(459),n2h64(763))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(830)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1052),h0tab(:,1052),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,33),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,908),heltab2x128(:,:,1052))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(460),n2h64(764))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(830)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1053),h0tab(:,1053),[64,15,48],[0,0,0],3,2,wf16(:,33),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,909),heltab2x128(:,:,1053))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(461),n2h64(765))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(830)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1054),h0tab(:,1054),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,33),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,910),heltab2x128(:,:,1054))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(462),n2h64(766))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(830)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1055),h0tab(:,1055),[64,15,48],[0,0,0],3,2,wf16(:,33),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,911),heltab2x128(:,:,1055))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(463),n2h64(767))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(830)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1056),h0tab(:,1056),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,33),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,912),heltab2x128(:,:,1056))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(464),n2h64(768))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(831)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1057),h0tab(:,1057),[64,15,48],[0,0,0],3,2,wf16(:,183),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,913),heltab2x128(:,:,1057))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(465),n2h64(769))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(831)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1058),h0tab(:,1058),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,183),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,914),heltab2x128(:,:,1058))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(466),n2h64(770))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(831)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1059),h0tab(:,1059),[64,15,48],[0,0,0],3,2,wf16(:,183),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,915),heltab2x128(:,:,1059))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(467),n2h64(771))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(831)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1060),h0tab(:,1060),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,183),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,916),heltab2x128(:,:,1060))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(468),n2h64(772))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(831)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1061),h0tab(:,1061),[64,15,48],[0,0,0],3,2,wf16(:,183),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,917),heltab2x128(:,:,1061))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(469),n2h64(773))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(831)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1062),h0tab(:,1062),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,183),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,918),heltab2x128(:,:,1062))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(470),n2h64(774))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(831)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1063),h0tab(:,1063),[64,15,48],[0,0,0],3,2,wf16(:,183),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,919),heltab2x128(:,:,1063))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(471),n2h64(775))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(831)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1064),h0tab(:,1064),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,183),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,920),heltab2x128(:,:,1064))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(472),n2h64(776))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(832)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1065),h0tab(:,1065),[64,15,48],[0,0,0],3,2,wf16(:,35),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,921),heltab2x128(:,:,1065))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(473),n2h64(777))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(832)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1066),h0tab(:,1066),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,35),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,922),heltab2x128(:,:,1066))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(474),n2h64(778))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(832)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1067),h0tab(:,1067),[64,15,48],[0,0,0],3,2,wf16(:,35),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,923),heltab2x128(:,:,1067))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(475),n2h64(779))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(832)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1068),h0tab(:,1068),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,35),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,924),heltab2x128(:,:,1068))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(476),n2h64(780))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(832)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1069),h0tab(:,1069),[64,15,48],[0,0,0],3,2,wf16(:,35),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,925),heltab2x128(:,:,1069))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(477),n2h64(781))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(832)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1070),h0tab(:,1070),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,35),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,926),heltab2x128(:,:,1070))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(478),n2h64(782))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(832)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1071),h0tab(:,1071),[64,15,48],[0,0,0],3,2,wf16(:,35),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,927),heltab2x128(:,:,1071))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(479),n2h64(783))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(832)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1072),h0tab(:,1072),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,35),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,928),heltab2x128(:,:,1072))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(480),n2h64(784))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(833)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1073),h0tab(:,1073),[64,15,48],[0,0,0],3,2,wf16(:,184),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,929),heltab2x128(:,:,1073))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(481),n2h64(785))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(833)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1074),h0tab(:,1074),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,184),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,930),heltab2x128(:,:,1074))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(482),n2h64(786))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(833)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1075),h0tab(:,1075),[64,15,48],[0,0,0],3,2,wf16(:,184),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,931),heltab2x128(:,:,1075))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(483),n2h64(787))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(833)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1076),h0tab(:,1076),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,184),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,932),heltab2x128(:,:,1076))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(484),n2h64(788))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(833)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1077),h0tab(:,1077),[64,15,48],[0,0,0],3,2,wf16(:,184),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,933),heltab2x128(:,:,1077))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(485),n2h64(789))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(833)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1078),h0tab(:,1078),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,184),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,934),heltab2x128(:,:,1078))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(486),n2h64(790))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(833)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1079),h0tab(:,1079),[64,15,48],[0,0,0],3,2,wf16(:,184),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,935),heltab2x128(:,:,1079))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(487),n2h64(791))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(833)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1080),h0tab(:,1080),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,184),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,936),heltab2x128(:,:,1080))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(488),n2h64(792))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(834)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1081),h0tab(:,1081),[64,15,48],[0,0,0],3,2,wf16(:,37),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,937),heltab2x128(:,:,1081))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(489),n2h64(793))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(834)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1082),h0tab(:,1082),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,37),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,938),heltab2x128(:,:,1082))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(490),n2h64(794))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(834)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1083),h0tab(:,1083),[64,15,48],[0,0,0],3,2,wf16(:,37),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,939),heltab2x128(:,:,1083))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(491),n2h64(795))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(834)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1084),h0tab(:,1084),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,37),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,940),heltab2x128(:,:,1084))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(492),n2h64(796))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(834)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1085),h0tab(:,1085),[64,15,48],[0,0,0],3,2,wf16(:,37),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,941),heltab2x128(:,:,1085))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(493),n2h64(797))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(834)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1086),h0tab(:,1086),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,37),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,942),heltab2x128(:,:,1086))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(494),n2h64(798))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(834)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1087),h0tab(:,1087),[64,15,48],[0,0,0],3,2,wf16(:,37),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,943),heltab2x128(:,:,1087))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(495),n2h64(799))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(834)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1088),h0tab(:,1088),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,37),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,944),heltab2x128(:,:,1088))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(496),n2h64(800))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(835)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1089),h0tab(:,1089),[64,15,48],[0,0,0],3,2,wf16(:,38),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,945),heltab2x128(:,:,1089))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(497),n2h64(801))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(835)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1090),h0tab(:,1090),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,38),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,946),heltab2x128(:,:,1090))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(498),n2h64(802))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(835)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1091),h0tab(:,1091),[64,15,48],[0,0,0],3,2,wf16(:,38),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,947),heltab2x128(:,:,1091))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(499),n2h64(803))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(835)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1092),h0tab(:,1092),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,38),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,948),heltab2x128(:,:,1092))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(500),n2h64(804))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(835)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1093),h0tab(:,1093),[64,15,48],[0,0,0],3,2,wf16(:,38),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,949),heltab2x128(:,:,1093))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(501),n2h64(805))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(835)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1094),h0tab(:,1094),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,38),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,950),heltab2x128(:,:,1094))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(502),n2h64(806))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(835)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1095),h0tab(:,1095),[64,15,48],[0,0,0],3,2,wf16(:,38),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,951),heltab2x128(:,:,1095))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(503),n2h64(807))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(835)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1096),h0tab(:,1096),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,38),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,952),heltab2x128(:,:,1096))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(504),n2h64(808))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(836)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1097),h0tab(:,1097),[64,15,48],[0,0,0],3,2,wf16(:,185),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,953),heltab2x128(:,:,1097))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(505),n2h64(809))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(836)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1098),h0tab(:,1098),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,185),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,954),heltab2x128(:,:,1098))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(506),n2h64(810))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(836)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1099),h0tab(:,1099),[64,15,48],[0,0,0],3,2,wf16(:,185),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,955),heltab2x128(:,:,1099))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(507),n2h64(811))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(836)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1100),h0tab(:,1100),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,185),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,956),heltab2x128(:,:,1100))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(508),n2h64(812))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(836)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1101),h0tab(:,1101),[64,15,48],[0,0,0],3,2,wf16(:,185),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,957),heltab2x128(:,:,1101))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(509),n2h64(813))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(836)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1102),h0tab(:,1102),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,185),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,958),heltab2x128(:,:,1102))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(510),n2h64(814))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(836)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1103),h0tab(:,1103),[64,15,48],[0,0,0],3,2,wf16(:,185),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,959),heltab2x128(:,:,1103))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(511),n2h64(815))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(836)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1104),h0tab(:,1104),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,185),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,960),heltab2x128(:,:,1104))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(512),n2h64(816))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(837)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1105),h0tab(:,1105),[64,15,48],[0,0,0],3,2,wf16(:,186),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,961),heltab2x128(:,:,1105))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(513),n2h64(817))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(837)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1106),h0tab(:,1106),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,186),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,962),heltab2x128(:,:,1106))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(514),n2h64(818))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(837)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1107),h0tab(:,1107),[64,15,48],[0,0,0],3,2,wf16(:,186),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,963),heltab2x128(:,:,1107))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(515),n2h64(819))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(837)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1108),h0tab(:,1108),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,186),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,964),heltab2x128(:,:,1108))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(516),n2h64(820))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(837)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1109),h0tab(:,1109),[64,15,48],[0,0,0],3,2,wf16(:,186),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,965),heltab2x128(:,:,1109))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(517),n2h64(821))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(837)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1110),h0tab(:,1110),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,186),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,966),heltab2x128(:,:,1110))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(518),n2h64(822))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(837)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1111),h0tab(:,1111),[64,15,48],[0,0,0],3,2,wf16(:,186),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,967),heltab2x128(:,:,1111))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(519),n2h64(823))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(837)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1112),h0tab(:,1112),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,186),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,968),heltab2x128(:,:,1112))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(520),n2h64(824))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(838)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1113),h0tab(:,1113),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,33))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,81),heltab2x128(:,:,1113))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(35),n2h32(209))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(839)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1114),h0tab(:,1114),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,183))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,82),heltab2x128(:,:,1114))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(36),n2h32(210))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(840)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1115),h0tab(:,1115),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,35))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,83),heltab2x128(:,:,1115))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(38),n2h32(211))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(841)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1116),h0tab(:,1116),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,184))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,84),heltab2x128(:,:,1116))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(59),n2h32(212))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(842)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1117),h0tab(:,1117),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,37))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,85),heltab2x128(:,:,1117))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(60),n2h32(213))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(843)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1118),h0tab(:,1118),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,38))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,86),heltab2x128(:,:,1118))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(61),n2h32(214))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(844)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1119),h0tab(:,1119),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,185))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,87),heltab2x128(:,:,1119))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(64),n2h32(215))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(845)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1120),h0tab(:,1120),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,186))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,88),heltab2x128(:,:,1120))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(65),n2h32(216))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(846)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1121),h0tab(:,1121),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,33))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,89),heltab2x128(:,:,1121))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(66),n2h32(217))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(847)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1122),h0tab(:,1122),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,183))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,90),heltab2x128(:,:,1122))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(67),n2h32(218))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(848)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1123),h0tab(:,1123),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,35))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,91),heltab2x128(:,:,1123))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(70),n2h32(219))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(849)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1124),h0tab(:,1124),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,184))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,92),heltab2x128(:,:,1124))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(71),n2h32(220))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(850)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1125),h0tab(:,1125),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,37))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,93),heltab2x128(:,:,1125))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(72),n2h32(221))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(851)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1126),h0tab(:,1126),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,38))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,94),heltab2x128(:,:,1126))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(73),n2h32(222))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(852)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1127),h0tab(:,1127),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,185))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,95),heltab2x128(:,:,1127))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(76),n2h32(223))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(853)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1128),h0tab(:,1128),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,186))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,96),heltab2x128(:,:,1128))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(77),n2h32(224))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(638)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1129),h0tab(:,1129),[64,31,32],[0,0,0],3,1,wf32(:,106))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,969),heltab2x128(:,:,1129))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(521),n2h64(825))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(639)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1130),h0tab(:,1130),[64,31,32],[0,0,0],3,1,wf32(:,108))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,970),heltab2x128(:,:,1130))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(522),n2h64(826))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(640)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1131),h0tab(:,1131),[64,31,32],[0,0,0],3,1,wf32(:,110))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,971),heltab2x128(:,:,1131))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(523),n2h64(827))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(641)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1132),h0tab(:,1132),[64,31,32],[0,0,0],3,1,wf32(:,112))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,972),heltab2x128(:,:,1132))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(524),n2h64(828))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(638)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1133),h0tab(:,1133),[64,31,32],[0,0,0],3,1,wf32(:,106))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(525),m3h2x64(:,973),heltab2x128(:,:,1133))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(639)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1134),h0tab(:,1134),[64,31,32],[0,0,0],3,1,wf32(:,108))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(526),m3h2x64(:,974),heltab2x128(:,:,1134))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(640)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1135),h0tab(:,1135),[64,31,32],[0,0,0],3,1,wf32(:,110))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(527),m3h2x64(:,975),heltab2x128(:,:,1135))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(641)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1136),h0tab(:,1136),[64,31,32],[0,0,0],3,1,wf32(:,112))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(528),m3h2x64(:,976),heltab2x128(:,:,1136))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(642)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1137),h0tab(:,1137),[64,16,47],[0,0,0],3,1,wf32(:,114))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,977),heltab2x128(:,:,1137))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(529),n2h64(829))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(643)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1138),h0tab(:,1138),[64,16,47],[0,0,0],3,1,wf32(:,116))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,978),heltab2x128(:,:,1138))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(530),n2h64(830))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(644)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1139),h0tab(:,1139),[64,16,47],[0,0,0],3,1,wf32(:,118))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,979),heltab2x128(:,:,1139))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(531),n2h64(831))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(645)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1140),h0tab(:,1140),[64,16,47],[0,0,0],3,1,wf32(:,120))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,980),heltab2x128(:,:,1140))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(532),n2h64(832))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(642)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1141),h0tab(:,1141),[64,16,47],[0,0,0],3,1,wf32(:,114))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(533),m3h2x64(:,981),heltab2x128(:,:,1141))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(643)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1142),h0tab(:,1142),[64,16,47],[0,0,0],3,1,wf32(:,116))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(534),m3h2x64(:,982),heltab2x128(:,:,1142))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(644)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1143),h0tab(:,1143),[64,16,47],[0,0,0],3,1,wf32(:,118))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(535),m3h2x64(:,983),heltab2x128(:,:,1143))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(645)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1144),h0tab(:,1144),[64,16,47],[0,0,0],3,1,wf32(:,120))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(536),m3h2x64(:,984),heltab2x128(:,:,1144))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(646)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1145),h0tab(:,1145),[64,31,32],[0,0,0],3,1,wf32(:,122))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,985),heltab2x128(:,:,1145))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(537),n2h64(833))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(647)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1146),h0tab(:,1146),[64,31,32],[0,0,0],3,1,wf32(:,124))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,986),heltab2x128(:,:,1146))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(538),n2h64(834))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(648)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1147),h0tab(:,1147),[64,31,32],[0,0,0],3,1,wf32(:,126))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,987),heltab2x128(:,:,1147))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(539),n2h64(835))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(649)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1148),h0tab(:,1148),[64,31,32],[0,0,0],3,1,wf32(:,128))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,988),heltab2x128(:,:,1148))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(540),n2h64(836))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(646)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1149),h0tab(:,1149),[64,31,32],[0,0,0],3,1,wf32(:,122))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(541),m3h2x64(:,989),heltab2x128(:,:,1149))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(647)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1150),h0tab(:,1150),[64,31,32],[0,0,0],3,1,wf32(:,124))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(542),m3h2x64(:,990),heltab2x128(:,:,1150))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(648)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1151),h0tab(:,1151),[64,31,32],[0,0,0],3,1,wf32(:,126))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(543),m3h2x64(:,991),heltab2x128(:,:,1151))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(649)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1152),h0tab(:,1152),[64,31,32],[0,0,0],3,1,wf32(:,128))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(544),m3h2x64(:,992),heltab2x128(:,:,1152))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(650)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1153),h0tab(:,1153),[64,16,47],[0,0,0],3,1,wf32(:,130))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,993),heltab2x128(:,:,1153))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(545),n2h64(837))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(651)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1154),h0tab(:,1154),[64,16,47],[0,0,0],3,1,wf32(:,132))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,994),heltab2x128(:,:,1154))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(546),n2h64(838))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(652)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1155),h0tab(:,1155),[64,16,47],[0,0,0],3,1,wf32(:,134))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,995),heltab2x128(:,:,1155))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(547),n2h64(839))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(653)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1156),h0tab(:,1156),[64,16,47],[0,0,0],3,1,wf32(:,136))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,996),heltab2x128(:,:,1156))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(548),n2h64(840))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(650)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1157),h0tab(:,1157),[64,16,47],[0,0,0],3,1,wf32(:,130))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(549),m3h2x64(:,997),heltab2x128(:,:,1157))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(651)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1158),h0tab(:,1158),[64,16,47],[0,0,0],3,1,wf32(:,132))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(550),m3h2x64(:,998),heltab2x128(:,:,1158))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(652)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1159),h0tab(:,1159),[64,16,47],[0,0,0],3,1,wf32(:,134))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(551),m3h2x64(:,999),heltab2x128(:,:,1159))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(653)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1160),h0tab(:,1160),[64,16,47],[0,0,0],3,1,wf32(:,136))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(552),m3h2x64(:,1000),heltab2x128(:,:,1160))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(854)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1161),h0tab(:,1161),[64,15,48],[0,0,0],3,2,wf16(:,41),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1001),heltab2x128(:,:,1161))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(553),n2h64(841))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(854)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1162),h0tab(:,1162),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,41),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1002),heltab2x128(:,:,1162))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(554),n2h64(842))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(854)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1163),h0tab(:,1163),[64,15,48],[0,0,0],3,2,wf16(:,41),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1003),heltab2x128(:,:,1163))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(555),n2h64(843))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(854)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1164),h0tab(:,1164),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,41),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1004),heltab2x128(:,:,1164))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(556),n2h64(844))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(854)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1165),h0tab(:,1165),[64,15,48],[0,0,0],3,2,wf16(:,41),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1005),heltab2x128(:,:,1165))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(557),n2h64(845))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(854)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1166),h0tab(:,1166),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,41),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1006),heltab2x128(:,:,1166))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(558),n2h64(846))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(854)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1167),h0tab(:,1167),[64,15,48],[0,0,0],3,2,wf16(:,41),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1007),heltab2x128(:,:,1167))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(559),n2h64(847))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(854)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1168),h0tab(:,1168),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,41),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1008),heltab2x128(:,:,1168))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(560),n2h64(848))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(855)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1169),h0tab(:,1169),[64,15,48],[0,0,0],3,2,wf16(:,187),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1009),heltab2x128(:,:,1169))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(561),n2h64(849))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(855)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1170),h0tab(:,1170),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,187),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1010),heltab2x128(:,:,1170))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(562),n2h64(850))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(855)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1171),h0tab(:,1171),[64,15,48],[0,0,0],3,2,wf16(:,187),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1011),heltab2x128(:,:,1171))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(563),n2h64(851))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(855)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1172),h0tab(:,1172),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,187),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1012),heltab2x128(:,:,1172))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(564),n2h64(852))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(855)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1173),h0tab(:,1173),[64,15,48],[0,0,0],3,2,wf16(:,187),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1013),heltab2x128(:,:,1173))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(565),n2h64(853))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(855)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1174),h0tab(:,1174),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,187),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1014),heltab2x128(:,:,1174))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(566),n2h64(854))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(855)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1175),h0tab(:,1175),[64,15,48],[0,0,0],3,2,wf16(:,187),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1015),heltab2x128(:,:,1175))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(567),n2h64(855))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(855)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1176),h0tab(:,1176),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,187),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1016),heltab2x128(:,:,1176))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(568),n2h64(856))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(856)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1177),h0tab(:,1177),[64,15,48],[0,0,0],3,2,wf16(:,43),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1017),heltab2x128(:,:,1177))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(569),n2h64(857))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(856)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1178),h0tab(:,1178),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,43),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1018),heltab2x128(:,:,1178))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(570),n2h64(858))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(856)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1179),h0tab(:,1179),[64,15,48],[0,0,0],3,2,wf16(:,43),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1019),heltab2x128(:,:,1179))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(571),n2h64(859))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(856)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1180),h0tab(:,1180),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,43),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1020),heltab2x128(:,:,1180))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(572),n2h64(860))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(856)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1181),h0tab(:,1181),[64,15,48],[0,0,0],3,2,wf16(:,43),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1021),heltab2x128(:,:,1181))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(573),n2h64(861))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(856)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1182),h0tab(:,1182),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,43),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1022),heltab2x128(:,:,1182))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(574),n2h64(862))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(856)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1183),h0tab(:,1183),[64,15,48],[0,0,0],3,2,wf16(:,43),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1023),heltab2x128(:,:,1183))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(575),n2h64(863))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(856)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1184),h0tab(:,1184),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,43),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1024),heltab2x128(:,:,1184))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(576),n2h64(864))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(857)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1185),h0tab(:,1185),[64,15,48],[0,0,0],3,2,wf16(:,188),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1025),heltab2x128(:,:,1185))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(577),n2h64(865))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(857)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1186),h0tab(:,1186),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,188),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1026),heltab2x128(:,:,1186))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(578),n2h64(866))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(857)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1187),h0tab(:,1187),[64,15,48],[0,0,0],3,2,wf16(:,188),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1027),heltab2x128(:,:,1187))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(579),n2h64(867))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(857)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1188),h0tab(:,1188),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,188),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1028),heltab2x128(:,:,1188))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(580),n2h64(868))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(857)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1189),h0tab(:,1189),[64,15,48],[0,0,0],3,2,wf16(:,188),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1029),heltab2x128(:,:,1189))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(581),n2h64(869))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(857)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1190),h0tab(:,1190),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,188),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1030),heltab2x128(:,:,1190))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(582),n2h64(870))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(857)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1191),h0tab(:,1191),[64,15,48],[0,0,0],3,2,wf16(:,188),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1031),heltab2x128(:,:,1191))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(583),n2h64(871))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(857)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1192),h0tab(:,1192),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,188),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1032),heltab2x128(:,:,1192))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(584),n2h64(872))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(858)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1193),h0tab(:,1193),[64,15,48],[0,0,0],3,2,wf16(:,45),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1033),heltab2x128(:,:,1193))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(585),n2h64(873))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(858)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1194),h0tab(:,1194),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,45),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1034),heltab2x128(:,:,1194))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(586),n2h64(874))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(858)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1195),h0tab(:,1195),[64,15,48],[0,0,0],3,2,wf16(:,45),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1035),heltab2x128(:,:,1195))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(587),n2h64(875))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(858)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1196),h0tab(:,1196),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,45),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1036),heltab2x128(:,:,1196))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(588),n2h64(876))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(858)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1197),h0tab(:,1197),[64,15,48],[0,0,0],3,2,wf16(:,45),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1037),heltab2x128(:,:,1197))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(589),n2h64(877))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(858)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1198),h0tab(:,1198),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,45),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1038),heltab2x128(:,:,1198))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(590),n2h64(878))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(858)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1199),h0tab(:,1199),[64,15,48],[0,0,0],3,2,wf16(:,45),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1039),heltab2x128(:,:,1199))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(591),n2h64(879))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(858)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1200),h0tab(:,1200),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,45),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1040),heltab2x128(:,:,1200))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(592),n2h64(880))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(859)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1201),h0tab(:,1201),[64,15,48],[0,0,0],3,2,wf16(:,189),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1041),heltab2x128(:,:,1201))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(593),n2h64(881))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(859)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1202),h0tab(:,1202),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,189),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1042),heltab2x128(:,:,1202))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(594),n2h64(882))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(859)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1203),h0tab(:,1203),[64,15,48],[0,0,0],3,2,wf16(:,189),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1043),heltab2x128(:,:,1203))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(595),n2h64(883))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(859)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1204),h0tab(:,1204),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,189),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1044),heltab2x128(:,:,1204))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(596),n2h64(884))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(859)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1205),h0tab(:,1205),[64,15,48],[0,0,0],3,2,wf16(:,189),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1045),heltab2x128(:,:,1205))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(597),n2h64(885))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(859)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1206),h0tab(:,1206),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,189),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1046),heltab2x128(:,:,1206))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(598),n2h64(886))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(859)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1207),h0tab(:,1207),[64,15,48],[0,0,0],3,2,wf16(:,189),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1047),heltab2x128(:,:,1207))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(599),n2h64(887))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(859)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1208),h0tab(:,1208),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,189),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1048),heltab2x128(:,:,1208))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(600),n2h64(888))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(860)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1209),h0tab(:,1209),[64,15,48],[0,0,0],3,2,wf16(:,47),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1049),heltab2x128(:,:,1209))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(601),n2h64(889))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(860)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1210),h0tab(:,1210),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,47),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1050),heltab2x128(:,:,1210))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(602),n2h64(890))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(860)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1211),h0tab(:,1211),[64,15,48],[0,0,0],3,2,wf16(:,47),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1051),heltab2x128(:,:,1211))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(603),n2h64(891))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(860)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1212),h0tab(:,1212),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,47),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1052),heltab2x128(:,:,1212))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(604),n2h64(892))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(860)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1213),h0tab(:,1213),[64,15,48],[0,0,0],3,2,wf16(:,47),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1053),heltab2x128(:,:,1213))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(605),n2h64(893))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(860)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1214),h0tab(:,1214),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,47),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1054),heltab2x128(:,:,1214))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(606),n2h64(894))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(860)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1215),h0tab(:,1215),[64,15,48],[0,0,0],3,2,wf16(:,47),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1055),heltab2x128(:,:,1215))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(607),n2h64(895))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(860)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1216),h0tab(:,1216),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,47),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1056),heltab2x128(:,:,1216))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(608),n2h64(896))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(861)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1217),h0tab(:,1217),[64,15,48],[0,0,0],3,2,wf16(:,190),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1057),heltab2x128(:,:,1217))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(609),n2h64(897))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(861)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1218),h0tab(:,1218),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,190),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1058),heltab2x128(:,:,1218))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(610),n2h64(898))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(861)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1219),h0tab(:,1219),[64,15,48],[0,0,0],3,2,wf16(:,190),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1059),heltab2x128(:,:,1219))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(611),n2h64(899))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(861)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1220),h0tab(:,1220),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,190),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1060),heltab2x128(:,:,1220))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(612),n2h64(900))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(861)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1221),h0tab(:,1221),[64,15,48],[0,0,0],3,2,wf16(:,190),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1061),heltab2x128(:,:,1221))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(613),n2h64(901))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(861)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1222),h0tab(:,1222),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,190),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1062),heltab2x128(:,:,1222))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(614),n2h64(902))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(861)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1223),h0tab(:,1223),[64,15,48],[0,0,0],3,2,wf16(:,190),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1063),heltab2x128(:,:,1223))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(615),n2h64(903))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(861)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1224),h0tab(:,1224),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,190),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1064),heltab2x128(:,:,1224))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(616),n2h64(904))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(862)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1225),h0tab(:,1225),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,41))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,97),heltab2x128(:,:,1225))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(78),n2h32(225))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(863)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1226),h0tab(:,1226),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,187))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,98),heltab2x128(:,:,1226))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(79),n2h32(226))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(864)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1227),h0tab(:,1227),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,43))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,99),heltab2x128(:,:,1227))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(82),n2h32(227))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(865)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1228),h0tab(:,1228),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,188))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,100),heltab2x128(:,:,1228))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(83),n2h32(228))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(866)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1229),h0tab(:,1229),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,45))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,101),heltab2x128(:,:,1229))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(84),n2h32(229))



end subroutine vamp_1

end module ol_vamp_1_ppllllj_eeexexddxg_1_/**/REALKIND
