
module ol_vamp_1_ppllllj_nenexeexddxg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllllj_nenexeexddxg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllllj_nenexeexddxg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppllllj_nenexeexddxg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppllllj_nenexeexddxg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppllllj_nenexeexddxg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppllllj_nenexeexddxg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1),h0tab(:,1),[64,12,3,32,16],[0,0,0,0,0],5,2,wf4(:,2),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1),heltab2x128(:,:,1))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(1),n2h64(1))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(2),h0tab(:,2),[64,12,3,32,16],[0,0,0,0,0],5,2,wf4(:,7),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,2),heltab2x128(:,:,2))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(2),n2h64(2))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(3),h0tab(:,3),[64,3,12,32,16],[0,0,0,0,0],5,2,wf4(:,4),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,3),heltab2x128(:,:,3))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(3),n2h64(3))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(4),h0tab(:,4),[64,3,12,32,16],[0,0,0,0,0],5,2,wf4(:,4),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,4),heltab2x128(:,:,4))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(4),n2h64(4))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(5),h0tab(:,5),[64,12,3,16,32],[0,0,0,0,0],5,2,wf4(:,2),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,5),heltab2x128(:,:,5))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(5),n2h64(5))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(6),h0tab(:,6),[64,12,3,16,32],[0,0,0,0,0],5,2,wf4(:,7),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,6),heltab2x128(:,:,6))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(6),n2h64(6))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(7),h0tab(:,7),[64,3,16,32,12],[0,0,0,0,0],5,2,wf4(:,4),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,7),heltab2x128(:,:,7))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(7),n2h64(7))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(8),h0tab(:,8),[64,3,16,32,12],[0,0,0,0,0],5,2,wf4(:,4),wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,8),heltab2x128(:,:,8))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(8),n2h64(8))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(9),h0tab(:,9),[64,3,12,16,32],[0,0,0,0,0],5,2,wf4(:,4),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,9),heltab2x128(:,:,9))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(9),n2h64(9))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(10),h0tab(:,10),[64,3,12,16,32],[0,0,0,0,0],5,2,wf4(:,4),wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,10),heltab2x128(:,:,10))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(10),n2h64(10))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(11),h0tab(:,11),[64,3,32,16,12],[0,0,0,0,0],5,2,wf4(:,4),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,11),heltab2x128(:,:,11))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(11),n2h64(11))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(12),h0tab(:,12),[64,3,32,16,12],[0,0,0,0,0],5,2,wf4(:,4),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,12),heltab2x128(:,:,12))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(12),n2h64(12))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(13),h0tab(:,13),[64,16,3,12,32],[0,0,0,0,0],5,2,wf4(:,4),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(13),m3h2x64(:,13),heltab2x128(:,:,13))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(14),h0tab(:,14),[64,16,3,12,32],[0,0,0,0,0],5,2,wf4(:,4),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(14),m3h2x64(:,14),heltab2x128(:,:,14))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(15),h0tab(:,15),[64,16,12,3,32],[0,0,0,0,0],5,2,wf4(:,2),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(15),m3h2x64(:,15),heltab2x128(:,:,15))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(16),h0tab(:,16),[64,16,12,3,32],[0,0,0,0,0],5,2,wf4(:,7),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(16),m3h2x64(:,16),heltab2x128(:,:,16))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(17),h0tab(:,17),[64,9,6,32,16],[0,0,0,0,0],5,2,wf4(:,13),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,17),heltab2x128(:,:,17))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(17),n2h64(13))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(18),h0tab(:,18),[64,6,9,16,32],[0,0,0,0,0],5,2,wf4(:,12),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,18),heltab2x128(:,:,18))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(18),n2h64(14))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(19),h0tab(:,19),[64,6,32,16,9],[0,0,0,0,0],5,2,wf4(:,12),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,19),heltab2x128(:,:,19))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(19),n2h64(15))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(20),h0tab(:,20),[64,16,9,6,32],[0,0,0,0,0],5,2,wf4(:,13),wf4(:,12))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(20),m3h2x64(:,20),heltab2x128(:,:,20))
  call Hloop_QV_A(ntryL,G1H64(1),wf4(:,2),G1H16(1),m3h4x16(:,1),heltab2x64(:,:,1))
  call Hloop_Q_A(ntryL,G1H16(1),76,0,G2H16(1),n2h16(1))
  call Hloop_QZ_A(ntryL,G1H64(2),wf4(:,7),G1H16(1),ngZd,m3h4x16(:,2),heltab2x64(:,:,2))
  call Hloop_Q_A(ntryL,G1H16(1),76,0,G2H16(2),n2h16(2))
  call Hloop_QZ_A(ntryL,G1H64(3),wf4(:,4),G1H16(1),ngZd,m3h4x16(:,3),heltab2x64(:,:,3))
  call Hloop_Q_A(ntryL,G1H16(1),67,0,G2H16(3),n2h16(3))
  call Hloop_QZ_A(ntryL,G1H64(4),wf4(:,4),G1H16(1),ngZd,m3h4x16(:,4),heltab2x64(:,:,4))
  call Hloop_Q_A(ntryL,G1H16(1),67,0,G2H16(4),n2h16(4))
  call Hloop_AV_Q(ntryL,G1H64(5),wf4(:,2),G1H16(1),m3h4x16(:,5),heltab2x64(:,:,5))
  call Hloop_A_Q(ntryL,G1H16(1),76,0,G2H16(5),n2h16(5))
  call Hloop_AZ_Q(ntryL,G1H64(6),wf4(:,7),G1H16(1),ngZd,m3h4x16(:,6),heltab2x64(:,:,6))
  call Hloop_A_Q(ntryL,G1H16(1),76,0,G2H16(6),n2h16(6))
  call Hloop_AZ_Q(ntryL,G1H64(7),wf4(:,4),G1H16(1),ngZd,m3h4x16(:,7),heltab2x64(:,:,7))
  call Hloop_A_Q(ntryL,G1H16(1),67,0,G2H16(7),n2h16(7))
  call Hloop_AZ_Q(ntryL,G1H64(8),wf4(:,4),G1H16(1),ngZd,m3h4x16(:,8),heltab2x64(:,:,8))
  call Hloop_A_Q(ntryL,G1H16(1),67,0,G2H16(8),n2h16(8))
  call Hloop_AZ_Q(ntryL,G1H64(9),wf4(:,4),G1H16(1),ngZd,m3h4x16(:,9),heltab2x64(:,:,9))
  call Hloop_A_Q(ntryL,G1H16(1),67,0,G2H16(9),n2h16(9))
  call Hloop_AZ_Q(ntryL,G1H64(10),wf4(:,4),G1H16(1),ngZd,m3h4x16(:,10),heltab2x64(:,:,10))
  call Hloop_A_Q(ntryL,G1H16(1),67,0,G2H16(10),n2h16(10))
  call Hloop_QZ_A(ntryL,G1H64(11),wf4(:,4),G1H16(1),ngZd,m3h4x16(:,11),heltab2x64(:,:,11))
  call Hloop_Q_A(ntryL,G1H16(1),67,0,G2H16(11),n2h16(11))
  call Hloop_QZ_A(ntryL,G1H64(12),wf4(:,4),G1H16(1),ngZd,m3h4x16(:,12),heltab2x64(:,:,12))
  call Hloop_Q_A(ntryL,G1H16(1),67,0,G2H16(12),n2h16(12))
  call Hloop_VQ_A(ntryL,G1H64(13),ex5(:),G1H32(1),m3h2x32(:,1),heltab2x64(:,:,13))
  call Hloop_Q_A(ntryL,G1H32(1),80,0,G2H32(1),n2h32(1))
  call Hloop_VQ_A(ntryL,G1H64(14),ex5(:),G1H32(1),m3h2x32(:,2),heltab2x64(:,:,14))
  call Hloop_Q_A(ntryL,G1H32(1),80,0,G2H32(2),n2h32(2))
  call Hloop_VQ_A(ntryL,G1H64(15),ex5(:),G1H32(1),m3h2x32(:,3),heltab2x64(:,:,15))
  call Hloop_Q_A(ntryL,G1H32(1),80,0,G2H32(3),n2h32(3))
  call Hloop_VQ_A(ntryL,G1H64(16),ex5(:),G1H32(1),m3h2x32(:,4),heltab2x64(:,:,16))
  call Hloop_Q_A(ntryL,G1H32(1),80,0,G2H32(4),n2h32(4))
  call Hloop_QW_A(ntryL,G1H64(17),wf4(:,13),G1H16(1),m3h4x16(:,13),heltab2x64(:,:,17))
  call Hloop_Q_A(ntryL,G1H16(1),73,0,G2H16(13),n2h16(13))
  call Hloop_AW_Q(ntryL,G1H64(18),wf4(:,12),G1H16(1),m3h4x16(:,14),heltab2x64(:,:,18))
  call Hloop_A_Q(ntryL,G1H16(1),70,0,G2H16(14),n2h16(14))
  call Hloop_QW_A(ntryL,G1H64(19),wf4(:,12),G1H16(1),m3h4x16(:,15),heltab2x64(:,:,19))
  call Hloop_Q_A(ntryL,G1H16(1),70,0,G2H16(15),n2h16(15))
  call Hloop_VQ_A(ntryL,G1H64(20),ex5(:),G1H32(1),m3h2x32(:,5),heltab2x64(:,:,20))
  call Hloop_Q_A(ntryL,G1H32(1),80,0,G2H32(5),n2h32(5))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(2),[G2H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(6),[G2H16(5)])
  call Hotf_5pt_reduction(G2H16(2),RedSet_5(1),mass5set(:,1),  & 
G1H16(1),G1H16(2),G1H16(3),G1H16(4),G1H16(5),G1H16(6),16)
  call HG1shiftOLR(G1H16(2),16,16)
  call Hotf_5pt_reduction(G2H16(3),RedSet_5(2),mass5set(:,1),  & 
G1H16(7),G1H16(8),G1H16(9),G1H16(10),G1H16(11),G1H16(12),16)
  call HG1shiftOLR(G1H16(8),16,16)
  call Hotf_5pt_reduction(G2H16(4),RedSet_5(2),mass5set(:,1),  & 
G1H16(13),G1H16(14),G1H16(15),G1H16(16),G1H16(17),G1H16(18),16)
  call HG1shiftOLR(G1H16(14),16,16)
  call Hotf_5pt_reduction(G2H16(6),RedSet_5(3),mass5set(:,1),  & 
G1H16(19),G1H16(20),G1H16(21),G1H16(22),G1H16(23),G1H16(24),16)
  call HG1shiftOLR(G1H16(20),32,16)
  call Hloop_AQ_V(ntryL,G2H16(7),ex5(:),G2H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_AQ_V(ntryL,G2H16(8),ex5(:),G2H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hotf_5pt_reduction(G2H16(9),RedSet_5(4),mass5set(:,1),  & 
G1H16(25),G1H16(26),G1H16(27),G1H16(28),G1H16(29),G1H16(30),16)
  call HG1shiftOLR(G1H16(26),32,16)
  call Hotf_5pt_reduction(G2H16(10),RedSet_5(4),mass5set(:,1),  & 
G1H16(31),G1H16(32),G1H16(33),G1H16(34),G1H16(35),G1H16(36),16)
  call HG1shiftOLR(G1H16(32),32,16)
  call Hloop_QA_V(ntryL,G2H16(11),ex6(:),G2H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_QA_V(ntryL,G2H16(12),ex6(:),G2H8(4),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hotf_5pt_reduction(G2H32(1),RedSet_5(5),mass5set(:,1),  & 
G1H32(1),G1H32(2),G1H32(3),G1H32(4),G1H32(5),G1H32(6),32)
  call HG1shiftOLR(G1H32(2),32,32)
  call Hotf_5pt_reduction(G2H32(2),RedSet_5(5),mass5set(:,1),  & 
G1H32(7),G1H32(8),G1H32(9),G1H32(10),G1H32(11),G1H32(12),32)
  call HG1shiftOLR(G1H32(8),32,32)
  call Hotf_5pt_reduction(G2H32(3),RedSet_5(6),mass5set(:,1),  & 
G1H32(13),G1H32(14),G1H32(15),G1H32(16),G1H32(17),G1H32(18),32)
  call HG1shiftOLR(G1H32(14),32,32)
  call Hotf_5pt_reduction(G2H32(4),RedSet_5(6),mass5set(:,1),  & 
G1H32(19),G1H32(20),G1H32(21),G1H32(22),G1H32(23),G1H32(24),32)
  call HG1shiftOLR(G1H32(20),32,32)
  call Hotf_5pt_reduction(G2H16(13),RedSet_5(7),mass5set(:,1),  & 
G1H16(37),G1H16(38),G1H16(39),G1H16(40),G1H16(41),G1H16(42),16)
  call HG1shiftOLR(G1H16(38),16,16)
  call Hotf_5pt_reduction(G2H16(14),RedSet_5(8),mass5set(:,1),  & 
G1H16(43),G1H16(44),G1H16(45),G1H16(46),G1H16(47),G1H16(48),16)
  call HG1shiftOLR(G1H16(44),32,16)
  call Hloop_QA_V(ntryL,G2H16(15),ex6(:),G2H8(5),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hotf_5pt_reduction(G2H32(5),RedSet_5(9),mass5set(:,1),  & 
G1H32(25),G1H32(26),G1H32(27),G1H32(28),G1H32(29),G1H32(30),32)
  call HG1shiftOLR(G1H32(26),32,32)
  call Hloop_QZ_A(ntryL,G1H16(1),wf4(:,4),G1H4(1),ngZd,m3h4x4(:,1),heltab2x16(:,:,6))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(1),n2h4(1))
call HGT_OLR(G1H16(2),1,1,16)
call HGT_invQ_OLR(G1H16(2),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(2),-16,0,G2H16(1),n2h16(16))
  call Hloop_AQ_V(ntryL,G2H16(1),ex5(:),G2H8(6),m3h2x8(:,6),heltab2x16(:,:,7))
  call Hloop_QZ_A(ntryL,G1H16(4),wf4(:,4),G1H4(1),ngZd,m3h4x4(:,2),heltab2x16(:,:,8))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(2),n2h4(2))
  call Hloop_QZ_A(ntryL,G1H16(5),wf4(:,4),G1H4(1),ngZd,m3h4x4(:,3),heltab2x16(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(3),n2h4(3))
  call Hloop_QZ_A(ntryL,G1H16(6),wf4(:,4),G1H4(1),ngZd,m3h4x4(:,4),heltab2x16(:,:,10))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(4),n2h4(4))
  call Hloop_QV_A(ntryL,G1H16(7),wf4(:,2),G1H4(1),m3h4x4(:,5),heltab2x16(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(5),n2h4(5))
call HGT_OLR(G1H16(8),1,1,16)
call HGT_invQ_OLR(G1H16(8),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(8),-16,0,G2H16(5),n2h16(17))
  call Hloop_AQ_V(ntryL,G2H16(5),ex5(:),G2H8(7),m3h2x8(:,7),heltab2x16(:,:,12))
  call Hloop_QV_A(ntryL,G1H16(10),wf4(:,2),G1H4(1),m3h4x4(:,6),heltab2x16(:,:,13))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(6),n2h4(6))
  call Hloop_QV_A(ntryL,G1H16(11),wf4(:,2),G1H4(1),m3h4x4(:,7),heltab2x16(:,:,14))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(7),n2h4(7))
  call Hloop_QV_A(ntryL,G1H16(12),wf4(:,2),G1H4(1),m3h4x4(:,8),heltab2x16(:,:,15))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(8),n2h4(8))
  call Hloop_QZ_A(ntryL,G1H16(13),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,9),heltab2x16(:,:,16))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(9),n2h4(9))
call HGT_OLR(G1H16(14),1,1,16)
call HGT_invQ_OLR(G1H16(14),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(14),-16,0,G2H16(2),n2h16(18))
  call Hloop_AQ_V(ntryL,G2H16(2),ex5(:),G2H8(8),m3h2x8(:,8),heltab2x16(:,:,17))
  call Hloop_QZ_A(ntryL,G1H16(16),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,10),heltab2x16(:,:,18))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(10),n2h4(10))
  call Hloop_QZ_A(ntryL,G1H16(17),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,11),heltab2x16(:,:,19))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(11),n2h4(11))
  call Hloop_QZ_A(ntryL,G1H16(18),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,12),heltab2x16(:,:,20))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(12),n2h4(12))
  call Hloop_AZ_Q(ntryL,G1H16(19),wf4(:,4),G1H4(1),ngZd,m3h4x4(:,13),heltab2x16(:,:,21))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(13),n2h4(13))
call HGT_OLR(G1H16(20),1,1,16)
call HGT_invQ_OLR(G1H16(20),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(20),-32,0,G2H16(3),n2h16(19))
  call Hloop_QA_V(ntryL,G2H16(3),ex6(:),G2H8(9),m3h2x8(:,9),heltab2x16(:,:,22))
  call Hloop_AZ_Q(ntryL,G1H16(22),wf4(:,4),G1H4(1),ngZd,m3h4x4(:,14),heltab2x16(:,:,23))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(14),n2h4(14))
  call Hloop_AZ_Q(ntryL,G1H16(23),wf4(:,4),G1H4(1),ngZd,m3h4x4(:,15),heltab2x16(:,:,24))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(15),n2h4(15))
  call Hloop_AZ_Q(ntryL,G1H16(24),wf4(:,4),G1H4(1),ngZd,m3h4x4(:,16),heltab2x16(:,:,25))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(16),n2h4(16))
  call Hloop_AV_Q(ntryL,G1H16(25),wf4(:,2),G1H4(1),m3h4x4(:,17),heltab2x16(:,:,26))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(17),n2h4(17))
call HGT_OLR(G1H16(26),1,1,16)
call HGT_invQ_OLR(G1H16(26),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(26),-32,0,G2H16(4),n2h16(20))
  call Hloop_QA_V(ntryL,G2H16(4),ex6(:),G2H8(10),m3h2x8(:,10),heltab2x16(:,:,27))
  call Hloop_AV_Q(ntryL,G1H16(28),wf4(:,2),G1H4(1),m3h4x4(:,18),heltab2x16(:,:,28))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(18),n2h4(18))
  call Hloop_AV_Q(ntryL,G1H16(29),wf4(:,2),G1H4(1),m3h4x4(:,19),heltab2x16(:,:,29))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(19),n2h4(19))
  call Hloop_AV_Q(ntryL,G1H16(30),wf4(:,2),G1H4(1),m3h4x4(:,20),heltab2x16(:,:,30))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(20),n2h4(20))
  call Hloop_AZ_Q(ntryL,G1H16(31),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,21),heltab2x16(:,:,31))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(21),n2h4(21))
call HGT_OLR(G1H16(32),1,1,16)
call HGT_invQ_OLR(G1H16(32),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(32),-32,0,G2H16(6),n2h16(21))
  call Hloop_QA_V(ntryL,G2H16(6),ex6(:),G2H8(11),m3h2x8(:,11),heltab2x16(:,:,32))
  call Hloop_AZ_Q(ntryL,G1H16(34),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,22),heltab2x16(:,:,33))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(22),n2h4(22))
  call Hloop_AZ_Q(ntryL,G1H16(35),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,23),heltab2x16(:,:,34))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(23),n2h4(23))
  call Hloop_AZ_Q(ntryL,G1H16(36),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,24),heltab2x16(:,:,35))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(24),n2h4(24))
  call Hloop_QZ_A(ntryL,G1H32(1),wf4(:,4),G1H8(1),ngZd,m3h4x8(:,1),heltab2x32(:,:,1))
  call Hloop_Q_A(ntryL,G1H8(1),83,0,G2H8(12),n2h8(1))
call HGT_raise_alpha_OLR(G1H32(2),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(2),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(2),ex6(:),G1H16(1),m3h2x16(:,1),heltab2x32(:,:,2))
  call Hloop_QZ_A(ntryL,G1H32(4),wf4(:,4),G1H8(1),ngZd,m3h4x8(:,2),heltab2x32(:,:,3))
  call Hloop_Q_A(ntryL,G1H8(1),83,0,G2H8(13),n2h8(2))
  call Hloop_QZ_A(ntryL,G1H32(5),wf4(:,4),G1H8(1),ngZd,m3h4x8(:,3),heltab2x32(:,:,4))
  call Hloop_Q_A(ntryL,G1H8(1),83,0,G2H8(14),n2h8(3))
  call Hloop_QZ_A(ntryL,G1H32(6),wf4(:,4),G1H8(1),ngZd,m3h4x8(:,4),heltab2x32(:,:,5))
  call Hloop_Q_A(ntryL,G1H8(1),83,0,G2H8(15),n2h8(4))
  call Hloop_QZ_A(ntryL,G1H32(7),wf4(:,4),G1H8(1),ngZd,m3h4x8(:,5),heltab2x32(:,:,6))
  call Hloop_Q_A(ntryL,G1H8(1),83,0,G2H8(16),n2h8(5))
call HGT_raise_alpha_OLR(G1H32(8),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(8),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(8),ex6(:),G1H16(2),m3h2x16(:,2),heltab2x32(:,:,7))
  call Hloop_QZ_A(ntryL,G1H32(10),wf4(:,4),G1H8(1),ngZd,m3h4x8(:,6),heltab2x32(:,:,8))
  call Hloop_Q_A(ntryL,G1H8(1),83,0,G2H8(17),n2h8(6))
  call Hloop_QZ_A(ntryL,G1H32(11),wf4(:,4),G1H8(1),ngZd,m3h4x8(:,7),heltab2x32(:,:,9))
  call Hloop_Q_A(ntryL,G1H8(1),83,0,G2H8(18),n2h8(7))
  call Hloop_QZ_A(ntryL,G1H32(12),wf4(:,4),G1H8(1),ngZd,m3h4x8(:,8),heltab2x32(:,:,10))
  call Hloop_Q_A(ntryL,G1H8(1),83,0,G2H8(19),n2h8(8))
  call Hloop_QV_A(ntryL,G1H32(13),wf4(:,2),G1H8(1),m3h4x8(:,9),heltab2x32(:,:,11))
  call Hloop_Q_A(ntryL,G1H8(1),92,0,G2H8(20),n2h8(9))
call HGT_raise_alpha_OLR(G1H32(14),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(14),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(14),ex6(:),G1H16(4),m3h2x16(:,3),heltab2x32(:,:,12))
  call Hloop_QV_A(ntryL,G1H32(16),wf4(:,2),G1H8(1),m3h4x8(:,10),heltab2x32(:,:,13))
  call Hloop_Q_A(ntryL,G1H8(1),92,0,G2H8(21),n2h8(10))
  call Hloop_QV_A(ntryL,G1H32(17),wf4(:,2),G1H8(1),m3h4x8(:,11),heltab2x32(:,:,14))
  call Hloop_Q_A(ntryL,G1H8(1),92,0,G2H8(22),n2h8(11))
  call Hloop_QV_A(ntryL,G1H32(18),wf4(:,2),G1H8(1),m3h4x8(:,12),heltab2x32(:,:,15))
  call Hloop_Q_A(ntryL,G1H8(1),92,0,G2H8(23),n2h8(12))
  call Hloop_QZ_A(ntryL,G1H32(19),wf4(:,7),G1H8(1),ngZd,m3h4x8(:,13),heltab2x32(:,:,16))
  call Hloop_Q_A(ntryL,G1H8(1),92,0,G2H8(24),n2h8(13))
call HGT_raise_alpha_OLR(G1H32(20),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(20),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(20),ex6(:),G1H16(5),m3h2x16(:,4),heltab2x32(:,:,17))
  call Hloop_QZ_A(ntryL,G1H32(22),wf4(:,7),G1H8(1),ngZd,m3h4x8(:,14),heltab2x32(:,:,18))
  call Hloop_Q_A(ntryL,G1H8(1),92,0,G2H8(25),n2h8(14))
  call Hloop_QZ_A(ntryL,G1H32(23),wf4(:,7),G1H8(1),ngZd,m3h4x8(:,15),heltab2x32(:,:,19))
  call Hloop_Q_A(ntryL,G1H8(1),92,0,G2H8(26),n2h8(15))
  call Hloop_QZ_A(ntryL,G1H32(24),wf4(:,7),G1H8(1),ngZd,m3h4x8(:,16),heltab2x32(:,:,20))
  call Hloop_Q_A(ntryL,G1H8(1),92,0,G2H8(27),n2h8(16))
  call Hloop_QW_A(ntryL,G1H16(37),wf4(:,12),G1H4(1),m3h4x4(:,25),heltab2x16(:,:,36))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(25),n2h4(25))
call HGT_OLR(G1H16(38),1,1,16)
call HGT_invQ_OLR(G1H16(38),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(38),-16,0,G2H16(7),n2h16(22))
  call Hloop_AQ_V(ntryL,G2H16(7),ex5(:),G2H8(28),m3h2x8(:,12),heltab2x16(:,:,37))
  call Hloop_QW_A(ntryL,G1H16(40),wf4(:,12),G1H4(1),m3h4x4(:,26),heltab2x16(:,:,38))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(26),n2h4(26))
  call Hloop_QW_A(ntryL,G1H16(41),wf4(:,12),G1H4(1),m3h4x4(:,27),heltab2x16(:,:,39))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(27),n2h4(27))
  call Hloop_QW_A(ntryL,G1H16(42),wf4(:,12),G1H4(1),m3h4x4(:,28),heltab2x16(:,:,40))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(28),n2h4(28))
  call Hloop_AW_Q(ntryL,G1H16(43),wf4(:,13),G1H4(1),m3h4x4(:,29),heltab2x16(:,:,41))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(29),n2h4(29))
call HGT_OLR(G1H16(44),1,1,16)
call HGT_invQ_OLR(G1H16(44),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(44),-32,0,G2H16(8),n2h16(23))
  call Hloop_QA_V(ntryL,G2H16(8),ex6(:),G2H8(29),m3h2x8(:,13),heltab2x16(:,:,42))
  call Hloop_AW_Q(ntryL,G1H16(46),wf4(:,13),G1H4(1),m3h4x4(:,30),heltab2x16(:,:,43))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(30),n2h4(30))
  call Hloop_AW_Q(ntryL,G1H16(47),wf4(:,13),G1H4(1),m3h4x4(:,31),heltab2x16(:,:,44))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(31),n2h4(31))
  call Hloop_AW_Q(ntryL,G1H16(48),wf4(:,13),G1H4(1),m3h4x4(:,32),heltab2x16(:,:,45))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(32),n2h4(32))
  call Hloop_QW_A(ntryL,G1H32(25),wf4(:,13),G1H8(1),m3h4x8(:,17),heltab2x32(:,:,21))
  call Hloop_Q_A(ntryL,G1H8(1),89,0,G2H8(30),n2h8(17))
call HGT_raise_alpha_OLR(G1H32(26),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(26),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(26),ex6(:),G1H16(6),m3h2x16(:,5),heltab2x32(:,:,22))
  call Hloop_QW_A(ntryL,G1H32(28),wf4(:,13),G1H8(1),m3h4x8(:,18),heltab2x32(:,:,23))
  call Hloop_Q_A(ntryL,G1H8(1),89,0,G2H8(31),n2h8(18))
  call Hloop_QW_A(ntryL,G1H32(29),wf4(:,13),G1H8(1),m3h4x8(:,19),heltab2x32(:,:,24))
  call Hloop_Q_A(ntryL,G1H8(1),89,0,G2H8(32),n2h8(19))
  call Hloop_QW_A(ntryL,G1H32(30),wf4(:,13),G1H8(1),m3h4x8(:,20),heltab2x32(:,:,25))
  call Hloop_Q_A(ntryL,G1H8(1),89,0,G2H8(33),n2h8(20))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G2H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G2H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G2H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(21),[G2H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(23),[G2H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(24),[G2H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(24),[G2H8(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(26),[G2H8(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(27),[G2H8(23)])
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(10),mass5set(:,1),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),G1H8(6),8)
  call HG1shiftOLR(G1H8(2),12,8)
  call Hotf_5pt_reduction(G2H8(2),RedSet_5(10),mass5set(:,1),  & 
G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),G1H8(12),8)
  call HG1shiftOLR(G1H8(8),12,8)
  call Hotf_5pt_reduction(G2H8(3),RedSet_5(11),mass5set(:,1),  & 
G1H8(13),G1H8(14),G1H8(15),G1H8(16),G1H8(17),G1H8(18),8)
  call HG1shiftOLR(G1H8(14),12,8)
  call Hotf_5pt_reduction(G2H8(4),RedSet_5(11),mass5set(:,1),  & 
G1H8(19),G1H8(20),G1H8(21),G1H8(22),G1H8(23),G1H8(24),8)
  call HG1shiftOLR(G1H8(20),12,8)
  call Hotf_5pt_reduction(G2H8(5),RedSet_5(12),mass5set(:,1),  & 
G1H8(25),G1H8(26),G1H8(27),G1H8(28),G1H8(29),G1H8(30),8)
  call HG1shiftOLR(G1H8(26),9,8)
  call Hloop_QA_V(ntryL,G2H4(1),ex6(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_V(ntryL,G2H4(3),ex6(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_V(ntryL,G2H4(4),ex6(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_V(ntryL,G2H4(9),ex6(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_QA_V(ntryL,G2H4(11),ex6(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QA_V(ntryL,G2H4(12),ex6(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_AQ_V(ntryL,G2H4(13),ex5(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_V(ntryL,G2H4(15),ex5(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_AQ_V(ntryL,G2H4(16),ex5(:),G2H2(9),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_AQ_V(ntryL,G2H4(21),ex5(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_AQ_V(ntryL,G2H4(23),ex5(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_AQ_V(ntryL,G2H4(24),ex5(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hotf_5pt_reduction(G2H8(12),RedSet_5(5),mass5set(:,1),  & 
G1H8(31),G1H8(32),G1H8(33),G1H8(34),G1H8(35),G1H8(36),8)
  call HG1shiftOLR(G1H8(32),32,8)
  call Hotf_4pt_reduction(G2H8(14),RedSet_4(1),mass4set(:,1),  & 
G1H8(37),G1H8(38),G1H8(39),G1H8(40),G1H8(41),8)
  call HG1shiftOLR(G1H8(38),32,8)
  call Hotf_4pt_reduction(G2H8(15),RedSet_4(2),mass4set(:,1),  & 
G1H8(42),G1H8(43),G1H8(44),G1H8(45),G1H8(46),8)
  call HG1shiftOLR(G1H8(43),44,8)
  call Hotf_5pt_reduction(G2H8(16),RedSet_5(5),mass5set(:,1),  & 
G1H8(47),G1H8(48),G1H8(49),G1H8(50),G1H8(51),G1H8(52),8)
  call HG1shiftOLR(G1H8(48),32,8)
  call Hotf_4pt_reduction(G2H8(18),RedSet_4(1),mass4set(:,1),  & 
G1H8(53),G1H8(54),G1H8(55),G1H8(56),G1H8(57),8)
  call HG1shiftOLR(G1H8(54),32,8)
  call Hotf_4pt_reduction(G2H8(19),RedSet_4(2),mass4set(:,1),  & 
G1H8(58),G1H8(59),G1H8(60),G1H8(61),G1H8(62),8)
  call HG1shiftOLR(G1H8(59),44,8)
  call Hotf_5pt_reduction(G2H8(24),RedSet_5(6),mass5set(:,1),  & 
G1H8(63),G1H8(64),G1H8(65),G1H8(66),G1H8(67),G1H8(68),8)
  call HG1shiftOLR(G1H8(64),32,8)
  call Hotf_4pt_reduction(G2H8(26),RedSet_4(1),mass4set(:,1),  & 
G1H8(69),G1H8(70),G1H8(71),G1H8(72),G1H8(73),8)
  call HG1shiftOLR(G1H8(70),32,8)
  call Hotf_4pt_reduction(G2H8(27),RedSet_4(3),mass4set(:,1),  & 
G1H8(74),G1H8(75),G1H8(76),G1H8(77),G1H8(78),8)
  call HG1shiftOLR(G1H8(75),35,8)
  call Hloop_QA_V(ntryL,G2H4(25),ex6(:),G2H2(13),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_QA_V(ntryL,G2H4(27),ex6(:),G2H2(14),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_QA_V(ntryL,G2H4(28),ex6(:),G2H2(15),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_AQ_V(ntryL,G2H4(29),ex5(:),G2H2(16),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_AQ_V(ntryL,G2H4(31),ex5(:),G2H2(17),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_AQ_V(ntryL,G2H4(32),ex5(:),G2H2(18),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hotf_5pt_reduction(G2H8(30),RedSet_5(9),mass5set(:,1),  & 
G1H8(79),G1H8(80),G1H8(81),G1H8(82),G1H8(83),G1H8(84),8)
  call HG1shiftOLR(G1H8(80),32,8)
  call Hotf_4pt_reduction(G2H8(32),RedSet_4(1),mass4set(:,1),  & 
G1H8(85),G1H8(86),G1H8(87),G1H8(88),G1H8(89),8)
  call HG1shiftOLR(G1H8(86),32,8)
  call Hotf_4pt_reduction(G2H8(33),RedSet_4(4),mass4set(:,1),  & 
G1H8(90),G1H8(91),G1H8(92),G1H8(93),G1H8(94),8)
  call HG1shiftOLR(G1H8(91),38,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(37),[G1H8(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(42),[G1H8(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(53),[G1H8(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(58),[G1H8(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(69),[G1H8(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(74),[G1H8(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(85),[G1H8(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(90),[G1H8(84)])
  call Hloop_VA_Q(ntryL,G1H8(1),ex6(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_A_Q(ntryL,G1H4(1),115,0,G2H4(5),n2h4(33))
call HGT_OLR(G1H8(2),1,1,8)
call HGT_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(2),-12,0,G2H8(20),n2h8(21))
  call Hloop_QV_A(ntryL,G2H8(20),wf4(:,2),G2H2(19),m3h4x2(:,1),heltab2x8(:,:,2))
  call Hloop_VA_Q(ntryL,G1H8(5),ex6(:),G1H4(1),m3h2x4(:,2),heltab2x8(:,:,3))
  call Hloop_A_Q(ntryL,G1H4(1),115,0,G2H4(7),n2h4(34))
  call Hloop_VA_Q(ntryL,G1H8(6),ex6(:),G1H4(1),m3h2x4(:,3),heltab2x8(:,:,4))
  call Hloop_A_Q(ntryL,G1H4(1),115,0,G2H4(8),n2h4(35))
  call Hloop_VA_Q(ntryL,G1H8(7),ex6(:),G1H4(1),m3h2x4(:,4),heltab2x8(:,:,5))
  call Hloop_A_Q(ntryL,G1H4(1),115,0,G2H4(17),n2h4(36))
call HGT_OLR(G1H8(8),1,1,8)
call HGT_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(8),-12,0,G2H8(22),n2h8(22))
  call Hloop_QZ_A(ntryL,G2H8(22),wf4(:,7),G2H2(20),ngZd,m3h4x2(:,2),heltab2x8(:,:,6))
  call Hloop_VA_Q(ntryL,G1H8(11),ex6(:),G1H4(1),m3h2x4(:,5),heltab2x8(:,:,7))
  call Hloop_A_Q(ntryL,G1H4(1),115,0,G2H4(19),n2h4(37))
  call Hloop_VA_Q(ntryL,G1H8(12),ex6(:),G1H4(1),m3h2x4(:,6),heltab2x8(:,:,8))
  call Hloop_A_Q(ntryL,G1H4(1),115,0,G2H4(20),n2h4(38))
  call Hloop_VQ_A(ntryL,G1H8(13),ex5(:),G1H4(1),m3h2x4(:,7),heltab2x8(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(1),115,0,G2H4(1),n2h4(39))
call HGT_OLR(G1H8(14),1,1,8)
call HGT_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(14),-12,0,G2H8(23),n2h8(23))
  call Hloop_AV_Q(ntryL,G2H8(23),wf4(:,2),G2H2(21),m3h4x2(:,3),heltab2x8(:,:,10))
  call Hloop_VQ_A(ntryL,G1H8(17),ex5(:),G1H4(1),m3h2x4(:,8),heltab2x8(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(1),115,0,G2H4(3),n2h4(40))
  call Hloop_VQ_A(ntryL,G1H8(18),ex5(:),G1H4(1),m3h2x4(:,9),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(1),115,0,G2H4(4),n2h4(41))
  call Hloop_VQ_A(ntryL,G1H8(19),ex5(:),G1H4(1),m3h2x4(:,10),heltab2x8(:,:,13))
  call Hloop_Q_A(ntryL,G1H4(1),115,0,G2H4(9),n2h4(42))
call HGT_OLR(G1H8(20),1,1,8)
call HGT_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(20),-12,0,G2H8(1),n2h8(24))
  call Hloop_AZ_Q(ntryL,G2H8(1),wf4(:,7),G2H2(22),ngZd,m3h4x2(:,4),heltab2x8(:,:,14))
  call Hloop_VQ_A(ntryL,G1H8(23),ex5(:),G1H4(1),m3h2x4(:,11),heltab2x8(:,:,15))
  call Hloop_Q_A(ntryL,G1H4(1),115,0,G2H4(11),n2h4(43))
  call Hloop_VQ_A(ntryL,G1H8(24),ex5(:),G1H4(1),m3h2x4(:,12),heltab2x8(:,:,16))
  call Hloop_Q_A(ntryL,G1H4(1),115,0,G2H4(12),n2h4(44))
  call Hloop_VQ_A(ntryL,G1H8(25),ex5(:),G1H4(1),m3h2x4(:,13),heltab2x8(:,:,17))
  call Hloop_Q_A(ntryL,G1H4(1),118,0,G2H4(13),n2h4(45))
call HGT_OLR(G1H8(26),1,1,8)
call HGT_invQ_OLR(G1H8(26),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(26),-9,0,G2H8(2),n2h8(25))
  call Hloop_AW_Q(ntryL,G2H8(2),wf4(:,13),G2H2(23),m3h4x2(:,5),heltab2x8(:,:,18))
  call Hloop_VQ_A(ntryL,G1H8(29),ex5(:),G1H4(1),m3h2x4(:,14),heltab2x8(:,:,19))
  call Hloop_Q_A(ntryL,G1H4(1),118,0,G2H4(15),n2h4(46))
  call Hloop_VQ_A(ntryL,G1H8(30),ex5(:),G1H4(1),m3h2x4(:,15),heltab2x8(:,:,20))
  call Hloop_Q_A(ntryL,G1H4(1),118,0,G2H4(16),n2h4(47))
  call Hloop_QV_A(ntryL,G1H8(31),wf4(:,2),G1H2(1),m3h4x2(:,6),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(24),n2h2(1))
call HGT_raise_alpha_OLR(G1H8(32),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(32),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(32),ex6(:),G1H4(1),m3h2x4(:,16),heltab2x8(:,:,22))
  call Hloop_QV_A(ntryL,G1H8(37),wf4(:,2),G1H2(1),m3h4x2(:,7),heltab2x8(:,:,23))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(25),n2h2(2))
  call Hloop_QV_A(ntryL,G1H8(42),wf4(:,2),G1H2(1),m3h4x2(:,8),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(26),n2h2(3))
call HGT_raise_alpha_OLR(G1H8(38),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(38),ex6(:),G1H4(2),m3h2x4(:,17),heltab2x8(:,:,25))
  call Hloop_QV_A(ntryL,G1H8(41),wf4(:,2),G1H2(1),m3h4x2(:,9),heltab2x8(:,:,26))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(27),n2h2(4))
call HGT_raise_alpha_OLR(G1H8(43),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(43),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(43),ex6(:),G1H4(3),m3h2x4(:,18),heltab2x8(:,:,27))
  call Hloop_QV_A(ntryL,G1H8(46),wf4(:,2),G1H2(1),m3h4x2(:,10),heltab2x8(:,:,28))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(28),n2h2(5))
  call Hloop_QZ_A(ntryL,G1H8(47),wf4(:,7),G1H2(1),ngZd,m3h4x2(:,11),heltab2x8(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(29),n2h2(6))
call HGT_raise_alpha_OLR(G1H8(48),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(48),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(48),ex6(:),G1H4(4),m3h2x4(:,19),heltab2x8(:,:,30))
  call Hloop_QZ_A(ntryL,G1H8(53),wf4(:,7),G1H2(1),ngZd,m3h4x2(:,12),heltab2x8(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(30),n2h2(7))
  call Hloop_QZ_A(ntryL,G1H8(58),wf4(:,7),G1H2(1),ngZd,m3h4x2(:,13),heltab2x8(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(31),n2h2(8))
call HGT_raise_alpha_OLR(G1H8(54),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(54),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(54),ex6(:),G1H4(5),m3h2x4(:,20),heltab2x8(:,:,33))
  call Hloop_QZ_A(ntryL,G1H8(57),wf4(:,7),G1H2(1),ngZd,m3h4x2(:,14),heltab2x8(:,:,34))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(32),n2h2(9))
call HGT_raise_alpha_OLR(G1H8(59),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(59),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(59),ex6(:),G1H4(6),m3h2x4(:,21),heltab2x8(:,:,35))
  call Hloop_QZ_A(ntryL,G1H8(62),wf4(:,7),G1H2(1),ngZd,m3h4x2(:,15),heltab2x8(:,:,36))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(33),n2h2(10))
  call Hloop_QZ_A(ntryL,G1H8(63),wf4(:,4),G1H2(1),ngZd,m3h4x2(:,16),heltab2x8(:,:,37))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(34),n2h2(11))
call HGT_raise_alpha_OLR(G1H8(64),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(64),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(64),ex6(:),G1H4(7),m3h2x4(:,22),heltab2x8(:,:,38))
  call Hloop_QZ_A(ntryL,G1H8(69),wf4(:,4),G1H2(1),ngZd,m3h4x2(:,17),heltab2x8(:,:,39))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(35),n2h2(12))
  call Hloop_QZ_A(ntryL,G1H8(74),wf4(:,4),G1H2(1),ngZd,m3h4x2(:,18),heltab2x8(:,:,40))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(36),n2h2(13))
call HGT_raise_alpha_OLR(G1H8(70),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(70),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(70),ex6(:),G1H4(8),m3h2x4(:,23),heltab2x8(:,:,41))
  call Hloop_QZ_A(ntryL,G1H8(73),wf4(:,4),G1H2(1),ngZd,m3h4x2(:,19),heltab2x8(:,:,42))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(37),n2h2(14))
call HGT_raise_alpha_OLR(G1H8(75),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(75),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(75),ex6(:),G1H4(9),m3h2x4(:,24),heltab2x8(:,:,43))
  call Hloop_QZ_A(ntryL,G1H8(78),wf4(:,4),G1H2(1),ngZd,m3h4x2(:,20),heltab2x8(:,:,44))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(38),n2h2(15))
  call Hloop_QW_A(ntryL,G1H8(79),wf4(:,12),G1H2(1),m3h4x2(:,21),heltab2x8(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(39),n2h2(16))
call HGT_raise_alpha_OLR(G1H8(80),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(80),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(80),ex6(:),G1H4(10),m3h2x4(:,25),heltab2x8(:,:,46))
  call Hloop_QW_A(ntryL,G1H8(85),wf4(:,12),G1H2(1),m3h4x2(:,22),heltab2x8(:,:,47))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(40),n2h2(17))
  call Hloop_QW_A(ntryL,G1H8(90),wf4(:,12),G1H2(1),m3h4x2(:,23),heltab2x8(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(41),n2h2(18))
call HGT_raise_alpha_OLR(G1H8(86),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(86),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(86),ex6(:),G1H4(11),m3h2x4(:,26),heltab2x8(:,:,49))
  call Hloop_QW_A(ntryL,G1H8(89),wf4(:,12),G1H2(1),m3h4x2(:,24),heltab2x8(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(42),n2h2(19))
call HGT_raise_alpha_OLR(G1H8(91),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(91),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(91),ex6(:),G1H4(12),m3h2x4(:,27),heltab2x8(:,:,51))
  call Hloop_QW_A(ntryL,G1H8(94),wf4(:,12),G1H2(1),m3h4x2(:,25),heltab2x8(:,:,52))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(43),n2h2(20))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G2H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(31),[G2H2(26)])
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(2),16,2)
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(5),mass4set(:,1),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),2)
  call HG1shiftOLR(G1H2(8),48,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(2),mass5set(:,1),  & 
G1H2(12),G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),2)
  call HG1shiftOLR(G1H2(13),16,2)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(6),mass4set(:,1),  & 
G1H2(18),G1H2(19),G1H2(20),G1H2(21),G1H2(22),2)
  call HG1shiftOLR(G1H2(19),48,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(3),mass5set(:,1),  & 
G1H2(23),G1H2(24),G1H2(25),G1H2(26),G1H2(27),G1H2(28),2)
  call HG1shiftOLR(G1H2(24),32,2)
  call Hotf_4pt_reduction(G2H2(9),RedSet_4(5),mass4set(:,1),  & 
G1H2(29),G1H2(30),G1H2(31),G1H2(32),G1H2(33),2)
  call HG1shiftOLR(G1H2(30),48,2)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(4),mass5set(:,1),  & 
G1H2(34),G1H2(35),G1H2(36),G1H2(37),G1H2(38),G1H2(39),2)
  call HG1shiftOLR(G1H2(35),32,2)
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(6),mass4set(:,1),  & 
G1H2(40),G1H2(41),G1H2(42),G1H2(43),G1H2(44),2)
  call HG1shiftOLR(G1H2(41),48,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(7),mass5set(:,1),  & 
G1H2(45),G1H2(46),G1H2(47),G1H2(48),G1H2(49),G1H2(50),2)
  call HG1shiftOLR(G1H2(46),16,2)
  call Hotf_4pt_reduction(G2H2(15),RedSet_4(7),mass4set(:,1),  & 
G1H2(51),G1H2(52),G1H2(53),G1H2(54),G1H2(55),2)
  call HG1shiftOLR(G1H2(52),48,2)
  call Hotf_5pt_reduction(G2H2(16),RedSet_5(8),mass5set(:,1),  & 
G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),G1H2(61),2)
  call HG1shiftOLR(G1H2(57),32,2)
  call Hotf_4pt_reduction(G2H2(18),RedSet_4(8),mass4set(:,1),  & 
G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(63),48,2)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(10),mass5set(:,1),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(14),12,4)
  call Hotf_4pt_reduction(G2H4(8),RedSet_4(9),mass4set(:,1),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),4)
  call HG1shiftOLR(G1H4(20),44,4)
  call Hotf_5pt_reduction(G2H4(17),RedSet_5(10),mass5set(:,1),  & 
G1H4(24),G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),4)
  call HG1shiftOLR(G1H4(25),12,4)
  call Hotf_4pt_reduction(G2H4(20),RedSet_4(9),mass4set(:,1),  & 
G1H4(30),G1H4(31),G1H4(32),G1H4(33),G1H4(34),4)
  call HG1shiftOLR(G1H4(31),44,4)
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(11),mass5set(:,1),  & 
G1H4(35),G1H4(36),G1H4(37),G1H4(38),G1H4(39),G1H4(40),4)
  call HG1shiftOLR(G1H4(36),12,4)
  call Hotf_4pt_reduction(G2H4(4),RedSet_4(10),mass4set(:,1),  & 
G1H4(41),G1H4(42),G1H4(43),G1H4(44),G1H4(45),4)
  call HG1shiftOLR(G1H4(42),28,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(11),mass5set(:,1),  & 
G1H4(46),G1H4(47),G1H4(48),G1H4(49),G1H4(50),G1H4(51),4)
  call HG1shiftOLR(G1H4(47),12,4)
  call Hotf_4pt_reduction(G2H4(12),RedSet_4(10),mass4set(:,1),  & 
G1H4(52),G1H4(53),G1H4(54),G1H4(55),G1H4(56),4)
  call HG1shiftOLR(G1H4(53),28,4)
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(12),mass5set(:,1),  & 
G1H4(57),G1H4(58),G1H4(59),G1H4(60),G1H4(61),G1H4(62),4)
  call HG1shiftOLR(G1H4(58),9,4)
  call Hotf_4pt_reduction(G2H4(16),RedSet_4(11),mass4set(:,1),  & 
G1H4(63),G1H4(64),G1H4(65),G1H4(66),G1H4(67),4)
  call HG1shiftOLR(G1H4(64),25,4)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(29),ex6(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(31),ex6(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(34),ex6(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(36),ex6(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(39),ex6(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(41),ex6(:),G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(7),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(18),[G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(29),[G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(40),[G1H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(51),[G1H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(62),[G1H2(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(19),[G1H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(30),[G1H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(41),[G1H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(52),[G1H4(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(63),[G1H4(62)])
  call Hloop_VQ_A(ntryL,G1H2(1),ex5(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(7),n2h1(1))
  call Hloop_VQ_A(ntryL,G1H2(2),ex5(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(8),n2h1(2))
  call Hloop_VQ_A(ntryL,G1H2(7),ex5(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(9),n2h1(3))
  call Hloop_VQ_A(ntryL,G1H2(8),ex5(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,0,G2tensor(10),n2h1(4))
  call Hloop_VQ_A(ntryL,G1H2(12),ex5(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(11),n2h1(5))
  call Hloop_VQ_A(ntryL,G1H2(13),ex5(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(12),n2h1(6))
  call Hloop_VQ_A(ntryL,G1H2(18),ex5(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(13),n2h1(7))
  call Hloop_VQ_A(ntryL,G1H2(19),ex5(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,0,G2tensor(14),n2h1(8))
  call Hloop_VA_Q(ntryL,G1H2(23),ex6(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(15),n2h1(9))
  call Hloop_VA_Q(ntryL,G1H2(24),ex6(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(16),n2h1(10))
  call Hloop_VA_Q(ntryL,G1H2(29),ex6(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(17),n2h1(11))
  call Hloop_VA_Q(ntryL,G1H2(30),ex6(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,0,G2tensor(18),n2h1(12))
  call Hloop_VA_Q(ntryL,G1H2(34),ex6(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(19),n2h1(13))
  call Hloop_VA_Q(ntryL,G1H2(35),ex6(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(20),n2h1(14))
  call Hloop_VA_Q(ntryL,G1H2(40),ex6(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(21),n2h1(15))
  call Hloop_VA_Q(ntryL,G1H2(41),ex6(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,0,G2tensor(22),n2h1(16))
  call Hloop_VQ_A(ntryL,G1H2(45),ex5(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(23),n2h1(17))
  call Hloop_VQ_A(ntryL,G1H2(46),ex5(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(24),n2h1(18))
  call Hloop_VQ_A(ntryL,G1H2(51),ex5(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(25),n2h1(19))
  call Hloop_VQ_A(ntryL,G1H2(52),ex5(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,0,G2tensor(26),n2h1(20))
  call Hloop_VA_Q(ntryL,G1H2(56),ex6(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(27),n2h1(21))
  call Hloop_VA_Q(ntryL,G1H2(57),ex6(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(28),n2h1(22))
  call Hloop_VA_Q(ntryL,G1H2(62),ex6(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(29),n2h1(23))
  call Hloop_VA_Q(ntryL,G1H2(63),ex6(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,0,G2tensor(30),n2h1(24))
  call Hloop_AV_Q(ntryL,G1H4(13),wf4(:,2),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(31),n2h1(25))
  call Hloop_AV_Q(ntryL,G1H4(14),wf4(:,2),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(32),n2h1(26))
  call Hloop_AV_Q(ntryL,G1H4(19),wf4(:,2),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(33),n2h1(27))
  call Hloop_AV_Q(ntryL,G1H4(20),wf4(:,2),G1H1(1),m3h4x1(:,4),heltab2x4(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),44,0,G2tensor(34),n2h1(28))
  call Hloop_AZ_Q(ntryL,G1H4(24),wf4(:,7),G1H1(1),ngZd,m3h4x1(:,5),heltab2x4(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(35),n2h1(29))
  call Hloop_AZ_Q(ntryL,G1H4(25),wf4(:,7),G1H1(1),ngZd,m3h4x1(:,6),heltab2x4(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(36),n2h1(30))
  call Hloop_AZ_Q(ntryL,G1H4(30),wf4(:,7),G1H1(1),ngZd,m3h4x1(:,7),heltab2x4(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(37),n2h1(31))
  call Hloop_AZ_Q(ntryL,G1H4(31),wf4(:,7),G1H1(1),ngZd,m3h4x1(:,8),heltab2x4(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),44,0,G2tensor(38),n2h1(32))
  call Hloop_QV_A(ntryL,G1H4(35),wf4(:,2),G1H1(1),m3h4x1(:,9),heltab2x4(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(39),n2h1(33))
  call Hloop_QV_A(ntryL,G1H4(36),wf4(:,2),G1H1(1),m3h4x1(:,10),heltab2x4(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(40),n2h1(34))
  call Hloop_QV_A(ntryL,G1H4(41),wf4(:,2),G1H1(1),m3h4x1(:,11),heltab2x4(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(41),n2h1(35))
  call Hloop_QV_A(ntryL,G1H4(42),wf4(:,2),G1H1(1),m3h4x1(:,12),heltab2x4(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),28,0,G2tensor(42),n2h1(36))
  call Hloop_QZ_A(ntryL,G1H4(46),wf4(:,7),G1H1(1),ngZd,m3h4x1(:,13),heltab2x4(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(43),n2h1(37))
  call Hloop_QZ_A(ntryL,G1H4(47),wf4(:,7),G1H1(1),ngZd,m3h4x1(:,14),heltab2x4(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(44),n2h1(38))
  call Hloop_QZ_A(ntryL,G1H4(52),wf4(:,7),G1H1(1),ngZd,m3h4x1(:,15),heltab2x4(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(45),n2h1(39))
  call Hloop_QZ_A(ntryL,G1H4(53),wf4(:,7),G1H1(1),ngZd,m3h4x1(:,16),heltab2x4(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),28,0,G2tensor(46),n2h1(40))
  call Hloop_QW_A(ntryL,G1H4(57),wf4(:,13),G1H1(1),m3h4x1(:,17),heltab2x4(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(47),n2h1(41))
  call Hloop_QW_A(ntryL,G1H4(58),wf4(:,13),G1H1(1),m3h4x1(:,18),heltab2x4(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(48),n2h1(42))
  call Hloop_QW_A(ntryL,G1H4(63),wf4(:,13),G1H1(1),m3h4x1(:,19),heltab2x4(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(49),n2h1(43))
  call Hloop_QW_A(ntryL,G1H4(64),wf4(:,13),G1H1(1),m3h4x1(:,20),heltab2x4(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),25,0,G2tensor(50),n2h1(44))
  call ol_merge_tensors(G2tensor(35),[G2tensor(31)])
  call ol_merge_tensors(G2tensor(43),[G2tensor(39)])
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(5),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),32)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(6),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),32)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(9),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),32)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(1),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),16)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(2),mass5set(:,1),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),16)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(3),mass5set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),32)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(4),mass5set(:,1),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),32)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(7),mass5set(:,1),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),16)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(8),mass5set(:,1),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),32)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(10),mass5set(:,1),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),12)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(11),mass5set(:,1),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),12)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(12),mass5set(:,1),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),9)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(21),h0tab(:,21),[64,3,48,12],[0,0,0,0],4,3,wf4(:,4),wf4(:,14),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,21),heltab2x128(:,:,21))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(1),n2h64(16))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(22),h0tab(:,22),[64,3,48,12],[nMT,nMT,nMT,nMT],4,3,wf4(:,4),wf4(:,14) &
    ,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,22),heltab2x128(:,:,22))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(2),n2h64(17))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(23),h0tab(:,23),[64,3,48,12],[0,0,0,0],4,3,wf4(:,4),wf4(:,14),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,23),heltab2x128(:,:,23))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(3),n2h64(18))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(24),h0tab(:,24),[64,3,48,12],[nMT,nMT,nMT,nMT],4,3,wf4(:,4),wf4(:,14) &
    ,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,24),heltab2x128(:,:,24))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(4),n2h64(19))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(25),h0tab(:,25),[64,3,48,12],[0,0,0,0],4,3,wf4(:,4),wf4(:,14),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,25),heltab2x128(:,:,25))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(5),n2h64(20))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(26),h0tab(:,26),[64,3,48,12],[nMB,nMB,nMB,nMB],4,3,wf4(:,4),wf4(:,14) &
    ,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,26),heltab2x128(:,:,26))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(6),n2h64(21))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(27),h0tab(:,27),[64,3,48,12],[0,0,0,0],4,3,wf4(:,4),wf4(:,14),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,27),heltab2x128(:,:,27))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(7),n2h64(22))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(28),h0tab(:,28),[64,3,48,12],[nMB,nMB,nMB,nMB],4,3,wf4(:,4),wf4(:,14) &
    ,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,28),heltab2x128(:,:,28))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(8),n2h64(23))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(29),h0tab(:,29),[64,3,48,12],[0,0,0,0],4,3,wf4(:,4),wf4(:,14),wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,29),heltab2x128(:,:,29))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(9),n2h64(24))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(30),h0tab(:,30),[64,3,48,12],[nMT,nMT,nMT,nMT],4,3,wf4(:,4),wf4(:,14) &
    ,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,30),heltab2x128(:,:,30))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(10),n2h64(25))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(31),h0tab(:,31),[64,3,48,12],[0,0,0,0],4,3,wf4(:,4),wf4(:,14),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,31),heltab2x128(:,:,31))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(11),n2h64(26))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(32),h0tab(:,32),[64,3,48,12],[nMT,nMT,nMT,nMT],4,3,wf4(:,4),wf4(:,14) &
    ,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,32),heltab2x128(:,:,32))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(12),n2h64(27))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(33),h0tab(:,33),[64,3,48,12],[0,0,0,0],4,3,wf4(:,4),wf4(:,14),wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,33),heltab2x128(:,:,33))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(13),n2h64(28))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(34),h0tab(:,34),[64,3,48,12],[nMB,nMB,nMB,nMB],4,3,wf4(:,4),wf4(:,14) &
    ,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,34),heltab2x128(:,:,34))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(14),n2h64(29))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(35),h0tab(:,35),[64,3,48,12],[0,0,0,0],4,3,wf4(:,4),wf4(:,14),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,35),heltab2x128(:,:,35))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(15),n2h64(30))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(36),h0tab(:,36),[64,3,48,12],[nMB,nMB,nMB,nMB],4,3,wf4(:,4),wf4(:,14) &
    ,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,36),heltab2x128(:,:,36))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(16),n2h64(31))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(37),h0tab(:,37),[64,3,12,48],[0,0,0,0],4,3,wf4(:,4),wf4(:,2),wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,37),heltab2x128(:,:,37))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(17),n2h64(32))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(38),h0tab(:,38),[64,3,12,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,4),wf4(:,2),wf4(: &
    ,14))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,38),heltab2x128(:,:,38))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(18),n2h64(33))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(39),h0tab(:,39),[64,3,12,48],[0,0,0,0],4,3,wf4(:,4),wf4(:,2),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,39),heltab2x128(:,:,39))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(19),n2h64(34))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(40),h0tab(:,40),[64,3,12,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,4),wf4(:,2),wf4(: &
    ,14))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,40),heltab2x128(:,:,40))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(20),n2h64(35))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(41),h0tab(:,41),[64,3,12,48],[0,0,0,0],4,3,wf4(:,4),wf4(:,2),wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,41),heltab2x128(:,:,41))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(21),n2h64(36))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(42),h0tab(:,42),[64,3,12,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,4),wf4(:,2),wf4(: &
    ,14))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,42),heltab2x128(:,:,42))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(22),n2h64(37))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(43),h0tab(:,43),[64,3,12,48],[0,0,0,0],4,3,wf4(:,4),wf4(:,2),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,43),heltab2x128(:,:,43))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(23),n2h64(38))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(44),h0tab(:,44),[64,3,12,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,4),wf4(:,2),wf4(: &
    ,14))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,44),heltab2x128(:,:,44))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(24),n2h64(39))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(45),h0tab(:,45),[64,3,12,48],[0,0,0,0],4,3,wf4(:,4),wf4(:,7),wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,45),heltab2x128(:,:,45))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(25),n2h64(40))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(46),h0tab(:,46),[64,3,12,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,4),wf4(:,7),wf4(: &
    ,14))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,46),heltab2x128(:,:,46))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(26),n2h64(41))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(47),h0tab(:,47),[64,3,12,48],[0,0,0,0],4,3,wf4(:,4),wf4(:,7),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,47),heltab2x128(:,:,47))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(27),n2h64(42))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(48),h0tab(:,48),[64,3,12,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,4),wf4(:,7),wf4(: &
    ,14))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,48),heltab2x128(:,:,48))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(28),n2h64(43))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(49),h0tab(:,49),[64,3,12,48],[0,0,0,0],4,3,wf4(:,4),wf4(:,7),wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,49),heltab2x128(:,:,49))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(29),n2h64(44))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(50),h0tab(:,50),[64,3,12,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,4),wf4(:,7),wf4(: &
    ,14))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,50),heltab2x128(:,:,50))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(30),n2h64(45))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(51),h0tab(:,51),[64,3,12,48],[0,0,0,0],4,3,wf4(:,4),wf4(:,7),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,51),heltab2x128(:,:,51))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(31),n2h64(46))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(52),h0tab(:,52),[64,3,12,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,4),wf4(:,7),wf4(: &
    ,14))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,52),heltab2x128(:,:,52))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(32),n2h64(47))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(53),h0tab(:,53),[64,12,3,48],[0,0,0,0],4,3,wf4(:,2),wf4(:,4),wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,53),heltab2x128(:,:,53))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(33),n2h64(48))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(54),h0tab(:,54),[64,12,3,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,2),wf4(:,4),wf4(: &
    ,14))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,54),heltab2x128(:,:,54))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(34),n2h64(49))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(55),h0tab(:,55),[64,12,3,48],[0,0,0,0],4,3,wf4(:,2),wf4(:,4),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,55),heltab2x128(:,:,55))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(35),n2h64(50))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(56),h0tab(:,56),[64,12,3,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,2),wf4(:,4),wf4(: &
    ,14))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,56),heltab2x128(:,:,56))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(36),n2h64(51))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(57),h0tab(:,57),[64,12,3,48],[0,0,0,0],4,3,wf4(:,2),wf4(:,4),wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,57),heltab2x128(:,:,57))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(37),n2h64(52))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(58),h0tab(:,58),[64,12,3,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,2),wf4(:,4),wf4(: &
    ,14))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,58),heltab2x128(:,:,58))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(38),n2h64(53))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(59),h0tab(:,59),[64,12,3,48],[0,0,0,0],4,3,wf4(:,2),wf4(:,4),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,59),heltab2x128(:,:,59))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(39),n2h64(54))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(60),h0tab(:,60),[64,12,3,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,2),wf4(:,4),wf4(: &
    ,14))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,60),heltab2x128(:,:,60))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(40),n2h64(55))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(61),h0tab(:,61),[64,12,3,48],[0,0,0,0],4,3,wf4(:,7),wf4(:,4),wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,61),heltab2x128(:,:,61))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(41),n2h64(56))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(62),h0tab(:,62),[64,12,3,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,7),wf4(:,4),wf4(: &
    ,14))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,62),heltab2x128(:,:,62))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(42),n2h64(57))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(63),h0tab(:,63),[64,12,3,48],[0,0,0,0],4,3,wf4(:,7),wf4(:,4),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,63),heltab2x128(:,:,63))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(43),n2h64(58))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(64),h0tab(:,64),[64,12,3,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,7),wf4(:,4),wf4(: &
    ,14))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,64),heltab2x128(:,:,64))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(44),n2h64(59))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(65),h0tab(:,65),[64,12,3,48],[0,0,0,0],4,3,wf4(:,7),wf4(:,4),wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,65),heltab2x128(:,:,65))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(45),n2h64(60))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(66),h0tab(:,66),[64,12,3,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,7),wf4(:,4),wf4(: &
    ,14))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,66),heltab2x128(:,:,66))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(46),n2h64(61))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(67),h0tab(:,67),[64,12,3,48],[0,0,0,0],4,3,wf4(:,7),wf4(:,4),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,67),heltab2x128(:,:,67))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(47),n2h64(62))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(68),h0tab(:,68),[64,12,3,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,7),wf4(:,4),wf4(: &
    ,14))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,68),heltab2x128(:,:,68))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(48),n2h64(63))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(307)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(69),h0tab(:,69),[80,12,3,32],[0,0,0,0],4,3,wf4(:,5),wf4(:,2),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,5),G0H32(1),m3h4x32(:,1),heltab2x128(:,:,69))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(1),n2h32(11))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(308)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(70),h0tab(:,70),[80,12,3,32],[0,0,0,0],4,3,wf4(:,5),wf4(:,7),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,5),G0H32(1),m3h4x32(:,2),heltab2x128(:,:,70))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(2),n2h32(12))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(307)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(71),h0tab(:,71),[80,3,12,32],[0,0,0,0],4,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,5),G0H32(1),m3h4x32(:,3),heltab2x128(:,:,71))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(4),n2h32(13))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(308)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(72),h0tab(:,72),[80,3,12,32],[0,0,0,0],4,3,wf4(:,5),wf4(:,4),wf4(:,7))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,5),G0H32(1),m3h4x32(:,4),heltab2x128(:,:,72))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(5),n2h32(14))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(313)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(73),h0tab(:,73),[96,12,3,16],[0,0,0,0],4,3,wf4(:,9),wf4(:,2),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,5),heltab2x128(:,:,73))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(6),n2h32(15))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(314)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(74),h0tab(:,74),[96,12,3,16],[0,0,0,0],4,3,wf4(:,9),wf4(:,7),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,6),heltab2x128(:,:,74))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(7),n2h32(16))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(313)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(75),h0tab(:,75),[96,3,12,16],[0,0,0,0],4,3,wf4(:,9),wf4(:,4),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,7),heltab2x128(:,:,75))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(8),n2h32(17))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(314)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(76),h0tab(:,76),[96,3,12,16],[0,0,0,0],4,3,wf4(:,9),wf4(:,4),wf4(:,7))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,8),heltab2x128(:,:,76))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(10),n2h32(18))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(245)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(77),h0tab(:,77),[64,19,12,32],[0,0,0,0],4,2,wf8(:,8),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(49),m3h2x64(:,69),heltab2x128(:,:,77))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(248)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(78),h0tab(:,78),[64,19,12,32],[0,0,0,0],4,2,wf8(:,8),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(50),m3h2x64(:,70),heltab2x128(:,:,78))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(245)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(79),h0tab(:,79),[64,12,19,32],[0,0,0,0],4,2,wf4(:,2),wf8(:,8))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,71),heltab2x128(:,:,79))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(51),n2h64(64))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(248)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(80),h0tab(:,80),[64,12,19,32],[0,0,0,0],4,2,wf4(:,7),wf8(:,8))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,72),heltab2x128(:,:,80))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(52),n2h64(65))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(245)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(81),h0tab(:,81),[64,12,32,19],[0,0,0,0],4,2,wf4(:,2),wf8(:,8))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,73),heltab2x128(:,:,81))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(53),n2h64(66))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(248)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(82),h0tab(:,82),[64,12,32,19],[0,0,0,0],4,2,wf4(:,7),wf8(:,8))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,74),heltab2x128(:,:,82))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(54),n2h64(67))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(251)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(83),h0tab(:,83),[64,16,12,35],[0,0,0,0],4,2,wf4(:,2),wf8(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(55),m3h2x64(:,75),heltab2x128(:,:,83))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(254)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(84),h0tab(:,84),[64,16,12,35],[0,0,0,0],4,2,wf4(:,7),wf8(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(56),m3h2x64(:,76),heltab2x128(:,:,84))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(251)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(85),h0tab(:,85),[64,12,35,16],[0,0,0,0],4,2,wf4(:,2),wf8(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,77),heltab2x128(:,:,85))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(57),n2h64(68))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(254)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(86),h0tab(:,86),[64,12,35,16],[0,0,0,0],4,2,wf4(:,7),wf8(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,78),heltab2x128(:,:,86))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(58),n2h64(69))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(251)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(87),h0tab(:,87),[64,12,16,35],[0,0,0,0],4,2,wf4(:,2),wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,79),heltab2x128(:,:,87))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(59),n2h64(70))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(254)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(88),h0tab(:,88),[64,12,16,35],[0,0,0,0],4,2,wf4(:,7),wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,80),heltab2x128(:,:,88))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(60),n2h64(71))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(259)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(89),h0tab(:,89),[64,28,3,32],[0,0,0,0],4,2,wf8(:,10),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(61),m3h2x64(:,81),heltab2x128(:,:,89))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(90),h0tab(:,90),[64,28,3,32],[0,0,0,0],4,2,wf8(:,12),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(62),m3h2x64(:,82),heltab2x128(:,:,90))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(259)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(91),h0tab(:,91),[64,3,28,32],[0,0,0,0],4,2,wf4(:,4),wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,83),heltab2x128(:,:,91))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(63),n2h64(72))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(92),h0tab(:,92),[64,3,28,32],[0,0,0,0],4,2,wf4(:,4),wf8(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,84),heltab2x128(:,:,92))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(64),n2h64(73))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(259)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(93),h0tab(:,93),[64,3,32,28],[0,0,0,0],4,2,wf4(:,4),wf8(:,10))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,85),heltab2x128(:,:,93))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(65),n2h64(74))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(94),h0tab(:,94),[64,3,32,28],[0,0,0,0],4,2,wf4(:,4),wf8(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,86),heltab2x128(:,:,94))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(66),n2h64(75))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(95),h0tab(:,95),[64,16,3,44],[0,0,0,0],4,2,wf4(:,4),wf8(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(67),m3h2x64(:,87),heltab2x128(:,:,95))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(267)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(96),h0tab(:,96),[64,16,3,44],[0,0,0,0],4,2,wf4(:,4),wf8(:,6))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(68),m3h2x64(:,88),heltab2x128(:,:,96))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(97),h0tab(:,97),[64,3,44,16],[0,0,0,0],4,2,wf4(:,4),wf8(:,4))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,89),heltab2x128(:,:,97))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(69),n2h64(76))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(267)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(98),h0tab(:,98),[64,3,44,16],[0,0,0,0],4,2,wf4(:,4),wf8(:,6))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,90),heltab2x128(:,:,98))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(70),n2h64(77))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(99),h0tab(:,99),[64,3,16,44],[0,0,0,0],4,2,wf4(:,4),wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,91),heltab2x128(:,:,99))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(71),n2h64(78))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(267)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(100),h0tab(:,100),[64,3,16,44],[0,0,0,0],4,2,wf4(:,4),wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,92),heltab2x128(:,:,100))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(72),n2h64(79))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(193)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(101),h0tab(:,101),[64,15,32,16],[0,0,0,0],4,1,wf16(:,10))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,93),heltab2x128(:,:,101))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(73),n2h64(80))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(195)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(102),h0tab(:,102),[64,15,32,16],[0,0,0,0],4,1,wf16(:,82))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,94),heltab2x128(:,:,102))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(74),n2h64(81))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(193)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(103),h0tab(:,103),[64,15,16,32],[0,0,0,0],4,1,wf16(:,10))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,95),heltab2x128(:,:,103))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(75),n2h64(82))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(195)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(104),h0tab(:,104),[64,15,16,32],[0,0,0,0],4,1,wf16(:,82))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,96),heltab2x128(:,:,104))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(76),n2h64(83))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(193)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(105),h0tab(:,105),[64,16,15,32],[0,0,0,0],4,1,wf16(:,10))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(77),m3h2x64(:,97),heltab2x128(:,:,105))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(195)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(106),h0tab(:,106),[64,16,15,32],[0,0,0,0],4,1,wf16(:,82))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(78),m3h2x64(:,98),heltab2x128(:,:,106))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(197)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(107),h0tab(:,107),[64,15,32,16],[0,0,0,0],4,1,wf16(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,99),heltab2x128(:,:,107))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(79),n2h64(84))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(199)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(108),h0tab(:,108),[64,15,32,16],[0,0,0,0],4,1,wf16(:,83))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,100),heltab2x128(:,:,108))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(80),n2h64(85))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(197)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(109),h0tab(:,109),[64,15,16,32],[0,0,0,0],4,1,wf16(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,101),heltab2x128(:,:,109))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(81),n2h64(86))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(199)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(110),h0tab(:,110),[64,15,16,32],[0,0,0,0],4,1,wf16(:,83))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,102),heltab2x128(:,:,110))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(82),n2h64(87))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(197)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(111),h0tab(:,111),[64,16,15,32],[0,0,0,0],4,1,wf16(:,12))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(83),m3h2x64(:,103),heltab2x128(:,:,111))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(199)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(112),h0tab(:,112),[64,16,15,32],[0,0,0,0],4,1,wf16(:,83))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(84),m3h2x64(:,104),heltab2x128(:,:,112))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(344)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(113),h0tab(:,113),[64,6,48,9],[0,0,0,0],4,3,wf4(:,12),wf4(:,14),wf4(: &
    ,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,105),heltab2x128(:,:,113))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(85),n2h64(88))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(344)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(114),h0tab(:,114),[64,6,48,9],[nMT,nMB,nMB,nMT],4,3,wf4(:,12),wf4(:,14) &
    ,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,106),heltab2x128(:,:,114))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(86),n2h64(89))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(344)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(115),h0tab(:,115),[64,6,48,9],[0,0,0,0],4,3,wf4(:,12),wf4(:,14),wf4(: &
    ,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,107),heltab2x128(:,:,115))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(87),n2h64(90))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(344)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(116),h0tab(:,116),[64,6,48,9],[nMB,nMT,nMT,nMB],4,3,wf4(:,12),wf4(:,14) &
    ,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,108),heltab2x128(:,:,116))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(88),n2h64(91))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(344)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(117),h0tab(:,117),[64,9,6,48],[0,0,0,0],4,3,wf4(:,13),wf4(:,12),wf4(: &
    ,14))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,109),heltab2x128(:,:,117))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(89),n2h64(92))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(344)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(118),h0tab(:,118),[64,9,6,48],[nMT,nMB,nMT,nMT],4,3,wf4(:,13),wf4(:,12) &
    ,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,110),heltab2x128(:,:,118))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(90),n2h64(93))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(344)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(119),h0tab(:,119),[64,9,6,48],[0,0,0,0],4,3,wf4(:,13),wf4(:,12),wf4(: &
    ,14))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,111),heltab2x128(:,:,119))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(91),n2h64(94))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(344)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(120),h0tab(:,120),[64,9,6,48],[nMB,nMT,nMB,nMB],4,3,wf4(:,13),wf4(:,12) &
    ,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,112),heltab2x128(:,:,120))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(92),n2h64(95))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(344)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(121),h0tab(:,121),[64,6,9,48],[0,0,0,0],4,3,wf4(:,12),wf4(:,13),wf4(: &
    ,14))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,113),heltab2x128(:,:,121))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(93),n2h64(96))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(344)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(122),h0tab(:,122),[64,6,9,48],[nMT,nMB,nMT,nMT],4,3,wf4(:,12),wf4(:,13) &
    ,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,114),heltab2x128(:,:,122))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(94),n2h64(97))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(344)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(123),h0tab(:,123),[64,6,9,48],[0,0,0,0],4,3,wf4(:,12),wf4(:,13),wf4(: &
    ,14))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,115),heltab2x128(:,:,123))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(95),n2h64(98))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(344)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(124),h0tab(:,124),[64,6,9,48],[nMB,nMT,nMB,nMB],4,3,wf4(:,12),wf4(:,13) &
    ,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,116),heltab2x128(:,:,124))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(96),n2h64(99))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(346)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(125),h0tab(:,125),[80,9,6,32],[0,0,0,0],4,3,wf4(:,5),wf4(:,13),wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,5),G0H32(1),m3h4x32(:,9),heltab2x128(:,:,125))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(11),n2h32(19))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(348)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(126),h0tab(:,126),[96,6,9,16],[0,0,0,0],4,3,wf4(:,9),wf4(:,12),wf4(:,13))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,10),heltab2x128(:,:,126))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(12),n2h32(20))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(127),h0tab(:,127),[64,25,6,32],[0,0,0,0],4,2,wf8(:,26),wf4(:,12))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(97),m3h2x64(:,117),heltab2x128(:,:,127))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(128),h0tab(:,128),[64,6,25,32],[0,0,0,0],4,2,wf4(:,12),wf8(:,26))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,118),heltab2x128(:,:,128))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(98),n2h64(100))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(129),h0tab(:,129),[64,6,32,25],[0,0,0,0],4,2,wf4(:,12),wf8(:,26))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,119),heltab2x128(:,:,129))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(99),n2h64(101))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(279)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(130),h0tab(:,130),[64,16,9,38],[0,0,0,0],4,2,wf4(:,13),wf8(:,24))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(100),m3h2x64(:,120),heltab2x128(:,:,130))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(279)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(131),h0tab(:,131),[64,9,38,16],[0,0,0,0],4,2,wf4(:,13),wf8(:,24))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,121),heltab2x128(:,:,131))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(101),n2h64(102))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(279)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(132),h0tab(:,132),[64,9,16,38],[0,0,0,0],4,2,wf4(:,13),wf8(:,24))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,122),heltab2x128(:,:,132))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(102),n2h64(103))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(133),h0tab(:,133),[64,15,32,16],[0,0,0,0],4,1,wf16(:,15))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,123),heltab2x128(:,:,133))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(103),n2h64(104))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(134),h0tab(:,134),[64,15,32,16],[0,0,0,0],4,1,wf16(:,58))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,124),heltab2x128(:,:,134))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(104),n2h64(105))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(135),h0tab(:,135),[64,15,16,32],[0,0,0,0],4,1,wf16(:,15))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,125),heltab2x128(:,:,135))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(105),n2h64(106))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(136),h0tab(:,136),[64,15,16,32],[0,0,0,0],4,1,wf16(:,58))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,126),heltab2x128(:,:,136))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(106),n2h64(107))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(137),h0tab(:,137),[64,16,15,32],[0,0,0,0],4,1,wf16(:,15))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(107),m3h2x64(:,127),heltab2x128(:,:,137))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(138),h0tab(:,138),[64,16,15,32],[0,0,0,0],4,1,wf16(:,58))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(108),m3h2x64(:,128),heltab2x128(:,:,138))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(139),h0tab(:,139),[64,15,32,16],[0,0,0,0],4,1,wf16(:,18))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,129),heltab2x128(:,:,139))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(109),n2h64(108))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(140),h0tab(:,140),[64,15,32,16],[0,0,0,0],4,1,wf16(:,89))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,130),heltab2x128(:,:,140))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(110),n2h64(109))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(141),h0tab(:,141),[64,15,16,32],[0,0,0,0],4,1,wf16(:,18))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,131),heltab2x128(:,:,141))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(111),n2h64(110))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(142),h0tab(:,142),[64,15,16,32],[0,0,0,0],4,1,wf16(:,89))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,132),heltab2x128(:,:,142))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(112),n2h64(111))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(143),h0tab(:,143),[64,16,15,32],[0,0,0,0],4,1,wf16(:,18))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(113),m3h2x64(:,133),heltab2x128(:,:,143))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(144),h0tab(:,144),[64,16,15,32],[0,0,0,0],4,1,wf16(:,89))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(114),m3h2x64(:,134),heltab2x128(:,:,144))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(223)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(145),h0tab(:,145),[64,15,32,16],[0,0,0,0],4,1,wf16(:,90))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,135),heltab2x128(:,:,145))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(115),n2h64(112))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(223)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(146),h0tab(:,146),[64,15,16,32],[0,0,0,0],4,1,wf16(:,90))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,136),heltab2x128(:,:,146))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(116),n2h64(113))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(223)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(147),h0tab(:,147),[64,16,15,32],[0,0,0,0],4,1,wf16(:,90))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(117),m3h2x64(:,137),heltab2x128(:,:,147))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(228)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(148),h0tab(:,148),[64,15,32,16],[0,0,0,0],4,1,wf16(:,21))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,138),heltab2x128(:,:,148))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(118),n2h64(114))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(230)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(149),h0tab(:,149),[64,15,32,16],[0,0,0,0],4,1,wf16(:,91))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,139),heltab2x128(:,:,149))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(119),n2h64(115))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(228)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(150),h0tab(:,150),[64,15,16,32],[0,0,0,0],4,1,wf16(:,21))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,140),heltab2x128(:,:,150))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(120),n2h64(116))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(230)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(151),h0tab(:,151),[64,15,16,32],[0,0,0,0],4,1,wf16(:,91))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,141),heltab2x128(:,:,151))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(121),n2h64(117))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(228)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(152),h0tab(:,152),[64,16,15,32],[0,0,0,0],4,1,wf16(:,21))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(122),m3h2x64(:,142),heltab2x128(:,:,152))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(230)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(153),h0tab(:,153),[64,16,15,32],[0,0,0,0],4,1,wf16(:,91))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(123),m3h2x64(:,143),heltab2x128(:,:,153))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(154),h0tab(:,154),[64,15,32,16],[0,0,0,0],4,1,wf16(:,92))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,144),heltab2x128(:,:,154))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(124),n2h64(118))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(155),h0tab(:,155),[64,15,16,32],[0,0,0,0],4,1,wf16(:,92))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,145),heltab2x128(:,:,155))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(125),n2h64(119))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(156),h0tab(:,156),[64,16,15,32],[0,0,0,0],4,1,wf16(:,92))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(126),m3h2x64(:,146),heltab2x128(:,:,156))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(237)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(157),h0tab(:,157),[64,15,32,16],[0,0,0,0],4,1,wf16(:,93))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,147),heltab2x128(:,:,157))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(127),n2h64(120))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(237)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(158),h0tab(:,158),[64,15,16,32],[0,0,0,0],4,1,wf16(:,93))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,148),heltab2x128(:,:,158))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(128),n2h64(121))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(237)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(159),h0tab(:,159),[64,16,15,32],[0,0,0,0],4,1,wf16(:,93))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(129),m3h2x64(:,149),heltab2x128(:,:,159))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(239)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(160),h0tab(:,160),[64,15,32,16],[0,0,0,0],4,1,wf16(:,94))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,150),heltab2x128(:,:,160))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(130),n2h64(122))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(239)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(161),h0tab(:,161),[64,15,16,32],[0,0,0,0],4,1,wf16(:,94))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,151),heltab2x128(:,:,161))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(131),n2h64(123))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(239)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(162),h0tab(:,162),[64,16,15,32],[0,0,0,0],4,1,wf16(:,94))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(132),m3h2x64(:,152),heltab2x128(:,:,162))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(4),[G1H32(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(5),[G1H32(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(1),[G1H32(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(2),[G1H32(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(11),[G1H32(27)])
  call Hloop_QZ_A(ntryL,G1H16(3),wf4(:,4),G1H4(18),ngZd,m3h4x4(:,33),heltab2x16(:,:,46))
  call Hloop_Q_A(ntryL,G1H4(18),79,0,G2H4(21),n2h4(48))
  call Hloop_QV_A(ntryL,G1H16(9),wf4(:,2),G1H4(29),m3h4x4(:,34),heltab2x16(:,:,47))
  call Hloop_Q_A(ntryL,G1H4(29),79,0,G2H4(23),n2h4(49))
  call Hloop_QZ_A(ntryL,G1H16(15),wf4(:,7),G1H4(40),ngZd,m3h4x4(:,35),heltab2x16(:,:,48))
  call Hloop_Q_A(ntryL,G1H4(40),79,0,G2H4(24),n2h4(50))
  call Hloop_AZ_Q(ntryL,G1H16(21),wf4(:,4),G1H4(51),ngZd,m3h4x4(:,36),heltab2x16(:,:,49))
  call Hloop_A_Q(ntryL,G1H4(51),79,0,G2H4(25),n2h4(51))
  call Hloop_AV_Q(ntryL,G1H16(27),wf4(:,2),G1H4(62),m3h4x4(:,37),heltab2x16(:,:,50))
  call Hloop_A_Q(ntryL,G1H4(62),79,0,G2H4(27),n2h4(52))
  call Hloop_AZ_Q(ntryL,G1H16(33),wf4(:,7),G1H4(13),ngZd,m3h4x4(:,38),heltab2x16(:,:,51))
  call Hloop_A_Q(ntryL,G1H4(13),79,0,G2H4(28),n2h4(53))
  call Hloop_QZ_A(ntryL,G1H32(4),wf4(:,4),G1H8(35),ngZd,m3h4x8(:,21),heltab2x32(:,:,26))
  call Hloop_Q_A(ntryL,G1H8(35),83,0,G2H8(3),n2h8(38))
  call Hloop_QZ_A(ntryL,G1H32(5),wf4(:,4),G1H8(36),ngZd,m3h4x8(:,22),heltab2x32(:,:,27))
  call Hloop_Q_A(ntryL,G1H8(36),83,0,G2H8(4),n2h8(39))
  call Hloop_QV_A(ntryL,G1H32(1),wf4(:,2),G1H8(51),m3h4x8(:,23),heltab2x32(:,:,28))
  call Hloop_Q_A(ntryL,G1H8(51),92,0,G2H8(5),n2h8(40))
  call Hloop_QZ_A(ntryL,G1H32(2),wf4(:,7),G1H8(52),ngZd,m3h4x8(:,24),heltab2x32(:,:,29))
  call Hloop_Q_A(ntryL,G1H8(52),92,0,G2H8(12),n2h8(41))
  call Hloop_QW_A(ntryL,G1H16(39),wf4(:,12),G1H4(14),m3h4x4(:,39),heltab2x16(:,:,52))
  call Hloop_Q_A(ntryL,G1H4(14),79,0,G2H4(29),n2h4(54))
  call Hloop_AW_Q(ntryL,G1H16(45),wf4(:,13),G1H4(19),m3h4x4(:,40),heltab2x16(:,:,53))
  call Hloop_A_Q(ntryL,G1H4(19),79,0,G2H4(31),n2h4(55))
  call Hloop_QW_A(ntryL,G1H32(11),wf4(:,13),G1H8(67),m3h4x8(:,25),heltab2x32(:,:,30))
  call Hloop_Q_A(ntryL,G1H8(67),89,0,G2H8(14),n2h8(42))
  call Hloop_AZ_Q(ntryL,G1H64(1),wf4(:,4),G1H16(7),ngZu,m3h4x16(:,16),heltab2x64(:,:,21))
  call Hloop_A_Q(ntryL,G1H16(7),67,0,G2H16(9),n2h16(24))
  call Hloop_AZ_Q(ntryL,G1H64(2),wf4(:,4),G1H16(8),ngZu,m3h4x16(:,17),heltab2x64(:,:,22))
  call Hloop_A_Q(ntryL,G1H16(8),67,nMT,G2H16(10),n2h16(25))
  call Hloop_QZ_A(ntryL,G1H64(3),wf4(:,4),G1H16(10),ngZu,m3h4x16(:,18),heltab2x64(:,:,23))
  call Hloop_Q_A(ntryL,G1H16(10),67,0,G2H16(11),n2h16(26))
  call Hloop_QZ_A(ntryL,G1H64(4),wf4(:,4),G1H16(11),ngZu,m3h4x16(:,19),heltab2x64(:,:,24))
  call Hloop_Q_A(ntryL,G1H16(11),67,nMT,G2H16(12),n2h16(27))
  call Hloop_AZ_Q(ntryL,G1H64(5),wf4(:,4),G1H16(12),ngZd,m3h4x16(:,20),heltab2x64(:,:,25))
  call Hloop_A_Q(ntryL,G1H16(12),67,0,G2H16(13),n2h16(28))
  call Hloop_AZ_Q(ntryL,G1H64(6),wf4(:,4),G1H16(13),ngZd,m3h4x16(:,21),heltab2x64(:,:,26))
  call Hloop_A_Q(ntryL,G1H16(13),67,nMB,G2H16(14),n2h16(29))
  call Hloop_QZ_A(ntryL,G1H64(7),wf4(:,4),G1H16(14),ngZd,m3h4x16(:,22),heltab2x64(:,:,27))
  call Hloop_Q_A(ntryL,G1H16(14),67,0,G2H16(15),n2h16(30))
  call Hloop_QZ_A(ntryL,G1H64(8),wf4(:,4),G1H16(16),ngZd,m3h4x16(:,23),heltab2x64(:,:,28))
  call Hloop_Q_A(ntryL,G1H16(16),67,nMB,G2H16(1),n2h16(31))
  call Hloop_AZ_Q(ntryL,G1H64(9),wf4(:,4),G1H16(17),ngZu,m3h4x16(:,24),heltab2x64(:,:,29))
  call Hloop_A_Q(ntryL,G1H16(17),67,0,G2H16(5),n2h16(32))
  call Hloop_AZ_Q(ntryL,G1H64(10),wf4(:,4),G1H16(18),ngZu,m3h4x16(:,25),heltab2x64(:,:,30))
  call Hloop_A_Q(ntryL,G1H16(18),67,nMT,G2H16(2),n2h16(33))
  call Hloop_QZ_A(ntryL,G1H64(11),wf4(:,4),G1H16(19),ngZu,m3h4x16(:,26),heltab2x64(:,:,31))
  call Hloop_Q_A(ntryL,G1H16(19),67,0,G2H16(3),n2h16(34))
  call Hloop_QZ_A(ntryL,G1H64(12),wf4(:,4),G1H16(20),ngZu,m3h4x16(:,27),heltab2x64(:,:,32))
  call Hloop_Q_A(ntryL,G1H16(20),67,nMT,G2H16(4),n2h16(35))
  call Hloop_AZ_Q(ntryL,G1H64(13),wf4(:,4),G1H16(22),ngZd,m3h4x16(:,28),heltab2x64(:,:,33))
  call Hloop_A_Q(ntryL,G1H16(22),67,0,G2H16(6),n2h16(36))
  call Hloop_AZ_Q(ntryL,G1H64(14),wf4(:,4),G1H16(23),ngZd,m3h4x16(:,29),heltab2x64(:,:,34))
  call Hloop_A_Q(ntryL,G1H16(23),67,nMB,G2H16(7),n2h16(37))
  call Hloop_QZ_A(ntryL,G1H64(15),wf4(:,4),G1H16(24),ngZd,m3h4x16(:,30),heltab2x64(:,:,35))
  call Hloop_Q_A(ntryL,G1H16(24),67,0,G2H16(8),n2h16(38))
  call Hloop_QZ_A(ntryL,G1H64(16),wf4(:,4),G1H16(25),ngZd,m3h4x16(:,31),heltab2x64(:,:,36))
  call Hloop_Q_A(ntryL,G1H16(25),67,nMB,G2H16(16),n2h16(39))
  call Hloop_AZ_Q(ntryL,G1H64(17),wf4(:,4),G1H16(26),ngZu,m3h4x16(:,32),heltab2x64(:,:,37))
  call Hloop_A_Q(ntryL,G1H16(26),67,0,G2H16(17),n2h16(40))
  call Hloop_AZ_Q(ntryL,G1H64(18),wf4(:,4),G1H16(28),ngZu,m3h4x16(:,33),heltab2x64(:,:,38))
  call Hloop_A_Q(ntryL,G1H16(28),67,nMT,G2H16(18),n2h16(41))
  call Hloop_QZ_A(ntryL,G1H64(19),wf4(:,4),G1H16(29),ngZu,m3h4x16(:,34),heltab2x64(:,:,39))
  call Hloop_Q_A(ntryL,G1H16(29),67,0,G2H16(19),n2h16(42))
  call Hloop_QZ_A(ntryL,G1H64(20),wf4(:,4),G1H16(30),ngZu,m3h4x16(:,35),heltab2x64(:,:,40))
  call Hloop_Q_A(ntryL,G1H16(30),67,nMT,G2H16(20),n2h16(43))
  call Hloop_AZ_Q(ntryL,G1H64(21),wf4(:,4),G1H16(31),ngZd,m3h4x16(:,36),heltab2x64(:,:,41))
  call Hloop_A_Q(ntryL,G1H16(31),67,0,G2H16(21),n2h16(44))
  call Hloop_AZ_Q(ntryL,G1H64(22),wf4(:,4),G1H16(32),ngZd,m3h4x16(:,37),heltab2x64(:,:,42))
  call Hloop_A_Q(ntryL,G1H16(32),67,nMB,G2H16(22),n2h16(45))
  call Hloop_QZ_A(ntryL,G1H64(23),wf4(:,4),G1H16(34),ngZd,m3h4x16(:,38),heltab2x64(:,:,43))
  call Hloop_Q_A(ntryL,G1H16(34),67,0,G2H16(23),n2h16(46))
  call Hloop_QZ_A(ntryL,G1H64(24),wf4(:,4),G1H16(35),ngZd,m3h4x16(:,39),heltab2x64(:,:,44))
  call Hloop_Q_A(ntryL,G1H16(35),67,nMB,G2H16(24),n2h16(47))
  call Hloop_AZ_Q(ntryL,G1H64(25),wf4(:,4),G1H16(36),ngZu,m3h4x16(:,40),heltab2x64(:,:,45))
  call Hloop_A_Q(ntryL,G1H16(36),67,0,G2H16(25),n2h16(48))
  call Hloop_AZ_Q(ntryL,G1H64(26),wf4(:,4),G1H16(37),ngZu,m3h4x16(:,41),heltab2x64(:,:,46))
  call Hloop_A_Q(ntryL,G1H16(37),67,nMT,G2H16(26),n2h16(49))
  call Hloop_QZ_A(ntryL,G1H64(27),wf4(:,4),G1H16(38),ngZu,m3h4x16(:,42),heltab2x64(:,:,47))
  call Hloop_Q_A(ntryL,G1H16(38),67,0,G2H16(27),n2h16(50))
  call Hloop_QZ_A(ntryL,G1H64(28),wf4(:,4),G1H16(40),ngZu,m3h4x16(:,43),heltab2x64(:,:,48))
  call Hloop_Q_A(ntryL,G1H16(40),67,nMT,G2H16(28),n2h16(51))
  call Hloop_AZ_Q(ntryL,G1H64(29),wf4(:,4),G1H16(41),ngZd,m3h4x16(:,44),heltab2x64(:,:,49))
  call Hloop_A_Q(ntryL,G1H16(41),67,0,G2H16(29),n2h16(52))
  call Hloop_AZ_Q(ntryL,G1H64(30),wf4(:,4),G1H16(42),ngZd,m3h4x16(:,45),heltab2x64(:,:,50))
  call Hloop_A_Q(ntryL,G1H16(42),67,nMB,G2H16(30),n2h16(53))
  call Hloop_QZ_A(ntryL,G1H64(31),wf4(:,4),G1H16(43),ngZd,m3h4x16(:,46),heltab2x64(:,:,51))
  call Hloop_Q_A(ntryL,G1H16(43),67,0,G2H16(31),n2h16(54))
  call Hloop_QZ_A(ntryL,G1H64(32),wf4(:,4),G1H16(44),ngZd,m3h4x16(:,47),heltab2x64(:,:,52))
  call Hloop_Q_A(ntryL,G1H16(44),67,nMB,G2H16(32),n2h16(55))
  call Hloop_AV_Q(ntryL,G1H64(33),wf4(:,2),G1H16(46),m3h4x16(:,48),heltab2x64(:,:,53))
  call Hloop_A_Q(ntryL,G1H16(46),76,0,G2H16(33),n2h16(56))
  call Hloop_AV_Q(ntryL,G1H64(34),wf4(:,2),G1H16(47),m3h4x16(:,49),heltab2x64(:,:,54))
  call Hloop_A_Q(ntryL,G1H16(47),76,nMT,G2H16(34),n2h16(57))
  call Hloop_QV_A(ntryL,G1H64(35),wf4(:,2),G1H16(48),m3h4x16(:,50),heltab2x64(:,:,55))
  call Hloop_Q_A(ntryL,G1H16(48),76,0,G2H16(35),n2h16(58))
  call Hloop_QV_A(ntryL,G1H64(36),wf4(:,2),G1H16(3),m3h4x16(:,51),heltab2x64(:,:,56))
  call Hloop_Q_A(ntryL,G1H16(3),76,nMT,G2H16(36),n2h16(59))
  call Hloop_AV_Q(ntryL,G1H64(37),wf4(:,2),G1H16(9),m3h4x16(:,52),heltab2x64(:,:,57))
  call Hloop_A_Q(ntryL,G1H16(9),76,0,G2H16(37),n2h16(60))
  call Hloop_AV_Q(ntryL,G1H64(38),wf4(:,2),G1H16(15),m3h4x16(:,53),heltab2x64(:,:,58))
  call Hloop_A_Q(ntryL,G1H16(15),76,nMB,G2H16(38),n2h16(61))
  call Hloop_QV_A(ntryL,G1H64(39),wf4(:,2),G1H16(21),m3h4x16(:,54),heltab2x64(:,:,59))
  call Hloop_Q_A(ntryL,G1H16(21),76,0,G2H16(39),n2h16(62))
  call Hloop_QV_A(ntryL,G1H64(40),wf4(:,2),G1H16(27),m3h4x16(:,55),heltab2x64(:,:,60))
  call Hloop_Q_A(ntryL,G1H16(27),76,nMB,G2H16(40),n2h16(63))
  call Hloop_AZ_Q(ntryL,G1H64(41),wf4(:,7),G1H16(33),ngZu,m3h4x16(:,56),heltab2x64(:,:,61))
  call Hloop_A_Q(ntryL,G1H16(33),76,0,G2H16(41),n2h16(64))
  call Hloop_AZ_Q(ntryL,G1H64(42),wf4(:,7),G1H16(39),ngZu,m3h4x16(:,57),heltab2x64(:,:,62))
  call Hloop_A_Q(ntryL,G1H16(39),76,nMT,G2H16(42),n2h16(65))
  call Hloop_QZ_A(ntryL,G1H64(43),wf4(:,7),G1H16(45),ngZu,m3h4x16(:,58),heltab2x64(:,:,63))
  call Hloop_Q_A(ntryL,G1H16(45),76,0,G2H16(43),n2h16(66))
  call Hloop_QZ_A(ntryL,G1H64(44),wf4(:,7),G1H16(7),ngZu,m3h4x16(:,59),heltab2x64(:,:,64))
  call Hloop_Q_A(ntryL,G1H16(7),76,nMT,G2H16(44),n2h16(67))
  call Hloop_AZ_Q(ntryL,G1H64(45),wf4(:,7),G1H16(8),ngZd,m3h4x16(:,60),heltab2x64(:,:,65))
  call Hloop_A_Q(ntryL,G1H16(8),76,0,G2H16(45),n2h16(68))
  call Hloop_AZ_Q(ntryL,G1H64(46),wf4(:,7),G1H16(10),ngZd,m3h4x16(:,61),heltab2x64(:,:,66))
  call Hloop_A_Q(ntryL,G1H16(10),76,nMB,G2H16(46),n2h16(69))
  call Hloop_QZ_A(ntryL,G1H64(47),wf4(:,7),G1H16(11),ngZd,m3h4x16(:,62),heltab2x64(:,:,67))
  call Hloop_Q_A(ntryL,G1H16(11),76,0,G2H16(47),n2h16(70))
  call Hloop_QZ_A(ntryL,G1H64(48),wf4(:,7),G1H16(12),ngZd,m3h4x16(:,63),heltab2x64(:,:,68))
  call Hloop_Q_A(ntryL,G1H16(12),76,nMB,G2H16(48),n2h16(71))
  call Hloop_AV_Q(ntryL,G1H32(6),wf4(:,2),G1H8(68),m3h4x8(:,26),heltab2x32(:,:,31))
  call Hloop_A_Q(ntryL,G1H8(68),108,0,G2H8(15),n2h8(43))
  call Hloop_AZ_Q(ntryL,G1H32(7),wf4(:,7),G1H8(83),ngZd,m3h4x8(:,27),heltab2x32(:,:,32))
  call Hloop_A_Q(ntryL,G1H8(83),108,0,G2H8(16),n2h8(44))
  call Hloop_AZ_Q(ntryL,G1H32(8),wf4(:,4),G1H8(84),ngZd,m3h4x8(:,28),heltab2x32(:,:,33))
  call Hloop_A_Q(ntryL,G1H8(84),99,0,G2H8(18),n2h8(45))
  call Hloop_AZ_Q(ntryL,G1H32(10),wf4(:,4),G1H8(1),ngZd,m3h4x8(:,29),heltab2x32(:,:,34))
  call Hloop_A_Q(ntryL,G1H8(1),99,0,G2H8(19),n2h8(46))
  call Hloop_VQ_A(ntryL,G1H64(49),wf8(:,8),G1H8(2),m3h8x8(:,1),heltab2x64(:,:,69))
  call Hloop_Q_A(ntryL,G1H8(2),83,0,G2H8(24),n2h8(47))
  call Hloop_VQ_A(ntryL,G1H64(50),wf8(:,8),G1H8(5),m3h8x8(:,2),heltab2x64(:,:,70))
  call Hloop_Q_A(ntryL,G1H8(5),83,0,G2H8(26),n2h8(48))
  call Hloop_AV_Q(ntryL,G1H64(51),wf4(:,2),G1H16(13),m3h4x16(:,64),heltab2x64(:,:,71))
  call Hloop_A_Q(ntryL,G1H16(13),76,0,G2H16(49),n2h16(72))
  call Hloop_AZ_Q(ntryL,G1H64(52),wf4(:,7),G1H16(14),ngZd,m3h4x16(:,65),heltab2x64(:,:,72))
  call Hloop_A_Q(ntryL,G1H16(14),76,0,G2H16(50),n2h16(73))
  call Hloop_QV_A(ntryL,G1H64(53),wf4(:,2),G1H16(16),m3h4x16(:,66),heltab2x64(:,:,73))
  call Hloop_Q_A(ntryL,G1H16(16),76,0,G2H16(51),n2h16(74))
  call Hloop_QZ_A(ntryL,G1H64(54),wf4(:,7),G1H16(17),ngZd,m3h4x16(:,67),heltab2x64(:,:,74))
  call Hloop_Q_A(ntryL,G1H16(17),76,0,G2H16(52),n2h16(75))
  call Hloop_VQ_A(ntryL,G1H64(55),ex5(:),G1H32(13),m3h2x32(:,6),heltab2x64(:,:,75))
  call Hloop_Q_A(ntryL,G1H32(13),80,0,G2H32(1),n2h32(21))
  call Hloop_VQ_A(ntryL,G1H64(56),ex5(:),G1H32(14),m3h2x32(:,7),heltab2x64(:,:,76))
  call Hloop_Q_A(ntryL,G1H32(14),80,0,G2H32(2),n2h32(22))
  call Hloop_QV_A(ntryL,G1H64(57),wf4(:,2),G1H16(18),m3h4x16(:,68),heltab2x64(:,:,77))
  call Hloop_Q_A(ntryL,G1H16(18),76,0,G2H16(53),n2h16(76))
  call Hloop_QZ_A(ntryL,G1H64(58),wf4(:,7),G1H16(19),ngZd,m3h4x16(:,69),heltab2x64(:,:,78))
  call Hloop_Q_A(ntryL,G1H16(19),76,0,G2H16(54),n2h16(77))
  call Hloop_AV_Q(ntryL,G1H64(59),wf4(:,2),G1H16(20),m3h4x16(:,70),heltab2x64(:,:,79))
  call Hloop_A_Q(ntryL,G1H16(20),76,0,G2H16(55),n2h16(78))
  call Hloop_AZ_Q(ntryL,G1H64(60),wf4(:,7),G1H16(22),ngZd,m3h4x16(:,71),heltab2x64(:,:,80))
  call Hloop_A_Q(ntryL,G1H16(22),76,0,G2H16(56),n2h16(79))
  call Hloop_VQ_A(ntryL,G1H64(61),wf8(:,10),G1H8(6),m3h8x8(:,3),heltab2x64(:,:,81))
  call Hloop_Q_A(ntryL,G1H8(6),92,0,G2H8(27),n2h8(49))
  call Hloop_VQ_A(ntryL,G1H64(62),wf8(:,12),G1H8(7),m3h8x8(:,4),heltab2x64(:,:,82))
  call Hloop_Q_A(ntryL,G1H8(7),92,0,G2H8(30),n2h8(50))
  call Hloop_AZ_Q(ntryL,G1H64(63),wf4(:,4),G1H16(23),ngZd,m3h4x16(:,72),heltab2x64(:,:,83))
  call Hloop_A_Q(ntryL,G1H16(23),67,0,G2H16(57),n2h16(80))
  call Hloop_AZ_Q(ntryL,G1H64(64),wf4(:,4),G1H16(24),ngZd,m3h4x16(:,73),heltab2x64(:,:,84))
  call Hloop_A_Q(ntryL,G1H16(24),67,0,G2H16(58),n2h16(81))
  call Hloop_QZ_A(ntryL,G1H64(65),wf4(:,4),G1H16(25),ngZd,m3h4x16(:,74),heltab2x64(:,:,85))
  call Hloop_Q_A(ntryL,G1H16(25),67,0,G2H16(59),n2h16(82))
  call Hloop_QZ_A(ntryL,G1H64(66),wf4(:,4),G1H16(26),ngZd,m3h4x16(:,75),heltab2x64(:,:,86))
  call Hloop_Q_A(ntryL,G1H16(26),67,0,G2H16(60),n2h16(83))
  call Hloop_VQ_A(ntryL,G1H64(67),ex5(:),G1H32(16),m3h2x32(:,8),heltab2x64(:,:,87))
  call Hloop_Q_A(ntryL,G1H32(16),80,0,G2H32(3),n2h32(23))
  call Hloop_VQ_A(ntryL,G1H64(68),ex5(:),G1H32(17),m3h2x32(:,9),heltab2x64(:,:,88))
  call Hloop_Q_A(ntryL,G1H32(17),80,0,G2H32(4),n2h32(24))
  call Hloop_QZ_A(ntryL,G1H64(69),wf4(:,4),G1H16(28),ngZd,m3h4x16(:,76),heltab2x64(:,:,89))
  call Hloop_Q_A(ntryL,G1H16(28),67,0,G2H16(61),n2h16(84))
  call Hloop_QZ_A(ntryL,G1H64(70),wf4(:,4),G1H16(29),ngZd,m3h4x16(:,77),heltab2x64(:,:,90))
  call Hloop_Q_A(ntryL,G1H16(29),67,0,G2H16(62),n2h16(85))
  call Hloop_AZ_Q(ntryL,G1H64(71),wf4(:,4),G1H16(30),ngZd,m3h4x16(:,78),heltab2x64(:,:,91))
  call Hloop_A_Q(ntryL,G1H16(30),67,0,G2H16(63),n2h16(86))
  call Hloop_AZ_Q(ntryL,G1H64(72),wf4(:,4),G1H16(31),ngZd,m3h4x16(:,79),heltab2x64(:,:,92))
  call Hloop_A_Q(ntryL,G1H16(31),67,0,G2H16(64),n2h16(87))
  call Hloop_QV_A(ntryL,G1H64(73),wf16(:,10),G1H4(20),m3h16x4(:,1),heltab2x64(:,:,93))
  call Hloop_Q_A(ntryL,G1H4(20),79,0,G2H4(32),n2h4(56))
  call Hloop_QZ_A(ntryL,G1H64(74),wf16(:,82),G1H4(24),ngZd,m3h16x4(:,2),heltab2x64(:,:,94))
  call Hloop_Q_A(ntryL,G1H4(24),79,0,G2H4(5),n2h4(57))
  call Hloop_AV_Q(ntryL,G1H64(75),wf16(:,10),G1H4(25),m3h16x4(:,3),heltab2x64(:,:,95))
  call Hloop_A_Q(ntryL,G1H4(25),79,0,G2H4(8),n2h4(58))
  call Hloop_AZ_Q(ntryL,G1H64(76),wf16(:,82),G1H4(30),ngZd,m3h16x4(:,4),heltab2x64(:,:,96))
  call Hloop_A_Q(ntryL,G1H4(30),79,0,G2H4(17),n2h4(59))
  call Hloop_VQ_A(ntryL,G1H64(77),ex5(:),G1H32(18),m3h2x32(:,10),heltab2x64(:,:,97))
  call Hloop_Q_A(ntryL,G1H32(18),80,0,G2H32(5),n2h32(25))
  call Hloop_VQ_A(ntryL,G1H64(78),ex5(:),G1H32(19),m3h2x32(:,11),heltab2x64(:,:,98))
  call Hloop_Q_A(ntryL,G1H32(19),80,0,G2H32(6),n2h32(26))
  call Hloop_QV_A(ntryL,G1H64(79),wf16(:,12),G1H4(31),m3h16x4(:,5),heltab2x64(:,:,99))
  call Hloop_Q_A(ntryL,G1H4(31),79,0,G2H4(20),n2h4(60))
  call Hloop_QZ_A(ntryL,G1H64(80),wf16(:,83),G1H4(35),ngZd,m3h16x4(:,6),heltab2x64(:,:,100))
  call Hloop_Q_A(ntryL,G1H4(35),79,0,G2H4(1),n2h4(61))
  call Hloop_AV_Q(ntryL,G1H64(81),wf16(:,12),G1H4(36),m3h16x4(:,7),heltab2x64(:,:,101))
  call Hloop_A_Q(ntryL,G1H4(36),79,0,G2H4(4),n2h4(62))
  call Hloop_AZ_Q(ntryL,G1H64(82),wf16(:,83),G1H4(41),ngZd,m3h16x4(:,8),heltab2x64(:,:,102))
  call Hloop_A_Q(ntryL,G1H4(41),79,0,G2H4(9),n2h4(63))
  call Hloop_VQ_A(ntryL,G1H64(83),ex5(:),G1H32(20),m3h2x32(:,12),heltab2x64(:,:,103))
  call Hloop_Q_A(ntryL,G1H32(20),80,0,G2H32(7),n2h32(27))
  call Hloop_VQ_A(ntryL,G1H64(84),ex5(:),G1H32(22),m3h2x32(:,13),heltab2x64(:,:,104))
  call Hloop_Q_A(ntryL,G1H32(22),80,0,G2H32(8),n2h32(28))
  call Hloop_QW_A(ntryL,G1H64(85),wf4(:,12),G1H16(32),m3h4x16(:,80),heltab2x64(:,:,105))
  call Hloop_Q_A(ntryL,G1H16(32),70,0,G2H16(65),n2h16(88))
  call Hloop_QW_A(ntryL,G1H64(86),wf4(:,12),G1H16(34),m3h4x16(:,81),heltab2x64(:,:,106))
  call Hloop_Q_A(ntryL,G1H16(34),70,nMB,G2H16(66),n2h16(89))
  call Hloop_AW_Q(ntryL,G1H64(87),wf4(:,12),G1H16(35),m3h4x16(:,82),heltab2x64(:,:,107))
  call Hloop_A_Q(ntryL,G1H16(35),70,0,G2H16(67),n2h16(90))
  call Hloop_AW_Q(ntryL,G1H64(88),wf4(:,12),G1H16(36),m3h4x16(:,83),heltab2x64(:,:,108))
  call Hloop_A_Q(ntryL,G1H16(36),70,nMT,G2H16(68),n2h16(91))
  call Hloop_AW_Q(ntryL,G1H64(89),wf4(:,13),G1H16(37),m3h4x16(:,84),heltab2x64(:,:,109))
  call Hloop_A_Q(ntryL,G1H16(37),73,0,G2H16(69),n2h16(92))
  call Hloop_AW_Q(ntryL,G1H64(90),wf4(:,13),G1H16(38),m3h4x16(:,85),heltab2x64(:,:,110))
  call Hloop_A_Q(ntryL,G1H16(38),73,nMB,G2H16(70),n2h16(93))
  call Hloop_QW_A(ntryL,G1H64(91),wf4(:,13),G1H16(40),m3h4x16(:,86),heltab2x64(:,:,111))
  call Hloop_Q_A(ntryL,G1H16(40),73,0,G2H16(71),n2h16(94))
  call Hloop_QW_A(ntryL,G1H64(92),wf4(:,13),G1H16(41),m3h4x16(:,87),heltab2x64(:,:,112))
  call Hloop_Q_A(ntryL,G1H16(41),73,nMT,G2H16(72),n2h16(95))
  call Hloop_QW_A(ntryL,G1H64(93),wf4(:,12),G1H16(42),m3h4x16(:,88),heltab2x64(:,:,113))
  call Hloop_Q_A(ntryL,G1H16(42),70,0,G2H16(73),n2h16(96))
  call Hloop_QW_A(ntryL,G1H64(94),wf4(:,12),G1H16(43),m3h4x16(:,89),heltab2x64(:,:,114))
  call Hloop_Q_A(ntryL,G1H16(43),70,nMB,G2H16(74),n2h16(97))
  call Hloop_AW_Q(ntryL,G1H64(95),wf4(:,12),G1H16(44),m3h4x16(:,90),heltab2x64(:,:,115))
  call Hloop_A_Q(ntryL,G1H16(44),70,0,G2H16(75),n2h16(98))
  call Hloop_AW_Q(ntryL,G1H64(96),wf4(:,12),G1H16(46),m3h4x16(:,91),heltab2x64(:,:,116))
  call Hloop_A_Q(ntryL,G1H16(46),70,nMT,G2H16(76),n2h16(99))
  call Hloop_AW_Q(ntryL,G1H32(12),wf4(:,12),G1H8(8),m3h4x8(:,30),heltab2x32(:,:,35))
  call Hloop_A_Q(ntryL,G1H8(8),102,0,G2H8(32),n2h8(51))
  call Hloop_VQ_A(ntryL,G1H64(97),wf8(:,26),G1H8(11),m3h8x8(:,5),heltab2x64(:,:,117))
  call Hloop_Q_A(ntryL,G1H8(11),89,0,G2H8(33),n2h8(52))
  call Hloop_AW_Q(ntryL,G1H64(98),wf4(:,12),G1H16(47),m3h4x16(:,92),heltab2x64(:,:,118))
  call Hloop_A_Q(ntryL,G1H16(47),70,0,G2H16(77),n2h16(100))
  call Hloop_QW_A(ntryL,G1H64(99),wf4(:,12),G1H16(48),m3h4x16(:,93),heltab2x64(:,:,119))
  call Hloop_Q_A(ntryL,G1H16(48),70,0,G2H16(78),n2h16(101))
  call Hloop_VQ_A(ntryL,G1H64(100),ex5(:),G1H32(23),m3h2x32(:,14),heltab2x64(:,:,120))
  call Hloop_Q_A(ntryL,G1H32(23),80,0,G2H32(9),n2h32(29))
  call Hloop_QW_A(ntryL,G1H64(101),wf4(:,13),G1H16(3),m3h4x16(:,94),heltab2x64(:,:,121))
  call Hloop_Q_A(ntryL,G1H16(3),73,0,G2H16(79),n2h16(102))
  call Hloop_AW_Q(ntryL,G1H64(102),wf4(:,13),G1H16(9),m3h4x16(:,95),heltab2x64(:,:,122))
  call Hloop_A_Q(ntryL,G1H16(9),73,0,G2H16(80),n2h16(103))
  call Hloop_QV_A(ntryL,G1H64(103),wf16(:,15),G1H4(42),m3h16x4(:,9),heltab2x64(:,:,123))
  call Hloop_Q_A(ntryL,G1H4(42),79,0,G2H4(12),n2h4(64))
  call Hloop_QZ_A(ntryL,G1H64(104),wf16(:,58),G1H4(46),ngZd,m3h16x4(:,10),heltab2x64(:,:,124))
  call Hloop_Q_A(ntryL,G1H4(46),79,0,G2H4(13),n2h4(65))
  call Hloop_AV_Q(ntryL,G1H64(105),wf16(:,15),G1H4(47),m3h16x4(:,11),heltab2x64(:,:,125))
  call Hloop_A_Q(ntryL,G1H4(47),79,0,G2H4(16),n2h4(66))
  call Hloop_AZ_Q(ntryL,G1H64(106),wf16(:,58),G1H4(52),ngZd,m3h16x4(:,12),heltab2x64(:,:,126))
  call Hloop_A_Q(ntryL,G1H4(52),79,0,G2H4(33),n2h4(67))
  call Hloop_VQ_A(ntryL,G1H64(107),ex5(:),G1H32(24),m3h2x32(:,15),heltab2x64(:,:,127))
  call Hloop_Q_A(ntryL,G1H32(24),80,0,G2H32(10),n2h32(30))
  call Hloop_VQ_A(ntryL,G1H64(108),ex5(:),G1H32(25),m3h2x32(:,16),heltab2x64(:,:,128))
  call Hloop_Q_A(ntryL,G1H32(25),80,0,G2H32(11),n2h32(31))
  call Hloop_QV_A(ntryL,G1H64(109),wf16(:,18),G1H4(53),m3h16x4(:,13),heltab2x64(:,:,129))
  call Hloop_Q_A(ntryL,G1H4(53),79,0,G2H4(34),n2h4(68))
  call Hloop_QZ_A(ntryL,G1H64(110),wf16(:,89),G1H4(57),ngZd,m3h16x4(:,14),heltab2x64(:,:,130))
  call Hloop_Q_A(ntryL,G1H4(57),79,0,G2H4(35),n2h4(69))
  call Hloop_AV_Q(ntryL,G1H64(111),wf16(:,18),G1H4(58),m3h16x4(:,15),heltab2x64(:,:,131))
  call Hloop_A_Q(ntryL,G1H4(58),79,0,G2H4(36),n2h4(70))
  call Hloop_AZ_Q(ntryL,G1H64(112),wf16(:,89),G1H4(63),ngZd,m3h16x4(:,16),heltab2x64(:,:,132))
  call Hloop_A_Q(ntryL,G1H4(63),79,0,G2H4(37),n2h4(71))
  call Hloop_VQ_A(ntryL,G1H64(113),ex5(:),G1H32(26),m3h2x32(:,17),heltab2x64(:,:,133))
  call Hloop_Q_A(ntryL,G1H32(26),80,0,G2H32(12),n2h32(32))
  call Hloop_VQ_A(ntryL,G1H64(114),ex5(:),G1H32(28),m3h2x32(:,18),heltab2x64(:,:,134))
  call Hloop_Q_A(ntryL,G1H32(28),80,0,G2H32(13),n2h32(33))
  call Hloop_QZ_A(ntryL,G1H64(115),wf16(:,90),G1H4(64),ngZd,m3h16x4(:,17),heltab2x64(:,:,135))
  call Hloop_Q_A(ntryL,G1H4(64),79,0,G2H4(38),n2h4(72))
  call Hloop_AZ_Q(ntryL,G1H64(116),wf16(:,90),G1H4(18),ngZd,m3h16x4(:,18),heltab2x64(:,:,136))
  call Hloop_A_Q(ntryL,G1H4(18),79,0,G2H4(39),n2h4(73))
  call Hloop_VQ_A(ntryL,G1H64(117),ex5(:),G1H32(29),m3h2x32(:,19),heltab2x64(:,:,137))
  call Hloop_Q_A(ntryL,G1H32(29),80,0,G2H32(14),n2h32(34))
  call Hloop_QV_A(ntryL,G1H64(118),wf16(:,21),G1H4(29),m3h16x4(:,19),heltab2x64(:,:,138))
  call Hloop_Q_A(ntryL,G1H4(29),79,0,G2H4(40),n2h4(74))
  call Hloop_QZ_A(ntryL,G1H64(119),wf16(:,91),G1H4(40),ngZd,m3h16x4(:,20),heltab2x64(:,:,139))
  call Hloop_Q_A(ntryL,G1H4(40),79,0,G2H4(41),n2h4(75))
  call Hloop_AV_Q(ntryL,G1H64(120),wf16(:,21),G1H4(51),m3h16x4(:,21),heltab2x64(:,:,140))
  call Hloop_A_Q(ntryL,G1H4(51),79,0,G2H4(42),n2h4(76))
  call Hloop_AZ_Q(ntryL,G1H64(121),wf16(:,91),G1H4(62),ngZd,m3h16x4(:,22),heltab2x64(:,:,141))
  call Hloop_A_Q(ntryL,G1H4(62),79,0,G2H4(43),n2h4(77))
  call Hloop_VQ_A(ntryL,G1H64(122),ex5(:),G1H32(30),m3h2x32(:,20),heltab2x64(:,:,142))
  call Hloop_Q_A(ntryL,G1H32(30),80,0,G2H32(15),n2h32(35))
  call Hloop_VQ_A(ntryL,G1H64(123),ex5(:),G1H32(3),m3h2x32(:,21),heltab2x64(:,:,143))
  call Hloop_Q_A(ntryL,G1H32(3),80,0,G2H32(16),n2h32(36))
  call Hloop_QZ_A(ntryL,G1H64(124),wf16(:,92),G1H4(13),ngZd,m3h16x4(:,23),heltab2x64(:,:,144))
  call Hloop_Q_A(ntryL,G1H4(13),79,0,G2H4(44),n2h4(78))
  call Hloop_AZ_Q(ntryL,G1H64(125),wf16(:,92),G1H4(14),ngZd,m3h16x4(:,24),heltab2x64(:,:,145))
  call Hloop_A_Q(ntryL,G1H4(14),79,0,G2H4(45),n2h4(79))
  call Hloop_VQ_A(ntryL,G1H64(126),ex5(:),G1H32(9),m3h2x32(:,22),heltab2x64(:,:,146))
  call Hloop_Q_A(ntryL,G1H32(9),80,0,G2H32(17),n2h32(37))
  call Hloop_QZ_A(ntryL,G1H64(127),wf16(:,93),G1H4(19),ngZd,m3h16x4(:,25),heltab2x64(:,:,147))
  call Hloop_Q_A(ntryL,G1H4(19),79,0,G2H4(46),n2h4(80))
  call Hloop_AZ_Q(ntryL,G1H64(128),wf16(:,93),G1H4(20),ngZd,m3h16x4(:,26),heltab2x64(:,:,148))
  call Hloop_A_Q(ntryL,G1H4(20),79,0,G2H4(47),n2h4(81))
  call Hloop_VQ_A(ntryL,G1H64(129),ex5(:),G1H32(15),m3h2x32(:,23),heltab2x64(:,:,149))
  call Hloop_Q_A(ntryL,G1H32(15),80,0,G2H32(18),n2h32(38))
  call Hloop_QZ_A(ntryL,G1H64(130),wf16(:,94),G1H4(24),ngZd,m3h16x4(:,27),heltab2x64(:,:,150))
  call Hloop_Q_A(ntryL,G1H4(24),79,0,G2H4(48),n2h4(82))
  call Hloop_AZ_Q(ntryL,G1H64(131),wf16(:,94),G1H4(25),ngZd,m3h16x4(:,28),heltab2x64(:,:,151))
  call Hloop_A_Q(ntryL,G1H4(25),79,0,G2H4(49),n2h4(83))
  call Hloop_VQ_A(ntryL,G1H64(132),ex5(:),G1H32(21),m3h2x32(:,24),heltab2x64(:,:,152))
  call Hloop_Q_A(ntryL,G1H32(21),80,0,G2H32(19),n2h32(39))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(12),[G2H8(5),G1H8(65)])
call HGT_lower_alpha_w2_OLR(G2H8(6),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(6),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(6),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(6),[G2H8(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(48),[G2H4(46),G2H4(44),G2H4(41),G2H4(40),G2H4(38) &
    ,G2H4(35),G2H4(34),G2H4(13),G2H4(12),G2H4(1),G2H4(20),G2H4(5),G2H4(32),G2H4(26),G2H4(10),G2H4(6),G2H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(3),[G1H8(33)])
call HGT_lower_alpha_w2_OLR(G2H8(7),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(7),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(7),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(7),[G2H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(4),[G1H8(49)])
call HGT_lower_alpha_w2_OLR(G2H8(8),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(8),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(8),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(8),[G2H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(16),[G2H8(15)])
call HGT_lower_alpha_w2_OLR(G2H8(9),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(9),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(9),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(9),[G2H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(49),[G2H4(47),G2H4(45),G2H4(43),G2H4(42),G2H4(39) &
    ,G2H4(37),G2H4(36),G2H4(33),G2H4(16),G2H4(9),G2H4(4),G2H4(17),G2H4(8),G2H4(30),G2H4(22),G2H4(18),G2H4(14)])
call HGT_lower_alpha_w2_OLR(G2H8(10),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(10),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(10),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(10),[G2H8(18)])
call HGT_lower_alpha_w2_OLR(G2H8(11),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(11),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(11),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(11),[G2H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(24),[G2H8(13),G1H8(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(26),[G2H8(17),G1H8(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(30),[G2H8(27),G2H8(25),G2H8(21),G1H8(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(14),[G1H8(81)])
call HGT_lower_alpha_w2_OLR(G2H8(28),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(28),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(28),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(28),[G2H8(14)])
call HGT_lower_alpha_w2_OLR(G2H8(29),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(29),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(29),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(29),[G2H8(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(33),[G2H8(31),G1H8(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(24),[G2H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(28),[G2H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(13),[G2H16(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(15),[G2H16(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(21),[G2H16(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(23),[G2H16(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(41),[G2H16(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(42),[G2H16(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(43),[G2H16(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(44),[G2H16(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(45),[G2H16(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(46),[G2H16(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(47),[G2H16(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(48),[G2H16(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(50),[G2H16(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(52),[G2H16(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(54),[G2H16(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(56),[G2H16(55)])
  call Hotf_4pt_reduction(G2H8(6),RedSet_4(15),mass4set(:,1),  & 
G1H8(12),G1H8(13),G1H8(14),G1H8(17),G1H8(18),8)
  call HG1shiftOLR(G1H8(13),32,8)
  call Hloop_QA_V(ntryL,G2H4(48),ex6(:),G2H2(24),m3h2x2(:,19),heltab2x4(:,:,39))
  call Hotf_4pt_reduction(G2H8(7),RedSet_4(12),mass4set(:,1),  & 
G1H8(19),G1H8(20),G1H8(23),G1H8(24),G1H8(25),8)
  call HG1shiftOLR(G1H8(20),32,8)
  call Hotf_4pt_reduction(G2H8(8),RedSet_4(12),mass4set(:,1),  & 
G1H8(26),G1H8(29),G1H8(30),G1H8(31),G1H8(32),8)
  call HG1shiftOLR(G1H8(29),32,8)
  call Hotf_4pt_reduction(G2H8(9),RedSet_4(52),mass4set(:,1),  & 
G1H8(37),G1H8(42),G1H8(38),G1H8(41),G1H8(43),8)
  call HG1shiftOLR(G1H8(42),16,8)
  call Hloop_AQ_V(ntryL,G2H4(49),ex5(:),G2H2(26),m3h2x2(:,20),heltab2x4(:,:,40))
  call Hotf_4pt_reduction(G2H8(10),RedSet_4(53),mass4set(:,1),  & 
G1H8(46),G1H8(47),G1H8(48),G1H8(53),G1H8(58),8)
  call HG1shiftOLR(G1H8(47),16,8)
  call Hotf_4pt_reduction(G2H8(11),RedSet_4(53),mass4set(:,1),  & 
G1H8(54),G1H8(57),G1H8(59),G1H8(62),G1H8(63),8)
  call HG1shiftOLR(G1H8(57),16,8)
call HGT_w2_OLR(G1H16(1),1,1,16)
call HGT_w2_invQ_OLR(G1H16(1),2,5,16)
  call Hloop_QZ_A(ntryL,G1H16(1),wf4(:,4),G1H4(30),ngZd,m3h4x4(:,41),heltab2x16(:,:,54))
  call Hloop_Q_A(ntryL,G1H4(30),115,0,G2H4(46),n2h4(84))
  call Hotf_4pt_reduction(G2H8(24),RedSet_4(13),mass4set(:,1),  & 
G1H8(64),G1H8(69),G1H8(74),G1H8(70),G1H8(73),8)
  call HG1shiftOLR(G1H8(69),32,8)
call HGT_w2_OLR(G1H16(2),1,1,16)
call HGT_w2_invQ_OLR(G1H16(2),2,5,16)
  call Hloop_QZ_A(ntryL,G1H16(2),wf4(:,4),G1H4(31),ngZd,m3h4x4(:,42),heltab2x16(:,:,55))
  call Hloop_Q_A(ntryL,G1H4(31),115,0,G2H4(44),n2h4(85))
  call Hotf_4pt_reduction(G2H8(26),RedSet_4(13),mass4set(:,1),  & 
G1H8(75),G1H8(78),G1H8(79),G1H8(80),G1H8(85),8)
  call HG1shiftOLR(G1H8(78),32,8)
call HGT_w2_OLR(G1H16(4),1,1,16)
call HGT_w2_invQ_OLR(G1H16(4),2,5,16)
  call Hloop_QV_A(ntryL,G1H16(4),wf4(:,2),G1H4(35),m3h4x4(:,43),heltab2x16(:,:,56))
  call Hloop_Q_A(ntryL,G1H4(35),124,0,G2H4(41),n2h4(86))
  call Hotf_4pt_reduction(G2H8(30),RedSet_4(16),mass4set(:,1),  & 
G1H8(90),G1H8(86),G1H8(89),G1H8(91),G1H8(94),8)
  call HG1shiftOLR(G1H8(86),32,8)
call HGT_w2_OLR(G1H16(5),1,1,16)
call HGT_w2_invQ_OLR(G1H16(5),2,5,16)
  call Hloop_QZ_A(ntryL,G1H16(5),wf4(:,7),G1H4(36),ngZd,m3h4x4(:,44),heltab2x16(:,:,57))
  call Hloop_Q_A(ntryL,G1H4(36),124,0,G2H4(40),n2h4(87))
  call Hotf_4pt_reduction(G2H8(28),RedSet_4(18),mass4set(:,1),  & 
G1H8(35),G1H8(36),G1H8(51),G1H8(52),G1H8(67),8)
  call HG1shiftOLR(G1H8(36),32,8)
  call Hotf_4pt_reduction(G2H8(29),RedSet_4(54),mass4set(:,1),  & 
G1H8(68),G1H8(83),G1H8(84),G1H8(1),G1H8(2),8)
  call HG1shiftOLR(G1H8(83),16,8)
call HGT_w2_OLR(G1H16(6),1,1,16)
call HGT_w2_invQ_OLR(G1H16(6),2,5,16)
  call Hloop_QW_A(ntryL,G1H16(6),wf4(:,13),G1H4(41),m3h4x4(:,45),heltab2x16(:,:,58))
  call Hloop_Q_A(ntryL,G1H4(41),121,0,G2H4(38),n2h4(88))
  call Hotf_4pt_reduction(G2H8(33),RedSet_4(19),mass4set(:,1),  & 
G1H8(5),G1H8(6),G1H8(7),G1H8(8),G1H8(11),8)
  call HG1shiftOLR(G1H8(6),32,8)
  call Hloop_VA_Q(ntryL,G1H8(3),ex6(:),G1H4(42),m3h2x4(:,28),heltab2x8(:,:,53))
  call Hloop_A_Q(ntryL,G1H4(42),115,0,G2H4(35),n2h4(89))
  call Hloop_VA_Q(ntryL,G1H8(4),ex6(:),G1H4(46),m3h2x4(:,29),heltab2x8(:,:,54))
  call Hloop_A_Q(ntryL,G1H4(46),115,0,G2H4(34),n2h4(90))
  call Hloop_VA_Q(ntryL,G1H8(9),ex6(:),G1H4(47),m3h2x4(:,30),heltab2x8(:,:,55))
  call Hloop_A_Q(ntryL,G1H4(47),115,0,G2H4(13),n2h4(91))
  call Hloop_VA_Q(ntryL,G1H8(10),ex6(:),G1H4(52),m3h2x4(:,31),heltab2x8(:,:,56))
  call Hloop_A_Q(ntryL,G1H4(52),115,0,G2H4(12),n2h4(92))
  call Hloop_VQ_A(ntryL,G1H8(15),ex5(:),G1H4(53),m3h2x4(:,32),heltab2x8(:,:,57))
  call Hloop_Q_A(ntryL,G1H4(53),115,0,G2H4(1),n2h4(93))
  call Hloop_VQ_A(ntryL,G1H8(16),ex5(:),G1H4(57),m3h2x4(:,33),heltab2x8(:,:,58))
  call Hloop_Q_A(ntryL,G1H4(57),115,0,G2H4(20),n2h4(94))
  call Hloop_VQ_A(ntryL,G1H8(21),ex5(:),G1H4(58),m3h2x4(:,34),heltab2x8(:,:,59))
  call Hloop_Q_A(ntryL,G1H4(58),115,0,G2H4(5),n2h4(95))
  call Hloop_VQ_A(ntryL,G1H8(22),ex5(:),G1H4(63),m3h2x4(:,35),heltab2x8(:,:,60))
  call Hloop_Q_A(ntryL,G1H4(63),115,0,G2H4(32),n2h4(96))
  call Hloop_VQ_A(ntryL,G1H8(27),ex5(:),G1H4(64),m3h2x4(:,36),heltab2x8(:,:,61))
  call Hloop_Q_A(ntryL,G1H4(64),118,0,G2H4(26),n2h4(97))
  call Hloop_VQ_A(ntryL,G1H8(28),ex5(:),G1H4(18),m3h2x4(:,37),heltab2x8(:,:,62))
  call Hloop_Q_A(ntryL,G1H4(18),118,0,G2H4(10),n2h4(98))
  call Hloop_QV_A(ntryL,G1H8(39),wf4(:,2),G1H2(6),m3h4x2(:,26),heltab2x8(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(6),95,0,G2H2(1),n2h2(21))
  call Hloop_QV_A(ntryL,G1H8(40),wf4(:,2),G1H2(17),m3h4x2(:,27),heltab2x8(:,:,64))
  call Hloop_Q_A(ntryL,G1H2(17),95,0,G2H2(3),n2h2(22))
  call Hloop_QV_A(ntryL,G1H8(44),wf4(:,2),G1H2(28),m3h4x2(:,28),heltab2x8(:,:,65))
  call Hloop_Q_A(ntryL,G1H2(28),95,0,G2H2(4),n2h2(23))
  call Hloop_QV_A(ntryL,G1H8(45),wf4(:,2),G1H2(39),m3h4x2(:,29),heltab2x8(:,:,66))
  call Hloop_Q_A(ntryL,G1H2(39),95,0,G2H2(6),n2h2(24))
  call Hloop_QZ_A(ntryL,G1H8(55),wf4(:,7),G1H2(50),ngZd,m3h4x2(:,30),heltab2x8(:,:,67))
  call Hloop_Q_A(ntryL,G1H2(50),95,0,G2H2(7),n2h2(25))
  call Hloop_QZ_A(ntryL,G1H8(56),wf4(:,7),G1H2(61),ngZd,m3h4x2(:,31),heltab2x8(:,:,68))
  call Hloop_Q_A(ntryL,G1H2(61),95,0,G2H2(9),n2h2(26))
  call Hloop_QZ_A(ntryL,G1H8(60),wf4(:,7),G1H2(1),ngZd,m3h4x2(:,32),heltab2x8(:,:,69))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(10),n2h2(27))
  call Hloop_QZ_A(ntryL,G1H8(61),wf4(:,7),G1H2(2),ngZd,m3h4x2(:,33),heltab2x8(:,:,70))
  call Hloop_Q_A(ntryL,G1H2(2),95,0,G2H2(12),n2h2(28))
  call Hloop_QZ_A(ntryL,G1H8(71),wf4(:,4),G1H2(7),ngZd,m3h4x2(:,34),heltab2x8(:,:,71))
  call Hloop_Q_A(ntryL,G1H2(7),95,0,G2H2(13),n2h2(29))
  call Hloop_QZ_A(ntryL,G1H8(72),wf4(:,4),G1H2(8),ngZd,m3h4x2(:,35),heltab2x8(:,:,72))
  call Hloop_Q_A(ntryL,G1H2(8),95,0,G2H2(15),n2h2(30))
  call Hloop_QZ_A(ntryL,G1H8(76),wf4(:,4),G1H2(12),ngZd,m3h4x2(:,36),heltab2x8(:,:,73))
  call Hloop_Q_A(ntryL,G1H2(12),95,0,G2H2(16),n2h2(31))
  call Hloop_QZ_A(ntryL,G1H8(77),wf4(:,4),G1H2(13),ngZd,m3h4x2(:,37),heltab2x8(:,:,74))
  call Hloop_Q_A(ntryL,G1H2(13),95,0,G2H2(18),n2h2(32))
  call Hloop_QW_A(ntryL,G1H8(87),wf4(:,12),G1H2(18),m3h4x2(:,38),heltab2x8(:,:,75))
  call Hloop_Q_A(ntryL,G1H2(18),95,0,G2H2(29),n2h2(33))
  call Hloop_QW_A(ntryL,G1H8(88),wf4(:,12),G1H2(19),m3h4x2(:,39),heltab2x8(:,:,76))
  call Hloop_Q_A(ntryL,G1H2(19),95,0,G2H2(31),n2h2(34))
  call Hloop_QW_A(ntryL,G1H8(92),wf4(:,12),G1H2(23),m3h4x2(:,40),heltab2x8(:,:,77))
  call Hloop_Q_A(ntryL,G1H2(23),95,0,G2H2(34),n2h2(35))
  call Hloop_QW_A(ntryL,G1H8(93),wf4(:,12),G1H2(24),m3h4x2(:,41),heltab2x8(:,:,78))
  call Hloop_Q_A(ntryL,G1H2(24),95,0,G2H2(36),n2h2(36))
  call Hloop_QA_V(ntryL,G2H4(21),ex6(:),G2H2(39),m3h2x2(:,21),heltab2x4(:,:,41))
  call Hloop_QA_V(ntryL,G2H4(24),ex6(:),G2H2(41),m3h2x2(:,22),heltab2x4(:,:,42))
  call Hloop_AQ_V(ntryL,G2H4(25),ex5(:),G2H2(44),m3h2x2(:,23),heltab2x4(:,:,43))
  call Hloop_AQ_V(ntryL,G2H4(28),ex5(:),G2H2(45),m3h2x2(:,24),heltab2x4(:,:,44))
  call Hloop_QA_V(ntryL,G2H4(29),ex6(:),G2H2(46),m3h2x2(:,25),heltab2x4(:,:,45))
  call Hloop_AQ_V(ntryL,G2H4(31),ex5(:),G2H2(47),m3h2x2(:,26),heltab2x4(:,:,46))
  call Hotf_4pt_reduction(G2H16(13),RedSet_4(43),mass4set(:,1),  & 
G1H16(15),G1H16(21),G1H16(27),G1H16(33),G1H16(39),G0H16(1),16)
  call HG1shiftOLR(G1H16(21),12,16)
  call Hotf_4pt_reduction(G2H16(10),RedSet_4(43),mass4set(:,2),  & 
G1H16(45),G1H16(7),G1H16(8),G1H16(10),G1H16(11),G0H16(2),16)
  call HG1shiftOLR(G1H16(7),12,16)
  call Hotf_4pt_reduction(G2H16(15),RedSet_4(43),mass4set(:,1),  & 
G1H16(12),G1H16(13),G1H16(14),G1H16(16),G1H16(17),G0H16(3),16)
  call HG1shiftOLR(G1H16(13),12,16)
  call Hotf_4pt_reduction(G2H16(12),RedSet_4(43),mass4set(:,2),  & 
G1H16(18),G1H16(19),G1H16(20),G1H16(22),G1H16(23),G0H16(4),16)
  call HG1shiftOLR(G1H16(19),12,16)
  call Hotf_4pt_reduction(G2H16(14),RedSet_4(43),mass4set(:,3),  & 
G1H16(24),G1H16(25),G1H16(26),G1H16(28),G1H16(29),G0H16(5),16)
  call HG1shiftOLR(G1H16(25),12,16)
  call Hotf_4pt_reduction(G2H16(1),RedSet_4(43),mass4set(:,3),  & 
G1H16(30),G1H16(31),G1H16(32),G1H16(34),G1H16(35),G0H16(6),16)
  call HG1shiftOLR(G1H16(31),12,16)
  call Hotf_4pt_reduction(G2H16(5),RedSet_4(43),mass4set(:,1),  & 
G1H16(36),G1H16(37),G1H16(38),G1H16(40),G1H16(41),G0H16(7),16)
  call HG1shiftOLR(G1H16(37),12,16)
  call Hotf_4pt_reduction(G2H16(2),RedSet_4(43),mass4set(:,2),  & 
G1H16(42),G1H16(43),G1H16(44),G1H16(46),G1H16(47),G0H16(8),16)
  call HG1shiftOLR(G1H16(43),12,16)
  call Hotf_4pt_reduction(G2H16(3),RedSet_4(43),mass4set(:,1),  & 
G1H16(48),G1H16(3),G1H16(9),G1H16(1),G1H16(2),G0H16(9),16)
  call HG1shiftOLR(G1H16(3),12,16)
  call Hotf_4pt_reduction(G2H16(4),RedSet_4(43),mass4set(:,2),  & 
G1H16(4),G1H16(5),G1H16(6),G1H16(49),G1H16(50),G0H16(10),16)
  call HG1shiftOLR(G1H16(5),12,16)
  call Hotf_4pt_reduction(G2H16(6),RedSet_4(43),mass4set(:,1),  & 
G1H16(51),G1H16(52),G1H16(53),G1H16(54),G1H16(55),G0H16(11),16)
  call HG1shiftOLR(G1H16(52),12,16)
  call Hotf_4pt_reduction(G2H16(7),RedSet_4(43),mass4set(:,3),  & 
G1H16(56),G1H16(57),G1H16(58),G1H16(59),G1H16(60),G0H16(12),16)
  call HG1shiftOLR(G1H16(57),12,16)
  call Hotf_4pt_reduction(G2H16(8),RedSet_4(43),mass4set(:,1),  & 
G1H16(61),G1H16(62),G1H16(63),G1H16(64),G1H16(65),G0H16(13),16)
  call HG1shiftOLR(G1H16(62),12,16)
  call Hotf_4pt_reduction(G2H16(16),RedSet_4(43),mass4set(:,3),  & 
G1H16(66),G1H16(67),G1H16(68),G1H16(69),G1H16(70),G0H16(14),16)
  call HG1shiftOLR(G1H16(67),12,16)
  call Hotf_4pt_reduction(G2H16(21),RedSet_4(6),mass4set(:,1),  & 
G1H16(71),G1H16(72),G1H16(73),G1H16(74),G1H16(75),G0H16(15),16)
  call HG1shiftOLR(G1H16(72),48,16)
  call Hotf_4pt_reduction(G2H16(18),RedSet_4(6),mass4set(:,2),  & 
G1H16(76),G1H16(77),G1H16(78),G1H16(79),G1H16(80),G0H16(16),16)
  call HG1shiftOLR(G1H16(77),48,16)
  call Hotf_4pt_reduction(G2H16(23),RedSet_4(6),mass4set(:,1),  & 
G1H16(81),G1H16(82),G1H16(83),G1H16(84),G1H16(85),G0H16(17),16)
  call HG1shiftOLR(G1H16(82),48,16)
  call Hotf_4pt_reduction(G2H16(20),RedSet_4(6),mass4set(:,2),  & 
G1H16(86),G1H16(87),G1H16(88),G1H16(89),G1H16(90),G0H16(18),16)
  call HG1shiftOLR(G1H16(87),48,16)
  call Hotf_4pt_reduction(G2H16(22),RedSet_4(6),mass4set(:,3),  & 
G1H16(91),G1H16(92),G1H16(93),G1H16(94),G1H16(95),G0H16(19),16)
  call HG1shiftOLR(G1H16(92),48,16)
  call Hotf_4pt_reduction(G2H16(24),RedSet_4(6),mass4set(:,3),  & 
G1H16(96),G1H16(97),G1H16(98),G1H16(99),G1H16(100),G0H16(20),16)
  call HG1shiftOLR(G1H16(97),48,16)
  call Hotf_4pt_reduction(G2H16(25),RedSet_4(6),mass4set(:,1),  & 
G1H16(101),G1H16(102),G1H16(103),G1H16(104),G1H16(105),G0H16(21),16)
  call HG1shiftOLR(G1H16(102),48,16)
  call Hotf_4pt_reduction(G2H16(26),RedSet_4(6),mass4set(:,2),  & 
G1H16(106),G1H16(107),G1H16(108),G1H16(109),G1H16(110),G0H16(22),16)
  call HG1shiftOLR(G1H16(107),48,16)
  call Hotf_4pt_reduction(G2H16(27),RedSet_4(6),mass4set(:,1),  & 
G1H16(111),G1H16(112),G1H16(113),G1H16(114),G1H16(115),G0H16(23),16)
  call HG1shiftOLR(G1H16(112),48,16)
  call Hotf_4pt_reduction(G2H16(28),RedSet_4(6),mass4set(:,2),  & 
G1H16(116),G1H16(117),G1H16(118),G1H16(119),G1H16(120),G0H16(24),16)
  call HG1shiftOLR(G1H16(117),48,16)
  call Hotf_4pt_reduction(G2H16(29),RedSet_4(6),mass4set(:,1),  & 
G1H16(121),G1H16(122),G1H16(123),G1H16(124),G1H16(125),G0H16(25),16)
  call HG1shiftOLR(G1H16(122),48,16)
  call Hotf_4pt_reduction(G2H16(30),RedSet_4(6),mass4set(:,3),  & 
G1H16(126),G1H16(127),G1H16(128),G1H16(129),G1H16(130),G0H16(26),16)
  call HG1shiftOLR(G1H16(127),48,16)
  call Hotf_4pt_reduction(G2H16(31),RedSet_4(6),mass4set(:,1),  & 
G1H16(131),G1H16(132),G1H16(133),G1H16(134),G1H16(135),G0H16(27),16)
  call HG1shiftOLR(G1H16(132),48,16)
  call Hotf_4pt_reduction(G2H16(32),RedSet_4(6),mass4set(:,3),  & 
G1H16(136),G1H16(137),G1H16(138),G1H16(139),G1H16(140),G0H16(28),16)
  call HG1shiftOLR(G1H16(137),48,16)
  call Hotf_4pt_reduction(G2H16(41),RedSet_4(5),mass4set(:,1),  & 
G1H16(141),G1H16(142),G1H16(143),G1H16(144),G1H16(145),G0H16(29),16)
  call HG1shiftOLR(G1H16(142),48,16)
  call Hotf_4pt_reduction(G2H16(42),RedSet_4(5),mass4set(:,2),  & 
G1H16(146),G1H16(147),G1H16(148),G1H16(149),G1H16(150),G0H16(30),16)
  call HG1shiftOLR(G1H16(147),48,16)
  call Hotf_4pt_reduction(G2H16(43),RedSet_4(5),mass4set(:,1),  & 
G1H16(151),G1H16(152),G1H16(153),G1H16(154),G1H16(155),G0H16(31),16)
  call HG1shiftOLR(G1H16(152),48,16)
  call Hotf_4pt_reduction(G2H16(44),RedSet_4(5),mass4set(:,2),  & 
G1H16(156),G1H16(157),G1H16(158),G1H16(159),G1H16(160),G0H16(32),16)
  call HG1shiftOLR(G1H16(157),48,16)
  call Hotf_4pt_reduction(G2H16(45),RedSet_4(5),mass4set(:,1),  & 
G1H16(161),G1H16(162),G1H16(163),G1H16(164),G1H16(165),G0H16(33),16)
  call HG1shiftOLR(G1H16(162),48,16)
  call Hotf_4pt_reduction(G2H16(46),RedSet_4(5),mass4set(:,3),  & 
G1H16(166),G1H16(167),G1H16(168),G1H16(169),G1H16(170),G0H16(34),16)
  call HG1shiftOLR(G1H16(167),48,16)
  call Hotf_4pt_reduction(G2H16(47),RedSet_4(5),mass4set(:,1),  & 
G1H16(171),G1H16(172),G1H16(173),G1H16(174),G1H16(175),G0H16(35),16)
  call HG1shiftOLR(G1H16(172),48,16)
  call Hotf_4pt_reduction(G2H16(48),RedSet_4(5),mass4set(:,3),  & 
G1H16(176),G1H16(177),G1H16(178),G1H16(179),G1H16(180),G0H16(36),16)
  call HG1shiftOLR(G1H16(177),48,16)
  call Hloop_AQ_V(ntryL,G2H16(50),wf8(:,8),G2H2(48),m3h8x2(:,1),heltab2x16(:,:,59))
  call Hloop_QA_V(ntryL,G2H16(52),ex6(:),G2H8(20),m3h2x8(:,14),heltab2x16(:,:,60))
  call Hotf_4pt_reduction(G2H32(1),RedSet_4(3),mass4set(:,1),  & 
G1H32(27),G1H32(4),G1H32(5),G1H32(1),G1H32(2),32)
  call HG1shiftOLR(G1H32(4),35,32)
  call Hotf_4pt_reduction(G2H32(2),RedSet_4(3),mass4set(:,1),  & 
G1H32(11),G1H32(6),G1H32(7),G1H32(8),G1H32(10),32)
  call HG1shiftOLR(G1H32(6),35,32)
  call Hloop_QA_V(ntryL,G2H16(54),wf8(:,2),G2H2(49),m3h8x2(:,2),heltab2x16(:,:,61))
  call Hloop_AQ_V(ntryL,G2H16(56),ex5(:),G2H8(22),m3h2x8(:,15),heltab2x16(:,:,62))
  call Hloop_AQ_V(ntryL,G2H16(57),wf8(:,10),G2H2(50),m3h8x2(:,3),heltab2x16(:,:,63))
  call Hloop_AQ_V(ntryL,G2H16(58),wf8(:,12),G2H2(51),m3h8x2(:,4),heltab2x16(:,:,64))
  call Hloop_QA_V(ntryL,G2H16(59),ex6(:),G2H8(23),m3h2x8(:,16),heltab2x16(:,:,65))
  call Hloop_QA_V(ntryL,G2H16(60),ex6(:),G2H8(1),m3h2x8(:,17),heltab2x16(:,:,66))
  call Hotf_4pt_reduction(G2H32(3),RedSet_4(2),mass4set(:,1),  & 
G1H32(13),G1H32(14),G1H32(16),G1H32(17),G1H32(18),32)
  call HG1shiftOLR(G1H32(14),44,32)
  call Hotf_4pt_reduction(G2H32(4),RedSet_4(2),mass4set(:,1),  & 
G1H32(19),G1H32(20),G1H32(22),G1H32(12),G1H32(23),32)
  call HG1shiftOLR(G1H32(20),44,32)
  call Hloop_QA_V(ntryL,G2H16(61),wf8(:,4),G2H2(52),m3h8x2(:,5),heltab2x16(:,:,67))
  call Hloop_QA_V(ntryL,G2H16(62),wf8(:,6),G2H2(53),m3h8x2(:,6),heltab2x16(:,:,68))
  call Hloop_AQ_V(ntryL,G2H16(63),ex5(:),G2H8(2),m3h2x8(:,18),heltab2x16(:,:,69))
  call Hloop_AQ_V(ntryL,G2H16(64),ex5(:),G2H8(5),m3h2x8(:,19),heltab2x16(:,:,70))
  call Hotf_4pt_reduction(G2H32(5),RedSet_4(1),mass4set(:,1),  & 
G1H32(24),G1H32(25),G1H32(26),G1H32(28),G1H32(29),32)
  call HG1shiftOLR(G1H32(25),32,32)
  call Hotf_4pt_reduction(G2H32(6),RedSet_4(1),mass4set(:,1),  & 
G1H32(30),G1H32(3),G1H32(9),G1H32(15),G1H32(21),32)
  call HG1shiftOLR(G1H32(3),32,32)
  call Hotf_4pt_reduction(G2H32(7),RedSet_4(1),mass4set(:,1),  & 
G1H32(31),G1H32(32),G1H32(33),G1H32(34),G1H32(35),32)
  call HG1shiftOLR(G1H32(32),32,32)
  call Hotf_4pt_reduction(G2H32(8),RedSet_4(1),mass4set(:,1),  & 
G1H32(36),G1H32(37),G1H32(38),G1H32(39),G1H32(40),32)
  call HG1shiftOLR(G1H32(37),32,32)
  call Hotf_4pt_reduction(G2H16(65),RedSet_4(50),mass4set(:,1),  & 
G1H16(181),G1H16(182),G1H16(183),G1H16(184),G1H16(185),G0H16(37),16)
  call HG1shiftOLR(G1H16(182),9,16)
  call Hotf_4pt_reduction(G2H16(66),RedSet_4(50),mass4set(:,4),  & 
G1H16(186),G1H16(187),G1H16(188),G1H16(189),G1H16(190),G0H16(38),16)
  call HG1shiftOLR(G1H16(187),9,16)
  call Hotf_4pt_reduction(G2H16(67),RedSet_4(50),mass4set(:,1),  & 
G1H16(191),G1H16(192),G1H16(193),G1H16(194),G1H16(195),G0H16(39),16)
  call HG1shiftOLR(G1H16(192),9,16)
  call Hotf_4pt_reduction(G2H16(68),RedSet_4(50),mass4set(:,5),  & 
G1H16(196),G1H16(197),G1H16(198),G1H16(199),G1H16(200),G0H16(40),16)
  call HG1shiftOLR(G1H16(197),9,16)
  call Hotf_4pt_reduction(G2H16(69),RedSet_4(7),mass4set(:,1),  & 
G1H16(201),G1H16(202),G1H16(203),G1H16(204),G1H16(205),G0H16(41),16)
  call HG1shiftOLR(G1H16(202),48,16)
  call Hotf_4pt_reduction(G2H16(70),RedSet_4(7),mass4set(:,6),  & 
G1H16(206),G1H16(207),G1H16(208),G1H16(209),G1H16(210),G0H16(42),16)
  call HG1shiftOLR(G1H16(207),48,16)
  call Hotf_4pt_reduction(G2H16(71),RedSet_4(7),mass4set(:,1),  & 
G1H16(211),G1H16(212),G1H16(213),G1H16(214),G1H16(215),G0H16(43),16)
  call HG1shiftOLR(G1H16(212),48,16)
  call Hotf_4pt_reduction(G2H16(72),RedSet_4(7),mass4set(:,7),  & 
G1H16(216),G1H16(217),G1H16(218),G1H16(219),G1H16(220),G0H16(44),16)
  call HG1shiftOLR(G1H16(217),48,16)
  call Hotf_4pt_reduction(G2H16(73),RedSet_4(8),mass4set(:,1),  & 
G1H16(221),G1H16(222),G1H16(223),G1H16(224),G1H16(225),G0H16(45),16)
  call HG1shiftOLR(G1H16(222),48,16)
  call Hotf_4pt_reduction(G2H16(74),RedSet_4(8),mass4set(:,6),  & 
G1H16(226),G1H16(227),G1H16(228),G1H16(229),G1H16(230),G0H16(46),16)
  call HG1shiftOLR(G1H16(227),48,16)
  call Hotf_4pt_reduction(G2H16(75),RedSet_4(8),mass4set(:,1),  & 
G1H16(231),G1H16(232),G1H16(233),G1H16(234),G1H16(235),G0H16(47),16)
  call HG1shiftOLR(G1H16(232),48,16)
  call Hotf_4pt_reduction(G2H16(76),RedSet_4(8),mass4set(:,7),  & 
G1H16(236),G1H16(237),G1H16(238),G1H16(239),G1H16(240),G0H16(48),16)
  call HG1shiftOLR(G1H16(237),48,16)
  call Hloop_AQ_V(ntryL,G2H16(77),wf8(:,26),G2H2(54),m3h8x2(:,7),heltab2x16(:,:,71))
  call Hloop_QA_V(ntryL,G2H16(78),ex6(:),G2H8(12),m3h2x8(:,20),heltab2x16(:,:,72))
  call Hotf_4pt_reduction(G2H32(9),RedSet_4(4),mass4set(:,1),  & 
G1H32(41),G1H32(42),G1H32(43),G1H32(44),G1H32(45),32)
  call HG1shiftOLR(G1H32(42),38,32)
  call Hloop_QA_V(ntryL,G2H16(79),wf8(:,24),G2H2(55),m3h8x2(:,8),heltab2x16(:,:,73))
  call Hloop_AQ_V(ntryL,G2H16(80),ex5(:),G2H8(3),m3h2x8(:,21),heltab2x16(:,:,74))
  call Hotf_4pt_reduction(G2H32(10),RedSet_4(1),mass4set(:,1),  & 
G1H32(46),G1H32(47),G1H32(48),G1H32(49),G1H32(50),32)
  call HG1shiftOLR(G1H32(47),32,32)
  call Hotf_4pt_reduction(G2H32(11),RedSet_4(1),mass4set(:,1),  & 
G1H32(51),G1H32(52),G1H32(53),G1H32(54),G1H32(55),32)
  call HG1shiftOLR(G1H32(52),32,32)
  call Hotf_4pt_reduction(G2H32(12),RedSet_4(1),mass4set(:,1),  & 
G1H32(56),G1H32(57),G1H32(58),G1H32(59),G1H32(60),32)
  call HG1shiftOLR(G1H32(57),32,32)
  call Hotf_4pt_reduction(G2H32(13),RedSet_4(1),mass4set(:,1),  & 
G1H32(61),G1H32(62),G1H32(63),G1H32(64),G1H32(65),32)
  call HG1shiftOLR(G1H32(62),32,32)
  call Hotf_4pt_reduction(G2H32(14),RedSet_4(1),mass4set(:,1),  & 
G1H32(66),G1H32(67),G1H32(68),G1H32(69),G1H32(70),32)
  call HG1shiftOLR(G1H32(67),32,32)
  call Hotf_4pt_reduction(G2H32(15),RedSet_4(1),mass4set(:,1),  & 
G1H32(71),G1H32(72),G1H32(73),G1H32(74),G1H32(75),32)
  call HG1shiftOLR(G1H32(72),32,32)
  call Hotf_4pt_reduction(G2H32(16),RedSet_4(1),mass4set(:,1),  & 
G1H32(76),G1H32(77),G1H32(78),G1H32(79),G1H32(80),32)
  call HG1shiftOLR(G1H32(77),32,32)
  call Hotf_4pt_reduction(G2H32(17),RedSet_4(1),mass4set(:,1),  & 
G1H32(81),G1H32(82),G1H32(83),G1H32(84),G1H32(85),32)
  call HG1shiftOLR(G1H32(82),32,32)
  call Hotf_4pt_reduction(G2H32(18),RedSet_4(1),mass4set(:,1),  & 
G1H32(86),G1H32(87),G1H32(88),G1H32(89),G1H32(90),32)
  call HG1shiftOLR(G1H32(87),32,32)
  call Hotf_4pt_reduction(G2H32(19),RedSet_4(1),mass4set(:,1),  & 
G1H32(91),G1H32(92),G1H32(93),G1H32(94),G1H32(95),32)
  call HG1shiftOLR(G1H32(92),32,32)
  call Hloop_QZ_A(ntryL,G1H8(12),wf4(:,4),G1H2(29),ngZd,m3h4x2(:,42),heltab2x8(:,:,79))
  call Hloop_Q_A(ntryL,G1H2(29),95,0,G2H2(56),n2h2(37))
call HGT_raise_alpha_OLR(G1H8(13),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(13),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(13),ex6(:),G1H4(29),m3h2x4(:,38),heltab2x8(:,:,80))
  call Hloop_QZ_A(ntryL,G1H8(17),wf4(:,4),G1H2(30),ngZd,m3h4x2(:,43),heltab2x8(:,:,81))
  call Hloop_Q_A(ntryL,G1H2(30),95,0,G2H2(57),n2h2(38))
  call Hloop_QZ_A(ntryL,G1H8(18),wf4(:,4),G1H2(34),ngZd,m3h4x2(:,44),heltab2x8(:,:,82))
  call Hloop_Q_A(ntryL,G1H2(34),95,0,G2H2(58),n2h2(39))
  call Hloop_QV_A(ntryL,G1H8(19),wf4(:,2),G1H2(35),m3h4x2(:,45),heltab2x8(:,:,83))
  call Hloop_Q_A(ntryL,G1H2(35),95,0,G2H2(59),n2h2(40))
call HGT_raise_alpha_OLR(G1H8(20),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(20),ex6(:),G1H4(40),m3h2x4(:,39),heltab2x8(:,:,84))
  call Hloop_QV_A(ntryL,G1H8(24),wf4(:,2),G1H2(40),m3h4x2(:,46),heltab2x8(:,:,85))
  call Hloop_Q_A(ntryL,G1H2(40),95,0,G2H2(60),n2h2(41))
  call Hloop_QV_A(ntryL,G1H8(25),wf4(:,2),G1H2(41),m3h4x2(:,47),heltab2x8(:,:,86))
  call Hloop_Q_A(ntryL,G1H2(41),95,0,G2H2(61),n2h2(42))
  call Hloop_QZ_A(ntryL,G1H8(26),wf4(:,7),G1H2(45),ngZd,m3h4x2(:,48),heltab2x8(:,:,87))
  call Hloop_Q_A(ntryL,G1H2(45),95,0,G2H2(62),n2h2(43))
call HGT_raise_alpha_OLR(G1H8(29),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(29),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(29),ex6(:),G1H4(51),m3h2x4(:,40),heltab2x8(:,:,88))
  call Hloop_QZ_A(ntryL,G1H8(31),wf4(:,7),G1H2(46),ngZd,m3h4x2(:,49),heltab2x8(:,:,89))
  call Hloop_Q_A(ntryL,G1H2(46),95,0,G2H2(63),n2h2(44))
  call Hloop_QZ_A(ntryL,G1H8(32),wf4(:,7),G1H2(51),ngZd,m3h4x2(:,50),heltab2x8(:,:,90))
  call Hloop_Q_A(ntryL,G1H2(51),95,0,G2H2(64),n2h2(45))
  call Hloop_AZ_Q(ntryL,G1H8(37),wf4(:,4),G1H2(52),ngZd,m3h4x2(:,51),heltab2x8(:,:,91))
  call Hloop_A_Q(ntryL,G1H2(52),111,0,G2H2(65),n2h2(46))
call HGT_raise_alpha_OLR(G1H8(42),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(42),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(42),ex5(:),G1H4(62),m3h2x4(:,41),heltab2x8(:,:,92))
  call Hloop_AZ_Q(ntryL,G1H8(41),wf4(:,4),G1H2(56),ngZd,m3h4x2(:,52),heltab2x8(:,:,93))
  call Hloop_A_Q(ntryL,G1H2(56),111,0,G2H2(66),n2h2(47))
  call Hloop_AZ_Q(ntryL,G1H8(43),wf4(:,4),G1H2(57),ngZd,m3h4x2(:,53),heltab2x8(:,:,94))
  call Hloop_A_Q(ntryL,G1H2(57),111,0,G2H2(67),n2h2(48))
  call Hloop_AV_Q(ntryL,G1H8(46),wf4(:,2),G1H2(62),m3h4x2(:,54),heltab2x8(:,:,95))
  call Hloop_A_Q(ntryL,G1H2(62),111,0,G2H2(68),n2h2(49))
call HGT_raise_alpha_OLR(G1H8(47),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(47),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(47),ex5(:),G1H4(13),m3h2x4(:,42),heltab2x8(:,:,96))
  call Hloop_AV_Q(ntryL,G1H8(53),wf4(:,2),G1H2(63),m3h4x2(:,55),heltab2x8(:,:,97))
  call Hloop_A_Q(ntryL,G1H2(63),111,0,G2H2(69),n2h2(50))
  call Hloop_AV_Q(ntryL,G1H8(58),wf4(:,2),G1H2(6),m3h4x2(:,56),heltab2x8(:,:,98))
  call Hloop_A_Q(ntryL,G1H2(6),111,0,G2H2(70),n2h2(51))
  call Hloop_AZ_Q(ntryL,G1H8(54),wf4(:,7),G1H2(17),ngZd,m3h4x2(:,57),heltab2x8(:,:,99))
  call Hloop_A_Q(ntryL,G1H2(17),111,0,G2H2(71),n2h2(52))
call HGT_raise_alpha_OLR(G1H8(57),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(57),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(57),ex5(:),G1H4(14),m3h2x4(:,43),heltab2x8(:,:,100))
  call Hloop_AZ_Q(ntryL,G1H8(62),wf4(:,7),G1H2(28),ngZd,m3h4x2(:,58),heltab2x8(:,:,101))
  call Hloop_A_Q(ntryL,G1H2(28),111,0,G2H2(72),n2h2(53))
  call Hloop_AZ_Q(ntryL,G1H8(63),wf4(:,7),G1H2(39),ngZd,m3h4x2(:,59),heltab2x8(:,:,102))
  call Hloop_A_Q(ntryL,G1H2(39),111,0,G2H2(73),n2h2(54))
  call Hloop_QV_A(ntryL,G1H8(64),wf4(:,2),G1H2(50),m3h4x2(:,60),heltab2x8(:,:,103))
  call Hloop_Q_A(ntryL,G1H2(50),95,0,G2H2(74),n2h2(55))
call HGT_raise_alpha_OLR(G1H8(69),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(69),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(69),ex6(:),G1H4(19),m3h2x4(:,44),heltab2x8(:,:,104))
  call Hloop_QV_A(ntryL,G1H8(70),wf4(:,2),G1H2(61),m3h4x2(:,61),heltab2x8(:,:,105))
  call Hloop_Q_A(ntryL,G1H2(61),95,0,G2H2(75),n2h2(56))
  call Hloop_QV_A(ntryL,G1H8(73),wf4(:,2),G1H2(1),m3h4x2(:,62),heltab2x8(:,:,106))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(76),n2h2(57))
  call Hloop_QZ_A(ntryL,G1H8(75),wf4(:,7),G1H2(2),ngZd,m3h4x2(:,63),heltab2x8(:,:,107))
  call Hloop_Q_A(ntryL,G1H2(2),95,0,G2H2(77),n2h2(58))
call HGT_raise_alpha_OLR(G1H8(78),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(78),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(78),ex6(:),G1H4(20),m3h2x4(:,45),heltab2x8(:,:,108))
  call Hloop_QZ_A(ntryL,G1H8(80),wf4(:,7),G1H2(7),ngZd,m3h4x2(:,64),heltab2x8(:,:,109))
  call Hloop_Q_A(ntryL,G1H2(7),95,0,G2H2(78),n2h2(59))
  call Hloop_QZ_A(ntryL,G1H8(85),wf4(:,7),G1H2(8),ngZd,m3h4x2(:,65),heltab2x8(:,:,110))
  call Hloop_Q_A(ntryL,G1H2(8),95,0,G2H2(79),n2h2(60))
  call Hloop_QZ_A(ntryL,G1H8(90),wf4(:,4),G1H2(12),ngZd,m3h4x2(:,66),heltab2x8(:,:,111))
  call Hloop_Q_A(ntryL,G1H2(12),95,0,G2H2(80),n2h2(61))
call HGT_raise_alpha_OLR(G1H8(86),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(86),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(86),ex6(:),G1H4(24),m3h2x4(:,46),heltab2x8(:,:,112))
  call Hloop_QZ_A(ntryL,G1H8(91),wf4(:,4),G1H2(13),ngZd,m3h4x2(:,67),heltab2x8(:,:,113))
  call Hloop_Q_A(ntryL,G1H2(13),95,0,G2H2(81),n2h2(62))
  call Hloop_QZ_A(ntryL,G1H8(94),wf4(:,4),G1H2(18),ngZd,m3h4x2(:,68),heltab2x8(:,:,114))
  call Hloop_Q_A(ntryL,G1H2(18),95,0,G2H2(82),n2h2(63))
  call Hloop_QW_A(ntryL,G1H8(35),wf4(:,12),G1H2(19),m3h4x2(:,69),heltab2x8(:,:,115))
  call Hloop_Q_A(ntryL,G1H2(19),95,0,G2H2(83),n2h2(64))
call HGT_raise_alpha_OLR(G1H8(36),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(36),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(36),ex6(:),G1H4(25),m3h2x4(:,47),heltab2x8(:,:,116))
  call Hloop_QW_A(ntryL,G1H8(52),wf4(:,12),G1H2(23),m3h4x2(:,70),heltab2x8(:,:,117))
  call Hloop_Q_A(ntryL,G1H2(23),95,0,G2H2(84),n2h2(65))
  call Hloop_QW_A(ntryL,G1H8(67),wf4(:,12),G1H2(24),m3h4x2(:,71),heltab2x8(:,:,118))
  call Hloop_Q_A(ntryL,G1H2(24),95,0,G2H2(85),n2h2(66))
  call Hloop_AW_Q(ntryL,G1H8(68),wf4(:,13),G1H2(29),m3h4x2(:,72),heltab2x8(:,:,119))
  call Hloop_A_Q(ntryL,G1H2(29),111,0,G2H2(86),n2h2(67))
call HGT_raise_alpha_OLR(G1H8(83),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(83),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(83),ex5(:),G1H4(30),m3h2x4(:,48),heltab2x8(:,:,120))
  call Hloop_AW_Q(ntryL,G1H8(1),wf4(:,13),G1H2(30),m3h4x2(:,73),heltab2x8(:,:,121))
  call Hloop_A_Q(ntryL,G1H2(30),111,0,G2H2(87),n2h2(68))
  call Hloop_AW_Q(ntryL,G1H8(2),wf4(:,13),G1H2(34),m3h4x2(:,74),heltab2x8(:,:,122))
  call Hloop_A_Q(ntryL,G1H2(34),111,0,G2H2(88),n2h2(69))
  call Hloop_QW_A(ntryL,G1H8(5),wf4(:,12),G1H2(35),m3h4x2(:,75),heltab2x8(:,:,123))
  call Hloop_Q_A(ntryL,G1H2(35),95,0,G2H2(89),n2h2(70))
call HGT_raise_alpha_OLR(G1H8(6),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(6),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(6),ex6(:),G1H4(31),m3h2x4(:,49),heltab2x8(:,:,124))
  call Hloop_QW_A(ntryL,G1H8(8),wf4(:,12),G1H2(40),m3h4x2(:,76),heltab2x8(:,:,125))
  call Hloop_Q_A(ntryL,G1H2(40),95,0,G2H2(90),n2h2(71))
  call Hloop_QW_A(ntryL,G1H8(11),wf4(:,12),G1H2(41),m3h4x2(:,77),heltab2x8(:,:,126))
  call Hloop_Q_A(ntryL,G1H2(41),95,0,G2H2(91),n2h2(72))
  call Hloop_AV_Q(ntryL,G1H16(15),wf4(:,14),G1H4(35),m3h4x4(:,46),heltab2x16(:,:,75))
  call Hloop_A_Q(ntryL,G1H4(35),115,0,G2H4(6),n2h4(99))
call HGT_OLR(G1H16(21),1,1,16)
call HGT_invQ_OLR(G1H16(21),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(21),-12,0,G2H16(9),n2h16(104))
  call Hloop_QV_A(ntryL,G2H16(9),wf4(:,2),G2H4(2),m3h4x4(:,47),heltab2x16(:,:,76))
  call Hloop_AV_Q(ntryL,G1H16(33),wf4(:,14),G1H4(36),m3h4x4(:,48),heltab2x16(:,:,77))
  call Hloop_A_Q(ntryL,G1H4(36),115,0,G2H4(47),n2h4(100))
  call Hloop_AV_Q(ntryL,G1H16(39),wf4(:,14),G1H4(41),m3h4x4(:,49),heltab2x16(:,:,78))
  call Hloop_A_Q(ntryL,G1H4(41),115,0,G2H4(45),n2h4(101))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,14),G0H4(1),m3h4x4(:,50),heltab2x16(:,:,79))
  call Hloop_A_Q(ntryL,G0H4(1),115,0,G1H4(42),n2h4(102))
  call Hloop_AV_Q(ntryL,G1H16(45),wf4(:,14),G1H4(46),m3h4x4(:,51),heltab2x16(:,:,80))
  call Hloop_A_Q(ntryL,G1H4(46),115,nMT,G2H4(43),n2h4(103))
call HGT_OLR(G1H16(7),1,1,16)
call HGT_invQ_OLR(G1H16(7),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(7),-12,nMT,G2H16(11),n2h16(105))
  call Hloop_QV_A(ntryL,G2H16(11),wf4(:,2),G2H4(42),m3h4x4(:,52),heltab2x16(:,:,81))
  call Hloop_AV_Q(ntryL,G1H16(10),wf4(:,14),G1H4(47),m3h4x4(:,53),heltab2x16(:,:,82))
  call Hloop_A_Q(ntryL,G1H4(47),115,nMT,G2H4(39),n2h4(104))
  call Hloop_AV_Q(ntryL,G1H16(11),wf4(:,14),G1H4(52),m3h4x4(:,54),heltab2x16(:,:,83))
  call Hloop_A_Q(ntryL,G1H4(52),115,nMT,G2H4(37),n2h4(105))
  call Hloop_AV_Q(ntryL,G0H16(2),wf4(:,14),G0H4(1),m3h4x4(:,55),heltab2x16(:,:,84))
  call Hloop_A_Q(ntryL,G0H4(1),115,nMT,G1H4(53),n2h4(106))
  call Hloop_QV_A(ntryL,G1H16(12),wf4(:,14),G1H4(57),m3h4x4(:,56),heltab2x16(:,:,85))
  call Hloop_Q_A(ntryL,G1H4(57),115,0,G2H4(36),n2h4(107))
call HGT_OLR(G1H16(13),1,1,16)
call HGT_invQ_OLR(G1H16(13),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(13),-12,0,G2H16(17),n2h16(106))
  call Hloop_AV_Q(ntryL,G2H16(17),wf4(:,2),G2H4(33),m3h4x4(:,57),heltab2x16(:,:,86))
  call Hloop_QV_A(ntryL,G1H16(16),wf4(:,14),G1H4(58),m3h4x4(:,58),heltab2x16(:,:,87))
  call Hloop_Q_A(ntryL,G1H4(58),115,0,G2H4(16),n2h4(108))
  call Hloop_QV_A(ntryL,G1H16(17),wf4(:,14),G1H4(63),m3h4x4(:,59),heltab2x16(:,:,88))
  call Hloop_Q_A(ntryL,G1H4(63),115,0,G2H4(9),n2h4(109))
  call Hloop_QV_A(ntryL,G0H16(3),wf4(:,14),G0H4(1),m3h4x4(:,60),heltab2x16(:,:,89))
  call Hloop_Q_A(ntryL,G0H4(1),115,0,G1H4(64),n2h4(110))
  call Hloop_QV_A(ntryL,G1H16(18),wf4(:,14),G1H4(18),m3h4x4(:,61),heltab2x16(:,:,90))
  call Hloop_Q_A(ntryL,G1H4(18),115,nMT,G2H4(4),n2h4(111))
call HGT_OLR(G1H16(19),1,1,16)
call HGT_invQ_OLR(G1H16(19),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(19),-12,nMT,G2H16(19),n2h16(107))
  call Hloop_AV_Q(ntryL,G2H16(19),wf4(:,2),G2H4(17),m3h4x4(:,62),heltab2x16(:,:,91))
  call Hloop_QV_A(ntryL,G1H16(22),wf4(:,14),G1H4(35),m3h4x4(:,63),heltab2x16(:,:,92))
  call Hloop_Q_A(ntryL,G1H4(35),115,nMT,G2H4(8),n2h4(112))
  call Hloop_QV_A(ntryL,G1H16(23),wf4(:,14),G1H4(36),m3h4x4(:,64),heltab2x16(:,:,93))
  call Hloop_Q_A(ntryL,G1H4(36),115,nMT,G2H4(30),n2h4(113))
  call Hloop_QV_A(ntryL,G0H16(4),wf4(:,14),G0H4(1),m3h4x4(:,65),heltab2x16(:,:,94))
  call Hloop_Q_A(ntryL,G0H4(1),115,nMT,G1H4(41),n2h4(114))
  call Hloop_AV_Q(ntryL,G1H16(24),wf4(:,14),G1H4(46),m3h4x4(:,66),heltab2x16(:,:,95))
  call Hloop_A_Q(ntryL,G1H4(46),115,nMB,G2H4(22),n2h4(115))
call HGT_OLR(G1H16(25),1,1,16)
call HGT_invQ_OLR(G1H16(25),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(25),-12,nMB,G2H16(33),n2h16(108))
  call Hloop_QV_A(ntryL,G2H16(33),wf4(:,2),G2H4(18),m3h4x4(:,67),heltab2x16(:,:,96))
  call Hloop_AV_Q(ntryL,G1H16(28),wf4(:,14),G1H4(47),m3h4x4(:,68),heltab2x16(:,:,97))
  call Hloop_A_Q(ntryL,G1H4(47),115,nMB,G2H4(14),n2h4(116))
  call Hloop_AV_Q(ntryL,G1H16(29),wf4(:,14),G1H4(52),m3h4x4(:,69),heltab2x16(:,:,98))
  call Hloop_A_Q(ntryL,G1H4(52),115,nMB,G2H4(23),n2h4(117))
  call Hloop_AV_Q(ntryL,G0H16(5),wf4(:,14),G0H4(1),m3h4x4(:,70),heltab2x16(:,:,99))
  call Hloop_A_Q(ntryL,G0H4(1),115,nMB,G1H4(57),n2h4(118))
  call Hloop_QV_A(ntryL,G1H16(30),wf4(:,14),G1H4(58),m3h4x4(:,71),heltab2x16(:,:,100))
  call Hloop_Q_A(ntryL,G1H4(58),115,nMB,G2H4(27),n2h4(119))
call HGT_OLR(G1H16(31),1,1,16)
call HGT_invQ_OLR(G1H16(31),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(31),-12,nMB,G2H16(34),n2h16(109))
  call Hloop_AV_Q(ntryL,G2H16(34),wf4(:,2),G2H4(48),m3h4x4(:,72),heltab2x16(:,:,101))
  call Hloop_QV_A(ntryL,G1H16(34),wf4(:,14),G1H4(63),m3h4x4(:,73),heltab2x16(:,:,102))
  call Hloop_Q_A(ntryL,G1H4(63),115,nMB,G2H4(49),n2h4(120))
  call Hloop_QV_A(ntryL,G1H16(35),wf4(:,14),G1H4(18),m3h4x4(:,74),heltab2x16(:,:,103))
  call Hloop_Q_A(ntryL,G1H4(18),115,nMB,G2H4(21),n2h4(121))
  call Hloop_QV_A(ntryL,G0H16(6),wf4(:,14),G0H4(1),m3h4x4(:,75),heltab2x16(:,:,104))
  call Hloop_Q_A(ntryL,G0H4(1),115,nMB,G1H4(35),n2h4(122))
  call Hloop_AV_Q(ntryL,G1H16(36),wf4(:,14),G1H4(36),m3h4x4(:,76),heltab2x16(:,:,105))
  call Hloop_A_Q(ntryL,G1H4(36),115,0,G2H4(24),n2h4(123))
call HGT_OLR(G1H16(37),1,1,16)
call HGT_invQ_OLR(G1H16(37),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(37),-12,0,G2H16(35),n2h16(110))
  call Hloop_QZ_A(ntryL,G2H16(35),wf4(:,7),G2H4(25),ngZu,m3h4x4(:,77),heltab2x16(:,:,106))
  call Hloop_AV_Q(ntryL,G1H16(40),wf4(:,14),G1H4(46),m3h4x4(:,78),heltab2x16(:,:,107))
  call Hloop_A_Q(ntryL,G1H4(46),115,0,G2H4(28),n2h4(124))
  call Hloop_AV_Q(ntryL,G1H16(41),wf4(:,14),G1H4(47),m3h4x4(:,79),heltab2x16(:,:,108))
  call Hloop_A_Q(ntryL,G1H4(47),115,0,G2H4(29),n2h4(125))
  call Hloop_AV_Q(ntryL,G0H16(7),wf4(:,14),G0H4(1),m3h4x4(:,80),heltab2x16(:,:,109))
  call Hloop_A_Q(ntryL,G0H4(1),115,0,G1H4(52),n2h4(126))
  call Hloop_AV_Q(ntryL,G1H16(42),wf4(:,14),G1H4(58),m3h4x4(:,81),heltab2x16(:,:,110))
  call Hloop_A_Q(ntryL,G1H4(58),115,nMT,G2H4(31),n2h4(127))
call HGT_OLR(G1H16(43),1,1,16)
call HGT_invQ_OLR(G1H16(43),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(43),-12,nMT,G2H16(36),n2h16(111))
  call Hloop_QZ_A(ntryL,G2H16(36),wf4(:,7),G2H4(50),ngZu,m3h4x4(:,82),heltab2x16(:,:,111))
  call Hloop_AV_Q(ntryL,G1H16(46),wf4(:,14),G1H4(63),m3h4x4(:,83),heltab2x16(:,:,112))
  call Hloop_A_Q(ntryL,G1H4(63),115,nMT,G2H4(51),n2h4(128))
  call Hloop_AV_Q(ntryL,G1H16(47),wf4(:,14),G1H4(18),m3h4x4(:,84),heltab2x16(:,:,113))
  call Hloop_A_Q(ntryL,G1H4(18),115,nMT,G2H4(52),n2h4(129))
  call Hloop_AV_Q(ntryL,G0H16(8),wf4(:,14),G0H4(1),m3h4x4(:,85),heltab2x16(:,:,114))
  call Hloop_A_Q(ntryL,G0H4(1),115,nMT,G1H4(36),n2h4(130))
  call Hloop_QV_A(ntryL,G1H16(48),wf4(:,14),G1H4(46),m3h4x4(:,86),heltab2x16(:,:,115))
  call Hloop_Q_A(ntryL,G1H4(46),115,0,G2H4(53),n2h4(131))
call HGT_OLR(G1H16(3),1,1,16)
call HGT_invQ_OLR(G1H16(3),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(3),-12,0,G2H16(37),n2h16(112))
  call Hloop_AZ_Q(ntryL,G2H16(37),wf4(:,7),G2H4(54),ngZu,m3h4x4(:,87),heltab2x16(:,:,116))
  call Hloop_QV_A(ntryL,G1H16(1),wf4(:,14),G1H4(47),m3h4x4(:,88),heltab2x16(:,:,117))
  call Hloop_Q_A(ntryL,G1H4(47),115,0,G2H4(55),n2h4(132))
  call Hloop_QV_A(ntryL,G1H16(2),wf4(:,14),G1H4(58),m3h4x4(:,89),heltab2x16(:,:,118))
  call Hloop_Q_A(ntryL,G1H4(58),115,0,G2H4(56),n2h4(133))
  call Hloop_QV_A(ntryL,G0H16(9),wf4(:,14),G0H4(1),m3h4x4(:,90),heltab2x16(:,:,119))
  call Hloop_Q_A(ntryL,G0H4(1),115,0,G1H4(63),n2h4(134))
  call Hloop_QV_A(ntryL,G1H16(4),wf4(:,14),G1H4(18),m3h4x4(:,91),heltab2x16(:,:,120))
  call Hloop_Q_A(ntryL,G1H4(18),115,nMT,G2H4(57),n2h4(135))
call HGT_OLR(G1H16(5),1,1,16)
call HGT_invQ_OLR(G1H16(5),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(5),-12,nMT,G2H16(38),n2h16(113))
  call Hloop_AZ_Q(ntryL,G2H16(38),wf4(:,7),G2H4(58),ngZu,m3h4x4(:,92),heltab2x16(:,:,121))
  call Hloop_QV_A(ntryL,G1H16(49),wf4(:,14),G1H4(46),m3h4x4(:,93),heltab2x16(:,:,122))
  call Hloop_Q_A(ntryL,G1H4(46),115,nMT,G2H4(59),n2h4(136))
  call Hloop_QV_A(ntryL,G1H16(50),wf4(:,14),G1H4(47),m3h4x4(:,94),heltab2x16(:,:,123))
  call Hloop_Q_A(ntryL,G1H4(47),115,nMT,G2H4(60),n2h4(137))
  call Hloop_QV_A(ntryL,G0H16(10),wf4(:,14),G0H4(1),m3h4x4(:,95),heltab2x16(:,:,124))
  call Hloop_Q_A(ntryL,G0H4(1),115,nMT,G1H4(58),n2h4(138))
  call Hloop_AV_Q(ntryL,G1H16(51),wf4(:,14),G1H4(18),m3h4x4(:,96),heltab2x16(:,:,125))
  call Hloop_A_Q(ntryL,G1H4(18),115,0,G2H4(61),n2h4(139))
call HGT_OLR(G1H16(52),1,1,16)
call HGT_invQ_OLR(G1H16(52),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(52),-12,0,G2H16(39),n2h16(114))
  call Hloop_QZ_A(ntryL,G2H16(39),wf4(:,7),G2H4(62),ngZd,m3h4x4(:,97),heltab2x16(:,:,126))
  call Hloop_AV_Q(ntryL,G1H16(54),wf4(:,14),G1H4(46),m3h4x4(:,98),heltab2x16(:,:,127))
  call Hloop_A_Q(ntryL,G1H4(46),115,0,G2H4(63),n2h4(140))
  call Hloop_AV_Q(ntryL,G1H16(55),wf4(:,14),G1H4(47),m3h4x4(:,99),heltab2x16(:,:,128))
  call Hloop_A_Q(ntryL,G1H4(47),115,0,G2H4(64),n2h4(141))
  call Hloop_AV_Q(ntryL,G0H16(11),wf4(:,14),G0H4(1),m3h4x4(:,100),heltab2x16(:,:,129))
  call Hloop_A_Q(ntryL,G0H4(1),115,0,G1H4(18),n2h4(142))
  call Hloop_AV_Q(ntryL,G1H16(56),wf4(:,14),G1H4(46),m3h4x4(:,101),heltab2x16(:,:,130))
  call Hloop_A_Q(ntryL,G1H4(46),115,nMB,G2H4(65),n2h4(143))
call HGT_OLR(G1H16(57),1,1,16)
call HGT_invQ_OLR(G1H16(57),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(57),-12,nMB,G2H16(40),n2h16(115))
  call Hloop_QZ_A(ntryL,G2H16(40),wf4(:,7),G2H4(66),ngZd,m3h4x4(:,102),heltab2x16(:,:,131))
  call Hloop_AV_Q(ntryL,G1H16(59),wf4(:,14),G1H4(47),m3h4x4(:,103),heltab2x16(:,:,132))
  call Hloop_A_Q(ntryL,G1H4(47),115,nMB,G2H4(67),n2h4(144))
  call Hloop_AV_Q(ntryL,G1H16(60),wf4(:,14),G1H4(46),m3h4x4(:,104),heltab2x16(:,:,133))
  call Hloop_A_Q(ntryL,G1H4(46),115,nMB,G2H4(68),n2h4(145))
  call Hloop_AV_Q(ntryL,G0H16(12),wf4(:,14),G0H4(1),m3h4x4(:,105),heltab2x16(:,:,134))
  call Hloop_A_Q(ntryL,G0H4(1),115,nMB,G1H4(47),n2h4(146))
  call Hloop_QV_A(ntryL,G1H16(61),wf4(:,14),G1H4(46),m3h4x4(:,106),heltab2x16(:,:,135))
  call Hloop_Q_A(ntryL,G1H4(46),115,0,G2H4(69),n2h4(147))
call HGT_OLR(G1H16(62),1,1,16)
call HGT_invQ_OLR(G1H16(62),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(62),-12,0,G2H16(49),n2h16(116))
  call Hloop_AZ_Q(ntryL,G2H16(49),wf4(:,7),G2H4(70),ngZd,m3h4x4(:,107),heltab2x16(:,:,136))
  call Hloop_QV_A(ntryL,G1H16(64),wf4(:,14),G1H4(46),m3h4x4(:,108),heltab2x16(:,:,137))
  call Hloop_Q_A(ntryL,G1H4(46),115,0,G2H4(71),n2h4(148))
  call Hloop_QV_A(ntryL,G1H16(65),wf4(:,14),G1H4(46),m3h4x4(:,109),heltab2x16(:,:,138))
  call Hloop_Q_A(ntryL,G1H4(46),115,0,G2H4(72),n2h4(149))
  call Hloop_QV_A(ntryL,G0H16(13),wf4(:,14),G0H4(1),m3h4x4(:,110),heltab2x16(:,:,139))
  call Hloop_Q_A(ntryL,G0H4(1),115,0,G1H4(46),n2h4(150))
  call Hloop_QV_A(ntryL,G1H16(66),wf4(:,14),G1H4(68),m3h4x4(:,111),heltab2x16(:,:,140))
  call Hloop_Q_A(ntryL,G1H4(68),115,nMB,G2H4(73),n2h4(151))
call HGT_OLR(G1H16(67),1,1,16)
call HGT_invQ_OLR(G1H16(67),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(67),-12,nMB,G2H16(51),n2h16(117))
  call Hloop_AZ_Q(ntryL,G2H16(51),wf4(:,7),G2H4(74),ngZd,m3h4x4(:,112),heltab2x16(:,:,141))
  call Hloop_QV_A(ntryL,G1H16(69),wf4(:,14),G1H4(68),m3h4x4(:,113),heltab2x16(:,:,142))
  call Hloop_Q_A(ntryL,G1H4(68),115,nMB,G2H4(75),n2h4(152))
  call Hloop_QV_A(ntryL,G1H16(70),wf4(:,14),G1H4(68),m3h4x4(:,114),heltab2x16(:,:,143))
  call Hloop_Q_A(ntryL,G1H4(68),115,nMB,G2H4(76),n2h4(153))
  call Hloop_QV_A(ntryL,G0H16(14),wf4(:,14),G0H4(1),m3h4x4(:,115),heltab2x16(:,:,144))
  call Hloop_Q_A(ntryL,G0H4(1),115,nMB,G1H4(68),n2h4(154))
  call Hloop_AV_Q(ntryL,G1H16(71),wf4(:,2),G1H4(69),m3h4x4(:,116),heltab2x16(:,:,145))
  call Hloop_A_Q(ntryL,G1H4(69),79,0,G2H4(77),n2h4(155))
call HGT_OLR(G1H16(72),1,1,16)
call HGT_invQ_OLR(G1H16(72),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(72),-48,0,G2H16(53),n2h16(118))
  call Hloop_QV_A(ntryL,G2H16(53),wf4(:,14),G2H4(78),m3h4x4(:,117),heltab2x16(:,:,146))
  call Hloop_AV_Q(ntryL,G1H16(74),wf4(:,2),G1H4(69),m3h4x4(:,118),heltab2x16(:,:,147))
  call Hloop_A_Q(ntryL,G1H4(69),79,0,G2H4(79),n2h4(156))
  call Hloop_AV_Q(ntryL,G1H16(75),wf4(:,2),G1H4(69),m3h4x4(:,119),heltab2x16(:,:,148))
  call Hloop_A_Q(ntryL,G1H4(69),79,0,G2H4(80),n2h4(157))
  call Hloop_AV_Q(ntryL,G0H16(15),wf4(:,2),G0H4(1),m3h4x4(:,120),heltab2x16(:,:,149))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(69),n2h4(158))
  call Hloop_AV_Q(ntryL,G1H16(76),wf4(:,2),G1H4(70),m3h4x4(:,121),heltab2x16(:,:,150))
  call Hloop_A_Q(ntryL,G1H4(70),79,nMT,G2H4(81),n2h4(159))
call HGT_OLR(G1H16(77),1,1,16)
call HGT_invQ_OLR(G1H16(77),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(77),-48,nMT,G2H16(55),n2h16(119))
  call Hloop_QV_A(ntryL,G2H16(55),wf4(:,14),G2H4(82),m3h4x4(:,122),heltab2x16(:,:,151))
  call Hloop_AV_Q(ntryL,G1H16(79),wf4(:,2),G1H4(70),m3h4x4(:,123),heltab2x16(:,:,152))
  call Hloop_A_Q(ntryL,G1H4(70),79,nMT,G2H4(83),n2h4(160))
  call Hloop_AV_Q(ntryL,G1H16(80),wf4(:,2),G1H4(70),m3h4x4(:,124),heltab2x16(:,:,153))
  call Hloop_A_Q(ntryL,G1H4(70),79,nMT,G2H4(84),n2h4(161))
  call Hloop_AV_Q(ntryL,G0H16(16),wf4(:,2),G0H4(1),m3h4x4(:,125),heltab2x16(:,:,154))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMT,G1H4(70),n2h4(162))
  call Hloop_QV_A(ntryL,G1H16(81),wf4(:,2),G1H4(71),m3h4x4(:,126),heltab2x16(:,:,155))
  call Hloop_Q_A(ntryL,G1H4(71),79,0,G2H4(85),n2h4(163))
call HGT_OLR(G1H16(82),1,1,16)
call HGT_invQ_OLR(G1H16(82),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(82),-48,0,G2H16(13),n2h16(120))
  call Hloop_AV_Q(ntryL,G2H16(13),wf4(:,14),G2H4(86),m3h4x4(:,127),heltab2x16(:,:,156))
  call Hloop_QV_A(ntryL,G1H16(84),wf4(:,2),G1H4(71),m3h4x4(:,128),heltab2x16(:,:,157))
  call Hloop_Q_A(ntryL,G1H4(71),79,0,G2H4(87),n2h4(164))
  call Hloop_QV_A(ntryL,G1H16(85),wf4(:,2),G1H4(71),m3h4x4(:,129),heltab2x16(:,:,158))
  call Hloop_Q_A(ntryL,G1H4(71),79,0,G2H4(88),n2h4(165))
  call Hloop_QV_A(ntryL,G0H16(17),wf4(:,2),G0H4(1),m3h4x4(:,130),heltab2x16(:,:,159))
  call Hloop_Q_A(ntryL,G0H4(1),79,0,G1H4(71),n2h4(166))
  call Hloop_QV_A(ntryL,G1H16(86),wf4(:,2),G1H4(72),m3h4x4(:,131),heltab2x16(:,:,160))
  call Hloop_Q_A(ntryL,G1H4(72),79,nMT,G2H4(89),n2h4(167))
call HGT_OLR(G1H16(87),1,1,16)
call HGT_invQ_OLR(G1H16(87),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(87),-48,nMT,G2H16(10),n2h16(121))
  call Hloop_AV_Q(ntryL,G2H16(10),wf4(:,14),G2H4(90),m3h4x4(:,132),heltab2x16(:,:,161))
  call Hloop_QV_A(ntryL,G1H16(89),wf4(:,2),G1H4(72),m3h4x4(:,133),heltab2x16(:,:,162))
  call Hloop_Q_A(ntryL,G1H4(72),79,nMT,G2H4(91),n2h4(168))
  call Hloop_QV_A(ntryL,G1H16(90),wf4(:,2),G1H4(72),m3h4x4(:,134),heltab2x16(:,:,163))
  call Hloop_Q_A(ntryL,G1H4(72),79,nMT,G2H4(92),n2h4(169))
  call Hloop_QV_A(ntryL,G0H16(18),wf4(:,2),G0H4(1),m3h4x4(:,135),heltab2x16(:,:,164))
  call Hloop_Q_A(ntryL,G0H4(1),79,nMT,G1H4(72),n2h4(170))
  call Hloop_AV_Q(ntryL,G1H16(91),wf4(:,2),G1H4(73),m3h4x4(:,136),heltab2x16(:,:,165))
  call Hloop_A_Q(ntryL,G1H4(73),79,nMB,G2H4(93),n2h4(171))
call HGT_OLR(G1H16(92),1,1,16)
call HGT_invQ_OLR(G1H16(92),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(92),-48,nMB,G2H16(15),n2h16(122))
  call Hloop_QV_A(ntryL,G2H16(15),wf4(:,14),G2H4(94),m3h4x4(:,137),heltab2x16(:,:,166))



end subroutine vamp_1

end module ol_vamp_1_ppllllj_nenexeexddxg_1_/**/REALKIND
