
module ol_vamp_1_ppllllj_eexmmxbbxg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllllj_eexmmxbbxg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllllj_eexmmxbbxg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppllllj_eexmmxbbxg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppllllj_eexmmxbbxg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppllllj_eexmmxbbxg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppllllj_eexmmxbbxg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(579)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1),h0tab(:,1),[64,12,3,32,16],[nMB,nMB,nMB,0,nMB],5,2,wf4(:,2),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1),heltab2x128(:,:,1))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(1),n2h64(1))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(2),h0tab(:,2),[64,12,3,32,16],[nMB,nMB,nMB,0,nMB],5,2,wf4(:,2),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,2),heltab2x128(:,:,2))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(2),n2h64(2))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(3),h0tab(:,3),[64,12,3,32,16],[nMB,nMB,nMB,0,nMB],5,2,wf4(:,7),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,3),heltab2x128(:,:,3))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(3),n2h64(3))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(4),h0tab(:,4),[64,12,3,32,16],[nMB,nMB,nMB,0,nMB],5,2,wf4(:,9),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,4),heltab2x128(:,:,4))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(4),n2h64(4))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(5),h0tab(:,5),[64,12,3,32,16],[nMB,nMB,nMB,0,nMB],5,2,wf4(:,7),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,5),heltab2x128(:,:,5))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(5),n2h64(5))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(6),h0tab(:,6),[64,12,3,32,16],[nMB,nMB,nMB,0,nMB],5,2,wf4(:,9),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,6),heltab2x128(:,:,6))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(6),n2h64(6))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(579)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(7),h0tab(:,7),[64,3,12,32,16],[nMB,nMB,nMB,0,nMB],5,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,7),heltab2x128(:,:,7))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(7),n2h64(7))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(8),h0tab(:,8),[64,3,12,32,16],[nMB,nMB,nMB,0,nMB],5,2,wf4(:,6),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,8),heltab2x128(:,:,8))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(8),n2h64(8))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(9),h0tab(:,9),[64,3,12,32,16],[nMB,nMB,nMB,0,nMB],5,2,wf4(:,1),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,9),heltab2x128(:,:,9))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(9),n2h64(9))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(10),h0tab(:,10),[64,3,12,32,16],[nMB,nMB,nMB,0,nMB],5,2,wf4(:,1),wf4(: &
    ,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,10),heltab2x128(:,:,10))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(10),n2h64(10))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(11),h0tab(:,11),[64,3,12,32,16],[nMB,nMB,nMB,0,nMB],5,2,wf4(:,6),wf4(: &
    ,7))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,11),heltab2x128(:,:,11))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(11),n2h64(11))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(12),h0tab(:,12),[64,3,12,32,16],[nMB,nMB,nMB,0,nMB],5,2,wf4(:,6),wf4(: &
    ,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,12),heltab2x128(:,:,12))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(12),n2h64(12))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(579)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(13),h0tab(:,13),[64,12,3,16,32],[nMB,nMB,nMB,0,nMB],5,2,wf4(:,2),wf4(: &
    ,1))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,13),heltab2x128(:,:,13))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(13),n2h64(13))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(14),h0tab(:,14),[64,12,3,16,32],[nMB,nMB,nMB,0,nMB],5,2,wf4(:,2),wf4(: &
    ,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,14),heltab2x128(:,:,14))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(14),n2h64(14))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(15),h0tab(:,15),[64,12,3,16,32],[nMB,nMB,nMB,0,nMB],5,2,wf4(:,7),wf4(: &
    ,1))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,15),heltab2x128(:,:,15))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(15),n2h64(15))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(16),h0tab(:,16),[64,12,3,16,32],[nMB,nMB,nMB,0,nMB],5,2,wf4(:,9),wf4(: &
    ,1))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,16),heltab2x128(:,:,16))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(16),n2h64(16))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(17),h0tab(:,17),[64,12,3,16,32],[nMB,nMB,nMB,0,nMB],5,2,wf4(:,7),wf4(: &
    ,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,17),heltab2x128(:,:,17))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(17),n2h64(17))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(18),h0tab(:,18),[64,12,3,16,32],[nMB,nMB,nMB,0,nMB],5,2,wf4(:,9),wf4(: &
    ,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,18),heltab2x128(:,:,18))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(18),n2h64(18))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(579)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(19),h0tab(:,19),[64,3,16,32,12],[nMB,nMB,0,nMB,nMB],5,2,wf4(:,1),wf4(: &
    ,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,19),heltab2x128(:,:,19))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(19),n2h64(19))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(20),h0tab(:,20),[64,3,16,32,12],[nMB,nMB,0,nMB,nMB],5,2,wf4(:,6),wf4(: &
    ,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,20),heltab2x128(:,:,20))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(20),n2h64(20))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(21),h0tab(:,21),[64,3,16,32,12],[nMB,nMB,0,nMB,nMB],5,2,wf4(:,1),wf4(: &
    ,7))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,21),heltab2x128(:,:,21))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(21),n2h64(21))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(22),h0tab(:,22),[64,3,16,32,12],[nMB,nMB,0,nMB,nMB],5,2,wf4(:,1),wf4(: &
    ,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,22),heltab2x128(:,:,22))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(22),n2h64(22))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(23),h0tab(:,23),[64,3,16,32,12],[nMB,nMB,0,nMB,nMB],5,2,wf4(:,6),wf4(: &
    ,7))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,23),heltab2x128(:,:,23))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(23),n2h64(23))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(24),h0tab(:,24),[64,3,16,32,12],[nMB,nMB,0,nMB,nMB],5,2,wf4(:,6),wf4(: &
    ,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,24),heltab2x128(:,:,24))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(24),n2h64(24))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(579)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(25),h0tab(:,25),[64,3,12,16,32],[nMB,nMB,nMB,0,nMB],5,2,wf4(:,1),wf4(: &
    ,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,25),heltab2x128(:,:,25))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(25),n2h64(25))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(26),h0tab(:,26),[64,3,12,16,32],[nMB,nMB,nMB,0,nMB],5,2,wf4(:,6),wf4(: &
    ,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,26),heltab2x128(:,:,26))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(26),n2h64(26))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(27),h0tab(:,27),[64,3,12,16,32],[nMB,nMB,nMB,0,nMB],5,2,wf4(:,1),wf4(: &
    ,7))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,27),heltab2x128(:,:,27))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(27),n2h64(27))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(28),h0tab(:,28),[64,3,12,16,32],[nMB,nMB,nMB,0,nMB],5,2,wf4(:,1),wf4(: &
    ,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,28),heltab2x128(:,:,28))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(28),n2h64(28))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(29),h0tab(:,29),[64,3,12,16,32],[nMB,nMB,nMB,0,nMB],5,2,wf4(:,6),wf4(: &
    ,7))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,29),heltab2x128(:,:,29))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(29),n2h64(29))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(30),h0tab(:,30),[64,3,12,16,32],[nMB,nMB,nMB,0,nMB],5,2,wf4(:,6),wf4(: &
    ,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,30),heltab2x128(:,:,30))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(30),n2h64(30))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(579)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(31),h0tab(:,31),[64,3,32,16,12],[nMB,nMB,0,nMB,nMB],5,2,wf4(:,1),wf4(: &
    ,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,31),heltab2x128(:,:,31))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(31),n2h64(31))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(32),h0tab(:,32),[64,3,32,16,12],[nMB,nMB,0,nMB,nMB],5,2,wf4(:,6),wf4(: &
    ,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,32),heltab2x128(:,:,32))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(32),n2h64(32))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(33),h0tab(:,33),[64,3,32,16,12],[nMB,nMB,0,nMB,nMB],5,2,wf4(:,1),wf4(: &
    ,7))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,33),heltab2x128(:,:,33))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(33),n2h64(33))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(34),h0tab(:,34),[64,3,32,16,12],[nMB,nMB,0,nMB,nMB],5,2,wf4(:,1),wf4(: &
    ,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,34),heltab2x128(:,:,34))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(34),n2h64(34))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(35),h0tab(:,35),[64,3,32,16,12],[nMB,nMB,0,nMB,nMB],5,2,wf4(:,6),wf4(: &
    ,7))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,35),heltab2x128(:,:,35))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(35),n2h64(35))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(36),h0tab(:,36),[64,3,32,16,12],[nMB,nMB,0,nMB,nMB],5,2,wf4(:,6),wf4(: &
    ,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,36),heltab2x128(:,:,36))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(36),n2h64(36))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(579)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(37),h0tab(:,37),[64,16,3,12,32],[0,nMB,nMB,nMB,0],5,2,wf4(:,1),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(37),m3h2x64(:,37),heltab2x128(:,:,37))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(38),h0tab(:,38),[64,16,3,12,32],[0,nMB,nMB,nMB,0],5,2,wf4(:,6),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(38),m3h2x64(:,38),heltab2x128(:,:,38))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(39),h0tab(:,39),[64,16,3,12,32],[0,nMB,nMB,nMB,0],5,2,wf4(:,1),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(39),m3h2x64(:,39),heltab2x128(:,:,39))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(40),h0tab(:,40),[64,16,3,12,32],[0,nMB,nMB,nMB,0],5,2,wf4(:,1),wf4(:,9))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(40),m3h2x64(:,40),heltab2x128(:,:,40))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(41),h0tab(:,41),[64,16,3,12,32],[0,nMB,nMB,nMB,0],5,2,wf4(:,6),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(41),m3h2x64(:,41),heltab2x128(:,:,41))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(42),h0tab(:,42),[64,16,3,12,32],[0,nMB,nMB,nMB,0],5,2,wf4(:,6),wf4(:,9))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(42),m3h2x64(:,42),heltab2x128(:,:,42))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(579)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(43),h0tab(:,43),[64,16,12,3,32],[0,nMB,nMB,nMB,0],5,2,wf4(:,2),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(43),m3h2x64(:,43),heltab2x128(:,:,43))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(44),h0tab(:,44),[64,16,12,3,32],[0,nMB,nMB,nMB,0],5,2,wf4(:,2),wf4(:,6))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(44),m3h2x64(:,44),heltab2x128(:,:,44))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(45),h0tab(:,45),[64,16,12,3,32],[0,nMB,nMB,nMB,0],5,2,wf4(:,7),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(45),m3h2x64(:,45),heltab2x128(:,:,45))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(46),h0tab(:,46),[64,16,12,3,32],[0,nMB,nMB,nMB,0],5,2,wf4(:,9),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(46),m3h2x64(:,46),heltab2x128(:,:,46))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(47),h0tab(:,47),[64,16,12,3,32],[0,nMB,nMB,nMB,0],5,2,wf4(:,7),wf4(:,6))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(47),m3h2x64(:,47),heltab2x128(:,:,47))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(48),h0tab(:,48),[64,16,12,3,32],[0,nMB,nMB,nMB,0],5,2,wf4(:,9),wf4(:,6))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(48),m3h2x64(:,48),heltab2x128(:,:,48))
  call Hloop_QS_A(ntryL,G1H64(1),wf4(:,2),G1H16(1),ngH,m3h4x16(:,1),heltab2x64(:,:,1))
  call Hloop_Q_A(ntryL,G1H16(1),76,nMB,G2H16(1),n2h16(1))
  call Hloop_QS_A(ntryL,G1H64(2),wf4(:,2),G1H16(1),ngH,m3h4x16(:,2),heltab2x64(:,:,2))
  call Hloop_Q_A(ntryL,G1H16(1),76,nMB,G2H16(2),n2h16(2))
  call Hloop_QV_A(ntryL,G1H64(3),wf4(:,7),G1H16(1),m3h4x16(:,3),heltab2x64(:,:,3))
  call Hloop_Q_A(ntryL,G1H16(1),76,nMB,G2H16(3),n2h16(3))
  call Hloop_QZ_A(ntryL,G1H64(4),wf4(:,9),G1H16(1),ngZd,m3h4x16(:,4),heltab2x64(:,:,4))
  call Hloop_Q_A(ntryL,G1H16(1),76,nMB,G2H16(4),n2h16(4))
  call Hloop_QV_A(ntryL,G1H64(5),wf4(:,7),G1H16(1),m3h4x16(:,5),heltab2x64(:,:,5))
  call Hloop_Q_A(ntryL,G1H16(1),76,nMB,G2H16(5),n2h16(5))
  call Hloop_QZ_A(ntryL,G1H64(6),wf4(:,9),G1H16(1),ngZd,m3h4x16(:,6),heltab2x64(:,:,6))
  call Hloop_Q_A(ntryL,G1H16(1),76,nMB,G2H16(6),n2h16(6))
  call Hloop_QV_A(ntryL,G1H64(7),wf4(:,1),G1H16(1),m3h4x16(:,7),heltab2x64(:,:,7))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMB,G2H16(7),n2h16(7))
  call Hloop_QZ_A(ntryL,G1H64(8),wf4(:,6),G1H16(1),ngZd,m3h4x16(:,8),heltab2x64(:,:,8))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMB,G2H16(8),n2h16(8))
  call Hloop_QV_A(ntryL,G1H64(9),wf4(:,1),G1H16(1),m3h4x16(:,9),heltab2x64(:,:,9))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMB,G2H16(9),n2h16(9))
  call Hloop_QV_A(ntryL,G1H64(10),wf4(:,1),G1H16(1),m3h4x16(:,10),heltab2x64(:,:,10))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMB,G2H16(10),n2h16(10))
  call Hloop_QZ_A(ntryL,G1H64(11),wf4(:,6),G1H16(1),ngZd,m3h4x16(:,11),heltab2x64(:,:,11))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMB,G2H16(11),n2h16(11))
  call Hloop_QZ_A(ntryL,G1H64(12),wf4(:,6),G1H16(1),ngZd,m3h4x16(:,12),heltab2x64(:,:,12))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMB,G2H16(12),n2h16(12))
  call Hloop_AS_Q(ntryL,G1H64(13),wf4(:,2),G1H16(1),ngH,m3h4x16(:,13),heltab2x64(:,:,13))
  call Hloop_A_Q(ntryL,G1H16(1),76,nMB,G2H16(13),n2h16(13))
  call Hloop_AS_Q(ntryL,G1H64(14),wf4(:,2),G1H16(1),ngH,m3h4x16(:,14),heltab2x64(:,:,14))
  call Hloop_A_Q(ntryL,G1H16(1),76,nMB,G2H16(14),n2h16(14))
  call Hloop_AV_Q(ntryL,G1H64(15),wf4(:,7),G1H16(1),m3h4x16(:,15),heltab2x64(:,:,15))
  call Hloop_A_Q(ntryL,G1H16(1),76,nMB,G2H16(15),n2h16(15))
  call Hloop_AZ_Q(ntryL,G1H64(16),wf4(:,9),G1H16(1),ngZd,m3h4x16(:,16),heltab2x64(:,:,16))
  call Hloop_A_Q(ntryL,G1H16(1),76,nMB,G2H16(16),n2h16(16))
  call Hloop_AV_Q(ntryL,G1H64(17),wf4(:,7),G1H16(1),m3h4x16(:,17),heltab2x64(:,:,17))
  call Hloop_A_Q(ntryL,G1H16(1),76,nMB,G2H16(17),n2h16(17))
  call Hloop_AZ_Q(ntryL,G1H64(18),wf4(:,9),G1H16(1),ngZd,m3h4x16(:,18),heltab2x64(:,:,18))
  call Hloop_A_Q(ntryL,G1H16(1),76,nMB,G2H16(18),n2h16(18))
  call Hloop_AV_Q(ntryL,G1H64(19),wf4(:,1),G1H16(1),m3h4x16(:,19),heltab2x64(:,:,19))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMB,G2H16(19),n2h16(19))
  call Hloop_AZ_Q(ntryL,G1H64(20),wf4(:,6),G1H16(1),ngZd,m3h4x16(:,20),heltab2x64(:,:,20))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMB,G2H16(20),n2h16(20))
  call Hloop_AV_Q(ntryL,G1H64(21),wf4(:,1),G1H16(1),m3h4x16(:,21),heltab2x64(:,:,21))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMB,G2H16(21),n2h16(21))
  call Hloop_AV_Q(ntryL,G1H64(22),wf4(:,1),G1H16(1),m3h4x16(:,22),heltab2x64(:,:,22))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMB,G2H16(22),n2h16(22))
  call Hloop_AZ_Q(ntryL,G1H64(23),wf4(:,6),G1H16(1),ngZd,m3h4x16(:,23),heltab2x64(:,:,23))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMB,G2H16(23),n2h16(23))
  call Hloop_AZ_Q(ntryL,G1H64(24),wf4(:,6),G1H16(1),ngZd,m3h4x16(:,24),heltab2x64(:,:,24))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMB,G2H16(24),n2h16(24))
  call Hloop_AV_Q(ntryL,G1H64(25),wf4(:,1),G1H16(1),m3h4x16(:,25),heltab2x64(:,:,25))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMB,G2H16(25),n2h16(25))
  call Hloop_AZ_Q(ntryL,G1H64(26),wf4(:,6),G1H16(1),ngZd,m3h4x16(:,26),heltab2x64(:,:,26))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMB,G2H16(26),n2h16(26))
  call Hloop_AV_Q(ntryL,G1H64(27),wf4(:,1),G1H16(1),m3h4x16(:,27),heltab2x64(:,:,27))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMB,G2H16(27),n2h16(27))
  call Hloop_AV_Q(ntryL,G1H64(28),wf4(:,1),G1H16(1),m3h4x16(:,28),heltab2x64(:,:,28))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMB,G2H16(28),n2h16(28))
  call Hloop_AZ_Q(ntryL,G1H64(29),wf4(:,6),G1H16(1),ngZd,m3h4x16(:,29),heltab2x64(:,:,29))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMB,G2H16(29),n2h16(29))
  call Hloop_AZ_Q(ntryL,G1H64(30),wf4(:,6),G1H16(1),ngZd,m3h4x16(:,30),heltab2x64(:,:,30))
  call Hloop_A_Q(ntryL,G1H16(1),67,nMB,G2H16(30),n2h16(30))
  call Hloop_QV_A(ntryL,G1H64(31),wf4(:,1),G1H16(1),m3h4x16(:,31),heltab2x64(:,:,31))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMB,G2H16(31),n2h16(31))
  call Hloop_QZ_A(ntryL,G1H64(32),wf4(:,6),G1H16(1),ngZd,m3h4x16(:,32),heltab2x64(:,:,32))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMB,G2H16(32),n2h16(32))
  call Hloop_QV_A(ntryL,G1H64(33),wf4(:,1),G1H16(1),m3h4x16(:,33),heltab2x64(:,:,33))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMB,G2H16(33),n2h16(33))
  call Hloop_QV_A(ntryL,G1H64(34),wf4(:,1),G1H16(1),m3h4x16(:,34),heltab2x64(:,:,34))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMB,G2H16(34),n2h16(34))
  call Hloop_QZ_A(ntryL,G1H64(35),wf4(:,6),G1H16(1),ngZd,m3h4x16(:,35),heltab2x64(:,:,35))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMB,G2H16(35),n2h16(35))
  call Hloop_QZ_A(ntryL,G1H64(36),wf4(:,6),G1H16(1),ngZd,m3h4x16(:,36),heltab2x64(:,:,36))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMB,G2H16(36),n2h16(36))
  call Hloop_VQ_A(ntryL,G1H64(37),ex5(:),G1H32(1),m3h2x32(:,1),heltab2x64(:,:,37))
  call Hloop_Q_A(ntryL,G1H32(1),80,nMB,G2H32(1),n2h32(1))
  call Hloop_VQ_A(ntryL,G1H64(38),ex5(:),G1H32(1),m3h2x32(:,2),heltab2x64(:,:,38))
  call Hloop_Q_A(ntryL,G1H32(1),80,nMB,G2H32(2),n2h32(2))
  call Hloop_VQ_A(ntryL,G1H64(39),ex5(:),G1H32(1),m3h2x32(:,3),heltab2x64(:,:,39))
  call Hloop_Q_A(ntryL,G1H32(1),80,nMB,G2H32(3),n2h32(3))
  call Hloop_VQ_A(ntryL,G1H64(40),ex5(:),G1H32(1),m3h2x32(:,4),heltab2x64(:,:,40))
  call Hloop_Q_A(ntryL,G1H32(1),80,nMB,G2H32(4),n2h32(4))
  call Hloop_VQ_A(ntryL,G1H64(41),ex5(:),G1H32(1),m3h2x32(:,5),heltab2x64(:,:,41))
  call Hloop_Q_A(ntryL,G1H32(1),80,nMB,G2H32(5),n2h32(5))
  call Hloop_VQ_A(ntryL,G1H64(42),ex5(:),G1H32(1),m3h2x32(:,6),heltab2x64(:,:,42))
  call Hloop_Q_A(ntryL,G1H32(1),80,nMB,G2H32(6),n2h32(6))
  call Hloop_VQ_A(ntryL,G1H64(43),ex5(:),G1H32(1),m3h2x32(:,7),heltab2x64(:,:,43))
  call Hloop_Q_A(ntryL,G1H32(1),80,nMB,G2H32(7),n2h32(7))
  call Hloop_VQ_A(ntryL,G1H64(44),ex5(:),G1H32(1),m3h2x32(:,8),heltab2x64(:,:,44))
  call Hloop_Q_A(ntryL,G1H32(1),80,nMB,G2H32(8),n2h32(8))
  call Hloop_VQ_A(ntryL,G1H64(45),ex5(:),G1H32(1),m3h2x32(:,9),heltab2x64(:,:,45))
  call Hloop_Q_A(ntryL,G1H32(1),80,nMB,G2H32(9),n2h32(9))
  call Hloop_VQ_A(ntryL,G1H64(46),ex5(:),G1H32(1),m3h2x32(:,10),heltab2x64(:,:,46))
  call Hloop_Q_A(ntryL,G1H32(1),80,nMB,G2H32(10),n2h32(10))
  call Hloop_VQ_A(ntryL,G1H64(47),ex5(:),G1H32(1),m3h2x32(:,11),heltab2x64(:,:,47))
  call Hloop_Q_A(ntryL,G1H32(1),80,nMB,G2H32(11),n2h32(11))
  call Hloop_VQ_A(ntryL,G1H64(48),ex5(:),G1H32(1),m3h2x32(:,12),heltab2x64(:,:,48))
  call Hloop_Q_A(ntryL,G1H32(1),80,nMB,G2H32(12),n2h32(12))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(4),[G2H16(3),G2H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(6),[G2H16(5),G2H16(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(8),[G2H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(11),[G2H16(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(12),[G2H16(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(16),[G2H16(15),G2H16(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(18),[G2H16(17),G2H16(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(20),[G2H16(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(23),[G2H16(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(24),[G2H16(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(26),[G2H16(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(29),[G2H16(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(30),[G2H16(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(32),[G2H16(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(35),[G2H16(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(36),[G2H16(34)])
  call Hotf_5pt_reduction(G2H16(4),RedSet_5(1),mass5set(:,1),  & 
G1H16(1),G1H16(2),G1H16(3),G1H16(4),G1H16(5),G1H16(6),16)
  call HG1shiftOLR(G1H16(2),16,16)
  call Hotf_5pt_reduction(G2H16(6),RedSet_5(1),mass5set(:,1),  & 
G1H16(7),G1H16(8),G1H16(9),G1H16(10),G1H16(11),G1H16(12),16)
  call HG1shiftOLR(G1H16(8),16,16)
  call Hotf_5pt_reduction(G2H16(8),RedSet_5(2),mass5set(:,1),  & 
G1H16(13),G1H16(14),G1H16(15),G1H16(16),G1H16(17),G1H16(18),16)
  call HG1shiftOLR(G1H16(14),16,16)
  call Hotf_5pt_reduction(G2H16(11),RedSet_5(2),mass5set(:,1),  & 
G1H16(19),G1H16(20),G1H16(21),G1H16(22),G1H16(23),G1H16(24),16)
  call HG1shiftOLR(G1H16(20),16,16)
  call Hotf_5pt_reduction(G2H16(12),RedSet_5(2),mass5set(:,1),  & 
G1H16(25),G1H16(26),G1H16(27),G1H16(28),G1H16(29),G1H16(30),16)
  call HG1shiftOLR(G1H16(26),16,16)
  call Hotf_5pt_reduction(G2H16(16),RedSet_5(3),mass5set(:,1),  & 
G1H16(31),G1H16(32),G1H16(33),G1H16(34),G1H16(35),G1H16(36),16)
  call HG1shiftOLR(G1H16(32),32,16)
  call Hotf_5pt_reduction(G2H16(18),RedSet_5(3),mass5set(:,1),  & 
G1H16(37),G1H16(38),G1H16(39),G1H16(40),G1H16(41),G1H16(42),16)
  call HG1shiftOLR(G1H16(38),32,16)
  call Hloop_AQ_V(ntryL,G2H16(20),ex5(:),G2H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_AQ_V(ntryL,G2H16(23),ex5(:),G2H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_AQ_V(ntryL,G2H16(24),ex5(:),G2H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hotf_5pt_reduction(G2H16(26),RedSet_5(4),mass5set(:,1),  & 
G1H16(43),G1H16(44),G1H16(45),G1H16(46),G1H16(47),G1H16(48),16)
  call HG1shiftOLR(G1H16(44),32,16)
  call Hotf_5pt_reduction(G2H16(29),RedSet_5(4),mass5set(:,1),  & 
G1H16(49),G1H16(50),G1H16(51),G1H16(52),G1H16(53),G1H16(54),16)
  call HG1shiftOLR(G1H16(50),32,16)
  call Hotf_5pt_reduction(G2H16(30),RedSet_5(4),mass5set(:,1),  & 
G1H16(55),G1H16(56),G1H16(57),G1H16(58),G1H16(59),G1H16(60),16)
  call HG1shiftOLR(G1H16(56),32,16)
  call Hloop_QA_V(ntryL,G2H16(32),ex6(:),G2H8(4),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_QA_V(ntryL,G2H16(35),ex6(:),G2H8(5),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_QA_V(ntryL,G2H16(36),ex6(:),G2H8(6),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hotf_5pt_reduction(G2H32(1),RedSet_5(5),mass5set(:,2),  & 
G1H32(1),G1H32(2),G1H32(3),G1H32(4),G1H32(5),G1H32(6),32)
  call HG1shiftOLR(G1H32(2),32,32)
  call Hotf_5pt_reduction(G2H32(2),RedSet_5(5),mass5set(:,2),  & 
G1H32(7),G1H32(8),G1H32(9),G1H32(10),G1H32(11),G1H32(12),32)
  call HG1shiftOLR(G1H32(8),32,32)
  call Hotf_5pt_reduction(G2H32(3),RedSet_5(5),mass5set(:,2),  & 
G1H32(13),G1H32(14),G1H32(15),G1H32(16),G1H32(17),G1H32(18),32)
  call HG1shiftOLR(G1H32(14),32,32)
  call Hotf_5pt_reduction(G2H32(4),RedSet_5(5),mass5set(:,2),  & 
G1H32(19),G1H32(20),G1H32(21),G1H32(22),G1H32(23),G1H32(24),32)
  call HG1shiftOLR(G1H32(20),32,32)
  call Hotf_5pt_reduction(G2H32(5),RedSet_5(5),mass5set(:,2),  & 
G1H32(25),G1H32(26),G1H32(27),G1H32(28),G1H32(29),G1H32(30),32)
  call HG1shiftOLR(G1H32(26),32,32)
  call Hotf_5pt_reduction(G2H32(6),RedSet_5(5),mass5set(:,2),  & 
G1H32(31),G1H32(32),G1H32(33),G1H32(34),G1H32(35),G1H32(36),32)
  call HG1shiftOLR(G1H32(32),32,32)
  call Hotf_5pt_reduction(G2H32(7),RedSet_5(6),mass5set(:,2),  & 
G1H32(37),G1H32(38),G1H32(39),G1H32(40),G1H32(41),G1H32(42),32)
  call HG1shiftOLR(G1H32(38),32,32)
  call Hotf_5pt_reduction(G2H32(8),RedSet_5(6),mass5set(:,2),  & 
G1H32(43),G1H32(44),G1H32(45),G1H32(46),G1H32(47),G1H32(48),32)
  call HG1shiftOLR(G1H32(44),32,32)
  call Hotf_5pt_reduction(G2H32(9),RedSet_5(6),mass5set(:,2),  & 
G1H32(49),G1H32(50),G1H32(51),G1H32(52),G1H32(53),G1H32(54),32)
  call HG1shiftOLR(G1H32(50),32,32)
  call Hotf_5pt_reduction(G2H32(10),RedSet_5(6),mass5set(:,2),  & 
G1H32(55),G1H32(56),G1H32(57),G1H32(58),G1H32(59),G1H32(60),32)
  call HG1shiftOLR(G1H32(56),32,32)
  call Hotf_5pt_reduction(G2H32(11),RedSet_5(6),mass5set(:,2),  & 
G1H32(61),G1H32(62),G1H32(63),G1H32(64),G1H32(65),G1H32(66),32)
  call HG1shiftOLR(G1H32(62),32,32)
  call Hotf_5pt_reduction(G2H32(12),RedSet_5(6),mass5set(:,2),  & 
G1H32(67),G1H32(68),G1H32(69),G1H32(70),G1H32(71),G1H32(72),32)
  call HG1shiftOLR(G1H32(68),32,32)
  call Hloop_QV_A(ntryL,G1H16(1),wf4(:,1),G1H4(1),m3h4x4(:,1),heltab2x16(:,:,7))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(1),n2h4(1))
call HGT_OLR(G1H16(2),1,1,16)
call HGT_invQ_OLR(G1H16(2),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(2),-16,nMB,G2H16(3),n2h16(37))
  call Hloop_AQ_V(ntryL,G2H16(3),ex5(:),G2H8(7),m3h2x8(:,7),heltab2x16(:,:,8))
  call Hloop_QV_A(ntryL,G1H16(4),wf4(:,1),G1H4(1),m3h4x4(:,2),heltab2x16(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(2),n2h4(2))
  call Hloop_QV_A(ntryL,G1H16(5),wf4(:,1),G1H4(1),m3h4x4(:,3),heltab2x16(:,:,10))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(3),n2h4(3))
  call Hloop_QV_A(ntryL,G1H16(6),wf4(:,1),G1H4(1),m3h4x4(:,4),heltab2x16(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(4),n2h4(4))
  call Hloop_QZ_A(ntryL,G1H16(7),wf4(:,6),G1H4(1),ngZd,m3h4x4(:,5),heltab2x16(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(5),n2h4(5))
call HGT_OLR(G1H16(8),1,1,16)
call HGT_invQ_OLR(G1H16(8),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(8),-16,nMB,G2H16(1),n2h16(38))
  call Hloop_AQ_V(ntryL,G2H16(1),ex5(:),G2H8(8),m3h2x8(:,8),heltab2x16(:,:,13))
  call Hloop_QZ_A(ntryL,G1H16(10),wf4(:,6),G1H4(1),ngZd,m3h4x4(:,6),heltab2x16(:,:,14))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(6),n2h4(6))
  call Hloop_QZ_A(ntryL,G1H16(11),wf4(:,6),G1H4(1),ngZd,m3h4x4(:,7),heltab2x16(:,:,15))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(7),n2h4(7))
  call Hloop_QZ_A(ntryL,G1H16(12),wf4(:,6),G1H4(1),ngZd,m3h4x4(:,8),heltab2x16(:,:,16))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(8),n2h4(8))
  call Hloop_QS_A(ntryL,G1H16(13),wf4(:,2),G1H4(1),ngH,m3h4x4(:,9),heltab2x16(:,:,17))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(9),n2h4(9))
call HGT_OLR(G1H16(14),1,1,16)
call HGT_invQ_OLR(G1H16(14),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(14),-16,nMB,G2H16(5),n2h16(39))
  call Hloop_AQ_V(ntryL,G2H16(5),ex5(:),G2H8(9),m3h2x8(:,9),heltab2x16(:,:,18))
  call Hloop_QS_A(ntryL,G1H16(16),wf4(:,2),G1H4(1),ngH,m3h4x4(:,10),heltab2x16(:,:,19))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(10),n2h4(10))
  call Hloop_QS_A(ntryL,G1H16(17),wf4(:,2),G1H4(1),ngH,m3h4x4(:,11),heltab2x16(:,:,20))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(11),n2h4(11))
  call Hloop_QS_A(ntryL,G1H16(18),wf4(:,2),G1H4(1),ngH,m3h4x4(:,12),heltab2x16(:,:,21))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(12),n2h4(12))
  call Hloop_QV_A(ntryL,G1H16(19),wf4(:,7),G1H4(1),m3h4x4(:,13),heltab2x16(:,:,22))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(13),n2h4(13))
call HGT_OLR(G1H16(20),1,1,16)
call HGT_invQ_OLR(G1H16(20),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(20),-16,nMB,G2H16(2),n2h16(40))
  call Hloop_AQ_V(ntryL,G2H16(2),ex5(:),G2H8(10),m3h2x8(:,10),heltab2x16(:,:,23))
  call Hloop_QV_A(ntryL,G1H16(22),wf4(:,7),G1H4(1),m3h4x4(:,14),heltab2x16(:,:,24))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(14),n2h4(14))
  call Hloop_QV_A(ntryL,G1H16(23),wf4(:,7),G1H4(1),m3h4x4(:,15),heltab2x16(:,:,25))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(15),n2h4(15))
  call Hloop_QV_A(ntryL,G1H16(24),wf4(:,7),G1H4(1),m3h4x4(:,16),heltab2x16(:,:,26))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(16),n2h4(16))
  call Hloop_QZ_A(ntryL,G1H16(25),wf4(:,9),G1H4(1),ngZd,m3h4x4(:,17),heltab2x16(:,:,27))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(17),n2h4(17))
call HGT_OLR(G1H16(26),1,1,16)
call HGT_invQ_OLR(G1H16(26),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(26),-16,nMB,G2H16(7),n2h16(41))
  call Hloop_AQ_V(ntryL,G2H16(7),ex5(:),G2H8(11),m3h2x8(:,11),heltab2x16(:,:,28))
  call Hloop_QZ_A(ntryL,G1H16(28),wf4(:,9),G1H4(1),ngZd,m3h4x4(:,18),heltab2x16(:,:,29))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(18),n2h4(18))
  call Hloop_QZ_A(ntryL,G1H16(29),wf4(:,9),G1H4(1),ngZd,m3h4x4(:,19),heltab2x16(:,:,30))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(19),n2h4(19))
  call Hloop_QZ_A(ntryL,G1H16(30),wf4(:,9),G1H4(1),ngZd,m3h4x4(:,20),heltab2x16(:,:,31))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(20),n2h4(20))
  call Hloop_AV_Q(ntryL,G1H16(31),wf4(:,1),G1H4(1),m3h4x4(:,21),heltab2x16(:,:,32))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(21),n2h4(21))
call HGT_OLR(G1H16(32),1,1,16)
call HGT_invQ_OLR(G1H16(32),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(32),-32,nMB,G2H16(9),n2h16(42))
  call Hloop_QA_V(ntryL,G2H16(9),ex6(:),G2H8(12),m3h2x8(:,12),heltab2x16(:,:,33))
  call Hloop_AV_Q(ntryL,G1H16(34),wf4(:,1),G1H4(1),m3h4x4(:,22),heltab2x16(:,:,34))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(22),n2h4(22))
  call Hloop_AV_Q(ntryL,G1H16(35),wf4(:,1),G1H4(1),m3h4x4(:,23),heltab2x16(:,:,35))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(23),n2h4(23))
  call Hloop_AV_Q(ntryL,G1H16(36),wf4(:,1),G1H4(1),m3h4x4(:,24),heltab2x16(:,:,36))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(24),n2h4(24))
  call Hloop_AZ_Q(ntryL,G1H16(37),wf4(:,6),G1H4(1),ngZd,m3h4x4(:,25),heltab2x16(:,:,37))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(25),n2h4(25))
call HGT_OLR(G1H16(38),1,1,16)
call HGT_invQ_OLR(G1H16(38),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(38),-32,nMB,G2H16(10),n2h16(43))
  call Hloop_QA_V(ntryL,G2H16(10),ex6(:),G2H8(13),m3h2x8(:,13),heltab2x16(:,:,38))
  call Hloop_AZ_Q(ntryL,G1H16(40),wf4(:,6),G1H4(1),ngZd,m3h4x4(:,26),heltab2x16(:,:,39))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(26),n2h4(26))
  call Hloop_AZ_Q(ntryL,G1H16(41),wf4(:,6),G1H4(1),ngZd,m3h4x4(:,27),heltab2x16(:,:,40))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(27),n2h4(27))
  call Hloop_AZ_Q(ntryL,G1H16(42),wf4(:,6),G1H4(1),ngZd,m3h4x4(:,28),heltab2x16(:,:,41))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(28),n2h4(28))
  call Hloop_AS_Q(ntryL,G1H16(43),wf4(:,2),G1H4(1),ngH,m3h4x4(:,29),heltab2x16(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(29),n2h4(29))
call HGT_OLR(G1H16(44),1,1,16)
call HGT_invQ_OLR(G1H16(44),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(44),-32,nMB,G2H16(15),n2h16(44))
  call Hloop_QA_V(ntryL,G2H16(15),ex6(:),G2H8(14),m3h2x8(:,14),heltab2x16(:,:,43))
  call Hloop_AS_Q(ntryL,G1H16(46),wf4(:,2),G1H4(1),ngH,m3h4x4(:,30),heltab2x16(:,:,44))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(30),n2h4(30))
  call Hloop_AS_Q(ntryL,G1H16(47),wf4(:,2),G1H4(1),ngH,m3h4x4(:,31),heltab2x16(:,:,45))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(31),n2h4(31))
  call Hloop_AS_Q(ntryL,G1H16(48),wf4(:,2),G1H4(1),ngH,m3h4x4(:,32),heltab2x16(:,:,46))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(32),n2h4(32))
  call Hloop_AV_Q(ntryL,G1H16(49),wf4(:,7),G1H4(1),m3h4x4(:,33),heltab2x16(:,:,47))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(33),n2h4(33))
call HGT_OLR(G1H16(50),1,1,16)
call HGT_invQ_OLR(G1H16(50),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(50),-32,nMB,G2H16(13),n2h16(45))
  call Hloop_QA_V(ntryL,G2H16(13),ex6(:),G2H8(15),m3h2x8(:,15),heltab2x16(:,:,48))
  call Hloop_AV_Q(ntryL,G1H16(52),wf4(:,7),G1H4(1),m3h4x4(:,34),heltab2x16(:,:,49))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(34),n2h4(34))
  call Hloop_AV_Q(ntryL,G1H16(53),wf4(:,7),G1H4(1),m3h4x4(:,35),heltab2x16(:,:,50))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(35),n2h4(35))
  call Hloop_AV_Q(ntryL,G1H16(54),wf4(:,7),G1H4(1),m3h4x4(:,36),heltab2x16(:,:,51))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(36),n2h4(36))
  call Hloop_AZ_Q(ntryL,G1H16(55),wf4(:,9),G1H4(1),ngZd,m3h4x4(:,37),heltab2x16(:,:,52))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(37),n2h4(37))
call HGT_OLR(G1H16(56),1,1,16)
call HGT_invQ_OLR(G1H16(56),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(56),-32,nMB,G2H16(17),n2h16(46))
  call Hloop_QA_V(ntryL,G2H16(17),ex6(:),G2H8(16),m3h2x8(:,16),heltab2x16(:,:,53))
  call Hloop_AZ_Q(ntryL,G1H16(58),wf4(:,9),G1H4(1),ngZd,m3h4x4(:,38),heltab2x16(:,:,54))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(38),n2h4(38))
  call Hloop_AZ_Q(ntryL,G1H16(59),wf4(:,9),G1H4(1),ngZd,m3h4x4(:,39),heltab2x16(:,:,55))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(39),n2h4(39))
  call Hloop_AZ_Q(ntryL,G1H16(60),wf4(:,9),G1H4(1),ngZd,m3h4x4(:,40),heltab2x16(:,:,56))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(40),n2h4(40))
  call Hloop_QV_A(ntryL,G1H32(1),wf4(:,1),G1H8(1),m3h4x8(:,1),heltab2x32(:,:,1))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMB,G2H8(17),n2h8(1))
call HGT_raise_alpha_OLR(G1H32(2),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(2),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(2),ex6(:),G1H16(1),m3h2x16(:,1),heltab2x32(:,:,2))
  call Hloop_QV_A(ntryL,G1H32(4),wf4(:,1),G1H8(1),m3h4x8(:,2),heltab2x32(:,:,3))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMB,G2H8(18),n2h8(2))
  call Hloop_QV_A(ntryL,G1H32(5),wf4(:,1),G1H8(1),m3h4x8(:,3),heltab2x32(:,:,4))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMB,G2H8(19),n2h8(3))
  call Hloop_QV_A(ntryL,G1H32(6),wf4(:,1),G1H8(1),m3h4x8(:,4),heltab2x32(:,:,5))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMB,G2H8(20),n2h8(4))
  call Hloop_QZ_A(ntryL,G1H32(7),wf4(:,6),G1H8(1),ngZd,m3h4x8(:,5),heltab2x32(:,:,6))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMB,G2H8(21),n2h8(5))
call HGT_raise_alpha_OLR(G1H32(8),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(8),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(8),ex6(:),G1H16(2),m3h2x16(:,2),heltab2x32(:,:,7))
  call Hloop_QZ_A(ntryL,G1H32(10),wf4(:,6),G1H8(1),ngZd,m3h4x8(:,6),heltab2x32(:,:,8))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMB,G2H8(22),n2h8(6))
  call Hloop_QZ_A(ntryL,G1H32(11),wf4(:,6),G1H8(1),ngZd,m3h4x8(:,7),heltab2x32(:,:,9))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMB,G2H8(23),n2h8(7))
  call Hloop_QZ_A(ntryL,G1H32(12),wf4(:,6),G1H8(1),ngZd,m3h4x8(:,8),heltab2x32(:,:,10))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMB,G2H8(24),n2h8(8))
  call Hloop_QV_A(ntryL,G1H32(13),wf4(:,1),G1H8(1),m3h4x8(:,9),heltab2x32(:,:,11))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMB,G2H8(25),n2h8(9))
call HGT_raise_alpha_OLR(G1H32(14),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(14),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(14),ex6(:),G1H16(4),m3h2x16(:,3),heltab2x32(:,:,12))
  call Hloop_QV_A(ntryL,G1H32(16),wf4(:,1),G1H8(1),m3h4x8(:,10),heltab2x32(:,:,13))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMB,G2H8(26),n2h8(10))
  call Hloop_QV_A(ntryL,G1H32(17),wf4(:,1),G1H8(1),m3h4x8(:,11),heltab2x32(:,:,14))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMB,G2H8(27),n2h8(11))
  call Hloop_QV_A(ntryL,G1H32(18),wf4(:,1),G1H8(1),m3h4x8(:,12),heltab2x32(:,:,15))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMB,G2H8(28),n2h8(12))
  call Hloop_QV_A(ntryL,G1H32(19),wf4(:,1),G1H8(1),m3h4x8(:,13),heltab2x32(:,:,16))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMB,G2H8(29),n2h8(13))
call HGT_raise_alpha_OLR(G1H32(20),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(20),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(20),ex6(:),G1H16(5),m3h2x16(:,4),heltab2x32(:,:,17))
  call Hloop_QV_A(ntryL,G1H32(22),wf4(:,1),G1H8(1),m3h4x8(:,14),heltab2x32(:,:,18))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMB,G2H8(30),n2h8(14))
  call Hloop_QV_A(ntryL,G1H32(23),wf4(:,1),G1H8(1),m3h4x8(:,15),heltab2x32(:,:,19))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMB,G2H8(31),n2h8(15))
  call Hloop_QV_A(ntryL,G1H32(24),wf4(:,1),G1H8(1),m3h4x8(:,16),heltab2x32(:,:,20))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMB,G2H8(32),n2h8(16))
  call Hloop_QZ_A(ntryL,G1H32(25),wf4(:,6),G1H8(1),ngZd,m3h4x8(:,17),heltab2x32(:,:,21))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMB,G2H8(33),n2h8(17))
call HGT_raise_alpha_OLR(G1H32(26),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(26),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(26),ex6(:),G1H16(6),m3h2x16(:,5),heltab2x32(:,:,22))
  call Hloop_QZ_A(ntryL,G1H32(28),wf4(:,6),G1H8(1),ngZd,m3h4x8(:,18),heltab2x32(:,:,23))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMB,G2H8(34),n2h8(18))
  call Hloop_QZ_A(ntryL,G1H32(29),wf4(:,6),G1H8(1),ngZd,m3h4x8(:,19),heltab2x32(:,:,24))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMB,G2H8(35),n2h8(19))
  call Hloop_QZ_A(ntryL,G1H32(30),wf4(:,6),G1H8(1),ngZd,m3h4x8(:,20),heltab2x32(:,:,25))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMB,G2H8(36),n2h8(20))
  call Hloop_QZ_A(ntryL,G1H32(31),wf4(:,6),G1H8(1),ngZd,m3h4x8(:,21),heltab2x32(:,:,26))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMB,G2H8(37),n2h8(21))
call HGT_raise_alpha_OLR(G1H32(32),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(32),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(32),ex6(:),G1H16(7),m3h2x16(:,6),heltab2x32(:,:,27))
  call Hloop_QZ_A(ntryL,G1H32(34),wf4(:,6),G1H8(1),ngZd,m3h4x8(:,22),heltab2x32(:,:,28))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMB,G2H8(38),n2h8(22))
  call Hloop_QZ_A(ntryL,G1H32(35),wf4(:,6),G1H8(1),ngZd,m3h4x8(:,23),heltab2x32(:,:,29))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMB,G2H8(39),n2h8(23))
  call Hloop_QZ_A(ntryL,G1H32(36),wf4(:,6),G1H8(1),ngZd,m3h4x8(:,24),heltab2x32(:,:,30))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMB,G2H8(40),n2h8(24))
  call Hloop_QS_A(ntryL,G1H32(37),wf4(:,2),G1H8(1),ngH,m3h4x8(:,25),heltab2x32(:,:,31))
  call Hloop_Q_A(ntryL,G1H8(1),92,nMB,G2H8(41),n2h8(25))
call HGT_raise_alpha_OLR(G1H32(38),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(38),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(38),ex6(:),G1H16(8),m3h2x16(:,7),heltab2x32(:,:,32))
  call Hloop_QS_A(ntryL,G1H32(40),wf4(:,2),G1H8(1),ngH,m3h4x8(:,26),heltab2x32(:,:,33))
  call Hloop_Q_A(ntryL,G1H8(1),92,nMB,G2H8(42),n2h8(26))
  call Hloop_QS_A(ntryL,G1H32(41),wf4(:,2),G1H8(1),ngH,m3h4x8(:,27),heltab2x32(:,:,34))
  call Hloop_Q_A(ntryL,G1H8(1),92,nMB,G2H8(43),n2h8(27))
  call Hloop_QS_A(ntryL,G1H32(42),wf4(:,2),G1H8(1),ngH,m3h4x8(:,28),heltab2x32(:,:,35))
  call Hloop_Q_A(ntryL,G1H8(1),92,nMB,G2H8(44),n2h8(28))
  call Hloop_QS_A(ntryL,G1H32(43),wf4(:,2),G1H8(1),ngH,m3h4x8(:,29),heltab2x32(:,:,36))
  call Hloop_Q_A(ntryL,G1H8(1),92,nMB,G2H8(45),n2h8(29))
call HGT_raise_alpha_OLR(G1H32(44),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(44),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(44),ex6(:),G1H16(10),m3h2x16(:,8),heltab2x32(:,:,37))
  call Hloop_QS_A(ntryL,G1H32(46),wf4(:,2),G1H8(1),ngH,m3h4x8(:,30),heltab2x32(:,:,38))
  call Hloop_Q_A(ntryL,G1H8(1),92,nMB,G2H8(46),n2h8(30))
  call Hloop_QS_A(ntryL,G1H32(47),wf4(:,2),G1H8(1),ngH,m3h4x8(:,31),heltab2x32(:,:,39))
  call Hloop_Q_A(ntryL,G1H8(1),92,nMB,G2H8(47),n2h8(31))
  call Hloop_QS_A(ntryL,G1H32(48),wf4(:,2),G1H8(1),ngH,m3h4x8(:,32),heltab2x32(:,:,40))
  call Hloop_Q_A(ntryL,G1H8(1),92,nMB,G2H8(48),n2h8(32))
  call Hloop_QV_A(ntryL,G1H32(49),wf4(:,7),G1H8(1),m3h4x8(:,33),heltab2x32(:,:,41))
  call Hloop_Q_A(ntryL,G1H8(1),92,nMB,G2H8(49),n2h8(33))
call HGT_raise_alpha_OLR(G1H32(50),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(50),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(50),ex6(:),G1H16(11),m3h2x16(:,9),heltab2x32(:,:,42))
  call Hloop_QV_A(ntryL,G1H32(52),wf4(:,7),G1H8(1),m3h4x8(:,34),heltab2x32(:,:,43))
  call Hloop_Q_A(ntryL,G1H8(1),92,nMB,G2H8(50),n2h8(34))
  call Hloop_QV_A(ntryL,G1H32(53),wf4(:,7),G1H8(1),m3h4x8(:,35),heltab2x32(:,:,44))
  call Hloop_Q_A(ntryL,G1H8(1),92,nMB,G2H8(51),n2h8(35))
  call Hloop_QV_A(ntryL,G1H32(54),wf4(:,7),G1H8(1),m3h4x8(:,36),heltab2x32(:,:,45))
  call Hloop_Q_A(ntryL,G1H8(1),92,nMB,G2H8(52),n2h8(36))
  call Hloop_QZ_A(ntryL,G1H32(55),wf4(:,9),G1H8(1),ngZd,m3h4x8(:,37),heltab2x32(:,:,46))
  call Hloop_Q_A(ntryL,G1H8(1),92,nMB,G2H8(53),n2h8(37))
call HGT_raise_alpha_OLR(G1H32(56),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(56),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(56),ex6(:),G1H16(12),m3h2x16(:,10),heltab2x32(:,:,47))
  call Hloop_QZ_A(ntryL,G1H32(58),wf4(:,9),G1H8(1),ngZd,m3h4x8(:,38),heltab2x32(:,:,48))
  call Hloop_Q_A(ntryL,G1H8(1),92,nMB,G2H8(54),n2h8(38))
  call Hloop_QZ_A(ntryL,G1H32(59),wf4(:,9),G1H8(1),ngZd,m3h4x8(:,39),heltab2x32(:,:,49))
  call Hloop_Q_A(ntryL,G1H8(1),92,nMB,G2H8(55),n2h8(39))
  call Hloop_QZ_A(ntryL,G1H32(60),wf4(:,9),G1H8(1),ngZd,m3h4x8(:,40),heltab2x32(:,:,50))
  call Hloop_Q_A(ntryL,G1H8(1),92,nMB,G2H8(56),n2h8(40))
  call Hloop_QV_A(ntryL,G1H32(61),wf4(:,7),G1H8(1),m3h4x8(:,41),heltab2x32(:,:,51))
  call Hloop_Q_A(ntryL,G1H8(1),92,nMB,G2H8(57),n2h8(41))
call HGT_raise_alpha_OLR(G1H32(62),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(62),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(62),ex6(:),G1H16(13),m3h2x16(:,11),heltab2x32(:,:,52))
  call Hloop_QV_A(ntryL,G1H32(64),wf4(:,7),G1H8(1),m3h4x8(:,42),heltab2x32(:,:,53))
  call Hloop_Q_A(ntryL,G1H8(1),92,nMB,G2H8(58),n2h8(42))
  call Hloop_QV_A(ntryL,G1H32(65),wf4(:,7),G1H8(1),m3h4x8(:,43),heltab2x32(:,:,54))
  call Hloop_Q_A(ntryL,G1H8(1),92,nMB,G2H8(59),n2h8(43))
  call Hloop_QV_A(ntryL,G1H32(66),wf4(:,7),G1H8(1),m3h4x8(:,44),heltab2x32(:,:,55))
  call Hloop_Q_A(ntryL,G1H8(1),92,nMB,G2H8(60),n2h8(44))
  call Hloop_QZ_A(ntryL,G1H32(67),wf4(:,9),G1H8(1),ngZd,m3h4x8(:,45),heltab2x32(:,:,56))
  call Hloop_Q_A(ntryL,G1H8(1),92,nMB,G2H8(61),n2h8(45))
call HGT_raise_alpha_OLR(G1H32(68),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(68),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(68),ex6(:),G1H16(14),m3h2x16(:,12),heltab2x32(:,:,57))
  call Hloop_QZ_A(ntryL,G1H32(70),wf4(:,9),G1H8(1),ngZd,m3h4x8(:,46),heltab2x32(:,:,58))
  call Hloop_Q_A(ntryL,G1H8(1),92,nMB,G2H8(62),n2h8(46))
  call Hloop_QZ_A(ntryL,G1H32(71),wf4(:,9),G1H8(1),ngZd,m3h4x8(:,47),heltab2x32(:,:,59))
  call Hloop_Q_A(ntryL,G1H8(1),92,nMB,G2H8(63),n2h8(47))
  call Hloop_QZ_A(ntryL,G1H32(72),wf4(:,9),G1H8(1),ngZd,m3h4x8(:,48),heltab2x32(:,:,60))
  call Hloop_Q_A(ntryL,G1H8(1),92,nMB,G2H8(64),n2h8(48))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(5),[G2H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G2H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G2H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(17),[G2H4(13),G2H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(19),[G2H4(15),G2H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(20),[G2H4(16),G2H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(25),[G2H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(27),[G2H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(28),[G2H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(37),[G2H4(33),G2H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(39),[G2H4(35),G2H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(40),[G2H4(36),G2H4(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(21),[G2H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(23),[G2H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(24),[G2H8(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(33),[G2H8(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(35),[G2H8(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(36),[G2H8(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(37),[G2H8(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(39),[G2H8(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(40),[G2H8(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(53),[G2H8(49),G2H8(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(55),[G2H8(51),G2H8(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(56),[G2H8(52),G2H8(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(61),[G2H8(57),G2H8(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(63),[G2H8(59),G2H8(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(64),[G2H8(60),G2H8(48)])
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(7),mass5set(:,3),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),G1H8(6),8)
  call HG1shiftOLR(G1H8(2),12,8)
  call Hotf_5pt_reduction(G2H8(2),RedSet_5(7),mass5set(:,3),  & 
G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),G1H8(12),8)
  call HG1shiftOLR(G1H8(8),12,8)
  call Hotf_5pt_reduction(G2H8(3),RedSet_5(7),mass5set(:,3),  & 
G1H8(13),G1H8(14),G1H8(15),G1H8(16),G1H8(17),G1H8(18),8)
  call HG1shiftOLR(G1H8(14),12,8)
  call Hotf_5pt_reduction(G2H8(4),RedSet_5(8),mass5set(:,3),  & 
G1H8(19),G1H8(20),G1H8(21),G1H8(22),G1H8(23),G1H8(24),8)
  call HG1shiftOLR(G1H8(20),12,8)
  call Hotf_5pt_reduction(G2H8(5),RedSet_5(8),mass5set(:,3),  & 
G1H8(25),G1H8(26),G1H8(27),G1H8(28),G1H8(29),G1H8(30),8)
  call HG1shiftOLR(G1H8(26),12,8)
  call Hotf_5pt_reduction(G2H8(6),RedSet_5(8),mass5set(:,3),  & 
G1H8(31),G1H8(32),G1H8(33),G1H8(34),G1H8(35),G1H8(36),8)
  call HG1shiftOLR(G1H8(32),12,8)
  call Hloop_QA_V(ntryL,G2H4(5),ex6(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_V(ntryL,G2H4(7),ex6(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_V(ntryL,G2H4(8),ex6(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_V(ntryL,G2H4(17),ex6(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_QA_V(ntryL,G2H4(19),ex6(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QA_V(ntryL,G2H4(20),ex6(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_AQ_V(ntryL,G2H4(25),ex5(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_V(ntryL,G2H4(27),ex5(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_AQ_V(ntryL,G2H4(28),ex5(:),G2H2(9),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_AQ_V(ntryL,G2H4(37),ex5(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_AQ_V(ntryL,G2H4(39),ex5(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_AQ_V(ntryL,G2H4(40),ex5(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hotf_5pt_reduction(G2H8(21),RedSet_5(5),mass5set(:,2),  & 
G1H8(37),G1H8(38),G1H8(39),G1H8(40),G1H8(41),G1H8(42),8)
  call HG1shiftOLR(G1H8(38),32,8)
  call Hotf_4pt_reduction(G2H8(23),RedSet_4(1),mass4set(:,1),  & 
G1H8(43),G1H8(44),G1H8(45),G1H8(46),G1H8(47),8)
  call HG1shiftOLR(G1H8(44),32,8)
  call Hotf_4pt_reduction(G2H8(24),RedSet_4(2),mass4set(:,1),  & 
G1H8(48),G1H8(49),G1H8(50),G1H8(51),G1H8(52),8)
  call HG1shiftOLR(G1H8(49),44,8)
  call Hotf_5pt_reduction(G2H8(33),RedSet_5(5),mass5set(:,2),  & 
G1H8(53),G1H8(54),G1H8(55),G1H8(56),G1H8(57),G1H8(58),8)
  call HG1shiftOLR(G1H8(54),32,8)
  call Hotf_4pt_reduction(G2H8(35),RedSet_4(1),mass4set(:,1),  & 
G1H8(59),G1H8(60),G1H8(61),G1H8(62),G1H8(63),8)
  call HG1shiftOLR(G1H8(60),32,8)
  call Hotf_4pt_reduction(G2H8(36),RedSet_4(2),mass4set(:,1),  & 
G1H8(64),G1H8(65),G1H8(66),G1H8(67),G1H8(68),8)
  call HG1shiftOLR(G1H8(65),44,8)
  call Hotf_5pt_reduction(G2H8(37),RedSet_5(5),mass5set(:,2),  & 
G1H8(69),G1H8(70),G1H8(71),G1H8(72),G1H8(73),G1H8(74),8)
  call HG1shiftOLR(G1H8(70),32,8)
  call Hotf_4pt_reduction(G2H8(39),RedSet_4(1),mass4set(:,1),  & 
G1H8(75),G1H8(76),G1H8(77),G1H8(78),G1H8(79),8)
  call HG1shiftOLR(G1H8(76),32,8)
  call Hotf_4pt_reduction(G2H8(40),RedSet_4(2),mass4set(:,1),  & 
G1H8(80),G1H8(81),G1H8(82),G1H8(83),G1H8(84),8)
  call HG1shiftOLR(G1H8(81),44,8)
  call Hotf_5pt_reduction(G2H8(53),RedSet_5(6),mass5set(:,2),  & 
G1H8(85),G1H8(86),G1H8(87),G1H8(88),G1H8(89),G1H8(90),8)
  call HG1shiftOLR(G1H8(86),32,8)
  call Hotf_4pt_reduction(G2H8(55),RedSet_4(1),mass4set(:,1),  & 
G1H8(91),G1H8(92),G1H8(93),G1H8(94),G1H8(95),8)
  call HG1shiftOLR(G1H8(92),32,8)
  call Hotf_4pt_reduction(G2H8(56),RedSet_4(3),mass4set(:,1),  & 
G1H8(96),G1H8(97),G1H8(98),G1H8(99),G1H8(100),8)
  call HG1shiftOLR(G1H8(97),35,8)
  call Hotf_5pt_reduction(G2H8(61),RedSet_5(6),mass5set(:,2),  & 
G1H8(101),G1H8(102),G1H8(103),G1H8(104),G1H8(105),G1H8(106),8)
  call HG1shiftOLR(G1H8(102),32,8)
  call Hotf_4pt_reduction(G2H8(63),RedSet_4(1),mass4set(:,1),  & 
G1H8(107),G1H8(108),G1H8(109),G1H8(110),G1H8(111),8)
  call HG1shiftOLR(G1H8(108),32,8)
  call Hotf_4pt_reduction(G2H8(64),RedSet_4(3),mass4set(:,1),  & 
G1H8(112),G1H8(113),G1H8(114),G1H8(115),G1H8(116),8)
  call HG1shiftOLR(G1H8(113),35,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(43),[G1H8(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(48),[G1H8(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(59),[G1H8(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(64),[G1H8(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(75),[G1H8(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(80),[G1H8(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(91),[G1H8(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(96),[G1H8(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(107),[G1H8(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(112),[G1H8(106)])
  call Hloop_VA_Q(ntryL,G1H8(1),ex6(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_A_Q(ntryL,G1H4(1),115,nMB,G2H4(1),n2h4(41))
call HGT_OLR(G1H8(2),1,1,8)
call HGT_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(2),-12,nMB,G2H8(17),n2h8(49))
  call Hloop_QS_A(ntryL,G2H8(17),wf4(:,2),G2H2(13),ngH,m3h4x2(:,1),heltab2x8(:,:,2))
  call Hloop_VA_Q(ntryL,G1H8(5),ex6(:),G1H4(1),m3h2x4(:,2),heltab2x8(:,:,3))
  call Hloop_A_Q(ntryL,G1H4(1),115,nMB,G2H4(3),n2h4(42))
  call Hloop_VA_Q(ntryL,G1H8(6),ex6(:),G1H4(1),m3h2x4(:,3),heltab2x8(:,:,4))
  call Hloop_A_Q(ntryL,G1H4(1),115,nMB,G2H4(4),n2h4(43))
  call Hloop_VA_Q(ntryL,G1H8(7),ex6(:),G1H4(1),m3h2x4(:,4),heltab2x8(:,:,5))
  call Hloop_A_Q(ntryL,G1H4(1),115,nMB,G2H4(13),n2h4(44))
call HGT_OLR(G1H8(8),1,1,8)
call HGT_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(8),-12,nMB,G2H8(19),n2h8(50))
  call Hloop_QV_A(ntryL,G2H8(19),wf4(:,7),G2H2(14),m3h4x2(:,2),heltab2x8(:,:,6))
  call Hloop_VA_Q(ntryL,G1H8(11),ex6(:),G1H4(1),m3h2x4(:,5),heltab2x8(:,:,7))
  call Hloop_A_Q(ntryL,G1H4(1),115,nMB,G2H4(9),n2h4(45))
  call Hloop_VA_Q(ntryL,G1H8(12),ex6(:),G1H4(1),m3h2x4(:,6),heltab2x8(:,:,8))
  call Hloop_A_Q(ntryL,G1H4(1),115,nMB,G2H4(15),n2h4(46))
  call Hloop_VA_Q(ntryL,G1H8(13),ex6(:),G1H4(1),m3h2x4(:,7),heltab2x8(:,:,9))
  call Hloop_A_Q(ntryL,G1H4(1),115,nMB,G2H4(11),n2h4(47))
call HGT_OLR(G1H8(14),1,1,8)
call HGT_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(14),-12,nMB,G2H8(20),n2h8(51))
  call Hloop_QZ_A(ntryL,G2H8(20),wf4(:,9),G2H2(15),ngZd,m3h4x2(:,3),heltab2x8(:,:,10))
  call Hloop_VA_Q(ntryL,G1H8(17),ex6(:),G1H4(1),m3h2x4(:,8),heltab2x8(:,:,11))
  call Hloop_A_Q(ntryL,G1H4(1),115,nMB,G2H4(16),n2h4(48))
  call Hloop_VA_Q(ntryL,G1H8(18),ex6(:),G1H4(1),m3h2x4(:,9),heltab2x8(:,:,12))
  call Hloop_A_Q(ntryL,G1H4(1),115,nMB,G2H4(12),n2h4(49))
  call Hloop_VQ_A(ntryL,G1H8(19),ex5(:),G1H4(1),m3h2x4(:,10),heltab2x8(:,:,13))
  call Hloop_Q_A(ntryL,G1H4(1),115,nMB,G2H4(21),n2h4(50))
call HGT_OLR(G1H8(20),1,1,8)
call HGT_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(20),-12,nMB,G2H8(25),n2h8(52))
  call Hloop_AS_Q(ntryL,G2H8(25),wf4(:,2),G2H2(16),ngH,m3h4x2(:,4),heltab2x8(:,:,14))
  call Hloop_VQ_A(ntryL,G1H8(23),ex5(:),G1H4(1),m3h2x4(:,11),heltab2x8(:,:,15))
  call Hloop_Q_A(ntryL,G1H4(1),115,nMB,G2H4(23),n2h4(51))
  call Hloop_VQ_A(ntryL,G1H8(24),ex5(:),G1H4(1),m3h2x4(:,12),heltab2x8(:,:,16))
  call Hloop_Q_A(ntryL,G1H4(1),115,nMB,G2H4(24),n2h4(52))
  call Hloop_VQ_A(ntryL,G1H8(25),ex5(:),G1H4(1),m3h2x4(:,13),heltab2x8(:,:,17))
  call Hloop_Q_A(ntryL,G1H4(1),115,nMB,G2H4(33),n2h4(53))
call HGT_OLR(G1H8(26),1,1,8)
call HGT_invQ_OLR(G1H8(26),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(26),-12,nMB,G2H8(27),n2h8(53))
  call Hloop_AV_Q(ntryL,G2H8(27),wf4(:,7),G2H2(17),m3h4x2(:,5),heltab2x8(:,:,18))
  call Hloop_VQ_A(ntryL,G1H8(29),ex5(:),G1H4(1),m3h2x4(:,14),heltab2x8(:,:,19))
  call Hloop_Q_A(ntryL,G1H4(1),115,nMB,G2H4(29),n2h4(54))
  call Hloop_VQ_A(ntryL,G1H8(30),ex5(:),G1H4(1),m3h2x4(:,15),heltab2x8(:,:,20))
  call Hloop_Q_A(ntryL,G1H4(1),115,nMB,G2H4(35),n2h4(55))
  call Hloop_VQ_A(ntryL,G1H8(31),ex5(:),G1H4(1),m3h2x4(:,16),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G1H4(1),115,nMB,G2H4(31),n2h4(56))
call HGT_OLR(G1H8(32),1,1,8)
call HGT_invQ_OLR(G1H8(32),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(32),-12,nMB,G2H8(28),n2h8(54))
  call Hloop_AZ_Q(ntryL,G2H8(28),wf4(:,9),G2H2(18),ngZd,m3h4x2(:,6),heltab2x8(:,:,22))
  call Hloop_VQ_A(ntryL,G1H8(35),ex5(:),G1H4(1),m3h2x4(:,17),heltab2x8(:,:,23))
  call Hloop_Q_A(ntryL,G1H4(1),115,nMB,G2H4(36),n2h4(57))
  call Hloop_VQ_A(ntryL,G1H8(36),ex5(:),G1H4(1),m3h2x4(:,18),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G1H4(1),115,nMB,G2H4(32),n2h4(58))
  call Hloop_QS_A(ntryL,G1H8(37),wf4(:,2),G1H2(1),ngH,m3h4x2(:,7),heltab2x8(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(19),n2h2(1))
call HGT_raise_alpha_OLR(G1H8(38),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(38),ex6(:),G1H4(1),m3h2x4(:,19),heltab2x8(:,:,26))
  call Hloop_QS_A(ntryL,G1H8(43),wf4(:,2),G1H2(1),ngH,m3h4x2(:,8),heltab2x8(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(20),n2h2(2))
  call Hloop_QS_A(ntryL,G1H8(48),wf4(:,2),G1H2(1),ngH,m3h4x2(:,9),heltab2x8(:,:,28))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(21),n2h2(3))
call HGT_raise_alpha_OLR(G1H8(44),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(44),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(44),ex6(:),G1H4(2),m3h2x4(:,20),heltab2x8(:,:,29))
  call Hloop_QS_A(ntryL,G1H8(47),wf4(:,2),G1H2(1),ngH,m3h4x2(:,10),heltab2x8(:,:,30))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(22),n2h2(4))
call HGT_raise_alpha_OLR(G1H8(49),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(49),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(49),ex6(:),G1H4(3),m3h2x4(:,21),heltab2x8(:,:,31))
  call Hloop_QS_A(ntryL,G1H8(52),wf4(:,2),G1H2(1),ngH,m3h4x2(:,11),heltab2x8(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(23),n2h2(5))
  call Hloop_QV_A(ntryL,G1H8(53),wf4(:,7),G1H2(1),m3h4x2(:,12),heltab2x8(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(24),n2h2(6))
call HGT_raise_alpha_OLR(G1H8(54),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(54),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(54),ex6(:),G1H4(4),m3h2x4(:,22),heltab2x8(:,:,34))
  call Hloop_QV_A(ntryL,G1H8(59),wf4(:,7),G1H2(1),m3h4x2(:,13),heltab2x8(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(25),n2h2(7))
  call Hloop_QV_A(ntryL,G1H8(64),wf4(:,7),G1H2(1),m3h4x2(:,14),heltab2x8(:,:,36))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(26),n2h2(8))
call HGT_raise_alpha_OLR(G1H8(60),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(60),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(60),ex6(:),G1H4(5),m3h2x4(:,23),heltab2x8(:,:,37))
  call Hloop_QV_A(ntryL,G1H8(63),wf4(:,7),G1H2(1),m3h4x2(:,15),heltab2x8(:,:,38))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(27),n2h2(9))
call HGT_raise_alpha_OLR(G1H8(65),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(65),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(65),ex6(:),G1H4(6),m3h2x4(:,24),heltab2x8(:,:,39))
  call Hloop_QV_A(ntryL,G1H8(68),wf4(:,7),G1H2(1),m3h4x2(:,16),heltab2x8(:,:,40))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(28),n2h2(10))
  call Hloop_QZ_A(ntryL,G1H8(69),wf4(:,9),G1H2(1),ngZd,m3h4x2(:,17),heltab2x8(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(29),n2h2(11))
call HGT_raise_alpha_OLR(G1H8(70),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(70),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(70),ex6(:),G1H4(7),m3h2x4(:,25),heltab2x8(:,:,42))
  call Hloop_QZ_A(ntryL,G1H8(75),wf4(:,9),G1H2(1),ngZd,m3h4x2(:,18),heltab2x8(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(30),n2h2(12))
  call Hloop_QZ_A(ntryL,G1H8(80),wf4(:,9),G1H2(1),ngZd,m3h4x2(:,19),heltab2x8(:,:,44))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(31),n2h2(13))
call HGT_raise_alpha_OLR(G1H8(76),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(76),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(76),ex6(:),G1H4(8),m3h2x4(:,26),heltab2x8(:,:,45))
  call Hloop_QZ_A(ntryL,G1H8(79),wf4(:,9),G1H2(1),ngZd,m3h4x2(:,20),heltab2x8(:,:,46))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(32),n2h2(14))
call HGT_raise_alpha_OLR(G1H8(81),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(81),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(81),ex6(:),G1H4(9),m3h2x4(:,27),heltab2x8(:,:,47))
  call Hloop_QZ_A(ntryL,G1H8(84),wf4(:,9),G1H2(1),ngZd,m3h4x2(:,21),heltab2x8(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(33),n2h2(15))
  call Hloop_QV_A(ntryL,G1H8(85),wf4(:,1),G1H2(1),m3h4x2(:,22),heltab2x8(:,:,49))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(34),n2h2(16))
call HGT_raise_alpha_OLR(G1H8(86),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(86),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(86),ex6(:),G1H4(10),m3h2x4(:,28),heltab2x8(:,:,50))
  call Hloop_QV_A(ntryL,G1H8(91),wf4(:,1),G1H2(1),m3h4x2(:,23),heltab2x8(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(35),n2h2(17))
  call Hloop_QV_A(ntryL,G1H8(96),wf4(:,1),G1H2(1),m3h4x2(:,24),heltab2x8(:,:,52))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(36),n2h2(18))
call HGT_raise_alpha_OLR(G1H8(92),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(92),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(92),ex6(:),G1H4(11),m3h2x4(:,29),heltab2x8(:,:,53))
  call Hloop_QV_A(ntryL,G1H8(95),wf4(:,1),G1H2(1),m3h4x2(:,25),heltab2x8(:,:,54))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(37),n2h2(19))
call HGT_raise_alpha_OLR(G1H8(97),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(97),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(97),ex6(:),G1H4(12),m3h2x4(:,30),heltab2x8(:,:,55))
  call Hloop_QV_A(ntryL,G1H8(100),wf4(:,1),G1H2(1),m3h4x2(:,26),heltab2x8(:,:,56))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(38),n2h2(20))
  call Hloop_QZ_A(ntryL,G1H8(101),wf4(:,6),G1H2(1),ngZd,m3h4x2(:,27),heltab2x8(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(39),n2h2(21))
call HGT_raise_alpha_OLR(G1H8(102),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(102),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(102),ex6(:),G1H4(13),m3h2x4(:,31),heltab2x8(:,:,58))
  call Hloop_QZ_A(ntryL,G1H8(107),wf4(:,6),G1H2(1),ngZd,m3h4x2(:,28),heltab2x8(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(40),n2h2(22))
  call Hloop_QZ_A(ntryL,G1H8(112),wf4(:,6),G1H2(1),ngZd,m3h4x2(:,29),heltab2x8(:,:,60))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(41),n2h2(23))
call HGT_raise_alpha_OLR(G1H8(108),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(108),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(108),ex6(:),G1H4(14),m3h2x4(:,32),heltab2x8(:,:,61))
  call Hloop_QZ_A(ntryL,G1H8(111),wf4(:,6),G1H2(1),ngZd,m3h4x2(:,30),heltab2x8(:,:,62))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(42),n2h2(24))
call HGT_raise_alpha_OLR(G1H8(113),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(113),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(113),ex6(:),G1H4(15),m3h2x4(:,33),heltab2x8(:,:,63))
  call Hloop_QZ_A(ntryL,G1H8(116),wf4(:,6),G1H2(1),ngZd,m3h4x2(:,31),heltab2x8(:,:,64))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(43),n2h2(25))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G2H2(24),G2H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(31),[G2H2(26),G2H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(39),[G2H2(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(41),[G2H2(36)])
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(2),16,2)
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(4),mass4set(:,2),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),2)
  call HG1shiftOLR(G1H2(8),48,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(2),mass5set(:,1),  & 
G1H2(12),G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),2)
  call HG1shiftOLR(G1H2(13),16,2)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(5),mass4set(:,2),  & 
G1H2(18),G1H2(19),G1H2(20),G1H2(21),G1H2(22),2)
  call HG1shiftOLR(G1H2(19),48,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(3),mass5set(:,1),  & 
G1H2(23),G1H2(24),G1H2(25),G1H2(26),G1H2(27),G1H2(28),2)
  call HG1shiftOLR(G1H2(24),32,2)
  call Hotf_4pt_reduction(G2H2(9),RedSet_4(4),mass4set(:,2),  & 
G1H2(29),G1H2(30),G1H2(31),G1H2(32),G1H2(33),2)
  call HG1shiftOLR(G1H2(30),48,2)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(4),mass5set(:,1),  & 
G1H2(34),G1H2(35),G1H2(36),G1H2(37),G1H2(38),G1H2(39),2)
  call HG1shiftOLR(G1H2(35),32,2)
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(5),mass4set(:,2),  & 
G1H2(40),G1H2(41),G1H2(42),G1H2(43),G1H2(44),2)
  call HG1shiftOLR(G1H2(41),48,2)
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(7),mass5set(:,3),  & 
G1H4(16),G1H4(17),G1H4(18),G1H4(19),G1H4(20),G1H4(21),4)
  call HG1shiftOLR(G1H4(17),12,4)
  call Hotf_4pt_reduction(G2H4(4),RedSet_4(6),mass4set(:,3),  & 
G1H4(22),G1H4(23),G1H4(24),G1H4(25),G1H4(26),4)
  call HG1shiftOLR(G1H4(23),44,4)
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(7),mass5set(:,3),  & 
G1H4(27),G1H4(28),G1H4(29),G1H4(30),G1H4(31),G1H4(32),4)
  call HG1shiftOLR(G1H4(28),12,4)
  call Hotf_4pt_reduction(G2H4(15),RedSet_4(6),mass4set(:,3),  & 
G1H4(33),G1H4(34),G1H4(35),G1H4(36),G1H4(37),4)
  call HG1shiftOLR(G1H4(34),44,4)
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(7),mass5set(:,3),  & 
G1H4(38),G1H4(39),G1H4(40),G1H4(41),G1H4(42),G1H4(43),4)
  call HG1shiftOLR(G1H4(39),12,4)
  call Hotf_4pt_reduction(G2H4(12),RedSet_4(6),mass4set(:,3),  & 
G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
  call HG1shiftOLR(G1H4(45),44,4)
  call Hotf_5pt_reduction(G2H4(21),RedSet_5(8),mass5set(:,3),  & 
G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),G1H4(54),4)
  call HG1shiftOLR(G1H4(50),12,4)
  call Hotf_4pt_reduction(G2H4(24),RedSet_4(7),mass4set(:,3),  & 
G1H4(55),G1H4(56),G1H4(57),G1H4(58),G1H4(59),4)
  call HG1shiftOLR(G1H4(56),28,4)
  call Hotf_5pt_reduction(G2H4(33),RedSet_5(8),mass5set(:,3),  & 
G1H4(60),G1H4(61),G1H4(62),G1H4(63),G1H4(64),G1H4(65),4)
  call HG1shiftOLR(G1H4(61),12,4)
  call Hotf_4pt_reduction(G2H4(35),RedSet_4(7),mass4set(:,3),  & 
G1H4(66),G1H4(67),G1H4(68),G1H4(69),G1H4(70),4)
  call HG1shiftOLR(G1H4(67),28,4)
  call Hotf_5pt_reduction(G2H4(31),RedSet_5(8),mass5set(:,3),  & 
G1H4(71),G1H4(72),G1H4(73),G1H4(74),G1H4(75),G1H4(76),4)
  call HG1shiftOLR(G1H4(72),12,4)
  call Hotf_4pt_reduction(G2H4(32),RedSet_4(7),mass4set(:,3),  & 
G1H4(77),G1H4(78),G1H4(79),G1H4(80),G1H4(81),4)
  call HG1shiftOLR(G1H4(78),28,4)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(29),ex6(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(31),ex6(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(39),ex6(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(41),ex6(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(7),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(18),[G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(29),[G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(40),[G1H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(22),[G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(33),[G1H4(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(44),[G1H4(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(55),[G1H4(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(66),[G1H4(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(77),[G1H4(76)])
  call Hloop_VQ_A(ntryL,G1H2(1),ex5(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(5),n2h1(1))
  call Hloop_VQ_A(ntryL,G1H2(2),ex5(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(6),n2h1(2))
  call Hloop_VQ_A(ntryL,G1H2(7),ex5(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(7),n2h1(3))
  call Hloop_VQ_A(ntryL,G1H2(8),ex5(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,nMB,G2tensor(8),n2h1(4))
  call Hloop_VQ_A(ntryL,G1H2(12),ex5(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(9),n2h1(5))
  call Hloop_VQ_A(ntryL,G1H2(13),ex5(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(10),n2h1(6))
  call Hloop_VQ_A(ntryL,G1H2(18),ex5(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(11),n2h1(7))
  call Hloop_VQ_A(ntryL,G1H2(19),ex5(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,nMB,G2tensor(12),n2h1(8))
  call Hloop_VA_Q(ntryL,G1H2(23),ex6(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(13),n2h1(9))
  call Hloop_VA_Q(ntryL,G1H2(24),ex6(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,nMB,G2tensor(14),n2h1(10))
  call Hloop_VA_Q(ntryL,G1H2(29),ex6(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(15),n2h1(11))
  call Hloop_VA_Q(ntryL,G1H2(30),ex6(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,nMB,G2tensor(16),n2h1(12))
  call Hloop_VA_Q(ntryL,G1H2(34),ex6(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(17),n2h1(13))
  call Hloop_VA_Q(ntryL,G1H2(35),ex6(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,nMB,G2tensor(18),n2h1(14))
  call Hloop_VA_Q(ntryL,G1H2(40),ex6(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(19),n2h1(15))
  call Hloop_VA_Q(ntryL,G1H2(41),ex6(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,nMB,G2tensor(20),n2h1(16))
  call Hloop_AS_Q(ntryL,G1H4(16),wf4(:,2),G1H1(1),ngH,m3h4x1(:,1),heltab2x4(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(21),n2h1(17))
  call Hloop_AS_Q(ntryL,G1H4(17),wf4(:,2),G1H1(1),ngH,m3h4x1(:,2),heltab2x4(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(22),n2h1(18))
  call Hloop_AS_Q(ntryL,G1H4(22),wf4(:,2),G1H1(1),ngH,m3h4x1(:,3),heltab2x4(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(23),n2h1(19))
  call Hloop_AS_Q(ntryL,G1H4(23),wf4(:,2),G1H1(1),ngH,m3h4x1(:,4),heltab2x4(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),44,nMB,G2tensor(24),n2h1(20))
  call Hloop_AV_Q(ntryL,G1H4(27),wf4(:,7),G1H1(1),m3h4x1(:,5),heltab2x4(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(25),n2h1(21))
  call Hloop_AV_Q(ntryL,G1H4(28),wf4(:,7),G1H1(1),m3h4x1(:,6),heltab2x4(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(26),n2h1(22))
  call Hloop_AV_Q(ntryL,G1H4(33),wf4(:,7),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(27),n2h1(23))
  call Hloop_AV_Q(ntryL,G1H4(34),wf4(:,7),G1H1(1),m3h4x1(:,8),heltab2x4(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),44,nMB,G2tensor(28),n2h1(24))
  call Hloop_AZ_Q(ntryL,G1H4(38),wf4(:,9),G1H1(1),ngZd,m3h4x1(:,9),heltab2x4(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(29),n2h1(25))
  call Hloop_AZ_Q(ntryL,G1H4(39),wf4(:,9),G1H1(1),ngZd,m3h4x1(:,10),heltab2x4(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(30),n2h1(26))
  call Hloop_AZ_Q(ntryL,G1H4(44),wf4(:,9),G1H1(1),ngZd,m3h4x1(:,11),heltab2x4(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(31),n2h1(27))
  call Hloop_AZ_Q(ntryL,G1H4(45),wf4(:,9),G1H1(1),ngZd,m3h4x1(:,12),heltab2x4(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),44,nMB,G2tensor(32),n2h1(28))
  call Hloop_QS_A(ntryL,G1H4(49),wf4(:,2),G1H1(1),ngH,m3h4x1(:,13),heltab2x4(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(33),n2h1(29))
  call Hloop_QS_A(ntryL,G1H4(50),wf4(:,2),G1H1(1),ngH,m3h4x1(:,14),heltab2x4(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(34),n2h1(30))
  call Hloop_QS_A(ntryL,G1H4(55),wf4(:,2),G1H1(1),ngH,m3h4x1(:,15),heltab2x4(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(35),n2h1(31))
  call Hloop_QS_A(ntryL,G1H4(56),wf4(:,2),G1H1(1),ngH,m3h4x1(:,16),heltab2x4(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),28,nMB,G2tensor(36),n2h1(32))
  call Hloop_QV_A(ntryL,G1H4(60),wf4(:,7),G1H1(1),m3h4x1(:,17),heltab2x4(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(37),n2h1(33))
  call Hloop_QV_A(ntryL,G1H4(61),wf4(:,7),G1H1(1),m3h4x1(:,18),heltab2x4(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(38),n2h1(34))
  call Hloop_QV_A(ntryL,G1H4(66),wf4(:,7),G1H1(1),m3h4x1(:,19),heltab2x4(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(39),n2h1(35))
  call Hloop_QV_A(ntryL,G1H4(67),wf4(:,7),G1H1(1),m3h4x1(:,20),heltab2x4(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),28,nMB,G2tensor(40),n2h1(36))
  call Hloop_QZ_A(ntryL,G1H4(71),wf4(:,9),G1H1(1),ngZd,m3h4x1(:,21),heltab2x4(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(41),n2h1(37))
  call Hloop_QZ_A(ntryL,G1H4(72),wf4(:,9),G1H1(1),ngZd,m3h4x1(:,22),heltab2x4(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(42),n2h1(38))
  call Hloop_QZ_A(ntryL,G1H4(77),wf4(:,9),G1H1(1),ngZd,m3h4x1(:,23),heltab2x4(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(43),n2h1(39))
  call Hloop_QZ_A(ntryL,G1H4(78),wf4(:,9),G1H1(1),ngZd,m3h4x1(:,24),heltab2x4(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),28,nMB,G2tensor(44),n2h1(40))
  call ol_merge_tensors(G2tensor(29),[G2tensor(25),G2tensor(21)])
  call ol_merge_tensors(G2tensor(41),[G2tensor(37),G2tensor(33)])
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(5),mass5set(:,2),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),32)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(6),mass5set(:,2),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),32)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(1),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),16)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(2),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),16)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(3),mass5set(:,1),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),32)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(4),mass5set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),32)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(7),mass5set(:,3),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),12)
  call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(8),mass5set(:,3),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),12)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(489)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(49),h0tab(:,49),[64,3,48,12],[nMT,nMT,nMT,nMT],4,3,wf4(:,1),wf4(:,12) &
    ,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,49),heltab2x128(:,:,49))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(1),n2h64(37))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(489)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(50),h0tab(:,50),[64,3,48,12],[nMT,nMT,nMT,nMT],4,3,wf4(:,1),wf4(:,12) &
    ,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,50),heltab2x128(:,:,50))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(2),n2h64(38))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(489)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(51),h0tab(:,51),[64,3,48,12],[nMB,nMB,nMB,nMB],4,3,wf4(:,1),wf4(:,12) &
    ,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,51),heltab2x128(:,:,51))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(3),n2h64(39))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(489)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(52),h0tab(:,52),[64,3,48,12],[nMB,nMB,nMB,nMB],4,3,wf4(:,1),wf4(:,12) &
    ,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,52),heltab2x128(:,:,52))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(4),n2h64(40))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(490)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(53),h0tab(:,53),[64,3,48,12],[nMT,nMT,nMT,nMT],4,3,wf4(:,6),wf4(:,12) &
    ,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,53),heltab2x128(:,:,53))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(5),n2h64(41))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(490)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(54),h0tab(:,54),[64,3,48,12],[nMT,nMT,nMT,nMT],4,3,wf4(:,6),wf4(:,12) &
    ,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,54),heltab2x128(:,:,54))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(6),n2h64(42))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(490)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(55),h0tab(:,55),[64,3,48,12],[nMB,nMB,nMB,nMB],4,3,wf4(:,6),wf4(:,12) &
    ,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,55),heltab2x128(:,:,55))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(7),n2h64(43))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(490)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(56),h0tab(:,56),[64,3,48,12],[nMB,nMB,nMB,nMB],4,3,wf4(:,6),wf4(:,12) &
    ,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,56),heltab2x128(:,:,56))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(8),n2h64(44))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(491)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(57),h0tab(:,57),[64,3,48,12],[0,0,0,0],4,3,wf4(:,1),wf4(:,12),wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,57),heltab2x128(:,:,57))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(9),n2h64(45))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(491)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(58),h0tab(:,58),[64,3,48,12],[nMT,nMT,nMT,nMT],4,3,wf4(:,1),wf4(:,12) &
    ,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,58),heltab2x128(:,:,58))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(10),n2h64(46))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(491)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(59),h0tab(:,59),[64,3,48,12],[0,0,0,0],4,3,wf4(:,1),wf4(:,12),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,59),heltab2x128(:,:,59))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(11),n2h64(47))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(491)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(60),h0tab(:,60),[64,3,48,12],[nMT,nMT,nMT,nMT],4,3,wf4(:,1),wf4(:,12) &
    ,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,60),heltab2x128(:,:,60))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(12),n2h64(48))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(491)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(61),h0tab(:,61),[64,3,48,12],[0,0,0,0],4,3,wf4(:,1),wf4(:,12),wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,61),heltab2x128(:,:,61))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(13),n2h64(49))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(491)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(62),h0tab(:,62),[64,3,48,12],[nMB,nMB,nMB,nMB],4,3,wf4(:,1),wf4(:,12) &
    ,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,62),heltab2x128(:,:,62))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(14),n2h64(50))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(491)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(63),h0tab(:,63),[64,3,48,12],[0,0,0,0],4,3,wf4(:,1),wf4(:,12),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,63),heltab2x128(:,:,63))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(15),n2h64(51))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(491)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(64),h0tab(:,64),[64,3,48,12],[nMB,nMB,nMB,nMB],4,3,wf4(:,1),wf4(:,12) &
    ,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,64),heltab2x128(:,:,64))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(16),n2h64(52))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(492)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(65),h0tab(:,65),[64,3,48,12],[0,0,0,0],4,3,wf4(:,1),wf4(:,12),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,65),heltab2x128(:,:,65))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(17),n2h64(53))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(492)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(66),h0tab(:,66),[64,3,48,12],[nMT,nMT,nMT,nMT],4,3,wf4(:,1),wf4(:,12) &
    ,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,66),heltab2x128(:,:,66))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(18),n2h64(54))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(492)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(67),h0tab(:,67),[64,3,48,12],[0,0,0,0],4,3,wf4(:,1),wf4(:,12),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,67),heltab2x128(:,:,67))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(19),n2h64(55))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(492)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(68),h0tab(:,68),[64,3,48,12],[nMT,nMT,nMT,nMT],4,3,wf4(:,1),wf4(:,12) &
    ,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,68),heltab2x128(:,:,68))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(20),n2h64(56))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(492)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(69),h0tab(:,69),[64,3,48,12],[0,0,0,0],4,3,wf4(:,1),wf4(:,12),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,69),heltab2x128(:,:,69))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(21),n2h64(57))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(492)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(70),h0tab(:,70),[64,3,48,12],[nMB,nMB,nMB,nMB],4,3,wf4(:,1),wf4(:,12) &
    ,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,70),heltab2x128(:,:,70))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(22),n2h64(58))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(492)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(71),h0tab(:,71),[64,3,48,12],[0,0,0,0],4,3,wf4(:,1),wf4(:,12),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,71),heltab2x128(:,:,71))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(23),n2h64(59))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(492)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(72),h0tab(:,72),[64,3,48,12],[nMB,nMB,nMB,nMB],4,3,wf4(:,1),wf4(:,12) &
    ,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,72),heltab2x128(:,:,72))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(24),n2h64(60))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(493)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(73),h0tab(:,73),[64,3,48,12],[0,0,0,0],4,3,wf4(:,6),wf4(:,12),wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,73),heltab2x128(:,:,73))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(25),n2h64(61))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(493)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(74),h0tab(:,74),[64,3,48,12],[nMT,nMT,nMT,nMT],4,3,wf4(:,6),wf4(:,12) &
    ,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,74),heltab2x128(:,:,74))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(26),n2h64(62))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(493)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(75),h0tab(:,75),[64,3,48,12],[0,0,0,0],4,3,wf4(:,6),wf4(:,12),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,75),heltab2x128(:,:,75))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(27),n2h64(63))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(493)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(76),h0tab(:,76),[64,3,48,12],[nMT,nMT,nMT,nMT],4,3,wf4(:,6),wf4(:,12) &
    ,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,76),heltab2x128(:,:,76))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(28),n2h64(64))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(493)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(77),h0tab(:,77),[64,3,48,12],[0,0,0,0],4,3,wf4(:,6),wf4(:,12),wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,77),heltab2x128(:,:,77))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(29),n2h64(65))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(493)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(78),h0tab(:,78),[64,3,48,12],[nMB,nMB,nMB,nMB],4,3,wf4(:,6),wf4(:,12) &
    ,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,78),heltab2x128(:,:,78))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(30),n2h64(66))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(493)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(79),h0tab(:,79),[64,3,48,12],[0,0,0,0],4,3,wf4(:,6),wf4(:,12),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,79),heltab2x128(:,:,79))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(31),n2h64(67))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(493)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(80),h0tab(:,80),[64,3,48,12],[nMB,nMB,nMB,nMB],4,3,wf4(:,6),wf4(:,12) &
    ,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,80),heltab2x128(:,:,80))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(32),n2h64(68))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(494)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(81),h0tab(:,81),[64,3,48,12],[0,0,0,0],4,3,wf4(:,6),wf4(:,12),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,81),heltab2x128(:,:,81))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(33),n2h64(69))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(494)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(82),h0tab(:,82),[64,3,48,12],[nMT,nMT,nMT,nMT],4,3,wf4(:,6),wf4(:,12) &
    ,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,82),heltab2x128(:,:,82))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(34),n2h64(70))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(494)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(83),h0tab(:,83),[64,3,48,12],[0,0,0,0],4,3,wf4(:,6),wf4(:,12),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,83),heltab2x128(:,:,83))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(35),n2h64(71))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(494)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(84),h0tab(:,84),[64,3,48,12],[nMT,nMT,nMT,nMT],4,3,wf4(:,6),wf4(:,12) &
    ,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,84),heltab2x128(:,:,84))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(36),n2h64(72))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(494)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(85),h0tab(:,85),[64,3,48,12],[0,0,0,0],4,3,wf4(:,6),wf4(:,12),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,85),heltab2x128(:,:,85))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(37),n2h64(73))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(494)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(86),h0tab(:,86),[64,3,48,12],[nMB,nMB,nMB,nMB],4,3,wf4(:,6),wf4(:,12) &
    ,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,86),heltab2x128(:,:,86))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(38),n2h64(74))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(494)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(87),h0tab(:,87),[64,3,48,12],[0,0,0,0],4,3,wf4(:,6),wf4(:,12),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,87),heltab2x128(:,:,87))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(39),n2h64(75))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(494)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(88),h0tab(:,88),[64,3,48,12],[nMB,nMB,nMB,nMB],4,3,wf4(:,6),wf4(:,12) &
    ,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,88),heltab2x128(:,:,88))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(40),n2h64(76))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(489)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(89),h0tab(:,89),[64,3,12,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,1),wf4(:,2),wf4(: &
    ,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,89),heltab2x128(:,:,89))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(41),n2h64(77))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(489)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(90),h0tab(:,90),[64,3,12,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,1),wf4(:,2),wf4(: &
    ,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,90),heltab2x128(:,:,90))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(42),n2h64(78))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(489)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(91),h0tab(:,91),[64,3,12,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,1),wf4(:,2),wf4(: &
    ,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,91),heltab2x128(:,:,91))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(43),n2h64(79))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(489)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(92),h0tab(:,92),[64,3,12,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,1),wf4(:,2),wf4(: &
    ,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,92),heltab2x128(:,:,92))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(44),n2h64(80))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(490)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(93),h0tab(:,93),[64,3,12,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,6),wf4(:,2),wf4(: &
    ,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,93),heltab2x128(:,:,93))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(45),n2h64(81))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(490)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(94),h0tab(:,94),[64,3,12,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,6),wf4(:,2),wf4(: &
    ,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,94),heltab2x128(:,:,94))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(46),n2h64(82))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(490)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(95),h0tab(:,95),[64,3,12,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,6),wf4(:,2),wf4(: &
    ,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,95),heltab2x128(:,:,95))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(47),n2h64(83))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(490)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(96),h0tab(:,96),[64,3,12,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,6),wf4(:,2),wf4(: &
    ,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,96),heltab2x128(:,:,96))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(48),n2h64(84))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(491)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(97),h0tab(:,97),[64,3,12,48],[0,0,0,0],4,3,wf4(:,1),wf4(:,7),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,97),heltab2x128(:,:,97))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(49),n2h64(85))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(491)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(98),h0tab(:,98),[64,3,12,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,1),wf4(:,7),wf4(: &
    ,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,98),heltab2x128(:,:,98))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(50),n2h64(86))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(491)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(99),h0tab(:,99),[64,3,12,48],[0,0,0,0],4,3,wf4(:,1),wf4(:,7),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,99),heltab2x128(:,:,99))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(51),n2h64(87))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(491)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(100),h0tab(:,100),[64,3,12,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,1),wf4(:,7) &
    ,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,100),heltab2x128(:,:,100))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(52),n2h64(88))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(491)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(101),h0tab(:,101),[64,3,12,48],[0,0,0,0],4,3,wf4(:,1),wf4(:,7),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,101),heltab2x128(:,:,101))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(53),n2h64(89))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(491)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(102),h0tab(:,102),[64,3,12,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,1),wf4(:,7) &
    ,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,102),heltab2x128(:,:,102))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(54),n2h64(90))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(491)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(103),h0tab(:,103),[64,3,12,48],[0,0,0,0],4,3,wf4(:,1),wf4(:,7),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,103),heltab2x128(:,:,103))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(55),n2h64(91))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(491)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(104),h0tab(:,104),[64,3,12,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,1),wf4(:,7) &
    ,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,104),heltab2x128(:,:,104))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(56),n2h64(92))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(492)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(105),h0tab(:,105),[64,3,12,48],[0,0,0,0],4,3,wf4(:,1),wf4(:,9),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,105),heltab2x128(:,:,105))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(57),n2h64(93))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(492)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(106),h0tab(:,106),[64,3,12,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,1),wf4(:,9) &
    ,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,106),heltab2x128(:,:,106))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(58),n2h64(94))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(492)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(107),h0tab(:,107),[64,3,12,48],[0,0,0,0],4,3,wf4(:,1),wf4(:,9),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,107),heltab2x128(:,:,107))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(59),n2h64(95))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(492)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(108),h0tab(:,108),[64,3,12,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,1),wf4(:,9) &
    ,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,108),heltab2x128(:,:,108))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(60),n2h64(96))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(492)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(109),h0tab(:,109),[64,3,12,48],[0,0,0,0],4,3,wf4(:,1),wf4(:,9),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,109),heltab2x128(:,:,109))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(61),n2h64(97))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(492)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(110),h0tab(:,110),[64,3,12,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,1),wf4(:,9) &
    ,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,110),heltab2x128(:,:,110))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(62),n2h64(98))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(492)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(111),h0tab(:,111),[64,3,12,48],[0,0,0,0],4,3,wf4(:,1),wf4(:,9),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,111),heltab2x128(:,:,111))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(63),n2h64(99))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(492)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(112),h0tab(:,112),[64,3,12,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,1),wf4(:,9) &
    ,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,112),heltab2x128(:,:,112))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(64),n2h64(100))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(493)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(113),h0tab(:,113),[64,3,12,48],[0,0,0,0],4,3,wf4(:,6),wf4(:,7),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,113),heltab2x128(:,:,113))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(65),n2h64(101))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(493)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(114),h0tab(:,114),[64,3,12,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,6),wf4(:,7) &
    ,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,114),heltab2x128(:,:,114))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(66),n2h64(102))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(493)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(115),h0tab(:,115),[64,3,12,48],[0,0,0,0],4,3,wf4(:,6),wf4(:,7),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,115),heltab2x128(:,:,115))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(67),n2h64(103))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(493)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(116),h0tab(:,116),[64,3,12,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,6),wf4(:,7) &
    ,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,116),heltab2x128(:,:,116))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(68),n2h64(104))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(493)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(117),h0tab(:,117),[64,3,12,48],[0,0,0,0],4,3,wf4(:,6),wf4(:,7),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,117),heltab2x128(:,:,117))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(69),n2h64(105))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(493)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(118),h0tab(:,118),[64,3,12,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,6),wf4(:,7) &
    ,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,118),heltab2x128(:,:,118))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(70),n2h64(106))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(493)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(119),h0tab(:,119),[64,3,12,48],[0,0,0,0],4,3,wf4(:,6),wf4(:,7),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,119),heltab2x128(:,:,119))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(71),n2h64(107))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(493)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(120),h0tab(:,120),[64,3,12,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,6),wf4(:,7) &
    ,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,120),heltab2x128(:,:,120))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(72),n2h64(108))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(494)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(121),h0tab(:,121),[64,3,12,48],[0,0,0,0],4,3,wf4(:,6),wf4(:,9),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,121),heltab2x128(:,:,121))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(73),n2h64(109))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(494)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(122),h0tab(:,122),[64,3,12,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,6),wf4(:,9) &
    ,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,122),heltab2x128(:,:,122))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(74),n2h64(110))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(494)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(123),h0tab(:,123),[64,3,12,48],[0,0,0,0],4,3,wf4(:,6),wf4(:,9),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,123),heltab2x128(:,:,123))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(75),n2h64(111))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(494)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(124),h0tab(:,124),[64,3,12,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,6),wf4(:,9) &
    ,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,124),heltab2x128(:,:,124))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(76),n2h64(112))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(494)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(125),h0tab(:,125),[64,3,12,48],[0,0,0,0],4,3,wf4(:,6),wf4(:,9),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,125),heltab2x128(:,:,125))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(77),n2h64(113))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(494)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(126),h0tab(:,126),[64,3,12,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,6),wf4(:,9) &
    ,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,126),heltab2x128(:,:,126))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(78),n2h64(114))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(494)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(127),h0tab(:,127),[64,3,12,48],[0,0,0,0],4,3,wf4(:,6),wf4(:,9),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,127),heltab2x128(:,:,127))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(79),n2h64(115))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(494)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(128),h0tab(:,128),[64,3,12,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,6),wf4(:,9) &
    ,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,128),heltab2x128(:,:,128))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(80),n2h64(116))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(489)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(129),h0tab(:,129),[64,12,3,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,2),wf4(:,1) &
    ,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,129),heltab2x128(:,:,129))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(81),n2h64(117))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(489)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(130),h0tab(:,130),[64,12,3,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,2),wf4(:,1) &
    ,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,130),heltab2x128(:,:,130))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(82),n2h64(118))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(489)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(131),h0tab(:,131),[64,12,3,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,2),wf4(:,1) &
    ,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,131),heltab2x128(:,:,131))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(83),n2h64(119))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(489)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(132),h0tab(:,132),[64,12,3,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,2),wf4(:,1) &
    ,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,132),heltab2x128(:,:,132))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(84),n2h64(120))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(490)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(133),h0tab(:,133),[64,12,3,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,2),wf4(:,6) &
    ,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,133),heltab2x128(:,:,133))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(85),n2h64(121))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(490)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(134),h0tab(:,134),[64,12,3,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,2),wf4(:,6) &
    ,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,134),heltab2x128(:,:,134))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(86),n2h64(122))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(490)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(135),h0tab(:,135),[64,12,3,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,2),wf4(:,6) &
    ,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,135),heltab2x128(:,:,135))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(87),n2h64(123))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(490)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(136),h0tab(:,136),[64,12,3,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,2),wf4(:,6) &
    ,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,136),heltab2x128(:,:,136))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(88),n2h64(124))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(491)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(137),h0tab(:,137),[64,12,3,48],[0,0,0,0],4,3,wf4(:,7),wf4(:,1),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,137),heltab2x128(:,:,137))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(89),n2h64(125))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(491)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(138),h0tab(:,138),[64,12,3,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,7),wf4(:,1) &
    ,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,138),heltab2x128(:,:,138))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(90),n2h64(126))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(491)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(139),h0tab(:,139),[64,12,3,48],[0,0,0,0],4,3,wf4(:,7),wf4(:,1),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,139),heltab2x128(:,:,139))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(91),n2h64(127))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(491)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(140),h0tab(:,140),[64,12,3,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,7),wf4(:,1) &
    ,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,140),heltab2x128(:,:,140))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(92),n2h64(128))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(491)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(141),h0tab(:,141),[64,12,3,48],[0,0,0,0],4,3,wf4(:,7),wf4(:,1),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,141),heltab2x128(:,:,141))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(93),n2h64(129))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(491)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(142),h0tab(:,142),[64,12,3,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,7),wf4(:,1) &
    ,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,142),heltab2x128(:,:,142))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(94),n2h64(130))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(491)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(143),h0tab(:,143),[64,12,3,48],[0,0,0,0],4,3,wf4(:,7),wf4(:,1),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,143),heltab2x128(:,:,143))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(95),n2h64(131))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(491)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(144),h0tab(:,144),[64,12,3,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,7),wf4(:,1) &
    ,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,144),heltab2x128(:,:,144))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(96),n2h64(132))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(492)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(145),h0tab(:,145),[64,12,3,48],[0,0,0,0],4,3,wf4(:,9),wf4(:,1),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,145),heltab2x128(:,:,145))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(97),n2h64(133))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(492)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(146),h0tab(:,146),[64,12,3,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,9),wf4(:,1) &
    ,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,146),heltab2x128(:,:,146))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(98),n2h64(134))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(492)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(147),h0tab(:,147),[64,12,3,48],[0,0,0,0],4,3,wf4(:,9),wf4(:,1),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,147),heltab2x128(:,:,147))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(99),n2h64(135))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(492)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(148),h0tab(:,148),[64,12,3,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,9),wf4(:,1) &
    ,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,148),heltab2x128(:,:,148))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(100),n2h64(136))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(492)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(149),h0tab(:,149),[64,12,3,48],[0,0,0,0],4,3,wf4(:,9),wf4(:,1),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,149),heltab2x128(:,:,149))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(101),n2h64(137))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(492)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(150),h0tab(:,150),[64,12,3,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,9),wf4(:,1) &
    ,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,150),heltab2x128(:,:,150))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(102),n2h64(138))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(492)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(151),h0tab(:,151),[64,12,3,48],[0,0,0,0],4,3,wf4(:,9),wf4(:,1),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,151),heltab2x128(:,:,151))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(103),n2h64(139))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(492)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(152),h0tab(:,152),[64,12,3,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,9),wf4(:,1) &
    ,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,152),heltab2x128(:,:,152))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(104),n2h64(140))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(493)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(153),h0tab(:,153),[64,12,3,48],[0,0,0,0],4,3,wf4(:,7),wf4(:,6),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,153),heltab2x128(:,:,153))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(105),n2h64(141))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(493)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(154),h0tab(:,154),[64,12,3,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,7),wf4(:,6) &
    ,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,154),heltab2x128(:,:,154))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(106),n2h64(142))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(493)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(155),h0tab(:,155),[64,12,3,48],[0,0,0,0],4,3,wf4(:,7),wf4(:,6),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,155),heltab2x128(:,:,155))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(107),n2h64(143))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(493)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(156),h0tab(:,156),[64,12,3,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,7),wf4(:,6) &
    ,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,156),heltab2x128(:,:,156))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(108),n2h64(144))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(493)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(157),h0tab(:,157),[64,12,3,48],[0,0,0,0],4,3,wf4(:,7),wf4(:,6),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,157),heltab2x128(:,:,157))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(109),n2h64(145))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(493)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(158),h0tab(:,158),[64,12,3,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,7),wf4(:,6) &
    ,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,158),heltab2x128(:,:,158))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(110),n2h64(146))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(493)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(159),h0tab(:,159),[64,12,3,48],[0,0,0,0],4,3,wf4(:,7),wf4(:,6),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,159),heltab2x128(:,:,159))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(111),n2h64(147))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(493)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(160),h0tab(:,160),[64,12,3,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,7),wf4(:,6) &
    ,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,160),heltab2x128(:,:,160))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(112),n2h64(148))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(494)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(161),h0tab(:,161),[64,12,3,48],[0,0,0,0],4,3,wf4(:,9),wf4(:,6),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,161),heltab2x128(:,:,161))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(113),n2h64(149))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(494)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(162),h0tab(:,162),[64,12,3,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,9),wf4(:,6) &
    ,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,162),heltab2x128(:,:,162))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(114),n2h64(150))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(494)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(163),h0tab(:,163),[64,12,3,48],[0,0,0,0],4,3,wf4(:,9),wf4(:,6),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,163),heltab2x128(:,:,163))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(115),n2h64(151))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(494)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(164),h0tab(:,164),[64,12,3,48],[nMT,nMT,nMT,nMT],4,3,wf4(:,9),wf4(:,6) &
    ,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,164),heltab2x128(:,:,164))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(116),n2h64(152))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(494)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(165),h0tab(:,165),[64,12,3,48],[0,0,0,0],4,3,wf4(:,9),wf4(:,6),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,165),heltab2x128(:,:,165))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(117),n2h64(153))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(494)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(166),h0tab(:,166),[64,12,3,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,9),wf4(:,6) &
    ,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,166),heltab2x128(:,:,166))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(118),n2h64(154))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(494)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(167),h0tab(:,167),[64,12,3,48],[0,0,0,0],4,3,wf4(:,9),wf4(:,6),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,167),heltab2x128(:,:,167))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(119),n2h64(155))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(494)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(168),h0tab(:,168),[64,12,3,48],[nMB,nMB,nMB,nMB],4,3,wf4(:,9),wf4(:,6) &
    ,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,168),heltab2x128(:,:,168))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(120),n2h64(156))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(507)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(169),h0tab(:,169),[80,12,3,32],[nMB,nMB,nMB,0],4,3,wf4(:,4),wf4(:,2),wf4(: &
    ,1))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,1),heltab2x128(:,:,169))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(1),n2h32(25))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(508)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(170),h0tab(:,170),[80,12,3,32],[nMB,nMB,nMB,0],4,3,wf4(:,4),wf4(:,2),wf4(: &
    ,6))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,2),heltab2x128(:,:,170))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(2),n2h32(26))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(509)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(171),h0tab(:,171),[80,12,3,32],[nMB,nMB,nMB,0],4,3,wf4(:,4),wf4(:,7),wf4(: &
    ,1))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,3),heltab2x128(:,:,171))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(4),n2h32(27))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(510)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(172),h0tab(:,172),[80,12,3,32],[nMB,nMB,nMB,0],4,3,wf4(:,4),wf4(:,9),wf4(: &
    ,1))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,4),heltab2x128(:,:,172))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(5),n2h32(28))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(511)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(173),h0tab(:,173),[80,12,3,32],[nMB,nMB,nMB,0],4,3,wf4(:,4),wf4(:,7),wf4(: &
    ,6))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,5),heltab2x128(:,:,173))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(6),n2h32(29))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(512)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(174),h0tab(:,174),[80,12,3,32],[nMB,nMB,nMB,0],4,3,wf4(:,4),wf4(:,9),wf4(: &
    ,6))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,6),heltab2x128(:,:,174))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(7),n2h32(30))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(507)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(175),h0tab(:,175),[80,3,12,32],[nMB,nMB,nMB,0],4,3,wf4(:,4),wf4(:,1),wf4(: &
    ,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,7),heltab2x128(:,:,175))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(8),n2h32(31))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(508)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(176),h0tab(:,176),[80,3,12,32],[nMB,nMB,nMB,0],4,3,wf4(:,4),wf4(:,6),wf4(: &
    ,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,8),heltab2x128(:,:,176))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(10),n2h32(32))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(509)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(177),h0tab(:,177),[80,3,12,32],[nMB,nMB,nMB,0],4,3,wf4(:,4),wf4(:,1),wf4(: &
    ,7))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,9),heltab2x128(:,:,177))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(11),n2h32(33))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(510)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(178),h0tab(:,178),[80,3,12,32],[nMB,nMB,nMB,0],4,3,wf4(:,4),wf4(:,1),wf4(: &
    ,9))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,10),heltab2x128(:,:,178))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(12),n2h32(34))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(511)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(179),h0tab(:,179),[80,3,12,32],[nMB,nMB,nMB,0],4,3,wf4(:,4),wf4(:,6),wf4(: &
    ,7))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,11),heltab2x128(:,:,179))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(13),n2h32(35))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(512)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(180),h0tab(:,180),[80,3,12,32],[nMB,nMB,nMB,0],4,3,wf4(:,4),wf4(:,6),wf4(: &
    ,9))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,12),heltab2x128(:,:,180))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(14),n2h32(36))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(525)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(181),h0tab(:,181),[96,12,3,16],[nMB,nMB,nMB,0],4,3,wf4(:,11),wf4(:,2) &
    ,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,11),G0H32(1),m3h4x32(:,13),heltab2x128(:,:,181))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(16),n2h32(37))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(526)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(182),h0tab(:,182),[96,12,3,16],[nMB,nMB,nMB,0],4,3,wf4(:,11),wf4(:,2) &
    ,wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,11),G0H32(1),m3h4x32(:,14),heltab2x128(:,:,182))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(17),n2h32(38))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(527)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(183),h0tab(:,183),[96,12,3,16],[nMB,nMB,nMB,0],4,3,wf4(:,11),wf4(:,7) &
    ,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,11),G0H32(1),m3h4x32(:,15),heltab2x128(:,:,183))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(18),n2h32(39))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(528)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(184),h0tab(:,184),[96,12,3,16],[nMB,nMB,nMB,0],4,3,wf4(:,11),wf4(:,9) &
    ,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,11),G0H32(1),m3h4x32(:,16),heltab2x128(:,:,184))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(19),n2h32(40))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(529)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(185),h0tab(:,185),[96,12,3,16],[nMB,nMB,nMB,0],4,3,wf4(:,11),wf4(:,7) &
    ,wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,11),G0H32(1),m3h4x32(:,17),heltab2x128(:,:,185))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(20),n2h32(41))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(530)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(186),h0tab(:,186),[96,12,3,16],[nMB,nMB,nMB,0],4,3,wf4(:,11),wf4(:,9) &
    ,wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,11),G0H32(1),m3h4x32(:,18),heltab2x128(:,:,186))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(22),n2h32(42))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(525)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(187),h0tab(:,187),[96,3,12,16],[nMB,nMB,nMB,0],4,3,wf4(:,11),wf4(:,1) &
    ,wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,11),G0H32(1),m3h4x32(:,19),heltab2x128(:,:,187))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(23),n2h32(43))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(526)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(188),h0tab(:,188),[96,3,12,16],[nMB,nMB,nMB,0],4,3,wf4(:,11),wf4(:,6) &
    ,wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,11),G0H32(1),m3h4x32(:,20),heltab2x128(:,:,188))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(24),n2h32(44))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(527)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(189),h0tab(:,189),[96,3,12,16],[nMB,nMB,nMB,0],4,3,wf4(:,11),wf4(:,1) &
    ,wf4(:,7))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,11),G0H32(1),m3h4x32(:,21),heltab2x128(:,:,189))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(25),n2h32(45))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(528)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(190),h0tab(:,190),[96,3,12,16],[nMB,nMB,nMB,0],4,3,wf4(:,11),wf4(:,1) &
    ,wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,11),G0H32(1),m3h4x32(:,22),heltab2x128(:,:,190))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(26),n2h32(46))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(529)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(191),h0tab(:,191),[96,3,12,16],[nMB,nMB,nMB,0],4,3,wf4(:,11),wf4(:,6) &
    ,wf4(:,7))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,11),G0H32(1),m3h4x32(:,23),heltab2x128(:,:,191))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(28),n2h32(47))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(530)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(192),h0tab(:,192),[96,3,12,16],[nMB,nMB,nMB,0],4,3,wf4(:,11),wf4(:,6) &
    ,wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,11),G0H32(1),m3h4x32(:,24),heltab2x128(:,:,192))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(29),n2h32(48))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(386)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(193),h0tab(:,193),[64,19,12,32],[0,nMB,nMB,0],4,2,wf8(:,15),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(121),m3h2x64(:,169),heltab2x128(:,:,193))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(389)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(194),h0tab(:,194),[64,19,12,32],[0,nMB,nMB,0],4,2,wf8(:,17),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(122),m3h2x64(:,170),heltab2x128(:,:,194))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(391)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(195),h0tab(:,195),[64,19,12,32],[0,nMB,nMB,0],4,2,wf8(:,15),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(123),m3h2x64(:,171),heltab2x128(:,:,195))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(393)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(196),h0tab(:,196),[64,19,12,32],[0,nMB,nMB,0],4,2,wf8(:,15),wf4(:,9))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(124),m3h2x64(:,172),heltab2x128(:,:,196))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(395)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(197),h0tab(:,197),[64,19,12,32],[0,nMB,nMB,0],4,2,wf8(:,17),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(125),m3h2x64(:,173),heltab2x128(:,:,197))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(397)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(198),h0tab(:,198),[64,19,12,32],[0,nMB,nMB,0],4,2,wf8(:,17),wf4(:,9))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(126),m3h2x64(:,174),heltab2x128(:,:,198))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(386)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(199),h0tab(:,199),[64,12,19,32],[nMB,nMB,0,nMB],4,2,wf4(:,2),wf8(:,15))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,175),heltab2x128(:,:,199))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(127),n2h64(157))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(389)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(200),h0tab(:,200),[64,12,19,32],[nMB,nMB,0,nMB],4,2,wf4(:,2),wf8(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,176),heltab2x128(:,:,200))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(128),n2h64(158))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(391)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(201),h0tab(:,201),[64,12,19,32],[nMB,nMB,0,nMB],4,2,wf4(:,7),wf8(:,15))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,177),heltab2x128(:,:,201))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(129),n2h64(159))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(393)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(202),h0tab(:,202),[64,12,19,32],[nMB,nMB,0,nMB],4,2,wf4(:,9),wf8(:,15))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,178),heltab2x128(:,:,202))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(130),n2h64(160))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(395)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(203),h0tab(:,203),[64,12,19,32],[nMB,nMB,0,nMB],4,2,wf4(:,7),wf8(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,179),heltab2x128(:,:,203))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(131),n2h64(161))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(397)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(204),h0tab(:,204),[64,12,19,32],[nMB,nMB,0,nMB],4,2,wf4(:,9),wf8(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,180),heltab2x128(:,:,204))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(132),n2h64(162))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(386)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(205),h0tab(:,205),[64,12,32,19],[nMB,nMB,0,nMB],4,2,wf4(:,2),wf8(:,15))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,181),heltab2x128(:,:,205))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(133),n2h64(163))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(389)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(206),h0tab(:,206),[64,12,32,19],[nMB,nMB,0,nMB],4,2,wf4(:,2),wf8(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,182),heltab2x128(:,:,206))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(134),n2h64(164))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(391)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(207),h0tab(:,207),[64,12,32,19],[nMB,nMB,0,nMB],4,2,wf4(:,7),wf8(:,15))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,183),heltab2x128(:,:,207))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(135),n2h64(165))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(393)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(208),h0tab(:,208),[64,12,32,19],[nMB,nMB,0,nMB],4,2,wf4(:,9),wf8(:,15))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,184),heltab2x128(:,:,208))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(136),n2h64(166))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(395)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(209),h0tab(:,209),[64,12,32,19],[nMB,nMB,0,nMB],4,2,wf4(:,7),wf8(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,185),heltab2x128(:,:,209))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(137),n2h64(167))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(397)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(210),h0tab(:,210),[64,12,32,19],[nMB,nMB,0,nMB],4,2,wf4(:,9),wf8(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,186),heltab2x128(:,:,210))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(138),n2h64(168))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(401)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(211),h0tab(:,211),[64,16,12,35],[0,nMB,nMB,0],4,2,wf4(:,2),wf8(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(139),m3h2x64(:,187),heltab2x128(:,:,211))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(404)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(212),h0tab(:,212),[64,16,12,35],[0,nMB,nMB,0],4,2,wf4(:,2),wf8(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(140),m3h2x64(:,188),heltab2x128(:,:,212))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(406)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(213),h0tab(:,213),[64,16,12,35],[0,nMB,nMB,0],4,2,wf4(:,7),wf8(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(141),m3h2x64(:,189),heltab2x128(:,:,213))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(408)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(214),h0tab(:,214),[64,16,12,35],[0,nMB,nMB,0],4,2,wf4(:,9),wf8(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(142),m3h2x64(:,190),heltab2x128(:,:,214))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(410)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(215),h0tab(:,215),[64,16,12,35],[0,nMB,nMB,0],4,2,wf4(:,7),wf8(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(143),m3h2x64(:,191),heltab2x128(:,:,215))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(412)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(216),h0tab(:,216),[64,16,12,35],[0,nMB,nMB,0],4,2,wf4(:,9),wf8(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(144),m3h2x64(:,192),heltab2x128(:,:,216))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(401)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(217),h0tab(:,217),[64,12,35,16],[nMB,nMB,0,nMB],4,2,wf4(:,2),wf8(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,193),heltab2x128(:,:,217))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(145),n2h64(169))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(404)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(218),h0tab(:,218),[64,12,35,16],[nMB,nMB,0,nMB],4,2,wf4(:,2),wf8(:,4))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,194),heltab2x128(:,:,218))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(146),n2h64(170))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(406)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(219),h0tab(:,219),[64,12,35,16],[nMB,nMB,0,nMB],4,2,wf4(:,7),wf8(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,195),heltab2x128(:,:,219))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(147),n2h64(171))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(408)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(220),h0tab(:,220),[64,12,35,16],[nMB,nMB,0,nMB],4,2,wf4(:,9),wf8(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,196),heltab2x128(:,:,220))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(148),n2h64(172))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(410)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(221),h0tab(:,221),[64,12,35,16],[nMB,nMB,0,nMB],4,2,wf4(:,7),wf8(:,4))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,197),heltab2x128(:,:,221))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(149),n2h64(173))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(412)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(222),h0tab(:,222),[64,12,35,16],[nMB,nMB,0,nMB],4,2,wf4(:,9),wf8(:,4))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,198),heltab2x128(:,:,222))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(150),n2h64(174))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(401)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(223),h0tab(:,223),[64,12,16,35],[nMB,nMB,0,nMB],4,2,wf4(:,2),wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,199),heltab2x128(:,:,223))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(151),n2h64(175))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(404)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(224),h0tab(:,224),[64,12,16,35],[nMB,nMB,0,nMB],4,2,wf4(:,2),wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,200),heltab2x128(:,:,224))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(152),n2h64(176))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(406)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(225),h0tab(:,225),[64,12,16,35],[nMB,nMB,0,nMB],4,2,wf4(:,7),wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,201),heltab2x128(:,:,225))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(153),n2h64(177))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(408)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(226),h0tab(:,226),[64,12,16,35],[nMB,nMB,0,nMB],4,2,wf4(:,9),wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,202),heltab2x128(:,:,226))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(154),n2h64(178))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(410)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(227),h0tab(:,227),[64,12,16,35],[nMB,nMB,0,nMB],4,2,wf4(:,7),wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,203),heltab2x128(:,:,227))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(155),n2h64(179))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(412)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(228),h0tab(:,228),[64,12,16,35],[nMB,nMB,0,nMB],4,2,wf4(:,9),wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,204),heltab2x128(:,:,228))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(156),n2h64(180))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(418)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(229),h0tab(:,229),[64,28,3,32],[0,nMB,nMB,0],4,2,wf8(:,19),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(157),m3h2x64(:,205),heltab2x128(:,:,229))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(420)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(230),h0tab(:,230),[64,28,3,32],[0,nMB,nMB,0],4,2,wf8(:,19),wf4(:,6))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(158),m3h2x64(:,206),heltab2x128(:,:,230))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(422)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(231),h0tab(:,231),[64,28,3,32],[0,nMB,nMB,0],4,2,wf8(:,21),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(159),m3h2x64(:,207),heltab2x128(:,:,231))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(424)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(232),h0tab(:,232),[64,28,3,32],[0,nMB,nMB,0],4,2,wf8(:,23),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(160),m3h2x64(:,208),heltab2x128(:,:,232))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(426)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(233),h0tab(:,233),[64,28,3,32],[0,nMB,nMB,0],4,2,wf8(:,21),wf4(:,6))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(161),m3h2x64(:,209),heltab2x128(:,:,233))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(428)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(234),h0tab(:,234),[64,28,3,32],[0,nMB,nMB,0],4,2,wf8(:,23),wf4(:,6))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(162),m3h2x64(:,210),heltab2x128(:,:,234))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(418)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(235),h0tab(:,235),[64,3,28,32],[nMB,nMB,0,nMB],4,2,wf4(:,1),wf8(:,19))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,211),heltab2x128(:,:,235))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(163),n2h64(181))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(420)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(236),h0tab(:,236),[64,3,28,32],[nMB,nMB,0,nMB],4,2,wf4(:,6),wf8(:,19))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,212),heltab2x128(:,:,236))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(164),n2h64(182))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(422)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(237),h0tab(:,237),[64,3,28,32],[nMB,nMB,0,nMB],4,2,wf4(:,1),wf8(:,21))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,213),heltab2x128(:,:,237))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(165),n2h64(183))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(424)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(238),h0tab(:,238),[64,3,28,32],[nMB,nMB,0,nMB],4,2,wf4(:,1),wf8(:,23))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,214),heltab2x128(:,:,238))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(166),n2h64(184))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(426)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(239),h0tab(:,239),[64,3,28,32],[nMB,nMB,0,nMB],4,2,wf4(:,6),wf8(:,21))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,215),heltab2x128(:,:,239))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(167),n2h64(185))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(428)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(240),h0tab(:,240),[64,3,28,32],[nMB,nMB,0,nMB],4,2,wf4(:,6),wf8(:,23))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,216),heltab2x128(:,:,240))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(168),n2h64(186))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(418)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(241),h0tab(:,241),[64,3,32,28],[nMB,nMB,0,nMB],4,2,wf4(:,1),wf8(:,19))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,217),heltab2x128(:,:,241))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(169),n2h64(187))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(420)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(242),h0tab(:,242),[64,3,32,28],[nMB,nMB,0,nMB],4,2,wf4(:,6),wf8(:,19))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,218),heltab2x128(:,:,242))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(170),n2h64(188))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(422)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(243),h0tab(:,243),[64,3,32,28],[nMB,nMB,0,nMB],4,2,wf4(:,1),wf8(:,21))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,219),heltab2x128(:,:,243))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(171),n2h64(189))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(424)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(244),h0tab(:,244),[64,3,32,28],[nMB,nMB,0,nMB],4,2,wf4(:,1),wf8(:,23))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,220),heltab2x128(:,:,244))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(172),n2h64(190))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(426)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(245),h0tab(:,245),[64,3,32,28],[nMB,nMB,0,nMB],4,2,wf4(:,6),wf8(:,21))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,221),heltab2x128(:,:,245))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(173),n2h64(191))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(428)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(246),h0tab(:,246),[64,3,32,28],[nMB,nMB,0,nMB],4,2,wf4(:,6),wf8(:,23))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,222),heltab2x128(:,:,246))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(174),n2h64(192))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(433)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(247),h0tab(:,247),[64,16,3,44],[0,nMB,nMB,0],4,2,wf4(:,1),wf8(:,6))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(175),m3h2x64(:,223),heltab2x128(:,:,247))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(435)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(248),h0tab(:,248),[64,16,3,44],[0,nMB,nMB,0],4,2,wf4(:,6),wf8(:,6))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(176),m3h2x64(:,224),heltab2x128(:,:,248))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(437)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(249),h0tab(:,249),[64,16,3,44],[0,nMB,nMB,0],4,2,wf4(:,1),wf8(:,8))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(177),m3h2x64(:,225),heltab2x128(:,:,249))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(439)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(250),h0tab(:,250),[64,16,3,44],[0,nMB,nMB,0],4,2,wf4(:,1),wf8(:,10))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(178),m3h2x64(:,226),heltab2x128(:,:,250))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(441)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(251),h0tab(:,251),[64,16,3,44],[0,nMB,nMB,0],4,2,wf4(:,6),wf8(:,8))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(179),m3h2x64(:,227),heltab2x128(:,:,251))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(443)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(252),h0tab(:,252),[64,16,3,44],[0,nMB,nMB,0],4,2,wf4(:,6),wf8(:,10))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(180),m3h2x64(:,228),heltab2x128(:,:,252))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(433)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(253),h0tab(:,253),[64,3,44,16],[nMB,nMB,0,nMB],4,2,wf4(:,1),wf8(:,6))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,229),heltab2x128(:,:,253))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(181),n2h64(193))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(435)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(254),h0tab(:,254),[64,3,44,16],[nMB,nMB,0,nMB],4,2,wf4(:,6),wf8(:,6))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,230),heltab2x128(:,:,254))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(182),n2h64(194))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(437)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(255),h0tab(:,255),[64,3,44,16],[nMB,nMB,0,nMB],4,2,wf4(:,1),wf8(:,8))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,231),heltab2x128(:,:,255))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(183),n2h64(195))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(439)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(256),h0tab(:,256),[64,3,44,16],[nMB,nMB,0,nMB],4,2,wf4(:,1),wf8(:,10))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,232),heltab2x128(:,:,256))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(184),n2h64(196))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(441)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(257),h0tab(:,257),[64,3,44,16],[nMB,nMB,0,nMB],4,2,wf4(:,6),wf8(:,8))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,233),heltab2x128(:,:,257))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(185),n2h64(197))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(443)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(258),h0tab(:,258),[64,3,44,16],[nMB,nMB,0,nMB],4,2,wf4(:,6),wf8(:,10))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,234),heltab2x128(:,:,258))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(186),n2h64(198))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(433)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(259),h0tab(:,259),[64,3,16,44],[nMB,nMB,0,nMB],4,2,wf4(:,1),wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,235),heltab2x128(:,:,259))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(187),n2h64(199))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(435)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(260),h0tab(:,260),[64,3,16,44],[nMB,nMB,0,nMB],4,2,wf4(:,6),wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,236),heltab2x128(:,:,260))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(188),n2h64(200))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(437)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(261),h0tab(:,261),[64,3,16,44],[nMB,nMB,0,nMB],4,2,wf4(:,1),wf8(:,8))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,237),heltab2x128(:,:,261))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(189),n2h64(201))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(439)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(262),h0tab(:,262),[64,3,16,44],[nMB,nMB,0,nMB],4,2,wf4(:,1),wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,238),heltab2x128(:,:,262))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(190),n2h64(202))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(441)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(263),h0tab(:,263),[64,3,16,44],[nMB,nMB,0,nMB],4,2,wf4(:,6),wf8(:,8))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,239),heltab2x128(:,:,263))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(191),n2h64(203))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(443)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(264),h0tab(:,264),[64,3,16,44],[nMB,nMB,0,nMB],4,2,wf4(:,6),wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,240),heltab2x128(:,:,264))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(192),n2h64(204))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(144)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(265),h0tab(:,265),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,38))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,241),heltab2x128(:,:,265))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(193),n2h64(205))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(147)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(266),h0tab(:,266),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,7))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,242),heltab2x128(:,:,266))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(194),n2h64(206))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(144)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(267),h0tab(:,267),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,38))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,243),heltab2x128(:,:,267))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(195),n2h64(207))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(147)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(268),h0tab(:,268),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,7))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,244),heltab2x128(:,:,268))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(196),n2h64(208))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(144)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(269),h0tab(:,269),[64,16,15,32],[0,nMB,nMB,0],4,1,wf16(:,38))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(197),m3h2x64(:,245),heltab2x128(:,:,269))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(147)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(270),h0tab(:,270),[64,16,15,32],[0,nMB,nMB,0],4,1,wf16(:,7))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(198),m3h2x64(:,246),heltab2x128(:,:,270))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(322)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(271),h0tab(:,271),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,18))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,247),heltab2x128(:,:,271))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(199),n2h64(209))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(324)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(272),h0tab(:,272),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,19))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,248),heltab2x128(:,:,272))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(200),n2h64(210))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(327)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(273),h0tab(:,273),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,20))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,249),heltab2x128(:,:,273))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(201),n2h64(211))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(329)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(274),h0tab(:,274),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,114))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,250),heltab2x128(:,:,274))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(202),n2h64(212))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(331)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(275),h0tab(:,275),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,22))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,251),heltab2x128(:,:,275))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(203),n2h64(213))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(333)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(276),h0tab(:,276),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,115))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,252),heltab2x128(:,:,276))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(204),n2h64(214))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(322)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(277),h0tab(:,277),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,18))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,253),heltab2x128(:,:,277))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(205),n2h64(215))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(324)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(278),h0tab(:,278),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,19))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,254),heltab2x128(:,:,278))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(206),n2h64(216))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(327)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(279),h0tab(:,279),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,20))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,255),heltab2x128(:,:,279))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(207),n2h64(217))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(329)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(280),h0tab(:,280),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,114))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,256),heltab2x128(:,:,280))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(208),n2h64(218))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(331)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(281),h0tab(:,281),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,22))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,257),heltab2x128(:,:,281))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(209),n2h64(219))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(333)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(282),h0tab(:,282),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,115))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,258),heltab2x128(:,:,282))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(210),n2h64(220))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(322)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(283),h0tab(:,283),[64,16,15,32],[0,nMB,nMB,0],4,1,wf16(:,18))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(211),m3h2x64(:,259),heltab2x128(:,:,283))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(324)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(284),h0tab(:,284),[64,16,15,32],[0,nMB,nMB,0],4,1,wf16(:,19))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(212),m3h2x64(:,260),heltab2x128(:,:,284))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(327)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(285),h0tab(:,285),[64,16,15,32],[0,nMB,nMB,0],4,1,wf16(:,20))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(213),m3h2x64(:,261),heltab2x128(:,:,285))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(329)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(286),h0tab(:,286),[64,16,15,32],[0,nMB,nMB,0],4,1,wf16(:,114))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(214),m3h2x64(:,262),heltab2x128(:,:,286))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(331)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(287),h0tab(:,287),[64,16,15,32],[0,nMB,nMB,0],4,1,wf16(:,22))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(215),m3h2x64(:,263),heltab2x128(:,:,287))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(333)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(288),h0tab(:,288),[64,16,15,32],[0,nMB,nMB,0],4,1,wf16(:,115))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(216),m3h2x64(:,264),heltab2x128(:,:,288))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(335)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(289),h0tab(:,289),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,24))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,265),heltab2x128(:,:,289))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(217),n2h64(221))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(337)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(290),h0tab(:,290),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,25))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,266),heltab2x128(:,:,290))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(218),n2h64(222))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(339)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(291),h0tab(:,291),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,26))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,267),heltab2x128(:,:,291))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(219),n2h64(223))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(341)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(292),h0tab(:,292),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,116))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,268),heltab2x128(:,:,292))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(220),n2h64(224))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(343)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(293),h0tab(:,293),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,28))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,269),heltab2x128(:,:,293))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(221),n2h64(225))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(345)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(294),h0tab(:,294),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,117))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,270),heltab2x128(:,:,294))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(222),n2h64(226))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(335)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(295),h0tab(:,295),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,24))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,271),heltab2x128(:,:,295))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(223),n2h64(227))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(337)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(296),h0tab(:,296),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,25))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,272),heltab2x128(:,:,296))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(224),n2h64(228))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(339)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(297),h0tab(:,297),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,26))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,273),heltab2x128(:,:,297))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(225),n2h64(229))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(341)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(298),h0tab(:,298),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,116))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,274),heltab2x128(:,:,298))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(226),n2h64(230))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(343)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(299),h0tab(:,299),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,28))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,275),heltab2x128(:,:,299))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(227),n2h64(231))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(345)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(300),h0tab(:,300),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,117))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,276),heltab2x128(:,:,300))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(228),n2h64(232))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(335)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(301),h0tab(:,301),[64,16,15,32],[0,nMB,nMB,0],4,1,wf16(:,24))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(229),m3h2x64(:,277),heltab2x128(:,:,301))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(337)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(302),h0tab(:,302),[64,16,15,32],[0,nMB,nMB,0],4,1,wf16(:,25))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(230),m3h2x64(:,278),heltab2x128(:,:,302))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(339)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(303),h0tab(:,303),[64,16,15,32],[0,nMB,nMB,0],4,1,wf16(:,26))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(231),m3h2x64(:,279),heltab2x128(:,:,303))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(341)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(304),h0tab(:,304),[64,16,15,32],[0,nMB,nMB,0],4,1,wf16(:,116))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(232),m3h2x64(:,280),heltab2x128(:,:,304))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(343)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(305),h0tab(:,305),[64,16,15,32],[0,nMB,nMB,0],4,1,wf16(:,28))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(233),m3h2x64(:,281),heltab2x128(:,:,305))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(345)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(306),h0tab(:,306),[64,16,15,32],[0,nMB,nMB,0],4,1,wf16(:,117))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(234),m3h2x64(:,282),heltab2x128(:,:,306))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(359)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(307),h0tab(:,307),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,30))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,283),heltab2x128(:,:,307))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(235),n2h64(233))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(361)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(308),h0tab(:,308),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,118))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,284),heltab2x128(:,:,308))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(236),n2h64(234))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(363)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(309),h0tab(:,309),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,32))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,285),heltab2x128(:,:,309))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(237),n2h64(235))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(365)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(310),h0tab(:,310),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,119))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,286),heltab2x128(:,:,310))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(238),n2h64(236))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(359)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(311),h0tab(:,311),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,30))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,287),heltab2x128(:,:,311))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(239),n2h64(237))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(361)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(312),h0tab(:,312),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,118))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,288),heltab2x128(:,:,312))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(240),n2h64(238))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(363)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(313),h0tab(:,313),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,32))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,289),heltab2x128(:,:,313))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(241),n2h64(239))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(365)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(314),h0tab(:,314),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,119))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,290),heltab2x128(:,:,314))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(242),n2h64(240))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(359)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(315),h0tab(:,315),[64,16,15,32],[0,nMB,nMB,0],4,1,wf16(:,30))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(243),m3h2x64(:,291),heltab2x128(:,:,315))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(361)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(316),h0tab(:,316),[64,16,15,32],[0,nMB,nMB,0],4,1,wf16(:,118))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(244),m3h2x64(:,292),heltab2x128(:,:,316))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(363)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(317),h0tab(:,317),[64,16,15,32],[0,nMB,nMB,0],4,1,wf16(:,32))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(245),m3h2x64(:,293),heltab2x128(:,:,317))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(365)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(318),h0tab(:,318),[64,16,15,32],[0,nMB,nMB,0],4,1,wf16(:,119))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(246),m3h2x64(:,294),heltab2x128(:,:,318))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(367)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(319),h0tab(:,319),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,34))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,295),heltab2x128(:,:,319))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(247),n2h64(241))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(369)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(320),h0tab(:,320),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,35))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,296),heltab2x128(:,:,320))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(248),n2h64(242))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(371)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(321),h0tab(:,321),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,120))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,297),heltab2x128(:,:,321))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(249),n2h64(243))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(373)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(322),h0tab(:,322),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,121))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,298),heltab2x128(:,:,322))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(250),n2h64(244))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(367)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(323),h0tab(:,323),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,34))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,299),heltab2x128(:,:,323))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(251),n2h64(245))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(369)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(324),h0tab(:,324),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,35))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,300),heltab2x128(:,:,324))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(252),n2h64(246))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(371)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(325),h0tab(:,325),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,120))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,301),heltab2x128(:,:,325))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(253),n2h64(247))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(373)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(326),h0tab(:,326),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,121))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,302),heltab2x128(:,:,326))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(254),n2h64(248))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(367)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(327),h0tab(:,327),[64,16,15,32],[0,nMB,nMB,0],4,1,wf16(:,34))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(255),m3h2x64(:,303),heltab2x128(:,:,327))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(369)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(328),h0tab(:,328),[64,16,15,32],[0,nMB,nMB,0],4,1,wf16(:,35))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(256),m3h2x64(:,304),heltab2x128(:,:,328))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(371)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(329),h0tab(:,329),[64,16,15,32],[0,nMB,nMB,0],4,1,wf16(:,120))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(257),m3h2x64(:,305),heltab2x128(:,:,329))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(373)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(330),h0tab(:,330),[64,16,15,32],[0,nMB,nMB,0],4,1,wf16(:,121))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(258),m3h2x64(:,306),heltab2x128(:,:,330))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(8),[G1H32(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(10),[G1H32(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(11),[G1H32(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(12),[G1H32(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(13),[G1H32(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(14),[G1H32(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(1),[G1H32(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(2),[G1H32(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(4),[G1H32(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(5),[G1H32(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(6),[G1H32(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(7),[G1H32(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H64(13),[G1H64(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H64(15),[G1H64(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H64(53),[G1H64(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H64(55),[G1H64(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H64(93),[G1H64(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H64(95),[G1H64(91)])
  call Hloop_QV_A(ntryL,G1H16(3),wf4(:,1),G1H4(21),m3h4x4(:,41),heltab2x16(:,:,57))
  call Hloop_Q_A(ntryL,G1H4(21),79,nMB,G2H4(5),n2h4(59))
  call Hloop_QZ_A(ntryL,G1H16(9),wf4(:,6),G1H4(32),ngZd,m3h4x4(:,42),heltab2x16(:,:,58))
  call Hloop_Q_A(ntryL,G1H4(32),79,nMB,G2H4(7),n2h4(60))
  call Hloop_QS_A(ntryL,G1H16(15),wf4(:,2),G1H4(43),ngH,m3h4x4(:,43),heltab2x16(:,:,59))
  call Hloop_Q_A(ntryL,G1H4(43),79,nMB,G2H4(8),n2h4(61))
  call Hloop_QV_A(ntryL,G1H16(21),wf4(:,7),G1H4(54),m3h4x4(:,44),heltab2x16(:,:,60))
  call Hloop_Q_A(ntryL,G1H4(54),79,nMB,G2H4(17),n2h4(62))
  call Hloop_QZ_A(ntryL,G1H16(27),wf4(:,9),G1H4(65),ngZd,m3h4x4(:,45),heltab2x16(:,:,61))
  call Hloop_Q_A(ntryL,G1H4(65),79,nMB,G2H4(19),n2h4(63))
  call Hloop_AV_Q(ntryL,G1H16(33),wf4(:,1),G1H4(76),m3h4x4(:,46),heltab2x16(:,:,62))
  call Hloop_A_Q(ntryL,G1H4(76),79,nMB,G2H4(20),n2h4(64))
  call Hloop_AZ_Q(ntryL,G1H16(39),wf4(:,6),G1H4(16),ngZd,m3h4x4(:,47),heltab2x16(:,:,63))
  call Hloop_A_Q(ntryL,G1H4(16),79,nMB,G2H4(25),n2h4(65))
  call Hloop_AS_Q(ntryL,G1H16(45),wf4(:,2),G1H4(17),ngH,m3h4x4(:,48),heltab2x16(:,:,64))
  call Hloop_A_Q(ntryL,G1H4(17),79,nMB,G2H4(27),n2h4(66))
  call Hloop_AV_Q(ntryL,G1H16(51),wf4(:,7),G1H4(22),m3h4x4(:,49),heltab2x16(:,:,65))
  call Hloop_A_Q(ntryL,G1H4(22),79,nMB,G2H4(28),n2h4(67))
  call Hloop_AZ_Q(ntryL,G1H16(57),wf4(:,9),G1H4(23),ngZd,m3h4x4(:,50),heltab2x16(:,:,66))
  call Hloop_A_Q(ntryL,G1H4(23),79,nMB,G2H4(37),n2h4(68))
  call Hloop_QV_A(ntryL,G1H32(8),wf4(:,1),G1H8(41),m3h4x8(:,49),heltab2x32(:,:,61))
  call Hloop_Q_A(ntryL,G1H8(41),83,nMB,G2H8(29),n2h8(70))
  call Hloop_QZ_A(ntryL,G1H32(10),wf4(:,6),G1H8(42),ngZd,m3h4x8(:,50),heltab2x32(:,:,62))
  call Hloop_Q_A(ntryL,G1H8(42),83,nMB,G2H8(31),n2h8(71))
  call Hloop_QV_A(ntryL,G1H32(11),wf4(:,1),G1H8(57),m3h4x8(:,51),heltab2x32(:,:,63))
  call Hloop_Q_A(ntryL,G1H8(57),83,nMB,G2H8(32),n2h8(72))
  call Hloop_QV_A(ntryL,G1H32(12),wf4(:,1),G1H8(58),m3h4x8(:,52),heltab2x32(:,:,64))
  call Hloop_Q_A(ntryL,G1H8(58),83,nMB,G2H8(49),n2h8(73))
  call Hloop_QZ_A(ntryL,G1H32(13),wf4(:,6),G1H8(73),ngZd,m3h4x8(:,53),heltab2x32(:,:,65))
  call Hloop_Q_A(ntryL,G1H8(73),83,nMB,G2H8(41),n2h8(74))
  call Hloop_QZ_A(ntryL,G1H32(14),wf4(:,6),G1H8(74),ngZd,m3h4x8(:,54),heltab2x32(:,:,66))
  call Hloop_Q_A(ntryL,G1H8(74),83,nMB,G2H8(51),n2h8(75))
  call Hloop_QS_A(ntryL,G1H32(1),wf4(:,2),G1H8(89),ngH,m3h4x8(:,55),heltab2x32(:,:,67))
  call Hloop_Q_A(ntryL,G1H8(89),92,nMB,G2H8(43),n2h8(76))
  call Hloop_QS_A(ntryL,G1H32(2),wf4(:,2),G1H8(90),ngH,m3h4x8(:,56),heltab2x32(:,:,68))
  call Hloop_Q_A(ntryL,G1H8(90),92,nMB,G2H8(52),n2h8(77))
  call Hloop_QV_A(ntryL,G1H32(4),wf4(:,7),G1H8(105),m3h4x8(:,57),heltab2x32(:,:,69))
  call Hloop_Q_A(ntryL,G1H8(105),92,nMB,G2H8(44),n2h8(78))
  call Hloop_QZ_A(ntryL,G1H32(5),wf4(:,9),G1H8(106),ngZd,m3h4x8(:,58),heltab2x32(:,:,70))
  call Hloop_Q_A(ntryL,G1H8(106),92,nMB,G2H8(57),n2h8(79))
  call Hloop_QV_A(ntryL,G1H32(6),wf4(:,7),G1H8(1),m3h4x8(:,59),heltab2x32(:,:,71))
  call Hloop_Q_A(ntryL,G1H8(1),92,nMB,G2H8(45),n2h8(80))
  call Hloop_QZ_A(ntryL,G1H32(7),wf4(:,9),G1H8(2),ngZd,m3h4x8(:,60),heltab2x32(:,:,72))
  call Hloop_Q_A(ntryL,G1H8(2),92,nMB,G2H8(59),n2h8(81))
  call Hloop_AV_Q(ntryL,G1H64(1),wf4(:,1),G1H16(16),m3h4x16(:,37),heltab2x64(:,:,49))
  call Hloop_A_Q(ntryL,G1H16(16),67,nMT,G2H16(14),n2h16(47))
  call Hloop_QV_A(ntryL,G1H64(2),wf4(:,1),G1H16(17),m3h4x16(:,38),heltab2x64(:,:,50))
  call Hloop_Q_A(ntryL,G1H16(17),67,nMT,G2H16(19),n2h16(48))
  call Hloop_AV_Q(ntryL,G1H64(3),wf4(:,1),G1H16(18),m3h4x16(:,39),heltab2x64(:,:,51))
  call Hloop_A_Q(ntryL,G1H16(18),67,nMB,G2H16(21),n2h16(49))
  call Hloop_QV_A(ntryL,G1H64(4),wf4(:,1),G1H16(19),m3h4x16(:,40),heltab2x64(:,:,52))
  call Hloop_Q_A(ntryL,G1H16(19),67,nMB,G2H16(22),n2h16(50))
  call Hloop_AZ_Q(ntryL,G1H64(5),wf4(:,6),G1H16(20),ngZu,m3h4x16(:,41),heltab2x64(:,:,53))
  call Hloop_A_Q(ntryL,G1H16(20),67,nMT,G2H16(25),n2h16(51))
  call Hloop_QZ_A(ntryL,G1H64(6),wf4(:,6),G1H16(22),ngZu,m3h4x16(:,42),heltab2x64(:,:,54))
  call Hloop_Q_A(ntryL,G1H16(22),67,nMT,G2H16(27),n2h16(52))
  call Hloop_AZ_Q(ntryL,G1H64(7),wf4(:,6),G1H16(23),ngZd,m3h4x16(:,43),heltab2x64(:,:,55))
  call Hloop_A_Q(ntryL,G1H16(23),67,nMB,G2H16(28),n2h16(53))
  call Hloop_QZ_A(ntryL,G1H64(8),wf4(:,6),G1H16(24),ngZd,m3h4x16(:,44),heltab2x64(:,:,56))
  call Hloop_Q_A(ntryL,G1H16(24),67,nMB,G2H16(31),n2h16(54))
  call Hloop_AV_Q(ntryL,G1H64(13),wf4(:,1),G1H16(25),m3h4x16(:,45),heltab2x64(:,:,57))
  call Hloop_A_Q(ntryL,G1H16(25),67,0,G2H16(33),n2h16(55))
  call Hloop_AV_Q(ntryL,G1H64(10),wf4(:,1),G1H16(26),m3h4x16(:,46),heltab2x64(:,:,58))
  call Hloop_A_Q(ntryL,G1H16(26),67,nMT,G2H16(34),n2h16(56))
  call Hloop_QV_A(ntryL,G1H64(15),wf4(:,1),G1H16(28),m3h4x16(:,47),heltab2x64(:,:,59))
  call Hloop_Q_A(ntryL,G1H16(28),67,0,G2H16(4),n2h16(57))
  call Hloop_QV_A(ntryL,G1H64(12),wf4(:,1),G1H16(29),m3h4x16(:,48),heltab2x64(:,:,60))
  call Hloop_Q_A(ntryL,G1H16(29),67,nMT,G2H16(6),n2h16(58))
  call Hloop_AV_Q(ntryL,G1H64(14),wf4(:,1),G1H16(30),m3h4x16(:,49),heltab2x64(:,:,61))
  call Hloop_A_Q(ntryL,G1H16(30),67,nMB,G2H16(8),n2h16(59))
  call Hloop_QV_A(ntryL,G1H64(16),wf4(:,1),G1H16(31),m3h4x16(:,50),heltab2x64(:,:,62))
  call Hloop_Q_A(ntryL,G1H16(31),67,nMB,G2H16(11),n2h16(60))
  call Hloop_AV_Q(ntryL,G1H64(17),wf4(:,1),G1H16(32),m3h4x16(:,51),heltab2x64(:,:,63))
  call Hloop_A_Q(ntryL,G1H16(32),67,0,G2H16(12),n2h16(61))
  call Hloop_AV_Q(ntryL,G1H64(18),wf4(:,1),G1H16(34),m3h4x16(:,52),heltab2x64(:,:,64))
  call Hloop_A_Q(ntryL,G1H16(34),67,nMT,G2H16(16),n2h16(62))
  call Hloop_QV_A(ntryL,G1H64(19),wf4(:,1),G1H16(35),m3h4x16(:,53),heltab2x64(:,:,65))
  call Hloop_Q_A(ntryL,G1H16(35),67,0,G2H16(18),n2h16(63))
  call Hloop_QV_A(ntryL,G1H64(20),wf4(:,1),G1H16(36),m3h4x16(:,54),heltab2x64(:,:,66))
  call Hloop_Q_A(ntryL,G1H16(36),67,nMT,G2H16(20),n2h16(64))
  call Hloop_AV_Q(ntryL,G1H64(21),wf4(:,1),G1H16(37),m3h4x16(:,55),heltab2x64(:,:,67))
  call Hloop_A_Q(ntryL,G1H16(37),67,0,G2H16(23),n2h16(65))
  call Hloop_AV_Q(ntryL,G1H64(22),wf4(:,1),G1H16(38),m3h4x16(:,56),heltab2x64(:,:,68))
  call Hloop_A_Q(ntryL,G1H16(38),67,nMB,G2H16(24),n2h16(66))
  call Hloop_QV_A(ntryL,G1H64(23),wf4(:,1),G1H16(40),m3h4x16(:,57),heltab2x64(:,:,69))
  call Hloop_Q_A(ntryL,G1H16(40),67,0,G2H16(26),n2h16(67))
  call Hloop_QV_A(ntryL,G1H64(24),wf4(:,1),G1H16(41),m3h4x16(:,58),heltab2x64(:,:,70))
  call Hloop_Q_A(ntryL,G1H16(41),67,nMB,G2H16(29),n2h16(68))
  call Hloop_AZ_Q(ntryL,G1H64(25),wf4(:,6),G1H16(42),ngZu,m3h4x16(:,59),heltab2x64(:,:,71))
  call Hloop_A_Q(ntryL,G1H16(42),67,0,G2H16(30),n2h16(69))
  call Hloop_AZ_Q(ntryL,G1H64(26),wf4(:,6),G1H16(43),ngZu,m3h4x16(:,60),heltab2x64(:,:,72))
  call Hloop_A_Q(ntryL,G1H16(43),67,nMT,G2H16(32),n2h16(70))
  call Hloop_QZ_A(ntryL,G1H64(27),wf4(:,6),G1H16(44),ngZu,m3h4x16(:,61),heltab2x64(:,:,73))
  call Hloop_Q_A(ntryL,G1H16(44),67,0,G2H16(35),n2h16(71))
  call Hloop_QZ_A(ntryL,G1H64(28),wf4(:,6),G1H16(46),ngZu,m3h4x16(:,62),heltab2x64(:,:,74))
  call Hloop_Q_A(ntryL,G1H16(46),67,nMT,G2H16(36),n2h16(72))
  call Hloop_AZ_Q(ntryL,G1H64(29),wf4(:,6),G1H16(47),ngZd,m3h4x16(:,63),heltab2x64(:,:,75))
  call Hloop_A_Q(ntryL,G1H16(47),67,0,G2H16(3),n2h16(73))
  call Hloop_AZ_Q(ntryL,G1H64(30),wf4(:,6),G1H16(48),ngZd,m3h4x16(:,64),heltab2x64(:,:,76))
  call Hloop_A_Q(ntryL,G1H16(48),67,nMB,G2H16(1),n2h16(74))
  call Hloop_QZ_A(ntryL,G1H64(31),wf4(:,6),G1H16(49),ngZd,m3h4x16(:,65),heltab2x64(:,:,77))
  call Hloop_Q_A(ntryL,G1H16(49),67,0,G2H16(5),n2h16(75))
  call Hloop_QZ_A(ntryL,G1H64(32),wf4(:,6),G1H16(50),ngZd,m3h4x16(:,66),heltab2x64(:,:,78))
  call Hloop_Q_A(ntryL,G1H16(50),67,nMB,G2H16(2),n2h16(76))
  call Hloop_AZ_Q(ntryL,G1H64(33),wf4(:,6),G1H16(52),ngZu,m3h4x16(:,67),heltab2x64(:,:,79))
  call Hloop_A_Q(ntryL,G1H16(52),67,0,G2H16(7),n2h16(77))
  call Hloop_AZ_Q(ntryL,G1H64(34),wf4(:,6),G1H16(53),ngZu,m3h4x16(:,68),heltab2x64(:,:,80))
  call Hloop_A_Q(ntryL,G1H16(53),67,nMT,G2H16(9),n2h16(78))
  call Hloop_QZ_A(ntryL,G1H64(35),wf4(:,6),G1H16(54),ngZu,m3h4x16(:,69),heltab2x64(:,:,81))
  call Hloop_Q_A(ntryL,G1H16(54),67,0,G2H16(10),n2h16(79))
  call Hloop_QZ_A(ntryL,G1H64(36),wf4(:,6),G1H16(55),ngZu,m3h4x16(:,70),heltab2x64(:,:,82))
  call Hloop_Q_A(ntryL,G1H16(55),67,nMT,G2H16(15),n2h16(80))
  call Hloop_AZ_Q(ntryL,G1H64(37),wf4(:,6),G1H16(56),ngZd,m3h4x16(:,71),heltab2x64(:,:,83))
  call Hloop_A_Q(ntryL,G1H16(56),67,0,G2H16(13),n2h16(81))
  call Hloop_AZ_Q(ntryL,G1H64(38),wf4(:,6),G1H16(58),ngZd,m3h4x16(:,72),heltab2x64(:,:,84))
  call Hloop_A_Q(ntryL,G1H16(58),67,nMB,G2H16(17),n2h16(82))
  call Hloop_QZ_A(ntryL,G1H64(39),wf4(:,6),G1H16(59),ngZd,m3h4x16(:,73),heltab2x64(:,:,85))
  call Hloop_Q_A(ntryL,G1H16(59),67,0,G2H16(37),n2h16(83))
  call Hloop_QZ_A(ntryL,G1H64(40),wf4(:,6),G1H16(60),ngZd,m3h4x16(:,74),heltab2x64(:,:,86))



end subroutine vamp_1

end module ol_vamp_1_ppllllj_eexmmxbbxg_1_/**/REALKIND
