
! **********************************************************************
module ol_tables_storage_ppllllj_neeexexuxdg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  ! helicity tables for the 1-loop recursion
integer(intkind2), save :: h0tab(128,436)
integer(intkind2), save :: heltab2x2(2,2,161)
integer(intkind2), save :: heltab2x4(2,4,199)
integer(intkind2), save :: heltab2x8(2,8,294)
integer(intkind2), save :: heltab2x16(2,16,146)
integer(intkind2), save :: heltab2x32(2,32,256)
integer(intkind2), save :: heltab2x64(2,64,268)
integer(intkind2), save :: heltab2x128(2,128,436)


  ! number of helicity states for openloops recursion steps
integer(intkind2), save :: m0h(436)
integer(intkind2), save :: m3h2x1(3,161)
integer(intkind2), save :: m3h4x1(3,165)
integer(intkind2), save :: m3h8x1(3,102)
integer(intkind2), save :: m3h16x1(3,36)
integer(intkind2), save :: m3h32x1(3,80)
integer(intkind2), save :: m3h2x2(3,34)
integer(intkind2), save :: m3h4x2(3,126)
integer(intkind2), save :: m3h8x2(3,12)
integer(intkind2), save :: m3h16x2(3,60)
integer(intkind2), save :: m3h32x2(3,40)
integer(intkind2), save :: m3h2x4(3,66)
integer(intkind2), save :: m3h4x4(3,68)
integer(intkind2), save :: m3h8x4(3,8)
integer(intkind2), save :: m3h16x4(3,24)
integer(intkind2), save :: m3h2x8(3,30)
integer(intkind2), save :: m3h4x8(3,88)
integer(intkind2), save :: m3h8x8(3,24)
integer(intkind2), save :: m3h16x8(3,64)
integer(intkind2), save :: m3h2x16(3,20)
integer(intkind2), save :: m3h4x16(3,112)
integer(intkind2), save :: m3h2x32(3,68)
integer(intkind2), save :: m3h4x32(3,96)
integer(intkind2), save :: m3h2x64(3,276)

integer(intkind2), save :: n2h1(425)
integer(intkind2), save :: n2h2(200)
integer(intkind2), save :: n2h4(122)
integer(intkind2), save :: n2h8(210)
integer(intkind2), save :: n2h16(124)
integer(intkind2), save :: n2h32(144)
integer(intkind2), save :: n2h64(192)


contains

!**********************************************************************
subroutine HOL_m3_init()
!**********************************************************************
! initialize m3 arrays for helicity summation
!**********************************************************************
  use KIND_TYPES, only: REALKIND, intkind2

m3h2x1(1,:)=2
m3h2x1(2,:)=1
m3h2x1(3,:)=2
m3h4x1(1,:)=4
m3h4x1(2,:)=1
m3h4x1(3,:)=4
m3h8x1(1,:)=8
m3h8x1(2,:)=1
m3h8x1(3,:)=8
m3h16x1(1,:)=16
m3h16x1(2,:)=1
m3h16x1(3,:)=16
m3h32x1(1,:)=32
m3h32x1(2,:)=1
m3h32x1(3,:)=32
m3h2x2(1,:)=2
m3h2x2(2,:)=2
m3h2x2(3,:)=4
m3h4x2(1,:)=4
m3h4x2(2,:)=2
m3h4x2(3,:)=8
m3h8x2(1,:)=8
m3h8x2(2,:)=2
m3h8x2(3,:)=16
m3h16x2(1,:)=16
m3h16x2(2,:)=2
m3h16x2(3,:)=32
m3h32x2(1,:)=32
m3h32x2(2,:)=2
m3h32x2(3,:)=64
m3h2x4(1,:)=2
m3h2x4(2,:)=4
m3h2x4(3,:)=8
m3h4x4(1,:)=4
m3h4x4(2,:)=4
m3h4x4(3,:)=16
m3h8x4(1,:)=8
m3h8x4(2,:)=4
m3h8x4(3,:)=32
m3h16x4(1,:)=16
m3h16x4(2,:)=4
m3h16x4(3,:)=64
m3h2x8(1,:)=2
m3h2x8(2,:)=8
m3h2x8(3,:)=16
m3h4x8(1,:)=4
m3h4x8(2,:)=8
m3h4x8(3,:)=32
m3h8x8(1,:)=8
m3h8x8(2,:)=8
m3h8x8(3,:)=64
m3h16x8(1,:)=16
m3h16x8(2,:)=8
m3h16x8(3,:)=128
m3h2x16(1,:)=2
m3h2x16(2,:)=16
m3h2x16(3,:)=32
m3h4x16(1,:)=4
m3h4x16(2,:)=16
m3h4x16(3,:)=64
m3h2x32(1,:)=2
m3h2x32(2,:)=32
m3h2x32(3,:)=64
m3h4x32(1,:)=4
m3h4x32(2,:)=32
m3h4x32(3,:)=128
m3h2x64(1,:)=2
m3h2x64(2,:)=64
m3h2x64(3,:)=128

n2h1(:)=1
n2h2(:)=2
n2h4(:)=4
n2h8(:)=8
n2h16(:)=16
n2h32(:)=32
n2h64(:)=64


end subroutine HOL_m3_init

!**********************************************************************

end module ol_tables_storage_ppllllj_neeexexuxdg_1_/**/REALKIND

! **********************************************************************
module ol_tensor_sum_storage_ppllllj_neeexexuxdg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol, hcl, met
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  type(met), save :: M2L1R1

  ! Declarations of loop wave function tensors

  type(hol), save :: G0H1(1)
  type(hol), save :: G1H1(1)
  type(hol), save :: G2H1(1)
  type(hol), save :: G1H2(94)
  type(hol), save :: G2H2(168)
  type(hol), save :: G1H4(149)
  type(hol), save :: G2H4(54)
  type(hol), save :: G0H8(1)
  type(hol), save :: G1H8(132)
  type(hol), save :: G2H8(50)
  type(hol), save :: G1H16(72)
  type(hol), save :: G2H16(56)
  type(hol), save :: G0H32(29)
  type(hol), save :: G1H32(100)
  type(hol), save :: G2H32(20)
  type(hol), save :: G0H64(1)
  type(hol), save :: G1H64(160)
  type(hol), save :: G0H128(1)
  type(hcl), save, dimension(320) :: G0tensor
  type(hcl), save, dimension(305) :: G1tensor
  type(hcl), save, dimension(345) :: G2tensor
  type(hcl), save, dimension(24) :: G3tensor



  ! Declarations for on-the-fly tensor reduction
type (basis),      save :: RedBasis(108)
type (redset4),    save :: RedSet_4(77)
type (redset5),    save :: RedSet_5(16)
integer, save :: mass2set(0:1,1)
integer, save :: mass3set(0:2,3)
integer, save :: mass4set(0:3,1)
integer, save :: mass5set(0:4,1)



  ! Declarations for TI calls

  integer, save :: momenta_1(2)
  integer, save :: momenta_2(2)
  integer, save :: momenta_3(2)
  integer, save :: momenta_4(2)
  integer, save :: momenta_5(2)
  integer, save :: momenta_6(2)
  integer, save :: momenta_7(2)
  integer, save :: momenta_8(2)
  integer, save :: momenta_9(2)
  integer, save :: momenta_10(2)
  integer, save :: momenta_11(2)
  integer, save :: momenta_12(2)
  integer, save :: momenta_13(2)
  integer, save :: momenta_14(2)
  integer, save :: momenta_15(2)
  integer, save :: momenta_16(2)
  integer, save :: momenta_17(2)
  integer, save :: momenta_18(2)
  integer, save :: momenta_19(2)
  integer, save :: momenta_20(2)
  integer, save :: momenta_21(2)
  integer, save :: momenta_22(2)
  integer, save :: momenta_23(2)
  integer, save :: momenta_24(2)
  integer, save :: momenta_25(3)
  integer, save :: momenta_26(3)
  integer, save :: momenta_27(3)
  integer, save :: momenta_28(3)
  integer, save :: momenta_29(3)
  integer, save :: momenta_30(3)
  integer, save :: momenta_31(3)
  integer, save :: momenta_32(3)
  integer, save :: momenta_33(3)
  integer, save :: momenta_34(3)
  integer, save :: momenta_35(3)
  integer, save :: momenta_36(3)
  integer, save :: momenta_37(3)
  integer, save :: momenta_38(3)
  integer, save :: momenta_39(3)
  integer, save :: momenta_40(3)
  integer, save :: momenta_41(3)
  integer, save :: momenta_42(3)
  integer, save :: momenta_43(3)
  integer, save :: momenta_44(3)
  integer, save :: momenta_45(3)
  integer, save :: momenta_46(3)
  integer, save :: momenta_47(3)
  integer, save :: momenta_48(3)
  integer, save :: momenta_49(3)
  integer, save :: momenta_50(3)
  integer, save :: momenta_51(3)
  integer, save :: momenta_52(3)
  integer, save :: momenta_53(3)
  integer, save :: momenta_54(3)
  integer, save :: momenta_55(3)
  integer, save :: momenta_56(3)
  integer, save :: momenta_57(3)
  integer, save :: momenta_58(3)
  integer, save :: momenta_59(3)
  integer, save :: momenta_60(3)
  integer, save :: momenta_61(3)
  integer, save :: momenta_62(3)
  integer, save :: momenta_63(3)
  integer, save :: momenta_64(3)
  integer, save :: momenta_65(3)
  integer, save :: momenta_66(3)
  integer, save :: momenta_67(3)
  integer, save :: momenta_68(3)
  integer, save :: momenta_69(3)
  integer, save :: momenta_70(3)
  integer, save :: momenta_71(3)
  integer, save :: momenta_72(3)
  integer, save :: momenta_73(3)
  integer, save :: momenta_74(3)
  integer, save :: momenta_75(3)
  integer, save :: momenta_76(3)
  integer, save :: momenta_77(3)
  integer, save :: momenta_78(3)
  integer, save :: momenta_79(3)
  integer, save :: momenta_80(3)
  integer, save :: momenta_81(3)
  integer, save :: momenta_82(3)
  integer, save :: momenta_83(3)
  integer, save :: momenta_84(3)
  integer, save :: momenta_85(3)
  integer, save :: momenta_86(3)
  integer, save :: momenta_87(3)
  integer, save :: momenta_88(3)
  integer, save :: momenta_89(3)
  integer, save :: momenta_90(3)
  integer, save :: momenta_91(3)
  integer, save :: momenta_92(3)
  integer, save :: momenta_93(3)
  integer, save :: momenta_94(3)
  integer, save :: momenta_95(3)
  integer, save :: momenta_96(3)
  integer, save :: momenta_97(3)
  integer, save :: momenta_98(3)
  integer, save :: momenta_99(3)
  integer, save :: momenta_100(4)
  integer, save :: momenta_101(4)
  integer, save :: momenta_102(4)
  integer, save :: momenta_103(4)
  integer, save :: momenta_104(4)
  integer, save :: momenta_105(4)
  integer, save :: momenta_106(4)
  integer, save :: momenta_107(4)
  integer, save :: momenta_108(4)
  integer, save :: momenta_109(4)
  integer, save :: momenta_110(4)
  integer, save :: momenta_111(4)
  integer, save :: momenta_112(4)
  integer, save :: momenta_113(4)
  integer, save :: momenta_114(4)
  integer, save :: momenta_115(4)
  integer, save :: momenta_116(4)
  integer, save :: momenta_117(4)
  integer, save :: momenta_118(4)
  integer, save :: momenta_119(4)
  integer, save :: momenta_120(4)
  integer, save :: momenta_121(4)
  integer, save :: momenta_122(4)
  integer, save :: momenta_123(4)
  integer, save :: momenta_124(4)
  integer, save :: momenta_125(4)
  integer, save :: momenta_126(4)
  integer, save :: momenta_127(4)
  integer, save :: momenta_128(4)
  integer, save :: momenta_129(4)
  integer, save :: momenta_130(4)
  integer, save :: momenta_131(4)
  integer, save :: momenta_132(4)
  integer, save :: momenta_133(4)
  integer, save :: momenta_134(4)
  integer, save :: momenta_135(4)
  integer, save :: momenta_136(4)
  integer, save :: momenta_137(4)
  integer, save :: momenta_138(4)
  integer, save :: momenta_139(4)
  integer, save :: momenta_140(4)
  integer, save :: momenta_141(4)
  integer, save :: momenta_142(4)
  integer, save :: momenta_143(4)
  integer, save :: momenta_144(4)
  integer, save :: momenta_145(4)
  integer, save :: momenta_146(4)
  integer, save :: momenta_147(4)
  integer, save :: momenta_148(4)
  integer, save :: momenta_149(4)
  integer, save :: momenta_150(4)
  integer, save :: momenta_151(4)
  integer, save :: momenta_152(4)
  integer, save :: momenta_153(4)
  integer, save :: momenta_154(4)
  integer, save :: momenta_155(4)
  integer, save :: momenta_156(4)
  integer, save :: momenta_157(4)
  integer, save :: momenta_158(4)
  integer, save :: momenta_159(4)
  integer, save :: momenta_160(4)
  integer, save :: momenta_161(5)
  integer, save :: momenta_162(5)
  integer, save :: momenta_163(5)
  integer, save :: momenta_164(5)
  integer, save :: momenta_165(5)
  integer, save :: momenta_166(5)
  integer, save :: momenta_167(5)
  integer, save :: momenta_168(5)
  integer, save :: momenta_169(5)
  integer, save :: momenta_170(5)
  integer, save :: momenta_171(5)
  integer, save :: momenta_172(5)
  integer, save :: momenta_173(5)
  integer, save :: momenta_174(5)
  integer, save :: momenta_175(5)
  integer, save :: momenta_176(5)

  integer, save :: masses2_1(2)
  integer, save :: masses2_2(2)
  integer, save :: masses2_3(2)
  integer, save :: masses2_4(2)
  integer, save :: masses2_5(2)
  integer, save :: masses2_6(3)
  integer, save :: masses2_7(3)
  integer, save :: masses2_8(3)
  integer, save :: masses2_9(4)
  integer, save :: masses2_10(5)

type(scalarbox), save :: ScalarBoxes(65)

integer, save :: sbarray_1(5)
integer, save :: sbarray_2(5)
integer, save :: sbarray_3(5)
integer, save :: sbarray_4(5)
integer, save :: sbarray_5(5)
integer, save :: sbarray_6(5)
integer, save :: sbarray_7(5)
integer, save :: sbarray_8(5)
integer, save :: sbarray_9(5)
integer, save :: sbarray_10(5)
integer, save :: sbarray_11(5)
integer, save :: sbarray_12(5)
integer, save :: sbarray_13(5)
integer, save :: sbarray_14(5)
integer, save :: sbarray_15(5)
integer, save :: sbarray_16(5)

  type(hcl), save, dimension(175) :: T0sum
  type(hcl), save, dimension(16) :: T1sum


  contains

!**********************************************************************
subroutine HOL_memory_allocation_full()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_loop_storage_ppllllj_neeexexuxdg_1_/**/DREALKIND, only: nhel
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none

    call hol_allocation(4,1,4,1,G0H1,1)
  call hol_allocation(4,5,4,1,G1H1,1)
  call hol_allocation(4,15,4,1,G2H1,1)
  call hol_allocation(4,5,4,2,G1H2,94)
  call hol_allocation(4,15,4,2,G2H2,168)
  call hol_allocation(4,5,4,4,G1H4,149)
  call hol_allocation(4,15,4,4,G2H4,54)
  call hol_allocation(4,1,4,8,G0H8,1)
  call hol_allocation(4,5,4,8,G1H8,132)
  call hol_allocation(4,15,4,8,G2H8,50)
  call hol_allocation(4,5,4,16,G1H16,72)
  call hol_allocation(4,15,4,16,G2H16,56)
  call hol_allocation(4,1,4,32,G0H32,29)
  call hol_allocation(4,5,4,32,G1H32,100)
  call hol_allocation(4,15,4,32,G2H32,20)
  call hol_allocation(4,1,4,64,G0H64,1)
  call hol_allocation(4,5,4,64,G1H64,160)
  call hol_allocation(4,1,4,128,G0H128,1)


end subroutine HOL_memory_allocation_full

!**********************************************************************
subroutine HOL_memory_allocation_optimized()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_loop_storage_ppllllj_neeexexuxdg_1_/**/DREALKIND, only: nhel
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none

    call hol_allocation(4,1,4,min(nhel,1),G0H1,1)
  call hol_allocation(4,5,4,min(nhel,1),G1H1,1)
  call hol_allocation(4,15,4,min(nhel,1),G2H1,1)
  call hol_allocation(4,5,4,min(nhel,2),G1H2,94)
  call hol_allocation(4,15,4,min(nhel,2),G2H2,168)
  call hol_allocation(4,5,4,min(nhel,4),G1H4,149)
  call hol_allocation(4,15,4,min(nhel,4),G2H4,54)
  call hol_allocation(4,1,4,min(nhel,8),G0H8,1)
  call hol_allocation(4,5,4,min(nhel,8),G1H8,132)
  call hol_allocation(4,15,4,min(nhel,8),G2H8,50)
  call hol_allocation(4,5,4,min(nhel,16),G1H16,72)
  call hol_allocation(4,15,4,min(nhel,16),G2H16,56)
  call hol_allocation(4,1,4,min(nhel,32),G0H32,29)
  call hol_allocation(4,5,4,min(nhel,32),G1H32,100)
  call hol_allocation(4,15,4,min(nhel,32),G2H32,20)
  call hol_allocation(4,1,4,min(nhel,64),G0H64,1)
  call hol_allocation(4,5,4,min(nhel,64),G1H64,160)
  call hol_allocation(4,1,4,min(nhel,128),G0H128,1)


end subroutine HOL_memory_allocation_optimized

!**********************************************************************
subroutine HOL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_deallocation
  implicit none
  integer,   intent(in)    :: dmode

    call hol_deallocation(G0H1,1,dmode)
  call hol_deallocation(G1H1,1,dmode)
  call hol_deallocation(G2H1,1,dmode)
  call hol_deallocation(G1H2,94,dmode)
  call hol_deallocation(G2H2,168,dmode)
  call hol_deallocation(G1H4,149,dmode)
  call hol_deallocation(G2H4,54,dmode)
  call hol_deallocation(G0H8,1,dmode)
  call hol_deallocation(G1H8,132,dmode)
  call hol_deallocation(G2H8,50,dmode)
  call hol_deallocation(G1H16,72,dmode)
  call hol_deallocation(G2H16,56,dmode)
  call hol_deallocation(G0H32,29,dmode)
  call hol_deallocation(G1H32,100,dmode)
  call hol_deallocation(G2H32,20,dmode)
  call hol_deallocation(G0H64,1,dmode)
  call hol_deallocation(G1H64,160,dmode)
  call hol_deallocation(G0H128,1,dmode)


end subroutine HOL_memory_deallocation_/**/REALKIND

!**********************************************************************
subroutine HCL_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

  call hcl_allocation(1,G0tensor, 320)
call hcl_allocation(5,G1tensor, 305)
call hcl_allocation(15,G2tensor, 345)
call hcl_allocation(35,G3tensor, 24)


end subroutine HCL_memory_allocation


!**********************************************************************
subroutine HCL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! deallocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_deallocation
  implicit none
  integer,   intent(in)    :: dmode

  call hcl_deallocation(G0tensor, 320,dmode)
call hcl_deallocation(G1tensor, 305,dmode)
call hcl_deallocation(G2tensor, 345,dmode)
call hcl_deallocation(G3tensor, 24,dmode)

    call hcl_deallocation(T0sum,175,dmode)
  call hcl_deallocation(T1sum,16,dmode)


end subroutine HCL_memory_deallocation_/**/REALKIND


!**********************************************************************
subroutine Tsum_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

    call hcl_allocation(1,T0sum,175)
  call hcl_allocation(5,T1sum,16)


end subroutine Tsum_memory_allocation


#ifdef PRECISION_dp
subroutine max_point(r) &
    & bind(c,name="ol_f_max_point_ppllllj_neeexexuxdg_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 5
end subroutine max_point

subroutine tensor_rank(r) &
    & bind(c,name="ol_f_tensor_rank_ppllllj_neeexexuxdg_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 1
end subroutine tensor_rank
#endif

subroutine reset_tensor_sum()
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  use ol_parameters_init_/**/REALKIND, only: init_hcl
  implicit none
  integer :: i

  do i = 1,175
    call init_hcl(T0sum(i))
  end do
  do i = 1,16
    call init_hcl(T1sum(i))
  end do

end subroutine reset_tensor_sum


subroutine scale_one_tsum(tsum, spow)
  use ol_parameters_decl_/**/REALKIND, only: scalefactor
  implicit none
  complex(REALKIND), intent(inout) :: tsum(:)
  integer, intent(in) :: spow ! rank 0 scale power
  real(REALKIND) :: sfinv, sfac
  integer :: sz
  sfinv = 1/scalefactor
  sfac = scalefactor**spow
  sz = size(tsum)
  tsum(1) = sfac*tsum(1)
  if (sz > 1) then ! rank 1
    sfac = sfac*sfinv
    tsum(2:5) = sfac*tsum(2:5)
  end if
  if (sz > 5) then ! rank 2
    sfac = sfac*sfinv
    tsum(6:15) = sfac*tsum(6:15)
  end if
  if (sz > 15) then ! rank 3
    sfac = sfac*sfinv
    tsum(16:35) = sfac*tsum(16:35)
  end if
  if (sz > 35) then ! rank 4
    sfac = sfac*sfinv
    tsum(36:70) = sfac*tsum(36:70)
  end if
  if (sz > 70) then ! rank 5
    sfac = sfac*sfinv
    tsum(71:126) = sfac*tsum(71:126)
  end if
  if (sz > 126) then ! rank 6
    sfac = sfac*sfinv
    tsum(127:210) = sfac*tsum(127:210)
  end if
  if (sz > 210) then ! rank 7
    sfac = sfac*sfinv
    tsum(211:330) = sfac*tsum(211:330)
  end if
end subroutine scale_one_tsum


subroutine scale_tensor_sum()
  implicit none
  call scale_one_tsum(T1sum(1)%cmp, 0)
  call scale_one_tsum(T1sum(2)%cmp, 0)
  call scale_one_tsum(T1sum(3)%cmp, 0)
  call scale_one_tsum(T1sum(4)%cmp, 0)
  call scale_one_tsum(T1sum(5)%cmp, 0)
  call scale_one_tsum(T1sum(6)%cmp, 0)
  call scale_one_tsum(T1sum(7)%cmp, 0)
  call scale_one_tsum(T1sum(8)%cmp, 0)
  call scale_one_tsum(T1sum(9)%cmp, 0)
  call scale_one_tsum(T1sum(10)%cmp, 0)
  call scale_one_tsum(T1sum(11)%cmp, 0)
  call scale_one_tsum(T1sum(12)%cmp, 0)
  call scale_one_tsum(T1sum(13)%cmp, 0)
  call scale_one_tsum(T1sum(14)%cmp, 0)
  call scale_one_tsum(T1sum(15)%cmp, 0)
  call scale_one_tsum(T1sum(16)%cmp, 0)
  call scale_one_tsum(T0sum(1)%cmp, -2)
  call scale_one_tsum(T0sum(2)%cmp, -2)
  call scale_one_tsum(T0sum(3)%cmp, -2)
  call scale_one_tsum(T0sum(4)%cmp, -2)
  call scale_one_tsum(T0sum(5)%cmp, -2)
  call scale_one_tsum(T0sum(6)%cmp, -2)
  call scale_one_tsum(T0sum(7)%cmp, -2)
  call scale_one_tsum(T0sum(8)%cmp, -2)
  call scale_one_tsum(T0sum(9)%cmp, -2)
  call scale_one_tsum(T0sum(10)%cmp, -2)
  call scale_one_tsum(T0sum(11)%cmp, -2)
  call scale_one_tsum(T0sum(12)%cmp, -2)
  call scale_one_tsum(T0sum(13)%cmp, -2)
  call scale_one_tsum(T0sum(14)%cmp, -2)
  call scale_one_tsum(T0sum(15)%cmp, -2)
  call scale_one_tsum(T0sum(16)%cmp, -2)
  call scale_one_tsum(T0sum(17)%cmp, -2)
  call scale_one_tsum(T0sum(18)%cmp, -2)
  call scale_one_tsum(T0sum(19)%cmp, -2)
  call scale_one_tsum(T0sum(20)%cmp, -2)
  call scale_one_tsum(T0sum(21)%cmp, -2)
  call scale_one_tsum(T0sum(22)%cmp, -2)
  call scale_one_tsum(T0sum(23)%cmp, -2)
  call scale_one_tsum(T0sum(24)%cmp, -2)
  call scale_one_tsum(T0sum(25)%cmp, -2)
  call scale_one_tsum(T0sum(26)%cmp, -2)
  call scale_one_tsum(T0sum(27)%cmp, -2)
  call scale_one_tsum(T0sum(28)%cmp, -2)
  call scale_one_tsum(T0sum(29)%cmp, -2)
  call scale_one_tsum(T0sum(30)%cmp, -2)
  call scale_one_tsum(T0sum(31)%cmp, -2)
  call scale_one_tsum(T0sum(32)%cmp, -2)
  call scale_one_tsum(T0sum(33)%cmp, -2)
  call scale_one_tsum(T0sum(34)%cmp, -2)
  call scale_one_tsum(T0sum(35)%cmp, -2)
  call scale_one_tsum(T0sum(36)%cmp, -2)
  call scale_one_tsum(T0sum(37)%cmp, -2)
  call scale_one_tsum(T0sum(38)%cmp, -2)
  call scale_one_tsum(T0sum(39)%cmp, -2)
  call scale_one_tsum(T0sum(40)%cmp, -2)
  call scale_one_tsum(T0sum(41)%cmp, -2)
  call scale_one_tsum(T0sum(42)%cmp, -2)
  call scale_one_tsum(T0sum(43)%cmp, -2)
  call scale_one_tsum(T0sum(44)%cmp, -2)
  call scale_one_tsum(T0sum(45)%cmp, -2)
  call scale_one_tsum(T0sum(46)%cmp, -2)
  call scale_one_tsum(T0sum(47)%cmp, -2)
  call scale_one_tsum(T0sum(48)%cmp, -2)
  call scale_one_tsum(T0sum(49)%cmp, -2)
  call scale_one_tsum(T0sum(50)%cmp, -2)
  call scale_one_tsum(T0sum(51)%cmp, -2)
  call scale_one_tsum(T0sum(52)%cmp, -2)
  call scale_one_tsum(T0sum(53)%cmp, -2)
  call scale_one_tsum(T0sum(54)%cmp, -2)
  call scale_one_tsum(T0sum(55)%cmp, -2)
  call scale_one_tsum(T0sum(56)%cmp, -2)
  call scale_one_tsum(T0sum(57)%cmp, -2)
  call scale_one_tsum(T0sum(58)%cmp, -2)
  call scale_one_tsum(T0sum(59)%cmp, -2)
  call scale_one_tsum(T0sum(60)%cmp, -2)
  call scale_one_tsum(T0sum(61)%cmp, -2)
  call scale_one_tsum(T0sum(62)%cmp, -4)
  call scale_one_tsum(T0sum(63)%cmp, -4)
  call scale_one_tsum(T0sum(64)%cmp, -4)
  call scale_one_tsum(T0sum(65)%cmp, -4)
  call scale_one_tsum(T0sum(66)%cmp, -4)
  call scale_one_tsum(T0sum(67)%cmp, -4)
  call scale_one_tsum(T0sum(68)%cmp, -4)
  call scale_one_tsum(T0sum(69)%cmp, -4)
  call scale_one_tsum(T0sum(70)%cmp, -4)
  call scale_one_tsum(T0sum(71)%cmp, -4)
  call scale_one_tsum(T0sum(72)%cmp, -4)
  call scale_one_tsum(T0sum(73)%cmp, -4)
  call scale_one_tsum(T0sum(74)%cmp, -4)
  call scale_one_tsum(T0sum(75)%cmp, -4)
  call scale_one_tsum(T0sum(76)%cmp, -4)
  call scale_one_tsum(T0sum(77)%cmp, -4)
  call scale_one_tsum(T0sum(78)%cmp, -4)
  call scale_one_tsum(T0sum(79)%cmp, -4)
  call scale_one_tsum(T0sum(80)%cmp, -4)
  call scale_one_tsum(T0sum(81)%cmp, -4)
  call scale_one_tsum(T0sum(82)%cmp, -4)
  call scale_one_tsum(T0sum(83)%cmp, -4)
  call scale_one_tsum(T0sum(84)%cmp, -4)
  call scale_one_tsum(T0sum(85)%cmp, -4)
  call scale_one_tsum(T0sum(86)%cmp, -4)
  call scale_one_tsum(T0sum(87)%cmp, -4)
  call scale_one_tsum(T0sum(88)%cmp, -4)
  call scale_one_tsum(T0sum(89)%cmp, -4)
  call scale_one_tsum(T0sum(90)%cmp, -4)
  call scale_one_tsum(T0sum(91)%cmp, -4)
  call scale_one_tsum(T0sum(92)%cmp, -4)
  call scale_one_tsum(T0sum(93)%cmp, -4)
  call scale_one_tsum(T0sum(94)%cmp, -4)
  call scale_one_tsum(T0sum(95)%cmp, -4)
  call scale_one_tsum(T0sum(96)%cmp, -4)
  call scale_one_tsum(T0sum(97)%cmp, -4)
  call scale_one_tsum(T0sum(98)%cmp, -4)
  call scale_one_tsum(T0sum(99)%cmp, -4)
  call scale_one_tsum(T0sum(100)%cmp, -4)
  call scale_one_tsum(T0sum(101)%cmp, -4)
  call scale_one_tsum(T0sum(102)%cmp, -4)
  call scale_one_tsum(T0sum(103)%cmp, -4)
  call scale_one_tsum(T0sum(104)%cmp, -4)
  call scale_one_tsum(T0sum(105)%cmp, -4)
  call scale_one_tsum(T0sum(106)%cmp, -4)
  call scale_one_tsum(T0sum(107)%cmp, -4)
  call scale_one_tsum(T0sum(108)%cmp, -4)
  call scale_one_tsum(T0sum(109)%cmp, -4)
  call scale_one_tsum(T0sum(110)%cmp, -4)
  call scale_one_tsum(T0sum(111)%cmp, -4)
  call scale_one_tsum(T0sum(112)%cmp, -4)
  call scale_one_tsum(T0sum(113)%cmp, -4)
  call scale_one_tsum(T0sum(114)%cmp, -4)
  call scale_one_tsum(T0sum(115)%cmp, -4)
  call scale_one_tsum(T0sum(116)%cmp, -4)
  call scale_one_tsum(T0sum(117)%cmp, -4)
  call scale_one_tsum(T0sum(118)%cmp, -4)
  call scale_one_tsum(T0sum(119)%cmp, -4)
  call scale_one_tsum(T0sum(120)%cmp, -4)
  call scale_one_tsum(T0sum(121)%cmp, -4)
  call scale_one_tsum(T0sum(122)%cmp, -4)
  call scale_one_tsum(T0sum(123)%cmp, -4)
  call scale_one_tsum(T0sum(124)%cmp, -4)
  call scale_one_tsum(T0sum(125)%cmp, -4)
  call scale_one_tsum(T0sum(126)%cmp, -4)
  call scale_one_tsum(T0sum(127)%cmp, -4)
  call scale_one_tsum(T0sum(128)%cmp, -4)
  call scale_one_tsum(T0sum(129)%cmp, -4)
  call scale_one_tsum(T0sum(130)%cmp, -4)
  call scale_one_tsum(T0sum(131)%cmp, -4)
  call scale_one_tsum(T0sum(132)%cmp, -4)
  call scale_one_tsum(T0sum(133)%cmp, -4)
  call scale_one_tsum(T0sum(134)%cmp, -4)
  call scale_one_tsum(T0sum(135)%cmp, -4)
  call scale_one_tsum(T0sum(136)%cmp, -4)
  call scale_one_tsum(T0sum(137)%cmp, -4)
  call scale_one_tsum(T0sum(138)%cmp, -4)
  call scale_one_tsum(T0sum(139)%cmp, -4)
  call scale_one_tsum(T0sum(140)%cmp, -4)
  call scale_one_tsum(T0sum(141)%cmp, -6)
  call scale_one_tsum(T0sum(142)%cmp, -6)
  call scale_one_tsum(T0sum(143)%cmp, -6)
  call scale_one_tsum(T0sum(144)%cmp, -6)
  call scale_one_tsum(T0sum(145)%cmp, -6)
  call scale_one_tsum(T0sum(146)%cmp, -6)
  call scale_one_tsum(T0sum(147)%cmp, -6)
  call scale_one_tsum(T0sum(148)%cmp, -6)
  call scale_one_tsum(T0sum(149)%cmp, -6)
  call scale_one_tsum(T0sum(150)%cmp, -6)
  call scale_one_tsum(T0sum(151)%cmp, -6)
  call scale_one_tsum(T0sum(152)%cmp, -6)
  call scale_one_tsum(T0sum(153)%cmp, -6)
  call scale_one_tsum(T0sum(154)%cmp, -6)
  call scale_one_tsum(T0sum(155)%cmp, -6)
  call scale_one_tsum(T0sum(156)%cmp, -6)
  call scale_one_tsum(T0sum(157)%cmp, -6)
  call scale_one_tsum(T0sum(158)%cmp, -6)
  call scale_one_tsum(T0sum(159)%cmp, -6)
  call scale_one_tsum(T0sum(160)%cmp, -6)
  call scale_one_tsum(T0sum(161)%cmp, -6)
  call scale_one_tsum(T0sum(162)%cmp, -6)
  call scale_one_tsum(T0sum(163)%cmp, -6)
  call scale_one_tsum(T0sum(164)%cmp, -6)
  call scale_one_tsum(T0sum(165)%cmp, -6)
  call scale_one_tsum(T0sum(166)%cmp, -6)
  call scale_one_tsum(T0sum(167)%cmp, -6)
  call scale_one_tsum(T0sum(168)%cmp, -6)
  call scale_one_tsum(T0sum(169)%cmp, -6)
  call scale_one_tsum(T0sum(170)%cmp, -6)
  call scale_one_tsum(T0sum(171)%cmp, -6)
  call scale_one_tsum(T0sum(172)%cmp, -6)
  call scale_one_tsum(T0sum(173)%cmp, -6)
  call scale_one_tsum(T0sum(174)%cmp, -6)
  call scale_one_tsum(T0sum(175)%cmp, -6)

end subroutine scale_tensor_sum

! **********************************************************************
subroutine set_integral_masses_and_momenta()
! **********************************************************************

  use ol_parameters_decl_/**/REALKIND
  momenta_1 = [ 0, 0 ]
  momenta_2 = [ 64, 63 ]
  momenta_3 = [ 69, 58 ]
  momenta_4 = [ 70, 57 ]
  momenta_5 = [ 73, 54 ]
  momenta_6 = [ 74, 53 ]
  momenta_7 = [ 79, 48 ]
  momenta_8 = [ 80, 47 ]
  momenta_9 = [ 85, 42 ]
  momenta_10 = [ 86, 41 ]
  momenta_11 = [ 89, 38 ]
  momenta_12 = [ 90, 37 ]
  momenta_13 = [ 95, 32 ]
  momenta_14 = [ 96, 31 ]
  momenta_15 = [ 101, 26 ]
  momenta_16 = [ 102, 25 ]
  momenta_17 = [ 105, 22 ]
  momenta_18 = [ 106, 21 ]
  momenta_19 = [ 111, 16 ]
  momenta_20 = [ 112, 15 ]
  momenta_21 = [ 117, 10 ]
  momenta_22 = [ 118, 9 ]
  momenta_23 = [ 121, 6 ]
  momenta_24 = [ 122, 5 ]
  momenta_25 = [ 64, 5, 58 ]
  momenta_26 = [ 64, 6, 57 ]
  momenta_27 = [ 64, 9, 54 ]
  momenta_28 = [ 64, 10, 53 ]
  momenta_29 = [ 64, 15, 48 ]
  momenta_30 = [ 64, 16, 47 ]
  momenta_31 = [ 64, 21, 42 ]
  momenta_32 = [ 64, 22, 41 ]
  momenta_33 = [ 64, 25, 38 ]
  momenta_34 = [ 64, 26, 37 ]
  momenta_35 = [ 64, 31, 32 ]
  momenta_36 = [ 64, 37, 26 ]
  momenta_37 = [ 64, 38, 25 ]
  momenta_38 = [ 64, 41, 22 ]
  momenta_39 = [ 64, 42, 21 ]
  momenta_40 = [ 64, 47, 16 ]
  momenta_41 = [ 64, 53, 10 ]
  momenta_42 = [ 64, 54, 9 ]
  momenta_43 = [ 69, 10, 48 ]
  momenta_44 = [ 69, 16, 42 ]
  momenta_45 = [ 69, 26, 32 ]
  momenta_46 = [ 69, 32, 26 ]
  momenta_47 = [ 69, 42, 16 ]
  momenta_48 = [ 69, 48, 10 ]
  momenta_49 = [ 70, 9, 48 ]
  momenta_50 = [ 70, 16, 41 ]
  momenta_51 = [ 70, 25, 32 ]
  momenta_52 = [ 70, 32, 25 ]
  momenta_53 = [ 70, 41, 16 ]
  momenta_54 = [ 70, 48, 9 ]
  momenta_55 = [ 73, 6, 48 ]
  momenta_56 = [ 73, 16, 38 ]
  momenta_57 = [ 73, 22, 32 ]
  momenta_58 = [ 73, 32, 22 ]
  momenta_59 = [ 73, 38, 16 ]
  momenta_60 = [ 74, 5, 48 ]
  momenta_61 = [ 74, 16, 37 ]
  momenta_62 = [ 74, 21, 32 ]
  momenta_63 = [ 74, 32, 21 ]
  momenta_64 = [ 74, 37, 16 ]
  momenta_65 = [ 79, 16, 32 ]
  momenta_66 = [ 79, 32, 16 ]
  momenta_67 = [ 80, 5, 42 ]
  momenta_68 = [ 80, 6, 41 ]
  momenta_69 = [ 80, 9, 38 ]
  momenta_70 = [ 80, 10, 37 ]
  momenta_71 = [ 80, 15, 32 ]
  momenta_72 = [ 85, 10, 32 ]
  momenta_73 = [ 85, 32, 10 ]
  momenta_74 = [ 86, 9, 32 ]
  momenta_75 = [ 86, 32, 9 ]
  momenta_76 = [ 89, 6, 32 ]
  momenta_77 = [ 90, 5, 32 ]
  momenta_78 = [ 96, 5, 26 ]
  momenta_79 = [ 96, 6, 25 ]
  momenta_80 = [ 96, 9, 22 ]
  momenta_81 = [ 96, 10, 21 ]
  momenta_82 = [ 96, 15, 16 ]
  momenta_83 = [ 96, 16, 15 ]
  momenta_84 = [ 96, 21, 10 ]
  momenta_85 = [ 96, 22, 9 ]
  momenta_86 = [ 96, 25, 6 ]
  momenta_87 = [ 96, 26, 5 ]
  momenta_88 = [ 101, 10, 16 ]
  momenta_89 = [ 101, 16, 10 ]
  momenta_90 = [ 102, 9, 16 ]
  momenta_91 = [ 102, 16, 9 ]
  momenta_92 = [ 105, 6, 16 ]
  momenta_93 = [ 105, 16, 6 ]
  momenta_94 = [ 106, 5, 16 ]
  momenta_95 = [ 106, 16, 5 ]
  momenta_96 = [ 112, 5, 10 ]
  momenta_97 = [ 112, 6, 9 ]
  momenta_98 = [ 112, 9, 6 ]
  momenta_99 = [ 112, 10, 5 ]
  momenta_100 = [ 64, 5, 10, 48 ]
  momenta_101 = [ 64, 5, 16, 42 ]
  momenta_102 = [ 64, 5, 26, 32 ]
  momenta_103 = [ 64, 5, 32, 26 ]
  momenta_104 = [ 64, 5, 42, 16 ]
  momenta_105 = [ 64, 5, 48, 10 ]
  momenta_106 = [ 64, 6, 9, 48 ]
  momenta_107 = [ 64, 6, 16, 41 ]
  momenta_108 = [ 64, 6, 25, 32 ]
  momenta_109 = [ 64, 6, 32, 25 ]
  momenta_110 = [ 64, 6, 41, 16 ]
  momenta_111 = [ 64, 6, 48, 9 ]
  momenta_112 = [ 64, 9, 6, 48 ]
  momenta_113 = [ 64, 9, 16, 38 ]
  momenta_114 = [ 64, 9, 22, 32 ]
  momenta_115 = [ 64, 9, 32, 22 ]
  momenta_116 = [ 64, 9, 38, 16 ]
  momenta_117 = [ 64, 10, 5, 48 ]
  momenta_118 = [ 64, 10, 16, 37 ]
  momenta_119 = [ 64, 10, 21, 32 ]
  momenta_120 = [ 64, 10, 32, 21 ]
  momenta_121 = [ 64, 10, 37, 16 ]
  momenta_122 = [ 64, 15, 16, 32 ]
  momenta_123 = [ 64, 15, 32, 16 ]
  momenta_124 = [ 64, 16, 5, 42 ]
  momenta_125 = [ 64, 16, 6, 41 ]
  momenta_126 = [ 64, 16, 9, 38 ]
  momenta_127 = [ 64, 16, 10, 37 ]
  momenta_128 = [ 64, 16, 15, 32 ]
  momenta_129 = [ 64, 21, 10, 32 ]
  momenta_130 = [ 64, 21, 32, 10 ]
  momenta_131 = [ 64, 22, 9, 32 ]
  momenta_132 = [ 64, 22, 32, 9 ]
  momenta_133 = [ 64, 25, 6, 32 ]
  momenta_134 = [ 64, 26, 5, 32 ]
  momenta_135 = [ 64, 37, 16, 10 ]
  momenta_136 = [ 64, 38, 16, 9 ]
  momenta_137 = [ 69, 10, 16, 32 ]
  momenta_138 = [ 69, 10, 32, 16 ]
  momenta_139 = [ 69, 16, 32, 10 ]
  momenta_140 = [ 69, 32, 16, 10 ]
  momenta_141 = [ 70, 9, 16, 32 ]
  momenta_142 = [ 70, 9, 32, 16 ]
  momenta_143 = [ 70, 16, 32, 9 ]
  momenta_144 = [ 70, 32, 16, 9 ]
  momenta_145 = [ 73, 6, 16, 32 ]
  momenta_146 = [ 73, 6, 32, 16 ]
  momenta_147 = [ 74, 5, 16, 32 ]
  momenta_148 = [ 74, 5, 32, 16 ]
  momenta_149 = [ 80, 5, 10, 32 ]
  momenta_150 = [ 80, 6, 9, 32 ]
  momenta_151 = [ 80, 9, 6, 32 ]
  momenta_152 = [ 80, 10, 5, 32 ]
  momenta_153 = [ 96, 5, 10, 16 ]
  momenta_154 = [ 96, 6, 9, 16 ]
  momenta_155 = [ 96, 9, 6, 16 ]
  momenta_156 = [ 96, 10, 5, 16 ]
  momenta_157 = [ 96, 16, 5, 10 ]
  momenta_158 = [ 96, 16, 6, 9 ]
  momenta_159 = [ 96, 16, 9, 6 ]
  momenta_160 = [ 96, 16, 10, 5 ]
  momenta_161 = [ 64, 5, 10, 16, 32 ]
  momenta_162 = [ 64, 5, 10, 32, 16 ]
  momenta_163 = [ 64, 5, 16, 32, 10 ]
  momenta_164 = [ 64, 5, 32, 16, 10 ]
  momenta_165 = [ 64, 6, 9, 16, 32 ]
  momenta_166 = [ 64, 6, 9, 32, 16 ]
  momenta_167 = [ 64, 6, 16, 32, 9 ]
  momenta_168 = [ 64, 6, 32, 16, 9 ]
  momenta_169 = [ 64, 9, 6, 16, 32 ]
  momenta_170 = [ 64, 9, 6, 32, 16 ]
  momenta_171 = [ 64, 10, 5, 16, 32 ]
  momenta_172 = [ 64, 10, 5, 32, 16 ]
  momenta_173 = [ 64, 16, 5, 10, 32 ]
  momenta_174 = [ 64, 16, 6, 9, 32 ]
  momenta_175 = [ 64, 16, 9, 6, 32 ]
  momenta_176 = [ 64, 16, 10, 5, 32 ]

  masses2_1 = [ 0, 0 ]
  masses2_2 = [ nMB, 0 ]
  masses2_3 = [ nMT, 0 ]
  masses2_4 = [ nMB, nMB ]
  masses2_5 = [ nMT, nMT ]
  masses2_6 = [ 0, 0, 0 ]
  masses2_7 = [ nMB, nMB, nMB ]
  masses2_8 = [ nMT, nMT, nMT ]
  masses2_9 = [ 0, 0, 0, 0 ]
  masses2_10 = [ 0, 0, 0, 0, 0 ]


end subroutine  set_integral_masses_and_momenta

! **********************************************************************
subroutine integrate_tensor_sum(M2out)
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! only: ZERO, masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: a_switch
#endif
  use ol_parameters_init_/**/REALKIND, only: init_met, add_met, met_to_real
  use ol_loop_routines_/**/REALKIND, only: TI_call_OL
  implicit none
  real(REALKIND), intent(out) :: M2out
  type(met) :: M2
  call init_met(M2)

sbarray_1 = [1, 2, 3, 4, 5]
sbarray_2 = [6, 7, 3, 8, 9]
sbarray_3 = [10, 11, 3, 12, 13]
sbarray_4 = [14, 15, 3, 16, 17]
sbarray_5 = [18, 19, 20, 21, 22]
sbarray_6 = [23, 19, 24, 25, 26]
sbarray_7 = [27, 28, 29, 21, 30]
sbarray_8 = [31, 28, 32, 25, 33]
sbarray_9 = [34, 19, 35, 36, 37]
sbarray_10 = [38, 19, 39, 40, 41]
sbarray_11 = [42, 28, 43, 36, 44]
sbarray_12 = [45, 28, 46, 40, 47]
sbarray_13 = [48, 49, 50, 51, 52]
sbarray_14 = [53, 54, 50, 55, 56]
sbarray_15 = [57, 58, 59, 60, 61]
sbarray_16 = [62, 63, 59, 64, 65]


#ifdef LOOPSQUARED
  if (a_switch == 1 .or. a_switch == 7) then
#endif
  call TI_call_OL(0,0, momenta_124, masses2_9, T0sum(1), M2,[4], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_127, masses2_9, T0sum(2), M2,[8], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_126, masses2_9, T0sum(3), M2,[12], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_125, masses2_9, T0sum(4), M2,[16], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_152, masses2_9, T0sum(5), M2,[6], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_117, masses2_9, T0sum(6), M2,[21], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_149, masses2_9, T0sum(7), M2,[1], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_100, masses2_9, T0sum(8), M2,[25], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_156, masses2_9, T0sum(9), M2,[30], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_153, masses2_9, T0sum(10), M2,[33], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_150, masses2_9, T0sum(11), M2,[14], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_106, masses2_9, T0sum(12), M2,[36], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_151, masses2_9, T0sum(13), M2,[10], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_112, masses2_9, T0sum(14), M2,[40], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_154, masses2_9, T0sum(15), M2,[44], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_155, masses2_9, T0sum(16), M2,[47], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_147, masses2_9, T0sum(17), M2,[27], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_101, masses2_9, T0sum(18), M2,[51], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_148, masses2_9, T0sum(19), M2,[18], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_103, masses2_9, T0sum(20), M2,[55], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_146, masses2_9, T0sum(21), M2,[38], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_109, masses2_9, T0sum(22), M2,[60], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_145, masses2_9, T0sum(23), M2,[45], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_107, masses2_9, T0sum(24), M2,[64], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_157, masses2_9, T0sum(25), M2,[5], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_129, masses2_9, T0sum(26), M2,[2], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_128, masses2_9, T0sum(27), M2,[3], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_160, masses2_9, T0sum(28), M2,[9], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_134, masses2_9, T0sum(29), M2,[7], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_159, masses2_9, T0sum(30), M2,[13], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_133, masses2_9, T0sum(31), M2,[11], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_158, masses2_9, T0sum(32), M2,[17], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_131, masses2_9, T0sum(33), M2,[15], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_123, masses2_9, T0sum(34), M2,[19], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_121, masses2_9, T0sum(35), M2,[20], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_138, masses2_9, T0sum(36), M2,[23], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_104, masses2_9, T0sum(37), M2,[24], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_122, masses2_9, T0sum(38), M2,[28], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_119, masses2_9, T0sum(39), M2,[29], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_137, masses2_9, T0sum(40), M2,[31], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_102, masses2_9, T0sum(41), M2,[32], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_142, masses2_9, T0sum(42), M2,[34], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_110, masses2_9, T0sum(43), M2,[35], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_116, masses2_9, T0sum(44), M2,[39], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_141, masses2_9, T0sum(45), M2,[42], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_108, masses2_9, T0sum(46), M2,[43], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_114, masses2_9, T0sum(47), M2,[46], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_139, masses2_9, T0sum(48), M2,[48], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_130, masses2_9, T0sum(49), M2,[49], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_105, masses2_9, T0sum(50), M2,[50], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_140, masses2_9, T0sum(51), M2,[53], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_135, masses2_9, T0sum(52), M2,[54], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_144, masses2_9, T0sum(53), M2,[57], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_136, masses2_9, T0sum(54), M2,[58], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_111, masses2_9, T0sum(55), M2,[59], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_143, masses2_9, T0sum(56), M2,[62], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_132, masses2_9, T0sum(57), M2,[63], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_120, masses2_9, T0sum(58), M2,[49], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_118, masses2_9, T0sum(59), M2,[54], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_115, masses2_9, T0sum(60), M2,[63], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_113, masses2_9, T0sum(61), M2,[58], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_99, masses2_6, T0sum(62), M2)
  call TI_call_OL(0,0, momenta_96, masses2_6, T0sum(63), M2)
  call TI_call_OL(0,0, momenta_97, masses2_6, T0sum(64), M2)
  call TI_call_OL(0,0, momenta_98, masses2_6, T0sum(65), M2)
  call TI_call_OL(0,0, momenta_94, masses2_6, T0sum(66), M2)
  call TI_call_OL(0,0, momenta_77, masses2_6, T0sum(67), M2)
  call TI_call_OL(0,0, momenta_76, masses2_6, T0sum(68), M2)
  call TI_call_OL(0,0, momenta_92, masses2_6, T0sum(69), M2)
  call TI_call_OL(0,0, momenta_83, masses2_6, T0sum(70), M2)
  call TI_call_OL(0,0, momenta_30, masses2_6, T0sum(71), M2)
  call TI_call_OL(0,0, momenta_95, masses2_6, T0sum(72), M2)
  call TI_call_OL(0,0, momenta_89, masses2_6, T0sum(73), M2)
  call TI_call_OL(0,0, momenta_91, masses2_6, T0sum(74), M2)
  call TI_call_OL(0,0, momenta_93, masses2_6, T0sum(75), M2)
  call TI_call_OL(0,0, momenta_60, masses2_6, T0sum(76), M2)
  call TI_call_OL(0,0, momenta_29, masses2_6, T0sum(77), M2)
  call TI_call_OL(0,0, momenta_28, masses2_6, T0sum(78), M2)
  call TI_call_OL(0,0, momenta_43, masses2_6, T0sum(79), M2)
  call TI_call_OL(0,0, momenta_25, masses2_6, T0sum(80), M2)
  call TI_call_OL(0,0, momenta_49, masses2_6, T0sum(81), M2)
  call TI_call_OL(0,0, momenta_26, masses2_6, T0sum(82), M2)
  call TI_call_OL(0,0, momenta_55, masses2_6, T0sum(83), M2)
  call TI_call_OL(0,0, momenta_27, masses2_6, T0sum(84), M2)
  call TI_call_OL(0,0, momenta_44, masses2_6, T0sum(85), M2)
  call TI_call_OL(0,0, momenta_31, masses2_6, T0sum(86), M2)
  call TI_call_OL(0,0, momenta_46, masses2_6, T0sum(87), M2)
  call TI_call_OL(0,0, momenta_36, masses2_6, T0sum(88), M2)
  call TI_call_OL(0,0, momenta_52, masses2_6, T0sum(89), M2)
  call TI_call_OL(0,0, momenta_37, masses2_6, T0sum(90), M2)
  call TI_call_OL(0,0, momenta_50, masses2_6, T0sum(91), M2)
  call TI_call_OL(0,0, momenta_32, masses2_6, T0sum(92), M2)
  call TI_call_OL(0,0, momenta_67, masses2_6, T0sum(93), M2)
  call TI_call_OL(0,0, momenta_70, masses2_6, T0sum(94), M2)
  call TI_call_OL(0,0, momenta_34, masses2_6, T0sum(95), M2)
  call TI_call_OL(0,0, momenta_69, masses2_6, T0sum(96), M2)
  call TI_call_OL(0,0, momenta_33, masses2_6, T0sum(97), M2)
  call TI_call_OL(0,0, momenta_68, masses2_6, T0sum(98), M2)
  call TI_call_OL(0,0, momenta_81, masses2_6, T0sum(99), M2)
  call TI_call_OL(0,0, momenta_78, masses2_6, T0sum(100), M2)
  call TI_call_OL(0,0, momenta_79, masses2_6, T0sum(101), M2)
  call TI_call_OL(0,0, momenta_80, masses2_6, T0sum(102), M2)
  call TI_call_OL(0,0, momenta_71, masses2_6, T0sum(103), M2)
  call TI_call_OL(0,0, momenta_72, masses2_6, T0sum(104), M2)
  call TI_call_OL(0,0, momenta_82, masses2_6, T0sum(105), M2)
  call TI_call_OL(0,0, momenta_88, masses2_6, T0sum(106), M2)
  call TI_call_OL(0,0, momenta_74, masses2_6, T0sum(107), M2)
  call TI_call_OL(0,0, momenta_90, masses2_6, T0sum(108), M2)
  call TI_call_OL(0,0, momenta_65, masses2_6, T0sum(109), M2)
  call TI_call_OL(0,0, momenta_62, masses2_6, T0sum(110), M2)
  call TI_call_OL(0,0, momenta_66, masses2_6, T0sum(111), M2)
  call TI_call_OL(0,0, momenta_64, masses2_6, T0sum(112), M2)
  call TI_call_OL(0,0, momenta_59, masses2_6, T0sum(113), M2)
  call TI_call_OL(0,0, momenta_57, masses2_6, T0sum(114), M2)
  call TI_call_OL(0,0, momenta_84, masses2_6, T0sum(115), M2)
  call TI_call_OL(0,0, momenta_35, masses2_6, T0sum(116), M2)
  call TI_call_OL(0,0, momenta_87, masses2_6, T0sum(117), M2)
  call TI_call_OL(0,0, momenta_86, masses2_6, T0sum(118), M2)
  call TI_call_OL(0,0, momenta_85, masses2_6, T0sum(119), M2)
  call TI_call_OL(0,0, momenta_40, masses2_6, T0sum(120), M2)
  call TI_call_OL(0,0, momenta_47, masses2_6, T0sum(121), M2)
  call TI_call_OL(0,0, momenta_45, masses2_6, T0sum(122), M2)
  call TI_call_OL(0,0, momenta_53, masses2_6, T0sum(123), M2)
  call TI_call_OL(0,0, momenta_51, masses2_6, T0sum(124), M2)
  call TI_call_OL(0,0, momenta_73, masses2_6, T0sum(125), M2)
  call TI_call_OL(0,0, momenta_48, masses2_6, T0sum(126), M2)
  call TI_call_OL(0,0, momenta_41, masses2_6, T0sum(127), M2)
  call TI_call_OL(0,0, momenta_54, masses2_6, T0sum(128), M2)
  call TI_call_OL(0,0, momenta_42, masses2_6, T0sum(129), M2)
  call TI_call_OL(0,0, momenta_75, masses2_6, T0sum(130), M2)
  call TI_call_OL(0,0, momenta_63, masses2_6, T0sum(131), M2)
  call TI_call_OL(0,0, momenta_39, masses2_6, T0sum(132), M2)
  call TI_call_OL(0,0, momenta_61, masses2_6, T0sum(133), M2)
  call TI_call_OL(0,0, momenta_58, masses2_6, T0sum(134), M2)
  call TI_call_OL(0,0, momenta_38, masses2_6, T0sum(135), M2)
  call TI_call_OL(0,0, momenta_56, masses2_6, T0sum(136), M2)
  call TI_call_OL(0,0, momenta_28, masses2_8, T0sum(137), M2)
  call TI_call_OL(0,0, momenta_28, masses2_7, T0sum(138), M2)
  call TI_call_OL(0,0, momenta_26, masses2_8, T0sum(139), M2)
  call TI_call_OL(0,0, momenta_26, masses2_7, T0sum(140), M2)
  call TI_call_OL(0,0, momenta_21, masses2_1, T0sum(141), M2)
  call TI_call_OL(0,0, momenta_24, masses2_1, T0sum(142), M2)
  call TI_call_OL(0,0, momenta_20, masses2_1, T0sum(143), M2)
  call TI_call_OL(0,0, momenta_23, masses2_1, T0sum(144), M2)
  call TI_call_OL(0,0, momenta_22, masses2_1, T0sum(145), M2)
  call TI_call_OL(0,0, momenta_19, masses2_1, T0sum(146), M2)
  call TI_call_OL(0,0, momenta_18, masses2_1, T0sum(147), M2)
  call TI_call_OL(0,0, momenta_13, masses2_1, T0sum(148), M2)
  call TI_call_OL(0,0, momenta_12, masses2_1, T0sum(149), M2)
  call TI_call_OL(0,0, momenta_11, masses2_1, T0sum(150), M2)
  call TI_call_OL(0,0, momenta_17, masses2_1, T0sum(151), M2)
  call TI_call_OL(0,0, momenta_14, masses2_1, T0sum(152), M2)
  call TI_call_OL(0,0, momenta_8, masses2_1, T0sum(153), M2)
  call TI_call_OL(0,0, momenta_2, masses2_1, T0sum(154), M2)
  call TI_call_OL(0,0, momenta_15, masses2_1, T0sum(155), M2)
  call TI_call_OL(0,0, momenta_16, masses2_1, T0sum(156), M2)
  call TI_call_OL(0,0, momenta_7, masses2_1, T0sum(157), M2)
  call TI_call_OL(0,0, momenta_6, masses2_1, T0sum(158), M2)
  call TI_call_OL(0,0, momenta_3, masses2_1, T0sum(159), M2)
  call TI_call_OL(0,0, momenta_4, masses2_1, T0sum(160), M2)
  call TI_call_OL(0,0, momenta_5, masses2_1, T0sum(161), M2)
  call TI_call_OL(0,0, momenta_9, masses2_1, T0sum(162), M2)
  call TI_call_OL(0,0, momenta_10, masses2_1, T0sum(163), M2)
  call TI_call_OL(0,0, momenta_21, masses2_5, T0sum(164), M2)
  call TI_call_OL(0,0, momenta_6, masses2_5, T0sum(165), M2)
  call TI_call_OL(0,0, momenta_2, masses2_5, T0sum(166), M2)
  call TI_call_OL(0,0, momenta_1, masses2_3, T0sum(167), M2)
  call TI_call_OL(0,0, momenta_21, masses2_4, T0sum(168), M2)
  call TI_call_OL(0,0, momenta_6, masses2_4, T0sum(169), M2)
  call TI_call_OL(0,0, momenta_2, masses2_4, T0sum(170), M2)
  call TI_call_OL(0,0, momenta_1, masses2_2, T0sum(171), M2)
  call TI_call_OL(0,0, momenta_23, masses2_5, T0sum(172), M2)
  call TI_call_OL(0,0, momenta_4, masses2_5, T0sum(173), M2)
  call TI_call_OL(0,0, momenta_23, masses2_4, T0sum(174), M2)
  call TI_call_OL(0,0, momenta_4, masses2_4, T0sum(175), M2)

  call TI_call_OL(0,1, momenta_173, masses2_10, T1sum(1), M2,sbarray_1, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_176, masses2_10, T1sum(2), M2,sbarray_2, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_175, masses2_10, T1sum(3), M2,sbarray_3, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_174, masses2_10, T1sum(4), M2,sbarray_4, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_172, masses2_10, T1sum(5), M2,sbarray_5, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_162, masses2_10, T1sum(6), M2,sbarray_6, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_171, masses2_10, T1sum(7), M2,sbarray_7, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_161, masses2_10, T1sum(8), M2,sbarray_8, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_166, masses2_10, T1sum(9), M2,sbarray_9, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_170, masses2_10, T1sum(10), M2,sbarray_10, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_165, masses2_10, T1sum(11), M2,sbarray_11, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_169, masses2_10, T1sum(12), M2,sbarray_12, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_163, masses2_10, T1sum(13), M2,sbarray_13, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_164, masses2_10, T1sum(14), M2,sbarray_14, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_168, masses2_10, T1sum(15), M2,sbarray_15, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_167, masses2_10, T1sum(16), M2,sbarray_16, ScalarBoxes(:))

  call add_met(M2,M2L1R1)

#ifdef LOOPSQUARED
  end if
#endif

  call met_to_real(M2out,M2)

#ifdef PRECISION_dp
  call HOL_memory_deallocation_/**/REALKIND(1)
  call HCL_memory_deallocation_/**/REALKIND(1)
#endif

end subroutine integrate_tensor_sum

end module ol_tensor_sum_storage_ppllllj_neeexexuxdg_1_/**/REALKIND
