
module ol_colourmatrix_ppllllj_eexmmxuuxg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(30,1), K2(30,1), KL(30,1), Cas(7) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [  12]
  K1( 2,:) = [   0]
  K1( 3,:) = [   0]
  K1( 4,:) = [   0]
  K1( 5,:) = [   0]
  K1( 6,:) = [   0]
  K1( 7,:) = [   0]
  K1( 8,:) = [   0]
  K1( 9,:) = [   0]
  K1(10,:) = [   0]
  K1(11,:) = [   0]
  K1(12,:) = [   0]
  K1(13,:) = [   0]
  K1(14,:) = [   0]
  K1(15,:) = [   0]
  K1(16,:) = [  16]
  K1(17,:) = [   0]
  K1(18,:) = [   0]
  K1(19,:) = [   0]
  K1(20,:) = [   0]
  K1(21,:) = [   2]
  K1(22,:) = [  16]
  K1(23,:) = [   0]
  K1(24,:) = [   0]
  K1(25,:) = [   0]
  K1(26,:) = [   0]
  K1(27,:) = [ -18]
  K1(28,:) = [ -18]
  K1(29,:) = [  36]
  K1(30,:) = [   0]
  K1 = (1._/**/REALKIND / 3) * K1

  K2( 1,:) = [  12]
  K2( 2,:) = [   0]
  K2( 3,:) = [   0]
  K2( 4,:) = [   0]
  K2( 5,:) = [   0]
  K2( 6,:) = [   0]
  K2( 7,:) = [   0]
  K2( 8,:) = [   0]
  K2( 9,:) = [   0]
  K2(10,:) = [   0]
  K2(11,:) = [   0]
  K2(12,:) = [   0]
  K2(13,:) = [   0]
  K2(14,:) = [   0]
  K2(15,:) = [   0]
  K2(16,:) = [  16]
  K2(17,:) = [   0]
  K2(18,:) = [   0]
  K2(19,:) = [   0]
  K2(20,:) = [   0]
  K2(21,:) = [   2]
  K2(22,:) = [  16]
  K2(23,:) = [   0]
  K2(24,:) = [   0]
  K2(25,:) = [   0]
  K2(26,:) = [   0]
  K2(27,:) = [ -18]
  K2(28,:) = [ -18]
  K2(29,:) = [  36]
  K2(30,:) = [   0]
  K2 = (1._/**/REALKIND / 3) * K2

  KL( 1,:) = [  12]
  KL( 2,:) = [   0]
  KL( 3,:) = [   0]
  KL( 4,:) = [   0]
  KL( 5,:) = [   0]
  KL( 6,:) = [   0]
  KL( 7,:) = [   0]
  KL( 8,:) = [   0]
  KL( 9,:) = [   0]
  KL(10,:) = [   0]
  KL(11,:) = [   0]
  KL(12,:) = [   0]
  KL(13,:) = [   0]
  KL(14,:) = [   0]
  KL(15,:) = [   0]
  KL(16,:) = [  16]
  KL(17,:) = [   0]
  KL(18,:) = [   0]
  KL(19,:) = [   0]
  KL(20,:) = [   0]
  KL(21,:) = [   2]
  KL(22,:) = [  16]
  KL(23,:) = [   0]
  KL(24,:) = [   0]
  KL(25,:) = [   0]
  KL(26,:) = [   0]
  KL(27,:) = [ -18]
  KL(28,:) = [ -18]
  KL(29,:) = [  36]
  KL(30,:) = [   0]
  KL = (1._/**/REALKIND / 3) * KL

#if -1 > 0
    co = 0
    do k = 1, 7
      co = co + k
      Cas(k) = K1(1+1*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_ppllllj_eexmmxuuxg_1_/**/REALKIND



module ol_forced_parameters_ppllllj_eexmmxuuxg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (YE /= 0) write(*,101) 'YE = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMM /= 0) write(*,101) 'wMM = 0'
  if (wMM /= 0) write(*,101) 'wMM = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppllllj_eexmmxuuxg_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_ppllllj_eexmmxuuxg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 128 ! number of helicity configurations
  integer(intkind2), save :: nhel = 128 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: hel_states = 128 ! number of helicity configurations needed for mem-allocation
  integer(intkind2), save :: Hel(128) ! physical helicity states
#endif

  type(Hpolcont), save, allocatable :: A(:,:), M1helarray(:,:), M1helarray_ct(:,:)
  complex(REALKIND), save :: den(548)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2), ex7(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,20), wf8(8,84), wf16(16,103), wf32(32,104), wf128(128,310)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(51), c(30)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save, allocatable :: M0_col1_helarray(:,:), M0M1_hel_cc(:,:,:)
  complex(REALKIND), save :: M2ctcc(29)

end module ol_loop_storage_ppllllj_eexmmxuuxg_1_/**/REALKIND






! **********************************************************************
module ol_loop_ppllllj_eexmmxuuxg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppllllj_eexmmxuuxg_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (4*CI*eQED**4*gQCD)/9._/**/REALKIND
    f( 2) = (2*CI*eQED**4*gQCD)/3._/**/REALKIND
    f( 3) = CI*eQED**4*gQCD
    f( 4) = (4*CI*countertermnorm*eQED**4*gQCD**3)/9._/**/REALKIND
    f( 5) = (2*CI*countertermnorm*eQED**4*gQCD**3)/3._/**/REALKIND
    f( 6) = CI*countertermnorm*eQED**4*gQCD**3
    f( 7) = CI*countertermnorm*ctAAGG*eQED**4*gQCD**3
    f( 8) = CI*countertermnorm*ctAZGG*eQED**4*gQCD**3
    f( 9) = (4*CI*countertermnorm*ctGqq*eQED**4*gQCD**3)/9._/**/REALKIND
    f(10) = (2*CI*countertermnorm*ctGqq*eQED**4*gQCD**3)/3._/**/REALKIND
    f(11) = CI*countertermnorm*ctGqq*eQED**4*gQCD**3
    f(12) = (4*CI*countertermnorm*ctVqq*eQED**4*gQCD**3)/9._/**/REALKIND
    f(13) = (2*CI*countertermnorm*ctVqq*eQED**4*gQCD**3)/3._/**/REALKIND
    f(14) = CI*countertermnorm*ctVqq*eQED**4*gQCD**3
    f(15) = (2*countertermnorm*ctZGG*eQED**4*gQCD**3)/3._/**/REALKIND
    f(16) = countertermnorm*ctZGG*eQED**4*gQCD**3
    f(17) = CI*countertermnorm*ctZZGG*eQED**4*gQCD**3
    f(18) = (CI*eQED**4*gQCD*MM)/(2._/**/REALKIND*cw**2*sw**2)
    f(19) = (CI*countertermnorm*eQED**4*gQCD**3*MM)/(2._/**/REALKIND*cw**2*sw**2)
    f(20) = (CI*countertermnorm*ctGqq*eQED**4*gQCD**3*MM)/(2._/**/REALKIND*cw**2*sw**2)
    f(21) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**3*MM)/(2._/**/REALKIND*cw**2*sw**2)
    f(22) = (countertermnorm*ctZGG*eQED**4*gQCD**3*MM)/(cw**2*sw**2*2._/**/REALKIND)
    f(23) = (CI*countertermnorm*ctHGG*eQED**4*gQCD**3*MM)/(3._/**/REALKIND*MW*sw)
    f(24) = (CI*countertermnorm*ctHGG*eQED**4*gQCD**3*MM)/(2._/**/REALKIND*MW*sw)
    f(25) = (CI*countertermnorm*ctHGG*eQED**4*gQCD**3*MW)/(cw**2*sw)
    f(26) = (4*CI*eQED**4*gQCD**3*integralnorm*SwB)/9._/**/REALKIND
    f(27) = (2*CI*eQED**4*gQCD**3*integralnorm*SwB)/3._/**/REALKIND
    f(28) = CI*eQED**4*gQCD**3*integralnorm*SwB
    f(29) = (4*eQED**4*gQCD**3*integralnorm*SwB)/9._/**/REALKIND
    f(30) = (2*eQED**4*gQCD**3*integralnorm*SwB)/3._/**/REALKIND
    f(31) = eQED**4*gQCD**3*integralnorm*SwB
    f(32) = (CI*eQED**4*gQCD**3*integralnorm*MM*SwB)/(2._/**/REALKIND*cw**2*sw**2)
    f(33) = (eQED**4*gQCD**3*integralnorm*MM*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(34) = (eQED**4*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(35) = (2*eQED**4*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(36) = (eQED**4*gQCD**3*integralnorm*SwF)/3._/**/REALKIND
    f(37) = (4*eQED**4*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(38) = (2*eQED**4*gQCD**3*integralnorm*SwF)/3._/**/REALKIND
    f(39) = (8*eQED**4*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(40) = eQED**4*gQCD**3*integralnorm*SwF
    f(41) = (4*eQED**4*gQCD**3*integralnorm*SwF)/3._/**/REALKIND
    f(42) = 2*eQED**4*gQCD**3*integralnorm*SwF
    f(43) = (eQED**4*gQCD**3*integralnorm*MB*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(44) = (eQED**4*gQCD**3*integralnorm*MM*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(45) = (eQED**4*gQCD**3*integralnorm*MM*SwF)/(cw**2*sw**2)
    f(46) = (eQED**4*gQCD**3*integralnorm*MT*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(47) = (eQED**4*gQCD**3*integralnorm*MB*MM*SwF)/(MW**2*sw**2*12._/**/REALKIND)
    f(48) = (eQED**4*gQCD**3*integralnorm*MB*MM*SwF)/(MW**2*sw**2*6._/**/REALKIND)
    f(49) = (eQED**4*gQCD**3*integralnorm*MB*MM*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(50) = (eQED**4*gQCD**3*integralnorm*MM*MT*SwF)/(MW**2*sw**2*6._/**/REALKIND)
    f(51) = (eQED**4*gQCD**3*integralnorm*MM*MT*SwF)/(MW**2*sw**2*4._/**/REALKIND)

  c = [ 9*CI*f(26), 9*CI*f(27), 9*CI*f(28), f(29), 8*f(29), f(30), 8*f(30), f(31), 8*f(31), 9*CI*f(32), f(33), 8*f(33), 3*f(34) &
    , 3*f(35), 3*f(36), 3*f(37), 3*f(38), 3*f(39), 3*f(40), 3*f(41), 3*f(42), 3*f(43), 3*f(44), 3*f(45), 3*f(46), 3*f(47), 3*f(48) &
    , 3*f(49), 3*f(50), 3*f(51) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3))+L(6,3))
  den(2) = 1 /((L(5,12))+L(6,12))
  den(3) = 1 /((L(5,80))+L(6,80))
  den(5) = 1 /((L(5,35))+L(6,35))
  den(8) = 1 /((L(5,12) - MZ2)+L(6,12))
  den(11) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(16) = 1 /((L(5,44))+L(6,44))
  den(24) = 1 /((L(5,12) - MH2)+L(6,12))
  den(26) = 1 /((L(5,112) - MZ2)+L(6,112))
  den(29) = 1 /((L(5,96))+L(6,96))
  den(31) = 1 /((L(5,19))+L(6,19))
  den(40) = 1 /((L(5,28))+L(6,28))
  den(58) = 1 /((L(5,7) - MM2)+L(6,7))
  den(60) = 1 /((L(5,112))+L(6,112))
  den(67) = 1 /((L(5,11) - MM2)+L(6,11))
  den(83) = 1 /((L(5,13))+L(6,13))
  den(90) = 1 /((L(5,14))+L(6,14))
  den(105) = 1 /((L(5,48))+L(6,48))
  den(114) = 1 /((L(5,15) - MZ2)+L(6,15))
  den(117) = 1 /((L(5,15) - MH2)+L(6,15))
  den(120) = 1 /((L(5,76))+L(6,76))
  den(131) = 1 /((L(5,67))+L(6,67))
  den(138) = 1 /((L(5,83))+L(6,83))
  den(145) = 1 /((L(5,92))+L(6,92))
  den(153) = 1 /((L(5,99))+L(6,99))
  den(160) = 1 /((L(5,108))+L(6,108))
  den(167) = 1 /((L(5,112) - MH2)+L(6,112))
  den(250) = 1 /((L(5,15))+L(6,15))
  den(299) = 1 /((L(5,51))+L(6,51))
  den(303) = 1 /((L(5,31))+L(6,31))
  den(314) = 1 /((L(5,47))+L(6,47))
  den(322) = 1 /((L(5,60))+L(6,60))

  ! denominators
  den(4) = den(2)*den(3)
  den(6) = den(1)*den(5)
  den(7) = den(4)*den(6)
  den(9) = den(3)*den(8)
  den(10) = den(6)*den(9)
  den(12) = den(5)*den(11)
  den(13) = den(4)*den(12)
  den(14) = den(9)*den(12)
  den(15) = den(1)*den(3)
  den(17) = den(2)*den(16)
  den(18) = den(15)*den(17)
  den(19) = den(8)*den(16)
  den(20) = den(15)*den(19)
  den(21) = den(3)*den(11)
  den(22) = den(17)*den(21)
  den(23) = den(19)*den(21)
  den(25) = den(11)*den(24)
  den(27) = den(3)*den(26)
  den(28) = den(25)*den(27)
  den(30) = den(2)*den(29)
  den(32) = den(1)*den(31)
  den(33) = den(30)*den(32)
  den(34) = den(8)*den(29)
  den(35) = den(32)*den(34)
  den(36) = den(11)*den(31)
  den(37) = den(30)*den(36)
  den(38) = den(34)*den(36)
  den(39) = den(1)*den(29)
  den(41) = den(2)*den(40)
  den(42) = den(39)*den(41)
  den(43) = den(8)*den(40)
  den(44) = den(39)*den(43)
  den(45) = den(11)*den(29)
  den(46) = den(41)*den(45)
  den(47) = den(43)*den(45)
  den(48) = den(26)*den(29)
  den(49) = den(25)*den(48)
  den(50) = den(17)*den(32)
  den(51) = den(19)*den(32)
  den(52) = den(17)*den(36)
  den(53) = den(19)*den(36)
  den(54) = den(6)*den(41)
  den(55) = den(6)*den(43)
  den(56) = den(12)*den(41)
  den(57) = den(12)*den(43)
  den(59) = den(1)*den(58)
  den(61) = den(3)*den(60)
  den(62) = den(59)*den(61)
  den(63) = den(27)*den(59)
  den(64) = den(11)*den(58)
  den(65) = den(61)*den(64)
  den(66) = den(27)*den(64)
  den(68) = den(1)*den(67)
  den(69) = den(61)*den(68)
  den(70) = den(27)*den(68)
  den(71) = den(11)*den(67)
  den(72) = den(61)*den(71)
  den(73) = den(27)*den(71)
  den(74) = den(29)*den(60)
  den(75) = den(59)*den(74)
  den(76) = den(48)*den(59)
  den(77) = den(64)*den(74)
  den(78) = den(48)*den(64)
  den(79) = den(68)*den(74)
  den(80) = den(48)*den(68)
  den(81) = den(71)*den(74)
  den(82) = den(48)*den(71)
  den(84) = den(2)*den(83)
  den(85) = den(61)*den(84)
  den(86) = den(27)*den(84)
  den(87) = den(8)*den(83)
  den(88) = den(61)*den(87)
  den(89) = den(27)*den(87)
  den(91) = den(2)*den(90)
  den(92) = den(61)*den(91)
  den(93) = den(8)*den(90)
  den(94) = den(61)*den(93)
  den(95) = den(27)*den(91)
  den(96) = den(27)*den(93)
  den(97) = den(74)*den(84)
  den(98) = den(48)*den(84)
  den(99) = den(74)*den(87)
  den(100) = den(48)*den(87)
  den(101) = den(74)*den(91)
  den(102) = den(74)*den(93)
  den(103) = den(48)*den(91)
  den(104) = den(48)*den(93)
  den(106) = den(1)*den(2)
  den(107) = den(105)*den(106)
  den(108) = den(1)*den(8)
  den(109) = den(105)*den(108)
  den(110) = den(2)*den(11)
  den(111) = den(105)*den(110)
  den(112) = den(8)*den(11)
  den(113) = den(105)*den(112)
  den(115) = den(25)*den(114)
  den(116) = den(105)*den(115)
  den(118) = den(112)*den(117)
  den(119) = den(105)*den(118)
  den(121) = den(24)*den(120)
  den(122) = den(32)*den(121)
  den(123) = den(36)*den(121)
  den(124) = den(8)*den(120)
  den(125) = den(32)*den(124)
  den(126) = den(36)*den(124)
  den(127) = den(6)*den(121)
  den(128) = den(12)*den(121)
  den(129) = den(6)*den(124)
  den(130) = den(12)*den(124)
  den(132) = den(11)*den(131)
  den(133) = den(41)*den(132)
  den(134) = den(43)*den(132)
  den(135) = den(17)*den(132)
  den(136) = den(19)*den(132)
  den(137) = den(3)*den(115)
  den(139) = den(15)*den(138)
  den(140) = den(2)*den(139)
  den(141) = den(8)*den(139)
  den(142) = den(21)*den(138)
  den(143) = den(2)*den(142)
  den(144) = den(8)*den(142)
  den(146) = den(4)*den(145)
  den(147) = den(1)*den(146)
  den(148) = den(9)*den(145)
  den(149) = den(1)*den(148)
  den(150) = den(11)*den(146)
  den(151) = den(11)*den(148)
  den(152) = den(29)*den(115)
  den(154) = den(39)*den(153)
  den(155) = den(2)*den(154)
  den(156) = den(8)*den(154)
  den(157) = den(45)*den(153)
  den(158) = den(2)*den(157)
  den(159) = den(8)*den(157)
  den(161) = den(30)*den(160)
  den(162) = den(1)*den(161)
  den(163) = den(34)*den(160)
  den(164) = den(1)*den(163)
  den(165) = den(11)*den(161)
  den(166) = den(11)*den(163)
  den(168) = den(105)*den(167)
  den(169) = den(59)*den(168)
  den(170) = den(64)*den(168)
  den(171) = den(26)*den(105)
  den(172) = den(59)*den(171)
  den(173) = den(64)*den(171)
  den(174) = den(68)*den(168)
  den(175) = den(71)*den(168)
  den(176) = den(68)*den(171)
  den(177) = den(71)*den(171)
  den(178) = den(84)*den(171)
  den(179) = den(87)*den(171)
  den(180) = den(91)*den(171)
  den(181) = den(93)*den(171)
  den(182) = den(3)**2
  den(183) = den(115)*den(182)
  den(184) = den(2)*den(182)
  den(185) = den(6)*den(184)
  den(186) = den(8)*den(182)
  den(187) = den(6)*den(186)
  den(188) = den(12)*den(184)
  den(189) = den(12)*den(186)
  den(190) = den(1)*den(182)
  den(191) = den(17)*den(190)
  den(192) = den(19)*den(190)
  den(193) = den(11)*den(182)
  den(194) = den(17)*den(193)
  den(195) = den(19)*den(193)
  den(196) = den(6)*den(146)
  den(197) = den(6)*den(148)
  den(198) = den(12)*den(146)
  den(199) = den(12)*den(148)
  den(200) = den(17)*den(139)
  den(201) = den(19)*den(139)
  den(202) = den(17)*den(142)
  den(203) = den(19)*den(142)
  den(204) = den(29)**2
  den(205) = den(115)*den(204)
  den(206) = den(32)*den(161)
  den(207) = den(32)*den(163)
  den(208) = den(36)*den(161)
  den(209) = den(36)*den(163)
  den(210) = den(41)*den(154)
  den(211) = den(43)*den(154)
  den(212) = den(41)*den(157)
  den(213) = den(43)*den(157)
  den(214) = den(2)*den(204)
  den(215) = den(32)*den(214)
  den(216) = den(8)*den(204)
  den(217) = den(32)*den(216)
  den(218) = den(36)*den(214)
  den(219) = den(36)*den(216)
  den(220) = den(1)*den(204)
  den(221) = den(41)*den(220)
  den(222) = den(43)*den(220)
  den(223) = den(11)*den(204)
  den(224) = den(41)*den(223)
  den(225) = den(43)*den(223)
  den(226) = den(17)*den(160)
  den(227) = den(32)*den(226)
  den(228) = den(19)*den(160)
  den(229) = den(32)*den(228)
  den(230) = den(36)*den(226)
  den(231) = den(36)*den(228)
  den(232) = den(6)*den(153)
  den(233) = den(41)*den(232)
  den(234) = den(43)*den(232)
  den(235) = den(12)*den(153)
  den(236) = den(41)*den(235)
  den(237) = den(43)*den(235)
  den(238) = den(32)*den(138)
  den(239) = den(17)*den(238)
  den(240) = den(19)*den(238)
  den(241) = den(36)*den(138)
  den(242) = den(17)*den(241)
  den(243) = den(19)*den(241)
  den(244) = den(41)*den(145)
  den(245) = den(6)*den(244)
  den(246) = den(43)*den(145)
  den(247) = den(6)*den(246)
  den(248) = den(12)*den(244)
  den(249) = den(12)*den(246)
  den(251) = den(59)*den(250)
  den(252) = den(182)*den(251)
  den(253) = den(59)*den(114)
  den(254) = den(182)*den(253)
  den(255) = den(64)*den(250)
  den(256) = den(182)*den(255)
  den(257) = den(64)*den(114)
  den(258) = den(182)*den(257)
  den(259) = den(68)*den(250)
  den(260) = den(182)*den(259)
  den(261) = den(68)*den(114)
  den(262) = den(182)*den(261)
  den(263) = den(71)*den(250)
  den(264) = den(182)*den(263)
  den(265) = den(71)*den(114)
  den(266) = den(182)*den(265)
  den(267) = den(204)*den(251)
  den(268) = den(204)*den(253)
  den(269) = den(204)*den(255)
  den(270) = den(204)*den(257)
  den(271) = den(204)*den(259)
  den(272) = den(204)*den(261)
  den(273) = den(204)*den(263)
  den(274) = den(204)*den(265)
  den(275) = den(84)*den(250)
  den(276) = den(182)*den(275)
  den(277) = den(84)*den(114)
  den(278) = den(182)*den(277)
  den(279) = den(87)*den(250)
  den(280) = den(182)*den(279)
  den(281) = den(87)*den(114)
  den(282) = den(182)*den(281)
  den(283) = den(91)*den(250)
  den(284) = den(182)*den(283)
  den(285) = den(93)*den(250)
  den(286) = den(182)*den(285)
  den(287) = den(91)*den(114)
  den(288) = den(182)*den(287)
  den(289) = den(93)*den(114)
  den(290) = den(182)*den(289)
  den(291) = den(204)*den(275)
  den(292) = den(204)*den(277)
  den(293) = den(204)*den(279)
  den(294) = den(204)*den(281)
  den(295) = den(204)*den(283)
  den(296) = den(204)*den(285)
  den(297) = den(204)*den(287)
  den(298) = den(204)*den(289)
  den(300) = den(32)*den(299)
  den(301) = den(36)*den(299)
  den(302) = den(2)*den(32)
  den(304) = den(302)*den(303)
  den(305) = den(8)*den(32)
  den(306) = den(303)*den(305)
  den(307) = den(2)*den(36)
  den(308) = den(303)*den(307)
  den(309) = den(8)*den(36)
  den(310) = den(303)*den(309)
  den(311) = den(6)*den(299)
  den(312) = den(12)*den(299)
  den(313) = den(2)*den(6)
  den(315) = den(313)*den(314)
  den(316) = den(6)*den(8)
  den(317) = den(314)*den(316)
  den(318) = den(2)*den(12)
  den(319) = den(314)*den(318)
  den(320) = den(8)*den(12)
  den(321) = den(314)*den(320)
  den(323) = den(41)*den(322)
  den(324) = den(43)*den(322)
  den(325) = den(1)*den(41)
  den(326) = den(303)*den(325)
  den(327) = den(1)*den(43)
  den(328) = den(303)*den(327)
  den(329) = den(11)*den(41)
  den(330) = den(303)*den(329)
  den(331) = den(11)*den(43)
  den(332) = den(303)*den(331)
  den(333) = den(17)*den(322)
  den(334) = den(19)*den(322)
  den(335) = den(1)*den(17)
  den(336) = den(314)*den(335)
  den(337) = den(1)*den(19)
  den(338) = den(314)*den(337)
  den(339) = den(11)*den(17)
  den(340) = den(314)*den(339)
  den(341) = den(11)*den(19)
  den(342) = den(314)*den(341)
  den(343) = den(115)*den(303)
  den(344) = den(115)*den(314)
  den(345) = den(59)*den(117)
  den(346) = den(64)*den(117)
  den(347) = den(68)*den(117)
  den(348) = den(71)*den(117)
  den(349) = den(251)*den(303)
  den(350) = den(253)*den(303)
  den(351) = den(255)*den(303)
  den(352) = den(257)*den(303)
  den(353) = den(251)*den(314)
  den(354) = den(253)*den(314)
  den(355) = den(255)*den(314)
  den(356) = den(257)*den(314)
  den(357) = den(259)*den(303)
  den(358) = den(261)*den(303)
  den(359) = den(263)*den(303)
  den(360) = den(265)*den(303)
  den(361) = den(259)*den(314)
  den(362) = den(261)*den(314)
  den(363) = den(263)*den(314)
  den(364) = den(265)*den(314)
  den(365) = den(275)*den(303)
  den(366) = den(277)*den(303)
  den(367) = den(279)*den(303)
  den(368) = den(281)*den(303)
  den(369) = den(275)*den(314)
  den(370) = den(277)*den(314)
  den(371) = den(279)*den(314)
  den(372) = den(281)*den(314)
  den(373) = den(283)*den(303)
  den(374) = den(285)*den(303)
  den(375) = den(287)*den(303)
  den(376) = den(289)*den(303)
  den(377) = den(283)*den(314)
  den(378) = den(285)*den(314)
  den(379) = den(287)*den(314)
  den(380) = den(289)*den(314)
  den(381) = den(1)*den(24)*den(105)
  den(382) = den(11)*den(24)*den(105)
  den(383) = den(1)*den(2)*den(105)
  den(384) = den(1)*den(8)*den(105)
  den(385) = den(2)*den(11)*den(105)
  den(386) = den(8)*den(11)*den(105)
  den(387) = den(2)*den(3)*den(6)
  den(388) = den(3)*den(6)*den(8)
  den(389) = den(2)*den(3)*den(12)
  den(390) = den(3)*den(8)*den(12)
  den(391) = den(1)*den(3)*den(17)
  den(392) = den(1)*den(3)*den(19)
  den(393) = den(3)*den(11)*den(17)
  den(394) = den(3)*den(11)*den(19)
  den(395) = den(1)*den(2)*den(3)
  den(396) = den(1)*den(3)*den(8)
  den(397) = den(2)*den(3)*den(11)
  den(398) = den(3)*den(8)*den(11)
  den(399) = den(2)*den(29)*den(32)
  den(400) = den(8)*den(29)*den(32)
  den(401) = den(2)*den(29)*den(36)
  den(402) = den(8)*den(29)*den(36)
  den(403) = den(1)*den(29)*den(41)
  den(404) = den(1)*den(29)*den(43)
  den(405) = den(11)*den(29)*den(41)
  den(406) = den(11)*den(29)*den(43)
  den(407) = den(1)*den(2)*den(29)
  den(408) = den(1)*den(8)*den(29)
  den(409) = den(2)*den(11)*den(29)
  den(410) = den(8)*den(11)*den(29)
  den(411) = den(24)*den(300)
  den(412) = den(24)*den(301)
  den(413) = den(2)*den(300)
  den(414) = den(8)*den(300)
  den(415) = den(2)*den(301)
  den(416) = den(8)*den(301)
  den(417) = den(2)*den(238)
  den(418) = den(8)*den(238)
  den(419) = den(2)*den(241)
  den(420) = den(8)*den(241)
  den(421) = den(24)*den(311)
  den(422) = den(24)*den(312)
  den(423) = den(2)*den(311)
  den(424) = den(8)*den(311)
  den(425) = den(2)*den(312)
  den(426) = den(8)*den(312)
  den(427) = den(2)*den(232)
  den(428) = den(8)*den(232)
  den(429) = den(2)*den(235)
  den(430) = den(8)*den(235)
  den(431) = den(1)*den(323)
  den(432) = den(1)*den(324)
  den(433) = den(11)*den(323)
  den(434) = den(11)*den(324)
  den(435) = den(1)*den(244)
  den(436) = den(1)*den(246)
  den(437) = den(11)*den(244)
  den(438) = den(11)*den(246)
  den(439) = den(1)*den(333)
  den(440) = den(1)*den(334)
  den(441) = den(11)*den(333)
  den(442) = den(11)*den(334)
  den(443) = den(1)*den(226)
  den(444) = den(1)*den(228)
  den(445) = den(11)*den(226)
  den(446) = den(11)*den(228)
  den(447) = den(105)*den(345)
  den(448) = den(105)*den(346)
  den(449) = den(105)*den(251)
  den(450) = den(105)*den(253)
  den(451) = den(105)*den(255)
  den(452) = den(105)*den(257)
  den(453) = den(105)*den(347)
  den(454) = den(105)*den(348)
  den(455) = den(105)*den(259)
  den(456) = den(105)*den(261)
  den(457) = den(105)*den(263)
  den(458) = den(105)*den(265)
  den(459) = den(3)*den(251)
  den(460) = den(3)*den(253)
  den(461) = den(3)*den(255)
  den(462) = den(3)*den(257)
  den(463) = den(3)*den(259)
  den(464) = den(3)*den(261)
  den(465) = den(3)*den(263)
  den(466) = den(3)*den(265)
  den(467) = den(29)*den(251)
  den(468) = den(29)*den(253)
  den(469) = den(29)*den(255)
  den(470) = den(29)*den(257)
  den(471) = den(29)*den(259)
  den(472) = den(29)*den(261)
  den(473) = den(29)*den(263)
  den(474) = den(29)*den(265)
  den(475) = den(105)*den(275)
  den(476) = den(105)*den(277)
  den(477) = den(105)*den(279)
  den(478) = den(105)*den(281)
  den(479) = den(105)*den(283)
  den(480) = den(105)*den(285)
  den(481) = den(105)*den(287)
  den(482) = den(105)*den(289)
  den(483) = den(3)*den(275)
  den(484) = den(3)*den(277)
  den(485) = den(3)*den(279)
  den(486) = den(3)*den(281)
  den(487) = den(3)*den(283)
  den(488) = den(3)*den(285)
  den(489) = den(3)*den(287)
  den(490) = den(3)*den(289)
  den(491) = den(29)*den(275)
  den(492) = den(29)*den(277)
  den(493) = den(29)*den(279)
  den(494) = den(29)*den(281)
  den(495) = den(29)*den(283)
  den(496) = den(29)*den(285)
  den(497) = den(29)*den(287)
  den(498) = den(29)*den(289)
  den(499) = den(3)*den(315)
  den(500) = den(3)*den(317)
  den(501) = den(3)*den(319)
  den(502) = den(3)*den(321)
  den(503) = den(3)*den(336)
  den(504) = den(3)*den(338)
  den(505) = den(3)*den(340)
  den(506) = den(3)*den(342)
  den(507) = den(3)*den(344)
  den(508) = den(29)*den(304)
  den(509) = den(29)*den(306)
  den(510) = den(29)*den(308)
  den(511) = den(29)*den(310)
  den(512) = den(29)*den(326)
  den(513) = den(29)*den(328)
  den(514) = den(29)*den(330)
  den(515) = den(29)*den(332)
  den(516) = den(29)*den(343)
  den(517) = den(3)*den(353)
  den(518) = den(3)*den(354)
  den(519) = den(3)*den(355)
  den(520) = den(3)*den(356)
  den(521) = den(3)*den(361)
  den(522) = den(3)*den(362)
  den(523) = den(3)*den(363)
  den(524) = den(3)*den(364)
  den(525) = den(29)*den(349)
  den(526) = den(29)*den(350)
  den(527) = den(29)*den(351)
  den(528) = den(29)*den(352)
  den(529) = den(29)*den(357)
  den(530) = den(29)*den(358)
  den(531) = den(29)*den(359)
  den(532) = den(29)*den(360)
  den(533) = den(3)*den(369)
  den(534) = den(3)*den(370)
  den(535) = den(3)*den(371)
  den(536) = den(3)*den(372)
  den(537) = den(3)*den(377)
  den(538) = den(3)*den(378)
  den(539) = den(3)*den(379)
  den(540) = den(3)*den(380)
  den(541) = den(29)*den(365)
  den(542) = den(29)*den(366)
  den(543) = den(29)*den(367)
  den(544) = den(29)*den(368)
  den(545) = den(29)*den(373)
  den(546) = den(29)*den(374)
  den(547) = den(29)*den(375)
  den(548) = den(29)*den(376)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif

! **********************************************************************
subroutine allocate_diagrams()
!-----------------------------------------------------------------------
! After the first Born evaluation, colour-stripped amplitudes and
! colour vectors are initialiased with the minimum number of relevant
! helicity states.
! **********************************************************************
#ifndef PRECISION_dp
  use ol_loop_storage_ppllllj_eexmmxuuxg_1_/**/DREALKIND, only: hel_states
#endif
  implicit none

  if (allocated(A)) deallocate(A)
  if (allocated(M1helarray)) deallocate(M1helarray)
  if (allocated(M1helarray_ct)) deallocate(M1helarray_ct)
  if (allocated(M0_col1_helarray)) deallocate(M0_col1_helarray)
  allocate(A(hel_states,310))
  allocate(M1helarray(1,hel_states))
  allocate(M1helarray_ct(1,hel_states))
  allocate(M0_col1_helarray(1,hel_states))
#if -1 > 0
  if (allocated(M0M1_hel_cc)) deallocate(M0M1_hel_cc)
  allocate(M0M1_hel_cc(1,hel_states,29))
#endif
end subroutine allocate_diagrams

!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
#else
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
  use ol_loop_storage_ppllllj_eexmmxuuxg_1_/**/DREALKIND, only: &
  nhel, Hel, hel_states
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for e- e+ mu- mu+ up anti-up glue -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init, ensure_mp_loop_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_settings_ppllllj_eexmmxuuxg_1, only: hel_mem_opt, loopcc
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppllllj_eexmmxuuxg_1, only: &
    & external_perm_ppllllj_eexmmxuuxg_1, &
    & external_perm_inv_ppllllj_eexmmxuuxg_1, &
    & extcomb_perm_ppllllj_eexmmxuuxg_1, &
    & average_factor_ppllllj_eexmmxuuxg_1
  use ol_external_ppllllj_eexmmxuuxg_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppllllj_eexmmxuuxg_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppllllj_eexmmxuuxg_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_ppllllj_eexmmxuuxg_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,7)
  real(REALKIND),  intent(out) :: M02
  logical, intent(in) :: qp_kinematics
  real(REALKIND),  intent(out), optional :: M2ct
  real(REALKIND),  intent(out), optional :: M2colint(29)
  real(REALKIND) :: iM2ct
  real(REALKIND) :: iM2colint(29)

  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,7)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,7)
#endif
  integer           :: extmasses2(7)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(29)
  complex(REALKIND) :: M1(1), M2(1)
  real(REALKIND)    :: P_scatt_intern(0:3,7)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(29), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak
  logical              :: do_ct, do_colint
#if 7 > 3
  integer :: ind_cc_comb(14)
#endif
  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if (present(M2ct)) then
    do_ct = .true.
  else
    do_ct = .false.
  end if

  if (present(M2colint)) then
    do_colint = .true.
  else
    do_colint = .false.
  end if

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, qp_kinematics, M2ct=iM2ct, M2colint=iM2colint)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,310))
  end if

  if (do_ct) call set_parameter("ew_renorm", 0)
  call parameters_flush()
  call ensure_mp_init()
  if (do_ct) call ensure_mp_loop_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    call check_forced_parameters()
  end if
  if (do_ct) call fac_init_loop()

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, nMM, nMM, 0, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_ppllllj_eexmmxuuxg_1, 7, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_Q(P(:,3), rMM, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rMM, H4, ex4, POLSEL(4),4)
  call pol_wf_Q(P(:,5), rZERO, H5, ex5, POLSEL(5),5)
  call pol_wf_A(P(:,6), rZERO, H6, ex6, POLSEL(6),6)
  call pol_wf_V(P(:,7), rZERO, H7, ex7, POLSEL(7),7)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_QA_V(ntry, ex3(:), ex4(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_VQ_A(ntry, ex7(:), ex5(:), wf4(:,3), n3(:,3), t3x4(:,:,3))
  call prop_Q_A(ntry, wf4(:,3), 80, ZERO, 0_intkind1, wf4(:,4), n2(1))
  call vert_AV_Q(ntry, ex6(:), wf4(:,1), wf8(:,1), n3(:,4), t3x8(:,:,1))
  call vert_VQ_A(ntry, wf4(:,2), wf4(:,4), wf16(:,1), n3(:,5), t3x16(:,:,1))
  call prop_A_Q(ntry, wf8(:,1), 35, ZERO, 0_intkind1, wf8(:,2), n2(2))
  call vert_QA_Z(gZl,ntry, ex3(:), ex4(:), wf4(:,5), n3(:,6), t3x4(:,:,4))
  call prop_W_W(ntry, wf4(:,5), 12, MZ, 1_intkind1, wf4(:,6), n2(3))
  call vert_ZQ_A(gZu,ntry, wf4(:,6), wf4(:,4), wf16(:,2), n3(:,7), t3x16(:,:,2))
  call vert_QA_Z(gZl,ntry, ex1(:), ex2(:), wf4(:,7), n3(:,8), t3x4(:,:,5))
  call prop_W_W(ntry, wf4(:,7), 3, MZ, 1_intkind1, wf4(:,8), n2(4))
  call vert_AZ_Q(gZu,ntry, ex6(:), wf4(:,8), wf8(:,3), n3(:,9), t3x8(:,:,2))
  call prop_A_Q(ntry, wf8(:,3), 35, ZERO, 0_intkind1, wf8(:,4), n2(5))
  call vert_AV_Q(ntry, ex6(:), wf4(:,2), wf8(:,5), n3(:,10), t3x8(:,:,3))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,4), wf16(:,3), n3(:,11), t3x16(:,:,3))
  call prop_A_Q(ntry, wf8(:,5), 44, ZERO, 0_intkind1, wf8(:,6), n2(6))
  call vert_AZ_Q(gZu,ntry, ex6(:), wf4(:,6), wf8(:,7), n3(:,12), t3x8(:,:,4))
  call prop_A_Q(ntry, wf8(:,7), 44, ZERO, 0_intkind1, wf8(:,8), n2(7))
  call vert_ZQ_A(gZu,ntry, wf4(:,8), wf4(:,4), wf16(:,4), n3(:,13), t3x16(:,:,4))
  call vert_AQ_S(gH,ntry, ex4(:), ex3(:), wf4(:,9), n3(:,14), t3x4(:,:,6))
  call vert_QA_Z(gZu,ntry, wf4(:,4), ex6(:), wf8(:,9), n3(:,15), t3x8(:,:,5))
  call vert_SV_V(ntry, wf4(:,9), wf4(:,8), wf16(:,5), n3(:,16), t3x16(:,:,5))
  call prop_W_W(ntry, wf8(:,9), 112, MZ, 1_intkind1, wf8(:,10), n2(8))
  call vert_AV_Q(ntry, ex6(:), ex7(:), wf4(:,10), n3(:,17), t3x4(:,:,7))
  call prop_A_Q(ntry, wf4(:,10), 96, ZERO, 0_intkind1, wf4(:,11), n2(9))
  call vert_VQ_A(ntry, wf4(:,1), ex5(:), wf8(:,11), n3(:,18), t3x8(:,:,6))
  call vert_AV_Q(ntry, wf4(:,11), wf4(:,2), wf16(:,6), n3(:,19), t3x16(:,:,6))
  call prop_Q_A(ntry, wf8(:,11), 19, ZERO, 0_intkind1, wf8(:,12), n2(10))
  call vert_AZ_Q(gZu,ntry, wf4(:,11), wf4(:,6), wf16(:,7), n3(:,20), t3x16(:,:,7))
  call vert_ZQ_A(gZu,ntry, wf4(:,8), ex5(:), wf8(:,13), n3(:,21), t3x8(:,:,7))
  call prop_Q_A(ntry, wf8(:,13), 19, ZERO, 0_intkind1, wf8(:,14), n2(11))
  call vert_VQ_A(ntry, wf4(:,2), ex5(:), wf8(:,15), n3(:,22), t3x8(:,:,8))
  call vert_AV_Q(ntry, wf4(:,11), wf4(:,1), wf16(:,8), n3(:,23), t3x16(:,:,8))
  call prop_Q_A(ntry, wf8(:,15), 28, ZERO, 0_intkind1, wf8(:,16), n2(12))
  call vert_ZQ_A(gZu,ntry, wf4(:,6), ex5(:), wf8(:,17), n3(:,24), t3x8(:,:,9))
  call prop_Q_A(ntry, wf8(:,17), 28, ZERO, 0_intkind1, wf8(:,18), n2(13))
  call vert_AZ_Q(gZu,ntry, wf4(:,11), wf4(:,8), wf16(:,9), n3(:,25), t3x16(:,:,9))
  call vert_QA_Z(gZu,ntry, ex5(:), wf4(:,11), wf8(:,19), n3(:,26), t3x8(:,:,10))
  call prop_W_W(ntry, wf8(:,19), 112, MZ, 1_intkind1, wf8(:,20), n2(14))
  call vert_VQ_A(ntry, ex7(:), wf8(:,12), wf16(:,10), n3(:,27), t3x16(:,:,10))
  call vert_VQ_A(ntry, ex7(:), wf8(:,14), wf16(:,11), n3(:,28), t3x16(:,:,11))
  call vert_VQ_A(ntry, ex7(:), wf8(:,16), wf16(:,12), n3(:,29), t3x16(:,:,12))
  call vert_VQ_A(ntry, ex7(:), wf8(:,18), wf16(:,13), n3(:,30), t3x16(:,:,13))
  call vert_VQ_A(ntry, wf4(:,1), ex3(:), wf8(:,21), n3(:,31), t3x8(:,:,11))
  call vert_QA_V(ntry, wf4(:,4), ex6(:), wf8(:,22), n3(:,32), t3x8(:,:,12))
  call prop_Q_A(ntry, wf8(:,21), 7, MM, 1_intkind1, wf8(:,23), n2(15))
  call vert_QA_V(ntry, wf8(:,23), ex4(:), wf16(:,14), n3(:,33), t3x16(:,:,14))
  call vert_QA_Z(gZl,ntry, wf8(:,23), ex4(:), wf16(:,15), n3(:,34), t3x16(:,:,15))
  call vert_ZQ_A(gZl,ntry, wf4(:,8), ex3(:), wf8(:,24), n3(:,35), t3x8(:,:,13))
  call prop_Q_A(ntry, wf8(:,24), 7, MM, 1_intkind1, wf8(:,25), n2(16))
  call vert_QA_V(ntry, wf8(:,25), ex4(:), wf16(:,16), n3(:,36), t3x16(:,:,16))
  call vert_QA_Z(gZl,ntry, wf8(:,25), ex4(:), wf16(:,17), n3(:,37), t3x16(:,:,17))
  call vert_AV_Q(ntry, ex4(:), wf4(:,1), wf8(:,26), n3(:,38), t3x8(:,:,14))
  call prop_A_Q(ntry, wf8(:,26), 11, MM, 1_intkind1, wf8(:,27), n2(17))
  call vert_QA_V(ntry, ex3(:), wf8(:,27), wf16(:,18), n3(:,39), t3x16(:,:,18))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,27), wf16(:,19), n3(:,40), t3x16(:,:,19))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,8), wf8(:,28), n3(:,41), t3x8(:,:,15))
  call prop_A_Q(ntry, wf8(:,28), 11, MM, 1_intkind1, wf8(:,29), n2(18))
  call vert_QA_V(ntry, ex3(:), wf8(:,29), wf16(:,20), n3(:,42), t3x16(:,:,20))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,29), wf16(:,21), n3(:,43), t3x16(:,:,21))
  call vert_QA_V(ntry, ex5(:), wf4(:,11), wf8(:,30), n3(:,44), t3x8(:,:,16))
  call vert_VQ_A(ntry, wf4(:,2), ex1(:), wf8(:,31), n3(:,45), t3x8(:,:,17))
  call prop_Q_A(ntry, wf8(:,31), 13, ZERO, 0_intkind1, wf8(:,32), n2(19))
  call vert_QA_V(ntry, wf8(:,32), ex2(:), wf16(:,22), n3(:,46), t3x16(:,:,22))
  call vert_QA_Z(gZl,ntry, wf8(:,32), ex2(:), wf16(:,23), n3(:,47), t3x16(:,:,23))
  call vert_ZQ_A(gZl,ntry, wf4(:,6), ex1(:), wf8(:,33), n3(:,48), t3x8(:,:,18))
  call prop_Q_A(ntry, wf8(:,33), 13, ZERO, 0_intkind1, wf8(:,34), n2(20))
  call vert_QA_V(ntry, wf8(:,34), ex2(:), wf16(:,24), n3(:,49), t3x16(:,:,24))
  call vert_QA_Z(gZl,ntry, wf8(:,34), ex2(:), wf16(:,25), n3(:,50), t3x16(:,:,25))
  call vert_AV_Q(ntry, ex2(:), wf4(:,2), wf8(:,35), n3(:,51), t3x8(:,:,19))
  call prop_A_Q(ntry, wf8(:,35), 14, ZERO, 0_intkind1, wf8(:,36), n2(21))
  call vert_QA_V(ntry, ex1(:), wf8(:,36), wf16(:,26), n3(:,52), t3x16(:,:,26))
  call vert_AZ_Q(gZl,ntry, ex2(:), wf4(:,6), wf8(:,37), n3(:,53), t3x8(:,:,20))
  call prop_A_Q(ntry, wf8(:,37), 14, ZERO, 0_intkind1, wf8(:,38), n2(22))
  call vert_QA_V(ntry, ex1(:), wf8(:,38), wf16(:,27), n3(:,54), t3x16(:,:,27))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,36), wf16(:,28), n3(:,55), t3x16(:,:,28))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,38), wf16(:,29), n3(:,56), t3x16(:,:,29))
  call vert_QA_V(ntry, ex5(:), ex6(:), wf4(:,12), n3(:,57), t3x4(:,:,8))
  call counter_VVG_G(ntry, wf4(:,1), wf4(:,2), ex7(:), wf32(:,1), n4(:,1), t4x32(:,:,1))
  call counter_VVG_G(ntry, wf4(:,1), wf4(:,6), ex7(:), wf32(:,2), n4(:,2), t4x32(:,:,2))
  call counter_VVG_G(ntry, wf4(:,8), wf4(:,2), ex7(:), wf32(:,3), n4(:,3), t4x32(:,:,3))
  call counter_VVG_G(ntry, wf4(:,8), wf4(:,6), ex7(:), wf32(:,4), n4(:,4), t4x32(:,:,4))
  call counter_GG_V(ntry, wf4(:,12), 48, ex7(:), 64, wf8(:,39), n3(:,58), t3x8(:,:,21))
  call prop_W_W(ntry, wf16(:,5), 15, MZ, 1_intkind1, wf16(:,30), n2(23))
  call vert_VV_S(ntry, wf4(:,8), wf4(:,6), wf16(:,31), n3(:,59), t3x16(:,:,30))
  call counter_GG_S(ntry, wf4(:,12), ex7(:), wf8(:,40), n3(:,60), t3x8(:,:,22))
  call counter_VQ_A(ntry, wf4(:,2), wf4(:,4), wf16(:,32), n3(:,61), t3x16(:,:,31))
  call counter_ZQ_A(gZu,ntry, wf4(:,6), wf4(:,4), wf16(:,33), n3(:,62), t3x16(:,:,32))
  call counter_VQ_A(ntry, wf4(:,1), wf4(:,4), wf16(:,34), n3(:,63), t3x16(:,:,33))
  call counter_ZQ_A(gZu,ntry, wf4(:,8), wf4(:,4), wf16(:,35), n3(:,64), t3x16(:,:,34))
  call counter_AV_Q(ntry, wf4(:,11), wf4(:,2), wf16(:,36), n3(:,65), t3x16(:,:,35))
  call counter_AZ_Q(gZu,ntry, wf4(:,11), wf4(:,6), wf16(:,37), n3(:,66), t3x16(:,:,36))
  call counter_AV_Q(ntry, wf4(:,11), wf4(:,1), wf16(:,38), n3(:,67), t3x16(:,:,37))
  call counter_AZ_Q(gZu,ntry, wf4(:,11), wf4(:,8), wf16(:,39), n3(:,68), t3x16(:,:,38))
  call counter_VQ_A(ntry, ex7(:), wf8(:,12), wf16(:,40), n3(:,69), t3x16(:,:,39))
  call counter_VQ_A(ntry, ex7(:), wf8(:,14), wf16(:,41), n3(:,70), t3x16(:,:,40))
  call counter_SG_G(ntry, wf4(:,9), ex7(:), wf8(:,41), n3(:,71), t3x8(:,:,23))
  call vert_QA_V(ntry, wf8(:,12), ex6(:), wf16(:,42), n3(:,72), t3x16(:,:,41))
  call vert_QA_V(ntry, wf8(:,14), ex6(:), wf16(:,43), n3(:,73), t3x16(:,:,42))
  call counter_VG_G(ntry, wf4(:,6), ex7(:), 64, wf8(:,42), 76, n3(:,74), t3x8(:,:,24))
  call counter_VQ_A(ntry, ex7(:), wf8(:,16), wf16(:,44), n3(:,75), t3x16(:,:,43))
  call counter_VQ_A(ntry, ex7(:), wf8(:,18), wf16(:,45), n3(:,76), t3x16(:,:,44))
  call vert_QA_V(ntry, ex5(:), wf8(:,2), wf16(:,46), n3(:,77), t3x16(:,:,45))
  call vert_QA_V(ntry, ex5(:), wf8(:,4), wf16(:,47), n3(:,78), t3x16(:,:,46))
  call counter_VG_G(ntry, wf4(:,8), ex7(:), 64, wf8(:,43), 67, n3(:,79), t3x8(:,:,25))
  call vert_QA_V(ntry, wf8(:,16), ex6(:), wf16(:,48), n3(:,80), t3x16(:,:,47))
  call vert_QA_V(ntry, wf8(:,18), ex6(:), wf16(:,49), n3(:,81), t3x16(:,:,48))
  call vert_QA_V(ntry, ex5(:), wf8(:,6), wf16(:,50), n3(:,82), t3x16(:,:,49))
  call vert_QA_V(ntry, ex5(:), wf8(:,8), wf16(:,51), n3(:,83), t3x16(:,:,50))
  call counter_QA_Z(gZu,ntry, wf4(:,4), ex6(:), wf8(:,44), n3(:,84), t3x8(:,:,26))
  call counter_AV_Q(ntry, ex6(:), wf4(:,2), wf8(:,45), n3(:,85), t3x8(:,:,27))
  call prop_Q_A(ntry, wf16(:,3), 83, ZERO, 0_intkind1, wf16(:,52), n2(24))
  call counter_AZ_Q(gZu,ntry, ex6(:), wf4(:,6), wf8(:,46), n3(:,86), t3x8(:,:,28))
  call prop_Q_A(ntry, wf16(:,4), 83, ZERO, 0_intkind1, wf16(:,53), n2(25))
  call counter_AV_Q(ntry, ex6(:), wf4(:,1), wf8(:,47), n3(:,87), t3x8(:,:,29))
  call prop_Q_A(ntry, wf16(:,1), 92, ZERO, 0_intkind1, wf16(:,54), n2(26))
  call prop_Q_A(ntry, wf16(:,2), 92, ZERO, 0_intkind1, wf16(:,55), n2(27))
  call counter_AZ_Q(gZu,ntry, ex6(:), wf4(:,8), wf8(:,48), n3(:,88), t3x8(:,:,30))
  call prop_A_Q(ntry, wf8(:,45), 44, ZERO, 0_intkind1, wf8(:,49), n2(28))
  call prop_A_Q(ntry, wf8(:,46), 44, ZERO, 0_intkind1, wf8(:,50), n2(29))
  call prop_A_Q(ntry, wf8(:,47), 35, ZERO, 0_intkind1, wf8(:,51), n2(30))
  call prop_A_Q(ntry, wf8(:,48), 35, ZERO, 0_intkind1, wf8(:,52), n2(31))
  call counter_AV_Q(ntry, ex6(:), ex7(:), wf4(:,13), n3(:,89), t3x4(:,:,9))
  call prop_A_Q(ntry, wf4(:,13), 96, ZERO, 0_intkind1, wf4(:,14), n2(32))
  call vert_AV_Q(ntry, wf4(:,14), wf4(:,2), wf16(:,56), n3(:,90), t3x16(:,:,51))
  call vert_AZ_Q(gZu,ntry, wf4(:,14), wf4(:,6), wf16(:,57), n3(:,91), t3x16(:,:,52))
  call vert_AV_Q(ntry, wf4(:,14), wf4(:,1), wf16(:,58), n3(:,92), t3x16(:,:,53))
  call vert_AZ_Q(gZu,ntry, wf4(:,14), wf4(:,8), wf16(:,59), n3(:,93), t3x16(:,:,54))
  call vert_QA_Z(gZu,ntry, ex5(:), wf4(:,14), wf8(:,53), n3(:,94), t3x8(:,:,31))
  call prop_W_W(ntry, wf8(:,53), 112, MZ, 1_intkind1, wf8(:,54), n2(33))
  call counter_QA_Z(gZu,ntry, ex5(:), wf4(:,11), wf8(:,55), n3(:,95), t3x8(:,:,32))
  call counter_VQ_A(ntry, wf4(:,2), ex5(:), wf8(:,56), n3(:,96), t3x8(:,:,33))
  call prop_A_Q(ntry, wf16(:,8), 99, ZERO, 0_intkind1, wf16(:,60), n2(34))
  call counter_ZQ_A(gZu,ntry, wf4(:,6), ex5(:), wf8(:,57), n3(:,97), t3x8(:,:,34))
  call prop_A_Q(ntry, wf16(:,9), 99, ZERO, 0_intkind1, wf16(:,61), n2(35))
  call counter_VQ_A(ntry, wf4(:,1), ex5(:), wf8(:,58), n3(:,98), t3x8(:,:,35))
  call prop_A_Q(ntry, wf16(:,6), 108, ZERO, 0_intkind1, wf16(:,62), n2(36))
  call prop_A_Q(ntry, wf16(:,7), 108, ZERO, 0_intkind1, wf16(:,63), n2(37))
  call counter_ZQ_A(gZu,ntry, wf4(:,8), ex5(:), wf8(:,59), n3(:,99), t3x8(:,:,36))
  call prop_Q_A(ntry, wf8(:,56), 28, ZERO, 0_intkind1, wf8(:,60), n2(38))
  call vert_VQ_A(ntry, ex7(:), wf8(:,60), wf16(:,64), n3(:,100), t3x16(:,:,55))
  call prop_Q_A(ntry, wf8(:,57), 28, ZERO, 0_intkind1, wf8(:,61), n2(39))
  call vert_VQ_A(ntry, ex7(:), wf8(:,61), wf16(:,65), n3(:,101), t3x16(:,:,56))
  call prop_Q_A(ntry, wf8(:,58), 19, ZERO, 0_intkind1, wf8(:,62), n2(40))
  call vert_VQ_A(ntry, ex7(:), wf8(:,62), wf16(:,66), n3(:,102), t3x16(:,:,57))
  call prop_Q_A(ntry, wf8(:,59), 19, ZERO, 0_intkind1, wf8(:,63), n2(41))
  call vert_VQ_A(ntry, ex7(:), wf8(:,63), wf16(:,67), n3(:,103), t3x16(:,:,58))
  call counter_VQ_A(ntry, ex7(:), ex5(:), wf4(:,15), n3(:,104), t3x4(:,:,10))
  call prop_Q_A(ntry, wf4(:,15), 80, ZERO, 0_intkind1, wf4(:,16), n2(42))
  call vert_VQ_A(ntry, wf4(:,2), wf4(:,16), wf16(:,68), n3(:,105), t3x16(:,:,59))
  call vert_ZQ_A(gZu,ntry, wf4(:,6), wf4(:,16), wf16(:,69), n3(:,106), t3x16(:,:,60))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,16), wf16(:,70), n3(:,107), t3x16(:,:,61))
  call vert_ZQ_A(gZu,ntry, wf4(:,8), wf4(:,16), wf16(:,71), n3(:,108), t3x16(:,:,62))
  call vert_QA_Z(gZu,ntry, wf4(:,16), ex6(:), wf8(:,64), n3(:,109), t3x8(:,:,37))
  call prop_W_W(ntry, wf8(:,64), 112, MZ, 1_intkind1, wf8(:,65), n2(43))
  call vert_AQ_S(gH,ntry, ex4(:), wf8(:,23), wf16(:,72), n3(:,110), t3x16(:,:,63))
  call vert_AQ_S(gH,ntry, ex4(:), wf8(:,25), wf16(:,73), n3(:,111), t3x16(:,:,64))
  call prop_W_W(ntry, wf8(:,39), 112, MZ, 1_intkind1, wf8(:,66), n2(44))
  call vert_AQ_S(gH,ntry, wf8(:,27), ex3(:), wf16(:,74), n3(:,112), t3x16(:,:,65))
  call vert_AQ_S(gH,ntry, wf8(:,29), ex3(:), wf16(:,75), n3(:,113), t3x16(:,:,66))
  call counter_QA_V(ntry, wf4(:,4), ex6(:), wf8(:,67), n3(:,114), t3x8(:,:,38))
  call prop_W_W(ntry, wf8(:,44), 112, MZ, 1_intkind1, wf8(:,68), n2(45))
  call vert_QA_V(ntry, ex5(:), wf4(:,14), wf8(:,69), n3(:,115), t3x8(:,:,39))
  call counter_QA_V(ntry, ex5(:), wf4(:,11), wf8(:,70), n3(:,116), t3x8(:,:,40))
  call prop_W_W(ntry, wf8(:,55), 112, MZ, 1_intkind1, wf8(:,71), n2(46))
  call vert_QA_V(ntry, wf4(:,16), ex6(:), wf8(:,72), n3(:,117), t3x8(:,:,41))
  call counter_Q_A(ctqq,2,ntry, wf4(:,4), 80, wf4(:,17), n2(47))
  call prop_Q_A(ntry, wf4(:,17), 80, ZERO, 0_intkind1, wf4(:,18), n2(48))
  call vert_QA_Z(gZu,ntry, wf4(:,18), ex6(:), wf8(:,73), n3(:,118), t3x8(:,:,42))
  call vert_VQ_A(ntry, wf4(:,2), wf4(:,18), wf16(:,76), n3(:,119), t3x16(:,:,67))
  call vert_ZQ_A(gZu,ntry, wf4(:,6), wf4(:,18), wf16(:,77), n3(:,120), t3x16(:,:,68))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,18), wf16(:,78), n3(:,121), t3x16(:,:,69))
  call vert_ZQ_A(gZu,ntry, wf4(:,8), wf4(:,18), wf16(:,79), n3(:,122), t3x16(:,:,70))
  call counter_A_Q(ctqq,2,ntry, wf8(:,2), 35, wf8(:,74), n2(49))
  call counter_A_Q(ctqq,2,ntry, wf8(:,4), 35, wf8(:,75), n2(50))
  call counter_A_Q(ctqq,2,ntry, wf8(:,6), 44, wf8(:,76), n2(51))
  call counter_A_Q(ctqq,2,ntry, wf8(:,8), 44, wf8(:,77), n2(52))
  call counter_A_Q(ctqq,2,ntry, wf4(:,11), 96, wf4(:,19), n2(53))
  call prop_A_Q(ntry, wf4(:,19), 96, ZERO, 0_intkind1, wf4(:,20), n2(54))
  call vert_QA_Z(gZu,ntry, ex5(:), wf4(:,20), wf8(:,78), n3(:,123), t3x8(:,:,43))
  call counter_Q_A(ctqq,2,ntry, wf8(:,12), 19, wf8(:,79), n2(55))
  call counter_Q_A(ctqq,2,ntry, wf8(:,14), 19, wf8(:,80), n2(56))
  call counter_Q_A(ctqq,2,ntry, wf8(:,16), 28, wf8(:,81), n2(57))
  call counter_Q_A(ctqq,2,ntry, wf8(:,18), 28, wf8(:,82), n2(58))
  call vert_AV_Q(ntry, wf4(:,20), wf4(:,2), wf16(:,80), n3(:,124), t3x16(:,:,71))
  call vert_AZ_Q(gZu,ntry, wf4(:,20), wf4(:,6), wf16(:,81), n3(:,125), t3x16(:,:,72))
  call vert_AV_Q(ntry, wf4(:,20), wf4(:,1), wf16(:,82), n3(:,126), t3x16(:,:,73))
  call vert_AZ_Q(gZu,ntry, wf4(:,20), wf4(:,8), wf16(:,83), n3(:,127), t3x16(:,:,74))
  call vert_AV_Q(ntry, wf8(:,6), ex7(:), wf16(:,84), n3(:,128), t3x16(:,:,75))
  call prop_A_Q(ntry, wf16(:,84), 108, ZERO, 0_intkind1, wf16(:,85), n2(59))
  call vert_AV_Q(ntry, wf8(:,8), ex7(:), wf16(:,86), n3(:,129), t3x16(:,:,76))
  call prop_A_Q(ntry, wf16(:,86), 108, ZERO, 0_intkind1, wf16(:,87), n2(60))
  call vert_AV_Q(ntry, wf8(:,2), ex7(:), wf16(:,88), n3(:,130), t3x16(:,:,77))
  call prop_A_Q(ntry, wf16(:,88), 99, ZERO, 0_intkind1, wf16(:,89), n2(61))
  call vert_AV_Q(ntry, wf8(:,4), ex7(:), wf16(:,90), n3(:,131), t3x16(:,:,78))
  call prop_A_Q(ntry, wf16(:,90), 99, ZERO, 0_intkind1, wf16(:,91), n2(62))
  call prop_Q_A(ntry, wf16(:,10), 83, ZERO, 0_intkind1, wf16(:,92), n2(63))
  call prop_Q_A(ntry, wf16(:,11), 83, ZERO, 0_intkind1, wf16(:,93), n2(64))
  call prop_Q_A(ntry, wf16(:,12), 92, ZERO, 0_intkind1, wf16(:,94), n2(65))
  call prop_Q_A(ntry, wf16(:,13), 92, ZERO, 0_intkind1, wf16(:,95), n2(66))
  call vert_QA_V(ntry, wf4(:,18), ex6(:), wf8(:,83), n3(:,132), t3x8(:,:,44))
  call prop_W_W(ntry, wf16(:,15), 15, MZ, 1_intkind1, wf16(:,96), n2(67))
  call prop_W_W(ntry, wf16(:,17), 15, MZ, 1_intkind1, wf16(:,97), n2(68))
  call prop_W_W(ntry, wf16(:,19), 15, MZ, 1_intkind1, wf16(:,98), n2(69))
  call prop_W_W(ntry, wf16(:,21), 15, MZ, 1_intkind1, wf16(:,99), n2(70))
  call vert_QA_V(ntry, ex5(:), wf4(:,20), wf8(:,84), n3(:,133), t3x8(:,:,45))
  call prop_W_W(ntry, wf16(:,23), 15, MZ, 1_intkind1, wf16(:,100), n2(71))
  call prop_W_W(ntry, wf16(:,25), 15, MZ, 1_intkind1, wf16(:,101), n2(72))
  call prop_W_W(ntry, wf16(:,28), 15, MZ, 1_intkind1, wf16(:,102), n2(73))
  call prop_W_W(ntry, wf16(:,29), 15, MZ, 1_intkind1, wf16(:,103), n2(74))
  call vert_VQ_A(ntry, wf4(:,2), wf8(:,12), wf32(:,5), n3(:,134), t3x32(:,:,1))
  call prop_Q_A(ntry, wf32(:,5), 31, ZERO, 0_intkind1, wf32(:,6), n2(75))
  call vert_ZQ_A(gZu,ntry, wf4(:,6), wf8(:,12), wf32(:,7), n3(:,135), t3x32(:,:,2))
  call prop_Q_A(ntry, wf32(:,7), 31, ZERO, 0_intkind1, wf32(:,8), n2(76))
  call vert_VQ_A(ntry, wf4(:,2), wf8(:,14), wf32(:,9), n3(:,136), t3x32(:,:,3))
  call prop_Q_A(ntry, wf32(:,9), 31, ZERO, 0_intkind1, wf32(:,10), n2(77))
  call vert_ZQ_A(gZu,ntry, wf4(:,6), wf8(:,14), wf32(:,11), n3(:,137), t3x32(:,:,4))
  call prop_Q_A(ntry, wf32(:,11), 31, ZERO, 0_intkind1, wf32(:,12), n2(78))
  call vert_AV_Q(ntry, wf8(:,2), wf4(:,2), wf32(:,13), n3(:,138), t3x32(:,:,5))
  call prop_A_Q(ntry, wf32(:,13), 47, ZERO, 0_intkind1, wf32(:,14), n2(79))
  call vert_AZ_Q(gZu,ntry, wf8(:,2), wf4(:,6), wf32(:,15), n3(:,139), t3x32(:,:,6))
  call prop_A_Q(ntry, wf32(:,15), 47, ZERO, 0_intkind1, wf32(:,16), n2(80))
  call vert_AV_Q(ntry, wf8(:,4), wf4(:,2), wf32(:,17), n3(:,140), t3x32(:,:,7))
  call prop_A_Q(ntry, wf32(:,17), 47, ZERO, 0_intkind1, wf32(:,18), n2(81))
  call vert_AZ_Q(gZu,ntry, wf8(:,4), wf4(:,6), wf32(:,19), n3(:,141), t3x32(:,:,8))
  call prop_A_Q(ntry, wf32(:,19), 47, ZERO, 0_intkind1, wf32(:,20), n2(82))
  call vert_VQ_A(ntry, wf4(:,1), wf8(:,16), wf32(:,21), n3(:,142), t3x32(:,:,9))
  call prop_Q_A(ntry, wf32(:,21), 31, ZERO, 0_intkind1, wf32(:,22), n2(83))
  call vert_VQ_A(ntry, wf4(:,1), wf8(:,18), wf32(:,23), n3(:,143), t3x32(:,:,10))
  call prop_Q_A(ntry, wf32(:,23), 31, ZERO, 0_intkind1, wf32(:,24), n2(84))
  call vert_ZQ_A(gZu,ntry, wf4(:,8), wf8(:,16), wf32(:,25), n3(:,144), t3x32(:,:,11))
  call prop_Q_A(ntry, wf32(:,25), 31, ZERO, 0_intkind1, wf32(:,26), n2(85))
  call vert_ZQ_A(gZu,ntry, wf4(:,8), wf8(:,18), wf32(:,27), n3(:,145), t3x32(:,:,12))
  call prop_Q_A(ntry, wf32(:,27), 31, ZERO, 0_intkind1, wf32(:,28), n2(86))
  call vert_AV_Q(ntry, wf8(:,6), wf4(:,1), wf32(:,29), n3(:,146), t3x32(:,:,13))
  call prop_A_Q(ntry, wf32(:,29), 47, ZERO, 0_intkind1, wf32(:,30), n2(87))
  call vert_AV_Q(ntry, wf8(:,8), wf4(:,1), wf32(:,31), n3(:,147), t3x32(:,:,14))
  call prop_A_Q(ntry, wf32(:,31), 47, ZERO, 0_intkind1, wf32(:,32), n2(88))
  call vert_AZ_Q(gZu,ntry, wf8(:,6), wf4(:,8), wf32(:,33), n3(:,148), t3x32(:,:,15))
  call prop_A_Q(ntry, wf32(:,33), 47, ZERO, 0_intkind1, wf32(:,34), n2(89))
  call vert_AZ_Q(gZu,ntry, wf8(:,8), wf4(:,8), wf32(:,35), n3(:,149), t3x32(:,:,16))
  call prop_A_Q(ntry, wf32(:,35), 47, ZERO, 0_intkind1, wf32(:,36), n2(90))
  call vert_ZQ_A(gZu,ntry, wf16(:,30), ex5(:), wf32(:,37), n3(:,150), t3x32(:,:,17))
  call prop_Q_A(ntry, wf32(:,37), 31, ZERO, 0_intkind1, wf32(:,38), n2(91))
  call vert_AZ_Q(gZu,ntry, ex6(:), wf16(:,30), wf32(:,39), n3(:,151), t3x32(:,:,18))
  call prop_A_Q(ntry, wf32(:,39), 47, ZERO, 0_intkind1, wf32(:,40), n2(92))
  call vert_VQ_A(ntry, wf16(:,14), ex5(:), wf32(:,41), n3(:,152), t3x32(:,:,19))
  call prop_Q_A(ntry, wf32(:,41), 31, ZERO, 0_intkind1, wf32(:,42), n2(93))
  call vert_ZQ_A(gZu,ntry, wf16(:,96), ex5(:), wf32(:,43), n3(:,153), t3x32(:,:,20))
  call prop_Q_A(ntry, wf32(:,43), 31, ZERO, 0_intkind1, wf32(:,44), n2(94))
  call vert_VQ_A(ntry, wf16(:,16), ex5(:), wf32(:,45), n3(:,154), t3x32(:,:,21))
  call prop_Q_A(ntry, wf32(:,45), 31, ZERO, 0_intkind1, wf32(:,46), n2(95))
  call vert_ZQ_A(gZu,ntry, wf16(:,97), ex5(:), wf32(:,47), n3(:,155), t3x32(:,:,22))
  call prop_Q_A(ntry, wf32(:,47), 31, ZERO, 0_intkind1, wf32(:,48), n2(96))
  call vert_AV_Q(ntry, ex6(:), wf16(:,14), wf32(:,49), n3(:,156), t3x32(:,:,23))
  call prop_A_Q(ntry, wf32(:,49), 47, ZERO, 0_intkind1, wf32(:,50), n2(97))
  call vert_AZ_Q(gZu,ntry, ex6(:), wf16(:,96), wf32(:,51), n3(:,157), t3x32(:,:,24))
  call prop_A_Q(ntry, wf32(:,51), 47, ZERO, 0_intkind1, wf32(:,52), n2(98))
  call vert_AV_Q(ntry, ex6(:), wf16(:,16), wf32(:,53), n3(:,158), t3x32(:,:,25))
  call prop_A_Q(ntry, wf32(:,53), 47, ZERO, 0_intkind1, wf32(:,54), n2(99))
  call vert_AZ_Q(gZu,ntry, ex6(:), wf16(:,97), wf32(:,55), n3(:,159), t3x32(:,:,26))
  call prop_A_Q(ntry, wf32(:,55), 47, ZERO, 0_intkind1, wf32(:,56), n2(100))
  call vert_VQ_A(ntry, wf16(:,18), ex5(:), wf32(:,57), n3(:,160), t3x32(:,:,27))
  call prop_Q_A(ntry, wf32(:,57), 31, ZERO, 0_intkind1, wf32(:,58), n2(101))
  call vert_ZQ_A(gZu,ntry, wf16(:,98), ex5(:), wf32(:,59), n3(:,161), t3x32(:,:,28))
  call prop_Q_A(ntry, wf32(:,59), 31, ZERO, 0_intkind1, wf32(:,60), n2(102))
  call vert_VQ_A(ntry, wf16(:,20), ex5(:), wf32(:,61), n3(:,162), t3x32(:,:,29))
  call prop_Q_A(ntry, wf32(:,61), 31, ZERO, 0_intkind1, wf32(:,62), n2(103))
  call vert_ZQ_A(gZu,ntry, wf16(:,99), ex5(:), wf32(:,63), n3(:,163), t3x32(:,:,30))
  call prop_Q_A(ntry, wf32(:,63), 31, ZERO, 0_intkind1, wf32(:,64), n2(104))
  call vert_AV_Q(ntry, ex6(:), wf16(:,18), wf32(:,65), n3(:,164), t3x32(:,:,31))
  call prop_A_Q(ntry, wf32(:,65), 47, ZERO, 0_intkind1, wf32(:,66), n2(105))
  call vert_AZ_Q(gZu,ntry, ex6(:), wf16(:,98), wf32(:,67), n3(:,165), t3x32(:,:,32))
  call prop_A_Q(ntry, wf32(:,67), 47, ZERO, 0_intkind1, wf32(:,68), n2(106))
  call vert_AV_Q(ntry, ex6(:), wf16(:,20), wf32(:,69), n3(:,166), t3x32(:,:,33))
  call prop_A_Q(ntry, wf32(:,69), 47, ZERO, 0_intkind1, wf32(:,70), n2(107))
  call vert_AZ_Q(gZu,ntry, ex6(:), wf16(:,99), wf32(:,71), n3(:,167), t3x32(:,:,34))
  call prop_A_Q(ntry, wf32(:,71), 47, ZERO, 0_intkind1, wf32(:,72), n2(108))
  call vert_VQ_A(ntry, wf16(:,22), ex5(:), wf32(:,73), n3(:,168), t3x32(:,:,35))
  call prop_Q_A(ntry, wf32(:,73), 31, ZERO, 0_intkind1, wf32(:,74), n2(109))
  call vert_ZQ_A(gZu,ntry, wf16(:,100), ex5(:), wf32(:,75), n3(:,169), t3x32(:,:,36))
  call prop_Q_A(ntry, wf32(:,75), 31, ZERO, 0_intkind1, wf32(:,76), n2(110))
  call vert_VQ_A(ntry, wf16(:,24), ex5(:), wf32(:,77), n3(:,170), t3x32(:,:,37))
  call prop_Q_A(ntry, wf32(:,77), 31, ZERO, 0_intkind1, wf32(:,78), n2(111))
  call vert_ZQ_A(gZu,ntry, wf16(:,101), ex5(:), wf32(:,79), n3(:,171), t3x32(:,:,38))
  call prop_Q_A(ntry, wf32(:,79), 31, ZERO, 0_intkind1, wf32(:,80), n2(112))
  call vert_AV_Q(ntry, ex6(:), wf16(:,22), wf32(:,81), n3(:,172), t3x32(:,:,39))
  call prop_A_Q(ntry, wf32(:,81), 47, ZERO, 0_intkind1, wf32(:,82), n2(113))
  call vert_AZ_Q(gZu,ntry, ex6(:), wf16(:,100), wf32(:,83), n3(:,173), t3x32(:,:,40))
  call prop_A_Q(ntry, wf32(:,83), 47, ZERO, 0_intkind1, wf32(:,84), n2(114))
  call vert_AV_Q(ntry, ex6(:), wf16(:,24), wf32(:,85), n3(:,174), t3x32(:,:,41))
  call prop_A_Q(ntry, wf32(:,85), 47, ZERO, 0_intkind1, wf32(:,86), n2(115))
  call vert_AZ_Q(gZu,ntry, ex6(:), wf16(:,101), wf32(:,87), n3(:,175), t3x32(:,:,42))
  call prop_A_Q(ntry, wf32(:,87), 47, ZERO, 0_intkind1, wf32(:,88), n2(116))
  call vert_VQ_A(ntry, wf16(:,26), ex5(:), wf32(:,89), n3(:,176), t3x32(:,:,43))
  call prop_Q_A(ntry, wf32(:,89), 31, ZERO, 0_intkind1, wf32(:,90), n2(117))
  call vert_VQ_A(ntry, wf16(:,27), ex5(:), wf32(:,91), n3(:,177), t3x32(:,:,44))
  call prop_Q_A(ntry, wf32(:,91), 31, ZERO, 0_intkind1, wf32(:,92), n2(118))
  call vert_ZQ_A(gZu,ntry, wf16(:,102), ex5(:), wf32(:,93), n3(:,178), t3x32(:,:,45))
  call prop_Q_A(ntry, wf32(:,93), 31, ZERO, 0_intkind1, wf32(:,94), n2(119))
  call vert_ZQ_A(gZu,ntry, wf16(:,103), ex5(:), wf32(:,95), n3(:,179), t3x32(:,:,46))
  call prop_Q_A(ntry, wf32(:,95), 31, ZERO, 0_intkind1, wf32(:,96), n2(120))
  call vert_AV_Q(ntry, ex6(:), wf16(:,26), wf32(:,97), n3(:,180), t3x32(:,:,47))
  call prop_A_Q(ntry, wf32(:,97), 47, ZERO, 0_intkind1, wf32(:,98), n2(121))
  call vert_AV_Q(ntry, ex6(:), wf16(:,27), wf32(:,99), n3(:,181), t3x32(:,:,48))
  call prop_A_Q(ntry, wf32(:,99), 47, ZERO, 0_intkind1, wf32(:,100), n2(122))
  call vert_AZ_Q(gZu,ntry, ex6(:), wf16(:,102), wf32(:,101), n3(:,182), t3x32(:,:,49))
  call prop_A_Q(ntry, wf32(:,101), 47, ZERO, 0_intkind1, wf32(:,102), n2(123))
  call vert_AZ_Q(gZu,ntry, ex6(:), wf16(:,103), wf32(:,103), n3(:,183), t3x32(:,:,50))
  call prop_A_Q(ntry, wf32(:,103), 47, ZERO, 0_intkind1, wf32(:,104), n2(124))


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  if (ntry < 2) then
    if(hel_mem_opt) hel_states = nhel
    call allocate_diagrams()
  end if

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    if (do_ct) call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  if (do_ct) M2ct = 0
  if (do_colint) M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    if (do_ct) call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      if (do_colint) call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    if (do_ct) M2ct = M2ct + M2add_ct
    if (do_colint) M2colint = M2colint + M2add_colint
  end do

#if -1 > 0 && 7 > 3
  if (loopcc) then
    !!Born-loop colour correlators interference
    
    M0M1_hel_cc(:,:,:)%j = 0
    M2ctcc = 0
    do n = 1, 14
      M2add_ct = 0
      m = ind_cc_comb(n)
        do k = 1, nhel
          call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
          call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
          M2ctcc(m) = M2ctcc(m) + M2add_ct
        end do
    end do
    M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
    M0M1_hel_cc(:,nhel+1:,:)%j = 0
  end if
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5,i6,i7
integer :: n

n=0

do i7= 1, 2
do i6= 1, 2
do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2) .OR. (ex7(i7)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf + ex7(i7)%hf
 end if
end do
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_QA(nsync, wf16(:,1), wf8(:,2), A(:,1), n3(:,184), t3x128(:,:,1), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,2), A(:,2), n3(:,185), t3x128(:,:,2), nhel, den(10))
    call Hcont_QA(nsync, wf16(:,1), wf8(:,4), A(:,3), n3(:,186), t3x128(:,:,3), nhel, den(13))
    call Hcont_QA(nsync, wf16(:,2), wf8(:,4), A(:,4), n3(:,187), t3x128(:,:,4), nhel, den(14))
    call Hcont_QA(nsync, wf16(:,3), wf8(:,6), A(:,5), n3(:,188), t3x128(:,:,5), nhel, den(18))
    call Hcont_QA(nsync, wf16(:,3), wf8(:,8), A(:,6), n3(:,189), t3x128(:,:,6), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,4), A(:,7), n3(:,190), t3x128(:,:,7), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,4), A(:,8), n3(:,191), t3x128(:,:,8), nhel, den(23))
    call Hcont_VV(nsync, wf16(:,5), wf8(:,10), A(:,9), n3(:,192), t3x128(:,:,9), nhel, den(28))
    call Hcont_QA(nsync, wf16(:,6), wf8(:,12), A(:,10), n3(:,193), t3x128(:,:,10), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,12), wf16(:,7), A(:,11), n3(:,194), t3x128(:,:,11), nhel, den(35))
    call Hcont_QA(nsync, wf16(:,6), wf8(:,14), A(:,12), n3(:,195), t3x128(:,:,12), nhel, den(37))
    call Hcont_QA(nsync, wf16(:,7), wf8(:,14), A(:,13), n3(:,196), t3x128(:,:,13), nhel, den(38))
    call Hcont_QA(nsync, wf16(:,8), wf8(:,16), A(:,14), n3(:,197), t3x128(:,:,14), nhel, den(42))
    call Hcont_QA(nsync, wf16(:,8), wf8(:,18), A(:,15), n3(:,198), t3x128(:,:,15), nhel, den(44))
    call Hcont_QA(nsync, wf8(:,16), wf16(:,9), A(:,16), n3(:,199), t3x128(:,:,16), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,9), A(:,17), n3(:,200), t3x128(:,:,17), nhel, den(47))
    call Hcont_VV(nsync, wf16(:,5), wf8(:,20), A(:,18), n3(:,201), t3x128(:,:,18), nhel, den(49))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,10), A(:,19), n3(:,202), t3x128(:,:,19), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,10), A(:,20), n3(:,203), t3x128(:,:,20), nhel, den(51))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,11), A(:,21), n3(:,204), t3x128(:,:,21), nhel, den(52))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,11), A(:,22), n3(:,205), t3x128(:,:,22), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,12), A(:,23), n3(:,206), t3x128(:,:,23), nhel, den(54))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,13), A(:,24), n3(:,207), t3x128(:,:,24), nhel, den(55))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,12), A(:,25), n3(:,208), t3x128(:,:,25), nhel, den(56))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,13), A(:,26), n3(:,209), t3x128(:,:,26), nhel, den(57))
    call Hcont_VV(nsync, wf8(:,22), wf16(:,14), A(:,27), n3(:,210), t3x128(:,:,27), nhel, den(62))
    call Hcont_VV(nsync, wf8(:,10), wf16(:,15), A(:,28), n3(:,211), t3x128(:,:,28), nhel, den(63))
    call Hcont_VV(nsync, wf8(:,22), wf16(:,16), A(:,29), n3(:,212), t3x128(:,:,29), nhel, den(65))
    call Hcont_VV(nsync, wf8(:,10), wf16(:,17), A(:,30), n3(:,213), t3x128(:,:,30), nhel, den(66))
    call Hcont_VV(nsync, wf8(:,22), wf16(:,18), A(:,31), n3(:,214), t3x128(:,:,31), nhel, den(69))
    call Hcont_VV(nsync, wf8(:,10), wf16(:,19), A(:,32), n3(:,215), t3x128(:,:,32), nhel, den(70))
    call Hcont_VV(nsync, wf8(:,22), wf16(:,20), A(:,33), n3(:,216), t3x128(:,:,33), nhel, den(72))
    call Hcont_VV(nsync, wf8(:,10), wf16(:,21), A(:,34), n3(:,217), t3x128(:,:,34), nhel, den(73))
    call Hcont_VV(nsync, wf16(:,14), wf8(:,30), A(:,35), n3(:,218), t3x128(:,:,35), nhel, den(75))
    call Hcont_VV(nsync, wf8(:,20), wf16(:,15), A(:,36), n3(:,219), t3x128(:,:,36), nhel, den(76))
    call Hcont_VV(nsync, wf16(:,16), wf8(:,30), A(:,37), n3(:,220), t3x128(:,:,37), nhel, den(77))
    call Hcont_VV(nsync, wf8(:,20), wf16(:,17), A(:,38), n3(:,221), t3x128(:,:,38), nhel, den(78))
    call Hcont_VV(nsync, wf16(:,18), wf8(:,30), A(:,39), n3(:,222), t3x128(:,:,39), nhel, den(79))
    call Hcont_VV(nsync, wf8(:,20), wf16(:,19), A(:,40), n3(:,223), t3x128(:,:,40), nhel, den(80))
    call Hcont_VV(nsync, wf16(:,20), wf8(:,30), A(:,41), n3(:,224), t3x128(:,:,41), nhel, den(81))
    call Hcont_VV(nsync, wf8(:,20), wf16(:,21), A(:,42), n3(:,225), t3x128(:,:,42), nhel, den(82))
    call Hcont_VV(nsync, wf8(:,22), wf16(:,22), A(:,43), n3(:,226), t3x128(:,:,43), nhel, den(85))
    call Hcont_VV(nsync, wf8(:,10), wf16(:,23), A(:,44), n3(:,227), t3x128(:,:,44), nhel, den(86))
    call Hcont_VV(nsync, wf8(:,22), wf16(:,24), A(:,45), n3(:,228), t3x128(:,:,45), nhel, den(88))
    call Hcont_VV(nsync, wf8(:,10), wf16(:,25), A(:,46), n3(:,229), t3x128(:,:,46), nhel, den(89))
    call Hcont_VV(nsync, wf8(:,22), wf16(:,26), A(:,47), n3(:,230), t3x128(:,:,47), nhel, den(92))
    call Hcont_VV(nsync, wf8(:,22), wf16(:,27), A(:,48), n3(:,231), t3x128(:,:,48), nhel, den(94))
    call Hcont_VV(nsync, wf8(:,10), wf16(:,28), A(:,49), n3(:,232), t3x128(:,:,49), nhel, den(95))
    call Hcont_VV(nsync, wf8(:,10), wf16(:,29), A(:,50), n3(:,233), t3x128(:,:,50), nhel, den(96))
    call Hcont_VV(nsync, wf8(:,30), wf16(:,22), A(:,51), n3(:,234), t3x128(:,:,51), nhel, den(97))
    call Hcont_VV(nsync, wf8(:,20), wf16(:,23), A(:,52), n3(:,235), t3x128(:,:,52), nhel, den(98))
    call Hcont_VV(nsync, wf8(:,30), wf16(:,24), A(:,53), n3(:,236), t3x128(:,:,53), nhel, den(99))
    call Hcont_VV(nsync, wf8(:,20), wf16(:,25), A(:,54), n3(:,237), t3x128(:,:,54), nhel, den(100))
    call Hcont_VV(nsync, wf8(:,30), wf16(:,26), A(:,55), n3(:,238), t3x128(:,:,55), nhel, den(101))
    call Hcont_VV(nsync, wf8(:,30), wf16(:,27), A(:,56), n3(:,239), t3x128(:,:,56), nhel, den(102))
    call Hcont_VV(nsync, wf8(:,20), wf16(:,28), A(:,57), n3(:,240), t3x128(:,:,57), nhel, den(103))
    call Hcont_VV(nsync, wf8(:,20), wf16(:,29), A(:,58), n3(:,241), t3x128(:,:,58), nhel, den(104))

    call Hcont_VV(nsync, wf4(:,12), wf32(:,1), A(:,59), n3(:,242), t3x128(:,:,59), nhel, den(107))
    call Hcont_VV(nsync, wf4(:,12), wf32(:,2), A(:,60), n3(:,243), t3x128(:,:,60), nhel, den(109))
    call Hcont_VV(nsync, wf4(:,12), wf32(:,3), A(:,61), n3(:,244), t3x128(:,:,61), nhel, den(111))
    call Hcont_VV(nsync, wf4(:,12), wf32(:,4), A(:,62), n3(:,245), t3x128(:,:,62), nhel, den(113))
    call Hcont_VV(nsync, wf8(:,39), wf16(:,30), A(:,63), n3(:,246), t3x128(:,:,63), nhel, den(116))
    call Hcont_SS(nsync, wf16(:,31), wf8(:,40), A(:,64), n3(:,247), t3x128(:,:,64), nhel, den(119))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,32), A(:,65), n3(:,248), t3x128(:,:,65), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,33), A(:,66), n3(:,249), t3x128(:,:,66), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,32), A(:,67), n3(:,250), t3x128(:,:,67), nhel, den(13))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,33), A(:,68), n3(:,251), t3x128(:,:,68), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,34), A(:,69), n3(:,252), t3x128(:,:,69), nhel, den(18))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,34), A(:,70), n3(:,253), t3x128(:,:,70), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,35), A(:,71), n3(:,254), t3x128(:,:,71), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,35), A(:,72), n3(:,255), t3x128(:,:,72), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,12), wf16(:,36), A(:,73), n3(:,256), t3x128(:,:,73), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,12), wf16(:,37), A(:,74), n3(:,257), t3x128(:,:,74), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,14), wf16(:,36), A(:,75), n3(:,258), t3x128(:,:,75), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,14), wf16(:,37), A(:,76), n3(:,259), t3x128(:,:,76), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,16), wf16(:,38), A(:,77), n3(:,260), t3x128(:,:,77), nhel, den(42))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,38), A(:,78), n3(:,261), t3x128(:,:,78), nhel, den(44))
    call Hcont_QA(nsync, wf8(:,16), wf16(:,39), A(:,79), n3(:,262), t3x128(:,:,79), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,39), A(:,80), n3(:,263), t3x128(:,:,80), nhel, den(47))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,40), A(:,81), n3(:,264), t3x128(:,:,81), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,40), A(:,82), n3(:,265), t3x128(:,:,82), nhel, den(51))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,41), A(:,83), n3(:,266), t3x128(:,:,83), nhel, den(52))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,41), A(:,84), n3(:,267), t3x128(:,:,84), nhel, den(53))
    call Hcont_VV(nsync, wf8(:,41), wf16(:,42), A(:,85), n3(:,268), t3x128(:,:,85), nhel, den(122))
    call Hcont_VV(nsync, wf8(:,41), wf16(:,43), A(:,86), n3(:,269), t3x128(:,:,86), nhel, den(123))
    call Hcont_VV(nsync, wf16(:,42), wf8(:,42), A(:,87), n3(:,270), t3x128(:,:,87), nhel, den(125))
    call Hcont_VV(nsync, wf16(:,43), wf8(:,42), A(:,88), n3(:,271), t3x128(:,:,88), nhel, den(126))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,44), A(:,89), n3(:,272), t3x128(:,:,89), nhel, den(54))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,45), A(:,90), n3(:,273), t3x128(:,:,90), nhel, den(55))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,44), A(:,91), n3(:,274), t3x128(:,:,91), nhel, den(56))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,45), A(:,92), n3(:,275), t3x128(:,:,92), nhel, den(57))
    call Hcont_VV(nsync, wf8(:,41), wf16(:,46), A(:,93), n3(:,276), t3x128(:,:,93), nhel, den(127))
    call Hcont_VV(nsync, wf8(:,41), wf16(:,47), A(:,94), n3(:,277), t3x128(:,:,94), nhel, den(128))
    call Hcont_VV(nsync, wf8(:,42), wf16(:,46), A(:,95), n3(:,278), t3x128(:,:,95), nhel, den(129))
    call Hcont_VV(nsync, wf8(:,42), wf16(:,47), A(:,96), n3(:,279), t3x128(:,:,96), nhel, den(130))
    call Hcont_VV(nsync, wf8(:,43), wf16(:,48), A(:,97), n3(:,280), t3x128(:,:,97), nhel, den(133))
    call Hcont_VV(nsync, wf8(:,43), wf16(:,49), A(:,98), n3(:,281), t3x128(:,:,98), nhel, den(134))
    call Hcont_VV(nsync, wf8(:,43), wf16(:,50), A(:,99), n3(:,282), t3x128(:,:,99), nhel, den(135))
    call Hcont_VV(nsync, wf8(:,43), wf16(:,51), A(:,100), n3(:,283), t3x128(:,:,100), nhel, den(136))
    call Hcont_VV(nsync, wf16(:,30), wf8(:,44), A(:,101), n3(:,284), t3x128(:,:,101), nhel, den(137))
    call Hcont_QA(nsync, wf8(:,45), wf16(:,52), A(:,102), n3(:,285), t3x128(:,:,102), nhel, den(140))
    call Hcont_QA(nsync, wf16(:,52), wf8(:,46), A(:,103), n3(:,286), t3x128(:,:,103), nhel, den(141))
    call Hcont_QA(nsync, wf8(:,45), wf16(:,53), A(:,104), n3(:,287), t3x128(:,:,104), nhel, den(143))
    call Hcont_QA(nsync, wf8(:,46), wf16(:,53), A(:,105), n3(:,288), t3x128(:,:,105), nhel, den(144))
    call Hcont_QA(nsync, wf8(:,47), wf16(:,54), A(:,106), n3(:,289), t3x128(:,:,106), nhel, den(147))
    call Hcont_QA(nsync, wf8(:,47), wf16(:,55), A(:,107), n3(:,290), t3x128(:,:,107), nhel, den(149))
    call Hcont_QA(nsync, wf16(:,54), wf8(:,48), A(:,108), n3(:,291), t3x128(:,:,108), nhel, den(150))
    call Hcont_QA(nsync, wf16(:,55), wf8(:,48), A(:,109), n3(:,292), t3x128(:,:,109), nhel, den(151))
    call Hcont_QA(nsync, wf16(:,10), wf8(:,49), A(:,110), n3(:,293), t3x128(:,:,110), nhel, den(50))
    call Hcont_QA(nsync, wf16(:,10), wf8(:,50), A(:,111), n3(:,294), t3x128(:,:,111), nhel, den(51))
    call Hcont_QA(nsync, wf16(:,11), wf8(:,49), A(:,112), n3(:,295), t3x128(:,:,112), nhel, den(52))
    call Hcont_QA(nsync, wf16(:,11), wf8(:,50), A(:,113), n3(:,296), t3x128(:,:,113), nhel, den(53))
    call Hcont_QA(nsync, wf16(:,12), wf8(:,51), A(:,114), n3(:,297), t3x128(:,:,114), nhel, den(54))
    call Hcont_QA(nsync, wf16(:,13), wf8(:,51), A(:,115), n3(:,298), t3x128(:,:,115), nhel, den(55))
    call Hcont_QA(nsync, wf16(:,12), wf8(:,52), A(:,116), n3(:,299), t3x128(:,:,116), nhel, den(56))
    call Hcont_QA(nsync, wf16(:,13), wf8(:,52), A(:,117), n3(:,300), t3x128(:,:,117), nhel, den(57))
    call Hcont_QA(nsync, wf8(:,12), wf16(:,56), A(:,118), n3(:,301), t3x128(:,:,118), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,12), wf16(:,57), A(:,119), n3(:,302), t3x128(:,:,119), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,14), wf16(:,56), A(:,120), n3(:,303), t3x128(:,:,120), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,14), wf16(:,57), A(:,121), n3(:,304), t3x128(:,:,121), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,16), wf16(:,58), A(:,122), n3(:,305), t3x128(:,:,122), nhel, den(42))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,58), A(:,123), n3(:,306), t3x128(:,:,123), nhel, den(44))
    call Hcont_QA(nsync, wf8(:,16), wf16(:,59), A(:,124), n3(:,307), t3x128(:,:,124), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,59), A(:,125), n3(:,308), t3x128(:,:,125), nhel, den(47))
    call Hcont_VV(nsync, wf16(:,5), wf8(:,54), A(:,126), n3(:,309), t3x128(:,:,126), nhel, den(49))
    call Hcont_VV(nsync, wf16(:,30), wf8(:,55), A(:,127), n3(:,310), t3x128(:,:,127), nhel, den(152))
    call Hcont_QA(nsync, wf8(:,56), wf16(:,60), A(:,128), n3(:,311), t3x128(:,:,128), nhel, den(155))
    call Hcont_QA(nsync, wf16(:,60), wf8(:,57), A(:,129), n3(:,312), t3x128(:,:,129), nhel, den(156))
    call Hcont_QA(nsync, wf8(:,56), wf16(:,61), A(:,130), n3(:,313), t3x128(:,:,130), nhel, den(158))
    call Hcont_QA(nsync, wf8(:,57), wf16(:,61), A(:,131), n3(:,314), t3x128(:,:,131), nhel, den(159))
    call Hcont_QA(nsync, wf8(:,58), wf16(:,62), A(:,132), n3(:,315), t3x128(:,:,132), nhel, den(162))
    call Hcont_QA(nsync, wf8(:,58), wf16(:,63), A(:,133), n3(:,316), t3x128(:,:,133), nhel, den(164))
    call Hcont_QA(nsync, wf16(:,62), wf8(:,59), A(:,134), n3(:,317), t3x128(:,:,134), nhel, den(165))
    call Hcont_QA(nsync, wf16(:,63), wf8(:,59), A(:,135), n3(:,318), t3x128(:,:,135), nhel, den(166))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,64), A(:,136), n3(:,319), t3x128(:,:,136), nhel, den(54))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,65), A(:,137), n3(:,320), t3x128(:,:,137), nhel, den(55))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,64), A(:,138), n3(:,321), t3x128(:,:,138), nhel, den(56))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,65), A(:,139), n3(:,322), t3x128(:,:,139), nhel, den(57))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,66), A(:,140), n3(:,323), t3x128(:,:,140), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,66), A(:,141), n3(:,324), t3x128(:,:,141), nhel, den(51))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,67), A(:,142), n3(:,325), t3x128(:,:,142), nhel, den(52))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,67), A(:,143), n3(:,326), t3x128(:,:,143), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,68), A(:,144), n3(:,327), t3x128(:,:,144), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,69), A(:,145), n3(:,328), t3x128(:,:,145), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,68), A(:,146), n3(:,329), t3x128(:,:,146), nhel, den(13))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,69), A(:,147), n3(:,330), t3x128(:,:,147), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,70), A(:,148), n3(:,331), t3x128(:,:,148), nhel, den(18))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,70), A(:,149), n3(:,332), t3x128(:,:,149), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,71), A(:,150), n3(:,333), t3x128(:,:,150), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,71), A(:,151), n3(:,334), t3x128(:,:,151), nhel, den(23))
    call Hcont_VV(nsync, wf16(:,5), wf8(:,65), A(:,152), n3(:,335), t3x128(:,:,152), nhel, den(28))
    call Hcont_SS(nsync, wf8(:,40), wf16(:,72), A(:,153), n3(:,336), t3x128(:,:,153), nhel, den(169))
    call Hcont_SS(nsync, wf8(:,40), wf16(:,73), A(:,154), n3(:,337), t3x128(:,:,154), nhel, den(170))
    call Hcont_VV(nsync, wf16(:,15), wf8(:,66), A(:,155), n3(:,338), t3x128(:,:,155), nhel, den(172))
    call Hcont_VV(nsync, wf16(:,17), wf8(:,66), A(:,156), n3(:,339), t3x128(:,:,156), nhel, den(173))
    call Hcont_SS(nsync, wf8(:,40), wf16(:,74), A(:,157), n3(:,340), t3x128(:,:,157), nhel, den(174))
    call Hcont_SS(nsync, wf8(:,40), wf16(:,75), A(:,158), n3(:,341), t3x128(:,:,158), nhel, den(175))
    call Hcont_VV(nsync, wf16(:,19), wf8(:,66), A(:,159), n3(:,342), t3x128(:,:,159), nhel, den(176))
    call Hcont_VV(nsync, wf16(:,21), wf8(:,66), A(:,160), n3(:,343), t3x128(:,:,160), nhel, den(177))
    call Hcont_VV(nsync, wf16(:,14), wf8(:,67), A(:,161), n3(:,344), t3x128(:,:,161), nhel, den(62))
    call Hcont_VV(nsync, wf16(:,15), wf8(:,68), A(:,162), n3(:,345), t3x128(:,:,162), nhel, den(63))
    call Hcont_VV(nsync, wf16(:,16), wf8(:,67), A(:,163), n3(:,346), t3x128(:,:,163), nhel, den(65))
    call Hcont_VV(nsync, wf16(:,17), wf8(:,68), A(:,164), n3(:,347), t3x128(:,:,164), nhel, den(66))
    call Hcont_VV(nsync, wf16(:,18), wf8(:,67), A(:,165), n3(:,348), t3x128(:,:,165), nhel, den(69))
    call Hcont_VV(nsync, wf16(:,19), wf8(:,68), A(:,166), n3(:,349), t3x128(:,:,166), nhel, den(70))
    call Hcont_VV(nsync, wf16(:,20), wf8(:,67), A(:,167), n3(:,350), t3x128(:,:,167), nhel, den(72))
    call Hcont_VV(nsync, wf16(:,21), wf8(:,68), A(:,168), n3(:,351), t3x128(:,:,168), nhel, den(73))
    call Hcont_VV(nsync, wf16(:,14), wf8(:,69), A(:,169), n3(:,352), t3x128(:,:,169), nhel, den(75))
    call Hcont_VV(nsync, wf16(:,15), wf8(:,54), A(:,170), n3(:,353), t3x128(:,:,170), nhel, den(76))
    call Hcont_VV(nsync, wf16(:,16), wf8(:,69), A(:,171), n3(:,354), t3x128(:,:,171), nhel, den(77))
    call Hcont_VV(nsync, wf16(:,17), wf8(:,54), A(:,172), n3(:,355), t3x128(:,:,172), nhel, den(78))
    call Hcont_VV(nsync, wf16(:,18), wf8(:,69), A(:,173), n3(:,356), t3x128(:,:,173), nhel, den(79))
    call Hcont_VV(nsync, wf16(:,19), wf8(:,54), A(:,174), n3(:,357), t3x128(:,:,174), nhel, den(80))
    call Hcont_VV(nsync, wf16(:,20), wf8(:,69), A(:,175), n3(:,358), t3x128(:,:,175), nhel, den(81))
    call Hcont_VV(nsync, wf16(:,21), wf8(:,54), A(:,176), n3(:,359), t3x128(:,:,176), nhel, den(82))
    call Hcont_VV(nsync, wf16(:,14), wf8(:,70), A(:,177), n3(:,360), t3x128(:,:,177), nhel, den(75))
    call Hcont_VV(nsync, wf16(:,15), wf8(:,71), A(:,178), n3(:,361), t3x128(:,:,178), nhel, den(76))
    call Hcont_VV(nsync, wf16(:,16), wf8(:,70), A(:,179), n3(:,362), t3x128(:,:,179), nhel, den(77))
    call Hcont_VV(nsync, wf16(:,17), wf8(:,71), A(:,180), n3(:,363), t3x128(:,:,180), nhel, den(78))
    call Hcont_VV(nsync, wf16(:,18), wf8(:,70), A(:,181), n3(:,364), t3x128(:,:,181), nhel, den(79))
    call Hcont_VV(nsync, wf16(:,19), wf8(:,71), A(:,182), n3(:,365), t3x128(:,:,182), nhel, den(80))
    call Hcont_VV(nsync, wf16(:,20), wf8(:,70), A(:,183), n3(:,366), t3x128(:,:,183), nhel, den(81))
    call Hcont_VV(nsync, wf16(:,21), wf8(:,71), A(:,184), n3(:,367), t3x128(:,:,184), nhel, den(82))
    call Hcont_VV(nsync, wf16(:,14), wf8(:,72), A(:,185), n3(:,368), t3x128(:,:,185), nhel, den(62))
    call Hcont_VV(nsync, wf16(:,15), wf8(:,65), A(:,186), n3(:,369), t3x128(:,:,186), nhel, den(63))
    call Hcont_VV(nsync, wf16(:,16), wf8(:,72), A(:,187), n3(:,370), t3x128(:,:,187), nhel, den(65))
    call Hcont_VV(nsync, wf16(:,17), wf8(:,65), A(:,188), n3(:,371), t3x128(:,:,188), nhel, den(66))
    call Hcont_VV(nsync, wf16(:,18), wf8(:,72), A(:,189), n3(:,372), t3x128(:,:,189), nhel, den(69))
    call Hcont_VV(nsync, wf16(:,19), wf8(:,65), A(:,190), n3(:,373), t3x128(:,:,190), nhel, den(70))
    call Hcont_VV(nsync, wf16(:,20), wf8(:,72), A(:,191), n3(:,374), t3x128(:,:,191), nhel, den(72))
    call Hcont_VV(nsync, wf16(:,21), wf8(:,65), A(:,192), n3(:,375), t3x128(:,:,192), nhel, den(73))
    call Hcont_VV(nsync, wf16(:,23), wf8(:,66), A(:,193), n3(:,376), t3x128(:,:,193), nhel, den(178))
    call Hcont_VV(nsync, wf16(:,25), wf8(:,66), A(:,194), n3(:,377), t3x128(:,:,194), nhel, den(179))
    call Hcont_VV(nsync, wf16(:,28), wf8(:,66), A(:,195), n3(:,378), t3x128(:,:,195), nhel, den(180))
    call Hcont_VV(nsync, wf16(:,29), wf8(:,66), A(:,196), n3(:,379), t3x128(:,:,196), nhel, den(181))
    call Hcont_VV(nsync, wf16(:,22), wf8(:,67), A(:,197), n3(:,380), t3x128(:,:,197), nhel, den(85))
    call Hcont_VV(nsync, wf16(:,23), wf8(:,68), A(:,198), n3(:,381), t3x128(:,:,198), nhel, den(86))
    call Hcont_VV(nsync, wf16(:,24), wf8(:,67), A(:,199), n3(:,382), t3x128(:,:,199), nhel, den(88))
    call Hcont_VV(nsync, wf16(:,25), wf8(:,68), A(:,200), n3(:,383), t3x128(:,:,200), nhel, den(89))
    call Hcont_VV(nsync, wf16(:,26), wf8(:,67), A(:,201), n3(:,384), t3x128(:,:,201), nhel, den(92))
    call Hcont_VV(nsync, wf16(:,27), wf8(:,67), A(:,202), n3(:,385), t3x128(:,:,202), nhel, den(94))
    call Hcont_VV(nsync, wf16(:,28), wf8(:,68), A(:,203), n3(:,386), t3x128(:,:,203), nhel, den(95))
    call Hcont_VV(nsync, wf16(:,29), wf8(:,68), A(:,204), n3(:,387), t3x128(:,:,204), nhel, den(96))
    call Hcont_VV(nsync, wf16(:,22), wf8(:,69), A(:,205), n3(:,388), t3x128(:,:,205), nhel, den(97))
    call Hcont_VV(nsync, wf16(:,23), wf8(:,54), A(:,206), n3(:,389), t3x128(:,:,206), nhel, den(98))
    call Hcont_VV(nsync, wf16(:,24), wf8(:,69), A(:,207), n3(:,390), t3x128(:,:,207), nhel, den(99))
    call Hcont_VV(nsync, wf16(:,25), wf8(:,54), A(:,208), n3(:,391), t3x128(:,:,208), nhel, den(100))
    call Hcont_VV(nsync, wf16(:,26), wf8(:,69), A(:,209), n3(:,392), t3x128(:,:,209), nhel, den(101))
    call Hcont_VV(nsync, wf16(:,27), wf8(:,69), A(:,210), n3(:,393), t3x128(:,:,210), nhel, den(102))
    call Hcont_VV(nsync, wf16(:,28), wf8(:,54), A(:,211), n3(:,394), t3x128(:,:,211), nhel, den(103))
    call Hcont_VV(nsync, wf16(:,29), wf8(:,54), A(:,212), n3(:,395), t3x128(:,:,212), nhel, den(104))
    call Hcont_VV(nsync, wf16(:,22), wf8(:,70), A(:,213), n3(:,396), t3x128(:,:,213), nhel, den(97))
    call Hcont_VV(nsync, wf16(:,23), wf8(:,71), A(:,214), n3(:,397), t3x128(:,:,214), nhel, den(98))
    call Hcont_VV(nsync, wf16(:,24), wf8(:,70), A(:,215), n3(:,398), t3x128(:,:,215), nhel, den(99))
    call Hcont_VV(nsync, wf16(:,25), wf8(:,71), A(:,216), n3(:,399), t3x128(:,:,216), nhel, den(100))
    call Hcont_VV(nsync, wf16(:,26), wf8(:,70), A(:,217), n3(:,400), t3x128(:,:,217), nhel, den(101))
    call Hcont_VV(nsync, wf16(:,27), wf8(:,70), A(:,218), n3(:,401), t3x128(:,:,218), nhel, den(102))
    call Hcont_VV(nsync, wf16(:,28), wf8(:,71), A(:,219), n3(:,402), t3x128(:,:,219), nhel, den(103))
    call Hcont_VV(nsync, wf16(:,29), wf8(:,71), A(:,220), n3(:,403), t3x128(:,:,220), nhel, den(104))
    call Hcont_VV(nsync, wf16(:,22), wf8(:,72), A(:,221), n3(:,404), t3x128(:,:,221), nhel, den(85))
    call Hcont_VV(nsync, wf16(:,23), wf8(:,65), A(:,222), n3(:,405), t3x128(:,:,222), nhel, den(86))
    call Hcont_VV(nsync, wf16(:,24), wf8(:,72), A(:,223), n3(:,406), t3x128(:,:,223), nhel, den(88))
    call Hcont_VV(nsync, wf16(:,25), wf8(:,65), A(:,224), n3(:,407), t3x128(:,:,224), nhel, den(89))
    call Hcont_VV(nsync, wf16(:,26), wf8(:,72), A(:,225), n3(:,408), t3x128(:,:,225), nhel, den(92))
    call Hcont_VV(nsync, wf16(:,27), wf8(:,72), A(:,226), n3(:,409), t3x128(:,:,226), nhel, den(94))
    call Hcont_VV(nsync, wf16(:,28), wf8(:,65), A(:,227), n3(:,410), t3x128(:,:,227), nhel, den(95))
    call Hcont_VV(nsync, wf16(:,29), wf8(:,65), A(:,228), n3(:,411), t3x128(:,:,228), nhel, den(96))
    call Hcont_VV(nsync, wf16(:,30), wf8(:,73), A(:,229), n3(:,412), t3x128(:,:,229), nhel, den(183))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,76), A(:,230), n3(:,413), t3x128(:,:,230), nhel, den(185))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,77), A(:,231), n3(:,414), t3x128(:,:,231), nhel, den(187))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,76), A(:,232), n3(:,415), t3x128(:,:,232), nhel, den(188))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,77), A(:,233), n3(:,416), t3x128(:,:,233), nhel, den(189))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,78), A(:,234), n3(:,417), t3x128(:,:,234), nhel, den(191))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,78), A(:,235), n3(:,418), t3x128(:,:,235), nhel, den(192))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,79), A(:,236), n3(:,419), t3x128(:,:,236), nhel, den(194))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,79), A(:,237), n3(:,420), t3x128(:,:,237), nhel, den(195))
    call Hcont_QA(nsync, wf16(:,54), wf8(:,74), A(:,238), n3(:,421), t3x128(:,:,238), nhel, den(196))
    call Hcont_QA(nsync, wf16(:,55), wf8(:,74), A(:,239), n3(:,422), t3x128(:,:,239), nhel, den(197))
    call Hcont_QA(nsync, wf16(:,54), wf8(:,75), A(:,240), n3(:,423), t3x128(:,:,240), nhel, den(198))
    call Hcont_QA(nsync, wf16(:,55), wf8(:,75), A(:,241), n3(:,424), t3x128(:,:,241), nhel, den(199))
    call Hcont_QA(nsync, wf16(:,52), wf8(:,76), A(:,242), n3(:,425), t3x128(:,:,242), nhel, den(200))
    call Hcont_QA(nsync, wf16(:,52), wf8(:,77), A(:,243), n3(:,426), t3x128(:,:,243), nhel, den(201))
    call Hcont_QA(nsync, wf16(:,53), wf8(:,76), A(:,244), n3(:,427), t3x128(:,:,244), nhel, den(202))
    call Hcont_QA(nsync, wf16(:,53), wf8(:,77), A(:,245), n3(:,428), t3x128(:,:,245), nhel, den(203))
    call Hcont_VV(nsync, wf16(:,30), wf8(:,78), A(:,246), n3(:,429), t3x128(:,:,246), nhel, den(205))
    call Hcont_QA(nsync, wf16(:,62), wf8(:,79), A(:,247), n3(:,430), t3x128(:,:,247), nhel, den(206))
    call Hcont_QA(nsync, wf16(:,63), wf8(:,79), A(:,248), n3(:,431), t3x128(:,:,248), nhel, den(207))
    call Hcont_QA(nsync, wf16(:,62), wf8(:,80), A(:,249), n3(:,432), t3x128(:,:,249), nhel, den(208))
    call Hcont_QA(nsync, wf16(:,63), wf8(:,80), A(:,250), n3(:,433), t3x128(:,:,250), nhel, den(209))
    call Hcont_QA(nsync, wf16(:,60), wf8(:,81), A(:,251), n3(:,434), t3x128(:,:,251), nhel, den(210))
    call Hcont_QA(nsync, wf16(:,60), wf8(:,82), A(:,252), n3(:,435), t3x128(:,:,252), nhel, den(211))
    call Hcont_QA(nsync, wf16(:,61), wf8(:,81), A(:,253), n3(:,436), t3x128(:,:,253), nhel, den(212))
    call Hcont_QA(nsync, wf16(:,61), wf8(:,82), A(:,254), n3(:,437), t3x128(:,:,254), nhel, den(213))
    call Hcont_QA(nsync, wf8(:,12), wf16(:,80), A(:,255), n3(:,438), t3x128(:,:,255), nhel, den(215))
    call Hcont_QA(nsync, wf8(:,12), wf16(:,81), A(:,256), n3(:,439), t3x128(:,:,256), nhel, den(217))
    call Hcont_QA(nsync, wf8(:,14), wf16(:,80), A(:,257), n3(:,440), t3x128(:,:,257), nhel, den(218))
    call Hcont_QA(nsync, wf8(:,14), wf16(:,81), A(:,258), n3(:,441), t3x128(:,:,258), nhel, den(219))
    call Hcont_QA(nsync, wf8(:,16), wf16(:,82), A(:,259), n3(:,442), t3x128(:,:,259), nhel, den(221))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,82), A(:,260), n3(:,443), t3x128(:,:,260), nhel, den(222))
    call Hcont_QA(nsync, wf8(:,16), wf16(:,83), A(:,261), n3(:,444), t3x128(:,:,261), nhel, den(224))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,83), A(:,262), n3(:,445), t3x128(:,:,262), nhel, den(225))
    call Hcont_QA(nsync, wf8(:,79), wf16(:,85), A(:,263), n3(:,446), t3x128(:,:,263), nhel, den(227))
    call Hcont_QA(nsync, wf8(:,79), wf16(:,87), A(:,264), n3(:,447), t3x128(:,:,264), nhel, den(229))
    call Hcont_QA(nsync, wf8(:,80), wf16(:,85), A(:,265), n3(:,448), t3x128(:,:,265), nhel, den(230))
    call Hcont_QA(nsync, wf8(:,80), wf16(:,87), A(:,266), n3(:,449), t3x128(:,:,266), nhel, den(231))
    call Hcont_QA(nsync, wf8(:,81), wf16(:,89), A(:,267), n3(:,450), t3x128(:,:,267), nhel, den(233))
    call Hcont_QA(nsync, wf8(:,82), wf16(:,89), A(:,268), n3(:,451), t3x128(:,:,268), nhel, den(234))
    call Hcont_QA(nsync, wf8(:,81), wf16(:,91), A(:,269), n3(:,452), t3x128(:,:,269), nhel, den(236))
    call Hcont_QA(nsync, wf8(:,82), wf16(:,91), A(:,270), n3(:,453), t3x128(:,:,270), nhel, den(237))
    call Hcont_QA(nsync, wf8(:,76), wf16(:,92), A(:,271), n3(:,454), t3x128(:,:,271), nhel, den(239))
    call Hcont_QA(nsync, wf8(:,77), wf16(:,92), A(:,272), n3(:,455), t3x128(:,:,272), nhel, den(240))
    call Hcont_QA(nsync, wf8(:,76), wf16(:,93), A(:,273), n3(:,456), t3x128(:,:,273), nhel, den(242))
    call Hcont_QA(nsync, wf8(:,77), wf16(:,93), A(:,274), n3(:,457), t3x128(:,:,274), nhel, den(243))
    call Hcont_QA(nsync, wf8(:,74), wf16(:,94), A(:,275), n3(:,458), t3x128(:,:,275), nhel, den(245))
    call Hcont_QA(nsync, wf8(:,74), wf16(:,95), A(:,276), n3(:,459), t3x128(:,:,276), nhel, den(247))
    call Hcont_QA(nsync, wf8(:,75), wf16(:,94), A(:,277), n3(:,460), t3x128(:,:,277), nhel, den(248))
    call Hcont_QA(nsync, wf8(:,75), wf16(:,95), A(:,278), n3(:,461), t3x128(:,:,278), nhel, den(249))
    call Hcont_VV(nsync, wf16(:,14), wf8(:,83), A(:,279), n3(:,462), t3x128(:,:,279), nhel, den(252))
    call Hcont_VV(nsync, wf8(:,73), wf16(:,96), A(:,280), n3(:,463), t3x128(:,:,280), nhel, den(254))
    call Hcont_VV(nsync, wf16(:,16), wf8(:,83), A(:,281), n3(:,464), t3x128(:,:,281), nhel, den(256))
    call Hcont_VV(nsync, wf8(:,73), wf16(:,97), A(:,282), n3(:,465), t3x128(:,:,282), nhel, den(258))
    call Hcont_VV(nsync, wf16(:,18), wf8(:,83), A(:,283), n3(:,466), t3x128(:,:,283), nhel, den(260))
    call Hcont_VV(nsync, wf8(:,73), wf16(:,98), A(:,284), n3(:,467), t3x128(:,:,284), nhel, den(262))
    call Hcont_VV(nsync, wf16(:,20), wf8(:,83), A(:,285), n3(:,468), t3x128(:,:,285), nhel, den(264))
    call Hcont_VV(nsync, wf8(:,73), wf16(:,99), A(:,286), n3(:,469), t3x128(:,:,286), nhel, den(266))
    call Hcont_VV(nsync, wf16(:,14), wf8(:,84), A(:,287), n3(:,470), t3x128(:,:,287), nhel, den(267))
    call Hcont_VV(nsync, wf8(:,78), wf16(:,96), A(:,288), n3(:,471), t3x128(:,:,288), nhel, den(268))
    call Hcont_VV(nsync, wf16(:,16), wf8(:,84), A(:,289), n3(:,472), t3x128(:,:,289), nhel, den(269))
    call Hcont_VV(nsync, wf8(:,78), wf16(:,97), A(:,290), n3(:,473), t3x128(:,:,290), nhel, den(270))
    call Hcont_VV(nsync, wf16(:,18), wf8(:,84), A(:,291), n3(:,474), t3x128(:,:,291), nhel, den(271))
    call Hcont_VV(nsync, wf8(:,78), wf16(:,98), A(:,292), n3(:,475), t3x128(:,:,292), nhel, den(272))
    call Hcont_VV(nsync, wf16(:,20), wf8(:,84), A(:,293), n3(:,476), t3x128(:,:,293), nhel, den(273))
    call Hcont_VV(nsync, wf8(:,78), wf16(:,99), A(:,294), n3(:,477), t3x128(:,:,294), nhel, den(274))
    call Hcont_VV(nsync, wf16(:,22), wf8(:,83), A(:,295), n3(:,478), t3x128(:,:,295), nhel, den(276))
    call Hcont_VV(nsync, wf8(:,73), wf16(:,100), A(:,296), n3(:,479), t3x128(:,:,296), nhel, den(278))
    call Hcont_VV(nsync, wf16(:,24), wf8(:,83), A(:,297), n3(:,480), t3x128(:,:,297), nhel, den(280))
    call Hcont_VV(nsync, wf8(:,73), wf16(:,101), A(:,298), n3(:,481), t3x128(:,:,298), nhel, den(282))
    call Hcont_VV(nsync, wf16(:,26), wf8(:,83), A(:,299), n3(:,482), t3x128(:,:,299), nhel, den(284))
    call Hcont_VV(nsync, wf16(:,27), wf8(:,83), A(:,300), n3(:,483), t3x128(:,:,300), nhel, den(286))
    call Hcont_VV(nsync, wf8(:,73), wf16(:,102), A(:,301), n3(:,484), t3x128(:,:,301), nhel, den(288))
    call Hcont_VV(nsync, wf8(:,73), wf16(:,103), A(:,302), n3(:,485), t3x128(:,:,302), nhel, den(290))
    call Hcont_VV(nsync, wf16(:,22), wf8(:,84), A(:,303), n3(:,486), t3x128(:,:,303), nhel, den(291))
    call Hcont_VV(nsync, wf8(:,78), wf16(:,100), A(:,304), n3(:,487), t3x128(:,:,304), nhel, den(292))
    call Hcont_VV(nsync, wf16(:,24), wf8(:,84), A(:,305), n3(:,488), t3x128(:,:,305), nhel, den(293))
    call Hcont_VV(nsync, wf8(:,78), wf16(:,101), A(:,306), n3(:,489), t3x128(:,:,306), nhel, den(294))
    call Hcont_VV(nsync, wf16(:,26), wf8(:,84), A(:,307), n3(:,490), t3x128(:,:,307), nhel, den(295))
    call Hcont_VV(nsync, wf16(:,27), wf8(:,84), A(:,308), n3(:,491), t3x128(:,:,308), nhel, den(296))
    call Hcont_VV(nsync, wf8(:,78), wf16(:,102), A(:,309), n3(:,492), t3x128(:,:,309), nhel, den(297))
    call Hcont_VV(nsync, wf8(:,78), wf16(:,103), A(:,310), n3(:,493), t3x128(:,:,310), nhel, den(298))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(1), M2(1) ! M1helarray(1,nhel)
  integer :: empty(0), i

  M1(1)%j = (A(j,1)%j+A(j,5)%j+A(j,10)%j+A(j,14)%j+A(j,19)%j+A(j,23)%j)*f(1)+(-A(j,2)%j-A(j,3)%j-A(j,6)%j-A(j,7)%j-A(j,11)%j &
       -A(j,12)%j-A(j,15)%j-A(j,16)%j-A(j,20)%j-A(j,21)%j-A(j,24)%j-A(j,25)%j-A(j,27)%j-A(j,29)%j-A(j,31)%j-A(j,33)%j-A(j,35)%j &
       -A(j,37)%j-A(j,39)%j-A(j,41)%j-A(j,43)%j-A(j,45)%j-A(j,47)%j-A(j,48)%j-A(j,51)%j-A(j,53)%j-A(j,55)%j-A(j,56)%j)*f(2) &
       +(A(j,4)%j+A(j,8)%j+A(j,13)%j+A(j,17)%j+A(j,22)%j+A(j,26)%j+A(j,28)%j+A(j,30)%j+A(j,32)%j+A(j,34)%j+A(j,36)%j+A(j,38)%j &
       +A(j,40)%j+A(j,42)%j+A(j,44)%j+A(j,46)%j+A(j,49)%j+A(j,50)%j+A(j,52)%j+A(j,54)%j+A(j,57)%j+A(j,58)%j)*f(3)+(-A(j,9)%j &
       -A(j,18)%j)*f(18)

  M2(1)%j = (-A(j,230)%j-A(j,234)%j-A(j,238)%j-A(j,242)%j-A(j,247)%j-A(j,251)%j-A(j,255)%j-A(j,259)%j-A(j,263)%j-A(j,267)%j &
       -A(j,271)%j-A(j,275)%j)*f(4)+(A(j,231)%j+A(j,232)%j+A(j,235)%j+A(j,236)%j+A(j,239)%j+A(j,240)%j+A(j,243)%j+A(j,244)%j &
       +A(j,248)%j+A(j,249)%j+A(j,252)%j+A(j,253)%j+A(j,256)%j+A(j,257)%j+A(j,260)%j+A(j,261)%j+A(j,264)%j+A(j,265)%j+A(j,268)%j &
       +A(j,269)%j+A(j,272)%j+A(j,273)%j+A(j,276)%j+A(j,277)%j+A(j,279)%j+A(j,281)%j+A(j,283)%j+A(j,285)%j+A(j,287)%j+A(j,289)%j &
       +A(j,291)%j+A(j,293)%j+A(j,295)%j+A(j,297)%j+A(j,299)%j+A(j,300)%j+A(j,303)%j+A(j,305)%j+A(j,307)%j+A(j,308)%j)*f(5)+( &
       -A(j,233)%j-A(j,237)%j-A(j,241)%j-A(j,245)%j-A(j,250)%j-A(j,254)%j-A(j,258)%j-A(j,262)%j-A(j,266)%j-A(j,270)%j-A(j,274)%j &
       -A(j,278)%j-A(j,280)%j-A(j,282)%j-A(j,284)%j-A(j,286)%j-A(j,288)%j-A(j,290)%j-A(j,292)%j-A(j,294)%j-A(j,296)%j-A(j,298)%j &
       -A(j,301)%j-A(j,302)%j-A(j,304)%j-A(j,306)%j-A(j,309)%j-A(j,310)%j)*f(6)+A(j,59)%j*f(7)+(A(j,60)%j+A(j,61)%j)*f(8) &
       +(A(j,81)%j+A(j,89)%j+A(j,118)%j+A(j,122)%j+A(j,144)%j+A(j,148)%j)*f(9)+(-A(j,82)%j-A(j,83)%j-A(j,90)%j-A(j,91)%j &
       -A(j,119)%j-A(j,120)%j-A(j,123)%j-A(j,124)%j-A(j,145)%j-A(j,146)%j-A(j,149)%j-A(j,150)%j-A(j,169)%j-A(j,171)%j-A(j,173)%j &
       -A(j,175)%j-A(j,185)%j-A(j,187)%j-A(j,189)%j-A(j,191)%j-A(j,205)%j-A(j,207)%j-A(j,209)%j-A(j,210)%j-A(j,221)%j-A(j,223)%j &
       -A(j,225)%j-A(j,226)%j)*f(10)+(A(j,84)%j+A(j,92)%j+A(j,121)%j+A(j,125)%j+A(j,147)%j+A(j,151)%j+A(j,170)%j+A(j,172)%j &
       +A(j,174)%j+A(j,176)%j+A(j,186)%j+A(j,188)%j+A(j,190)%j+A(j,192)%j+A(j,206)%j+A(j,208)%j+A(j,211)%j+A(j,212)%j+A(j,222)%j &
       +A(j,224)%j+A(j,227)%j+A(j,228)%j)*f(11)+(A(j,65)%j+A(j,69)%j+A(j,73)%j+A(j,77)%j+A(j,102)%j+A(j,106)%j+A(j,110)%j &
       +A(j,114)%j+A(j,128)%j+A(j,132)%j+A(j,136)%j+A(j,140)%j)*f(12)+(-A(j,66)%j-A(j,67)%j-A(j,70)%j-A(j,71)%j-A(j,74)%j &
       -A(j,75)%j-A(j,78)%j-A(j,79)%j-A(j,103)%j-A(j,104)%j-A(j,107)%j-A(j,108)%j-A(j,111)%j-A(j,112)%j-A(j,115)%j-A(j,116)%j &
       -A(j,129)%j-A(j,130)%j-A(j,133)%j-A(j,134)%j-A(j,137)%j-A(j,138)%j-A(j,141)%j-A(j,142)%j-A(j,161)%j-A(j,163)%j-A(j,165)%j &
       -A(j,167)%j-A(j,177)%j-A(j,179)%j-A(j,181)%j-A(j,183)%j-A(j,197)%j-A(j,199)%j-A(j,201)%j-A(j,202)%j-A(j,213)%j-A(j,215)%j &
       -A(j,217)%j-A(j,218)%j)*f(13)+(A(j,68)%j+A(j,72)%j+A(j,76)%j+A(j,80)%j+A(j,105)%j+A(j,109)%j+A(j,113)%j+A(j,117)%j &
       +A(j,131)%j+A(j,135)%j+A(j,139)%j+A(j,143)%j+A(j,162)%j+A(j,164)%j+A(j,166)%j+A(j,168)%j+A(j,178)%j+A(j,180)%j+A(j,182)%j &
       +A(j,184)%j+A(j,198)%j+A(j,200)%j+A(j,203)%j+A(j,204)%j+A(j,214)%j+A(j,216)%j+A(j,219)%j+A(j,220)%j)*f(14)+(A(j,87)%j &
       +A(j,95)%j+A(j,97)%j+A(j,99)%j)*f(15)+(-A(j,88)%j-A(j,96)%j-A(j,98)%j-A(j,100)%j-A(j,155)%j-A(j,156)%j-A(j,159)%j &
       -A(j,160)%j-A(j,193)%j-A(j,194)%j-A(j,195)%j-A(j,196)%j)*f(16)+A(j,62)%j*f(17)+(A(j,229)%j+A(j,246)%j)*f(19)+(-A(j,126)%j &
       -A(j,152)%j)*f(20)+(-A(j,101)%j-A(j,127)%j)*f(21)+A(j,63)%j*f(22)+(A(j,85)%j+A(j,93)%j)*f(23)+(-A(j,86)%j-A(j,94)%j &
       -A(j,153)%j-A(j,154)%j-A(j,157)%j-A(j,158)%j)*f(24)-A(j,64)%j*f(25)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppllllj_eexmmxuuxg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 1
      do j = 1, 1
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppllllj_eexmmxuuxg_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mct(1)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 1
    do j = 1, 1
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+1*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppllllj_eexmmxuuxg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2IRadd(29)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 30-1
    colmatpos = 1*k
    do i = 1, 1
      do j = 1, 1
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppllllj_eexmmxuuxg_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppllllj_eexmmxuuxg_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(1)
  type(Hpolcont), intent(out)  :: M0_col(1)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 1 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 1 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+1*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppllllj_eexmmxuuxg_1_/**/REALKIND
