
module ol_vamp_1_ppllllj_nenmxexmddxg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllllj_nenmxexmddxg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllllj_nenmxexmddxg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppllllj_nenmxexmddxg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppllllj_nenmxexmddxg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppllllj_nenmxexmddxg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppllllj_nenmxexmddxg_1_/**/DREALKIND, only: ntryL, p_switch, Hel
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(128)
  type(Hpolcont), intent(in) :: M(1,128)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1),h0tab(:,1),[64,5,10,32,16],[0,0,0,0,0],5,2,wf4(:,5),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1),heltab2x128(:,:,1))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(1),n2h64(1))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(2),h0tab(:,2),[64,10,5,16,32],[0,0,0,0,0],5,2,wf4(:,4),wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,2),heltab2x128(:,:,2))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(2),n2h64(2))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(3),h0tab(:,3),[64,5,16,32,10],[0,0,0,0,0],5,2,wf4(:,5),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,3),heltab2x128(:,:,3))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(3),n2h64(3))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(4),h0tab(:,4),[64,16,5,10,32],[0,0,0,0,0],5,2,wf4(:,5),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(4),m3h2x64(:,4),heltab2x128(:,:,4))
  call Hloop_QW_A(ntryL,G1H64(1),wf4(:,5),G1H16(1),m3h4x16(:,1),heltab2x64(:,:,1))
  call Hloop_Q_A(ntryL,G1H16(1),69,0,G2H16(1),n2h16(1))
  call Hloop_AW_Q(ntryL,G1H64(2),wf4(:,4),G1H16(1),m3h4x16(:,2),heltab2x64(:,:,2))
  call Hloop_A_Q(ntryL,G1H16(1),74,0,G2H16(2),n2h16(2))
  call Hloop_AW_Q(ntryL,G1H64(3),wf4(:,5),G1H16(1),m3h4x16(:,3),heltab2x64(:,:,3))
  call Hloop_A_Q(ntryL,G1H16(1),69,0,G2H16(3),n2h16(3))
  call Hloop_VQ_A(ntryL,G1H64(4),ex5(:),G1H32(1),m3h2x32(:,1),heltab2x64(:,:,4))
  call Hloop_Q_A(ntryL,G1H32(1),80,0,G2H32(1),n2h32(1))
call Hotf_5pt_reduction(G2H16(1),RedSet_5(1),mass5set(:,1),  & 
G1H16(1),G1H16(2),G1H16(3),G1H16(4),G1H16(5),G1H16(6),16)
call HG1shiftOLR(G1H16(2),16,16)
call Hotf_5pt_reduction(G2H16(2),RedSet_5(2),mass5set(:,1),  & 
G1H16(7),G1H16(8),G1H16(9),G1H16(10),G1H16(11),G1H16(12),16)
call HG1shiftOLR(G1H16(8),32,16)
  call Hloop_AQ_V(ntryL,G2H16(3),ex5(:),G2H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
call Hotf_5pt_reduction(G2H32(1),RedSet_5(3),mass5set(:,1),  & 
G1H32(1),G1H32(2),G1H32(3),G1H32(4),G1H32(5),G1H32(6),32)
call HG1shiftOLR(G1H32(2),32,32)
  call Hloop_QW_A(ntryL,G1H16(1),wf4(:,4),G1H4(1),m3h4x4(:,1),heltab2x16(:,:,2))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(1),n2h4(1))
call HGT_OLR(G1H16(2),1,1,16)
call HGT_invQ_OLR(G1H16(2),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(2),-16,0,G2H16(1),n2h16(4))
  call Hloop_AQ_V(ntryL,G2H16(1),ex5(:),G2H8(2),m3h2x8(:,2),heltab2x16(:,:,3))
  call Hloop_QW_A(ntryL,G1H16(4),wf4(:,4),G1H4(1),m3h4x4(:,2),heltab2x16(:,:,4))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(2),n2h4(2))
  call Hloop_QW_A(ntryL,G1H16(5),wf4(:,4),G1H4(1),m3h4x4(:,3),heltab2x16(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(3),n2h4(3))
  call Hloop_QW_A(ntryL,G1H16(6),wf4(:,4),G1H4(1),m3h4x4(:,4),heltab2x16(:,:,6))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(4),n2h4(4))
  call Hloop_AW_Q(ntryL,G1H16(7),wf4(:,5),G1H4(1),m3h4x4(:,5),heltab2x16(:,:,7))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(5),n2h4(5))
call HGT_OLR(G1H16(8),1,1,16)
call HGT_invQ_OLR(G1H16(8),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(8),-32,0,G2H16(2),n2h16(5))
  call Hloop_QA_V(ntryL,G2H16(2),ex6(:),G2H8(3),m3h2x8(:,3),heltab2x16(:,:,8))
  call Hloop_AW_Q(ntryL,G1H16(10),wf4(:,5),G1H4(1),m3h4x4(:,6),heltab2x16(:,:,9))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(6),n2h4(6))
  call Hloop_AW_Q(ntryL,G1H16(11),wf4(:,5),G1H4(1),m3h4x4(:,7),heltab2x16(:,:,10))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(7),n2h4(7))
  call Hloop_AW_Q(ntryL,G1H16(12),wf4(:,5),G1H4(1),m3h4x4(:,8),heltab2x16(:,:,11))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(8),n2h4(8))
  call Hloop_QW_A(ntryL,G1H32(1),wf4(:,5),G1H8(1),m3h4x8(:,1),heltab2x32(:,:,1))
  call Hloop_Q_A(ntryL,G1H8(1),85,0,G2H8(4),n2h8(1))
call HGT_raise_alpha_OLR(G1H32(2),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(2),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(2),ex6(:),G1H16(1),m3h2x16(:,1),heltab2x32(:,:,2))
  call Hloop_QW_A(ntryL,G1H32(4),wf4(:,5),G1H8(1),m3h4x8(:,2),heltab2x32(:,:,3))
  call Hloop_Q_A(ntryL,G1H8(1),85,0,G2H8(5),n2h8(2))
  call Hloop_QW_A(ntryL,G1H32(5),wf4(:,5),G1H8(1),m3h4x8(:,3),heltab2x32(:,:,4))
  call Hloop_Q_A(ntryL,G1H8(1),85,0,G2H8(6),n2h8(3))
  call Hloop_QW_A(ntryL,G1H32(6),wf4(:,5),G1H8(1),m3h4x8(:,4),heltab2x32(:,:,5))
  call Hloop_Q_A(ntryL,G1H8(1),85,0,G2H8(7),n2h8(4))
call Hotf_5pt_reduction(G2H8(1),RedSet_5(4),mass5set(:,1),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),G1H8(6),8)
call HG1shiftOLR(G1H8(2),10,8)
  call Hloop_QA_V(ntryL,G2H4(1),ex6(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_V(ntryL,G2H4(3),ex6(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_V(ntryL,G2H4(4),ex6(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_AQ_V(ntryL,G2H4(5),ex5(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_AQ_V(ntryL,G2H4(7),ex5(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_V(ntryL,G2H4(8),ex5(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
call Hotf_5pt_reduction(G2H8(4),RedSet_5(3),mass5set(:,1),  & 
G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),G1H8(12),8)
call HG1shiftOLR(G1H8(8),32,8)
call Hotf_4pt_reduction(G2H8(6),RedSet_4(1),mass4set(:,1),  & 
G1H8(13),G1H8(14),G1H8(15),G1H8(16),G1H8(17),8)
call HG1shiftOLR(G1H8(14),32,8)
call Hotf_4pt_reduction(G2H8(7),RedSet_4(2),mass4set(:,1),  & 
G1H8(18),G1H8(19),G1H8(20),G1H8(21),G1H8(22),8)
call HG1shiftOLR(G1H8(19),42,8)
  call ol_merge(ntryL,G1H8(13),[G1H8(11)])
  call ol_merge(ntryL,G1H8(18),[G1H8(12)])
  call Hloop_VA_Q(ntryL,G1H8(1),ex6(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_A_Q(ntryL,G1H4(1),117,0,G2H4(1),n2h4(9))
call HGT_OLR(G1H8(2),1,1,8)
call HGT_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(2),-10,0,G2H8(1),n2h8(5))
  call Hloop_QW_A(ntryL,G2H8(1),wf4(:,4),G2H2(7),m3h4x2(:,1),heltab2x8(:,:,2))
  call Hloop_VA_Q(ntryL,G1H8(5),ex6(:),G1H4(1),m3h2x4(:,2),heltab2x8(:,:,3))
  call Hloop_A_Q(ntryL,G1H4(1),117,0,G2H4(3),n2h4(10))
  call Hloop_VA_Q(ntryL,G1H8(6),ex6(:),G1H4(1),m3h2x4(:,3),heltab2x8(:,:,4))
  call Hloop_A_Q(ntryL,G1H4(1),117,0,G2H4(4),n2h4(11))
  call Hloop_QW_A(ntryL,G1H8(7),wf4(:,4),G1H2(1),m3h4x2(:,2),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(8),n2h2(1))
call HGT_raise_alpha_OLR(G1H8(8),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(8),ex6(:),G1H4(1),m3h2x4(:,4),heltab2x8(:,:,6))
  call Hloop_QW_A(ntryL,G1H8(13),wf4(:,4),G1H2(1),m3h4x2(:,3),heltab2x8(:,:,7))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(9),n2h2(2))
  call Hloop_QW_A(ntryL,G1H8(18),wf4(:,4),G1H2(1),m3h4x2(:,4),heltab2x8(:,:,8))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(10),n2h2(3))
call HGT_raise_alpha_OLR(G1H8(14),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(14),ex6(:),G1H4(2),m3h2x4(:,5),heltab2x8(:,:,9))
  call Hloop_QW_A(ntryL,G1H8(17),wf4(:,4),G1H2(1),m3h4x2(:,5),heltab2x8(:,:,10))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(11),n2h2(4))
call HGT_raise_alpha_OLR(G1H8(19),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(19),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(19),ex6(:),G1H4(3),m3h2x4(:,6),heltab2x8(:,:,11))
  call Hloop_QW_A(ntryL,G1H8(22),wf4(:,4),G1H2(1),m3h4x2(:,6),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(12),n2h2(5))
call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
call HG1shiftOLR(G1H2(2),16,2)
call Hotf_4pt_reduction(G2H2(3),RedSet_4(3),mass4set(:,1),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),2)
call HG1shiftOLR(G1H2(8),48,2)
call Hotf_5pt_reduction(G2H2(4),RedSet_5(2),mass5set(:,1),  & 
G1H2(12),G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),2)
call HG1shiftOLR(G1H2(13),32,2)
call Hotf_4pt_reduction(G2H2(6),RedSet_4(4),mass4set(:,1),  & 
G1H2(18),G1H2(19),G1H2(20),G1H2(21),G1H2(22),2)
call HG1shiftOLR(G1H2(19),48,2)
call Hotf_5pt_reduction(G2H4(1),RedSet_5(4),mass5set(:,1),  & 
G1H4(4),G1H4(5),G1H4(6),G1H4(7),G1H4(8),G1H4(9),4)
call HG1shiftOLR(G1H4(5),10,4)
call Hotf_4pt_reduction(G2H4(4),RedSet_4(5),mass4set(:,1),  & 
G1H4(10),G1H4(11),G1H4(12),G1H4(13),G1H4(14),4)
call HG1shiftOLR(G1H4(11),42,4)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(8),ex6(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(10),ex6(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call ol_merge(ntryL,G1H2(7),[G1H2(6)])
  call ol_merge(ntryL,G1H2(18),[G1H2(17)])
  call ol_merge(ntryL,G1H4(10),[G1H4(9)])
  call Hloop_VQ_A(ntryL,G1H2(1),ex5(:),G1H1(1),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(3),n2h1(1))
  call Hloop_VQ_A(ntryL,G1H2(2),ex5(:),G1H1(1),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(4),n2h1(2))
  call Hloop_VQ_A(ntryL,G1H2(7),ex5(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(5),n2h1(3))
  call Hloop_VQ_A(ntryL,G1H2(8),ex5(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,0,G2tensor(6),n2h1(4))
  call Hloop_VA_Q(ntryL,G1H2(12),ex6(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(7),n2h1(5))
  call Hloop_VA_Q(ntryL,G1H2(13),ex6(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(8),n2h1(6))
  call Hloop_VA_Q(ntryL,G1H2(18),ex6(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(9),n2h1(7))
  call Hloop_VA_Q(ntryL,G1H2(19),ex6(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,0,G2tensor(10),n2h1(8))
  call Hloop_AW_Q(ntryL,G1H4(4),wf4(:,4),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(11),n2h1(9))
  call Hloop_AW_Q(ntryL,G1H4(5),wf4(:,4),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(12),n2h1(10))
  call Hloop_AW_Q(ntryL,G1H4(10),wf4(:,4),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(13),n2h1(11))
  call Hloop_AW_Q(ntryL,G1H4(11),wf4(:,4),G1H1(1),m3h4x1(:,4),heltab2x4(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),42,0,G2tensor(14),n2h1(12))
call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(3),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
call G_TensorShift(G1tensor(2),32)
call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(1),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
call G_TensorShift(G1tensor(8),16)
call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(2),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
call G_TensorShift(G1tensor(14),32)
call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(4),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
call G_TensorShift(G1tensor(20),10)
call ol_merge_tensors(T1sum(1),[G1tensor(1)])
call ol_merge_tensors(T1sum(2),[G1tensor(7)])
call ol_merge_tensors(T1sum(3),[G1tensor(13)])
call ol_merge_tensors(T1sum(4),[G1tensor(19)])
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(131)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(5),h0tab(:,5),[64,5,48,10],[0,0,0,0],4,3,wf4(:,5),wf4(:,9),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,5),heltab2x128(:,:,5))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(1),n2h64(4))
Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(131)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(6),h0tab(:,6),[64,5,48,10],[nMT,nMB,nMB,nMT],4,3,wf4(:,5),wf4(:,9),wf4(: &
    ,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,6),heltab2x128(:,:,6))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(2),n2h64(5))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(131)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(7),h0tab(:,7),[64,5,48,10],[0,0,0,0],4,3,wf4(:,5),wf4(:,9),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,7),heltab2x128(:,:,7))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(3),n2h64(6))
Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(131)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(8),h0tab(:,8),[64,5,48,10],[nMB,nMT,nMT,nMB],4,3,wf4(:,5),wf4(:,9),wf4(: &
    ,4))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,8),heltab2x128(:,:,8))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(4),n2h64(7))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(131)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(9),h0tab(:,9),[64,5,10,48],[0,0,0,0],4,3,wf4(:,5),wf4(:,4),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,9),heltab2x128(:,:,9))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(5),n2h64(8))
Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(131)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(10),h0tab(:,10),[64,5,10,48],[nMT,nMB,nMT,nMT],4,3,wf4(:,5),wf4(:,4),wf4(: &
    ,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,10),heltab2x128(:,:,10))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(6),n2h64(9))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(131)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(11),h0tab(:,11),[64,5,10,48],[0,0,0,0],4,3,wf4(:,5),wf4(:,4),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,11),heltab2x128(:,:,11))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(7),n2h64(10))
Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(131)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(12),h0tab(:,12),[64,5,10,48],[nMB,nMT,nMB,nMB],4,3,wf4(:,5),wf4(:,4),wf4(: &
    ,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,12),heltab2x128(:,:,12))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(8),n2h64(11))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(131)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(13),h0tab(:,13),[64,10,5,48],[0,0,0,0],4,3,wf4(:,4),wf4(:,5),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,13),heltab2x128(:,:,13))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(9),n2h64(12))
Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(131)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(14),h0tab(:,14),[64,10,5,48],[nMT,nMB,nMT,nMT],4,3,wf4(:,4),wf4(:,5),wf4(: &
    ,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,14),heltab2x128(:,:,14))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(10),n2h64(13))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(131)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(15),h0tab(:,15),[64,10,5,48],[0,0,0,0],4,3,wf4(:,4),wf4(:,5),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,15),heltab2x128(:,:,15))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(11),n2h64(14))
Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(131)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(16),h0tab(:,16),[64,10,5,48],[nMB,nMT,nMB,nMB],4,3,wf4(:,4),wf4(:,5),wf4(: &
    ,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,16),heltab2x128(:,:,16))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(12),n2h64(15))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(133)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(17),h0tab(:,17),[80,5,10,32],[0,0,0,0],4,3,wf4(:,6),wf4(:,5),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,6),G0H32(1),m3h4x32(:,1),heltab2x128(:,:,17))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(1),n2h32(3))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(135)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(18),h0tab(:,18),[96,10,5,16],[0,0,0,0],4,3,wf4(:,8),wf4(:,4),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(1),m3h4x32(:,2),heltab2x128(:,:,18))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(2),n2h32(4))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(107)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(19),h0tab(:,19),[64,21,10,32],[0,0,0,0],4,2,wf8(:,7),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(13),m3h2x64(:,17),heltab2x128(:,:,19))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(107)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(20),h0tab(:,20),[64,10,21,32],[0,0,0,0],4,2,wf4(:,4),wf8(:,7))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,18),heltab2x128(:,:,20))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(14),n2h64(16))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(107)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(21),h0tab(:,21),[64,10,32,21],[0,0,0,0],4,2,wf4(:,4),wf8(:,7))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,19),heltab2x128(:,:,21))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(15),n2h64(17))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(110)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(22),h0tab(:,22),[64,16,5,42],[0,0,0,0],4,2,wf4(:,5),wf8(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(16),m3h2x64(:,20),heltab2x128(:,:,22))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(110)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(23),h0tab(:,23),[64,5,42,16],[0,0,0,0],4,2,wf4(:,5),wf8(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,21),heltab2x128(:,:,23))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(17),n2h64(18))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(110)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(24),h0tab(:,24),[64,5,16,42],[0,0,0,0],4,2,wf4(:,5),wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,22),heltab2x128(:,:,24))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(18),n2h64(19))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(54)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(25),h0tab(:,25),[64,15,32,16],[0,0,0,0],4,1,wf16(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,23),heltab2x128(:,:,25))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(19),n2h64(20))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(51)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(26),h0tab(:,26),[64,15,32,16],[0,0,0,0],4,1,wf16(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,24),heltab2x128(:,:,26))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(20),n2h64(21))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(54)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(27),h0tab(:,27),[64,15,16,32],[0,0,0,0],4,1,wf16(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,25),heltab2x128(:,:,27))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(21),n2h64(22))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(51)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(28),h0tab(:,28),[64,15,16,32],[0,0,0,0],4,1,wf16(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,26),heltab2x128(:,:,28))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(22),n2h64(23))
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(54)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(29),h0tab(:,29),[64,16,15,32],[0,0,0,0],4,1,wf16(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(23),m3h2x64(:,27),heltab2x128(:,:,29))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(51)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(30),h0tab(:,30),[64,16,15,32],[0,0,0,0],4,1,wf16(:,12))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(24),m3h2x64(:,28),heltab2x128(:,:,30))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(89)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(31),h0tab(:,31),[64,15,32,16],[0,0,0,0],4,1,wf16(:,5))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,29),heltab2x128(:,:,31))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(25),n2h64(24))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(91)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(32),h0tab(:,32),[64,15,32,16],[0,0,0,0],4,1,wf16(:,27))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,30),heltab2x128(:,:,32))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(26),n2h64(25))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(89)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(33),h0tab(:,33),[64,15,16,32],[0,0,0,0],4,1,wf16(:,5))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,31),heltab2x128(:,:,33))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(27),n2h64(26))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(91)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(34),h0tab(:,34),[64,15,16,32],[0,0,0,0],4,1,wf16(:,27))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,32),heltab2x128(:,:,34))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(28),n2h64(27))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(89)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(35),h0tab(:,35),[64,16,15,32],[0,0,0,0],4,1,wf16(:,5))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(29),m3h2x64(:,33),heltab2x128(:,:,35))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(91)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(36),h0tab(:,36),[64,16,15,32],[0,0,0,0],4,1,wf16(:,27))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(30),m3h2x64(:,34),heltab2x128(:,:,36))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(93)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(37),h0tab(:,37),[64,15,32,16],[0,0,0,0],4,1,wf16(:,28))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,35),heltab2x128(:,:,37))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(31),n2h64(28))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(93)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(38),h0tab(:,38),[64,15,16,32],[0,0,0,0],4,1,wf16(:,28))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,36),heltab2x128(:,:,38))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(32),n2h64(29))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(93)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(39),h0tab(:,39),[64,16,15,32],[0,0,0,0],4,1,wf16(:,28))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(33),m3h2x64(:,37),heltab2x128(:,:,39))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(98)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(40),h0tab(:,40),[64,15,32,16],[0,0,0,0],4,1,wf16(:,8))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,38),heltab2x128(:,:,40))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(34),n2h64(30))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(100)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(41),h0tab(:,41),[64,15,32,16],[0,0,0,0],4,1,wf16(:,29))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,39),heltab2x128(:,:,41))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(35),n2h64(31))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(98)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(42),h0tab(:,42),[64,15,16,32],[0,0,0,0],4,1,wf16(:,8))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,40),heltab2x128(:,:,42))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(36),n2h64(32))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(100)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(43),h0tab(:,43),[64,15,16,32],[0,0,0,0],4,1,wf16(:,29))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,41),heltab2x128(:,:,43))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(37),n2h64(33))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(98)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(44),h0tab(:,44),[64,16,15,32],[0,0,0,0],4,1,wf16(:,8))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(38),m3h2x64(:,42),heltab2x128(:,:,44))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(100)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(45),h0tab(:,45),[64,16,15,32],[0,0,0,0],4,1,wf16(:,29))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(39),m3h2x64(:,43),heltab2x128(:,:,45))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(102)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(46),h0tab(:,46),[64,15,32,16],[0,0,0,0],4,1,wf16(:,30))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,44),heltab2x128(:,:,46))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(40),n2h64(34))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(102)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(47),h0tab(:,47),[64,15,16,32],[0,0,0,0],4,1,wf16(:,30))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,45),heltab2x128(:,:,47))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(41),n2h64(35))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(102)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(48),h0tab(:,48),[64,16,15,32],[0,0,0,0],4,1,wf16(:,30))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(42),m3h2x64(:,46),heltab2x128(:,:,48))
  call ol_merge(ntryL,G1H32(1),[G1H32(3)])
  call Hloop_QW_A(ntryL,G1H16(3),wf4(:,4),G1H4(9),m3h4x4(:,9),heltab2x16(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(9),79,0,G2H4(5),n2h4(12))
  call Hloop_AW_Q(ntryL,G1H16(9),wf4(:,5),G1H4(4),m3h4x4(:,10),heltab2x16(:,:,13))
  call Hloop_A_Q(ntryL,G1H4(4),79,0,G2H4(7),n2h4(13))
  call Hloop_QW_A(ntryL,G1H32(1),wf4(:,5),G1H8(11),m3h4x8(:,5),heltab2x32(:,:,6))
  call Hloop_Q_A(ntryL,G1H8(11),85,0,G2H8(4),n2h8(9))
  call Hloop_AW_Q(ntryL,G1H64(1),wf4(:,5),G1H16(2),m3h4x16(:,4),heltab2x64(:,:,5))
  call Hloop_A_Q(ntryL,G1H16(2),69,0,G2H16(3),n2h16(6))
  call Hloop_AW_Q(ntryL,G1H64(2),wf4(:,5),G1H16(4),m3h4x16(:,5),heltab2x64(:,:,6))
  call Hloop_A_Q(ntryL,G1H16(4),69,nMB,G2H16(1),n2h16(7))
  call Hloop_QW_A(ntryL,G1H64(3),wf4(:,5),G1H16(5),m3h4x16(:,6),heltab2x64(:,:,7))
  call Hloop_Q_A(ntryL,G1H16(5),69,0,G2H16(2),n2h16(8))
  call Hloop_QW_A(ntryL,G1H64(4),wf4(:,5),G1H16(6),m3h4x16(:,7),heltab2x64(:,:,8))
  call Hloop_Q_A(ntryL,G1H16(6),69,nMT,G2H16(4),n2h16(9))
  call Hloop_AW_Q(ntryL,G1H64(5),wf4(:,5),G1H16(7),m3h4x16(:,8),heltab2x64(:,:,9))
  call Hloop_A_Q(ntryL,G1H16(7),69,0,G2H16(5),n2h16(10))
  call Hloop_AW_Q(ntryL,G1H64(6),wf4(:,5),G1H16(8),m3h4x16(:,9),heltab2x64(:,:,10))
  call Hloop_A_Q(ntryL,G1H16(8),69,nMB,G2H16(6),n2h16(11))
  call Hloop_QW_A(ntryL,G1H64(7),wf4(:,5),G1H16(10),m3h4x16(:,10),heltab2x64(:,:,11))
  call Hloop_Q_A(ntryL,G1H16(10),69,0,G2H16(7),n2h16(12))
  call Hloop_QW_A(ntryL,G1H64(8),wf4(:,5),G1H16(11),m3h4x16(:,11),heltab2x64(:,:,12))
  call Hloop_Q_A(ntryL,G1H16(11),69,nMT,G2H16(8),n2h16(13))
  call Hloop_QW_A(ntryL,G1H64(9),wf4(:,4),G1H16(12),m3h4x16(:,12),heltab2x64(:,:,13))
  call Hloop_Q_A(ntryL,G1H16(12),74,0,G2H16(9),n2h16(14))
  call Hloop_QW_A(ntryL,G1H64(10),wf4(:,4),G1H16(3),m3h4x16(:,13),heltab2x64(:,:,14))
  call Hloop_Q_A(ntryL,G1H16(3),74,nMB,G2H16(10),n2h16(15))
  call Hloop_AW_Q(ntryL,G1H64(11),wf4(:,4),G1H16(9),m3h4x16(:,14),heltab2x64(:,:,15))
  call Hloop_A_Q(ntryL,G1H16(9),74,0,G2H16(11),n2h16(16))
  call Hloop_AW_Q(ntryL,G1H64(12),wf4(:,4),G1H16(2),m3h4x16(:,15),heltab2x64(:,:,16))
  call Hloop_A_Q(ntryL,G1H16(2),74,nMT,G2H16(12),n2h16(17))
  call Hloop_AW_Q(ntryL,G1H32(2),wf4(:,4),G1H8(12),m3h4x8(:,6),heltab2x32(:,:,7))
  call Hloop_A_Q(ntryL,G1H8(12),106,0,G2H8(6),n2h8(10))
  call Hloop_VQ_A(ntryL,G1H64(13),wf8(:,7),G1H8(1),m3h8x8(:,1),heltab2x64(:,:,17))
  call Hloop_Q_A(ntryL,G1H8(1),85,0,G2H8(7),n2h8(11))
  call Hloop_AW_Q(ntryL,G1H64(14),wf4(:,4),G1H16(4),m3h4x16(:,16),heltab2x64(:,:,18))
  call Hloop_A_Q(ntryL,G1H16(4),74,0,G2H16(13),n2h16(18))
  call Hloop_QW_A(ntryL,G1H64(15),wf4(:,4),G1H16(5),m3h4x16(:,17),heltab2x64(:,:,19))
  call Hloop_Q_A(ntryL,G1H16(5),74,0,G2H16(14),n2h16(19))
  call Hloop_VQ_A(ntryL,G1H64(16),ex5(:),G1H32(4),m3h2x32(:,2),heltab2x64(:,:,20))
  call Hloop_Q_A(ntryL,G1H32(4),80,0,G2H32(1),n2h32(5))
  call Hloop_QW_A(ntryL,G1H64(17),wf4(:,5),G1H16(6),m3h4x16(:,18),heltab2x64(:,:,21))
  call Hloop_Q_A(ntryL,G1H16(6),69,0,G2H16(15),n2h16(20))
  call Hloop_AW_Q(ntryL,G1H64(18),wf4(:,5),G1H16(7),m3h4x16(:,19),heltab2x64(:,:,22))
  call Hloop_A_Q(ntryL,G1H16(7),69,0,G2H16(16),n2h16(21))
  call Hloop_QV_A(ntryL,G1H64(19),wf16(:,2),G1H4(5),m3h16x4(:,1),heltab2x64(:,:,23))
  call Hloop_Q_A(ntryL,G1H4(5),79,0,G2H4(8),n2h4(14))
  call Hloop_QZ_A(ntryL,G1H64(20),wf16(:,12),G1H4(10),ngZd,m3h16x4(:,2),heltab2x64(:,:,24))
  call Hloop_Q_A(ntryL,G1H4(10),79,0,G2H4(1),n2h4(15))
  call Hloop_AV_Q(ntryL,G1H64(21),wf16(:,2),G1H4(11),m3h16x4(:,3),heltab2x64(:,:,25))
  call Hloop_A_Q(ntryL,G1H4(11),79,0,G2H4(4),n2h4(16))
  call Hloop_AZ_Q(ntryL,G1H64(22),wf16(:,12),G1H4(9),ngZd,m3h16x4(:,4),heltab2x64(:,:,26))
  call Hloop_A_Q(ntryL,G1H4(9),79,0,G2H4(9),n2h4(17))
  call Hloop_VQ_A(ntryL,G1H64(23),ex5(:),G1H32(5),m3h2x32(:,3),heltab2x64(:,:,27))
  call Hloop_Q_A(ntryL,G1H32(5),80,0,G2H32(2),n2h32(6))
  call Hloop_VQ_A(ntryL,G1H64(24),ex5(:),G1H32(6),m3h2x32(:,4),heltab2x64(:,:,28))
  call Hloop_Q_A(ntryL,G1H32(6),80,0,G2H32(3),n2h32(7))
  call Hloop_QV_A(ntryL,G1H64(25),wf16(:,5),G1H4(4),m3h16x4(:,5),heltab2x64(:,:,29))
  call Hloop_Q_A(ntryL,G1H4(4),79,0,G2H4(10),n2h4(18))
  call Hloop_QZ_A(ntryL,G1H64(26),wf16(:,27),G1H4(5),ngZd,m3h16x4(:,6),heltab2x64(:,:,30))
  call Hloop_Q_A(ntryL,G1H4(5),79,0,G2H4(11),n2h4(19))
  call Hloop_AV_Q(ntryL,G1H64(27),wf16(:,5),G1H4(10),m3h16x4(:,7),heltab2x64(:,:,31))
  call Hloop_A_Q(ntryL,G1H4(10),79,0,G2H4(12),n2h4(20))
  call Hloop_AZ_Q(ntryL,G1H64(28),wf16(:,27),G1H4(11),ngZd,m3h16x4(:,8),heltab2x64(:,:,32))
  call Hloop_A_Q(ntryL,G1H4(11),79,0,G2H4(13),n2h4(21))
  call Hloop_VQ_A(ntryL,G1H64(29),ex5(:),G1H32(3),m3h2x32(:,5),heltab2x64(:,:,33))
  call Hloop_Q_A(ntryL,G1H32(3),80,0,G2H32(4),n2h32(8))
  call Hloop_VQ_A(ntryL,G1H64(30),ex5(:),G1H32(1),m3h2x32(:,6),heltab2x64(:,:,34))
  call Hloop_Q_A(ntryL,G1H32(1),80,0,G2H32(5),n2h32(9))
  call Hloop_QZ_A(ntryL,G1H64(31),wf16(:,28),G1H4(9),ngZd,m3h16x4(:,9),heltab2x64(:,:,35))
  call Hloop_Q_A(ntryL,G1H4(9),79,0,G2H4(14),n2h4(22))
  call Hloop_AZ_Q(ntryL,G1H64(32),wf16(:,28),G1H4(4),ngZd,m3h16x4(:,10),heltab2x64(:,:,36))
  call Hloop_A_Q(ntryL,G1H4(4),79,0,G2H4(15),n2h4(23))
  call Hloop_VQ_A(ntryL,G1H64(33),ex5(:),G1H32(2),m3h2x32(:,7),heltab2x64(:,:,37))
  call Hloop_Q_A(ntryL,G1H32(2),80,0,G2H32(6),n2h32(10))
  call Hloop_QV_A(ntryL,G1H64(34),wf16(:,8),G1H4(5),m3h16x4(:,11),heltab2x64(:,:,38))
  call Hloop_Q_A(ntryL,G1H4(5),79,0,G2H4(16),n2h4(24))
  call Hloop_QZ_A(ntryL,G1H64(35),wf16(:,29),G1H4(10),ngZd,m3h16x4(:,12),heltab2x64(:,:,39))
  call Hloop_Q_A(ntryL,G1H4(10),79,0,G2H4(17),n2h4(25))
  call Hloop_AV_Q(ntryL,G1H64(36),wf16(:,8),G1H4(11),m3h16x4(:,13),heltab2x64(:,:,40))
  call Hloop_A_Q(ntryL,G1H4(11),79,0,G2H4(18),n2h4(26))
  call Hloop_AZ_Q(ntryL,G1H64(37),wf16(:,29),G1H4(9),ngZd,m3h16x4(:,14),heltab2x64(:,:,41))
  call Hloop_A_Q(ntryL,G1H4(9),79,0,G2H4(19),n2h4(27))
  call Hloop_VQ_A(ntryL,G1H64(38),ex5(:),G1H32(4),m3h2x32(:,8),heltab2x64(:,:,42))
  call Hloop_Q_A(ntryL,G1H32(4),80,0,G2H32(7),n2h32(11))
  call Hloop_VQ_A(ntryL,G1H64(39),ex5(:),G1H32(5),m3h2x32(:,9),heltab2x64(:,:,43))
  call Hloop_Q_A(ntryL,G1H32(5),80,0,G2H32(8),n2h32(12))
  call Hloop_QZ_A(ntryL,G1H64(40),wf16(:,30),G1H4(4),ngZd,m3h16x4(:,15),heltab2x64(:,:,44))
  call Hloop_Q_A(ntryL,G1H4(4),79,0,G2H4(20),n2h4(28))
  call Hloop_AZ_Q(ntryL,G1H64(41),wf16(:,30),G1H4(5),ngZd,m3h16x4(:,16),heltab2x64(:,:,45))
  call Hloop_A_Q(ntryL,G1H4(5),79,0,G2H4(21),n2h4(29))
  call Hloop_VQ_A(ntryL,G1H64(42),ex5(:),G1H32(6),m3h2x32(:,10),heltab2x64(:,:,46))
  call Hloop_Q_A(ntryL,G1H32(6),80,0,G2H32(9),n2h32(13))
  call ol_merge(ntryL,G2H8(4),[G1H8(9)])
call HGT_lower_alpha_w2_OLR(G2H8(2),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(2),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(2),6,15,8)
  call ol_merge(ntryL,G2H8(2),[G2H8(4)])
  call ol_merge(ntryL,G2H4(20),[G2H4(17),G2H4(16),G2H4(14),G2H4(11),G2H4(10),G2H4(1),G2H4(8),G2H4(2)])
call HGT_lower_alpha_w2_OLR(G2H8(3),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(3),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(3),6,15,8)
  call ol_merge(ntryL,G2H8(3),[G2H8(6)])
  call ol_merge(ntryL,G2H4(21),[G2H4(19),G2H4(18),G2H4(15),G2H4(13),G2H4(12),G2H4(9),G2H4(4),G2H4(6)])
  call ol_merge(ntryL,G2H8(7),[G2H8(5),G1H8(10)])
call Hotf_4pt_reduction(G2H8(2),RedSet_4(6),mass4set(:,1),  & 
G1H8(2),G1H8(5),G1H8(6),G1H8(7),G1H8(8),8)
call HG1shiftOLR(G1H8(5),32,8)
  call Hloop_QA_V(ntryL,G2H4(20),ex6(:),G2H2(1),m3h2x2(:,7),heltab2x4(:,:,11))
call Hotf_4pt_reduction(G2H8(3),RedSet_4(21),mass4set(:,1),  & 
G1H8(13),G1H8(18),G1H8(14),G1H8(17),G1H8(19),8)
call HG1shiftOLR(G1H8(18),16,8)
  call Hloop_AQ_V(ntryL,G2H4(21),ex5(:),G2H2(3),m3h2x2(:,8),heltab2x4(:,:,12))
call HGT_w2_OLR(G1H16(1),1,1,16)
call HGT_w2_invQ_OLR(G1H16(1),2,5,16)
  call Hloop_QW_A(ntryL,G1H16(1),wf4(:,5),G1H4(10),m3h4x4(:,11),heltab2x16(:,:,14))
  call Hloop_Q_A(ntryL,G1H4(10),117,0,G2H4(17),n2h4(30))
call Hotf_4pt_reduction(G2H8(7),RedSet_4(7),mass4set(:,1),  & 
G1H8(22),G1H8(11),G1H8(12),G1H8(1),G1H8(9),8)
call HG1shiftOLR(G1H8(11),32,8)
  call Hloop_VA_Q(ntryL,G1H8(3),ex6(:),G1H4(11),m3h2x4(:,7),heltab2x8(:,:,13))
  call Hloop_A_Q(ntryL,G1H4(11),117,0,G2H4(16),n2h4(31))
  call Hloop_VA_Q(ntryL,G1H8(4),ex6(:),G1H4(9),m3h2x4(:,8),heltab2x8(:,:,14))
  call Hloop_A_Q(ntryL,G1H4(9),117,0,G2H4(14),n2h4(32))
  call Hloop_QW_A(ntryL,G1H8(15),wf4(:,4),G1H2(6),m3h4x2(:,7),heltab2x8(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(6),95,0,G2H2(4),n2h2(6))
  call Hloop_QW_A(ntryL,G1H8(16),wf4(:,4),G1H2(17),m3h4x2(:,8),heltab2x8(:,:,16))
  call Hloop_Q_A(ntryL,G1H2(17),95,0,G2H2(6),n2h2(7))
  call Hloop_QW_A(ntryL,G1H8(20),wf4(:,4),G1H2(1),m3h4x2(:,9),heltab2x8(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(8),n2h2(8))
  call Hloop_QW_A(ntryL,G1H8(21),wf4(:,4),G1H2(2),m3h4x2(:,10),heltab2x8(:,:,18))
  call Hloop_Q_A(ntryL,G1H2(2),95,0,G2H2(10),n2h2(9))
  call Hloop_QA_V(ntryL,G2H4(5),ex6(:),G2H2(13),m3h2x2(:,9),heltab2x4(:,:,13))
  call Hloop_AQ_V(ntryL,G2H4(7),ex5(:),G2H2(14),m3h2x2(:,10),heltab2x4(:,:,14))
call Hotf_4pt_reduction(G2H16(3),RedSet_4(19),mass4set(:,1),  & 
G1H16(8),G1H16(10),G1H16(11),G1H16(12),G1H16(3),G0H16(1),16)
call HG1shiftOLR(G1H16(10),10,16)
call Hotf_4pt_reduction(G2H16(1),RedSet_4(19),mass4set(:,2),  & 
G1H16(9),G1H16(2),G1H16(4),G1H16(5),G1H16(6),G0H16(2),16)
call HG1shiftOLR(G1H16(2),10,16)
call Hotf_4pt_reduction(G2H16(2),RedSet_4(19),mass4set(:,1),  & 
G1H16(7),G1H16(1),G1H16(13),G1H16(14),G1H16(15),G0H16(3),16)
call HG1shiftOLR(G1H16(1),10,16)
call Hotf_4pt_reduction(G2H16(4),RedSet_4(19),mass4set(:,3),  & 
G1H16(16),G1H16(17),G1H16(18),G1H16(19),G1H16(20),G0H16(4),16)
call HG1shiftOLR(G1H16(17),10,16)
call Hotf_4pt_reduction(G2H16(5),RedSet_4(3),mass4set(:,1),  & 
G1H16(21),G1H16(22),G1H16(23),G1H16(24),G1H16(25),G0H16(5),16)
call HG1shiftOLR(G1H16(22),48,16)
call Hotf_4pt_reduction(G2H16(6),RedSet_4(3),mass4set(:,4),  & 
G1H16(26),G1H16(27),G1H16(28),G1H16(29),G1H16(30),G0H16(6),16)
call HG1shiftOLR(G1H16(27),48,16)
call Hotf_4pt_reduction(G2H16(7),RedSet_4(3),mass4set(:,1),  & 
G1H16(31),G1H16(32),G1H16(33),G1H16(34),G1H16(35),G0H16(7),16)
call HG1shiftOLR(G1H16(32),48,16)
call Hotf_4pt_reduction(G2H16(8),RedSet_4(3),mass4set(:,5),  & 
G1H16(36),G1H16(37),G1H16(38),G1H16(39),G1H16(40),G0H16(8),16)
call HG1shiftOLR(G1H16(37),48,16)
call Hotf_4pt_reduction(G2H16(9),RedSet_4(4),mass4set(:,1),  & 
G1H16(41),G1H16(42),G1H16(43),G1H16(44),G1H16(45),G0H16(9),16)
call HG1shiftOLR(G1H16(42),48,16)
call Hotf_4pt_reduction(G2H16(10),RedSet_4(4),mass4set(:,4),  & 
G1H16(46),G1H16(47),G1H16(48),G1H16(49),G1H16(50),G0H16(10),16)
call HG1shiftOLR(G1H16(47),48,16)
call Hotf_4pt_reduction(G2H16(11),RedSet_4(4),mass4set(:,1),  & 
G1H16(51),G1H16(52),G1H16(53),G1H16(54),G1H16(55),G0H16(11),16)
call HG1shiftOLR(G1H16(52),48,16)
call Hotf_4pt_reduction(G2H16(12),RedSet_4(4),mass4set(:,5),  & 
G1H16(56),G1H16(57),G1H16(58),G1H16(59),G1H16(60),G0H16(12),16)
call HG1shiftOLR(G1H16(57),48,16)
  call Hloop_AQ_V(ntryL,G2H16(13),wf8(:,7),G2H2(15),m3h8x2(:,1),heltab2x16(:,:,15))
  call Hloop_QA_V(ntryL,G2H16(14),ex6(:),G2H8(1),m3h2x8(:,4),heltab2x16(:,:,16))
call Hotf_4pt_reduction(G2H32(1),RedSet_4(2),mass4set(:,1),  & 
G1H32(3),G1H32(1),G1H32(2),G1H32(4),G1H32(5),32)
call HG1shiftOLR(G1H32(1),42,32)
  call Hloop_QA_V(ntryL,G2H16(15),wf8(:,2),G2H2(16),m3h8x2(:,2),heltab2x16(:,:,17))
  call Hloop_AQ_V(ntryL,G2H16(16),ex5(:),G2H8(4),m3h2x8(:,5),heltab2x16(:,:,18))
call Hotf_4pt_reduction(G2H32(2),RedSet_4(1),mass4set(:,1),  & 
G1H32(6),G1H32(7),G1H32(8),G1H32(9),G1H32(10),32)
call HG1shiftOLR(G1H32(7),32,32)
call Hotf_4pt_reduction(G2H32(3),RedSet_4(1),mass4set(:,1),  & 
G1H32(11),G1H32(12),G1H32(13),G1H32(14),G1H32(15),32)
call HG1shiftOLR(G1H32(12),32,32)
call Hotf_4pt_reduction(G2H32(4),RedSet_4(1),mass4set(:,1),  & 
G1H32(16),G1H32(17),G1H32(18),G1H32(19),G1H32(20),32)
call HG1shiftOLR(G1H32(17),32,32)
call Hotf_4pt_reduction(G2H32(5),RedSet_4(1),mass4set(:,1),  & 
G1H32(21),G1H32(22),G1H32(23),G1H32(24),G1H32(25),32)
call HG1shiftOLR(G1H32(22),32,32)
call Hotf_4pt_reduction(G2H32(6),RedSet_4(1),mass4set(:,1),  & 
G1H32(26),G1H32(27),G1H32(28),G1H32(29),G1H32(30),32)
call HG1shiftOLR(G1H32(27),32,32)
call Hotf_4pt_reduction(G2H32(7),RedSet_4(1),mass4set(:,1),  & 
G1H32(31),G1H32(32),G1H32(33),G1H32(34),G1H32(35),32)
call HG1shiftOLR(G1H32(32),32,32)
call Hotf_4pt_reduction(G2H32(8),RedSet_4(1),mass4set(:,1),  & 
G1H32(36),G1H32(37),G1H32(38),G1H32(39),G1H32(40),32)
call HG1shiftOLR(G1H32(37),32,32)
call Hotf_4pt_reduction(G2H32(9),RedSet_4(1),mass4set(:,1),  & 
G1H32(41),G1H32(42),G1H32(43),G1H32(44),G1H32(45),32)
call HG1shiftOLR(G1H32(42),32,32)
  call Hloop_QW_A(ntryL,G1H8(2),wf4(:,4),G1H2(7),m3h4x2(:,11),heltab2x8(:,:,19))
  call Hloop_Q_A(ntryL,G1H2(7),95,0,G2H2(17),n2h2(10))
call HGT_raise_alpha_OLR(G1H8(5),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(5),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(5),ex6(:),G1H4(4),m3h2x4(:,9),heltab2x8(:,:,20))
  call Hloop_QW_A(ntryL,G1H8(7),wf4(:,4),G1H2(8),m3h4x2(:,12),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G1H2(8),95,0,G2H2(18),n2h2(11))
  call Hloop_QW_A(ntryL,G1H8(8),wf4(:,4),G1H2(12),m3h4x2(:,13),heltab2x8(:,:,22))
  call Hloop_Q_A(ntryL,G1H2(12),95,0,G2H2(19),n2h2(12))
  call Hloop_AW_Q(ntryL,G1H8(13),wf4(:,5),G1H2(13),m3h4x2(:,14),heltab2x8(:,:,23))
  call Hloop_A_Q(ntryL,G1H2(13),111,0,G2H2(20),n2h2(13))
call HGT_raise_alpha_OLR(G1H8(18),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(18),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(18),ex5(:),G1H4(5),m3h2x4(:,10),heltab2x8(:,:,24))
  call Hloop_AW_Q(ntryL,G1H8(17),wf4(:,5),G1H2(18),m3h4x2(:,15),heltab2x8(:,:,25))
  call Hloop_A_Q(ntryL,G1H2(18),111,0,G2H2(21),n2h2(14))
  call Hloop_AW_Q(ntryL,G1H8(19),wf4(:,5),G1H2(19),m3h4x2(:,16),heltab2x8(:,:,26))
  call Hloop_A_Q(ntryL,G1H2(19),111,0,G2H2(22),n2h2(15))
  call Hloop_QW_A(ntryL,G1H8(22),wf4(:,4),G1H2(6),m3h4x2(:,17),heltab2x8(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(6),95,0,G2H2(23),n2h2(16))
call HGT_raise_alpha_OLR(G1H8(11),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(11),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(11),ex6(:),G1H4(10),m3h2x4(:,11),heltab2x8(:,:,28))
  call Hloop_QW_A(ntryL,G1H8(1),wf4(:,4),G1H2(17),m3h4x2(:,18),heltab2x8(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(17),95,0,G2H2(24),n2h2(17))
  call Hloop_QW_A(ntryL,G1H8(9),wf4(:,4),G1H2(1),m3h4x2(:,19),heltab2x8(:,:,30))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(25),n2h2(18))
  call Hloop_AV_Q(ntryL,G1H16(8),wf4(:,9),G1H4(11),m3h4x4(:,12),heltab2x16(:,:,19))
  call Hloop_A_Q(ntryL,G1H4(11),117,0,G2H4(11),n2h4(33))
call HGT_OLR(G1H16(10),1,1,16)
call HGT_invQ_OLR(G1H16(10),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(10),-10,0,G2H16(3),n2h16(22))
  call Hloop_QW_A(ntryL,G2H16(3),wf4(:,4),G2H4(10),m3h4x4(:,13),heltab2x16(:,:,20))
  call Hloop_AV_Q(ntryL,G1H16(12),wf4(:,9),G1H4(9),m3h4x4(:,14),heltab2x16(:,:,21))
  call Hloop_A_Q(ntryL,G1H4(9),117,0,G2H4(1),n2h4(34))
  call Hloop_AV_Q(ntryL,G1H16(3),wf4(:,9),G1H4(11),m3h4x4(:,15),heltab2x16(:,:,22))
  call Hloop_A_Q(ntryL,G1H4(11),117,0,G2H4(8),n2h4(35))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,9),G0H4(1),m3h4x4(:,16),heltab2x16(:,:,23))
  call Hloop_A_Q(ntryL,G0H4(1),117,0,G1H4(9),n2h4(36))
  call Hloop_AV_Q(ntryL,G1H16(9),wf4(:,9),G1H4(11),m3h4x4(:,17),heltab2x16(:,:,24))
  call Hloop_A_Q(ntryL,G1H4(11),117,nMB,G2H4(2),n2h4(37))
call HGT_OLR(G1H16(2),1,1,16)
call HGT_invQ_OLR(G1H16(2),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(2),-10,nMT,G2H16(1),n2h16(23))
  call Hloop_QW_A(ntryL,G2H16(1),wf4(:,4),G2H4(19),m3h4x4(:,18),heltab2x16(:,:,25))
  call Hloop_AV_Q(ntryL,G1H16(5),wf4(:,9),G1H4(11),m3h4x4(:,19),heltab2x16(:,:,26))
  call Hloop_A_Q(ntryL,G1H4(11),117,nMB,G2H4(18),n2h4(38))
  call Hloop_AV_Q(ntryL,G1H16(6),wf4(:,9),G1H4(11),m3h4x4(:,20),heltab2x16(:,:,27))
  call Hloop_A_Q(ntryL,G1H4(11),117,nMB,G2H4(15),n2h4(39))
  call Hloop_AV_Q(ntryL,G0H16(2),wf4(:,9),G0H4(1),m3h4x4(:,21),heltab2x16(:,:,28))
  call Hloop_A_Q(ntryL,G0H4(1),117,nMB,G1H4(11),n2h4(40))
  call Hloop_QV_A(ntryL,G1H16(7),wf4(:,9),G1H4(15),m3h4x4(:,22),heltab2x16(:,:,29))
  call Hloop_Q_A(ntryL,G1H4(15),117,0,G2H4(13),n2h4(41))
call HGT_OLR(G1H16(1),1,1,16)
call HGT_invQ_OLR(G1H16(1),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(1),-10,0,G2H16(2),n2h16(24))
  call Hloop_AW_Q(ntryL,G2H16(2),wf4(:,4),G2H4(12),m3h4x4(:,23),heltab2x16(:,:,30))
  call Hloop_QV_A(ntryL,G1H16(14),wf4(:,9),G1H4(15),m3h4x4(:,24),heltab2x16(:,:,31))
  call Hloop_Q_A(ntryL,G1H4(15),117,0,G2H4(9),n2h4(42))
  call Hloop_QV_A(ntryL,G1H16(15),wf4(:,9),G1H4(15),m3h4x4(:,25),heltab2x16(:,:,32))
  call Hloop_Q_A(ntryL,G1H4(15),117,0,G2H4(4),n2h4(43))
  call Hloop_QV_A(ntryL,G0H16(3),wf4(:,9),G0H4(1),m3h4x4(:,26),heltab2x16(:,:,33))
  call Hloop_Q_A(ntryL,G0H4(1),117,0,G1H4(15),n2h4(44))
  call Hloop_QV_A(ntryL,G1H16(16),wf4(:,9),G1H4(16),m3h4x4(:,27),heltab2x16(:,:,34))
  call Hloop_Q_A(ntryL,G1H4(16),117,nMT,G2H4(6),n2h4(45))
call HGT_OLR(G1H16(17),1,1,16)
call HGT_invQ_OLR(G1H16(17),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(17),-10,nMB,G2H16(4),n2h16(25))
  call Hloop_AW_Q(ntryL,G2H16(4),wf4(:,4),G2H4(20),m3h4x4(:,28),heltab2x16(:,:,35))
  call Hloop_QV_A(ntryL,G1H16(19),wf4(:,9),G1H4(16),m3h4x4(:,29),heltab2x16(:,:,36))
  call Hloop_Q_A(ntryL,G1H4(16),117,nMT,G2H4(21),n2h4(46))
  call Hloop_QV_A(ntryL,G1H16(20),wf4(:,9),G1H4(16),m3h4x4(:,30),heltab2x16(:,:,37))
  call Hloop_Q_A(ntryL,G1H4(16),117,nMT,G2H4(5),n2h4(47))
  call Hloop_QV_A(ntryL,G0H16(4),wf4(:,9),G0H4(1),m3h4x4(:,31),heltab2x16(:,:,38))
  call Hloop_Q_A(ntryL,G0H4(1),117,nMT,G1H4(16),n2h4(48))
  call Hloop_AW_Q(ntryL,G1H16(21),wf4(:,4),G1H4(17),m3h4x4(:,32),heltab2x16(:,:,39))
  call Hloop_A_Q(ntryL,G1H4(17),79,0,G2H4(7),n2h4(49))
call HGT_OLR(G1H16(22),1,1,16)
call HGT_invQ_OLR(G1H16(22),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(22),-48,0,G2H16(5),n2h16(26))
  call Hloop_QV_A(ntryL,G2H16(5),wf4(:,9),G2H4(22),m3h4x4(:,33),heltab2x16(:,:,40))
  call Hloop_AW_Q(ntryL,G1H16(24),wf4(:,4),G1H4(17),m3h4x4(:,34),heltab2x16(:,:,41))
  call Hloop_A_Q(ntryL,G1H4(17),79,0,G2H4(23),n2h4(50))
  call Hloop_AW_Q(ntryL,G1H16(25),wf4(:,4),G1H4(17),m3h4x4(:,35),heltab2x16(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(17),79,0,G2H4(24),n2h4(51))
  call Hloop_AW_Q(ntryL,G0H16(5),wf4(:,4),G0H4(1),m3h4x4(:,36),heltab2x16(:,:,43))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(17),n2h4(52))
  call Hloop_AW_Q(ntryL,G1H16(26),wf4(:,4),G1H4(18),m3h4x4(:,37),heltab2x16(:,:,44))
  call Hloop_A_Q(ntryL,G1H4(18),79,nMT,G2H4(25),n2h4(53))
call HGT_OLR(G1H16(27),1,1,16)
call HGT_invQ_OLR(G1H16(27),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(27),-48,nMT,G2H16(6),n2h16(27))
  call Hloop_QV_A(ntryL,G2H16(6),wf4(:,9),G2H4(26),m3h4x4(:,38),heltab2x16(:,:,45))
  call Hloop_AW_Q(ntryL,G1H16(29),wf4(:,4),G1H4(18),m3h4x4(:,39),heltab2x16(:,:,46))
  call Hloop_A_Q(ntryL,G1H4(18),79,nMT,G2H4(27),n2h4(54))
  call Hloop_AW_Q(ntryL,G1H16(30),wf4(:,4),G1H4(18),m3h4x4(:,40),heltab2x16(:,:,47))
  call Hloop_A_Q(ntryL,G1H4(18),79,nMT,G2H4(28),n2h4(55))
  call Hloop_AW_Q(ntryL,G0H16(6),wf4(:,4),G0H4(1),m3h4x4(:,41),heltab2x16(:,:,48))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMT,G1H4(18),n2h4(56))
  call Hloop_QW_A(ntryL,G1H16(31),wf4(:,4),G1H4(19),m3h4x4(:,42),heltab2x16(:,:,49))
  call Hloop_Q_A(ntryL,G1H4(19),79,0,G2H4(29),n2h4(57))
call HGT_OLR(G1H16(32),1,1,16)
call HGT_invQ_OLR(G1H16(32),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(32),-48,0,G2H16(7),n2h16(28))
  call Hloop_AV_Q(ntryL,G2H16(7),wf4(:,9),G2H4(30),m3h4x4(:,43),heltab2x16(:,:,50))
  call Hloop_QW_A(ntryL,G1H16(34),wf4(:,4),G1H4(19),m3h4x4(:,44),heltab2x16(:,:,51))
  call Hloop_Q_A(ntryL,G1H4(19),79,0,G2H4(31),n2h4(58))
  call Hloop_QW_A(ntryL,G1H16(35),wf4(:,4),G1H4(19),m3h4x4(:,45),heltab2x16(:,:,52))
  call Hloop_Q_A(ntryL,G1H4(19),79,0,G2H4(32),n2h4(59))
  call Hloop_QW_A(ntryL,G0H16(7),wf4(:,4),G0H4(1),m3h4x4(:,46),heltab2x16(:,:,53))
  call Hloop_Q_A(ntryL,G0H4(1),79,0,G1H4(19),n2h4(60))
  call Hloop_QW_A(ntryL,G1H16(36),wf4(:,4),G1H4(20),m3h4x4(:,47),heltab2x16(:,:,54))
  call Hloop_Q_A(ntryL,G1H4(20),79,nMB,G2H4(33),n2h4(61))
call HGT_OLR(G1H16(37),1,1,16)
call HGT_invQ_OLR(G1H16(37),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(37),-48,nMB,G2H16(8),n2h16(29))
  call Hloop_AV_Q(ntryL,G2H16(8),wf4(:,9),G2H4(34),m3h4x4(:,48),heltab2x16(:,:,55))
  call Hloop_QW_A(ntryL,G1H16(39),wf4(:,4),G1H4(20),m3h4x4(:,49),heltab2x16(:,:,56))
  call Hloop_Q_A(ntryL,G1H4(20),79,nMB,G2H4(35),n2h4(62))
  call Hloop_QW_A(ntryL,G1H16(40),wf4(:,4),G1H4(20),m3h4x4(:,50),heltab2x16(:,:,57))
  call Hloop_Q_A(ntryL,G1H4(20),79,nMB,G2H4(36),n2h4(63))
  call Hloop_QW_A(ntryL,G0H16(8),wf4(:,4),G0H4(1),m3h4x4(:,51),heltab2x16(:,:,58))
  call Hloop_Q_A(ntryL,G0H4(1),79,nMB,G1H4(20),n2h4(64))
  call Hloop_QW_A(ntryL,G1H16(41),wf4(:,5),G1H4(21),m3h4x4(:,52),heltab2x16(:,:,59))
  call Hloop_Q_A(ntryL,G1H4(21),79,0,G2H4(37),n2h4(65))
call HGT_OLR(G1H16(42),1,1,16)
call HGT_invQ_OLR(G1H16(42),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(42),-48,0,G2H16(9),n2h16(30))
  call Hloop_AV_Q(ntryL,G2H16(9),wf4(:,9),G2H4(38),m3h4x4(:,53),heltab2x16(:,:,60))
  call Hloop_QW_A(ntryL,G1H16(44),wf4(:,5),G1H4(21),m3h4x4(:,54),heltab2x16(:,:,61))
  call Hloop_Q_A(ntryL,G1H4(21),79,0,G2H4(39),n2h4(66))
  call Hloop_QW_A(ntryL,G1H16(45),wf4(:,5),G1H4(21),m3h4x4(:,55),heltab2x16(:,:,62))
  call Hloop_Q_A(ntryL,G1H4(21),79,0,G2H4(40),n2h4(67))
  call Hloop_QW_A(ntryL,G0H16(9),wf4(:,5),G0H4(1),m3h4x4(:,56),heltab2x16(:,:,63))
  call Hloop_Q_A(ntryL,G0H4(1),79,0,G1H4(21),n2h4(68))
  call Hloop_QW_A(ntryL,G1H16(46),wf4(:,5),G1H4(22),m3h4x4(:,57),heltab2x16(:,:,64))
  call Hloop_Q_A(ntryL,G1H4(22),79,nMT,G2H4(41),n2h4(69))
call HGT_OLR(G1H16(47),1,1,16)
call HGT_invQ_OLR(G1H16(47),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(47),-48,nMT,G2H16(10),n2h16(31))
  call Hloop_AV_Q(ntryL,G2H16(10),wf4(:,9),G2H4(42),m3h4x4(:,58),heltab2x16(:,:,65))
  call Hloop_QW_A(ntryL,G1H16(49),wf4(:,5),G1H4(22),m3h4x4(:,59),heltab2x16(:,:,66))
  call Hloop_Q_A(ntryL,G1H4(22),79,nMT,G2H4(43),n2h4(70))
  call Hloop_QW_A(ntryL,G1H16(50),wf4(:,5),G1H4(22),m3h4x4(:,60),heltab2x16(:,:,67))
  call Hloop_Q_A(ntryL,G1H4(22),79,nMT,G2H4(44),n2h4(71))
  call Hloop_QW_A(ntryL,G0H16(10),wf4(:,5),G0H4(1),m3h4x4(:,61),heltab2x16(:,:,68))
  call Hloop_Q_A(ntryL,G0H4(1),79,nMT,G1H4(22),n2h4(72))
  call Hloop_AW_Q(ntryL,G1H16(51),wf4(:,5),G1H4(23),m3h4x4(:,62),heltab2x16(:,:,69))
  call Hloop_A_Q(ntryL,G1H4(23),79,0,G2H4(45),n2h4(73))
call HGT_OLR(G1H16(52),1,1,16)
call HGT_invQ_OLR(G1H16(52),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(52),-48,0,G2H16(11),n2h16(32))
  call Hloop_QV_A(ntryL,G2H16(11),wf4(:,9),G2H4(46),m3h4x4(:,63),heltab2x16(:,:,70))
  call Hloop_AW_Q(ntryL,G1H16(54),wf4(:,5),G1H4(23),m3h4x4(:,64),heltab2x16(:,:,71))
  call Hloop_A_Q(ntryL,G1H4(23),79,0,G2H4(47),n2h4(74))
  call Hloop_AW_Q(ntryL,G1H16(55),wf4(:,5),G1H4(23),m3h4x4(:,65),heltab2x16(:,:,72))
  call Hloop_A_Q(ntryL,G1H4(23),79,0,G2H4(48),n2h4(75))
  call Hloop_AW_Q(ntryL,G0H16(11),wf4(:,5),G0H4(1),m3h4x4(:,66),heltab2x16(:,:,73))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(23),n2h4(76))
  call Hloop_AW_Q(ntryL,G1H16(56),wf4(:,5),G1H4(24),m3h4x4(:,67),heltab2x16(:,:,74))
  call Hloop_A_Q(ntryL,G1H4(24),79,nMB,G2H4(49),n2h4(77))
call HGT_OLR(G1H16(57),1,1,16)
call HGT_invQ_OLR(G1H16(57),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(57),-48,nMB,G2H16(12),n2h16(33))
  call Hloop_QV_A(ntryL,G2H16(12),wf4(:,9),G2H4(50),m3h4x4(:,68),heltab2x16(:,:,75))
  call Hloop_AW_Q(ntryL,G1H16(59),wf4(:,5),G1H4(24),m3h4x4(:,69),heltab2x16(:,:,76))
  call Hloop_A_Q(ntryL,G1H4(24),79,nMB,G2H4(51),n2h4(78))
  call Hloop_AW_Q(ntryL,G1H16(60),wf4(:,5),G1H4(24),m3h4x4(:,70),heltab2x16(:,:,77))
  call Hloop_A_Q(ntryL,G1H4(24),79,nMB,G2H4(52),n2h4(79))
  call Hloop_AW_Q(ntryL,G0H16(12),wf4(:,5),G0H4(1),m3h4x4(:,71),heltab2x16(:,:,78))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(24),n2h4(80))
  call Hloop_QW_A(ntryL,G1H32(3),wf4(:,5),G1H8(10),m3h4x8(:,7),heltab2x32(:,:,8))
  call Hloop_Q_A(ntryL,G1H8(10),85,0,G2H8(6),n2h8(15))
call HGT_raise_alpha_OLR(G1H32(1),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(1),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(1),wf8(:,2),G1H4(25),m3h8x4(:,1),heltab2x32(:,:,9))
  call Hloop_QW_A(ntryL,G1H32(4),wf4(:,5),G1H8(3),m3h4x8(:,8),heltab2x32(:,:,10))
  call Hloop_Q_A(ntryL,G1H8(3),85,0,G2H8(5),n2h8(16))
  call Hloop_QW_A(ntryL,G1H32(5),wf4(:,5),G1H8(4),m3h4x8(:,9),heltab2x32(:,:,11))
  call Hloop_Q_A(ntryL,G1H8(4),85,0,G2H8(2),n2h8(17))
  call Hloop_QV_A(ntryL,G1H32(6),wf16(:,2),G1H2(2),m3h16x2(:,1),heltab2x32(:,:,12))
  call Hloop_Q_A(ntryL,G1H2(2),95,0,G2H2(26),n2h2(19))
call HGT_raise_alpha_OLR(G1H32(7),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(7),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(7),ex6(:),G1H16(8),m3h2x16(:,2),heltab2x32(:,:,13))
  call Hloop_QV_A(ntryL,G1H32(9),wf16(:,2),G1H2(7),m3h16x2(:,2),heltab2x32(:,:,14))
  call Hloop_Q_A(ntryL,G1H2(7),95,0,G2H2(27),n2h2(20))
  call Hloop_QV_A(ntryL,G1H32(10),wf16(:,2),G1H2(8),m3h16x2(:,3),heltab2x32(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(8),95,0,G2H2(28),n2h2(21))
  call Hloop_QZ_A(ntryL,G1H32(11),wf16(:,12),G1H2(12),ngZd,m3h16x2(:,4),heltab2x32(:,:,16))
  call Hloop_Q_A(ntryL,G1H2(12),95,0,G2H2(29),n2h2(22))
call HGT_raise_alpha_OLR(G1H32(12),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(12),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(12),ex6(:),G1H16(10),m3h2x16(:,3),heltab2x32(:,:,17))
  call Hloop_QZ_A(ntryL,G1H32(14),wf16(:,12),G1H2(13),ngZd,m3h16x2(:,5),heltab2x32(:,:,18))
  call Hloop_Q_A(ntryL,G1H2(13),95,0,G2H2(30),n2h2(23))
  call Hloop_QZ_A(ntryL,G1H32(15),wf16(:,12),G1H2(18),ngZd,m3h16x2(:,6),heltab2x32(:,:,19))
  call Hloop_Q_A(ntryL,G1H2(18),95,0,G2H2(31),n2h2(24))
  call Hloop_QV_A(ntryL,G1H32(16),wf16(:,5),G1H2(19),m3h16x2(:,7),heltab2x32(:,:,20))
  call Hloop_Q_A(ntryL,G1H2(19),95,0,G2H2(32),n2h2(25))
call HGT_raise_alpha_OLR(G1H32(17),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(17),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(17),ex6(:),G1H16(12),m3h2x16(:,4),heltab2x32(:,:,21))
  call Hloop_QV_A(ntryL,G1H32(19),wf16(:,5),G1H2(6),m3h16x2(:,8),heltab2x32(:,:,22))
  call Hloop_Q_A(ntryL,G1H2(6),95,0,G2H2(33),n2h2(26))
  call Hloop_QV_A(ntryL,G1H32(20),wf16(:,5),G1H2(17),m3h16x2(:,9),heltab2x32(:,:,23))
  call Hloop_Q_A(ntryL,G1H2(17),95,0,G2H2(34),n2h2(27))
  call Hloop_QZ_A(ntryL,G1H32(21),wf16(:,27),G1H2(1),ngZd,m3h16x2(:,10),heltab2x32(:,:,24))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(35),n2h2(28))
call HGT_raise_alpha_OLR(G1H32(22),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(22),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(22),ex6(:),G1H16(3),m3h2x16(:,5),heltab2x32(:,:,25))
  call Hloop_QZ_A(ntryL,G1H32(24),wf16(:,27),G1H2(2),ngZd,m3h16x2(:,11),heltab2x32(:,:,26))
  call Hloop_Q_A(ntryL,G1H2(2),95,0,G2H2(36),n2h2(29))
  call Hloop_QZ_A(ntryL,G1H32(25),wf16(:,27),G1H2(7),ngZd,m3h16x2(:,12),heltab2x32(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(7),95,0,G2H2(37),n2h2(30))
  call Hloop_QZ_A(ntryL,G1H32(26),wf16(:,28),G1H2(8),ngZd,m3h16x2(:,13),heltab2x32(:,:,28))
  call Hloop_Q_A(ntryL,G1H2(8),95,0,G2H2(38),n2h2(31))
call HGT_raise_alpha_OLR(G1H32(27),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(27),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(27),ex6(:),G1H16(9),m3h2x16(:,6),heltab2x32(:,:,29))
  call Hloop_QZ_A(ntryL,G1H32(29),wf16(:,28),G1H2(12),ngZd,m3h16x2(:,14),heltab2x32(:,:,30))
  call Hloop_Q_A(ntryL,G1H2(12),95,0,G2H2(39),n2h2(32))
  call Hloop_QZ_A(ntryL,G1H32(30),wf16(:,28),G1H2(13),ngZd,m3h16x2(:,15),heltab2x32(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(13),95,0,G2H2(40),n2h2(33))
  call Hloop_QV_A(ntryL,G1H32(31),wf16(:,8),G1H2(18),m3h16x2(:,16),heltab2x32(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(18),95,0,G2H2(41),n2h2(34))
call HGT_raise_alpha_OLR(G1H32(32),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(32),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(32),ex6(:),G1H16(2),m3h2x16(:,7),heltab2x32(:,:,33))
  call Hloop_QV_A(ntryL,G1H32(34),wf16(:,8),G1H2(19),m3h16x2(:,17),heltab2x32(:,:,34))
  call Hloop_Q_A(ntryL,G1H2(19),95,0,G2H2(42),n2h2(35))
  call Hloop_QV_A(ntryL,G1H32(35),wf16(:,8),G1H2(6),m3h16x2(:,18),heltab2x32(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(6),95,0,G2H2(43),n2h2(36))
  call Hloop_QZ_A(ntryL,G1H32(36),wf16(:,29),G1H2(17),ngZd,m3h16x2(:,19),heltab2x32(:,:,36))
  call Hloop_Q_A(ntryL,G1H2(17),95,0,G2H2(44),n2h2(37))
call HGT_raise_alpha_OLR(G1H32(37),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(37),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(37),ex6(:),G1H16(5),m3h2x16(:,8),heltab2x32(:,:,37))
  call Hloop_QZ_A(ntryL,G1H32(39),wf16(:,29),G1H2(1),ngZd,m3h16x2(:,20),heltab2x32(:,:,38))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(45),n2h2(38))
  call Hloop_QZ_A(ntryL,G1H32(40),wf16(:,29),G1H2(2),ngZd,m3h16x2(:,21),heltab2x32(:,:,39))
  call Hloop_Q_A(ntryL,G1H2(2),95,0,G2H2(46),n2h2(39))
  call Hloop_QZ_A(ntryL,G1H32(41),wf16(:,30),G1H2(7),ngZd,m3h16x2(:,22),heltab2x32(:,:,40))
  call Hloop_Q_A(ntryL,G1H2(7),95,0,G2H2(47),n2h2(40))
call HGT_raise_alpha_OLR(G1H32(42),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(42),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(42),ex6(:),G1H16(6),m3h2x16(:,9),heltab2x32(:,:,41))
  call Hloop_QZ_A(ntryL,G1H32(44),wf16(:,30),G1H2(8),ngZd,m3h16x2(:,23),heltab2x32(:,:,42))
  call Hloop_Q_A(ntryL,G1H2(8),95,0,G2H2(48),n2h2(41))
  call Hloop_QZ_A(ntryL,G1H32(45),wf16(:,30),G1H2(12),ngZd,m3h16x2(:,24),heltab2x32(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(12),95,0,G2H2(49),n2h2(42))
  call ol_merge(ntryL,G2H2(16),[G2H2(2),G1H2(5)])
  call ol_merge(ntryL,G2H2(15),[G2H2(5),G1H2(16)])
  call ol_merge(ntryL,G2H2(14),[G1H2(14)])
call HGT_OLR(G2H2(7),1,1,2)
call HGT_invQ_OLR(G2H2(7),2,5,2)
call HGT_OLR(G2H2(7),6,15,2)
  call ol_merge(ntryL,G2H2(7),[G2H2(14)])
  call ol_merge(ntryL,G2H4(11),[G2H4(3),G1H4(8)])
call HGT_w2_OLR(G1H4(1),1,1,4)
call HGT_w2_invQ_OLR(G1H4(1),2,5,4)
  call ol_merge(ntryL,G2H4(17),[G1H4(1)])
  call ol_merge(ntryL,G2H2(47),[G2H2(44),G2H2(41),G2H2(38),G2H2(35),G2H2(32),G2H2(29),G2H2(26),G2H2(9)])
  call ol_merge(ntryL,G2H2(49),[G2H2(46),G2H2(43),G2H2(40),G2H2(37),G2H2(34),G2H2(31),G2H2(28),G2H2(12),G2H2(11)])
  call ol_merge(ntryL,G2H2(13),[G1H2(3)])
  call ol_merge(ntryL,G2H2(1),[G1H2(4)])
  call ol_merge(ntryL,G2H2(3),[G1H2(15)])
  call ol_merge(ntryL,G2H4(16),[G1H4(6)])
  call ol_merge(ntryL,G2H4(14),[G1H4(7)])
  call ol_merge(ntryL,G2H4(8),[G1H4(14)])
  call ol_merge(ntryL,G2H2(19),[G2H2(8)])
  call ol_merge(ntryL,G2H2(25),[G2H2(10)])
call Hotf_4pt_reduction(G2H2(16),RedSet_4(11),mass4set(:,1),  & 
G1H2(13),G1H2(18),G1H2(19),G1H2(6),G1H2(17),2)
call HG1shiftOLR(G1H2(18),16,2)
call Hotf_4pt_reduction(G2H2(15),RedSet_4(15),mass4set(:,1),  & 
G1H2(1),G1H2(2),G1H2(7),G1H2(8),G1H2(12),2)
call HG1shiftOLR(G1H2(2),32,2)
call Hotf_4pt_reduction(G2H2(7),RedSet_4(13),mass4set(:,1),  & 
G1H2(5),G1H2(16),G1H2(14),G1H2(3),G1H2(4),2)
call HG1shiftOLR(G1H2(16),32,2)
call Hotf_4pt_reduction(G2H4(11),RedSet_4(19),mass4set(:,1),  & 
G1H4(8),G1H4(1),G1H4(6),G1H4(7),G1H4(14),4)
call HG1shiftOLR(G1H4(1),10,4)
call Hotf_4pt_reduction(G2H4(17),RedSet_4(22),mass4set(:,1),  & 
G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
call HG1shiftOLR(G1H4(27),10,4)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(47),ex6(:),G2tensor(1),m3h2x1(:,11),heltab2x2(:,:,11))
call HGT_w2_OLR(G1H4(2),1,1,4)
call HGT_w2_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_QW_A(ntryL,G1H4(2),wf4(:,4),G1H1(1),m3h4x1(:,5),heltab2x4(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(3),n2h1(13))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(49),ex6(:),G2tensor(7),m3h2x1(:,12),heltab2x2(:,:,12))
call HGT_w2_OLR(G1H4(3),1,1,4)
call HGT_w2_invQ_OLR(G1H4(3),2,5,4)
  call Hloop_QW_A(ntryL,G1H4(3),wf4(:,4),G1H1(1),m3h4x1(:,6),heltab2x4(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(11),n2h1(14))
call Hotf_4pt_reduction(G2H2(13),RedSet_4(9),mass4set(:,1),  & 
G1H2(15),G1H2(23),G1H2(24),G1H2(25),G1H2(26),2)
call HG1shiftOLR(G1H2(23),16,2)
call Hotf_4pt_reduction(G2H2(1),RedSet_4(10),mass4set(:,1),  & 
G1H2(27),G1H2(28),G1H2(29),G1H2(30),G1H2(31),2)
call HG1shiftOLR(G1H2(28),16,2)
  call Hloop_VQ_A(ntryL,G1H2(9),ex5(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(15),n2h1(15))
  call Hloop_VQ_A(ntryL,G1H2(10),ex5(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(16),n2h1(16))
  call Hloop_VQ_A(ntryL,G1H2(11),ex5(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(17),n2h1(17))
call Hotf_4pt_reduction(G2H2(3),RedSet_4(14),mass4set(:,1),  & 
G1H2(9),G1H2(10),G1H2(11),G1H2(32),G1H2(33),2)
call HG1shiftOLR(G1H2(10),32,2)
  call Hloop_VA_Q(ntryL,G1H2(20),ex6(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(18),n2h1(18))
  call Hloop_VA_Q(ntryL,G1H2(21),ex6(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(19),n2h1(19))
  call Hloop_VA_Q(ntryL,G1H2(22),ex6(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(20),n2h1(20))
call Hotf_4pt_reduction(G2H4(16),RedSet_4(17),mass4set(:,1),  & 
G1H4(2),G1H4(3),G1H4(31),G1H4(32),G1H4(33),4)
call HG1shiftOLR(G1H4(3),10,4)
call Hotf_4pt_reduction(G2H4(14),RedSet_4(18),mass4set(:,1),  & 
G1H4(34),G1H4(35),G1H4(36),G1H4(37),G1H4(38),4)
call HG1shiftOLR(G1H4(35),10,4)
  call Hloop_AW_Q(ntryL,G1H4(12),wf4(:,4),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(21),n2h1(21))
  call Hloop_AW_Q(ntryL,G1H4(13),wf4(:,4),G1H1(1),m3h4x1(:,8),heltab2x4(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(22),n2h1(22))
  call Hloop_AW_Q(ntryL,G2H4(8),wf4(:,4),G2H1(1),m3h4x1(:,9),heltab2x4(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(1),n2h1(23))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(19),ex6(:),G2tensor(23),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(25),ex6(:),G2tensor(24),m3h2x1(:,20),heltab2x2(:,:,20))
call Hotf_4pt_reduction(G2H8(1),RedSet_4(23),mass4set(:,1),  & 
G1H8(15),G1H8(16),G1H8(20),G1H8(21),G1H8(2),8)
call HG1shiftOLR(G1H8(16),21,8)
call Hotf_4pt_reduction(G2H8(4),RedSet_4(5),mass4set(:,1),  & 
G1H8(5),G1H8(7),G1H8(8),G1H8(13),G1H8(18),8)
call HG1shiftOLR(G1H8(7),42,8)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(17),ex6(:),G2tensor(25),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(20),ex5(:),G2tensor(26),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(22),ex5(:),G2tensor(27),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(23),ex6(:),G2tensor(28),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hloop_AW_Q(ntryL,G1H4(9),wf4(:,4),G1H1(1),m3h4x1(:,10),heltab2x4(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(29),n2h1(24))
call Hotf_4pt_reduction(G2H4(2),RedSet_4(19),mass4set(:,2),  & 
G1H4(12),G1H4(13),G1H4(9),G1H4(39),G1H4(40),4)
call HG1shiftOLR(G1H4(13),10,4)
  call Hloop_AW_Q(ntryL,G2H4(15),wf4(:,4),G2H1(1),m3h4x1(:,11),heltab2x4(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(2),n2h1(25))
  call Hloop_AW_Q(ntryL,G1H4(11),wf4(:,4),G1H1(1),m3h4x1(:,12),heltab2x4(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(30),n2h1(26))
call Hotf_4pt_reduction(G2H4(13),RedSet_4(19),mass4set(:,1),  & 
G1H4(11),G1H4(41),G1H4(42),G1H4(43),G1H4(44),4)
call HG1shiftOLR(G1H4(41),10,4)
  call Hloop_QW_A(ntryL,G2H4(4),wf4(:,4),G2H1(1),m3h4x1(:,13),heltab2x4(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(3),n2h1(27))
  call Hloop_QW_A(ntryL,G1H4(15),wf4(:,4),G1H1(1),m3h4x1(:,14),heltab2x4(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(31),n2h1(28))
call Hotf_4pt_reduction(G2H4(6),RedSet_4(19),mass4set(:,3),  & 
G1H4(15),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
call HG1shiftOLR(G1H4(45),10,4)
  call Hloop_QW_A(ntryL,G2H4(5),wf4(:,4),G2H1(1),m3h4x1(:,15),heltab2x4(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(4),n2h1(29))
  call Hloop_QW_A(ntryL,G1H4(16),wf4(:,4),G1H1(1),m3h4x1(:,16),heltab2x4(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(32),n2h1(30))
call Hotf_4pt_reduction(G2H4(7),RedSet_4(3),mass4set(:,1),  & 
G1H4(16),G1H4(49),G1H4(50),G1H4(51),G1H4(52),4)
call HG1shiftOLR(G1H4(49),48,4)
  call Hloop_AV_Q(ntryL,G2H4(24),wf4(:,9),G2H1(1),m3h4x1(:,17),heltab2x4(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(5),n2h1(31))
  call Hloop_AV_Q(ntryL,G1H4(17),wf4(:,9),G1H1(1),m3h4x1(:,18),heltab2x4(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(33),n2h1(32))
call Hotf_4pt_reduction(G2H4(25),RedSet_4(3),mass4set(:,4),  & 
G1H4(17),G1H4(53),G1H4(54),G1H4(55),G1H4(56),4)
call HG1shiftOLR(G1H4(53),48,4)
  call Hloop_AV_Q(ntryL,G2H4(28),wf4(:,9),G2H1(1),m3h4x1(:,19),heltab2x4(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(6),n2h1(33))
  call Hloop_AV_Q(ntryL,G1H4(18),wf4(:,9),G1H1(1),m3h4x1(:,20),heltab2x4(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(34),n2h1(34))
call Hotf_4pt_reduction(G2H4(29),RedSet_4(3),mass4set(:,1),  & 
G1H4(18),G1H4(57),G1H4(58),G1H4(59),G1H4(60),4)
call HG1shiftOLR(G1H4(57),48,4)
  call Hloop_QV_A(ntryL,G2H4(32),wf4(:,9),G2H1(1),m3h4x1(:,21),heltab2x4(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(7),n2h1(35))
  call Hloop_QV_A(ntryL,G1H4(19),wf4(:,9),G1H1(1),m3h4x1(:,22),heltab2x4(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(35),n2h1(36))
call Hotf_4pt_reduction(G2H4(33),RedSet_4(3),mass4set(:,5),  & 
G1H4(19),G1H4(61),G1H4(62),G1H4(63),G1H4(64),4)
call HG1shiftOLR(G1H4(61),48,4)
  call Hloop_QV_A(ntryL,G2H4(36),wf4(:,9),G2H1(1),m3h4x1(:,23),heltab2x4(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(8),n2h1(37))
  call Hloop_QV_A(ntryL,G1H4(20),wf4(:,9),G1H1(1),m3h4x1(:,24),heltab2x4(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(36),n2h1(38))
call Hotf_4pt_reduction(G2H4(37),RedSet_4(4),mass4set(:,1),  & 
G1H4(20),G1H4(65),G1H4(66),G1H4(67),G1H4(68),4)
call HG1shiftOLR(G1H4(65),48,4)
  call Hloop_QV_A(ntryL,G2H4(40),wf4(:,9),G2H1(1),m3h4x1(:,25),heltab2x4(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(9),n2h1(39))
  call Hloop_QV_A(ntryL,G1H4(21),wf4(:,9),G1H1(1),m3h4x1(:,26),heltab2x4(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(37),n2h1(40))
call Hotf_4pt_reduction(G2H4(41),RedSet_4(4),mass4set(:,4),  & 
G1H4(21),G1H4(69),G1H4(70),G1H4(71),G1H4(72),4)
call HG1shiftOLR(G1H4(69),48,4)
  call Hloop_QV_A(ntryL,G2H4(44),wf4(:,9),G2H1(1),m3h4x1(:,27),heltab2x4(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(10),n2h1(41))
  call Hloop_QV_A(ntryL,G1H4(22),wf4(:,9),G1H1(1),m3h4x1(:,28),heltab2x4(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(38),n2h1(42))
call Hotf_4pt_reduction(G2H4(45),RedSet_4(4),mass4set(:,1),  & 
G1H4(22),G1H4(73),G1H4(74),G1H4(75),G1H4(76),4)
call HG1shiftOLR(G1H4(73),48,4)
  call Hloop_AV_Q(ntryL,G2H4(48),wf4(:,9),G2H1(1),m3h4x1(:,29),heltab2x4(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(11),n2h1(43))
  call Hloop_AV_Q(ntryL,G1H4(23),wf4(:,9),G1H1(1),m3h4x1(:,30),heltab2x4(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(39),n2h1(44))
call Hotf_4pt_reduction(G2H4(49),RedSet_4(4),mass4set(:,5),  & 
G1H4(23),G1H4(77),G1H4(78),G1H4(79),G1H4(80),4)
call HG1shiftOLR(G1H4(77),48,4)
  call Hloop_AV_Q(ntryL,G2H4(52),wf4(:,9),G2H1(1),m3h4x1(:,31),heltab2x4(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(12),n2h1(45))
  call Hloop_AV_Q(ntryL,G1H4(24),wf4(:,9),G1H1(1),m3h4x1(:,32),heltab2x4(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(40),n2h1(46))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(6),wf8(:,2),G2tensor(41),m3h8x1(:,1),heltab2x8(:,:,31))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(2),wf8(:,2),G2tensor(42),m3h8x1(:,2),heltab2x8(:,:,32))
  call Hloop_VQ_A(ntryL,G1H2(13),ex5(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(43),n2h1(47))
  call Hloop_VQ_A(ntryL,G1H2(18),ex5(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(44),n2h1(48))
  call Hloop_VQ_A(ntryL,G1H2(17),ex5(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(45),n2h1(49))
  call Hloop_VA_Q(ntryL,G1H2(1),ex6(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(46),n2h1(50))
  call Hloop_VA_Q(ntryL,G1H2(2),ex6(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(47),n2h1(51))
  call Hloop_VA_Q(ntryL,G1H2(12),ex6(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(48),n2h1(52))
  call Hloop_VA_Q(ntryL,G1H2(5),ex6(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(49),n2h1(53))
  call Hloop_VA_Q(ntryL,G1H2(16),ex6(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(50),n2h1(54))
  call Hloop_VA_Q(ntryL,G1H2(4),ex6(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(51),n2h1(55))
  call Hloop_AW_Q(ntryL,G1H4(8),wf4(:,4),G1H1(1),m3h4x1(:,33),heltab2x4(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(52),n2h1(56))
  call Hloop_AW_Q(ntryL,G1H4(1),wf4(:,4),G1H1(1),m3h4x1(:,34),heltab2x4(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(53),n2h1(57))
  call Hloop_AW_Q(ntryL,G1H4(14),wf4(:,4),G1H1(1),m3h4x1(:,35),heltab2x4(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(54),n2h1(58))
  call Hloop_QW_A(ntryL,G1H4(26),wf4(:,4),G1H1(1),m3h4x1(:,36),heltab2x4(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(55),n2h1(59))
  call Hloop_QW_A(ntryL,G1H4(27),wf4(:,4),G1H1(1),m3h4x1(:,37),heltab2x4(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(56),n2h1(60))
  call Hloop_QW_A(ntryL,G1H4(30),wf4(:,4),G1H1(1),m3h4x1(:,38),heltab2x4(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(57),n2h1(61))
  call Hloop_VQ_A(ntryL,G1H2(15),ex5(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(58),n2h1(62))
  call Hloop_VQ_A(ntryL,G1H2(23),ex5(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(59),n2h1(63))
  call Hloop_VQ_A(ntryL,G1H2(26),ex5(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(60),n2h1(64))
  call Hloop_VQ_A(ntryL,G1H2(27),ex5(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(61),n2h1(65))
  call Hloop_VQ_A(ntryL,G1H2(28),ex5(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(62),n2h1(66))
  call Hloop_VQ_A(ntryL,G1H2(31),ex5(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(63),n2h1(67))
  call Hloop_VA_Q(ntryL,G1H2(9),ex6(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(64),n2h1(68))
  call Hloop_VA_Q(ntryL,G1H2(10),ex6(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(65),n2h1(69))
  call Hloop_VA_Q(ntryL,G1H2(33),ex6(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(66),n2h1(70))
  call Hloop_AW_Q(ntryL,G1H4(2),wf4(:,4),G1H1(1),m3h4x1(:,39),heltab2x4(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(67),n2h1(71))
  call Hloop_AW_Q(ntryL,G1H4(3),wf4(:,4),G1H1(1),m3h4x1(:,40),heltab2x4(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(68),n2h1(72))
  call Hloop_AW_Q(ntryL,G1H4(33),wf4(:,4),G1H1(1),m3h4x1(:,41),heltab2x4(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(69),n2h1(73))
  call Hloop_AW_Q(ntryL,G1H4(34),wf4(:,4),G1H1(1),m3h4x1(:,42),heltab2x4(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(70),n2h1(74))
  call Hloop_AW_Q(ntryL,G1H4(35),wf4(:,4),G1H1(1),m3h4x1(:,43),heltab2x4(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(71),n2h1(75))
  call Hloop_AW_Q(ntryL,G1H4(38),wf4(:,4),G1H1(1),m3h4x1(:,44),heltab2x4(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(72),n2h1(76))
  call Hloop_VQ_A(ntryL,G1H8(15),wf8(:,7),G1H1(1),m3h8x1(:,3),heltab2x8(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(73),n2h1(77))
  call Hloop_VQ_A(ntryL,G1H8(16),wf8(:,7),G1H1(1),m3h8x1(:,4),heltab2x8(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),21,0,G2tensor(74),n2h1(78))
  call Hloop_VQ_A(ntryL,G1H8(2),wf8(:,7),G1H1(1),m3h8x1(:,5),heltab2x8(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(75),n2h1(79))
  call Hloop_VA_Q(ntryL,G1H8(5),wf8(:,2),G1H1(1),m3h8x1(:,6),heltab2x8(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(76),n2h1(80))
  call Hloop_VA_Q(ntryL,G1H8(7),wf8(:,2),G1H1(1),m3h8x1(:,7),heltab2x8(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),42,0,G2tensor(77),n2h1(81))
  call Hloop_VA_Q(ntryL,G1H8(18),wf8(:,2),G1H1(1),m3h8x1(:,8),heltab2x8(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(78),n2h1(82))
  call Hloop_AW_Q(ntryL,G1H4(12),wf4(:,4),G1H1(1),m3h4x1(:,45),heltab2x4(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(79),n2h1(83))
  call Hloop_AW_Q(ntryL,G1H4(13),wf4(:,4),G1H1(1),m3h4x1(:,46),heltab2x4(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMT,G2tensor(80),n2h1(84))
  call Hloop_AW_Q(ntryL,G1H4(40),wf4(:,4),G1H1(1),m3h4x1(:,47),heltab2x4(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(81),n2h1(85))
  call Hloop_QW_A(ntryL,G1H4(11),wf4(:,4),G1H1(1),m3h4x1(:,48),heltab2x4(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(82),n2h1(86))
  call Hloop_QW_A(ntryL,G1H4(41),wf4(:,4),G1H1(1),m3h4x1(:,49),heltab2x4(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(83),n2h1(87))
  call Hloop_QW_A(ntryL,G1H4(44),wf4(:,4),G1H1(1),m3h4x1(:,50),heltab2x4(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(84),n2h1(88))
  call Hloop_QW_A(ntryL,G1H4(15),wf4(:,4),G1H1(1),m3h4x1(:,51),heltab2x4(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(85),n2h1(89))
  call Hloop_QW_A(ntryL,G1H4(45),wf4(:,4),G1H1(1),m3h4x1(:,52),heltab2x4(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(86),n2h1(90))
  call Hloop_QW_A(ntryL,G1H4(48),wf4(:,4),G1H1(1),m3h4x1(:,53),heltab2x4(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(87),n2h1(91))
  call Hloop_AV_Q(ntryL,G1H4(16),wf4(:,9),G1H1(1),m3h4x1(:,54),heltab2x4(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(88),n2h1(92))
  call Hloop_AV_Q(ntryL,G1H4(49),wf4(:,9),G1H1(1),m3h4x1(:,55),heltab2x4(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,0,G2tensor(89),n2h1(93))
  call Hloop_AV_Q(ntryL,G1H4(52),wf4(:,9),G1H1(1),m3h4x1(:,56),heltab2x4(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(90),n2h1(94))
  call Hloop_AV_Q(ntryL,G1H4(17),wf4(:,9),G1H1(1),m3h4x1(:,57),heltab2x4(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(91),n2h1(95))
  call Hloop_AV_Q(ntryL,G1H4(53),wf4(:,9),G1H1(1),m3h4x1(:,58),heltab2x4(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,nMT,G2tensor(92),n2h1(96))
  call Hloop_AV_Q(ntryL,G1H4(56),wf4(:,9),G1H1(1),m3h4x1(:,59),heltab2x4(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(93),n2h1(97))
  call Hloop_QV_A(ntryL,G1H4(18),wf4(:,9),G1H1(1),m3h4x1(:,60),heltab2x4(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(94),n2h1(98))
  call Hloop_QV_A(ntryL,G1H4(57),wf4(:,9),G1H1(1),m3h4x1(:,61),heltab2x4(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,0,G2tensor(95),n2h1(99))
  call Hloop_QV_A(ntryL,G1H4(60),wf4(:,9),G1H1(1),m3h4x1(:,62),heltab2x4(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(96),n2h1(100))
  call Hloop_QV_A(ntryL,G1H4(19),wf4(:,9),G1H1(1),m3h4x1(:,63),heltab2x4(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(97),n2h1(101))
  call Hloop_QV_A(ntryL,G1H4(61),wf4(:,9),G1H1(1),m3h4x1(:,64),heltab2x4(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,nMB,G2tensor(98),n2h1(102))
  call Hloop_QV_A(ntryL,G1H4(64),wf4(:,9),G1H1(1),m3h4x1(:,65),heltab2x4(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(99),n2h1(103))
  call Hloop_QV_A(ntryL,G1H4(20),wf4(:,9),G1H1(1),m3h4x1(:,66),heltab2x4(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(100),n2h1(104))
  call Hloop_QV_A(ntryL,G1H4(65),wf4(:,9),G1H1(1),m3h4x1(:,67),heltab2x4(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,0,G2tensor(101),n2h1(105))
  call Hloop_QV_A(ntryL,G1H4(68),wf4(:,9),G1H1(1),m3h4x1(:,68),heltab2x4(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(102),n2h1(106))
  call Hloop_QV_A(ntryL,G1H4(21),wf4(:,9),G1H1(1),m3h4x1(:,69),heltab2x4(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(103),n2h1(107))
  call Hloop_QV_A(ntryL,G1H4(69),wf4(:,9),G1H1(1),m3h4x1(:,70),heltab2x4(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,nMT,G2tensor(104),n2h1(108))
  call Hloop_QV_A(ntryL,G1H4(72),wf4(:,9),G1H1(1),m3h4x1(:,71),heltab2x4(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(105),n2h1(109))
  call Hloop_AV_Q(ntryL,G1H4(22),wf4(:,9),G1H1(1),m3h4x1(:,72),heltab2x4(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(106),n2h1(110))
  call Hloop_AV_Q(ntryL,G1H4(73),wf4(:,9),G1H1(1),m3h4x1(:,73),heltab2x4(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,0,G2tensor(107),n2h1(111))
  call Hloop_AV_Q(ntryL,G1H4(76),wf4(:,9),G1H1(1),m3h4x1(:,74),heltab2x4(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(108),n2h1(112))
  call Hloop_AV_Q(ntryL,G1H4(23),wf4(:,9),G1H1(1),m3h4x1(:,75),heltab2x4(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(109),n2h1(113))
  call Hloop_AV_Q(ntryL,G1H4(77),wf4(:,9),G1H1(1),m3h4x1(:,76),heltab2x4(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,nMB,G2tensor(110),n2h1(114))
  call Hloop_AV_Q(ntryL,G1H4(80),wf4(:,9),G1H1(1),m3h4x1(:,77),heltab2x4(:,:,87))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(111),n2h1(115))
  call ol_merge_tensors(G2tensor(41),[G2tensor(2),G1tensor(6)])
  call ol_merge_tensors(G2tensor(25),[G2tensor(4),G1tensor(8),G1tensor(3)])
  call ol_merge_tensors(G2tensor(94),[G2tensor(88),G2tensor(5),G1tensor(12)])
  call ol_merge_tensors(G2tensor(26),[G2tensor(8),G1tensor(14)])
  call ol_merge_tensors(G2tensor(106),[G2tensor(100),G2tensor(9),G1tensor(18)])
  call ol_merge_tensors(G2tensor(49),[G2tensor(12),G1tensor(20),G1tensor(15)])
  call ol_merge_tensors(G2tensor(76),[G2tensor(13),G1tensor(24)])
  call ol_merge_tensors(G2tensor(55),[G1tensor(2)])
  call ol_merge_tensors(G2tensor(28),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(5)])
  call ol_merge_tensors(G2tensor(58),[G1tensor(9)])
  call ol_merge_tensors(G2tensor(61),[G1tensor(10)])
  call ol_merge_tensors(G2tensor(43),[G1tensor(11)])
  call ol_merge_tensors(G2tensor(64),[G1tensor(16)])
  call ol_merge_tensors(G2tensor(46),[G1tensor(17)])
  call ol_merge_tensors(G2tensor(67),[G1tensor(21)])
  call ol_merge_tensors(G2tensor(70),[G1tensor(22)])
  call ol_merge_tensors(G2tensor(82),[G2tensor(52),G1tensor(23)])
  call ol_merge_tensors(G2tensor(31),[G2tensor(29)])
  call ol_merge_tensors(G2tensor(35),[G2tensor(33)])
  call ol_merge_tensors(G2tensor(39),[G2tensor(37)])
call Hotf_4pt_reduction_last(G2tensor(41),RedSet_4(2),mass4set(:,1),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(6))
call G_TensorShift(G1tensor(7),42)
call Hotf_4pt_reduction_last(G2tensor(25),RedSet_4(6),mass4set(:,1),  & 
G1tensor(8),G1tensor(3),G1tensor(12),G1tensor(14),G1tensor(18))
call G_TensorShift(G1tensor(3),32)
call Hotf_4pt_reduction_last(G2tensor(94),RedSet_4(3),mass4set(:,1),  & 
G1tensor(20),G1tensor(15),G1tensor(24),G1tensor(2),G1tensor(4))
call G_TensorShift(G1tensor(15),48)
call Hotf_4pt_reduction_last(G2tensor(26),RedSet_4(21),mass4set(:,1),  & 
G1tensor(5),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(16))
call G_TensorShift(G1tensor(9),16)
call Hotf_4pt_reduction_last(G2tensor(106),RedSet_4(4),mass4set(:,1),  & 
G1tensor(17),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(25))
call G_TensorShift(G1tensor(21),48)
call Hotf_4pt_reduction_last(G2tensor(49),RedSet_4(13),mass4set(:,1),  & 
G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
call G_TensorShift(G1tensor(27),32)
call Hotf_4pt_reduction_last(G2tensor(76),RedSet_4(5),mass4set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35))
call G_TensorShift(G1tensor(32),42)
call Hotf_4pt_reduction_last(G2tensor(55),RedSet_4(22),mass4set(:,1),  & 
G1tensor(36),G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40))
call G_TensorShift(G1tensor(37),10)
call Hotf_4pt_reduction_last(G2tensor(28),RedSet_4(7),mass4set(:,1),  & 
G1tensor(41),G1tensor(42),G1tensor(43),G1tensor(44),G1tensor(45))
call G_TensorShift(G1tensor(42),32)
call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,1),  & 
G1tensor(46),G1tensor(47),G1tensor(48),G1tensor(49),G1tensor(50))
call G_TensorShift(G1tensor(47),32)
call Hotf_4pt_reduction_last(G2tensor(58),RedSet_4(9),mass4set(:,1),  & 
G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54),G1tensor(55))
call G_TensorShift(G1tensor(52),16)
call Hotf_4pt_reduction_last(G2tensor(61),RedSet_4(10),mass4set(:,1),  & 
G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
call G_TensorShift(G1tensor(57),16)
call Hotf_4pt_reduction_last(G2tensor(43),RedSet_4(11),mass4set(:,1),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65))
call G_TensorShift(G1tensor(62),16)
call Hotf_4pt_reduction_last(G2tensor(64),RedSet_4(14),mass4set(:,1),  & 
G1tensor(66),G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70))
call G_TensorShift(G1tensor(67),32)
call Hotf_4pt_reduction_last(G2tensor(46),RedSet_4(15),mass4set(:,1),  & 
G1tensor(71),G1tensor(72),G1tensor(73),G1tensor(74),G1tensor(75))
call G_TensorShift(G1tensor(72),32)
call Hotf_4pt_reduction_last(G2tensor(67),RedSet_4(17),mass4set(:,1),  & 
G1tensor(76),G1tensor(77),G1tensor(78),G1tensor(79),G1tensor(80))
call G_TensorShift(G1tensor(77),10)
call Hotf_4pt_reduction_last(G2tensor(70),RedSet_4(18),mass4set(:,1),  & 
G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84),G1tensor(85))
call G_TensorShift(G1tensor(82),10)
call Hotf_4pt_reduction_last(G2tensor(82),RedSet_4(19),mass4set(:,1),  & 
G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
call G_TensorShift(G1tensor(87),10)
call Hotf_4pt_reduction_last(G2tensor(31),RedSet_4(19),mass4set(:,1),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G0tensor(1))
call G_TensorShift(G1tensor(92),10)
call Hotf_4pt_reduction_last(G2tensor(30),RedSet_4(19),mass4set(:,2),  & 
G1tensor(91),G1tensor(96),G1tensor(97),G1tensor(98),G1tensor(99),G0tensor(2))
call G_TensorShift(G1tensor(96),10)
call Hotf_4pt_reduction_last(G2tensor(32),RedSet_4(19),mass4set(:,3),  & 
G1tensor(91),G1tensor(100),G1tensor(101),G1tensor(102),G1tensor(103),G0tensor(3))
call G_TensorShift(G1tensor(100),10)
call Hotf_4pt_reduction_last(G2tensor(35),RedSet_4(3),mass4set(:,1),  & 
G1tensor(91),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G0tensor(4))
call G_TensorShift(G1tensor(104),48)
call Hotf_4pt_reduction_last(G2tensor(34),RedSet_4(3),mass4set(:,4),  & 
G1tensor(91),G1tensor(108),G1tensor(109),G1tensor(110),G1tensor(111),G0tensor(5))
call G_TensorShift(G1tensor(108),48)
call Hotf_4pt_reduction_last(G2tensor(36),RedSet_4(3),mass4set(:,5),  & 
G1tensor(91),G1tensor(112),G1tensor(113),G1tensor(114),G1tensor(115),G0tensor(6))
call G_TensorShift(G1tensor(112),48)
call Hotf_4pt_reduction_last(G2tensor(39),RedSet_4(4),mass4set(:,1),  & 
G1tensor(91),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G0tensor(7))
call G_TensorShift(G1tensor(116),48)
call Hotf_4pt_reduction_last(G2tensor(38),RedSet_4(4),mass4set(:,4),  & 
G1tensor(91),G1tensor(120),G1tensor(121),G1tensor(122),G1tensor(123),G0tensor(8))
call G_TensorShift(G1tensor(120),48)
call Hotf_4pt_reduction_last(G2tensor(40),RedSet_4(4),mass4set(:,5),  & 
G1tensor(91),G1tensor(124),G1tensor(125),G1tensor(126),G1tensor(127),G0tensor(9))
call G_TensorShift(G1tensor(124),48)
call Hotf_4pt_reduction_last(G2tensor(73),RedSet_4(23),mass4set(:,1),  & 
G1tensor(91),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131))
call G_TensorShift(G1tensor(128),21)
call Hotf_4pt_reduction_last(G2tensor(79),RedSet_4(19),mass4set(:,2),  & 
G1tensor(132),G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136))
call G_TensorShift(G1tensor(133),10)
call Hotf_4pt_reduction_last(G2tensor(85),RedSet_4(19),mass4set(:,3),  & 
G1tensor(137),G1tensor(138),G1tensor(139),G1tensor(140),G1tensor(141))
call G_TensorShift(G1tensor(138),10)
call Hotf_4pt_reduction_last(G2tensor(91),RedSet_4(3),mass4set(:,4),  & 
G1tensor(142),G1tensor(143),G1tensor(144),G1tensor(145),G1tensor(146))
call G_TensorShift(G1tensor(143),48)
call Hotf_4pt_reduction_last(G2tensor(97),RedSet_4(3),mass4set(:,5),  & 
G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150),G1tensor(151))
call G_TensorShift(G1tensor(148),48)
call Hotf_4pt_reduction_last(G2tensor(103),RedSet_4(4),mass4set(:,4),  & 
G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
call G_TensorShift(G1tensor(153),48)
call Hotf_4pt_reduction_last(G2tensor(109),RedSet_4(4),mass4set(:,5),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161))
call G_TensorShift(G1tensor(158),48)
call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(2),mass4set(:,1),  & 
G0tensor(10),G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14))
call Hotf_4pt_reduction_last(G1tensor(8),RedSet_4(6),mass4set(:,1),  & 
G0tensor(15),G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19))
call Hotf_4pt_reduction_last(G1tensor(20),RedSet_4(3),mass4set(:,1),  & 
G0tensor(20),G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24))
call Hotf_4pt_reduction_last(G1tensor(5),RedSet_4(21),mass4set(:,1),  & 
G0tensor(25),G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29))
call Hotf_4pt_reduction_last(G1tensor(17),RedSet_4(4),mass4set(:,1),  & 
G0tensor(30),G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34))
call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(13),mass4set(:,1),  & 
G0tensor(35),G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39))
call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(5),mass4set(:,1),  & 
G0tensor(40),G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44))
call Hotf_4pt_reduction_last(G1tensor(36),RedSet_4(22),mass4set(:,1),  & 
G0tensor(45),G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49))
call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(7),mass4set(:,1),  & 
G0tensor(50),G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54))
call Hotf_4pt_reduction_last(G1tensor(46),RedSet_4(1),mass4set(:,1),  & 
G0tensor(55),G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59))
call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(9),mass4set(:,1),  & 
G0tensor(60),G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64))
call Hotf_4pt_reduction_last(G1tensor(56),RedSet_4(10),mass4set(:,1),  & 
G0tensor(65),G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69))
call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(11),mass4set(:,1),  & 
G0tensor(70),G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74))
call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(14),mass4set(:,1),  & 
G0tensor(75),G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79))
call Hotf_4pt_reduction_last(G1tensor(71),RedSet_4(15),mass4set(:,1),  & 
G0tensor(80),G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84))
call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(17),mass4set(:,1),  & 
G0tensor(85),G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89))
call Hotf_4pt_reduction_last(G1tensor(81),RedSet_4(18),mass4set(:,1),  & 
G0tensor(90),G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94))
call Hotf_4pt_reduction_last(G1tensor(86),RedSet_4(19),mass4set(:,1),  & 
G0tensor(95),G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99))
call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(23),mass4set(:,1),  & 
G0tensor(100),G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104))
call Hotf_4pt_reduction_last(G1tensor(132),RedSet_4(19),mass4set(:,2),  & 
G0tensor(105),G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109))
call Hotf_4pt_reduction_last(G1tensor(137),RedSet_4(19),mass4set(:,3),  & 
G0tensor(110),G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114))
call Hotf_4pt_reduction_last(G1tensor(142),RedSet_4(3),mass4set(:,4),  & 
G0tensor(115),G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119))
call Hotf_4pt_reduction_last(G1tensor(147),RedSet_4(3),mass4set(:,5),  & 
G0tensor(120),G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124))
call Hotf_4pt_reduction_last(G1tensor(152),RedSet_4(4),mass4set(:,4),  & 
G0tensor(125),G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129))
call Hotf_4pt_reduction_last(G1tensor(157),RedSet_4(4),mass4set(:,5),  & 
G0tensor(130),G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134))
call ol_merge_tensors(T0sum(1),[G0tensor(10)])
call ol_merge_tensors(T0sum(2),[G0tensor(15)])
call ol_merge_tensors(T0sum(3),[G0tensor(20)])
call ol_merge_tensors(T0sum(4),[G0tensor(25)])
call ol_merge_tensors(T0sum(5),[G0tensor(30)])
call ol_merge_tensors(T0sum(6),[G0tensor(35)])
call ol_merge_tensors(T0sum(7),[G0tensor(40)])
call ol_merge_tensors(T0sum(8),[G0tensor(45)])
call ol_merge_tensors(T0sum(9),[G0tensor(50)])
call ol_merge_tensors(T0sum(10),[G0tensor(55)])
call ol_merge_tensors(T0sum(11),[G0tensor(60)])
call ol_merge_tensors(T0sum(12),[G0tensor(65)])
call ol_merge_tensors(T0sum(13),[G0tensor(70)])
call ol_merge_tensors(T0sum(14),[G0tensor(75)])
call ol_merge_tensors(T0sum(15),[G0tensor(80)])
call ol_merge_tensors(T0sum(16),[G0tensor(85)])
call ol_merge_tensors(T0sum(17),[G0tensor(90)])
call ol_merge_tensors(T0sum(18),[G0tensor(95)])
call ol_merge_tensors(T0sum(19),[G0tensor(1)])
call ol_merge_tensors(T0sum(20),[G0tensor(2)])
call ol_merge_tensors(T0sum(21),[G0tensor(3)])
call ol_merge_tensors(T0sum(22),[G0tensor(4)])
call ol_merge_tensors(T0sum(23),[G0tensor(5)])
call ol_merge_tensors(T0sum(24),[G0tensor(6)])
call ol_merge_tensors(T0sum(25),[G0tensor(7)])
call ol_merge_tensors(T0sum(26),[G0tensor(8)])
call ol_merge_tensors(T0sum(27),[G0tensor(9)])
call ol_merge_tensors(T0sum(28),[G0tensor(100)])
call ol_merge_tensors(T0sum(29),[G0tensor(105)])
call ol_merge_tensors(T0sum(30),[G0tensor(110)])
call ol_merge_tensors(T0sum(31),[G0tensor(115)])
call ol_merge_tensors(T0sum(32),[G0tensor(120)])
call ol_merge_tensors(T0sum(33),[G0tensor(125)])
call ol_merge_tensors(T0sum(34),[G0tensor(130)])
Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(49)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(49),h0tab(:,49),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,11),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,47),heltab2x128(:,:,49))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(1),n2h64(36))
Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(49)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(50),h0tab(:,50),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,11),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,48),heltab2x128(:,:,50))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(2),n2h64(37))
Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(49)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(51),h0tab(:,51),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,11),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,49),heltab2x128(:,:,51))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(3),n2h64(38))
Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(49)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(52),h0tab(:,52),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,11),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,50),heltab2x128(:,:,52))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(4),n2h64(39))
Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(130)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(53),h0tab(:,53),[64,15,48],[0,0,0],3,2,wf16(:,2),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,51),heltab2x128(:,:,53))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(5),n2h64(40))
Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(130)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(54),h0tab(:,54),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,2),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,52),heltab2x128(:,:,54))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(6),n2h64(41))
Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(130)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(55),h0tab(:,55),[64,15,48],[0,0,0],3,2,wf16(:,2),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,53),heltab2x128(:,:,55))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(7),n2h64(42))
Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(130)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(56),h0tab(:,56),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,2),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,54),heltab2x128(:,:,56))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(8),n2h64(43))
Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(130)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(57),h0tab(:,57),[64,15,48],[0,0,0],3,2,wf16(:,2),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,55),heltab2x128(:,:,57))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(9),n2h64(44))
Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(130)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(58),h0tab(:,58),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,2),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,56),heltab2x128(:,:,58))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(10),n2h64(45))
Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(130)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(59),h0tab(:,59),[64,15,48],[0,0,0],3,2,wf16(:,2),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,57),heltab2x128(:,:,59))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(11),n2h64(46))
Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(130)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(60),h0tab(:,60),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,2),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,58),heltab2x128(:,:,60))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(12),n2h64(47))
Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(52)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(61),h0tab(:,61),[64,15,48],[0,0,0],3,2,wf16(:,12),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,59),heltab2x128(:,:,61))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(13),n2h64(48))
Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(52)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(62),h0tab(:,62),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,12),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,60),heltab2x128(:,:,62))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(14),n2h64(49))
Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(52)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(63),h0tab(:,63),[64,15,48],[0,0,0],3,2,wf16(:,12),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,61),heltab2x128(:,:,63))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(15),n2h64(50))
Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(52)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(64),h0tab(:,64),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,12),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,62),heltab2x128(:,:,64))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(16),n2h64(51))
Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(52)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(65),h0tab(:,65),[64,15,48],[0,0,0],3,2,wf16(:,12),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,63),heltab2x128(:,:,65))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(17),n2h64(52))
Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(52)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(66),h0tab(:,66),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,12),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,64),heltab2x128(:,:,66))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(18),n2h64(53))
Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(52)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(67),h0tab(:,67),[64,15,48],[0,0,0],3,2,wf16(:,12),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,65),heltab2x128(:,:,67))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(19),n2h64(54))
Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(52)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(68),h0tab(:,68),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,12),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,66),heltab2x128(:,:,68))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(20),n2h64(55))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(132)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(69),h0tab(:,69),[80,5,42],[0,0,0],3,3,wf4(:,6),wf4(:,5),wf8(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,6),G0H32(1),m3h4x32(:,3),heltab2x128(:,:,69))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(3),n2h32(23))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(55)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(70),h0tab(:,70),[80,15,32],[0,0,0],3,2,wf4(:,6),wf16(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,6),G0H32(1),m3h4x32(:,4),heltab2x128(:,:,70))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(1),n2h32(24))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(56)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(71),h0tab(:,71),[80,15,32],[0,0,0],3,2,wf4(:,6),wf16(:,12))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,6),G0H32(1),m3h4x32(:,5),heltab2x128(:,:,71))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(4),n2h32(25))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(59)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(72),h0tab(:,72),[85,10,32],[0,0,0],3,2,wf16(:,16),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,16),G0H8(1),m3h16x8(:,1),heltab2x128(:,:,72))
  call Hloop_Q_A(ntryL,G0H8(1),85,0,G1H8(17),n2h8(18))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(134)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(73),h0tab(:,73),[96,10,21],[0,0,0],3,3,wf4(:,8),wf4(:,4),wf8(:,7))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(1),m3h4x32(:,6),heltab2x128(:,:,73))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(5),n2h32(26))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(60)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(74),h0tab(:,74),[96,15,16],[0,0,0],3,2,wf4(:,8),wf16(:,2))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(1),m3h4x32(:,7),heltab2x128(:,:,74))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(6),n2h32(27))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(61)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(75),h0tab(:,75),[96,15,16],[0,0,0],3,2,wf4(:,8),wf16(:,12))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(1),m3h4x32(:,8),heltab2x128(:,:,75))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(7),n2h32(28))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(64)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(76),h0tab(:,76),[106,5,16],[0,0,0],3,2,wf16(:,18),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,18),G0H8(1),m3h16x8(:,2),heltab2x128(:,:,76))
  call Hloop_A_Q(ntryL,G0H8(1),106,0,G1H8(19),n2h8(19))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(24)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(77),h0tab(:,77),[64,21,42],[0,0,0],3,2,wf8(:,7),wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,67),heltab2x128(:,:,77))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(21),n2h64(56))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(24)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(78),h0tab(:,78),[64,21,42],[0,0,0],3,2,wf8(:,7),wf8(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(22),m3h2x64(:,68),heltab2x128(:,:,78))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(136)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(79),h0tab(:,79),[85,10,32],[0,0,0],3,2,wf16(:,26),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,26),G0H8(1),m3h16x8(:,3),heltab2x128(:,:,79))
  call Hloop_Q_A(ntryL,G0H8(1),85,0,G1H8(22),n2h8(20))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(109)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(80),h0tab(:,80),[64,31,32],[0,0,0],3,1,wf32(:,3))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,69),heltab2x128(:,:,80))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(23),n2h64(57))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(109)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(81),h0tab(:,81),[64,31,32],[0,0,0],3,1,wf32(:,3))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(24),m3h2x64(:,70),heltab2x128(:,:,81))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(137)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(82),h0tab(:,82),[106,5,16],[0,0,0],3,2,wf16(:,25),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,25),G0H8(1),m3h16x8(:,4),heltab2x128(:,:,82))
  call Hloop_A_Q(ntryL,G0H8(1),106,0,G1H8(11),n2h8(21))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(112)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(83),h0tab(:,83),[64,16,47],[0,0,0],3,1,wf32(:,5))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,71),heltab2x128(:,:,83))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(25),n2h64(58))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(112)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(84),h0tab(:,84),[64,16,47],[0,0,0],3,1,wf32(:,5))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(26),m3h2x64(:,72),heltab2x128(:,:,84))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(113)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(85),h0tab(:,85),[64,31,32],[0,0,0],3,1,wf32(:,7))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,73),heltab2x128(:,:,85))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(27),n2h64(59))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(114)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(86),h0tab(:,86),[64,31,32],[0,0,0],3,1,wf32(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,74),heltab2x128(:,:,86))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(28),n2h64(60))
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(113)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(87),h0tab(:,87),[64,31,32],[0,0,0],3,1,wf32(:,7))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(29),m3h2x64(:,75),heltab2x128(:,:,87))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(114)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(88),h0tab(:,88),[64,31,32],[0,0,0],3,1,wf32(:,9))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(30),m3h2x64(:,76),heltab2x128(:,:,88))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(115)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(89),h0tab(:,89),[64,16,47],[0,0,0],3,1,wf32(:,11))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,77),heltab2x128(:,:,89))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(31),n2h64(61))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(116)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(90),h0tab(:,90),[64,16,47],[0,0,0],3,1,wf32(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,78),heltab2x128(:,:,90))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(32),n2h64(62))
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(115)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(91),h0tab(:,91),[64,16,47],[0,0,0],3,1,wf32(:,11))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(33),m3h2x64(:,79),heltab2x128(:,:,91))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(116)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(92),h0tab(:,92),[64,16,47],[0,0,0],3,1,wf32(:,13))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(34),m3h2x64(:,80),heltab2x128(:,:,92))
Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(138)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(93),h0tab(:,93),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,21),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,81),heltab2x128(:,:,93))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(35),n2h64(63))
Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(138)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(94),h0tab(:,94),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,21),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,82),heltab2x128(:,:,94))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(36),n2h64(64))
Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(138)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(95),h0tab(:,95),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,21),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,83),heltab2x128(:,:,95))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(37),n2h64(65))
Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(138)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(96),h0tab(:,96),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,21),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,84),heltab2x128(:,:,96))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(38),n2h64(66))
Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(139)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(97),h0tab(:,97),[64,15,48],[0,0,0],3,2,wf16(:,5),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,85),heltab2x128(:,:,97))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(39),n2h64(67))
Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(139)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(98),h0tab(:,98),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,5),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,86),heltab2x128(:,:,98))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(40),n2h64(68))
Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(139)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(99),h0tab(:,99),[64,15,48],[0,0,0],3,2,wf16(:,5),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,87),heltab2x128(:,:,99))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(41),n2h64(69))
Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(139)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(100),h0tab(:,100),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,5),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,88),heltab2x128(:,:,100))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(42),n2h64(70))
Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(139)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(101),h0tab(:,101),[64,15,48],[0,0,0],3,2,wf16(:,5),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,89),heltab2x128(:,:,101))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(43),n2h64(71))
Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(139)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(102),h0tab(:,102),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,5),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,90),heltab2x128(:,:,102))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(44),n2h64(72))
Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(139)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(103),h0tab(:,103),[64,15,48],[0,0,0],3,2,wf16(:,5),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,91),heltab2x128(:,:,103))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(45),n2h64(73))
Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(139)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(104),h0tab(:,104),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,5),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,92),heltab2x128(:,:,104))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(46),n2h64(74))
Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(140)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(105),h0tab(:,105),[64,15,48],[0,0,0],3,2,wf16(:,27),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,93),heltab2x128(:,:,105))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(47),n2h64(75))
Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(140)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(106),h0tab(:,106),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,27),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,94),heltab2x128(:,:,106))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(48),n2h64(76))
Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(140)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(107),h0tab(:,107),[64,15,48],[0,0,0],3,2,wf16(:,27),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,95),heltab2x128(:,:,107))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(49),n2h64(77))
Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(140)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(108),h0tab(:,108),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,27),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,96),heltab2x128(:,:,108))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(50),n2h64(78))
Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(140)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(109),h0tab(:,109),[64,15,48],[0,0,0],3,2,wf16(:,27),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,97),heltab2x128(:,:,109))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(51),n2h64(79))
Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(140)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(110),h0tab(:,110),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,27),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,98),heltab2x128(:,:,110))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(52),n2h64(80))
Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(140)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(111),h0tab(:,111),[64,15,48],[0,0,0],3,2,wf16(:,27),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,99),heltab2x128(:,:,111))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(53),n2h64(81))
Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(140)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(112),h0tab(:,112),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,27),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,100),heltab2x128(:,:,112))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(54),n2h64(82))
Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(141)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(113),h0tab(:,113),[64,15,48],[0,0,0],3,2,wf16(:,28),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,101),heltab2x128(:,:,113))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(55),n2h64(83))
Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(141)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(114),h0tab(:,114),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,28),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,102),heltab2x128(:,:,114))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(56),n2h64(84))
Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(141)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(115),h0tab(:,115),[64,15,48],[0,0,0],3,2,wf16(:,28),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,103),heltab2x128(:,:,115))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(57),n2h64(85))
Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(141)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(116),h0tab(:,116),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,28),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,104),heltab2x128(:,:,116))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(58),n2h64(86))
Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(141)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(117),h0tab(:,117),[64,15,48],[0,0,0],3,2,wf16(:,28),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,105),heltab2x128(:,:,117))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(59),n2h64(87))
Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(141)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(118),h0tab(:,118),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,28),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,106),heltab2x128(:,:,118))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(60),n2h64(88))
Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(141)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(119),h0tab(:,119),[64,15,48],[0,0,0],3,2,wf16(:,28),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,107),heltab2x128(:,:,119))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(61),n2h64(89))
Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(141)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(120),h0tab(:,120),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,28),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,108),heltab2x128(:,:,120))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(62),n2h64(90))
Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(142)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(121),h0tab(:,121),[80,15,32],[0,0,0],3,2,wf4(:,6),wf16(:,5))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,6),G0H32(1),m3h4x32(:,9),heltab2x128(:,:,121))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(9),n2h32(29))
Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(143)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(122),h0tab(:,122),[80,15,32],[0,0,0],3,2,wf4(:,6),wf16(:,27))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,6),G0H32(1),m3h4x32(:,10),heltab2x128(:,:,122))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(10),n2h32(30))
Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(144)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(123),h0tab(:,123),[80,15,32],[0,0,0],3,2,wf4(:,6),wf16(:,28))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,6),G0H32(1),m3h4x32(:,11),heltab2x128(:,:,123))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(11),n2h32(31))
Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(145)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(124),h0tab(:,124),[96,15,16],[0,0,0],3,2,wf4(:,8),wf16(:,5))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(1),m3h4x32(:,12),heltab2x128(:,:,124))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(12),n2h32(32))
Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(146)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(125),h0tab(:,125),[96,15,16],[0,0,0],3,2,wf4(:,8),wf16(:,27))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(1),m3h4x32(:,13),heltab2x128(:,:,125))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(14),n2h32(33))
Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(147)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(126),h0tab(:,126),[96,15,16],[0,0,0],3,2,wf4(:,8),wf16(:,28))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(1),m3h4x32(:,14),heltab2x128(:,:,126))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(15),n2h32(34))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(118)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(127),h0tab(:,127),[64,31,32],[0,0,0],3,1,wf32(:,15))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,109),heltab2x128(:,:,127))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(63),n2h64(91))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(119)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(128),h0tab(:,128),[64,31,32],[0,0,0],3,1,wf32(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,110),heltab2x128(:,:,128))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(64),n2h64(92))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(118)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(129),h0tab(:,129),[64,31,32],[0,0,0],3,1,wf32(:,15))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(65),m3h2x64(:,111),heltab2x128(:,:,129))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(119)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(130),h0tab(:,130),[64,31,32],[0,0,0],3,1,wf32(:,17))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(66),m3h2x64(:,112),heltab2x128(:,:,130))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(120)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(131),h0tab(:,131),[64,16,47],[0,0,0],3,1,wf32(:,19))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,113),heltab2x128(:,:,131))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(67),n2h64(93))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(121)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(132),h0tab(:,132),[64,16,47],[0,0,0],3,1,wf32(:,21))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,114),heltab2x128(:,:,132))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(68),n2h64(94))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(120)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(133),h0tab(:,133),[64,16,47],[0,0,0],3,1,wf32(:,19))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(69),m3h2x64(:,115),heltab2x128(:,:,133))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(121)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(134),h0tab(:,134),[64,16,47],[0,0,0],3,1,wf32(:,21))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(70),m3h2x64(:,116),heltab2x128(:,:,134))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(122)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(135),h0tab(:,135),[64,31,32],[0,0,0],3,1,wf32(:,23))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,117),heltab2x128(:,:,135))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(71),n2h64(95))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(122)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(136),h0tab(:,136),[64,31,32],[0,0,0],3,1,wf32(:,23))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(72),m3h2x64(:,118),heltab2x128(:,:,136))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(123)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(137),h0tab(:,137),[64,16,47],[0,0,0],3,1,wf32(:,25))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,119),heltab2x128(:,:,137))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(73),n2h64(96))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(123)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(138),h0tab(:,138),[64,16,47],[0,0,0],3,1,wf32(:,25))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(74),m3h2x64(:,120),heltab2x128(:,:,138))
Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(148)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(139),h0tab(:,139),[64,15,48],[0,0,0],3,2,wf16(:,8),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,121),heltab2x128(:,:,139))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(75),n2h64(97))
Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(148)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(140),h0tab(:,140),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,8),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,122),heltab2x128(:,:,140))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(76),n2h64(98))
Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(148)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(141),h0tab(:,141),[64,15,48],[0,0,0],3,2,wf16(:,8),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,123),heltab2x128(:,:,141))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(77),n2h64(99))
Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(148)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(142),h0tab(:,142),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,8),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,124),heltab2x128(:,:,142))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(78),n2h64(100))
Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(148)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(143),h0tab(:,143),[64,15,48],[0,0,0],3,2,wf16(:,8),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,125),heltab2x128(:,:,143))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(79),n2h64(101))
Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(148)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(144),h0tab(:,144),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,8),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,126),heltab2x128(:,:,144))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(80),n2h64(102))
Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(148)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(145),h0tab(:,145),[64,15,48],[0,0,0],3,2,wf16(:,8),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,127),heltab2x128(:,:,145))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(81),n2h64(103))
Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(148)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(146),h0tab(:,146),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,8),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,128),heltab2x128(:,:,146))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(82),n2h64(104))
Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(149)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(147),h0tab(:,147),[64,15,48],[0,0,0],3,2,wf16(:,29),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,129),heltab2x128(:,:,147))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(83),n2h64(105))
Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(149)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(148),h0tab(:,148),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,29),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,130),heltab2x128(:,:,148))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(84),n2h64(106))
Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(149)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(149),h0tab(:,149),[64,15,48],[0,0,0],3,2,wf16(:,29),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,131),heltab2x128(:,:,149))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(85),n2h64(107))
Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(149)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(150),h0tab(:,150),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,29),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,132),heltab2x128(:,:,150))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(86),n2h64(108))
Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(149)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(151),h0tab(:,151),[64,15,48],[0,0,0],3,2,wf16(:,29),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,133),heltab2x128(:,:,151))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(87),n2h64(109))
Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(149)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(152),h0tab(:,152),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,29),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,134),heltab2x128(:,:,152))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(88),n2h64(110))
Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(149)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(153),h0tab(:,153),[64,15,48],[0,0,0],3,2,wf16(:,29),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,135),heltab2x128(:,:,153))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(89),n2h64(111))
Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(149)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(154),h0tab(:,154),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,29),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,136),heltab2x128(:,:,154))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(90),n2h64(112))
Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(150)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(155),h0tab(:,155),[64,15,48],[0,0,0],3,2,wf16(:,30),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,137),heltab2x128(:,:,155))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(91),n2h64(113))
Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(150)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(156),h0tab(:,156),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,30),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,138),heltab2x128(:,:,156))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(92),n2h64(114))
Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(150)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(157),h0tab(:,157),[64,15,48],[0,0,0],3,2,wf16(:,30),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,139),heltab2x128(:,:,157))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(93),n2h64(115))
Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(150)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(158),h0tab(:,158),[64,15,48],[nMT,nMT,nMT],3,2,wf16(:,30),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,140),heltab2x128(:,:,158))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(94),n2h64(116))
Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(150)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(159),h0tab(:,159),[64,15,48],[0,0,0],3,2,wf16(:,30),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,141),heltab2x128(:,:,159))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(95),n2h64(117))
Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(150)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(160),h0tab(:,160),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,30),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,142),heltab2x128(:,:,160))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(96),n2h64(118))
Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(150)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(161),h0tab(:,161),[64,15,48],[0,0,0],3,2,wf16(:,30),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,143),heltab2x128(:,:,161))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(97),n2h64(119))
Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(150)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(162),h0tab(:,162),[64,15,48],[nMB,nMB,nMB],3,2,wf16(:,30),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,144),heltab2x128(:,:,162))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(98),n2h64(120))
Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(151)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(163),h0tab(:,163),[80,15,32],[0,0,0],3,2,wf4(:,6),wf16(:,8))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,6),G0H32(1),m3h4x32(:,15),heltab2x128(:,:,163))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(16),n2h32(35))
Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(152)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(164),h0tab(:,164),[80,15,32],[0,0,0],3,2,wf4(:,6),wf16(:,29))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,6),G0H32(1),m3h4x32(:,16),heltab2x128(:,:,164))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(17),n2h32(36))
Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(153)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(165),h0tab(:,165),[80,15,32],[0,0,0],3,2,wf4(:,6),wf16(:,30))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,6),G0H32(1),m3h4x32(:,17),heltab2x128(:,:,165))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(19),n2h32(37))
Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(154)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(166),h0tab(:,166),[96,15,16],[0,0,0],3,2,wf4(:,8),wf16(:,8))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(1),m3h4x32(:,18),heltab2x128(:,:,166))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(20),n2h32(38))
Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(155)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(167),h0tab(:,167),[96,15,16],[0,0,0],3,2,wf4(:,8),wf16(:,29))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(1),m3h4x32(:,19),heltab2x128(:,:,167))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(21),n2h32(39))
Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(156)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(168),h0tab(:,168),[96,15,16],[0,0,0],3,2,wf4(:,8),wf16(:,30))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(1),m3h4x32(:,20),heltab2x128(:,:,168))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(22),n2h32(40))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(124)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(169),h0tab(:,169),[64,31,32],[0,0,0],3,1,wf32(:,27))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,145),heltab2x128(:,:,169))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(99),n2h64(121))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(125)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(170),h0tab(:,170),[64,31,32],[0,0,0],3,1,wf32(:,29))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,146),heltab2x128(:,:,170))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(100),n2h64(122))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(124)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(171),h0tab(:,171),[64,31,32],[0,0,0],3,1,wf32(:,27))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(101),m3h2x64(:,147),heltab2x128(:,:,171))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(125)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(172),h0tab(:,172),[64,31,32],[0,0,0],3,1,wf32(:,29))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(102),m3h2x64(:,148),heltab2x128(:,:,172))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(126)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(173),h0tab(:,173),[64,16,47],[0,0,0],3,1,wf32(:,31))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,149),heltab2x128(:,:,173))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(103),n2h64(123))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(127)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(174),h0tab(:,174),[64,16,47],[0,0,0],3,1,wf32(:,33))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,150),heltab2x128(:,:,174))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(104),n2h64(124))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(126)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(175),h0tab(:,175),[64,16,47],[0,0,0],3,1,wf32(:,31))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(105),m3h2x64(:,151),heltab2x128(:,:,175))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(127)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(176),h0tab(:,176),[64,16,47],[0,0,0],3,1,wf32(:,33))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(106),m3h2x64(:,152),heltab2x128(:,:,176))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(128)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(177),h0tab(:,177),[64,31,32],[0,0,0],3,1,wf32(:,35))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,153),heltab2x128(:,:,177))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(107),n2h64(125))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(128)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(178),h0tab(:,178),[64,31,32],[0,0,0],3,1,wf32(:,35))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(108),m3h2x64(:,154),heltab2x128(:,:,178))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(129)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(179),h0tab(:,179),[64,16,47],[0,0,0],3,1,wf32(:,37))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,155),heltab2x128(:,:,179))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(109),n2h64(126))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(129)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(180),h0tab(:,180),[64,16,47],[0,0,0],3,1,wf32(:,37))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(110),m3h2x64(:,156),heltab2x128(:,:,180))
  call ol_merge(ntryL,G1H8(22),[G1H8(17),G1H8(12),G1H8(6)])
  call ol_merge(ntryL,G1H8(11),[G1H8(19),G1H8(14)])
  call ol_merge(ntryL,G1H32(3),[G1H32(2)])
  call ol_merge(ntryL,G1H32(1),[G1H32(8)])
  call ol_merge(ntryL,G1H32(4),[G1H32(13)])
  call ol_merge(ntryL,G1H32(9),[G1H32(18)])
  call ol_merge(ntryL,G1H32(10),[G1H32(23)])
  call ol_merge(ntryL,G1H32(11),[G1H32(28)])
  call ol_merge(ntryL,G1H32(16),[G1H32(33)])
  call ol_merge(ntryL,G1H32(17),[G1H32(38)])
  call ol_merge(ntryL,G1H32(19),[G1H32(43)])
  call ol_merge(ntryL,G1H64(9),[G1H64(5)])
  call ol_merge(ntryL,G1H64(11),[G1H64(7)])
  call ol_merge(ntryL,G1H64(43),[G1H64(39)])
  call ol_merge(ntryL,G1H64(45),[G1H64(41)])
  call ol_merge(ntryL,G1H64(79),[G1H64(75)])
  call ol_merge(ntryL,G1H64(81),[G1H64(77)])
  call Hloop_QW_A(ntryL,G1H8(22),wf4(:,4),G1H2(20),m3h4x2(:,20),heltab2x8(:,:,39))
  call Hloop_Q_A(ntryL,G1H2(20),95,0,G2H2(2),n2h2(43))
  call Hloop_AW_Q(ntryL,G1H8(11),wf4(:,5),G1H2(21),m3h4x2(:,21),heltab2x8(:,:,40))
  call Hloop_A_Q(ntryL,G1H2(21),111,0,G2H2(5),n2h2(44))
  call Hloop_AV_Q(ntryL,G1H16(11),wf4(:,9),G1H4(24),m3h4x4(:,72),heltab2x16(:,:,79))
  call Hloop_A_Q(ntryL,G1H4(24),117,0,G2H4(3),n2h4(81))
  call Hloop_AV_Q(ntryL,G1H16(4),wf4(:,9),G1H4(8),m3h4x4(:,73),heltab2x16(:,:,80))
  call Hloop_A_Q(ntryL,G1H4(8),117,nMB,G2H4(11),n2h4(82))
  call Hloop_QV_A(ntryL,G1H16(13),wf4(:,9),G1H4(1),m3h4x4(:,74),heltab2x16(:,:,81))
  call Hloop_Q_A(ntryL,G1H4(1),117,0,G2H4(17),n2h4(83))
  call Hloop_QV_A(ntryL,G1H16(18),wf4(:,9),G1H4(14),m3h4x4(:,75),heltab2x16(:,:,82))
  call Hloop_Q_A(ntryL,G1H4(14),117,nMT,G2H4(16),n2h4(84))
  call Hloop_AW_Q(ntryL,G1H16(23),wf4(:,4),G1H4(26),m3h4x4(:,76),heltab2x16(:,:,83))
  call Hloop_A_Q(ntryL,G1H4(26),79,0,G2H4(14),n2h4(85))
  call Hloop_AW_Q(ntryL,G1H16(28),wf4(:,4),G1H4(27),m3h4x4(:,77),heltab2x16(:,:,84))
  call Hloop_A_Q(ntryL,G1H4(27),79,nMT,G2H4(8),n2h4(86))
  call Hloop_QW_A(ntryL,G1H16(33),wf4(:,4),G1H4(30),m3h4x4(:,78),heltab2x16(:,:,85))
  call Hloop_Q_A(ntryL,G1H4(30),79,0,G2H4(2),n2h4(87))
  call Hloop_QW_A(ntryL,G1H16(38),wf4(:,4),G1H4(2),m3h4x4(:,79),heltab2x16(:,:,86))
  call Hloop_Q_A(ntryL,G1H4(2),79,nMB,G2H4(15),n2h4(88))
  call Hloop_QW_A(ntryL,G1H16(43),wf4(:,5),G1H4(3),m3h4x4(:,80),heltab2x16(:,:,87))
  call Hloop_Q_A(ntryL,G1H4(3),79,0,G2H4(13),n2h4(89))
  call Hloop_QW_A(ntryL,G1H16(48),wf4(:,5),G1H4(33),m3h4x4(:,81),heltab2x16(:,:,88))
  call Hloop_Q_A(ntryL,G1H4(33),79,nMT,G2H4(4),n2h4(90))
  call Hloop_AW_Q(ntryL,G1H16(53),wf4(:,5),G1H4(34),m3h4x4(:,82),heltab2x16(:,:,89))
  call Hloop_A_Q(ntryL,G1H4(34),79,0,G2H4(6),n2h4(91))
  call Hloop_AW_Q(ntryL,G1H16(58),wf4(:,5),G1H4(35),m3h4x4(:,83),heltab2x16(:,:,90))
  call Hloop_A_Q(ntryL,G1H4(35),79,nMB,G2H4(5),n2h4(92))
  call Hloop_QW_A(ntryL,G1H32(3),wf4(:,5),G1H8(1),m3h4x8(:,10),heltab2x32(:,:,44))
  call Hloop_Q_A(ntryL,G1H8(1),85,0,G2H8(3),n2h8(22))
  call Hloop_QV_A(ntryL,G1H32(1),wf16(:,2),G1H2(22),m3h16x2(:,25),heltab2x32(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(22),95,0,G2H2(14),n2h2(45))
  call Hloop_QZ_A(ntryL,G1H32(4),wf16(:,12),G1H2(13),ngZd,m3h16x2(:,26),heltab2x32(:,:,46))
  call Hloop_Q_A(ntryL,G1H2(13),95,0,G2H2(44),n2h2(46))
  call Hloop_QV_A(ntryL,G1H32(9),wf16(:,5),G1H2(18),m3h16x2(:,27),heltab2x32(:,:,47))
  call Hloop_Q_A(ntryL,G1H2(18),95,0,G2H2(41),n2h2(47))
  call Hloop_QZ_A(ntryL,G1H32(10),wf16(:,27),G1H2(17),ngZd,m3h16x2(:,28),heltab2x32(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(17),95,0,G2H2(38),n2h2(48))
  call Hloop_QZ_A(ntryL,G1H32(11),wf16(:,28),G1H2(1),ngZd,m3h16x2(:,29),heltab2x32(:,:,49))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(35),n2h2(49))
  call Hloop_QV_A(ntryL,G1H32(16),wf16(:,8),G1H2(2),m3h16x2(:,30),heltab2x32(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(2),95,0,G2H2(32),n2h2(50))
  call Hloop_QZ_A(ntryL,G1H32(17),wf16(:,29),G1H2(12),ngZd,m3h16x2(:,31),heltab2x32(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(12),95,0,G2H2(29),n2h2(51))
  call Hloop_QZ_A(ntryL,G1H32(19),wf16(:,30),G1H2(5),ngZd,m3h16x2(:,32),heltab2x32(:,:,52))
  call Hloop_Q_A(ntryL,G1H2(5),95,0,G2H2(26),n2h2(52))
  call Hloop_QS_A(ntryL,G1H64(1),wf16(:,11),G1H4(38),ngH,m3h16x4(:,17),heltab2x64(:,:,47))
  call Hloop_Q_A(ntryL,G1H4(38),79,nMT,G2H4(7),n2h4(93))
  call Hloop_AS_Q(ntryL,G1H64(2),wf16(:,11),G1H4(12),ngH,m3h16x4(:,18),heltab2x64(:,:,48))
  call Hloop_A_Q(ntryL,G1H4(12),79,nMT,G2H4(24),n2h4(94))
  call Hloop_QS_A(ntryL,G1H64(3),wf16(:,11),G1H4(13),ngH,m3h16x4(:,19),heltab2x64(:,:,49))
  call Hloop_Q_A(ntryL,G1H4(13),79,nMB,G2H4(25),n2h4(95))
  call Hloop_AS_Q(ntryL,G1H64(4),wf16(:,11),G1H4(40),ngH,m3h16x4(:,20),heltab2x64(:,:,50))
  call Hloop_A_Q(ntryL,G1H4(40),79,nMB,G2H4(28),n2h4(96))
  call Hloop_QV_A(ntryL,G1H64(9),wf16(:,2),G1H4(11),m3h16x4(:,21),heltab2x64(:,:,51))
  call Hloop_Q_A(ntryL,G1H4(11),79,0,G2H4(29),n2h4(97))
  call Hloop_QV_A(ntryL,G1H64(6),wf16(:,2),G1H4(41),m3h16x4(:,22),heltab2x64(:,:,52))
  call Hloop_Q_A(ntryL,G1H4(41),79,nMT,G2H4(32),n2h4(98))
  call Hloop_AV_Q(ntryL,G1H64(11),wf16(:,2),G1H4(44),m3h16x4(:,23),heltab2x64(:,:,53))
  call Hloop_A_Q(ntryL,G1H4(44),79,0,G2H4(33),n2h4(99))
  call Hloop_AV_Q(ntryL,G1H64(8),wf16(:,2),G1H4(15),m3h16x4(:,24),heltab2x64(:,:,54))
  call Hloop_A_Q(ntryL,G1H4(15),79,nMT,G2H4(36),n2h4(100))
  call Hloop_QV_A(ntryL,G1H64(10),wf16(:,2),G1H4(45),m3h16x4(:,25),heltab2x64(:,:,55))
  call Hloop_Q_A(ntryL,G1H4(45),79,nMB,G2H4(37),n2h4(101))
  call Hloop_AV_Q(ntryL,G1H64(12),wf16(:,2),G1H4(48),m3h16x4(:,26),heltab2x64(:,:,56))
  call Hloop_A_Q(ntryL,G1H4(48),79,nMB,G2H4(40),n2h4(102))
  call Hloop_QZ_A(ntryL,G1H64(13),wf16(:,12),G1H4(16),ngZu,m3h16x4(:,27),heltab2x64(:,:,57))
  call Hloop_Q_A(ntryL,G1H4(16),79,0,G2H4(41),n2h4(103))
  call Hloop_QZ_A(ntryL,G1H64(14),wf16(:,12),G1H4(49),ngZu,m3h16x4(:,28),heltab2x64(:,:,58))
  call Hloop_Q_A(ntryL,G1H4(49),79,nMT,G2H4(44),n2h4(104))
  call Hloop_AZ_Q(ntryL,G1H64(15),wf16(:,12),G1H4(52),ngZu,m3h16x4(:,29),heltab2x64(:,:,59))
  call Hloop_A_Q(ntryL,G1H4(52),79,0,G2H4(45),n2h4(105))
  call Hloop_AZ_Q(ntryL,G1H64(16),wf16(:,12),G1H4(17),ngZu,m3h16x4(:,30),heltab2x64(:,:,60))
  call Hloop_A_Q(ntryL,G1H4(17),79,nMT,G2H4(48),n2h4(106))
  call Hloop_QZ_A(ntryL,G1H64(17),wf16(:,12),G1H4(53),ngZd,m3h16x4(:,31),heltab2x64(:,:,61))
  call Hloop_Q_A(ntryL,G1H4(53),79,0,G2H4(49),n2h4(107))
  call Hloop_QZ_A(ntryL,G1H64(18),wf16(:,12),G1H4(56),ngZd,m3h16x4(:,32),heltab2x64(:,:,62))
  call Hloop_Q_A(ntryL,G1H4(56),79,nMB,G2H4(52),n2h4(108))
  call Hloop_AZ_Q(ntryL,G1H64(19),wf16(:,12),G1H4(18),ngZd,m3h16x4(:,33),heltab2x64(:,:,63))
  call Hloop_A_Q(ntryL,G1H4(18),79,0,G2H4(53),n2h4(109))
  call Hloop_AZ_Q(ntryL,G1H64(20),wf16(:,12),G1H4(57),ngZd,m3h16x4(:,34),heltab2x64(:,:,64))
  call Hloop_A_Q(ntryL,G1H4(57),79,nMB,G2H4(54),n2h4(110))
  call Hloop_AW_Q(ntryL,G1H32(5),wf4(:,4),G1H8(9),m3h4x8(:,11),heltab2x32(:,:,53))
  call Hloop_A_Q(ntryL,G1H8(9),106,0,G2H8(7),n2h8(23))
  call Hloop_AV_Q(ntryL,G1H32(6),wf16(:,2),G1H2(16),m3h16x2(:,33),heltab2x32(:,:,54))
  call Hloop_A_Q(ntryL,G1H2(16),111,0,G2H2(9),n2h2(53))
  call Hloop_AZ_Q(ntryL,G1H32(7),wf16(:,12),G1H2(4),ngZd,m3h16x2(:,34),heltab2x32(:,:,55))
  call Hloop_A_Q(ntryL,G1H2(4),111,0,G2H2(46),n2h2(54))
  call Hloop_AQ_V(ntryL,G1H64(21),wf8(:,7),G1H8(10),m3h8x8(:,2),heltab2x64(:,:,65))
  call Hloop_VQ_A(ntryL,G1H64(22),wf8(:,7),G1H8(3),m3h8x8(:,3),heltab2x64(:,:,66))
  call Hloop_Q_A(ntryL,G1H8(3),85,0,G2H8(1),n2h8(24))
  call Hloop_AQ_V(ntryL,G1H64(23),wf32(:,3),G1H2(15),m3h32x2(:,1),heltab2x64(:,:,67))
  call Hloop_VQ_A(ntryL,G1H64(24),wf32(:,3),G1H2(23),m3h32x2(:,2),heltab2x64(:,:,68))
  call Hloop_Q_A(ntryL,G1H2(23),95,0,G2H2(43),n2h2(55))
  call Hloop_AQ_V(ntryL,G1H64(25),ex5(:),G1H32(24),m3h2x32(:,11),heltab2x64(:,:,69))
  call Hloop_VQ_A(ntryL,G1H64(26),ex5(:),G1H32(25),m3h2x32(:,12),heltab2x64(:,:,70))
  call Hloop_Q_A(ntryL,G1H32(25),80,0,G2H32(1),n2h32(41))
  call Hloop_AQ_V(ntryL,G1H64(27),wf32(:,7),G1H2(26),m3h32x2(:,3),heltab2x64(:,:,71))
  call Hloop_AQ_V(ntryL,G1H64(28),wf32(:,9),G1H2(27),m3h32x2(:,4),heltab2x64(:,:,72))
  call Hloop_VQ_A(ntryL,G1H64(29),wf32(:,7),G1H2(28),m3h32x2(:,5),heltab2x64(:,:,73))
  call Hloop_Q_A(ntryL,G1H2(28),95,0,G2H2(40),n2h2(56))
  call Hloop_VQ_A(ntryL,G1H64(30),wf32(:,9),G1H2(31),m3h32x2(:,6),heltab2x64(:,:,74))
  call Hloop_Q_A(ntryL,G1H2(31),95,0,G2H2(37),n2h2(57))
  call Hloop_AQ_V(ntryL,G1H64(31),ex5(:),G1H32(26),m3h2x32(:,13),heltab2x64(:,:,75))
  call Hloop_AQ_V(ntryL,G1H64(32),ex5(:),G1H32(27),m3h2x32(:,14),heltab2x64(:,:,76))
  call Hloop_VQ_A(ntryL,G1H64(33),ex5(:),G1H32(29),m3h2x32(:,15),heltab2x64(:,:,77))
  call Hloop_Q_A(ntryL,G1H32(29),80,0,G2H32(2),n2h32(42))
  call Hloop_VQ_A(ntryL,G1H64(34),ex5(:),G1H32(30),m3h2x32(:,16),heltab2x64(:,:,78))
  call Hloop_Q_A(ntryL,G1H32(30),80,0,G2H32(3),n2h32(43))
  call Hloop_AS_Q(ntryL,G1H64(35),wf16(:,21),G1H4(60),ngH,m3h16x4(:,35),heltab2x64(:,:,79))
  call Hloop_A_Q(ntryL,G1H4(60),79,nMT,G2H4(55),n2h4(111))
  call Hloop_QS_A(ntryL,G1H64(36),wf16(:,21),G1H4(19),ngH,m3h16x4(:,36),heltab2x64(:,:,80))
  call Hloop_Q_A(ntryL,G1H4(19),79,nMT,G2H4(56),n2h4(112))
  call Hloop_AS_Q(ntryL,G1H64(37),wf16(:,21),G1H4(61),ngH,m3h16x4(:,37),heltab2x64(:,:,81))
  call Hloop_A_Q(ntryL,G1H4(61),79,nMB,G2H4(57),n2h4(113))
  call Hloop_QS_A(ntryL,G1H64(38),wf16(:,21),G1H4(64),ngH,m3h16x4(:,38),heltab2x64(:,:,82))
  call Hloop_Q_A(ntryL,G1H4(64),79,nMB,G2H4(58),n2h4(114))
  call Hloop_AV_Q(ntryL,G1H64(43),wf16(:,5),G1H4(20),m3h16x4(:,39),heltab2x64(:,:,83))
  call Hloop_A_Q(ntryL,G1H4(20),79,0,G2H4(59),n2h4(115))
  call Hloop_AV_Q(ntryL,G1H64(40),wf16(:,5),G1H4(65),m3h16x4(:,40),heltab2x64(:,:,84))
  call Hloop_A_Q(ntryL,G1H4(65),79,nMT,G2H4(60),n2h4(116))
  call Hloop_QV_A(ntryL,G1H64(45),wf16(:,5),G1H4(68),m3h16x4(:,41),heltab2x64(:,:,85))
  call Hloop_Q_A(ntryL,G1H4(68),79,0,G2H4(61),n2h4(117))
  call Hloop_QV_A(ntryL,G1H64(42),wf16(:,5),G1H4(21),m3h16x4(:,42),heltab2x64(:,:,86))
  call Hloop_Q_A(ntryL,G1H4(21),79,nMT,G2H4(62),n2h4(118))
  call Hloop_AV_Q(ntryL,G1H64(44),wf16(:,5),G1H4(69),m3h16x4(:,43),heltab2x64(:,:,87))
  call Hloop_A_Q(ntryL,G1H4(69),79,nMB,G2H4(63),n2h4(119))
  call Hloop_QV_A(ntryL,G1H64(46),wf16(:,5),G1H4(72),m3h16x4(:,44),heltab2x64(:,:,88))
  call Hloop_Q_A(ntryL,G1H4(72),79,nMB,G2H4(64),n2h4(120))
  call Hloop_AZ_Q(ntryL,G1H64(47),wf16(:,27),G1H4(22),ngZu,m3h16x4(:,45),heltab2x64(:,:,89))
  call Hloop_A_Q(ntryL,G1H4(22),79,0,G2H4(65),n2h4(121))
  call Hloop_AZ_Q(ntryL,G1H64(48),wf16(:,27),G1H4(73),ngZu,m3h16x4(:,46),heltab2x64(:,:,90))
  call Hloop_A_Q(ntryL,G1H4(73),79,nMT,G2H4(66),n2h4(122))
  call Hloop_QZ_A(ntryL,G1H64(49),wf16(:,27),G1H4(76),ngZu,m3h16x4(:,47),heltab2x64(:,:,91))
  call Hloop_Q_A(ntryL,G1H4(76),79,0,G2H4(67),n2h4(123))
  call Hloop_QZ_A(ntryL,G1H64(50),wf16(:,27),G1H4(23),ngZu,m3h16x4(:,48),heltab2x64(:,:,92))
  call Hloop_Q_A(ntryL,G1H4(23),79,nMT,G2H4(68),n2h4(124))
  call Hloop_AZ_Q(ntryL,G1H64(51),wf16(:,27),G1H4(77),ngZd,m3h16x4(:,49),heltab2x64(:,:,93))
  call Hloop_A_Q(ntryL,G1H4(77),79,0,G2H4(69),n2h4(125))
  call Hloop_AZ_Q(ntryL,G1H64(52),wf16(:,27),G1H4(80),ngZd,m3h16x4(:,50),heltab2x64(:,:,94))
  call Hloop_A_Q(ntryL,G1H4(80),79,nMB,G2H4(70),n2h4(126))
  call Hloop_QZ_A(ntryL,G1H64(53),wf16(:,27),G1H4(24),ngZd,m3h16x4(:,51),heltab2x64(:,:,95))
  call Hloop_Q_A(ntryL,G1H4(24),79,0,G2H4(71),n2h4(127))
  call Hloop_QZ_A(ntryL,G1H64(54),wf16(:,27),G1H4(8),ngZd,m3h16x4(:,52),heltab2x64(:,:,96))
  call Hloop_Q_A(ntryL,G1H4(8),79,nMB,G2H4(72),n2h4(128))
  call Hloop_AZ_Q(ntryL,G1H64(55),wf16(:,28),G1H4(1),ngZu,m3h16x4(:,53),heltab2x64(:,:,97))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(73),n2h4(129))
  call Hloop_AZ_Q(ntryL,G1H64(56),wf16(:,28),G1H4(14),ngZu,m3h16x4(:,54),heltab2x64(:,:,98))
  call Hloop_A_Q(ntryL,G1H4(14),79,nMT,G2H4(74),n2h4(130))
  call Hloop_QZ_A(ntryL,G1H64(57),wf16(:,28),G1H4(26),ngZu,m3h16x4(:,55),heltab2x64(:,:,99))
  call Hloop_Q_A(ntryL,G1H4(26),79,0,G2H4(75),n2h4(131))
  call Hloop_QZ_A(ntryL,G1H64(58),wf16(:,28),G1H4(27),ngZu,m3h16x4(:,56),heltab2x64(:,:,100))
  call Hloop_Q_A(ntryL,G1H4(27),79,nMT,G2H4(76),n2h4(132))
  call Hloop_AZ_Q(ntryL,G1H64(59),wf16(:,28),G1H4(30),ngZd,m3h16x4(:,57),heltab2x64(:,:,101))
  call Hloop_A_Q(ntryL,G1H4(30),79,0,G2H4(77),n2h4(133))
  call Hloop_AZ_Q(ntryL,G1H64(60),wf16(:,28),G1H4(2),ngZd,m3h16x4(:,58),heltab2x64(:,:,102))
  call Hloop_A_Q(ntryL,G1H4(2),79,nMB,G2H4(78),n2h4(134))
  call Hloop_QZ_A(ntryL,G1H64(61),wf16(:,28),G1H4(3),ngZd,m3h16x4(:,59),heltab2x64(:,:,103))
  call Hloop_Q_A(ntryL,G1H4(3),79,0,G2H4(79),n2h4(135))
  call Hloop_QZ_A(ntryL,G1H64(62),wf16(:,28),G1H4(33),ngZd,m3h16x4(:,60),heltab2x64(:,:,104))
  call Hloop_Q_A(ntryL,G1H4(33),79,nMB,G2H4(80),n2h4(136))
  call Hloop_AV_Q(ntryL,G1H32(12),wf16(:,5),G1H2(9),m3h16x2(:,35),heltab2x32(:,:,56))
  call Hloop_A_Q(ntryL,G1H2(9),111,0,G2H2(34),n2h2(58))
  call Hloop_AZ_Q(ntryL,G1H32(14),wf16(:,27),G1H2(10),ngZd,m3h16x2(:,36),heltab2x32(:,:,57))
  call Hloop_A_Q(ntryL,G1H2(10),111,0,G2H2(31),n2h2(59))
  call Hloop_AZ_Q(ntryL,G1H32(15),wf16(:,28),G1H2(33),ngZd,m3h16x2(:,37),heltab2x32(:,:,58))
  call Hloop_A_Q(ntryL,G1H2(33),111,0,G2H2(28),n2h2(60))
  call Hloop_AQ_V(ntryL,G1H64(63),wf32(:,15),G1H2(20),m3h32x2(:,7),heltab2x64(:,:,105))
  call Hloop_AQ_V(ntryL,G1H64(64),wf32(:,17),G1H2(21),m3h32x2(:,8),heltab2x64(:,:,106))
  call Hloop_VQ_A(ntryL,G1H64(65),wf32(:,15),G1H2(22),m3h32x2(:,9),heltab2x64(:,:,107))
  call Hloop_Q_A(ntryL,G1H2(22),95,0,G2H2(12),n2h2(61))
  call Hloop_VQ_A(ntryL,G1H64(66),wf32(:,17),G1H2(13),m3h32x2(:,10),heltab2x64(:,:,108))
  call Hloop_Q_A(ntryL,G1H2(13),95,0,G2H2(11),n2h2(62))
  call Hloop_AQ_V(ntryL,G1H64(67),ex5(:),G1H32(31),m3h2x32(:,17),heltab2x64(:,:,109))
  call Hloop_AQ_V(ntryL,G1H64(68),ex5(:),G1H32(32),m3h2x32(:,18),heltab2x64(:,:,110))
  call Hloop_VQ_A(ntryL,G1H64(69),ex5(:),G1H32(34),m3h2x32(:,19),heltab2x64(:,:,111))
  call Hloop_Q_A(ntryL,G1H32(34),80,0,G2H32(4),n2h32(44))
  call Hloop_VQ_A(ntryL,G1H64(70),ex5(:),G1H32(35),m3h2x32(:,20),heltab2x64(:,:,112))
  call Hloop_Q_A(ntryL,G1H32(35),80,0,G2H32(5),n2h32(45))
  call Hloop_AQ_V(ntryL,G1H64(71),wf32(:,23),G1H2(18),m3h32x2(:,11),heltab2x64(:,:,113))
  call Hloop_VQ_A(ntryL,G1H64(72),wf32(:,23),G1H2(17),m3h32x2(:,12),heltab2x64(:,:,114))
  call Hloop_Q_A(ntryL,G1H2(17),95,0,G2H2(8),n2h2(63))
  call Hloop_AQ_V(ntryL,G1H64(73),ex5(:),G1H32(36),m3h2x32(:,21),heltab2x64(:,:,115))
  call Hloop_VQ_A(ntryL,G1H64(74),ex5(:),G1H32(37),m3h2x32(:,22),heltab2x64(:,:,116))
  call Hloop_Q_A(ntryL,G1H32(37),80,0,G2H32(6),n2h32(46))
  call Hloop_AV_Q(ntryL,G1H64(79),wf16(:,8),G1H4(34),m3h16x4(:,61),heltab2x64(:,:,117))
  call Hloop_A_Q(ntryL,G1H4(34),79,0,G2H4(81),n2h4(137))
  call Hloop_AV_Q(ntryL,G1H64(76),wf16(:,8),G1H4(35),m3h16x4(:,62),heltab2x64(:,:,118))
  call Hloop_A_Q(ntryL,G1H4(35),79,nMT,G2H4(82),n2h4(138))
  call Hloop_QV_A(ntryL,G1H64(81),wf16(:,8),G1H4(38),m3h16x4(:,63),heltab2x64(:,:,119))
  call Hloop_Q_A(ntryL,G1H4(38),79,0,G2H4(83),n2h4(139))
  call Hloop_QV_A(ntryL,G1H64(78),wf16(:,8),G1H4(12),m3h16x4(:,64),heltab2x64(:,:,120))
  call Hloop_Q_A(ntryL,G1H4(12),79,nMT,G2H4(84),n2h4(140))
  call Hloop_AV_Q(ntryL,G1H64(80),wf16(:,8),G1H4(13),m3h16x4(:,65),heltab2x64(:,:,121))
  call Hloop_A_Q(ntryL,G1H4(13),79,nMB,G2H4(85),n2h4(141))
  call Hloop_QV_A(ntryL,G1H64(82),wf16(:,8),G1H4(40),m3h16x4(:,66),heltab2x64(:,:,122))
  call Hloop_Q_A(ntryL,G1H4(40),79,nMB,G2H4(86),n2h4(142))
  call Hloop_AZ_Q(ntryL,G1H64(83),wf16(:,29),G1H4(11),ngZu,m3h16x4(:,67),heltab2x64(:,:,123))
  call Hloop_A_Q(ntryL,G1H4(11),79,0,G2H4(87),n2h4(143))
  call Hloop_AZ_Q(ntryL,G1H64(84),wf16(:,29),G1H4(41),ngZu,m3h16x4(:,68),heltab2x64(:,:,124))
  call Hloop_A_Q(ntryL,G1H4(41),79,nMT,G2H4(88),n2h4(144))
  call Hloop_QZ_A(ntryL,G1H64(85),wf16(:,29),G1H4(44),ngZu,m3h16x4(:,69),heltab2x64(:,:,125))
  call Hloop_Q_A(ntryL,G1H4(44),79,0,G2H4(89),n2h4(145))
  call Hloop_QZ_A(ntryL,G1H64(86),wf16(:,29),G1H4(15),ngZu,m3h16x4(:,70),heltab2x64(:,:,126))
  call Hloop_Q_A(ntryL,G1H4(15),79,nMT,G2H4(90),n2h4(146))
  call Hloop_AZ_Q(ntryL,G1H64(87),wf16(:,29),G1H4(45),ngZd,m3h16x4(:,71),heltab2x64(:,:,127))
  call Hloop_A_Q(ntryL,G1H4(45),79,0,G2H4(91),n2h4(147))
  call Hloop_AZ_Q(ntryL,G1H64(88),wf16(:,29),G1H4(48),ngZd,m3h16x4(:,72),heltab2x64(:,:,128))
  call Hloop_A_Q(ntryL,G1H4(48),79,nMB,G2H4(92),n2h4(148))
  call Hloop_QZ_A(ntryL,G1H64(89),wf16(:,29),G1H4(16),ngZd,m3h16x4(:,73),heltab2x64(:,:,129))
  call Hloop_Q_A(ntryL,G1H4(16),79,0,G2H4(93),n2h4(149))
  call Hloop_QZ_A(ntryL,G1H64(90),wf16(:,29),G1H4(49),ngZd,m3h16x4(:,74),heltab2x64(:,:,130))
  call Hloop_Q_A(ntryL,G1H4(49),79,nMB,G2H4(94),n2h4(150))
  call Hloop_AZ_Q(ntryL,G1H64(91),wf16(:,30),G1H4(52),ngZu,m3h16x4(:,75),heltab2x64(:,:,131))
  call Hloop_A_Q(ntryL,G1H4(52),79,0,G2H4(95),n2h4(151))
  call Hloop_AZ_Q(ntryL,G1H64(92),wf16(:,30),G1H4(17),ngZu,m3h16x4(:,76),heltab2x64(:,:,132))
  call Hloop_A_Q(ntryL,G1H4(17),79,nMT,G2H4(96),n2h4(152))
  call Hloop_QZ_A(ntryL,G1H64(93),wf16(:,30),G1H4(53),ngZu,m3h16x4(:,77),heltab2x64(:,:,133))
  call Hloop_Q_A(ntryL,G1H4(53),79,0,G2H4(97),n2h4(153))
  call Hloop_QZ_A(ntryL,G1H64(94),wf16(:,30),G1H4(56),ngZu,m3h16x4(:,78),heltab2x64(:,:,134))
  call Hloop_Q_A(ntryL,G1H4(56),79,nMT,G2H4(98),n2h4(154))
  call Hloop_AZ_Q(ntryL,G1H64(95),wf16(:,30),G1H4(18),ngZd,m3h16x4(:,79),heltab2x64(:,:,135))
  call Hloop_A_Q(ntryL,G1H4(18),79,0,G2H4(99),n2h4(155))
  call Hloop_AZ_Q(ntryL,G1H64(96),wf16(:,30),G1H4(57),ngZd,m3h16x4(:,80),heltab2x64(:,:,136))
  call Hloop_A_Q(ntryL,G1H4(57),79,nMB,G2H4(100),n2h4(156))
  call Hloop_QZ_A(ntryL,G1H64(97),wf16(:,30),G1H4(60),ngZd,m3h16x4(:,81),heltab2x64(:,:,137))
  call Hloop_Q_A(ntryL,G1H4(60),79,0,G2H4(101),n2h4(157))
  call Hloop_QZ_A(ntryL,G1H64(98),wf16(:,30),G1H4(19),ngZd,m3h16x4(:,82),heltab2x64(:,:,138))
  call Hloop_Q_A(ntryL,G1H4(19),79,nMB,G2H4(102),n2h4(158))
  call Hloop_AV_Q(ntryL,G1H32(20),wf16(:,8),G1H2(1),m3h16x2(:,38),heltab2x32(:,:,59))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(10),n2h2(64))
  call Hloop_AZ_Q(ntryL,G1H32(21),wf16(:,29),G1H2(2),ngZd,m3h16x2(:,39),heltab2x32(:,:,60))
  call Hloop_A_Q(ntryL,G1H2(2),111,0,G2H2(16),n2h2(65))
  call Hloop_AZ_Q(ntryL,G1H32(22),wf16(:,30),G1H2(12),ngZd,m3h16x2(:,40),heltab2x32(:,:,61))
  call Hloop_A_Q(ntryL,G1H2(12),111,0,G2H2(15),n2h2(66))
  call Hloop_AQ_V(ntryL,G1H64(99),wf32(:,27),G1H2(5),m3h32x2(:,13),heltab2x64(:,:,139))
  call Hloop_AQ_V(ntryL,G1H64(100),wf32(:,29),G1H2(16),m3h32x2(:,14),heltab2x64(:,:,140))
  call Hloop_VQ_A(ntryL,G1H64(101),wf32(:,27),G1H2(4),m3h32x2(:,15),heltab2x64(:,:,141))
  call Hloop_Q_A(ntryL,G1H2(4),95,0,G2H2(7),n2h2(67))
  call Hloop_VQ_A(ntryL,G1H64(102),wf32(:,29),G1H2(23),m3h32x2(:,16),heltab2x64(:,:,142))
  call Hloop_Q_A(ntryL,G1H2(23),95,0,G2H2(47),n2h2(68))
  call Hloop_AQ_V(ntryL,G1H64(103),ex5(:),G1H32(39),m3h2x32(:,23),heltab2x64(:,:,143))
  call Hloop_AQ_V(ntryL,G1H64(104),ex5(:),G1H32(40),m3h2x32(:,24),heltab2x64(:,:,144))
  call Hloop_VQ_A(ntryL,G1H64(105),ex5(:),G1H32(41),m3h2x32(:,25),heltab2x64(:,:,145))
  call Hloop_Q_A(ntryL,G1H32(41),80,0,G2H32(7),n2h32(47))
  call Hloop_VQ_A(ntryL,G1H64(106),ex5(:),G1H32(42),m3h2x32(:,26),heltab2x64(:,:,146))
  call Hloop_Q_A(ntryL,G1H32(42),80,0,G2H32(8),n2h32(48))
  call Hloop_AQ_V(ntryL,G1H64(107),wf32(:,35),G1H2(28),m3h32x2(:,17),heltab2x64(:,:,147))
  call Hloop_VQ_A(ntryL,G1H64(108),wf32(:,35),G1H2(31),m3h32x2(:,18),heltab2x64(:,:,148))
  call Hloop_Q_A(ntryL,G1H2(31),95,0,G2H2(49),n2h2(69))
  call Hloop_AQ_V(ntryL,G1H64(109),ex5(:),G1H32(44),m3h2x32(:,27),heltab2x64(:,:,149))
  call Hloop_VQ_A(ntryL,G1H64(110),ex5(:),G1H32(45),m3h2x32(:,28),heltab2x64(:,:,150))
  call Hloop_Q_A(ntryL,G1H32(45),80,0,G2H32(9),n2h32(49))
  call ol_merge(ntryL,G2H2(26),[G2H2(29),G2H2(32),G2H2(35),G2H2(38),G2H2(41),G2H2(44),G2H2(14),G2H2(18),G2H2(4)])
  call ol_merge(ntryL,G2H2(49),[G2H2(47),G2H2(7),G2H2(8),G2H2(11),G2H2(12),G2H2(37),G2H2(40),G2H2(43),G2H2(48),G2H2(45),G2H2(42) &
    ,G2H2(39),G2H2(36),G2H2(33),G2H2(30),G2H2(27),G2H2(24),G2H2(6)])
call ol_merge_last(G1H4(4), G1H4(4)) 
  call ol_merge(ntryL,G2H4(30),[G1H4(4)])
call HGT_OLR(G2H4(30),1,1,4)
call HGT_invQ_OLR(G2H4(30),2,5,4)
call HGT_OLR(G2H4(30),6,15,4)
  call ol_merge(ntryL,G2H4(30),[G1H4(28)])
call ol_merge_last(G1H4(5), G1H4(5)) 
  call ol_merge(ntryL,G2H4(46),[G1H4(5)])
  call ol_merge(ntryL,G2H2(15),[G2H2(16),G2H2(10),G2H2(28),G2H2(31),G2H2(34),G2H2(46),G2H2(9),G2H2(21)])
call HGT_w2_OLR(G1H4(10),1,1,4)
call HGT_w2_invQ_OLR(G1H4(10),2,5,4)
  call ol_merge(ntryL,G1H4(10),[G1H4(29)])
  call ol_merge(ntryL,G2H4(6),[G1H4(74)])
call HGT_OLR(G2H4(10),1,1,4)
call HGT_invQ_OLR(G2H4(10),2,5,4)
call HGT_OLR(G2H4(10),6,15,4)
  call ol_merge(ntryL,G2H4(10),[G2H4(6)])
  call ol_merge(ntryL,G2H4(1),[G1H4(37),G1H4(7)])
  call ol_merge(ntryL,G2H4(5),[G1H4(78)])
call HGT_OLR(G2H4(19),1,1,4)
call HGT_invQ_OLR(G2H4(19),2,5,4)
call HGT_OLR(G2H4(19),6,15,4)
  call ol_merge(ntryL,G2H4(19),[G2H4(5)])
  call ol_merge(ntryL,G2H4(18),[G1H4(39)])
  call ol_merge(ntryL,G2H4(13),[G1H4(66)])
call HGT_OLR(G2H4(12),1,1,4)
call HGT_invQ_OLR(G2H4(12),2,5,4)
call HGT_OLR(G2H4(12),6,15,4)
  call ol_merge(ntryL,G2H4(12),[G2H4(13)])
  call ol_merge(ntryL,G2H4(9),[G1H4(43)])
  call ol_merge(ntryL,G2H4(4),[G1H4(70)])
call HGT_OLR(G2H4(20),1,1,4)
call HGT_invQ_OLR(G2H4(20),2,5,4)
call HGT_OLR(G2H4(20),6,15,4)
  call ol_merge(ntryL,G2H4(20),[G2H4(4)])
  call ol_merge(ntryL,G2H4(21),[G1H4(47)])
  call ol_merge(ntryL,G2H4(99),[G2H4(95),G2H4(91),G2H4(87),G2H4(81),G2H4(77),G2H4(73),G2H4(69),G2H4(65),G2H4(59),G2H4(53),G2H4(45) &
    ,G2H4(33),G2H4(47),G2H4(23),G1H4(75),G1H4(51)])
  call ol_merge(ntryL,G2H4(96),[G2H4(88),G2H4(82),G2H4(74),G2H4(66),G2H4(60),G2H4(55),G2H4(48),G2H4(36),G2H4(24),G2H4(27) &
    ,G1H4(55)])
  call ol_merge(ntryL,G2H4(101),[G2H4(97),G2H4(93),G2H4(89),G2H4(83),G2H4(79),G2H4(75),G2H4(71),G2H4(67),G2H4(61),G2H4(49) &
    ,G2H4(41),G2H4(29),G2H4(39),G2H4(31),G1H4(67),G1H4(59)])
  call ol_merge(ntryL,G2H4(102),[G2H4(94),G2H4(86),G2H4(80),G2H4(72),G2H4(64),G2H4(58),G2H4(52),G2H4(37),G2H4(25),G2H4(35) &
    ,G1H4(63)])
  call ol_merge(ntryL,G2H4(98),[G2H4(90),G2H4(84),G2H4(76),G2H4(68),G2H4(62),G2H4(56),G2H4(44),G2H4(32),G2H4(7),G2H4(43) &
    ,G1H4(71)])
  call ol_merge(ntryL,G2H4(100),[G2H4(92),G2H4(85),G2H4(78),G2H4(70),G2H4(63),G2H4(57),G2H4(54),G2H4(40),G2H4(28),G2H4(51) &
    ,G1H4(79)])
  call ol_merge(ntryL,G2H8(1),[G2H8(5)])
  call ol_merge(ntryL,G1H2(25),[G1H2(19)])
  call ol_merge(ntryL,G1H2(30),[G1H2(6)])
  call ol_merge(ntryL,G1H2(3),[G1H2(7)])
  call ol_merge(ntryL,G1H2(28),[G1H2(16),G1H2(5),G1H2(18),G1H2(21),G1H2(20),G1H2(27),G1H2(26),G1H2(15),G1H2(32),G1H2(8)])
  call ol_merge(ntryL,G1H2(11),[G1H2(14)])
  call ol_merge(ntryL,G2H4(3),[G1H4(32),G1H4(6)])
  call ol_merge(ntryL,G1H2(29),[G1H2(24)])
  call ol_merge(ntryL,G1H4(36),[G1H4(31)])
  call ol_merge(ntryL,G1H8(10),[G1H8(13)])
  call ol_merge(ntryL,G2H4(11),[G1H4(9)])
  call ol_merge(ntryL,G2H4(17),[G1H4(42)])
  call ol_merge(ntryL,G2H4(16),[G1H4(46)])
  call ol_merge(ntryL,G2H4(14),[G1H4(50)])
  call ol_merge(ntryL,G2H4(8),[G1H4(54)])
  call ol_merge(ntryL,G2H4(2),[G1H4(58)])
  call ol_merge(ntryL,G2H4(15),[G1H4(62)])
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(26),ex6(:),G2tensor(2),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(49),ex6(:),G2tensor(4),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hloop_QW_A(ntryL,G2H4(30),wf4(:,4),G2H1(1),m3h4x1(:,78),heltab2x4(:,:,88))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(13),n2h1(116))
call HGT_OLR(G2H4(46),1,1,4)
call HGT_invQ_OLR(G2H4(46),2,5,4)
call HGT_OLR(G2H4(46),6,15,4)
  call Hloop_AW_Q(ntryL,G2H4(46),wf4(:,5),G2H1(1),m3h4x1(:,79),heltab2x4(:,:,89))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(14),n2h1(117))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(15),ex5(:),G2tensor(88),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hloop_QW_A(ntryL,G1H4(10),wf4(:,4),G1H1(1),m3h4x1(:,80),heltab2x4(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(5),n2h1(118))
  call Hloop_AV_Q(ntryL,G2H4(10),wf4(:,9),G2H1(1),m3h4x1(:,81),heltab2x4(:,:,91))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(15),n2h1(119))
  call Hloop_AW_Q(ntryL,G2H4(1),wf4(:,4),G2H1(1),m3h4x1(:,82),heltab2x4(:,:,92))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(16),n2h1(120))
  call Hloop_AV_Q(ntryL,G2H4(19),wf4(:,9),G2H1(1),m3h4x1(:,83),heltab2x4(:,:,93))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(17),n2h1(121))
  call Hloop_AW_Q(ntryL,G2H4(18),wf4(:,4),G2H1(1),m3h4x1(:,84),heltab2x4(:,:,94))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(18),n2h1(122))
  call Hloop_QV_A(ntryL,G2H4(12),wf4(:,9),G2H1(1),m3h4x1(:,85),heltab2x4(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(19),n2h1(123))
  call Hloop_QW_A(ntryL,G2H4(9),wf4(:,4),G2H1(1),m3h4x1(:,86),heltab2x4(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(20),n2h1(124))
  call Hloop_QV_A(ntryL,G2H4(20),wf4(:,9),G2H1(1),m3h4x1(:,87),heltab2x4(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(21),n2h1(125))
  call Hloop_QW_A(ntryL,G2H4(21),wf4(:,4),G2H1(1),m3h4x1(:,88),heltab2x4(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(22),n2h1(126))
call HGT_OLR(G2H4(22),1,1,4)
call HGT_invQ_OLR(G2H4(22),2,5,4)
call HGT_OLR(G2H4(22),6,15,4)
  call Hloop_AW_Q(ntryL,G2H4(22),wf4(:,4),G2H1(1),m3h4x1(:,89),heltab2x4(:,:,99))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(23),n2h1(127))
  call Hloop_AV_Q(ntryL,G2H4(99),wf4(:,9),G2H1(1),m3h4x1(:,90),heltab2x4(:,:,100))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(24),n2h1(128))
call HGT_OLR(G2H4(26),1,1,4)
call HGT_invQ_OLR(G2H4(26),2,5,4)
call HGT_OLR(G2H4(26),6,15,4)
  call Hloop_AW_Q(ntryL,G2H4(26),wf4(:,4),G2H1(1),m3h4x1(:,91),heltab2x4(:,:,101))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(25),n2h1(129))
  call Hloop_AV_Q(ntryL,G2H4(96),wf4(:,9),G2H1(1),m3h4x1(:,92),heltab2x4(:,:,102))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(26),n2h1(130))
  call Hloop_QV_A(ntryL,G2H4(101),wf4(:,9),G2H1(1),m3h4x1(:,93),heltab2x4(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(27),n2h1(131))
call HGT_OLR(G2H4(34),1,1,4)
call HGT_invQ_OLR(G2H4(34),2,5,4)
call HGT_OLR(G2H4(34),6,15,4)
  call Hloop_QW_A(ntryL,G2H4(34),wf4(:,4),G2H1(1),m3h4x1(:,94),heltab2x4(:,:,104))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(28),n2h1(132))
  call Hloop_QV_A(ntryL,G2H4(102),wf4(:,9),G2H1(1),m3h4x1(:,95),heltab2x4(:,:,105))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(29),n2h1(133))
call HGT_OLR(G2H4(38),1,1,4)
call HGT_invQ_OLR(G2H4(38),2,5,4)
call HGT_OLR(G2H4(38),6,15,4)
  call Hloop_QW_A(ntryL,G2H4(38),wf4(:,5),G2H1(1),m3h4x1(:,96),heltab2x4(:,:,106))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(30),n2h1(134))
call HGT_OLR(G2H4(42),1,1,4)
call HGT_invQ_OLR(G2H4(42),2,5,4)
call HGT_OLR(G2H4(42),6,15,4)
  call Hloop_QW_A(ntryL,G2H4(42),wf4(:,5),G2H1(1),m3h4x1(:,97),heltab2x4(:,:,107))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(31),n2h1(135))
  call Hloop_QV_A(ntryL,G2H4(98),wf4(:,9),G2H1(1),m3h4x1(:,98),heltab2x4(:,:,108))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(32),n2h1(136))
call HGT_OLR(G2H4(50),1,1,4)
call HGT_invQ_OLR(G2H4(50),2,5,4)
call HGT_OLR(G2H4(50),6,15,4)
  call Hloop_AW_Q(ntryL,G2H4(50),wf4(:,5),G2H1(1),m3h4x1(:,99),heltab2x4(:,:,109))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(33),n2h1(137))
  call Hloop_AV_Q(ntryL,G2H4(100),wf4(:,9),G2H1(1),m3h4x1(:,100),heltab2x4(:,:,110))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(34),n2h1(138))
call HGT_w2_OLR(G1H4(25),1,1,4)
call HGT_w2_invQ_OLR(G1H4(25),2,5,4)
  call Hloop_QW_A(ntryL,G1H4(25),wf4(:,5),G1H1(1),m3h4x1(:,101),heltab2x4(:,:,111))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(8),n2h1(139))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(1),wf8(:,2),G2tensor(100),m3h8x1(:,9),heltab2x8(:,:,41))
call HGT_w2_OLR(G1H16(8),1,1,16)
call HGT_w2_invQ_OLR(G1H16(8),2,5,16)
  call Hloop_QV_A(ntryL,G1H16(8),wf16(:,2),G1H1(1),m3h16x1(:,1),heltab2x16(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(9),n2h1(140))
call HGT_w2_OLR(G1H16(10),1,1,16)
call HGT_w2_invQ_OLR(G1H16(10),2,5,16)
  call Hloop_QZ_A(ntryL,G1H16(10),wf16(:,12),G1H1(1),ngZd,m3h16x1(:,2),heltab2x16(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(12),n2h1(141))
call HGT_w2_OLR(G1H16(12),1,1,16)
call HGT_w2_invQ_OLR(G1H16(12),2,5,16)
  call Hloop_QV_A(ntryL,G1H16(12),wf16(:,5),G1H1(1),m3h16x1(:,3),heltab2x16(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(13),n2h1(142))
call HGT_w2_OLR(G1H16(3),1,1,16)
call HGT_w2_invQ_OLR(G1H16(3),2,5,16)
  call Hloop_QZ_A(ntryL,G1H16(3),wf16(:,27),G1H1(1),ngZd,m3h16x1(:,4),heltab2x16(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(52),n2h1(143))
call HGT_w2_OLR(G1H16(9),1,1,16)
call HGT_w2_invQ_OLR(G1H16(9),2,5,16)
  call Hloop_QZ_A(ntryL,G1H16(9),wf16(:,28),G1H1(1),ngZd,m3h16x1(:,5),heltab2x16(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(29),n2h1(144))
call HGT_w2_OLR(G1H16(2),1,1,16)
call HGT_w2_invQ_OLR(G1H16(2),2,5,16)
  call Hloop_QV_A(ntryL,G1H16(2),wf16(:,8),G1H1(1),m3h16x1(:,6),heltab2x16(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(33),n2h1(145))
call HGT_w2_OLR(G1H16(5),1,1,16)
call HGT_w2_invQ_OLR(G1H16(5),2,5,16)
  call Hloop_QZ_A(ntryL,G1H16(5),wf16(:,29),G1H1(1),ngZd,m3h16x1(:,7),heltab2x16(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(37),n2h1(146))
call HGT_w2_OLR(G1H16(6),1,1,16)
call HGT_w2_invQ_OLR(G1H16(6),2,5,16)
  call Hloop_QZ_A(ntryL,G1H16(6),wf16(:,30),G1H1(1),ngZd,m3h16x1(:,8),heltab2x16(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(41),n2h1(147))
  call Hloop_VQ_A(ntryL,G1H2(25),ex5(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(25),n2h1(148))
  call Hloop_VQ_A(ntryL,G1H2(30),ex5(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(94),n2h1(149))
  call Hloop_VA_Q(ntryL,G1H2(3),ex6(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(26),n2h1(150))
  call Hloop_VA_Q(ntryL,G1H2(28),ex6(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(106),n2h1(151))
  call Hloop_VA_Q(ntryL,G1H2(11),ex6(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(49),n2h1(152))
  call Hloop_AW_Q(ntryL,G2H4(3),wf4(:,4),G2H1(1),m3h4x1(:,102),heltab2x4(:,:,112))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(35),n2h1(153))
  call Hloop_VQ_A(ntryL,G1H2(29),ex5(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(76),n2h1(154))
  call Hloop_AW_Q(ntryL,G1H4(36),wf4(:,4),G1H1(1),m3h4x1(:,103),heltab2x4(:,:,113))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(55),n2h1(155))
  call Hloop_VQ_A(ntryL,G1H8(20),wf8(:,7),G1H1(1),m3h8x1(:,10),heltab2x8(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(28),n2h1(156))
  call Hloop_VQ_A(ntryL,G1H8(21),wf8(:,7),G1H1(1),m3h8x1(:,11),heltab2x8(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(1),n2h1(157))
  call Hloop_VA_Q(ntryL,G1H8(8),wf8(:,2),G1H1(1),m3h8x1(:,12),heltab2x8(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(58),n2h1(158))
  call Hloop_VA_Q(ntryL,G1H8(10),wf8(:,2),G1H1(1),m3h8x1(:,13),heltab2x8(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(61),n2h1(159))
  call Hloop_AW_Q(ntryL,G2H4(11),wf4(:,4),G2H1(1),m3h4x1(:,104),heltab2x4(:,:,114))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(36),n2h1(160))
  call Hloop_QW_A(ntryL,G2H4(17),wf4(:,4),G2H1(1),m3h4x1(:,105),heltab2x4(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(37),n2h1(161))
  call Hloop_QW_A(ntryL,G2H4(16),wf4(:,4),G2H1(1),m3h4x1(:,106),heltab2x4(:,:,116))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(38),n2h1(162))
  call Hloop_AV_Q(ntryL,G2H4(14),wf4(:,9),G2H1(1),m3h4x1(:,107),heltab2x4(:,:,117))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,0,G3tensor(39),n2h1(163))
  call Hloop_AV_Q(ntryL,G2H4(8),wf4(:,9),G2H1(1),m3h4x1(:,108),heltab2x4(:,:,118))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),127,nMT,G3tensor(40),n2h1(164))
  call Hloop_QV_A(ntryL,G2H4(2),wf4(:,9),G2H1(1),m3h4x1(:,109),heltab2x4(:,:,119))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,0,G3tensor(41),n2h1(165))
  call Hloop_QV_A(ntryL,G2H4(15),wf4(:,9),G2H1(1),m3h4x1(:,110),heltab2x4(:,:,120))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),127,nMB,G3tensor(42),n2h1(166))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(2),ex6(:),G2tensor(43),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(5),ex5(:),G2tensor(64),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(3),wf8(:,2),G2tensor(46),m3h8x1(:,14),heltab2x8(:,:,46))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(7),wf8(:,7),G2tensor(67),m3h8x1(:,15),heltab2x8(:,:,47))
  call Hloop_VA_Q(ntryL,G1H32(24),wf32(:,5),G1H1(1),m3h32x1(:,1),heltab2x32(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(70),n2h1(167))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H32(1),wf32(:,5),G2tensor(82),m3h32x1(:,2),heltab2x32(:,:,63))
  call Hloop_VA_Q(ntryL,G1H32(26),wf32(:,11),G1H1(1),m3h32x1(:,3),heltab2x32(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(31),n2h1(168))
  call Hloop_VA_Q(ntryL,G1H32(27),wf32(:,13),G1H1(1),m3h32x1(:,4),heltab2x32(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(30),n2h1(169))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H32(2),wf32(:,11),G2tensor(32),m3h32x1(:,5),heltab2x32(:,:,66))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H32(3),wf32(:,13),G2tensor(35),m3h32x1(:,6),heltab2x32(:,:,67))
  call Hloop_VA_Q(ntryL,G1H32(31),wf32(:,19),G1H1(1),m3h32x1(:,7),heltab2x32(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(34),n2h1(170))
  call Hloop_VA_Q(ntryL,G1H32(32),wf32(:,21),G1H1(1),m3h32x1(:,8),heltab2x32(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(36),n2h1(171))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H32(4),wf32(:,19),G2tensor(39),m3h32x1(:,9),heltab2x32(:,:,70))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H32(5),wf32(:,21),G2tensor(38),m3h32x1(:,10),heltab2x32(:,:,71))
  call Hloop_VA_Q(ntryL,G1H32(36),wf32(:,25),G1H1(1),m3h32x1(:,11),heltab2x32(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(40),n2h1(172))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H32(6),wf32(:,25),G2tensor(73),m3h32x1(:,12),heltab2x32(:,:,73))
  call Hloop_VA_Q(ntryL,G1H32(39),wf32(:,31),G1H1(1),m3h32x1(:,13),heltab2x32(:,:,74))



end subroutine vamp_1

end module ol_vamp_1_ppllllj_nenmxexmddxg_1_/**/REALKIND
