
module ol_vamp_1_ppllllj_neeexexuxdg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllllj_neeexexuxdg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllllj_neeexexuxdg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppllllj_neeexexuxdg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppllllj_neeexexuxdg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppllllj_neeexexuxdg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppllllj_neeexexuxdg_1_/**/DREALKIND, only: ntryL, p_switch, Hel
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(128)
  type(Hpolcont), intent(in) :: M(1,128)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1),h0tab(:,1),[64,10,5,32,16],[0,0,0,0,0],5,2,wf4(:,2),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1),heltab2x128(:,:,1))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(1),n2h64(1))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(21)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(2),h0tab(:,2),[64,10,5,32,16],[0,0,0,0,0],5,2,wf4(:,7),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,2),heltab2x128(:,:,2))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(2),n2h64(2))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(3),h0tab(:,3),[64,5,10,32,16],[0,0,0,0,0],5,2,wf4(:,4),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,3),heltab2x128(:,:,3))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(3),n2h64(3))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(21)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(4),h0tab(:,4),[64,5,10,32,16],[0,0,0,0,0],5,2,wf4(:,4),wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,4),heltab2x128(:,:,4))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(4),n2h64(4))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(5),h0tab(:,5),[64,10,5,16,32],[0,0,0,0,0],5,2,wf4(:,2),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,5),heltab2x128(:,:,5))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(5),n2h64(5))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(21)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(6),h0tab(:,6),[64,10,5,16,32],[0,0,0,0,0],5,2,wf4(:,7),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,6),heltab2x128(:,:,6))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(6),n2h64(6))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(7),h0tab(:,7),[64,5,16,32,10],[0,0,0,0,0],5,2,wf4(:,4),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,7),heltab2x128(:,:,7))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(7),n2h64(7))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(21)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(8),h0tab(:,8),[64,5,16,32,10],[0,0,0,0,0],5,2,wf4(:,4),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,8),heltab2x128(:,:,8))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(8),n2h64(8))
Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(9),h0tab(:,9),[64,5,10,16,32],[0,0,0,0,0],5,2,wf4(:,4),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,9),heltab2x128(:,:,9))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(9),n2h64(9))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(21)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(10),h0tab(:,10),[64,5,10,16,32],[0,0,0,0,0],5,2,wf4(:,4),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,10),heltab2x128(:,:,10))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(10),n2h64(10))
Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(11),h0tab(:,11),[64,5,32,16,10],[0,0,0,0,0],5,2,wf4(:,4),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,11),heltab2x128(:,:,11))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(11),n2h64(11))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(21)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(12),h0tab(:,12),[64,5,32,16,10],[0,0,0,0,0],5,2,wf4(:,4),wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,12),heltab2x128(:,:,12))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(12),n2h64(12))
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(13),h0tab(:,13),[64,16,5,10,32],[0,0,0,0,0],5,2,wf4(:,4),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(13),m3h2x64(:,13),heltab2x128(:,:,13))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(21)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(14),h0tab(:,14),[64,16,5,10,32],[0,0,0,0,0],5,2,wf4(:,4),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(14),m3h2x64(:,14),heltab2x128(:,:,14))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(15),h0tab(:,15),[64,16,10,5,32],[0,0,0,0,0],5,2,wf4(:,2),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(15),m3h2x64(:,15),heltab2x128(:,:,15))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(21)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(16),h0tab(:,16),[64,16,10,5,32],[0,0,0,0,0],5,2,wf4(:,7),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(16),m3h2x64(:,16),heltab2x128(:,:,16))
Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(62)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(17),h0tab(:,17),[64,6,9,32,16],[0,0,0,0,0],5,2,wf4(:,11),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,17),heltab2x128(:,:,17))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(17),n2h64(13))
Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(64)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(18),h0tab(:,18),[64,6,9,32,16],[0,0,0,0,0],5,2,wf4(:,14),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,18),heltab2x128(:,:,18))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(18),n2h64(14))
Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(62)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(19),h0tab(:,19),[64,9,6,32,16],[0,0,0,0,0],5,2,wf4(:,12),wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,19),heltab2x128(:,:,19))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(19),n2h64(15))
Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(64)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(20),h0tab(:,20),[64,9,6,32,16],[0,0,0,0,0],5,2,wf4(:,12),wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,20),heltab2x128(:,:,20))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(20),n2h64(16))
Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(62)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(21),h0tab(:,21),[64,6,9,16,32],[0,0,0,0,0],5,2,wf4(:,11),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,21),heltab2x128(:,:,21))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(21),n2h64(17))
Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(64)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(22),h0tab(:,22),[64,6,9,16,32],[0,0,0,0,0],5,2,wf4(:,14),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,22),heltab2x128(:,:,22))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(22),n2h64(18))
Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(62)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(23),h0tab(:,23),[64,6,32,16,9],[0,0,0,0,0],5,2,wf4(:,11),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,23),heltab2x128(:,:,23))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(23),n2h64(19))
Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(64)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(24),h0tab(:,24),[64,6,32,16,9],[0,0,0,0,0],5,2,wf4(:,14),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,24),heltab2x128(:,:,24))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(24),n2h64(20))
Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(62)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(25),h0tab(:,25),[64,9,6,16,32],[0,0,0,0,0],5,2,wf4(:,12),wf4(:,11))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,25),heltab2x128(:,:,25))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(25),n2h64(21))
Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(64)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(26),h0tab(:,26),[64,9,6,16,32],[0,0,0,0,0],5,2,wf4(:,12),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,26),heltab2x128(:,:,26))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(26),n2h64(22))
Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(62)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(27),h0tab(:,27),[64,6,16,32,9],[0,0,0,0,0],5,2,wf4(:,11),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,27),heltab2x128(:,:,27))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(27),n2h64(23))
Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(64)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(28),h0tab(:,28),[64,6,16,32,9],[0,0,0,0,0],5,2,wf4(:,14),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,28),heltab2x128(:,:,28))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(28),n2h64(24))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(62)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(29),h0tab(:,29),[64,16,9,6,32],[0,0,0,0,0],5,2,wf4(:,12),wf4(:,11))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(29),m3h2x64(:,29),heltab2x128(:,:,29))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(64)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(30),h0tab(:,30),[64,16,9,6,32],[0,0,0,0,0],5,2,wf4(:,12),wf4(:,14))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(30),m3h2x64(:,30),heltab2x128(:,:,30))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(62)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(31),h0tab(:,31),[64,16,6,9,32],[0,0,0,0,0],5,2,wf4(:,11),wf4(:,12))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(31),m3h2x64(:,31),heltab2x128(:,:,31))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(64)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(32),h0tab(:,32),[64,16,6,9,32],[0,0,0,0,0],5,2,wf4(:,14),wf4(:,12))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(32),m3h2x64(:,32),heltab2x128(:,:,32))
  call Hloop_AV_Q(ntryL,G1H64(1),wf4(:,2),G1H16(1),m3h4x16(:,1),heltab2x64(:,:,1))
  call Hloop_A_Q(ntryL,G1H16(1),74,0,G2H16(1),n2h16(1))
  call Hloop_AZ_Q(ntryL,G1H64(2),wf4(:,7),G1H16(1),ngZu,m3h4x16(:,2),heltab2x64(:,:,2))
  call Hloop_A_Q(ntryL,G1H16(1),74,0,G2H16(2),n2h16(2))
  call Hloop_AW_Q(ntryL,G1H64(3),wf4(:,4),G1H16(1),m3h4x16(:,3),heltab2x64(:,:,3))
  call Hloop_A_Q(ntryL,G1H16(1),69,0,G2H16(3),n2h16(3))
  call Hloop_AW_Q(ntryL,G1H64(4),wf4(:,4),G1H16(1),m3h4x16(:,4),heltab2x64(:,:,4))
  call Hloop_A_Q(ntryL,G1H16(1),69,0,G2H16(4),n2h16(4))
  call Hloop_QV_A(ntryL,G1H64(5),wf4(:,2),G1H16(1),m3h4x16(:,5),heltab2x64(:,:,5))
  call Hloop_Q_A(ntryL,G1H16(1),74,0,G2H16(5),n2h16(5))
  call Hloop_QZ_A(ntryL,G1H64(6),wf4(:,7),G1H16(1),ngZd,m3h4x16(:,6),heltab2x64(:,:,6))
  call Hloop_Q_A(ntryL,G1H16(1),74,0,G2H16(6),n2h16(6))
  call Hloop_QW_A(ntryL,G1H64(7),wf4(:,4),G1H16(1),m3h4x16(:,7),heltab2x64(:,:,7))
  call Hloop_Q_A(ntryL,G1H16(1),69,0,G2H16(7),n2h16(7))
  call Hloop_QW_A(ntryL,G1H64(8),wf4(:,4),G1H16(1),m3h4x16(:,8),heltab2x64(:,:,8))
  call Hloop_Q_A(ntryL,G1H16(1),69,0,G2H16(8),n2h16(8))
  call Hloop_QW_A(ntryL,G1H64(9),wf4(:,4),G1H16(1),m3h4x16(:,9),heltab2x64(:,:,9))
  call Hloop_Q_A(ntryL,G1H16(1),69,0,G2H16(9),n2h16(9))
  call Hloop_QW_A(ntryL,G1H64(10),wf4(:,4),G1H16(1),m3h4x16(:,10),heltab2x64(:,:,10))
  call Hloop_Q_A(ntryL,G1H16(1),69,0,G2H16(10),n2h16(10))
  call Hloop_AW_Q(ntryL,G1H64(11),wf4(:,4),G1H16(1),m3h4x16(:,11),heltab2x64(:,:,11))
  call Hloop_A_Q(ntryL,G1H16(1),69,0,G2H16(11),n2h16(11))
  call Hloop_AW_Q(ntryL,G1H64(12),wf4(:,4),G1H16(1),m3h4x16(:,12),heltab2x64(:,:,12))
  call Hloop_A_Q(ntryL,G1H16(1),69,0,G2H16(12),n2h16(12))
  call Hloop_VA_Q(ntryL,G1H64(13),ex5(:),G1H32(1),m3h2x32(:,1),heltab2x64(:,:,13))
  call Hloop_A_Q(ntryL,G1H32(1),80,0,G2H32(1),n2h32(1))
  call Hloop_VA_Q(ntryL,G1H64(14),ex5(:),G1H32(1),m3h2x32(:,2),heltab2x64(:,:,14))
  call Hloop_A_Q(ntryL,G1H32(1),80,0,G2H32(2),n2h32(2))
  call Hloop_VA_Q(ntryL,G1H64(15),ex5(:),G1H32(1),m3h2x32(:,3),heltab2x64(:,:,15))
  call Hloop_A_Q(ntryL,G1H32(1),80,0,G2H32(3),n2h32(3))
  call Hloop_VA_Q(ntryL,G1H64(16),ex5(:),G1H32(1),m3h2x32(:,4),heltab2x64(:,:,16))
  call Hloop_A_Q(ntryL,G1H32(1),80,0,G2H32(4),n2h32(4))
  call Hloop_AV_Q(ntryL,G1H64(17),wf4(:,11),G1H16(1),m3h4x16(:,13),heltab2x64(:,:,17))
  call Hloop_A_Q(ntryL,G1H16(1),70,0,G2H16(13),n2h16(13))
  call Hloop_AZ_Q(ntryL,G1H64(18),wf4(:,14),G1H16(1),ngZu,m3h4x16(:,14),heltab2x64(:,:,18))
  call Hloop_A_Q(ntryL,G1H16(1),70,0,G2H16(14),n2h16(14))
  call Hloop_AW_Q(ntryL,G1H64(19),wf4(:,12),G1H16(1),m3h4x16(:,15),heltab2x64(:,:,19))
  call Hloop_A_Q(ntryL,G1H16(1),73,0,G2H16(15),n2h16(15))
  call Hloop_AW_Q(ntryL,G1H64(20),wf4(:,12),G1H16(1),m3h4x16(:,16),heltab2x64(:,:,20))
  call Hloop_A_Q(ntryL,G1H16(1),73,0,G2H16(16),n2h16(16))
  call Hloop_QV_A(ntryL,G1H64(21),wf4(:,11),G1H16(1),m3h4x16(:,17),heltab2x64(:,:,21))
  call Hloop_Q_A(ntryL,G1H16(1),70,0,G2H16(17),n2h16(17))
  call Hloop_QZ_A(ntryL,G1H64(22),wf4(:,14),G1H16(1),ngZd,m3h4x16(:,18),heltab2x64(:,:,22))
  call Hloop_Q_A(ntryL,G1H16(1),70,0,G2H16(18),n2h16(18))
  call Hloop_AV_Q(ntryL,G1H64(23),wf4(:,11),G1H16(1),m3h4x16(:,19),heltab2x64(:,:,23))
  call Hloop_A_Q(ntryL,G1H16(1),70,0,G2H16(19),n2h16(19))
  call Hloop_AZ_Q(ntryL,G1H64(24),wf4(:,14),G1H16(1),ngZd,m3h4x16(:,20),heltab2x64(:,:,24))
  call Hloop_A_Q(ntryL,G1H16(1),70,0,G2H16(20),n2h16(20))
  call Hloop_QW_A(ntryL,G1H64(25),wf4(:,12),G1H16(1),m3h4x16(:,21),heltab2x64(:,:,25))
  call Hloop_Q_A(ntryL,G1H16(1),73,0,G2H16(21),n2h16(21))
  call Hloop_QW_A(ntryL,G1H64(26),wf4(:,12),G1H16(1),m3h4x16(:,22),heltab2x64(:,:,26))
  call Hloop_Q_A(ntryL,G1H16(1),73,0,G2H16(22),n2h16(22))
  call Hloop_QV_A(ntryL,G1H64(27),wf4(:,11),G1H16(1),m3h4x16(:,23),heltab2x64(:,:,27))
  call Hloop_Q_A(ntryL,G1H16(1),70,0,G2H16(23),n2h16(23))
  call Hloop_QZ_A(ntryL,G1H64(28),wf4(:,14),G1H16(1),ngZu,m3h4x16(:,24),heltab2x64(:,:,28))
  call Hloop_Q_A(ntryL,G1H16(1),70,0,G2H16(24),n2h16(24))
  call Hloop_VA_Q(ntryL,G1H64(29),ex5(:),G1H32(1),m3h2x32(:,5),heltab2x64(:,:,29))
  call Hloop_A_Q(ntryL,G1H32(1),80,0,G2H32(5),n2h32(5))
  call Hloop_VA_Q(ntryL,G1H64(30),ex5(:),G1H32(1),m3h2x32(:,6),heltab2x64(:,:,30))
  call Hloop_A_Q(ntryL,G1H32(1),80,0,G2H32(6),n2h32(6))
  call Hloop_VA_Q(ntryL,G1H64(31),ex5(:),G1H32(1),m3h2x32(:,7),heltab2x64(:,:,31))
  call Hloop_A_Q(ntryL,G1H32(1),80,0,G2H32(7),n2h32(7))
  call Hloop_VA_Q(ntryL,G1H64(32),ex5(:),G1H32(1),m3h2x32(:,8),heltab2x64(:,:,32))
  call Hloop_A_Q(ntryL,G1H32(1),80,0,G2H32(8),n2h32(8))
  call ol_merge(ntryL,G2H16(2),[G2H16(1)])
  call ol_merge(ntryL,G2H16(6),[G2H16(5)])
  call ol_merge(ntryL,G2H16(14),[G2H16(13)])
  call ol_merge(ntryL,G2H16(18),[G2H16(17)])
  call ol_merge(ntryL,G2H16(20),[G2H16(19)])
  call ol_merge(ntryL,G2H16(24),[G2H16(23)])
call Hotf_5pt_reduction(G2H16(2),RedSet_5(1),mass5set(:,1),  & 
G1H16(1),G1H16(2),G1H16(3),G1H16(4),G1H16(5),G1H16(6),16)
call HG1shiftOLR(G1H16(2),16,16)
call Hotf_5pt_reduction(G2H16(3),RedSet_5(2),mass5set(:,1),  & 
G1H16(7),G1H16(8),G1H16(9),G1H16(10),G1H16(11),G1H16(12),16)
call HG1shiftOLR(G1H16(8),16,16)
call Hotf_5pt_reduction(G2H16(4),RedSet_5(2),mass5set(:,1),  & 
G1H16(13),G1H16(14),G1H16(15),G1H16(16),G1H16(17),G1H16(18),16)
call HG1shiftOLR(G1H16(14),16,16)
call Hotf_5pt_reduction(G2H16(6),RedSet_5(3),mass5set(:,1),  & 
G1H16(19),G1H16(20),G1H16(21),G1H16(22),G1H16(23),G1H16(24),16)
call HG1shiftOLR(G1H16(20),32,16)
  call Hloop_QA_V(ntryL,G2H16(7),ex5(:),G2H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_QA_V(ntryL,G2H16(8),ex5(:),G2H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
call Hotf_5pt_reduction(G2H16(9),RedSet_5(4),mass5set(:,1),  & 
G1H16(25),G1H16(26),G1H16(27),G1H16(28),G1H16(29),G1H16(30),16)
call HG1shiftOLR(G1H16(26),32,16)
call Hotf_5pt_reduction(G2H16(10),RedSet_5(4),mass5set(:,1),  & 
G1H16(31),G1H16(32),G1H16(33),G1H16(34),G1H16(35),G1H16(36),16)
call HG1shiftOLR(G1H16(32),32,16)
  call Hloop_AQ_V(ntryL,G2H16(11),ex6(:),G2H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_AQ_V(ntryL,G2H16(12),ex6(:),G2H8(4),m3h2x8(:,4),heltab2x16(:,:,4))
call Hotf_5pt_reduction(G2H32(1),RedSet_5(5),mass5set(:,1),  & 
G1H32(1),G1H32(2),G1H32(3),G1H32(4),G1H32(5),G1H32(6),32)
call HG1shiftOLR(G1H32(2),32,32)
call Hotf_5pt_reduction(G2H32(2),RedSet_5(5),mass5set(:,1),  & 
G1H32(7),G1H32(8),G1H32(9),G1H32(10),G1H32(11),G1H32(12),32)
call HG1shiftOLR(G1H32(8),32,32)
call Hotf_5pt_reduction(G2H32(3),RedSet_5(6),mass5set(:,1),  & 
G1H32(13),G1H32(14),G1H32(15),G1H32(16),G1H32(17),G1H32(18),32)
call HG1shiftOLR(G1H32(14),32,32)
call Hotf_5pt_reduction(G2H32(4),RedSet_5(6),mass5set(:,1),  & 
G1H32(19),G1H32(20),G1H32(21),G1H32(22),G1H32(23),G1H32(24),32)
call HG1shiftOLR(G1H32(20),32,32)
call Hotf_5pt_reduction(G2H16(14),RedSet_5(7),mass5set(:,1),  & 
G1H16(37),G1H16(38),G1H16(39),G1H16(40),G1H16(41),G1H16(42),16)
call HG1shiftOLR(G1H16(38),16,16)
call Hotf_5pt_reduction(G2H16(15),RedSet_5(8),mass5set(:,1),  & 
G1H16(43),G1H16(44),G1H16(45),G1H16(46),G1H16(47),G1H16(48),16)
call HG1shiftOLR(G1H16(44),16,16)
call Hotf_5pt_reduction(G2H16(16),RedSet_5(8),mass5set(:,1),  & 
G1H16(49),G1H16(50),G1H16(51),G1H16(52),G1H16(53),G1H16(54),16)
call HG1shiftOLR(G1H16(50),16,16)
call Hotf_5pt_reduction(G2H16(18),RedSet_5(9),mass5set(:,1),  & 
G1H16(55),G1H16(56),G1H16(57),G1H16(58),G1H16(59),G1H16(60),16)
call HG1shiftOLR(G1H16(56),32,16)
  call Hloop_AQ_V(ntryL,G2H16(20),ex6(:),G2H8(5),m3h2x8(:,5),heltab2x16(:,:,5))
call Hotf_5pt_reduction(G2H16(21),RedSet_5(10),mass5set(:,1),  & 
G1H16(61),G1H16(62),G1H16(63),G1H16(64),G1H16(65),G1H16(66),16)
call HG1shiftOLR(G1H16(62),32,16)
call Hotf_5pt_reduction(G2H16(22),RedSet_5(10),mass5set(:,1),  & 
G1H16(67),G1H16(68),G1H16(69),G1H16(70),G1H16(71),G1H16(72),16)
call HG1shiftOLR(G1H16(68),32,16)
  call Hloop_QA_V(ntryL,G2H16(24),ex5(:),G2H8(6),m3h2x8(:,6),heltab2x16(:,:,6))
call Hotf_5pt_reduction(G2H32(5),RedSet_5(11),mass5set(:,1),  & 
G1H32(25),G1H32(26),G1H32(27),G1H32(28),G1H32(29),G1H32(30),32)
call HG1shiftOLR(G1H32(26),32,32)
call Hotf_5pt_reduction(G2H32(6),RedSet_5(11),mass5set(:,1),  & 
G1H32(31),G1H32(32),G1H32(33),G1H32(34),G1H32(35),G1H32(36),32)
call HG1shiftOLR(G1H32(32),32,32)
call Hotf_5pt_reduction(G2H32(7),RedSet_5(12),mass5set(:,1),  & 
G1H32(37),G1H32(38),G1H32(39),G1H32(40),G1H32(41),G1H32(42),32)
call HG1shiftOLR(G1H32(38),32,32)
call Hotf_5pt_reduction(G2H32(8),RedSet_5(12),mass5set(:,1),  & 
G1H32(43),G1H32(44),G1H32(45),G1H32(46),G1H32(47),G1H32(48),32)
call HG1shiftOLR(G1H32(44),32,32)
  call Hloop_AW_Q(ntryL,G1H16(1),wf4(:,4),G1H4(1),m3h4x4(:,1),heltab2x16(:,:,7))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(1),n2h4(1))
call HGT_OLR(G1H16(2),1,1,16)
call HGT_invQ_OLR(G1H16(2),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(2),-16,0,G2H16(1),n2h16(25))
  call Hloop_QA_V(ntryL,G2H16(1),ex5(:),G2H8(7),m3h2x8(:,7),heltab2x16(:,:,8))
  call Hloop_AW_Q(ntryL,G1H16(4),wf4(:,4),G1H4(1),m3h4x4(:,2),heltab2x16(:,:,9))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(2),n2h4(2))
  call Hloop_AW_Q(ntryL,G1H16(5),wf4(:,4),G1H4(1),m3h4x4(:,3),heltab2x16(:,:,10))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(3),n2h4(3))
  call Hloop_AW_Q(ntryL,G1H16(6),wf4(:,4),G1H4(1),m3h4x4(:,4),heltab2x16(:,:,11))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(4),n2h4(4))
  call Hloop_AV_Q(ntryL,G1H16(7),wf4(:,2),G1H4(1),m3h4x4(:,5),heltab2x16(:,:,12))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(5),n2h4(5))
call HGT_OLR(G1H16(8),1,1,16)
call HGT_invQ_OLR(G1H16(8),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(8),-16,0,G2H16(5),n2h16(26))
  call Hloop_QA_V(ntryL,G2H16(5),ex5(:),G2H8(8),m3h2x8(:,8),heltab2x16(:,:,13))
  call Hloop_AV_Q(ntryL,G1H16(10),wf4(:,2),G1H4(1),m3h4x4(:,6),heltab2x16(:,:,14))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(6),n2h4(6))
  call Hloop_AV_Q(ntryL,G1H16(11),wf4(:,2),G1H4(1),m3h4x4(:,7),heltab2x16(:,:,15))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(7),n2h4(7))
  call Hloop_AV_Q(ntryL,G1H16(12),wf4(:,2),G1H4(1),m3h4x4(:,8),heltab2x16(:,:,16))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(8),n2h4(8))
  call Hloop_AZ_Q(ntryL,G1H16(13),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,9),heltab2x16(:,:,17))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(9),n2h4(9))
call HGT_OLR(G1H16(14),1,1,16)
call HGT_invQ_OLR(G1H16(14),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(14),-16,0,G2H16(13),n2h16(27))
  call Hloop_QA_V(ntryL,G2H16(13),ex5(:),G2H8(9),m3h2x8(:,9),heltab2x16(:,:,18))
  call Hloop_AZ_Q(ntryL,G1H16(16),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,10),heltab2x16(:,:,19))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(10),n2h4(10))
  call Hloop_AZ_Q(ntryL,G1H16(17),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,11),heltab2x16(:,:,20))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(11),n2h4(11))
  call Hloop_AZ_Q(ntryL,G1H16(18),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,12),heltab2x16(:,:,21))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(12),n2h4(12))
  call Hloop_QW_A(ntryL,G1H16(19),wf4(:,4),G1H4(1),m3h4x4(:,13),heltab2x16(:,:,22))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(13),n2h4(13))
call HGT_OLR(G1H16(20),1,1,16)
call HGT_invQ_OLR(G1H16(20),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(20),-32,0,G2H16(17),n2h16(28))
  call Hloop_AQ_V(ntryL,G2H16(17),ex6(:),G2H8(10),m3h2x8(:,10),heltab2x16(:,:,23))
  call Hloop_QW_A(ntryL,G1H16(22),wf4(:,4),G1H4(1),m3h4x4(:,14),heltab2x16(:,:,24))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(14),n2h4(14))
  call Hloop_QW_A(ntryL,G1H16(23),wf4(:,4),G1H4(1),m3h4x4(:,15),heltab2x16(:,:,25))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(15),n2h4(15))
  call Hloop_QW_A(ntryL,G1H16(24),wf4(:,4),G1H4(1),m3h4x4(:,16),heltab2x16(:,:,26))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(16),n2h4(16))
  call Hloop_QV_A(ntryL,G1H16(25),wf4(:,2),G1H4(1),m3h4x4(:,17),heltab2x16(:,:,27))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(17),n2h4(17))
call HGT_OLR(G1H16(26),1,1,16)
call HGT_invQ_OLR(G1H16(26),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(26),-32,0,G2H16(19),n2h16(29))
  call Hloop_AQ_V(ntryL,G2H16(19),ex6(:),G2H8(11),m3h2x8(:,11),heltab2x16(:,:,28))
  call Hloop_QV_A(ntryL,G1H16(28),wf4(:,2),G1H4(1),m3h4x4(:,18),heltab2x16(:,:,29))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(18),n2h4(18))
  call Hloop_QV_A(ntryL,G1H16(29),wf4(:,2),G1H4(1),m3h4x4(:,19),heltab2x16(:,:,30))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(19),n2h4(19))
  call Hloop_QV_A(ntryL,G1H16(30),wf4(:,2),G1H4(1),m3h4x4(:,20),heltab2x16(:,:,31))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(20),n2h4(20))
  call Hloop_QZ_A(ntryL,G1H16(31),wf4(:,7),G1H4(1),ngZu,m3h4x4(:,21),heltab2x16(:,:,32))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(21),n2h4(21))
call HGT_OLR(G1H16(32),1,1,16)
call HGT_invQ_OLR(G1H16(32),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(32),-32,0,G2H16(23),n2h16(30))
  call Hloop_AQ_V(ntryL,G2H16(23),ex6(:),G2H8(12),m3h2x8(:,12),heltab2x16(:,:,33))
  call Hloop_QZ_A(ntryL,G1H16(34),wf4(:,7),G1H4(1),ngZu,m3h4x4(:,22),heltab2x16(:,:,34))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(22),n2h4(22))
  call Hloop_QZ_A(ntryL,G1H16(35),wf4(:,7),G1H4(1),ngZu,m3h4x4(:,23),heltab2x16(:,:,35))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(23),n2h4(23))
  call Hloop_QZ_A(ntryL,G1H16(36),wf4(:,7),G1H4(1),ngZu,m3h4x4(:,24),heltab2x16(:,:,36))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(24),n2h4(24))
  call Hloop_AW_Q(ntryL,G1H32(1),wf4(:,4),G1H8(1),m3h4x8(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(1),85,0,G2H8(13),n2h8(1))
call HGT_raise_alpha_OLR(G1H32(2),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(2),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(2),ex6(:),G1H16(1),m3h2x16(:,1),heltab2x32(:,:,2))
  call Hloop_AW_Q(ntryL,G1H32(4),wf4(:,4),G1H8(1),m3h4x8(:,2),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G1H8(1),85,0,G2H8(14),n2h8(2))
  call Hloop_AW_Q(ntryL,G1H32(5),wf4(:,4),G1H8(1),m3h4x8(:,3),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G1H8(1),85,0,G2H8(15),n2h8(3))
  call Hloop_AW_Q(ntryL,G1H32(6),wf4(:,4),G1H8(1),m3h4x8(:,4),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G1H8(1),85,0,G2H8(16),n2h8(4))
  call Hloop_AW_Q(ntryL,G1H32(7),wf4(:,4),G1H8(1),m3h4x8(:,5),heltab2x32(:,:,6))
  call Hloop_A_Q(ntryL,G1H8(1),85,0,G2H8(17),n2h8(5))
call HGT_raise_alpha_OLR(G1H32(8),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(8),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(8),ex6(:),G1H16(2),m3h2x16(:,2),heltab2x32(:,:,7))
  call Hloop_AW_Q(ntryL,G1H32(10),wf4(:,4),G1H8(1),m3h4x8(:,6),heltab2x32(:,:,8))
  call Hloop_A_Q(ntryL,G1H8(1),85,0,G2H8(18),n2h8(6))
  call Hloop_AW_Q(ntryL,G1H32(11),wf4(:,4),G1H8(1),m3h4x8(:,7),heltab2x32(:,:,9))
  call Hloop_A_Q(ntryL,G1H8(1),85,0,G2H8(19),n2h8(7))
  call Hloop_AW_Q(ntryL,G1H32(12),wf4(:,4),G1H8(1),m3h4x8(:,8),heltab2x32(:,:,10))
  call Hloop_A_Q(ntryL,G1H8(1),85,0,G2H8(20),n2h8(8))
  call Hloop_AV_Q(ntryL,G1H32(13),wf4(:,2),G1H8(1),m3h4x8(:,9),heltab2x32(:,:,11))
  call Hloop_A_Q(ntryL,G1H8(1),90,0,G2H8(21),n2h8(9))
call HGT_raise_alpha_OLR(G1H32(14),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(14),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(14),ex6(:),G1H16(4),m3h2x16(:,3),heltab2x32(:,:,12))
  call Hloop_AV_Q(ntryL,G1H32(16),wf4(:,2),G1H8(1),m3h4x8(:,10),heltab2x32(:,:,13))
  call Hloop_A_Q(ntryL,G1H8(1),90,0,G2H8(22),n2h8(10))
  call Hloop_AV_Q(ntryL,G1H32(17),wf4(:,2),G1H8(1),m3h4x8(:,11),heltab2x32(:,:,14))
  call Hloop_A_Q(ntryL,G1H8(1),90,0,G2H8(23),n2h8(11))
  call Hloop_AV_Q(ntryL,G1H32(18),wf4(:,2),G1H8(1),m3h4x8(:,12),heltab2x32(:,:,15))
  call Hloop_A_Q(ntryL,G1H8(1),90,0,G2H8(24),n2h8(12))
  call Hloop_AZ_Q(ntryL,G1H32(19),wf4(:,7),G1H8(1),ngZu,m3h4x8(:,13),heltab2x32(:,:,16))
  call Hloop_A_Q(ntryL,G1H8(1),90,0,G2H8(25),n2h8(13))
call HGT_raise_alpha_OLR(G1H32(20),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(20),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(20),ex6(:),G1H16(5),m3h2x16(:,4),heltab2x32(:,:,17))
  call Hloop_AZ_Q(ntryL,G1H32(22),wf4(:,7),G1H8(1),ngZu,m3h4x8(:,14),heltab2x32(:,:,18))
  call Hloop_A_Q(ntryL,G1H8(1),90,0,G2H8(26),n2h8(14))
  call Hloop_AZ_Q(ntryL,G1H32(23),wf4(:,7),G1H8(1),ngZu,m3h4x8(:,15),heltab2x32(:,:,19))
  call Hloop_A_Q(ntryL,G1H8(1),90,0,G2H8(27),n2h8(15))
  call Hloop_AZ_Q(ntryL,G1H32(24),wf4(:,7),G1H8(1),ngZu,m3h4x8(:,16),heltab2x32(:,:,20))
  call Hloop_A_Q(ntryL,G1H8(1),90,0,G2H8(28),n2h8(16))
  call Hloop_AW_Q(ntryL,G1H16(37),wf4(:,12),G1H4(1),m3h4x4(:,25),heltab2x16(:,:,37))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(25),n2h4(25))
call HGT_OLR(G1H16(38),1,1,16)
call HGT_invQ_OLR(G1H16(38),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(38),-16,0,G2H16(2),n2h16(31))
  call Hloop_QA_V(ntryL,G2H16(2),ex5(:),G2H8(29),m3h2x8(:,13),heltab2x16(:,:,38))
  call Hloop_AW_Q(ntryL,G1H16(40),wf4(:,12),G1H4(1),m3h4x4(:,26),heltab2x16(:,:,39))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(26),n2h4(26))
  call Hloop_AW_Q(ntryL,G1H16(41),wf4(:,12),G1H4(1),m3h4x4(:,27),heltab2x16(:,:,40))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(27),n2h4(27))
  call Hloop_AW_Q(ntryL,G1H16(42),wf4(:,12),G1H4(1),m3h4x4(:,28),heltab2x16(:,:,41))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(28),n2h4(28))
  call Hloop_AV_Q(ntryL,G1H16(43),wf4(:,11),G1H4(1),m3h4x4(:,29),heltab2x16(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(29),n2h4(29))
call HGT_OLR(G1H16(44),1,1,16)
call HGT_invQ_OLR(G1H16(44),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(44),-16,0,G2H16(3),n2h16(32))
  call Hloop_QA_V(ntryL,G2H16(3),ex5(:),G2H8(30),m3h2x8(:,14),heltab2x16(:,:,43))
  call Hloop_AV_Q(ntryL,G1H16(46),wf4(:,11),G1H4(1),m3h4x4(:,30),heltab2x16(:,:,44))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(30),n2h4(30))
  call Hloop_AV_Q(ntryL,G1H16(47),wf4(:,11),G1H4(1),m3h4x4(:,31),heltab2x16(:,:,45))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(31),n2h4(31))
  call Hloop_AV_Q(ntryL,G1H16(48),wf4(:,11),G1H4(1),m3h4x4(:,32),heltab2x16(:,:,46))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(32),n2h4(32))
  call Hloop_AZ_Q(ntryL,G1H16(49),wf4(:,14),G1H4(1),ngZd,m3h4x4(:,33),heltab2x16(:,:,47))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(33),n2h4(33))
call HGT_OLR(G1H16(50),1,1,16)
call HGT_invQ_OLR(G1H16(50),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(50),-16,0,G2H16(4),n2h16(33))
  call Hloop_QA_V(ntryL,G2H16(4),ex5(:),G2H8(31),m3h2x8(:,15),heltab2x16(:,:,48))
  call Hloop_AZ_Q(ntryL,G1H16(52),wf4(:,14),G1H4(1),ngZd,m3h4x4(:,34),heltab2x16(:,:,49))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(34),n2h4(34))
  call Hloop_AZ_Q(ntryL,G1H16(53),wf4(:,14),G1H4(1),ngZd,m3h4x4(:,35),heltab2x16(:,:,50))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(35),n2h4(35))
  call Hloop_AZ_Q(ntryL,G1H16(54),wf4(:,14),G1H4(1),ngZd,m3h4x4(:,36),heltab2x16(:,:,51))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(36),n2h4(36))
  call Hloop_QW_A(ntryL,G1H16(55),wf4(:,12),G1H4(1),m3h4x4(:,37),heltab2x16(:,:,52))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(37),n2h4(37))
call HGT_OLR(G1H16(56),1,1,16)
call HGT_invQ_OLR(G1H16(56),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(56),-32,0,G2H16(6),n2h16(34))
  call Hloop_AQ_V(ntryL,G2H16(6),ex6(:),G2H8(32),m3h2x8(:,16),heltab2x16(:,:,53))
  call Hloop_QW_A(ntryL,G1H16(58),wf4(:,12),G1H4(1),m3h4x4(:,38),heltab2x16(:,:,54))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(38),n2h4(38))
  call Hloop_QW_A(ntryL,G1H16(59),wf4(:,12),G1H4(1),m3h4x4(:,39),heltab2x16(:,:,55))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(39),n2h4(39))
  call Hloop_QW_A(ntryL,G1H16(60),wf4(:,12),G1H4(1),m3h4x4(:,40),heltab2x16(:,:,56))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(40),n2h4(40))
  call Hloop_QV_A(ntryL,G1H16(61),wf4(:,11),G1H4(1),m3h4x4(:,41),heltab2x16(:,:,57))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(41),n2h4(41))
call HGT_OLR(G1H16(62),1,1,16)
call HGT_invQ_OLR(G1H16(62),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(62),-32,0,G2H16(7),n2h16(35))
  call Hloop_AQ_V(ntryL,G2H16(7),ex6(:),G2H8(33),m3h2x8(:,17),heltab2x16(:,:,58))
  call Hloop_QV_A(ntryL,G1H16(64),wf4(:,11),G1H4(1),m3h4x4(:,42),heltab2x16(:,:,59))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(42),n2h4(42))
  call Hloop_QV_A(ntryL,G1H16(65),wf4(:,11),G1H4(1),m3h4x4(:,43),heltab2x16(:,:,60))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(43),n2h4(43))
  call Hloop_QV_A(ntryL,G1H16(66),wf4(:,11),G1H4(1),m3h4x4(:,44),heltab2x16(:,:,61))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(44),n2h4(44))
  call Hloop_QZ_A(ntryL,G1H16(67),wf4(:,14),G1H4(1),ngZu,m3h4x4(:,45),heltab2x16(:,:,62))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(45),n2h4(45))
call HGT_OLR(G1H16(68),1,1,16)
call HGT_invQ_OLR(G1H16(68),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(68),-32,0,G2H16(8),n2h16(36))
  call Hloop_AQ_V(ntryL,G2H16(8),ex6(:),G2H8(34),m3h2x8(:,18),heltab2x16(:,:,63))
  call Hloop_QZ_A(ntryL,G1H16(70),wf4(:,14),G1H4(1),ngZu,m3h4x4(:,46),heltab2x16(:,:,64))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(46),n2h4(46))
  call Hloop_QZ_A(ntryL,G1H16(71),wf4(:,14),G1H4(1),ngZu,m3h4x4(:,47),heltab2x16(:,:,65))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(47),n2h4(47))
  call Hloop_QZ_A(ntryL,G1H16(72),wf4(:,14),G1H4(1),ngZu,m3h4x4(:,48),heltab2x16(:,:,66))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(48),n2h4(48))
  call Hloop_AW_Q(ntryL,G1H32(25),wf4(:,12),G1H8(1),m3h4x8(:,17),heltab2x32(:,:,21))
  call Hloop_A_Q(ntryL,G1H8(1),89,0,G2H8(35),n2h8(17))
call HGT_raise_alpha_OLR(G1H32(26),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(26),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(26),ex6(:),G1H16(6),m3h2x16(:,5),heltab2x32(:,:,22))
  call Hloop_AW_Q(ntryL,G1H32(28),wf4(:,12),G1H8(1),m3h4x8(:,18),heltab2x32(:,:,23))
  call Hloop_A_Q(ntryL,G1H8(1),89,0,G2H8(36),n2h8(18))
  call Hloop_AW_Q(ntryL,G1H32(29),wf4(:,12),G1H8(1),m3h4x8(:,19),heltab2x32(:,:,24))
  call Hloop_A_Q(ntryL,G1H8(1),89,0,G2H8(37),n2h8(19))
  call Hloop_AW_Q(ntryL,G1H32(30),wf4(:,12),G1H8(1),m3h4x8(:,20),heltab2x32(:,:,25))
  call Hloop_A_Q(ntryL,G1H8(1),89,0,G2H8(38),n2h8(20))
  call Hloop_AW_Q(ntryL,G1H32(31),wf4(:,12),G1H8(1),m3h4x8(:,21),heltab2x32(:,:,26))
  call Hloop_A_Q(ntryL,G1H8(1),89,0,G2H8(39),n2h8(21))
call HGT_raise_alpha_OLR(G1H32(32),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(32),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(32),ex6(:),G1H16(7),m3h2x16(:,6),heltab2x32(:,:,27))
  call Hloop_AW_Q(ntryL,G1H32(34),wf4(:,12),G1H8(1),m3h4x8(:,22),heltab2x32(:,:,28))
  call Hloop_A_Q(ntryL,G1H8(1),89,0,G2H8(40),n2h8(22))
  call Hloop_AW_Q(ntryL,G1H32(35),wf4(:,12),G1H8(1),m3h4x8(:,23),heltab2x32(:,:,29))
  call Hloop_A_Q(ntryL,G1H8(1),89,0,G2H8(41),n2h8(23))
  call Hloop_AW_Q(ntryL,G1H32(36),wf4(:,12),G1H8(1),m3h4x8(:,24),heltab2x32(:,:,30))
  call Hloop_A_Q(ntryL,G1H8(1),89,0,G2H8(42),n2h8(24))
  call Hloop_AV_Q(ntryL,G1H32(37),wf4(:,11),G1H8(1),m3h4x8(:,25),heltab2x32(:,:,31))
  call Hloop_A_Q(ntryL,G1H8(1),86,0,G2H8(43),n2h8(25))
call HGT_raise_alpha_OLR(G1H32(38),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(38),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(38),ex6(:),G1H16(8),m3h2x16(:,7),heltab2x32(:,:,32))
  call Hloop_AV_Q(ntryL,G1H32(40),wf4(:,11),G1H8(1),m3h4x8(:,26),heltab2x32(:,:,33))
  call Hloop_A_Q(ntryL,G1H8(1),86,0,G2H8(44),n2h8(26))
  call Hloop_AV_Q(ntryL,G1H32(41),wf4(:,11),G1H8(1),m3h4x8(:,27),heltab2x32(:,:,34))
  call Hloop_A_Q(ntryL,G1H8(1),86,0,G2H8(45),n2h8(27))
  call Hloop_AV_Q(ntryL,G1H32(42),wf4(:,11),G1H8(1),m3h4x8(:,28),heltab2x32(:,:,35))
  call Hloop_A_Q(ntryL,G1H8(1),86,0,G2H8(46),n2h8(28))
  call Hloop_AZ_Q(ntryL,G1H32(43),wf4(:,14),G1H8(1),ngZu,m3h4x8(:,29),heltab2x32(:,:,36))
  call Hloop_A_Q(ntryL,G1H8(1),86,0,G2H8(47),n2h8(29))
call HGT_raise_alpha_OLR(G1H32(44),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(44),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(44),ex6(:),G1H16(10),m3h2x16(:,8),heltab2x32(:,:,37))
  call Hloop_AZ_Q(ntryL,G1H32(46),wf4(:,14),G1H8(1),ngZu,m3h4x8(:,30),heltab2x32(:,:,38))
  call Hloop_A_Q(ntryL,G1H8(1),86,0,G2H8(48),n2h8(30))
  call Hloop_AZ_Q(ntryL,G1H32(47),wf4(:,14),G1H8(1),ngZu,m3h4x8(:,31),heltab2x32(:,:,39))
  call Hloop_A_Q(ntryL,G1H8(1),86,0,G2H8(49),n2h8(31))
  call Hloop_AZ_Q(ntryL,G1H32(48),wf4(:,14),G1H8(1),ngZu,m3h4x8(:,32),heltab2x32(:,:,40))
  call Hloop_A_Q(ntryL,G1H8(1),86,0,G2H8(50),n2h8(32))
  call ol_merge(ntryL,G2H4(9),[G2H4(5)])
  call ol_merge(ntryL,G2H4(11),[G2H4(7)])
  call ol_merge(ntryL,G2H4(12),[G2H4(8)])
  call ol_merge(ntryL,G2H4(21),[G2H4(17)])
  call ol_merge(ntryL,G2H4(23),[G2H4(19)])
  call ol_merge(ntryL,G2H4(24),[G2H4(20)])
  call ol_merge(ntryL,G2H8(25),[G2H8(21)])
  call ol_merge(ntryL,G2H8(27),[G2H8(23)])
  call ol_merge(ntryL,G2H8(28),[G2H8(24)])
  call ol_merge(ntryL,G2H4(33),[G2H4(29)])
  call ol_merge(ntryL,G2H4(35),[G2H4(31)])
  call ol_merge(ntryL,G2H4(36),[G2H4(32)])
  call ol_merge(ntryL,G2H4(45),[G2H4(41)])
  call ol_merge(ntryL,G2H4(47),[G2H4(43)])
  call ol_merge(ntryL,G2H4(48),[G2H4(44)])
  call ol_merge(ntryL,G2H8(47),[G2H8(43)])
  call ol_merge(ntryL,G2H8(49),[G2H8(45)])
  call ol_merge(ntryL,G2H8(50),[G2H8(46)])
call Hotf_5pt_reduction(G2H8(1),RedSet_5(13),mass5set(:,1),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),G1H8(6),8)
call HG1shiftOLR(G1H8(2),10,8)
call Hotf_5pt_reduction(G2H8(2),RedSet_5(13),mass5set(:,1),  & 
G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),G1H8(12),8)
call HG1shiftOLR(G1H8(8),10,8)
call Hotf_5pt_reduction(G2H8(3),RedSet_5(14),mass5set(:,1),  & 
G1H8(13),G1H8(14),G1H8(15),G1H8(16),G1H8(17),G1H8(18),8)
call HG1shiftOLR(G1H8(14),10,8)
call Hotf_5pt_reduction(G2H8(4),RedSet_5(14),mass5set(:,1),  & 
G1H8(19),G1H8(20),G1H8(21),G1H8(22),G1H8(23),G1H8(24),8)
call HG1shiftOLR(G1H8(20),10,8)
call Hotf_5pt_reduction(G2H8(5),RedSet_5(15),mass5set(:,1),  & 
G1H8(25),G1H8(26),G1H8(27),G1H8(28),G1H8(29),G1H8(30),8)
call HG1shiftOLR(G1H8(26),9,8)
call Hotf_5pt_reduction(G2H8(6),RedSet_5(16),mass5set(:,1),  & 
G1H8(31),G1H8(32),G1H8(33),G1H8(34),G1H8(35),G1H8(36),8)
call HG1shiftOLR(G1H8(32),9,8)
  call Hloop_AQ_V(ntryL,G2H4(1),ex6(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_AQ_V(ntryL,G2H4(3),ex6(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_AQ_V(ntryL,G2H4(4),ex6(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_AQ_V(ntryL,G2H4(9),ex6(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_AQ_V(ntryL,G2H4(11),ex6(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_V(ntryL,G2H4(12),ex6(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_QA_V(ntryL,G2H4(13),ex5(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_QA_V(ntryL,G2H4(15),ex5(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_QA_V(ntryL,G2H4(16),ex5(:),G2H2(9),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_QA_V(ntryL,G2H4(21),ex5(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_QA_V(ntryL,G2H4(23),ex5(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_QA_V(ntryL,G2H4(24),ex5(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
call Hotf_5pt_reduction(G2H8(13),RedSet_5(5),mass5set(:,1),  & 
G1H8(37),G1H8(38),G1H8(39),G1H8(40),G1H8(41),G1H8(42),8)
call HG1shiftOLR(G1H8(38),32,8)
call Hotf_4pt_reduction(G2H8(15),RedSet_4(1),mass4set(:,1),  & 
G1H8(43),G1H8(44),G1H8(45),G1H8(46),G1H8(47),8)
call HG1shiftOLR(G1H8(44),32,8)
call Hotf_4pt_reduction(G2H8(16),RedSet_4(2),mass4set(:,1),  & 
G1H8(48),G1H8(49),G1H8(50),G1H8(51),G1H8(52),8)
call HG1shiftOLR(G1H8(49),42,8)
call Hotf_5pt_reduction(G2H8(17),RedSet_5(5),mass5set(:,1),  & 
G1H8(53),G1H8(54),G1H8(55),G1H8(56),G1H8(57),G1H8(58),8)
call HG1shiftOLR(G1H8(54),32,8)
call Hotf_4pt_reduction(G2H8(19),RedSet_4(1),mass4set(:,1),  & 
G1H8(59),G1H8(60),G1H8(61),G1H8(62),G1H8(63),8)
call HG1shiftOLR(G1H8(60),32,8)
call Hotf_4pt_reduction(G2H8(20),RedSet_4(2),mass4set(:,1),  & 
G1H8(64),G1H8(65),G1H8(66),G1H8(67),G1H8(68),8)
call HG1shiftOLR(G1H8(65),42,8)
call Hotf_5pt_reduction(G2H8(25),RedSet_5(6),mass5set(:,1),  & 
G1H8(69),G1H8(70),G1H8(71),G1H8(72),G1H8(73),G1H8(74),8)
call HG1shiftOLR(G1H8(70),32,8)
call Hotf_4pt_reduction(G2H8(27),RedSet_4(1),mass4set(:,1),  & 
G1H8(75),G1H8(76),G1H8(77),G1H8(78),G1H8(79),8)
call HG1shiftOLR(G1H8(76),32,8)
call Hotf_4pt_reduction(G2H8(28),RedSet_4(3),mass4set(:,1),  & 
G1H8(80),G1H8(81),G1H8(82),G1H8(83),G1H8(84),8)
call HG1shiftOLR(G1H8(81),37,8)
  call Hloop_AQ_V(ntryL,G2H4(25),ex6(:),G2H2(13),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_AQ_V(ntryL,G2H4(27),ex6(:),G2H2(14),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_AQ_V(ntryL,G2H4(28),ex6(:),G2H2(15),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_AQ_V(ntryL,G2H4(33),ex6(:),G2H2(16),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_AQ_V(ntryL,G2H4(35),ex6(:),G2H2(17),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_AQ_V(ntryL,G2H4(36),ex6(:),G2H2(18),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_QA_V(ntryL,G2H4(37),ex5(:),G2H2(19),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_QA_V(ntryL,G2H4(39),ex5(:),G2H2(20),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_QA_V(ntryL,G2H4(40),ex5(:),G2H2(21),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_QA_V(ntryL,G2H4(45),ex5(:),G2H2(22),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_QA_V(ntryL,G2H4(47),ex5(:),G2H2(23),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_QA_V(ntryL,G2H4(48),ex5(:),G2H2(24),m3h2x2(:,24),heltab2x4(:,:,24))
call Hotf_5pt_reduction(G2H8(35),RedSet_5(11),mass5set(:,1),  & 
G1H8(85),G1H8(86),G1H8(87),G1H8(88),G1H8(89),G1H8(90),8)
call HG1shiftOLR(G1H8(86),32,8)
call Hotf_4pt_reduction(G2H8(37),RedSet_4(1),mass4set(:,1),  & 
G1H8(91),G1H8(92),G1H8(93),G1H8(94),G1H8(95),8)
call HG1shiftOLR(G1H8(92),32,8)
call Hotf_4pt_reduction(G2H8(38),RedSet_4(4),mass4set(:,1),  & 
G1H8(96),G1H8(97),G1H8(98),G1H8(99),G1H8(100),8)
call HG1shiftOLR(G1H8(97),38,8)
call Hotf_5pt_reduction(G2H8(39),RedSet_5(11),mass5set(:,1),  & 
G1H8(101),G1H8(102),G1H8(103),G1H8(104),G1H8(105),G1H8(106),8)
call HG1shiftOLR(G1H8(102),32,8)
call Hotf_4pt_reduction(G2H8(41),RedSet_4(1),mass4set(:,1),  & 
G1H8(107),G1H8(108),G1H8(109),G1H8(110),G1H8(111),8)
call HG1shiftOLR(G1H8(108),32,8)
call Hotf_4pt_reduction(G2H8(42),RedSet_4(4),mass4set(:,1),  & 
G1H8(112),G1H8(113),G1H8(114),G1H8(115),G1H8(116),8)
call HG1shiftOLR(G1H8(113),38,8)
call Hotf_5pt_reduction(G2H8(47),RedSet_5(12),mass5set(:,1),  & 
G1H8(117),G1H8(118),G1H8(119),G1H8(120),G1H8(121),G1H8(122),8)
call HG1shiftOLR(G1H8(118),32,8)
call Hotf_4pt_reduction(G2H8(49),RedSet_4(1),mass4set(:,1),  & 
G1H8(123),G1H8(124),G1H8(125),G1H8(126),G1H8(127),8)
call HG1shiftOLR(G1H8(124),32,8)
call Hotf_4pt_reduction(G2H8(50),RedSet_4(5),mass4set(:,1),  & 
G1H8(128),G1H8(129),G1H8(130),G1H8(131),G1H8(132),8)
call HG1shiftOLR(G1H8(129),41,8)
  call ol_merge(ntryL,G1H8(43),[G1H8(41)])
  call ol_merge(ntryL,G1H8(48),[G1H8(42)])
  call ol_merge(ntryL,G1H8(59),[G1H8(57)])
  call ol_merge(ntryL,G1H8(64),[G1H8(58)])
  call ol_merge(ntryL,G1H8(75),[G1H8(73)])
  call ol_merge(ntryL,G1H8(80),[G1H8(74)])
  call ol_merge(ntryL,G1H8(91),[G1H8(89)])
  call ol_merge(ntryL,G1H8(96),[G1H8(90)])
  call ol_merge(ntryL,G1H8(107),[G1H8(105)])
  call ol_merge(ntryL,G1H8(112),[G1H8(106)])
  call ol_merge(ntryL,G1H8(123),[G1H8(121)])
  call ol_merge(ntryL,G1H8(128),[G1H8(122)])
  call Hloop_VQ_A(ntryL,G1H8(1),ex6(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_Q_A(ntryL,G1H4(1),117,0,G2H4(5),n2h4(49))
call HGT_OLR(G1H8(2),1,1,8)
call HGT_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(2),-10,0,G2H8(21),n2h8(33))
  call Hloop_AV_Q(ntryL,G2H8(21),wf4(:,2),G2H2(25),m3h4x2(:,1),heltab2x8(:,:,2))
  call Hloop_VQ_A(ntryL,G1H8(5),ex6(:),G1H4(1),m3h2x4(:,2),heltab2x8(:,:,3))
  call Hloop_Q_A(ntryL,G1H4(1),117,0,G2H4(7),n2h4(50))
  call Hloop_VQ_A(ntryL,G1H8(6),ex6(:),G1H4(1),m3h2x4(:,3),heltab2x8(:,:,4))
  call Hloop_Q_A(ntryL,G1H4(1),117,0,G2H4(8),n2h4(51))
  call Hloop_VQ_A(ntryL,G1H8(7),ex6(:),G1H4(1),m3h2x4(:,4),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(1),117,0,G2H4(17),n2h4(52))
call HGT_OLR(G1H8(8),1,1,8)
call HGT_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(8),-10,0,G2H8(23),n2h8(34))
  call Hloop_AZ_Q(ntryL,G2H8(23),wf4(:,7),G2H2(26),ngZd,m3h4x2(:,2),heltab2x8(:,:,6))
  call Hloop_VQ_A(ntryL,G1H8(11),ex6(:),G1H4(1),m3h2x4(:,5),heltab2x8(:,:,7))
  call Hloop_Q_A(ntryL,G1H4(1),117,0,G2H4(19),n2h4(53))
  call Hloop_VQ_A(ntryL,G1H8(12),ex6(:),G1H4(1),m3h2x4(:,6),heltab2x8(:,:,8))
  call Hloop_Q_A(ntryL,G1H4(1),117,0,G2H4(20),n2h4(54))
  call Hloop_VA_Q(ntryL,G1H8(13),ex5(:),G1H4(1),m3h2x4(:,7),heltab2x8(:,:,9))
  call Hloop_A_Q(ntryL,G1H4(1),117,0,G2H4(29),n2h4(55))
call HGT_OLR(G1H8(14),1,1,8)
call HGT_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(14),-10,0,G2H8(24),n2h8(35))
  call Hloop_QV_A(ntryL,G2H8(24),wf4(:,2),G2H2(27),m3h4x2(:,3),heltab2x8(:,:,10))
  call Hloop_VA_Q(ntryL,G1H8(17),ex5(:),G1H4(1),m3h2x4(:,8),heltab2x8(:,:,11))
  call Hloop_A_Q(ntryL,G1H4(1),117,0,G2H4(31),n2h4(56))
  call Hloop_VA_Q(ntryL,G1H8(18),ex5(:),G1H4(1),m3h2x4(:,9),heltab2x8(:,:,12))
  call Hloop_A_Q(ntryL,G1H4(1),117,0,G2H4(32),n2h4(57))
  call Hloop_VA_Q(ntryL,G1H8(19),ex5(:),G1H4(1),m3h2x4(:,10),heltab2x8(:,:,13))
  call Hloop_A_Q(ntryL,G1H4(1),117,0,G2H4(41),n2h4(58))
call HGT_OLR(G1H8(20),1,1,8)
call HGT_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(20),-10,0,G2H8(43),n2h8(36))
  call Hloop_QZ_A(ntryL,G2H8(43),wf4(:,7),G2H2(28),ngZu,m3h4x2(:,4),heltab2x8(:,:,14))
  call Hloop_VA_Q(ntryL,G1H8(23),ex5(:),G1H4(1),m3h2x4(:,11),heltab2x8(:,:,15))
  call Hloop_A_Q(ntryL,G1H4(1),117,0,G2H4(43),n2h4(59))
  call Hloop_VA_Q(ntryL,G1H8(24),ex5(:),G1H4(1),m3h2x4(:,12),heltab2x8(:,:,16))
  call Hloop_A_Q(ntryL,G1H4(1),117,0,G2H4(44),n2h4(60))
  call Hloop_VA_Q(ntryL,G1H8(25),ex5(:),G1H4(1),m3h2x4(:,13),heltab2x8(:,:,17))
  call Hloop_A_Q(ntryL,G1H4(1),118,0,G2H4(1),n2h4(61))
call HGT_OLR(G1H8(26),1,1,8)
call HGT_invQ_OLR(G1H8(26),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(26),-9,0,G2H8(45),n2h8(37))
  call Hloop_QW_A(ntryL,G2H8(45),wf4(:,12),G2H2(29),m3h4x2(:,5),heltab2x8(:,:,18))
  call Hloop_VA_Q(ntryL,G1H8(29),ex5(:),G1H4(1),m3h2x4(:,14),heltab2x8(:,:,19))
  call Hloop_A_Q(ntryL,G1H4(1),118,0,G2H4(3),n2h4(62))
  call Hloop_VA_Q(ntryL,G1H8(30),ex5(:),G1H4(1),m3h2x4(:,15),heltab2x8(:,:,20))
  call Hloop_A_Q(ntryL,G1H4(1),118,0,G2H4(4),n2h4(63))
  call Hloop_VQ_A(ntryL,G1H8(31),ex6(:),G1H4(1),m3h2x4(:,16),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G1H4(1),118,0,G2H4(9),n2h4(64))
call HGT_OLR(G1H8(32),1,1,8)
call HGT_invQ_OLR(G1H8(32),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(32),-9,0,G2H8(46),n2h8(38))
  call Hloop_AW_Q(ntryL,G2H8(46),wf4(:,12),G2H2(30),m3h4x2(:,6),heltab2x8(:,:,22))
  call Hloop_VQ_A(ntryL,G1H8(35),ex6(:),G1H4(1),m3h2x4(:,17),heltab2x8(:,:,23))
  call Hloop_Q_A(ntryL,G1H4(1),118,0,G2H4(11),n2h4(65))
  call Hloop_VQ_A(ntryL,G1H8(36),ex6(:),G1H4(1),m3h2x4(:,18),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G1H4(1),118,0,G2H4(12),n2h4(66))
  call Hloop_AV_Q(ntryL,G1H8(37),wf4(:,2),G1H2(1),m3h4x2(:,7),heltab2x8(:,:,25))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(31),n2h2(1))
call HGT_raise_alpha_OLR(G1H8(38),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(38),ex6(:),G1H4(1),m3h2x4(:,19),heltab2x8(:,:,26))
  call Hloop_AV_Q(ntryL,G1H8(43),wf4(:,2),G1H2(1),m3h4x2(:,8),heltab2x8(:,:,27))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(32),n2h2(2))
  call Hloop_AV_Q(ntryL,G1H8(48),wf4(:,2),G1H2(1),m3h4x2(:,9),heltab2x8(:,:,28))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(33),n2h2(3))
call HGT_raise_alpha_OLR(G1H8(44),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(44),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(44),ex6(:),G1H4(2),m3h2x4(:,20),heltab2x8(:,:,29))
  call Hloop_AV_Q(ntryL,G1H8(47),wf4(:,2),G1H2(1),m3h4x2(:,10),heltab2x8(:,:,30))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(34),n2h2(4))
call HGT_raise_alpha_OLR(G1H8(49),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(49),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(49),ex6(:),G1H4(3),m3h2x4(:,21),heltab2x8(:,:,31))
  call Hloop_AV_Q(ntryL,G1H8(52),wf4(:,2),G1H2(1),m3h4x2(:,11),heltab2x8(:,:,32))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(35),n2h2(5))
  call Hloop_AZ_Q(ntryL,G1H8(53),wf4(:,7),G1H2(1),ngZd,m3h4x2(:,12),heltab2x8(:,:,33))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(36),n2h2(6))
call HGT_raise_alpha_OLR(G1H8(54),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(54),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(54),ex6(:),G1H4(4),m3h2x4(:,22),heltab2x8(:,:,34))
  call Hloop_AZ_Q(ntryL,G1H8(59),wf4(:,7),G1H2(1),ngZd,m3h4x2(:,13),heltab2x8(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(37),n2h2(7))
  call Hloop_AZ_Q(ntryL,G1H8(64),wf4(:,7),G1H2(1),ngZd,m3h4x2(:,14),heltab2x8(:,:,36))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(38),n2h2(8))
call HGT_raise_alpha_OLR(G1H8(60),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(60),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(60),ex6(:),G1H4(5),m3h2x4(:,23),heltab2x8(:,:,37))
  call Hloop_AZ_Q(ntryL,G1H8(63),wf4(:,7),G1H2(1),ngZd,m3h4x2(:,15),heltab2x8(:,:,38))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(39),n2h2(9))
call HGT_raise_alpha_OLR(G1H8(65),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(65),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(65),ex6(:),G1H4(6),m3h2x4(:,24),heltab2x8(:,:,39))
  call Hloop_AZ_Q(ntryL,G1H8(68),wf4(:,7),G1H2(1),ngZd,m3h4x2(:,16),heltab2x8(:,:,40))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(40),n2h2(10))
  call Hloop_AW_Q(ntryL,G1H8(69),wf4(:,4),G1H2(1),m3h4x2(:,17),heltab2x8(:,:,41))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(41),n2h2(11))
call HGT_raise_alpha_OLR(G1H8(70),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(70),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(70),ex6(:),G1H4(7),m3h2x4(:,25),heltab2x8(:,:,42))
  call Hloop_AW_Q(ntryL,G1H8(75),wf4(:,4),G1H2(1),m3h4x2(:,18),heltab2x8(:,:,43))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(42),n2h2(12))
  call Hloop_AW_Q(ntryL,G1H8(80),wf4(:,4),G1H2(1),m3h4x2(:,19),heltab2x8(:,:,44))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(43),n2h2(13))
call HGT_raise_alpha_OLR(G1H8(76),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(76),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(76),ex6(:),G1H4(8),m3h2x4(:,26),heltab2x8(:,:,45))
  call Hloop_AW_Q(ntryL,G1H8(79),wf4(:,4),G1H2(1),m3h4x2(:,20),heltab2x8(:,:,46))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(44),n2h2(14))
call HGT_raise_alpha_OLR(G1H8(81),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(81),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(81),ex6(:),G1H4(9),m3h2x4(:,27),heltab2x8(:,:,47))
  call Hloop_AW_Q(ntryL,G1H8(84),wf4(:,4),G1H2(1),m3h4x2(:,21),heltab2x8(:,:,48))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(45),n2h2(15))
  call Hloop_AV_Q(ntryL,G1H8(85),wf4(:,11),G1H2(1),m3h4x2(:,22),heltab2x8(:,:,49))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(46),n2h2(16))
call HGT_raise_alpha_OLR(G1H8(86),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(86),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(86),ex6(:),G1H4(10),m3h2x4(:,28),heltab2x8(:,:,50))
  call Hloop_AV_Q(ntryL,G1H8(91),wf4(:,11),G1H2(1),m3h4x2(:,23),heltab2x8(:,:,51))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(47),n2h2(17))
  call Hloop_AV_Q(ntryL,G1H8(96),wf4(:,11),G1H2(1),m3h4x2(:,24),heltab2x8(:,:,52))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(48),n2h2(18))
call HGT_raise_alpha_OLR(G1H8(92),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(92),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(92),ex6(:),G1H4(11),m3h2x4(:,29),heltab2x8(:,:,53))
  call Hloop_AV_Q(ntryL,G1H8(95),wf4(:,11),G1H2(1),m3h4x2(:,25),heltab2x8(:,:,54))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(49),n2h2(19))
call HGT_raise_alpha_OLR(G1H8(97),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(97),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(97),ex6(:),G1H4(12),m3h2x4(:,30),heltab2x8(:,:,55))
  call Hloop_AV_Q(ntryL,G1H8(100),wf4(:,11),G1H2(1),m3h4x2(:,26),heltab2x8(:,:,56))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(50),n2h2(20))
  call Hloop_AZ_Q(ntryL,G1H8(101),wf4(:,14),G1H2(1),ngZd,m3h4x2(:,27),heltab2x8(:,:,57))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(51),n2h2(21))
call HGT_raise_alpha_OLR(G1H8(102),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(102),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(102),ex6(:),G1H4(13),m3h2x4(:,31),heltab2x8(:,:,58))
  call Hloop_AZ_Q(ntryL,G1H8(107),wf4(:,14),G1H2(1),ngZd,m3h4x2(:,28),heltab2x8(:,:,59))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(52),n2h2(22))
  call Hloop_AZ_Q(ntryL,G1H8(112),wf4(:,14),G1H2(1),ngZd,m3h4x2(:,29),heltab2x8(:,:,60))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(53),n2h2(23))
call HGT_raise_alpha_OLR(G1H8(108),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(108),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(108),ex6(:),G1H4(14),m3h2x4(:,32),heltab2x8(:,:,61))
  call Hloop_AZ_Q(ntryL,G1H8(111),wf4(:,14),G1H2(1),ngZd,m3h4x2(:,30),heltab2x8(:,:,62))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(54),n2h2(24))
call HGT_raise_alpha_OLR(G1H8(113),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(113),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(113),ex6(:),G1H4(15),m3h2x4(:,33),heltab2x8(:,:,63))
  call Hloop_AZ_Q(ntryL,G1H8(116),wf4(:,14),G1H2(1),ngZd,m3h4x2(:,31),heltab2x8(:,:,64))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(55),n2h2(25))
  call Hloop_AW_Q(ntryL,G1H8(117),wf4(:,12),G1H2(1),m3h4x2(:,32),heltab2x8(:,:,65))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(56),n2h2(26))
call HGT_raise_alpha_OLR(G1H8(118),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(118),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(118),ex6(:),G1H4(16),m3h2x4(:,34),heltab2x8(:,:,66))
  call Hloop_AW_Q(ntryL,G1H8(123),wf4(:,12),G1H2(1),m3h4x2(:,33),heltab2x8(:,:,67))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(57),n2h2(27))
  call Hloop_AW_Q(ntryL,G1H8(128),wf4(:,12),G1H2(1),m3h4x2(:,34),heltab2x8(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(58),n2h2(28))
call HGT_raise_alpha_OLR(G1H8(124),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(124),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(124),ex6(:),G1H4(17),m3h2x4(:,35),heltab2x8(:,:,69))
  call Hloop_AW_Q(ntryL,G1H8(127),wf4(:,12),G1H2(1),m3h4x2(:,35),heltab2x8(:,:,70))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(59),n2h2(29))
call HGT_raise_alpha_OLR(G1H8(129),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(129),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(129),ex6(:),G1H4(18),m3h2x4(:,36),heltab2x8(:,:,71))
  call Hloop_AW_Q(ntryL,G1H8(132),wf4(:,12),G1H2(1),m3h4x2(:,36),heltab2x8(:,:,72))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(60),n2h2(30))
  call ol_merge(ntryL,G2H2(36),[G2H2(31)])
  call ol_merge(ntryL,G2H2(38),[G2H2(33)])
  call ol_merge(ntryL,G2H2(51),[G2H2(46)])
  call ol_merge(ntryL,G2H2(53),[G2H2(48)])
call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
call HG1shiftOLR(G1H2(2),16,2)
call Hotf_4pt_reduction(G2H2(3),RedSet_4(6),mass4set(:,1),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),2)
call HG1shiftOLR(G1H2(8),48,2)
call Hotf_5pt_reduction(G2H2(4),RedSet_5(2),mass5set(:,1),  & 
G1H2(12),G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),2)
call HG1shiftOLR(G1H2(13),16,2)
call Hotf_4pt_reduction(G2H2(6),RedSet_4(7),mass4set(:,1),  & 
G1H2(18),G1H2(19),G1H2(20),G1H2(21),G1H2(22),2)
call HG1shiftOLR(G1H2(19),48,2)
call Hotf_5pt_reduction(G2H2(7),RedSet_5(3),mass5set(:,1),  & 
G1H2(23),G1H2(24),G1H2(25),G1H2(26),G1H2(27),G1H2(28),2)
call HG1shiftOLR(G1H2(24),32,2)
call Hotf_4pt_reduction(G2H2(9),RedSet_4(6),mass4set(:,1),  & 
G1H2(29),G1H2(30),G1H2(31),G1H2(32),G1H2(33),2)
call HG1shiftOLR(G1H2(30),48,2)
call Hotf_5pt_reduction(G2H2(10),RedSet_5(4),mass5set(:,1),  & 
G1H2(34),G1H2(35),G1H2(36),G1H2(37),G1H2(38),G1H2(39),2)
call HG1shiftOLR(G1H2(35),32,2)
call Hotf_4pt_reduction(G2H2(12),RedSet_4(7),mass4set(:,1),  & 
G1H2(40),G1H2(41),G1H2(42),G1H2(43),G1H2(44),2)
call HG1shiftOLR(G1H2(41),48,2)
call Hotf_5pt_reduction(G2H2(13),RedSet_5(7),mass5set(:,1),  & 
G1H2(45),G1H2(46),G1H2(47),G1H2(48),G1H2(49),G1H2(50),2)
call HG1shiftOLR(G1H2(46),16,2)
call Hotf_4pt_reduction(G2H2(15),RedSet_4(8),mass4set(:,1),  & 
G1H2(51),G1H2(52),G1H2(53),G1H2(54),G1H2(55),2)
call HG1shiftOLR(G1H2(52),48,2)
call Hotf_5pt_reduction(G2H2(16),RedSet_5(8),mass5set(:,1),  & 
G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),G1H2(61),2)
call HG1shiftOLR(G1H2(57),16,2)
call Hotf_4pt_reduction(G2H2(18),RedSet_4(9),mass4set(:,1),  & 
G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),2)
call HG1shiftOLR(G1H2(63),48,2)
call Hotf_5pt_reduction(G2H2(19),RedSet_5(9),mass5set(:,1),  & 
G1H2(67),G1H2(68),G1H2(69),G1H2(70),G1H2(71),G1H2(72),2)
call HG1shiftOLR(G1H2(68),32,2)
call Hotf_4pt_reduction(G2H2(21),RedSet_4(8),mass4set(:,1),  & 
G1H2(73),G1H2(74),G1H2(75),G1H2(76),G1H2(77),2)
call HG1shiftOLR(G1H2(74),48,2)
call Hotf_5pt_reduction(G2H2(22),RedSet_5(10),mass5set(:,1),  & 
G1H2(78),G1H2(79),G1H2(80),G1H2(81),G1H2(82),G1H2(83),2)
call HG1shiftOLR(G1H2(79),32,2)
call Hotf_4pt_reduction(G2H2(24),RedSet_4(9),mass4set(:,1),  & 
G1H2(84),G1H2(85),G1H2(86),G1H2(87),G1H2(88),2)
call HG1shiftOLR(G1H2(85),48,2)
call Hotf_5pt_reduction(G2H4(5),RedSet_5(13),mass5set(:,1),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
call HG1shiftOLR(G1H4(20),10,4)
call Hotf_4pt_reduction(G2H4(8),RedSet_4(10),mass4set(:,1),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),4)
call HG1shiftOLR(G1H4(26),42,4)
call Hotf_5pt_reduction(G2H4(17),RedSet_5(13),mass5set(:,1),  & 
G1H4(30),G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),4)
call HG1shiftOLR(G1H4(31),10,4)
call Hotf_4pt_reduction(G2H4(20),RedSet_4(10),mass4set(:,1),  & 
G1H4(36),G1H4(37),G1H4(38),G1H4(39),G1H4(40),4)
call HG1shiftOLR(G1H4(37),42,4)
call Hotf_5pt_reduction(G2H4(29),RedSet_5(14),mass5set(:,1),  & 
G1H4(41),G1H4(42),G1H4(43),G1H4(44),G1H4(45),G1H4(46),4)
call HG1shiftOLR(G1H4(42),10,4)
call Hotf_4pt_reduction(G2H4(32),RedSet_4(11),mass4set(:,1),  & 
G1H4(47),G1H4(48),G1H4(49),G1H4(50),G1H4(51),4)
call HG1shiftOLR(G1H4(48),26,4)
call Hotf_5pt_reduction(G2H4(41),RedSet_5(14),mass5set(:,1),  & 
G1H4(52),G1H4(53),G1H4(54),G1H4(55),G1H4(56),G1H4(57),4)
call HG1shiftOLR(G1H4(53),10,4)
call Hotf_4pt_reduction(G2H4(44),RedSet_4(11),mass4set(:,1),  & 
G1H4(58),G1H4(59),G1H4(60),G1H4(61),G1H4(62),4)
call HG1shiftOLR(G1H4(59),26,4)
call Hotf_5pt_reduction(G2H4(1),RedSet_5(15),mass5set(:,1),  & 
G1H4(63),G1H4(64),G1H4(65),G1H4(66),G1H4(67),G1H4(68),4)
call HG1shiftOLR(G1H4(64),9,4)
call Hotf_4pt_reduction(G2H4(4),RedSet_4(12),mass4set(:,1),  & 
G1H4(69),G1H4(70),G1H4(71),G1H4(72),G1H4(73),4)
call HG1shiftOLR(G1H4(70),25,4)
call Hotf_5pt_reduction(G2H4(9),RedSet_5(16),mass5set(:,1),  & 
G1H4(74),G1H4(75),G1H4(76),G1H4(77),G1H4(78),G1H4(79),4)
call HG1shiftOLR(G1H4(75),9,4)
call Hotf_4pt_reduction(G2H4(12),RedSet_4(13),mass4set(:,1),  & 
G1H4(80),G1H4(81),G1H4(82),G1H4(83),G1H4(84),4)
call HG1shiftOLR(G1H4(81),41,4)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(36),ex6(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(38),ex6(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(41),ex6(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(43),ex6(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(51),ex6(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(53),ex6(:),G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(56),ex6(:),G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(58),ex6(:),G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call ol_merge(ntryL,G1H2(7),[G1H2(6)])
  call ol_merge(ntryL,G1H2(18),[G1H2(17)])
  call ol_merge(ntryL,G1H2(29),[G1H2(28)])
  call ol_merge(ntryL,G1H2(40),[G1H2(39)])
  call ol_merge(ntryL,G1H2(51),[G1H2(50)])
  call ol_merge(ntryL,G1H2(62),[G1H2(61)])
  call ol_merge(ntryL,G1H2(73),[G1H2(72)])
  call ol_merge(ntryL,G1H2(84),[G1H2(83)])
  call ol_merge(ntryL,G1H4(25),[G1H4(24)])
  call ol_merge(ntryL,G1H4(36),[G1H4(35)])
  call ol_merge(ntryL,G1H4(47),[G1H4(46)])
  call ol_merge(ntryL,G1H4(58),[G1H4(57)])
  call ol_merge(ntryL,G1H4(69),[G1H4(68)])
  call ol_merge(ntryL,G1H4(80),[G1H4(79)])
  call Hloop_VA_Q(ntryL,G1H2(1),ex5(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(9),n2h1(1))
  call Hloop_VA_Q(ntryL,G1H2(2),ex5(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(10),n2h1(2))
  call Hloop_VA_Q(ntryL,G1H2(7),ex5(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(11),n2h1(3))
  call Hloop_VA_Q(ntryL,G1H2(8),ex5(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,0,G2tensor(12),n2h1(4))
  call Hloop_VA_Q(ntryL,G1H2(12),ex5(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(13),n2h1(5))
  call Hloop_VA_Q(ntryL,G1H2(13),ex5(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(14),n2h1(6))
  call Hloop_VA_Q(ntryL,G1H2(18),ex5(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(15),n2h1(7))
  call Hloop_VA_Q(ntryL,G1H2(19),ex5(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,0,G2tensor(16),n2h1(8))
  call Hloop_VQ_A(ntryL,G1H2(23),ex6(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(17),n2h1(9))
  call Hloop_VQ_A(ntryL,G1H2(24),ex6(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),32,0,G2tensor(18),n2h1(10))
  call Hloop_VQ_A(ntryL,G1H2(29),ex6(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(19),n2h1(11))
  call Hloop_VQ_A(ntryL,G1H2(30),ex6(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,0,G2tensor(20),n2h1(12))
  call Hloop_VQ_A(ntryL,G1H2(34),ex6(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(21),n2h1(13))
  call Hloop_VQ_A(ntryL,G1H2(35),ex6(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),32,0,G2tensor(22),n2h1(14))
  call Hloop_VQ_A(ntryL,G1H2(40),ex6(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(23),n2h1(15))
  call Hloop_VQ_A(ntryL,G1H2(41),ex6(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,0,G2tensor(24),n2h1(16))
  call Hloop_VA_Q(ntryL,G1H2(45),ex5(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(25),n2h1(17))
  call Hloop_VA_Q(ntryL,G1H2(46),ex5(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(26),n2h1(18))
  call Hloop_VA_Q(ntryL,G1H2(51),ex5(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(27),n2h1(19))
  call Hloop_VA_Q(ntryL,G1H2(52),ex5(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,0,G2tensor(28),n2h1(20))
  call Hloop_VA_Q(ntryL,G1H2(56),ex5(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(29),n2h1(21))
  call Hloop_VA_Q(ntryL,G1H2(57),ex5(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(30),n2h1(22))
  call Hloop_VA_Q(ntryL,G1H2(62),ex5(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(31),n2h1(23))
  call Hloop_VA_Q(ntryL,G1H2(63),ex5(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),48,0,G2tensor(32),n2h1(24))
  call Hloop_VQ_A(ntryL,G1H2(67),ex6(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(33),n2h1(25))
  call Hloop_VQ_A(ntryL,G1H2(68),ex6(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),32,0,G2tensor(34),n2h1(26))
  call Hloop_VQ_A(ntryL,G1H2(73),ex6(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(35),n2h1(27))
  call Hloop_VQ_A(ntryL,G1H2(74),ex6(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,0,G2tensor(36),n2h1(28))
  call Hloop_VQ_A(ntryL,G1H2(78),ex6(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(37),n2h1(29))
  call Hloop_VQ_A(ntryL,G1H2(79),ex6(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),32,0,G2tensor(38),n2h1(30))
  call Hloop_VQ_A(ntryL,G1H2(84),ex6(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(39),n2h1(31))
  call Hloop_VQ_A(ntryL,G1H2(85),ex6(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),48,0,G2tensor(40),n2h1(32))
  call Hloop_QV_A(ntryL,G1H4(19),wf4(:,2),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(41),n2h1(33))
  call Hloop_QV_A(ntryL,G1H4(20),wf4(:,2),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(42),n2h1(34))
  call Hloop_QV_A(ntryL,G1H4(25),wf4(:,2),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(43),n2h1(35))
  call Hloop_QV_A(ntryL,G1H4(26),wf4(:,2),G1H1(1),m3h4x1(:,4),heltab2x4(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),42,0,G2tensor(44),n2h1(36))
  call Hloop_QZ_A(ntryL,G1H4(30),wf4(:,7),G1H1(1),ngZd,m3h4x1(:,5),heltab2x4(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(45),n2h1(37))
  call Hloop_QZ_A(ntryL,G1H4(31),wf4(:,7),G1H1(1),ngZd,m3h4x1(:,6),heltab2x4(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(46),n2h1(38))
  call Hloop_QZ_A(ntryL,G1H4(36),wf4(:,7),G1H1(1),ngZd,m3h4x1(:,7),heltab2x4(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(47),n2h1(39))
  call Hloop_QZ_A(ntryL,G1H4(37),wf4(:,7),G1H1(1),ngZd,m3h4x1(:,8),heltab2x4(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),42,0,G2tensor(48),n2h1(40))
  call Hloop_AV_Q(ntryL,G1H4(41),wf4(:,2),G1H1(1),m3h4x1(:,9),heltab2x4(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(49),n2h1(41))
  call Hloop_AV_Q(ntryL,G1H4(42),wf4(:,2),G1H1(1),m3h4x1(:,10),heltab2x4(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(50),n2h1(42))
  call Hloop_AV_Q(ntryL,G1H4(47),wf4(:,2),G1H1(1),m3h4x1(:,11),heltab2x4(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(51),n2h1(43))
  call Hloop_AV_Q(ntryL,G1H4(48),wf4(:,2),G1H1(1),m3h4x1(:,12),heltab2x4(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),26,0,G2tensor(52),n2h1(44))
  call Hloop_AZ_Q(ntryL,G1H4(52),wf4(:,7),G1H1(1),ngZu,m3h4x1(:,13),heltab2x4(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(53),n2h1(45))
  call Hloop_AZ_Q(ntryL,G1H4(53),wf4(:,7),G1H1(1),ngZu,m3h4x1(:,14),heltab2x4(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(54),n2h1(46))
  call Hloop_AZ_Q(ntryL,G1H4(58),wf4(:,7),G1H1(1),ngZu,m3h4x1(:,15),heltab2x4(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(55),n2h1(47))
  call Hloop_AZ_Q(ntryL,G1H4(59),wf4(:,7),G1H1(1),ngZu,m3h4x1(:,16),heltab2x4(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),26,0,G2tensor(56),n2h1(48))
  call Hloop_AW_Q(ntryL,G1H4(63),wf4(:,12),G1H1(1),m3h4x1(:,17),heltab2x4(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(57),n2h1(49))
  call Hloop_AW_Q(ntryL,G1H4(64),wf4(:,12),G1H1(1),m3h4x1(:,18),heltab2x4(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,0,G2tensor(58),n2h1(50))
  call Hloop_AW_Q(ntryL,G1H4(69),wf4(:,12),G1H1(1),m3h4x1(:,19),heltab2x4(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(59),n2h1(51))
  call Hloop_AW_Q(ntryL,G1H4(70),wf4(:,12),G1H1(1),m3h4x1(:,20),heltab2x4(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),25,0,G2tensor(60),n2h1(52))
  call Hloop_QW_A(ntryL,G1H4(74),wf4(:,12),G1H1(1),m3h4x1(:,21),heltab2x4(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(61),n2h1(53))
  call Hloop_QW_A(ntryL,G1H4(75),wf4(:,12),G1H1(1),m3h4x1(:,22),heltab2x4(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(62),n2h1(54))
  call Hloop_QW_A(ntryL,G1H4(80),wf4(:,12),G1H1(1),m3h4x1(:,23),heltab2x4(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(63),n2h1(55))
  call Hloop_QW_A(ntryL,G1H4(81),wf4(:,12),G1H1(1),m3h4x1(:,24),heltab2x4(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),41,0,G2tensor(64),n2h1(56))
  call ol_merge_tensors(G2tensor(45),[G2tensor(41)])
  call ol_merge_tensors(G2tensor(53),[G2tensor(49)])
call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(5),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
call G_TensorShift(G1tensor(2),32)
call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(6),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
call G_TensorShift(G1tensor(8),32)
call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(11),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
call G_TensorShift(G1tensor(14),32)
call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(12),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
call G_TensorShift(G1tensor(20),32)
call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(1),mass5set(:,1),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
call G_TensorShift(G1tensor(26),16)
call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(2),mass5set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
call G_TensorShift(G1tensor(32),16)
call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(3),mass5set(:,1),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
call G_TensorShift(G1tensor(38),32)
call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(4),mass5set(:,1),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
call G_TensorShift(G1tensor(44),32)
call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(7),mass5set(:,1),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
call G_TensorShift(G1tensor(50),16)
call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(8),mass5set(:,1),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
call G_TensorShift(G1tensor(56),16)
call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(9),mass5set(:,1),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
call G_TensorShift(G1tensor(62),32)
call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(10),mass5set(:,1),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
call G_TensorShift(G1tensor(68),32)
call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(13),mass5set(:,1),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
call G_TensorShift(G1tensor(74),10)
call Hotf_5pt_reduction_last(G2tensor(53),RedSet_5(14),mass5set(:,1),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
call G_TensorShift(G1tensor(80),10)
call Hotf_5pt_reduction_last(G2tensor(57),RedSet_5(15),mass5set(:,1),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
call G_TensorShift(G1tensor(86),9)
call Hotf_5pt_reduction_last(G2tensor(61),RedSet_5(16),mass5set(:,1),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
call G_TensorShift(G1tensor(92),9)
call ol_merge_tensors(T1sum(1),[G1tensor(1)])
call ol_merge_tensors(T1sum(2),[G1tensor(7)])
call ol_merge_tensors(T1sum(3),[G1tensor(13)])
call ol_merge_tensors(T1sum(4),[G1tensor(19)])
call ol_merge_tensors(T1sum(5),[G1tensor(25)])
call ol_merge_tensors(T1sum(6),[G1tensor(31)])
call ol_merge_tensors(T1sum(7),[G1tensor(37)])
call ol_merge_tensors(T1sum(8),[G1tensor(43)])
call ol_merge_tensors(T1sum(9),[G1tensor(49)])
call ol_merge_tensors(T1sum(10),[G1tensor(55)])
call ol_merge_tensors(T1sum(11),[G1tensor(61)])
call ol_merge_tensors(T1sum(12),[G1tensor(67)])
call ol_merge_tensors(T1sum(13),[G1tensor(73)])
call ol_merge_tensors(T1sum(14),[G1tensor(79)])
call ol_merge_tensors(T1sum(15),[G1tensor(85)])
call ol_merge_tensors(T1sum(16),[G1tensor(91)])
Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(338)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(33),h0tab(:,33),[80,10,5,32],[0,0,0,0],4,3,wf4(:,5),wf4(:,2),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,5),G0H32(1),m3h4x32(:,1),heltab2x128(:,:,33))
  call Hloop_A_Q(ntryL,G0H32(1),80,0,G1H32(1),n2h32(17))
Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(339)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(34),h0tab(:,34),[80,10,5,32],[0,0,0,0],4,3,wf4(:,5),wf4(:,7),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,5),G0H32(1),m3h4x32(:,2),heltab2x128(:,:,34))
  call Hloop_A_Q(ntryL,G0H32(1),80,0,G1H32(2),n2h32(18))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(338)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(35),h0tab(:,35),[80,5,10,32],[0,0,0,0],4,3,wf4(:,5),wf4(:,4),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,5),G0H32(1),m3h4x32(:,3),heltab2x128(:,:,35))
  call Hloop_A_Q(ntryL,G0H32(1),80,0,G1H32(4),n2h32(19))
Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(339)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(36),h0tab(:,36),[80,5,10,32],[0,0,0,0],4,3,wf4(:,5),wf4(:,4),wf4(:,7))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,5),G0H32(1),m3h4x32(:,4),heltab2x128(:,:,36))
  call Hloop_A_Q(ntryL,G0H32(1),80,0,G1H32(5),n2h32(20))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(344)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(37),h0tab(:,37),[96,10,5,16],[0,0,0,0],4,3,wf4(:,9),wf4(:,2),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,5),heltab2x128(:,:,37))
  call Hloop_Q_A(ntryL,G0H32(1),96,0,G1H32(6),n2h32(21))
Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(345)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(38),h0tab(:,38),[96,10,5,16],[0,0,0,0],4,3,wf4(:,9),wf4(:,7),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,6),heltab2x128(:,:,38))
  call Hloop_Q_A(ntryL,G0H32(1),96,0,G1H32(7),n2h32(22))
Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(344)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(39),h0tab(:,39),[96,5,10,16],[0,0,0,0],4,3,wf4(:,9),wf4(:,4),wf4(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,7),heltab2x128(:,:,39))
  call Hloop_Q_A(ntryL,G0H32(1),96,0,G1H32(8),n2h32(23))
Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(345)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(40),h0tab(:,40),[96,5,10,16],[0,0,0,0],4,3,wf4(:,9),wf4(:,4),wf4(:,7))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,8),heltab2x128(:,:,40))
  call Hloop_Q_A(ntryL,G0H32(1),96,0,G1H32(10),n2h32(24))
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(272)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(41),h0tab(:,41),[64,21,10,32],[0,0,0,0],4,2,wf8(:,10),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(1),m3h2x64(:,33),heltab2x128(:,:,41))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(275)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(42),h0tab(:,42),[64,21,10,32],[0,0,0,0],4,2,wf8(:,10),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(2),m3h2x64(:,34),heltab2x128(:,:,42))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(272)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(43),h0tab(:,43),[64,10,21,32],[0,0,0,0],4,2,wf4(:,2),wf8(:,10))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,35),heltab2x128(:,:,43))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(3),n2h64(25))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(275)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(44),h0tab(:,44),[64,10,21,32],[0,0,0,0],4,2,wf4(:,7),wf8(:,10))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,36),heltab2x128(:,:,44))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(4),n2h64(26))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(272)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(45),h0tab(:,45),[64,10,32,21],[0,0,0,0],4,2,wf4(:,2),wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,37),heltab2x128(:,:,45))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(5),n2h64(27))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(275)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(46),h0tab(:,46),[64,10,32,21],[0,0,0,0],4,2,wf4(:,7),wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,38),heltab2x128(:,:,46))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(6),n2h64(28))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(278)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(47),h0tab(:,47),[64,16,10,37],[0,0,0,0],4,2,wf4(:,2),wf8(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(7),m3h2x64(:,39),heltab2x128(:,:,47))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(281)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(48),h0tab(:,48),[64,16,10,37],[0,0,0,0],4,2,wf4(:,7),wf8(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(8),m3h2x64(:,40),heltab2x128(:,:,48))
Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(278)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(49),h0tab(:,49),[64,10,37,16],[0,0,0,0],4,2,wf4(:,2),wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,41),heltab2x128(:,:,49))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(9),n2h64(29))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(281)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(50),h0tab(:,50),[64,10,37,16],[0,0,0,0],4,2,wf4(:,7),wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,42),heltab2x128(:,:,50))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(10),n2h64(30))
Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(278)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(51),h0tab(:,51),[64,10,16,37],[0,0,0,0],4,2,wf4(:,2),wf8(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,43),heltab2x128(:,:,51))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(11),n2h64(31))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(281)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(52),h0tab(:,52),[64,10,16,37],[0,0,0,0],4,2,wf4(:,7),wf8(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,44),heltab2x128(:,:,52))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(12),n2h64(32))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(283)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(53),h0tab(:,53),[64,26,5,32],[0,0,0,0],4,2,wf8(:,12),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(13),m3h2x64(:,45),heltab2x128(:,:,53))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(285)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(54),h0tab(:,54),[64,26,5,32],[0,0,0,0],4,2,wf8(:,14),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(14),m3h2x64(:,46),heltab2x128(:,:,54))
Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(283)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(55),h0tab(:,55),[64,5,26,32],[0,0,0,0],4,2,wf4(:,4),wf8(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,47),heltab2x128(:,:,55))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(15),n2h64(33))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(285)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(56),h0tab(:,56),[64,5,26,32],[0,0,0,0],4,2,wf4(:,4),wf8(:,14))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,48),heltab2x128(:,:,56))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(16),n2h64(34))
Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(283)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(57),h0tab(:,57),[64,5,32,26],[0,0,0,0],4,2,wf4(:,4),wf8(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,49),heltab2x128(:,:,57))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(17),n2h64(35))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(285)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(58),h0tab(:,58),[64,5,32,26],[0,0,0,0],4,2,wf4(:,4),wf8(:,14))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,50),heltab2x128(:,:,58))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(18),n2h64(36))
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(287)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(59),h0tab(:,59),[64,16,5,42],[0,0,0,0],4,2,wf4(:,4),wf8(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(19),m3h2x64(:,51),heltab2x128(:,:,59))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(289)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(60),h0tab(:,60),[64,16,5,42],[0,0,0,0],4,2,wf4(:,4),wf8(:,6))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(20),m3h2x64(:,52),heltab2x128(:,:,60))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(287)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(61),h0tab(:,61),[64,5,42,16],[0,0,0,0],4,2,wf4(:,4),wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,53),heltab2x128(:,:,61))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(21),n2h64(37))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(289)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(62),h0tab(:,62),[64,5,42,16],[0,0,0,0],4,2,wf4(:,4),wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,54),heltab2x128(:,:,62))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(22),n2h64(38))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(287)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(63),h0tab(:,63),[64,5,16,42],[0,0,0,0],4,2,wf4(:,4),wf8(:,4))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,55),heltab2x128(:,:,63))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(23),n2h64(39))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(289)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(64),h0tab(:,64),[64,5,16,42],[0,0,0,0],4,2,wf4(:,4),wf8(:,6))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,56),heltab2x128(:,:,64))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(24),n2h64(40))
Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(112)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(65),h0tab(:,65),[64,15,32,16],[0,0,0,0],4,1,wf16(:,42))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,57),heltab2x128(:,:,65))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(25),n2h64(41))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(114)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(66),h0tab(:,66),[64,15,32,16],[0,0,0,0],4,1,wf16(:,43))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,58),heltab2x128(:,:,66))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(26),n2h64(42))
Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(112)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(67),h0tab(:,67),[64,15,16,32],[0,0,0,0],4,1,wf16(:,42))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,59),heltab2x128(:,:,67))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(27),n2h64(43))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(114)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(68),h0tab(:,68),[64,15,16,32],[0,0,0,0],4,1,wf16(:,43))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,60),heltab2x128(:,:,68))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(28),n2h64(44))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(112)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(69),h0tab(:,69),[64,16,15,32],[0,0,0,0],4,1,wf16(:,42))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(29),m3h2x64(:,61),heltab2x128(:,:,69))
Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(114)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(70),h0tab(:,70),[64,16,15,32],[0,0,0,0],4,1,wf16(:,43))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(30),m3h2x64(:,62),heltab2x128(:,:,70))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(206)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(71),h0tab(:,71),[64,15,32,16],[0,0,0,0],4,1,wf16(:,102))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,63),heltab2x128(:,:,71))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(31),n2h64(45))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(206)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(72),h0tab(:,72),[64,15,16,32],[0,0,0,0],4,1,wf16(:,102))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,64),heltab2x128(:,:,72))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(32),n2h64(46))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(206)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(73),h0tab(:,73),[64,16,15,32],[0,0,0,0],4,1,wf16(:,102))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(33),m3h2x64(:,65),heltab2x128(:,:,73))
Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(364)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(74),h0tab(:,74),[80,6,9,32],[0,0,0,0],4,3,wf4(:,5),wf4(:,11),wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,5),G0H32(1),m3h4x32(:,9),heltab2x128(:,:,74))
  call Hloop_A_Q(ntryL,G0H32(1),80,0,G1H32(11),n2h32(25))
Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(365)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(75),h0tab(:,75),[80,6,9,32],[0,0,0,0],4,3,wf4(:,5),wf4(:,14),wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,5),G0H32(1),m3h4x32(:,10),heltab2x128(:,:,75))
  call Hloop_A_Q(ntryL,G0H32(1),80,0,G1H32(12),n2h32(26))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(364)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(76),h0tab(:,76),[80,9,6,32],[0,0,0,0],4,3,wf4(:,5),wf4(:,12),wf4(:,11))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,5),G0H32(1),m3h4x32(:,11),heltab2x128(:,:,76))
  call Hloop_A_Q(ntryL,G0H32(1),80,0,G1H32(13),n2h32(27))
Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(365)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(77),h0tab(:,77),[80,9,6,32],[0,0,0,0],4,3,wf4(:,5),wf4(:,12),wf4(:,14))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,5),G0H32(1),m3h4x32(:,12),heltab2x128(:,:,77))
  call Hloop_A_Q(ntryL,G0H32(1),80,0,G1H32(14),n2h32(28))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(370)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(78),h0tab(:,78),[96,6,9,16],[0,0,0,0],4,3,wf4(:,9),wf4(:,11),wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,13),heltab2x128(:,:,78))
  call Hloop_Q_A(ntryL,G0H32(1),96,0,G1H32(16),n2h32(29))
Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(371)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(79),h0tab(:,79),[96,6,9,16],[0,0,0,0],4,3,wf4(:,9),wf4(:,14),wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,14),heltab2x128(:,:,79))
  call Hloop_Q_A(ntryL,G0H32(1),96,0,G1H32(17),n2h32(30))
Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(370)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(80),h0tab(:,80),[96,9,6,16],[0,0,0,0],4,3,wf4(:,9),wf4(:,12),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,15),heltab2x128(:,:,80))
  call Hloop_Q_A(ntryL,G0H32(1),96,0,G1H32(18),n2h32(31))
Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(371)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(81),h0tab(:,81),[96,9,6,16],[0,0,0,0],4,3,wf4(:,9),wf4(:,12),wf4(:,14))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,16),heltab2x128(:,:,81))
  call Hloop_Q_A(ntryL,G0H32(1),96,0,G1H32(19),n2h32(32))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(299)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(82),h0tab(:,82),[64,25,6,32],[0,0,0,0],4,2,wf8(:,26),wf4(:,11))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(34),m3h2x64(:,66),heltab2x128(:,:,82))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(301)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(83),h0tab(:,83),[64,25,6,32],[0,0,0,0],4,2,wf8(:,26),wf4(:,14))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(35),m3h2x64(:,67),heltab2x128(:,:,83))
Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(299)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(84),h0tab(:,84),[64,6,25,32],[0,0,0,0],4,2,wf4(:,11),wf8(:,26))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,68),heltab2x128(:,:,84))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(36),n2h64(47))
Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(301)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(85),h0tab(:,85),[64,6,25,32],[0,0,0,0],4,2,wf4(:,14),wf8(:,26))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,69),heltab2x128(:,:,85))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(37),n2h64(48))
Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(299)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(86),h0tab(:,86),[64,6,32,25],[0,0,0,0],4,2,wf4(:,11),wf8(:,26))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,70),heltab2x128(:,:,86))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(38),n2h64(49))
Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(301)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(87),h0tab(:,87),[64,6,32,25],[0,0,0,0],4,2,wf4(:,14),wf8(:,26))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,71),heltab2x128(:,:,87))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(39),n2h64(50))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(304)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(88),h0tab(:,88),[64,16,6,41],[0,0,0,0],4,2,wf4(:,11),wf8(:,20))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(40),m3h2x64(:,72),heltab2x128(:,:,88))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(306)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(89),h0tab(:,89),[64,16,6,41],[0,0,0,0],4,2,wf4(:,14),wf8(:,20))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(41),m3h2x64(:,73),heltab2x128(:,:,89))
Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(304)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(90),h0tab(:,90),[64,6,41,16],[0,0,0,0],4,2,wf4(:,11),wf8(:,20))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,74),heltab2x128(:,:,90))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(42),n2h64(51))
Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(306)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(91),h0tab(:,91),[64,6,41,16],[0,0,0,0],4,2,wf4(:,14),wf8(:,20))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,75),heltab2x128(:,:,91))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(43),n2h64(52))
Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(304)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(92),h0tab(:,92),[64,6,16,41],[0,0,0,0],4,2,wf4(:,11),wf8(:,20))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,76),heltab2x128(:,:,92))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(44),n2h64(53))
Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(306)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(93),h0tab(:,93),[64,6,16,41],[0,0,0,0],4,2,wf4(:,14),wf8(:,20))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,77),heltab2x128(:,:,93))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(45),n2h64(54))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(308)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(94),h0tab(:,94),[64,22,9,32],[0,0,0,0],4,2,wf8(:,28),wf4(:,12))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(46),m3h2x64(:,78),heltab2x128(:,:,94))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(310)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(95),h0tab(:,95),[64,22,9,32],[0,0,0,0],4,2,wf8(:,30),wf4(:,12))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(47),m3h2x64(:,79),heltab2x128(:,:,95))
Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(308)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(96),h0tab(:,96),[64,9,22,32],[0,0,0,0],4,2,wf4(:,12),wf8(:,28))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,80),heltab2x128(:,:,96))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(48),n2h64(55))
Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(310)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(97),h0tab(:,97),[64,9,22,32],[0,0,0,0],4,2,wf4(:,12),wf8(:,30))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,81),heltab2x128(:,:,97))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(49),n2h64(56))
Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(308)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(98),h0tab(:,98),[64,9,32,22],[0,0,0,0],4,2,wf4(:,12),wf8(:,28))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,82),heltab2x128(:,:,98))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(50),n2h64(57))
Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(310)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(99),h0tab(:,99),[64,9,32,22],[0,0,0,0],4,2,wf4(:,12),wf8(:,30))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,83),heltab2x128(:,:,99))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(51),n2h64(58))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(312)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(100),h0tab(:,100),[64,16,9,38],[0,0,0,0],4,2,wf4(:,12),wf8(:,22))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(52),m3h2x64(:,84),heltab2x128(:,:,100))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(314)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(101),h0tab(:,101),[64,16,9,38],[0,0,0,0],4,2,wf4(:,12),wf8(:,24))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(53),m3h2x64(:,85),heltab2x128(:,:,101))
Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(312)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(102),h0tab(:,102),[64,9,38,16],[0,0,0,0],4,2,wf4(:,12),wf8(:,22))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,86),heltab2x128(:,:,102))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(54),n2h64(59))
Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(314)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(103),h0tab(:,103),[64,9,38,16],[0,0,0,0],4,2,wf4(:,12),wf8(:,24))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,87),heltab2x128(:,:,103))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(55),n2h64(60))
Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(312)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(104),h0tab(:,104),[64,9,16,38],[0,0,0,0],4,2,wf4(:,12),wf8(:,22))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,88),heltab2x128(:,:,104))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(56),n2h64(61))
Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(314)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(105),h0tab(:,105),[64,9,16,38],[0,0,0,0],4,2,wf4(:,12),wf8(:,24))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,89),heltab2x128(:,:,105))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(57),n2h64(62))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(140)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(106),h0tab(:,106),[64,15,32,16],[0,0,0,0],4,1,wf16(:,70))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,90),heltab2x128(:,:,106))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(58),n2h64(63))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(142)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(107),h0tab(:,107),[64,15,32,16],[0,0,0,0],4,1,wf16(:,71))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,91),heltab2x128(:,:,107))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(59),n2h64(64))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(140)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(108),h0tab(:,108),[64,15,16,32],[0,0,0,0],4,1,wf16(:,70))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,92),heltab2x128(:,:,108))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(60),n2h64(65))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(142)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(109),h0tab(:,109),[64,15,16,32],[0,0,0,0],4,1,wf16(:,71))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,93),heltab2x128(:,:,109))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(61),n2h64(66))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(140)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(110),h0tab(:,110),[64,16,15,32],[0,0,0,0],4,1,wf16(:,70))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(62),m3h2x64(:,94),heltab2x128(:,:,110))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(142)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(111),h0tab(:,111),[64,16,15,32],[0,0,0,0],4,1,wf16(:,71))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(63),m3h2x64(:,95),heltab2x128(:,:,111))
Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(249)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(112),h0tab(:,112),[64,15,32,16],[0,0,0,0],4,1,wf16(:,118))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,96),heltab2x128(:,:,112))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(64),n2h64(67))
Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(249)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(113),h0tab(:,113),[64,15,16,32],[0,0,0,0],4,1,wf16(:,118))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,97),heltab2x128(:,:,113))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(65),n2h64(68))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(249)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(114),h0tab(:,114),[64,16,15,32],[0,0,0,0],4,1,wf16(:,118))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(66),m3h2x64(:,98),heltab2x128(:,:,114))
Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(251)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(115),h0tab(:,115),[64,15,32,16],[0,0,0,0],4,1,wf16(:,119))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,99),heltab2x128(:,:,115))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(67),n2h64(69))
Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(253)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(116),h0tab(:,116),[64,15,32,16],[0,0,0,0],4,1,wf16(:,120))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,100),heltab2x128(:,:,116))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(68),n2h64(70))
Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(251)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(117),h0tab(:,117),[64,15,16,32],[0,0,0,0],4,1,wf16(:,119))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,101),heltab2x128(:,:,117))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(69),n2h64(71))
Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(253)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(118),h0tab(:,118),[64,15,16,32],[0,0,0,0],4,1,wf16(:,120))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,102),heltab2x128(:,:,118))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(70),n2h64(72))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(251)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(119),h0tab(:,119),[64,16,15,32],[0,0,0,0],4,1,wf16(:,119))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(71),m3h2x64(:,103),heltab2x128(:,:,119))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(253)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(120),h0tab(:,120),[64,16,15,32],[0,0,0,0],4,1,wf16(:,120))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(72),m3h2x64(:,104),heltab2x128(:,:,120))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(258)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(121),h0tab(:,121),[64,15,32,16],[0,0,0,0],4,1,wf16(:,121))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,105),heltab2x128(:,:,121))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(73),n2h64(73))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(258)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(122),h0tab(:,122),[64,15,16,32],[0,0,0,0],4,1,wf16(:,121))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,106),heltab2x128(:,:,122))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(74),n2h64(74))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(258)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(123),h0tab(:,123),[64,16,15,32],[0,0,0,0],4,1,wf16(:,121))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(75),m3h2x64(:,107),heltab2x128(:,:,123))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(261)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(124),h0tab(:,124),[64,15,32,16],[0,0,0,0],4,1,wf16(:,122))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,108),heltab2x128(:,:,124))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(76),n2h64(75))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(261)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(125),h0tab(:,125),[64,15,16,32],[0,0,0,0],4,1,wf16(:,122))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,109),heltab2x128(:,:,125))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(77),n2h64(76))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(261)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(126),h0tab(:,126),[64,16,15,32],[0,0,0,0],4,1,wf16(:,122))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(78),m3h2x64(:,110),heltab2x128(:,:,126))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(263)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(127),h0tab(:,127),[64,15,32,16],[0,0,0,0],4,1,wf16(:,123))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,111),heltab2x128(:,:,127))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(79),n2h64(77))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(265)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(128),h0tab(:,128),[64,15,32,16],[0,0,0,0],4,1,wf16(:,124))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,112),heltab2x128(:,:,128))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(80),n2h64(78))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(263)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(129),h0tab(:,129),[64,15,16,32],[0,0,0,0],4,1,wf16(:,123))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,113),heltab2x128(:,:,129))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(81),n2h64(79))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(265)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(130),h0tab(:,130),[64,15,16,32],[0,0,0,0],4,1,wf16(:,124))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,114),heltab2x128(:,:,130))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(82),n2h64(80))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(263)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(131),h0tab(:,131),[64,16,15,32],[0,0,0,0],4,1,wf16(:,123))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(83),m3h2x64(:,115),heltab2x128(:,:,131))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(265)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(132),h0tab(:,132),[64,16,15,32],[0,0,0,0],4,1,wf16(:,124))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(84),m3h2x64(:,116),heltab2x128(:,:,132))
  call ol_merge(ntryL,G1H32(4),[G1H32(3)])
  call ol_merge(ntryL,G1H32(5),[G1H32(9)])
  call ol_merge(ntryL,G1H32(1),[G1H32(15)])
  call ol_merge(ntryL,G1H32(2),[G1H32(21)])
  call ol_merge(ntryL,G1H32(13),[G1H32(27)])
  call ol_merge(ntryL,G1H32(14),[G1H32(33)])
  call ol_merge(ntryL,G1H32(11),[G1H32(39)])
  call ol_merge(ntryL,G1H32(12),[G1H32(45)])
  call Hloop_AW_Q(ntryL,G1H16(3),wf4(:,4),G1H4(24),m3h4x4(:,49),heltab2x16(:,:,67))
  call Hloop_A_Q(ntryL,G1H4(24),79,0,G2H4(13),n2h4(67))
  call Hloop_AV_Q(ntryL,G1H16(9),wf4(:,2),G1H4(35),m3h4x4(:,50),heltab2x16(:,:,68))
  call Hloop_A_Q(ntryL,G1H4(35),79,0,G2H4(15),n2h4(68))
  call Hloop_AZ_Q(ntryL,G1H16(15),wf4(:,7),G1H4(46),ngZd,m3h4x4(:,51),heltab2x16(:,:,69))
  call Hloop_A_Q(ntryL,G1H4(46),79,0,G2H4(16),n2h4(69))
  call Hloop_QW_A(ntryL,G1H16(21),wf4(:,4),G1H4(57),m3h4x4(:,52),heltab2x16(:,:,70))
  call Hloop_Q_A(ntryL,G1H4(57),79,0,G2H4(21),n2h4(70))
  call Hloop_QV_A(ntryL,G1H16(27),wf4(:,2),G1H4(68),m3h4x4(:,53),heltab2x16(:,:,71))
  call Hloop_Q_A(ntryL,G1H4(68),79,0,G2H4(23),n2h4(71))
  call Hloop_QZ_A(ntryL,G1H16(33),wf4(:,7),G1H4(79),ngZu,m3h4x4(:,54),heltab2x16(:,:,72))
  call Hloop_Q_A(ntryL,G1H4(79),79,0,G2H4(24),n2h4(72))
  call Hloop_AW_Q(ntryL,G1H32(4),wf4(:,4),G1H8(41),m3h4x8(:,33),heltab2x32(:,:,41))
  call Hloop_A_Q(ntryL,G1H8(41),85,0,G2H8(1),n2h8(57))
  call Hloop_AW_Q(ntryL,G1H32(5),wf4(:,4),G1H8(42),m3h4x8(:,34),heltab2x32(:,:,42))
  call Hloop_A_Q(ntryL,G1H8(42),85,0,G2H8(2),n2h8(58))
  call Hloop_AV_Q(ntryL,G1H32(1),wf4(:,2),G1H8(57),m3h4x8(:,35),heltab2x32(:,:,43))
  call Hloop_A_Q(ntryL,G1H8(57),90,0,G2H8(3),n2h8(59))
  call Hloop_AZ_Q(ntryL,G1H32(2),wf4(:,7),G1H8(58),ngZu,m3h4x8(:,36),heltab2x32(:,:,44))
  call Hloop_A_Q(ntryL,G1H8(58),90,0,G2H8(4),n2h8(60))
  call Hloop_AW_Q(ntryL,G1H16(39),wf4(:,12),G1H4(19),m3h4x4(:,55),heltab2x16(:,:,73))
  call Hloop_A_Q(ntryL,G1H4(19),79,0,G2H4(25),n2h4(73))
  call Hloop_AV_Q(ntryL,G1H16(45),wf4(:,11),G1H4(20),m3h4x4(:,56),heltab2x16(:,:,74))
  call Hloop_A_Q(ntryL,G1H4(20),79,0,G2H4(27),n2h4(74))
  call Hloop_AZ_Q(ntryL,G1H16(51),wf4(:,14),G1H4(25),ngZd,m3h4x4(:,57),heltab2x16(:,:,75))
  call Hloop_A_Q(ntryL,G1H4(25),79,0,G2H4(28),n2h4(75))
  call Hloop_QW_A(ntryL,G1H16(57),wf4(:,12),G1H4(26),m3h4x4(:,58),heltab2x16(:,:,76))
  call Hloop_Q_A(ntryL,G1H4(26),79,0,G2H4(33),n2h4(76))
  call Hloop_QV_A(ntryL,G1H16(63),wf4(:,11),G1H4(30),m3h4x4(:,59),heltab2x16(:,:,77))
  call Hloop_Q_A(ntryL,G1H4(30),79,0,G2H4(35),n2h4(77))
  call Hloop_QZ_A(ntryL,G1H16(69),wf4(:,14),G1H4(31),ngZu,m3h4x4(:,60),heltab2x16(:,:,78))
  call Hloop_Q_A(ntryL,G1H4(31),79,0,G2H4(36),n2h4(78))
  call Hloop_AW_Q(ntryL,G1H32(13),wf4(:,12),G1H8(73),m3h4x8(:,37),heltab2x32(:,:,45))
  call Hloop_A_Q(ntryL,G1H8(73),89,0,G2H8(5),n2h8(61))
  call Hloop_AW_Q(ntryL,G1H32(14),wf4(:,12),G1H8(74),m3h4x8(:,38),heltab2x32(:,:,46))
  call Hloop_A_Q(ntryL,G1H8(74),89,0,G2H8(6),n2h8(62))
  call Hloop_AV_Q(ntryL,G1H32(11),wf4(:,11),G1H8(89),m3h4x8(:,39),heltab2x32(:,:,47))
  call Hloop_A_Q(ntryL,G1H8(89),86,0,G2H8(13),n2h8(63))
  call Hloop_AZ_Q(ntryL,G1H32(12),wf4(:,14),G1H8(90),ngZu,m3h4x8(:,40),heltab2x32(:,:,48))
  call Hloop_A_Q(ntryL,G1H8(90),86,0,G2H8(15),n2h8(64))
  call Hloop_QV_A(ntryL,G1H32(6),wf4(:,2),G1H8(105),m3h4x8(:,41),heltab2x32(:,:,49))
  call Hloop_Q_A(ntryL,G1H8(105),106,0,G2H8(16),n2h8(65))
  call Hloop_QZ_A(ntryL,G1H32(7),wf4(:,7),G1H8(106),ngZd,m3h4x8(:,42),heltab2x32(:,:,50))
  call Hloop_Q_A(ntryL,G1H8(106),106,0,G2H8(17),n2h8(66))
  call Hloop_QW_A(ntryL,G1H32(8),wf4(:,4),G1H8(121),m3h4x8(:,43),heltab2x32(:,:,51))
  call Hloop_Q_A(ntryL,G1H8(121),101,0,G2H8(19),n2h8(67))
  call Hloop_QW_A(ntryL,G1H32(10),wf4(:,4),G1H8(122),m3h4x8(:,44),heltab2x32(:,:,52))
  call Hloop_Q_A(ntryL,G1H8(122),101,0,G2H8(20),n2h8(68))
  call Hloop_VA_Q(ntryL,G1H64(1),wf8(:,10),G1H8(1),m3h8x8(:,1),heltab2x64(:,:,33))
  call Hloop_A_Q(ntryL,G1H8(1),85,0,G2H8(25),n2h8(69))
  call Hloop_VA_Q(ntryL,G1H64(2),wf8(:,10),G1H8(2),m3h8x8(:,2),heltab2x64(:,:,34))
  call Hloop_A_Q(ntryL,G1H8(2),85,0,G2H8(27),n2h8(70))
  call Hloop_QV_A(ntryL,G1H64(3),wf4(:,2),G1H16(11),m3h4x16(:,25),heltab2x64(:,:,35))
  call Hloop_Q_A(ntryL,G1H16(11),74,0,G2H16(9),n2h16(37))
  call Hloop_QZ_A(ntryL,G1H64(4),wf4(:,7),G1H16(12),ngZd,m3h4x16(:,26),heltab2x64(:,:,36))
  call Hloop_Q_A(ntryL,G1H16(12),74,0,G2H16(10),n2h16(38))
  call Hloop_AV_Q(ntryL,G1H64(5),wf4(:,2),G1H16(13),m3h4x16(:,27),heltab2x64(:,:,37))
  call Hloop_A_Q(ntryL,G1H16(13),74,0,G2H16(11),n2h16(39))
  call Hloop_AZ_Q(ntryL,G1H64(6),wf4(:,7),G1H16(14),ngZd,m3h4x16(:,28),heltab2x64(:,:,38))
  call Hloop_A_Q(ntryL,G1H16(14),74,0,G2H16(12),n2h16(40))
  call Hloop_VA_Q(ntryL,G1H64(7),ex5(:),G1H32(20),m3h2x32(:,9),heltab2x64(:,:,39))
  call Hloop_A_Q(ntryL,G1H32(20),80,0,G2H32(1),n2h32(33))
  call Hloop_VA_Q(ntryL,G1H64(8),ex5(:),G1H32(22),m3h2x32(:,10),heltab2x64(:,:,40))
  call Hloop_A_Q(ntryL,G1H32(22),80,0,G2H32(2),n2h32(34))
  call Hloop_AV_Q(ntryL,G1H64(9),wf4(:,2),G1H16(16),m3h4x16(:,29),heltab2x64(:,:,41))
  call Hloop_A_Q(ntryL,G1H16(16),74,0,G2H16(14),n2h16(41))
  call Hloop_AZ_Q(ntryL,G1H64(10),wf4(:,7),G1H16(17),ngZu,m3h4x16(:,30),heltab2x64(:,:,42))
  call Hloop_A_Q(ntryL,G1H16(17),74,0,G2H16(15),n2h16(42))
  call Hloop_QV_A(ntryL,G1H64(11),wf4(:,2),G1H16(18),m3h4x16(:,31),heltab2x64(:,:,43))
  call Hloop_Q_A(ntryL,G1H16(18),74,0,G2H16(16),n2h16(43))
  call Hloop_QZ_A(ntryL,G1H64(12),wf4(:,7),G1H16(19),ngZu,m3h4x16(:,32),heltab2x64(:,:,44))
  call Hloop_Q_A(ntryL,G1H16(19),74,0,G2H16(18),n2h16(44))
  call Hloop_VA_Q(ntryL,G1H64(13),wf8(:,12),G1H8(5),m3h8x8(:,3),heltab2x64(:,:,45))
  call Hloop_A_Q(ntryL,G1H8(5),90,0,G2H8(28),n2h8(71))
  call Hloop_VA_Q(ntryL,G1H64(14),wf8(:,14),G1H8(6),m3h8x8(:,4),heltab2x64(:,:,46))
  call Hloop_A_Q(ntryL,G1H8(6),90,0,G2H8(35),n2h8(72))
  call Hloop_QW_A(ntryL,G1H64(15),wf4(:,4),G1H16(20),m3h4x16(:,33),heltab2x64(:,:,47))
  call Hloop_Q_A(ntryL,G1H16(20),69,0,G2H16(20),n2h16(45))
  call Hloop_QW_A(ntryL,G1H64(16),wf4(:,4),G1H16(22),m3h4x16(:,34),heltab2x64(:,:,48))
  call Hloop_Q_A(ntryL,G1H16(22),69,0,G2H16(21),n2h16(46))
  call Hloop_AW_Q(ntryL,G1H64(17),wf4(:,4),G1H16(23),m3h4x16(:,35),heltab2x64(:,:,49))
  call Hloop_A_Q(ntryL,G1H16(23),69,0,G2H16(22),n2h16(47))
  call Hloop_AW_Q(ntryL,G1H64(18),wf4(:,4),G1H16(24),m3h4x16(:,36),heltab2x64(:,:,50))
  call Hloop_A_Q(ntryL,G1H16(24),69,0,G2H16(24),n2h16(48))
  call Hloop_VA_Q(ntryL,G1H64(19),ex5(:),G1H32(23),m3h2x32(:,11),heltab2x64(:,:,51))
  call Hloop_A_Q(ntryL,G1H32(23),80,0,G2H32(3),n2h32(35))
  call Hloop_VA_Q(ntryL,G1H64(20),ex5(:),G1H32(24),m3h2x32(:,12),heltab2x64(:,:,52))
  call Hloop_A_Q(ntryL,G1H32(24),80,0,G2H32(4),n2h32(36))
  call Hloop_AW_Q(ntryL,G1H64(21),wf4(:,4),G1H16(25),m3h4x16(:,37),heltab2x64(:,:,53))
  call Hloop_A_Q(ntryL,G1H16(25),69,0,G2H16(1),n2h16(49))
  call Hloop_AW_Q(ntryL,G1H64(22),wf4(:,4),G1H16(26),m3h4x16(:,38),heltab2x64(:,:,54))
  call Hloop_A_Q(ntryL,G1H16(26),69,0,G2H16(5),n2h16(50))
  call Hloop_QW_A(ntryL,G1H64(23),wf4(:,4),G1H16(28),m3h4x16(:,39),heltab2x64(:,:,55))
  call Hloop_Q_A(ntryL,G1H16(28),69,0,G2H16(13),n2h16(51))
  call Hloop_QW_A(ntryL,G1H64(24),wf4(:,4),G1H16(29),m3h4x16(:,40),heltab2x64(:,:,56))
  call Hloop_Q_A(ntryL,G1H16(29),69,0,G2H16(17),n2h16(52))
  call Hloop_AW_Q(ntryL,G1H64(25),wf16(:,42),G1H4(36),m3h16x4(:,1),heltab2x64(:,:,57))
  call Hloop_A_Q(ntryL,G1H4(36),79,0,G2H4(37),n2h4(79))
  call Hloop_AW_Q(ntryL,G1H64(26),wf16(:,43),G1H4(37),m3h16x4(:,2),heltab2x64(:,:,58))
  call Hloop_A_Q(ntryL,G1H4(37),79,0,G2H4(39),n2h4(80))
  call Hloop_QW_A(ntryL,G1H64(27),wf16(:,42),G1H4(41),m3h16x4(:,3),heltab2x64(:,:,59))
  call Hloop_Q_A(ntryL,G1H4(41),79,0,G2H4(40),n2h4(81))
  call Hloop_QW_A(ntryL,G1H64(28),wf16(:,43),G1H4(42),m3h16x4(:,4),heltab2x64(:,:,60))
  call Hloop_Q_A(ntryL,G1H4(42),79,0,G2H4(45),n2h4(82))
  call Hloop_VA_Q(ntryL,G1H64(29),ex5(:),G1H32(25),m3h2x32(:,13),heltab2x64(:,:,61))
  call Hloop_A_Q(ntryL,G1H32(25),80,0,G2H32(5),n2h32(37))
  call Hloop_VA_Q(ntryL,G1H64(30),ex5(:),G1H32(26),m3h2x32(:,14),heltab2x64(:,:,62))
  call Hloop_A_Q(ntryL,G1H32(26),80,0,G2H32(6),n2h32(38))
  call Hloop_AW_Q(ntryL,G1H64(31),wf16(:,102),G1H4(47),m3h16x4(:,5),heltab2x64(:,:,63))
  call Hloop_A_Q(ntryL,G1H4(47),79,0,G2H4(47),n2h4(83))
  call Hloop_QW_A(ntryL,G1H64(32),wf16(:,102),G1H4(48),m3h16x4(:,6),heltab2x64(:,:,64))
  call Hloop_Q_A(ntryL,G1H4(48),79,0,G2H4(48),n2h4(84))
  call Hloop_VA_Q(ntryL,G1H64(33),ex5(:),G1H32(28),m3h2x32(:,15),heltab2x64(:,:,65))
  call Hloop_A_Q(ntryL,G1H32(28),80,0,G2H32(7),n2h32(39))
  call Hloop_QV_A(ntryL,G1H32(16),wf4(:,11),G1H8(7),m3h4x8(:,45),heltab2x32(:,:,53))
  call Hloop_Q_A(ntryL,G1H8(7),102,0,G2H8(37),n2h8(73))
  call Hloop_QZ_A(ntryL,G1H32(17),wf4(:,14),G1H8(8),ngZd,m3h4x8(:,46),heltab2x32(:,:,54))
  call Hloop_Q_A(ntryL,G1H8(8),102,0,G2H8(38),n2h8(74))
  call Hloop_QW_A(ntryL,G1H32(18),wf4(:,12),G1H8(11),m3h4x8(:,47),heltab2x32(:,:,55))
  call Hloop_Q_A(ntryL,G1H8(11),105,0,G2H8(39),n2h8(75))
  call Hloop_QW_A(ntryL,G1H32(19),wf4(:,12),G1H8(12),m3h4x8(:,48),heltab2x32(:,:,56))
  call Hloop_Q_A(ntryL,G1H8(12),105,0,G2H8(41),n2h8(76))
  call Hloop_VA_Q(ntryL,G1H64(34),wf8(:,26),G1H8(13),m3h8x8(:,5),heltab2x64(:,:,66))
  call Hloop_A_Q(ntryL,G1H8(13),89,0,G2H8(42),n2h8(77))
  call Hloop_VA_Q(ntryL,G1H64(35),wf8(:,26),G1H8(14),m3h8x8(:,6),heltab2x64(:,:,67))
  call Hloop_A_Q(ntryL,G1H8(14),89,0,G2H8(47),n2h8(78))
  call Hloop_QV_A(ntryL,G1H64(36),wf4(:,11),G1H16(30),m3h4x16(:,41),heltab2x64(:,:,68))
  call Hloop_Q_A(ntryL,G1H16(30),70,0,G2H16(19),n2h16(53))
  call Hloop_QZ_A(ntryL,G1H64(37),wf4(:,14),G1H16(31),ngZd,m3h4x16(:,42),heltab2x64(:,:,69))
  call Hloop_Q_A(ntryL,G1H16(31),70,0,G2H16(23),n2h16(54))
  call Hloop_AV_Q(ntryL,G1H64(38),wf4(:,11),G1H16(32),m3h4x16(:,43),heltab2x64(:,:,70))
  call Hloop_A_Q(ntryL,G1H16(32),70,0,G2H16(2),n2h16(55))
  call Hloop_AZ_Q(ntryL,G1H64(39),wf4(:,14),G1H16(34),ngZd,m3h4x16(:,44),heltab2x64(:,:,71))
  call Hloop_A_Q(ntryL,G1H16(34),70,0,G2H16(3),n2h16(56))
  call Hloop_VA_Q(ntryL,G1H64(40),ex5(:),G1H32(29),m3h2x32(:,16),heltab2x64(:,:,72))
  call Hloop_A_Q(ntryL,G1H32(29),80,0,G2H32(8),n2h32(40))
  call Hloop_VA_Q(ntryL,G1H64(41),ex5(:),G1H32(30),m3h2x32(:,17),heltab2x64(:,:,73))
  call Hloop_A_Q(ntryL,G1H32(30),80,0,G2H32(9),n2h32(41))
  call Hloop_AV_Q(ntryL,G1H64(42),wf4(:,11),G1H16(35),m3h4x16(:,45),heltab2x64(:,:,74))
  call Hloop_A_Q(ntryL,G1H16(35),70,0,G2H16(4),n2h16(57))
  call Hloop_AZ_Q(ntryL,G1H64(43),wf4(:,14),G1H16(36),ngZu,m3h4x16(:,46),heltab2x64(:,:,75))
  call Hloop_A_Q(ntryL,G1H16(36),70,0,G2H16(6),n2h16(58))
  call Hloop_QV_A(ntryL,G1H64(44),wf4(:,11),G1H16(37),m3h4x16(:,47),heltab2x64(:,:,76))
  call Hloop_Q_A(ntryL,G1H16(37),70,0,G2H16(7),n2h16(59))
  call Hloop_QZ_A(ntryL,G1H64(45),wf4(:,14),G1H16(38),ngZu,m3h4x16(:,48),heltab2x64(:,:,77))
  call Hloop_Q_A(ntryL,G1H16(38),70,0,G2H16(8),n2h16(60))
  call Hloop_VA_Q(ntryL,G1H64(46),wf8(:,28),G1H8(17),m3h8x8(:,7),heltab2x64(:,:,78))
  call Hloop_A_Q(ntryL,G1H8(17),86,0,G2H8(49),n2h8(79))
  call Hloop_VA_Q(ntryL,G1H64(47),wf8(:,30),G1H8(18),m3h8x8(:,8),heltab2x64(:,:,79))
  call Hloop_A_Q(ntryL,G1H8(18),86,0,G2H8(50),n2h8(80))
  call Hloop_QW_A(ntryL,G1H64(48),wf4(:,12),G1H16(40),m3h4x16(:,49),heltab2x64(:,:,80))
  call Hloop_Q_A(ntryL,G1H16(40),73,0,G2H16(25),n2h16(61))
  call Hloop_QW_A(ntryL,G1H64(49),wf4(:,12),G1H16(41),m3h4x16(:,50),heltab2x64(:,:,81))
  call Hloop_Q_A(ntryL,G1H16(41),73,0,G2H16(26),n2h16(62))
  call Hloop_AW_Q(ntryL,G1H64(50),wf4(:,12),G1H16(42),m3h4x16(:,51),heltab2x64(:,:,82))
  call Hloop_A_Q(ntryL,G1H16(42),73,0,G2H16(27),n2h16(63))
  call Hloop_AW_Q(ntryL,G1H64(51),wf4(:,12),G1H16(43),m3h4x16(:,52),heltab2x64(:,:,83))
  call Hloop_A_Q(ntryL,G1H16(43),73,0,G2H16(28),n2h16(64))
  call Hloop_VA_Q(ntryL,G1H64(52),ex5(:),G1H32(31),m3h2x32(:,18),heltab2x64(:,:,84))
  call Hloop_A_Q(ntryL,G1H32(31),80,0,G2H32(10),n2h32(42))
  call Hloop_VA_Q(ntryL,G1H64(53),ex5(:),G1H32(32),m3h2x32(:,19),heltab2x64(:,:,85))
  call Hloop_A_Q(ntryL,G1H32(32),80,0,G2H32(11),n2h32(43))
  call Hloop_AW_Q(ntryL,G1H64(54),wf4(:,12),G1H16(44),m3h4x16(:,53),heltab2x64(:,:,86))
  call Hloop_A_Q(ntryL,G1H16(44),73,0,G2H16(29),n2h16(65))
  call Hloop_AW_Q(ntryL,G1H64(55),wf4(:,12),G1H16(46),m3h4x16(:,54),heltab2x64(:,:,87))
  call Hloop_A_Q(ntryL,G1H16(46),73,0,G2H16(30),n2h16(66))
  call Hloop_QW_A(ntryL,G1H64(56),wf4(:,12),G1H16(47),m3h4x16(:,55),heltab2x64(:,:,88))
  call Hloop_Q_A(ntryL,G1H16(47),73,0,G2H16(31),n2h16(67))
  call Hloop_QW_A(ntryL,G1H64(57),wf4(:,12),G1H16(48),m3h4x16(:,56),heltab2x64(:,:,89))
  call Hloop_Q_A(ntryL,G1H16(48),73,0,G2H16(32),n2h16(68))
  call Hloop_AW_Q(ntryL,G1H64(58),wf16(:,70),G1H4(52),m3h16x4(:,7),heltab2x64(:,:,90))
  call Hloop_A_Q(ntryL,G1H4(52),79,0,G2H4(5),n2h4(85))
  call Hloop_AW_Q(ntryL,G1H64(59),wf16(:,71),G1H4(53),m3h16x4(:,8),heltab2x64(:,:,91))
  call Hloop_A_Q(ntryL,G1H4(53),79,0,G2H4(8),n2h4(86))
  call Hloop_QW_A(ntryL,G1H64(60),wf16(:,70),G1H4(58),m3h16x4(:,9),heltab2x64(:,:,92))
  call Hloop_Q_A(ntryL,G1H4(58),79,0,G2H4(17),n2h4(87))
  call Hloop_QW_A(ntryL,G1H64(61),wf16(:,71),G1H4(59),m3h16x4(:,10),heltab2x64(:,:,93))
  call Hloop_Q_A(ntryL,G1H4(59),79,0,G2H4(20),n2h4(88))
  call Hloop_VA_Q(ntryL,G1H64(62),ex5(:),G1H32(34),m3h2x32(:,20),heltab2x64(:,:,94))
  call Hloop_A_Q(ntryL,G1H32(34),80,0,G2H32(12),n2h32(44))
  call Hloop_VA_Q(ntryL,G1H64(63),ex5(:),G1H32(35),m3h2x32(:,21),heltab2x64(:,:,95))
  call Hloop_A_Q(ntryL,G1H32(35),80,0,G2H32(13),n2h32(45))
  call Hloop_AW_Q(ntryL,G1H64(64),wf16(:,118),G1H4(63),m3h16x4(:,11),heltab2x64(:,:,96))
  call Hloop_A_Q(ntryL,G1H4(63),79,0,G2H4(29),n2h4(89))
  call Hloop_QW_A(ntryL,G1H64(65),wf16(:,118),G1H4(64),m3h16x4(:,12),heltab2x64(:,:,97))
  call Hloop_Q_A(ntryL,G1H4(64),79,0,G2H4(32),n2h4(90))
  call Hloop_VA_Q(ntryL,G1H64(66),ex5(:),G1H32(36),m3h2x32(:,22),heltab2x64(:,:,98))
  call Hloop_A_Q(ntryL,G1H32(36),80,0,G2H32(14),n2h32(46))
  call Hloop_AW_Q(ntryL,G1H64(67),wf16(:,119),G1H4(69),m3h16x4(:,13),heltab2x64(:,:,99))
  call Hloop_A_Q(ntryL,G1H4(69),79,0,G2H4(41),n2h4(91))
  call Hloop_AW_Q(ntryL,G1H64(68),wf16(:,120),G1H4(70),m3h16x4(:,14),heltab2x64(:,:,100))
  call Hloop_A_Q(ntryL,G1H4(70),79,0,G2H4(44),n2h4(92))
  call Hloop_QW_A(ntryL,G1H64(69),wf16(:,119),G1H4(74),m3h16x4(:,15),heltab2x64(:,:,101))
  call Hloop_Q_A(ntryL,G1H4(74),79,0,G2H4(1),n2h4(93))
  call Hloop_QW_A(ntryL,G1H64(70),wf16(:,120),G1H4(75),m3h16x4(:,16),heltab2x64(:,:,102))
  call Hloop_Q_A(ntryL,G1H4(75),79,0,G2H4(4),n2h4(94))
  call Hloop_VA_Q(ntryL,G1H64(71),ex5(:),G1H32(37),m3h2x32(:,23),heltab2x64(:,:,103))
  call Hloop_A_Q(ntryL,G1H32(37),80,0,G2H32(15),n2h32(47))
  call Hloop_VA_Q(ntryL,G1H64(72),ex5(:),G1H32(38),m3h2x32(:,24),heltab2x64(:,:,104))
  call Hloop_A_Q(ntryL,G1H32(38),80,0,G2H32(16),n2h32(48))
  call Hloop_AW_Q(ntryL,G1H64(73),wf16(:,121),G1H4(80),m3h16x4(:,17),heltab2x64(:,:,105))
  call Hloop_A_Q(ntryL,G1H4(80),79,0,G2H4(9),n2h4(95))
  call Hloop_QW_A(ntryL,G1H64(74),wf16(:,121),G1H4(81),m3h16x4(:,18),heltab2x64(:,:,106))
  call Hloop_Q_A(ntryL,G1H4(81),79,0,G2H4(12),n2h4(96))
  call Hloop_VA_Q(ntryL,G1H64(75),ex5(:),G1H32(40),m3h2x32(:,25),heltab2x64(:,:,107))
  call Hloop_A_Q(ntryL,G1H32(40),80,0,G2H32(17),n2h32(49))
  call Hloop_AW_Q(ntryL,G1H64(76),wf16(:,122),G1H4(24),m3h16x4(:,19),heltab2x64(:,:,108))
  call Hloop_A_Q(ntryL,G1H4(24),79,0,G2H4(49),n2h4(97))
  call Hloop_QW_A(ntryL,G1H64(77),wf16(:,122),G1H4(35),m3h16x4(:,20),heltab2x64(:,:,109))
  call Hloop_Q_A(ntryL,G1H4(35),79,0,G2H4(50),n2h4(98))
  call Hloop_VA_Q(ntryL,G1H64(78),ex5(:),G1H32(41),m3h2x32(:,26),heltab2x64(:,:,110))
  call Hloop_A_Q(ntryL,G1H32(41),80,0,G2H32(18),n2h32(50))
  call Hloop_AW_Q(ntryL,G1H64(79),wf16(:,123),G1H4(46),m3h16x4(:,21),heltab2x64(:,:,111))
  call Hloop_A_Q(ntryL,G1H4(46),79,0,G2H4(51),n2h4(99))
  call Hloop_AW_Q(ntryL,G1H64(80),wf16(:,124),G1H4(57),m3h16x4(:,22),heltab2x64(:,:,112))
  call Hloop_A_Q(ntryL,G1H4(57),79,0,G2H4(52),n2h4(100))
  call Hloop_QW_A(ntryL,G1H64(81),wf16(:,123),G1H4(68),m3h16x4(:,23),heltab2x64(:,:,113))
  call Hloop_Q_A(ntryL,G1H4(68),79,0,G2H4(53),n2h4(101))
  call Hloop_QW_A(ntryL,G1H64(82),wf16(:,124),G1H4(79),m3h16x4(:,24),heltab2x64(:,:,114))
  call Hloop_Q_A(ntryL,G1H4(79),79,0,G2H4(54),n2h4(102))
  call Hloop_VA_Q(ntryL,G1H64(83),ex5(:),G1H32(42),m3h2x32(:,27),heltab2x64(:,:,115))
  call Hloop_A_Q(ntryL,G1H32(42),80,0,G2H32(19),n2h32(51))
  call Hloop_VA_Q(ntryL,G1H64(84),ex5(:),G1H32(43),m3h2x32(:,28),heltab2x64(:,:,116))
  call Hloop_A_Q(ntryL,G1H32(43),80,0,G2H32(20),n2h32(52))
  call ol_merge(ntryL,G2H8(4),[G2H8(3),G1H8(71)])
call HGT_lower_alpha_w2_OLR(G2H8(7),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(7),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(7),6,15,8)
  call ol_merge(ntryL,G2H8(7),[G2H8(4)])
  call ol_merge(ntryL,G2H4(52),[G2H4(51),G2H4(49),G2H4(9),G2H4(44),G2H4(41),G2H4(29),G2H4(8),G2H4(5),G2H4(47),G2H4(39),G2H4(37) &
    ,G2H4(34),G2H4(30),G2H4(26),G2H4(10),G2H4(6),G2H4(2)])
  call ol_merge(ntryL,G2H8(1),[G1H8(39)])
call HGT_lower_alpha_w2_OLR(G2H8(8),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(8),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(8),6,15,8)
  call ol_merge(ntryL,G2H8(8),[G2H8(1)])
  call ol_merge(ntryL,G2H8(2),[G1H8(55)])
call HGT_lower_alpha_w2_OLR(G2H8(9),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(9),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(9),6,15,8)
  call ol_merge(ntryL,G2H8(9),[G2H8(2)])
  call ol_merge(ntryL,G2H8(17),[G2H8(16)])
call HGT_lower_alpha_w2_OLR(G2H8(10),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(10),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(10),6,15,8)
  call ol_merge(ntryL,G2H8(10),[G2H8(17)])
  call ol_merge(ntryL,G2H4(54),[G2H4(53),G2H4(50),G2H4(12),G2H4(4),G2H4(1),G2H4(32),G2H4(20),G2H4(17),G2H4(48),G2H4(45),G2H4(40) &
    ,G2H4(46),G2H4(42),G2H4(38),G2H4(22),G2H4(18),G2H4(14)])
call HGT_lower_alpha_w2_OLR(G2H8(11),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(11),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(11),6,15,8)
  call ol_merge(ntryL,G2H8(11),[G2H8(19)])
call HGT_lower_alpha_w2_OLR(G2H8(12),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(12),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(12),6,15,8)
  call ol_merge(ntryL,G2H8(12),[G2H8(20)])
  call ol_merge(ntryL,G2H8(25),[G2H8(14),G1H8(40)])
  call ol_merge(ntryL,G2H8(27),[G2H8(18),G1H8(56)])
  call ol_merge(ntryL,G2H8(35),[G2H8(28),G2H8(26),G2H8(22),G1H8(72)])
  call ol_merge(ntryL,G2H8(15),[G2H8(13),G1H8(119)])
call HGT_lower_alpha_w2_OLR(G2H8(29),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(29),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(29),6,15,8)
  call ol_merge(ntryL,G2H8(29),[G2H8(15)])
  call ol_merge(ntryL,G2H8(5),[G1H8(87)])
call HGT_lower_alpha_w2_OLR(G2H8(30),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(30),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(30),6,15,8)
  call ol_merge(ntryL,G2H8(30),[G2H8(5)])
  call ol_merge(ntryL,G2H8(6),[G1H8(103)])
call HGT_lower_alpha_w2_OLR(G2H8(31),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(31),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(31),6,15,8)
  call ol_merge(ntryL,G2H8(31),[G2H8(6)])
  call ol_merge(ntryL,G2H8(38),[G2H8(37)])
call HGT_lower_alpha_w2_OLR(G2H8(32),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(32),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(32),6,15,8)
  call ol_merge(ntryL,G2H8(32),[G2H8(38)])
call HGT_lower_alpha_w2_OLR(G2H8(33),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(33),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(33),6,15,8)
  call ol_merge(ntryL,G2H8(33),[G2H8(39)])
call HGT_lower_alpha_w2_OLR(G2H8(34),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(34),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(34),6,15,8)
  call ol_merge(ntryL,G2H8(34),[G2H8(41)])
  call ol_merge(ntryL,G2H8(42),[G2H8(36),G1H8(88)])
  call ol_merge(ntryL,G2H8(47),[G2H8(40),G1H8(104)])
  call ol_merge(ntryL,G2H8(50),[G2H8(49),G2H8(48),G2H8(44),G1H8(120)])
  call ol_merge(ntryL,G2H4(16),[G2H4(15)])
  call ol_merge(ntryL,G2H4(24),[G2H4(23)])
  call ol_merge(ntryL,G2H4(28),[G2H4(27)])
  call ol_merge(ntryL,G2H4(36),[G2H4(35)])
  call ol_merge(ntryL,G2H16(10),[G2H16(9)])
  call ol_merge(ntryL,G2H16(12),[G2H16(11)])
  call ol_merge(ntryL,G2H16(15),[G2H16(14)])
  call ol_merge(ntryL,G2H16(18),[G2H16(16)])
  call ol_merge(ntryL,G2H16(23),[G2H16(19)])
  call ol_merge(ntryL,G2H16(3),[G2H16(2)])
  call ol_merge(ntryL,G2H16(6),[G2H16(4)])
  call ol_merge(ntryL,G2H16(8),[G2H16(7)])
call Hotf_4pt_reduction(G2H8(7),RedSet_4(17),mass4set(:,1),  & 
G1H8(19),G1H8(20),G1H8(23),G1H8(24),G1H8(25),8)
call HG1shiftOLR(G1H8(20),32,8)
  call Hloop_AQ_V(ntryL,G2H4(52),ex6(:),G2H2(31),m3h2x2(:,25),heltab2x4(:,:,49))
call Hotf_4pt_reduction(G2H8(8),RedSet_4(14),mass4set(:,1),  & 
G1H8(26),G1H8(29),G1H8(30),G1H8(31),G1H8(32),8)
call HG1shiftOLR(G1H8(29),32,8)
call Hotf_4pt_reduction(G2H8(9),RedSet_4(14),mass4set(:,1),  & 
G1H8(35),G1H8(36),G1H8(37),G1H8(38),G1H8(43),8)
call HG1shiftOLR(G1H8(36),32,8)
call Hotf_4pt_reduction(G2H8(10),RedSet_4(66),mass4set(:,1),  & 
G1H8(48),G1H8(44),G1H8(47),G1H8(49),G1H8(52),8)
call HG1shiftOLR(G1H8(44),16,8)
  call Hloop_QA_V(ntryL,G2H4(54),ex5(:),G2H2(33),m3h2x2(:,26),heltab2x4(:,:,50))
call Hotf_4pt_reduction(G2H8(11),RedSet_4(67),mass4set(:,1),  & 
G1H8(53),G1H8(54),G1H8(59),G1H8(64),G1H8(60),8)
call HG1shiftOLR(G1H8(54),16,8)
call Hotf_4pt_reduction(G2H8(12),RedSet_4(67),mass4set(:,1),  & 
G1H8(63),G1H8(65),G1H8(68),G1H8(69),G1H8(70),8)
call HG1shiftOLR(G1H8(65),16,8)
call HGT_w2_OLR(G1H16(1),1,1,16)
call HGT_w2_invQ_OLR(G1H16(1),2,5,16)
  call Hloop_AW_Q(ntryL,G1H16(1),wf4(:,4),G1H4(19),m3h4x4(:,61),heltab2x16(:,:,79))
  call Hloop_A_Q(ntryL,G1H4(19),117,0,G2H4(51),n2h4(103))
call Hotf_4pt_reduction(G2H8(25),RedSet_4(15),mass4set(:,1),  & 
G1H8(75),G1H8(80),G1H8(76),G1H8(79),G1H8(81),8)
call HG1shiftOLR(G1H8(80),32,8)
call HGT_w2_OLR(G1H16(2),1,1,16)
call HGT_w2_invQ_OLR(G1H16(2),2,5,16)
  call Hloop_AW_Q(ntryL,G1H16(2),wf4(:,4),G1H4(20),m3h4x4(:,62),heltab2x16(:,:,80))
  call Hloop_A_Q(ntryL,G1H4(20),117,0,G2H4(49),n2h4(104))
call Hotf_4pt_reduction(G2H8(27),RedSet_4(15),mass4set(:,1),  & 
G1H8(84),G1H8(85),G1H8(86),G1H8(91),G1H8(96),8)
call HG1shiftOLR(G1H8(85),32,8)
call HGT_w2_OLR(G1H16(4),1,1,16)
call HGT_w2_invQ_OLR(G1H16(4),2,5,16)
  call Hloop_AV_Q(ntryL,G1H16(4),wf4(:,2),G1H4(25),m3h4x4(:,63),heltab2x16(:,:,81))
  call Hloop_A_Q(ntryL,G1H4(25),122,0,G2H4(9),n2h4(105))
call Hotf_4pt_reduction(G2H8(35),RedSet_4(18),mass4set(:,1),  & 
G1H8(92),G1H8(95),G1H8(97),G1H8(100),G1H8(101),8)
call HG1shiftOLR(G1H8(95),32,8)
call HGT_w2_OLR(G1H16(5),1,1,16)
call HGT_w2_invQ_OLR(G1H16(5),2,5,16)
  call Hloop_AZ_Q(ntryL,G1H16(5),wf4(:,7),G1H4(26),ngZu,m3h4x4(:,64),heltab2x16(:,:,82))
  call Hloop_A_Q(ntryL,G1H4(26),122,0,G2H4(44),n2h4(106))
call Hotf_4pt_reduction(G2H8(29),RedSet_4(23),mass4set(:,1),  & 
G1H8(102),G1H8(107),G1H8(112),G1H8(108),G1H8(111),8)
call HG1shiftOLR(G1H8(107),32,8)
call Hotf_4pt_reduction(G2H8(30),RedSet_4(20),mass4set(:,1),  & 
G1H8(113),G1H8(116),G1H8(117),G1H8(118),G1H8(123),8)
call HG1shiftOLR(G1H8(116),32,8)
call Hotf_4pt_reduction(G2H8(31),RedSet_4(20),mass4set(:,1),  & 
G1H8(128),G1H8(124),G1H8(127),G1H8(129),G1H8(132),8)
call HG1shiftOLR(G1H8(124),32,8)
call Hotf_4pt_reduction(G2H8(32),RedSet_4(68),mass4set(:,1),  & 
G1H8(41),G1H8(42),G1H8(57),G1H8(58),G1H8(73),8)
call HG1shiftOLR(G1H8(42),16,8)
call Hotf_4pt_reduction(G2H8(33),RedSet_4(69),mass4set(:,1),  & 
G1H8(74),G1H8(89),G1H8(90),G1H8(105),G1H8(106),8)
call HG1shiftOLR(G1H8(89),16,8)
call Hotf_4pt_reduction(G2H8(34),RedSet_4(69),mass4set(:,1),  & 
G1H8(121),G1H8(122),G1H8(1),G1H8(2),G1H8(5),8)
call HG1shiftOLR(G1H8(122),16,8)
call HGT_w2_OLR(G1H16(6),1,1,16)
call HGT_w2_invQ_OLR(G1H16(6),2,5,16)
  call Hloop_AW_Q(ntryL,G1H16(6),wf4(:,12),G1H4(30),m3h4x4(:,65),heltab2x16(:,:,83))
  call Hloop_A_Q(ntryL,G1H4(30),121,0,G2H4(41),n2h4(107))
call Hotf_4pt_reduction(G2H8(42),RedSet_4(21),mass4set(:,1),  & 
G1H8(6),G1H8(7),G1H8(8),G1H8(11),G1H8(12),8)
call HG1shiftOLR(G1H8(7),32,8)
call HGT_w2_OLR(G1H16(7),1,1,16)
call HGT_w2_invQ_OLR(G1H16(7),2,5,16)
  call Hloop_AW_Q(ntryL,G1H16(7),wf4(:,12),G1H4(31),m3h4x4(:,66),heltab2x16(:,:,84))
  call Hloop_A_Q(ntryL,G1H4(31),121,0,G2H4(29),n2h4(108))
call Hotf_4pt_reduction(G2H8(47),RedSet_4(21),mass4set(:,1),  & 
G1H8(13),G1H8(14),G1H8(17),G1H8(18),G1H8(71),8)
call HG1shiftOLR(G1H8(14),32,8)
call HGT_w2_OLR(G1H16(8),1,1,16)
call HGT_w2_invQ_OLR(G1H16(8),2,5,16)
  call Hloop_AV_Q(ntryL,G1H16(8),wf4(:,11),G1H4(36),m3h4x4(:,67),heltab2x16(:,:,85))
  call Hloop_A_Q(ntryL,G1H4(36),118,0,G2H4(8),n2h4(109))
call Hotf_4pt_reduction(G2H8(50),RedSet_4(24),mass4set(:,1),  & 
G1H8(39),G1H8(55),G1H8(40),G1H8(56),G1H8(72),8)
call HG1shiftOLR(G1H8(55),32,8)
call HGT_w2_OLR(G1H16(10),1,1,16)
call HGT_w2_invQ_OLR(G1H16(10),2,5,16)
  call Hloop_AZ_Q(ntryL,G1H16(10),wf4(:,14),G1H4(37),ngZu,m3h4x4(:,68),heltab2x16(:,:,86))
  call Hloop_A_Q(ntryL,G1H4(37),118,0,G2H4(5),n2h4(110))
  call Hloop_VQ_A(ntryL,G1H8(3),ex6(:),G1H4(41),m3h2x4(:,37),heltab2x8(:,:,73))
  call Hloop_Q_A(ntryL,G1H4(41),117,0,G2H4(47),n2h4(111))
  call Hloop_VQ_A(ntryL,G1H8(4),ex6(:),G1H4(42),m3h2x4(:,38),heltab2x8(:,:,74))
  call Hloop_Q_A(ntryL,G1H4(42),117,0,G2H4(39),n2h4(112))
  call Hloop_VQ_A(ntryL,G1H8(9),ex6(:),G1H4(47),m3h2x4(:,39),heltab2x8(:,:,75))
  call Hloop_Q_A(ntryL,G1H4(47),117,0,G2H4(37),n2h4(113))
  call Hloop_VQ_A(ntryL,G1H8(10),ex6(:),G1H4(48),m3h2x4(:,40),heltab2x8(:,:,76))
  call Hloop_Q_A(ntryL,G1H4(48),117,0,G2H4(34),n2h4(114))
  call Hloop_VA_Q(ntryL,G1H8(15),ex5(:),G1H4(52),m3h2x4(:,41),heltab2x8(:,:,77))
  call Hloop_A_Q(ntryL,G1H4(52),117,0,G2H4(30),n2h4(115))
  call Hloop_VA_Q(ntryL,G1H8(16),ex5(:),G1H4(53),m3h2x4(:,42),heltab2x8(:,:,78))
  call Hloop_A_Q(ntryL,G1H4(53),117,0,G2H4(26),n2h4(116))
  call Hloop_VA_Q(ntryL,G1H8(21),ex5(:),G1H4(58),m3h2x4(:,43),heltab2x8(:,:,79))
  call Hloop_A_Q(ntryL,G1H4(58),117,0,G2H4(10),n2h4(117))
  call Hloop_VA_Q(ntryL,G1H8(22),ex5(:),G1H4(59),m3h2x4(:,44),heltab2x8(:,:,80))
  call Hloop_A_Q(ntryL,G1H4(59),117,0,G2H4(6),n2h4(118))
  call Hloop_VA_Q(ntryL,G1H8(27),ex5(:),G1H4(63),m3h2x4(:,45),heltab2x8(:,:,81))
  call Hloop_A_Q(ntryL,G1H4(63),118,0,G2H4(2),n2h4(119))
  call Hloop_VA_Q(ntryL,G1H8(28),ex5(:),G1H4(64),m3h2x4(:,46),heltab2x8(:,:,82))
  call Hloop_A_Q(ntryL,G1H4(64),118,0,G2H4(53),n2h4(120))
  call Hloop_VQ_A(ntryL,G1H8(33),ex6(:),G1H4(69),m3h2x4(:,47),heltab2x8(:,:,83))
  call Hloop_Q_A(ntryL,G1H4(69),118,0,G2H4(50),n2h4(121))
  call Hloop_VQ_A(ntryL,G1H8(34),ex6(:),G1H4(70),m3h2x4(:,48),heltab2x8(:,:,84))
  call Hloop_Q_A(ntryL,G1H4(70),118,0,G2H4(12),n2h4(122))
  call Hloop_AV_Q(ntryL,G1H8(45),wf4(:,2),G1H2(6),m3h4x2(:,37),heltab2x8(:,:,85))
  call Hloop_A_Q(ntryL,G1H2(6),95,0,G2H2(46),n2h2(31))
  call Hloop_AV_Q(ntryL,G1H8(46),wf4(:,2),G1H2(17),m3h4x2(:,38),heltab2x8(:,:,86))
  call Hloop_A_Q(ntryL,G1H2(17),95,0,G2H2(48),n2h2(32))
  call Hloop_AV_Q(ntryL,G1H8(50),wf4(:,2),G1H2(28),m3h4x2(:,39),heltab2x8(:,:,87))
  call Hloop_A_Q(ntryL,G1H2(28),95,0,G2H2(1),n2h2(33))
  call Hloop_AV_Q(ntryL,G1H8(51),wf4(:,2),G1H2(39),m3h4x2(:,40),heltab2x8(:,:,88))
  call Hloop_A_Q(ntryL,G1H2(39),95,0,G2H2(3),n2h2(34))
  call Hloop_AZ_Q(ntryL,G1H8(61),wf4(:,7),G1H2(50),ngZd,m3h4x2(:,41),heltab2x8(:,:,89))
  call Hloop_A_Q(ntryL,G1H2(50),95,0,G2H2(4),n2h2(35))
  call Hloop_AZ_Q(ntryL,G1H8(62),wf4(:,7),G1H2(61),ngZd,m3h4x2(:,42),heltab2x8(:,:,90))
  call Hloop_A_Q(ntryL,G1H2(61),95,0,G2H2(6),n2h2(36))
  call Hloop_AZ_Q(ntryL,G1H8(66),wf4(:,7),G1H2(72),ngZd,m3h4x2(:,43),heltab2x8(:,:,91))
  call Hloop_A_Q(ntryL,G1H2(72),95,0,G2H2(7),n2h2(37))
  call Hloop_AZ_Q(ntryL,G1H8(67),wf4(:,7),G1H2(83),ngZd,m3h4x2(:,44),heltab2x8(:,:,92))
  call Hloop_A_Q(ntryL,G1H2(83),95,0,G2H2(9),n2h2(38))
  call Hloop_AW_Q(ntryL,G1H8(77),wf4(:,4),G1H2(1),m3h4x2(:,45),heltab2x8(:,:,93))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(10),n2h2(39))
  call Hloop_AW_Q(ntryL,G1H8(78),wf4(:,4),G1H2(2),m3h4x2(:,46),heltab2x8(:,:,94))
  call Hloop_A_Q(ntryL,G1H2(2),95,0,G2H2(12),n2h2(40))
  call Hloop_AW_Q(ntryL,G1H8(82),wf4(:,4),G1H2(7),m3h4x2(:,47),heltab2x8(:,:,95))
  call Hloop_A_Q(ntryL,G1H2(7),95,0,G2H2(13),n2h2(41))
  call Hloop_AW_Q(ntryL,G1H8(83),wf4(:,4),G1H2(8),m3h4x2(:,48),heltab2x8(:,:,96))
  call Hloop_A_Q(ntryL,G1H2(8),95,0,G2H2(15),n2h2(42))
  call Hloop_AV_Q(ntryL,G1H8(93),wf4(:,11),G1H2(12),m3h4x2(:,49),heltab2x8(:,:,97))
  call Hloop_A_Q(ntryL,G1H2(12),95,0,G2H2(16),n2h2(43))
  call Hloop_AV_Q(ntryL,G1H8(94),wf4(:,11),G1H2(13),m3h4x2(:,50),heltab2x8(:,:,98))
  call Hloop_A_Q(ntryL,G1H2(13),95,0,G2H2(18),n2h2(44))
  call Hloop_AV_Q(ntryL,G1H8(98),wf4(:,11),G1H2(18),m3h4x2(:,51),heltab2x8(:,:,99))
  call Hloop_A_Q(ntryL,G1H2(18),95,0,G2H2(19),n2h2(45))
  call Hloop_AV_Q(ntryL,G1H8(99),wf4(:,11),G1H2(19),m3h4x2(:,52),heltab2x8(:,:,100))
  call Hloop_A_Q(ntryL,G1H2(19),95,0,G2H2(21),n2h2(46))
  call Hloop_AZ_Q(ntryL,G1H8(109),wf4(:,14),G1H2(23),ngZd,m3h4x2(:,53),heltab2x8(:,:,101))
  call Hloop_A_Q(ntryL,G1H2(23),95,0,G2H2(22),n2h2(47))
  call Hloop_AZ_Q(ntryL,G1H8(110),wf4(:,14),G1H2(24),ngZd,m3h4x2(:,54),heltab2x8(:,:,102))
  call Hloop_A_Q(ntryL,G1H2(24),95,0,G2H2(24),n2h2(48))
  call Hloop_AZ_Q(ntryL,G1H8(114),wf4(:,14),G1H2(29),ngZd,m3h4x2(:,55),heltab2x8(:,:,103))
  call Hloop_A_Q(ntryL,G1H2(29),95,0,G2H2(36),n2h2(49))
  call Hloop_AZ_Q(ntryL,G1H8(115),wf4(:,14),G1H2(30),ngZd,m3h4x2(:,56),heltab2x8(:,:,104))
  call Hloop_A_Q(ntryL,G1H2(30),95,0,G2H2(38),n2h2(50))
  call Hloop_AW_Q(ntryL,G1H8(125),wf4(:,12),G1H2(34),m3h4x2(:,57),heltab2x8(:,:,105))
  call Hloop_A_Q(ntryL,G1H2(34),95,0,G2H2(41),n2h2(51))
  call Hloop_AW_Q(ntryL,G1H8(126),wf4(:,12),G1H2(35),m3h4x2(:,58),heltab2x8(:,:,106))
  call Hloop_A_Q(ntryL,G1H2(35),95,0,G2H2(43),n2h2(52))
  call Hloop_AW_Q(ntryL,G1H8(130),wf4(:,12),G1H2(40),m3h4x2(:,59),heltab2x8(:,:,107))
  call Hloop_A_Q(ntryL,G1H2(40),95,0,G2H2(51),n2h2(53))
  call Hloop_AW_Q(ntryL,G1H8(131),wf4(:,12),G1H2(41),m3h4x2(:,60),heltab2x8(:,:,108))
  call Hloop_A_Q(ntryL,G1H2(41),95,0,G2H2(53),n2h2(54))
  call Hloop_AQ_V(ntryL,G2H4(13),ex6(:),G2H2(56),m3h2x2(:,27),heltab2x4(:,:,51))
  call Hloop_AQ_V(ntryL,G2H4(16),ex6(:),G2H2(58),m3h2x2(:,28),heltab2x4(:,:,52))
  call Hloop_QA_V(ntryL,G2H4(21),ex5(:),G2H2(61),m3h2x2(:,29),heltab2x4(:,:,53))
  call Hloop_QA_V(ntryL,G2H4(24),ex5(:),G2H2(62),m3h2x2(:,30),heltab2x4(:,:,54))
  call Hloop_AQ_V(ntryL,G2H4(25),ex6(:),G2H2(63),m3h2x2(:,31),heltab2x4(:,:,55))
  call Hloop_AQ_V(ntryL,G2H4(28),ex6(:),G2H2(64),m3h2x2(:,32),heltab2x4(:,:,56))
  call Hloop_QA_V(ntryL,G2H4(33),ex5(:),G2H2(65),m3h2x2(:,33),heltab2x4(:,:,57))
  call Hloop_QA_V(ntryL,G2H4(36),ex5(:),G2H2(66),m3h2x2(:,34),heltab2x4(:,:,58))
  call Hloop_QA_V(ntryL,G2H16(10),wf8(:,10),G2H2(67),m3h8x2(:,1),heltab2x16(:,:,87))
  call Hloop_AQ_V(ntryL,G2H16(12),ex6(:),G2H8(21),m3h2x8(:,19),heltab2x16(:,:,88))
call Hotf_4pt_reduction(G2H32(1),RedSet_4(3),mass4set(:,1),  & 
G1H32(44),G1H32(46),G1H32(47),G1H32(48),G1H32(3),32)
call HG1shiftOLR(G1H32(46),37,32)
call Hotf_4pt_reduction(G2H32(2),RedSet_4(3),mass4set(:,1),  & 
G1H32(9),G1H32(15),G1H32(21),G1H32(27),G1H32(33),32)
call HG1shiftOLR(G1H32(15),37,32)
  call Hloop_AQ_V(ntryL,G2H16(15),wf8(:,2),G2H2(68),m3h8x2(:,2),heltab2x16(:,:,89))
  call Hloop_QA_V(ntryL,G2H16(18),ex5(:),G2H8(23),m3h2x8(:,20),heltab2x16(:,:,90))
  call Hloop_QA_V(ntryL,G2H16(20),wf8(:,12),G2H2(69),m3h8x2(:,3),heltab2x16(:,:,91))
  call Hloop_QA_V(ntryL,G2H16(21),wf8(:,14),G2H2(70),m3h8x2(:,4),heltab2x16(:,:,92))
  call Hloop_AQ_V(ntryL,G2H16(22),ex6(:),G2H8(24),m3h2x8(:,21),heltab2x16(:,:,93))
  call Hloop_AQ_V(ntryL,G2H16(24),ex6(:),G2H8(43),m3h2x8(:,22),heltab2x16(:,:,94))
call Hotf_4pt_reduction(G2H32(3),RedSet_4(2),mass4set(:,1),  & 
G1H32(39),G1H32(45),G1H32(4),G1H32(5),G1H32(1),32)
call HG1shiftOLR(G1H32(45),42,32)
call Hotf_4pt_reduction(G2H32(4),RedSet_4(2),mass4set(:,1),  & 
G1H32(2),G1H32(13),G1H32(14),G1H32(11),G1H32(12),32)
call HG1shiftOLR(G1H32(13),42,32)
  call Hloop_AQ_V(ntryL,G2H16(1),wf8(:,4),G2H2(71),m3h8x2(:,5),heltab2x16(:,:,95))
  call Hloop_AQ_V(ntryL,G2H16(5),wf8(:,6),G2H2(72),m3h8x2(:,6),heltab2x16(:,:,96))
  call Hloop_QA_V(ntryL,G2H16(13),ex5(:),G2H8(45),m3h2x8(:,23),heltab2x16(:,:,97))
  call Hloop_QA_V(ntryL,G2H16(17),ex5(:),G2H8(46),m3h2x8(:,24),heltab2x16(:,:,98))
call Hotf_4pt_reduction(G2H32(5),RedSet_4(1),mass4set(:,1),  & 
G1H32(6),G1H32(7),G1H32(8),G1H32(10),G1H32(20),32)
call HG1shiftOLR(G1H32(7),32,32)
call Hotf_4pt_reduction(G2H32(6),RedSet_4(1),mass4set(:,1),  & 
G1H32(22),G1H32(23),G1H32(24),G1H32(25),G1H32(26),32)
call HG1shiftOLR(G1H32(23),32,32)
call Hotf_4pt_reduction(G2H32(7),RedSet_4(1),mass4set(:,1),  & 
G1H32(28),G1H32(16),G1H32(17),G1H32(18),G1H32(19),32)
call HG1shiftOLR(G1H32(16),32,32)
  call Hloop_QA_V(ntryL,G2H16(23),wf8(:,26),G2H2(73),m3h8x2(:,7),heltab2x16(:,:,99))
  call Hloop_AQ_V(ntryL,G2H16(3),ex6(:),G2H8(3),m3h2x8(:,25),heltab2x16(:,:,100))
call Hotf_4pt_reduction(G2H32(8),RedSet_4(5),mass4set(:,1),  & 
G1H32(29),G1H32(30),G1H32(31),G1H32(32),G1H32(34),32)
call HG1shiftOLR(G1H32(30),41,32)
call Hotf_4pt_reduction(G2H32(9),RedSet_4(5),mass4set(:,1),  & 
G1H32(35),G1H32(36),G1H32(37),G1H32(38),G1H32(40),32)
call HG1shiftOLR(G1H32(36),41,32)
  call Hloop_AQ_V(ntryL,G2H16(6),wf8(:,20),G2H2(74),m3h8x2(:,8),heltab2x16(:,:,101))
  call Hloop_QA_V(ntryL,G2H16(8),ex5(:),G2H8(4),m3h2x8(:,26),heltab2x16(:,:,102))
  call Hloop_QA_V(ntryL,G2H16(25),wf8(:,28),G2H2(75),m3h8x2(:,9),heltab2x16(:,:,103))
  call Hloop_QA_V(ntryL,G2H16(26),wf8(:,30),G2H2(76),m3h8x2(:,10),heltab2x16(:,:,104))
  call Hloop_AQ_V(ntryL,G2H16(27),ex6(:),G2H8(1),m3h2x8(:,27),heltab2x16(:,:,105))
  call Hloop_AQ_V(ntryL,G2H16(28),ex6(:),G2H8(2),m3h2x8(:,28),heltab2x16(:,:,106))
call Hotf_4pt_reduction(G2H32(10),RedSet_4(4),mass4set(:,1),  & 
G1H32(41),G1H32(42),G1H32(43),G1H32(49),G1H32(50),32)
call HG1shiftOLR(G1H32(42),38,32)
call Hotf_4pt_reduction(G2H32(11),RedSet_4(4),mass4set(:,1),  & 
G1H32(51),G1H32(52),G1H32(53),G1H32(54),G1H32(55),32)
call HG1shiftOLR(G1H32(52),38,32)
  call Hloop_AQ_V(ntryL,G2H16(29),wf8(:,22),G2H2(77),m3h8x2(:,11),heltab2x16(:,:,107))
  call Hloop_AQ_V(ntryL,G2H16(30),wf8(:,24),G2H2(78),m3h8x2(:,12),heltab2x16(:,:,108))
  call Hloop_QA_V(ntryL,G2H16(31),ex5(:),G2H8(16),m3h2x8(:,29),heltab2x16(:,:,109))
  call Hloop_QA_V(ntryL,G2H16(32),ex5(:),G2H8(17),m3h2x8(:,30),heltab2x16(:,:,110))
call Hotf_4pt_reduction(G2H32(12),RedSet_4(1),mass4set(:,1),  & 
G1H32(56),G1H32(57),G1H32(58),G1H32(59),G1H32(60),32)
call HG1shiftOLR(G1H32(57),32,32)
call Hotf_4pt_reduction(G2H32(13),RedSet_4(1),mass4set(:,1),  & 
G1H32(61),G1H32(62),G1H32(63),G1H32(64),G1H32(65),32)
call HG1shiftOLR(G1H32(62),32,32)
call Hotf_4pt_reduction(G2H32(14),RedSet_4(1),mass4set(:,1),  & 
G1H32(66),G1H32(67),G1H32(68),G1H32(69),G1H32(70),32)
call HG1shiftOLR(G1H32(67),32,32)
call Hotf_4pt_reduction(G2H32(15),RedSet_4(1),mass4set(:,1),  & 
G1H32(71),G1H32(72),G1H32(73),G1H32(74),G1H32(75),32)
call HG1shiftOLR(G1H32(72),32,32)
call Hotf_4pt_reduction(G2H32(16),RedSet_4(1),mass4set(:,1),  & 
G1H32(76),G1H32(77),G1H32(78),G1H32(79),G1H32(80),32)
call HG1shiftOLR(G1H32(77),32,32)
call Hotf_4pt_reduction(G2H32(17),RedSet_4(1),mass4set(:,1),  & 
G1H32(81),G1H32(82),G1H32(83),G1H32(84),G1H32(85),32)
call HG1shiftOLR(G1H32(82),32,32)
call Hotf_4pt_reduction(G2H32(18),RedSet_4(1),mass4set(:,1),  & 
G1H32(86),G1H32(87),G1H32(88),G1H32(89),G1H32(90),32)
call HG1shiftOLR(G1H32(87),32,32)
call Hotf_4pt_reduction(G2H32(19),RedSet_4(1),mass4set(:,1),  & 
G1H32(91),G1H32(92),G1H32(93),G1H32(94),G1H32(95),32)
call HG1shiftOLR(G1H32(92),32,32)
call Hotf_4pt_reduction(G2H32(20),RedSet_4(1),mass4set(:,1),  & 
G1H32(96),G1H32(97),G1H32(98),G1H32(99),G1H32(100),32)
call HG1shiftOLR(G1H32(97),32,32)
  call Hloop_AW_Q(ntryL,G1H8(19),wf4(:,4),G1H2(45),m3h4x2(:,61),heltab2x8(:,:,109))
  call Hloop_A_Q(ntryL,G1H2(45),95,0,G2H2(79),n2h2(55))
call HGT_raise_alpha_OLR(G1H8(20),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(20),ex6(:),G1H4(74),m3h2x4(:,49),heltab2x8(:,:,110))
  call Hloop_AW_Q(ntryL,G1H8(24),wf4(:,4),G1H2(46),m3h4x2(:,62),heltab2x8(:,:,111))
  call Hloop_A_Q(ntryL,G1H2(46),95,0,G2H2(80),n2h2(56))
  call Hloop_AW_Q(ntryL,G1H8(25),wf4(:,4),G1H2(51),m3h4x2(:,63),heltab2x8(:,:,112))
  call Hloop_A_Q(ntryL,G1H2(51),95,0,G2H2(81),n2h2(57))
  call Hloop_AV_Q(ntryL,G1H8(26),wf4(:,2),G1H2(52),m3h4x2(:,64),heltab2x8(:,:,113))
  call Hloop_A_Q(ntryL,G1H2(52),95,0,G2H2(82),n2h2(58))
call HGT_raise_alpha_OLR(G1H8(29),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(29),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(29),ex6(:),G1H4(75),m3h2x4(:,50),heltab2x8(:,:,114))
  call Hloop_AV_Q(ntryL,G1H8(31),wf4(:,2),G1H2(56),m3h4x2(:,65),heltab2x8(:,:,115))
  call Hloop_A_Q(ntryL,G1H2(56),95,0,G2H2(83),n2h2(59))
  call Hloop_AV_Q(ntryL,G1H8(32),wf4(:,2),G1H2(57),m3h4x2(:,66),heltab2x8(:,:,116))
  call Hloop_A_Q(ntryL,G1H2(57),95,0,G2H2(84),n2h2(60))
  call Hloop_AZ_Q(ntryL,G1H8(35),wf4(:,7),G1H2(62),ngZd,m3h4x2(:,67),heltab2x8(:,:,117))
  call Hloop_A_Q(ntryL,G1H2(62),95,0,G2H2(85),n2h2(61))
call HGT_raise_alpha_OLR(G1H8(36),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(36),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(36),ex6(:),G1H4(80),m3h2x4(:,51),heltab2x8(:,:,118))
  call Hloop_AZ_Q(ntryL,G1H8(38),wf4(:,7),G1H2(63),ngZd,m3h4x2(:,68),heltab2x8(:,:,119))
  call Hloop_A_Q(ntryL,G1H2(63),95,0,G2H2(86),n2h2(62))
  call Hloop_AZ_Q(ntryL,G1H8(43),wf4(:,7),G1H2(67),ngZd,m3h4x2(:,69),heltab2x8(:,:,120))
  call Hloop_A_Q(ntryL,G1H2(67),95,0,G2H2(87),n2h2(63))
  call Hloop_QW_A(ntryL,G1H8(48),wf4(:,4),G1H2(68),m3h4x2(:,70),heltab2x8(:,:,121))
  call Hloop_Q_A(ntryL,G1H2(68),111,0,G2H2(88),n2h2(64))
call HGT_raise_alpha_OLR(G1H8(44),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(44),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(44),ex5(:),G1H4(81),m3h2x4(:,52),heltab2x8(:,:,122))
  call Hloop_QW_A(ntryL,G1H8(49),wf4(:,4),G1H2(73),m3h4x2(:,71),heltab2x8(:,:,123))
  call Hloop_Q_A(ntryL,G1H2(73),111,0,G2H2(89),n2h2(65))
  call Hloop_QW_A(ntryL,G1H8(52),wf4(:,4),G1H2(74),m3h4x2(:,72),heltab2x8(:,:,124))
  call Hloop_Q_A(ntryL,G1H2(74),111,0,G2H2(90),n2h2(66))
  call Hloop_QV_A(ntryL,G1H8(53),wf4(:,2),G1H2(78),m3h4x2(:,73),heltab2x8(:,:,125))
  call Hloop_Q_A(ntryL,G1H2(78),111,0,G2H2(91),n2h2(67))
call HGT_raise_alpha_OLR(G1H8(54),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(54),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(54),ex5(:),G1H4(24),m3h2x4(:,53),heltab2x8(:,:,126))
  call Hloop_QV_A(ntryL,G1H8(64),wf4(:,2),G1H2(79),m3h4x2(:,74),heltab2x8(:,:,127))
  call Hloop_Q_A(ntryL,G1H2(79),111,0,G2H2(92),n2h2(68))
  call Hloop_QV_A(ntryL,G1H8(60),wf4(:,2),G1H2(84),m3h4x2(:,75),heltab2x8(:,:,128))
  call Hloop_Q_A(ntryL,G1H2(84),111,0,G2H2(93),n2h2(69))
  call Hloop_QZ_A(ntryL,G1H8(63),wf4(:,7),G1H2(85),ngZu,m3h4x2(:,76),heltab2x8(:,:,129))
  call Hloop_Q_A(ntryL,G1H2(85),111,0,G2H2(94),n2h2(70))
call HGT_raise_alpha_OLR(G1H8(65),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(65),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(65),ex5(:),G1H4(35),m3h2x4(:,54),heltab2x8(:,:,130))
  call Hloop_QZ_A(ntryL,G1H8(69),wf4(:,7),G1H2(6),ngZu,m3h4x2(:,77),heltab2x8(:,:,131))
  call Hloop_Q_A(ntryL,G1H2(6),111,0,G2H2(95),n2h2(71))
  call Hloop_QZ_A(ntryL,G1H8(70),wf4(:,7),G1H2(17),ngZu,m3h4x2(:,78),heltab2x8(:,:,132))
  call Hloop_Q_A(ntryL,G1H2(17),111,0,G2H2(96),n2h2(72))
  call Hloop_AV_Q(ntryL,G1H8(75),wf4(:,2),G1H2(28),m3h4x2(:,79),heltab2x8(:,:,133))
  call Hloop_A_Q(ntryL,G1H2(28),95,0,G2H2(97),n2h2(73))
call HGT_raise_alpha_OLR(G1H8(80),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(80),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(80),ex6(:),G1H4(46),m3h2x4(:,55),heltab2x8(:,:,134))
  call Hloop_AV_Q(ntryL,G1H8(79),wf4(:,2),G1H2(39),m3h4x2(:,80),heltab2x8(:,:,135))
  call Hloop_A_Q(ntryL,G1H2(39),95,0,G2H2(98),n2h2(74))
  call Hloop_AV_Q(ntryL,G1H8(81),wf4(:,2),G1H2(50),m3h4x2(:,81),heltab2x8(:,:,136))
  call Hloop_A_Q(ntryL,G1H2(50),95,0,G2H2(99),n2h2(75))
  call Hloop_AZ_Q(ntryL,G1H8(84),wf4(:,7),G1H2(61),ngZd,m3h4x2(:,82),heltab2x8(:,:,137))
  call Hloop_A_Q(ntryL,G1H2(61),95,0,G2H2(100),n2h2(76))
call HGT_raise_alpha_OLR(G1H8(85),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(85),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(85),ex6(:),G1H4(57),m3h2x4(:,56),heltab2x8(:,:,138))
  call Hloop_AZ_Q(ntryL,G1H8(91),wf4(:,7),G1H2(72),ngZd,m3h4x2(:,83),heltab2x8(:,:,139))
  call Hloop_A_Q(ntryL,G1H2(72),95,0,G2H2(101),n2h2(77))
  call Hloop_AZ_Q(ntryL,G1H8(96),wf4(:,7),G1H2(83),ngZd,m3h4x2(:,84),heltab2x8(:,:,140))
  call Hloop_A_Q(ntryL,G1H2(83),95,0,G2H2(102),n2h2(78))
  call Hloop_AW_Q(ntryL,G1H8(92),wf4(:,4),G1H2(1),m3h4x2(:,85),heltab2x8(:,:,141))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(103),n2h2(79))
call HGT_raise_alpha_OLR(G1H8(95),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(95),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(95),ex6(:),G1H4(68),m3h2x4(:,57),heltab2x8(:,:,142))
  call Hloop_AW_Q(ntryL,G1H8(100),wf4(:,4),G1H2(2),m3h4x2(:,86),heltab2x8(:,:,143))
  call Hloop_A_Q(ntryL,G1H2(2),95,0,G2H2(104),n2h2(80))
  call Hloop_AW_Q(ntryL,G1H8(101),wf4(:,4),G1H2(7),m3h4x2(:,87),heltab2x8(:,:,144))
  call Hloop_A_Q(ntryL,G1H2(7),95,0,G2H2(105),n2h2(81))
  call Hloop_AW_Q(ntryL,G1H8(102),wf4(:,12),G1H2(8),m3h4x2(:,88),heltab2x8(:,:,145))
  call Hloop_A_Q(ntryL,G1H2(8),95,0,G2H2(106),n2h2(82))
call HGT_raise_alpha_OLR(G1H8(107),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(107),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(107),ex6(:),G1H4(79),m3h2x4(:,58),heltab2x8(:,:,146))
  call Hloop_AW_Q(ntryL,G1H8(108),wf4(:,12),G1H2(12),m3h4x2(:,89),heltab2x8(:,:,147))
  call Hloop_A_Q(ntryL,G1H2(12),95,0,G2H2(107),n2h2(83))
  call Hloop_AW_Q(ntryL,G1H8(111),wf4(:,12),G1H2(13),m3h4x2(:,90),heltab2x8(:,:,148))
  call Hloop_A_Q(ntryL,G1H2(13),95,0,G2H2(108),n2h2(84))
  call Hloop_AV_Q(ntryL,G1H8(113),wf4(:,11),G1H2(18),m3h4x2(:,91),heltab2x8(:,:,149))
  call Hloop_A_Q(ntryL,G1H2(18),95,0,G2H2(109),n2h2(85))
call HGT_raise_alpha_OLR(G1H8(116),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(116),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(116),ex6(:),G1H4(19),m3h2x4(:,59),heltab2x8(:,:,150))
  call Hloop_AV_Q(ntryL,G1H8(118),wf4(:,11),G1H2(19),m3h4x2(:,92),heltab2x8(:,:,151))
  call Hloop_A_Q(ntryL,G1H2(19),95,0,G2H2(110),n2h2(86))
  call Hloop_AV_Q(ntryL,G1H8(123),wf4(:,11),G1H2(23),m3h4x2(:,93),heltab2x8(:,:,152))
  call Hloop_A_Q(ntryL,G1H2(23),95,0,G2H2(111),n2h2(87))
  call Hloop_AZ_Q(ntryL,G1H8(128),wf4(:,14),G1H2(24),ngZd,m3h4x2(:,94),heltab2x8(:,:,153))
  call Hloop_A_Q(ntryL,G1H2(24),95,0,G2H2(112),n2h2(88))
call HGT_raise_alpha_OLR(G1H8(124),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(124),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(124),ex6(:),G1H4(20),m3h2x4(:,60),heltab2x8(:,:,154))
  call Hloop_AZ_Q(ntryL,G1H8(129),wf4(:,14),G1H2(29),ngZd,m3h4x2(:,95),heltab2x8(:,:,155))
  call Hloop_A_Q(ntryL,G1H2(29),95,0,G2H2(113),n2h2(89))
  call Hloop_AZ_Q(ntryL,G1H8(132),wf4(:,14),G1H2(30),ngZd,m3h4x2(:,96),heltab2x8(:,:,156))
  call Hloop_A_Q(ntryL,G1H2(30),95,0,G2H2(114),n2h2(90))
  call Hloop_QW_A(ntryL,G1H8(41),wf4(:,12),G1H2(34),m3h4x2(:,97),heltab2x8(:,:,157))
  call Hloop_Q_A(ntryL,G1H2(34),111,0,G2H2(115),n2h2(91))
call HGT_raise_alpha_OLR(G1H8(42),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(42),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(42),ex5(:),G1H4(25),m3h2x4(:,61),heltab2x8(:,:,158))
  call Hloop_QW_A(ntryL,G1H8(58),wf4(:,12),G1H2(35),m3h4x2(:,98),heltab2x8(:,:,159))
  call Hloop_Q_A(ntryL,G1H2(35),111,0,G2H2(116),n2h2(92))
  call Hloop_QW_A(ntryL,G1H8(73),wf4(:,12),G1H2(40),m3h4x2(:,99),heltab2x8(:,:,160))
  call Hloop_Q_A(ntryL,G1H2(40),111,0,G2H2(117),n2h2(93))
  call Hloop_QV_A(ntryL,G1H8(74),wf4(:,11),G1H2(41),m3h4x2(:,100),heltab2x8(:,:,161))
  call Hloop_Q_A(ntryL,G1H2(41),111,0,G2H2(118),n2h2(94))
call HGT_raise_alpha_OLR(G1H8(89),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(89),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(89),ex5(:),G1H4(26),m3h2x4(:,62),heltab2x8(:,:,162))
  call Hloop_QV_A(ntryL,G1H8(105),wf4(:,11),G1H2(45),m3h4x2(:,101),heltab2x8(:,:,163))
  call Hloop_Q_A(ntryL,G1H2(45),111,0,G2H2(119),n2h2(95))
  call Hloop_QV_A(ntryL,G1H8(106),wf4(:,11),G1H2(46),m3h4x2(:,102),heltab2x8(:,:,164))
  call Hloop_Q_A(ntryL,G1H2(46),111,0,G2H2(120),n2h2(96))
  call Hloop_QZ_A(ntryL,G1H8(121),wf4(:,14),G1H2(51),ngZu,m3h4x2(:,103),heltab2x8(:,:,165))
  call Hloop_Q_A(ntryL,G1H2(51),111,0,G2H2(121),n2h2(97))
call HGT_raise_alpha_OLR(G1H8(122),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(122),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(122),ex5(:),G1H4(30),m3h2x4(:,63),heltab2x8(:,:,166))
  call Hloop_QZ_A(ntryL,G1H8(2),wf4(:,14),G1H2(52),ngZu,m3h4x2(:,104),heltab2x8(:,:,167))
  call Hloop_Q_A(ntryL,G1H2(52),111,0,G2H2(122),n2h2(98))
  call Hloop_QZ_A(ntryL,G1H8(5),wf4(:,14),G1H2(56),ngZu,m3h4x2(:,105),heltab2x8(:,:,168))
  call Hloop_Q_A(ntryL,G1H2(56),111,0,G2H2(123),n2h2(99))
  call Hloop_AV_Q(ntryL,G1H8(6),wf4(:,11),G1H2(57),m3h4x2(:,106),heltab2x8(:,:,169))
  call Hloop_A_Q(ntryL,G1H2(57),95,0,G2H2(124),n2h2(100))
call HGT_raise_alpha_OLR(G1H8(7),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(7),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(7),ex6(:),G1H4(31),m3h2x4(:,64),heltab2x8(:,:,170))
  call Hloop_AV_Q(ntryL,G1H8(11),wf4(:,11),G1H2(62),m3h4x2(:,107),heltab2x8(:,:,171))
  call Hloop_A_Q(ntryL,G1H2(62),95,0,G2H2(125),n2h2(101))
  call Hloop_AV_Q(ntryL,G1H8(12),wf4(:,11),G1H2(63),m3h4x2(:,108),heltab2x8(:,:,172))
  call Hloop_A_Q(ntryL,G1H2(63),95,0,G2H2(126),n2h2(102))
  call Hloop_AZ_Q(ntryL,G1H8(13),wf4(:,14),G1H2(67),ngZd,m3h4x2(:,109),heltab2x8(:,:,173))
  call Hloop_A_Q(ntryL,G1H2(67),95,0,G2H2(127),n2h2(103))
call HGT_raise_alpha_OLR(G1H8(14),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(14),ex6(:),G1H4(36),m3h2x4(:,65),heltab2x8(:,:,174))
  call Hloop_AZ_Q(ntryL,G1H8(18),wf4(:,14),G1H2(68),ngZd,m3h4x2(:,110),heltab2x8(:,:,175))
  call Hloop_A_Q(ntryL,G1H2(68),95,0,G2H2(128),n2h2(104))
  call Hloop_AZ_Q(ntryL,G1H8(71),wf4(:,14),G1H2(73),ngZd,m3h4x2(:,111),heltab2x8(:,:,176))
  call Hloop_A_Q(ntryL,G1H2(73),95,0,G2H2(129),n2h2(105))
  call Hloop_AW_Q(ntryL,G1H8(39),wf4(:,12),G1H2(74),m3h4x2(:,112),heltab2x8(:,:,177))
  call Hloop_A_Q(ntryL,G1H2(74),95,0,G2H2(130),n2h2(106))
call HGT_raise_alpha_OLR(G1H8(55),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(55),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(55),ex6(:),G1H4(37),m3h2x4(:,66),heltab2x8(:,:,178))
  call Hloop_AW_Q(ntryL,G1H8(56),wf4(:,12),G1H2(78),m3h4x2(:,113),heltab2x8(:,:,179))
  call Hloop_A_Q(ntryL,G1H2(78),95,0,G2H2(131),n2h2(107))
  call Hloop_AW_Q(ntryL,G1H8(72),wf4(:,12),G1H2(79),m3h4x2(:,114),heltab2x8(:,:,180))
  call Hloop_A_Q(ntryL,G1H2(79),95,0,G2H2(132),n2h2(108))
  call Hloop_AV_Q(ntryL,G1H32(44),wf4(:,2),G1H8(119),m3h4x8(:,49),heltab2x32(:,:,57))
  call Hloop_A_Q(ntryL,G1H8(119),90,0,G2H8(19),n2h8(99))
call HGT_raise_alpha_OLR(G1H32(46),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(46),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(46),wf8(:,2),G1H4(41),m3h8x4(:,1),heltab2x32(:,:,58))
  call Hloop_AV_Q(ntryL,G1H32(48),wf4(:,2),G1H8(87),m3h4x8(:,50),heltab2x32(:,:,59))
  call Hloop_A_Q(ntryL,G1H8(87),90,0,G2H8(20),n2h8(100))
  call Hloop_AV_Q(ntryL,G1H32(3),wf4(:,2),G1H8(103),m3h4x8(:,51),heltab2x32(:,:,60))
  call Hloop_A_Q(ntryL,G1H8(103),90,0,G2H8(14),n2h8(101))
  call Hloop_AZ_Q(ntryL,G1H32(9),wf4(:,7),G1H8(88),ngZu,m3h4x8(:,52),heltab2x32(:,:,61))
  call Hloop_A_Q(ntryL,G1H8(88),90,0,G2H8(18),n2h8(102))
call HGT_raise_alpha_OLR(G1H32(15),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(15),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(15),wf8(:,2),G1H4(42),m3h8x4(:,2),heltab2x32(:,:,62))
  call Hloop_AZ_Q(ntryL,G1H32(27),wf4(:,7),G1H8(104),ngZu,m3h4x8(:,53),heltab2x32(:,:,63))
  call Hloop_A_Q(ntryL,G1H8(104),90,0,G2H8(28),n2h8(103))
  call Hloop_AZ_Q(ntryL,G1H32(33),wf4(:,7),G1H8(120),ngZu,m3h4x8(:,54),heltab2x32(:,:,64))
  call Hloop_A_Q(ntryL,G1H8(120),90,0,G2H8(26),n2h8(104))
  call Hloop_AW_Q(ntryL,G1H32(39),wf4(:,4),G1H8(3),m3h4x8(:,55),heltab2x32(:,:,65))
  call Hloop_A_Q(ntryL,G1H8(3),85,0,G2H8(22),n2h8(105))
call HGT_raise_alpha_OLR(G1H32(45),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(45),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(45),wf8(:,4),G1H4(47),m3h8x4(:,3),heltab2x32(:,:,66))
  call Hloop_AW_Q(ntryL,G1H32(5),wf4(:,4),G1H8(4),m3h4x8(:,56),heltab2x32(:,:,67))
  call Hloop_A_Q(ntryL,G1H8(4),85,0,G2H8(13),n2h8(106))
  call Hloop_AW_Q(ntryL,G1H32(1),wf4(:,4),G1H8(9),m3h4x8(:,57),heltab2x32(:,:,68))
  call Hloop_A_Q(ntryL,G1H8(9),85,0,G2H8(15),n2h8(107))
  call Hloop_AW_Q(ntryL,G1H32(2),wf4(:,4),G1H8(10),m3h4x8(:,58),heltab2x32(:,:,69))
  call Hloop_A_Q(ntryL,G1H8(10),85,0,G2H8(5),n2h8(108))
call HGT_raise_alpha_OLR(G1H32(13),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(13),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(13),wf8(:,6),G1H4(48),m3h8x4(:,4),heltab2x32(:,:,70))
  call Hloop_AW_Q(ntryL,G1H32(11),wf4(:,4),G1H8(15),m3h4x8(:,59),heltab2x32(:,:,71))
  call Hloop_A_Q(ntryL,G1H8(15),85,0,G2H8(6),n2h8(109))
  call Hloop_AW_Q(ntryL,G1H32(12),wf4(:,4),G1H8(16),m3h4x8(:,60),heltab2x32(:,:,72))
  call Hloop_A_Q(ntryL,G1H8(16),85,0,G2H8(37),n2h8(110))
  call Hloop_AW_Q(ntryL,G1H32(6),wf16(:,42),G1H2(84),m3h16x2(:,1),heltab2x32(:,:,73))
  call Hloop_A_Q(ntryL,G1H2(84),95,0,G2H2(133),n2h2(109))
call HGT_raise_alpha_OLR(G1H32(7),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(7),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(7),ex6(:),G1H16(49),m3h2x16(:,9),heltab2x32(:,:,74))
  call Hloop_AW_Q(ntryL,G1H32(10),wf16(:,42),G1H2(85),m3h16x2(:,2),heltab2x32(:,:,75))
  call Hloop_A_Q(ntryL,G1H2(85),95,0,G2H2(134),n2h2(110))
  call Hloop_AW_Q(ntryL,G1H32(20),wf16(:,42),G1H2(6),m3h16x2(:,3),heltab2x32(:,:,76))
  call Hloop_A_Q(ntryL,G1H2(6),95,0,G2H2(135),n2h2(111))
  call Hloop_AW_Q(ntryL,G1H32(22),wf16(:,43),G1H2(17),m3h16x2(:,4),heltab2x32(:,:,77))
  call Hloop_A_Q(ntryL,G1H2(17),95,0,G2H2(136),n2h2(112))
call HGT_raise_alpha_OLR(G1H32(23),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(23),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(23),ex6(:),G1H16(50),m3h2x16(:,10),heltab2x32(:,:,78))
  call Hloop_AW_Q(ntryL,G1H32(25),wf16(:,43),G1H2(28),m3h16x2(:,5),heltab2x32(:,:,79))
  call Hloop_A_Q(ntryL,G1H2(28),95,0,G2H2(137),n2h2(113))
  call Hloop_AW_Q(ntryL,G1H32(26),wf16(:,43),G1H2(39),m3h16x2(:,6),heltab2x32(:,:,80))
  call Hloop_A_Q(ntryL,G1H2(39),95,0,G2H2(138),n2h2(114))
  call Hloop_AW_Q(ntryL,G1H32(28),wf16(:,102),G1H2(50),m3h16x2(:,7),heltab2x32(:,:,81))
  call Hloop_A_Q(ntryL,G1H2(50),95,0,G2H2(139),n2h2(115))
call HGT_raise_alpha_OLR(G1H32(16),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(16),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(16),ex6(:),G1H16(52),m3h2x16(:,11),heltab2x32(:,:,82))
  call Hloop_AW_Q(ntryL,G1H32(18),wf16(:,102),G1H2(61),m3h16x2(:,8),heltab2x32(:,:,83))
  call Hloop_A_Q(ntryL,G1H2(61),95,0,G2H2(140),n2h2(116))
  call Hloop_AW_Q(ntryL,G1H32(19),wf16(:,102),G1H2(72),m3h16x2(:,9),heltab2x32(:,:,84))
  call Hloop_A_Q(ntryL,G1H2(72),95,0,G2H2(141),n2h2(117))
  call Hloop_AV_Q(ntryL,G1H32(29),wf4(:,11),G1H8(21),m3h4x8(:,61),heltab2x32(:,:,85))
  call Hloop_A_Q(ntryL,G1H8(21),86,0,G2H8(38),n2h8(111))
call HGT_raise_alpha_OLR(G1H32(30),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(30),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(30),wf8(:,20),G1H4(52),m3h8x4(:,5),heltab2x32(:,:,86))
  call Hloop_AV_Q(ntryL,G1H32(32),wf4(:,11),G1H8(22),m3h4x8(:,62),heltab2x32(:,:,87))
  call Hloop_A_Q(ntryL,G1H8(22),86,0,G2H8(39),n2h8(112))
  call Hloop_AV_Q(ntryL,G1H32(34),wf4(:,11),G1H8(27),m3h4x8(:,63),heltab2x32(:,:,88))
  call Hloop_A_Q(ntryL,G1H8(27),86,0,G2H8(41),n2h8(113))
  call Hloop_AZ_Q(ntryL,G1H32(35),wf4(:,14),G1H8(28),ngZu,m3h4x8(:,64),heltab2x32(:,:,89))
  call Hloop_A_Q(ntryL,G1H8(28),86,0,G2H8(36),n2h8(114))
call HGT_raise_alpha_OLR(G1H32(36),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(36),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(36),wf8(:,20),G1H4(53),m3h8x4(:,6),heltab2x32(:,:,90))
  call Hloop_AZ_Q(ntryL,G1H32(38),wf4(:,14),G1H8(33),ngZu,m3h4x8(:,65),heltab2x32(:,:,91))
  call Hloop_A_Q(ntryL,G1H8(33),86,0,G2H8(40),n2h8(115))
  call Hloop_AZ_Q(ntryL,G1H32(40),wf4(:,14),G1H8(34),ngZu,m3h4x8(:,66),heltab2x32(:,:,92))
  call Hloop_A_Q(ntryL,G1H8(34),86,0,G2H8(49),n2h8(116))
  call Hloop_AW_Q(ntryL,G1H32(41),wf4(:,12),G1H8(45),m3h4x8(:,67),heltab2x32(:,:,93))
  call Hloop_A_Q(ntryL,G1H8(45),89,0,G2H8(48),n2h8(117))
call HGT_raise_alpha_OLR(G1H32(42),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(42),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(42),wf8(:,22),G1H4(58),m3h8x4(:,7),heltab2x32(:,:,94))
  call Hloop_AW_Q(ntryL,G1H32(49),wf4(:,12),G1H8(46),m3h4x8(:,68),heltab2x32(:,:,95))
  call Hloop_A_Q(ntryL,G1H8(46),89,0,G2H8(44),n2h8(118))
  call Hloop_AW_Q(ntryL,G1H32(50),wf4(:,12),G1H8(50),m3h4x8(:,69),heltab2x32(:,:,96))
  call Hloop_A_Q(ntryL,G1H8(50),89,0,G2H8(7),n2h8(119))
  call Hloop_AW_Q(ntryL,G1H32(51),wf4(:,12),G1H8(51),m3h4x8(:,70),heltab2x32(:,:,97))
  call Hloop_A_Q(ntryL,G1H8(51),89,0,G2H8(8),n2h8(120))
call HGT_raise_alpha_OLR(G1H32(52),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(52),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(52),wf8(:,24),G1H4(59),m3h8x4(:,8),heltab2x32(:,:,98))
  call Hloop_AW_Q(ntryL,G1H32(54),wf4(:,12),G1H8(61),m3h4x8(:,71),heltab2x32(:,:,99))
  call Hloop_A_Q(ntryL,G1H8(61),89,0,G2H8(9),n2h8(121))
  call Hloop_AW_Q(ntryL,G1H32(55),wf4(:,12),G1H8(62),m3h4x8(:,72),heltab2x32(:,:,100))
  call Hloop_A_Q(ntryL,G1H8(62),89,0,G2H8(10),n2h8(122))
  call Hloop_AW_Q(ntryL,G1H32(56),wf16(:,70),G1H2(83),m3h16x2(:,10),heltab2x32(:,:,101))
  call Hloop_A_Q(ntryL,G1H2(83),95,0,G2H2(142),n2h2(118))
call HGT_raise_alpha_OLR(G1H32(57),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(57),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(57),ex6(:),G1H16(53),m3h2x16(:,12),heltab2x32(:,:,102))
  call Hloop_AW_Q(ntryL,G1H32(59),wf16(:,70),G1H2(1),m3h16x2(:,11),heltab2x32(:,:,103))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(143),n2h2(119))
  call Hloop_AW_Q(ntryL,G1H32(60),wf16(:,70),G1H2(2),m3h16x2(:,12),heltab2x32(:,:,104))
  call Hloop_A_Q(ntryL,G1H2(2),95,0,G2H2(144),n2h2(120))
  call Hloop_AW_Q(ntryL,G1H32(61),wf16(:,71),G1H2(7),m3h16x2(:,13),heltab2x32(:,:,105))
  call Hloop_A_Q(ntryL,G1H2(7),95,0,G2H2(145),n2h2(121))
call HGT_raise_alpha_OLR(G1H32(62),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(62),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(62),ex6(:),G1H16(54),m3h2x16(:,13),heltab2x32(:,:,106))
  call Hloop_AW_Q(ntryL,G1H32(64),wf16(:,71),G1H2(8),m3h16x2(:,14),heltab2x32(:,:,107))
  call Hloop_A_Q(ntryL,G1H2(8),95,0,G2H2(146),n2h2(122))
  call Hloop_AW_Q(ntryL,G1H32(65),wf16(:,71),G1H2(12),m3h16x2(:,15),heltab2x32(:,:,108))
  call Hloop_A_Q(ntryL,G1H2(12),95,0,G2H2(147),n2h2(123))
  call Hloop_AW_Q(ntryL,G1H32(66),wf16(:,118),G1H2(13),m3h16x2(:,16),heltab2x32(:,:,109))
  call Hloop_A_Q(ntryL,G1H2(13),95,0,G2H2(148),n2h2(124))
call HGT_raise_alpha_OLR(G1H32(67),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(67),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(67),ex6(:),G1H16(55),m3h2x16(:,14),heltab2x32(:,:,110))
  call Hloop_AW_Q(ntryL,G1H32(69),wf16(:,118),G1H2(18),m3h16x2(:,17),heltab2x32(:,:,111))
  call Hloop_A_Q(ntryL,G1H2(18),95,0,G2H2(149),n2h2(125))
  call Hloop_AW_Q(ntryL,G1H32(70),wf16(:,118),G1H2(19),m3h16x2(:,18),heltab2x32(:,:,112))
  call Hloop_A_Q(ntryL,G1H2(19),95,0,G2H2(150),n2h2(126))
  call Hloop_AW_Q(ntryL,G1H32(71),wf16(:,119),G1H2(23),m3h16x2(:,19),heltab2x32(:,:,113))
  call Hloop_A_Q(ntryL,G1H2(23),95,0,G2H2(151),n2h2(127))
call HGT_raise_alpha_OLR(G1H32(72),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(72),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(72),ex6(:),G1H16(56),m3h2x16(:,15),heltab2x32(:,:,114))
  call Hloop_AW_Q(ntryL,G1H32(74),wf16(:,119),G1H2(24),m3h16x2(:,20),heltab2x32(:,:,115))
  call Hloop_A_Q(ntryL,G1H2(24),95,0,G2H2(152),n2h2(128))
  call Hloop_AW_Q(ntryL,G1H32(75),wf16(:,119),G1H2(29),m3h16x2(:,21),heltab2x32(:,:,116))
  call Hloop_A_Q(ntryL,G1H2(29),95,0,G2H2(153),n2h2(129))
  call Hloop_AW_Q(ntryL,G1H32(76),wf16(:,120),G1H2(30),m3h16x2(:,22),heltab2x32(:,:,117))



end subroutine vamp_1

end module ol_vamp_1_ppllllj_neeexexuxdg_1_/**/REALKIND
