
module ol_colourmatrix_ppllllj_eeexexbbxg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(30,1), K2(1,1), KL(1,1)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [  12]
  K1( 2,:) = [   0]
  K1( 3,:) = [   0]
  K1( 4,:) = [   0]
  K1( 5,:) = [   0]
  K1( 6,:) = [   0]
  K1( 7,:) = [   0]
  K1( 8,:) = [   0]
  K1( 9,:) = [   0]
  K1(10,:) = [   0]
  K1(11,:) = [   0]
  K1(12,:) = [   0]
  K1(13,:) = [   0]
  K1(14,:) = [   0]
  K1(15,:) = [   0]
  K1(16,:) = [  16]
  K1(17,:) = [   0]
  K1(18,:) = [   0]
  K1(19,:) = [   0]
  K1(20,:) = [   0]
  K1(21,:) = [   2]
  K1(22,:) = [  16]
  K1(23,:) = [   0]
  K1(24,:) = [   0]
  K1(25,:) = [   0]
  K1(26,:) = [   0]
  K1(27,:) = [ -18]
  K1(28,:) = [ -18]
  K1(29,:) = [  36]
  K1(30,:) = [   0]
  K1 = (1._/**/REALKIND / 3) * K1

  K2(1,:) = [ 4]

  KL(1,:) = [ 4]

  end subroutine colourmatrix_init
end module ol_colourmatrix_ppllllj_eeexexbbxg_1_/**/REALKIND



module ol_forced_parameters_ppllllj_eeexexbbxg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (YE /= 0) write(*,101) 'YE = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (YU /= 0) write(*,101) 'YU = 0'
  if (YD /= 0) write(*,101) 'YD = 0'
  if (YS /= 0) write(*,101) 'YS = 0'
  if (YC /= 0) write(*,101) 'YC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppllllj_eeexexbbxg_1_/**/REALKIND
! **********************************************************************
module ol_loop_storage_ppllllj_eeexexbbxg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2  
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  
#ifdef PRECISION_dp
  integer(intkind1), save :: ntry = 1, ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types 
  ! the following are flags for memory allocation of the hol coefficients in dp or qp 
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer(intkind2), parameter :: nheltot = 128 ! number of helicity configurations
  integer(intkind2), save :: nhel = 128 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(128) ! physical helicity states
#endif

  complex(REALKIND), save :: den(1020)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2), ex7(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,25), wf8(8,149), wf16(16,194), wf32(32,208), wf128(128,604)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(42), c(23)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(1,128)

end module ol_loop_storage_ppllllj_eeexexbbxg_1_/**/REALKIND






! **********************************************************************
module ol_loop_ppllllj_eeexexbbxg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2  
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppllllj_eeexexbbxg_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (CI*eQED**4*gQCD)/9._/**/REALKIND
    f( 2) = (CI*eQED**4*gQCD)/3._/**/REALKIND
    f( 3) = CI*eQED**4*gQCD
    f( 4) = (CI*countertermnorm*eQED**4*gQCD**3)/9._/**/REALKIND
    f( 5) = (CI*countertermnorm*eQED**4*gQCD**3)/3._/**/REALKIND
    f( 6) = CI*countertermnorm*eQED**4*gQCD**3
    f( 7) = CI*countertermnorm*ctAAGG*eQED**4*gQCD**3
    f( 8) = CI*countertermnorm*ctAZGG*eQED**4*gQCD**3
    f( 9) = (CI*countertermnorm*ctGbb*eQED**4*gQCD**3)/9._/**/REALKIND
    f(10) = (CI*countertermnorm*ctGbb*eQED**4*gQCD**3)/3._/**/REALKIND
    f(11) = CI*countertermnorm*ctGbb*eQED**4*gQCD**3
    f(12) = (CI*countertermnorm*ctVbb*eQED**4*gQCD**3)/9._/**/REALKIND
    f(13) = (CI*countertermnorm*ctVbb*eQED**4*gQCD**3)/3._/**/REALKIND
    f(14) = CI*countertermnorm*ctVbb*eQED**4*gQCD**3
    f(15) = (countertermnorm*ctZGG*eQED**4*gQCD**3)/3._/**/REALKIND
    f(16) = countertermnorm*ctZGG*eQED**4*gQCD**3
    f(17) = CI*countertermnorm*ctZZGG*eQED**4*gQCD**3
    f(18) = (CI*eQED**4*gQCD**3*integralnorm*SwB)/9._/**/REALKIND
    f(19) = (CI*eQED**4*gQCD**3*integralnorm*SwB)/3._/**/REALKIND
    f(20) = CI*eQED**4*gQCD**3*integralnorm*SwB
    f(21) = (eQED**4*gQCD**3*integralnorm*SwB)/9._/**/REALKIND
    f(22) = (eQED**4*gQCD**3*integralnorm*SwB)/3._/**/REALKIND
    f(23) = eQED**4*gQCD**3*integralnorm*SwB
    f(24) = (eQED**4*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(25) = (2*eQED**4*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(26) = (eQED**4*gQCD**3*integralnorm*SwF)/3._/**/REALKIND
    f(27) = (4*eQED**4*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(28) = (2*eQED**4*gQCD**3*integralnorm*SwF)/3._/**/REALKIND
    f(29) = (8*eQED**4*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(30) = eQED**4*gQCD**3*integralnorm*SwF
    f(31) = (4*eQED**4*gQCD**3*integralnorm*SwF)/3._/**/REALKIND
    f(32) = 2*eQED**4*gQCD**3*integralnorm*SwF
    f(33) = (CI*eQED**4*gQCD*lambdaHZZ*YB)/(2._/**/REALKIND*cw**2*sw**2)
    f(34) = (CI*countertermnorm*eQED**4*gQCD**3*lambdaHZZ*YB)/(2._/**/REALKIND*cw**2*sw**2)
    f(35) = (CI*countertermnorm*ctGbb*eQED**4*gQCD**3*lambdaHZZ*YB)/(2._/**/REALKIND*cw**2*sw**2)
    f(36) = (CI*countertermnorm*ctSbb*eQED**4*gQCD**3*lambdaHZZ*YB)/(2._/**/REALKIND*cw**2*sw**2)
    f(37) = (CI*countertermnorm*ctHGG*eQED**4*gQCD**3*lambdaHZZ*MB*MW*YB)/(cw**2*MQ2sum*sw)
    f(38) = (CI*eQED**4*gQCD**3*integralnorm*lambdaHZZ*SwB*YB)/(2._/**/REALKIND*cw**2*sw**2)
    f(39) = (eQED**4*gQCD**3*integralnorm*lambdaHZZ*SwB*YB)/(cw**2*sw**2*2._/**/REALKIND)
    f(40) = (eQED**4*gQCD**3*integralnorm*lambdaHZZ*SwF*YB)/(cw**2*sw**2*2._/**/REALKIND)
    f(41) = (CI*countertermnorm*ctHGG*eQED**4*gQCD**3*lambdaHZZ*MT*MW*YT)/(cw**2*MQ2sum*sw)
    f(42) = (eQED**4*gQCD**3*integralnorm*lambdaHZZ*SwF*YT)/(cw**2*sw**2*2._/**/REALKIND)

  c = [ 9*CI*f(18), 9*CI*f(19), 9*CI*f(20), f(21), 8*f(21), f(22), 8*f(22), f(23), 8*f(23), 3*f(24), 3*f(25), 3*f(26), 3*f(27) &
    , 3*f(28), 3*f(29), 3*f(30), 3*f(31), 3*f(32), 9*CI*f(38), f(39), 8*f(39), 3*f(40), 3*f(42) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,5))+L(6,5))
  den(2) = 1 /((L(5,10))+L(6,10))
  den(3) = 1 /((L(5,80) - MB2)+L(6,80))
  den(5) = 1 /((L(5,37) - MB2)+L(6,37))
  den(8) = 1 /((L(5,10) - MZ2)+L(6,10))
  den(11) = 1 /((L(5,5) - MZ2)+L(6,5))
  den(16) = 1 /((L(5,42) - MB2)+L(6,42))
  den(25) = 1 /((L(5,112) - MH2)+L(6,112))
  den(28) = 1 /((L(5,96) - MB2)+L(6,96))
  den(30) = 1 /((L(5,21) - MB2)+L(6,21))
  den(39) = 1 /((L(5,26) - MB2)+L(6,26))
  den(57) = 1 /((L(5,7))+L(6,7))
  den(59) = 1 /((L(5,112))+L(6,112))
  den(62) = 1 /((L(5,112) - MZ2)+L(6,112))
  den(68) = 1 /((L(5,13))+L(6,13))
  den(85) = 1 /((L(5,9))+L(6,9))
  den(86) = 1 /((L(5,6))+L(6,6))
  den(88) = 1 /((L(5,41) - MB2)+L(6,41))
  den(91) = 1 /((L(5,6) - MZ2)+L(6,6))
  den(94) = 1 /((L(5,9) - MZ2)+L(6,9))
  den(99) = 1 /((L(5,38) - MB2)+L(6,38))
  den(110) = 1 /((L(5,25) - MB2)+L(6,25))
  den(119) = 1 /((L(5,22) - MB2)+L(6,22))
  den(142) = 1 /((L(5,14))+L(6,14))
  den(157) = 1 /((L(5,11))+L(6,11))
  den(198) = 1 /((L(5,48))+L(6,48))
  den(213) = 1 /((L(5,15) - MH2)+L(6,15))
  den(216) = 1 /((L(5,74))+L(6,74))
  den(222) = 1 /((L(5,69))+L(6,69))
  den(229) = 1 /((L(5,85) - MB2)+L(6,85))
  den(236) = 1 /((L(5,90) - MB2)+L(6,90))
  den(244) = 1 /((L(5,101) - MB2)+L(6,101))
  den(251) = 1 /((L(5,106) - MB2)+L(6,106))
  den(265) = 1 /((L(5,70))+L(6,70))
  den(271) = 1 /((L(5,73))+L(6,73))
  den(278) = 1 /((L(5,89) - MB2)+L(6,89))
  den(285) = 1 /((L(5,86) - MB2)+L(6,86))
  den(293) = 1 /((L(5,105) - MB2)+L(6,105))
  den(300) = 1 /((L(5,102) - MB2)+L(6,102))
  den(387) = 1 /((L(5,15))+L(6,15))
  den(390) = 1 /((L(5,15) - MZ2)+L(6,15))
  den(551) = 1 /((L(5,53))+L(6,53))
  den(555) = 1 /((L(5,31) - MB2)+L(6,31))
  den(566) = 1 /((L(5,47) - MB2)+L(6,47))
  den(574) = 1 /((L(5,58))+L(6,58))
  den(613) = 1 /((L(5,57))+L(6,57))
  den(634) = 1 /((L(5,54))+L(6,54))

  ! denominators
  den(4) = den(2)*den(3)
  den(6) = den(1)*den(5)
  den(7) = den(4)*den(6)
  den(9) = den(3)*den(8)
  den(10) = den(6)*den(9)
  den(12) = den(5)*den(11)
  den(13) = den(4)*den(12)
  den(14) = den(9)*den(12)
  den(15) = den(1)*den(3)
  den(17) = den(2)*den(16)
  den(18) = den(15)*den(17)
  den(19) = den(8)*den(16)
  den(20) = den(15)*den(19)
  den(21) = den(3)*den(11)
  den(22) = den(17)*den(21)
  den(23) = den(19)*den(21)
  den(24) = den(8)*den(11)
  den(26) = den(3)*den(25)
  den(27) = den(24)*den(26)
  den(29) = den(2)*den(28)
  den(31) = den(1)*den(30)
  den(32) = den(29)*den(31)
  den(33) = den(8)*den(28)
  den(34) = den(31)*den(33)
  den(35) = den(11)*den(30)
  den(36) = den(29)*den(35)
  den(37) = den(33)*den(35)
  den(38) = den(1)*den(28)
  den(40) = den(2)*den(39)
  den(41) = den(38)*den(40)
  den(42) = den(8)*den(39)
  den(43) = den(38)*den(42)
  den(44) = den(11)*den(28)
  den(45) = den(40)*den(44)
  den(46) = den(42)*den(44)
  den(47) = den(25)*den(28)
  den(48) = den(24)*den(47)
  den(49) = den(17)*den(31)
  den(50) = den(19)*den(31)
  den(51) = den(17)*den(35)
  den(52) = den(19)*den(35)
  den(53) = den(6)*den(40)
  den(54) = den(6)*den(42)
  den(55) = den(12)*den(40)
  den(56) = den(12)*den(42)
  den(58) = den(1)*den(57)
  den(60) = den(3)*den(59)
  den(61) = den(58)*den(60)
  den(63) = den(3)*den(62)
  den(64) = den(58)*den(63)
  den(65) = den(11)*den(57)
  den(66) = den(60)*den(65)
  den(67) = den(63)*den(65)
  den(69) = den(1)*den(68)
  den(70) = den(60)*den(69)
  den(71) = den(63)*den(69)
  den(72) = den(11)*den(68)
  den(73) = den(60)*den(72)
  den(74) = den(63)*den(72)
  den(75) = den(28)*den(59)
  den(76) = den(58)*den(75)
  den(77) = den(28)*den(62)
  den(78) = den(58)*den(77)
  den(79) = den(65)*den(75)
  den(80) = den(65)*den(77)
  den(81) = den(69)*den(75)
  den(82) = den(69)*den(77)
  den(83) = den(72)*den(75)
  den(84) = den(72)*den(77)
  den(87) = den(3)*den(86)
  den(89) = den(85)*den(88)
  den(90) = den(87)*den(89)
  den(92) = den(3)*den(91)
  den(93) = den(89)*den(92)
  den(95) = den(88)*den(94)
  den(96) = den(87)*den(95)
  den(97) = den(92)*den(95)
  den(98) = den(3)*den(85)
  den(100) = den(86)*den(99)
  den(101) = den(98)*den(100)
  den(102) = den(91)*den(99)
  den(103) = den(98)*den(102)
  den(104) = den(3)*den(94)
  den(105) = den(100)*den(104)
  den(106) = den(102)*den(104)
  den(107) = den(91)*den(94)
  den(108) = den(26)*den(107)
  den(109) = den(28)*den(86)
  den(111) = den(85)*den(110)
  den(112) = den(109)*den(111)
  den(113) = den(28)*den(91)
  den(114) = den(111)*den(113)
  den(115) = den(94)*den(110)
  den(116) = den(109)*den(115)
  den(117) = den(113)*den(115)
  den(118) = den(28)*den(85)
  den(120) = den(86)*den(119)
  den(121) = den(118)*den(120)
  den(122) = den(91)*den(119)
  den(123) = den(118)*den(122)
  den(124) = den(28)*den(94)
  den(125) = den(120)*den(124)
  den(126) = den(122)*den(124)
  den(127) = den(47)*den(107)
  den(128) = den(100)*den(111)
  den(129) = den(102)*den(111)
  den(130) = den(100)*den(115)
  den(131) = den(102)*den(115)
  den(132) = den(89)*den(120)
  den(133) = den(89)*den(122)
  den(134) = den(95)*den(120)
  den(135) = den(95)*den(122)
  den(136) = den(57)*den(86)
  den(137) = den(60)*den(136)
  den(138) = den(63)*den(136)
  den(139) = den(57)*den(91)
  den(140) = den(60)*den(139)
  den(141) = den(63)*den(139)
  den(143) = den(86)*den(142)
  den(144) = den(60)*den(143)
  den(145) = den(91)*den(142)
  den(146) = den(60)*den(145)
  den(147) = den(63)*den(143)
  den(148) = den(63)*den(145)
  den(149) = den(75)*den(136)
  den(150) = den(77)*den(136)
  den(151) = den(75)*den(139)
  den(152) = den(77)*den(139)
  den(153) = den(75)*den(143)
  den(154) = den(75)*den(145)
  den(155) = den(77)*den(143)
  den(156) = den(77)*den(145)
  den(158) = den(85)*den(157)
  den(159) = den(60)*den(158)
  den(160) = den(63)*den(158)
  den(161) = den(94)*den(157)
  den(162) = den(60)*den(161)
  den(163) = den(63)*den(161)
  den(164) = den(68)*den(85)
  den(165) = den(60)*den(164)
  den(166) = den(63)*den(164)
  den(167) = den(68)*den(94)
  den(168) = den(60)*den(167)
  den(169) = den(63)*den(167)
  den(170) = den(75)*den(158)
  den(171) = den(77)*den(158)
  den(172) = den(75)*den(161)
  den(173) = den(77)*den(161)
  den(174) = den(75)*den(164)
  den(175) = den(77)*den(164)
  den(176) = den(75)*den(167)
  den(177) = den(77)*den(167)
  den(178) = den(2)*den(157)
  den(179) = den(60)*den(178)
  den(180) = den(63)*den(178)
  den(181) = den(8)*den(157)
  den(182) = den(60)*den(181)
  den(183) = den(63)*den(181)
  den(184) = den(2)*den(142)
  den(185) = den(60)*den(184)
  den(186) = den(8)*den(142)
  den(187) = den(60)*den(186)
  den(188) = den(63)*den(184)
  den(189) = den(63)*den(186)
  den(190) = den(75)*den(178)
  den(191) = den(77)*den(178)
  den(192) = den(75)*den(181)
  den(193) = den(77)*den(181)
  den(194) = den(75)*den(184)
  den(195) = den(75)*den(186)
  den(196) = den(77)*den(184)
  den(197) = den(77)*den(186)
  den(199) = den(1)*den(2)
  den(200) = den(198)*den(199)
  den(201) = den(1)*den(8)
  den(202) = den(198)*den(201)
  den(203) = den(2)*den(11)
  den(204) = den(198)*den(203)
  den(205) = den(24)*den(198)
  den(206) = den(85)*den(86)
  den(207) = den(198)*den(206)
  den(208) = den(85)*den(91)
  den(209) = den(198)*den(208)
  den(210) = den(86)*den(94)
  den(211) = den(198)*den(210)
  den(212) = den(107)*den(198)
  den(214) = den(24)*den(213)
  den(215) = den(198)*den(214)
  den(217) = den(8)*den(216)
  den(218) = den(31)*den(217)
  den(219) = den(35)*den(217)
  den(220) = den(6)*den(217)
  den(221) = den(12)*den(217)
  den(223) = den(11)*den(222)
  den(224) = den(40)*den(223)
  den(225) = den(42)*den(223)
  den(226) = den(17)*den(223)
  den(227) = den(19)*den(223)
  den(228) = den(3)*den(214)
  den(230) = den(15)*den(229)
  den(231) = den(2)*den(230)
  den(232) = den(8)*den(230)
  den(233) = den(21)*den(229)
  den(234) = den(2)*den(233)
  den(235) = den(8)*den(233)
  den(237) = den(4)*den(236)
  den(238) = den(1)*den(237)
  den(239) = den(9)*den(236)
  den(240) = den(1)*den(239)
  den(241) = den(11)*den(237)
  den(242) = den(11)*den(239)
  den(243) = den(28)*den(214)
  den(245) = den(38)*den(244)
  den(246) = den(2)*den(245)
  den(247) = den(8)*den(245)
  den(248) = den(44)*den(244)
  den(249) = den(2)*den(248)
  den(250) = den(8)*den(248)
  den(252) = den(29)*den(251)
  den(253) = den(1)*den(252)
  den(254) = den(33)*den(251)
  den(255) = den(1)*den(254)
  den(256) = den(11)*den(252)
  den(257) = den(11)*den(254)
  den(258) = den(62)*den(198)
  den(259) = den(58)*den(258)
  den(260) = den(65)*den(258)
  den(261) = den(69)*den(258)
  den(262) = den(72)*den(258)
  den(263) = den(107)*den(213)
  den(264) = den(198)*den(263)
  den(266) = den(91)*den(265)
  den(267) = den(111)*den(266)
  den(268) = den(115)*den(266)
  den(269) = den(89)*den(266)
  den(270) = den(95)*den(266)
  den(272) = den(94)*den(271)
  den(273) = den(120)*den(272)
  den(274) = den(122)*den(272)
  den(275) = den(100)*den(272)
  den(276) = den(102)*den(272)
  den(277) = den(3)*den(263)
  den(279) = den(98)*den(278)
  den(280) = den(86)*den(279)
  den(281) = den(91)*den(279)
  den(282) = den(104)*den(278)
  den(283) = den(86)*den(282)
  den(284) = den(91)*den(282)
  den(286) = den(87)*den(285)
  den(287) = den(85)*den(286)
  den(288) = den(92)*den(285)
  den(289) = den(85)*den(288)
  den(290) = den(94)*den(286)
  den(291) = den(94)*den(288)
  den(292) = den(28)*den(263)
  den(294) = den(118)*den(293)
  den(295) = den(86)*den(294)
  den(296) = den(91)*den(294)
  den(297) = den(124)*den(293)
  den(298) = den(86)*den(297)
  den(299) = den(91)*den(297)
  den(301) = den(109)*den(300)
  den(302) = den(85)*den(301)
  den(303) = den(113)*den(300)
  den(304) = den(85)*den(303)
  den(305) = den(94)*den(301)
  den(306) = den(94)*den(303)
  den(307) = den(136)*den(258)
  den(308) = den(139)*den(258)
  den(309) = den(143)*den(258)
  den(310) = den(145)*den(258)
  den(311) = den(158)*den(258)
  den(312) = den(161)*den(258)
  den(313) = den(164)*den(258)
  den(314) = den(167)*den(258)
  den(315) = den(178)*den(258)
  den(316) = den(181)*den(258)
  den(317) = den(184)*den(258)
  den(318) = den(186)*den(258)
  den(319) = den(3)**2
  den(320) = den(214)*den(319)
  den(321) = den(2)*den(319)
  den(322) = den(6)*den(321)
  den(323) = den(8)*den(319)
  den(324) = den(6)*den(323)
  den(325) = den(12)*den(321)
  den(326) = den(12)*den(323)
  den(327) = den(1)*den(319)
  den(328) = den(17)*den(327)
  den(329) = den(19)*den(327)
  den(330) = den(11)*den(319)
  den(331) = den(17)*den(330)
  den(332) = den(19)*den(330)
  den(333) = den(6)*den(237)
  den(334) = den(6)*den(239)
  den(335) = den(12)*den(237)
  den(336) = den(12)*den(239)
  den(337) = den(17)*den(230)
  den(338) = den(19)*den(230)
  den(339) = den(17)*den(233)
  den(340) = den(19)*den(233)
  den(341) = den(28)**2
  den(342) = den(214)*den(341)
  den(343) = den(31)*den(252)
  den(344) = den(31)*den(254)
  den(345) = den(35)*den(252)
  den(346) = den(35)*den(254)
  den(347) = den(40)*den(245)
  den(348) = den(42)*den(245)
  den(349) = den(40)*den(248)
  den(350) = den(42)*den(248)
  den(351) = den(2)*den(341)
  den(352) = den(31)*den(351)
  den(353) = den(8)*den(341)
  den(354) = den(31)*den(353)
  den(355) = den(35)*den(351)
  den(356) = den(35)*den(353)
  den(357) = den(1)*den(341)
  den(358) = den(40)*den(357)
  den(359) = den(42)*den(357)
  den(360) = den(11)*den(341)
  den(361) = den(40)*den(360)
  den(362) = den(42)*den(360)
  den(363) = den(17)*den(251)
  den(364) = den(31)*den(363)
  den(365) = den(19)*den(251)
  den(366) = den(31)*den(365)
  den(367) = den(35)*den(363)
  den(368) = den(35)*den(365)
  den(369) = den(6)*den(244)
  den(370) = den(40)*den(369)
  den(371) = den(42)*den(369)
  den(372) = den(12)*den(244)
  den(373) = den(40)*den(372)
  den(374) = den(42)*den(372)
  den(375) = den(31)*den(229)
  den(376) = den(17)*den(375)
  den(377) = den(19)*den(375)
  den(378) = den(35)*den(229)
  den(379) = den(17)*den(378)
  den(380) = den(19)*den(378)
  den(381) = den(40)*den(236)
  den(382) = den(6)*den(381)
  den(383) = den(42)*den(236)
  den(384) = den(6)*den(383)
  den(385) = den(12)*den(381)
  den(386) = den(12)*den(383)
  den(388) = den(58)*den(387)
  den(389) = den(319)*den(388)
  den(391) = den(58)*den(390)
  den(392) = den(319)*den(391)
  den(393) = den(65)*den(387)
  den(394) = den(319)*den(393)
  den(395) = den(65)*den(390)
  den(396) = den(319)*den(395)
  den(397) = den(69)*den(387)
  den(398) = den(319)*den(397)
  den(399) = den(69)*den(390)
  den(400) = den(319)*den(399)
  den(401) = den(72)*den(387)
  den(402) = den(319)*den(401)
  den(403) = den(72)*den(390)
  den(404) = den(319)*den(403)
  den(405) = den(341)*den(388)
  den(406) = den(341)*den(391)
  den(407) = den(341)*den(393)
  den(408) = den(341)*den(395)
  den(409) = den(341)*den(397)
  den(410) = den(341)*den(399)
  den(411) = den(341)*den(401)
  den(412) = den(341)*den(403)
  den(413) = den(263)*den(319)
  den(414) = den(86)*den(319)
  den(415) = den(89)*den(414)
  den(416) = den(91)*den(319)
  den(417) = den(89)*den(416)
  den(418) = den(95)*den(414)
  den(419) = den(95)*den(416)
  den(420) = den(85)*den(319)
  den(421) = den(100)*den(420)
  den(422) = den(102)*den(420)
  den(423) = den(94)*den(319)
  den(424) = den(100)*den(423)
  den(425) = den(102)*den(423)
  den(426) = den(89)*den(286)
  den(427) = den(89)*den(288)
  den(428) = den(95)*den(286)
  den(429) = den(95)*den(288)
  den(430) = den(100)*den(279)
  den(431) = den(102)*den(279)
  den(432) = den(100)*den(282)
  den(433) = den(102)*den(282)
  den(434) = den(263)*den(341)
  den(435) = den(111)*den(301)
  den(436) = den(111)*den(303)
  den(437) = den(115)*den(301)
  den(438) = den(115)*den(303)
  den(439) = den(120)*den(294)
  den(440) = den(122)*den(294)
  den(441) = den(120)*den(297)
  den(442) = den(122)*den(297)
  den(443) = den(86)*den(341)
  den(444) = den(111)*den(443)
  den(445) = den(91)*den(341)
  den(446) = den(111)*den(445)
  den(447) = den(115)*den(443)
  den(448) = den(115)*den(445)
  den(449) = den(85)*den(341)
  den(450) = den(120)*den(449)
  den(451) = den(122)*den(449)
  den(452) = den(94)*den(341)
  den(453) = den(120)*den(452)
  den(454) = den(122)*den(452)
  den(455) = den(100)*den(300)
  den(456) = den(111)*den(455)
  den(457) = den(102)*den(300)
  den(458) = den(111)*den(457)
  den(459) = den(115)*den(455)
  den(460) = den(115)*den(457)
  den(461) = den(89)*den(293)
  den(462) = den(120)*den(461)
  den(463) = den(122)*den(461)
  den(464) = den(95)*den(293)
  den(465) = den(120)*den(464)
  den(466) = den(122)*den(464)
  den(467) = den(111)*den(278)
  den(468) = den(100)*den(467)
  den(469) = den(102)*den(467)
  den(470) = den(115)*den(278)
  den(471) = den(100)*den(470)
  den(472) = den(102)*den(470)
  den(473) = den(120)*den(285)
  den(474) = den(89)*den(473)
  den(475) = den(122)*den(285)
  den(476) = den(89)*den(475)
  den(477) = den(95)*den(473)
  den(478) = den(95)*den(475)
  den(479) = den(136)*den(387)
  den(480) = den(319)*den(479)
  den(481) = den(136)*den(390)
  den(482) = den(319)*den(481)
  den(483) = den(139)*den(387)
  den(484) = den(319)*den(483)
  den(485) = den(139)*den(390)
  den(486) = den(319)*den(485)
  den(487) = den(143)*den(387)
  den(488) = den(319)*den(487)
  den(489) = den(145)*den(387)
  den(490) = den(319)*den(489)
  den(491) = den(143)*den(390)
  den(492) = den(319)*den(491)
  den(493) = den(145)*den(390)
  den(494) = den(319)*den(493)
  den(495) = den(341)*den(479)
  den(496) = den(341)*den(481)
  den(497) = den(341)*den(483)
  den(498) = den(341)*den(485)
  den(499) = den(341)*den(487)
  den(500) = den(341)*den(489)
  den(501) = den(341)*den(491)
  den(502) = den(341)*den(493)
  den(503) = den(158)*den(387)
  den(504) = den(319)*den(503)
  den(505) = den(158)*den(390)
  den(506) = den(319)*den(505)
  den(507) = den(161)*den(387)
  den(508) = den(319)*den(507)
  den(509) = den(161)*den(390)
  den(510) = den(319)*den(509)
  den(511) = den(164)*den(387)
  den(512) = den(319)*den(511)
  den(513) = den(164)*den(390)
  den(514) = den(319)*den(513)
  den(515) = den(167)*den(387)
  den(516) = den(319)*den(515)
  den(517) = den(167)*den(390)
  den(518) = den(319)*den(517)
  den(519) = den(341)*den(503)
  den(520) = den(341)*den(505)
  den(521) = den(341)*den(507)
  den(522) = den(341)*den(509)
  den(523) = den(341)*den(511)
  den(524) = den(341)*den(513)
  den(525) = den(341)*den(515)
  den(526) = den(341)*den(517)
  den(527) = den(178)*den(387)
  den(528) = den(319)*den(527)
  den(529) = den(178)*den(390)
  den(530) = den(319)*den(529)
  den(531) = den(181)*den(387)
  den(532) = den(319)*den(531)
  den(533) = den(181)*den(390)
  den(534) = den(319)*den(533)
  den(535) = den(184)*den(387)
  den(536) = den(319)*den(535)
  den(537) = den(186)*den(387)
  den(538) = den(319)*den(537)
  den(539) = den(184)*den(390)
  den(540) = den(319)*den(539)
  den(541) = den(186)*den(390)
  den(542) = den(319)*den(541)
  den(543) = den(341)*den(527)
  den(544) = den(341)*den(529)
  den(545) = den(341)*den(531)
  den(546) = den(341)*den(533)
  den(547) = den(341)*den(535)
  den(548) = den(341)*den(537)
  den(549) = den(341)*den(539)
  den(550) = den(341)*den(541)
  den(552) = den(31)*den(551)
  den(553) = den(35)*den(551)
  den(554) = den(2)*den(31)
  den(556) = den(554)*den(555)
  den(557) = den(8)*den(31)
  den(558) = den(555)*den(557)
  den(559) = den(2)*den(35)
  den(560) = den(555)*den(559)
  den(561) = den(8)*den(35)
  den(562) = den(555)*den(561)
  den(563) = den(6)*den(551)
  den(564) = den(12)*den(551)
  den(565) = den(2)*den(6)
  den(567) = den(565)*den(566)
  den(568) = den(6)*den(8)
  den(569) = den(566)*den(568)
  den(570) = den(2)*den(12)
  den(571) = den(566)*den(570)
  den(572) = den(8)*den(12)
  den(573) = den(566)*den(572)
  den(575) = den(40)*den(574)
  den(576) = den(42)*den(574)
  den(577) = den(1)*den(40)
  den(578) = den(555)*den(577)
  den(579) = den(1)*den(42)
  den(580) = den(555)*den(579)
  den(581) = den(11)*den(40)
  den(582) = den(555)*den(581)
  den(583) = den(11)*den(42)
  den(584) = den(555)*den(583)
  den(585) = den(17)*den(574)
  den(586) = den(19)*den(574)
  den(587) = den(1)*den(17)
  den(588) = den(566)*den(587)
  den(589) = den(1)*den(19)
  den(590) = den(566)*den(589)
  den(591) = den(11)*den(17)
  den(592) = den(566)*den(591)
  den(593) = den(11)*den(19)
  den(594) = den(566)*den(593)
  den(595) = den(214)*den(555)
  den(596) = den(214)*den(566)
  den(597) = den(388)*den(555)
  den(598) = den(391)*den(555)
  den(599) = den(393)*den(555)
  den(600) = den(395)*den(555)
  den(601) = den(388)*den(566)
  den(602) = den(391)*den(566)
  den(603) = den(393)*den(566)
  den(604) = den(395)*den(566)
  den(605) = den(397)*den(555)
  den(606) = den(399)*den(555)
  den(607) = den(401)*den(555)
  den(608) = den(403)*den(555)
  den(609) = den(397)*den(566)
  den(610) = den(399)*den(566)
  den(611) = den(401)*den(566)
  den(612) = den(403)*den(566)
  den(614) = den(111)*den(613)
  den(615) = den(115)*den(613)
  den(616) = den(86)*den(111)
  den(617) = den(555)*den(616)
  den(618) = den(91)*den(111)
  den(619) = den(555)*den(618)
  den(620) = den(86)*den(115)
  den(621) = den(555)*den(620)
  den(622) = den(91)*den(115)
  den(623) = den(555)*den(622)
  den(624) = den(89)*den(613)
  den(625) = den(95)*den(613)
  den(626) = den(86)*den(89)
  den(627) = den(566)*den(626)
  den(628) = den(89)*den(91)
  den(629) = den(566)*den(628)
  den(630) = den(86)*den(95)
  den(631) = den(566)*den(630)
  den(632) = den(91)*den(95)
  den(633) = den(566)*den(632)
  den(635) = den(120)*den(634)
  den(636) = den(122)*den(634)
  den(637) = den(85)*den(120)
  den(638) = den(555)*den(637)
  den(639) = den(85)*den(122)
  den(640) = den(555)*den(639)
  den(641) = den(94)*den(120)
  den(642) = den(555)*den(641)
  den(643) = den(94)*den(122)
  den(644) = den(555)*den(643)
  den(645) = den(100)*den(634)
  den(646) = den(102)*den(634)
  den(647) = den(85)*den(100)
  den(648) = den(566)*den(647)
  den(649) = den(85)*den(102)
  den(650) = den(566)*den(649)
  den(651) = den(94)*den(100)
  den(652) = den(566)*den(651)
  den(653) = den(94)*den(102)
  den(654) = den(566)*den(653)
  den(655) = den(263)*den(555)
  den(656) = den(263)*den(566)
  den(657) = den(479)*den(555)
  den(658) = den(481)*den(555)
  den(659) = den(483)*den(555)
  den(660) = den(485)*den(555)
  den(661) = den(479)*den(566)
  den(662) = den(481)*den(566)
  den(663) = den(483)*den(566)
  den(664) = den(485)*den(566)
  den(665) = den(487)*den(555)
  den(666) = den(489)*den(555)
  den(667) = den(491)*den(555)
  den(668) = den(493)*den(555)
  den(669) = den(487)*den(566)
  den(670) = den(489)*den(566)
  den(671) = den(491)*den(566)
  den(672) = den(493)*den(566)
  den(673) = den(503)*den(555)
  den(674) = den(505)*den(555)
  den(675) = den(507)*den(555)
  den(676) = den(509)*den(555)
  den(677) = den(503)*den(566)
  den(678) = den(505)*den(566)
  den(679) = den(507)*den(566)
  den(680) = den(509)*den(566)
  den(681) = den(511)*den(555)
  den(682) = den(513)*den(555)
  den(683) = den(515)*den(555)
  den(684) = den(517)*den(555)
  den(685) = den(511)*den(566)
  den(686) = den(513)*den(566)
  den(687) = den(515)*den(566)
  den(688) = den(517)*den(566)
  den(689) = den(527)*den(555)
  den(690) = den(529)*den(555)
  den(691) = den(531)*den(555)
  den(692) = den(533)*den(555)
  den(693) = den(527)*den(566)
  den(694) = den(529)*den(566)
  den(695) = den(531)*den(566)
  den(696) = den(533)*den(566)
  den(697) = den(535)*den(555)
  den(698) = den(537)*den(555)
  den(699) = den(539)*den(555)
  den(700) = den(541)*den(555)
  den(701) = den(535)*den(566)
  den(702) = den(537)*den(566)
  den(703) = den(539)*den(566)
  den(704) = den(541)*den(566)
  den(705) = den(1)*den(2)*den(198)
  den(706) = den(1)*den(8)*den(198)
  den(707) = den(2)*den(11)*den(198)
  den(708) = den(8)*den(11)*den(198)
  den(709) = den(2)*den(3)*den(6)
  den(710) = den(3)*den(6)*den(8)
  den(711) = den(2)*den(3)*den(12)
  den(712) = den(3)*den(8)*den(12)
  den(713) = den(1)*den(3)*den(17)
  den(714) = den(1)*den(3)*den(19)
  den(715) = den(3)*den(11)*den(17)
  den(716) = den(3)*den(11)*den(19)
  den(717) = den(1)*den(2)*den(3)
  den(718) = den(1)*den(3)*den(8)
  den(719) = den(2)*den(3)*den(11)
  den(720) = den(3)*den(8)*den(11)
  den(721) = den(2)*den(28)*den(31)
  den(722) = den(8)*den(28)*den(31)
  den(723) = den(2)*den(28)*den(35)
  den(724) = den(8)*den(28)*den(35)
  den(725) = den(1)*den(28)*den(40)
  den(726) = den(1)*den(28)*den(42)
  den(727) = den(11)*den(28)*den(40)
  den(728) = den(11)*den(28)*den(42)
  den(729) = den(1)*den(2)*den(28)
  den(730) = den(1)*den(8)*den(28)
  den(731) = den(2)*den(11)*den(28)
  den(732) = den(8)*den(11)*den(28)
  den(733) = den(2)*den(552)
  den(734) = den(8)*den(552)
  den(735) = den(2)*den(553)
  den(736) = den(8)*den(553)
  den(737) = den(2)*den(375)
  den(738) = den(8)*den(375)
  den(739) = den(2)*den(378)
  den(740) = den(8)*den(378)
  den(741) = den(2)*den(563)
  den(742) = den(8)*den(563)
  den(743) = den(2)*den(564)
  den(744) = den(8)*den(564)
  den(745) = den(2)*den(369)
  den(746) = den(8)*den(369)
  den(747) = den(2)*den(372)
  den(748) = den(8)*den(372)
  den(749) = den(1)*den(575)
  den(750) = den(1)*den(576)
  den(751) = den(11)*den(575)
  den(752) = den(11)*den(576)
  den(753) = den(1)*den(381)
  den(754) = den(1)*den(383)
  den(755) = den(11)*den(381)
  den(756) = den(11)*den(383)
  den(757) = den(1)*den(585)
  den(758) = den(1)*den(586)
  den(759) = den(11)*den(585)
  den(760) = den(11)*den(586)
  den(761) = den(1)*den(363)
  den(762) = den(1)*den(365)
  den(763) = den(11)*den(363)
  den(764) = den(11)*den(365)
  den(765) = den(198)*den(388)
  den(766) = den(198)*den(391)
  den(767) = den(198)*den(393)
  den(768) = den(198)*den(395)
  den(769) = den(198)*den(397)
  den(770) = den(198)*den(399)
  den(771) = den(198)*den(401)
  den(772) = den(198)*den(403)
  den(773) = den(3)*den(388)
  den(774) = den(3)*den(391)
  den(775) = den(3)*den(393)
  den(776) = den(3)*den(395)
  den(777) = den(3)*den(397)
  den(778) = den(3)*den(399)
  den(779) = den(3)*den(401)
  den(780) = den(3)*den(403)
  den(781) = den(28)*den(388)
  den(782) = den(28)*den(391)
  den(783) = den(28)*den(393)
  den(784) = den(28)*den(395)
  den(785) = den(28)*den(397)
  den(786) = den(28)*den(399)
  den(787) = den(28)*den(401)
  den(788) = den(28)*den(403)
  den(789) = den(85)*den(86)*den(198)
  den(790) = den(85)*den(91)*den(198)
  den(791) = den(86)*den(94)*den(198)
  den(792) = den(91)*den(94)*den(198)
  den(793) = den(3)*den(86)*den(89)
  den(794) = den(3)*den(89)*den(91)
  den(795) = den(3)*den(86)*den(95)
  den(796) = den(3)*den(91)*den(95)
  den(797) = den(3)*den(85)*den(100)
  den(798) = den(3)*den(85)*den(102)
  den(799) = den(3)*den(94)*den(100)
  den(800) = den(3)*den(94)*den(102)
  den(801) = den(3)*den(85)*den(86)
  den(802) = den(3)*den(85)*den(91)
  den(803) = den(3)*den(86)*den(94)
  den(804) = den(3)*den(91)*den(94)
  den(805) = den(28)*den(86)*den(111)
  den(806) = den(28)*den(91)*den(111)
  den(807) = den(28)*den(86)*den(115)
  den(808) = den(28)*den(91)*den(115)
  den(809) = den(28)*den(85)*den(120)
  den(810) = den(28)*den(85)*den(122)
  den(811) = den(28)*den(94)*den(120)
  den(812) = den(28)*den(94)*den(122)
  den(813) = den(28)*den(85)*den(86)
  den(814) = den(28)*den(85)*den(91)
  den(815) = den(28)*den(86)*den(94)
  den(816) = den(28)*den(91)*den(94)
  den(817) = den(86)*den(614)
  den(818) = den(91)*den(614)
  den(819) = den(86)*den(615)
  den(820) = den(91)*den(615)
  den(821) = den(86)*den(467)
  den(822) = den(91)*den(467)
  den(823) = den(86)*den(470)
  den(824) = den(91)*den(470)
  den(825) = den(86)*den(624)
  den(826) = den(91)*den(624)
  den(827) = den(86)*den(625)
  den(828) = den(91)*den(625)
  den(829) = den(86)*den(461)
  den(830) = den(91)*den(461)
  den(831) = den(86)*den(464)
  den(832) = den(91)*den(464)
  den(833) = den(85)*den(635)
  den(834) = den(85)*den(636)
  den(835) = den(94)*den(635)
  den(836) = den(94)*den(636)
  den(837) = den(85)*den(473)
  den(838) = den(85)*den(475)
  den(839) = den(94)*den(473)
  den(840) = den(94)*den(475)
  den(841) = den(85)*den(645)
  den(842) = den(85)*den(646)
  den(843) = den(94)*den(645)
  den(844) = den(94)*den(646)
  den(845) = den(85)*den(455)
  den(846) = den(85)*den(457)
  den(847) = den(94)*den(455)
  den(848) = den(94)*den(457)
  den(849) = den(198)*den(479)
  den(850) = den(198)*den(481)
  den(851) = den(198)*den(483)
  den(852) = den(198)*den(485)
  den(853) = den(198)*den(487)
  den(854) = den(198)*den(489)
  den(855) = den(198)*den(491)
  den(856) = den(198)*den(493)
  den(857) = den(3)*den(479)
  den(858) = den(3)*den(481)
  den(859) = den(3)*den(483)
  den(860) = den(3)*den(485)
  den(861) = den(3)*den(487)
  den(862) = den(3)*den(489)
  den(863) = den(3)*den(491)
  den(864) = den(3)*den(493)
  den(865) = den(28)*den(479)
  den(866) = den(28)*den(481)
  den(867) = den(28)*den(483)
  den(868) = den(28)*den(485)
  den(869) = den(28)*den(487)
  den(870) = den(28)*den(489)
  den(871) = den(28)*den(491)
  den(872) = den(28)*den(493)
  den(873) = den(198)*den(503)
  den(874) = den(198)*den(505)
  den(875) = den(198)*den(507)
  den(876) = den(198)*den(509)
  den(877) = den(198)*den(511)
  den(878) = den(198)*den(513)
  den(879) = den(198)*den(515)
  den(880) = den(198)*den(517)
  den(881) = den(3)*den(503)
  den(882) = den(3)*den(505)
  den(883) = den(3)*den(507)
  den(884) = den(3)*den(509)
  den(885) = den(3)*den(511)
  den(886) = den(3)*den(513)
  den(887) = den(3)*den(515)
  den(888) = den(3)*den(517)
  den(889) = den(28)*den(503)
  den(890) = den(28)*den(505)
  den(891) = den(28)*den(507)
  den(892) = den(28)*den(509)
  den(893) = den(28)*den(511)
  den(894) = den(28)*den(513)
  den(895) = den(28)*den(515)
  den(896) = den(28)*den(517)
  den(897) = den(198)*den(527)
  den(898) = den(198)*den(529)
  den(899) = den(198)*den(531)
  den(900) = den(198)*den(533)
  den(901) = den(198)*den(535)
  den(902) = den(198)*den(537)
  den(903) = den(198)*den(539)
  den(904) = den(198)*den(541)
  den(905) = den(3)*den(527)
  den(906) = den(3)*den(529)
  den(907) = den(3)*den(531)
  den(908) = den(3)*den(533)
  den(909) = den(3)*den(535)
  den(910) = den(3)*den(537)
  den(911) = den(3)*den(539)
  den(912) = den(3)*den(541)
  den(913) = den(28)*den(527)
  den(914) = den(28)*den(529)
  den(915) = den(28)*den(531)
  den(916) = den(28)*den(533)
  den(917) = den(28)*den(535)
  den(918) = den(28)*den(537)
  den(919) = den(28)*den(539)
  den(920) = den(28)*den(541)
  den(921) = den(3)*den(567)
  den(922) = den(3)*den(569)
  den(923) = den(3)*den(571)
  den(924) = den(3)*den(573)
  den(925) = den(3)*den(588)
  den(926) = den(3)*den(590)
  den(927) = den(3)*den(592)
  den(928) = den(3)*den(594)
  den(929) = den(3)*den(596)
  den(930) = den(28)*den(556)
  den(931) = den(28)*den(558)
  den(932) = den(28)*den(560)
  den(933) = den(28)*den(562)
  den(934) = den(28)*den(578)
  den(935) = den(28)*den(580)
  den(936) = den(28)*den(582)
  den(937) = den(28)*den(584)
  den(938) = den(28)*den(595)
  den(939) = den(3)*den(601)
  den(940) = den(3)*den(602)
  den(941) = den(3)*den(603)
  den(942) = den(3)*den(604)
  den(943) = den(3)*den(609)
  den(944) = den(3)*den(610)
  den(945) = den(3)*den(611)
  den(946) = den(3)*den(612)
  den(947) = den(28)*den(597)
  den(948) = den(28)*den(598)
  den(949) = den(28)*den(599)
  den(950) = den(28)*den(600)
  den(951) = den(28)*den(605)
  den(952) = den(28)*den(606)
  den(953) = den(28)*den(607)
  den(954) = den(28)*den(608)
  den(955) = den(3)*den(627)
  den(956) = den(3)*den(629)
  den(957) = den(3)*den(631)
  den(958) = den(3)*den(633)
  den(959) = den(3)*den(648)
  den(960) = den(3)*den(650)
  den(961) = den(3)*den(652)
  den(962) = den(3)*den(654)
  den(963) = den(3)*den(656)
  den(964) = den(28)*den(617)
  den(965) = den(28)*den(619)
  den(966) = den(28)*den(621)
  den(967) = den(28)*den(623)
  den(968) = den(28)*den(638)
  den(969) = den(28)*den(640)
  den(970) = den(28)*den(642)
  den(971) = den(28)*den(644)
  den(972) = den(28)*den(655)
  den(973) = den(3)*den(661)
  den(974) = den(3)*den(662)
  den(975) = den(3)*den(663)
  den(976) = den(3)*den(664)
  den(977) = den(3)*den(669)
  den(978) = den(3)*den(670)
  den(979) = den(3)*den(671)
  den(980) = den(3)*den(672)
  den(981) = den(28)*den(657)
  den(982) = den(28)*den(658)
  den(983) = den(28)*den(659)
  den(984) = den(28)*den(660)
  den(985) = den(28)*den(665)
  den(986) = den(28)*den(666)
  den(987) = den(28)*den(667)
  den(988) = den(28)*den(668)
  den(989) = den(3)*den(677)
  den(990) = den(3)*den(678)
  den(991) = den(3)*den(679)
  den(992) = den(3)*den(680)
  den(993) = den(3)*den(685)
  den(994) = den(3)*den(686)
  den(995) = den(3)*den(687)
  den(996) = den(3)*den(688)
  den(997) = den(28)*den(673)
  den(998) = den(28)*den(674)
  den(999) = den(28)*den(675)
  den(1000) = den(28)*den(676)
  den(1001) = den(28)*den(681)
  den(1002) = den(28)*den(682)
  den(1003) = den(28)*den(683)
  den(1004) = den(28)*den(684)
  den(1005) = den(3)*den(693)
  den(1006) = den(3)*den(694)
  den(1007) = den(3)*den(695)
  den(1008) = den(3)*den(696)
  den(1009) = den(3)*den(701)
  den(1010) = den(3)*den(702)
  den(1011) = den(3)*den(703)
  den(1012) = den(3)*den(704)
  den(1013) = den(28)*den(689)
  den(1014) = den(28)*den(690)
  den(1015) = den(28)*den(691)
  den(1016) = den(28)*den(692)
  den(1017) = den(28)*den(697)
  den(1018) = den(28)*den(698)
  den(1019) = den(28)*den(699)
  den(1020) = den(28)*den(700)

end subroutine denominators

!
!
!
!
!
! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_ppllllj_eeexexbbxg_1_/**/DREALKIND, only: ntry, nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for e- e- e+ e+ bottom anti-bottom glue -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppllllj_eeexexbbxg_1, only: external_perm_ppllllj_eeexexbbxg_1, &
    & external_perm_inv_ppllllj_eeexexbbxg_1, extcomb_perm_ppllllj_eeexexbbxg_1, &
    & average_factor_ppllllj_eeexexbbxg_1
  use ol_external_ppllllj_eeexexbbxg_1, only: H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppllllj_eeexexbbxg_1_/**/REALKIND, only: colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppllllj_eeexexbbxg_1_/**/REALKIND, only: check_forced_parameters
  use ol_heltables_OLR_ppllllj_eeexexbbxg_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: IR_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,7)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(29)
  logical, intent(in) :: qp_kinematics

  integer           :: shift, k, r, m, n
  real(REALKIND)    :: P(0:3,7)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,7)
#endif
  integer           :: extmasses2(7)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(29)
  complex(REALKIND) :: M1(1), M2(1) 
  real(REALKIND)    :: P_scatt_intern(0:3,7)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(1,128)
  type(Hpolcont) :: M1helarray_ct(1,128)

  type(Hpolcont) :: A(128,604)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(604)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call set_parameter("ew_renorm", 0)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, 0, 0, nMB, nMB, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, external_perm_inv_ppllllj_eeexexbbxg_1, 7, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_Q(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_A(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rZERO, H4, ex4, POLSEL(4),4)
  call pol_wf_Q(P(:,5), rMB, H5, ex5, POLSEL(5),5)
  call pol_wf_A(P(:,6), rMB, H6, ex6, POLSEL(6),6)
  call pol_wf_V(P(:,7), rZERO, H7, ex7, POLSEL(7),7)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1(:), ex3(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_QA_V(ntry, ex2(:), ex4(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_VQ_A(ntry, ex7(:), ex5(:), wf4(:,3), n3(:,3), t3x4(:,:,3))
  call prop_Q_A(ntry, wf4(:,3), 80, MB, 1_intkind1, wf4(:,4), n2(1))
  call vert_AV_Q(ntry, ex6(:), wf4(:,1), wf8(:,1), n3(:,4), t3x8(:,:,1))
  call vert_VQ_A(ntry, wf4(:,2), wf4(:,4), wf16(:,1), n3(:,5), t3x16(:,:,1))
  call prop_A_Q(ntry, wf8(:,1), 37, MB, 1_intkind1, wf8(:,2), n2(2))
  call vert_QA_Z(gZl,ntry, ex2(:), ex4(:), wf4(:,5), n3(:,6), t3x4(:,:,4))
  call prop_W_W(ntry, wf4(:,5), 10, MZ, 1_intkind1, wf4(:,6), n2(3))
  call vert_ZQ_A(gZd,ntry, wf4(:,6), wf4(:,4), wf16(:,2), n3(:,7), t3x16(:,:,2))
  call vert_QA_Z(gZl,ntry, ex1(:), ex3(:), wf4(:,7), n3(:,8), t3x4(:,:,5))
  call prop_W_W(ntry, wf4(:,7), 5, MZ, 1_intkind1, wf4(:,8), n2(4))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,8), wf8(:,3), n3(:,9), t3x8(:,:,2))
  call prop_A_Q(ntry, wf8(:,3), 37, MB, 1_intkind1, wf8(:,4), n2(5))
  call vert_AV_Q(ntry, ex6(:), wf4(:,2), wf8(:,5), n3(:,10), t3x8(:,:,3))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,4), wf16(:,3), n3(:,11), t3x16(:,:,3))
  call prop_A_Q(ntry, wf8(:,5), 42, MB, 1_intkind1, wf8(:,6), n2(6))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,6), wf8(:,7), n3(:,12), t3x8(:,:,4))
  call prop_A_Q(ntry, wf8(:,7), 42, MB, 1_intkind1, wf8(:,8), n2(7))
  call vert_ZQ_A(gZd,ntry, wf4(:,8), wf4(:,4), wf16(:,4), n3(:,13), t3x16(:,:,4))
  call vert_AQ_S(gH,ntry, ex6(:), wf4(:,4), wf8(:,9), n3(:,14), t3x8(:,:,5))
  call vert_VV_S(ntry, wf4(:,8), wf4(:,6), wf16(:,5), n3(:,15), t3x16(:,:,5))
  call vert_AV_Q(ntry, ex6(:), ex7(:), wf4(:,9), n3(:,16), t3x4(:,:,6))
  call prop_A_Q(ntry, wf4(:,9), 96, MB, 1_intkind1, wf4(:,10), n2(8))
  call vert_VQ_A(ntry, wf4(:,1), ex5(:), wf8(:,10), n3(:,17), t3x8(:,:,6))
  call vert_AV_Q(ntry, wf4(:,10), wf4(:,2), wf16(:,6), n3(:,18), t3x16(:,:,6))
  call prop_Q_A(ntry, wf8(:,10), 21, MB, 1_intkind1, wf8(:,11), n2(9))
  call vert_AZ_Q(gZd,ntry, wf4(:,10), wf4(:,6), wf16(:,7), n3(:,19), t3x16(:,:,7))
  call vert_ZQ_A(gZd,ntry, wf4(:,8), ex5(:), wf8(:,12), n3(:,20), t3x8(:,:,7))
  call prop_Q_A(ntry, wf8(:,12), 21, MB, 1_intkind1, wf8(:,13), n2(10))
  call vert_VQ_A(ntry, wf4(:,2), ex5(:), wf8(:,14), n3(:,21), t3x8(:,:,8))
  call vert_AV_Q(ntry, wf4(:,10), wf4(:,1), wf16(:,8), n3(:,22), t3x16(:,:,8))
  call prop_Q_A(ntry, wf8(:,14), 26, MB, 1_intkind1, wf8(:,15), n2(11))
  call vert_ZQ_A(gZd,ntry, wf4(:,6), ex5(:), wf8(:,16), n3(:,23), t3x8(:,:,9))
  call prop_Q_A(ntry, wf8(:,16), 26, MB, 1_intkind1, wf8(:,17), n2(12))
  call vert_AZ_Q(gZd,ntry, wf4(:,10), wf4(:,8), wf16(:,9), n3(:,24), t3x16(:,:,9))
  call vert_AQ_S(gH,ntry, wf4(:,10), ex5(:), wf8(:,18), n3(:,25), t3x8(:,:,10))
  call vert_VQ_A(ntry, ex7(:), wf8(:,11), wf16(:,10), n3(:,26), t3x16(:,:,10))
  call vert_VQ_A(ntry, ex7(:), wf8(:,13), wf16(:,11), n3(:,27), t3x16(:,:,11))
  call vert_VQ_A(ntry, ex7(:), wf8(:,15), wf16(:,12), n3(:,28), t3x16(:,:,12))
  call vert_VQ_A(ntry, ex7(:), wf8(:,17), wf16(:,13), n3(:,29), t3x16(:,:,13))
  call vert_VQ_A(ntry, wf4(:,1), ex2(:), wf8(:,19), n3(:,30), t3x8(:,:,11))
  call vert_QA_V(ntry, wf4(:,4), ex6(:), wf8(:,20), n3(:,31), t3x8(:,:,12))
  call prop_Q_A(ntry, wf8(:,19), 7, ZERO, 0_intkind1, wf8(:,21), n2(13))
  call vert_QA_V(ntry, wf8(:,21), ex4(:), wf16(:,14), n3(:,32), t3x16(:,:,14))
  call vert_QA_Z(gZd,ntry, wf4(:,4), ex6(:), wf8(:,22), n3(:,33), t3x8(:,:,13))
  call prop_W_W(ntry, wf8(:,22), 112, MZ, 1_intkind1, wf8(:,23), n2(14))
  call vert_QA_Z(gZl,ntry, wf8(:,21), ex4(:), wf16(:,15), n3(:,34), t3x16(:,:,15))
  call vert_ZQ_A(gZl,ntry, wf4(:,8), ex2(:), wf8(:,24), n3(:,35), t3x8(:,:,14))
  call prop_Q_A(ntry, wf8(:,24), 7, ZERO, 0_intkind1, wf8(:,25), n2(15))
  call vert_QA_V(ntry, wf8(:,25), ex4(:), wf16(:,16), n3(:,36), t3x16(:,:,16))
  call vert_QA_Z(gZl,ntry, wf8(:,25), ex4(:), wf16(:,17), n3(:,37), t3x16(:,:,17))
  call vert_AV_Q(ntry, ex4(:), wf4(:,1), wf8(:,26), n3(:,38), t3x8(:,:,15))
  call prop_A_Q(ntry, wf8(:,26), 13, ZERO, 0_intkind1, wf8(:,27), n2(16))
  call vert_QA_V(ntry, ex2(:), wf8(:,27), wf16(:,18), n3(:,39), t3x16(:,:,18))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,27), wf16(:,19), n3(:,40), t3x16(:,:,19))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,8), wf8(:,28), n3(:,41), t3x8(:,:,16))
  call prop_A_Q(ntry, wf8(:,28), 13, ZERO, 0_intkind1, wf8(:,29), n2(17))
  call vert_QA_V(ntry, ex2(:), wf8(:,29), wf16(:,20), n3(:,42), t3x16(:,:,20))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,29), wf16(:,21), n3(:,43), t3x16(:,:,21))
  call vert_QA_V(ntry, ex5(:), wf4(:,10), wf8(:,30), n3(:,44), t3x8(:,:,17))
  call vert_QA_Z(gZd,ntry, ex5(:), wf4(:,10), wf8(:,31), n3(:,45), t3x8(:,:,18))
  call prop_W_W(ntry, wf8(:,31), 112, MZ, 1_intkind1, wf8(:,32), n2(18))
  call vert_QA_V(ntry, ex1(:), ex4(:), wf4(:,11), n3(:,46), t3x4(:,:,7))
  call vert_QA_V(ntry, ex2(:), ex3(:), wf4(:,12), n3(:,47), t3x4(:,:,8))
  call vert_AV_Q(ntry, ex6(:), wf4(:,11), wf8(:,33), n3(:,48), t3x8(:,:,19))
  call vert_VQ_A(ntry, wf4(:,12), wf4(:,4), wf16(:,22), n3(:,49), t3x16(:,:,22))
  call prop_A_Q(ntry, wf8(:,33), 41, MB, 1_intkind1, wf8(:,34), n2(19))
  call vert_QA_Z(gZl,ntry, ex2(:), ex3(:), wf4(:,13), n3(:,50), t3x4(:,:,9))
  call prop_W_W(ntry, wf4(:,13), 6, MZ, 1_intkind1, wf4(:,14), n2(20))
  call vert_ZQ_A(gZd,ntry, wf4(:,14), wf4(:,4), wf16(:,23), n3(:,51), t3x16(:,:,23))
  call vert_QA_Z(gZl,ntry, ex1(:), ex4(:), wf4(:,15), n3(:,52), t3x4(:,:,10))
  call prop_W_W(ntry, wf4(:,15), 9, MZ, 1_intkind1, wf4(:,16), n2(21))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,16), wf8(:,35), n3(:,53), t3x8(:,:,20))
  call prop_A_Q(ntry, wf8(:,35), 41, MB, 1_intkind1, wf8(:,36), n2(22))
  call vert_AV_Q(ntry, ex6(:), wf4(:,12), wf8(:,37), n3(:,54), t3x8(:,:,21))
  call vert_VQ_A(ntry, wf4(:,11), wf4(:,4), wf16(:,24), n3(:,55), t3x16(:,:,24))
  call prop_A_Q(ntry, wf8(:,37), 38, MB, 1_intkind1, wf8(:,38), n2(23))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,14), wf8(:,39), n3(:,56), t3x8(:,:,22))
  call prop_A_Q(ntry, wf8(:,39), 38, MB, 1_intkind1, wf8(:,40), n2(24))
  call vert_ZQ_A(gZd,ntry, wf4(:,16), wf4(:,4), wf16(:,25), n3(:,57), t3x16(:,:,25))
  call vert_VV_S(ntry, wf4(:,14), wf4(:,16), wf16(:,26), n3(:,58), t3x16(:,:,26))
  call vert_VQ_A(ntry, wf4(:,11), ex5(:), wf8(:,41), n3(:,59), t3x8(:,:,23))
  call vert_AV_Q(ntry, wf4(:,10), wf4(:,12), wf16(:,27), n3(:,60), t3x16(:,:,27))
  call prop_Q_A(ntry, wf8(:,41), 25, MB, 1_intkind1, wf8(:,42), n2(25))
  call vert_AZ_Q(gZd,ntry, wf4(:,10), wf4(:,14), wf16(:,28), n3(:,61), t3x16(:,:,28))
  call vert_ZQ_A(gZd,ntry, wf4(:,16), ex5(:), wf8(:,43), n3(:,62), t3x8(:,:,24))
  call prop_Q_A(ntry, wf8(:,43), 25, MB, 1_intkind1, wf8(:,44), n2(26))
  call vert_VQ_A(ntry, wf4(:,12), ex5(:), wf8(:,45), n3(:,63), t3x8(:,:,25))
  call vert_AV_Q(ntry, wf4(:,10), wf4(:,11), wf16(:,29), n3(:,64), t3x16(:,:,29))
  call prop_Q_A(ntry, wf8(:,45), 22, MB, 1_intkind1, wf8(:,46), n2(27))
  call vert_ZQ_A(gZd,ntry, wf4(:,14), ex5(:), wf8(:,47), n3(:,65), t3x8(:,:,26))
  call prop_Q_A(ntry, wf8(:,47), 22, MB, 1_intkind1, wf8(:,48), n2(28))
  call vert_AZ_Q(gZd,ntry, wf4(:,10), wf4(:,16), wf16(:,30), n3(:,66), t3x16(:,:,30))
  call vert_VQ_A(ntry, ex7(:), wf8(:,42), wf16(:,31), n3(:,67), t3x16(:,:,31))
  call vert_VQ_A(ntry, ex7(:), wf8(:,44), wf16(:,32), n3(:,68), t3x16(:,:,32))
  call vert_VQ_A(ntry, ex7(:), wf8(:,46), wf16(:,33), n3(:,69), t3x16(:,:,33))
  call vert_VQ_A(ntry, ex7(:), wf8(:,48), wf16(:,34), n3(:,70), t3x16(:,:,34))
  call vert_VQ_A(ntry, wf4(:,12), ex1(:), wf8(:,49), n3(:,71), t3x8(:,:,27))
  call prop_Q_A(ntry, wf8(:,49), 7, ZERO, 0_intkind1, wf8(:,50), n2(29))
  call vert_QA_V(ntry, wf8(:,50), ex4(:), wf16(:,35), n3(:,72), t3x16(:,:,35))
  call vert_QA_Z(gZl,ntry, wf8(:,50), ex4(:), wf16(:,36), n3(:,73), t3x16(:,:,36))
  call vert_ZQ_A(gZl,ntry, wf4(:,14), ex1(:), wf8(:,51), n3(:,74), t3x8(:,:,28))
  call prop_Q_A(ntry, wf8(:,51), 7, ZERO, 0_intkind1, wf8(:,52), n2(30))
  call vert_QA_V(ntry, wf8(:,52), ex4(:), wf16(:,37), n3(:,75), t3x16(:,:,37))
  call vert_QA_Z(gZl,ntry, wf8(:,52), ex4(:), wf16(:,38), n3(:,76), t3x16(:,:,38))
  call vert_AV_Q(ntry, ex4(:), wf4(:,12), wf8(:,53), n3(:,77), t3x8(:,:,29))
  call prop_A_Q(ntry, wf8(:,53), 14, ZERO, 0_intkind1, wf8(:,54), n2(31))
  call vert_QA_V(ntry, ex1(:), wf8(:,54), wf16(:,39), n3(:,78), t3x16(:,:,39))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,14), wf8(:,55), n3(:,79), t3x8(:,:,30))
  call prop_A_Q(ntry, wf8(:,55), 14, ZERO, 0_intkind1, wf8(:,56), n2(32))
  call vert_QA_V(ntry, ex1(:), wf8(:,56), wf16(:,40), n3(:,80), t3x16(:,:,40))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,54), wf16(:,41), n3(:,81), t3x16(:,:,41))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,56), wf16(:,42), n3(:,82), t3x16(:,:,42))
  call vert_VQ_A(ntry, wf4(:,11), ex2(:), wf8(:,57), n3(:,83), t3x8(:,:,31))
  call prop_Q_A(ntry, wf8(:,57), 11, ZERO, 0_intkind1, wf8(:,58), n2(33))
  call vert_QA_V(ntry, wf8(:,58), ex3(:), wf16(:,43), n3(:,84), t3x16(:,:,43))
  call vert_QA_Z(gZl,ntry, wf8(:,58), ex3(:), wf16(:,44), n3(:,85), t3x16(:,:,44))
  call vert_ZQ_A(gZl,ntry, wf4(:,16), ex2(:), wf8(:,59), n3(:,86), t3x8(:,:,32))
  call prop_Q_A(ntry, wf8(:,59), 11, ZERO, 0_intkind1, wf8(:,60), n2(34))
  call vert_QA_V(ntry, wf8(:,60), ex3(:), wf16(:,45), n3(:,87), t3x16(:,:,45))
  call vert_QA_Z(gZl,ntry, wf8(:,60), ex3(:), wf16(:,46), n3(:,88), t3x16(:,:,46))
  call vert_AV_Q(ntry, ex3(:), wf4(:,11), wf8(:,61), n3(:,89), t3x8(:,:,33))
  call prop_A_Q(ntry, wf8(:,61), 13, ZERO, 0_intkind1, wf8(:,62), n2(35))
  call vert_QA_V(ntry, ex2(:), wf8(:,62), wf16(:,47), n3(:,90), t3x16(:,:,47))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,62), wf16(:,48), n3(:,91), t3x16(:,:,48))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf4(:,16), wf8(:,63), n3(:,92), t3x8(:,:,34))
  call prop_A_Q(ntry, wf8(:,63), 13, ZERO, 0_intkind1, wf8(:,64), n2(36))
  call vert_QA_V(ntry, ex2(:), wf8(:,64), wf16(:,49), n3(:,93), t3x16(:,:,49))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,64), wf16(:,50), n3(:,94), t3x16(:,:,50))
  call vert_VQ_A(ntry, wf4(:,2), ex1(:), wf8(:,65), n3(:,95), t3x8(:,:,35))
  call prop_Q_A(ntry, wf8(:,65), 11, ZERO, 0_intkind1, wf8(:,66), n2(37))
  call vert_QA_V(ntry, wf8(:,66), ex3(:), wf16(:,51), n3(:,96), t3x16(:,:,51))
  call vert_QA_Z(gZl,ntry, wf8(:,66), ex3(:), wf16(:,52), n3(:,97), t3x16(:,:,52))
  call vert_ZQ_A(gZl,ntry, wf4(:,6), ex1(:), wf8(:,67), n3(:,98), t3x8(:,:,36))
  call prop_Q_A(ntry, wf8(:,67), 11, ZERO, 0_intkind1, wf8(:,68), n2(38))
  call vert_QA_V(ntry, wf8(:,68), ex3(:), wf16(:,53), n3(:,99), t3x16(:,:,53))
  call vert_QA_Z(gZl,ntry, wf8(:,68), ex3(:), wf16(:,54), n3(:,100), t3x16(:,:,54))
  call vert_AV_Q(ntry, ex3(:), wf4(:,2), wf8(:,69), n3(:,101), t3x8(:,:,37))
  call prop_A_Q(ntry, wf8(:,69), 14, ZERO, 0_intkind1, wf8(:,70), n2(39))
  call vert_QA_V(ntry, ex1(:), wf8(:,70), wf16(:,55), n3(:,102), t3x16(:,:,55))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf4(:,6), wf8(:,71), n3(:,103), t3x8(:,:,38))
  call prop_A_Q(ntry, wf8(:,71), 14, ZERO, 0_intkind1, wf8(:,72), n2(40))
  call vert_QA_V(ntry, ex1(:), wf8(:,72), wf16(:,56), n3(:,104), t3x16(:,:,56))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,70), wf16(:,57), n3(:,105), t3x16(:,:,57))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,72), wf16(:,58), n3(:,106), t3x16(:,:,58))
  call vert_QA_V(ntry, ex5(:), ex6(:), wf4(:,17), n3(:,107), t3x4(:,:,11))
  call counter_VVG_G(ntry, wf4(:,1), wf4(:,2), ex7(:), wf32(:,1), n4(:,1), t4x32(:,:,1))
  call counter_VVG_G(ntry, wf4(:,1), wf4(:,6), ex7(:), wf32(:,2), n4(:,2), t4x32(:,:,2))
  call counter_VVG_G(ntry, wf4(:,8), wf4(:,2), ex7(:), wf32(:,3), n4(:,3), t4x32(:,:,3))
  call counter_VVG_G(ntry, wf4(:,8), wf4(:,6), ex7(:), wf32(:,4), n4(:,4), t4x32(:,:,4))
  call counter_VVG_G(ntry, wf4(:,12), wf4(:,11), ex7(:), wf32(:,5), n4(:,5), t4x32(:,:,5))
  call counter_VVG_G(ntry, wf4(:,14), wf4(:,11), ex7(:), wf32(:,6), n4(:,6), t4x32(:,:,6))
  call counter_VVG_G(ntry, wf4(:,12), wf4(:,16), ex7(:), wf32(:,7), n4(:,7), t4x32(:,:,7))
  call counter_VVG_G(ntry, wf4(:,14), wf4(:,16), ex7(:), wf32(:,8), n4(:,8), t4x32(:,:,8))
  call counter_GG_S(ntry, wf4(:,17), ex7(:), wf8(:,73), n3(:,108), t3x8(:,:,39))
  call counter_VQ_A(ntry, wf4(:,2), wf4(:,4), wf16(:,59), n3(:,109), t3x16(:,:,59))
  call counter_ZQ_A(gZd,ntry, wf4(:,6), wf4(:,4), wf16(:,60), n3(:,110), t3x16(:,:,60))
  call counter_VQ_A(ntry, wf4(:,1), wf4(:,4), wf16(:,61), n3(:,111), t3x16(:,:,61))
  call counter_ZQ_A(gZd,ntry, wf4(:,8), wf4(:,4), wf16(:,62), n3(:,112), t3x16(:,:,62))
  call counter_AV_Q(ntry, wf4(:,10), wf4(:,2), wf16(:,63), n3(:,113), t3x16(:,:,63))
  call counter_AZ_Q(gZd,ntry, wf4(:,10), wf4(:,6), wf16(:,64), n3(:,114), t3x16(:,:,64))
  call counter_AV_Q(ntry, wf4(:,10), wf4(:,1), wf16(:,65), n3(:,115), t3x16(:,:,65))
  call counter_AZ_Q(gZd,ntry, wf4(:,10), wf4(:,8), wf16(:,66), n3(:,116), t3x16(:,:,66))
  call counter_VQ_A(ntry, ex7(:), wf8(:,11), wf16(:,67), n3(:,117), t3x16(:,:,67))
  call counter_VQ_A(ntry, ex7(:), wf8(:,13), wf16(:,68), n3(:,118), t3x16(:,:,68))
  call counter_VG_G(ntry, wf4(:,6), ex7(:), 64, wf8(:,74), 74, n3(:,119), t3x8(:,:,40))
  call vert_QA_V(ntry, wf8(:,11), ex6(:), wf16(:,69), n3(:,120), t3x16(:,:,69))
  call vert_QA_V(ntry, wf8(:,13), ex6(:), wf16(:,70), n3(:,121), t3x16(:,:,70))
  call counter_VQ_A(ntry, ex7(:), wf8(:,15), wf16(:,71), n3(:,122), t3x16(:,:,71))
  call counter_VQ_A(ntry, ex7(:), wf8(:,17), wf16(:,72), n3(:,123), t3x16(:,:,72))
  call vert_QA_V(ntry, ex5(:), wf8(:,2), wf16(:,73), n3(:,124), t3x16(:,:,73))
  call vert_QA_V(ntry, ex5(:), wf8(:,4), wf16(:,74), n3(:,125), t3x16(:,:,74))
  call counter_VG_G(ntry, wf4(:,8), ex7(:), 64, wf8(:,75), 69, n3(:,126), t3x8(:,:,41))
  call vert_QA_V(ntry, wf8(:,15), ex6(:), wf16(:,75), n3(:,127), t3x16(:,:,75))
  call vert_QA_V(ntry, wf8(:,17), ex6(:), wf16(:,76), n3(:,128), t3x16(:,:,76))
  call vert_QA_V(ntry, ex5(:), wf8(:,6), wf16(:,77), n3(:,129), t3x16(:,:,77))
  call vert_QA_V(ntry, ex5(:), wf8(:,8), wf16(:,78), n3(:,130), t3x16(:,:,78))
  call counter_AQ_S(gH,ntry, ex6(:), wf4(:,4), wf8(:,76), n3(:,131), t3x8(:,:,42))
  call counter_AV_Q(ntry, ex6(:), wf4(:,2), wf8(:,77), n3(:,132), t3x8(:,:,43))
  call prop_Q_A(ntry, wf16(:,3), 85, MB, 1_intkind1, wf16(:,79), n2(41))
  call counter_AZ_Q(gZd,ntry, ex6(:), wf4(:,6), wf8(:,78), n3(:,133), t3x8(:,:,44))
  call prop_Q_A(ntry, wf16(:,4), 85, MB, 1_intkind1, wf16(:,80), n2(42))
  call counter_AV_Q(ntry, ex6(:), wf4(:,1), wf8(:,79), n3(:,134), t3x8(:,:,45))
  call prop_Q_A(ntry, wf16(:,1), 90, MB, 1_intkind1, wf16(:,81), n2(43))
  call prop_Q_A(ntry, wf16(:,2), 90, MB, 1_intkind1, wf16(:,82), n2(44))
  call counter_AZ_Q(gZd,ntry, ex6(:), wf4(:,8), wf8(:,80), n3(:,135), t3x8(:,:,46))
  call prop_A_Q(ntry, wf8(:,77), 42, MB, 1_intkind1, wf8(:,81), n2(45))
  call prop_A_Q(ntry, wf8(:,78), 42, MB, 1_intkind1, wf8(:,82), n2(46))
  call prop_A_Q(ntry, wf8(:,79), 37, MB, 1_intkind1, wf8(:,83), n2(47))
  call prop_A_Q(ntry, wf8(:,80), 37, MB, 1_intkind1, wf8(:,84), n2(48))
  call counter_AV_Q(ntry, ex6(:), ex7(:), wf4(:,18), n3(:,136), t3x4(:,:,12))
  call prop_A_Q(ntry, wf4(:,18), 96, MB, 1_intkind1, wf4(:,19), n2(49))
  call vert_AV_Q(ntry, wf4(:,19), wf4(:,2), wf16(:,83), n3(:,137), t3x16(:,:,79))
  call vert_AZ_Q(gZd,ntry, wf4(:,19), wf4(:,6), wf16(:,84), n3(:,138), t3x16(:,:,80))
  call vert_AV_Q(ntry, wf4(:,19), wf4(:,1), wf16(:,85), n3(:,139), t3x16(:,:,81))
  call vert_AZ_Q(gZd,ntry, wf4(:,19), wf4(:,8), wf16(:,86), n3(:,140), t3x16(:,:,82))
  call vert_AQ_S(gH,ntry, wf4(:,19), ex5(:), wf8(:,85), n3(:,141), t3x8(:,:,47))
  call counter_AQ_S(gH,ntry, wf4(:,10), ex5(:), wf8(:,86), n3(:,142), t3x8(:,:,48))
  call counter_VQ_A(ntry, wf4(:,2), ex5(:), wf8(:,87), n3(:,143), t3x8(:,:,49))
  call prop_A_Q(ntry, wf16(:,8), 101, MB, 1_intkind1, wf16(:,87), n2(50))
  call counter_ZQ_A(gZd,ntry, wf4(:,6), ex5(:), wf8(:,88), n3(:,144), t3x8(:,:,50))
  call prop_A_Q(ntry, wf16(:,9), 101, MB, 1_intkind1, wf16(:,88), n2(51))
  call counter_VQ_A(ntry, wf4(:,1), ex5(:), wf8(:,89), n3(:,145), t3x8(:,:,51))
  call prop_A_Q(ntry, wf16(:,6), 106, MB, 1_intkind1, wf16(:,89), n2(52))
  call prop_A_Q(ntry, wf16(:,7), 106, MB, 1_intkind1, wf16(:,90), n2(53))
  call counter_ZQ_A(gZd,ntry, wf4(:,8), ex5(:), wf8(:,90), n3(:,146), t3x8(:,:,52))
  call prop_Q_A(ntry, wf8(:,87), 26, MB, 1_intkind1, wf8(:,91), n2(54))
  call vert_VQ_A(ntry, ex7(:), wf8(:,91), wf16(:,91), n3(:,147), t3x16(:,:,83))
  call prop_Q_A(ntry, wf8(:,88), 26, MB, 1_intkind1, wf8(:,92), n2(55))
  call vert_VQ_A(ntry, ex7(:), wf8(:,92), wf16(:,92), n3(:,148), t3x16(:,:,84))
  call prop_Q_A(ntry, wf8(:,89), 21, MB, 1_intkind1, wf8(:,93), n2(56))
  call vert_VQ_A(ntry, ex7(:), wf8(:,93), wf16(:,93), n3(:,149), t3x16(:,:,85))
  call prop_Q_A(ntry, wf8(:,90), 21, MB, 1_intkind1, wf8(:,94), n2(57))
  call vert_VQ_A(ntry, ex7(:), wf8(:,94), wf16(:,94), n3(:,150), t3x16(:,:,86))
  call counter_VQ_A(ntry, ex7(:), ex5(:), wf4(:,20), n3(:,151), t3x4(:,:,13))
  call prop_Q_A(ntry, wf4(:,20), 80, MB, 1_intkind1, wf4(:,21), n2(58))
  call vert_VQ_A(ntry, wf4(:,2), wf4(:,21), wf16(:,95), n3(:,152), t3x16(:,:,87))
  call vert_ZQ_A(gZd,ntry, wf4(:,6), wf4(:,21), wf16(:,96), n3(:,153), t3x16(:,:,88))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,21), wf16(:,97), n3(:,154), t3x16(:,:,89))
  call vert_ZQ_A(gZd,ntry, wf4(:,8), wf4(:,21), wf16(:,98), n3(:,155), t3x16(:,:,90))
  call vert_AQ_S(gH,ntry, ex6(:), wf4(:,21), wf8(:,95), n3(:,156), t3x8(:,:,53))
  call counter_GG_V(ntry, wf4(:,17), 48, ex7(:), 64, wf8(:,96), n3(:,157), t3x8(:,:,54))
  call prop_W_W(ntry, wf8(:,96), 112, MZ, 1_intkind1, wf8(:,97), n2(59))
  call counter_QA_V(ntry, wf4(:,4), ex6(:), wf8(:,98), n3(:,158), t3x8(:,:,55))
  call counter_QA_Z(gZd,ntry, wf4(:,4), ex6(:), wf8(:,99), n3(:,159), t3x8(:,:,56))
  call prop_W_W(ntry, wf8(:,99), 112, MZ, 1_intkind1, wf8(:,100), n2(60))
  call vert_QA_V(ntry, ex5(:), wf4(:,19), wf8(:,101), n3(:,160), t3x8(:,:,57))
  call vert_QA_Z(gZd,ntry, ex5(:), wf4(:,19), wf8(:,102), n3(:,161), t3x8(:,:,58))
  call prop_W_W(ntry, wf8(:,102), 112, MZ, 1_intkind1, wf8(:,103), n2(61))
  call counter_QA_V(ntry, ex5(:), wf4(:,10), wf8(:,104), n3(:,162), t3x8(:,:,59))
  call counter_QA_Z(gZd,ntry, ex5(:), wf4(:,10), wf8(:,105), n3(:,163), t3x8(:,:,60))
  call prop_W_W(ntry, wf8(:,105), 112, MZ, 1_intkind1, wf8(:,106), n2(62))
  call vert_QA_V(ntry, wf4(:,21), ex6(:), wf8(:,107), n3(:,164), t3x8(:,:,61))
  call vert_QA_Z(gZd,ntry, wf4(:,21), ex6(:), wf8(:,108), n3(:,165), t3x8(:,:,62))
  call prop_W_W(ntry, wf8(:,108), 112, MZ, 1_intkind1, wf8(:,109), n2(63))
  call counter_VQ_A(ntry, wf4(:,12), wf4(:,4), wf16(:,99), n3(:,166), t3x16(:,:,91))
  call counter_ZQ_A(gZd,ntry, wf4(:,14), wf4(:,4), wf16(:,100), n3(:,167), t3x16(:,:,92))
  call counter_VQ_A(ntry, wf4(:,11), wf4(:,4), wf16(:,101), n3(:,168), t3x16(:,:,93))
  call counter_ZQ_A(gZd,ntry, wf4(:,16), wf4(:,4), wf16(:,102), n3(:,169), t3x16(:,:,94))
  call counter_AV_Q(ntry, wf4(:,10), wf4(:,12), wf16(:,103), n3(:,170), t3x16(:,:,95))
  call counter_AZ_Q(gZd,ntry, wf4(:,10), wf4(:,14), wf16(:,104), n3(:,171), t3x16(:,:,96))
  call counter_AV_Q(ntry, wf4(:,10), wf4(:,11), wf16(:,105), n3(:,172), t3x16(:,:,97))
  call counter_AZ_Q(gZd,ntry, wf4(:,10), wf4(:,16), wf16(:,106), n3(:,173), t3x16(:,:,98))
  call counter_VQ_A(ntry, ex7(:), wf8(:,42), wf16(:,107), n3(:,174), t3x16(:,:,99))
  call counter_VQ_A(ntry, ex7(:), wf8(:,44), wf16(:,108), n3(:,175), t3x16(:,:,100))
  call counter_VG_G(ntry, wf4(:,14), ex7(:), 64, wf8(:,110), 70, n3(:,176), t3x8(:,:,63))
  call vert_QA_V(ntry, wf8(:,42), ex6(:), wf16(:,109), n3(:,177), t3x16(:,:,101))
  call vert_QA_V(ntry, wf8(:,44), ex6(:), wf16(:,110), n3(:,178), t3x16(:,:,102))
  call counter_VQ_A(ntry, ex7(:), wf8(:,46), wf16(:,111), n3(:,179), t3x16(:,:,103))
  call counter_VQ_A(ntry, ex7(:), wf8(:,48), wf16(:,112), n3(:,180), t3x16(:,:,104))
  call vert_QA_V(ntry, ex5(:), wf8(:,34), wf16(:,113), n3(:,181), t3x16(:,:,105))
  call vert_QA_V(ntry, ex5(:), wf8(:,36), wf16(:,114), n3(:,182), t3x16(:,:,106))
  call counter_VG_G(ntry, wf4(:,16), ex7(:), 64, wf8(:,111), 73, n3(:,183), t3x8(:,:,64))
  call vert_QA_V(ntry, wf8(:,46), ex6(:), wf16(:,115), n3(:,184), t3x16(:,:,107))
  call vert_QA_V(ntry, wf8(:,48), ex6(:), wf16(:,116), n3(:,185), t3x16(:,:,108))
  call vert_QA_V(ntry, ex5(:), wf8(:,38), wf16(:,117), n3(:,186), t3x16(:,:,109))
  call vert_QA_V(ntry, ex5(:), wf8(:,40), wf16(:,118), n3(:,187), t3x16(:,:,110))
  call counter_AV_Q(ntry, ex6(:), wf4(:,12), wf8(:,112), n3(:,188), t3x8(:,:,65))
  call prop_Q_A(ntry, wf16(:,24), 89, MB, 1_intkind1, wf16(:,119), n2(64))
  call counter_AZ_Q(gZd,ntry, ex6(:), wf4(:,14), wf8(:,113), n3(:,189), t3x8(:,:,66))
  call prop_Q_A(ntry, wf16(:,25), 89, MB, 1_intkind1, wf16(:,120), n2(65))
  call counter_AV_Q(ntry, ex6(:), wf4(:,11), wf8(:,114), n3(:,190), t3x8(:,:,67))
  call prop_Q_A(ntry, wf16(:,22), 86, MB, 1_intkind1, wf16(:,121), n2(66))
  call prop_Q_A(ntry, wf16(:,23), 86, MB, 1_intkind1, wf16(:,122), n2(67))
  call counter_AZ_Q(gZd,ntry, ex6(:), wf4(:,16), wf8(:,115), n3(:,191), t3x8(:,:,68))
  call prop_A_Q(ntry, wf8(:,112), 38, MB, 1_intkind1, wf8(:,116), n2(68))
  call prop_A_Q(ntry, wf8(:,113), 38, MB, 1_intkind1, wf8(:,117), n2(69))
  call prop_A_Q(ntry, wf8(:,114), 41, MB, 1_intkind1, wf8(:,118), n2(70))
  call prop_A_Q(ntry, wf8(:,115), 41, MB, 1_intkind1, wf8(:,119), n2(71))
  call vert_AV_Q(ntry, wf4(:,19), wf4(:,12), wf16(:,123), n3(:,192), t3x16(:,:,111))
  call vert_AZ_Q(gZd,ntry, wf4(:,19), wf4(:,14), wf16(:,124), n3(:,193), t3x16(:,:,112))
  call vert_AV_Q(ntry, wf4(:,19), wf4(:,11), wf16(:,125), n3(:,194), t3x16(:,:,113))
  call vert_AZ_Q(gZd,ntry, wf4(:,19), wf4(:,16), wf16(:,126), n3(:,195), t3x16(:,:,114))
  call counter_VQ_A(ntry, wf4(:,12), ex5(:), wf8(:,120), n3(:,196), t3x8(:,:,69))
  call prop_A_Q(ntry, wf16(:,29), 105, MB, 1_intkind1, wf16(:,127), n2(72))
  call counter_ZQ_A(gZd,ntry, wf4(:,14), ex5(:), wf8(:,121), n3(:,197), t3x8(:,:,70))
  call prop_A_Q(ntry, wf16(:,30), 105, MB, 1_intkind1, wf16(:,128), n2(73))
  call counter_VQ_A(ntry, wf4(:,11), ex5(:), wf8(:,122), n3(:,198), t3x8(:,:,71))
  call prop_A_Q(ntry, wf16(:,27), 102, MB, 1_intkind1, wf16(:,129), n2(74))
  call prop_A_Q(ntry, wf16(:,28), 102, MB, 1_intkind1, wf16(:,130), n2(75))
  call counter_ZQ_A(gZd,ntry, wf4(:,16), ex5(:), wf8(:,123), n3(:,199), t3x8(:,:,72))
  call prop_Q_A(ntry, wf8(:,120), 22, MB, 1_intkind1, wf8(:,124), n2(76))
  call vert_VQ_A(ntry, ex7(:), wf8(:,124), wf16(:,131), n3(:,200), t3x16(:,:,115))
  call prop_Q_A(ntry, wf8(:,121), 22, MB, 1_intkind1, wf8(:,125), n2(77))
  call vert_VQ_A(ntry, ex7(:), wf8(:,125), wf16(:,132), n3(:,201), t3x16(:,:,116))
  call prop_Q_A(ntry, wf8(:,122), 25, MB, 1_intkind1, wf8(:,126), n2(78))
  call vert_VQ_A(ntry, ex7(:), wf8(:,126), wf16(:,133), n3(:,202), t3x16(:,:,117))
  call prop_Q_A(ntry, wf8(:,123), 25, MB, 1_intkind1, wf8(:,127), n2(79))
  call vert_VQ_A(ntry, ex7(:), wf8(:,127), wf16(:,134), n3(:,203), t3x16(:,:,118))
  call vert_VQ_A(ntry, wf4(:,12), wf4(:,21), wf16(:,135), n3(:,204), t3x16(:,:,119))
  call vert_ZQ_A(gZd,ntry, wf4(:,14), wf4(:,21), wf16(:,136), n3(:,205), t3x16(:,:,120))
  call vert_VQ_A(ntry, wf4(:,11), wf4(:,21), wf16(:,137), n3(:,206), t3x16(:,:,121))
  call vert_ZQ_A(gZd,ntry, wf4(:,16), wf4(:,21), wf16(:,138), n3(:,207), t3x16(:,:,122))
  call counter_Q_A(ctbb,5,ntry, wf4(:,4), 80, wf4(:,22), n2(80))
  call prop_Q_A(ntry, wf4(:,22), 80, MB, 1_intkind1, wf4(:,23), n2(81))
  call vert_AQ_S(gH,ntry, ex6(:), wf4(:,23), wf8(:,128), n3(:,208), t3x8(:,:,73))
  call vert_VQ_A(ntry, wf4(:,2), wf4(:,23), wf16(:,139), n3(:,209), t3x16(:,:,123))
  call vert_ZQ_A(gZd,ntry, wf4(:,6), wf4(:,23), wf16(:,140), n3(:,210), t3x16(:,:,124))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,23), wf16(:,141), n3(:,211), t3x16(:,:,125))
  call vert_ZQ_A(gZd,ntry, wf4(:,8), wf4(:,23), wf16(:,142), n3(:,212), t3x16(:,:,126))
  call counter_A_Q(ctbb,5,ntry, wf8(:,2), 37, wf8(:,129), n2(82))
  call counter_A_Q(ctbb,5,ntry, wf8(:,4), 37, wf8(:,130), n2(83))
  call counter_A_Q(ctbb,5,ntry, wf8(:,6), 42, wf8(:,131), n2(84))
  call counter_A_Q(ctbb,5,ntry, wf8(:,8), 42, wf8(:,132), n2(85))
  call counter_A_Q(ctbb,5,ntry, wf4(:,10), 96, wf4(:,24), n2(86))
  call prop_A_Q(ntry, wf4(:,24), 96, MB, 1_intkind1, wf4(:,25), n2(87))
  call vert_AQ_S(gH,ntry, wf4(:,25), ex5(:), wf8(:,133), n3(:,213), t3x8(:,:,74))
  call counter_Q_A(ctbb,5,ntry, wf8(:,11), 21, wf8(:,134), n2(88))
  call counter_Q_A(ctbb,5,ntry, wf8(:,13), 21, wf8(:,135), n2(89))
  call counter_Q_A(ctbb,5,ntry, wf8(:,15), 26, wf8(:,136), n2(90))
  call counter_Q_A(ctbb,5,ntry, wf8(:,17), 26, wf8(:,137), n2(91))
  call vert_AV_Q(ntry, wf4(:,25), wf4(:,2), wf16(:,143), n3(:,214), t3x16(:,:,127))
  call vert_AZ_Q(gZd,ntry, wf4(:,25), wf4(:,6), wf16(:,144), n3(:,215), t3x16(:,:,128))
  call vert_AV_Q(ntry, wf4(:,25), wf4(:,1), wf16(:,145), n3(:,216), t3x16(:,:,129))
  call vert_AZ_Q(gZd,ntry, wf4(:,25), wf4(:,8), wf16(:,146), n3(:,217), t3x16(:,:,130))
  call vert_AV_Q(ntry, wf8(:,6), ex7(:), wf16(:,147), n3(:,218), t3x16(:,:,131))
  call prop_A_Q(ntry, wf16(:,147), 106, MB, 1_intkind1, wf16(:,148), n2(92))
  call vert_AV_Q(ntry, wf8(:,8), ex7(:), wf16(:,149), n3(:,219), t3x16(:,:,132))
  call prop_A_Q(ntry, wf16(:,149), 106, MB, 1_intkind1, wf16(:,150), n2(93))
  call vert_AV_Q(ntry, wf8(:,2), ex7(:), wf16(:,151), n3(:,220), t3x16(:,:,133))
  call prop_A_Q(ntry, wf16(:,151), 101, MB, 1_intkind1, wf16(:,152), n2(94))
  call vert_AV_Q(ntry, wf8(:,4), ex7(:), wf16(:,153), n3(:,221), t3x16(:,:,134))
  call prop_A_Q(ntry, wf16(:,153), 101, MB, 1_intkind1, wf16(:,154), n2(95))
  call prop_Q_A(ntry, wf16(:,10), 85, MB, 1_intkind1, wf16(:,155), n2(96))
  call prop_Q_A(ntry, wf16(:,11), 85, MB, 1_intkind1, wf16(:,156), n2(97))
  call prop_Q_A(ntry, wf16(:,12), 90, MB, 1_intkind1, wf16(:,157), n2(98))
  call prop_Q_A(ntry, wf16(:,13), 90, MB, 1_intkind1, wf16(:,158), n2(99))
  call vert_QA_V(ntry, wf4(:,23), ex6(:), wf8(:,138), n3(:,222), t3x8(:,:,75))
  call vert_QA_Z(gZd,ntry, wf4(:,23), ex6(:), wf8(:,139), n3(:,223), t3x8(:,:,76))
  call prop_W_W(ntry, wf16(:,15), 15, MZ, 1_intkind1, wf16(:,159), n2(100))
  call prop_W_W(ntry, wf16(:,17), 15, MZ, 1_intkind1, wf16(:,160), n2(101))
  call prop_W_W(ntry, wf16(:,19), 15, MZ, 1_intkind1, wf16(:,161), n2(102))
  call prop_W_W(ntry, wf16(:,21), 15, MZ, 1_intkind1, wf16(:,162), n2(103))
  call vert_QA_V(ntry, ex5(:), wf4(:,25), wf8(:,140), n3(:,224), t3x8(:,:,77))
  call vert_QA_Z(gZd,ntry, ex5(:), wf4(:,25), wf8(:,141), n3(:,225), t3x8(:,:,78))
  call vert_VQ_A(ntry, wf4(:,12), wf4(:,23), wf16(:,163), n3(:,226), t3x16(:,:,135))
  call vert_ZQ_A(gZd,ntry, wf4(:,14), wf4(:,23), wf16(:,164), n3(:,227), t3x16(:,:,136))
  call vert_VQ_A(ntry, wf4(:,11), wf4(:,23), wf16(:,165), n3(:,228), t3x16(:,:,137))
  call vert_ZQ_A(gZd,ntry, wf4(:,16), wf4(:,23), wf16(:,166), n3(:,229), t3x16(:,:,138))
  call counter_A_Q(ctbb,5,ntry, wf8(:,34), 41, wf8(:,142), n2(104))
  call counter_A_Q(ctbb,5,ntry, wf8(:,36), 41, wf8(:,143), n2(105))
  call counter_A_Q(ctbb,5,ntry, wf8(:,38), 38, wf8(:,144), n2(106))
  call counter_A_Q(ctbb,5,ntry, wf8(:,40), 38, wf8(:,145), n2(107))
  call counter_Q_A(ctbb,5,ntry, wf8(:,42), 25, wf8(:,146), n2(108))
  call counter_Q_A(ctbb,5,ntry, wf8(:,44), 25, wf8(:,147), n2(109))
  call counter_Q_A(ctbb,5,ntry, wf8(:,46), 22, wf8(:,148), n2(110))
  call counter_Q_A(ctbb,5,ntry, wf8(:,48), 22, wf8(:,149), n2(111))
  call vert_AV_Q(ntry, wf4(:,25), wf4(:,12), wf16(:,167), n3(:,230), t3x16(:,:,139))
  call vert_AZ_Q(gZd,ntry, wf4(:,25), wf4(:,14), wf16(:,168), n3(:,231), t3x16(:,:,140))
  call vert_AV_Q(ntry, wf4(:,25), wf4(:,11), wf16(:,169), n3(:,232), t3x16(:,:,141))
  call vert_AZ_Q(gZd,ntry, wf4(:,25), wf4(:,16), wf16(:,170), n3(:,233), t3x16(:,:,142))
  call vert_AV_Q(ntry, wf8(:,38), ex7(:), wf16(:,171), n3(:,234), t3x16(:,:,143))
  call prop_A_Q(ntry, wf16(:,171), 102, MB, 1_intkind1, wf16(:,172), n2(112))
  call vert_AV_Q(ntry, wf8(:,40), ex7(:), wf16(:,173), n3(:,235), t3x16(:,:,144))
  call prop_A_Q(ntry, wf16(:,173), 102, MB, 1_intkind1, wf16(:,174), n2(113))
  call vert_AV_Q(ntry, wf8(:,34), ex7(:), wf16(:,175), n3(:,236), t3x16(:,:,145))
  call prop_A_Q(ntry, wf16(:,175), 105, MB, 1_intkind1, wf16(:,176), n2(114))
  call vert_AV_Q(ntry, wf8(:,36), ex7(:), wf16(:,177), n3(:,237), t3x16(:,:,146))
  call prop_A_Q(ntry, wf16(:,177), 105, MB, 1_intkind1, wf16(:,178), n2(115))
  call prop_Q_A(ntry, wf16(:,31), 89, MB, 1_intkind1, wf16(:,179), n2(116))
  call prop_Q_A(ntry, wf16(:,32), 89, MB, 1_intkind1, wf16(:,180), n2(117))
  call prop_Q_A(ntry, wf16(:,33), 86, MB, 1_intkind1, wf16(:,181), n2(118))
  call prop_Q_A(ntry, wf16(:,34), 86, MB, 1_intkind1, wf16(:,182), n2(119))
  call prop_W_W(ntry, wf16(:,36), 15, MZ, 1_intkind1, wf16(:,183), n2(120))
  call prop_W_W(ntry, wf16(:,38), 15, MZ, 1_intkind1, wf16(:,184), n2(121))
  call prop_W_W(ntry, wf16(:,41), 15, MZ, 1_intkind1, wf16(:,185), n2(122))
  call prop_W_W(ntry, wf16(:,42), 15, MZ, 1_intkind1, wf16(:,186), n2(123))
  call prop_W_W(ntry, wf16(:,44), 15, MZ, 1_intkind1, wf16(:,187), n2(124))
  call prop_W_W(ntry, wf16(:,46), 15, MZ, 1_intkind1, wf16(:,188), n2(125))
  call prop_W_W(ntry, wf16(:,48), 15, MZ, 1_intkind1, wf16(:,189), n2(126))
  call prop_W_W(ntry, wf16(:,50), 15, MZ, 1_intkind1, wf16(:,190), n2(127))
  call prop_W_W(ntry, wf16(:,52), 15, MZ, 1_intkind1, wf16(:,191), n2(128))
  call prop_W_W(ntry, wf16(:,54), 15, MZ, 1_intkind1, wf16(:,192), n2(129))
  call prop_W_W(ntry, wf16(:,57), 15, MZ, 1_intkind1, wf16(:,193), n2(130))
  call prop_W_W(ntry, wf16(:,58), 15, MZ, 1_intkind1, wf16(:,194), n2(131))
  call vert_VQ_A(ntry, wf4(:,2), wf8(:,11), wf32(:,9), n3(:,238), t3x32(:,:,1))
  call prop_Q_A(ntry, wf32(:,9), 31, MB, 1_intkind1, wf32(:,10), n2(132))
  call vert_ZQ_A(gZd,ntry, wf4(:,6), wf8(:,11), wf32(:,11), n3(:,239), t3x32(:,:,2))
  call prop_Q_A(ntry, wf32(:,11), 31, MB, 1_intkind1, wf32(:,12), n2(133))
  call vert_VQ_A(ntry, wf4(:,2), wf8(:,13), wf32(:,13), n3(:,240), t3x32(:,:,3))
  call prop_Q_A(ntry, wf32(:,13), 31, MB, 1_intkind1, wf32(:,14), n2(134))
  call vert_ZQ_A(gZd,ntry, wf4(:,6), wf8(:,13), wf32(:,15), n3(:,241), t3x32(:,:,4))
  call prop_Q_A(ntry, wf32(:,15), 31, MB, 1_intkind1, wf32(:,16), n2(135))
  call vert_AV_Q(ntry, wf8(:,2), wf4(:,2), wf32(:,17), n3(:,242), t3x32(:,:,5))
  call prop_A_Q(ntry, wf32(:,17), 47, MB, 1_intkind1, wf32(:,18), n2(136))
  call vert_AZ_Q(gZd,ntry, wf8(:,2), wf4(:,6), wf32(:,19), n3(:,243), t3x32(:,:,6))
  call prop_A_Q(ntry, wf32(:,19), 47, MB, 1_intkind1, wf32(:,20), n2(137))
  call vert_AV_Q(ntry, wf8(:,4), wf4(:,2), wf32(:,21), n3(:,244), t3x32(:,:,7))
  call prop_A_Q(ntry, wf32(:,21), 47, MB, 1_intkind1, wf32(:,22), n2(138))
  call vert_AZ_Q(gZd,ntry, wf8(:,4), wf4(:,6), wf32(:,23), n3(:,245), t3x32(:,:,8))
  call prop_A_Q(ntry, wf32(:,23), 47, MB, 1_intkind1, wf32(:,24), n2(139))
  call vert_VQ_A(ntry, wf4(:,1), wf8(:,15), wf32(:,25), n3(:,246), t3x32(:,:,9))
  call prop_Q_A(ntry, wf32(:,25), 31, MB, 1_intkind1, wf32(:,26), n2(140))
  call vert_VQ_A(ntry, wf4(:,1), wf8(:,17), wf32(:,27), n3(:,247), t3x32(:,:,10))
  call prop_Q_A(ntry, wf32(:,27), 31, MB, 1_intkind1, wf32(:,28), n2(141))
  call vert_ZQ_A(gZd,ntry, wf4(:,8), wf8(:,15), wf32(:,29), n3(:,248), t3x32(:,:,11))
  call prop_Q_A(ntry, wf32(:,29), 31, MB, 1_intkind1, wf32(:,30), n2(142))
  call vert_ZQ_A(gZd,ntry, wf4(:,8), wf8(:,17), wf32(:,31), n3(:,249), t3x32(:,:,12))
  call prop_Q_A(ntry, wf32(:,31), 31, MB, 1_intkind1, wf32(:,32), n2(143))
  call vert_AV_Q(ntry, wf8(:,6), wf4(:,1), wf32(:,33), n3(:,250), t3x32(:,:,13))
  call prop_A_Q(ntry, wf32(:,33), 47, MB, 1_intkind1, wf32(:,34), n2(144))
  call vert_AV_Q(ntry, wf8(:,8), wf4(:,1), wf32(:,35), n3(:,251), t3x32(:,:,14))
  call prop_A_Q(ntry, wf32(:,35), 47, MB, 1_intkind1, wf32(:,36), n2(145))
  call vert_AZ_Q(gZd,ntry, wf8(:,6), wf4(:,8), wf32(:,37), n3(:,252), t3x32(:,:,15))
  call prop_A_Q(ntry, wf32(:,37), 47, MB, 1_intkind1, wf32(:,38), n2(146))
  call vert_AZ_Q(gZd,ntry, wf8(:,8), wf4(:,8), wf32(:,39), n3(:,253), t3x32(:,:,16))
  call prop_A_Q(ntry, wf32(:,39), 47, MB, 1_intkind1, wf32(:,40), n2(147))
  call vert_QS_A(gH,ntry, ex5(:), wf16(:,5), wf32(:,41), n3(:,254), t3x32(:,:,17))
  call prop_Q_A(ntry, wf32(:,41), 31, MB, 1_intkind1, wf32(:,42), n2(148))
  call vert_SA_Q(gH,ntry, wf16(:,5), ex6(:), wf32(:,43), n3(:,255), t3x32(:,:,18))
  call prop_A_Q(ntry, wf32(:,43), 47, MB, 1_intkind1, wf32(:,44), n2(149))
  call vert_VQ_A(ntry, wf16(:,14), ex5(:), wf32(:,45), n3(:,256), t3x32(:,:,19))
  call prop_Q_A(ntry, wf32(:,45), 31, MB, 1_intkind1, wf32(:,46), n2(150))
  call vert_ZQ_A(gZd,ntry, wf16(:,159), ex5(:), wf32(:,47), n3(:,257), t3x32(:,:,20))
  call prop_Q_A(ntry, wf32(:,47), 31, MB, 1_intkind1, wf32(:,48), n2(151))
  call vert_VQ_A(ntry, wf16(:,16), ex5(:), wf32(:,49), n3(:,258), t3x32(:,:,21))
  call prop_Q_A(ntry, wf32(:,49), 31, MB, 1_intkind1, wf32(:,50), n2(152))
  call vert_ZQ_A(gZd,ntry, wf16(:,160), ex5(:), wf32(:,51), n3(:,259), t3x32(:,:,22))
  call prop_Q_A(ntry, wf32(:,51), 31, MB, 1_intkind1, wf32(:,52), n2(153))
  call vert_AV_Q(ntry, ex6(:), wf16(:,14), wf32(:,53), n3(:,260), t3x32(:,:,23))
  call prop_A_Q(ntry, wf32(:,53), 47, MB, 1_intkind1, wf32(:,54), n2(154))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,159), wf32(:,55), n3(:,261), t3x32(:,:,24))
  call prop_A_Q(ntry, wf32(:,55), 47, MB, 1_intkind1, wf32(:,56), n2(155))
  call vert_AV_Q(ntry, ex6(:), wf16(:,16), wf32(:,57), n3(:,262), t3x32(:,:,25))
  call prop_A_Q(ntry, wf32(:,57), 47, MB, 1_intkind1, wf32(:,58), n2(156))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,160), wf32(:,59), n3(:,263), t3x32(:,:,26))
  call prop_A_Q(ntry, wf32(:,59), 47, MB, 1_intkind1, wf32(:,60), n2(157))
  call vert_VQ_A(ntry, wf16(:,18), ex5(:), wf32(:,61), n3(:,264), t3x32(:,:,27))
  call prop_Q_A(ntry, wf32(:,61), 31, MB, 1_intkind1, wf32(:,62), n2(158))
  call vert_ZQ_A(gZd,ntry, wf16(:,161), ex5(:), wf32(:,63), n3(:,265), t3x32(:,:,28))
  call prop_Q_A(ntry, wf32(:,63), 31, MB, 1_intkind1, wf32(:,64), n2(159))
  call vert_VQ_A(ntry, wf16(:,20), ex5(:), wf32(:,65), n3(:,266), t3x32(:,:,29))
  call prop_Q_A(ntry, wf32(:,65), 31, MB, 1_intkind1, wf32(:,66), n2(160))
  call vert_ZQ_A(gZd,ntry, wf16(:,162), ex5(:), wf32(:,67), n3(:,267), t3x32(:,:,30))
  call prop_Q_A(ntry, wf32(:,67), 31, MB, 1_intkind1, wf32(:,68), n2(161))
  call vert_AV_Q(ntry, ex6(:), wf16(:,18), wf32(:,69), n3(:,268), t3x32(:,:,31))
  call prop_A_Q(ntry, wf32(:,69), 47, MB, 1_intkind1, wf32(:,70), n2(162))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,161), wf32(:,71), n3(:,269), t3x32(:,:,32))
  call prop_A_Q(ntry, wf32(:,71), 47, MB, 1_intkind1, wf32(:,72), n2(163))
  call vert_AV_Q(ntry, ex6(:), wf16(:,20), wf32(:,73), n3(:,270), t3x32(:,:,33))
  call prop_A_Q(ntry, wf32(:,73), 47, MB, 1_intkind1, wf32(:,74), n2(164))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,162), wf32(:,75), n3(:,271), t3x32(:,:,34))
  call prop_A_Q(ntry, wf32(:,75), 47, MB, 1_intkind1, wf32(:,76), n2(165))
  call vert_VQ_A(ntry, wf4(:,12), wf8(:,42), wf32(:,77), n3(:,272), t3x32(:,:,35))
  call prop_Q_A(ntry, wf32(:,77), 31, MB, 1_intkind1, wf32(:,78), n2(166))
  call vert_ZQ_A(gZd,ntry, wf4(:,14), wf8(:,42), wf32(:,79), n3(:,273), t3x32(:,:,36))
  call prop_Q_A(ntry, wf32(:,79), 31, MB, 1_intkind1, wf32(:,80), n2(167))
  call vert_VQ_A(ntry, wf4(:,12), wf8(:,44), wf32(:,81), n3(:,274), t3x32(:,:,37))
  call prop_Q_A(ntry, wf32(:,81), 31, MB, 1_intkind1, wf32(:,82), n2(168))
  call vert_ZQ_A(gZd,ntry, wf4(:,14), wf8(:,44), wf32(:,83), n3(:,275), t3x32(:,:,38))
  call prop_Q_A(ntry, wf32(:,83), 31, MB, 1_intkind1, wf32(:,84), n2(169))
  call vert_AV_Q(ntry, wf8(:,34), wf4(:,12), wf32(:,85), n3(:,276), t3x32(:,:,39))
  call prop_A_Q(ntry, wf32(:,85), 47, MB, 1_intkind1, wf32(:,86), n2(170))
  call vert_AZ_Q(gZd,ntry, wf8(:,34), wf4(:,14), wf32(:,87), n3(:,277), t3x32(:,:,40))
  call prop_A_Q(ntry, wf32(:,87), 47, MB, 1_intkind1, wf32(:,88), n2(171))
  call vert_AV_Q(ntry, wf8(:,36), wf4(:,12), wf32(:,89), n3(:,278), t3x32(:,:,41))
  call prop_A_Q(ntry, wf32(:,89), 47, MB, 1_intkind1, wf32(:,90), n2(172))
  call vert_AZ_Q(gZd,ntry, wf8(:,36), wf4(:,14), wf32(:,91), n3(:,279), t3x32(:,:,42))
  call prop_A_Q(ntry, wf32(:,91), 47, MB, 1_intkind1, wf32(:,92), n2(173))
  call vert_VQ_A(ntry, wf4(:,11), wf8(:,46), wf32(:,93), n3(:,280), t3x32(:,:,43))
  call prop_Q_A(ntry, wf32(:,93), 31, MB, 1_intkind1, wf32(:,94), n2(174))
  call vert_VQ_A(ntry, wf4(:,11), wf8(:,48), wf32(:,95), n3(:,281), t3x32(:,:,44))
  call prop_Q_A(ntry, wf32(:,95), 31, MB, 1_intkind1, wf32(:,96), n2(175))
  call vert_ZQ_A(gZd,ntry, wf4(:,16), wf8(:,46), wf32(:,97), n3(:,282), t3x32(:,:,45))
  call prop_Q_A(ntry, wf32(:,97), 31, MB, 1_intkind1, wf32(:,98), n2(176))
  call vert_ZQ_A(gZd,ntry, wf4(:,16), wf8(:,48), wf32(:,99), n3(:,283), t3x32(:,:,46))
  call prop_Q_A(ntry, wf32(:,99), 31, MB, 1_intkind1, wf32(:,100), n2(177))
  call vert_AV_Q(ntry, wf8(:,38), wf4(:,11), wf32(:,101), n3(:,284), t3x32(:,:,47))
  call prop_A_Q(ntry, wf32(:,101), 47, MB, 1_intkind1, wf32(:,102), n2(178))
  call vert_AV_Q(ntry, wf8(:,40), wf4(:,11), wf32(:,103), n3(:,285), t3x32(:,:,48))
  call prop_A_Q(ntry, wf32(:,103), 47, MB, 1_intkind1, wf32(:,104), n2(179))
  call vert_AZ_Q(gZd,ntry, wf8(:,38), wf4(:,16), wf32(:,105), n3(:,286), t3x32(:,:,49))
  call prop_A_Q(ntry, wf32(:,105), 47, MB, 1_intkind1, wf32(:,106), n2(180))
  call vert_AZ_Q(gZd,ntry, wf8(:,40), wf4(:,16), wf32(:,107), n3(:,287), t3x32(:,:,50))
  call prop_A_Q(ntry, wf32(:,107), 47, MB, 1_intkind1, wf32(:,108), n2(181))
  call vert_QS_A(gH,ntry, ex5(:), wf16(:,26), wf32(:,109), n3(:,288), t3x32(:,:,51))
  call prop_Q_A(ntry, wf32(:,109), 31, MB, 1_intkind1, wf32(:,110), n2(182))
  call vert_SA_Q(gH,ntry, wf16(:,26), ex6(:), wf32(:,111), n3(:,289), t3x32(:,:,52))
  call prop_A_Q(ntry, wf32(:,111), 47, MB, 1_intkind1, wf32(:,112), n2(183))
  call vert_VQ_A(ntry, wf16(:,35), ex5(:), wf32(:,113), n3(:,290), t3x32(:,:,53))
  call prop_Q_A(ntry, wf32(:,113), 31, MB, 1_intkind1, wf32(:,114), n2(184))
  call vert_ZQ_A(gZd,ntry, wf16(:,183), ex5(:), wf32(:,115), n3(:,291), t3x32(:,:,54))
  call prop_Q_A(ntry, wf32(:,115), 31, MB, 1_intkind1, wf32(:,116), n2(185))
  call vert_VQ_A(ntry, wf16(:,37), ex5(:), wf32(:,117), n3(:,292), t3x32(:,:,55))
  call prop_Q_A(ntry, wf32(:,117), 31, MB, 1_intkind1, wf32(:,118), n2(186))
  call vert_ZQ_A(gZd,ntry, wf16(:,184), ex5(:), wf32(:,119), n3(:,293), t3x32(:,:,56))
  call prop_Q_A(ntry, wf32(:,119), 31, MB, 1_intkind1, wf32(:,120), n2(187))
  call vert_AV_Q(ntry, ex6(:), wf16(:,35), wf32(:,121), n3(:,294), t3x32(:,:,57))
  call prop_A_Q(ntry, wf32(:,121), 47, MB, 1_intkind1, wf32(:,122), n2(188))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,183), wf32(:,123), n3(:,295), t3x32(:,:,58))
  call prop_A_Q(ntry, wf32(:,123), 47, MB, 1_intkind1, wf32(:,124), n2(189))
  call vert_AV_Q(ntry, ex6(:), wf16(:,37), wf32(:,125), n3(:,296), t3x32(:,:,59))
  call prop_A_Q(ntry, wf32(:,125), 47, MB, 1_intkind1, wf32(:,126), n2(190))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,184), wf32(:,127), n3(:,297), t3x32(:,:,60))
  call prop_A_Q(ntry, wf32(:,127), 47, MB, 1_intkind1, wf32(:,128), n2(191))
  call vert_VQ_A(ntry, wf16(:,39), ex5(:), wf32(:,129), n3(:,298), t3x32(:,:,61))
  call prop_Q_A(ntry, wf32(:,129), 31, MB, 1_intkind1, wf32(:,130), n2(192))
  call vert_VQ_A(ntry, wf16(:,40), ex5(:), wf32(:,131), n3(:,299), t3x32(:,:,62))
  call prop_Q_A(ntry, wf32(:,131), 31, MB, 1_intkind1, wf32(:,132), n2(193))
  call vert_ZQ_A(gZd,ntry, wf16(:,185), ex5(:), wf32(:,133), n3(:,300), t3x32(:,:,63))
  call prop_Q_A(ntry, wf32(:,133), 31, MB, 1_intkind1, wf32(:,134), n2(194))
  call vert_ZQ_A(gZd,ntry, wf16(:,186), ex5(:), wf32(:,135), n3(:,301), t3x32(:,:,64))
  call prop_Q_A(ntry, wf32(:,135), 31, MB, 1_intkind1, wf32(:,136), n2(195))
  call vert_AV_Q(ntry, ex6(:), wf16(:,39), wf32(:,137), n3(:,302), t3x32(:,:,65))
  call prop_A_Q(ntry, wf32(:,137), 47, MB, 1_intkind1, wf32(:,138), n2(196))
  call vert_AV_Q(ntry, ex6(:), wf16(:,40), wf32(:,139), n3(:,303), t3x32(:,:,66))
  call prop_A_Q(ntry, wf32(:,139), 47, MB, 1_intkind1, wf32(:,140), n2(197))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,185), wf32(:,141), n3(:,304), t3x32(:,:,67))
  call prop_A_Q(ntry, wf32(:,141), 47, MB, 1_intkind1, wf32(:,142), n2(198))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,186), wf32(:,143), n3(:,305), t3x32(:,:,68))
  call prop_A_Q(ntry, wf32(:,143), 47, MB, 1_intkind1, wf32(:,144), n2(199))
  call vert_VQ_A(ntry, wf16(:,43), ex5(:), wf32(:,145), n3(:,306), t3x32(:,:,69))
  call prop_Q_A(ntry, wf32(:,145), 31, MB, 1_intkind1, wf32(:,146), n2(200))
  call vert_ZQ_A(gZd,ntry, wf16(:,187), ex5(:), wf32(:,147), n3(:,307), t3x32(:,:,70))
  call prop_Q_A(ntry, wf32(:,147), 31, MB, 1_intkind1, wf32(:,148), n2(201))
  call vert_VQ_A(ntry, wf16(:,45), ex5(:), wf32(:,149), n3(:,308), t3x32(:,:,71))
  call prop_Q_A(ntry, wf32(:,149), 31, MB, 1_intkind1, wf32(:,150), n2(202))
  call vert_ZQ_A(gZd,ntry, wf16(:,188), ex5(:), wf32(:,151), n3(:,309), t3x32(:,:,72))
  call prop_Q_A(ntry, wf32(:,151), 31, MB, 1_intkind1, wf32(:,152), n2(203))
  call vert_AV_Q(ntry, ex6(:), wf16(:,43), wf32(:,153), n3(:,310), t3x32(:,:,73))
  call prop_A_Q(ntry, wf32(:,153), 47, MB, 1_intkind1, wf32(:,154), n2(204))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,187), wf32(:,155), n3(:,311), t3x32(:,:,74))
  call prop_A_Q(ntry, wf32(:,155), 47, MB, 1_intkind1, wf32(:,156), n2(205))
  call vert_AV_Q(ntry, ex6(:), wf16(:,45), wf32(:,157), n3(:,312), t3x32(:,:,75))
  call prop_A_Q(ntry, wf32(:,157), 47, MB, 1_intkind1, wf32(:,158), n2(206))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,188), wf32(:,159), n3(:,313), t3x32(:,:,76))
  call prop_A_Q(ntry, wf32(:,159), 47, MB, 1_intkind1, wf32(:,160), n2(207))
  call vert_VQ_A(ntry, wf16(:,47), ex5(:), wf32(:,161), n3(:,314), t3x32(:,:,77))
  call prop_Q_A(ntry, wf32(:,161), 31, MB, 1_intkind1, wf32(:,162), n2(208))
  call vert_ZQ_A(gZd,ntry, wf16(:,189), ex5(:), wf32(:,163), n3(:,315), t3x32(:,:,78))
  call prop_Q_A(ntry, wf32(:,163), 31, MB, 1_intkind1, wf32(:,164), n2(209))
  call vert_VQ_A(ntry, wf16(:,49), ex5(:), wf32(:,165), n3(:,316), t3x32(:,:,79))
  call prop_Q_A(ntry, wf32(:,165), 31, MB, 1_intkind1, wf32(:,166), n2(210))
  call vert_ZQ_A(gZd,ntry, wf16(:,190), ex5(:), wf32(:,167), n3(:,317), t3x32(:,:,80))
  call prop_Q_A(ntry, wf32(:,167), 31, MB, 1_intkind1, wf32(:,168), n2(211))
  call vert_AV_Q(ntry, ex6(:), wf16(:,47), wf32(:,169), n3(:,318), t3x32(:,:,81))
  call prop_A_Q(ntry, wf32(:,169), 47, MB, 1_intkind1, wf32(:,170), n2(212))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,189), wf32(:,171), n3(:,319), t3x32(:,:,82))
  call prop_A_Q(ntry, wf32(:,171), 47, MB, 1_intkind1, wf32(:,172), n2(213))
  call vert_AV_Q(ntry, ex6(:), wf16(:,49), wf32(:,173), n3(:,320), t3x32(:,:,83))
  call prop_A_Q(ntry, wf32(:,173), 47, MB, 1_intkind1, wf32(:,174), n2(214))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,190), wf32(:,175), n3(:,321), t3x32(:,:,84))
  call prop_A_Q(ntry, wf32(:,175), 47, MB, 1_intkind1, wf32(:,176), n2(215))
  call vert_VQ_A(ntry, wf16(:,51), ex5(:), wf32(:,177), n3(:,322), t3x32(:,:,85))
  call prop_Q_A(ntry, wf32(:,177), 31, MB, 1_intkind1, wf32(:,178), n2(216))
  call vert_ZQ_A(gZd,ntry, wf16(:,191), ex5(:), wf32(:,179), n3(:,323), t3x32(:,:,86))
  call prop_Q_A(ntry, wf32(:,179), 31, MB, 1_intkind1, wf32(:,180), n2(217))
  call vert_VQ_A(ntry, wf16(:,53), ex5(:), wf32(:,181), n3(:,324), t3x32(:,:,87))
  call prop_Q_A(ntry, wf32(:,181), 31, MB, 1_intkind1, wf32(:,182), n2(218))
  call vert_ZQ_A(gZd,ntry, wf16(:,192), ex5(:), wf32(:,183), n3(:,325), t3x32(:,:,88))
  call prop_Q_A(ntry, wf32(:,183), 31, MB, 1_intkind1, wf32(:,184), n2(219))
  call vert_AV_Q(ntry, ex6(:), wf16(:,51), wf32(:,185), n3(:,326), t3x32(:,:,89))
  call prop_A_Q(ntry, wf32(:,185), 47, MB, 1_intkind1, wf32(:,186), n2(220))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,191), wf32(:,187), n3(:,327), t3x32(:,:,90))
  call prop_A_Q(ntry, wf32(:,187), 47, MB, 1_intkind1, wf32(:,188), n2(221))
  call vert_AV_Q(ntry, ex6(:), wf16(:,53), wf32(:,189), n3(:,328), t3x32(:,:,91))
  call prop_A_Q(ntry, wf32(:,189), 47, MB, 1_intkind1, wf32(:,190), n2(222))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,192), wf32(:,191), n3(:,329), t3x32(:,:,92))
  call prop_A_Q(ntry, wf32(:,191), 47, MB, 1_intkind1, wf32(:,192), n2(223))
  call vert_VQ_A(ntry, wf16(:,55), ex5(:), wf32(:,193), n3(:,330), t3x32(:,:,93))
  call prop_Q_A(ntry, wf32(:,193), 31, MB, 1_intkind1, wf32(:,194), n2(224))
  call vert_VQ_A(ntry, wf16(:,56), ex5(:), wf32(:,195), n3(:,331), t3x32(:,:,94))
  call prop_Q_A(ntry, wf32(:,195), 31, MB, 1_intkind1, wf32(:,196), n2(225))
  call vert_ZQ_A(gZd,ntry, wf16(:,193), ex5(:), wf32(:,197), n3(:,332), t3x32(:,:,95))
  call prop_Q_A(ntry, wf32(:,197), 31, MB, 1_intkind1, wf32(:,198), n2(226))
  call vert_ZQ_A(gZd,ntry, wf16(:,194), ex5(:), wf32(:,199), n3(:,333), t3x32(:,:,96))
  call prop_Q_A(ntry, wf32(:,199), 31, MB, 1_intkind1, wf32(:,200), n2(227))
  call vert_AV_Q(ntry, ex6(:), wf16(:,55), wf32(:,201), n3(:,334), t3x32(:,:,97))
  call prop_A_Q(ntry, wf32(:,201), 47, MB, 1_intkind1, wf32(:,202), n2(228))
  call vert_AV_Q(ntry, ex6(:), wf16(:,56), wf32(:,203), n3(:,335), t3x32(:,:,98))
  call prop_A_Q(ntry, wf32(:,203), 47, MB, 1_intkind1, wf32(:,204), n2(229))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,193), wf32(:,205), n3(:,336), t3x32(:,:,99))
  call prop_A_Q(ntry, wf32(:,205), 47, MB, 1_intkind1, wf32(:,206), n2(230))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,194), wf32(:,207), n3(:,337), t3x32(:,:,100))
  call prop_A_Q(ntry, wf32(:,207), 47, MB, 1_intkind1, wf32(:,208), n2(231))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_exwf(ex5)
  call init_hybrid_exwf(ex6)
  call init_hybrid_exwf(ex7)
  call init_hybrid_wf(wf4)
  call init_hybrid_wf(wf8)
  call init_hybrid_wf(wf16)
  call init_hybrid_wf(wf32)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k))
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0
  
  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do



  contains

subroutine physical_helicities()
  implicit none 

integer :: i1,i2,i3,i4,i5,i6,i7
integer :: n

n=0

do i7= 1, 2
do i6= 1, 2
do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2) .OR. (ex7(i7)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf + ex7(i7)%hf
 end if
end do
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_QA(nsync, wf16(:,1), wf8(:,2), A(:,1), n3(:,338), t3x128(:,:,1), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,2), A(:,2), n3(:,339), t3x128(:,:,2), nhel, den(10))
    call Hcont_QA(nsync, wf16(:,1), wf8(:,4), A(:,3), n3(:,340), t3x128(:,:,3), nhel, den(13))
    call Hcont_QA(nsync, wf16(:,2), wf8(:,4), A(:,4), n3(:,341), t3x128(:,:,4), nhel, den(14))
    call Hcont_QA(nsync, wf16(:,3), wf8(:,6), A(:,5), n3(:,342), t3x128(:,:,5), nhel, den(18))
    call Hcont_QA(nsync, wf16(:,3), wf8(:,8), A(:,6), n3(:,343), t3x128(:,:,6), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,4), A(:,7), n3(:,344), t3x128(:,:,7), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,4), A(:,8), n3(:,345), t3x128(:,:,8), nhel, den(23))
    call Hcont_SS(nsync, wf8(:,9), wf16(:,5), A(:,9), n3(:,346), t3x128(:,:,9), nhel, den(27))
    call Hcont_QA(nsync, wf16(:,6), wf8(:,11), A(:,10), n3(:,347), t3x128(:,:,10), nhel, den(32))
    call Hcont_QA(nsync, wf8(:,11), wf16(:,7), A(:,11), n3(:,348), t3x128(:,:,11), nhel, den(34))
    call Hcont_QA(nsync, wf16(:,6), wf8(:,13), A(:,12), n3(:,349), t3x128(:,:,12), nhel, den(36))
    call Hcont_QA(nsync, wf16(:,7), wf8(:,13), A(:,13), n3(:,350), t3x128(:,:,13), nhel, den(37))
    call Hcont_QA(nsync, wf16(:,8), wf8(:,15), A(:,14), n3(:,351), t3x128(:,:,14), nhel, den(41))
    call Hcont_QA(nsync, wf16(:,8), wf8(:,17), A(:,15), n3(:,352), t3x128(:,:,15), nhel, den(43))
    call Hcont_QA(nsync, wf8(:,15), wf16(:,9), A(:,16), n3(:,353), t3x128(:,:,16), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,17), wf16(:,9), A(:,17), n3(:,354), t3x128(:,:,17), nhel, den(46))
    call Hcont_SS(nsync, wf16(:,5), wf8(:,18), A(:,18), n3(:,355), t3x128(:,:,18), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,10), A(:,19), n3(:,356), t3x128(:,:,19), nhel, den(49))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,10), A(:,20), n3(:,357), t3x128(:,:,20), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,11), A(:,21), n3(:,358), t3x128(:,:,21), nhel, den(51))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,11), A(:,22), n3(:,359), t3x128(:,:,22), nhel, den(52))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,12), A(:,23), n3(:,360), t3x128(:,:,23), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,13), A(:,24), n3(:,361), t3x128(:,:,24), nhel, den(54))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,12), A(:,25), n3(:,362), t3x128(:,:,25), nhel, den(55))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,13), A(:,26), n3(:,363), t3x128(:,:,26), nhel, den(56))
    call Hcont_VV(nsync, wf8(:,20), wf16(:,14), A(:,27), n3(:,364), t3x128(:,:,27), nhel, den(61))
    call Hcont_VV(nsync, wf8(:,23), wf16(:,15), A(:,28), n3(:,365), t3x128(:,:,28), nhel, den(64))
    call Hcont_VV(nsync, wf8(:,20), wf16(:,16), A(:,29), n3(:,366), t3x128(:,:,29), nhel, den(66))
    call Hcont_VV(nsync, wf8(:,23), wf16(:,17), A(:,30), n3(:,367), t3x128(:,:,30), nhel, den(67))
    call Hcont_VV(nsync, wf8(:,20), wf16(:,18), A(:,31), n3(:,368), t3x128(:,:,31), nhel, den(70))
    call Hcont_VV(nsync, wf8(:,23), wf16(:,19), A(:,32), n3(:,369), t3x128(:,:,32), nhel, den(71))
    call Hcont_VV(nsync, wf8(:,20), wf16(:,20), A(:,33), n3(:,370), t3x128(:,:,33), nhel, den(73))
    call Hcont_VV(nsync, wf8(:,23), wf16(:,21), A(:,34), n3(:,371), t3x128(:,:,34), nhel, den(74))
    call Hcont_VV(nsync, wf16(:,14), wf8(:,30), A(:,35), n3(:,372), t3x128(:,:,35), nhel, den(76))
    call Hcont_VV(nsync, wf16(:,15), wf8(:,32), A(:,36), n3(:,373), t3x128(:,:,36), nhel, den(78))
    call Hcont_VV(nsync, wf16(:,16), wf8(:,30), A(:,37), n3(:,374), t3x128(:,:,37), nhel, den(79))
    call Hcont_VV(nsync, wf16(:,17), wf8(:,32), A(:,38), n3(:,375), t3x128(:,:,38), nhel, den(80))
    call Hcont_VV(nsync, wf16(:,18), wf8(:,30), A(:,39), n3(:,376), t3x128(:,:,39), nhel, den(81))
    call Hcont_VV(nsync, wf16(:,19), wf8(:,32), A(:,40), n3(:,377), t3x128(:,:,40), nhel, den(82))
    call Hcont_VV(nsync, wf16(:,20), wf8(:,30), A(:,41), n3(:,378), t3x128(:,:,41), nhel, den(83))
    call Hcont_VV(nsync, wf16(:,21), wf8(:,32), A(:,42), n3(:,379), t3x128(:,:,42), nhel, den(84))
    call Hcont_QA(nsync, wf16(:,22), wf8(:,34), A(:,43), n3(:,380), t3x128(:,:,43), nhel, den(90))
    call Hcont_QA(nsync, wf8(:,34), wf16(:,23), A(:,44), n3(:,381), t3x128(:,:,44), nhel, den(93))
    call Hcont_QA(nsync, wf16(:,22), wf8(:,36), A(:,45), n3(:,382), t3x128(:,:,45), nhel, den(96))
    call Hcont_QA(nsync, wf16(:,23), wf8(:,36), A(:,46), n3(:,383), t3x128(:,:,46), nhel, den(97))
    call Hcont_QA(nsync, wf16(:,24), wf8(:,38), A(:,47), n3(:,384), t3x128(:,:,47), nhel, den(101))
    call Hcont_QA(nsync, wf16(:,24), wf8(:,40), A(:,48), n3(:,385), t3x128(:,:,48), nhel, den(103))
    call Hcont_QA(nsync, wf8(:,38), wf16(:,25), A(:,49), n3(:,386), t3x128(:,:,49), nhel, den(105))
    call Hcont_QA(nsync, wf8(:,40), wf16(:,25), A(:,50), n3(:,387), t3x128(:,:,50), nhel, den(106))
    call Hcont_SS(nsync, wf8(:,9), wf16(:,26), A(:,51), n3(:,388), t3x128(:,:,51), nhel, den(108))
    call Hcont_QA(nsync, wf16(:,27), wf8(:,42), A(:,52), n3(:,389), t3x128(:,:,52), nhel, den(112))
    call Hcont_QA(nsync, wf8(:,42), wf16(:,28), A(:,53), n3(:,390), t3x128(:,:,53), nhel, den(114))
    call Hcont_QA(nsync, wf16(:,27), wf8(:,44), A(:,54), n3(:,391), t3x128(:,:,54), nhel, den(116))
    call Hcont_QA(nsync, wf16(:,28), wf8(:,44), A(:,55), n3(:,392), t3x128(:,:,55), nhel, den(117))
    call Hcont_QA(nsync, wf16(:,29), wf8(:,46), A(:,56), n3(:,393), t3x128(:,:,56), nhel, den(121))
    call Hcont_QA(nsync, wf16(:,29), wf8(:,48), A(:,57), n3(:,394), t3x128(:,:,57), nhel, den(123))
    call Hcont_QA(nsync, wf8(:,46), wf16(:,30), A(:,58), n3(:,395), t3x128(:,:,58), nhel, den(125))
    call Hcont_QA(nsync, wf8(:,48), wf16(:,30), A(:,59), n3(:,396), t3x128(:,:,59), nhel, den(126))
    call Hcont_SS(nsync, wf8(:,18), wf16(:,26), A(:,60), n3(:,397), t3x128(:,:,60), nhel, den(127))
    call Hcont_QA(nsync, wf8(:,38), wf16(:,31), A(:,61), n3(:,398), t3x128(:,:,61), nhel, den(128))
    call Hcont_QA(nsync, wf8(:,40), wf16(:,31), A(:,62), n3(:,399), t3x128(:,:,62), nhel, den(129))
    call Hcont_QA(nsync, wf8(:,38), wf16(:,32), A(:,63), n3(:,400), t3x128(:,:,63), nhel, den(130))
    call Hcont_QA(nsync, wf8(:,40), wf16(:,32), A(:,64), n3(:,401), t3x128(:,:,64), nhel, den(131))
    call Hcont_QA(nsync, wf8(:,34), wf16(:,33), A(:,65), n3(:,402), t3x128(:,:,65), nhel, den(132))
    call Hcont_QA(nsync, wf8(:,34), wf16(:,34), A(:,66), n3(:,403), t3x128(:,:,66), nhel, den(133))
    call Hcont_QA(nsync, wf8(:,36), wf16(:,33), A(:,67), n3(:,404), t3x128(:,:,67), nhel, den(134))
    call Hcont_QA(nsync, wf8(:,36), wf16(:,34), A(:,68), n3(:,405), t3x128(:,:,68), nhel, den(135))
    call Hcont_VV(nsync, wf8(:,20), wf16(:,35), A(:,69), n3(:,406), t3x128(:,:,69), nhel, den(137))
    call Hcont_VV(nsync, wf8(:,23), wf16(:,36), A(:,70), n3(:,407), t3x128(:,:,70), nhel, den(138))
    call Hcont_VV(nsync, wf8(:,20), wf16(:,37), A(:,71), n3(:,408), t3x128(:,:,71), nhel, den(140))
    call Hcont_VV(nsync, wf8(:,23), wf16(:,38), A(:,72), n3(:,409), t3x128(:,:,72), nhel, den(141))
    call Hcont_VV(nsync, wf8(:,20), wf16(:,39), A(:,73), n3(:,410), t3x128(:,:,73), nhel, den(144))
    call Hcont_VV(nsync, wf8(:,20), wf16(:,40), A(:,74), n3(:,411), t3x128(:,:,74), nhel, den(146))
    call Hcont_VV(nsync, wf8(:,23), wf16(:,41), A(:,75), n3(:,412), t3x128(:,:,75), nhel, den(147))
    call Hcont_VV(nsync, wf8(:,23), wf16(:,42), A(:,76), n3(:,413), t3x128(:,:,76), nhel, den(148))
    call Hcont_VV(nsync, wf8(:,30), wf16(:,35), A(:,77), n3(:,414), t3x128(:,:,77), nhel, den(149))
    call Hcont_VV(nsync, wf8(:,32), wf16(:,36), A(:,78), n3(:,415), t3x128(:,:,78), nhel, den(150))
    call Hcont_VV(nsync, wf8(:,30), wf16(:,37), A(:,79), n3(:,416), t3x128(:,:,79), nhel, den(151))
    call Hcont_VV(nsync, wf8(:,32), wf16(:,38), A(:,80), n3(:,417), t3x128(:,:,80), nhel, den(152))
    call Hcont_VV(nsync, wf8(:,30), wf16(:,39), A(:,81), n3(:,418), t3x128(:,:,81), nhel, den(153))
    call Hcont_VV(nsync, wf8(:,30), wf16(:,40), A(:,82), n3(:,419), t3x128(:,:,82), nhel, den(154))
    call Hcont_VV(nsync, wf8(:,32), wf16(:,41), A(:,83), n3(:,420), t3x128(:,:,83), nhel, den(155))
    call Hcont_VV(nsync, wf8(:,32), wf16(:,42), A(:,84), n3(:,421), t3x128(:,:,84), nhel, den(156))
    call Hcont_VV(nsync, wf8(:,20), wf16(:,43), A(:,85), n3(:,422), t3x128(:,:,85), nhel, den(159))
    call Hcont_VV(nsync, wf8(:,23), wf16(:,44), A(:,86), n3(:,423), t3x128(:,:,86), nhel, den(160))
    call Hcont_VV(nsync, wf8(:,20), wf16(:,45), A(:,87), n3(:,424), t3x128(:,:,87), nhel, den(162))
    call Hcont_VV(nsync, wf8(:,23), wf16(:,46), A(:,88), n3(:,425), t3x128(:,:,88), nhel, den(163))
    call Hcont_VV(nsync, wf8(:,20), wf16(:,47), A(:,89), n3(:,426), t3x128(:,:,89), nhel, den(165))
    call Hcont_VV(nsync, wf8(:,23), wf16(:,48), A(:,90), n3(:,427), t3x128(:,:,90), nhel, den(166))
    call Hcont_VV(nsync, wf8(:,20), wf16(:,49), A(:,91), n3(:,428), t3x128(:,:,91), nhel, den(168))
    call Hcont_VV(nsync, wf8(:,23), wf16(:,50), A(:,92), n3(:,429), t3x128(:,:,92), nhel, den(169))
    call Hcont_VV(nsync, wf8(:,30), wf16(:,43), A(:,93), n3(:,430), t3x128(:,:,93), nhel, den(170))
    call Hcont_VV(nsync, wf8(:,32), wf16(:,44), A(:,94), n3(:,431), t3x128(:,:,94), nhel, den(171))
    call Hcont_VV(nsync, wf8(:,30), wf16(:,45), A(:,95), n3(:,432), t3x128(:,:,95), nhel, den(172))
    call Hcont_VV(nsync, wf8(:,32), wf16(:,46), A(:,96), n3(:,433), t3x128(:,:,96), nhel, den(173))
    call Hcont_VV(nsync, wf8(:,30), wf16(:,47), A(:,97), n3(:,434), t3x128(:,:,97), nhel, den(174))
    call Hcont_VV(nsync, wf8(:,32), wf16(:,48), A(:,98), n3(:,435), t3x128(:,:,98), nhel, den(175))
    call Hcont_VV(nsync, wf8(:,30), wf16(:,49), A(:,99), n3(:,436), t3x128(:,:,99), nhel, den(176))
    call Hcont_VV(nsync, wf8(:,32), wf16(:,50), A(:,100), n3(:,437), t3x128(:,:,100), nhel, den(177))
    call Hcont_VV(nsync, wf8(:,20), wf16(:,51), A(:,101), n3(:,438), t3x128(:,:,101), nhel, den(179))
    call Hcont_VV(nsync, wf8(:,23), wf16(:,52), A(:,102), n3(:,439), t3x128(:,:,102), nhel, den(180))
    call Hcont_VV(nsync, wf8(:,20), wf16(:,53), A(:,103), n3(:,440), t3x128(:,:,103), nhel, den(182))
    call Hcont_VV(nsync, wf8(:,23), wf16(:,54), A(:,104), n3(:,441), t3x128(:,:,104), nhel, den(183))
    call Hcont_VV(nsync, wf8(:,20), wf16(:,55), A(:,105), n3(:,442), t3x128(:,:,105), nhel, den(185))
    call Hcont_VV(nsync, wf8(:,20), wf16(:,56), A(:,106), n3(:,443), t3x128(:,:,106), nhel, den(187))
    call Hcont_VV(nsync, wf8(:,23), wf16(:,57), A(:,107), n3(:,444), t3x128(:,:,107), nhel, den(188))
    call Hcont_VV(nsync, wf8(:,23), wf16(:,58), A(:,108), n3(:,445), t3x128(:,:,108), nhel, den(189))
    call Hcont_VV(nsync, wf8(:,30), wf16(:,51), A(:,109), n3(:,446), t3x128(:,:,109), nhel, den(190))
    call Hcont_VV(nsync, wf8(:,32), wf16(:,52), A(:,110), n3(:,447), t3x128(:,:,110), nhel, den(191))
    call Hcont_VV(nsync, wf8(:,30), wf16(:,53), A(:,111), n3(:,448), t3x128(:,:,111), nhel, den(192))
    call Hcont_VV(nsync, wf8(:,32), wf16(:,54), A(:,112), n3(:,449), t3x128(:,:,112), nhel, den(193))
    call Hcont_VV(nsync, wf8(:,30), wf16(:,55), A(:,113), n3(:,450), t3x128(:,:,113), nhel, den(194))
    call Hcont_VV(nsync, wf8(:,30), wf16(:,56), A(:,114), n3(:,451), t3x128(:,:,114), nhel, den(195))
    call Hcont_VV(nsync, wf8(:,32), wf16(:,57), A(:,115), n3(:,452), t3x128(:,:,115), nhel, den(196))
    call Hcont_VV(nsync, wf8(:,32), wf16(:,58), A(:,116), n3(:,453), t3x128(:,:,116), nhel, den(197))

    call Hcont_VV(nsync, wf4(:,17), wf32(:,1), A(:,117), n3(:,454), t3x128(:,:,117), nhel, den(200))
    call Hcont_VV(nsync, wf4(:,17), wf32(:,2), A(:,118), n3(:,455), t3x128(:,:,118), nhel, den(202))
    call Hcont_VV(nsync, wf4(:,17), wf32(:,3), A(:,119), n3(:,456), t3x128(:,:,119), nhel, den(204))
    call Hcont_VV(nsync, wf4(:,17), wf32(:,4), A(:,120), n3(:,457), t3x128(:,:,120), nhel, den(205))
    call Hcont_VV(nsync, wf4(:,17), wf32(:,5), A(:,121), n3(:,458), t3x128(:,:,121), nhel, den(207))
    call Hcont_VV(nsync, wf4(:,17), wf32(:,6), A(:,122), n3(:,459), t3x128(:,:,122), nhel, den(209))
    call Hcont_VV(nsync, wf4(:,17), wf32(:,7), A(:,123), n3(:,460), t3x128(:,:,123), nhel, den(211))
    call Hcont_VV(nsync, wf4(:,17), wf32(:,8), A(:,124), n3(:,461), t3x128(:,:,124), nhel, den(212))
    call Hcont_SS(nsync, wf16(:,5), wf8(:,73), A(:,125), n3(:,462), t3x128(:,:,125), nhel, den(215))
    call Hcont_SS(nsync, wf16(:,5), wf8(:,73), A(:,126), n3(:,463), t3x128(:,:,126), nhel, den(215))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,59), A(:,127), n3(:,464), t3x128(:,:,127), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,60), A(:,128), n3(:,465), t3x128(:,:,128), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,59), A(:,129), n3(:,466), t3x128(:,:,129), nhel, den(13))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,60), A(:,130), n3(:,467), t3x128(:,:,130), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,61), A(:,131), n3(:,468), t3x128(:,:,131), nhel, den(18))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,61), A(:,132), n3(:,469), t3x128(:,:,132), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,62), A(:,133), n3(:,470), t3x128(:,:,133), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,62), A(:,134), n3(:,471), t3x128(:,:,134), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,11), wf16(:,63), A(:,135), n3(:,472), t3x128(:,:,135), nhel, den(32))
    call Hcont_QA(nsync, wf8(:,11), wf16(:,64), A(:,136), n3(:,473), t3x128(:,:,136), nhel, den(34))
    call Hcont_QA(nsync, wf8(:,13), wf16(:,63), A(:,137), n3(:,474), t3x128(:,:,137), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,13), wf16(:,64), A(:,138), n3(:,475), t3x128(:,:,138), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,15), wf16(:,65), A(:,139), n3(:,476), t3x128(:,:,139), nhel, den(41))
    call Hcont_QA(nsync, wf8(:,17), wf16(:,65), A(:,140), n3(:,477), t3x128(:,:,140), nhel, den(43))
    call Hcont_QA(nsync, wf8(:,15), wf16(:,66), A(:,141), n3(:,478), t3x128(:,:,141), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,17), wf16(:,66), A(:,142), n3(:,479), t3x128(:,:,142), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,67), A(:,143), n3(:,480), t3x128(:,:,143), nhel, den(49))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,67), A(:,144), n3(:,481), t3x128(:,:,144), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,68), A(:,145), n3(:,482), t3x128(:,:,145), nhel, den(51))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,68), A(:,146), n3(:,483), t3x128(:,:,146), nhel, den(52))
    call Hcont_VV(nsync, wf8(:,74), wf16(:,69), A(:,147), n3(:,484), t3x128(:,:,147), nhel, den(218))
    call Hcont_VV(nsync, wf8(:,74), wf16(:,70), A(:,148), n3(:,485), t3x128(:,:,148), nhel, den(219))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,71), A(:,149), n3(:,486), t3x128(:,:,149), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,72), A(:,150), n3(:,487), t3x128(:,:,150), nhel, den(54))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,71), A(:,151), n3(:,488), t3x128(:,:,151), nhel, den(55))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,72), A(:,152), n3(:,489), t3x128(:,:,152), nhel, den(56))
    call Hcont_VV(nsync, wf8(:,74), wf16(:,73), A(:,153), n3(:,490), t3x128(:,:,153), nhel, den(220))
    call Hcont_VV(nsync, wf8(:,74), wf16(:,74), A(:,154), n3(:,491), t3x128(:,:,154), nhel, den(221))
    call Hcont_VV(nsync, wf8(:,75), wf16(:,75), A(:,155), n3(:,492), t3x128(:,:,155), nhel, den(224))
    call Hcont_VV(nsync, wf8(:,75), wf16(:,76), A(:,156), n3(:,493), t3x128(:,:,156), nhel, den(225))
    call Hcont_VV(nsync, wf8(:,75), wf16(:,77), A(:,157), n3(:,494), t3x128(:,:,157), nhel, den(226))
    call Hcont_VV(nsync, wf8(:,75), wf16(:,78), A(:,158), n3(:,495), t3x128(:,:,158), nhel, den(227))
    call Hcont_SS(nsync, wf16(:,5), wf8(:,76), A(:,159), n3(:,496), t3x128(:,:,159), nhel, den(228))
    call Hcont_QA(nsync, wf8(:,77), wf16(:,79), A(:,160), n3(:,497), t3x128(:,:,160), nhel, den(231))
    call Hcont_QA(nsync, wf16(:,79), wf8(:,78), A(:,161), n3(:,498), t3x128(:,:,161), nhel, den(232))
    call Hcont_QA(nsync, wf8(:,77), wf16(:,80), A(:,162), n3(:,499), t3x128(:,:,162), nhel, den(234))
    call Hcont_QA(nsync, wf8(:,78), wf16(:,80), A(:,163), n3(:,500), t3x128(:,:,163), nhel, den(235))
    call Hcont_QA(nsync, wf8(:,79), wf16(:,81), A(:,164), n3(:,501), t3x128(:,:,164), nhel, den(238))
    call Hcont_QA(nsync, wf8(:,79), wf16(:,82), A(:,165), n3(:,502), t3x128(:,:,165), nhel, den(240))
    call Hcont_QA(nsync, wf16(:,81), wf8(:,80), A(:,166), n3(:,503), t3x128(:,:,166), nhel, den(241))
    call Hcont_QA(nsync, wf16(:,82), wf8(:,80), A(:,167), n3(:,504), t3x128(:,:,167), nhel, den(242))
    call Hcont_QA(nsync, wf16(:,10), wf8(:,81), A(:,168), n3(:,505), t3x128(:,:,168), nhel, den(49))
    call Hcont_QA(nsync, wf16(:,10), wf8(:,82), A(:,169), n3(:,506), t3x128(:,:,169), nhel, den(50))
    call Hcont_QA(nsync, wf16(:,11), wf8(:,81), A(:,170), n3(:,507), t3x128(:,:,170), nhel, den(51))
    call Hcont_QA(nsync, wf16(:,11), wf8(:,82), A(:,171), n3(:,508), t3x128(:,:,171), nhel, den(52))
    call Hcont_QA(nsync, wf16(:,12), wf8(:,83), A(:,172), n3(:,509), t3x128(:,:,172), nhel, den(53))
    call Hcont_QA(nsync, wf16(:,13), wf8(:,83), A(:,173), n3(:,510), t3x128(:,:,173), nhel, den(54))
    call Hcont_QA(nsync, wf16(:,12), wf8(:,84), A(:,174), n3(:,511), t3x128(:,:,174), nhel, den(55))
    call Hcont_QA(nsync, wf16(:,13), wf8(:,84), A(:,175), n3(:,512), t3x128(:,:,175), nhel, den(56))
    call Hcont_QA(nsync, wf8(:,11), wf16(:,83), A(:,176), n3(:,513), t3x128(:,:,176), nhel, den(32))
    call Hcont_QA(nsync, wf8(:,11), wf16(:,84), A(:,177), n3(:,514), t3x128(:,:,177), nhel, den(34))
    call Hcont_QA(nsync, wf8(:,13), wf16(:,83), A(:,178), n3(:,515), t3x128(:,:,178), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,13), wf16(:,84), A(:,179), n3(:,516), t3x128(:,:,179), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,15), wf16(:,85), A(:,180), n3(:,517), t3x128(:,:,180), nhel, den(41))
    call Hcont_QA(nsync, wf8(:,17), wf16(:,85), A(:,181), n3(:,518), t3x128(:,:,181), nhel, den(43))
    call Hcont_QA(nsync, wf8(:,15), wf16(:,86), A(:,182), n3(:,519), t3x128(:,:,182), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,17), wf16(:,86), A(:,183), n3(:,520), t3x128(:,:,183), nhel, den(46))
    call Hcont_SS(nsync, wf16(:,5), wf8(:,85), A(:,184), n3(:,521), t3x128(:,:,184), nhel, den(48))
    call Hcont_SS(nsync, wf16(:,5), wf8(:,86), A(:,185), n3(:,522), t3x128(:,:,185), nhel, den(243))
    call Hcont_QA(nsync, wf8(:,87), wf16(:,87), A(:,186), n3(:,523), t3x128(:,:,186), nhel, den(246))
    call Hcont_QA(nsync, wf16(:,87), wf8(:,88), A(:,187), n3(:,524), t3x128(:,:,187), nhel, den(247))
    call Hcont_QA(nsync, wf8(:,87), wf16(:,88), A(:,188), n3(:,525), t3x128(:,:,188), nhel, den(249))
    call Hcont_QA(nsync, wf8(:,88), wf16(:,88), A(:,189), n3(:,526), t3x128(:,:,189), nhel, den(250))
    call Hcont_QA(nsync, wf8(:,89), wf16(:,89), A(:,190), n3(:,527), t3x128(:,:,190), nhel, den(253))
    call Hcont_QA(nsync, wf8(:,89), wf16(:,90), A(:,191), n3(:,528), t3x128(:,:,191), nhel, den(255))
    call Hcont_QA(nsync, wf16(:,89), wf8(:,90), A(:,192), n3(:,529), t3x128(:,:,192), nhel, den(256))
    call Hcont_QA(nsync, wf16(:,90), wf8(:,90), A(:,193), n3(:,530), t3x128(:,:,193), nhel, den(257))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,91), A(:,194), n3(:,531), t3x128(:,:,194), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,92), A(:,195), n3(:,532), t3x128(:,:,195), nhel, den(54))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,91), A(:,196), n3(:,533), t3x128(:,:,196), nhel, den(55))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,92), A(:,197), n3(:,534), t3x128(:,:,197), nhel, den(56))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,93), A(:,198), n3(:,535), t3x128(:,:,198), nhel, den(49))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,93), A(:,199), n3(:,536), t3x128(:,:,199), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,94), A(:,200), n3(:,537), t3x128(:,:,200), nhel, den(51))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,94), A(:,201), n3(:,538), t3x128(:,:,201), nhel, den(52))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,95), A(:,202), n3(:,539), t3x128(:,:,202), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,96), A(:,203), n3(:,540), t3x128(:,:,203), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,95), A(:,204), n3(:,541), t3x128(:,:,204), nhel, den(13))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,96), A(:,205), n3(:,542), t3x128(:,:,205), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,97), A(:,206), n3(:,543), t3x128(:,:,206), nhel, den(18))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,97), A(:,207), n3(:,544), t3x128(:,:,207), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,98), A(:,208), n3(:,545), t3x128(:,:,208), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,98), A(:,209), n3(:,546), t3x128(:,:,209), nhel, den(23))
    call Hcont_SS(nsync, wf16(:,5), wf8(:,95), A(:,210), n3(:,547), t3x128(:,:,210), nhel, den(27))
    call Hcont_VV(nsync, wf16(:,15), wf8(:,97), A(:,211), n3(:,548), t3x128(:,:,211), nhel, den(259))
    call Hcont_VV(nsync, wf16(:,17), wf8(:,97), A(:,212), n3(:,549), t3x128(:,:,212), nhel, den(260))
    call Hcont_VV(nsync, wf16(:,19), wf8(:,97), A(:,213), n3(:,550), t3x128(:,:,213), nhel, den(261))
    call Hcont_VV(nsync, wf16(:,21), wf8(:,97), A(:,214), n3(:,551), t3x128(:,:,214), nhel, den(262))
    call Hcont_VV(nsync, wf16(:,14), wf8(:,98), A(:,215), n3(:,552), t3x128(:,:,215), nhel, den(61))
    call Hcont_VV(nsync, wf16(:,15), wf8(:,100), A(:,216), n3(:,553), t3x128(:,:,216), nhel, den(64))
    call Hcont_VV(nsync, wf16(:,16), wf8(:,98), A(:,217), n3(:,554), t3x128(:,:,217), nhel, den(66))
    call Hcont_VV(nsync, wf16(:,17), wf8(:,100), A(:,218), n3(:,555), t3x128(:,:,218), nhel, den(67))
    call Hcont_VV(nsync, wf16(:,18), wf8(:,98), A(:,219), n3(:,556), t3x128(:,:,219), nhel, den(70))
    call Hcont_VV(nsync, wf16(:,19), wf8(:,100), A(:,220), n3(:,557), t3x128(:,:,220), nhel, den(71))
    call Hcont_VV(nsync, wf16(:,20), wf8(:,98), A(:,221), n3(:,558), t3x128(:,:,221), nhel, den(73))
    call Hcont_VV(nsync, wf16(:,21), wf8(:,100), A(:,222), n3(:,559), t3x128(:,:,222), nhel, den(74))
    call Hcont_VV(nsync, wf16(:,14), wf8(:,101), A(:,223), n3(:,560), t3x128(:,:,223), nhel, den(76))
    call Hcont_VV(nsync, wf16(:,15), wf8(:,103), A(:,224), n3(:,561), t3x128(:,:,224), nhel, den(78))
    call Hcont_VV(nsync, wf16(:,16), wf8(:,101), A(:,225), n3(:,562), t3x128(:,:,225), nhel, den(79))
    call Hcont_VV(nsync, wf16(:,17), wf8(:,103), A(:,226), n3(:,563), t3x128(:,:,226), nhel, den(80))
    call Hcont_VV(nsync, wf16(:,18), wf8(:,101), A(:,227), n3(:,564), t3x128(:,:,227), nhel, den(81))
    call Hcont_VV(nsync, wf16(:,19), wf8(:,103), A(:,228), n3(:,565), t3x128(:,:,228), nhel, den(82))
    call Hcont_VV(nsync, wf16(:,20), wf8(:,101), A(:,229), n3(:,566), t3x128(:,:,229), nhel, den(83))
    call Hcont_VV(nsync, wf16(:,21), wf8(:,103), A(:,230), n3(:,567), t3x128(:,:,230), nhel, den(84))
    call Hcont_VV(nsync, wf16(:,14), wf8(:,104), A(:,231), n3(:,568), t3x128(:,:,231), nhel, den(76))
    call Hcont_VV(nsync, wf16(:,15), wf8(:,106), A(:,232), n3(:,569), t3x128(:,:,232), nhel, den(78))
    call Hcont_VV(nsync, wf16(:,16), wf8(:,104), A(:,233), n3(:,570), t3x128(:,:,233), nhel, den(79))
    call Hcont_VV(nsync, wf16(:,17), wf8(:,106), A(:,234), n3(:,571), t3x128(:,:,234), nhel, den(80))
    call Hcont_VV(nsync, wf16(:,18), wf8(:,104), A(:,235), n3(:,572), t3x128(:,:,235), nhel, den(81))
    call Hcont_VV(nsync, wf16(:,19), wf8(:,106), A(:,236), n3(:,573), t3x128(:,:,236), nhel, den(82))
    call Hcont_VV(nsync, wf16(:,20), wf8(:,104), A(:,237), n3(:,574), t3x128(:,:,237), nhel, den(83))
    call Hcont_VV(nsync, wf16(:,21), wf8(:,106), A(:,238), n3(:,575), t3x128(:,:,238), nhel, den(84))
    call Hcont_VV(nsync, wf16(:,14), wf8(:,107), A(:,239), n3(:,576), t3x128(:,:,239), nhel, den(61))
    call Hcont_VV(nsync, wf16(:,15), wf8(:,109), A(:,240), n3(:,577), t3x128(:,:,240), nhel, den(64))
    call Hcont_VV(nsync, wf16(:,16), wf8(:,107), A(:,241), n3(:,578), t3x128(:,:,241), nhel, den(66))
    call Hcont_VV(nsync, wf16(:,17), wf8(:,109), A(:,242), n3(:,579), t3x128(:,:,242), nhel, den(67))
    call Hcont_VV(nsync, wf16(:,18), wf8(:,107), A(:,243), n3(:,580), t3x128(:,:,243), nhel, den(70))
    call Hcont_VV(nsync, wf16(:,19), wf8(:,109), A(:,244), n3(:,581), t3x128(:,:,244), nhel, den(71))
    call Hcont_VV(nsync, wf16(:,20), wf8(:,107), A(:,245), n3(:,582), t3x128(:,:,245), nhel, den(73))
    call Hcont_VV(nsync, wf16(:,21), wf8(:,109), A(:,246), n3(:,583), t3x128(:,:,246), nhel, den(74))
    call Hcont_SS(nsync, wf16(:,26), wf8(:,73), A(:,247), n3(:,584), t3x128(:,:,247), nhel, den(264))
    call Hcont_SS(nsync, wf16(:,26), wf8(:,73), A(:,248), n3(:,585), t3x128(:,:,248), nhel, den(264))
    call Hcont_QA(nsync, wf8(:,34), wf16(:,99), A(:,249), n3(:,586), t3x128(:,:,249), nhel, den(90))
    call Hcont_QA(nsync, wf8(:,34), wf16(:,100), A(:,250), n3(:,587), t3x128(:,:,250), nhel, den(93))
    call Hcont_QA(nsync, wf8(:,36), wf16(:,99), A(:,251), n3(:,588), t3x128(:,:,251), nhel, den(96))
    call Hcont_QA(nsync, wf8(:,36), wf16(:,100), A(:,252), n3(:,589), t3x128(:,:,252), nhel, den(97))
    call Hcont_QA(nsync, wf8(:,38), wf16(:,101), A(:,253), n3(:,590), t3x128(:,:,253), nhel, den(101))
    call Hcont_QA(nsync, wf8(:,40), wf16(:,101), A(:,254), n3(:,591), t3x128(:,:,254), nhel, den(103))
    call Hcont_QA(nsync, wf8(:,38), wf16(:,102), A(:,255), n3(:,592), t3x128(:,:,255), nhel, den(105))
    call Hcont_QA(nsync, wf8(:,40), wf16(:,102), A(:,256), n3(:,593), t3x128(:,:,256), nhel, den(106))
    call Hcont_QA(nsync, wf8(:,42), wf16(:,103), A(:,257), n3(:,594), t3x128(:,:,257), nhel, den(112))
    call Hcont_QA(nsync, wf8(:,42), wf16(:,104), A(:,258), n3(:,595), t3x128(:,:,258), nhel, den(114))
    call Hcont_QA(nsync, wf8(:,44), wf16(:,103), A(:,259), n3(:,596), t3x128(:,:,259), nhel, den(116))
    call Hcont_QA(nsync, wf8(:,44), wf16(:,104), A(:,260), n3(:,597), t3x128(:,:,260), nhel, den(117))
    call Hcont_QA(nsync, wf8(:,46), wf16(:,105), A(:,261), n3(:,598), t3x128(:,:,261), nhel, den(121))
    call Hcont_QA(nsync, wf8(:,48), wf16(:,105), A(:,262), n3(:,599), t3x128(:,:,262), nhel, den(123))
    call Hcont_QA(nsync, wf8(:,46), wf16(:,106), A(:,263), n3(:,600), t3x128(:,:,263), nhel, den(125))
    call Hcont_QA(nsync, wf8(:,48), wf16(:,106), A(:,264), n3(:,601), t3x128(:,:,264), nhel, den(126))
    call Hcont_QA(nsync, wf8(:,38), wf16(:,107), A(:,265), n3(:,602), t3x128(:,:,265), nhel, den(128))
    call Hcont_QA(nsync, wf8(:,40), wf16(:,107), A(:,266), n3(:,603), t3x128(:,:,266), nhel, den(129))
    call Hcont_QA(nsync, wf8(:,38), wf16(:,108), A(:,267), n3(:,604), t3x128(:,:,267), nhel, den(130))
    call Hcont_QA(nsync, wf8(:,40), wf16(:,108), A(:,268), n3(:,605), t3x128(:,:,268), nhel, den(131))
    call Hcont_VV(nsync, wf8(:,110), wf16(:,109), A(:,269), n3(:,606), t3x128(:,:,269), nhel, den(267))
    call Hcont_VV(nsync, wf8(:,110), wf16(:,110), A(:,270), n3(:,607), t3x128(:,:,270), nhel, den(268))
    call Hcont_QA(nsync, wf8(:,34), wf16(:,111), A(:,271), n3(:,608), t3x128(:,:,271), nhel, den(132))
    call Hcont_QA(nsync, wf8(:,34), wf16(:,112), A(:,272), n3(:,609), t3x128(:,:,272), nhel, den(133))
    call Hcont_QA(nsync, wf8(:,36), wf16(:,111), A(:,273), n3(:,610), t3x128(:,:,273), nhel, den(134))
    call Hcont_QA(nsync, wf8(:,36), wf16(:,112), A(:,274), n3(:,611), t3x128(:,:,274), nhel, den(135))
    call Hcont_VV(nsync, wf8(:,110), wf16(:,113), A(:,275), n3(:,612), t3x128(:,:,275), nhel, den(269))
    call Hcont_VV(nsync, wf8(:,110), wf16(:,114), A(:,276), n3(:,613), t3x128(:,:,276), nhel, den(270))
    call Hcont_VV(nsync, wf8(:,111), wf16(:,115), A(:,277), n3(:,614), t3x128(:,:,277), nhel, den(273))
    call Hcont_VV(nsync, wf8(:,111), wf16(:,116), A(:,278), n3(:,615), t3x128(:,:,278), nhel, den(274))
    call Hcont_VV(nsync, wf8(:,111), wf16(:,117), A(:,279), n3(:,616), t3x128(:,:,279), nhel, den(275))
    call Hcont_VV(nsync, wf8(:,111), wf16(:,118), A(:,280), n3(:,617), t3x128(:,:,280), nhel, den(276))
    call Hcont_SS(nsync, wf16(:,26), wf8(:,76), A(:,281), n3(:,618), t3x128(:,:,281), nhel, den(277))
    call Hcont_QA(nsync, wf8(:,112), wf16(:,119), A(:,282), n3(:,619), t3x128(:,:,282), nhel, den(280))
    call Hcont_QA(nsync, wf16(:,119), wf8(:,113), A(:,283), n3(:,620), t3x128(:,:,283), nhel, den(281))
    call Hcont_QA(nsync, wf8(:,112), wf16(:,120), A(:,284), n3(:,621), t3x128(:,:,284), nhel, den(283))
    call Hcont_QA(nsync, wf8(:,113), wf16(:,120), A(:,285), n3(:,622), t3x128(:,:,285), nhel, den(284))
    call Hcont_QA(nsync, wf8(:,114), wf16(:,121), A(:,286), n3(:,623), t3x128(:,:,286), nhel, den(287))
    call Hcont_QA(nsync, wf8(:,114), wf16(:,122), A(:,287), n3(:,624), t3x128(:,:,287), nhel, den(289))
    call Hcont_QA(nsync, wf16(:,121), wf8(:,115), A(:,288), n3(:,625), t3x128(:,:,288), nhel, den(290))
    call Hcont_QA(nsync, wf16(:,122), wf8(:,115), A(:,289), n3(:,626), t3x128(:,:,289), nhel, den(291))
    call Hcont_QA(nsync, wf16(:,31), wf8(:,116), A(:,290), n3(:,627), t3x128(:,:,290), nhel, den(128))
    call Hcont_QA(nsync, wf16(:,31), wf8(:,117), A(:,291), n3(:,628), t3x128(:,:,291), nhel, den(129))
    call Hcont_QA(nsync, wf16(:,32), wf8(:,116), A(:,292), n3(:,629), t3x128(:,:,292), nhel, den(130))
    call Hcont_QA(nsync, wf16(:,32), wf8(:,117), A(:,293), n3(:,630), t3x128(:,:,293), nhel, den(131))
    call Hcont_QA(nsync, wf16(:,33), wf8(:,118), A(:,294), n3(:,631), t3x128(:,:,294), nhel, den(132))
    call Hcont_QA(nsync, wf16(:,34), wf8(:,118), A(:,295), n3(:,632), t3x128(:,:,295), nhel, den(133))
    call Hcont_QA(nsync, wf16(:,33), wf8(:,119), A(:,296), n3(:,633), t3x128(:,:,296), nhel, den(134))
    call Hcont_QA(nsync, wf16(:,34), wf8(:,119), A(:,297), n3(:,634), t3x128(:,:,297), nhel, den(135))
    call Hcont_QA(nsync, wf8(:,42), wf16(:,123), A(:,298), n3(:,635), t3x128(:,:,298), nhel, den(112))
    call Hcont_QA(nsync, wf8(:,42), wf16(:,124), A(:,299), n3(:,636), t3x128(:,:,299), nhel, den(114))
    call Hcont_QA(nsync, wf8(:,44), wf16(:,123), A(:,300), n3(:,637), t3x128(:,:,300), nhel, den(116))
    call Hcont_QA(nsync, wf8(:,44), wf16(:,124), A(:,301), n3(:,638), t3x128(:,:,301), nhel, den(117))
    call Hcont_QA(nsync, wf8(:,46), wf16(:,125), A(:,302), n3(:,639), t3x128(:,:,302), nhel, den(121))
    call Hcont_QA(nsync, wf8(:,48), wf16(:,125), A(:,303), n3(:,640), t3x128(:,:,303), nhel, den(123))
    call Hcont_QA(nsync, wf8(:,46), wf16(:,126), A(:,304), n3(:,641), t3x128(:,:,304), nhel, den(125))
    call Hcont_QA(nsync, wf8(:,48), wf16(:,126), A(:,305), n3(:,642), t3x128(:,:,305), nhel, den(126))
    call Hcont_SS(nsync, wf16(:,26), wf8(:,85), A(:,306), n3(:,643), t3x128(:,:,306), nhel, den(127))
    call Hcont_SS(nsync, wf16(:,26), wf8(:,86), A(:,307), n3(:,644), t3x128(:,:,307), nhel, den(292))
    call Hcont_QA(nsync, wf8(:,120), wf16(:,127), A(:,308), n3(:,645), t3x128(:,:,308), nhel, den(295))
    call Hcont_QA(nsync, wf16(:,127), wf8(:,121), A(:,309), n3(:,646), t3x128(:,:,309), nhel, den(296))
    call Hcont_QA(nsync, wf8(:,120), wf16(:,128), A(:,310), n3(:,647), t3x128(:,:,310), nhel, den(298))
    call Hcont_QA(nsync, wf8(:,121), wf16(:,128), A(:,311), n3(:,648), t3x128(:,:,311), nhel, den(299))
    call Hcont_QA(nsync, wf8(:,122), wf16(:,129), A(:,312), n3(:,649), t3x128(:,:,312), nhel, den(302))
    call Hcont_QA(nsync, wf8(:,122), wf16(:,130), A(:,313), n3(:,650), t3x128(:,:,313), nhel, den(304))
    call Hcont_QA(nsync, wf16(:,129), wf8(:,123), A(:,314), n3(:,651), t3x128(:,:,314), nhel, den(305))
    call Hcont_QA(nsync, wf16(:,130), wf8(:,123), A(:,315), n3(:,652), t3x128(:,:,315), nhel, den(306))
    call Hcont_QA(nsync, wf8(:,34), wf16(:,131), A(:,316), n3(:,653), t3x128(:,:,316), nhel, den(132))
    call Hcont_QA(nsync, wf8(:,34), wf16(:,132), A(:,317), n3(:,654), t3x128(:,:,317), nhel, den(133))
    call Hcont_QA(nsync, wf8(:,36), wf16(:,131), A(:,318), n3(:,655), t3x128(:,:,318), nhel, den(134))
    call Hcont_QA(nsync, wf8(:,36), wf16(:,132), A(:,319), n3(:,656), t3x128(:,:,319), nhel, den(135))
    call Hcont_QA(nsync, wf8(:,38), wf16(:,133), A(:,320), n3(:,657), t3x128(:,:,320), nhel, den(128))
    call Hcont_QA(nsync, wf8(:,40), wf16(:,133), A(:,321), n3(:,658), t3x128(:,:,321), nhel, den(129))
    call Hcont_QA(nsync, wf8(:,38), wf16(:,134), A(:,322), n3(:,659), t3x128(:,:,322), nhel, den(130))
    call Hcont_QA(nsync, wf8(:,40), wf16(:,134), A(:,323), n3(:,660), t3x128(:,:,323), nhel, den(131))
    call Hcont_QA(nsync, wf8(:,34), wf16(:,135), A(:,324), n3(:,661), t3x128(:,:,324), nhel, den(90))
    call Hcont_QA(nsync, wf8(:,34), wf16(:,136), A(:,325), n3(:,662), t3x128(:,:,325), nhel, den(93))
    call Hcont_QA(nsync, wf8(:,36), wf16(:,135), A(:,326), n3(:,663), t3x128(:,:,326), nhel, den(96))
    call Hcont_QA(nsync, wf8(:,36), wf16(:,136), A(:,327), n3(:,664), t3x128(:,:,327), nhel, den(97))
    call Hcont_QA(nsync, wf8(:,38), wf16(:,137), A(:,328), n3(:,665), t3x128(:,:,328), nhel, den(101))
    call Hcont_QA(nsync, wf8(:,40), wf16(:,137), A(:,329), n3(:,666), t3x128(:,:,329), nhel, den(103))
    call Hcont_QA(nsync, wf8(:,38), wf16(:,138), A(:,330), n3(:,667), t3x128(:,:,330), nhel, den(105))
    call Hcont_QA(nsync, wf8(:,40), wf16(:,138), A(:,331), n3(:,668), t3x128(:,:,331), nhel, den(106))
    call Hcont_SS(nsync, wf16(:,26), wf8(:,95), A(:,332), n3(:,669), t3x128(:,:,332), nhel, den(108))
    call Hcont_VV(nsync, wf16(:,36), wf8(:,97), A(:,333), n3(:,670), t3x128(:,:,333), nhel, den(307))
    call Hcont_VV(nsync, wf16(:,38), wf8(:,97), A(:,334), n3(:,671), t3x128(:,:,334), nhel, den(308))
    call Hcont_VV(nsync, wf16(:,41), wf8(:,97), A(:,335), n3(:,672), t3x128(:,:,335), nhel, den(309))
    call Hcont_VV(nsync, wf16(:,42), wf8(:,97), A(:,336), n3(:,673), t3x128(:,:,336), nhel, den(310))
    call Hcont_VV(nsync, wf16(:,35), wf8(:,98), A(:,337), n3(:,674), t3x128(:,:,337), nhel, den(137))
    call Hcont_VV(nsync, wf16(:,36), wf8(:,100), A(:,338), n3(:,675), t3x128(:,:,338), nhel, den(138))
    call Hcont_VV(nsync, wf16(:,37), wf8(:,98), A(:,339), n3(:,676), t3x128(:,:,339), nhel, den(140))
    call Hcont_VV(nsync, wf16(:,38), wf8(:,100), A(:,340), n3(:,677), t3x128(:,:,340), nhel, den(141))
    call Hcont_VV(nsync, wf16(:,39), wf8(:,98), A(:,341), n3(:,678), t3x128(:,:,341), nhel, den(144))
    call Hcont_VV(nsync, wf16(:,40), wf8(:,98), A(:,342), n3(:,679), t3x128(:,:,342), nhel, den(146))
    call Hcont_VV(nsync, wf16(:,41), wf8(:,100), A(:,343), n3(:,680), t3x128(:,:,343), nhel, den(147))
    call Hcont_VV(nsync, wf16(:,42), wf8(:,100), A(:,344), n3(:,681), t3x128(:,:,344), nhel, den(148))
    call Hcont_VV(nsync, wf16(:,35), wf8(:,101), A(:,345), n3(:,682), t3x128(:,:,345), nhel, den(149))
    call Hcont_VV(nsync, wf16(:,36), wf8(:,103), A(:,346), n3(:,683), t3x128(:,:,346), nhel, den(150))
    call Hcont_VV(nsync, wf16(:,37), wf8(:,101), A(:,347), n3(:,684), t3x128(:,:,347), nhel, den(151))
    call Hcont_VV(nsync, wf16(:,38), wf8(:,103), A(:,348), n3(:,685), t3x128(:,:,348), nhel, den(152))
    call Hcont_VV(nsync, wf16(:,39), wf8(:,101), A(:,349), n3(:,686), t3x128(:,:,349), nhel, den(153))
    call Hcont_VV(nsync, wf16(:,40), wf8(:,101), A(:,350), n3(:,687), t3x128(:,:,350), nhel, den(154))
    call Hcont_VV(nsync, wf16(:,41), wf8(:,103), A(:,351), n3(:,688), t3x128(:,:,351), nhel, den(155))
    call Hcont_VV(nsync, wf16(:,42), wf8(:,103), A(:,352), n3(:,689), t3x128(:,:,352), nhel, den(156))
    call Hcont_VV(nsync, wf16(:,35), wf8(:,104), A(:,353), n3(:,690), t3x128(:,:,353), nhel, den(149))
    call Hcont_VV(nsync, wf16(:,36), wf8(:,106), A(:,354), n3(:,691), t3x128(:,:,354), nhel, den(150))
    call Hcont_VV(nsync, wf16(:,37), wf8(:,104), A(:,355), n3(:,692), t3x128(:,:,355), nhel, den(151))
    call Hcont_VV(nsync, wf16(:,38), wf8(:,106), A(:,356), n3(:,693), t3x128(:,:,356), nhel, den(152))
    call Hcont_VV(nsync, wf16(:,39), wf8(:,104), A(:,357), n3(:,694), t3x128(:,:,357), nhel, den(153))
    call Hcont_VV(nsync, wf16(:,40), wf8(:,104), A(:,358), n3(:,695), t3x128(:,:,358), nhel, den(154))
    call Hcont_VV(nsync, wf16(:,41), wf8(:,106), A(:,359), n3(:,696), t3x128(:,:,359), nhel, den(155))
    call Hcont_VV(nsync, wf16(:,42), wf8(:,106), A(:,360), n3(:,697), t3x128(:,:,360), nhel, den(156))
    call Hcont_VV(nsync, wf16(:,35), wf8(:,107), A(:,361), n3(:,698), t3x128(:,:,361), nhel, den(137))
    call Hcont_VV(nsync, wf16(:,36), wf8(:,109), A(:,362), n3(:,699), t3x128(:,:,362), nhel, den(138))
    call Hcont_VV(nsync, wf16(:,37), wf8(:,107), A(:,363), n3(:,700), t3x128(:,:,363), nhel, den(140))
    call Hcont_VV(nsync, wf16(:,38), wf8(:,109), A(:,364), n3(:,701), t3x128(:,:,364), nhel, den(141))
    call Hcont_VV(nsync, wf16(:,39), wf8(:,107), A(:,365), n3(:,702), t3x128(:,:,365), nhel, den(144))
    call Hcont_VV(nsync, wf16(:,40), wf8(:,107), A(:,366), n3(:,703), t3x128(:,:,366), nhel, den(146))
    call Hcont_VV(nsync, wf16(:,41), wf8(:,109), A(:,367), n3(:,704), t3x128(:,:,367), nhel, den(147))
    call Hcont_VV(nsync, wf16(:,42), wf8(:,109), A(:,368), n3(:,705), t3x128(:,:,368), nhel, den(148))
    call Hcont_VV(nsync, wf16(:,44), wf8(:,97), A(:,369), n3(:,706), t3x128(:,:,369), nhel, den(311))
    call Hcont_VV(nsync, wf16(:,46), wf8(:,97), A(:,370), n3(:,707), t3x128(:,:,370), nhel, den(312))
    call Hcont_VV(nsync, wf16(:,48), wf8(:,97), A(:,371), n3(:,708), t3x128(:,:,371), nhel, den(313))
    call Hcont_VV(nsync, wf16(:,50), wf8(:,97), A(:,372), n3(:,709), t3x128(:,:,372), nhel, den(314))
    call Hcont_VV(nsync, wf16(:,43), wf8(:,98), A(:,373), n3(:,710), t3x128(:,:,373), nhel, den(159))
    call Hcont_VV(nsync, wf16(:,44), wf8(:,100), A(:,374), n3(:,711), t3x128(:,:,374), nhel, den(160))
    call Hcont_VV(nsync, wf16(:,45), wf8(:,98), A(:,375), n3(:,712), t3x128(:,:,375), nhel, den(162))
    call Hcont_VV(nsync, wf16(:,46), wf8(:,100), A(:,376), n3(:,713), t3x128(:,:,376), nhel, den(163))
    call Hcont_VV(nsync, wf16(:,47), wf8(:,98), A(:,377), n3(:,714), t3x128(:,:,377), nhel, den(165))
    call Hcont_VV(nsync, wf16(:,48), wf8(:,100), A(:,378), n3(:,715), t3x128(:,:,378), nhel, den(166))
    call Hcont_VV(nsync, wf16(:,49), wf8(:,98), A(:,379), n3(:,716), t3x128(:,:,379), nhel, den(168))
    call Hcont_VV(nsync, wf16(:,50), wf8(:,100), A(:,380), n3(:,717), t3x128(:,:,380), nhel, den(169))
    call Hcont_VV(nsync, wf16(:,43), wf8(:,101), A(:,381), n3(:,718), t3x128(:,:,381), nhel, den(170))
    call Hcont_VV(nsync, wf16(:,44), wf8(:,103), A(:,382), n3(:,719), t3x128(:,:,382), nhel, den(171))
    call Hcont_VV(nsync, wf16(:,45), wf8(:,101), A(:,383), n3(:,720), t3x128(:,:,383), nhel, den(172))
    call Hcont_VV(nsync, wf16(:,46), wf8(:,103), A(:,384), n3(:,721), t3x128(:,:,384), nhel, den(173))
    call Hcont_VV(nsync, wf16(:,47), wf8(:,101), A(:,385), n3(:,722), t3x128(:,:,385), nhel, den(174))
    call Hcont_VV(nsync, wf16(:,48), wf8(:,103), A(:,386), n3(:,723), t3x128(:,:,386), nhel, den(175))
    call Hcont_VV(nsync, wf16(:,49), wf8(:,101), A(:,387), n3(:,724), t3x128(:,:,387), nhel, den(176))
    call Hcont_VV(nsync, wf16(:,50), wf8(:,103), A(:,388), n3(:,725), t3x128(:,:,388), nhel, den(177))
    call Hcont_VV(nsync, wf16(:,43), wf8(:,104), A(:,389), n3(:,726), t3x128(:,:,389), nhel, den(170))
    call Hcont_VV(nsync, wf16(:,44), wf8(:,106), A(:,390), n3(:,727), t3x128(:,:,390), nhel, den(171))
    call Hcont_VV(nsync, wf16(:,45), wf8(:,104), A(:,391), n3(:,728), t3x128(:,:,391), nhel, den(172))
    call Hcont_VV(nsync, wf16(:,46), wf8(:,106), A(:,392), n3(:,729), t3x128(:,:,392), nhel, den(173))
    call Hcont_VV(nsync, wf16(:,47), wf8(:,104), A(:,393), n3(:,730), t3x128(:,:,393), nhel, den(174))
    call Hcont_VV(nsync, wf16(:,48), wf8(:,106), A(:,394), n3(:,731), t3x128(:,:,394), nhel, den(175))
    call Hcont_VV(nsync, wf16(:,49), wf8(:,104), A(:,395), n3(:,732), t3x128(:,:,395), nhel, den(176))
    call Hcont_VV(nsync, wf16(:,50), wf8(:,106), A(:,396), n3(:,733), t3x128(:,:,396), nhel, den(177))
    call Hcont_VV(nsync, wf16(:,43), wf8(:,107), A(:,397), n3(:,734), t3x128(:,:,397), nhel, den(159))
    call Hcont_VV(nsync, wf16(:,44), wf8(:,109), A(:,398), n3(:,735), t3x128(:,:,398), nhel, den(160))
    call Hcont_VV(nsync, wf16(:,45), wf8(:,107), A(:,399), n3(:,736), t3x128(:,:,399), nhel, den(162))
    call Hcont_VV(nsync, wf16(:,46), wf8(:,109), A(:,400), n3(:,737), t3x128(:,:,400), nhel, den(163))
    call Hcont_VV(nsync, wf16(:,47), wf8(:,107), A(:,401), n3(:,738), t3x128(:,:,401), nhel, den(165))
    call Hcont_VV(nsync, wf16(:,48), wf8(:,109), A(:,402), n3(:,739), t3x128(:,:,402), nhel, den(166))
    call Hcont_VV(nsync, wf16(:,49), wf8(:,107), A(:,403), n3(:,740), t3x128(:,:,403), nhel, den(168))
    call Hcont_VV(nsync, wf16(:,50), wf8(:,109), A(:,404), n3(:,741), t3x128(:,:,404), nhel, den(169))
    call Hcont_VV(nsync, wf16(:,52), wf8(:,97), A(:,405), n3(:,742), t3x128(:,:,405), nhel, den(315))
    call Hcont_VV(nsync, wf16(:,54), wf8(:,97), A(:,406), n3(:,743), t3x128(:,:,406), nhel, den(316))
    call Hcont_VV(nsync, wf16(:,57), wf8(:,97), A(:,407), n3(:,744), t3x128(:,:,407), nhel, den(317))
    call Hcont_VV(nsync, wf16(:,58), wf8(:,97), A(:,408), n3(:,745), t3x128(:,:,408), nhel, den(318))
    call Hcont_VV(nsync, wf16(:,51), wf8(:,98), A(:,409), n3(:,746), t3x128(:,:,409), nhel, den(179))
    call Hcont_VV(nsync, wf16(:,52), wf8(:,100), A(:,410), n3(:,747), t3x128(:,:,410), nhel, den(180))
    call Hcont_VV(nsync, wf16(:,53), wf8(:,98), A(:,411), n3(:,748), t3x128(:,:,411), nhel, den(182))
    call Hcont_VV(nsync, wf16(:,54), wf8(:,100), A(:,412), n3(:,749), t3x128(:,:,412), nhel, den(183))
    call Hcont_VV(nsync, wf16(:,55), wf8(:,98), A(:,413), n3(:,750), t3x128(:,:,413), nhel, den(185))
    call Hcont_VV(nsync, wf16(:,56), wf8(:,98), A(:,414), n3(:,751), t3x128(:,:,414), nhel, den(187))
    call Hcont_VV(nsync, wf16(:,57), wf8(:,100), A(:,415), n3(:,752), t3x128(:,:,415), nhel, den(188))
    call Hcont_VV(nsync, wf16(:,58), wf8(:,100), A(:,416), n3(:,753), t3x128(:,:,416), nhel, den(189))
    call Hcont_VV(nsync, wf16(:,51), wf8(:,101), A(:,417), n3(:,754), t3x128(:,:,417), nhel, den(190))
    call Hcont_VV(nsync, wf16(:,52), wf8(:,103), A(:,418), n3(:,755), t3x128(:,:,418), nhel, den(191))
    call Hcont_VV(nsync, wf16(:,53), wf8(:,101), A(:,419), n3(:,756), t3x128(:,:,419), nhel, den(192))
    call Hcont_VV(nsync, wf16(:,54), wf8(:,103), A(:,420), n3(:,757), t3x128(:,:,420), nhel, den(193))
    call Hcont_VV(nsync, wf16(:,55), wf8(:,101), A(:,421), n3(:,758), t3x128(:,:,421), nhel, den(194))
    call Hcont_VV(nsync, wf16(:,56), wf8(:,101), A(:,422), n3(:,759), t3x128(:,:,422), nhel, den(195))
    call Hcont_VV(nsync, wf16(:,57), wf8(:,103), A(:,423), n3(:,760), t3x128(:,:,423), nhel, den(196))
    call Hcont_VV(nsync, wf16(:,58), wf8(:,103), A(:,424), n3(:,761), t3x128(:,:,424), nhel, den(197))
    call Hcont_VV(nsync, wf16(:,51), wf8(:,104), A(:,425), n3(:,762), t3x128(:,:,425), nhel, den(190))
    call Hcont_VV(nsync, wf16(:,52), wf8(:,106), A(:,426), n3(:,763), t3x128(:,:,426), nhel, den(191))
    call Hcont_VV(nsync, wf16(:,53), wf8(:,104), A(:,427), n3(:,764), t3x128(:,:,427), nhel, den(192))
    call Hcont_VV(nsync, wf16(:,54), wf8(:,106), A(:,428), n3(:,765), t3x128(:,:,428), nhel, den(193))
    call Hcont_VV(nsync, wf16(:,55), wf8(:,104), A(:,429), n3(:,766), t3x128(:,:,429), nhel, den(194))
    call Hcont_VV(nsync, wf16(:,56), wf8(:,104), A(:,430), n3(:,767), t3x128(:,:,430), nhel, den(195))
    call Hcont_VV(nsync, wf16(:,57), wf8(:,106), A(:,431), n3(:,768), t3x128(:,:,431), nhel, den(196))
    call Hcont_VV(nsync, wf16(:,58), wf8(:,106), A(:,432), n3(:,769), t3x128(:,:,432), nhel, den(197))
    call Hcont_VV(nsync, wf16(:,51), wf8(:,107), A(:,433), n3(:,770), t3x128(:,:,433), nhel, den(179))
    call Hcont_VV(nsync, wf16(:,52), wf8(:,109), A(:,434), n3(:,771), t3x128(:,:,434), nhel, den(180))
    call Hcont_VV(nsync, wf16(:,53), wf8(:,107), A(:,435), n3(:,772), t3x128(:,:,435), nhel, den(182))
    call Hcont_VV(nsync, wf16(:,54), wf8(:,109), A(:,436), n3(:,773), t3x128(:,:,436), nhel, den(183))
    call Hcont_VV(nsync, wf16(:,55), wf8(:,107), A(:,437), n3(:,774), t3x128(:,:,437), nhel, den(185))
    call Hcont_VV(nsync, wf16(:,56), wf8(:,107), A(:,438), n3(:,775), t3x128(:,:,438), nhel, den(187))
    call Hcont_VV(nsync, wf16(:,57), wf8(:,109), A(:,439), n3(:,776), t3x128(:,:,439), nhel, den(188))
    call Hcont_VV(nsync, wf16(:,58), wf8(:,109), A(:,440), n3(:,777), t3x128(:,:,440), nhel, den(189))
    call Hcont_SS(nsync, wf16(:,5), wf8(:,128), A(:,441), n3(:,778), t3x128(:,:,441), nhel, den(320))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,139), A(:,442), n3(:,779), t3x128(:,:,442), nhel, den(322))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,140), A(:,443), n3(:,780), t3x128(:,:,443), nhel, den(324))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,139), A(:,444), n3(:,781), t3x128(:,:,444), nhel, den(325))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,140), A(:,445), n3(:,782), t3x128(:,:,445), nhel, den(326))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,141), A(:,446), n3(:,783), t3x128(:,:,446), nhel, den(328))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,141), A(:,447), n3(:,784), t3x128(:,:,447), nhel, den(329))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,142), A(:,448), n3(:,785), t3x128(:,:,448), nhel, den(331))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,142), A(:,449), n3(:,786), t3x128(:,:,449), nhel, den(332))
    call Hcont_QA(nsync, wf16(:,81), wf8(:,129), A(:,450), n3(:,787), t3x128(:,:,450), nhel, den(333))
    call Hcont_QA(nsync, wf16(:,82), wf8(:,129), A(:,451), n3(:,788), t3x128(:,:,451), nhel, den(334))
    call Hcont_QA(nsync, wf16(:,81), wf8(:,130), A(:,452), n3(:,789), t3x128(:,:,452), nhel, den(335))
    call Hcont_QA(nsync, wf16(:,82), wf8(:,130), A(:,453), n3(:,790), t3x128(:,:,453), nhel, den(336))
    call Hcont_QA(nsync, wf16(:,79), wf8(:,131), A(:,454), n3(:,791), t3x128(:,:,454), nhel, den(337))
    call Hcont_QA(nsync, wf16(:,79), wf8(:,132), A(:,455), n3(:,792), t3x128(:,:,455), nhel, den(338))
    call Hcont_QA(nsync, wf16(:,80), wf8(:,131), A(:,456), n3(:,793), t3x128(:,:,456), nhel, den(339))
    call Hcont_QA(nsync, wf16(:,80), wf8(:,132), A(:,457), n3(:,794), t3x128(:,:,457), nhel, den(340))
    call Hcont_SS(nsync, wf16(:,5), wf8(:,133), A(:,458), n3(:,795), t3x128(:,:,458), nhel, den(342))
    call Hcont_QA(nsync, wf16(:,89), wf8(:,134), A(:,459), n3(:,796), t3x128(:,:,459), nhel, den(343))
    call Hcont_QA(nsync, wf16(:,90), wf8(:,134), A(:,460), n3(:,797), t3x128(:,:,460), nhel, den(344))
    call Hcont_QA(nsync, wf16(:,89), wf8(:,135), A(:,461), n3(:,798), t3x128(:,:,461), nhel, den(345))
    call Hcont_QA(nsync, wf16(:,90), wf8(:,135), A(:,462), n3(:,799), t3x128(:,:,462), nhel, den(346))
    call Hcont_QA(nsync, wf16(:,87), wf8(:,136), A(:,463), n3(:,800), t3x128(:,:,463), nhel, den(347))
    call Hcont_QA(nsync, wf16(:,87), wf8(:,137), A(:,464), n3(:,801), t3x128(:,:,464), nhel, den(348))
    call Hcont_QA(nsync, wf16(:,88), wf8(:,136), A(:,465), n3(:,802), t3x128(:,:,465), nhel, den(349))
    call Hcont_QA(nsync, wf16(:,88), wf8(:,137), A(:,466), n3(:,803), t3x128(:,:,466), nhel, den(350))
    call Hcont_QA(nsync, wf8(:,11), wf16(:,143), A(:,467), n3(:,804), t3x128(:,:,467), nhel, den(352))
    call Hcont_QA(nsync, wf8(:,11), wf16(:,144), A(:,468), n3(:,805), t3x128(:,:,468), nhel, den(354))
    call Hcont_QA(nsync, wf8(:,13), wf16(:,143), A(:,469), n3(:,806), t3x128(:,:,469), nhel, den(355))
    call Hcont_QA(nsync, wf8(:,13), wf16(:,144), A(:,470), n3(:,807), t3x128(:,:,470), nhel, den(356))
    call Hcont_QA(nsync, wf8(:,15), wf16(:,145), A(:,471), n3(:,808), t3x128(:,:,471), nhel, den(358))
    call Hcont_QA(nsync, wf8(:,17), wf16(:,145), A(:,472), n3(:,809), t3x128(:,:,472), nhel, den(359))
    call Hcont_QA(nsync, wf8(:,15), wf16(:,146), A(:,473), n3(:,810), t3x128(:,:,473), nhel, den(361))
    call Hcont_QA(nsync, wf8(:,17), wf16(:,146), A(:,474), n3(:,811), t3x128(:,:,474), nhel, den(362))
    call Hcont_QA(nsync, wf8(:,134), wf16(:,148), A(:,475), n3(:,812), t3x128(:,:,475), nhel, den(364))
    call Hcont_QA(nsync, wf8(:,134), wf16(:,150), A(:,476), n3(:,813), t3x128(:,:,476), nhel, den(366))
    call Hcont_QA(nsync, wf8(:,135), wf16(:,148), A(:,477), n3(:,814), t3x128(:,:,477), nhel, den(367))
    call Hcont_QA(nsync, wf8(:,135), wf16(:,150), A(:,478), n3(:,815), t3x128(:,:,478), nhel, den(368))
    call Hcont_QA(nsync, wf8(:,136), wf16(:,152), A(:,479), n3(:,816), t3x128(:,:,479), nhel, den(370))
    call Hcont_QA(nsync, wf8(:,137), wf16(:,152), A(:,480), n3(:,817), t3x128(:,:,480), nhel, den(371))
    call Hcont_QA(nsync, wf8(:,136), wf16(:,154), A(:,481), n3(:,818), t3x128(:,:,481), nhel, den(373))
    call Hcont_QA(nsync, wf8(:,137), wf16(:,154), A(:,482), n3(:,819), t3x128(:,:,482), nhel, den(374))
    call Hcont_QA(nsync, wf8(:,131), wf16(:,155), A(:,483), n3(:,820), t3x128(:,:,483), nhel, den(376))
    call Hcont_QA(nsync, wf8(:,132), wf16(:,155), A(:,484), n3(:,821), t3x128(:,:,484), nhel, den(377))
    call Hcont_QA(nsync, wf8(:,131), wf16(:,156), A(:,485), n3(:,822), t3x128(:,:,485), nhel, den(379))
    call Hcont_QA(nsync, wf8(:,132), wf16(:,156), A(:,486), n3(:,823), t3x128(:,:,486), nhel, den(380))
    call Hcont_QA(nsync, wf8(:,129), wf16(:,157), A(:,487), n3(:,824), t3x128(:,:,487), nhel, den(382))
    call Hcont_QA(nsync, wf8(:,129), wf16(:,158), A(:,488), n3(:,825), t3x128(:,:,488), nhel, den(384))
    call Hcont_QA(nsync, wf8(:,130), wf16(:,157), A(:,489), n3(:,826), t3x128(:,:,489), nhel, den(385))
    call Hcont_QA(nsync, wf8(:,130), wf16(:,158), A(:,490), n3(:,827), t3x128(:,:,490), nhel, den(386))
    call Hcont_VV(nsync, wf16(:,14), wf8(:,138), A(:,491), n3(:,828), t3x128(:,:,491), nhel, den(389))
    call Hcont_VV(nsync, wf8(:,139), wf16(:,159), A(:,492), n3(:,829), t3x128(:,:,492), nhel, den(392))
    call Hcont_VV(nsync, wf16(:,16), wf8(:,138), A(:,493), n3(:,830), t3x128(:,:,493), nhel, den(394))
    call Hcont_VV(nsync, wf8(:,139), wf16(:,160), A(:,494), n3(:,831), t3x128(:,:,494), nhel, den(396))
    call Hcont_VV(nsync, wf16(:,18), wf8(:,138), A(:,495), n3(:,832), t3x128(:,:,495), nhel, den(398))
    call Hcont_VV(nsync, wf8(:,139), wf16(:,161), A(:,496), n3(:,833), t3x128(:,:,496), nhel, den(400))
    call Hcont_VV(nsync, wf16(:,20), wf8(:,138), A(:,497), n3(:,834), t3x128(:,:,497), nhel, den(402))
    call Hcont_VV(nsync, wf8(:,139), wf16(:,162), A(:,498), n3(:,835), t3x128(:,:,498), nhel, den(404))
    call Hcont_VV(nsync, wf16(:,14), wf8(:,140), A(:,499), n3(:,836), t3x128(:,:,499), nhel, den(405))
    call Hcont_VV(nsync, wf16(:,159), wf8(:,141), A(:,500), n3(:,837), t3x128(:,:,500), nhel, den(406))
    call Hcont_VV(nsync, wf16(:,16), wf8(:,140), A(:,501), n3(:,838), t3x128(:,:,501), nhel, den(407))
    call Hcont_VV(nsync, wf16(:,160), wf8(:,141), A(:,502), n3(:,839), t3x128(:,:,502), nhel, den(408))
    call Hcont_VV(nsync, wf16(:,18), wf8(:,140), A(:,503), n3(:,840), t3x128(:,:,503), nhel, den(409))
    call Hcont_VV(nsync, wf16(:,161), wf8(:,141), A(:,504), n3(:,841), t3x128(:,:,504), nhel, den(410))
    call Hcont_VV(nsync, wf16(:,20), wf8(:,140), A(:,505), n3(:,842), t3x128(:,:,505), nhel, den(411))
    call Hcont_VV(nsync, wf16(:,162), wf8(:,141), A(:,506), n3(:,843), t3x128(:,:,506), nhel, den(412))
    call Hcont_SS(nsync, wf16(:,26), wf8(:,128), A(:,507), n3(:,844), t3x128(:,:,507), nhel, den(413))
    call Hcont_QA(nsync, wf8(:,34), wf16(:,163), A(:,508), n3(:,845), t3x128(:,:,508), nhel, den(415))
    call Hcont_QA(nsync, wf8(:,34), wf16(:,164), A(:,509), n3(:,846), t3x128(:,:,509), nhel, den(417))
    call Hcont_QA(nsync, wf8(:,36), wf16(:,163), A(:,510), n3(:,847), t3x128(:,:,510), nhel, den(418))
    call Hcont_QA(nsync, wf8(:,36), wf16(:,164), A(:,511), n3(:,848), t3x128(:,:,511), nhel, den(419))
    call Hcont_QA(nsync, wf8(:,38), wf16(:,165), A(:,512), n3(:,849), t3x128(:,:,512), nhel, den(421))
    call Hcont_QA(nsync, wf8(:,40), wf16(:,165), A(:,513), n3(:,850), t3x128(:,:,513), nhel, den(422))
    call Hcont_QA(nsync, wf8(:,38), wf16(:,166), A(:,514), n3(:,851), t3x128(:,:,514), nhel, den(424))
    call Hcont_QA(nsync, wf8(:,40), wf16(:,166), A(:,515), n3(:,852), t3x128(:,:,515), nhel, den(425))
    call Hcont_QA(nsync, wf16(:,121), wf8(:,142), A(:,516), n3(:,853), t3x128(:,:,516), nhel, den(426))
    call Hcont_QA(nsync, wf16(:,122), wf8(:,142), A(:,517), n3(:,854), t3x128(:,:,517), nhel, den(427))
    call Hcont_QA(nsync, wf16(:,121), wf8(:,143), A(:,518), n3(:,855), t3x128(:,:,518), nhel, den(428))
    call Hcont_QA(nsync, wf16(:,122), wf8(:,143), A(:,519), n3(:,856), t3x128(:,:,519), nhel, den(429))
    call Hcont_QA(nsync, wf16(:,119), wf8(:,144), A(:,520), n3(:,857), t3x128(:,:,520), nhel, den(430))
    call Hcont_QA(nsync, wf16(:,119), wf8(:,145), A(:,521), n3(:,858), t3x128(:,:,521), nhel, den(431))
    call Hcont_QA(nsync, wf16(:,120), wf8(:,144), A(:,522), n3(:,859), t3x128(:,:,522), nhel, den(432))
    call Hcont_QA(nsync, wf16(:,120), wf8(:,145), A(:,523), n3(:,860), t3x128(:,:,523), nhel, den(433))
    call Hcont_SS(nsync, wf16(:,26), wf8(:,133), A(:,524), n3(:,861), t3x128(:,:,524), nhel, den(434))
    call Hcont_QA(nsync, wf16(:,129), wf8(:,146), A(:,525), n3(:,862), t3x128(:,:,525), nhel, den(435))
    call Hcont_QA(nsync, wf16(:,130), wf8(:,146), A(:,526), n3(:,863), t3x128(:,:,526), nhel, den(436))
    call Hcont_QA(nsync, wf16(:,129), wf8(:,147), A(:,527), n3(:,864), t3x128(:,:,527), nhel, den(437))
    call Hcont_QA(nsync, wf16(:,130), wf8(:,147), A(:,528), n3(:,865), t3x128(:,:,528), nhel, den(438))
    call Hcont_QA(nsync, wf16(:,127), wf8(:,148), A(:,529), n3(:,866), t3x128(:,:,529), nhel, den(439))
    call Hcont_QA(nsync, wf16(:,127), wf8(:,149), A(:,530), n3(:,867), t3x128(:,:,530), nhel, den(440))
    call Hcont_QA(nsync, wf16(:,128), wf8(:,148), A(:,531), n3(:,868), t3x128(:,:,531), nhel, den(441))
    call Hcont_QA(nsync, wf16(:,128), wf8(:,149), A(:,532), n3(:,869), t3x128(:,:,532), nhel, den(442))
    call Hcont_QA(nsync, wf8(:,42), wf16(:,167), A(:,533), n3(:,870), t3x128(:,:,533), nhel, den(444))
    call Hcont_QA(nsync, wf8(:,42), wf16(:,168), A(:,534), n3(:,871), t3x128(:,:,534), nhel, den(446))
    call Hcont_QA(nsync, wf8(:,44), wf16(:,167), A(:,535), n3(:,872), t3x128(:,:,535), nhel, den(447))
    call Hcont_QA(nsync, wf8(:,44), wf16(:,168), A(:,536), n3(:,873), t3x128(:,:,536), nhel, den(448))
    call Hcont_QA(nsync, wf8(:,46), wf16(:,169), A(:,537), n3(:,874), t3x128(:,:,537), nhel, den(450))
    call Hcont_QA(nsync, wf8(:,48), wf16(:,169), A(:,538), n3(:,875), t3x128(:,:,538), nhel, den(451))
    call Hcont_QA(nsync, wf8(:,46), wf16(:,170), A(:,539), n3(:,876), t3x128(:,:,539), nhel, den(453))
    call Hcont_QA(nsync, wf8(:,48), wf16(:,170), A(:,540), n3(:,877), t3x128(:,:,540), nhel, den(454))
    call Hcont_QA(nsync, wf8(:,146), wf16(:,172), A(:,541), n3(:,878), t3x128(:,:,541), nhel, den(456))
    call Hcont_QA(nsync, wf8(:,146), wf16(:,174), A(:,542), n3(:,879), t3x128(:,:,542), nhel, den(458))
    call Hcont_QA(nsync, wf8(:,147), wf16(:,172), A(:,543), n3(:,880), t3x128(:,:,543), nhel, den(459))
    call Hcont_QA(nsync, wf8(:,147), wf16(:,174), A(:,544), n3(:,881), t3x128(:,:,544), nhel, den(460))
    call Hcont_QA(nsync, wf8(:,148), wf16(:,176), A(:,545), n3(:,882), t3x128(:,:,545), nhel, den(462))
    call Hcont_QA(nsync, wf8(:,149), wf16(:,176), A(:,546), n3(:,883), t3x128(:,:,546), nhel, den(463))
    call Hcont_QA(nsync, wf8(:,148), wf16(:,178), A(:,547), n3(:,884), t3x128(:,:,547), nhel, den(465))
    call Hcont_QA(nsync, wf8(:,149), wf16(:,178), A(:,548), n3(:,885), t3x128(:,:,548), nhel, den(466))
    call Hcont_QA(nsync, wf8(:,144), wf16(:,179), A(:,549), n3(:,886), t3x128(:,:,549), nhel, den(468))
    call Hcont_QA(nsync, wf8(:,145), wf16(:,179), A(:,550), n3(:,887), t3x128(:,:,550), nhel, den(469))
    call Hcont_QA(nsync, wf8(:,144), wf16(:,180), A(:,551), n3(:,888), t3x128(:,:,551), nhel, den(471))
    call Hcont_QA(nsync, wf8(:,145), wf16(:,180), A(:,552), n3(:,889), t3x128(:,:,552), nhel, den(472))
    call Hcont_QA(nsync, wf8(:,142), wf16(:,181), A(:,553), n3(:,890), t3x128(:,:,553), nhel, den(474))
    call Hcont_QA(nsync, wf8(:,142), wf16(:,182), A(:,554), n3(:,891), t3x128(:,:,554), nhel, den(476))
    call Hcont_QA(nsync, wf8(:,143), wf16(:,181), A(:,555), n3(:,892), t3x128(:,:,555), nhel, den(477))
    call Hcont_QA(nsync, wf8(:,143), wf16(:,182), A(:,556), n3(:,893), t3x128(:,:,556), nhel, den(478))
    call Hcont_VV(nsync, wf16(:,35), wf8(:,138), A(:,557), n3(:,894), t3x128(:,:,557), nhel, den(480))
    call Hcont_VV(nsync, wf8(:,139), wf16(:,183), A(:,558), n3(:,895), t3x128(:,:,558), nhel, den(482))
    call Hcont_VV(nsync, wf16(:,37), wf8(:,138), A(:,559), n3(:,896), t3x128(:,:,559), nhel, den(484))
    call Hcont_VV(nsync, wf8(:,139), wf16(:,184), A(:,560), n3(:,897), t3x128(:,:,560), nhel, den(486))
    call Hcont_VV(nsync, wf16(:,39), wf8(:,138), A(:,561), n3(:,898), t3x128(:,:,561), nhel, den(488))
    call Hcont_VV(nsync, wf16(:,40), wf8(:,138), A(:,562), n3(:,899), t3x128(:,:,562), nhel, den(490))
    call Hcont_VV(nsync, wf8(:,139), wf16(:,185), A(:,563), n3(:,900), t3x128(:,:,563), nhel, den(492))
    call Hcont_VV(nsync, wf8(:,139), wf16(:,186), A(:,564), n3(:,901), t3x128(:,:,564), nhel, den(494))
    call Hcont_VV(nsync, wf16(:,35), wf8(:,140), A(:,565), n3(:,902), t3x128(:,:,565), nhel, den(495))
    call Hcont_VV(nsync, wf8(:,141), wf16(:,183), A(:,566), n3(:,903), t3x128(:,:,566), nhel, den(496))
    call Hcont_VV(nsync, wf16(:,37), wf8(:,140), A(:,567), n3(:,904), t3x128(:,:,567), nhel, den(497))
    call Hcont_VV(nsync, wf8(:,141), wf16(:,184), A(:,568), n3(:,905), t3x128(:,:,568), nhel, den(498))
    call Hcont_VV(nsync, wf16(:,39), wf8(:,140), A(:,569), n3(:,906), t3x128(:,:,569), nhel, den(499))
    call Hcont_VV(nsync, wf16(:,40), wf8(:,140), A(:,570), n3(:,907), t3x128(:,:,570), nhel, den(500))
    call Hcont_VV(nsync, wf8(:,141), wf16(:,185), A(:,571), n3(:,908), t3x128(:,:,571), nhel, den(501))
    call Hcont_VV(nsync, wf8(:,141), wf16(:,186), A(:,572), n3(:,909), t3x128(:,:,572), nhel, den(502))
    call Hcont_VV(nsync, wf16(:,43), wf8(:,138), A(:,573), n3(:,910), t3x128(:,:,573), nhel, den(504))
    call Hcont_VV(nsync, wf8(:,139), wf16(:,187), A(:,574), n3(:,911), t3x128(:,:,574), nhel, den(506))
    call Hcont_VV(nsync, wf16(:,45), wf8(:,138), A(:,575), n3(:,912), t3x128(:,:,575), nhel, den(508))
    call Hcont_VV(nsync, wf8(:,139), wf16(:,188), A(:,576), n3(:,913), t3x128(:,:,576), nhel, den(510))
    call Hcont_VV(nsync, wf16(:,47), wf8(:,138), A(:,577), n3(:,914), t3x128(:,:,577), nhel, den(512))
    call Hcont_VV(nsync, wf8(:,139), wf16(:,189), A(:,578), n3(:,915), t3x128(:,:,578), nhel, den(514))
    call Hcont_VV(nsync, wf16(:,49), wf8(:,138), A(:,579), n3(:,916), t3x128(:,:,579), nhel, den(516))
    call Hcont_VV(nsync, wf8(:,139), wf16(:,190), A(:,580), n3(:,917), t3x128(:,:,580), nhel, den(518))
    call Hcont_VV(nsync, wf16(:,43), wf8(:,140), A(:,581), n3(:,918), t3x128(:,:,581), nhel, den(519))
    call Hcont_VV(nsync, wf8(:,141), wf16(:,187), A(:,582), n3(:,919), t3x128(:,:,582), nhel, den(520))
    call Hcont_VV(nsync, wf16(:,45), wf8(:,140), A(:,583), n3(:,920), t3x128(:,:,583), nhel, den(521))
    call Hcont_VV(nsync, wf8(:,141), wf16(:,188), A(:,584), n3(:,921), t3x128(:,:,584), nhel, den(522))
    call Hcont_VV(nsync, wf16(:,47), wf8(:,140), A(:,585), n3(:,922), t3x128(:,:,585), nhel, den(523))
    call Hcont_VV(nsync, wf8(:,141), wf16(:,189), A(:,586), n3(:,923), t3x128(:,:,586), nhel, den(524))
    call Hcont_VV(nsync, wf16(:,49), wf8(:,140), A(:,587), n3(:,924), t3x128(:,:,587), nhel, den(525))
    call Hcont_VV(nsync, wf8(:,141), wf16(:,190), A(:,588), n3(:,925), t3x128(:,:,588), nhel, den(526))
    call Hcont_VV(nsync, wf16(:,51), wf8(:,138), A(:,589), n3(:,926), t3x128(:,:,589), nhel, den(528))
    call Hcont_VV(nsync, wf8(:,139), wf16(:,191), A(:,590), n3(:,927), t3x128(:,:,590), nhel, den(530))
    call Hcont_VV(nsync, wf16(:,53), wf8(:,138), A(:,591), n3(:,928), t3x128(:,:,591), nhel, den(532))
    call Hcont_VV(nsync, wf8(:,139), wf16(:,192), A(:,592), n3(:,929), t3x128(:,:,592), nhel, den(534))
    call Hcont_VV(nsync, wf16(:,55), wf8(:,138), A(:,593), n3(:,930), t3x128(:,:,593), nhel, den(536))
    call Hcont_VV(nsync, wf16(:,56), wf8(:,138), A(:,594), n3(:,931), t3x128(:,:,594), nhel, den(538))
    call Hcont_VV(nsync, wf8(:,139), wf16(:,193), A(:,595), n3(:,932), t3x128(:,:,595), nhel, den(540))
    call Hcont_VV(nsync, wf8(:,139), wf16(:,194), A(:,596), n3(:,933), t3x128(:,:,596), nhel, den(542))
    call Hcont_VV(nsync, wf16(:,51), wf8(:,140), A(:,597), n3(:,934), t3x128(:,:,597), nhel, den(543))
    call Hcont_VV(nsync, wf8(:,141), wf16(:,191), A(:,598), n3(:,935), t3x128(:,:,598), nhel, den(544))
    call Hcont_VV(nsync, wf16(:,53), wf8(:,140), A(:,599), n3(:,936), t3x128(:,:,599), nhel, den(545))
    call Hcont_VV(nsync, wf8(:,141), wf16(:,192), A(:,600), n3(:,937), t3x128(:,:,600), nhel, den(546))
    call Hcont_VV(nsync, wf16(:,55), wf8(:,140), A(:,601), n3(:,938), t3x128(:,:,601), nhel, den(547))
    call Hcont_VV(nsync, wf16(:,56), wf8(:,140), A(:,602), n3(:,939), t3x128(:,:,602), nhel, den(548))
    call Hcont_VV(nsync, wf8(:,141), wf16(:,193), A(:,603), n3(:,940), t3x128(:,:,603), nhel, den(549))
    call Hcont_VV(nsync, wf8(:,141), wf16(:,194), A(:,604), n3(:,941), t3x128(:,:,604), nhel, den(550))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(1), M2(1) ! M1helarray(1,128)
  integer :: empty(0), i

  M1(1)%j = (-A(j,1)%j-A(j,5)%j-A(j,10)%j-A(j,14)%j-A(j,19)%j-A(j,23)%j+A(j,43)%j+A(j,47)%j+A(j,52)%j+A(j,56)%j+A(j,61)%j &
       +A(j,65)%j)*f(1)+(-A(j,2)%j-A(j,3)%j-A(j,6)%j-A(j,7)%j-A(j,11)%j-A(j,12)%j-A(j,15)%j-A(j,16)%j-A(j,20)%j-A(j,21)%j &
       -A(j,24)%j-A(j,25)%j-A(j,27)%j-A(j,29)%j-A(j,31)%j-A(j,33)%j-A(j,35)%j-A(j,37)%j-A(j,39)%j-A(j,41)%j+A(j,44)%j+A(j,45)%j &
       +A(j,48)%j+A(j,49)%j+A(j,53)%j+A(j,54)%j+A(j,57)%j+A(j,58)%j+A(j,62)%j+A(j,63)%j+A(j,66)%j+A(j,67)%j+A(j,69)%j+A(j,71)%j &
       +A(j,73)%j+A(j,74)%j+A(j,77)%j+A(j,79)%j+A(j,81)%j+A(j,82)%j+A(j,85)%j+A(j,87)%j+A(j,89)%j+A(j,91)%j+A(j,93)%j+A(j,95)%j &
       +A(j,97)%j+A(j,99)%j-A(j,101)%j-A(j,103)%j-A(j,105)%j-A(j,106)%j-A(j,109)%j-A(j,111)%j-A(j,113)%j-A(j,114)%j)*f(2)+( &
       -A(j,4)%j-A(j,8)%j-A(j,13)%j-A(j,17)%j-A(j,22)%j-A(j,26)%j-A(j,28)%j-A(j,30)%j-A(j,32)%j-A(j,34)%j-A(j,36)%j-A(j,38)%j &
       -A(j,40)%j-A(j,42)%j+A(j,46)%j+A(j,50)%j+A(j,55)%j+A(j,59)%j+A(j,64)%j+A(j,68)%j+A(j,70)%j+A(j,72)%j+A(j,75)%j+A(j,76)%j &
       +A(j,78)%j+A(j,80)%j+A(j,83)%j+A(j,84)%j+A(j,86)%j+A(j,88)%j+A(j,90)%j+A(j,92)%j+A(j,94)%j+A(j,96)%j+A(j,98)%j+A(j,100)%j &
       -A(j,102)%j-A(j,104)%j-A(j,107)%j-A(j,108)%j-A(j,110)%j-A(j,112)%j-A(j,115)%j-A(j,116)%j)*f(3)+(A(j,9)%j+A(j,18)%j &
       -A(j,51)%j-A(j,60)%j)*f(33)

  M2(1)%j = (A(j,442)%j+A(j,446)%j+A(j,450)%j+A(j,454)%j+A(j,459)%j+A(j,463)%j+A(j,467)%j+A(j,471)%j+A(j,475)%j+A(j,479)%j &
       +A(j,483)%j+A(j,487)%j-A(j,508)%j-A(j,512)%j-A(j,516)%j-A(j,520)%j-A(j,525)%j-A(j,529)%j-A(j,533)%j-A(j,537)%j-A(j,541)%j &
       -A(j,545)%j-A(j,549)%j-A(j,553)%j)*f(4)+(A(j,443)%j+A(j,444)%j+A(j,447)%j+A(j,448)%j+A(j,451)%j+A(j,452)%j+A(j,455)%j &
       +A(j,456)%j+A(j,460)%j+A(j,461)%j+A(j,464)%j+A(j,465)%j+A(j,468)%j+A(j,469)%j+A(j,472)%j+A(j,473)%j+A(j,476)%j+A(j,477)%j &
       +A(j,480)%j+A(j,481)%j+A(j,484)%j+A(j,485)%j+A(j,488)%j+A(j,489)%j+A(j,491)%j+A(j,493)%j+A(j,495)%j+A(j,497)%j+A(j,499)%j &
       +A(j,501)%j+A(j,503)%j+A(j,505)%j-A(j,509)%j-A(j,510)%j-A(j,513)%j-A(j,514)%j-A(j,517)%j-A(j,518)%j-A(j,521)%j-A(j,522)%j &
       -A(j,526)%j-A(j,527)%j-A(j,530)%j-A(j,531)%j-A(j,534)%j-A(j,535)%j-A(j,538)%j-A(j,539)%j-A(j,542)%j-A(j,543)%j-A(j,546)%j &
       -A(j,547)%j-A(j,550)%j-A(j,551)%j-A(j,554)%j-A(j,555)%j-A(j,557)%j-A(j,559)%j-A(j,561)%j-A(j,562)%j-A(j,565)%j-A(j,567)%j &
       -A(j,569)%j-A(j,570)%j-A(j,573)%j-A(j,575)%j-A(j,577)%j-A(j,579)%j-A(j,581)%j-A(j,583)%j-A(j,585)%j-A(j,587)%j+A(j,589)%j &
       +A(j,591)%j+A(j,593)%j+A(j,594)%j+A(j,597)%j+A(j,599)%j+A(j,601)%j+A(j,602)%j)*f(5)+(A(j,445)%j+A(j,449)%j+A(j,453)%j &
       +A(j,457)%j+A(j,462)%j+A(j,466)%j+A(j,470)%j+A(j,474)%j+A(j,478)%j+A(j,482)%j+A(j,486)%j+A(j,490)%j+A(j,492)%j+A(j,494)%j &
       +A(j,496)%j+A(j,498)%j+A(j,500)%j+A(j,502)%j+A(j,504)%j+A(j,506)%j-A(j,511)%j-A(j,515)%j-A(j,519)%j-A(j,523)%j-A(j,528)%j &
       -A(j,532)%j-A(j,536)%j-A(j,540)%j-A(j,544)%j-A(j,548)%j-A(j,552)%j-A(j,556)%j-A(j,558)%j-A(j,560)%j-A(j,563)%j-A(j,564)%j &
       -A(j,566)%j-A(j,568)%j-A(j,571)%j-A(j,572)%j-A(j,574)%j-A(j,576)%j-A(j,578)%j-A(j,580)%j-A(j,582)%j-A(j,584)%j-A(j,586)%j &
       -A(j,588)%j+A(j,590)%j+A(j,592)%j+A(j,595)%j+A(j,596)%j+A(j,598)%j+A(j,600)%j+A(j,603)%j+A(j,604)%j)*f(6)+(-A(j,117)%j &
       +A(j,121)%j)*f(7)+(-A(j,118)%j-A(j,119)%j+A(j,122)%j+A(j,123)%j)*f(8)+(-A(j,143)%j-A(j,149)%j-A(j,176)%j-A(j,180)%j &
       -A(j,202)%j-A(j,206)%j+A(j,265)%j+A(j,271)%j+A(j,298)%j+A(j,302)%j+A(j,324)%j+A(j,328)%j)*f(9)+(-A(j,144)%j-A(j,145)%j &
       -A(j,150)%j-A(j,151)%j-A(j,177)%j-A(j,178)%j-A(j,181)%j-A(j,182)%j-A(j,203)%j-A(j,204)%j-A(j,207)%j-A(j,208)%j-A(j,223)%j &
       -A(j,225)%j-A(j,227)%j-A(j,229)%j-A(j,239)%j-A(j,241)%j-A(j,243)%j-A(j,245)%j+A(j,266)%j+A(j,267)%j+A(j,272)%j+A(j,273)%j &
       +A(j,299)%j+A(j,300)%j+A(j,303)%j+A(j,304)%j+A(j,325)%j+A(j,326)%j+A(j,329)%j+A(j,330)%j+A(j,345)%j+A(j,347)%j+A(j,349)%j &
       +A(j,350)%j+A(j,361)%j+A(j,363)%j+A(j,365)%j+A(j,366)%j+A(j,381)%j+A(j,383)%j+A(j,385)%j+A(j,387)%j+A(j,397)%j+A(j,399)%j &
       +A(j,401)%j+A(j,403)%j-A(j,417)%j-A(j,419)%j-A(j,421)%j-A(j,422)%j-A(j,433)%j-A(j,435)%j-A(j,437)%j-A(j,438)%j)*f(10)+( &
       -A(j,146)%j-A(j,152)%j-A(j,179)%j-A(j,183)%j-A(j,205)%j-A(j,209)%j-A(j,224)%j-A(j,226)%j-A(j,228)%j-A(j,230)%j-A(j,240)%j &
       -A(j,242)%j-A(j,244)%j-A(j,246)%j+A(j,268)%j+A(j,274)%j+A(j,301)%j+A(j,305)%j+A(j,327)%j+A(j,331)%j+A(j,346)%j+A(j,348)%j &
       +A(j,351)%j+A(j,352)%j+A(j,362)%j+A(j,364)%j+A(j,367)%j+A(j,368)%j+A(j,382)%j+A(j,384)%j+A(j,386)%j+A(j,388)%j+A(j,398)%j &
       +A(j,400)%j+A(j,402)%j+A(j,404)%j-A(j,418)%j-A(j,420)%j-A(j,423)%j-A(j,424)%j-A(j,434)%j-A(j,436)%j-A(j,439)%j &
       -A(j,440)%j)*f(11)+(-A(j,127)%j-A(j,131)%j-A(j,135)%j-A(j,139)%j-A(j,160)%j-A(j,164)%j-A(j,168)%j-A(j,172)%j-A(j,186)%j &
       -A(j,190)%j-A(j,194)%j-A(j,198)%j+A(j,249)%j+A(j,253)%j+A(j,257)%j+A(j,261)%j+A(j,282)%j+A(j,286)%j+A(j,290)%j+A(j,294)%j &
       +A(j,308)%j+A(j,312)%j+A(j,316)%j+A(j,320)%j)*f(12)+(-A(j,128)%j-A(j,129)%j-A(j,132)%j-A(j,133)%j-A(j,136)%j-A(j,137)%j &
       -A(j,140)%j-A(j,141)%j-A(j,161)%j-A(j,162)%j-A(j,165)%j-A(j,166)%j-A(j,169)%j-A(j,170)%j-A(j,173)%j-A(j,174)%j-A(j,187)%j &
       -A(j,188)%j-A(j,191)%j-A(j,192)%j-A(j,195)%j-A(j,196)%j-A(j,199)%j-A(j,200)%j-A(j,215)%j-A(j,217)%j-A(j,219)%j-A(j,221)%j &
       -A(j,231)%j-A(j,233)%j-A(j,235)%j-A(j,237)%j+A(j,250)%j+A(j,251)%j+A(j,254)%j+A(j,255)%j+A(j,258)%j+A(j,259)%j+A(j,262)%j &
       +A(j,263)%j+A(j,283)%j+A(j,284)%j+A(j,287)%j+A(j,288)%j+A(j,291)%j+A(j,292)%j+A(j,295)%j+A(j,296)%j+A(j,309)%j+A(j,310)%j &
       +A(j,313)%j+A(j,314)%j+A(j,317)%j+A(j,318)%j+A(j,321)%j+A(j,322)%j+A(j,337)%j+A(j,339)%j+A(j,341)%j+A(j,342)%j+A(j,353)%j &
       +A(j,355)%j+A(j,357)%j+A(j,358)%j+A(j,373)%j+A(j,375)%j+A(j,377)%j+A(j,379)%j+A(j,389)%j+A(j,391)%j+A(j,393)%j+A(j,395)%j &
       -A(j,409)%j-A(j,411)%j-A(j,413)%j-A(j,414)%j-A(j,425)%j-A(j,427)%j-A(j,429)%j-A(j,430)%j)*f(13)+(-A(j,130)%j-A(j,134)%j &
       -A(j,138)%j-A(j,142)%j-A(j,163)%j-A(j,167)%j-A(j,171)%j-A(j,175)%j-A(j,189)%j-A(j,193)%j-A(j,197)%j-A(j,201)%j-A(j,216)%j &
       -A(j,218)%j-A(j,220)%j-A(j,222)%j-A(j,232)%j-A(j,234)%j-A(j,236)%j-A(j,238)%j+A(j,252)%j+A(j,256)%j+A(j,260)%j+A(j,264)%j &
       +A(j,285)%j+A(j,289)%j+A(j,293)%j+A(j,297)%j+A(j,311)%j+A(j,315)%j+A(j,319)%j+A(j,323)%j+A(j,338)%j+A(j,340)%j+A(j,343)%j &
       +A(j,344)%j+A(j,354)%j+A(j,356)%j+A(j,359)%j+A(j,360)%j+A(j,374)%j+A(j,376)%j+A(j,378)%j+A(j,380)%j+A(j,390)%j+A(j,392)%j &
       +A(j,394)%j+A(j,396)%j-A(j,410)%j-A(j,412)%j-A(j,415)%j-A(j,416)%j-A(j,426)%j-A(j,428)%j-A(j,431)%j-A(j,432)%j)*f(14) &
       +(A(j,147)%j+A(j,153)%j+A(j,155)%j+A(j,157)%j-A(j,269)%j-A(j,275)%j-A(j,277)%j-A(j,279)%j)*f(15)+(A(j,148)%j+A(j,154)%j &
       +A(j,156)%j+A(j,158)%j+A(j,211)%j+A(j,212)%j+A(j,213)%j+A(j,214)%j-A(j,270)%j-A(j,276)%j-A(j,278)%j-A(j,280)%j-A(j,333)%j &
       -A(j,334)%j-A(j,335)%j-A(j,336)%j-A(j,369)%j-A(j,370)%j-A(j,371)%j-A(j,372)%j+A(j,405)%j+A(j,406)%j+A(j,407)%j &
       +A(j,408)%j)*f(16)+(-A(j,120)%j+A(j,124)%j)*f(17)+(-A(j,441)%j-A(j,458)%j+A(j,507)%j+A(j,524)%j)*f(34)+(A(j,184)%j &
       +A(j,210)%j-A(j,306)%j-A(j,332)%j)*f(35)+(A(j,159)%j+A(j,185)%j-A(j,281)%j-A(j,307)%j)*f(36)+(A(j,126)%j-A(j,248)%j)*f(37) &
       +(A(j,125)%j-A(j,247)%j)*f(41)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)  

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppllllj_eeexexbbxg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 1
      do j = 1, 1
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppllllj_eeexexbbxg_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M(1), Mct(1)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer ::  i, j

  M2colint_ct = 0

    do i = 1, 1
      do j = 1, 1
        M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i,j)*Mct(j))
      end do
    end do


end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppllllj_eeexexbbxg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2IRadd(29)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 30-1
    colmatpos = 1*k
    do i = 1, 1
      do j = 1, 1
	M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do
  
end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppllllj_eeexexbbxg_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppllllj_eeexexbbxg_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(1)
  type(Hpolcont), intent(out)  :: M0_col(1)
  integer :: i, j


  do j = 1, 1 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 1 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i,j)
    end do    
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppllllj_eeexexbbxg_1_/**/REALKIND
