
module ol_colourmatrix_ppllllj2_onlyh_nenenexnexggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(0,0), K2(0,2), KL(0,2), KL2(60,2), KL2ct(60,2), KL2ct2(60,2)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  KL2( 1,:) = [  14,  -4]
  KL2( 2,:) = [  -4,  14]
  KL2( 3,:) = [   0,   0]
  KL2( 4,:) = [   0,   0]
  KL2( 5,:) = [   0,   0]
  KL2( 6,:) = [   0,   0]
  KL2( 7,:) = [   0,   0]
  KL2( 8,:) = [   0,   0]
  KL2( 9,:) = [   0,   0]
  KL2(10,:) = [   0,   0]
  KL2(11,:) = [   0,   0]
  KL2(12,:) = [   0,   0]
  KL2(13,:) = [   0,   0]
  KL2(14,:) = [   0,   0]
  KL2(15,:) = [   0,   0]
  KL2(16,:) = [   0,   0]
  KL2(17,:) = [   0,   0]
  KL2(18,:) = [   0,   0]
  KL2(19,:) = [   0,   0]
  KL2(20,:) = [   0,   0]
  KL2(21,:) = [   0,   0]
  KL2(22,:) = [   0,   0]
  KL2(23,:) = [   0,   0]
  KL2(24,:) = [   0,   0]
  KL2(25,:) = [   0,   0]
  KL2(26,:) = [   0,   0]
  KL2(27,:) = [   0,   0]
  KL2(28,:) = [   0,   0]
  KL2(29,:) = [   0,   0]
  KL2(30,:) = [   0,   0]
  KL2(31,:) = [  42, -12]
  KL2(32,:) = [ -12,  42]
  KL2(33,:) = [   0,   0]
  KL2(34,:) = [   0,   0]
  KL2(35,:) = [   0,   0]
  KL2(36,:) = [   0,   0]
  KL2(37,:) = [   0,   0]
  KL2(38,:) = [   0,   0]
  KL2(39,:) = [   0,   0]
  KL2(40,:) = [   0,   0]
  KL2(41,:) = [ -21,   6]
  KL2(42,:) = [   6, -21]
  KL2(43,:) = [  42, -12]
  KL2(44,:) = [ -12,  42]
  KL2(45,:) = [   0,   0]
  KL2(46,:) = [   0,   0]
  KL2(47,:) = [   0,   0]
  KL2(48,:) = [   0,   0]
  KL2(49,:) = [   0,   0]
  KL2(50,:) = [   0,   0]
  KL2(51,:) = [   0,   0]
  KL2(52,:) = [   0,   0]
  KL2(53,:) = [ -21,   6]
  KL2(54,:) = [   6, -21]
  KL2(55,:) = [ -21,   6]
  KL2(56,:) = [   6, -21]
  KL2(57,:) = [  42, -12]
  KL2(58,:) = [ -12,  42]
  KL2(59,:) = [   0,   0]
  KL2(60,:) = [   0,   0]
  KL2 = (1._/**/REALKIND / 6) * KL2

  KL2ct( 1,:) = [  14,  -4]
  KL2ct( 2,:) = [  -4,  14]
  KL2ct( 3,:) = [   0,   0]
  KL2ct( 4,:) = [   0,   0]
  KL2ct( 5,:) = [   0,   0]
  KL2ct( 6,:) = [   0,   0]
  KL2ct( 7,:) = [   0,   0]
  KL2ct( 8,:) = [   0,   0]
  KL2ct( 9,:) = [   0,   0]
  KL2ct(10,:) = [   0,   0]
  KL2ct(11,:) = [   0,   0]
  KL2ct(12,:) = [   0,   0]
  KL2ct(13,:) = [   0,   0]
  KL2ct(14,:) = [   0,   0]
  KL2ct(15,:) = [   0,   0]
  KL2ct(16,:) = [   0,   0]
  KL2ct(17,:) = [   0,   0]
  KL2ct(18,:) = [   0,   0]
  KL2ct(19,:) = [   0,   0]
  KL2ct(20,:) = [   0,   0]
  KL2ct(21,:) = [   0,   0]
  KL2ct(22,:) = [   0,   0]
  KL2ct(23,:) = [   0,   0]
  KL2ct(24,:) = [   0,   0]
  KL2ct(25,:) = [   0,   0]
  KL2ct(26,:) = [   0,   0]
  KL2ct(27,:) = [   0,   0]
  KL2ct(28,:) = [   0,   0]
  KL2ct(29,:) = [   0,   0]
  KL2ct(30,:) = [   0,   0]
  KL2ct(31,:) = [  42, -12]
  KL2ct(32,:) = [ -12,  42]
  KL2ct(33,:) = [   0,   0]
  KL2ct(34,:) = [   0,   0]
  KL2ct(35,:) = [   0,   0]
  KL2ct(36,:) = [   0,   0]
  KL2ct(37,:) = [   0,   0]
  KL2ct(38,:) = [   0,   0]
  KL2ct(39,:) = [   0,   0]
  KL2ct(40,:) = [   0,   0]
  KL2ct(41,:) = [ -21,   6]
  KL2ct(42,:) = [   6, -21]
  KL2ct(43,:) = [  42, -12]
  KL2ct(44,:) = [ -12,  42]
  KL2ct(45,:) = [   0,   0]
  KL2ct(46,:) = [   0,   0]
  KL2ct(47,:) = [   0,   0]
  KL2ct(48,:) = [   0,   0]
  KL2ct(49,:) = [   0,   0]
  KL2ct(50,:) = [   0,   0]
  KL2ct(51,:) = [   0,   0]
  KL2ct(52,:) = [   0,   0]
  KL2ct(53,:) = [ -21,   6]
  KL2ct(54,:) = [   6, -21]
  KL2ct(55,:) = [ -21,   6]
  KL2ct(56,:) = [   6, -21]
  KL2ct(57,:) = [  42, -12]
  KL2ct(58,:) = [ -12,  42]
  KL2ct(59,:) = [   0,   0]
  KL2ct(60,:) = [   0,   0]
  KL2ct = (1._/**/REALKIND / 6) * KL2ct

  KL2ct2( 1,:) = [  14,  -4]
  KL2ct2( 2,:) = [  -4,  14]
  KL2ct2( 3,:) = [   0,   0]
  KL2ct2( 4,:) = [   0,   0]
  KL2ct2( 5,:) = [   0,   0]
  KL2ct2( 6,:) = [   0,   0]
  KL2ct2( 7,:) = [   0,   0]
  KL2ct2( 8,:) = [   0,   0]
  KL2ct2( 9,:) = [   0,   0]
  KL2ct2(10,:) = [   0,   0]
  KL2ct2(11,:) = [   0,   0]
  KL2ct2(12,:) = [   0,   0]
  KL2ct2(13,:) = [   0,   0]
  KL2ct2(14,:) = [   0,   0]
  KL2ct2(15,:) = [   0,   0]
  KL2ct2(16,:) = [   0,   0]
  KL2ct2(17,:) = [   0,   0]
  KL2ct2(18,:) = [   0,   0]
  KL2ct2(19,:) = [   0,   0]
  KL2ct2(20,:) = [   0,   0]
  KL2ct2(21,:) = [   0,   0]
  KL2ct2(22,:) = [   0,   0]
  KL2ct2(23,:) = [   0,   0]
  KL2ct2(24,:) = [   0,   0]
  KL2ct2(25,:) = [   0,   0]
  KL2ct2(26,:) = [   0,   0]
  KL2ct2(27,:) = [   0,   0]
  KL2ct2(28,:) = [   0,   0]
  KL2ct2(29,:) = [   0,   0]
  KL2ct2(30,:) = [   0,   0]
  KL2ct2(31,:) = [  42, -12]
  KL2ct2(32,:) = [ -12,  42]
  KL2ct2(33,:) = [   0,   0]
  KL2ct2(34,:) = [   0,   0]
  KL2ct2(35,:) = [   0,   0]
  KL2ct2(36,:) = [   0,   0]
  KL2ct2(37,:) = [   0,   0]
  KL2ct2(38,:) = [   0,   0]
  KL2ct2(39,:) = [   0,   0]
  KL2ct2(40,:) = [   0,   0]
  KL2ct2(41,:) = [ -21,   6]
  KL2ct2(42,:) = [   6, -21]
  KL2ct2(43,:) = [  42, -12]
  KL2ct2(44,:) = [ -12,  42]
  KL2ct2(45,:) = [   0,   0]
  KL2ct2(46,:) = [   0,   0]
  KL2ct2(47,:) = [   0,   0]
  KL2ct2(48,:) = [   0,   0]
  KL2ct2(49,:) = [   0,   0]
  KL2ct2(50,:) = [   0,   0]
  KL2ct2(51,:) = [   0,   0]
  KL2ct2(52,:) = [   0,   0]
  KL2ct2(53,:) = [ -21,   6]
  KL2ct2(54,:) = [   6, -21]
  KL2ct2(55,:) = [ -21,   6]
  KL2ct2(56,:) = [   6, -21]
  KL2ct2(57,:) = [  42, -12]
  KL2ct2(58,:) = [ -12,  42]
  KL2ct2(59,:) = [   0,   0]
  KL2ct2(60,:) = [   0,   0]
  KL2ct2 = (1._/**/REALKIND / 6) * KL2ct2

  end subroutine colourmatrix_init
end module ol_colourmatrix_ppllllj2_onlyh_nenenexnexggg_1_/**/REALKIND



module ol_forced_parameters_ppllllj2_onlyh_nenenexnexggg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (YE /= 0) write(*,101) 'YE = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (YU /= 0) write(*,101) 'YU = 0'
  if (YD /= 0) write(*,101) 'YD = 0'
  if (YS /= 0) write(*,101) 'YS = 0'
  if (YC /= 0) write(*,101) 'YC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppllllj2_onlyh_nenenexnexggg_1_/**/REALKIND

module ol_loop_ppllllj2_onlyh_nenenexnexggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(6), c(0)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-7+1:16)
  ! denominators
  complex(REALKIND), save :: den(18)
  ! Born, CT and Loop colour vector for each helicity configuration
  complex(REALKIND), save :: M0(0,128), Mct(2,128), Mcol_loop(2,128)
  ! zero helicity identifier
  logical,           save :: zerohel(128) = .true., zerohel_ct(128) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_decl_/**/DREALKIND, only: do_ew_renorm
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_loop_init
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  call ensure_mp_loop_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(1) = (countertermnorm*ctHGG*eQED**4*gQCD**3*lambdaHZZ*MB*MW*YB)/(cw**2*MQ2sum*sw)
    f(2) = (CI*eQED**4*gQCD**3*integralnorm*lambdaHZZ*SwF*YB)/(2._/**/REALKIND*cw**2*sw**2)
    f(3) = (eQED**4*gQCD**3*integralnorm*lambdaHZZ*SwF*YB)/(cw**2*sw**2*2._/**/REALKIND)
    f(4) = (countertermnorm*ctHGG*eQED**4*gQCD**3*lambdaHZZ*MT*MW*YT)/(cw**2*MQ2sum*sw)
    f(5) = (CI*eQED**4*gQCD**3*integralnorm*lambdaHZZ*SwF*YT)/(2._/**/REALKIND*cw**2*sw**2)
    f(6) = (eQED**4*gQCD**3*integralnorm*lambdaHZZ*SwF*YT)/(cw**2*sw**2*2._/**/REALKIND)


end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2, POLSEL)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none
  real(REALKIND),    intent(in)  :: P(0:3,7)
  integer,           intent(in)  :: H(7)
  integer,           intent(in), optional  :: POLSEL(7)
  complex(REALKIND), intent(out) :: M1(0), M2(2)
  complex(REALKIND) :: A(12)
  ! external WFs
  if (present(POLSEL)) then
    call pol_wf_Q(P(:,1), rZERO, H(1), wf(:,0), POLSEL(1))
    call pol_wf_Q(P(:,2), rZERO, H(2), wf(:,-1), POLSEL(2))
    call pol_wf_A(P(:,3), rZERO, H(3), wf(:,-2), POLSEL(3))
    call pol_wf_A(P(:,4), rZERO, H(4), wf(:,-3), POLSEL(4))
    call pol_wf_V(P(:,5), rZERO, H(5), wf(:,-4), POLSEL(5))
    call pol_wf_V(P(:,6), rZERO, H(6), wf(:,-5), POLSEL(6))
    call pol_wf_V(P(:,7), rZERO, H(7), wf(:,-6), POLSEL(7))

  else
    call pol_wf_Q(P(:,1), rZERO, H(1), wf(:,0), 0)
    call pol_wf_Q(P(:,2), rZERO, H(2), wf(:,-1), 0)
    call pol_wf_A(P(:,3), rZERO, H(3), wf(:,-2), 0)
    call pol_wf_A(P(:,4), rZERO, H(4), wf(:,-3), 0)
    call pol_wf_V(P(:,5), rZERO, H(5), wf(:,-4), 0)
    call pol_wf_V(P(:,6), rZERO, H(6), wf(:,-5), 0)
    call pol_wf_V(P(:,7), rZERO, H(7), wf(:,-6), 0)

  end if

  ! internal WFs
  call vert_QA_Z(gZn,wf(:,0),wf(:,-2),wf(:,1))
  call vert_QA_Z(gZn,wf(:,-1),wf(:,-3),wf(:,2))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,-5),Q(:,32),wf(:,3))
  call prop_W_W(wf(:,1),Q(:,5),MZ,1_intkind1,wf(:,4))
  call prop_W_W(wf(:,2),Q(:,10),MZ,1_intkind1,wf(:,5))
  call vert_VV_S(wf(:,4),wf(:,5),wf(:,6))
  call counter_GG_S(wf(:,3),wf(:,-6),wf(:,7))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,-6),Q(:,64),wf(:,8))
  call counter_GG_S(wf(:,-5),wf(:,8),wf(:,9))
  call vert_UV_W(wf(:,-5),Q(:,32),wf(:,-6),Q(:,64),wf(:,10))
  call counter_GG_S(wf(:,-4),wf(:,10),wf(:,11))
  call vert_QA_Z(gZn,wf(:,0),wf(:,-3),wf(:,12))
  call vert_QA_Z(gZn,wf(:,-1),wf(:,-2),wf(:,13))
  call prop_W_W(wf(:,12),Q(:,9),MZ,1_intkind1,wf(:,14))
  call prop_W_W(wf(:,13),Q(:,6),MZ,1_intkind1,wf(:,15))
  call vert_VV_S(wf(:,15),wf(:,14),wf(:,16))

  call denominators()
  call diagrams(A)
  call colourvectors(A, M1, M2)
end subroutine tree_wavefunctions


subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none
  ! propagators
  den(1) = 1 / (Q(5,5) - MZ2)
  den(2) = 1 / (Q(5,10) - MZ2)
  den(3) = 1 / (Q(5,48))
  den(5) = 1 / (Q(5,15) - MH2)
  den(8) = 1 / (Q(5,80))
  den(10) = 1 / (Q(5,96))
  den(12) = 1 / (Q(5,9) - MZ2)
  den(13) = 1 / (Q(5,6) - MZ2)

  ! denominators
  den(4) = den(1)*den(2)
  den(6) = den(4)*den(5)
  den(7) = den(3)*den(6)
  den(9) = den(6)*den(8)
  den(11) = den(6)*den(10)
  den(14) = den(12)*den(13)
  den(15) = den(5)*den(14)
  den(16) = den(3)*den(15)
  den(17) = den(8)*den(15)
  den(18) = den(10)*den(15)

end subroutine denominators


subroutine diagrams(A)
  ! colour stripped tree amplitudes
  use ol_contractions_/**/REALKIND
  implicit none
  complex(REALKIND), intent(out) :: A(12)


  A(1) = cont_SS(wf(:,6),wf(:,7)) * den(7)
  A(2) = cont_SS(wf(:,6),wf(:,7)) * den(7)
  A(3) = cont_SS(wf(:,6),wf(:,9)) * den(9)
  A(4) = cont_SS(wf(:,6),wf(:,9)) * den(9)
  A(5) = cont_SS(wf(:,6),wf(:,11)) * den(11)
  A(6) = cont_SS(wf(:,6),wf(:,11)) * den(11)
  A(7) = cont_SS(wf(:,7),wf(:,16)) * den(16)
  A(8) = cont_SS(wf(:,7),wf(:,16)) * den(16)
  A(9) = cont_SS(wf(:,9),wf(:,16)) * den(17)
  A(10) = cont_SS(wf(:,9),wf(:,16)) * den(17)
  A(11) = cont_SS(wf(:,11),wf(:,16)) * den(18)
  A(12) = cont_SS(wf(:,11),wf(:,16)) * den(18)

end subroutine diagrams


subroutine colourvectors(A, M1, M2)
  ! Born and counterterm colour vectors
  use ol_parameters_decl_/**/REALKIND, only: CI
  implicit none
  complex(REALKIND), intent(in) :: A(12)
  complex(REALKIND), intent(out) :: M1(0), M2(2)


  M2(1) = 2*CI*(A(2)-A(4)+A(6)-A(8)+A(10)-A(12))*f(1)+2*CI*(A(1)-A(3)+A(5)-A(7)+A(9)-A(11))*f(4)
  M2(2) = 2*CI*(-A(2)+A(4)-A(6)+A(8)-A(10)+A(12))*f(1)+2*CI*(-A(1)+A(3)-A(5)+A(7)-A(9)+A(11))*f(4)

end subroutine colourvectors

end module ol_loop_ppllllj2_onlyh_nenenexnexggg_1_/**/REALKIND
