
module ol_vamp_2_pplllla_nenexeexbbxa_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_2(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pplllla_nenexeexbbxa_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pplllla_nenexeexbbxa_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pplllla_nenexeexbbxa_1_/**/DREALKIND
  use ol_tensor_sum_storage_pplllla_nenexeexbbxa_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red

  use ol_loop_storage_pplllla_nenexeexbbxa_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pplllla_nenexeexbbxa_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(276)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(283),h0tab(:,283),[108,19],[nMB,0],2,2,wf16(:,148),wf8(:,9))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,148),G0H8(1),m3h16x8(:,44),heltab2x128(:,:,283))
  call Hloop_A_Q(ntryL,G0H8(1),108,nMB,G1H8(54),n2h8(72))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(284)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(284),h0tab(:,284),[92,35],[nMB,0],2,2,wf16(:,152),wf8(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,152),G0H8(1),m3h16x8(:,45),heltab2x128(:,:,284))
  call Hloop_Q_A(ntryL,G0H8(1),92,nMB,G1H8(53),n2h8(73))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(286)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(285),h0tab(:,285),[92,35],[nMB,0],2,2,wf16(:,153),wf8(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,153),G0H8(1),m3h16x8(:,46),heltab2x128(:,:,285))
  call Hloop_Q_A(ntryL,G0H8(1),92,nMB,G1H8(50),n2h8(74))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(278)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(286),h0tab(:,286),[99,28],[nMB,0],2,2,wf16(:,150),wf8(:,11))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,150),G0H8(1),m3h16x8(:,47),heltab2x128(:,:,286))
  call Hloop_A_Q(ntryL,G0H8(1),99,nMB,G1H8(38),n2h8(75))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(279)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(287),h0tab(:,287),[99,28],[nMB,0],2,2,wf16(:,150),wf8(:,13))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,150),G0H8(1),m3h16x8(:,48),heltab2x128(:,:,287))
  call Hloop_A_Q(ntryL,G0H8(1),99,nMB,G1H8(44),n2h8(76))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(288)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(288),h0tab(:,288),[108,19],[nMB,0],2,2,wf16(:,154),wf8(:,9))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,154),G0H8(1),m3h16x8(:,49),heltab2x128(:,:,288))
  call Hloop_A_Q(ntryL,G0H8(1),108,nMB,G1H8(19),n2h8(77))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(290)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(289),h0tab(:,289),[108,19],[nMB,0],2,2,wf16(:,155),wf8(:,9))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,155),G0H8(1),m3h16x8(:,50),heltab2x128(:,:,289))
  call Hloop_A_Q(ntryL,G0H8(1),108,nMB,G1H8(20),n2h8(78))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(292)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(290),h0tab(:,290),[92,35],[0,nMB],2,2,wf16(:,156),wf8(:,2))
  call Hloop_AQ_V(ntryL,G0H128(1),wf16(:,156),G0H8(1),m3h16x8(:,51),heltab2x128(:,:,290))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(294)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(291),h0tab(:,291),[92,35],[0,nMB],2,2,wf16(:,157),wf8(:,2))
  call Hloop_AQ_V(ntryL,G0H128(1),wf16(:,157),G0H8(2),m3h16x8(:,52),heltab2x128(:,:,291))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(296)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(292),h0tab(:,292),[108,19],[nMB,0],2,2,wf16(:,158),wf8(:,9))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,158),G0H8(3),m3h16x8(:,53),heltab2x128(:,:,292))
  call Hloop_A_Q(ntryL,G0H8(3),108,nMB,G1H8(48),n2h8(79))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(298)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(293),h0tab(:,293),[108,19],[nMB,0],2,2,wf16(:,159),wf8(:,9))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,159),G0H8(3),m3h16x8(:,54),heltab2x128(:,:,293))
  call Hloop_A_Q(ntryL,G0H8(3),108,nMB,G1H8(21),n2h8(80))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(300)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(294),h0tab(:,294),[92,35],[0,nMB],2,2,wf16(:,160),wf8(:,2))
  call Hloop_AQ_V(ntryL,G0H128(1),wf16(:,160),G0H8(3),m3h16x8(:,55),heltab2x128(:,:,294))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(295),h0tab(:,295),[92,35],[0,nMB],2,2,wf16(:,161),wf8(:,2))
  call Hloop_AQ_V(ntryL,G0H128(1),wf16(:,161),G0H8(4),m3h16x8(:,56),heltab2x128(:,:,295))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(582)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(296),h0tab(:,296),[80,47],[0,nMB],2,2,wf4(:,12),wf32(:,42))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,12),G0H32(10),m3h4x32(:,63),heltab2x128(:,:,296))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(583)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(297),h0tab(:,297),[80,47],[0,nMB],2,2,wf4(:,12),wf32(:,44))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,12),G0H32(11),m3h4x32(:,64),heltab2x128(:,:,297))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(584)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(298),h0tab(:,298),[80,47],[0,nMB],2,2,wf4(:,12),wf32(:,53))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,12),G0H32(12),m3h4x32(:,65),heltab2x128(:,:,298))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(585)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(299),h0tab(:,299),[80,47],[0,nMB],2,2,wf4(:,12),wf32(:,55))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,12),G0H32(13),m3h4x32(:,66),heltab2x128(:,:,299))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(586)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(300),h0tab(:,300),[96,31],[nMB,0],2,2,wf4(:,16),wf32(:,38))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(14),m3h4x32(:,67),heltab2x128(:,:,300))
  call Hloop_A_Q(ntryL,G0H32(14),96,nMB,G1H32(23),n2h32(54))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(587)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(301),h0tab(:,301),[96,31],[nMB,0],2,2,wf4(:,16),wf32(:,40))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(14),m3h4x32(:,68),heltab2x128(:,:,301))
  call Hloop_A_Q(ntryL,G0H32(14),96,nMB,G1H32(24),n2h32(55))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(588)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(302),h0tab(:,302),[96,31],[nMB,0],2,2,wf4(:,16),wf32(:,49))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(14),m3h4x32(:,69),heltab2x128(:,:,302))
  call Hloop_A_Q(ntryL,G0H32(14),96,nMB,G1H32(25),n2h32(56))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(589)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(303),h0tab(:,303),[96,31],[nMB,0],2,2,wf4(:,16),wf32(:,51))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(14),m3h4x32(:,70),heltab2x128(:,:,303))
  call Hloop_A_Q(ntryL,G0H32(14),96,nMB,G1H32(26),n2h32(57))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(320)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(304),h0tab(:,304),[89,38],[nMT,0],2,2,wf16(:,114),wf8(:,44))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,114),G0H8(5),m3h16x8(:,57),heltab2x128(:,:,304))
  call Hloop_Q_A(ntryL,G0H8(5),89,nMT,G1H8(25),n2h8(81))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(590)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(305),h0tab(:,305),[80,47],[0,nMB],2,2,wf4(:,12),wf32(:,65))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,12),G0H32(14),m3h4x32(:,71),heltab2x128(:,:,305))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(591)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(306),h0tab(:,306),[80,47],[0,nMB],2,2,wf4(:,12),wf32(:,76))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,12),G0H32(15),m3h4x32(:,72),heltab2x128(:,:,306))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(592)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(307),h0tab(:,307),[80,47],[0,nMB],2,2,wf4(:,12),wf32(:,78))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,12),G0H32(16),m3h4x32(:,73),heltab2x128(:,:,307))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(593)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(308),h0tab(:,308),[80,47],[0,nMB],2,2,wf4(:,12),wf32(:,80))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,12),G0H32(17),m3h4x32(:,74),heltab2x128(:,:,308))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(594)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(309),h0tab(:,309),[96,31],[0,nMB],2,2,wf4(:,16),wf32(:,60))
  call Hloop_QA_V(ntryL,G0H128(1),wf4(:,16),G0H32(18),m3h4x32(:,75),heltab2x128(:,:,309))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(324)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(310),h0tab(:,310),[102,25],[nMT,0],2,2,wf16(:,118),wf8(:,46))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,118),G0H8(5),m3h16x8(:,58),heltab2x128(:,:,310))
  call Hloop_A_Q(ntryL,G0H8(5),102,nMT,G1H8(55),n2h8(82))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(595)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(311),h0tab(:,311),[96,31],[nMB,0],2,2,wf4(:,16),wf32(:,70))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(19),m3h4x32(:,76),heltab2x128(:,:,311))
  call Hloop_A_Q(ntryL,G0H32(19),96,nMB,G1H32(27),n2h32(58))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(596)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(312),h0tab(:,312),[96,31],[nMB,0],2,2,wf4(:,16),wf32(:,72))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(19),m3h4x32(:,77),heltab2x128(:,:,312))
  call Hloop_A_Q(ntryL,G0H32(19),96,nMB,G1H32(28),n2h32(59))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(597)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(313),h0tab(:,313),[96,31],[nMB,0],2,2,wf4(:,16),wf32(:,74))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(19),m3h4x32(:,78),heltab2x128(:,:,313))
  call Hloop_A_Q(ntryL,G0H32(19),96,nMB,G1H32(29),n2h32(60))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(334)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(314),h0tab(:,314),[89,38],[nMT,0],2,2,wf16(:,172),wf8(:,44))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,172),G0H8(5),m3h16x8(:,59),heltab2x128(:,:,314))
  call Hloop_Q_A(ntryL,G0H8(5),89,nMT,G1H8(56),n2h8(83))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(332)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(315),h0tab(:,315),[102,25],[nMT,0],2,2,wf16(:,171),wf8(:,46))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,171),G0H8(5),m3h16x8(:,60),heltab2x128(:,:,315))
  call Hloop_A_Q(ntryL,G0H8(5),102,nMT,G1H8(43),n2h8(84))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(328)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(316),h0tab(:,316),[102,25],[nMT,0],2,2,wf16(:,167),wf8(:,46))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,167),G0H8(5),m3h16x8(:,61),heltab2x128(:,:,316))
  call Hloop_A_Q(ntryL,G0H8(5),102,nMT,G1H8(37),n2h8(85))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(330)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(317),h0tab(:,317),[89,38],[0,nMT],2,2,wf16(:,169),wf8(:,44))
  call Hloop_AQ_V(ntryL,G0H128(1),wf16(:,169),G0H8(5),m3h16x8(:,62),heltab2x128(:,:,317))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(336)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(318),h0tab(:,318),[89,38],[0,nMT],2,2,wf16(:,173),wf8(:,44))
  call Hloop_AQ_V(ntryL,G0H128(1),wf16(:,173),G0H8(6),m3h16x8(:,63),heltab2x128(:,:,318))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(598)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(319),h0tab(:,319),[80,47],[0,nMB],2,2,wf4(:,12),wf32(:,94))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,12),G0H32(19),m3h4x32(:,79),heltab2x128(:,:,319))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(599)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(320),h0tab(:,320),[80,47],[0,nMB],2,2,wf4(:,12),wf32(:,96))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,12),G0H32(20),m3h4x32(:,80),heltab2x128(:,:,320))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(600)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(321),h0tab(:,321),[80,47],[0,nMB],2,2,wf4(:,12),wf32(:,103))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,12),G0H32(21),m3h4x32(:,81),heltab2x128(:,:,321))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(601)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(322),h0tab(:,322),[96,31],[nMB,0],2,2,wf4(:,16),wf32(:,90))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(22),m3h4x32(:,82),heltab2x128(:,:,322))
  call Hloop_A_Q(ntryL,G0H32(22),96,nMB,G1H32(30),n2h32(61))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(602)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(323),h0tab(:,323),[96,31],[nMB,0],2,2,wf4(:,16),wf32(:,92))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(22),m3h4x32(:,83),heltab2x128(:,:,323))
  call Hloop_A_Q(ntryL,G0H32(22),96,nMB,G1H32(31),n2h32(62))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(603)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(324),h0tab(:,324),[96,31],[nMB,0],2,2,wf4(:,16),wf32(:,101))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(22),m3h4x32(:,84),heltab2x128(:,:,324))
  call Hloop_A_Q(ntryL,G0H32(22),96,nMB,G1H32(32),n2h32(63))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(347)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(325),h0tab(:,325),[102,25],[nMT,0],2,2,wf16(:,176),wf8(:,46))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,176),G0H8(7),m3h16x8(:,64),heltab2x128(:,:,325))
  call Hloop_A_Q(ntryL,G0H8(7),102,nMT,G1H8(34),n2h8(86))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(604)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(326),h0tab(:,326),[80,47],[0,nMB],2,2,wf4(:,12),wf32(:,122))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,12),G0H32(22),m3h4x32(:,85),heltab2x128(:,:,326))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(605)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(327),h0tab(:,327),[80,47],[0,nMB],2,2,wf4(:,12),wf32(:,124))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,12),G0H32(23),m3h4x32(:,86),heltab2x128(:,:,327))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(606)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(328),h0tab(:,328),[80,47],[0,nMB],2,2,wf4(:,12),wf32(:,131))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,12),G0H32(24),m3h4x32(:,87),heltab2x128(:,:,328))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(607)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(329),h0tab(:,329),[96,31],[nMB,0],2,2,wf4(:,16),wf32(:,118))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(25),m3h4x32(:,88),heltab2x128(:,:,329))
  call Hloop_A_Q(ntryL,G0H32(25),96,nMB,G1H32(33),n2h32(64))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(608)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(330),h0tab(:,330),[96,31],[nMB,0],2,2,wf4(:,16),wf32(:,120))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(25),m3h4x32(:,89),heltab2x128(:,:,330))
  call Hloop_A_Q(ntryL,G0H32(25),96,nMB,G1H32(34),n2h32(65))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(609)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(331),h0tab(:,331),[96,31],[nMB,0],2,2,wf4(:,16),wf32(:,129))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(25),m3h4x32(:,90),heltab2x128(:,:,331))
  call Hloop_A_Q(ntryL,G0H32(25),96,nMB,G1H32(35),n2h32(66))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(610)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(332),h0tab(:,332),[80,47],[0,nMB],2,2,wf4(:,12),wf32(:,140))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,12),G0H32(25),m3h4x32(:,91),heltab2x128(:,:,332))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(611)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(333),h0tab(:,333),[80,47],[0,nMB],2,2,wf4(:,12),wf32(:,144))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,12),G0H32(26),m3h4x32(:,92),heltab2x128(:,:,333))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(612)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(334),h0tab(:,334),[96,31],[nMB,0],2,2,wf4(:,16),wf32(:,138))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(27),m3h4x32(:,93),heltab2x128(:,:,334))
  call Hloop_A_Q(ntryL,G0H32(27),96,nMB,G1H32(36),n2h32(67))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(613)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(335),h0tab(:,335),[96,31],[nMB,0],2,2,wf4(:,16),wf32(:,142))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(27),m3h4x32(:,94),heltab2x128(:,:,335))
  call Hloop_A_Q(ntryL,G0H32(27),96,nMB,G1H32(37),n2h32(68))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(50),[G1H8(53),G1H8(14),G1H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(51),[G1H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(49),[G1H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(21),[G1H8(48),G1H8(20),G1H8(19),G1H8(54),G1H8(33) &
    ,G1H8(12),G1H8(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(38),[G1H8(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(44),[G1H8(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(4),[G0H8(3),G0H8(2),G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(56),[G1H8(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(34),[G1H8(37),G1H8(43),G1H8(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(6),[G0H8(5)])
  call Hcheck_last_QA_V(ntryL,l_switch,G1H8(50),wf8(:,2),G1tensor(1),m3h8x1(:,49),heltab2x8(:,:,89))
  call Hloop_VA_Q(ntryL,G0H32(1),wf32(:,8),G0H1(1),m3h32x1(:,22),heltab2x32(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(6),n2h1(116))
  call Hloop_VA_Q(ntryL,G0H32(2),wf32(:,10),G0H1(1),m3h32x1(:,23),heltab2x32(:,:,75))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(11),n2h1(117))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H8(51),wf8(:,4),G1tensor(16),m3h8x1(:,50),heltab2x8(:,:,90))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H8(49),wf8(:,6),G1tensor(21),m3h8x1(:,51),heltab2x8(:,:,91))
  call Hloop_VA_Q(ntryL,G0H32(3),wf32(:,16),G0H1(1),m3h32x1(:,24),heltab2x32(:,:,76))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(26),n2h1(118))
  call Hloop_VA_Q(ntryL,G0H32(4),wf32(:,18),G0H1(1),m3h32x1(:,25),heltab2x32(:,:,77))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(31),n2h1(119))
  call Hloop_VA_Q(ntryL,G0H32(5),wf32(:,22),G0H1(1),m3h32x1(:,26),heltab2x32(:,:,78))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(36),n2h1(120))
  call Hloop_VQ_A(ntryL,G0H32(6),wf32(:,4),G0H1(1),m3h32x1(:,27),heltab2x32(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(41),n2h1(121))
  call Hloop_VQ_A(ntryL,G0H32(7),wf32(:,6),G0H1(1),m3h32x1(:,28),heltab2x32(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(46),n2h1(122))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(21),wf8(:,9),G1tensor(51),m3h8x1(:,52),heltab2x8(:,:,92))
  call Hloop_VQ_A(ntryL,G0H32(8),wf32(:,12),G0H1(1),m3h32x1(:,29),heltab2x32(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(56),n2h1(123))
  call Hloop_VQ_A(ntryL,G0H32(9),wf32(:,14),G0H1(1),m3h32x1(:,30),heltab2x32(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(61),n2h1(124))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(38),wf8(:,11),G1tensor(66),m3h8x1(:,53),heltab2x8(:,:,93))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(44),wf8(:,13),G1tensor(71),m3h8x1(:,54),heltab2x8(:,:,94))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H32(22),wf32(:,20),G1tensor(76),m3h32x1(:,31),heltab2x32(:,:,83))
  call Hloop_VA_Q(ntryL,G0H8(4),wf8(:,2),G0H1(1),m3h8x1(:,55),heltab2x8(:,:,95))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(81),n2h1(125))
  call Hloop_VA_Q(ntryL,G0H32(10),wf32(:,42),G0H1(1),m3h32x1(:,32),heltab2x32(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(86),n2h1(126))
  call Hloop_VA_Q(ntryL,G0H32(11),wf32(:,44),G0H1(1),m3h32x1(:,33),heltab2x32(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(91),n2h1(127))
  call Hloop_VA_Q(ntryL,G0H32(12),wf32(:,53),G0H1(1),m3h32x1(:,34),heltab2x32(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(96),n2h1(128))
  call Hloop_VA_Q(ntryL,G0H32(13),wf32(:,55),G0H1(1),m3h32x1(:,35),heltab2x32(:,:,87))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(101),n2h1(129))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H32(23),wf32(:,38),G1tensor(106),m3h32x1(:,36),heltab2x32(:,:,88))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H32(24),wf32(:,40),G1tensor(111),m3h32x1(:,37),heltab2x32(:,:,89))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H32(25),wf32(:,49),G1tensor(116),m3h32x1(:,38),heltab2x32(:,:,90))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H32(26),wf32(:,51),G1tensor(42),m3h32x1(:,39),heltab2x32(:,:,91))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H8(56),wf8(:,44),G1tensor(5),m3h8x1(:,56),heltab2x8(:,:,96))
  call Hloop_VA_Q(ntryL,G0H32(14),wf32(:,65),G0H1(1),m3h32x1(:,40),heltab2x32(:,:,92))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(62),n2h1(130))
  call Hloop_VA_Q(ntryL,G0H32(15),wf32(:,76),G0H1(1),m3h32x1(:,41),heltab2x32(:,:,93))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(10),n2h1(131))
  call Hloop_VA_Q(ntryL,G0H32(16),wf32(:,78),G0H1(1),m3h32x1(:,42),heltab2x32(:,:,94))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(32),n2h1(132))
  call Hloop_VA_Q(ntryL,G0H32(17),wf32(:,80),G0H1(1),m3h32x1(:,43),heltab2x32(:,:,95))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(15),n2h1(133))
  call Hloop_VQ_A(ntryL,G0H32(18),wf32(:,60),G0H1(1),m3h32x1(:,44),heltab2x32(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(52),n2h1(134))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(34),wf8(:,46),G1tensor(20),m3h8x1(:,57),heltab2x8(:,:,97))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H32(27),wf32(:,70),G1tensor(107),m3h32x1(:,45),heltab2x32(:,:,97))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H32(28),wf32(:,72),G1tensor(25),m3h32x1(:,46),heltab2x32(:,:,98))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H32(29),wf32(:,74),G1tensor(92),m3h32x1(:,47),heltab2x32(:,:,99))
  call Hloop_VA_Q(ntryL,G0H8(6),wf8(:,44),G0H1(1),m3h8x1(:,58),heltab2x8(:,:,98))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,nMT,G1tensor(30),n2h1(135))
  call Hloop_VA_Q(ntryL,G0H32(19),wf32(:,94),G0H1(1),m3h32x1(:,48),heltab2x32(:,:,100))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(50),n2h1(136))
  call Hloop_VA_Q(ntryL,G0H32(20),wf32(:,96),G0H1(1),m3h32x1(:,49),heltab2x32(:,:,101))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(45),n2h1(137))
  call Hloop_VA_Q(ntryL,G0H32(21),wf32(:,103),G0H1(1),m3h32x1(:,50),heltab2x32(:,:,102))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(40),n2h1(138))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H32(30),wf32(:,90),G1tensor(35),m3h32x1(:,51),heltab2x32(:,:,103))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H32(31),wf32(:,92),G1tensor(37),m3h32x1(:,52),heltab2x32(:,:,104))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H32(32),wf32(:,101),G1tensor(8),m3h32x1(:,53),heltab2x32(:,:,105))
  call Hloop_VA_Q(ntryL,G0H32(22),wf32(:,122),G0H1(1),m3h32x1(:,54),heltab2x32(:,:,106))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(47),n2h1(139))
  call Hloop_VA_Q(ntryL,G0H32(23),wf32(:,124),G0H1(1),m3h32x1(:,55),heltab2x32(:,:,107))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(18),n2h1(140))
  call Hloop_VA_Q(ntryL,G0H32(24),wf32(:,131),G0H1(1),m3h32x1(:,56),heltab2x32(:,:,108))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(70),n2h1(141))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H32(33),wf32(:,118),G1tensor(65),m3h32x1(:,57),heltab2x32(:,:,109))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H32(34),wf32(:,120),G1tensor(60),m3h32x1(:,58),heltab2x32(:,:,110))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H32(35),wf32(:,129),G1tensor(55),m3h32x1(:,59),heltab2x32(:,:,111))
  call Hloop_VA_Q(ntryL,G0H32(25),wf32(:,140),G0H1(1),m3h32x1(:,60),heltab2x32(:,:,112))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(87),n2h1(142))
  call Hloop_VA_Q(ntryL,G0H32(26),wf32(:,144),G0H1(1),m3h32x1(:,61),heltab2x32(:,:,113))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,nMB,G1tensor(57),n2h1(143))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H32(36),wf32(:,138),G1tensor(3),m3h32x1(:,62),heltab2x32(:,:,114))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H32(37),wf32(:,142),G1tensor(82),m3h32x1(:,63),heltab2x32(:,:,115))
  call ol_merge_tensors(G0tensor(138),[G0tensor(132),G0tensor(18),G0tensor(40),G0tensor(25),G0tensor(56),G0tensor(6)])
  call ol_merge_tensors(G1tensor(1),[G0tensor(204),G0tensor(174),G0tensor(24),G0tensor(11)])
  call ol_merge_tensors(G0tensor(179),[G0tensor(85),G0tensor(116),G0tensor(41),G0tensor(16)])
  call ol_merge_tensors(G0tensor(271),[G0tensor(261),G0tensor(254),G0tensor(244),G0tensor(237),G0tensor(232),G0tensor(227) &
    ,G0tensor(222),G0tensor(217),G0tensor(212),G0tensor(207),G0tensor(202),G0tensor(197),G0tensor(192),G0tensor(187),G0tensor(182) &
    ,G0tensor(177),G0tensor(172),G0tensor(167),G0tensor(162),G0tensor(157),G0tensor(151),G0tensor(145),G0tensor(140),G0tensor(135) &
    ,G0tensor(129),G0tensor(124),G0tensor(104),G0tensor(83),G0tensor(68),G0tensor(49),G0tensor(43),G0tensor(94),G0tensor(7) &
    ,G0tensor(115),G0tensor(105),G0tensor(95),G0tensor(29),G0tensor(9),G0tensor(82),G0tensor(60),G0tensor(8),G0tensor(50) &
    ,G0tensor(52),G0tensor(42),G0tensor(96),G0tensor(71),G0tensor(46),G0tensor(21)])
  call ol_merge_tensors(G0tensor(137),[G0tensor(133),G0tensor(12),G0tensor(80),G0tensor(13),G0tensor(87),G0tensor(81) &
    ,G0tensor(31)])
  call ol_merge_tensors(G1tensor(21),[G1tensor(16),G0tensor(209),G0tensor(169),G0tensor(37),G0tensor(36)])
  call ol_merge_tensors(G1tensor(51),[G0tensor(219),G0tensor(154),G0tensor(77),G0tensor(61)])
  call ol_merge_tensors(G1tensor(82),[G1tensor(3),G1tensor(55),G1tensor(60),G1tensor(65),G1tensor(8),G1tensor(37),G1tensor(35) &
    ,G1tensor(92),G1tensor(25),G1tensor(107),G1tensor(42),G1tensor(116),G1tensor(111),G1tensor(106),G1tensor(76),G0tensor(159) &
    ,G0tensor(28),G0tensor(15),G0tensor(91),G0tensor(66)])
  call ol_merge_tensors(G1tensor(71),[G1tensor(66),G0tensor(194),G0tensor(189),G0tensor(65),G0tensor(86)])
  call ol_merge_tensors(G0tensor(142),[G0tensor(88),G0tensor(106)])
  call ol_merge_tensors(G1tensor(5),[G0tensor(251),G0tensor(246),G0tensor(39),G0tensor(111)])
  call ol_merge_tensors(G0tensor(266),[G0tensor(260),G0tensor(255),G0tensor(249),G0tensor(243),G0tensor(238),G0tensor(152) &
    ,G0tensor(146),G0tensor(130),G0tensor(123),G0tensor(108),G0tensor(78),G0tensor(69),G0tensor(48),G0tensor(89),G0tensor(79) &
    ,G0tensor(20),G0tensor(5)])
  call ol_merge_tensors(G0tensor(148),[G0tensor(27),G0tensor(10)])
  call ol_merge_tensors(G1tensor(20),[G0tensor(263),G0tensor(234),G0tensor(99),G0tensor(32)])
  call ol_merge_tensors(G0tensor(186),[G0tensor(176),G0tensor(166),G0tensor(156),G0tensor(17),G0tensor(92)])
  call ol_merge_tensors(G0tensor(270),[G0tensor(221),G0tensor(206),G0tensor(191),G0tensor(181),G0tensor(171),G0tensor(161) &
    ,G0tensor(118),G0tensor(33),G0tensor(100),G0tensor(3),G0tensor(30)])
  call ol_merge_tensors(G0tensor(240),[G0tensor(224),G0tensor(199),G0tensor(164),G0tensor(38),G0tensor(90),G0tensor(72) &
    ,G0tensor(35)])
  call ol_merge_tensors(G0tensor(268),[G0tensor(257),G0tensor(229),G0tensor(214),G0tensor(184),G0tensor(98),G0tensor(112) &
    ,G0tensor(75),G0tensor(70)])
  call ol_merge_tensors(G0tensor(216),[G0tensor(211),G0tensor(201),G0tensor(196),G0tensor(57)])
  call ol_merge_tensors(G0tensor(150),[G0tensor(144),G0tensor(139),G0tensor(134),G0tensor(117),G0tensor(97),G0tensor(14)])
  call ol_merge_tensors(G0tensor(231),[G0tensor(226),G0tensor(127),G0tensor(59),G0tensor(2),G0tensor(23)])
  call ol_merge_tensors(G0tensor(236),[G0tensor(128),G0tensor(84)])
  call ol_merge_tensors(G0tensor(143),[G0tensor(58),G0tensor(74),G0tensor(34)])
  call ol_merge_tensors(G0tensor(242),[G0tensor(64)])
  call ol_merge_tensors(G0tensor(265),[G0tensor(248),G0tensor(122),G0tensor(44)])
  call ol_merge_tensors(G0tensor(253),[G0tensor(73),G0tensor(63)])
  call ol_merge_tensors(G0tensor(149),[G0tensor(126),G0tensor(114),G0tensor(93)])
  call ol_merge_tensors(G0tensor(259),[G0tensor(121)])
  call ol_merge_tensors(G0tensor(235),[G0tensor(230),G0tensor(195),G0tensor(160),G0tensor(155)])
  call ol_merge_tensors(G0tensor(170),[G0tensor(165)])
  call ol_merge_tensors(G0tensor(252),[G0tensor(225),G0tensor(210),G0tensor(180),G0tensor(175)])
  call ol_merge_tensors(G1tensor(81),[G0tensor(190),G0tensor(185)])
  call ol_merge_tensors(G0tensor(205),[G0tensor(200)])
  call ol_merge_tensors(G0tensor(220),[G0tensor(215)])
  call ol_merge_tensors(G0tensor(247),[G0tensor(241)])
  call ol_merge_tensors(G1tensor(30),[G0tensor(264),G0tensor(258)])
  call ol_merge_tensors(G1tensor(57),[G1tensor(87),G1tensor(70),G1tensor(18),G1tensor(47),G1tensor(40),G1tensor(45),G1tensor(50) &
    ,G1tensor(15),G1tensor(32),G1tensor(10),G1tensor(62),G1tensor(101),G1tensor(96),G1tensor(91),G1tensor(86),G1tensor(36) &
    ,G1tensor(31),G1tensor(26),G1tensor(11),G1tensor(6),G0tensor(269)])
  call ol_merge_tensors(G1tensor(52),[G1tensor(61),G1tensor(56),G1tensor(46),G1tensor(41)])
call TI_bubble_red(G1tensor(1),92,mass2set(:,1),G0tensor(1),M2L1R1,G0tensor(26))
call TI_bubble_red(G1tensor(21),83,mass2set(:,1),G0tensor(51),M2L1R1,G0tensor(76))
call TI_bubble_red(G1tensor(51),108,mass2set(:,1),G0tensor(101),M2L1R1,G0tensor(62))
call TI_bubble_red(G1tensor(82),96,mass2set(:,1),G0tensor(107),M2L1R1,G0tensor(45))
call TI_bubble_red(G1tensor(71),99,mass2set(:,1),G0tensor(47),M2L1R1,G0tensor(55))
call TI_bubble_red(G1tensor(5),89,mass2set(:,2),G0tensor(67),M2L1R1,G0tensor(4))
call TI_bubble_red(G1tensor(20),102,mass2set(:,2),G0tensor(19),M2L1R1,G0tensor(102))
call TI_bubble_red(G1tensor(81),92,mass2set(:,3),G0tensor(110),M2L1R1,G0tensor(120))
call TI_bubble_red(G1tensor(30),89,mass2set(:,4),G0tensor(22),M2L1R1,G0tensor(54))
call TI_bubble_red(G1tensor(57),80,mass2set(:,3),G0tensor(109),M2L1R1,G0tensor(53))
call TI_bubble_red(G1tensor(52),96,mass2set(:,3),G0tensor(103),M2L1R1,G0tensor(119))
  call ol_merge_tensors(G0tensor(119),[G0tensor(53),G0tensor(120),G0tensor(55),G0tensor(45),G0tensor(62),G0tensor(76) &
    ,G0tensor(271),G0tensor(26)])
  call ol_merge_tensors(G0tensor(54),[G0tensor(102),G0tensor(266),G0tensor(4)])
  call ol_merge_tensors(T0sum(76),[G0tensor(138)])
  call ol_merge_tensors(T0sum(77),[G0tensor(1)])
  call ol_merge_tensors(T0sum(78),[G0tensor(119)])
  call ol_merge_tensors(T0sum(79),[G0tensor(179)])
  call ol_merge_tensors(T0sum(80),[G0tensor(137)])
  call ol_merge_tensors(T0sum(81),[G0tensor(51)])
  call ol_merge_tensors(T0sum(82),[G0tensor(101)])
  call ol_merge_tensors(T0sum(83),[G0tensor(107)])
  call ol_merge_tensors(T0sum(84),[G0tensor(47)])
  call ol_merge_tensors(T0sum(85),[G0tensor(142)])
  call ol_merge_tensors(T0sum(86),[G0tensor(67)])
  call ol_merge_tensors(T0sum(87),[G0tensor(54)])
  call ol_merge_tensors(T0sum(88),[G0tensor(148)])
  call ol_merge_tensors(T0sum(89),[G0tensor(19)])
  call ol_merge_tensors(T0sum(90),[G0tensor(186)])
  call ol_merge_tensors(T0sum(91),[G0tensor(270)])
  call ol_merge_tensors(T0sum(92),[G0tensor(240)])
  call ol_merge_tensors(T0sum(93),[G0tensor(268)])
  call ol_merge_tensors(T0sum(94),[G0tensor(216)])
  call ol_merge_tensors(T0sum(95),[G0tensor(150)])
  call ol_merge_tensors(T0sum(96),[G0tensor(231)])
  call ol_merge_tensors(T0sum(97),[G0tensor(236)])
  call ol_merge_tensors(T0sum(98),[G0tensor(143)])
  call ol_merge_tensors(T0sum(99),[G0tensor(242)])
  call ol_merge_tensors(T0sum(100),[G0tensor(265)])
  call ol_merge_tensors(T0sum(101),[G0tensor(253)])
  call ol_merge_tensors(T0sum(102),[G0tensor(149)])
  call ol_merge_tensors(T0sum(103),[G0tensor(259)])
  call ol_merge_tensors(T0sum(104),[G0tensor(235)])
  call ol_merge_tensors(T0sum(105),[G0tensor(170)])
  call ol_merge_tensors(T0sum(106),[G0tensor(252)])
  call ol_merge_tensors(T0sum(107),[G0tensor(110)])
  call ol_merge_tensors(T0sum(108),[G0tensor(205)])
  call ol_merge_tensors(T0sum(109),[G0tensor(220)])
  call ol_merge_tensors(T0sum(110),[G0tensor(247)])
  call ol_merge_tensors(T0sum(111),[G0tensor(22)])
  call ol_merge_tensors(T0sum(112),[G0tensor(109)])
  call ol_merge_tensors(T0sum(113),[G0tensor(103)])
! end of process


end subroutine vamp_2

end module ol_vamp_2_pplllla_nenexeexbbxa_1_/**/REALKIND
