
module ol_vamp_2_pplllla_eeexexddxa_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_2(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pplllla_eeexexddxa_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pplllla_eeexexddxa_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pplllla_eeexexddxa_1_/**/DREALKIND
  use ol_tensor_sum_storage_pplllla_eeexexddxa_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red

  use ol_loop_storage_pplllla_eeexexddxa_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pplllla_eeexexddxa_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,148),heltab2x128(:,:,288))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(20),n2h64(148))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(289),h0tab(:,289),[106,5,16],[0,0,0],3,2,wf16(:,306),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,306),G0H8(1),m3h16x8(:,29),heltab2x128(:,:,289))
  call Hloop_A_Q(ntryL,G0H8(1),106,0,G1H8(59),n2h8(77))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(290),h0tab(:,290),[106,5,16],[0,0,0],3,2,wf16(:,308),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,308),G0H8(1),m3h16x8(:,30),heltab2x128(:,:,290))
  call Hloop_A_Q(ntryL,G0H8(1),106,0,G1H8(62),n2h8(78))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(291),h0tab(:,291),[106,5,16],[0,0,0],3,2,wf16(:,306),wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,306),G0H8(1),m3h16x8(:,31),heltab2x128(:,:,291))
  call Hloop_A_Q(ntryL,G0H8(1),106,0,G1H8(64),n2h8(79))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(292),h0tab(:,292),[106,5,16],[0,0,0],3,2,wf16(:,308),wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,308),G0H8(1),m3h16x8(:,32),heltab2x128(:,:,292))
  call Hloop_A_Q(ntryL,G0H8(1),106,0,G1H8(65),n2h8(80))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(886)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(293),h0tab(:,293),[64,16,47],[0,0,0],3,1,wf32(:,26))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,149),heltab2x128(:,:,293))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(21),n2h64(149))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(888)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(294),h0tab(:,294),[64,16,47],[0,0,0],3,1,wf32(:,28))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,150),heltab2x128(:,:,294))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(22),n2h64(150))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(890)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(295),h0tab(:,295),[64,16,47],[0,0,0],3,1,wf32(:,30))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,151),heltab2x128(:,:,295))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(23),n2h64(151))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(892)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(296),h0tab(:,296),[64,16,47],[0,0,0],3,1,wf32(:,32))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,152),heltab2x128(:,:,296))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(24),n2h64(152))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(895)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(297),h0tab(:,297),[79,16,32],[0,0,0],3,1,wf32(:,33))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,33),G0H4(1),m3h32x4(:,1),heltab2x128(:,:,297))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(17),n2h4(81))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(897)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(298),h0tab(:,298),[79,16,32],[0,0,0],3,1,wf32(:,35))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,35),G0H4(1),ngZd,m3h32x4(:,2),heltab2x128(:,:,298))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(18),n2h4(82))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(899)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(299),h0tab(:,299),[79,16,32],[0,0,0],3,1,wf32(:,36))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,36),G0H4(1),m3h32x4(:,3),heltab2x128(:,:,299))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(19),n2h4(83))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(900)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(300),h0tab(:,300),[79,16,32],[0,0,0],3,1,wf32(:,38))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,38),G0H4(1),ngZd,m3h32x4(:,4),heltab2x128(:,:,300))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(20),n2h4(84))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(101)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(301),h0tab(:,301),[74,21,32],[0,0,0],3,2,wf8(:,33),wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,33),G0H16(1),m3h8x16(:,65),heltab2x128(:,:,301))
  call Hloop_A_Q(ntryL,G0H16(1),74,0,G1H16(20),n2h16(129))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(302),h0tab(:,302),[74,21,32],[0,0,0],3,2,wf8(:,35),wf8(:,10))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,35),G0H16(1),ngZd,m3h8x16(:,66),heltab2x128(:,:,302))
  call Hloop_A_Q(ntryL,G0H16(1),74,0,G1H16(19),n2h16(130))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(303),h0tab(:,303),[74,21,32],[0,0,0],3,2,wf8(:,33),wf8(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,33),G0H16(1),m3h8x16(:,67),heltab2x128(:,:,303))
  call Hloop_A_Q(ntryL,G0H16(1),74,0,G1H16(25),n2h16(131))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(304),h0tab(:,304),[74,21,32],[0,0,0],3,2,wf8(:,35),wf8(:,12))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,35),G0H16(1),ngZd,m3h8x16(:,68),heltab2x128(:,:,304))
  call Hloop_A_Q(ntryL,G0H16(1),74,0,G1H16(22),n2h16(132))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(305),h0tab(:,305),[74,16,37],[0,0,0],3,2,wf8(:,33),wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,33),G0H16(1),m3h8x16(:,69),heltab2x128(:,:,305))
  call Hloop_A_Q(ntryL,G0H16(1),74,0,G1H16(21),n2h16(133))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(108)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(306),h0tab(:,306),[74,16,37],[0,0,0],3,2,wf8(:,35),wf8(:,2))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,35),G0H16(1),ngZd,m3h8x16(:,70),heltab2x128(:,:,306))
  call Hloop_A_Q(ntryL,G0H16(1),74,0,G1H16(26),n2h16(134))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(109)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(307),h0tab(:,307),[74,16,37],[0,0,0],3,2,wf8(:,33),wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,33),G0H16(1),m3h8x16(:,71),heltab2x128(:,:,307))
  call Hloop_A_Q(ntryL,G0H16(1),74,0,G1H16(24),n2h16(135))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(308),h0tab(:,308),[74,16,37],[0,0,0],3,2,wf8(:,35),wf8(:,4))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,35),G0H16(1),ngZd,m3h8x16(:,72),heltab2x128(:,:,308))
  call Hloop_A_Q(ntryL,G0H16(1),74,0,G1H16(23),n2h16(136))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(309),h0tab(:,309),[90,5,32],[0,0,0],3,2,wf16(:,319),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,319),G0H8(1),m3h16x8(:,33),heltab2x128(:,:,309))
  call Hloop_Q_A(ntryL,G0H8(1),90,0,G1H8(69),n2h8(81))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1276)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(310),h0tab(:,310),[90,5,32],[0,0,0],3,2,wf16(:,320),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,320),G0H8(1),m3h16x8(:,34),heltab2x128(:,:,310))
  call Hloop_Q_A(ntryL,G0H8(1),90,0,G1H8(70),n2h8(82))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(311),h0tab(:,311),[90,5,32],[0,0,0],3,2,wf16(:,319),wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,319),G0H8(1),m3h16x8(:,35),heltab2x128(:,:,311))
  call Hloop_Q_A(ntryL,G0H8(1),90,0,G1H8(71),n2h8(83))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1278)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(312),h0tab(:,312),[90,5,32],[0,0,0],3,2,wf16(:,320),wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,320),G0H8(1),m3h16x8(:,36),heltab2x128(:,:,312))
  call Hloop_Q_A(ntryL,G0H8(1),90,0,G1H8(75),n2h8(84))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1279)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(313),h0tab(:,313),[106,5,16],[0,0,0],3,2,wf16(:,317),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,317),G0H8(1),m3h16x8(:,37),heltab2x128(:,:,313))
  call Hloop_A_Q(ntryL,G0H8(1),106,0,G1H8(76),n2h8(85))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1280)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(314),h0tab(:,314),[106,5,16],[0,0,0],3,2,wf16(:,318),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,318),G0H8(1),m3h16x8(:,38),heltab2x128(:,:,314))
  call Hloop_A_Q(ntryL,G0H8(1),106,0,G1H8(77),n2h8(86))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1281)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(315),h0tab(:,315),[106,5,16],[0,0,0],3,2,wf16(:,317),wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,317),G0H8(1),m3h16x8(:,39),heltab2x128(:,:,315))
  call Hloop_A_Q(ntryL,G0H8(1),106,0,G1H8(81),n2h8(87))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1282)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(316),h0tab(:,316),[106,5,16],[0,0,0],3,2,wf16(:,318),wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,318),G0H8(1),m3h16x8(:,40),heltab2x128(:,:,316))
  call Hloop_A_Q(ntryL,G0H8(1),106,0,G1H8(82),n2h8(88))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(903)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(317),h0tab(:,317),[79,16,32],[0,0,0],3,1,wf32(:,39))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,39),G0H4(1),m3h32x4(:,5),heltab2x128(:,:,317))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(21),n2h4(85))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(904)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(318),h0tab(:,318),[79,16,32],[0,0,0],3,1,wf32(:,41))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,41),G0H4(1),ngZd,m3h32x4(:,6),heltab2x128(:,:,318))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(22),n2h4(86))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(906)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(319),h0tab(:,319),[79,16,32],[0,0,0],3,1,wf32(:,42))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,42),G0H4(1),m3h32x4(:,7),heltab2x128(:,:,319))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(23),n2h4(87))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(907)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(320),h0tab(:,320),[79,16,32],[0,0,0],3,1,wf32(:,44))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,44),G0H4(1),ngZd,m3h32x4(:,8),heltab2x128(:,:,320))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(24),n2h4(88))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(909)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(321),h0tab(:,321),[79,16,32],[0,0,0],3,1,wf32(:,45))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,45),G0H4(1),m3h32x4(:,9),heltab2x128(:,:,321))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(25),n2h4(89))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(910)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(322),h0tab(:,322),[79,16,32],[0,0,0],3,1,wf32(:,47))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,47),G0H4(1),ngZd,m3h32x4(:,10),heltab2x128(:,:,322))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(26),n2h4(90))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(912)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(323),h0tab(:,323),[79,16,32],[0,0,0],3,1,wf32(:,48))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,48),G0H4(1),m3h32x4(:,11),heltab2x128(:,:,323))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(27),n2h4(91))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(913)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(324),h0tab(:,324),[79,16,32],[0,0,0],3,1,wf32(:,50))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,50),G0H4(1),ngZd,m3h32x4(:,12),heltab2x128(:,:,324))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(28),n2h4(92))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(325),h0tab(:,325),[74,21,32],[0,0,0],3,2,wf8(:,36),wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,36),G0H16(1),m3h8x16(:,73),heltab2x128(:,:,325))
  call Hloop_A_Q(ntryL,G0H16(1),74,0,G1H16(41),n2h16(137))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(326),h0tab(:,326),[74,21,32],[0,0,0],3,2,wf8(:,38),wf8(:,10))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,38),G0H16(1),ngZd,m3h8x16(:,74),heltab2x128(:,:,326))
  call Hloop_A_Q(ntryL,G0H16(1),74,0,G1H16(34),n2h16(138))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(115)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(327),h0tab(:,327),[74,21,32],[0,0,0],3,2,wf8(:,36),wf8(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,36),G0H16(1),m3h8x16(:,75),heltab2x128(:,:,327))
  call Hloop_A_Q(ntryL,G0H16(1),74,0,G1H16(33),n2h16(139))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(328),h0tab(:,328),[74,21,32],[0,0,0],3,2,wf8(:,38),wf8(:,12))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,38),G0H16(1),ngZd,m3h8x16(:,76),heltab2x128(:,:,328))
  call Hloop_A_Q(ntryL,G0H16(1),74,0,G1H16(43),n2h16(140))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(329),h0tab(:,329),[74,16,37],[0,0,0],3,2,wf8(:,36),wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,36),G0H16(1),m3h8x16(:,77),heltab2x128(:,:,329))
  call Hloop_A_Q(ntryL,G0H16(1),74,0,G1H16(36),n2h16(141))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(330),h0tab(:,330),[74,16,37],[0,0,0],3,2,wf8(:,38),wf8(:,2))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,38),G0H16(1),ngZd,m3h8x16(:,78),heltab2x128(:,:,330))
  call Hloop_A_Q(ntryL,G0H16(1),74,0,G1H16(35),n2h16(142))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(331),h0tab(:,331),[74,16,37],[0,0,0],3,2,wf8(:,36),wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,36),G0H16(1),m3h8x16(:,79),heltab2x128(:,:,331))
  call Hloop_A_Q(ntryL,G0H16(1),74,0,G1H16(45),n2h16(143))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(120)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(332),h0tab(:,332),[74,16,37],[0,0,0],3,2,wf8(:,38),wf8(:,4))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,38),G0H16(1),ngZd,m3h8x16(:,80),heltab2x128(:,:,332))
  call Hloop_A_Q(ntryL,G0H16(1),74,0,G1H16(38),n2h16(144))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1287)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(333),h0tab(:,333),[90,5,32],[0,0,0],3,2,wf16(:,323),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,323),G0H8(1),m3h16x8(:,41),heltab2x128(:,:,333))
  call Hloop_Q_A(ntryL,G0H8(1),90,0,G1H8(83),n2h8(89))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1288)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(334),h0tab(:,334),[90,5,32],[0,0,0],3,2,wf16(:,324),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,324),G0H8(1),m3h16x8(:,42),heltab2x128(:,:,334))
  call Hloop_Q_A(ntryL,G0H8(1),90,0,G1H8(86),n2h8(90))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1289)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(335),h0tab(:,335),[90,5,32],[0,0,0],3,2,wf16(:,323),wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,323),G0H8(1),m3h16x8(:,43),heltab2x128(:,:,335))
  call Hloop_Q_A(ntryL,G0H8(1),90,0,G1H8(87),n2h8(91))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1290)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(336),h0tab(:,336),[90,5,32],[0,0,0],3,2,wf16(:,324),wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,324),G0H8(1),m3h16x8(:,44),heltab2x128(:,:,336))
  call Hloop_Q_A(ntryL,G0H8(1),90,0,G1H8(88),n2h8(92))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1291)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(337),h0tab(:,337),[106,5,16],[0,0,0],3,2,wf16(:,321),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,321),G0H8(1),m3h16x8(:,45),heltab2x128(:,:,337))
  call Hloop_A_Q(ntryL,G0H8(1),106,0,G1H8(91),n2h8(93))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1292)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(338),h0tab(:,338),[106,5,16],[0,0,0],3,2,wf16(:,322),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,322),G0H8(1),m3h16x8(:,46),heltab2x128(:,:,338))
  call Hloop_A_Q(ntryL,G0H8(1),106,0,G1H8(92),n2h8(94))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1293)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(339),h0tab(:,339),[106,5,16],[0,0,0],3,2,wf16(:,321),wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,321),G0H8(1),m3h16x8(:,47),heltab2x128(:,:,339))
  call Hloop_A_Q(ntryL,G0H8(1),106,0,G1H8(93),n2h8(95))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1294)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(340),h0tab(:,340),[106,5,16],[0,0,0],3,2,wf16(:,322),wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,322),G0H8(1),m3h16x8(:,48),heltab2x128(:,:,340))
  call Hloop_A_Q(ntryL,G0H8(1),106,0,G1H8(96),n2h8(96))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(916)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(341),h0tab(:,341),[79,16,32],[0,0,0],3,1,wf32(:,51))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,51),G0H4(1),m3h32x4(:,13),heltab2x128(:,:,341))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(29),n2h4(93))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(917)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(342),h0tab(:,342),[79,16,32],[0,0,0],3,1,wf32(:,53))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,53),G0H4(1),ngZd,m3h32x4(:,14),heltab2x128(:,:,342))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(30),n2h4(94))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(919)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(343),h0tab(:,343),[79,16,32],[0,0,0],3,1,wf32(:,54))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,54),G0H4(1),m3h32x4(:,15),heltab2x128(:,:,343))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(31),n2h4(95))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(920)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(344),h0tab(:,344),[79,16,32],[0,0,0],3,1,wf32(:,56))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,56),G0H4(1),ngZd,m3h32x4(:,16),heltab2x128(:,:,344))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(32),n2h4(96))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1299)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(345),h0tab(:,345),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,33))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,49),heltab2x128(:,:,345))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(17),n2h32(49))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1300)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(346),h0tab(:,346),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,325))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,50),heltab2x128(:,:,346))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(18),n2h32(50))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(347),h0tab(:,347),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,35))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,51),heltab2x128(:,:,347))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(19),n2h32(51))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(348),h0tab(:,348),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,326))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,52),heltab2x128(:,:,348))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(20),n2h32(52))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1303)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(349),h0tab(:,349),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,37))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,53),heltab2x128(:,:,349))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(21),n2h32(53))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1304)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(350),h0tab(:,350),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,327))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,54),heltab2x128(:,:,350))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(22),n2h32(54))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1305)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(351),h0tab(:,351),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,39))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,55),heltab2x128(:,:,351))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(23),n2h32(55))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1306)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(352),h0tab(:,352),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,328))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,56),heltab2x128(:,:,352))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(24),n2h32(56))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1307)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(353),h0tab(:,353),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,33))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,57),heltab2x128(:,:,353))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(25),n2h32(57))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1308)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(354),h0tab(:,354),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,325))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,58),heltab2x128(:,:,354))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(26),n2h32(58))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1309)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(355),h0tab(:,355),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,35))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,59),heltab2x128(:,:,355))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(27),n2h32(59))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1310)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(356),h0tab(:,356),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,326))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,60),heltab2x128(:,:,356))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(28),n2h32(60))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1311)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(357),h0tab(:,357),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,37))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,61),heltab2x128(:,:,357))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(29),n2h32(61))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1312)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(358),h0tab(:,358),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,327))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,62),heltab2x128(:,:,358))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(30),n2h32(62))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1313)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(359),h0tab(:,359),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,39))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,63),heltab2x128(:,:,359))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(31),n2h32(63))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1314)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(360),h0tab(:,360),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,328))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,64),heltab2x128(:,:,360))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(32),n2h32(64))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(921)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(361),h0tab(:,361),[64,31,32],[0,0,0],3,1,wf32(:,58))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,153),heltab2x128(:,:,361))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(25),n2h64(153))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(922)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(362),h0tab(:,362),[64,31,32],[0,0,0],3,1,wf32(:,60))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,154),heltab2x128(:,:,362))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(26),n2h64(154))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(923)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(363),h0tab(:,363),[64,31,32],[0,0,0],3,1,wf32(:,62))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,155),heltab2x128(:,:,363))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(27),n2h64(155))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(924)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(364),h0tab(:,364),[64,31,32],[0,0,0],3,1,wf32(:,64))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,156),heltab2x128(:,:,364))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(28),n2h64(156))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(925)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(365),h0tab(:,365),[64,16,47],[0,0,0],3,1,wf32(:,66))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,157),heltab2x128(:,:,365))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(29),n2h64(157))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(926)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(366),h0tab(:,366),[64,16,47],[0,0,0],3,1,wf32(:,68))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,158),heltab2x128(:,:,366))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(30),n2h64(158))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(927)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(367),h0tab(:,367),[64,16,47],[0,0,0],3,1,wf32(:,70))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,159),heltab2x128(:,:,367))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(31),n2h64(159))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(928)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(368),h0tab(:,368),[64,16,47],[0,0,0],3,1,wf32(:,72))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,160),heltab2x128(:,:,368))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(32),n2h64(160))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(930)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(369),h0tab(:,369),[79,16,32],[0,0,0],3,1,wf32(:,73))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,73),G0H4(1),m3h32x4(:,17),heltab2x128(:,:,369))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(33),n2h4(97))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(931)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(370),h0tab(:,370),[79,16,32],[0,0,0],3,1,wf32(:,75))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,75),G0H4(1),ngZd,m3h32x4(:,18),heltab2x128(:,:,370))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(34),n2h4(98))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(933)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(371),h0tab(:,371),[79,16,32],[0,0,0],3,1,wf32(:,76))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,76),G0H4(1),m3h32x4(:,19),heltab2x128(:,:,371))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(35),n2h4(99))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(934)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(372),h0tab(:,372),[79,16,32],[0,0,0],3,1,wf32(:,78))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,78),G0H4(1),ngZd,m3h32x4(:,20),heltab2x128(:,:,372))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(36),n2h4(100))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(935)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(373),h0tab(:,373),[64,31,32],[0,0,0],3,1,wf32(:,80))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,161),heltab2x128(:,:,373))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(33),n2h64(161))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(936)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(374),h0tab(:,374),[64,31,32],[0,0,0],3,1,wf32(:,82))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,162),heltab2x128(:,:,374))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(34),n2h64(162))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(937)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(375),h0tab(:,375),[64,31,32],[0,0,0],3,1,wf32(:,84))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,163),heltab2x128(:,:,375))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(35),n2h64(163))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(938)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(376),h0tab(:,376),[64,31,32],[0,0,0],3,1,wf32(:,86))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,164),heltab2x128(:,:,376))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(36),n2h64(164))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(939)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(377),h0tab(:,377),[64,16,47],[0,0,0],3,1,wf32(:,88))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,165),heltab2x128(:,:,377))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(37),n2h64(165))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(940)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(378),h0tab(:,378),[64,16,47],[0,0,0],3,1,wf32(:,90))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,166),heltab2x128(:,:,378))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(38),n2h64(166))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(941)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(379),h0tab(:,379),[64,16,47],[0,0,0],3,1,wf32(:,92))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,167),heltab2x128(:,:,379))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(39),n2h64(167))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(942)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(380),h0tab(:,380),[64,16,47],[0,0,0],3,1,wf32(:,94))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,168),heltab2x128(:,:,380))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(40),n2h64(168))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(944)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(381),h0tab(:,381),[79,16,32],[0,0,0],3,1,wf32(:,95))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,95),G0H4(1),m3h32x4(:,21),heltab2x128(:,:,381))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(37),n2h4(101))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(945)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(382),h0tab(:,382),[79,16,32],[0,0,0],3,1,wf32(:,97))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,97),G0H4(1),ngZd,m3h32x4(:,22),heltab2x128(:,:,382))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(38),n2h4(102))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(947)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(383),h0tab(:,383),[79,16,32],[0,0,0],3,1,wf32(:,98))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,98),G0H4(1),m3h32x4(:,23),heltab2x128(:,:,383))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(39),n2h4(103))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(948)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(384),h0tab(:,384),[79,16,32],[0,0,0],3,1,wf32(:,100))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,100),G0H4(1),ngZd,m3h32x4(:,24),heltab2x128(:,:,384))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(40),n2h4(104))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1315)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(385),h0tab(:,385),[80,6,41],[0,0,0],3,3,wf4(:,4),wf4(:,19),wf8(:,46))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,65),heltab2x128(:,:,385))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(33),n2h32(65))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1316)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(386),h0tab(:,386),[80,6,41],[0,0,0],3,3,wf4(:,4),wf4(:,21),wf8(:,46))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,66),heltab2x128(:,:,386))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(34),n2h32(66))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1317)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(387),h0tab(:,387),[80,6,41],[0,0,0],3,3,wf4(:,4),wf4(:,19),wf8(:,48))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,67),heltab2x128(:,:,387))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(35),n2h32(67))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1318)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(388),h0tab(:,388),[80,6,41],[0,0,0],3,3,wf4(:,4),wf4(:,21),wf8(:,48))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,68),heltab2x128(:,:,388))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(36),n2h32(68))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1319)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(389),h0tab(:,389),[80,9,38],[0,0,0],3,3,wf4(:,4),wf4(:,18),wf8(:,50))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,69),heltab2x128(:,:,389))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(37),n2h32(69))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1320)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(390),h0tab(:,390),[80,9,38],[0,0,0],3,3,wf4(:,4),wf4(:,18),wf8(:,52))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,70),heltab2x128(:,:,390))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(38),n2h32(70))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1321)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(391),h0tab(:,391),[80,9,38],[0,0,0],3,3,wf4(:,4),wf4(:,23),wf8(:,50))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,71),heltab2x128(:,:,391))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(39),n2h32(71))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1322)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(392),h0tab(:,392),[80,9,38],[0,0,0],3,3,wf4(:,4),wf4(:,23),wf8(:,52))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,72),heltab2x128(:,:,392))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(40),n2h32(72))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(509)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(393),h0tab(:,393),[89,6,32],[0,0,0],3,2,wf16(:,223),wf4(:,19))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,223),G0H8(1),m3h16x8(:,49),heltab2x128(:,:,393))
  call Hloop_Q_A(ntryL,G0H8(1),89,0,G1H8(97),n2h8(97))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(510)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(394),h0tab(:,394),[89,6,32],[0,0,0],3,2,wf16(:,223),wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,223),G0H8(1),m3h16x8(:,50),heltab2x128(:,:,394))
  call Hloop_Q_A(ntryL,G0H8(1),89,0,G1H8(98),n2h8(98))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(512)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(395),h0tab(:,395),[89,6,32],[0,0,0],3,2,wf16(:,224),wf4(:,19))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,224),G0H8(1),m3h16x8(:,51),heltab2x128(:,:,395))
  call Hloop_Q_A(ntryL,G0H8(1),89,0,G1H8(99),n2h8(99))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(513)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(396),h0tab(:,396),[89,6,32],[0,0,0],3,2,wf16(:,224),wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,224),G0H8(1),m3h16x8(:,52),heltab2x128(:,:,396))
  call Hloop_Q_A(ntryL,G0H8(1),89,0,G1H8(100),n2h8(100))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(516)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(397),h0tab(:,397),[86,9,32],[0,0,0],3,2,wf16(:,225),wf4(:,18))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,225),G0H8(1),m3h16x8(:,53),heltab2x128(:,:,397))
  call Hloop_Q_A(ntryL,G0H8(1),86,0,G1H8(101),n2h8(101))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(518)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(398),h0tab(:,398),[86,9,32],[0,0,0],3,2,wf16(:,226),wf4(:,18))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,226),G0H8(1),m3h16x8(:,54),heltab2x128(:,:,398))
  call Hloop_Q_A(ntryL,G0H8(1),86,0,G1H8(102),n2h8(102))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(519)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(399),h0tab(:,399),[86,9,32],[0,0,0],3,2,wf16(:,225),wf4(:,23))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,225),G0H8(1),m3h16x8(:,55),heltab2x128(:,:,399))
  call Hloop_Q_A(ntryL,G0H8(1),86,0,G1H8(103),n2h8(103))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(520)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(400),h0tab(:,400),[86,9,32],[0,0,0],3,2,wf16(:,226),wf4(:,23))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,226),G0H8(1),m3h16x8(:,56),heltab2x128(:,:,400))
  call Hloop_Q_A(ntryL,G0H8(1),86,0,G1H8(104),n2h8(104))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1327)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(401),h0tab(:,401),[96,6,25],[0,0,0],3,3,wf4(:,10),wf4(:,19),wf8(:,54))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,73),heltab2x128(:,:,401))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(41),n2h32(73))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1328)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(402),h0tab(:,402),[96,6,25],[0,0,0],3,3,wf4(:,10),wf4(:,21),wf8(:,54))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,74),heltab2x128(:,:,402))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(42),n2h32(74))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1329)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(403),h0tab(:,403),[96,6,25],[0,0,0],3,3,wf4(:,10),wf4(:,19),wf8(:,56))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,75),heltab2x128(:,:,403))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(43),n2h32(75))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1330)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(404),h0tab(:,404),[96,6,25],[0,0,0],3,3,wf4(:,10),wf4(:,21),wf8(:,56))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,76),heltab2x128(:,:,404))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(44),n2h32(76))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1331)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(405),h0tab(:,405),[96,9,22],[0,0,0],3,3,wf4(:,10),wf4(:,18),wf8(:,58))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,77),heltab2x128(:,:,405))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(45),n2h32(77))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1332)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(406),h0tab(:,406),[96,9,22],[0,0,0],3,3,wf4(:,10),wf4(:,18),wf8(:,60))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,78),heltab2x128(:,:,406))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(46),n2h32(78))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1333)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(407),h0tab(:,407),[96,9,22],[0,0,0],3,3,wf4(:,10),wf4(:,23),wf8(:,58))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,79),heltab2x128(:,:,407))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(47),n2h32(79))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1334)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(408),h0tab(:,408),[96,9,22],[0,0,0],3,3,wf4(:,10),wf4(:,23),wf8(:,60))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,80),heltab2x128(:,:,408))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(48),n2h32(80))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(523)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(409),h0tab(:,409),[105,6,16],[0,0,0],3,2,wf16(:,231),wf4(:,19))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,231),G0H8(1),m3h16x8(:,57),heltab2x128(:,:,409))
  call Hloop_A_Q(ntryL,G0H8(1),105,0,G1H8(105),n2h8(105))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(524)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(410),h0tab(:,410),[105,6,16],[0,0,0],3,2,wf16(:,231),wf4(:,21))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,231),G0H8(1),m3h16x8(:,58),heltab2x128(:,:,410))
  call Hloop_A_Q(ntryL,G0H8(1),105,0,G1H8(106),n2h8(106))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(526)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(411),h0tab(:,411),[105,6,16],[0,0,0],3,2,wf16(:,232),wf4(:,19))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,232),G0H8(1),m3h16x8(:,59),heltab2x128(:,:,411))
  call Hloop_A_Q(ntryL,G0H8(1),105,0,G1H8(107),n2h8(107))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(527)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(412),h0tab(:,412),[105,6,16],[0,0,0],3,2,wf16(:,232),wf4(:,21))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,232),G0H8(1),m3h16x8(:,60),heltab2x128(:,:,412))
  call Hloop_A_Q(ntryL,G0H8(1),105,0,G1H8(108),n2h8(108))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(530)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(413),h0tab(:,413),[102,9,16],[0,0,0],3,2,wf16(:,233),wf4(:,18))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,233),G0H8(1),m3h16x8(:,61),heltab2x128(:,:,413))
  call Hloop_A_Q(ntryL,G0H8(1),102,0,G1H8(109),n2h8(109))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(532)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(414),h0tab(:,414),[102,9,16],[0,0,0],3,2,wf16(:,234),wf4(:,18))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,234),G0H8(1),m3h16x8(:,62),heltab2x128(:,:,414))
  call Hloop_A_Q(ntryL,G0H8(1),102,0,G1H8(110),n2h8(110))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(533)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(415),h0tab(:,415),[102,9,16],[0,0,0],3,2,wf16(:,233),wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,233),G0H8(1),m3h16x8(:,63),heltab2x128(:,:,415))
  call Hloop_A_Q(ntryL,G0H8(1),102,0,G1H8(111),n2h8(111))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(534)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(416),h0tab(:,416),[102,9,16],[0,0,0],3,2,wf16(:,234),wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,234),G0H8(1),m3h16x8(:,64),heltab2x128(:,:,416))
  call Hloop_A_Q(ntryL,G0H8(1),102,0,G1H8(112),n2h8(112))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(183)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(417),h0tab(:,417),[64,25,38],[0,0,0],3,2,wf8(:,54),wf8(:,50))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,169),heltab2x128(:,:,417))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(41),n2h64(169))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(184)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(418),h0tab(:,418),[64,25,38],[0,0,0],3,2,wf8(:,54),wf8(:,52))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,170),heltab2x128(:,:,418))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(42),n2h64(170))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(419),h0tab(:,419),[64,25,38],[0,0,0],3,2,wf8(:,56),wf8(:,50))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,171),heltab2x128(:,:,419))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(43),n2h64(171))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(186)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(420),h0tab(:,420),[64,25,38],[0,0,0],3,2,wf8(:,56),wf8(:,52))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,172),heltab2x128(:,:,420))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(44),n2h64(172))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1339)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(421),h0tab(:,421),[89,6,32],[0,0,0],3,2,wf16(:,345),wf4(:,19))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,345),G0H8(1),m3h16x8(:,65),heltab2x128(:,:,421))
  call Hloop_Q_A(ntryL,G0H8(1),89,0,G1H8(113),n2h8(113))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1340)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(422),h0tab(:,422),[89,6,32],[0,0,0],3,2,wf16(:,345),wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,345),G0H8(1),m3h16x8(:,66),heltab2x128(:,:,422))
  call Hloop_Q_A(ntryL,G0H8(1),89,0,G1H8(114),n2h8(114))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1341)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(423),h0tab(:,423),[89,6,32],[0,0,0],3,2,wf16(:,346),wf4(:,19))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,346),G0H8(1),m3h16x8(:,67),heltab2x128(:,:,423))
  call Hloop_Q_A(ntryL,G0H8(1),89,0,G1H8(115),n2h8(115))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1342)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(424),h0tab(:,424),[89,6,32],[0,0,0],3,2,wf16(:,346),wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,346),G0H8(1),m3h16x8(:,68),heltab2x128(:,:,424))
  call Hloop_Q_A(ntryL,G0H8(1),89,0,G1H8(116),n2h8(116))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(950)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(425),h0tab(:,425),[64,31,32],[0,0,0],3,1,wf32(:,102))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,173),heltab2x128(:,:,425))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(45),n2h64(173))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(952)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(426),h0tab(:,426),[64,31,32],[0,0,0],3,1,wf32(:,104))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,174),heltab2x128(:,:,426))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(46),n2h64(174))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(954)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(427),h0tab(:,427),[64,31,32],[0,0,0],3,1,wf32(:,106))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,175),heltab2x128(:,:,427))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(47),n2h64(175))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(956)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(428),h0tab(:,428),[64,31,32],[0,0,0],3,1,wf32(:,108))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,176),heltab2x128(:,:,428))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(48),n2h64(176))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(187)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(429),h0tab(:,429),[64,22,41],[0,0,0],3,2,wf8(:,58),wf8(:,46))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,177),heltab2x128(:,:,429))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(49),n2h64(177))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(188)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(430),h0tab(:,430),[64,22,41],[0,0,0],3,2,wf8(:,60),wf8(:,46))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,178),heltab2x128(:,:,430))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(50),n2h64(178))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(189)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(431),h0tab(:,431),[64,22,41],[0,0,0],3,2,wf8(:,58),wf8(:,48))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,179),heltab2x128(:,:,431))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(51),n2h64(179))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(190)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(432),h0tab(:,432),[64,22,41],[0,0,0],3,2,wf8(:,60),wf8(:,48))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,180),heltab2x128(:,:,432))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(52),n2h64(180))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1343)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(433),h0tab(:,433),[105,6,16],[0,0,0],3,2,wf16(:,342),wf4(:,19))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,342),G0H8(1),m3h16x8(:,69),heltab2x128(:,:,433))
  call Hloop_A_Q(ntryL,G0H8(1),105,0,G1H8(117),n2h8(117))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1344)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(434),h0tab(:,434),[105,6,16],[0,0,0],3,2,wf16(:,342),wf4(:,21))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,342),G0H8(1),m3h16x8(:,70),heltab2x128(:,:,434))
  call Hloop_A_Q(ntryL,G0H8(1),105,0,G1H8(118),n2h8(118))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1345)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(435),h0tab(:,435),[105,6,16],[0,0,0],3,2,wf16(:,344),wf4(:,19))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,344),G0H8(1),m3h16x8(:,71),heltab2x128(:,:,435))
  call Hloop_A_Q(ntryL,G0H8(1),105,0,G1H8(119),n2h8(119))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1346)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(436),h0tab(:,436),[105,6,16],[0,0,0],3,2,wf16(:,344),wf4(:,21))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,344),G0H8(1),m3h16x8(:,72),heltab2x128(:,:,436))
  call Hloop_A_Q(ntryL,G0H8(1),105,0,G1H8(120),n2h8(120))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(958)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(437),h0tab(:,437),[64,16,47],[0,0,0],3,1,wf32(:,110))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,181),heltab2x128(:,:,437))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(53),n2h64(181))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(960)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(438),h0tab(:,438),[64,16,47],[0,0,0],3,1,wf32(:,112))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,182),heltab2x128(:,:,438))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(54),n2h64(182))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(962)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(439),h0tab(:,439),[64,16,47],[0,0,0],3,1,wf32(:,114))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,183),heltab2x128(:,:,439))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(55),n2h64(183))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(964)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(440),h0tab(:,440),[64,16,47],[0,0,0],3,1,wf32(:,116))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,184),heltab2x128(:,:,440))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(56),n2h64(184))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1347)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(441),h0tab(:,441),[86,9,32],[0,0,0],3,2,wf16(:,347),wf4(:,18))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,347),G0H8(1),m3h16x8(:,73),heltab2x128(:,:,441))
  call Hloop_Q_A(ntryL,G0H8(1),86,0,G1H8(121),n2h8(121))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1348)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(442),h0tab(:,442),[86,9,32],[0,0,0],3,2,wf16(:,348),wf4(:,18))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,348),G0H8(1),m3h16x8(:,74),heltab2x128(:,:,442))
  call Hloop_Q_A(ntryL,G0H8(1),86,0,G1H8(122),n2h8(122))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1349)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(443),h0tab(:,443),[86,9,32],[0,0,0],3,2,wf16(:,347),wf4(:,23))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,347),G0H8(1),m3h16x8(:,75),heltab2x128(:,:,443))
  call Hloop_Q_A(ntryL,G0H8(1),86,0,G1H8(123),n2h8(123))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1350)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(444),h0tab(:,444),[86,9,32],[0,0,0],3,2,wf16(:,348),wf4(:,23))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,348),G0H8(1),m3h16x8(:,76),heltab2x128(:,:,444))
  call Hloop_Q_A(ntryL,G0H8(1),86,0,G1H8(124),n2h8(124))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(966)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(445),h0tab(:,445),[64,31,32],[0,0,0],3,1,wf32(:,118))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,185),heltab2x128(:,:,445))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(57),n2h64(185))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(968)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(446),h0tab(:,446),[64,31,32],[0,0,0],3,1,wf32(:,120))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,186),heltab2x128(:,:,446))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(58),n2h64(186))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(970)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(447),h0tab(:,447),[64,31,32],[0,0,0],3,1,wf32(:,122))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,187),heltab2x128(:,:,447))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(59),n2h64(187))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(972)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(448),h0tab(:,448),[64,31,32],[0,0,0],3,1,wf32(:,124))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,188),heltab2x128(:,:,448))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(60),n2h64(188))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1351)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(449),h0tab(:,449),[102,9,16],[0,0,0],3,2,wf16(:,338),wf4(:,18))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,338),G0H8(1),m3h16x8(:,77),heltab2x128(:,:,449))
  call Hloop_A_Q(ntryL,G0H8(1),102,0,G1H8(125),n2h8(125))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1352)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(450),h0tab(:,450),[102,9,16],[0,0,0],3,2,wf16(:,340),wf4(:,18))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,340),G0H8(1),m3h16x8(:,78),heltab2x128(:,:,450))
  call Hloop_A_Q(ntryL,G0H8(1),102,0,G1H8(126),n2h8(126))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1353)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(451),h0tab(:,451),[102,9,16],[0,0,0],3,2,wf16(:,338),wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,338),G0H8(1),m3h16x8(:,79),heltab2x128(:,:,451))
  call Hloop_A_Q(ntryL,G0H8(1),102,0,G1H8(127),n2h8(127))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1354)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(452),h0tab(:,452),[102,9,16],[0,0,0],3,2,wf16(:,340),wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,340),G0H8(1),m3h16x8(:,80),heltab2x128(:,:,452))
  call Hloop_A_Q(ntryL,G0H8(1),102,0,G1H8(128),n2h8(128))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(974)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(453),h0tab(:,453),[64,16,47],[0,0,0],3,1,wf32(:,126))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,189),heltab2x128(:,:,453))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(61),n2h64(189))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(976)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(454),h0tab(:,454),[64,16,47],[0,0,0],3,1,wf32(:,128))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,190),heltab2x128(:,:,454))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(62),n2h64(190))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(978)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(455),h0tab(:,455),[64,16,47],[0,0,0],3,1,wf32(:,130))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,191),heltab2x128(:,:,455))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(63),n2h64(191))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(980)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(456),h0tab(:,456),[64,16,47],[0,0,0],3,1,wf32(:,132))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,192),heltab2x128(:,:,456))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(64),n2h64(192))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(457),h0tab(:,457),[73,22,32],[0,0,0],3,2,wf8(:,73),wf8(:,58))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,73),G0H16(1),m3h8x16(:,81),heltab2x128(:,:,457))
  call Hloop_A_Q(ntryL,G0H16(1),73,0,G1H16(10),n2h16(145))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(458),h0tab(:,458),[73,22,32],[0,0,0],3,2,wf8(:,75),wf8(:,58))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,75),G0H16(1),ngZd,m3h8x16(:,82),heltab2x128(:,:,458))
  call Hloop_A_Q(ntryL,G0H16(1),73,0,G1H16(12),n2h16(146))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(236)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(459),h0tab(:,459),[73,22,32],[0,0,0],3,2,wf8(:,73),wf8(:,60))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,73),G0H16(1),m3h8x16(:,83),heltab2x128(:,:,459))
  call Hloop_A_Q(ntryL,G0H16(1),73,0,G1H16(14),n2h16(147))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(237)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(460),h0tab(:,460),[73,22,32],[0,0,0],3,2,wf8(:,75),wf8(:,60))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,75),G0H16(1),ngZd,m3h8x16(:,84),heltab2x128(:,:,460))
  call Hloop_A_Q(ntryL,G0H16(1),73,0,G1H16(16),n2h16(148))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(238)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(461),h0tab(:,461),[73,16,38],[0,0,0],3,2,wf8(:,73),wf8(:,50))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,73),G0H16(1),m3h8x16(:,85),heltab2x128(:,:,461))
  call Hloop_A_Q(ntryL,G0H16(1),73,0,G1H16(37),n2h16(149))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(239)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(462),h0tab(:,462),[73,16,38],[0,0,0],3,2,wf8(:,75),wf8(:,50))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,75),G0H16(1),ngZd,m3h8x16(:,86),heltab2x128(:,:,462))
  call Hloop_A_Q(ntryL,G0H16(1),73,0,G1H16(47),n2h16(150))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(240)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(463),h0tab(:,463),[73,16,38],[0,0,0],3,2,wf8(:,73),wf8(:,52))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,73),G0H16(1),m3h8x16(:,87),heltab2x128(:,:,463))
  call Hloop_A_Q(ntryL,G0H16(1),73,0,G1H16(40),n2h16(151))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(241)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(464),h0tab(:,464),[73,16,38],[0,0,0],3,2,wf8(:,75),wf8(:,52))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,75),G0H16(1),ngZd,m3h8x16(:,88),heltab2x128(:,:,464))
  call Hloop_A_Q(ntryL,G0H16(1),73,0,G1H16(39),n2h16(152))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1355)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(465),h0tab(:,465),[89,6,32],[0,0,0],3,2,wf16(:,351),wf4(:,19))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,351),G0H8(1),m3h16x8(:,81),heltab2x128(:,:,465))
  call Hloop_Q_A(ntryL,G0H8(1),89,0,G1H8(129),n2h8(129))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1356)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(466),h0tab(:,466),[89,6,32],[0,0,0],3,2,wf16(:,352),wf4(:,19))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,352),G0H8(1),m3h16x8(:,82),heltab2x128(:,:,466))
  call Hloop_Q_A(ntryL,G0H8(1),89,0,G1H8(130),n2h8(130))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1357)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(467),h0tab(:,467),[89,6,32],[0,0,0],3,2,wf16(:,351),wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,351),G0H8(1),m3h16x8(:,83),heltab2x128(:,:,467))
  call Hloop_Q_A(ntryL,G0H8(1),89,0,G1H8(131),n2h8(131))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1358)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(468),h0tab(:,468),[89,6,32],[0,0,0],3,2,wf16(:,352),wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,352),G0H8(1),m3h16x8(:,84),heltab2x128(:,:,468))
  call Hloop_Q_A(ntryL,G0H8(1),89,0,G1H8(132),n2h8(132))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1359)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(469),h0tab(:,469),[105,6,16],[0,0,0],3,2,wf16(:,349),wf4(:,19))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,349),G0H8(1),m3h16x8(:,85),heltab2x128(:,:,469))
  call Hloop_A_Q(ntryL,G0H8(1),105,0,G1H8(133),n2h8(133))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1360)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(470),h0tab(:,470),[105,6,16],[0,0,0],3,2,wf16(:,350),wf4(:,19))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,350),G0H8(1),m3h16x8(:,86),heltab2x128(:,:,470))
  call Hloop_A_Q(ntryL,G0H8(1),105,0,G1H8(134),n2h8(134))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1361)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(471),h0tab(:,471),[105,6,16],[0,0,0],3,2,wf16(:,349),wf4(:,21))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,349),G0H8(1),m3h16x8(:,87),heltab2x128(:,:,471))
  call Hloop_A_Q(ntryL,G0H8(1),105,0,G1H8(135),n2h8(135))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1362)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(472),h0tab(:,472),[105,6,16],[0,0,0],3,2,wf16(:,350),wf4(:,21))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,350),G0H8(1),m3h16x8(:,88),heltab2x128(:,:,472))
  call Hloop_A_Q(ntryL,G0H8(1),105,0,G1H8(136),n2h8(136))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(982)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(473),h0tab(:,473),[79,16,32],[0,0,0],3,1,wf32(:,133))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,133),G0H4(1),m3h32x4(:,25),heltab2x128(:,:,473))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(41),n2h4(105))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(983)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(474),h0tab(:,474),[79,16,32],[0,0,0],3,1,wf32(:,135))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,135),G0H4(1),ngZd,m3h32x4(:,26),heltab2x128(:,:,474))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(42),n2h4(106))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(985)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(475),h0tab(:,475),[79,16,32],[0,0,0],3,1,wf32(:,136))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,136),G0H4(1),m3h32x4(:,27),heltab2x128(:,:,475))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(43),n2h4(107))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(986)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(476),h0tab(:,476),[79,16,32],[0,0,0],3,1,wf32(:,138))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,138),G0H4(1),ngZd,m3h32x4(:,28),heltab2x128(:,:,476))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(44),n2h4(108))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(988)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(477),h0tab(:,477),[79,16,32],[0,0,0],3,1,wf32(:,139))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,139),G0H4(1),m3h32x4(:,29),heltab2x128(:,:,477))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(45),n2h4(109))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(989)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(478),h0tab(:,478),[79,16,32],[0,0,0],3,1,wf32(:,141))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,141),G0H4(1),ngZd,m3h32x4(:,30),heltab2x128(:,:,478))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(46),n2h4(110))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(991)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(479),h0tab(:,479),[79,16,32],[0,0,0],3,1,wf32(:,142))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,142),G0H4(1),m3h32x4(:,31),heltab2x128(:,:,479))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(47),n2h4(111))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(992)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(480),h0tab(:,480),[79,16,32],[0,0,0],3,1,wf32(:,144))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,144),G0H4(1),ngZd,m3h32x4(:,32),heltab2x128(:,:,480))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(48),n2h4(112))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(994)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(481),h0tab(:,481),[79,16,32],[0,0,0],3,1,wf32(:,145))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,145),G0H4(1),m3h32x4(:,33),heltab2x128(:,:,481))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(49),n2h4(113))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(995)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(482),h0tab(:,482),[79,16,32],[0,0,0],3,1,wf32(:,147))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,147),G0H4(1),ngZd,m3h32x4(:,34),heltab2x128(:,:,482))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(50),n2h4(114))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(997)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(483),h0tab(:,483),[79,16,32],[0,0,0],3,1,wf32(:,148))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,148),G0H4(1),m3h32x4(:,35),heltab2x128(:,:,483))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(51),n2h4(115))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(998)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(484),h0tab(:,484),[79,16,32],[0,0,0],3,1,wf32(:,150))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,150),G0H4(1),ngZd,m3h32x4(:,36),heltab2x128(:,:,484))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(52),n2h4(116))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1367)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(485),h0tab(:,485),[89,6,32],[0,0,0],3,2,wf16(:,353),wf4(:,19))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,353),G0H8(1),m3h16x8(:,89),heltab2x128(:,:,485))
  call Hloop_Q_A(ntryL,G0H8(1),89,0,G1H8(137),n2h8(137))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1368)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(486),h0tab(:,486),[89,6,32],[0,0,0],3,2,wf16(:,353),wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,353),G0H8(1),m3h16x8(:,90),heltab2x128(:,:,486))
  call Hloop_Q_A(ntryL,G0H8(1),89,0,G1H8(138),n2h8(138))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1369)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(487),h0tab(:,487),[89,6,32],[0,0,0],3,2,wf16(:,354),wf4(:,19))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,354),G0H8(1),m3h16x8(:,91),heltab2x128(:,:,487))
  call Hloop_Q_A(ntryL,G0H8(1),89,0,G1H8(139),n2h8(139))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1370)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(488),h0tab(:,488),[89,6,32],[0,0,0],3,2,wf16(:,354),wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,354),G0H8(1),m3h16x8(:,92),heltab2x128(:,:,488))
  call Hloop_Q_A(ntryL,G0H8(1),89,0,G1H8(140),n2h8(140))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1371)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(489),h0tab(:,489),[105,6,16],[0,0,0],3,2,wf16(:,355),wf4(:,19))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,355),G0H8(1),m3h16x8(:,93),heltab2x128(:,:,489))
  call Hloop_A_Q(ntryL,G0H8(1),105,0,G1H8(141),n2h8(141))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1372)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(490),h0tab(:,490),[105,6,16],[0,0,0],3,2,wf16(:,355),wf4(:,21))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,355),G0H8(1),m3h16x8(:,94),heltab2x128(:,:,490))
  call Hloop_A_Q(ntryL,G0H8(1),105,0,G1H8(142),n2h8(142))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1373)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(491),h0tab(:,491),[105,6,16],[0,0,0],3,2,wf16(:,356),wf4(:,19))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,356),G0H8(1),m3h16x8(:,95),heltab2x128(:,:,491))
  call Hloop_A_Q(ntryL,G0H8(1),105,0,G1H8(143),n2h8(143))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1374)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(492),h0tab(:,492),[105,6,16],[0,0,0],3,2,wf16(:,356),wf4(:,21))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,356),G0H8(1),m3h16x8(:,96),heltab2x128(:,:,492))
  call Hloop_A_Q(ntryL,G0H8(1),105,0,G1H8(144),n2h8(144))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(248)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(493),h0tab(:,493),[73,22,32],[0,0,0],3,2,wf8(:,76),wf8(:,58))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,76),G0H16(1),m3h8x16(:,89),heltab2x128(:,:,493))
  call Hloop_A_Q(ntryL,G0H16(1),73,0,G1H16(61),n2h16(153))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(249)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(494),h0tab(:,494),[73,22,32],[0,0,0],3,2,wf8(:,76),wf8(:,60))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,76),G0H16(1),m3h8x16(:,90),heltab2x128(:,:,494))
  call Hloop_A_Q(ntryL,G0H16(1),73,0,G1H16(50),n2h16(154))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(495),h0tab(:,495),[73,22,32],[0,0,0],3,2,wf8(:,78),wf8(:,58))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,78),G0H16(1),ngZd,m3h8x16(:,91),heltab2x128(:,:,495))
  call Hloop_A_Q(ntryL,G0H16(1),73,0,G1H16(49),n2h16(155))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(251)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(496),h0tab(:,496),[73,22,32],[0,0,0],3,2,wf8(:,78),wf8(:,60))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,78),G0H16(1),ngZd,m3h8x16(:,92),heltab2x128(:,:,496))
  call Hloop_A_Q(ntryL,G0H16(1),73,0,G1H16(62),n2h16(156))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(243)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(497),h0tab(:,497),[73,16,38],[0,0,0],3,2,wf8(:,76),wf8(:,50))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,76),G0H16(1),m3h8x16(:,93),heltab2x128(:,:,497))
  call Hloop_A_Q(ntryL,G0H16(1),73,0,G1H16(52),n2h16(157))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(244)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(498),h0tab(:,498),[73,16,38],[0,0,0],3,2,wf8(:,76),wf8(:,52))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,76),G0H16(1),m3h8x16(:,94),heltab2x128(:,:,498))
  call Hloop_A_Q(ntryL,G0H16(1),73,0,G1H16(51),n2h16(158))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(246)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(499),h0tab(:,499),[73,16,38],[0,0,0],3,2,wf8(:,78),wf8(:,50))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,78),G0H16(1),ngZd,m3h8x16(:,95),heltab2x128(:,:,499))
  call Hloop_A_Q(ntryL,G0H16(1),73,0,G1H16(57),n2h16(159))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(247)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(500),h0tab(:,500),[73,16,38],[0,0,0],3,2,wf8(:,78),wf8(:,52))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,78),G0H16(1),ngZd,m3h8x16(:,96),heltab2x128(:,:,500))
  call Hloop_A_Q(ntryL,G0H16(1),73,0,G1H16(54),n2h16(160))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1001)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(501),h0tab(:,501),[79,16,32],[0,0,0],3,1,wf32(:,151))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,151),G0H4(1),m3h32x4(:,37),heltab2x128(:,:,501))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(53),n2h4(117))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1003)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(502),h0tab(:,502),[79,16,32],[0,0,0],3,1,wf32(:,152))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,152),G0H4(1),m3h32x4(:,38),heltab2x128(:,:,502))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(54),n2h4(118))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1004)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(503),h0tab(:,503),[79,16,32],[0,0,0],3,1,wf32(:,154))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,154),G0H4(1),ngZd,m3h32x4(:,39),heltab2x128(:,:,503))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(55),n2h4(119))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1005)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(504),h0tab(:,504),[79,16,32],[0,0,0],3,1,wf32(:,156))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,156),G0H4(1),ngZd,m3h32x4(:,40),heltab2x128(:,:,504))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(56),n2h4(120))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1379)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(505),h0tab(:,505),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,71))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,81),heltab2x128(:,:,505))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(49),n2h32(81))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1380)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(506),h0tab(:,506),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,357))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,82),heltab2x128(:,:,506))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(50),n2h32(82))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1381)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(507),h0tab(:,507),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,73))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,83),heltab2x128(:,:,507))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(51),n2h32(83))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1382)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(508),h0tab(:,508),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,358))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,84),heltab2x128(:,:,508))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(52),n2h32(84))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1383)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(509),h0tab(:,509),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,75))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,85),heltab2x128(:,:,509))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(53),n2h32(85))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1384)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(510),h0tab(:,510),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,76))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,86),heltab2x128(:,:,510))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(54),n2h32(86))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1385)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(511),h0tab(:,511),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,359))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,87),heltab2x128(:,:,511))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(55),n2h32(87))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1386)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(512),h0tab(:,512),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,360))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,88),heltab2x128(:,:,512))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(56),n2h32(88))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1387)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(513),h0tab(:,513),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,71))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,89),heltab2x128(:,:,513))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(57),n2h32(89))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1388)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(514),h0tab(:,514),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,357))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,90),heltab2x128(:,:,514))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(58),n2h32(90))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1389)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(515),h0tab(:,515),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,73))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,91),heltab2x128(:,:,515))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(59),n2h32(91))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1390)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(516),h0tab(:,516),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,358))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,92),heltab2x128(:,:,516))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(60),n2h32(92))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1391)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(517),h0tab(:,517),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,75))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,93),heltab2x128(:,:,517))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(61),n2h32(93))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1392)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(518),h0tab(:,518),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,76))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,94),heltab2x128(:,:,518))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(62),n2h32(94))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1393)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(519),h0tab(:,519),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,359))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,95),heltab2x128(:,:,519))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(63),n2h32(95))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1394)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(520),h0tab(:,520),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,360))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,96),heltab2x128(:,:,520))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(64),n2h32(96))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1006)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(521),h0tab(:,521),[64,31,32],[0,0,0],3,1,wf32(:,158))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,193),heltab2x128(:,:,521))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(65),n2h64(193))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1007)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(522),h0tab(:,522),[64,31,32],[0,0,0],3,1,wf32(:,160))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,194),heltab2x128(:,:,522))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(66),n2h64(194))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1008)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(523),h0tab(:,523),[64,31,32],[0,0,0],3,1,wf32(:,162))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,195),heltab2x128(:,:,523))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(67),n2h64(195))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1009)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(524),h0tab(:,524),[64,31,32],[0,0,0],3,1,wf32(:,164))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,196),heltab2x128(:,:,524))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(68),n2h64(196))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1010)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(525),h0tab(:,525),[64,16,47],[0,0,0],3,1,wf32(:,166))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,197),heltab2x128(:,:,525))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(69),n2h64(197))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1011)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(526),h0tab(:,526),[64,16,47],[0,0,0],3,1,wf32(:,168))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,198),heltab2x128(:,:,526))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(70),n2h64(198))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1012)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(527),h0tab(:,527),[64,16,47],[0,0,0],3,1,wf32(:,170))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,199),heltab2x128(:,:,527))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(71),n2h64(199))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1013)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(528),h0tab(:,528),[64,16,47],[0,0,0],3,1,wf32(:,172))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,200),heltab2x128(:,:,528))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(72),n2h64(200))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1015)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(529),h0tab(:,529),[79,16,32],[0,0,0],3,1,wf32(:,173))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,173),G0H4(1),m3h32x4(:,41),heltab2x128(:,:,529))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(57),n2h4(121))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1016)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(530),h0tab(:,530),[79,16,32],[0,0,0],3,1,wf32(:,175))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,175),G0H4(1),ngZd,m3h32x4(:,42),heltab2x128(:,:,530))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(58),n2h4(122))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1018)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(531),h0tab(:,531),[79,16,32],[0,0,0],3,1,wf32(:,176))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,176),G0H4(1),m3h32x4(:,43),heltab2x128(:,:,531))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(59),n2h4(123))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1019)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(532),h0tab(:,532),[79,16,32],[0,0,0],3,1,wf32(:,178))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,178),G0H4(1),ngZd,m3h32x4(:,44),heltab2x128(:,:,532))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(60),n2h4(124))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1020)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(533),h0tab(:,533),[64,31,32],[0,0,0],3,1,wf32(:,180))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,201),heltab2x128(:,:,533))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(73),n2h64(201))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1021)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(534),h0tab(:,534),[64,31,32],[0,0,0],3,1,wf32(:,182))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,202),heltab2x128(:,:,534))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(74),n2h64(202))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1022)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(535),h0tab(:,535),[64,31,32],[0,0,0],3,1,wf32(:,184))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,203),heltab2x128(:,:,535))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(75),n2h64(203))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1023)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(536),h0tab(:,536),[64,31,32],[0,0,0],3,1,wf32(:,186))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,204),heltab2x128(:,:,536))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(76),n2h64(204))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1024)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(537),h0tab(:,537),[64,16,47],[0,0,0],3,1,wf32(:,188))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,205),heltab2x128(:,:,537))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(77),n2h64(205))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1025)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(538),h0tab(:,538),[64,16,47],[0,0,0],3,1,wf32(:,190))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,206),heltab2x128(:,:,538))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(78),n2h64(206))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1026)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(539),h0tab(:,539),[64,16,47],[0,0,0],3,1,wf32(:,192))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,207),heltab2x128(:,:,539))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(79),n2h64(207))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1027)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(540),h0tab(:,540),[64,16,47],[0,0,0],3,1,wf32(:,194))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,208),heltab2x128(:,:,540))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(80),n2h64(208))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1029)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(541),h0tab(:,541),[79,16,32],[0,0,0],3,1,wf32(:,195))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,195),G0H4(1),m3h32x4(:,45),heltab2x128(:,:,541))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(61),n2h4(125))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1031)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(542),h0tab(:,542),[79,16,32],[0,0,0],3,1,wf32(:,196))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,196),G0H4(1),m3h32x4(:,46),heltab2x128(:,:,542))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(62),n2h4(126))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1032)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(543),h0tab(:,543),[79,16,32],[0,0,0],3,1,wf32(:,198))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,198),G0H4(1),ngZd,m3h32x4(:,47),heltab2x128(:,:,543))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(63),n2h4(127))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1033)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(544),h0tab(:,544),[79,16,32],[0,0,0],3,1,wf32(:,200))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,200),G0H4(1),ngZd,m3h32x4(:,48),heltab2x128(:,:,544))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(64),n2h4(128))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1035)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(545),h0tab(:,545),[79,16,32],[0,0,0],3,1,wf32(:,201))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,201),G0H4(1),m3h32x4(:,49),heltab2x128(:,:,545))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(65),n2h4(129))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1036)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(546),h0tab(:,546),[79,16,32],[0,0,0],3,1,wf32(:,203))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,203),G0H4(1),ngZd,m3h32x4(:,50),heltab2x128(:,:,546))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(66),n2h4(130))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1038)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(547),h0tab(:,547),[79,16,32],[0,0,0],3,1,wf32(:,204))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,204),G0H4(1),m3h32x4(:,51),heltab2x128(:,:,547))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(67),n2h4(131))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1039)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(548),h0tab(:,548),[79,16,32],[0,0,0],3,1,wf32(:,206))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,206),G0H4(1),ngZd,m3h32x4(:,52),heltab2x128(:,:,548))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(68),n2h4(132))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(309)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(549),h0tab(:,549),[70,25,32],[0,0,0],3,2,wf8(:,91),wf8(:,54))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,91),G0H16(1),m3h8x16(:,97),heltab2x128(:,:,549))
  call Hloop_A_Q(ntryL,G0H16(1),70,0,G1H16(53),n2h16(161))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(312)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(550),h0tab(:,550),[70,25,32],[0,0,0],3,2,wf8(:,93),wf8(:,54))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,93),G0H16(1),ngZd,m3h8x16(:,98),heltab2x128(:,:,550))
  call Hloop_A_Q(ntryL,G0H16(1),70,0,G1H16(58),n2h16(162))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(313)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(551),h0tab(:,551),[70,25,32],[0,0,0],3,2,wf8(:,91),wf8(:,56))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,91),G0H16(1),m3h8x16(:,99),heltab2x128(:,:,551))
  call Hloop_A_Q(ntryL,G0H16(1),70,0,G1H16(56),n2h16(163))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(314)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(552),h0tab(:,552),[70,25,32],[0,0,0],3,2,wf8(:,93),wf8(:,56))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,93),G0H16(1),ngZd,m3h8x16(:,100),heltab2x128(:,:,552))
  call Hloop_A_Q(ntryL,G0H16(1),70,0,G1H16(55),n2h16(164))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(315)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(553),h0tab(:,553),[70,16,41],[0,0,0],3,2,wf8(:,91),wf8(:,46))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,91),G0H16(1),m3h8x16(:,101),heltab2x128(:,:,553))
  call Hloop_A_Q(ntryL,G0H16(1),70,0,G1H16(9),n2h16(165))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(316)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(554),h0tab(:,554),[70,16,41],[0,0,0],3,2,wf8(:,93),wf8(:,46))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,93),G0H16(1),ngZd,m3h8x16(:,102),heltab2x128(:,:,554))
  call Hloop_A_Q(ntryL,G0H16(1),70,0,G1H16(2),n2h16(166))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(317)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(555),h0tab(:,555),[70,16,41],[0,0,0],3,2,wf8(:,91),wf8(:,48))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,91),G0H16(1),m3h8x16(:,103),heltab2x128(:,:,555))
  call Hloop_A_Q(ntryL,G0H16(1),70,0,G1H16(1),n2h16(167))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(318)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(556),h0tab(:,556),[70,16,41],[0,0,0],3,2,wf8(:,93),wf8(:,48))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,93),G0H16(1),ngZd,m3h8x16(:,104),heltab2x128(:,:,556))
  call Hloop_A_Q(ntryL,G0H16(1),70,0,G1H16(11),n2h16(168))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1395)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(557),h0tab(:,557),[86,9,32],[0,0,0],3,2,wf16(:,363),wf4(:,18))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,363),G0H8(1),m3h16x8(:,97),heltab2x128(:,:,557))
  call Hloop_Q_A(ntryL,G0H8(1),86,0,G1H8(145),n2h8(145))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1396)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(558),h0tab(:,558),[86,9,32],[0,0,0],3,2,wf16(:,364),wf4(:,18))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,364),G0H8(1),m3h16x8(:,98),heltab2x128(:,:,558))
  call Hloop_Q_A(ntryL,G0H8(1),86,0,G1H8(146),n2h8(146))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1397)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(559),h0tab(:,559),[86,9,32],[0,0,0],3,2,wf16(:,363),wf4(:,23))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,363),G0H8(1),m3h16x8(:,99),heltab2x128(:,:,559))
  call Hloop_Q_A(ntryL,G0H8(1),86,0,G1H8(147),n2h8(147))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1398)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(560),h0tab(:,560),[86,9,32],[0,0,0],3,2,wf16(:,364),wf4(:,23))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,364),G0H8(1),m3h16x8(:,100),heltab2x128(:,:,560))
  call Hloop_Q_A(ntryL,G0H8(1),86,0,G1H8(148),n2h8(148))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1399)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(561),h0tab(:,561),[102,9,16],[0,0,0],3,2,wf16(:,361),wf4(:,18))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,361),G0H8(1),m3h16x8(:,101),heltab2x128(:,:,561))
  call Hloop_A_Q(ntryL,G0H8(1),102,0,G1H8(149),n2h8(149))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1400)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(562),h0tab(:,562),[102,9,16],[0,0,0],3,2,wf16(:,362),wf4(:,18))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,362),G0H8(1),m3h16x8(:,102),heltab2x128(:,:,562))
  call Hloop_A_Q(ntryL,G0H8(1),102,0,G1H8(150),n2h8(150))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1401)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(563),h0tab(:,563),[102,9,16],[0,0,0],3,2,wf16(:,361),wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,361),G0H8(1),m3h16x8(:,103),heltab2x128(:,:,563))
  call Hloop_A_Q(ntryL,G0H8(1),102,0,G1H8(151),n2h8(151))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1402)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(564),h0tab(:,564),[102,9,16],[0,0,0],3,2,wf16(:,362),wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,362),G0H8(1),m3h16x8(:,104),heltab2x128(:,:,564))
  call Hloop_A_Q(ntryL,G0H8(1),102,0,G1H8(152),n2h8(152))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1042)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(565),h0tab(:,565),[79,16,32],[0,0,0],3,1,wf32(:,207))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,207),G0H4(1),m3h32x4(:,53),heltab2x128(:,:,565))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(69),n2h4(133))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1043)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(566),h0tab(:,566),[79,16,32],[0,0,0],3,1,wf32(:,209))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,209),G0H4(1),ngZd,m3h32x4(:,54),heltab2x128(:,:,566))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(70),n2h4(134))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1045)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(567),h0tab(:,567),[79,16,32],[0,0,0],3,1,wf32(:,210))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,210),G0H4(1),m3h32x4(:,55),heltab2x128(:,:,567))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(71),n2h4(135))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1046)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(568),h0tab(:,568),[79,16,32],[0,0,0],3,1,wf32(:,212))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,212),G0H4(1),ngZd,m3h32x4(:,56),heltab2x128(:,:,568))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(72),n2h4(136))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1048)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(569),h0tab(:,569),[79,16,32],[0,0,0],3,1,wf32(:,213))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,213),G0H4(1),m3h32x4(:,57),heltab2x128(:,:,569))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(73),n2h4(137))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1049)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(570),h0tab(:,570),[79,16,32],[0,0,0],3,1,wf32(:,215))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,215),G0H4(1),ngZd,m3h32x4(:,58),heltab2x128(:,:,570))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(74),n2h4(138))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1051)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(571),h0tab(:,571),[79,16,32],[0,0,0],3,1,wf32(:,216))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,216),G0H4(1),m3h32x4(:,59),heltab2x128(:,:,571))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(75),n2h4(139))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1052)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(572),h0tab(:,572),[79,16,32],[0,0,0],3,1,wf32(:,218))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,218),G0H4(1),ngZd,m3h32x4(:,60),heltab2x128(:,:,572))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(76),n2h4(140))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(320)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(573),h0tab(:,573),[70,25,32],[0,0,0],3,2,wf8(:,94),wf8(:,54))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,94),G0H16(1),m3h8x16(:,105),heltab2x128(:,:,573))
  call Hloop_A_Q(ntryL,G0H16(1),70,0,G1H16(4),n2h16(169))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(322)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(574),h0tab(:,574),[70,25,32],[0,0,0],3,2,wf8(:,96),wf8(:,54))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,96),G0H16(1),ngZd,m3h8x16(:,106),heltab2x128(:,:,574))
  call Hloop_A_Q(ntryL,G0H16(1),70,0,G1H16(3),n2h16(170))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(323)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(575),h0tab(:,575),[70,25,32],[0,0,0],3,2,wf8(:,94),wf8(:,56))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,94),G0H16(1),m3h8x16(:,107),heltab2x128(:,:,575))
  call Hloop_A_Q(ntryL,G0H16(1),70,0,G1H16(13),n2h16(171))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(324)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(576),h0tab(:,576),[70,25,32],[0,0,0],3,2,wf8(:,96),wf8(:,56))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,96),G0H16(1),ngZd,m3h8x16(:,108),heltab2x128(:,:,576))
  call Hloop_A_Q(ntryL,G0H16(1),70,0,G1H16(6),n2h16(172))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(325)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(577),h0tab(:,577),[70,16,41],[0,0,0],3,2,wf8(:,94),wf8(:,46))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,94),G0H16(1),m3h8x16(:,109),heltab2x128(:,:,577))
  call Hloop_A_Q(ntryL,G0H16(1),70,0,G1H16(5),n2h16(173))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(326)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(578),h0tab(:,578),[70,16,41],[0,0,0],3,2,wf8(:,96),wf8(:,46))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,96),G0H16(1),ngZd,m3h8x16(:,110),heltab2x128(:,:,578))
  call Hloop_A_Q(ntryL,G0H16(1),70,0,G1H16(15),n2h16(174))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(327)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(579),h0tab(:,579),[70,16,41],[0,0,0],3,2,wf8(:,94),wf8(:,48))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,94),G0H16(1),m3h8x16(:,111),heltab2x128(:,:,579))
  call Hloop_A_Q(ntryL,G0H16(1),70,0,G1H16(8),n2h16(175))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(328)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(580),h0tab(:,580),[70,16,41],[0,0,0],3,2,wf8(:,96),wf8(:,48))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,96),G0H16(1),ngZd,m3h8x16(:,112),heltab2x128(:,:,580))
  call Hloop_A_Q(ntryL,G0H16(1),70,0,G1H16(7),n2h16(176))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1407)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(581),h0tab(:,581),[86,9,32],[0,0,0],3,2,wf16(:,367),wf4(:,18))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,367),G0H8(1),m3h16x8(:,105),heltab2x128(:,:,581))
  call Hloop_Q_A(ntryL,G0H8(1),86,0,G1H8(153),n2h8(153))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1408)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(582),h0tab(:,582),[86,9,32],[0,0,0],3,2,wf16(:,368),wf4(:,18))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,368),G0H8(1),m3h16x8(:,106),heltab2x128(:,:,582))
  call Hloop_Q_A(ntryL,G0H8(1),86,0,G1H8(154),n2h8(154))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1409)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(583),h0tab(:,583),[86,9,32],[0,0,0],3,2,wf16(:,367),wf4(:,23))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,367),G0H8(1),m3h16x8(:,107),heltab2x128(:,:,583))
  call Hloop_Q_A(ntryL,G0H8(1),86,0,G1H8(155),n2h8(155))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1410)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(584),h0tab(:,584),[86,9,32],[0,0,0],3,2,wf16(:,368),wf4(:,23))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,368),G0H8(1),m3h16x8(:,108),heltab2x128(:,:,584))
  call Hloop_Q_A(ntryL,G0H8(1),86,0,G1H8(156),n2h8(156))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1411)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(585),h0tab(:,585),[102,9,16],[0,0,0],3,2,wf16(:,365),wf4(:,18))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,365),G0H8(1),m3h16x8(:,109),heltab2x128(:,:,585))
  call Hloop_A_Q(ntryL,G0H8(1),102,0,G1H8(157),n2h8(157))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1412)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(586),h0tab(:,586),[102,9,16],[0,0,0],3,2,wf16(:,366),wf4(:,18))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,366),G0H8(1),m3h16x8(:,110),heltab2x128(:,:,586))
  call Hloop_A_Q(ntryL,G0H8(1),102,0,G1H8(158),n2h8(158))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1413)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(587),h0tab(:,587),[102,9,16],[0,0,0],3,2,wf16(:,365),wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,365),G0H8(1),m3h16x8(:,111),heltab2x128(:,:,587))
  call Hloop_A_Q(ntryL,G0H8(1),102,0,G1H8(159),n2h8(159))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1414)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(588),h0tab(:,588),[102,9,16],[0,0,0],3,2,wf16(:,366),wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,366),G0H8(1),m3h16x8(:,112),heltab2x128(:,:,588))
  call Hloop_A_Q(ntryL,G0H8(1),102,0,G1H8(160),n2h8(160))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1054)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(589),h0tab(:,589),[79,16,32],[0,0,0],3,1,wf32(:,219))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,219),G0H4(1),m3h32x4(:,61),heltab2x128(:,:,589))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(77),n2h4(141))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1055)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(590),h0tab(:,590),[79,16,32],[0,0,0],3,1,wf32(:,221))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,221),G0H4(1),ngZd,m3h32x4(:,62),heltab2x128(:,:,590))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(78),n2h4(142))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1057)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(591),h0tab(:,591),[79,16,32],[0,0,0],3,1,wf32(:,222))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,222),G0H4(1),m3h32x4(:,63),heltab2x128(:,:,591))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(79),n2h4(143))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1058)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(592),h0tab(:,592),[79,16,32],[0,0,0],3,1,wf32(:,224))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,224),G0H4(1),ngZd,m3h32x4(:,64),heltab2x128(:,:,592))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(80),n2h4(144))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1419)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(593),h0tab(:,593),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,95))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,97),heltab2x128(:,:,593))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(65),n2h32(97))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1420)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(594),h0tab(:,594),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,369))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,98),heltab2x128(:,:,594))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(66),n2h32(98))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1421)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(595),h0tab(:,595),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,97))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,99),heltab2x128(:,:,595))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(67),n2h32(99))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1422)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(596),h0tab(:,596),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,370))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,100),heltab2x128(:,:,596))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(68),n2h32(100))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1423)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(597),h0tab(:,597),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,99))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,101),heltab2x128(:,:,597))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(69),n2h32(101))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1424)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(598),h0tab(:,598),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,371))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,102),heltab2x128(:,:,598))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(70),n2h32(102))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1425)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(599),h0tab(:,599),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,101))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,103),heltab2x128(:,:,599))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(71),n2h32(103))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1426)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(600),h0tab(:,600),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,372))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,104),heltab2x128(:,:,600))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(72),n2h32(104))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1427)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(601),h0tab(:,601),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,95))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,105),heltab2x128(:,:,601))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(73),n2h32(105))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1428)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(602),h0tab(:,602),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,369))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,106),heltab2x128(:,:,602))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(74),n2h32(106))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1429)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(603),h0tab(:,603),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,97))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,107),heltab2x128(:,:,603))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(75),n2h32(107))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1430)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(604),h0tab(:,604),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,370))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,108),heltab2x128(:,:,604))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(76),n2h32(108))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1431)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(605),h0tab(:,605),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,99))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,109),heltab2x128(:,:,605))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(77),n2h32(109))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1432)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(606),h0tab(:,606),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,371))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,110),heltab2x128(:,:,606))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(78),n2h32(110))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1433)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(607),h0tab(:,607),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,101))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,111),heltab2x128(:,:,607))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(79),n2h32(111))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1434)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(608),h0tab(:,608),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,372))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,112),heltab2x128(:,:,608))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(80),n2h32(112))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1059)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(609),h0tab(:,609),[64,31,32],[0,0,0],3,1,wf32(:,226))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,209),heltab2x128(:,:,609))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(81),n2h64(209))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1060)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(610),h0tab(:,610),[64,31,32],[0,0,0],3,1,wf32(:,228))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,210),heltab2x128(:,:,610))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(82),n2h64(210))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1061)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(611),h0tab(:,611),[64,31,32],[0,0,0],3,1,wf32(:,230))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,211),heltab2x128(:,:,611))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(83),n2h64(211))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1062)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(612),h0tab(:,612),[64,31,32],[0,0,0],3,1,wf32(:,232))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,212),heltab2x128(:,:,612))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(84),n2h64(212))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1063)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(613),h0tab(:,613),[64,16,47],[0,0,0],3,1,wf32(:,234))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,213),heltab2x128(:,:,613))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(85),n2h64(213))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1064)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(614),h0tab(:,614),[64,16,47],[0,0,0],3,1,wf32(:,236))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,214),heltab2x128(:,:,614))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(86),n2h64(214))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1065)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(615),h0tab(:,615),[64,16,47],[0,0,0],3,1,wf32(:,238))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,215),heltab2x128(:,:,615))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(87),n2h64(215))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1066)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(616),h0tab(:,616),[64,16,47],[0,0,0],3,1,wf32(:,240))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,216),heltab2x128(:,:,616))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(88),n2h64(216))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1068)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(617),h0tab(:,617),[79,16,32],[0,0,0],3,1,wf32(:,241))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,241),G0H4(1),m3h32x4(:,65),heltab2x128(:,:,617))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(81),n2h4(145))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1069)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(618),h0tab(:,618),[79,16,32],[0,0,0],3,1,wf32(:,243))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,243),G0H4(1),ngZd,m3h32x4(:,66),heltab2x128(:,:,618))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(82),n2h4(146))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1071)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(619),h0tab(:,619),[79,16,32],[0,0,0],3,1,wf32(:,244))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,244),G0H4(1),m3h32x4(:,67),heltab2x128(:,:,619))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(83),n2h4(147))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1072)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(620),h0tab(:,620),[79,16,32],[0,0,0],3,1,wf32(:,246))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,246),G0H4(1),ngZd,m3h32x4(:,68),heltab2x128(:,:,620))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(84),n2h4(148))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1073)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(621),h0tab(:,621),[64,31,32],[0,0,0],3,1,wf32(:,248))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,217),heltab2x128(:,:,621))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(89),n2h64(217))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1074)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(622),h0tab(:,622),[64,31,32],[0,0,0],3,1,wf32(:,250))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,218),heltab2x128(:,:,622))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(90),n2h64(218))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1075)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(623),h0tab(:,623),[64,31,32],[0,0,0],3,1,wf32(:,252))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,219),heltab2x128(:,:,623))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(91),n2h64(219))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1076)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(624),h0tab(:,624),[64,31,32],[0,0,0],3,1,wf32(:,254))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,220),heltab2x128(:,:,624))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(92),n2h64(220))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1077)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(625),h0tab(:,625),[64,16,47],[0,0,0],3,1,wf32(:,256))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,221),heltab2x128(:,:,625))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(93),n2h64(221))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1078)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(626),h0tab(:,626),[64,16,47],[0,0,0],3,1,wf32(:,258))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,222),heltab2x128(:,:,626))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(94),n2h64(222))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1079)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(627),h0tab(:,627),[64,16,47],[0,0,0],3,1,wf32(:,260))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,223),heltab2x128(:,:,627))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(95),n2h64(223))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1080)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(628),h0tab(:,628),[64,16,47],[0,0,0],3,1,wf32(:,262))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,224),heltab2x128(:,:,628))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(96),n2h64(224))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1082)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(629),h0tab(:,629),[79,16,32],[0,0,0],3,1,wf32(:,263))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,263),G0H4(1),m3h32x4(:,69),heltab2x128(:,:,629))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(85),n2h4(149))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1083)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(630),h0tab(:,630),[79,16,32],[0,0,0],3,1,wf32(:,265))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,265),G0H4(1),ngZd,m3h32x4(:,70),heltab2x128(:,:,630))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(86),n2h4(150))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1085)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(631),h0tab(:,631),[79,16,32],[0,0,0],3,1,wf32(:,266))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,266),G0H4(1),m3h32x4(:,71),heltab2x128(:,:,631))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(87),n2h4(151))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1086)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(632),h0tab(:,632),[79,16,32],[0,0,0],3,1,wf32(:,268))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,268),G0H4(1),ngZd,m3h32x4(:,72),heltab2x128(:,:,632))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(88),n2h4(152))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(379)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(633),h0tab(:,633),[69,26,32],[0,0,0],3,2,wf8(:,105),wf8(:,14))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,105),G0H16(1),m3h8x16(:,113),heltab2x128(:,:,633))
  call Hloop_A_Q(ntryL,G0H16(1),69,0,G1H16(29),n2h16(177))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(382)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(634),h0tab(:,634),[69,26,32],[0,0,0],3,2,wf8(:,107),wf8(:,14))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,107),G0H16(1),ngZd,m3h8x16(:,114),heltab2x128(:,:,634))
  call Hloop_A_Q(ntryL,G0H16(1),69,0,G1H16(18),n2h16(178))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(383)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(635),h0tab(:,635),[69,26,32],[0,0,0],3,2,wf8(:,105),wf8(:,16))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,105),G0H16(1),m3h8x16(:,115),heltab2x128(:,:,635))
  call Hloop_A_Q(ntryL,G0H16(1),69,0,G1H16(17),n2h16(179))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(384)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(636),h0tab(:,636),[69,26,32],[0,0,0],3,2,wf8(:,107),wf8(:,16))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,107),G0H16(1),ngZd,m3h8x16(:,116),heltab2x128(:,:,636))
  call Hloop_A_Q(ntryL,G0H16(1),69,0,G1H16(30),n2h16(180))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(385)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(637),h0tab(:,637),[69,16,42],[0,0,0],3,2,wf8(:,105),wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,105),G0H16(1),m3h8x16(:,117),heltab2x128(:,:,637))
  call Hloop_A_Q(ntryL,G0H16(1),69,0,G1H16(31),n2h16(181))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(386)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(638),h0tab(:,638),[69,16,42],[0,0,0],3,2,wf8(:,107),wf8(:,6))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,107),G0H16(1),ngZd,m3h8x16(:,118),heltab2x128(:,:,638))
  call Hloop_A_Q(ntryL,G0H16(1),69,0,G1H16(32),n2h16(182))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(387)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(639),h0tab(:,639),[69,16,42],[0,0,0],3,2,wf8(:,105),wf8(:,8))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,105),G0H16(1),m3h8x16(:,119),heltab2x128(:,:,639))
  call Hloop_A_Q(ntryL,G0H16(1),69,0,G1H16(27),n2h16(183))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(388)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(640),h0tab(:,640),[69,16,42],[0,0,0],3,2,wf8(:,107),wf8(:,8))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,107),G0H16(1),ngZd,m3h8x16(:,120),heltab2x128(:,:,640))
  call Hloop_A_Q(ntryL,G0H16(1),69,0,G1H16(28),n2h16(184))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1435)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(641),h0tab(:,641),[85,10,32],[0,0,0],3,2,wf16(:,375),wf4(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,375),G0H8(1),m3h16x8(:,113),heltab2x128(:,:,641))
  call Hloop_Q_A(ntryL,G0H8(1),85,0,G1H8(161),n2h8(161))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1436)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(642),h0tab(:,642),[85,10,32],[0,0,0],3,2,wf16(:,376),wf4(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,376),G0H8(1),m3h16x8(:,114),heltab2x128(:,:,642))
  call Hloop_Q_A(ntryL,G0H8(1),85,0,G1H8(162),n2h8(162))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1437)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(643),h0tab(:,643),[85,10,32],[0,0,0],3,2,wf16(:,375),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,375),G0H8(1),m3h16x8(:,115),heltab2x128(:,:,643))
  call Hloop_Q_A(ntryL,G0H8(1),85,0,G1H8(163),n2h8(163))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1438)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(644),h0tab(:,644),[85,10,32],[0,0,0],3,2,wf16(:,376),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,376),G0H8(1),m3h16x8(:,116),heltab2x128(:,:,644))
  call Hloop_Q_A(ntryL,G0H8(1),85,0,G1H8(164),n2h8(164))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1439)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(645),h0tab(:,645),[101,10,16],[0,0,0],3,2,wf16(:,373),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,373),G0H8(1),m3h16x8(:,117),heltab2x128(:,:,645))
  call Hloop_A_Q(ntryL,G0H8(1),101,0,G1H8(165),n2h8(165))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1440)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(646),h0tab(:,646),[101,10,16],[0,0,0],3,2,wf16(:,374),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,374),G0H8(1),m3h16x8(:,118),heltab2x128(:,:,646))
  call Hloop_A_Q(ntryL,G0H8(1),101,0,G1H8(166),n2h8(166))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1441)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(647),h0tab(:,647),[101,10,16],[0,0,0],3,2,wf16(:,373),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,373),G0H8(1),m3h16x8(:,119),heltab2x128(:,:,647))
  call Hloop_A_Q(ntryL,G0H8(1),101,0,G1H8(167),n2h8(167))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1442)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(648),h0tab(:,648),[101,10,16],[0,0,0],3,2,wf16(:,374),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,374),G0H8(1),m3h16x8(:,120),heltab2x128(:,:,648))
  call Hloop_A_Q(ntryL,G0H8(1),101,0,G1H8(168),n2h8(168))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1088)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(649),h0tab(:,649),[79,16,32],[0,0,0],3,1,wf32(:,269))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,269),G0H4(1),m3h32x4(:,73),heltab2x128(:,:,649))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(89),n2h4(153))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1089)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(650),h0tab(:,650),[79,16,32],[0,0,0],3,1,wf32(:,271))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,271),G0H4(1),ngZd,m3h32x4(:,74),heltab2x128(:,:,650))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(90),n2h4(154))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1091)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(651),h0tab(:,651),[79,16,32],[0,0,0],3,1,wf32(:,272))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,272),G0H4(1),m3h32x4(:,75),heltab2x128(:,:,651))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(91),n2h4(155))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1092)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(652),h0tab(:,652),[79,16,32],[0,0,0],3,1,wf32(:,274))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,274),G0H4(1),ngZd,m3h32x4(:,76),heltab2x128(:,:,652))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(92),n2h4(156))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1094)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(653),h0tab(:,653),[79,16,32],[0,0,0],3,1,wf32(:,275))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,275),G0H4(1),m3h32x4(:,77),heltab2x128(:,:,653))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(93),n2h4(157))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1095)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(654),h0tab(:,654),[79,16,32],[0,0,0],3,1,wf32(:,277))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,277),G0H4(1),ngZd,m3h32x4(:,78),heltab2x128(:,:,654))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(94),n2h4(158))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1097)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(655),h0tab(:,655),[79,16,32],[0,0,0],3,1,wf32(:,278))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,278),G0H4(1),m3h32x4(:,79),heltab2x128(:,:,655))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(95),n2h4(159))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1098)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(656),h0tab(:,656),[79,16,32],[0,0,0],3,1,wf32(:,280))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,280),G0H4(1),ngZd,m3h32x4(:,80),heltab2x128(:,:,656))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(96),n2h4(160))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(657),h0tab(:,657),[79,16,32],[0,0,0],3,1,wf32(:,281))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,281),G0H4(1),m3h32x4(:,81),heltab2x128(:,:,657))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(97),n2h4(161))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1101)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(658),h0tab(:,658),[79,16,32],[0,0,0],3,1,wf32(:,283))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,283),G0H4(1),ngZd,m3h32x4(:,82),heltab2x128(:,:,658))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(98),n2h4(162))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(659),h0tab(:,659),[79,16,32],[0,0,0],3,1,wf32(:,284))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,284),G0H4(1),m3h32x4(:,83),heltab2x128(:,:,659))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(99),n2h4(163))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(660),h0tab(:,660),[79,16,32],[0,0,0],3,1,wf32(:,286))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,286),G0H4(1),ngZd,m3h32x4(:,84),heltab2x128(:,:,660))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(100),n2h4(164))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1447)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(661),h0tab(:,661),[85,10,32],[0,0,0],3,2,wf16(:,377),wf4(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,377),G0H8(1),m3h16x8(:,121),heltab2x128(:,:,661))
  call Hloop_Q_A(ntryL,G0H8(1),85,0,G1H8(169),n2h8(169))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1448)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(662),h0tab(:,662),[85,10,32],[0,0,0],3,2,wf16(:,377),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,377),G0H8(1),m3h16x8(:,122),heltab2x128(:,:,662))
  call Hloop_Q_A(ntryL,G0H8(1),85,0,G1H8(170),n2h8(170))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1449)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(663),h0tab(:,663),[85,10,32],[0,0,0],3,2,wf16(:,378),wf4(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,378),G0H8(1),m3h16x8(:,123),heltab2x128(:,:,663))
  call Hloop_Q_A(ntryL,G0H8(1),85,0,G1H8(171),n2h8(171))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1450)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(664),h0tab(:,664),[85,10,32],[0,0,0],3,2,wf16(:,378),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,378),G0H8(1),m3h16x8(:,124),heltab2x128(:,:,664))
  call Hloop_Q_A(ntryL,G0H8(1),85,0,G1H8(172),n2h8(172))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1451)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(665),h0tab(:,665),[101,10,16],[0,0,0],3,2,wf16(:,379),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,379),G0H8(1),m3h16x8(:,125),heltab2x128(:,:,665))
  call Hloop_A_Q(ntryL,G0H8(1),101,0,G1H8(173),n2h8(173))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1452)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(666),h0tab(:,666),[101,10,16],[0,0,0],3,2,wf16(:,379),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,379),G0H8(1),m3h16x8(:,126),heltab2x128(:,:,666))
  call Hloop_A_Q(ntryL,G0H8(1),101,0,G1H8(174),n2h8(174))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1453)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(667),h0tab(:,667),[101,10,16],[0,0,0],3,2,wf16(:,380),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,380),G0H8(1),m3h16x8(:,127),heltab2x128(:,:,667))
  call Hloop_A_Q(ntryL,G0H8(1),101,0,G1H8(175),n2h8(175))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1454)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(668),h0tab(:,668),[101,10,16],[0,0,0],3,2,wf16(:,380),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,380),G0H8(1),m3h16x8(:,128),heltab2x128(:,:,668))
  call Hloop_A_Q(ntryL,G0H8(1),101,0,G1H8(176),n2h8(176))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(395)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(669),h0tab(:,669),[69,26,32],[0,0,0],3,2,wf8(:,108),wf8(:,14))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,108),G0H16(1),m3h8x16(:,121),heltab2x128(:,:,669))
  call Hloop_A_Q(ntryL,G0H16(1),69,0,G1H16(42),n2h16(185))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(396)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(670),h0tab(:,670),[69,26,32],[0,0,0],3,2,wf8(:,108),wf8(:,16))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,108),G0H16(1),m3h8x16(:,122),heltab2x128(:,:,670))
  call Hloop_A_Q(ntryL,G0H16(1),69,0,G1H16(44),n2h16(186))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(397)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(671),h0tab(:,671),[69,26,32],[0,0,0],3,2,wf8(:,110),wf8(:,14))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,110),G0H16(1),ngZd,m3h8x16(:,123),heltab2x128(:,:,671))
  call Hloop_A_Q(ntryL,G0H16(1),69,0,G1H16(46),n2h16(187))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(398)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(672),h0tab(:,672),[69,26,32],[0,0,0],3,2,wf8(:,110),wf8(:,16))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,110),G0H16(1),ngZd,m3h8x16(:,124),heltab2x128(:,:,672))
  call Hloop_A_Q(ntryL,G0H16(1),69,0,G1H16(48),n2h16(188))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(390)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(673),h0tab(:,673),[69,16,42],[0,0,0],3,2,wf8(:,108),wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,108),G0H16(1),m3h8x16(:,125),heltab2x128(:,:,673))
  call Hloop_A_Q(ntryL,G0H16(1),69,0,G1H16(63),n2h16(189))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(391)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(674),h0tab(:,674),[69,16,42],[0,0,0],3,2,wf8(:,108),wf8(:,8))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,108),G0H16(1),m3h8x16(:,126),heltab2x128(:,:,674))
  call Hloop_A_Q(ntryL,G0H16(1),69,0,G1H16(64),n2h16(190))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(393)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(675),h0tab(:,675),[69,16,42],[0,0,0],3,2,wf8(:,110),wf8(:,6))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,110),G0H16(1),ngZd,m3h8x16(:,127),heltab2x128(:,:,675))
  call Hloop_A_Q(ntryL,G0H16(1),69,0,G1H16(59),n2h16(191))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(394)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(676),h0tab(:,676),[69,16,42],[0,0,0],3,2,wf8(:,110),wf8(:,8))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,110),G0H16(1),ngZd,m3h8x16(:,128),heltab2x128(:,:,676))
  call Hloop_A_Q(ntryL,G0H16(1),69,0,G1H16(60),n2h16(192))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(677),h0tab(:,677),[79,16,32],[0,0,0],3,1,wf32(:,287))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,287),G0H4(1),m3h32x4(:,85),heltab2x128(:,:,677))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(101),n2h4(165))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1108)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(678),h0tab(:,678),[79,16,32],[0,0,0],3,1,wf32(:,288))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,288),G0H4(1),m3h32x4(:,86),heltab2x128(:,:,678))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(102),n2h4(166))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1109)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(679),h0tab(:,679),[79,16,32],[0,0,0],3,1,wf32(:,290))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,290),G0H4(1),ngZd,m3h32x4(:,87),heltab2x128(:,:,679))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(103),n2h4(167))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(680),h0tab(:,680),[79,16,32],[0,0,0],3,1,wf32(:,292))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,292),G0H4(1),ngZd,m3h32x4(:,88),heltab2x128(:,:,680))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(104),n2h4(168))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1459)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(681),h0tab(:,681),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,117))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,113),heltab2x128(:,:,681))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(81),n2h32(113))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1460)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(682),h0tab(:,682),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,381))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,114),heltab2x128(:,:,682))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(82),n2h32(114))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1461)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(683),h0tab(:,683),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,119))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,115),heltab2x128(:,:,683))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(83),n2h32(115))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1462)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(684),h0tab(:,684),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,382))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,116),heltab2x128(:,:,684))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(84),n2h32(116))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1463)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(685),h0tab(:,685),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,121))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,117),heltab2x128(:,:,685))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(85),n2h32(117))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1464)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(686),h0tab(:,686),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,122))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,118),heltab2x128(:,:,686))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(86),n2h32(118))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1465)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(687),h0tab(:,687),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,383))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,119),heltab2x128(:,:,687))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(87),n2h32(119))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1466)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(688),h0tab(:,688),[80,15,32],[0,0,0],3,2,wf4(:,4),wf16(:,384))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,120),heltab2x128(:,:,688))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(88),n2h32(120))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1467)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(689),h0tab(:,689),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,117))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,121),heltab2x128(:,:,689))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(89),n2h32(121))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1468)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(690),h0tab(:,690),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,381))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,122),heltab2x128(:,:,690))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(90),n2h32(122))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1469)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(691),h0tab(:,691),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,119))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,123),heltab2x128(:,:,691))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(91),n2h32(123))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1470)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(692),h0tab(:,692),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,382))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,124),heltab2x128(:,:,692))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(92),n2h32(124))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1471)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(693),h0tab(:,693),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,121))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,125),heltab2x128(:,:,693))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(93),n2h32(125))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1472)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(694),h0tab(:,694),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,122))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,126),heltab2x128(:,:,694))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(94),n2h32(126))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1473)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(695),h0tab(:,695),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,383))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,127),heltab2x128(:,:,695))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(95),n2h32(127))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1474)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(696),h0tab(:,696),[96,15,16],[0,0,0],3,2,wf4(:,10),wf16(:,384))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,128),heltab2x128(:,:,696))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(96),n2h32(128))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(697),h0tab(:,697),[64,31,32],[0,0,0],3,1,wf32(:,294))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,225),heltab2x128(:,:,697))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(97),n2h64(225))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(698),h0tab(:,698),[64,31,32],[0,0,0],3,1,wf32(:,296))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,226),heltab2x128(:,:,698))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(98),n2h64(226))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(699),h0tab(:,699),[64,31,32],[0,0,0],3,1,wf32(:,298))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,227),heltab2x128(:,:,699))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(99),n2h64(227))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(700),h0tab(:,700),[64,31,32],[0,0,0],3,1,wf32(:,300))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,228),heltab2x128(:,:,700))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(100),n2h64(228))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1115)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(701),h0tab(:,701),[64,16,47],[0,0,0],3,1,wf32(:,302))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,229),heltab2x128(:,:,701))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(101),n2h64(229))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(702),h0tab(:,702),[64,16,47],[0,0,0],3,1,wf32(:,304))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,230),heltab2x128(:,:,702))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(102),n2h64(230))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(703),h0tab(:,703),[64,16,47],[0,0,0],3,1,wf32(:,306))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,231),heltab2x128(:,:,703))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(103),n2h64(231))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(704),h0tab(:,704),[64,16,47],[0,0,0],3,1,wf32(:,308))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,232),heltab2x128(:,:,704))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(104),n2h64(232))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1120)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(705),h0tab(:,705),[79,16,32],[0,0,0],3,1,wf32(:,309))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,309),G0H4(1),m3h32x4(:,89),heltab2x128(:,:,705))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(105),n2h4(169))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1121)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(706),h0tab(:,706),[79,16,32],[0,0,0],3,1,wf32(:,311))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,311),G0H4(1),ngZd,m3h32x4(:,90),heltab2x128(:,:,706))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(106),n2h4(170))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(707),h0tab(:,707),[79,16,32],[0,0,0],3,1,wf32(:,312))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,312),G0H4(1),m3h32x4(:,91),heltab2x128(:,:,707))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(107),n2h4(171))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(708),h0tab(:,708),[79,16,32],[0,0,0],3,1,wf32(:,314))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,314),G0H4(1),ngZd,m3h32x4(:,92),heltab2x128(:,:,708))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(108),n2h4(172))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(709),h0tab(:,709),[64,31,32],[0,0,0],3,1,wf32(:,316))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,233),heltab2x128(:,:,709))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(105),n2h64(233))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(710),h0tab(:,710),[64,31,32],[0,0,0],3,1,wf32(:,318))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,234),heltab2x128(:,:,710))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(106),n2h64(234))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(711),h0tab(:,711),[64,31,32],[0,0,0],3,1,wf32(:,320))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,235),heltab2x128(:,:,711))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(107),n2h64(235))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(712),h0tab(:,712),[64,31,32],[0,0,0],3,1,wf32(:,322))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,236),heltab2x128(:,:,712))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(108),n2h64(236))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1129)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(713),h0tab(:,713),[64,16,47],[0,0,0],3,1,wf32(:,324))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,237),heltab2x128(:,:,713))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(109),n2h64(237))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1130)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(714),h0tab(:,714),[64,16,47],[0,0,0],3,1,wf32(:,326))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,238),heltab2x128(:,:,714))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(110),n2h64(238))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1131)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(715),h0tab(:,715),[64,16,47],[0,0,0],3,1,wf32(:,328))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,239),heltab2x128(:,:,715))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(111),n2h64(239))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(716),h0tab(:,716),[64,16,47],[0,0,0],3,1,wf32(:,330))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,240),heltab2x128(:,:,716))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(112),n2h64(240))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1134)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(717),h0tab(:,717),[79,16,32],[0,0,0],3,1,wf32(:,331))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,331),G0H4(1),m3h32x4(:,93),heltab2x128(:,:,717))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(109),n2h4(173))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(718),h0tab(:,718),[79,16,32],[0,0,0],3,1,wf32(:,332))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,332),G0H4(1),m3h32x4(:,94),heltab2x128(:,:,718))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(110),n2h4(174))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1137)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(719),h0tab(:,719),[79,16,32],[0,0,0],3,1,wf32(:,334))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,334),G0H4(1),ngZd,m3h32x4(:,95),heltab2x128(:,:,719))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(111),n2h4(175))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(720),h0tab(:,720),[79,16,32],[0,0,0],3,1,wf32(:,336))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,336),G0H4(1),ngZd,m3h32x4(:,96),heltab2x128(:,:,720))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(112),n2h4(176))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(721),h0tab(:,721),[79,16,32],[0,0,0],3,1,wf32(:,337))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,337),G0H4(1),m3h32x4(:,97),heltab2x128(:,:,721))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(113),n2h4(177))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1141)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(722),h0tab(:,722),[79,16,32],[0,0,0],3,1,wf32(:,339))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,339),G0H4(1),ngZd,m3h32x4(:,98),heltab2x128(:,:,722))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(114),n2h4(178))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1143)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(723),h0tab(:,723),[79,16,32],[0,0,0],3,1,wf32(:,340))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,340),G0H4(1),m3h32x4(:,99),heltab2x128(:,:,723))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(115),n2h4(179))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1144)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(724),h0tab(:,724),[79,16,32],[0,0,0],3,1,wf32(:,342))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,342),G0H4(1),ngZd,m3h32x4(:,100),heltab2x128(:,:,724))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(116),n2h4(180))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1146)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(725),h0tab(:,725),[79,16,32],[0,0,0],3,1,wf32(:,343))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,343),G0H4(1),m3h32x4(:,101),heltab2x128(:,:,725))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(117),n2h4(181))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1148)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(726),h0tab(:,726),[79,16,32],[0,0,0],3,1,wf32(:,344))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,344),G0H4(1),m3h32x4(:,102),heltab2x128(:,:,726))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(118),n2h4(182))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1149)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(727),h0tab(:,727),[79,16,32],[0,0,0],3,1,wf32(:,346))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,346),G0H4(1),ngZd,m3h32x4(:,103),heltab2x128(:,:,727))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(119),n2h4(183))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1150)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(728),h0tab(:,728),[79,16,32],[0,0,0],3,1,wf32(:,348))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,348),G0H4(1),ngZd,m3h32x4(:,104),heltab2x128(:,:,728))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(120),n2h4(184))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1152)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(729),h0tab(:,729),[79,16,32],[0,0,0],3,1,wf32(:,349))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,349),G0H4(1),m3h32x4(:,105),heltab2x128(:,:,729))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(121),n2h4(185))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1153)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(730),h0tab(:,730),[79,16,32],[0,0,0],3,1,wf32(:,351))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,351),G0H4(1),ngZd,m3h32x4(:,106),heltab2x128(:,:,730))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(122),n2h4(186))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1155)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(731),h0tab(:,731),[79,16,32],[0,0,0],3,1,wf32(:,352))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,352),G0H4(1),m3h32x4(:,107),heltab2x128(:,:,731))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(123),n2h4(187))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1156)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(732),h0tab(:,732),[79,16,32],[0,0,0],3,1,wf32(:,354))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,354),G0H4(1),ngZd,m3h32x4(:,108),heltab2x128(:,:,732))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(124),n2h4(188))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1158)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(733),h0tab(:,733),[79,16,32],[0,0,0],3,1,wf32(:,355))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,355),G0H4(1),m3h32x4(:,109),heltab2x128(:,:,733))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(125),n2h4(189))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1160)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(734),h0tab(:,734),[79,16,32],[0,0,0],3,1,wf32(:,356))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,356),G0H4(1),m3h32x4(:,110),heltab2x128(:,:,734))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(126),n2h4(190))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1161)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(735),h0tab(:,735),[79,16,32],[0,0,0],3,1,wf32(:,358))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,358),G0H4(1),ngZd,m3h32x4(:,111),heltab2x128(:,:,735))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(127),n2h4(191))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1162)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(736),h0tab(:,736),[79,16,32],[0,0,0],3,1,wf32(:,360))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,360),G0H4(1),ngZd,m3h32x4(:,112),heltab2x128(:,:,736))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(128),n2h4(192))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1164)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(737),h0tab(:,737),[79,16,32],[0,0,0],3,1,wf32(:,361))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,361),G0H4(1),m3h32x4(:,113),heltab2x128(:,:,737))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(129),n2h4(193))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1165)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(738),h0tab(:,738),[79,16,32],[0,0,0],3,1,wf32(:,363))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,363),G0H4(1),ngZd,m3h32x4(:,114),heltab2x128(:,:,738))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(130),n2h4(194))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1167)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(739),h0tab(:,739),[79,16,32],[0,0,0],3,1,wf32(:,364))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,364),G0H4(1),m3h32x4(:,115),heltab2x128(:,:,739))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(131),n2h4(195))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1168)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(740),h0tab(:,740),[79,16,32],[0,0,0],3,1,wf32(:,366))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,366),G0H4(1),ngZd,m3h32x4(:,116),heltab2x128(:,:,740))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(132),n2h4(196))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1170)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(741),h0tab(:,741),[79,16,32],[0,0,0],3,1,wf32(:,367))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,367),G0H4(1),m3h32x4(:,117),heltab2x128(:,:,741))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(133),n2h4(197))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1171)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(742),h0tab(:,742),[79,16,32],[0,0,0],3,1,wf32(:,369))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,369),G0H4(1),ngZd,m3h32x4(:,118),heltab2x128(:,:,742))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(134),n2h4(198))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1173)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(743),h0tab(:,743),[79,16,32],[0,0,0],3,1,wf32(:,370))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,370),G0H4(1),m3h32x4(:,119),heltab2x128(:,:,743))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(135),n2h4(199))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1174)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(744),h0tab(:,744),[79,16,32],[0,0,0],3,1,wf32(:,372))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,372),G0H4(1),ngZd,m3h32x4(:,120),heltab2x128(:,:,744))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(136),n2h4(200))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1176)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(745),h0tab(:,745),[79,16,32],[0,0,0],3,1,wf32(:,373))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,373),G0H4(1),m3h32x4(:,121),heltab2x128(:,:,745))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(137),n2h4(201))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1178)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(746),h0tab(:,746),[79,16,32],[0,0,0],3,1,wf32(:,374))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,374),G0H4(1),m3h32x4(:,122),heltab2x128(:,:,746))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(138),n2h4(202))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1179)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(747),h0tab(:,747),[79,16,32],[0,0,0],3,1,wf32(:,376))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,376),G0H4(1),ngZd,m3h32x4(:,123),heltab2x128(:,:,747))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(139),n2h4(203))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1180)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(748),h0tab(:,748),[79,16,32],[0,0,0],3,1,wf32(:,378))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,378),G0H4(1),ngZd,m3h32x4(:,124),heltab2x128(:,:,748))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(140),n2h4(204))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1182)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(749),h0tab(:,749),[79,16,32],[0,0,0],3,1,wf32(:,379))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,379),G0H4(1),m3h32x4(:,125),heltab2x128(:,:,749))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(141),n2h4(205))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1184)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(750),h0tab(:,750),[79,16,32],[0,0,0],3,1,wf32(:,380))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,380),G0H4(1),m3h32x4(:,126),heltab2x128(:,:,750))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(142),n2h4(206))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(751),h0tab(:,751),[79,16,32],[0,0,0],3,1,wf32(:,382))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,382),G0H4(1),ngZd,m3h32x4(:,127),heltab2x128(:,:,751))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(143),n2h4(207))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1186)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(752),h0tab(:,752),[79,16,32],[0,0,0],3,1,wf32(:,384))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,384),G0H4(1),ngZd,m3h32x4(:,128),heltab2x128(:,:,752))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(144),n2h4(208))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1188)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(753),h0tab(:,753),[79,16,32],[0,0,0],3,1,wf32(:,385))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,385),G0H4(1),m3h32x4(:,129),heltab2x128(:,:,753))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(145),n2h4(209))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1189)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(754),h0tab(:,754),[79,16,32],[0,0,0],3,1,wf32(:,387))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,387),G0H4(1),ngZd,m3h32x4(:,130),heltab2x128(:,:,754))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(146),n2h4(210))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1191)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(755),h0tab(:,755),[79,16,32],[0,0,0],3,1,wf32(:,388))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,388),G0H4(1),m3h32x4(:,131),heltab2x128(:,:,755))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(147),n2h4(211))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1192)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(756),h0tab(:,756),[79,16,32],[0,0,0],3,1,wf32(:,390))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,390),G0H4(1),ngZd,m3h32x4(:,132),heltab2x128(:,:,756))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(148),n2h4(212))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1194)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(757),h0tab(:,757),[79,16,32],[0,0,0],3,1,wf32(:,391))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,391),G0H4(1),m3h32x4(:,133),heltab2x128(:,:,757))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(149),n2h4(213))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1195)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(758),h0tab(:,758),[79,16,32],[0,0,0],3,1,wf32(:,393))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,393),G0H4(1),ngZd,m3h32x4(:,134),heltab2x128(:,:,758))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(150),n2h4(214))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1197)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(759),h0tab(:,759),[79,16,32],[0,0,0],3,1,wf32(:,394))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,394),G0H4(1),m3h32x4(:,135),heltab2x128(:,:,759))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(151),n2h4(215))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1198)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(760),h0tab(:,760),[79,16,32],[0,0,0],3,1,wf32(:,396))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,396),G0H4(1),ngZd,m3h32x4(:,136),heltab2x128(:,:,760))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(152),n2h4(216))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1200)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(761),h0tab(:,761),[79,16,32],[0,0,0],3,1,wf32(:,397))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,397),G0H4(1),m3h32x4(:,137),heltab2x128(:,:,761))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(153),n2h4(217))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1201)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(762),h0tab(:,762),[79,16,32],[0,0,0],3,1,wf32(:,399))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,399),G0H4(1),ngZd,m3h32x4(:,138),heltab2x128(:,:,762))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(154),n2h4(218))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1203)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(763),h0tab(:,763),[79,16,32],[0,0,0],3,1,wf32(:,400))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,400),G0H4(1),m3h32x4(:,139),heltab2x128(:,:,763))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(155),n2h4(219))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1204)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(764),h0tab(:,764),[79,16,32],[0,0,0],3,1,wf32(:,402))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,402),G0H4(1),ngZd,m3h32x4(:,140),heltab2x128(:,:,764))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(156),n2h4(220))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1206)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(765),h0tab(:,765),[79,16,32],[0,0,0],3,1,wf32(:,403))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,403),G0H4(1),m3h32x4(:,141),heltab2x128(:,:,765))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(157),n2h4(221))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1208)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(766),h0tab(:,766),[79,16,32],[0,0,0],3,1,wf32(:,404))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,404),G0H4(1),m3h32x4(:,142),heltab2x128(:,:,766))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(158),n2h4(222))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1209)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(767),h0tab(:,767),[79,16,32],[0,0,0],3,1,wf32(:,406))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,406),G0H4(1),ngZd,m3h32x4(:,143),heltab2x128(:,:,767))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(159),n2h4(223))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1210)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(768),h0tab(:,768),[79,16,32],[0,0,0],3,1,wf32(:,408))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,408),G0H4(1),ngZd,m3h32x4(:,144),heltab2x128(:,:,768))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(160),n2h4(224))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1212)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(769),h0tab(:,769),[79,16,32],[0,0,0],3,1,wf32(:,409))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,409),G0H4(1),m3h32x4(:,145),heltab2x128(:,:,769))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(161),n2h4(225))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1213)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(770),h0tab(:,770),[79,16,32],[0,0,0],3,1,wf32(:,411))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,411),G0H4(1),ngZd,m3h32x4(:,146),heltab2x128(:,:,770))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(162),n2h4(226))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(771),h0tab(:,771),[79,16,32],[0,0,0],3,1,wf32(:,412))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,412),G0H4(1),m3h32x4(:,147),heltab2x128(:,:,771))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(163),n2h4(227))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(772),h0tab(:,772),[79,16,32],[0,0,0],3,1,wf32(:,414))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,414),G0H4(1),ngZd,m3h32x4(:,148),heltab2x128(:,:,772))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(164),n2h4(228))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(773),h0tab(:,773),[79,16,32],[0,0,0],3,1,wf32(:,415))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,415),G0H4(1),m3h32x4(:,149),heltab2x128(:,:,773))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(165),n2h4(229))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(774),h0tab(:,774),[79,16,32],[0,0,0],3,1,wf32(:,417))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,417),G0H4(1),ngZd,m3h32x4(:,150),heltab2x128(:,:,774))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(166),n2h4(230))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(775),h0tab(:,775),[79,16,32],[0,0,0],3,1,wf32(:,418))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,418),G0H4(1),m3h32x4(:,151),heltab2x128(:,:,775))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(167),n2h4(231))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(776),h0tab(:,776),[79,16,32],[0,0,0],3,1,wf32(:,420))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,420),G0H4(1),ngZd,m3h32x4(:,152),heltab2x128(:,:,776))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(168),n2h4(232))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1224)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(777),h0tab(:,777),[79,16,32],[0,0,0],3,1,wf32(:,421))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,421),G0H4(1),m3h32x4(:,153),heltab2x128(:,:,777))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(169),n2h4(233))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1225)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(778),h0tab(:,778),[79,16,32],[0,0,0],3,1,wf32(:,423))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,423),G0H4(1),ngZd,m3h32x4(:,154),heltab2x128(:,:,778))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(170),n2h4(234))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1227)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(779),h0tab(:,779),[79,16,32],[0,0,0],3,1,wf32(:,424))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,424),G0H4(1),m3h32x4(:,155),heltab2x128(:,:,779))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(171),n2h4(235))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1228)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(780),h0tab(:,780),[79,16,32],[0,0,0],3,1,wf32(:,426))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,426),G0H4(1),ngZd,m3h32x4(:,156),heltab2x128(:,:,780))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(172),n2h4(236))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1230)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(781),h0tab(:,781),[79,16,32],[0,0,0],3,1,wf32(:,427))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,427),G0H4(1),m3h32x4(:,157),heltab2x128(:,:,781))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(173),n2h4(237))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(782),h0tab(:,782),[79,16,32],[0,0,0],3,1,wf32(:,428))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,428),G0H4(1),m3h32x4(:,158),heltab2x128(:,:,782))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(174),n2h4(238))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(783),h0tab(:,783),[79,16,32],[0,0,0],3,1,wf32(:,430))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,430),G0H4(1),ngZd,m3h32x4(:,159),heltab2x128(:,:,783))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(175),n2h4(239))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(784),h0tab(:,784),[79,16,32],[0,0,0],3,1,wf32(:,432))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,432),G0H4(1),ngZd,m3h32x4(:,160),heltab2x128(:,:,784))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(176),n2h4(240))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(86),[G1H8(83),G1H8(70),G1H8(69),G1H8(52),G1H8(51) &
    ,G1H8(12),G1H8(9),G1H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(88),[G1H8(87),G1H8(75),G1H8(71),G1H8(57),G1H8(56) &
    ,G1H8(15),G1H8(14),G1H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(171),[G1H8(169),G1H8(162),G1H8(161),G1H8(39),G1H8(34) &
    ,G1H8(6),G1H8(1),G1H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(172),[G1H8(170),G1H8(164),G1H8(163),G1H8(40),G1H8(37) &
    ,G1H8(7),G1H8(2),G1H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(92),[G1H8(91),G1H8(77),G1H8(76),G1H8(62),G1H8(59) &
    ,G1H8(27),G1H8(26),G1H8(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(96),[G1H8(93),G1H8(82),G1H8(81),G1H8(65),G1H8(64) &
    ,G1H8(32),G1H8(31),G1H8(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(175),[G1H8(173),G1H8(166),G1H8(165),G1H8(46),G1H8(44) &
    ,G1H8(21),G1H8(19),G1H8(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(176),[G1H8(174),G1H8(168),G1H8(167),G1H8(50),G1H8(45) &
    ,G1H8(25),G1H8(20),G1H8(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(154),[G1H8(153),G1H8(146),G1H8(145),G1H8(122),G1H8(121) &
    ,G1H8(102),G1H8(101),G1H8(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(156),[G1H8(155),G1H8(148),G1H8(147),G1H8(124),G1H8(123) &
    ,G1H8(104),G1H8(103),G1H8(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(139),[G1H8(137),G1H8(130),G1H8(129),G1H8(115),G1H8(113) &
    ,G1H8(99),G1H8(97),G1H8(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(140),[G1H8(138),G1H8(132),G1H8(131),G1H8(116),G1H8(114) &
    ,G1H8(100),G1H8(98),G1H8(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(158),[G1H8(157),G1H8(150),G1H8(149),G1H8(126),G1H8(125) &
    ,G1H8(110),G1H8(109),G1H8(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(160),[G1H8(159),G1H8(152),G1H8(151),G1H8(128),G1H8(127) &
    ,G1H8(112),G1H8(111),G1H8(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(143),[G1H8(141),G1H8(134),G1H8(133),G1H8(119),G1H8(117) &
    ,G1H8(107),G1H8(105),G1H8(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(144),[G1H8(142),G1H8(136),G1H8(135),G1H8(120),G1H8(118) &
    ,G1H8(108),G1H8(106),G1H8(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(176),[G1H4(175),G1H4(174),G1H4(173),G1H4(172),G1H4(171) &
    ,G1H4(170),G1H4(169),G1H4(168),G1H4(167),G1H4(166),G1H4(165),G1H4(164),G1H4(163),G1H4(162),G1H4(161),G1H4(160),G1H4(159) &
    ,G1H4(158),G1H4(157),G1H4(156),G1H4(155),G1H4(154),G1H4(153),G1H4(152),G1H4(151),G1H4(150),G1H4(149),G1H4(148),G1H4(147) &
    ,G1H4(146),G1H4(145),G1H4(144),G1H4(143),G1H4(142),G1H4(141),G1H4(140),G1H4(139),G1H4(138),G1H4(137),G1H4(136),G1H4(135) &
    ,G1H4(134),G1H4(133),G1H4(132),G1H4(131),G1H4(130),G1H4(129),G1H4(128),G1H4(127),G1H4(126),G1H4(125),G1H4(124),G1H4(123) &
    ,G1H4(122),G1H4(121),G1H4(120),G1H4(119),G1H4(118),G1H4(117),G1H4(116),G1H4(115),G1H4(114),G1H4(113),G1H4(112),G1H4(111) &
    ,G1H4(110),G1H4(109),G1H4(108),G1H4(107),G1H4(106),G1H4(105),G1H4(104),G1H4(103),G1H4(102),G1H4(101),G1H4(100),G1H4(99) &
    ,G1H4(98),G1H4(97),G1H4(96),G1H4(95),G1H4(94),G1H4(93),G1H4(92),G1H4(91),G1H4(90),G1H4(89),G1H4(88),G1H4(87),G1H4(86),G1H4(85) &
    ,G1H4(84),G1H4(83),G1H4(82),G1H4(81),G1H4(80),G1H4(79),G1H4(78),G1H4(77),G1H4(76),G1H4(75),G1H4(74),G1H4(73),G1H4(72),G1H4(71) &
    ,G1H4(70),G1H4(69),G1H4(68),G1H4(67),G1H4(66),G1H4(65),G1H4(64),G1H4(63),G1H4(62),G1H4(61),G1H4(60),G1H4(59),G1H4(58),G1H4(57) &
    ,G1H4(56),G1H4(55),G1H4(54),G1H4(53),G1H4(52),G1H4(51),G1H4(50),G1H4(49),G1H4(48),G1H4(47),G1H4(46),G1H4(45),G1H4(44),G1H4(43) &
    ,G1H4(42),G1H4(41),G1H4(40),G1H4(39),G1H4(38),G1H4(37),G1H4(36),G1H4(35),G1H4(34),G1H4(33),G1H4(32),G1H4(31),G1H4(30),G1H4(29) &
    ,G1H4(28),G1H4(27),G1H4(26),G1H4(25),G1H4(24),G1H4(23),G1H4(22),G1H4(21),G1H4(20),G1H4(19),G1H4(18),G1H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(34),[G1H16(41),G1H16(19),G1H16(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(43),[G1H16(33),G1H16(22),G1H16(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(35),[G1H16(36),G1H16(26),G1H16(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(38),[G1H16(45),G1H16(23),G1H16(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(49),[G1H16(61),G1H16(12),G1H16(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(62),[G1H16(50),G1H16(16),G1H16(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(57),[G1H16(52),G1H16(47),G1H16(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(54),[G1H16(51),G1H16(39),G1H16(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(3),[G1H16(4),G1H16(58),G1H16(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(6),[G1H16(13),G1H16(55),G1H16(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(15),[G1H16(5),G1H16(2),G1H16(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(7),[G1H16(8),G1H16(11),G1H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(46),[G1H16(42),G1H16(18),G1H16(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(48),[G1H16(44),G1H16(30),G1H16(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(59),[G1H16(63),G1H16(32),G1H16(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(60),[G1H16(64),G1H16(28),G1H16(27)])
  call Hloop_QV_A(ntryL,G1H8(86),wf4(:,1),G1H2(1),m3h4x2(:,49),heltab2x8(:,:,113))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(1),n2h2(49))
  call Hloop_QZ_A(ntryL,G1H8(88),wf4(:,8),G1H2(2),ngZd,m3h4x2(:,50),heltab2x8(:,:,114))
  call Hloop_Q_A(ntryL,G1H2(2),95,0,G2H2(3),n2h2(50))
  call Hloop_QV_A(ntryL,G1H8(171),wf4(:,2),G1H2(5),m3h4x2(:,51),heltab2x8(:,:,115))
  call Hloop_Q_A(ntryL,G1H2(5),95,0,G2H2(5),n2h2(51))
  call Hloop_QZ_A(ntryL,G1H8(172),wf4(:,6),G1H2(6),ngZd,m3h4x2(:,52),heltab2x8(:,:,116))
  call Hloop_Q_A(ntryL,G1H2(6),95,0,G2H2(7),n2h2(52))
  call Hloop_AV_Q(ntryL,G1H8(92),wf4(:,1),G1H2(7),m3h4x2(:,53),heltab2x8(:,:,117))
  call Hloop_A_Q(ntryL,G1H2(7),111,0,G2H2(13),n2h2(53))
  call Hloop_AZ_Q(ntryL,G1H8(96),wf4(:,8),G1H2(10),ngZd,m3h4x2(:,54),heltab2x8(:,:,118))
  call Hloop_A_Q(ntryL,G1H2(10),111,0,G2H2(15),n2h2(54))
  call Hloop_AV_Q(ntryL,G1H8(175),wf4(:,2),G1H2(11),m3h4x2(:,55),heltab2x8(:,:,119))
  call Hloop_A_Q(ntryL,G1H2(11),111,0,G2H2(17),n2h2(55))
  call Hloop_AZ_Q(ntryL,G1H8(176),wf4(:,6),G1H2(12),ngZd,m3h4x2(:,56),heltab2x8(:,:,120))
  call Hloop_A_Q(ntryL,G1H2(12),111,0,G2H2(19),n2h2(56))
  call Hloop_QV_A(ntryL,G1H8(154),wf4(:,18),G1H2(15),m3h4x2(:,57),heltab2x8(:,:,121))
  call Hloop_Q_A(ntryL,G1H2(15),95,0,G2H2(27),n2h2(57))
  call Hloop_QZ_A(ntryL,G1H8(156),wf4(:,23),G1H2(16),ngZd,m3h4x2(:,58),heltab2x8(:,:,122))
  call Hloop_Q_A(ntryL,G1H2(16),95,0,G2H2(29),n2h2(58))
  call Hloop_QV_A(ntryL,G1H8(139),wf4(:,19),G1H2(17),m3h4x2(:,59),heltab2x8(:,:,123))
  call Hloop_Q_A(ntryL,G1H2(17),95,0,G2H2(33),n2h2(59))
  call Hloop_QZ_A(ntryL,G1H8(140),wf4(:,21),G1H2(20),ngZd,m3h4x2(:,60),heltab2x8(:,:,124))
  call Hloop_Q_A(ntryL,G1H2(20),95,0,G2H2(35),n2h2(60))
  call Hloop_AV_Q(ntryL,G1H8(158),wf4(:,18),G1H2(21),m3h4x2(:,61),heltab2x8(:,:,125))
  call Hloop_A_Q(ntryL,G1H2(21),111,0,G2H2(39),n2h2(61))
  call Hloop_AZ_Q(ntryL,G1H8(160),wf4(:,23),G1H2(22),ngZd,m3h4x2(:,62),heltab2x8(:,:,126))
  call Hloop_A_Q(ntryL,G1H2(22),111,0,G2H2(41),n2h2(62))
  call Hloop_AV_Q(ntryL,G1H8(143),wf4(:,19),G1H2(25),m3h4x2(:,63),heltab2x8(:,:,127))
  call Hloop_A_Q(ntryL,G1H2(25),111,0,G2H2(45),n2h2(63))
  call Hloop_AZ_Q(ntryL,G1H8(144),wf4(:,21),G1H2(26),ngZd,m3h4x2(:,64),heltab2x8(:,:,128))
  call Hloop_A_Q(ntryL,G1H2(26),111,0,G2H2(47),n2h2(64))
  call Hloop_QV_A(ntryL,G1H32(1),wf4(:,2),G1H8(83),m3h4x8(:,33),heltab2x32(:,:,33))
  call Hloop_Q_A(ntryL,G1H8(83),90,0,G2H8(2),n2h8(177))
  call Hloop_QZ_A(ntryL,G1H32(2),wf4(:,6),G1H8(70),ngZd,m3h4x8(:,34),heltab2x32(:,:,34))
  call Hloop_Q_A(ntryL,G1H8(70),90,0,G2H8(4),n2h8(178))
  call Hloop_QV_A(ntryL,G1H32(3),wf4(:,2),G1H8(69),m3h4x8(:,35),heltab2x32(:,:,35))
  call Hloop_Q_A(ntryL,G1H8(69),90,0,G2H8(7),n2h8(179))
  call Hloop_QZ_A(ntryL,G1H32(4),wf4(:,6),G1H8(52),ngZd,m3h4x8(:,36),heltab2x32(:,:,36))
  call Hloop_Q_A(ntryL,G1H8(52),90,0,G2H8(8),n2h8(180))
  call Hloop_QV_A(ntryL,G1H32(5),wf4(:,1),G1H8(51),m3h4x8(:,37),heltab2x32(:,:,37))
  call Hloop_Q_A(ntryL,G1H8(51),85,0,G2H8(10),n2h8(181))
  call Hloop_QV_A(ntryL,G1H32(6),wf4(:,1),G1H8(12),m3h4x8(:,38),heltab2x32(:,:,38))
  call Hloop_Q_A(ntryL,G1H8(12),85,0,G2H8(12),n2h8(182))
  call Hloop_QZ_A(ntryL,G1H32(7),wf4(:,8),G1H8(9),ngZd,m3h4x8(:,39),heltab2x32(:,:,39))
  call Hloop_Q_A(ntryL,G1H8(9),85,0,G2H8(15),n2h8(183))
  call Hloop_QZ_A(ntryL,G1H32(8),wf4(:,8),G1H8(3),ngZd,m3h4x8(:,40),heltab2x32(:,:,40))
  call Hloop_Q_A(ntryL,G1H8(3),85,0,G2H8(16),n2h8(184))
  call Hloop_AV_Q(ntryL,G1H32(9),wf4(:,2),G1H8(87),m3h4x8(:,41),heltab2x32(:,:,41))
  call Hloop_A_Q(ntryL,G1H8(87),106,0,G2H8(18),n2h8(185))
  call Hloop_AZ_Q(ntryL,G1H32(10),wf4(:,6),G1H8(75),ngZd,m3h4x8(:,42),heltab2x32(:,:,42))
  call Hloop_A_Q(ntryL,G1H8(75),106,0,G2H8(20),n2h8(186))
  call Hloop_AV_Q(ntryL,G1H32(11),wf4(:,2),G1H8(71),m3h4x8(:,43),heltab2x32(:,:,43))
  call Hloop_A_Q(ntryL,G1H8(71),106,0,G2H8(23),n2h8(187))
  call Hloop_AZ_Q(ntryL,G1H32(12),wf4(:,6),G1H8(57),ngZd,m3h4x8(:,44),heltab2x32(:,:,44))
  call Hloop_A_Q(ntryL,G1H8(57),106,0,G2H8(24),n2h8(188))
  call Hloop_AV_Q(ntryL,G1H32(13),wf4(:,1),G1H8(56),m3h4x8(:,45),heltab2x32(:,:,45))
  call Hloop_A_Q(ntryL,G1H8(56),101,0,G2H8(26),n2h8(189))
  call Hloop_AV_Q(ntryL,G1H32(14),wf4(:,1),G1H8(15),m3h4x8(:,46),heltab2x32(:,:,46))
  call Hloop_A_Q(ntryL,G1H8(15),101,0,G2H8(28),n2h8(190))
  call Hloop_AZ_Q(ntryL,G1H32(15),wf4(:,8),G1H8(14),ngZd,m3h4x8(:,47),heltab2x32(:,:,47))
  call Hloop_A_Q(ntryL,G1H8(14),101,0,G2H8(31),n2h8(191))
  call Hloop_AZ_Q(ntryL,G1H32(16),wf4(:,8),G1H8(8),ngZd,m3h4x8(:,48),heltab2x32(:,:,48))
  call Hloop_A_Q(ntryL,G1H8(8),101,0,G2H8(32),n2h8(192))
  call Hloop_AQ_V(ntryL,G1H64(1),wf8(:,10),G1H8(169),m3h8x8(:,1),heltab2x64(:,:,129))
  call Hloop_AQ_V(ntryL,G1H64(2),wf8(:,10),G1H8(162),m3h8x8(:,2),heltab2x64(:,:,130))
  call Hloop_AQ_V(ntryL,G1H64(3),wf8(:,12),G1H8(161),m3h8x8(:,3),heltab2x64(:,:,131))
  call Hloop_AQ_V(ntryL,G1H64(4),wf8(:,12),G1H8(39),m3h8x8(:,4),heltab2x64(:,:,132))
  call Hloop_AQ_V(ntryL,G1H64(5),wf32(:,2),G1H2(27),m3h32x2(:,1),heltab2x64(:,:,133))
  call Hloop_AQ_V(ntryL,G1H64(6),wf32(:,4),G1H2(30),m3h32x2(:,2),heltab2x64(:,:,134))
  call Hloop_AQ_V(ntryL,G1H64(7),wf32(:,6),G1H2(31),m3h32x2(:,3),heltab2x64(:,:,135))
  call Hloop_AQ_V(ntryL,G1H64(8),wf32(:,8),G1H2(32),m3h32x2(:,4),heltab2x64(:,:,136))
  call Hloop_AQ_V(ntryL,G1H64(9),wf8(:,14),G1H8(34),m3h8x8(:,5),heltab2x64(:,:,137))
  call Hloop_AQ_V(ntryL,G1H64(10),wf8(:,16),G1H8(6),m3h8x8(:,6),heltab2x64(:,:,138))
  call Hloop_AQ_V(ntryL,G1H64(11),wf8(:,14),G1H8(1),m3h8x8(:,7),heltab2x64(:,:,139))
  call Hloop_AQ_V(ntryL,G1H64(12),wf8(:,16),G1H8(13),m3h8x8(:,8),heltab2x64(:,:,140))
  call Hloop_AQ_V(ntryL,G1H64(13),ex5(:),G1H32(1),m3h2x32(:,1),heltab2x64(:,:,141))
  call Hloop_AQ_V(ntryL,G1H64(14),ex5(:),G1H32(2),m3h2x32(:,2),heltab2x64(:,:,142))
  call Hloop_AQ_V(ntryL,G1H64(15),ex5(:),G1H32(3),m3h2x32(:,3),heltab2x64(:,:,143))
  call Hloop_AQ_V(ntryL,G1H64(16),ex5(:),G1H32(4),m3h2x32(:,4),heltab2x64(:,:,144))
  call Hloop_AQ_V(ntryL,G1H64(17),wf32(:,18),G1H2(35),m3h32x2(:,5),heltab2x64(:,:,145))
  call Hloop_AQ_V(ntryL,G1H64(18),wf32(:,20),G1H2(36),m3h32x2(:,6),heltab2x64(:,:,146))
  call Hloop_AQ_V(ntryL,G1H64(19),wf32(:,22),G1H2(37),m3h32x2(:,7),heltab2x64(:,:,147))
  call Hloop_AQ_V(ntryL,G1H64(20),wf32(:,24),G1H2(40),m3h32x2(:,8),heltab2x64(:,:,148))
  call Hloop_AQ_V(ntryL,G1H64(21),ex5(:),G1H32(5),m3h2x32(:,5),heltab2x64(:,:,149))
  call Hloop_AQ_V(ntryL,G1H64(22),ex5(:),G1H32(6),m3h2x32(:,6),heltab2x64(:,:,150))
  call Hloop_AQ_V(ntryL,G1H64(23),ex5(:),G1H32(7),m3h2x32(:,7),heltab2x64(:,:,151))
  call Hloop_AQ_V(ntryL,G1H64(24),ex5(:),G1H32(8),m3h2x32(:,8),heltab2x64(:,:,152))
  call Hloop_AQ_V(ntryL,G1H4(176),ex5(:),G1H2(41),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_AQ_V(ntryL,G1H16(34),wf8(:,10),G1H2(42),m3h8x2(:,17),heltab2x16(:,:,49))
  call Hloop_AQ_V(ntryL,G1H16(43),wf8(:,12),G1H2(45),m3h8x2(:,18),heltab2x16(:,:,50))
  call Hloop_AQ_V(ntryL,G1H16(35),ex5(:),G1H8(170),m3h2x8(:,17),heltab2x16(:,:,51))
  call Hloop_AQ_V(ntryL,G1H16(38),ex5(:),G1H8(164),m3h2x8(:,18),heltab2x16(:,:,52))
  call Hloop_QV_A(ntryL,G1H32(17),wf16(:,33),G1H2(46),m3h16x2(:,1),heltab2x32(:,:,49))
  call Hloop_Q_A(ntryL,G1H2(46),95,0,G2H2(51),n2h2(65))
  call Hloop_QZ_A(ntryL,G1H32(18),wf16(:,325),G1H2(47),ngZd,m3h16x2(:,2),heltab2x32(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(47),95,0,G2H2(53),n2h2(66))
  call Hloop_QV_A(ntryL,G1H32(19),wf16(:,35),G1H2(50),m3h16x2(:,3),heltab2x32(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(50),95,0,G2H2(57),n2h2(67))
  call Hloop_QZ_A(ntryL,G1H32(20),wf16(:,326),G1H2(51),ngZd,m3h16x2(:,4),heltab2x32(:,:,52))
  call Hloop_Q_A(ntryL,G1H2(51),95,0,G2H2(59),n2h2(68))
  call Hloop_QV_A(ntryL,G1H32(21),wf16(:,37),G1H2(52),m3h16x2(:,5),heltab2x32(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(52),95,0,G2H2(63),n2h2(69))
  call Hloop_QZ_A(ntryL,G1H32(22),wf16(:,327),G1H2(55),ngZd,m3h16x2(:,6),heltab2x32(:,:,54))
  call Hloop_Q_A(ntryL,G1H2(55),95,0,G2H2(65),n2h2(70))
  call Hloop_QV_A(ntryL,G1H32(23),wf16(:,39),G1H2(56),m3h16x2(:,7),heltab2x32(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(56),95,0,G2H2(69),n2h2(71))
  call Hloop_QZ_A(ntryL,G1H32(24),wf16(:,328),G1H2(57),ngZd,m3h16x2(:,8),heltab2x32(:,:,56))
  call Hloop_Q_A(ntryL,G1H2(57),95,0,G2H2(71),n2h2(72))
  call Hloop_AV_Q(ntryL,G1H32(25),wf16(:,33),G1H2(60),m3h16x2(:,9),heltab2x32(:,:,57))
  call Hloop_A_Q(ntryL,G1H2(60),111,0,G2H2(2),n2h2(73))
  call Hloop_AZ_Q(ntryL,G1H32(26),wf16(:,325),G1H2(61),ngZd,m3h16x2(:,10),heltab2x32(:,:,58))
  call Hloop_A_Q(ntryL,G1H2(61),111,0,G2H2(4),n2h2(74))
  call Hloop_AV_Q(ntryL,G1H32(27),wf16(:,35),G1H2(62),m3h16x2(:,11),heltab2x32(:,:,59))
  call Hloop_A_Q(ntryL,G1H2(62),111,0,G2H2(6),n2h2(75))
  call Hloop_AZ_Q(ntryL,G1H32(28),wf16(:,326),G1H2(65),ngZd,m3h16x2(:,12),heltab2x32(:,:,60))
  call Hloop_A_Q(ntryL,G1H2(65),111,0,G2H2(8),n2h2(76))
  call Hloop_AV_Q(ntryL,G1H32(29),wf16(:,37),G1H2(66),m3h16x2(:,13),heltab2x32(:,:,61))
  call Hloop_A_Q(ntryL,G1H2(66),111,0,G2H2(9),n2h2(77))
  call Hloop_AZ_Q(ntryL,G1H32(30),wf16(:,327),G1H2(67),ngZd,m3h16x2(:,14),heltab2x32(:,:,62))
  call Hloop_A_Q(ntryL,G1H2(67),111,0,G2H2(10),n2h2(78))
  call Hloop_AV_Q(ntryL,G1H32(31),wf16(:,39),G1H2(70),m3h16x2(:,15),heltab2x32(:,:,63))
  call Hloop_A_Q(ntryL,G1H2(70),111,0,G2H2(11),n2h2(79))
  call Hloop_AZ_Q(ntryL,G1H32(32),wf16(:,328),G1H2(71),ngZd,m3h16x2(:,16),heltab2x32(:,:,64))
  call Hloop_A_Q(ntryL,G1H2(71),111,0,G2H2(12),n2h2(80))
  call Hloop_AQ_V(ntryL,G1H64(25),wf32(:,58),G1H2(72),m3h32x2(:,9),heltab2x64(:,:,153))
  call Hloop_AQ_V(ntryL,G1H64(26),wf32(:,60),G1H2(75),m3h32x2(:,10),heltab2x64(:,:,154))
  call Hloop_AQ_V(ntryL,G1H64(27),wf32(:,62),G1H2(76),m3h32x2(:,11),heltab2x64(:,:,155))
  call Hloop_AQ_V(ntryL,G1H64(28),wf32(:,64),G1H2(77),m3h32x2(:,12),heltab2x64(:,:,156))
  call Hloop_AQ_V(ntryL,G1H64(29),ex5(:),G1H32(9),m3h2x32(:,9),heltab2x64(:,:,157))
  call Hloop_AQ_V(ntryL,G1H64(30),ex5(:),G1H32(10),m3h2x32(:,10),heltab2x64(:,:,158))
  call Hloop_AQ_V(ntryL,G1H64(31),ex5(:),G1H32(11),m3h2x32(:,11),heltab2x64(:,:,159))
  call Hloop_AQ_V(ntryL,G1H64(32),ex5(:),G1H32(12),m3h2x32(:,12),heltab2x64(:,:,160))
  call Hloop_AQ_V(ntryL,G1H64(33),wf32(:,80),G1H2(80),m3h32x2(:,13),heltab2x64(:,:,161))
  call Hloop_AQ_V(ntryL,G1H64(34),wf32(:,82),G1H2(81),m3h32x2(:,14),heltab2x64(:,:,162))
  call Hloop_AQ_V(ntryL,G1H64(35),wf32(:,84),G1H2(82),m3h32x2(:,15),heltab2x64(:,:,163))
  call Hloop_AQ_V(ntryL,G1H64(36),wf32(:,86),G1H2(85),m3h32x2(:,16),heltab2x64(:,:,164))
  call Hloop_AQ_V(ntryL,G1H64(37),ex5(:),G1H32(13),m3h2x32(:,13),heltab2x64(:,:,165))
  call Hloop_AQ_V(ntryL,G1H64(38),ex5(:),G1H32(14),m3h2x32(:,14),heltab2x64(:,:,166))
  call Hloop_AQ_V(ntryL,G1H64(39),ex5(:),G1H32(15),m3h2x32(:,15),heltab2x64(:,:,167))
  call Hloop_AQ_V(ntryL,G1H64(40),ex5(:),G1H32(16),m3h2x32(:,16),heltab2x64(:,:,168))
  call Hloop_QV_A(ntryL,G1H32(33),wf4(:,19),G1H8(163),m3h4x8(:,49),heltab2x32(:,:,65))
  call Hloop_Q_A(ntryL,G1H8(163),86,0,G2H8(1),n2h8(193))
  call Hloop_QZ_A(ntryL,G1H32(34),wf4(:,21),G1H8(40),ngZd,m3h4x8(:,50),heltab2x32(:,:,66))
  call Hloop_Q_A(ntryL,G1H8(40),86,0,G2H8(3),n2h8(194))
  call Hloop_QV_A(ntryL,G1H32(35),wf4(:,19),G1H8(37),m3h4x8(:,51),heltab2x32(:,:,67))
  call Hloop_Q_A(ntryL,G1H8(37),86,0,G2H8(5),n2h8(195))
  call Hloop_QZ_A(ntryL,G1H32(36),wf4(:,21),G1H8(7),ngZd,m3h4x8(:,52),heltab2x32(:,:,68))
  call Hloop_Q_A(ntryL,G1H8(7),86,0,G2H8(6),n2h8(196))
  call Hloop_QV_A(ntryL,G1H32(37),wf4(:,18),G1H8(2),m3h4x8(:,53),heltab2x32(:,:,69))
  call Hloop_Q_A(ntryL,G1H8(2),89,0,G2H8(9),n2h8(197))
  call Hloop_QV_A(ntryL,G1H32(38),wf4(:,18),G1H8(18),m3h4x8(:,54),heltab2x32(:,:,70))
  call Hloop_Q_A(ntryL,G1H8(18),89,0,G2H8(11),n2h8(198))
  call Hloop_QZ_A(ntryL,G1H32(39),wf4(:,23),G1H8(91),ngZd,m3h4x8(:,55),heltab2x32(:,:,71))
  call Hloop_Q_A(ntryL,G1H8(91),89,0,G2H8(13),n2h8(199))
  call Hloop_QZ_A(ntryL,G1H32(40),wf4(:,23),G1H8(77),ngZd,m3h4x8(:,56),heltab2x32(:,:,72))
  call Hloop_Q_A(ntryL,G1H8(77),89,0,G2H8(14),n2h8(200))
  call Hloop_AV_Q(ntryL,G1H32(41),wf4(:,19),G1H8(76),m3h4x8(:,57),heltab2x32(:,:,73))
  call Hloop_A_Q(ntryL,G1H8(76),102,0,G2H8(17),n2h8(201))
  call Hloop_AZ_Q(ntryL,G1H32(42),wf4(:,21),G1H8(62),ngZd,m3h4x8(:,58),heltab2x32(:,:,74))
  call Hloop_A_Q(ntryL,G1H8(62),102,0,G2H8(19),n2h8(202))
  call Hloop_AV_Q(ntryL,G1H32(43),wf4(:,19),G1H8(59),m3h4x8(:,59),heltab2x32(:,:,75))
  call Hloop_A_Q(ntryL,G1H8(59),102,0,G2H8(21),n2h8(203))
  call Hloop_AZ_Q(ntryL,G1H32(44),wf4(:,21),G1H8(27),ngZd,m3h4x8(:,60),heltab2x32(:,:,76))
  call Hloop_A_Q(ntryL,G1H8(27),102,0,G2H8(22),n2h8(204))
  call Hloop_AV_Q(ntryL,G1H32(45),wf4(:,18),G1H8(26),m3h4x8(:,61),heltab2x32(:,:,77))
  call Hloop_A_Q(ntryL,G1H8(26),105,0,G2H8(25),n2h8(205))
  call Hloop_AV_Q(ntryL,G1H32(46),wf4(:,18),G1H8(23),m3h4x8(:,62),heltab2x32(:,:,78))
  call Hloop_A_Q(ntryL,G1H8(23),105,0,G2H8(27),n2h8(206))
  call Hloop_AZ_Q(ntryL,G1H32(47),wf4(:,23),G1H8(93),ngZd,m3h4x8(:,63),heltab2x32(:,:,79))
  call Hloop_A_Q(ntryL,G1H8(93),105,0,G2H8(29),n2h8(207))
  call Hloop_AZ_Q(ntryL,G1H32(48),wf4(:,23),G1H8(82),ngZd,m3h4x8(:,64),heltab2x32(:,:,80))
  call Hloop_A_Q(ntryL,G1H8(82),105,0,G2H8(30),n2h8(208))
  call Hloop_AQ_V(ntryL,G1H64(41),wf8(:,54),G1H8(81),m3h8x8(:,9),heltab2x64(:,:,169))
  call Hloop_AQ_V(ntryL,G1H64(42),wf8(:,54),G1H8(65),m3h8x8(:,10),heltab2x64(:,:,170))
  call Hloop_AQ_V(ntryL,G1H64(43),wf8(:,56),G1H8(64),m3h8x8(:,11),heltab2x64(:,:,171))
  call Hloop_AQ_V(ntryL,G1H64(44),wf8(:,56),G1H8(32),m3h8x8(:,12),heltab2x64(:,:,172))
  call Hloop_AQ_V(ntryL,G1H64(45),wf32(:,102),G1H2(86),m3h32x2(:,17),heltab2x64(:,:,173))
  call Hloop_AQ_V(ntryL,G1H64(46),wf32(:,104),G1H2(87),m3h32x2(:,18),heltab2x64(:,:,174))
  call Hloop_AQ_V(ntryL,G1H64(47),wf32(:,106),G1H2(90),m3h32x2(:,19),heltab2x64(:,:,175))
  call Hloop_AQ_V(ntryL,G1H64(48),wf32(:,108),G1H2(1),m3h32x2(:,20),heltab2x64(:,:,176))
  call Hloop_AQ_V(ntryL,G1H64(49),wf8(:,58),G1H8(31),m3h8x8(:,13),heltab2x64(:,:,177))
  call Hloop_AQ_V(ntryL,G1H64(50),wf8(:,60),G1H8(28),m3h8x8(:,14),heltab2x64(:,:,178))
  call Hloop_AQ_V(ntryL,G1H64(51),wf8(:,58),G1H8(173),m3h8x8(:,15),heltab2x64(:,:,179))
  call Hloop_AQ_V(ntryL,G1H64(52),wf8(:,60),G1H8(166),m3h8x8(:,16),heltab2x64(:,:,180))
  call Hloop_AQ_V(ntryL,G1H64(53),ex5(:),G1H32(17),m3h2x32(:,17),heltab2x64(:,:,181))
  call Hloop_AQ_V(ntryL,G1H64(54),ex5(:),G1H32(18),m3h2x32(:,18),heltab2x64(:,:,182))
  call Hloop_AQ_V(ntryL,G1H64(55),ex5(:),G1H32(19),m3h2x32(:,19),heltab2x64(:,:,183))
  call Hloop_AQ_V(ntryL,G1H64(56),ex5(:),G1H32(20),m3h2x32(:,20),heltab2x64(:,:,184))
  call Hloop_AQ_V(ntryL,G1H64(57),wf32(:,118),G1H2(2),m3h32x2(:,21),heltab2x64(:,:,185))
  call Hloop_AQ_V(ntryL,G1H64(58),wf32(:,120),G1H2(5),m3h32x2(:,22),heltab2x64(:,:,186))
  call Hloop_AQ_V(ntryL,G1H64(59),wf32(:,122),G1H2(6),m3h32x2(:,23),heltab2x64(:,:,187))
  call Hloop_AQ_V(ntryL,G1H64(60),wf32(:,124),G1H2(7),m3h32x2(:,24),heltab2x64(:,:,188))
  call Hloop_AQ_V(ntryL,G1H64(61),ex5(:),G1H32(21),m3h2x32(:,21),heltab2x64(:,:,189))
  call Hloop_AQ_V(ntryL,G1H64(62),ex5(:),G1H32(22),m3h2x32(:,22),heltab2x64(:,:,190))
  call Hloop_AQ_V(ntryL,G1H64(63),ex5(:),G1H32(23),m3h2x32(:,23),heltab2x64(:,:,191))
  call Hloop_AQ_V(ntryL,G1H64(64),ex5(:),G1H32(24),m3h2x32(:,24),heltab2x64(:,:,192))
  call Hloop_AQ_V(ntryL,G1H16(49),wf8(:,58),G1H2(10),m3h8x2(:,19),heltab2x16(:,:,53))
  call Hloop_AQ_V(ntryL,G1H16(62),wf8(:,60),G1H2(11),m3h8x2(:,20),heltab2x16(:,:,54))
  call Hloop_AQ_V(ntryL,G1H16(57),ex5(:),G1H8(165),m3h2x8(:,19),heltab2x16(:,:,55))
  call Hloop_AQ_V(ntryL,G1H16(54),ex5(:),G1H8(46),m3h2x8(:,20),heltab2x16(:,:,56))
  call Hloop_QV_A(ntryL,G1H32(49),wf16(:,71),G1H2(12),m3h16x2(:,17),heltab2x32(:,:,81))
  call Hloop_Q_A(ntryL,G1H2(12),95,0,G2H2(14),n2h2(81))
  call Hloop_QZ_A(ntryL,G1H32(50),wf16(:,357),G1H2(15),ngZd,m3h16x2(:,18),heltab2x32(:,:,82))
  call Hloop_Q_A(ntryL,G1H2(15),95,0,G2H2(16),n2h2(82))
  call Hloop_QV_A(ntryL,G1H32(51),wf16(:,73),G1H2(16),m3h16x2(:,19),heltab2x32(:,:,83))
  call Hloop_Q_A(ntryL,G1H2(16),95,0,G2H2(18),n2h2(83))
  call Hloop_QZ_A(ntryL,G1H32(52),wf16(:,358),G1H2(17),ngZd,m3h16x2(:,20),heltab2x32(:,:,84))
  call Hloop_Q_A(ntryL,G1H2(17),95,0,G2H2(20),n2h2(84))
  call Hloop_QV_A(ntryL,G1H32(53),wf16(:,75),G1H2(20),m3h16x2(:,21),heltab2x32(:,:,85))
  call Hloop_Q_A(ntryL,G1H2(20),95,0,G2H2(21),n2h2(85))
  call Hloop_QV_A(ntryL,G1H32(54),wf16(:,76),G1H2(21),m3h16x2(:,22),heltab2x32(:,:,86))
  call Hloop_Q_A(ntryL,G1H2(21),95,0,G2H2(22),n2h2(86))
  call Hloop_QZ_A(ntryL,G1H32(55),wf16(:,359),G1H2(22),ngZd,m3h16x2(:,23),heltab2x32(:,:,87))
  call Hloop_Q_A(ntryL,G1H2(22),95,0,G2H2(23),n2h2(87))
  call Hloop_QZ_A(ntryL,G1H32(56),wf16(:,360),G1H2(25),ngZd,m3h16x2(:,24),heltab2x32(:,:,88))
  call Hloop_Q_A(ntryL,G1H2(25),95,0,G2H2(24),n2h2(88))
  call Hloop_AV_Q(ntryL,G1H32(57),wf16(:,71),G1H2(26),m3h16x2(:,25),heltab2x32(:,:,89))
  call Hloop_A_Q(ntryL,G1H2(26),111,0,G2H2(25),n2h2(89))
  call Hloop_AZ_Q(ntryL,G1H32(58),wf16(:,357),G1H2(46),ngZd,m3h16x2(:,26),heltab2x32(:,:,90))
  call Hloop_A_Q(ntryL,G1H2(46),111,0,G2H2(26),n2h2(90))
  call Hloop_AV_Q(ntryL,G1H32(59),wf16(:,73),G1H2(47),m3h16x2(:,27),heltab2x32(:,:,91))
  call Hloop_A_Q(ntryL,G1H2(47),111,0,G2H2(30),n2h2(91))
  call Hloop_AZ_Q(ntryL,G1H32(60),wf16(:,358),G1H2(50),ngZd,m3h16x2(:,28),heltab2x32(:,:,92))
  call Hloop_A_Q(ntryL,G1H2(50),111,0,G2H2(32),n2h2(92))
  call Hloop_AV_Q(ntryL,G1H32(61),wf16(:,75),G1H2(51),m3h16x2(:,29),heltab2x32(:,:,93))
  call Hloop_A_Q(ntryL,G1H2(51),111,0,G2H2(36),n2h2(93))
  call Hloop_AV_Q(ntryL,G1H32(62),wf16(:,76),G1H2(52),m3h16x2(:,30),heltab2x32(:,:,94))
  call Hloop_A_Q(ntryL,G1H2(52),111,0,G2H2(38),n2h2(94))
  call Hloop_AZ_Q(ntryL,G1H32(63),wf16(:,359),G1H2(55),ngZd,m3h16x2(:,31),heltab2x32(:,:,95))
  call Hloop_A_Q(ntryL,G1H2(55),111,0,G2H2(42),n2h2(95))
  call Hloop_AZ_Q(ntryL,G1H32(64),wf16(:,360),G1H2(56),ngZd,m3h16x2(:,32),heltab2x32(:,:,96))
  call Hloop_A_Q(ntryL,G1H2(56),111,0,G2H2(44),n2h2(96))
  call Hloop_AQ_V(ntryL,G1H64(65),wf32(:,158),G1H2(57),m3h32x2(:,25),heltab2x64(:,:,193))
  call Hloop_AQ_V(ntryL,G1H64(66),wf32(:,160),G1H2(60),m3h32x2(:,26),heltab2x64(:,:,194))
  call Hloop_AQ_V(ntryL,G1H64(67),wf32(:,162),G1H2(61),m3h32x2(:,27),heltab2x64(:,:,195))
  call Hloop_AQ_V(ntryL,G1H64(68),wf32(:,164),G1H2(62),m3h32x2(:,28),heltab2x64(:,:,196))
  call Hloop_AQ_V(ntryL,G1H64(69),ex5(:),G1H32(25),m3h2x32(:,25),heltab2x64(:,:,197))
  call Hloop_AQ_V(ntryL,G1H64(70),ex5(:),G1H32(26),m3h2x32(:,26),heltab2x64(:,:,198))
  call Hloop_AQ_V(ntryL,G1H64(71),ex5(:),G1H32(27),m3h2x32(:,27),heltab2x64(:,:,199))
  call Hloop_AQ_V(ntryL,G1H64(72),ex5(:),G1H32(28),m3h2x32(:,28),heltab2x64(:,:,200))
  call Hloop_AQ_V(ntryL,G1H64(73),wf32(:,180),G1H2(65),m3h32x2(:,29),heltab2x64(:,:,201))
  call Hloop_AQ_V(ntryL,G1H64(74),wf32(:,182),G1H2(66),m3h32x2(:,30),heltab2x64(:,:,202))
  call Hloop_AQ_V(ntryL,G1H64(75),wf32(:,184),G1H2(67),m3h32x2(:,31),heltab2x64(:,:,203))
  call Hloop_AQ_V(ntryL,G1H64(76),wf32(:,186),G1H2(70),m3h32x2(:,32),heltab2x64(:,:,204))
  call Hloop_AQ_V(ntryL,G1H64(77),ex5(:),G1H32(29),m3h2x32(:,29),heltab2x64(:,:,205))
  call Hloop_AQ_V(ntryL,G1H64(78),ex5(:),G1H32(30),m3h2x32(:,30),heltab2x64(:,:,206))
  call Hloop_AQ_V(ntryL,G1H64(79),ex5(:),G1H32(31),m3h2x32(:,31),heltab2x64(:,:,207))
  call Hloop_AQ_V(ntryL,G1H64(80),ex5(:),G1H32(32),m3h2x32(:,32),heltab2x64(:,:,208))
  call Hloop_AQ_V(ntryL,G1H16(3),wf8(:,54),G1H2(71),m3h8x2(:,21),heltab2x16(:,:,57))
  call Hloop_AQ_V(ntryL,G1H16(6),wf8(:,56),G1H2(12),m3h8x2(:,22),heltab2x16(:,:,58))
  call Hloop_AQ_V(ntryL,G1H16(15),ex5(:),G1H8(44),m3h2x8(:,21),heltab2x16(:,:,59))
  call Hloop_AQ_V(ntryL,G1H16(7),ex5(:),G1H8(21),m3h2x8(:,22),heltab2x16(:,:,60))
  call Hloop_QV_A(ntryL,G1H32(65),wf16(:,95),G1H2(15),m3h16x2(:,33),heltab2x32(:,:,97))
  call Hloop_Q_A(ntryL,G1H2(15),95,0,G2H2(48),n2h2(97))
  call Hloop_QZ_A(ntryL,G1H32(66),wf16(:,369),G1H2(16),ngZd,m3h16x2(:,34),heltab2x32(:,:,98))
  call Hloop_Q_A(ntryL,G1H2(16),95,0,G2H2(50),n2h2(98))
  call Hloop_QV_A(ntryL,G1H32(67),wf16(:,97),G1H2(17),m3h16x2(:,35),heltab2x32(:,:,99))
  call Hloop_Q_A(ntryL,G1H2(17),95,0,G2H2(54),n2h2(99))
  call Hloop_QZ_A(ntryL,G1H32(68),wf16(:,370),G1H2(20),ngZd,m3h16x2(:,36),heltab2x32(:,:,100))
  call Hloop_Q_A(ntryL,G1H2(20),95,0,G2H2(56),n2h2(100))
  call Hloop_QV_A(ntryL,G1H32(69),wf16(:,99),G1H2(21),m3h16x2(:,37),heltab2x32(:,:,101))
  call Hloop_Q_A(ntryL,G1H2(21),95,0,G2H2(60),n2h2(101))
  call Hloop_QZ_A(ntryL,G1H32(70),wf16(:,371),G1H2(22),ngZd,m3h16x2(:,38),heltab2x32(:,:,102))
  call Hloop_Q_A(ntryL,G1H2(22),95,0,G2H2(62),n2h2(102))
  call Hloop_QV_A(ntryL,G1H32(71),wf16(:,101),G1H2(25),m3h16x2(:,39),heltab2x32(:,:,103))
  call Hloop_Q_A(ntryL,G1H2(25),95,0,G2H2(66),n2h2(103))
  call Hloop_QZ_A(ntryL,G1H32(72),wf16(:,372),G1H2(26),ngZd,m3h16x2(:,40),heltab2x32(:,:,104))
  call Hloop_Q_A(ntryL,G1H2(26),95,0,G2H2(68),n2h2(104))
  call Hloop_AV_Q(ntryL,G1H32(73),wf16(:,95),G1H2(46),m3h16x2(:,41),heltab2x32(:,:,105))
  call Hloop_A_Q(ntryL,G1H2(46),111,0,G2H2(72),n2h2(105))
  call Hloop_AZ_Q(ntryL,G1H32(74),wf16(:,369),G1H2(47),ngZd,m3h16x2(:,42),heltab2x32(:,:,106))
  call Hloop_A_Q(ntryL,G1H2(47),111,0,G2H2(74),n2h2(106))
  call Hloop_AV_Q(ntryL,G1H32(75),wf16(:,97),G1H2(50),m3h16x2(:,43),heltab2x32(:,:,107))
  call Hloop_A_Q(ntryL,G1H2(50),111,0,G2H2(75),n2h2(107))
  call Hloop_AZ_Q(ntryL,G1H32(76),wf16(:,370),G1H2(51),ngZd,m3h16x2(:,44),heltab2x32(:,:,108))
  call Hloop_A_Q(ntryL,G1H2(51),111,0,G2H2(76),n2h2(108))
  call Hloop_AV_Q(ntryL,G1H32(77),wf16(:,99),G1H2(52),m3h16x2(:,45),heltab2x32(:,:,109))
  call Hloop_A_Q(ntryL,G1H2(52),111,0,G2H2(77),n2h2(109))
  call Hloop_AZ_Q(ntryL,G1H32(78),wf16(:,371),G1H2(55),ngZd,m3h16x2(:,46),heltab2x32(:,:,110))
  call Hloop_A_Q(ntryL,G1H2(55),111,0,G2H2(78),n2h2(110))
  call Hloop_AV_Q(ntryL,G1H32(79),wf16(:,101),G1H2(56),m3h16x2(:,47),heltab2x32(:,:,111))
  call Hloop_A_Q(ntryL,G1H2(56),111,0,G2H2(79),n2h2(111))
  call Hloop_AZ_Q(ntryL,G1H32(80),wf16(:,372),G1H2(15),ngZd,m3h16x2(:,48),heltab2x32(:,:,112))
  call Hloop_A_Q(ntryL,G1H2(15),111,0,G2H2(80),n2h2(112))
  call Hloop_AQ_V(ntryL,G1H64(81),wf32(:,226),G1H2(16),m3h32x2(:,33),heltab2x64(:,:,209))
  call Hloop_AQ_V(ntryL,G1H64(82),wf32(:,228),G1H2(17),m3h32x2(:,34),heltab2x64(:,:,210))
  call Hloop_AQ_V(ntryL,G1H64(83),wf32(:,230),G1H2(20),m3h32x2(:,35),heltab2x64(:,:,211))
  call Hloop_AQ_V(ntryL,G1H64(84),wf32(:,232),G1H2(21),m3h32x2(:,36),heltab2x64(:,:,212))
  call Hloop_AQ_V(ntryL,G1H64(85),ex5(:),G1H32(33),m3h2x32(:,33),heltab2x64(:,:,213))
  call Hloop_AQ_V(ntryL,G1H64(86),ex5(:),G1H32(34),m3h2x32(:,34),heltab2x64(:,:,214))
  call Hloop_AQ_V(ntryL,G1H64(87),ex5(:),G1H32(35),m3h2x32(:,35),heltab2x64(:,:,215))
  call Hloop_AQ_V(ntryL,G1H64(88),ex5(:),G1H32(36),m3h2x32(:,36),heltab2x64(:,:,216))
  call Hloop_AQ_V(ntryL,G1H64(89),wf32(:,248),G1H2(22),m3h32x2(:,37),heltab2x64(:,:,217))
  call Hloop_AQ_V(ntryL,G1H64(90),wf32(:,250),G1H2(25),m3h32x2(:,38),heltab2x64(:,:,218))
  call Hloop_AQ_V(ntryL,G1H64(91),wf32(:,252),G1H2(26),m3h32x2(:,39),heltab2x64(:,:,219))
  call Hloop_AQ_V(ntryL,G1H64(92),wf32(:,254),G1H2(46),m3h32x2(:,40),heltab2x64(:,:,220))
  call Hloop_AQ_V(ntryL,G1H64(93),ex5(:),G1H32(37),m3h2x32(:,37),heltab2x64(:,:,221))
  call Hloop_AQ_V(ntryL,G1H64(94),ex5(:),G1H32(38),m3h2x32(:,38),heltab2x64(:,:,222))
  call Hloop_AQ_V(ntryL,G1H64(95),ex5(:),G1H32(39),m3h2x32(:,39),heltab2x64(:,:,223))
  call Hloop_AQ_V(ntryL,G1H64(96),ex5(:),G1H32(40),m3h2x32(:,40),heltab2x64(:,:,224))
  call Hloop_AQ_V(ntryL,G1H16(46),wf8(:,14),G1H2(47),m3h8x2(:,23),heltab2x16(:,:,61))
  call Hloop_AQ_V(ntryL,G1H16(48),wf8(:,16),G1H2(50),m3h8x2(:,24),heltab2x16(:,:,62))
  call Hloop_AQ_V(ntryL,G1H16(59),ex5(:),G1H8(19),m3h2x8(:,23),heltab2x16(:,:,63))
  call Hloop_AQ_V(ntryL,G1H16(60),ex5(:),G1H8(33),m3h2x8(:,24),heltab2x16(:,:,64))
  call Hloop_QV_A(ntryL,G1H32(81),wf16(:,117),G1H2(51),m3h16x2(:,49),heltab2x32(:,:,113))
  call Hloop_Q_A(ntryL,G1H2(51),95,0,G2H2(81),n2h2(113))
  call Hloop_QZ_A(ntryL,G1H32(82),wf16(:,381),G1H2(52),ngZd,m3h16x2(:,50),heltab2x32(:,:,114))
  call Hloop_Q_A(ntryL,G1H2(52),95,0,G2H2(82),n2h2(114))
  call Hloop_QV_A(ntryL,G1H32(83),wf16(:,119),G1H2(55),m3h16x2(:,51),heltab2x32(:,:,115))
  call Hloop_Q_A(ntryL,G1H2(55),95,0,G2H2(83),n2h2(115))
  call Hloop_QZ_A(ntryL,G1H32(84),wf16(:,382),G1H2(56),ngZd,m3h16x2(:,52),heltab2x32(:,:,116))
  call Hloop_Q_A(ntryL,G1H2(56),95,0,G2H2(84),n2h2(116))
  call Hloop_QV_A(ntryL,G1H32(85),wf16(:,121),G1H2(15),m3h16x2(:,53),heltab2x32(:,:,117))
  call Hloop_Q_A(ntryL,G1H2(15),95,0,G2H2(85),n2h2(117))
  call Hloop_QV_A(ntryL,G1H32(86),wf16(:,122),G1H2(51),m3h16x2(:,54),heltab2x32(:,:,118))
  call Hloop_Q_A(ntryL,G1H2(51),95,0,G2H2(86),n2h2(118))
  call Hloop_QZ_A(ntryL,G1H32(87),wf16(:,383),G1H2(52),ngZd,m3h16x2(:,55),heltab2x32(:,:,119))
  call Hloop_Q_A(ntryL,G1H2(52),95,0,G2H2(87),n2h2(119))
  call Hloop_QZ_A(ntryL,G1H32(88),wf16(:,384),G1H2(55),ngZd,m3h16x2(:,56),heltab2x32(:,:,120))
  call Hloop_Q_A(ntryL,G1H2(55),95,0,G2H2(88),n2h2(120))
  call Hloop_AV_Q(ntryL,G1H32(89),wf16(:,117),G1H2(56),m3h16x2(:,57),heltab2x32(:,:,121))
  call Hloop_A_Q(ntryL,G1H2(56),111,0,G2H2(89),n2h2(121))
  call Hloop_AZ_Q(ntryL,G1H32(90),wf16(:,381),G1H2(15),ngZd,m3h16x2(:,58),heltab2x32(:,:,122))
  call Hloop_A_Q(ntryL,G1H2(15),111,0,G2H2(90),n2h2(122))
  call Hloop_AV_Q(ntryL,G1H32(91),wf16(:,119),G1H2(51),m3h16x2(:,59),heltab2x32(:,:,123))
  call Hloop_A_Q(ntryL,G1H2(51),111,0,G2H2(91),n2h2(123))
  call Hloop_AZ_Q(ntryL,G1H32(92),wf16(:,382),G1H2(52),ngZd,m3h16x2(:,60),heltab2x32(:,:,124))
  call Hloop_A_Q(ntryL,G1H2(52),111,0,G2H2(92),n2h2(124))
  call Hloop_AV_Q(ntryL,G1H32(93),wf16(:,121),G1H2(55),m3h16x2(:,61),heltab2x32(:,:,125))
  call Hloop_A_Q(ntryL,G1H2(55),111,0,G2H2(93),n2h2(125))
  call Hloop_AV_Q(ntryL,G1H32(94),wf16(:,122),G1H2(56),m3h16x2(:,62),heltab2x32(:,:,126))
  call Hloop_A_Q(ntryL,G1H2(56),111,0,G2H2(94),n2h2(126))
  call Hloop_AZ_Q(ntryL,G1H32(95),wf16(:,383),G1H2(15),ngZd,m3h16x2(:,63),heltab2x32(:,:,127))
  call Hloop_A_Q(ntryL,G1H2(15),111,0,G2H2(95),n2h2(127))
  call Hloop_AZ_Q(ntryL,G1H32(96),wf16(:,384),G1H2(51),ngZd,m3h16x2(:,64),heltab2x32(:,:,128))
  call Hloop_A_Q(ntryL,G1H2(51),111,0,G2H2(96),n2h2(128))
  call Hloop_AQ_V(ntryL,G1H64(97),wf32(:,294),G1H2(52),m3h32x2(:,41),heltab2x64(:,:,225))
  call Hloop_AQ_V(ntryL,G1H64(98),wf32(:,296),G1H2(55),m3h32x2(:,42),heltab2x64(:,:,226))
  call Hloop_AQ_V(ntryL,G1H64(99),wf32(:,298),G1H2(56),m3h32x2(:,43),heltab2x64(:,:,227))
  call Hloop_AQ_V(ntryL,G1H64(100),wf32(:,300),G1H2(15),m3h32x2(:,44),heltab2x64(:,:,228))
  call Hloop_AQ_V(ntryL,G1H64(101),ex5(:),G1H32(41),m3h2x32(:,41),heltab2x64(:,:,229))
  call Hloop_AQ_V(ntryL,G1H64(102),ex5(:),G1H32(42),m3h2x32(:,42),heltab2x64(:,:,230))
  call Hloop_AQ_V(ntryL,G1H64(103),ex5(:),G1H32(43),m3h2x32(:,43),heltab2x64(:,:,231))
  call Hloop_AQ_V(ntryL,G1H64(104),ex5(:),G1H32(44),m3h2x32(:,44),heltab2x64(:,:,232))
  call Hloop_AQ_V(ntryL,G1H64(105),wf32(:,316),G1H2(51),m3h32x2(:,45),heltab2x64(:,:,233))
  call Hloop_AQ_V(ntryL,G1H64(106),wf32(:,318),G1H2(91),m3h32x2(:,46),heltab2x64(:,:,234))
  call Hloop_AQ_V(ntryL,G1H64(107),wf32(:,320),G1H2(92),m3h32x2(:,47),heltab2x64(:,:,235))
  call Hloop_AQ_V(ntryL,G1H64(108),wf32(:,322),G1H2(93),m3h32x2(:,48),heltab2x64(:,:,236))
  call Hloop_AQ_V(ntryL,G1H64(109),ex5(:),G1H32(45),m3h2x32(:,45),heltab2x64(:,:,237))
  call Hloop_AQ_V(ntryL,G1H64(110),ex5(:),G1H32(46),m3h2x32(:,46),heltab2x64(:,:,238))
  call Hloop_AQ_V(ntryL,G1H64(111),ex5(:),G1H32(47),m3h2x32(:,47),heltab2x64(:,:,239))
  call Hloop_AQ_V(ntryL,G1H64(112),ex5(:),G1H32(48),m3h2x32(:,48),heltab2x64(:,:,240))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(88),[G2H2(87),G2H2(86),G2H2(85),G2H2(84),G2H2(83) &
    ,G2H2(82),G2H2(81),G2H2(68),G2H2(66),G2H2(62),G2H2(60),G2H2(56),G2H2(54),G2H2(50),G2H2(48),G2H2(24),G2H2(23),G2H2(22),G2H2(21) &
    ,G2H2(20),G2H2(18),G2H2(16),G2H2(14),G2H2(71),G2H2(69),G2H2(65),G2H2(63),G2H2(59),G2H2(57),G2H2(53),G2H2(51),G2H2(61),G2H2(58) &
    ,G2H2(55),G2H2(52),G2H2(37),G2H2(34),G2H2(31),G2H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(96),[G2H2(95),G2H2(94),G2H2(93),G2H2(92),G2H2(91) &
    ,G2H2(90),G2H2(89),G2H2(80),G2H2(79),G2H2(78),G2H2(77),G2H2(76),G2H2(75),G2H2(74),G2H2(72),G2H2(44),G2H2(42),G2H2(38),G2H2(36) &
    ,G2H2(32),G2H2(30),G2H2(26),G2H2(25),G2H2(12),G2H2(11),G2H2(10),G2H2(9),G2H2(8),G2H2(6),G2H2(4),G2H2(2),G2H2(73),G2H2(70) &
    ,G2H2(67),G2H2(64),G2H2(49),G2H2(46),G2H2(43),G2H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(45),[G1H2(42),G1H2(24),G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(93),[G1H2(92),G1H2(91),G1H2(51),G1H2(15),G1H2(56) &
    ,G1H2(55),G1H2(52),G1H2(46),G1H2(26),G1H2(25),G1H2(22),G1H2(21),G1H2(20),G1H2(17),G1H2(16),G1H2(70),G1H2(67),G1H2(66),G1H2(65) &
    ,G1H2(62),G1H2(61),G1H2(60),G1H2(57),G1H2(7),G1H2(6),G1H2(5),G1H2(2),G1H2(1),G1H2(90),G1H2(87),G1H2(86),G1H2(85),G1H2(82) &
    ,G1H2(81),G1H2(80),G1H2(77),G1H2(76),G1H2(75),G1H2(72),G1H2(40),G1H2(37),G1H2(36),G1H2(35),G1H2(32),G1H2(31),G1H2(30),G1H2(27) &
    ,G1H2(54),G1H2(44),G1H2(39),G1H2(14),G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(29),[G1H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(59),[G1H2(49),G1H2(34),G1H2(19),G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(170),[G1H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(6),[G1H8(34),G1H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(164),[G1H8(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(13),[G1H8(1),G1H8(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(50),[G1H2(47),G1H2(84),G1H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(89),[G1H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(19),[G1H8(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(161),[G1H8(169),G1H8(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(33),[G1H8(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(39),[G1H8(162),G1H8(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(41),[G1H2(83),G1H2(73),G1H2(63),G1H2(38),G1H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(88),[G1H2(78),G1H2(68),G1H2(33),G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(12),[G1H2(71),G1H2(74),G1H2(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(79),[G1H2(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(44),[G1H8(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(28),[G1H8(31),G1H8(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(21),[G1H8(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(166),[G1H8(173),G1H8(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(11),[G1H2(10),G1H2(64),G1H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(69),[G1H2(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(165),[G1H8(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(64),[G1H8(81),G1H8(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(46),[G1H8(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(32),[G1H8(65),G1H8(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G2H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G2H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(15),[G2H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(19),[G2H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G2H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(35),[G2H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(41),[G2H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(47),[G2H2(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(4),[G2H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(8),[G2H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(15),[G2H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(16),[G2H8(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(20),[G2H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(24),[G2H8(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(31),[G2H8(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(32),[G2H8(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(3),[G2H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(6),[G2H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(13),[G2H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(14),[G2H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(19),[G2H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(22),[G2H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(29),[G2H8(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(30),[G2H8(27)])
call HGT_w2_OLR(G1H4(1),1,1,4)
call HGT_w2_invQ_OLR(G1H4(1),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(1),wf4(:,1),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(20),n2h1(103))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(88),ex6(:),G2tensor(29),m3h2x1(:,71),heltab2x2(:,:,71))
call HGT_w2_OLR(G1H4(2),1,1,4)
call HGT_w2_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(2),wf4(:,8),G1H1(1),ngZd,m3h4x1(:,2),heltab2x4(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(38),n2h1(104))
call HGT_w2_OLR(G1H4(3),1,1,4)
call HGT_w2_invQ_OLR(G1H4(3),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(3),wf4(:,2),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(47),n2h1(105))
call HGT_w2_OLR(G1H4(4),1,1,4)
call HGT_w2_invQ_OLR(G1H4(4),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(4),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,4),heltab2x4(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(68),n2h1(106))
call HGT_w2_OLR(G1H4(5),1,1,4)
call HGT_w2_invQ_OLR(G1H4(5),2,5,4)
  call Hloop_AV_Q(ntryL,G1H4(5),wf4(:,1),G1H1(1),m3h4x1(:,5),heltab2x4(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(77),n2h1(107))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(96),ex5(:),G2tensor(86),m3h2x1(:,72),heltab2x2(:,:,72))
call HGT_w2_OLR(G1H4(6),1,1,4)
call HGT_w2_invQ_OLR(G1H4(6),2,5,4)
  call Hloop_AZ_Q(ntryL,G1H4(6),wf4(:,8),G1H1(1),ngZd,m3h4x1(:,6),heltab2x4(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(95),n2h1(108))
call HGT_w2_OLR(G1H4(7),1,1,4)
call HGT_w2_invQ_OLR(G1H4(7),2,5,4)
  call Hloop_AV_Q(ntryL,G1H4(7),wf4(:,2),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(1),n2h1(109))
call HGT_w2_OLR(G1H4(8),1,1,4)
call HGT_w2_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_AZ_Q(ntryL,G1H4(8),wf4(:,6),G1H1(1),ngZd,m3h4x1(:,8),heltab2x4(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(3),n2h1(110))
call HGT_w2_OLR(G1H4(9),1,1,4)
call HGT_w2_invQ_OLR(G1H4(9),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(9),wf4(:,18),G1H1(1),m3h4x1(:,9),heltab2x4(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(5),n2h1(111))
call HGT_w2_OLR(G1H4(10),1,1,4)
call HGT_w2_invQ_OLR(G1H4(10),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(10),wf4(:,23),G1H1(1),ngZd,m3h4x1(:,10),heltab2x4(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(7),n2h1(112))



end subroutine vamp_2

end module ol_vamp_2_pplllla_eeexexddxa_1_/**/REALKIND
