
module ol_vamp_1_pplllla_nexnmemxuuxa_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pplllla_nexnmemxuuxa_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pplllla_nexnmemxuuxa_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pplllla_nexnmemxuuxa_1_/**/DREALKIND
  use ol_tensor_sum_storage_pplllla_nexnmemxuuxa_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red

  use ol_loop_storage_pplllla_nexnmemxuuxa_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pplllla_nexnmemxuuxa_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(246)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1),h0tab(:,1),[80,5,10,32],[0,0,0,0],4,3,wf4(:,9),wf4(:,4),wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,1),heltab2x128(:,:,1))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(1),n2h32(1))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(248)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(2),h0tab(:,2),[96,10,5,16],[0,0,0,0],4,3,wf4(:,11),wf4(:,5),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,11),G0H32(1),m3h4x32(:,2),heltab2x128(:,:,2))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(2),n2h32(2))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(171)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(3),h0tab(:,3),[64,10,21,32],[0,0,0,0],4,2,wf4(:,5),wf8(:,11))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1),heltab2x128(:,:,3))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(1),n2h64(1))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(171)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(4),h0tab(:,4),[64,10,32,21],[0,0,0,0],4,2,wf4(:,5),wf8(:,11))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,2),heltab2x128(:,:,4))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(2),n2h64(2))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(174)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(5),h0tab(:,5),[69,10,32,16],[0,0,0,0],4,2,wf8(:,2),wf4(:,5))
  call Hloop_QW_A(ntryL,G0H128(1),wf8(:,2),G0H16(1),m3h8x16(:,1),heltab2x128(:,:,5))
  call Hloop_Q_A(ntryL,G0H16(1),69,0,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(177)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(6),h0tab(:,6),[64,5,42,16],[0,0,0,0],4,2,wf4(:,4),wf8(:,6))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,3),heltab2x128(:,:,6))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(3),n2h64(3))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(177)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(7),h0tab(:,7),[64,5,16,42],[0,0,0,0],4,2,wf4(:,4),wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,4),heltab2x128(:,:,7))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(4),n2h64(4))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(180)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(8),h0tab(:,8),[74,5,16,32],[0,0,0,0],4,2,wf8(:,4),wf4(:,4))
  call Hloop_AW_Q(ntryL,G0H128(1),wf8(:,4),G0H16(1),m3h8x16(:,2),heltab2x128(:,:,8))
  call Hloop_A_Q(ntryL,G0H16(1),74,0,G1H16(2),n2h16(2))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(9),h0tab(:,9),[64,15,32,16],[0,0,0,0],4,1,wf16(:,6))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,5),heltab2x128(:,:,9))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(5),n2h64(5))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(115)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(10),h0tab(:,10),[64,15,32,16],[0,0,0,0],4,1,wf16(:,39))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,6),heltab2x128(:,:,10))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(6),n2h64(6))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(11),h0tab(:,11),[64,15,16,32],[0,0,0,0],4,1,wf16(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,7),heltab2x128(:,:,11))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(7),n2h64(7))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(115)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(12),h0tab(:,12),[64,15,16,32],[0,0,0,0],4,1,wf16(:,39))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,8),heltab2x128(:,:,12))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(8),n2h64(8))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(190)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(13),h0tab(:,13),[74,5,16,32],[0,0,0,0],4,2,wf8(:,18),wf4(:,4))
  call Hloop_AW_Q(ntryL,G0H128(1),wf8(:,18),G0H16(1),m3h8x16(:,3),heltab2x128(:,:,13))
  call Hloop_A_Q(ntryL,G0H16(1),74,0,G1H16(3),n2h16(3))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(147)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(14),h0tab(:,14),[64,15,32,16],[0,0,0,0],4,1,wf16(:,19))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,9),heltab2x128(:,:,14))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(9),n2h64(9))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(149)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(15),h0tab(:,15),[64,15,32,16],[0,0,0,0],4,1,wf16(:,75))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,10),heltab2x128(:,:,15))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(10),n2h64(10))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(147)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(16),h0tab(:,16),[64,15,16,32],[0,0,0,0],4,1,wf16(:,19))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,11),heltab2x128(:,:,16))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(11),n2h64(11))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(149)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(17),h0tab(:,17),[64,15,16,32],[0,0,0,0],4,1,wf16(:,75))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,12),heltab2x128(:,:,17))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(12),n2h64(12))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(151)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(18),h0tab(:,18),[64,15,32,16],[0,0,0,0],4,1,wf16(:,76))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,13),heltab2x128(:,:,18))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(13),n2h64(13))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(151)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(19),h0tab(:,19),[64,15,16,32],[0,0,0,0],4,1,wf16(:,76))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,14),heltab2x128(:,:,19))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(14),n2h64(14))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(214)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(20),h0tab(:,20),[69,10,32,16],[0,0,0,0],4,2,wf8(:,30),wf4(:,5))
  call Hloop_QW_A(ntryL,G0H128(1),wf8(:,30),G0H16(1),m3h8x16(:,4),heltab2x128(:,:,20))
  call Hloop_Q_A(ntryL,G0H16(1),69,0,G1H16(4),n2h16(4))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(158)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(21),h0tab(:,21),[64,15,32,16],[0,0,0,0],4,1,wf16(:,30))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,15),heltab2x128(:,:,21))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(15),n2h64(15))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(160)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(22),h0tab(:,22),[64,15,32,16],[0,0,0,0],4,1,wf16(:,78))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,16),heltab2x128(:,:,22))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(16),n2h64(16))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(158)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(23),h0tab(:,23),[64,15,16,32],[0,0,0,0],4,1,wf16(:,30))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,17),heltab2x128(:,:,23))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(17),n2h64(17))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(160)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(24),h0tab(:,24),[64,15,16,32],[0,0,0,0],4,1,wf16(:,78))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,18),heltab2x128(:,:,24))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(18),n2h64(18))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(162)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(25),h0tab(:,25),[64,15,32,16],[0,0,0,0],4,1,wf16(:,79))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,19),heltab2x128(:,:,25))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(19),n2h64(19))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(162)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(26),h0tab(:,26),[64,15,16,32],[0,0,0,0],4,1,wf16(:,79))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,20),heltab2x128(:,:,26))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(20),n2h64(20))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(4),[G1H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(3),[G1H16(2)])
  call Hloop_QW_A(ntryL,G1H32(1),wf4(:,4),G1H8(1),m3h4x8(:,1),heltab2x32(:,:,1))
  call Hloop_Q_A(ntryL,G1H8(1),85,0,G2H8(1),n2h8(1))
  call Hloop_AW_Q(ntryL,G1H32(2),wf4(:,5),G1H8(1),m3h4x8(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G1H8(1),106,0,G2H8(2),n2h8(2))
  call Hloop_AW_Q(ntryL,G1H64(1),wf4(:,5),G1H16(1),m3h4x16(:,1),heltab2x64(:,:,1))
  call Hloop_A_Q(ntryL,G1H16(1),74,0,G2H16(1),n2h16(5))
  call Hloop_QW_A(ntryL,G1H64(2),wf4(:,5),G1H16(2),m3h4x16(:,2),heltab2x64(:,:,2))
  call Hloop_Q_A(ntryL,G1H16(2),74,0,G2H16(2),n2h16(6))
  call Hloop_QW_A(ntryL,G1H16(4),wf4(:,5),G1H4(1),m3h4x4(:,1),heltab2x16(:,:,1))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(1),n2h4(1))
  call Hloop_QW_A(ntryL,G1H64(3),wf4(:,4),G1H16(1),m3h4x16(:,3),heltab2x64(:,:,3))
  call Hloop_Q_A(ntryL,G1H16(1),69,0,G2H16(3),n2h16(7))
  call Hloop_AW_Q(ntryL,G1H64(4),wf4(:,4),G1H16(2),m3h4x16(:,4),heltab2x64(:,:,4))
  call Hloop_A_Q(ntryL,G1H16(2),69,0,G2H16(4),n2h16(8))
  call Hloop_AW_Q(ntryL,G1H16(3),wf4(:,4),G1H4(1),m3h4x4(:,2),heltab2x16(:,:,2))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(2),n2h4(2))
  call Hloop_QV_A(ntryL,G1H64(5),wf16(:,6),G1H4(1),m3h16x4(:,1),heltab2x64(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(3),n2h4(3))
  call Hloop_QZ_A(ntryL,G1H64(6),wf16(:,39),G1H4(1),ngZu,m3h16x4(:,2),heltab2x64(:,:,6))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(4),n2h4(4))
  call Hloop_AV_Q(ntryL,G1H64(7),wf16(:,6),G1H4(1),m3h16x4(:,3),heltab2x64(:,:,7))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(5),n2h4(5))
  call Hloop_AZ_Q(ntryL,G1H64(8),wf16(:,39),G1H4(1),ngZu,m3h16x4(:,4),heltab2x64(:,:,8))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(6),n2h4(6))
  call Hloop_QV_A(ntryL,G1H64(9),wf16(:,19),G1H4(1),m3h16x4(:,5),heltab2x64(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(7),n2h4(7))
  call Hloop_QZ_A(ntryL,G1H64(10),wf16(:,75),G1H4(1),ngZu,m3h16x4(:,6),heltab2x64(:,:,10))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(8),n2h4(8))
  call Hloop_AV_Q(ntryL,G1H64(11),wf16(:,19),G1H4(1),m3h16x4(:,7),heltab2x64(:,:,11))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(9),n2h4(9))
  call Hloop_AZ_Q(ntryL,G1H64(12),wf16(:,75),G1H4(1),ngZu,m3h16x4(:,8),heltab2x64(:,:,12))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(10),n2h4(10))
  call Hloop_QZ_A(ntryL,G1H64(13),wf16(:,76),G1H4(1),ngZu,m3h16x4(:,9),heltab2x64(:,:,13))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(11),n2h4(11))
  call Hloop_AZ_Q(ntryL,G1H64(14),wf16(:,76),G1H4(1),ngZu,m3h16x4(:,10),heltab2x64(:,:,14))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(12),n2h4(12))
  call Hloop_QV_A(ntryL,G1H64(15),wf16(:,30),G1H4(1),m3h16x4(:,11),heltab2x64(:,:,15))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(13),n2h4(13))
  call Hloop_QZ_A(ntryL,G1H64(16),wf16(:,78),G1H4(1),ngZu,m3h16x4(:,12),heltab2x64(:,:,16))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(14),n2h4(14))
  call Hloop_AV_Q(ntryL,G1H64(17),wf16(:,30),G1H4(1),m3h16x4(:,13),heltab2x64(:,:,17))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(15),n2h4(15))
  call Hloop_AZ_Q(ntryL,G1H64(18),wf16(:,78),G1H4(1),ngZu,m3h16x4(:,14),heltab2x64(:,:,18))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(16),n2h4(16))
  call Hloop_QZ_A(ntryL,G1H64(19),wf16(:,79),G1H4(1),ngZu,m3h16x4(:,15),heltab2x64(:,:,19))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(17),n2h4(17))
  call Hloop_AZ_Q(ntryL,G1H64(20),wf16(:,79),G1H4(1),ngZu,m3h16x4(:,16),heltab2x64(:,:,20))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(18),n2h4(18))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(17),[G2H4(14),G2H4(13),G2H4(11),G2H4(8),G2H4(7),G2H4(4) &
    ,G2H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(18),[G2H4(16),G2H4(15),G2H4(12),G2H4(10),G2H4(9),G2H4(6) &
    ,G2H4(5)])
  call Hotf_4pt_reduction(G2H8(1),RedSet_4(1),mass4set(:,1),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),8)
  call HG1shiftOLR(G1H8(2),32,8)
  call Hotf_4pt_reduction(G2H8(2),RedSet_4(2),mass4set(:,1),  & 
G1H8(6),G1H8(7),G1H8(8),G1H8(9),G1H8(10),8)
  call HG1shiftOLR(G1H8(7),16,8)
  call Hloop_AQ_V(ntryL,G2H16(1),wf8(:,11),G2H2(1),m3h8x2(:,1),heltab2x16(:,:,3))
  call Hloop_QA_V(ntryL,G2H16(2),ex6(:),G2H8(1),m3h2x8(:,1),heltab2x16(:,:,4))
  call Hloop_QA_V(ntryL,G2H4(1),ex6(:),G2H2(2),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_V(ntryL,G2H16(3),wf8(:,6),G2H2(3),m3h8x2(:,2),heltab2x16(:,:,5))
  call Hloop_AQ_V(ntryL,G2H16(4),ex5(:),G2H8(2),m3h2x8(:,2),heltab2x16(:,:,6))
  call Hloop_AQ_V(ntryL,G2H4(2),ex5(:),G2H2(4),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_V(ntryL,G2H4(17),ex6(:),G2H2(5),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_AQ_V(ntryL,G2H4(18),ex5(:),G2H2(6),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_QW_A(ntryL,G1H8(1),wf4(:,5),G1H2(1),m3h4x2(:,1),heltab2x8(:,:,1))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(7),n2h2(1))
call HGT_raise_alpha_OLR(G1H8(2),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(2),ex6(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,2))
  call Hloop_QW_A(ntryL,G1H8(4),wf4(:,5),G1H2(1),m3h4x2(:,2),heltab2x8(:,:,3))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(8),n2h2(2))
  call Hloop_QW_A(ntryL,G1H8(5),wf4(:,5),G1H2(1),m3h4x2(:,3),heltab2x8(:,:,4))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(9),n2h2(3))
  call Hloop_AW_Q(ntryL,G1H8(6),wf4(:,4),G1H2(1),m3h4x2(:,4),heltab2x8(:,:,5))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(10),n2h2(4))
call HGT_raise_alpha_OLR(G1H8(7),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(7),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(7),ex5(:),G1H4(2),m3h2x4(:,2),heltab2x8(:,:,6))
  call Hloop_AW_Q(ntryL,G1H8(9),wf4(:,4),G1H2(1),m3h4x2(:,5),heltab2x8(:,:,7))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(11),n2h2(5))
  call Hloop_AW_Q(ntryL,G1H8(10),wf4(:,4),G1H2(1),m3h4x2(:,6),heltab2x8(:,:,8))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(12),n2h2(6))
  call Hotf_4pt_reduction(G2H2(1),RedSet_4(3),mass4set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),2)
  call HG1shiftOLR(G1H2(2),32,2)
  call Hotf_4pt_reduction(G2H8(1),RedSet_4(4),mass4set(:,1),  & 
G1H8(1),G1H8(2),G1H8(4),G1H8(5),G1H8(6),8)
  call HG1shiftOLR(G1H8(2),21,8)
  call Hotf_4pt_reduction(G2H2(2),RedSet_4(5),mass4set(:,1),  & 
G1H2(6),G1H2(7),G1H2(8),G1H2(9),G1H2(10),2)
  call HG1shiftOLR(G1H2(7),16,2)
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(6),mass4set(:,1),  & 
G1H2(11),G1H2(12),G1H2(13),G1H2(14),G1H2(15),2)
  call HG1shiftOLR(G1H2(12),16,2)
  call Hotf_4pt_reduction(G2H8(2),RedSet_4(7),mass4set(:,1),  & 
G1H8(7),G1H8(9),G1H8(10),G1H8(11),G1H8(12),8)
  call HG1shiftOLR(G1H8(9),42,8)
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(8),mass4set(:,1),  & 
G1H2(16),G1H2(17),G1H2(18),G1H2(19),G1H2(20),2)
  call HG1shiftOLR(G1H2(17),32,2)
  call Hotf_4pt_reduction(G2H2(5),RedSet_4(9),mass4set(:,1),  & 
G1H2(21),G1H2(22),G1H2(23),G1H2(24),G1H2(25),2)
  call HG1shiftOLR(G1H2(22),16,2)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(10),mass4set(:,1),  & 
G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(27),32,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(7),ex6(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(9),ex6(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(10),ex5(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(12),ex5(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hloop_VA_Q(ntryL,G1H2(1),ex6(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(5),n2h1(1))
  call Hloop_VA_Q(ntryL,G1H2(2),ex6(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(6),n2h1(2))
  call Hloop_VA_Q(ntryL,G1H2(5),ex6(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(7),n2h1(3))
  call Hloop_VQ_A(ntryL,G1H8(1),wf8(:,11),G1H1(1),m3h8x1(:,1),heltab2x8(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(8),n2h1(4))
  call Hloop_VQ_A(ntryL,G1H8(2),wf8(:,11),G1H1(1),m3h8x1(:,2),heltab2x8(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),21,0,G2tensor(9),n2h1(5))
  call Hloop_VQ_A(ntryL,G1H8(6),wf8(:,11),G1H1(1),m3h8x1(:,3),heltab2x8(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(10),n2h1(6))
  call Hloop_VQ_A(ntryL,G1H2(6),ex5(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(11),n2h1(7))
  call Hloop_VQ_A(ntryL,G1H2(7),ex5(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(12),n2h1(8))
  call Hloop_VQ_A(ntryL,G1H2(10),ex5(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(13),n2h1(9))
  call Hloop_VQ_A(ntryL,G1H2(11),ex5(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(14),n2h1(10))
  call Hloop_VQ_A(ntryL,G1H2(12),ex5(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(15),n2h1(11))
  call Hloop_VQ_A(ntryL,G1H2(15),ex5(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(16),n2h1(12))
  call Hloop_VA_Q(ntryL,G1H8(7),wf8(:,6),G1H1(1),m3h8x1(:,4),heltab2x8(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(17),n2h1(13))
  call Hloop_VA_Q(ntryL,G1H8(9),wf8(:,6),G1H1(1),m3h8x1(:,5),heltab2x8(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),42,0,G2tensor(18),n2h1(14))
  call Hloop_VA_Q(ntryL,G1H8(12),wf8(:,6),G1H1(1),m3h8x1(:,6),heltab2x8(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(19),n2h1(15))
  call Hloop_VA_Q(ntryL,G1H2(16),ex6(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(20),n2h1(16))
  call Hloop_VA_Q(ntryL,G1H2(17),ex6(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(21),n2h1(17))
  call Hloop_VA_Q(ntryL,G1H2(20),ex6(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(22),n2h1(18))
  call Hloop_VQ_A(ntryL,G1H2(21),ex5(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(23),n2h1(19))
  call Hloop_VQ_A(ntryL,G1H2(22),ex5(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(24),n2h1(20))
  call Hloop_VQ_A(ntryL,G1H2(25),ex5(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(25),n2h1(21))
  call Hloop_VA_Q(ntryL,G1H2(26),ex6(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(26),n2h1(22))
  call Hloop_VA_Q(ntryL,G1H2(27),ex6(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(27),n2h1(23))
  call Hloop_VA_Q(ntryL,G1H2(30),ex6(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(28),n2h1(24))
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5))
  call G_TensorShift(G1tensor(2),32)
  call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(2),mass4set(:,1),  & 
G1tensor(6),G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10))
  call G_TensorShift(G1tensor(7),16)
  call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(3),mass4set(:,1),  & 
G1tensor(11),G1tensor(12),G1tensor(13),G1tensor(14),G1tensor(15))
  call G_TensorShift(G1tensor(12),32)
  call Hotf_4pt_reduction_last(G2tensor(8),RedSet_4(4),mass4set(:,1),  & 
G1tensor(16),G1tensor(17),G1tensor(18),G1tensor(19),G1tensor(20))
  call G_TensorShift(G1tensor(17),21)
  call Hotf_4pt_reduction_last(G2tensor(11),RedSet_4(5),mass4set(:,1),  & 
G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24),G1tensor(25))
  call G_TensorShift(G1tensor(22),16)
  call Hotf_4pt_reduction_last(G2tensor(14),RedSet_4(6),mass4set(:,1),  & 
G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(27),16)
  call Hotf_4pt_reduction_last(G2tensor(17),RedSet_4(7),mass4set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35))
  call G_TensorShift(G1tensor(32),42)
  call Hotf_4pt_reduction_last(G2tensor(20),RedSet_4(8),mass4set(:,1),  & 
G1tensor(36),G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40))
  call G_TensorShift(G1tensor(37),32)
  call Hotf_4pt_reduction_last(G2tensor(23),RedSet_4(9),mass4set(:,1),  & 
G1tensor(41),G1tensor(42),G1tensor(43),G1tensor(44),G1tensor(45))
  call G_TensorShift(G1tensor(42),16)
  call Hotf_4pt_reduction_last(G2tensor(26),RedSet_4(10),mass4set(:,1),  & 
G1tensor(46),G1tensor(47),G1tensor(48),G1tensor(49),G1tensor(50))
  call G_TensorShift(G1tensor(47),32)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(1),mass4set(:,1),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(6),RedSet_4(2),mass4set(:,1),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(3),mass4set(:,1),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(16),RedSet_4(4),mass4set(:,1),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(21),RedSet_4(5),mass4set(:,1),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(6),mass4set(:,1),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(7),mass4set(:,1),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(36),RedSet_4(8),mass4set(:,1),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(9),mass4set(:,1),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(46),RedSet_4(10),mass4set(:,1),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(168)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(27),h0tab(:,27),[79,16,32],[0,0,0],3,1,wf32(:,1))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,1),G0H4(1),m3h32x4(:,1),heltab2x128(:,:,27))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(3),n2h4(19))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(170)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(28),h0tab(:,28),[79,16,32],[0,0,0],3,1,wf32(:,2))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,2),G0H4(1),ngZu,m3h32x4(:,2),heltab2x128(:,:,28))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(4),n2h4(20))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(245)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(29),h0tab(:,29),[80,5,42],[0,0,0],3,3,wf4(:,9),wf4(:,4),wf8(:,6))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,3),heltab2x128(:,:,29))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(1),n2h32(3))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(30),h0tab(:,30),[80,15,32],[0,0,0],3,2,wf4(:,9),wf16(:,6))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,4),heltab2x128(:,:,30))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(2),n2h32(4))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(31),h0tab(:,31),[80,15,32],[0,0,0],3,2,wf4(:,9),wf16(:,39))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,5),heltab2x128(:,:,31))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(3),n2h32(5))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(32),h0tab(:,32),[85,10,32],[0,0,0],3,2,wf16(:,40),wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,40),G0H8(1),m3h16x8(:,1),heltab2x128(:,:,32))
  call Hloop_Q_A(ntryL,G0H8(1),85,0,G1H8(1),n2h8(5))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(247)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(33),h0tab(:,33),[96,10,21],[0,0,0],3,3,wf4(:,11),wf4(:,5),wf8(:,11))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,11),G0H32(1),m3h4x32(:,6),heltab2x128(:,:,33))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(4),n2h32(6))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(120)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(34),h0tab(:,34),[96,15,16],[0,0,0],3,2,wf4(:,11),wf16(:,6))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,11),G0H32(1),m3h4x32(:,7),heltab2x128(:,:,34))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(5),n2h32(7))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(121)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(35),h0tab(:,35),[96,15,16],[0,0,0],3,2,wf4(:,11),wf16(:,39))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,11),G0H32(1),m3h4x32(:,8),heltab2x128(:,:,35))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(6),n2h32(8))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(36),h0tab(:,36),[106,5,16],[0,0,0],3,2,wf16(:,44),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,44),G0H8(1),m3h16x8(:,2),heltab2x128(:,:,36))
  call Hloop_A_Q(ntryL,G0H8(1),106,0,G1H8(2),n2h8(6))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(37),h0tab(:,37),[64,21,42],[0,0,0],3,2,wf8(:,11),wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,21),heltab2x128(:,:,37))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(1),n2h64(21))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(38),h0tab(:,38),[74,21,32],[0,0,0],3,2,wf8(:,4),wf8(:,11))
  call Hloop_AW_Q(ntryL,G0H128(1),wf8(:,4),G0H16(1),m3h8x16(:,5),heltab2x128(:,:,38))
  call Hloop_A_Q(ntryL,G0H16(1),74,0,G1H16(4),n2h16(9))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(249)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(39),h0tab(:,39),[85,10,32],[0,0,0],3,2,wf16(:,73),wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,73),G0H8(1),m3h16x8(:,3),heltab2x128(:,:,39))
  call Hloop_Q_A(ntryL,G0H8(1),85,0,G1H8(6),n2h8(7))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(173)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(40),h0tab(:,40),[64,31,32],[0,0,0],3,1,wf32(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,22),heltab2x128(:,:,40))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(2),n2h64(22))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(41),h0tab(:,41),[69,16,42],[0,0,0],3,2,wf8(:,2),wf8(:,6))
  call Hloop_AW_Q(ntryL,G0H128(1),wf8(:,2),G0H16(1),m3h8x16(:,6),heltab2x128(:,:,41))
  call Hloop_A_Q(ntryL,G0H16(1),69,0,G1H16(1),n2h16(10))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(42),h0tab(:,42),[85,10,32],[0,0,0],3,2,wf16(:,70),wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,70),G0H8(1),m3h16x8(:,4),heltab2x128(:,:,42))
  call Hloop_Q_A(ntryL,G0H8(1),85,0,G1H8(7),n2h8(8))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(175)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(43),h0tab(:,43),[79,16,32],[0,0,0],3,1,wf32(:,5))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,5),G0H4(1),m3h32x4(:,3),heltab2x128(:,:,43))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(5),n2h4(21))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(176)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(44),h0tab(:,44),[79,16,32],[0,0,0],3,1,wf32(:,6))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,6),G0H4(1),ngZu,m3h32x4(:,4),heltab2x128(:,:,44))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(6),n2h4(22))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(251)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(45),h0tab(:,45),[106,5,16],[0,0,0],3,2,wf16(:,72),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,72),G0H8(1),m3h16x8(:,5),heltab2x128(:,:,45))
  call Hloop_A_Q(ntryL,G0H8(1),106,0,G1H8(9),n2h8(9))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(179)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(46),h0tab(:,46),[64,16,47],[0,0,0],3,1,wf32(:,8))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,23),heltab2x128(:,:,46))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(3),n2h64(23))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(252)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(47),h0tab(:,47),[106,5,16],[0,0,0],3,2,wf16(:,68),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,68),G0H8(1),m3h16x8(:,6),heltab2x128(:,:,47))
  call Hloop_A_Q(ntryL,G0H8(1),106,0,G1H8(12),n2h8(10))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(181)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(48),h0tab(:,48),[79,16,32],[0,0,0],3,1,wf32(:,9))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,9),G0H4(1),m3h32x4(:,5),heltab2x128(:,:,48))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(7),n2h4(23))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(182)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(49),h0tab(:,49),[79,16,32],[0,0,0],3,1,wf32(:,10))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,10),G0H4(1),ngZu,m3h32x4(:,6),heltab2x128(:,:,49))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(8),n2h4(24))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(183)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(50),h0tab(:,50),[64,31,32],[0,0,0],3,1,wf32(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,24),heltab2x128(:,:,50))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(4),n2h64(24))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(184)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(51),h0tab(:,51),[64,31,32],[0,0,0],3,1,wf32(:,14))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,25),heltab2x128(:,:,51))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(5),n2h64(25))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(52),h0tab(:,52),[64,16,47],[0,0,0],3,1,wf32(:,16))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,26),heltab2x128(:,:,52))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(6),n2h64(26))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(186)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(53),h0tab(:,53),[64,16,47],[0,0,0],3,1,wf32(:,18))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,27),heltab2x128(:,:,53))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(7),n2h64(27))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(188)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(54),h0tab(:,54),[79,16,32],[0,0,0],3,1,wf32(:,19))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,19),G0H4(1),m3h32x4(:,7),heltab2x128(:,:,54))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(9),n2h4(25))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(189)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(55),h0tab(:,55),[79,16,32],[0,0,0],3,1,wf32(:,21))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,21),G0H4(1),ngZu,m3h32x4(:,8),heltab2x128(:,:,55))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(10),n2h4(26))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(56),h0tab(:,56),[74,21,32],[0,0,0],3,2,wf8(:,18),wf8(:,11))
  call Hloop_AW_Q(ntryL,G0H128(1),wf8(:,18),G0H16(1),m3h8x16(:,7),heltab2x128(:,:,56))
  call Hloop_A_Q(ntryL,G0H16(1),74,0,G1H16(2),n2h16(11))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(253)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(57),h0tab(:,57),[106,5,16],[0,0,0],3,2,wf16(:,74),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,74),G0H8(1),m3h16x8(:,7),heltab2x128(:,:,57))
  call Hloop_A_Q(ntryL,G0H8(1),106,0,G1H8(13),n2h8(11))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(191)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(58),h0tab(:,58),[79,16,32],[0,0,0],3,1,wf32(:,22))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,22),G0H4(1),m3h32x4(:,9),heltab2x128(:,:,58))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(11),n2h4(27))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(192)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(59),h0tab(:,59),[79,16,32],[0,0,0],3,1,wf32(:,23))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,23),G0H4(1),ngZu,m3h32x4(:,10),heltab2x128(:,:,59))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(12),n2h4(28))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(195)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(60),h0tab(:,60),[79,16,32],[0,0,0],3,1,wf32(:,25))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,25),G0H4(1),ngZu,m3h32x4(:,11),heltab2x128(:,:,60))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(13),n2h4(29))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(254)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(61),h0tab(:,61),[80,15,32],[0,0,0],3,2,wf4(:,9),wf16(:,19))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,9),heltab2x128(:,:,61))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(7),n2h32(9))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(255)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(62),h0tab(:,62),[80,15,32],[0,0,0],3,2,wf4(:,9),wf16(:,75))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,10),heltab2x128(:,:,62))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(8),n2h32(10))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(256)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(63),h0tab(:,63),[80,15,32],[0,0,0],3,2,wf4(:,9),wf16(:,76))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,11),heltab2x128(:,:,63))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(9),n2h32(11))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(257)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(64),h0tab(:,64),[96,15,16],[0,0,0],3,2,wf4(:,11),wf16(:,19))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,11),G0H32(1),m3h4x32(:,12),heltab2x128(:,:,64))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(10),n2h32(12))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(258)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(65),h0tab(:,65),[96,15,16],[0,0,0],3,2,wf4(:,11),wf16(:,75))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,11),G0H32(1),m3h4x32(:,13),heltab2x128(:,:,65))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(11),n2h32(13))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(259)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(66),h0tab(:,66),[96,15,16],[0,0,0],3,2,wf4(:,11),wf16(:,76))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,11),G0H32(1),m3h4x32(:,14),heltab2x128(:,:,66))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(12),n2h32(14))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(67),h0tab(:,67),[64,31,32],[0,0,0],3,1,wf32(:,27))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,28),heltab2x128(:,:,67))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(8),n2h64(28))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(197)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(68),h0tab(:,68),[64,31,32],[0,0,0],3,1,wf32(:,29))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,29),heltab2x128(:,:,68))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(9),n2h64(29))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(198)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(69),h0tab(:,69),[64,16,47],[0,0,0],3,1,wf32(:,31))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,30),heltab2x128(:,:,69))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(10),n2h64(30))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(199)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(70),h0tab(:,70),[64,16,47],[0,0,0],3,1,wf32(:,33))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,31),heltab2x128(:,:,70))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(11),n2h64(31))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(202)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(71),h0tab(:,71),[79,16,32],[0,0,0],3,1,wf32(:,34))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,34),G0H4(1),m3h32x4(:,12),heltab2x128(:,:,71))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(14),n2h4(30))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(203)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(72),h0tab(:,72),[79,16,32],[0,0,0],3,1,wf32(:,36))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,36),G0H4(1),ngZu,m3h32x4(:,13),heltab2x128(:,:,72))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(15),n2h4(31))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(204)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(73),h0tab(:,73),[64,31,32],[0,0,0],3,1,wf32(:,38))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,32),heltab2x128(:,:,73))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(12),n2h64(32))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(205)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(74),h0tab(:,74),[64,16,47],[0,0,0],3,1,wf32(:,40))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,33),heltab2x128(:,:,74))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(13),n2h64(33))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(207)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(75),h0tab(:,75),[79,16,32],[0,0,0],3,1,wf32(:,41))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,41),G0H4(1),m3h32x4(:,14),heltab2x128(:,:,75))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(16),n2h4(32))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(208)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(76),h0tab(:,76),[79,16,32],[0,0,0],3,1,wf32(:,43))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,43),G0H4(1),ngZu,m3h32x4(:,15),heltab2x128(:,:,76))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(17),n2h4(33))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(210)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(77),h0tab(:,77),[79,16,32],[0,0,0],3,1,wf32(:,45))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,45),G0H4(1),ngZu,m3h32x4(:,16),heltab2x128(:,:,77))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(18),n2h4(34))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(212)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(78),h0tab(:,78),[79,16,32],[0,0,0],3,1,wf32(:,46))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,46),G0H4(1),m3h32x4(:,17),heltab2x128(:,:,78))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(19),n2h4(35))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(213)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(79),h0tab(:,79),[79,16,32],[0,0,0],3,1,wf32(:,48))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,48),G0H4(1),ngZu,m3h32x4(:,18),heltab2x128(:,:,79))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(20),n2h4(36))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(260)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(80),h0tab(:,80),[85,10,32],[0,0,0],3,2,wf16(:,77),wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,77),G0H8(1),m3h16x8(:,8),heltab2x128(:,:,80))
  call Hloop_Q_A(ntryL,G0H8(1),85,0,G1H8(14),n2h8(12))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(81),h0tab(:,81),[69,16,42],[0,0,0],3,2,wf8(:,30),wf8(:,6))
  call Hloop_AW_Q(ntryL,G0H128(1),wf8(:,30),G0H16(1),m3h8x16(:,8),heltab2x128(:,:,81))
  call Hloop_A_Q(ntryL,G0H16(1),69,0,G1H16(3),n2h16(12))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(82),h0tab(:,82),[79,16,32],[0,0,0],3,1,wf32(:,49))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,49),G0H4(1),m3h32x4(:,19),heltab2x128(:,:,82))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(21),n2h4(37))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(83),h0tab(:,83),[79,16,32],[0,0,0],3,1,wf32(:,50))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,50),G0H4(1),ngZu,m3h32x4(:,20),heltab2x128(:,:,83))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(22),n2h4(38))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(84),h0tab(:,84),[79,16,32],[0,0,0],3,1,wf32(:,52))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,52),G0H4(1),ngZu,m3h32x4(:,21),heltab2x128(:,:,84))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(23),n2h4(39))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(85),h0tab(:,85),[80,15,32],[0,0,0],3,2,wf4(:,9),wf16(:,30))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,15),heltab2x128(:,:,85))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(13),n2h32(15))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(262)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(86),h0tab(:,86),[80,15,32],[0,0,0],3,2,wf4(:,9),wf16(:,78))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,16),heltab2x128(:,:,86))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(14),n2h32(16))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(263)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(87),h0tab(:,87),[80,15,32],[0,0,0],3,2,wf4(:,9),wf16(:,79))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,17),heltab2x128(:,:,87))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(15),n2h32(17))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(88),h0tab(:,88),[96,15,16],[0,0,0],3,2,wf4(:,11),wf16(:,30))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,11),G0H32(1),m3h4x32(:,18),heltab2x128(:,:,88))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(16),n2h32(18))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(89),h0tab(:,89),[96,15,16],[0,0,0],3,2,wf4(:,11),wf16(:,78))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,11),G0H32(1),m3h4x32(:,19),heltab2x128(:,:,89))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(17),n2h32(19))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(266)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(90),h0tab(:,90),[96,15,16],[0,0,0],3,2,wf4(:,11),wf16(:,79))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,11),G0H32(1),m3h4x32(:,20),heltab2x128(:,:,90))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(18),n2h32(20))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(91),h0tab(:,91),[64,31,32],[0,0,0],3,1,wf32(:,54))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,34),heltab2x128(:,:,91))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(14),n2h64(34))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(92),h0tab(:,92),[64,31,32],[0,0,0],3,1,wf32(:,56))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,35),heltab2x128(:,:,92))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(15),n2h64(35))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(93),h0tab(:,93),[64,16,47],[0,0,0],3,1,wf32(:,58))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,36),heltab2x128(:,:,93))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(16),n2h64(36))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(223)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(94),h0tab(:,94),[64,16,47],[0,0,0],3,1,wf32(:,60))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,37),heltab2x128(:,:,94))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(17),n2h64(37))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(226)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(95),h0tab(:,95),[79,16,32],[0,0,0],3,1,wf32(:,61))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,61),G0H4(1),m3h32x4(:,22),heltab2x128(:,:,95))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(24),n2h4(40))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(227)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(96),h0tab(:,96),[79,16,32],[0,0,0],3,1,wf32(:,63))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,63),G0H4(1),ngZu,m3h32x4(:,23),heltab2x128(:,:,96))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(25),n2h4(41))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(228)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(97),h0tab(:,97),[64,31,32],[0,0,0],3,1,wf32(:,65))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,38),heltab2x128(:,:,97))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(18),n2h64(38))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(229)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(98),h0tab(:,98),[64,16,47],[0,0,0],3,1,wf32(:,67))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,39),heltab2x128(:,:,98))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(19),n2h64(39))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(231)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(99),h0tab(:,99),[79,16,32],[0,0,0],3,1,wf32(:,68))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,68),G0H4(1),m3h32x4(:,24),heltab2x128(:,:,99))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(26),n2h4(42))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(100),h0tab(:,100),[79,16,32],[0,0,0],3,1,wf32(:,70))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,70),G0H4(1),ngZu,m3h32x4(:,25),heltab2x128(:,:,100))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(27),n2h4(43))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(101),h0tab(:,101),[79,16,32],[0,0,0],3,1,wf32(:,72))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,72),G0H4(1),ngZu,m3h32x4(:,26),heltab2x128(:,:,101))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(28),n2h4(44))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(236)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(102),h0tab(:,102),[79,16,32],[0,0,0],3,1,wf32(:,73))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,73),G0H4(1),m3h32x4(:,27),heltab2x128(:,:,102))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(29),n2h4(45))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(237)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(103),h0tab(:,103),[79,16,32],[0,0,0],3,1,wf32(:,75))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,75),G0H4(1),ngZu,m3h32x4(:,28),heltab2x128(:,:,103))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(30),n2h4(46))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(239)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(104),h0tab(:,104),[79,16,32],[0,0,0],3,1,wf32(:,77))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,77),G0H4(1),ngZu,m3h32x4(:,29),heltab2x128(:,:,104))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(31),n2h4(47))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(241)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(105),h0tab(:,105),[79,16,32],[0,0,0],3,1,wf32(:,78))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,78),G0H4(1),m3h32x4(:,30),heltab2x128(:,:,105))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(32),n2h4(48))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(242)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(106),h0tab(:,106),[79,16,32],[0,0,0],3,1,wf32(:,80))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,80),G0H4(1),ngZu,m3h32x4(:,31),heltab2x128(:,:,106))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(33),n2h4(49))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(244)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(107),h0tab(:,107),[79,16,32],[0,0,0],3,1,wf32(:,82))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,82),G0H4(1),ngZu,m3h32x4(:,32),heltab2x128(:,:,107))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(34),n2h4(50))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(14),[G1H8(7),G1H8(6),G1H8(1),G1H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(13),[G1H8(12),G1H8(9),G1H8(2),G1H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(34),[G1H4(33),G1H4(32),G1H4(31),G1H4(30),G1H4(29) &
    ,G1H4(28),G1H4(27),G1H4(26),G1H4(25),G1H4(24),G1H4(23),G1H4(22),G1H4(21),G1H4(20),G1H4(19),G1H4(18),G1H4(17),G1H4(16),G1H4(15) &
    ,G1H4(14),G1H4(13),G1H4(12),G1H4(11),G1H4(10),G1H4(9),G1H4(8),G1H4(7),G1H4(6),G1H4(5),G1H4(4),G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(2),[G1H16(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(3),[G1H16(1)])
  call Hloop_QW_A(ntryL,G1H8(14),wf4(:,5),G1H2(1),m3h4x2(:,7),heltab2x8(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(1),n2h2(7))
  call Hloop_AW_Q(ntryL,G1H8(13),wf4(:,4),G1H2(2),m3h4x2(:,8),heltab2x8(:,:,16))
  call Hloop_A_Q(ntryL,G1H2(2),111,0,G2H2(2),n2h2(8))
  call Hloop_AQ_V(ntryL,G1H4(34),ex5(:),G1H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QW_A(ntryL,G1H32(1),wf4(:,4),G1H8(7),m3h4x8(:,3),heltab2x32(:,:,3))
  call Hloop_Q_A(ntryL,G1H8(7),85,0,G2H8(1),n2h8(13))
  call Hloop_QV_A(ntryL,G1H32(2),wf16(:,6),G1H2(6),m3h16x2(:,1),heltab2x32(:,:,4))
  call Hloop_Q_A(ntryL,G1H2(6),95,0,G2H2(3),n2h2(9))
  call Hloop_QZ_A(ntryL,G1H32(3),wf16(:,39),G1H2(7),ngZu,m3h16x2(:,2),heltab2x32(:,:,5))
  call Hloop_Q_A(ntryL,G1H2(7),95,0,G2H2(4),n2h2(10))
  call Hloop_AW_Q(ntryL,G1H32(4),wf4(:,5),G1H8(6),m3h4x8(:,4),heltab2x32(:,:,6))
  call Hloop_A_Q(ntryL,G1H8(6),106,0,G2H8(2),n2h8(14))
  call Hloop_AV_Q(ntryL,G1H32(5),wf16(:,6),G1H2(10),m3h16x2(:,3),heltab2x32(:,:,7))
  call Hloop_A_Q(ntryL,G1H2(10),111,0,G2H2(5),n2h2(11))
  call Hloop_AZ_Q(ntryL,G1H32(6),wf16(:,39),G1H2(11),ngZu,m3h16x2(:,4),heltab2x32(:,:,8))
  call Hloop_A_Q(ntryL,G1H2(11),111,0,G2H2(6),n2h2(12))
  call Hloop_AQ_V(ntryL,G1H64(1),wf8(:,11),G1H8(1),m3h8x8(:,1),heltab2x64(:,:,21))
  call Hloop_AQ_V(ntryL,G1H16(2),wf8(:,11),G1H2(12),m3h8x2(:,3),heltab2x16(:,:,7))
  call Hloop_AQ_V(ntryL,G1H64(2),wf32(:,4),G1H2(15),m3h32x2(:,1),heltab2x64(:,:,22))
  call Hloop_AQ_V(ntryL,G1H16(3),ex5(:),G1H8(3),m3h2x8(:,3),heltab2x16(:,:,8))
  call Hloop_AQ_V(ntryL,G1H64(3),ex5(:),G1H32(1),m3h2x32(:,1),heltab2x64(:,:,23))
  call Hloop_AQ_V(ntryL,G1H64(4),wf32(:,12),G1H2(16),m3h32x2(:,2),heltab2x64(:,:,24))
  call Hloop_AQ_V(ntryL,G1H64(5),wf32(:,14),G1H2(17),m3h32x2(:,3),heltab2x64(:,:,25))
  call Hloop_AQ_V(ntryL,G1H64(6),ex5(:),G1H32(2),m3h2x32(:,2),heltab2x64(:,:,26))
  call Hloop_AQ_V(ntryL,G1H64(7),ex5(:),G1H32(3),m3h2x32(:,3),heltab2x64(:,:,27))
  call Hloop_QV_A(ntryL,G1H32(7),wf16(:,19),G1H2(20),m3h16x2(:,5),heltab2x32(:,:,9))
  call Hloop_Q_A(ntryL,G1H2(20),95,0,G2H2(7),n2h2(13))
  call Hloop_QZ_A(ntryL,G1H32(8),wf16(:,75),G1H2(21),ngZu,m3h16x2(:,6),heltab2x32(:,:,10))
  call Hloop_Q_A(ntryL,G1H2(21),95,0,G2H2(9),n2h2(14))
  call Hloop_QZ_A(ntryL,G1H32(9),wf16(:,76),G1H2(22),ngZu,m3h16x2(:,7),heltab2x32(:,:,11))
  call Hloop_Q_A(ntryL,G1H2(22),95,0,G2H2(10),n2h2(15))
  call Hloop_AV_Q(ntryL,G1H32(10),wf16(:,19),G1H2(25),m3h16x2(:,8),heltab2x32(:,:,12))
  call Hloop_A_Q(ntryL,G1H2(25),111,0,G2H2(12),n2h2(16))
  call Hloop_AZ_Q(ntryL,G1H32(11),wf16(:,75),G1H2(26),ngZu,m3h16x2(:,9),heltab2x32(:,:,13))
  call Hloop_A_Q(ntryL,G1H2(26),111,0,G2H2(13),n2h2(17))
  call Hloop_AZ_Q(ntryL,G1H32(12),wf16(:,76),G1H2(27),ngZu,m3h16x2(:,10),heltab2x32(:,:,14))
  call Hloop_A_Q(ntryL,G1H2(27),111,0,G2H2(14),n2h2(18))
  call Hloop_AQ_V(ntryL,G1H64(8),wf32(:,27),G1H2(30),m3h32x2(:,4),heltab2x64(:,:,28))
  call Hloop_AQ_V(ntryL,G1H64(9),wf32(:,29),G1H2(1),m3h32x2(:,5),heltab2x64(:,:,29))
  call Hloop_AQ_V(ntryL,G1H64(10),ex5(:),G1H32(4),m3h2x32(:,4),heltab2x64(:,:,30))
  call Hloop_AQ_V(ntryL,G1H64(11),ex5(:),G1H32(5),m3h2x32(:,5),heltab2x64(:,:,31))
  call Hloop_AQ_V(ntryL,G1H64(12),wf32(:,38),G1H2(2),m3h32x2(:,6),heltab2x64(:,:,32))
  call Hloop_AQ_V(ntryL,G1H64(13),ex5(:),G1H32(6),m3h2x32(:,6),heltab2x64(:,:,33))
  call Hloop_QV_A(ntryL,G1H32(13),wf16(:,30),G1H2(6),m3h16x2(:,11),heltab2x32(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(6),95,0,G2H2(15),n2h2(19))
  call Hloop_QZ_A(ntryL,G1H32(14),wf16(:,78),G1H2(7),ngZu,m3h16x2(:,12),heltab2x32(:,:,16))
  call Hloop_Q_A(ntryL,G1H2(7),95,0,G2H2(16),n2h2(20))
  call Hloop_QZ_A(ntryL,G1H32(15),wf16(:,79),G1H2(10),ngZu,m3h16x2(:,13),heltab2x32(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(10),95,0,G2H2(17),n2h2(21))
  call Hloop_AV_Q(ntryL,G1H32(16),wf16(:,30),G1H2(11),m3h16x2(:,14),heltab2x32(:,:,18))
  call Hloop_A_Q(ntryL,G1H2(11),111,0,G2H2(18),n2h2(22))
  call Hloop_AZ_Q(ntryL,G1H32(17),wf16(:,78),G1H2(20),ngZu,m3h16x2(:,15),heltab2x32(:,:,19))
  call Hloop_A_Q(ntryL,G1H2(20),111,0,G2H2(19),n2h2(23))
  call Hloop_AZ_Q(ntryL,G1H32(18),wf16(:,79),G1H2(21),ngZu,m3h16x2(:,16),heltab2x32(:,:,20))
  call Hloop_A_Q(ntryL,G1H2(21),111,0,G2H2(20),n2h2(24))
  call Hloop_AQ_V(ntryL,G1H64(14),wf32(:,54),G1H2(22),m3h32x2(:,7),heltab2x64(:,:,34))
  call Hloop_AQ_V(ntryL,G1H64(15),wf32(:,56),G1H2(25),m3h32x2(:,8),heltab2x64(:,:,35))
  call Hloop_AQ_V(ntryL,G1H64(16),ex5(:),G1H32(7),m3h2x32(:,7),heltab2x64(:,:,36))
  call Hloop_AQ_V(ntryL,G1H64(17),ex5(:),G1H32(8),m3h2x32(:,8),heltab2x64(:,:,37))
  call Hloop_AQ_V(ntryL,G1H64(18),wf32(:,65),G1H2(26),m3h32x2(:,9),heltab2x64(:,:,38))
  call Hloop_AQ_V(ntryL,G1H64(19),ex5(:),G1H32(9),m3h2x32(:,9),heltab2x64(:,:,39))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G2H2(16),G2H2(15),G2H2(10),G2H2(9),G2H2(7),G2H2(4) &
    ,G2H2(3),G2H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G2H2(19),G2H2(18),G2H2(14),G2H2(13),G2H2(12),G2H2(6) &
    ,G2H2(5),G2H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(12),[G1H2(19),G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(26),[G1H2(25),G1H2(22),G1H2(2),G1H2(1),G1H2(30),G1H2(17) &
    ,G1H2(16),G1H2(15),G1H2(29),G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(23),[G1H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(13),[G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(24),[G1H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(3),[G1H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1),[G1H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(5),[G1H2(28),G1H2(18)])
call HGT_w2_OLR(G1H4(1),1,1,4)
call HGT_w2_invQ_OLR(G1H4(1),2,5,4)
  call Hloop_QW_A(ntryL,G1H4(1),wf4(:,5),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(1),n2h1(25))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(17),ex6(:),G2tensor(3),m3h2x1(:,23),heltab2x2(:,:,23))
call HGT_w2_OLR(G1H4(2),1,1,4)
call HGT_w2_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_AW_Q(ntryL,G1H4(2),wf4(:,4),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(5),n2h1(26))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(20),ex5(:),G2tensor(8),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hloop_VA_Q(ntryL,G1H2(12),ex6(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(11),n2h1(27))
  call Hloop_VA_Q(ntryL,G1H2(26),ex6(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(14),n2h1(28))
  call Hloop_VQ_A(ntryL,G1H8(4),wf8(:,11),G1H1(1),m3h8x1(:,7),heltab2x8(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(17),n2h1(29))
  call Hloop_VQ_A(ntryL,G1H8(5),wf8(:,11),G1H1(1),m3h8x1(:,8),heltab2x8(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(20),n2h1(30))
  call Hloop_VQ_A(ntryL,G1H2(23),ex5(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(23),n2h1(31))
  call Hloop_VQ_A(ntryL,G1H2(13),ex5(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(26),n2h1(32))
  call Hloop_VQ_A(ntryL,G1H2(24),ex5(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(29),n2h1(33))
  call Hloop_VA_Q(ntryL,G1H8(3),wf8(:,6),G1H1(1),m3h8x1(:,9),heltab2x8(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(30),n2h1(34))
  call Hloop_VA_Q(ntryL,G1H8(1),wf8(:,6),G1H1(1),m3h8x1(:,10),heltab2x8(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(31),n2h1(35))
  call Hloop_VA_Q(ntryL,G1H2(5),ex6(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(32),n2h1(36))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(1),ex6(:),G2tensor(33),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(2),ex5(:),G2tensor(34),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(1),wf8(:,6),G2tensor(35),m3h8x1(:,11),heltab2x8(:,:,21))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(2),wf8(:,11),G2tensor(36),m3h8x1(:,12),heltab2x8(:,:,22))
  call Hloop_VA_Q(ntryL,G1H32(1),wf32(:,8),G1H1(1),m3h32x1(:,1),heltab2x32(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(37),n2h1(37))
  call Hloop_VA_Q(ntryL,G1H32(2),wf32(:,16),G1H1(1),m3h32x1(:,2),heltab2x32(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(38),n2h1(38))
  call Hloop_VA_Q(ntryL,G1H32(3),wf32(:,18),G1H1(1),m3h32x1(:,3),heltab2x32(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(39),n2h1(39))
  call Hloop_VA_Q(ntryL,G1H32(4),wf32(:,31),G1H1(1),m3h32x1(:,4),heltab2x32(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(40),n2h1(40))
  call Hloop_VA_Q(ntryL,G1H32(5),wf32(:,33),G1H1(1),m3h32x1(:,5),heltab2x32(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(41),n2h1(41))
  call Hloop_VA_Q(ntryL,G1H32(6),wf32(:,40),G1H1(1),m3h32x1(:,6),heltab2x32(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(42),n2h1(42))
  call Hloop_VA_Q(ntryL,G1H32(7),wf32(:,58),G1H1(1),m3h32x1(:,7),heltab2x32(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(43),n2h1(43))
  call Hloop_VA_Q(ntryL,G1H32(8),wf32(:,60),G1H1(1),m3h32x1(:,8),heltab2x32(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(44),n2h1(44))
  call Hloop_VA_Q(ntryL,G1H32(9),wf32(:,67),G1H1(1),m3h32x1(:,9),heltab2x32(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(45),n2h1(45))
  call ol_merge_tensors(G2tensor(35),[G2tensor(15),G2tensor(2),G1tensor(27),G1tensor(5),G0tensor(27),G0tensor(5)])
  call ol_merge_tensors(G2tensor(36),[G2tensor(6),G2tensor(4),G1tensor(12),G1tensor(10),G0tensor(12),G0tensor(10)])
  call ol_merge_tensors(G2tensor(10),[G2tensor(7),G1tensor(20),G1tensor(15),G0tensor(20),G0tensor(15)])
  call ol_merge_tensors(G2tensor(33),[G2tensor(12),G2tensor(9),G1tensor(22),G1tensor(17),G1tensor(3),G0tensor(22),G0tensor(17) &
    ,G0tensor(3)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(25),G0tensor(25)])
  call ol_merge_tensors(G2tensor(19),[G2tensor(16),G1tensor(35),G1tensor(30),G0tensor(35),G0tensor(30)])
  call ol_merge_tensors(G2tensor(34),[G2tensor(21),G2tensor(18),G1tensor(37),G1tensor(32),G1tensor(8),G0tensor(37),G0tensor(32) &
    ,G0tensor(8)])
  call ol_merge_tensors(G2tensor(22),[G1tensor(40),G0tensor(40)])
  call ol_merge_tensors(G2tensor(3),[G2tensor(24),G1tensor(42),G1tensor(4),G0tensor(42),G0tensor(4)])
  call ol_merge_tensors(G2tensor(28),[G2tensor(25),G1tensor(50),G1tensor(45),G0tensor(50),G0tensor(45)])
  call ol_merge_tensors(G2tensor(8),[G2tensor(27),G1tensor(47),G1tensor(9),G0tensor(47),G0tensor(9)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(2),G0tensor(2)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(7),G0tensor(7)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(39),G1tensor(13),G0tensor(39),G0tensor(13)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(49),G1tensor(14),G0tensor(49),G0tensor(14)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(18),G0tensor(18)])
  call ol_merge_tensors(G2tensor(20),[G1tensor(19),G0tensor(19)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(43),G1tensor(23),G0tensor(43),G0tensor(23)])
  call ol_merge_tensors(G2tensor(26),[G1tensor(28),G1tensor(24),G0tensor(28),G0tensor(24)])
  call ol_merge_tensors(G2tensor(29),[G1tensor(44),G1tensor(29),G0tensor(44),G0tensor(29)])
  call ol_merge_tensors(G2tensor(30),[G1tensor(33),G0tensor(33)])
  call ol_merge_tensors(G2tensor(31),[G1tensor(34),G0tensor(34)])
  call ol_merge_tensors(G2tensor(32),[G1tensor(48),G1tensor(38),G0tensor(48),G0tensor(38)])
  call ol_merge_tensors(G2tensor(45),[G2tensor(44),G2tensor(43),G2tensor(42),G2tensor(41),G2tensor(40),G2tensor(39),G2tensor(38) &
    ,G2tensor(37)])
  call TI_triangle_red(G2tensor(35),RedBasis(1),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1)
  call TI_triangle_red(G2tensor(36),RedBasis(4),mass3set(:,1),G0tensor(21),G0tensor(26),G0tensor(31),G0tensor(36),M2L1R1)
  call TI_triangle_red(G2tensor(10),RedBasis(7),mass3set(:,1),G0tensor(41),G0tensor(46),G0tensor(27),G0tensor(5),M2L1R1)
  call TI_triangle_red(G2tensor(33),RedBasis(3),mass3set(:,1),G0tensor(12),G0tensor(10),G0tensor(20),G0tensor(15),M2L1R1)
  call TI_triangle_red(G2tensor(13),RedBasis(12),mass3set(:,1),G0tensor(22),G0tensor(17),G0tensor(3),G0tensor(25),M2L1R1)
  call TI_triangle_red(G2tensor(19),RedBasis(15),mass3set(:,1),G0tensor(35),G0tensor(30),G0tensor(37),G0tensor(32),M2L1R1)
  call TI_triangle_red(G2tensor(34),RedBasis(6),mass3set(:,1),G0tensor(8),G0tensor(40),G0tensor(42),G0tensor(4),M2L1R1)
  call TI_triangle_red(G2tensor(22),RedBasis(19),mass3set(:,1),G0tensor(50),G0tensor(45),G0tensor(47),G0tensor(9),M2L1R1)
  call TI_triangle_red(G2tensor(3),RedBasis(2),mass3set(:,1),G0tensor(2),G0tensor(7),G0tensor(39),G0tensor(13),M2L1R1)
  call TI_triangle_red(G2tensor(28),RedBasis(21),mass3set(:,1),G0tensor(49),G0tensor(14),G0tensor(18),G0tensor(19),M2L1R1)
  call TI_triangle_red(G2tensor(8),RedBasis(5),mass3set(:,1),G0tensor(43),G0tensor(23),G0tensor(28),G0tensor(24),M2L1R1)
  call TI_triangle_red(G2tensor(1),RedBasis(22),mass3set(:,1),G0tensor(44),G0tensor(29),G0tensor(33),G0tensor(34),M2L1R1)
  call TI_triangle_red(G2tensor(5),RedBasis(23),mass3set(:,1),G0tensor(48),G0tensor(38),G0tensor(51),G0tensor(52),M2L1R1)
  call TI_triangle_red(G2tensor(11),RedBasis(9),mass3set(:,1),G0tensor(53),G0tensor(54),G0tensor(55),G0tensor(56),M2L1R1)
  call TI_triangle_red(G2tensor(14),RedBasis(8),mass3set(:,1),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60),M2L1R1)
  call TI_triangle_red(G2tensor(17),RedBasis(11),mass3set(:,1),G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),M2L1R1)
  call TI_triangle_red(G2tensor(20),RedBasis(10),mass3set(:,1),G0tensor(65),G0tensor(66),G0tensor(67),G0tensor(68),M2L1R1)
  call TI_triangle_red(G2tensor(23),RedBasis(14),mass3set(:,1),G0tensor(69),G0tensor(70),G0tensor(71),G0tensor(72),M2L1R1)
  call TI_triangle_red(G2tensor(26),RedBasis(13),mass3set(:,1),G0tensor(73),G0tensor(74),G0tensor(75),G0tensor(76),M2L1R1)
  call TI_triangle_red(G2tensor(29),RedBasis(16),mass3set(:,1),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80),M2L1R1)
  call TI_triangle_red(G2tensor(30),RedBasis(18),mass3set(:,1),G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),M2L1R1)
  call TI_triangle_red(G2tensor(31),RedBasis(17),mass3set(:,1),G0tensor(85),G0tensor(86),G0tensor(87),G0tensor(88),M2L1R1)
  call TI_triangle_red(G2tensor(32),RedBasis(20),mass3set(:,1),G0tensor(89),G0tensor(90),G0tensor(91),G0tensor(92),M2L1R1)
  call TI_triangle_red(G2tensor(45),RedBasis(24),mass3set(:,1),G0tensor(93),G0tensor(94),G0tensor(95),G0tensor(96),M2L1R1)
  call ol_merge_tensors(T0sum(11),[G0tensor(1)])
  call ol_merge_tensors(T0sum(12),[G0tensor(21)])
  call ol_merge_tensors(T0sum(13),[G0tensor(41)])
  call ol_merge_tensors(T0sum(14),[G0tensor(12)])
  call ol_merge_tensors(T0sum(15),[G0tensor(22)])
  call ol_merge_tensors(T0sum(16),[G0tensor(35)])
  call ol_merge_tensors(T0sum(17),[G0tensor(8)])
  call ol_merge_tensors(T0sum(18),[G0tensor(50)])
  call ol_merge_tensors(T0sum(19),[G0tensor(2)])
  call ol_merge_tensors(T0sum(20),[G0tensor(49)])
  call ol_merge_tensors(T0sum(21),[G0tensor(43)])
  call ol_merge_tensors(T0sum(22),[G0tensor(44)])
  call ol_merge_tensors(T0sum(23),[G0tensor(48)])
  call ol_merge_tensors(T0sum(24),[G0tensor(53)])
  call ol_merge_tensors(T0sum(25),[G0tensor(57)])
  call ol_merge_tensors(T0sum(26),[G0tensor(61)])
  call ol_merge_tensors(T0sum(27),[G0tensor(65)])
  call ol_merge_tensors(T0sum(28),[G0tensor(69)])
  call ol_merge_tensors(T0sum(29),[G0tensor(73)])
  call ol_merge_tensors(T0sum(30),[G0tensor(77)])
  call ol_merge_tensors(T0sum(31),[G0tensor(81)])
  call ol_merge_tensors(T0sum(32),[G0tensor(85)])
  call ol_merge_tensors(T0sum(33),[G0tensor(89)])
  call ol_merge_tensors(T0sum(34),[G0tensor(93)])
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(130)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(108),h0tab(:,108),[85,42],[0,0],2,2,wf16(:,40),wf8(:,6))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,40),G0H8(1),m3h16x8(:,9),heltab2x128(:,:,108))
  call Hloop_Q_A(ntryL,G0H8(1),85,0,G1H8(12),n2h8(15))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(267)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(109),h0tab(:,109),[80,47],[0,0],2,2,wf4(:,9),wf32(:,8))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,21),heltab2x128(:,:,109))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(110),h0tab(:,110),[80,47],[0,0],2,2,wf4(:,9),wf32(:,16))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,9),G0H32(2),m3h4x32(:,22),heltab2x128(:,:,110))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(111),h0tab(:,111),[80,47],[0,0],2,2,wf4(:,9),wf32(:,18))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,9),G0H32(3),m3h4x32(:,23),heltab2x128(:,:,111))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(112),h0tab(:,112),[96,31],[0,0],2,2,wf4(:,11),wf32(:,4))
  call Hloop_QA_V(ntryL,G0H128(1),wf4(:,11),G0H32(4),m3h4x32(:,24),heltab2x128(:,:,112))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(134)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(113),h0tab(:,113),[106,21],[0,0],2,2,wf16(:,44),wf8(:,11))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,44),G0H8(1),m3h16x8(:,10),heltab2x128(:,:,113))
  call Hloop_A_Q(ntryL,G0H8(1),106,0,G1H8(9),n2h8(16))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(114),h0tab(:,114),[96,31],[0,0],2,2,wf4(:,11),wf32(:,12))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,11),G0H32(5),m3h4x32(:,25),heltab2x128(:,:,114))
  call Hloop_A_Q(ntryL,G0H32(5),96,0,G1H32(10),n2h32(21))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(115),h0tab(:,115),[96,31],[0,0],2,2,wf4(:,11),wf32(:,14))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,11),G0H32(5),m3h4x32(:,26),heltab2x128(:,:,115))
  call Hloop_A_Q(ntryL,G0H32(5),96,0,G1H32(11),n2h32(22))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(144)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(116),h0tab(:,116),[85,42],[0,0],2,2,wf16(:,73),wf8(:,6))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,73),G0H8(1),m3h16x8(:,11),heltab2x128(:,:,116))
  call Hloop_Q_A(ntryL,G0H8(1),85,0,G1H8(2),n2h8(17))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(142)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(117),h0tab(:,117),[106,21],[0,0],2,2,wf16(:,72),wf8(:,11))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,72),G0H8(1),m3h16x8(:,12),heltab2x128(:,:,117))
  call Hloop_A_Q(ntryL,G0H8(1),106,0,G1H8(8),n2h8(18))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(118),h0tab(:,118),[106,21],[0,0],2,2,wf16(:,68),wf8(:,11))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,68),G0H8(1),m3h16x8(:,13),heltab2x128(:,:,118))
  call Hloop_A_Q(ntryL,G0H8(1),106,0,G1H8(14),n2h8(19))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(119),h0tab(:,119),[85,42],[0,0],2,2,wf16(:,70),wf8(:,6))
  call Hloop_AQ_V(ntryL,G0H128(1),wf16(:,70),G0H8(1),m3h16x8(:,14),heltab2x128(:,:,119))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(146)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(120),h0tab(:,120),[106,21],[0,0],2,2,wf16(:,74),wf8(:,11))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,74),G0H8(2),m3h16x8(:,15),heltab2x128(:,:,120))
  call Hloop_A_Q(ntryL,G0H8(2),106,0,G1H8(13),n2h8(20))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(121),h0tab(:,121),[80,47],[0,0],2,2,wf4(:,9),wf32(:,31))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,9),G0H32(5),m3h4x32(:,27),heltab2x128(:,:,121))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(122),h0tab(:,122),[80,47],[0,0],2,2,wf4(:,9),wf32(:,33))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,9),G0H32(6),m3h4x32(:,28),heltab2x128(:,:,122))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(123),h0tab(:,123),[80,47],[0,0],2,2,wf4(:,9),wf32(:,40))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,9),G0H32(7),m3h4x32(:,29),heltab2x128(:,:,123))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(276)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(124),h0tab(:,124),[96,31],[0,0],2,2,wf4(:,11),wf32(:,27))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,11),G0H32(8),m3h4x32(:,30),heltab2x128(:,:,124))
  call Hloop_A_Q(ntryL,G0H32(8),96,0,G1H32(12),n2h32(23))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(125),h0tab(:,125),[96,31],[0,0],2,2,wf4(:,11),wf32(:,29))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,11),G0H32(8),m3h4x32(:,31),heltab2x128(:,:,125))
  call Hloop_A_Q(ntryL,G0H32(8),96,0,G1H32(13),n2h32(24))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(278)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(126),h0tab(:,126),[96,31],[0,0],2,2,wf4(:,11),wf32(:,38))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,11),G0H32(8),m3h4x32(:,32),heltab2x128(:,:,126))
  call Hloop_A_Q(ntryL,G0H32(8),96,0,G1H32(14),n2h32(25))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(157)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(127),h0tab(:,127),[85,42],[0,0],2,2,wf16(:,77),wf8(:,6))
  call Hloop_AQ_V(ntryL,G0H128(1),wf16(:,77),G0H8(2),m3h16x8(:,16),heltab2x128(:,:,127))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(279)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(128),h0tab(:,128),[80,47],[0,0],2,2,wf4(:,9),wf32(:,58))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,9),G0H32(8),m3h4x32(:,33),heltab2x128(:,:,128))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(280)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(129),h0tab(:,129),[80,47],[0,0],2,2,wf4(:,9),wf32(:,60))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,9),G0H32(9),m3h4x32(:,34),heltab2x128(:,:,129))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(281)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(130),h0tab(:,130),[80,47],[0,0],2,2,wf4(:,9),wf32(:,67))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,9),G0H32(10),m3h4x32(:,35),heltab2x128(:,:,130))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(282)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(131),h0tab(:,131),[96,31],[0,0],2,2,wf4(:,11),wf32(:,54))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,11),G0H32(11),m3h4x32(:,36),heltab2x128(:,:,131))
  call Hloop_A_Q(ntryL,G0H32(11),96,0,G1H32(15),n2h32(26))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(283)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(132),h0tab(:,132),[96,31],[0,0],2,2,wf4(:,11),wf32(:,56))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,11),G0H32(11),m3h4x32(:,37),heltab2x128(:,:,132))
  call Hloop_A_Q(ntryL,G0H32(11),96,0,G1H32(16),n2h32(27))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(284)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(133),h0tab(:,133),[96,31],[0,0],2,2,wf4(:,11),wf32(:,65))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,11),G0H32(11),m3h4x32(:,38),heltab2x128(:,:,133))
  call Hloop_A_Q(ntryL,G0H32(11),96,0,G1H32(17),n2h32(28))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(2),[G1H8(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(13),[G1H8(14),G1H8(8),G1H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(2),[G0H8(1)])
  call Hcheck_last_QA_V(ntryL,l_switch,G1H8(2),wf8(:,6),G1tensor(1),m3h8x1(:,13),heltab2x8(:,:,23))
  call Hloop_VA_Q(ntryL,G0H32(1),wf32(:,8),G0H1(1),m3h32x1(:,10),heltab2x32(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,0,G1tensor(6),n2h1(46))
  call Hloop_VA_Q(ntryL,G0H32(2),wf32(:,16),G0H1(1),m3h32x1(:,11),heltab2x32(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,0,G1tensor(11),n2h1(47))
  call Hloop_VA_Q(ntryL,G0H32(3),wf32(:,18),G0H1(1),m3h32x1(:,12),heltab2x32(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,0,G1tensor(16),n2h1(48))
  call Hloop_VQ_A(ntryL,G0H32(4),wf32(:,4),G0H1(1),m3h32x1(:,13),heltab2x32(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),127,0,G1tensor(21),n2h1(49))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(13),wf8(:,11),G1tensor(26),m3h8x1(:,14),heltab2x8(:,:,24))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H32(10),wf32(:,12),G1tensor(31),m3h32x1(:,14),heltab2x32(:,:,34))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H32(11),wf32(:,14),G1tensor(36),m3h32x1(:,15),heltab2x32(:,:,35))
  call Hloop_VA_Q(ntryL,G0H8(2),wf8(:,6),G0H1(1),m3h8x1(:,15),heltab2x8(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,0,G1tensor(41),n2h1(50))
  call Hloop_VA_Q(ntryL,G0H32(5),wf32(:,31),G0H1(1),m3h32x1(:,16),heltab2x32(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,0,G1tensor(46),n2h1(51))
  call Hloop_VA_Q(ntryL,G0H32(6),wf32(:,33),G0H1(1),m3h32x1(:,17),heltab2x32(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,0,G1tensor(27),n2h1(52))
  call Hloop_VA_Q(ntryL,G0H32(7),wf32(:,40),G0H1(1),m3h32x1(:,18),heltab2x32(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,0,G1tensor(5),n2h1(53))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H32(12),wf32(:,27),G1tensor(12),m3h32x1(:,19),heltab2x32(:,:,39))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H32(13),wf32(:,29),G1tensor(10),m3h32x1(:,20),heltab2x32(:,:,40))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H32(14),wf32(:,38),G1tensor(20),m3h32x1(:,21),heltab2x32(:,:,41))
  call Hloop_VA_Q(ntryL,G0H32(8),wf32(:,58),G0H1(1),m3h32x1(:,22),heltab2x32(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,0,G1tensor(15),n2h1(54))
  call Hloop_VA_Q(ntryL,G0H32(9),wf32(:,60),G0H1(1),m3h32x1(:,23),heltab2x32(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,0,G1tensor(22),n2h1(55))
  call Hloop_VA_Q(ntryL,G0H32(10),wf32(:,67),G0H1(1),m3h32x1(:,24),heltab2x32(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,0,G1tensor(17),n2h1(56))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H32(15),wf32(:,54),G1tensor(3),m3h32x1(:,25),heltab2x32(:,:,45))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H32(16),wf32(:,56),G1tensor(25),m3h32x1(:,26),heltab2x32(:,:,46))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H32(17),wf32(:,65),G1tensor(35),m3h32x1(:,27),heltab2x32(:,:,47))
  call ol_merge_tensors(G0tensor(51),[G0tensor(29),G0tensor(45),G0tensor(40),G0tensor(30),G0tensor(6)])
  call ol_merge_tensors(G1tensor(41),[G1tensor(1),G0tensor(87),G0tensor(83),G0tensor(74),G0tensor(66),G0tensor(15),G0tensor(11)])
  call ol_merge_tensors(G1tensor(17),[G1tensor(22),G1tensor(15),G1tensor(5),G1tensor(27),G1tensor(46),G1tensor(16),G1tensor(11) &
    ,G1tensor(6),G0tensor(95),G0tensor(78),G0tensor(13),G0tensor(16)])
  call ol_merge_tensors(G0tensor(38),[G0tensor(33),G0tensor(17),G0tensor(10),G0tensor(46),G0tensor(26)])
  call ol_merge_tensors(G1tensor(26),[G0tensor(86),G0tensor(67),G0tensor(63),G0tensor(54),G0tensor(4),G0tensor(31)])
  call ol_merge_tensors(G1tensor(35),[G1tensor(25),G1tensor(3),G1tensor(20),G1tensor(10),G1tensor(12),G1tensor(36),G1tensor(31) &
    ,G1tensor(21),G0tensor(58),G0tensor(24),G0tensor(36)])
  call ol_merge_tensors(G0tensor(64),[G0tensor(56),G0tensor(9),G0tensor(27)])
  call ol_merge_tensors(G0tensor(96),[G0tensor(88),G0tensor(80),G0tensor(68),G0tensor(60),G0tensor(19),G0tensor(32),G0tensor(5)])
  call ol_merge_tensors(G0tensor(91),[G0tensor(70),G0tensor(62),G0tensor(59),G0tensor(55),G0tensor(39),G0tensor(20)])
  call ol_merge_tensors(G0tensor(92),[G0tensor(72),G0tensor(18),G0tensor(47),G0tensor(3)])
  call ol_merge_tensors(G0tensor(84),[G0tensor(76),G0tensor(37),G0tensor(25)])
  call ol_merge_tensors(G0tensor(94),[G0tensor(90),G0tensor(82),G0tensor(79),G0tensor(75),G0tensor(71),G0tensor(28) &
    ,G0tensor(42)])
  call ol_merge_tensors(G0tensor(52),[G0tensor(34),G0tensor(23),G0tensor(14),G0tensor(7)])
call TI_bubble_red(G1tensor(41),85,mass2set(:,1),G0tensor(1),M2L1R1)
call TI_bubble_red(G1tensor(17),80,mass2set(:,1),G0tensor(21),M2L1R1)
call TI_bubble_red(G1tensor(26),106,mass2set(:,1),G0tensor(41),M2L1R1)
call TI_bubble_red(G1tensor(35),96,mass2set(:,1),G0tensor(12),M2L1R1)
  call ol_merge_tensors(T0sum(35),[G0tensor(51)])
  call ol_merge_tensors(T0sum(36),[G0tensor(1)])
  call ol_merge_tensors(T0sum(37),[G0tensor(21)])
  call ol_merge_tensors(T0sum(38),[G0tensor(38)])
  call ol_merge_tensors(T0sum(39),[G0tensor(41)])
  call ol_merge_tensors(T0sum(40),[G0tensor(12)])
  call ol_merge_tensors(T0sum(41),[G0tensor(64)])
  call ol_merge_tensors(T0sum(42),[G0tensor(96)])
  call ol_merge_tensors(T0sum(43),[G0tensor(91)])
  call ol_merge_tensors(T0sum(44),[G0tensor(92)])
  call ol_merge_tensors(T0sum(45),[G0tensor(84)])
  call ol_merge_tensors(T0sum(46),[G0tensor(94)])
  call ol_merge_tensors(T0sum(47),[G0tensor(52)])
! end of process


end subroutine vamp_1

end module ol_vamp_1_pplllla_nexnmemxuuxa_1_/**/REALKIND
