
module ol_vamp_1_pplllla_nenexnmnmxddxa_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pplllla_nenexnmnmxddxa_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pplllla_nenexnmnmxddxa_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pplllla_nenexnmnmxddxa_1_/**/DREALKIND
  use ol_tensor_sum_storage_pplllla_nenexnmnmxddxa_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red

  use ol_loop_storage_pplllla_nenexnmnmxddxa_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pplllla_nenexnmnmxddxa_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(109)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1),h0tab(:,1),[80,12,3,32],[0,0,0,0],4,3,wf4(:,6),wf4(:,5),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,6),G0H32(1),m3h4x32(:,1),heltab2x128(:,:,1))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(1),n2h32(1))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(109)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(2),h0tab(:,2),[80,3,12,32],[0,0,0,0],4,3,wf4(:,6),wf4(:,4),wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,6),G0H32(1),m3h4x32(:,2),heltab2x128(:,:,2))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(2),n2h32(2))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(3),h0tab(:,3),[96,12,3,16],[0,0,0,0],4,3,wf4(:,8),wf4(:,5),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(1),m3h4x32(:,3),heltab2x128(:,:,3))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(3),n2h32(3))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(4),h0tab(:,4),[96,3,12,16],[0,0,0,0],4,3,wf4(:,8),wf4(:,4),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(1),m3h4x32(:,4),heltab2x128(:,:,4))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(4),n2h32(4))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(5),h0tab(:,5),[64,12,19,32],[0,0,0,0],4,2,wf4(:,5),wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1),heltab2x128(:,:,5))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(1),n2h64(1))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(6),h0tab(:,6),[64,12,32,19],[0,0,0,0],4,2,wf4(:,5),wf8(:,6))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,2),heltab2x128(:,:,6))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(2),n2h64(2))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(7),h0tab(:,7),[64,12,35,16],[0,0,0,0],4,2,wf4(:,5),wf8(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,3),heltab2x128(:,:,7))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(3),n2h64(3))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(8),h0tab(:,8),[64,12,16,35],[0,0,0,0],4,2,wf4(:,5),wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,4),heltab2x128(:,:,8))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(4),n2h64(4))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(9),h0tab(:,9),[64,3,28,32],[0,0,0,0],4,2,wf4(:,4),wf8(:,8))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,5),heltab2x128(:,:,9))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(5),n2h64(5))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(10),h0tab(:,10),[64,3,32,28],[0,0,0,0],4,2,wf4(:,4),wf8(:,8))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,6),heltab2x128(:,:,10))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(6),n2h64(6))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(97)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(11),h0tab(:,11),[64,3,44,16],[0,0,0,0],4,2,wf4(:,4),wf8(:,4))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,7),heltab2x128(:,:,11))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(7),n2h64(7))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(97)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(12),h0tab(:,12),[64,3,16,44],[0,0,0,0],4,2,wf4(:,4),wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,8),heltab2x128(:,:,12))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(8),n2h64(8))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(13),h0tab(:,13),[64,15,32,16],[0,0,0,0],4,1,wf16(:,37))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,9),heltab2x128(:,:,13))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(9),n2h64(9))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(14),h0tab(:,14),[64,15,16,32],[0,0,0,0],4,1,wf16(:,37))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,10),heltab2x128(:,:,14))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(10),n2h64(10))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(15),h0tab(:,15),[64,15,32,16],[0,0,0,0],4,1,wf16(:,38))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,11),heltab2x128(:,:,15))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(11),n2h64(11))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(16),h0tab(:,16),[64,15,16,32],[0,0,0,0],4,1,wf16(:,38))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,12),heltab2x128(:,:,16))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(12),n2h64(12))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(17),h0tab(:,17),[64,15,32,16],[0,0,0,0],4,1,wf16(:,39))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,13),heltab2x128(:,:,17))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(13),n2h64(13))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(18),h0tab(:,18),[64,15,16,32],[0,0,0,0],4,1,wf16(:,39))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,14),heltab2x128(:,:,18))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(14),n2h64(14))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(19),h0tab(:,19),[64,15,32,16],[0,0,0,0],4,1,wf16(:,40))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,15),heltab2x128(:,:,19))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(15),n2h64(15))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(20),h0tab(:,20),[64,15,16,32],[0,0,0,0],4,1,wf16(:,40))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,16),heltab2x128(:,:,20))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(16),n2h64(16))
  call Hloop_QZ_A(ntryL,G1H32(1),wf4(:,5),G1H8(1),ngZd,m3h4x8(:,1),heltab2x32(:,:,1))
  call Hloop_Q_A(ntryL,G1H8(1),92,0,G2H8(1),n2h8(1))
  call Hloop_QZ_A(ntryL,G1H32(2),wf4(:,4),G1H8(1),ngZd,m3h4x8(:,2),heltab2x32(:,:,2))
  call Hloop_Q_A(ntryL,G1H8(1),83,0,G2H8(2),n2h8(2))
  call Hloop_AZ_Q(ntryL,G1H32(3),wf4(:,5),G1H8(1),ngZd,m3h4x8(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G1H8(1),108,0,G2H8(3),n2h8(3))
  call Hloop_AZ_Q(ntryL,G1H32(4),wf4(:,4),G1H8(1),ngZd,m3h4x8(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G1H8(1),99,0,G2H8(4),n2h8(4))
  call Hloop_AZ_Q(ntryL,G1H64(1),wf4(:,5),G1H16(1),ngZd,m3h4x16(:,1),heltab2x64(:,:,1))
  call Hloop_A_Q(ntryL,G1H16(1),76,0,G2H16(1),n2h16(1))
  call Hloop_QZ_A(ntryL,G1H64(2),wf4(:,5),G1H16(1),ngZd,m3h4x16(:,2),heltab2x64(:,:,2))
  call Hloop_Q_A(ntryL,G1H16(1),76,0,G2H16(2),n2h16(2))
  call Hloop_QZ_A(ntryL,G1H64(3),wf4(:,5),G1H16(1),ngZd,m3h4x16(:,3),heltab2x64(:,:,3))
  call Hloop_Q_A(ntryL,G1H16(1),76,0,G2H16(3),n2h16(3))
  call Hloop_AZ_Q(ntryL,G1H64(4),wf4(:,5),G1H16(1),ngZd,m3h4x16(:,4),heltab2x64(:,:,4))
  call Hloop_A_Q(ntryL,G1H16(1),76,0,G2H16(4),n2h16(4))
  call Hloop_AZ_Q(ntryL,G1H64(5),wf4(:,4),G1H16(1),ngZd,m3h4x16(:,5),heltab2x64(:,:,5))
  call Hloop_A_Q(ntryL,G1H16(1),67,0,G2H16(5),n2h16(5))
  call Hloop_QZ_A(ntryL,G1H64(6),wf4(:,4),G1H16(1),ngZd,m3h4x16(:,6),heltab2x64(:,:,6))
  call Hloop_Q_A(ntryL,G1H16(1),67,0,G2H16(6),n2h16(6))
  call Hloop_QZ_A(ntryL,G1H64(7),wf4(:,4),G1H16(1),ngZd,m3h4x16(:,7),heltab2x64(:,:,7))
  call Hloop_Q_A(ntryL,G1H16(1),67,0,G2H16(7),n2h16(7))
  call Hloop_AZ_Q(ntryL,G1H64(8),wf4(:,4),G1H16(1),ngZd,m3h4x16(:,8),heltab2x64(:,:,8))
  call Hloop_A_Q(ntryL,G1H16(1),67,0,G2H16(8),n2h16(8))
  call Hloop_QZ_A(ntryL,G1H64(9),wf16(:,37),G1H4(1),ngZd,m3h16x4(:,1),heltab2x64(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(1),n2h4(1))
  call Hloop_AZ_Q(ntryL,G1H64(10),wf16(:,37),G1H4(1),ngZd,m3h16x4(:,2),heltab2x64(:,:,10))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(2),n2h4(2))
  call Hloop_QZ_A(ntryL,G1H64(11),wf16(:,38),G1H4(1),ngZd,m3h16x4(:,3),heltab2x64(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(3),n2h4(3))
  call Hloop_AZ_Q(ntryL,G1H64(12),wf16(:,38),G1H4(1),ngZd,m3h16x4(:,4),heltab2x64(:,:,12))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(4),n2h4(4))
  call Hloop_QZ_A(ntryL,G1H64(13),wf16(:,39),G1H4(1),ngZd,m3h16x4(:,5),heltab2x64(:,:,13))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(5),n2h4(5))
  call Hloop_AZ_Q(ntryL,G1H64(14),wf16(:,39),G1H4(1),ngZd,m3h16x4(:,6),heltab2x64(:,:,14))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(6),n2h4(6))
  call Hloop_QZ_A(ntryL,G1H64(15),wf16(:,40),G1H4(1),ngZd,m3h16x4(:,7),heltab2x64(:,:,15))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(7),n2h4(7))
  call Hloop_AZ_Q(ntryL,G1H64(16),wf16(:,40),G1H4(1),ngZd,m3h16x4(:,8),heltab2x64(:,:,16))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(8),n2h4(8))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G2H4(5),G2H4(3),G2H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G2H4(6),G2H4(4),G2H4(2)])
  call Hotf_4pt_reduction(G2H8(1),RedSet_4(1),mass4set(:,1),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),8)
  call HG1shiftOLR(G1H8(2),32,8)
  call Hotf_4pt_reduction(G2H8(2),RedSet_4(2),mass4set(:,1),  & 
G1H8(6),G1H8(7),G1H8(8),G1H8(9),G1H8(10),8)
  call HG1shiftOLR(G1H8(7),32,8)
  call Hotf_4pt_reduction(G2H8(3),RedSet_4(3),mass4set(:,1),  & 
G1H8(11),G1H8(12),G1H8(13),G1H8(14),G1H8(15),8)
  call HG1shiftOLR(G1H8(12),16,8)
  call Hotf_4pt_reduction(G2H8(4),RedSet_4(4),mass4set(:,1),  & 
G1H8(16),G1H8(17),G1H8(18),G1H8(19),G1H8(20),8)
  call HG1shiftOLR(G1H8(17),16,8)
  call Hloop_AQ_V(ntryL,G2H16(1),wf8(:,6),G2H2(1),m3h8x2(:,1),heltab2x16(:,:,1))
  call Hloop_QA_V(ntryL,G2H16(2),ex6(:),G2H8(1),m3h2x8(:,1),heltab2x16(:,:,2))
  call Hloop_QA_V(ntryL,G2H16(3),wf8(:,2),G2H2(2),m3h8x2(:,2),heltab2x16(:,:,3))
  call Hloop_AQ_V(ntryL,G2H16(4),ex5(:),G2H8(2),m3h2x8(:,2),heltab2x16(:,:,4))
  call Hloop_AQ_V(ntryL,G2H16(5),wf8(:,8),G2H2(3),m3h8x2(:,3),heltab2x16(:,:,5))
  call Hloop_QA_V(ntryL,G2H16(6),ex6(:),G2H8(3),m3h2x8(:,3),heltab2x16(:,:,6))
  call Hloop_QA_V(ntryL,G2H16(7),wf8(:,4),G2H2(4),m3h8x2(:,4),heltab2x16(:,:,7))
  call Hloop_AQ_V(ntryL,G2H16(8),ex5(:),G2H8(4),m3h2x8(:,4),heltab2x16(:,:,8))
  call Hloop_QA_V(ntryL,G2H4(7),ex6(:),G2H2(5),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_AQ_V(ntryL,G2H4(8),ex5(:),G2H2(6),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QZ_A(ntryL,G1H8(1),wf4(:,4),G1H2(1),ngZd,m3h4x2(:,1),heltab2x8(:,:,1))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(7),n2h2(1))
call HGT_raise_alpha_OLR(G1H8(2),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(2),ex6(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,2))
  call Hloop_QZ_A(ntryL,G1H8(4),wf4(:,4),G1H2(1),ngZd,m3h4x2(:,2),heltab2x8(:,:,3))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(8),n2h2(2))
  call Hloop_QZ_A(ntryL,G1H8(5),wf4(:,4),G1H2(1),ngZd,m3h4x2(:,3),heltab2x8(:,:,4))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(9),n2h2(3))
  call Hloop_QZ_A(ntryL,G1H8(6),wf4(:,5),G1H2(1),ngZd,m3h4x2(:,4),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(10),n2h2(4))
call HGT_raise_alpha_OLR(G1H8(7),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(7),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(7),ex6(:),G1H4(2),m3h2x4(:,2),heltab2x8(:,:,6))
  call Hloop_QZ_A(ntryL,G1H8(9),wf4(:,5),G1H2(1),ngZd,m3h4x2(:,5),heltab2x8(:,:,7))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(11),n2h2(5))
  call Hloop_QZ_A(ntryL,G1H8(10),wf4(:,5),G1H2(1),ngZd,m3h4x2(:,6),heltab2x8(:,:,8))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(12),n2h2(6))
  call Hloop_AZ_Q(ntryL,G1H8(11),wf4(:,4),G1H2(1),ngZd,m3h4x2(:,7),heltab2x8(:,:,9))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(13),n2h2(7))
call HGT_raise_alpha_OLR(G1H8(12),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(12),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(12),ex5(:),G1H4(3),m3h2x4(:,3),heltab2x8(:,:,10))
  call Hloop_AZ_Q(ntryL,G1H8(14),wf4(:,4),G1H2(1),ngZd,m3h4x2(:,8),heltab2x8(:,:,11))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(14),n2h2(8))
  call Hloop_AZ_Q(ntryL,G1H8(15),wf4(:,4),G1H2(1),ngZd,m3h4x2(:,9),heltab2x8(:,:,12))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(15),n2h2(9))
  call Hloop_AZ_Q(ntryL,G1H8(16),wf4(:,5),G1H2(1),ngZd,m3h4x2(:,10),heltab2x8(:,:,13))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(16),n2h2(10))
call HGT_raise_alpha_OLR(G1H8(17),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(17),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(17),ex5(:),G1H4(4),m3h2x4(:,4),heltab2x8(:,:,14))
  call Hloop_AZ_Q(ntryL,G1H8(19),wf4(:,5),G1H2(1),ngZd,m3h4x2(:,11),heltab2x8(:,:,15))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(17),n2h2(11))
  call Hloop_AZ_Q(ntryL,G1H8(20),wf4(:,5),G1H2(1),ngZd,m3h4x2(:,12),heltab2x8(:,:,16))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(18),n2h2(12))
  call Hotf_4pt_reduction(G2H2(1),RedSet_4(5),mass4set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),2)
  call HG1shiftOLR(G1H2(2),32,2)
  call Hotf_4pt_reduction(G2H8(1),RedSet_4(6),mass4set(:,1),  & 
G1H8(1),G1H8(2),G1H8(4),G1H8(5),G1H8(6),8)
  call HG1shiftOLR(G1H8(2),19,8)
  call Hotf_4pt_reduction(G2H2(2),RedSet_4(7),mass4set(:,1),  & 
G1H2(6),G1H2(7),G1H2(8),G1H2(9),G1H2(10),2)
  call HG1shiftOLR(G1H2(7),16,2)
  call Hotf_4pt_reduction(G2H8(2),RedSet_4(8),mass4set(:,1),  & 
G1H8(7),G1H8(9),G1H8(10),G1H8(11),G1H8(12),8)
  call HG1shiftOLR(G1H8(9),35,8)
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(9),mass4set(:,1),  & 
G1H2(11),G1H2(12),G1H2(13),G1H2(14),G1H2(15),2)
  call HG1shiftOLR(G1H2(12),32,2)
  call Hotf_4pt_reduction(G2H8(3),RedSet_4(10),mass4set(:,1),  & 
G1H8(14),G1H8(15),G1H8(16),G1H8(17),G1H8(19),8)
  call HG1shiftOLR(G1H8(15),28,8)
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(11),mass4set(:,1),  & 
G1H2(16),G1H2(17),G1H2(18),G1H2(19),G1H2(20),2)
  call HG1shiftOLR(G1H2(17),16,2)
  call Hotf_4pt_reduction(G2H8(4),RedSet_4(12),mass4set(:,1),  & 
G1H8(20),G1H8(21),G1H8(22),G1H8(23),G1H8(24),8)
  call HG1shiftOLR(G1H8(21),44,8)
  call Hotf_4pt_reduction(G2H2(5),RedSet_4(13),mass4set(:,1),  & 
G1H2(21),G1H2(22),G1H2(23),G1H2(24),G1H2(25),2)
  call HG1shiftOLR(G1H2(22),16,2)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(14),mass4set(:,1),  & 
G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(27),32,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(7),ex6(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(9),ex6(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(10),ex6(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(12),ex6(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(13),ex5(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(15),ex5(:),G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(16),ex5(:),G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(18),ex5(:),G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hloop_VA_Q(ntryL,G1H2(1),ex6(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(9),n2h1(1))
  call Hloop_VA_Q(ntryL,G1H2(2),ex6(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(10),n2h1(2))
  call Hloop_VA_Q(ntryL,G1H2(5),ex6(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(11),n2h1(3))
  call Hloop_VQ_A(ntryL,G1H8(1),wf8(:,6),G1H1(1),m3h8x1(:,1),heltab2x8(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(12),n2h1(4))
  call Hloop_VQ_A(ntryL,G1H8(2),wf8(:,6),G1H1(1),m3h8x1(:,2),heltab2x8(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),19,0,G2tensor(13),n2h1(5))
  call Hloop_VQ_A(ntryL,G1H8(6),wf8(:,6),G1H1(1),m3h8x1(:,3),heltab2x8(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(14),n2h1(6))
  call Hloop_VQ_A(ntryL,G1H2(6),ex5(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(15),n2h1(7))
  call Hloop_VQ_A(ntryL,G1H2(7),ex5(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(16),n2h1(8))
  call Hloop_VQ_A(ntryL,G1H2(10),ex5(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(17),n2h1(9))
  call Hloop_VA_Q(ntryL,G1H8(7),wf8(:,2),G1H1(1),m3h8x1(:,4),heltab2x8(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(18),n2h1(10))
  call Hloop_VA_Q(ntryL,G1H8(9),wf8(:,2),G1H1(1),m3h8x1(:,5),heltab2x8(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),35,0,G2tensor(19),n2h1(11))
  call Hloop_VA_Q(ntryL,G1H8(12),wf8(:,2),G1H1(1),m3h8x1(:,6),heltab2x8(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(20),n2h1(12))
  call Hloop_VA_Q(ntryL,G1H2(11),ex6(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(21),n2h1(13))
  call Hloop_VA_Q(ntryL,G1H2(12),ex6(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(22),n2h1(14))
  call Hloop_VA_Q(ntryL,G1H2(15),ex6(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(23),n2h1(15))
  call Hloop_VQ_A(ntryL,G1H8(14),wf8(:,8),G1H1(1),m3h8x1(:,7),heltab2x8(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(24),n2h1(16))
  call Hloop_VQ_A(ntryL,G1H8(15),wf8(:,8),G1H1(1),m3h8x1(:,8),heltab2x8(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),28,0,G2tensor(25),n2h1(17))
  call Hloop_VQ_A(ntryL,G1H8(19),wf8(:,8),G1H1(1),m3h8x1(:,9),heltab2x8(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(26),n2h1(18))
  call Hloop_VQ_A(ntryL,G1H2(16),ex5(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(27),n2h1(19))
  call Hloop_VQ_A(ntryL,G1H2(17),ex5(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(28),n2h1(20))
  call Hloop_VQ_A(ntryL,G1H2(20),ex5(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(29),n2h1(21))
  call Hloop_VA_Q(ntryL,G1H8(20),wf8(:,4),G1H1(1),m3h8x1(:,10),heltab2x8(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(30),n2h1(22))
  call Hloop_VA_Q(ntryL,G1H8(21),wf8(:,4),G1H1(1),m3h8x1(:,11),heltab2x8(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),44,0,G2tensor(31),n2h1(23))
  call Hloop_VA_Q(ntryL,G1H8(24),wf8(:,4),G1H1(1),m3h8x1(:,12),heltab2x8(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(32),n2h1(24))
  call Hloop_VQ_A(ntryL,G1H2(21),ex5(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(33),n2h1(25))
  call Hloop_VQ_A(ntryL,G1H2(22),ex5(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(34),n2h1(26))
  call Hloop_VQ_A(ntryL,G1H2(25),ex5(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(35),n2h1(27))
  call Hloop_VA_Q(ntryL,G1H2(26),ex6(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(36),n2h1(28))
  call Hloop_VA_Q(ntryL,G1H2(27),ex6(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(37),n2h1(29))
  call Hloop_VA_Q(ntryL,G1H2(30),ex6(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(38),n2h1(30))
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5))
  call G_TensorShift(G1tensor(2),32)
  call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(2),mass4set(:,1),  & 
G1tensor(6),G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10))
  call G_TensorShift(G1tensor(7),32)
  call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(3),mass4set(:,1),  & 
G1tensor(11),G1tensor(12),G1tensor(13),G1tensor(14),G1tensor(15))
  call G_TensorShift(G1tensor(12),16)
  call Hotf_4pt_reduction_last(G2tensor(7),RedSet_4(4),mass4set(:,1),  & 
G1tensor(16),G1tensor(17),G1tensor(18),G1tensor(19),G1tensor(20))
  call G_TensorShift(G1tensor(17),16)
  call Hotf_4pt_reduction_last(G2tensor(9),RedSet_4(5),mass4set(:,1),  & 
G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24),G1tensor(25))
  call G_TensorShift(G1tensor(22),32)
  call Hotf_4pt_reduction_last(G2tensor(12),RedSet_4(6),mass4set(:,1),  & 
G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(27),19)
  call Hotf_4pt_reduction_last(G2tensor(15),RedSet_4(7),mass4set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35))
  call G_TensorShift(G1tensor(32),16)
  call Hotf_4pt_reduction_last(G2tensor(18),RedSet_4(8),mass4set(:,1),  & 
G1tensor(36),G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40))
  call G_TensorShift(G1tensor(37),35)
  call Hotf_4pt_reduction_last(G2tensor(21),RedSet_4(9),mass4set(:,1),  & 
G1tensor(41),G1tensor(42),G1tensor(43),G1tensor(44),G1tensor(45))
  call G_TensorShift(G1tensor(42),32)
  call Hotf_4pt_reduction_last(G2tensor(24),RedSet_4(10),mass4set(:,1),  & 
G1tensor(46),G1tensor(47),G1tensor(48),G1tensor(49),G1tensor(50))
  call G_TensorShift(G1tensor(47),28)
  call Hotf_4pt_reduction_last(G2tensor(27),RedSet_4(11),mass4set(:,1),  & 
G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54),G1tensor(55))
  call G_TensorShift(G1tensor(52),16)
  call Hotf_4pt_reduction_last(G2tensor(30),RedSet_4(12),mass4set(:,1),  & 
G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(57),44)
  call Hotf_4pt_reduction_last(G2tensor(33),RedSet_4(13),mass4set(:,1),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65))
  call G_TensorShift(G1tensor(62),16)
  call Hotf_4pt_reduction_last(G2tensor(36),RedSet_4(14),mass4set(:,1),  & 
G1tensor(66),G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70))
  call G_TensorShift(G1tensor(67),32)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(1),mass4set(:,1),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(6),RedSet_4(2),mass4set(:,1),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(3),mass4set(:,1),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(16),RedSet_4(4),mass4set(:,1),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(21),RedSet_4(5),mass4set(:,1),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(6),mass4set(:,1),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(7),mass4set(:,1),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(36),RedSet_4(8),mass4set(:,1),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(9),mass4set(:,1),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(46),RedSet_4(10),mass4set(:,1),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(11),mass4set(:,1),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(56),RedSet_4(12),mass4set(:,1),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(13),mass4set(:,1),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(14),mass4set(:,1),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  call ol_merge_tensors(T0sum(12),[G0tensor(56)])
  call ol_merge_tensors(T0sum(13),[G0tensor(61)])
  call ol_merge_tensors(T0sum(14),[G0tensor(66)])
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(21),h0tab(:,21),[80,12,35],[0,0,0],3,3,wf4(:,6),wf4(:,5),wf8(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,6),G0H32(1),m3h4x32(:,5),heltab2x128(:,:,21))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(1),n2h32(5))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(108)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(22),h0tab(:,22),[80,3,44],[0,0,0],3,3,wf4(:,6),wf4(:,4),wf8(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,6),G0H32(1),m3h4x32(:,6),heltab2x128(:,:,22))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(2),n2h32(6))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(23),h0tab(:,23),[83,12,32],[0,0,0],3,2,wf16(:,17),wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,17),G0H8(1),m3h16x8(:,1),heltab2x128(:,:,23))
  call Hloop_Q_A(ntryL,G0H8(1),83,0,G1H8(1),n2h8(9))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(24),h0tab(:,24),[92,3,32],[0,0,0],3,2,wf16(:,18),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,18),G0H8(1),m3h16x8(:,2),heltab2x128(:,:,24))
  call Hloop_Q_A(ntryL,G0H8(1),92,0,G1H8(2),n2h8(10))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(25),h0tab(:,25),[96,12,19],[0,0,0],3,3,wf4(:,8),wf4(:,5),wf8(:,6))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(1),m3h4x32(:,7),heltab2x128(:,:,25))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(3),n2h32(7))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(26),h0tab(:,26),[96,3,28],[0,0,0],3,3,wf4(:,8),wf4(:,4),wf8(:,8))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(1),m3h4x32(:,8),heltab2x128(:,:,26))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(4),n2h32(8))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(27),h0tab(:,27),[99,12,16],[0,0,0],3,2,wf16(:,21),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,21),G0H8(1),m3h16x8(:,3),heltab2x128(:,:,27))
  call Hloop_A_Q(ntryL,G0H8(1),99,0,G1H8(6),n2h8(11))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(28),h0tab(:,28),[108,3,16],[0,0,0],3,2,wf16(:,22),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,22),G0H8(1),m3h16x8(:,4),heltab2x128(:,:,28))
  call Hloop_A_Q(ntryL,G0H8(1),108,0,G1H8(7),n2h8(12))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(29),h0tab(:,29),[64,19,44],[0,0,0],3,2,wf8(:,6),wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,17),heltab2x128(:,:,29))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(1),n2h64(17))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(30),h0tab(:,30),[83,12,32],[0,0,0],3,2,wf16(:,35),wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,35),G0H8(1),m3h16x8(:,5),heltab2x128(:,:,30))
  call Hloop_Q_A(ntryL,G0H8(1),83,0,G1H8(9),n2h8(13))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(91)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(31),h0tab(:,31),[64,31,32],[0,0,0],3,1,wf32(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,18),heltab2x128(:,:,31))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(2),n2h64(18))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(32),h0tab(:,32),[64,28,35],[0,0,0],3,2,wf8(:,8),wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,19),heltab2x128(:,:,32))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(3),n2h64(19))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(33),h0tab(:,33),[99,12,16],[0,0,0],3,2,wf16(:,34),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,34),G0H8(1),m3h16x8(:,6),heltab2x128(:,:,33))
  call Hloop_A_Q(ntryL,G0H8(1),99,0,G1H8(12),n2h8(14))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(34),h0tab(:,34),[64,16,47],[0,0,0],3,1,wf32(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,20),heltab2x128(:,:,34))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(4),n2h64(20))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(115)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(35),h0tab(:,35),[92,3,32],[0,0,0],3,2,wf16(:,36),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,36),G0H8(1),m3h16x8(:,7),heltab2x128(:,:,35))
  call Hloop_Q_A(ntryL,G0H8(1),92,0,G1H8(14),n2h8(15))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(36),h0tab(:,36),[64,31,32],[0,0,0],3,1,wf32(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,21),heltab2x128(:,:,36))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(5),n2h64(21))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(37),h0tab(:,37),[108,3,16],[0,0,0],3,2,wf16(:,32),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,32),G0H8(1),m3h16x8(:,8),heltab2x128(:,:,37))
  call Hloop_A_Q(ntryL,G0H8(1),108,0,G1H8(15),n2h8(16))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(38),h0tab(:,38),[64,16,47],[0,0,0],3,1,wf32(:,8))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,22),heltab2x128(:,:,38))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(6),n2h64(22))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(39),h0tab(:,39),[80,15,32],[0,0,0],3,2,wf4(:,6),wf16(:,37))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,6),G0H32(1),m3h4x32(:,9),heltab2x128(:,:,39))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(5),n2h32(9))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(40),h0tab(:,40),[80,15,32],[0,0,0],3,2,wf4(:,6),wf16(:,38))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,6),G0H32(1),m3h4x32(:,10),heltab2x128(:,:,40))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(6),n2h32(10))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(41),h0tab(:,41),[96,15,16],[0,0,0],3,2,wf4(:,8),wf16(:,37))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(1),m3h4x32(:,11),heltab2x128(:,:,41))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(7),n2h32(11))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(120)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(42),h0tab(:,42),[96,15,16],[0,0,0],3,2,wf4(:,8),wf16(:,38))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(1),m3h4x32(:,12),heltab2x128(:,:,42))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(8),n2h32(12))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(43),h0tab(:,43),[64,31,32],[0,0,0],3,1,wf32(:,10))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,23),heltab2x128(:,:,43))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(7),n2h64(23))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(44),h0tab(:,44),[64,16,47],[0,0,0],3,1,wf32(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,24),heltab2x128(:,:,44))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(8),n2h64(24))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(101)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(45),h0tab(:,45),[64,31,32],[0,0,0],3,1,wf32(:,14))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,25),heltab2x128(:,:,45))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(9),n2h64(25))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(46),h0tab(:,46),[64,16,47],[0,0,0],3,1,wf32(:,16))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,26),heltab2x128(:,:,46))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(10),n2h64(26))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(121)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(47),h0tab(:,47),[80,15,32],[0,0,0],3,2,wf4(:,6),wf16(:,39))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,6),G0H32(1),m3h4x32(:,13),heltab2x128(:,:,47))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(9),n2h32(13))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(48),h0tab(:,48),[80,15,32],[0,0,0],3,2,wf4(:,6),wf16(:,40))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,6),G0H32(1),m3h4x32(:,14),heltab2x128(:,:,48))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(10),n2h32(14))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(49),h0tab(:,49),[96,15,16],[0,0,0],3,2,wf4(:,8),wf16(:,39))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(1),m3h4x32(:,15),heltab2x128(:,:,49))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(11),n2h32(15))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(50),h0tab(:,50),[96,15,16],[0,0,0],3,2,wf4(:,8),wf16(:,40))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(1),m3h4x32(:,16),heltab2x128(:,:,50))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(12),n2h32(16))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(51),h0tab(:,51),[64,31,32],[0,0,0],3,1,wf32(:,18))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,27),heltab2x128(:,:,51))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(11),n2h64(27))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(52),h0tab(:,52),[64,16,47],[0,0,0],3,1,wf32(:,20))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,28),heltab2x128(:,:,52))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(12),n2h64(28))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(53),h0tab(:,53),[64,31,32],[0,0,0],3,1,wf32(:,22))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,29),heltab2x128(:,:,53))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(13),n2h64(29))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(54),h0tab(:,54),[64,16,47],[0,0,0],3,1,wf32(:,24))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,30),heltab2x128(:,:,54))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(14),n2h64(30))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(14),[G1H8(2),G1H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(9),[G1H8(1),G1H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(15),[G1H8(7),G1H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(12),[G1H8(6),G1H8(18)])
  call Hloop_QZ_A(ntryL,G1H8(14),wf4(:,4),G1H2(1),ngZd,m3h4x2(:,13),heltab2x8(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(1),n2h2(13))
  call Hloop_QZ_A(ntryL,G1H8(9),wf4(:,5),G1H2(2),ngZd,m3h4x2(:,14),heltab2x8(:,:,30))
  call Hloop_Q_A(ntryL,G1H2(2),95,0,G2H2(2),n2h2(14))
  call Hloop_AZ_Q(ntryL,G1H8(15),wf4(:,4),G1H2(5),ngZd,m3h4x2(:,15),heltab2x8(:,:,31))
  call Hloop_A_Q(ntryL,G1H2(5),111,0,G2H2(3),n2h2(15))
  call Hloop_AZ_Q(ntryL,G1H8(12),wf4(:,5),G1H2(6),ngZd,m3h4x2(:,16),heltab2x8(:,:,32))
  call Hloop_A_Q(ntryL,G1H2(6),111,0,G2H2(4),n2h2(16))
  call Hloop_QZ_A(ntryL,G1H32(1),wf4(:,5),G1H8(19),ngZd,m3h4x8(:,5),heltab2x32(:,:,5))
  call Hloop_Q_A(ntryL,G1H8(19),92,0,G2H8(1),n2h8(17))
  call Hloop_QZ_A(ntryL,G1H32(2),wf4(:,4),G1H8(20),ngZd,m3h4x8(:,6),heltab2x32(:,:,6))
  call Hloop_Q_A(ntryL,G1H8(20),83,0,G2H8(2),n2h8(18))
  call Hloop_AZ_Q(ntryL,G1H32(3),wf4(:,5),G1H8(21),ngZd,m3h4x8(:,7),heltab2x32(:,:,7))
  call Hloop_A_Q(ntryL,G1H8(21),108,0,G2H8(3),n2h8(19))
  call Hloop_AZ_Q(ntryL,G1H32(4),wf4(:,4),G1H8(24),ngZd,m3h4x8(:,8),heltab2x32(:,:,8))
  call Hloop_A_Q(ntryL,G1H8(24),99,0,G2H8(4),n2h8(20))
  call Hloop_AQ_V(ntryL,G1H64(1),wf8(:,6),G1H8(2),m3h8x8(:,1),heltab2x64(:,:,17))
  call Hloop_AQ_V(ntryL,G1H64(2),wf32(:,2),G1H2(7),m3h32x2(:,1),heltab2x64(:,:,18))
  call Hloop_AQ_V(ntryL,G1H64(3),wf8(:,8),G1H8(3),m3h8x8(:,2),heltab2x64(:,:,19))
  call Hloop_AQ_V(ntryL,G1H64(4),ex5(:),G1H32(1),m3h2x32(:,1),heltab2x64(:,:,20))
  call Hloop_AQ_V(ntryL,G1H64(5),wf32(:,6),G1H2(10),m3h32x2(:,2),heltab2x64(:,:,21))
  call Hloop_AQ_V(ntryL,G1H64(6),ex5(:),G1H32(2),m3h2x32(:,2),heltab2x64(:,:,22))
  call Hloop_QZ_A(ntryL,G1H32(5),wf16(:,37),G1H2(11),ngZd,m3h16x2(:,1),heltab2x32(:,:,9))
  call Hloop_Q_A(ntryL,G1H2(11),95,0,G2H2(5),n2h2(17))
  call Hloop_QZ_A(ntryL,G1H32(6),wf16(:,38),G1H2(12),ngZd,m3h16x2(:,2),heltab2x32(:,:,10))
  call Hloop_Q_A(ntryL,G1H2(12),95,0,G2H2(6),n2h2(18))
  call Hloop_AZ_Q(ntryL,G1H32(7),wf16(:,37),G1H2(15),ngZd,m3h16x2(:,3),heltab2x32(:,:,11))
  call Hloop_A_Q(ntryL,G1H2(15),111,0,G2H2(7),n2h2(19))
  call Hloop_AZ_Q(ntryL,G1H32(8),wf16(:,38),G1H2(16),ngZd,m3h16x2(:,4),heltab2x32(:,:,12))
  call Hloop_A_Q(ntryL,G1H2(16),111,0,G2H2(9),n2h2(20))
  call Hloop_AQ_V(ntryL,G1H64(7),wf32(:,10),G1H2(17),m3h32x2(:,3),heltab2x64(:,:,23))
  call Hloop_AQ_V(ntryL,G1H64(8),ex5(:),G1H32(3),m3h2x32(:,3),heltab2x64(:,:,24))
  call Hloop_AQ_V(ntryL,G1H64(9),wf32(:,14),G1H2(20),m3h32x2(:,4),heltab2x64(:,:,25))
  call Hloop_AQ_V(ntryL,G1H64(10),ex5(:),G1H32(4),m3h2x32(:,4),heltab2x64(:,:,26))
  call Hloop_QZ_A(ntryL,G1H32(9),wf16(:,39),G1H2(21),ngZd,m3h16x2(:,5),heltab2x32(:,:,13))
  call Hloop_Q_A(ntryL,G1H2(21),95,0,G2H2(10),n2h2(21))
  call Hloop_QZ_A(ntryL,G1H32(10),wf16(:,40),G1H2(22),ngZd,m3h16x2(:,6),heltab2x32(:,:,14))
  call Hloop_Q_A(ntryL,G1H2(22),95,0,G2H2(12),n2h2(22))
  call Hloop_AZ_Q(ntryL,G1H32(11),wf16(:,39),G1H2(25),ngZd,m3h16x2(:,7),heltab2x32(:,:,15))
  call Hloop_A_Q(ntryL,G1H2(25),111,0,G2H2(13),n2h2(23))
  call Hloop_AZ_Q(ntryL,G1H32(12),wf16(:,40),G1H2(26),ngZd,m3h16x2(:,8),heltab2x32(:,:,16))
  call Hloop_A_Q(ntryL,G1H2(26),111,0,G2H2(15),n2h2(24))
  call Hloop_AQ_V(ntryL,G1H64(11),wf32(:,18),G1H2(27),m3h32x2(:,5),heltab2x64(:,:,27))
  call Hloop_AQ_V(ntryL,G1H64(12),ex5(:),G1H32(5),m3h2x32(:,5),heltab2x64(:,:,28))
  call Hloop_AQ_V(ntryL,G1H64(13),wf32(:,22),G1H2(30),m3h32x2(:,6),heltab2x64(:,:,29))
  call Hloop_AQ_V(ntryL,G1H64(14),ex5(:),G1H32(6),m3h2x32(:,6),heltab2x64(:,:,30))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G2H2(10),G2H2(6),G2H2(5),G2H2(11),G2H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(15),[G2H2(13),G2H2(9),G2H2(7),G2H2(17),G2H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(30),[G1H2(27),G1H2(20),G1H2(17),G1H2(10),G1H2(7),G1H2(29) &
    ,G1H2(14),G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(24),[G1H2(19),G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(3),[G1H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(2),[G1H8(23)])
call HGT_w2_OLR(G1H4(1),1,1,4)
call HGT_w2_invQ_OLR(G1H4(1),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(1),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,1),heltab2x4(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(1),n2h1(31))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(12),ex6(:),G2tensor(3),m3h2x1(:,27),heltab2x2(:,:,27))
call HGT_w2_OLR(G1H4(2),1,1,4)
call HGT_w2_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(2),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,2),heltab2x4(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(5),n2h1(32))
call HGT_w2_OLR(G1H4(3),1,1,4)
call HGT_w2_invQ_OLR(G1H4(3),2,5,4)
  call Hloop_AZ_Q(ntryL,G1H4(3),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,3),heltab2x4(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(7),n2h1(33))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(15),ex5(:),G2tensor(9),m3h2x1(:,28),heltab2x2(:,:,28))
call HGT_w2_OLR(G1H4(4),1,1,4)
call HGT_w2_invQ_OLR(G1H4(4),2,5,4)
  call Hloop_AZ_Q(ntryL,G1H4(4),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,4),heltab2x4(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(12),n2h1(34))
  call Hloop_VA_Q(ntryL,G1H2(3),ex6(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(15),n2h1(35))
  call Hloop_VA_Q(ntryL,G1H2(30),ex6(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(18),n2h1(36))
  call Hloop_VQ_A(ntryL,G1H8(4),wf8(:,6),G1H1(1),m3h8x1(:,13),heltab2x8(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(21),n2h1(37))
  call Hloop_VQ_A(ntryL,G1H8(5),wf8(:,6),G1H1(1),m3h8x1(:,14),heltab2x8(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(24),n2h1(38))
  call Hloop_VQ_A(ntryL,G1H2(8),ex5(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(27),n2h1(39))
  call Hloop_VQ_A(ntryL,G1H2(24),ex5(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(30),n2h1(40))
  call Hloop_VA_Q(ntryL,G1H8(10),wf8(:,2),G1H1(1),m3h8x1(:,15),heltab2x8(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(33),n2h1(41))
  call Hloop_VA_Q(ntryL,G1H8(3),wf8(:,2),G1H1(1),m3h8x1(:,16),heltab2x8(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(36),n2h1(42))
  call Hloop_VA_Q(ntryL,G1H2(13),ex6(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(39),n2h1(43))
  call Hloop_VQ_A(ntryL,G1H8(16),wf8(:,8),G1H1(1),m3h8x1(:,17),heltab2x8(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(40),n2h1(44))
  call Hloop_VQ_A(ntryL,G1H8(17),wf8(:,8),G1H1(1),m3h8x1(:,18),heltab2x8(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(41),n2h1(45))
  call Hloop_VQ_A(ntryL,G1H2(18),ex5(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(42),n2h1(46))
  call Hloop_VA_Q(ntryL,G1H8(22),wf8(:,4),G1H1(1),m3h8x1(:,19),heltab2x8(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(43),n2h1(47))
  call Hloop_VA_Q(ntryL,G1H8(2),wf8(:,4),G1H1(1),m3h8x1(:,20),heltab2x8(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(44),n2h1(48))
  call Hloop_VQ_A(ntryL,G1H2(23),ex5(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(45),n2h1(49))
  call Hloop_VA_Q(ntryL,G1H2(28),ex6(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(46),n2h1(50))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(1),ex6(:),G2tensor(47),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(2),ex6(:),G2tensor(48),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(3),ex5(:),G2tensor(49),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(4),ex5(:),G2tensor(50),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(1),wf8(:,2),G2tensor(51),m3h8x1(:,21),heltab2x8(:,:,41))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(2),wf8(:,4),G2tensor(52),m3h8x1(:,22),heltab2x8(:,:,42))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(3),wf8(:,6),G2tensor(53),m3h8x1(:,23),heltab2x8(:,:,43))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(4),wf8(:,8),G2tensor(54),m3h8x1(:,24),heltab2x8(:,:,44))
  call Hloop_VA_Q(ntryL,G1H32(1),wf32(:,4),G1H1(1),m3h32x1(:,1),heltab2x32(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(55),n2h1(51))
  call Hloop_VA_Q(ntryL,G1H32(2),wf32(:,8),G1H1(1),m3h32x1(:,2),heltab2x32(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(56),n2h1(52))
  call Hloop_VA_Q(ntryL,G1H32(3),wf32(:,12),G1H1(1),m3h32x1(:,3),heltab2x32(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(57),n2h1(53))
  call Hloop_VA_Q(ntryL,G1H32(4),wf32(:,16),G1H1(1),m3h32x1(:,4),heltab2x32(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(58),n2h1(54))
  call Hloop_VA_Q(ntryL,G1H32(5),wf32(:,20),G1H1(1),m3h32x1(:,5),heltab2x32(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(59),n2h1(55))
  call Hloop_VA_Q(ntryL,G1H32(6),wf32(:,24),G1H1(1),m3h32x1(:,6),heltab2x32(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(60),n2h1(56))
  call ol_merge_tensors(G2tensor(51),[G2tensor(16),G2tensor(2),G1tensor(32),G1tensor(5),G0tensor(32),G0tensor(5)])
  call ol_merge_tensors(G2tensor(52),[G2tensor(28),G2tensor(4),G1tensor(52),G1tensor(10),G0tensor(52),G0tensor(10)])
  call ol_merge_tensors(G2tensor(53),[G2tensor(10),G2tensor(6),G1tensor(22),G1tensor(15),G0tensor(22),G0tensor(15)])
  call ol_merge_tensors(G2tensor(54),[G2tensor(22),G2tensor(8),G1tensor(42),G1tensor(20),G0tensor(42),G0tensor(20)])
  call ol_merge_tensors(G2tensor(20),[G2tensor(17),G2tensor(14),G2tensor(11),G1tensor(40),G1tensor(35),G1tensor(30),G1tensor(25) &
    ,G0tensor(40),G0tensor(35),G0tensor(30),G0tensor(25)])
  call ol_merge_tensors(G2tensor(48),[G2tensor(13),G1tensor(27),G1tensor(8),G0tensor(27),G0tensor(8)])
  call ol_merge_tensors(G2tensor(50),[G2tensor(19),G1tensor(37),G1tensor(18),G0tensor(37),G0tensor(18)])
  call ol_merge_tensors(G2tensor(32),[G2tensor(29),G2tensor(26),G2tensor(23),G1tensor(60),G1tensor(55),G1tensor(50),G1tensor(45) &
    ,G0tensor(60),G0tensor(55),G0tensor(50),G0tensor(45)])
  call ol_merge_tensors(G2tensor(47),[G2tensor(25),G1tensor(47),G1tensor(3),G0tensor(47),G0tensor(3)])
  call ol_merge_tensors(G2tensor(49),[G2tensor(31),G1tensor(57),G1tensor(13),G0tensor(57),G0tensor(13)])
  call ol_merge_tensors(G2tensor(3),[G2tensor(34),G1tensor(62),G1tensor(9),G1tensor(4),G0tensor(62),G0tensor(9),G0tensor(4)])
  call ol_merge_tensors(G2tensor(38),[G2tensor(35),G1tensor(70),G1tensor(65),G0tensor(70),G0tensor(65)])
  call ol_merge_tensors(G2tensor(9),[G2tensor(37),G1tensor(67),G1tensor(19),G1tensor(14),G0tensor(67),G0tensor(19),G0tensor(14)])
  call ol_merge_tensors(G2tensor(7),[G2tensor(1),G1tensor(12),G1tensor(2),G0tensor(12),G0tensor(2)])
  call ol_merge_tensors(G2tensor(12),[G2tensor(5),G1tensor(17),G1tensor(7),G0tensor(17),G0tensor(7)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(23),G0tensor(23)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(69),G1tensor(44),G1tensor(24),G0tensor(69),G0tensor(44),G0tensor(24)])
  call ol_merge_tensors(G2tensor(21),[G1tensor(28),G0tensor(28)])
  call ol_merge_tensors(G2tensor(24),[G1tensor(29),G0tensor(29)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(33),G0tensor(33)])
  call ol_merge_tensors(G2tensor(30),[G1tensor(64),G1tensor(54),G1tensor(34),G0tensor(64),G0tensor(54),G0tensor(34)])
  call ol_merge_tensors(G2tensor(33),[G1tensor(38),G0tensor(38)])
  call ol_merge_tensors(G2tensor(36),[G1tensor(39),G0tensor(39)])
  call ol_merge_tensors(G2tensor(39),[G1tensor(43),G0tensor(43)])
  call ol_merge_tensors(G2tensor(40),[G1tensor(48),G0tensor(48)])
  call ol_merge_tensors(G2tensor(41),[G1tensor(49),G0tensor(49)])
  call ol_merge_tensors(G2tensor(42),[G1tensor(53),G0tensor(53)])
  call ol_merge_tensors(G2tensor(43),[G1tensor(58),G0tensor(58)])
  call ol_merge_tensors(G2tensor(44),[G1tensor(59),G0tensor(59)])
  call ol_merge_tensors(G2tensor(45),[G1tensor(63),G0tensor(63)])
  call ol_merge_tensors(G2tensor(46),[G1tensor(68),G0tensor(68)])
  call ol_merge_tensors(G2tensor(60),[G2tensor(59),G2tensor(58),G2tensor(57),G2tensor(56),G2tensor(55)])
  call TI_triangle_red(G2tensor(51),RedBasis(1),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1)
  call TI_triangle_red(G2tensor(52),RedBasis(4),mass3set(:,1),G0tensor(21),G0tensor(26),G0tensor(31),G0tensor(36),M2L1R1)
  call TI_triangle_red(G2tensor(53),RedBasis(6),mass3set(:,1),G0tensor(41),G0tensor(46),G0tensor(51),G0tensor(56),M2L1R1)
  call TI_triangle_red(G2tensor(54),RedBasis(9),mass3set(:,1),G0tensor(61),G0tensor(66),G0tensor(32),G0tensor(5),M2L1R1)
  call TI_triangle_red(G2tensor(20),RedBasis(11),mass3set(:,1),G0tensor(52),G0tensor(10),G0tensor(22),G0tensor(15),M2L1R1)
  call TI_triangle_red(G2tensor(48),RedBasis(5),mass3set(:,1),G0tensor(42),G0tensor(20),G0tensor(40),G0tensor(35),M2L1R1)
  call TI_triangle_red(G2tensor(50),RedBasis(10),mass3set(:,1),G0tensor(30),G0tensor(25),G0tensor(27),G0tensor(8),M2L1R1)
  call TI_triangle_red(G2tensor(32),RedBasis(20),mass3set(:,1),G0tensor(37),G0tensor(18),G0tensor(60),G0tensor(55),M2L1R1)
  call TI_triangle_red(G2tensor(47),RedBasis(3),mass3set(:,1),G0tensor(50),G0tensor(45),G0tensor(47),G0tensor(3),M2L1R1)
  call TI_triangle_red(G2tensor(49),RedBasis(8),mass3set(:,1),G0tensor(57),G0tensor(13),G0tensor(62),G0tensor(9),M2L1R1)
  call TI_triangle_red(G2tensor(3),RedBasis(2),mass3set(:,1),G0tensor(4),G0tensor(70),G0tensor(65),G0tensor(67),M2L1R1)
  call TI_triangle_red(G2tensor(38),RedBasis(27),mass3set(:,1),G0tensor(19),G0tensor(14),G0tensor(12),G0tensor(2),M2L1R1)
  call TI_triangle_red(G2tensor(9),RedBasis(7),mass3set(:,1),G0tensor(17),G0tensor(7),G0tensor(23),G0tensor(69),M2L1R1)
  call TI_triangle_red(G2tensor(7),RedBasis(30),mass3set(:,1),G0tensor(44),G0tensor(24),G0tensor(28),G0tensor(29),M2L1R1)
  call TI_triangle_red(G2tensor(12),RedBasis(31),mass3set(:,1),G0tensor(33),G0tensor(64),G0tensor(54),G0tensor(34),M2L1R1)
  call TI_triangle_red(G2tensor(15),RedBasis(13),mass3set(:,1),G0tensor(38),G0tensor(39),G0tensor(43),G0tensor(48),M2L1R1)
  call TI_triangle_red(G2tensor(18),RedBasis(12),mass3set(:,1),G0tensor(49),G0tensor(53),G0tensor(58),G0tensor(59),M2L1R1)
  call TI_triangle_red(G2tensor(21),RedBasis(15),mass3set(:,1),G0tensor(63),G0tensor(68),G0tensor(71),G0tensor(72),M2L1R1)
  call TI_triangle_red(G2tensor(24),RedBasis(14),mass3set(:,1),G0tensor(73),G0tensor(74),G0tensor(75),G0tensor(76),M2L1R1)
  call TI_triangle_red(G2tensor(27),RedBasis(17),mass3set(:,1),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80),M2L1R1)
  call TI_triangle_red(G2tensor(30),RedBasis(16),mass3set(:,1),G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),M2L1R1)
  call TI_triangle_red(G2tensor(33),RedBasis(19),mass3set(:,1),G0tensor(85),G0tensor(86),G0tensor(87),G0tensor(88),M2L1R1)
  call TI_triangle_red(G2tensor(36),RedBasis(18),mass3set(:,1),G0tensor(89),G0tensor(90),G0tensor(91),G0tensor(92),M2L1R1)
  call TI_triangle_red(G2tensor(39),RedBasis(21),mass3set(:,1),G0tensor(93),G0tensor(94),G0tensor(95),G0tensor(96),M2L1R1)
  call TI_triangle_red(G2tensor(40),RedBasis(23),mass3set(:,1),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100),M2L1R1)
  call TI_triangle_red(G2tensor(41),RedBasis(22),mass3set(:,1),G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104),M2L1R1)
  call TI_triangle_red(G2tensor(42),RedBasis(24),mass3set(:,1),G0tensor(105),G0tensor(106),G0tensor(107),G0tensor(108),M2L1R1)
  call TI_triangle_red(G2tensor(43),RedBasis(26),mass3set(:,1),G0tensor(109),G0tensor(110),G0tensor(111),G0tensor(112),M2L1R1)
  call TI_triangle_red(G2tensor(44),RedBasis(25),mass3set(:,1),G0tensor(113),G0tensor(114),G0tensor(115),G0tensor(116),M2L1R1)
  call TI_triangle_red(G2tensor(45),RedBasis(28),mass3set(:,1),G0tensor(117),G0tensor(118),G0tensor(119),G0tensor(120),M2L1R1)
  call TI_triangle_red(G2tensor(46),RedBasis(29),mass3set(:,1),G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124),M2L1R1)
  call TI_triangle_red(G2tensor(60),RedBasis(32),mass3set(:,1),G0tensor(125),G0tensor(126),G0tensor(127),G0tensor(128),M2L1R1)
  call ol_merge_tensors(T0sum(15),[G0tensor(1)])
  call ol_merge_tensors(T0sum(16),[G0tensor(21)])
  call ol_merge_tensors(T0sum(17),[G0tensor(41)])
  call ol_merge_tensors(T0sum(18),[G0tensor(61)])
  call ol_merge_tensors(T0sum(19),[G0tensor(52)])
  call ol_merge_tensors(T0sum(20),[G0tensor(42)])
  call ol_merge_tensors(T0sum(21),[G0tensor(30)])
  call ol_merge_tensors(T0sum(22),[G0tensor(37)])
  call ol_merge_tensors(T0sum(23),[G0tensor(50)])
  call ol_merge_tensors(T0sum(24),[G0tensor(57)])
  call ol_merge_tensors(T0sum(25),[G0tensor(4)])
  call ol_merge_tensors(T0sum(26),[G0tensor(19)])
  call ol_merge_tensors(T0sum(27),[G0tensor(17)])
  call ol_merge_tensors(T0sum(28),[G0tensor(44)])
  call ol_merge_tensors(T0sum(29),[G0tensor(33)])
  call ol_merge_tensors(T0sum(30),[G0tensor(38)])
  call ol_merge_tensors(T0sum(31),[G0tensor(49)])
  call ol_merge_tensors(T0sum(32),[G0tensor(63)])
  call ol_merge_tensors(T0sum(33),[G0tensor(73)])
  call ol_merge_tensors(T0sum(34),[G0tensor(77)])
  call ol_merge_tensors(T0sum(35),[G0tensor(81)])
  call ol_merge_tensors(T0sum(36),[G0tensor(85)])
  call ol_merge_tensors(T0sum(37),[G0tensor(89)])
  call ol_merge_tensors(T0sum(38),[G0tensor(93)])
  call ol_merge_tensors(T0sum(39),[G0tensor(97)])
  call ol_merge_tensors(T0sum(40),[G0tensor(101)])
  call ol_merge_tensors(T0sum(41),[G0tensor(105)])
  call ol_merge_tensors(T0sum(42),[G0tensor(109)])
  call ol_merge_tensors(T0sum(43),[G0tensor(113)])
  call ol_merge_tensors(T0sum(44),[G0tensor(117)])
  call ol_merge_tensors(T0sum(45),[G0tensor(121)])
  call ol_merge_tensors(T0sum(46),[G0tensor(125)])
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(55),h0tab(:,55),[92,35],[0,0],2,2,wf16(:,18),wf8(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,18),G0H8(1),m3h16x8(:,9),heltab2x128(:,:,55))
  call Hloop_Q_A(ntryL,G0H8(1),92,0,G1H8(1),n2h8(21))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(56),h0tab(:,56),[80,47],[0,0],2,2,wf4(:,6),wf32(:,4))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,6),G0H32(1),m3h4x32(:,17),heltab2x128(:,:,56))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(57),h0tab(:,57),[83,44],[0,0],2,2,wf16(:,17),wf8(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,17),G0H8(1),m3h16x8(:,10),heltab2x128(:,:,57))
  call Hloop_Q_A(ntryL,G0H8(1),83,0,G1H8(8),n2h8(22))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(58),h0tab(:,58),[80,47],[0,0],2,2,wf4(:,6),wf32(:,8))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,6),G0H32(2),m3h4x32(:,18),heltab2x128(:,:,58))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(59),h0tab(:,59),[96,31],[0,0],2,2,wf4(:,8),wf32(:,2))
  call Hloop_QA_V(ntryL,G0H128(1),wf4(:,8),G0H32(3),m3h4x32(:,19),heltab2x128(:,:,59))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(60),h0tab(:,60),[108,19],[0,0],2,2,wf16(:,22),wf8(:,6))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,22),G0H8(1),m3h16x8(:,11),heltab2x128(:,:,60))
  call Hloop_A_Q(ntryL,G0H8(1),108,0,G1H8(7),n2h8(23))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(61),h0tab(:,61),[96,31],[0,0],2,2,wf4(:,8),wf32(:,6))
  call Hloop_QA_V(ntryL,G0H128(1),wf4(:,8),G0H32(4),m3h4x32(:,20),heltab2x128(:,:,61))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(62),h0tab(:,62),[99,28],[0,0],2,2,wf16(:,21),wf8(:,8))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,21),G0H8(1),m3h16x8(:,12),heltab2x128(:,:,62))
  call Hloop_A_Q(ntryL,G0H8(1),99,0,G1H8(13),n2h8(24))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(63),h0tab(:,63),[83,44],[0,0],2,2,wf16(:,35),wf8(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,35),G0H8(1),m3h16x8(:,13),heltab2x128(:,:,63))
  call Hloop_Q_A(ntryL,G0H8(1),83,0,G1H8(6),n2h8(25))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(64),h0tab(:,64),[108,19],[0,0],2,2,wf16(:,32),wf8(:,6))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,32),G0H8(1),m3h16x8(:,14),heltab2x128(:,:,64))
  call Hloop_A_Q(ntryL,G0H8(1),108,0,G1H8(18),n2h8(26))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(65),h0tab(:,65),[92,35],[0,0],2,2,wf16(:,36),wf8(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,36),G0H8(1),m3h16x8(:,15),heltab2x128(:,:,65))
  call Hloop_Q_A(ntryL,G0H8(1),92,0,G1H8(14),n2h8(27))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(66),h0tab(:,66),[99,28],[0,0],2,2,wf16(:,34),wf8(:,8))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,34),G0H8(1),m3h16x8(:,16),heltab2x128(:,:,66))
  call Hloop_A_Q(ntryL,G0H8(1),99,0,G1H8(9),n2h8(28))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(129)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(67),h0tab(:,67),[80,47],[0,0],2,2,wf4(:,6),wf32(:,12))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,6),G0H32(5),m3h4x32(:,21),heltab2x128(:,:,67))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(130)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(68),h0tab(:,68),[80,47],[0,0],2,2,wf4(:,6),wf32(:,16))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,6),G0H32(6),m3h4x32(:,22),heltab2x128(:,:,68))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(131)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(69),h0tab(:,69),[96,31],[0,0],2,2,wf4(:,8),wf32(:,10))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(7),m3h4x32(:,23),heltab2x128(:,:,69))
  call Hloop_A_Q(ntryL,G0H32(7),96,0,G1H32(7),n2h32(17))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(70),h0tab(:,70),[96,31],[0,0],2,2,wf4(:,8),wf32(:,14))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(7),m3h4x32(:,24),heltab2x128(:,:,70))
  call Hloop_A_Q(ntryL,G0H32(7),96,0,G1H32(8),n2h32(18))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(71),h0tab(:,71),[80,47],[0,0],2,2,wf4(:,6),wf32(:,20))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,6),G0H32(7),m3h4x32(:,25),heltab2x128(:,:,71))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(134)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(72),h0tab(:,72),[80,47],[0,0],2,2,wf4(:,6),wf32(:,24))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,6),G0H32(8),m3h4x32(:,26),heltab2x128(:,:,72))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(73),h0tab(:,73),[96,31],[0,0],2,2,wf4(:,8),wf32(:,18))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(9),m3h4x32(:,27),heltab2x128(:,:,73))
  call Hloop_A_Q(ntryL,G0H32(9),96,0,G1H32(9),n2h32(19))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(74),h0tab(:,74),[96,31],[0,0],2,2,wf4(:,8),wf32(:,22))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,8),G0H32(9),m3h4x32(:,28),heltab2x128(:,:,74))
  call Hloop_A_Q(ntryL,G0H32(9),96,0,G1H32(10),n2h32(20))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(14),[G1H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(6),[G1H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(18),[G1H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(9),[G1H8(13)])
  call Hcheck_last_QA_V(ntryL,l_switch,G1H8(14),wf8(:,2),G1tensor(1),m3h8x1(:,25),heltab2x8(:,:,45))
  call Hloop_VA_Q(ntryL,G0H32(1),wf32(:,4),G0H1(1),m3h32x1(:,7),heltab2x32(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,0,G1tensor(6),n2h1(57))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H8(6),wf8(:,4),G1tensor(11),m3h8x1(:,26),heltab2x8(:,:,46))
  call Hloop_VA_Q(ntryL,G0H32(2),wf32(:,8),G0H1(1),m3h32x1(:,8),heltab2x32(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,0,G1tensor(16),n2h1(58))
  call Hloop_VQ_A(ntryL,G0H32(3),wf32(:,2),G0H1(1),m3h32x1(:,9),heltab2x32(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),127,0,G1tensor(21),n2h1(59))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(18),wf8(:,6),G1tensor(26),m3h8x1(:,27),heltab2x8(:,:,47))
  call Hloop_VQ_A(ntryL,G0H32(4),wf32(:,6),G0H1(1),m3h32x1(:,10),heltab2x32(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),127,0,G1tensor(31),n2h1(60))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(9),wf8(:,8),G1tensor(36),m3h8x1(:,28),heltab2x8(:,:,48))
  call Hloop_VA_Q(ntryL,G0H32(5),wf32(:,12),G0H1(1),m3h32x1(:,11),heltab2x32(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,0,G1tensor(41),n2h1(61))
  call Hloop_VA_Q(ntryL,G0H32(6),wf32(:,16),G0H1(1),m3h32x1(:,12),heltab2x32(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,0,G1tensor(46),n2h1(62))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H32(7),wf32(:,10),G1tensor(51),m3h32x1(:,13),heltab2x32(:,:,29))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H32(8),wf32(:,14),G1tensor(56),m3h32x1(:,14),heltab2x32(:,:,30))
  call Hloop_VA_Q(ntryL,G0H32(7),wf32(:,20),G0H1(1),m3h32x1(:,15),heltab2x32(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,0,G1tensor(61),n2h1(63))
  call Hloop_VA_Q(ntryL,G0H32(8),wf32(:,24),G0H1(1),m3h32x1(:,16),heltab2x32(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,0,G1tensor(66),n2h1(64))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H32(9),wf32(:,18),G1tensor(32),m3h32x1(:,17),heltab2x32(:,:,33))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H32(10),wf32(:,22),G1tensor(5),m3h32x1(:,18),heltab2x32(:,:,34))
  call ol_merge_tensors(G0tensor(54),[G0tensor(24),G0tensor(25),G0tensor(20),G0tensor(10),G0tensor(46),G0tensor(6)])
  call ol_merge_tensors(G1tensor(1),[G0tensor(102),G0tensor(91),G0tensor(87),G0tensor(78),G0tensor(3),G0tensor(11)])
  call ol_merge_tensors(G1tensor(66),[G1tensor(61),G1tensor(46),G1tensor(41),G1tensor(16),G1tensor(6),G0tensor(127),G0tensor(82) &
    ,G0tensor(67),G0tensor(36),G0tensor(16)])
  call ol_merge_tensors(G0tensor(64),[G0tensor(28),G0tensor(13),G0tensor(45),G0tensor(18),G0tensor(66),G0tensor(26)])
  call ol_merge_tensors(G1tensor(11),[G0tensor(115),G0tensor(111),G0tensor(106),G0tensor(74),G0tensor(35),G0tensor(31)])
  call ol_merge_tensors(G1tensor(26),[G0tensor(114),G0tensor(75),G0tensor(71),G0tensor(39),G0tensor(9),G0tensor(51)])
  call ol_merge_tensors(G1tensor(5),[G1tensor(32),G1tensor(56),G1tensor(51),G1tensor(31),G1tensor(21),G0tensor(53),G0tensor(69) &
    ,G0tensor(5),G0tensor(56)])
  call ol_merge_tensors(G1tensor(36),[G0tensor(103),G0tensor(99),G0tensor(94),G0tensor(90),G0tensor(8),G0tensor(32)])
  call ol_merge_tensors(G0tensor(88),[G0tensor(80),G0tensor(72),G0tensor(48),G0tensor(22)])
  call ol_merge_tensors(G0tensor(128),[G0tensor(116),G0tensor(104),G0tensor(92),G0tensor(84),G0tensor(76),G0tensor(59),G0tensor(2) &
    ,G0tensor(55),G0tensor(15)])
  call ol_merge_tensors(G0tensor(123),[G0tensor(118),G0tensor(98),G0tensor(95),G0tensor(68),G0tensor(58),G0tensor(43),G0tensor(65) &
    ,G0tensor(47),G0tensor(40)])
  call ol_merge_tensors(G0tensor(126),[G0tensor(122),G0tensor(119),G0tensor(110),G0tensor(107),G0tensor(86),G0tensor(83) &
    ,G0tensor(79),G0tensor(23),G0tensor(62),G0tensor(27)])
  call ol_merge_tensors(G0tensor(112),[G0tensor(108),G0tensor(100),G0tensor(96),G0tensor(60)])
  call ol_merge_tensors(G0tensor(34),[G0tensor(29),G0tensor(7),G0tensor(14),G0tensor(70)])
  call ol_merge_tensors(G0tensor(124),[G0tensor(120),G0tensor(12)])
call TI_bubble_red(G1tensor(1),92,mass2set(:,1),G0tensor(1),M2L1R1)
call TI_bubble_red(G1tensor(66),80,mass2set(:,1),G0tensor(21),M2L1R1)
call TI_bubble_red(G1tensor(11),83,mass2set(:,1),G0tensor(41),M2L1R1)
call TI_bubble_red(G1tensor(26),108,mass2set(:,1),G0tensor(61),M2L1R1)
call TI_bubble_red(G1tensor(5),96,mass2set(:,1),G0tensor(52),M2L1R1)
call TI_bubble_red(G1tensor(36),99,mass2set(:,1),G0tensor(42),M2L1R1)
  call ol_merge_tensors(T0sum(47),[G0tensor(54)])
  call ol_merge_tensors(T0sum(48),[G0tensor(1)])
  call ol_merge_tensors(T0sum(49),[G0tensor(21)])
  call ol_merge_tensors(T0sum(50),[G0tensor(64)])
  call ol_merge_tensors(T0sum(51),[G0tensor(41)])
  call ol_merge_tensors(T0sum(52),[G0tensor(61)])
  call ol_merge_tensors(T0sum(53),[G0tensor(52)])
  call ol_merge_tensors(T0sum(54),[G0tensor(42)])
  call ol_merge_tensors(T0sum(55),[G0tensor(88)])
  call ol_merge_tensors(T0sum(56),[G0tensor(128)])
  call ol_merge_tensors(T0sum(57),[G0tensor(123)])
  call ol_merge_tensors(T0sum(58),[G0tensor(126)])
  call ol_merge_tensors(T0sum(59),[G0tensor(112)])
  call ol_merge_tensors(T0sum(60),[G0tensor(34)])
  call ol_merge_tensors(T0sum(61),[G0tensor(124)])
! end of process


end subroutine vamp_1

end module ol_vamp_1_pplllla_nenexnmnmxddxa_1_/**/REALKIND
