
module ol_vamp_1_pplllla_nenexeexuuxa_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pplllla_nenexeexuuxa_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pplllla_nenexeexuuxa_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pplllla_nenexeexuuxa_1_/**/DREALKIND
  use ol_tensor_sum_storage_pplllla_nenexeexuuxa_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red

  use ol_loop_storage_pplllla_nenexeexuuxa_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pplllla_nenexeexuuxa_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(470)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1),h0tab(:,1),[80,12,3,32],[0,0,0,0],4,3,wf4(:,12),wf4(:,9),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,12),G0H32(1),m3h4x32(:,1),heltab2x128(:,:,1))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(1),n2h32(1))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(471)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(2),h0tab(:,2),[80,12,3,32],[0,0,0,0],4,3,wf4(:,12),wf4(:,14),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,12),G0H32(1),m3h4x32(:,2),heltab2x128(:,:,2))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(2),n2h32(2))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(470)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(3),h0tab(:,3),[80,3,12,32],[0,0,0,0],4,3,wf4(:,12),wf4(:,11),wf4(:,9))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,12),G0H32(1),m3h4x32(:,3),heltab2x128(:,:,3))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(3),n2h32(3))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(471)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(4),h0tab(:,4),[80,3,12,32],[0,0,0,0],4,3,wf4(:,12),wf4(:,11),wf4(:,14))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,12),G0H32(1),m3h4x32(:,4),heltab2x128(:,:,4))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(4),n2h32(4))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(476)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(5),h0tab(:,5),[96,12,3,16],[0,0,0,0],4,3,wf4(:,16),wf4(:,9),wf4(:,11))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(1),m3h4x32(:,5),heltab2x128(:,:,5))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(5),n2h32(5))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(477)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(6),h0tab(:,6),[96,12,3,16],[0,0,0,0],4,3,wf4(:,16),wf4(:,14),wf4(:,11))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(1),m3h4x32(:,6),heltab2x128(:,:,6))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(6),n2h32(6))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(476)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(7),h0tab(:,7),[96,3,12,16],[0,0,0,0],4,3,wf4(:,16),wf4(:,11),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(1),m3h4x32(:,7),heltab2x128(:,:,7))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(7),n2h32(7))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(477)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(8),h0tab(:,8),[96,3,12,16],[0,0,0,0],4,3,wf4(:,16),wf4(:,11),wf4(:,14))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(1),m3h4x32(:,8),heltab2x128(:,:,8))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(8),n2h32(8))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(338)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(9),h0tab(:,9),[64,12,19,32],[0,0,0,0],4,2,wf4(:,9),wf8(:,8))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1),heltab2x128(:,:,9))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(1),n2h64(1))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(341)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(10),h0tab(:,10),[64,12,19,32],[0,0,0,0],4,2,wf4(:,14),wf8(:,8))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,2),heltab2x128(:,:,10))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(2),n2h64(2))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(338)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(11),h0tab(:,11),[64,12,32,19],[0,0,0,0],4,2,wf4(:,9),wf8(:,8))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,3),heltab2x128(:,:,11))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(3),n2h64(3))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(341)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(12),h0tab(:,12),[64,12,32,19],[0,0,0,0],4,2,wf4(:,14),wf8(:,8))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,4),heltab2x128(:,:,12))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(4),n2h64(4))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(343)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(13),h0tab(:,13),[64,12,35,16],[0,0,0,0],4,2,wf4(:,9),wf8(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,5),heltab2x128(:,:,13))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(5),n2h64(5))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(346)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(14),h0tab(:,14),[64,12,35,16],[0,0,0,0],4,2,wf4(:,14),wf8(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,6),heltab2x128(:,:,14))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(6),n2h64(6))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(343)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(15),h0tab(:,15),[64,12,16,35],[0,0,0,0],4,2,wf4(:,9),wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,7),heltab2x128(:,:,15))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(7),n2h64(7))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(346)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(16),h0tab(:,16),[64,12,16,35],[0,0,0,0],4,2,wf4(:,14),wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,8),heltab2x128(:,:,16))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(8),n2h64(8))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(348)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(17),h0tab(:,17),[64,3,28,32],[0,0,0,0],4,2,wf4(:,11),wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,9),heltab2x128(:,:,17))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(9),n2h64(9))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(350)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(18),h0tab(:,18),[64,3,28,32],[0,0,0,0],4,2,wf4(:,11),wf8(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,10),heltab2x128(:,:,18))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(10),n2h64(10))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(348)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(19),h0tab(:,19),[64,3,32,28],[0,0,0,0],4,2,wf4(:,11),wf8(:,10))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,11),heltab2x128(:,:,19))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(11),n2h64(11))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(350)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(20),h0tab(:,20),[64,3,32,28],[0,0,0,0],4,2,wf4(:,11),wf8(:,12))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,12),heltab2x128(:,:,20))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(12),n2h64(12))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(352)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(21),h0tab(:,21),[64,3,44,16],[0,0,0,0],4,2,wf4(:,11),wf8(:,4))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,13),heltab2x128(:,:,21))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(13),n2h64(13))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(354)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(22),h0tab(:,22),[64,3,44,16],[0,0,0,0],4,2,wf4(:,11),wf8(:,6))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,14),heltab2x128(:,:,22))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(14),n2h64(14))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(352)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(23),h0tab(:,23),[64,3,16,44],[0,0,0,0],4,2,wf4(:,11),wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,15),heltab2x128(:,:,23))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(15),n2h64(15))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(354)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(24),h0tab(:,24),[64,3,16,44],[0,0,0,0],4,2,wf4(:,11),wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,16),heltab2x128(:,:,24))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(16),n2h64(16))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(490)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(25),h0tab(:,25),[76,3,16,32],[0,0,0,0],4,2,wf8(:,25),wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,25),G0H16(1),m3h8x16(:,1),heltab2x128(:,:,25))
  call Hloop_A_Q(ntryL,G0H16(1),76,0,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(491)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(26),h0tab(:,26),[76,3,16,32],[0,0,0,0],4,2,wf8(:,27),wf4(:,11))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,27),G0H16(1),ngZu,m3h8x16(:,2),heltab2x128(:,:,26))
  call Hloop_A_Q(ntryL,G0H16(1),76,0,G1H16(2),n2h16(2))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(490)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(27),h0tab(:,27),[76,3,32,16],[0,0,0,0],4,2,wf8(:,25),wf4(:,11))
  call Hloop_QV_A(ntryL,G0H128(1),wf8(:,25),G0H16(1),m3h8x16(:,3),heltab2x128(:,:,27))
  call Hloop_Q_A(ntryL,G0H16(1),76,0,G1H16(3),n2h16(3))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(491)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(28),h0tab(:,28),[76,3,32,16],[0,0,0,0],4,2,wf8(:,27),wf4(:,11))
  call Hloop_QZ_A(ntryL,G0H128(1),wf8(:,27),G0H16(1),ngZu,m3h8x16(:,4),heltab2x128(:,:,28))
  call Hloop_Q_A(ntryL,G0H16(1),76,0,G1H16(4),n2h16(4))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(496)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(29),h0tab(:,29),[76,3,16,32],[0,0,0,0],4,2,wf8(:,28),wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,28),G0H16(1),m3h8x16(:,5),heltab2x128(:,:,29))
  call Hloop_A_Q(ntryL,G0H16(1),76,0,G1H16(5),n2h16(5))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(497)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(30),h0tab(:,30),[76,3,16,32],[0,0,0,0],4,2,wf8(:,30),wf4(:,11))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,30),G0H16(1),ngZu,m3h8x16(:,6),heltab2x128(:,:,30))
  call Hloop_A_Q(ntryL,G0H16(1),76,0,G1H16(6),n2h16(6))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(496)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(31),h0tab(:,31),[76,3,32,16],[0,0,0,0],4,2,wf8(:,28),wf4(:,11))
  call Hloop_QV_A(ntryL,G0H128(1),wf8(:,28),G0H16(1),m3h8x16(:,7),heltab2x128(:,:,31))
  call Hloop_Q_A(ntryL,G0H16(1),76,0,G1H16(7),n2h16(7))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(497)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(32),h0tab(:,32),[76,3,32,16],[0,0,0,0],4,2,wf8(:,30),wf4(:,11))
  call Hloop_QZ_A(ntryL,G0H128(1),wf8(:,30),G0H16(1),ngZu,m3h8x16(:,8),heltab2x128(:,:,32))
  call Hloop_Q_A(ntryL,G0H16(1),76,0,G1H16(8),n2h16(8))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(276)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(33),h0tab(:,33),[64,15,32,16],[0,0,0,0],4,1,wf16(:,27))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,17),heltab2x128(:,:,33))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(17),n2h64(17))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(278)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(34),h0tab(:,34),[64,15,32,16],[0,0,0,0],4,1,wf16(:,154))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,18),heltab2x128(:,:,34))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(18),n2h64(18))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(276)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(35),h0tab(:,35),[64,15,16,32],[0,0,0,0],4,1,wf16(:,27))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,19),heltab2x128(:,:,35))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(19),n2h64(19))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(278)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(36),h0tab(:,36),[64,15,16,32],[0,0,0,0],4,1,wf16(:,154))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,20),heltab2x128(:,:,36))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(20),n2h64(20))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(280)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(37),h0tab(:,37),[64,15,32,16],[0,0,0,0],4,1,wf16(:,29))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,21),heltab2x128(:,:,37))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(21),n2h64(21))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(282)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(38),h0tab(:,38),[64,15,32,16],[0,0,0,0],4,1,wf16(:,155))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,22),heltab2x128(:,:,38))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(22),n2h64(22))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(280)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(39),h0tab(:,39),[64,15,16,32],[0,0,0,0],4,1,wf16(:,29))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,23),heltab2x128(:,:,39))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(23),n2h64(23))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(282)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(40),h0tab(:,40),[64,15,16,32],[0,0,0,0],4,1,wf16(:,155))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,24),heltab2x128(:,:,40))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(24),n2h64(24))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(507)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(41),h0tab(:,41),[80,6,9,32],[0,0,0,0],4,3,wf4(:,12),wf4(:,5),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,12),G0H32(1),m3h4x32(:,9),heltab2x128(:,:,41))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(9),n2h32(9))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(509)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(42),h0tab(:,42),[96,9,6,16],[0,0,0,0],4,3,wf4(:,16),wf4(:,4),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(1),m3h4x32(:,10),heltab2x128(:,:,42))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(10),n2h32(10))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(384)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(43),h0tab(:,43),[64,6,41,16],[0,0,0,0],4,2,wf4(:,5),wf8(:,42))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,25),heltab2x128(:,:,43))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(25),n2h64(25))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(384)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(44),h0tab(:,44),[64,6,16,41],[0,0,0,0],4,2,wf4(:,5),wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,26),heltab2x128(:,:,44))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(26),n2h64(26))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(386)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(45),h0tab(:,45),[73,6,16,32],[0,0,0,0],4,2,wf8(:,38),wf4(:,5))
  call Hloop_AW_Q(ntryL,G0H128(1),wf8(:,38),G0H16(1),m3h8x16(:,9),heltab2x128(:,:,45))
  call Hloop_A_Q(ntryL,G0H16(1),73,0,G1H16(9),n2h16(9))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(389)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(46),h0tab(:,46),[64,9,22,32],[0,0,0,0],4,2,wf4(:,4),wf8(:,44))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,27),heltab2x128(:,:,46))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(27),n2h64(27))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(389)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(47),h0tab(:,47),[64,9,32,22],[0,0,0,0],4,2,wf4(:,4),wf8(:,44))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,28),heltab2x128(:,:,47))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(28),n2h64(28))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(391)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(48),h0tab(:,48),[70,9,32,16],[0,0,0,0],4,2,wf8(:,40),wf4(:,4))
  call Hloop_QW_A(ntryL,G0H128(1),wf8(:,40),G0H16(1),m3h8x16(:,10),heltab2x128(:,:,48))
  call Hloop_Q_A(ntryL,G0H16(1),70,0,G1H16(10),n2h16(10))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(209)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(49),h0tab(:,49),[64,15,32,16],[0,0,0,0],4,1,wf16(:,36))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,29),heltab2x128(:,:,49))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(29),n2h64(29))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(212)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(50),h0tab(:,50),[64,15,32,16],[0,0,0,0],4,1,wf16(:,107))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,30),heltab2x128(:,:,50))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(30),n2h64(30))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(209)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(51),h0tab(:,51),[64,15,16,32],[0,0,0,0],4,1,wf16(:,36))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,31),heltab2x128(:,:,51))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(31),n2h64(31))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(212)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(52),h0tab(:,52),[64,15,16,32],[0,0,0,0],4,1,wf16(:,107))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,32),heltab2x128(:,:,52))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(32),n2h64(32))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(401)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(53),h0tab(:,53),[73,6,16,32],[0,0,0,0],4,2,wf8(:,48),wf4(:,5))
  call Hloop_AW_Q(ntryL,G0H128(1),wf8(:,48),G0H16(1),m3h8x16(:,11),heltab2x128(:,:,53))
  call Hloop_A_Q(ntryL,G0H16(1),73,0,G1H16(11),n2h16(11))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(308)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(54),h0tab(:,54),[64,15,32,16],[0,0,0,0],4,1,wf16(:,47))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,33),heltab2x128(:,:,54))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(33),n2h64(33))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(310)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(55),h0tab(:,55),[64,15,32,16],[0,0,0,0],4,1,wf16(:,166))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,34),heltab2x128(:,:,55))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(34),n2h64(34))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(308)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(56),h0tab(:,56),[64,15,16,32],[0,0,0,0],4,1,wf16(:,47))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,35),heltab2x128(:,:,56))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(35),n2h64(35))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(310)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(57),h0tab(:,57),[64,15,16,32],[0,0,0,0],4,1,wf16(:,166))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,36),heltab2x128(:,:,57))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(36),n2h64(36))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(312)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(58),h0tab(:,58),[64,15,32,16],[0,0,0,0],4,1,wf16(:,167))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,37),heltab2x128(:,:,58))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(37),n2h64(37))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(312)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(59),h0tab(:,59),[64,15,16,32],[0,0,0,0],4,1,wf16(:,167))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,38),heltab2x128(:,:,59))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(38),n2h64(38))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(424)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(60),h0tab(:,60),[70,9,32,16],[0,0,0,0],4,2,wf8(:,56),wf4(:,4))
  call Hloop_QW_A(ntryL,G0H128(1),wf8(:,56),G0H16(1),m3h8x16(:,12),heltab2x128(:,:,60))
  call Hloop_Q_A(ntryL,G0H16(1),70,0,G1H16(12),n2h16(12))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(319)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(61),h0tab(:,61),[64,15,32,16],[0,0,0,0],4,1,wf16(:,56))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,39),heltab2x128(:,:,61))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(39),n2h64(39))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(321)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(62),h0tab(:,62),[64,15,32,16],[0,0,0,0],4,1,wf16(:,169))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,40),heltab2x128(:,:,62))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(40),n2h64(40))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(319)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(63),h0tab(:,63),[64,15,16,32],[0,0,0,0],4,1,wf16(:,56))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,41),heltab2x128(:,:,63))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(41),n2h64(41))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(321)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(64),h0tab(:,64),[64,15,16,32],[0,0,0,0],4,1,wf16(:,169))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,42),heltab2x128(:,:,64))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(42),n2h64(42))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(323)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(65),h0tab(:,65),[64,15,32,16],[0,0,0,0],4,1,wf16(:,170))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,43),heltab2x128(:,:,65))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(43),n2h64(43))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(323)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(66),h0tab(:,66),[64,15,16,32],[0,0,0,0],4,1,wf16(:,170))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,44),heltab2x128(:,:,66))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(44),n2h64(44))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(328)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(67),h0tab(:,67),[64,15,32,16],[0,0,0,0],4,1,wf16(:,171))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,45),heltab2x128(:,:,67))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(45),n2h64(45))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(328)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(68),h0tab(:,68),[64,15,16,32],[0,0,0,0],4,1,wf16(:,171))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,46),heltab2x128(:,:,68))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(46),n2h64(46))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(330)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(69),h0tab(:,69),[64,15,32,16],[0,0,0,0],4,1,wf16(:,172))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,47),heltab2x128(:,:,69))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(47),n2h64(47))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(330)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(70),h0tab(:,70),[64,15,16,32],[0,0,0,0],4,1,wf16(:,172))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,48),heltab2x128(:,:,70))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(48),n2h64(48))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(6),[G1H16(5),G1H16(2),G1H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(8),[G1H16(7),G1H16(4),G1H16(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(11),[G1H16(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(12),[G1H16(10)])
  call Hloop_QV_A(ntryL,G1H32(1),wf4(:,9),G1H8(1),m3h4x8(:,1),heltab2x32(:,:,1))
  call Hloop_Q_A(ntryL,G1H8(1),92,0,G2H8(1),n2h8(1))
  call Hloop_QZ_A(ntryL,G1H32(2),wf4(:,14),G1H8(1),ngZu,m3h4x8(:,2),heltab2x32(:,:,2))
  call Hloop_Q_A(ntryL,G1H8(1),92,0,G2H8(2),n2h8(2))
  call Hloop_QZ_A(ntryL,G1H32(3),wf4(:,11),G1H8(1),ngZu,m3h4x8(:,3),heltab2x32(:,:,3))
  call Hloop_Q_A(ntryL,G1H8(1),83,0,G2H8(3),n2h8(3))
  call Hloop_QZ_A(ntryL,G1H32(4),wf4(:,11),G1H8(1),ngZu,m3h4x8(:,4),heltab2x32(:,:,4))
  call Hloop_Q_A(ntryL,G1H8(1),83,0,G2H8(4),n2h8(4))
  call Hloop_AV_Q(ntryL,G1H32(5),wf4(:,9),G1H8(1),m3h4x8(:,5),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G1H8(1),108,0,G2H8(5),n2h8(5))
  call Hloop_AZ_Q(ntryL,G1H32(6),wf4(:,14),G1H8(1),ngZu,m3h4x8(:,6),heltab2x32(:,:,6))
  call Hloop_A_Q(ntryL,G1H8(1),108,0,G2H8(6),n2h8(6))
  call Hloop_AZ_Q(ntryL,G1H32(7),wf4(:,11),G1H8(1),ngZu,m3h4x8(:,7),heltab2x32(:,:,7))
  call Hloop_A_Q(ntryL,G1H8(1),99,0,G2H8(7),n2h8(7))
  call Hloop_AZ_Q(ntryL,G1H32(8),wf4(:,11),G1H8(1),ngZu,m3h4x8(:,8),heltab2x32(:,:,8))
  call Hloop_A_Q(ntryL,G1H8(1),99,0,G2H8(8),n2h8(8))
  call Hloop_AV_Q(ntryL,G1H64(1),wf4(:,9),G1H16(5),m3h4x16(:,1),heltab2x64(:,:,1))
  call Hloop_A_Q(ntryL,G1H16(5),76,0,G2H16(1),n2h16(13))
  call Hloop_AZ_Q(ntryL,G1H64(2),wf4(:,14),G1H16(2),ngZu,m3h4x16(:,2),heltab2x64(:,:,2))
  call Hloop_A_Q(ntryL,G1H16(2),76,0,G2H16(2),n2h16(14))
  call Hloop_QV_A(ntryL,G1H64(3),wf4(:,9),G1H16(1),m3h4x16(:,3),heltab2x64(:,:,3))
  call Hloop_Q_A(ntryL,G1H16(1),76,0,G2H16(3),n2h16(15))
  call Hloop_QZ_A(ntryL,G1H64(4),wf4(:,14),G1H16(7),ngZu,m3h4x16(:,4),heltab2x64(:,:,4))
  call Hloop_Q_A(ntryL,G1H16(7),76,0,G2H16(4),n2h16(16))
  call Hloop_QV_A(ntryL,G1H64(5),wf4(:,9),G1H16(4),m3h4x16(:,5),heltab2x64(:,:,5))
  call Hloop_Q_A(ntryL,G1H16(4),76,0,G2H16(5),n2h16(17))
  call Hloop_QZ_A(ntryL,G1H64(6),wf4(:,14),G1H16(3),ngZu,m3h4x16(:,6),heltab2x64(:,:,6))
  call Hloop_Q_A(ntryL,G1H16(3),76,0,G2H16(6),n2h16(18))
  call Hloop_AV_Q(ntryL,G1H64(7),wf4(:,9),G1H16(9),m3h4x16(:,7),heltab2x64(:,:,7))
  call Hloop_A_Q(ntryL,G1H16(9),76,0,G2H16(7),n2h16(19))
  call Hloop_AZ_Q(ntryL,G1H64(8),wf4(:,14),G1H16(10),ngZu,m3h4x16(:,8),heltab2x64(:,:,8))
  call Hloop_A_Q(ntryL,G1H16(10),76,0,G2H16(8),n2h16(20))
  call Hloop_AZ_Q(ntryL,G1H64(9),wf4(:,11),G1H16(5),ngZu,m3h4x16(:,9),heltab2x64(:,:,9))
  call Hloop_A_Q(ntryL,G1H16(5),67,0,G2H16(9),n2h16(21))
  call Hloop_AZ_Q(ntryL,G1H64(10),wf4(:,11),G1H16(2),ngZu,m3h4x16(:,10),heltab2x64(:,:,10))
  call Hloop_A_Q(ntryL,G1H16(2),67,0,G2H16(10),n2h16(22))
  call Hloop_QZ_A(ntryL,G1H64(11),wf4(:,11),G1H16(1),ngZu,m3h4x16(:,11),heltab2x64(:,:,11))
  call Hloop_Q_A(ntryL,G1H16(1),67,0,G2H16(11),n2h16(23))
  call Hloop_QZ_A(ntryL,G1H64(12),wf4(:,11),G1H16(7),ngZu,m3h4x16(:,12),heltab2x64(:,:,12))
  call Hloop_Q_A(ntryL,G1H16(7),67,0,G2H16(12),n2h16(24))
  call Hloop_QZ_A(ntryL,G1H64(13),wf4(:,11),G1H16(4),ngZu,m3h4x16(:,13),heltab2x64(:,:,13))
  call Hloop_Q_A(ntryL,G1H16(4),67,0,G2H16(13),n2h16(25))
  call Hloop_QZ_A(ntryL,G1H64(14),wf4(:,11),G1H16(3),ngZu,m3h4x16(:,14),heltab2x64(:,:,14))
  call Hloop_Q_A(ntryL,G1H16(3),67,0,G2H16(14),n2h16(26))
  call Hloop_AZ_Q(ntryL,G1H64(15),wf4(:,11),G1H16(9),ngZu,m3h4x16(:,15),heltab2x64(:,:,15))
  call Hloop_A_Q(ntryL,G1H16(9),67,0,G2H16(15),n2h16(27))
  call Hloop_AZ_Q(ntryL,G1H64(16),wf4(:,11),G1H16(10),ngZu,m3h4x16(:,16),heltab2x64(:,:,16))
  call Hloop_A_Q(ntryL,G1H16(10),67,0,G2H16(16),n2h16(28))
  call Hloop_AZ_Q(ntryL,G1H16(6),wf4(:,11),G1H4(1),ngZu,m3h4x4(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(1),n2h4(1))
  call Hloop_QZ_A(ntryL,G1H16(8),wf4(:,11),G1H4(1),ngZu,m3h4x4(:,2),heltab2x16(:,:,2))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(2),n2h4(2))
  call Hloop_QV_A(ntryL,G1H64(17),wf16(:,27),G1H4(1),m3h16x4(:,1),heltab2x64(:,:,17))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(3),n2h4(3))
  call Hloop_QZ_A(ntryL,G1H64(18),wf16(:,154),G1H4(1),ngZu,m3h16x4(:,2),heltab2x64(:,:,18))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(4),n2h4(4))
  call Hloop_AV_Q(ntryL,G1H64(19),wf16(:,27),G1H4(1),m3h16x4(:,3),heltab2x64(:,:,19))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(5),n2h4(5))
  call Hloop_AZ_Q(ntryL,G1H64(20),wf16(:,154),G1H4(1),ngZu,m3h16x4(:,4),heltab2x64(:,:,20))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(6),n2h4(6))
  call Hloop_QV_A(ntryL,G1H64(21),wf16(:,29),G1H4(1),m3h16x4(:,5),heltab2x64(:,:,21))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(7),n2h4(7))
  call Hloop_QZ_A(ntryL,G1H64(22),wf16(:,155),G1H4(1),ngZu,m3h16x4(:,6),heltab2x64(:,:,22))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(8),n2h4(8))
  call Hloop_AV_Q(ntryL,G1H64(23),wf16(:,29),G1H4(1),m3h16x4(:,7),heltab2x64(:,:,23))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(9),n2h4(9))
  call Hloop_AZ_Q(ntryL,G1H64(24),wf16(:,155),G1H4(1),ngZu,m3h16x4(:,8),heltab2x64(:,:,24))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(10),n2h4(10))
  call Hloop_QW_A(ntryL,G1H32(9),wf4(:,5),G1H8(1),m3h4x8(:,9),heltab2x32(:,:,9))
  call Hloop_Q_A(ntryL,G1H8(1),86,0,G2H8(9),n2h8(9))
  call Hloop_AW_Q(ntryL,G1H32(10),wf4(:,4),G1H8(1),m3h4x8(:,10),heltab2x32(:,:,10))
  call Hloop_A_Q(ntryL,G1H8(1),105,0,G2H8(10),n2h8(10))
  call Hloop_QW_A(ntryL,G1H64(25),wf4(:,5),G1H16(5),m3h4x16(:,17),heltab2x64(:,:,25))
  call Hloop_Q_A(ntryL,G1H16(5),70,0,G2H16(17),n2h16(29))
  call Hloop_AW_Q(ntryL,G1H64(26),wf4(:,5),G1H16(2),m3h4x16(:,18),heltab2x64(:,:,26))
  call Hloop_A_Q(ntryL,G1H16(2),70,0,G2H16(18),n2h16(30))
  call Hloop_AW_Q(ntryL,G1H16(11),wf4(:,5),G1H4(1),m3h4x4(:,3),heltab2x16(:,:,3))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(11),n2h4(11))
  call Hloop_AW_Q(ntryL,G1H64(27),wf4(:,4),G1H16(1),m3h4x16(:,19),heltab2x64(:,:,27))
  call Hloop_A_Q(ntryL,G1H16(1),73,0,G2H16(19),n2h16(31))
  call Hloop_QW_A(ntryL,G1H64(28),wf4(:,4),G1H16(7),m3h4x16(:,20),heltab2x64(:,:,28))
  call Hloop_Q_A(ntryL,G1H16(7),73,0,G2H16(20),n2h16(32))
  call Hloop_QW_A(ntryL,G1H16(12),wf4(:,4),G1H4(1),m3h4x4(:,4),heltab2x16(:,:,4))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(12),n2h4(12))
  call Hloop_QV_A(ntryL,G1H64(29),wf16(:,36),G1H4(1),m3h16x4(:,9),heltab2x64(:,:,29))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(13),n2h4(13))
  call Hloop_QZ_A(ntryL,G1H64(30),wf16(:,107),G1H4(1),ngZu,m3h16x4(:,10),heltab2x64(:,:,30))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(14),n2h4(14))
  call Hloop_AV_Q(ntryL,G1H64(31),wf16(:,36),G1H4(1),m3h16x4(:,11),heltab2x64(:,:,31))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(15),n2h4(15))
  call Hloop_AZ_Q(ntryL,G1H64(32),wf16(:,107),G1H4(1),ngZu,m3h16x4(:,12),heltab2x64(:,:,32))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(16),n2h4(16))
  call Hloop_QV_A(ntryL,G1H64(33),wf16(:,47),G1H4(1),m3h16x4(:,13),heltab2x64(:,:,33))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(17),n2h4(17))
  call Hloop_QZ_A(ntryL,G1H64(34),wf16(:,166),G1H4(1),ngZu,m3h16x4(:,14),heltab2x64(:,:,34))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(18),n2h4(18))
  call Hloop_AV_Q(ntryL,G1H64(35),wf16(:,47),G1H4(1),m3h16x4(:,15),heltab2x64(:,:,35))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(19),n2h4(19))
  call Hloop_AZ_Q(ntryL,G1H64(36),wf16(:,166),G1H4(1),ngZu,m3h16x4(:,16),heltab2x64(:,:,36))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(20),n2h4(20))
  call Hloop_QZ_A(ntryL,G1H64(37),wf16(:,167),G1H4(1),ngZu,m3h16x4(:,17),heltab2x64(:,:,37))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(21),n2h4(21))
  call Hloop_AZ_Q(ntryL,G1H64(38),wf16(:,167),G1H4(1),ngZu,m3h16x4(:,18),heltab2x64(:,:,38))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(22),n2h4(22))
  call Hloop_QV_A(ntryL,G1H64(39),wf16(:,56),G1H4(1),m3h16x4(:,19),heltab2x64(:,:,39))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(23),n2h4(23))
  call Hloop_QZ_A(ntryL,G1H64(40),wf16(:,169),G1H4(1),ngZu,m3h16x4(:,20),heltab2x64(:,:,40))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(24),n2h4(24))
  call Hloop_AV_Q(ntryL,G1H64(41),wf16(:,56),G1H4(1),m3h16x4(:,21),heltab2x64(:,:,41))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(25),n2h4(25))
  call Hloop_AZ_Q(ntryL,G1H64(42),wf16(:,169),G1H4(1),ngZu,m3h16x4(:,22),heltab2x64(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(26),n2h4(26))
  call Hloop_QZ_A(ntryL,G1H64(43),wf16(:,170),G1H4(1),ngZu,m3h16x4(:,23),heltab2x64(:,:,43))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(27),n2h4(27))
  call Hloop_AZ_Q(ntryL,G1H64(44),wf16(:,170),G1H4(1),ngZu,m3h16x4(:,24),heltab2x64(:,:,44))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(28),n2h4(28))
  call Hloop_QZ_A(ntryL,G1H64(45),wf16(:,171),G1H4(1),ngZu,m3h16x4(:,25),heltab2x64(:,:,45))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(29),n2h4(29))
  call Hloop_AZ_Q(ntryL,G1H64(46),wf16(:,171),G1H4(1),ngZu,m3h16x4(:,26),heltab2x64(:,:,46))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(30),n2h4(30))
  call Hloop_QZ_A(ntryL,G1H64(47),wf16(:,172),G1H4(1),ngZu,m3h16x4(:,27),heltab2x64(:,:,47))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(31),n2h4(31))
  call Hloop_AZ_Q(ntryL,G1H64(48),wf16(:,172),G1H4(1),ngZu,m3h16x4(:,28),heltab2x64(:,:,48))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(32),n2h4(32))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(2),[G2H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(6),[G2H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(2),[G2H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(4),[G2H16(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(6),[G2H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(8),[G2H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(31),[G2H4(29),G2H4(27),G2H4(24),G2H4(23),G2H4(21) &
    ,G2H4(18),G2H4(17),G2H4(14),G2H4(13),G2H4(8),G2H4(7),G2H4(4),G2H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(32),[G2H4(30),G2H4(28),G2H4(26),G2H4(25),G2H4(22) &
    ,G2H4(20),G2H4(19),G2H4(16),G2H4(15),G2H4(10),G2H4(9),G2H4(6),G2H4(5)])
  call Hotf_4pt_reduction(G2H8(2),RedSet_4(1),mass4set(:,1),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),8)
  call HG1shiftOLR(G1H8(2),32,8)
  call Hotf_4pt_reduction(G2H8(3),RedSet_4(2),mass4set(:,1),  & 
G1H8(6),G1H8(7),G1H8(8),G1H8(9),G1H8(10),8)
  call HG1shiftOLR(G1H8(7),32,8)
  call Hotf_4pt_reduction(G2H8(4),RedSet_4(2),mass4set(:,1),  & 
G1H8(11),G1H8(12),G1H8(13),G1H8(14),G1H8(15),8)
  call HG1shiftOLR(G1H8(12),32,8)
  call Hotf_4pt_reduction(G2H8(6),RedSet_4(3),mass4set(:,1),  & 
G1H8(16),G1H8(17),G1H8(18),G1H8(19),G1H8(20),8)
  call HG1shiftOLR(G1H8(17),16,8)
  call Hotf_4pt_reduction(G2H8(7),RedSet_4(4),mass4set(:,1),  & 
G1H8(21),G1H8(22),G1H8(23),G1H8(24),G1H8(25),8)
  call HG1shiftOLR(G1H8(22),16,8)
  call Hotf_4pt_reduction(G2H8(8),RedSet_4(4),mass4set(:,1),  & 
G1H8(26),G1H8(27),G1H8(28),G1H8(29),G1H8(30),8)
  call HG1shiftOLR(G1H8(27),16,8)
  call Hloop_AQ_V(ntryL,G2H16(2),wf8(:,8),G2H2(1),m3h8x2(:,1),heltab2x16(:,:,5))
  call Hloop_QA_V(ntryL,G2H16(4),ex6(:),G2H8(1),m3h2x8(:,1),heltab2x16(:,:,6))
  call Hloop_QA_V(ntryL,G2H16(6),wf8(:,2),G2H2(2),m3h8x2(:,2),heltab2x16(:,:,7))
  call Hloop_AQ_V(ntryL,G2H16(8),ex5(:),G2H8(5),m3h2x8(:,2),heltab2x16(:,:,8))
  call Hloop_AQ_V(ntryL,G2H16(9),wf8(:,10),G2H2(3),m3h8x2(:,3),heltab2x16(:,:,9))
  call Hloop_AQ_V(ntryL,G2H16(10),wf8(:,12),G2H2(4),m3h8x2(:,4),heltab2x16(:,:,10))
  call Hloop_QA_V(ntryL,G2H16(11),ex6(:),G2H8(2),m3h2x8(:,3),heltab2x16(:,:,11))
  call Hloop_QA_V(ntryL,G2H16(12),ex6(:),G2H8(3),m3h2x8(:,4),heltab2x16(:,:,12))
  call Hloop_QA_V(ntryL,G2H16(13),wf8(:,4),G2H2(5),m3h8x2(:,5),heltab2x16(:,:,13))
  call Hloop_QA_V(ntryL,G2H16(14),wf8(:,6),G2H2(6),m3h8x2(:,6),heltab2x16(:,:,14))
  call Hloop_AQ_V(ntryL,G2H16(15),ex5(:),G2H8(4),m3h2x8(:,5),heltab2x16(:,:,15))
  call Hloop_AQ_V(ntryL,G2H16(16),ex5(:),G2H8(6),m3h2x8(:,6),heltab2x16(:,:,16))
  call Hloop_AQ_V(ntryL,G2H4(1),ex5(:),G2H2(7),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_V(ntryL,G2H4(2),ex6(:),G2H2(8),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_V(ntryL,G2H4(31),ex6(:),G2H2(9),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_AQ_V(ntryL,G2H4(32),ex5(:),G2H2(10),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hotf_4pt_reduction(G2H8(9),RedSet_4(5),mass4set(:,1),  & 
G1H8(31),G1H8(32),G1H8(33),G1H8(34),G1H8(35),8)
  call HG1shiftOLR(G1H8(32),32,8)
  call Hotf_4pt_reduction(G2H8(10),RedSet_4(6),mass4set(:,1),  & 
G1H8(36),G1H8(37),G1H8(38),G1H8(39),G1H8(40),8)
  call HG1shiftOLR(G1H8(37),16,8)
  call Hloop_QA_V(ntryL,G2H16(17),wf8(:,42),G2H2(11),m3h8x2(:,7),heltab2x16(:,:,17))
  call Hloop_AQ_V(ntryL,G2H16(18),ex5(:),G2H8(7),m3h2x8(:,7),heltab2x16(:,:,18))
  call Hloop_AQ_V(ntryL,G2H4(11),ex5(:),G2H2(12),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_V(ntryL,G2H16(19),wf8(:,44),G2H2(13),m3h8x2(:,8),heltab2x16(:,:,19))
  call Hloop_QA_V(ntryL,G2H16(20),ex6(:),G2H8(8),m3h2x8(:,8),heltab2x16(:,:,20))
  call Hloop_QA_V(ntryL,G2H4(12),ex6(:),G2H2(14),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_QZ_A(ntryL,G1H8(1),wf4(:,11),G1H2(1),ngZu,m3h4x2(:,1),heltab2x8(:,:,1))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(15),n2h2(1))
call HGT_raise_alpha_OLR(G1H8(2),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(2),ex6(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,2))
  call Hloop_QZ_A(ntryL,G1H8(4),wf4(:,11),G1H2(1),ngZu,m3h4x2(:,2),heltab2x8(:,:,3))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(16),n2h2(2))
  call Hloop_QZ_A(ntryL,G1H8(5),wf4(:,11),G1H2(1),ngZu,m3h4x2(:,3),heltab2x8(:,:,4))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(17),n2h2(3))
  call Hloop_QV_A(ntryL,G1H8(6),wf4(:,9),G1H2(1),m3h4x2(:,4),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(18),n2h2(4))
call HGT_raise_alpha_OLR(G1H8(7),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(7),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(7),ex6(:),G1H4(2),m3h2x4(:,2),heltab2x8(:,:,6))
  call Hloop_QV_A(ntryL,G1H8(9),wf4(:,9),G1H2(1),m3h4x2(:,5),heltab2x8(:,:,7))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(19),n2h2(5))
  call Hloop_QV_A(ntryL,G1H8(10),wf4(:,9),G1H2(1),m3h4x2(:,6),heltab2x8(:,:,8))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(20),n2h2(6))
  call Hloop_QZ_A(ntryL,G1H8(11),wf4(:,14),G1H2(1),ngZu,m3h4x2(:,7),heltab2x8(:,:,9))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(21),n2h2(7))
call HGT_raise_alpha_OLR(G1H8(12),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(12),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(12),ex6(:),G1H4(3),m3h2x4(:,3),heltab2x8(:,:,10))
  call Hloop_QZ_A(ntryL,G1H8(14),wf4(:,14),G1H2(1),ngZu,m3h4x2(:,8),heltab2x8(:,:,11))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(22),n2h2(8))
  call Hloop_QZ_A(ntryL,G1H8(15),wf4(:,14),G1H2(1),ngZu,m3h4x2(:,9),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(23),n2h2(9))
  call Hloop_AZ_Q(ntryL,G1H8(16),wf4(:,11),G1H2(1),ngZu,m3h4x2(:,10),heltab2x8(:,:,13))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(24),n2h2(10))
call HGT_raise_alpha_OLR(G1H8(17),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(17),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(17),ex5(:),G1H4(4),m3h2x4(:,4),heltab2x8(:,:,14))
  call Hloop_AZ_Q(ntryL,G1H8(19),wf4(:,11),G1H2(1),ngZu,m3h4x2(:,11),heltab2x8(:,:,15))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(25),n2h2(11))
  call Hloop_AZ_Q(ntryL,G1H8(20),wf4(:,11),G1H2(1),ngZu,m3h4x2(:,12),heltab2x8(:,:,16))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(26),n2h2(12))
  call Hloop_AV_Q(ntryL,G1H8(21),wf4(:,9),G1H2(1),m3h4x2(:,13),heltab2x8(:,:,17))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(27),n2h2(13))
call HGT_raise_alpha_OLR(G1H8(22),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(22),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(22),ex5(:),G1H4(5),m3h2x4(:,5),heltab2x8(:,:,18))
  call Hloop_AV_Q(ntryL,G1H8(24),wf4(:,9),G1H2(1),m3h4x2(:,14),heltab2x8(:,:,19))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(28),n2h2(14))
  call Hloop_AV_Q(ntryL,G1H8(25),wf4(:,9),G1H2(1),m3h4x2(:,15),heltab2x8(:,:,20))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(29),n2h2(15))
  call Hloop_AZ_Q(ntryL,G1H8(26),wf4(:,14),G1H2(1),ngZu,m3h4x2(:,16),heltab2x8(:,:,21))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(30),n2h2(16))
call HGT_raise_alpha_OLR(G1H8(27),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(27),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(27),ex5(:),G1H4(6),m3h2x4(:,6),heltab2x8(:,:,22))
  call Hloop_AZ_Q(ntryL,G1H8(29),wf4(:,14),G1H2(1),ngZu,m3h4x2(:,17),heltab2x8(:,:,23))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(31),n2h2(17))
  call Hloop_AZ_Q(ntryL,G1H8(30),wf4(:,14),G1H2(1),ngZu,m3h4x2(:,18),heltab2x8(:,:,24))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(32),n2h2(18))
  call Hloop_QW_A(ntryL,G1H8(31),wf4(:,4),G1H2(1),m3h4x2(:,19),heltab2x8(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(33),n2h2(19))
call HGT_raise_alpha_OLR(G1H8(32),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(32),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(32),ex6(:),G1H4(7),m3h2x4(:,7),heltab2x8(:,:,26))
  call Hloop_QW_A(ntryL,G1H8(34),wf4(:,4),G1H2(1),m3h4x2(:,20),heltab2x8(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(34),n2h2(20))
  call Hloop_QW_A(ntryL,G1H8(35),wf4(:,4),G1H2(1),m3h4x2(:,21),heltab2x8(:,:,28))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(35),n2h2(21))
  call Hloop_AW_Q(ntryL,G1H8(36),wf4(:,5),G1H2(1),m3h4x2(:,22),heltab2x8(:,:,29))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(36),n2h2(22))
call HGT_raise_alpha_OLR(G1H8(37),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(37),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(37),ex5(:),G1H4(8),m3h2x4(:,8),heltab2x8(:,:,30))
  call Hloop_AW_Q(ntryL,G1H8(39),wf4(:,5),G1H2(1),m3h4x2(:,23),heltab2x8(:,:,31))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(37),n2h2(23))
  call Hloop_AW_Q(ntryL,G1H8(40),wf4(:,5),G1H2(1),m3h4x2(:,24),heltab2x8(:,:,32))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(38),n2h2(24))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G2H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G2H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(21),[G2H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(23),[G2H2(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(30),[G2H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G2H2(29)])
  call Hotf_4pt_reduction(G2H2(1),RedSet_4(7),mass4set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),2)
  call HG1shiftOLR(G1H2(2),32,2)
  call Hotf_4pt_reduction(G2H8(1),RedSet_4(8),mass4set(:,1),  & 
G1H8(1),G1H8(2),G1H8(4),G1H8(5),G1H8(6),8)
  call HG1shiftOLR(G1H8(2),19,8)
  call Hotf_4pt_reduction(G2H2(2),RedSet_4(9),mass4set(:,1),  & 
G1H2(6),G1H2(7),G1H2(8),G1H2(9),G1H2(10),2)
  call HG1shiftOLR(G1H2(7),16,2)
  call Hotf_4pt_reduction(G2H8(5),RedSet_4(10),mass4set(:,1),  & 
G1H8(7),G1H8(9),G1H8(10),G1H8(11),G1H8(12),8)
  call HG1shiftOLR(G1H8(9),35,8)
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(11),mass4set(:,1),  & 
G1H2(11),G1H2(12),G1H2(13),G1H2(14),G1H2(15),2)
  call HG1shiftOLR(G1H2(12),32,2)
  call Hotf_4pt_reduction(G2H8(2),RedSet_4(12),mass4set(:,1),  & 
G1H8(14),G1H8(15),G1H8(16),G1H8(17),G1H8(19),8)
  call HG1shiftOLR(G1H8(15),28,8)
  call Hotf_4pt_reduction(G2H8(3),RedSet_4(12),mass4set(:,1),  & 
G1H8(20),G1H8(21),G1H8(22),G1H8(24),G1H8(25),8)
  call HG1shiftOLR(G1H8(21),28,8)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(13),mass4set(:,1),  & 
G1H2(16),G1H2(17),G1H2(18),G1H2(19),G1H2(20),2)
  call HG1shiftOLR(G1H2(17),16,2)
  call Hotf_4pt_reduction(G2H8(4),RedSet_4(14),mass4set(:,1),  & 
G1H8(26),G1H8(27),G1H8(29),G1H8(30),G1H8(31),8)
  call HG1shiftOLR(G1H8(27),44,8)
  call Hotf_4pt_reduction(G2H8(6),RedSet_4(14),mass4set(:,1),  & 
G1H8(32),G1H8(34),G1H8(35),G1H8(36),G1H8(37),8)
  call HG1shiftOLR(G1H8(34),44,8)
  call Hotf_4pt_reduction(G2H2(7),RedSet_4(15),mass4set(:,1),  & 
G1H2(21),G1H2(22),G1H2(23),G1H2(24),G1H2(25),2)
  call HG1shiftOLR(G1H2(22),32,2)
  call Hotf_4pt_reduction(G2H2(8),RedSet_4(16),mass4set(:,1),  & 
G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(27),16,2)
  call Hotf_4pt_reduction(G2H2(9),RedSet_4(17),mass4set(:,1),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),2)
  call HG1shiftOLR(G1H2(32),16,2)
  call Hotf_4pt_reduction(G2H2(10),RedSet_4(18),mass4set(:,1),  & 
G1H2(36),G1H2(37),G1H2(38),G1H2(39),G1H2(40),2)
  call HG1shiftOLR(G1H2(37),32,2)
  call Hotf_4pt_reduction(G2H2(11),RedSet_4(19),mass4set(:,1),  & 
G1H2(41),G1H2(42),G1H2(43),G1H2(44),G1H2(45),2)
  call HG1shiftOLR(G1H2(42),16,2)
  call Hotf_4pt_reduction(G2H8(7),RedSet_4(20),mass4set(:,1),  & 
G1H8(39),G1H8(40),G1H8(41),G1H8(42),G1H8(43),8)
  call HG1shiftOLR(G1H8(40),41,8)
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(21),mass4set(:,1),  & 
G1H2(46),G1H2(47),G1H2(48),G1H2(49),G1H2(50),2)
  call HG1shiftOLR(G1H2(47),32,2)
  call Hotf_4pt_reduction(G2H2(13),RedSet_4(22),mass4set(:,1),  & 
G1H2(51),G1H2(52),G1H2(53),G1H2(54),G1H2(55),2)
  call HG1shiftOLR(G1H2(52),32,2)
  call Hotf_4pt_reduction(G2H8(8),RedSet_4(23),mass4set(:,1),  & 
G1H8(44),G1H8(45),G1H8(46),G1H8(47),G1H8(48),8)
  call HG1shiftOLR(G1H8(45),22,8)
  call Hotf_4pt_reduction(G2H2(14),RedSet_4(24),mass4set(:,1),  & 
G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),2)
  call HG1shiftOLR(G1H2(57),16,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(15),ex6(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(17),ex6(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(21),ex6(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(23),ex6(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(24),ex5(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(26),ex5(:),G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(30),ex5(:),G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(32),ex5(:),G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(33),ex6(:),G2tensor(9),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(35),ex6(:),G2tensor(10),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(36),ex5(:),G2tensor(11),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(38),ex5(:),G2tensor(12),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hloop_VA_Q(ntryL,G1H2(1),ex6(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(13),n2h1(1))
  call Hloop_VA_Q(ntryL,G1H2(2),ex6(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(14),n2h1(2))
  call Hloop_VA_Q(ntryL,G1H2(5),ex6(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(15),n2h1(3))
  call Hloop_VQ_A(ntryL,G1H8(1),wf8(:,8),G1H1(1),m3h8x1(:,1),heltab2x8(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(16),n2h1(4))
  call Hloop_VQ_A(ntryL,G1H8(2),wf8(:,8),G1H1(1),m3h8x1(:,2),heltab2x8(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),19,0,G2tensor(17),n2h1(5))
  call Hloop_VQ_A(ntryL,G1H8(6),wf8(:,8),G1H1(1),m3h8x1(:,3),heltab2x8(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(18),n2h1(6))
  call Hloop_VQ_A(ntryL,G1H2(6),ex5(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(19),n2h1(7))
  call Hloop_VQ_A(ntryL,G1H2(7),ex5(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(20),n2h1(8))
  call Hloop_VQ_A(ntryL,G1H2(10),ex5(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(21),n2h1(9))
  call Hloop_VA_Q(ntryL,G1H8(7),wf8(:,2),G1H1(1),m3h8x1(:,4),heltab2x8(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(22),n2h1(10))
  call Hloop_VA_Q(ntryL,G1H8(9),wf8(:,2),G1H1(1),m3h8x1(:,5),heltab2x8(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),35,0,G2tensor(23),n2h1(11))
  call Hloop_VA_Q(ntryL,G1H8(12),wf8(:,2),G1H1(1),m3h8x1(:,6),heltab2x8(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(24),n2h1(12))
  call Hloop_VA_Q(ntryL,G1H2(11),ex6(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(25),n2h1(13))
  call Hloop_VA_Q(ntryL,G1H2(12),ex6(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(26),n2h1(14))
  call Hloop_VA_Q(ntryL,G1H2(15),ex6(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(27),n2h1(15))
  call Hloop_VQ_A(ntryL,G1H8(14),wf8(:,10),G1H1(1),m3h8x1(:,7),heltab2x8(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(28),n2h1(16))
  call Hloop_VQ_A(ntryL,G1H8(15),wf8(:,10),G1H1(1),m3h8x1(:,8),heltab2x8(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),28,0,G2tensor(29),n2h1(17))
  call Hloop_VQ_A(ntryL,G1H8(19),wf8(:,10),G1H1(1),m3h8x1(:,9),heltab2x8(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(30),n2h1(18))
  call Hloop_VQ_A(ntryL,G1H8(20),wf8(:,12),G1H1(1),m3h8x1(:,10),heltab2x8(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(31),n2h1(19))
  call Hloop_VQ_A(ntryL,G1H8(21),wf8(:,12),G1H1(1),m3h8x1(:,11),heltab2x8(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),28,0,G2tensor(32),n2h1(20))
  call Hloop_VQ_A(ntryL,G1H8(25),wf8(:,12),G1H1(1),m3h8x1(:,12),heltab2x8(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(33),n2h1(21))
  call Hloop_VQ_A(ntryL,G1H2(16),ex5(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(34),n2h1(22))
  call Hloop_VQ_A(ntryL,G1H2(17),ex5(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(35),n2h1(23))
  call Hloop_VQ_A(ntryL,G1H2(20),ex5(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(36),n2h1(24))
  call Hloop_VA_Q(ntryL,G1H8(26),wf8(:,4),G1H1(1),m3h8x1(:,13),heltab2x8(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(37),n2h1(25))
  call Hloop_VA_Q(ntryL,G1H8(27),wf8(:,4),G1H1(1),m3h8x1(:,14),heltab2x8(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),44,0,G2tensor(38),n2h1(26))
  call Hloop_VA_Q(ntryL,G1H8(31),wf8(:,4),G1H1(1),m3h8x1(:,15),heltab2x8(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(39),n2h1(27))
  call Hloop_VA_Q(ntryL,G1H8(32),wf8(:,6),G1H1(1),m3h8x1(:,16),heltab2x8(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(40),n2h1(28))
  call Hloop_VA_Q(ntryL,G1H8(34),wf8(:,6),G1H1(1),m3h8x1(:,17),heltab2x8(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),44,0,G2tensor(41),n2h1(29))
  call Hloop_VA_Q(ntryL,G1H8(37),wf8(:,6),G1H1(1),m3h8x1(:,18),heltab2x8(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(42),n2h1(30))
  call Hloop_VA_Q(ntryL,G1H2(21),ex6(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(43),n2h1(31))
  call Hloop_VA_Q(ntryL,G1H2(22),ex6(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(44),n2h1(32))
  call Hloop_VA_Q(ntryL,G1H2(25),ex6(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(45),n2h1(33))
  call Hloop_VQ_A(ntryL,G1H2(26),ex5(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(46),n2h1(34))
  call Hloop_VQ_A(ntryL,G1H2(27),ex5(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(47),n2h1(35))
  call Hloop_VQ_A(ntryL,G1H2(30),ex5(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(48),n2h1(36))
  call Hloop_VQ_A(ntryL,G1H2(31),ex5(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(49),n2h1(37))
  call Hloop_VQ_A(ntryL,G1H2(32),ex5(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(50),n2h1(38))
  call Hloop_VQ_A(ntryL,G1H2(35),ex5(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(51),n2h1(39))
  call Hloop_VA_Q(ntryL,G1H2(36),ex6(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(52),n2h1(40))
  call Hloop_VA_Q(ntryL,G1H2(37),ex6(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(53),n2h1(41))
  call Hloop_VA_Q(ntryL,G1H2(40),ex6(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(54),n2h1(42))
  call Hloop_VQ_A(ntryL,G1H2(41),ex5(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(55),n2h1(43))
  call Hloop_VQ_A(ntryL,G1H2(42),ex5(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(56),n2h1(44))
  call Hloop_VQ_A(ntryL,G1H2(45),ex5(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(57),n2h1(45))
  call Hloop_VA_Q(ntryL,G1H8(39),wf8(:,42),G1H1(1),m3h8x1(:,19),heltab2x8(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(58),n2h1(46))
  call Hloop_VA_Q(ntryL,G1H8(40),wf8(:,42),G1H1(1),m3h8x1(:,20),heltab2x8(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),41,0,G2tensor(59),n2h1(47))
  call Hloop_VA_Q(ntryL,G1H8(43),wf8(:,42),G1H1(1),m3h8x1(:,21),heltab2x8(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(60),n2h1(48))
  call Hloop_VA_Q(ntryL,G1H2(46),ex6(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(61),n2h1(49))
  call Hloop_VA_Q(ntryL,G1H2(47),ex6(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(62),n2h1(50))
  call Hloop_VA_Q(ntryL,G1H2(50),ex6(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(63),n2h1(51))
  call Hloop_VA_Q(ntryL,G1H2(51),ex6(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(64),n2h1(52))
  call Hloop_VA_Q(ntryL,G1H2(52),ex6(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(65),n2h1(53))
  call Hloop_VA_Q(ntryL,G1H2(55),ex6(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(66),n2h1(54))
  call Hloop_VQ_A(ntryL,G1H8(44),wf8(:,44),G1H1(1),m3h8x1(:,22),heltab2x8(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(67),n2h1(55))
  call Hloop_VQ_A(ntryL,G1H8(45),wf8(:,44),G1H1(1),m3h8x1(:,23),heltab2x8(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),22,0,G2tensor(68),n2h1(56))
  call Hloop_VQ_A(ntryL,G1H8(48),wf8(:,44),G1H1(1),m3h8x1(:,24),heltab2x8(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(69),n2h1(57))
  call Hloop_VQ_A(ntryL,G1H2(56),ex5(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(70),n2h1(58))
  call Hloop_VQ_A(ntryL,G1H2(57),ex5(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(71),n2h1(59))
  call Hloop_VQ_A(ntryL,G1H2(60),ex5(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(72),n2h1(60))
  call ol_merge_tensors(G2tensor(31),[G2tensor(28)])
  call ol_merge_tensors(G2tensor(40),[G2tensor(37)])
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5))
  call G_TensorShift(G1tensor(2),32)
  call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(2),mass4set(:,1),  & 
G1tensor(6),G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10))
  call G_TensorShift(G1tensor(7),32)
  call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(3),mass4set(:,1),  & 
G1tensor(11),G1tensor(12),G1tensor(13),G1tensor(14),G1tensor(15))
  call G_TensorShift(G1tensor(12),16)
  call Hotf_4pt_reduction_last(G2tensor(7),RedSet_4(4),mass4set(:,1),  & 
G1tensor(16),G1tensor(17),G1tensor(18),G1tensor(19),G1tensor(20))
  call G_TensorShift(G1tensor(17),16)
  call Hotf_4pt_reduction_last(G2tensor(9),RedSet_4(5),mass4set(:,1),  & 
G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24),G1tensor(25))
  call G_TensorShift(G1tensor(22),32)
  call Hotf_4pt_reduction_last(G2tensor(11),RedSet_4(6),mass4set(:,1),  & 
G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(27),16)
  call Hotf_4pt_reduction_last(G2tensor(13),RedSet_4(7),mass4set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35))
  call G_TensorShift(G1tensor(32),32)
  call Hotf_4pt_reduction_last(G2tensor(16),RedSet_4(8),mass4set(:,1),  & 
G1tensor(36),G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40))
  call G_TensorShift(G1tensor(37),19)
  call Hotf_4pt_reduction_last(G2tensor(19),RedSet_4(9),mass4set(:,1),  & 
G1tensor(41),G1tensor(42),G1tensor(43),G1tensor(44),G1tensor(45))
  call G_TensorShift(G1tensor(42),16)
  call Hotf_4pt_reduction_last(G2tensor(22),RedSet_4(10),mass4set(:,1),  & 
G1tensor(46),G1tensor(47),G1tensor(48),G1tensor(49),G1tensor(50))
  call G_TensorShift(G1tensor(47),35)
  call Hotf_4pt_reduction_last(G2tensor(25),RedSet_4(11),mass4set(:,1),  & 
G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54),G1tensor(55))
  call G_TensorShift(G1tensor(52),32)
  call Hotf_4pt_reduction_last(G2tensor(31),RedSet_4(12),mass4set(:,1),  & 
G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(57),28)
  call Hotf_4pt_reduction_last(G2tensor(34),RedSet_4(13),mass4set(:,1),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65))
  call G_TensorShift(G1tensor(62),16)
  call Hotf_4pt_reduction_last(G2tensor(40),RedSet_4(14),mass4set(:,1),  & 
G1tensor(66),G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70))
  call G_TensorShift(G1tensor(67),44)
  call Hotf_4pt_reduction_last(G2tensor(43),RedSet_4(15),mass4set(:,1),  & 
G1tensor(71),G1tensor(72),G1tensor(73),G1tensor(74),G1tensor(75))
  call G_TensorShift(G1tensor(72),32)
  call Hotf_4pt_reduction_last(G2tensor(46),RedSet_4(16),mass4set(:,1),  & 
G1tensor(76),G1tensor(77),G1tensor(78),G1tensor(79),G1tensor(80))
  call G_TensorShift(G1tensor(77),16)
  call Hotf_4pt_reduction_last(G2tensor(49),RedSet_4(17),mass4set(:,1),  & 
G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84),G1tensor(85))
  call G_TensorShift(G1tensor(82),16)
  call Hotf_4pt_reduction_last(G2tensor(52),RedSet_4(18),mass4set(:,1),  & 
G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(87),32)
  call Hotf_4pt_reduction_last(G2tensor(55),RedSet_4(19),mass4set(:,1),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95))
  call G_TensorShift(G1tensor(92),16)
  call Hotf_4pt_reduction_last(G2tensor(58),RedSet_4(20),mass4set(:,1),  & 
G1tensor(96),G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100))
  call G_TensorShift(G1tensor(97),41)
  call Hotf_4pt_reduction_last(G2tensor(61),RedSet_4(21),mass4set(:,1),  & 
G1tensor(101),G1tensor(102),G1tensor(103),G1tensor(104),G1tensor(105))
  call G_TensorShift(G1tensor(102),32)
  call Hotf_4pt_reduction_last(G2tensor(64),RedSet_4(22),mass4set(:,1),  & 
G1tensor(106),G1tensor(107),G1tensor(108),G1tensor(109),G1tensor(110))
  call G_TensorShift(G1tensor(107),32)
  call Hotf_4pt_reduction_last(G2tensor(67),RedSet_4(23),mass4set(:,1),  & 
G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114),G1tensor(115))
  call G_TensorShift(G1tensor(112),22)
  call Hotf_4pt_reduction_last(G2tensor(70),RedSet_4(24),mass4set(:,1),  & 
G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(117),16)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(1),mass4set(:,1),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(6),RedSet_4(2),mass4set(:,1),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(3),mass4set(:,1),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(16),RedSet_4(4),mass4set(:,1),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(21),RedSet_4(5),mass4set(:,1),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(6),mass4set(:,1),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(7),mass4set(:,1),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(36),RedSet_4(8),mass4set(:,1),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(9),mass4set(:,1),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(46),RedSet_4(10),mass4set(:,1),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(11),mass4set(:,1),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(56),RedSet_4(12),mass4set(:,1),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(13),mass4set(:,1),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(14),mass4set(:,1),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call Hotf_4pt_reduction_last(G1tensor(71),RedSet_4(15),mass4set(:,1),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
  call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(16),mass4set(:,1),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
  call Hotf_4pt_reduction_last(G1tensor(81),RedSet_4(17),mass4set(:,1),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
  call Hotf_4pt_reduction_last(G1tensor(86),RedSet_4(18),mass4set(:,1),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
  call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(19),mass4set(:,1),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
  call Hotf_4pt_reduction_last(G1tensor(96),RedSet_4(20),mass4set(:,1),  & 
G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100))
  call Hotf_4pt_reduction_last(G1tensor(101),RedSet_4(21),mass4set(:,1),  & 
G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104),G0tensor(105))
  call Hotf_4pt_reduction_last(G1tensor(106),RedSet_4(22),mass4set(:,1),  & 
G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110))
  call Hotf_4pt_reduction_last(G1tensor(111),RedSet_4(23),mass4set(:,1),  & 
G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114),G0tensor(115))
  call Hotf_4pt_reduction_last(G1tensor(116),RedSet_4(24),mass4set(:,1),  & 
G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119),G0tensor(120))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  call ol_merge_tensors(T0sum(12),[G0tensor(56)])
  call ol_merge_tensors(T0sum(13),[G0tensor(61)])
  call ol_merge_tensors(T0sum(14),[G0tensor(66)])
  call ol_merge_tensors(T0sum(15),[G0tensor(71)])
  call ol_merge_tensors(T0sum(16),[G0tensor(76)])
  call ol_merge_tensors(T0sum(17),[G0tensor(81)])
  call ol_merge_tensors(T0sum(18),[G0tensor(86)])
  call ol_merge_tensors(T0sum(19),[G0tensor(91)])
  call ol_merge_tensors(T0sum(20),[G0tensor(96)])
  call ol_merge_tensors(T0sum(21),[G0tensor(101)])
  call ol_merge_tensors(T0sum(22),[G0tensor(106)])
  call ol_merge_tensors(T0sum(23),[G0tensor(111)])
  call ol_merge_tensors(T0sum(24),[G0tensor(116)])
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(335)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(71),h0tab(:,71),[79,16,32],[0,0,0],3,1,wf32(:,1))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,1),G0H4(1),m3h32x4(:,1),heltab2x128(:,:,71))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(9),n2h4(33))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(337)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(72),h0tab(:,72),[79,16,32],[0,0,0],3,1,wf32(:,2))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,2),G0H4(1),ngZu,m3h32x4(:,2),heltab2x128(:,:,72))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(10),n2h4(34))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(466)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(73),h0tab(:,73),[80,12,35],[0,0,0],3,3,wf4(:,12),wf4(:,9),wf8(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,12),G0H32(1),m3h4x32(:,11),heltab2x128(:,:,73))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(1),n2h32(11))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(467)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(74),h0tab(:,74),[80,12,35],[0,0,0],3,3,wf4(:,12),wf4(:,14),wf8(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,12),G0H32(1),m3h4x32(:,12),heltab2x128(:,:,74))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(2),n2h32(12))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(468)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(75),h0tab(:,75),[80,3,44],[0,0,0],3,3,wf4(:,12),wf4(:,11),wf8(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,12),G0H32(1),m3h4x32(:,13),heltab2x128(:,:,75))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(3),n2h32(13))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(469)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(76),h0tab(:,76),[80,3,44],[0,0,0],3,3,wf4(:,12),wf4(:,11),wf8(:,6))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,12),G0H32(1),m3h4x32(:,14),heltab2x128(:,:,76))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(4),n2h32(14))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(192)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(77),h0tab(:,77),[83,12,32],[0,0,0],3,2,wf16(:,75),wf4(:,9))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,75),G0H8(1),m3h16x8(:,1),heltab2x128(:,:,77))
  call Hloop_Q_A(ntryL,G0H8(1),83,0,G1H8(1),n2h8(19))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(193)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(78),h0tab(:,78),[83,12,32],[0,0,0],3,2,wf16(:,75),wf4(:,14))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,75),G0H8(1),m3h16x8(:,2),heltab2x128(:,:,78))
  call Hloop_Q_A(ntryL,G0H8(1),83,0,G1H8(2),n2h8(20))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(79),h0tab(:,79),[92,3,32],[0,0,0],3,2,wf16(:,76),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,76),G0H8(1),m3h16x8(:,3),heltab2x128(:,:,79))
  call Hloop_Q_A(ntryL,G0H8(1),92,0,G1H8(6),n2h8(21))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(198)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(80),h0tab(:,80),[92,3,32],[0,0,0],3,2,wf16(:,77),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,77),G0H8(1),m3h16x8(:,4),heltab2x128(:,:,80))
  call Hloop_Q_A(ntryL,G0H8(1),92,0,G1H8(7),n2h8(22))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(472)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(81),h0tab(:,81),[96,12,19],[0,0,0],3,3,wf4(:,16),wf4(:,9),wf8(:,8))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(1),m3h4x32(:,15),heltab2x128(:,:,81))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(5),n2h32(15))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(473)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(82),h0tab(:,82),[96,12,19],[0,0,0],3,3,wf4(:,16),wf4(:,14),wf8(:,8))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(1),m3h4x32(:,16),heltab2x128(:,:,82))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(6),n2h32(16))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(474)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(83),h0tab(:,83),[96,3,28],[0,0,0],3,3,wf4(:,16),wf4(:,11),wf8(:,10))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(1),m3h4x32(:,17),heltab2x128(:,:,83))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(7),n2h32(17))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(475)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(84),h0tab(:,84),[96,3,28],[0,0,0],3,3,wf4(:,16),wf4(:,11),wf8(:,12))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(1),m3h4x32(:,18),heltab2x128(:,:,84))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(8),n2h32(18))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(201)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(85),h0tab(:,85),[99,12,16],[0,0,0],3,2,wf16(:,81),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,81),G0H8(1),m3h16x8(:,5),heltab2x128(:,:,85))
  call Hloop_A_Q(ntryL,G0H8(1),99,0,G1H8(9),n2h8(23))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(202)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(86),h0tab(:,86),[99,12,16],[0,0,0],3,2,wf16(:,81),wf4(:,14))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,81),G0H8(1),m3h16x8(:,6),heltab2x128(:,:,86))
  call Hloop_A_Q(ntryL,G0H8(1),99,0,G1H8(12),n2h8(24))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(205)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(87),h0tab(:,87),[108,3,16],[0,0,0],3,2,wf16(:,82),wf4(:,11))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,82),G0H8(1),m3h16x8(:,7),heltab2x128(:,:,87))
  call Hloop_A_Q(ntryL,G0H8(1),108,0,G1H8(14),n2h8(25))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(207)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(88),h0tab(:,88),[108,3,16],[0,0,0],3,2,wf16(:,83),wf4(:,11))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,83),G0H8(1),m3h16x8(:,8),heltab2x128(:,:,88))
  call Hloop_A_Q(ntryL,G0H8(1),108,0,G1H8(15),n2h8(26))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(89),h0tab(:,89),[64,19,44],[0,0,0],3,2,wf8(:,8),wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,49),heltab2x128(:,:,89))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(1),n2h64(49))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(90),h0tab(:,90),[64,19,44],[0,0,0],3,2,wf8(:,8),wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,50),heltab2x128(:,:,90))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(2),n2h64(50))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(478)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(91),h0tab(:,91),[83,12,32],[0,0,0],3,2,wf16(:,143),wf4(:,9))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,143),G0H8(1),m3h16x8(:,9),heltab2x128(:,:,91))
  call Hloop_Q_A(ntryL,G0H8(1),83,0,G1H8(19),n2h8(27))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(479)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(92),h0tab(:,92),[83,12,32],[0,0,0],3,2,wf16(:,143),wf4(:,14))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,143),G0H8(1),m3h16x8(:,10),heltab2x128(:,:,92))
  call Hloop_Q_A(ntryL,G0H8(1),83,0,G1H8(20),n2h8(28))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(340)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(93),h0tab(:,93),[64,31,32],[0,0,0],3,1,wf32(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,51),heltab2x128(:,:,93))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(3),n2h64(51))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(342)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(94),h0tab(:,94),[64,31,32],[0,0,0],3,1,wf32(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,52),heltab2x128(:,:,94))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(4),n2h64(52))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(95),h0tab(:,95),[64,28,35],[0,0,0],3,2,wf8(:,10),wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,53),heltab2x128(:,:,95))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(5),n2h64(53))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(96),h0tab(:,96),[64,28,35],[0,0,0],3,2,wf8(:,12),wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,54),heltab2x128(:,:,96))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(6),n2h64(54))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(480)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(97),h0tab(:,97),[99,12,16],[0,0,0],3,2,wf16(:,142),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,142),G0H8(1),m3h16x8(:,11),heltab2x128(:,:,97))
  call Hloop_A_Q(ntryL,G0H8(1),99,0,G1H8(21),n2h8(29))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(481)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(98),h0tab(:,98),[99,12,16],[0,0,0],3,2,wf16(:,142),wf4(:,14))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,142),G0H8(1),m3h16x8(:,12),heltab2x128(:,:,98))
  call Hloop_A_Q(ntryL,G0H8(1),99,0,G1H8(25),n2h8(30))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(345)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(99),h0tab(:,99),[64,16,47],[0,0,0],3,1,wf32(:,8))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,55),heltab2x128(:,:,99))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(7),n2h64(55))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(347)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(100),h0tab(:,100),[64,16,47],[0,0,0],3,1,wf32(:,10))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,56),heltab2x128(:,:,100))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(8),n2h64(56))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(482)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(101),h0tab(:,101),[92,3,32],[0,0,0],3,2,wf16(:,144),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,144),G0H8(1),m3h16x8(:,13),heltab2x128(:,:,101))
  call Hloop_Q_A(ntryL,G0H8(1),92,0,G1H8(26),n2h8(31))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(483)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(102),h0tab(:,102),[92,3,32],[0,0,0],3,2,wf16(:,145),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,145),G0H8(1),m3h16x8(:,14),heltab2x128(:,:,102))
  call Hloop_Q_A(ntryL,G0H8(1),92,0,G1H8(27),n2h8(32))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(349)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(103),h0tab(:,103),[64,31,32],[0,0,0],3,1,wf32(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,57),heltab2x128(:,:,103))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(9),n2h64(57))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(351)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(104),h0tab(:,104),[64,31,32],[0,0,0],3,1,wf32(:,14))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,58),heltab2x128(:,:,104))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(10),n2h64(58))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(484)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(105),h0tab(:,105),[108,3,16],[0,0,0],3,2,wf16(:,138),wf4(:,11))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,138),G0H8(1),m3h16x8(:,15),heltab2x128(:,:,105))
  call Hloop_A_Q(ntryL,G0H8(1),108,0,G1H8(31),n2h8(33))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(485)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(106),h0tab(:,106),[108,3,16],[0,0,0],3,2,wf16(:,140),wf4(:,11))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,140),G0H8(1),m3h16x8(:,16),heltab2x128(:,:,106))
  call Hloop_A_Q(ntryL,G0H8(1),108,0,G1H8(32),n2h8(34))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(353)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(107),h0tab(:,107),[64,16,47],[0,0,0],3,1,wf32(:,16))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,59),heltab2x128(:,:,107))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(11),n2h64(59))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(355)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(108),h0tab(:,108),[64,16,47],[0,0,0],3,1,wf32(:,18))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,60),heltab2x128(:,:,108))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(12),n2h64(60))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(357)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(109),h0tab(:,109),[79,16,32],[0,0,0],3,1,wf32(:,19))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,19),G0H4(1),m3h32x4(:,3),heltab2x128(:,:,109))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(11),n2h4(35))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(358)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(110),h0tab(:,110),[79,16,32],[0,0,0],3,1,wf32(:,21))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,21),G0H4(1),ngZu,m3h32x4(:,4),heltab2x128(:,:,110))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(12),n2h4(36))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(111),h0tab(:,111),[76,19,32],[0,0,0],3,2,wf8(:,25),wf8(:,8))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,25),G0H16(1),m3h8x16(:,13),heltab2x128(:,:,111))
  call Hloop_A_Q(ntryL,G0H16(1),76,0,G1H16(4),n2h16(33))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(112),h0tab(:,112),[76,19,32],[0,0,0],3,2,wf8(:,27),wf8(:,8))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,27),G0H16(1),ngZu,m3h8x16(:,14),heltab2x128(:,:,112))
  call Hloop_A_Q(ntryL,G0H16(1),76,0,G1H16(3),n2h16(34))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(113),h0tab(:,113),[76,16,35],[0,0,0],3,2,wf8(:,25),wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,25),G0H16(1),m3h8x16(:,15),heltab2x128(:,:,113))
  call Hloop_A_Q(ntryL,G0H16(1),76,0,G1H16(9),n2h16(35))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(114),h0tab(:,114),[76,16,35],[0,0,0],3,2,wf8(:,27),wf8(:,2))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,27),G0H16(1),ngZu,m3h8x16(:,16),heltab2x128(:,:,114))
  call Hloop_A_Q(ntryL,G0H16(1),76,0,G1H16(10),n2h16(36))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(486)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(115),h0tab(:,115),[92,3,32],[0,0,0],3,2,wf16(:,148),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,148),G0H8(1),m3h16x8(:,17),heltab2x128(:,:,115))
  call Hloop_Q_A(ntryL,G0H8(1),92,0,G1H8(34),n2h8(35))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(487)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(116),h0tab(:,116),[92,3,32],[0,0,0],3,2,wf16(:,149),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,149),G0H8(1),m3h16x8(:,18),heltab2x128(:,:,116))
  call Hloop_Q_A(ntryL,G0H8(1),92,0,G1H8(37),n2h8(36))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(488)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(117),h0tab(:,117),[108,3,16],[0,0,0],3,2,wf16(:,146),wf4(:,11))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,146),G0H8(1),m3h16x8(:,19),heltab2x128(:,:,117))
  call Hloop_A_Q(ntryL,G0H8(1),108,0,G1H8(39),n2h8(37))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(489)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(118),h0tab(:,118),[108,3,16],[0,0,0],3,2,wf16(:,147),wf4(:,11))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,147),G0H8(1),m3h16x8(:,20),heltab2x128(:,:,118))
  call Hloop_A_Q(ntryL,G0H8(1),108,0,G1H8(40),n2h8(38))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(361)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(119),h0tab(:,119),[79,16,32],[0,0,0],3,1,wf32(:,22))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,22),G0H4(1),m3h32x4(:,5),heltab2x128(:,:,119))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(13),n2h4(37))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(362)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(120),h0tab(:,120),[79,16,32],[0,0,0],3,1,wf32(:,24))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,24),G0H4(1),ngZu,m3h32x4(:,6),heltab2x128(:,:,120))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(14),n2h4(38))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(364)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(121),h0tab(:,121),[79,16,32],[0,0,0],3,1,wf32(:,25))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,25),G0H4(1),m3h32x4(:,7),heltab2x128(:,:,121))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(15),n2h4(39))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(365)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(122),h0tab(:,122),[79,16,32],[0,0,0],3,1,wf32(:,27))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,27),G0H4(1),ngZu,m3h32x4(:,8),heltab2x128(:,:,122))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(16),n2h4(40))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(123),h0tab(:,123),[76,19,32],[0,0,0],3,2,wf8(:,28),wf8(:,8))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,28),G0H16(1),m3h8x16(:,17),heltab2x128(:,:,123))
  call Hloop_A_Q(ntryL,G0H16(1),76,0,G1H16(6),n2h16(37))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(124),h0tab(:,124),[76,19,32],[0,0,0],3,2,wf8(:,30),wf8(:,8))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,30),G0H16(1),ngZu,m3h8x16(:,18),heltab2x128(:,:,124))
  call Hloop_A_Q(ntryL,G0H16(1),76,0,G1H16(8),n2h16(38))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(125),h0tab(:,125),[76,16,35],[0,0,0],3,2,wf8(:,28),wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,28),G0H16(1),m3h8x16(:,19),heltab2x128(:,:,125))
  call Hloop_A_Q(ntryL,G0H16(1),76,0,G1H16(5),n2h16(39))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(126),h0tab(:,126),[76,16,35],[0,0,0],3,2,wf8(:,30),wf8(:,2))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,30),G0H16(1),ngZu,m3h8x16(:,20),heltab2x128(:,:,126))
  call Hloop_A_Q(ntryL,G0H16(1),76,0,G1H16(2),n2h16(40))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(492)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(127),h0tab(:,127),[92,3,32],[0,0,0],3,2,wf16(:,152),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,152),G0H8(1),m3h16x8(:,21),heltab2x128(:,:,127))
  call Hloop_Q_A(ntryL,G0H8(1),92,0,G1H8(43),n2h8(39))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(493)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(128),h0tab(:,128),[92,3,32],[0,0,0],3,2,wf16(:,153),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,153),G0H8(1),m3h16x8(:,22),heltab2x128(:,:,128))
  call Hloop_Q_A(ntryL,G0H8(1),92,0,G1H8(44),n2h8(40))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(494)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(129),h0tab(:,129),[108,3,16],[0,0,0],3,2,wf16(:,150),wf4(:,11))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,150),G0H8(1),m3h16x8(:,23),heltab2x128(:,:,129))
  call Hloop_A_Q(ntryL,G0H8(1),108,0,G1H8(45),n2h8(41))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(495)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(130),h0tab(:,130),[108,3,16],[0,0,0],3,2,wf16(:,151),wf4(:,11))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,151),G0H8(1),m3h16x8(:,24),heltab2x128(:,:,130))
  call Hloop_A_Q(ntryL,G0H8(1),108,0,G1H8(48),n2h8(42))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(368)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(131),h0tab(:,131),[79,16,32],[0,0,0],3,1,wf32(:,28))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,28),G0H4(1),m3h32x4(:,9),heltab2x128(:,:,131))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(17),n2h4(41))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(369)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(132),h0tab(:,132),[79,16,32],[0,0,0],3,1,wf32(:,30))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,30),G0H4(1),ngZu,m3h32x4(:,10),heltab2x128(:,:,132))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(18),n2h4(42))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(498)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(133),h0tab(:,133),[80,15,32],[0,0,0],3,2,wf4(:,12),wf16(:,27))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,12),G0H32(1),m3h4x32(:,19),heltab2x128(:,:,133))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(9),n2h32(19))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(499)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(134),h0tab(:,134),[80,15,32],[0,0,0],3,2,wf4(:,12),wf16(:,154))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,12),G0H32(1),m3h4x32(:,20),heltab2x128(:,:,134))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(10),n2h32(20))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(500)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(135),h0tab(:,135),[80,15,32],[0,0,0],3,2,wf4(:,12),wf16(:,29))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,12),G0H32(1),m3h4x32(:,21),heltab2x128(:,:,135))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(11),n2h32(21))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(501)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(136),h0tab(:,136),[80,15,32],[0,0,0],3,2,wf4(:,12),wf16(:,155))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,12),G0H32(1),m3h4x32(:,22),heltab2x128(:,:,136))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(12),n2h32(22))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(502)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(137),h0tab(:,137),[96,15,16],[0,0,0],3,2,wf4(:,16),wf16(:,27))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(1),m3h4x32(:,23),heltab2x128(:,:,137))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(13),n2h32(23))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(503)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(138),h0tab(:,138),[96,15,16],[0,0,0],3,2,wf4(:,16),wf16(:,154))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(1),m3h4x32(:,24),heltab2x128(:,:,138))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(14),n2h32(24))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(504)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(139),h0tab(:,139),[96,15,16],[0,0,0],3,2,wf4(:,16),wf16(:,29))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(1),m3h4x32(:,25),heltab2x128(:,:,139))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(15),n2h32(25))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(505)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(140),h0tab(:,140),[96,15,16],[0,0,0],3,2,wf4(:,16),wf16(:,155))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(1),m3h4x32(:,26),heltab2x128(:,:,140))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(16),n2h32(26))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(370)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(141),h0tab(:,141),[64,31,32],[0,0,0],3,1,wf32(:,32))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,61),heltab2x128(:,:,141))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(13),n2h64(61))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(371)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(142),h0tab(:,142),[64,31,32],[0,0,0],3,1,wf32(:,34))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,62),heltab2x128(:,:,142))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(14),n2h64(62))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(372)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(143),h0tab(:,143),[64,16,47],[0,0,0],3,1,wf32(:,36))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,63),heltab2x128(:,:,143))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(15),n2h64(63))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(373)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(144),h0tab(:,144),[64,16,47],[0,0,0],3,1,wf32(:,38))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,64),heltab2x128(:,:,144))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(16),n2h64(64))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(375)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(145),h0tab(:,145),[79,16,32],[0,0,0],3,1,wf32(:,39))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,39),G0H4(1),m3h32x4(:,11),heltab2x128(:,:,145))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(19),n2h4(43))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(376)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(146),h0tab(:,146),[79,16,32],[0,0,0],3,1,wf32(:,41))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,41),G0H4(1),ngZu,m3h32x4(:,12),heltab2x128(:,:,146))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(20),n2h4(44))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(377)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(147),h0tab(:,147),[64,31,32],[0,0,0],3,1,wf32(:,43))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,65),heltab2x128(:,:,147))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(17),n2h64(65))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(378)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(148),h0tab(:,148),[64,31,32],[0,0,0],3,1,wf32(:,45))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,66),heltab2x128(:,:,148))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(18),n2h64(66))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(379)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(149),h0tab(:,149),[64,16,47],[0,0,0],3,1,wf32(:,47))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,67),heltab2x128(:,:,149))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(19),n2h64(67))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(380)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(150),h0tab(:,150),[64,16,47],[0,0,0],3,1,wf32(:,49))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,68),heltab2x128(:,:,150))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(20),n2h64(68))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(382)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(151),h0tab(:,151),[79,16,32],[0,0,0],3,1,wf32(:,50))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,50),G0H4(1),m3h32x4(:,13),heltab2x128(:,:,151))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(21),n2h4(45))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(383)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(152),h0tab(:,152),[79,16,32],[0,0,0],3,1,wf32(:,52))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,52),G0H4(1),ngZu,m3h32x4(:,14),heltab2x128(:,:,152))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(22),n2h4(46))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(506)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(153),h0tab(:,153),[80,6,41],[0,0,0],3,3,wf4(:,12),wf4(:,5),wf8(:,42))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,12),G0H32(1),m3h4x32(:,27),heltab2x128(:,:,153))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(17),n2h32(27))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(210)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(154),h0tab(:,154),[80,15,32],[0,0,0],3,2,wf4(:,12),wf16(:,36))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,12),G0H32(1),m3h4x32(:,28),heltab2x128(:,:,154))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(18),n2h32(28))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(213)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(155),h0tab(:,155),[80,15,32],[0,0,0],3,2,wf4(:,12),wf16(:,107))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,12),G0H32(1),m3h4x32(:,29),heltab2x128(:,:,155))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(19),n2h32(29))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(156),h0tab(:,156),[86,9,32],[0,0,0],3,2,wf16(:,108),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,108),G0H8(1),m3h16x8(:,25),heltab2x128(:,:,156))
  call Hloop_Q_A(ntryL,G0H8(1),86,0,G1H8(49),n2h8(43))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(508)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(157),h0tab(:,157),[96,9,22],[0,0,0],3,3,wf4(:,16),wf4(:,4),wf8(:,44))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(1),m3h4x32(:,30),heltab2x128(:,:,157))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(20),n2h32(30))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(158),h0tab(:,158),[96,15,16],[0,0,0],3,2,wf4(:,16),wf16(:,36))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(1),m3h4x32(:,31),heltab2x128(:,:,158))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(21),n2h32(31))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(159),h0tab(:,159),[96,15,16],[0,0,0],3,2,wf4(:,16),wf16(:,107))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(1),m3h4x32(:,32),heltab2x128(:,:,159))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(22),n2h32(32))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(160),h0tab(:,160),[105,6,16],[0,0,0],3,2,wf16(:,112),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,112),G0H8(1),m3h16x8(:,26),heltab2x128(:,:,160))
  call Hloop_A_Q(ntryL,G0H8(1),105,0,G1H8(50),n2h8(44))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(161),h0tab(:,161),[64,22,41],[0,0,0],3,2,wf8(:,44),wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,69),heltab2x128(:,:,161))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(21),n2h64(69))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(162),h0tab(:,162),[70,16,41],[0,0,0],3,2,wf8(:,40),wf8(:,42))
  call Hloop_AW_Q(ntryL,G0H128(1),wf8(:,40),G0H16(1),m3h8x16(:,21),heltab2x128(:,:,162))
  call Hloop_A_Q(ntryL,G0H16(1),70,0,G1H16(11),n2h16(41))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(510)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(163),h0tab(:,163),[105,6,16],[0,0,0],3,2,wf16(:,163),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,163),G0H8(1),m3h16x8(:,27),heltab2x128(:,:,163))
  call Hloop_A_Q(ntryL,G0H8(1),105,0,G1H8(51),n2h8(45))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(385)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(164),h0tab(:,164),[64,16,47],[0,0,0],3,1,wf32(:,54))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,70),heltab2x128(:,:,164))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(22),n2h64(70))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(165),h0tab(:,165),[73,22,32],[0,0,0],3,2,wf8(:,38),wf8(:,44))
  call Hloop_AW_Q(ntryL,G0H128(1),wf8(:,38),G0H16(1),m3h8x16(:,22),heltab2x128(:,:,165))
  call Hloop_A_Q(ntryL,G0H16(1),73,0,G1H16(1),n2h16(42))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(511)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(166),h0tab(:,166),[105,6,16],[0,0,0],3,2,wf16(:,161),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,161),G0H8(1),m3h16x8(:,28),heltab2x128(:,:,166))
  call Hloop_A_Q(ntryL,G0H8(1),105,0,G1H8(52),n2h8(46))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(387)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(167),h0tab(:,167),[79,16,32],[0,0,0],3,1,wf32(:,55))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,55),G0H4(1),m3h32x4(:,15),heltab2x128(:,:,167))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(23),n2h4(47))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(388)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(168),h0tab(:,168),[79,16,32],[0,0,0],3,1,wf32(:,56))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,56),G0H4(1),ngZu,m3h32x4(:,16),heltab2x128(:,:,168))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(24),n2h4(48))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(512)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(169),h0tab(:,169),[86,9,32],[0,0,0],3,2,wf16(:,164),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,164),G0H8(1),m3h16x8(:,29),heltab2x128(:,:,169))
  call Hloop_Q_A(ntryL,G0H8(1),86,0,G1H8(53),n2h8(47))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(390)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(170),h0tab(:,170),[64,31,32],[0,0,0],3,1,wf32(:,58))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,71),heltab2x128(:,:,170))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(23),n2h64(71))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(513)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(171),h0tab(:,171),[86,9,32],[0,0,0],3,2,wf16(:,159),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,159),G0H8(1),m3h16x8(:,30),heltab2x128(:,:,171))
  call Hloop_Q_A(ntryL,G0H8(1),86,0,G1H8(54),n2h8(48))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(392)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(172),h0tab(:,172),[79,16,32],[0,0,0],3,1,wf32(:,59))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,59),G0H4(1),m3h32x4(:,17),heltab2x128(:,:,172))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(25),n2h4(49))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(393)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(173),h0tab(:,173),[79,16,32],[0,0,0],3,1,wf32(:,60))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,60),G0H4(1),ngZu,m3h32x4(:,18),heltab2x128(:,:,173))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(26),n2h4(50))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(394)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(174),h0tab(:,174),[64,31,32],[0,0,0],3,1,wf32(:,62))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,72),heltab2x128(:,:,174))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(24),n2h64(72))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(395)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(175),h0tab(:,175),[64,31,32],[0,0,0],3,1,wf32(:,64))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,73),heltab2x128(:,:,175))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(25),n2h64(73))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(396)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(176),h0tab(:,176),[64,16,47],[0,0,0],3,1,wf32(:,66))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,74),heltab2x128(:,:,176))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(26),n2h64(74))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(397)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(177),h0tab(:,177),[64,16,47],[0,0,0],3,1,wf32(:,68))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,75),heltab2x128(:,:,177))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(27),n2h64(75))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(399)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(178),h0tab(:,178),[79,16,32],[0,0,0],3,1,wf32(:,69))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,69),G0H4(1),m3h32x4(:,19),heltab2x128(:,:,178))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(27),n2h4(51))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(400)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(179),h0tab(:,179),[79,16,32],[0,0,0],3,1,wf32(:,71))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,71),G0H4(1),ngZu,m3h32x4(:,20),heltab2x128(:,:,179))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(28),n2h4(52))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(514)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(180),h0tab(:,180),[105,6,16],[0,0,0],3,2,wf16(:,165),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,165),G0H8(1),m3h16x8(:,31),heltab2x128(:,:,180))
  call Hloop_A_Q(ntryL,G0H8(1),105,0,G1H8(55),n2h8(49))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(141)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(181),h0tab(:,181),[73,22,32],[0,0,0],3,2,wf8(:,48),wf8(:,44))
  call Hloop_AW_Q(ntryL,G0H128(1),wf8(:,48),G0H16(1),m3h8x16(:,23),heltab2x128(:,:,181))
  call Hloop_A_Q(ntryL,G0H16(1),73,0,G1H16(7),n2h16(43))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(402)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(182),h0tab(:,182),[79,16,32],[0,0,0],3,1,wf32(:,72))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,72),G0H4(1),m3h32x4(:,21),heltab2x128(:,:,182))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(29),n2h4(53))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(403)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(183),h0tab(:,183),[79,16,32],[0,0,0],3,1,wf32(:,73))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,73),G0H4(1),ngZu,m3h32x4(:,22),heltab2x128(:,:,183))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(30),n2h4(54))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(406)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(184),h0tab(:,184),[79,16,32],[0,0,0],3,1,wf32(:,75))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,75),G0H4(1),ngZu,m3h32x4(:,23),heltab2x128(:,:,184))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(31),n2h4(55))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(515)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(185),h0tab(:,185),[80,15,32],[0,0,0],3,2,wf4(:,12),wf16(:,47))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,12),G0H32(1),m3h4x32(:,33),heltab2x128(:,:,185))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(23),n2h32(33))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(516)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(186),h0tab(:,186),[80,15,32],[0,0,0],3,2,wf4(:,12),wf16(:,166))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,12),G0H32(1),m3h4x32(:,34),heltab2x128(:,:,186))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(24),n2h32(34))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(517)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(187),h0tab(:,187),[80,15,32],[0,0,0],3,2,wf4(:,12),wf16(:,167))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,12),G0H32(1),m3h4x32(:,35),heltab2x128(:,:,187))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(25),n2h32(35))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(518)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(188),h0tab(:,188),[96,15,16],[0,0,0],3,2,wf4(:,16),wf16(:,47))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(1),m3h4x32(:,36),heltab2x128(:,:,188))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(26),n2h32(36))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(519)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(189),h0tab(:,189),[96,15,16],[0,0,0],3,2,wf4(:,16),wf16(:,166))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(1),m3h4x32(:,37),heltab2x128(:,:,189))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(27),n2h32(37))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(520)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(190),h0tab(:,190),[96,15,16],[0,0,0],3,2,wf4(:,16),wf16(:,167))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(1),m3h4x32(:,38),heltab2x128(:,:,190))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(28),n2h32(38))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(407)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(191),h0tab(:,191),[64,31,32],[0,0,0],3,1,wf32(:,77))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,76),heltab2x128(:,:,191))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(28),n2h64(76))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(408)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(192),h0tab(:,192),[64,31,32],[0,0,0],3,1,wf32(:,79))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,77),heltab2x128(:,:,192))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(29),n2h64(77))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(409)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(193),h0tab(:,193),[64,16,47],[0,0,0],3,1,wf32(:,81))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,78),heltab2x128(:,:,193))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(30),n2h64(78))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(410)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(194),h0tab(:,194),[64,16,47],[0,0,0],3,1,wf32(:,83))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,79),heltab2x128(:,:,194))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(31),n2h64(79))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(412)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(195),h0tab(:,195),[79,16,32],[0,0,0],3,1,wf32(:,84))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,84),G0H4(1),m3h32x4(:,24),heltab2x128(:,:,195))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(32),n2h4(56))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(413)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(196),h0tab(:,196),[79,16,32],[0,0,0],3,1,wf32(:,86))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,86),G0H4(1),ngZu,m3h32x4(:,25),heltab2x128(:,:,196))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(33),n2h4(57))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(414)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(197),h0tab(:,197),[64,31,32],[0,0,0],3,1,wf32(:,88))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,80),heltab2x128(:,:,197))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(32),n2h64(80))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(415)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(198),h0tab(:,198),[64,16,47],[0,0,0],3,1,wf32(:,90))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,81),heltab2x128(:,:,198))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(33),n2h64(81))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(417)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(199),h0tab(:,199),[79,16,32],[0,0,0],3,1,wf32(:,91))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,91),G0H4(1),m3h32x4(:,26),heltab2x128(:,:,199))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(34),n2h4(58))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(418)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(200),h0tab(:,200),[79,16,32],[0,0,0],3,1,wf32(:,93))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,93),G0H4(1),ngZu,m3h32x4(:,27),heltab2x128(:,:,200))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(35),n2h4(59))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(420)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(201),h0tab(:,201),[79,16,32],[0,0,0],3,1,wf32(:,95))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,95),G0H4(1),ngZu,m3h32x4(:,28),heltab2x128(:,:,201))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(36),n2h4(60))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(422)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(202),h0tab(:,202),[79,16,32],[0,0,0],3,1,wf32(:,96))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,96),G0H4(1),m3h32x4(:,29),heltab2x128(:,:,202))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(37),n2h4(61))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(423)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(203),h0tab(:,203),[79,16,32],[0,0,0],3,1,wf32(:,98))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,98),G0H4(1),ngZu,m3h32x4(:,30),heltab2x128(:,:,203))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(38),n2h4(62))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(165)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(204),h0tab(:,204),[70,16,41],[0,0,0],3,2,wf8(:,56),wf8(:,42))
  call Hloop_AW_Q(ntryL,G0H128(1),wf8(:,56),G0H16(1),m3h8x16(:,24),heltab2x128(:,:,204))
  call Hloop_A_Q(ntryL,G0H16(1),70,0,G1H16(12),n2h16(44))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(521)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(205),h0tab(:,205),[86,9,32],[0,0,0],3,2,wf16(:,168),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,168),G0H8(1),m3h16x8(:,32),heltab2x128(:,:,205))
  call Hloop_Q_A(ntryL,G0H8(1),86,0,G1H8(56),n2h8(50))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(425)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(206),h0tab(:,206),[79,16,32],[0,0,0],3,1,wf32(:,99))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,99),G0H4(1),m3h32x4(:,31),heltab2x128(:,:,206))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(39),n2h4(63))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(426)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(207),h0tab(:,207),[79,16,32],[0,0,0],3,1,wf32(:,100))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,100),G0H4(1),ngZu,m3h32x4(:,32),heltab2x128(:,:,207))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(40),n2h4(64))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(429)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(208),h0tab(:,208),[79,16,32],[0,0,0],3,1,wf32(:,102))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,102),G0H4(1),ngZu,m3h32x4(:,33),heltab2x128(:,:,208))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(41),n2h4(65))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(522)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(209),h0tab(:,209),[80,15,32],[0,0,0],3,2,wf4(:,12),wf16(:,56))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,12),G0H32(1),m3h4x32(:,39),heltab2x128(:,:,209))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(29),n2h32(39))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(523)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(210),h0tab(:,210),[80,15,32],[0,0,0],3,2,wf4(:,12),wf16(:,169))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,12),G0H32(1),m3h4x32(:,40),heltab2x128(:,:,210))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(30),n2h32(40))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(524)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(211),h0tab(:,211),[80,15,32],[0,0,0],3,2,wf4(:,12),wf16(:,170))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,12),G0H32(1),m3h4x32(:,41),heltab2x128(:,:,211))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(31),n2h32(41))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(525)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(212),h0tab(:,212),[96,15,16],[0,0,0],3,2,wf4(:,16),wf16(:,56))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(1),m3h4x32(:,42),heltab2x128(:,:,212))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(32),n2h32(42))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(526)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(213),h0tab(:,213),[96,15,16],[0,0,0],3,2,wf4(:,16),wf16(:,169))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(1),m3h4x32(:,43),heltab2x128(:,:,213))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(33),n2h32(43))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(527)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(214),h0tab(:,214),[96,15,16],[0,0,0],3,2,wf4(:,16),wf16(:,170))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(1),m3h4x32(:,44),heltab2x128(:,:,214))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(34),n2h32(44))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(430)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(215),h0tab(:,215),[64,31,32],[0,0,0],3,1,wf32(:,104))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,82),heltab2x128(:,:,215))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(34),n2h64(82))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(431)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(216),h0tab(:,216),[64,31,32],[0,0,0],3,1,wf32(:,106))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,83),heltab2x128(:,:,216))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(35),n2h64(83))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(432)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(217),h0tab(:,217),[64,16,47],[0,0,0],3,1,wf32(:,108))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,84),heltab2x128(:,:,217))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(36),n2h64(84))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(433)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(218),h0tab(:,218),[64,16,47],[0,0,0],3,1,wf32(:,110))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,85),heltab2x128(:,:,218))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(37),n2h64(85))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(435)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(219),h0tab(:,219),[79,16,32],[0,0,0],3,1,wf32(:,111))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,111),G0H4(1),m3h32x4(:,34),heltab2x128(:,:,219))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(42),n2h4(66))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(436)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(220),h0tab(:,220),[79,16,32],[0,0,0],3,1,wf32(:,113))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,113),G0H4(1),ngZu,m3h32x4(:,35),heltab2x128(:,:,220))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(43),n2h4(67))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(437)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(221),h0tab(:,221),[64,31,32],[0,0,0],3,1,wf32(:,115))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,86),heltab2x128(:,:,221))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(38),n2h64(86))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(438)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(222),h0tab(:,222),[64,16,47],[0,0,0],3,1,wf32(:,117))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,87),heltab2x128(:,:,222))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(39),n2h64(87))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(440)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(223),h0tab(:,223),[79,16,32],[0,0,0],3,1,wf32(:,118))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,118),G0H4(1),m3h32x4(:,36),heltab2x128(:,:,223))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(44),n2h4(68))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(441)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(224),h0tab(:,224),[79,16,32],[0,0,0],3,1,wf32(:,120))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,120),G0H4(1),ngZu,m3h32x4(:,37),heltab2x128(:,:,224))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(45),n2h4(69))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(443)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(225),h0tab(:,225),[79,16,32],[0,0,0],3,1,wf32(:,122))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,122),G0H4(1),ngZu,m3h32x4(:,38),heltab2x128(:,:,225))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(46),n2h4(70))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(528)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(226),h0tab(:,226),[80,15,32],[0,0,0],3,2,wf4(:,12),wf16(:,171))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,12),G0H32(1),m3h4x32(:,45),heltab2x128(:,:,226))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(35),n2h32(45))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(529)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(227),h0tab(:,227),[80,15,32],[0,0,0],3,2,wf4(:,12),wf16(:,172))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,12),G0H32(1),m3h4x32(:,46),heltab2x128(:,:,227))
  call Hloop_Q_A(ntryL,G0H32(1),80,0,G1H32(36),n2h32(46))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(530)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(228),h0tab(:,228),[96,15,16],[0,0,0],3,2,wf4(:,16),wf16(:,171))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(1),m3h4x32(:,47),heltab2x128(:,:,228))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(37),n2h32(47))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(531)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(229),h0tab(:,229),[96,15,16],[0,0,0],3,2,wf4(:,16),wf16(:,172))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(1),m3h4x32(:,48),heltab2x128(:,:,229))
  call Hloop_A_Q(ntryL,G0H32(1),96,0,G1H32(38),n2h32(48))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(444)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(230),h0tab(:,230),[64,31,32],[0,0,0],3,1,wf32(:,124))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,88),heltab2x128(:,:,230))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(40),n2h64(88))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(445)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(231),h0tab(:,231),[64,16,47],[0,0,0],3,1,wf32(:,126))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,89),heltab2x128(:,:,231))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(41),n2h64(89))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(446)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(232),h0tab(:,232),[64,31,32],[0,0,0],3,1,wf32(:,128))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,90),heltab2x128(:,:,232))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(42),n2h64(90))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(447)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(233),h0tab(:,233),[64,16,47],[0,0,0],3,1,wf32(:,130))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,91),heltab2x128(:,:,233))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(43),n2h64(91))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(449)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(234),h0tab(:,234),[79,16,32],[0,0,0],3,1,wf32(:,131))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,131),G0H4(1),m3h32x4(:,39),heltab2x128(:,:,234))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(47),n2h4(71))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(450)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(235),h0tab(:,235),[79,16,32],[0,0,0],3,1,wf32(:,133))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,133),G0H4(1),ngZu,m3h32x4(:,40),heltab2x128(:,:,235))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(48),n2h4(72))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(452)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(236),h0tab(:,236),[79,16,32],[0,0,0],3,1,wf32(:,135))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,135),G0H4(1),ngZu,m3h32x4(:,41),heltab2x128(:,:,236))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(49),n2h4(73))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(454)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(237),h0tab(:,237),[79,16,32],[0,0,0],3,1,wf32(:,137))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,137),G0H4(1),ngZu,m3h32x4(:,42),heltab2x128(:,:,237))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(50),n2h4(74))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(456)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(238),h0tab(:,238),[79,16,32],[0,0,0],3,1,wf32(:,139))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,139),G0H4(1),ngZu,m3h32x4(:,43),heltab2x128(:,:,238))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(51),n2h4(75))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(458)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(239),h0tab(:,239),[79,16,32],[0,0,0],3,1,wf32(:,141))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,141),G0H4(1),ngZu,m3h32x4(:,44),heltab2x128(:,:,239))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(52),n2h4(76))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(460)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(240),h0tab(:,240),[79,16,32],[0,0,0],3,1,wf32(:,142))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,142),G0H4(1),m3h32x4(:,45),heltab2x128(:,:,240))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(53),n2h4(77))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(461)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(241),h0tab(:,241),[79,16,32],[0,0,0],3,1,wf32(:,144))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,144),G0H4(1),ngZu,m3h32x4(:,46),heltab2x128(:,:,241))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(54),n2h4(78))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(463)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(242),h0tab(:,242),[79,16,32],[0,0,0],3,1,wf32(:,146))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,146),G0H4(1),ngZu,m3h32x4(:,47),heltab2x128(:,:,242))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(55),n2h4(79))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(465)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(243),h0tab(:,243),[79,16,32],[0,0,0],3,1,wf32(:,148))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,148),G0H4(1),ngZu,m3h32x4(:,48),heltab2x128(:,:,243))
  call Hloop_A_Q(ntryL,G0H4(1),79,0,G1H4(56),n2h4(80))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(44),[G1H8(43),G1H8(37),G1H8(34),G1H8(27),G1H8(26),G1H8(7) &
    ,G1H8(6),G1H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(19),[G1H8(1),G1H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(20),[G1H8(2),G1H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(48),[G1H8(45),G1H8(40),G1H8(39),G1H8(32),G1H8(31) &
    ,G1H8(15),G1H8(14),G1H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(21),[G1H8(9),G1H8(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(25),[G1H8(12),G1H8(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(56),[G1H8(54),G1H8(53),G1H8(49),G1H8(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(55),[G1H8(52),G1H8(51),G1H8(50),G1H8(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(56),[G1H4(55),G1H4(54),G1H4(53),G1H4(52),G1H4(51) &
    ,G1H4(50),G1H4(49),G1H4(48),G1H4(47),G1H4(46),G1H4(45),G1H4(44),G1H4(43),G1H4(42),G1H4(41),G1H4(40),G1H4(39),G1H4(38),G1H4(37) &
    ,G1H4(36),G1H4(35),G1H4(34),G1H4(33),G1H4(32),G1H4(31),G1H4(30),G1H4(29),G1H4(28),G1H4(27),G1H4(26),G1H4(25),G1H4(24),G1H4(23) &
    ,G1H4(22),G1H4(21),G1H4(20),G1H4(19),G1H4(18),G1H4(17),G1H4(16),G1H4(15),G1H4(14),G1H4(13),G1H4(12),G1H4(11),G1H4(10) &
    ,G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(8),[G1H16(6),G1H16(3),G1H16(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(2),[G1H16(5),G1H16(10),G1H16(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(12),[G1H16(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(7),[G1H16(1)])
  call Hloop_QZ_A(ntryL,G1H8(44),wf4(:,11),G1H2(1),ngZu,m3h4x2(:,25),heltab2x8(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(3),n2h2(25))
  call Hloop_QV_A(ntryL,G1H8(19),wf4(:,9),G1H2(2),m3h4x2(:,26),heltab2x8(:,:,58))
  call Hloop_Q_A(ntryL,G1H2(2),95,0,G2H2(5),n2h2(26))
  call Hloop_QZ_A(ntryL,G1H8(20),wf4(:,14),G1H2(5),ngZu,m3h4x2(:,27),heltab2x8(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(5),95,0,G2H2(18),n2h2(27))
  call Hloop_AZ_Q(ntryL,G1H8(48),wf4(:,11),G1H2(6),ngZu,m3h4x2(:,28),heltab2x8(:,:,60))
  call Hloop_A_Q(ntryL,G1H2(6),111,0,G2H2(20),n2h2(28))
  call Hloop_AV_Q(ntryL,G1H8(21),wf4(:,9),G1H2(7),m3h4x2(:,29),heltab2x8(:,:,61))
  call Hloop_A_Q(ntryL,G1H2(7),111,0,G2H2(27),n2h2(29))
  call Hloop_AZ_Q(ntryL,G1H8(25),wf4(:,14),G1H2(10),ngZu,m3h4x2(:,30),heltab2x8(:,:,62))
  call Hloop_A_Q(ntryL,G1H2(10),111,0,G2H2(29),n2h2(30))
  call Hloop_QW_A(ntryL,G1H8(56),wf4(:,4),G1H2(11),m3h4x2(:,31),heltab2x8(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(11),95,0,G2H2(1),n2h2(31))
  call Hloop_AW_Q(ntryL,G1H8(55),wf4(:,5),G1H2(12),m3h4x2(:,32),heltab2x8(:,:,64))
  call Hloop_A_Q(ntryL,G1H2(12),111,0,G2H2(2),n2h2(32))
  call Hloop_AQ_V(ntryL,G1H4(56),ex5(:),G1H2(15),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_QV_A(ntryL,G1H32(1),wf4(:,9),G1H8(43),m3h4x8(:,11),heltab2x32(:,:,11))
  call Hloop_Q_A(ntryL,G1H8(43),92,0,G2H8(9),n2h8(51))
  call Hloop_QZ_A(ntryL,G1H32(2),wf4(:,14),G1H8(37),ngZu,m3h4x8(:,12),heltab2x32(:,:,12))
  call Hloop_Q_A(ntryL,G1H8(37),92,0,G2H8(10),n2h8(52))
  call Hloop_QZ_A(ntryL,G1H32(3),wf4(:,11),G1H8(34),ngZu,m3h4x8(:,13),heltab2x32(:,:,13))
  call Hloop_Q_A(ntryL,G1H8(34),83,0,G2H8(1),n2h8(53))
  call Hloop_QZ_A(ntryL,G1H32(4),wf4(:,11),G1H8(27),ngZu,m3h4x8(:,14),heltab2x32(:,:,14))
  call Hloop_Q_A(ntryL,G1H8(27),83,0,G2H8(5),n2h8(54))
  call Hloop_AV_Q(ntryL,G1H32(5),wf4(:,9),G1H8(26),m3h4x8(:,15),heltab2x32(:,:,15))
  call Hloop_A_Q(ntryL,G1H8(26),108,0,G2H8(2),n2h8(55))
  call Hloop_AZ_Q(ntryL,G1H32(6),wf4(:,14),G1H8(7),ngZu,m3h4x8(:,16),heltab2x32(:,:,16))
  call Hloop_A_Q(ntryL,G1H8(7),108,0,G2H8(3),n2h8(56))
  call Hloop_AZ_Q(ntryL,G1H32(7),wf4(:,11),G1H8(6),ngZu,m3h4x8(:,17),heltab2x32(:,:,17))
  call Hloop_A_Q(ntryL,G1H8(6),99,0,G2H8(4),n2h8(57))
  call Hloop_AZ_Q(ntryL,G1H32(8),wf4(:,11),G1H8(3),ngZu,m3h4x8(:,18),heltab2x32(:,:,18))
  call Hloop_A_Q(ntryL,G1H8(3),99,0,G2H8(6),n2h8(58))
  call Hloop_AQ_V(ntryL,G1H64(1),wf8(:,8),G1H8(1),m3h8x8(:,1),heltab2x64(:,:,49))
  call Hloop_AQ_V(ntryL,G1H64(2),wf8(:,8),G1H8(8),m3h8x8(:,2),heltab2x64(:,:,50))
  call Hloop_AQ_V(ntryL,G1H64(3),wf32(:,4),G1H2(16),m3h32x2(:,1),heltab2x64(:,:,51))
  call Hloop_AQ_V(ntryL,G1H64(4),wf32(:,6),G1H2(17),m3h32x2(:,2),heltab2x64(:,:,52))
  call Hloop_AQ_V(ntryL,G1H64(5),wf8(:,10),G1H8(2),m3h8x8(:,3),heltab2x64(:,:,53))
  call Hloop_AQ_V(ntryL,G1H64(6),wf8(:,12),G1H8(13),m3h8x8(:,4),heltab2x64(:,:,54))
  call Hloop_AQ_V(ntryL,G1H64(7),ex5(:),G1H32(1),m3h2x32(:,1),heltab2x64(:,:,55))
  call Hloop_AQ_V(ntryL,G1H64(8),ex5(:),G1H32(2),m3h2x32(:,2),heltab2x64(:,:,56))
  call Hloop_AQ_V(ntryL,G1H64(9),wf32(:,12),G1H2(20),m3h32x2(:,3),heltab2x64(:,:,57))
  call Hloop_AQ_V(ntryL,G1H64(10),wf32(:,14),G1H2(21),m3h32x2(:,4),heltab2x64(:,:,58))
  call Hloop_AQ_V(ntryL,G1H64(11),ex5(:),G1H32(3),m3h2x32(:,3),heltab2x64(:,:,59))
  call Hloop_AQ_V(ntryL,G1H64(12),ex5(:),G1H32(4),m3h2x32(:,4),heltab2x64(:,:,60))
  call Hloop_AQ_V(ntryL,G1H16(8),wf8(:,8),G1H2(22),m3h8x2(:,9),heltab2x16(:,:,21))
  call Hloop_AQ_V(ntryL,G1H16(2),ex5(:),G1H8(45),m3h2x8(:,9),heltab2x16(:,:,22))
  call Hloop_QV_A(ntryL,G1H32(9),wf16(:,27),G1H2(25),m3h16x2(:,1),heltab2x32(:,:,19))
  call Hloop_Q_A(ntryL,G1H2(25),95,0,G2H2(4),n2h2(33))
  call Hloop_QZ_A(ntryL,G1H32(10),wf16(:,154),G1H2(26),ngZu,m3h16x2(:,2),heltab2x32(:,:,20))
  call Hloop_Q_A(ntryL,G1H2(26),95,0,G2H2(6),n2h2(34))
  call Hloop_QV_A(ntryL,G1H32(11),wf16(:,29),G1H2(27),m3h16x2(:,3),heltab2x32(:,:,21))
  call Hloop_Q_A(ntryL,G1H2(27),95,0,G2H2(7),n2h2(35))
  call Hloop_QZ_A(ntryL,G1H32(12),wf16(:,155),G1H2(30),ngZu,m3h16x2(:,4),heltab2x32(:,:,22))
  call Hloop_Q_A(ntryL,G1H2(30),95,0,G2H2(8),n2h2(36))
  call Hloop_AV_Q(ntryL,G1H32(13),wf16(:,27),G1H2(31),m3h16x2(:,5),heltab2x32(:,:,23))
  call Hloop_A_Q(ntryL,G1H2(31),111,0,G2H2(9),n2h2(37))
  call Hloop_AZ_Q(ntryL,G1H32(14),wf16(:,154),G1H2(32),ngZu,m3h16x2(:,6),heltab2x32(:,:,24))
  call Hloop_A_Q(ntryL,G1H2(32),111,0,G2H2(10),n2h2(38))
  call Hloop_AV_Q(ntryL,G1H32(15),wf16(:,29),G1H2(35),m3h16x2(:,7),heltab2x32(:,:,25))
  call Hloop_A_Q(ntryL,G1H2(35),111,0,G2H2(11),n2h2(39))
  call Hloop_AZ_Q(ntryL,G1H32(16),wf16(:,155),G1H2(36),ngZu,m3h16x2(:,8),heltab2x32(:,:,26))
  call Hloop_A_Q(ntryL,G1H2(36),111,0,G2H2(12),n2h2(40))
  call Hloop_AQ_V(ntryL,G1H64(13),wf32(:,32),G1H2(37),m3h32x2(:,5),heltab2x64(:,:,61))
  call Hloop_AQ_V(ntryL,G1H64(14),wf32(:,34),G1H2(40),m3h32x2(:,6),heltab2x64(:,:,62))
  call Hloop_AQ_V(ntryL,G1H64(15),ex5(:),G1H32(5),m3h2x32(:,5),heltab2x64(:,:,63))
  call Hloop_AQ_V(ntryL,G1H64(16),ex5(:),G1H32(6),m3h2x32(:,6),heltab2x64(:,:,64))
  call Hloop_AQ_V(ntryL,G1H64(17),wf32(:,43),G1H2(41),m3h32x2(:,7),heltab2x64(:,:,65))
  call Hloop_AQ_V(ntryL,G1H64(18),wf32(:,45),G1H2(42),m3h32x2(:,8),heltab2x64(:,:,66))
  call Hloop_AQ_V(ntryL,G1H64(19),ex5(:),G1H32(7),m3h2x32(:,7),heltab2x64(:,:,67))
  call Hloop_AQ_V(ntryL,G1H64(20),ex5(:),G1H32(8),m3h2x32(:,8),heltab2x64(:,:,68))
  call Hloop_QW_A(ntryL,G1H32(17),wf4(:,5),G1H8(40),m3h4x8(:,19),heltab2x32(:,:,27))
  call Hloop_Q_A(ntryL,G1H8(40),86,0,G2H8(7),n2h8(59))
  call Hloop_QV_A(ntryL,G1H32(18),wf16(:,36),G1H2(45),m3h16x2(:,9),heltab2x32(:,:,28))
  call Hloop_Q_A(ntryL,G1H2(45),95,0,G2H2(13),n2h2(41))
  call Hloop_QZ_A(ntryL,G1H32(19),wf16(:,107),G1H2(46),ngZu,m3h16x2(:,10),heltab2x32(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(46),95,0,G2H2(14),n2h2(42))
  call Hloop_AW_Q(ntryL,G1H32(20),wf4(:,4),G1H8(39),m3h4x8(:,20),heltab2x32(:,:,30))
  call Hloop_A_Q(ntryL,G1H8(39),105,0,G2H8(8),n2h8(60))
  call Hloop_AV_Q(ntryL,G1H32(21),wf16(:,36),G1H2(47),m3h16x2(:,11),heltab2x32(:,:,31))
  call Hloop_A_Q(ntryL,G1H2(47),111,0,G2H2(15),n2h2(43))
  call Hloop_AZ_Q(ntryL,G1H32(22),wf16(:,107),G1H2(50),ngZu,m3h16x2(:,12),heltab2x32(:,:,32))
  call Hloop_A_Q(ntryL,G1H2(50),111,0,G2H2(17),n2h2(44))
  call Hloop_AQ_V(ntryL,G1H64(21),wf8(:,44),G1H8(32),m3h8x8(:,5),heltab2x64(:,:,69))
  call Hloop_AQ_V(ntryL,G1H16(12),ex5(:),G1H8(31),m3h2x8(:,10),heltab2x16(:,:,23))
  call Hloop_AQ_V(ntryL,G1H64(22),ex5(:),G1H32(9),m3h2x32(:,9),heltab2x64(:,:,70))
  call Hloop_AQ_V(ntryL,G1H16(7),wf8(:,44),G1H2(51),m3h8x2(:,10),heltab2x16(:,:,24))
  call Hloop_AQ_V(ntryL,G1H64(23),wf32(:,58),G1H2(52),m3h32x2(:,9),heltab2x64(:,:,71))
  call Hloop_AQ_V(ntryL,G1H64(24),wf32(:,62),G1H2(55),m3h32x2(:,10),heltab2x64(:,:,72))
  call Hloop_AQ_V(ntryL,G1H64(25),wf32(:,64),G1H2(56),m3h32x2(:,11),heltab2x64(:,:,73))
  call Hloop_AQ_V(ntryL,G1H64(26),ex5(:),G1H32(10),m3h2x32(:,10),heltab2x64(:,:,74))
  call Hloop_AQ_V(ntryL,G1H64(27),ex5(:),G1H32(11),m3h2x32(:,11),heltab2x64(:,:,75))
  call Hloop_QV_A(ntryL,G1H32(23),wf16(:,47),G1H2(57),m3h16x2(:,13),heltab2x32(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(57),95,0,G2H2(21),n2h2(45))
  call Hloop_QZ_A(ntryL,G1H32(24),wf16(:,166),G1H2(60),ngZu,m3h16x2(:,14),heltab2x32(:,:,34))
  call Hloop_Q_A(ntryL,G1H2(60),95,0,G2H2(23),n2h2(46))
  call Hloop_QZ_A(ntryL,G1H32(25),wf16(:,167),G1H2(1),ngZu,m3h16x2(:,15),heltab2x32(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(24),n2h2(47))
  call Hloop_AV_Q(ntryL,G1H32(26),wf16(:,47),G1H2(2),m3h16x2(:,16),heltab2x32(:,:,36))
  call Hloop_A_Q(ntryL,G1H2(2),111,0,G2H2(26),n2h2(48))
  call Hloop_AZ_Q(ntryL,G1H32(27),wf16(:,166),G1H2(5),ngZu,m3h16x2(:,17),heltab2x32(:,:,37))
  call Hloop_A_Q(ntryL,G1H2(5),111,0,G2H2(30),n2h2(49))
  call Hloop_AZ_Q(ntryL,G1H32(28),wf16(:,167),G1H2(6),ngZu,m3h16x2(:,18),heltab2x32(:,:,38))
  call Hloop_A_Q(ntryL,G1H2(6),111,0,G2H2(32),n2h2(50))
  call Hloop_AQ_V(ntryL,G1H64(28),wf32(:,77),G1H2(7),m3h32x2(:,12),heltab2x64(:,:,76))
  call Hloop_AQ_V(ntryL,G1H64(29),wf32(:,79),G1H2(10),m3h32x2(:,13),heltab2x64(:,:,77))
  call Hloop_AQ_V(ntryL,G1H64(30),ex5(:),G1H32(12),m3h2x32(:,12),heltab2x64(:,:,78))
  call Hloop_AQ_V(ntryL,G1H64(31),ex5(:),G1H32(13),m3h2x32(:,13),heltab2x64(:,:,79))
  call Hloop_AQ_V(ntryL,G1H64(32),wf32(:,88),G1H2(11),m3h32x2(:,14),heltab2x64(:,:,80))
  call Hloop_AQ_V(ntryL,G1H64(33),ex5(:),G1H32(14),m3h2x32(:,14),heltab2x64(:,:,81))
  call Hloop_QV_A(ntryL,G1H32(29),wf16(:,56),G1H2(12),m3h16x2(:,19),heltab2x32(:,:,39))
  call Hloop_Q_A(ntryL,G1H2(12),95,0,G2H2(33),n2h2(51))
  call Hloop_QZ_A(ntryL,G1H32(30),wf16(:,169),G1H2(25),ngZu,m3h16x2(:,20),heltab2x32(:,:,40))
  call Hloop_Q_A(ntryL,G1H2(25),95,0,G2H2(35),n2h2(52))
  call Hloop_QZ_A(ntryL,G1H32(31),wf16(:,170),G1H2(26),ngZu,m3h16x2(:,21),heltab2x32(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(26),95,0,G2H2(36),n2h2(53))
  call Hloop_AV_Q(ntryL,G1H32(32),wf16(:,56),G1H2(27),m3h16x2(:,22),heltab2x32(:,:,42))
  call Hloop_A_Q(ntryL,G1H2(27),111,0,G2H2(38),n2h2(54))
  call Hloop_AZ_Q(ntryL,G1H32(33),wf16(:,169),G1H2(30),ngZu,m3h16x2(:,23),heltab2x32(:,:,43))
  call Hloop_A_Q(ntryL,G1H2(30),111,0,G2H2(39),n2h2(55))
  call Hloop_AZ_Q(ntryL,G1H32(34),wf16(:,170),G1H2(31),ngZu,m3h16x2(:,24),heltab2x32(:,:,44))
  call Hloop_A_Q(ntryL,G1H2(31),111,0,G2H2(40),n2h2(56))
  call Hloop_AQ_V(ntryL,G1H64(34),wf32(:,104),G1H2(32),m3h32x2(:,15),heltab2x64(:,:,82))
  call Hloop_AQ_V(ntryL,G1H64(35),wf32(:,106),G1H2(35),m3h32x2(:,16),heltab2x64(:,:,83))
  call Hloop_AQ_V(ntryL,G1H64(36),ex5(:),G1H32(15),m3h2x32(:,15),heltab2x64(:,:,84))
  call Hloop_AQ_V(ntryL,G1H64(37),ex5(:),G1H32(16),m3h2x32(:,16),heltab2x64(:,:,85))
  call Hloop_AQ_V(ntryL,G1H64(38),wf32(:,115),G1H2(36),m3h32x2(:,17),heltab2x64(:,:,86))
  call Hloop_AQ_V(ntryL,G1H64(39),ex5(:),G1H32(17),m3h2x32(:,17),heltab2x64(:,:,87))
  call Hloop_QZ_A(ntryL,G1H32(35),wf16(:,171),G1H2(45),ngZu,m3h16x2(:,25),heltab2x32(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(45),95,0,G2H2(41),n2h2(57))
  call Hloop_QZ_A(ntryL,G1H32(36),wf16(:,172),G1H2(46),ngZu,m3h16x2(:,26),heltab2x32(:,:,46))
  call Hloop_Q_A(ntryL,G1H2(46),95,0,G2H2(42),n2h2(58))
  call Hloop_AZ_Q(ntryL,G1H32(37),wf16(:,171),G1H2(47),ngZu,m3h16x2(:,27),heltab2x32(:,:,47))
  call Hloop_A_Q(ntryL,G1H2(47),111,0,G2H2(43),n2h2(59))
  call Hloop_AZ_Q(ntryL,G1H32(38),wf16(:,172),G1H2(50),ngZu,m3h16x2(:,28),heltab2x32(:,:,48))
  call Hloop_A_Q(ntryL,G1H2(50),111,0,G2H2(44),n2h2(60))
  call Hloop_AQ_V(ntryL,G1H64(40),wf32(:,124),G1H2(57),m3h32x2(:,18),heltab2x64(:,:,88))
  call Hloop_AQ_V(ntryL,G1H64(41),ex5(:),G1H32(18),m3h2x32(:,18),heltab2x64(:,:,89))
  call Hloop_AQ_V(ntryL,G1H64(42),wf32(:,128),G1H2(60),m3h32x2(:,19),heltab2x64(:,:,90))
  call Hloop_AQ_V(ntryL,G1H64(43),ex5(:),G1H32(19),m3h2x32(:,19),heltab2x64(:,:,91))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(42),[G2H2(41),G2H2(36),G2H2(35),G2H2(33),G2H2(24) &
    ,G2H2(23),G2H2(21),G2H2(14),G2H2(13),G2H2(8),G2H2(7),G2H2(6),G2H2(4),G2H2(34),G2H2(22),G2H2(19),G2H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(44),[G2H2(43),G2H2(40),G2H2(39),G2H2(38),G2H2(32) &
    ,G2H2(30),G2H2(26),G2H2(17),G2H2(15),G2H2(12),G2H2(11),G2H2(10),G2H2(9),G2H2(37),G2H2(31),G2H2(28),G2H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(22),[G1H2(24),G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(60),[G1H2(57),G1H2(36),G1H2(35),G1H2(32),G1H2(11) &
    ,G1H2(10),G1H2(7),G1H2(56),G1H2(55),G1H2(52),G1H2(42),G1H2(41),G1H2(40),G1H2(37),G1H2(21),G1H2(20),G1H2(17),G1H2(16),G1H2(54) &
    ,G1H2(39),G1H2(14),G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(29),[G1H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(44),[G1H2(34),G1H2(19),G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(45),[G1H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(13),[G1H8(2),G1H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1),[G1H8(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(8),[G1H8(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(15),[G1H2(48),G1H2(38),G1H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(58),[G1H2(33),G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(59),[G1H2(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(31),[G1H8(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(32),[G1H8(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(51),[G1H2(53),G1H2(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(18),[G2H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G2H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(10),[G2H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(3),[G2H8(2)])
call HGT_w2_OLR(G1H4(1),1,1,4)
call HGT_w2_invQ_OLR(G1H4(1),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(1),wf4(:,11),G1H1(1),ngZu,m3h4x1(:,1),heltab2x4(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(28),n2h1(61))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(42),ex6(:),G2tensor(37),m3h2x1(:,49),heltab2x2(:,:,49))
call HGT_w2_OLR(G1H4(2),1,1,4)
call HGT_w2_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(2),wf4(:,9),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(1),n2h1(62))
call HGT_w2_OLR(G1H4(3),1,1,4)
call HGT_w2_invQ_OLR(G1H4(3),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(3),wf4(:,14),G1H1(1),ngZu,m3h4x1(:,3),heltab2x4(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(3),n2h1(63))
call HGT_w2_OLR(G1H4(4),1,1,4)
call HGT_w2_invQ_OLR(G1H4(4),2,5,4)
  call Hloop_AZ_Q(ntryL,G1H4(4),wf4(:,11),G1H1(1),ngZu,m3h4x1(:,4),heltab2x4(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(5),n2h1(64))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(44),ex5(:),G2tensor(7),m3h2x1(:,50),heltab2x2(:,:,50))
call HGT_w2_OLR(G1H4(5),1,1,4)
call HGT_w2_invQ_OLR(G1H4(5),2,5,4)
  call Hloop_AV_Q(ntryL,G1H4(5),wf4(:,9),G1H1(1),m3h4x1(:,5),heltab2x4(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(9),n2h1(65))
call HGT_w2_OLR(G1H4(6),1,1,4)
call HGT_w2_invQ_OLR(G1H4(6),2,5,4)
  call Hloop_AZ_Q(ntryL,G1H4(6),wf4(:,14),G1H1(1),ngZu,m3h4x1(:,6),heltab2x4(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(11),n2h1(66))
call HGT_w2_OLR(G1H4(7),1,1,4)
call HGT_w2_invQ_OLR(G1H4(7),2,5,4)
  call Hloop_QW_A(ntryL,G1H4(7),wf4(:,4),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(13),n2h1(67))
call HGT_w2_OLR(G1H4(8),1,1,4)
call HGT_w2_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_AW_Q(ntryL,G1H4(8),wf4(:,5),G1H1(1),m3h4x1(:,8),heltab2x4(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(16),n2h1(68))
  call Hloop_VA_Q(ntryL,G1H2(22),ex6(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(19),n2h1(69))
  call Hloop_VA_Q(ntryL,G1H2(60),ex6(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(22),n2h1(70))
  call Hloop_VQ_A(ntryL,G1H8(4),wf8(:,8),G1H1(1),m3h8x1(:,25),heltab2x8(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(25),n2h1(71))
  call Hloop_VQ_A(ntryL,G1H8(5),wf8(:,8),G1H1(1),m3h8x1(:,26),heltab2x8(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(31),n2h1(72))
  call Hloop_VQ_A(ntryL,G1H2(29),ex5(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(34),n2h1(73))
  call Hloop_VQ_A(ntryL,G1H2(44),ex5(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(40),n2h1(74))
  call Hloop_VA_Q(ntryL,G1H8(45),wf8(:,2),G1H1(1),m3h8x1(:,27),heltab2x8(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(43),n2h1(75))
  call Hloop_VA_Q(ntryL,G1H8(13),wf8(:,2),G1H1(1),m3h8x1(:,28),heltab2x8(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(46),n2h1(76))
  call Hloop_VA_Q(ntryL,G1H2(13),ex6(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(49),n2h1(77))
  call Hloop_VQ_A(ntryL,G1H8(16),wf8(:,10),G1H1(1),m3h8x1(:,29),heltab2x8(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(52),n2h1(78))
  call Hloop_VQ_A(ntryL,G1H8(17),wf8(:,10),G1H1(1),m3h8x1(:,30),heltab2x8(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(55),n2h1(79))
  call Hloop_VQ_A(ntryL,G1H8(22),wf8(:,12),G1H1(1),m3h8x1(:,31),heltab2x8(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(58),n2h1(80))
  call Hloop_VQ_A(ntryL,G1H8(24),wf8(:,12),G1H1(1),m3h8x1(:,32),heltab2x8(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(61),n2h1(81))
  call Hloop_VQ_A(ntryL,G1H2(18),ex5(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(64),n2h1(82))
  call Hloop_VA_Q(ntryL,G1H8(29),wf8(:,4),G1H1(1),m3h8x1(:,33),heltab2x8(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(67),n2h1(83))
  call Hloop_VA_Q(ntryL,G1H8(1),wf8(:,4),G1H1(1),m3h8x1(:,34),heltab2x8(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(70),n2h1(84))
  call Hloop_VA_Q(ntryL,G1H8(35),wf8(:,6),G1H1(1),m3h8x1(:,35),heltab2x8(:,:,75))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(73),n2h1(85))
  call Hloop_VA_Q(ntryL,G1H8(8),wf8(:,6),G1H1(1),m3h8x1(:,36),heltab2x8(:,:,76))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(74),n2h1(86))
  call Hloop_VA_Q(ntryL,G1H2(15),ex6(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(75),n2h1(87))
  call Hloop_VQ_A(ntryL,G1H2(58),ex5(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(76),n2h1(88))
  call Hloop_VQ_A(ntryL,G1H2(59),ex5(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(77),n2h1(89))
  call Hloop_VA_Q(ntryL,G1H8(31),wf8(:,42),G1H1(1),m3h8x1(:,37),heltab2x8(:,:,77))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(78),n2h1(90))
  call Hloop_VA_Q(ntryL,G1H8(32),wf8(:,42),G1H1(1),m3h8x1(:,38),heltab2x8(:,:,78))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(79),n2h1(91))
  call Hloop_VA_Q(ntryL,G1H2(51),ex6(:),G1H1(1),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(80),n2h1(92))
  call Hloop_VQ_A(ntryL,G1H8(46),wf8(:,44),G1H1(1),m3h8x1(:,39),heltab2x8(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(81),n2h1(93))
  call Hloop_VQ_A(ntryL,G1H8(47),wf8(:,44),G1H1(1),m3h8x1(:,40),heltab2x8(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(82),n2h1(94))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(3),ex6(:),G2tensor(83),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(18),ex6(:),G2tensor(84),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(20),ex5(:),G2tensor(85),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(29),ex5(:),G2tensor(86),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(1),ex6(:),G2tensor(87),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(2),ex5(:),G2tensor(88),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(10),wf8(:,2),G2tensor(89),m3h8x1(:,41),heltab2x8(:,:,81))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(1),wf8(:,4),G2tensor(90),m3h8x1(:,42),heltab2x8(:,:,82))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(5),wf8(:,6),G2tensor(91),m3h8x1(:,43),heltab2x8(:,:,83))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(3),wf8(:,8),G2tensor(92),m3h8x1(:,44),heltab2x8(:,:,84))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(4),wf8(:,10),G2tensor(93),m3h8x1(:,45),heltab2x8(:,:,85))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(6),wf8(:,12),G2tensor(94),m3h8x1(:,46),heltab2x8(:,:,86))
  call Hloop_VA_Q(ntryL,G1H32(1),wf32(:,8),G1H1(1),m3h32x1(:,1),heltab2x32(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(95),n2h1(95))
  call Hloop_VA_Q(ntryL,G1H32(2),wf32(:,10),G1H1(1),m3h32x1(:,2),heltab2x32(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(96),n2h1(96))
  call Hloop_VA_Q(ntryL,G1H32(3),wf32(:,16),G1H1(1),m3h32x1(:,3),heltab2x32(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(97),n2h1(97))
  call Hloop_VA_Q(ntryL,G1H32(4),wf32(:,18),G1H1(1),m3h32x1(:,4),heltab2x32(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(98),n2h1(98))
  call Hloop_VA_Q(ntryL,G1H32(5),wf32(:,36),G1H1(1),m3h32x1(:,5),heltab2x32(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(99),n2h1(99))
  call Hloop_VA_Q(ntryL,G1H32(6),wf32(:,38),G1H1(1),m3h32x1(:,6),heltab2x32(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(100),n2h1(100))
  call Hloop_VA_Q(ntryL,G1H32(7),wf32(:,47),G1H1(1),m3h32x1(:,7),heltab2x32(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(101),n2h1(101))
  call Hloop_VA_Q(ntryL,G1H32(8),wf32(:,49),G1H1(1),m3h32x1(:,8),heltab2x32(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(102),n2h1(102))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(7),wf8(:,42),G2tensor(103),m3h8x1(:,47),heltab2x8(:,:,87))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(8),wf8(:,44),G2tensor(104),m3h8x1(:,48),heltab2x8(:,:,88))
  call Hloop_VA_Q(ntryL,G1H32(9),wf32(:,54),G1H1(1),m3h32x1(:,9),heltab2x32(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(105),n2h1(103))
  call Hloop_VA_Q(ntryL,G1H32(10),wf32(:,66),G1H1(1),m3h32x1(:,10),heltab2x32(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(106),n2h1(104))
  call Hloop_VA_Q(ntryL,G1H32(11),wf32(:,68),G1H1(1),m3h32x1(:,11),heltab2x32(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(107),n2h1(105))
  call Hloop_VA_Q(ntryL,G1H32(12),wf32(:,81),G1H1(1),m3h32x1(:,12),heltab2x32(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(108),n2h1(106))
  call Hloop_VA_Q(ntryL,G1H32(13),wf32(:,83),G1H1(1),m3h32x1(:,13),heltab2x32(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(109),n2h1(107))
  call Hloop_VA_Q(ntryL,G1H32(14),wf32(:,90),G1H1(1),m3h32x1(:,14),heltab2x32(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(110),n2h1(108))
  call Hloop_VA_Q(ntryL,G1H32(15),wf32(:,108),G1H1(1),m3h32x1(:,15),heltab2x32(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(111),n2h1(109))
  call Hloop_VA_Q(ntryL,G1H32(16),wf32(:,110),G1H1(1),m3h32x1(:,16),heltab2x32(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(112),n2h1(110))
  call Hloop_VA_Q(ntryL,G1H32(17),wf32(:,117),G1H1(1),m3h32x1(:,17),heltab2x32(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(113),n2h1(111))
  call Hloop_VA_Q(ntryL,G1H32(18),wf32(:,126),G1H1(1),m3h32x1(:,18),heltab2x32(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(114),n2h1(112))
  call Hloop_VA_Q(ntryL,G1H32(19),wf32(:,130),G1H1(1),m3h32x1(:,19),heltab2x32(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(115),n2h1(113))
  call ol_merge_tensors(G2tensor(89),[G2tensor(20),G2tensor(2),G1tensor(42),G1tensor(5),G0tensor(42),G0tensor(5)])
  call ol_merge_tensors(G2tensor(91),[G2tensor(90),G2tensor(35),G2tensor(4),G1tensor(62),G1tensor(10),G0tensor(62),G0tensor(10)])
  call ol_merge_tensors(G2tensor(92),[G2tensor(14),G2tensor(6),G1tensor(32),G1tensor(15),G0tensor(32),G0tensor(15)])
  call ol_merge_tensors(G2tensor(94),[G2tensor(93),G2tensor(26),G2tensor(8),G1tensor(52),G1tensor(20),G0tensor(52),G0tensor(20)])
  call ol_merge_tensors(G2tensor(103),[G2tensor(56),G2tensor(10),G1tensor(92),G1tensor(25),G0tensor(92),G0tensor(25)])
  call ol_merge_tensors(G2tensor(104),[G2tensor(65),G2tensor(12),G1tensor(107),G1tensor(30),G0tensor(107),G0tensor(30)])
  call ol_merge_tensors(G2tensor(24),[G2tensor(21),G2tensor(18),G2tensor(15),G1tensor(50),G1tensor(45),G1tensor(40),G1tensor(35) &
    ,G0tensor(50),G0tensor(45),G0tensor(40),G0tensor(35)])
  call ol_merge_tensors(G2tensor(84),[G2tensor(17),G1tensor(37),G1tensor(8),G0tensor(37),G0tensor(8)])
  call ol_merge_tensors(G2tensor(86),[G2tensor(23),G1tensor(47),G1tensor(18),G0tensor(47),G0tensor(18)])
  call ol_merge_tensors(G2tensor(42),[G2tensor(39),G2tensor(36),G2tensor(33),G2tensor(30),G2tensor(27),G1tensor(70),G1tensor(65) &
    ,G1tensor(60),G1tensor(55),G0tensor(70),G0tensor(65),G0tensor(60),G0tensor(55)])
  call ol_merge_tensors(G2tensor(83),[G2tensor(47),G2tensor(32),G2tensor(29),G1tensor(77),G1tensor(57),G1tensor(3),G0tensor(77) &
    ,G0tensor(57),G0tensor(3)])
  call ol_merge_tensors(G2tensor(85),[G2tensor(44),G2tensor(41),G2tensor(38),G1tensor(72),G1tensor(67),G1tensor(13),G0tensor(72) &
    ,G0tensor(67),G0tensor(13)])
  call ol_merge_tensors(G2tensor(48),[G2tensor(45),G1tensor(80),G1tensor(75),G0tensor(80),G0tensor(75)])
  call ol_merge_tensors(G2tensor(37),[G2tensor(50),G1tensor(82),G1tensor(24),G1tensor(9),G1tensor(4),G0tensor(82),G0tensor(24) &
    ,G0tensor(9),G0tensor(4)])
  call ol_merge_tensors(G2tensor(54),[G2tensor(51),G1tensor(90),G1tensor(85),G0tensor(90),G0tensor(85)])
  call ol_merge_tensors(G2tensor(7),[G2tensor(53),G1tensor(87),G1tensor(29),G1tensor(19),G1tensor(14),G0tensor(87),G0tensor(29) &
    ,G0tensor(19),G0tensor(14)])
  call ol_merge_tensors(G2tensor(60),[G2tensor(57),G1tensor(100),G1tensor(95),G0tensor(100),G0tensor(95)])
  call ol_merge_tensors(G2tensor(88),[G2tensor(62),G2tensor(59),G1tensor(102),G1tensor(97),G1tensor(28),G0tensor(102),G0tensor(97) &
    ,G0tensor(28)])
  call ol_merge_tensors(G2tensor(63),[G1tensor(105),G0tensor(105)])
  call ol_merge_tensors(G2tensor(69),[G2tensor(66),G1tensor(115),G1tensor(110),G0tensor(115),G0tensor(110)])
  call ol_merge_tensors(G2tensor(87),[G2tensor(71),G2tensor(68),G1tensor(117),G1tensor(112),G1tensor(23),G0tensor(117) &
    ,G0tensor(112),G0tensor(23)])
  call ol_merge_tensors(G2tensor(72),[G1tensor(120),G0tensor(120)])
  call ol_merge_tensors(G2tensor(5),[G2tensor(28),G1tensor(12),G1tensor(2),G0tensor(12),G0tensor(2)])
  call ol_merge_tensors(G2tensor(11),[G2tensor(9),G2tensor(3),G2tensor(1),G1tensor(17),G1tensor(7),G0tensor(17),G0tensor(7)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(22),G0tensor(22)])
  call ol_merge_tensors(G2tensor(16),[G1tensor(27),G0tensor(27)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(74),G1tensor(33),G0tensor(74),G0tensor(33)])
  call ol_merge_tensors(G2tensor(22),[G1tensor(109),G1tensor(89),G1tensor(54),G1tensor(34),G0tensor(109),G0tensor(89),G0tensor(54) &
    ,G0tensor(34)])
  call ol_merge_tensors(G2tensor(25),[G1tensor(38),G0tensor(38)])
  call ol_merge_tensors(G2tensor(31),[G1tensor(39),G0tensor(39)])
  call ol_merge_tensors(G2tensor(34),[G1tensor(79),G1tensor(43),G0tensor(79),G0tensor(43)])
  call ol_merge_tensors(G2tensor(40),[G1tensor(94),G1tensor(84),G1tensor(64),G1tensor(44),G0tensor(94),G0tensor(84),G0tensor(64) &
    ,G0tensor(44)])
  call ol_merge_tensors(G2tensor(43),[G1tensor(48),G0tensor(48)])
  call ol_merge_tensors(G2tensor(46),[G1tensor(49),G0tensor(49)])
  call ol_merge_tensors(G2tensor(49),[G1tensor(53),G0tensor(53)])
  call ol_merge_tensors(G2tensor(58),[G2tensor(52),G1tensor(58),G0tensor(58)])
  call ol_merge_tensors(G2tensor(61),[G2tensor(55),G1tensor(59),G0tensor(59)])
  call ol_merge_tensors(G2tensor(64),[G1tensor(63),G0tensor(63)])
  call ol_merge_tensors(G2tensor(73),[G2tensor(67),G1tensor(68),G0tensor(68)])
  call ol_merge_tensors(G2tensor(74),[G2tensor(70),G1tensor(69),G0tensor(69)])
  call ol_merge_tensors(G2tensor(75),[G1tensor(103),G1tensor(88),G1tensor(73),G0tensor(103),G0tensor(88),G0tensor(73)])
  call ol_merge_tensors(G2tensor(76),[G1tensor(118),G1tensor(83),G1tensor(78),G0tensor(118),G0tensor(83),G0tensor(78)])
  call ol_merge_tensors(G2tensor(77),[G1tensor(119),G1tensor(93),G0tensor(119),G0tensor(93)])
  call ol_merge_tensors(G2tensor(78),[G1tensor(98),G0tensor(98)])
  call ol_merge_tensors(G2tensor(79),[G1tensor(99),G0tensor(99)])
  call ol_merge_tensors(G2tensor(80),[G1tensor(108),G1tensor(104),G0tensor(108),G0tensor(104)])
  call ol_merge_tensors(G2tensor(81),[G1tensor(113),G0tensor(113)])
  call ol_merge_tensors(G2tensor(82),[G1tensor(114),G0tensor(114)])
  call ol_merge_tensors(G2tensor(115),[G2tensor(114),G2tensor(113),G2tensor(112),G2tensor(111),G2tensor(110),G2tensor(109) &
    ,G2tensor(108),G2tensor(107),G2tensor(106),G2tensor(105),G2tensor(102),G2tensor(101),G2tensor(100),G2tensor(99),G2tensor(98) &
    ,G2tensor(97),G2tensor(96),G2tensor(95)])
  call TI_triangle_red(G2tensor(89),RedBasis(1),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1)
  call TI_triangle_red(G2tensor(91),RedBasis(4),mass3set(:,1),G0tensor(21),G0tensor(26),G0tensor(31),G0tensor(36),M2L1R1)
  call TI_triangle_red(G2tensor(92),RedBasis(6),mass3set(:,1),G0tensor(41),G0tensor(46),G0tensor(51),G0tensor(56),M2L1R1)
  call TI_triangle_red(G2tensor(94),RedBasis(9),mass3set(:,1),G0tensor(61),G0tensor(66),G0tensor(71),G0tensor(76),M2L1R1)
  call TI_triangle_red(G2tensor(103),RedBasis(11),mass3set(:,1),G0tensor(81),G0tensor(86),G0tensor(91),G0tensor(96),M2L1R1)
  call TI_triangle_red(G2tensor(104),RedBasis(13),mass3set(:,1),G0tensor(101),G0tensor(106),G0tensor(111),G0tensor(116),M2L1R1)
  call TI_triangle_red(G2tensor(24),RedBasis(15),mass3set(:,1),G0tensor(42),G0tensor(5),G0tensor(62),G0tensor(10),M2L1R1)
  call TI_triangle_red(G2tensor(84),RedBasis(5),mass3set(:,1),G0tensor(32),G0tensor(15),G0tensor(52),G0tensor(20),M2L1R1)
  call TI_triangle_red(G2tensor(86),RedBasis(10),mass3set(:,1),G0tensor(92),G0tensor(25),G0tensor(107),G0tensor(30),M2L1R1)
  call TI_triangle_red(G2tensor(42),RedBasis(24),mass3set(:,1),G0tensor(50),G0tensor(45),G0tensor(40),G0tensor(35),M2L1R1)
  call TI_triangle_red(G2tensor(83),RedBasis(3),mass3set(:,1),G0tensor(37),G0tensor(8),G0tensor(47),G0tensor(18),M2L1R1)
  call TI_triangle_red(G2tensor(85),RedBasis(8),mass3set(:,1),G0tensor(70),G0tensor(65),G0tensor(60),G0tensor(55),M2L1R1)
  call TI_triangle_red(G2tensor(48),RedBasis(31),mass3set(:,1),G0tensor(77),G0tensor(57),G0tensor(3),G0tensor(72),M2L1R1)
  call TI_triangle_red(G2tensor(37),RedBasis(2),mass3set(:,1),G0tensor(67),G0tensor(13),G0tensor(80),G0tensor(75),M2L1R1)
  call TI_triangle_red(G2tensor(54),RedBasis(34),mass3set(:,1),G0tensor(82),G0tensor(24),G0tensor(9),G0tensor(4),M2L1R1)
  call TI_triangle_red(G2tensor(7),RedBasis(7),mass3set(:,1),G0tensor(90),G0tensor(85),G0tensor(87),G0tensor(29),M2L1R1)
  call TI_triangle_red(G2tensor(60),RedBasis(35),mass3set(:,1),G0tensor(19),G0tensor(14),G0tensor(100),G0tensor(95),M2L1R1)
  call TI_triangle_red(G2tensor(88),RedBasis(14),mass3set(:,1),G0tensor(102),G0tensor(97),G0tensor(28),G0tensor(105),M2L1R1)
  call TI_triangle_red(G2tensor(63),RedBasis(39),mass3set(:,1),G0tensor(115),G0tensor(110),G0tensor(117),G0tensor(112),M2L1R1)
  call TI_triangle_red(G2tensor(69),RedBasis(41),mass3set(:,1),G0tensor(23),G0tensor(120),G0tensor(12),G0tensor(2),M2L1R1)
  call TI_triangle_red(G2tensor(87),RedBasis(12),mass3set(:,1),G0tensor(17),G0tensor(7),G0tensor(22),G0tensor(27),M2L1R1)
  call TI_triangle_red(G2tensor(72),RedBasis(44),mass3set(:,1),G0tensor(74),G0tensor(33),G0tensor(109),G0tensor(89),M2L1R1)
  call TI_triangle_red(G2tensor(5),RedBasis(45),mass3set(:,1),G0tensor(54),G0tensor(34),G0tensor(38),G0tensor(39),M2L1R1)
  call TI_triangle_red(G2tensor(11),RedBasis(46),mass3set(:,1),G0tensor(79),G0tensor(43),G0tensor(94),G0tensor(84),M2L1R1)
  call TI_triangle_red(G2tensor(13),RedBasis(47),mass3set(:,1),G0tensor(64),G0tensor(44),G0tensor(48),G0tensor(49),M2L1R1)
  call TI_triangle_red(G2tensor(16),RedBasis(48),mass3set(:,1),G0tensor(53),G0tensor(58),G0tensor(59),G0tensor(63),M2L1R1)
  call TI_triangle_red(G2tensor(19),RedBasis(17),mass3set(:,1),G0tensor(68),G0tensor(69),G0tensor(103),G0tensor(88),M2L1R1)
  call TI_triangle_red(G2tensor(22),RedBasis(16),mass3set(:,1),G0tensor(73),G0tensor(118),G0tensor(83),G0tensor(78),M2L1R1)
  call TI_triangle_red(G2tensor(25),RedBasis(19),mass3set(:,1),G0tensor(119),G0tensor(93),G0tensor(98),G0tensor(99),M2L1R1)
  call TI_triangle_red(G2tensor(31),RedBasis(18),mass3set(:,1),G0tensor(108),G0tensor(104),G0tensor(113),G0tensor(114),M2L1R1)
  call TI_triangle_red(G2tensor(34),RedBasis(21),mass3set(:,1),G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124),M2L1R1)
  call TI_triangle_red(G2tensor(40),RedBasis(20),mass3set(:,1),G0tensor(125),G0tensor(126),G0tensor(127),G0tensor(128),M2L1R1)
  call TI_triangle_red(G2tensor(43),RedBasis(23),mass3set(:,1),G0tensor(129),G0tensor(130),G0tensor(131),G0tensor(132),M2L1R1)
  call TI_triangle_red(G2tensor(46),RedBasis(22),mass3set(:,1),G0tensor(133),G0tensor(134),G0tensor(135),G0tensor(136),M2L1R1)
  call TI_triangle_red(G2tensor(49),RedBasis(25),mass3set(:,1),G0tensor(137),G0tensor(138),G0tensor(139),G0tensor(140),M2L1R1)
  call TI_triangle_red(G2tensor(58),RedBasis(27),mass3set(:,1),G0tensor(141),G0tensor(142),G0tensor(143),G0tensor(144),M2L1R1)
  call TI_triangle_red(G2tensor(61),RedBasis(26),mass3set(:,1),G0tensor(145),G0tensor(146),G0tensor(147),G0tensor(148),M2L1R1)
  call TI_triangle_red(G2tensor(64),RedBasis(28),mass3set(:,1),G0tensor(149),G0tensor(150),G0tensor(151),G0tensor(152),M2L1R1)
  call TI_triangle_red(G2tensor(73),RedBasis(30),mass3set(:,1),G0tensor(153),G0tensor(154),G0tensor(155),G0tensor(156),M2L1R1)
  call TI_triangle_red(G2tensor(74),RedBasis(29),mass3set(:,1),G0tensor(157),G0tensor(158),G0tensor(159),G0tensor(160),M2L1R1)
  call TI_triangle_red(G2tensor(75),RedBasis(32),mass3set(:,1),G0tensor(161),G0tensor(162),G0tensor(163),G0tensor(164),M2L1R1)
  call TI_triangle_red(G2tensor(76),RedBasis(33),mass3set(:,1),G0tensor(165),G0tensor(166),G0tensor(167),G0tensor(168),M2L1R1)
  call TI_triangle_red(G2tensor(77),RedBasis(36),mass3set(:,1),G0tensor(169),G0tensor(170),G0tensor(171),G0tensor(172),M2L1R1)
  call TI_triangle_red(G2tensor(78),RedBasis(38),mass3set(:,1),G0tensor(173),G0tensor(174),G0tensor(175),G0tensor(176),M2L1R1)
  call TI_triangle_red(G2tensor(79),RedBasis(37),mass3set(:,1),G0tensor(177),G0tensor(178),G0tensor(179),G0tensor(180),M2L1R1)
  call TI_triangle_red(G2tensor(80),RedBasis(40),mass3set(:,1),G0tensor(181),G0tensor(182),G0tensor(183),G0tensor(184),M2L1R1)
  call TI_triangle_red(G2tensor(81),RedBasis(43),mass3set(:,1),G0tensor(185),G0tensor(186),G0tensor(187),G0tensor(188),M2L1R1)
  call TI_triangle_red(G2tensor(82),RedBasis(42),mass3set(:,1),G0tensor(189),G0tensor(190),G0tensor(191),G0tensor(192),M2L1R1)
  call TI_triangle_red(G2tensor(115),RedBasis(49),mass3set(:,1),G0tensor(193),G0tensor(194),G0tensor(195),G0tensor(196),M2L1R1)
  call ol_merge_tensors(T0sum(25),[G0tensor(1)])
  call ol_merge_tensors(T0sum(26),[G0tensor(21)])
  call ol_merge_tensors(T0sum(27),[G0tensor(41)])
  call ol_merge_tensors(T0sum(28),[G0tensor(61)])
  call ol_merge_tensors(T0sum(29),[G0tensor(81)])
  call ol_merge_tensors(T0sum(30),[G0tensor(101)])
  call ol_merge_tensors(T0sum(31),[G0tensor(42)])
  call ol_merge_tensors(T0sum(32),[G0tensor(32)])
  call ol_merge_tensors(T0sum(33),[G0tensor(92)])
  call ol_merge_tensors(T0sum(34),[G0tensor(50)])
  call ol_merge_tensors(T0sum(35),[G0tensor(37)])
  call ol_merge_tensors(T0sum(36),[G0tensor(70)])
  call ol_merge_tensors(T0sum(37),[G0tensor(77)])
  call ol_merge_tensors(T0sum(38),[G0tensor(67)])
  call ol_merge_tensors(T0sum(39),[G0tensor(82)])
  call ol_merge_tensors(T0sum(40),[G0tensor(90)])
  call ol_merge_tensors(T0sum(41),[G0tensor(19)])
  call ol_merge_tensors(T0sum(42),[G0tensor(102)])
  call ol_merge_tensors(T0sum(43),[G0tensor(115)])
  call ol_merge_tensors(T0sum(44),[G0tensor(23)])
  call ol_merge_tensors(T0sum(45),[G0tensor(17)])
  call ol_merge_tensors(T0sum(46),[G0tensor(74)])
  call ol_merge_tensors(T0sum(47),[G0tensor(54)])
  call ol_merge_tensors(T0sum(48),[G0tensor(79)])
  call ol_merge_tensors(T0sum(49),[G0tensor(64)])
  call ol_merge_tensors(T0sum(50),[G0tensor(53)])
  call ol_merge_tensors(T0sum(51),[G0tensor(68)])
  call ol_merge_tensors(T0sum(52),[G0tensor(73)])
  call ol_merge_tensors(T0sum(53),[G0tensor(119)])
  call ol_merge_tensors(T0sum(54),[G0tensor(108)])
  call ol_merge_tensors(T0sum(55),[G0tensor(121)])
  call ol_merge_tensors(T0sum(56),[G0tensor(125)])
  call ol_merge_tensors(T0sum(57),[G0tensor(129)])
  call ol_merge_tensors(T0sum(58),[G0tensor(133)])
  call ol_merge_tensors(T0sum(59),[G0tensor(137)])
  call ol_merge_tensors(T0sum(60),[G0tensor(141)])
  call ol_merge_tensors(T0sum(61),[G0tensor(145)])
  call ol_merge_tensors(T0sum(62),[G0tensor(149)])
  call ol_merge_tensors(T0sum(63),[G0tensor(153)])
  call ol_merge_tensors(T0sum(64),[G0tensor(157)])
  call ol_merge_tensors(T0sum(65),[G0tensor(161)])
  call ol_merge_tensors(T0sum(66),[G0tensor(165)])
  call ol_merge_tensors(T0sum(67),[G0tensor(169)])
  call ol_merge_tensors(T0sum(68),[G0tensor(173)])
  call ol_merge_tensors(T0sum(69),[G0tensor(177)])
  call ol_merge_tensors(T0sum(70),[G0tensor(181)])
  call ol_merge_tensors(T0sum(71),[G0tensor(185)])
  call ol_merge_tensors(T0sum(72),[G0tensor(189)])
  call ol_merge_tensors(T0sum(73),[G0tensor(193)])
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(230)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(244),h0tab(:,244),[92,35],[0,0],2,2,wf16(:,76),wf8(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,76),G0H8(1),m3h16x8(:,33),heltab2x128(:,:,244))
  call Hloop_Q_A(ntryL,G0H8(1),92,0,G1H8(15),n2h8(61))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(231)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(245),h0tab(:,245),[92,35],[0,0],2,2,wf16(:,77),wf8(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,77),G0H8(1),m3h16x8(:,34),heltab2x128(:,:,245))
  call Hloop_Q_A(ntryL,G0H8(1),92,0,G1H8(14),n2h8(62))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(532)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(246),h0tab(:,246),[80,47],[0,0],2,2,wf4(:,12),wf32(:,8))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,12),G0H32(1),m3h4x32(:,49),heltab2x128(:,:,246))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(533)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(247),h0tab(:,247),[80,47],[0,0],2,2,wf4(:,12),wf32(:,10))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,12),G0H32(2),m3h4x32(:,50),heltab2x128(:,:,247))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(248),h0tab(:,248),[83,44],[0,0],2,2,wf16(:,75),wf8(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,75),G0H8(1),m3h16x8(:,35),heltab2x128(:,:,248))
  call Hloop_Q_A(ntryL,G0H8(1),83,0,G1H8(18),n2h8(63))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(249),h0tab(:,249),[83,44],[0,0],2,2,wf16(:,75),wf8(:,6))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,75),G0H8(1),m3h16x8(:,36),heltab2x128(:,:,249))
  call Hloop_Q_A(ntryL,G0H8(1),83,0,G1H8(9),n2h8(64))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(534)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(250),h0tab(:,250),[80,47],[0,0],2,2,wf4(:,12),wf32(:,16))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,12),G0H32(3),m3h4x32(:,51),heltab2x128(:,:,250))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(535)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(251),h0tab(:,251),[80,47],[0,0],2,2,wf4(:,12),wf32(:,18))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,12),G0H32(4),m3h4x32(:,52),heltab2x128(:,:,251))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(536)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(252),h0tab(:,252),[96,31],[0,0],2,2,wf4(:,16),wf32(:,4))
  call Hloop_QA_V(ntryL,G0H128(1),wf4(:,16),G0H32(5),m3h4x32(:,53),heltab2x128(:,:,252))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(537)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(253),h0tab(:,253),[96,31],[0,0],2,2,wf4(:,16),wf32(:,6))
  call Hloop_QA_V(ntryL,G0H128(1),wf4(:,16),G0H32(6),m3h4x32(:,54),heltab2x128(:,:,253))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(254),h0tab(:,254),[108,19],[0,0],2,2,wf16(:,82),wf8(:,8))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,82),G0H8(1),m3h16x8(:,37),heltab2x128(:,:,254))
  call Hloop_A_Q(ntryL,G0H8(1),108,0,G1H8(23),n2h8(65))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(255),h0tab(:,255),[108,19],[0,0],2,2,wf16(:,83),wf8(:,8))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,83),G0H8(1),m3h16x8(:,38),heltab2x128(:,:,255))
  call Hloop_A_Q(ntryL,G0H8(1),108,0,G1H8(12),n2h8(66))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(538)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(256),h0tab(:,256),[96,31],[0,0],2,2,wf4(:,16),wf32(:,12))
  call Hloop_QA_V(ntryL,G0H128(1),wf4(:,16),G0H32(7),m3h4x32(:,55),heltab2x128(:,:,256))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(539)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(257),h0tab(:,257),[96,31],[0,0],2,2,wf4(:,16),wf32(:,14))
  call Hloop_QA_V(ntryL,G0H128(1),wf4(:,16),G0H32(8),m3h4x32(:,56),heltab2x128(:,:,257))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(236)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(258),h0tab(:,258),[99,28],[0,0],2,2,wf16(:,81),wf8(:,10))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,81),G0H8(1),m3h16x8(:,39),heltab2x128(:,:,258))
  call Hloop_A_Q(ntryL,G0H8(1),99,0,G1H8(28),n2h8(67))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(237)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(259),h0tab(:,259),[99,28],[0,0],2,2,wf16(:,81),wf8(:,12))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,81),G0H8(1),m3h16x8(:,40),heltab2x128(:,:,259))
  call Hloop_A_Q(ntryL,G0H8(1),99,0,G1H8(54),n2h8(68))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(254)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(260),h0tab(:,260),[83,44],[0,0],2,2,wf16(:,143),wf8(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,143),G0H8(1),m3h16x8(:,41),heltab2x128(:,:,260))
  call Hloop_Q_A(ntryL,G0H8(1),83,0,G1H8(53),n2h8(69))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(255)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(261),h0tab(:,261),[83,44],[0,0],2,2,wf16(:,143),wf8(:,6))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,143),G0H8(1),m3h16x8(:,42),heltab2x128(:,:,261))
  call Hloop_Q_A(ntryL,G0H8(1),83,0,G1H8(49),n2h8(70))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(247)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(262),h0tab(:,262),[108,19],[0,0],2,2,wf16(:,138),wf8(:,8))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,138),G0H8(1),m3h16x8(:,43),heltab2x128(:,:,262))
  call Hloop_A_Q(ntryL,G0H8(1),108,0,G1H8(33),n2h8(71))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(249)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(263),h0tab(:,263),[108,19],[0,0],2,2,wf16(:,140),wf8(:,8))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,140),G0H8(1),m3h16x8(:,44),heltab2x128(:,:,263))
  call Hloop_A_Q(ntryL,G0H8(1),108,0,G1H8(52),n2h8(72))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(257)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(264),h0tab(:,264),[92,35],[0,0],2,2,wf16(:,144),wf8(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,144),G0H8(1),m3h16x8(:,45),heltab2x128(:,:,264))
  call Hloop_Q_A(ntryL,G0H8(1),92,0,G1H8(51),n2h8(73))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(259)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(265),h0tab(:,265),[92,35],[0,0],2,2,wf16(:,145),wf8(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,145),G0H8(1),m3h16x8(:,46),heltab2x128(:,:,265))
  call Hloop_Q_A(ntryL,G0H8(1),92,0,G1H8(50),n2h8(74))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(251)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(266),h0tab(:,266),[99,28],[0,0],2,2,wf16(:,142),wf8(:,10))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,142),G0H8(1),m3h16x8(:,47),heltab2x128(:,:,266))
  call Hloop_A_Q(ntryL,G0H8(1),99,0,G1H8(38),n2h8(75))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(252)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(267),h0tab(:,267),[99,28],[0,0],2,2,wf16(:,142),wf8(:,12))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,142),G0H8(1),m3h16x8(:,48),heltab2x128(:,:,267))
  call Hloop_A_Q(ntryL,G0H8(1),99,0,G1H8(44),n2h8(76))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(268),h0tab(:,268),[108,19],[0,0],2,2,wf16(:,146),wf8(:,8))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,146),G0H8(1),m3h16x8(:,49),heltab2x128(:,:,268))
  call Hloop_A_Q(ntryL,G0H8(1),108,0,G1H8(19),n2h8(77))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(263)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(269),h0tab(:,269),[108,19],[0,0],2,2,wf16(:,147),wf8(:,8))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,147),G0H8(1),m3h16x8(:,50),heltab2x128(:,:,269))
  call Hloop_A_Q(ntryL,G0H8(1),108,0,G1H8(20),n2h8(78))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(270),h0tab(:,270),[92,35],[0,0],2,2,wf16(:,148),wf8(:,2))
  call Hloop_AQ_V(ntryL,G0H128(1),wf16(:,148),G0H8(1),m3h16x8(:,51),heltab2x128(:,:,270))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(267)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(271),h0tab(:,271),[92,35],[0,0],2,2,wf16(:,149),wf8(:,2))
  call Hloop_AQ_V(ntryL,G0H128(1),wf16(:,149),G0H8(2),m3h16x8(:,52),heltab2x128(:,:,271))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(272),h0tab(:,272),[108,19],[0,0],2,2,wf16(:,150),wf8(:,8))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,150),G0H8(3),m3h16x8(:,53),heltab2x128(:,:,272))
  call Hloop_A_Q(ntryL,G0H8(3),108,0,G1H8(48),n2h8(79))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(273),h0tab(:,273),[108,19],[0,0],2,2,wf16(:,151),wf8(:,8))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,151),G0H8(3),m3h16x8(:,54),heltab2x128(:,:,273))
  call Hloop_A_Q(ntryL,G0H8(3),108,0,G1H8(21),n2h8(80))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(274),h0tab(:,274),[92,35],[0,0],2,2,wf16(:,152),wf8(:,2))
  call Hloop_AQ_V(ntryL,G0H128(1),wf16(:,152),G0H8(3),m3h16x8(:,55),heltab2x128(:,:,274))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(275),h0tab(:,275),[92,35],[0,0],2,2,wf16(:,153),wf8(:,2))
  call Hloop_AQ_V(ntryL,G0H128(1),wf16(:,153),G0H8(4),m3h16x8(:,56),heltab2x128(:,:,275))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(540)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(276),h0tab(:,276),[80,47],[0,0],2,2,wf4(:,12),wf32(:,36))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,12),G0H32(9),m3h4x32(:,57),heltab2x128(:,:,276))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(541)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(277),h0tab(:,277),[80,47],[0,0],2,2,wf4(:,12),wf32(:,38))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,12),G0H32(10),m3h4x32(:,58),heltab2x128(:,:,277))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(542)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(278),h0tab(:,278),[80,47],[0,0],2,2,wf4(:,12),wf32(:,47))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,12),G0H32(11),m3h4x32(:,59),heltab2x128(:,:,278))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(543)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(279),h0tab(:,279),[80,47],[0,0],2,2,wf4(:,12),wf32(:,49))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,12),G0H32(12),m3h4x32(:,60),heltab2x128(:,:,279))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(544)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(280),h0tab(:,280),[96,31],[0,0],2,2,wf4(:,16),wf32(:,32))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(13),m3h4x32(:,61),heltab2x128(:,:,280))
  call Hloop_A_Q(ntryL,G0H32(13),96,0,G1H32(20),n2h32(49))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(545)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(281),h0tab(:,281),[96,31],[0,0],2,2,wf4(:,16),wf32(:,34))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(13),m3h4x32(:,62),heltab2x128(:,:,281))
  call Hloop_A_Q(ntryL,G0H32(13),96,0,G1H32(21),n2h32(50))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(546)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(282),h0tab(:,282),[96,31],[0,0],2,2,wf4(:,16),wf32(:,43))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(13),m3h4x32(:,63),heltab2x128(:,:,282))
  call Hloop_A_Q(ntryL,G0H32(13),96,0,G1H32(22),n2h32(51))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(547)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(283),h0tab(:,283),[96,31],[0,0],2,2,wf4(:,16),wf32(:,45))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(13),m3h4x32(:,64),heltab2x128(:,:,283))
  call Hloop_A_Q(ntryL,G0H32(13),96,0,G1H32(23),n2h32(52))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(292)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(284),h0tab(:,284),[86,41],[0,0],2,2,wf16(:,108),wf8(:,42))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,108),G0H8(5),m3h16x8(:,57),heltab2x128(:,:,284))
  call Hloop_Q_A(ntryL,G0H8(5),86,0,G1H8(25),n2h8(81))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(548)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(285),h0tab(:,285),[80,47],[0,0],2,2,wf4(:,12),wf32(:,54))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,12),G0H32(13),m3h4x32(:,65),heltab2x128(:,:,285))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(549)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(286),h0tab(:,286),[80,47],[0,0],2,2,wf4(:,12),wf32(:,66))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,12),G0H32(14),m3h4x32(:,66),heltab2x128(:,:,286))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(550)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(287),h0tab(:,287),[80,47],[0,0],2,2,wf4(:,12),wf32(:,68))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,12),G0H32(15),m3h4x32(:,67),heltab2x128(:,:,287))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(551)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(288),h0tab(:,288),[96,31],[0,0],2,2,wf4(:,16),wf32(:,58))
  call Hloop_QA_V(ntryL,G0H128(1),wf4(:,16),G0H32(16),m3h4x32(:,68),heltab2x128(:,:,288))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(295)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(289),h0tab(:,289),[105,22],[0,0],2,2,wf16(:,112),wf8(:,44))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,112),G0H8(5),m3h16x8(:,58),heltab2x128(:,:,289))
  call Hloop_A_Q(ntryL,G0H8(5),105,0,G1H8(56),n2h8(82))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(552)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(290),h0tab(:,290),[96,31],[0,0],2,2,wf4(:,16),wf32(:,62))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(17),m3h4x32(:,69),heltab2x128(:,:,290))
  call Hloop_A_Q(ntryL,G0H32(17),96,0,G1H32(24),n2h32(53))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(553)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(291),h0tab(:,291),[96,31],[0,0],2,2,wf4(:,16),wf32(:,64))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(17),m3h4x32(:,70),heltab2x128(:,:,291))
  call Hloop_A_Q(ntryL,G0H32(17),96,0,G1H32(25),n2h32(54))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(305)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(292),h0tab(:,292),[86,41],[0,0],2,2,wf16(:,164),wf8(:,42))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,164),G0H8(5),m3h16x8(:,59),heltab2x128(:,:,292))
  call Hloop_Q_A(ntryL,G0H8(5),86,0,G1H8(55),n2h8(83))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(303)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(293),h0tab(:,293),[105,22],[0,0],2,2,wf16(:,163),wf8(:,44))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,163),G0H8(5),m3h16x8(:,60),heltab2x128(:,:,293))
  call Hloop_A_Q(ntryL,G0H8(5),105,0,G1H8(43),n2h8(84))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(299)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(294),h0tab(:,294),[86,41],[0,0],2,2,wf16(:,159),wf8(:,42))
  call Hloop_AQ_V(ntryL,G0H128(1),wf16(:,159),G0H8(5),m3h16x8(:,61),heltab2x128(:,:,294))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(295),h0tab(:,295),[105,22],[0,0],2,2,wf16(:,161),wf8(:,44))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,161),G0H8(6),m3h16x8(:,62),heltab2x128(:,:,295))
  call Hloop_A_Q(ntryL,G0H8(6),105,0,G1H8(37),n2h8(85))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(307)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(296),h0tab(:,296),[105,22],[0,0],2,2,wf16(:,165),wf8(:,44))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,165),G0H8(6),m3h16x8(:,63),heltab2x128(:,:,296))
  call Hloop_A_Q(ntryL,G0H8(6),105,0,G1H8(34),n2h8(86))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(554)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(297),h0tab(:,297),[80,47],[0,0],2,2,wf4(:,12),wf32(:,81))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,12),G0H32(17),m3h4x32(:,71),heltab2x128(:,:,297))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(555)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(298),h0tab(:,298),[80,47],[0,0],2,2,wf4(:,12),wf32(:,83))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,12),G0H32(18),m3h4x32(:,72),heltab2x128(:,:,298))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(556)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(299),h0tab(:,299),[80,47],[0,0],2,2,wf4(:,12),wf32(:,90))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,12),G0H32(19),m3h4x32(:,73),heltab2x128(:,:,299))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(557)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(300),h0tab(:,300),[96,31],[0,0],2,2,wf4(:,16),wf32(:,77))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(20),m3h4x32(:,74),heltab2x128(:,:,300))
  call Hloop_A_Q(ntryL,G0H32(20),96,0,G1H32(26),n2h32(55))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(558)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(301),h0tab(:,301),[96,31],[0,0],2,2,wf4(:,16),wf32(:,79))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(20),m3h4x32(:,75),heltab2x128(:,:,301))
  call Hloop_A_Q(ntryL,G0H32(20),96,0,G1H32(27),n2h32(56))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(559)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(302),h0tab(:,302),[96,31],[0,0],2,2,wf4(:,16),wf32(:,88))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(20),m3h4x32(:,76),heltab2x128(:,:,302))
  call Hloop_A_Q(ntryL,G0H32(20),96,0,G1H32(28),n2h32(57))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(318)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(303),h0tab(:,303),[86,41],[0,0],2,2,wf16(:,168),wf8(:,42))
  call Hloop_AQ_V(ntryL,G0H128(1),wf16(:,168),G0H8(6),m3h16x8(:,64),heltab2x128(:,:,303))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(560)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(304),h0tab(:,304),[80,47],[0,0],2,2,wf4(:,12),wf32(:,108))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,12),G0H32(20),m3h4x32(:,77),heltab2x128(:,:,304))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(561)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(305),h0tab(:,305),[80,47],[0,0],2,2,wf4(:,12),wf32(:,110))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,12),G0H32(21),m3h4x32(:,78),heltab2x128(:,:,305))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(562)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(306),h0tab(:,306),[80,47],[0,0],2,2,wf4(:,12),wf32(:,117))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,12),G0H32(22),m3h4x32(:,79),heltab2x128(:,:,306))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(563)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(307),h0tab(:,307),[96,31],[0,0],2,2,wf4(:,16),wf32(:,104))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(23),m3h4x32(:,80),heltab2x128(:,:,307))
  call Hloop_A_Q(ntryL,G0H32(23),96,0,G1H32(29),n2h32(58))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(564)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(308),h0tab(:,308),[96,31],[0,0],2,2,wf4(:,16),wf32(:,106))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(23),m3h4x32(:,81),heltab2x128(:,:,308))
  call Hloop_A_Q(ntryL,G0H32(23),96,0,G1H32(30),n2h32(59))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(565)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(309),h0tab(:,309),[96,31],[0,0],2,2,wf4(:,16),wf32(:,115))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(23),m3h4x32(:,82),heltab2x128(:,:,309))
  call Hloop_A_Q(ntryL,G0H32(23),96,0,G1H32(31),n2h32(60))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(566)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(310),h0tab(:,310),[80,47],[0,0],2,2,wf4(:,12),wf32(:,126))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,12),G0H32(23),m3h4x32(:,83),heltab2x128(:,:,310))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(567)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(311),h0tab(:,311),[80,47],[0,0],2,2,wf4(:,12),wf32(:,130))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,12),G0H32(24),m3h4x32(:,84),heltab2x128(:,:,311))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(568)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(312),h0tab(:,312),[96,31],[0,0],2,2,wf4(:,16),wf32(:,124))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(25),m3h4x32(:,85),heltab2x128(:,:,312))
  call Hloop_A_Q(ntryL,G0H32(25),96,0,G1H32(32),n2h32(61))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(569)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(313),h0tab(:,313),[96,31],[0,0],2,2,wf4(:,16),wf32(:,128))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,16),G0H32(25),m3h4x32(:,86),heltab2x128(:,:,313))
  call Hloop_A_Q(ntryL,G0H32(25),96,0,G1H32(33),n2h32(62))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(50),[G1H8(51),G1H8(14),G1H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(53),[G1H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(49),[G1H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(21),[G1H8(48),G1H8(20),G1H8(19),G1H8(52),G1H8(33) &
    ,G1H8(12),G1H8(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(38),[G1H8(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(44),[G1H8(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(4),[G0H8(3),G0H8(2),G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(55),[G1H8(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(34),[G1H8(37),G1H8(43),G1H8(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(6),[G0H8(5)])
  call Hcheck_last_QA_V(ntryL,l_switch,G1H8(50),wf8(:,2),G1tensor(1),m3h8x1(:,49),heltab2x8(:,:,89))
  call Hloop_VA_Q(ntryL,G0H32(1),wf32(:,8),G0H1(1),m3h32x1(:,20),heltab2x32(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,0,G1tensor(6),n2h1(114))
  call Hloop_VA_Q(ntryL,G0H32(2),wf32(:,10),G0H1(1),m3h32x1(:,21),heltab2x32(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,0,G1tensor(11),n2h1(115))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H8(53),wf8(:,4),G1tensor(16),m3h8x1(:,50),heltab2x8(:,:,90))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H8(49),wf8(:,6),G1tensor(21),m3h8x1(:,51),heltab2x8(:,:,91))
  call Hloop_VA_Q(ntryL,G0H32(3),wf32(:,16),G0H1(1),m3h32x1(:,22),heltab2x32(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,0,G1tensor(26),n2h1(116))
  call Hloop_VA_Q(ntryL,G0H32(4),wf32(:,18),G0H1(1),m3h32x1(:,23),heltab2x32(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),127,0,G1tensor(31),n2h1(117))



end subroutine vamp_1

end module ol_vamp_1_pplllla_nenexeexuuxa_1_/**/REALKIND
