
module ol_vamp_1_pplllla_eexmmxbbxa_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pplllla_eexmmxbbxa_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pplllla_eexmmxbbxa_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pplllla_eexmmxbbxa_1_/**/DREALKIND
  use ol_tensor_sum_storage_pplllla_eexmmxbbxa_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red

  use ol_loop_storage_pplllla_eexmmxbbxa_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pplllla_eexmmxbbxa_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(681)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1),h0tab(:,1),[80,12,3,32],[nMB,nMB,nMB,0],4,3,wf4(:,4),wf4(:,2),wf4(: &
    ,1))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,1),heltab2x128(:,:,1))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(1),n2h32(1))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(682)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(2),h0tab(:,2),[80,12,3,32],[nMB,nMB,nMB,0],4,3,wf4(:,4),wf4(:,6),wf4(: &
    ,1))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,2),heltab2x128(:,:,2))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(2),n2h32(2))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(683)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(3),h0tab(:,3),[80,12,3,32],[nMB,nMB,nMB,0],4,3,wf4(:,4),wf4(:,2),wf4(: &
    ,8))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,3),heltab2x128(:,:,3))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(3),n2h32(3))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(684)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(4),h0tab(:,4),[80,12,3,32],[nMB,nMB,nMB,0],4,3,wf4(:,4),wf4(:,6),wf4(: &
    ,8))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,4),heltab2x128(:,:,4))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(4),n2h32(4))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(681)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(5),h0tab(:,5),[80,3,12,32],[nMB,nMB,nMB,0],4,3,wf4(:,4),wf4(:,1),wf4(: &
    ,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,5),heltab2x128(:,:,5))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(5),n2h32(5))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(682)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(6),h0tab(:,6),[80,3,12,32],[nMB,nMB,nMB,0],4,3,wf4(:,4),wf4(:,1),wf4(: &
    ,6))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,6),heltab2x128(:,:,6))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(6),n2h32(6))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(683)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(7),h0tab(:,7),[80,3,12,32],[nMB,nMB,nMB,0],4,3,wf4(:,4),wf4(:,8),wf4(: &
    ,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,7),heltab2x128(:,:,7))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(7),n2h32(7))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(684)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(8),h0tab(:,8),[80,3,12,32],[nMB,nMB,nMB,0],4,3,wf4(:,4),wf4(:,8),wf4(: &
    ,6))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,8),heltab2x128(:,:,8))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(8),n2h32(8))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(693)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(9),h0tab(:,9),[96,12,3,16],[nMB,nMB,nMB,0],4,3,wf4(:,10),wf4(:,2),wf4(: &
    ,1))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,9),heltab2x128(:,:,9))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(9),n2h32(9))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(694)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(10),h0tab(:,10),[96,12,3,16],[nMB,nMB,nMB,0],4,3,wf4(:,10),wf4(:,6),wf4(: &
    ,1))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,10),heltab2x128(:,:,10))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(10),n2h32(10))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(695)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(11),h0tab(:,11),[96,12,3,16],[nMB,nMB,nMB,0],4,3,wf4(:,10),wf4(:,2),wf4(: &
    ,8))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,11),heltab2x128(:,:,11))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(11),n2h32(11))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(696)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(12),h0tab(:,12),[96,12,3,16],[nMB,nMB,nMB,0],4,3,wf4(:,10),wf4(:,6),wf4(: &
    ,8))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,12),heltab2x128(:,:,12))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(12),n2h32(12))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(693)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(13),h0tab(:,13),[96,3,12,16],[nMB,nMB,nMB,0],4,3,wf4(:,10),wf4(:,1),wf4(: &
    ,2))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,13),heltab2x128(:,:,13))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(13),n2h32(13))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(694)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(14),h0tab(:,14),[96,3,12,16],[nMB,nMB,nMB,0],4,3,wf4(:,10),wf4(:,1),wf4(: &
    ,6))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,14),heltab2x128(:,:,14))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(14),n2h32(14))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(695)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(15),h0tab(:,15),[96,3,12,16],[nMB,nMB,nMB,0],4,3,wf4(:,10),wf4(:,8),wf4(: &
    ,2))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,15),heltab2x128(:,:,15))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(15),n2h32(15))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(696)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(16),h0tab(:,16),[96,3,12,16],[nMB,nMB,nMB,0],4,3,wf4(:,10),wf4(:,8),wf4(: &
    ,6))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,16),heltab2x128(:,:,16))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(16),n2h32(16))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(470)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(17),h0tab(:,17),[64,12,19,32],[nMB,nMB,0,nMB],4,2,wf4(:,2),wf8(:,11))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1),heltab2x128(:,:,17))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(1),n2h64(1))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(473)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(18),h0tab(:,18),[64,12,19,32],[nMB,nMB,0,nMB],4,2,wf4(:,6),wf8(:,11))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,2),heltab2x128(:,:,18))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(2),n2h64(2))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(475)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(19),h0tab(:,19),[64,12,19,32],[nMB,nMB,0,nMB],4,2,wf4(:,2),wf8(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,3),heltab2x128(:,:,19))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(3),n2h64(3))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(477)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(20),h0tab(:,20),[64,12,19,32],[nMB,nMB,0,nMB],4,2,wf4(:,6),wf8(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,4),heltab2x128(:,:,20))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(4),n2h64(4))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(470)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(21),h0tab(:,21),[64,12,32,19],[nMB,nMB,0,nMB],4,2,wf4(:,2),wf8(:,11))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,5),heltab2x128(:,:,21))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(5),n2h64(5))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(473)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(22),h0tab(:,22),[64,12,32,19],[nMB,nMB,0,nMB],4,2,wf4(:,6),wf8(:,11))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,6),heltab2x128(:,:,22))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(6),n2h64(6))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(475)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(23),h0tab(:,23),[64,12,32,19],[nMB,nMB,0,nMB],4,2,wf4(:,2),wf8(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,7),heltab2x128(:,:,23))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(7),n2h64(7))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(477)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(24),h0tab(:,24),[64,12,32,19],[nMB,nMB,0,nMB],4,2,wf4(:,6),wf8(:,13))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,8),heltab2x128(:,:,24))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(8),n2h64(8))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(479)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(25),h0tab(:,25),[64,12,35,16],[nMB,nMB,0,nMB],4,2,wf4(:,2),wf8(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,9),heltab2x128(:,:,25))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(9),n2h64(9))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(482)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(26),h0tab(:,26),[64,12,35,16],[nMB,nMB,0,nMB],4,2,wf4(:,6),wf8(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,10),heltab2x128(:,:,26))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(10),n2h64(10))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(484)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(27),h0tab(:,27),[64,12,35,16],[nMB,nMB,0,nMB],4,2,wf4(:,2),wf8(:,4))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,11),heltab2x128(:,:,27))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(11),n2h64(11))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(486)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(28),h0tab(:,28),[64,12,35,16],[nMB,nMB,0,nMB],4,2,wf4(:,6),wf8(:,4))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,12),heltab2x128(:,:,28))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(12),n2h64(12))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(479)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(29),h0tab(:,29),[64,12,16,35],[nMB,nMB,0,nMB],4,2,wf4(:,2),wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,13),heltab2x128(:,:,29))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(13),n2h64(13))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(482)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(30),h0tab(:,30),[64,12,16,35],[nMB,nMB,0,nMB],4,2,wf4(:,6),wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,14),heltab2x128(:,:,30))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(14),n2h64(14))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(484)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(31),h0tab(:,31),[64,12,16,35],[nMB,nMB,0,nMB],4,2,wf4(:,2),wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,15),heltab2x128(:,:,31))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(15),n2h64(15))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(486)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(32),h0tab(:,32),[64,12,16,35],[nMB,nMB,0,nMB],4,2,wf4(:,6),wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,16),heltab2x128(:,:,32))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(16),n2h64(16))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(488)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(33),h0tab(:,33),[64,3,28,32],[nMB,nMB,0,nMB],4,2,wf4(:,1),wf8(:,15))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,17),heltab2x128(:,:,33))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(17),n2h64(17))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(490)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(34),h0tab(:,34),[64,3,28,32],[nMB,nMB,0,nMB],4,2,wf4(:,1),wf8(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,18),heltab2x128(:,:,34))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(18),n2h64(18))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(492)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(35),h0tab(:,35),[64,3,28,32],[nMB,nMB,0,nMB],4,2,wf4(:,8),wf8(:,15))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,19),heltab2x128(:,:,35))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(19),n2h64(19))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(494)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(36),h0tab(:,36),[64,3,28,32],[nMB,nMB,0,nMB],4,2,wf4(:,8),wf8(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,20),heltab2x128(:,:,36))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(20),n2h64(20))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(488)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(37),h0tab(:,37),[64,3,32,28],[nMB,nMB,0,nMB],4,2,wf4(:,1),wf8(:,15))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,21),heltab2x128(:,:,37))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(21),n2h64(21))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(490)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(38),h0tab(:,38),[64,3,32,28],[nMB,nMB,0,nMB],4,2,wf4(:,1),wf8(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,22),heltab2x128(:,:,38))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(22),n2h64(22))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(492)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(39),h0tab(:,39),[64,3,32,28],[nMB,nMB,0,nMB],4,2,wf4(:,8),wf8(:,15))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,23),heltab2x128(:,:,39))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(23),n2h64(23))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(494)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(40),h0tab(:,40),[64,3,32,28],[nMB,nMB,0,nMB],4,2,wf4(:,8),wf8(:,17))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,24),heltab2x128(:,:,40))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(24),n2h64(24))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(496)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(41),h0tab(:,41),[64,3,44,16],[nMB,nMB,0,nMB],4,2,wf4(:,1),wf8(:,6))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,25),heltab2x128(:,:,41))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(25),n2h64(25))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(498)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(42),h0tab(:,42),[64,3,44,16],[nMB,nMB,0,nMB],4,2,wf4(:,1),wf8(:,8))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,26),heltab2x128(:,:,42))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(26),n2h64(26))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(500)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(43),h0tab(:,43),[64,3,44,16],[nMB,nMB,0,nMB],4,2,wf4(:,8),wf8(:,6))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,27),heltab2x128(:,:,43))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(27),n2h64(27))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(502)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(44),h0tab(:,44),[64,3,44,16],[nMB,nMB,0,nMB],4,2,wf4(:,8),wf8(:,8))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,28),heltab2x128(:,:,44))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(28),n2h64(28))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(496)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(45),h0tab(:,45),[64,3,16,44],[nMB,nMB,0,nMB],4,2,wf4(:,1),wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,29),heltab2x128(:,:,45))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(29),n2h64(29))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(498)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(46),h0tab(:,46),[64,3,16,44],[nMB,nMB,0,nMB],4,2,wf4(:,1),wf8(:,8))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,30),heltab2x128(:,:,46))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(30),n2h64(30))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(500)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(47),h0tab(:,47),[64,3,16,44],[nMB,nMB,0,nMB],4,2,wf4(:,8),wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,31),heltab2x128(:,:,47))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(31),n2h64(31))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(502)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(48),h0tab(:,48),[64,3,16,44],[nMB,nMB,0,nMB],4,2,wf4(:,8),wf8(:,8))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,32),heltab2x128(:,:,48))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(32),n2h64(32))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(49),h0tab(:,49),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,5))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,33),heltab2x128(:,:,49))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(33),n2h64(33))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(50),h0tab(:,50),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,5))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,34),heltab2x128(:,:,50))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(34),n2h64(34))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(721)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(51),h0tab(:,51),[76,3,16,32],[nMB,nMB,0,nMB],4,2,wf8(:,39),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,39),G0H16(1),m3h8x16(:,1),heltab2x128(:,:,51))
  call Hloop_A_Q(ntryL,G0H16(1),76,nMB,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(722)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(52),h0tab(:,52),[76,3,16,32],[nMB,nMB,0,nMB],4,2,wf8(:,24),wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,24),G0H16(1),ngZd,m3h8x16(:,2),heltab2x128(:,:,52))
  call Hloop_A_Q(ntryL,G0H16(1),76,nMB,G1H16(2),n2h16(2))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(723)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(53),h0tab(:,53),[76,3,16,32],[nMB,nMB,0,nMB],4,2,wf8(:,39),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,39),G0H16(1),m3h8x16(:,3),heltab2x128(:,:,53))
  call Hloop_A_Q(ntryL,G0H16(1),76,nMB,G1H16(3),n2h16(3))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(514)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(54),h0tab(:,54),[76,3,16,32],[nMB,nMB,0,nMB],4,2,wf8(:,24),wf4(:,8))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,24),G0H16(1),ngZd,m3h8x16(:,4),heltab2x128(:,:,54))
  call Hloop_A_Q(ntryL,G0H16(1),76,nMB,G1H16(4),n2h16(4))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(721)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(55),h0tab(:,55),[76,3,32,16],[nMB,nMB,0,nMB],4,2,wf8(:,39),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),wf8(:,39),G0H16(1),m3h8x16(:,5),heltab2x128(:,:,55))
  call Hloop_Q_A(ntryL,G0H16(1),76,nMB,G1H16(5),n2h16(5))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(722)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(56),h0tab(:,56),[76,3,32,16],[nMB,nMB,0,nMB],4,2,wf8(:,24),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H128(1),wf8(:,24),G0H16(1),ngZd,m3h8x16(:,6),heltab2x128(:,:,56))
  call Hloop_Q_A(ntryL,G0H16(1),76,nMB,G1H16(6),n2h16(6))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(723)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(57),h0tab(:,57),[76,3,32,16],[nMB,nMB,0,nMB],4,2,wf8(:,39),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H128(1),wf8(:,39),G0H16(1),m3h8x16(:,7),heltab2x128(:,:,57))
  call Hloop_Q_A(ntryL,G0H16(1),76,nMB,G1H16(7),n2h16(7))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(514)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(58),h0tab(:,58),[76,3,32,16],[nMB,nMB,0,nMB],4,2,wf8(:,24),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H128(1),wf8(:,24),G0H16(1),ngZd,m3h8x16(:,8),heltab2x128(:,:,58))
  call Hloop_Q_A(ntryL,G0H16(1),76,nMB,G1H16(8),n2h16(8))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(732)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(59),h0tab(:,59),[76,3,16,32],[nMB,nMB,0,nMB],4,2,wf8(:,40),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,40),G0H16(1),m3h8x16(:,9),heltab2x128(:,:,59))
  call Hloop_A_Q(ntryL,G0H16(1),76,nMB,G1H16(9),n2h16(9))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(733)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(60),h0tab(:,60),[76,3,16,32],[nMB,nMB,0,nMB],4,2,wf8(:,34),wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,34),G0H16(1),ngZd,m3h8x16(:,10),heltab2x128(:,:,60))
  call Hloop_A_Q(ntryL,G0H16(1),76,nMB,G1H16(10),n2h16(10))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(734)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(61),h0tab(:,61),[76,3,16,32],[nMB,nMB,0,nMB],4,2,wf8(:,40),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,40),G0H16(1),m3h8x16(:,11),heltab2x128(:,:,61))
  call Hloop_A_Q(ntryL,G0H16(1),76,nMB,G1H16(11),n2h16(11))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(530)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(62),h0tab(:,62),[76,3,16,32],[nMB,nMB,0,nMB],4,2,wf8(:,34),wf4(:,8))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,34),G0H16(1),ngZd,m3h8x16(:,12),heltab2x128(:,:,62))
  call Hloop_A_Q(ntryL,G0H16(1),76,nMB,G1H16(12),n2h16(12))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(732)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(63),h0tab(:,63),[76,3,32,16],[nMB,nMB,0,nMB],4,2,wf8(:,40),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),wf8(:,40),G0H16(1),m3h8x16(:,13),heltab2x128(:,:,63))
  call Hloop_Q_A(ntryL,G0H16(1),76,nMB,G1H16(13),n2h16(13))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(733)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(64),h0tab(:,64),[76,3,32,16],[nMB,nMB,0,nMB],4,2,wf8(:,34),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H128(1),wf8(:,34),G0H16(1),ngZd,m3h8x16(:,14),heltab2x128(:,:,64))
  call Hloop_Q_A(ntryL,G0H16(1),76,nMB,G1H16(14),n2h16(14))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(734)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(65),h0tab(:,65),[76,3,32,16],[nMB,nMB,0,nMB],4,2,wf8(:,40),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H128(1),wf8(:,40),G0H16(1),m3h8x16(:,15),heltab2x128(:,:,65))
  call Hloop_Q_A(ntryL,G0H16(1),76,nMB,G1H16(15),n2h16(15))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(530)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(66),h0tab(:,66),[76,3,32,16],[nMB,nMB,0,nMB],4,2,wf8(:,34),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H128(1),wf8(:,34),G0H16(1),ngZd,m3h8x16(:,16),heltab2x128(:,:,66))
  call Hloop_Q_A(ntryL,G0H16(1),76,nMB,G1H16(16),n2h16(16))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(397)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(67),h0tab(:,67),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,35))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,35),heltab2x128(:,:,67))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(35),n2h64(35))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(400)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(68),h0tab(:,68),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,186))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,36),heltab2x128(:,:,68))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(36),n2h64(36))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(402)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(69),h0tab(:,69),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,37))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,37),heltab2x128(:,:,69))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(37),n2h64(37))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(404)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(70),h0tab(:,70),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,187))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,38),heltab2x128(:,:,70))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(38),n2h64(38))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(397)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(71),h0tab(:,71),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,35))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,39),heltab2x128(:,:,71))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(39),n2h64(39))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(400)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(72),h0tab(:,72),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,186))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,40),heltab2x128(:,:,72))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(40),n2h64(40))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(402)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(73),h0tab(:,73),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,37))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,41),heltab2x128(:,:,73))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(41),n2h64(41))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(404)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(74),h0tab(:,74),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,187))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,42),heltab2x128(:,:,74))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(42),n2h64(42))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(406)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(75),h0tab(:,75),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,39))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,43),heltab2x128(:,:,75))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(43),n2h64(43))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(408)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(76),h0tab(:,76),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,188))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,44),heltab2x128(:,:,76))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(44),n2h64(44))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(410)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(77),h0tab(:,77),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,41))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,45),heltab2x128(:,:,77))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(45),n2h64(45))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(412)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(78),h0tab(:,78),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,189))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,46),heltab2x128(:,:,78))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(46),n2h64(46))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(406)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(79),h0tab(:,79),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,39))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,47),heltab2x128(:,:,79))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(47),n2h64(47))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(408)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(80),h0tab(:,80),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,188))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,48),heltab2x128(:,:,80))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(48),n2h64(48))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(410)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(81),h0tab(:,81),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,41))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,49),heltab2x128(:,:,81))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(49),n2h64(49))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(412)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(82),h0tab(:,82),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,189))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,50),heltab2x128(:,:,82))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(50),n2h64(50))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(759)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(83),h0tab(:,83),[67,12,32,16],[nMB,nMB,0,nMB],4,2,wf8(:,67),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),wf8(:,67),G0H16(1),m3h8x16(:,17),heltab2x128(:,:,83))
  call Hloop_Q_A(ntryL,G0H16(1),67,nMB,G1H16(17),n2h16(17))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(760)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(84),h0tab(:,84),[67,12,32,16],[nMB,nMB,0,nMB],4,2,wf8(:,67),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H128(1),wf8(:,67),G0H16(1),m3h8x16(:,18),heltab2x128(:,:,84))
  call Hloop_Q_A(ntryL,G0H16(1),67,nMB,G1H16(18),n2h16(18))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(761)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(85),h0tab(:,85),[67,12,32,16],[nMB,nMB,0,nMB],4,2,wf8(:,48),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H128(1),wf8(:,48),G0H16(1),ngZd,m3h8x16(:,19),heltab2x128(:,:,85))
  call Hloop_Q_A(ntryL,G0H16(1),67,nMB,G1H16(19),n2h16(19))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(567)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(86),h0tab(:,86),[67,12,32,16],[nMB,nMB,0,nMB],4,2,wf8(:,48),wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H128(1),wf8(:,48),G0H16(1),ngZd,m3h8x16(:,20),heltab2x128(:,:,86))
  call Hloop_Q_A(ntryL,G0H16(1),67,nMB,G1H16(20),n2h16(20))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(759)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(87),h0tab(:,87),[67,12,16,32],[nMB,nMB,0,nMB],4,2,wf8(:,67),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,67),G0H16(1),m3h8x16(:,21),heltab2x128(:,:,87))
  call Hloop_A_Q(ntryL,G0H16(1),67,nMB,G1H16(21),n2h16(21))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(760)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(88),h0tab(:,88),[67,12,16,32],[nMB,nMB,0,nMB],4,2,wf8(:,67),wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,67),G0H16(1),m3h8x16(:,22),heltab2x128(:,:,88))
  call Hloop_A_Q(ntryL,G0H16(1),67,nMB,G1H16(22),n2h16(22))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(761)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(89),h0tab(:,89),[67,12,16,32],[nMB,nMB,0,nMB],4,2,wf8(:,48),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,48),G0H16(1),ngZd,m3h8x16(:,23),heltab2x128(:,:,89))
  call Hloop_A_Q(ntryL,G0H16(1),67,nMB,G1H16(23),n2h16(23))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(567)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(90),h0tab(:,90),[67,12,16,32],[nMB,nMB,0,nMB],4,2,wf8(:,48),wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,48),G0H16(1),ngZd,m3h8x16(:,24),heltab2x128(:,:,90))
  call Hloop_A_Q(ntryL,G0H16(1),67,nMB,G1H16(24),n2h16(24))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(770)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(91),h0tab(:,91),[67,12,32,16],[nMB,nMB,0,nMB],4,2,wf8(:,68),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H128(1),wf8(:,68),G0H16(1),m3h8x16(:,25),heltab2x128(:,:,91))
  call Hloop_Q_A(ntryL,G0H16(1),67,nMB,G1H16(25),n2h16(25))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(771)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(92),h0tab(:,92),[67,12,32,16],[nMB,nMB,0,nMB],4,2,wf8(:,68),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H128(1),wf8(:,68),G0H16(1),m3h8x16(:,26),heltab2x128(:,:,92))
  call Hloop_Q_A(ntryL,G0H16(1),67,nMB,G1H16(26),n2h16(26))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(772)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(93),h0tab(:,93),[67,12,32,16],[nMB,nMB,0,nMB],4,2,wf8(:,58),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H128(1),wf8(:,58),G0H16(1),ngZd,m3h8x16(:,27),heltab2x128(:,:,93))
  call Hloop_Q_A(ntryL,G0H16(1),67,nMB,G1H16(27),n2h16(27))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(582)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(94),h0tab(:,94),[67,12,32,16],[nMB,nMB,0,nMB],4,2,wf8(:,58),wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H128(1),wf8(:,58),G0H16(1),ngZd,m3h8x16(:,28),heltab2x128(:,:,94))
  call Hloop_Q_A(ntryL,G0H16(1),67,nMB,G1H16(28),n2h16(28))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(770)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(95),h0tab(:,95),[67,12,16,32],[nMB,nMB,0,nMB],4,2,wf8(:,68),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,68),G0H16(1),m3h8x16(:,29),heltab2x128(:,:,95))
  call Hloop_A_Q(ntryL,G0H16(1),67,nMB,G1H16(29),n2h16(29))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(771)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(96),h0tab(:,96),[67,12,16,32],[nMB,nMB,0,nMB],4,2,wf8(:,68),wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,68),G0H16(1),m3h8x16(:,30),heltab2x128(:,:,96))
  call Hloop_A_Q(ntryL,G0H16(1),67,nMB,G1H16(30),n2h16(30))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(772)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(97),h0tab(:,97),[67,12,16,32],[nMB,nMB,0,nMB],4,2,wf8(:,58),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,58),G0H16(1),ngZd,m3h8x16(:,31),heltab2x128(:,:,97))
  call Hloop_A_Q(ntryL,G0H16(1),67,nMB,G1H16(31),n2h16(31))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(582)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(98),h0tab(:,98),[67,12,16,32],[nMB,nMB,0,nMB],4,2,wf8(:,58),wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,58),G0H16(1),ngZd,m3h8x16(:,32),heltab2x128(:,:,98))
  call Hloop_A_Q(ntryL,G0H16(1),67,nMB,G1H16(32),n2h16(32))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(446)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(99),h0tab(:,99),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,64))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,51),heltab2x128(:,:,99))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(51),n2h64(51))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(448)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(100),h0tab(:,100),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,198))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,52),heltab2x128(:,:,100))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(52),n2h64(52))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(450)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(101),h0tab(:,101),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,66))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,53),heltab2x128(:,:,101))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(53),n2h64(53))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(452)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(102),h0tab(:,102),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,199))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,54),heltab2x128(:,:,102))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(54),n2h64(54))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(446)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(103),h0tab(:,103),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,64))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,55),heltab2x128(:,:,103))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(55),n2h64(55))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(448)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(104),h0tab(:,104),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,198))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,56),heltab2x128(:,:,104))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(56),n2h64(56))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(450)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(105),h0tab(:,105),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,66))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,57),heltab2x128(:,:,105))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(57),n2h64(57))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(452)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(106),h0tab(:,106),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,199))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,58),heltab2x128(:,:,106))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(58),n2h64(58))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(454)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(107),h0tab(:,107),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,68))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,59),heltab2x128(:,:,107))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(59),n2h64(59))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(456)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(108),h0tab(:,108),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,69))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,60),heltab2x128(:,:,108))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(60),n2h64(60))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(458)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(109),h0tab(:,109),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,200))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,61),heltab2x128(:,:,109))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(61),n2h64(61))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(460)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(110),h0tab(:,110),[64,15,32,16],[nMB,nMB,0,nMB],4,1,wf16(:,201))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,62),heltab2x128(:,:,110))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMB,G1H64(62),n2h64(62))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(454)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(111),h0tab(:,111),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,68))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,63),heltab2x128(:,:,111))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(63),n2h64(63))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(456)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(112),h0tab(:,112),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,69))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,64),heltab2x128(:,:,112))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(64),n2h64(64))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(458)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(113),h0tab(:,113),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,200))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,65),heltab2x128(:,:,113))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(65),n2h64(65))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(460)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(114),h0tab(:,114),[64,15,16,32],[nMB,nMB,0,nMB],4,1,wf16(:,201))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,66),heltab2x128(:,:,114))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(66),n2h64(66))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(10),[G1H16(9),G1H16(2),G1H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(12),[G1H16(11),G1H16(4),G1H16(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(14),[G1H16(13),G1H16(6),G1H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(16),[G1H16(15),G1H16(8),G1H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(27),[G1H16(25),G1H16(19),G1H16(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(28),[G1H16(26),G1H16(20),G1H16(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(31),[G1H16(29),G1H16(23),G1H16(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(32),[G1H16(30),G1H16(24),G1H16(22)])
  call Hloop_QV_A(ntryL,G1H32(1),wf4(:,2),G1H8(1),m3h4x8(:,1),heltab2x32(:,:,1))
  call Hloop_Q_A(ntryL,G1H8(1),92,nMB,G2H8(1),n2h8(1))
  call Hloop_QZ_A(ntryL,G1H32(2),wf4(:,6),G1H8(1),ngZd,m3h4x8(:,2),heltab2x32(:,:,2))
  call Hloop_Q_A(ntryL,G1H8(1),92,nMB,G2H8(2),n2h8(2))
  call Hloop_QV_A(ntryL,G1H32(3),wf4(:,2),G1H8(1),m3h4x8(:,3),heltab2x32(:,:,3))
  call Hloop_Q_A(ntryL,G1H8(1),92,nMB,G2H8(3),n2h8(3))
  call Hloop_QZ_A(ntryL,G1H32(4),wf4(:,6),G1H8(1),ngZd,m3h4x8(:,4),heltab2x32(:,:,4))
  call Hloop_Q_A(ntryL,G1H8(1),92,nMB,G2H8(4),n2h8(4))
  call Hloop_QV_A(ntryL,G1H32(5),wf4(:,1),G1H8(1),m3h4x8(:,5),heltab2x32(:,:,5))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMB,G2H8(5),n2h8(5))
  call Hloop_QV_A(ntryL,G1H32(6),wf4(:,1),G1H8(1),m3h4x8(:,6),heltab2x32(:,:,6))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMB,G2H8(6),n2h8(6))
  call Hloop_QZ_A(ntryL,G1H32(7),wf4(:,8),G1H8(1),ngZd,m3h4x8(:,7),heltab2x32(:,:,7))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMB,G2H8(7),n2h8(7))
  call Hloop_QZ_A(ntryL,G1H32(8),wf4(:,8),G1H8(1),ngZd,m3h4x8(:,8),heltab2x32(:,:,8))
  call Hloop_Q_A(ntryL,G1H8(1),83,nMB,G2H8(8),n2h8(8))
  call Hloop_AV_Q(ntryL,G1H32(9),wf4(:,2),G1H8(1),m3h4x8(:,9),heltab2x32(:,:,9))
  call Hloop_A_Q(ntryL,G1H8(1),108,nMB,G2H8(9),n2h8(9))
  call Hloop_AZ_Q(ntryL,G1H32(10),wf4(:,6),G1H8(1),ngZd,m3h4x8(:,10),heltab2x32(:,:,10))
  call Hloop_A_Q(ntryL,G1H8(1),108,nMB,G2H8(10),n2h8(10))
  call Hloop_AV_Q(ntryL,G1H32(11),wf4(:,2),G1H8(1),m3h4x8(:,11),heltab2x32(:,:,11))
  call Hloop_A_Q(ntryL,G1H8(1),108,nMB,G2H8(11),n2h8(11))
  call Hloop_AZ_Q(ntryL,G1H32(12),wf4(:,6),G1H8(1),ngZd,m3h4x8(:,12),heltab2x32(:,:,12))
  call Hloop_A_Q(ntryL,G1H8(1),108,nMB,G2H8(12),n2h8(12))
  call Hloop_AV_Q(ntryL,G1H32(13),wf4(:,1),G1H8(1),m3h4x8(:,13),heltab2x32(:,:,13))
  call Hloop_A_Q(ntryL,G1H8(1),99,nMB,G2H8(13),n2h8(13))
  call Hloop_AV_Q(ntryL,G1H32(14),wf4(:,1),G1H8(1),m3h4x8(:,14),heltab2x32(:,:,14))
  call Hloop_A_Q(ntryL,G1H8(1),99,nMB,G2H8(14),n2h8(14))
  call Hloop_AZ_Q(ntryL,G1H32(15),wf4(:,8),G1H8(1),ngZd,m3h4x8(:,15),heltab2x32(:,:,15))
  call Hloop_A_Q(ntryL,G1H8(1),99,nMB,G2H8(15),n2h8(15))
  call Hloop_AZ_Q(ntryL,G1H32(16),wf4(:,8),G1H8(1),ngZd,m3h4x8(:,16),heltab2x32(:,:,16))
  call Hloop_A_Q(ntryL,G1H8(1),99,nMB,G2H8(16),n2h8(16))
  call Hloop_AV_Q(ntryL,G1H64(1),wf4(:,2),G1H16(9),m3h4x16(:,1),heltab2x64(:,:,1))
  call Hloop_A_Q(ntryL,G1H16(9),76,nMB,G2H16(1),n2h16(33))
  call Hloop_AZ_Q(ntryL,G1H64(2),wf4(:,6),G1H16(2),ngZd,m3h4x16(:,2),heltab2x64(:,:,2))
  call Hloop_A_Q(ntryL,G1H16(2),76,nMB,G2H16(2),n2h16(34))
  call Hloop_AV_Q(ntryL,G1H64(3),wf4(:,2),G1H16(1),m3h4x16(:,3),heltab2x64(:,:,3))
  call Hloop_A_Q(ntryL,G1H16(1),76,nMB,G2H16(3),n2h16(35))
  call Hloop_AZ_Q(ntryL,G1H64(4),wf4(:,6),G1H16(11),ngZd,m3h4x16(:,4),heltab2x64(:,:,4))
  call Hloop_A_Q(ntryL,G1H16(11),76,nMB,G2H16(4),n2h16(36))
  call Hloop_QV_A(ntryL,G1H64(5),wf4(:,2),G1H16(4),m3h4x16(:,5),heltab2x64(:,:,5))
  call Hloop_Q_A(ntryL,G1H16(4),76,nMB,G2H16(5),n2h16(37))
  call Hloop_QZ_A(ntryL,G1H64(6),wf4(:,6),G1H16(3),ngZd,m3h4x16(:,6),heltab2x64(:,:,6))
  call Hloop_Q_A(ntryL,G1H16(3),76,nMB,G2H16(6),n2h16(38))
  call Hloop_QV_A(ntryL,G1H64(7),wf4(:,2),G1H16(13),m3h4x16(:,7),heltab2x64(:,:,7))
  call Hloop_Q_A(ntryL,G1H16(13),76,nMB,G2H16(7),n2h16(39))
  call Hloop_QZ_A(ntryL,G1H64(8),wf4(:,6),G1H16(6),ngZd,m3h4x16(:,8),heltab2x64(:,:,8))
  call Hloop_Q_A(ntryL,G1H16(6),76,nMB,G2H16(8),n2h16(40))
  call Hloop_QV_A(ntryL,G1H64(9),wf4(:,2),G1H16(5),m3h4x16(:,9),heltab2x64(:,:,9))
  call Hloop_Q_A(ntryL,G1H16(5),76,nMB,G2H16(9),n2h16(41))
  call Hloop_QZ_A(ntryL,G1H64(10),wf4(:,6),G1H16(15),ngZd,m3h4x16(:,10),heltab2x64(:,:,10))
  call Hloop_Q_A(ntryL,G1H16(15),76,nMB,G2H16(10),n2h16(42))
  call Hloop_QV_A(ntryL,G1H64(11),wf4(:,2),G1H16(8),m3h4x16(:,11),heltab2x64(:,:,11))
  call Hloop_Q_A(ntryL,G1H16(8),76,nMB,G2H16(11),n2h16(43))
  call Hloop_QZ_A(ntryL,G1H64(12),wf4(:,6),G1H16(7),ngZd,m3h4x16(:,12),heltab2x64(:,:,12))
  call Hloop_Q_A(ntryL,G1H16(7),76,nMB,G2H16(12),n2h16(44))
  call Hloop_AV_Q(ntryL,G1H64(13),wf4(:,2),G1H16(25),m3h4x16(:,13),heltab2x64(:,:,13))
  call Hloop_A_Q(ntryL,G1H16(25),76,nMB,G2H16(13),n2h16(45))
  call Hloop_AZ_Q(ntryL,G1H64(14),wf4(:,6),G1H16(19),ngZd,m3h4x16(:,14),heltab2x64(:,:,14))
  call Hloop_A_Q(ntryL,G1H16(19),76,nMB,G2H16(14),n2h16(46))
  call Hloop_AV_Q(ntryL,G1H64(15),wf4(:,2),G1H16(17),m3h4x16(:,15),heltab2x64(:,:,15))
  call Hloop_A_Q(ntryL,G1H16(17),76,nMB,G2H16(15),n2h16(47))
  call Hloop_AZ_Q(ntryL,G1H64(16),wf4(:,6),G1H16(26),ngZd,m3h4x16(:,16),heltab2x64(:,:,16))
  call Hloop_A_Q(ntryL,G1H16(26),76,nMB,G2H16(16),n2h16(48))
  call Hloop_AV_Q(ntryL,G1H64(17),wf4(:,1),G1H16(20),m3h4x16(:,17),heltab2x64(:,:,17))
  call Hloop_A_Q(ntryL,G1H16(20),67,nMB,G2H16(17),n2h16(49))
  call Hloop_AV_Q(ntryL,G1H64(18),wf4(:,1),G1H16(18),m3h4x16(:,18),heltab2x64(:,:,18))
  call Hloop_A_Q(ntryL,G1H16(18),67,nMB,G2H16(18),n2h16(50))
  call Hloop_AZ_Q(ntryL,G1H64(19),wf4(:,8),G1H16(29),ngZd,m3h4x16(:,19),heltab2x64(:,:,19))
  call Hloop_A_Q(ntryL,G1H16(29),67,nMB,G2H16(19),n2h16(51))
  call Hloop_AZ_Q(ntryL,G1H64(20),wf4(:,8),G1H16(23),ngZd,m3h4x16(:,20),heltab2x64(:,:,20))
  call Hloop_A_Q(ntryL,G1H16(23),67,nMB,G2H16(20),n2h16(52))
  call Hloop_QV_A(ntryL,G1H64(21),wf4(:,1),G1H16(21),m3h4x16(:,21),heltab2x64(:,:,21))
  call Hloop_Q_A(ntryL,G1H16(21),67,nMB,G2H16(21),n2h16(53))
  call Hloop_QV_A(ntryL,G1H64(22),wf4(:,1),G1H16(30),m3h4x16(:,22),heltab2x64(:,:,22))
  call Hloop_Q_A(ntryL,G1H16(30),67,nMB,G2H16(22),n2h16(54))
  call Hloop_QZ_A(ntryL,G1H64(23),wf4(:,8),G1H16(24),ngZd,m3h4x16(:,23),heltab2x64(:,:,23))
  call Hloop_Q_A(ntryL,G1H16(24),67,nMB,G2H16(23),n2h16(55))
  call Hloop_QZ_A(ntryL,G1H64(24),wf4(:,8),G1H16(22),ngZd,m3h4x16(:,24),heltab2x64(:,:,24))
  call Hloop_Q_A(ntryL,G1H16(22),67,nMB,G2H16(24),n2h16(56))
  call Hloop_QV_A(ntryL,G1H64(25),wf4(:,1),G1H16(9),m3h4x16(:,25),heltab2x64(:,:,25))
  call Hloop_Q_A(ntryL,G1H16(9),67,nMB,G2H16(25),n2h16(57))
  call Hloop_QV_A(ntryL,G1H64(26),wf4(:,1),G1H16(2),m3h4x16(:,26),heltab2x64(:,:,26))
  call Hloop_Q_A(ntryL,G1H16(2),67,nMB,G2H16(26),n2h16(58))
  call Hloop_QZ_A(ntryL,G1H64(27),wf4(:,8),G1H16(1),ngZd,m3h4x16(:,27),heltab2x64(:,:,27))
  call Hloop_Q_A(ntryL,G1H16(1),67,nMB,G2H16(27),n2h16(59))
  call Hloop_QZ_A(ntryL,G1H64(28),wf4(:,8),G1H16(11),ngZd,m3h4x16(:,28),heltab2x64(:,:,28))
  call Hloop_Q_A(ntryL,G1H16(11),67,nMB,G2H16(28),n2h16(60))
  call Hloop_AV_Q(ntryL,G1H64(29),wf4(:,1),G1H16(4),m3h4x16(:,29),heltab2x64(:,:,29))
  call Hloop_A_Q(ntryL,G1H16(4),67,nMB,G2H16(29),n2h16(61))
  call Hloop_AV_Q(ntryL,G1H64(30),wf4(:,1),G1H16(3),m3h4x16(:,30),heltab2x64(:,:,30))
  call Hloop_A_Q(ntryL,G1H16(3),67,nMB,G2H16(30),n2h16(62))
  call Hloop_AZ_Q(ntryL,G1H64(31),wf4(:,8),G1H16(13),ngZd,m3h4x16(:,31),heltab2x64(:,:,31))
  call Hloop_A_Q(ntryL,G1H16(13),67,nMB,G2H16(31),n2h16(63))
  call Hloop_AZ_Q(ntryL,G1H64(32),wf4(:,8),G1H16(6),ngZd,m3h4x16(:,32),heltab2x64(:,:,32))
  call Hloop_A_Q(ntryL,G1H16(6),67,nMB,G2H16(32),n2h16(64))
  call Hloop_QS_A(ntryL,G1H64(33),wf16(:,5),G1H4(1),ngH,m3h16x4(:,1),heltab2x64(:,:,33))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(1),n2h4(1))
  call Hloop_AS_Q(ntryL,G1H64(34),wf16(:,5),G1H4(1),ngH,m3h16x4(:,2),heltab2x64(:,:,34))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(2),n2h4(2))
  call Hloop_AV_Q(ntryL,G1H16(10),wf4(:,1),G1H4(1),m3h4x4(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(3),n2h4(3))
  call Hloop_AZ_Q(ntryL,G1H16(12),wf4(:,8),G1H4(1),ngZd,m3h4x4(:,2),heltab2x16(:,:,2))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(4),n2h4(4))
  call Hloop_QV_A(ntryL,G1H16(14),wf4(:,1),G1H4(1),m3h4x4(:,3),heltab2x16(:,:,3))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(5),n2h4(5))
  call Hloop_QZ_A(ntryL,G1H16(16),wf4(:,8),G1H4(1),ngZd,m3h4x4(:,4),heltab2x16(:,:,4))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(6),n2h4(6))
  call Hloop_QV_A(ntryL,G1H64(35),wf16(:,35),G1H4(1),m3h16x4(:,3),heltab2x64(:,:,35))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(7),n2h4(7))
  call Hloop_QZ_A(ntryL,G1H64(36),wf16(:,186),G1H4(1),ngZd,m3h16x4(:,4),heltab2x64(:,:,36))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(8),n2h4(8))
  call Hloop_QV_A(ntryL,G1H64(37),wf16(:,37),G1H4(1),m3h16x4(:,5),heltab2x64(:,:,37))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(9),n2h4(9))
  call Hloop_QZ_A(ntryL,G1H64(38),wf16(:,187),G1H4(1),ngZd,m3h16x4(:,6),heltab2x64(:,:,38))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(10),n2h4(10))
  call Hloop_AV_Q(ntryL,G1H64(39),wf16(:,35),G1H4(1),m3h16x4(:,7),heltab2x64(:,:,39))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(11),n2h4(11))
  call Hloop_AZ_Q(ntryL,G1H64(40),wf16(:,186),G1H4(1),ngZd,m3h16x4(:,8),heltab2x64(:,:,40))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(12),n2h4(12))
  call Hloop_AV_Q(ntryL,G1H64(41),wf16(:,37),G1H4(1),m3h16x4(:,9),heltab2x64(:,:,41))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(13),n2h4(13))
  call Hloop_AZ_Q(ntryL,G1H64(42),wf16(:,187),G1H4(1),ngZd,m3h16x4(:,10),heltab2x64(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(14),n2h4(14))
  call Hloop_QV_A(ntryL,G1H64(43),wf16(:,39),G1H4(1),m3h16x4(:,11),heltab2x64(:,:,43))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(15),n2h4(15))
  call Hloop_QZ_A(ntryL,G1H64(44),wf16(:,188),G1H4(1),ngZd,m3h16x4(:,12),heltab2x64(:,:,44))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(16),n2h4(16))
  call Hloop_QV_A(ntryL,G1H64(45),wf16(:,41),G1H4(1),m3h16x4(:,13),heltab2x64(:,:,45))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(17),n2h4(17))
  call Hloop_QZ_A(ntryL,G1H64(46),wf16(:,189),G1H4(1),ngZd,m3h16x4(:,14),heltab2x64(:,:,46))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(18),n2h4(18))
  call Hloop_AV_Q(ntryL,G1H64(47),wf16(:,39),G1H4(1),m3h16x4(:,15),heltab2x64(:,:,47))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(19),n2h4(19))
  call Hloop_AZ_Q(ntryL,G1H64(48),wf16(:,188),G1H4(1),ngZd,m3h16x4(:,16),heltab2x64(:,:,48))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(20),n2h4(20))
  call Hloop_AV_Q(ntryL,G1H64(49),wf16(:,41),G1H4(1),m3h16x4(:,17),heltab2x64(:,:,49))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(21),n2h4(21))
  call Hloop_AZ_Q(ntryL,G1H64(50),wf16(:,189),G1H4(1),ngZd,m3h16x4(:,18),heltab2x64(:,:,50))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(22),n2h4(22))
  call Hloop_QV_A(ntryL,G1H16(27),wf4(:,2),G1H4(1),m3h4x4(:,5),heltab2x16(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(23),n2h4(23))
  call Hloop_QZ_A(ntryL,G1H16(28),wf4(:,6),G1H4(1),ngZd,m3h4x4(:,6),heltab2x16(:,:,6))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(24),n2h4(24))
  call Hloop_AV_Q(ntryL,G1H16(31),wf4(:,2),G1H4(1),m3h4x4(:,7),heltab2x16(:,:,7))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(25),n2h4(25))
  call Hloop_AZ_Q(ntryL,G1H16(32),wf4(:,6),G1H4(1),ngZd,m3h4x4(:,8),heltab2x16(:,:,8))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(26),n2h4(26))
  call Hloop_QV_A(ntryL,G1H64(51),wf16(:,64),G1H4(1),m3h16x4(:,19),heltab2x64(:,:,51))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(27),n2h4(27))
  call Hloop_QZ_A(ntryL,G1H64(52),wf16(:,198),G1H4(1),ngZd,m3h16x4(:,20),heltab2x64(:,:,52))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(28),n2h4(28))
  call Hloop_QV_A(ntryL,G1H64(53),wf16(:,66),G1H4(1),m3h16x4(:,21),heltab2x64(:,:,53))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(29),n2h4(29))
  call Hloop_QZ_A(ntryL,G1H64(54),wf16(:,199),G1H4(1),ngZd,m3h16x4(:,22),heltab2x64(:,:,54))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(30),n2h4(30))
  call Hloop_AV_Q(ntryL,G1H64(55),wf16(:,64),G1H4(1),m3h16x4(:,23),heltab2x64(:,:,55))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(31),n2h4(31))
  call Hloop_AZ_Q(ntryL,G1H64(56),wf16(:,198),G1H4(1),ngZd,m3h16x4(:,24),heltab2x64(:,:,56))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(32),n2h4(32))
  call Hloop_AV_Q(ntryL,G1H64(57),wf16(:,66),G1H4(1),m3h16x4(:,25),heltab2x64(:,:,57))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(33),n2h4(33))
  call Hloop_AZ_Q(ntryL,G1H64(58),wf16(:,199),G1H4(1),ngZd,m3h16x4(:,26),heltab2x64(:,:,58))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(34),n2h4(34))
  call Hloop_QV_A(ntryL,G1H64(59),wf16(:,68),G1H4(1),m3h16x4(:,27),heltab2x64(:,:,59))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(35),n2h4(35))
  call Hloop_QV_A(ntryL,G1H64(60),wf16(:,69),G1H4(1),m3h16x4(:,28),heltab2x64(:,:,60))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(36),n2h4(36))
  call Hloop_QZ_A(ntryL,G1H64(61),wf16(:,200),G1H4(1),ngZd,m3h16x4(:,29),heltab2x64(:,:,61))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(37),n2h4(37))
  call Hloop_QZ_A(ntryL,G1H64(62),wf16(:,201),G1H4(1),ngZd,m3h16x4(:,30),heltab2x64(:,:,62))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMB,G2H4(38),n2h4(38))
  call Hloop_AV_Q(ntryL,G1H64(63),wf16(:,68),G1H4(1),m3h16x4(:,31),heltab2x64(:,:,63))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(39),n2h4(39))
  call Hloop_AV_Q(ntryL,G1H64(64),wf16(:,69),G1H4(1),m3h16x4(:,32),heltab2x64(:,:,64))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(40),n2h4(40))
  call Hloop_AZ_Q(ntryL,G1H64(65),wf16(:,200),G1H4(1),ngZd,m3h16x4(:,33),heltab2x64(:,:,65))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(41),n2h4(41))
  call Hloop_AZ_Q(ntryL,G1H64(66),wf16(:,201),G1H4(1),ngZd,m3h16x4(:,34),heltab2x64(:,:,66))
  call Hloop_A_Q(ntryL,G1H4(1),79,nMB,G2H4(42),n2h4(42))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(2),[G2H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(4),[G2H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(7),[G2H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(8),[G2H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(10),[G2H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(12),[G2H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(15),[G2H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(16),[G2H8(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(2),[G2H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(4),[G2H16(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(6),[G2H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(8),[G2H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(10),[G2H16(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(12),[G2H16(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(14),[G2H16(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(16),[G2H16(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(19),[G2H16(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(20),[G2H16(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(23),[G2H16(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(24),[G2H16(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(27),[G2H16(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(28),[G2H16(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(31),[G2H16(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(32),[G2H16(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(38),[G2H4(37),G2H4(36),G2H4(35),G2H4(30),G2H4(29) &
    ,G2H4(28),G2H4(27),G2H4(18),G2H4(17),G2H4(16),G2H4(15),G2H4(10),G2H4(9),G2H4(8),G2H4(7),G2H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(42),[G2H4(41),G2H4(40),G2H4(39),G2H4(34),G2H4(33) &
    ,G2H4(32),G2H4(31),G2H4(22),G2H4(21),G2H4(20),G2H4(19),G2H4(14),G2H4(13),G2H4(12),G2H4(11),G2H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G2H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G2H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(24),[G2H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(26),[G2H4(25)])
  call Hotf_4pt_reduction(G2H8(2),RedSet_4(1),mass4set(:,1),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),8)
  call HG1shiftOLR(G1H8(2),32,8)
  call Hotf_4pt_reduction(G2H8(4),RedSet_4(1),mass4set(:,1),  & 
G1H8(6),G1H8(7),G1H8(8),G1H8(9),G1H8(10),8)
  call HG1shiftOLR(G1H8(7),32,8)
  call Hotf_4pt_reduction(G2H8(7),RedSet_4(2),mass4set(:,1),  & 
G1H8(11),G1H8(12),G1H8(13),G1H8(14),G1H8(15),8)
  call HG1shiftOLR(G1H8(12),32,8)
  call Hotf_4pt_reduction(G2H8(8),RedSet_4(2),mass4set(:,1),  & 
G1H8(16),G1H8(17),G1H8(18),G1H8(19),G1H8(20),8)
  call HG1shiftOLR(G1H8(17),32,8)
  call Hotf_4pt_reduction(G2H8(10),RedSet_4(3),mass4set(:,1),  & 
G1H8(21),G1H8(22),G1H8(23),G1H8(24),G1H8(25),8)
  call HG1shiftOLR(G1H8(22),16,8)
  call Hotf_4pt_reduction(G2H8(12),RedSet_4(3),mass4set(:,1),  & 
G1H8(26),G1H8(27),G1H8(28),G1H8(29),G1H8(30),8)
  call HG1shiftOLR(G1H8(27),16,8)
  call Hotf_4pt_reduction(G2H8(15),RedSet_4(4),mass4set(:,1),  & 
G1H8(31),G1H8(32),G1H8(33),G1H8(34),G1H8(35),8)
  call HG1shiftOLR(G1H8(32),16,8)
  call Hotf_4pt_reduction(G2H8(16),RedSet_4(4),mass4set(:,1),  & 
G1H8(36),G1H8(37),G1H8(38),G1H8(39),G1H8(40),8)
  call HG1shiftOLR(G1H8(37),16,8)
  call Hloop_AQ_V(ntryL,G2H16(2),wf8(:,11),G2H2(1),m3h8x2(:,1),heltab2x16(:,:,9))
  call Hloop_AQ_V(ntryL,G2H16(4),wf8(:,13),G2H2(2),m3h8x2(:,2),heltab2x16(:,:,10))
  call Hloop_QA_V(ntryL,G2H16(6),ex6(:),G2H8(1),m3h2x8(:,1),heltab2x16(:,:,11))
  call Hloop_QA_V(ntryL,G2H16(8),ex6(:),G2H8(3),m3h2x8(:,2),heltab2x16(:,:,12))
  call Hloop_QA_V(ntryL,G2H16(10),wf8(:,2),G2H2(3),m3h8x2(:,3),heltab2x16(:,:,13))
  call Hloop_QA_V(ntryL,G2H16(12),wf8(:,4),G2H2(4),m3h8x2(:,4),heltab2x16(:,:,14))
  call Hloop_AQ_V(ntryL,G2H16(14),ex5(:),G2H8(5),m3h2x8(:,3),heltab2x16(:,:,15))
  call Hloop_AQ_V(ntryL,G2H16(16),ex5(:),G2H8(6),m3h2x8(:,4),heltab2x16(:,:,16))
  call Hloop_AQ_V(ntryL,G2H16(19),wf8(:,15),G2H2(5),m3h8x2(:,5),heltab2x16(:,:,17))
  call Hloop_AQ_V(ntryL,G2H16(20),wf8(:,17),G2H2(6),m3h8x2(:,6),heltab2x16(:,:,18))
  call Hloop_QA_V(ntryL,G2H16(23),ex6(:),G2H8(9),m3h2x8(:,5),heltab2x16(:,:,19))
  call Hloop_QA_V(ntryL,G2H16(24),ex6(:),G2H8(11),m3h2x8(:,6),heltab2x16(:,:,20))
  call Hloop_QA_V(ntryL,G2H16(27),wf8(:,6),G2H2(7),m3h8x2(:,7),heltab2x16(:,:,21))
  call Hloop_QA_V(ntryL,G2H16(28),wf8(:,8),G2H2(8),m3h8x2(:,8),heltab2x16(:,:,22))
  call Hloop_AQ_V(ntryL,G2H16(31),ex5(:),G2H8(13),m3h2x8(:,7),heltab2x16(:,:,23))
  call Hloop_AQ_V(ntryL,G2H16(32),ex5(:),G2H8(14),m3h2x8(:,8),heltab2x16(:,:,24))
  call Hloop_QA_V(ntryL,G2H4(38),ex6(:),G2H2(9),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_AQ_V(ntryL,G2H4(42),ex5(:),G2H2(10),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_AQ_V(ntryL,G2H4(4),ex5(:),G2H2(11),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_V(ntryL,G2H4(6),ex6(:),G2H2(12),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_QA_V(ntryL,G2H4(24),ex6(:),G2H2(13),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_V(ntryL,G2H4(26),ex5(:),G2H2(14),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_QV_A(ntryL,G1H8(1),wf4(:,1),G1H2(1),m3h4x2(:,1),heltab2x8(:,:,1))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(15),n2h2(1))
call HGT_raise_alpha_OLR(G1H8(2),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(2),ex6(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,2))
  call Hloop_QV_A(ntryL,G1H8(4),wf4(:,1),G1H2(1),m3h4x2(:,2),heltab2x8(:,:,3))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(16),n2h2(2))
  call Hloop_QV_A(ntryL,G1H8(5),wf4(:,1),G1H2(1),m3h4x2(:,3),heltab2x8(:,:,4))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(17),n2h2(3))
  call Hloop_QZ_A(ntryL,G1H8(6),wf4(:,8),G1H2(1),ngZd,m3h4x2(:,4),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(18),n2h2(4))
call HGT_raise_alpha_OLR(G1H8(7),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(7),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(7),ex6(:),G1H4(2),m3h2x4(:,2),heltab2x8(:,:,6))
  call Hloop_QZ_A(ntryL,G1H8(9),wf4(:,8),G1H2(1),ngZd,m3h4x2(:,5),heltab2x8(:,:,7))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(19),n2h2(5))
  call Hloop_QZ_A(ntryL,G1H8(10),wf4(:,8),G1H2(1),ngZd,m3h4x2(:,6),heltab2x8(:,:,8))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(20),n2h2(6))
  call Hloop_QV_A(ntryL,G1H8(11),wf4(:,2),G1H2(1),m3h4x2(:,7),heltab2x8(:,:,9))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(21),n2h2(7))
call HGT_raise_alpha_OLR(G1H8(12),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(12),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(12),ex6(:),G1H4(3),m3h2x4(:,3),heltab2x8(:,:,10))
  call Hloop_QV_A(ntryL,G1H8(14),wf4(:,2),G1H2(1),m3h4x2(:,8),heltab2x8(:,:,11))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(22),n2h2(8))
  call Hloop_QV_A(ntryL,G1H8(15),wf4(:,2),G1H2(1),m3h4x2(:,9),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(23),n2h2(9))
  call Hloop_QZ_A(ntryL,G1H8(16),wf4(:,6),G1H2(1),ngZd,m3h4x2(:,10),heltab2x8(:,:,13))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(24),n2h2(10))
call HGT_raise_alpha_OLR(G1H8(17),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(17),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(17),ex6(:),G1H4(4),m3h2x4(:,4),heltab2x8(:,:,14))
  call Hloop_QZ_A(ntryL,G1H8(19),wf4(:,6),G1H2(1),ngZd,m3h4x2(:,11),heltab2x8(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(25),n2h2(11))
  call Hloop_QZ_A(ntryL,G1H8(20),wf4(:,6),G1H2(1),ngZd,m3h4x2(:,12),heltab2x8(:,:,16))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(26),n2h2(12))
  call Hloop_AV_Q(ntryL,G1H8(21),wf4(:,1),G1H2(1),m3h4x2(:,13),heltab2x8(:,:,17))
  call Hloop_A_Q(ntryL,G1H2(1),111,nMB,G2H2(27),n2h2(13))
call HGT_raise_alpha_OLR(G1H8(22),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(22),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(22),ex5(:),G1H4(5),m3h2x4(:,5),heltab2x8(:,:,18))
  call Hloop_AV_Q(ntryL,G1H8(24),wf4(:,1),G1H2(1),m3h4x2(:,14),heltab2x8(:,:,19))
  call Hloop_A_Q(ntryL,G1H2(1),111,nMB,G2H2(28),n2h2(14))
  call Hloop_AV_Q(ntryL,G1H8(25),wf4(:,1),G1H2(1),m3h4x2(:,15),heltab2x8(:,:,20))
  call Hloop_A_Q(ntryL,G1H2(1),111,nMB,G2H2(29),n2h2(15))
  call Hloop_AZ_Q(ntryL,G1H8(26),wf4(:,8),G1H2(1),ngZd,m3h4x2(:,16),heltab2x8(:,:,21))
  call Hloop_A_Q(ntryL,G1H2(1),111,nMB,G2H2(30),n2h2(16))
call HGT_raise_alpha_OLR(G1H8(27),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(27),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(27),ex5(:),G1H4(6),m3h2x4(:,6),heltab2x8(:,:,22))
  call Hloop_AZ_Q(ntryL,G1H8(29),wf4(:,8),G1H2(1),ngZd,m3h4x2(:,17),heltab2x8(:,:,23))
  call Hloop_A_Q(ntryL,G1H2(1),111,nMB,G2H2(31),n2h2(17))
  call Hloop_AZ_Q(ntryL,G1H8(30),wf4(:,8),G1H2(1),ngZd,m3h4x2(:,18),heltab2x8(:,:,24))
  call Hloop_A_Q(ntryL,G1H2(1),111,nMB,G2H2(32),n2h2(18))
  call Hloop_AV_Q(ntryL,G1H8(31),wf4(:,2),G1H2(1),m3h4x2(:,19),heltab2x8(:,:,25))
  call Hloop_A_Q(ntryL,G1H2(1),111,nMB,G2H2(33),n2h2(19))
call HGT_raise_alpha_OLR(G1H8(32),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(32),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(32),ex5(:),G1H4(7),m3h2x4(:,7),heltab2x8(:,:,26))
  call Hloop_AV_Q(ntryL,G1H8(34),wf4(:,2),G1H2(1),m3h4x2(:,20),heltab2x8(:,:,27))
  call Hloop_A_Q(ntryL,G1H2(1),111,nMB,G2H2(34),n2h2(20))
  call Hloop_AV_Q(ntryL,G1H8(35),wf4(:,2),G1H2(1),m3h4x2(:,21),heltab2x8(:,:,28))
  call Hloop_A_Q(ntryL,G1H2(1),111,nMB,G2H2(35),n2h2(21))
  call Hloop_AZ_Q(ntryL,G1H8(36),wf4(:,6),G1H2(1),ngZd,m3h4x2(:,22),heltab2x8(:,:,29))
  call Hloop_A_Q(ntryL,G1H2(1),111,nMB,G2H2(36),n2h2(22))
call HGT_raise_alpha_OLR(G1H8(37),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(37),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(37),ex5(:),G1H4(8),m3h2x4(:,8),heltab2x8(:,:,30))
  call Hloop_AZ_Q(ntryL,G1H8(39),wf4(:,6),G1H2(1),ngZd,m3h4x2(:,23),heltab2x8(:,:,31))
  call Hloop_A_Q(ntryL,G1H2(1),111,nMB,G2H2(37),n2h2(23))
  call Hloop_AZ_Q(ntryL,G1H8(40),wf4(:,6),G1H2(1),ngZd,m3h4x2(:,24),heltab2x8(:,:,32))
  call Hloop_A_Q(ntryL,G1H2(1),111,nMB,G2H2(38),n2h2(24))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G2H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G2H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G2H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G2H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(18),[G2H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G2H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(24),[G2H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(26),[G2H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(30),[G2H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G2H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(36),[G2H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(38),[G2H2(35)])
  call Hotf_4pt_reduction(G2H2(2),RedSet_4(5),mass4set(:,2),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),2)
  call HG1shiftOLR(G1H2(2),32,2)
  call Hotf_4pt_reduction(G2H8(1),RedSet_4(6),mass4set(:,2),  & 
G1H8(1),G1H8(2),G1H8(4),G1H8(5),G1H8(6),8)
  call HG1shiftOLR(G1H8(2),19,8)
  call Hotf_4pt_reduction(G2H8(3),RedSet_4(6),mass4set(:,2),  & 
G1H8(7),G1H8(9),G1H8(10),G1H8(11),G1H8(12),8)
  call HG1shiftOLR(G1H8(9),19,8)
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(7),mass4set(:,2),  & 
G1H2(6),G1H2(7),G1H2(8),G1H2(9),G1H2(10),2)
  call HG1shiftOLR(G1H2(7),16,2)
  call Hotf_4pt_reduction(G2H8(5),RedSet_4(8),mass4set(:,2),  & 
G1H8(14),G1H8(15),G1H8(16),G1H8(17),G1H8(19),8)
  call HG1shiftOLR(G1H8(15),35,8)
  call Hotf_4pt_reduction(G2H8(6),RedSet_4(8),mass4set(:,2),  & 
G1H8(20),G1H8(21),G1H8(22),G1H8(24),G1H8(25),8)
  call HG1shiftOLR(G1H8(21),35,8)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(9),mass4set(:,2),  & 
G1H2(11),G1H2(12),G1H2(13),G1H2(14),G1H2(15),2)
  call HG1shiftOLR(G1H2(12),32,2)
  call Hotf_4pt_reduction(G2H8(9),RedSet_4(10),mass4set(:,2),  & 
G1H8(26),G1H8(27),G1H8(29),G1H8(30),G1H8(31),8)
  call HG1shiftOLR(G1H8(27),28,8)
  call Hotf_4pt_reduction(G2H8(11),RedSet_4(10),mass4set(:,2),  & 
G1H8(32),G1H8(34),G1H8(35),G1H8(36),G1H8(37),8)
  call HG1shiftOLR(G1H8(34),28,8)
  call Hotf_4pt_reduction(G2H2(8),RedSet_4(11),mass4set(:,2),  & 
G1H2(16),G1H2(17),G1H2(18),G1H2(19),G1H2(20),2)
  call HG1shiftOLR(G1H2(17),16,2)
  call Hotf_4pt_reduction(G2H8(13),RedSet_4(12),mass4set(:,2),  & 
G1H8(39),G1H8(40),G1H8(41),G1H8(42),G1H8(43),8)
  call HG1shiftOLR(G1H8(40),44,8)
  call Hotf_4pt_reduction(G2H8(14),RedSet_4(12),mass4set(:,2),  & 
G1H8(44),G1H8(45),G1H8(46),G1H8(47),G1H8(48),8)
  call HG1shiftOLR(G1H8(45),44,8)
  call Hotf_4pt_reduction(G2H2(9),RedSet_4(13),mass4set(:,2),  & 
G1H2(21),G1H2(22),G1H2(23),G1H2(24),G1H2(25),2)
  call HG1shiftOLR(G1H2(22),16,2)
  call Hotf_4pt_reduction(G2H2(10),RedSet_4(14),mass4set(:,2),  & 
G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(27),32,2)
  call Hotf_4pt_reduction(G2H2(11),RedSet_4(15),mass4set(:,2),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),2)
  call HG1shiftOLR(G1H2(32),32,2)
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(16),mass4set(:,2),  & 
G1H2(36),G1H2(37),G1H2(38),G1H2(39),G1H2(40),2)
  call HG1shiftOLR(G1H2(37),16,2)
  call Hotf_4pt_reduction(G2H2(13),RedSet_4(17),mass4set(:,2),  & 
G1H2(41),G1H2(42),G1H2(43),G1H2(44),G1H2(45),2)
  call HG1shiftOLR(G1H2(42),16,2)
  call Hotf_4pt_reduction(G2H2(14),RedSet_4(18),mass4set(:,2),  & 
G1H2(46),G1H2(47),G1H2(48),G1H2(49),G1H2(50),2)
  call HG1shiftOLR(G1H2(47),32,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(18),ex6(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(20),ex6(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(24),ex6(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(26),ex6(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(30),ex5(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(32),ex5(:),G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(36),ex5(:),G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(38),ex5(:),G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hloop_VA_Q(ntryL,G1H2(1),ex6(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(9),n2h1(1))
  call Hloop_VA_Q(ntryL,G1H2(2),ex6(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,nMB,G2tensor(10),n2h1(2))
  call Hloop_VA_Q(ntryL,G1H2(5),ex6(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(11),n2h1(3))
  call Hloop_VQ_A(ntryL,G1H8(1),wf8(:,11),G1H1(1),m3h8x1(:,1),heltab2x8(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(12),n2h1(4))
  call Hloop_VQ_A(ntryL,G1H8(2),wf8(:,11),G1H1(1),m3h8x1(:,2),heltab2x8(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),19,nMB,G2tensor(13),n2h1(5))
  call Hloop_VQ_A(ntryL,G1H8(6),wf8(:,11),G1H1(1),m3h8x1(:,3),heltab2x8(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(14),n2h1(6))
  call Hloop_VQ_A(ntryL,G1H8(7),wf8(:,13),G1H1(1),m3h8x1(:,4),heltab2x8(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(15),n2h1(7))
  call Hloop_VQ_A(ntryL,G1H8(9),wf8(:,13),G1H1(1),m3h8x1(:,5),heltab2x8(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),19,nMB,G2tensor(16),n2h1(8))
  call Hloop_VQ_A(ntryL,G1H8(12),wf8(:,13),G1H1(1),m3h8x1(:,6),heltab2x8(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(17),n2h1(9))
  call Hloop_VQ_A(ntryL,G1H2(6),ex5(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(18),n2h1(10))
  call Hloop_VQ_A(ntryL,G1H2(7),ex5(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(19),n2h1(11))
  call Hloop_VQ_A(ntryL,G1H2(10),ex5(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(20),n2h1(12))
  call Hloop_VA_Q(ntryL,G1H8(14),wf8(:,2),G1H1(1),m3h8x1(:,7),heltab2x8(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(21),n2h1(13))
  call Hloop_VA_Q(ntryL,G1H8(15),wf8(:,2),G1H1(1),m3h8x1(:,8),heltab2x8(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),35,nMB,G2tensor(22),n2h1(14))
  call Hloop_VA_Q(ntryL,G1H8(19),wf8(:,2),G1H1(1),m3h8x1(:,9),heltab2x8(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(23),n2h1(15))
  call Hloop_VA_Q(ntryL,G1H8(20),wf8(:,4),G1H1(1),m3h8x1(:,10),heltab2x8(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(24),n2h1(16))
  call Hloop_VA_Q(ntryL,G1H8(21),wf8(:,4),G1H1(1),m3h8x1(:,11),heltab2x8(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),35,nMB,G2tensor(25),n2h1(17))
  call Hloop_VA_Q(ntryL,G1H8(25),wf8(:,4),G1H1(1),m3h8x1(:,12),heltab2x8(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(26),n2h1(18))
  call Hloop_VA_Q(ntryL,G1H2(11),ex6(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(27),n2h1(19))
  call Hloop_VA_Q(ntryL,G1H2(12),ex6(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,nMB,G2tensor(28),n2h1(20))
  call Hloop_VA_Q(ntryL,G1H2(15),ex6(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(29),n2h1(21))
  call Hloop_VQ_A(ntryL,G1H8(26),wf8(:,15),G1H1(1),m3h8x1(:,13),heltab2x8(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(30),n2h1(22))
  call Hloop_VQ_A(ntryL,G1H8(27),wf8(:,15),G1H1(1),m3h8x1(:,14),heltab2x8(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),28,nMB,G2tensor(31),n2h1(23))
  call Hloop_VQ_A(ntryL,G1H8(31),wf8(:,15),G1H1(1),m3h8x1(:,15),heltab2x8(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(32),n2h1(24))
  call Hloop_VQ_A(ntryL,G1H8(32),wf8(:,17),G1H1(1),m3h8x1(:,16),heltab2x8(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(33),n2h1(25))
  call Hloop_VQ_A(ntryL,G1H8(34),wf8(:,17),G1H1(1),m3h8x1(:,17),heltab2x8(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),28,nMB,G2tensor(34),n2h1(26))
  call Hloop_VQ_A(ntryL,G1H8(37),wf8(:,17),G1H1(1),m3h8x1(:,18),heltab2x8(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(35),n2h1(27))
  call Hloop_VQ_A(ntryL,G1H2(16),ex5(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(36),n2h1(28))
  call Hloop_VQ_A(ntryL,G1H2(17),ex5(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(37),n2h1(29))
  call Hloop_VQ_A(ntryL,G1H2(20),ex5(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(38),n2h1(30))
  call Hloop_VA_Q(ntryL,G1H8(39),wf8(:,6),G1H1(1),m3h8x1(:,19),heltab2x8(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(39),n2h1(31))
  call Hloop_VA_Q(ntryL,G1H8(40),wf8(:,6),G1H1(1),m3h8x1(:,20),heltab2x8(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),44,nMB,G2tensor(40),n2h1(32))
  call Hloop_VA_Q(ntryL,G1H8(43),wf8(:,6),G1H1(1),m3h8x1(:,21),heltab2x8(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(41),n2h1(33))
  call Hloop_VA_Q(ntryL,G1H8(44),wf8(:,8),G1H1(1),m3h8x1(:,22),heltab2x8(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(42),n2h1(34))
  call Hloop_VA_Q(ntryL,G1H8(45),wf8(:,8),G1H1(1),m3h8x1(:,23),heltab2x8(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),44,nMB,G2tensor(43),n2h1(35))
  call Hloop_VA_Q(ntryL,G1H8(48),wf8(:,8),G1H1(1),m3h8x1(:,24),heltab2x8(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(44),n2h1(36))
  call Hloop_VQ_A(ntryL,G1H2(21),ex5(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(45),n2h1(37))
  call Hloop_VQ_A(ntryL,G1H2(22),ex5(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(46),n2h1(38))
  call Hloop_VQ_A(ntryL,G1H2(25),ex5(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(47),n2h1(39))
  call Hloop_VA_Q(ntryL,G1H2(26),ex6(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(48),n2h1(40))
  call Hloop_VA_Q(ntryL,G1H2(27),ex6(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,nMB,G2tensor(49),n2h1(41))
  call Hloop_VA_Q(ntryL,G1H2(30),ex6(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(50),n2h1(42))
  call Hloop_VA_Q(ntryL,G1H2(31),ex6(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(51),n2h1(43))
  call Hloop_VA_Q(ntryL,G1H2(32),ex6(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,nMB,G2tensor(52),n2h1(44))
  call Hloop_VA_Q(ntryL,G1H2(35),ex6(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(53),n2h1(45))
  call Hloop_VQ_A(ntryL,G1H2(36),ex5(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(54),n2h1(46))
  call Hloop_VQ_A(ntryL,G1H2(37),ex5(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(55),n2h1(47))
  call Hloop_VQ_A(ntryL,G1H2(40),ex5(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(56),n2h1(48))
  call Hloop_VQ_A(ntryL,G1H2(41),ex5(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(57),n2h1(49))
  call Hloop_VQ_A(ntryL,G1H2(42),ex5(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(58),n2h1(50))
  call Hloop_VQ_A(ntryL,G1H2(45),ex5(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(59),n2h1(51))
  call Hloop_VA_Q(ntryL,G1H2(46),ex6(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(60),n2h1(52))
  call Hloop_VA_Q(ntryL,G1H2(47),ex6(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,nMB,G2tensor(61),n2h1(53))
  call Hloop_VA_Q(ntryL,G1H2(50),ex6(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMB,G2tensor(62),n2h1(54))
  call ol_merge_tensors(G2tensor(15),[G2tensor(12)])
  call ol_merge_tensors(G2tensor(24),[G2tensor(21)])
  call ol_merge_tensors(G2tensor(33),[G2tensor(30)])
  call ol_merge_tensors(G2tensor(42),[G2tensor(39)])
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5))
  call G_TensorShift(G1tensor(2),32)
  call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(2),mass4set(:,1),  & 
G1tensor(6),G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10))
  call G_TensorShift(G1tensor(7),32)
  call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(3),mass4set(:,1),  & 
G1tensor(11),G1tensor(12),G1tensor(13),G1tensor(14),G1tensor(15))
  call G_TensorShift(G1tensor(12),16)
  call Hotf_4pt_reduction_last(G2tensor(7),RedSet_4(4),mass4set(:,1),  & 
G1tensor(16),G1tensor(17),G1tensor(18),G1tensor(19),G1tensor(20))
  call G_TensorShift(G1tensor(17),16)
  call Hotf_4pt_reduction_last(G2tensor(9),RedSet_4(5),mass4set(:,2),  & 
G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24),G1tensor(25))
  call G_TensorShift(G1tensor(22),32)
  call Hotf_4pt_reduction_last(G2tensor(15),RedSet_4(6),mass4set(:,2),  & 
G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(27),19)
  call Hotf_4pt_reduction_last(G2tensor(18),RedSet_4(7),mass4set(:,2),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35))
  call G_TensorShift(G1tensor(32),16)
  call Hotf_4pt_reduction_last(G2tensor(24),RedSet_4(8),mass4set(:,2),  & 
G1tensor(36),G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40))
  call G_TensorShift(G1tensor(37),35)
  call Hotf_4pt_reduction_last(G2tensor(27),RedSet_4(9),mass4set(:,2),  & 
G1tensor(41),G1tensor(42),G1tensor(43),G1tensor(44),G1tensor(45))
  call G_TensorShift(G1tensor(42),32)
  call Hotf_4pt_reduction_last(G2tensor(33),RedSet_4(10),mass4set(:,2),  & 
G1tensor(46),G1tensor(47),G1tensor(48),G1tensor(49),G1tensor(50))
  call G_TensorShift(G1tensor(47),28)
  call Hotf_4pt_reduction_last(G2tensor(36),RedSet_4(11),mass4set(:,2),  & 
G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54),G1tensor(55))
  call G_TensorShift(G1tensor(52),16)
  call Hotf_4pt_reduction_last(G2tensor(42),RedSet_4(12),mass4set(:,2),  & 
G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(57),44)
  call Hotf_4pt_reduction_last(G2tensor(45),RedSet_4(13),mass4set(:,2),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65))
  call G_TensorShift(G1tensor(62),16)
  call Hotf_4pt_reduction_last(G2tensor(48),RedSet_4(14),mass4set(:,2),  & 
G1tensor(66),G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70))
  call G_TensorShift(G1tensor(67),32)
  call Hotf_4pt_reduction_last(G2tensor(51),RedSet_4(15),mass4set(:,2),  & 
G1tensor(71),G1tensor(72),G1tensor(73),G1tensor(74),G1tensor(75))
  call G_TensorShift(G1tensor(72),32)
  call Hotf_4pt_reduction_last(G2tensor(54),RedSet_4(16),mass4set(:,2),  & 
G1tensor(76),G1tensor(77),G1tensor(78),G1tensor(79),G1tensor(80))
  call G_TensorShift(G1tensor(77),16)
  call Hotf_4pt_reduction_last(G2tensor(57),RedSet_4(17),mass4set(:,2),  & 
G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84),G1tensor(85))
  call G_TensorShift(G1tensor(82),16)
  call Hotf_4pt_reduction_last(G2tensor(60),RedSet_4(18),mass4set(:,2),  & 
G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(87),32)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(1),mass4set(:,1),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(6),RedSet_4(2),mass4set(:,1),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(3),mass4set(:,1),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(16),RedSet_4(4),mass4set(:,1),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(21),RedSet_4(5),mass4set(:,2),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(6),mass4set(:,2),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(7),mass4set(:,2),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(36),RedSet_4(8),mass4set(:,2),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(9),mass4set(:,2),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(46),RedSet_4(10),mass4set(:,2),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(11),mass4set(:,2),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(56),RedSet_4(12),mass4set(:,2),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(13),mass4set(:,2),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(14),mass4set(:,2),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call Hotf_4pt_reduction_last(G1tensor(71),RedSet_4(15),mass4set(:,2),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
  call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(16),mass4set(:,2),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
  call Hotf_4pt_reduction_last(G1tensor(81),RedSet_4(17),mass4set(:,2),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
  call Hotf_4pt_reduction_last(G1tensor(86),RedSet_4(18),mass4set(:,2),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  call ol_merge_tensors(T0sum(12),[G0tensor(56)])
  call ol_merge_tensors(T0sum(13),[G0tensor(61)])
  call ol_merge_tensors(T0sum(14),[G0tensor(66)])
  call ol_merge_tensors(T0sum(15),[G0tensor(71)])
  call ol_merge_tensors(T0sum(16),[G0tensor(76)])
  call ol_merge_tensors(T0sum(17),[G0tensor(81)])
  call ol_merge_tensors(T0sum(18),[G0tensor(86)])
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(673)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(115),h0tab(:,115),[80,12,35],[nMB,nMB,0],3,3,wf4(:,4),wf4(:,2),wf8(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,17),heltab2x128(:,:,115))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(1),n2h32(17))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(674)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(116),h0tab(:,116),[80,12,35],[nMB,nMB,0],3,3,wf4(:,4),wf4(:,6),wf8(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,18),heltab2x128(:,:,116))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(2),n2h32(18))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(675)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(117),h0tab(:,117),[80,12,35],[nMB,nMB,0],3,3,wf4(:,4),wf4(:,2),wf8(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,19),heltab2x128(:,:,117))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(3),n2h32(19))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(676)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(118),h0tab(:,118),[80,12,35],[nMB,nMB,0],3,3,wf4(:,4),wf4(:,6),wf8(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,20),heltab2x128(:,:,118))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(4),n2h32(20))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(677)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(119),h0tab(:,119),[80,3,44],[nMB,nMB,0],3,3,wf4(:,4),wf4(:,1),wf8(:,6))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,21),heltab2x128(:,:,119))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(5),n2h32(21))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(678)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(120),h0tab(:,120),[80,3,44],[nMB,nMB,0],3,3,wf4(:,4),wf4(:,1),wf8(:,8))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,22),heltab2x128(:,:,120))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(6),n2h32(22))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(679)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(121),h0tab(:,121),[80,3,44],[nMB,nMB,0],3,3,wf4(:,4),wf4(:,8),wf8(:,6))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,23),heltab2x128(:,:,121))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(7),n2h32(23))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(680)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(122),h0tab(:,122),[80,3,44],[nMB,nMB,0],3,3,wf4(:,4),wf4(:,8),wf8(:,8))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,24),heltab2x128(:,:,122))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(8),n2h32(24))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(274)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(123),h0tab(:,123),[80,15,32],[nMB,nMB,0],3,2,wf4(:,4),wf16(:,5))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,25),heltab2x128(:,:,123))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(9),n2h32(25))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(124),h0tab(:,124),[83,12,32],[nMB,nMB,0],3,2,wf16(:,100),wf4(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,100),G0H8(1),m3h16x8(:,1),heltab2x128(:,:,124))
  call Hloop_Q_A(ntryL,G0H8(1),83,nMB,G1H8(1),n2h8(25))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(278)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(125),h0tab(:,125),[83,12,32],[nMB,nMB,0],3,2,wf16(:,100),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,100),G0H8(1),m3h16x8(:,2),heltab2x128(:,:,125))
  call Hloop_Q_A(ntryL,G0H8(1),83,nMB,G1H8(2),n2h8(26))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(280)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(126),h0tab(:,126),[83,12,32],[nMB,nMB,0],3,2,wf16(:,101),wf4(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,101),G0H8(1),m3h16x8(:,3),heltab2x128(:,:,126))
  call Hloop_Q_A(ntryL,G0H8(1),83,nMB,G1H8(6),n2h8(27))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(281)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(127),h0tab(:,127),[83,12,32],[nMB,nMB,0],3,2,wf16(:,101),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,101),G0H8(1),m3h16x8(:,4),heltab2x128(:,:,127))
  call Hloop_Q_A(ntryL,G0H8(1),83,nMB,G1H8(7),n2h8(28))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(284)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(128),h0tab(:,128),[92,3,32],[nMB,nMB,0],3,2,wf16(:,102),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,102),G0H8(1),m3h16x8(:,5),heltab2x128(:,:,128))
  call Hloop_Q_A(ntryL,G0H8(1),92,nMB,G1H8(9),n2h8(29))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(286)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(129),h0tab(:,129),[92,3,32],[nMB,nMB,0],3,2,wf16(:,103),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,103),G0H8(1),m3h16x8(:,6),heltab2x128(:,:,129))
  call Hloop_Q_A(ntryL,G0H8(1),92,nMB,G1H8(12),n2h8(30))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(287)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(130),h0tab(:,130),[92,3,32],[nMB,nMB,0],3,2,wf16(:,102),wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,102),G0H8(1),m3h16x8(:,7),heltab2x128(:,:,130))
  call Hloop_Q_A(ntryL,G0H8(1),92,nMB,G1H8(14),n2h8(31))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(288)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(131),h0tab(:,131),[92,3,32],[nMB,nMB,0],3,2,wf16(:,103),wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,103),G0H8(1),m3h16x8(:,8),heltab2x128(:,:,131))
  call Hloop_Q_A(ntryL,G0H8(1),92,nMB,G1H8(15),n2h8(32))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(685)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(132),h0tab(:,132),[96,12,19],[nMB,nMB,0],3,3,wf4(:,10),wf4(:,2),wf8(: &
    ,11))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,26),heltab2x128(:,:,132))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(10),n2h32(26))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(686)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(133),h0tab(:,133),[96,12,19],[nMB,nMB,0],3,3,wf4(:,10),wf4(:,6),wf8(: &
    ,11))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,27),heltab2x128(:,:,133))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(11),n2h32(27))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(687)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(134),h0tab(:,134),[96,12,19],[nMB,nMB,0],3,3,wf4(:,10),wf4(:,2),wf8(: &
    ,13))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,28),heltab2x128(:,:,134))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(12),n2h32(28))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(688)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(135),h0tab(:,135),[96,12,19],[nMB,nMB,0],3,3,wf4(:,10),wf4(:,6),wf8(: &
    ,13))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,29),heltab2x128(:,:,135))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(13),n2h32(29))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(689)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(136),h0tab(:,136),[96,3,28],[nMB,nMB,0],3,3,wf4(:,10),wf4(:,1),wf8(:,15))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,30),heltab2x128(:,:,136))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(14),n2h32(30))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(690)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(137),h0tab(:,137),[96,3,28],[nMB,nMB,0],3,3,wf4(:,10),wf4(:,1),wf8(:,17))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,31),heltab2x128(:,:,137))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(15),n2h32(31))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(691)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(138),h0tab(:,138),[96,3,28],[nMB,nMB,0],3,3,wf4(:,10),wf4(:,8),wf8(:,15))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,32),heltab2x128(:,:,138))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(16),n2h32(32))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(692)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(139),h0tab(:,139),[96,3,28],[nMB,nMB,0],3,3,wf4(:,10),wf4(:,8),wf8(:,17))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,33),heltab2x128(:,:,139))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(17),n2h32(33))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(289)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(140),h0tab(:,140),[96,15,16],[nMB,nMB,0],3,2,wf4(:,10),wf16(:,5))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,34),heltab2x128(:,:,140))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(18),n2h32(34))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(292)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(141),h0tab(:,141),[99,12,16],[nMB,nMB,0],3,2,wf16(:,108),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,108),G0H8(1),m3h16x8(:,9),heltab2x128(:,:,141))
  call Hloop_A_Q(ntryL,G0H8(1),99,nMB,G1H8(19),n2h8(33))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(293)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(142),h0tab(:,142),[99,12,16],[nMB,nMB,0],3,2,wf16(:,108),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,108),G0H8(1),m3h16x8(:,10),heltab2x128(:,:,142))
  call Hloop_A_Q(ntryL,G0H8(1),99,nMB,G1H8(20),n2h8(34))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(295)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(143),h0tab(:,143),[99,12,16],[nMB,nMB,0],3,2,wf16(:,109),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,109),G0H8(1),m3h16x8(:,11),heltab2x128(:,:,143))
  call Hloop_A_Q(ntryL,G0H8(1),99,nMB,G1H8(21),n2h8(35))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(296)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(144),h0tab(:,144),[99,12,16],[nMB,nMB,0],3,2,wf16(:,109),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,109),G0H8(1),m3h16x8(:,12),heltab2x128(:,:,144))
  call Hloop_A_Q(ntryL,G0H8(1),99,nMB,G1H8(25),n2h8(36))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(299)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(145),h0tab(:,145),[108,3,16],[nMB,nMB,0],3,2,wf16(:,110),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,110),G0H8(1),m3h16x8(:,13),heltab2x128(:,:,145))
  call Hloop_A_Q(ntryL,G0H8(1),108,nMB,G1H8(26),n2h8(37))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(301)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(146),h0tab(:,146),[108,3,16],[nMB,nMB,0],3,2,wf16(:,111),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,111),G0H8(1),m3h16x8(:,14),heltab2x128(:,:,146))
  call Hloop_A_Q(ntryL,G0H8(1),108,nMB,G1H8(27),n2h8(38))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(302)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(147),h0tab(:,147),[108,3,16],[nMB,nMB,0],3,2,wf16(:,110),wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,110),G0H8(1),m3h16x8(:,15),heltab2x128(:,:,147))
  call Hloop_A_Q(ntryL,G0H8(1),108,nMB,G1H8(31),n2h8(39))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(303)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(148),h0tab(:,148),[108,3,16],[nMB,nMB,0],3,2,wf16(:,111),wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,111),G0H8(1),m3h16x8(:,16),heltab2x128(:,:,148))
  call Hloop_A_Q(ntryL,G0H8(1),108,nMB,G1H8(32),n2h8(40))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(149),h0tab(:,149),[64,19,44],[nMB,0,nMB],3,2,wf8(:,11),wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,67),heltab2x128(:,:,149))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(1),n2h64(67))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(150),h0tab(:,150),[64,19,44],[nMB,0,nMB],3,2,wf8(:,11),wf8(:,8))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,68),heltab2x128(:,:,150))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(2),n2h64(68))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(151),h0tab(:,151),[64,19,44],[nMB,0,nMB],3,2,wf8(:,13),wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,69),heltab2x128(:,:,151))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(3),n2h64(69))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(152),h0tab(:,152),[64,19,44],[nMB,0,nMB],3,2,wf8(:,13),wf8(:,8))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,70),heltab2x128(:,:,152))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(4),n2h64(70))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(697)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(153),h0tab(:,153),[83,12,32],[nMB,nMB,0],3,2,wf16(:,174),wf4(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,174),G0H8(1),m3h16x8(:,17),heltab2x128(:,:,153))
  call Hloop_Q_A(ntryL,G0H8(1),83,nMB,G1H8(34),n2h8(41))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(698)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(154),h0tab(:,154),[83,12,32],[nMB,nMB,0],3,2,wf16(:,174),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,174),G0H8(1),m3h16x8(:,18),heltab2x128(:,:,154))
  call Hloop_Q_A(ntryL,G0H8(1),83,nMB,G1H8(37),n2h8(42))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(699)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(155),h0tab(:,155),[83,12,32],[nMB,nMB,0],3,2,wf16(:,175),wf4(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,175),G0H8(1),m3h16x8(:,19),heltab2x128(:,:,155))
  call Hloop_Q_A(ntryL,G0H8(1),83,nMB,G1H8(39),n2h8(43))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(700)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(156),h0tab(:,156),[83,12,32],[nMB,nMB,0],3,2,wf16(:,175),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,175),G0H8(1),m3h16x8(:,20),heltab2x128(:,:,156))
  call Hloop_Q_A(ntryL,G0H8(1),83,nMB,G1H8(40),n2h8(44))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(472)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(157),h0tab(:,157),[64,31,32],[nMB,0,nMB],3,1,wf32(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,71),heltab2x128(:,:,157))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(5),n2h64(71))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(474)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(158),h0tab(:,158),[64,31,32],[nMB,0,nMB],3,1,wf32(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,72),heltab2x128(:,:,158))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(6),n2h64(72))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(476)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(159),h0tab(:,159),[64,31,32],[nMB,0,nMB],3,1,wf32(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,73),heltab2x128(:,:,159))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(7),n2h64(73))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(478)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(160),h0tab(:,160),[64,31,32],[nMB,0,nMB],3,1,wf32(:,8))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,74),heltab2x128(:,:,160))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(8),n2h64(74))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(161),h0tab(:,161),[64,28,35],[nMB,0,nMB],3,2,wf8(:,15),wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,75),heltab2x128(:,:,161))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(9),n2h64(75))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(162),h0tab(:,162),[64,28,35],[nMB,0,nMB],3,2,wf8(:,17),wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,76),heltab2x128(:,:,162))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(10),n2h64(76))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(163),h0tab(:,163),[64,28,35],[nMB,0,nMB],3,2,wf8(:,15),wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,77),heltab2x128(:,:,163))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(11),n2h64(77))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(164),h0tab(:,164),[64,28,35],[nMB,0,nMB],3,2,wf8(:,17),wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,78),heltab2x128(:,:,164))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(12),n2h64(78))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(701)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(165),h0tab(:,165),[99,12,16],[nMB,nMB,0],3,2,wf16(:,171),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,171),G0H8(1),m3h16x8(:,21),heltab2x128(:,:,165))
  call Hloop_A_Q(ntryL,G0H8(1),99,nMB,G1H8(43),n2h8(45))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(702)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(166),h0tab(:,166),[99,12,16],[nMB,nMB,0],3,2,wf16(:,171),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,171),G0H8(1),m3h16x8(:,22),heltab2x128(:,:,166))
  call Hloop_A_Q(ntryL,G0H8(1),99,nMB,G1H8(44),n2h8(46))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(703)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(167),h0tab(:,167),[99,12,16],[nMB,nMB,0],3,2,wf16(:,173),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,173),G0H8(1),m3h16x8(:,23),heltab2x128(:,:,167))
  call Hloop_A_Q(ntryL,G0H8(1),99,nMB,G1H8(45),n2h8(47))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(704)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(168),h0tab(:,168),[99,12,16],[nMB,nMB,0],3,2,wf16(:,173),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,173),G0H8(1),m3h16x8(:,24),heltab2x128(:,:,168))
  call Hloop_A_Q(ntryL,G0H8(1),99,nMB,G1H8(48),n2h8(48))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(481)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(169),h0tab(:,169),[64,16,47],[nMB,0,nMB],3,1,wf32(:,10))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,79),heltab2x128(:,:,169))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(13),n2h64(79))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(483)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(170),h0tab(:,170),[64,16,47],[nMB,0,nMB],3,1,wf32(:,12))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,80),heltab2x128(:,:,170))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(14),n2h64(80))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(485)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(171),h0tab(:,171),[64,16,47],[nMB,0,nMB],3,1,wf32(:,14))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,81),heltab2x128(:,:,171))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(15),n2h64(81))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(487)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(172),h0tab(:,172),[64,16,47],[nMB,0,nMB],3,1,wf32(:,16))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,82),heltab2x128(:,:,172))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(16),n2h64(82))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(705)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(173),h0tab(:,173),[92,3,32],[nMB,nMB,0],3,2,wf16(:,176),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,176),G0H8(1),m3h16x8(:,25),heltab2x128(:,:,173))
  call Hloop_Q_A(ntryL,G0H8(1),92,nMB,G1H8(49),n2h8(49))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(706)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(174),h0tab(:,174),[92,3,32],[nMB,nMB,0],3,2,wf16(:,177),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,177),G0H8(1),m3h16x8(:,26),heltab2x128(:,:,174))
  call Hloop_Q_A(ntryL,G0H8(1),92,nMB,G1H8(50),n2h8(50))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(707)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(175),h0tab(:,175),[92,3,32],[nMB,nMB,0],3,2,wf16(:,176),wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,176),G0H8(1),m3h16x8(:,27),heltab2x128(:,:,175))
  call Hloop_Q_A(ntryL,G0H8(1),92,nMB,G1H8(51),n2h8(51))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(708)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(176),h0tab(:,176),[92,3,32],[nMB,nMB,0],3,2,wf16(:,177),wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,177),G0H8(1),m3h16x8(:,28),heltab2x128(:,:,176))
  call Hloop_Q_A(ntryL,G0H8(1),92,nMB,G1H8(52),n2h8(52))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(489)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(177),h0tab(:,177),[64,31,32],[nMB,0,nMB],3,1,wf32(:,18))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,83),heltab2x128(:,:,177))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(17),n2h64(83))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(491)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(178),h0tab(:,178),[64,31,32],[nMB,0,nMB],3,1,wf32(:,20))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,84),heltab2x128(:,:,178))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(18),n2h64(84))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(493)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(179),h0tab(:,179),[64,31,32],[nMB,0,nMB],3,1,wf32(:,22))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,85),heltab2x128(:,:,179))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(19),n2h64(85))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(495)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(180),h0tab(:,180),[64,31,32],[nMB,0,nMB],3,1,wf32(:,24))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,86),heltab2x128(:,:,180))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(20),n2h64(86))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(709)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(181),h0tab(:,181),[108,3,16],[nMB,nMB,0],3,2,wf16(:,167),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,167),G0H8(1),m3h16x8(:,29),heltab2x128(:,:,181))
  call Hloop_A_Q(ntryL,G0H8(1),108,nMB,G1H8(53),n2h8(53))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(710)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(182),h0tab(:,182),[108,3,16],[nMB,nMB,0],3,2,wf16(:,169),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,169),G0H8(1),m3h16x8(:,30),heltab2x128(:,:,182))
  call Hloop_A_Q(ntryL,G0H8(1),108,nMB,G1H8(54),n2h8(54))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(711)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(183),h0tab(:,183),[108,3,16],[nMB,nMB,0],3,2,wf16(:,167),wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,167),G0H8(1),m3h16x8(:,31),heltab2x128(:,:,183))
  call Hloop_A_Q(ntryL,G0H8(1),108,nMB,G1H8(55),n2h8(55))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(712)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(184),h0tab(:,184),[108,3,16],[nMB,nMB,0],3,2,wf16(:,169),wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,169),G0H8(1),m3h16x8(:,32),heltab2x128(:,:,184))
  call Hloop_A_Q(ntryL,G0H8(1),108,nMB,G1H8(56),n2h8(56))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(497)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(185),h0tab(:,185),[64,16,47],[nMB,0,nMB],3,1,wf32(:,26))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,87),heltab2x128(:,:,185))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(21),n2h64(87))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(499)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(186),h0tab(:,186),[64,16,47],[nMB,0,nMB],3,1,wf32(:,28))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,88),heltab2x128(:,:,186))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(22),n2h64(88))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(501)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(187),h0tab(:,187),[64,16,47],[nMB,0,nMB],3,1,wf32(:,30))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,89),heltab2x128(:,:,187))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(23),n2h64(89))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(503)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(188),h0tab(:,188),[64,16,47],[nMB,0,nMB],3,1,wf32(:,32))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,90),heltab2x128(:,:,188))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(24),n2h64(90))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(504)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(189),h0tab(:,189),[64,31,32],[nMB,0,nMB],3,1,wf32(:,34))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,91),heltab2x128(:,:,189))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(25),n2h64(91))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(505)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(190),h0tab(:,190),[64,16,47],[nMB,0,nMB],3,1,wf32(:,36))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,92),heltab2x128(:,:,190))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(26),n2h64(92))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(508)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(191),h0tab(:,191),[79,16,32],[nMB,0,nMB],3,1,wf32(:,37))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,37),G0H4(1),m3h32x4(:,1),heltab2x128(:,:,191))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(9),n2h4(43))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(510)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(192),h0tab(:,192),[79,16,32],[nMB,0,nMB],3,1,wf32(:,39))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,39),G0H4(1),ngZd,m3h32x4(:,2),heltab2x128(:,:,192))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(10),n2h4(44))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(512)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(193),h0tab(:,193),[79,16,32],[nMB,0,nMB],3,1,wf32(:,40))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,40),G0H4(1),m3h32x4(:,3),heltab2x128(:,:,193))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(11),n2h4(45))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(513)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(194),h0tab(:,194),[79,16,32],[nMB,0,nMB],3,1,wf32(:,42))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,42),G0H4(1),ngZd,m3h32x4(:,4),heltab2x128(:,:,194))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(12),n2h4(46))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(195),h0tab(:,195),[76,19,32],[nMB,0,nMB],3,2,wf8(:,39),wf8(:,11))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,39),G0H16(1),m3h8x16(:,33),heltab2x128(:,:,195))
  call Hloop_A_Q(ntryL,G0H16(1),76,nMB,G1H16(5),n2h16(65))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(115)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(196),h0tab(:,196),[76,19,32],[nMB,0,nMB],3,2,wf8(:,24),wf8(:,11))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,24),G0H16(1),ngZd,m3h8x16(:,34),heltab2x128(:,:,196))
  call Hloop_A_Q(ntryL,G0H16(1),76,nMB,G1H16(15),n2h16(66))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(197),h0tab(:,197),[76,19,32],[nMB,0,nMB],3,2,wf8(:,39),wf8(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,39),G0H16(1),m3h8x16(:,35),heltab2x128(:,:,197))
  call Hloop_A_Q(ntryL,G0H16(1),76,nMB,G1H16(8),n2h16(67))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(198),h0tab(:,198),[76,19,32],[nMB,0,nMB],3,2,wf8(:,24),wf8(:,13))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,24),G0H16(1),ngZd,m3h8x16(:,36),heltab2x128(:,:,198))
  call Hloop_A_Q(ntryL,G0H16(1),76,nMB,G1H16(7),n2h16(68))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(199),h0tab(:,199),[76,16,35],[nMB,0,nMB],3,2,wf8(:,39),wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,39),G0H16(1),m3h8x16(:,37),heltab2x128(:,:,199))
  call Hloop_A_Q(ntryL,G0H16(1),76,nMB,G1H16(25),n2h16(69))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(200),h0tab(:,200),[76,16,35],[nMB,0,nMB],3,2,wf8(:,24),wf8(:,2))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,24),G0H16(1),ngZd,m3h8x16(:,38),heltab2x128(:,:,200))
  call Hloop_A_Q(ntryL,G0H16(1),76,nMB,G1H16(19),n2h16(70))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(120)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(201),h0tab(:,201),[76,16,35],[nMB,0,nMB],3,2,wf8(:,39),wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,39),G0H16(1),m3h8x16(:,39),heltab2x128(:,:,201))
  call Hloop_A_Q(ntryL,G0H16(1),76,nMB,G1H16(17),n2h16(71))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(121)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(202),h0tab(:,202),[76,16,35],[nMB,0,nMB],3,2,wf8(:,24),wf8(:,4))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,24),G0H16(1),ngZd,m3h8x16(:,40),heltab2x128(:,:,202))
  call Hloop_A_Q(ntryL,G0H16(1),76,nMB,G1H16(26),n2h16(72))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(713)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(203),h0tab(:,203),[92,3,32],[nMB,nMB,0],3,2,wf16(:,180),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,180),G0H8(1),m3h16x8(:,33),heltab2x128(:,:,203))
  call Hloop_Q_A(ntryL,G0H8(1),92,nMB,G1H8(57),n2h8(57))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(714)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(204),h0tab(:,204),[92,3,32],[nMB,nMB,0],3,2,wf16(:,181),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,181),G0H8(1),m3h16x8(:,34),heltab2x128(:,:,204))
  call Hloop_Q_A(ntryL,G0H8(1),92,nMB,G1H8(58),n2h8(58))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(715)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(205),h0tab(:,205),[92,3,32],[nMB,nMB,0],3,2,wf16(:,180),wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,180),G0H8(1),m3h16x8(:,35),heltab2x128(:,:,205))
  call Hloop_Q_A(ntryL,G0H8(1),92,nMB,G1H8(59),n2h8(59))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(716)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(206),h0tab(:,206),[92,3,32],[nMB,nMB,0],3,2,wf16(:,181),wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,181),G0H8(1),m3h16x8(:,36),heltab2x128(:,:,206))
  call Hloop_Q_A(ntryL,G0H8(1),92,nMB,G1H8(60),n2h8(60))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(717)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(207),h0tab(:,207),[108,3,16],[nMB,nMB,0],3,2,wf16(:,178),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,178),G0H8(1),m3h16x8(:,37),heltab2x128(:,:,207))
  call Hloop_A_Q(ntryL,G0H8(1),108,nMB,G1H8(61),n2h8(61))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(718)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(208),h0tab(:,208),[108,3,16],[nMB,nMB,0],3,2,wf16(:,179),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,179),G0H8(1),m3h16x8(:,38),heltab2x128(:,:,208))
  call Hloop_A_Q(ntryL,G0H8(1),108,nMB,G1H8(62),n2h8(62))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(719)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(209),h0tab(:,209),[108,3,16],[nMB,nMB,0],3,2,wf16(:,178),wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,178),G0H8(1),m3h16x8(:,39),heltab2x128(:,:,209))
  call Hloop_A_Q(ntryL,G0H8(1),108,nMB,G1H8(63),n2h8(63))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(720)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(210),h0tab(:,210),[108,3,16],[nMB,nMB,0],3,2,wf16(:,179),wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,179),G0H8(1),m3h16x8(:,40),heltab2x128(:,:,210))
  call Hloop_A_Q(ntryL,G0H8(1),108,nMB,G1H8(64),n2h8(64))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(516)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(211),h0tab(:,211),[79,16,32],[nMB,0,nMB],3,1,wf32(:,43))
  call Hloop_AS_Q(ntryL,G0H128(1),wf32(:,43),G0H4(1),ngH,m3h32x4(:,5),heltab2x128(:,:,211))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(13),n2h4(47))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(519)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(212),h0tab(:,212),[79,16,32],[nMB,0,nMB],3,1,wf32(:,44))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,44),G0H4(1),m3h32x4(:,6),heltab2x128(:,:,212))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(14),n2h4(48))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(520)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(213),h0tab(:,213),[79,16,32],[nMB,0,nMB],3,1,wf32(:,46))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,46),G0H4(1),ngZd,m3h32x4(:,7),heltab2x128(:,:,213))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(15),n2h4(49))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(522)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(214),h0tab(:,214),[79,16,32],[nMB,0,nMB],3,1,wf32(:,47))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,47),G0H4(1),m3h32x4(:,8),heltab2x128(:,:,214))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(16),n2h4(50))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(523)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(215),h0tab(:,215),[79,16,32],[nMB,0,nMB],3,1,wf32(:,49))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,49),G0H4(1),ngZd,m3h32x4(:,9),heltab2x128(:,:,215))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(17),n2h4(51))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(525)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(216),h0tab(:,216),[79,16,32],[nMB,0,nMB],3,1,wf32(:,50))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,50),G0H4(1),m3h32x4(:,10),heltab2x128(:,:,216))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(18),n2h4(52))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(526)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(217),h0tab(:,217),[79,16,32],[nMB,0,nMB],3,1,wf32(:,52))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,52),G0H4(1),ngZd,m3h32x4(:,11),heltab2x128(:,:,217))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(19),n2h4(53))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(528)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(218),h0tab(:,218),[79,16,32],[nMB,0,nMB],3,1,wf32(:,53))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,53),G0H4(1),m3h32x4(:,12),heltab2x128(:,:,218))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(20),n2h4(54))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(529)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(219),h0tab(:,219),[79,16,32],[nMB,0,nMB],3,1,wf32(:,55))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,55),G0H4(1),ngZd,m3h32x4(:,13),heltab2x128(:,:,219))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(21),n2h4(55))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(220),h0tab(:,220),[76,19,32],[nMB,0,nMB],3,2,wf8(:,40),wf8(:,11))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,40),G0H16(1),m3h8x16(:,41),heltab2x128(:,:,220))
  call Hloop_A_Q(ntryL,G0H16(1),76,nMB,G1H16(20),n2h16(73))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(221),h0tab(:,221),[76,19,32],[nMB,0,nMB],3,2,wf8(:,34),wf8(:,11))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,34),G0H16(1),ngZd,m3h8x16(:,42),heltab2x128(:,:,221))
  call Hloop_A_Q(ntryL,G0H16(1),76,nMB,G1H16(18),n2h16(74))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(222),h0tab(:,222),[76,19,32],[nMB,0,nMB],3,2,wf8(:,40),wf8(:,13))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,40),G0H16(1),m3h8x16(:,43),heltab2x128(:,:,222))
  call Hloop_A_Q(ntryL,G0H16(1),76,nMB,G1H16(29),n2h16(75))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(223),h0tab(:,223),[76,19,32],[nMB,0,nMB],3,2,wf8(:,34),wf8(:,13))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,34),G0H16(1),ngZd,m3h8x16(:,44),heltab2x128(:,:,223))
  call Hloop_A_Q(ntryL,G0H16(1),76,nMB,G1H16(23),n2h16(76))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(224),h0tab(:,224),[76,16,35],[nMB,0,nMB],3,2,wf8(:,40),wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,40),G0H16(1),m3h8x16(:,45),heltab2x128(:,:,224))
  call Hloop_A_Q(ntryL,G0H16(1),76,nMB,G1H16(21),n2h16(77))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(225),h0tab(:,225),[76,16,35],[nMB,0,nMB],3,2,wf8(:,34),wf8(:,2))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,34),G0H16(1),ngZd,m3h8x16(:,46),heltab2x128(:,:,225))
  call Hloop_A_Q(ntryL,G0H16(1),76,nMB,G1H16(30),n2h16(78))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(129)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(226),h0tab(:,226),[76,16,35],[nMB,0,nMB],3,2,wf8(:,40),wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,40),G0H16(1),m3h8x16(:,47),heltab2x128(:,:,226))
  call Hloop_A_Q(ntryL,G0H16(1),76,nMB,G1H16(24),n2h16(79))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(130)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(227),h0tab(:,227),[76,16,35],[nMB,0,nMB],3,2,wf8(:,34),wf8(:,4))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,34),G0H16(1),ngZd,m3h8x16(:,48),heltab2x128(:,:,227))
  call Hloop_A_Q(ntryL,G0H16(1),76,nMB,G1H16(22),n2h16(80))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(724)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(228),h0tab(:,228),[92,3,32],[nMB,nMB,0],3,2,wf16(:,184),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,184),G0H8(1),m3h16x8(:,41),heltab2x128(:,:,228))
  call Hloop_Q_A(ntryL,G0H8(1),92,nMB,G1H8(65),n2h8(65))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(725)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(229),h0tab(:,229),[92,3,32],[nMB,nMB,0],3,2,wf16(:,185),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,185),G0H8(1),m3h16x8(:,42),heltab2x128(:,:,229))
  call Hloop_Q_A(ntryL,G0H8(1),92,nMB,G1H8(66),n2h8(66))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(726)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(230),h0tab(:,230),[92,3,32],[nMB,nMB,0],3,2,wf16(:,184),wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,184),G0H8(1),m3h16x8(:,43),heltab2x128(:,:,230))
  call Hloop_Q_A(ntryL,G0H8(1),92,nMB,G1H8(67),n2h8(67))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(727)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(231),h0tab(:,231),[92,3,32],[nMB,nMB,0],3,2,wf16(:,185),wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,185),G0H8(1),m3h16x8(:,44),heltab2x128(:,:,231))
  call Hloop_Q_A(ntryL,G0H8(1),92,nMB,G1H8(68),n2h8(68))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(728)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(232),h0tab(:,232),[108,3,16],[nMB,nMB,0],3,2,wf16(:,182),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,182),G0H8(1),m3h16x8(:,45),heltab2x128(:,:,232))
  call Hloop_A_Q(ntryL,G0H8(1),108,nMB,G1H8(69),n2h8(69))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(729)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(233),h0tab(:,233),[108,3,16],[nMB,nMB,0],3,2,wf16(:,183),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,183),G0H8(1),m3h16x8(:,46),heltab2x128(:,:,233))
  call Hloop_A_Q(ntryL,G0H8(1),108,nMB,G1H8(70),n2h8(70))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(730)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(234),h0tab(:,234),[108,3,16],[nMB,nMB,0],3,2,wf16(:,182),wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,182),G0H8(1),m3h16x8(:,47),heltab2x128(:,:,234))
  call Hloop_A_Q(ntryL,G0H8(1),108,nMB,G1H8(71),n2h8(71))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(731)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(235),h0tab(:,235),[108,3,16],[nMB,nMB,0],3,2,wf16(:,183),wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,183),G0H8(1),m3h16x8(:,48),heltab2x128(:,:,235))
  call Hloop_A_Q(ntryL,G0H8(1),108,nMB,G1H8(72),n2h8(72))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(531)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(236),h0tab(:,236),[79,16,32],[nMB,0,nMB],3,1,wf32(:,56))
  call Hloop_AS_Q(ntryL,G0H128(1),wf32(:,56),G0H4(1),ngH,m3h32x4(:,14),heltab2x128(:,:,236))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(22),n2h4(56))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(534)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(237),h0tab(:,237),[79,16,32],[nMB,0,nMB],3,1,wf32(:,57))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,57),G0H4(1),m3h32x4(:,15),heltab2x128(:,:,237))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(23),n2h4(57))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(535)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(238),h0tab(:,238),[79,16,32],[nMB,0,nMB],3,1,wf32(:,59))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,59),G0H4(1),ngZd,m3h32x4(:,16),heltab2x128(:,:,238))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(24),n2h4(58))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(537)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(239),h0tab(:,239),[79,16,32],[nMB,0,nMB],3,1,wf32(:,60))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,60),G0H4(1),m3h32x4(:,17),heltab2x128(:,:,239))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(25),n2h4(59))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(538)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(240),h0tab(:,240),[79,16,32],[nMB,0,nMB],3,1,wf32(:,62))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,62),G0H4(1),ngZd,m3h32x4(:,18),heltab2x128(:,:,240))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(26),n2h4(60))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(735)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(241),h0tab(:,241),[80,15,32],[nMB,nMB,0],3,2,wf4(:,4),wf16(:,35))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,35),heltab2x128(:,:,241))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(19),n2h32(35))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(736)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(242),h0tab(:,242),[80,15,32],[nMB,nMB,0],3,2,wf4(:,4),wf16(:,186))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,36),heltab2x128(:,:,242))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(20),n2h32(36))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(737)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(243),h0tab(:,243),[80,15,32],[nMB,nMB,0],3,2,wf4(:,4),wf16(:,37))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,37),heltab2x128(:,:,243))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(21),n2h32(37))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(738)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(244),h0tab(:,244),[80,15,32],[nMB,nMB,0],3,2,wf4(:,4),wf16(:,187))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,38),heltab2x128(:,:,244))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(22),n2h32(38))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(739)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(245),h0tab(:,245),[80,15,32],[nMB,nMB,0],3,2,wf4(:,4),wf16(:,39))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,39),heltab2x128(:,:,245))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(23),n2h32(39))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(740)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(246),h0tab(:,246),[80,15,32],[nMB,nMB,0],3,2,wf4(:,4),wf16(:,188))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,40),heltab2x128(:,:,246))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(24),n2h32(40))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(741)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(247),h0tab(:,247),[80,15,32],[nMB,nMB,0],3,2,wf4(:,4),wf16(:,41))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,41),heltab2x128(:,:,247))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(25),n2h32(41))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(742)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(248),h0tab(:,248),[80,15,32],[nMB,nMB,0],3,2,wf4(:,4),wf16(:,189))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,42),heltab2x128(:,:,248))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(26),n2h32(42))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(743)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(249),h0tab(:,249),[96,15,16],[nMB,nMB,0],3,2,wf4(:,10),wf16(:,35))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,43),heltab2x128(:,:,249))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(27),n2h32(43))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(744)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(250),h0tab(:,250),[96,15,16],[nMB,nMB,0],3,2,wf4(:,10),wf16(:,186))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,44),heltab2x128(:,:,250))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(28),n2h32(44))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(745)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(251),h0tab(:,251),[96,15,16],[nMB,nMB,0],3,2,wf4(:,10),wf16(:,37))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,45),heltab2x128(:,:,251))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(29),n2h32(45))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(746)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(252),h0tab(:,252),[96,15,16],[nMB,nMB,0],3,2,wf4(:,10),wf16(:,187))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,46),heltab2x128(:,:,252))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(30),n2h32(46))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(747)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(253),h0tab(:,253),[96,15,16],[nMB,nMB,0],3,2,wf4(:,10),wf16(:,39))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,47),heltab2x128(:,:,253))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(31),n2h32(47))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(748)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(254),h0tab(:,254),[96,15,16],[nMB,nMB,0],3,2,wf4(:,10),wf16(:,188))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,48),heltab2x128(:,:,254))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(32),n2h32(48))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(749)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(255),h0tab(:,255),[96,15,16],[nMB,nMB,0],3,2,wf4(:,10),wf16(:,41))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,49),heltab2x128(:,:,255))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(33),n2h32(49))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(750)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(256),h0tab(:,256),[96,15,16],[nMB,nMB,0],3,2,wf4(:,10),wf16(:,189))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,50),heltab2x128(:,:,256))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(34),n2h32(50))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(539)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(257),h0tab(:,257),[64,31,32],[nMB,0,nMB],3,1,wf32(:,64))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,93),heltab2x128(:,:,257))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(27),n2h64(93))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(540)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(258),h0tab(:,258),[64,31,32],[nMB,0,nMB],3,1,wf32(:,66))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,94),heltab2x128(:,:,258))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(28),n2h64(94))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(541)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(259),h0tab(:,259),[64,31,32],[nMB,0,nMB],3,1,wf32(:,68))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,95),heltab2x128(:,:,259))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(29),n2h64(95))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(542)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(260),h0tab(:,260),[64,31,32],[nMB,0,nMB],3,1,wf32(:,70))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,96),heltab2x128(:,:,260))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(30),n2h64(96))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(543)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(261),h0tab(:,261),[64,16,47],[nMB,0,nMB],3,1,wf32(:,72))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,97),heltab2x128(:,:,261))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(31),n2h64(97))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(544)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(262),h0tab(:,262),[64,16,47],[nMB,0,nMB],3,1,wf32(:,74))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,98),heltab2x128(:,:,262))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(32),n2h64(98))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(545)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(263),h0tab(:,263),[64,16,47],[nMB,0,nMB],3,1,wf32(:,76))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,99),heltab2x128(:,:,263))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(33),n2h64(99))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(546)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(264),h0tab(:,264),[64,16,47],[nMB,0,nMB],3,1,wf32(:,78))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,100),heltab2x128(:,:,264))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(34),n2h64(100))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(548)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(265),h0tab(:,265),[79,16,32],[nMB,0,nMB],3,1,wf32(:,79))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,79),G0H4(1),m3h32x4(:,19),heltab2x128(:,:,265))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(27),n2h4(61))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(549)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(266),h0tab(:,266),[79,16,32],[nMB,0,nMB],3,1,wf32(:,81))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,81),G0H4(1),ngZd,m3h32x4(:,20),heltab2x128(:,:,266))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(28),n2h4(62))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(551)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(267),h0tab(:,267),[79,16,32],[nMB,0,nMB],3,1,wf32(:,82))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,82),G0H4(1),m3h32x4(:,21),heltab2x128(:,:,267))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(29),n2h4(63))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(552)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(268),h0tab(:,268),[79,16,32],[nMB,0,nMB],3,1,wf32(:,84))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,84),G0H4(1),ngZd,m3h32x4(:,22),heltab2x128(:,:,268))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(30),n2h4(64))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(553)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(269),h0tab(:,269),[64,31,32],[nMB,0,nMB],3,1,wf32(:,86))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,101),heltab2x128(:,:,269))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(35),n2h64(101))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(554)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(270),h0tab(:,270),[64,31,32],[nMB,0,nMB],3,1,wf32(:,88))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,102),heltab2x128(:,:,270))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(36),n2h64(102))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(555)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(271),h0tab(:,271),[64,31,32],[nMB,0,nMB],3,1,wf32(:,90))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,103),heltab2x128(:,:,271))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(37),n2h64(103))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(556)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(272),h0tab(:,272),[64,31,32],[nMB,0,nMB],3,1,wf32(:,92))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,104),heltab2x128(:,:,272))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(38),n2h64(104))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(557)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(273),h0tab(:,273),[64,16,47],[nMB,0,nMB],3,1,wf32(:,94))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,105),heltab2x128(:,:,273))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(39),n2h64(105))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(558)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(274),h0tab(:,274),[64,16,47],[nMB,0,nMB],3,1,wf32(:,96))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,106),heltab2x128(:,:,274))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(40),n2h64(106))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(559)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(275),h0tab(:,275),[64,16,47],[nMB,0,nMB],3,1,wf32(:,98))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,107),heltab2x128(:,:,275))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(41),n2h64(107))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(560)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(276),h0tab(:,276),[64,16,47],[nMB,0,nMB],3,1,wf32(:,100))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,108),heltab2x128(:,:,276))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(42),n2h64(108))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(562)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(277),h0tab(:,277),[79,16,32],[nMB,0,nMB],3,1,wf32(:,101))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,101),G0H4(1),m3h32x4(:,23),heltab2x128(:,:,277))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(31),n2h4(65))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(563)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(278),h0tab(:,278),[79,16,32],[nMB,0,nMB],3,1,wf32(:,103))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,103),G0H4(1),ngZd,m3h32x4(:,24),heltab2x128(:,:,278))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(32),n2h4(66))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(565)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(279),h0tab(:,279),[79,16,32],[nMB,0,nMB],3,1,wf32(:,104))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,104),G0H4(1),m3h32x4(:,25),heltab2x128(:,:,279))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(33),n2h4(67))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(566)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(280),h0tab(:,280),[79,16,32],[nMB,0,nMB],3,1,wf32(:,106))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,106),G0H4(1),ngZd,m3h32x4(:,26),heltab2x128(:,:,280))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(34),n2h4(68))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(751)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(281),h0tab(:,281),[83,12,32],[nMB,nMB,0],3,2,wf16(:,190),wf4(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,190),G0H8(1),m3h16x8(:,49),heltab2x128(:,:,281))
  call Hloop_Q_A(ntryL,G0H8(1),83,nMB,G1H8(73),n2h8(73))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(752)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(282),h0tab(:,282),[83,12,32],[nMB,nMB,0],3,2,wf16(:,190),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,190),G0H8(1),m3h16x8(:,50),heltab2x128(:,:,282))
  call Hloop_Q_A(ntryL,G0H8(1),83,nMB,G1H8(74),n2h8(74))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(753)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(283),h0tab(:,283),[83,12,32],[nMB,nMB,0],3,2,wf16(:,191),wf4(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,191),G0H8(1),m3h16x8(:,51),heltab2x128(:,:,283))
  call Hloop_Q_A(ntryL,G0H8(1),83,nMB,G1H8(75),n2h8(75))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(754)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(284),h0tab(:,284),[83,12,32],[nMB,nMB,0],3,2,wf16(:,191),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,191),G0H8(1),m3h16x8(:,52),heltab2x128(:,:,284))
  call Hloop_Q_A(ntryL,G0H8(1),83,nMB,G1H8(76),n2h8(76))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(755)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(285),h0tab(:,285),[99,12,16],[nMB,nMB,0],3,2,wf16(:,192),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,192),G0H8(1),m3h16x8(:,53),heltab2x128(:,:,285))
  call Hloop_A_Q(ntryL,G0H8(1),99,nMB,G1H8(77),n2h8(77))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(756)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(286),h0tab(:,286),[99,12,16],[nMB,nMB,0],3,2,wf16(:,192),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,192),G0H8(1),m3h16x8(:,54),heltab2x128(:,:,286))
  call Hloop_A_Q(ntryL,G0H8(1),99,nMB,G1H8(78),n2h8(78))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(757)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(287),h0tab(:,287),[99,12,16],[nMB,nMB,0],3,2,wf16(:,193),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,193),G0H8(1),m3h16x8(:,55),heltab2x128(:,:,287))
  call Hloop_A_Q(ntryL,G0H8(1),99,nMB,G1H8(79),n2h8(79))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(758)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(288),h0tab(:,288),[99,12,16],[nMB,nMB,0],3,2,wf16(:,193),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,193),G0H8(1),m3h16x8(:,56),heltab2x128(:,:,288))
  call Hloop_A_Q(ntryL,G0H8(1),99,nMB,G1H8(80),n2h8(80))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(211)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(289),h0tab(:,289),[67,28,32],[nMB,0,nMB],3,2,wf8(:,67),wf8(:,15))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,67),G0H16(1),m3h8x16(:,49),heltab2x128(:,:,289))
  call Hloop_A_Q(ntryL,G0H16(1),67,nMB,G1H16(9),n2h16(81))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(212)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(290),h0tab(:,290),[67,28,32],[nMB,0,nMB],3,2,wf8(:,67),wf8(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,67),G0H16(1),m3h8x16(:,50),heltab2x128(:,:,290))
  call Hloop_A_Q(ntryL,G0H16(1),67,nMB,G1H16(2),n2h16(82))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(213)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(291),h0tab(:,291),[67,28,32],[nMB,0,nMB],3,2,wf8(:,48),wf8(:,15))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,48),G0H16(1),ngZd,m3h8x16(:,51),heltab2x128(:,:,291))
  call Hloop_A_Q(ntryL,G0H16(1),67,nMB,G1H16(1),n2h16(83))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(214)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(292),h0tab(:,292),[67,28,32],[nMB,0,nMB],3,2,wf8(:,48),wf8(:,17))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,48),G0H16(1),ngZd,m3h8x16(:,52),heltab2x128(:,:,292))
  call Hloop_A_Q(ntryL,G0H16(1),67,nMB,G1H16(11),n2h16(84))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(207)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(293),h0tab(:,293),[67,16,44],[nMB,0,nMB],3,2,wf8(:,67),wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,67),G0H16(1),m3h8x16(:,53),heltab2x128(:,:,293))
  call Hloop_A_Q(ntryL,G0H16(1),67,nMB,G1H16(4),n2h16(85))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(208)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(294),h0tab(:,294),[67,16,44],[nMB,0,nMB],3,2,wf8(:,67),wf8(:,8))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,67),G0H16(1),m3h8x16(:,54),heltab2x128(:,:,294))
  call Hloop_A_Q(ntryL,G0H16(1),67,nMB,G1H16(3),n2h16(86))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(209)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(295),h0tab(:,295),[67,16,44],[nMB,0,nMB],3,2,wf8(:,48),wf8(:,6))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,48),G0H16(1),ngZd,m3h8x16(:,55),heltab2x128(:,:,295))
  call Hloop_A_Q(ntryL,G0H16(1),67,nMB,G1H16(13),n2h16(87))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(210)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(296),h0tab(:,296),[67,16,44],[nMB,0,nMB],3,2,wf8(:,48),wf8(:,8))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,48),G0H16(1),ngZd,m3h8x16(:,56),heltab2x128(:,:,296))
  call Hloop_A_Q(ntryL,G0H16(1),67,nMB,G1H16(6),n2h16(88))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(568)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(297),h0tab(:,297),[79,16,32],[nMB,0,nMB],3,1,wf32(:,107))
  call Hloop_AS_Q(ntryL,G0H128(1),wf32(:,107),G0H4(1),ngH,m3h32x4(:,27),heltab2x128(:,:,297))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(35),n2h4(69))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(570)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(298),h0tab(:,298),[79,16,32],[nMB,0,nMB],3,1,wf32(:,108))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,108),G0H4(1),m3h32x4(:,28),heltab2x128(:,:,298))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(36),n2h4(70))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(571)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(299),h0tab(:,299),[79,16,32],[nMB,0,nMB],3,1,wf32(:,110))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,110),G0H4(1),ngZd,m3h32x4(:,29),heltab2x128(:,:,299))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(37),n2h4(71))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(573)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(300),h0tab(:,300),[79,16,32],[nMB,0,nMB],3,1,wf32(:,111))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,111),G0H4(1),m3h32x4(:,30),heltab2x128(:,:,300))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(38),n2h4(72))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(574)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(301),h0tab(:,301),[79,16,32],[nMB,0,nMB],3,1,wf32(:,113))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,113),G0H4(1),ngZd,m3h32x4(:,31),heltab2x128(:,:,301))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(39),n2h4(73))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(577)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(302),h0tab(:,302),[79,16,32],[nMB,0,nMB],3,1,wf32(:,114))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,114),G0H4(1),m3h32x4(:,32),heltab2x128(:,:,302))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(40),n2h4(74))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(579)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(303),h0tab(:,303),[79,16,32],[nMB,0,nMB],3,1,wf32(:,115))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,115),G0H4(1),m3h32x4(:,33),heltab2x128(:,:,303))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(41),n2h4(75))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(580)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(304),h0tab(:,304),[79,16,32],[nMB,0,nMB],3,1,wf32(:,117))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,117),G0H4(1),ngZd,m3h32x4(:,34),heltab2x128(:,:,304))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(42),n2h4(76))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(581)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(305),h0tab(:,305),[79,16,32],[nMB,0,nMB],3,1,wf32(:,119))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,119),G0H4(1),ngZd,m3h32x4(:,35),heltab2x128(:,:,305))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(43),n2h4(77))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(762)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(306),h0tab(:,306),[83,12,32],[nMB,nMB,0],3,2,wf16(:,194),wf4(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,194),G0H8(1),m3h16x8(:,57),heltab2x128(:,:,306))
  call Hloop_Q_A(ntryL,G0H8(1),83,nMB,G1H8(81),n2h8(81))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(763)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(307),h0tab(:,307),[83,12,32],[nMB,nMB,0],3,2,wf16(:,194),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,194),G0H8(1),m3h16x8(:,58),heltab2x128(:,:,307))
  call Hloop_Q_A(ntryL,G0H8(1),83,nMB,G1H8(82),n2h8(82))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(764)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(308),h0tab(:,308),[83,12,32],[nMB,nMB,0],3,2,wf16(:,195),wf4(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,195),G0H8(1),m3h16x8(:,59),heltab2x128(:,:,308))
  call Hloop_Q_A(ntryL,G0H8(1),83,nMB,G1H8(83),n2h8(83))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(765)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(309),h0tab(:,309),[83,12,32],[nMB,nMB,0],3,2,wf16(:,195),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H128(1),wf16(:,195),G0H8(1),m3h16x8(:,60),heltab2x128(:,:,309))
  call Hloop_Q_A(ntryL,G0H8(1),83,nMB,G1H8(84),n2h8(84))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(766)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(310),h0tab(:,310),[99,12,16],[nMB,nMB,0],3,2,wf16(:,196),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,196),G0H8(1),m3h16x8(:,61),heltab2x128(:,:,310))
  call Hloop_A_Q(ntryL,G0H8(1),99,nMB,G1H8(85),n2h8(85))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(767)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(311),h0tab(:,311),[99,12,16],[nMB,nMB,0],3,2,wf16(:,196),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,196),G0H8(1),m3h16x8(:,62),heltab2x128(:,:,311))
  call Hloop_A_Q(ntryL,G0H8(1),99,nMB,G1H8(86),n2h8(86))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(768)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(312),h0tab(:,312),[99,12,16],[nMB,nMB,0],3,2,wf16(:,197),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,197),G0H8(1),m3h16x8(:,63),heltab2x128(:,:,312))
  call Hloop_A_Q(ntryL,G0H8(1),99,nMB,G1H8(87),n2h8(87))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(769)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(313),h0tab(:,313),[99,12,16],[nMB,nMB,0],3,2,wf16(:,197),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,197),G0H8(1),m3h16x8(:,64),heltab2x128(:,:,313))
  call Hloop_A_Q(ntryL,G0H8(1),99,nMB,G1H8(88),n2h8(88))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(314),h0tab(:,314),[67,28,32],[nMB,0,nMB],3,2,wf8(:,68),wf8(:,15))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,68),G0H16(1),m3h8x16(:,57),heltab2x128(:,:,314))
  call Hloop_A_Q(ntryL,G0H16(1),67,nMB,G1H16(10),n2h16(89))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(315),h0tab(:,315),[67,28,32],[nMB,0,nMB],3,2,wf8(:,68),wf8(:,17))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,68),G0H16(1),m3h8x16(:,58),heltab2x128(:,:,315))
  call Hloop_A_Q(ntryL,G0H16(1),67,nMB,G1H16(12),n2h16(90))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(316),h0tab(:,316),[67,28,32],[nMB,0,nMB],3,2,wf8(:,58),wf8(:,15))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,58),G0H16(1),ngZd,m3h8x16(:,59),heltab2x128(:,:,316))
  call Hloop_A_Q(ntryL,G0H16(1),67,nMB,G1H16(14),n2h16(91))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(223)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(317),h0tab(:,317),[67,28,32],[nMB,0,nMB],3,2,wf8(:,58),wf8(:,17))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,58),G0H16(1),ngZd,m3h8x16(:,60),heltab2x128(:,:,317))
  call Hloop_A_Q(ntryL,G0H16(1),67,nMB,G1H16(16),n2h16(92))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(318),h0tab(:,318),[67,16,44],[nMB,0,nMB],3,2,wf8(:,68),wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,68),G0H16(1),m3h8x16(:,61),heltab2x128(:,:,318))
  call Hloop_A_Q(ntryL,G0H16(1),67,nMB,G1H16(27),n2h16(93))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(319),h0tab(:,319),[67,16,44],[nMB,0,nMB],3,2,wf8(:,68),wf8(:,8))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,68),G0H16(1),m3h8x16(:,62),heltab2x128(:,:,319))
  call Hloop_A_Q(ntryL,G0H16(1),67,nMB,G1H16(28),n2h16(94))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(320),h0tab(:,320),[67,16,44],[nMB,0,nMB],3,2,wf8(:,58),wf8(:,6))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,58),G0H16(1),ngZd,m3h8x16(:,63),heltab2x128(:,:,320))
  call Hloop_A_Q(ntryL,G0H16(1),67,nMB,G1H16(31),n2h16(95))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(321),h0tab(:,321),[67,16,44],[nMB,0,nMB],3,2,wf8(:,58),wf8(:,8))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf8(:,58),G0H16(1),ngZd,m3h8x16(:,64),heltab2x128(:,:,321))
  call Hloop_A_Q(ntryL,G0H16(1),67,nMB,G1H16(32),n2h16(96))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(583)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(322),h0tab(:,322),[79,16,32],[nMB,0,nMB],3,1,wf32(:,120))
  call Hloop_AS_Q(ntryL,G0H128(1),wf32(:,120),G0H4(1),ngH,m3h32x4(:,36),heltab2x128(:,:,322))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(44),n2h4(78))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(585)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(323),h0tab(:,323),[79,16,32],[nMB,0,nMB],3,1,wf32(:,121))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,121),G0H4(1),m3h32x4(:,37),heltab2x128(:,:,323))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(45),n2h4(79))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(586)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(324),h0tab(:,324),[79,16,32],[nMB,0,nMB],3,1,wf32(:,123))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,123),G0H4(1),ngZd,m3h32x4(:,38),heltab2x128(:,:,324))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(46),n2h4(80))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(588)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(325),h0tab(:,325),[79,16,32],[nMB,0,nMB],3,1,wf32(:,124))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,124),G0H4(1),m3h32x4(:,39),heltab2x128(:,:,325))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(47),n2h4(81))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(589)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(326),h0tab(:,326),[79,16,32],[nMB,0,nMB],3,1,wf32(:,126))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,126),G0H4(1),ngZd,m3h32x4(:,40),heltab2x128(:,:,326))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(48),n2h4(82))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(592)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(327),h0tab(:,327),[79,16,32],[nMB,0,nMB],3,1,wf32(:,127))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,127),G0H4(1),m3h32x4(:,41),heltab2x128(:,:,327))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(49),n2h4(83))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(594)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(328),h0tab(:,328),[79,16,32],[nMB,0,nMB],3,1,wf32(:,128))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,128),G0H4(1),m3h32x4(:,42),heltab2x128(:,:,328))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(50),n2h4(84))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(595)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(329),h0tab(:,329),[79,16,32],[nMB,0,nMB],3,1,wf32(:,130))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,130),G0H4(1),ngZd,m3h32x4(:,43),heltab2x128(:,:,329))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(51),n2h4(85))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(596)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(330),h0tab(:,330),[79,16,32],[nMB,0,nMB],3,1,wf32(:,132))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,132),G0H4(1),ngZd,m3h32x4(:,44),heltab2x128(:,:,330))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(52),n2h4(86))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(773)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(331),h0tab(:,331),[80,15,32],[nMB,nMB,0],3,2,wf4(:,4),wf16(:,64))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,51),heltab2x128(:,:,331))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(35),n2h32(51))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(774)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(332),h0tab(:,332),[80,15,32],[nMB,nMB,0],3,2,wf4(:,4),wf16(:,198))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,52),heltab2x128(:,:,332))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(36),n2h32(52))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(775)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(333),h0tab(:,333),[80,15,32],[nMB,nMB,0],3,2,wf4(:,4),wf16(:,66))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,53),heltab2x128(:,:,333))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(37),n2h32(53))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(776)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(334),h0tab(:,334),[80,15,32],[nMB,nMB,0],3,2,wf4(:,4),wf16(:,199))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,54),heltab2x128(:,:,334))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(38),n2h32(54))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(777)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(335),h0tab(:,335),[80,15,32],[nMB,nMB,0],3,2,wf4(:,4),wf16(:,68))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,55),heltab2x128(:,:,335))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(39),n2h32(55))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(778)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(336),h0tab(:,336),[80,15,32],[nMB,nMB,0],3,2,wf4(:,4),wf16(:,69))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,56),heltab2x128(:,:,336))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(40),n2h32(56))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(779)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(337),h0tab(:,337),[80,15,32],[nMB,nMB,0],3,2,wf4(:,4),wf16(:,200))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,57),heltab2x128(:,:,337))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(41),n2h32(57))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(780)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(338),h0tab(:,338),[80,15,32],[nMB,nMB,0],3,2,wf4(:,4),wf16(:,201))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,4),G0H32(1),m3h4x32(:,58),heltab2x128(:,:,338))
  call Hloop_Q_A(ntryL,G0H32(1),80,nMB,G1H32(42),n2h32(58))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(781)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(339),h0tab(:,339),[96,15,16],[nMB,nMB,0],3,2,wf4(:,10),wf16(:,64))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,59),heltab2x128(:,:,339))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(43),n2h32(59))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(782)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(340),h0tab(:,340),[96,15,16],[nMB,nMB,0],3,2,wf4(:,10),wf16(:,198))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,60),heltab2x128(:,:,340))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(44),n2h32(60))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(783)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(341),h0tab(:,341),[96,15,16],[nMB,nMB,0],3,2,wf4(:,10),wf16(:,66))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,61),heltab2x128(:,:,341))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(45),n2h32(61))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(784)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(342),h0tab(:,342),[96,15,16],[nMB,nMB,0],3,2,wf4(:,10),wf16(:,199))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,62),heltab2x128(:,:,342))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(46),n2h32(62))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(785)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(343),h0tab(:,343),[96,15,16],[nMB,nMB,0],3,2,wf4(:,10),wf16(:,68))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,63),heltab2x128(:,:,343))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(47),n2h32(63))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(786)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(344),h0tab(:,344),[96,15,16],[nMB,nMB,0],3,2,wf4(:,10),wf16(:,69))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,64),heltab2x128(:,:,344))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(48),n2h32(64))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(787)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(345),h0tab(:,345),[96,15,16],[nMB,nMB,0],3,2,wf4(:,10),wf16(:,200))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,65),heltab2x128(:,:,345))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(49),n2h32(65))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(788)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(346),h0tab(:,346),[96,15,16],[nMB,nMB,0],3,2,wf4(:,10),wf16(:,201))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,10),G0H32(1),m3h4x32(:,66),heltab2x128(:,:,346))
  call Hloop_A_Q(ntryL,G0H32(1),96,nMB,G1H32(50),n2h32(66))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(597)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(347),h0tab(:,347),[64,31,32],[nMB,0,nMB],3,1,wf32(:,134))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,109),heltab2x128(:,:,347))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(43),n2h64(109))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(598)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(348),h0tab(:,348),[64,31,32],[nMB,0,nMB],3,1,wf32(:,136))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,110),heltab2x128(:,:,348))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(44),n2h64(110))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(599)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(349),h0tab(:,349),[64,31,32],[nMB,0,nMB],3,1,wf32(:,138))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,111),heltab2x128(:,:,349))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(45),n2h64(111))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(600)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(350),h0tab(:,350),[64,31,32],[nMB,0,nMB],3,1,wf32(:,140))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,112),heltab2x128(:,:,350))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(46),n2h64(112))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(601)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(351),h0tab(:,351),[64,16,47],[nMB,0,nMB],3,1,wf32(:,142))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,113),heltab2x128(:,:,351))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(47),n2h64(113))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(602)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(352),h0tab(:,352),[64,16,47],[nMB,0,nMB],3,1,wf32(:,144))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,114),heltab2x128(:,:,352))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(48),n2h64(114))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(603)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(353),h0tab(:,353),[64,16,47],[nMB,0,nMB],3,1,wf32(:,146))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,115),heltab2x128(:,:,353))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(49),n2h64(115))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(604)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(354),h0tab(:,354),[64,16,47],[nMB,0,nMB],3,1,wf32(:,148))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,116),heltab2x128(:,:,354))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(50),n2h64(116))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(605)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(355),h0tab(:,355),[64,31,32],[nMB,0,nMB],3,1,wf32(:,150))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,117),heltab2x128(:,:,355))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(51),n2h64(117))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(606)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(356),h0tab(:,356),[64,31,32],[nMB,0,nMB],3,1,wf32(:,152))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,118),heltab2x128(:,:,356))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(52),n2h64(118))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(607)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(357),h0tab(:,357),[64,31,32],[nMB,0,nMB],3,1,wf32(:,154))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,119),heltab2x128(:,:,357))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(53),n2h64(119))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(608)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(358),h0tab(:,358),[64,31,32],[nMB,0,nMB],3,1,wf32(:,156))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,120),heltab2x128(:,:,358))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(54),n2h64(120))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(609)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(359),h0tab(:,359),[64,16,47],[nMB,0,nMB],3,1,wf32(:,158))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,121),heltab2x128(:,:,359))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(55),n2h64(121))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(610)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(360),h0tab(:,360),[64,16,47],[nMB,0,nMB],3,1,wf32(:,160))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,122),heltab2x128(:,:,360))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(56),n2h64(122))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(611)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(361),h0tab(:,361),[64,16,47],[nMB,0,nMB],3,1,wf32(:,162))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,123),heltab2x128(:,:,361))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(57),n2h64(123))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(612)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(362),h0tab(:,362),[64,16,47],[nMB,0,nMB],3,1,wf32(:,164))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,124),heltab2x128(:,:,362))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMB,G1H64(58),n2h64(124))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(614)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(363),h0tab(:,363),[79,16,32],[nMB,0,nMB],3,1,wf32(:,165))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,165),G0H4(1),m3h32x4(:,45),heltab2x128(:,:,363))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(53),n2h4(87))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(615)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(364),h0tab(:,364),[79,16,32],[nMB,0,nMB],3,1,wf32(:,167))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,167),G0H4(1),ngZd,m3h32x4(:,46),heltab2x128(:,:,364))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(54),n2h4(88))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(617)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(365),h0tab(:,365),[79,16,32],[nMB,0,nMB],3,1,wf32(:,168))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,168),G0H4(1),m3h32x4(:,47),heltab2x128(:,:,365))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(55),n2h4(89))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(618)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(366),h0tab(:,366),[79,16,32],[nMB,0,nMB],3,1,wf32(:,170))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,170),G0H4(1),ngZd,m3h32x4(:,48),heltab2x128(:,:,366))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(56),n2h4(90))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(620)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(367),h0tab(:,367),[79,16,32],[nMB,0,nMB],3,1,wf32(:,171))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,171),G0H4(1),m3h32x4(:,49),heltab2x128(:,:,367))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(57),n2h4(91))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(622)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(368),h0tab(:,368),[79,16,32],[nMB,0,nMB],3,1,wf32(:,172))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,172),G0H4(1),m3h32x4(:,50),heltab2x128(:,:,368))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(58),n2h4(92))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(623)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(369),h0tab(:,369),[79,16,32],[nMB,0,nMB],3,1,wf32(:,174))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,174),G0H4(1),ngZd,m3h32x4(:,51),heltab2x128(:,:,369))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(59),n2h4(93))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(624)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(370),h0tab(:,370),[79,16,32],[nMB,0,nMB],3,1,wf32(:,176))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,176),G0H4(1),ngZd,m3h32x4(:,52),heltab2x128(:,:,370))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(60),n2h4(94))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(626)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(371),h0tab(:,371),[79,16,32],[nMB,0,nMB],3,1,wf32(:,177))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,177),G0H4(1),m3h32x4(:,53),heltab2x128(:,:,371))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(61),n2h4(95))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(627)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(372),h0tab(:,372),[79,16,32],[nMB,0,nMB],3,1,wf32(:,179))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,179),G0H4(1),ngZd,m3h32x4(:,54),heltab2x128(:,:,372))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(62),n2h4(96))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(629)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(373),h0tab(:,373),[79,16,32],[nMB,0,nMB],3,1,wf32(:,180))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,180),G0H4(1),m3h32x4(:,55),heltab2x128(:,:,373))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(63),n2h4(97))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(630)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(374),h0tab(:,374),[79,16,32],[nMB,0,nMB],3,1,wf32(:,182))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,182),G0H4(1),ngZd,m3h32x4(:,56),heltab2x128(:,:,374))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(64),n2h4(98))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(632)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(375),h0tab(:,375),[79,16,32],[nMB,0,nMB],3,1,wf32(:,183))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,183),G0H4(1),m3h32x4(:,57),heltab2x128(:,:,375))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(65),n2h4(99))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(633)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(376),h0tab(:,376),[79,16,32],[nMB,0,nMB],3,1,wf32(:,185))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,185),G0H4(1),ngZd,m3h32x4(:,58),heltab2x128(:,:,376))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(66),n2h4(100))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(635)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(377),h0tab(:,377),[79,16,32],[nMB,0,nMB],3,1,wf32(:,186))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,186),G0H4(1),m3h32x4(:,59),heltab2x128(:,:,377))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(67),n2h4(101))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(636)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(378),h0tab(:,378),[79,16,32],[nMB,0,nMB],3,1,wf32(:,188))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,188),G0H4(1),ngZd,m3h32x4(:,60),heltab2x128(:,:,378))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(68),n2h4(102))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(638)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(379),h0tab(:,379),[79,16,32],[nMB,0,nMB],3,1,wf32(:,189))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,189),G0H4(1),m3h32x4(:,61),heltab2x128(:,:,379))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(69),n2h4(103))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(639)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(380),h0tab(:,380),[79,16,32],[nMB,0,nMB],3,1,wf32(:,191))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,191),G0H4(1),ngZd,m3h32x4(:,62),heltab2x128(:,:,380))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(70),n2h4(104))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(641)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(381),h0tab(:,381),[79,16,32],[nMB,0,nMB],3,1,wf32(:,192))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,192),G0H4(1),m3h32x4(:,63),heltab2x128(:,:,381))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(71),n2h4(105))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(642)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(382),h0tab(:,382),[79,16,32],[nMB,0,nMB],3,1,wf32(:,194))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,194),G0H4(1),ngZd,m3h32x4(:,64),heltab2x128(:,:,382))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(72),n2h4(106))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(644)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(383),h0tab(:,383),[79,16,32],[nMB,0,nMB],3,1,wf32(:,195))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,195),G0H4(1),m3h32x4(:,65),heltab2x128(:,:,383))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(73),n2h4(107))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(645)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(384),h0tab(:,384),[79,16,32],[nMB,0,nMB],3,1,wf32(:,197))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,197),G0H4(1),ngZd,m3h32x4(:,66),heltab2x128(:,:,384))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(74),n2h4(108))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(647)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(385),h0tab(:,385),[79,16,32],[nMB,0,nMB],3,1,wf32(:,198))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,198),G0H4(1),m3h32x4(:,67),heltab2x128(:,:,385))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(75),n2h4(109))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(648)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(386),h0tab(:,386),[79,16,32],[nMB,0,nMB],3,1,wf32(:,200))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,200),G0H4(1),ngZd,m3h32x4(:,68),heltab2x128(:,:,386))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(76),n2h4(110))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(650)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(387),h0tab(:,387),[79,16,32],[nMB,0,nMB],3,1,wf32(:,201))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,201),G0H4(1),m3h32x4(:,69),heltab2x128(:,:,387))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(77),n2h4(111))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(651)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(388),h0tab(:,388),[79,16,32],[nMB,0,nMB],3,1,wf32(:,203))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,203),G0H4(1),ngZd,m3h32x4(:,70),heltab2x128(:,:,388))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(78),n2h4(112))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(653)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(389),h0tab(:,389),[79,16,32],[nMB,0,nMB],3,1,wf32(:,204))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,204),G0H4(1),m3h32x4(:,71),heltab2x128(:,:,389))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(79),n2h4(113))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(654)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(390),h0tab(:,390),[79,16,32],[nMB,0,nMB],3,1,wf32(:,206))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,206),G0H4(1),ngZd,m3h32x4(:,72),heltab2x128(:,:,390))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(80),n2h4(114))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(656)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(391),h0tab(:,391),[79,16,32],[nMB,0,nMB],3,1,wf32(:,207))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,207),G0H4(1),m3h32x4(:,73),heltab2x128(:,:,391))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(81),n2h4(115))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(658)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(392),h0tab(:,392),[79,16,32],[nMB,0,nMB],3,1,wf32(:,208))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,208),G0H4(1),m3h32x4(:,74),heltab2x128(:,:,392))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(82),n2h4(116))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(659)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(393),h0tab(:,393),[79,16,32],[nMB,0,nMB],3,1,wf32(:,210))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,210),G0H4(1),ngZd,m3h32x4(:,75),heltab2x128(:,:,393))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(83),n2h4(117))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(660)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(394),h0tab(:,394),[79,16,32],[nMB,0,nMB],3,1,wf32(:,212))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,212),G0H4(1),ngZd,m3h32x4(:,76),heltab2x128(:,:,394))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(84),n2h4(118))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(662)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(395),h0tab(:,395),[79,16,32],[nMB,0,nMB],3,1,wf32(:,213))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,213),G0H4(1),m3h32x4(:,77),heltab2x128(:,:,395))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(85),n2h4(119))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(663)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(396),h0tab(:,396),[79,16,32],[nMB,0,nMB],3,1,wf32(:,215))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,215),G0H4(1),ngZd,m3h32x4(:,78),heltab2x128(:,:,396))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(86),n2h4(120))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(665)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(397),h0tab(:,397),[79,16,32],[nMB,0,nMB],3,1,wf32(:,216))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,216),G0H4(1),m3h32x4(:,79),heltab2x128(:,:,397))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(87),n2h4(121))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(666)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(398),h0tab(:,398),[79,16,32],[nMB,0,nMB],3,1,wf32(:,218))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,218),G0H4(1),ngZd,m3h32x4(:,80),heltab2x128(:,:,398))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(88),n2h4(122))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(668)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(399),h0tab(:,399),[79,16,32],[nMB,0,nMB],3,1,wf32(:,219))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,219),G0H4(1),m3h32x4(:,81),heltab2x128(:,:,399))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(89),n2h4(123))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(670)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(400),h0tab(:,400),[79,16,32],[nMB,0,nMB],3,1,wf32(:,220))
  call Hloop_AV_Q(ntryL,G0H128(1),wf32(:,220),G0H4(1),m3h32x4(:,82),heltab2x128(:,:,400))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(90),n2h4(124))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(671)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(401),h0tab(:,401),[79,16,32],[nMB,0,nMB],3,1,wf32(:,222))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,222),G0H4(1),ngZd,m3h32x4(:,83),heltab2x128(:,:,401))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(91),n2h4(125))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(672)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(402),h0tab(:,402),[79,16,32],[nMB,0,nMB],3,1,wf32(:,224))
  call Hloop_AZ_Q(ntryL,G0H128(1),wf32(:,224),G0H4(1),ngZd,m3h32x4(:,84),heltab2x128(:,:,402))
  call Hloop_A_Q(ntryL,G0H4(1),79,nMB,G1H4(92),n2h4(126))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(66),[G1H8(65),G1H8(58),G1H8(57),G1H8(50),G1H8(49) &
    ,G1H8(12),G1H8(9),G1H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(68),[G1H8(67),G1H8(60),G1H8(59),G1H8(52),G1H8(51) &
    ,G1H8(15),G1H8(14),G1H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(83),[G1H8(81),G1H8(75),G1H8(73),G1H8(39),G1H8(34),G1H8(6) &
    ,G1H8(1),G1H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(84),[G1H8(82),G1H8(76),G1H8(74),G1H8(40),G1H8(37),G1H8(7) &
    ,G1H8(2),G1H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(70),[G1H8(69),G1H8(62),G1H8(61),G1H8(54),G1H8(53) &
    ,G1H8(27),G1H8(26),G1H8(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(72),[G1H8(71),G1H8(64),G1H8(63),G1H8(56),G1H8(55) &
    ,G1H8(32),G1H8(31),G1H8(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(87),[G1H8(85),G1H8(79),G1H8(77),G1H8(45),G1H8(43) &
    ,G1H8(21),G1H8(19),G1H8(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(88),[G1H8(86),G1H8(80),G1H8(78),G1H8(48),G1H8(44) &
    ,G1H8(25),G1H8(20),G1H8(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(92),[G1H4(91),G1H4(90),G1H4(89),G1H4(88),G1H4(87) &
    ,G1H4(86),G1H4(85),G1H4(84),G1H4(83),G1H4(82),G1H4(81),G1H4(80),G1H4(79),G1H4(78),G1H4(77),G1H4(76),G1H4(75),G1H4(74),G1H4(73) &
    ,G1H4(72),G1H4(71),G1H4(70),G1H4(69),G1H4(68),G1H4(67),G1H4(66),G1H4(65),G1H4(64),G1H4(63),G1H4(62),G1H4(61),G1H4(60),G1H4(59) &
    ,G1H4(58),G1H4(57),G1H4(56),G1H4(55),G1H4(54),G1H4(53),G1H4(52),G1H4(51),G1H4(50),G1H4(49),G1H4(48),G1H4(47),G1H4(46),G1H4(45) &
    ,G1H4(44),G1H4(43),G1H4(42),G1H4(41),G1H4(40),G1H4(39),G1H4(38),G1H4(37),G1H4(36),G1H4(35),G1H4(34),G1H4(33),G1H4(32),G1H4(31) &
    ,G1H4(30),G1H4(29),G1H4(28),G1H4(27),G1H4(26),G1H4(25),G1H4(24),G1H4(23),G1H4(22),G1H4(21),G1H4(20),G1H4(19),G1H4(18),G1H4(17) &
    ,G1H4(16),G1H4(15),G1H4(14),G1H4(13),G1H4(12),G1H4(11),G1H4(10),G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(18),[G1H16(20),G1H16(15),G1H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(23),[G1H16(29),G1H16(7),G1H16(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(30),[G1H16(21),G1H16(19),G1H16(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(22),[G1H16(24),G1H16(26),G1H16(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(14),[G1H16(10),G1H16(1),G1H16(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(16),[G1H16(12),G1H16(11),G1H16(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(31),[G1H16(27),G1H16(13),G1H16(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(32),[G1H16(28),G1H16(6),G1H16(3)])
  call Hloop_QV_A(ntryL,G1H8(66),wf4(:,1),G1H2(1),m3h4x2(:,25),heltab2x8(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(1),n2h2(25))
  call Hloop_QZ_A(ntryL,G1H8(68),wf4(:,8),G1H2(2),ngZd,m3h4x2(:,26),heltab2x8(:,:,58))
  call Hloop_Q_A(ntryL,G1H2(2),95,nMB,G2H2(3),n2h2(26))
  call Hloop_QV_A(ntryL,G1H8(83),wf4(:,2),G1H2(5),m3h4x2(:,27),heltab2x8(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(5),95,nMB,G2H2(5),n2h2(27))
  call Hloop_QZ_A(ntryL,G1H8(84),wf4(:,6),G1H2(6),ngZd,m3h4x2(:,28),heltab2x8(:,:,60))
  call Hloop_Q_A(ntryL,G1H2(6),95,nMB,G2H2(7),n2h2(28))
  call Hloop_AV_Q(ntryL,G1H8(70),wf4(:,1),G1H2(7),m3h4x2(:,29),heltab2x8(:,:,61))
  call Hloop_A_Q(ntryL,G1H2(7),111,nMB,G2H2(15),n2h2(29))
  call Hloop_AZ_Q(ntryL,G1H8(72),wf4(:,8),G1H2(10),ngZd,m3h4x2(:,30),heltab2x8(:,:,62))
  call Hloop_A_Q(ntryL,G1H2(10),111,nMB,G2H2(17),n2h2(30))
  call Hloop_AV_Q(ntryL,G1H8(87),wf4(:,2),G1H2(11),m3h4x2(:,31),heltab2x8(:,:,63))
  call Hloop_A_Q(ntryL,G1H2(11),111,nMB,G2H2(21),n2h2(31))
  call Hloop_AZ_Q(ntryL,G1H8(88),wf4(:,6),G1H2(12),ngZd,m3h4x2(:,32),heltab2x8(:,:,64))
  call Hloop_A_Q(ntryL,G1H2(12),111,nMB,G2H2(23),n2h2(32))
  call Hloop_QV_A(ntryL,G1H32(1),wf4(:,2),G1H8(65),m3h4x8(:,17),heltab2x32(:,:,17))
  call Hloop_Q_A(ntryL,G1H8(65),92,nMB,G2H8(2),n2h8(89))
  call Hloop_QZ_A(ntryL,G1H32(2),wf4(:,6),G1H8(58),ngZd,m3h4x8(:,18),heltab2x32(:,:,18))
  call Hloop_Q_A(ntryL,G1H8(58),92,nMB,G2H8(4),n2h8(90))
  call Hloop_QV_A(ntryL,G1H32(3),wf4(:,2),G1H8(57),m3h4x8(:,19),heltab2x32(:,:,19))
  call Hloop_Q_A(ntryL,G1H8(57),92,nMB,G2H8(7),n2h8(91))
  call Hloop_QZ_A(ntryL,G1H32(4),wf4(:,6),G1H8(50),ngZd,m3h4x8(:,20),heltab2x32(:,:,20))
  call Hloop_Q_A(ntryL,G1H8(50),92,nMB,G2H8(8),n2h8(92))
  call Hloop_QV_A(ntryL,G1H32(5),wf4(:,1),G1H8(49),m3h4x8(:,21),heltab2x32(:,:,21))
  call Hloop_Q_A(ntryL,G1H8(49),83,nMB,G2H8(10),n2h8(93))
  call Hloop_QV_A(ntryL,G1H32(6),wf4(:,1),G1H8(12),m3h4x8(:,22),heltab2x32(:,:,22))
  call Hloop_Q_A(ntryL,G1H8(12),83,nMB,G2H8(12),n2h8(94))
  call Hloop_QZ_A(ntryL,G1H32(7),wf4(:,8),G1H8(9),ngZd,m3h4x8(:,23),heltab2x32(:,:,23))
  call Hloop_Q_A(ntryL,G1H8(9),83,nMB,G2H8(15),n2h8(95))
  call Hloop_QZ_A(ntryL,G1H32(8),wf4(:,8),G1H8(3),ngZd,m3h4x8(:,24),heltab2x32(:,:,24))
  call Hloop_Q_A(ntryL,G1H8(3),83,nMB,G2H8(16),n2h8(96))
  call Hloop_QS_A(ntryL,G1H32(9),wf16(:,5),G1H2(15),ngH,m3h16x2(:,1),heltab2x32(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(15),95,nMB,G2H2(27),n2h2(33))
  call Hloop_AV_Q(ntryL,G1H32(10),wf4(:,2),G1H8(67),m3h4x8(:,25),heltab2x32(:,:,26))
  call Hloop_A_Q(ntryL,G1H8(67),108,nMB,G2H8(1),n2h8(97))
  call Hloop_AZ_Q(ntryL,G1H32(11),wf4(:,6),G1H8(60),ngZd,m3h4x8(:,26),heltab2x32(:,:,27))
  call Hloop_A_Q(ntryL,G1H8(60),108,nMB,G2H8(3),n2h8(98))
  call Hloop_AV_Q(ntryL,G1H32(12),wf4(:,2),G1H8(59),m3h4x8(:,27),heltab2x32(:,:,28))
  call Hloop_A_Q(ntryL,G1H8(59),108,nMB,G2H8(5),n2h8(99))
  call Hloop_AZ_Q(ntryL,G1H32(13),wf4(:,6),G1H8(52),ngZd,m3h4x8(:,28),heltab2x32(:,:,29))
  call Hloop_A_Q(ntryL,G1H8(52),108,nMB,G2H8(6),n2h8(100))
  call Hloop_AV_Q(ntryL,G1H32(14),wf4(:,1),G1H8(51),m3h4x8(:,29),heltab2x32(:,:,30))
  call Hloop_A_Q(ntryL,G1H8(51),99,nMB,G2H8(9),n2h8(101))
  call Hloop_AV_Q(ntryL,G1H32(15),wf4(:,1),G1H8(15),m3h4x8(:,30),heltab2x32(:,:,31))
  call Hloop_A_Q(ntryL,G1H8(15),99,nMB,G2H8(11),n2h8(102))
  call Hloop_AZ_Q(ntryL,G1H32(16),wf4(:,8),G1H8(14),ngZd,m3h4x8(:,31),heltab2x32(:,:,32))
  call Hloop_A_Q(ntryL,G1H8(14),99,nMB,G2H8(13),n2h8(103))
  call Hloop_AZ_Q(ntryL,G1H32(17),wf4(:,8),G1H8(8),ngZd,m3h4x8(:,32),heltab2x32(:,:,33))
  call Hloop_A_Q(ntryL,G1H8(8),99,nMB,G2H8(14),n2h8(104))
  call Hloop_AS_Q(ntryL,G1H32(18),wf16(:,5),G1H2(16),ngH,m3h16x2(:,2),heltab2x32(:,:,34))
  call Hloop_A_Q(ntryL,G1H2(16),111,nMB,G2H2(29),n2h2(34))
  call Hloop_AQ_V(ntryL,G1H64(1),wf8(:,11),G1H8(81),m3h8x8(:,1),heltab2x64(:,:,67))
  call Hloop_AQ_V(ntryL,G1H64(2),wf8(:,11),G1H8(75),m3h8x8(:,2),heltab2x64(:,:,68))
  call Hloop_AQ_V(ntryL,G1H64(3),wf8(:,13),G1H8(73),m3h8x8(:,3),heltab2x64(:,:,69))
  call Hloop_AQ_V(ntryL,G1H64(4),wf8(:,13),G1H8(39),m3h8x8(:,4),heltab2x64(:,:,70))
  call Hloop_AQ_V(ntryL,G1H64(5),wf32(:,2),G1H2(17),m3h32x2(:,1),heltab2x64(:,:,71))
  call Hloop_AQ_V(ntryL,G1H64(6),wf32(:,4),G1H2(20),m3h32x2(:,2),heltab2x64(:,:,72))
  call Hloop_AQ_V(ntryL,G1H64(7),wf32(:,6),G1H2(21),m3h32x2(:,3),heltab2x64(:,:,73))
  call Hloop_AQ_V(ntryL,G1H64(8),wf32(:,8),G1H2(22),m3h32x2(:,4),heltab2x64(:,:,74))
  call Hloop_AQ_V(ntryL,G1H64(9),wf8(:,15),G1H8(34),m3h8x8(:,5),heltab2x64(:,:,75))
  call Hloop_AQ_V(ntryL,G1H64(10),wf8(:,17),G1H8(6),m3h8x8(:,6),heltab2x64(:,:,76))
  call Hloop_AQ_V(ntryL,G1H64(11),wf8(:,15),G1H8(1),m3h8x8(:,7),heltab2x64(:,:,77))
  call Hloop_AQ_V(ntryL,G1H64(12),wf8(:,17),G1H8(13),m3h8x8(:,8),heltab2x64(:,:,78))
  call Hloop_AQ_V(ntryL,G1H64(13),ex5(:),G1H32(1),m3h2x32(:,1),heltab2x64(:,:,79))
  call Hloop_AQ_V(ntryL,G1H64(14),ex5(:),G1H32(2),m3h2x32(:,2),heltab2x64(:,:,80))
  call Hloop_AQ_V(ntryL,G1H64(15),ex5(:),G1H32(3),m3h2x32(:,3),heltab2x64(:,:,81))
  call Hloop_AQ_V(ntryL,G1H64(16),ex5(:),G1H32(4),m3h2x32(:,4),heltab2x64(:,:,82))
  call Hloop_AQ_V(ntryL,G1H64(17),wf32(:,18),G1H2(25),m3h32x2(:,5),heltab2x64(:,:,83))
  call Hloop_AQ_V(ntryL,G1H64(18),wf32(:,20),G1H2(26),m3h32x2(:,6),heltab2x64(:,:,84))
  call Hloop_AQ_V(ntryL,G1H64(19),wf32(:,22),G1H2(27),m3h32x2(:,7),heltab2x64(:,:,85))
  call Hloop_AQ_V(ntryL,G1H64(20),wf32(:,24),G1H2(30),m3h32x2(:,8),heltab2x64(:,:,86))
  call Hloop_AQ_V(ntryL,G1H64(21),ex5(:),G1H32(5),m3h2x32(:,5),heltab2x64(:,:,87))
  call Hloop_AQ_V(ntryL,G1H64(22),ex5(:),G1H32(6),m3h2x32(:,6),heltab2x64(:,:,88))
  call Hloop_AQ_V(ntryL,G1H64(23),ex5(:),G1H32(7),m3h2x32(:,7),heltab2x64(:,:,89))
  call Hloop_AQ_V(ntryL,G1H64(24),ex5(:),G1H32(8),m3h2x32(:,8),heltab2x64(:,:,90))
  call Hloop_AQ_V(ntryL,G1H64(25),wf32(:,34),G1H2(31),m3h32x2(:,9),heltab2x64(:,:,91))
  call Hloop_AQ_V(ntryL,G1H64(26),ex5(:),G1H32(9),m3h2x32(:,9),heltab2x64(:,:,92))
  call Hloop_AQ_V(ntryL,G1H4(92),ex5(:),G1H2(32),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_V(ntryL,G1H16(18),wf8(:,11),G1H2(35),m3h8x2(:,9),heltab2x16(:,:,25))
  call Hloop_AQ_V(ntryL,G1H16(23),wf8(:,13),G1H2(36),m3h8x2(:,10),heltab2x16(:,:,26))
  call Hloop_AQ_V(ntryL,G1H16(30),ex5(:),G1H8(82),m3h2x8(:,9),heltab2x16(:,:,27))
  call Hloop_AQ_V(ntryL,G1H16(22),ex5(:),G1H8(76),m3h2x8(:,10),heltab2x16(:,:,28))
  call Hloop_QV_A(ntryL,G1H32(19),wf16(:,35),G1H2(37),m3h16x2(:,3),heltab2x32(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(37),95,nMB,G2H2(33),n2h2(35))
  call Hloop_QZ_A(ntryL,G1H32(20),wf16(:,186),G1H2(40),ngZd,m3h16x2(:,4),heltab2x32(:,:,36))
  call Hloop_Q_A(ntryL,G1H2(40),95,nMB,G2H2(35),n2h2(36))
  call Hloop_QV_A(ntryL,G1H32(21),wf16(:,37),G1H2(41),m3h16x2(:,5),heltab2x32(:,:,37))
  call Hloop_Q_A(ntryL,G1H2(41),95,nMB,G2H2(2),n2h2(37))
  call Hloop_QZ_A(ntryL,G1H32(22),wf16(:,187),G1H2(42),ngZd,m3h16x2(:,6),heltab2x32(:,:,38))
  call Hloop_Q_A(ntryL,G1H2(42),95,nMB,G2H2(4),n2h2(38))
  call Hloop_QV_A(ntryL,G1H32(23),wf16(:,39),G1H2(45),m3h16x2(:,7),heltab2x32(:,:,39))
  call Hloop_Q_A(ntryL,G1H2(45),95,nMB,G2H2(6),n2h2(39))
  call Hloop_QZ_A(ntryL,G1H32(24),wf16(:,188),G1H2(46),ngZd,m3h16x2(:,8),heltab2x32(:,:,40))
  call Hloop_Q_A(ntryL,G1H2(46),95,nMB,G2H2(8),n2h2(40))
  call Hloop_QV_A(ntryL,G1H32(25),wf16(:,41),G1H2(47),m3h16x2(:,9),heltab2x32(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(47),95,nMB,G2H2(9),n2h2(41))
  call Hloop_QZ_A(ntryL,G1H32(26),wf16(:,189),G1H2(50),ngZd,m3h16x2(:,10),heltab2x32(:,:,42))
  call Hloop_Q_A(ntryL,G1H2(50),95,nMB,G2H2(10),n2h2(42))
  call Hloop_AV_Q(ntryL,G1H32(27),wf16(:,35),G1H2(1),m3h16x2(:,11),heltab2x32(:,:,43))
  call Hloop_A_Q(ntryL,G1H2(1),111,nMB,G2H2(11),n2h2(43))
  call Hloop_AZ_Q(ntryL,G1H32(28),wf16(:,186),G1H2(2),ngZd,m3h16x2(:,12),heltab2x32(:,:,44))
  call Hloop_A_Q(ntryL,G1H2(2),111,nMB,G2H2(12),n2h2(44))
  call Hloop_AV_Q(ntryL,G1H32(29),wf16(:,37),G1H2(5),m3h16x2(:,13),heltab2x32(:,:,45))
  call Hloop_A_Q(ntryL,G1H2(5),111,nMB,G2H2(13),n2h2(45))
  call Hloop_AZ_Q(ntryL,G1H32(30),wf16(:,187),G1H2(6),ngZd,m3h16x2(:,14),heltab2x32(:,:,46))
  call Hloop_A_Q(ntryL,G1H2(6),111,nMB,G2H2(14),n2h2(46))
  call Hloop_AV_Q(ntryL,G1H32(31),wf16(:,39),G1H2(7),m3h16x2(:,15),heltab2x32(:,:,47))
  call Hloop_A_Q(ntryL,G1H2(7),111,nMB,G2H2(18),n2h2(47))
  call Hloop_AZ_Q(ntryL,G1H32(32),wf16(:,188),G1H2(10),ngZd,m3h16x2(:,16),heltab2x32(:,:,48))
  call Hloop_A_Q(ntryL,G1H2(10),111,nMB,G2H2(20),n2h2(48))
  call Hloop_AV_Q(ntryL,G1H32(33),wf16(:,41),G1H2(11),m3h16x2(:,17),heltab2x32(:,:,49))
  call Hloop_A_Q(ntryL,G1H2(11),111,nMB,G2H2(24),n2h2(49))
  call Hloop_AZ_Q(ntryL,G1H32(34),wf16(:,189),G1H2(12),ngZd,m3h16x2(:,18),heltab2x32(:,:,50))
  call Hloop_A_Q(ntryL,G1H2(12),111,nMB,G2H2(26),n2h2(50))
  call Hloop_AQ_V(ntryL,G1H64(27),wf32(:,64),G1H2(15),m3h32x2(:,10),heltab2x64(:,:,93))
  call Hloop_AQ_V(ntryL,G1H64(28),wf32(:,66),G1H2(16),m3h32x2(:,11),heltab2x64(:,:,94))
  call Hloop_AQ_V(ntryL,G1H64(29),wf32(:,68),G1H2(37),m3h32x2(:,12),heltab2x64(:,:,95))
  call Hloop_AQ_V(ntryL,G1H64(30),wf32(:,70),G1H2(40),m3h32x2(:,13),heltab2x64(:,:,96))
  call Hloop_AQ_V(ntryL,G1H64(31),ex5(:),G1H32(10),m3h2x32(:,10),heltab2x64(:,:,97))
  call Hloop_AQ_V(ntryL,G1H64(32),ex5(:),G1H32(11),m3h2x32(:,11),heltab2x64(:,:,98))
  call Hloop_AQ_V(ntryL,G1H64(33),ex5(:),G1H32(12),m3h2x32(:,12),heltab2x64(:,:,99))
  call Hloop_AQ_V(ntryL,G1H64(34),ex5(:),G1H32(13),m3h2x32(:,13),heltab2x64(:,:,100))
  call Hloop_AQ_V(ntryL,G1H64(35),wf32(:,86),G1H2(41),m3h32x2(:,14),heltab2x64(:,:,101))
  call Hloop_AQ_V(ntryL,G1H64(36),wf32(:,88),G1H2(42),m3h32x2(:,15),heltab2x64(:,:,102))
  call Hloop_AQ_V(ntryL,G1H64(37),wf32(:,90),G1H2(45),m3h32x2(:,16),heltab2x64(:,:,103))
  call Hloop_AQ_V(ntryL,G1H64(38),wf32(:,92),G1H2(46),m3h32x2(:,17),heltab2x64(:,:,104))
  call Hloop_AQ_V(ntryL,G1H64(39),ex5(:),G1H32(14),m3h2x32(:,14),heltab2x64(:,:,105))
  call Hloop_AQ_V(ntryL,G1H64(40),ex5(:),G1H32(15),m3h2x32(:,15),heltab2x64(:,:,106))
  call Hloop_AQ_V(ntryL,G1H64(41),ex5(:),G1H32(16),m3h2x32(:,16),heltab2x64(:,:,107))
  call Hloop_AQ_V(ntryL,G1H64(42),ex5(:),G1H32(17),m3h2x32(:,17),heltab2x64(:,:,108))
  call Hloop_AQ_V(ntryL,G1H16(14),wf8(:,15),G1H2(47),m3h8x2(:,11),heltab2x16(:,:,29))
  call Hloop_AQ_V(ntryL,G1H16(16),wf8(:,17),G1H2(50),m3h8x2(:,12),heltab2x16(:,:,30))
  call Hloop_AQ_V(ntryL,G1H16(31),ex5(:),G1H8(74),m3h2x8(:,11),heltab2x16(:,:,31))
  call Hloop_AQ_V(ntryL,G1H16(32),ex5(:),G1H8(40),m3h2x8(:,12),heltab2x16(:,:,32))
  call Hloop_QV_A(ntryL,G1H32(35),wf16(:,64),G1H2(1),m3h16x2(:,19),heltab2x32(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(1),95,nMB,G2H2(30),n2h2(51))
  call Hloop_QZ_A(ntryL,G1H32(36),wf16(:,198),G1H2(2),ngZd,m3h16x2(:,20),heltab2x32(:,:,52))
  call Hloop_Q_A(ntryL,G1H2(2),95,nMB,G2H2(32),n2h2(52))
  call Hloop_QV_A(ntryL,G1H32(37),wf16(:,66),G1H2(5),m3h16x2(:,21),heltab2x32(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(5),95,nMB,G2H2(36),n2h2(53))
  call Hloop_QZ_A(ntryL,G1H32(38),wf16(:,199),G1H2(6),ngZd,m3h16x2(:,22),heltab2x32(:,:,54))
  call Hloop_Q_A(ntryL,G1H2(6),95,nMB,G2H2(38),n2h2(54))
  call Hloop_QV_A(ntryL,G1H32(39),wf16(:,68),G1H2(7),m3h16x2(:,23),heltab2x32(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(7),95,nMB,G2H2(39),n2h2(55))
  call Hloop_QV_A(ntryL,G1H32(40),wf16(:,69),G1H2(10),m3h16x2(:,24),heltab2x32(:,:,56))
  call Hloop_Q_A(ntryL,G1H2(10),95,nMB,G2H2(40),n2h2(56))
  call Hloop_QZ_A(ntryL,G1H32(41),wf16(:,200),G1H2(11),ngZd,m3h16x2(:,25),heltab2x32(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(11),95,nMB,G2H2(41),n2h2(57))
  call Hloop_QZ_A(ntryL,G1H32(42),wf16(:,201),G1H2(12),ngZd,m3h16x2(:,26),heltab2x32(:,:,58))
  call Hloop_Q_A(ntryL,G1H2(12),95,nMB,G2H2(42),n2h2(58))
  call Hloop_AV_Q(ntryL,G1H32(43),wf16(:,64),G1H2(1),m3h16x2(:,27),heltab2x32(:,:,59))
  call Hloop_A_Q(ntryL,G1H2(1),111,nMB,G2H2(43),n2h2(59))
  call Hloop_AZ_Q(ntryL,G1H32(44),wf16(:,198),G1H2(2),ngZd,m3h16x2(:,28),heltab2x32(:,:,60))
  call Hloop_A_Q(ntryL,G1H2(2),111,nMB,G2H2(44),n2h2(60))



end subroutine vamp_1

end module ol_vamp_1_pplllla_eexmmxbbxa_1_/**/REALKIND
