
! **********************************************************************
module ol_tables_storage_pplllla_nenmnmxexuxda_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
  implicit none

  ! helicity tables for the 1-loop recursion
integer(intkind2), save :: h0tab(128,103)
integer(intkind2), save :: heltab2x2(2,2,46)
integer(intkind2), save :: heltab2x4(2,4,9)
integer(intkind2), save :: heltab2x8(2,8,49)
integer(intkind2), save :: heltab2x16(2,16,12)
integer(intkind2), save :: heltab2x32(2,32,34)
integer(intkind2), save :: heltab2x64(2,64,30)
integer(intkind2), save :: heltab2x128(2,128,103)


  ! number of helicity states for openloops recursion steps
integer(intkind2), save :: m0h(103)
integer(intkind2), save :: m3h2x1(3,46)
integer(intkind2), save :: m3h4x1(3,4)
integer(intkind2), save :: m3h8x1(3,29)
integer(intkind2), save :: m3h32x1(3,18)
integer(intkind2), save :: m3h2x2(3,5)
integer(intkind2), save :: m3h4x2(3,16)
integer(intkind2), save :: m3h8x2(3,5)
integer(intkind2), save :: m3h16x2(3,8)
integer(intkind2), save :: m3h32x2(3,6)
integer(intkind2), save :: m3h2x4(3,4)
integer(intkind2), save :: m3h4x4(3,2)
integer(intkind2), save :: m3h16x4(3,8)
integer(intkind2), save :: m3h32x4(3,13)
integer(intkind2), save :: m3h2x8(3,5)
integer(intkind2), save :: m3h4x8(3,8)
integer(intkind2), save :: m3h8x8(3,2)
integer(intkind2), save :: m3h16x8(3,24)
integer(intkind2), save :: m3h4x16(3,8)
integer(intkind2), save :: m3h8x16(3,8)
integer(intkind2), save :: m3h2x32(3,6)
integer(intkind2), save :: m3h4x32(3,28)
integer(intkind2), save :: m3h2x64(3,30)

integer(intkind2), save :: n2h1(71)
integer(intkind2), save :: n2h2(24)
integer(intkind2), save :: n2h4(23)
integer(intkind2), save :: n2h8(34)
integer(intkind2), save :: n2h16(16)
integer(intkind2), save :: n2h32(20)
integer(intkind2), save :: n2h64(30)


contains

!**********************************************************************
subroutine HOL_m3_init()
!**********************************************************************
! initialize m3 arrays for helicity summation
!**********************************************************************
  use KIND_TYPES, only: REALKIND, intkind2

m3h2x1(1,:)=2
m3h2x1(2,:)=1
m3h2x1(3,:)=2
m3h4x1(1,:)=4
m3h4x1(2,:)=1
m3h4x1(3,:)=4
m3h8x1(1,:)=8
m3h8x1(2,:)=1
m3h8x1(3,:)=8
m3h32x1(1,:)=32
m3h32x1(2,:)=1
m3h32x1(3,:)=32
m3h2x2(1,:)=2
m3h2x2(2,:)=2
m3h2x2(3,:)=4
m3h4x2(1,:)=4
m3h4x2(2,:)=2
m3h4x2(3,:)=8
m3h8x2(1,:)=8
m3h8x2(2,:)=2
m3h8x2(3,:)=16
m3h16x2(1,:)=16
m3h16x2(2,:)=2
m3h16x2(3,:)=32
m3h32x2(1,:)=32
m3h32x2(2,:)=2
m3h32x2(3,:)=64
m3h2x4(1,:)=2
m3h2x4(2,:)=4
m3h2x4(3,:)=8
m3h4x4(1,:)=4
m3h4x4(2,:)=4
m3h4x4(3,:)=16
m3h16x4(1,:)=16
m3h16x4(2,:)=4
m3h16x4(3,:)=64
m3h32x4(1,:)=32
m3h32x4(2,:)=4
m3h32x4(3,:)=128
m3h2x8(1,:)=2
m3h2x8(2,:)=8
m3h2x8(3,:)=16
m3h4x8(1,:)=4
m3h4x8(2,:)=8
m3h4x8(3,:)=32
m3h8x8(1,:)=8
m3h8x8(2,:)=8
m3h8x8(3,:)=64
m3h16x8(1,:)=16
m3h16x8(2,:)=8
m3h16x8(3,:)=128
m3h4x16(1,:)=4
m3h4x16(2,:)=16
m3h4x16(3,:)=64
m3h8x16(1,:)=8
m3h8x16(2,:)=16
m3h8x16(3,:)=128
m3h2x32(1,:)=2
m3h2x32(2,:)=32
m3h2x32(3,:)=64
m3h4x32(1,:)=4
m3h4x32(2,:)=32
m3h4x32(3,:)=128
m3h2x64(1,:)=2
m3h2x64(2,:)=64
m3h2x64(3,:)=128

n2h1(:)=1
n2h2(:)=2
n2h4(:)=4
n2h8(:)=8
n2h16(:)=16
n2h32(:)=32
n2h64(:)=64


end subroutine HOL_m3_init

!**********************************************************************

end module ol_tables_storage_pplllla_nenmnmxexuxda_1_/**/REALKIND

! **********************************************************************
module ol_tensor_sum_storage_pplllla_nenmnmxexuxda_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol, hcl, met
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
  implicit none

  type(met), save :: M2L1R1

  ! Declarations of loop wave function tensors

  type(hol), save :: G0H1(1)
  type(hol), save :: G1H1(1)
  type(hol), save :: G1H2(40)
  type(hol), save :: G2H2(20)
  type(hol), save :: G0H4(1)
  type(hol), save :: G1H4(17)
  type(hol), save :: G2H4(10)
  type(hol), save :: G0H8(3)
  type(hol), save :: G1H8(24)
  type(hol), save :: G2H8(4)
  type(hol), save :: G0H16(1)
  type(hol), save :: G1H16(4)
  type(hol), save :: G2H16(8)
  type(hol), save :: G0H32(9)
  type(hol), save :: G1H32(12)
  type(hol), save :: G0H64(1)
  type(hol), save :: G1H64(16)
  type(hol), save :: G0H128(1)
  type(hcl), save, dimension(132) :: G0tensor
  type(hcl), save, dimension(80) :: G1tensor
  type(hcl), save, dimension(64) :: G2tensor



  ! Declarations for on-the-fly tensor reduction
type (basis),      save :: RedBasis(33)
type (redset4),    save :: RedSet_4(16)
integer, save :: mass2set(0:1,1)
integer, save :: mass3set(0:2,1)
integer, save :: mass4set(0:3,1)



  ! Declarations for TI calls

  integer, save :: momenta_1(2)
  integer, save :: momenta_2(2)
  integer, save :: momenta_3(2)
  integer, save :: momenta_4(2)
  integer, save :: momenta_5(2)
  integer, save :: momenta_6(2)
  integer, save :: momenta_7(2)
  integer, save :: momenta_8(2)
  integer, save :: momenta_9(2)
  integer, save :: momenta_10(2)
  integer, save :: momenta_11(2)
  integer, save :: momenta_12(2)
  integer, save :: momenta_13(2)
  integer, save :: momenta_14(2)
  integer, save :: momenta_15(2)
  integer, save :: momenta_16(3)
  integer, save :: momenta_17(3)
  integer, save :: momenta_18(3)
  integer, save :: momenta_19(3)
  integer, save :: momenta_20(3)
  integer, save :: momenta_21(3)
  integer, save :: momenta_22(3)
  integer, save :: momenta_23(3)
  integer, save :: momenta_24(3)
  integer, save :: momenta_25(3)
  integer, save :: momenta_26(3)
  integer, save :: momenta_27(3)
  integer, save :: momenta_28(3)
  integer, save :: momenta_29(3)
  integer, save :: momenta_30(3)
  integer, save :: momenta_31(3)
  integer, save :: momenta_32(3)
  integer, save :: momenta_33(3)
  integer, save :: momenta_34(3)
  integer, save :: momenta_35(3)
  integer, save :: momenta_36(3)
  integer, save :: momenta_37(3)
  integer, save :: momenta_38(3)
  integer, save :: momenta_39(3)
  integer, save :: momenta_40(3)
  integer, save :: momenta_41(3)
  integer, save :: momenta_42(3)
  integer, save :: momenta_43(3)
  integer, save :: momenta_44(3)
  integer, save :: momenta_45(3)
  integer, save :: momenta_46(3)
  integer, save :: momenta_47(3)
  integer, save :: momenta_48(3)
  integer, save :: momenta_49(4)
  integer, save :: momenta_50(4)
  integer, save :: momenta_51(4)
  integer, save :: momenta_52(4)
  integer, save :: momenta_53(4)
  integer, save :: momenta_54(4)
  integer, save :: momenta_55(4)
  integer, save :: momenta_56(4)
  integer, save :: momenta_57(4)
  integer, save :: momenta_58(4)
  integer, save :: momenta_59(4)
  integer, save :: momenta_60(4)
  integer, save :: momenta_61(4)
  integer, save :: momenta_62(4)
  integer, save :: momenta_63(4)
  integer, save :: momenta_64(4)

  integer, save :: masses2_1(2)
  integer, save :: masses2_2(3)
  integer, save :: masses2_3(4)



  type(hcl), save, dimension(64) :: T0sum


  contains

!**********************************************************************
subroutine HOL_memory_allocation_full()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_loop_storage_pplllla_nenmnmxexuxda_1_/**/DREALKIND, only: nhel
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none

    call hol_allocation(4,1,4,1,G0H1,1)
  call hol_allocation(4,5,4,1,G1H1,1)
  call hol_allocation(4,5,4,2,G1H2,40)
  call hol_allocation(4,15,4,2,G2H2,20)
  call hol_allocation(4,1,4,4,G0H4,1)
  call hol_allocation(4,5,4,4,G1H4,17)
  call hol_allocation(4,15,4,4,G2H4,10)
  call hol_allocation(4,1,4,8,G0H8,3)
  call hol_allocation(4,5,4,8,G1H8,24)
  call hol_allocation(4,15,4,8,G2H8,4)
  call hol_allocation(4,1,4,16,G0H16,1)
  call hol_allocation(4,5,4,16,G1H16,4)
  call hol_allocation(4,15,4,16,G2H16,8)
  call hol_allocation(4,1,4,32,G0H32,9)
  call hol_allocation(4,5,4,32,G1H32,12)
  call hol_allocation(4,1,4,64,G0H64,1)
  call hol_allocation(4,5,4,64,G1H64,16)
  call hol_allocation(4,1,4,128,G0H128,1)


end subroutine HOL_memory_allocation_full

!**********************************************************************
subroutine HOL_memory_allocation_optimized()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_loop_storage_pplllla_nenmnmxexuxda_1_/**/DREALKIND, only: nhel
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none

    call hol_allocation(4,1,4,min(nhel,1),G0H1,1)
  call hol_allocation(4,5,4,min(nhel,1),G1H1,1)
  call hol_allocation(4,5,4,min(nhel,2),G1H2,40)
  call hol_allocation(4,15,4,min(nhel,2),G2H2,20)
  call hol_allocation(4,1,4,min(nhel,4),G0H4,1)
  call hol_allocation(4,5,4,min(nhel,4),G1H4,17)
  call hol_allocation(4,15,4,min(nhel,4),G2H4,10)
  call hol_allocation(4,1,4,min(nhel,8),G0H8,3)
  call hol_allocation(4,5,4,min(nhel,8),G1H8,24)
  call hol_allocation(4,15,4,min(nhel,8),G2H8,4)
  call hol_allocation(4,1,4,min(nhel,16),G0H16,1)
  call hol_allocation(4,5,4,min(nhel,16),G1H16,4)
  call hol_allocation(4,15,4,min(nhel,16),G2H16,8)
  call hol_allocation(4,1,4,min(nhel,32),G0H32,9)
  call hol_allocation(4,5,4,min(nhel,32),G1H32,12)
  call hol_allocation(4,1,4,min(nhel,64),G0H64,1)
  call hol_allocation(4,5,4,min(nhel,64),G1H64,16)
  call hol_allocation(4,1,4,min(nhel,128),G0H128,1)


end subroutine HOL_memory_allocation_optimized

!**********************************************************************
subroutine HOL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_deallocation
  implicit none
  integer,   intent(in)    :: dmode

    call hol_deallocation(G0H1,1,dmode)
  call hol_deallocation(G1H1,1,dmode)
  call hol_deallocation(G1H2,40,dmode)
  call hol_deallocation(G2H2,20,dmode)
  call hol_deallocation(G0H4,1,dmode)
  call hol_deallocation(G1H4,17,dmode)
  call hol_deallocation(G2H4,10,dmode)
  call hol_deallocation(G0H8,3,dmode)
  call hol_deallocation(G1H8,24,dmode)
  call hol_deallocation(G2H8,4,dmode)
  call hol_deallocation(G0H16,1,dmode)
  call hol_deallocation(G1H16,4,dmode)
  call hol_deallocation(G2H16,8,dmode)
  call hol_deallocation(G0H32,9,dmode)
  call hol_deallocation(G1H32,12,dmode)
  call hol_deallocation(G0H64,1,dmode)
  call hol_deallocation(G1H64,16,dmode)
  call hol_deallocation(G0H128,1,dmode)


end subroutine HOL_memory_deallocation_/**/REALKIND

!**********************************************************************
subroutine HCL_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

  call hcl_allocation(1,G0tensor, 132)
call hcl_allocation(5,G1tensor, 80)
call hcl_allocation(15,G2tensor, 64)


end subroutine HCL_memory_allocation


!**********************************************************************
subroutine HCL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! deallocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_deallocation
  implicit none
  integer,   intent(in)    :: dmode

  call hcl_deallocation(G0tensor, 132,dmode)
call hcl_deallocation(G1tensor, 80,dmode)
call hcl_deallocation(G2tensor, 64,dmode)

    call hcl_deallocation(T0sum,64,dmode)


end subroutine HCL_memory_deallocation_/**/REALKIND


!**********************************************************************
subroutine Tsum_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

    call hcl_allocation(1,T0sum,64)


end subroutine Tsum_memory_allocation


#ifdef PRECISION_dp
subroutine max_point(r) &
    & bind(c,name="ol_f_max_point_pplllla_nenmnmxexuxda_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 4
end subroutine max_point

subroutine tensor_rank(r) &
    & bind(c,name="ol_f_tensor_rank_pplllla_nenmnmxexuxda_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 0
end subroutine tensor_rank
#endif

subroutine reset_tensor_sum()
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  use ol_parameters_init_/**/REALKIND, only: init_hcl
  implicit none
  integer :: i

  do i = 1,64
    call init_hcl(T0sum(i))
  end do

end subroutine reset_tensor_sum


subroutine scale_one_tsum(tsum, spow)
  use ol_parameters_decl_/**/REALKIND, only: scalefactor
  implicit none
  complex(REALKIND), intent(inout) :: tsum(:)
  integer, intent(in) :: spow ! rank 0 scale power
  real(REALKIND) :: sfinv, sfac
  integer :: sz
  sfinv = 1/scalefactor
  sfac = scalefactor**spow
  sz = size(tsum)
  tsum(1) = sfac*tsum(1)
  if (sz > 1) then ! rank 1
    sfac = sfac*sfinv
    tsum(2:5) = sfac*tsum(2:5)
  end if
  if (sz > 5) then ! rank 2
    sfac = sfac*sfinv
    tsum(6:15) = sfac*tsum(6:15)
  end if
  if (sz > 15) then ! rank 3
    sfac = sfac*sfinv
    tsum(16:35) = sfac*tsum(16:35)
  end if
  if (sz > 35) then ! rank 4
    sfac = sfac*sfinv
    tsum(36:70) = sfac*tsum(36:70)
  end if
  if (sz > 70) then ! rank 5
    sfac = sfac*sfinv
    tsum(71:126) = sfac*tsum(71:126)
  end if
  if (sz > 126) then ! rank 6
    sfac = sfac*sfinv
    tsum(127:210) = sfac*tsum(127:210)
  end if
  if (sz > 210) then ! rank 7
    sfac = sfac*sfinv
    tsum(211:330) = sfac*tsum(211:330)
  end if
end subroutine scale_one_tsum


subroutine scale_tensor_sum()
  implicit none
  call scale_one_tsum(T0sum(1)%cmp, -2)
  call scale_one_tsum(T0sum(2)%cmp, -2)
  call scale_one_tsum(T0sum(3)%cmp, -2)
  call scale_one_tsum(T0sum(4)%cmp, -2)
  call scale_one_tsum(T0sum(5)%cmp, -2)
  call scale_one_tsum(T0sum(6)%cmp, -2)
  call scale_one_tsum(T0sum(7)%cmp, -2)
  call scale_one_tsum(T0sum(8)%cmp, -2)
  call scale_one_tsum(T0sum(9)%cmp, -2)
  call scale_one_tsum(T0sum(10)%cmp, -2)
  call scale_one_tsum(T0sum(11)%cmp, -2)
  call scale_one_tsum(T0sum(12)%cmp, -2)
  call scale_one_tsum(T0sum(13)%cmp, -2)
  call scale_one_tsum(T0sum(14)%cmp, -2)
  call scale_one_tsum(T0sum(15)%cmp, -2)
  call scale_one_tsum(T0sum(16)%cmp, -2)
  call scale_one_tsum(T0sum(17)%cmp, -4)
  call scale_one_tsum(T0sum(18)%cmp, -4)
  call scale_one_tsum(T0sum(19)%cmp, -4)
  call scale_one_tsum(T0sum(20)%cmp, -4)
  call scale_one_tsum(T0sum(21)%cmp, -4)
  call scale_one_tsum(T0sum(22)%cmp, -4)
  call scale_one_tsum(T0sum(23)%cmp, -4)
  call scale_one_tsum(T0sum(24)%cmp, -4)
  call scale_one_tsum(T0sum(25)%cmp, -4)
  call scale_one_tsum(T0sum(26)%cmp, -4)
  call scale_one_tsum(T0sum(27)%cmp, -4)
  call scale_one_tsum(T0sum(28)%cmp, -4)
  call scale_one_tsum(T0sum(29)%cmp, -4)
  call scale_one_tsum(T0sum(30)%cmp, -4)
  call scale_one_tsum(T0sum(31)%cmp, -4)
  call scale_one_tsum(T0sum(32)%cmp, -4)
  call scale_one_tsum(T0sum(33)%cmp, -4)
  call scale_one_tsum(T0sum(34)%cmp, -4)
  call scale_one_tsum(T0sum(35)%cmp, -4)
  call scale_one_tsum(T0sum(36)%cmp, -4)
  call scale_one_tsum(T0sum(37)%cmp, -4)
  call scale_one_tsum(T0sum(38)%cmp, -4)
  call scale_one_tsum(T0sum(39)%cmp, -4)
  call scale_one_tsum(T0sum(40)%cmp, -4)
  call scale_one_tsum(T0sum(41)%cmp, -4)
  call scale_one_tsum(T0sum(42)%cmp, -4)
  call scale_one_tsum(T0sum(43)%cmp, -4)
  call scale_one_tsum(T0sum(44)%cmp, -4)
  call scale_one_tsum(T0sum(45)%cmp, -4)
  call scale_one_tsum(T0sum(46)%cmp, -4)
  call scale_one_tsum(T0sum(47)%cmp, -4)
  call scale_one_tsum(T0sum(48)%cmp, -4)
  call scale_one_tsum(T0sum(49)%cmp, -4)
  call scale_one_tsum(T0sum(50)%cmp, -6)
  call scale_one_tsum(T0sum(51)%cmp, -6)
  call scale_one_tsum(T0sum(52)%cmp, -6)
  call scale_one_tsum(T0sum(53)%cmp, -6)
  call scale_one_tsum(T0sum(54)%cmp, -6)
  call scale_one_tsum(T0sum(55)%cmp, -6)
  call scale_one_tsum(T0sum(56)%cmp, -6)
  call scale_one_tsum(T0sum(57)%cmp, -6)
  call scale_one_tsum(T0sum(58)%cmp, -6)
  call scale_one_tsum(T0sum(59)%cmp, -6)
  call scale_one_tsum(T0sum(60)%cmp, -6)
  call scale_one_tsum(T0sum(61)%cmp, -6)
  call scale_one_tsum(T0sum(62)%cmp, -6)
  call scale_one_tsum(T0sum(63)%cmp, -6)
  call scale_one_tsum(T0sum(64)%cmp, -6)

end subroutine scale_tensor_sum

! **********************************************************************
subroutine set_integral_masses_and_momenta()
! **********************************************************************

  use ol_parameters_decl_/**/REALKIND
  momenta_1 = [ 64, 63 ]
  momenta_2 = [ 70, 57 ]
  momenta_3 = [ 73, 54 ]
  momenta_4 = [ 79, 48 ]
  momenta_5 = [ 80, 47 ]
  momenta_6 = [ 86, 41 ]
  momenta_7 = [ 89, 38 ]
  momenta_8 = [ 95, 32 ]
  momenta_9 = [ 96, 31 ]
  momenta_10 = [ 102, 25 ]
  momenta_11 = [ 105, 22 ]
  momenta_12 = [ 111, 16 ]
  momenta_13 = [ 112, 15 ]
  momenta_14 = [ 118, 9 ]
  momenta_15 = [ 121, 6 ]
  momenta_16 = [ 64, 6, 57 ]
  momenta_17 = [ 64, 9, 54 ]
  momenta_18 = [ 64, 15, 48 ]
  momenta_19 = [ 64, 16, 47 ]
  momenta_20 = [ 64, 22, 41 ]
  momenta_21 = [ 64, 25, 38 ]
  momenta_22 = [ 64, 31, 32 ]
  momenta_23 = [ 64, 38, 25 ]
  momenta_24 = [ 64, 41, 22 ]
  momenta_25 = [ 64, 47, 16 ]
  momenta_26 = [ 70, 16, 41 ]
  momenta_27 = [ 70, 25, 32 ]
  momenta_28 = [ 70, 32, 25 ]
  momenta_29 = [ 70, 41, 16 ]
  momenta_30 = [ 73, 6, 48 ]
  momenta_31 = [ 73, 16, 38 ]
  momenta_32 = [ 73, 22, 32 ]
  momenta_33 = [ 73, 32, 22 ]
  momenta_34 = [ 73, 38, 16 ]
  momenta_35 = [ 79, 16, 32 ]
  momenta_36 = [ 79, 32, 16 ]
  momenta_37 = [ 80, 6, 41 ]
  momenta_38 = [ 80, 9, 38 ]
  momenta_39 = [ 80, 15, 32 ]
  momenta_40 = [ 86, 9, 32 ]
  momenta_41 = [ 89, 6, 32 ]
  momenta_42 = [ 96, 6, 25 ]
  momenta_43 = [ 96, 9, 22 ]
  momenta_44 = [ 96, 15, 16 ]
  momenta_45 = [ 102, 9, 16 ]
  momenta_46 = [ 105, 6, 16 ]
  momenta_47 = [ 112, 6, 9 ]
  momenta_48 = [ 112, 9, 6 ]
  momenta_49 = [ 64, 6, 16, 41 ]
  momenta_50 = [ 64, 6, 25, 32 ]
  momenta_51 = [ 64, 6, 32, 25 ]
  momenta_52 = [ 64, 6, 41, 16 ]
  momenta_53 = [ 64, 9, 16, 38 ]
  momenta_54 = [ 64, 9, 22, 32 ]
  momenta_55 = [ 64, 9, 32, 22 ]
  momenta_56 = [ 64, 9, 38, 16 ]
  momenta_57 = [ 64, 15, 16, 32 ]
  momenta_58 = [ 64, 15, 32, 16 ]
  momenta_59 = [ 73, 6, 16, 32 ]
  momenta_60 = [ 73, 6, 32, 16 ]
  momenta_61 = [ 80, 6, 9, 32 ]
  momenta_62 = [ 80, 9, 6, 32 ]
  momenta_63 = [ 96, 6, 9, 16 ]
  momenta_64 = [ 96, 9, 6, 16 ]

  masses2_1 = [ 0, 0 ]
  masses2_2 = [ 0, 0, 0 ]
  masses2_3 = [ 0, 0, 0, 0 ]


end subroutine  set_integral_masses_and_momenta

! **********************************************************************
subroutine integrate_tensor_sum(M2out)
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! only: ZERO, masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: a_switch
#endif
  use ol_parameters_init_/**/REALKIND, only: init_met, add_met, met_to_real
  use ol_loop_routines_/**/REALKIND, only: TI_call_OL
  implicit none
  real(REALKIND), intent(out) :: M2out
  type(met) :: M2
  call init_met(M2)



#ifdef LOOPSQUARED
  if (a_switch == 1 .or. a_switch == 7) then
#endif
  call TI_call_OL(0,0, momenta_61, masses2_3, T0sum(1), M2)
  call TI_call_OL(0,0, momenta_62, masses2_3, T0sum(2), M2)
  call TI_call_OL(0,0, momenta_63, masses2_3, T0sum(3), M2)
  call TI_call_OL(0,0, momenta_64, masses2_3, T0sum(4), M2)
  call TI_call_OL(0,0, momenta_50, masses2_3, T0sum(5), M2)
  call TI_call_OL(0,0, momenta_51, masses2_3, T0sum(6), M2)
  call TI_call_OL(0,0, momenta_52, masses2_3, T0sum(7), M2)
  call TI_call_OL(0,0, momenta_49, masses2_3, T0sum(8), M2)
  call TI_call_OL(0,0, momenta_59, masses2_3, T0sum(9), M2)
  call TI_call_OL(0,0, momenta_60, masses2_3, T0sum(10), M2)
  call TI_call_OL(0,0, momenta_54, masses2_3, T0sum(11), M2)
  call TI_call_OL(0,0, momenta_55, masses2_3, T0sum(12), M2)
  call TI_call_OL(0,0, momenta_56, masses2_3, T0sum(13), M2)
  call TI_call_OL(0,0, momenta_53, masses2_3, T0sum(14), M2)
  call TI_call_OL(0,0, momenta_58, masses2_3, T0sum(15), M2)
  call TI_call_OL(0,0, momenta_57, masses2_3, T0sum(16), M2)
  call TI_call_OL(0,0, momenta_37, masses2_2, T0sum(17), M2)
  call TI_call_OL(0,0, momenta_38, masses2_2, T0sum(18), M2)
  call TI_call_OL(0,0, momenta_42, masses2_2, T0sum(19), M2)
  call TI_call_OL(0,0, momenta_43, masses2_2, T0sum(20), M2)
  call TI_call_OL(0,0, momenta_16, masses2_2, T0sum(21), M2)
  call TI_call_OL(0,0, momenta_41, masses2_2, T0sum(22), M2)
  call TI_call_OL(0,0, momenta_46, masses2_2, T0sum(23), M2)
  call TI_call_OL(0,0, momenta_30, masses2_2, T0sum(24), M2)
  call TI_call_OL(0,0, momenta_17, masses2_2, T0sum(25), M2)
  call TI_call_OL(0,0, momenta_40, masses2_2, T0sum(26), M2)
  call TI_call_OL(0,0, momenta_45, masses2_2, T0sum(27), M2)
  call TI_call_OL(0,0, momenta_39, masses2_2, T0sum(28), M2)
  call TI_call_OL(0,0, momenta_18, masses2_2, T0sum(29), M2)
  call TI_call_OL(0,0, momenta_44, masses2_2, T0sum(30), M2)
  call TI_call_OL(0,0, momenta_47, masses2_2, T0sum(31), M2)
  call TI_call_OL(0,0, momenta_48, masses2_2, T0sum(32), M2)
  call TI_call_OL(0,0, momenta_27, masses2_2, T0sum(33), M2)
  call TI_call_OL(0,0, momenta_22, masses2_2, T0sum(34), M2)
  call TI_call_OL(0,0, momenta_28, masses2_2, T0sum(35), M2)
  call TI_call_OL(0,0, momenta_23, masses2_2, T0sum(36), M2)
  call TI_call_OL(0,0, momenta_29, masses2_2, T0sum(37), M2)
  call TI_call_OL(0,0, momenta_25, masses2_2, T0sum(38), M2)
  call TI_call_OL(0,0, momenta_26, masses2_2, T0sum(39), M2)
  call TI_call_OL(0,0, momenta_20, masses2_2, T0sum(40), M2)
  call TI_call_OL(0,0, momenta_35, masses2_2, T0sum(41), M2)
  call TI_call_OL(0,0, momenta_32, masses2_2, T0sum(42), M2)
  call TI_call_OL(0,0, momenta_36, masses2_2, T0sum(43), M2)
  call TI_call_OL(0,0, momenta_34, masses2_2, T0sum(44), M2)
  call TI_call_OL(0,0, momenta_33, masses2_2, T0sum(45), M2)
  call TI_call_OL(0,0, momenta_24, masses2_2, T0sum(46), M2)
  call TI_call_OL(0,0, momenta_31, masses2_2, T0sum(47), M2)
  call TI_call_OL(0,0, momenta_21, masses2_2, T0sum(48), M2)
  call TI_call_OL(0,0, momenta_19, masses2_2, T0sum(49), M2)
  call TI_call_OL(0,0, momenta_15, masses2_1, T0sum(50), M2)
  call TI_call_OL(0,0, momenta_6, masses2_1, T0sum(51), M2)
  call TI_call_OL(0,0, momenta_5, masses2_1, T0sum(52), M2)
  call TI_call_OL(0,0, momenta_14, masses2_1, T0sum(53), M2)
  call TI_call_OL(0,0, momenta_7, masses2_1, T0sum(54), M2)
  call TI_call_OL(0,0, momenta_10, masses2_1, T0sum(55), M2)
  call TI_call_OL(0,0, momenta_9, masses2_1, T0sum(56), M2)
  call TI_call_OL(0,0, momenta_11, masses2_1, T0sum(57), M2)
  call TI_call_OL(0,0, momenta_2, masses2_1, T0sum(58), M2)
  call TI_call_OL(0,0, momenta_1, masses2_1, T0sum(59), M2)
  call TI_call_OL(0,0, momenta_8, masses2_1, T0sum(60), M2)
  call TI_call_OL(0,0, momenta_12, masses2_1, T0sum(61), M2)
  call TI_call_OL(0,0, momenta_4, masses2_1, T0sum(62), M2)
  call TI_call_OL(0,0, momenta_3, masses2_1, T0sum(63), M2)
  call TI_call_OL(0,0, momenta_13, masses2_1, T0sum(64), M2)

  call add_met(M2,M2L1R1)

#ifdef LOOPSQUARED
  end if
#endif

  call met_to_real(M2out,M2)

#ifdef PRECISION_dp
  call HOL_memory_deallocation_/**/REALKIND(1)
  call HCL_memory_deallocation_/**/REALKIND(1)
#endif

end subroutine integrate_tensor_sum

end module ol_tensor_sum_storage_pplllla_nenmnmxexuxda_1_/**/REALKIND
