
! **********************************************************************
module ol_tables_storage_pplllla_nenenexnexddxa_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
  implicit none

  ! helicity tables for the 1-loop recursion
integer(intkind2), save :: h0tab(128,148)
integer(intkind2), save :: heltab2x2(2,2,68)
integer(intkind2), save :: heltab2x4(2,4,10)
integer(intkind2), save :: heltab2x8(2,8,96)
integer(intkind2), save :: heltab2x16(2,16,16)
integer(intkind2), save :: heltab2x32(2,32,68)
integer(intkind2), save :: heltab2x64(2,64,60)
integer(intkind2), save :: heltab2x128(2,128,148)


  ! number of helicity states for openloops recursion steps
integer(intkind2), save :: m0h(148)
integer(intkind2), save :: m3h2x1(3,68)
integer(intkind2), save :: m3h4x1(3,8)
integer(intkind2), save :: m3h8x1(3,56)
integer(intkind2), save :: m3h32x1(3,36)
integer(intkind2), save :: m3h2x2(3,2)
integer(intkind2), save :: m3h4x2(3,32)
integer(intkind2), save :: m3h8x2(3,8)
integer(intkind2), save :: m3h16x2(3,16)
integer(intkind2), save :: m3h32x2(3,12)
integer(intkind2), save :: m3h2x4(3,8)
integer(intkind2), save :: m3h16x4(3,16)
integer(intkind2), save :: m3h2x8(3,8)
integer(intkind2), save :: m3h4x8(3,16)
integer(intkind2), save :: m3h8x8(3,4)
integer(intkind2), save :: m3h16x8(3,32)
integer(intkind2), save :: m3h4x16(3,16)
integer(intkind2), save :: m3h2x32(3,12)
integer(intkind2), save :: m3h4x32(3,56)
integer(intkind2), save :: m3h2x64(3,60)

integer(intkind2), save :: n2h1(118)
integer(intkind2), save :: n2h2(48)
integer(intkind2), save :: n2h4(16)
integer(intkind2), save :: n2h8(56)
integer(intkind2), save :: n2h16(16)
integer(intkind2), save :: n2h32(40)
integer(intkind2), save :: n2h64(60)


contains

!**********************************************************************
subroutine HOL_m3_init()
!**********************************************************************
! initialize m3 arrays for helicity summation
!**********************************************************************
  use KIND_TYPES, only: REALKIND, intkind2

m3h2x1(1,:)=2
m3h2x1(2,:)=1
m3h2x1(3,:)=2
m3h4x1(1,:)=4
m3h4x1(2,:)=1
m3h4x1(3,:)=4
m3h8x1(1,:)=8
m3h8x1(2,:)=1
m3h8x1(3,:)=8
m3h32x1(1,:)=32
m3h32x1(2,:)=1
m3h32x1(3,:)=32
m3h2x2(1,:)=2
m3h2x2(2,:)=2
m3h2x2(3,:)=4
m3h4x2(1,:)=4
m3h4x2(2,:)=2
m3h4x2(3,:)=8
m3h8x2(1,:)=8
m3h8x2(2,:)=2
m3h8x2(3,:)=16
m3h16x2(1,:)=16
m3h16x2(2,:)=2
m3h16x2(3,:)=32
m3h32x2(1,:)=32
m3h32x2(2,:)=2
m3h32x2(3,:)=64
m3h2x4(1,:)=2
m3h2x4(2,:)=4
m3h2x4(3,:)=8
m3h16x4(1,:)=16
m3h16x4(2,:)=4
m3h16x4(3,:)=64
m3h2x8(1,:)=2
m3h2x8(2,:)=8
m3h2x8(3,:)=16
m3h4x8(1,:)=4
m3h4x8(2,:)=8
m3h4x8(3,:)=32
m3h8x8(1,:)=8
m3h8x8(2,:)=8
m3h8x8(3,:)=64
m3h16x8(1,:)=16
m3h16x8(2,:)=8
m3h16x8(3,:)=128
m3h4x16(1,:)=4
m3h4x16(2,:)=16
m3h4x16(3,:)=64
m3h2x32(1,:)=2
m3h2x32(2,:)=32
m3h2x32(3,:)=64
m3h4x32(1,:)=4
m3h4x32(2,:)=32
m3h4x32(3,:)=128
m3h2x64(1,:)=2
m3h2x64(2,:)=64
m3h2x64(3,:)=128

n2h1(:)=1
n2h2(:)=2
n2h4(:)=4
n2h8(:)=8
n2h16(:)=16
n2h32(:)=32
n2h64(:)=64


end subroutine HOL_m3_init

!**********************************************************************

end module ol_tables_storage_pplllla_nenenexnexddxa_1_/**/REALKIND

! **********************************************************************
module ol_tensor_sum_storage_pplllla_nenenexnexddxa_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol, hcl, met
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
  implicit none

  type(met), save :: M2L1R1

  ! Declarations of loop wave function tensors

  type(hol), save :: G0H1(1)
  type(hol), save :: G1H1(1)
  type(hol), save :: G1H2(50)
  type(hol), save :: G2H2(34)
  type(hol), save :: G1H4(8)
  type(hol), save :: G2H4(16)
  type(hol), save :: G0H8(1)
  type(hol), save :: G1H8(48)
  type(hol), save :: G2H8(8)
  type(hol), save :: G1H16(1)
  type(hol), save :: G2H16(16)
  type(hol), save :: G0H32(17)
  type(hol), save :: G1H32(24)
  type(hol), save :: G0H64(1)
  type(hol), save :: G1H64(32)
  type(hol), save :: G0H128(1)
  type(hcl), save, dimension(224) :: G0tensor
  type(hcl), save, dimension(130) :: G1tensor
  type(hcl), save, dimension(110) :: G2tensor



  ! Declarations for on-the-fly tensor reduction
type (basis),      save :: RedBasis(56)
type (redset4),    save :: RedSet_4(26)
integer, save :: mass2set(0:1,1)
integer, save :: mass3set(0:2,1)
integer, save :: mass4set(0:3,1)



  ! Declarations for TI calls

  integer, save :: momenta_1(2)
  integer, save :: momenta_2(2)
  integer, save :: momenta_3(2)
  integer, save :: momenta_4(2)
  integer, save :: momenta_5(2)
  integer, save :: momenta_6(2)
  integer, save :: momenta_7(2)
  integer, save :: momenta_8(2)
  integer, save :: momenta_9(2)
  integer, save :: momenta_10(2)
  integer, save :: momenta_11(2)
  integer, save :: momenta_12(2)
  integer, save :: momenta_13(2)
  integer, save :: momenta_14(2)
  integer, save :: momenta_15(2)
  integer, save :: momenta_16(2)
  integer, save :: momenta_17(2)
  integer, save :: momenta_18(2)
  integer, save :: momenta_19(2)
  integer, save :: momenta_20(2)
  integer, save :: momenta_21(2)
  integer, save :: momenta_22(2)
  integer, save :: momenta_23(2)
  integer, save :: momenta_24(3)
  integer, save :: momenta_25(3)
  integer, save :: momenta_26(3)
  integer, save :: momenta_27(3)
  integer, save :: momenta_28(3)
  integer, save :: momenta_29(3)
  integer, save :: momenta_30(3)
  integer, save :: momenta_31(3)
  integer, save :: momenta_32(3)
  integer, save :: momenta_33(3)
  integer, save :: momenta_34(3)
  integer, save :: momenta_35(3)
  integer, save :: momenta_36(3)
  integer, save :: momenta_37(3)
  integer, save :: momenta_38(3)
  integer, save :: momenta_39(3)
  integer, save :: momenta_40(3)
  integer, save :: momenta_41(3)
  integer, save :: momenta_42(3)
  integer, save :: momenta_43(3)
  integer, save :: momenta_44(3)
  integer, save :: momenta_45(3)
  integer, save :: momenta_46(3)
  integer, save :: momenta_47(3)
  integer, save :: momenta_48(3)
  integer, save :: momenta_49(3)
  integer, save :: momenta_50(3)
  integer, save :: momenta_51(3)
  integer, save :: momenta_52(3)
  integer, save :: momenta_53(3)
  integer, save :: momenta_54(3)
  integer, save :: momenta_55(3)
  integer, save :: momenta_56(3)
  integer, save :: momenta_57(3)
  integer, save :: momenta_58(3)
  integer, save :: momenta_59(3)
  integer, save :: momenta_60(3)
  integer, save :: momenta_61(3)
  integer, save :: momenta_62(3)
  integer, save :: momenta_63(3)
  integer, save :: momenta_64(3)
  integer, save :: momenta_65(3)
  integer, save :: momenta_66(3)
  integer, save :: momenta_67(3)
  integer, save :: momenta_68(3)
  integer, save :: momenta_69(3)
  integer, save :: momenta_70(3)
  integer, save :: momenta_71(3)
  integer, save :: momenta_72(3)
  integer, save :: momenta_73(3)
  integer, save :: momenta_74(3)
  integer, save :: momenta_75(3)
  integer, save :: momenta_76(3)
  integer, save :: momenta_77(3)
  integer, save :: momenta_78(3)
  integer, save :: momenta_79(3)
  integer, save :: momenta_80(4)
  integer, save :: momenta_81(4)
  integer, save :: momenta_82(4)
  integer, save :: momenta_83(4)
  integer, save :: momenta_84(4)
  integer, save :: momenta_85(4)
  integer, save :: momenta_86(4)
  integer, save :: momenta_87(4)
  integer, save :: momenta_88(4)
  integer, save :: momenta_89(4)
  integer, save :: momenta_90(4)
  integer, save :: momenta_91(4)
  integer, save :: momenta_92(4)
  integer, save :: momenta_93(4)
  integer, save :: momenta_94(4)
  integer, save :: momenta_95(4)
  integer, save :: momenta_96(4)
  integer, save :: momenta_97(4)
  integer, save :: momenta_98(4)
  integer, save :: momenta_99(4)
  integer, save :: momenta_100(4)
  integer, save :: momenta_101(4)
  integer, save :: momenta_102(4)
  integer, save :: momenta_103(4)
  integer, save :: momenta_104(4)
  integer, save :: momenta_105(4)

  integer, save :: masses2_1(2)
  integer, save :: masses2_2(3)
  integer, save :: masses2_3(4)



  type(hcl), save, dimension(105) :: T0sum


  contains

!**********************************************************************
subroutine HOL_memory_allocation_full()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_loop_storage_pplllla_nenenexnexddxa_1_/**/DREALKIND, only: nhel
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none

    call hol_allocation(4,1,4,1,G0H1,1)
  call hol_allocation(4,5,4,1,G1H1,1)
  call hol_allocation(4,5,4,2,G1H2,50)
  call hol_allocation(4,15,4,2,G2H2,34)
  call hol_allocation(4,5,4,4,G1H4,8)
  call hol_allocation(4,15,4,4,G2H4,16)
  call hol_allocation(4,1,4,8,G0H8,1)
  call hol_allocation(4,5,4,8,G1H8,48)
  call hol_allocation(4,15,4,8,G2H8,8)
  call hol_allocation(4,5,4,16,G1H16,1)
  call hol_allocation(4,15,4,16,G2H16,16)
  call hol_allocation(4,1,4,32,G0H32,17)
  call hol_allocation(4,5,4,32,G1H32,24)
  call hol_allocation(4,1,4,64,G0H64,1)
  call hol_allocation(4,5,4,64,G1H64,32)
  call hol_allocation(4,1,4,128,G0H128,1)


end subroutine HOL_memory_allocation_full

!**********************************************************************
subroutine HOL_memory_allocation_optimized()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_loop_storage_pplllla_nenenexnexddxa_1_/**/DREALKIND, only: nhel
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none

    call hol_allocation(4,1,4,min(nhel,1),G0H1,1)
  call hol_allocation(4,5,4,min(nhel,1),G1H1,1)
  call hol_allocation(4,5,4,min(nhel,2),G1H2,50)
  call hol_allocation(4,15,4,min(nhel,2),G2H2,34)
  call hol_allocation(4,5,4,min(nhel,4),G1H4,8)
  call hol_allocation(4,15,4,min(nhel,4),G2H4,16)
  call hol_allocation(4,1,4,min(nhel,8),G0H8,1)
  call hol_allocation(4,5,4,min(nhel,8),G1H8,48)
  call hol_allocation(4,15,4,min(nhel,8),G2H8,8)
  call hol_allocation(4,5,4,min(nhel,16),G1H16,1)
  call hol_allocation(4,15,4,min(nhel,16),G2H16,16)
  call hol_allocation(4,1,4,min(nhel,32),G0H32,17)
  call hol_allocation(4,5,4,min(nhel,32),G1H32,24)
  call hol_allocation(4,1,4,min(nhel,64),G0H64,1)
  call hol_allocation(4,5,4,min(nhel,64),G1H64,32)
  call hol_allocation(4,1,4,min(nhel,128),G0H128,1)


end subroutine HOL_memory_allocation_optimized

!**********************************************************************
subroutine HOL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_deallocation
  implicit none
  integer,   intent(in)    :: dmode

    call hol_deallocation(G0H1,1,dmode)
  call hol_deallocation(G1H1,1,dmode)
  call hol_deallocation(G1H2,50,dmode)
  call hol_deallocation(G2H2,34,dmode)
  call hol_deallocation(G1H4,8,dmode)
  call hol_deallocation(G2H4,16,dmode)
  call hol_deallocation(G0H8,1,dmode)
  call hol_deallocation(G1H8,48,dmode)
  call hol_deallocation(G2H8,8,dmode)
  call hol_deallocation(G1H16,1,dmode)
  call hol_deallocation(G2H16,16,dmode)
  call hol_deallocation(G0H32,17,dmode)
  call hol_deallocation(G1H32,24,dmode)
  call hol_deallocation(G0H64,1,dmode)
  call hol_deallocation(G1H64,32,dmode)
  call hol_deallocation(G0H128,1,dmode)


end subroutine HOL_memory_deallocation_/**/REALKIND

!**********************************************************************
subroutine HCL_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

  call hcl_allocation(1,G0tensor, 224)
call hcl_allocation(5,G1tensor, 130)
call hcl_allocation(15,G2tensor, 110)


end subroutine HCL_memory_allocation


!**********************************************************************
subroutine HCL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! deallocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_deallocation
  implicit none
  integer,   intent(in)    :: dmode

  call hcl_deallocation(G0tensor, 224,dmode)
call hcl_deallocation(G1tensor, 130,dmode)
call hcl_deallocation(G2tensor, 110,dmode)

    call hcl_deallocation(T0sum,105,dmode)


end subroutine HCL_memory_deallocation_/**/REALKIND


!**********************************************************************
subroutine Tsum_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

    call hcl_allocation(1,T0sum,105)


end subroutine Tsum_memory_allocation


#ifdef PRECISION_dp
subroutine max_point(r) &
    & bind(c,name="ol_f_max_point_pplllla_nenenexnexddxa_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 4
end subroutine max_point

subroutine tensor_rank(r) &
    & bind(c,name="ol_f_tensor_rank_pplllla_nenenexnexddxa_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 0
end subroutine tensor_rank
#endif

subroutine reset_tensor_sum()
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  use ol_parameters_init_/**/REALKIND, only: init_hcl
  implicit none
  integer :: i

  do i = 1,105
    call init_hcl(T0sum(i))
  end do

end subroutine reset_tensor_sum


subroutine scale_one_tsum(tsum, spow)
  use ol_parameters_decl_/**/REALKIND, only: scalefactor
  implicit none
  complex(REALKIND), intent(inout) :: tsum(:)
  integer, intent(in) :: spow ! rank 0 scale power
  real(REALKIND) :: sfinv, sfac
  integer :: sz
  sfinv = 1/scalefactor
  sfac = scalefactor**spow
  sz = size(tsum)
  tsum(1) = sfac*tsum(1)
  if (sz > 1) then ! rank 1
    sfac = sfac*sfinv
    tsum(2:5) = sfac*tsum(2:5)
  end if
  if (sz > 5) then ! rank 2
    sfac = sfac*sfinv
    tsum(6:15) = sfac*tsum(6:15)
  end if
  if (sz > 15) then ! rank 3
    sfac = sfac*sfinv
    tsum(16:35) = sfac*tsum(16:35)
  end if
  if (sz > 35) then ! rank 4
    sfac = sfac*sfinv
    tsum(36:70) = sfac*tsum(36:70)
  end if
  if (sz > 70) then ! rank 5
    sfac = sfac*sfinv
    tsum(71:126) = sfac*tsum(71:126)
  end if
  if (sz > 126) then ! rank 6
    sfac = sfac*sfinv
    tsum(127:210) = sfac*tsum(127:210)
  end if
  if (sz > 210) then ! rank 7
    sfac = sfac*sfinv
    tsum(211:330) = sfac*tsum(211:330)
  end if
end subroutine scale_one_tsum


subroutine scale_tensor_sum()
  implicit none
  call scale_one_tsum(T0sum(1)%cmp, -2)
  call scale_one_tsum(T0sum(2)%cmp, -2)
  call scale_one_tsum(T0sum(3)%cmp, -2)
  call scale_one_tsum(T0sum(4)%cmp, -2)
  call scale_one_tsum(T0sum(5)%cmp, -2)
  call scale_one_tsum(T0sum(6)%cmp, -2)
  call scale_one_tsum(T0sum(7)%cmp, -2)
  call scale_one_tsum(T0sum(8)%cmp, -2)
  call scale_one_tsum(T0sum(9)%cmp, -2)
  call scale_one_tsum(T0sum(10)%cmp, -2)
  call scale_one_tsum(T0sum(11)%cmp, -2)
  call scale_one_tsum(T0sum(12)%cmp, -2)
  call scale_one_tsum(T0sum(13)%cmp, -2)
  call scale_one_tsum(T0sum(14)%cmp, -2)
  call scale_one_tsum(T0sum(15)%cmp, -2)
  call scale_one_tsum(T0sum(16)%cmp, -2)
  call scale_one_tsum(T0sum(17)%cmp, -2)
  call scale_one_tsum(T0sum(18)%cmp, -2)
  call scale_one_tsum(T0sum(19)%cmp, -2)
  call scale_one_tsum(T0sum(20)%cmp, -2)
  call scale_one_tsum(T0sum(21)%cmp, -2)
  call scale_one_tsum(T0sum(22)%cmp, -2)
  call scale_one_tsum(T0sum(23)%cmp, -2)
  call scale_one_tsum(T0sum(24)%cmp, -2)
  call scale_one_tsum(T0sum(25)%cmp, -2)
  call scale_one_tsum(T0sum(26)%cmp, -2)
  call scale_one_tsum(T0sum(27)%cmp, -4)
  call scale_one_tsum(T0sum(28)%cmp, -4)
  call scale_one_tsum(T0sum(29)%cmp, -4)
  call scale_one_tsum(T0sum(30)%cmp, -4)
  call scale_one_tsum(T0sum(31)%cmp, -4)
  call scale_one_tsum(T0sum(32)%cmp, -4)
  call scale_one_tsum(T0sum(33)%cmp, -4)
  call scale_one_tsum(T0sum(34)%cmp, -4)
  call scale_one_tsum(T0sum(35)%cmp, -4)
  call scale_one_tsum(T0sum(36)%cmp, -4)
  call scale_one_tsum(T0sum(37)%cmp, -4)
  call scale_one_tsum(T0sum(38)%cmp, -4)
  call scale_one_tsum(T0sum(39)%cmp, -4)
  call scale_one_tsum(T0sum(40)%cmp, -4)
  call scale_one_tsum(T0sum(41)%cmp, -4)
  call scale_one_tsum(T0sum(42)%cmp, -4)
  call scale_one_tsum(T0sum(43)%cmp, -4)
  call scale_one_tsum(T0sum(44)%cmp, -4)
  call scale_one_tsum(T0sum(45)%cmp, -4)
  call scale_one_tsum(T0sum(46)%cmp, -4)
  call scale_one_tsum(T0sum(47)%cmp, -4)
  call scale_one_tsum(T0sum(48)%cmp, -4)
  call scale_one_tsum(T0sum(49)%cmp, -4)
  call scale_one_tsum(T0sum(50)%cmp, -4)
  call scale_one_tsum(T0sum(51)%cmp, -4)
  call scale_one_tsum(T0sum(52)%cmp, -4)
  call scale_one_tsum(T0sum(53)%cmp, -4)
  call scale_one_tsum(T0sum(54)%cmp, -4)
  call scale_one_tsum(T0sum(55)%cmp, -4)
  call scale_one_tsum(T0sum(56)%cmp, -4)
  call scale_one_tsum(T0sum(57)%cmp, -4)
  call scale_one_tsum(T0sum(58)%cmp, -4)
  call scale_one_tsum(T0sum(59)%cmp, -4)
  call scale_one_tsum(T0sum(60)%cmp, -4)
  call scale_one_tsum(T0sum(61)%cmp, -4)
  call scale_one_tsum(T0sum(62)%cmp, -4)
  call scale_one_tsum(T0sum(63)%cmp, -4)
  call scale_one_tsum(T0sum(64)%cmp, -4)
  call scale_one_tsum(T0sum(65)%cmp, -4)
  call scale_one_tsum(T0sum(66)%cmp, -4)
  call scale_one_tsum(T0sum(67)%cmp, -4)
  call scale_one_tsum(T0sum(68)%cmp, -4)
  call scale_one_tsum(T0sum(69)%cmp, -4)
  call scale_one_tsum(T0sum(70)%cmp, -4)
  call scale_one_tsum(T0sum(71)%cmp, -4)
  call scale_one_tsum(T0sum(72)%cmp, -4)
  call scale_one_tsum(T0sum(73)%cmp, -4)
  call scale_one_tsum(T0sum(74)%cmp, -4)
  call scale_one_tsum(T0sum(75)%cmp, -4)
  call scale_one_tsum(T0sum(76)%cmp, -4)
  call scale_one_tsum(T0sum(77)%cmp, -4)
  call scale_one_tsum(T0sum(78)%cmp, -4)
  call scale_one_tsum(T0sum(79)%cmp, -4)
  call scale_one_tsum(T0sum(80)%cmp, -4)
  call scale_one_tsum(T0sum(81)%cmp, -4)
  call scale_one_tsum(T0sum(82)%cmp, -4)
  call scale_one_tsum(T0sum(83)%cmp, -6)
  call scale_one_tsum(T0sum(84)%cmp, -6)
  call scale_one_tsum(T0sum(85)%cmp, -6)
  call scale_one_tsum(T0sum(86)%cmp, -6)
  call scale_one_tsum(T0sum(87)%cmp, -6)
  call scale_one_tsum(T0sum(88)%cmp, -6)
  call scale_one_tsum(T0sum(89)%cmp, -6)
  call scale_one_tsum(T0sum(90)%cmp, -6)
  call scale_one_tsum(T0sum(91)%cmp, -6)
  call scale_one_tsum(T0sum(92)%cmp, -6)
  call scale_one_tsum(T0sum(93)%cmp, -6)
  call scale_one_tsum(T0sum(94)%cmp, -6)
  call scale_one_tsum(T0sum(95)%cmp, -6)
  call scale_one_tsum(T0sum(96)%cmp, -6)
  call scale_one_tsum(T0sum(97)%cmp, -6)
  call scale_one_tsum(T0sum(98)%cmp, -6)
  call scale_one_tsum(T0sum(99)%cmp, -6)
  call scale_one_tsum(T0sum(100)%cmp, -6)
  call scale_one_tsum(T0sum(101)%cmp, -6)
  call scale_one_tsum(T0sum(102)%cmp, -6)
  call scale_one_tsum(T0sum(103)%cmp, -6)
  call scale_one_tsum(T0sum(104)%cmp, -6)
  call scale_one_tsum(T0sum(105)%cmp, -6)

end subroutine scale_tensor_sum

! **********************************************************************
subroutine set_integral_masses_and_momenta()
! **********************************************************************

  use ol_parameters_decl_/**/REALKIND
  momenta_1 = [ 64, 63 ]
  momenta_2 = [ 69, 58 ]
  momenta_3 = [ 70, 57 ]
  momenta_4 = [ 73, 54 ]
  momenta_5 = [ 74, 53 ]
  momenta_6 = [ 79, 48 ]
  momenta_7 = [ 80, 47 ]
  momenta_8 = [ 85, 42 ]
  momenta_9 = [ 86, 41 ]
  momenta_10 = [ 89, 38 ]
  momenta_11 = [ 90, 37 ]
  momenta_12 = [ 95, 32 ]
  momenta_13 = [ 96, 31 ]
  momenta_14 = [ 101, 26 ]
  momenta_15 = [ 102, 25 ]
  momenta_16 = [ 105, 22 ]
  momenta_17 = [ 106, 21 ]
  momenta_18 = [ 111, 16 ]
  momenta_19 = [ 112, 15 ]
  momenta_20 = [ 117, 10 ]
  momenta_21 = [ 118, 9 ]
  momenta_22 = [ 121, 6 ]
  momenta_23 = [ 122, 5 ]
  momenta_24 = [ 64, 5, 58 ]
  momenta_25 = [ 64, 6, 57 ]
  momenta_26 = [ 64, 9, 54 ]
  momenta_27 = [ 64, 10, 53 ]
  momenta_28 = [ 64, 15, 48 ]
  momenta_29 = [ 64, 16, 47 ]
  momenta_30 = [ 64, 21, 42 ]
  momenta_31 = [ 64, 22, 41 ]
  momenta_32 = [ 64, 25, 38 ]
  momenta_33 = [ 64, 26, 37 ]
  momenta_34 = [ 64, 31, 32 ]
  momenta_35 = [ 64, 37, 26 ]
  momenta_36 = [ 64, 38, 25 ]
  momenta_37 = [ 64, 41, 22 ]
  momenta_38 = [ 64, 42, 21 ]
  momenta_39 = [ 64, 47, 16 ]
  momenta_40 = [ 69, 16, 42 ]
  momenta_41 = [ 69, 26, 32 ]
  momenta_42 = [ 69, 32, 26 ]
  momenta_43 = [ 69, 42, 16 ]
  momenta_44 = [ 70, 16, 41 ]
  momenta_45 = [ 70, 25, 32 ]
  momenta_46 = [ 70, 32, 25 ]
  momenta_47 = [ 70, 41, 16 ]
  momenta_48 = [ 73, 16, 38 ]
  momenta_49 = [ 73, 22, 32 ]
  momenta_50 = [ 73, 32, 22 ]
  momenta_51 = [ 73, 38, 16 ]
  momenta_52 = [ 74, 16, 37 ]
  momenta_53 = [ 74, 21, 32 ]
  momenta_54 = [ 74, 32, 21 ]
  momenta_55 = [ 74, 37, 16 ]
  momenta_56 = [ 79, 16, 32 ]
  momenta_57 = [ 79, 32, 16 ]
  momenta_58 = [ 80, 5, 42 ]
  momenta_59 = [ 80, 6, 41 ]
  momenta_60 = [ 80, 9, 38 ]
  momenta_61 = [ 80, 10, 37 ]
  momenta_62 = [ 80, 15, 32 ]
  momenta_63 = [ 85, 10, 32 ]
  momenta_64 = [ 86, 9, 32 ]
  momenta_65 = [ 89, 6, 32 ]
  momenta_66 = [ 90, 5, 32 ]
  momenta_67 = [ 96, 5, 26 ]
  momenta_68 = [ 96, 6, 25 ]
  momenta_69 = [ 96, 9, 22 ]
  momenta_70 = [ 96, 10, 21 ]
  momenta_71 = [ 96, 15, 16 ]
  momenta_72 = [ 101, 10, 16 ]
  momenta_73 = [ 102, 9, 16 ]
  momenta_74 = [ 105, 6, 16 ]
  momenta_75 = [ 106, 5, 16 ]
  momenta_76 = [ 112, 5, 10 ]
  momenta_77 = [ 112, 6, 9 ]
  momenta_78 = [ 112, 9, 6 ]
  momenta_79 = [ 112, 10, 5 ]
  momenta_80 = [ 64, 5, 16, 42 ]
  momenta_81 = [ 64, 5, 26, 32 ]
  momenta_82 = [ 64, 5, 32, 26 ]
  momenta_83 = [ 64, 5, 42, 16 ]
  momenta_84 = [ 64, 6, 16, 41 ]
  momenta_85 = [ 64, 6, 25, 32 ]
  momenta_86 = [ 64, 6, 32, 25 ]
  momenta_87 = [ 64, 6, 41, 16 ]
  momenta_88 = [ 64, 9, 16, 38 ]
  momenta_89 = [ 64, 9, 22, 32 ]
  momenta_90 = [ 64, 9, 32, 22 ]
  momenta_91 = [ 64, 9, 38, 16 ]
  momenta_92 = [ 64, 10, 16, 37 ]
  momenta_93 = [ 64, 10, 21, 32 ]
  momenta_94 = [ 64, 10, 32, 21 ]
  momenta_95 = [ 64, 10, 37, 16 ]
  momenta_96 = [ 64, 15, 16, 32 ]
  momenta_97 = [ 64, 15, 32, 16 ]
  momenta_98 = [ 80, 5, 10, 32 ]
  momenta_99 = [ 80, 6, 9, 32 ]
  momenta_100 = [ 80, 9, 6, 32 ]
  momenta_101 = [ 80, 10, 5, 32 ]
  momenta_102 = [ 96, 5, 10, 16 ]
  momenta_103 = [ 96, 6, 9, 16 ]
  momenta_104 = [ 96, 9, 6, 16 ]
  momenta_105 = [ 96, 10, 5, 16 ]

  masses2_1 = [ 0, 0 ]
  masses2_2 = [ 0, 0, 0 ]
  masses2_3 = [ 0, 0, 0, 0 ]


end subroutine  set_integral_masses_and_momenta

! **********************************************************************
subroutine integrate_tensor_sum(M2out)
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! only: ZERO, masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: a_switch
#endif
  use ol_parameters_init_/**/REALKIND, only: init_met, add_met, met_to_real
  use ol_loop_routines_/**/REALKIND, only: TI_call_OL
  implicit none
  real(REALKIND), intent(out) :: M2out
  type(met) :: M2
  call init_met(M2)



#ifdef LOOPSQUARED
  if (a_switch == 1 .or. a_switch == 7) then
#endif
  call TI_call_OL(0,0, momenta_101, masses2_3, T0sum(1), M2)
  call TI_call_OL(0,0, momenta_98, masses2_3, T0sum(2), M2)
  call TI_call_OL(0,0, momenta_105, masses2_3, T0sum(3), M2)
  call TI_call_OL(0,0, momenta_102, masses2_3, T0sum(4), M2)
  call TI_call_OL(0,0, momenta_99, masses2_3, T0sum(5), M2)
  call TI_call_OL(0,0, momenta_100, masses2_3, T0sum(6), M2)
  call TI_call_OL(0,0, momenta_103, masses2_3, T0sum(7), M2)
  call TI_call_OL(0,0, momenta_104, masses2_3, T0sum(8), M2)
  call TI_call_OL(0,0, momenta_93, masses2_3, T0sum(9), M2)
  call TI_call_OL(0,0, momenta_94, masses2_3, T0sum(10), M2)
  call TI_call_OL(0,0, momenta_95, masses2_3, T0sum(11), M2)
  call TI_call_OL(0,0, momenta_92, masses2_3, T0sum(12), M2)
  call TI_call_OL(0,0, momenta_81, masses2_3, T0sum(13), M2)
  call TI_call_OL(0,0, momenta_82, masses2_3, T0sum(14), M2)
  call TI_call_OL(0,0, momenta_83, masses2_3, T0sum(15), M2)
  call TI_call_OL(0,0, momenta_80, masses2_3, T0sum(16), M2)
  call TI_call_OL(0,0, momenta_97, masses2_3, T0sum(17), M2)
  call TI_call_OL(0,0, momenta_96, masses2_3, T0sum(18), M2)
  call TI_call_OL(0,0, momenta_85, masses2_3, T0sum(19), M2)
  call TI_call_OL(0,0, momenta_86, masses2_3, T0sum(20), M2)
  call TI_call_OL(0,0, momenta_87, masses2_3, T0sum(21), M2)
  call TI_call_OL(0,0, momenta_84, masses2_3, T0sum(22), M2)
  call TI_call_OL(0,0, momenta_89, masses2_3, T0sum(23), M2)
  call TI_call_OL(0,0, momenta_90, masses2_3, T0sum(24), M2)
  call TI_call_OL(0,0, momenta_91, masses2_3, T0sum(25), M2)
  call TI_call_OL(0,0, momenta_88, masses2_3, T0sum(26), M2)
  call TI_call_OL(0,0, momenta_61, masses2_2, T0sum(27), M2)
  call TI_call_OL(0,0, momenta_58, masses2_2, T0sum(28), M2)
  call TI_call_OL(0,0, momenta_70, masses2_2, T0sum(29), M2)
  call TI_call_OL(0,0, momenta_67, masses2_2, T0sum(30), M2)
  call TI_call_OL(0,0, momenta_59, masses2_2, T0sum(31), M2)
  call TI_call_OL(0,0, momenta_60, masses2_2, T0sum(32), M2)
  call TI_call_OL(0,0, momenta_68, masses2_2, T0sum(33), M2)
  call TI_call_OL(0,0, momenta_69, masses2_2, T0sum(34), M2)
  call TI_call_OL(0,0, momenta_27, masses2_2, T0sum(35), M2)
  call TI_call_OL(0,0, momenta_63, masses2_2, T0sum(36), M2)
  call TI_call_OL(0,0, momenta_72, masses2_2, T0sum(37), M2)
  call TI_call_OL(0,0, momenta_24, masses2_2, T0sum(38), M2)
  call TI_call_OL(0,0, momenta_66, masses2_2, T0sum(39), M2)
  call TI_call_OL(0,0, momenta_75, masses2_2, T0sum(40), M2)
  call TI_call_OL(0,0, momenta_62, masses2_2, T0sum(41), M2)
  call TI_call_OL(0,0, momenta_28, masses2_2, T0sum(42), M2)
  call TI_call_OL(0,0, momenta_71, masses2_2, T0sum(43), M2)
  call TI_call_OL(0,0, momenta_25, masses2_2, T0sum(44), M2)
  call TI_call_OL(0,0, momenta_65, masses2_2, T0sum(45), M2)
  call TI_call_OL(0,0, momenta_74, masses2_2, T0sum(46), M2)
  call TI_call_OL(0,0, momenta_26, masses2_2, T0sum(47), M2)
  call TI_call_OL(0,0, momenta_64, masses2_2, T0sum(48), M2)
  call TI_call_OL(0,0, momenta_73, masses2_2, T0sum(49), M2)
  call TI_call_OL(0,0, momenta_79, masses2_2, T0sum(50), M2)
  call TI_call_OL(0,0, momenta_76, masses2_2, T0sum(51), M2)
  call TI_call_OL(0,0, momenta_77, masses2_2, T0sum(52), M2)
  call TI_call_OL(0,0, momenta_78, masses2_2, T0sum(53), M2)
  call TI_call_OL(0,0, momenta_53, masses2_2, T0sum(54), M2)
  call TI_call_OL(0,0, momenta_34, masses2_2, T0sum(55), M2)
  call TI_call_OL(0,0, momenta_54, masses2_2, T0sum(56), M2)
  call TI_call_OL(0,0, momenta_38, masses2_2, T0sum(57), M2)
  call TI_call_OL(0,0, momenta_55, masses2_2, T0sum(58), M2)
  call TI_call_OL(0,0, momenta_39, masses2_2, T0sum(59), M2)
  call TI_call_OL(0,0, momenta_52, masses2_2, T0sum(60), M2)
  call TI_call_OL(0,0, momenta_33, masses2_2, T0sum(61), M2)
  call TI_call_OL(0,0, momenta_41, masses2_2, T0sum(62), M2)
  call TI_call_OL(0,0, momenta_42, masses2_2, T0sum(63), M2)
  call TI_call_OL(0,0, momenta_35, masses2_2, T0sum(64), M2)
  call TI_call_OL(0,0, momenta_43, masses2_2, T0sum(65), M2)
  call TI_call_OL(0,0, momenta_40, masses2_2, T0sum(66), M2)
  call TI_call_OL(0,0, momenta_30, masses2_2, T0sum(67), M2)
  call TI_call_OL(0,0, momenta_57, masses2_2, T0sum(68), M2)
  call TI_call_OL(0,0, momenta_56, masses2_2, T0sum(69), M2)
  call TI_call_OL(0,0, momenta_45, masses2_2, T0sum(70), M2)
  call TI_call_OL(0,0, momenta_46, masses2_2, T0sum(71), M2)
  call TI_call_OL(0,0, momenta_36, masses2_2, T0sum(72), M2)
  call TI_call_OL(0,0, momenta_47, masses2_2, T0sum(73), M2)
  call TI_call_OL(0,0, momenta_44, masses2_2, T0sum(74), M2)
  call TI_call_OL(0,0, momenta_31, masses2_2, T0sum(75), M2)
  call TI_call_OL(0,0, momenta_49, masses2_2, T0sum(76), M2)
  call TI_call_OL(0,0, momenta_50, masses2_2, T0sum(77), M2)
  call TI_call_OL(0,0, momenta_37, masses2_2, T0sum(78), M2)
  call TI_call_OL(0,0, momenta_51, masses2_2, T0sum(79), M2)
  call TI_call_OL(0,0, momenta_48, masses2_2, T0sum(80), M2)
  call TI_call_OL(0,0, momenta_32, masses2_2, T0sum(81), M2)
  call TI_call_OL(0,0, momenta_29, masses2_2, T0sum(82), M2)
  call TI_call_OL(0,0, momenta_20, masses2_1, T0sum(83), M2)
  call TI_call_OL(0,0, momenta_11, masses2_1, T0sum(84), M2)
  call TI_call_OL(0,0, momenta_7, masses2_1, T0sum(85), M2)
  call TI_call_OL(0,0, momenta_23, masses2_1, T0sum(86), M2)
  call TI_call_OL(0,0, momenta_8, masses2_1, T0sum(87), M2)
  call TI_call_OL(0,0, momenta_17, masses2_1, T0sum(88), M2)
  call TI_call_OL(0,0, momenta_13, masses2_1, T0sum(89), M2)
  call TI_call_OL(0,0, momenta_14, masses2_1, T0sum(90), M2)
  call TI_call_OL(0,0, momenta_22, masses2_1, T0sum(91), M2)
  call TI_call_OL(0,0, momenta_9, masses2_1, T0sum(92), M2)
  call TI_call_OL(0,0, momenta_21, masses2_1, T0sum(93), M2)
  call TI_call_OL(0,0, momenta_10, masses2_1, T0sum(94), M2)
  call TI_call_OL(0,0, momenta_15, masses2_1, T0sum(95), M2)
  call TI_call_OL(0,0, momenta_16, masses2_1, T0sum(96), M2)
  call TI_call_OL(0,0, momenta_5, masses2_1, T0sum(97), M2)
  call TI_call_OL(0,0, momenta_1, masses2_1, T0sum(98), M2)
  call TI_call_OL(0,0, momenta_12, masses2_1, T0sum(99), M2)
  call TI_call_OL(0,0, momenta_18, masses2_1, T0sum(100), M2)
  call TI_call_OL(0,0, momenta_2, masses2_1, T0sum(101), M2)
  call TI_call_OL(0,0, momenta_19, masses2_1, T0sum(102), M2)
  call TI_call_OL(0,0, momenta_6, masses2_1, T0sum(103), M2)
  call TI_call_OL(0,0, momenta_3, masses2_1, T0sum(104), M2)
  call TI_call_OL(0,0, momenta_4, masses2_1, T0sum(105), M2)

  call add_met(M2,M2L1R1)

#ifdef LOOPSQUARED
  end if
#endif

  call met_to_real(M2out,M2)

#ifdef PRECISION_dp
  call HOL_memory_deallocation_/**/REALKIND(1)
  call HCL_memory_deallocation_/**/REALKIND(1)
#endif

end subroutine integrate_tensor_sum

end module ol_tensor_sum_storage_pplllla_nenenexnexddxa_1_/**/REALKIND
