
module ol_colourmatrix_pplllla_nenexeexbbxa_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(30,1), K2(30,1), KL(30,1), Cas(7) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [  3]
  K1( 2,:) = [  0]
  K1( 3,:) = [  0]
  K1( 4,:) = [  0]
  K1( 5,:) = [  0]
  K1( 6,:) = [  0]
  K1( 7,:) = [  0]
  K1( 8,:) = [  0]
  K1( 9,:) = [  0]
  K1(10,:) = [  0]
  K1(11,:) = [  0]
  K1(12,:) = [  0]
  K1(13,:) = [  0]
  K1(14,:) = [  0]
  K1(15,:) = [  0]
  K1(16,:) = [  4]
  K1(17,:) = [  0]
  K1(18,:) = [  0]
  K1(19,:) = [  0]
  K1(20,:) = [  0]
  K1(21,:) = [ -4]
  K1(22,:) = [  4]
  K1(23,:) = [  0]
  K1(24,:) = [  0]
  K1(25,:) = [  0]
  K1(26,:) = [  0]
  K1(27,:) = [  0]
  K1(28,:) = [  0]
  K1(29,:) = [  0]
  K1(30,:) = [  0]

  K2( 1,:) = [  3]
  K2( 2,:) = [  0]
  K2( 3,:) = [  0]
  K2( 4,:) = [  0]
  K2( 5,:) = [  0]
  K2( 6,:) = [  0]
  K2( 7,:) = [  0]
  K2( 8,:) = [  0]
  K2( 9,:) = [  0]
  K2(10,:) = [  0]
  K2(11,:) = [  0]
  K2(12,:) = [  0]
  K2(13,:) = [  0]
  K2(14,:) = [  0]
  K2(15,:) = [  0]
  K2(16,:) = [  4]
  K2(17,:) = [  0]
  K2(18,:) = [  0]
  K2(19,:) = [  0]
  K2(20,:) = [  0]
  K2(21,:) = [ -4]
  K2(22,:) = [  4]
  K2(23,:) = [  0]
  K2(24,:) = [  0]
  K2(25,:) = [  0]
  K2(26,:) = [  0]
  K2(27,:) = [  0]
  K2(28,:) = [  0]
  K2(29,:) = [  0]
  K2(30,:) = [  0]

  KL( 1,:) = [  3]
  KL( 2,:) = [  0]
  KL( 3,:) = [  0]
  KL( 4,:) = [  0]
  KL( 5,:) = [  0]
  KL( 6,:) = [  0]
  KL( 7,:) = [  0]
  KL( 8,:) = [  0]
  KL( 9,:) = [  0]
  KL(10,:) = [  0]
  KL(11,:) = [  0]
  KL(12,:) = [  0]
  KL(13,:) = [  0]
  KL(14,:) = [  0]
  KL(15,:) = [  0]
  KL(16,:) = [  4]
  KL(17,:) = [  0]
  KL(18,:) = [  0]
  KL(19,:) = [  0]
  KL(20,:) = [  0]
  KL(21,:) = [ -4]
  KL(22,:) = [  4]
  KL(23,:) = [  0]
  KL(24,:) = [  0]
  KL(25,:) = [  0]
  KL(26,:) = [  0]
  KL(27,:) = [  0]
  KL(28,:) = [  0]
  KL(29,:) = [  0]
  KL(30,:) = [  0]

#if -1 > 0
    co = 0
    do k = 1, 7
      co = co + k
      Cas(k) = K1(1+1*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_pplllla_nenexeexbbxa_1_/**/REALKIND



module ol_forced_parameters_pplllla_nenexeexbbxa_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pplllla_nenexeexbbxa_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_pplllla_nenexeexbbxa_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 128 ! number of helicity configurations
  integer(intkind2), save :: nhel = 128 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: hel_states = 128 ! number of helicity configurations needed for mem-allocation
  integer(intkind2), save :: Hel(128) ! physical helicity states
#endif

  type(Hpolcont), save, allocatable :: A(:,:), M1helarray(:,:), M1helarray_ct(:,:)
  complex(REALKIND), save :: den(613)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2), ex7(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,33), wf8(8,124), wf16(16,210), wf32(32,162), wf128(128,374)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(60), c(15)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save, allocatable :: M0_col1_helarray(:,:), M0M1_hel_cc(:,:,:)
  complex(REALKIND), save :: M2ctcc(29)

end module ol_loop_storage_pplllla_nenexeexbbxa_1_/**/REALKIND






! **********************************************************************
module ol_loop_pplllla_nenexeexbbxa_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_pplllla_nenexeexbbxa_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (CI*eQED**5)/9._/**/REALKIND
    f( 2) = (CI*eQED**5)/3._/**/REALKIND
    f( 3) = CI*eQED**5
    f( 4) = (CI*countertermnorm*eQED**5*gQCD**2)/9._/**/REALKIND
    f( 5) = (CI*countertermnorm*eQED**5*gQCD**2)/3._/**/REALKIND
    f( 6) = CI*countertermnorm*eQED**5*gQCD**2
    f( 7) = (CI*countertermnorm*ctVbb*eQED**5*gQCD**2)/9._/**/REALKIND
    f( 8) = (CI*countertermnorm*ctVbb*eQED**5*gQCD**2)/3._/**/REALKIND
    f( 9) = CI*countertermnorm*ctVbb*eQED**5*gQCD**2
    f(10) = (CI*eQED**5)/(12._/**/REALKIND*sw**4)
    f(11) = (CI*eQED**5)/(6._/**/REALKIND*sw**4)
    f(12) = (CI*eQED**5)/(4._/**/REALKIND*sw**4)
    f(13) = (CI*countertermnorm*eQED**5*gQCD**2)/(12._/**/REALKIND*sw**4)
    f(14) = (CI*countertermnorm*eQED**5*gQCD**2)/(6._/**/REALKIND*sw**4)
    f(15) = (CI*countertermnorm*eQED**5*gQCD**2)/(4._/**/REALKIND*sw**4)
    f(16) = (CI*countertermnorm*ctVbb*eQED**5*gQCD**2)/(12._/**/REALKIND*sw**4)
    f(17) = (CI*countertermnorm*ctVbt*eQED**5*gQCD**2)/(12._/**/REALKIND*sw**4)
    f(18) = (CI*countertermnorm*ctVbt*eQED**5*gQCD**2)/(6._/**/REALKIND*sw**4)
    f(19) = (CI*countertermnorm*ctVbt*eQED**5*gQCD**2)/(4._/**/REALKIND*sw**4)
    f(20) = (CI*countertermnorm*ctVtt*eQED**5*gQCD**2)/(6._/**/REALKIND*sw**4)
    f(21) = (CI*eQED**5*MB)/(12._/**/REALKIND*sw**4)
    f(22) = (CI*eQED**5*MB)/(4._/**/REALKIND*sw**4)
    f(23) = (CI*countertermnorm*eQED**5*gQCD**2*MB)/(12._/**/REALKIND*sw**4)
    f(24) = (CI*countertermnorm*ctSbb*eQED**5*gQCD**2*MB)/(12._/**/REALKIND*sw**4)
    f(25) = (CI*countertermnorm*ctSbb*eQED**5*gQCD**2*MB)/(4._/**/REALKIND*sw**4)
    f(26) = (CI*countertermnorm*ctVbb*eQED**5*gQCD**2*MB)/(12._/**/REALKIND*sw**4)
    f(27) = (CI*cw*eQED**5)/(6._/**/REALKIND*sw**3)
    f(28) = (CI*cw*eQED**5)/(2._/**/REALKIND*sw**3)
    f(29) = (CI*countertermnorm*cw*eQED**5*gQCD**2)/(6._/**/REALKIND*sw**3)
    f(30) = (CI*countertermnorm*ctVbb*cw*eQED**5*gQCD**2)/(6._/**/REALKIND*sw**3)
    f(31) = (CI*countertermnorm*ctVbb*cw*eQED**5*gQCD**2)/(2._/**/REALKIND*sw**3)
    f(32) = (CI*eQED**5)/(18._/**/REALKIND*sw**2)
    f(33) = (CI*eQED**5)/(6._/**/REALKIND*sw**2)
    f(34) = (CI*eQED**5)/(2._/**/REALKIND*sw**2)
    f(35) = (CI*countertermnorm*eQED**5*gQCD**2)/(18._/**/REALKIND*sw**2)
    f(36) = (CI*countertermnorm*eQED**5*gQCD**2)/(6._/**/REALKIND*sw**2)
    f(37) = (CI*countertermnorm*ctVbb*eQED**5*gQCD**2)/(18._/**/REALKIND*sw**2)
    f(38) = (CI*countertermnorm*ctVbb*eQED**5*gQCD**2)/(6._/**/REALKIND*sw**2)
    f(39) = (CI*countertermnorm*ctVbb*eQED**5*gQCD**2)/(2._/**/REALKIND*sw**2)
    f(40) = (CI*eQED**5*MB)/(6._/**/REALKIND*cw**2*sw**2)
    f(41) = (CI*eQED**5*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f(42) = (CI*countertermnorm*eQED**5*gQCD**2*MB)/(6._/**/REALKIND*cw**2*sw**2)
    f(43) = (CI*countertermnorm*ctSbb*eQED**5*gQCD**2*MB)/(6._/**/REALKIND*cw**2*sw**2)
    f(44) = (CI*countertermnorm*ctSbb*eQED**5*gQCD**2*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f(45) = (CI*countertermnorm*ctVbb*eQED**5*gQCD**2*MB)/(6._/**/REALKIND*cw**2*sw**2)
    f(46) = (eQED**5*gQCD**2*integralnorm*SwB)/9._/**/REALKIND
    f(47) = (eQED**5*gQCD**2*integralnorm*SwB)/3._/**/REALKIND
    f(48) = eQED**5*gQCD**2*integralnorm*SwB
    f(49) = (eQED**5*gQCD**2*integralnorm*SwB)/(sw**4*12._/**/REALKIND)
    f(50) = (eQED**5*gQCD**2*integralnorm*SwB)/(sw**4*6._/**/REALKIND)
    f(51) = (eQED**5*gQCD**2*integralnorm*SwB)/(sw**4*4._/**/REALKIND)
    f(52) = (eQED**5*gQCD**2*integralnorm*MB*SwB)/(sw**4*12._/**/REALKIND)
    f(53) = (eQED**5*gQCD**2*integralnorm*MB*SwB)/(sw**4*4._/**/REALKIND)
    f(54) = (cw*eQED**5*gQCD**2*integralnorm*SwB)/(sw**3*6._/**/REALKIND)
    f(55) = (cw*eQED**5*gQCD**2*integralnorm*SwB)/(sw**3*2._/**/REALKIND)
    f(56) = (eQED**5*gQCD**2*integralnorm*SwB)/(sw**2*18._/**/REALKIND)
    f(57) = (eQED**5*gQCD**2*integralnorm*SwB)/(sw**2*6._/**/REALKIND)
    f(58) = (eQED**5*gQCD**2*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(59) = (eQED**5*gQCD**2*integralnorm*MB*SwB)/(cw**2*sw**2*6._/**/REALKIND)
    f(60) = (eQED**5*gQCD**2*integralnorm*MB*SwB)/(cw**2*sw**2*2._/**/REALKIND)

  c = [ 4*f(46), 4*f(47), 4*f(48), 4*f(49), 4*f(50), 4*f(51), 4*f(52), 4*f(53), 4*f(54), 4*f(55), 4*f(56), 4*f(57), 4*f(58) &
    , 4*f(59), 4*f(60) ]
  c = (1._/**/REALKIND / 3) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,9) - MW2)+L(6,9))
  den(2) = 1 /((L(5,6) - MW2)+L(6,6))
  den(3) = 1 /((L(5,48))+L(6,48))
  den(6) = 1 /((L(5,48) - MZ2)+L(6,48))
  den(8) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(9) = 1 /((L(5,12))+L(6,12))
  den(10) = 1 /((L(5,80) - MB2)+L(6,80))
  den(12) = 1 /((L(5,35) - MB2)+L(6,35))
  den(15) = 1 /((L(5,12) - MZ2)+L(6,12))
  den(19) = 1 /((L(5,44) - MB2)+L(6,44))
  den(25) = 1 /((L(5,112) - MH2)+L(6,112))
  den(28) = 1 /((L(5,96) - MB2)+L(6,96))
  den(30) = 1 /((L(5,19) - MB2)+L(6,19))
  den(36) = 1 /((L(5,28) - MB2)+L(6,28))
  den(47) = 1 /((L(5,68))+L(6,68))
  den(49) = 1 /((L(5,11))+L(6,11))
  den(54) = 1 /((L(5,48) - MH2)+L(6,48))
  den(56) = 1 /((L(5,76) - MZ2)+L(6,76))
  den(60) = 1 /((L(5,56))+L(6,56))
  den(65) = 1 /((L(5,72))+L(6,72))
  den(67) = 1 /((L(5,7))+L(6,7))
  den(75) = 1 /((L(5,52))+L(6,52))
  den(84) = 1 /((L(5,76))+L(6,76))
  den(95) = 1 /((L(5,112))+L(6,112))
  den(98) = 1 /((L(5,112) - MZ2)+L(6,112))
  den(110) = 1 /((L(5,73) - MW2)+L(6,73))
  den(118) = 1 /((L(5,70) - MW2)+L(6,70))
  den(126) = 1 /((L(5,38) - MT2)+L(6,38))
  den(133) = 1 /((L(5,25) - MT2)+L(6,25))
  den(150) = 1 /((L(5,49))+L(6,49))
  den(161) = 1 /((L(5,14))+L(6,14))
  den(175) = 1 /((L(5,50))+L(6,50))
  den(186) = 1 /((L(5,13))+L(6,13))
  den(208) = 1 /((L(5,15) - MH2)+L(6,15))
  den(211) = 1 /((L(5,83) - MB2)+L(6,83))
  den(215) = 1 /((L(5,92) - MB2)+L(6,92))
  den(221) = 1 /((L(5,99) - MB2)+L(6,99))
  den(225) = 1 /((L(5,108) - MB2)+L(6,108))
  den(232) = 1 /((L(5,15))+L(6,15))
  den(235) = 1 /((L(5,15) - MZ2)+L(6,15))
  den(238) = 1 /((L(5,89) - MT2)+L(6,89))
  den(244) = 1 /((L(5,102) - MT2)+L(6,102))
  den(363) = 1 /((L(5,79))+L(6,79))
  den(365) = 1 /((L(5,79) - MZ2)+L(6,79))
  den(368) = 1 /((L(5,31) - MB2)+L(6,31))
  den(373) = 1 /((L(5,47) - MB2)+L(6,47))
  den(391) = 1 /((L(5,79) - MH2)+L(6,79))
  den(393) = 1 /((L(5,71))+L(6,71))
  den(402) = 1 /((L(5,75))+L(6,75))
  den(445) = 1 /((L(5,78))+L(6,78))
  den(469) = 1 /((L(5,77))+L(6,77))

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(7) = den(4)*den(6)
  den(11) = den(9)*den(10)
  den(13) = den(8)*den(12)
  den(14) = den(11)*den(13)
  den(16) = den(10)*den(15)
  den(17) = den(13)*den(16)
  den(18) = den(8)*den(10)
  den(20) = den(9)*den(19)
  den(21) = den(18)*den(20)
  den(22) = den(15)*den(19)
  den(23) = den(18)*den(22)
  den(24) = den(8)*den(15)
  den(26) = den(10)*den(25)
  den(27) = den(24)*den(26)
  den(29) = den(9)*den(28)
  den(31) = den(8)*den(30)
  den(32) = den(29)*den(31)
  den(33) = den(15)*den(28)
  den(34) = den(31)*den(33)
  den(35) = den(8)*den(28)
  den(37) = den(9)*den(36)
  den(38) = den(35)*den(37)
  den(39) = den(15)*den(36)
  den(40) = den(35)*den(39)
  den(41) = den(25)*den(28)
  den(42) = den(24)*den(41)
  den(43) = den(20)*den(31)
  den(44) = den(22)*den(31)
  den(45) = den(13)*den(37)
  den(46) = den(13)*den(39)
  den(48) = den(3)*den(47)
  den(50) = den(8)*den(49)
  den(51) = den(48)*den(50)
  den(52) = den(6)*den(47)
  den(53) = den(50)*den(52)
  den(55) = den(8)*den(54)
  den(57) = den(47)*den(56)
  den(58) = den(55)*den(57)
  den(59) = den(8)*den(47)
  den(61) = den(3)*den(60)
  den(62) = den(59)*den(61)
  den(63) = den(6)*den(60)
  den(64) = den(59)*den(63)
  den(66) = den(3)*den(65)
  den(68) = den(8)*den(67)
  den(69) = den(66)*den(68)
  den(70) = den(6)*den(65)
  den(71) = den(68)*den(70)
  den(72) = den(56)*den(65)
  den(73) = den(55)*den(72)
  den(74) = den(8)*den(65)
  den(76) = den(3)*den(75)
  den(77) = den(74)*den(76)
  den(78) = den(6)*den(75)
  den(79) = den(74)*den(78)
  den(80) = den(61)*den(68)
  den(81) = den(63)*den(68)
  den(82) = den(50)*den(76)
  den(83) = den(50)*den(78)
  den(85) = den(47)*den(84)
  den(86) = den(31)*den(85)
  den(87) = den(31)*den(57)
  den(88) = den(13)*den(85)
  den(89) = den(13)*den(57)
  den(90) = den(65)*den(84)
  den(91) = den(31)*den(90)
  den(92) = den(31)*den(72)
  den(93) = den(13)*den(90)
  den(94) = den(13)*den(72)
  den(96) = den(10)*den(95)
  den(97) = den(68)*den(96)
  den(99) = den(10)*den(98)
  den(100) = den(68)*den(99)
  den(101) = den(50)*den(96)
  den(102) = den(50)*den(99)
  den(103) = den(28)*den(95)
  den(104) = den(68)*den(103)
  den(105) = den(28)*den(98)
  den(106) = den(68)*den(105)
  den(107) = den(50)*den(103)
  den(108) = den(50)*den(105)
  den(109) = den(2)*den(54)
  den(111) = den(1)*den(110)
  den(112) = den(109)*den(111)
  den(113) = den(2)*den(3)
  den(114) = den(111)*den(113)
  den(115) = den(2)*den(6)
  den(116) = den(111)*den(115)
  den(117) = den(1)*den(54)
  den(119) = den(2)*den(118)
  den(120) = den(117)*den(119)
  den(121) = den(1)*den(3)
  den(122) = den(119)*den(121)
  den(123) = den(1)*den(6)
  den(124) = den(119)*den(123)
  den(125) = den(1)*den(10)
  den(127) = den(2)*den(126)
  den(128) = den(125)*den(127)
  den(129) = den(4)*den(26)
  den(130) = den(4)*den(96)
  den(131) = den(4)*den(99)
  den(132) = den(2)*den(28)
  den(134) = den(1)*den(133)
  den(135) = den(132)*den(134)
  den(136) = den(4)*den(41)
  den(137) = den(4)*den(103)
  den(138) = den(4)*den(105)
  den(139) = den(127)*den(134)
  den(140) = den(119)*den(134)
  den(141) = den(111)*den(127)
  den(142) = den(2)*den(67)
  den(143) = den(66)*den(142)
  den(144) = den(70)*den(142)
  den(145) = den(65)*den(110)
  den(146) = den(109)*den(145)
  den(147) = den(113)*den(145)
  den(148) = den(115)*den(145)
  den(149) = den(2)*den(65)
  den(151) = den(6)*den(150)
  den(152) = den(149)*den(151)
  den(153) = den(61)*den(142)
  den(154) = den(63)*den(142)
  den(155) = den(119)*den(151)
  den(156) = den(61)*den(119)
  den(157) = den(63)*den(119)
  den(158) = den(127)*den(145)
  den(159) = den(96)*den(142)
  den(160) = den(99)*den(142)
  den(162) = den(2)*den(161)
  den(163) = den(99)*den(162)
  den(164) = den(103)*den(142)
  den(165) = den(105)*den(142)
  den(166) = den(105)*den(162)
  den(167) = den(1)*den(49)
  den(168) = den(48)*den(167)
  den(169) = den(52)*den(167)
  den(170) = den(47)*den(118)
  den(171) = den(117)*den(170)
  den(172) = den(121)*den(170)
  den(173) = den(123)*den(170)
  den(174) = den(1)*den(47)
  den(176) = den(6)*den(175)
  den(177) = den(174)*den(176)
  den(178) = den(76)*den(167)
  den(179) = den(78)*den(167)
  den(180) = den(111)*den(176)
  den(181) = den(76)*den(111)
  den(182) = den(78)*den(111)
  den(183) = den(134)*den(170)
  den(184) = den(96)*den(167)
  den(185) = den(99)*den(167)
  den(187) = den(1)*den(186)
  den(188) = den(99)*den(187)
  den(189) = den(103)*den(167)
  den(190) = den(105)*den(167)
  den(191) = den(105)*den(187)
  den(192) = den(15)*den(186)
  den(193) = den(99)*den(192)
  den(194) = den(15)*den(161)
  den(195) = den(99)*den(194)
  den(196) = den(105)*den(192)
  den(197) = den(105)*den(194)
  den(198) = den(61)*den(170)
  den(199) = den(63)*den(170)
  den(200) = den(57)*den(176)
  den(201) = den(57)*den(151)
  den(202) = den(151)*den(170)
  den(203) = den(72)*den(176)
  den(204) = den(76)*den(145)
  den(205) = den(78)*den(145)
  den(206) = den(72)*den(151)
  den(207) = den(145)*den(176)
  den(209) = den(24)*den(208)
  den(210) = den(10)*den(209)
  den(212) = den(18)*den(211)
  den(213) = den(9)*den(212)
  den(214) = den(15)*den(212)
  den(216) = den(11)*den(215)
  den(217) = den(8)*den(216)
  den(218) = den(16)*den(215)
  den(219) = den(8)*den(218)
  den(220) = den(28)*den(209)
  den(222) = den(35)*den(221)
  den(223) = den(9)*den(222)
  den(224) = den(15)*den(222)
  den(226) = den(29)*den(225)
  den(227) = den(8)*den(226)
  den(228) = den(33)*den(225)
  den(229) = den(8)*den(228)
  den(230) = den(4)*den(208)
  den(231) = den(10)*den(230)
  den(233) = den(4)*den(232)
  den(234) = den(10)*den(233)
  den(236) = den(4)*den(235)
  den(237) = den(10)*den(236)
  den(239) = den(125)*den(238)
  den(240) = den(2)*den(239)
  den(241) = den(28)*den(230)
  den(242) = den(28)*den(233)
  den(243) = den(28)*den(236)
  den(245) = den(132)*den(244)
  den(246) = den(1)*den(245)
  den(247) = den(10)**2
  den(248) = den(209)*den(247)
  den(249) = den(9)*den(247)
  den(250) = den(13)*den(249)
  den(251) = den(15)*den(247)
  den(252) = den(13)*den(251)
  den(253) = den(8)*den(247)
  den(254) = den(20)*den(253)
  den(255) = den(22)*den(253)
  den(256) = den(13)*den(216)
  den(257) = den(13)*den(218)
  den(258) = den(20)*den(212)
  den(259) = den(22)*den(212)
  den(260) = den(28)**2
  den(261) = den(209)*den(260)
  den(262) = den(31)*den(226)
  den(263) = den(31)*den(228)
  den(264) = den(37)*den(222)
  den(265) = den(39)*den(222)
  den(266) = den(9)*den(260)
  den(267) = den(31)*den(266)
  den(268) = den(15)*den(260)
  den(269) = den(31)*den(268)
  den(270) = den(8)*den(260)
  den(271) = den(37)*den(270)
  den(272) = den(39)*den(270)
  den(273) = den(20)*den(225)
  den(274) = den(31)*den(273)
  den(275) = den(22)*den(225)
  den(276) = den(31)*den(275)
  den(277) = den(13)*den(221)
  den(278) = den(37)*den(277)
  den(279) = den(39)*den(277)
  den(280) = den(31)*den(211)
  den(281) = den(20)*den(280)
  den(282) = den(22)*den(280)
  den(283) = den(37)*den(215)
  den(284) = den(13)*den(283)
  den(285) = den(39)*den(215)
  den(286) = den(13)*den(285)
  den(287) = den(85)*den(225)
  den(288) = den(31)*den(287)
  den(289) = den(57)*den(225)
  den(290) = den(31)*den(289)
  den(291) = den(85)*den(215)
  den(292) = den(13)*den(291)
  den(293) = den(57)*den(215)
  den(294) = den(13)*den(293)
  den(295) = den(90)*den(225)
  den(296) = den(31)*den(295)
  den(297) = den(72)*den(225)
  den(298) = den(31)*den(297)
  den(299) = den(90)*den(215)
  den(300) = den(13)*den(299)
  den(301) = den(72)*den(215)
  den(302) = den(13)*den(301)
  den(303) = den(68)*den(232)
  den(304) = den(247)*den(303)
  den(305) = den(68)*den(235)
  den(306) = den(247)*den(305)
  den(307) = den(50)*den(232)
  den(308) = den(247)*den(307)
  den(309) = den(50)*den(235)
  den(310) = den(247)*den(309)
  den(311) = den(260)*den(303)
  den(312) = den(260)*den(305)
  den(313) = den(260)*den(307)
  den(314) = den(260)*den(309)
  den(315) = den(230)*den(247)
  den(316) = den(233)*den(247)
  den(317) = den(236)*den(247)
  den(318) = den(1)*den(247)
  den(319) = den(127)*den(318)
  den(320) = den(127)*den(239)
  den(321) = den(230)*den(260)
  den(322) = den(233)*den(260)
  den(323) = den(236)*den(260)
  den(324) = den(134)*den(245)
  den(325) = den(2)*den(260)
  den(326) = den(134)*den(325)
  den(327) = den(119)*den(244)
  den(328) = den(134)*den(327)
  den(329) = den(111)*den(238)
  den(330) = den(127)*den(329)
  den(331) = den(127)*den(244)
  den(332) = den(134)*den(331)
  den(333) = den(134)*den(238)
  den(334) = den(127)*den(333)
  den(335) = den(145)*den(238)
  den(336) = den(127)*den(335)
  den(337) = den(142)*den(232)
  den(338) = den(247)*den(337)
  den(339) = den(142)*den(235)
  den(340) = den(247)*den(339)
  den(341) = den(162)*den(235)
  den(342) = den(247)*den(341)
  den(343) = den(260)*den(337)
  den(344) = den(260)*den(339)
  den(345) = den(260)*den(341)
  den(346) = den(170)*den(244)
  den(347) = den(134)*den(346)
  den(348) = den(167)*den(232)
  den(349) = den(247)*den(348)
  den(350) = den(167)*den(235)
  den(351) = den(247)*den(350)
  den(352) = den(187)*den(235)
  den(353) = den(247)*den(352)
  den(354) = den(260)*den(348)
  den(355) = den(260)*den(350)
  den(356) = den(260)*den(352)
  den(357) = den(192)*den(235)
  den(358) = den(247)*den(357)
  den(359) = den(194)*den(235)
  den(360) = den(247)*den(359)
  den(361) = den(260)*den(357)
  den(362) = den(260)*den(359)
  den(364) = den(4)*den(363)
  den(366) = den(4)*den(365)
  den(367) = den(9)*den(31)
  den(369) = den(367)*den(368)
  den(370) = den(15)*den(31)
  den(371) = den(368)*den(370)
  den(372) = den(9)*den(13)
  den(374) = den(372)*den(373)
  den(375) = den(13)*den(15)
  den(376) = den(373)*den(375)
  den(377) = den(8)*den(37)
  den(378) = den(368)*den(377)
  den(379) = den(8)*den(39)
  den(380) = den(368)*den(379)
  den(381) = den(8)*den(20)
  den(382) = den(373)*den(381)
  den(383) = den(8)*den(22)
  den(384) = den(373)*den(383)
  den(385) = den(209)*den(368)
  den(386) = den(209)*den(373)
  den(387) = den(47)*den(50)
  den(388) = den(363)*den(387)
  den(389) = den(365)*den(387)
  den(390) = den(8)*den(57)
  den(392) = den(390)*den(391)
  den(394) = den(59)*den(393)
  den(395) = den(363)*den(394)
  den(396) = den(365)*den(394)
  den(397) = den(65)*den(68)
  den(398) = den(363)*den(397)
  den(399) = den(365)*den(397)
  den(400) = den(8)*den(72)
  den(401) = den(391)*den(400)
  den(403) = den(74)*den(402)
  den(404) = den(363)*den(403)
  den(405) = den(365)*den(403)
  den(406) = den(303)*den(368)
  den(407) = den(305)*den(368)
  den(408) = den(303)*den(373)
  den(409) = den(305)*den(373)
  den(410) = den(68)*den(393)
  den(411) = den(363)*den(410)
  den(412) = den(365)*den(410)
  den(413) = den(307)*den(368)
  den(414) = den(309)*den(368)
  den(415) = den(307)*den(373)
  den(416) = den(309)*den(373)
  den(417) = den(50)*den(402)
  den(418) = den(363)*den(417)
  den(419) = den(365)*den(417)
  den(420) = den(2)*den(134)
  den(421) = den(368)*den(420)
  den(422) = den(2)*den(111)
  den(423) = den(391)*den(422)
  den(424) = den(363)*den(422)
  den(425) = den(365)*den(422)
  den(426) = den(1)*den(127)
  den(427) = den(373)*den(426)
  den(428) = den(1)*den(119)
  den(429) = den(391)*den(428)
  den(430) = den(363)*den(428)
  den(431) = den(365)*den(428)
  den(432) = den(230)*den(368)
  den(433) = den(233)*den(368)
  den(434) = den(236)*den(368)
  den(435) = den(230)*den(373)
  den(436) = den(233)*den(373)
  den(437) = den(236)*den(373)
  den(438) = den(65)*den(142)
  den(439) = den(363)*den(438)
  den(440) = den(365)*den(438)
  den(441) = den(2)*den(145)
  den(442) = den(391)*den(441)
  den(443) = den(363)*den(441)
  den(444) = den(365)*den(441)
  den(446) = den(149)*den(445)
  den(447) = den(365)*den(446)
  den(448) = den(337)*den(368)
  den(449) = den(339)*den(368)
  den(450) = den(337)*den(373)
  den(451) = den(339)*den(373)
  den(452) = den(142)*den(393)
  den(453) = den(363)*den(452)
  den(454) = den(365)*den(452)
  den(455) = den(341)*den(368)
  den(456) = den(341)*den(373)
  den(457) = den(119)*den(393)
  den(458) = den(363)*den(457)
  den(459) = den(365)*den(457)
  den(460) = den(119)*den(445)
  den(461) = den(365)*den(460)
  den(462) = den(47)*den(167)
  den(463) = den(363)*den(462)
  den(464) = den(365)*den(462)
  den(465) = den(1)*den(170)
  den(466) = den(391)*den(465)
  den(467) = den(363)*den(465)
  den(468) = den(365)*den(465)
  den(470) = den(174)*den(469)
  den(471) = den(365)*den(470)
  den(472) = den(348)*den(368)
  den(473) = den(350)*den(368)
  den(474) = den(348)*den(373)
  den(475) = den(350)*den(373)
  den(476) = den(167)*den(402)
  den(477) = den(363)*den(476)
  den(478) = den(365)*den(476)
  den(479) = den(352)*den(368)
  den(480) = den(352)*den(373)
  den(481) = den(111)*den(402)
  den(482) = den(363)*den(481)
  den(483) = den(365)*den(481)
  den(484) = den(111)*den(469)
  den(485) = den(365)*den(484)
  den(486) = den(357)*den(368)
  den(487) = den(357)*den(373)
  den(488) = den(359)*den(368)
  den(489) = den(359)*den(373)
  den(490) = den(170)*den(393)
  den(491) = den(363)*den(490)
  den(492) = den(365)*den(490)
  den(493) = den(57)*den(469)
  den(494) = den(365)*den(493)
  den(495) = den(57)*den(445)
  den(496) = den(365)*den(495)
  den(497) = den(170)*den(445)
  den(498) = den(365)*den(497)
  den(499) = den(72)*den(469)
  den(500) = den(365)*den(499)
  den(501) = den(145)*den(402)
  den(502) = den(363)*den(501)
  den(503) = den(365)*den(501)
  den(504) = den(72)*den(445)
  den(505) = den(365)*den(504)
  den(506) = den(145)*den(469)
  den(507) = den(365)*den(506)
  den(508) = den(9)*den(10)*den(13)
  den(509) = den(10)*den(13)*den(15)
  den(510) = den(8)*den(10)*den(20)
  den(511) = den(8)*den(10)*den(22)
  den(512) = den(8)*den(9)*den(10)
  den(513) = den(8)*den(10)*den(15)
  den(514) = den(9)*den(28)*den(31)
  den(515) = den(15)*den(28)*den(31)
  den(516) = den(8)*den(28)*den(37)
  den(517) = den(8)*den(28)*den(39)
  den(518) = den(8)*den(9)*den(28)
  den(519) = den(8)*den(15)*den(28)
  den(520) = den(9)*den(280)
  den(521) = den(15)*den(280)
  den(522) = den(9)*den(277)
  den(523) = den(15)*den(277)
  den(524) = den(8)*den(283)
  den(525) = den(8)*den(285)
  den(526) = den(8)*den(273)
  den(527) = den(8)*den(275)
  den(528) = den(8)*den(291)
  den(529) = den(8)*den(293)
  den(530) = den(8)*den(287)
  den(531) = den(8)*den(289)
  den(532) = den(8)*den(85)
  den(533) = den(8)*den(299)
  den(534) = den(8)*den(301)
  den(535) = den(8)*den(295)
  den(536) = den(8)*den(297)
  den(537) = den(8)*den(90)
  den(538) = den(10)*den(303)
  den(539) = den(10)*den(305)
  den(540) = den(10)*den(307)
  den(541) = den(10)*den(309)
  den(542) = den(28)*den(303)
  den(543) = den(28)*den(305)
  den(544) = den(28)*den(307)
  den(545) = den(28)*den(309)
  den(546) = den(1)*den(10)*den(127)
  den(547) = den(1)*den(2)*den(10)
  den(548) = den(2)*den(28)*den(134)
  den(549) = den(1)*den(2)*den(28)
  den(550) = den(2)*den(333)
  den(551) = den(2)*den(329)
  den(552) = den(1)*den(331)
  den(553) = den(1)*den(327)
  den(554) = den(2)*den(335)
  den(555) = den(10)*den(337)
  den(556) = den(10)*den(339)
  den(557) = den(10)*den(341)
  den(558) = den(28)*den(337)
  den(559) = den(28)*den(339)
  den(560) = den(28)*den(341)
  den(561) = den(1)*den(346)
  den(562) = den(10)*den(348)
  den(563) = den(10)*den(350)
  den(564) = den(10)*den(352)
  den(565) = den(28)*den(348)
  den(566) = den(28)*den(350)
  den(567) = den(28)*den(352)
  den(568) = den(10)*den(357)
  den(569) = den(10)*den(359)
  den(570) = den(28)*den(357)
  den(571) = den(28)*den(359)
  den(572) = den(10)*den(374)
  den(573) = den(10)*den(376)
  den(574) = den(10)*den(382)
  den(575) = den(10)*den(384)
  den(576) = den(10)*den(386)
  den(577) = den(28)*den(369)
  den(578) = den(28)*den(371)
  den(579) = den(28)*den(378)
  den(580) = den(28)*den(380)
  den(581) = den(28)*den(385)
  den(582) = den(10)*den(408)
  den(583) = den(10)*den(409)
  den(584) = den(10)*den(415)
  den(585) = den(10)*den(416)
  den(586) = den(28)*den(406)
  den(587) = den(28)*den(407)
  den(588) = den(28)*den(413)
  den(589) = den(28)*den(414)
  den(590) = den(10)*den(427)
  den(591) = den(10)*den(435)
  den(592) = den(10)*den(436)
  den(593) = den(10)*den(437)
  den(594) = den(28)*den(421)
  den(595) = den(28)*den(432)
  den(596) = den(28)*den(433)
  den(597) = den(28)*den(434)
  den(598) = den(10)*den(450)
  den(599) = den(10)*den(451)
  den(600) = den(10)*den(456)
  den(601) = den(28)*den(448)
  den(602) = den(28)*den(449)
  den(603) = den(28)*den(455)
  den(604) = den(10)*den(474)
  den(605) = den(10)*den(475)
  den(606) = den(10)*den(480)
  den(607) = den(28)*den(472)
  den(608) = den(28)*den(473)
  den(609) = den(28)*den(479)
  den(610) = den(10)*den(487)
  den(611) = den(10)*den(489)
  den(612) = den(28)*den(486)
  den(613) = den(28)*den(488)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif

! **********************************************************************
subroutine allocate_diagrams()
!-----------------------------------------------------------------------
! After the first Born evaluation, colour-stripped amplitudes and
! colour vectors are initialiased with the minimum number of relevant
! helicity states.
! **********************************************************************
#ifndef PRECISION_dp
  use ol_loop_storage_pplllla_nenexeexbbxa_1_/**/DREALKIND, only: hel_states
#endif
  implicit none

  if (allocated(A)) deallocate(A)
  if (allocated(M1helarray)) deallocate(M1helarray)
  if (allocated(M1helarray_ct)) deallocate(M1helarray_ct)
  if (allocated(M0_col1_helarray)) deallocate(M0_col1_helarray)
  allocate(A(hel_states,374))
  allocate(M1helarray(1,hel_states))
  allocate(M1helarray_ct(1,hel_states))
  allocate(M0_col1_helarray(1,hel_states))
#if -1 > 0
  if (allocated(M0M1_hel_cc)) deallocate(M0M1_hel_cc)
  allocate(M0M1_hel_cc(1,hel_states,29))
#endif
end subroutine allocate_diagrams

!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_pplllla_nenexeexbbxa_1_/**/DREALKIND, only: &
  nhel, Hel, hel_states
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for nu_e anti-nu_e e- e+ bottom anti-bottom gamma -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init, ensure_mp_loop_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_settings_pplllla_nenexeexbbxa_1, only: hel_mem_opt, loopcc
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_pplllla_nenexeexbbxa_1, only: &
    & external_perm_pplllla_nenexeexbbxa_1, &
    & external_perm_inv_pplllla_nenexeexbbxa_1, &
    & extcomb_perm_pplllla_nenexeexbbxa_1, &
    & average_factor_pplllla_nenexeexbbxa_1
  use ol_external_pplllla_nenexeexbbxa_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_pplllla_nenexeexbbxa_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_pplllla_nenexeexbbxa_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_pplllla_nenexeexbbxa_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,7)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(29)
  logical, intent(in) :: qp_kinematics
  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,7)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,7)
#endif
  integer           :: extmasses2(7)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(29)
  complex(REALKIND) :: M1(1), M2(1)
  real(REALKIND)    :: P_scatt_intern(0:3,7)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(29), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak

#if 7 > 3
  integer :: ind_cc_comb(14)
#endif

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(374)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,374))
  end if

  call set_parameter("ew_renorm", 0)
  call parameters_flush()
  call ensure_mp_init()
  call ensure_mp_loop_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    call check_forced_parameters()
  end if
  call fac_init_loop()

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, 0, 0, nMB, nMB, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_pplllla_nenexeexbbxa_1, 7, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_Q(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rZERO, H4, ex4, POLSEL(4),4)
  call pol_wf_Q(P(:,5), rMB, H5, ex5, POLSEL(5),5)
  call pol_wf_A(P(:,6), rMB, H6, ex6, POLSEL(6),6)
  call pol_wf_V(P(:,7), rZERO, H7, ex7, POLSEL(7),7)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_W(ntry, ex1(:), ex4(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_QA_W(ntry, ex3(:), ex2(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_QA_V(ntry, ex5(:), ex6(:), wf4(:,3), n3(:,3), t3x4(:,:,3))
  call prop_W_W(ntry, wf4(:,1), 9, MW, 1_intkind1, wf4(:,4), n2(1))
  call prop_W_W(ntry, wf4(:,2), 6, MW, 1_intkind1, wf4(:,5), n2(2))
  call vert_WWV_V(ntry, wf4(:,5), wf4(:,4), ex7(:), wf32(:,1), n4(:,1), t4x32(:,:,1))
  call vert_QA_Z(gZd,ntry, ex5(:), ex6(:), wf4(:,6), n3(:,4), t3x4(:,:,4))
  call prop_W_W(ntry, wf4(:,6), 48, MZ, 1_intkind1, wf4(:,7), n2(3))
  call vert_QA_Z(gZn,ntry, ex1(:), ex2(:), wf4(:,8), n3(:,5), t3x4(:,:,5))
  call vert_QA_V(ntry, ex3(:), ex4(:), wf4(:,9), n3(:,6), t3x4(:,:,6))
  call vert_VQ_A(ntry, ex7(:), ex5(:), wf4(:,10), n3(:,7), t3x4(:,:,7))
  call prop_W_W(ntry, wf4(:,8), 3, MZ, 1_intkind1, wf4(:,11), n2(4))
  call prop_Q_A(ntry, wf4(:,10), 80, MB, 1_intkind1, wf4(:,12), n2(5))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,11), wf8(:,1), n3(:,8), t3x8(:,:,1))
  call vert_VQ_A(ntry, wf4(:,9), wf4(:,12), wf16(:,1), n3(:,9), t3x16(:,:,1))
  call prop_A_Q(ntry, wf8(:,1), 35, MB, 1_intkind1, wf8(:,2), n2(6))
  call vert_QA_Z(gZl,ntry, ex3(:), ex4(:), wf4(:,13), n3(:,10), t3x4(:,:,8))
  call prop_W_W(ntry, wf4(:,13), 12, MZ, 1_intkind1, wf4(:,14), n2(7))
  call vert_ZQ_A(gZd,ntry, wf4(:,14), wf4(:,12), wf16(:,2), n3(:,11), t3x16(:,:,2))
  call vert_AV_Q(ntry, ex6(:), wf4(:,9), wf8(:,3), n3(:,12), t3x8(:,:,2))
  call vert_ZQ_A(gZd,ntry, wf4(:,11), wf4(:,12), wf16(:,3), n3(:,13), t3x16(:,:,3))
  call prop_A_Q(ntry, wf8(:,3), 44, MB, 1_intkind1, wf8(:,4), n2(8))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,14), wf8(:,5), n3(:,14), t3x8(:,:,3))
  call prop_A_Q(ntry, wf8(:,5), 44, MB, 1_intkind1, wf8(:,6), n2(9))
  call vert_AQ_S(gH,ntry, ex6(:), wf4(:,12), wf8(:,7), n3(:,15), t3x8(:,:,4))
  call vert_VV_S(ntry, wf4(:,11), wf4(:,14), wf16(:,4), n3(:,16), t3x16(:,:,4))
  call vert_AV_Q(ntry, ex6(:), ex7(:), wf4(:,15), n3(:,17), t3x4(:,:,9))
  call prop_A_Q(ntry, wf4(:,15), 96, MB, 1_intkind1, wf4(:,16), n2(10))
  call vert_ZQ_A(gZd,ntry, wf4(:,11), ex5(:), wf8(:,8), n3(:,18), t3x8(:,:,5))
  call vert_AV_Q(ntry, wf4(:,16), wf4(:,9), wf16(:,5), n3(:,19), t3x16(:,:,5))
  call prop_Q_A(ntry, wf8(:,8), 19, MB, 1_intkind1, wf8(:,9), n2(11))
  call vert_AZ_Q(gZd,ntry, wf4(:,16), wf4(:,14), wf16(:,6), n3(:,20), t3x16(:,:,6))
  call vert_VQ_A(ntry, wf4(:,9), ex5(:), wf8(:,10), n3(:,21), t3x8(:,:,6))
  call vert_AZ_Q(gZd,ntry, wf4(:,16), wf4(:,11), wf16(:,7), n3(:,22), t3x16(:,:,7))
  call prop_Q_A(ntry, wf8(:,10), 28, MB, 1_intkind1, wf8(:,11), n2(12))
  call vert_ZQ_A(gZd,ntry, wf4(:,14), ex5(:), wf8(:,12), n3(:,23), t3x8(:,:,7))
  call prop_Q_A(ntry, wf8(:,12), 28, MB, 1_intkind1, wf8(:,13), n2(13))
  call vert_AQ_S(gH,ntry, wf4(:,16), ex5(:), wf8(:,14), n3(:,24), t3x8(:,:,8))
  call vert_VQ_A(ntry, ex7(:), wf8(:,9), wf16(:,8), n3(:,25), t3x16(:,:,8))
  call vert_VQ_A(ntry, ex7(:), wf8(:,11), wf16(:,9), n3(:,26), t3x16(:,:,9))
  call vert_VQ_A(ntry, ex7(:), wf8(:,13), wf16(:,10), n3(:,27), t3x16(:,:,10))
  call vert_VQ_A(ntry, ex7(:), ex3(:), wf4(:,17), n3(:,28), t3x4(:,:,10))
  call prop_Q_A(ntry, wf4(:,17), 68, ZERO, 0_intkind1, wf4(:,18), n2(14))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,11), wf8(:,15), n3(:,29), t3x8(:,:,9))
  call vert_VQ_A(ntry, wf4(:,3), wf4(:,18), wf16(:,11), n3(:,30), t3x16(:,:,11))
  call prop_A_Q(ntry, wf8(:,15), 11, ZERO, 0_intkind1, wf8(:,16), n2(15))
  call vert_ZQ_A(gZl,ntry, wf4(:,7), wf4(:,18), wf16(:,12), n3(:,31), t3x16(:,:,12))
  call vert_AQ_S(gH,ntry, ex6(:), ex5(:), wf4(:,19), n3(:,32), t3x4(:,:,11))
  call vert_QA_Z(gZl,ntry, wf4(:,18), ex4(:), wf8(:,17), n3(:,33), t3x8(:,:,10))
  call vert_SV_V(ntry, wf4(:,19), wf4(:,11), wf16(:,13), n3(:,34), t3x16(:,:,13))
  call prop_W_W(ntry, wf8(:,17), 76, MZ, 1_intkind1, wf8(:,18), n2(16))
  call vert_AV_Q(ntry, ex4(:), wf4(:,3), wf8(:,19), n3(:,35), t3x8(:,:,11))
  call vert_ZQ_A(gZl,ntry, wf4(:,11), wf4(:,18), wf16(:,14), n3(:,36), t3x16(:,:,14))
  call prop_A_Q(ntry, wf8(:,19), 56, ZERO, 0_intkind1, wf8(:,20), n2(17))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,7), wf8(:,21), n3(:,37), t3x8(:,:,12))
  call prop_A_Q(ntry, wf8(:,21), 56, ZERO, 0_intkind1, wf8(:,22), n2(18))
  call vert_AV_Q(ntry, ex4(:), ex7(:), wf4(:,20), n3(:,38), t3x4(:,:,12))
  call prop_A_Q(ntry, wf4(:,20), 72, ZERO, 0_intkind1, wf4(:,21), n2(19))
  call vert_ZQ_A(gZl,ntry, wf4(:,11), ex3(:), wf8(:,23), n3(:,39), t3x8(:,:,13))
  call vert_AV_Q(ntry, wf4(:,21), wf4(:,3), wf16(:,15), n3(:,40), t3x16(:,:,15))
  call prop_Q_A(ntry, wf8(:,23), 7, ZERO, 0_intkind1, wf8(:,24), n2(20))
  call vert_AZ_Q(gZl,ntry, wf4(:,21), wf4(:,7), wf16(:,16), n3(:,41), t3x16(:,:,16))
  call vert_QA_Z(gZl,ntry, ex3(:), wf4(:,21), wf8(:,25), n3(:,42), t3x8(:,:,14))
  call prop_W_W(ntry, wf8(:,25), 76, MZ, 1_intkind1, wf8(:,26), n2(21))
  call vert_VQ_A(ntry, wf4(:,3), ex3(:), wf8(:,27), n3(:,43), t3x8(:,:,15))
  call vert_AZ_Q(gZl,ntry, wf4(:,21), wf4(:,11), wf16(:,17), n3(:,44), t3x16(:,:,17))
  call prop_Q_A(ntry, wf8(:,27), 52, ZERO, 0_intkind1, wf8(:,28), n2(22))
  call vert_ZQ_A(gZl,ntry, wf4(:,7), ex3(:), wf8(:,29), n3(:,45), t3x8(:,:,16))
  call prop_Q_A(ntry, wf8(:,29), 52, ZERO, 0_intkind1, wf8(:,30), n2(23))
  call vert_VQ_A(ntry, ex7(:), wf8(:,24), wf16(:,18), n3(:,46), t3x16(:,:,18))
  call vert_VQ_A(ntry, ex7(:), wf8(:,28), wf16(:,19), n3(:,47), t3x16(:,:,19))
  call vert_VQ_A(ntry, ex7(:), wf8(:,30), wf16(:,20), n3(:,48), t3x16(:,:,20))
  call vert_QA_V(ntry, wf4(:,18), ex4(:), wf8(:,31), n3(:,49), t3x8(:,:,17))
  call vert_AV_Q(ntry, ex6(:), wf8(:,31), wf16(:,21), n3(:,50), t3x16(:,:,21))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf8(:,18), wf16(:,22), n3(:,51), t3x16(:,:,22))
  call vert_VQ_A(ntry, wf8(:,31), ex5(:), wf16(:,23), n3(:,52), t3x16(:,:,23))
  call vert_ZQ_A(gZd,ntry, wf8(:,18), ex5(:), wf16(:,24), n3(:,53), t3x16(:,:,24))
  call vert_QA_V(ntry, ex3(:), wf4(:,21), wf8(:,32), n3(:,54), t3x8(:,:,18))
  call vert_AV_Q(ntry, ex6(:), wf8(:,32), wf16(:,25), n3(:,55), t3x16(:,:,25))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf8(:,26), wf16(:,26), n3(:,56), t3x16(:,:,26))
  call vert_VQ_A(ntry, wf8(:,32), ex5(:), wf16(:,27), n3(:,57), t3x16(:,:,27))
  call vert_ZQ_A(gZd,ntry, wf8(:,26), ex5(:), wf16(:,28), n3(:,58), t3x16(:,:,28))
  call vert_QA_V(ntry, wf4(:,12), ex6(:), wf8(:,33), n3(:,59), t3x8(:,:,19))
  call vert_QA_V(ntry, wf8(:,24), ex4(:), wf16(:,29), n3(:,60), t3x16(:,:,29))
  call vert_QA_Z(gZd,ntry, wf4(:,12), ex6(:), wf8(:,34), n3(:,61), t3x8(:,:,20))
  call prop_W_W(ntry, wf8(:,34), 112, MZ, 1_intkind1, wf8(:,35), n2(24))
  call vert_QA_Z(gZl,ntry, wf8(:,24), ex4(:), wf16(:,30), n3(:,62), t3x16(:,:,30))
  call vert_QA_V(ntry, ex3(:), wf8(:,16), wf16(:,31), n3(:,63), t3x16(:,:,31))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,16), wf16(:,32), n3(:,64), t3x16(:,:,32))
  call vert_QA_V(ntry, ex5(:), wf4(:,16), wf8(:,36), n3(:,65), t3x8(:,:,21))
  call vert_QA_Z(gZd,ntry, ex5(:), wf4(:,16), wf8(:,37), n3(:,66), t3x8(:,:,22))
  call prop_W_W(ntry, wf8(:,37), 112, MZ, 1_intkind1, wf8(:,38), n2(25))
  call vert_UV_W(ntry, ex7(:), 64, wf4(:,4), 9, wf8(:,39), n3(:,67), t3x8(:,:,23))
  call vert_SV_V(ntry, wf4(:,19), wf4(:,5), wf16(:,33), n3(:,68), t3x16(:,:,33))
  call prop_W_W(ntry, wf8(:,39), 73, MW, 1_intkind1, wf8(:,40), n2(26))
  call vert_UV_W(ntry, wf4(:,5), 6, wf4(:,3), 48, wf16(:,34), n3(:,69), t3x16(:,:,34))
  call vert_UV_W(ntry, wf4(:,5), 6, wf4(:,7), 48, wf16(:,35), n3(:,70), t3x16(:,:,35))
  call vert_UV_W(ntry, wf4(:,5), 6, ex7(:), 64, wf8(:,41), n3(:,71), t3x8(:,:,24))
  call vert_SV_V(ntry, wf4(:,19), wf4(:,4), wf16(:,36), n3(:,72), t3x16(:,:,36))
  call prop_W_W(ntry, wf8(:,41), 70, MW, 1_intkind1, wf8(:,42), n2(27))
  call vert_UV_W(ntry, wf4(:,3), 48, wf4(:,4), 9, wf16(:,37), n3(:,73), t3x16(:,:,37))
  call vert_UV_W(ntry, wf4(:,7), 48, wf4(:,4), 9, wf16(:,38), n3(:,74), t3x16(:,:,38))
  call vert_AW_Q(ntry, ex6(:), wf4(:,5), wf8(:,43), n3(:,75), t3x8(:,:,25))
  call vert_WQ_A(ntry, wf4(:,4), wf4(:,12), wf16(:,39), n3(:,76), t3x16(:,:,39))
  call prop_A_Q(ntry, wf8(:,43), 38, MT, 1_intkind1, wf8(:,44), n2(28))
  call vert_VV_S(ntry, wf4(:,5), wf4(:,4), wf16(:,40), n3(:,77), t3x16(:,:,40))
  call vert_UV_W(ntry, wf4(:,4), 9, wf4(:,5), 6, wf16(:,41), n3(:,78), t3x16(:,:,41))
  call vert_WQ_A(ntry, wf4(:,4), ex5(:), wf8(:,45), n3(:,79), t3x8(:,:,26))
  call vert_AW_Q(ntry, wf4(:,16), wf4(:,5), wf16(:,42), n3(:,80), t3x16(:,:,42))
  call prop_Q_A(ntry, wf8(:,45), 25, MT, 1_intkind1, wf8(:,46), n2(29))
  call vert_VQ_A(ntry, ex7(:), wf8(:,46), wf16(:,43), n3(:,81), t3x16(:,:,43))
  call vert_QA_W(ntry, wf8(:,46), ex6(:), wf16(:,44), n3(:,82), t3x16(:,:,44))
  call vert_QA_W(ntry, ex5(:), wf8(:,44), wf16(:,45), n3(:,83), t3x16(:,:,45))
  call vert_WQ_A(ntry, wf4(:,5), ex1(:), wf8(:,47), n3(:,84), t3x8(:,:,27))
  call prop_Q_A(ntry, wf8(:,47), 7, ZERO, 0_intkind1, wf8(:,48), n2(30))
  call vert_QA_W(ntry, ex1(:), wf4(:,21), wf8(:,49), n3(:,85), t3x8(:,:,28))
  call prop_W_W(ntry, wf8(:,49), 73, MW, 1_intkind1, wf8(:,50), n2(31))
  call vert_ZQ_A(gZn,ntry, wf4(:,7), ex1(:), wf8(:,51), n3(:,86), t3x8(:,:,29))
  call vert_AW_Q(ntry, wf4(:,21), wf4(:,5), wf16(:,46), n3(:,87), t3x16(:,:,46))
  call prop_Q_A(ntry, wf8(:,51), 49, ZERO, 0_intkind1, wf8(:,52), n2(32))
  call vert_VQ_A(ntry, ex7(:), wf8(:,48), wf16(:,47), n3(:,88), t3x16(:,:,47))
  call vert_QA_W(ntry, wf8(:,52), ex4(:), wf16(:,48), n3(:,89), t3x16(:,:,48))
  call vert_QA_W(ntry, ex1(:), wf8(:,20), wf16(:,49), n3(:,90), t3x16(:,:,49))
  call vert_QA_W(ntry, ex1(:), wf8(:,22), wf16(:,50), n3(:,91), t3x16(:,:,50))
  call vert_WQ_A(ntry, wf8(:,50), ex5(:), wf16(:,51), n3(:,92), t3x16(:,:,51))
  call vert_QA_V(ntry, wf8(:,48), ex4(:), wf16(:,52), n3(:,93), t3x16(:,:,52))
  call vert_QA_Z(gZl,ntry, wf8(:,48), ex4(:), wf16(:,53), n3(:,94), t3x16(:,:,53))
  call vert_AW_Q(ntry, ex4(:), wf4(:,5), wf8(:,53), n3(:,95), t3x8(:,:,30))
  call prop_A_Q(ntry, wf8(:,53), 14, ZERO, 0_intkind1, wf8(:,54), n2(33))
  call vert_QA_Z(gZn,ntry, ex1(:), wf8(:,54), wf16(:,54), n3(:,96), t3x16(:,:,54))
  call vert_AW_Q(ntry, ex2(:), wf4(:,4), wf8(:,55), n3(:,97), t3x8(:,:,31))
  call prop_A_Q(ntry, wf8(:,55), 11, ZERO, 0_intkind1, wf8(:,56), n2(34))
  call vert_QA_W(ntry, wf4(:,18), ex2(:), wf8(:,57), n3(:,98), t3x8(:,:,32))
  call prop_W_W(ntry, wf8(:,57), 70, MW, 1_intkind1, wf8(:,58), n2(35))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf4(:,7), wf8(:,59), n3(:,99), t3x8(:,:,33))
  call vert_WQ_A(ntry, wf4(:,4), wf4(:,18), wf16(:,55), n3(:,100), t3x16(:,:,55))
  call prop_A_Q(ntry, wf8(:,59), 50, ZERO, 0_intkind1, wf8(:,60), n2(36))
  call vert_AV_Q(ntry, wf8(:,56), ex7(:), wf16(:,56), n3(:,101), t3x16(:,:,56))
  call vert_QA_W(ntry, ex3(:), wf8(:,60), wf16(:,57), n3(:,102), t3x16(:,:,57))
  call vert_QA_W(ntry, wf8(:,28), ex2(:), wf16(:,58), n3(:,103), t3x16(:,:,58))
  call vert_QA_W(ntry, wf8(:,30), ex2(:), wf16(:,59), n3(:,104), t3x16(:,:,59))
  call vert_AW_Q(ntry, ex6(:), wf8(:,58), wf16(:,60), n3(:,105), t3x16(:,:,60))
  call vert_QA_V(ntry, ex3(:), wf8(:,56), wf16(:,61), n3(:,106), t3x16(:,:,61))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,56), wf16(:,62), n3(:,107), t3x16(:,:,62))
  call vert_WQ_A(ntry, wf4(:,4), ex3(:), wf8(:,61), n3(:,108), t3x8(:,:,34))
  call prop_Q_A(ntry, wf8(:,61), 13, ZERO, 0_intkind1, wf8(:,62), n2(37))
  call vert_QA_Z(gZn,ntry, wf8(:,62), ex2(:), wf16(:,63), n3(:,109), t3x16(:,:,63))
  call vert_ZQ_A(gZn,ntry, wf4(:,14), ex1(:), wf8(:,63), n3(:,110), t3x8(:,:,35))
  call prop_Q_A(ntry, wf8(:,63), 13, ZERO, 0_intkind1, wf8(:,64), n2(38))
  call vert_QA_Z(gZn,ntry, wf8(:,64), ex2(:), wf16(:,64), n3(:,111), t3x16(:,:,64))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf4(:,14), wf8(:,65), n3(:,112), t3x8(:,:,36))
  call prop_A_Q(ntry, wf8(:,65), 14, ZERO, 0_intkind1, wf8(:,66), n2(39))
  call vert_QA_Z(gZn,ntry, ex1(:), wf8(:,66), wf16(:,65), n3(:,113), t3x16(:,:,65))
  call vert_WQ_A(ntry, wf8(:,58), ex1(:), wf16(:,66), n3(:,114), t3x16(:,:,66))
  call vert_QA_Z(gZn,ntry, ex1(:), wf8(:,60), wf16(:,67), n3(:,115), t3x16(:,:,67))
  call vert_QA_Z(gZn,ntry, wf8(:,52), ex2(:), wf16(:,68), n3(:,116), t3x16(:,:,68))
  call vert_AW_Q(ntry, ex2(:), wf8(:,50), wf16(:,69), n3(:,117), t3x16(:,:,69))
  call vert_WQ_A(ntry, wf8(:,50), ex3(:), wf16(:,70), n3(:,118), t3x16(:,:,70))
  call counter_QA_V(ntry, ex5(:), ex6(:), wf4(:,22), n3(:,119), t3x4(:,:,13))
  call counter_QA_Z(gZd,ntry, ex5(:), ex6(:), wf4(:,23), n3(:,120), t3x4(:,:,14))
  call prop_W_W(ntry, wf4(:,23), 48, MZ, 1_intkind1, wf4(:,24), n2(40))
  call counter_VQ_A(ntry, wf4(:,9), wf4(:,12), wf16(:,71), n3(:,121), t3x16(:,:,71))
  call counter_ZQ_A(gZd,ntry, wf4(:,14), wf4(:,12), wf16(:,72), n3(:,122), t3x16(:,:,72))
  call counter_ZQ_A(gZd,ntry, wf4(:,11), wf4(:,12), wf16(:,73), n3(:,123), t3x16(:,:,73))
  call counter_AV_Q(ntry, wf4(:,16), wf4(:,9), wf16(:,74), n3(:,124), t3x16(:,:,74))
  call counter_AZ_Q(gZd,ntry, wf4(:,16), wf4(:,14), wf16(:,75), n3(:,125), t3x16(:,:,75))
  call counter_AZ_Q(gZd,ntry, wf4(:,16), wf4(:,11), wf16(:,76), n3(:,126), t3x16(:,:,76))
  call counter_VQ_A(ntry, ex7(:), wf8(:,9), wf16(:,77), n3(:,127), t3x16(:,:,77))
  call counter_VQ_A(ntry, ex7(:), wf8(:,11), wf16(:,78), n3(:,128), t3x16(:,:,78))
  call counter_VQ_A(ntry, ex7(:), wf8(:,13), wf16(:,79), n3(:,129), t3x16(:,:,79))
  call counter_AQ_S(gH,ntry, ex6(:), wf4(:,12), wf8(:,67), n3(:,130), t3x8(:,:,37))
  call counter_AV_Q(ntry, ex6(:), wf4(:,9), wf8(:,68), n3(:,131), t3x8(:,:,38))
  call prop_Q_A(ntry, wf16(:,3), 83, MB, 1_intkind1, wf16(:,80), n2(41))
  call counter_AZ_Q(gZd,ntry, ex6(:), wf4(:,14), wf8(:,69), n3(:,132), t3x8(:,:,39))
  call counter_AZ_Q(gZd,ntry, ex6(:), wf4(:,11), wf8(:,70), n3(:,133), t3x8(:,:,40))
  call prop_Q_A(ntry, wf16(:,1), 92, MB, 1_intkind1, wf16(:,81), n2(42))
  call prop_Q_A(ntry, wf16(:,2), 92, MB, 1_intkind1, wf16(:,82), n2(43))
  call prop_A_Q(ntry, wf8(:,68), 44, MB, 1_intkind1, wf8(:,71), n2(44))
  call prop_A_Q(ntry, wf8(:,69), 44, MB, 1_intkind1, wf8(:,72), n2(45))
  call prop_A_Q(ntry, wf8(:,70), 35, MB, 1_intkind1, wf8(:,73), n2(46))
  call counter_AV_Q(ntry, ex6(:), ex7(:), wf4(:,25), n3(:,134), t3x4(:,:,15))
  call prop_A_Q(ntry, wf4(:,25), 96, MB, 1_intkind1, wf4(:,26), n2(47))
  call vert_AV_Q(ntry, wf4(:,26), wf4(:,9), wf16(:,83), n3(:,135), t3x16(:,:,80))
  call vert_AZ_Q(gZd,ntry, wf4(:,26), wf4(:,14), wf16(:,84), n3(:,136), t3x16(:,:,81))
  call vert_AZ_Q(gZd,ntry, wf4(:,26), wf4(:,11), wf16(:,85), n3(:,137), t3x16(:,:,82))
  call vert_AQ_S(gH,ntry, wf4(:,26), ex5(:), wf8(:,74), n3(:,138), t3x8(:,:,41))
  call counter_AQ_S(gH,ntry, wf4(:,16), ex5(:), wf8(:,75), n3(:,139), t3x8(:,:,42))
  call counter_VQ_A(ntry, wf4(:,9), ex5(:), wf8(:,76), n3(:,140), t3x8(:,:,43))
  call prop_A_Q(ntry, wf16(:,7), 99, MB, 1_intkind1, wf16(:,86), n2(48))
  call counter_ZQ_A(gZd,ntry, wf4(:,14), ex5(:), wf8(:,77), n3(:,141), t3x8(:,:,44))
  call counter_ZQ_A(gZd,ntry, wf4(:,11), ex5(:), wf8(:,78), n3(:,142), t3x8(:,:,45))
  call prop_A_Q(ntry, wf16(:,5), 108, MB, 1_intkind1, wf16(:,87), n2(49))
  call prop_A_Q(ntry, wf16(:,6), 108, MB, 1_intkind1, wf16(:,88), n2(50))
  call prop_Q_A(ntry, wf8(:,76), 28, MB, 1_intkind1, wf8(:,79), n2(51))
  call vert_VQ_A(ntry, ex7(:), wf8(:,79), wf16(:,89), n3(:,143), t3x16(:,:,83))
  call prop_Q_A(ntry, wf8(:,77), 28, MB, 1_intkind1, wf8(:,80), n2(52))
  call vert_VQ_A(ntry, ex7(:), wf8(:,80), wf16(:,90), n3(:,144), t3x16(:,:,84))
  call prop_Q_A(ntry, wf8(:,78), 19, MB, 1_intkind1, wf8(:,81), n2(53))
  call vert_VQ_A(ntry, ex7(:), wf8(:,81), wf16(:,91), n3(:,145), t3x16(:,:,85))
  call counter_VQ_A(ntry, ex7(:), ex5(:), wf4(:,27), n3(:,146), t3x4(:,:,16))
  call prop_Q_A(ntry, wf4(:,27), 80, MB, 1_intkind1, wf4(:,28), n2(54))
  call vert_VQ_A(ntry, wf4(:,9), wf4(:,28), wf16(:,92), n3(:,147), t3x16(:,:,86))
  call vert_ZQ_A(gZd,ntry, wf4(:,14), wf4(:,28), wf16(:,93), n3(:,148), t3x16(:,:,87))
  call vert_ZQ_A(gZd,ntry, wf4(:,11), wf4(:,28), wf16(:,94), n3(:,149), t3x16(:,:,88))
  call vert_AQ_S(gH,ntry, ex6(:), wf4(:,28), wf8(:,82), n3(:,150), t3x8(:,:,46))
  call counter_AV_Q(ntry, ex6(:), wf8(:,31), wf16(:,95), n3(:,151), t3x16(:,:,89))
  call counter_AZ_Q(gZd,ntry, ex6(:), wf8(:,18), wf16(:,96), n3(:,152), t3x16(:,:,90))
  call counter_AV_Q(ntry, ex6(:), wf8(:,32), wf16(:,97), n3(:,153), t3x16(:,:,91))
  call counter_AZ_Q(gZd,ntry, ex6(:), wf8(:,26), wf16(:,98), n3(:,154), t3x16(:,:,92))
  call counter_QA_V(ntry, wf4(:,12), ex6(:), wf8(:,83), n3(:,155), t3x8(:,:,47))
  call counter_QA_Z(gZd,ntry, wf4(:,12), ex6(:), wf8(:,84), n3(:,156), t3x8(:,:,48))
  call prop_W_W(ntry, wf8(:,84), 112, MZ, 1_intkind1, wf8(:,85), n2(55))
  call vert_QA_V(ntry, ex5(:), wf4(:,26), wf8(:,86), n3(:,157), t3x8(:,:,49))
  call vert_QA_Z(gZd,ntry, ex5(:), wf4(:,26), wf8(:,87), n3(:,158), t3x8(:,:,50))
  call prop_W_W(ntry, wf8(:,87), 112, MZ, 1_intkind1, wf8(:,88), n2(56))
  call counter_VQ_A(ntry, wf8(:,31), ex5(:), wf16(:,99), n3(:,159), t3x16(:,:,93))
  call counter_ZQ_A(gZd,ntry, wf8(:,18), ex5(:), wf16(:,100), n3(:,160), t3x16(:,:,94))
  call counter_VQ_A(ntry, wf8(:,32), ex5(:), wf16(:,101), n3(:,161), t3x16(:,:,95))
  call counter_ZQ_A(gZd,ntry, wf8(:,26), ex5(:), wf16(:,102), n3(:,162), t3x16(:,:,96))
  call counter_QA_V(ntry, ex5(:), wf4(:,16), wf8(:,89), n3(:,163), t3x8(:,:,51))
  call counter_QA_Z(gZd,ntry, ex5(:), wf4(:,16), wf8(:,90), n3(:,164), t3x8(:,:,52))
  call prop_W_W(ntry, wf8(:,90), 112, MZ, 1_intkind1, wf8(:,91), n2(57))
  call vert_QA_V(ntry, wf4(:,28), ex6(:), wf8(:,92), n3(:,165), t3x8(:,:,53))
  call vert_QA_Z(gZd,ntry, wf4(:,28), ex6(:), wf8(:,93), n3(:,166), t3x8(:,:,54))
  call prop_W_W(ntry, wf8(:,93), 112, MZ, 1_intkind1, wf8(:,94), n2(58))
  call vert_VQ_A(ntry, wf4(:,22), wf4(:,18), wf16(:,103), n3(:,167), t3x16(:,:,97))
  call vert_ZQ_A(gZl,ntry, wf4(:,24), wf4(:,18), wf16(:,104), n3(:,168), t3x16(:,:,98))
  call counter_AQ_S(gH,ntry, ex6(:), ex5(:), wf4(:,29), n3(:,169), t3x4(:,:,17))
  call vert_SV_V(ntry, wf4(:,29), wf4(:,11), wf16(:,105), n3(:,170), t3x16(:,:,99))
  call vert_AV_Q(ntry, ex4(:), wf4(:,22), wf8(:,95), n3(:,171), t3x8(:,:,55))
  call prop_A_Q(ntry, wf8(:,95), 56, ZERO, 0_intkind1, wf8(:,96), n2(59))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,24), wf8(:,97), n3(:,172), t3x8(:,:,56))
  call prop_A_Q(ntry, wf8(:,97), 56, ZERO, 0_intkind1, wf8(:,98), n2(60))
  call vert_AV_Q(ntry, wf4(:,21), wf4(:,22), wf16(:,106), n3(:,173), t3x16(:,:,100))
  call vert_AZ_Q(gZl,ntry, wf4(:,21), wf4(:,24), wf16(:,107), n3(:,174), t3x16(:,:,101))
  call vert_VQ_A(ntry, wf4(:,22), ex3(:), wf8(:,99), n3(:,175), t3x8(:,:,57))
  call prop_Q_A(ntry, wf8(:,99), 52, ZERO, 0_intkind1, wf8(:,100), n2(61))
  call vert_ZQ_A(gZl,ntry, wf4(:,24), ex3(:), wf8(:,101), n3(:,176), t3x8(:,:,58))
  call prop_Q_A(ntry, wf8(:,101), 52, ZERO, 0_intkind1, wf8(:,102), n2(62))
  call vert_VQ_A(ntry, ex7(:), wf8(:,100), wf16(:,108), n3(:,177), t3x16(:,:,102))
  call vert_VQ_A(ntry, ex7(:), wf8(:,102), wf16(:,109), n3(:,178), t3x16(:,:,103))
  call counter_WQ_A(ntry, wf4(:,4), wf4(:,12), wf16(:,110), n3(:,179), t3x16(:,:,104))
  call counter_AW_Q(ntry, wf4(:,16), wf4(:,5), wf16(:,111), n3(:,180), t3x16(:,:,105))
  call counter_VQ_A(ntry, ex7(:), wf8(:,46), wf16(:,112), n3(:,181), t3x16(:,:,106))
  call prop_W_W(ntry, wf16(:,41), 15, MZ, 1_intkind1, wf16(:,113), n2(63))
  call counter_AW_Q(ntry, ex6(:), wf4(:,5), wf8(:,103), n3(:,182), t3x8(:,:,59))
  call prop_Q_A(ntry, wf16(:,39), 89, MT, 1_intkind1, wf16(:,114), n2(64))
  call counter_QA_W(ntry, wf8(:,46), ex6(:), wf16(:,115), n3(:,183), t3x16(:,:,107))
  call prop_A_Q(ntry, wf8(:,103), 38, MT, 1_intkind1, wf8(:,104), n2(65))
  call vert_QA_W(ntry, ex5(:), wf8(:,104), wf16(:,116), n3(:,184), t3x16(:,:,108))
  call vert_AW_Q(ntry, wf4(:,26), wf4(:,5), wf16(:,117), n3(:,185), t3x16(:,:,109))
  call counter_WQ_A(ntry, wf4(:,4), ex5(:), wf8(:,105), n3(:,186), t3x8(:,:,60))
  call prop_A_Q(ntry, wf16(:,42), 102, MT, 1_intkind1, wf16(:,118), n2(66))
  call counter_QA_W(ntry, ex5(:), wf8(:,44), wf16(:,119), n3(:,187), t3x16(:,:,110))
  call prop_Q_A(ntry, wf8(:,105), 25, MT, 1_intkind1, wf8(:,106), n2(67))
  call vert_VQ_A(ntry, ex7(:), wf8(:,106), wf16(:,120), n3(:,188), t3x16(:,:,111))
  call vert_QA_W(ntry, wf8(:,106), ex6(:), wf16(:,121), n3(:,189), t3x16(:,:,112))
  call vert_WQ_A(ntry, wf4(:,4), wf4(:,28), wf16(:,122), n3(:,190), t3x16(:,:,113))
  call vert_SV_V(ntry, wf4(:,29), wf4(:,5), wf16(:,123), n3(:,191), t3x16(:,:,114))
  call vert_UV_W(ntry, wf4(:,5), 6, wf4(:,22), 48, wf16(:,124), n3(:,192), t3x16(:,:,115))
  call vert_UV_W(ntry, wf4(:,5), 6, wf4(:,24), 48, wf16(:,125), n3(:,193), t3x16(:,:,116))
  call vert_SV_V(ntry, wf4(:,29), wf4(:,4), wf16(:,126), n3(:,194), t3x16(:,:,117))
  call vert_UV_W(ntry, wf4(:,22), 48, wf4(:,4), 9, wf16(:,127), n3(:,195), t3x16(:,:,118))
  call vert_UV_W(ntry, wf4(:,24), 48, wf4(:,4), 9, wf16(:,128), n3(:,196), t3x16(:,:,119))
  call counter_WQ_A(ntry, wf8(:,50), ex5(:), wf16(:,129), n3(:,197), t3x16(:,:,120))
  call vert_ZQ_A(gZn,ntry, wf4(:,24), ex1(:), wf8(:,107), n3(:,198), t3x8(:,:,61))
  call prop_Q_A(ntry, wf8(:,107), 49, ZERO, 0_intkind1, wf8(:,108), n2(68))
  call vert_QA_W(ntry, ex1(:), wf8(:,96), wf16(:,130), n3(:,199), t3x16(:,:,121))
  call vert_QA_W(ntry, ex1(:), wf8(:,98), wf16(:,131), n3(:,200), t3x16(:,:,122))
  call vert_QA_W(ntry, wf8(:,108), ex4(:), wf16(:,132), n3(:,201), t3x16(:,:,123))
  call counter_AW_Q(ntry, ex6(:), wf8(:,58), wf16(:,133), n3(:,202), t3x16(:,:,124))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf4(:,24), wf8(:,109), n3(:,203), t3x8(:,:,62))
  call prop_A_Q(ntry, wf8(:,109), 50, ZERO, 0_intkind1, wf8(:,110), n2(69))
  call vert_QA_W(ntry, wf8(:,100), ex2(:), wf16(:,134), n3(:,204), t3x16(:,:,125))
  call vert_QA_W(ntry, wf8(:,102), ex2(:), wf16(:,135), n3(:,205), t3x16(:,:,126))
  call vert_QA_W(ntry, ex3(:), wf8(:,110), wf16(:,136), n3(:,206), t3x16(:,:,127))
  call vert_QA_Z(gZn,ntry, ex1(:), wf8(:,110), wf16(:,137), n3(:,207), t3x16(:,:,128))
  call vert_QA_Z(gZn,ntry, wf8(:,108), ex2(:), wf16(:,138), n3(:,208), t3x16(:,:,129))
  call counter_Q_A(ctbb,5,ntry, wf4(:,12), 80, wf4(:,30), n2(70))
  call prop_Q_A(ntry, wf4(:,30), 80, MB, 1_intkind1, wf4(:,31), n2(71))
  call vert_AQ_S(gH,ntry, ex6(:), wf4(:,31), wf8(:,111), n3(:,209), t3x8(:,:,63))
  call vert_VQ_A(ntry, wf4(:,9), wf4(:,31), wf16(:,139), n3(:,210), t3x16(:,:,130))
  call vert_ZQ_A(gZd,ntry, wf4(:,14), wf4(:,31), wf16(:,140), n3(:,211), t3x16(:,:,131))
  call vert_ZQ_A(gZd,ntry, wf4(:,11), wf4(:,31), wf16(:,141), n3(:,212), t3x16(:,:,132))
  call counter_A_Q(ctbb,5,ntry, wf8(:,2), 35, wf8(:,112), n2(72))
  call counter_A_Q(ctbb,5,ntry, wf8(:,4), 44, wf8(:,113), n2(73))
  call counter_A_Q(ctbb,5,ntry, wf8(:,6), 44, wf8(:,114), n2(74))
  call counter_A_Q(ctbb,5,ntry, wf4(:,16), 96, wf4(:,32), n2(75))
  call prop_A_Q(ntry, wf4(:,32), 96, MB, 1_intkind1, wf4(:,33), n2(76))
  call vert_AQ_S(gH,ntry, wf4(:,33), ex5(:), wf8(:,115), n3(:,213), t3x8(:,:,64))
  call counter_Q_A(ctbb,5,ntry, wf8(:,9), 19, wf8(:,116), n2(77))
  call counter_Q_A(ctbb,5,ntry, wf8(:,11), 28, wf8(:,117), n2(78))
  call counter_Q_A(ctbb,5,ntry, wf8(:,13), 28, wf8(:,118), n2(79))
  call vert_AV_Q(ntry, wf4(:,33), wf4(:,9), wf16(:,142), n3(:,214), t3x16(:,:,133))
  call vert_AZ_Q(gZd,ntry, wf4(:,33), wf4(:,14), wf16(:,143), n3(:,215), t3x16(:,:,134))
  call vert_AZ_Q(gZd,ntry, wf4(:,33), wf4(:,11), wf16(:,144), n3(:,216), t3x16(:,:,135))
  call vert_AV_Q(ntry, wf8(:,4), ex7(:), wf16(:,145), n3(:,217), t3x16(:,:,136))
  call prop_A_Q(ntry, wf16(:,145), 108, MB, 1_intkind1, wf16(:,146), n2(80))
  call vert_AV_Q(ntry, wf8(:,6), ex7(:), wf16(:,147), n3(:,218), t3x16(:,:,137))
  call prop_A_Q(ntry, wf16(:,147), 108, MB, 1_intkind1, wf16(:,148), n2(81))
  call vert_AV_Q(ntry, wf8(:,2), ex7(:), wf16(:,149), n3(:,219), t3x16(:,:,138))
  call prop_A_Q(ntry, wf16(:,149), 99, MB, 1_intkind1, wf16(:,150), n2(82))
  call prop_Q_A(ntry, wf16(:,8), 83, MB, 1_intkind1, wf16(:,151), n2(83))
  call prop_Q_A(ntry, wf16(:,9), 92, MB, 1_intkind1, wf16(:,152), n2(84))
  call prop_Q_A(ntry, wf16(:,10), 92, MB, 1_intkind1, wf16(:,153), n2(85))
  call prop_A_Q(ntry, wf16(:,21), 108, MB, 1_intkind1, wf16(:,154), n2(86))
  call prop_A_Q(ntry, wf16(:,22), 108, MB, 1_intkind1, wf16(:,155), n2(87))
  call prop_Q_A(ntry, wf16(:,23), 92, MB, 1_intkind1, wf16(:,156), n2(88))
  call prop_Q_A(ntry, wf16(:,24), 92, MB, 1_intkind1, wf16(:,157), n2(89))
  call prop_A_Q(ntry, wf16(:,25), 108, MB, 1_intkind1, wf16(:,158), n2(90))
  call prop_A_Q(ntry, wf16(:,26), 108, MB, 1_intkind1, wf16(:,159), n2(91))
  call prop_Q_A(ntry, wf16(:,27), 92, MB, 1_intkind1, wf16(:,160), n2(92))
  call prop_Q_A(ntry, wf16(:,28), 92, MB, 1_intkind1, wf16(:,161), n2(93))
  call vert_QA_V(ntry, wf4(:,31), ex6(:), wf8(:,119), n3(:,220), t3x8(:,:,65))
  call vert_QA_Z(gZd,ntry, wf4(:,31), ex6(:), wf8(:,120), n3(:,221), t3x8(:,:,66))
  call prop_W_W(ntry, wf16(:,30), 15, MZ, 1_intkind1, wf16(:,162), n2(94))
  call prop_W_W(ntry, wf16(:,32), 15, MZ, 1_intkind1, wf16(:,163), n2(95))
  call vert_QA_V(ntry, ex5(:), wf4(:,33), wf8(:,121), n3(:,222), t3x8(:,:,67))
  call vert_QA_Z(gZd,ntry, ex5(:), wf4(:,33), wf8(:,122), n3(:,223), t3x8(:,:,68))
  call vert_WQ_A(ntry, wf4(:,4), wf4(:,31), wf16(:,164), n3(:,224), t3x16(:,:,139))
  call counter_A_Q(cttt,6,ntry, wf8(:,44), 38, wf8(:,123), n2(96))
  call counter_Q_A(cttt,6,ntry, wf8(:,46), 25, wf8(:,124), n2(97))
  call vert_AW_Q(ntry, wf4(:,33), wf4(:,5), wf16(:,165), n3(:,225), t3x16(:,:,140))
  call vert_AW_Q(ntry, ex6(:), wf8(:,42), wf16(:,166), n3(:,226), t3x16(:,:,141))
  call prop_A_Q(ntry, wf16(:,166), 102, MT, 1_intkind1, wf16(:,167), n2(98))
  call vert_WQ_A(ntry, wf8(:,40), ex5(:), wf16(:,168), n3(:,227), t3x16(:,:,142))
  call prop_Q_A(ntry, wf16(:,168), 89, MT, 1_intkind1, wf16(:,169), n2(99))
  call vert_AV_Q(ntry, wf8(:,44), ex7(:), wf16(:,170), n3(:,228), t3x16(:,:,143))
  call prop_A_Q(ntry, wf16(:,170), 102, MT, 1_intkind1, wf16(:,171), n2(100))
  call prop_Q_A(ntry, wf16(:,43), 89, MT, 1_intkind1, wf16(:,172), n2(101))
  call prop_Q_A(ntry, wf16(:,51), 89, MT, 1_intkind1, wf16(:,173), n2(102))
  call prop_W_W(ntry, wf16(:,53), 15, MZ, 1_intkind1, wf16(:,174), n2(103))
  call prop_W_W(ntry, wf16(:,54), 15, MZ, 1_intkind1, wf16(:,175), n2(104))
  call prop_A_Q(ntry, wf16(:,60), 102, MT, 1_intkind1, wf16(:,176), n2(105))
  call prop_W_W(ntry, wf16(:,62), 15, MZ, 1_intkind1, wf16(:,177), n2(106))
  call prop_W_W(ntry, wf16(:,63), 15, MZ, 1_intkind1, wf16(:,178), n2(107))
  call prop_W_W(ntry, wf16(:,64), 15, MZ, 1_intkind1, wf16(:,179), n2(108))
  call prop_W_W(ntry, wf16(:,65), 15, MZ, 1_intkind1, wf16(:,180), n2(109))
  call prop_W_W(ntry, wf32(:,1), 79, MZ, 1_intkind1, wf32(:,2), n2(110))
  call vert_VQ_A(ntry, wf4(:,9), wf8(:,9), wf32(:,3), n3(:,229), t3x32(:,:,1))
  call prop_Q_A(ntry, wf32(:,3), 31, MB, 1_intkind1, wf32(:,4), n2(111))
  call vert_ZQ_A(gZd,ntry, wf4(:,14), wf8(:,9), wf32(:,5), n3(:,230), t3x32(:,:,2))
  call prop_Q_A(ntry, wf32(:,5), 31, MB, 1_intkind1, wf32(:,6), n2(112))
  call vert_AV_Q(ntry, wf8(:,2), wf4(:,9), wf32(:,7), n3(:,231), t3x32(:,:,3))
  call prop_A_Q(ntry, wf32(:,7), 47, MB, 1_intkind1, wf32(:,8), n2(113))
  call vert_AZ_Q(gZd,ntry, wf8(:,2), wf4(:,14), wf32(:,9), n3(:,232), t3x32(:,:,4))
  call prop_A_Q(ntry, wf32(:,9), 47, MB, 1_intkind1, wf32(:,10), n2(114))
  call vert_ZQ_A(gZd,ntry, wf4(:,11), wf8(:,11), wf32(:,11), n3(:,233), t3x32(:,:,5))
  call prop_Q_A(ntry, wf32(:,11), 31, MB, 1_intkind1, wf32(:,12), n2(115))
  call vert_ZQ_A(gZd,ntry, wf4(:,11), wf8(:,13), wf32(:,13), n3(:,234), t3x32(:,:,6))
  call prop_Q_A(ntry, wf32(:,13), 31, MB, 1_intkind1, wf32(:,14), n2(116))
  call vert_AZ_Q(gZd,ntry, wf8(:,4), wf4(:,11), wf32(:,15), n3(:,235), t3x32(:,:,7))
  call prop_A_Q(ntry, wf32(:,15), 47, MB, 1_intkind1, wf32(:,16), n2(117))
  call vert_AZ_Q(gZd,ntry, wf8(:,6), wf4(:,11), wf32(:,17), n3(:,236), t3x32(:,:,8))
  call prop_A_Q(ntry, wf32(:,17), 47, MB, 1_intkind1, wf32(:,18), n2(118))
  call vert_QS_A(gH,ntry, ex5(:), wf16(:,4), wf32(:,19), n3(:,237), t3x32(:,:,9))
  call prop_Q_A(ntry, wf32(:,19), 31, MB, 1_intkind1, wf32(:,20), n2(119))
  call vert_SA_Q(gH,ntry, wf16(:,4), ex6(:), wf32(:,21), n3(:,238), t3x32(:,:,10))
  call prop_A_Q(ntry, wf32(:,21), 47, MB, 1_intkind1, wf32(:,22), n2(120))
  call vert_QA_V(ntry, wf4(:,18), wf8(:,16), wf32(:,23), n3(:,239), t3x32(:,:,11))
  call vert_QA_Z(gZl,ntry, wf4(:,18), wf8(:,16), wf32(:,24), n3(:,240), t3x32(:,:,12))
  call prop_W_W(ntry, wf32(:,24), 79, MZ, 1_intkind1, wf32(:,25), n2(121))
  call vert_VV_S(ntry, wf4(:,11), wf8(:,18), wf32(:,26), n3(:,241), t3x32(:,:,13))
  call prop_Q_A(ntry, wf16(:,14), 71, ZERO, 0_intkind1, wf16(:,181), n2(122))
  call vert_QA_V(ntry, wf16(:,181), ex4(:), wf32(:,27), n3(:,242), t3x32(:,:,14))
  call vert_QA_Z(gZl,ntry, wf16(:,181), ex4(:), wf32(:,28), n3(:,243), t3x32(:,:,15))
  call prop_W_W(ntry, wf32(:,28), 79, MZ, 1_intkind1, wf32(:,29), n2(123))
  call vert_QA_V(ntry, wf8(:,24), wf4(:,21), wf32(:,30), n3(:,244), t3x32(:,:,16))
  call vert_QA_Z(gZl,ntry, wf8(:,24), wf4(:,21), wf32(:,31), n3(:,245), t3x32(:,:,17))
  call prop_W_W(ntry, wf32(:,31), 79, MZ, 1_intkind1, wf32(:,32), n2(124))
  call vert_VV_S(ntry, wf4(:,11), wf8(:,26), wf32(:,33), n3(:,246), t3x32(:,:,18))
  call prop_A_Q(ntry, wf16(:,17), 75, ZERO, 0_intkind1, wf16(:,182), n2(125))
  call vert_QA_V(ntry, ex3(:), wf16(:,182), wf32(:,34), n3(:,247), t3x32(:,:,19))
  call vert_QA_Z(gZl,ntry, ex3(:), wf16(:,182), wf32(:,35), n3(:,248), t3x32(:,:,20))
  call prop_W_W(ntry, wf32(:,35), 79, MZ, 1_intkind1, wf32(:,36), n2(126))
  call vert_VQ_A(ntry, wf16(:,29), ex5(:), wf32(:,37), n3(:,249), t3x32(:,:,21))
  call prop_Q_A(ntry, wf32(:,37), 31, MB, 1_intkind1, wf32(:,38), n2(127))
  call vert_ZQ_A(gZd,ntry, wf16(:,162), ex5(:), wf32(:,39), n3(:,250), t3x32(:,:,22))
  call prop_Q_A(ntry, wf32(:,39), 31, MB, 1_intkind1, wf32(:,40), n2(128))
  call vert_AV_Q(ntry, ex6(:), wf16(:,29), wf32(:,41), n3(:,251), t3x32(:,:,23))
  call prop_A_Q(ntry, wf32(:,41), 47, MB, 1_intkind1, wf32(:,42), n2(129))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,162), wf32(:,43), n3(:,252), t3x32(:,:,24))
  call prop_A_Q(ntry, wf32(:,43), 47, MB, 1_intkind1, wf32(:,44), n2(130))
  call prop_Q_A(ntry, wf16(:,18), 71, ZERO, 0_intkind1, wf16(:,183), n2(131))
  call vert_QA_V(ntry, wf16(:,183), ex4(:), wf32(:,45), n3(:,253), t3x32(:,:,25))
  call vert_QA_Z(gZl,ntry, wf16(:,183), ex4(:), wf32(:,46), n3(:,254), t3x32(:,:,26))
  call prop_W_W(ntry, wf32(:,46), 79, MZ, 1_intkind1, wf32(:,47), n2(132))
  call vert_VQ_A(ntry, wf16(:,31), ex5(:), wf32(:,48), n3(:,255), t3x32(:,:,27))
  call prop_Q_A(ntry, wf32(:,48), 31, MB, 1_intkind1, wf32(:,49), n2(133))
  call vert_ZQ_A(gZd,ntry, wf16(:,163), ex5(:), wf32(:,50), n3(:,256), t3x32(:,:,28))
  call prop_Q_A(ntry, wf32(:,50), 31, MB, 1_intkind1, wf32(:,51), n2(134))
  call vert_AV_Q(ntry, ex6(:), wf16(:,31), wf32(:,52), n3(:,257), t3x32(:,:,29))
  call prop_A_Q(ntry, wf32(:,52), 47, MB, 1_intkind1, wf32(:,53), n2(135))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,163), wf32(:,54), n3(:,258), t3x32(:,:,30))
  call prop_A_Q(ntry, wf32(:,54), 47, MB, 1_intkind1, wf32(:,55), n2(136))
  call vert_AV_Q(ntry, wf8(:,16), ex7(:), wf16(:,184), n3(:,259), t3x16(:,:,144))
  call prop_A_Q(ntry, wf16(:,184), 75, ZERO, 0_intkind1, wf16(:,185), n2(137))
  call vert_QA_V(ntry, ex3(:), wf16(:,185), wf32(:,56), n3(:,260), t3x32(:,:,31))
  call vert_QA_Z(gZl,ntry, ex3(:), wf16(:,185), wf32(:,57), n3(:,261), t3x32(:,:,32))
  call prop_W_W(ntry, wf32(:,57), 79, MZ, 1_intkind1, wf32(:,58), n2(138))
  call vert_WQ_A(ntry, wf4(:,5), wf8(:,46), wf32(:,59), n3(:,262), t3x32(:,:,33))
  call prop_Q_A(ntry, wf32(:,59), 31, MB, 1_intkind1, wf32(:,60), n2(139))
  call vert_VV_S(ntry, wf4(:,5), wf8(:,40), wf32(:,61), n3(:,263), t3x32(:,:,34))
  call vert_UV_W(ntry, wf8(:,40), 73, wf4(:,5), 6, wf32(:,62), n3(:,264), t3x32(:,:,35))
  call prop_W_W(ntry, wf32(:,62), 79, MZ, 1_intkind1, wf32(:,63), n2(140))
  call vert_AW_Q(ntry, wf8(:,44), wf4(:,4), wf32(:,64), n3(:,265), t3x32(:,:,36))
  call prop_A_Q(ntry, wf32(:,64), 47, MB, 1_intkind1, wf32(:,65), n2(141))
  call vert_VV_S(ntry, wf4(:,4), wf8(:,42), wf32(:,66), n3(:,266), t3x32(:,:,37))
  call vert_UV_W(ntry, wf4(:,4), 9, wf8(:,42), 70, wf32(:,67), n3(:,267), t3x32(:,:,38))
  call prop_W_W(ntry, wf32(:,67), 79, MZ, 1_intkind1, wf32(:,68), n2(142))
  call vert_QS_A(gH,ntry, ex5(:), wf16(:,40), wf32(:,69), n3(:,268), t3x32(:,:,39))
  call prop_Q_A(ntry, wf32(:,69), 31, MB, 1_intkind1, wf32(:,70), n2(143))
  call vert_VQ_A(ntry, wf16(:,41), ex5(:), wf32(:,71), n3(:,269), t3x32(:,:,40))
  call prop_Q_A(ntry, wf32(:,71), 31, MB, 1_intkind1, wf32(:,72), n2(144))
  call vert_ZQ_A(gZd,ntry, wf16(:,113), ex5(:), wf32(:,73), n3(:,270), t3x32(:,:,41))
  call prop_Q_A(ntry, wf32(:,73), 31, MB, 1_intkind1, wf32(:,74), n2(145))
  call vert_SA_Q(gH,ntry, wf16(:,40), ex6(:), wf32(:,75), n3(:,271), t3x32(:,:,42))
  call prop_A_Q(ntry, wf32(:,75), 47, MB, 1_intkind1, wf32(:,76), n2(146))
  call vert_AV_Q(ntry, ex6(:), wf16(:,41), wf32(:,77), n3(:,272), t3x32(:,:,43))
  call prop_A_Q(ntry, wf32(:,77), 47, MB, 1_intkind1, wf32(:,78), n2(147))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,113), wf32(:,79), n3(:,273), t3x32(:,:,44))
  call prop_A_Q(ntry, wf32(:,79), 47, MB, 1_intkind1, wf32(:,80), n2(148))
  call vert_QA_V(ntry, wf8(:,48), wf4(:,21), wf32(:,81), n3(:,274), t3x32(:,:,45))
  call vert_QA_Z(gZl,ntry, wf8(:,48), wf4(:,21), wf32(:,82), n3(:,275), t3x32(:,:,46))
  call prop_W_W(ntry, wf32(:,82), 79, MZ, 1_intkind1, wf32(:,83), n2(149))
  call vert_VV_S(ntry, wf4(:,5), wf8(:,50), wf32(:,84), n3(:,276), t3x32(:,:,47))
  call vert_UV_W(ntry, wf8(:,50), 73, wf4(:,5), 6, wf32(:,85), n3(:,277), t3x32(:,:,48))
  call prop_W_W(ntry, wf32(:,85), 79, MZ, 1_intkind1, wf32(:,86), n2(150))
  call prop_A_Q(ntry, wf16(:,46), 78, ZERO, 0_intkind1, wf16(:,186), n2(151))
  call vert_QA_Z(gZn,ntry, ex1(:), wf16(:,186), wf32(:,87), n3(:,278), t3x32(:,:,49))
  call prop_W_W(ntry, wf32(:,87), 79, MZ, 1_intkind1, wf32(:,88), n2(152))
  call vert_VQ_A(ntry, wf16(:,52), ex5(:), wf32(:,89), n3(:,279), t3x32(:,:,50))
  call prop_Q_A(ntry, wf32(:,89), 31, MB, 1_intkind1, wf32(:,90), n2(153))
  call vert_ZQ_A(gZd,ntry, wf16(:,174), ex5(:), wf32(:,91), n3(:,280), t3x32(:,:,51))
  call prop_Q_A(ntry, wf32(:,91), 31, MB, 1_intkind1, wf32(:,92), n2(154))
  call vert_AV_Q(ntry, ex6(:), wf16(:,52), wf32(:,93), n3(:,281), t3x32(:,:,52))
  call prop_A_Q(ntry, wf32(:,93), 47, MB, 1_intkind1, wf32(:,94), n2(155))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,174), wf32(:,95), n3(:,282), t3x32(:,:,53))
  call prop_A_Q(ntry, wf32(:,95), 47, MB, 1_intkind1, wf32(:,96), n2(156))
  call prop_Q_A(ntry, wf16(:,47), 71, ZERO, 0_intkind1, wf16(:,187), n2(157))
  call vert_QA_V(ntry, wf16(:,187), ex4(:), wf32(:,97), n3(:,283), t3x32(:,:,54))
  call vert_QA_Z(gZl,ntry, wf16(:,187), ex4(:), wf32(:,98), n3(:,284), t3x32(:,:,55))
  call prop_W_W(ntry, wf32(:,98), 79, MZ, 1_intkind1, wf32(:,99), n2(158))
  call vert_ZQ_A(gZd,ntry, wf16(:,175), ex5(:), wf32(:,100), n3(:,285), t3x32(:,:,56))
  call prop_Q_A(ntry, wf32(:,100), 31, MB, 1_intkind1, wf32(:,101), n2(159))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,175), wf32(:,102), n3(:,286), t3x32(:,:,57))
  call prop_A_Q(ntry, wf32(:,102), 47, MB, 1_intkind1, wf32(:,103), n2(160))
  call vert_WQ_A(ntry, wf8(:,42), ex1(:), wf16(:,188), n3(:,287), t3x16(:,:,145))
  call prop_Q_A(ntry, wf16(:,188), 71, ZERO, 0_intkind1, wf16(:,189), n2(161))
  call vert_QA_V(ntry, wf16(:,189), ex4(:), wf32(:,104), n3(:,288), t3x32(:,:,58))
  call vert_QA_Z(gZl,ntry, wf16(:,189), ex4(:), wf32(:,105), n3(:,289), t3x32(:,:,59))
  call prop_W_W(ntry, wf32(:,105), 79, MZ, 1_intkind1, wf32(:,106), n2(162))
  call vert_AW_Q(ntry, ex4(:), wf8(:,42), wf16(:,190), n3(:,290), t3x16(:,:,146))
  call prop_A_Q(ntry, wf16(:,190), 78, ZERO, 0_intkind1, wf16(:,191), n2(163))
  call vert_QA_Z(gZn,ntry, ex1(:), wf16(:,191), wf32(:,107), n3(:,291), t3x32(:,:,60))
  call prop_W_W(ntry, wf32(:,107), 79, MZ, 1_intkind1, wf32(:,108), n2(164))
  call vert_QA_V(ntry, wf4(:,18), wf8(:,56), wf32(:,109), n3(:,292), t3x32(:,:,61))
  call vert_QA_Z(gZl,ntry, wf4(:,18), wf8(:,56), wf32(:,110), n3(:,293), t3x32(:,:,62))
  call prop_W_W(ntry, wf32(:,110), 79, MZ, 1_intkind1, wf32(:,111), n2(165))
  call vert_VV_S(ntry, wf4(:,4), wf8(:,58), wf32(:,112), n3(:,294), t3x32(:,:,63))
  call vert_UV_W(ntry, wf4(:,4), 9, wf8(:,58), 70, wf32(:,113), n3(:,295), t3x32(:,:,64))
  call prop_W_W(ntry, wf32(:,113), 79, MZ, 1_intkind1, wf32(:,114), n2(166))
  call prop_Q_A(ntry, wf16(:,55), 77, ZERO, 0_intkind1, wf16(:,192), n2(167))
  call vert_QA_Z(gZn,ntry, wf16(:,192), ex2(:), wf32(:,115), n3(:,296), t3x32(:,:,65))
  call prop_W_W(ntry, wf32(:,115), 79, MZ, 1_intkind1, wf32(:,116), n2(168))
  call vert_VQ_A(ntry, wf16(:,61), ex5(:), wf32(:,117), n3(:,297), t3x32(:,:,66))
  call prop_Q_A(ntry, wf32(:,117), 31, MB, 1_intkind1, wf32(:,118), n2(169))
  call vert_ZQ_A(gZd,ntry, wf16(:,177), ex5(:), wf32(:,119), n3(:,298), t3x32(:,:,67))
  call prop_Q_A(ntry, wf32(:,119), 31, MB, 1_intkind1, wf32(:,120), n2(170))
  call vert_AV_Q(ntry, ex6(:), wf16(:,61), wf32(:,121), n3(:,299), t3x32(:,:,68))
  call prop_A_Q(ntry, wf32(:,121), 47, MB, 1_intkind1, wf32(:,122), n2(171))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,177), wf32(:,123), n3(:,300), t3x32(:,:,69))
  call prop_A_Q(ntry, wf32(:,123), 47, MB, 1_intkind1, wf32(:,124), n2(172))
  call prop_A_Q(ntry, wf16(:,56), 75, ZERO, 0_intkind1, wf16(:,193), n2(173))
  call vert_QA_V(ntry, ex3(:), wf16(:,193), wf32(:,125), n3(:,301), t3x32(:,:,70))
  call vert_QA_Z(gZl,ntry, ex3(:), wf16(:,193), wf32(:,126), n3(:,302), t3x32(:,:,71))
  call prop_W_W(ntry, wf32(:,126), 79, MZ, 1_intkind1, wf32(:,127), n2(174))
  call vert_ZQ_A(gZd,ntry, wf16(:,178), ex5(:), wf32(:,128), n3(:,303), t3x32(:,:,72))
  call prop_Q_A(ntry, wf32(:,128), 31, MB, 1_intkind1, wf32(:,129), n2(175))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,178), wf32(:,130), n3(:,304), t3x32(:,:,73))
  call prop_A_Q(ntry, wf32(:,130), 47, MB, 1_intkind1, wf32(:,131), n2(176))
  call vert_AW_Q(ntry, ex2(:), wf8(:,40), wf16(:,194), n3(:,305), t3x16(:,:,147))
  call prop_A_Q(ntry, wf16(:,194), 75, ZERO, 0_intkind1, wf16(:,195), n2(177))
  call vert_QA_V(ntry, ex3(:), wf16(:,195), wf32(:,132), n3(:,306), t3x32(:,:,74))
  call vert_QA_Z(gZl,ntry, ex3(:), wf16(:,195), wf32(:,133), n3(:,307), t3x32(:,:,75))
  call prop_W_W(ntry, wf32(:,133), 79, MZ, 1_intkind1, wf32(:,134), n2(178))
  call vert_WQ_A(ntry, wf8(:,40), ex3(:), wf16(:,196), n3(:,308), t3x16(:,:,148))
  call prop_Q_A(ntry, wf16(:,196), 77, ZERO, 0_intkind1, wf16(:,197), n2(179))
  call vert_QA_Z(gZn,ntry, wf16(:,197), ex2(:), wf32(:,135), n3(:,309), t3x32(:,:,76))
  call prop_W_W(ntry, wf32(:,135), 79, MZ, 1_intkind1, wf32(:,136), n2(180))
  call vert_ZQ_A(gZd,ntry, wf16(:,179), ex5(:), wf32(:,137), n3(:,310), t3x32(:,:,77))
  call prop_Q_A(ntry, wf32(:,137), 31, MB, 1_intkind1, wf32(:,138), n2(181))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,179), wf32(:,139), n3(:,311), t3x32(:,:,78))
  call prop_A_Q(ntry, wf32(:,139), 47, MB, 1_intkind1, wf32(:,140), n2(182))
  call vert_ZQ_A(gZd,ntry, wf16(:,180), ex5(:), wf32(:,141), n3(:,312), t3x32(:,:,79))
  call prop_Q_A(ntry, wf32(:,141), 31, MB, 1_intkind1, wf32(:,142), n2(183))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,180), wf32(:,143), n3(:,313), t3x32(:,:,80))
  call prop_A_Q(ntry, wf32(:,143), 47, MB, 1_intkind1, wf32(:,144), n2(184))
  call prop_Q_A(ntry, wf16(:,66), 71, ZERO, 0_intkind1, wf16(:,198), n2(185))
  call vert_QA_V(ntry, wf16(:,198), ex4(:), wf32(:,145), n3(:,314), t3x32(:,:,81))
  call vert_QA_Z(gZl,ntry, wf16(:,198), ex4(:), wf32(:,146), n3(:,315), t3x32(:,:,82))
  call prop_W_W(ntry, wf32(:,146), 79, MZ, 1_intkind1, wf32(:,147), n2(186))
  call vert_ZQ_A(gZn,ntry, wf8(:,18), ex1(:), wf16(:,199), n3(:,316), t3x16(:,:,149))
  call prop_Q_A(ntry, wf16(:,199), 77, ZERO, 0_intkind1, wf16(:,200), n2(187))
  call vert_QA_Z(gZn,ntry, wf16(:,200), ex2(:), wf32(:,148), n3(:,317), t3x32(:,:,83))
  call prop_W_W(ntry, wf32(:,148), 79, MZ, 1_intkind1, wf32(:,149), n2(188))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf8(:,18), wf16(:,201), n3(:,318), t3x16(:,:,150))
  call prop_A_Q(ntry, wf16(:,201), 78, ZERO, 0_intkind1, wf16(:,202), n2(189))
  call vert_QA_Z(gZn,ntry, ex1(:), wf16(:,202), wf32(:,150), n3(:,319), t3x32(:,:,84))
  call prop_W_W(ntry, wf32(:,150), 79, MZ, 1_intkind1, wf32(:,151), n2(190))
  call vert_AW_Q(ntry, ex4(:), wf8(:,58), wf16(:,203), n3(:,320), t3x16(:,:,151))
  call prop_A_Q(ntry, wf16(:,203), 78, ZERO, 0_intkind1, wf16(:,204), n2(191))
  call vert_QA_Z(gZn,ntry, ex1(:), wf16(:,204), wf32(:,152), n3(:,321), t3x32(:,:,85))
  call prop_W_W(ntry, wf32(:,152), 79, MZ, 1_intkind1, wf32(:,153), n2(192))
  call vert_ZQ_A(gZn,ntry, wf8(:,26), ex1(:), wf16(:,205), n3(:,322), t3x16(:,:,152))
  call prop_Q_A(ntry, wf16(:,205), 77, ZERO, 0_intkind1, wf16(:,206), n2(193))
  call vert_QA_Z(gZn,ntry, wf16(:,206), ex2(:), wf32(:,154), n3(:,323), t3x32(:,:,86))
  call prop_W_W(ntry, wf32(:,154), 79, MZ, 1_intkind1, wf32(:,155), n2(194))
  call prop_A_Q(ntry, wf16(:,69), 75, ZERO, 0_intkind1, wf16(:,207), n2(195))
  call vert_QA_V(ntry, ex3(:), wf16(:,207), wf32(:,156), n3(:,324), t3x32(:,:,87))
  call vert_QA_Z(gZl,ntry, ex3(:), wf16(:,207), wf32(:,157), n3(:,325), t3x32(:,:,88))
  call prop_W_W(ntry, wf32(:,157), 79, MZ, 1_intkind1, wf32(:,158), n2(196))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf8(:,26), wf16(:,208), n3(:,326), t3x16(:,:,153))
  call prop_A_Q(ntry, wf16(:,208), 78, ZERO, 0_intkind1, wf16(:,209), n2(197))
  call vert_QA_Z(gZn,ntry, ex1(:), wf16(:,209), wf32(:,159), n3(:,327), t3x32(:,:,89))
  call prop_W_W(ntry, wf32(:,159), 79, MZ, 1_intkind1, wf32(:,160), n2(198))
  call prop_Q_A(ntry, wf16(:,70), 77, ZERO, 0_intkind1, wf16(:,210), n2(199))
  call vert_QA_Z(gZn,ntry, wf16(:,210), ex2(:), wf32(:,161), n3(:,328), t3x32(:,:,90))
  call prop_W_W(ntry, wf32(:,161), 79, MZ, 1_intkind1, wf32(:,162), n2(200))


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  if (ntry < 2) then
    if(hel_mem_opt) hel_states = nhel
    call allocate_diagrams()
  end if

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do

#if -1 > 0 && 7 > 3
  if (loopcc) then
    !!Born-loop colour correlators interference
    
    M0M1_hel_cc(:,:,:)%j = 0
    M2ctcc = 0
    do n = 1, 14
      M2add_ct = 0
      m = ind_cc_comb(n)
        do k = 1, nhel
          call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
          call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
          M2ctcc(m) = M2ctcc(m) + M2add_ct
        end do
    end do
    M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
    M0M1_hel_cc(:,nhel+1:,:)%j = 0
  end if
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5,i6,i7
integer :: n

n=0

do i7= 1, 2
do i6= 1, 2
do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2) .OR. (ex7(i7)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf + ex7(i7)%hf
 end if
end do
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_VV(nsync, wf4(:,3), wf32(:,1), A(:,1), n3(:,329), t3x128(:,:,1), nhel, den(5))
    call Hcont_VV(nsync, wf32(:,1), wf4(:,7), A(:,2), n3(:,330), t3x128(:,:,2), nhel, den(7))
    call Hcont_QA(nsync, wf16(:,1), wf8(:,2), A(:,3), n3(:,331), t3x128(:,:,3), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,2), A(:,4), n3(:,332), t3x128(:,:,4), nhel, den(17))
    call Hcont_QA(nsync, wf16(:,3), wf8(:,4), A(:,5), n3(:,333), t3x128(:,:,5), nhel, den(21))
    call Hcont_QA(nsync, wf16(:,3), wf8(:,6), A(:,6), n3(:,334), t3x128(:,:,6), nhel, den(23))
    call Hcont_SS(nsync, wf8(:,7), wf16(:,4), A(:,7), n3(:,335), t3x128(:,:,7), nhel, den(27))
    call Hcont_QA(nsync, wf16(:,5), wf8(:,9), A(:,8), n3(:,336), t3x128(:,:,8), nhel, den(32))
    call Hcont_QA(nsync, wf8(:,9), wf16(:,6), A(:,9), n3(:,337), t3x128(:,:,9), nhel, den(34))
    call Hcont_QA(nsync, wf16(:,7), wf8(:,11), A(:,10), n3(:,338), t3x128(:,:,10), nhel, den(38))
    call Hcont_QA(nsync, wf16(:,7), wf8(:,13), A(:,11), n3(:,339), t3x128(:,:,11), nhel, den(40))
    call Hcont_SS(nsync, wf16(:,4), wf8(:,14), A(:,12), n3(:,340), t3x128(:,:,12), nhel, den(42))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,8), A(:,13), n3(:,341), t3x128(:,:,13), nhel, den(43))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,8), A(:,14), n3(:,342), t3x128(:,:,14), nhel, den(44))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,9), A(:,15), n3(:,343), t3x128(:,:,15), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,10), A(:,16), n3(:,344), t3x128(:,:,16), nhel, den(46))
    call Hcont_QA(nsync, wf16(:,11), wf8(:,16), A(:,17), n3(:,345), t3x128(:,:,17), nhel, den(51))
    call Hcont_QA(nsync, wf8(:,16), wf16(:,12), A(:,18), n3(:,346), t3x128(:,:,18), nhel, den(53))
    call Hcont_VV(nsync, wf16(:,13), wf8(:,18), A(:,19), n3(:,347), t3x128(:,:,19), nhel, den(58))
    call Hcont_QA(nsync, wf16(:,14), wf8(:,20), A(:,20), n3(:,348), t3x128(:,:,20), nhel, den(62))
    call Hcont_QA(nsync, wf16(:,14), wf8(:,22), A(:,21), n3(:,349), t3x128(:,:,21), nhel, den(64))
    call Hcont_QA(nsync, wf16(:,15), wf8(:,24), A(:,22), n3(:,350), t3x128(:,:,22), nhel, den(69))
    call Hcont_QA(nsync, wf8(:,24), wf16(:,16), A(:,23), n3(:,351), t3x128(:,:,23), nhel, den(71))
    call Hcont_VV(nsync, wf16(:,13), wf8(:,26), A(:,24), n3(:,352), t3x128(:,:,24), nhel, den(73))
    call Hcont_QA(nsync, wf16(:,17), wf8(:,28), A(:,25), n3(:,353), t3x128(:,:,25), nhel, den(77))
    call Hcont_QA(nsync, wf16(:,17), wf8(:,30), A(:,26), n3(:,354), t3x128(:,:,26), nhel, den(79))
    call Hcont_QA(nsync, wf8(:,20), wf16(:,18), A(:,27), n3(:,355), t3x128(:,:,27), nhel, den(80))
    call Hcont_QA(nsync, wf8(:,22), wf16(:,18), A(:,28), n3(:,356), t3x128(:,:,28), nhel, den(81))
    call Hcont_QA(nsync, wf8(:,16), wf16(:,19), A(:,29), n3(:,357), t3x128(:,:,29), nhel, den(82))
    call Hcont_QA(nsync, wf8(:,16), wf16(:,20), A(:,30), n3(:,358), t3x128(:,:,30), nhel, den(83))
    call Hcont_QA(nsync, wf8(:,9), wf16(:,21), A(:,31), n3(:,359), t3x128(:,:,31), nhel, den(86))
    call Hcont_QA(nsync, wf8(:,9), wf16(:,22), A(:,32), n3(:,360), t3x128(:,:,32), nhel, den(87))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,23), A(:,33), n3(:,361), t3x128(:,:,33), nhel, den(88))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,24), A(:,34), n3(:,362), t3x128(:,:,34), nhel, den(89))
    call Hcont_QA(nsync, wf8(:,9), wf16(:,25), A(:,35), n3(:,363), t3x128(:,:,35), nhel, den(91))
    call Hcont_QA(nsync, wf8(:,9), wf16(:,26), A(:,36), n3(:,364), t3x128(:,:,36), nhel, den(92))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,27), A(:,37), n3(:,365), t3x128(:,:,37), nhel, den(93))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,28), A(:,38), n3(:,366), t3x128(:,:,38), nhel, den(94))
    call Hcont_VV(nsync, wf8(:,33), wf16(:,29), A(:,39), n3(:,367), t3x128(:,:,39), nhel, den(97))
    call Hcont_VV(nsync, wf8(:,35), wf16(:,30), A(:,40), n3(:,368), t3x128(:,:,40), nhel, den(100))
    call Hcont_VV(nsync, wf8(:,33), wf16(:,31), A(:,41), n3(:,369), t3x128(:,:,41), nhel, den(101))
    call Hcont_VV(nsync, wf8(:,35), wf16(:,32), A(:,42), n3(:,370), t3x128(:,:,42), nhel, den(102))
    call Hcont_VV(nsync, wf16(:,29), wf8(:,36), A(:,43), n3(:,371), t3x128(:,:,43), nhel, den(104))
    call Hcont_VV(nsync, wf16(:,30), wf8(:,38), A(:,44), n3(:,372), t3x128(:,:,44), nhel, den(106))
    call Hcont_VV(nsync, wf16(:,31), wf8(:,36), A(:,45), n3(:,373), t3x128(:,:,45), nhel, den(107))
    call Hcont_VV(nsync, wf16(:,32), wf8(:,38), A(:,46), n3(:,374), t3x128(:,:,46), nhel, den(108))
    call Hcont_VV(nsync, wf16(:,33), wf8(:,40), A(:,47), n3(:,375), t3x128(:,:,47), nhel, den(112))
    call Hcont_VV(nsync, wf8(:,40), wf16(:,34), A(:,48), n3(:,376), t3x128(:,:,48), nhel, den(114))
    call Hcont_VV(nsync, wf8(:,40), wf16(:,35), A(:,49), n3(:,377), t3x128(:,:,49), nhel, den(116))
    call Hcont_VV(nsync, wf16(:,36), wf8(:,42), A(:,50), n3(:,378), t3x128(:,:,50), nhel, den(120))
    call Hcont_VV(nsync, wf8(:,42), wf16(:,37), A(:,51), n3(:,379), t3x128(:,:,51), nhel, den(122))
    call Hcont_VV(nsync, wf8(:,42), wf16(:,38), A(:,52), n3(:,380), t3x128(:,:,52), nhel, den(124))
    call Hcont_QA(nsync, wf16(:,39), wf8(:,44), A(:,53), n3(:,381), t3x128(:,:,53), nhel, den(128))
    call Hcont_SS(nsync, wf8(:,7), wf16(:,40), A(:,54), n3(:,382), t3x128(:,:,54), nhel, den(129))
    call Hcont_VV(nsync, wf8(:,33), wf16(:,41), A(:,55), n3(:,383), t3x128(:,:,55), nhel, den(130))
    call Hcont_VV(nsync, wf8(:,35), wf16(:,41), A(:,56), n3(:,384), t3x128(:,:,56), nhel, den(131))
    call Hcont_QA(nsync, wf16(:,42), wf8(:,46), A(:,57), n3(:,385), t3x128(:,:,57), nhel, den(135))
    call Hcont_SS(nsync, wf8(:,14), wf16(:,40), A(:,58), n3(:,386), t3x128(:,:,58), nhel, den(136))
    call Hcont_VV(nsync, wf8(:,36), wf16(:,41), A(:,59), n3(:,387), t3x128(:,:,59), nhel, den(137))
    call Hcont_VV(nsync, wf8(:,38), wf16(:,41), A(:,60), n3(:,388), t3x128(:,:,60), nhel, den(138))
    call Hcont_QA(nsync, wf8(:,44), wf16(:,43), A(:,61), n3(:,389), t3x128(:,:,61), nhel, den(139))
    call Hcont_VV(nsync, wf8(:,42), wf16(:,44), A(:,62), n3(:,390), t3x128(:,:,62), nhel, den(140))
    call Hcont_VV(nsync, wf8(:,40), wf16(:,45), A(:,63), n3(:,391), t3x128(:,:,63), nhel, den(141))
    call Hcont_QA(nsync, wf16(:,15), wf8(:,48), A(:,64), n3(:,392), t3x128(:,:,64), nhel, den(143))
    call Hcont_QA(nsync, wf16(:,16), wf8(:,48), A(:,65), n3(:,393), t3x128(:,:,65), nhel, den(144))
    call Hcont_VV(nsync, wf16(:,33), wf8(:,50), A(:,66), n3(:,394), t3x128(:,:,66), nhel, den(146))
    call Hcont_VV(nsync, wf16(:,34), wf8(:,50), A(:,67), n3(:,395), t3x128(:,:,67), nhel, den(147))
    call Hcont_VV(nsync, wf16(:,35), wf8(:,50), A(:,68), n3(:,396), t3x128(:,:,68), nhel, den(148))
    call Hcont_QA(nsync, wf16(:,46), wf8(:,52), A(:,69), n3(:,397), t3x128(:,:,69), nhel, den(152))
    call Hcont_QA(nsync, wf8(:,20), wf16(:,47), A(:,70), n3(:,398), t3x128(:,:,70), nhel, den(153))
    call Hcont_QA(nsync, wf8(:,22), wf16(:,47), A(:,71), n3(:,399), t3x128(:,:,71), nhel, den(154))
    call Hcont_VV(nsync, wf8(:,42), wf16(:,48), A(:,72), n3(:,400), t3x128(:,:,72), nhel, den(155))
    call Hcont_VV(nsync, wf8(:,42), wf16(:,49), A(:,73), n3(:,401), t3x128(:,:,73), nhel, den(156))
    call Hcont_VV(nsync, wf8(:,42), wf16(:,50), A(:,74), n3(:,402), t3x128(:,:,74), nhel, den(157))
    call Hcont_QA(nsync, wf8(:,44), wf16(:,51), A(:,75), n3(:,403), t3x128(:,:,75), nhel, den(158))
    call Hcont_VV(nsync, wf8(:,33), wf16(:,52), A(:,76), n3(:,404), t3x128(:,:,76), nhel, den(159))
    call Hcont_VV(nsync, wf8(:,35), wf16(:,53), A(:,77), n3(:,405), t3x128(:,:,77), nhel, den(160))
    call Hcont_VV(nsync, wf8(:,35), wf16(:,54), A(:,78), n3(:,406), t3x128(:,:,78), nhel, den(163))
    call Hcont_VV(nsync, wf8(:,36), wf16(:,52), A(:,79), n3(:,407), t3x128(:,:,79), nhel, den(164))
    call Hcont_VV(nsync, wf8(:,38), wf16(:,53), A(:,80), n3(:,408), t3x128(:,:,80), nhel, den(165))
    call Hcont_VV(nsync, wf8(:,38), wf16(:,54), A(:,81), n3(:,409), t3x128(:,:,81), nhel, den(166))
    call Hcont_QA(nsync, wf16(:,11), wf8(:,56), A(:,82), n3(:,410), t3x128(:,:,82), nhel, den(168))
    call Hcont_QA(nsync, wf16(:,12), wf8(:,56), A(:,83), n3(:,411), t3x128(:,:,83), nhel, den(169))
    call Hcont_VV(nsync, wf16(:,36), wf8(:,58), A(:,84), n3(:,412), t3x128(:,:,84), nhel, den(171))
    call Hcont_VV(nsync, wf16(:,37), wf8(:,58), A(:,85), n3(:,413), t3x128(:,:,85), nhel, den(172))
    call Hcont_VV(nsync, wf16(:,38), wf8(:,58), A(:,86), n3(:,414), t3x128(:,:,86), nhel, den(173))
    call Hcont_QA(nsync, wf16(:,55), wf8(:,60), A(:,87), n3(:,415), t3x128(:,:,87), nhel, den(177))
    call Hcont_QA(nsync, wf8(:,28), wf16(:,56), A(:,88), n3(:,416), t3x128(:,:,88), nhel, den(178))
    call Hcont_QA(nsync, wf8(:,30), wf16(:,56), A(:,89), n3(:,417), t3x128(:,:,89), nhel, den(179))
    call Hcont_VV(nsync, wf8(:,40), wf16(:,57), A(:,90), n3(:,418), t3x128(:,:,90), nhel, den(180))
    call Hcont_VV(nsync, wf8(:,40), wf16(:,58), A(:,91), n3(:,419), t3x128(:,:,91), nhel, den(181))
    call Hcont_VV(nsync, wf8(:,40), wf16(:,59), A(:,92), n3(:,420), t3x128(:,:,92), nhel, den(182))
    call Hcont_QA(nsync, wf8(:,46), wf16(:,60), A(:,93), n3(:,421), t3x128(:,:,93), nhel, den(183))
    call Hcont_VV(nsync, wf8(:,33), wf16(:,61), A(:,94), n3(:,422), t3x128(:,:,94), nhel, den(184))
    call Hcont_VV(nsync, wf8(:,35), wf16(:,62), A(:,95), n3(:,423), t3x128(:,:,95), nhel, den(185))
    call Hcont_VV(nsync, wf8(:,35), wf16(:,63), A(:,96), n3(:,424), t3x128(:,:,96), nhel, den(188))
    call Hcont_VV(nsync, wf8(:,36), wf16(:,61), A(:,97), n3(:,425), t3x128(:,:,97), nhel, den(189))
    call Hcont_VV(nsync, wf8(:,38), wf16(:,62), A(:,98), n3(:,426), t3x128(:,:,98), nhel, den(190))
    call Hcont_VV(nsync, wf8(:,38), wf16(:,63), A(:,99), n3(:,427), t3x128(:,:,99), nhel, den(191))
    call Hcont_VV(nsync, wf8(:,35), wf16(:,64), A(:,100), n3(:,428), t3x128(:,:,100), nhel, den(193))
    call Hcont_VV(nsync, wf8(:,35), wf16(:,65), A(:,101), n3(:,429), t3x128(:,:,101), nhel, den(195))
    call Hcont_VV(nsync, wf8(:,38), wf16(:,64), A(:,102), n3(:,430), t3x128(:,:,102), nhel, den(196))
    call Hcont_VV(nsync, wf8(:,38), wf16(:,65), A(:,103), n3(:,431), t3x128(:,:,103), nhel, den(197))
    call Hcont_QA(nsync, wf8(:,20), wf16(:,66), A(:,104), n3(:,432), t3x128(:,:,104), nhel, den(198))
    call Hcont_QA(nsync, wf8(:,22), wf16(:,66), A(:,105), n3(:,433), t3x128(:,:,105), nhel, den(199))
    call Hcont_VV(nsync, wf8(:,18), wf16(:,67), A(:,106), n3(:,434), t3x128(:,:,106), nhel, den(200))
    call Hcont_VV(nsync, wf8(:,18), wf16(:,68), A(:,107), n3(:,435), t3x128(:,:,107), nhel, den(201))
    call Hcont_VV(nsync, wf16(:,48), wf8(:,58), A(:,108), n3(:,436), t3x128(:,:,108), nhel, den(202))
    call Hcont_VV(nsync, wf8(:,26), wf16(:,67), A(:,109), n3(:,437), t3x128(:,:,109), nhel, den(203))
    call Hcont_QA(nsync, wf8(:,28), wf16(:,69), A(:,110), n3(:,438), t3x128(:,:,110), nhel, den(204))
    call Hcont_QA(nsync, wf8(:,30), wf16(:,69), A(:,111), n3(:,439), t3x128(:,:,111), nhel, den(205))
    call Hcont_VV(nsync, wf8(:,26), wf16(:,68), A(:,112), n3(:,440), t3x128(:,:,112), nhel, den(206))
    call Hcont_QA(nsync, wf8(:,60), wf16(:,70), A(:,113), n3(:,441), t3x128(:,:,113), nhel, den(207))

    call Hcont_VV(nsync, wf32(:,1), wf4(:,22), A(:,114), n3(:,442), t3x128(:,:,114), nhel, den(5))
    call Hcont_VV(nsync, wf32(:,1), wf4(:,24), A(:,115), n3(:,443), t3x128(:,:,115), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,71), A(:,116), n3(:,444), t3x128(:,:,116), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,72), A(:,117), n3(:,445), t3x128(:,:,117), nhel, den(17))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,73), A(:,118), n3(:,446), t3x128(:,:,118), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,73), A(:,119), n3(:,447), t3x128(:,:,119), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,9), wf16(:,74), A(:,120), n3(:,448), t3x128(:,:,120), nhel, den(32))
    call Hcont_QA(nsync, wf8(:,9), wf16(:,75), A(:,121), n3(:,449), t3x128(:,:,121), nhel, den(34))
    call Hcont_QA(nsync, wf8(:,11), wf16(:,76), A(:,122), n3(:,450), t3x128(:,:,122), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,13), wf16(:,76), A(:,123), n3(:,451), t3x128(:,:,123), nhel, den(40))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,77), A(:,124), n3(:,452), t3x128(:,:,124), nhel, den(43))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,77), A(:,125), n3(:,453), t3x128(:,:,125), nhel, den(44))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,78), A(:,126), n3(:,454), t3x128(:,:,126), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,79), A(:,127), n3(:,455), t3x128(:,:,127), nhel, den(46))
    call Hcont_SS(nsync, wf16(:,4), wf8(:,67), A(:,128), n3(:,456), t3x128(:,:,128), nhel, den(210))
    call Hcont_QA(nsync, wf8(:,68), wf16(:,80), A(:,129), n3(:,457), t3x128(:,:,129), nhel, den(213))
    call Hcont_QA(nsync, wf16(:,80), wf8(:,69), A(:,130), n3(:,458), t3x128(:,:,130), nhel, den(214))
    call Hcont_QA(nsync, wf8(:,70), wf16(:,81), A(:,131), n3(:,459), t3x128(:,:,131), nhel, den(217))
    call Hcont_QA(nsync, wf8(:,70), wf16(:,82), A(:,132), n3(:,460), t3x128(:,:,132), nhel, den(219))
    call Hcont_QA(nsync, wf16(:,8), wf8(:,71), A(:,133), n3(:,461), t3x128(:,:,133), nhel, den(43))
    call Hcont_QA(nsync, wf16(:,8), wf8(:,72), A(:,134), n3(:,462), t3x128(:,:,134), nhel, den(44))
    call Hcont_QA(nsync, wf16(:,9), wf8(:,73), A(:,135), n3(:,463), t3x128(:,:,135), nhel, den(45))
    call Hcont_QA(nsync, wf16(:,10), wf8(:,73), A(:,136), n3(:,464), t3x128(:,:,136), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,9), wf16(:,83), A(:,137), n3(:,465), t3x128(:,:,137), nhel, den(32))
    call Hcont_QA(nsync, wf8(:,9), wf16(:,84), A(:,138), n3(:,466), t3x128(:,:,138), nhel, den(34))
    call Hcont_QA(nsync, wf8(:,11), wf16(:,85), A(:,139), n3(:,467), t3x128(:,:,139), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,13), wf16(:,85), A(:,140), n3(:,468), t3x128(:,:,140), nhel, den(40))
    call Hcont_SS(nsync, wf16(:,4), wf8(:,74), A(:,141), n3(:,469), t3x128(:,:,141), nhel, den(42))
    call Hcont_SS(nsync, wf16(:,4), wf8(:,75), A(:,142), n3(:,470), t3x128(:,:,142), nhel, den(220))
    call Hcont_QA(nsync, wf8(:,76), wf16(:,86), A(:,143), n3(:,471), t3x128(:,:,143), nhel, den(223))
    call Hcont_QA(nsync, wf16(:,86), wf8(:,77), A(:,144), n3(:,472), t3x128(:,:,144), nhel, den(224))
    call Hcont_QA(nsync, wf8(:,78), wf16(:,87), A(:,145), n3(:,473), t3x128(:,:,145), nhel, den(227))
    call Hcont_QA(nsync, wf8(:,78), wf16(:,88), A(:,146), n3(:,474), t3x128(:,:,146), nhel, den(229))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,89), A(:,147), n3(:,475), t3x128(:,:,147), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,90), A(:,148), n3(:,476), t3x128(:,:,148), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,91), A(:,149), n3(:,477), t3x128(:,:,149), nhel, den(43))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,91), A(:,150), n3(:,478), t3x128(:,:,150), nhel, den(44))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,92), A(:,151), n3(:,479), t3x128(:,:,151), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,93), A(:,152), n3(:,480), t3x128(:,:,152), nhel, den(17))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,94), A(:,153), n3(:,481), t3x128(:,:,153), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,94), A(:,154), n3(:,482), t3x128(:,:,154), nhel, den(23))
    call Hcont_SS(nsync, wf16(:,4), wf8(:,82), A(:,155), n3(:,483), t3x128(:,:,155), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,9), wf16(:,95), A(:,156), n3(:,484), t3x128(:,:,156), nhel, den(86))
    call Hcont_QA(nsync, wf8(:,9), wf16(:,96), A(:,157), n3(:,485), t3x128(:,:,157), nhel, den(87))
    call Hcont_QA(nsync, wf16(:,23), wf8(:,73), A(:,158), n3(:,486), t3x128(:,:,158), nhel, den(88))
    call Hcont_QA(nsync, wf16(:,24), wf8(:,73), A(:,159), n3(:,487), t3x128(:,:,159), nhel, den(89))
    call Hcont_QA(nsync, wf8(:,9), wf16(:,97), A(:,160), n3(:,488), t3x128(:,:,160), nhel, den(91))
    call Hcont_QA(nsync, wf8(:,9), wf16(:,98), A(:,161), n3(:,489), t3x128(:,:,161), nhel, den(92))
    call Hcont_QA(nsync, wf16(:,27), wf8(:,73), A(:,162), n3(:,490), t3x128(:,:,162), nhel, den(93))
    call Hcont_QA(nsync, wf16(:,28), wf8(:,73), A(:,163), n3(:,491), t3x128(:,:,163), nhel, den(94))
    call Hcont_VV(nsync, wf16(:,29), wf8(:,83), A(:,164), n3(:,492), t3x128(:,:,164), nhel, den(97))
    call Hcont_VV(nsync, wf16(:,30), wf8(:,85), A(:,165), n3(:,493), t3x128(:,:,165), nhel, den(100))
    call Hcont_VV(nsync, wf16(:,31), wf8(:,83), A(:,166), n3(:,494), t3x128(:,:,166), nhel, den(101))
    call Hcont_VV(nsync, wf16(:,32), wf8(:,85), A(:,167), n3(:,495), t3x128(:,:,167), nhel, den(102))
    call Hcont_VV(nsync, wf16(:,29), wf8(:,86), A(:,168), n3(:,496), t3x128(:,:,168), nhel, den(104))
    call Hcont_VV(nsync, wf16(:,30), wf8(:,88), A(:,169), n3(:,497), t3x128(:,:,169), nhel, den(106))
    call Hcont_VV(nsync, wf16(:,31), wf8(:,86), A(:,170), n3(:,498), t3x128(:,:,170), nhel, den(107))
    call Hcont_VV(nsync, wf16(:,32), wf8(:,88), A(:,171), n3(:,499), t3x128(:,:,171), nhel, den(108))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,99), A(:,172), n3(:,500), t3x128(:,:,172), nhel, den(88))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,100), A(:,173), n3(:,501), t3x128(:,:,173), nhel, den(89))
    call Hcont_QA(nsync, wf16(:,21), wf8(:,81), A(:,174), n3(:,502), t3x128(:,:,174), nhel, den(86))
    call Hcont_QA(nsync, wf16(:,22), wf8(:,81), A(:,175), n3(:,503), t3x128(:,:,175), nhel, den(87))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,101), A(:,176), n3(:,504), t3x128(:,:,176), nhel, den(93))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,102), A(:,177), n3(:,505), t3x128(:,:,177), nhel, den(94))
    call Hcont_QA(nsync, wf16(:,25), wf8(:,81), A(:,178), n3(:,506), t3x128(:,:,178), nhel, den(91))
    call Hcont_QA(nsync, wf16(:,26), wf8(:,81), A(:,179), n3(:,507), t3x128(:,:,179), nhel, den(92))
    call Hcont_VV(nsync, wf16(:,29), wf8(:,89), A(:,180), n3(:,508), t3x128(:,:,180), nhel, den(104))
    call Hcont_VV(nsync, wf16(:,30), wf8(:,91), A(:,181), n3(:,509), t3x128(:,:,181), nhel, den(106))
    call Hcont_VV(nsync, wf16(:,31), wf8(:,89), A(:,182), n3(:,510), t3x128(:,:,182), nhel, den(107))
    call Hcont_VV(nsync, wf16(:,32), wf8(:,91), A(:,183), n3(:,511), t3x128(:,:,183), nhel, den(108))
    call Hcont_VV(nsync, wf16(:,29), wf8(:,92), A(:,184), n3(:,512), t3x128(:,:,184), nhel, den(97))
    call Hcont_VV(nsync, wf16(:,30), wf8(:,94), A(:,185), n3(:,513), t3x128(:,:,185), nhel, den(100))
    call Hcont_VV(nsync, wf16(:,31), wf8(:,92), A(:,186), n3(:,514), t3x128(:,:,186), nhel, den(101))
    call Hcont_VV(nsync, wf16(:,32), wf8(:,94), A(:,187), n3(:,515), t3x128(:,:,187), nhel, den(102))
    call Hcont_QA(nsync, wf8(:,16), wf16(:,103), A(:,188), n3(:,516), t3x128(:,:,188), nhel, den(51))
    call Hcont_QA(nsync, wf8(:,16), wf16(:,104), A(:,189), n3(:,517), t3x128(:,:,189), nhel, den(53))
    call Hcont_VV(nsync, wf8(:,18), wf16(:,105), A(:,190), n3(:,518), t3x128(:,:,190), nhel, den(58))
    call Hcont_QA(nsync, wf16(:,14), wf8(:,96), A(:,191), n3(:,519), t3x128(:,:,191), nhel, den(62))
    call Hcont_QA(nsync, wf16(:,14), wf8(:,98), A(:,192), n3(:,520), t3x128(:,:,192), nhel, den(64))
    call Hcont_QA(nsync, wf8(:,24), wf16(:,106), A(:,193), n3(:,521), t3x128(:,:,193), nhel, den(69))
    call Hcont_QA(nsync, wf8(:,24), wf16(:,107), A(:,194), n3(:,522), t3x128(:,:,194), nhel, den(71))
    call Hcont_VV(nsync, wf8(:,26), wf16(:,105), A(:,195), n3(:,523), t3x128(:,:,195), nhel, den(73))
    call Hcont_QA(nsync, wf16(:,17), wf8(:,100), A(:,196), n3(:,524), t3x128(:,:,196), nhel, den(77))
    call Hcont_QA(nsync, wf16(:,17), wf8(:,102), A(:,197), n3(:,525), t3x128(:,:,197), nhel, den(79))
    call Hcont_QA(nsync, wf16(:,18), wf8(:,96), A(:,198), n3(:,526), t3x128(:,:,198), nhel, den(80))
    call Hcont_QA(nsync, wf16(:,18), wf8(:,98), A(:,199), n3(:,527), t3x128(:,:,199), nhel, den(81))
    call Hcont_QA(nsync, wf8(:,16), wf16(:,108), A(:,200), n3(:,528), t3x128(:,:,200), nhel, den(82))
    call Hcont_QA(nsync, wf8(:,16), wf16(:,109), A(:,201), n3(:,529), t3x128(:,:,201), nhel, den(83))
    call Hcont_QA(nsync, wf8(:,44), wf16(:,110), A(:,202), n3(:,530), t3x128(:,:,202), nhel, den(128))
    call Hcont_QA(nsync, wf8(:,46), wf16(:,111), A(:,203), n3(:,531), t3x128(:,:,203), nhel, den(135))
    call Hcont_QA(nsync, wf8(:,44), wf16(:,112), A(:,204), n3(:,532), t3x128(:,:,204), nhel, den(139))
    call Hcont_SS(nsync, wf16(:,40), wf8(:,67), A(:,205), n3(:,533), t3x128(:,:,205), nhel, den(231))
    call Hcont_VV(nsync, wf16(:,41), wf8(:,83), A(:,206), n3(:,534), t3x128(:,:,206), nhel, den(234))
    call Hcont_VV(nsync, wf8(:,84), wf16(:,113), A(:,207), n3(:,535), t3x128(:,:,207), nhel, den(237))
    call Hcont_QA(nsync, wf8(:,103), wf16(:,114), A(:,208), n3(:,536), t3x128(:,:,208), nhel, den(240))
    call Hcont_VV(nsync, wf8(:,42), wf16(:,115), A(:,209), n3(:,537), t3x128(:,:,209), nhel, den(140))
    call Hcont_QA(nsync, wf16(:,43), wf8(:,104), A(:,210), n3(:,538), t3x128(:,:,210), nhel, den(139))
    call Hcont_VV(nsync, wf8(:,40), wf16(:,116), A(:,211), n3(:,539), t3x128(:,:,211), nhel, den(141))
    call Hcont_QA(nsync, wf8(:,46), wf16(:,117), A(:,212), n3(:,540), t3x128(:,:,212), nhel, den(135))
    call Hcont_SS(nsync, wf16(:,40), wf8(:,74), A(:,213), n3(:,541), t3x128(:,:,213), nhel, den(136))
    call Hcont_VV(nsync, wf16(:,41), wf8(:,86), A(:,214), n3(:,542), t3x128(:,:,214), nhel, den(137))
    call Hcont_VV(nsync, wf16(:,41), wf8(:,88), A(:,215), n3(:,543), t3x128(:,:,215), nhel, den(138))
    call Hcont_SS(nsync, wf16(:,40), wf8(:,75), A(:,216), n3(:,544), t3x128(:,:,216), nhel, den(241))
    call Hcont_VV(nsync, wf16(:,41), wf8(:,89), A(:,217), n3(:,545), t3x128(:,:,217), nhel, den(242))
    call Hcont_VV(nsync, wf8(:,90), wf16(:,113), A(:,218), n3(:,546), t3x128(:,:,218), nhel, den(243))
    call Hcont_QA(nsync, wf8(:,105), wf16(:,118), A(:,219), n3(:,547), t3x128(:,:,219), nhel, den(246))
    call Hcont_VV(nsync, wf8(:,40), wf16(:,119), A(:,220), n3(:,548), t3x128(:,:,220), nhel, den(141))
    call Hcont_QA(nsync, wf8(:,44), wf16(:,120), A(:,221), n3(:,549), t3x128(:,:,221), nhel, den(139))
    call Hcont_VV(nsync, wf8(:,42), wf16(:,121), A(:,222), n3(:,550), t3x128(:,:,222), nhel, den(140))
    call Hcont_QA(nsync, wf8(:,44), wf16(:,122), A(:,223), n3(:,551), t3x128(:,:,223), nhel, den(128))
    call Hcont_SS(nsync, wf16(:,40), wf8(:,82), A(:,224), n3(:,552), t3x128(:,:,224), nhel, den(129))
    call Hcont_VV(nsync, wf16(:,41), wf8(:,92), A(:,225), n3(:,553), t3x128(:,:,225), nhel, den(130))
    call Hcont_VV(nsync, wf16(:,41), wf8(:,94), A(:,226), n3(:,554), t3x128(:,:,226), nhel, den(131))
    call Hcont_VV(nsync, wf8(:,40), wf16(:,123), A(:,227), n3(:,555), t3x128(:,:,227), nhel, den(112))
    call Hcont_VV(nsync, wf8(:,40), wf16(:,124), A(:,228), n3(:,556), t3x128(:,:,228), nhel, den(114))
    call Hcont_VV(nsync, wf8(:,40), wf16(:,125), A(:,229), n3(:,557), t3x128(:,:,229), nhel, den(116))
    call Hcont_VV(nsync, wf8(:,42), wf16(:,126), A(:,230), n3(:,558), t3x128(:,:,230), nhel, den(120))
    call Hcont_VV(nsync, wf8(:,42), wf16(:,127), A(:,231), n3(:,559), t3x128(:,:,231), nhel, den(122))
    call Hcont_VV(nsync, wf8(:,42), wf16(:,128), A(:,232), n3(:,560), t3x128(:,:,232), nhel, den(124))
    call Hcont_QA(nsync, wf16(:,51), wf8(:,104), A(:,233), n3(:,561), t3x128(:,:,233), nhel, den(158))
    call Hcont_VV(nsync, wf16(:,52), wf8(:,83), A(:,234), n3(:,562), t3x128(:,:,234), nhel, den(159))
    call Hcont_VV(nsync, wf16(:,53), wf8(:,85), A(:,235), n3(:,563), t3x128(:,:,235), nhel, den(160))
    call Hcont_VV(nsync, wf16(:,54), wf8(:,85), A(:,236), n3(:,564), t3x128(:,:,236), nhel, den(163))
    call Hcont_VV(nsync, wf16(:,52), wf8(:,86), A(:,237), n3(:,565), t3x128(:,:,237), nhel, den(164))
    call Hcont_VV(nsync, wf16(:,53), wf8(:,88), A(:,238), n3(:,566), t3x128(:,:,238), nhel, den(165))
    call Hcont_VV(nsync, wf16(:,54), wf8(:,88), A(:,239), n3(:,567), t3x128(:,:,239), nhel, den(166))
    call Hcont_QA(nsync, wf8(:,44), wf16(:,129), A(:,240), n3(:,568), t3x128(:,:,240), nhel, den(158))
    call Hcont_VV(nsync, wf16(:,52), wf8(:,89), A(:,241), n3(:,569), t3x128(:,:,241), nhel, den(164))
    call Hcont_VV(nsync, wf16(:,53), wf8(:,91), A(:,242), n3(:,570), t3x128(:,:,242), nhel, den(165))
    call Hcont_VV(nsync, wf16(:,54), wf8(:,91), A(:,243), n3(:,571), t3x128(:,:,243), nhel, den(166))
    call Hcont_VV(nsync, wf16(:,52), wf8(:,92), A(:,244), n3(:,572), t3x128(:,:,244), nhel, den(159))
    call Hcont_VV(nsync, wf16(:,53), wf8(:,94), A(:,245), n3(:,573), t3x128(:,:,245), nhel, den(160))
    call Hcont_VV(nsync, wf16(:,54), wf8(:,94), A(:,246), n3(:,574), t3x128(:,:,246), nhel, den(163))
    call Hcont_QA(nsync, wf8(:,48), wf16(:,106), A(:,247), n3(:,575), t3x128(:,:,247), nhel, den(143))
    call Hcont_QA(nsync, wf8(:,48), wf16(:,107), A(:,248), n3(:,576), t3x128(:,:,248), nhel, den(144))
    call Hcont_VV(nsync, wf8(:,50), wf16(:,123), A(:,249), n3(:,577), t3x128(:,:,249), nhel, den(146))
    call Hcont_VV(nsync, wf8(:,50), wf16(:,124), A(:,250), n3(:,578), t3x128(:,:,250), nhel, den(147))
    call Hcont_VV(nsync, wf8(:,50), wf16(:,125), A(:,251), n3(:,579), t3x128(:,:,251), nhel, den(148))
    call Hcont_QA(nsync, wf16(:,46), wf8(:,108), A(:,252), n3(:,580), t3x128(:,:,252), nhel, den(152))
    call Hcont_QA(nsync, wf16(:,47), wf8(:,96), A(:,253), n3(:,581), t3x128(:,:,253), nhel, den(153))
    call Hcont_QA(nsync, wf16(:,47), wf8(:,98), A(:,254), n3(:,582), t3x128(:,:,254), nhel, den(154))
    call Hcont_VV(nsync, wf8(:,42), wf16(:,130), A(:,255), n3(:,583), t3x128(:,:,255), nhel, den(156))
    call Hcont_VV(nsync, wf8(:,42), wf16(:,131), A(:,256), n3(:,584), t3x128(:,:,256), nhel, den(157))
    call Hcont_VV(nsync, wf8(:,42), wf16(:,132), A(:,257), n3(:,585), t3x128(:,:,257), nhel, den(155))
    call Hcont_QA(nsync, wf8(:,46), wf16(:,133), A(:,258), n3(:,586), t3x128(:,:,258), nhel, den(183))
    call Hcont_VV(nsync, wf16(:,61), wf8(:,83), A(:,259), n3(:,587), t3x128(:,:,259), nhel, den(184))
    call Hcont_VV(nsync, wf16(:,62), wf8(:,85), A(:,260), n3(:,588), t3x128(:,:,260), nhel, den(185))
    call Hcont_VV(nsync, wf16(:,63), wf8(:,85), A(:,261), n3(:,589), t3x128(:,:,261), nhel, den(188))
    call Hcont_VV(nsync, wf16(:,61), wf8(:,86), A(:,262), n3(:,590), t3x128(:,:,262), nhel, den(189))
    call Hcont_VV(nsync, wf16(:,62), wf8(:,88), A(:,263), n3(:,591), t3x128(:,:,263), nhel, den(190))
    call Hcont_VV(nsync, wf16(:,63), wf8(:,88), A(:,264), n3(:,592), t3x128(:,:,264), nhel, den(191))
    call Hcont_QA(nsync, wf16(:,60), wf8(:,106), A(:,265), n3(:,593), t3x128(:,:,265), nhel, den(183))
    call Hcont_VV(nsync, wf16(:,61), wf8(:,89), A(:,266), n3(:,594), t3x128(:,:,266), nhel, den(189))
    call Hcont_VV(nsync, wf16(:,62), wf8(:,91), A(:,267), n3(:,595), t3x128(:,:,267), nhel, den(190))
    call Hcont_VV(nsync, wf16(:,63), wf8(:,91), A(:,268), n3(:,596), t3x128(:,:,268), nhel, den(191))
    call Hcont_VV(nsync, wf16(:,61), wf8(:,92), A(:,269), n3(:,597), t3x128(:,:,269), nhel, den(184))
    call Hcont_VV(nsync, wf16(:,62), wf8(:,94), A(:,270), n3(:,598), t3x128(:,:,270), nhel, den(185))
    call Hcont_VV(nsync, wf16(:,63), wf8(:,94), A(:,271), n3(:,599), t3x128(:,:,271), nhel, den(188))
    call Hcont_QA(nsync, wf8(:,56), wf16(:,103), A(:,272), n3(:,600), t3x128(:,:,272), nhel, den(168))
    call Hcont_QA(nsync, wf8(:,56), wf16(:,104), A(:,273), n3(:,601), t3x128(:,:,273), nhel, den(169))
    call Hcont_VV(nsync, wf8(:,58), wf16(:,126), A(:,274), n3(:,602), t3x128(:,:,274), nhel, den(171))
    call Hcont_VV(nsync, wf8(:,58), wf16(:,127), A(:,275), n3(:,603), t3x128(:,:,275), nhel, den(172))
    call Hcont_VV(nsync, wf8(:,58), wf16(:,128), A(:,276), n3(:,604), t3x128(:,:,276), nhel, den(173))
    call Hcont_QA(nsync, wf16(:,55), wf8(:,110), A(:,277), n3(:,605), t3x128(:,:,277), nhel, den(177))
    call Hcont_QA(nsync, wf16(:,56), wf8(:,100), A(:,278), n3(:,606), t3x128(:,:,278), nhel, den(178))
    call Hcont_QA(nsync, wf16(:,56), wf8(:,102), A(:,279), n3(:,607), t3x128(:,:,279), nhel, den(179))
    call Hcont_VV(nsync, wf8(:,40), wf16(:,134), A(:,280), n3(:,608), t3x128(:,:,280), nhel, den(181))
    call Hcont_VV(nsync, wf8(:,40), wf16(:,135), A(:,281), n3(:,609), t3x128(:,:,281), nhel, den(182))
    call Hcont_VV(nsync, wf8(:,40), wf16(:,136), A(:,282), n3(:,610), t3x128(:,:,282), nhel, den(180))
    call Hcont_VV(nsync, wf16(:,64), wf8(:,85), A(:,283), n3(:,611), t3x128(:,:,283), nhel, den(193))
    call Hcont_VV(nsync, wf16(:,65), wf8(:,85), A(:,284), n3(:,612), t3x128(:,:,284), nhel, den(195))
    call Hcont_VV(nsync, wf16(:,64), wf8(:,88), A(:,285), n3(:,613), t3x128(:,:,285), nhel, den(196))
    call Hcont_VV(nsync, wf16(:,65), wf8(:,88), A(:,286), n3(:,614), t3x128(:,:,286), nhel, den(197))
    call Hcont_VV(nsync, wf16(:,64), wf8(:,91), A(:,287), n3(:,615), t3x128(:,:,287), nhel, den(196))
    call Hcont_VV(nsync, wf16(:,65), wf8(:,91), A(:,288), n3(:,616), t3x128(:,:,288), nhel, den(197))
    call Hcont_VV(nsync, wf16(:,64), wf8(:,94), A(:,289), n3(:,617), t3x128(:,:,289), nhel, den(193))
    call Hcont_VV(nsync, wf16(:,65), wf8(:,94), A(:,290), n3(:,618), t3x128(:,:,290), nhel, den(195))
    call Hcont_QA(nsync, wf16(:,66), wf8(:,96), A(:,291), n3(:,619), t3x128(:,:,291), nhel, den(198))
    call Hcont_QA(nsync, wf16(:,66), wf8(:,98), A(:,292), n3(:,620), t3x128(:,:,292), nhel, den(199))
    call Hcont_VV(nsync, wf8(:,18), wf16(:,137), A(:,293), n3(:,621), t3x128(:,:,293), nhel, den(200))
    call Hcont_VV(nsync, wf8(:,18), wf16(:,138), A(:,294), n3(:,622), t3x128(:,:,294), nhel, den(201))
    call Hcont_VV(nsync, wf8(:,58), wf16(:,132), A(:,295), n3(:,623), t3x128(:,:,295), nhel, den(202))
    call Hcont_VV(nsync, wf8(:,26), wf16(:,137), A(:,296), n3(:,624), t3x128(:,:,296), nhel, den(203))
    call Hcont_QA(nsync, wf16(:,69), wf8(:,100), A(:,297), n3(:,625), t3x128(:,:,297), nhel, den(204))
    call Hcont_QA(nsync, wf16(:,69), wf8(:,102), A(:,298), n3(:,626), t3x128(:,:,298), nhel, den(205))
    call Hcont_VV(nsync, wf8(:,26), wf16(:,138), A(:,299), n3(:,627), t3x128(:,:,299), nhel, den(206))
    call Hcont_QA(nsync, wf16(:,70), wf8(:,110), A(:,300), n3(:,628), t3x128(:,:,300), nhel, den(207))
    call Hcont_SS(nsync, wf16(:,4), wf8(:,111), A(:,301), n3(:,629), t3x128(:,:,301), nhel, den(248))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,139), A(:,302), n3(:,630), t3x128(:,:,302), nhel, den(250))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,140), A(:,303), n3(:,631), t3x128(:,:,303), nhel, den(252))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,141), A(:,304), n3(:,632), t3x128(:,:,304), nhel, den(254))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,141), A(:,305), n3(:,633), t3x128(:,:,305), nhel, den(255))
    call Hcont_QA(nsync, wf16(:,81), wf8(:,112), A(:,306), n3(:,634), t3x128(:,:,306), nhel, den(256))
    call Hcont_QA(nsync, wf16(:,82), wf8(:,112), A(:,307), n3(:,635), t3x128(:,:,307), nhel, den(257))
    call Hcont_QA(nsync, wf16(:,80), wf8(:,113), A(:,308), n3(:,636), t3x128(:,:,308), nhel, den(258))
    call Hcont_QA(nsync, wf16(:,80), wf8(:,114), A(:,309), n3(:,637), t3x128(:,:,309), nhel, den(259))
    call Hcont_SS(nsync, wf16(:,4), wf8(:,115), A(:,310), n3(:,638), t3x128(:,:,310), nhel, den(261))
    call Hcont_QA(nsync, wf16(:,87), wf8(:,116), A(:,311), n3(:,639), t3x128(:,:,311), nhel, den(262))
    call Hcont_QA(nsync, wf16(:,88), wf8(:,116), A(:,312), n3(:,640), t3x128(:,:,312), nhel, den(263))
    call Hcont_QA(nsync, wf16(:,86), wf8(:,117), A(:,313), n3(:,641), t3x128(:,:,313), nhel, den(264))
    call Hcont_QA(nsync, wf16(:,86), wf8(:,118), A(:,314), n3(:,642), t3x128(:,:,314), nhel, den(265))
    call Hcont_QA(nsync, wf8(:,9), wf16(:,142), A(:,315), n3(:,643), t3x128(:,:,315), nhel, den(267))
    call Hcont_QA(nsync, wf8(:,9), wf16(:,143), A(:,316), n3(:,644), t3x128(:,:,316), nhel, den(269))
    call Hcont_QA(nsync, wf8(:,11), wf16(:,144), A(:,317), n3(:,645), t3x128(:,:,317), nhel, den(271))
    call Hcont_QA(nsync, wf8(:,13), wf16(:,144), A(:,318), n3(:,646), t3x128(:,:,318), nhel, den(272))
    call Hcont_QA(nsync, wf8(:,116), wf16(:,146), A(:,319), n3(:,647), t3x128(:,:,319), nhel, den(274))
    call Hcont_QA(nsync, wf8(:,116), wf16(:,148), A(:,320), n3(:,648), t3x128(:,:,320), nhel, den(276))
    call Hcont_QA(nsync, wf8(:,117), wf16(:,150), A(:,321), n3(:,649), t3x128(:,:,321), nhel, den(278))
    call Hcont_QA(nsync, wf8(:,118), wf16(:,150), A(:,322), n3(:,650), t3x128(:,:,322), nhel, den(279))
    call Hcont_QA(nsync, wf8(:,113), wf16(:,151), A(:,323), n3(:,651), t3x128(:,:,323), nhel, den(281))
    call Hcont_QA(nsync, wf8(:,114), wf16(:,151), A(:,324), n3(:,652), t3x128(:,:,324), nhel, den(282))
    call Hcont_QA(nsync, wf8(:,112), wf16(:,152), A(:,325), n3(:,653), t3x128(:,:,325), nhel, den(284))
    call Hcont_QA(nsync, wf8(:,112), wf16(:,153), A(:,326), n3(:,654), t3x128(:,:,326), nhel, den(286))
    call Hcont_QA(nsync, wf8(:,116), wf16(:,154), A(:,327), n3(:,655), t3x128(:,:,327), nhel, den(288))
    call Hcont_QA(nsync, wf8(:,116), wf16(:,155), A(:,328), n3(:,656), t3x128(:,:,328), nhel, den(290))
    call Hcont_QA(nsync, wf8(:,112), wf16(:,156), A(:,329), n3(:,657), t3x128(:,:,329), nhel, den(292))
    call Hcont_QA(nsync, wf8(:,112), wf16(:,157), A(:,330), n3(:,658), t3x128(:,:,330), nhel, den(294))
    call Hcont_QA(nsync, wf8(:,116), wf16(:,158), A(:,331), n3(:,659), t3x128(:,:,331), nhel, den(296))
    call Hcont_QA(nsync, wf8(:,116), wf16(:,159), A(:,332), n3(:,660), t3x128(:,:,332), nhel, den(298))
    call Hcont_QA(nsync, wf8(:,112), wf16(:,160), A(:,333), n3(:,661), t3x128(:,:,333), nhel, den(300))
    call Hcont_QA(nsync, wf8(:,112), wf16(:,161), A(:,334), n3(:,662), t3x128(:,:,334), nhel, den(302))
    call Hcont_VV(nsync, wf16(:,29), wf8(:,119), A(:,335), n3(:,663), t3x128(:,:,335), nhel, den(304))
    call Hcont_VV(nsync, wf8(:,120), wf16(:,162), A(:,336), n3(:,664), t3x128(:,:,336), nhel, den(306))
    call Hcont_VV(nsync, wf16(:,31), wf8(:,119), A(:,337), n3(:,665), t3x128(:,:,337), nhel, den(308))
    call Hcont_VV(nsync, wf8(:,120), wf16(:,163), A(:,338), n3(:,666), t3x128(:,:,338), nhel, den(310))
    call Hcont_VV(nsync, wf16(:,29), wf8(:,121), A(:,339), n3(:,667), t3x128(:,:,339), nhel, den(311))
    call Hcont_VV(nsync, wf16(:,162), wf8(:,122), A(:,340), n3(:,668), t3x128(:,:,340), nhel, den(312))
    call Hcont_VV(nsync, wf16(:,31), wf8(:,121), A(:,341), n3(:,669), t3x128(:,:,341), nhel, den(313))
    call Hcont_VV(nsync, wf16(:,163), wf8(:,122), A(:,342), n3(:,670), t3x128(:,:,342), nhel, den(314))
    call Hcont_SS(nsync, wf16(:,40), wf8(:,111), A(:,343), n3(:,671), t3x128(:,:,343), nhel, den(315))
    call Hcont_VV(nsync, wf16(:,41), wf8(:,119), A(:,344), n3(:,672), t3x128(:,:,344), nhel, den(316))
    call Hcont_VV(nsync, wf16(:,113), wf8(:,120), A(:,345), n3(:,673), t3x128(:,:,345), nhel, den(317))
    call Hcont_QA(nsync, wf8(:,44), wf16(:,164), A(:,346), n3(:,674), t3x128(:,:,346), nhel, den(319))
    call Hcont_QA(nsync, wf16(:,114), wf8(:,123), A(:,347), n3(:,675), t3x128(:,:,347), nhel, den(320))
    call Hcont_SS(nsync, wf16(:,40), wf8(:,115), A(:,348), n3(:,676), t3x128(:,:,348), nhel, den(321))
    call Hcont_VV(nsync, wf16(:,41), wf8(:,121), A(:,349), n3(:,677), t3x128(:,:,349), nhel, den(322))
    call Hcont_VV(nsync, wf16(:,113), wf8(:,122), A(:,350), n3(:,678), t3x128(:,:,350), nhel, den(323))
    call Hcont_QA(nsync, wf16(:,118), wf8(:,124), A(:,351), n3(:,679), t3x128(:,:,351), nhel, den(324))
    call Hcont_QA(nsync, wf8(:,46), wf16(:,165), A(:,352), n3(:,680), t3x128(:,:,352), nhel, den(326))
    call Hcont_QA(nsync, wf8(:,124), wf16(:,167), A(:,353), n3(:,681), t3x128(:,:,353), nhel, den(328))
    call Hcont_QA(nsync, wf8(:,123), wf16(:,169), A(:,354), n3(:,682), t3x128(:,:,354), nhel, den(330))
    call Hcont_QA(nsync, wf8(:,124), wf16(:,171), A(:,355), n3(:,683), t3x128(:,:,355), nhel, den(332))
    call Hcont_QA(nsync, wf8(:,123), wf16(:,172), A(:,356), n3(:,684), t3x128(:,:,356), nhel, den(334))
    call Hcont_QA(nsync, wf8(:,123), wf16(:,173), A(:,357), n3(:,685), t3x128(:,:,357), nhel, den(336))
    call Hcont_VV(nsync, wf16(:,52), wf8(:,119), A(:,358), n3(:,686), t3x128(:,:,358), nhel, den(338))
    call Hcont_VV(nsync, wf8(:,120), wf16(:,174), A(:,359), n3(:,687), t3x128(:,:,359), nhel, den(340))
    call Hcont_VV(nsync, wf8(:,120), wf16(:,175), A(:,360), n3(:,688), t3x128(:,:,360), nhel, den(342))
    call Hcont_VV(nsync, wf16(:,52), wf8(:,121), A(:,361), n3(:,689), t3x128(:,:,361), nhel, den(343))
    call Hcont_VV(nsync, wf8(:,122), wf16(:,174), A(:,362), n3(:,690), t3x128(:,:,362), nhel, den(344))
    call Hcont_VV(nsync, wf8(:,122), wf16(:,175), A(:,363), n3(:,691), t3x128(:,:,363), nhel, den(345))
    call Hcont_QA(nsync, wf8(:,124), wf16(:,176), A(:,364), n3(:,692), t3x128(:,:,364), nhel, den(347))
    call Hcont_VV(nsync, wf16(:,61), wf8(:,119), A(:,365), n3(:,693), t3x128(:,:,365), nhel, den(349))
    call Hcont_VV(nsync, wf8(:,120), wf16(:,177), A(:,366), n3(:,694), t3x128(:,:,366), nhel, den(351))
    call Hcont_VV(nsync, wf8(:,120), wf16(:,178), A(:,367), n3(:,695), t3x128(:,:,367), nhel, den(353))
    call Hcont_VV(nsync, wf16(:,61), wf8(:,121), A(:,368), n3(:,696), t3x128(:,:,368), nhel, den(354))
    call Hcont_VV(nsync, wf8(:,122), wf16(:,177), A(:,369), n3(:,697), t3x128(:,:,369), nhel, den(355))
    call Hcont_VV(nsync, wf8(:,122), wf16(:,178), A(:,370), n3(:,698), t3x128(:,:,370), nhel, den(356))
    call Hcont_VV(nsync, wf8(:,120), wf16(:,179), A(:,371), n3(:,699), t3x128(:,:,371), nhel, den(358))
    call Hcont_VV(nsync, wf8(:,120), wf16(:,180), A(:,372), n3(:,700), t3x128(:,:,372), nhel, den(360))
    call Hcont_VV(nsync, wf8(:,122), wf16(:,179), A(:,373), n3(:,701), t3x128(:,:,373), nhel, den(361))
    call Hcont_VV(nsync, wf8(:,122), wf16(:,180), A(:,374), n3(:,702), t3x128(:,:,374), nhel, den(362))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(1), M2(1) ! M1helarray(1,nhel)
  integer :: empty(0), i

  M1(1)%j = (-A(j,3)%j-A(j,5)%j-A(j,8)%j-A(j,10)%j-A(j,13)%j-A(j,15)%j-A(j,39)%j-A(j,41)%j-A(j,43)%j-A(j,45)%j)*f(1)+(-A(j,4)%j &
       -A(j,6)%j-A(j,9)%j-A(j,11)%j-A(j,14)%j-A(j,16)%j-A(j,17)%j-A(j,20)%j-A(j,22)%j-A(j,25)%j-A(j,27)%j-A(j,29)%j-A(j,31)%j &
       -A(j,33)%j-A(j,35)%j-A(j,37)%j-A(j,40)%j-A(j,42)%j-A(j,44)%j-A(j,46)%j-A(j,100)%j-A(j,101)%j-A(j,102)%j-A(j,103)%j)*f(2)+( &
       -A(j,18)%j-A(j,21)%j-A(j,23)%j-A(j,26)%j-A(j,28)%j-A(j,30)%j-A(j,32)%j-A(j,34)%j-A(j,36)%j-A(j,38)%j-A(j,106)%j-A(j,107)%j &
       -A(j,109)%j-A(j,112)%j)*f(3)+(A(j,53)%j+A(j,57)%j)*f(10)-A(j,61)%j*f(11)+(-A(j,62)%j-A(j,63)%j+A(j,75)%j+A(j,93)%j)*f(12)+( &
       -A(j,54)%j-A(j,58)%j)*f(21)+(A(j,47)%j+A(j,50)%j-A(j,66)%j-A(j,84)%j)*f(22)+(A(j,56)%j+A(j,60)%j)*f(27)+(A(j,2)%j-A(j,49)%j &
       -A(j,52)%j+A(j,68)%j+A(j,86)%j)*f(28)+(-A(j,55)%j-A(j,59)%j+A(j,76)%j+A(j,79)%j+A(j,94)%j+A(j,97)%j)*f(32)+(-A(j,1)%j &
       +A(j,48)%j+A(j,51)%j+A(j,64)%j-A(j,67)%j+A(j,70)%j-A(j,73)%j+A(j,77)%j+A(j,78)%j+A(j,80)%j+A(j,81)%j+A(j,82)%j-A(j,85)%j &
       +A(j,88)%j-A(j,91)%j+A(j,95)%j+A(j,96)%j+A(j,98)%j+A(j,99)%j+A(j,104)%j+A(j,110)%j)*f(33)+(A(j,65)%j+A(j,69)%j+A(j,71)%j &
       -A(j,72)%j-A(j,74)%j+A(j,83)%j+A(j,87)%j+A(j,89)%j-A(j,90)%j-A(j,92)%j+A(j,105)%j+A(j,108)%j+A(j,111)%j+A(j,113)%j)*f(34) &
       +(A(j,7)%j+A(j,12)%j)*f(40)+(A(j,19)%j+A(j,24)%j)*f(41)

  M2(1)%j = (A(j,302)%j+A(j,304)%j+A(j,306)%j+A(j,308)%j+A(j,311)%j+A(j,313)%j+A(j,315)%j+A(j,317)%j+A(j,319)%j+A(j,321)%j &
       +A(j,323)%j+A(j,325)%j+A(j,335)%j+A(j,337)%j+A(j,339)%j+A(j,341)%j)*f(4)+(A(j,303)%j+A(j,305)%j+A(j,307)%j+A(j,309)%j &
       +A(j,312)%j+A(j,314)%j+A(j,316)%j+A(j,318)%j+A(j,320)%j+A(j,322)%j+A(j,324)%j+A(j,326)%j+A(j,327)%j+A(j,329)%j+A(j,331)%j &
       +A(j,333)%j+A(j,336)%j+A(j,338)%j+A(j,340)%j+A(j,342)%j+A(j,371)%j+A(j,372)%j+A(j,373)%j+A(j,374)%j)*f(5)+(A(j,328)%j &
       +A(j,330)%j+A(j,332)%j+A(j,334)%j)*f(6)+(-A(j,116)%j-A(j,118)%j-A(j,120)%j-A(j,122)%j-A(j,124)%j-A(j,126)%j-A(j,129)%j &
       -A(j,131)%j-A(j,133)%j-A(j,135)%j-A(j,137)%j-A(j,139)%j-A(j,143)%j-A(j,145)%j-A(j,147)%j-A(j,149)%j-A(j,151)%j-A(j,153)%j &
       -A(j,164)%j-A(j,166)%j-A(j,168)%j-A(j,170)%j-A(j,180)%j-A(j,182)%j-A(j,184)%j-A(j,186)%j)*f(7)+(-A(j,117)%j-A(j,119)%j &
       -A(j,121)%j-A(j,123)%j-A(j,125)%j-A(j,127)%j-A(j,130)%j-A(j,132)%j-A(j,134)%j-A(j,136)%j-A(j,138)%j-A(j,140)%j-A(j,144)%j &
       -A(j,146)%j-A(j,148)%j-A(j,150)%j-A(j,152)%j-A(j,154)%j-A(j,156)%j-A(j,158)%j-A(j,160)%j-A(j,162)%j-A(j,165)%j-A(j,167)%j &
       -A(j,169)%j-A(j,171)%j-A(j,172)%j-A(j,174)%j-A(j,176)%j-A(j,178)%j-A(j,181)%j-A(j,183)%j-A(j,185)%j-A(j,187)%j-A(j,188)%j &
       -A(j,191)%j-A(j,193)%j-A(j,196)%j-A(j,198)%j-A(j,200)%j-A(j,283)%j-A(j,284)%j-A(j,285)%j-A(j,286)%j-A(j,287)%j-A(j,288)%j &
       -A(j,289)%j-A(j,290)%j)*f(8)+(-A(j,157)%j-A(j,159)%j-A(j,161)%j-A(j,163)%j-A(j,173)%j-A(j,175)%j-A(j,177)%j-A(j,179)%j &
       -A(j,189)%j-A(j,192)%j-A(j,194)%j-A(j,197)%j-A(j,199)%j-A(j,201)%j-A(j,293)%j-A(j,294)%j-A(j,296)%j-A(j,299)%j)*f(9)+( &
       -A(j,346)%j-A(j,347)%j-A(j,351)%j-A(j,352)%j)*f(13)+(A(j,355)%j+A(j,356)%j)*f(14)+(A(j,353)%j+A(j,354)%j-A(j,357)%j &
       -A(j,364)%j)*f(15)+(A(j,212)%j+A(j,223)%j)*f(16)+(A(j,202)%j+A(j,203)%j+A(j,208)%j+A(j,219)%j)*f(17)+(-A(j,210)%j &
       -A(j,221)%j)*f(18)+(-A(j,209)%j-A(j,211)%j-A(j,220)%j-A(j,222)%j+A(j,233)%j+A(j,240)%j+A(j,258)%j+A(j,265)%j)*f(19) &
       -A(j,204)%j*f(20)+(A(j,343)%j+A(j,348)%j)*f(23)+(-A(j,205)%j-A(j,216)%j)*f(24)+(A(j,227)%j+A(j,230)%j-A(j,249)%j &
       -A(j,274)%j)*f(25)+(-A(j,213)%j-A(j,224)%j)*f(26)+(-A(j,345)%j-A(j,350)%j)*f(29)+(A(j,207)%j+A(j,215)%j+A(j,218)%j &
       +A(j,226)%j)*f(30)+(A(j,115)%j-A(j,229)%j-A(j,232)%j+A(j,251)%j+A(j,276)%j)*f(31)+(A(j,344)%j+A(j,349)%j-A(j,358)%j &
       -A(j,361)%j-A(j,365)%j-A(j,368)%j)*f(35)+(-A(j,359)%j-A(j,360)%j-A(j,362)%j-A(j,363)%j-A(j,366)%j-A(j,367)%j-A(j,369)%j &
       -A(j,370)%j)*f(36)+(-A(j,206)%j-A(j,214)%j-A(j,217)%j-A(j,225)%j+A(j,234)%j+A(j,237)%j+A(j,241)%j+A(j,244)%j+A(j,259)%j &
       +A(j,262)%j+A(j,266)%j+A(j,269)%j)*f(37)+(-A(j,114)%j+A(j,228)%j+A(j,231)%j+A(j,235)%j+A(j,236)%j+A(j,238)%j+A(j,239)%j &
       +A(j,242)%j+A(j,243)%j+A(j,245)%j+A(j,246)%j+A(j,247)%j-A(j,250)%j+A(j,253)%j-A(j,255)%j+A(j,260)%j+A(j,261)%j+A(j,263)%j &
       +A(j,264)%j+A(j,267)%j+A(j,268)%j+A(j,270)%j+A(j,271)%j+A(j,272)%j-A(j,275)%j+A(j,278)%j-A(j,280)%j+A(j,291)%j &
       +A(j,297)%j)*f(38)+(A(j,248)%j+A(j,252)%j+A(j,254)%j-A(j,256)%j-A(j,257)%j+A(j,273)%j+A(j,277)%j+A(j,279)%j-A(j,281)%j &
       -A(j,282)%j+A(j,292)%j+A(j,295)%j+A(j,298)%j+A(j,300)%j)*f(39)+(-A(j,301)%j-A(j,310)%j)*f(42)+(A(j,128)%j+A(j,142)%j)*f(43) &
       +(A(j,190)%j+A(j,195)%j)*f(44)+(A(j,141)%j+A(j,155)%j)*f(45)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pplllla_nenexeexbbxa_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 1
      do j = 1, 1
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pplllla_nenexeexbbxa_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mct(1)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 1
    do j = 1, 1
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+1*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_pplllla_nenexeexbbxa_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2IRadd(29)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 30-1
    colmatpos = 1*k
    do i = 1, 1
      do j = 1, 1
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pplllla_nenexeexbbxa_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_pplllla_nenexeexbbxa_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(1)
  type(Hpolcont), intent(out)  :: M0_col(1)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 1 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 1 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+1*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_pplllla_nenexeexbbxa_1_/**/REALKIND
