
module ol_colourmatrix_pplllla_eeexexddxa_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(30,1), K2(30,1), KL(30,1), Cas(7) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [  3]
  K1( 2,:) = [  0]
  K1( 3,:) = [  0]
  K1( 4,:) = [  0]
  K1( 5,:) = [  0]
  K1( 6,:) = [  0]
  K1( 7,:) = [  0]
  K1( 8,:) = [  0]
  K1( 9,:) = [  0]
  K1(10,:) = [  0]
  K1(11,:) = [  0]
  K1(12,:) = [  0]
  K1(13,:) = [  0]
  K1(14,:) = [  0]
  K1(15,:) = [  0]
  K1(16,:) = [  4]
  K1(17,:) = [  0]
  K1(18,:) = [  0]
  K1(19,:) = [  0]
  K1(20,:) = [  0]
  K1(21,:) = [ -4]
  K1(22,:) = [  4]
  K1(23,:) = [  0]
  K1(24,:) = [  0]
  K1(25,:) = [  0]
  K1(26,:) = [  0]
  K1(27,:) = [  0]
  K1(28,:) = [  0]
  K1(29,:) = [  0]
  K1(30,:) = [  0]

  K2( 1,:) = [  3]
  K2( 2,:) = [  0]
  K2( 3,:) = [  0]
  K2( 4,:) = [  0]
  K2( 5,:) = [  0]
  K2( 6,:) = [  0]
  K2( 7,:) = [  0]
  K2( 8,:) = [  0]
  K2( 9,:) = [  0]
  K2(10,:) = [  0]
  K2(11,:) = [  0]
  K2(12,:) = [  0]
  K2(13,:) = [  0]
  K2(14,:) = [  0]
  K2(15,:) = [  0]
  K2(16,:) = [  4]
  K2(17,:) = [  0]
  K2(18,:) = [  0]
  K2(19,:) = [  0]
  K2(20,:) = [  0]
  K2(21,:) = [ -4]
  K2(22,:) = [  4]
  K2(23,:) = [  0]
  K2(24,:) = [  0]
  K2(25,:) = [  0]
  K2(26,:) = [  0]
  K2(27,:) = [  0]
  K2(28,:) = [  0]
  K2(29,:) = [  0]
  K2(30,:) = [  0]

  KL( 1,:) = [  3]
  KL( 2,:) = [  0]
  KL( 3,:) = [  0]
  KL( 4,:) = [  0]
  KL( 5,:) = [  0]
  KL( 6,:) = [  0]
  KL( 7,:) = [  0]
  KL( 8,:) = [  0]
  KL( 9,:) = [  0]
  KL(10,:) = [  0]
  KL(11,:) = [  0]
  KL(12,:) = [  0]
  KL(13,:) = [  0]
  KL(14,:) = [  0]
  KL(15,:) = [  0]
  KL(16,:) = [  4]
  KL(17,:) = [  0]
  KL(18,:) = [  0]
  KL(19,:) = [  0]
  KL(20,:) = [  0]
  KL(21,:) = [ -4]
  KL(22,:) = [  4]
  KL(23,:) = [  0]
  KL(24,:) = [  0]
  KL(25,:) = [  0]
  KL(26,:) = [  0]
  KL(27,:) = [  0]
  KL(28,:) = [  0]
  KL(29,:) = [  0]
  KL(30,:) = [  0]

#if -1 > 0
    co = 0
    do k = 1, 7
      co = co + k
      Cas(k) = K1(1+1*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_pplllla_eeexexddxa_1_/**/REALKIND



module ol_forced_parameters_pplllla_eeexexddxa_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pplllla_eeexexddxa_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_pplllla_eeexexddxa_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 128 ! number of helicity configurations
  integer(intkind2), save :: nhel = 128 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: hel_states = 128 ! number of helicity configurations needed for mem-allocation
  integer(intkind2), save :: Hel(128) ! physical helicity states
#endif

  type(Hpolcont), save, allocatable :: A(:,:), M1helarray(:,:), M1helarray_ct(:,:)
  complex(REALKIND), save :: den(1570)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2), ex7(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,38), wf8(8,190), wf16(16,472), wf32(32,432), wf128(128,1120)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(16), c(4)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save, allocatable :: M0_col1_helarray(:,:), M0M1_hel_cc(:,:,:)
  complex(REALKIND), save :: M2ctcc(29)

end module ol_loop_storage_pplllla_eeexexddxa_1_/**/REALKIND






! **********************************************************************
module ol_loop_pplllla_eeexexddxa_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_pplllla_eeexexddxa_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (CI*eQED**5)/27._/**/REALKIND
    f( 2) = (CI*eQED**5)/9._/**/REALKIND
    f( 3) = (CI*eQED**5)/3._/**/REALKIND
    f( 4) = CI*eQED**5
    f( 5) = (CI*countertermnorm*eQED**5*gQCD**2)/27._/**/REALKIND
    f( 6) = (CI*countertermnorm*eQED**5*gQCD**2)/9._/**/REALKIND
    f( 7) = (CI*countertermnorm*eQED**5*gQCD**2)/3._/**/REALKIND
    f( 8) = CI*countertermnorm*eQED**5*gQCD**2
    f( 9) = (CI*countertermnorm*ctVqq*eQED**5*gQCD**2)/27._/**/REALKIND
    f(10) = (CI*countertermnorm*ctVqq*eQED**5*gQCD**2)/9._/**/REALKIND
    f(11) = (CI*countertermnorm*ctVqq*eQED**5*gQCD**2)/3._/**/REALKIND
    f(12) = CI*countertermnorm*ctVqq*eQED**5*gQCD**2
    f(13) = (eQED**5*gQCD**2*integralnorm*SwB)/27._/**/REALKIND
    f(14) = (eQED**5*gQCD**2*integralnorm*SwB)/9._/**/REALKIND
    f(15) = (eQED**5*gQCD**2*integralnorm*SwB)/3._/**/REALKIND
    f(16) = eQED**5*gQCD**2*integralnorm*SwB

  c = [ 4*f(13), 4*f(14), 4*f(15), 4*f(16) ]
  c = (1._/**/REALKIND / 3) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,5))+L(6,5))
  den(2) = 1 /((L(5,10))+L(6,10))
  den(3) = 1 /((L(5,80))+L(6,80))
  den(5) = 1 /((L(5,37))+L(6,37))
  den(8) = 1 /((L(5,10) - MZ2)+L(6,10))
  den(11) = 1 /((L(5,5) - MZ2)+L(6,5))
  den(16) = 1 /((L(5,42))+L(6,42))
  den(24) = 1 /((L(5,96))+L(6,96))
  den(26) = 1 /((L(5,21))+L(6,21))
  den(35) = 1 /((L(5,26))+L(6,26))
  den(51) = 1 /((L(5,66))+L(6,66))
  den(52) = 1 /((L(5,48))+L(6,48))
  den(54) = 1 /((L(5,13))+L(6,13))
  den(57) = 1 /((L(5,48) - MZ2)+L(6,48))
  den(64) = 1 /((L(5,56))+L(6,56))
  den(72) = 1 /((L(5,72))+L(6,72))
  den(74) = 1 /((L(5,7))+L(6,7))
  den(83) = 1 /((L(5,50))+L(6,50))
  den(99) = 1 /((L(5,74))+L(6,74))
  den(102) = 1 /((L(5,74) - MZ2)+L(6,74))
  den(121) = 1 /((L(5,112))+L(6,112))
  den(124) = 1 /((L(5,112) - MZ2)+L(6,112))
  den(143) = 1 /((L(5,9))+L(6,9))
  den(144) = 1 /((L(5,6))+L(6,6))
  den(146) = 1 /((L(5,41))+L(6,41))
  den(149) = 1 /((L(5,6) - MZ2)+L(6,6))
  den(152) = 1 /((L(5,9) - MZ2)+L(6,9))
  den(157) = 1 /((L(5,38))+L(6,38))
  den(166) = 1 /((L(5,25))+L(6,25))
  den(175) = 1 /((L(5,22))+L(6,22))
  den(191) = 1 /((L(5,65))+L(6,65))
  den(193) = 1 /((L(5,14))+L(6,14))
  den(214) = 1 /((L(5,49))+L(6,49))
  den(230) = 1 /((L(5,73))+L(6,73))
  den(233) = 1 /((L(5,73) - MZ2)+L(6,73))
  den(275) = 1 /((L(5,52))+L(6,52))
  den(283) = 1 /((L(5,68))+L(6,68))
  den(285) = 1 /((L(5,11))+L(6,11))
  den(307) = 1 /((L(5,70))+L(6,70))
  den(310) = 1 /((L(5,70) - MZ2)+L(6,70))
  den(377) = 1 /((L(5,69))+L(6,69))
  den(380) = 1 /((L(5,69) - MZ2)+L(6,69))
  den(479) = 1 /((L(5,85))+L(6,85))
  den(486) = 1 /((L(5,90))+L(6,90))
  den(493) = 1 /((L(5,101))+L(6,101))
  den(500) = 1 /((L(5,106))+L(6,106))
  den(507) = 1 /((L(5,89))+L(6,89))
  den(514) = 1 /((L(5,86))+L(6,86))
  den(521) = 1 /((L(5,105))+L(6,105))
  den(528) = 1 /((L(5,102))+L(6,102))
  den(625) = 1 /((L(5,15))+L(6,15))
  den(628) = 1 /((L(5,15) - MZ2)+L(6,15))
  den(860) = 1 /((L(5,31))+L(6,31))
  den(869) = 1 /((L(5,47))+L(6,47))
  den(894) = 1 /((L(5,79))+L(6,79))
  den(896) = 1 /((L(5,79) - MZ2)+L(6,79))
  den(901) = 1 /((L(5,71))+L(6,71))
  den(914) = 1 /((L(5,77))+L(6,77))
  den(999) = 1 /((L(5,78))+L(6,78))
  den(1040) = 1 /((L(5,75))+L(6,75))

  ! denominators
  den(4) = den(2)*den(3)
  den(6) = den(1)*den(5)
  den(7) = den(4)*den(6)
  den(9) = den(3)*den(8)
  den(10) = den(6)*den(9)
  den(12) = den(5)*den(11)
  den(13) = den(4)*den(12)
  den(14) = den(9)*den(12)
  den(15) = den(1)*den(3)
  den(17) = den(2)*den(16)
  den(18) = den(15)*den(17)
  den(19) = den(8)*den(16)
  den(20) = den(15)*den(19)
  den(21) = den(3)*den(11)
  den(22) = den(17)*den(21)
  den(23) = den(19)*den(21)
  den(25) = den(2)*den(24)
  den(27) = den(1)*den(26)
  den(28) = den(25)*den(27)
  den(29) = den(8)*den(24)
  den(30) = den(27)*den(29)
  den(31) = den(11)*den(26)
  den(32) = den(25)*den(31)
  den(33) = den(29)*den(31)
  den(34) = den(1)*den(24)
  den(36) = den(2)*den(35)
  den(37) = den(34)*den(36)
  den(38) = den(8)*den(35)
  den(39) = den(34)*den(38)
  den(40) = den(11)*den(24)
  den(41) = den(36)*den(40)
  den(42) = den(38)*den(40)
  den(43) = den(17)*den(27)
  den(44) = den(19)*den(27)
  den(45) = den(17)*den(31)
  den(46) = den(19)*den(31)
  den(47) = den(6)*den(36)
  den(48) = den(6)*den(38)
  den(49) = den(12)*den(36)
  den(50) = den(12)*den(38)
  den(53) = den(51)*den(52)
  den(55) = den(1)*den(54)
  den(56) = den(53)*den(55)
  den(58) = den(51)*den(57)
  den(59) = den(55)*den(58)
  den(60) = den(11)*den(54)
  den(61) = den(53)*den(60)
  den(62) = den(58)*den(60)
  den(63) = den(1)*den(51)
  den(65) = den(52)*den(64)
  den(66) = den(63)*den(65)
  den(67) = den(57)*den(64)
  den(68) = den(63)*den(67)
  den(69) = den(11)*den(51)
  den(70) = den(65)*den(69)
  den(71) = den(67)*den(69)
  den(73) = den(52)*den(72)
  den(75) = den(1)*den(74)
  den(76) = den(73)*den(75)
  den(77) = den(57)*den(72)
  den(78) = den(75)*den(77)
  den(79) = den(11)*den(74)
  den(80) = den(73)*den(79)
  den(81) = den(77)*den(79)
  den(82) = den(1)*den(72)
  den(84) = den(52)*den(83)
  den(85) = den(82)*den(84)
  den(86) = den(57)*den(83)
  den(87) = den(82)*den(86)
  den(88) = den(11)*den(72)
  den(89) = den(84)*den(88)
  den(90) = den(86)*den(88)
  den(91) = den(65)*den(75)
  den(92) = den(67)*den(75)
  den(93) = den(65)*den(79)
  den(94) = den(67)*den(79)
  den(95) = den(55)*den(84)
  den(96) = den(55)*den(86)
  den(97) = den(60)*den(84)
  den(98) = den(60)*den(86)
  den(100) = den(51)*den(99)
  den(101) = den(27)*den(100)
  den(103) = den(51)*den(102)
  den(104) = den(27)*den(103)
  den(105) = den(31)*den(100)
  den(106) = den(31)*den(103)
  den(107) = den(6)*den(100)
  den(108) = den(6)*den(103)
  den(109) = den(12)*den(100)
  den(110) = den(12)*den(103)
  den(111) = den(72)*den(99)
  den(112) = den(27)*den(111)
  den(113) = den(72)*den(102)
  den(114) = den(27)*den(113)
  den(115) = den(31)*den(111)
  den(116) = den(31)*den(113)
  den(117) = den(6)*den(111)
  den(118) = den(6)*den(113)
  den(119) = den(12)*den(111)
  den(120) = den(12)*den(113)
  den(122) = den(3)*den(121)
  den(123) = den(75)*den(122)
  den(125) = den(3)*den(124)
  den(126) = den(75)*den(125)
  den(127) = den(79)*den(122)
  den(128) = den(79)*den(125)
  den(129) = den(55)*den(122)
  den(130) = den(55)*den(125)
  den(131) = den(60)*den(122)
  den(132) = den(60)*den(125)
  den(133) = den(24)*den(121)
  den(134) = den(75)*den(133)
  den(135) = den(24)*den(124)
  den(136) = den(75)*den(135)
  den(137) = den(79)*den(133)
  den(138) = den(79)*den(135)
  den(139) = den(55)*den(133)
  den(140) = den(55)*den(135)
  den(141) = den(60)*den(133)
  den(142) = den(60)*den(135)
  den(145) = den(3)*den(144)
  den(147) = den(143)*den(146)
  den(148) = den(145)*den(147)
  den(150) = den(3)*den(149)
  den(151) = den(147)*den(150)
  den(153) = den(146)*den(152)
  den(154) = den(145)*den(153)
  den(155) = den(150)*den(153)
  den(156) = den(3)*den(143)
  den(158) = den(144)*den(157)
  den(159) = den(156)*den(158)
  den(160) = den(149)*den(157)
  den(161) = den(156)*den(160)
  den(162) = den(3)*den(152)
  den(163) = den(158)*den(162)
  den(164) = den(160)*den(162)
  den(165) = den(24)*den(144)
  den(167) = den(143)*den(166)
  den(168) = den(165)*den(167)
  den(169) = den(24)*den(149)
  den(170) = den(167)*den(169)
  den(171) = den(152)*den(166)
  den(172) = den(165)*den(171)
  den(173) = den(169)*den(171)
  den(174) = den(24)*den(143)
  den(176) = den(144)*den(175)
  den(177) = den(174)*den(176)
  den(178) = den(149)*den(175)
  den(179) = den(174)*den(178)
  den(180) = den(24)*den(152)
  den(181) = den(176)*den(180)
  den(182) = den(178)*den(180)
  den(183) = den(158)*den(167)
  den(184) = den(160)*den(167)
  den(185) = den(158)*den(171)
  den(186) = den(160)*den(171)
  den(187) = den(147)*den(176)
  den(188) = den(147)*den(178)
  den(189) = den(153)*den(176)
  den(190) = den(153)*den(178)
  den(192) = den(52)*den(191)
  den(194) = den(144)*den(193)
  den(195) = den(192)*den(194)
  den(196) = den(57)*den(191)
  den(197) = den(194)*den(196)
  den(198) = den(149)*den(193)
  den(199) = den(192)*den(198)
  den(200) = den(196)*den(198)
  den(201) = den(144)*den(191)
  den(202) = den(65)*den(201)
  den(203) = den(67)*den(201)
  den(204) = den(149)*den(191)
  den(205) = den(65)*den(204)
  den(206) = den(67)*den(204)
  den(207) = den(74)*den(144)
  den(208) = den(73)*den(207)
  den(209) = den(77)*den(207)
  den(210) = den(74)*den(149)
  den(211) = den(73)*den(210)
  den(212) = den(77)*den(210)
  den(213) = den(72)*den(144)
  den(215) = den(52)*den(214)
  den(216) = den(213)*den(215)
  den(217) = den(72)*den(149)
  den(218) = den(215)*den(217)
  den(219) = den(57)*den(214)
  den(220) = den(213)*den(219)
  den(221) = den(217)*den(219)
  den(222) = den(65)*den(207)
  den(223) = den(67)*den(207)
  den(224) = den(65)*den(210)
  den(225) = den(67)*den(210)
  den(226) = den(194)*den(215)
  den(227) = den(198)*den(215)
  den(228) = den(194)*den(219)
  den(229) = den(198)*den(219)
  den(231) = den(191)*den(230)
  den(232) = den(176)*den(231)
  den(234) = den(191)*den(233)
  den(235) = den(176)*den(234)
  den(236) = den(178)*den(231)
  den(237) = den(178)*den(234)
  den(238) = den(158)*den(231)
  den(239) = den(158)*den(234)
  den(240) = den(160)*den(231)
  den(241) = den(160)*den(234)
  den(242) = den(72)*den(230)
  den(243) = den(158)*den(242)
  den(244) = den(160)*den(242)
  den(245) = den(72)*den(233)
  den(246) = den(158)*den(245)
  den(247) = den(160)*den(245)
  den(248) = den(176)*den(242)
  den(249) = den(178)*den(242)
  den(250) = den(176)*den(245)
  den(251) = den(178)*den(245)
  den(252) = den(122)*den(207)
  den(253) = den(125)*den(207)
  den(254) = den(122)*den(210)
  den(255) = den(125)*den(210)
  den(256) = den(122)*den(194)
  den(257) = den(122)*den(198)
  den(258) = den(125)*den(194)
  den(259) = den(125)*den(198)
  den(260) = den(133)*den(207)
  den(261) = den(135)*den(207)
  den(262) = den(133)*den(210)
  den(263) = den(135)*den(210)
  den(264) = den(133)*den(194)
  den(265) = den(133)*den(198)
  den(266) = den(135)*den(194)
  den(267) = den(135)*den(198)
  den(268) = den(54)*den(143)
  den(269) = den(53)*den(268)
  den(270) = den(58)*den(268)
  den(271) = den(54)*den(152)
  den(272) = den(53)*den(271)
  den(273) = den(58)*den(271)
  den(274) = den(51)*den(143)
  den(276) = den(52)*den(275)
  den(277) = den(274)*den(276)
  den(278) = den(57)*den(275)
  den(279) = den(274)*den(278)
  den(280) = den(51)*den(152)
  den(281) = den(276)*den(280)
  den(282) = den(278)*den(280)
  den(284) = den(52)*den(283)
  den(286) = den(143)*den(285)
  den(287) = den(284)*den(286)
  den(288) = den(57)*den(283)
  den(289) = den(286)*den(288)
  den(290) = den(152)*den(285)
  den(291) = den(284)*den(290)
  den(292) = den(288)*den(290)
  den(293) = den(143)*den(283)
  den(294) = den(84)*den(293)
  den(295) = den(86)*den(293)
  den(296) = den(152)*den(283)
  den(297) = den(84)*den(296)
  den(298) = den(86)*den(296)
  den(299) = den(276)*den(286)
  den(300) = den(278)*den(286)
  den(301) = den(276)*den(290)
  den(302) = den(278)*den(290)
  den(303) = den(84)*den(268)
  den(304) = den(86)*den(268)
  den(305) = den(84)*den(271)
  den(306) = den(86)*den(271)
  den(308) = den(51)*den(307)
  den(309) = den(167)*den(308)
  den(311) = den(51)*den(310)
  den(312) = den(167)*den(311)
  den(313) = den(171)*den(308)
  den(314) = den(171)*den(311)
  den(315) = den(147)*den(308)
  den(316) = den(147)*den(311)
  den(317) = den(153)*den(308)
  den(318) = den(153)*den(311)
  den(319) = den(283)*den(307)
  den(320) = den(167)*den(319)
  den(321) = den(283)*den(310)
  den(322) = den(167)*den(321)
  den(323) = den(171)*den(319)
  den(324) = den(171)*den(321)
  den(325) = den(147)*den(319)
  den(326) = den(147)*den(321)
  den(327) = den(153)*den(319)
  den(328) = den(153)*den(321)
  den(329) = den(122)*den(286)
  den(330) = den(125)*den(286)
  den(331) = den(122)*den(290)
  den(332) = den(125)*den(290)
  den(333) = den(122)*den(268)
  den(334) = den(125)*den(268)
  den(335) = den(122)*den(271)
  den(336) = den(125)*den(271)
  den(337) = den(133)*den(286)
  den(338) = den(135)*den(286)
  den(339) = den(133)*den(290)
  den(340) = den(135)*den(290)
  den(341) = den(133)*den(268)
  den(342) = den(135)*den(268)
  den(343) = den(133)*den(271)
  den(344) = den(135)*den(271)
  den(345) = den(2)*den(193)
  den(346) = den(192)*den(345)
  den(347) = den(196)*den(345)
  den(348) = den(8)*den(193)
  den(349) = den(192)*den(348)
  den(350) = den(196)*den(348)
  den(351) = den(2)*den(191)
  den(352) = den(276)*den(351)
  den(353) = den(278)*den(351)
  den(354) = den(8)*den(191)
  den(355) = den(276)*den(354)
  den(356) = den(278)*den(354)
  den(357) = den(2)*den(285)
  den(358) = den(284)*den(357)
  den(359) = den(288)*den(357)
  den(360) = den(8)*den(285)
  den(361) = den(284)*den(360)
  den(362) = den(288)*den(360)
  den(363) = den(2)*den(283)
  den(364) = den(215)*den(363)
  den(365) = den(8)*den(283)
  den(366) = den(215)*den(365)
  den(367) = den(219)*den(363)
  den(368) = den(219)*den(365)
  den(369) = den(276)*den(357)
  den(370) = den(278)*den(357)
  den(371) = den(276)*den(360)
  den(372) = den(278)*den(360)
  den(373) = den(215)*den(345)
  den(374) = den(215)*den(348)
  den(375) = den(219)*den(345)
  den(376) = den(219)*den(348)
  den(378) = den(191)*den(377)
  den(379) = den(36)*den(378)
  den(381) = den(191)*den(380)
  den(382) = den(36)*den(381)
  den(383) = den(38)*den(378)
  den(384) = den(38)*den(381)
  den(385) = den(17)*den(378)
  den(386) = den(17)*den(381)
  den(387) = den(19)*den(378)
  den(388) = den(19)*den(381)
  den(389) = den(283)*den(377)
  den(390) = den(17)*den(389)
  den(391) = den(19)*den(389)
  den(392) = den(283)*den(380)
  den(393) = den(17)*den(392)
  den(394) = den(19)*den(392)
  den(395) = den(36)*den(389)
  den(396) = den(38)*den(389)
  den(397) = den(36)*den(392)
  den(398) = den(38)*den(392)
  den(399) = den(122)*den(357)
  den(400) = den(125)*den(357)
  den(401) = den(122)*den(360)
  den(402) = den(125)*den(360)
  den(403) = den(122)*den(345)
  den(404) = den(122)*den(348)
  den(405) = den(125)*den(345)
  den(406) = den(125)*den(348)
  den(407) = den(133)*den(357)
  den(408) = den(135)*den(357)
  den(409) = den(133)*den(360)
  den(410) = den(135)*den(360)
  den(411) = den(133)*den(345)
  den(412) = den(133)*den(348)
  den(413) = den(135)*den(345)
  den(414) = den(135)*den(348)
  den(415) = den(65)*den(378)
  den(416) = den(67)*den(378)
  den(417) = den(65)*den(381)
  den(418) = den(67)*den(381)
  den(419) = den(84)*den(378)
  den(420) = den(84)*den(381)
  den(421) = den(86)*den(378)
  den(422) = den(86)*den(381)
  den(423) = den(231)*den(276)
  den(424) = den(231)*den(278)
  den(425) = den(234)*den(276)
  den(426) = den(234)*den(278)
  den(427) = den(84)*den(231)
  den(428) = den(84)*den(234)
  den(429) = den(86)*den(231)
  den(430) = den(86)*den(234)
  den(431) = den(65)*den(308)
  den(432) = den(67)*den(308)
  den(433) = den(65)*den(311)
  den(434) = den(67)*den(311)
  den(435) = den(100)*den(276)
  den(436) = den(100)*den(278)
  den(437) = den(103)*den(276)
  den(438) = den(103)*den(278)
  den(439) = den(100)*den(215)
  den(440) = den(103)*den(215)
  den(441) = den(100)*den(219)
  den(442) = den(103)*den(219)
  den(443) = den(215)*den(308)
  den(444) = den(215)*den(311)
  den(445) = den(219)*den(308)
  den(446) = den(219)*den(311)
  den(447) = den(65)*den(389)
  den(448) = den(67)*den(389)
  den(449) = den(65)*den(392)
  den(450) = den(67)*den(392)
  den(451) = den(65)*den(319)
  den(452) = den(67)*den(319)
  den(453) = den(65)*den(321)
  den(454) = den(67)*den(321)
  den(455) = den(84)*den(389)
  den(456) = den(86)*den(389)
  den(457) = den(84)*den(392)
  den(458) = den(86)*den(392)
  den(459) = den(215)*den(319)
  den(460) = den(215)*den(321)
  den(461) = den(219)*den(319)
  den(462) = den(219)*den(321)
  den(463) = den(111)*den(276)
  den(464) = den(111)*den(278)
  den(465) = den(113)*den(276)
  den(466) = den(113)*den(278)
  den(467) = den(242)*den(276)
  den(468) = den(242)*den(278)
  den(469) = den(245)*den(276)
  den(470) = den(245)*den(278)
  den(471) = den(84)*den(242)
  den(472) = den(86)*den(242)
  den(473) = den(84)*den(245)
  den(474) = den(86)*den(245)
  den(475) = den(111)*den(215)
  den(476) = den(113)*den(215)
  den(477) = den(111)*den(219)
  den(478) = den(113)*den(219)
  den(480) = den(15)*den(479)
  den(481) = den(2)*den(480)
  den(482) = den(8)*den(480)
  den(483) = den(21)*den(479)
  den(484) = den(2)*den(483)
  den(485) = den(8)*den(483)
  den(487) = den(4)*den(486)
  den(488) = den(1)*den(487)
  den(489) = den(9)*den(486)
  den(490) = den(1)*den(489)
  den(491) = den(11)*den(487)
  den(492) = den(11)*den(489)
  den(494) = den(34)*den(493)
  den(495) = den(2)*den(494)
  den(496) = den(8)*den(494)
  den(497) = den(40)*den(493)
  den(498) = den(2)*den(497)
  den(499) = den(8)*den(497)
  den(501) = den(25)*den(500)
  den(502) = den(1)*den(501)
  den(503) = den(29)*den(500)
  den(504) = den(1)*den(503)
  den(505) = den(11)*den(501)
  den(506) = den(11)*den(503)
  den(508) = den(156)*den(507)
  den(509) = den(144)*den(508)
  den(510) = den(149)*den(508)
  den(511) = den(162)*den(507)
  den(512) = den(144)*den(511)
  den(513) = den(149)*den(511)
  den(515) = den(145)*den(514)
  den(516) = den(143)*den(515)
  den(517) = den(150)*den(514)
  den(518) = den(143)*den(517)
  den(519) = den(152)*den(515)
  den(520) = den(152)*den(517)
  den(522) = den(174)*den(521)
  den(523) = den(144)*den(522)
  den(524) = den(149)*den(522)
  den(525) = den(180)*den(521)
  den(526) = den(144)*den(525)
  den(527) = den(149)*den(525)
  den(529) = den(165)*den(528)
  den(530) = den(143)*den(529)
  den(531) = den(169)*den(528)
  den(532) = den(143)*den(531)
  den(533) = den(152)*den(529)
  den(534) = den(152)*den(531)
  den(535) = den(3)**2
  den(536) = den(2)*den(535)
  den(537) = den(6)*den(536)
  den(538) = den(8)*den(535)
  den(539) = den(6)*den(538)
  den(540) = den(12)*den(536)
  den(541) = den(12)*den(538)
  den(542) = den(1)*den(535)
  den(543) = den(17)*den(542)
  den(544) = den(19)*den(542)
  den(545) = den(11)*den(535)
  den(546) = den(17)*den(545)
  den(547) = den(19)*den(545)
  den(548) = den(6)*den(487)
  den(549) = den(6)*den(489)
  den(550) = den(12)*den(487)
  den(551) = den(12)*den(489)
  den(552) = den(17)*den(480)
  den(553) = den(19)*den(480)
  den(554) = den(17)*den(483)
  den(555) = den(19)*den(483)
  den(556) = den(27)*den(501)
  den(557) = den(27)*den(503)
  den(558) = den(31)*den(501)
  den(559) = den(31)*den(503)
  den(560) = den(36)*den(494)
  den(561) = den(38)*den(494)
  den(562) = den(36)*den(497)
  den(563) = den(38)*den(497)
  den(564) = den(24)**2
  den(565) = den(2)*den(564)
  den(566) = den(27)*den(565)
  den(567) = den(8)*den(564)
  den(568) = den(27)*den(567)
  den(569) = den(31)*den(565)
  den(570) = den(31)*den(567)
  den(571) = den(1)*den(564)
  den(572) = den(36)*den(571)
  den(573) = den(38)*den(571)
  den(574) = den(11)*den(564)
  den(575) = den(36)*den(574)
  den(576) = den(38)*den(574)
  den(577) = den(17)*den(500)
  den(578) = den(27)*den(577)
  den(579) = den(19)*den(500)
  den(580) = den(27)*den(579)
  den(581) = den(31)*den(577)
  den(582) = den(31)*den(579)
  den(583) = den(6)*den(493)
  den(584) = den(36)*den(583)
  den(585) = den(38)*den(583)
  den(586) = den(12)*den(493)
  den(587) = den(36)*den(586)
  den(588) = den(38)*den(586)
  den(589) = den(27)*den(479)
  den(590) = den(17)*den(589)
  den(591) = den(19)*den(589)
  den(592) = den(31)*den(479)
  den(593) = den(17)*den(592)
  den(594) = den(19)*den(592)
  den(595) = den(36)*den(486)
  den(596) = den(6)*den(595)
  den(597) = den(38)*den(486)
  den(598) = den(6)*den(597)
  den(599) = den(12)*den(595)
  den(600) = den(12)*den(597)
  den(601) = den(100)*den(500)
  den(602) = den(27)*den(601)
  den(603) = den(103)*den(500)
  den(604) = den(27)*den(603)
  den(605) = den(31)*den(601)
  den(606) = den(31)*den(603)
  den(607) = den(100)*den(486)
  den(608) = den(6)*den(607)
  den(609) = den(103)*den(486)
  den(610) = den(6)*den(609)
  den(611) = den(12)*den(607)
  den(612) = den(12)*den(609)
  den(613) = den(111)*den(500)
  den(614) = den(27)*den(613)
  den(615) = den(113)*den(500)
  den(616) = den(27)*den(615)
  den(617) = den(31)*den(613)
  den(618) = den(31)*den(615)
  den(619) = den(111)*den(486)
  den(620) = den(6)*den(619)
  den(621) = den(113)*den(486)
  den(622) = den(6)*den(621)
  den(623) = den(12)*den(619)
  den(624) = den(12)*den(621)
  den(626) = den(75)*den(625)
  den(627) = den(535)*den(626)
  den(629) = den(75)*den(628)
  den(630) = den(535)*den(629)
  den(631) = den(79)*den(625)
  den(632) = den(535)*den(631)
  den(633) = den(79)*den(628)
  den(634) = den(535)*den(633)
  den(635) = den(55)*den(625)
  den(636) = den(535)*den(635)
  den(637) = den(55)*den(628)
  den(638) = den(535)*den(637)
  den(639) = den(60)*den(625)
  den(640) = den(535)*den(639)
  den(641) = den(60)*den(628)
  den(642) = den(535)*den(641)
  den(643) = den(564)*den(626)
  den(644) = den(564)*den(629)
  den(645) = den(564)*den(631)
  den(646) = den(564)*den(633)
  den(647) = den(564)*den(635)
  den(648) = den(564)*den(637)
  den(649) = den(564)*den(639)
  den(650) = den(564)*den(641)
  den(651) = den(144)*den(535)
  den(652) = den(147)*den(651)
  den(653) = den(149)*den(535)
  den(654) = den(147)*den(653)
  den(655) = den(153)*den(651)
  den(656) = den(153)*den(653)
  den(657) = den(143)*den(535)
  den(658) = den(158)*den(657)
  den(659) = den(160)*den(657)
  den(660) = den(152)*den(535)
  den(661) = den(158)*den(660)
  den(662) = den(160)*den(660)
  den(663) = den(147)*den(515)
  den(664) = den(147)*den(517)
  den(665) = den(153)*den(515)
  den(666) = den(153)*den(517)
  den(667) = den(158)*den(508)
  den(668) = den(160)*den(508)
  den(669) = den(158)*den(511)
  den(670) = den(160)*den(511)
  den(671) = den(167)*den(529)
  den(672) = den(167)*den(531)
  den(673) = den(171)*den(529)
  den(674) = den(171)*den(531)
  den(675) = den(176)*den(522)
  den(676) = den(178)*den(522)
  den(677) = den(176)*den(525)
  den(678) = den(178)*den(525)
  den(679) = den(144)*den(564)
  den(680) = den(167)*den(679)
  den(681) = den(149)*den(564)
  den(682) = den(167)*den(681)
  den(683) = den(171)*den(679)
  den(684) = den(171)*den(681)
  den(685) = den(143)*den(564)
  den(686) = den(176)*den(685)
  den(687) = den(178)*den(685)
  den(688) = den(152)*den(564)
  den(689) = den(176)*den(688)
  den(690) = den(178)*den(688)
  den(691) = den(158)*den(528)
  den(692) = den(167)*den(691)
  den(693) = den(160)*den(528)
  den(694) = den(167)*den(693)
  den(695) = den(171)*den(691)
  den(696) = den(171)*den(693)
  den(697) = den(147)*den(521)
  den(698) = den(176)*den(697)
  den(699) = den(178)*den(697)
  den(700) = den(153)*den(521)
  den(701) = den(176)*den(700)
  den(702) = den(178)*den(700)
  den(703) = den(167)*den(507)
  den(704) = den(158)*den(703)
  den(705) = den(160)*den(703)
  den(706) = den(171)*den(507)
  den(707) = den(158)*den(706)
  den(708) = den(160)*den(706)
  den(709) = den(176)*den(514)
  den(710) = den(147)*den(709)
  den(711) = den(178)*den(514)
  den(712) = den(147)*den(711)
  den(713) = den(153)*den(709)
  den(714) = den(153)*den(711)
  den(715) = den(231)*den(521)
  den(716) = den(176)*den(715)
  den(717) = den(234)*den(521)
  den(718) = den(176)*den(717)
  den(719) = den(178)*den(715)
  den(720) = den(178)*den(717)
  den(721) = den(231)*den(507)
  den(722) = den(158)*den(721)
  den(723) = den(234)*den(507)
  den(724) = den(158)*den(723)
  den(725) = den(160)*den(721)
  den(726) = den(160)*den(723)
  den(727) = den(242)*den(507)
  den(728) = den(158)*den(727)
  den(729) = den(160)*den(727)
  den(730) = den(245)*den(507)
  den(731) = den(158)*den(730)
  den(732) = den(160)*den(730)
  den(733) = den(242)*den(521)
  den(734) = den(176)*den(733)
  den(735) = den(178)*den(733)
  den(736) = den(245)*den(521)
  den(737) = den(176)*den(736)
  den(738) = den(178)*den(736)
  den(739) = den(207)*den(625)
  den(740) = den(535)*den(739)
  den(741) = den(207)*den(628)
  den(742) = den(535)*den(741)
  den(743) = den(210)*den(625)
  den(744) = den(535)*den(743)
  den(745) = den(210)*den(628)
  den(746) = den(535)*den(745)
  den(747) = den(194)*den(625)
  den(748) = den(535)*den(747)
  den(749) = den(198)*den(625)
  den(750) = den(535)*den(749)
  den(751) = den(194)*den(628)
  den(752) = den(535)*den(751)
  den(753) = den(198)*den(628)
  den(754) = den(535)*den(753)
  den(755) = den(564)*den(739)
  den(756) = den(564)*den(741)
  den(757) = den(564)*den(743)
  den(758) = den(564)*den(745)
  den(759) = den(564)*den(747)
  den(760) = den(564)*den(749)
  den(761) = den(564)*den(751)
  den(762) = den(564)*den(753)
  den(763) = den(308)*den(528)
  den(764) = den(167)*den(763)
  den(765) = den(311)*den(528)
  den(766) = den(167)*den(765)
  den(767) = den(171)*den(763)
  den(768) = den(171)*den(765)
  den(769) = den(308)*den(514)
  den(770) = den(147)*den(769)
  den(771) = den(311)*den(514)
  den(772) = den(147)*den(771)
  den(773) = den(153)*den(769)
  den(774) = den(153)*den(771)
  den(775) = den(319)*den(528)
  den(776) = den(167)*den(775)
  den(777) = den(321)*den(528)
  den(778) = den(167)*den(777)
  den(779) = den(171)*den(775)
  den(780) = den(171)*den(777)
  den(781) = den(319)*den(514)
  den(782) = den(147)*den(781)
  den(783) = den(321)*den(514)
  den(784) = den(147)*den(783)
  den(785) = den(153)*den(781)
  den(786) = den(153)*den(783)
  den(787) = den(286)*den(625)
  den(788) = den(535)*den(787)
  den(789) = den(286)*den(628)
  den(790) = den(535)*den(789)
  den(791) = den(290)*den(625)
  den(792) = den(535)*den(791)
  den(793) = den(290)*den(628)
  den(794) = den(535)*den(793)
  den(795) = den(268)*den(625)
  den(796) = den(535)*den(795)
  den(797) = den(268)*den(628)
  den(798) = den(535)*den(797)
  den(799) = den(271)*den(625)
  den(800) = den(535)*den(799)
  den(801) = den(271)*den(628)
  den(802) = den(535)*den(801)
  den(803) = den(564)*den(787)
  den(804) = den(564)*den(789)
  den(805) = den(564)*den(791)
  den(806) = den(564)*den(793)
  den(807) = den(564)*den(795)
  den(808) = den(564)*den(797)
  den(809) = den(564)*den(799)
  den(810) = den(564)*den(801)
  den(811) = den(378)*den(493)
  den(812) = den(36)*den(811)
  den(813) = den(381)*den(493)
  den(814) = den(36)*den(813)
  den(815) = den(38)*den(811)
  den(816) = den(38)*den(813)
  den(817) = den(378)*den(479)
  den(818) = den(17)*den(817)
  den(819) = den(381)*den(479)
  den(820) = den(17)*den(819)
  den(821) = den(19)*den(817)
  den(822) = den(19)*den(819)
  den(823) = den(389)*den(479)
  den(824) = den(17)*den(823)
  den(825) = den(19)*den(823)
  den(826) = den(392)*den(479)
  den(827) = den(17)*den(826)
  den(828) = den(19)*den(826)
  den(829) = den(389)*den(493)
  den(830) = den(36)*den(829)
  den(831) = den(38)*den(829)
  den(832) = den(392)*den(493)
  den(833) = den(36)*den(832)
  den(834) = den(38)*den(832)
  den(835) = den(357)*den(625)
  den(836) = den(535)*den(835)
  den(837) = den(357)*den(628)
  den(838) = den(535)*den(837)
  den(839) = den(360)*den(625)
  den(840) = den(535)*den(839)
  den(841) = den(360)*den(628)
  den(842) = den(535)*den(841)
  den(843) = den(345)*den(625)
  den(844) = den(535)*den(843)
  den(845) = den(348)*den(625)
  den(846) = den(535)*den(845)
  den(847) = den(345)*den(628)
  den(848) = den(535)*den(847)
  den(849) = den(348)*den(628)
  den(850) = den(535)*den(849)
  den(851) = den(564)*den(835)
  den(852) = den(564)*den(837)
  den(853) = den(564)*den(839)
  den(854) = den(564)*den(841)
  den(855) = den(564)*den(843)
  den(856) = den(564)*den(845)
  den(857) = den(564)*den(847)
  den(858) = den(564)*den(849)
  den(859) = den(2)*den(27)
  den(861) = den(859)*den(860)
  den(862) = den(8)*den(27)
  den(863) = den(860)*den(862)
  den(864) = den(2)*den(31)
  den(865) = den(860)*den(864)
  den(866) = den(8)*den(31)
  den(867) = den(860)*den(866)
  den(868) = den(2)*den(6)
  den(870) = den(868)*den(869)
  den(871) = den(6)*den(8)
  den(872) = den(869)*den(871)
  den(873) = den(2)*den(12)
  den(874) = den(869)*den(873)
  den(875) = den(8)*den(12)
  den(876) = den(869)*den(875)
  den(877) = den(1)*den(36)
  den(878) = den(860)*den(877)
  den(879) = den(1)*den(38)
  den(880) = den(860)*den(879)
  den(881) = den(11)*den(36)
  den(882) = den(860)*den(881)
  den(883) = den(11)*den(38)
  den(884) = den(860)*den(883)
  den(885) = den(1)*den(17)
  den(886) = den(869)*den(885)
  den(887) = den(1)*den(19)
  den(888) = den(869)*den(887)
  den(889) = den(11)*den(17)
  den(890) = den(869)*den(889)
  den(891) = den(11)*den(19)
  den(892) = den(869)*den(891)
  den(893) = den(51)*den(55)
  den(895) = den(893)*den(894)
  den(897) = den(893)*den(896)
  den(898) = den(51)*den(60)
  den(899) = den(894)*den(898)
  den(900) = den(896)*den(898)
  den(902) = den(63)*den(901)
  den(903) = den(894)*den(902)
  den(904) = den(896)*den(902)
  den(905) = den(69)*den(901)
  den(906) = den(894)*den(905)
  den(907) = den(896)*den(905)
  den(908) = den(72)*den(75)
  den(909) = den(894)*den(908)
  den(910) = den(896)*den(908)
  den(911) = den(72)*den(79)
  den(912) = den(894)*den(911)
  den(913) = den(896)*den(911)
  den(915) = den(82)*den(914)
  den(916) = den(894)*den(915)
  den(917) = den(896)*den(915)
  den(918) = den(88)*den(914)
  den(919) = den(894)*den(918)
  den(920) = den(896)*den(918)
  den(921) = den(626)*den(860)
  den(922) = den(629)*den(860)
  den(923) = den(631)*den(860)
  den(924) = den(633)*den(860)
  den(925) = den(626)*den(869)
  den(926) = den(629)*den(869)
  den(927) = den(631)*den(869)
  den(928) = den(633)*den(869)
  den(929) = den(75)*den(901)
  den(930) = den(894)*den(929)
  den(931) = den(896)*den(929)
  den(932) = den(79)*den(901)
  den(933) = den(894)*den(932)
  den(934) = den(896)*den(932)
  den(935) = den(635)*den(860)
  den(936) = den(637)*den(860)
  den(937) = den(639)*den(860)
  den(938) = den(641)*den(860)
  den(939) = den(635)*den(869)
  den(940) = den(637)*den(869)
  den(941) = den(639)*den(869)
  den(942) = den(641)*den(869)
  den(943) = den(55)*den(914)
  den(944) = den(894)*den(943)
  den(945) = den(896)*den(943)
  den(946) = den(60)*den(914)
  den(947) = den(894)*den(946)
  den(948) = den(896)*den(946)
  den(949) = den(144)*den(167)
  den(950) = den(860)*den(949)
  den(951) = den(149)*den(167)
  den(952) = den(860)*den(951)
  den(953) = den(144)*den(171)
  den(954) = den(860)*den(953)
  den(955) = den(149)*den(171)
  den(956) = den(860)*den(955)
  den(957) = den(144)*den(147)
  den(958) = den(869)*den(957)
  den(959) = den(147)*den(149)
  den(960) = den(869)*den(959)
  den(961) = den(144)*den(153)
  den(962) = den(869)*den(961)
  den(963) = den(149)*den(153)
  den(964) = den(869)*den(963)
  den(965) = den(143)*den(176)
  den(966) = den(860)*den(965)
  den(967) = den(143)*den(178)
  den(968) = den(860)*den(967)
  den(969) = den(152)*den(176)
  den(970) = den(860)*den(969)
  den(971) = den(152)*den(178)
  den(972) = den(860)*den(971)
  den(973) = den(143)*den(158)
  den(974) = den(869)*den(973)
  den(975) = den(143)*den(160)
  den(976) = den(869)*den(975)
  den(977) = den(152)*den(158)
  den(978) = den(869)*den(977)
  den(979) = den(152)*den(160)
  den(980) = den(869)*den(979)
  den(981) = den(191)*den(194)
  den(982) = den(894)*den(981)
  den(983) = den(896)*den(981)
  den(984) = den(191)*den(198)
  den(985) = den(894)*den(984)
  den(986) = den(896)*den(984)
  den(987) = den(201)*den(901)
  den(988) = den(894)*den(987)
  den(989) = den(896)*den(987)
  den(990) = den(204)*den(901)
  den(991) = den(894)*den(990)
  den(992) = den(896)*den(990)
  den(993) = den(72)*den(207)
  den(994) = den(894)*den(993)
  den(995) = den(896)*den(993)
  den(996) = den(72)*den(210)
  den(997) = den(894)*den(996)
  den(998) = den(896)*den(996)
  den(1000) = den(213)*den(999)
  den(1001) = den(894)*den(1000)
  den(1002) = den(217)*den(999)
  den(1003) = den(894)*den(1002)
  den(1004) = den(896)*den(1000)
  den(1005) = den(896)*den(1002)
  den(1006) = den(739)*den(860)
  den(1007) = den(741)*den(860)
  den(1008) = den(743)*den(860)
  den(1009) = den(745)*den(860)
  den(1010) = den(739)*den(869)
  den(1011) = den(741)*den(869)
  den(1012) = den(743)*den(869)
  den(1013) = den(745)*den(869)
  den(1014) = den(207)*den(901)
  den(1015) = den(894)*den(1014)
  den(1016) = den(896)*den(1014)
  den(1017) = den(210)*den(901)
  den(1018) = den(894)*den(1017)
  den(1019) = den(896)*den(1017)
  den(1020) = den(747)*den(860)
  den(1021) = den(749)*den(860)
  den(1022) = den(751)*den(860)
  den(1023) = den(753)*den(860)
  den(1024) = den(747)*den(869)
  den(1025) = den(749)*den(869)
  den(1026) = den(751)*den(869)
  den(1027) = den(753)*den(869)
  den(1028) = den(194)*den(999)
  den(1029) = den(894)*den(1028)
  den(1030) = den(198)*den(999)
  den(1031) = den(894)*den(1030)
  den(1032) = den(896)*den(1028)
  den(1033) = den(896)*den(1030)
  den(1034) = den(51)*den(268)
  den(1035) = den(894)*den(1034)
  den(1036) = den(896)*den(1034)
  den(1037) = den(51)*den(271)
  den(1038) = den(894)*den(1037)
  den(1039) = den(896)*den(1037)
  den(1041) = den(274)*den(1040)
  den(1042) = den(894)*den(1041)
  den(1043) = den(896)*den(1041)
  den(1044) = den(280)*den(1040)
  den(1045) = den(894)*den(1044)
  den(1046) = den(896)*den(1044)
  den(1047) = den(283)*den(286)
  den(1048) = den(894)*den(1047)
  den(1049) = den(896)*den(1047)
  den(1050) = den(283)*den(290)
  den(1051) = den(894)*den(1050)
  den(1052) = den(896)*den(1050)
  den(1053) = den(293)*den(914)
  den(1054) = den(894)*den(1053)
  den(1055) = den(896)*den(1053)
  den(1056) = den(296)*den(914)
  den(1057) = den(894)*den(1056)
  den(1058) = den(896)*den(1056)
  den(1059) = den(787)*den(860)
  den(1060) = den(789)*den(860)
  den(1061) = den(791)*den(860)
  den(1062) = den(793)*den(860)
  den(1063) = den(787)*den(869)
  den(1064) = den(789)*den(869)
  den(1065) = den(791)*den(869)
  den(1066) = den(793)*den(869)
  den(1067) = den(286)*den(1040)
  den(1068) = den(894)*den(1067)
  den(1069) = den(896)*den(1067)
  den(1070) = den(290)*den(1040)
  den(1071) = den(894)*den(1070)
  den(1072) = den(896)*den(1070)
  den(1073) = den(795)*den(860)
  den(1074) = den(797)*den(860)
  den(1075) = den(799)*den(860)
  den(1076) = den(801)*den(860)
  den(1077) = den(795)*den(869)
  den(1078) = den(797)*den(869)
  den(1079) = den(799)*den(869)
  den(1080) = den(801)*den(869)
  den(1081) = den(268)*den(914)
  den(1082) = den(894)*den(1081)
  den(1083) = den(896)*den(1081)
  den(1084) = den(271)*den(914)
  den(1085) = den(894)*den(1084)
  den(1086) = den(896)*den(1084)
  den(1087) = den(191)*den(345)
  den(1088) = den(894)*den(1087)
  den(1089) = den(896)*den(1087)
  den(1090) = den(191)*den(348)
  den(1091) = den(894)*den(1090)
  den(1092) = den(896)*den(1090)
  den(1093) = den(351)*den(1040)
  den(1094) = den(894)*den(1093)
  den(1095) = den(896)*den(1093)
  den(1096) = den(354)*den(1040)
  den(1097) = den(894)*den(1096)
  den(1098) = den(896)*den(1096)
  den(1099) = den(283)*den(357)
  den(1100) = den(894)*den(1099)
  den(1101) = den(896)*den(1099)
  den(1102) = den(283)*den(360)
  den(1103) = den(894)*den(1102)
  den(1104) = den(896)*den(1102)
  den(1105) = den(363)*den(999)
  den(1106) = den(894)*den(1105)
  den(1107) = den(365)*den(999)
  den(1108) = den(894)*den(1107)
  den(1109) = den(896)*den(1105)
  den(1110) = den(896)*den(1107)
  den(1111) = den(835)*den(860)
  den(1112) = den(837)*den(860)
  den(1113) = den(839)*den(860)
  den(1114) = den(841)*den(860)
  den(1115) = den(835)*den(869)
  den(1116) = den(837)*den(869)
  den(1117) = den(839)*den(869)
  den(1118) = den(841)*den(869)
  den(1119) = den(357)*den(1040)
  den(1120) = den(894)*den(1119)
  den(1121) = den(896)*den(1119)
  den(1122) = den(360)*den(1040)
  den(1123) = den(894)*den(1122)
  den(1124) = den(896)*den(1122)
  den(1125) = den(843)*den(860)
  den(1126) = den(845)*den(860)
  den(1127) = den(847)*den(860)
  den(1128) = den(849)*den(860)
  den(1129) = den(843)*den(869)
  den(1130) = den(845)*den(869)
  den(1131) = den(847)*den(869)
  den(1132) = den(849)*den(869)
  den(1133) = den(345)*den(999)
  den(1134) = den(894)*den(1133)
  den(1135) = den(348)*den(999)
  den(1136) = den(894)*den(1135)
  den(1137) = den(896)*den(1133)
  den(1138) = den(896)*den(1135)
  den(1139) = den(378)*den(901)
  den(1140) = den(894)*den(1139)
  den(1141) = den(896)*den(1139)
  den(1142) = den(381)*den(901)
  den(1143) = den(894)*den(1142)
  den(1144) = den(896)*den(1142)
  den(1145) = den(378)*den(914)
  den(1146) = den(894)*den(1145)
  den(1147) = den(381)*den(914)
  den(1148) = den(894)*den(1147)
  den(1149) = den(896)*den(1145)
  den(1150) = den(896)*den(1147)
  den(1151) = den(231)*den(1040)
  den(1152) = den(894)*den(1151)
  den(1153) = den(896)*den(1151)
  den(1154) = den(234)*den(1040)
  den(1155) = den(894)*den(1154)
  den(1156) = den(896)*den(1154)
  den(1157) = den(231)*den(914)
  den(1158) = den(894)*den(1157)
  den(1159) = den(234)*den(914)
  den(1160) = den(894)*den(1159)
  den(1161) = den(896)*den(1157)
  den(1162) = den(896)*den(1159)
  den(1163) = den(308)*den(901)
  den(1164) = den(894)*den(1163)
  den(1165) = den(896)*den(1163)
  den(1166) = den(311)*den(901)
  den(1167) = den(894)*den(1166)
  den(1168) = den(896)*den(1166)
  den(1169) = den(100)*den(1040)
  den(1170) = den(894)*den(1169)
  den(1171) = den(896)*den(1169)
  den(1172) = den(103)*den(1040)
  den(1173) = den(894)*den(1172)
  den(1174) = den(896)*den(1172)
  den(1175) = den(100)*den(999)
  den(1176) = den(894)*den(1175)
  den(1177) = den(103)*den(999)
  den(1178) = den(894)*den(1177)
  den(1179) = den(896)*den(1175)
  den(1180) = den(896)*den(1177)
  den(1181) = den(308)*den(999)
  den(1182) = den(894)*den(1181)
  den(1183) = den(311)*den(999)
  den(1184) = den(894)*den(1183)
  den(1185) = den(896)*den(1181)
  den(1186) = den(896)*den(1183)
  den(1187) = den(389)*den(901)
  den(1188) = den(894)*den(1187)
  den(1189) = den(896)*den(1187)
  den(1190) = den(392)*den(901)
  den(1191) = den(894)*den(1190)
  den(1192) = den(896)*den(1190)
  den(1193) = den(319)*den(901)
  den(1194) = den(894)*den(1193)
  den(1195) = den(896)*den(1193)
  den(1196) = den(321)*den(901)
  den(1197) = den(894)*den(1196)
  den(1198) = den(896)*den(1196)
  den(1199) = den(389)*den(914)
  den(1200) = den(894)*den(1199)
  den(1201) = den(896)*den(1199)
  den(1202) = den(392)*den(914)
  den(1203) = den(894)*den(1202)
  den(1204) = den(896)*den(1202)
  den(1205) = den(319)*den(999)
  den(1206) = den(894)*den(1205)
  den(1207) = den(321)*den(999)
  den(1208) = den(894)*den(1207)
  den(1209) = den(896)*den(1205)
  den(1210) = den(896)*den(1207)
  den(1211) = den(111)*den(1040)
  den(1212) = den(894)*den(1211)
  den(1213) = den(896)*den(1211)
  den(1214) = den(113)*den(1040)
  den(1215) = den(894)*den(1214)
  den(1216) = den(896)*den(1214)
  den(1217) = den(242)*den(1040)
  den(1218) = den(894)*den(1217)
  den(1219) = den(896)*den(1217)
  den(1220) = den(245)*den(1040)
  den(1221) = den(894)*den(1220)
  den(1222) = den(896)*den(1220)
  den(1223) = den(242)*den(914)
  den(1224) = den(894)*den(1223)
  den(1225) = den(896)*den(1223)
  den(1226) = den(245)*den(914)
  den(1227) = den(894)*den(1226)
  den(1228) = den(896)*den(1226)
  den(1229) = den(111)*den(999)
  den(1230) = den(894)*den(1229)
  den(1231) = den(113)*den(999)
  den(1232) = den(894)*den(1231)
  den(1233) = den(896)*den(1229)
  den(1234) = den(896)*den(1231)
  den(1235) = den(2)*den(3)*den(6)
  den(1236) = den(3)*den(6)*den(8)
  den(1237) = den(2)*den(3)*den(12)
  den(1238) = den(3)*den(8)*den(12)
  den(1239) = den(1)*den(3)*den(17)
  den(1240) = den(1)*den(3)*den(19)
  den(1241) = den(3)*den(11)*den(17)
  den(1242) = den(3)*den(11)*den(19)
  den(1243) = den(1)*den(2)*den(3)
  den(1244) = den(1)*den(3)*den(8)
  den(1245) = den(2)*den(3)*den(11)
  den(1246) = den(3)*den(8)*den(11)
  den(1247) = den(2)*den(24)*den(27)
  den(1248) = den(8)*den(24)*den(27)
  den(1249) = den(2)*den(24)*den(31)
  den(1250) = den(8)*den(24)*den(31)
  den(1251) = den(1)*den(24)*den(36)
  den(1252) = den(1)*den(24)*den(38)
  den(1253) = den(11)*den(24)*den(36)
  den(1254) = den(11)*den(24)*den(38)
  den(1255) = den(1)*den(2)*den(24)
  den(1256) = den(1)*den(8)*den(24)
  den(1257) = den(2)*den(11)*den(24)
  den(1258) = den(8)*den(11)*den(24)
  den(1259) = den(2)*den(589)
  den(1260) = den(8)*den(589)
  den(1261) = den(2)*den(592)
  den(1262) = den(8)*den(592)
  den(1263) = den(2)*den(583)
  den(1264) = den(8)*den(583)
  den(1265) = den(2)*den(586)
  den(1266) = den(8)*den(586)
  den(1267) = den(1)*den(595)
  den(1268) = den(1)*den(597)
  den(1269) = den(11)*den(595)
  den(1270) = den(11)*den(597)
  den(1271) = den(1)*den(577)
  den(1272) = den(1)*den(579)
  den(1273) = den(11)*den(577)
  den(1274) = den(11)*den(579)
  den(1275) = den(1)*den(607)
  den(1276) = den(1)*den(609)
  den(1277) = den(11)*den(607)
  den(1278) = den(11)*den(609)
  den(1279) = den(1)*den(601)
  den(1280) = den(1)*den(603)
  den(1281) = den(11)*den(601)
  den(1282) = den(11)*den(603)
  den(1283) = den(1)*den(100)
  den(1284) = den(1)*den(103)
  den(1285) = den(11)*den(100)
  den(1286) = den(11)*den(103)
  den(1287) = den(1)*den(619)
  den(1288) = den(1)*den(621)
  den(1289) = den(11)*den(619)
  den(1290) = den(11)*den(621)
  den(1291) = den(1)*den(613)
  den(1292) = den(1)*den(615)
  den(1293) = den(11)*den(613)
  den(1294) = den(11)*den(615)
  den(1295) = den(1)*den(111)
  den(1296) = den(1)*den(113)
  den(1297) = den(11)*den(111)
  den(1298) = den(11)*den(113)
  den(1299) = den(3)*den(626)
  den(1300) = den(3)*den(629)
  den(1301) = den(3)*den(631)
  den(1302) = den(3)*den(633)
  den(1303) = den(3)*den(635)
  den(1304) = den(3)*den(637)
  den(1305) = den(3)*den(639)
  den(1306) = den(3)*den(641)
  den(1307) = den(24)*den(626)
  den(1308) = den(24)*den(629)
  den(1309) = den(24)*den(631)
  den(1310) = den(24)*den(633)
  den(1311) = den(24)*den(635)
  den(1312) = den(24)*den(637)
  den(1313) = den(24)*den(639)
  den(1314) = den(24)*den(641)
  den(1315) = den(3)*den(144)*den(147)
  den(1316) = den(3)*den(147)*den(149)
  den(1317) = den(3)*den(144)*den(153)
  den(1318) = den(3)*den(149)*den(153)
  den(1319) = den(3)*den(143)*den(158)
  den(1320) = den(3)*den(143)*den(160)
  den(1321) = den(3)*den(152)*den(158)
  den(1322) = den(3)*den(152)*den(160)
  den(1323) = den(3)*den(143)*den(144)
  den(1324) = den(3)*den(143)*den(149)
  den(1325) = den(3)*den(144)*den(152)
  den(1326) = den(3)*den(149)*den(152)
  den(1327) = den(24)*den(144)*den(167)
  den(1328) = den(24)*den(149)*den(167)
  den(1329) = den(24)*den(144)*den(171)
  den(1330) = den(24)*den(149)*den(171)
  den(1331) = den(24)*den(143)*den(176)
  den(1332) = den(24)*den(143)*den(178)
  den(1333) = den(24)*den(152)*den(176)
  den(1334) = den(24)*den(152)*den(178)
  den(1335) = den(24)*den(143)*den(144)
  den(1336) = den(24)*den(143)*den(149)
  den(1337) = den(24)*den(144)*den(152)
  den(1338) = den(24)*den(149)*den(152)
  den(1339) = den(144)*den(703)
  den(1340) = den(149)*den(703)
  den(1341) = den(144)*den(706)
  den(1342) = den(149)*den(706)
  den(1343) = den(144)*den(697)
  den(1344) = den(149)*den(697)
  den(1345) = den(144)*den(700)
  den(1346) = den(149)*den(700)
  den(1347) = den(143)*den(709)
  den(1348) = den(143)*den(711)
  den(1349) = den(152)*den(709)
  den(1350) = den(152)*den(711)
  den(1351) = den(143)*den(691)
  den(1352) = den(143)*den(693)
  den(1353) = den(152)*den(691)
  den(1354) = den(152)*den(693)
  den(1355) = den(144)*den(721)
  den(1356) = den(144)*den(723)
  den(1357) = den(149)*den(721)
  den(1358) = den(149)*den(723)
  den(1359) = den(144)*den(715)
  den(1360) = den(144)*den(717)
  den(1361) = den(149)*den(715)
  den(1362) = den(149)*den(717)
  den(1363) = den(144)*den(231)
  den(1364) = den(144)*den(234)
  den(1365) = den(149)*den(231)
  den(1366) = den(149)*den(234)
  den(1367) = den(144)*den(727)
  den(1368) = den(149)*den(727)
  den(1369) = den(144)*den(730)
  den(1370) = den(149)*den(730)
  den(1371) = den(144)*den(733)
  den(1372) = den(149)*den(733)
  den(1373) = den(144)*den(736)
  den(1374) = den(149)*den(736)
  den(1375) = den(144)*den(242)
  den(1376) = den(149)*den(242)
  den(1377) = den(144)*den(245)
  den(1378) = den(149)*den(245)
  den(1379) = den(3)*den(739)
  den(1380) = den(3)*den(741)
  den(1381) = den(3)*den(743)
  den(1382) = den(3)*den(745)
  den(1383) = den(3)*den(747)
  den(1384) = den(3)*den(749)
  den(1385) = den(3)*den(751)
  den(1386) = den(3)*den(753)
  den(1387) = den(24)*den(739)
  den(1388) = den(24)*den(741)
  den(1389) = den(24)*den(743)
  den(1390) = den(24)*den(745)
  den(1391) = den(24)*den(747)
  den(1392) = den(24)*den(749)
  den(1393) = den(24)*den(751)
  den(1394) = den(24)*den(753)
  den(1395) = den(143)*den(769)
  den(1396) = den(143)*den(771)
  den(1397) = den(152)*den(769)
  den(1398) = den(152)*den(771)
  den(1399) = den(143)*den(763)
  den(1400) = den(143)*den(765)
  den(1401) = den(152)*den(763)
  den(1402) = den(152)*den(765)
  den(1403) = den(143)*den(308)
  den(1404) = den(143)*den(311)
  den(1405) = den(152)*den(308)
  den(1406) = den(152)*den(311)
  den(1407) = den(143)*den(781)
  den(1408) = den(143)*den(783)
  den(1409) = den(152)*den(781)
  den(1410) = den(152)*den(783)
  den(1411) = den(143)*den(775)
  den(1412) = den(143)*den(777)
  den(1413) = den(152)*den(775)
  den(1414) = den(152)*den(777)
  den(1415) = den(143)*den(319)
  den(1416) = den(143)*den(321)
  den(1417) = den(152)*den(319)
  den(1418) = den(152)*den(321)
  den(1419) = den(3)*den(787)
  den(1420) = den(3)*den(789)
  den(1421) = den(3)*den(791)
  den(1422) = den(3)*den(793)
  den(1423) = den(3)*den(795)
  den(1424) = den(3)*den(797)
  den(1425) = den(3)*den(799)
  den(1426) = den(3)*den(801)
  den(1427) = den(24)*den(787)
  den(1428) = den(24)*den(789)
  den(1429) = den(24)*den(791)
  den(1430) = den(24)*den(793)
  den(1431) = den(24)*den(795)
  den(1432) = den(24)*den(797)
  den(1433) = den(24)*den(799)
  den(1434) = den(24)*den(801)
  den(1435) = den(2)*den(817)
  den(1436) = den(2)*den(819)
  den(1437) = den(8)*den(817)
  den(1438) = den(8)*den(819)
  den(1439) = den(2)*den(811)
  den(1440) = den(2)*den(813)
  den(1441) = den(8)*den(811)
  den(1442) = den(8)*den(813)
  den(1443) = den(2)*den(378)
  den(1444) = den(2)*den(381)
  den(1445) = den(8)*den(378)
  den(1446) = den(8)*den(381)
  den(1447) = den(2)*den(823)
  den(1448) = den(8)*den(823)
  den(1449) = den(2)*den(826)
  den(1450) = den(8)*den(826)
  den(1451) = den(2)*den(829)
  den(1452) = den(8)*den(829)
  den(1453) = den(2)*den(832)
  den(1454) = den(8)*den(832)
  den(1455) = den(2)*den(389)
  den(1456) = den(8)*den(389)
  den(1457) = den(2)*den(392)
  den(1458) = den(8)*den(392)
  den(1459) = den(3)*den(835)
  den(1460) = den(3)*den(837)
  den(1461) = den(3)*den(839)
  den(1462) = den(3)*den(841)
  den(1463) = den(3)*den(843)
  den(1464) = den(3)*den(845)
  den(1465) = den(3)*den(847)
  den(1466) = den(3)*den(849)
  den(1467) = den(24)*den(835)
  den(1468) = den(24)*den(837)
  den(1469) = den(24)*den(839)
  den(1470) = den(24)*den(841)
  den(1471) = den(24)*den(843)
  den(1472) = den(24)*den(845)
  den(1473) = den(24)*den(847)
  den(1474) = den(24)*den(849)
  den(1475) = den(3)*den(870)
  den(1476) = den(3)*den(872)
  den(1477) = den(3)*den(874)
  den(1478) = den(3)*den(876)
  den(1479) = den(3)*den(886)
  den(1480) = den(3)*den(888)
  den(1481) = den(3)*den(890)
  den(1482) = den(3)*den(892)
  den(1483) = den(24)*den(861)
  den(1484) = den(24)*den(863)
  den(1485) = den(24)*den(865)
  den(1486) = den(24)*den(867)
  den(1487) = den(24)*den(878)
  den(1488) = den(24)*den(880)
  den(1489) = den(24)*den(882)
  den(1490) = den(24)*den(884)
  den(1491) = den(3)*den(925)
  den(1492) = den(3)*den(926)
  den(1493) = den(3)*den(927)
  den(1494) = den(3)*den(928)
  den(1495) = den(3)*den(939)
  den(1496) = den(3)*den(940)
  den(1497) = den(3)*den(941)
  den(1498) = den(3)*den(942)
  den(1499) = den(24)*den(921)
  den(1500) = den(24)*den(922)
  den(1501) = den(24)*den(923)
  den(1502) = den(24)*den(924)
  den(1503) = den(24)*den(935)
  den(1504) = den(24)*den(936)
  den(1505) = den(24)*den(937)
  den(1506) = den(24)*den(938)
  den(1507) = den(3)*den(958)
  den(1508) = den(3)*den(960)
  den(1509) = den(3)*den(962)
  den(1510) = den(3)*den(964)
  den(1511) = den(3)*den(974)
  den(1512) = den(3)*den(976)
  den(1513) = den(3)*den(978)
  den(1514) = den(3)*den(980)
  den(1515) = den(24)*den(950)
  den(1516) = den(24)*den(952)
  den(1517) = den(24)*den(954)
  den(1518) = den(24)*den(956)
  den(1519) = den(24)*den(966)
  den(1520) = den(24)*den(968)
  den(1521) = den(24)*den(970)
  den(1522) = den(24)*den(972)
  den(1523) = den(3)*den(1010)
  den(1524) = den(3)*den(1011)
  den(1525) = den(3)*den(1012)
  den(1526) = den(3)*den(1013)
  den(1527) = den(3)*den(1024)
  den(1528) = den(3)*den(1025)
  den(1529) = den(3)*den(1026)
  den(1530) = den(3)*den(1027)
  den(1531) = den(24)*den(1006)
  den(1532) = den(24)*den(1007)
  den(1533) = den(24)*den(1008)
  den(1534) = den(24)*den(1009)
  den(1535) = den(24)*den(1020)
  den(1536) = den(24)*den(1021)
  den(1537) = den(24)*den(1022)
  den(1538) = den(24)*den(1023)
  den(1539) = den(3)*den(1063)
  den(1540) = den(3)*den(1064)
  den(1541) = den(3)*den(1065)
  den(1542) = den(3)*den(1066)
  den(1543) = den(3)*den(1077)
  den(1544) = den(3)*den(1078)
  den(1545) = den(3)*den(1079)
  den(1546) = den(3)*den(1080)
  den(1547) = den(24)*den(1059)
  den(1548) = den(24)*den(1060)
  den(1549) = den(24)*den(1061)
  den(1550) = den(24)*den(1062)
  den(1551) = den(24)*den(1073)
  den(1552) = den(24)*den(1074)
  den(1553) = den(24)*den(1075)
  den(1554) = den(24)*den(1076)
  den(1555) = den(3)*den(1115)
  den(1556) = den(3)*den(1116)
  den(1557) = den(3)*den(1117)
  den(1558) = den(3)*den(1118)
  den(1559) = den(3)*den(1129)
  den(1560) = den(3)*den(1130)
  den(1561) = den(3)*den(1131)
  den(1562) = den(3)*den(1132)
  den(1563) = den(24)*den(1111)
  den(1564) = den(24)*den(1112)
  den(1565) = den(24)*den(1113)
  den(1566) = den(24)*den(1114)
  den(1567) = den(24)*den(1125)
  den(1568) = den(24)*den(1126)
  den(1569) = den(24)*den(1127)
  den(1570) = den(24)*den(1128)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif

! **********************************************************************
subroutine allocate_diagrams()
!-----------------------------------------------------------------------
! After the first Born evaluation, colour-stripped amplitudes and
! colour vectors are initialiased with the minimum number of relevant
! helicity states.
! **********************************************************************
#ifndef PRECISION_dp
  use ol_loop_storage_pplllla_eeexexddxa_1_/**/DREALKIND, only: hel_states
#endif
  implicit none

  if (allocated(A)) deallocate(A)
  if (allocated(M1helarray)) deallocate(M1helarray)
  if (allocated(M1helarray_ct)) deallocate(M1helarray_ct)
  if (allocated(M0_col1_helarray)) deallocate(M0_col1_helarray)
  allocate(A(hel_states,1120))
  allocate(M1helarray(1,hel_states))
  allocate(M1helarray_ct(1,hel_states))
  allocate(M0_col1_helarray(1,hel_states))
#if -1 > 0
  if (allocated(M0M1_hel_cc)) deallocate(M0M1_hel_cc)
  allocate(M0M1_hel_cc(1,hel_states,29))
#endif
end subroutine allocate_diagrams

!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_pplllla_eeexexddxa_1_/**/DREALKIND, only: &
  nhel, Hel, hel_states
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for e- e- e+ e+ down anti-down gamma -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init, ensure_mp_loop_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_settings_pplllla_eeexexddxa_1, only: hel_mem_opt, loopcc
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_pplllla_eeexexddxa_1, only: &
    & external_perm_pplllla_eeexexddxa_1, &
    & external_perm_inv_pplllla_eeexexddxa_1, &
    & extcomb_perm_pplllla_eeexexddxa_1, &
    & average_factor_pplllla_eeexexddxa_1
  use ol_external_pplllla_eeexexddxa_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_pplllla_eeexexddxa_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_pplllla_eeexexddxa_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_pplllla_eeexexddxa_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,7)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(29)
  logical, intent(in) :: qp_kinematics
  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,7)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,7)
#endif
  integer           :: extmasses2(7)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(29)
  complex(REALKIND) :: M1(1), M2(1)
  real(REALKIND)    :: P_scatt_intern(0:3,7)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(29), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak

#if 7 > 3
  integer :: ind_cc_comb(14)
#endif

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(1120)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,1120))
  end if

  call set_parameter("ew_renorm", 0)
  call parameters_flush()
  call ensure_mp_init()
  call ensure_mp_loop_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    call check_forced_parameters()
  end if
  call fac_init_loop()

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, 0, 0, 0, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_pplllla_eeexexddxa_1, 7, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_Q(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_A(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rZERO, H4, ex4, POLSEL(4),4)
  call pol_wf_Q(P(:,5), rZERO, H5, ex5, POLSEL(5),5)
  call pol_wf_A(P(:,6), rZERO, H6, ex6, POLSEL(6),6)
  call pol_wf_V(P(:,7), rZERO, H7, ex7, POLSEL(7),7)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1(:), ex3(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_QA_V(ntry, ex2(:), ex4(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_VQ_A(ntry, ex7(:), ex5(:), wf4(:,3), n3(:,3), t3x4(:,:,3))
  call prop_Q_A(ntry, wf4(:,3), 80, ZERO, 0_intkind1, wf4(:,4), n2(1))
  call vert_AV_Q(ntry, ex6(:), wf4(:,1), wf8(:,1), n3(:,4), t3x8(:,:,1))
  call vert_VQ_A(ntry, wf4(:,2), wf4(:,4), wf16(:,1), n3(:,5), t3x16(:,:,1))
  call prop_A_Q(ntry, wf8(:,1), 37, ZERO, 0_intkind1, wf8(:,2), n2(2))
  call vert_QA_Z(gZl,ntry, ex2(:), ex4(:), wf4(:,5), n3(:,6), t3x4(:,:,4))
  call prop_W_W(ntry, wf4(:,5), 10, MZ, 1_intkind1, wf4(:,6), n2(3))
  call vert_ZQ_A(gZd,ntry, wf4(:,6), wf4(:,4), wf16(:,2), n3(:,7), t3x16(:,:,2))
  call vert_QA_Z(gZl,ntry, ex1(:), ex3(:), wf4(:,7), n3(:,8), t3x4(:,:,5))
  call prop_W_W(ntry, wf4(:,7), 5, MZ, 1_intkind1, wf4(:,8), n2(4))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,8), wf8(:,3), n3(:,9), t3x8(:,:,2))
  call prop_A_Q(ntry, wf8(:,3), 37, ZERO, 0_intkind1, wf8(:,4), n2(5))
  call vert_AV_Q(ntry, ex6(:), wf4(:,2), wf8(:,5), n3(:,10), t3x8(:,:,3))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,4), wf16(:,3), n3(:,11), t3x16(:,:,3))
  call prop_A_Q(ntry, wf8(:,5), 42, ZERO, 0_intkind1, wf8(:,6), n2(6))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,6), wf8(:,7), n3(:,12), t3x8(:,:,4))
  call prop_A_Q(ntry, wf8(:,7), 42, ZERO, 0_intkind1, wf8(:,8), n2(7))
  call vert_ZQ_A(gZd,ntry, wf4(:,8), wf4(:,4), wf16(:,4), n3(:,13), t3x16(:,:,4))
  call vert_AV_Q(ntry, ex6(:), ex7(:), wf4(:,9), n3(:,14), t3x4(:,:,6))
  call prop_A_Q(ntry, wf4(:,9), 96, ZERO, 0_intkind1, wf4(:,10), n2(8))
  call vert_VQ_A(ntry, wf4(:,1), ex5(:), wf8(:,9), n3(:,15), t3x8(:,:,5))
  call vert_AV_Q(ntry, wf4(:,10), wf4(:,2), wf16(:,5), n3(:,16), t3x16(:,:,5))
  call prop_Q_A(ntry, wf8(:,9), 21, ZERO, 0_intkind1, wf8(:,10), n2(9))
  call vert_AZ_Q(gZd,ntry, wf4(:,10), wf4(:,6), wf16(:,6), n3(:,17), t3x16(:,:,6))
  call vert_ZQ_A(gZd,ntry, wf4(:,8), ex5(:), wf8(:,11), n3(:,18), t3x8(:,:,6))
  call prop_Q_A(ntry, wf8(:,11), 21, ZERO, 0_intkind1, wf8(:,12), n2(10))
  call vert_VQ_A(ntry, wf4(:,2), ex5(:), wf8(:,13), n3(:,19), t3x8(:,:,7))
  call vert_AV_Q(ntry, wf4(:,10), wf4(:,1), wf16(:,7), n3(:,20), t3x16(:,:,7))
  call prop_Q_A(ntry, wf8(:,13), 26, ZERO, 0_intkind1, wf8(:,14), n2(11))
  call vert_ZQ_A(gZd,ntry, wf4(:,6), ex5(:), wf8(:,15), n3(:,21), t3x8(:,:,8))
  call prop_Q_A(ntry, wf8(:,15), 26, ZERO, 0_intkind1, wf8(:,16), n2(12))
  call vert_AZ_Q(gZd,ntry, wf4(:,10), wf4(:,8), wf16(:,8), n3(:,22), t3x16(:,:,8))
  call vert_VQ_A(ntry, ex7(:), wf8(:,10), wf16(:,9), n3(:,23), t3x16(:,:,9))
  call vert_VQ_A(ntry, ex7(:), wf8(:,12), wf16(:,10), n3(:,24), t3x16(:,:,10))
  call vert_VQ_A(ntry, ex7(:), wf8(:,14), wf16(:,11), n3(:,25), t3x16(:,:,11))
  call vert_VQ_A(ntry, ex7(:), wf8(:,16), wf16(:,12), n3(:,26), t3x16(:,:,12))
  call vert_VQ_A(ntry, ex7(:), ex2(:), wf4(:,11), n3(:,27), t3x4(:,:,7))
  call vert_QA_V(ntry, ex5(:), ex6(:), wf4(:,12), n3(:,28), t3x4(:,:,8))
  call prop_Q_A(ntry, wf4(:,11), 66, ZERO, 0_intkind1, wf4(:,13), n2(13))
  call vert_AV_Q(ntry, ex4(:), wf4(:,1), wf8(:,17), n3(:,29), t3x8(:,:,9))
  call vert_VQ_A(ntry, wf4(:,12), wf4(:,13), wf16(:,13), n3(:,30), t3x16(:,:,13))
  call prop_A_Q(ntry, wf8(:,17), 13, ZERO, 0_intkind1, wf8(:,18), n2(14))
  call vert_QA_Z(gZd,ntry, ex5(:), ex6(:), wf4(:,14), n3(:,31), t3x4(:,:,9))
  call prop_W_W(ntry, wf4(:,14), 48, MZ, 1_intkind1, wf4(:,15), n2(15))
  call vert_ZQ_A(gZl,ntry, wf4(:,15), wf4(:,13), wf16(:,14), n3(:,32), t3x16(:,:,14))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,8), wf8(:,19), n3(:,33), t3x8(:,:,10))
  call prop_A_Q(ntry, wf8(:,19), 13, ZERO, 0_intkind1, wf8(:,20), n2(16))
  call vert_AV_Q(ntry, ex4(:), wf4(:,12), wf8(:,21), n3(:,34), t3x8(:,:,11))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,13), wf16(:,15), n3(:,35), t3x16(:,:,15))
  call prop_A_Q(ntry, wf8(:,21), 56, ZERO, 0_intkind1, wf8(:,22), n2(17))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,15), wf8(:,23), n3(:,36), t3x8(:,:,12))
  call prop_A_Q(ntry, wf8(:,23), 56, ZERO, 0_intkind1, wf8(:,24), n2(18))
  call vert_ZQ_A(gZl,ntry, wf4(:,8), wf4(:,13), wf16(:,16), n3(:,37), t3x16(:,:,16))
  call vert_AV_Q(ntry, ex4(:), ex7(:), wf4(:,16), n3(:,38), t3x4(:,:,10))
  call prop_A_Q(ntry, wf4(:,16), 72, ZERO, 0_intkind1, wf4(:,17), n2(19))
  call vert_VQ_A(ntry, wf4(:,1), ex2(:), wf8(:,25), n3(:,39), t3x8(:,:,13))
  call vert_AV_Q(ntry, wf4(:,17), wf4(:,12), wf16(:,17), n3(:,40), t3x16(:,:,17))
  call prop_Q_A(ntry, wf8(:,25), 7, ZERO, 0_intkind1, wf8(:,26), n2(20))
  call vert_AZ_Q(gZl,ntry, wf4(:,17), wf4(:,15), wf16(:,18), n3(:,41), t3x16(:,:,18))
  call vert_ZQ_A(gZl,ntry, wf4(:,8), ex2(:), wf8(:,27), n3(:,42), t3x8(:,:,14))
  call prop_Q_A(ntry, wf8(:,27), 7, ZERO, 0_intkind1, wf8(:,28), n2(21))
  call vert_VQ_A(ntry, wf4(:,12), ex2(:), wf8(:,29), n3(:,43), t3x8(:,:,15))
  call vert_AV_Q(ntry, wf4(:,17), wf4(:,1), wf16(:,19), n3(:,44), t3x16(:,:,19))
  call prop_Q_A(ntry, wf8(:,29), 50, ZERO, 0_intkind1, wf8(:,30), n2(22))
  call vert_ZQ_A(gZl,ntry, wf4(:,15), ex2(:), wf8(:,31), n3(:,45), t3x8(:,:,16))
  call prop_Q_A(ntry, wf8(:,31), 50, ZERO, 0_intkind1, wf8(:,32), n2(23))
  call vert_AZ_Q(gZl,ntry, wf4(:,17), wf4(:,8), wf16(:,20), n3(:,46), t3x16(:,:,20))
  call vert_VQ_A(ntry, ex7(:), wf8(:,26), wf16(:,21), n3(:,47), t3x16(:,:,21))
  call vert_VQ_A(ntry, ex7(:), wf8(:,28), wf16(:,22), n3(:,48), t3x16(:,:,22))
  call vert_VQ_A(ntry, ex7(:), wf8(:,30), wf16(:,23), n3(:,49), t3x16(:,:,23))
  call vert_VQ_A(ntry, ex7(:), wf8(:,32), wf16(:,24), n3(:,50), t3x16(:,:,24))
  call vert_QA_V(ntry, wf4(:,13), ex4(:), wf8(:,33), n3(:,51), t3x8(:,:,17))
  call vert_AV_Q(ntry, ex6(:), wf8(:,33), wf16(:,25), n3(:,52), t3x16(:,:,25))
  call vert_QA_Z(gZl,ntry, wf4(:,13), ex4(:), wf8(:,34), n3(:,53), t3x8(:,:,18))
  call prop_W_W(ntry, wf8(:,34), 74, MZ, 1_intkind1, wf8(:,35), n2(24))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf8(:,35), wf16(:,26), n3(:,54), t3x16(:,:,26))
  call vert_VQ_A(ntry, wf8(:,33), ex5(:), wf16(:,27), n3(:,55), t3x16(:,:,27))
  call vert_ZQ_A(gZd,ntry, wf8(:,35), ex5(:), wf16(:,28), n3(:,56), t3x16(:,:,28))
  call vert_QA_V(ntry, ex2(:), wf4(:,17), wf8(:,36), n3(:,57), t3x8(:,:,19))
  call vert_AV_Q(ntry, ex6(:), wf8(:,36), wf16(:,29), n3(:,58), t3x16(:,:,29))
  call vert_QA_Z(gZl,ntry, ex2(:), wf4(:,17), wf8(:,37), n3(:,59), t3x8(:,:,20))
  call prop_W_W(ntry, wf8(:,37), 74, MZ, 1_intkind1, wf8(:,38), n2(25))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf8(:,38), wf16(:,30), n3(:,60), t3x16(:,:,30))
  call vert_VQ_A(ntry, wf8(:,36), ex5(:), wf16(:,31), n3(:,61), t3x16(:,:,31))
  call vert_ZQ_A(gZd,ntry, wf8(:,38), ex5(:), wf16(:,32), n3(:,62), t3x16(:,:,32))
  call vert_QA_V(ntry, wf4(:,4), ex6(:), wf8(:,39), n3(:,63), t3x8(:,:,21))
  call vert_QA_V(ntry, wf8(:,26), ex4(:), wf16(:,33), n3(:,64), t3x16(:,:,33))
  call vert_QA_Z(gZd,ntry, wf4(:,4), ex6(:), wf8(:,40), n3(:,65), t3x8(:,:,22))
  call prop_W_W(ntry, wf8(:,40), 112, MZ, 1_intkind1, wf8(:,41), n2(26))
  call vert_QA_Z(gZl,ntry, wf8(:,26), ex4(:), wf16(:,34), n3(:,66), t3x16(:,:,34))
  call vert_QA_V(ntry, wf8(:,28), ex4(:), wf16(:,35), n3(:,67), t3x16(:,:,35))
  call vert_QA_Z(gZl,ntry, wf8(:,28), ex4(:), wf16(:,36), n3(:,68), t3x16(:,:,36))
  call vert_QA_V(ntry, ex2(:), wf8(:,18), wf16(:,37), n3(:,69), t3x16(:,:,37))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,18), wf16(:,38), n3(:,70), t3x16(:,:,38))
  call vert_QA_V(ntry, ex2(:), wf8(:,20), wf16(:,39), n3(:,71), t3x16(:,:,39))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,20), wf16(:,40), n3(:,72), t3x16(:,:,40))
  call vert_QA_V(ntry, ex5(:), wf4(:,10), wf8(:,42), n3(:,73), t3x8(:,:,23))
  call vert_QA_Z(gZd,ntry, ex5(:), wf4(:,10), wf8(:,43), n3(:,74), t3x8(:,:,24))
  call prop_W_W(ntry, wf8(:,43), 112, MZ, 1_intkind1, wf8(:,44), n2(27))
  call vert_QA_V(ntry, ex1(:), ex4(:), wf4(:,18), n3(:,75), t3x4(:,:,11))
  call vert_QA_V(ntry, ex2(:), ex3(:), wf4(:,19), n3(:,76), t3x4(:,:,12))
  call vert_AV_Q(ntry, ex6(:), wf4(:,18), wf8(:,45), n3(:,77), t3x8(:,:,25))
  call vert_VQ_A(ntry, wf4(:,19), wf4(:,4), wf16(:,41), n3(:,78), t3x16(:,:,41))
  call prop_A_Q(ntry, wf8(:,45), 41, ZERO, 0_intkind1, wf8(:,46), n2(28))
  call vert_QA_Z(gZl,ntry, ex2(:), ex3(:), wf4(:,20), n3(:,79), t3x4(:,:,13))
  call prop_W_W(ntry, wf4(:,20), 6, MZ, 1_intkind1, wf4(:,21), n2(29))
  call vert_ZQ_A(gZd,ntry, wf4(:,21), wf4(:,4), wf16(:,42), n3(:,80), t3x16(:,:,42))
  call vert_QA_Z(gZl,ntry, ex1(:), ex4(:), wf4(:,22), n3(:,81), t3x4(:,:,14))
  call prop_W_W(ntry, wf4(:,22), 9, MZ, 1_intkind1, wf4(:,23), n2(30))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,23), wf8(:,47), n3(:,82), t3x8(:,:,26))
  call prop_A_Q(ntry, wf8(:,47), 41, ZERO, 0_intkind1, wf8(:,48), n2(31))
  call vert_AV_Q(ntry, ex6(:), wf4(:,19), wf8(:,49), n3(:,83), t3x8(:,:,27))
  call vert_VQ_A(ntry, wf4(:,18), wf4(:,4), wf16(:,43), n3(:,84), t3x16(:,:,43))
  call prop_A_Q(ntry, wf8(:,49), 38, ZERO, 0_intkind1, wf8(:,50), n2(32))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,21), wf8(:,51), n3(:,85), t3x8(:,:,28))
  call prop_A_Q(ntry, wf8(:,51), 38, ZERO, 0_intkind1, wf8(:,52), n2(33))
  call vert_ZQ_A(gZd,ntry, wf4(:,23), wf4(:,4), wf16(:,44), n3(:,86), t3x16(:,:,44))
  call vert_VQ_A(ntry, wf4(:,18), ex5(:), wf8(:,53), n3(:,87), t3x8(:,:,29))
  call vert_AV_Q(ntry, wf4(:,10), wf4(:,19), wf16(:,45), n3(:,88), t3x16(:,:,45))
  call prop_Q_A(ntry, wf8(:,53), 25, ZERO, 0_intkind1, wf8(:,54), n2(34))
  call vert_AZ_Q(gZd,ntry, wf4(:,10), wf4(:,21), wf16(:,46), n3(:,89), t3x16(:,:,46))
  call vert_ZQ_A(gZd,ntry, wf4(:,23), ex5(:), wf8(:,55), n3(:,90), t3x8(:,:,30))
  call prop_Q_A(ntry, wf8(:,55), 25, ZERO, 0_intkind1, wf8(:,56), n2(35))
  call vert_VQ_A(ntry, wf4(:,19), ex5(:), wf8(:,57), n3(:,91), t3x8(:,:,31))
  call vert_AV_Q(ntry, wf4(:,10), wf4(:,18), wf16(:,47), n3(:,92), t3x16(:,:,47))
  call prop_Q_A(ntry, wf8(:,57), 22, ZERO, 0_intkind1, wf8(:,58), n2(36))
  call vert_ZQ_A(gZd,ntry, wf4(:,21), ex5(:), wf8(:,59), n3(:,93), t3x8(:,:,32))
  call prop_Q_A(ntry, wf8(:,59), 22, ZERO, 0_intkind1, wf8(:,60), n2(37))
  call vert_AZ_Q(gZd,ntry, wf4(:,10), wf4(:,23), wf16(:,48), n3(:,94), t3x16(:,:,48))
  call vert_VQ_A(ntry, ex7(:), wf8(:,54), wf16(:,49), n3(:,95), t3x16(:,:,49))
  call vert_VQ_A(ntry, ex7(:), wf8(:,56), wf16(:,50), n3(:,96), t3x16(:,:,50))
  call vert_VQ_A(ntry, ex7(:), wf8(:,58), wf16(:,51), n3(:,97), t3x16(:,:,51))
  call vert_VQ_A(ntry, ex7(:), wf8(:,60), wf16(:,52), n3(:,98), t3x16(:,:,52))
  call vert_VQ_A(ntry, ex7(:), ex1(:), wf4(:,24), n3(:,99), t3x4(:,:,15))
  call prop_Q_A(ntry, wf4(:,24), 65, ZERO, 0_intkind1, wf4(:,25), n2(38))
  call vert_AV_Q(ntry, ex4(:), wf4(:,19), wf8(:,61), n3(:,100), t3x8(:,:,33))
  call vert_VQ_A(ntry, wf4(:,12), wf4(:,25), wf16(:,53), n3(:,101), t3x16(:,:,53))
  call prop_A_Q(ntry, wf8(:,61), 14, ZERO, 0_intkind1, wf8(:,62), n2(39))
  call vert_ZQ_A(gZl,ntry, wf4(:,15), wf4(:,25), wf16(:,54), n3(:,102), t3x16(:,:,54))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,21), wf8(:,63), n3(:,103), t3x8(:,:,34))
  call prop_A_Q(ntry, wf8(:,63), 14, ZERO, 0_intkind1, wf8(:,64), n2(40))
  call vert_VQ_A(ntry, wf4(:,19), wf4(:,25), wf16(:,55), n3(:,104), t3x16(:,:,55))
  call vert_ZQ_A(gZl,ntry, wf4(:,21), wf4(:,25), wf16(:,56), n3(:,105), t3x16(:,:,56))
  call vert_VQ_A(ntry, wf4(:,19), ex1(:), wf8(:,65), n3(:,106), t3x8(:,:,35))
  call prop_Q_A(ntry, wf8(:,65), 7, ZERO, 0_intkind1, wf8(:,66), n2(41))
  call vert_ZQ_A(gZl,ntry, wf4(:,21), ex1(:), wf8(:,67), n3(:,107), t3x8(:,:,36))
  call prop_Q_A(ntry, wf8(:,67), 7, ZERO, 0_intkind1, wf8(:,68), n2(42))
  call vert_VQ_A(ntry, wf4(:,12), ex1(:), wf8(:,69), n3(:,108), t3x8(:,:,37))
  call vert_AV_Q(ntry, wf4(:,17), wf4(:,19), wf16(:,57), n3(:,109), t3x16(:,:,57))
  call prop_Q_A(ntry, wf8(:,69), 49, ZERO, 0_intkind1, wf8(:,70), n2(43))
  call vert_AZ_Q(gZl,ntry, wf4(:,17), wf4(:,21), wf16(:,58), n3(:,110), t3x16(:,:,58))
  call vert_ZQ_A(gZl,ntry, wf4(:,15), ex1(:), wf8(:,71), n3(:,111), t3x8(:,:,38))
  call prop_Q_A(ntry, wf8(:,71), 49, ZERO, 0_intkind1, wf8(:,72), n2(44))
  call vert_VQ_A(ntry, ex7(:), wf8(:,66), wf16(:,59), n3(:,112), t3x16(:,:,59))
  call vert_VQ_A(ntry, ex7(:), wf8(:,68), wf16(:,60), n3(:,113), t3x16(:,:,60))
  call vert_VQ_A(ntry, ex7(:), wf8(:,70), wf16(:,61), n3(:,114), t3x16(:,:,61))
  call vert_VQ_A(ntry, ex7(:), wf8(:,72), wf16(:,62), n3(:,115), t3x16(:,:,62))
  call vert_QA_V(ntry, wf4(:,25), ex4(:), wf8(:,73), n3(:,116), t3x8(:,:,39))
  call vert_AV_Q(ntry, ex6(:), wf8(:,73), wf16(:,63), n3(:,117), t3x16(:,:,63))
  call vert_QA_Z(gZl,ntry, wf4(:,25), ex4(:), wf8(:,74), n3(:,118), t3x8(:,:,40))
  call prop_W_W(ntry, wf8(:,74), 73, MZ, 1_intkind1, wf8(:,75), n2(45))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf8(:,75), wf16(:,64), n3(:,119), t3x16(:,:,64))
  call vert_VQ_A(ntry, wf8(:,73), ex5(:), wf16(:,65), n3(:,120), t3x16(:,:,65))
  call vert_ZQ_A(gZd,ntry, wf8(:,75), ex5(:), wf16(:,66), n3(:,121), t3x16(:,:,66))
  call vert_QA_V(ntry, ex1(:), wf4(:,17), wf8(:,76), n3(:,122), t3x8(:,:,41))
  call vert_VQ_A(ntry, wf8(:,76), ex5(:), wf16(:,67), n3(:,123), t3x16(:,:,67))
  call vert_QA_Z(gZl,ntry, ex1(:), wf4(:,17), wf8(:,77), n3(:,124), t3x8(:,:,42))
  call prop_W_W(ntry, wf8(:,77), 73, MZ, 1_intkind1, wf8(:,78), n2(46))
  call vert_ZQ_A(gZd,ntry, wf8(:,78), ex5(:), wf16(:,68), n3(:,125), t3x16(:,:,68))
  call vert_AV_Q(ntry, ex6(:), wf8(:,76), wf16(:,69), n3(:,126), t3x16(:,:,69))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf8(:,78), wf16(:,70), n3(:,127), t3x16(:,:,70))
  call vert_QA_V(ntry, wf8(:,66), ex4(:), wf16(:,71), n3(:,128), t3x16(:,:,71))
  call vert_QA_Z(gZl,ntry, wf8(:,66), ex4(:), wf16(:,72), n3(:,129), t3x16(:,:,72))
  call vert_QA_V(ntry, wf8(:,68), ex4(:), wf16(:,73), n3(:,130), t3x16(:,:,73))
  call vert_QA_Z(gZl,ntry, wf8(:,68), ex4(:), wf16(:,74), n3(:,131), t3x16(:,:,74))
  call vert_QA_V(ntry, ex1(:), wf8(:,62), wf16(:,75), n3(:,132), t3x16(:,:,75))
  call vert_QA_V(ntry, ex1(:), wf8(:,64), wf16(:,76), n3(:,133), t3x16(:,:,76))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,62), wf16(:,77), n3(:,134), t3x16(:,:,77))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,64), wf16(:,78), n3(:,135), t3x16(:,:,78))
  call vert_AV_Q(ntry, ex3(:), wf4(:,18), wf8(:,79), n3(:,136), t3x8(:,:,43))
  call prop_A_Q(ntry, wf8(:,79), 13, ZERO, 0_intkind1, wf8(:,80), n2(47))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf4(:,23), wf8(:,81), n3(:,137), t3x8(:,:,44))
  call prop_A_Q(ntry, wf8(:,81), 13, ZERO, 0_intkind1, wf8(:,82), n2(48))
  call vert_AV_Q(ntry, ex3(:), wf4(:,12), wf8(:,83), n3(:,138), t3x8(:,:,45))
  call vert_VQ_A(ntry, wf4(:,18), wf4(:,13), wf16(:,79), n3(:,139), t3x16(:,:,79))
  call prop_A_Q(ntry, wf8(:,83), 52, ZERO, 0_intkind1, wf8(:,84), n2(49))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf4(:,15), wf8(:,85), n3(:,140), t3x8(:,:,46))
  call prop_A_Q(ntry, wf8(:,85), 52, ZERO, 0_intkind1, wf8(:,86), n2(50))
  call vert_ZQ_A(gZl,ntry, wf4(:,23), wf4(:,13), wf16(:,80), n3(:,141), t3x16(:,:,80))
  call vert_AV_Q(ntry, ex3(:), ex7(:), wf4(:,26), n3(:,142), t3x4(:,:,16))
  call prop_A_Q(ntry, wf4(:,26), 68, ZERO, 0_intkind1, wf4(:,27), n2(51))
  call vert_VQ_A(ntry, wf4(:,18), ex2(:), wf8(:,87), n3(:,143), t3x8(:,:,47))
  call vert_AV_Q(ntry, wf4(:,27), wf4(:,12), wf16(:,81), n3(:,144), t3x16(:,:,81))
  call prop_Q_A(ntry, wf8(:,87), 11, ZERO, 0_intkind1, wf8(:,88), n2(52))
  call vert_AZ_Q(gZl,ntry, wf4(:,27), wf4(:,15), wf16(:,82), n3(:,145), t3x16(:,:,82))
  call vert_ZQ_A(gZl,ntry, wf4(:,23), ex2(:), wf8(:,89), n3(:,146), t3x8(:,:,48))
  call prop_Q_A(ntry, wf8(:,89), 11, ZERO, 0_intkind1, wf8(:,90), n2(53))
  call vert_AV_Q(ntry, wf4(:,27), wf4(:,18), wf16(:,83), n3(:,147), t3x16(:,:,83))
  call vert_AZ_Q(gZl,ntry, wf4(:,27), wf4(:,23), wf16(:,84), n3(:,148), t3x16(:,:,84))
  call vert_VQ_A(ntry, ex7(:), wf8(:,88), wf16(:,85), n3(:,149), t3x16(:,:,85))
  call vert_VQ_A(ntry, ex7(:), wf8(:,90), wf16(:,86), n3(:,150), t3x16(:,:,86))
  call vert_QA_V(ntry, wf4(:,13), ex3(:), wf8(:,91), n3(:,151), t3x8(:,:,49))
  call vert_AV_Q(ntry, ex6(:), wf8(:,91), wf16(:,87), n3(:,152), t3x16(:,:,87))
  call vert_QA_Z(gZl,ntry, wf4(:,13), ex3(:), wf8(:,92), n3(:,153), t3x8(:,:,50))
  call prop_W_W(ntry, wf8(:,92), 70, MZ, 1_intkind1, wf8(:,93), n2(54))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf8(:,93), wf16(:,88), n3(:,154), t3x16(:,:,88))
  call vert_VQ_A(ntry, wf8(:,91), ex5(:), wf16(:,89), n3(:,155), t3x16(:,:,89))
  call vert_ZQ_A(gZd,ntry, wf8(:,93), ex5(:), wf16(:,90), n3(:,156), t3x16(:,:,90))
  call vert_QA_V(ntry, ex2(:), wf4(:,27), wf8(:,94), n3(:,157), t3x8(:,:,51))
  call vert_AV_Q(ntry, ex6(:), wf8(:,94), wf16(:,91), n3(:,158), t3x16(:,:,91))
  call vert_QA_Z(gZl,ntry, ex2(:), wf4(:,27), wf8(:,95), n3(:,159), t3x8(:,:,52))
  call prop_W_W(ntry, wf8(:,95), 70, MZ, 1_intkind1, wf8(:,96), n2(55))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf8(:,96), wf16(:,92), n3(:,160), t3x16(:,:,92))
  call vert_VQ_A(ntry, wf8(:,94), ex5(:), wf16(:,93), n3(:,161), t3x16(:,:,93))
  call vert_ZQ_A(gZd,ntry, wf8(:,96), ex5(:), wf16(:,94), n3(:,162), t3x16(:,:,94))
  call vert_QA_V(ntry, wf8(:,88), ex3(:), wf16(:,95), n3(:,163), t3x16(:,:,95))
  call vert_QA_Z(gZl,ntry, wf8(:,88), ex3(:), wf16(:,96), n3(:,164), t3x16(:,:,96))
  call vert_QA_V(ntry, wf8(:,90), ex3(:), wf16(:,97), n3(:,165), t3x16(:,:,97))
  call vert_QA_Z(gZl,ntry, wf8(:,90), ex3(:), wf16(:,98), n3(:,166), t3x16(:,:,98))
  call vert_QA_V(ntry, ex2(:), wf8(:,80), wf16(:,99), n3(:,167), t3x16(:,:,99))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,80), wf16(:,100), n3(:,168), t3x16(:,:,100))
  call vert_QA_V(ntry, ex2(:), wf8(:,82), wf16(:,101), n3(:,169), t3x16(:,:,101))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,82), wf16(:,102), n3(:,170), t3x16(:,:,102))
  call vert_AV_Q(ntry, ex3(:), wf4(:,2), wf8(:,97), n3(:,171), t3x8(:,:,53))
  call prop_A_Q(ntry, wf8(:,97), 14, ZERO, 0_intkind1, wf8(:,98), n2(56))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf4(:,6), wf8(:,99), n3(:,172), t3x8(:,:,54))
  call prop_A_Q(ntry, wf8(:,99), 14, ZERO, 0_intkind1, wf8(:,100), n2(57))
  call vert_VQ_A(ntry, wf4(:,2), wf4(:,25), wf16(:,103), n3(:,173), t3x16(:,:,103))
  call vert_ZQ_A(gZl,ntry, wf4(:,6), wf4(:,25), wf16(:,104), n3(:,174), t3x16(:,:,104))
  call vert_VQ_A(ntry, wf4(:,2), ex1(:), wf8(:,101), n3(:,175), t3x8(:,:,55))
  call prop_Q_A(ntry, wf8(:,101), 11, ZERO, 0_intkind1, wf8(:,102), n2(58))
  call vert_ZQ_A(gZl,ntry, wf4(:,6), ex1(:), wf8(:,103), n3(:,176), t3x8(:,:,56))
  call prop_Q_A(ntry, wf8(:,103), 11, ZERO, 0_intkind1, wf8(:,104), n2(59))
  call vert_AV_Q(ntry, wf4(:,27), wf4(:,2), wf16(:,105), n3(:,177), t3x16(:,:,105))
  call vert_AZ_Q(gZl,ntry, wf4(:,27), wf4(:,6), wf16(:,106), n3(:,178), t3x16(:,:,106))
  call vert_VQ_A(ntry, ex7(:), wf8(:,102), wf16(:,107), n3(:,179), t3x16(:,:,107))
  call vert_VQ_A(ntry, ex7(:), wf8(:,104), wf16(:,108), n3(:,180), t3x16(:,:,108))
  call vert_QA_V(ntry, wf4(:,25), ex3(:), wf8(:,105), n3(:,181), t3x8(:,:,57))
  call vert_AV_Q(ntry, ex6(:), wf8(:,105), wf16(:,109), n3(:,182), t3x16(:,:,109))
  call vert_QA_Z(gZl,ntry, wf4(:,25), ex3(:), wf8(:,106), n3(:,183), t3x8(:,:,58))
  call prop_W_W(ntry, wf8(:,106), 69, MZ, 1_intkind1, wf8(:,107), n2(60))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf8(:,107), wf16(:,110), n3(:,184), t3x16(:,:,110))
  call vert_VQ_A(ntry, wf8(:,105), ex5(:), wf16(:,111), n3(:,185), t3x16(:,:,111))
  call vert_ZQ_A(gZd,ntry, wf8(:,107), ex5(:), wf16(:,112), n3(:,186), t3x16(:,:,112))
  call vert_QA_V(ntry, ex1(:), wf4(:,27), wf8(:,108), n3(:,187), t3x8(:,:,59))
  call vert_VQ_A(ntry, wf8(:,108), ex5(:), wf16(:,113), n3(:,188), t3x16(:,:,113))
  call vert_QA_Z(gZl,ntry, ex1(:), wf4(:,27), wf8(:,109), n3(:,189), t3x8(:,:,60))
  call prop_W_W(ntry, wf8(:,109), 69, MZ, 1_intkind1, wf8(:,110), n2(61))
  call vert_ZQ_A(gZd,ntry, wf8(:,110), ex5(:), wf16(:,114), n3(:,190), t3x16(:,:,114))
  call vert_AV_Q(ntry, ex6(:), wf8(:,108), wf16(:,115), n3(:,191), t3x16(:,:,115))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf8(:,110), wf16(:,116), n3(:,192), t3x16(:,:,116))
  call vert_QA_V(ntry, wf8(:,102), ex3(:), wf16(:,117), n3(:,193), t3x16(:,:,117))
  call vert_QA_Z(gZl,ntry, wf8(:,102), ex3(:), wf16(:,118), n3(:,194), t3x16(:,:,118))
  call vert_QA_V(ntry, wf8(:,104), ex3(:), wf16(:,119), n3(:,195), t3x16(:,:,119))
  call vert_QA_Z(gZl,ntry, wf8(:,104), ex3(:), wf16(:,120), n3(:,196), t3x16(:,:,120))
  call vert_QA_V(ntry, ex1(:), wf8(:,98), wf16(:,121), n3(:,197), t3x16(:,:,121))
  call vert_QA_V(ntry, ex1(:), wf8(:,100), wf16(:,122), n3(:,198), t3x16(:,:,122))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,98), wf16(:,123), n3(:,199), t3x16(:,:,123))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,100), wf16(:,124), n3(:,200), t3x16(:,:,124))
  call vert_VQ_A(ntry, wf8(:,105), ex2(:), wf16(:,125), n3(:,201), t3x16(:,:,125))
  call vert_ZQ_A(gZl,ntry, wf8(:,107), ex2(:), wf16(:,126), n3(:,202), t3x16(:,:,126))
  call vert_QA_V(ntry, wf8(:,30), ex4(:), wf16(:,127), n3(:,203), t3x16(:,:,127))
  call vert_QA_Z(gZl,ntry, wf8(:,30), ex4(:), wf16(:,128), n3(:,204), t3x16(:,:,128))
  call vert_QA_V(ntry, wf8(:,32), ex4(:), wf16(:,129), n3(:,205), t3x16(:,:,129))
  call vert_QA_Z(gZl,ntry, wf8(:,32), ex4(:), wf16(:,130), n3(:,206), t3x16(:,:,130))
  call vert_QA_V(ntry, ex2(:), wf8(:,84), wf16(:,131), n3(:,207), t3x16(:,:,131))
  call vert_QA_V(ntry, ex2(:), wf8(:,86), wf16(:,132), n3(:,208), t3x16(:,:,132))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,84), wf16(:,133), n3(:,209), t3x16(:,:,133))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,86), wf16(:,134), n3(:,210), t3x16(:,:,134))
  call vert_QA_V(ntry, wf8(:,30), ex3(:), wf16(:,135), n3(:,211), t3x16(:,:,135))
  call vert_QA_Z(gZl,ntry, wf8(:,30), ex3(:), wf16(:,136), n3(:,212), t3x16(:,:,136))
  call vert_QA_V(ntry, wf8(:,32), ex3(:), wf16(:,137), n3(:,213), t3x16(:,:,137))
  call vert_QA_Z(gZl,ntry, wf8(:,32), ex3(:), wf16(:,138), n3(:,214), t3x16(:,:,138))
  call vert_VQ_A(ntry, wf8(:,91), ex1(:), wf16(:,139), n3(:,215), t3x16(:,:,139))
  call vert_ZQ_A(gZl,ntry, wf8(:,93), ex1(:), wf16(:,140), n3(:,216), t3x16(:,:,140))
  call vert_QA_V(ntry, ex1(:), wf8(:,84), wf16(:,141), n3(:,217), t3x16(:,:,141))
  call vert_QA_V(ntry, ex1(:), wf8(:,86), wf16(:,142), n3(:,218), t3x16(:,:,142))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,84), wf16(:,143), n3(:,219), t3x16(:,:,143))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,86), wf16(:,144), n3(:,220), t3x16(:,:,144))
  call vert_QA_V(ntry, wf8(:,70), ex3(:), wf16(:,145), n3(:,221), t3x16(:,:,145))
  call vert_QA_Z(gZl,ntry, wf8(:,70), ex3(:), wf16(:,146), n3(:,222), t3x16(:,:,146))
  call vert_QA_V(ntry, wf8(:,72), ex3(:), wf16(:,147), n3(:,223), t3x16(:,:,147))
  call vert_QA_Z(gZl,ntry, wf8(:,72), ex3(:), wf16(:,148), n3(:,224), t3x16(:,:,148))
  call vert_QA_V(ntry, wf8(:,70), ex4(:), wf16(:,149), n3(:,225), t3x16(:,:,149))
  call vert_QA_Z(gZl,ntry, wf8(:,70), ex4(:), wf16(:,150), n3(:,226), t3x16(:,:,150))
  call vert_QA_V(ntry, wf8(:,72), ex4(:), wf16(:,151), n3(:,227), t3x16(:,:,151))
  call vert_QA_Z(gZl,ntry, wf8(:,72), ex4(:), wf16(:,152), n3(:,228), t3x16(:,:,152))
  call vert_VQ_A(ntry, wf8(:,108), ex2(:), wf16(:,153), n3(:,229), t3x16(:,:,153))
  call vert_ZQ_A(gZl,ntry, wf8(:,110), ex2(:), wf16(:,154), n3(:,230), t3x16(:,:,154))
  call vert_VQ_A(ntry, wf8(:,94), ex1(:), wf16(:,155), n3(:,231), t3x16(:,:,155))
  call vert_ZQ_A(gZl,ntry, wf8(:,96), ex1(:), wf16(:,156), n3(:,232), t3x16(:,:,156))
  call vert_AV_Q(ntry, ex4(:), wf8(:,108), wf16(:,157), n3(:,233), t3x16(:,:,157))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf8(:,110), wf16(:,158), n3(:,234), t3x16(:,:,158))
  call vert_VQ_A(ntry, wf8(:,36), ex1(:), wf16(:,159), n3(:,235), t3x16(:,:,159))
  call vert_ZQ_A(gZl,ntry, wf8(:,38), ex1(:), wf16(:,160), n3(:,236), t3x16(:,:,160))
  call vert_VQ_A(ntry, wf8(:,76), ex2(:), wf16(:,161), n3(:,237), t3x16(:,:,161))
  call vert_ZQ_A(gZl,ntry, wf8(:,78), ex2(:), wf16(:,162), n3(:,238), t3x16(:,:,162))
  call vert_AV_Q(ntry, ex3(:), wf8(:,76), wf16(:,163), n3(:,239), t3x16(:,:,163))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf8(:,78), wf16(:,164), n3(:,240), t3x16(:,:,164))
  call counter_VQ_A(ntry, wf4(:,2), wf4(:,4), wf16(:,165), n3(:,241), t3x16(:,:,165))
  call counter_ZQ_A(gZd,ntry, wf4(:,6), wf4(:,4), wf16(:,166), n3(:,242), t3x16(:,:,166))
  call counter_VQ_A(ntry, wf4(:,1), wf4(:,4), wf16(:,167), n3(:,243), t3x16(:,:,167))
  call counter_ZQ_A(gZd,ntry, wf4(:,8), wf4(:,4), wf16(:,168), n3(:,244), t3x16(:,:,168))
  call counter_AV_Q(ntry, wf4(:,10), wf4(:,2), wf16(:,169), n3(:,245), t3x16(:,:,169))
  call counter_AZ_Q(gZd,ntry, wf4(:,10), wf4(:,6), wf16(:,170), n3(:,246), t3x16(:,:,170))
  call counter_AV_Q(ntry, wf4(:,10), wf4(:,1), wf16(:,171), n3(:,247), t3x16(:,:,171))
  call counter_AZ_Q(gZd,ntry, wf4(:,10), wf4(:,8), wf16(:,172), n3(:,248), t3x16(:,:,172))
  call counter_VQ_A(ntry, ex7(:), wf8(:,10), wf16(:,173), n3(:,249), t3x16(:,:,173))
  call counter_VQ_A(ntry, ex7(:), wf8(:,12), wf16(:,174), n3(:,250), t3x16(:,:,174))
  call counter_VQ_A(ntry, ex7(:), wf8(:,14), wf16(:,175), n3(:,251), t3x16(:,:,175))
  call counter_VQ_A(ntry, ex7(:), wf8(:,16), wf16(:,176), n3(:,252), t3x16(:,:,176))
  call counter_AV_Q(ntry, ex6(:), wf4(:,2), wf8(:,111), n3(:,253), t3x8(:,:,61))
  call prop_Q_A(ntry, wf16(:,3), 85, ZERO, 0_intkind1, wf16(:,177), n2(62))
  call counter_AZ_Q(gZd,ntry, ex6(:), wf4(:,6), wf8(:,112), n3(:,254), t3x8(:,:,62))
  call prop_Q_A(ntry, wf16(:,4), 85, ZERO, 0_intkind1, wf16(:,178), n2(63))
  call counter_AV_Q(ntry, ex6(:), wf4(:,1), wf8(:,113), n3(:,255), t3x8(:,:,63))
  call prop_Q_A(ntry, wf16(:,1), 90, ZERO, 0_intkind1, wf16(:,179), n2(64))
  call prop_Q_A(ntry, wf16(:,2), 90, ZERO, 0_intkind1, wf16(:,180), n2(65))
  call counter_AZ_Q(gZd,ntry, ex6(:), wf4(:,8), wf8(:,114), n3(:,256), t3x8(:,:,64))
  call prop_A_Q(ntry, wf8(:,111), 42, ZERO, 0_intkind1, wf8(:,115), n2(66))
  call prop_A_Q(ntry, wf8(:,112), 42, ZERO, 0_intkind1, wf8(:,116), n2(67))
  call prop_A_Q(ntry, wf8(:,113), 37, ZERO, 0_intkind1, wf8(:,117), n2(68))
  call prop_A_Q(ntry, wf8(:,114), 37, ZERO, 0_intkind1, wf8(:,118), n2(69))
  call counter_AV_Q(ntry, ex6(:), ex7(:), wf4(:,28), n3(:,257), t3x4(:,:,17))
  call prop_A_Q(ntry, wf4(:,28), 96, ZERO, 0_intkind1, wf4(:,29), n2(70))
  call vert_AV_Q(ntry, wf4(:,29), wf4(:,2), wf16(:,181), n3(:,258), t3x16(:,:,177))
  call vert_AZ_Q(gZd,ntry, wf4(:,29), wf4(:,6), wf16(:,182), n3(:,259), t3x16(:,:,178))
  call vert_AV_Q(ntry, wf4(:,29), wf4(:,1), wf16(:,183), n3(:,260), t3x16(:,:,179))
  call vert_AZ_Q(gZd,ntry, wf4(:,29), wf4(:,8), wf16(:,184), n3(:,261), t3x16(:,:,180))
  call counter_VQ_A(ntry, wf4(:,2), ex5(:), wf8(:,119), n3(:,262), t3x8(:,:,65))
  call prop_A_Q(ntry, wf16(:,7), 101, ZERO, 0_intkind1, wf16(:,185), n2(71))
  call counter_ZQ_A(gZd,ntry, wf4(:,6), ex5(:), wf8(:,120), n3(:,263), t3x8(:,:,66))
  call prop_A_Q(ntry, wf16(:,8), 101, ZERO, 0_intkind1, wf16(:,186), n2(72))
  call counter_VQ_A(ntry, wf4(:,1), ex5(:), wf8(:,121), n3(:,264), t3x8(:,:,67))
  call prop_A_Q(ntry, wf16(:,5), 106, ZERO, 0_intkind1, wf16(:,187), n2(73))
  call prop_A_Q(ntry, wf16(:,6), 106, ZERO, 0_intkind1, wf16(:,188), n2(74))
  call counter_ZQ_A(gZd,ntry, wf4(:,8), ex5(:), wf8(:,122), n3(:,265), t3x8(:,:,68))
  call prop_Q_A(ntry, wf8(:,119), 26, ZERO, 0_intkind1, wf8(:,123), n2(75))
  call vert_VQ_A(ntry, ex7(:), wf8(:,123), wf16(:,189), n3(:,266), t3x16(:,:,181))
  call prop_Q_A(ntry, wf8(:,120), 26, ZERO, 0_intkind1, wf8(:,124), n2(76))
  call vert_VQ_A(ntry, ex7(:), wf8(:,124), wf16(:,190), n3(:,267), t3x16(:,:,182))
  call prop_Q_A(ntry, wf8(:,121), 21, ZERO, 0_intkind1, wf8(:,125), n2(77))
  call vert_VQ_A(ntry, ex7(:), wf8(:,125), wf16(:,191), n3(:,268), t3x16(:,:,183))
  call prop_Q_A(ntry, wf8(:,122), 21, ZERO, 0_intkind1, wf8(:,126), n2(78))
  call vert_VQ_A(ntry, ex7(:), wf8(:,126), wf16(:,192), n3(:,269), t3x16(:,:,184))
  call counter_VQ_A(ntry, ex7(:), ex5(:), wf4(:,30), n3(:,270), t3x4(:,:,18))
  call prop_Q_A(ntry, wf4(:,30), 80, ZERO, 0_intkind1, wf4(:,31), n2(79))
  call vert_VQ_A(ntry, wf4(:,2), wf4(:,31), wf16(:,193), n3(:,271), t3x16(:,:,185))
  call vert_ZQ_A(gZd,ntry, wf4(:,6), wf4(:,31), wf16(:,194), n3(:,272), t3x16(:,:,186))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,31), wf16(:,195), n3(:,273), t3x16(:,:,187))
  call vert_ZQ_A(gZd,ntry, wf4(:,8), wf4(:,31), wf16(:,196), n3(:,274), t3x16(:,:,188))
  call counter_AV_Q(ntry, ex6(:), wf8(:,33), wf16(:,197), n3(:,275), t3x16(:,:,189))
  call counter_AZ_Q(gZd,ntry, ex6(:), wf8(:,35), wf16(:,198), n3(:,276), t3x16(:,:,190))
  call counter_AV_Q(ntry, ex6(:), wf8(:,36), wf16(:,199), n3(:,277), t3x16(:,:,191))
  call counter_AZ_Q(gZd,ntry, ex6(:), wf8(:,38), wf16(:,200), n3(:,278), t3x16(:,:,192))
  call counter_QA_V(ntry, wf4(:,4), ex6(:), wf8(:,127), n3(:,279), t3x8(:,:,69))
  call counter_QA_Z(gZd,ntry, wf4(:,4), ex6(:), wf8(:,128), n3(:,280), t3x8(:,:,70))
  call prop_W_W(ntry, wf8(:,128), 112, MZ, 1_intkind1, wf8(:,129), n2(80))
  call vert_QA_V(ntry, ex5(:), wf4(:,29), wf8(:,130), n3(:,281), t3x8(:,:,71))
  call vert_QA_Z(gZd,ntry, ex5(:), wf4(:,29), wf8(:,131), n3(:,282), t3x8(:,:,72))
  call prop_W_W(ntry, wf8(:,131), 112, MZ, 1_intkind1, wf8(:,132), n2(81))
  call counter_VQ_A(ntry, wf8(:,33), ex5(:), wf16(:,201), n3(:,283), t3x16(:,:,193))
  call counter_ZQ_A(gZd,ntry, wf8(:,35), ex5(:), wf16(:,202), n3(:,284), t3x16(:,:,194))
  call counter_VQ_A(ntry, wf8(:,36), ex5(:), wf16(:,203), n3(:,285), t3x16(:,:,195))
  call counter_ZQ_A(gZd,ntry, wf8(:,38), ex5(:), wf16(:,204), n3(:,286), t3x16(:,:,196))
  call counter_QA_V(ntry, ex5(:), wf4(:,10), wf8(:,133), n3(:,287), t3x8(:,:,73))
  call counter_QA_Z(gZd,ntry, ex5(:), wf4(:,10), wf8(:,134), n3(:,288), t3x8(:,:,74))
  call prop_W_W(ntry, wf8(:,134), 112, MZ, 1_intkind1, wf8(:,135), n2(82))
  call vert_QA_V(ntry, wf4(:,31), ex6(:), wf8(:,136), n3(:,289), t3x8(:,:,75))
  call vert_QA_Z(gZd,ntry, wf4(:,31), ex6(:), wf8(:,137), n3(:,290), t3x8(:,:,76))
  call prop_W_W(ntry, wf8(:,137), 112, MZ, 1_intkind1, wf8(:,138), n2(83))
  call counter_QA_V(ntry, ex5(:), ex6(:), wf4(:,32), n3(:,291), t3x4(:,:,19))
  call vert_VQ_A(ntry, wf4(:,32), wf4(:,13), wf16(:,205), n3(:,292), t3x16(:,:,197))
  call counter_QA_Z(gZd,ntry, ex5(:), ex6(:), wf4(:,33), n3(:,293), t3x4(:,:,20))
  call prop_W_W(ntry, wf4(:,33), 48, MZ, 1_intkind1, wf4(:,34), n2(84))
  call vert_ZQ_A(gZl,ntry, wf4(:,34), wf4(:,13), wf16(:,206), n3(:,294), t3x16(:,:,198))
  call vert_AV_Q(ntry, ex4(:), wf4(:,32), wf8(:,139), n3(:,295), t3x8(:,:,77))
  call prop_A_Q(ntry, wf8(:,139), 56, ZERO, 0_intkind1, wf8(:,140), n2(85))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,34), wf8(:,141), n3(:,296), t3x8(:,:,78))
  call prop_A_Q(ntry, wf8(:,141), 56, ZERO, 0_intkind1, wf8(:,142), n2(86))
  call vert_AV_Q(ntry, wf4(:,17), wf4(:,32), wf16(:,207), n3(:,297), t3x16(:,:,199))
  call vert_AZ_Q(gZl,ntry, wf4(:,17), wf4(:,34), wf16(:,208), n3(:,298), t3x16(:,:,200))
  call vert_VQ_A(ntry, wf4(:,32), ex2(:), wf8(:,143), n3(:,299), t3x8(:,:,79))
  call prop_Q_A(ntry, wf8(:,143), 50, ZERO, 0_intkind1, wf8(:,144), n2(87))
  call vert_ZQ_A(gZl,ntry, wf4(:,34), ex2(:), wf8(:,145), n3(:,300), t3x8(:,:,80))
  call prop_Q_A(ntry, wf8(:,145), 50, ZERO, 0_intkind1, wf8(:,146), n2(88))
  call vert_VQ_A(ntry, ex7(:), wf8(:,144), wf16(:,209), n3(:,301), t3x16(:,:,201))
  call vert_VQ_A(ntry, ex7(:), wf8(:,146), wf16(:,210), n3(:,302), t3x16(:,:,202))
  call counter_VQ_A(ntry, wf4(:,19), wf4(:,4), wf16(:,211), n3(:,303), t3x16(:,:,203))
  call counter_ZQ_A(gZd,ntry, wf4(:,21), wf4(:,4), wf16(:,212), n3(:,304), t3x16(:,:,204))
  call counter_VQ_A(ntry, wf4(:,18), wf4(:,4), wf16(:,213), n3(:,305), t3x16(:,:,205))
  call counter_ZQ_A(gZd,ntry, wf4(:,23), wf4(:,4), wf16(:,214), n3(:,306), t3x16(:,:,206))
  call counter_AV_Q(ntry, wf4(:,10), wf4(:,19), wf16(:,215), n3(:,307), t3x16(:,:,207))
  call counter_AZ_Q(gZd,ntry, wf4(:,10), wf4(:,21), wf16(:,216), n3(:,308), t3x16(:,:,208))
  call counter_AV_Q(ntry, wf4(:,10), wf4(:,18), wf16(:,217), n3(:,309), t3x16(:,:,209))
  call counter_AZ_Q(gZd,ntry, wf4(:,10), wf4(:,23), wf16(:,218), n3(:,310), t3x16(:,:,210))
  call counter_VQ_A(ntry, ex7(:), wf8(:,54), wf16(:,219), n3(:,311), t3x16(:,:,211))
  call counter_VQ_A(ntry, ex7(:), wf8(:,56), wf16(:,220), n3(:,312), t3x16(:,:,212))
  call counter_VQ_A(ntry, ex7(:), wf8(:,58), wf16(:,221), n3(:,313), t3x16(:,:,213))
  call counter_VQ_A(ntry, ex7(:), wf8(:,60), wf16(:,222), n3(:,314), t3x16(:,:,214))
  call counter_AV_Q(ntry, ex6(:), wf4(:,19), wf8(:,147), n3(:,315), t3x8(:,:,81))
  call prop_Q_A(ntry, wf16(:,43), 89, ZERO, 0_intkind1, wf16(:,223), n2(89))
  call counter_AZ_Q(gZd,ntry, ex6(:), wf4(:,21), wf8(:,148), n3(:,316), t3x8(:,:,82))
  call prop_Q_A(ntry, wf16(:,44), 89, ZERO, 0_intkind1, wf16(:,224), n2(90))
  call counter_AV_Q(ntry, ex6(:), wf4(:,18), wf8(:,149), n3(:,317), t3x8(:,:,83))
  call prop_Q_A(ntry, wf16(:,41), 86, ZERO, 0_intkind1, wf16(:,225), n2(91))
  call prop_Q_A(ntry, wf16(:,42), 86, ZERO, 0_intkind1, wf16(:,226), n2(92))
  call counter_AZ_Q(gZd,ntry, ex6(:), wf4(:,23), wf8(:,150), n3(:,318), t3x8(:,:,84))
  call prop_A_Q(ntry, wf8(:,147), 38, ZERO, 0_intkind1, wf8(:,151), n2(93))
  call prop_A_Q(ntry, wf8(:,148), 38, ZERO, 0_intkind1, wf8(:,152), n2(94))
  call prop_A_Q(ntry, wf8(:,149), 41, ZERO, 0_intkind1, wf8(:,153), n2(95))
  call prop_A_Q(ntry, wf8(:,150), 41, ZERO, 0_intkind1, wf8(:,154), n2(96))
  call vert_AV_Q(ntry, wf4(:,29), wf4(:,19), wf16(:,227), n3(:,319), t3x16(:,:,215))
  call vert_AZ_Q(gZd,ntry, wf4(:,29), wf4(:,21), wf16(:,228), n3(:,320), t3x16(:,:,216))
  call vert_AV_Q(ntry, wf4(:,29), wf4(:,18), wf16(:,229), n3(:,321), t3x16(:,:,217))
  call vert_AZ_Q(gZd,ntry, wf4(:,29), wf4(:,23), wf16(:,230), n3(:,322), t3x16(:,:,218))
  call counter_VQ_A(ntry, wf4(:,19), ex5(:), wf8(:,155), n3(:,323), t3x8(:,:,85))
  call prop_A_Q(ntry, wf16(:,47), 105, ZERO, 0_intkind1, wf16(:,231), n2(97))
  call counter_ZQ_A(gZd,ntry, wf4(:,21), ex5(:), wf8(:,156), n3(:,324), t3x8(:,:,86))
  call prop_A_Q(ntry, wf16(:,48), 105, ZERO, 0_intkind1, wf16(:,232), n2(98))
  call counter_VQ_A(ntry, wf4(:,18), ex5(:), wf8(:,157), n3(:,325), t3x8(:,:,87))
  call prop_A_Q(ntry, wf16(:,45), 102, ZERO, 0_intkind1, wf16(:,233), n2(99))
  call prop_A_Q(ntry, wf16(:,46), 102, ZERO, 0_intkind1, wf16(:,234), n2(100))
  call counter_ZQ_A(gZd,ntry, wf4(:,23), ex5(:), wf8(:,158), n3(:,326), t3x8(:,:,88))
  call prop_Q_A(ntry, wf8(:,155), 22, ZERO, 0_intkind1, wf8(:,159), n2(101))
  call vert_VQ_A(ntry, ex7(:), wf8(:,159), wf16(:,235), n3(:,327), t3x16(:,:,219))
  call prop_Q_A(ntry, wf8(:,156), 22, ZERO, 0_intkind1, wf8(:,160), n2(102))
  call vert_VQ_A(ntry, ex7(:), wf8(:,160), wf16(:,236), n3(:,328), t3x16(:,:,220))
  call prop_Q_A(ntry, wf8(:,157), 25, ZERO, 0_intkind1, wf8(:,161), n2(103))
  call vert_VQ_A(ntry, ex7(:), wf8(:,161), wf16(:,237), n3(:,329), t3x16(:,:,221))
  call prop_Q_A(ntry, wf8(:,158), 25, ZERO, 0_intkind1, wf8(:,162), n2(104))
  call vert_VQ_A(ntry, ex7(:), wf8(:,162), wf16(:,238), n3(:,330), t3x16(:,:,222))
  call vert_VQ_A(ntry, wf4(:,19), wf4(:,31), wf16(:,239), n3(:,331), t3x16(:,:,223))
  call vert_ZQ_A(gZd,ntry, wf4(:,21), wf4(:,31), wf16(:,240), n3(:,332), t3x16(:,:,224))
  call vert_VQ_A(ntry, wf4(:,18), wf4(:,31), wf16(:,241), n3(:,333), t3x16(:,:,225))
  call vert_ZQ_A(gZd,ntry, wf4(:,23), wf4(:,31), wf16(:,242), n3(:,334), t3x16(:,:,226))
  call counter_AV_Q(ntry, ex6(:), wf8(:,73), wf16(:,243), n3(:,335), t3x16(:,:,227))
  call counter_AZ_Q(gZd,ntry, ex6(:), wf8(:,75), wf16(:,244), n3(:,336), t3x16(:,:,228))
  call counter_AV_Q(ntry, ex6(:), wf8(:,76), wf16(:,245), n3(:,337), t3x16(:,:,229))
  call counter_AZ_Q(gZd,ntry, ex6(:), wf8(:,78), wf16(:,246), n3(:,338), t3x16(:,:,230))
  call counter_VQ_A(ntry, wf8(:,73), ex5(:), wf16(:,247), n3(:,339), t3x16(:,:,231))
  call counter_ZQ_A(gZd,ntry, wf8(:,75), ex5(:), wf16(:,248), n3(:,340), t3x16(:,:,232))
  call counter_VQ_A(ntry, wf8(:,76), ex5(:), wf16(:,249), n3(:,341), t3x16(:,:,233))
  call counter_ZQ_A(gZd,ntry, wf8(:,78), ex5(:), wf16(:,250), n3(:,342), t3x16(:,:,234))
  call vert_VQ_A(ntry, wf4(:,32), wf4(:,25), wf16(:,251), n3(:,343), t3x16(:,:,235))
  call vert_ZQ_A(gZl,ntry, wf4(:,34), wf4(:,25), wf16(:,252), n3(:,344), t3x16(:,:,236))
  call vert_VQ_A(ntry, wf4(:,32), ex1(:), wf8(:,163), n3(:,345), t3x8(:,:,89))
  call prop_Q_A(ntry, wf8(:,163), 49, ZERO, 0_intkind1, wf8(:,164), n2(105))
  call vert_ZQ_A(gZl,ntry, wf4(:,34), ex1(:), wf8(:,165), n3(:,346), t3x8(:,:,90))
  call prop_Q_A(ntry, wf8(:,165), 49, ZERO, 0_intkind1, wf8(:,166), n2(106))
  call vert_VQ_A(ntry, ex7(:), wf8(:,164), wf16(:,253), n3(:,347), t3x16(:,:,237))
  call vert_VQ_A(ntry, ex7(:), wf8(:,166), wf16(:,254), n3(:,348), t3x16(:,:,238))
  call counter_AV_Q(ntry, ex6(:), wf8(:,91), wf16(:,255), n3(:,349), t3x16(:,:,239))
  call counter_AZ_Q(gZd,ntry, ex6(:), wf8(:,93), wf16(:,256), n3(:,350), t3x16(:,:,240))
  call counter_AV_Q(ntry, ex6(:), wf8(:,94), wf16(:,257), n3(:,351), t3x16(:,:,241))
  call counter_AZ_Q(gZd,ntry, ex6(:), wf8(:,96), wf16(:,258), n3(:,352), t3x16(:,:,242))
  call counter_VQ_A(ntry, wf8(:,91), ex5(:), wf16(:,259), n3(:,353), t3x16(:,:,243))
  call counter_ZQ_A(gZd,ntry, wf8(:,93), ex5(:), wf16(:,260), n3(:,354), t3x16(:,:,244))
  call counter_VQ_A(ntry, wf8(:,94), ex5(:), wf16(:,261), n3(:,355), t3x16(:,:,245))
  call counter_ZQ_A(gZd,ntry, wf8(:,96), ex5(:), wf16(:,262), n3(:,356), t3x16(:,:,246))
  call vert_AV_Q(ntry, ex3(:), wf4(:,32), wf8(:,167), n3(:,357), t3x8(:,:,91))
  call prop_A_Q(ntry, wf8(:,167), 52, ZERO, 0_intkind1, wf8(:,168), n2(107))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf4(:,34), wf8(:,169), n3(:,358), t3x8(:,:,92))
  call prop_A_Q(ntry, wf8(:,169), 52, ZERO, 0_intkind1, wf8(:,170), n2(108))
  call vert_AV_Q(ntry, wf4(:,27), wf4(:,32), wf16(:,263), n3(:,359), t3x16(:,:,247))
  call vert_AZ_Q(gZl,ntry, wf4(:,27), wf4(:,34), wf16(:,264), n3(:,360), t3x16(:,:,248))
  call counter_AV_Q(ntry, ex6(:), wf8(:,105), wf16(:,265), n3(:,361), t3x16(:,:,249))
  call counter_AZ_Q(gZd,ntry, ex6(:), wf8(:,107), wf16(:,266), n3(:,362), t3x16(:,:,250))
  call counter_AV_Q(ntry, ex6(:), wf8(:,108), wf16(:,267), n3(:,363), t3x16(:,:,251))
  call counter_AZ_Q(gZd,ntry, ex6(:), wf8(:,110), wf16(:,268), n3(:,364), t3x16(:,:,252))
  call counter_VQ_A(ntry, wf8(:,105), ex5(:), wf16(:,269), n3(:,365), t3x16(:,:,253))
  call counter_ZQ_A(gZd,ntry, wf8(:,107), ex5(:), wf16(:,270), n3(:,366), t3x16(:,:,254))
  call counter_VQ_A(ntry, wf8(:,108), ex5(:), wf16(:,271), n3(:,367), t3x16(:,:,255))
  call counter_ZQ_A(gZd,ntry, wf8(:,110), ex5(:), wf16(:,272), n3(:,368), t3x16(:,:,256))
  call vert_QA_V(ntry, wf8(:,144), ex4(:), wf16(:,273), n3(:,369), t3x16(:,:,257))
  call vert_QA_Z(gZl,ntry, wf8(:,144), ex4(:), wf16(:,274), n3(:,370), t3x16(:,:,258))
  call vert_QA_V(ntry, wf8(:,146), ex4(:), wf16(:,275), n3(:,371), t3x16(:,:,259))
  call vert_QA_Z(gZl,ntry, wf8(:,146), ex4(:), wf16(:,276), n3(:,372), t3x16(:,:,260))
  call vert_QA_V(ntry, ex2(:), wf8(:,168), wf16(:,277), n3(:,373), t3x16(:,:,261))
  call vert_QA_V(ntry, ex2(:), wf8(:,170), wf16(:,278), n3(:,374), t3x16(:,:,262))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,168), wf16(:,279), n3(:,375), t3x16(:,:,263))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,170), wf16(:,280), n3(:,376), t3x16(:,:,264))
  call vert_QA_V(ntry, wf8(:,144), ex3(:), wf16(:,281), n3(:,377), t3x16(:,:,265))
  call vert_QA_Z(gZl,ntry, wf8(:,144), ex3(:), wf16(:,282), n3(:,378), t3x16(:,:,266))
  call vert_QA_V(ntry, wf8(:,146), ex3(:), wf16(:,283), n3(:,379), t3x16(:,:,267))
  call vert_QA_Z(gZl,ntry, wf8(:,146), ex3(:), wf16(:,284), n3(:,380), t3x16(:,:,268))
  call vert_QA_V(ntry, ex1(:), wf8(:,168), wf16(:,285), n3(:,381), t3x16(:,:,269))
  call vert_QA_V(ntry, ex1(:), wf8(:,170), wf16(:,286), n3(:,382), t3x16(:,:,270))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,168), wf16(:,287), n3(:,383), t3x16(:,:,271))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,170), wf16(:,288), n3(:,384), t3x16(:,:,272))
  call vert_QA_V(ntry, wf8(:,164), ex3(:), wf16(:,289), n3(:,385), t3x16(:,:,273))
  call vert_QA_Z(gZl,ntry, wf8(:,164), ex3(:), wf16(:,290), n3(:,386), t3x16(:,:,274))
  call vert_QA_V(ntry, wf8(:,166), ex3(:), wf16(:,291), n3(:,387), t3x16(:,:,275))
  call vert_QA_Z(gZl,ntry, wf8(:,166), ex3(:), wf16(:,292), n3(:,388), t3x16(:,:,276))
  call vert_QA_V(ntry, wf8(:,164), ex4(:), wf16(:,293), n3(:,389), t3x16(:,:,277))
  call vert_QA_Z(gZl,ntry, wf8(:,164), ex4(:), wf16(:,294), n3(:,390), t3x16(:,:,278))
  call vert_QA_V(ntry, wf8(:,166), ex4(:), wf16(:,295), n3(:,391), t3x16(:,:,279))
  call vert_QA_Z(gZl,ntry, wf8(:,166), ex4(:), wf16(:,296), n3(:,392), t3x16(:,:,280))
  call counter_Q_A(ctqq,1,ntry, wf4(:,4), 80, wf4(:,35), n2(109))
  call prop_Q_A(ntry, wf4(:,35), 80, ZERO, 0_intkind1, wf4(:,36), n2(110))
  call vert_VQ_A(ntry, wf4(:,2), wf4(:,36), wf16(:,297), n3(:,393), t3x16(:,:,281))
  call vert_ZQ_A(gZd,ntry, wf4(:,6), wf4(:,36), wf16(:,298), n3(:,394), t3x16(:,:,282))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,36), wf16(:,299), n3(:,395), t3x16(:,:,283))
  call vert_ZQ_A(gZd,ntry, wf4(:,8), wf4(:,36), wf16(:,300), n3(:,396), t3x16(:,:,284))
  call counter_A_Q(ctqq,1,ntry, wf8(:,2), 37, wf8(:,171), n2(111))
  call counter_A_Q(ctqq,1,ntry, wf8(:,4), 37, wf8(:,172), n2(112))
  call counter_A_Q(ctqq,1,ntry, wf8(:,6), 42, wf8(:,173), n2(113))
  call counter_A_Q(ctqq,1,ntry, wf8(:,8), 42, wf8(:,174), n2(114))
  call counter_Q_A(ctqq,1,ntry, wf8(:,10), 21, wf8(:,175), n2(115))
  call counter_Q_A(ctqq,1,ntry, wf8(:,12), 21, wf8(:,176), n2(116))
  call counter_Q_A(ctqq,1,ntry, wf8(:,14), 26, wf8(:,177), n2(117))
  call counter_Q_A(ctqq,1,ntry, wf8(:,16), 26, wf8(:,178), n2(118))
  call counter_A_Q(ctqq,1,ntry, wf4(:,10), 96, wf4(:,37), n2(119))
  call prop_A_Q(ntry, wf4(:,37), 96, ZERO, 0_intkind1, wf4(:,38), n2(120))
  call vert_AV_Q(ntry, wf4(:,38), wf4(:,2), wf16(:,301), n3(:,397), t3x16(:,:,285))
  call vert_AZ_Q(gZd,ntry, wf4(:,38), wf4(:,6), wf16(:,302), n3(:,398), t3x16(:,:,286))
  call vert_AV_Q(ntry, wf4(:,38), wf4(:,1), wf16(:,303), n3(:,399), t3x16(:,:,287))
  call vert_AZ_Q(gZd,ntry, wf4(:,38), wf4(:,8), wf16(:,304), n3(:,400), t3x16(:,:,288))
  call vert_AV_Q(ntry, wf8(:,6), ex7(:), wf16(:,305), n3(:,401), t3x16(:,:,289))
  call prop_A_Q(ntry, wf16(:,305), 106, ZERO, 0_intkind1, wf16(:,306), n2(121))
  call vert_AV_Q(ntry, wf8(:,8), ex7(:), wf16(:,307), n3(:,402), t3x16(:,:,290))
  call prop_A_Q(ntry, wf16(:,307), 106, ZERO, 0_intkind1, wf16(:,308), n2(122))
  call vert_AV_Q(ntry, wf8(:,2), ex7(:), wf16(:,309), n3(:,403), t3x16(:,:,291))
  call prop_A_Q(ntry, wf16(:,309), 101, ZERO, 0_intkind1, wf16(:,310), n2(123))
  call vert_AV_Q(ntry, wf8(:,4), ex7(:), wf16(:,311), n3(:,404), t3x16(:,:,292))
  call prop_A_Q(ntry, wf16(:,311), 101, ZERO, 0_intkind1, wf16(:,312), n2(124))
  call prop_Q_A(ntry, wf16(:,9), 85, ZERO, 0_intkind1, wf16(:,313), n2(125))
  call prop_Q_A(ntry, wf16(:,10), 85, ZERO, 0_intkind1, wf16(:,314), n2(126))
  call prop_Q_A(ntry, wf16(:,11), 90, ZERO, 0_intkind1, wf16(:,315), n2(127))
  call prop_Q_A(ntry, wf16(:,12), 90, ZERO, 0_intkind1, wf16(:,316), n2(128))
  call prop_A_Q(ntry, wf16(:,25), 106, ZERO, 0_intkind1, wf16(:,317), n2(129))
  call prop_A_Q(ntry, wf16(:,26), 106, ZERO, 0_intkind1, wf16(:,318), n2(130))
  call prop_Q_A(ntry, wf16(:,27), 90, ZERO, 0_intkind1, wf16(:,319), n2(131))
  call prop_Q_A(ntry, wf16(:,28), 90, ZERO, 0_intkind1, wf16(:,320), n2(132))
  call prop_A_Q(ntry, wf16(:,29), 106, ZERO, 0_intkind1, wf16(:,321), n2(133))
  call prop_A_Q(ntry, wf16(:,30), 106, ZERO, 0_intkind1, wf16(:,322), n2(134))
  call prop_Q_A(ntry, wf16(:,31), 90, ZERO, 0_intkind1, wf16(:,323), n2(135))
  call prop_Q_A(ntry, wf16(:,32), 90, ZERO, 0_intkind1, wf16(:,324), n2(136))
  call vert_QA_V(ntry, wf4(:,36), ex6(:), wf8(:,179), n3(:,405), t3x8(:,:,93))
  call vert_QA_Z(gZd,ntry, wf4(:,36), ex6(:), wf8(:,180), n3(:,406), t3x8(:,:,94))
  call prop_W_W(ntry, wf16(:,34), 15, MZ, 1_intkind1, wf16(:,325), n2(137))
  call prop_W_W(ntry, wf16(:,36), 15, MZ, 1_intkind1, wf16(:,326), n2(138))
  call prop_W_W(ntry, wf16(:,38), 15, MZ, 1_intkind1, wf16(:,327), n2(139))
  call prop_W_W(ntry, wf16(:,40), 15, MZ, 1_intkind1, wf16(:,328), n2(140))
  call vert_QA_V(ntry, ex5(:), wf4(:,38), wf8(:,181), n3(:,407), t3x8(:,:,95))
  call vert_QA_Z(gZd,ntry, ex5(:), wf4(:,38), wf8(:,182), n3(:,408), t3x8(:,:,96))
  call vert_VQ_A(ntry, wf4(:,19), wf4(:,36), wf16(:,329), n3(:,409), t3x16(:,:,293))
  call vert_ZQ_A(gZd,ntry, wf4(:,21), wf4(:,36), wf16(:,330), n3(:,410), t3x16(:,:,294))
  call vert_VQ_A(ntry, wf4(:,18), wf4(:,36), wf16(:,331), n3(:,411), t3x16(:,:,295))
  call vert_ZQ_A(gZd,ntry, wf4(:,23), wf4(:,36), wf16(:,332), n3(:,412), t3x16(:,:,296))
  call counter_A_Q(ctqq,1,ntry, wf8(:,46), 41, wf8(:,183), n2(141))
  call counter_A_Q(ctqq,1,ntry, wf8(:,48), 41, wf8(:,184), n2(142))
  call counter_A_Q(ctqq,1,ntry, wf8(:,50), 38, wf8(:,185), n2(143))
  call counter_A_Q(ctqq,1,ntry, wf8(:,52), 38, wf8(:,186), n2(144))
  call counter_Q_A(ctqq,1,ntry, wf8(:,54), 25, wf8(:,187), n2(145))
  call counter_Q_A(ctqq,1,ntry, wf8(:,56), 25, wf8(:,188), n2(146))
  call counter_Q_A(ctqq,1,ntry, wf8(:,58), 22, wf8(:,189), n2(147))
  call counter_Q_A(ctqq,1,ntry, wf8(:,60), 22, wf8(:,190), n2(148))
  call vert_AV_Q(ntry, wf4(:,38), wf4(:,19), wf16(:,333), n3(:,413), t3x16(:,:,297))
  call vert_AZ_Q(gZd,ntry, wf4(:,38), wf4(:,21), wf16(:,334), n3(:,414), t3x16(:,:,298))
  call vert_AV_Q(ntry, wf4(:,38), wf4(:,18), wf16(:,335), n3(:,415), t3x16(:,:,299))
  call vert_AZ_Q(gZd,ntry, wf4(:,38), wf4(:,23), wf16(:,336), n3(:,416), t3x16(:,:,300))
  call vert_AV_Q(ntry, wf8(:,50), ex7(:), wf16(:,337), n3(:,417), t3x16(:,:,301))
  call prop_A_Q(ntry, wf16(:,337), 102, ZERO, 0_intkind1, wf16(:,338), n2(149))
  call vert_AV_Q(ntry, wf8(:,52), ex7(:), wf16(:,339), n3(:,418), t3x16(:,:,302))
  call prop_A_Q(ntry, wf16(:,339), 102, ZERO, 0_intkind1, wf16(:,340), n2(150))
  call vert_AV_Q(ntry, wf8(:,46), ex7(:), wf16(:,341), n3(:,419), t3x16(:,:,303))
  call prop_A_Q(ntry, wf16(:,341), 105, ZERO, 0_intkind1, wf16(:,342), n2(151))
  call vert_AV_Q(ntry, wf8(:,48), ex7(:), wf16(:,343), n3(:,420), t3x16(:,:,304))
  call prop_A_Q(ntry, wf16(:,343), 105, ZERO, 0_intkind1, wf16(:,344), n2(152))
  call prop_Q_A(ntry, wf16(:,49), 89, ZERO, 0_intkind1, wf16(:,345), n2(153))
  call prop_Q_A(ntry, wf16(:,50), 89, ZERO, 0_intkind1, wf16(:,346), n2(154))
  call prop_Q_A(ntry, wf16(:,51), 86, ZERO, 0_intkind1, wf16(:,347), n2(155))
  call prop_Q_A(ntry, wf16(:,52), 86, ZERO, 0_intkind1, wf16(:,348), n2(156))
  call prop_A_Q(ntry, wf16(:,63), 105, ZERO, 0_intkind1, wf16(:,349), n2(157))
  call prop_A_Q(ntry, wf16(:,64), 105, ZERO, 0_intkind1, wf16(:,350), n2(158))
  call prop_Q_A(ntry, wf16(:,65), 89, ZERO, 0_intkind1, wf16(:,351), n2(159))
  call prop_Q_A(ntry, wf16(:,66), 89, ZERO, 0_intkind1, wf16(:,352), n2(160))
  call prop_Q_A(ntry, wf16(:,67), 89, ZERO, 0_intkind1, wf16(:,353), n2(161))
  call prop_Q_A(ntry, wf16(:,68), 89, ZERO, 0_intkind1, wf16(:,354), n2(162))
  call prop_A_Q(ntry, wf16(:,69), 105, ZERO, 0_intkind1, wf16(:,355), n2(163))
  call prop_A_Q(ntry, wf16(:,70), 105, ZERO, 0_intkind1, wf16(:,356), n2(164))
  call prop_W_W(ntry, wf16(:,72), 15, MZ, 1_intkind1, wf16(:,357), n2(165))
  call prop_W_W(ntry, wf16(:,74), 15, MZ, 1_intkind1, wf16(:,358), n2(166))
  call prop_W_W(ntry, wf16(:,77), 15, MZ, 1_intkind1, wf16(:,359), n2(167))
  call prop_W_W(ntry, wf16(:,78), 15, MZ, 1_intkind1, wf16(:,360), n2(168))
  call prop_A_Q(ntry, wf16(:,87), 102, ZERO, 0_intkind1, wf16(:,361), n2(169))
  call prop_A_Q(ntry, wf16(:,88), 102, ZERO, 0_intkind1, wf16(:,362), n2(170))
  call prop_Q_A(ntry, wf16(:,89), 86, ZERO, 0_intkind1, wf16(:,363), n2(171))
  call prop_Q_A(ntry, wf16(:,90), 86, ZERO, 0_intkind1, wf16(:,364), n2(172))
  call prop_A_Q(ntry, wf16(:,91), 102, ZERO, 0_intkind1, wf16(:,365), n2(173))
  call prop_A_Q(ntry, wf16(:,92), 102, ZERO, 0_intkind1, wf16(:,366), n2(174))
  call prop_Q_A(ntry, wf16(:,93), 86, ZERO, 0_intkind1, wf16(:,367), n2(175))
  call prop_Q_A(ntry, wf16(:,94), 86, ZERO, 0_intkind1, wf16(:,368), n2(176))
  call prop_W_W(ntry, wf16(:,96), 15, MZ, 1_intkind1, wf16(:,369), n2(177))
  call prop_W_W(ntry, wf16(:,98), 15, MZ, 1_intkind1, wf16(:,370), n2(178))
  call prop_W_W(ntry, wf16(:,100), 15, MZ, 1_intkind1, wf16(:,371), n2(179))
  call prop_W_W(ntry, wf16(:,102), 15, MZ, 1_intkind1, wf16(:,372), n2(180))
  call prop_A_Q(ntry, wf16(:,109), 101, ZERO, 0_intkind1, wf16(:,373), n2(181))
  call prop_A_Q(ntry, wf16(:,110), 101, ZERO, 0_intkind1, wf16(:,374), n2(182))
  call prop_Q_A(ntry, wf16(:,111), 85, ZERO, 0_intkind1, wf16(:,375), n2(183))
  call prop_Q_A(ntry, wf16(:,112), 85, ZERO, 0_intkind1, wf16(:,376), n2(184))
  call prop_Q_A(ntry, wf16(:,113), 85, ZERO, 0_intkind1, wf16(:,377), n2(185))
  call prop_Q_A(ntry, wf16(:,114), 85, ZERO, 0_intkind1, wf16(:,378), n2(186))
  call prop_A_Q(ntry, wf16(:,115), 101, ZERO, 0_intkind1, wf16(:,379), n2(187))
  call prop_A_Q(ntry, wf16(:,116), 101, ZERO, 0_intkind1, wf16(:,380), n2(188))
  call prop_W_W(ntry, wf16(:,118), 15, MZ, 1_intkind1, wf16(:,381), n2(189))
  call prop_W_W(ntry, wf16(:,120), 15, MZ, 1_intkind1, wf16(:,382), n2(190))
  call prop_W_W(ntry, wf16(:,123), 15, MZ, 1_intkind1, wf16(:,383), n2(191))
  call prop_W_W(ntry, wf16(:,124), 15, MZ, 1_intkind1, wf16(:,384), n2(192))
  call vert_VQ_A(ntry, wf4(:,2), wf8(:,10), wf32(:,1), n3(:,421), t3x32(:,:,1))
  call prop_Q_A(ntry, wf32(:,1), 31, ZERO, 0_intkind1, wf32(:,2), n2(193))
  call vert_ZQ_A(gZd,ntry, wf4(:,6), wf8(:,10), wf32(:,3), n3(:,422), t3x32(:,:,2))
  call prop_Q_A(ntry, wf32(:,3), 31, ZERO, 0_intkind1, wf32(:,4), n2(194))
  call vert_VQ_A(ntry, wf4(:,2), wf8(:,12), wf32(:,5), n3(:,423), t3x32(:,:,3))
  call prop_Q_A(ntry, wf32(:,5), 31, ZERO, 0_intkind1, wf32(:,6), n2(195))
  call vert_ZQ_A(gZd,ntry, wf4(:,6), wf8(:,12), wf32(:,7), n3(:,424), t3x32(:,:,4))
  call prop_Q_A(ntry, wf32(:,7), 31, ZERO, 0_intkind1, wf32(:,8), n2(196))
  call vert_AV_Q(ntry, wf8(:,2), wf4(:,2), wf32(:,9), n3(:,425), t3x32(:,:,5))
  call prop_A_Q(ntry, wf32(:,9), 47, ZERO, 0_intkind1, wf32(:,10), n2(197))
  call vert_AZ_Q(gZd,ntry, wf8(:,2), wf4(:,6), wf32(:,11), n3(:,426), t3x32(:,:,6))
  call prop_A_Q(ntry, wf32(:,11), 47, ZERO, 0_intkind1, wf32(:,12), n2(198))
  call vert_AV_Q(ntry, wf8(:,4), wf4(:,2), wf32(:,13), n3(:,427), t3x32(:,:,7))
  call prop_A_Q(ntry, wf32(:,13), 47, ZERO, 0_intkind1, wf32(:,14), n2(199))
  call vert_AZ_Q(gZd,ntry, wf8(:,4), wf4(:,6), wf32(:,15), n3(:,428), t3x32(:,:,8))
  call prop_A_Q(ntry, wf32(:,15), 47, ZERO, 0_intkind1, wf32(:,16), n2(200))
  call vert_VQ_A(ntry, wf4(:,1), wf8(:,14), wf32(:,17), n3(:,429), t3x32(:,:,9))
  call prop_Q_A(ntry, wf32(:,17), 31, ZERO, 0_intkind1, wf32(:,18), n2(201))
  call vert_VQ_A(ntry, wf4(:,1), wf8(:,16), wf32(:,19), n3(:,430), t3x32(:,:,10))
  call prop_Q_A(ntry, wf32(:,19), 31, ZERO, 0_intkind1, wf32(:,20), n2(202))
  call vert_ZQ_A(gZd,ntry, wf4(:,8), wf8(:,14), wf32(:,21), n3(:,431), t3x32(:,:,11))
  call prop_Q_A(ntry, wf32(:,21), 31, ZERO, 0_intkind1, wf32(:,22), n2(203))
  call vert_ZQ_A(gZd,ntry, wf4(:,8), wf8(:,16), wf32(:,23), n3(:,432), t3x32(:,:,12))
  call prop_Q_A(ntry, wf32(:,23), 31, ZERO, 0_intkind1, wf32(:,24), n2(204))
  call vert_AV_Q(ntry, wf8(:,6), wf4(:,1), wf32(:,25), n3(:,433), t3x32(:,:,13))
  call prop_A_Q(ntry, wf32(:,25), 47, ZERO, 0_intkind1, wf32(:,26), n2(205))
  call vert_AV_Q(ntry, wf8(:,8), wf4(:,1), wf32(:,27), n3(:,434), t3x32(:,:,14))
  call prop_A_Q(ntry, wf32(:,27), 47, ZERO, 0_intkind1, wf32(:,28), n2(206))
  call vert_AZ_Q(gZd,ntry, wf8(:,6), wf4(:,8), wf32(:,29), n3(:,435), t3x32(:,:,15))
  call prop_A_Q(ntry, wf32(:,29), 47, ZERO, 0_intkind1, wf32(:,30), n2(207))
  call vert_AZ_Q(gZd,ntry, wf8(:,8), wf4(:,8), wf32(:,31), n3(:,436), t3x32(:,:,16))
  call prop_A_Q(ntry, wf32(:,31), 47, ZERO, 0_intkind1, wf32(:,32), n2(208))
  call vert_QA_V(ntry, wf4(:,13), wf8(:,18), wf32(:,33), n3(:,437), t3x32(:,:,17))
  call vert_QA_Z(gZl,ntry, wf4(:,13), wf8(:,18), wf32(:,34), n3(:,438), t3x32(:,:,18))
  call prop_W_W(ntry, wf32(:,34), 79, MZ, 1_intkind1, wf32(:,35), n2(209))
  call vert_QA_V(ntry, wf4(:,13), wf8(:,20), wf32(:,36), n3(:,439), t3x32(:,:,19))
  call vert_QA_Z(gZl,ntry, wf4(:,13), wf8(:,20), wf32(:,37), n3(:,440), t3x32(:,:,20))
  call prop_W_W(ntry, wf32(:,37), 79, MZ, 1_intkind1, wf32(:,38), n2(210))
  call prop_Q_A(ntry, wf16(:,15), 71, ZERO, 0_intkind1, wf16(:,385), n2(211))
  call vert_QA_V(ntry, wf16(:,385), ex4(:), wf32(:,39), n3(:,441), t3x32(:,:,21))
  call vert_QA_Z(gZl,ntry, wf16(:,385), ex4(:), wf32(:,40), n3(:,442), t3x32(:,:,22))
  call prop_W_W(ntry, wf32(:,40), 79, MZ, 1_intkind1, wf32(:,41), n2(212))
  call prop_Q_A(ntry, wf16(:,16), 71, ZERO, 0_intkind1, wf16(:,386), n2(213))
  call vert_QA_V(ntry, wf16(:,386), ex4(:), wf32(:,42), n3(:,443), t3x32(:,:,23))
  call vert_QA_Z(gZl,ntry, wf16(:,386), ex4(:), wf32(:,43), n3(:,444), t3x32(:,:,24))
  call prop_W_W(ntry, wf32(:,43), 79, MZ, 1_intkind1, wf32(:,44), n2(214))
  call vert_QA_V(ntry, wf8(:,26), wf4(:,17), wf32(:,45), n3(:,445), t3x32(:,:,25))
  call vert_QA_Z(gZl,ntry, wf8(:,26), wf4(:,17), wf32(:,46), n3(:,446), t3x32(:,:,26))
  call prop_W_W(ntry, wf32(:,46), 79, MZ, 1_intkind1, wf32(:,47), n2(215))
  call vert_QA_V(ntry, wf8(:,28), wf4(:,17), wf32(:,48), n3(:,447), t3x32(:,:,27))
  call vert_QA_Z(gZl,ntry, wf8(:,28), wf4(:,17), wf32(:,49), n3(:,448), t3x32(:,:,28))
  call prop_W_W(ntry, wf32(:,49), 79, MZ, 1_intkind1, wf32(:,50), n2(216))
  call prop_A_Q(ntry, wf16(:,19), 77, ZERO, 0_intkind1, wf16(:,387), n2(217))
  call vert_QA_V(ntry, ex2(:), wf16(:,387), wf32(:,51), n3(:,449), t3x32(:,:,29))
  call vert_QA_Z(gZl,ntry, ex2(:), wf16(:,387), wf32(:,52), n3(:,450), t3x32(:,:,30))
  call prop_W_W(ntry, wf32(:,52), 79, MZ, 1_intkind1, wf32(:,53), n2(218))
  call prop_A_Q(ntry, wf16(:,20), 77, ZERO, 0_intkind1, wf16(:,388), n2(219))
  call vert_QA_V(ntry, ex2(:), wf16(:,388), wf32(:,54), n3(:,451), t3x32(:,:,31))
  call vert_QA_Z(gZl,ntry, ex2(:), wf16(:,388), wf32(:,55), n3(:,452), t3x32(:,:,32))
  call prop_W_W(ntry, wf32(:,55), 79, MZ, 1_intkind1, wf32(:,56), n2(220))
  call vert_VQ_A(ntry, wf16(:,33), ex5(:), wf32(:,57), n3(:,453), t3x32(:,:,33))
  call prop_Q_A(ntry, wf32(:,57), 31, ZERO, 0_intkind1, wf32(:,58), n2(221))
  call vert_ZQ_A(gZd,ntry, wf16(:,325), ex5(:), wf32(:,59), n3(:,454), t3x32(:,:,34))
  call prop_Q_A(ntry, wf32(:,59), 31, ZERO, 0_intkind1, wf32(:,60), n2(222))
  call vert_VQ_A(ntry, wf16(:,35), ex5(:), wf32(:,61), n3(:,455), t3x32(:,:,35))
  call prop_Q_A(ntry, wf32(:,61), 31, ZERO, 0_intkind1, wf32(:,62), n2(223))
  call vert_ZQ_A(gZd,ntry, wf16(:,326), ex5(:), wf32(:,63), n3(:,456), t3x32(:,:,36))
  call prop_Q_A(ntry, wf32(:,63), 31, ZERO, 0_intkind1, wf32(:,64), n2(224))
  call vert_AV_Q(ntry, ex6(:), wf16(:,33), wf32(:,65), n3(:,457), t3x32(:,:,37))
  call prop_A_Q(ntry, wf32(:,65), 47, ZERO, 0_intkind1, wf32(:,66), n2(225))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,325), wf32(:,67), n3(:,458), t3x32(:,:,38))
  call prop_A_Q(ntry, wf32(:,67), 47, ZERO, 0_intkind1, wf32(:,68), n2(226))
  call vert_AV_Q(ntry, ex6(:), wf16(:,35), wf32(:,69), n3(:,459), t3x32(:,:,39))
  call prop_A_Q(ntry, wf32(:,69), 47, ZERO, 0_intkind1, wf32(:,70), n2(227))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,326), wf32(:,71), n3(:,460), t3x32(:,:,40))
  call prop_A_Q(ntry, wf32(:,71), 47, ZERO, 0_intkind1, wf32(:,72), n2(228))
  call prop_Q_A(ntry, wf16(:,21), 71, ZERO, 0_intkind1, wf16(:,389), n2(229))
  call vert_QA_V(ntry, wf16(:,389), ex4(:), wf32(:,73), n3(:,461), t3x32(:,:,41))
  call vert_QA_Z(gZl,ntry, wf16(:,389), ex4(:), wf32(:,74), n3(:,462), t3x32(:,:,42))
  call prop_W_W(ntry, wf32(:,74), 79, MZ, 1_intkind1, wf32(:,75), n2(230))
  call prop_Q_A(ntry, wf16(:,22), 71, ZERO, 0_intkind1, wf16(:,390), n2(231))
  call vert_QA_V(ntry, wf16(:,390), ex4(:), wf32(:,76), n3(:,463), t3x32(:,:,43))
  call vert_QA_Z(gZl,ntry, wf16(:,390), ex4(:), wf32(:,77), n3(:,464), t3x32(:,:,44))
  call prop_W_W(ntry, wf32(:,77), 79, MZ, 1_intkind1, wf32(:,78), n2(232))
  call vert_VQ_A(ntry, wf16(:,37), ex5(:), wf32(:,79), n3(:,465), t3x32(:,:,45))
  call prop_Q_A(ntry, wf32(:,79), 31, ZERO, 0_intkind1, wf32(:,80), n2(233))
  call vert_ZQ_A(gZd,ntry, wf16(:,327), ex5(:), wf32(:,81), n3(:,466), t3x32(:,:,46))
  call prop_Q_A(ntry, wf32(:,81), 31, ZERO, 0_intkind1, wf32(:,82), n2(234))
  call vert_VQ_A(ntry, wf16(:,39), ex5(:), wf32(:,83), n3(:,467), t3x32(:,:,47))
  call prop_Q_A(ntry, wf32(:,83), 31, ZERO, 0_intkind1, wf32(:,84), n2(235))
  call vert_ZQ_A(gZd,ntry, wf16(:,328), ex5(:), wf32(:,85), n3(:,468), t3x32(:,:,48))
  call prop_Q_A(ntry, wf32(:,85), 31, ZERO, 0_intkind1, wf32(:,86), n2(236))
  call vert_AV_Q(ntry, ex6(:), wf16(:,37), wf32(:,87), n3(:,469), t3x32(:,:,49))
  call prop_A_Q(ntry, wf32(:,87), 47, ZERO, 0_intkind1, wf32(:,88), n2(237))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,327), wf32(:,89), n3(:,470), t3x32(:,:,50))
  call prop_A_Q(ntry, wf32(:,89), 47, ZERO, 0_intkind1, wf32(:,90), n2(238))
  call vert_AV_Q(ntry, ex6(:), wf16(:,39), wf32(:,91), n3(:,471), t3x32(:,:,51))
  call prop_A_Q(ntry, wf32(:,91), 47, ZERO, 0_intkind1, wf32(:,92), n2(239))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,328), wf32(:,93), n3(:,472), t3x32(:,:,52))
  call prop_A_Q(ntry, wf32(:,93), 47, ZERO, 0_intkind1, wf32(:,94), n2(240))
  call vert_AV_Q(ntry, wf8(:,18), ex7(:), wf16(:,391), n3(:,473), t3x16(:,:,305))
  call prop_A_Q(ntry, wf16(:,391), 77, ZERO, 0_intkind1, wf16(:,392), n2(241))
  call vert_QA_V(ntry, ex2(:), wf16(:,392), wf32(:,95), n3(:,474), t3x32(:,:,53))
  call vert_QA_Z(gZl,ntry, ex2(:), wf16(:,392), wf32(:,96), n3(:,475), t3x32(:,:,54))
  call prop_W_W(ntry, wf32(:,96), 79, MZ, 1_intkind1, wf32(:,97), n2(242))
  call vert_AV_Q(ntry, wf8(:,20), ex7(:), wf16(:,393), n3(:,476), t3x16(:,:,306))
  call prop_A_Q(ntry, wf16(:,393), 77, ZERO, 0_intkind1, wf16(:,394), n2(243))
  call vert_QA_V(ntry, ex2(:), wf16(:,394), wf32(:,98), n3(:,477), t3x32(:,:,55))
  call vert_QA_Z(gZl,ntry, ex2(:), wf16(:,394), wf32(:,99), n3(:,478), t3x32(:,:,56))
  call prop_W_W(ntry, wf32(:,99), 79, MZ, 1_intkind1, wf32(:,100), n2(244))
  call vert_VQ_A(ntry, wf4(:,19), wf8(:,54), wf32(:,101), n3(:,479), t3x32(:,:,57))
  call prop_Q_A(ntry, wf32(:,101), 31, ZERO, 0_intkind1, wf32(:,102), n2(245))
  call vert_ZQ_A(gZd,ntry, wf4(:,21), wf8(:,54), wf32(:,103), n3(:,480), t3x32(:,:,58))
  call prop_Q_A(ntry, wf32(:,103), 31, ZERO, 0_intkind1, wf32(:,104), n2(246))
  call vert_VQ_A(ntry, wf4(:,19), wf8(:,56), wf32(:,105), n3(:,481), t3x32(:,:,59))
  call prop_Q_A(ntry, wf32(:,105), 31, ZERO, 0_intkind1, wf32(:,106), n2(247))
  call vert_ZQ_A(gZd,ntry, wf4(:,21), wf8(:,56), wf32(:,107), n3(:,482), t3x32(:,:,60))
  call prop_Q_A(ntry, wf32(:,107), 31, ZERO, 0_intkind1, wf32(:,108), n2(248))
  call vert_AV_Q(ntry, wf8(:,46), wf4(:,19), wf32(:,109), n3(:,483), t3x32(:,:,61))
  call prop_A_Q(ntry, wf32(:,109), 47, ZERO, 0_intkind1, wf32(:,110), n2(249))
  call vert_AZ_Q(gZd,ntry, wf8(:,46), wf4(:,21), wf32(:,111), n3(:,484), t3x32(:,:,62))
  call prop_A_Q(ntry, wf32(:,111), 47, ZERO, 0_intkind1, wf32(:,112), n2(250))
  call vert_AV_Q(ntry, wf8(:,48), wf4(:,19), wf32(:,113), n3(:,485), t3x32(:,:,63))
  call prop_A_Q(ntry, wf32(:,113), 47, ZERO, 0_intkind1, wf32(:,114), n2(251))
  call vert_AZ_Q(gZd,ntry, wf8(:,48), wf4(:,21), wf32(:,115), n3(:,486), t3x32(:,:,64))
  call prop_A_Q(ntry, wf32(:,115), 47, ZERO, 0_intkind1, wf32(:,116), n2(252))
  call vert_VQ_A(ntry, wf4(:,18), wf8(:,58), wf32(:,117), n3(:,487), t3x32(:,:,65))
  call prop_Q_A(ntry, wf32(:,117), 31, ZERO, 0_intkind1, wf32(:,118), n2(253))
  call vert_VQ_A(ntry, wf4(:,18), wf8(:,60), wf32(:,119), n3(:,488), t3x32(:,:,66))
  call prop_Q_A(ntry, wf32(:,119), 31, ZERO, 0_intkind1, wf32(:,120), n2(254))
  call vert_ZQ_A(gZd,ntry, wf4(:,23), wf8(:,58), wf32(:,121), n3(:,489), t3x32(:,:,67))
  call prop_Q_A(ntry, wf32(:,121), 31, ZERO, 0_intkind1, wf32(:,122), n2(255))
  call vert_ZQ_A(gZd,ntry, wf4(:,23), wf8(:,60), wf32(:,123), n3(:,490), t3x32(:,:,68))
  call prop_Q_A(ntry, wf32(:,123), 31, ZERO, 0_intkind1, wf32(:,124), n2(256))
  call vert_AV_Q(ntry, wf8(:,50), wf4(:,18), wf32(:,125), n3(:,491), t3x32(:,:,69))
  call prop_A_Q(ntry, wf32(:,125), 47, ZERO, 0_intkind1, wf32(:,126), n2(257))
  call vert_AV_Q(ntry, wf8(:,52), wf4(:,18), wf32(:,127), n3(:,492), t3x32(:,:,70))
  call prop_A_Q(ntry, wf32(:,127), 47, ZERO, 0_intkind1, wf32(:,128), n2(258))
  call vert_AZ_Q(gZd,ntry, wf8(:,50), wf4(:,23), wf32(:,129), n3(:,493), t3x32(:,:,71))
  call prop_A_Q(ntry, wf32(:,129), 47, ZERO, 0_intkind1, wf32(:,130), n2(259))
  call vert_AZ_Q(gZd,ntry, wf8(:,52), wf4(:,23), wf32(:,131), n3(:,494), t3x32(:,:,72))
  call prop_A_Q(ntry, wf32(:,131), 47, ZERO, 0_intkind1, wf32(:,132), n2(260))
  call vert_QA_V(ntry, wf4(:,25), wf8(:,62), wf32(:,133), n3(:,495), t3x32(:,:,73))
  call vert_QA_Z(gZl,ntry, wf4(:,25), wf8(:,62), wf32(:,134), n3(:,496), t3x32(:,:,74))
  call prop_W_W(ntry, wf32(:,134), 79, MZ, 1_intkind1, wf32(:,135), n2(261))
  call vert_QA_V(ntry, wf4(:,25), wf8(:,64), wf32(:,136), n3(:,497), t3x32(:,:,75))
  call vert_QA_Z(gZl,ntry, wf4(:,25), wf8(:,64), wf32(:,137), n3(:,498), t3x32(:,:,76))
  call prop_W_W(ntry, wf32(:,137), 79, MZ, 1_intkind1, wf32(:,138), n2(262))
  call prop_Q_A(ntry, wf16(:,55), 71, ZERO, 0_intkind1, wf16(:,395), n2(263))
  call vert_QA_V(ntry, wf16(:,395), ex4(:), wf32(:,139), n3(:,499), t3x32(:,:,77))
  call vert_QA_Z(gZl,ntry, wf16(:,395), ex4(:), wf32(:,140), n3(:,500), t3x32(:,:,78))
  call prop_W_W(ntry, wf32(:,140), 79, MZ, 1_intkind1, wf32(:,141), n2(264))
  call prop_Q_A(ntry, wf16(:,56), 71, ZERO, 0_intkind1, wf16(:,396), n2(265))
  call vert_QA_V(ntry, wf16(:,396), ex4(:), wf32(:,142), n3(:,501), t3x32(:,:,79))
  call vert_QA_Z(gZl,ntry, wf16(:,396), ex4(:), wf32(:,143), n3(:,502), t3x32(:,:,80))
  call prop_W_W(ntry, wf32(:,143), 79, MZ, 1_intkind1, wf32(:,144), n2(266))
  call vert_QA_V(ntry, wf8(:,66), wf4(:,17), wf32(:,145), n3(:,503), t3x32(:,:,81))
  call vert_QA_Z(gZl,ntry, wf8(:,66), wf4(:,17), wf32(:,146), n3(:,504), t3x32(:,:,82))
  call prop_W_W(ntry, wf32(:,146), 79, MZ, 1_intkind1, wf32(:,147), n2(267))
  call vert_QA_V(ntry, wf8(:,68), wf4(:,17), wf32(:,148), n3(:,505), t3x32(:,:,83))
  call vert_QA_Z(gZl,ntry, wf8(:,68), wf4(:,17), wf32(:,149), n3(:,506), t3x32(:,:,84))
  call prop_W_W(ntry, wf32(:,149), 79, MZ, 1_intkind1, wf32(:,150), n2(268))
  call prop_A_Q(ntry, wf16(:,57), 78, ZERO, 0_intkind1, wf16(:,397), n2(269))
  call vert_QA_V(ntry, ex1(:), wf16(:,397), wf32(:,151), n3(:,507), t3x32(:,:,85))
  call prop_A_Q(ntry, wf16(:,58), 78, ZERO, 0_intkind1, wf16(:,398), n2(270))
  call vert_QA_V(ntry, ex1(:), wf16(:,398), wf32(:,152), n3(:,508), t3x32(:,:,86))
  call vert_QA_Z(gZl,ntry, ex1(:), wf16(:,397), wf32(:,153), n3(:,509), t3x32(:,:,87))
  call prop_W_W(ntry, wf32(:,153), 79, MZ, 1_intkind1, wf32(:,154), n2(271))
  call vert_QA_Z(gZl,ntry, ex1(:), wf16(:,398), wf32(:,155), n3(:,510), t3x32(:,:,88))
  call prop_W_W(ntry, wf32(:,155), 79, MZ, 1_intkind1, wf32(:,156), n2(272))
  call vert_VQ_A(ntry, wf16(:,71), ex5(:), wf32(:,157), n3(:,511), t3x32(:,:,89))
  call prop_Q_A(ntry, wf32(:,157), 31, ZERO, 0_intkind1, wf32(:,158), n2(273))
  call vert_ZQ_A(gZd,ntry, wf16(:,357), ex5(:), wf32(:,159), n3(:,512), t3x32(:,:,90))
  call prop_Q_A(ntry, wf32(:,159), 31, ZERO, 0_intkind1, wf32(:,160), n2(274))
  call vert_VQ_A(ntry, wf16(:,73), ex5(:), wf32(:,161), n3(:,513), t3x32(:,:,91))
  call prop_Q_A(ntry, wf32(:,161), 31, ZERO, 0_intkind1, wf32(:,162), n2(275))
  call vert_ZQ_A(gZd,ntry, wf16(:,358), ex5(:), wf32(:,163), n3(:,514), t3x32(:,:,92))
  call prop_Q_A(ntry, wf32(:,163), 31, ZERO, 0_intkind1, wf32(:,164), n2(276))
  call vert_AV_Q(ntry, ex6(:), wf16(:,71), wf32(:,165), n3(:,515), t3x32(:,:,93))
  call prop_A_Q(ntry, wf32(:,165), 47, ZERO, 0_intkind1, wf32(:,166), n2(277))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,357), wf32(:,167), n3(:,516), t3x32(:,:,94))
  call prop_A_Q(ntry, wf32(:,167), 47, ZERO, 0_intkind1, wf32(:,168), n2(278))
  call vert_AV_Q(ntry, ex6(:), wf16(:,73), wf32(:,169), n3(:,517), t3x32(:,:,95))
  call prop_A_Q(ntry, wf32(:,169), 47, ZERO, 0_intkind1, wf32(:,170), n2(279))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,358), wf32(:,171), n3(:,518), t3x32(:,:,96))
  call prop_A_Q(ntry, wf32(:,171), 47, ZERO, 0_intkind1, wf32(:,172), n2(280))
  call prop_Q_A(ntry, wf16(:,59), 71, ZERO, 0_intkind1, wf16(:,399), n2(281))
  call vert_QA_V(ntry, wf16(:,399), ex4(:), wf32(:,173), n3(:,519), t3x32(:,:,97))
  call vert_QA_Z(gZl,ntry, wf16(:,399), ex4(:), wf32(:,174), n3(:,520), t3x32(:,:,98))
  call prop_W_W(ntry, wf32(:,174), 79, MZ, 1_intkind1, wf32(:,175), n2(282))
  call prop_Q_A(ntry, wf16(:,60), 71, ZERO, 0_intkind1, wf16(:,400), n2(283))
  call vert_QA_V(ntry, wf16(:,400), ex4(:), wf32(:,176), n3(:,521), t3x32(:,:,99))
  call vert_QA_Z(gZl,ntry, wf16(:,400), ex4(:), wf32(:,177), n3(:,522), t3x32(:,:,100))
  call prop_W_W(ntry, wf32(:,177), 79, MZ, 1_intkind1, wf32(:,178), n2(284))
  call vert_VQ_A(ntry, wf16(:,75), ex5(:), wf32(:,179), n3(:,523), t3x32(:,:,101))
  call prop_Q_A(ntry, wf32(:,179), 31, ZERO, 0_intkind1, wf32(:,180), n2(285))
  call vert_VQ_A(ntry, wf16(:,76), ex5(:), wf32(:,181), n3(:,524), t3x32(:,:,102))
  call prop_Q_A(ntry, wf32(:,181), 31, ZERO, 0_intkind1, wf32(:,182), n2(286))
  call vert_ZQ_A(gZd,ntry, wf16(:,359), ex5(:), wf32(:,183), n3(:,525), t3x32(:,:,103))
  call prop_Q_A(ntry, wf32(:,183), 31, ZERO, 0_intkind1, wf32(:,184), n2(287))
  call vert_ZQ_A(gZd,ntry, wf16(:,360), ex5(:), wf32(:,185), n3(:,526), t3x32(:,:,104))
  call prop_Q_A(ntry, wf32(:,185), 31, ZERO, 0_intkind1, wf32(:,186), n2(288))
  call vert_AV_Q(ntry, ex6(:), wf16(:,75), wf32(:,187), n3(:,527), t3x32(:,:,105))
  call prop_A_Q(ntry, wf32(:,187), 47, ZERO, 0_intkind1, wf32(:,188), n2(289))
  call vert_AV_Q(ntry, ex6(:), wf16(:,76), wf32(:,189), n3(:,528), t3x32(:,:,106))
  call prop_A_Q(ntry, wf32(:,189), 47, ZERO, 0_intkind1, wf32(:,190), n2(290))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,359), wf32(:,191), n3(:,529), t3x32(:,:,107))
  call prop_A_Q(ntry, wf32(:,191), 47, ZERO, 0_intkind1, wf32(:,192), n2(291))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,360), wf32(:,193), n3(:,530), t3x32(:,:,108))
  call prop_A_Q(ntry, wf32(:,193), 47, ZERO, 0_intkind1, wf32(:,194), n2(292))
  call vert_AV_Q(ntry, wf8(:,62), ex7(:), wf16(:,401), n3(:,531), t3x16(:,:,307))
  call prop_A_Q(ntry, wf16(:,401), 78, ZERO, 0_intkind1, wf16(:,402), n2(293))
  call vert_QA_V(ntry, ex1(:), wf16(:,402), wf32(:,195), n3(:,532), t3x32(:,:,109))
  call vert_AV_Q(ntry, wf8(:,64), ex7(:), wf16(:,403), n3(:,533), t3x16(:,:,308))
  call prop_A_Q(ntry, wf16(:,403), 78, ZERO, 0_intkind1, wf16(:,404), n2(294))
  call vert_QA_V(ntry, ex1(:), wf16(:,404), wf32(:,196), n3(:,534), t3x32(:,:,110))
  call vert_QA_Z(gZl,ntry, ex1(:), wf16(:,402), wf32(:,197), n3(:,535), t3x32(:,:,111))
  call prop_W_W(ntry, wf32(:,197), 79, MZ, 1_intkind1, wf32(:,198), n2(295))
  call vert_QA_Z(gZl,ntry, ex1(:), wf16(:,404), wf32(:,199), n3(:,536), t3x32(:,:,112))
  call prop_W_W(ntry, wf32(:,199), 79, MZ, 1_intkind1, wf32(:,200), n2(296))
  call vert_QA_V(ntry, wf4(:,13), wf8(:,80), wf32(:,201), n3(:,537), t3x32(:,:,113))
  call vert_QA_Z(gZl,ntry, wf4(:,13), wf8(:,80), wf32(:,202), n3(:,538), t3x32(:,:,114))
  call prop_W_W(ntry, wf32(:,202), 79, MZ, 1_intkind1, wf32(:,203), n2(297))
  call vert_QA_V(ntry, wf4(:,13), wf8(:,82), wf32(:,204), n3(:,539), t3x32(:,:,115))
  call vert_QA_Z(gZl,ntry, wf4(:,13), wf8(:,82), wf32(:,205), n3(:,540), t3x32(:,:,116))
  call prop_W_W(ntry, wf32(:,205), 79, MZ, 1_intkind1, wf32(:,206), n2(298))
  call prop_Q_A(ntry, wf16(:,79), 75, ZERO, 0_intkind1, wf16(:,405), n2(299))
  call vert_QA_V(ntry, wf16(:,405), ex3(:), wf32(:,207), n3(:,541), t3x32(:,:,117))
  call vert_QA_Z(gZl,ntry, wf16(:,405), ex3(:), wf32(:,208), n3(:,542), t3x32(:,:,118))
  call prop_W_W(ntry, wf32(:,208), 79, MZ, 1_intkind1, wf32(:,209), n2(300))
  call prop_Q_A(ntry, wf16(:,80), 75, ZERO, 0_intkind1, wf16(:,406), n2(301))
  call vert_QA_V(ntry, wf16(:,406), ex3(:), wf32(:,210), n3(:,543), t3x32(:,:,119))
  call vert_QA_Z(gZl,ntry, wf16(:,406), ex3(:), wf32(:,211), n3(:,544), t3x32(:,:,120))
  call prop_W_W(ntry, wf32(:,211), 79, MZ, 1_intkind1, wf32(:,212), n2(302))
  call vert_QA_V(ntry, wf8(:,88), wf4(:,27), wf32(:,213), n3(:,545), t3x32(:,:,121))
  call vert_QA_Z(gZl,ntry, wf8(:,88), wf4(:,27), wf32(:,214), n3(:,546), t3x32(:,:,122))
  call prop_W_W(ntry, wf32(:,214), 79, MZ, 1_intkind1, wf32(:,215), n2(303))
  call vert_QA_V(ntry, wf8(:,90), wf4(:,27), wf32(:,216), n3(:,547), t3x32(:,:,123))
  call vert_QA_Z(gZl,ntry, wf8(:,90), wf4(:,27), wf32(:,217), n3(:,548), t3x32(:,:,124))
  call prop_W_W(ntry, wf32(:,217), 79, MZ, 1_intkind1, wf32(:,218), n2(304))
  call prop_A_Q(ntry, wf16(:,83), 77, ZERO, 0_intkind1, wf16(:,407), n2(305))
  call vert_QA_V(ntry, ex2(:), wf16(:,407), wf32(:,219), n3(:,549), t3x32(:,:,125))
  call vert_QA_Z(gZl,ntry, ex2(:), wf16(:,407), wf32(:,220), n3(:,550), t3x32(:,:,126))
  call prop_W_W(ntry, wf32(:,220), 79, MZ, 1_intkind1, wf32(:,221), n2(306))
  call prop_A_Q(ntry, wf16(:,84), 77, ZERO, 0_intkind1, wf16(:,408), n2(307))
  call vert_QA_V(ntry, ex2(:), wf16(:,408), wf32(:,222), n3(:,551), t3x32(:,:,127))
  call vert_QA_Z(gZl,ntry, ex2(:), wf16(:,408), wf32(:,223), n3(:,552), t3x32(:,:,128))
  call prop_W_W(ntry, wf32(:,223), 79, MZ, 1_intkind1, wf32(:,224), n2(308))
  call vert_VQ_A(ntry, wf16(:,95), ex5(:), wf32(:,225), n3(:,553), t3x32(:,:,129))
  call prop_Q_A(ntry, wf32(:,225), 31, ZERO, 0_intkind1, wf32(:,226), n2(309))
  call vert_ZQ_A(gZd,ntry, wf16(:,369), ex5(:), wf32(:,227), n3(:,554), t3x32(:,:,130))
  call prop_Q_A(ntry, wf32(:,227), 31, ZERO, 0_intkind1, wf32(:,228), n2(310))
  call vert_VQ_A(ntry, wf16(:,97), ex5(:), wf32(:,229), n3(:,555), t3x32(:,:,131))
  call prop_Q_A(ntry, wf32(:,229), 31, ZERO, 0_intkind1, wf32(:,230), n2(311))
  call vert_ZQ_A(gZd,ntry, wf16(:,370), ex5(:), wf32(:,231), n3(:,556), t3x32(:,:,132))
  call prop_Q_A(ntry, wf32(:,231), 31, ZERO, 0_intkind1, wf32(:,232), n2(312))
  call vert_AV_Q(ntry, ex6(:), wf16(:,95), wf32(:,233), n3(:,557), t3x32(:,:,133))
  call prop_A_Q(ntry, wf32(:,233), 47, ZERO, 0_intkind1, wf32(:,234), n2(313))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,369), wf32(:,235), n3(:,558), t3x32(:,:,134))
  call prop_A_Q(ntry, wf32(:,235), 47, ZERO, 0_intkind1, wf32(:,236), n2(314))
  call vert_AV_Q(ntry, ex6(:), wf16(:,97), wf32(:,237), n3(:,559), t3x32(:,:,135))
  call prop_A_Q(ntry, wf32(:,237), 47, ZERO, 0_intkind1, wf32(:,238), n2(315))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,370), wf32(:,239), n3(:,560), t3x32(:,:,136))
  call prop_A_Q(ntry, wf32(:,239), 47, ZERO, 0_intkind1, wf32(:,240), n2(316))
  call prop_Q_A(ntry, wf16(:,85), 75, ZERO, 0_intkind1, wf16(:,409), n2(317))
  call vert_QA_V(ntry, wf16(:,409), ex3(:), wf32(:,241), n3(:,561), t3x32(:,:,137))
  call vert_QA_Z(gZl,ntry, wf16(:,409), ex3(:), wf32(:,242), n3(:,562), t3x32(:,:,138))
  call prop_W_W(ntry, wf32(:,242), 79, MZ, 1_intkind1, wf32(:,243), n2(318))
  call prop_Q_A(ntry, wf16(:,86), 75, ZERO, 0_intkind1, wf16(:,410), n2(319))
  call vert_QA_V(ntry, wf16(:,410), ex3(:), wf32(:,244), n3(:,563), t3x32(:,:,139))
  call vert_QA_Z(gZl,ntry, wf16(:,410), ex3(:), wf32(:,245), n3(:,564), t3x32(:,:,140))
  call prop_W_W(ntry, wf32(:,245), 79, MZ, 1_intkind1, wf32(:,246), n2(320))
  call vert_VQ_A(ntry, wf16(:,99), ex5(:), wf32(:,247), n3(:,565), t3x32(:,:,141))
  call prop_Q_A(ntry, wf32(:,247), 31, ZERO, 0_intkind1, wf32(:,248), n2(321))
  call vert_ZQ_A(gZd,ntry, wf16(:,371), ex5(:), wf32(:,249), n3(:,566), t3x32(:,:,142))
  call prop_Q_A(ntry, wf32(:,249), 31, ZERO, 0_intkind1, wf32(:,250), n2(322))
  call vert_VQ_A(ntry, wf16(:,101), ex5(:), wf32(:,251), n3(:,567), t3x32(:,:,143))
  call prop_Q_A(ntry, wf32(:,251), 31, ZERO, 0_intkind1, wf32(:,252), n2(323))
  call vert_ZQ_A(gZd,ntry, wf16(:,372), ex5(:), wf32(:,253), n3(:,568), t3x32(:,:,144))
  call prop_Q_A(ntry, wf32(:,253), 31, ZERO, 0_intkind1, wf32(:,254), n2(324))
  call vert_AV_Q(ntry, ex6(:), wf16(:,99), wf32(:,255), n3(:,569), t3x32(:,:,145))
  call prop_A_Q(ntry, wf32(:,255), 47, ZERO, 0_intkind1, wf32(:,256), n2(325))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,371), wf32(:,257), n3(:,570), t3x32(:,:,146))
  call prop_A_Q(ntry, wf32(:,257), 47, ZERO, 0_intkind1, wf32(:,258), n2(326))
  call vert_AV_Q(ntry, ex6(:), wf16(:,101), wf32(:,259), n3(:,571), t3x32(:,:,147))
  call prop_A_Q(ntry, wf32(:,259), 47, ZERO, 0_intkind1, wf32(:,260), n2(327))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,372), wf32(:,261), n3(:,572), t3x32(:,:,148))
  call prop_A_Q(ntry, wf32(:,261), 47, ZERO, 0_intkind1, wf32(:,262), n2(328))
  call vert_AV_Q(ntry, wf8(:,80), ex7(:), wf16(:,411), n3(:,573), t3x16(:,:,309))
  call prop_A_Q(ntry, wf16(:,411), 77, ZERO, 0_intkind1, wf16(:,412), n2(329))
  call vert_QA_V(ntry, ex2(:), wf16(:,412), wf32(:,263), n3(:,574), t3x32(:,:,149))
  call vert_QA_Z(gZl,ntry, ex2(:), wf16(:,412), wf32(:,264), n3(:,575), t3x32(:,:,150))
  call prop_W_W(ntry, wf32(:,264), 79, MZ, 1_intkind1, wf32(:,265), n2(330))
  call vert_AV_Q(ntry, wf8(:,82), ex7(:), wf16(:,413), n3(:,576), t3x16(:,:,310))
  call prop_A_Q(ntry, wf16(:,413), 77, ZERO, 0_intkind1, wf16(:,414), n2(331))
  call vert_QA_V(ntry, ex2(:), wf16(:,414), wf32(:,266), n3(:,577), t3x32(:,:,151))
  call vert_QA_Z(gZl,ntry, ex2(:), wf16(:,414), wf32(:,267), n3(:,578), t3x32(:,:,152))
  call prop_W_W(ntry, wf32(:,267), 79, MZ, 1_intkind1, wf32(:,268), n2(332))
  call vert_QA_V(ntry, wf4(:,25), wf8(:,98), wf32(:,269), n3(:,579), t3x32(:,:,153))
  call vert_QA_Z(gZl,ntry, wf4(:,25), wf8(:,98), wf32(:,270), n3(:,580), t3x32(:,:,154))
  call prop_W_W(ntry, wf32(:,270), 79, MZ, 1_intkind1, wf32(:,271), n2(333))
  call vert_QA_V(ntry, wf4(:,25), wf8(:,100), wf32(:,272), n3(:,581), t3x32(:,:,155))
  call vert_QA_Z(gZl,ntry, wf4(:,25), wf8(:,100), wf32(:,273), n3(:,582), t3x32(:,:,156))
  call prop_W_W(ntry, wf32(:,273), 79, MZ, 1_intkind1, wf32(:,274), n2(334))
  call prop_Q_A(ntry, wf16(:,103), 75, ZERO, 0_intkind1, wf16(:,415), n2(335))
  call vert_QA_V(ntry, wf16(:,415), ex3(:), wf32(:,275), n3(:,583), t3x32(:,:,157))
  call vert_QA_Z(gZl,ntry, wf16(:,415), ex3(:), wf32(:,276), n3(:,584), t3x32(:,:,158))
  call prop_W_W(ntry, wf32(:,276), 79, MZ, 1_intkind1, wf32(:,277), n2(336))
  call prop_Q_A(ntry, wf16(:,104), 75, ZERO, 0_intkind1, wf16(:,416), n2(337))
  call vert_QA_V(ntry, wf16(:,416), ex3(:), wf32(:,278), n3(:,585), t3x32(:,:,159))
  call vert_QA_Z(gZl,ntry, wf16(:,416), ex3(:), wf32(:,279), n3(:,586), t3x32(:,:,160))
  call prop_W_W(ntry, wf32(:,279), 79, MZ, 1_intkind1, wf32(:,280), n2(338))
  call vert_QA_V(ntry, wf8(:,102), wf4(:,27), wf32(:,281), n3(:,587), t3x32(:,:,161))
  call vert_QA_Z(gZl,ntry, wf8(:,102), wf4(:,27), wf32(:,282), n3(:,588), t3x32(:,:,162))
  call prop_W_W(ntry, wf32(:,282), 79, MZ, 1_intkind1, wf32(:,283), n2(339))
  call vert_QA_V(ntry, wf8(:,104), wf4(:,27), wf32(:,284), n3(:,589), t3x32(:,:,163))
  call vert_QA_Z(gZl,ntry, wf8(:,104), wf4(:,27), wf32(:,285), n3(:,590), t3x32(:,:,164))
  call prop_W_W(ntry, wf32(:,285), 79, MZ, 1_intkind1, wf32(:,286), n2(340))
  call prop_A_Q(ntry, wf16(:,105), 78, ZERO, 0_intkind1, wf16(:,417), n2(341))
  call vert_QA_V(ntry, ex1(:), wf16(:,417), wf32(:,287), n3(:,591), t3x32(:,:,165))
  call prop_A_Q(ntry, wf16(:,106), 78, ZERO, 0_intkind1, wf16(:,418), n2(342))
  call vert_QA_V(ntry, ex1(:), wf16(:,418), wf32(:,288), n3(:,592), t3x32(:,:,166))
  call vert_QA_Z(gZl,ntry, ex1(:), wf16(:,417), wf32(:,289), n3(:,593), t3x32(:,:,167))
  call prop_W_W(ntry, wf32(:,289), 79, MZ, 1_intkind1, wf32(:,290), n2(343))
  call vert_QA_Z(gZl,ntry, ex1(:), wf16(:,418), wf32(:,291), n3(:,594), t3x32(:,:,168))
  call prop_W_W(ntry, wf32(:,291), 79, MZ, 1_intkind1, wf32(:,292), n2(344))
  call vert_VQ_A(ntry, wf16(:,117), ex5(:), wf32(:,293), n3(:,595), t3x32(:,:,169))
  call prop_Q_A(ntry, wf32(:,293), 31, ZERO, 0_intkind1, wf32(:,294), n2(345))
  call vert_ZQ_A(gZd,ntry, wf16(:,381), ex5(:), wf32(:,295), n3(:,596), t3x32(:,:,170))
  call prop_Q_A(ntry, wf32(:,295), 31, ZERO, 0_intkind1, wf32(:,296), n2(346))
  call vert_VQ_A(ntry, wf16(:,119), ex5(:), wf32(:,297), n3(:,597), t3x32(:,:,171))
  call prop_Q_A(ntry, wf32(:,297), 31, ZERO, 0_intkind1, wf32(:,298), n2(347))
  call vert_ZQ_A(gZd,ntry, wf16(:,382), ex5(:), wf32(:,299), n3(:,598), t3x32(:,:,172))
  call prop_Q_A(ntry, wf32(:,299), 31, ZERO, 0_intkind1, wf32(:,300), n2(348))
  call vert_AV_Q(ntry, ex6(:), wf16(:,117), wf32(:,301), n3(:,599), t3x32(:,:,173))
  call prop_A_Q(ntry, wf32(:,301), 47, ZERO, 0_intkind1, wf32(:,302), n2(349))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,381), wf32(:,303), n3(:,600), t3x32(:,:,174))
  call prop_A_Q(ntry, wf32(:,303), 47, ZERO, 0_intkind1, wf32(:,304), n2(350))
  call vert_AV_Q(ntry, ex6(:), wf16(:,119), wf32(:,305), n3(:,601), t3x32(:,:,175))
  call prop_A_Q(ntry, wf32(:,305), 47, ZERO, 0_intkind1, wf32(:,306), n2(351))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,382), wf32(:,307), n3(:,602), t3x32(:,:,176))
  call prop_A_Q(ntry, wf32(:,307), 47, ZERO, 0_intkind1, wf32(:,308), n2(352))
  call prop_Q_A(ntry, wf16(:,107), 75, ZERO, 0_intkind1, wf16(:,419), n2(353))
  call vert_QA_V(ntry, wf16(:,419), ex3(:), wf32(:,309), n3(:,603), t3x32(:,:,177))
  call vert_QA_Z(gZl,ntry, wf16(:,419), ex3(:), wf32(:,310), n3(:,604), t3x32(:,:,178))
  call prop_W_W(ntry, wf32(:,310), 79, MZ, 1_intkind1, wf32(:,311), n2(354))
  call prop_Q_A(ntry, wf16(:,108), 75, ZERO, 0_intkind1, wf16(:,420), n2(355))
  call vert_QA_V(ntry, wf16(:,420), ex3(:), wf32(:,312), n3(:,605), t3x32(:,:,179))
  call vert_QA_Z(gZl,ntry, wf16(:,420), ex3(:), wf32(:,313), n3(:,606), t3x32(:,:,180))
  call prop_W_W(ntry, wf32(:,313), 79, MZ, 1_intkind1, wf32(:,314), n2(356))
  call vert_VQ_A(ntry, wf16(:,121), ex5(:), wf32(:,315), n3(:,607), t3x32(:,:,181))
  call prop_Q_A(ntry, wf32(:,315), 31, ZERO, 0_intkind1, wf32(:,316), n2(357))
  call vert_VQ_A(ntry, wf16(:,122), ex5(:), wf32(:,317), n3(:,608), t3x32(:,:,182))
  call prop_Q_A(ntry, wf32(:,317), 31, ZERO, 0_intkind1, wf32(:,318), n2(358))
  call vert_ZQ_A(gZd,ntry, wf16(:,383), ex5(:), wf32(:,319), n3(:,609), t3x32(:,:,183))
  call prop_Q_A(ntry, wf32(:,319), 31, ZERO, 0_intkind1, wf32(:,320), n2(359))
  call vert_ZQ_A(gZd,ntry, wf16(:,384), ex5(:), wf32(:,321), n3(:,610), t3x32(:,:,184))
  call prop_Q_A(ntry, wf32(:,321), 31, ZERO, 0_intkind1, wf32(:,322), n2(360))
  call vert_AV_Q(ntry, ex6(:), wf16(:,121), wf32(:,323), n3(:,611), t3x32(:,:,185))
  call prop_A_Q(ntry, wf32(:,323), 47, ZERO, 0_intkind1, wf32(:,324), n2(361))
  call vert_AV_Q(ntry, ex6(:), wf16(:,122), wf32(:,325), n3(:,612), t3x32(:,:,186))
  call prop_A_Q(ntry, wf32(:,325), 47, ZERO, 0_intkind1, wf32(:,326), n2(362))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,383), wf32(:,327), n3(:,613), t3x32(:,:,187))
  call prop_A_Q(ntry, wf32(:,327), 47, ZERO, 0_intkind1, wf32(:,328), n2(363))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf16(:,384), wf32(:,329), n3(:,614), t3x32(:,:,188))
  call prop_A_Q(ntry, wf32(:,329), 47, ZERO, 0_intkind1, wf32(:,330), n2(364))
  call vert_AV_Q(ntry, wf8(:,98), ex7(:), wf16(:,421), n3(:,615), t3x16(:,:,311))
  call prop_A_Q(ntry, wf16(:,421), 78, ZERO, 0_intkind1, wf16(:,422), n2(365))
  call vert_QA_V(ntry, ex1(:), wf16(:,422), wf32(:,331), n3(:,616), t3x32(:,:,189))
  call vert_AV_Q(ntry, wf8(:,100), ex7(:), wf16(:,423), n3(:,617), t3x16(:,:,312))
  call prop_A_Q(ntry, wf16(:,423), 78, ZERO, 0_intkind1, wf16(:,424), n2(366))
  call vert_QA_V(ntry, ex1(:), wf16(:,424), wf32(:,332), n3(:,618), t3x32(:,:,190))
  call vert_QA_Z(gZl,ntry, ex1(:), wf16(:,422), wf32(:,333), n3(:,619), t3x32(:,:,191))
  call prop_W_W(ntry, wf32(:,333), 79, MZ, 1_intkind1, wf32(:,334), n2(367))
  call vert_QA_Z(gZl,ntry, ex1(:), wf16(:,424), wf32(:,335), n3(:,620), t3x32(:,:,192))
  call prop_W_W(ntry, wf32(:,335), 79, MZ, 1_intkind1, wf32(:,336), n2(368))
  call prop_Q_A(ntry, wf16(:,125), 71, ZERO, 0_intkind1, wf16(:,425), n2(369))
  call vert_QA_V(ntry, wf16(:,425), ex4(:), wf32(:,337), n3(:,621), t3x32(:,:,193))
  call vert_QA_Z(gZl,ntry, wf16(:,425), ex4(:), wf32(:,338), n3(:,622), t3x32(:,:,194))
  call prop_W_W(ntry, wf32(:,338), 79, MZ, 1_intkind1, wf32(:,339), n2(370))
  call prop_Q_A(ntry, wf16(:,126), 71, ZERO, 0_intkind1, wf16(:,426), n2(371))
  call vert_QA_V(ntry, wf16(:,426), ex4(:), wf32(:,340), n3(:,623), t3x32(:,:,195))
  call vert_QA_Z(gZl,ntry, wf16(:,426), ex4(:), wf32(:,341), n3(:,624), t3x32(:,:,196))
  call prop_W_W(ntry, wf32(:,341), 79, MZ, 1_intkind1, wf32(:,342), n2(372))
  call vert_AV_Q(ntry, ex4(:), wf8(:,105), wf16(:,427), n3(:,625), t3x16(:,:,313))
  call prop_A_Q(ntry, wf16(:,427), 77, ZERO, 0_intkind1, wf16(:,428), n2(373))
  call vert_QA_V(ntry, ex2(:), wf16(:,428), wf32(:,343), n3(:,626), t3x32(:,:,197))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf8(:,107), wf16(:,429), n3(:,627), t3x16(:,:,314))
  call prop_A_Q(ntry, wf16(:,429), 77, ZERO, 0_intkind1, wf16(:,430), n2(374))
  call vert_QA_V(ntry, ex2(:), wf16(:,430), wf32(:,344), n3(:,628), t3x32(:,:,198))
  call vert_QA_Z(gZl,ntry, ex2(:), wf16(:,428), wf32(:,345), n3(:,629), t3x32(:,:,199))
  call prop_W_W(ntry, wf32(:,345), 79, MZ, 1_intkind1, wf32(:,346), n2(375))
  call vert_QA_Z(gZl,ntry, ex2(:), wf16(:,430), wf32(:,347), n3(:,630), t3x32(:,:,200))
  call prop_W_W(ntry, wf32(:,347), 79, MZ, 1_intkind1, wf32(:,348), n2(376))
  call vert_VQ_A(ntry, wf8(:,73), ex2(:), wf16(:,431), n3(:,631), t3x16(:,:,315))
  call prop_Q_A(ntry, wf16(:,431), 75, ZERO, 0_intkind1, wf16(:,432), n2(377))
  call vert_QA_V(ntry, wf16(:,432), ex3(:), wf32(:,349), n3(:,632), t3x32(:,:,201))
  call vert_QA_Z(gZl,ntry, wf16(:,432), ex3(:), wf32(:,350), n3(:,633), t3x32(:,:,202))
  call prop_W_W(ntry, wf32(:,350), 79, MZ, 1_intkind1, wf32(:,351), n2(378))
  call vert_ZQ_A(gZl,ntry, wf8(:,75), ex2(:), wf16(:,433), n3(:,634), t3x16(:,:,316))
  call prop_Q_A(ntry, wf16(:,433), 75, ZERO, 0_intkind1, wf16(:,434), n2(379))
  call vert_QA_V(ntry, wf16(:,434), ex3(:), wf32(:,352), n3(:,635), t3x32(:,:,203))
  call vert_QA_Z(gZl,ntry, wf16(:,434), ex3(:), wf32(:,353), n3(:,636), t3x32(:,:,204))
  call prop_W_W(ntry, wf32(:,353), 79, MZ, 1_intkind1, wf32(:,354), n2(380))
  call vert_AV_Q(ntry, ex3(:), wf8(:,73), wf16(:,435), n3(:,637), t3x16(:,:,317))
  call prop_A_Q(ntry, wf16(:,435), 77, ZERO, 0_intkind1, wf16(:,436), n2(381))
  call vert_QA_V(ntry, ex2(:), wf16(:,436), wf32(:,355), n3(:,638), t3x32(:,:,205))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf8(:,75), wf16(:,437), n3(:,639), t3x16(:,:,318))
  call prop_A_Q(ntry, wf16(:,437), 77, ZERO, 0_intkind1, wf16(:,438), n2(382))
  call vert_QA_V(ntry, ex2(:), wf16(:,438), wf32(:,356), n3(:,640), t3x32(:,:,206))
  call vert_QA_Z(gZl,ntry, ex2(:), wf16(:,436), wf32(:,357), n3(:,641), t3x32(:,:,207))
  call prop_W_W(ntry, wf32(:,357), 79, MZ, 1_intkind1, wf32(:,358), n2(383))
  call vert_QA_Z(gZl,ntry, ex2(:), wf16(:,438), wf32(:,359), n3(:,642), t3x32(:,:,208))
  call prop_W_W(ntry, wf32(:,359), 79, MZ, 1_intkind1, wf32(:,360), n2(384))
  call prop_Q_A(ntry, wf16(:,139), 71, ZERO, 0_intkind1, wf16(:,439), n2(385))
  call vert_QA_V(ntry, wf16(:,439), ex4(:), wf32(:,361), n3(:,643), t3x32(:,:,209))
  call vert_QA_Z(gZl,ntry, wf16(:,439), ex4(:), wf32(:,362), n3(:,644), t3x32(:,:,210))
  call prop_W_W(ntry, wf32(:,362), 79, MZ, 1_intkind1, wf32(:,363), n2(386))
  call prop_Q_A(ntry, wf16(:,140), 71, ZERO, 0_intkind1, wf16(:,440), n2(387))
  call vert_QA_V(ntry, wf16(:,440), ex4(:), wf32(:,364), n3(:,645), t3x32(:,:,211))
  call vert_QA_Z(gZl,ntry, wf16(:,440), ex4(:), wf32(:,365), n3(:,646), t3x32(:,:,212))
  call prop_W_W(ntry, wf32(:,365), 79, MZ, 1_intkind1, wf32(:,366), n2(388))
  call vert_VQ_A(ntry, wf8(:,33), ex1(:), wf16(:,441), n3(:,647), t3x16(:,:,319))
  call prop_Q_A(ntry, wf16(:,441), 75, ZERO, 0_intkind1, wf16(:,442), n2(389))
  call vert_QA_V(ntry, wf16(:,442), ex3(:), wf32(:,367), n3(:,648), t3x32(:,:,213))
  call vert_QA_Z(gZl,ntry, wf16(:,442), ex3(:), wf32(:,368), n3(:,649), t3x32(:,:,214))
  call prop_W_W(ntry, wf32(:,368), 79, MZ, 1_intkind1, wf32(:,369), n2(390))
  call vert_ZQ_A(gZl,ntry, wf8(:,35), ex1(:), wf16(:,443), n3(:,650), t3x16(:,:,320))
  call prop_Q_A(ntry, wf16(:,443), 75, ZERO, 0_intkind1, wf16(:,444), n2(391))
  call vert_QA_V(ntry, wf16(:,444), ex3(:), wf32(:,370), n3(:,651), t3x32(:,:,215))
  call vert_QA_Z(gZl,ntry, wf16(:,444), ex3(:), wf32(:,371), n3(:,652), t3x32(:,:,216))
  call prop_W_W(ntry, wf32(:,371), 79, MZ, 1_intkind1, wf32(:,372), n2(392))
  call vert_AV_Q(ntry, ex3(:), wf8(:,33), wf16(:,445), n3(:,653), t3x16(:,:,321))
  call prop_A_Q(ntry, wf16(:,445), 78, ZERO, 0_intkind1, wf16(:,446), n2(393))
  call vert_QA_V(ntry, ex1(:), wf16(:,446), wf32(:,373), n3(:,654), t3x32(:,:,217))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf8(:,35), wf16(:,447), n3(:,655), t3x16(:,:,322))
  call prop_A_Q(ntry, wf16(:,447), 78, ZERO, 0_intkind1, wf16(:,448), n2(394))
  call vert_QA_V(ntry, ex1(:), wf16(:,448), wf32(:,374), n3(:,656), t3x32(:,:,218))
  call vert_QA_Z(gZl,ntry, ex1(:), wf16(:,446), wf32(:,375), n3(:,657), t3x32(:,:,219))
  call prop_W_W(ntry, wf32(:,375), 79, MZ, 1_intkind1, wf32(:,376), n2(395))
  call vert_QA_Z(gZl,ntry, ex1(:), wf16(:,448), wf32(:,377), n3(:,658), t3x32(:,:,220))
  call prop_W_W(ntry, wf32(:,377), 79, MZ, 1_intkind1, wf32(:,378), n2(396))
  call vert_AV_Q(ntry, ex4(:), wf8(:,91), wf16(:,449), n3(:,659), t3x16(:,:,323))
  call prop_A_Q(ntry, wf16(:,449), 78, ZERO, 0_intkind1, wf16(:,450), n2(397))
  call vert_QA_V(ntry, ex1(:), wf16(:,450), wf32(:,379), n3(:,660), t3x32(:,:,221))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf8(:,93), wf16(:,451), n3(:,661), t3x16(:,:,324))
  call prop_A_Q(ntry, wf16(:,451), 78, ZERO, 0_intkind1, wf16(:,452), n2(398))
  call vert_QA_V(ntry, ex1(:), wf16(:,452), wf32(:,380), n3(:,662), t3x32(:,:,222))
  call vert_QA_Z(gZl,ntry, ex1(:), wf16(:,450), wf32(:,381), n3(:,663), t3x32(:,:,223))
  call prop_W_W(ntry, wf32(:,381), 79, MZ, 1_intkind1, wf32(:,382), n2(399))
  call vert_QA_Z(gZl,ntry, ex1(:), wf16(:,452), wf32(:,383), n3(:,664), t3x32(:,:,224))
  call prop_W_W(ntry, wf32(:,383), 79, MZ, 1_intkind1, wf32(:,384), n2(400))
  call prop_Q_A(ntry, wf16(:,153), 71, ZERO, 0_intkind1, wf16(:,453), n2(401))
  call vert_QA_V(ntry, wf16(:,453), ex4(:), wf32(:,385), n3(:,665), t3x32(:,:,225))
  call vert_QA_Z(gZl,ntry, wf16(:,453), ex4(:), wf32(:,386), n3(:,666), t3x32(:,:,226))
  call prop_W_W(ntry, wf32(:,386), 79, MZ, 1_intkind1, wf32(:,387), n2(402))
  call prop_Q_A(ntry, wf16(:,154), 71, ZERO, 0_intkind1, wf16(:,454), n2(403))
  call vert_QA_V(ntry, wf16(:,454), ex4(:), wf32(:,388), n3(:,667), t3x32(:,:,227))
  call vert_QA_Z(gZl,ntry, wf16(:,454), ex4(:), wf32(:,389), n3(:,668), t3x32(:,:,228))
  call prop_W_W(ntry, wf32(:,389), 79, MZ, 1_intkind1, wf32(:,390), n2(404))
  call prop_Q_A(ntry, wf16(:,155), 71, ZERO, 0_intkind1, wf16(:,455), n2(405))
  call vert_QA_V(ntry, wf16(:,455), ex4(:), wf32(:,391), n3(:,669), t3x32(:,:,229))
  call vert_QA_Z(gZl,ntry, wf16(:,455), ex4(:), wf32(:,392), n3(:,670), t3x32(:,:,230))
  call prop_W_W(ntry, wf32(:,392), 79, MZ, 1_intkind1, wf32(:,393), n2(406))
  call prop_Q_A(ntry, wf16(:,156), 71, ZERO, 0_intkind1, wf16(:,456), n2(407))
  call vert_QA_V(ntry, wf16(:,456), ex4(:), wf32(:,394), n3(:,671), t3x32(:,:,231))
  call vert_QA_Z(gZl,ntry, wf16(:,456), ex4(:), wf32(:,395), n3(:,672), t3x32(:,:,232))
  call prop_W_W(ntry, wf32(:,395), 79, MZ, 1_intkind1, wf32(:,396), n2(408))
  call prop_A_Q(ntry, wf16(:,157), 77, ZERO, 0_intkind1, wf16(:,457), n2(409))
  call vert_QA_V(ntry, ex2(:), wf16(:,457), wf32(:,397), n3(:,673), t3x32(:,:,233))
  call vert_QA_Z(gZl,ntry, ex2(:), wf16(:,457), wf32(:,398), n3(:,674), t3x32(:,:,234))
  call prop_W_W(ntry, wf32(:,398), 79, MZ, 1_intkind1, wf32(:,399), n2(410))
  call prop_A_Q(ntry, wf16(:,158), 77, ZERO, 0_intkind1, wf16(:,458), n2(411))
  call vert_QA_V(ntry, ex2(:), wf16(:,458), wf32(:,400), n3(:,675), t3x32(:,:,235))
  call vert_QA_Z(gZl,ntry, ex2(:), wf16(:,458), wf32(:,401), n3(:,676), t3x32(:,:,236))
  call prop_W_W(ntry, wf32(:,401), 79, MZ, 1_intkind1, wf32(:,402), n2(412))
  call vert_AV_Q(ntry, ex4(:), wf8(:,94), wf16(:,459), n3(:,677), t3x16(:,:,325))
  call prop_A_Q(ntry, wf16(:,459), 78, ZERO, 0_intkind1, wf16(:,460), n2(413))
  call vert_QA_V(ntry, ex1(:), wf16(:,460), wf32(:,403), n3(:,678), t3x32(:,:,237))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf8(:,96), wf16(:,461), n3(:,679), t3x16(:,:,326))
  call prop_A_Q(ntry, wf16(:,461), 78, ZERO, 0_intkind1, wf16(:,462), n2(414))
  call vert_QA_V(ntry, ex1(:), wf16(:,462), wf32(:,404), n3(:,680), t3x32(:,:,238))
  call vert_QA_Z(gZl,ntry, ex1(:), wf16(:,460), wf32(:,405), n3(:,681), t3x32(:,:,239))
  call prop_W_W(ntry, wf32(:,405), 79, MZ, 1_intkind1, wf32(:,406), n2(415))
  call vert_QA_Z(gZl,ntry, ex1(:), wf16(:,462), wf32(:,407), n3(:,682), t3x32(:,:,240))
  call prop_W_W(ntry, wf32(:,407), 79, MZ, 1_intkind1, wf32(:,408), n2(416))
  call prop_Q_A(ntry, wf16(:,159), 75, ZERO, 0_intkind1, wf16(:,463), n2(417))
  call vert_QA_V(ntry, wf16(:,463), ex3(:), wf32(:,409), n3(:,683), t3x32(:,:,241))
  call vert_QA_Z(gZl,ntry, wf16(:,463), ex3(:), wf32(:,410), n3(:,684), t3x32(:,:,242))
  call prop_W_W(ntry, wf32(:,410), 79, MZ, 1_intkind1, wf32(:,411), n2(418))
  call prop_Q_A(ntry, wf16(:,160), 75, ZERO, 0_intkind1, wf16(:,464), n2(419))
  call vert_QA_V(ntry, wf16(:,464), ex3(:), wf32(:,412), n3(:,685), t3x32(:,:,243))
  call vert_QA_Z(gZl,ntry, wf16(:,464), ex3(:), wf32(:,413), n3(:,686), t3x32(:,:,244))
  call prop_W_W(ntry, wf32(:,413), 79, MZ, 1_intkind1, wf32(:,414), n2(420))
  call prop_Q_A(ntry, wf16(:,161), 75, ZERO, 0_intkind1, wf16(:,465), n2(421))
  call vert_QA_V(ntry, wf16(:,465), ex3(:), wf32(:,415), n3(:,687), t3x32(:,:,245))
  call vert_QA_Z(gZl,ntry, wf16(:,465), ex3(:), wf32(:,416), n3(:,688), t3x32(:,:,246))
  call prop_W_W(ntry, wf32(:,416), 79, MZ, 1_intkind1, wf32(:,417), n2(422))
  call prop_Q_A(ntry, wf16(:,162), 75, ZERO, 0_intkind1, wf16(:,466), n2(423))
  call vert_QA_V(ntry, wf16(:,466), ex3(:), wf32(:,418), n3(:,689), t3x32(:,:,247))
  call vert_QA_Z(gZl,ntry, wf16(:,466), ex3(:), wf32(:,419), n3(:,690), t3x32(:,:,248))
  call prop_W_W(ntry, wf32(:,419), 79, MZ, 1_intkind1, wf32(:,420), n2(424))
  call prop_A_Q(ntry, wf16(:,163), 77, ZERO, 0_intkind1, wf16(:,467), n2(425))
  call vert_QA_V(ntry, ex2(:), wf16(:,467), wf32(:,421), n3(:,691), t3x32(:,:,249))
  call vert_QA_Z(gZl,ntry, ex2(:), wf16(:,467), wf32(:,422), n3(:,692), t3x32(:,:,250))
  call prop_W_W(ntry, wf32(:,422), 79, MZ, 1_intkind1, wf32(:,423), n2(426))
  call prop_A_Q(ntry, wf16(:,164), 77, ZERO, 0_intkind1, wf16(:,468), n2(427))
  call vert_QA_V(ntry, ex2(:), wf16(:,468), wf32(:,424), n3(:,693), t3x32(:,:,251))
  call vert_QA_Z(gZl,ntry, ex2(:), wf16(:,468), wf32(:,425), n3(:,694), t3x32(:,:,252))
  call prop_W_W(ntry, wf32(:,425), 79, MZ, 1_intkind1, wf32(:,426), n2(428))
  call vert_AV_Q(ntry, ex3(:), wf8(:,36), wf16(:,469), n3(:,695), t3x16(:,:,327))
  call prop_A_Q(ntry, wf16(:,469), 78, ZERO, 0_intkind1, wf16(:,470), n2(429))
  call vert_QA_V(ntry, ex1(:), wf16(:,470), wf32(:,427), n3(:,696), t3x32(:,:,253))
  call vert_AZ_Q(gZl,ntry, ex3(:), wf8(:,38), wf16(:,471), n3(:,697), t3x16(:,:,328))
  call prop_A_Q(ntry, wf16(:,471), 78, ZERO, 0_intkind1, wf16(:,472), n2(430))
  call vert_QA_V(ntry, ex1(:), wf16(:,472), wf32(:,428), n3(:,698), t3x32(:,:,254))
  call vert_QA_Z(gZl,ntry, ex1(:), wf16(:,470), wf32(:,429), n3(:,699), t3x32(:,:,255))
  call prop_W_W(ntry, wf32(:,429), 79, MZ, 1_intkind1, wf32(:,430), n2(431))
  call vert_QA_Z(gZl,ntry, ex1(:), wf16(:,472), wf32(:,431), n3(:,700), t3x32(:,:,256))
  call prop_W_W(ntry, wf32(:,431), 79, MZ, 1_intkind1, wf32(:,432), n2(432))


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  if (ntry < 2) then
    if(hel_mem_opt) hel_states = nhel
    call allocate_diagrams()
  end if

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do

#if -1 > 0 && 7 > 3
  if (loopcc) then
    !!Born-loop colour correlators interference
    
    M0M1_hel_cc(:,:,:)%j = 0
    M2ctcc = 0
    do n = 1, 14
      M2add_ct = 0
      m = ind_cc_comb(n)
        do k = 1, nhel
          call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
          call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
          M2ctcc(m) = M2ctcc(m) + M2add_ct
        end do
    end do
    M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
    M0M1_hel_cc(:,nhel+1:,:)%j = 0
  end if
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5,i6,i7
integer :: n

n=0

do i7= 1, 2
do i6= 1, 2
do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2) .OR. (ex7(i7)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf + ex7(i7)%hf
 end if
end do
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_QA(nsync, wf16(:,1), wf8(:,2), A(:,1), n3(:,701), t3x128(:,:,1), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,2), A(:,2), n3(:,702), t3x128(:,:,2), nhel, den(10))
    call Hcont_QA(nsync, wf16(:,1), wf8(:,4), A(:,3), n3(:,703), t3x128(:,:,3), nhel, den(13))
    call Hcont_QA(nsync, wf16(:,2), wf8(:,4), A(:,4), n3(:,704), t3x128(:,:,4), nhel, den(14))
    call Hcont_QA(nsync, wf16(:,3), wf8(:,6), A(:,5), n3(:,705), t3x128(:,:,5), nhel, den(18))
    call Hcont_QA(nsync, wf16(:,3), wf8(:,8), A(:,6), n3(:,706), t3x128(:,:,6), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,4), A(:,7), n3(:,707), t3x128(:,:,7), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,4), A(:,8), n3(:,708), t3x128(:,:,8), nhel, den(23))
    call Hcont_QA(nsync, wf16(:,5), wf8(:,10), A(:,9), n3(:,709), t3x128(:,:,9), nhel, den(28))
    call Hcont_QA(nsync, wf8(:,10), wf16(:,6), A(:,10), n3(:,710), t3x128(:,:,10), nhel, den(30))
    call Hcont_QA(nsync, wf16(:,5), wf8(:,12), A(:,11), n3(:,711), t3x128(:,:,11), nhel, den(32))
    call Hcont_QA(nsync, wf16(:,6), wf8(:,12), A(:,12), n3(:,712), t3x128(:,:,12), nhel, den(33))
    call Hcont_QA(nsync, wf16(:,7), wf8(:,14), A(:,13), n3(:,713), t3x128(:,:,13), nhel, den(37))
    call Hcont_QA(nsync, wf16(:,7), wf8(:,16), A(:,14), n3(:,714), t3x128(:,:,14), nhel, den(39))
    call Hcont_QA(nsync, wf8(:,14), wf16(:,8), A(:,15), n3(:,715), t3x128(:,:,15), nhel, den(41))
    call Hcont_QA(nsync, wf8(:,16), wf16(:,8), A(:,16), n3(:,716), t3x128(:,:,16), nhel, den(42))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,9), A(:,17), n3(:,717), t3x128(:,:,17), nhel, den(43))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,9), A(:,18), n3(:,718), t3x128(:,:,18), nhel, den(44))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,10), A(:,19), n3(:,719), t3x128(:,:,19), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,10), A(:,20), n3(:,720), t3x128(:,:,20), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,11), A(:,21), n3(:,721), t3x128(:,:,21), nhel, den(47))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,12), A(:,22), n3(:,722), t3x128(:,:,22), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,11), A(:,23), n3(:,723), t3x128(:,:,23), nhel, den(49))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,12), A(:,24), n3(:,724), t3x128(:,:,24), nhel, den(50))
    call Hcont_QA(nsync, wf16(:,13), wf8(:,18), A(:,25), n3(:,725), t3x128(:,:,25), nhel, den(56))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,14), A(:,26), n3(:,726), t3x128(:,:,26), nhel, den(59))
    call Hcont_QA(nsync, wf16(:,13), wf8(:,20), A(:,27), n3(:,727), t3x128(:,:,27), nhel, den(61))
    call Hcont_QA(nsync, wf16(:,14), wf8(:,20), A(:,28), n3(:,728), t3x128(:,:,28), nhel, den(62))
    call Hcont_QA(nsync, wf16(:,15), wf8(:,22), A(:,29), n3(:,729), t3x128(:,:,29), nhel, den(66))
    call Hcont_QA(nsync, wf16(:,15), wf8(:,24), A(:,30), n3(:,730), t3x128(:,:,30), nhel, den(68))
    call Hcont_QA(nsync, wf8(:,22), wf16(:,16), A(:,31), n3(:,731), t3x128(:,:,31), nhel, den(70))
    call Hcont_QA(nsync, wf8(:,24), wf16(:,16), A(:,32), n3(:,732), t3x128(:,:,32), nhel, den(71))
    call Hcont_QA(nsync, wf16(:,17), wf8(:,26), A(:,33), n3(:,733), t3x128(:,:,33), nhel, den(76))
    call Hcont_QA(nsync, wf8(:,26), wf16(:,18), A(:,34), n3(:,734), t3x128(:,:,34), nhel, den(78))
    call Hcont_QA(nsync, wf16(:,17), wf8(:,28), A(:,35), n3(:,735), t3x128(:,:,35), nhel, den(80))
    call Hcont_QA(nsync, wf16(:,18), wf8(:,28), A(:,36), n3(:,736), t3x128(:,:,36), nhel, den(81))
    call Hcont_QA(nsync, wf16(:,19), wf8(:,30), A(:,37), n3(:,737), t3x128(:,:,37), nhel, den(85))
    call Hcont_QA(nsync, wf16(:,19), wf8(:,32), A(:,38), n3(:,738), t3x128(:,:,38), nhel, den(87))
    call Hcont_QA(nsync, wf8(:,30), wf16(:,20), A(:,39), n3(:,739), t3x128(:,:,39), nhel, den(89))
    call Hcont_QA(nsync, wf8(:,32), wf16(:,20), A(:,40), n3(:,740), t3x128(:,:,40), nhel, den(90))
    call Hcont_QA(nsync, wf8(:,22), wf16(:,21), A(:,41), n3(:,741), t3x128(:,:,41), nhel, den(91))
    call Hcont_QA(nsync, wf8(:,24), wf16(:,21), A(:,42), n3(:,742), t3x128(:,:,42), nhel, den(92))
    call Hcont_QA(nsync, wf8(:,22), wf16(:,22), A(:,43), n3(:,743), t3x128(:,:,43), nhel, den(93))
    call Hcont_QA(nsync, wf8(:,24), wf16(:,22), A(:,44), n3(:,744), t3x128(:,:,44), nhel, den(94))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,23), A(:,45), n3(:,745), t3x128(:,:,45), nhel, den(95))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,24), A(:,46), n3(:,746), t3x128(:,:,46), nhel, den(96))
    call Hcont_QA(nsync, wf8(:,20), wf16(:,23), A(:,47), n3(:,747), t3x128(:,:,47), nhel, den(97))
    call Hcont_QA(nsync, wf8(:,20), wf16(:,24), A(:,48), n3(:,748), t3x128(:,:,48), nhel, den(98))
    call Hcont_QA(nsync, wf8(:,10), wf16(:,25), A(:,49), n3(:,749), t3x128(:,:,49), nhel, den(101))
    call Hcont_QA(nsync, wf8(:,10), wf16(:,26), A(:,50), n3(:,750), t3x128(:,:,50), nhel, den(104))
    call Hcont_QA(nsync, wf8(:,12), wf16(:,25), A(:,51), n3(:,751), t3x128(:,:,51), nhel, den(105))
    call Hcont_QA(nsync, wf8(:,12), wf16(:,26), A(:,52), n3(:,752), t3x128(:,:,52), nhel, den(106))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,27), A(:,53), n3(:,753), t3x128(:,:,53), nhel, den(107))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,28), A(:,54), n3(:,754), t3x128(:,:,54), nhel, den(108))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,27), A(:,55), n3(:,755), t3x128(:,:,55), nhel, den(109))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,28), A(:,56), n3(:,756), t3x128(:,:,56), nhel, den(110))
    call Hcont_QA(nsync, wf8(:,10), wf16(:,29), A(:,57), n3(:,757), t3x128(:,:,57), nhel, den(112))
    call Hcont_QA(nsync, wf8(:,10), wf16(:,30), A(:,58), n3(:,758), t3x128(:,:,58), nhel, den(114))
    call Hcont_QA(nsync, wf8(:,12), wf16(:,29), A(:,59), n3(:,759), t3x128(:,:,59), nhel, den(115))
    call Hcont_QA(nsync, wf8(:,12), wf16(:,30), A(:,60), n3(:,760), t3x128(:,:,60), nhel, den(116))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,31), A(:,61), n3(:,761), t3x128(:,:,61), nhel, den(117))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,32), A(:,62), n3(:,762), t3x128(:,:,62), nhel, den(118))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,31), A(:,63), n3(:,763), t3x128(:,:,63), nhel, den(119))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,32), A(:,64), n3(:,764), t3x128(:,:,64), nhel, den(120))
    call Hcont_VV(nsync, wf8(:,39), wf16(:,33), A(:,65), n3(:,765), t3x128(:,:,65), nhel, den(123))
    call Hcont_VV(nsync, wf8(:,41), wf16(:,34), A(:,66), n3(:,766), t3x128(:,:,66), nhel, den(126))
    call Hcont_VV(nsync, wf8(:,39), wf16(:,35), A(:,67), n3(:,767), t3x128(:,:,67), nhel, den(127))
    call Hcont_VV(nsync, wf8(:,41), wf16(:,36), A(:,68), n3(:,768), t3x128(:,:,68), nhel, den(128))
    call Hcont_VV(nsync, wf8(:,39), wf16(:,37), A(:,69), n3(:,769), t3x128(:,:,69), nhel, den(129))
    call Hcont_VV(nsync, wf8(:,41), wf16(:,38), A(:,70), n3(:,770), t3x128(:,:,70), nhel, den(130))
    call Hcont_VV(nsync, wf8(:,39), wf16(:,39), A(:,71), n3(:,771), t3x128(:,:,71), nhel, den(131))
    call Hcont_VV(nsync, wf8(:,41), wf16(:,40), A(:,72), n3(:,772), t3x128(:,:,72), nhel, den(132))
    call Hcont_VV(nsync, wf16(:,33), wf8(:,42), A(:,73), n3(:,773), t3x128(:,:,73), nhel, den(134))
    call Hcont_VV(nsync, wf16(:,34), wf8(:,44), A(:,74), n3(:,774), t3x128(:,:,74), nhel, den(136))
    call Hcont_VV(nsync, wf16(:,35), wf8(:,42), A(:,75), n3(:,775), t3x128(:,:,75), nhel, den(137))
    call Hcont_VV(nsync, wf16(:,36), wf8(:,44), A(:,76), n3(:,776), t3x128(:,:,76), nhel, den(138))
    call Hcont_VV(nsync, wf16(:,37), wf8(:,42), A(:,77), n3(:,777), t3x128(:,:,77), nhel, den(139))
    call Hcont_VV(nsync, wf16(:,38), wf8(:,44), A(:,78), n3(:,778), t3x128(:,:,78), nhel, den(140))
    call Hcont_VV(nsync, wf16(:,39), wf8(:,42), A(:,79), n3(:,779), t3x128(:,:,79), nhel, den(141))
    call Hcont_VV(nsync, wf16(:,40), wf8(:,44), A(:,80), n3(:,780), t3x128(:,:,80), nhel, den(142))
    call Hcont_QA(nsync, wf16(:,41), wf8(:,46), A(:,81), n3(:,781), t3x128(:,:,81), nhel, den(148))
    call Hcont_QA(nsync, wf8(:,46), wf16(:,42), A(:,82), n3(:,782), t3x128(:,:,82), nhel, den(151))
    call Hcont_QA(nsync, wf16(:,41), wf8(:,48), A(:,83), n3(:,783), t3x128(:,:,83), nhel, den(154))
    call Hcont_QA(nsync, wf16(:,42), wf8(:,48), A(:,84), n3(:,784), t3x128(:,:,84), nhel, den(155))
    call Hcont_QA(nsync, wf16(:,43), wf8(:,50), A(:,85), n3(:,785), t3x128(:,:,85), nhel, den(159))
    call Hcont_QA(nsync, wf16(:,43), wf8(:,52), A(:,86), n3(:,786), t3x128(:,:,86), nhel, den(161))
    call Hcont_QA(nsync, wf8(:,50), wf16(:,44), A(:,87), n3(:,787), t3x128(:,:,87), nhel, den(163))
    call Hcont_QA(nsync, wf8(:,52), wf16(:,44), A(:,88), n3(:,788), t3x128(:,:,88), nhel, den(164))
    call Hcont_QA(nsync, wf16(:,45), wf8(:,54), A(:,89), n3(:,789), t3x128(:,:,89), nhel, den(168))
    call Hcont_QA(nsync, wf8(:,54), wf16(:,46), A(:,90), n3(:,790), t3x128(:,:,90), nhel, den(170))
    call Hcont_QA(nsync, wf16(:,45), wf8(:,56), A(:,91), n3(:,791), t3x128(:,:,91), nhel, den(172))
    call Hcont_QA(nsync, wf16(:,46), wf8(:,56), A(:,92), n3(:,792), t3x128(:,:,92), nhel, den(173))
    call Hcont_QA(nsync, wf16(:,47), wf8(:,58), A(:,93), n3(:,793), t3x128(:,:,93), nhel, den(177))
    call Hcont_QA(nsync, wf16(:,47), wf8(:,60), A(:,94), n3(:,794), t3x128(:,:,94), nhel, den(179))
    call Hcont_QA(nsync, wf8(:,58), wf16(:,48), A(:,95), n3(:,795), t3x128(:,:,95), nhel, den(181))
    call Hcont_QA(nsync, wf8(:,60), wf16(:,48), A(:,96), n3(:,796), t3x128(:,:,96), nhel, den(182))
    call Hcont_QA(nsync, wf8(:,50), wf16(:,49), A(:,97), n3(:,797), t3x128(:,:,97), nhel, den(183))
    call Hcont_QA(nsync, wf8(:,52), wf16(:,49), A(:,98), n3(:,798), t3x128(:,:,98), nhel, den(184))
    call Hcont_QA(nsync, wf8(:,50), wf16(:,50), A(:,99), n3(:,799), t3x128(:,:,99), nhel, den(185))
    call Hcont_QA(nsync, wf8(:,52), wf16(:,50), A(:,100), n3(:,800), t3x128(:,:,100), nhel, den(186))
    call Hcont_QA(nsync, wf8(:,46), wf16(:,51), A(:,101), n3(:,801), t3x128(:,:,101), nhel, den(187))
    call Hcont_QA(nsync, wf8(:,46), wf16(:,52), A(:,102), n3(:,802), t3x128(:,:,102), nhel, den(188))
    call Hcont_QA(nsync, wf8(:,48), wf16(:,51), A(:,103), n3(:,803), t3x128(:,:,103), nhel, den(189))
    call Hcont_QA(nsync, wf8(:,48), wf16(:,52), A(:,104), n3(:,804), t3x128(:,:,104), nhel, den(190))
    call Hcont_QA(nsync, wf16(:,53), wf8(:,62), A(:,105), n3(:,805), t3x128(:,:,105), nhel, den(195))
    call Hcont_QA(nsync, wf8(:,62), wf16(:,54), A(:,106), n3(:,806), t3x128(:,:,106), nhel, den(197))
    call Hcont_QA(nsync, wf16(:,53), wf8(:,64), A(:,107), n3(:,807), t3x128(:,:,107), nhel, den(199))
    call Hcont_QA(nsync, wf16(:,54), wf8(:,64), A(:,108), n3(:,808), t3x128(:,:,108), nhel, den(200))
    call Hcont_QA(nsync, wf8(:,22), wf16(:,55), A(:,109), n3(:,809), t3x128(:,:,109), nhel, den(202))
    call Hcont_QA(nsync, wf8(:,24), wf16(:,55), A(:,110), n3(:,810), t3x128(:,:,110), nhel, den(203))
    call Hcont_QA(nsync, wf8(:,22), wf16(:,56), A(:,111), n3(:,811), t3x128(:,:,111), nhel, den(205))
    call Hcont_QA(nsync, wf8(:,24), wf16(:,56), A(:,112), n3(:,812), t3x128(:,:,112), nhel, den(206))
    call Hcont_QA(nsync, wf16(:,17), wf8(:,66), A(:,113), n3(:,813), t3x128(:,:,113), nhel, den(208))
    call Hcont_QA(nsync, wf16(:,18), wf8(:,66), A(:,114), n3(:,814), t3x128(:,:,114), nhel, den(209))
    call Hcont_QA(nsync, wf16(:,17), wf8(:,68), A(:,115), n3(:,815), t3x128(:,:,115), nhel, den(211))
    call Hcont_QA(nsync, wf16(:,18), wf8(:,68), A(:,116), n3(:,816), t3x128(:,:,116), nhel, den(212))
    call Hcont_QA(nsync, wf16(:,57), wf8(:,70), A(:,117), n3(:,817), t3x128(:,:,117), nhel, den(216))
    call Hcont_QA(nsync, wf8(:,70), wf16(:,58), A(:,118), n3(:,818), t3x128(:,:,118), nhel, den(218))
    call Hcont_QA(nsync, wf16(:,57), wf8(:,72), A(:,119), n3(:,819), t3x128(:,:,119), nhel, den(220))
    call Hcont_QA(nsync, wf16(:,58), wf8(:,72), A(:,120), n3(:,820), t3x128(:,:,120), nhel, den(221))
    call Hcont_QA(nsync, wf8(:,22), wf16(:,59), A(:,121), n3(:,821), t3x128(:,:,121), nhel, den(222))
    call Hcont_QA(nsync, wf8(:,24), wf16(:,59), A(:,122), n3(:,822), t3x128(:,:,122), nhel, den(223))
    call Hcont_QA(nsync, wf8(:,22), wf16(:,60), A(:,123), n3(:,823), t3x128(:,:,123), nhel, den(224))
    call Hcont_QA(nsync, wf8(:,24), wf16(:,60), A(:,124), n3(:,824), t3x128(:,:,124), nhel, den(225))
    call Hcont_QA(nsync, wf8(:,62), wf16(:,61), A(:,125), n3(:,825), t3x128(:,:,125), nhel, den(226))
    call Hcont_QA(nsync, wf8(:,64), wf16(:,61), A(:,126), n3(:,826), t3x128(:,:,126), nhel, den(227))
    call Hcont_QA(nsync, wf8(:,62), wf16(:,62), A(:,127), n3(:,827), t3x128(:,:,127), nhel, den(228))
    call Hcont_QA(nsync, wf8(:,64), wf16(:,62), A(:,128), n3(:,828), t3x128(:,:,128), nhel, den(229))
    call Hcont_QA(nsync, wf8(:,58), wf16(:,63), A(:,129), n3(:,829), t3x128(:,:,129), nhel, den(232))
    call Hcont_QA(nsync, wf8(:,58), wf16(:,64), A(:,130), n3(:,830), t3x128(:,:,130), nhel, den(235))
    call Hcont_QA(nsync, wf8(:,60), wf16(:,63), A(:,131), n3(:,831), t3x128(:,:,131), nhel, den(236))
    call Hcont_QA(nsync, wf8(:,60), wf16(:,64), A(:,132), n3(:,832), t3x128(:,:,132), nhel, den(237))
    call Hcont_QA(nsync, wf8(:,50), wf16(:,65), A(:,133), n3(:,833), t3x128(:,:,133), nhel, den(238))
    call Hcont_QA(nsync, wf8(:,50), wf16(:,66), A(:,134), n3(:,834), t3x128(:,:,134), nhel, den(239))
    call Hcont_QA(nsync, wf8(:,52), wf16(:,65), A(:,135), n3(:,835), t3x128(:,:,135), nhel, den(240))
    call Hcont_QA(nsync, wf8(:,52), wf16(:,66), A(:,136), n3(:,836), t3x128(:,:,136), nhel, den(241))
    call Hcont_QA(nsync, wf8(:,50), wf16(:,67), A(:,137), n3(:,837), t3x128(:,:,137), nhel, den(243))
    call Hcont_QA(nsync, wf8(:,52), wf16(:,67), A(:,138), n3(:,838), t3x128(:,:,138), nhel, den(244))
    call Hcont_QA(nsync, wf8(:,50), wf16(:,68), A(:,139), n3(:,839), t3x128(:,:,139), nhel, den(246))
    call Hcont_QA(nsync, wf8(:,52), wf16(:,68), A(:,140), n3(:,840), t3x128(:,:,140), nhel, den(247))
    call Hcont_QA(nsync, wf8(:,58), wf16(:,69), A(:,141), n3(:,841), t3x128(:,:,141), nhel, den(248))
    call Hcont_QA(nsync, wf8(:,60), wf16(:,69), A(:,142), n3(:,842), t3x128(:,:,142), nhel, den(249))
    call Hcont_QA(nsync, wf8(:,58), wf16(:,70), A(:,143), n3(:,843), t3x128(:,:,143), nhel, den(250))
    call Hcont_QA(nsync, wf8(:,60), wf16(:,70), A(:,144), n3(:,844), t3x128(:,:,144), nhel, den(251))
    call Hcont_VV(nsync, wf8(:,39), wf16(:,71), A(:,145), n3(:,845), t3x128(:,:,145), nhel, den(252))
    call Hcont_VV(nsync, wf8(:,41), wf16(:,72), A(:,146), n3(:,846), t3x128(:,:,146), nhel, den(253))
    call Hcont_VV(nsync, wf8(:,39), wf16(:,73), A(:,147), n3(:,847), t3x128(:,:,147), nhel, den(254))
    call Hcont_VV(nsync, wf8(:,41), wf16(:,74), A(:,148), n3(:,848), t3x128(:,:,148), nhel, den(255))
    call Hcont_VV(nsync, wf8(:,39), wf16(:,75), A(:,149), n3(:,849), t3x128(:,:,149), nhel, den(256))
    call Hcont_VV(nsync, wf8(:,39), wf16(:,76), A(:,150), n3(:,850), t3x128(:,:,150), nhel, den(257))
    call Hcont_VV(nsync, wf8(:,41), wf16(:,77), A(:,151), n3(:,851), t3x128(:,:,151), nhel, den(258))
    call Hcont_VV(nsync, wf8(:,41), wf16(:,78), A(:,152), n3(:,852), t3x128(:,:,152), nhel, den(259))
    call Hcont_VV(nsync, wf8(:,42), wf16(:,71), A(:,153), n3(:,853), t3x128(:,:,153), nhel, den(260))
    call Hcont_VV(nsync, wf8(:,44), wf16(:,72), A(:,154), n3(:,854), t3x128(:,:,154), nhel, den(261))
    call Hcont_VV(nsync, wf8(:,42), wf16(:,73), A(:,155), n3(:,855), t3x128(:,:,155), nhel, den(262))
    call Hcont_VV(nsync, wf8(:,44), wf16(:,74), A(:,156), n3(:,856), t3x128(:,:,156), nhel, den(263))
    call Hcont_VV(nsync, wf8(:,42), wf16(:,75), A(:,157), n3(:,857), t3x128(:,:,157), nhel, den(264))
    call Hcont_VV(nsync, wf8(:,42), wf16(:,76), A(:,158), n3(:,858), t3x128(:,:,158), nhel, den(265))
    call Hcont_VV(nsync, wf8(:,44), wf16(:,77), A(:,159), n3(:,859), t3x128(:,:,159), nhel, den(266))
    call Hcont_VV(nsync, wf8(:,44), wf16(:,78), A(:,160), n3(:,860), t3x128(:,:,160), nhel, den(267))
    call Hcont_QA(nsync, wf16(:,13), wf8(:,80), A(:,161), n3(:,861), t3x128(:,:,161), nhel, den(269))
    call Hcont_QA(nsync, wf16(:,14), wf8(:,80), A(:,162), n3(:,862), t3x128(:,:,162), nhel, den(270))
    call Hcont_QA(nsync, wf16(:,13), wf8(:,82), A(:,163), n3(:,863), t3x128(:,:,163), nhel, den(272))
    call Hcont_QA(nsync, wf16(:,14), wf8(:,82), A(:,164), n3(:,864), t3x128(:,:,164), nhel, den(273))
    call Hcont_QA(nsync, wf16(:,79), wf8(:,84), A(:,165), n3(:,865), t3x128(:,:,165), nhel, den(277))
    call Hcont_QA(nsync, wf16(:,79), wf8(:,86), A(:,166), n3(:,866), t3x128(:,:,166), nhel, den(279))
    call Hcont_QA(nsync, wf8(:,84), wf16(:,80), A(:,167), n3(:,867), t3x128(:,:,167), nhel, den(281))
    call Hcont_QA(nsync, wf8(:,86), wf16(:,80), A(:,168), n3(:,868), t3x128(:,:,168), nhel, den(282))
    call Hcont_QA(nsync, wf16(:,81), wf8(:,88), A(:,169), n3(:,869), t3x128(:,:,169), nhel, den(287))
    call Hcont_QA(nsync, wf8(:,88), wf16(:,82), A(:,170), n3(:,870), t3x128(:,:,170), nhel, den(289))
    call Hcont_QA(nsync, wf16(:,81), wf8(:,90), A(:,171), n3(:,871), t3x128(:,:,171), nhel, den(291))
    call Hcont_QA(nsync, wf16(:,82), wf8(:,90), A(:,172), n3(:,872), t3x128(:,:,172), nhel, den(292))
    call Hcont_QA(nsync, wf8(:,30), wf16(:,83), A(:,173), n3(:,873), t3x128(:,:,173), nhel, den(294))
    call Hcont_QA(nsync, wf8(:,32), wf16(:,83), A(:,174), n3(:,874), t3x128(:,:,174), nhel, den(295))
    call Hcont_QA(nsync, wf8(:,30), wf16(:,84), A(:,175), n3(:,875), t3x128(:,:,175), nhel, den(297))
    call Hcont_QA(nsync, wf8(:,32), wf16(:,84), A(:,176), n3(:,876), t3x128(:,:,176), nhel, den(298))
    call Hcont_QA(nsync, wf8(:,84), wf16(:,85), A(:,177), n3(:,877), t3x128(:,:,177), nhel, den(299))
    call Hcont_QA(nsync, wf8(:,86), wf16(:,85), A(:,178), n3(:,878), t3x128(:,:,178), nhel, den(300))
    call Hcont_QA(nsync, wf8(:,84), wf16(:,86), A(:,179), n3(:,879), t3x128(:,:,179), nhel, den(301))
    call Hcont_QA(nsync, wf8(:,86), wf16(:,86), A(:,180), n3(:,880), t3x128(:,:,180), nhel, den(302))
    call Hcont_QA(nsync, wf16(:,23), wf8(:,80), A(:,181), n3(:,881), t3x128(:,:,181), nhel, den(303))
    call Hcont_QA(nsync, wf16(:,24), wf8(:,80), A(:,182), n3(:,882), t3x128(:,:,182), nhel, den(304))
    call Hcont_QA(nsync, wf16(:,23), wf8(:,82), A(:,183), n3(:,883), t3x128(:,:,183), nhel, den(305))
    call Hcont_QA(nsync, wf16(:,24), wf8(:,82), A(:,184), n3(:,884), t3x128(:,:,184), nhel, den(306))
    call Hcont_QA(nsync, wf8(:,54), wf16(:,87), A(:,185), n3(:,885), t3x128(:,:,185), nhel, den(309))
    call Hcont_QA(nsync, wf8(:,54), wf16(:,88), A(:,186), n3(:,886), t3x128(:,:,186), nhel, den(312))
    call Hcont_QA(nsync, wf8(:,56), wf16(:,87), A(:,187), n3(:,887), t3x128(:,:,187), nhel, den(313))
    call Hcont_QA(nsync, wf8(:,56), wf16(:,88), A(:,188), n3(:,888), t3x128(:,:,188), nhel, den(314))
    call Hcont_QA(nsync, wf8(:,46), wf16(:,89), A(:,189), n3(:,889), t3x128(:,:,189), nhel, den(315))
    call Hcont_QA(nsync, wf8(:,46), wf16(:,90), A(:,190), n3(:,890), t3x128(:,:,190), nhel, den(316))
    call Hcont_QA(nsync, wf8(:,48), wf16(:,89), A(:,191), n3(:,891), t3x128(:,:,191), nhel, den(317))
    call Hcont_QA(nsync, wf8(:,48), wf16(:,90), A(:,192), n3(:,892), t3x128(:,:,192), nhel, den(318))
    call Hcont_QA(nsync, wf8(:,54), wf16(:,91), A(:,193), n3(:,893), t3x128(:,:,193), nhel, den(320))
    call Hcont_QA(nsync, wf8(:,54), wf16(:,92), A(:,194), n3(:,894), t3x128(:,:,194), nhel, den(322))
    call Hcont_QA(nsync, wf8(:,56), wf16(:,91), A(:,195), n3(:,895), t3x128(:,:,195), nhel, den(323))
    call Hcont_QA(nsync, wf8(:,56), wf16(:,92), A(:,196), n3(:,896), t3x128(:,:,196), nhel, den(324))
    call Hcont_QA(nsync, wf8(:,46), wf16(:,93), A(:,197), n3(:,897), t3x128(:,:,197), nhel, den(325))
    call Hcont_QA(nsync, wf8(:,46), wf16(:,94), A(:,198), n3(:,898), t3x128(:,:,198), nhel, den(326))
    call Hcont_QA(nsync, wf8(:,48), wf16(:,93), A(:,199), n3(:,899), t3x128(:,:,199), nhel, den(327))
    call Hcont_QA(nsync, wf8(:,48), wf16(:,94), A(:,200), n3(:,900), t3x128(:,:,200), nhel, den(328))
    call Hcont_VV(nsync, wf8(:,39), wf16(:,95), A(:,201), n3(:,901), t3x128(:,:,201), nhel, den(329))
    call Hcont_VV(nsync, wf8(:,41), wf16(:,96), A(:,202), n3(:,902), t3x128(:,:,202), nhel, den(330))
    call Hcont_VV(nsync, wf8(:,39), wf16(:,97), A(:,203), n3(:,903), t3x128(:,:,203), nhel, den(331))
    call Hcont_VV(nsync, wf8(:,41), wf16(:,98), A(:,204), n3(:,904), t3x128(:,:,204), nhel, den(332))
    call Hcont_VV(nsync, wf8(:,39), wf16(:,99), A(:,205), n3(:,905), t3x128(:,:,205), nhel, den(333))
    call Hcont_VV(nsync, wf8(:,41), wf16(:,100), A(:,206), n3(:,906), t3x128(:,:,206), nhel, den(334))
    call Hcont_VV(nsync, wf8(:,39), wf16(:,101), A(:,207), n3(:,907), t3x128(:,:,207), nhel, den(335))
    call Hcont_VV(nsync, wf8(:,41), wf16(:,102), A(:,208), n3(:,908), t3x128(:,:,208), nhel, den(336))
    call Hcont_VV(nsync, wf8(:,42), wf16(:,95), A(:,209), n3(:,909), t3x128(:,:,209), nhel, den(337))
    call Hcont_VV(nsync, wf8(:,44), wf16(:,96), A(:,210), n3(:,910), t3x128(:,:,210), nhel, den(338))
    call Hcont_VV(nsync, wf8(:,42), wf16(:,97), A(:,211), n3(:,911), t3x128(:,:,211), nhel, den(339))
    call Hcont_VV(nsync, wf8(:,44), wf16(:,98), A(:,212), n3(:,912), t3x128(:,:,212), nhel, den(340))
    call Hcont_VV(nsync, wf8(:,42), wf16(:,99), A(:,213), n3(:,913), t3x128(:,:,213), nhel, den(341))
    call Hcont_VV(nsync, wf8(:,44), wf16(:,100), A(:,214), n3(:,914), t3x128(:,:,214), nhel, den(342))
    call Hcont_VV(nsync, wf8(:,42), wf16(:,101), A(:,215), n3(:,915), t3x128(:,:,215), nhel, den(343))
    call Hcont_VV(nsync, wf8(:,44), wf16(:,102), A(:,216), n3(:,916), t3x128(:,:,216), nhel, den(344))
    call Hcont_QA(nsync, wf16(:,53), wf8(:,98), A(:,217), n3(:,917), t3x128(:,:,217), nhel, den(346))
    call Hcont_QA(nsync, wf16(:,54), wf8(:,98), A(:,218), n3(:,918), t3x128(:,:,218), nhel, den(347))
    call Hcont_QA(nsync, wf16(:,53), wf8(:,100), A(:,219), n3(:,919), t3x128(:,:,219), nhel, den(349))
    call Hcont_QA(nsync, wf16(:,54), wf8(:,100), A(:,220), n3(:,920), t3x128(:,:,220), nhel, den(350))
    call Hcont_QA(nsync, wf8(:,84), wf16(:,103), A(:,221), n3(:,921), t3x128(:,:,221), nhel, den(352))
    call Hcont_QA(nsync, wf8(:,86), wf16(:,103), A(:,222), n3(:,922), t3x128(:,:,222), nhel, den(353))
    call Hcont_QA(nsync, wf8(:,84), wf16(:,104), A(:,223), n3(:,923), t3x128(:,:,223), nhel, den(355))
    call Hcont_QA(nsync, wf8(:,86), wf16(:,104), A(:,224), n3(:,924), t3x128(:,:,224), nhel, den(356))
    call Hcont_QA(nsync, wf16(:,81), wf8(:,102), A(:,225), n3(:,925), t3x128(:,:,225), nhel, den(358))
    call Hcont_QA(nsync, wf16(:,82), wf8(:,102), A(:,226), n3(:,926), t3x128(:,:,226), nhel, den(359))
    call Hcont_QA(nsync, wf16(:,81), wf8(:,104), A(:,227), n3(:,927), t3x128(:,:,227), nhel, den(361))
    call Hcont_QA(nsync, wf16(:,82), wf8(:,104), A(:,228), n3(:,928), t3x128(:,:,228), nhel, den(362))
    call Hcont_QA(nsync, wf8(:,70), wf16(:,105), A(:,229), n3(:,929), t3x128(:,:,229), nhel, den(364))
    call Hcont_QA(nsync, wf8(:,70), wf16(:,106), A(:,230), n3(:,930), t3x128(:,:,230), nhel, den(366))
    call Hcont_QA(nsync, wf8(:,72), wf16(:,105), A(:,231), n3(:,931), t3x128(:,:,231), nhel, den(367))
    call Hcont_QA(nsync, wf8(:,72), wf16(:,106), A(:,232), n3(:,932), t3x128(:,:,232), nhel, den(368))
    call Hcont_QA(nsync, wf8(:,84), wf16(:,107), A(:,233), n3(:,933), t3x128(:,:,233), nhel, den(369))
    call Hcont_QA(nsync, wf8(:,86), wf16(:,107), A(:,234), n3(:,934), t3x128(:,:,234), nhel, den(370))
    call Hcont_QA(nsync, wf8(:,84), wf16(:,108), A(:,235), n3(:,935), t3x128(:,:,235), nhel, den(371))
    call Hcont_QA(nsync, wf8(:,86), wf16(:,108), A(:,236), n3(:,936), t3x128(:,:,236), nhel, den(372))
    call Hcont_QA(nsync, wf16(:,61), wf8(:,98), A(:,237), n3(:,937), t3x128(:,:,237), nhel, den(373))
    call Hcont_QA(nsync, wf16(:,61), wf8(:,100), A(:,238), n3(:,938), t3x128(:,:,238), nhel, den(374))
    call Hcont_QA(nsync, wf16(:,62), wf8(:,98), A(:,239), n3(:,939), t3x128(:,:,239), nhel, den(375))
    call Hcont_QA(nsync, wf16(:,62), wf8(:,100), A(:,240), n3(:,940), t3x128(:,:,240), nhel, den(376))
    call Hcont_QA(nsync, wf8(:,14), wf16(:,109), A(:,241), n3(:,941), t3x128(:,:,241), nhel, den(379))
    call Hcont_QA(nsync, wf8(:,14), wf16(:,110), A(:,242), n3(:,942), t3x128(:,:,242), nhel, den(382))
    call Hcont_QA(nsync, wf8(:,16), wf16(:,109), A(:,243), n3(:,943), t3x128(:,:,243), nhel, den(383))
    call Hcont_QA(nsync, wf8(:,16), wf16(:,110), A(:,244), n3(:,944), t3x128(:,:,244), nhel, den(384))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,111), A(:,245), n3(:,945), t3x128(:,:,245), nhel, den(385))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,112), A(:,246), n3(:,946), t3x128(:,:,246), nhel, den(386))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,111), A(:,247), n3(:,947), t3x128(:,:,247), nhel, den(387))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,112), A(:,248), n3(:,948), t3x128(:,:,248), nhel, den(388))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,113), A(:,249), n3(:,949), t3x128(:,:,249), nhel, den(390))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,113), A(:,250), n3(:,950), t3x128(:,:,250), nhel, den(391))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,114), A(:,251), n3(:,951), t3x128(:,:,251), nhel, den(393))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,114), A(:,252), n3(:,952), t3x128(:,:,252), nhel, den(394))
    call Hcont_QA(nsync, wf8(:,14), wf16(:,115), A(:,253), n3(:,953), t3x128(:,:,253), nhel, den(395))
    call Hcont_QA(nsync, wf8(:,16), wf16(:,115), A(:,254), n3(:,954), t3x128(:,:,254), nhel, den(396))
    call Hcont_QA(nsync, wf8(:,14), wf16(:,116), A(:,255), n3(:,955), t3x128(:,:,255), nhel, den(397))
    call Hcont_QA(nsync, wf8(:,16), wf16(:,116), A(:,256), n3(:,956), t3x128(:,:,256), nhel, den(398))
    call Hcont_VV(nsync, wf8(:,39), wf16(:,117), A(:,257), n3(:,957), t3x128(:,:,257), nhel, den(399))
    call Hcont_VV(nsync, wf8(:,41), wf16(:,118), A(:,258), n3(:,958), t3x128(:,:,258), nhel, den(400))
    call Hcont_VV(nsync, wf8(:,39), wf16(:,119), A(:,259), n3(:,959), t3x128(:,:,259), nhel, den(401))
    call Hcont_VV(nsync, wf8(:,41), wf16(:,120), A(:,260), n3(:,960), t3x128(:,:,260), nhel, den(402))
    call Hcont_VV(nsync, wf8(:,39), wf16(:,121), A(:,261), n3(:,961), t3x128(:,:,261), nhel, den(403))
    call Hcont_VV(nsync, wf8(:,39), wf16(:,122), A(:,262), n3(:,962), t3x128(:,:,262), nhel, den(404))
    call Hcont_VV(nsync, wf8(:,41), wf16(:,123), A(:,263), n3(:,963), t3x128(:,:,263), nhel, den(405))
    call Hcont_VV(nsync, wf8(:,41), wf16(:,124), A(:,264), n3(:,964), t3x128(:,:,264), nhel, den(406))
    call Hcont_VV(nsync, wf8(:,42), wf16(:,117), A(:,265), n3(:,965), t3x128(:,:,265), nhel, den(407))
    call Hcont_VV(nsync, wf8(:,44), wf16(:,118), A(:,266), n3(:,966), t3x128(:,:,266), nhel, den(408))
    call Hcont_VV(nsync, wf8(:,42), wf16(:,119), A(:,267), n3(:,967), t3x128(:,:,267), nhel, den(409))
    call Hcont_VV(nsync, wf8(:,44), wf16(:,120), A(:,268), n3(:,968), t3x128(:,:,268), nhel, den(410))
    call Hcont_VV(nsync, wf8(:,42), wf16(:,121), A(:,269), n3(:,969), t3x128(:,:,269), nhel, den(411))
    call Hcont_VV(nsync, wf8(:,42), wf16(:,122), A(:,270), n3(:,970), t3x128(:,:,270), nhel, den(412))
    call Hcont_VV(nsync, wf8(:,44), wf16(:,123), A(:,271), n3(:,971), t3x128(:,:,271), nhel, den(413))
    call Hcont_VV(nsync, wf8(:,44), wf16(:,124), A(:,272), n3(:,972), t3x128(:,:,272), nhel, den(414))
    call Hcont_QA(nsync, wf8(:,22), wf16(:,125), A(:,273), n3(:,973), t3x128(:,:,273), nhel, den(415))
    call Hcont_QA(nsync, wf8(:,24), wf16(:,125), A(:,274), n3(:,974), t3x128(:,:,274), nhel, den(416))
    call Hcont_QA(nsync, wf8(:,22), wf16(:,126), A(:,275), n3(:,975), t3x128(:,:,275), nhel, den(417))
    call Hcont_QA(nsync, wf8(:,24), wf16(:,126), A(:,276), n3(:,976), t3x128(:,:,276), nhel, den(418))
    call Hcont_VV(nsync, wf8(:,105), wf16(:,127), A(:,277), n3(:,977), t3x128(:,:,277), nhel, den(419))
    call Hcont_VV(nsync, wf8(:,107), wf16(:,128), A(:,278), n3(:,978), t3x128(:,:,278), nhel, den(420))
    call Hcont_VV(nsync, wf8(:,105), wf16(:,129), A(:,279), n3(:,979), t3x128(:,:,279), nhel, den(421))
    call Hcont_VV(nsync, wf8(:,107), wf16(:,130), A(:,280), n3(:,980), t3x128(:,:,280), nhel, den(422))
    call Hcont_VV(nsync, wf8(:,73), wf16(:,131), A(:,281), n3(:,981), t3x128(:,:,281), nhel, den(423))
    call Hcont_VV(nsync, wf8(:,73), wf16(:,132), A(:,282), n3(:,982), t3x128(:,:,282), nhel, den(424))
    call Hcont_VV(nsync, wf8(:,75), wf16(:,133), A(:,283), n3(:,983), t3x128(:,:,283), nhel, den(425))
    call Hcont_VV(nsync, wf8(:,75), wf16(:,134), A(:,284), n3(:,984), t3x128(:,:,284), nhel, den(426))
    call Hcont_VV(nsync, wf8(:,73), wf16(:,135), A(:,285), n3(:,985), t3x128(:,:,285), nhel, den(427))
    call Hcont_VV(nsync, wf8(:,75), wf16(:,136), A(:,286), n3(:,986), t3x128(:,:,286), nhel, den(428))
    call Hcont_VV(nsync, wf8(:,73), wf16(:,137), A(:,287), n3(:,987), t3x128(:,:,287), nhel, den(429))
    call Hcont_VV(nsync, wf8(:,75), wf16(:,138), A(:,288), n3(:,988), t3x128(:,:,288), nhel, den(430))
    call Hcont_QA(nsync, wf8(:,22), wf16(:,139), A(:,289), n3(:,989), t3x128(:,:,289), nhel, den(431))
    call Hcont_QA(nsync, wf8(:,24), wf16(:,139), A(:,290), n3(:,990), t3x128(:,:,290), nhel, den(432))
    call Hcont_QA(nsync, wf8(:,22), wf16(:,140), A(:,291), n3(:,991), t3x128(:,:,291), nhel, den(433))
    call Hcont_QA(nsync, wf8(:,24), wf16(:,140), A(:,292), n3(:,992), t3x128(:,:,292), nhel, den(434))
    call Hcont_VV(nsync, wf8(:,33), wf16(:,141), A(:,293), n3(:,993), t3x128(:,:,293), nhel, den(435))
    call Hcont_VV(nsync, wf8(:,33), wf16(:,142), A(:,294), n3(:,994), t3x128(:,:,294), nhel, den(436))
    call Hcont_VV(nsync, wf8(:,35), wf16(:,143), A(:,295), n3(:,995), t3x128(:,:,295), nhel, den(437))
    call Hcont_VV(nsync, wf8(:,35), wf16(:,144), A(:,296), n3(:,996), t3x128(:,:,296), nhel, den(438))
    call Hcont_VV(nsync, wf8(:,33), wf16(:,145), A(:,297), n3(:,997), t3x128(:,:,297), nhel, den(439))
    call Hcont_VV(nsync, wf8(:,35), wf16(:,146), A(:,298), n3(:,998), t3x128(:,:,298), nhel, den(440))
    call Hcont_VV(nsync, wf8(:,33), wf16(:,147), A(:,299), n3(:,999), t3x128(:,:,299), nhel, den(441))
    call Hcont_VV(nsync, wf8(:,35), wf16(:,148), A(:,300), n3(:,1000), t3x128(:,:,300), nhel, den(442))
    call Hcont_VV(nsync, wf8(:,91), wf16(:,149), A(:,301), n3(:,1001), t3x128(:,:,301), nhel, den(443))
    call Hcont_VV(nsync, wf8(:,93), wf16(:,150), A(:,302), n3(:,1002), t3x128(:,:,302), nhel, den(444))
    call Hcont_VV(nsync, wf8(:,91), wf16(:,151), A(:,303), n3(:,1003), t3x128(:,:,303), nhel, den(445))
    call Hcont_VV(nsync, wf8(:,93), wf16(:,152), A(:,304), n3(:,1004), t3x128(:,:,304), nhel, den(446))
    call Hcont_QA(nsync, wf8(:,22), wf16(:,153), A(:,305), n3(:,1005), t3x128(:,:,305), nhel, den(447))
    call Hcont_QA(nsync, wf8(:,24), wf16(:,153), A(:,306), n3(:,1006), t3x128(:,:,306), nhel, den(448))
    call Hcont_QA(nsync, wf8(:,22), wf16(:,154), A(:,307), n3(:,1007), t3x128(:,:,307), nhel, den(449))
    call Hcont_QA(nsync, wf8(:,24), wf16(:,154), A(:,308), n3(:,1008), t3x128(:,:,308), nhel, den(450))
    call Hcont_QA(nsync, wf8(:,22), wf16(:,155), A(:,309), n3(:,1009), t3x128(:,:,309), nhel, den(451))
    call Hcont_QA(nsync, wf8(:,24), wf16(:,155), A(:,310), n3(:,1010), t3x128(:,:,310), nhel, den(452))
    call Hcont_QA(nsync, wf8(:,22), wf16(:,156), A(:,311), n3(:,1011), t3x128(:,:,311), nhel, den(453))
    call Hcont_QA(nsync, wf8(:,24), wf16(:,156), A(:,312), n3(:,1012), t3x128(:,:,312), nhel, den(454))
    call Hcont_QA(nsync, wf8(:,30), wf16(:,157), A(:,313), n3(:,1013), t3x128(:,:,313), nhel, den(455))
    call Hcont_QA(nsync, wf8(:,32), wf16(:,157), A(:,314), n3(:,1014), t3x128(:,:,314), nhel, den(456))
    call Hcont_QA(nsync, wf8(:,30), wf16(:,158), A(:,315), n3(:,1015), t3x128(:,:,315), nhel, den(457))
    call Hcont_QA(nsync, wf8(:,32), wf16(:,158), A(:,316), n3(:,1016), t3x128(:,:,316), nhel, den(458))
    call Hcont_VV(nsync, wf8(:,94), wf16(:,149), A(:,317), n3(:,1017), t3x128(:,:,317), nhel, den(459))
    call Hcont_VV(nsync, wf8(:,96), wf16(:,150), A(:,318), n3(:,1018), t3x128(:,:,318), nhel, den(460))
    call Hcont_VV(nsync, wf8(:,94), wf16(:,151), A(:,319), n3(:,1019), t3x128(:,:,319), nhel, den(461))
    call Hcont_VV(nsync, wf8(:,96), wf16(:,152), A(:,320), n3(:,1020), t3x128(:,:,320), nhel, den(462))
    call Hcont_QA(nsync, wf8(:,84), wf16(:,159), A(:,321), n3(:,1021), t3x128(:,:,321), nhel, den(463))
    call Hcont_QA(nsync, wf8(:,86), wf16(:,159), A(:,322), n3(:,1022), t3x128(:,:,322), nhel, den(464))
    call Hcont_QA(nsync, wf8(:,84), wf16(:,160), A(:,323), n3(:,1023), t3x128(:,:,323), nhel, den(465))
    call Hcont_QA(nsync, wf8(:,86), wf16(:,160), A(:,324), n3(:,1024), t3x128(:,:,324), nhel, den(466))
    call Hcont_QA(nsync, wf8(:,84), wf16(:,161), A(:,325), n3(:,1025), t3x128(:,:,325), nhel, den(467))
    call Hcont_QA(nsync, wf8(:,86), wf16(:,161), A(:,326), n3(:,1026), t3x128(:,:,326), nhel, den(468))
    call Hcont_QA(nsync, wf8(:,84), wf16(:,162), A(:,327), n3(:,1027), t3x128(:,:,327), nhel, den(469))
    call Hcont_QA(nsync, wf8(:,86), wf16(:,162), A(:,328), n3(:,1028), t3x128(:,:,328), nhel, den(470))
    call Hcont_QA(nsync, wf8(:,30), wf16(:,163), A(:,329), n3(:,1029), t3x128(:,:,329), nhel, den(471))
    call Hcont_QA(nsync, wf8(:,32), wf16(:,163), A(:,330), n3(:,1030), t3x128(:,:,330), nhel, den(472))
    call Hcont_QA(nsync, wf8(:,30), wf16(:,164), A(:,331), n3(:,1031), t3x128(:,:,331), nhel, den(473))
    call Hcont_QA(nsync, wf8(:,32), wf16(:,164), A(:,332), n3(:,1032), t3x128(:,:,332), nhel, den(474))
    call Hcont_VV(nsync, wf8(:,36), wf16(:,145), A(:,333), n3(:,1033), t3x128(:,:,333), nhel, den(475))
    call Hcont_VV(nsync, wf8(:,38), wf16(:,146), A(:,334), n3(:,1034), t3x128(:,:,334), nhel, den(476))
    call Hcont_VV(nsync, wf8(:,36), wf16(:,147), A(:,335), n3(:,1035), t3x128(:,:,335), nhel, den(477))
    call Hcont_VV(nsync, wf8(:,38), wf16(:,148), A(:,336), n3(:,1036), t3x128(:,:,336), nhel, den(478))

    call Hcont_QA(nsync, wf8(:,2), wf16(:,165), A(:,337), n3(:,1037), t3x128(:,:,337), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,166), A(:,338), n3(:,1038), t3x128(:,:,338), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,165), A(:,339), n3(:,1039), t3x128(:,:,339), nhel, den(13))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,166), A(:,340), n3(:,1040), t3x128(:,:,340), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,167), A(:,341), n3(:,1041), t3x128(:,:,341), nhel, den(18))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,167), A(:,342), n3(:,1042), t3x128(:,:,342), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,168), A(:,343), n3(:,1043), t3x128(:,:,343), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,168), A(:,344), n3(:,1044), t3x128(:,:,344), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,10), wf16(:,169), A(:,345), n3(:,1045), t3x128(:,:,345), nhel, den(28))
    call Hcont_QA(nsync, wf8(:,10), wf16(:,170), A(:,346), n3(:,1046), t3x128(:,:,346), nhel, den(30))
    call Hcont_QA(nsync, wf8(:,12), wf16(:,169), A(:,347), n3(:,1047), t3x128(:,:,347), nhel, den(32))
    call Hcont_QA(nsync, wf8(:,12), wf16(:,170), A(:,348), n3(:,1048), t3x128(:,:,348), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,14), wf16(:,171), A(:,349), n3(:,1049), t3x128(:,:,349), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,16), wf16(:,171), A(:,350), n3(:,1050), t3x128(:,:,350), nhel, den(39))
    call Hcont_QA(nsync, wf8(:,14), wf16(:,172), A(:,351), n3(:,1051), t3x128(:,:,351), nhel, den(41))
    call Hcont_QA(nsync, wf8(:,16), wf16(:,172), A(:,352), n3(:,1052), t3x128(:,:,352), nhel, den(42))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,173), A(:,353), n3(:,1053), t3x128(:,:,353), nhel, den(43))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,173), A(:,354), n3(:,1054), t3x128(:,:,354), nhel, den(44))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,174), A(:,355), n3(:,1055), t3x128(:,:,355), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,174), A(:,356), n3(:,1056), t3x128(:,:,356), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,175), A(:,357), n3(:,1057), t3x128(:,:,357), nhel, den(47))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,176), A(:,358), n3(:,1058), t3x128(:,:,358), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,175), A(:,359), n3(:,1059), t3x128(:,:,359), nhel, den(49))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,176), A(:,360), n3(:,1060), t3x128(:,:,360), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,111), wf16(:,177), A(:,361), n3(:,1061), t3x128(:,:,361), nhel, den(481))
    call Hcont_QA(nsync, wf16(:,177), wf8(:,112), A(:,362), n3(:,1062), t3x128(:,:,362), nhel, den(482))
    call Hcont_QA(nsync, wf8(:,111), wf16(:,178), A(:,363), n3(:,1063), t3x128(:,:,363), nhel, den(484))
    call Hcont_QA(nsync, wf8(:,112), wf16(:,178), A(:,364), n3(:,1064), t3x128(:,:,364), nhel, den(485))
    call Hcont_QA(nsync, wf8(:,113), wf16(:,179), A(:,365), n3(:,1065), t3x128(:,:,365), nhel, den(488))
    call Hcont_QA(nsync, wf8(:,113), wf16(:,180), A(:,366), n3(:,1066), t3x128(:,:,366), nhel, den(490))
    call Hcont_QA(nsync, wf16(:,179), wf8(:,114), A(:,367), n3(:,1067), t3x128(:,:,367), nhel, den(491))
    call Hcont_QA(nsync, wf16(:,180), wf8(:,114), A(:,368), n3(:,1068), t3x128(:,:,368), nhel, den(492))
    call Hcont_QA(nsync, wf16(:,9), wf8(:,115), A(:,369), n3(:,1069), t3x128(:,:,369), nhel, den(43))
    call Hcont_QA(nsync, wf16(:,9), wf8(:,116), A(:,370), n3(:,1070), t3x128(:,:,370), nhel, den(44))
    call Hcont_QA(nsync, wf16(:,10), wf8(:,115), A(:,371), n3(:,1071), t3x128(:,:,371), nhel, den(45))
    call Hcont_QA(nsync, wf16(:,10), wf8(:,116), A(:,372), n3(:,1072), t3x128(:,:,372), nhel, den(46))
    call Hcont_QA(nsync, wf16(:,11), wf8(:,117), A(:,373), n3(:,1073), t3x128(:,:,373), nhel, den(47))
    call Hcont_QA(nsync, wf16(:,12), wf8(:,117), A(:,374), n3(:,1074), t3x128(:,:,374), nhel, den(48))
    call Hcont_QA(nsync, wf16(:,11), wf8(:,118), A(:,375), n3(:,1075), t3x128(:,:,375), nhel, den(49))
    call Hcont_QA(nsync, wf16(:,12), wf8(:,118), A(:,376), n3(:,1076), t3x128(:,:,376), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,10), wf16(:,181), A(:,377), n3(:,1077), t3x128(:,:,377), nhel, den(28))
    call Hcont_QA(nsync, wf8(:,10), wf16(:,182), A(:,378), n3(:,1078), t3x128(:,:,378), nhel, den(30))
    call Hcont_QA(nsync, wf8(:,12), wf16(:,181), A(:,379), n3(:,1079), t3x128(:,:,379), nhel, den(32))
    call Hcont_QA(nsync, wf8(:,12), wf16(:,182), A(:,380), n3(:,1080), t3x128(:,:,380), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,14), wf16(:,183), A(:,381), n3(:,1081), t3x128(:,:,381), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,16), wf16(:,183), A(:,382), n3(:,1082), t3x128(:,:,382), nhel, den(39))
    call Hcont_QA(nsync, wf8(:,14), wf16(:,184), A(:,383), n3(:,1083), t3x128(:,:,383), nhel, den(41))
    call Hcont_QA(nsync, wf8(:,16), wf16(:,184), A(:,384), n3(:,1084), t3x128(:,:,384), nhel, den(42))
    call Hcont_QA(nsync, wf8(:,119), wf16(:,185), A(:,385), n3(:,1085), t3x128(:,:,385), nhel, den(495))
    call Hcont_QA(nsync, wf16(:,185), wf8(:,120), A(:,386), n3(:,1086), t3x128(:,:,386), nhel, den(496))
    call Hcont_QA(nsync, wf8(:,119), wf16(:,186), A(:,387), n3(:,1087), t3x128(:,:,387), nhel, den(498))
    call Hcont_QA(nsync, wf8(:,120), wf16(:,186), A(:,388), n3(:,1088), t3x128(:,:,388), nhel, den(499))
    call Hcont_QA(nsync, wf8(:,121), wf16(:,187), A(:,389), n3(:,1089), t3x128(:,:,389), nhel, den(502))
    call Hcont_QA(nsync, wf8(:,121), wf16(:,188), A(:,390), n3(:,1090), t3x128(:,:,390), nhel, den(504))
    call Hcont_QA(nsync, wf16(:,187), wf8(:,122), A(:,391), n3(:,1091), t3x128(:,:,391), nhel, den(505))
    call Hcont_QA(nsync, wf16(:,188), wf8(:,122), A(:,392), n3(:,1092), t3x128(:,:,392), nhel, den(506))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,189), A(:,393), n3(:,1093), t3x128(:,:,393), nhel, den(47))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,190), A(:,394), n3(:,1094), t3x128(:,:,394), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,189), A(:,395), n3(:,1095), t3x128(:,:,395), nhel, den(49))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,190), A(:,396), n3(:,1096), t3x128(:,:,396), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,191), A(:,397), n3(:,1097), t3x128(:,:,397), nhel, den(43))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,191), A(:,398), n3(:,1098), t3x128(:,:,398), nhel, den(44))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,192), A(:,399), n3(:,1099), t3x128(:,:,399), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,192), A(:,400), n3(:,1100), t3x128(:,:,400), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,193), A(:,401), n3(:,1101), t3x128(:,:,401), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,194), A(:,402), n3(:,1102), t3x128(:,:,402), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,193), A(:,403), n3(:,1103), t3x128(:,:,403), nhel, den(13))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,194), A(:,404), n3(:,1104), t3x128(:,:,404), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,195), A(:,405), n3(:,1105), t3x128(:,:,405), nhel, den(18))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,195), A(:,406), n3(:,1106), t3x128(:,:,406), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,196), A(:,407), n3(:,1107), t3x128(:,:,407), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,196), A(:,408), n3(:,1108), t3x128(:,:,408), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,10), wf16(:,197), A(:,409), n3(:,1109), t3x128(:,:,409), nhel, den(101))
    call Hcont_QA(nsync, wf8(:,10), wf16(:,198), A(:,410), n3(:,1110), t3x128(:,:,410), nhel, den(104))
    call Hcont_QA(nsync, wf8(:,12), wf16(:,197), A(:,411), n3(:,1111), t3x128(:,:,411), nhel, den(105))
    call Hcont_QA(nsync, wf8(:,12), wf16(:,198), A(:,412), n3(:,1112), t3x128(:,:,412), nhel, den(106))
    call Hcont_QA(nsync, wf16(:,27), wf8(:,117), A(:,413), n3(:,1113), t3x128(:,:,413), nhel, den(107))
    call Hcont_QA(nsync, wf16(:,28), wf8(:,117), A(:,414), n3(:,1114), t3x128(:,:,414), nhel, den(108))
    call Hcont_QA(nsync, wf16(:,27), wf8(:,118), A(:,415), n3(:,1115), t3x128(:,:,415), nhel, den(109))
    call Hcont_QA(nsync, wf16(:,28), wf8(:,118), A(:,416), n3(:,1116), t3x128(:,:,416), nhel, den(110))
    call Hcont_QA(nsync, wf8(:,10), wf16(:,199), A(:,417), n3(:,1117), t3x128(:,:,417), nhel, den(112))
    call Hcont_QA(nsync, wf8(:,10), wf16(:,200), A(:,418), n3(:,1118), t3x128(:,:,418), nhel, den(114))
    call Hcont_QA(nsync, wf8(:,12), wf16(:,199), A(:,419), n3(:,1119), t3x128(:,:,419), nhel, den(115))
    call Hcont_QA(nsync, wf8(:,12), wf16(:,200), A(:,420), n3(:,1120), t3x128(:,:,420), nhel, den(116))
    call Hcont_QA(nsync, wf16(:,31), wf8(:,117), A(:,421), n3(:,1121), t3x128(:,:,421), nhel, den(117))
    call Hcont_QA(nsync, wf16(:,32), wf8(:,117), A(:,422), n3(:,1122), t3x128(:,:,422), nhel, den(118))
    call Hcont_QA(nsync, wf16(:,31), wf8(:,118), A(:,423), n3(:,1123), t3x128(:,:,423), nhel, den(119))
    call Hcont_QA(nsync, wf16(:,32), wf8(:,118), A(:,424), n3(:,1124), t3x128(:,:,424), nhel, den(120))
    call Hcont_VV(nsync, wf16(:,33), wf8(:,127), A(:,425), n3(:,1125), t3x128(:,:,425), nhel, den(123))
    call Hcont_VV(nsync, wf16(:,34), wf8(:,129), A(:,426), n3(:,1126), t3x128(:,:,426), nhel, den(126))
    call Hcont_VV(nsync, wf16(:,35), wf8(:,127), A(:,427), n3(:,1127), t3x128(:,:,427), nhel, den(127))
    call Hcont_VV(nsync, wf16(:,36), wf8(:,129), A(:,428), n3(:,1128), t3x128(:,:,428), nhel, den(128))
    call Hcont_VV(nsync, wf16(:,37), wf8(:,127), A(:,429), n3(:,1129), t3x128(:,:,429), nhel, den(129))
    call Hcont_VV(nsync, wf16(:,38), wf8(:,129), A(:,430), n3(:,1130), t3x128(:,:,430), nhel, den(130))
    call Hcont_VV(nsync, wf16(:,39), wf8(:,127), A(:,431), n3(:,1131), t3x128(:,:,431), nhel, den(131))
    call Hcont_VV(nsync, wf16(:,40), wf8(:,129), A(:,432), n3(:,1132), t3x128(:,:,432), nhel, den(132))
    call Hcont_VV(nsync, wf16(:,33), wf8(:,130), A(:,433), n3(:,1133), t3x128(:,:,433), nhel, den(134))
    call Hcont_VV(nsync, wf16(:,34), wf8(:,132), A(:,434), n3(:,1134), t3x128(:,:,434), nhel, den(136))
    call Hcont_VV(nsync, wf16(:,35), wf8(:,130), A(:,435), n3(:,1135), t3x128(:,:,435), nhel, den(137))
    call Hcont_VV(nsync, wf16(:,36), wf8(:,132), A(:,436), n3(:,1136), t3x128(:,:,436), nhel, den(138))
    call Hcont_VV(nsync, wf16(:,37), wf8(:,130), A(:,437), n3(:,1137), t3x128(:,:,437), nhel, den(139))
    call Hcont_VV(nsync, wf16(:,38), wf8(:,132), A(:,438), n3(:,1138), t3x128(:,:,438), nhel, den(140))
    call Hcont_VV(nsync, wf16(:,39), wf8(:,130), A(:,439), n3(:,1139), t3x128(:,:,439), nhel, den(141))
    call Hcont_VV(nsync, wf16(:,40), wf8(:,132), A(:,440), n3(:,1140), t3x128(:,:,440), nhel, den(142))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,201), A(:,441), n3(:,1141), t3x128(:,:,441), nhel, den(107))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,202), A(:,442), n3(:,1142), t3x128(:,:,442), nhel, den(108))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,201), A(:,443), n3(:,1143), t3x128(:,:,443), nhel, den(109))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,202), A(:,444), n3(:,1144), t3x128(:,:,444), nhel, den(110))
    call Hcont_QA(nsync, wf16(:,25), wf8(:,125), A(:,445), n3(:,1145), t3x128(:,:,445), nhel, den(101))
    call Hcont_QA(nsync, wf16(:,26), wf8(:,125), A(:,446), n3(:,1146), t3x128(:,:,446), nhel, den(104))
    call Hcont_QA(nsync, wf16(:,25), wf8(:,126), A(:,447), n3(:,1147), t3x128(:,:,447), nhel, den(105))
    call Hcont_QA(nsync, wf16(:,26), wf8(:,126), A(:,448), n3(:,1148), t3x128(:,:,448), nhel, den(106))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,203), A(:,449), n3(:,1149), t3x128(:,:,449), nhel, den(117))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,204), A(:,450), n3(:,1150), t3x128(:,:,450), nhel, den(118))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,203), A(:,451), n3(:,1151), t3x128(:,:,451), nhel, den(119))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,204), A(:,452), n3(:,1152), t3x128(:,:,452), nhel, den(120))
    call Hcont_QA(nsync, wf16(:,29), wf8(:,125), A(:,453), n3(:,1153), t3x128(:,:,453), nhel, den(112))
    call Hcont_QA(nsync, wf16(:,30), wf8(:,125), A(:,454), n3(:,1154), t3x128(:,:,454), nhel, den(114))
    call Hcont_QA(nsync, wf16(:,29), wf8(:,126), A(:,455), n3(:,1155), t3x128(:,:,455), nhel, den(115))
    call Hcont_QA(nsync, wf16(:,30), wf8(:,126), A(:,456), n3(:,1156), t3x128(:,:,456), nhel, den(116))
    call Hcont_VV(nsync, wf16(:,33), wf8(:,133), A(:,457), n3(:,1157), t3x128(:,:,457), nhel, den(134))
    call Hcont_VV(nsync, wf16(:,34), wf8(:,135), A(:,458), n3(:,1158), t3x128(:,:,458), nhel, den(136))
    call Hcont_VV(nsync, wf16(:,35), wf8(:,133), A(:,459), n3(:,1159), t3x128(:,:,459), nhel, den(137))
    call Hcont_VV(nsync, wf16(:,36), wf8(:,135), A(:,460), n3(:,1160), t3x128(:,:,460), nhel, den(138))
    call Hcont_VV(nsync, wf16(:,37), wf8(:,133), A(:,461), n3(:,1161), t3x128(:,:,461), nhel, den(139))
    call Hcont_VV(nsync, wf16(:,38), wf8(:,135), A(:,462), n3(:,1162), t3x128(:,:,462), nhel, den(140))
    call Hcont_VV(nsync, wf16(:,39), wf8(:,133), A(:,463), n3(:,1163), t3x128(:,:,463), nhel, den(141))
    call Hcont_VV(nsync, wf16(:,40), wf8(:,135), A(:,464), n3(:,1164), t3x128(:,:,464), nhel, den(142))
    call Hcont_VV(nsync, wf16(:,33), wf8(:,136), A(:,465), n3(:,1165), t3x128(:,:,465), nhel, den(123))
    call Hcont_VV(nsync, wf16(:,34), wf8(:,138), A(:,466), n3(:,1166), t3x128(:,:,466), nhel, den(126))
    call Hcont_VV(nsync, wf16(:,35), wf8(:,136), A(:,467), n3(:,1167), t3x128(:,:,467), nhel, den(127))
    call Hcont_VV(nsync, wf16(:,36), wf8(:,138), A(:,468), n3(:,1168), t3x128(:,:,468), nhel, den(128))
    call Hcont_VV(nsync, wf16(:,37), wf8(:,136), A(:,469), n3(:,1169), t3x128(:,:,469), nhel, den(129))
    call Hcont_VV(nsync, wf16(:,38), wf8(:,138), A(:,470), n3(:,1170), t3x128(:,:,470), nhel, den(130))
    call Hcont_VV(nsync, wf16(:,39), wf8(:,136), A(:,471), n3(:,1171), t3x128(:,:,471), nhel, den(131))
    call Hcont_VV(nsync, wf16(:,40), wf8(:,138), A(:,472), n3(:,1172), t3x128(:,:,472), nhel, den(132))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,205), A(:,473), n3(:,1173), t3x128(:,:,473), nhel, den(56))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,206), A(:,474), n3(:,1174), t3x128(:,:,474), nhel, den(59))
    call Hcont_QA(nsync, wf8(:,20), wf16(:,205), A(:,475), n3(:,1175), t3x128(:,:,475), nhel, den(61))
    call Hcont_QA(nsync, wf8(:,20), wf16(:,206), A(:,476), n3(:,1176), t3x128(:,:,476), nhel, den(62))
    call Hcont_QA(nsync, wf16(:,15), wf8(:,140), A(:,477), n3(:,1177), t3x128(:,:,477), nhel, den(66))
    call Hcont_QA(nsync, wf16(:,15), wf8(:,142), A(:,478), n3(:,1178), t3x128(:,:,478), nhel, den(68))
    call Hcont_QA(nsync, wf16(:,16), wf8(:,140), A(:,479), n3(:,1179), t3x128(:,:,479), nhel, den(70))
    call Hcont_QA(nsync, wf16(:,16), wf8(:,142), A(:,480), n3(:,1180), t3x128(:,:,480), nhel, den(71))
    call Hcont_QA(nsync, wf8(:,26), wf16(:,207), A(:,481), n3(:,1181), t3x128(:,:,481), nhel, den(76))
    call Hcont_QA(nsync, wf8(:,26), wf16(:,208), A(:,482), n3(:,1182), t3x128(:,:,482), nhel, den(78))
    call Hcont_QA(nsync, wf8(:,28), wf16(:,207), A(:,483), n3(:,1183), t3x128(:,:,483), nhel, den(80))
    call Hcont_QA(nsync, wf8(:,28), wf16(:,208), A(:,484), n3(:,1184), t3x128(:,:,484), nhel, den(81))
    call Hcont_QA(nsync, wf16(:,19), wf8(:,144), A(:,485), n3(:,1185), t3x128(:,:,485), nhel, den(85))
    call Hcont_QA(nsync, wf16(:,19), wf8(:,146), A(:,486), n3(:,1186), t3x128(:,:,486), nhel, den(87))
    call Hcont_QA(nsync, wf16(:,20), wf8(:,144), A(:,487), n3(:,1187), t3x128(:,:,487), nhel, den(89))
    call Hcont_QA(nsync, wf16(:,20), wf8(:,146), A(:,488), n3(:,1188), t3x128(:,:,488), nhel, den(90))
    call Hcont_QA(nsync, wf16(:,21), wf8(:,140), A(:,489), n3(:,1189), t3x128(:,:,489), nhel, den(91))
    call Hcont_QA(nsync, wf16(:,21), wf8(:,142), A(:,490), n3(:,1190), t3x128(:,:,490), nhel, den(92))
    call Hcont_QA(nsync, wf16(:,22), wf8(:,140), A(:,491), n3(:,1191), t3x128(:,:,491), nhel, den(93))
    call Hcont_QA(nsync, wf16(:,22), wf8(:,142), A(:,492), n3(:,1192), t3x128(:,:,492), nhel, den(94))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,209), A(:,493), n3(:,1193), t3x128(:,:,493), nhel, den(95))
    call Hcont_QA(nsync, wf8(:,18), wf16(:,210), A(:,494), n3(:,1194), t3x128(:,:,494), nhel, den(96))
    call Hcont_QA(nsync, wf8(:,20), wf16(:,209), A(:,495), n3(:,1195), t3x128(:,:,495), nhel, den(97))
    call Hcont_QA(nsync, wf8(:,20), wf16(:,210), A(:,496), n3(:,1196), t3x128(:,:,496), nhel, den(98))
    call Hcont_QA(nsync, wf8(:,46), wf16(:,211), A(:,497), n3(:,1197), t3x128(:,:,497), nhel, den(148))
    call Hcont_QA(nsync, wf8(:,46), wf16(:,212), A(:,498), n3(:,1198), t3x128(:,:,498), nhel, den(151))
    call Hcont_QA(nsync, wf8(:,48), wf16(:,211), A(:,499), n3(:,1199), t3x128(:,:,499), nhel, den(154))
    call Hcont_QA(nsync, wf8(:,48), wf16(:,212), A(:,500), n3(:,1200), t3x128(:,:,500), nhel, den(155))
    call Hcont_QA(nsync, wf8(:,50), wf16(:,213), A(:,501), n3(:,1201), t3x128(:,:,501), nhel, den(159))
    call Hcont_QA(nsync, wf8(:,52), wf16(:,213), A(:,502), n3(:,1202), t3x128(:,:,502), nhel, den(161))
    call Hcont_QA(nsync, wf8(:,50), wf16(:,214), A(:,503), n3(:,1203), t3x128(:,:,503), nhel, den(163))
    call Hcont_QA(nsync, wf8(:,52), wf16(:,214), A(:,504), n3(:,1204), t3x128(:,:,504), nhel, den(164))
    call Hcont_QA(nsync, wf8(:,54), wf16(:,215), A(:,505), n3(:,1205), t3x128(:,:,505), nhel, den(168))
    call Hcont_QA(nsync, wf8(:,54), wf16(:,216), A(:,506), n3(:,1206), t3x128(:,:,506), nhel, den(170))
    call Hcont_QA(nsync, wf8(:,56), wf16(:,215), A(:,507), n3(:,1207), t3x128(:,:,507), nhel, den(172))
    call Hcont_QA(nsync, wf8(:,56), wf16(:,216), A(:,508), n3(:,1208), t3x128(:,:,508), nhel, den(173))
    call Hcont_QA(nsync, wf8(:,58), wf16(:,217), A(:,509), n3(:,1209), t3x128(:,:,509), nhel, den(177))
    call Hcont_QA(nsync, wf8(:,60), wf16(:,217), A(:,510), n3(:,1210), t3x128(:,:,510), nhel, den(179))
    call Hcont_QA(nsync, wf8(:,58), wf16(:,218), A(:,511), n3(:,1211), t3x128(:,:,511), nhel, den(181))
    call Hcont_QA(nsync, wf8(:,60), wf16(:,218), A(:,512), n3(:,1212), t3x128(:,:,512), nhel, den(182))
    call Hcont_QA(nsync, wf8(:,50), wf16(:,219), A(:,513), n3(:,1213), t3x128(:,:,513), nhel, den(183))
    call Hcont_QA(nsync, wf8(:,52), wf16(:,219), A(:,514), n3(:,1214), t3x128(:,:,514), nhel, den(184))
    call Hcont_QA(nsync, wf8(:,50), wf16(:,220), A(:,515), n3(:,1215), t3x128(:,:,515), nhel, den(185))
    call Hcont_QA(nsync, wf8(:,52), wf16(:,220), A(:,516), n3(:,1216), t3x128(:,:,516), nhel, den(186))
    call Hcont_QA(nsync, wf8(:,46), wf16(:,221), A(:,517), n3(:,1217), t3x128(:,:,517), nhel, den(187))
    call Hcont_QA(nsync, wf8(:,46), wf16(:,222), A(:,518), n3(:,1218), t3x128(:,:,518), nhel, den(188))
    call Hcont_QA(nsync, wf8(:,48), wf16(:,221), A(:,519), n3(:,1219), t3x128(:,:,519), nhel, den(189))
    call Hcont_QA(nsync, wf8(:,48), wf16(:,222), A(:,520), n3(:,1220), t3x128(:,:,520), nhel, den(190))
    call Hcont_QA(nsync, wf8(:,147), wf16(:,223), A(:,521), n3(:,1221), t3x128(:,:,521), nhel, den(509))
    call Hcont_QA(nsync, wf16(:,223), wf8(:,148), A(:,522), n3(:,1222), t3x128(:,:,522), nhel, den(510))
    call Hcont_QA(nsync, wf8(:,147), wf16(:,224), A(:,523), n3(:,1223), t3x128(:,:,523), nhel, den(512))
    call Hcont_QA(nsync, wf8(:,148), wf16(:,224), A(:,524), n3(:,1224), t3x128(:,:,524), nhel, den(513))
    call Hcont_QA(nsync, wf8(:,149), wf16(:,225), A(:,525), n3(:,1225), t3x128(:,:,525), nhel, den(516))
    call Hcont_QA(nsync, wf8(:,149), wf16(:,226), A(:,526), n3(:,1226), t3x128(:,:,526), nhel, den(518))
    call Hcont_QA(nsync, wf16(:,225), wf8(:,150), A(:,527), n3(:,1227), t3x128(:,:,527), nhel, den(519))
    call Hcont_QA(nsync, wf16(:,226), wf8(:,150), A(:,528), n3(:,1228), t3x128(:,:,528), nhel, den(520))
    call Hcont_QA(nsync, wf16(:,49), wf8(:,151), A(:,529), n3(:,1229), t3x128(:,:,529), nhel, den(183))
    call Hcont_QA(nsync, wf16(:,49), wf8(:,152), A(:,530), n3(:,1230), t3x128(:,:,530), nhel, den(184))
    call Hcont_QA(nsync, wf16(:,50), wf8(:,151), A(:,531), n3(:,1231), t3x128(:,:,531), nhel, den(185))
    call Hcont_QA(nsync, wf16(:,50), wf8(:,152), A(:,532), n3(:,1232), t3x128(:,:,532), nhel, den(186))
    call Hcont_QA(nsync, wf16(:,51), wf8(:,153), A(:,533), n3(:,1233), t3x128(:,:,533), nhel, den(187))
    call Hcont_QA(nsync, wf16(:,52), wf8(:,153), A(:,534), n3(:,1234), t3x128(:,:,534), nhel, den(188))
    call Hcont_QA(nsync, wf16(:,51), wf8(:,154), A(:,535), n3(:,1235), t3x128(:,:,535), nhel, den(189))
    call Hcont_QA(nsync, wf16(:,52), wf8(:,154), A(:,536), n3(:,1236), t3x128(:,:,536), nhel, den(190))
    call Hcont_QA(nsync, wf8(:,54), wf16(:,227), A(:,537), n3(:,1237), t3x128(:,:,537), nhel, den(168))
    call Hcont_QA(nsync, wf8(:,54), wf16(:,228), A(:,538), n3(:,1238), t3x128(:,:,538), nhel, den(170))
    call Hcont_QA(nsync, wf8(:,56), wf16(:,227), A(:,539), n3(:,1239), t3x128(:,:,539), nhel, den(172))
    call Hcont_QA(nsync, wf8(:,56), wf16(:,228), A(:,540), n3(:,1240), t3x128(:,:,540), nhel, den(173))
    call Hcont_QA(nsync, wf8(:,58), wf16(:,229), A(:,541), n3(:,1241), t3x128(:,:,541), nhel, den(177))
    call Hcont_QA(nsync, wf8(:,60), wf16(:,229), A(:,542), n3(:,1242), t3x128(:,:,542), nhel, den(179))
    call Hcont_QA(nsync, wf8(:,58), wf16(:,230), A(:,543), n3(:,1243), t3x128(:,:,543), nhel, den(181))
    call Hcont_QA(nsync, wf8(:,60), wf16(:,230), A(:,544), n3(:,1244), t3x128(:,:,544), nhel, den(182))
    call Hcont_QA(nsync, wf8(:,155), wf16(:,231), A(:,545), n3(:,1245), t3x128(:,:,545), nhel, den(523))
    call Hcont_QA(nsync, wf16(:,231), wf8(:,156), A(:,546), n3(:,1246), t3x128(:,:,546), nhel, den(524))
    call Hcont_QA(nsync, wf8(:,155), wf16(:,232), A(:,547), n3(:,1247), t3x128(:,:,547), nhel, den(526))
    call Hcont_QA(nsync, wf8(:,156), wf16(:,232), A(:,548), n3(:,1248), t3x128(:,:,548), nhel, den(527))
    call Hcont_QA(nsync, wf8(:,157), wf16(:,233), A(:,549), n3(:,1249), t3x128(:,:,549), nhel, den(530))
    call Hcont_QA(nsync, wf8(:,157), wf16(:,234), A(:,550), n3(:,1250), t3x128(:,:,550), nhel, den(532))
    call Hcont_QA(nsync, wf16(:,233), wf8(:,158), A(:,551), n3(:,1251), t3x128(:,:,551), nhel, den(533))
    call Hcont_QA(nsync, wf16(:,234), wf8(:,158), A(:,552), n3(:,1252), t3x128(:,:,552), nhel, den(534))
    call Hcont_QA(nsync, wf8(:,46), wf16(:,235), A(:,553), n3(:,1253), t3x128(:,:,553), nhel, den(187))
    call Hcont_QA(nsync, wf8(:,46), wf16(:,236), A(:,554), n3(:,1254), t3x128(:,:,554), nhel, den(188))
    call Hcont_QA(nsync, wf8(:,48), wf16(:,235), A(:,555), n3(:,1255), t3x128(:,:,555), nhel, den(189))
    call Hcont_QA(nsync, wf8(:,48), wf16(:,236), A(:,556), n3(:,1256), t3x128(:,:,556), nhel, den(190))
    call Hcont_QA(nsync, wf8(:,50), wf16(:,237), A(:,557), n3(:,1257), t3x128(:,:,557), nhel, den(183))
    call Hcont_QA(nsync, wf8(:,52), wf16(:,237), A(:,558), n3(:,1258), t3x128(:,:,558), nhel, den(184))
    call Hcont_QA(nsync, wf8(:,50), wf16(:,238), A(:,559), n3(:,1259), t3x128(:,:,559), nhel, den(185))
    call Hcont_QA(nsync, wf8(:,52), wf16(:,238), A(:,560), n3(:,1260), t3x128(:,:,560), nhel, den(186))
    call Hcont_QA(nsync, wf8(:,46), wf16(:,239), A(:,561), n3(:,1261), t3x128(:,:,561), nhel, den(148))
    call Hcont_QA(nsync, wf8(:,46), wf16(:,240), A(:,562), n3(:,1262), t3x128(:,:,562), nhel, den(151))
    call Hcont_QA(nsync, wf8(:,48), wf16(:,239), A(:,563), n3(:,1263), t3x128(:,:,563), nhel, den(154))
    call Hcont_QA(nsync, wf8(:,48), wf16(:,240), A(:,564), n3(:,1264), t3x128(:,:,564), nhel, den(155))
    call Hcont_QA(nsync, wf8(:,50), wf16(:,241), A(:,565), n3(:,1265), t3x128(:,:,565), nhel, den(159))
    call Hcont_QA(nsync, wf8(:,52), wf16(:,241), A(:,566), n3(:,1266), t3x128(:,:,566), nhel, den(161))
    call Hcont_QA(nsync, wf8(:,50), wf16(:,242), A(:,567), n3(:,1267), t3x128(:,:,567), nhel, den(163))
    call Hcont_QA(nsync, wf8(:,52), wf16(:,242), A(:,568), n3(:,1268), t3x128(:,:,568), nhel, den(164))
    call Hcont_QA(nsync, wf8(:,58), wf16(:,243), A(:,569), n3(:,1269), t3x128(:,:,569), nhel, den(232))
    call Hcont_QA(nsync, wf8(:,58), wf16(:,244), A(:,570), n3(:,1270), t3x128(:,:,570), nhel, den(235))
    call Hcont_QA(nsync, wf8(:,60), wf16(:,243), A(:,571), n3(:,1271), t3x128(:,:,571), nhel, den(236))
    call Hcont_QA(nsync, wf8(:,60), wf16(:,244), A(:,572), n3(:,1272), t3x128(:,:,572), nhel, den(237))
    call Hcont_QA(nsync, wf16(:,65), wf8(:,151), A(:,573), n3(:,1273), t3x128(:,:,573), nhel, den(238))
    call Hcont_QA(nsync, wf16(:,66), wf8(:,151), A(:,574), n3(:,1274), t3x128(:,:,574), nhel, den(239))
    call Hcont_QA(nsync, wf16(:,65), wf8(:,152), A(:,575), n3(:,1275), t3x128(:,:,575), nhel, den(240))
    call Hcont_QA(nsync, wf16(:,66), wf8(:,152), A(:,576), n3(:,1276), t3x128(:,:,576), nhel, den(241))
    call Hcont_QA(nsync, wf16(:,67), wf8(:,151), A(:,577), n3(:,1277), t3x128(:,:,577), nhel, den(243))
    call Hcont_QA(nsync, wf16(:,67), wf8(:,152), A(:,578), n3(:,1278), t3x128(:,:,578), nhel, den(244))
    call Hcont_QA(nsync, wf16(:,68), wf8(:,151), A(:,579), n3(:,1279), t3x128(:,:,579), nhel, den(246))
    call Hcont_QA(nsync, wf16(:,68), wf8(:,152), A(:,580), n3(:,1280), t3x128(:,:,580), nhel, den(247))
    call Hcont_QA(nsync, wf8(:,58), wf16(:,245), A(:,581), n3(:,1281), t3x128(:,:,581), nhel, den(248))
    call Hcont_QA(nsync, wf8(:,60), wf16(:,245), A(:,582), n3(:,1282), t3x128(:,:,582), nhel, den(249))
    call Hcont_QA(nsync, wf8(:,58), wf16(:,246), A(:,583), n3(:,1283), t3x128(:,:,583), nhel, den(250))
    call Hcont_QA(nsync, wf8(:,60), wf16(:,246), A(:,584), n3(:,1284), t3x128(:,:,584), nhel, den(251))
    call Hcont_VV(nsync, wf16(:,71), wf8(:,127), A(:,585), n3(:,1285), t3x128(:,:,585), nhel, den(252))
    call Hcont_VV(nsync, wf16(:,72), wf8(:,129), A(:,586), n3(:,1286), t3x128(:,:,586), nhel, den(253))
    call Hcont_VV(nsync, wf16(:,73), wf8(:,127), A(:,587), n3(:,1287), t3x128(:,:,587), nhel, den(254))
    call Hcont_VV(nsync, wf16(:,74), wf8(:,129), A(:,588), n3(:,1288), t3x128(:,:,588), nhel, den(255))
    call Hcont_VV(nsync, wf16(:,75), wf8(:,127), A(:,589), n3(:,1289), t3x128(:,:,589), nhel, den(256))
    call Hcont_VV(nsync, wf16(:,76), wf8(:,127), A(:,590), n3(:,1290), t3x128(:,:,590), nhel, den(257))
    call Hcont_VV(nsync, wf16(:,77), wf8(:,129), A(:,591), n3(:,1291), t3x128(:,:,591), nhel, den(258))
    call Hcont_VV(nsync, wf16(:,78), wf8(:,129), A(:,592), n3(:,1292), t3x128(:,:,592), nhel, den(259))
    call Hcont_VV(nsync, wf16(:,71), wf8(:,130), A(:,593), n3(:,1293), t3x128(:,:,593), nhel, den(260))
    call Hcont_VV(nsync, wf16(:,72), wf8(:,132), A(:,594), n3(:,1294), t3x128(:,:,594), nhel, den(261))
    call Hcont_VV(nsync, wf16(:,73), wf8(:,130), A(:,595), n3(:,1295), t3x128(:,:,595), nhel, den(262))
    call Hcont_VV(nsync, wf16(:,74), wf8(:,132), A(:,596), n3(:,1296), t3x128(:,:,596), nhel, den(263))
    call Hcont_VV(nsync, wf16(:,75), wf8(:,130), A(:,597), n3(:,1297), t3x128(:,:,597), nhel, den(264))
    call Hcont_VV(nsync, wf16(:,76), wf8(:,130), A(:,598), n3(:,1298), t3x128(:,:,598), nhel, den(265))
    call Hcont_VV(nsync, wf16(:,77), wf8(:,132), A(:,599), n3(:,1299), t3x128(:,:,599), nhel, den(266))
    call Hcont_VV(nsync, wf16(:,78), wf8(:,132), A(:,600), n3(:,1300), t3x128(:,:,600), nhel, den(267))
    call Hcont_QA(nsync, wf8(:,50), wf16(:,247), A(:,601), n3(:,1301), t3x128(:,:,601), nhel, den(238))
    call Hcont_QA(nsync, wf8(:,50), wf16(:,248), A(:,602), n3(:,1302), t3x128(:,:,602), nhel, den(239))
    call Hcont_QA(nsync, wf8(:,52), wf16(:,247), A(:,603), n3(:,1303), t3x128(:,:,603), nhel, den(240))
    call Hcont_QA(nsync, wf8(:,52), wf16(:,248), A(:,604), n3(:,1304), t3x128(:,:,604), nhel, den(241))
    call Hcont_QA(nsync, wf16(:,63), wf8(:,159), A(:,605), n3(:,1305), t3x128(:,:,605), nhel, den(232))
    call Hcont_QA(nsync, wf16(:,64), wf8(:,159), A(:,606), n3(:,1306), t3x128(:,:,606), nhel, den(235))
    call Hcont_QA(nsync, wf16(:,63), wf8(:,160), A(:,607), n3(:,1307), t3x128(:,:,607), nhel, den(236))
    call Hcont_QA(nsync, wf16(:,64), wf8(:,160), A(:,608), n3(:,1308), t3x128(:,:,608), nhel, den(237))
    call Hcont_QA(nsync, wf16(:,69), wf8(:,159), A(:,609), n3(:,1309), t3x128(:,:,609), nhel, den(248))
    call Hcont_QA(nsync, wf16(:,69), wf8(:,160), A(:,610), n3(:,1310), t3x128(:,:,610), nhel, den(249))
    call Hcont_QA(nsync, wf16(:,70), wf8(:,159), A(:,611), n3(:,1311), t3x128(:,:,611), nhel, den(250))
    call Hcont_QA(nsync, wf16(:,70), wf8(:,160), A(:,612), n3(:,1312), t3x128(:,:,612), nhel, den(251))
    call Hcont_QA(nsync, wf8(:,50), wf16(:,249), A(:,613), n3(:,1313), t3x128(:,:,613), nhel, den(243))
    call Hcont_QA(nsync, wf8(:,52), wf16(:,249), A(:,614), n3(:,1314), t3x128(:,:,614), nhel, den(244))
    call Hcont_QA(nsync, wf8(:,50), wf16(:,250), A(:,615), n3(:,1315), t3x128(:,:,615), nhel, den(246))
    call Hcont_QA(nsync, wf8(:,52), wf16(:,250), A(:,616), n3(:,1316), t3x128(:,:,616), nhel, den(247))
    call Hcont_VV(nsync, wf16(:,71), wf8(:,133), A(:,617), n3(:,1317), t3x128(:,:,617), nhel, den(260))
    call Hcont_VV(nsync, wf16(:,72), wf8(:,135), A(:,618), n3(:,1318), t3x128(:,:,618), nhel, den(261))
    call Hcont_VV(nsync, wf16(:,73), wf8(:,133), A(:,619), n3(:,1319), t3x128(:,:,619), nhel, den(262))
    call Hcont_VV(nsync, wf16(:,74), wf8(:,135), A(:,620), n3(:,1320), t3x128(:,:,620), nhel, den(263))
    call Hcont_VV(nsync, wf16(:,75), wf8(:,133), A(:,621), n3(:,1321), t3x128(:,:,621), nhel, den(264))
    call Hcont_VV(nsync, wf16(:,76), wf8(:,133), A(:,622), n3(:,1322), t3x128(:,:,622), nhel, den(265))
    call Hcont_VV(nsync, wf16(:,77), wf8(:,135), A(:,623), n3(:,1323), t3x128(:,:,623), nhel, den(266))
    call Hcont_VV(nsync, wf16(:,78), wf8(:,135), A(:,624), n3(:,1324), t3x128(:,:,624), nhel, den(267))
    call Hcont_VV(nsync, wf16(:,71), wf8(:,136), A(:,625), n3(:,1325), t3x128(:,:,625), nhel, den(252))
    call Hcont_VV(nsync, wf16(:,72), wf8(:,138), A(:,626), n3(:,1326), t3x128(:,:,626), nhel, den(253))
    call Hcont_VV(nsync, wf16(:,73), wf8(:,136), A(:,627), n3(:,1327), t3x128(:,:,627), nhel, den(254))
    call Hcont_VV(nsync, wf16(:,74), wf8(:,138), A(:,628), n3(:,1328), t3x128(:,:,628), nhel, den(255))
    call Hcont_VV(nsync, wf16(:,75), wf8(:,136), A(:,629), n3(:,1329), t3x128(:,:,629), nhel, den(256))
    call Hcont_VV(nsync, wf16(:,76), wf8(:,136), A(:,630), n3(:,1330), t3x128(:,:,630), nhel, den(257))
    call Hcont_VV(nsync, wf16(:,77), wf8(:,138), A(:,631), n3(:,1331), t3x128(:,:,631), nhel, den(258))
    call Hcont_VV(nsync, wf16(:,78), wf8(:,138), A(:,632), n3(:,1332), t3x128(:,:,632), nhel, den(259))
    call Hcont_QA(nsync, wf8(:,62), wf16(:,251), A(:,633), n3(:,1333), t3x128(:,:,633), nhel, den(195))
    call Hcont_QA(nsync, wf8(:,62), wf16(:,252), A(:,634), n3(:,1334), t3x128(:,:,634), nhel, den(197))
    call Hcont_QA(nsync, wf8(:,64), wf16(:,251), A(:,635), n3(:,1335), t3x128(:,:,635), nhel, den(199))
    call Hcont_QA(nsync, wf8(:,64), wf16(:,252), A(:,636), n3(:,1336), t3x128(:,:,636), nhel, den(200))
    call Hcont_QA(nsync, wf16(:,55), wf8(:,140), A(:,637), n3(:,1337), t3x128(:,:,637), nhel, den(202))
    call Hcont_QA(nsync, wf16(:,55), wf8(:,142), A(:,638), n3(:,1338), t3x128(:,:,638), nhel, den(203))
    call Hcont_QA(nsync, wf16(:,56), wf8(:,140), A(:,639), n3(:,1339), t3x128(:,:,639), nhel, den(205))
    call Hcont_QA(nsync, wf16(:,56), wf8(:,142), A(:,640), n3(:,1340), t3x128(:,:,640), nhel, den(206))
    call Hcont_QA(nsync, wf8(:,66), wf16(:,207), A(:,641), n3(:,1341), t3x128(:,:,641), nhel, den(208))
    call Hcont_QA(nsync, wf8(:,66), wf16(:,208), A(:,642), n3(:,1342), t3x128(:,:,642), nhel, den(209))
    call Hcont_QA(nsync, wf8(:,68), wf16(:,207), A(:,643), n3(:,1343), t3x128(:,:,643), nhel, den(211))
    call Hcont_QA(nsync, wf8(:,68), wf16(:,208), A(:,644), n3(:,1344), t3x128(:,:,644), nhel, den(212))
    call Hcont_QA(nsync, wf16(:,57), wf8(:,164), A(:,645), n3(:,1345), t3x128(:,:,645), nhel, den(216))
    call Hcont_QA(nsync, wf16(:,58), wf8(:,164), A(:,646), n3(:,1346), t3x128(:,:,646), nhel, den(218))
    call Hcont_QA(nsync, wf16(:,57), wf8(:,166), A(:,647), n3(:,1347), t3x128(:,:,647), nhel, den(220))
    call Hcont_QA(nsync, wf16(:,58), wf8(:,166), A(:,648), n3(:,1348), t3x128(:,:,648), nhel, den(221))
    call Hcont_QA(nsync, wf16(:,59), wf8(:,140), A(:,649), n3(:,1349), t3x128(:,:,649), nhel, den(222))
    call Hcont_QA(nsync, wf16(:,59), wf8(:,142), A(:,650), n3(:,1350), t3x128(:,:,650), nhel, den(223))
    call Hcont_QA(nsync, wf16(:,60), wf8(:,140), A(:,651), n3(:,1351), t3x128(:,:,651), nhel, den(224))
    call Hcont_QA(nsync, wf16(:,60), wf8(:,142), A(:,652), n3(:,1352), t3x128(:,:,652), nhel, den(225))
    call Hcont_QA(nsync, wf8(:,62), wf16(:,253), A(:,653), n3(:,1353), t3x128(:,:,653), nhel, den(226))
    call Hcont_QA(nsync, wf8(:,64), wf16(:,253), A(:,654), n3(:,1354), t3x128(:,:,654), nhel, den(227))
    call Hcont_QA(nsync, wf8(:,62), wf16(:,254), A(:,655), n3(:,1355), t3x128(:,:,655), nhel, den(228))
    call Hcont_QA(nsync, wf8(:,64), wf16(:,254), A(:,656), n3(:,1356), t3x128(:,:,656), nhel, den(229))
    call Hcont_QA(nsync, wf8(:,54), wf16(:,255), A(:,657), n3(:,1357), t3x128(:,:,657), nhel, den(309))
    call Hcont_QA(nsync, wf8(:,54), wf16(:,256), A(:,658), n3(:,1358), t3x128(:,:,658), nhel, den(312))
    call Hcont_QA(nsync, wf8(:,56), wf16(:,255), A(:,659), n3(:,1359), t3x128(:,:,659), nhel, den(313))
    call Hcont_QA(nsync, wf8(:,56), wf16(:,256), A(:,660), n3(:,1360), t3x128(:,:,660), nhel, den(314))
    call Hcont_QA(nsync, wf16(:,89), wf8(:,153), A(:,661), n3(:,1361), t3x128(:,:,661), nhel, den(315))
    call Hcont_QA(nsync, wf16(:,90), wf8(:,153), A(:,662), n3(:,1362), t3x128(:,:,662), nhel, den(316))
    call Hcont_QA(nsync, wf16(:,89), wf8(:,154), A(:,663), n3(:,1363), t3x128(:,:,663), nhel, den(317))
    call Hcont_QA(nsync, wf16(:,90), wf8(:,154), A(:,664), n3(:,1364), t3x128(:,:,664), nhel, den(318))
    call Hcont_QA(nsync, wf8(:,54), wf16(:,257), A(:,665), n3(:,1365), t3x128(:,:,665), nhel, den(320))
    call Hcont_QA(nsync, wf8(:,54), wf16(:,258), A(:,666), n3(:,1366), t3x128(:,:,666), nhel, den(322))
    call Hcont_QA(nsync, wf8(:,56), wf16(:,257), A(:,667), n3(:,1367), t3x128(:,:,667), nhel, den(323))
    call Hcont_QA(nsync, wf8(:,56), wf16(:,258), A(:,668), n3(:,1368), t3x128(:,:,668), nhel, den(324))
    call Hcont_QA(nsync, wf16(:,93), wf8(:,153), A(:,669), n3(:,1369), t3x128(:,:,669), nhel, den(325))
    call Hcont_QA(nsync, wf16(:,94), wf8(:,153), A(:,670), n3(:,1370), t3x128(:,:,670), nhel, den(326))
    call Hcont_QA(nsync, wf16(:,93), wf8(:,154), A(:,671), n3(:,1371), t3x128(:,:,671), nhel, den(327))
    call Hcont_QA(nsync, wf16(:,94), wf8(:,154), A(:,672), n3(:,1372), t3x128(:,:,672), nhel, den(328))
    call Hcont_VV(nsync, wf16(:,95), wf8(:,127), A(:,673), n3(:,1373), t3x128(:,:,673), nhel, den(329))
    call Hcont_VV(nsync, wf16(:,96), wf8(:,129), A(:,674), n3(:,1374), t3x128(:,:,674), nhel, den(330))
    call Hcont_VV(nsync, wf16(:,97), wf8(:,127), A(:,675), n3(:,1375), t3x128(:,:,675), nhel, den(331))
    call Hcont_VV(nsync, wf16(:,98), wf8(:,129), A(:,676), n3(:,1376), t3x128(:,:,676), nhel, den(332))
    call Hcont_VV(nsync, wf16(:,99), wf8(:,127), A(:,677), n3(:,1377), t3x128(:,:,677), nhel, den(333))
    call Hcont_VV(nsync, wf16(:,100), wf8(:,129), A(:,678), n3(:,1378), t3x128(:,:,678), nhel, den(334))
    call Hcont_VV(nsync, wf16(:,101), wf8(:,127), A(:,679), n3(:,1379), t3x128(:,:,679), nhel, den(335))
    call Hcont_VV(nsync, wf16(:,102), wf8(:,129), A(:,680), n3(:,1380), t3x128(:,:,680), nhel, den(336))
    call Hcont_VV(nsync, wf16(:,95), wf8(:,130), A(:,681), n3(:,1381), t3x128(:,:,681), nhel, den(337))
    call Hcont_VV(nsync, wf16(:,96), wf8(:,132), A(:,682), n3(:,1382), t3x128(:,:,682), nhel, den(338))
    call Hcont_VV(nsync, wf16(:,97), wf8(:,130), A(:,683), n3(:,1383), t3x128(:,:,683), nhel, den(339))
    call Hcont_VV(nsync, wf16(:,98), wf8(:,132), A(:,684), n3(:,1384), t3x128(:,:,684), nhel, den(340))
    call Hcont_VV(nsync, wf16(:,99), wf8(:,130), A(:,685), n3(:,1385), t3x128(:,:,685), nhel, den(341))
    call Hcont_VV(nsync, wf16(:,100), wf8(:,132), A(:,686), n3(:,1386), t3x128(:,:,686), nhel, den(342))
    call Hcont_VV(nsync, wf16(:,101), wf8(:,130), A(:,687), n3(:,1387), t3x128(:,:,687), nhel, den(343))
    call Hcont_VV(nsync, wf16(:,102), wf8(:,132), A(:,688), n3(:,1388), t3x128(:,:,688), nhel, den(344))
    call Hcont_QA(nsync, wf8(:,46), wf16(:,259), A(:,689), n3(:,1389), t3x128(:,:,689), nhel, den(315))
    call Hcont_QA(nsync, wf8(:,46), wf16(:,260), A(:,690), n3(:,1390), t3x128(:,:,690), nhel, den(316))
    call Hcont_QA(nsync, wf8(:,48), wf16(:,259), A(:,691), n3(:,1391), t3x128(:,:,691), nhel, den(317))
    call Hcont_QA(nsync, wf8(:,48), wf16(:,260), A(:,692), n3(:,1392), t3x128(:,:,692), nhel, den(318))
    call Hcont_QA(nsync, wf16(:,87), wf8(:,161), A(:,693), n3(:,1393), t3x128(:,:,693), nhel, den(309))
    call Hcont_QA(nsync, wf16(:,88), wf8(:,161), A(:,694), n3(:,1394), t3x128(:,:,694), nhel, den(312))
    call Hcont_QA(nsync, wf16(:,87), wf8(:,162), A(:,695), n3(:,1395), t3x128(:,:,695), nhel, den(313))
    call Hcont_QA(nsync, wf16(:,88), wf8(:,162), A(:,696), n3(:,1396), t3x128(:,:,696), nhel, den(314))
    call Hcont_QA(nsync, wf8(:,46), wf16(:,261), A(:,697), n3(:,1397), t3x128(:,:,697), nhel, den(325))
    call Hcont_QA(nsync, wf8(:,46), wf16(:,262), A(:,698), n3(:,1398), t3x128(:,:,698), nhel, den(326))
    call Hcont_QA(nsync, wf8(:,48), wf16(:,261), A(:,699), n3(:,1399), t3x128(:,:,699), nhel, den(327))
    call Hcont_QA(nsync, wf8(:,48), wf16(:,262), A(:,700), n3(:,1400), t3x128(:,:,700), nhel, den(328))
    call Hcont_QA(nsync, wf16(:,91), wf8(:,161), A(:,701), n3(:,1401), t3x128(:,:,701), nhel, den(320))
    call Hcont_QA(nsync, wf16(:,92), wf8(:,161), A(:,702), n3(:,1402), t3x128(:,:,702), nhel, den(322))
    call Hcont_QA(nsync, wf16(:,91), wf8(:,162), A(:,703), n3(:,1403), t3x128(:,:,703), nhel, den(323))
    call Hcont_QA(nsync, wf16(:,92), wf8(:,162), A(:,704), n3(:,1404), t3x128(:,:,704), nhel, den(324))
    call Hcont_VV(nsync, wf16(:,95), wf8(:,133), A(:,705), n3(:,1405), t3x128(:,:,705), nhel, den(337))
    call Hcont_VV(nsync, wf16(:,96), wf8(:,135), A(:,706), n3(:,1406), t3x128(:,:,706), nhel, den(338))
    call Hcont_VV(nsync, wf16(:,97), wf8(:,133), A(:,707), n3(:,1407), t3x128(:,:,707), nhel, den(339))
    call Hcont_VV(nsync, wf16(:,98), wf8(:,135), A(:,708), n3(:,1408), t3x128(:,:,708), nhel, den(340))
    call Hcont_VV(nsync, wf16(:,99), wf8(:,133), A(:,709), n3(:,1409), t3x128(:,:,709), nhel, den(341))
    call Hcont_VV(nsync, wf16(:,100), wf8(:,135), A(:,710), n3(:,1410), t3x128(:,:,710), nhel, den(342))
    call Hcont_VV(nsync, wf16(:,101), wf8(:,133), A(:,711), n3(:,1411), t3x128(:,:,711), nhel, den(343))
    call Hcont_VV(nsync, wf16(:,102), wf8(:,135), A(:,712), n3(:,1412), t3x128(:,:,712), nhel, den(344))
    call Hcont_VV(nsync, wf16(:,95), wf8(:,136), A(:,713), n3(:,1413), t3x128(:,:,713), nhel, den(329))
    call Hcont_VV(nsync, wf16(:,96), wf8(:,138), A(:,714), n3(:,1414), t3x128(:,:,714), nhel, den(330))
    call Hcont_VV(nsync, wf16(:,97), wf8(:,136), A(:,715), n3(:,1415), t3x128(:,:,715), nhel, den(331))
    call Hcont_VV(nsync, wf16(:,98), wf8(:,138), A(:,716), n3(:,1416), t3x128(:,:,716), nhel, den(332))
    call Hcont_VV(nsync, wf16(:,99), wf8(:,136), A(:,717), n3(:,1417), t3x128(:,:,717), nhel, den(333))
    call Hcont_VV(nsync, wf16(:,100), wf8(:,138), A(:,718), n3(:,1418), t3x128(:,:,718), nhel, den(334))
    call Hcont_VV(nsync, wf16(:,101), wf8(:,136), A(:,719), n3(:,1419), t3x128(:,:,719), nhel, den(335))
    call Hcont_VV(nsync, wf16(:,102), wf8(:,138), A(:,720), n3(:,1420), t3x128(:,:,720), nhel, den(336))
    call Hcont_QA(nsync, wf8(:,80), wf16(:,205), A(:,721), n3(:,1421), t3x128(:,:,721), nhel, den(269))
    call Hcont_QA(nsync, wf8(:,80), wf16(:,206), A(:,722), n3(:,1422), t3x128(:,:,722), nhel, den(270))
    call Hcont_QA(nsync, wf8(:,82), wf16(:,205), A(:,723), n3(:,1423), t3x128(:,:,723), nhel, den(272))
    call Hcont_QA(nsync, wf8(:,82), wf16(:,206), A(:,724), n3(:,1424), t3x128(:,:,724), nhel, den(273))
    call Hcont_QA(nsync, wf16(:,79), wf8(:,168), A(:,725), n3(:,1425), t3x128(:,:,725), nhel, den(277))
    call Hcont_QA(nsync, wf16(:,79), wf8(:,170), A(:,726), n3(:,1426), t3x128(:,:,726), nhel, den(279))
    call Hcont_QA(nsync, wf16(:,80), wf8(:,168), A(:,727), n3(:,1427), t3x128(:,:,727), nhel, den(281))
    call Hcont_QA(nsync, wf16(:,80), wf8(:,170), A(:,728), n3(:,1428), t3x128(:,:,728), nhel, den(282))
    call Hcont_QA(nsync, wf8(:,88), wf16(:,263), A(:,729), n3(:,1429), t3x128(:,:,729), nhel, den(287))
    call Hcont_QA(nsync, wf8(:,88), wf16(:,264), A(:,730), n3(:,1430), t3x128(:,:,730), nhel, den(289))
    call Hcont_QA(nsync, wf8(:,90), wf16(:,263), A(:,731), n3(:,1431), t3x128(:,:,731), nhel, den(291))
    call Hcont_QA(nsync, wf8(:,90), wf16(:,264), A(:,732), n3(:,1432), t3x128(:,:,732), nhel, den(292))
    call Hcont_QA(nsync, wf16(:,83), wf8(:,144), A(:,733), n3(:,1433), t3x128(:,:,733), nhel, den(294))
    call Hcont_QA(nsync, wf16(:,83), wf8(:,146), A(:,734), n3(:,1434), t3x128(:,:,734), nhel, den(295))
    call Hcont_QA(nsync, wf16(:,84), wf8(:,144), A(:,735), n3(:,1435), t3x128(:,:,735), nhel, den(297))
    call Hcont_QA(nsync, wf16(:,84), wf8(:,146), A(:,736), n3(:,1436), t3x128(:,:,736), nhel, den(298))
    call Hcont_QA(nsync, wf16(:,85), wf8(:,168), A(:,737), n3(:,1437), t3x128(:,:,737), nhel, den(299))
    call Hcont_QA(nsync, wf16(:,85), wf8(:,170), A(:,738), n3(:,1438), t3x128(:,:,738), nhel, den(300))
    call Hcont_QA(nsync, wf16(:,86), wf8(:,168), A(:,739), n3(:,1439), t3x128(:,:,739), nhel, den(301))
    call Hcont_QA(nsync, wf16(:,86), wf8(:,170), A(:,740), n3(:,1440), t3x128(:,:,740), nhel, den(302))
    call Hcont_QA(nsync, wf8(:,80), wf16(:,209), A(:,741), n3(:,1441), t3x128(:,:,741), nhel, den(303))
    call Hcont_QA(nsync, wf8(:,80), wf16(:,210), A(:,742), n3(:,1442), t3x128(:,:,742), nhel, den(304))
    call Hcont_QA(nsync, wf8(:,82), wf16(:,209), A(:,743), n3(:,1443), t3x128(:,:,743), nhel, den(305))
    call Hcont_QA(nsync, wf8(:,82), wf16(:,210), A(:,744), n3(:,1444), t3x128(:,:,744), nhel, den(306))
    call Hcont_QA(nsync, wf8(:,14), wf16(:,265), A(:,745), n3(:,1445), t3x128(:,:,745), nhel, den(379))
    call Hcont_QA(nsync, wf8(:,14), wf16(:,266), A(:,746), n3(:,1446), t3x128(:,:,746), nhel, den(382))
    call Hcont_QA(nsync, wf8(:,16), wf16(:,265), A(:,747), n3(:,1447), t3x128(:,:,747), nhel, den(383))
    call Hcont_QA(nsync, wf8(:,16), wf16(:,266), A(:,748), n3(:,1448), t3x128(:,:,748), nhel, den(384))
    call Hcont_QA(nsync, wf16(:,111), wf8(:,115), A(:,749), n3(:,1449), t3x128(:,:,749), nhel, den(385))
    call Hcont_QA(nsync, wf16(:,112), wf8(:,115), A(:,750), n3(:,1450), t3x128(:,:,750), nhel, den(386))
    call Hcont_QA(nsync, wf16(:,111), wf8(:,116), A(:,751), n3(:,1451), t3x128(:,:,751), nhel, den(387))
    call Hcont_QA(nsync, wf16(:,112), wf8(:,116), A(:,752), n3(:,1452), t3x128(:,:,752), nhel, den(388))
    call Hcont_QA(nsync, wf16(:,113), wf8(:,115), A(:,753), n3(:,1453), t3x128(:,:,753), nhel, den(390))
    call Hcont_QA(nsync, wf16(:,113), wf8(:,116), A(:,754), n3(:,1454), t3x128(:,:,754), nhel, den(391))
    call Hcont_QA(nsync, wf16(:,114), wf8(:,115), A(:,755), n3(:,1455), t3x128(:,:,755), nhel, den(393))
    call Hcont_QA(nsync, wf16(:,114), wf8(:,116), A(:,756), n3(:,1456), t3x128(:,:,756), nhel, den(394))
    call Hcont_QA(nsync, wf8(:,14), wf16(:,267), A(:,757), n3(:,1457), t3x128(:,:,757), nhel, den(395))
    call Hcont_QA(nsync, wf8(:,16), wf16(:,267), A(:,758), n3(:,1458), t3x128(:,:,758), nhel, den(396))
    call Hcont_QA(nsync, wf8(:,14), wf16(:,268), A(:,759), n3(:,1459), t3x128(:,:,759), nhel, den(397))
    call Hcont_QA(nsync, wf8(:,16), wf16(:,268), A(:,760), n3(:,1460), t3x128(:,:,760), nhel, den(398))
    call Hcont_VV(nsync, wf16(:,117), wf8(:,127), A(:,761), n3(:,1461), t3x128(:,:,761), nhel, den(399))
    call Hcont_VV(nsync, wf16(:,118), wf8(:,129), A(:,762), n3(:,1462), t3x128(:,:,762), nhel, den(400))
    call Hcont_VV(nsync, wf16(:,119), wf8(:,127), A(:,763), n3(:,1463), t3x128(:,:,763), nhel, den(401))
    call Hcont_VV(nsync, wf16(:,120), wf8(:,129), A(:,764), n3(:,1464), t3x128(:,:,764), nhel, den(402))
    call Hcont_VV(nsync, wf16(:,121), wf8(:,127), A(:,765), n3(:,1465), t3x128(:,:,765), nhel, den(403))
    call Hcont_VV(nsync, wf16(:,122), wf8(:,127), A(:,766), n3(:,1466), t3x128(:,:,766), nhel, den(404))
    call Hcont_VV(nsync, wf16(:,123), wf8(:,129), A(:,767), n3(:,1467), t3x128(:,:,767), nhel, den(405))
    call Hcont_VV(nsync, wf16(:,124), wf8(:,129), A(:,768), n3(:,1468), t3x128(:,:,768), nhel, den(406))
    call Hcont_VV(nsync, wf16(:,117), wf8(:,130), A(:,769), n3(:,1469), t3x128(:,:,769), nhel, den(407))
    call Hcont_VV(nsync, wf16(:,118), wf8(:,132), A(:,770), n3(:,1470), t3x128(:,:,770), nhel, den(408))
    call Hcont_VV(nsync, wf16(:,119), wf8(:,130), A(:,771), n3(:,1471), t3x128(:,:,771), nhel, den(409))
    call Hcont_VV(nsync, wf16(:,120), wf8(:,132), A(:,772), n3(:,1472), t3x128(:,:,772), nhel, den(410))
    call Hcont_VV(nsync, wf16(:,121), wf8(:,130), A(:,773), n3(:,1473), t3x128(:,:,773), nhel, den(411))
    call Hcont_VV(nsync, wf16(:,122), wf8(:,130), A(:,774), n3(:,1474), t3x128(:,:,774), nhel, den(412))
    call Hcont_VV(nsync, wf16(:,123), wf8(:,132), A(:,775), n3(:,1475), t3x128(:,:,775), nhel, den(413))
    call Hcont_VV(nsync, wf16(:,124), wf8(:,132), A(:,776), n3(:,1476), t3x128(:,:,776), nhel, den(414))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,269), A(:,777), n3(:,1477), t3x128(:,:,777), nhel, den(385))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,270), A(:,778), n3(:,1478), t3x128(:,:,778), nhel, den(386))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,269), A(:,779), n3(:,1479), t3x128(:,:,779), nhel, den(387))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,270), A(:,780), n3(:,1480), t3x128(:,:,780), nhel, den(388))
    call Hcont_QA(nsync, wf16(:,109), wf8(:,123), A(:,781), n3(:,1481), t3x128(:,:,781), nhel, den(379))
    call Hcont_QA(nsync, wf16(:,110), wf8(:,123), A(:,782), n3(:,1482), t3x128(:,:,782), nhel, den(382))
    call Hcont_QA(nsync, wf16(:,109), wf8(:,124), A(:,783), n3(:,1483), t3x128(:,:,783), nhel, den(383))
    call Hcont_QA(nsync, wf16(:,110), wf8(:,124), A(:,784), n3(:,1484), t3x128(:,:,784), nhel, den(384))
    call Hcont_QA(nsync, wf16(:,115), wf8(:,123), A(:,785), n3(:,1485), t3x128(:,:,785), nhel, den(395))
    call Hcont_QA(nsync, wf16(:,115), wf8(:,124), A(:,786), n3(:,1486), t3x128(:,:,786), nhel, den(396))
    call Hcont_QA(nsync, wf16(:,116), wf8(:,123), A(:,787), n3(:,1487), t3x128(:,:,787), nhel, den(397))
    call Hcont_QA(nsync, wf16(:,116), wf8(:,124), A(:,788), n3(:,1488), t3x128(:,:,788), nhel, den(398))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,271), A(:,789), n3(:,1489), t3x128(:,:,789), nhel, den(390))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,271), A(:,790), n3(:,1490), t3x128(:,:,790), nhel, den(391))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,272), A(:,791), n3(:,1491), t3x128(:,:,791), nhel, den(393))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,272), A(:,792), n3(:,1492), t3x128(:,:,792), nhel, den(394))
    call Hcont_VV(nsync, wf16(:,117), wf8(:,133), A(:,793), n3(:,1493), t3x128(:,:,793), nhel, den(407))
    call Hcont_VV(nsync, wf16(:,118), wf8(:,135), A(:,794), n3(:,1494), t3x128(:,:,794), nhel, den(408))
    call Hcont_VV(nsync, wf16(:,119), wf8(:,133), A(:,795), n3(:,1495), t3x128(:,:,795), nhel, den(409))
    call Hcont_VV(nsync, wf16(:,120), wf8(:,135), A(:,796), n3(:,1496), t3x128(:,:,796), nhel, den(410))
    call Hcont_VV(nsync, wf16(:,121), wf8(:,133), A(:,797), n3(:,1497), t3x128(:,:,797), nhel, den(411))
    call Hcont_VV(nsync, wf16(:,122), wf8(:,133), A(:,798), n3(:,1498), t3x128(:,:,798), nhel, den(412))
    call Hcont_VV(nsync, wf16(:,123), wf8(:,135), A(:,799), n3(:,1499), t3x128(:,:,799), nhel, den(413))
    call Hcont_VV(nsync, wf16(:,124), wf8(:,135), A(:,800), n3(:,1500), t3x128(:,:,800), nhel, den(414))
    call Hcont_VV(nsync, wf16(:,117), wf8(:,136), A(:,801), n3(:,1501), t3x128(:,:,801), nhel, den(399))
    call Hcont_VV(nsync, wf16(:,118), wf8(:,138), A(:,802), n3(:,1502), t3x128(:,:,802), nhel, den(400))
    call Hcont_VV(nsync, wf16(:,119), wf8(:,136), A(:,803), n3(:,1503), t3x128(:,:,803), nhel, den(401))
    call Hcont_VV(nsync, wf16(:,120), wf8(:,138), A(:,804), n3(:,1504), t3x128(:,:,804), nhel, den(402))
    call Hcont_VV(nsync, wf16(:,121), wf8(:,136), A(:,805), n3(:,1505), t3x128(:,:,805), nhel, den(403))
    call Hcont_VV(nsync, wf16(:,122), wf8(:,136), A(:,806), n3(:,1506), t3x128(:,:,806), nhel, den(404))
    call Hcont_VV(nsync, wf16(:,123), wf8(:,138), A(:,807), n3(:,1507), t3x128(:,:,807), nhel, den(405))
    call Hcont_VV(nsync, wf16(:,124), wf8(:,138), A(:,808), n3(:,1508), t3x128(:,:,808), nhel, den(406))
    call Hcont_QA(nsync, wf8(:,98), wf16(:,251), A(:,809), n3(:,1509), t3x128(:,:,809), nhel, den(346))
    call Hcont_QA(nsync, wf8(:,98), wf16(:,252), A(:,810), n3(:,1510), t3x128(:,:,810), nhel, den(347))
    call Hcont_QA(nsync, wf8(:,100), wf16(:,251), A(:,811), n3(:,1511), t3x128(:,:,811), nhel, den(349))
    call Hcont_QA(nsync, wf8(:,100), wf16(:,252), A(:,812), n3(:,1512), t3x128(:,:,812), nhel, den(350))
    call Hcont_QA(nsync, wf16(:,103), wf8(:,168), A(:,813), n3(:,1513), t3x128(:,:,813), nhel, den(352))
    call Hcont_QA(nsync, wf16(:,103), wf8(:,170), A(:,814), n3(:,1514), t3x128(:,:,814), nhel, den(353))
    call Hcont_QA(nsync, wf16(:,104), wf8(:,168), A(:,815), n3(:,1515), t3x128(:,:,815), nhel, den(355))
    call Hcont_QA(nsync, wf16(:,104), wf8(:,170), A(:,816), n3(:,1516), t3x128(:,:,816), nhel, den(356))
    call Hcont_QA(nsync, wf8(:,102), wf16(:,263), A(:,817), n3(:,1517), t3x128(:,:,817), nhel, den(358))
    call Hcont_QA(nsync, wf8(:,102), wf16(:,264), A(:,818), n3(:,1518), t3x128(:,:,818), nhel, den(359))
    call Hcont_QA(nsync, wf8(:,104), wf16(:,263), A(:,819), n3(:,1519), t3x128(:,:,819), nhel, den(361))
    call Hcont_QA(nsync, wf8(:,104), wf16(:,264), A(:,820), n3(:,1520), t3x128(:,:,820), nhel, den(362))
    call Hcont_QA(nsync, wf16(:,105), wf8(:,164), A(:,821), n3(:,1521), t3x128(:,:,821), nhel, den(364))
    call Hcont_QA(nsync, wf16(:,106), wf8(:,164), A(:,822), n3(:,1522), t3x128(:,:,822), nhel, den(366))
    call Hcont_QA(nsync, wf16(:,105), wf8(:,166), A(:,823), n3(:,1523), t3x128(:,:,823), nhel, den(367))
    call Hcont_QA(nsync, wf16(:,106), wf8(:,166), A(:,824), n3(:,1524), t3x128(:,:,824), nhel, den(368))
    call Hcont_QA(nsync, wf16(:,107), wf8(:,168), A(:,825), n3(:,1525), t3x128(:,:,825), nhel, den(369))
    call Hcont_QA(nsync, wf16(:,107), wf8(:,170), A(:,826), n3(:,1526), t3x128(:,:,826), nhel, den(370))
    call Hcont_QA(nsync, wf16(:,108), wf8(:,168), A(:,827), n3(:,1527), t3x128(:,:,827), nhel, den(371))
    call Hcont_QA(nsync, wf16(:,108), wf8(:,170), A(:,828), n3(:,1528), t3x128(:,:,828), nhel, den(372))
    call Hcont_QA(nsync, wf8(:,98), wf16(:,253), A(:,829), n3(:,1529), t3x128(:,:,829), nhel, den(373))
    call Hcont_QA(nsync, wf8(:,100), wf16(:,253), A(:,830), n3(:,1530), t3x128(:,:,830), nhel, den(374))
    call Hcont_QA(nsync, wf8(:,98), wf16(:,254), A(:,831), n3(:,1531), t3x128(:,:,831), nhel, den(375))
    call Hcont_QA(nsync, wf8(:,100), wf16(:,254), A(:,832), n3(:,1532), t3x128(:,:,832), nhel, den(376))
    call Hcont_QA(nsync, wf16(:,125), wf8(:,140), A(:,833), n3(:,1533), t3x128(:,:,833), nhel, den(415))
    call Hcont_QA(nsync, wf16(:,125), wf8(:,142), A(:,834), n3(:,1534), t3x128(:,:,834), nhel, den(416))
    call Hcont_QA(nsync, wf16(:,126), wf8(:,140), A(:,835), n3(:,1535), t3x128(:,:,835), nhel, den(417))
    call Hcont_QA(nsync, wf16(:,126), wf8(:,142), A(:,836), n3(:,1536), t3x128(:,:,836), nhel, den(418))
    call Hcont_VV(nsync, wf8(:,105), wf16(:,273), A(:,837), n3(:,1537), t3x128(:,:,837), nhel, den(419))
    call Hcont_VV(nsync, wf8(:,107), wf16(:,274), A(:,838), n3(:,1538), t3x128(:,:,838), nhel, den(420))
    call Hcont_VV(nsync, wf8(:,105), wf16(:,275), A(:,839), n3(:,1539), t3x128(:,:,839), nhel, den(421))
    call Hcont_VV(nsync, wf8(:,107), wf16(:,276), A(:,840), n3(:,1540), t3x128(:,:,840), nhel, den(422))
    call Hcont_VV(nsync, wf8(:,73), wf16(:,277), A(:,841), n3(:,1541), t3x128(:,:,841), nhel, den(423))
    call Hcont_VV(nsync, wf8(:,73), wf16(:,278), A(:,842), n3(:,1542), t3x128(:,:,842), nhel, den(424))
    call Hcont_VV(nsync, wf8(:,75), wf16(:,279), A(:,843), n3(:,1543), t3x128(:,:,843), nhel, den(425))
    call Hcont_VV(nsync, wf8(:,75), wf16(:,280), A(:,844), n3(:,1544), t3x128(:,:,844), nhel, den(426))
    call Hcont_VV(nsync, wf8(:,73), wf16(:,281), A(:,845), n3(:,1545), t3x128(:,:,845), nhel, den(427))
    call Hcont_VV(nsync, wf8(:,75), wf16(:,282), A(:,846), n3(:,1546), t3x128(:,:,846), nhel, den(428))
    call Hcont_VV(nsync, wf8(:,73), wf16(:,283), A(:,847), n3(:,1547), t3x128(:,:,847), nhel, den(429))
    call Hcont_VV(nsync, wf8(:,75), wf16(:,284), A(:,848), n3(:,1548), t3x128(:,:,848), nhel, den(430))
    call Hcont_QA(nsync, wf16(:,139), wf8(:,140), A(:,849), n3(:,1549), t3x128(:,:,849), nhel, den(431))
    call Hcont_QA(nsync, wf16(:,139), wf8(:,142), A(:,850), n3(:,1550), t3x128(:,:,850), nhel, den(432))
    call Hcont_QA(nsync, wf16(:,140), wf8(:,140), A(:,851), n3(:,1551), t3x128(:,:,851), nhel, den(433))
    call Hcont_QA(nsync, wf16(:,140), wf8(:,142), A(:,852), n3(:,1552), t3x128(:,:,852), nhel, den(434))
    call Hcont_VV(nsync, wf8(:,33), wf16(:,285), A(:,853), n3(:,1553), t3x128(:,:,853), nhel, den(435))
    call Hcont_VV(nsync, wf8(:,33), wf16(:,286), A(:,854), n3(:,1554), t3x128(:,:,854), nhel, den(436))
    call Hcont_VV(nsync, wf8(:,35), wf16(:,287), A(:,855), n3(:,1555), t3x128(:,:,855), nhel, den(437))
    call Hcont_VV(nsync, wf8(:,35), wf16(:,288), A(:,856), n3(:,1556), t3x128(:,:,856), nhel, den(438))
    call Hcont_VV(nsync, wf8(:,33), wf16(:,289), A(:,857), n3(:,1557), t3x128(:,:,857), nhel, den(439))
    call Hcont_VV(nsync, wf8(:,35), wf16(:,290), A(:,858), n3(:,1558), t3x128(:,:,858), nhel, den(440))
    call Hcont_VV(nsync, wf8(:,33), wf16(:,291), A(:,859), n3(:,1559), t3x128(:,:,859), nhel, den(441))
    call Hcont_VV(nsync, wf8(:,35), wf16(:,292), A(:,860), n3(:,1560), t3x128(:,:,860), nhel, den(442))
    call Hcont_VV(nsync, wf8(:,91), wf16(:,293), A(:,861), n3(:,1561), t3x128(:,:,861), nhel, den(443))
    call Hcont_VV(nsync, wf8(:,93), wf16(:,294), A(:,862), n3(:,1562), t3x128(:,:,862), nhel, den(444))
    call Hcont_VV(nsync, wf8(:,91), wf16(:,295), A(:,863), n3(:,1563), t3x128(:,:,863), nhel, den(445))
    call Hcont_VV(nsync, wf8(:,93), wf16(:,296), A(:,864), n3(:,1564), t3x128(:,:,864), nhel, den(446))
    call Hcont_QA(nsync, wf16(:,153), wf8(:,140), A(:,865), n3(:,1565), t3x128(:,:,865), nhel, den(447))
    call Hcont_QA(nsync, wf16(:,153), wf8(:,142), A(:,866), n3(:,1566), t3x128(:,:,866), nhel, den(448))
    call Hcont_QA(nsync, wf16(:,154), wf8(:,140), A(:,867), n3(:,1567), t3x128(:,:,867), nhel, den(449))
    call Hcont_QA(nsync, wf16(:,154), wf8(:,142), A(:,868), n3(:,1568), t3x128(:,:,868), nhel, den(450))
    call Hcont_QA(nsync, wf16(:,155), wf8(:,140), A(:,869), n3(:,1569), t3x128(:,:,869), nhel, den(451))
    call Hcont_QA(nsync, wf16(:,155), wf8(:,142), A(:,870), n3(:,1570), t3x128(:,:,870), nhel, den(452))
    call Hcont_QA(nsync, wf16(:,156), wf8(:,140), A(:,871), n3(:,1571), t3x128(:,:,871), nhel, den(453))
    call Hcont_QA(nsync, wf16(:,156), wf8(:,142), A(:,872), n3(:,1572), t3x128(:,:,872), nhel, den(454))
    call Hcont_QA(nsync, wf16(:,157), wf8(:,144), A(:,873), n3(:,1573), t3x128(:,:,873), nhel, den(455))
    call Hcont_QA(nsync, wf16(:,157), wf8(:,146), A(:,874), n3(:,1574), t3x128(:,:,874), nhel, den(456))
    call Hcont_QA(nsync, wf16(:,158), wf8(:,144), A(:,875), n3(:,1575), t3x128(:,:,875), nhel, den(457))
    call Hcont_QA(nsync, wf16(:,158), wf8(:,146), A(:,876), n3(:,1576), t3x128(:,:,876), nhel, den(458))
    call Hcont_VV(nsync, wf8(:,94), wf16(:,293), A(:,877), n3(:,1577), t3x128(:,:,877), nhel, den(459))
    call Hcont_VV(nsync, wf8(:,96), wf16(:,294), A(:,878), n3(:,1578), t3x128(:,:,878), nhel, den(460))
    call Hcont_VV(nsync, wf8(:,94), wf16(:,295), A(:,879), n3(:,1579), t3x128(:,:,879), nhel, den(461))
    call Hcont_VV(nsync, wf8(:,96), wf16(:,296), A(:,880), n3(:,1580), t3x128(:,:,880), nhel, den(462))
    call Hcont_QA(nsync, wf16(:,159), wf8(:,168), A(:,881), n3(:,1581), t3x128(:,:,881), nhel, den(463))
    call Hcont_QA(nsync, wf16(:,159), wf8(:,170), A(:,882), n3(:,1582), t3x128(:,:,882), nhel, den(464))
    call Hcont_QA(nsync, wf16(:,160), wf8(:,168), A(:,883), n3(:,1583), t3x128(:,:,883), nhel, den(465))
    call Hcont_QA(nsync, wf16(:,160), wf8(:,170), A(:,884), n3(:,1584), t3x128(:,:,884), nhel, den(466))
    call Hcont_QA(nsync, wf16(:,161), wf8(:,168), A(:,885), n3(:,1585), t3x128(:,:,885), nhel, den(467))
    call Hcont_QA(nsync, wf16(:,161), wf8(:,170), A(:,886), n3(:,1586), t3x128(:,:,886), nhel, den(468))
    call Hcont_QA(nsync, wf16(:,162), wf8(:,168), A(:,887), n3(:,1587), t3x128(:,:,887), nhel, den(469))
    call Hcont_QA(nsync, wf16(:,162), wf8(:,170), A(:,888), n3(:,1588), t3x128(:,:,888), nhel, den(470))
    call Hcont_QA(nsync, wf16(:,163), wf8(:,144), A(:,889), n3(:,1589), t3x128(:,:,889), nhel, den(471))
    call Hcont_QA(nsync, wf16(:,163), wf8(:,146), A(:,890), n3(:,1590), t3x128(:,:,890), nhel, den(472))
    call Hcont_QA(nsync, wf16(:,164), wf8(:,144), A(:,891), n3(:,1591), t3x128(:,:,891), nhel, den(473))
    call Hcont_QA(nsync, wf16(:,164), wf8(:,146), A(:,892), n3(:,1592), t3x128(:,:,892), nhel, den(474))
    call Hcont_VV(nsync, wf8(:,36), wf16(:,289), A(:,893), n3(:,1593), t3x128(:,:,893), nhel, den(475))
    call Hcont_VV(nsync, wf8(:,38), wf16(:,290), A(:,894), n3(:,1594), t3x128(:,:,894), nhel, den(476))
    call Hcont_VV(nsync, wf8(:,36), wf16(:,291), A(:,895), n3(:,1595), t3x128(:,:,895), nhel, den(477))
    call Hcont_VV(nsync, wf8(:,38), wf16(:,292), A(:,896), n3(:,1596), t3x128(:,:,896), nhel, den(478))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,297), A(:,897), n3(:,1597), t3x128(:,:,897), nhel, den(537))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,298), A(:,898), n3(:,1598), t3x128(:,:,898), nhel, den(539))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,297), A(:,899), n3(:,1599), t3x128(:,:,899), nhel, den(540))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,298), A(:,900), n3(:,1600), t3x128(:,:,900), nhel, den(541))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,299), A(:,901), n3(:,1601), t3x128(:,:,901), nhel, den(543))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,299), A(:,902), n3(:,1602), t3x128(:,:,902), nhel, den(544))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,300), A(:,903), n3(:,1603), t3x128(:,:,903), nhel, den(546))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,300), A(:,904), n3(:,1604), t3x128(:,:,904), nhel, den(547))
    call Hcont_QA(nsync, wf16(:,179), wf8(:,171), A(:,905), n3(:,1605), t3x128(:,:,905), nhel, den(548))
    call Hcont_QA(nsync, wf16(:,180), wf8(:,171), A(:,906), n3(:,1606), t3x128(:,:,906), nhel, den(549))
    call Hcont_QA(nsync, wf16(:,179), wf8(:,172), A(:,907), n3(:,1607), t3x128(:,:,907), nhel, den(550))
    call Hcont_QA(nsync, wf16(:,180), wf8(:,172), A(:,908), n3(:,1608), t3x128(:,:,908), nhel, den(551))
    call Hcont_QA(nsync, wf16(:,177), wf8(:,173), A(:,909), n3(:,1609), t3x128(:,:,909), nhel, den(552))
    call Hcont_QA(nsync, wf16(:,177), wf8(:,174), A(:,910), n3(:,1610), t3x128(:,:,910), nhel, den(553))
    call Hcont_QA(nsync, wf16(:,178), wf8(:,173), A(:,911), n3(:,1611), t3x128(:,:,911), nhel, den(554))
    call Hcont_QA(nsync, wf16(:,178), wf8(:,174), A(:,912), n3(:,1612), t3x128(:,:,912), nhel, den(555))
    call Hcont_QA(nsync, wf16(:,187), wf8(:,175), A(:,913), n3(:,1613), t3x128(:,:,913), nhel, den(556))
    call Hcont_QA(nsync, wf16(:,188), wf8(:,175), A(:,914), n3(:,1614), t3x128(:,:,914), nhel, den(557))
    call Hcont_QA(nsync, wf16(:,187), wf8(:,176), A(:,915), n3(:,1615), t3x128(:,:,915), nhel, den(558))
    call Hcont_QA(nsync, wf16(:,188), wf8(:,176), A(:,916), n3(:,1616), t3x128(:,:,916), nhel, den(559))
    call Hcont_QA(nsync, wf16(:,185), wf8(:,177), A(:,917), n3(:,1617), t3x128(:,:,917), nhel, den(560))
    call Hcont_QA(nsync, wf16(:,185), wf8(:,178), A(:,918), n3(:,1618), t3x128(:,:,918), nhel, den(561))
    call Hcont_QA(nsync, wf16(:,186), wf8(:,177), A(:,919), n3(:,1619), t3x128(:,:,919), nhel, den(562))
    call Hcont_QA(nsync, wf16(:,186), wf8(:,178), A(:,920), n3(:,1620), t3x128(:,:,920), nhel, den(563))
    call Hcont_QA(nsync, wf8(:,10), wf16(:,301), A(:,921), n3(:,1621), t3x128(:,:,921), nhel, den(566))
    call Hcont_QA(nsync, wf8(:,10), wf16(:,302), A(:,922), n3(:,1622), t3x128(:,:,922), nhel, den(568))
    call Hcont_QA(nsync, wf8(:,12), wf16(:,301), A(:,923), n3(:,1623), t3x128(:,:,923), nhel, den(569))
    call Hcont_QA(nsync, wf8(:,12), wf16(:,302), A(:,924), n3(:,1624), t3x128(:,:,924), nhel, den(570))
    call Hcont_QA(nsync, wf8(:,14), wf16(:,303), A(:,925), n3(:,1625), t3x128(:,:,925), nhel, den(572))
    call Hcont_QA(nsync, wf8(:,16), wf16(:,303), A(:,926), n3(:,1626), t3x128(:,:,926), nhel, den(573))
    call Hcont_QA(nsync, wf8(:,14), wf16(:,304), A(:,927), n3(:,1627), t3x128(:,:,927), nhel, den(575))
    call Hcont_QA(nsync, wf8(:,16), wf16(:,304), A(:,928), n3(:,1628), t3x128(:,:,928), nhel, den(576))
    call Hcont_QA(nsync, wf8(:,175), wf16(:,306), A(:,929), n3(:,1629), t3x128(:,:,929), nhel, den(578))
    call Hcont_QA(nsync, wf8(:,175), wf16(:,308), A(:,930), n3(:,1630), t3x128(:,:,930), nhel, den(580))
    call Hcont_QA(nsync, wf8(:,176), wf16(:,306), A(:,931), n3(:,1631), t3x128(:,:,931), nhel, den(581))
    call Hcont_QA(nsync, wf8(:,176), wf16(:,308), A(:,932), n3(:,1632), t3x128(:,:,932), nhel, den(582))
    call Hcont_QA(nsync, wf8(:,177), wf16(:,310), A(:,933), n3(:,1633), t3x128(:,:,933), nhel, den(584))
    call Hcont_QA(nsync, wf8(:,178), wf16(:,310), A(:,934), n3(:,1634), t3x128(:,:,934), nhel, den(585))
    call Hcont_QA(nsync, wf8(:,177), wf16(:,312), A(:,935), n3(:,1635), t3x128(:,:,935), nhel, den(587))
    call Hcont_QA(nsync, wf8(:,178), wf16(:,312), A(:,936), n3(:,1636), t3x128(:,:,936), nhel, den(588))
    call Hcont_QA(nsync, wf8(:,173), wf16(:,313), A(:,937), n3(:,1637), t3x128(:,:,937), nhel, den(590))
    call Hcont_QA(nsync, wf8(:,174), wf16(:,313), A(:,938), n3(:,1638), t3x128(:,:,938), nhel, den(591))
    call Hcont_QA(nsync, wf8(:,173), wf16(:,314), A(:,939), n3(:,1639), t3x128(:,:,939), nhel, den(593))
    call Hcont_QA(nsync, wf8(:,174), wf16(:,314), A(:,940), n3(:,1640), t3x128(:,:,940), nhel, den(594))
    call Hcont_QA(nsync, wf8(:,171), wf16(:,315), A(:,941), n3(:,1641), t3x128(:,:,941), nhel, den(596))
    call Hcont_QA(nsync, wf8(:,171), wf16(:,316), A(:,942), n3(:,1642), t3x128(:,:,942), nhel, den(598))
    call Hcont_QA(nsync, wf8(:,172), wf16(:,315), A(:,943), n3(:,1643), t3x128(:,:,943), nhel, den(599))
    call Hcont_QA(nsync, wf8(:,172), wf16(:,316), A(:,944), n3(:,1644), t3x128(:,:,944), nhel, den(600))
    call Hcont_QA(nsync, wf8(:,175), wf16(:,317), A(:,945), n3(:,1645), t3x128(:,:,945), nhel, den(602))
    call Hcont_QA(nsync, wf8(:,175), wf16(:,318), A(:,946), n3(:,1646), t3x128(:,:,946), nhel, den(604))
    call Hcont_QA(nsync, wf8(:,176), wf16(:,317), A(:,947), n3(:,1647), t3x128(:,:,947), nhel, den(605))
    call Hcont_QA(nsync, wf8(:,176), wf16(:,318), A(:,948), n3(:,1648), t3x128(:,:,948), nhel, den(606))
    call Hcont_QA(nsync, wf8(:,171), wf16(:,319), A(:,949), n3(:,1649), t3x128(:,:,949), nhel, den(608))
    call Hcont_QA(nsync, wf8(:,171), wf16(:,320), A(:,950), n3(:,1650), t3x128(:,:,950), nhel, den(610))
    call Hcont_QA(nsync, wf8(:,172), wf16(:,319), A(:,951), n3(:,1651), t3x128(:,:,951), nhel, den(611))
    call Hcont_QA(nsync, wf8(:,172), wf16(:,320), A(:,952), n3(:,1652), t3x128(:,:,952), nhel, den(612))
    call Hcont_QA(nsync, wf8(:,175), wf16(:,321), A(:,953), n3(:,1653), t3x128(:,:,953), nhel, den(614))
    call Hcont_QA(nsync, wf8(:,175), wf16(:,322), A(:,954), n3(:,1654), t3x128(:,:,954), nhel, den(616))
    call Hcont_QA(nsync, wf8(:,176), wf16(:,321), A(:,955), n3(:,1655), t3x128(:,:,955), nhel, den(617))
    call Hcont_QA(nsync, wf8(:,176), wf16(:,322), A(:,956), n3(:,1656), t3x128(:,:,956), nhel, den(618))
    call Hcont_QA(nsync, wf8(:,171), wf16(:,323), A(:,957), n3(:,1657), t3x128(:,:,957), nhel, den(620))
    call Hcont_QA(nsync, wf8(:,171), wf16(:,324), A(:,958), n3(:,1658), t3x128(:,:,958), nhel, den(622))
    call Hcont_QA(nsync, wf8(:,172), wf16(:,323), A(:,959), n3(:,1659), t3x128(:,:,959), nhel, den(623))
    call Hcont_QA(nsync, wf8(:,172), wf16(:,324), A(:,960), n3(:,1660), t3x128(:,:,960), nhel, den(624))
    call Hcont_VV(nsync, wf16(:,33), wf8(:,179), A(:,961), n3(:,1661), t3x128(:,:,961), nhel, den(627))
    call Hcont_VV(nsync, wf8(:,180), wf16(:,325), A(:,962), n3(:,1662), t3x128(:,:,962), nhel, den(630))
    call Hcont_VV(nsync, wf16(:,35), wf8(:,179), A(:,963), n3(:,1663), t3x128(:,:,963), nhel, den(632))
    call Hcont_VV(nsync, wf8(:,180), wf16(:,326), A(:,964), n3(:,1664), t3x128(:,:,964), nhel, den(634))
    call Hcont_VV(nsync, wf16(:,37), wf8(:,179), A(:,965), n3(:,1665), t3x128(:,:,965), nhel, den(636))
    call Hcont_VV(nsync, wf8(:,180), wf16(:,327), A(:,966), n3(:,1666), t3x128(:,:,966), nhel, den(638))
    call Hcont_VV(nsync, wf16(:,39), wf8(:,179), A(:,967), n3(:,1667), t3x128(:,:,967), nhel, den(640))
    call Hcont_VV(nsync, wf8(:,180), wf16(:,328), A(:,968), n3(:,1668), t3x128(:,:,968), nhel, den(642))
    call Hcont_VV(nsync, wf16(:,33), wf8(:,181), A(:,969), n3(:,1669), t3x128(:,:,969), nhel, den(643))
    call Hcont_VV(nsync, wf16(:,325), wf8(:,182), A(:,970), n3(:,1670), t3x128(:,:,970), nhel, den(644))
    call Hcont_VV(nsync, wf16(:,35), wf8(:,181), A(:,971), n3(:,1671), t3x128(:,:,971), nhel, den(645))
    call Hcont_VV(nsync, wf16(:,326), wf8(:,182), A(:,972), n3(:,1672), t3x128(:,:,972), nhel, den(646))
    call Hcont_VV(nsync, wf16(:,37), wf8(:,181), A(:,973), n3(:,1673), t3x128(:,:,973), nhel, den(647))
    call Hcont_VV(nsync, wf16(:,327), wf8(:,182), A(:,974), n3(:,1674), t3x128(:,:,974), nhel, den(648))
    call Hcont_VV(nsync, wf16(:,39), wf8(:,181), A(:,975), n3(:,1675), t3x128(:,:,975), nhel, den(649))
    call Hcont_VV(nsync, wf16(:,328), wf8(:,182), A(:,976), n3(:,1676), t3x128(:,:,976), nhel, den(650))
    call Hcont_QA(nsync, wf8(:,46), wf16(:,329), A(:,977), n3(:,1677), t3x128(:,:,977), nhel, den(652))
    call Hcont_QA(nsync, wf8(:,46), wf16(:,330), A(:,978), n3(:,1678), t3x128(:,:,978), nhel, den(654))
    call Hcont_QA(nsync, wf8(:,48), wf16(:,329), A(:,979), n3(:,1679), t3x128(:,:,979), nhel, den(655))
    call Hcont_QA(nsync, wf8(:,48), wf16(:,330), A(:,980), n3(:,1680), t3x128(:,:,980), nhel, den(656))
    call Hcont_QA(nsync, wf8(:,50), wf16(:,331), A(:,981), n3(:,1681), t3x128(:,:,981), nhel, den(658))
    call Hcont_QA(nsync, wf8(:,52), wf16(:,331), A(:,982), n3(:,1682), t3x128(:,:,982), nhel, den(659))
    call Hcont_QA(nsync, wf8(:,50), wf16(:,332), A(:,983), n3(:,1683), t3x128(:,:,983), nhel, den(661))
    call Hcont_QA(nsync, wf8(:,52), wf16(:,332), A(:,984), n3(:,1684), t3x128(:,:,984), nhel, den(662))
    call Hcont_QA(nsync, wf16(:,225), wf8(:,183), A(:,985), n3(:,1685), t3x128(:,:,985), nhel, den(663))
    call Hcont_QA(nsync, wf16(:,226), wf8(:,183), A(:,986), n3(:,1686), t3x128(:,:,986), nhel, den(664))
    call Hcont_QA(nsync, wf16(:,225), wf8(:,184), A(:,987), n3(:,1687), t3x128(:,:,987), nhel, den(665))
    call Hcont_QA(nsync, wf16(:,226), wf8(:,184), A(:,988), n3(:,1688), t3x128(:,:,988), nhel, den(666))
    call Hcont_QA(nsync, wf16(:,223), wf8(:,185), A(:,989), n3(:,1689), t3x128(:,:,989), nhel, den(667))
    call Hcont_QA(nsync, wf16(:,223), wf8(:,186), A(:,990), n3(:,1690), t3x128(:,:,990), nhel, den(668))
    call Hcont_QA(nsync, wf16(:,224), wf8(:,185), A(:,991), n3(:,1691), t3x128(:,:,991), nhel, den(669))
    call Hcont_QA(nsync, wf16(:,224), wf8(:,186), A(:,992), n3(:,1692), t3x128(:,:,992), nhel, den(670))
    call Hcont_QA(nsync, wf16(:,233), wf8(:,187), A(:,993), n3(:,1693), t3x128(:,:,993), nhel, den(671))
    call Hcont_QA(nsync, wf16(:,234), wf8(:,187), A(:,994), n3(:,1694), t3x128(:,:,994), nhel, den(672))
    call Hcont_QA(nsync, wf16(:,233), wf8(:,188), A(:,995), n3(:,1695), t3x128(:,:,995), nhel, den(673))
    call Hcont_QA(nsync, wf16(:,234), wf8(:,188), A(:,996), n3(:,1696), t3x128(:,:,996), nhel, den(674))
    call Hcont_QA(nsync, wf16(:,231), wf8(:,189), A(:,997), n3(:,1697), t3x128(:,:,997), nhel, den(675))
    call Hcont_QA(nsync, wf16(:,231), wf8(:,190), A(:,998), n3(:,1698), t3x128(:,:,998), nhel, den(676))
    call Hcont_QA(nsync, wf16(:,232), wf8(:,189), A(:,999), n3(:,1699), t3x128(:,:,999), nhel, den(677))
    call Hcont_QA(nsync, wf16(:,232), wf8(:,190), A(:,1000), n3(:,1700), t3x128(:,:,1000), nhel, den(678))
    call Hcont_QA(nsync, wf8(:,54), wf16(:,333), A(:,1001), n3(:,1701), t3x128(:,:,1001), nhel, den(680))
    call Hcont_QA(nsync, wf8(:,54), wf16(:,334), A(:,1002), n3(:,1702), t3x128(:,:,1002), nhel, den(682))
    call Hcont_QA(nsync, wf8(:,56), wf16(:,333), A(:,1003), n3(:,1703), t3x128(:,:,1003), nhel, den(683))
    call Hcont_QA(nsync, wf8(:,56), wf16(:,334), A(:,1004), n3(:,1704), t3x128(:,:,1004), nhel, den(684))
    call Hcont_QA(nsync, wf8(:,58), wf16(:,335), A(:,1005), n3(:,1705), t3x128(:,:,1005), nhel, den(686))
    call Hcont_QA(nsync, wf8(:,60), wf16(:,335), A(:,1006), n3(:,1706), t3x128(:,:,1006), nhel, den(687))
    call Hcont_QA(nsync, wf8(:,58), wf16(:,336), A(:,1007), n3(:,1707), t3x128(:,:,1007), nhel, den(689))
    call Hcont_QA(nsync, wf8(:,60), wf16(:,336), A(:,1008), n3(:,1708), t3x128(:,:,1008), nhel, den(690))
    call Hcont_QA(nsync, wf8(:,187), wf16(:,338), A(:,1009), n3(:,1709), t3x128(:,:,1009), nhel, den(692))
    call Hcont_QA(nsync, wf8(:,187), wf16(:,340), A(:,1010), n3(:,1710), t3x128(:,:,1010), nhel, den(694))
    call Hcont_QA(nsync, wf8(:,188), wf16(:,338), A(:,1011), n3(:,1711), t3x128(:,:,1011), nhel, den(695))
    call Hcont_QA(nsync, wf8(:,188), wf16(:,340), A(:,1012), n3(:,1712), t3x128(:,:,1012), nhel, den(696))
    call Hcont_QA(nsync, wf8(:,189), wf16(:,342), A(:,1013), n3(:,1713), t3x128(:,:,1013), nhel, den(698))
    call Hcont_QA(nsync, wf8(:,190), wf16(:,342), A(:,1014), n3(:,1714), t3x128(:,:,1014), nhel, den(699))
    call Hcont_QA(nsync, wf8(:,189), wf16(:,344), A(:,1015), n3(:,1715), t3x128(:,:,1015), nhel, den(701))
    call Hcont_QA(nsync, wf8(:,190), wf16(:,344), A(:,1016), n3(:,1716), t3x128(:,:,1016), nhel, den(702))
    call Hcont_QA(nsync, wf8(:,185), wf16(:,345), A(:,1017), n3(:,1717), t3x128(:,:,1017), nhel, den(704))
    call Hcont_QA(nsync, wf8(:,186), wf16(:,345), A(:,1018), n3(:,1718), t3x128(:,:,1018), nhel, den(705))
    call Hcont_QA(nsync, wf8(:,185), wf16(:,346), A(:,1019), n3(:,1719), t3x128(:,:,1019), nhel, den(707))
    call Hcont_QA(nsync, wf8(:,186), wf16(:,346), A(:,1020), n3(:,1720), t3x128(:,:,1020), nhel, den(708))
    call Hcont_QA(nsync, wf8(:,183), wf16(:,347), A(:,1021), n3(:,1721), t3x128(:,:,1021), nhel, den(710))
    call Hcont_QA(nsync, wf8(:,183), wf16(:,348), A(:,1022), n3(:,1722), t3x128(:,:,1022), nhel, den(712))
    call Hcont_QA(nsync, wf8(:,184), wf16(:,347), A(:,1023), n3(:,1723), t3x128(:,:,1023), nhel, den(713))
    call Hcont_QA(nsync, wf8(:,184), wf16(:,348), A(:,1024), n3(:,1724), t3x128(:,:,1024), nhel, den(714))
    call Hcont_QA(nsync, wf8(:,189), wf16(:,349), A(:,1025), n3(:,1725), t3x128(:,:,1025), nhel, den(716))
    call Hcont_QA(nsync, wf8(:,189), wf16(:,350), A(:,1026), n3(:,1726), t3x128(:,:,1026), nhel, den(718))
    call Hcont_QA(nsync, wf8(:,190), wf16(:,349), A(:,1027), n3(:,1727), t3x128(:,:,1027), nhel, den(719))
    call Hcont_QA(nsync, wf8(:,190), wf16(:,350), A(:,1028), n3(:,1728), t3x128(:,:,1028), nhel, den(720))
    call Hcont_QA(nsync, wf8(:,185), wf16(:,351), A(:,1029), n3(:,1729), t3x128(:,:,1029), nhel, den(722))
    call Hcont_QA(nsync, wf8(:,185), wf16(:,352), A(:,1030), n3(:,1730), t3x128(:,:,1030), nhel, den(724))
    call Hcont_QA(nsync, wf8(:,186), wf16(:,351), A(:,1031), n3(:,1731), t3x128(:,:,1031), nhel, den(725))
    call Hcont_QA(nsync, wf8(:,186), wf16(:,352), A(:,1032), n3(:,1732), t3x128(:,:,1032), nhel, den(726))
    call Hcont_QA(nsync, wf8(:,185), wf16(:,353), A(:,1033), n3(:,1733), t3x128(:,:,1033), nhel, den(728))
    call Hcont_QA(nsync, wf8(:,186), wf16(:,353), A(:,1034), n3(:,1734), t3x128(:,:,1034), nhel, den(729))
    call Hcont_QA(nsync, wf8(:,185), wf16(:,354), A(:,1035), n3(:,1735), t3x128(:,:,1035), nhel, den(731))
    call Hcont_QA(nsync, wf8(:,186), wf16(:,354), A(:,1036), n3(:,1736), t3x128(:,:,1036), nhel, den(732))
    call Hcont_QA(nsync, wf8(:,189), wf16(:,355), A(:,1037), n3(:,1737), t3x128(:,:,1037), nhel, den(734))
    call Hcont_QA(nsync, wf8(:,190), wf16(:,355), A(:,1038), n3(:,1738), t3x128(:,:,1038), nhel, den(735))
    call Hcont_QA(nsync, wf8(:,189), wf16(:,356), A(:,1039), n3(:,1739), t3x128(:,:,1039), nhel, den(737))
    call Hcont_QA(nsync, wf8(:,190), wf16(:,356), A(:,1040), n3(:,1740), t3x128(:,:,1040), nhel, den(738))
    call Hcont_VV(nsync, wf16(:,71), wf8(:,179), A(:,1041), n3(:,1741), t3x128(:,:,1041), nhel, den(740))
    call Hcont_VV(nsync, wf8(:,180), wf16(:,357), A(:,1042), n3(:,1742), t3x128(:,:,1042), nhel, den(742))
    call Hcont_VV(nsync, wf16(:,73), wf8(:,179), A(:,1043), n3(:,1743), t3x128(:,:,1043), nhel, den(744))
    call Hcont_VV(nsync, wf8(:,180), wf16(:,358), A(:,1044), n3(:,1744), t3x128(:,:,1044), nhel, den(746))
    call Hcont_VV(nsync, wf16(:,75), wf8(:,179), A(:,1045), n3(:,1745), t3x128(:,:,1045), nhel, den(748))
    call Hcont_VV(nsync, wf16(:,76), wf8(:,179), A(:,1046), n3(:,1746), t3x128(:,:,1046), nhel, den(750))
    call Hcont_VV(nsync, wf8(:,180), wf16(:,359), A(:,1047), n3(:,1747), t3x128(:,:,1047), nhel, den(752))
    call Hcont_VV(nsync, wf8(:,180), wf16(:,360), A(:,1048), n3(:,1748), t3x128(:,:,1048), nhel, den(754))
    call Hcont_VV(nsync, wf16(:,71), wf8(:,181), A(:,1049), n3(:,1749), t3x128(:,:,1049), nhel, den(755))
    call Hcont_VV(nsync, wf8(:,182), wf16(:,357), A(:,1050), n3(:,1750), t3x128(:,:,1050), nhel, den(756))
    call Hcont_VV(nsync, wf16(:,73), wf8(:,181), A(:,1051), n3(:,1751), t3x128(:,:,1051), nhel, den(757))
    call Hcont_VV(nsync, wf8(:,182), wf16(:,358), A(:,1052), n3(:,1752), t3x128(:,:,1052), nhel, den(758))
    call Hcont_VV(nsync, wf16(:,75), wf8(:,181), A(:,1053), n3(:,1753), t3x128(:,:,1053), nhel, den(759))
    call Hcont_VV(nsync, wf16(:,76), wf8(:,181), A(:,1054), n3(:,1754), t3x128(:,:,1054), nhel, den(760))
    call Hcont_VV(nsync, wf8(:,182), wf16(:,359), A(:,1055), n3(:,1755), t3x128(:,:,1055), nhel, den(761))
    call Hcont_VV(nsync, wf8(:,182), wf16(:,360), A(:,1056), n3(:,1756), t3x128(:,:,1056), nhel, den(762))
    call Hcont_QA(nsync, wf8(:,187), wf16(:,361), A(:,1057), n3(:,1757), t3x128(:,:,1057), nhel, den(764))
    call Hcont_QA(nsync, wf8(:,187), wf16(:,362), A(:,1058), n3(:,1758), t3x128(:,:,1058), nhel, den(766))
    call Hcont_QA(nsync, wf8(:,188), wf16(:,361), A(:,1059), n3(:,1759), t3x128(:,:,1059), nhel, den(767))
    call Hcont_QA(nsync, wf8(:,188), wf16(:,362), A(:,1060), n3(:,1760), t3x128(:,:,1060), nhel, den(768))
    call Hcont_QA(nsync, wf8(:,183), wf16(:,363), A(:,1061), n3(:,1761), t3x128(:,:,1061), nhel, den(770))
    call Hcont_QA(nsync, wf8(:,183), wf16(:,364), A(:,1062), n3(:,1762), t3x128(:,:,1062), nhel, den(772))
    call Hcont_QA(nsync, wf8(:,184), wf16(:,363), A(:,1063), n3(:,1763), t3x128(:,:,1063), nhel, den(773))
    call Hcont_QA(nsync, wf8(:,184), wf16(:,364), A(:,1064), n3(:,1764), t3x128(:,:,1064), nhel, den(774))
    call Hcont_QA(nsync, wf8(:,187), wf16(:,365), A(:,1065), n3(:,1765), t3x128(:,:,1065), nhel, den(776))
    call Hcont_QA(nsync, wf8(:,187), wf16(:,366), A(:,1066), n3(:,1766), t3x128(:,:,1066), nhel, den(778))
    call Hcont_QA(nsync, wf8(:,188), wf16(:,365), A(:,1067), n3(:,1767), t3x128(:,:,1067), nhel, den(779))
    call Hcont_QA(nsync, wf8(:,188), wf16(:,366), A(:,1068), n3(:,1768), t3x128(:,:,1068), nhel, den(780))
    call Hcont_QA(nsync, wf8(:,183), wf16(:,367), A(:,1069), n3(:,1769), t3x128(:,:,1069), nhel, den(782))
    call Hcont_QA(nsync, wf8(:,183), wf16(:,368), A(:,1070), n3(:,1770), t3x128(:,:,1070), nhel, den(784))
    call Hcont_QA(nsync, wf8(:,184), wf16(:,367), A(:,1071), n3(:,1771), t3x128(:,:,1071), nhel, den(785))
    call Hcont_QA(nsync, wf8(:,184), wf16(:,368), A(:,1072), n3(:,1772), t3x128(:,:,1072), nhel, den(786))
    call Hcont_VV(nsync, wf16(:,95), wf8(:,179), A(:,1073), n3(:,1773), t3x128(:,:,1073), nhel, den(788))
    call Hcont_VV(nsync, wf8(:,180), wf16(:,369), A(:,1074), n3(:,1774), t3x128(:,:,1074), nhel, den(790))
    call Hcont_VV(nsync, wf16(:,97), wf8(:,179), A(:,1075), n3(:,1775), t3x128(:,:,1075), nhel, den(792))
    call Hcont_VV(nsync, wf8(:,180), wf16(:,370), A(:,1076), n3(:,1776), t3x128(:,:,1076), nhel, den(794))
    call Hcont_VV(nsync, wf16(:,99), wf8(:,179), A(:,1077), n3(:,1777), t3x128(:,:,1077), nhel, den(796))
    call Hcont_VV(nsync, wf8(:,180), wf16(:,371), A(:,1078), n3(:,1778), t3x128(:,:,1078), nhel, den(798))
    call Hcont_VV(nsync, wf16(:,101), wf8(:,179), A(:,1079), n3(:,1779), t3x128(:,:,1079), nhel, den(800))
    call Hcont_VV(nsync, wf8(:,180), wf16(:,372), A(:,1080), n3(:,1780), t3x128(:,:,1080), nhel, den(802))
    call Hcont_VV(nsync, wf16(:,95), wf8(:,181), A(:,1081), n3(:,1781), t3x128(:,:,1081), nhel, den(803))
    call Hcont_VV(nsync, wf8(:,182), wf16(:,369), A(:,1082), n3(:,1782), t3x128(:,:,1082), nhel, den(804))
    call Hcont_VV(nsync, wf16(:,97), wf8(:,181), A(:,1083), n3(:,1783), t3x128(:,:,1083), nhel, den(805))
    call Hcont_VV(nsync, wf8(:,182), wf16(:,370), A(:,1084), n3(:,1784), t3x128(:,:,1084), nhel, den(806))
    call Hcont_VV(nsync, wf16(:,99), wf8(:,181), A(:,1085), n3(:,1785), t3x128(:,:,1085), nhel, den(807))
    call Hcont_VV(nsync, wf8(:,182), wf16(:,371), A(:,1086), n3(:,1786), t3x128(:,:,1086), nhel, den(808))
    call Hcont_VV(nsync, wf16(:,101), wf8(:,181), A(:,1087), n3(:,1787), t3x128(:,:,1087), nhel, den(809))
    call Hcont_VV(nsync, wf8(:,182), wf16(:,372), A(:,1088), n3(:,1788), t3x128(:,:,1088), nhel, den(810))
    call Hcont_QA(nsync, wf8(:,177), wf16(:,373), A(:,1089), n3(:,1789), t3x128(:,:,1089), nhel, den(812))
    call Hcont_QA(nsync, wf8(:,177), wf16(:,374), A(:,1090), n3(:,1790), t3x128(:,:,1090), nhel, den(814))
    call Hcont_QA(nsync, wf8(:,178), wf16(:,373), A(:,1091), n3(:,1791), t3x128(:,:,1091), nhel, den(815))
    call Hcont_QA(nsync, wf8(:,178), wf16(:,374), A(:,1092), n3(:,1792), t3x128(:,:,1092), nhel, den(816))
    call Hcont_QA(nsync, wf8(:,173), wf16(:,375), A(:,1093), n3(:,1793), t3x128(:,:,1093), nhel, den(818))
    call Hcont_QA(nsync, wf8(:,173), wf16(:,376), A(:,1094), n3(:,1794), t3x128(:,:,1094), nhel, den(820))
    call Hcont_QA(nsync, wf8(:,174), wf16(:,375), A(:,1095), n3(:,1795), t3x128(:,:,1095), nhel, den(821))
    call Hcont_QA(nsync, wf8(:,174), wf16(:,376), A(:,1096), n3(:,1796), t3x128(:,:,1096), nhel, den(822))
    call Hcont_QA(nsync, wf8(:,173), wf16(:,377), A(:,1097), n3(:,1797), t3x128(:,:,1097), nhel, den(824))
    call Hcont_QA(nsync, wf8(:,174), wf16(:,377), A(:,1098), n3(:,1798), t3x128(:,:,1098), nhel, den(825))
    call Hcont_QA(nsync, wf8(:,173), wf16(:,378), A(:,1099), n3(:,1799), t3x128(:,:,1099), nhel, den(827))
    call Hcont_QA(nsync, wf8(:,174), wf16(:,378), A(:,1100), n3(:,1800), t3x128(:,:,1100), nhel, den(828))
    call Hcont_QA(nsync, wf8(:,177), wf16(:,379), A(:,1101), n3(:,1801), t3x128(:,:,1101), nhel, den(830))
    call Hcont_QA(nsync, wf8(:,178), wf16(:,379), A(:,1102), n3(:,1802), t3x128(:,:,1102), nhel, den(831))
    call Hcont_QA(nsync, wf8(:,177), wf16(:,380), A(:,1103), n3(:,1803), t3x128(:,:,1103), nhel, den(833))
    call Hcont_QA(nsync, wf8(:,178), wf16(:,380), A(:,1104), n3(:,1804), t3x128(:,:,1104), nhel, den(834))
    call Hcont_VV(nsync, wf16(:,117), wf8(:,179), A(:,1105), n3(:,1805), t3x128(:,:,1105), nhel, den(836))
    call Hcont_VV(nsync, wf8(:,180), wf16(:,381), A(:,1106), n3(:,1806), t3x128(:,:,1106), nhel, den(838))
    call Hcont_VV(nsync, wf16(:,119), wf8(:,179), A(:,1107), n3(:,1807), t3x128(:,:,1107), nhel, den(840))
    call Hcont_VV(nsync, wf8(:,180), wf16(:,382), A(:,1108), n3(:,1808), t3x128(:,:,1108), nhel, den(842))
    call Hcont_VV(nsync, wf16(:,121), wf8(:,179), A(:,1109), n3(:,1809), t3x128(:,:,1109), nhel, den(844))
    call Hcont_VV(nsync, wf16(:,122), wf8(:,179), A(:,1110), n3(:,1810), t3x128(:,:,1110), nhel, den(846))
    call Hcont_VV(nsync, wf8(:,180), wf16(:,383), A(:,1111), n3(:,1811), t3x128(:,:,1111), nhel, den(848))
    call Hcont_VV(nsync, wf8(:,180), wf16(:,384), A(:,1112), n3(:,1812), t3x128(:,:,1112), nhel, den(850))
    call Hcont_VV(nsync, wf16(:,117), wf8(:,181), A(:,1113), n3(:,1813), t3x128(:,:,1113), nhel, den(851))
    call Hcont_VV(nsync, wf8(:,182), wf16(:,381), A(:,1114), n3(:,1814), t3x128(:,:,1114), nhel, den(852))
    call Hcont_VV(nsync, wf16(:,119), wf8(:,181), A(:,1115), n3(:,1815), t3x128(:,:,1115), nhel, den(853))
    call Hcont_VV(nsync, wf8(:,182), wf16(:,382), A(:,1116), n3(:,1816), t3x128(:,:,1116), nhel, den(854))
    call Hcont_VV(nsync, wf16(:,121), wf8(:,181), A(:,1117), n3(:,1817), t3x128(:,:,1117), nhel, den(855))
    call Hcont_VV(nsync, wf16(:,122), wf8(:,181), A(:,1118), n3(:,1818), t3x128(:,:,1118), nhel, den(856))
    call Hcont_VV(nsync, wf8(:,182), wf16(:,383), A(:,1119), n3(:,1819), t3x128(:,:,1119), nhel, den(857))
    call Hcont_VV(nsync, wf8(:,182), wf16(:,384), A(:,1120), n3(:,1820), t3x128(:,:,1120), nhel, den(858))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(1), M2(1) ! M1helarray(1,nhel)
  integer :: empty(0), i

  M1(1)%j = (A(j,1)%j+A(j,5)%j+A(j,9)%j+A(j,13)%j+A(j,17)%j+A(j,21)%j-A(j,81)%j-A(j,85)%j-A(j,89)%j-A(j,93)%j-A(j,97)%j &
       -A(j,101)%j)*f(1)+(A(j,2)%j+A(j,3)%j+A(j,6)%j+A(j,7)%j+A(j,10)%j+A(j,11)%j+A(j,14)%j+A(j,15)%j+A(j,18)%j+A(j,19)%j &
       +A(j,22)%j+A(j,23)%j+A(j,49)%j+A(j,53)%j+A(j,57)%j+A(j,61)%j+A(j,65)%j+A(j,67)%j+A(j,69)%j+A(j,71)%j+A(j,73)%j+A(j,75)%j &
       +A(j,77)%j+A(j,79)%j-A(j,82)%j-A(j,83)%j-A(j,86)%j-A(j,87)%j-A(j,90)%j-A(j,91)%j-A(j,94)%j-A(j,95)%j-A(j,98)%j-A(j,99)%j &
       -A(j,102)%j-A(j,103)%j-A(j,129)%j-A(j,133)%j-A(j,137)%j-A(j,141)%j-A(j,145)%j-A(j,147)%j-A(j,149)%j-A(j,150)%j-A(j,153)%j &
       -A(j,155)%j-A(j,157)%j-A(j,158)%j-A(j,185)%j-A(j,189)%j-A(j,193)%j-A(j,197)%j-A(j,201)%j-A(j,203)%j-A(j,205)%j-A(j,207)%j &
       -A(j,209)%j-A(j,211)%j-A(j,213)%j-A(j,215)%j+A(j,241)%j+A(j,245)%j+A(j,249)%j+A(j,253)%j+A(j,257)%j+A(j,259)%j+A(j,261)%j &
       +A(j,262)%j+A(j,265)%j+A(j,267)%j+A(j,269)%j+A(j,270)%j)*f(2)+(A(j,4)%j+A(j,8)%j+A(j,12)%j+A(j,16)%j+A(j,20)%j+A(j,24)%j &
       +A(j,25)%j+A(j,27)%j+A(j,29)%j+A(j,31)%j+A(j,33)%j+A(j,35)%j+A(j,37)%j+A(j,39)%j+A(j,41)%j+A(j,43)%j+A(j,45)%j+A(j,47)%j &
       +A(j,50)%j+A(j,51)%j+A(j,54)%j+A(j,55)%j+A(j,58)%j+A(j,59)%j+A(j,62)%j+A(j,63)%j+A(j,66)%j+A(j,68)%j+A(j,70)%j+A(j,72)%j &
       +A(j,74)%j+A(j,76)%j+A(j,78)%j+A(j,80)%j-A(j,84)%j-A(j,88)%j-A(j,92)%j-A(j,96)%j-A(j,100)%j-A(j,104)%j-A(j,105)%j &
       -A(j,107)%j-A(j,109)%j-A(j,111)%j-A(j,113)%j-A(j,115)%j-A(j,117)%j-A(j,118)%j-A(j,121)%j-A(j,123)%j-A(j,125)%j-A(j,126)%j &
       -A(j,130)%j-A(j,131)%j-A(j,134)%j-A(j,135)%j-A(j,138)%j-A(j,139)%j-A(j,142)%j-A(j,143)%j-A(j,146)%j-A(j,148)%j-A(j,151)%j &
       -A(j,152)%j-A(j,154)%j-A(j,156)%j-A(j,159)%j-A(j,160)%j-A(j,161)%j-A(j,163)%j-A(j,165)%j-A(j,167)%j-A(j,169)%j-A(j,171)%j &
       -A(j,173)%j-A(j,175)%j-A(j,177)%j-A(j,179)%j-A(j,181)%j-A(j,183)%j-A(j,186)%j-A(j,187)%j-A(j,190)%j-A(j,191)%j-A(j,194)%j &
       -A(j,195)%j-A(j,198)%j-A(j,199)%j-A(j,202)%j-A(j,204)%j-A(j,206)%j-A(j,208)%j-A(j,210)%j-A(j,212)%j-A(j,214)%j-A(j,216)%j &
       +A(j,217)%j+A(j,219)%j+A(j,221)%j+A(j,223)%j+A(j,225)%j+A(j,227)%j+A(j,229)%j+A(j,230)%j+A(j,233)%j+A(j,235)%j+A(j,237)%j &
       +A(j,238)%j+A(j,242)%j+A(j,243)%j+A(j,246)%j+A(j,247)%j+A(j,250)%j+A(j,251)%j+A(j,254)%j+A(j,255)%j+A(j,258)%j+A(j,260)%j &
       +A(j,263)%j+A(j,264)%j+A(j,266)%j+A(j,268)%j+A(j,271)%j+A(j,272)%j+A(j,273)%j+A(j,275)%j+A(j,277)%j+A(j,278)%j-A(j,281)%j &
       -A(j,283)%j-A(j,285)%j-A(j,286)%j-A(j,289)%j-A(j,291)%j+A(j,293)%j+A(j,295)%j+A(j,297)%j+A(j,298)%j-A(j,301)%j-A(j,302)%j &
       +A(j,305)%j+A(j,307)%j-A(j,309)%j-A(j,311)%j+A(j,313)%j+A(j,315)%j-A(j,317)%j-A(j,318)%j+A(j,321)%j+A(j,323)%j-A(j,325)%j &
       -A(j,327)%j-A(j,329)%j-A(j,331)%j+A(j,333)%j+A(j,334)%j)*f(3)+(A(j,26)%j+A(j,28)%j+A(j,30)%j+A(j,32)%j+A(j,34)%j+A(j,36)%j &
       +A(j,38)%j+A(j,40)%j+A(j,42)%j+A(j,44)%j+A(j,46)%j+A(j,48)%j+A(j,52)%j+A(j,56)%j+A(j,60)%j+A(j,64)%j-A(j,106)%j-A(j,108)%j &
       -A(j,110)%j-A(j,112)%j-A(j,114)%j-A(j,116)%j-A(j,119)%j-A(j,120)%j-A(j,122)%j-A(j,124)%j-A(j,127)%j-A(j,128)%j-A(j,132)%j &
       -A(j,136)%j-A(j,140)%j-A(j,144)%j-A(j,162)%j-A(j,164)%j-A(j,166)%j-A(j,168)%j-A(j,170)%j-A(j,172)%j-A(j,174)%j-A(j,176)%j &
       -A(j,178)%j-A(j,180)%j-A(j,182)%j-A(j,184)%j-A(j,188)%j-A(j,192)%j-A(j,196)%j-A(j,200)%j+A(j,218)%j+A(j,220)%j+A(j,222)%j &
       +A(j,224)%j+A(j,226)%j+A(j,228)%j+A(j,231)%j+A(j,232)%j+A(j,234)%j+A(j,236)%j+A(j,239)%j+A(j,240)%j+A(j,244)%j+A(j,248)%j &
       +A(j,252)%j+A(j,256)%j+A(j,274)%j+A(j,276)%j+A(j,279)%j+A(j,280)%j-A(j,282)%j-A(j,284)%j-A(j,287)%j-A(j,288)%j-A(j,290)%j &
       -A(j,292)%j+A(j,294)%j+A(j,296)%j+A(j,299)%j+A(j,300)%j-A(j,303)%j-A(j,304)%j+A(j,306)%j+A(j,308)%j-A(j,310)%j-A(j,312)%j &
       +A(j,314)%j+A(j,316)%j-A(j,319)%j-A(j,320)%j+A(j,322)%j+A(j,324)%j-A(j,326)%j-A(j,328)%j-A(j,330)%j-A(j,332)%j+A(j,335)%j &
       +A(j,336)%j)*f(4)

  M2(1)%j = (-A(j,897)%j-A(j,901)%j-A(j,905)%j-A(j,909)%j-A(j,913)%j-A(j,917)%j-A(j,921)%j-A(j,925)%j-A(j,929)%j-A(j,933)%j &
       -A(j,937)%j-A(j,941)%j+A(j,977)%j+A(j,981)%j+A(j,985)%j+A(j,989)%j+A(j,993)%j+A(j,997)%j+A(j,1001)%j+A(j,1005)%j &
       +A(j,1009)%j+A(j,1013)%j+A(j,1017)%j+A(j,1021)%j)*f(5)+(-A(j,898)%j-A(j,899)%j-A(j,902)%j-A(j,903)%j-A(j,906)%j-A(j,907)%j &
       -A(j,910)%j-A(j,911)%j-A(j,914)%j-A(j,915)%j-A(j,918)%j-A(j,919)%j-A(j,922)%j-A(j,923)%j-A(j,926)%j-A(j,927)%j-A(j,930)%j &
       -A(j,931)%j-A(j,934)%j-A(j,935)%j-A(j,938)%j-A(j,939)%j-A(j,942)%j-A(j,943)%j-A(j,945)%j-A(j,949)%j-A(j,953)%j-A(j,957)%j &
       -A(j,961)%j-A(j,963)%j-A(j,965)%j-A(j,967)%j-A(j,969)%j-A(j,971)%j-A(j,973)%j-A(j,975)%j+A(j,978)%j+A(j,979)%j+A(j,982)%j &
       +A(j,983)%j+A(j,986)%j+A(j,987)%j+A(j,990)%j+A(j,991)%j+A(j,994)%j+A(j,995)%j+A(j,998)%j+A(j,999)%j+A(j,1002)%j+A(j,1003)%j &
       +A(j,1006)%j+A(j,1007)%j+A(j,1010)%j+A(j,1011)%j+A(j,1014)%j+A(j,1015)%j+A(j,1018)%j+A(j,1019)%j+A(j,1022)%j+A(j,1023)%j &
       +A(j,1025)%j+A(j,1029)%j+A(j,1033)%j+A(j,1037)%j+A(j,1041)%j+A(j,1043)%j+A(j,1045)%j+A(j,1046)%j+A(j,1049)%j+A(j,1051)%j &
       +A(j,1053)%j+A(j,1054)%j+A(j,1057)%j+A(j,1061)%j+A(j,1065)%j+A(j,1069)%j+A(j,1073)%j+A(j,1075)%j+A(j,1077)%j+A(j,1079)%j &
       +A(j,1081)%j+A(j,1083)%j+A(j,1085)%j+A(j,1087)%j-A(j,1089)%j-A(j,1093)%j-A(j,1097)%j-A(j,1101)%j-A(j,1105)%j-A(j,1107)%j &
       -A(j,1109)%j-A(j,1110)%j-A(j,1113)%j-A(j,1115)%j-A(j,1117)%j-A(j,1118)%j)*f(6)+(-A(j,900)%j-A(j,904)%j-A(j,908)%j &
       -A(j,912)%j-A(j,916)%j-A(j,920)%j-A(j,924)%j-A(j,928)%j-A(j,932)%j-A(j,936)%j-A(j,940)%j-A(j,944)%j-A(j,946)%j-A(j,947)%j &
       -A(j,950)%j-A(j,951)%j-A(j,954)%j-A(j,955)%j-A(j,958)%j-A(j,959)%j-A(j,962)%j-A(j,964)%j-A(j,966)%j-A(j,968)%j-A(j,970)%j &
       -A(j,972)%j-A(j,974)%j-A(j,976)%j+A(j,980)%j+A(j,984)%j+A(j,988)%j+A(j,992)%j+A(j,996)%j+A(j,1000)%j+A(j,1004)%j &
       +A(j,1008)%j+A(j,1012)%j+A(j,1016)%j+A(j,1020)%j+A(j,1024)%j+A(j,1026)%j+A(j,1027)%j+A(j,1030)%j+A(j,1031)%j+A(j,1034)%j &
       +A(j,1035)%j+A(j,1038)%j+A(j,1039)%j+A(j,1042)%j+A(j,1044)%j+A(j,1047)%j+A(j,1048)%j+A(j,1050)%j+A(j,1052)%j+A(j,1055)%j &
       +A(j,1056)%j+A(j,1058)%j+A(j,1059)%j+A(j,1062)%j+A(j,1063)%j+A(j,1066)%j+A(j,1067)%j+A(j,1070)%j+A(j,1071)%j+A(j,1074)%j &
       +A(j,1076)%j+A(j,1078)%j+A(j,1080)%j+A(j,1082)%j+A(j,1084)%j+A(j,1086)%j+A(j,1088)%j-A(j,1090)%j-A(j,1091)%j-A(j,1094)%j &
       -A(j,1095)%j-A(j,1098)%j-A(j,1099)%j-A(j,1102)%j-A(j,1103)%j-A(j,1106)%j-A(j,1108)%j-A(j,1111)%j-A(j,1112)%j-A(j,1114)%j &
       -A(j,1116)%j-A(j,1119)%j-A(j,1120)%j)*f(7)+(-A(j,948)%j-A(j,952)%j-A(j,956)%j-A(j,960)%j+A(j,1028)%j+A(j,1032)%j &
       +A(j,1036)%j+A(j,1040)%j+A(j,1060)%j+A(j,1064)%j+A(j,1068)%j+A(j,1072)%j-A(j,1092)%j-A(j,1096)%j-A(j,1100)%j &
       -A(j,1104)%j)*f(8)+(A(j,337)%j+A(j,341)%j+A(j,345)%j+A(j,349)%j+A(j,353)%j+A(j,357)%j+A(j,361)%j+A(j,365)%j+A(j,369)%j &
       +A(j,373)%j+A(j,377)%j+A(j,381)%j+A(j,385)%j+A(j,389)%j+A(j,393)%j+A(j,397)%j+A(j,401)%j+A(j,405)%j-A(j,497)%j-A(j,501)%j &
       -A(j,505)%j-A(j,509)%j-A(j,513)%j-A(j,517)%j-A(j,521)%j-A(j,525)%j-A(j,529)%j-A(j,533)%j-A(j,537)%j-A(j,541)%j-A(j,545)%j &
       -A(j,549)%j-A(j,553)%j-A(j,557)%j-A(j,561)%j-A(j,565)%j)*f(9)+(A(j,338)%j+A(j,339)%j+A(j,342)%j+A(j,343)%j+A(j,346)%j &
       +A(j,347)%j+A(j,350)%j+A(j,351)%j+A(j,354)%j+A(j,355)%j+A(j,358)%j+A(j,359)%j+A(j,362)%j+A(j,363)%j+A(j,366)%j+A(j,367)%j &
       +A(j,370)%j+A(j,371)%j+A(j,374)%j+A(j,375)%j+A(j,378)%j+A(j,379)%j+A(j,382)%j+A(j,383)%j+A(j,386)%j+A(j,387)%j+A(j,390)%j &
       +A(j,391)%j+A(j,394)%j+A(j,395)%j+A(j,398)%j+A(j,399)%j+A(j,402)%j+A(j,403)%j+A(j,406)%j+A(j,407)%j+A(j,409)%j+A(j,413)%j &
       +A(j,417)%j+A(j,421)%j+A(j,425)%j+A(j,427)%j+A(j,429)%j+A(j,431)%j+A(j,433)%j+A(j,435)%j+A(j,437)%j+A(j,439)%j+A(j,441)%j &
       +A(j,445)%j+A(j,449)%j+A(j,453)%j+A(j,457)%j+A(j,459)%j+A(j,461)%j+A(j,463)%j+A(j,465)%j+A(j,467)%j+A(j,469)%j+A(j,471)%j &
       -A(j,498)%j-A(j,499)%j-A(j,502)%j-A(j,503)%j-A(j,506)%j-A(j,507)%j-A(j,510)%j-A(j,511)%j-A(j,514)%j-A(j,515)%j-A(j,518)%j &
       -A(j,519)%j-A(j,522)%j-A(j,523)%j-A(j,526)%j-A(j,527)%j-A(j,530)%j-A(j,531)%j-A(j,534)%j-A(j,535)%j-A(j,538)%j-A(j,539)%j &
       -A(j,542)%j-A(j,543)%j-A(j,546)%j-A(j,547)%j-A(j,550)%j-A(j,551)%j-A(j,554)%j-A(j,555)%j-A(j,558)%j-A(j,559)%j-A(j,562)%j &
       -A(j,563)%j-A(j,566)%j-A(j,567)%j-A(j,569)%j-A(j,573)%j-A(j,577)%j-A(j,581)%j-A(j,585)%j-A(j,587)%j-A(j,589)%j-A(j,590)%j &
       -A(j,593)%j-A(j,595)%j-A(j,597)%j-A(j,598)%j-A(j,601)%j-A(j,605)%j-A(j,609)%j-A(j,613)%j-A(j,617)%j-A(j,619)%j-A(j,621)%j &
       -A(j,622)%j-A(j,625)%j-A(j,627)%j-A(j,629)%j-A(j,630)%j-A(j,657)%j-A(j,661)%j-A(j,665)%j-A(j,669)%j-A(j,673)%j-A(j,675)%j &
       -A(j,677)%j-A(j,679)%j-A(j,681)%j-A(j,683)%j-A(j,685)%j-A(j,687)%j-A(j,689)%j-A(j,693)%j-A(j,697)%j-A(j,701)%j-A(j,705)%j &
       -A(j,707)%j-A(j,709)%j-A(j,711)%j-A(j,713)%j-A(j,715)%j-A(j,717)%j-A(j,719)%j+A(j,745)%j+A(j,749)%j+A(j,753)%j+A(j,757)%j &
       +A(j,761)%j+A(j,763)%j+A(j,765)%j+A(j,766)%j+A(j,769)%j+A(j,771)%j+A(j,773)%j+A(j,774)%j+A(j,777)%j+A(j,781)%j+A(j,785)%j &
       +A(j,789)%j+A(j,793)%j+A(j,795)%j+A(j,797)%j+A(j,798)%j+A(j,801)%j+A(j,803)%j+A(j,805)%j+A(j,806)%j)*f(10)+(A(j,340)%j &
       +A(j,344)%j+A(j,348)%j+A(j,352)%j+A(j,356)%j+A(j,360)%j+A(j,364)%j+A(j,368)%j+A(j,372)%j+A(j,376)%j+A(j,380)%j+A(j,384)%j &
       +A(j,388)%j+A(j,392)%j+A(j,396)%j+A(j,400)%j+A(j,404)%j+A(j,408)%j+A(j,410)%j+A(j,411)%j+A(j,414)%j+A(j,415)%j+A(j,418)%j &
       +A(j,419)%j+A(j,422)%j+A(j,423)%j+A(j,426)%j+A(j,428)%j+A(j,430)%j+A(j,432)%j+A(j,434)%j+A(j,436)%j+A(j,438)%j+A(j,440)%j &
       +A(j,442)%j+A(j,443)%j+A(j,446)%j+A(j,447)%j+A(j,450)%j+A(j,451)%j+A(j,454)%j+A(j,455)%j+A(j,458)%j+A(j,460)%j+A(j,462)%j &
       +A(j,464)%j+A(j,466)%j+A(j,468)%j+A(j,470)%j+A(j,472)%j+A(j,473)%j+A(j,475)%j+A(j,477)%j+A(j,479)%j+A(j,481)%j+A(j,483)%j &
       +A(j,485)%j+A(j,487)%j+A(j,489)%j+A(j,491)%j+A(j,493)%j+A(j,495)%j-A(j,500)%j-A(j,504)%j-A(j,508)%j-A(j,512)%j-A(j,516)%j &
       -A(j,520)%j-A(j,524)%j-A(j,528)%j-A(j,532)%j-A(j,536)%j-A(j,540)%j-A(j,544)%j-A(j,548)%j-A(j,552)%j-A(j,556)%j-A(j,560)%j &
       -A(j,564)%j-A(j,568)%j-A(j,570)%j-A(j,571)%j-A(j,574)%j-A(j,575)%j-A(j,578)%j-A(j,579)%j-A(j,582)%j-A(j,583)%j-A(j,586)%j &
       -A(j,588)%j-A(j,591)%j-A(j,592)%j-A(j,594)%j-A(j,596)%j-A(j,599)%j-A(j,600)%j-A(j,602)%j-A(j,603)%j-A(j,606)%j-A(j,607)%j &
       -A(j,610)%j-A(j,611)%j-A(j,614)%j-A(j,615)%j-A(j,618)%j-A(j,620)%j-A(j,623)%j-A(j,624)%j-A(j,626)%j-A(j,628)%j-A(j,631)%j &
       -A(j,632)%j-A(j,633)%j-A(j,635)%j-A(j,637)%j-A(j,639)%j-A(j,641)%j-A(j,643)%j-A(j,645)%j-A(j,646)%j-A(j,649)%j-A(j,651)%j &
       -A(j,653)%j-A(j,654)%j-A(j,658)%j-A(j,659)%j-A(j,662)%j-A(j,663)%j-A(j,666)%j-A(j,667)%j-A(j,670)%j-A(j,671)%j-A(j,674)%j &
       -A(j,676)%j-A(j,678)%j-A(j,680)%j-A(j,682)%j-A(j,684)%j-A(j,686)%j-A(j,688)%j-A(j,690)%j-A(j,691)%j-A(j,694)%j-A(j,695)%j &
       -A(j,698)%j-A(j,699)%j-A(j,702)%j-A(j,703)%j-A(j,706)%j-A(j,708)%j-A(j,710)%j-A(j,712)%j-A(j,714)%j-A(j,716)%j-A(j,718)%j &
       -A(j,720)%j-A(j,721)%j-A(j,723)%j-A(j,725)%j-A(j,727)%j-A(j,729)%j-A(j,731)%j-A(j,733)%j-A(j,735)%j-A(j,737)%j-A(j,739)%j &
       -A(j,741)%j-A(j,743)%j+A(j,746)%j+A(j,747)%j+A(j,750)%j+A(j,751)%j+A(j,754)%j+A(j,755)%j+A(j,758)%j+A(j,759)%j+A(j,762)%j &
       +A(j,764)%j+A(j,767)%j+A(j,768)%j+A(j,770)%j+A(j,772)%j+A(j,775)%j+A(j,776)%j+A(j,778)%j+A(j,779)%j+A(j,782)%j+A(j,783)%j &
       +A(j,786)%j+A(j,787)%j+A(j,790)%j+A(j,791)%j+A(j,794)%j+A(j,796)%j+A(j,799)%j+A(j,800)%j+A(j,802)%j+A(j,804)%j+A(j,807)%j &
       +A(j,808)%j+A(j,809)%j+A(j,811)%j+A(j,813)%j+A(j,815)%j+A(j,817)%j+A(j,819)%j+A(j,821)%j+A(j,822)%j+A(j,825)%j+A(j,827)%j &
       +A(j,829)%j+A(j,830)%j+A(j,833)%j+A(j,835)%j+A(j,837)%j+A(j,838)%j-A(j,841)%j-A(j,843)%j-A(j,845)%j-A(j,846)%j-A(j,849)%j &
       -A(j,851)%j+A(j,853)%j+A(j,855)%j+A(j,857)%j+A(j,858)%j-A(j,861)%j-A(j,862)%j+A(j,865)%j+A(j,867)%j-A(j,869)%j-A(j,871)%j &
       +A(j,873)%j+A(j,875)%j-A(j,877)%j-A(j,878)%j+A(j,881)%j+A(j,883)%j-A(j,885)%j-A(j,887)%j-A(j,889)%j-A(j,891)%j+A(j,893)%j &
       +A(j,894)%j)*f(11)+(A(j,412)%j+A(j,416)%j+A(j,420)%j+A(j,424)%j+A(j,444)%j+A(j,448)%j+A(j,452)%j+A(j,456)%j+A(j,474)%j &
       +A(j,476)%j+A(j,478)%j+A(j,480)%j+A(j,482)%j+A(j,484)%j+A(j,486)%j+A(j,488)%j+A(j,490)%j+A(j,492)%j+A(j,494)%j+A(j,496)%j &
       -A(j,572)%j-A(j,576)%j-A(j,580)%j-A(j,584)%j-A(j,604)%j-A(j,608)%j-A(j,612)%j-A(j,616)%j-A(j,634)%j-A(j,636)%j-A(j,638)%j &
       -A(j,640)%j-A(j,642)%j-A(j,644)%j-A(j,647)%j-A(j,648)%j-A(j,650)%j-A(j,652)%j-A(j,655)%j-A(j,656)%j-A(j,660)%j-A(j,664)%j &
       -A(j,668)%j-A(j,672)%j-A(j,692)%j-A(j,696)%j-A(j,700)%j-A(j,704)%j-A(j,722)%j-A(j,724)%j-A(j,726)%j-A(j,728)%j-A(j,730)%j &
       -A(j,732)%j-A(j,734)%j-A(j,736)%j-A(j,738)%j-A(j,740)%j-A(j,742)%j-A(j,744)%j+A(j,748)%j+A(j,752)%j+A(j,756)%j+A(j,760)%j &
       +A(j,780)%j+A(j,784)%j+A(j,788)%j+A(j,792)%j+A(j,810)%j+A(j,812)%j+A(j,814)%j+A(j,816)%j+A(j,818)%j+A(j,820)%j+A(j,823)%j &
       +A(j,824)%j+A(j,826)%j+A(j,828)%j+A(j,831)%j+A(j,832)%j+A(j,834)%j+A(j,836)%j+A(j,839)%j+A(j,840)%j-A(j,842)%j-A(j,844)%j &
       -A(j,847)%j-A(j,848)%j-A(j,850)%j-A(j,852)%j+A(j,854)%j+A(j,856)%j+A(j,859)%j+A(j,860)%j-A(j,863)%j-A(j,864)%j+A(j,866)%j &
       +A(j,868)%j-A(j,870)%j-A(j,872)%j+A(j,874)%j+A(j,876)%j-A(j,879)%j-A(j,880)%j+A(j,882)%j+A(j,884)%j-A(j,886)%j-A(j,888)%j &
       -A(j,890)%j-A(j,892)%j+A(j,895)%j+A(j,896)%j)*f(12)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pplllla_eeexexddxa_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 1
      do j = 1, 1
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pplllla_eeexexddxa_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mct(1)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 1
    do j = 1, 1
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+1*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_pplllla_eeexexddxa_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2IRadd(29)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 30-1
    colmatpos = 1*k
    do i = 1, 1
      do j = 1, 1
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pplllla_eeexexddxa_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_pplllla_eeexexddxa_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(1)
  type(Hpolcont), intent(out)  :: M0_col(1)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 1 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 1 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+1*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_pplllla_eeexexddxa_1_/**/REALKIND
