
module ol_colourmatrix_pplllla_nexnmemxbbxag_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(38,1)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [  12]
  K1( 2,:) = [   0]
  K1( 3,:) = [   0]
  K1( 4,:) = [   0]
  K1( 5,:) = [   0]
  K1( 6,:) = [   0]
  K1( 7,:) = [   0]
  K1( 8,:) = [   0]
  K1( 9,:) = [   0]
  K1(10,:) = [   0]
  K1(11,:) = [   0]
  K1(12,:) = [   0]
  K1(13,:) = [   0]
  K1(14,:) = [   0]
  K1(15,:) = [   0]
  K1(16,:) = [  16]
  K1(17,:) = [   0]
  K1(18,:) = [   0]
  K1(19,:) = [   0]
  K1(20,:) = [   0]
  K1(21,:) = [   2]
  K1(22,:) = [  16]
  K1(23,:) = [   0]
  K1(24,:) = [   0]
  K1(25,:) = [   0]
  K1(26,:) = [   0]
  K1(27,:) = [   0]
  K1(28,:) = [   0]
  K1(29,:) = [   0]
  K1(30,:) = [   0]
  K1(31,:) = [   0]
  K1(32,:) = [   0]
  K1(33,:) = [   0]
  K1(34,:) = [ -18]
  K1(35,:) = [ -18]
  K1(36,:) = [   0]
  K1(37,:) = [  36]
  K1(38,:) = [   0]
  K1 = (1._/**/REALKIND / 3) * K1


  end subroutine colourmatrix_init
end module ol_colourmatrix_pplllla_nexnmemxbbxag_1_/**/REALKIND



module ol_forced_parameters_pplllla_nexnmemxbbxag_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (MM /= 0) write(*,101) 'MM = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pplllla_nexnmemxbbxag_1_/**/REALKIND

module ol_tree_pplllla_nexnmemxbbxag_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  implicit none
  integer,           save :: factors_status = -1
  complex(REALKIND), save :: f(10)
  complex(REALKIND), save :: den(280)
#ifdef PRECISION_dp
  integer(intkind1), save :: ntry = 1
  integer(intkind2), parameter :: nheltot = 256 ! number of helicity configurations
  integer(intkind2), save :: nhel = 256 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(256) ! physical helicity states
  complex(DREALKIND) :: M1helarr(1,256) ! cache
#endif

  contains

subroutine factors_init()
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND, only: loop_parameters_status
  implicit none
  factors_status = parameters_status
  ! factors of the diagrams
    f( 1) = (CI*eQED**5*gQCD)/(12._/**/REALKIND*sw**4)
    f( 2) = (CI*eQED**5*gQCD)/(6._/**/REALKIND*sw**4)
    f( 3) = (CI*eQED**5*gQCD)/(4._/**/REALKIND*sw**4)
    f( 4) = (CI*eQED**5*gQCD*MB)/(12._/**/REALKIND*sw**4)
    f( 5) = (CI*eQED**5*gQCD*MB)/(4._/**/REALKIND*sw**4)
    f( 6) = (CI*cw*eQED**5*gQCD)/(6._/**/REALKIND*sw**3)
    f( 7) = (CI*cw*eQED**5*gQCD)/(2._/**/REALKIND*sw**3)
    f( 8) = (CI*eQED**5*gQCD)/(18._/**/REALKIND*sw**2)
    f( 9) = (CI*eQED**5*gQCD)/(6._/**/REALKIND*sw**2)
    f(10) = (CI*eQED**5*gQCD)/(2._/**/REALKIND*sw**2)

end subroutine factors_init


subroutine born_denominators_init()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none

  ! propagators

  den(1) = 1 /((L(5,144) - MB2)+L(6,144))
  den(2) = 1 /((L(5,5) - MW2)+L(6,5))
  den(3) = 1 /((L(5,10) - MW2)+L(6,10))
  den(5) = 1 /((L(5,176))+L(6,176))
  den(8) = 1 /((L(5,176) - MZ2)+L(6,176))
  den(11) = 1 /((L(5,160) - MB2)+L(6,160))
  den(16) = 1 /((L(5,80) - MB2)+L(6,80))
  den(18) = 1 /((L(5,15) - MH2)+L(6,15))
  den(21) = 1 /((L(5,15))+L(6,15))
  den(24) = 1 /((L(5,15) - MZ2)+L(6,15))
  den(29) = 1 /((L(5,165) - MT2)+L(6,165))
  den(32) = 1 /((L(5,37) - MT2)+L(6,37))
  den(34) = 1 /((L(5,208) - MB2)+L(6,208))
  den(38) = 1 /((L(5,90) - MT2)+L(6,90))
  den(44) = 1 /((L(5,96) - MB2)+L(6,96))
  den(51) = 1 /((L(5,101) - MT2)+L(6,101))
  den(54) = 1 /((L(5,26) - MT2)+L(6,26))
  den(57) = 1 /((L(5,224) - MB2)+L(6,224))
  den(64) = 1 /((L(5,74) - MW2)+L(6,74))
  den(70) = 1 /((L(5,154) - MT2)+L(6,154))
  den(73) = 1 /((L(5,176) - MH2)+L(6,176))
  den(75) = 1 /((L(5,69) - MW2)+L(6,69))
  den(123) = 1 /((L(5,7))+L(6,7))
  den(125) = 1 /((L(5,72))+L(6,72))
  den(137) = 1 /((L(5,77))+L(6,77))
  den(149) = 1 /((L(5,240))+L(6,240))
  den(152) = 1 /((L(5,240) - MZ2)+L(6,240))
  den(155) = 1 /((L(5,13))+L(6,13))
  den(174) = 1 /((L(5,184))+L(6,184))
  den(180) = 1 /((L(5,178))+L(6,178))
  den(183) = 1 /((L(5,71))+L(6,71))
  den(198) = 1 /((L(5,11))+L(6,11))
  den(200) = 1 /((L(5,68))+L(6,68))
  den(211) = 1 /((L(5,78))+L(6,78))
  den(226) = 1 /((L(5,14))+L(6,14))
  den(243) = 1 /((L(5,180))+L(6,180))
  den(249) = 1 /((L(5,177))+L(6,177))
  den(252) = 1 /((L(5,75))+L(6,75))

  ! denominators

  den(4) = den(2)*den(3)
  den(6) = den(1)*den(5)
  den(7) = den(4)*den(6)
  den(9) = den(1)*den(8)
  den(10) = den(4)*den(9)
  den(12) = den(5)*den(11)
  den(13) = den(4)*den(12)
  den(14) = den(8)*den(11)
  den(15) = den(4)*den(14)
  den(17) = den(11)*den(16)
  den(19) = den(4)*den(18)
  den(20) = den(17)*den(19)
  den(22) = den(4)*den(21)
  den(23) = den(17)*den(22)
  den(25) = den(4)*den(24)
  den(26) = den(17)*den(25)
  den(27) = den(2)*den(11)
  den(28) = den(3)*den(16)
  den(30) = den(27)*den(29)
  den(31) = den(28)*den(30)
  den(33) = den(2)*den(32)
  den(35) = den(16)*den(34)
  den(36) = den(3)*den(33)
  den(37) = den(35)*den(36)
  den(39) = den(28)*den(38)
  den(40) = den(33)*den(39)
  den(41) = den(19)*den(35)
  den(42) = den(22)*den(35)
  den(43) = den(25)*den(35)
  den(45) = den(1)*den(44)
  den(46) = den(19)*den(45)
  den(47) = den(22)*den(45)
  den(48) = den(25)*den(45)
  den(49) = den(2)*den(44)
  den(50) = den(1)*den(3)
  den(52) = den(49)*den(51)
  den(53) = den(50)*den(52)
  den(55) = den(3)*den(54)
  den(56) = den(52)*den(55)
  den(58) = den(44)*den(57)
  den(59) = den(2)*den(55)
  den(60) = den(58)*den(59)
  den(61) = den(19)*den(58)
  den(62) = den(22)*den(58)
  den(63) = den(25)*den(58)
  den(65) = den(3)*den(64)
  den(66) = den(1)*den(33)
  den(67) = den(65)*den(66)
  den(68) = den(1)*den(34)
  den(69) = den(36)*den(68)
  den(71) = den(50)*den(70)
  den(72) = den(33)*den(71)
  den(74) = den(1)*den(73)
  den(76) = den(2)*den(75)
  den(77) = den(3)*den(74)
  den(78) = den(76)*den(77)
  den(79) = den(3)*den(6)
  den(80) = den(76)*den(79)
  den(81) = den(3)*den(9)
  den(82) = den(76)*den(81)
  den(83) = den(71)*den(76)
  den(84) = den(2)*den(74)
  den(85) = den(65)*den(84)
  den(86) = den(2)*den(6)
  den(87) = den(65)*den(86)
  den(88) = den(2)*den(9)
  den(89) = den(65)*den(88)
  den(90) = den(19)*den(68)
  den(91) = den(22)*den(68)
  den(92) = den(25)*den(68)
  den(93) = den(11)*den(55)
  den(94) = den(76)*den(93)
  den(95) = den(11)*den(73)
  den(96) = den(3)*den(95)
  den(97) = den(76)*den(96)
  den(98) = den(3)*den(12)
  den(99) = den(76)*den(98)
  den(100) = den(3)*den(14)
  den(101) = den(76)*den(100)
  den(102) = den(30)*den(55)
  den(103) = den(11)*den(57)
  den(104) = den(59)*den(103)
  den(105) = den(2)*den(95)
  den(106) = den(65)*den(105)
  den(107) = den(2)*den(12)
  den(108) = den(65)*den(107)
  den(109) = den(2)*den(14)
  den(110) = den(65)*den(109)
  den(111) = den(30)*den(65)
  den(112) = den(19)*den(103)
  den(113) = den(22)*den(103)
  den(114) = den(25)*den(103)
  den(115) = den(38)*den(55)
  den(116) = den(33)*den(115)
  den(117) = den(33)*den(51)
  den(118) = den(55)*den(117)
  den(119) = den(38)*den(65)
  den(120) = den(33)*den(119)
  den(121) = den(51)*den(76)
  den(122) = den(55)*den(121)
  den(124) = den(2)*den(123)
  den(126) = den(124)*den(125)
  den(127) = den(6)*den(126)
  den(128) = den(9)*den(126)
  den(129) = den(64)*den(125)
  den(130) = den(1)*den(129)
  den(131) = den(33)*den(130)
  den(132) = den(2)*den(129)
  den(133) = den(74)*den(132)
  den(134) = den(6)*den(132)
  den(135) = den(9)*den(132)
  den(136) = den(2)*den(125)
  den(138) = den(136)*den(137)
  den(139) = den(9)*den(138)
  den(140) = den(12)*den(126)
  den(141) = den(14)*den(126)
  den(142) = den(30)*den(129)
  den(143) = den(95)*den(132)
  den(144) = den(12)*den(132)
  den(145) = den(14)*den(132)
  den(146) = den(14)*den(138)
  den(147) = den(38)*den(129)
  den(148) = den(33)*den(147)
  den(150) = den(17)*den(149)
  den(151) = den(124)*den(150)
  den(153) = den(17)*den(152)
  den(154) = den(124)*den(153)
  den(156) = den(2)*den(155)
  den(157) = den(153)*den(156)
  den(158) = den(21)*den(124)
  den(159) = den(35)*den(158)
  den(160) = den(24)*den(124)
  den(161) = den(35)*den(160)
  den(162) = den(24)*den(156)
  den(163) = den(35)*den(162)
  den(164) = den(45)*den(149)
  den(165) = den(124)*den(164)
  den(166) = den(45)*den(152)
  den(167) = den(124)*den(166)
  den(168) = den(156)*den(166)
  den(169) = den(58)*den(158)
  den(170) = den(58)*den(160)
  den(171) = den(58)*den(162)
  den(172) = den(68)*den(158)
  den(173) = den(68)*den(160)
  den(175) = den(6)*den(174)
  den(176) = den(124)*den(175)
  den(177) = den(9)*den(174)
  den(178) = den(124)*den(177)
  den(179) = den(68)*den(162)
  den(181) = den(9)*den(180)
  den(182) = den(76)*den(181)
  den(184) = den(76)*den(183)
  den(185) = den(6)*den(184)
  den(186) = den(9)*den(184)
  den(187) = den(103)*den(158)
  den(188) = den(103)*den(160)
  den(189) = den(12)*den(174)
  den(190) = den(124)*den(189)
  den(191) = den(14)*den(174)
  den(192) = den(124)*den(191)
  den(193) = den(103)*den(162)
  den(194) = den(14)*den(180)
  den(195) = den(76)*den(194)
  den(196) = den(12)*den(184)
  den(197) = den(14)*den(184)
  den(199) = den(3)*den(198)
  den(201) = den(199)*den(200)
  den(202) = den(6)*den(201)
  den(203) = den(9)*den(201)
  den(204) = den(75)*den(200)
  den(205) = den(71)*den(204)
  den(206) = den(3)*den(204)
  den(207) = den(74)*den(206)
  den(208) = den(6)*den(206)
  den(209) = den(9)*den(206)
  den(210) = den(3)*den(200)
  den(212) = den(210)*den(211)
  den(213) = den(9)*den(212)
  den(214) = den(12)*den(201)
  den(215) = den(14)*den(201)
  den(216) = den(55)*den(204)
  den(217) = den(11)*den(216)
  den(218) = den(95)*den(206)
  den(219) = den(12)*den(206)
  den(220) = den(14)*den(206)
  den(221) = den(14)*den(212)
  den(222) = den(51)*den(204)
  den(223) = den(55)*den(222)
  den(224) = den(150)*den(199)
  den(225) = den(153)*den(199)
  den(227) = den(3)*den(226)
  den(228) = den(153)*den(227)
  den(229) = den(21)*den(199)
  den(230) = den(35)*den(229)
  den(231) = den(24)*den(199)
  den(232) = den(35)*den(231)
  den(233) = den(24)*den(227)
  den(234) = den(35)*den(233)
  den(235) = den(164)*den(199)
  den(236) = den(166)*den(199)
  den(237) = den(166)*den(227)
  den(238) = den(58)*den(229)
  den(239) = den(58)*den(231)
  den(240) = den(58)*den(233)
  den(241) = den(68)*den(229)
  den(242) = den(68)*den(231)
  den(244) = den(6)*den(243)
  den(245) = den(199)*den(244)
  den(246) = den(9)*den(243)
  den(247) = den(199)*den(246)
  den(248) = den(68)*den(233)
  den(250) = den(9)*den(249)
  den(251) = den(65)*den(250)
  den(253) = den(65)*den(252)
  den(254) = den(6)*den(253)
  den(255) = den(9)*den(253)
  den(256) = den(103)*den(229)
  den(257) = den(103)*den(231)
  den(258) = den(12)*den(243)
  den(259) = den(199)*den(258)
  den(260) = den(14)*den(243)
  den(261) = den(199)*den(260)
  den(262) = den(103)*den(233)
  den(263) = den(14)*den(249)
  den(264) = den(65)*den(263)
  den(265) = den(12)*den(253)
  den(266) = den(14)*den(253)
  den(267) = den(183)*den(204)
  den(268) = den(6)*den(267)
  den(269) = den(9)*den(267)
  den(270) = den(181)*den(204)
  den(271) = den(12)*den(267)
  den(272) = den(14)*den(267)
  den(273) = den(194)*den(204)
  den(274) = den(129)*den(252)
  den(275) = den(6)*den(274)
  den(276) = den(9)*den(274)
  den(277) = den(129)*den(250)
  den(278) = den(12)*den(274)
  den(279) = den(14)*den(274)
  den(280) = den(129)*den(263)

end subroutine born_denominators_init


! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M2, I, MOM, nextcombs, extcombs, M2munu) &
    & bind(c,name="ol_f_amp2_pplllla_nexnmemxbbxag_1")
#else
subroutine amp2(P_scatt, M2, I, MOM, nextcombs, extcombs, M2munu)
  use ol_tree_pplllla_nexnmemxbbxag_1_/**/DREALKIND, only: &
    & ntry, nhel, Hel, M1helarr
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for anti-nu_e nu_mu e- mu+ bottom anti-bottom gamma glue -> 0
! I   = emitter, 0 means none (replace wave function I in the current crossing by the momentum MOM),
!       for I < 0 emitter for PowHeg B^mu,nu
! MOM = external "polarisation vector" for gluon emitter
! nextcombs is the length of the array extcombs
! The elements of the array extcombs specify for which external particle combinations
!   the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
!   i=j=0 -> 0 means no colour insertion.
! M2munu = Spin correlated born squared amplitude in PowHeg format B^mu,nu for emitter -I
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_init, only: tree_parameters_flush
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_momenta_decl_/**/REALKIND, only: L
  use ol_data_types_/**/REALKIND
  use ol_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_h_propagators_/**/REALKIND
  use ol_h_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_h_vertices_/**/REALKIND
  use ol_h_contractions_/**/REALKIND
  use ol_external_pplllla_nexnmemxbbxag_1, only: &
    & external_perm_pplllla_nexnmemxbbxag_1, &
    & external_perm_inv_pplllla_nexnmemxbbxag_1, &
    & extcomb_perm_pplllla_nexnmemxbbxag_1, &
    & average_factor_pplllla_nexnmemxbbxag_1, &
    & photonid_pplllla_nexnmemxbbxag_1
  use ol_external_pplllla_nexnmemxbbxag_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_pplllla_nexnmemxbbxag_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_pplllla_nexnmemxbbxag_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_pplllla_nexnmemxbbxag_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_ew_renormalisation_/**/REALKIND, only: photon_factors
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,8)
  real(REALKIND),  intent(out) :: M2(0:38-1)
  real(REALKIND),  intent(out) :: M2munu(4,4)
  integer,         intent(in)  :: I
  real(REALKIND),  intent(in)  :: MOM(0:3)
  integer,         intent(in)  :: nextcombs
  integer,         intent(in)  :: extcombs(nextcombs)

  integer           :: ReplacePol, JBmunu, extcombs_permuted(nextcombs), shift, k, r, m, n
  real(REALKIND)    :: P(0:3,8)
  integer           :: extmasses2(8)
  real(REALKIND)    :: M2add(0:38-1)
  complex(REALKIND) :: M2munuadd(2)
  complex(REALKIND) :: MOM_LC(4), M1(1), M1helarray(1,256)
  real(REALKIND)    :: P_scatt_intern(0:3,8)
  complex(REALKIND) :: epLC(1:4), epStd(1:4,2)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0, bornphotonfactor
  integer(intkind1) :: nsync

  ! type(wfun) :: ex1(h1), ex2(h2), ... ! external wave functions for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2), ex7(2), ex8(2)

  ! type(wfun) :: wf<h>(h,n), ... ! n wave functions with h helicity configurations
  type(wfun) :: wf4(4,16), wf8(8,36), wf16(16,97), wf32(32,26), wf64(64,1), wf256(256,150)

  type(polcont) :: A(256,150)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call tree_parameters_flush()
  call ensure_mp_init()

  if (hel_not_initialised) call hel_init()
  if (colmat_not_initialised) call colourmatrix_init()
  if (factors_status /= parameters_status) then
    ! Note: if factors_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because check_forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call factors_init()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M2 = 0
    return
  end if

  extmasses2 = [ 0, 0, 0, 0, nMB, nMB, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
      &  external_perm_inv_pplllla_nexnmemxbbxag_1, 8,.false.)

  ! denominators
  call born_denominators_init()

  ReplacePol = 0
  JBmunu = 0
  if (I > 0) then
    ReplacePol = external_perm_pplllla_nexnmemxbbxag_1(I)
  else if (I < 0) then
    JBmunu = external_perm_pplllla_nexnmemxbbxag_1(-I)
  end if

  do k = 1, nextcombs
    extcombs_permuted(k) = &
       & extcomb_perm_pplllla_nexnmemxbbxag_1(extcombs(k))
  end do

  if (heltables_not_init) call init_heltables()

  42 continue
  ! external WFs
  call pol_wf_A(P(:,1), rZERO, H1, ex1, POLSEL(1))
  call pol_wf_Q(P(:,2), rZERO, H2, ex2, POLSEL(2))
  call pol_wf_Q(P(:,3), rZERO, H3, ex3, POLSEL(3))
  call pol_wf_A(P(:,4), rZERO, H4, ex4, POLSEL(4))
  call pol_wf_Q(P(:,5), rMB, H5, ex5, POLSEL(5))
  call pol_wf_A(P(:,6), rMB, H6, ex6, POLSEL(6))
  call pol_wf_V(P(:,7), rZERO, H7, ex7, POLSEL(7))
  call pol_wf_V(P(:,8), rZERO, H8, ex8, POLSEL(8))


  if (ntry == 1) then
    shift = 1
    ! call helbookkeeping_flip(H1, 1, shift, eflip, exthel, firstpol)
    ! call helbookkeeping_wf(H1, ex1, shift) ...

    if (any(POLSEL /= 0)) then

      call pol_wf_A(P(:,1), rZERO, H1, ex1, 0)
      call pol_wf_Q(P(:,2), rZERO, H2, ex2, 0)
      call pol_wf_Q(P(:,3), rZERO, H3, ex3, 0)
      call pol_wf_A(P(:,4), rZERO, H4, ex4, 0)
      call pol_wf_Q(P(:,5), rMB, H5, ex5, 0)
      call pol_wf_A(P(:,6), rMB, H6, ex6, 0)
      call pol_wf_V(P(:,7), rZERO, H7, ex7, 0)
      call pol_wf_V(P(:,8), rZERO, H8, ex8, 0)

    end if

    call helbookkeeping_flip(H1, 1, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H1, ex1, shift)
    call helbookkeeping_flip(H2, 2, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H2, ex2, shift)
    call helbookkeeping_flip(H3, 3, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H3, ex3, shift)
    call helbookkeeping_flip(H4, 4, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H4, ex4, shift)
    call helbookkeeping_flip(H5, 5, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H5, ex5, shift)
    call helbookkeeping_flip(H6, 6, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H6, ex6, shift)
    call helbookkeeping_flip(H7, 7, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H7, ex7, shift)
    call helbookkeeping_flip(H8, 8, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H8, ex8, shift)

  end if

  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_W(ntry, ex3, ex1, wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_QA_W(ntry, ex2, ex4, wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_VQ_A(ntry, ex8, ex5, wf4(:,3), n3(:,3), t3x4(:,:,3))
  call prop_Q_A(ntry, wf4(:,3), 144, MB, 1_intkind1, wf4(:,4), n2(1))
  call prop_W_W(ntry, wf4(:,1), 5, MW, 1_intkind1, wf4(:,5), n2(2))
  call prop_W_W(ntry, wf4(:,2), 10, MW, 1_intkind1, wf4(:,6), n2(3))
  call vert_QA_V(ntry, wf4(:,4), ex6, wf8(:,1), n3(:,4), t3x8(:,:,1))
  call vert_WWV_V(ntry, wf4(:,5), wf4(:,6), ex7, wf32(:,1), n4(:,1), t4x32(:,:,1))
  call vert_QA_Z(gZd,ntry, wf4(:,4), ex6, wf8(:,2), n3(:,5), t3x8(:,:,2))
  call prop_W_W(ntry, wf8(:,2), 176, MZ, 1_intkind1, wf8(:,3), n2(4))
  call vert_AV_Q(ntry, ex6, ex8, wf4(:,7), n3(:,6), t3x4(:,:,4))
  call prop_A_Q(ntry, wf4(:,7), 160, MB, 1_intkind1, wf4(:,8), n2(5))
  call vert_QA_V(ntry, ex5, wf4(:,8), wf8(:,4), n3(:,7), t3x8(:,:,3))
  call vert_QA_Z(gZd,ntry, ex5, wf4(:,8), wf8(:,5), n3(:,8), t3x8(:,:,4))
  call prop_W_W(ntry, wf8(:,5), 176, MZ, 1_intkind1, wf8(:,6), n2(6))
  call vert_VQ_A(ntry, ex7, ex5, wf4(:,9), n3(:,9), t3x4(:,:,5))
  call prop_Q_A(ntry, wf4(:,9), 80, MB, 1_intkind1, wf4(:,10), n2(7))
  call vert_VV_S(ntry, wf4(:,5), wf4(:,6), wf16(:,1), n3(:,10), t3x16(:,:,1))
  call vert_AQ_S(gH,ntry, wf4(:,8), wf4(:,10), wf16(:,2), n3(:,11), t3x16(:,:,2))
  call vert_UV_W(ntry, wf4(:,6), 10, wf4(:,5), 5, wf16(:,3), n3(:,12), t3x16(:,:,3))
  call vert_QA_V(ntry, wf4(:,10), wf4(:,8), wf16(:,4), n3(:,13), t3x16(:,:,4))
  call vert_QA_Z(gZd,ntry, wf4(:,10), wf4(:,8), wf16(:,5), n3(:,14), t3x16(:,:,5))
  call prop_W_W(ntry, wf16(:,3), 15, MZ, 1_intkind1, wf16(:,6), n2(8))
  call vert_AW_Q(ntry, wf4(:,8), wf4(:,5), wf16(:,7), n3(:,15), t3x16(:,:,6))
  call vert_WQ_A(ntry, wf4(:,6), wf4(:,10), wf16(:,8), n3(:,16), t3x16(:,:,7))
  call prop_A_Q(ntry, wf16(:,7), 165, MT, 1_intkind1, wf16(:,9), n2(9))
  call vert_AW_Q(ntry, ex6, wf4(:,5), wf8(:,7), n3(:,17), t3x8(:,:,5))
  call vert_VQ_A(ntry, ex8, wf4(:,10), wf8(:,8), n3(:,18), t3x8(:,:,6))
  call prop_A_Q(ntry, wf8(:,7), 37, MT, 1_intkind1, wf8(:,9), n2(10))
  call prop_Q_A(ntry, wf8(:,8), 208, MB, 1_intkind1, wf8(:,10), n2(11))
  call vert_AW_Q(ntry, wf8(:,9), wf4(:,6), wf32(:,2), n3(:,19), t3x32(:,:,1))
  call prop_Q_A(ntry, wf16(:,8), 90, MT, 1_intkind1, wf16(:,10), n2(12))
  call vert_AV_Q(ntry, wf8(:,9), ex8, wf16(:,11), n3(:,20), t3x16(:,:,8))
  call vert_AQ_S(gH,ntry, ex6, wf8(:,10), wf16(:,12), n3(:,21), t3x16(:,:,9))
  call vert_QA_V(ntry, wf8(:,10), ex6, wf16(:,13), n3(:,22), t3x16(:,:,10))
  call vert_QA_Z(gZd,ntry, wf8(:,10), ex6, wf16(:,14), n3(:,23), t3x16(:,:,11))
  call vert_AV_Q(ntry, ex6, ex7, wf4(:,11), n3(:,24), t3x4(:,:,6))
  call prop_A_Q(ntry, wf4(:,11), 96, MB, 1_intkind1, wf4(:,12), n2(13))
  call vert_AQ_S(gH,ntry, wf4(:,12), wf4(:,4), wf16(:,15), n3(:,25), t3x16(:,:,12))
  call vert_QA_V(ntry, wf4(:,4), wf4(:,12), wf16(:,16), n3(:,26), t3x16(:,:,13))
  call vert_QA_Z(gZd,ntry, wf4(:,4), wf4(:,12), wf16(:,17), n3(:,27), t3x16(:,:,14))
  call vert_AW_Q(ntry, wf4(:,12), wf4(:,5), wf16(:,18), n3(:,28), t3x16(:,:,15))
  call vert_WQ_A(ntry, wf4(:,6), wf4(:,4), wf16(:,19), n3(:,29), t3x16(:,:,16))
  call prop_A_Q(ntry, wf16(:,18), 101, MT, 1_intkind1, wf16(:,20), n2(14))
  call vert_WQ_A(ntry, wf4(:,6), ex5, wf8(:,11), n3(:,30), t3x8(:,:,7))
  call prop_Q_A(ntry, wf8(:,11), 26, MT, 1_intkind1, wf8(:,12), n2(15))
  call vert_VQ_A(ntry, ex8, wf8(:,12), wf16(:,21), n3(:,31), t3x16(:,:,17))
  call vert_AV_Q(ntry, wf4(:,12), ex8, wf8(:,13), n3(:,32), t3x8(:,:,8))
  call prop_A_Q(ntry, wf8(:,13), 224, MB, 1_intkind1, wf8(:,14), n2(16))
  call vert_WQ_A(ntry, wf4(:,5), wf8(:,12), wf32(:,3), n3(:,33), t3x32(:,:,2))
  call vert_AQ_S(gH,ntry, wf8(:,14), ex5, wf16(:,22), n3(:,34), t3x16(:,:,18))
  call vert_QA_V(ntry, ex5, wf8(:,14), wf16(:,23), n3(:,35), t3x16(:,:,19))
  call vert_QA_Z(gZd,ntry, ex5, wf8(:,14), wf16(:,24), n3(:,36), t3x16(:,:,20))
  call vert_UV_W(ntry, ex7, 64, wf4(:,6), 10, wf8(:,15), n3(:,37), t3x8(:,:,9))
  call prop_W_W(ntry, wf8(:,15), 74, MW, 1_intkind1, wf8(:,16), n2(17))
  call vert_QA_W(ntry, wf4(:,4), wf8(:,9), wf32(:,4), n3(:,38), t3x32(:,:,3))
  call vert_VQ_A(ntry, ex7, wf4(:,4), wf8(:,17), n3(:,39), t3x8(:,:,10))
  call prop_Q_A(ntry, wf8(:,17), 208, MB, 1_intkind1, wf8(:,18), n2(18))
  call prop_Q_A(ntry, wf16(:,19), 154, MT, 1_intkind1, wf16(:,25), n2(19))
  call vert_AV_Q(ntry, wf8(:,9), ex7, wf16(:,26), n3(:,40), t3x16(:,:,21))
  call vert_AQ_S(gH,ntry, ex6, wf4(:,4), wf8(:,19), n3(:,41), t3x8(:,:,11))
  call vert_UV_W(ntry, wf4(:,5), 5, ex7, 64, wf8(:,20), n3(:,42), t3x8(:,:,12))
  call prop_W_W(ntry, wf8(:,20), 69, MW, 1_intkind1, wf8(:,21), n2(20))
  call vert_SV_V(ntry, wf8(:,19), wf4(:,6), wf32(:,5), n3(:,43), t3x32(:,:,4))
  call vert_UV_W(ntry, wf8(:,1), 176, wf4(:,6), 10, wf32(:,6), n3(:,44), t3x32(:,:,5))
  call vert_UV_W(ntry, wf8(:,3), 176, wf4(:,6), 10, wf32(:,7), n3(:,45), t3x32(:,:,6))
  call vert_AW_Q(ntry, ex6, wf8(:,21), wf16(:,27), n3(:,46), t3x16(:,:,22))
  call vert_SV_V(ntry, wf8(:,19), wf4(:,5), wf32(:,8), n3(:,47), t3x32(:,:,7))
  call vert_UV_W(ntry, wf4(:,5), 5, wf8(:,1), 176, wf32(:,9), n3(:,48), t3x32(:,:,8))
  call vert_UV_W(ntry, wf4(:,5), 5, wf8(:,3), 176, wf32(:,10), n3(:,49), t3x32(:,:,9))
  call vert_AQ_S(gH,ntry, ex6, wf8(:,18), wf16(:,28), n3(:,50), t3x16(:,:,23))
  call vert_QA_V(ntry, wf8(:,18), ex6, wf16(:,29), n3(:,51), t3x16(:,:,24))
  call vert_QA_Z(gZd,ntry, wf8(:,18), ex6, wf16(:,30), n3(:,52), t3x16(:,:,25))
  call vert_QA_W(ntry, wf8(:,12), wf4(:,8), wf32(:,11), n3(:,53), t3x32(:,:,10))
  call vert_AQ_S(gH,ntry, wf4(:,8), ex5, wf8(:,22), n3(:,54), t3x8(:,:,13))
  call vert_SV_V(ntry, wf8(:,22), wf4(:,6), wf32(:,12), n3(:,55), t3x32(:,:,11))
  call vert_UV_W(ntry, wf8(:,4), 176, wf4(:,6), 10, wf32(:,13), n3(:,56), t3x32(:,:,12))
  call vert_UV_W(ntry, wf8(:,6), 176, wf4(:,6), 10, wf32(:,14), n3(:,57), t3x32(:,:,13))
  call vert_VQ_A(ntry, ex7, wf8(:,12), wf16(:,31), n3(:,58), t3x16(:,:,26))
  call vert_AV_Q(ntry, wf4(:,8), ex7, wf8(:,23), n3(:,59), t3x8(:,:,14))
  call prop_A_Q(ntry, wf8(:,23), 224, MB, 1_intkind1, wf8(:,24), n2(21))
  call vert_SV_V(ntry, wf8(:,22), wf4(:,5), wf32(:,15), n3(:,60), t3x32(:,:,14))
  call vert_UV_W(ntry, wf4(:,5), 5, wf8(:,4), 176, wf32(:,16), n3(:,61), t3x32(:,:,15))
  call vert_UV_W(ntry, wf4(:,5), 5, wf8(:,6), 176, wf32(:,17), n3(:,62), t3x32(:,:,16))
  call vert_WQ_A(ntry, wf8(:,16), ex5, wf16(:,32), n3(:,63), t3x16(:,:,27))
  call vert_AQ_S(gH,ntry, wf8(:,24), ex5, wf16(:,33), n3(:,64), t3x16(:,:,28))
  call vert_QA_V(ntry, ex5, wf8(:,24), wf16(:,34), n3(:,65), t3x16(:,:,29))
  call vert_QA_Z(gZd,ntry, ex5, wf8(:,24), wf16(:,35), n3(:,66), t3x16(:,:,30))
  call prop_Q_A(ntry, wf16(:,31), 90, MT, 1_intkind1, wf16(:,36), n2(22))
  call prop_A_Q(ntry, wf16(:,26), 101, MT, 1_intkind1, wf16(:,37), n2(23))
  call prop_Q_A(ntry, wf16(:,32), 90, MT, 1_intkind1, wf16(:,38), n2(24))
  call prop_A_Q(ntry, wf16(:,27), 101, MT, 1_intkind1, wf16(:,39), n2(25))
  call vert_AV_Q(ntry, ex4, ex7, wf4(:,13), n3(:,67), t3x4(:,:,7))
  call vert_WQ_A(ntry, wf4(:,5), ex2, wf8(:,25), n3(:,68), t3x8(:,:,15))
  call prop_Q_A(ntry, wf8(:,25), 7, ZERO, 0_intkind1, wf8(:,26), n2(26))
  call prop_A_Q(ntry, wf4(:,13), 72, ZERO, 0_intkind1, wf4(:,14), n2(27))
  call vert_QA_V(ntry, wf8(:,26), wf4(:,14), wf32(:,18), n3(:,69), t3x32(:,:,17))
  call vert_QA_Z(gZl,ntry, wf8(:,26), wf4(:,14), wf32(:,19), n3(:,70), t3x32(:,:,18))
  call vert_QA_W(ntry, ex2, wf4(:,14), wf8(:,27), n3(:,71), t3x8(:,:,16))
  call prop_W_W(ntry, wf8(:,27), 74, MW, 1_intkind1, wf8(:,28), n2(28))
  call vert_WQ_A(ntry, wf8(:,28), wf4(:,4), wf32(:,20), n3(:,72), t3x32(:,:,19))
  call vert_VV_S(ntry, wf4(:,5), wf8(:,28), wf32(:,21), n3(:,73), t3x32(:,:,20))
  call vert_UV_W(ntry, wf8(:,28), 74, wf4(:,5), 5, wf32(:,22), n3(:,74), t3x32(:,:,21))
  call vert_AW_Q(ntry, wf4(:,14), wf4(:,5), wf16(:,40), n3(:,75), t3x16(:,:,31))
  call prop_A_Q(ntry, wf16(:,40), 77, ZERO, 0_intkind1, wf16(:,41), n2(29))
  call vert_ZQ_A(gZn,ntry, wf8(:,3), ex2, wf16(:,42), n3(:,76), t3x16(:,:,32))
  call vert_WQ_A(ntry, wf8(:,28), ex5, wf16(:,43), n3(:,77), t3x16(:,:,33))
  call vert_ZQ_A(gZn,ntry, wf8(:,6), ex2, wf16(:,44), n3(:,78), t3x16(:,:,34))
  call prop_Q_A(ntry, wf16(:,43), 90, MT, 1_intkind1, wf16(:,45), n2(30))
  call vert_QA_V(ntry, wf8(:,26), ex4, wf16(:,46), n3(:,79), t3x16(:,:,35))
  call prop_W_W(ntry, wf16(:,5), 240, MZ, 1_intkind1, wf16(:,47), n2(31))
  call vert_QA_Z(gZl,ntry, wf8(:,26), ex4, wf16(:,48), n3(:,80), t3x16(:,:,36))
  call vert_AW_Q(ntry, ex4, wf4(:,5), wf8(:,29), n3(:,81), t3x8(:,:,17))
  call prop_A_Q(ntry, wf8(:,29), 13, ZERO, 0_intkind1, wf8(:,30), n2(32))
  call vert_QA_Z(gZn,ntry, ex2, wf8(:,30), wf16(:,49), n3(:,82), t3x16(:,:,37))
  call prop_W_W(ntry, wf16(:,48), 15, MZ, 1_intkind1, wf16(:,50), n2(33))
  call prop_W_W(ntry, wf16(:,49), 15, MZ, 1_intkind1, wf16(:,51), n2(34))
  call prop_W_W(ntry, wf16(:,17), 240, MZ, 1_intkind1, wf16(:,52), n2(35))
  call vert_AV_Q(ntry, ex4, wf8(:,1), wf16(:,53), n3(:,83), t3x16(:,:,38))
  call vert_VQ_A(ntry, ex7, wf8(:,26), wf16(:,54), n3(:,84), t3x16(:,:,39))
  call prop_A_Q(ntry, wf16(:,53), 184, ZERO, 0_intkind1, wf16(:,55), n2(36))
  call vert_AZ_Q(gZl,ntry, ex4, wf8(:,3), wf16(:,56), n3(:,85), t3x16(:,:,40))
  call prop_A_Q(ntry, wf16(:,56), 184, ZERO, 0_intkind1, wf16(:,57), n2(37))
  call vert_AW_Q(ntry, ex4, wf8(:,21), wf16(:,58), n3(:,86), t3x16(:,:,41))
  call prop_Q_A(ntry, wf16(:,42), 178, ZERO, 0_intkind1, wf16(:,59), n2(38))
  call vert_WQ_A(ntry, wf8(:,21), ex2, wf16(:,60), n3(:,87), t3x16(:,:,42))
  call prop_Q_A(ntry, wf16(:,60), 71, ZERO, 0_intkind1, wf16(:,61), n2(39))
  call vert_AV_Q(ntry, ex4, wf8(:,4), wf16(:,62), n3(:,88), t3x16(:,:,43))
  call prop_A_Q(ntry, wf16(:,62), 184, ZERO, 0_intkind1, wf16(:,63), n2(40))
  call vert_AZ_Q(gZl,ntry, ex4, wf8(:,6), wf16(:,64), n3(:,89), t3x16(:,:,44))
  call prop_A_Q(ntry, wf16(:,64), 184, ZERO, 0_intkind1, wf16(:,65), n2(41))
  call prop_Q_A(ntry, wf16(:,44), 178, ZERO, 0_intkind1, wf16(:,66), n2(42))
  call vert_VQ_A(ntry, ex7, ex3, wf4(:,15), n3(:,90), t3x4(:,:,8))
  call vert_AW_Q(ntry, ex1, wf4(:,6), wf8(:,31), n3(:,91), t3x8(:,:,18))
  call prop_A_Q(ntry, wf8(:,31), 11, ZERO, 0_intkind1, wf8(:,32), n2(43))
  call prop_Q_A(ntry, wf4(:,15), 68, ZERO, 0_intkind1, wf4(:,16), n2(44))
  call vert_QA_V(ntry, wf4(:,16), wf8(:,32), wf32(:,23), n3(:,92), t3x32(:,:,22))
  call vert_QA_Z(gZl,ntry, wf4(:,16), wf8(:,32), wf32(:,24), n3(:,93), t3x32(:,:,23))
  call vert_QA_W(ntry, wf4(:,16), ex1, wf8(:,33), n3(:,94), t3x8(:,:,19))
  call prop_W_W(ntry, wf8(:,33), 69, MW, 1_intkind1, wf8(:,34), n2(45))
  call vert_AW_Q(ntry, ex6, wf8(:,34), wf16(:,67), n3(:,95), t3x16(:,:,45))
  call vert_VV_S(ntry, wf4(:,6), wf8(:,34), wf32(:,25), n3(:,96), t3x32(:,:,24))
  call vert_UV_W(ntry, wf4(:,6), 10, wf8(:,34), 69, wf32(:,26), n3(:,97), t3x32(:,:,25))
  call vert_WQ_A(ntry, wf4(:,6), wf4(:,16), wf16(:,68), n3(:,98), t3x16(:,:,46))
  call prop_Q_A(ntry, wf16(:,68), 78, ZERO, 0_intkind1, wf16(:,69), n2(46))
  call vert_AZ_Q(gZn,ntry, ex1, wf8(:,3), wf16(:,70), n3(:,99), t3x16(:,:,47))
  call vert_WQ_A(ntry, wf8(:,34), wf8(:,12), wf64(:,1), n3(:,100), t3x64(:,:,1))
  call vert_AZ_Q(gZn,ntry, ex1, wf8(:,6), wf16(:,71), n3(:,101), t3x16(:,:,48))
  call prop_A_Q(ntry, wf16(:,67), 101, MT, 1_intkind1, wf16(:,72), n2(47))
  call vert_QA_V(ntry, ex3, wf8(:,32), wf16(:,73), n3(:,102), t3x16(:,:,49))
  call vert_QA_Z(gZl,ntry, ex3, wf8(:,32), wf16(:,74), n3(:,103), t3x16(:,:,50))
  call vert_WQ_A(ntry, wf4(:,6), ex3, wf8(:,35), n3(:,104), t3x8(:,:,20))
  call prop_Q_A(ntry, wf8(:,35), 14, ZERO, 0_intkind1, wf8(:,36), n2(48))
  call vert_QA_Z(gZn,ntry, wf8(:,36), ex1, wf16(:,75), n3(:,105), t3x16(:,:,51))
  call prop_W_W(ntry, wf16(:,74), 15, MZ, 1_intkind1, wf16(:,76), n2(49))
  call prop_W_W(ntry, wf16(:,75), 15, MZ, 1_intkind1, wf16(:,77), n2(50))
  call vert_VQ_A(ntry, wf8(:,1), ex3, wf16(:,78), n3(:,106), t3x16(:,:,52))
  call vert_AV_Q(ntry, wf8(:,32), ex7, wf16(:,79), n3(:,107), t3x16(:,:,53))
  call prop_Q_A(ntry, wf16(:,78), 180, ZERO, 0_intkind1, wf16(:,80), n2(51))
  call vert_ZQ_A(gZl,ntry, wf8(:,3), ex3, wf16(:,81), n3(:,108), t3x16(:,:,54))
  call prop_Q_A(ntry, wf16(:,81), 180, ZERO, 0_intkind1, wf16(:,82), n2(52))
  call vert_WQ_A(ntry, wf8(:,16), ex3, wf16(:,83), n3(:,109), t3x16(:,:,55))
  call prop_A_Q(ntry, wf16(:,70), 177, ZERO, 0_intkind1, wf16(:,84), n2(53))
  call vert_AW_Q(ntry, ex1, wf8(:,16), wf16(:,85), n3(:,110), t3x16(:,:,56))
  call prop_A_Q(ntry, wf16(:,85), 75, ZERO, 0_intkind1, wf16(:,86), n2(54))
  call vert_VQ_A(ntry, wf8(:,4), ex3, wf16(:,87), n3(:,111), t3x16(:,:,57))
  call prop_Q_A(ntry, wf16(:,87), 180, ZERO, 0_intkind1, wf16(:,88), n2(55))
  call vert_ZQ_A(gZl,ntry, wf8(:,6), ex3, wf16(:,89), n3(:,112), t3x16(:,:,58))
  call prop_Q_A(ntry, wf16(:,89), 180, ZERO, 0_intkind1, wf16(:,90), n2(56))
  call prop_A_Q(ntry, wf16(:,71), 177, ZERO, 0_intkind1, wf16(:,91), n2(57))
  call vert_WQ_A(ntry, wf8(:,34), ex2, wf16(:,92), n3(:,113), t3x16(:,:,59))
  call prop_Q_A(ntry, wf16(:,92), 71, ZERO, 0_intkind1, wf16(:,93), n2(58))
  call vert_AW_Q(ntry, ex4, wf8(:,34), wf16(:,94), n3(:,114), t3x16(:,:,60))
  call vert_AW_Q(ntry, ex1, wf8(:,28), wf16(:,95), n3(:,115), t3x16(:,:,61))
  call prop_A_Q(ntry, wf16(:,95), 75, ZERO, 0_intkind1, wf16(:,96), n2(59))
  call vert_WQ_A(ntry, wf8(:,28), ex3, wf16(:,97), n3(:,116), t3x16(:,:,62))


  ! colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) then
      call helsync(nsync, A, nhel, Hel)
      call helsync_flip(nsync, nhel, Hel, eflip, exthel)
      if (any(POLSEL /= 0)) then
        ntry = 2
        goto 42
      end if
    end if
  end do

  do k = 1, nhel
    call colourvector(A, k, M1helarray(:,k))
  end do
  M1helarray(:,nhel+1:) = 0
  M1helarr = M1helarray ! fill cache

  M2 = 0
  if (ReplacePol == 0) then ! no helicity correlation

    do k = 1, nhel
      call colint(M1helarray(:,k), M2add, extcombs_permuted)
      M2 = M2 + M2add
    end do

  else ! helicity correlation

    call flip_phase(P(:,ReplacePol), firstpol(ReplacePol), MOM, omega)
    do k = 1, nhel
      M1 = M1helarray(:,k)
      r = eflip(k, ReplacePol) ! Flip helicity of external particle ReplacePol (gluon emitter).
      if (r <= nhel) then      ! Only add flipped helicity configuration if it does not vanish.
        M1 = M1 + omega(exthel(k,ReplacePol)) * M1helarray(:,r)
      end if
      call colint2(M1helarray(:,k), M1, M2add, extcombs_permuted)
      M2 = M2 + M2add
    end do
    M2 = 0.5_/**/REALKIND * M2

  end if

  M2munu = 0
  if ( JBmunu /= 0 ) then ! POWHEGs Bmunu helicity correlation
    P_scatt_intern = P_scatt
    ! get wfs
    call wf_V_Std(P_scatt_intern(:,-I), rZERO, -1, epLC)
    call LC2Std_Rep_cmplx(epLC, epStd(:,1))
    call wf_V_Std(P_scatt_intern(:,-I), rZERO, 1, epLC)
    call LC2Std_Rep_cmplx(epLC, epStd(:,2))

    ! sum over helicities
    do k = 1, nhel
      !same helicity case
      call colintmunu(M1helarray(:,k), M1helarray(:,k), M2munuadd(1))
      !opposite helicity case
      r = eflip(k, JBmunu) ! Flip helicity of external particle JBmunu (gluon emitter).
      if (r <= nhel) then  ! Only add opposite helicity configuration if it does not vanish.
        call colintmunu(M1helarray(:,k), M1helarray(:,r), M2munuadd(2))
      else
        M2munuadd(2) = 0
      end if
      ! Fill B^(mu,nu) = sum_(k) sum_(l1,l2) M^*_(k) M_(k) (eps^(mu)_(l1))^* eps^(nu)_(l2)
      do m = 1,4
        do n = 1,4
          M2munu(m,n) = M2munu(m,n) + M2munuadd(1)*conjg(epStd(m,exthel(k,JBmunu)))*epStd(n,exthel(k,JBmunu))
          if (r <= nhel) then
            M2munu(m,n) = M2munu(m,n) + M2munuadd(2)*conjg(epStd(m,exthel(k,JBmunu)))*epStd(n,exthel(r,JBmunu))
          end if
        end do
      end do
    end do

    M2munu = M2munu / average_factor_pplllla_nexnmemxbbxag_1
  end if

  ! Colour and helicity average and symmetry factor of outgoing particles
  M2add = M2 / average_factor_pplllla_nexnmemxbbxag_1

  do k = 0, 38-1
    M2(k) = M2add(extcomb_perm_pplllla_nexnmemxbbxag_1(k))
  end do

  ! photon-factors
  call photon_factors(photonid_pplllla_nexnmemxbbxag_1, 0, bornphotonfactor)
  M2 = bornphotonfactor * M2
  M2munu = bornphotonfactor * M2munu

  if (ntry == 1) ntry = 2

  if (scalefactor /= old_scalefactor) then
    scalebackfactor = scalefactor**(2*8-8)
    old_scalefactor = scalefactor
  end if
  M2 = scalebackfactor * M2
  M2munu = scalebackfactor * M2munu

  contains

subroutine diagrams()
  implicit none
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call cont_VV(nsync, wf8(:,1), wf32(:,1), A(:,1), n3(:,117), t3x256(:,:,1), nhel, den(7))
    call cont_VV(nsync, wf32(:,1), wf8(:,3), A(:,2), n3(:,118), t3x256(:,:,2), nhel, den(10))
    call cont_VV(nsync, wf32(:,1), wf8(:,4), A(:,3), n3(:,119), t3x256(:,:,3), nhel, den(13))
    call cont_VV(nsync, wf32(:,1), wf8(:,6), A(:,4), n3(:,120), t3x256(:,:,4), nhel, den(15))
    call cont_SS(nsync, wf16(:,1), wf16(:,2), A(:,5), n3(:,121), t3x256(:,:,5), nhel, den(20))
    call cont_VV(nsync, wf16(:,3), wf16(:,4), A(:,6), n3(:,122), t3x256(:,:,6), nhel, den(23))
    call cont_VV(nsync, wf16(:,5), wf16(:,6), A(:,7), n3(:,123), t3x256(:,:,7), nhel, den(26))
    call cont_QA(nsync, wf16(:,8), wf16(:,9), A(:,8), n3(:,124), t3x256(:,:,8), nhel, den(31))
    call cont_QA(nsync, wf8(:,10), wf32(:,2), A(:,9), n3(:,125), t3x256(:,:,9), nhel, den(37))
    call cont_QA(nsync, wf16(:,10), wf16(:,11), A(:,10), n3(:,126), t3x256(:,:,10), nhel, den(40))
    call cont_SS(nsync, wf16(:,1), wf16(:,12), A(:,11), n3(:,127), t3x256(:,:,11), nhel, den(41))
    call cont_VV(nsync, wf16(:,3), wf16(:,13), A(:,12), n3(:,128), t3x256(:,:,12), nhel, den(42))
    call cont_VV(nsync, wf16(:,6), wf16(:,14), A(:,13), n3(:,129), t3x256(:,:,13), nhel, den(43))
    call cont_SS(nsync, wf16(:,1), wf16(:,15), A(:,14), n3(:,130), t3x256(:,:,14), nhel, den(46))
    call cont_VV(nsync, wf16(:,3), wf16(:,16), A(:,15), n3(:,131), t3x256(:,:,15), nhel, den(47))
    call cont_VV(nsync, wf16(:,6), wf16(:,17), A(:,16), n3(:,132), t3x256(:,:,16), nhel, den(48))
    call cont_QA(nsync, wf16(:,19), wf16(:,20), A(:,17), n3(:,133), t3x256(:,:,17), nhel, den(53))
    call cont_QA(nsync, wf16(:,20), wf16(:,21), A(:,18), n3(:,134), t3x256(:,:,18), nhel, den(56))
    call cont_QA(nsync, wf8(:,14), wf32(:,3), A(:,19), n3(:,135), t3x256(:,:,19), nhel, den(60))
    call cont_SS(nsync, wf16(:,1), wf16(:,22), A(:,20), n3(:,136), t3x256(:,:,20), nhel, den(61))
    call cont_VV(nsync, wf16(:,3), wf16(:,23), A(:,21), n3(:,137), t3x256(:,:,21), nhel, den(62))
    call cont_VV(nsync, wf16(:,6), wf16(:,24), A(:,22), n3(:,138), t3x256(:,:,22), nhel, den(63))
    call cont_VV(nsync, wf8(:,16), wf32(:,4), A(:,23), n3(:,139), t3x256(:,:,23), nhel, den(67))
    call cont_QA(nsync, wf32(:,2), wf8(:,18), A(:,24), n3(:,140), t3x256(:,:,24), nhel, den(69))
    call cont_QA(nsync, wf16(:,25), wf16(:,26), A(:,25), n3(:,141), t3x256(:,:,25), nhel, den(72))
    call cont_VV(nsync, wf8(:,21), wf32(:,5), A(:,26), n3(:,142), t3x256(:,:,26), nhel, den(78))
    call cont_VV(nsync, wf8(:,21), wf32(:,6), A(:,27), n3(:,143), t3x256(:,:,27), nhel, den(80))
    call cont_VV(nsync, wf8(:,21), wf32(:,7), A(:,28), n3(:,144), t3x256(:,:,28), nhel, den(82))
    call cont_QA(nsync, wf16(:,25), wf16(:,27), A(:,29), n3(:,145), t3x256(:,:,29), nhel, den(83))
    call cont_VV(nsync, wf8(:,16), wf32(:,8), A(:,30), n3(:,146), t3x256(:,:,30), nhel, den(85))
    call cont_VV(nsync, wf8(:,16), wf32(:,9), A(:,31), n3(:,147), t3x256(:,:,31), nhel, den(87))
    call cont_VV(nsync, wf8(:,16), wf32(:,10), A(:,32), n3(:,148), t3x256(:,:,32), nhel, den(89))
    call cont_SS(nsync, wf16(:,1), wf16(:,28), A(:,33), n3(:,149), t3x256(:,:,33), nhel, den(90))
    call cont_VV(nsync, wf16(:,3), wf16(:,29), A(:,34), n3(:,150), t3x256(:,:,34), nhel, den(91))
    call cont_VV(nsync, wf16(:,6), wf16(:,30), A(:,35), n3(:,151), t3x256(:,:,35), nhel, den(92))
    call cont_VV(nsync, wf8(:,21), wf32(:,11), A(:,36), n3(:,152), t3x256(:,:,36), nhel, den(94))
    call cont_VV(nsync, wf8(:,21), wf32(:,12), A(:,37), n3(:,153), t3x256(:,:,37), nhel, den(97))
    call cont_VV(nsync, wf8(:,21), wf32(:,13), A(:,38), n3(:,154), t3x256(:,:,38), nhel, den(99))
    call cont_VV(nsync, wf8(:,21), wf32(:,14), A(:,39), n3(:,155), t3x256(:,:,39), nhel, den(101))
    call cont_QA(nsync, wf16(:,9), wf16(:,31), A(:,40), n3(:,156), t3x256(:,:,40), nhel, den(102))
    call cont_QA(nsync, wf32(:,3), wf8(:,24), A(:,41), n3(:,157), t3x256(:,:,41), nhel, den(104))
    call cont_VV(nsync, wf8(:,16), wf32(:,15), A(:,42), n3(:,158), t3x256(:,:,42), nhel, den(106))
    call cont_VV(nsync, wf8(:,16), wf32(:,16), A(:,43), n3(:,159), t3x256(:,:,43), nhel, den(108))
    call cont_VV(nsync, wf8(:,16), wf32(:,17), A(:,44), n3(:,160), t3x256(:,:,44), nhel, den(110))
    call cont_QA(nsync, wf16(:,9), wf16(:,32), A(:,45), n3(:,161), t3x256(:,:,45), nhel, den(111))
    call cont_SS(nsync, wf16(:,1), wf16(:,33), A(:,46), n3(:,162), t3x256(:,:,46), nhel, den(112))
    call cont_VV(nsync, wf16(:,3), wf16(:,34), A(:,47), n3(:,163), t3x256(:,:,47), nhel, den(113))
    call cont_VV(nsync, wf16(:,6), wf16(:,35), A(:,48), n3(:,164), t3x256(:,:,48), nhel, den(114))
    call cont_QA(nsync, wf16(:,11), wf16(:,36), A(:,49), n3(:,165), t3x256(:,:,49), nhel, den(116))
    call cont_QA(nsync, wf16(:,21), wf16(:,37), A(:,50), n3(:,166), t3x256(:,:,50), nhel, den(118))
    call cont_QA(nsync, wf16(:,11), wf16(:,38), A(:,51), n3(:,167), t3x256(:,:,51), nhel, den(120))
    call cont_QA(nsync, wf16(:,21), wf16(:,39), A(:,52), n3(:,168), t3x256(:,:,52), nhel, den(122))
    call cont_VV(nsync, wf8(:,1), wf32(:,18), A(:,53), n3(:,169), t3x256(:,:,53), nhel, den(127))
    call cont_VV(nsync, wf8(:,3), wf32(:,19), A(:,54), n3(:,170), t3x256(:,:,54), nhel, den(128))
    call cont_QA(nsync, wf8(:,9), wf32(:,20), A(:,55), n3(:,171), t3x256(:,:,55), nhel, den(131))
    call cont_SS(nsync, wf8(:,19), wf32(:,21), A(:,56), n3(:,172), t3x256(:,:,56), nhel, den(133))
    call cont_VV(nsync, wf8(:,1), wf32(:,22), A(:,57), n3(:,173), t3x256(:,:,57), nhel, den(134))
    call cont_VV(nsync, wf8(:,3), wf32(:,22), A(:,58), n3(:,174), t3x256(:,:,58), nhel, den(135))
    call cont_QA(nsync, wf16(:,41), wf16(:,42), A(:,59), n3(:,175), t3x256(:,:,59), nhel, den(139))
    call cont_VV(nsync, wf8(:,4), wf32(:,18), A(:,60), n3(:,176), t3x256(:,:,60), nhel, den(140))
    call cont_VV(nsync, wf8(:,6), wf32(:,19), A(:,61), n3(:,177), t3x256(:,:,61), nhel, den(141))
    call cont_QA(nsync, wf16(:,9), wf16(:,43), A(:,62), n3(:,178), t3x256(:,:,62), nhel, den(142))
    call cont_SS(nsync, wf8(:,22), wf32(:,21), A(:,63), n3(:,179), t3x256(:,:,63), nhel, den(143))
    call cont_VV(nsync, wf8(:,4), wf32(:,22), A(:,64), n3(:,180), t3x256(:,:,64), nhel, den(144))
    call cont_VV(nsync, wf8(:,6), wf32(:,22), A(:,65), n3(:,181), t3x256(:,:,65), nhel, den(145))
    call cont_QA(nsync, wf16(:,41), wf16(:,44), A(:,66), n3(:,182), t3x256(:,:,66), nhel, den(146))
    call cont_QA(nsync, wf16(:,11), wf16(:,45), A(:,67), n3(:,183), t3x256(:,:,67), nhel, den(148))
    call cont_VV(nsync, wf16(:,4), wf16(:,46), A(:,68), n3(:,184), t3x256(:,:,68), nhel, den(151))
    call cont_VV(nsync, wf16(:,47), wf16(:,48), A(:,69), n3(:,185), t3x256(:,:,69), nhel, den(154))
    call cont_VV(nsync, wf16(:,47), wf16(:,49), A(:,70), n3(:,186), t3x256(:,:,70), nhel, den(157))
    call cont_VV(nsync, wf16(:,13), wf16(:,46), A(:,71), n3(:,187), t3x256(:,:,71), nhel, den(159))
    call cont_VV(nsync, wf16(:,14), wf16(:,50), A(:,72), n3(:,188), t3x256(:,:,72), nhel, den(161))
    call cont_VV(nsync, wf16(:,14), wf16(:,51), A(:,73), n3(:,189), t3x256(:,:,73), nhel, den(163))
    call cont_VV(nsync, wf16(:,16), wf16(:,46), A(:,74), n3(:,190), t3x256(:,:,74), nhel, den(165))
    call cont_VV(nsync, wf16(:,48), wf16(:,52), A(:,75), n3(:,191), t3x256(:,:,75), nhel, den(167))
    call cont_VV(nsync, wf16(:,49), wf16(:,52), A(:,76), n3(:,192), t3x256(:,:,76), nhel, den(168))
    call cont_VV(nsync, wf16(:,23), wf16(:,46), A(:,77), n3(:,193), t3x256(:,:,77), nhel, den(169))
    call cont_VV(nsync, wf16(:,24), wf16(:,50), A(:,78), n3(:,194), t3x256(:,:,78), nhel, den(170))
    call cont_VV(nsync, wf16(:,24), wf16(:,51), A(:,79), n3(:,195), t3x256(:,:,79), nhel, den(171))
    call cont_VV(nsync, wf16(:,29), wf16(:,46), A(:,80), n3(:,196), t3x256(:,:,80), nhel, den(172))
    call cont_VV(nsync, wf16(:,30), wf16(:,50), A(:,81), n3(:,197), t3x256(:,:,81), nhel, den(173))
    call cont_QA(nsync, wf16(:,54), wf16(:,55), A(:,82), n3(:,198), t3x256(:,:,82), nhel, den(176))
    call cont_QA(nsync, wf16(:,54), wf16(:,57), A(:,83), n3(:,199), t3x256(:,:,83), nhel, den(178))
    call cont_VV(nsync, wf16(:,30), wf16(:,51), A(:,84), n3(:,200), t3x256(:,:,84), nhel, den(179))
    call cont_QA(nsync, wf16(:,58), wf16(:,59), A(:,85), n3(:,201), t3x256(:,:,85), nhel, den(182))
    call cont_QA(nsync, wf16(:,53), wf16(:,61), A(:,86), n3(:,202), t3x256(:,:,86), nhel, den(185))
    call cont_QA(nsync, wf16(:,56), wf16(:,61), A(:,87), n3(:,203), t3x256(:,:,87), nhel, den(186))
    call cont_VV(nsync, wf16(:,34), wf16(:,46), A(:,88), n3(:,204), t3x256(:,:,88), nhel, den(187))
    call cont_VV(nsync, wf16(:,35), wf16(:,50), A(:,89), n3(:,205), t3x256(:,:,89), nhel, den(188))
    call cont_QA(nsync, wf16(:,54), wf16(:,63), A(:,90), n3(:,206), t3x256(:,:,90), nhel, den(190))
    call cont_QA(nsync, wf16(:,54), wf16(:,65), A(:,91), n3(:,207), t3x256(:,:,91), nhel, den(192))
    call cont_VV(nsync, wf16(:,35), wf16(:,51), A(:,92), n3(:,208), t3x256(:,:,92), nhel, den(193))
    call cont_QA(nsync, wf16(:,58), wf16(:,66), A(:,93), n3(:,209), t3x256(:,:,93), nhel, den(195))
    call cont_QA(nsync, wf16(:,61), wf16(:,62), A(:,94), n3(:,210), t3x256(:,:,94), nhel, den(196))
    call cont_QA(nsync, wf16(:,61), wf16(:,64), A(:,95), n3(:,211), t3x256(:,:,95), nhel, den(197))
    call cont_VV(nsync, wf8(:,1), wf32(:,23), A(:,96), n3(:,212), t3x256(:,:,96), nhel, den(202))
    call cont_VV(nsync, wf8(:,3), wf32(:,24), A(:,97), n3(:,213), t3x256(:,:,97), nhel, den(203))
    call cont_QA(nsync, wf16(:,25), wf16(:,67), A(:,98), n3(:,214), t3x256(:,:,98), nhel, den(205))
    call cont_SS(nsync, wf8(:,19), wf32(:,25), A(:,99), n3(:,215), t3x256(:,:,99), nhel, den(207))
    call cont_VV(nsync, wf8(:,1), wf32(:,26), A(:,100), n3(:,216), t3x256(:,:,100), nhel, den(208))
    call cont_VV(nsync, wf8(:,3), wf32(:,26), A(:,101), n3(:,217), t3x256(:,:,101), nhel, den(209))
    call cont_QA(nsync, wf16(:,69), wf16(:,70), A(:,102), n3(:,218), t3x256(:,:,102), nhel, den(213))
    call cont_VV(nsync, wf8(:,4), wf32(:,23), A(:,103), n3(:,219), t3x256(:,:,103), nhel, den(214))
    call cont_VV(nsync, wf8(:,6), wf32(:,24), A(:,104), n3(:,220), t3x256(:,:,104), nhel, den(215))
    call cont_QA(nsync, wf4(:,8), wf64(:,1), A(:,105), n3(:,221), t3x256(:,:,105), nhel, den(217))
    call cont_SS(nsync, wf8(:,22), wf32(:,25), A(:,106), n3(:,222), t3x256(:,:,106), nhel, den(218))
    call cont_VV(nsync, wf8(:,4), wf32(:,26), A(:,107), n3(:,223), t3x256(:,:,107), nhel, den(219))
    call cont_VV(nsync, wf8(:,6), wf32(:,26), A(:,108), n3(:,224), t3x256(:,:,108), nhel, den(220))
    call cont_QA(nsync, wf16(:,69), wf16(:,71), A(:,109), n3(:,225), t3x256(:,:,109), nhel, den(221))
    call cont_QA(nsync, wf16(:,21), wf16(:,72), A(:,110), n3(:,226), t3x256(:,:,110), nhel, den(223))
    call cont_VV(nsync, wf16(:,4), wf16(:,73), A(:,111), n3(:,227), t3x256(:,:,111), nhel, den(224))
    call cont_VV(nsync, wf16(:,47), wf16(:,74), A(:,112), n3(:,228), t3x256(:,:,112), nhel, den(225))
    call cont_VV(nsync, wf16(:,47), wf16(:,75), A(:,113), n3(:,229), t3x256(:,:,113), nhel, den(228))
    call cont_VV(nsync, wf16(:,13), wf16(:,73), A(:,114), n3(:,230), t3x256(:,:,114), nhel, den(230))
    call cont_VV(nsync, wf16(:,14), wf16(:,76), A(:,115), n3(:,231), t3x256(:,:,115), nhel, den(232))
    call cont_VV(nsync, wf16(:,14), wf16(:,77), A(:,116), n3(:,232), t3x256(:,:,116), nhel, den(234))
    call cont_VV(nsync, wf16(:,16), wf16(:,73), A(:,117), n3(:,233), t3x256(:,:,117), nhel, den(235))
    call cont_VV(nsync, wf16(:,52), wf16(:,74), A(:,118), n3(:,234), t3x256(:,:,118), nhel, den(236))
    call cont_VV(nsync, wf16(:,52), wf16(:,75), A(:,119), n3(:,235), t3x256(:,:,119), nhel, den(237))
    call cont_VV(nsync, wf16(:,23), wf16(:,73), A(:,120), n3(:,236), t3x256(:,:,120), nhel, den(238))
    call cont_VV(nsync, wf16(:,24), wf16(:,76), A(:,121), n3(:,237), t3x256(:,:,121), nhel, den(239))
    call cont_VV(nsync, wf16(:,24), wf16(:,77), A(:,122), n3(:,238), t3x256(:,:,122), nhel, den(240))
    call cont_VV(nsync, wf16(:,29), wf16(:,73), A(:,123), n3(:,239), t3x256(:,:,123), nhel, den(241))
    call cont_VV(nsync, wf16(:,30), wf16(:,76), A(:,124), n3(:,240), t3x256(:,:,124), nhel, den(242))
    call cont_QA(nsync, wf16(:,79), wf16(:,80), A(:,125), n3(:,241), t3x256(:,:,125), nhel, den(245))
    call cont_QA(nsync, wf16(:,79), wf16(:,82), A(:,126), n3(:,242), t3x256(:,:,126), nhel, den(247))
    call cont_VV(nsync, wf16(:,30), wf16(:,77), A(:,127), n3(:,243), t3x256(:,:,127), nhel, den(248))
    call cont_QA(nsync, wf16(:,83), wf16(:,84), A(:,128), n3(:,244), t3x256(:,:,128), nhel, den(251))
    call cont_QA(nsync, wf16(:,78), wf16(:,86), A(:,129), n3(:,245), t3x256(:,:,129), nhel, den(254))
    call cont_QA(nsync, wf16(:,81), wf16(:,86), A(:,130), n3(:,246), t3x256(:,:,130), nhel, den(255))
    call cont_VV(nsync, wf16(:,34), wf16(:,73), A(:,131), n3(:,247), t3x256(:,:,131), nhel, den(256))
    call cont_VV(nsync, wf16(:,35), wf16(:,76), A(:,132), n3(:,248), t3x256(:,:,132), nhel, den(257))
    call cont_QA(nsync, wf16(:,79), wf16(:,88), A(:,133), n3(:,249), t3x256(:,:,133), nhel, den(259))
    call cont_QA(nsync, wf16(:,79), wf16(:,90), A(:,134), n3(:,250), t3x256(:,:,134), nhel, den(261))
    call cont_VV(nsync, wf16(:,35), wf16(:,77), A(:,135), n3(:,251), t3x256(:,:,135), nhel, den(262))
    call cont_QA(nsync, wf16(:,83), wf16(:,91), A(:,136), n3(:,252), t3x256(:,:,136), nhel, den(264))
    call cont_QA(nsync, wf16(:,86), wf16(:,87), A(:,137), n3(:,253), t3x256(:,:,137), nhel, den(265))
    call cont_QA(nsync, wf16(:,86), wf16(:,89), A(:,138), n3(:,254), t3x256(:,:,138), nhel, den(266))
    call cont_QA(nsync, wf16(:,53), wf16(:,93), A(:,139), n3(:,255), t3x256(:,:,139), nhel, den(268))
    call cont_QA(nsync, wf16(:,56), wf16(:,93), A(:,140), n3(:,256), t3x256(:,:,140), nhel, den(269))
    call cont_QA(nsync, wf16(:,59), wf16(:,94), A(:,141), n3(:,257), t3x256(:,:,141), nhel, den(270))
    call cont_QA(nsync, wf16(:,62), wf16(:,93), A(:,142), n3(:,258), t3x256(:,:,142), nhel, den(271))
    call cont_QA(nsync, wf16(:,64), wf16(:,93), A(:,143), n3(:,259), t3x256(:,:,143), nhel, den(272))
    call cont_QA(nsync, wf16(:,66), wf16(:,94), A(:,144), n3(:,260), t3x256(:,:,144), nhel, den(273))
    call cont_QA(nsync, wf16(:,78), wf16(:,96), A(:,145), n3(:,261), t3x256(:,:,145), nhel, den(275))
    call cont_QA(nsync, wf16(:,81), wf16(:,96), A(:,146), n3(:,262), t3x256(:,:,146), nhel, den(276))
    call cont_QA(nsync, wf16(:,84), wf16(:,97), A(:,147), n3(:,263), t3x256(:,:,147), nhel, den(277))
    call cont_QA(nsync, wf16(:,87), wf16(:,96), A(:,148), n3(:,264), t3x256(:,:,148), nhel, den(278))
    call cont_QA(nsync, wf16(:,89), wf16(:,96), A(:,149), n3(:,265), t3x256(:,:,149), nhel, den(279))
    call cont_QA(nsync, wf16(:,91), wf16(:,97), A(:,150), n3(:,266), t3x256(:,:,150), nhel, den(280))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvector(A, j, M1)
  implicit none
  type(polcont) :: A(:,:)
  integer, intent(in) :: j
  complex(REALKIND), intent(out) :: M1(1) ! M1helarray(1,256)
  integer :: empty(0)

  M1(1) = (-A(j,8)%j-A(j,9)%j-A(j,10)%j-A(j,17)%j-A(j,18)%j-A(j,19)%j-A(j,24)%j-A(j,41)%j)*f(1)+(A(j,25)%j+A(j,40)%j+A(j,49)%j &
       +A(j,50)%j)*f(2)+(A(j,23)%j+A(j,29)%j+A(j,36)%j+A(j,45)%j+A(j,51)%j+A(j,52)%j-A(j,55)%j-A(j,62)%j-A(j,67)%j-A(j,98)%j &
       -A(j,105)%j-A(j,110)%j)*f(3)+(A(j,5)%j+A(j,11)%j+A(j,14)%j+A(j,20)%j+A(j,33)%j+A(j,46)%j)*f(4)+(-A(j,26)%j-A(j,30)%j &
       -A(j,37)%j-A(j,42)%j+A(j,56)%j+A(j,63)%j+A(j,99)%j+A(j,106)%j)*f(5)+(-A(j,7)%j-A(j,13)%j-A(j,16)%j-A(j,22)%j-A(j,35)%j &
       -A(j,48)%j)*f(6)+(-A(j,2)%j-A(j,4)%j+A(j,28)%j+A(j,32)%j+A(j,39)%j+A(j,44)%j-A(j,58)%j-A(j,65)%j-A(j,101)%j &
       -A(j,108)%j)*f(7)+(A(j,6)%j+A(j,12)%j+A(j,15)%j+A(j,21)%j+A(j,34)%j+A(j,47)%j-A(j,68)%j-A(j,71)%j-A(j,74)%j-A(j,77)%j &
       -A(j,80)%j-A(j,88)%j-A(j,111)%j-A(j,114)%j-A(j,117)%j-A(j,120)%j-A(j,123)%j-A(j,131)%j)*f(8)+(A(j,1)%j+A(j,3)%j-A(j,27)%j &
       -A(j,31)%j-A(j,38)%j-A(j,43)%j-A(j,53)%j+A(j,57)%j-A(j,60)%j+A(j,64)%j-A(j,69)%j-A(j,70)%j-A(j,72)%j-A(j,73)%j-A(j,75)%j &
       -A(j,76)%j-A(j,78)%j-A(j,79)%j-A(j,81)%j-A(j,82)%j-A(j,84)%j+A(j,86)%j-A(j,89)%j-A(j,90)%j-A(j,92)%j+A(j,94)%j-A(j,96)%j &
       +A(j,100)%j-A(j,103)%j+A(j,107)%j-A(j,112)%j-A(j,113)%j-A(j,115)%j-A(j,116)%j-A(j,118)%j-A(j,119)%j-A(j,121)%j-A(j,122)%j &
       -A(j,124)%j-A(j,125)%j-A(j,127)%j+A(j,129)%j-A(j,132)%j-A(j,133)%j-A(j,135)%j+A(j,137)%j-A(j,139)%j-A(j,142)%j-A(j,145)%j &
       -A(j,148)%j)*f(9)+(-A(j,54)%j-A(j,59)%j-A(j,61)%j-A(j,66)%j-A(j,83)%j+A(j,85)%j+A(j,87)%j-A(j,91)%j+A(j,93)%j+A(j,95)%j &
       -A(j,97)%j-A(j,102)%j-A(j,104)%j-A(j,109)%j-A(j,126)%j+A(j,128)%j+A(j,130)%j-A(j,134)%j+A(j,136)%j+A(j,138)%j-A(j,140)%j &
       -A(j,141)%j-A(j,143)%j-A(j,144)%j-A(j,146)%j-A(j,147)%j-A(j,149)%j-A(j,150)%j)*f(10)

end subroutine colourvector


! **********************************************************************
subroutine colint(M, M2colint, extcombs)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! M2colint is an array which contains the colour interference for each colour matrix
! The elements of the array extcombs specifies for which external particle
! combinations the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
! i=j=0 -> 0 means no colour insertion.
! **********************************************************************
  use ol_colourmatrix_pplllla_nexnmemxbbxag_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint(0:38-1)
  integer,           intent(in)  :: extcombs(:)
  integer :: extcomb, colmatpos, i, j, eco

  M2colint = 0

  do eco = 1, size(extcombs)
    extcomb = extcombs(eco)
    colmatpos = 1*extcomb
    do i = 1, 1
      do j = 1, 1
        M2colint(extcomb) = M2colint(extcomb) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint


! **********************************************************************
subroutine colint2(M1, M2, M2colint, extcombs)
! M1(i)   = <M1|Ci> colour component of matrix element
! M2(i)   = <M2|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! M2colint is an array which contains the colour interference for each colour matrix
! The elements of the array extcombs specifies for which external particle
! combinations the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
! i=j=0 -> 0 means no colour insertion.
! **********************************************************************
  use ol_colourmatrix_pplllla_nexnmemxbbxag_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M1(1), M2(1)
  real(REALKIND),    intent(out) :: M2colint(0:38-1)
  integer,           intent(in)  :: extcombs(:)
  integer :: extcomb, colmatpos, i, j, eco

  M2colint = 0

  do eco = 1, size(extcombs)
    extcomb = extcombs(eco)
    colmatpos = 1*extcomb
    do i = 1, 1
      do j = 1, 1
        M2colint(extcomb) = M2colint(extcomb) + real(conjg(M1(i))*K1(i+colmatpos,j)*M2(j))
      end do
    end do
  end do

end subroutine colint2


! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pplllla_nexnmemxbbxag_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K1(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu

end subroutine amp2


#ifdef PRECISION_dp
subroutine colourvector(M1out, nhelout) &
  & bind(c,name="ol_tree_colvect_pplllla_nexnmemxbbxag_1")
  ! Retrieve M1helarr from cache. Cache must have been filled before by calling amp2().
  ! [out] M1out(:,h): colour vector for each helicity configuration h
  ! [out] nhelout: number of non-vanishing helicity configurations
  implicit none
  complex(DREALKIND) :: M1out(1,256)
  integer, intent(out) :: nhelout
  M1out = M1helarr
  nhelout = nhel
end subroutine colourvector
#endif


! =================================================== !
! Only interfaces for easier usage of AMP2_<procname> !
! =================================================== !

#ifdef PRECISION_dp
subroutine amp2tree(P, M2) &
    & bind(c,name="ol_f_amp2tree_pplllla_nexnmemxbbxag_1")
#else
subroutine amp2tree(P, M2)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix element without fuss.
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,8)
  real(REALKIND),  intent(out) :: M2
  real(REALKIND) :: M2tmp(0:38-1)
  real(REALKIND) :: M2munu(4,4)
  call amp2(P, M2tmp, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], 1, [ 0 ], M2munu)
  M2 = M2tmp(0)
end subroutine amp2tree


#ifdef PRECISION_dp
subroutine amp2ccone(P, M2, I, J) &
    & bind(c,name="ol_f_amp2ccone_pplllla_nexnmemxbbxag_1")
#else
subroutine amp2ccone(P, M2, I, J)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix for the colour correlation matrix for particles I and J.
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,8)
  real(REALKIND),  intent(out) :: M2
  integer,         intent(in)  :: I, J
  integer        :: extcomb
  real(REALKIND) :: M2tmp(0:38-1)
  real(REALKIND) :: M2munu(4,4)
  if (J <= I) then
    extcomb = I*(I-1)/2 + J
  else
    extcomb = J*(J-1)/2 + I
  end if
  call amp2(P, M2tmp, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], 1, [ extcomb ], M2munu)
  M2 = M2tmp(extcomb)
end subroutine amp2ccone


#ifdef PRECISION_dp
subroutine amp2ccall(P, M2) &
    & bind(c,name="ol_f_amp2ccall_pplllla_nexnmemxbbxag_1")
#else
subroutine amp2ccall(P, M2)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix for all colour correlation matrices.
  ! The correlation between particles i and j is at position i*(i-1)/2+j of the array M2.
  ! M2(0) is AMP2tree
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,8)
  real(REALKIND),  intent(out) :: M2(0:38-1)
  real(REALKIND) :: M2munu(4,4)
  integer :: k
  call amp2(P, M2, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], &
    38, [ (k, k = 0, 38-1) ], M2munu)
end subroutine amp2ccall


#ifdef PRECISION_dp
subroutine amp2hcone(P, M2, I, J, MOM) &
    & bind(c,name="ol_f_amp2hcone_pplllla_nexnmemxbbxag_1")
#else
subroutine amp2hcone(P, M2, I, J, MOM)
#endif
  ! This is an interface for AMP2.
  ! Calculates the helicity correlation for emitter I with momentum MOM and spectator J
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,8)
  real(REALKIND),  intent(out) :: M2
  integer,         intent(in)  :: I, J
  real(REALKIND),  intent(in)  :: MOM(0:3)
  integer        :: extcomb
  real(REALKIND) :: M2tmp(0:38-1)
  real(REALKIND) :: M2munu(4,4)
  if (J <= I) then
    extcomb = I*(I-1)/2 + J
  else
    extcomb = J*(J-1)/2 + I
  end if
  call amp2(P, M2tmp, I, MOM, 1, [ extcomb ], M2munu)
  M2 = M2tmp(extcomb)
end subroutine amp2hcone


#ifdef PRECISION_dp
subroutine amp2hcall(P, M2, I, MOM) &
    & bind(c,name="ol_f_amp2hcall_pplllla_nexnmemxbbxag_1")
#else
subroutine amp2hcall(P, M2, I, MOM)
#endif
  ! This is an interface for AMP2.
  ! Calculates all helicity correlations for emitter I with momentum MOM.
  ! The correlator for spectator j is at position j of the array M2.
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,8)
  real(REALKIND),  intent(out) :: M2(8)
  integer,         intent(in)  :: I
  real(REALKIND),  intent(in)  :: MOM(0:3)
  real(REALKIND) :: M2tmp(0:38-1)
  real(REALKIND) :: M2munu(4,4)
  integer        :: J, extcombs(8)
  do J = 1, 8
    if (J <= I) then
      extcombs(J) = I*(I-1)/2 + J
    else
      extcombs(J) = J*(J-1)/2 + I
    end if
  end do
  call amp2(P, M2tmp, I, MOM, 8,extcombs, M2munu)
  do J = 1, 8
    M2(J) = M2tmp(extcombs(J))
  end do
end subroutine amp2hcall


#ifdef PRECISION_dp

subroutine amp2tree_c(p, m2) &
    & bind(c,name="ol_amp2tree_pplllla_nexnmemxbbxag_1")
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,8)
  real(c_double), intent(out) :: m2
  real(DREALKIND) :: f_p(0:3,8)
  real(DREALKIND) :: f_m2
  f_p = p
  call amp2tree(f_p, f_m2)
  m2 = f_m2
end subroutine amp2tree_c

subroutine amp2ccone_c(p, m2, i, j) &
    & bind(c,name="ol_amp2ccone_pplllla_nexnmemxbbxag_1")
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,8)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(DREALKIND) :: f_p(0:3,8)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  f_p = p
  f_i = i
  f_j = j
  call amp2ccone(f_p, f_m2, f_i, f_j)
  m2 = f_m2
end subroutine amp2ccone_c

subroutine amp2ccall_c(p, m2) &
    & bind(c,name="ol_amp2ccall_pplllla_nexnmemxbbxag_1")
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,8)
  real(c_double), intent(out) :: m2(0:38-1)
  real(DREALKIND) :: f_p(0:3,8)
  real(DREALKIND) :: f_m2(0:38-1)
  f_p = p
  call amp2ccall(f_p, f_m2)
  m2 = f_m2
end subroutine amp2ccall_c

subroutine amp2hcone_c(p, m2, i, j, mom) &
    & bind(c,name="ol_amp2hcone_pplllla_nexnmemxbbxag_1")
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,8)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,8)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_j = j
  f_mom = mom
  call amp2hcone(f_p, f_m2, f_i, f_j, f_mom)
  m2 = f_m2
end subroutine amp2hcone_c

subroutine amp2hcall_c(p, m2, i, mom) &
    & bind(c,name="ol_amp2hcall_pplllla_nexnmemxbbxag_1")
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,8)
  real(c_double), intent(out) :: m2(8)
  integer(c_int), intent(in) :: i
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,8)
  real(DREALKIND) :: f_m2(8)
  integer :: f_i
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_mom = mom
  call amp2hcall(f_p, f_m2, f_i, f_mom)
  m2 = f_m2
end subroutine amp2hcall_c

#endif

end module ol_tree_pplllla_nexnmemxbbxag_1_/**/REALKIND
